-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_302
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_302`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_302` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_302`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,4000,'',0,'22','1','302','PURCHASES','','2022-11-28 13:23:45',5,0.00,0.00,'','479','2022-11-28 13:23:45','479',0,0),(2,7000,'',0,'20','1','302','SALES','','2022-11-28 13:24:05',5,0.00,0.00,'','479','2022-11-28 13:24:05','479',0,0),(3,500,'',0,'6.1','1','302','CASH','','2022-11-28 13:24:19',5,0.00,0.00,'','479','2022-11-28 13:24:19','479',0,0),(4,8000,'',0,'24','1','302','SALARIES & WAGES','','2022-11-28 13:24:35',5,0.00,0.00,'','479','2022-11-28 13:24:35','479',0,0),(5,8001,'',0,'24','1','302','PURCHASES','','2022-11-28 13:24:52',5,0.00,0.00,'','479','2022-11-28 13:24:52','479',0,0),(6,2500,'',0,'2','1','302','ZB(LPG)1014471475','','2022-11-28 13:26:00',5,0.00,0.00,'','479','2022-11-28 13:26:00','479',0,0),(7,2501,'',0,'2','1','302','FID POS COLLECTION-5620141491','','2022-11-28 13:26:14',5,0.00,0.00,'','479','2022-11-28 13:26:14','479',0,0),(8,2502,'',0,'2','1','302','FB(IBAL)2023855223','','2022-11-28 13:27:14',5,0.00,0.00,'','479','2022-11-28 13:27:14','479',0,0),(9,2503,'',0,'2','1','302','ZNB E-BILL COLLECTION :1014717','','2022-11-28 13:27:59',5,0.00,0.00,'','479','2022-11-28 13:27:59','479',0,0),(10,2504,'',0,'2','1','302','E-BILLS 1015372548','','2022-11-28 13:34:35',5,0.00,0.00,'','479','2022-11-28 13:34:35','479',0,0),(11,2505,'',0,'2','1','302','E-BILLS  IBAL 1015372548','','2022-11-28 13:34:45',5,0.00,0.00,'','479','2022-11-28 13:34:45','479',0,0),(12,2506,'',0,'2','1','302','DANKANO-EBILLS:ZNB1014717618','','2022-11-28 13:37:20',5,0.00,0.00,'','479','2022-11-28 13:37:20','479',0,0),(13,2507,'',0,'2','1','302','UBA YOLA-1021398099','','2022-11-28 13:37:37',5,0.00,0.00,'','479','2022-11-28 13:37:37','479',0,0),(14,2508,'',0,'2','1','302','UBA-0039769388','','2022-11-28 13:37:51',5,0.00,0.00,'','479','2022-11-28 13:37:51','479',0,0),(15,2509,'',0,'2','1','302','UBA-1019882661','','2022-11-28 13:38:04',5,0.00,0.00,'','479','2022-11-28 13:38:04','479',0,0),(16,2510,'',0,'2','1','302','UNITY BANK-0024061656','','2022-11-28 13:38:14',5,0.00,0.00,'','479','2022-11-28 13:38:14','479',0,0),(17,2511,'',0,'2','1','302','TAJJ BANK CITY GATE:0001875361','','2022-11-28 13:38:29',5,0.00,0.00,'','479','2022-11-28 13:38:29','479',0,0),(18,2512,'',0,'2','1','302','POLARIS BANK KEBBI:4091417377','','2022-11-28 14:03:38',5,0.00,0.00,'','479','2022-11-28 14:03:38','479',0,0),(19,2513,'',0,'2','1','302','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:26:32',5,0.00,0.00,'','792','2023-02-20 14:26:32','792',0,0),(20,2514,'',0,'2','1','302','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:31:12',5,0.00,0.00,'2023-03-15','792','2023-03-17 12:37:03','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','1','302','RAHIM GAS','DORAYI','08080993683','rahimgas@gmail.com','KANO','KANO','DORAYI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-30 09:49:58',5,'995','2022-11-30 09:49:58','995'),(2,'','1','302','SAMINU GAS','KABUGA TUDUN YOLA','07030949648','saminugas@gmail.com','KANO','KANO','KABUGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-07 17:48:02',5,'995','2022-12-07 17:48:02','995'),(3,'','1','302','ALL DEALER','DORAYI','08120375333','rahimgas@gmail.com','KANO','KANO','DORAYI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-12 10:44:56',5,'995','2022-12-12 10:44:56','995'),(4,'','1','302','USMAN GAS','DORAYI','07069035447','usman2@.com','KANO','KANO','dorayi','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-16 10:00:29',5,'995','2022-12-16 10:00:29','995'),(5,'','1','302','MMH','DORAYI','08022140825','mmh@com','KANO','KANO','DORAYI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-16 11:05:52',5,'995','2022-12-16 11:05:52','995'),(6,'','1','302','USAMA GAS','USAMA GAS','07082881207','usamagas@gmil.com','KANO','KANO','KIRU LGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-19 17:41:43',5,'995','2022-12-19 17:41:43','995'),(7,'','1','302','ARMA TALLAFI GAS','ARMA','08066221467','armatallafi@gmail.com','KANO','KANO','TUDUN YOLA','Nigeria',1500.00,0.00,0.00,'0000-00-00','2022-12-30 20:58:05',5,'1018','2022-12-30 20:58:05','1018'),(8,'','1','302','MUHALLI GAS','MUHAMMAD','09160028118','muhalligas@gmail.com','KANO','KANO','YAMADAWA','Nigeria',1500.00,0.00,0.00,'0000-00-00','2022-12-30 21:02:10',5,'1018','2022-12-30 21:02:10','1018'),(9,'','1','302','MKD','MUHAMMAD','08109065050','mkd1@gmail.com','KANO','KANO','SHARADA ','Nigeria',1500.00,0.00,0.00,'0000-00-00','2022-12-30 21:06:49',5,'1018','2022-12-30 21:06:49','1018'),(10,'','1','302','MD GAS','MD KUNTAU','08084706079','md@gmail.com','KANO','KANO','KUNTAU LAYIN SANTANA','Nigeria',1500.00,0.00,0.00,'0000-00-00','2023-01-02 08:26:26',5,'1018','2023-01-02 08:26:26','1018'),(11,'','1','302','MAZA WAJE GAS','MUHAMMAD','07064324472','maza@gmail.com','KANO','KANO','GORON DUTSE','Nigeria',1500.00,0.00,0.00,'0000-00-00','2023-01-02 08:39:47',5,'1018','2023-01-02 08:39:47','1018'),(12,'','1','302','AU GULU GAS','UMAR SALISU','07033041443','augulu@gmail.com','KANO','KANO','SHARADA','Nigeria',1500.00,0.00,0.00,'0000-00-00','2023-01-02 08:42:20',5,'1018','2023-01-02 08:42:20','1018'),(13,'','1','302','TSC GAS','UMAR ','07065179499','tsc@gmail,com','KANO','KANO','YAMADAWA','Nigeria',1500.00,0.00,0.00,'0000-00-00','2023-01-02 17:26:19',5,'1018','2023-01-02 17:26:19','1018'),(14,'','1','302','GULU GAS','GULU','08086291803','gulu1@gmail,com','KANO','KANO','TAL-UDU','Nigeria',1500.00,0.00,0.00,'0000-00-00','2023-01-02 17:28:00',5,'1018','2023-01-02 17:28:00','1018'),(15,'','1','302','JIKAN TAJIRA GAS','GARBA MUHAMMAD ','08033228357','tajira@gmail.com','KANO','KANO','GWARZO','Nigeria',1500.00,0.00,0.00,'0000-00-00','2023-01-04 07:58:50',5,'1018','2023-01-04 07:58:50','1018'),(16,'','1','302','A. MALAM GAS','A. MALAM','08092135690','amalam@gmail.com','KANO','KANO','KABUGA KANO','Nigeria',1500.00,0.00,0.00,'0000-00-00','2023-01-08 14:30:52',5,'1018','2023-01-08 14:30:52','1018'),(17,'','1','302','MUSDAT SHEHU GAS','MUSDA SHEHU','09057805858','musdashehu@gmail.com','KANO','KANO','GADON KAYA','Nigeria',1500.00,0.00,0.00,'0000-00-00','2023-01-11 17:14:19',5,'1018','2023-01-11 17:14:19','1018'),(18,'','1','302','ZANGO GAS','UMAR ','08162473231','umar@gmail.com','KANO','KANO','GADON KAYA','Nigeria',1500.00,0.00,0.00,'0000-00-00','2023-01-11 17:16:27',5,'1018','2023-01-11 17:16:27','1018'),(19,'','1','302','KB GAS','KABIR ADAMU','08124011364','kb@yahoo.com','KANO','KANO','DORAYI SALANTA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-25 11:14:37',5,'1018','2023-01-25 11:14:37','1018'),(20,'','1','302','DG GAS','YUSUF ISA YUSUF','08039521636','dggas@yahoo.com','KANO','KANO','DORAYI','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-27 13:32:06',5,'1018','2023-01-27 13:32:06','1018'),(21,'','1','302','HAMDALA GAS','IMAMU WALI','08103350955','hamdala@gmail.com','KANO','KANO','DUKAWUYA,KANO.','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-02 18:23:11',5,'1018','2023-02-02 18:23:11','1018'),(22,'','1','302','HAJIYA BABBA GAS','BAZALLAHI HASSAN','08142430729','bazallah@gmail.com','KANO','KANO','KUNTAU LINK 9','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-02 18:26:22',5,'1018','2023-02-02 18:26:22','1018'),(23,'','1','302','ZAKSON GAS','ZAKARIYYA MUHAMMAD','07060705739','zaks@yahoo.com','KANO','KANO','KUNTAU LINK 12','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-02 18:28:37',5,'1018','2023-02-02 18:28:37','1018'),(24,'','1','302','HAMDALA GAS BEBEJI','TASIU NASIRU','08069581567','hamdala@gmail.com','KANO','KANO','BEBEJI LAY OUT','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-11 08:54:37',5,'1018','2023-02-11 08:54:37','1018'),(25,'','1','302','LAMIDO GAS','ISAH MUHD','07033199609','lamido@gmail','KANO','KANO','JANBULO','Nigeria',1.00,0.00,0.00,'0000-00-00','2023-02-11 10:52:20',5,'1018','2023-02-11 10:52:20','1018'),(26,'','1','302','OPERATIONAL LOST','00000000000','0000000000000','aarano@gmail.com','0000000','000000000','000000','Nigeria',1000.00,0.00,0.00,'0000-00-00','2023-03-12 14:52:34',5,'1018','2023-03-12 14:52:34','1018'),(27,'','1','302','SHAHEEDA INVESTMENT','MUSTAPHA RABIU','08035260665','sheeda@gmail.com','KANO','KANO','NO 23 NORTH WEST QUATERS','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-17 13:28:36',5,'1018','2023-03-17 13:28:36','1018'),(28,'','1','302','MARHABA GAS','NAJIB UBA HAMISU','09072117577','marhaba@gmail.com','KANO','KANO','DORAYI GAREJIN KAMILU','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-17 13:30:11',5,'1018','2023-03-17 13:30:11','1018');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','302','1',1,'5','LPG NOZZLE 1',15199.72,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','302','1',2,'5','LPG NOZZLE 2',78178.43,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=125 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','302',1,'DAILY SHIFT','2022-11-30','2022-11-30 09:33:37','2022-12-01 09:33:37','995',0.00,0.00,'995','2022-11-30 23:01:14','995','2022-11-30 23:01:33',10,0),('1','302',2,'DAILY SHIFT','2022-12-01','2022-12-01 07:14:15','2022-12-02 07:14:15','995',0.00,0.00,'995','2022-12-01 18:36:34','995','2022-12-01 18:37:23',10,0),('1','302',3,'DAILY SHIFT','2022-12-02','2022-12-02 07:18:25','2022-12-03 07:18:25','995',0.00,0.00,'995','2022-12-02 18:50:35','995','2022-12-02 18:50:55',10,0),('1','302',4,'DAILY SHIFT','2022-12-03','2022-12-03 07:13:11','2022-12-04 07:13:11','995',0.00,0.00,'995','2022-12-03 22:50:11','995','2022-12-03 22:50:33',10,0),('1','302',5,'DAILY SHIFT','2022-12-04','2022-12-04 07:16:44','2022-12-05 07:16:44','995',0.00,0.00,'995','2022-12-05 00:09:16','995','2022-12-05 00:09:32',10,0),('1','302',6,'DAILY SHIFT','2022-12-05','2022-12-05 07:23:18','2022-12-06 07:23:18','995',0.00,0.00,'995','2022-12-05 18:47:43','995','2022-12-05 18:48:06',10,0),('1','302',7,'DAILY SHIFT','2022-12-06','2022-12-06 07:17:12','2022-12-07 07:17:12','995',0.00,0.00,'995','2022-12-06 18:37:37','995','2022-12-06 18:39:52',10,0),('1','302',8,'DAILY SHIFT','2022-12-07','2022-12-07 08:31:10','2022-12-08 08:31:10','995',0.00,0.00,'995','2022-12-07 18:41:21','995','2022-12-07 18:41:43',10,0),('1','302',9,'DAILY SHIFT','2022-12-08','2022-12-08 07:20:36','2022-12-09 07:20:36','995',0.00,0.00,'995','2022-12-08 19:30:17','995','2022-12-08 19:30:32',10,0),('1','302',10,'DAILY SHIFT','2022-12-09','2022-12-09 07:14:07','2022-12-10 07:14:07','995',0.00,0.00,'995','2022-12-09 15:36:48','995','2022-12-09 15:37:04',10,0),('1','302',11,'DAILY SHIFT','2022-12-09','2022-12-09 17:16:33','2022-12-10 17:16:33','995',0.00,0.00,'995','2022-12-09 18:53:26','995','2022-12-09 18:53:48',10,0),('1','302',12,'DAILY SHIFT','2022-12-10','2022-12-10 07:15:16','2022-12-11 07:15:16','995',0.00,0.00,'995','2022-12-10 19:00:49','995','2022-12-10 19:01:16',10,0),('1','302',13,'DAILY SHIFT','2022-12-11','2022-12-11 07:55:29','2022-12-12 07:55:29','995',0.00,0.00,'995','2022-12-11 19:04:14','995','2022-12-11 19:05:01',10,0),('1','302',14,'DAILY SHIFT','2022-12-12','2022-12-12 07:09:34','2022-12-13 07:09:34','995',0.00,0.00,'995','2022-12-12 22:22:53','995','2022-12-12 22:23:25',10,0),('1','302',15,'DAILY SHIFT','2022-12-13','2022-12-13 07:00:41','2022-12-14 07:00:41','995',0.00,0.00,'995','2022-12-13 19:04:23','995','2022-12-13 19:04:37',10,0),('1','302',16,'DAILY SHIFT','2022-12-14','2022-12-14 07:10:49','2022-12-15 07:10:49','995',0.00,0.00,'995','2022-12-14 19:17:13','995','2022-12-14 19:17:31',10,0),('1','302',17,'DAILY SHIFT','2022-12-15','2022-12-15 07:01:40','2022-12-16 07:01:40','995',0.00,0.00,'995','2022-12-16 07:16:12','995','2022-12-16 07:16:38',10,0),('1','302',18,'DAILY SHIFT','2022-12-16','2022-12-16 07:17:17','2022-12-17 07:17:17','995',0.00,0.00,'995','2022-12-16 19:07:09','995','2022-12-16 19:07:52',10,0),('1','302',19,'DAILY SHIFT','2022-12-17','2022-12-17 07:02:59','2022-12-18 07:02:59','995',0.00,0.00,'995','2022-12-17 19:19:51','995','2022-12-17 19:20:35',10,0),('1','302',20,'DAILY SHIFT','2022-12-18','2022-12-18 07:14:30','2022-12-19 07:14:30','995',0.00,0.00,'995','2022-12-18 19:06:45','995','2022-12-18 19:07:04',10,0),('1','302',21,'DAILY SHIFT','2022-12-19','2022-12-19 07:07:10','2022-12-20 07:07:10','995',0.00,0.00,'995','2022-12-19 19:27:02','995','2022-12-19 19:29:11',10,0),('1','302',22,'DAILY SHIFT','2022-12-20','2022-12-20 07:06:47','2022-12-21 07:06:47','995',0.00,0.00,'995','2022-12-20 14:25:12','995','2022-12-20 14:25:37',10,0),('1','302',23,'DAILY SHIFT','2022-12-20','2022-12-20 16:17:23','2022-12-21 16:17:23','995',0.00,0.00,'995','2022-12-20 19:57:48','995','2022-12-20 19:58:09',10,0),('1','302',24,'DAILY SHIFT','2022-12-21','2022-12-21 06:59:38','2022-12-22 06:59:38','995',0.00,0.00,'995','2022-12-21 19:16:29','995','2022-12-21 19:16:48',10,0),('1','302',25,'DAILY SHIFT','2022-12-22','2022-12-22 07:12:15','2022-12-23 07:12:15','995',0.00,0.00,'995','2022-12-22 18:44:27','995','2022-12-22 18:44:46',10,0),('1','302',26,'DAILY SHIFT','2022-12-23','2022-12-23 07:18:24','2022-12-24 07:18:24','995',0.00,0.00,'1018','2022-12-23 18:49:39','1018','2022-12-23 18:50:28',10,0),('1','302',27,'DAILY SHIFT','2022-12-24','2022-12-24 07:14:39','2022-12-25 07:14:39','1018',0.00,0.00,'1018','2022-12-24 19:03:48','1018','2022-12-24 19:04:13',10,0),('1','302',28,'DAILY SHIFT','2022-12-25','2022-12-25 06:50:59','2022-12-26 06:50:59','1018',0.00,0.00,'1018','2022-12-25 19:10:32','1018','2022-12-25 19:10:52',10,0),('1','302',29,'DAILY SHIFT','2022-12-26','2022-12-26 07:02:50','2022-12-27 07:02:50','1018',0.00,0.00,'1018','2022-12-26 16:59:19','1018','2022-12-26 16:59:41',10,0),('1','302',30,'DAILY SHIFT','2022-12-26','2022-12-26 17:10:45','2022-12-27 17:10:45','1018',0.00,0.00,'1018','2022-12-26 18:38:18','1018','2022-12-26 18:38:38',10,0),('1','302',31,'DAILY SHIFT','2022-12-27','2022-12-27 07:08:57','2022-12-28 07:08:57','1018',0.00,0.00,'1018','2022-12-27 18:36:42','1018','2022-12-27 18:37:06',10,0),('1','302',32,'DAILY SHIFT','2022-12-28','2022-12-28 07:11:17','2022-12-29 07:11:17','1018',0.00,0.00,'1018','2022-12-28 18:35:40','1018','2022-12-28 18:36:15',10,0),('1','302',33,'DAILY SHIFT','2022-12-29','2022-12-29 07:17:49','2022-12-30 07:17:49','1018',0.00,0.00,'1018','2022-12-29 18:20:10','1018','2022-12-29 18:20:33',10,0),('1','302',34,'DAILY SHIFT','2022-12-30','2022-12-30 07:22:58','2022-12-31 07:22:58','1018',0.00,0.00,'1018','2022-12-30 18:46:35','1018','2022-12-30 18:47:02',10,0),('1','302',35,'DAILY SHIFT','2022-12-31','2022-12-31 10:42:18','2023-01-01 10:42:18','1018',0.00,0.00,'1018','2022-12-31 18:27:33','1018','2022-12-31 18:27:55',10,0),('1','302',36,'DAILY SHIFT','2023-01-01','2023-01-01 06:36:16','2023-01-02 06:36:16','1018',0.00,0.00,'1018','2023-01-01 19:42:34','1018','2023-01-01 19:43:00',10,0),('1','302',37,'DAILY SHIFT','2023-01-01','2023-01-01 19:52:43','2023-01-02 19:52:43','1018',0.00,0.00,'1018','2023-01-01 19:56:10','1018','2023-01-01 19:56:33',10,0),('1','302',38,'DAILY SHIFT','2023-01-02','2023-01-02 06:41:14','2023-01-03 06:41:14','1018',0.00,0.00,'1018','2023-01-02 19:17:53','1018','2023-01-02 19:18:18',10,0),('1','302',39,'DAILY SHIFT','2023-01-03','2023-01-03 07:24:51','2023-01-04 07:24:51','1018',0.00,0.00,'1018','2023-01-03 18:21:59','1018','2023-01-03 18:22:23',10,0),('1','302',40,'DAILY SHIFT','2023-01-04','2023-01-04 06:37:15','2023-01-05 06:37:15','1018',0.00,0.00,'1018','2023-01-05 06:26:17','1018','2023-01-05 06:33:15',10,0),('1','302',41,'DAILY SHIFT','2023-01-05','2023-01-05 06:35:04','2023-01-06 06:35:04','1018',0.00,0.00,'1018','2023-01-05 18:57:55','1018','2023-01-05 18:58:16',10,0),('1','302',42,'DAILY SHIFT','2023-01-06','2023-01-06 06:46:15','2023-01-07 06:46:15','1018',0.00,0.00,'1018','2023-01-06 18:49:24','1018','2023-01-06 18:49:45',10,0),('1','302',43,'DAILY SHIFT','2023-01-07','2023-01-07 06:44:39','2023-01-08 06:44:39','1018',0.00,0.00,'1018','2023-01-07 19:52:01','1018','2023-01-07 19:52:19',10,0),('1','302',44,'DAILY SHIFT','2023-01-08','2023-01-08 13:18:33','2023-01-09 13:18:33','1018',0.00,0.00,'1018','2023-01-08 20:52:15','1018','2023-01-08 20:52:36',10,0),('1','302',45,'DAILY SHIFT','2023-01-09','2023-01-09 06:32:28','2023-01-10 06:32:28','1018',0.00,0.00,'1018','2023-01-09 19:00:00','1018','2023-01-09 19:00:24',10,0),('1','302',46,'DAILY SHIFT','2023-01-10','2023-01-10 06:32:01','2023-01-11 06:32:01','1018',0.00,0.00,'1018','2023-01-10 19:07:30','1018','2023-01-10 19:07:51',10,0),('1','302',47,'DAILY SHIFT','2023-01-11','2023-01-11 06:31:00','2023-01-12 06:31:00','1018',0.00,0.00,'1018','2023-01-11 20:25:14','1018','2023-01-11 20:25:32',10,0),('1','302',48,'DAILY SHIFT','2023-01-12','2023-01-12 06:56:52','2023-01-13 06:56:52','1018',0.00,0.00,'1018','2023-01-12 18:46:06','1018','2023-01-12 18:46:25',10,0),('1','302',49,'DAILY SHIFT','2023-01-13','2023-01-13 07:28:42','2023-01-14 07:28:42','1018',0.00,0.00,'1018','2023-01-13 18:55:57','1018','2023-01-13 18:56:20',10,0),('1','302',50,'DAILY SHIFT','2023-01-14','2023-01-14 06:32:32','2023-01-15 06:32:32','1018',0.00,0.00,'1018','2023-01-14 20:16:33','1018','2023-01-14 20:16:56',10,0),('1','302',51,'DAILY SHIFT','2023-01-15','2023-01-15 06:32:58','2023-01-16 06:32:58','1018',0.00,0.00,'1018','2023-01-15 15:39:42','1018','2023-01-15 15:40:01',10,0),('1','302',52,'DAILY SHIFT','2023-01-15','2023-01-15 15:40:35','2023-01-16 15:40:35','1018',0.00,0.00,'1018','2023-01-15 20:52:44','1018','2023-01-15 20:53:15',10,0),('1','302',53,'DAILY SHIFT','2023-01-16','2023-01-16 06:25:48','2023-01-17 06:25:48','1018',0.00,0.00,'1018','2023-01-16 18:52:29','1018','2023-01-16 18:52:50',10,0),('1','302',54,'DAILY SHIFT','2023-01-17','2023-01-17 06:30:25','2023-01-18 06:30:25','1018',0.00,0.00,'1018','2023-01-17 19:08:25','1018','2023-01-17 19:08:45',10,0),('1','302',55,'DAILY SHIFT','2023-01-18','2023-01-18 06:30:14','2023-01-19 06:30:14','1018',0.00,0.00,'1018','2023-01-18 16:38:04','1018','2023-01-18 16:38:30',10,0),('1','302',56,'DAILY SHIFT','2023-01-18','2023-01-18 16:49:41','2023-01-19 16:49:41','1018',0.00,0.00,'1018','2023-01-18 19:13:51','1018','2023-01-18 19:14:11',10,0),('1','302',57,'DAILY SHIFT','2023-01-19','2023-01-19 06:30:13','2023-01-20 06:30:13','1018',0.00,0.00,'1018','2023-01-19 19:03:26','1018','2023-01-19 19:03:57',10,0),('1','302',58,'DAILY SHIFT','2023-01-20','2023-01-20 06:34:21','2023-01-21 06:34:21','1018',0.00,0.00,'1018','2023-01-20 19:36:13','1018','2023-01-20 19:37:18',10,0),('1','302',59,'DAILY SHIFT','2023-01-21','2023-01-21 06:27:51','2023-01-22 06:27:51','1018',0.00,0.00,'1018','2023-01-21 21:07:20','1018','2023-01-21 21:07:54',10,0),('1','302',60,'DAILY SHIFT','2023-01-22','2023-01-22 06:34:22','2023-01-23 06:34:22','1018',0.00,0.00,'1018','2023-01-22 20:10:50','1018','2023-01-22 20:11:14',10,0),('1','302',61,'DAILY SHIFT','2023-01-23','2023-01-23 06:34:34','2023-01-24 06:34:34','1018',0.00,0.00,'1018','2023-01-23 21:18:51','1018','2023-01-23 21:19:53',10,0),('1','302',62,'DAILY SHIFT','2023-01-23','2023-01-23 22:07:58','2023-01-24 22:07:58','1018',0.00,0.00,'1018','2023-01-23 22:13:34','1018','2023-01-23 22:14:04',10,0),('1','302',63,'DAILY SHIFT','2023-01-24','2023-01-24 06:33:44','2023-01-25 06:33:44','1018',0.00,0.00,'1018','2023-01-24 19:03:59','1018','2023-01-24 19:04:20',10,0),('1','302',64,'DAILY SHIFT','2023-01-25','2023-01-25 06:37:53','2023-01-26 06:37:53','1018',0.00,0.00,'1018','2023-01-26 06:48:27','1018','2023-01-26 06:48:50',10,0),('1','302',65,'DAILY SHIFT','2023-01-26','2023-01-26 06:49:13','2023-01-27 06:49:13','1018',0.00,0.00,'1018','2023-01-26 21:32:21','1018','2023-01-26 21:33:23',10,0),('1','302',66,'DAILY SHIFT','2023-01-27','2023-01-27 07:02:30','2023-01-28 07:02:30','1018',0.00,0.00,'1018','2023-01-27 19:07:55','1018','2023-01-27 19:08:20',10,0),('1','302',67,'DAILY SHIFT','2023-01-28','2023-01-28 06:41:18','2023-01-29 06:41:18','1018',0.00,0.00,'1018','2023-01-28 22:32:32','1018','2023-01-28 22:33:02',10,0),('1','302',68,'DAILY SHIFT 2','2023-01-28','2023-01-28 22:34:33','2023-01-29 22:34:33','1018',0.00,0.00,'1018','2023-01-29 06:24:04','1018','2023-01-29 06:24:33',10,0),('1','302',69,'DAILY SHIFT','2023-01-29','2023-01-29 06:25:35','2023-01-30 06:25:35','1018',0.00,0.00,'1018','2023-01-29 20:19:32','1018','2023-01-29 20:19:55',10,0),('1','302',70,'DAILY SHIFT','2023-01-30','2023-01-30 06:32:56','2023-01-31 06:32:56','1018',0.00,0.00,'1018','2023-01-31 06:58:37','1018','2023-01-31 06:59:04',10,0),('1','302',71,'DAILY SHIFT 2','2023-01-31','2023-01-31 06:59:52','2023-02-01 06:59:52','1018',0.00,0.00,'1018','2023-01-31 08:32:22','1018','2023-01-31 08:32:54',10,0),('1','302',72,'DAILY SHIFT','2023-01-31','2023-01-31 08:33:29','2023-02-01 08:33:29','1018',0.00,0.00,'1018','2023-01-31 19:26:37','1018','2023-01-31 19:27:07',10,0),('1','302',73,'DAILY SHIFT ','2023-02-01','2023-02-01 06:55:51','2023-02-02 06:55:51','1018',0.00,0.00,'1018','2023-02-01 19:26:22','1018','2023-02-01 19:27:02',10,0),('1','302',74,'DAILY SHIFT','2023-02-02','2023-02-02 06:33:42','2023-02-03 06:33:42','1018',0.00,0.00,'1018','2023-02-02 19:45:01','1018','2023-02-02 19:45:34',10,0),('1','302',75,'DAILY SHIFT','2023-02-03','2023-02-03 06:38:00','2023-02-04 06:38:00','1018',0.00,0.00,'1018','2023-02-03 19:17:48','1018','2023-02-03 19:18:13',10,0),('1','302',76,'DAILY SHIFT','2023-02-04','2023-02-04 06:29:26','2023-02-05 06:29:26','1018',0.00,0.00,'1018','2023-02-04 19:24:54','1018','2023-02-04 19:25:28',10,0),('1','302',77,'DAILY SHIFT','2023-02-05','2023-02-05 06:31:31','2023-02-06 06:31:31','1018',0.00,0.00,'1018','2023-02-05 22:53:29','1018','2023-02-05 22:54:21',10,0),('1','302',78,'DAILY SHIFTS','2023-02-06','2023-02-06 06:18:08','2023-02-07 06:18:08','1018',0.00,0.00,'1018','2023-02-06 22:41:23','1018','2023-02-06 22:41:49',10,0),('1','302',79,'DAILY SHIFTS','2023-02-06','2023-02-06 22:48:00','2023-02-07 22:48:00','1018',0.00,0.00,'1018','2023-02-06 22:52:24','1018','2023-02-06 22:52:45',10,0),('1','302',80,'DAILY SHIFTS','2023-02-07','2023-02-07 07:43:34','2023-02-08 07:43:34','1018',0.00,0.00,'1018','2023-02-07 21:56:41','1018','2023-02-07 21:57:17',10,0),('1','302',81,'DAILY SHIFTS','2023-02-08','2023-02-08 07:04:53','2023-02-09 07:04:53','1018',0.00,0.00,'1018','2023-02-08 19:49:41','1018','2023-02-08 19:50:06',10,0),('1','302',82,'DAILY SHIFT','2023-02-09','2023-02-09 08:44:17','2023-02-10 08:44:17','1018',0.00,0.00,'1018','2023-02-09 19:20:23','1018','2023-02-09 19:21:23',10,0),('1','302',83,'DAILY SHIFT','2023-02-10','2023-02-10 07:44:37','2023-02-11 07:44:37','1018',0.00,0.00,'1018','2023-02-10 18:37:14','1018','2023-02-10 18:37:42',10,0),('1','302',84,'DAILY SHIFT','2023-02-11','2023-02-11 07:55:31','2023-02-12 07:55:31','1018',0.00,0.00,'1018','2023-02-11 19:57:42','1018','2023-02-11 20:00:19',10,0),('1','302',85,'DAILY SHIFT','2023-02-12','2023-02-12 08:31:52','2023-02-13 08:31:52','1018',0.00,0.00,'1018','2023-02-13 07:22:29','1018','2023-02-13 07:23:44',10,0),('1','302',86,'DAILY SHIFT','2023-02-13','2023-02-13 07:24:15','2023-02-14 07:24:15','1018',0.00,0.00,'1018','2023-02-13 19:09:25','1018','2023-02-13 19:13:30',10,0),('1','302',87,'DAILY SHIFT','2023-02-14','2023-02-14 07:27:33','2023-02-15 07:27:33','1018',0.00,0.00,'1018','2023-02-14 19:51:55','1018','2023-02-14 19:52:14',10,0),('1','302',88,'DAILY SHIFT','2023-02-15','2023-02-15 07:25:37','2023-02-16 07:25:37','1018',0.00,0.00,'1018','2023-02-15 17:24:49','1018','2023-02-15 17:25:14',10,0),('1','302',89,'DAILY SHIFT','2023-02-16','2023-02-16 07:34:12','2023-02-17 07:34:12','1018',0.00,0.00,'1018','2023-02-16 19:43:50','1018','2023-02-16 19:44:38',10,0),('1','302',90,'DAILY SHIFT','2023-02-17','2023-02-17 07:18:07','2023-02-18 07:18:07','1018',0.00,0.00,'1018','2023-02-17 19:34:29','1018','2023-02-17 19:34:55',10,0),('1','302',91,'DAILY SHIFT','2023-02-18','2023-02-18 07:41:34','2023-02-19 07:41:34','1018',0.00,0.00,'1018','2023-02-18 20:03:22','1018','2023-02-18 20:04:04',10,0),('1','302',92,'DAILY SHIFT','2023-02-19','2023-02-19 07:30:50','2023-02-20 07:30:50','1018',0.00,0.00,'1018','2023-02-19 19:31:13','1018','2023-02-19 19:31:34',10,0),('1','302',93,'DAILY SHIFT','2023-02-20','2023-02-20 07:40:17','2023-02-21 07:40:17','1018',0.00,0.00,'1018','2023-02-20 19:32:19','1018','2023-02-20 19:32:43',10,0),('1','302',94,'DAILY SHIFTS','2023-02-21','2023-02-21 07:31:30','2023-02-22 07:31:30','1018',0.00,0.00,'1018','2023-02-21 19:13:49','1018','2023-02-21 19:14:07',10,0),('1','302',95,'DAILY SHIFT','2023-02-22','2023-02-22 08:09:46','2023-02-23 08:09:46','1018',0.00,0.00,'1018','2023-02-22 19:50:01','1018','2023-02-22 19:50:39',10,0),('1','302',96,'DAILY SHIFT','2023-02-23','2023-02-23 07:10:50','2023-02-24 07:10:50','1018',0.00,0.00,'1018','2023-02-23 19:12:32','1018','2023-02-23 19:12:55',10,0),('1','302',97,'DAILY SHIFT','2023-02-24','2023-02-24 07:35:44','2023-02-25 07:35:44','1018',0.00,0.00,'1018','2023-02-24 19:37:15','1018','2023-02-24 19:37:42',10,0),('1','302',98,'DAILY SHIFT','2023-02-26','2023-02-26 09:00:07','2023-02-27 09:00:07','1018',0.00,0.00,'1018','2023-02-26 21:37:15','1018','2023-02-26 21:38:08',10,0),('1','302',99,'DAILY SHIFT','2023-02-27','2023-02-27 10:15:02','2023-02-28 10:15:02','1018',0.00,0.00,'1018','2023-02-27 22:57:53','1018','2023-02-27 22:58:23',10,0),('1','302',100,'DAILY SHIFT','2023-02-28','2023-02-28 08:26:44','2023-03-01 08:26:44','1018',0.00,0.00,'1018','2023-02-28 20:21:13','1018','2023-02-28 20:21:52',10,0),('1','302',101,'DAILY SHIFT','2023-03-01','2023-03-01 07:09:00','2023-03-02 07:09:00','1018',0.00,0.00,'1018','2023-03-01 19:19:10','1018','2023-03-01 19:19:36',10,0),('1','302',102,'DAILY SHIFT','2023-03-02','2023-03-02 07:33:04','2023-03-03 07:33:04','1018',0.00,0.00,'1018','2023-03-02 19:53:23','1018','2023-03-02 19:53:50',10,0),('1','302',103,'DAILY SHIFT','2023-03-03','2023-03-03 07:12:18','2023-03-04 07:12:18','1018',0.00,0.00,'1018','2023-03-03 19:30:17','1018','2023-03-03 19:30:36',10,0),('1','302',104,'DAILY SHIFT','2023-03-04','2023-03-04 08:27:46','2023-03-05 08:27:46','1018',0.00,0.00,'1018','2023-03-04 20:00:44','1018','2023-03-04 20:01:04',10,0),('1','302',105,'DAILY SHIFT','2023-03-05','2023-03-05 07:35:48','2023-03-06 07:35:48','1018',0.00,0.00,'1018','2023-03-05 20:05:14','1018','2023-03-05 20:05:38',10,0),('1','302',106,'DAILY SHIFT','2023-03-06','2023-03-06 07:23:18','2023-03-07 07:23:18','1018',0.00,0.00,'1018','2023-03-06 14:21:28','1018','2023-03-06 14:21:53',10,0),('1','302',107,'DAILY SHIFT','2023-03-06','2023-03-06 19:57:39','2023-03-07 19:57:39','1018',0.00,0.00,'1018','2023-03-06 20:02:03','1018','2023-03-06 20:02:25',10,0),('1','302',108,'DAILY SHIFT','2023-03-07','2023-03-07 08:05:36','2023-03-08 08:05:36','1018',0.00,0.00,'1018','2023-03-07 19:05:16','1018','2023-03-07 19:05:36',10,0),('1','302',109,'DAILY SHIFT','2023-03-08','2023-03-08 07:26:45','2023-03-09 07:26:45','1018',0.00,0.00,'1018','2023-03-08 20:34:46','1018','2023-03-08 22:36:46',10,0),('1','302',110,'DAILY SHIFT','2023-03-09','2023-03-09 09:03:41','2023-03-10 09:03:41','1018',0.00,0.00,'1018','2023-03-10 07:18:21','1018','2023-03-10 07:18:40',10,0),('1','302',111,'DAILY SHIFT','2023-03-10','2023-03-10 07:19:14','2023-03-11 07:19:14','1018',0.00,0.00,'1018','2023-03-10 18:32:12','1018','2023-03-10 18:32:36',10,0),('1','302',112,'DAILY SHIFT','2023-03-11','2023-03-11 07:12:53','2023-03-12 07:12:53','1018',0.00,0.00,'1018','2023-03-11 19:49:22','1018','2023-03-11 19:49:44',10,0),('1','302',113,'DAILY SHIFT','2023-03-12','2023-03-12 07:11:51','2023-03-13 07:11:51','1018',0.00,0.00,'1018','2023-03-12 14:28:54','1018','2023-03-12 14:29:20',10,0),('1','302',114,'DAILY SHIFT','2023-03-12','2023-03-12 14:38:43','2023-03-13 14:38:43','1018',0.00,0.00,'1018','2023-03-12 14:59:32','1018','2023-03-12 14:59:54',10,0),('1','302',115,'DAILY SHIFT','2023-03-12','2023-03-12 16:18:53','2023-03-13 16:18:53','1018',0.00,0.00,'1018','2023-03-12 19:28:04','1018','2023-03-12 19:28:28',10,0),('1','302',116,'DAILY SHIFT','2023-03-13','2023-03-13 06:24:15','2023-03-14 06:24:15','1018',0.00,0.00,'1018','2023-03-13 18:51:09','1018','2023-03-13 18:51:28',10,0),('1','302',117,'DAILY SHIFT','2023-03-14','2023-03-14 06:24:17','2023-03-15 06:24:17','1018',0.00,0.00,'1018','2023-03-14 19:45:15','1018','2023-03-14 19:45:43',10,0),('1','302',118,'DAILY SHIFT','2023-03-15','2023-03-15 06:29:06','2023-03-16 06:29:06','1018',0.00,0.00,'1018','2023-03-15 19:38:40','1018','2023-03-15 19:39:02',10,0),('1','302',119,'DAILY SHIFT','2023-03-16','2023-03-16 06:32:12','2023-03-17 06:32:12','1018',0.00,0.00,'1018','2023-03-16 19:32:07','1018','2023-03-16 19:32:33',10,0),('1','302',120,'DAILY SHIFT','2023-03-17','2023-03-17 06:32:33','2023-03-18 06:32:33','1018',0.00,0.00,'1018','2023-03-17 18:22:10','1018','2023-03-17 18:22:40',10,0),('1','302',121,'DAILY SHIFT','2023-03-19','2023-03-19 06:31:15','2023-03-20 06:31:15','1018',0.00,0.00,'1018','2023-03-19 11:14:03','1018','2023-03-19 11:14:35',10,0),('1','302',122,'DAILY SHIFT','2023-03-19','2023-03-19 11:16:18','2023-03-20 11:16:18','1018',0.00,0.00,'1018','2023-03-19 11:32:46','1018','2023-03-19 11:33:10',10,0),('1','302',123,'DAILY SHIFT','2023-03-19','2023-03-19 11:33:30','2023-03-20 11:33:30','1018',0.00,0.00,'1018','2023-03-19 15:31:01','1018','2023-03-19 15:31:28',10,0),('1','302',124,'DAILY SHIFT','2023-03-20','2023-03-20 06:40:30','2023-03-21 06:40:30','1018',0.00,0.00,'1018','2023-03-20 19:10:44','1018','2023-03-20 19:11:08',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=249 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','302','1','1',1,'1','1',0.00,461.17,0.00,0.00,461.17,341233.48,0.00,0.00,0.00),('1','302','1','1',2,'2','1',0.00,300.00,0.00,0.00,300.00,213000.00,0.00,0.00,0.00),('1','302','1','2',3,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','2',4,'2','1',300.00,623.34,0.00,0.00,323.34,235430.24,0.00,0.00,0.00),('1','302','1','3',5,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','3',6,'2','1',623.34,878.97,0.00,0.00,255.63,186843.68,0.00,0.00,0.00),('1','302','1','4',7,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','4',8,'2','1',878.97,1499.08,0.00,0.00,620.11,455100.96,0.00,0.00,0.00),('1','302','1','5',9,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','5',10,'2','1',1499.08,2065.75,0.00,0.00,566.67,413169.12,0.00,0.00,0.00),('1','302','1','6',11,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','6',12,'2','1',2065.75,2525.49,0.00,0.00,459.74,335846.64,0.00,0.00,0.00),('1','302','1','7',13,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','7',14,'2','1',2525.49,2775.65,0.00,0.00,250.16,184117.76,0.00,0.00,0.00),('1','302','1','8',15,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','8',16,'2','1',2775.65,3196.98,0.00,0.00,421.33,307108.88,0.00,0.00,0.00),('1','302','1','9',17,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','9',18,'2','1',3196.98,3736.77,0.00,0.00,539.79,395335.44,0.00,0.00,0.00),('1','302','1','10',19,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','10',20,'2','1',3736.77,4158.01,0.00,0.00,421.24,305482.64,0.00,0.00,0.00),('1','302','1','11',21,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','11',22,'2','1',4158.01,4287.08,0.00,0.00,129.07,94995.52,0.00,0.00,0.00),('1','302','1','12',23,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','12',24,'2','1',4287.08,4963.10,0.00,0.00,676.02,492428.72,0.00,0.00,0.00),('1','302','1','13',25,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','13',26,'2','1',4963.10,5566.63,0.00,0.00,603.53,436859.58,0.00,0.00,0.00),('1','302','1','14',27,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','14',28,'2','1',5566.63,5911.19,0.00,0.00,344.56,252296.16,0.00,0.00,0.00),('1','302','1','15',29,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','15',30,'2','1',5911.19,6185.03,0.00,0.00,273.84,200896.24,0.00,0.00,0.00),('1','302','1','16',31,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','16',32,'2','1',6185.03,6625.17,0.00,0.00,440.14,321980.04,0.00,0.00,0.00),('1','302','1','17',33,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','17',34,'2','1',6625.17,6935.57,0.00,0.00,310.40,227804.40,0.00,0.00,0.00),('1','302','1','18',35,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','18',36,'2','1',6935.57,7714.42,0.00,0.00,778.85,567357.60,0.00,0.00,0.00),('1','302','1','19',37,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','19',38,'2','1',7714.42,8121.18,0.00,0.00,406.76,298075.36,0.00,0.00,0.00),('1','302','1','20',39,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','20',40,'2','1',8121.18,8453.89,0.00,0.00,332.71,244197.00,0.00,0.00,0.00),('1','302','1','21',41,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','21',42,'2','1',8453.89,9303.48,0.00,0.00,849.59,616536.24,0.00,0.00,0.00),('1','302','1','22',43,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','22',44,'2','1',9303.48,9591.22,0.00,0.00,287.74,209644.12,0.00,0.00,0.00),('1','302','1','23',45,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','23',46,'2','1',9591.22,9958.70,0.00,0.00,367.48,265136.58,0.00,0.00,0.00),('1','302','1','24',47,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','24',48,'2','1',9958.70,10946.89,0.00,0.00,988.19,711057.84,0.00,0.00,0.00),('1','302','1','25',49,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','25',50,'2','1',10946.89,11523.03,0.00,0.00,576.14,416889.04,0.00,0.00,0.00),('1','302','1','26',51,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','26',52,'2','1',11523.03,11970.06,0.00,0.00,447.03,329014.08,0.00,0.00,0.00),('1','302','1','27',53,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','27',54,'2','1',11970.06,12541.34,0.00,0.00,571.28,417940.08,0.00,0.00,0.00),('1','302','1','28',55,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','28',56,'2','1',12541.34,14091.19,0.00,0.00,1549.85,1117614.60,0.00,0.00,0.00),('1','302','1','29',57,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','29',58,'2','1',14091.19,15089.34,0.00,0.00,998.15,719468.96,0.00,0.00,0.00),('1','302','1','30',59,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','30',60,'2','1',15089.34,15215.98,0.00,0.00,126.64,93207.04,0.00,0.00,0.00),('1','302','1','31',61,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','31',62,'2','1',15215.98,16218.06,0.00,0.00,1002.08,721865.88,0.00,0.00,0.00),('1','302','1','32',63,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','32',64,'2','1',16218.06,16768.31,0.00,0.00,550.25,399853.68,0.00,0.00,0.00),('1','302','1','33',65,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','33',66,'2','1',16768.31,17548.67,0.00,0.00,780.36,568780.96,0.00,0.00,0.00),('1','302','1','34',67,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','34',68,'2','1',17548.67,18792.99,0.00,0.00,1244.32,901788.36,0.00,0.00,0.00),('1','302','1','35',69,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','35',70,'2','1',18792.99,19965.21,0.00,0.00,1172.22,843369.10,0.00,0.00,0.00),('1','302','1','36',71,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','36',72,'2','1',19965.21,20657.62,0.00,0.00,692.41,503555.76,0.00,0.00,0.00),('1','302','1','37',73,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','37',74,'2','1',20657.62,21070.05,0.00,0.00,412.43,296057.10,0.00,0.00,0.00),('1','302','1','38',75,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','38',76,'2','1',21070.05,21853.10,0.00,0.00,783.05,569023.48,0.00,0.00,0.00),('1','302','1','39',77,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','39',78,'2','1',21853.10,22993.70,0.00,0.00,1140.60,828886.60,0.00,0.00,0.00),('1','302','1','40',79,'1','1',461.17,461.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','40',80,'2','1',22993.70,23769.26,0.00,0.00,775.56,561972.16,0.00,0.00,0.00),('1','302','1','41',81,'1','1',461.17,1059.35,0.00,0.00,598.18,437660.48,0.00,0.00,0.00),('1','302','1','41',82,'2','1',23769.26,24221.10,0.00,0.00,451.84,323389.24,0.00,0.00,0.00),('1','302','1','42',83,'1','1',1059.35,1095.93,0.00,0.00,36.58,26922.88,0.00,0.00,0.00),('1','302','1','42',84,'2','1',24221.10,24818.06,0.00,0.00,596.96,435698.12,0.00,0.00,0.00),('1','302','1','43',85,'1','1',1095.93,1153.09,0.00,0.00,57.16,42069.76,0.00,0.00,0.00),('1','302','1','43',86,'2','1',24818.06,24834.52,0.00,0.00,16.46,11686.60,0.00,0.00,0.00),('1','302','1','44',87,'1','1',1153.09,1153.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','44',88,'2','1',24834.52,25651.28,0.00,0.00,816.76,596347.72,0.00,0.00,0.00),('1','302','1','45',89,'1','1',1153.09,2134.65,0.00,0.00,981.56,714433.16,0.00,0.00,0.00),('1','302','1','45',90,'2','1',25651.28,25795.70,0.00,0.00,144.42,103147.12,0.00,0.00,0.00),('1','302','1','46',91,'1','1',2134.65,2134.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','46',92,'2','1',25795.70,26376.87,0.00,0.00,581.17,423633.12,0.00,0.00,0.00),('1','302','1','47',93,'1','1',2134.65,2349.51,0.00,0.00,214.86,158136.96,0.00,0.00,0.00),('1','302','1','47',94,'2','1',26376.87,27064.17,0.00,0.00,687.30,498949.80,0.00,0.00,0.00),('1','302','1','48',95,'1','1',2349.51,2349.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','48',96,'2','1',27064.17,28119.55,0.00,0.00,1055.38,766424.68,0.00,0.00,0.00),('1','302','1','49',97,'1','1',2349.51,2362.51,0.00,0.00,13.00,9386.00,0.00,0.00,0.00),('1','302','1','49',98,'2','1',28119.55,29101.19,0.00,0.00,981.64,712045.18,0.00,0.00,0.00),('1','302','1','50',99,'1','1',2362.51,2362.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','50',100,'2','1',29101.19,29833.47,0.00,0.00,732.28,531392.08,0.00,0.00,0.00),('1','302','1','51',101,'1','1',2362.51,2362.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','51',102,'2','1',29833.47,30090.89,0.00,0.00,257.42,186861.12,0.00,0.00,0.00),('1','302','1','52',103,'1','1',2362.51,2362.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','52',104,'2','1',30090.89,30956.40,0.00,0.00,865.51,623703.36,0.00,0.00,0.00),('1','302','1','53',105,'1','1',2362.51,2362.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','53',106,'2','1',30956.40,31931.42,0.00,0.00,975.02,703998.00,0.00,0.00,0.00),('1','302','1','54',107,'1','1',2362.51,2362.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','54',108,'2','1',31931.42,32851.28,0.00,0.00,919.86,666522.58,0.00,0.00,0.00),('1','302','1','55',109,'1','1',2362.51,2362.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','55',110,'2','1',32851.28,33665.23,0.00,0.00,813.95,587055.20,0.00,0.00,0.00),('1','302','1','56',111,'1','1',2362.51,2362.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','56',112,'2','1',33665.23,34060.60,0.00,0.00,395.37,287027.32,0.00,0.00,0.00),('1','302','1','57',113,'1','1',2362.51,2362.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','57',114,'2','1',34060.60,34992.43,0.00,0.00,931.83,673827.88,0.00,0.00,0.00),('1','302','1','58',115,'1','1',2362.51,2362.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','58',116,'2','1',34992.43,35926.90,0.00,0.00,934.47,676069.92,0.00,0.00,0.00),('1','302','1','59',117,'1','1',2362.51,2362.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','59',118,'2','1',35926.90,37227.17,0.00,0.00,1300.27,936880.44,0.00,0.00,0.00),('1','302','1','60',119,'1','1',2362.51,2362.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','60',120,'2','1',37227.17,38149.92,0.00,0.00,922.75,671069.18,0.00,0.00,0.00),('1','302','1','61',121,'1','1',2362.51,2362.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','61',122,'2','1',38149.92,39173.70,0.00,0.00,1023.78,734850.98,0.00,0.00,0.00),('1','302','1','62',123,'1','1',2362.51,2362.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','62',124,'2','1',39173.70,39644.03,0.00,0.00,470.33,335913.68,0.00,0.00,0.00),('1','302','1','63',125,'1','1',2362.51,2362.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','63',126,'2','1',39644.03,40934.64,0.00,0.00,1290.61,929873.64,0.00,0.00,0.00),('1','302','1','64',127,'1','1',2362.51,2366.32,0.00,0.00,3.81,2804.16,0.00,0.00,0.00),('1','302','1','64',128,'2','1',40934.64,42158.19,0.00,0.00,1223.55,884628.60,0.00,0.00,0.00),('1','302','1','65',129,'1','1',2366.32,2366.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','65',130,'2','1',42158.19,43226.10,0.00,0.00,1067.91,777323.76,0.00,0.00,0.00),('1','302','1','66',131,'1','1',2366.32,2366.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','66',132,'2','1',43226.10,44006.27,0.00,0.00,780.17,567016.12,0.00,0.00,0.00),('1','302','1','67',133,'1','1',2366.32,2366.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','67',134,'2','1',44006.27,44570.55,0.00,0.00,564.28,409511.04,0.00,0.00,0.00),('1','302','1','68',135,'1','1',2366.32,2367.32,0.00,0.00,1.00,736.00,0.00,0.00,0.00),('1','302','1','68',136,'2','1',44570.55,44674.55,0.00,0.00,104.00,73840.00,0.00,0.00,0.00),('1','302','1','69',137,'1','1',2367.32,2367.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','69',138,'2','1',44674.55,46123.53,0.00,0.00,1448.98,1047803.64,0.00,0.00,0.00),('1','302','1','70',139,'1','1',2367.32,2367.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','70',140,'2','1',46123.53,46823.36,0.00,0.00,699.83,510951.28,0.00,0.00,0.00),('1','302','1','71',141,'1','1',2367.32,2367.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','71',142,'2','1',46823.36,46873.25,0.00,0.00,49.89,35421.90,0.00,0.00,0.00),('1','302','1','72',143,'1','1',2367.32,2367.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','72',144,'2','1',46873.25,47298.92,0.00,0.00,425.67,310693.12,0.00,0.00,0.00),('1','302','1','73',145,'1','1',2367.32,2367.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','73',146,'2','1',47298.92,48146.23,0.00,0.00,847.31,619655.16,0.00,0.00,0.00),('1','302','1','74',147,'1','1',2367.32,2367.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','74',148,'2','1',48146.23,49149.25,0.00,0.00,1003.02,733672.72,0.00,0.00,0.00),('1','302','1','75',149,'1','1',2367.32,2377.32,0.00,0.00,10.00,7100.00,0.00,0.00,0.00),('1','302','1','75',150,'2','1',49149.25,49959.60,0.00,0.00,810.35,591737.60,0.00,0.00,0.00),('1','302','1','76',151,'1','1',2377.32,2377.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','76',152,'2','1',49959.60,50844.04,0.00,0.00,884.44,646215.84,0.00,0.00,0.00),('1','302','1','77',153,'1','1',2377.32,2377.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','77',154,'2','1',50844.04,51909.54,0.00,0.00,1065.50,774601.00,0.00,0.00,0.00),('1','302','1','78',155,'1','1',2377.32,2377.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','78',156,'2','1',51909.54,52387.90,0.00,0.00,478.36,346190.72,0.00,0.00,0.00),('1','302','1','79',157,'1','1',2377.32,2377.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','79',158,'2','1',52387.90,52897.58,0.00,0.00,509.68,371783.48,0.00,0.00,0.00),('1','302','1','80',159,'1','1',2377.32,2490.52,0.00,0.00,113.20,83315.20,0.00,0.00,0.00),('1','302','1','80',160,'2','1',52897.58,53779.91,0.00,0.00,882.33,645286.88,0.00,0.00,0.00),('1','302','1','81',161,'1','1',2490.52,3467.14,0.00,0.00,976.62,706000.32,0.00,0.00,0.00),('1','302','1','81',162,'2','1',53779.91,54244.22,0.00,0.00,464.31,338015.46,0.00,0.00,0.00),('1','302','1','82',163,'1','1',3467.14,3467.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','82',164,'2','1',54244.22,55596.90,0.00,0.00,1352.68,986082.48,0.00,0.00,0.00),('1','302','1','83',165,'1','1',3467.14,4257.13,0.00,0.00,789.99,574612.06,0.00,0.00,0.00),('1','302','1','83',166,'2','1',55596.90,56009.79,0.00,0.00,412.89,301937.04,0.00,0.00,0.00),('1','302','1','84',167,'1','1',4257.13,4257.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','84',168,'2','1',56009.79,57607.87,0.00,0.00,1598.08,1159845.62,0.00,0.00,0.00),('1','302','1','85',169,'1','1',4257.13,4846.43,0.00,0.00,589.30,428329.80,0.00,0.00,0.00),('1','302','1','85',170,'2','1',57607.87,58045.39,0.00,0.00,437.52,318504.72,0.00,0.00,0.00),('1','302','1','86',171,'1','1',4846.43,4858.43,0.00,0.00,12.00,8520.00,0.00,0.00,0.00),('1','302','1','86',172,'2','1',58045.39,59272.37,0.00,0.00,1226.98,891932.40,0.00,0.00,0.00),('1','302','1','87',173,'1','1',4858.43,5574.23,0.00,0.00,715.80,516401.50,0.00,0.00,0.00),('1','302','1','87',174,'2','1',59272.37,59519.82,0.00,0.00,247.45,180823.20,0.00,0.00,0.00),('1','302','1','88',175,'1','1',5574.23,5580.63,0.00,0.00,6.40,4710.40,0.00,0.00,0.00),('1','302','1','88',176,'2','1',59519.82,60159.55,0.00,0.00,639.73,463431.28,0.00,0.00,0.00),('1','302','1','89',177,'1','1',5580.63,6308.33,0.00,0.00,727.70,528567.20,0.00,0.00,0.00),('1','302','1','89',178,'2','1',60159.55,60654.09,0.00,0.00,494.54,359069.00,0.00,0.00,0.00),('1','302','1','90',179,'1','1',6308.33,6308.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','90',180,'2','1',60654.09,61673.28,0.00,0.00,1019.19,738449.84,0.00,0.00,0.00),('1','302','1','91',181,'1','1',6308.33,6907.07,0.00,0.00,598.74,437240.64,0.00,0.00,0.00),('1','302','1','91',182,'2','1',61673.28,61797.72,0.00,0.00,124.44,91587.84,0.00,0.00,0.00),('1','302','1','92',183,'1','1',6907.07,6913.07,0.00,0.00,6.00,4416.00,0.00,0.00,0.00),('1','302','1','92',184,'2','1',61797.72,62963.84,0.00,0.00,1166.12,847481.34,0.00,0.00,0.00),('1','302','1','93',185,'1','1',6913.07,7483.27,0.00,0.00,570.20,415494.20,0.00,0.00,0.00),('1','302','1','93',186,'2','1',62963.84,63037.22,0.00,0.00,73.38,54007.68,0.00,0.00,0.00),('1','302','1','94',187,'1','1',7483.27,7483.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','94',188,'2','1',63037.22,63762.62,0.00,0.00,725.40,528863.40,0.00,0.00,0.00),('1','302','1','95',189,'1','1',7483.27,8510.83,0.00,0.00,1027.56,746097.36,0.00,0.00,0.00),('1','302','1','95',190,'2','1',63762.62,63845.10,0.00,0.00,82.48,60705.28,0.00,0.00,0.00),('1','302','1','96',191,'1','1',8510.83,8512.19,0.00,0.00,1.36,1000.96,0.00,0.00,0.00),('1','302','1','96',192,'2','1',63845.10,65449.80,0.00,0.00,1604.70,1163067.20,0.00,0.00,0.00),('1','302','1','97',193,'1','1',8512.19,8512.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','97',194,'2','1',65449.80,66408.22,0.00,0.00,958.42,703134.60,0.00,0.00,0.00),('1','302','1','98',195,'1','1',8512.19,9182.26,0.00,0.00,670.07,490571.52,0.00,0.00,0.00),('1','302','1','98',196,'2','1',66408.22,66649.19,0.00,0.00,240.97,175273.92,0.00,0.00,0.00),('1','302','1','99',197,'1','1',9182.26,9182.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','99',198,'2','1',66649.19,67581.37,0.00,0.00,932.18,677179.48,0.00,0.00,0.00),('1','302','1','100',199,'1','1',9182.26,9564.50,0.00,0.00,382.24,280678.64,0.00,0.00,0.00),('1','302','1','100',200,'2','1',67581.37,67707.91,0.00,0.00,126.54,92821.44,0.00,0.00,0.00),('1','302','1','101',201,'1','1',9564.50,9564.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','101',202,'2','1',67707.91,68453.45,0.00,0.00,745.54,547149.64,0.00,0.00,0.00),('1','302','1','102',203,'1','1',9564.50,10210.85,0.00,0.00,646.35,473113.60,0.00,0.00,0.00),('1','302','1','102',204,'2','1',68453.45,68756.33,0.00,0.00,302.88,220447.86,0.00,0.00,0.00),('1','302','1','103',205,'1','1',10210.85,10210.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','103',206,'2','1',68756.33,69600.53,0.00,0.00,844.20,617561.20,0.00,0.00,0.00),('1','302','1','104',207,'1','1',10210.85,11021.57,0.00,0.00,810.72,593569.92,0.00,0.00,0.00),('1','302','1','104',208,'2','1',69600.53,69819.53,0.00,0.00,219.00,160534.00,0.00,0.00,0.00),('1','302','1','105',209,'1','1',11021.57,11027.57,0.00,0.00,6.00,4416.00,0.00,0.00,0.00),('1','302','1','105',210,'2','1',69819.53,70807.02,0.00,0.00,987.49,722762.64,0.00,0.00,0.00),('1','302','1','106',211,'1','1',11027.57,11322.12,0.00,0.00,294.55,214838.80,0.00,0.00,0.00),('1','302','1','106',212,'2','1',70807.02,70866.60,0.00,0.00,59.58,43850.88,0.00,0.00,0.00),('1','302','1','107',213,'1','1',11322.12,11322.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','107',214,'2','1',70866.60,71196.68,0.00,0.00,330.08,239038.88,0.00,0.00,0.00),('1','302','1','108',215,'1','1',11322.12,11854.84,0.00,0.00,532.72,387661.92,0.00,0.00,0.00),('1','302','1','108',216,'2','1',71196.68,71482.83,0.00,0.00,286.15,209956.40,0.00,0.00,0.00),('1','302','1','109',217,'1','1',11854.84,12398.26,0.00,0.00,543.42,393187.82,0.00,0.00,0.00),('1','302','1','109',218,'2','1',71482.83,71779.85,0.00,0.00,297.02,214368.42,0.00,0.00,0.00),('1','302','1','110',219,'1','1',12398.26,12398.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','110',220,'2','1',71779.85,72691.65,0.00,0.00,911.80,649902.80,0.00,0.00,0.00),('1','302','1','111',221,'1','1',12398.26,12888.94,0.00,0.00,490.68,353594.68,0.00,0.00,0.00),('1','302','1','111',222,'2','1',72691.65,72949.91,0.00,0.00,258.26,185286.76,0.00,0.00,0.00),('1','302','1','112',223,'1','1',12888.94,12888.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','112',224,'2','1',72949.91,73925.54,0.00,0.00,975.63,704433.38,0.00,0.00,0.00),('1','302','1','113',225,'1','1',12888.94,13456.05,0.00,0.00,567.11,406677.86,0.00,0.00,0.00),('1','302','1','113',226,'2','1',73925.54,74100.28,0.00,0.00,174.74,126240.62,0.00,0.00,0.00),('1','302','1','114',227,'1','1',13456.05,13456.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','114',228,'2','1',74100.28,74100.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','115',229,'1','1',13456.05,13674.55,0.00,0.00,218.50,157851.00,0.00,0.00,0.00),('1','302','1','115',230,'2','1',74100.28,74211.16,0.00,0.00,110.88,80368.88,0.00,0.00,0.00),('1','302','1','116',231,'1','1',13674.55,13674.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','116',232,'2','1',74211.16,75108.28,0.00,0.00,897.12,646759.12,0.00,0.00,0.00),('1','302','1','117',233,'1','1',13674.55,14477.18,0.00,0.00,802.63,575936.38,0.00,0.00,0.00),('1','302','1','117',234,'2','1',75108.28,75249.27,0.00,0.00,140.99,102358.74,0.00,0.00,0.00),('1','302','1','118',235,'1','1',14477.18,14477.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','118',236,'2','1',75249.27,76525.96,0.00,0.00,1276.69,914318.94,0.00,0.00,0.00),('1','302','1','119',237,'1','1',14477.18,15196.72,0.00,0.00,719.54,515308.84,0.00,0.00,0.00),('1','302','1','119',238,'2','1',76525.96,76699.39,0.00,0.00,173.43,125910.18,0.00,0.00,0.00),('1','302','1','120',239,'1','1',15196.72,15199.72,0.00,0.00,3.00,2178.00,0.00,0.00,0.00),('1','302','1','120',240,'2','1',76699.39,77663.87,0.00,0.00,964.48,692503.48,0.00,0.00,0.00),('1','302','1','121',241,'1','1',15199.72,15199.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','121',242,'2','1',77663.87,77678.79,0.00,0.00,14.92,10831.92,0.00,0.00,0.00),('1','302','1','122',243,'1','1',15199.72,15199.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','122',244,'2','1',77678.79,77678.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','123',245,'1','1',15199.72,15199.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','123',246,'2','1',77678.79,78178.43,0.00,0.00,499.64,358526.64,0.00,0.00,0.00),('1','302','1','124',247,'1','1',15199.72,15199.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','302','1','124',248,'2','1',78178.43,78178.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=125 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','302','1','1',685.00,780.00,0.00,761.17,521401.45,554233.48,32832.03,1),('1','302','2','1',685.00,736.00,0.00,323.34,221487.90,235430.24,13942.34,2),('1','302','3','1',685.00,736.00,0.00,255.63,175106.55,186843.68,11737.13,3),('1','302','4','1',685.00,736.00,0.00,620.11,424775.35,455100.96,30325.61,4),('1','302','5','1',685.00,736.00,0.00,566.67,388168.95,413169.12,25000.17,5),('1','302','6','1',685.00,736.00,0.00,459.74,314921.90,335846.64,20924.74,6),('1','302','7','1',685.00,736.00,0.00,250.16,171359.60,184117.76,12758.16,7),('1','302','8','1',685.00,736.00,0.00,421.33,288611.05,307108.88,18497.83,8),('1','302','9','1',685.00,736.00,0.00,539.79,369756.15,395335.44,25579.29,9),('1','302','10','1',685.00,736.00,0.00,421.24,288549.40,305482.64,16933.24,10),('1','302','11','1',676.00,736.00,0.00,129.07,87251.32,94995.52,7744.20,11),('1','302','12','1',676.00,736.00,0.00,676.02,456989.52,492428.72,35439.20,12),('1','302','13','1',676.00,736.00,0.00,603.53,407986.28,436859.58,28873.30,13),('1','302','14','1',676.00,736.00,0.00,344.56,232922.56,252296.16,19373.60,14),('1','302','15','1',676.00,736.00,0.00,273.84,185115.84,200896.24,15780.40,15),('1','302','16','1',676.00,736.00,0.00,440.14,297534.64,321980.04,24445.40,16),('1','302','17','1',676.00,736.00,0.00,310.40,209830.40,227804.40,17974.00,17),('1','302','18','1',676.00,736.00,0.00,778.85,526502.60,567357.60,40855.00,18),('1','302','19','1',676.00,736.00,0.00,406.76,274969.76,298075.36,23105.60,19),('1','302','20','1',676.00,736.00,0.00,332.71,224911.96,244197.00,19285.04,20),('1','302','21','1',676.00,736.00,0.00,849.59,574322.84,616536.24,42213.40,21),('1','302','22','1',676.00,736.00,0.00,287.74,194512.24,209644.12,15131.88,22),('1','302','23','1',676.00,736.00,0.00,367.48,248416.48,265136.58,16720.10,23),('1','302','24','1',676.00,736.00,0.00,988.19,668016.44,711057.84,43041.40,24),('1','302','25','1',676.00,736.00,0.00,576.14,389470.64,416889.04,27418.40,25),('1','302','26','1',676.00,736.00,0.00,447.03,302192.28,329014.08,26821.80,26),('1','302','27','1',676.00,736.00,0.00,571.28,386185.28,417940.08,31754.80,27),('1','302','28','1',676.00,736.00,0.00,1549.85,1047698.60,1117614.60,69916.00,28),('1','302','29','1',676.00,736.00,0.00,998.15,674749.40,719468.96,44719.56,29),('1','302','30','1',676.00,736.00,0.00,126.64,85608.64,93207.04,7598.40,30),('1','302','31','1',676.00,736.00,0.00,1002.08,677406.08,721865.88,44459.80,31),('1','302','32','1',676.00,736.00,0.00,550.25,371969.00,399853.68,27884.68,32),('1','302','33','1',676.00,736.00,0.00,780.36,527523.36,568780.96,41257.60,33),('1','302','34','1',676.00,736.00,0.00,1244.32,841160.32,901788.36,60628.04,34),('1','302','35','1',676.00,736.00,0.00,1172.22,792420.72,843369.10,50948.38,35),('1','302','36','1',676.00,736.00,0.00,692.41,468069.16,503555.76,35486.60,36),('1','302','37','1',676.00,736.00,0.00,412.43,278802.68,296057.10,17254.42,37),('1','302','38','1',676.00,736.00,0.00,783.05,529341.80,569023.48,39681.68,38),('1','302','39','1',676.00,736.00,0.00,1140.60,771045.60,828886.60,57841.00,39),('1','302','40','1',676.00,736.00,0.00,775.56,524278.56,561972.16,37693.60,40),('1','302','41','1',676.00,736.00,0.00,1050.02,709813.52,761049.72,51236.20,41),('1','302','42','1',676.00,736.00,0.00,633.54,428273.04,462621.00,34347.96,42),('1','302','43','1',676.00,736.00,0.00,73.62,49767.12,53756.36,3989.24,43),('1','302','44','1',676.00,736.00,0.00,816.76,552129.76,596347.72,44217.96,44),('1','302','45','1',676.00,736.00,0.00,1125.98,761162.48,817580.28,56417.80,45),('1','302','46','1',676.00,736.00,0.00,581.17,392870.92,423633.12,30762.20,46),('1','302','47','1',676.00,736.00,0.00,902.16,609860.16,657086.76,47226.60,47),('1','302','48','1',676.00,736.00,0.00,1055.38,713436.88,766424.68,52987.80,48),('1','302','49','1',676.00,736.00,0.00,994.64,672376.64,721431.18,49054.54,49),('1','302','50','1',676.00,736.00,0.00,732.28,495021.28,531392.08,36370.80,50),('1','302','51','1',676.00,736.00,0.00,257.42,174015.92,186861.12,12845.20,51),('1','302','52','1',676.00,736.00,0.00,865.51,585084.76,623703.36,38618.60,52),('1','302','53','1',676.00,736.00,0.00,975.02,659113.52,703998.00,44884.48,53),('1','302','54','1',676.00,736.00,0.00,919.86,621825.36,666522.58,44697.22,54),('1','302','55','1',676.00,736.00,0.00,813.95,550230.20,587055.20,36825.00,55),('1','302','56','1',676.00,736.00,0.00,395.37,267270.12,287027.32,19757.20,56),('1','302','57','1',676.00,736.00,0.00,931.83,629917.08,673827.88,43910.80,57),('1','302','58','1',676.00,736.00,0.00,934.47,631701.72,676069.92,44368.20,58),('1','302','59','1',676.00,736.00,0.00,1300.27,878982.52,936880.44,57897.92,59),('1','302','60','1',676.00,736.00,0.00,922.75,623779.00,671069.18,47290.18,60),('1','302','61','1',676.00,736.00,0.00,1023.78,692075.28,734850.98,42775.70,61),('1','302','62','1',651.00,736.00,0.00,470.33,306184.83,335913.68,29728.85,62),('1','302','63','1',651.00,736.00,0.00,1290.61,840187.11,929873.64,89686.53,63),('1','302','64','1',651.00,736.00,0.00,1227.36,799011.36,887432.76,88421.40,64),('1','302','65','1',651.00,736.00,0.00,1067.91,695209.41,777323.76,82114.35,65),('1','302','66','1',651.00,736.00,0.00,780.17,507890.67,567016.12,59125.45,66),('1','302','67','1',651.00,736.00,0.00,564.28,367346.28,409511.04,42164.76,67),('1','302','68','1',651.00,736.00,0.00,105.00,68355.00,74576.00,6221.00,68),('1','302','69','1',651.00,736.00,0.00,1448.98,943285.98,1047803.64,104517.66,69),('1','302','70','1',651.00,736.00,0.00,699.83,455589.33,510951.28,55361.95,70),('1','302','71','1',651.00,736.00,0.00,49.89,32478.39,35421.90,2943.51,71),('1','302','72','1',651.00,736.00,0.00,425.67,277111.17,310693.12,33581.95,72),('1','302','73','1',651.00,736.00,0.00,847.31,551598.81,619655.16,68056.35,73),('1','302','74','1',651.00,736.00,0.00,1003.02,652966.02,733672.72,80706.70,74),('1','302','75','1',651.00,736.00,0.00,820.35,534047.85,598837.60,64789.75,75),('1','302','76','1',651.00,736.00,0.00,884.44,575770.44,646215.84,70445.40,76),('1','302','77','1',651.00,736.00,0.00,1065.50,693640.50,774601.00,80960.50,77),('1','302','78','1',651.00,736.00,0.00,478.36,311412.36,346190.72,34778.36,78),('1','302','79','1',651.00,736.00,0.00,509.68,331801.68,371783.48,39981.80,79),('1','302','80','1',651.00,736.00,0.00,995.53,648090.03,728602.08,80512.05,80),('1','302','81','1',651.00,736.00,0.00,1440.93,938045.43,1044015.78,105970.35,81),('1','302','82','1',651.00,736.00,0.00,1352.68,880594.68,986082.48,105487.80,82),('1','302','83','1',651.00,736.00,0.00,1202.88,783074.88,876549.10,93474.22,83),('1','302','84','1',651.00,736.00,0.00,1598.08,1040350.08,1159845.62,119495.54,84),('1','302','85','1',651.00,736.00,0.00,1026.82,668459.82,746834.52,78374.70,85),('1','302','86','1',651.00,736.00,0.00,1238.98,806575.98,900452.40,93876.42,86),('1','302','87','1',651.00,736.00,0.00,963.25,627075.75,697224.70,70148.95,87),('1','302','88','1',651.00,736.00,0.00,646.13,420630.63,468141.68,47511.05,88),('1','302','89','1',651.00,736.00,0.00,1222.24,807900.64,887636.20,79735.56,89),('1','302','90','1',661.00,736.00,0.00,1019.19,673684.59,738449.84,64765.25,90),('1','302','91','1',661.00,736.00,0.00,723.18,478021.98,528828.48,50806.50,91),('1','302','92','1',661.00,736.00,0.00,1172.12,774771.32,851897.34,77126.02,92),('1','302','93','1',661.00,736.00,0.00,643.58,425406.38,469501.88,44095.50,93),('1','302','94','1',661.00,736.00,0.00,725.40,479489.40,528863.40,49374.00,94),('1','302','95','1',661.00,736.00,0.00,1110.04,733736.44,806802.64,73066.20,95),('1','302','96','1',661.00,736.00,0.00,1606.06,1061605.66,1164068.16,102462.50,96),('1','302','97','1',661.00,736.00,0.00,958.42,633515.62,703134.60,69618.98,97),('1','302','98','1',661.00,736.00,0.00,911.04,602197.44,665845.44,63648.00,98),('1','302','99','1',661.00,736.00,0.00,932.18,616170.98,677179.48,61008.50,99),('1','302','100','1',661.00,736.00,0.00,508.78,331215.78,373500.08,42284.30,100),('1','302','101','1',651.00,736.00,0.00,745.54,485346.54,547149.64,61803.10,101),('1','302','102','1',651.00,736.00,0.00,949.23,617948.73,693561.46,75612.73,102),('1','302','103','1',651.00,736.00,0.00,844.20,549574.20,617561.20,67987.00,103),('1','302','104','1',651.00,736.00,0.00,1029.72,670347.72,754103.92,83756.20,104),('1','302','105','1',651.00,736.00,0.00,993.49,646761.99,727178.64,80416.65,105),('1','302','106','1',651.00,736.00,0.00,354.13,230538.63,258689.68,28151.05,106),('1','302','107','1',651.00,736.00,0.00,330.08,214882.08,239038.88,24156.80,107),('1','302','108','1',651.00,736.00,0.00,818.87,533084.37,597618.32,64533.95,108),('1','302','109','1',651.00,736.00,0.00,840.44,547126.44,607556.24,60429.80,109),('1','302','110','1',651.00,726.00,0.00,911.80,593581.80,649902.80,56321.00,110),('1','302','111','1',651.00,726.00,0.00,748.94,487559.94,538881.44,51321.50,111),('1','302','112','1',651.00,726.00,0.00,975.63,635135.13,704433.38,69298.25,112),('1','302','113','1',651.00,726.00,0.00,741.85,482944.35,532918.48,49974.13,113),('1','302','114','1',651.00,726.00,0.00,0.00,0.00,0.00,0.00,114),('1','302','115','1',651.00,726.00,0.00,329.38,214426.38,238219.88,23793.50,115),('1','302','116','1',651.00,726.00,0.00,897.12,584025.12,646759.12,62734.00,116),('1','302','117','1',651.00,726.00,0.00,943.62,614296.62,678295.12,63998.50,117),('1','302','118','1',651.00,726.00,0.00,1276.69,831125.19,914318.94,83193.75,118),('1','302','119','1',651.00,726.00,0.00,892.97,581323.47,641219.02,59895.55,119),('1','302','120','1',651.00,726.00,0.00,967.48,629829.48,694681.48,64852.00,120),('1','302','121','1',651.00,726.00,0.00,14.92,9712.92,10831.92,1119.00,121),('1','302','122','1',651.00,726.00,0.00,0.00,0.00,0.00,0.00,122),('1','302','123','1',651.00,726.00,0.00,499.64,325265.64,358526.64,33261.00,123),('1','302','124','1',651.00,726.00,0.00,0.00,0.00,0.00,0.00,124);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',1,'302','LPG PRODUCT TANK.','LPG TANKS');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','302','1',1,1,'1','LPG TANK ',7000.00,0.00,NULL,'TANK CONTAINING LPG.','479','2022-11-28 13:19:58','2022-11-28 13:19:58','479',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','302',1,4899.36,'2023-03-20 06:40:31');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=9734 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,2740000.00,4000.00,0.00,0.00,'2022-11-30 09:18:03','',''),(2,'1','302',NULL,1,'Reception corrector for bridging 1',0.00,0.00,0.00,4000.00,0.00,'2022-11-30 09:21:18','',''),(3,'1','302','1',1,'Received from bridging 1',0.00,0.00,4000.00,0.00,0.00,'2022-11-30 09:21:18','',''),(4,'1','302','1',1,'Retail Sale Id 1',32128.20,0.00,0.00,41.19,3913.05,'2022-11-30 09:38:30','',''),(5,'1','302','1',1,'Retail Sale Id 2',259020.48,0.00,0.00,351.93,17948.43,'2022-11-30 09:44:30','',''),(6,'1','302','1',1,'Retail Sale Id 3',213000.00,0.00,0.00,300.00,7500.00,'2022-11-30 09:58:29','',''),(7,'1','302','1',1,'Retail Sale Id 4',50084.80,0.00,0.00,68.05,3470.55,'2022-11-30 22:58:54','',''),(8,'1','302','1',1,'Retail Sale Id 5',736.00,0.00,0.00,1.00,51.00,'2022-12-01 07:24:31','',''),(9,'1','302','1',1,'Retail Sale Id 6',4496.96,0.00,0.00,6.11,311.61,'2022-12-01 07:56:09','',''),(10,'1','302','1',1,'Retail Sale Id 7',4496.96,0.00,0.00,6.11,311.61,'2022-12-01 08:06:07','',''),(11,'1','302','1',1,'Retail Sale Id 10',2502.40,0.00,0.00,3.40,173.40,'2022-12-01 08:29:32','',''),(12,'1','302','1',1,'Retail Sale Id 14',2502.40,0.00,0.00,3.40,173.40,'2022-12-01 08:48:03','',''),(13,'1','302','1',1,'Retail Sale Id 15',2208.00,0.00,0.00,3.00,153.00,'2022-12-01 08:49:03','',''),(14,'1','302','1',1,'Retail Sale Id 16',8500.80,0.00,0.00,11.55,589.05,'2022-12-01 08:59:20','',''),(15,'1','302','1',1,'Retail Sale Id 17',1501.44,0.00,0.00,2.04,104.04,'2022-12-01 09:08:51','',''),(16,'1','302','1',1,'Retail Sale Id 18',9200.00,0.00,0.00,12.50,637.50,'2022-12-01 09:10:23','',''),(17,'1','302','1',1,'Retail Sale Id 19',2208.00,0.00,0.00,3.00,153.00,'2022-12-01 09:11:50','',''),(18,'1','302','1',1,'Retail Sale Id 20',4496.96,0.00,0.00,6.11,311.61,'2022-12-01 09:20:47','',''),(19,'1','302','1',1,'Retail Sale Id 21',9200.00,0.00,0.00,12.50,637.50,'2022-12-01 09:49:27','',''),(20,'1','302','1',1,'Retail Sale Id 22',9200.00,0.00,0.00,12.50,637.50,'2022-12-01 09:55:22','',''),(21,'1','302','1',1,'Retail Sale Id 23',3503.36,0.00,0.00,4.76,242.76,'2022-12-01 10:34:24','',''),(22,'1','302','1',1,'Retail Sale Id 24',9200.00,0.00,0.00,12.50,637.50,'2022-12-01 10:41:11','',''),(23,'1','302','1',1,'Retail Sale Id 25',802.24,0.00,0.00,1.09,55.59,'2022-12-01 11:10:42','',''),(24,'1','302','1',1,'Retail Sale Id 26',2208.00,0.00,0.00,3.00,153.00,'2022-12-01 11:11:59','',''),(25,'1','302','1',1,'Retail Sale Id 27',2001.92,0.00,0.00,2.72,138.72,'2022-12-01 11:12:49','',''),(26,'1','302','1',1,'Retail Sale Id 28',2208.00,0.00,0.00,3.00,153.00,'2022-12-01 11:22:15','',''),(27,'1','302','1',1,'Retail Sale Id 29',2208.00,0.00,0.00,3.00,153.00,'2022-12-01 11:41:47','',''),(28,'1','302','1',1,'Retail Sale Id 30',2303.68,0.00,0.00,3.13,159.63,'2022-12-01 11:45:23','',''),(29,'1','302','1',1,'Retail Sale Id 31',4423.36,0.00,0.00,6.01,306.51,'2022-12-01 12:39:05','',''),(30,'1','302','1',1,'Retail Sale Id 32',8000.32,0.00,0.00,10.87,554.37,'2022-12-01 13:44:43','',''),(31,'1','302','1',1,'Retail Sale Id 33',34080.00,0.00,0.00,48.00,1200.00,'2022-12-01 13:56:19','',''),(32,'1','302','1',1,'Retail Sale Id 34',9200.00,0.00,0.00,12.50,637.50,'2022-12-01 14:02:47','',''),(33,'1','302','1',1,'Retail Sale Id 35',2208.00,0.00,0.00,3.00,153.00,'2022-12-01 14:40:19','',''),(34,'1','302','1',1,'Retail Sale Id 37',2208.00,0.00,0.00,3.00,153.00,'2022-12-01 14:59:26','',''),(35,'1','302','1',1,'Retail Sale Id 38',2252.16,0.00,0.00,3.06,156.06,'2022-12-01 15:03:13','',''),(36,'1','302','1',1,'Retail Sale Id 39',4416.00,0.00,0.00,6.00,306.00,'2022-12-01 15:50:40','',''),(37,'1','302','1',1,'Retail Sale Id 39',9200.00,0.00,0.00,12.50,637.50,'2022-12-01 15:50:40','',''),(38,'1','302','1',1,'Retail Sale Id 40',1501.44,0.00,0.00,2.04,104.04,'2022-12-01 15:57:05','',''),(39,'1','302','1',1,'Retail Sale Id 41',1501.44,0.00,0.00,2.04,104.04,'2022-12-01 15:59:16','',''),(40,'1','302','1',1,'Retail Sale Id 42',750.72,0.00,0.00,1.02,52.02,'2022-12-01 16:00:59','',''),(41,'1','302','1',1,'Retail Sale Id 43',35500.00,0.00,0.00,50.00,1250.00,'2022-12-01 16:29:54','',''),(42,'1','302','1',1,'Retail Sale Id 44',1501.44,0.00,0.00,2.04,104.04,'2022-12-01 16:30:55','',''),(43,'1','302','1',1,'Retail Sale Id 45',7360.00,0.00,0.00,10.00,510.00,'2022-12-01 16:37:52','',''),(44,'1','302','1',1,'Retail Sale Id 46',2208.00,0.00,0.00,3.00,153.00,'2022-12-01 16:45:43','',''),(45,'1','302','1',1,'Retail Sale Id 47',3002.88,0.00,0.00,4.08,208.08,'2022-12-01 17:04:52','',''),(46,'1','302','1',1,'Retail Sale Id 49',3996.48,0.00,0.00,5.43,276.93,'2022-12-01 17:13:14','',''),(47,'1','302','1',1,'Retail Sale Id 50',4496.96,0.00,0.00,6.11,311.61,'2022-12-01 17:26:55','',''),(48,'1','302','1',1,'Retail Sale Id 51',3680.00,0.00,0.00,5.00,255.00,'2022-12-01 17:33:45','',''),(49,'1','302','1',1,'Retail Sale Id 52',5203.52,0.00,0.00,7.07,360.57,'2022-12-01 17:43:43','',''),(50,'1','302','1',1,'Retail Sale Id 53',1000.96,0.00,0.00,1.36,69.36,'2022-12-01 17:55:16','',''),(51,'1','302','1',1,'Retail Sale Id 55',4416.00,0.00,0.00,6.00,306.00,'2022-12-01 17:59:11','',''),(52,'1','302','1',1,'Return of Retail Sale Id 55',0.00,4416.00,6.00,0.00,-306.00,'2022-12-01 18:28:13','',''),(53,'1','302','1',1,'Retail Sale Id 56',2053.44,0.00,0.00,2.79,142.29,'2022-12-01 18:28:51','',''),(54,'1','302','1',1,'Retail Sale Id 57',6999.36,0.00,0.00,9.51,485.01,'2022-12-02 07:47:48','',''),(55,'1','302','1',1,'Retail Sale Id 58',2208.00,0.00,0.00,3.00,153.00,'2022-12-02 07:56:59','',''),(56,'1','302','1',1,'Retail Sale Id 59',2208.00,0.00,0.00,3.00,153.00,'2022-12-02 08:10:47','',''),(57,'1','302','1',1,'Retail Sale Id 59',5291.84,0.00,0.00,7.19,366.69,'2022-12-02 08:10:47','',''),(58,'1','302','1',1,'Retail Sale Id 60',1000.96,0.00,0.00,1.36,69.36,'2022-12-02 08:11:41','',''),(59,'1','302','1',1,'Retail Sale Id 61',3680.00,0.00,0.00,5.00,255.00,'2022-12-02 08:56:16','',''),(60,'1','302','1',1,'Retail Sale Id 62',1472.00,0.00,0.00,2.00,102.00,'2022-12-02 09:23:02','',''),(61,'1','302','1',1,'Retail Sale Id 62',2944.00,0.00,0.00,4.00,204.00,'2022-12-02 09:23:02','',''),(62,'1','302','1',1,'Retail Sale Id 63',2208.00,0.00,0.00,3.00,153.00,'2022-12-02 09:37:43','',''),(63,'1','302','1',1,'Retail Sale Id 64',3503.36,0.00,0.00,4.76,242.76,'2022-12-02 09:38:38','',''),(64,'1','302','1',1,'Retail Sale Id 65',1501.44,0.00,0.00,2.04,104.04,'2022-12-02 09:57:33','',''),(65,'1','302','1',1,'Retail Sale Id 66',2208.00,0.00,0.00,3.00,153.00,'2022-12-02 10:10:45','',''),(66,'1','302','1',1,'Retail Sale Id 66',2208.00,0.00,0.00,3.00,153.00,'2022-12-02 10:10:45','',''),(67,'1','302','1',1,'Retail Sale Id 68',35500.00,0.00,0.00,50.00,1250.00,'2022-12-02 10:19:57','',''),(68,'1','302','1',1,'Retail Sale Id 69',4496.96,0.00,0.00,6.11,311.61,'2022-12-02 10:22:08','',''),(69,'1','302','1',1,'Retail Sale Id 70',4496.96,0.00,0.00,6.11,311.61,'2022-12-02 10:23:17','',''),(70,'1','302','1',1,'Retail Sale Id 71',2001.92,0.00,0.00,2.72,138.72,'2022-12-02 10:27:39','',''),(71,'1','302','1',1,'Retail Sale Id 72',4496.96,0.00,0.00,6.11,311.61,'2022-12-02 10:29:17','',''),(72,'1','302','1',1,'Retail Sale Id 73',743.36,0.00,0.00,1.01,51.51,'2022-12-02 10:36:15','',''),(73,'1','302','1',1,'Retail Sale Id 74',3680.00,0.00,0.00,5.00,255.00,'2022-12-02 11:18:12','',''),(74,'1','302','1',1,'Retail Sale Id 75',3002.88,0.00,0.00,4.08,208.08,'2022-12-02 11:19:40','',''),(75,'1','302','1',1,'Retail Sale Id 76',7352.64,0.00,0.00,9.99,509.49,'2022-12-02 11:52:32','',''),(76,'1','302','1',1,'Retail Sale Id 77',2208.00,0.00,0.00,3.00,153.00,'2022-12-02 12:00:17','',''),(77,'1','302','1',1,'Retail Sale Id 78',2208.00,0.00,0.00,3.00,153.00,'2022-12-02 12:02:34','',''),(78,'1','302','1',1,'Retail Sale Id 79',4423.36,0.00,0.00,6.01,306.51,'2022-12-02 12:08:29','',''),(79,'1','302','1',1,'Retail Sale Id 79',9200.00,0.00,0.00,12.50,637.50,'2022-12-02 12:08:29','',''),(80,'1','302','1',1,'Retail Sale Id 80',743.36,0.00,0.00,1.01,51.51,'2022-12-02 12:22:24','',''),(81,'1','302','1',1,'Retail Sale Id 81',500.48,0.00,0.00,0.68,34.68,'2022-12-02 12:35:04','',''),(82,'1','302','1',1,'Retail Sale Id 82',2208.00,0.00,0.00,3.00,153.00,'2022-12-02 12:40:25','',''),(83,'1','302','1',1,'Retail Sale Id 83',3996.48,0.00,0.00,5.43,276.93,'2022-12-02 12:52:11','',''),(84,'1','302','1',1,'Retail Sale Id 84',4423.36,0.00,0.00,6.01,306.51,'2022-12-02 12:56:22','',''),(85,'1','302','1',1,'Retail Sale Id 85',3702.08,0.00,0.00,5.03,256.53,'2022-12-02 13:21:21','',''),(86,'1','302','1',1,'Retail Sale Id 86',4416.00,0.00,0.00,6.00,306.00,'2022-12-02 14:24:34','',''),(87,'1','302','1',1,'Retail Sale Id 87',2001.92,0.00,0.00,2.72,138.72,'2022-12-02 14:28:22','',''),(88,'1','302','1',1,'Retail Sale Id 87',4416.00,0.00,0.00,6.00,306.00,'2022-12-02 14:28:22','',''),(89,'1','302','1',1,'Retail Sale Id 88',9200.00,0.00,0.00,12.50,637.50,'2022-12-02 14:45:33','',''),(90,'1','302','1',1,'Retail Sale Id 89',2200.64,0.00,0.00,2.99,152.49,'2022-12-02 14:51:25','',''),(91,'1','302','1',1,'Retail Sale Id 90',3002.88,0.00,0.00,4.08,208.08,'2022-12-02 15:06:58','',''),(92,'1','302','1',1,'Retail Sale Id 91',3002.88,0.00,0.00,4.08,208.08,'2022-12-02 16:01:50','',''),(93,'1','302','1',1,'Retail Sale Id 92',9200.00,0.00,0.00,12.50,637.50,'2022-12-02 16:52:41','',''),(94,'1','302','1',1,'Retail Sale Id 93',5203.52,0.00,0.00,7.07,360.57,'2022-12-02 17:24:14','',''),(95,'1','302','1',1,'Retail Sale Id 94',1501.44,0.00,0.00,2.04,104.04,'2022-12-02 17:25:07','',''),(96,'1','302','1',1,'Retail Sale Id 95',3702.08,0.00,0.00,5.03,256.53,'2022-12-02 17:52:19','',''),(97,'1','302','1',1,'Retail Sale Id 96',743.36,0.00,0.00,1.01,51.51,'2022-12-02 17:53:29','',''),(98,'1','302','1',1,'Retail Sale Id 97',1479.36,0.00,0.00,2.01,102.51,'2022-12-02 17:54:45','',''),(99,'1','302','1',1,'Return of Retail Sale Id 96',0.00,743.36,1.01,0.00,-51.51,'2022-12-02 18:47:33','',''),(100,'1','302','1',1,'Retail Sale Id 98',699.20,0.00,0.00,0.95,48.45,'2022-12-02 18:48:18','',''),(101,'1','302','1',1,'Retail Sale Id 99',4496.96,0.00,0.00,6.11,311.61,'2022-12-03 07:57:45','',''),(102,'1','302','1',1,'Retail Sale Id 100',2001.92,0.00,0.00,2.72,138.72,'2022-12-03 08:21:29','',''),(103,'1','302','1',1,'Retail Sale Id 101',4997.44,0.00,0.00,6.79,346.29,'2022-12-03 08:34:00','',''),(104,'1','302','1',1,'Retail Sale Id 102',1501.44,0.00,0.00,2.04,104.04,'2022-12-03 08:48:41','',''),(105,'1','302','1',1,'Retail Sale Id 103',2252.16,0.00,0.00,3.06,156.06,'2022-12-03 09:08:08','',''),(106,'1','302','1',1,'Retail Sale Id 104',2208.00,0.00,0.00,3.00,153.00,'2022-12-03 09:10:35','',''),(107,'1','302','1',1,'Retail Sale Id 105',3002.88,0.00,0.00,4.08,208.08,'2022-12-03 09:40:57','',''),(108,'1','302','1',1,'Retail Sale Id 106',9303.04,0.00,0.00,12.64,644.64,'2022-12-03 09:56:28','',''),(109,'1','302','1',1,'Retail Sale Id 108',2208.00,0.00,0.00,3.00,153.00,'2022-12-03 10:02:56','',''),(110,'1','302','1',1,'Retail Sale Id 108',2944.00,0.00,0.00,4.00,204.00,'2022-12-03 10:02:56','',''),(111,'1','302','1',1,'Retail Sale Id 109',1391.04,0.00,0.00,1.89,96.39,'2022-12-03 10:04:53','',''),(112,'1','302','1',1,'Retail Sale Id 109',2208.00,0.00,0.00,3.00,153.00,'2022-12-03 10:04:53','',''),(113,'1','302','1',1,'Retail Sale Id 110',4496.96,0.00,0.00,6.11,311.61,'2022-12-03 10:09:35','',''),(114,'1','302','1',1,'Retail Sale Id 111',2208.00,0.00,0.00,3.00,153.00,'2022-12-03 10:38:52','',''),(115,'1','302','1',1,'Retail Sale Id 112',9303.04,0.00,0.00,12.64,644.64,'2022-12-03 10:40:42','',''),(116,'1','302','1',1,'Retail Sale Id 113',7499.84,0.00,0.00,10.19,519.69,'2022-12-03 10:54:29','',''),(117,'1','302','1',1,'Retail Sale Id 114',4496.96,0.00,0.00,6.11,311.61,'2022-12-03 10:56:04','',''),(118,'1','302','1',1,'Retail Sale Id 115',3702.08,0.00,0.00,5.03,256.53,'2022-12-03 10:58:15','',''),(119,'1','302','1',1,'Retail Sale Id 116',3797.76,0.00,0.00,5.16,263.16,'2022-12-03 11:00:37','',''),(120,'1','302','1',1,'Retail Sale Id 118',4416.00,0.00,0.00,6.00,306.00,'2022-12-03 11:33:37','',''),(121,'1','302','1',1,'Retail Sale Id 118',4482.24,0.00,0.00,6.09,310.59,'2022-12-03 11:33:37','',''),(122,'1','302','1',1,'Retail Sale Id 119',9200.00,0.00,0.00,12.50,637.50,'2022-12-03 11:35:35','',''),(123,'1','302','1',1,'Retail Sale Id 119',9200.00,0.00,0.00,12.50,637.50,'2022-12-03 11:35:35','',''),(124,'1','302','1',1,'Retail Sale Id 120',2208.00,0.00,0.00,3.00,153.00,'2022-12-03 11:36:38','',''),(125,'1','302','1',1,'Retail Sale Id 121',4496.96,0.00,0.00,6.11,311.61,'2022-12-03 11:38:35','',''),(126,'1','302','1',1,'Retail Sale Id 122',4496.96,0.00,0.00,6.11,311.61,'2022-12-03 11:42:30','',''),(127,'1','302','1',1,'Retail Sale Id 123',3680.00,0.00,0.00,5.00,255.00,'2022-12-03 11:44:05','',''),(128,'1','302','1',1,'Retail Sale Id 124',9200.00,0.00,0.00,12.50,637.50,'2022-12-03 11:44:54','',''),(129,'1','302','1',1,'Retail Sale Id 125',2097.60,0.00,0.00,2.85,145.35,'2022-12-03 11:47:32','',''),(130,'1','302','1',1,'Retail Sale Id 126',1501.44,0.00,0.00,2.04,104.04,'2022-12-03 11:50:11','',''),(131,'1','302','1',1,'Retail Sale Id 127',9200.00,0.00,0.00,12.50,637.50,'2022-12-03 11:50:59','',''),(132,'1','302','1',1,'Retail Sale Id 128',1501.44,0.00,0.00,2.04,104.04,'2022-12-03 11:52:33','',''),(133,'1','302','1',1,'Retail Sale Id 128',1501.44,0.00,0.00,2.04,104.04,'2022-12-03 11:52:33','',''),(134,'1','302','1',1,'Retail Sale Id 129',9200.00,0.00,0.00,12.50,637.50,'2022-12-03 11:58:26','',''),(135,'1','302','1',1,'Retail Sale Id 130',8000.32,0.00,0.00,10.87,554.37,'2022-12-03 11:59:51','',''),(136,'1','302','1',1,'Retail Sale Id 131',3002.88,0.00,0.00,4.08,208.08,'2022-12-03 12:01:18','',''),(137,'1','302','1',1,'Retail Sale Id 132',4401.28,0.00,0.00,5.98,304.98,'2022-12-03 12:02:48','',''),(138,'1','302','1',1,'Retail Sale Id 133',4997.44,0.00,0.00,6.79,346.29,'2022-12-03 12:04:42','',''),(139,'1','302','1',1,'Retail Sale Id 134',3996.48,0.00,0.00,5.43,276.93,'2022-12-03 12:14:04','',''),(140,'1','302','1',1,'Retail Sale Id 135',2303.68,0.00,0.00,3.13,159.63,'2022-12-03 12:18:19','',''),(141,'1','302','1',1,'Retail Sale Id 136',2318.40,0.00,0.00,3.15,160.65,'2022-12-03 12:29:10','',''),(142,'1','302','1',1,'Retail Sale Id 136',3680.00,0.00,0.00,5.00,255.00,'2022-12-03 12:29:10','',''),(143,'1','302','1',1,'Retail Sale Id 137',4496.96,0.00,0.00,6.11,311.61,'2022-12-03 12:33:28','',''),(144,'1','302','1',1,'Retail Sale Id 138',3996.48,0.00,0.00,5.43,276.93,'2022-12-03 12:37:54','',''),(145,'1','302','1',1,'Retail Sale Id 139',2796.80,0.00,0.00,3.80,193.80,'2022-12-03 12:49:15','',''),(146,'1','302','1',1,'Retail Sale Id 139',2796.80,0.00,0.00,3.80,193.80,'2022-12-03 12:49:15','',''),(147,'1','302','1',1,'Retail Sale Id 139',2796.80,0.00,0.00,3.80,193.80,'2022-12-03 12:49:15','',''),(148,'1','302','1',1,'Retail Sale Id 139',2796.80,0.00,0.00,3.80,193.80,'2022-12-03 12:49:15','',''),(149,'1','302','1',1,'Retail Sale Id 139',2796.80,0.00,0.00,3.80,193.80,'2022-12-03 12:49:15','',''),(150,'1','302','1',1,'Retail Sale Id 139',2796.80,0.00,0.00,3.80,193.80,'2022-12-03 12:49:15','',''),(151,'1','302','1',1,'Retail Sale Id 140',4997.44,0.00,0.00,6.79,346.29,'2022-12-03 12:52:22','',''),(152,'1','302','1',1,'Retail Sale Id 141',7499.84,0.00,0.00,10.19,519.69,'2022-12-03 12:58:09','',''),(153,'1','302','1',1,'Retail Sale Id 142',35500.00,0.00,0.00,50.00,1250.00,'2022-12-03 13:00:41','',''),(154,'1','302','1',1,'Retail Sale Id 143',9303.04,0.00,0.00,12.64,644.64,'2022-12-03 13:02:25','',''),(155,'1','302','1',1,'Retail Sale Id 144',5299.20,0.00,0.00,7.20,367.20,'2022-12-03 13:05:02','',''),(156,'1','302','1',1,'Retail Sale Id 145',4496.96,0.00,0.00,6.11,311.61,'2022-12-03 13:05:58','',''),(157,'1','302','1',1,'Retail Sale Id 146',2200.64,0.00,0.00,2.99,152.49,'2022-12-03 13:23:29','',''),(158,'1','302','1',1,'Retail Sale Id 147',3503.36,0.00,0.00,4.76,242.76,'2022-12-03 13:24:28','',''),(159,'1','302','1',1,'Retail Sale Id 148',16928.00,0.00,0.00,23.00,1173.00,'2022-12-03 13:28:09','',''),(160,'1','302','1',1,'Retail Sale Id 149',2200.64,0.00,0.00,2.99,152.49,'2022-12-03 13:29:48','',''),(161,'1','302','1',1,'Retail Sale Id 150',2208.00,0.00,0.00,3.00,153.00,'2022-12-03 13:34:35','',''),(162,'1','302','1',1,'Retail Sale Id 151',4416.00,0.00,0.00,6.00,306.00,'2022-12-03 13:42:56','',''),(163,'1','302','1',1,'Retail Sale Id 153',1501.44,0.00,0.00,2.04,104.04,'2022-12-03 13:49:16','',''),(164,'1','302','1',1,'Retail Sale Id 154',9200.00,0.00,0.00,12.50,637.50,'2022-12-03 13:52:33','',''),(165,'1','302','1',1,'Retail Sale Id 155',5998.40,0.00,0.00,8.15,415.65,'2022-12-03 13:56:34','',''),(166,'1','302','1',1,'Retail Sale Id 156',1000.96,0.00,0.00,1.36,69.36,'2022-12-03 13:58:02','',''),(167,'1','302','1',1,'Retail Sale Id 157',4416.00,0.00,0.00,6.00,306.00,'2022-12-03 14:00:44','',''),(168,'1','302','1',1,'Retail Sale Id 158',2208.00,0.00,0.00,3.00,153.00,'2022-12-03 14:20:50','',''),(169,'1','302','1',1,'Retail Sale Id 159',1000.96,0.00,0.00,1.36,69.36,'2022-12-03 14:25:14','',''),(170,'1','302','1',1,'Retail Sale Id 160',4496.96,0.00,0.00,6.11,311.61,'2022-12-03 14:32:25','',''),(171,'1','302','1',1,'Retail Sale Id 161',2208.00,0.00,0.00,3.00,153.00,'2022-12-03 14:36:46','',''),(172,'1','302','1',1,'Retail Sale Id 161',4416.00,0.00,0.00,6.00,306.00,'2022-12-03 14:36:46','',''),(173,'1','302','1',1,'Retail Sale Id 162',4423.36,0.00,0.00,6.01,306.51,'2022-12-03 14:42:19','',''),(174,'1','302','1',1,'Retail Sale Id 163',1472.00,0.00,0.00,2.00,102.00,'2022-12-03 15:13:55','',''),(175,'1','302','1',1,'Retail Sale Id 163',2208.00,0.00,0.00,3.00,153.00,'2022-12-03 15:13:55','',''),(176,'1','302','1',1,'Retail Sale Id 164',4423.36,0.00,0.00,6.01,306.51,'2022-12-03 15:15:12','',''),(177,'1','302','1',1,'Retail Sale Id 165',7728.00,0.00,0.00,10.50,535.50,'2022-12-03 15:29:42','',''),(178,'1','302','1',1,'Retail Sale Id 166',2208.00,0.00,0.00,3.00,153.00,'2022-12-03 15:53:07','',''),(179,'1','302','1',1,'Retail Sale Id 167',2208.00,0.00,0.00,3.00,153.00,'2022-12-03 16:14:39','',''),(180,'1','302','1',1,'Retail Sale Id 168',2208.00,0.00,0.00,3.00,153.00,'2022-12-03 16:19:39','',''),(181,'1','302','1',1,'Retail Sale Id 169',7360.00,0.00,0.00,10.00,510.00,'2022-12-03 16:23:02','',''),(182,'1','302','1',1,'Retail Sale Id 170',9200.00,0.00,0.00,12.50,637.50,'2022-12-03 16:28:35','',''),(183,'1','302','1',1,'Retail Sale Id 172',3680.00,0.00,0.00,5.00,255.00,'2022-12-03 16:32:11','',''),(184,'1','302','1',1,'Retail Sale Id 174',4496.96,0.00,0.00,6.11,311.61,'2022-12-03 16:45:37','',''),(185,'1','302','1',1,'Retail Sale Id 175',2303.68,0.00,0.00,3.13,159.63,'2022-12-03 16:52:14','',''),(186,'1','302','1',1,'Retail Sale Id 176',4496.96,0.00,0.00,6.11,311.61,'2022-12-03 16:58:11','',''),(187,'1','302','1',1,'Retail Sale Id 177',2208.00,0.00,0.00,3.00,153.00,'2022-12-03 16:59:34','',''),(188,'1','302','1',1,'Retail Sale Id 178',1000.96,0.00,0.00,1.36,69.36,'2022-12-03 17:01:50','',''),(189,'1','302','1',1,'Retail Sale Id 179',9200.00,0.00,0.00,12.50,637.50,'2022-12-03 17:15:54','',''),(190,'1','302','1',1,'Retail Sale Id 181',3503.36,0.00,0.00,4.76,242.76,'2022-12-03 17:23:41','',''),(191,'1','302','1',1,'Retail Sale Id 181',4600.00,0.00,0.00,6.25,318.75,'2022-12-03 17:23:41','',''),(192,'1','302','1',1,'Retail Sale Id 182',4496.96,0.00,0.00,6.11,311.61,'2022-12-03 17:29:22','',''),(193,'1','302','1',1,'Retail Sale Id 183',18400.00,0.00,0.00,25.00,1275.00,'2022-12-03 17:35:50','',''),(194,'1','302','1',1,'Retail Sale Id 184',736.00,0.00,0.00,1.00,51.00,'2022-12-03 17:44:24','',''),(195,'1','302','1',1,'Retail Sale Id 185',9200.00,0.00,0.00,12.50,637.50,'2022-12-03 17:45:24','',''),(196,'1','302','1',1,'Return of Retail Sale Id 184',0.00,736.00,1.00,0.00,-51.00,'2022-12-03 18:56:22','',''),(197,'1','302','1',1,'Retail Sale Id 186',699.20,0.00,0.00,0.95,48.45,'2022-12-03 18:57:19','',''),(198,'1','302','1',1,'Retail Sale Id 187',4423.36,0.00,0.00,6.01,306.51,'2022-12-04 07:31:22','',''),(199,'1','302','1',1,'Retail Sale Id 188',1501.44,0.00,0.00,2.04,104.04,'2022-12-04 07:41:36','',''),(200,'1','302','1',1,'Retail Sale Id 189',750.72,0.00,0.00,1.02,52.02,'2022-12-04 07:46:09','',''),(201,'1','302','1',1,'Retail Sale Id 190',2001.92,0.00,0.00,2.72,138.72,'2022-12-04 08:12:12','',''),(202,'1','302','1',1,'Retail Sale Id 192',3002.88,0.00,0.00,4.08,208.08,'2022-12-04 08:17:10','',''),(203,'1','302','1',1,'Retail Sale Id 193',1501.44,0.00,0.00,2.04,104.04,'2022-12-04 08:20:39','',''),(204,'1','302','1',1,'Retail Sale Id 194',4452.80,0.00,0.00,6.05,308.55,'2022-12-04 08:25:02','',''),(205,'1','302','1',1,'Retail Sale Id 195',9200.00,0.00,0.00,12.50,637.50,'2022-12-04 08:40:59','',''),(206,'1','302','1',1,'Retail Sale Id 196',3002.88,0.00,0.00,4.08,208.08,'2022-12-04 08:50:16','',''),(207,'1','302','1',1,'Retail Sale Id 197',2001.92,0.00,0.00,2.72,138.72,'2022-12-04 08:52:54','',''),(208,'1','302','1',1,'Retail Sale Id 198',3002.88,0.00,0.00,4.08,208.08,'2022-12-04 08:53:36','',''),(209,'1','302','1',1,'Retail Sale Id 199',9200.00,0.00,0.00,12.50,637.50,'2022-12-04 09:04:11','',''),(210,'1','302','1',1,'Retail Sale Id 201',4423.36,0.00,0.00,6.01,306.51,'2022-12-04 09:20:55','',''),(211,'1','302','1',1,'Retail Sale Id 202',3680.00,0.00,0.00,5.00,255.00,'2022-12-04 09:33:05','',''),(212,'1','302','1',1,'Retail Sale Id 203',2001.92,0.00,0.00,2.72,138.72,'2022-12-04 09:35:12','',''),(213,'1','302','1',1,'Retail Sale Id 204',4408.64,0.00,0.00,5.99,305.49,'2022-12-04 09:49:11','',''),(214,'1','302','1',1,'Retail Sale Id 205',3702.08,0.00,0.00,5.03,256.53,'2022-12-04 10:06:03','',''),(215,'1','302','1',1,'Retail Sale Id 206',4423.36,0.00,0.00,6.01,306.51,'2022-12-04 10:17:26','',''),(216,'1','302','1',1,'Retail Sale Id 207',1501.44,0.00,0.00,2.04,104.04,'2022-12-04 10:22:38','',''),(217,'1','302','1',1,'Retail Sale Id 208',750.72,0.00,0.00,1.02,52.02,'2022-12-04 10:38:06','',''),(218,'1','302','1',1,'Retail Sale Id 209',2200.64,0.00,0.00,2.99,152.49,'2022-12-04 10:42:02','',''),(219,'1','302','1',1,'Retail Sale Id 210',500.48,0.00,0.00,0.68,34.68,'2022-12-04 10:49:19','',''),(220,'1','302','1',1,'Retail Sale Id 210',1000.96,0.00,0.00,1.36,69.36,'2022-12-04 10:49:19','',''),(221,'1','302','1',1,'Retail Sale Id 211',9200.00,0.00,0.00,12.50,637.50,'2022-12-04 10:52:11','',''),(222,'1','302','1',1,'Retail Sale Id 212',7360.00,0.00,0.00,10.00,510.00,'2022-12-04 10:59:12','',''),(223,'1','302','1',1,'Retail Sale Id 213',4423.36,0.00,0.00,6.01,306.51,'2022-12-04 11:08:05','',''),(224,'1','302','1',1,'Retail Sale Id 214',3996.48,0.00,0.00,5.43,276.93,'2022-12-04 11:12:29','',''),(225,'1','302','1',1,'Retail Sale Id 215',3002.88,0.00,0.00,4.08,208.08,'2022-12-04 11:13:54','',''),(226,'1','302','1',1,'Retail Sale Id 216',9200.00,0.00,0.00,12.50,637.50,'2022-12-04 11:31:00','',''),(227,'1','302','1',1,'Retail Sale Id 217',9200.00,0.00,0.00,12.50,637.50,'2022-12-04 11:40:01','',''),(228,'1','302','1',1,'Retail Sale Id 218',2208.00,0.00,0.00,3.00,153.00,'2022-12-04 11:47:03','',''),(229,'1','302','1',1,'Retail Sale Id 218',3680.00,0.00,0.00,5.00,255.00,'2022-12-04 11:47:03','',''),(230,'1','302','1',1,'Retail Sale Id 220',9200.00,0.00,0.00,12.50,637.50,'2022-12-04 11:54:48','',''),(231,'1','302','1',1,'Retail Sale Id 221',4298.24,0.00,0.00,5.84,297.84,'2022-12-04 11:56:23','',''),(232,'1','302','1',1,'Retail Sale Id 222',9200.00,0.00,0.00,12.50,637.50,'2022-12-04 12:11:35','',''),(233,'1','302','1',1,'Retail Sale Id 223',4416.00,0.00,0.00,6.00,306.00,'2022-12-04 12:18:31','',''),(234,'1','302','1',1,'Retail Sale Id 225',2001.92,0.00,0.00,2.72,138.72,'2022-12-04 12:36:09','',''),(235,'1','302','1',1,'Retail Sale Id 226',2208.00,0.00,0.00,3.00,153.00,'2022-12-04 12:37:51','',''),(236,'1','302','1',1,'Retail Sale Id 227',1000.96,0.00,0.00,1.36,69.36,'2022-12-04 12:40:00','',''),(237,'1','302','1',1,'Retail Sale Id 228',9200.00,0.00,0.00,12.50,637.50,'2022-12-04 12:42:58','',''),(238,'1','302','1',1,'Retail Sale Id 229',2208.00,0.00,0.00,3.00,153.00,'2022-12-04 12:53:06','',''),(239,'1','302','1',1,'Retail Sale Id 230',4423.36,0.00,0.00,6.01,306.51,'2022-12-04 13:02:42','',''),(240,'1','302','1',1,'Retail Sale Id 231',9001.28,0.00,0.00,12.23,623.73,'2022-12-04 13:04:44','',''),(241,'1','302','1',1,'Retail Sale Id 232',743.36,0.00,0.00,1.01,51.51,'2022-12-04 13:26:25','',''),(242,'1','302','1',1,'Retail Sale Id 232',1479.36,0.00,0.00,2.01,102.51,'2022-12-04 13:26:25','',''),(243,'1','302','1',1,'Retail Sale Id 232',1479.36,0.00,0.00,2.01,102.51,'2022-12-04 13:26:25','',''),(244,'1','302','1',1,'Retail Sale Id 232',2200.64,0.00,0.00,2.99,152.49,'2022-12-04 13:26:25','',''),(245,'1','302','1',1,'Retail Sale Id 233',2200.64,0.00,0.00,2.99,152.49,'2022-12-04 13:27:49','',''),(246,'1','302','1',1,'Retail Sale Id 234',4423.36,0.00,0.00,6.01,306.51,'2022-12-04 13:34:21','',''),(247,'1','302','1',1,'Retail Sale Id 235',3002.88,0.00,0.00,4.08,208.08,'2022-12-04 14:10:13','',''),(248,'1','302','1',1,'Retail Sale Id 236',2208.00,0.00,0.00,3.00,153.00,'2022-12-04 14:12:52','',''),(249,'1','302','1',1,'Retail Sale Id 237',5998.40,0.00,0.00,8.15,415.65,'2022-12-04 14:18:44','',''),(250,'1','302','1',1,'Retail Sale Id 238',2208.00,0.00,0.00,3.00,153.00,'2022-12-04 14:22:48','',''),(251,'1','302','1',1,'Retail Sale Id 239',3680.00,0.00,0.00,5.00,255.00,'2022-12-04 14:34:55','',''),(252,'1','302','1',1,'Retail Sale Id 240',2001.92,0.00,0.00,2.72,138.72,'2022-12-04 14:56:36','',''),(253,'1','302','1',1,'Retail Sale Id 241',3002.88,0.00,0.00,4.08,208.08,'2022-12-04 15:04:20','',''),(254,'1','302','1',1,'Retail Sale Id 242',106500.00,0.00,0.00,150.00,3750.00,'2022-12-04 15:15:30','',''),(255,'1','302','1',1,'Retail Sale Id 243',4423.36,0.00,0.00,6.01,306.51,'2022-12-04 15:47:05','',''),(256,'1','302','1',1,'Retail Sale Id 244',2001.92,0.00,0.00,2.72,138.72,'2022-12-04 15:55:19','',''),(257,'1','302','1',1,'Retail Sale Id 245',4423.36,0.00,0.00,6.01,306.51,'2022-12-04 16:09:15','',''),(258,'1','302','1',1,'Retail Sale Id 245',4423.36,0.00,0.00,6.01,306.51,'2022-12-04 16:09:15','',''),(259,'1','302','1',1,'Retail Sale Id 246',9200.00,0.00,0.00,12.50,637.50,'2022-12-04 16:10:56','',''),(260,'1','302','1',1,'Retail Sale Id 247',743.36,0.00,0.00,1.01,51.51,'2022-12-04 16:23:18','',''),(261,'1','302','1',1,'Retail Sale Id 248',3680.00,0.00,0.00,5.00,255.00,'2022-12-04 16:24:25','',''),(262,'1','302','1',1,'Retail Sale Id 248',9200.00,0.00,0.00,12.50,637.50,'2022-12-04 16:24:25','',''),(263,'1','302','1',1,'Retail Sale Id 249',9200.00,0.00,0.00,12.50,637.50,'2022-12-04 17:10:15','',''),(264,'1','302','1',1,'Retail Sale Id 251',3680.00,0.00,0.00,5.00,255.00,'2022-12-04 17:11:57','',''),(265,'1','302','1',1,'Retail Sale Id 252',750.72,0.00,0.00,1.02,52.02,'2022-12-04 17:15:00','',''),(266,'1','302','1',1,'Retail Sale Id 252',2200.64,0.00,0.00,2.99,152.49,'2022-12-04 17:15:00','',''),(267,'1','302','1',1,'Retail Sale Id 253',3702.08,0.00,0.00,5.03,256.53,'2022-12-04 17:22:06','',''),(268,'1','302','1',1,'Retail Sale Id 254',2222.72,0.00,0.00,3.02,154.02,'2022-12-04 17:23:09','',''),(269,'1','302','1',1,'Retail Sale Id 255',2200.64,0.00,0.00,2.99,152.49,'2022-12-04 17:29:46','',''),(270,'1','302','1',1,'Retail Sale Id 256',2001.92,0.00,0.00,2.72,138.72,'2022-12-04 17:38:44','',''),(271,'1','302','1',1,'Retail Sale Id 258',4401.28,0.00,0.00,5.98,304.98,'2022-12-04 17:57:41','',''),(272,'1','302','1',1,'Retail Sale Id 259',9200.00,0.00,0.00,12.50,637.50,'2022-12-04 18:02:55','',''),(273,'1','302','1',1,'Retail Sale Id 259',9200.00,0.00,0.00,12.50,637.50,'2022-12-04 18:02:55','',''),(274,'1','302','1',1,'Retail Sale Id 260',2200.64,0.00,0.00,2.99,152.49,'2022-12-04 18:04:01','',''),(275,'1','302','1',1,'Retail Sale Id 264',920.00,0.00,0.00,1.25,63.75,'2022-12-04 19:12:36','',''),(276,'1','302','1',1,'Retail Sale Id 265',2001.92,0.00,0.00,2.72,138.72,'2022-12-05 07:24:06','',''),(277,'1','302','1',1,'Retail Sale Id 266',4416.00,0.00,0.00,6.00,306.00,'2022-12-05 07:41:59','',''),(278,'1','302','1',1,'Retail Sale Id 267',9200.00,0.00,0.00,12.50,637.50,'2022-12-05 07:51:12','',''),(279,'1','302','1',1,'Retail Sale Id 268',3996.48,0.00,0.00,5.43,276.93,'2022-12-05 07:52:36','',''),(280,'1','302','1',1,'Retail Sale Id 268',3996.48,0.00,0.00,5.43,276.93,'2022-12-05 07:52:36','',''),(281,'1','302','1',1,'Retail Sale Id 269',4496.96,0.00,0.00,6.11,311.61,'2022-12-05 08:08:04','',''),(282,'1','302','1',1,'Retail Sale Id 270',3002.88,0.00,0.00,4.08,208.08,'2022-12-05 08:12:18','',''),(283,'1','302','1',1,'Retail Sale Id 271',4496.96,0.00,0.00,6.11,311.61,'2022-12-05 08:29:01','',''),(284,'1','302','1',1,'Retail Sale Id 272',1000.96,0.00,0.00,1.36,69.36,'2022-12-05 08:47:29','',''),(285,'1','302','1',1,'Retail Sale Id 273',3002.88,0.00,0.00,4.08,208.08,'2022-12-05 08:50:26','',''),(286,'1','302','1',1,'Retail Sale Id 274',5152.00,0.00,0.00,7.00,357.00,'2022-12-05 08:52:34','',''),(287,'1','302','1',1,'Retail Sale Id 275',7360.00,0.00,0.00,10.00,510.00,'2022-12-05 08:54:03','',''),(288,'1','302','1',1,'Retail Sale Id 276',802.24,0.00,0.00,1.09,55.59,'2022-12-05 08:59:15','',''),(289,'1','302','1',1,'Retail Sale Id 277',3702.08,0.00,0.00,5.03,256.53,'2022-12-05 09:11:26','',''),(290,'1','302','1',1,'Retail Sale Id 278',2208.00,0.00,0.00,3.00,153.00,'2022-12-05 09:13:53','',''),(291,'1','302','1',1,'Retail Sale Id 279',35500.00,0.00,0.00,50.00,1250.00,'2022-12-05 09:17:20','',''),(292,'1','302','1',1,'Retail Sale Id 280',7499.84,0.00,0.00,10.19,519.69,'2022-12-05 09:19:07','',''),(293,'1','302','1',1,'Retail Sale Id 281',4416.00,0.00,0.00,6.00,306.00,'2022-12-05 09:39:01','',''),(294,'1','302','1',1,'Retail Sale Id 282',8000.32,0.00,0.00,10.87,554.37,'2022-12-05 10:07:50','',''),(295,'1','302','1',1,'Retail Sale Id 284',2200.64,0.00,0.00,2.99,152.49,'2022-12-05 10:35:11','',''),(296,'1','302','1',1,'Retail Sale Id 285',3002.88,0.00,0.00,4.08,208.08,'2022-12-05 11:07:03','',''),(297,'1','302','1',1,'Retail Sale Id 286',4416.00,0.00,0.00,6.00,306.00,'2022-12-05 11:13:29','',''),(298,'1','302','1',1,'Retail Sale Id 287',5888.00,0.00,0.00,8.00,408.00,'2022-12-05 11:23:42','',''),(299,'1','302','1',1,'Retail Sale Id 288',18400.00,0.00,0.00,25.00,1275.00,'2022-12-05 11:26:13','',''),(300,'1','302','1',1,'Retail Sale Id 289',2208.00,0.00,0.00,3.00,153.00,'2022-12-05 11:33:23','',''),(301,'1','302','1',1,'Retail Sale Id 289',9200.00,0.00,0.00,12.50,637.50,'2022-12-05 11:33:23','',''),(302,'1','302','1',1,'Retail Sale Id 290',33370.00,0.00,0.00,47.00,1175.00,'2022-12-05 11:35:49','',''),(303,'1','302','1',1,'Retail Sale Id 291',9200.00,0.00,0.00,12.50,637.50,'2022-12-05 11:37:58','',''),(304,'1','302','1',1,'Retail Sale Id 292',2208.00,0.00,0.00,3.00,153.00,'2022-12-05 12:34:17','',''),(305,'1','302','1',1,'Retail Sale Id 292',4416.00,0.00,0.00,6.00,306.00,'2022-12-05 12:34:17','',''),(306,'1','302','1',1,'Retail Sale Id 293',736.00,0.00,0.00,1.00,51.00,'2022-12-05 12:41:16','',''),(307,'1','302','1',1,'Retail Sale Id 294',1501.44,0.00,0.00,2.04,104.04,'2022-12-05 12:52:34','',''),(308,'1','302','1',1,'Retail Sale Id 295',4416.00,0.00,0.00,6.00,306.00,'2022-12-05 12:57:00','',''),(309,'1','302','1',1,'Retail Sale Id 296',2208.00,0.00,0.00,3.00,153.00,'2022-12-05 13:07:48','',''),(310,'1','302','1',1,'Retail Sale Id 297',9200.00,0.00,0.00,12.50,637.50,'2022-12-05 13:10:53','',''),(311,'1','302','1',1,'Retail Sale Id 298',1000.96,0.00,0.00,1.36,69.36,'2022-12-05 13:11:44','',''),(312,'1','302','1',1,'Retail Sale Id 299',1501.44,0.00,0.00,2.04,104.04,'2022-12-05 13:19:47','',''),(313,'1','302','1',1,'Retail Sale Id 300',802.24,0.00,0.00,1.09,55.59,'2022-12-05 13:23:34','',''),(314,'1','302','1',1,'Retail Sale Id 301',1000.96,0.00,0.00,1.36,69.36,'2022-12-05 13:25:13','',''),(315,'1','302','1',1,'Retail Sale Id 302',4496.96,0.00,0.00,6.11,311.61,'2022-12-05 15:19:38','',''),(316,'1','302','1',1,'Retail Sale Id 303',9200.00,0.00,0.00,12.50,637.50,'2022-12-05 15:20:39','',''),(317,'1','302','1',1,'Retail Sale Id 304',2502.40,0.00,0.00,3.40,173.40,'2022-12-05 15:21:16','',''),(318,'1','302','1',1,'Retail Sale Id 305',4496.96,0.00,0.00,6.11,311.61,'2022-12-05 15:22:24','',''),(319,'1','302','1',1,'Retail Sale Id 306',9200.00,0.00,0.00,12.50,637.50,'2022-12-05 15:45:27','',''),(320,'1','302','1',1,'Retail Sale Id 307',1501.44,0.00,0.00,2.04,104.04,'2022-12-05 15:59:30','',''),(321,'1','302','1',1,'Retail Sale Id 308',1501.44,0.00,0.00,2.04,104.04,'2022-12-05 16:01:53','',''),(322,'1','302','1',1,'Retail Sale Id 309',3680.00,0.00,0.00,5.00,255.00,'2022-12-05 16:14:59','',''),(323,'1','302','1',1,'Retail Sale Id 310',2502.40,0.00,0.00,3.40,173.40,'2022-12-05 16:18:18','',''),(324,'1','302','1',1,'Retail Sale Id 311',2208.00,0.00,0.00,3.00,153.00,'2022-12-05 16:23:16','',''),(325,'1','302','1',1,'Retail Sale Id 312',4496.96,0.00,0.00,6.11,311.61,'2022-12-05 16:28:48','',''),(326,'1','302','1',1,'Retail Sale Id 313',2001.92,0.00,0.00,2.72,138.72,'2022-12-05 16:38:37','',''),(327,'1','302','1',1,'Retail Sale Id 313',2001.92,0.00,0.00,2.72,138.72,'2022-12-05 16:38:37','',''),(328,'1','302','1',1,'Retail Sale Id 313',2001.92,0.00,0.00,2.72,138.72,'2022-12-05 16:38:37','',''),(329,'1','302','1',1,'Retail Sale Id 314',9200.00,0.00,0.00,12.50,637.50,'2022-12-05 16:46:43','',''),(330,'1','302','1',1,'Retail Sale Id 315',4997.44,0.00,0.00,6.79,346.29,'2022-12-05 16:54:54','',''),(331,'1','302','1',1,'Retail Sale Id 316',3503.36,0.00,0.00,4.76,242.76,'2022-12-05 17:12:06','',''),(332,'1','302','1',1,'Retail Sale Id 317',3002.88,0.00,0.00,4.08,208.08,'2022-12-05 17:17:26','',''),(333,'1','302','1',1,'Retail Sale Id 318',3002.88,0.00,0.00,4.08,208.08,'2022-12-05 17:18:23','',''),(334,'1','302','1',1,'Retail Sale Id 319',4496.96,0.00,0.00,6.11,311.61,'2022-12-05 17:31:10','',''),(335,'1','302','1',1,'Retail Sale Id 320',9200.00,0.00,0.00,12.50,637.50,'2022-12-05 17:46:05','',''),(336,'1','302','1',1,'Retail Sale Id 321',4496.96,0.00,0.00,6.11,311.61,'2022-12-05 17:56:50','',''),(337,'1','302','1',1,'Retail Sale Id 322',9001.28,0.00,0.00,12.23,623.73,'2022-12-05 17:57:49','',''),(338,'1','302','1',1,'Retail Sale Id 323',2001.92,0.00,0.00,2.72,138.72,'2022-12-05 18:04:36','',''),(339,'1','302','1',1,'Retail Sale Id 325',22.08,0.00,0.00,0.03,1.53,'2022-12-05 18:31:23','',''),(340,'1','302','1',1,'Retail Sale Id 326',1803.20,0.00,0.00,2.45,124.95,'2022-12-06 07:26:27','',''),(341,'1','302','1',1,'Retail Sale Id 327',4496.96,0.00,0.00,6.11,311.61,'2022-12-06 08:10:54','',''),(342,'1','302','1',1,'Retail Sale Id 328',1000.96,0.00,0.00,1.36,69.36,'2022-12-06 08:44:26','',''),(343,'1','302','1',1,'Retail Sale Id 329',1000.96,0.00,0.00,1.36,69.36,'2022-12-06 08:50:52','',''),(344,'1','302','1',1,'Retail Sale Id 330',9200.00,0.00,0.00,12.50,637.50,'2022-12-06 09:01:48','',''),(345,'1','302','1',1,'Retail Sale Id 331',2200.64,0.00,0.00,2.99,152.49,'2022-12-06 09:03:36','',''),(346,'1','302','1',1,'Retail Sale Id 332',3996.48,0.00,0.00,5.43,276.93,'2022-12-06 09:06:34','',''),(347,'1','302','1',1,'Retail Sale Id 333',2502.40,0.00,0.00,3.40,173.40,'2022-12-06 09:17:29','',''),(348,'1','302','1',1,'Retail Sale Id 334',3002.88,0.00,0.00,4.08,208.08,'2022-12-06 09:27:57','',''),(349,'1','302','1',1,'Retail Sale Id 335',3002.88,0.00,0.00,4.08,208.08,'2022-12-06 09:28:43','',''),(350,'1','302','1',1,'Retail Sale Id 336',2208.00,0.00,0.00,3.00,153.00,'2022-12-06 09:40:13','',''),(351,'1','302','1',1,'Retail Sale Id 337',1501.44,0.00,0.00,2.04,104.04,'2022-12-06 09:44:31','',''),(352,'1','302','1',1,'Retail Sale Id 338',1199.68,0.00,0.00,1.63,83.13,'2022-12-06 10:06:57','',''),(353,'1','302','1',1,'Retail Sale Id 339',3002.88,0.00,0.00,4.08,208.08,'2022-12-06 10:11:08','',''),(354,'1','302','1',1,'Retail Sale Id 340',2208.00,0.00,0.00,3.00,153.00,'2022-12-06 10:14:34','',''),(355,'1','302','1',1,'Retail Sale Id 341',3002.88,0.00,0.00,4.08,208.08,'2022-12-06 10:28:44','',''),(356,'1','302','1',1,'Retail Sale Id 342',2252.16,0.00,0.00,3.06,156.06,'2022-12-06 10:32:09','',''),(357,'1','302','1',1,'Retail Sale Id 343',2252.16,0.00,0.00,3.06,156.06,'2022-12-06 10:32:47','',''),(358,'1','302','1',1,'Retail Sale Id 344',802.24,0.00,0.00,1.09,55.59,'2022-12-06 10:52:23','',''),(359,'1','302','1',1,'Retail Sale Id 345',3002.88,0.00,0.00,4.08,208.08,'2022-12-06 11:02:02','',''),(360,'1','302','1',1,'Retail Sale Id 346',2502.40,0.00,0.00,3.40,173.40,'2022-12-06 11:09:30','',''),(361,'1','302','1',1,'Retail Sale Id 347',4496.96,0.00,0.00,6.11,311.61,'2022-12-06 11:11:05','',''),(362,'1','302','1',1,'Retail Sale Id 348',4496.96,0.00,0.00,6.11,311.61,'2022-12-06 11:26:37','',''),(363,'1','302','1',1,'Retail Sale Id 349',4423.36,0.00,0.00,6.01,306.51,'2022-12-06 12:10:03','',''),(364,'1','302','1',1,'Retail Sale Id 350',1501.44,0.00,0.00,2.04,104.04,'2022-12-06 12:11:07','',''),(365,'1','302','1',1,'Retail Sale Id 351',9200.00,0.00,0.00,12.50,637.50,'2022-12-06 12:12:28','',''),(366,'1','302','1',1,'Retail Sale Id 352',2200.64,0.00,0.00,2.99,152.49,'2022-12-06 12:13:23','',''),(367,'1','302','1',1,'Retail Sale Id 353',5888.00,0.00,0.00,8.00,408.00,'2022-12-06 12:17:58','',''),(368,'1','302','1',1,'Retail Sale Id 355',9200.00,0.00,0.00,12.50,637.50,'2022-12-06 12:24:01','',''),(369,'1','302','1',1,'Retail Sale Id 356',2208.00,0.00,0.00,3.00,153.00,'2022-12-06 12:53:30','',''),(370,'1','302','1',1,'Retail Sale Id 357',3002.88,0.00,0.00,4.08,208.08,'2022-12-06 12:54:15','',''),(371,'1','302','1',1,'Retail Sale Id 358',3002.88,0.00,0.00,4.08,208.08,'2022-12-06 12:57:19','',''),(372,'1','302','1',1,'Retail Sale Id 359',802.24,0.00,0.00,1.09,55.59,'2022-12-06 13:16:26','',''),(373,'1','302','1',1,'Retail Sale Id 361',2208.00,0.00,0.00,3.00,153.00,'2022-12-06 13:23:31','',''),(374,'1','302','1',1,'Retail Sale Id 362',1501.44,0.00,0.00,2.04,104.04,'2022-12-06 13:29:33','',''),(375,'1','302','1',1,'Retail Sale Id 363',2208.00,0.00,0.00,3.00,153.00,'2022-12-06 13:37:39','',''),(376,'1','302','1',1,'Retail Sale Id 365',3680.00,0.00,0.00,5.00,255.00,'2022-12-06 13:42:13','',''),(377,'1','302','1',1,'Retail Sale Id 366',3680.00,0.00,0.00,5.00,255.00,'2022-12-06 14:25:46','',''),(378,'1','302','1',1,'Retail Sale Id 367',500.48,0.00,0.00,0.68,34.68,'2022-12-06 16:32:12','',''),(379,'1','302','1',1,'Retail Sale Id 368',4423.36,0.00,0.00,6.01,306.51,'2022-12-06 16:36:07','',''),(380,'1','302','1',1,'Retail Sale Id 369',4452.80,0.00,0.00,6.05,308.55,'2022-12-06 16:37:37','',''),(381,'1','302','1',1,'Retail Sale Id 370',4423.36,0.00,0.00,6.01,306.51,'2022-12-06 16:38:31','',''),(382,'1','302','1',1,'Retail Sale Id 371',16199.36,0.00,0.00,22.01,1122.51,'2022-12-06 16:45:43','',''),(383,'1','302','1',1,'Retail Sale Id 372',3002.88,0.00,0.00,4.08,208.08,'2022-12-06 16:46:42','',''),(384,'1','302','1',1,'Retail Sale Id 373',2200.64,0.00,0.00,2.99,152.49,'2022-12-06 16:47:54','',''),(385,'1','302','1',1,'Retail Sale Id 374',27600.00,0.00,0.00,37.50,1912.50,'2022-12-06 17:13:01','',''),(386,'1','302','1',1,'Retail Sale Id 375',1479.36,0.00,0.00,2.01,102.51,'2022-12-06 17:45:22','',''),(387,'1','302','1',1,'Return of Retail Sale Id 367',0.00,500.48,0.68,0.00,-34.68,'2022-12-06 18:32:22','',''),(388,'1','302','1',1,'Retail Sale Id 376',493.12,0.00,0.00,0.67,34.17,'2022-12-06 18:33:36','',''),(389,'1','302','1',1,'Retail Sale Id 378',4496.96,0.00,0.00,6.11,311.61,'2022-12-07 08:34:10','',''),(390,'1','302','1',1,'Retail Sale Id 379',802.24,0.00,0.00,1.09,55.59,'2022-12-07 08:35:36','',''),(391,'1','302','1',1,'Retail Sale Id 380',1479.36,0.00,0.00,2.01,102.51,'2022-12-07 08:36:48','',''),(392,'1','302','1',1,'Retail Sale Id 381',9200.00,0.00,0.00,12.50,637.50,'2022-12-07 08:37:47','',''),(393,'1','302','1',1,'Retail Sale Id 382',2208.00,0.00,0.00,3.00,153.00,'2022-12-07 08:39:42','',''),(394,'1','302','1',1,'Retail Sale Id 383',3672.64,0.00,0.00,4.99,254.49,'2022-12-07 09:11:05','',''),(395,'1','302','1',1,'Retail Sale Id 384',2208.00,0.00,0.00,3.00,153.00,'2022-12-07 09:26:00','',''),(396,'1','302','1',1,'Retail Sale Id 385',802.24,0.00,0.00,1.09,55.59,'2022-12-07 09:34:34','',''),(397,'1','302','1',1,'Retail Sale Id 386',4423.36,0.00,0.00,6.01,306.51,'2022-12-07 09:55:44','',''),(398,'1','302','1',1,'Retail Sale Id 387',3783.04,0.00,0.00,5.14,262.14,'2022-12-07 10:33:52','',''),(399,'1','302','1',1,'Retail Sale Id 388',4496.96,0.00,0.00,6.11,311.61,'2022-12-07 10:41:41','',''),(400,'1','302','1',1,'Retail Sale Id 390',4416.00,0.00,0.00,6.00,306.00,'2022-12-07 10:58:05','',''),(401,'1','302','1',1,'Retail Sale Id 390',9200.00,0.00,0.00,12.50,637.50,'2022-12-07 10:58:05','',''),(402,'1','302','1',1,'Retail Sale Id 398',2001.92,0.00,0.00,2.72,138.72,'2022-12-07 11:07:00','',''),(403,'1','302','1',1,'Retail Sale Id 399',2303.68,0.00,0.00,3.13,159.63,'2022-12-07 11:13:01','',''),(404,'1','302','1',1,'Retail Sale Id 400',11098.88,0.00,0.00,15.08,769.08,'2022-12-07 11:17:24','',''),(405,'1','302','1',1,'Retail Sale Id 401',3996.48,0.00,0.00,5.43,276.93,'2022-12-07 11:36:55','',''),(406,'1','302','1',1,'Retail Sale Id 402',3002.88,0.00,0.00,4.08,208.08,'2022-12-07 11:51:40','',''),(407,'1','302','1',1,'Retail Sale Id 403',9200.00,0.00,0.00,12.50,637.50,'2022-12-07 12:11:08','',''),(408,'1','302','1',1,'Retail Sale Id 404',9200.00,0.00,0.00,12.50,637.50,'2022-12-07 12:22:23','',''),(409,'1','302','1',1,'Retail Sale Id 406',9200.00,0.00,0.00,12.50,637.50,'2022-12-07 12:28:54','',''),(410,'1','302','1',1,'Retail Sale Id 407',802.24,0.00,0.00,1.09,55.59,'2022-12-07 12:40:24','',''),(411,'1','302','1',1,'Retail Sale Id 408',9200.00,0.00,0.00,12.50,637.50,'2022-12-07 12:41:39','',''),(412,'1','302','1',1,'Retail Sale Id 409',2502.40,0.00,0.00,3.40,173.40,'2022-12-07 12:47:12','',''),(413,'1','302','1',1,'Retail Sale Id 410',2502.40,0.00,0.00,3.40,173.40,'2022-12-07 12:48:41','',''),(414,'1','302','1',1,'Retail Sale Id 411',2200.64,0.00,0.00,2.99,152.49,'2022-12-07 12:58:02','',''),(415,'1','302','1',1,'Retail Sale Id 412',7301.12,0.00,0.00,9.92,505.92,'2022-12-07 13:04:01','',''),(416,'1','302','1',1,'Retail Sale Id 413',5152.00,0.00,0.00,7.00,357.00,'2022-12-07 13:10:09','',''),(417,'1','302','1',1,'Retail Sale Id 414',3702.08,0.00,0.00,5.03,256.53,'2022-12-07 13:11:22','',''),(418,'1','302','1',1,'Retail Sale Id 415',802.24,0.00,0.00,1.09,55.59,'2022-12-07 13:15:42','',''),(419,'1','302','1',1,'Retail Sale Id 416',2001.92,0.00,0.00,2.72,138.72,'2022-12-07 13:29:52','',''),(420,'1','302','1',1,'Retail Sale Id 417',802.24,0.00,0.00,1.09,55.59,'2022-12-07 13:33:29','',''),(421,'1','302','1',1,'Retail Sale Id 418',4401.28,0.00,0.00,5.98,304.98,'2022-12-07 13:35:35','',''),(422,'1','302','1',1,'Retail Sale Id 419',9200.00,0.00,0.00,12.50,637.50,'2022-12-07 13:46:42','',''),(423,'1','302','1',1,'Retail Sale Id 420',1000.96,0.00,0.00,1.36,69.36,'2022-12-07 13:59:40','',''),(424,'1','302','1',1,'Retail Sale Id 421',9001.28,0.00,0.00,12.23,623.73,'2022-12-07 14:01:21','',''),(425,'1','302','1',1,'Retail Sale Id 422',9200.00,0.00,0.00,12.50,637.50,'2022-12-07 14:06:31','',''),(426,'1','302','1',1,'Retail Sale Id 423',3002.88,0.00,0.00,4.08,208.08,'2022-12-07 14:32:24','',''),(427,'1','302','1',1,'Retail Sale Id 424',3503.36,0.00,0.00,4.76,242.76,'2022-12-07 14:50:35','',''),(428,'1','302','1',1,'Retail Sale Id 425',2303.68,0.00,0.00,3.13,159.63,'2022-12-07 14:53:30','',''),(429,'1','302','1',1,'Retail Sale Id 426',1000.96,0.00,0.00,1.36,69.36,'2022-12-07 15:07:13','',''),(430,'1','302','1',1,'Retail Sale Id 427',3002.88,0.00,0.00,4.08,208.08,'2022-12-07 15:16:34','',''),(431,'1','302','1',1,'Retail Sale Id 428',1803.20,0.00,0.00,2.45,124.95,'2022-12-07 15:42:15','',''),(432,'1','302','1',1,'Retail Sale Id 429',17750.00,0.00,0.00,25.00,625.00,'2022-12-07 15:52:18','',''),(433,'1','302','1',1,'Retail Sale Id 430',3702.08,0.00,0.00,5.03,256.53,'2022-12-07 16:21:36','',''),(434,'1','302','1',1,'Retail Sale Id 431',1472.00,0.00,0.00,2.00,102.00,'2022-12-07 16:29:44','',''),(435,'1','302','1',1,'Retail Sale Id 432',9200.00,0.00,0.00,12.50,637.50,'2022-12-07 16:31:42','',''),(436,'1','302','1',1,'Retail Sale Id 433',2222.72,0.00,0.00,3.02,154.02,'2022-12-07 16:34:19','',''),(437,'1','302','1',1,'Retail Sale Id 434',2303.68,0.00,0.00,3.13,159.63,'2022-12-07 16:40:34','',''),(438,'1','302','1',1,'Retail Sale Id 435',2001.92,0.00,0.00,2.72,138.72,'2022-12-07 17:18:37','',''),(439,'1','302','1',1,'Retail Sale Id 436',35500.00,0.00,0.00,50.00,1250.00,'2022-12-07 17:29:20','',''),(440,'1','302','1',1,'Retail Sale Id 437',9200.00,0.00,0.00,12.50,637.50,'2022-12-07 17:34:06','',''),(441,'1','302','1',1,'Retail Sale Id 438',4416.00,0.00,0.00,6.00,306.00,'2022-12-07 17:42:06','',''),(442,'1','302','1',1,'Retail Sale Id 439',28400.00,0.00,0.00,40.00,1000.00,'2022-12-07 17:49:29','',''),(443,'1','302','1',1,'Retail Sale Id 440',802.24,0.00,0.00,1.09,55.59,'2022-12-07 17:50:26','',''),(444,'1','302','1',1,'Retail Sale Id 441',4496.96,0.00,0.00,6.11,311.61,'2022-12-07 18:01:05','',''),(445,'1','302','1',1,'Retail Sale Id 442',58.88,0.00,0.00,0.08,4.08,'2022-12-07 18:31:43','',''),(446,'1','302','1',1,'Retail Sale Id 443',4452.80,0.00,0.00,6.05,308.55,'2022-12-08 07:56:02','',''),(447,'1','302','1',1,'Retail Sale Id 444',3680.00,0.00,0.00,5.00,255.00,'2022-12-08 08:37:47','',''),(448,'1','302','1',1,'Retail Sale Id 445',4423.36,0.00,0.00,6.01,306.51,'2022-12-08 08:49:09','',''),(449,'1','302','1',1,'Retail Sale Id 445',18400.00,0.00,0.00,25.00,1275.00,'2022-12-08 08:49:09','',''),(450,'1','302','1',1,'Retail Sale Id 446',2001.92,0.00,0.00,2.72,138.72,'2022-12-08 09:16:19','',''),(451,'1','302','1',1,'Retail Sale Id 447',9200.00,0.00,0.00,12.50,637.50,'2022-12-08 09:25:57','',''),(452,'1','302','1',1,'Retail Sale Id 448',3002.88,0.00,0.00,4.08,208.08,'2022-12-08 09:44:05','',''),(453,'1','302','1',1,'Retail Sale Id 449',3002.88,0.00,0.00,4.08,208.08,'2022-12-08 10:24:46','',''),(454,'1','302','1',1,'Retail Sale Id 450',2001.92,0.00,0.00,2.72,138.72,'2022-12-08 10:25:35','',''),(455,'1','302','1',1,'Retail Sale Id 451',4401.28,0.00,0.00,5.98,304.98,'2022-12-08 10:40:40','',''),(456,'1','302','1',1,'Retail Sale Id 452',2112.32,0.00,0.00,2.87,146.37,'2022-12-08 10:50:59','',''),(457,'1','302','1',1,'Retail Sale Id 453',3503.36,0.00,0.00,4.76,242.76,'2022-12-08 10:53:02','',''),(458,'1','302','1',1,'Retail Sale Id 454',2200.64,0.00,0.00,2.99,152.49,'2022-12-08 10:54:30','',''),(459,'1','302','1',1,'Retail Sale Id 456',35500.00,0.00,0.00,50.00,1250.00,'2022-12-08 11:02:31','',''),(460,'1','302','1',1,'Retail Sale Id 457',9200.00,0.00,0.00,12.50,637.50,'2022-12-08 11:08:30','',''),(461,'1','302','1',1,'Retail Sale Id 458',4423.36,0.00,0.00,6.01,306.51,'2022-12-08 11:14:02','',''),(462,'1','302','1',1,'Retail Sale Id 459',9200.00,0.00,0.00,12.50,637.50,'2022-12-08 11:16:01','',''),(463,'1','302','1',1,'Retail Sale Id 460',3996.48,0.00,0.00,5.43,276.93,'2022-12-08 11:23:00','',''),(464,'1','302','1',1,'Retail Sale Id 461',1501.44,0.00,0.00,2.04,104.04,'2022-12-08 11:33:02','',''),(465,'1','302','1',1,'Retail Sale Id 462',2001.92,0.00,0.00,2.72,138.72,'2022-12-08 11:38:11','',''),(466,'1','302','1',1,'Retail Sale Id 463',3650.56,0.00,0.00,4.96,252.96,'2022-12-08 11:56:48','',''),(467,'1','302','1',1,'Retail Sale Id 464',2252.16,0.00,0.00,3.06,156.06,'2022-12-08 11:58:21','',''),(468,'1','302','1',1,'Retail Sale Id 465',9200.00,0.00,0.00,12.50,637.50,'2022-12-08 12:03:20','',''),(469,'1','302','1',1,'Retail Sale Id 466',3702.08,0.00,0.00,5.03,256.53,'2022-12-08 12:12:46','',''),(470,'1','302','1',1,'Retail Sale Id 467',4496.96,0.00,0.00,6.11,311.61,'2022-12-08 12:17:44','',''),(471,'1','302','1',1,'Retail Sale Id 468',3996.48,0.00,0.00,5.43,276.93,'2022-12-08 12:22:35','',''),(472,'1','302','1',1,'Retail Sale Id 469',2097.60,0.00,0.00,2.85,145.35,'2022-12-08 12:33:12','',''),(473,'1','302','1',1,'Retail Sale Id 470',4496.96,0.00,0.00,6.11,311.61,'2022-12-08 12:50:03','',''),(474,'1','302','1',1,'Retail Sale Id 471',10002.24,0.00,0.00,13.59,693.09,'2022-12-08 12:58:42','',''),(475,'1','302','1',1,'Retail Sale Id 471',10002.24,0.00,0.00,13.59,693.09,'2022-12-08 12:58:42','',''),(476,'1','302','1',1,'Retail Sale Id 472',8500.80,0.00,0.00,11.55,589.05,'2022-12-08 13:02:53','',''),(477,'1','302','1',1,'Retail Sale Id 473',10002.24,0.00,0.00,13.59,693.09,'2022-12-08 13:07:05','',''),(478,'1','302','1',1,'Retail Sale Id 473',10002.24,0.00,0.00,13.59,693.09,'2022-12-08 13:07:05','',''),(479,'1','302','1',1,'Retail Sale Id 474',3002.88,0.00,0.00,4.08,208.08,'2022-12-08 13:10:25','',''),(480,'1','302','1',1,'Retail Sale Id 475',9200.00,0.00,0.00,12.50,637.50,'2022-12-08 13:31:53','',''),(481,'1','302','1',1,'Retail Sale Id 476',2208.00,0.00,0.00,3.00,153.00,'2022-12-08 14:14:33','',''),(482,'1','302','1',1,'Retail Sale Id 477',4496.96,0.00,0.00,6.11,311.61,'2022-12-08 14:25:39','',''),(483,'1','302','1',1,'Retail Sale Id 478',4496.96,0.00,0.00,6.11,311.61,'2022-12-08 14:27:56','',''),(484,'1','302','1',1,'Retail Sale Id 479',9200.00,0.00,0.00,12.50,637.50,'2022-12-08 14:46:16','',''),(485,'1','302','1',1,'Retail Sale Id 481',1000.96,0.00,0.00,1.36,69.36,'2022-12-08 14:50:46','',''),(486,'1','302','1',1,'Retail Sale Id 482',3002.88,0.00,0.00,4.08,208.08,'2022-12-08 14:59:47','',''),(487,'1','302','1',1,'Retail Sale Id 483',500.48,0.00,0.00,0.68,34.68,'2022-12-08 15:00:40','',''),(488,'1','302','1',1,'Retail Sale Id 484',1501.44,0.00,0.00,2.04,104.04,'2022-12-08 15:02:10','',''),(489,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,149288.90,217.94,0.00,0.00,'2022-12-08 19:23:11','',''),(490,'1','302',NULL,1,'Reception corrector for bridging 2',0.00,0.00,0.00,217.94,0.00,'2022-12-08 19:25:47','',''),(491,'1','302','1',1,'Received from bridging 2',0.00,0.00,217.94,0.00,0.00,'2022-12-08 19:25:47','',''),(492,'1','302','1',1,'Retail Sale Id 486',128365.76,0.00,0.00,174.41,8894.91,'2022-12-08 19:27:05','',''),(493,'1','302','1',1,'Retail Sale Id 487',17750.00,0.00,0.00,25.00,625.00,'2022-12-08 19:27:55','',''),(494,'1','302','1',1,'Retail Sale Id 488',1501.44,0.00,0.00,2.04,104.04,'2022-12-09 07:49:57','',''),(495,'1','302','1',1,'Retail Sale Id 489',3002.88,0.00,0.00,4.08,208.08,'2022-12-09 08:00:34','',''),(496,'1','302','1',1,'Retail Sale Id 490',2502.40,0.00,0.00,3.40,173.40,'2022-12-09 08:09:21','',''),(497,'1','302','1',1,'Retail Sale Id 491',2502.40,0.00,0.00,3.40,173.40,'2022-12-09 08:22:18','',''),(498,'1','302','1',1,'Retail Sale Id 492',4496.96,0.00,0.00,6.11,311.61,'2022-12-09 08:34:51','',''),(499,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,261341.20,381.52,0.00,0.00,'2022-12-09 15:23:48','',''),(500,'1','302',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,381.52,0.00,'2022-12-09 15:24:48','',''),(501,'1','302','1',1,'Received from bridging 3',0.00,0.00,381.52,0.00,0.00,'2022-12-09 15:24:48','',''),(502,'1','302','1',1,'Retail Sale Id 493',167226.56,0.00,0.00,227.21,11587.71,'2022-12-09 15:25:50','',''),(503,'1','302','1',1,'Retail Sale Id 494',110248.80,0.00,0.00,155.28,3882.00,'2022-12-09 15:26:55','',''),(504,'1','302','1',1,'Return of Retail Sale Id 494',0.00,110248.80,155.28,0.00,-3882.00,'2022-12-09 15:30:35','',''),(505,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,13508.20,19.72,0.00,0.00,'2022-12-09 15:32:16','',''),(506,'1','302',NULL,1,'Reception corrector for bridging 4',0.00,0.00,0.00,19.72,0.00,'2022-12-09 15:33:06','',''),(507,'1','302','1',1,'Received from bridging 4',0.00,0.00,19.72,0.00,0.00,'2022-12-09 15:33:06','',''),(508,'1','302','1',1,'Retail Sale Id 495',124250.00,0.00,0.00,175.00,4375.00,'2022-12-09 15:33:56','',''),(509,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3380000.00,5000.00,0.00,0.00,'2022-12-09 17:12:27','',''),(510,'1','302',NULL,1,'Reception corrector for bridging 5',0.00,0.00,0.00,5000.00,0.00,'2022-12-09 17:15:14','',''),(511,'1','302','1',1,'Received from bridging 5',0.00,0.00,5000.00,0.00,0.00,'2022-12-09 17:15:14','',''),(512,'1','302','1',1,'Retail Sale Id 496',4496.96,0.00,0.00,6.11,366.60,'2022-12-09 17:28:22','',''),(513,'1','302','1',1,'Retail Sale Id 497',80135.68,0.00,0.00,108.88,6532.80,'2022-12-09 17:36:03','',''),(514,'1','302','1',1,'Retail Sale Id 498',802.24,0.00,0.00,1.09,65.40,'2022-12-09 17:38:53','',''),(515,'1','302','1',1,'Retail Sale Id 499',7367.36,0.00,0.00,10.01,600.60,'2022-12-09 17:41:48','',''),(516,'1','302','1',1,'Retail Sale Id 500',2200.64,0.00,0.00,2.99,179.40,'2022-12-09 18:04:43','',''),(517,'1','302','1',1,'Return of Retail Sale Id 498',0.00,802.24,1.09,0.00,-65.40,'2022-12-09 18:49:36','',''),(518,'1','302','1',1,'Retail Sale Id 501',794.88,0.00,0.00,1.08,64.80,'2022-12-09 18:50:23','',''),(519,'1','302','1',1,'Return of Retail Sale Id 501',0.00,794.88,1.08,0.00,-64.80,'2022-12-09 18:51:44','',''),(520,'1','302','1',1,'Retail Sale Id 502',794.88,0.00,0.00,1.08,64.80,'2022-12-09 18:52:40','',''),(521,'1','302','1',1,'Retail Sale Id 503',4423.36,0.00,0.00,6.01,360.60,'2022-12-10 08:26:49','',''),(522,'1','302','1',1,'Retail Sale Id 504',2208.00,0.00,0.00,3.00,180.00,'2022-12-10 08:35:04','',''),(523,'1','302','1',1,'Retail Sale Id 505',699.20,0.00,0.00,0.95,57.00,'2022-12-10 08:35:48','',''),(524,'1','302','1',1,'Retail Sale Id 506',2200.64,0.00,0.00,2.99,179.40,'2022-12-10 08:50:44','',''),(525,'1','302','1',1,'Retail Sale Id 507',9200.00,0.00,0.00,12.50,750.00,'2022-12-10 08:51:44','',''),(526,'1','302','1',1,'Retail Sale Id 509',17750.00,0.00,0.00,25.00,850.00,'2022-12-10 09:03:26','',''),(527,'1','302','1',1,'Retail Sale Id 510',1501.44,0.00,0.00,2.04,122.40,'2022-12-10 09:04:50','',''),(528,'1','302','1',1,'Retail Sale Id 511',4423.36,0.00,0.00,6.01,360.60,'2022-12-10 09:07:10','',''),(529,'1','302','1',1,'Retail Sale Id 512',4423.36,0.00,0.00,6.01,360.60,'2022-12-10 09:24:28','',''),(530,'1','302','1',1,'Retail Sale Id 513',2001.92,0.00,0.00,2.72,163.20,'2022-12-10 09:29:14','',''),(531,'1','302','1',1,'Retail Sale Id 514',750.72,0.00,0.00,1.02,61.20,'2022-12-10 09:30:22','',''),(532,'1','302','1',1,'Retail Sale Id 515',2208.00,0.00,0.00,3.00,180.00,'2022-12-10 09:53:54','',''),(533,'1','302','1',1,'Retail Sale Id 515',9200.00,0.00,0.00,12.50,750.00,'2022-12-10 09:53:54','',''),(534,'1','302','1',1,'Retail Sale Id 515',9200.00,0.00,0.00,12.50,750.00,'2022-12-10 09:53:54','',''),(535,'1','302','1',1,'Retail Sale Id 516',1501.44,0.00,0.00,2.04,122.40,'2022-12-10 10:00:23','',''),(536,'1','302','1',1,'Retail Sale Id 517',4430.72,0.00,0.00,6.02,361.20,'2022-12-10 10:01:54','',''),(537,'1','302','1',1,'Retail Sale Id 518',1479.36,0.00,0.00,2.01,120.60,'2022-12-10 10:04:32','',''),(538,'1','302','1',1,'Retail Sale Id 519',9303.04,0.00,0.00,12.64,758.40,'2022-12-10 10:17:14','',''),(539,'1','302','1',1,'Retail Sale Id 520',9303.04,0.00,0.00,12.64,758.40,'2022-12-10 10:37:29','',''),(540,'1','302','1',1,'Retail Sale Id 521',1501.44,0.00,0.00,2.04,122.40,'2022-12-10 10:49:41','',''),(541,'1','302','1',1,'Retail Sale Id 523',9200.00,0.00,0.00,12.50,750.00,'2022-12-10 11:01:22','',''),(542,'1','302','1',1,'Retail Sale Id 524',9200.00,0.00,0.00,12.50,750.00,'2022-12-10 11:02:06','',''),(543,'1','302','1',1,'Retail Sale Id 524',9200.00,0.00,0.00,12.50,750.00,'2022-12-10 11:02:06','',''),(544,'1','302','1',1,'Retail Sale Id 525',3687.36,0.00,0.00,5.01,300.60,'2022-12-10 11:03:56','',''),(545,'1','302','1',1,'Retail Sale Id 525',3687.36,0.00,0.00,5.01,300.60,'2022-12-10 11:03:56','',''),(546,'1','302','1',1,'Retail Sale Id 525',4423.36,0.00,0.00,6.01,360.60,'2022-12-10 11:03:56','',''),(547,'1','302','1',1,'Retail Sale Id 526',4401.28,0.00,0.00,5.98,358.80,'2022-12-10 11:04:47','',''),(548,'1','302','1',1,'Retail Sale Id 527',4401.28,0.00,0.00,5.98,358.80,'2022-12-10 11:05:48','',''),(549,'1','302','1',1,'Retail Sale Id 528',9001.28,0.00,0.00,12.23,733.80,'2022-12-10 11:09:07','',''),(550,'1','302','1',1,'Retail Sale Id 529',4496.96,0.00,0.00,6.11,366.60,'2022-12-10 11:27:26','',''),(551,'1','302','1',1,'Retail Sale Id 530',8520.00,0.00,0.00,12.00,408.00,'2022-12-10 11:30:43','',''),(552,'1','302','1',1,'Retail Sale Id 531',2208.00,0.00,0.00,3.00,180.00,'2022-12-10 11:31:42','',''),(553,'1','302','1',1,'Retail Sale Id 532',71000.00,0.00,0.00,100.00,3400.00,'2022-12-10 11:38:36','',''),(554,'1','302','1',1,'Retail Sale Id 533',4496.96,0.00,0.00,6.11,366.60,'2022-12-10 11:44:01','',''),(555,'1','302','1',1,'Retail Sale Id 534',4298.24,0.00,0.00,5.84,350.40,'2022-12-10 11:48:53','',''),(556,'1','302','1',1,'Retail Sale Id 534',9200.00,0.00,0.00,12.50,750.00,'2022-12-10 11:48:53','',''),(557,'1','302','1',1,'Retail Sale Id 535',1501.44,0.00,0.00,2.04,122.40,'2022-12-10 11:49:33','',''),(558,'1','302','1',1,'Retail Sale Id 536',9200.00,0.00,0.00,12.50,750.00,'2022-12-10 11:51:13','',''),(559,'1','302','1',1,'Retail Sale Id 537',4408.64,0.00,0.00,5.99,359.40,'2022-12-10 11:54:44','',''),(560,'1','302','1',1,'Retail Sale Id 538',4401.28,0.00,0.00,5.98,358.80,'2022-12-10 11:55:34','',''),(561,'1','302','1',1,'Retail Sale Id 539',5888.00,0.00,0.00,8.00,480.00,'2022-12-10 11:56:45','',''),(562,'1','302','1',1,'Retail Sale Id 540',9200.00,0.00,0.00,12.50,750.00,'2022-12-10 11:58:40','',''),(563,'1','302','1',1,'Retail Sale Id 541',2001.92,0.00,0.00,2.72,163.20,'2022-12-10 12:07:29','',''),(564,'1','302','1',1,'Retail Sale Id 542',1501.44,0.00,0.00,2.04,122.40,'2022-12-10 12:17:42','',''),(565,'1','302','1',1,'Retail Sale Id 543',4401.28,0.00,0.00,5.98,358.80,'2022-12-10 12:25:24','',''),(566,'1','302','1',1,'Retail Sale Id 544',21300.00,0.00,0.00,30.00,1020.00,'2022-12-10 12:31:17','',''),(567,'1','302','1',1,'Retail Sale Id 545',4452.80,0.00,0.00,6.05,363.00,'2022-12-10 12:32:38','',''),(568,'1','302','1',1,'Retail Sale Id 546',2252.16,0.00,0.00,3.06,183.60,'2022-12-10 12:44:41','',''),(569,'1','302','1',1,'Retail Sale Id 547',4452.80,0.00,0.00,6.05,363.00,'2022-12-10 13:10:59','',''),(570,'1','302','1',1,'Retail Sale Id 548',3680.00,0.00,0.00,5.00,300.00,'2022-12-10 13:13:41','',''),(571,'1','302','1',1,'Retail Sale Id 549',9200.00,0.00,0.00,12.50,750.00,'2022-12-10 13:34:01','',''),(572,'1','302','1',1,'Retail Sale Id 549',9200.00,0.00,0.00,12.50,750.00,'2022-12-10 13:34:01','',''),(573,'1','302','1',1,'Retail Sale Id 551',9303.04,0.00,0.00,12.64,758.40,'2022-12-10 13:39:16','',''),(574,'1','302','1',1,'Retail Sale Id 552',9200.00,0.00,0.00,12.50,750.00,'2022-12-10 14:00:16','',''),(575,'1','302','1',1,'Retail Sale Id 553',14749.44,0.00,0.00,20.04,1202.40,'2022-12-10 14:15:19','',''),(576,'1','302','1',1,'Retail Sale Id 553',14749.44,0.00,0.00,20.04,1202.40,'2022-12-10 14:15:19','',''),(577,'1','302','1',1,'Retail Sale Id 554',2208.00,0.00,0.00,3.00,180.00,'2022-12-10 14:21:43','',''),(578,'1','302','1',1,'Retail Sale Id 555',699.20,0.00,0.00,0.95,57.00,'2022-12-10 14:22:45','',''),(579,'1','302','1',1,'Retail Sale Id 556',4416.00,0.00,0.00,6.00,360.00,'2022-12-10 14:25:08','',''),(580,'1','302','1',1,'Retail Sale Id 557',2200.64,0.00,0.00,2.99,179.40,'2022-12-10 14:30:08','',''),(581,'1','302','1',1,'Retail Sale Id 558',4496.96,0.00,0.00,6.11,366.60,'2022-12-10 14:41:00','',''),(582,'1','302','1',1,'Retail Sale Id 559',14720.00,0.00,0.00,20.00,1200.00,'2022-12-10 14:43:00','',''),(583,'1','302','1',1,'Retail Sale Id 560',2252.16,0.00,0.00,3.06,183.60,'2022-12-10 14:46:18','',''),(584,'1','302','1',1,'Retail Sale Id 561',7499.84,0.00,0.00,10.19,611.40,'2022-12-10 14:47:28','',''),(585,'1','302','1',1,'Retail Sale Id 562',3503.36,0.00,0.00,4.76,285.60,'2022-12-10 15:00:52','',''),(586,'1','302','1',1,'Retail Sale Id 563',3002.88,0.00,0.00,4.08,244.80,'2022-12-10 15:15:03','',''),(587,'1','302','1',1,'Retail Sale Id 564',1000.96,0.00,0.00,1.36,81.60,'2022-12-10 15:17:01','',''),(588,'1','302','1',1,'Retail Sale Id 565',1501.44,0.00,0.00,2.04,122.40,'2022-12-10 15:41:24','',''),(589,'1','302','1',1,'Retail Sale Id 566',3996.48,0.00,0.00,5.43,325.80,'2022-12-10 16:17:27','',''),(590,'1','302','1',1,'Retail Sale Id 567',21300.00,0.00,0.00,30.00,1020.00,'2022-12-10 16:43:42','',''),(591,'1','302','1',1,'Retail Sale Id 568',1000.96,0.00,0.00,1.36,81.60,'2022-12-10 16:44:22','',''),(592,'1','302','1',1,'Retail Sale Id 569',2200.64,0.00,0.00,2.99,179.40,'2022-12-10 17:15:03','',''),(593,'1','302','1',1,'Retail Sale Id 570',2208.00,0.00,0.00,3.00,180.00,'2022-12-10 17:41:56','',''),(594,'1','302','1',1,'Retail Sale Id 571',2001.92,0.00,0.00,2.72,163.20,'2022-12-10 17:44:43','',''),(595,'1','302','1',1,'Retail Sale Id 572',2001.92,0.00,0.00,2.72,163.20,'2022-12-10 18:03:51','',''),(596,'1','302','1',1,'Retail Sale Id 573',3002.88,0.00,0.00,4.08,244.80,'2022-12-10 18:09:10','',''),(597,'1','302','1',1,'Retail Sale Id 574',3002.88,0.00,0.00,4.08,244.80,'2022-12-10 18:21:29','',''),(598,'1','302','1',1,'Retail Sale Id 576',36.80,0.00,0.00,0.05,3.00,'2022-12-10 18:51:08','',''),(599,'1','302','1',1,'Retail Sale Id 577',4496.96,0.00,0.00,6.11,366.60,'2022-12-11 08:11:55','',''),(600,'1','302','1',1,'Retail Sale Id 578',4496.96,0.00,0.00,6.11,366.60,'2022-12-11 08:20:01','',''),(601,'1','302','1',1,'Retail Sale Id 579',106500.00,0.00,0.00,150.00,5100.00,'2022-12-11 08:39:08','',''),(602,'1','302','1',1,'Retail Sale Id 580',11040.00,0.00,0.00,15.00,900.00,'2022-12-11 08:48:55','',''),(603,'1','302','1',1,'Retail Sale Id 581',2502.40,0.00,0.00,3.40,204.00,'2022-12-11 08:54:01','',''),(604,'1','302','1',1,'Retail Sale Id 582',2001.92,0.00,0.00,2.72,163.20,'2022-12-11 09:02:31','',''),(605,'1','302','1',1,'Retail Sale Id 583',3503.36,0.00,0.00,4.76,285.60,'2022-12-11 09:18:42','',''),(606,'1','302','1',1,'Retail Sale Id 584',4416.00,0.00,0.00,6.00,360.00,'2022-12-11 09:19:37','',''),(607,'1','302','1',1,'Retail Sale Id 585',4452.80,0.00,0.00,6.05,363.00,'2022-12-11 09:20:38','',''),(608,'1','302','1',1,'Retail Sale Id 586',3002.88,0.00,0.00,4.08,244.80,'2022-12-11 09:57:16','',''),(609,'1','302','1',1,'Retail Sale Id 587',9200.00,0.00,0.00,12.50,750.00,'2022-12-11 10:05:09','',''),(610,'1','302','1',1,'Retail Sale Id 588',7360.00,0.00,0.00,10.00,600.00,'2022-12-11 10:10:54','',''),(611,'1','302','1',1,'Retail Sale Id 589',4496.96,0.00,0.00,6.11,366.60,'2022-12-11 10:22:45','',''),(612,'1','302','1',1,'Retail Sale Id 589',4496.96,0.00,0.00,6.11,366.60,'2022-12-11 10:22:45','',''),(613,'1','302','1',1,'Retail Sale Id 590',1501.44,0.00,0.00,2.04,122.40,'2022-12-11 10:31:44','',''),(614,'1','302','1',1,'Retail Sale Id 591',2208.00,0.00,0.00,3.00,180.00,'2022-12-11 10:39:42','',''),(615,'1','302','1',1,'Retail Sale Id 592',3996.48,0.00,0.00,5.43,325.80,'2022-12-11 10:41:21','',''),(616,'1','302','1',1,'Retail Sale Id 593',7301.12,0.00,0.00,9.92,595.20,'2022-12-11 10:45:48','',''),(617,'1','302','1',1,'Retail Sale Id 594',1000.96,0.00,0.00,1.36,81.60,'2022-12-11 10:55:05','',''),(618,'1','302','1',1,'Retail Sale Id 595',9200.00,0.00,0.00,12.50,750.00,'2022-12-11 11:12:09','',''),(619,'1','302','1',1,'Retail Sale Id 596',4997.44,0.00,0.00,6.79,407.40,'2022-12-11 11:26:42','',''),(620,'1','302','1',1,'Retail Sale Id 597',2200.64,0.00,0.00,2.99,179.40,'2022-12-11 11:30:09','',''),(621,'1','302','1',1,'Retail Sale Id 598',1479.36,0.00,0.00,2.01,120.60,'2022-12-11 11:31:56','',''),(622,'1','302','1',1,'Retail Sale Id 599',802.24,0.00,0.00,1.09,65.40,'2022-12-11 11:33:56','',''),(623,'1','302','1',1,'Retail Sale Id 600',35500.00,0.00,0.00,50.00,1700.00,'2022-12-11 11:37:56','',''),(624,'1','302','1',1,'Retail Sale Id 601',4496.96,0.00,0.00,6.11,366.60,'2022-12-11 11:57:06','',''),(625,'1','302','1',1,'Retail Sale Id 602',7396.80,0.00,0.00,10.05,603.00,'2022-12-11 12:10:04','',''),(626,'1','302','1',1,'Retail Sale Id 603',2200.64,0.00,0.00,2.99,179.40,'2022-12-11 12:13:23','',''),(627,'1','302','1',1,'Retail Sale Id 604',500.48,0.00,0.00,0.68,40.80,'2022-12-11 12:14:42','',''),(628,'1','302','1',1,'Retail Sale Id 605',9200.00,0.00,0.00,12.50,750.00,'2022-12-11 12:16:24','',''),(629,'1','302','1',1,'Retail Sale Id 606',2252.16,0.00,0.00,3.06,183.60,'2022-12-11 12:18:47','',''),(630,'1','302','1',1,'Retail Sale Id 607',4416.00,0.00,0.00,6.00,360.00,'2022-12-11 12:20:53','',''),(631,'1','302','1',1,'Retail Sale Id 609',4416.00,0.00,0.00,6.00,360.00,'2022-12-11 12:34:23','',''),(632,'1','302','1',1,'Retail Sale Id 610',1302.72,0.00,0.00,1.77,106.20,'2022-12-11 12:36:15','',''),(633,'1','302','1',1,'Retail Sale Id 610',1302.72,0.00,0.00,1.77,106.20,'2022-12-11 12:36:15','',''),(634,'1','302','1',1,'Retail Sale Id 611',1199.68,0.00,0.00,1.63,97.80,'2022-12-11 12:37:47','',''),(635,'1','302','1',1,'Retail Sale Id 612',802.24,0.00,0.00,1.09,65.40,'2022-12-11 12:42:33','',''),(636,'1','302','1',1,'Retail Sale Id 613',2208.00,0.00,0.00,3.00,180.00,'2022-12-11 12:53:40','',''),(637,'1','302','1',1,'Retail Sale Id 614',2200.64,0.00,0.00,2.99,179.40,'2022-12-11 12:58:24','',''),(638,'1','302','1',1,'Retail Sale Id 615',3002.88,0.00,0.00,4.08,244.80,'2022-12-11 13:02:57','',''),(639,'1','302','1',1,'Retail Sale Id 616',3680.00,0.00,0.00,5.00,300.00,'2022-12-11 13:26:27','',''),(640,'1','302','1',1,'Retail Sale Id 617',2208.00,0.00,0.00,3.00,180.00,'2022-12-11 13:28:12','',''),(641,'1','302','1',1,'Retail Sale Id 618',2208.00,0.00,0.00,3.00,180.00,'2022-12-11 13:29:22','',''),(642,'1','302','1',1,'Retail Sale Id 619',9200.00,0.00,0.00,12.50,750.00,'2022-12-11 13:34:03','',''),(643,'1','302','1',1,'Retail Sale Id 620',2001.92,0.00,0.00,2.72,163.20,'2022-12-11 13:36:56','',''),(644,'1','302','1',1,'Retail Sale Id 621',24850.00,0.00,0.00,35.00,1190.00,'2022-12-11 13:41:08','',''),(645,'1','302','1',1,'Retail Sale Id 622',8802.56,0.00,0.00,11.96,717.60,'2022-12-11 13:57:36','',''),(646,'1','302','1',1,'Retail Sale Id 624',2208.00,0.00,0.00,3.00,180.00,'2022-12-11 14:17:41','',''),(647,'1','302','1',1,'Retail Sale Id 625',4423.36,0.00,0.00,6.01,360.60,'2022-12-11 14:27:08','',''),(648,'1','302','1',1,'Retail Sale Id 626',17750.00,0.00,0.00,25.00,850.00,'2022-12-11 14:28:58','',''),(649,'1','302','1',1,'Retail Sale Id 627',7352.64,0.00,0.00,9.99,599.40,'2022-12-11 14:29:48','',''),(650,'1','302','1',1,'Retail Sale Id 628',2001.92,0.00,0.00,2.72,163.20,'2022-12-11 14:31:18','',''),(651,'1','302','1',1,'Retail Sale Id 630',7499.84,0.00,0.00,10.19,611.40,'2022-12-11 14:41:23','',''),(652,'1','302','1',1,'Retail Sale Id 631',2502.40,0.00,0.00,3.40,204.00,'2022-12-11 15:06:27','',''),(653,'1','302','1',1,'Retail Sale Id 632',1000.96,0.00,0.00,1.36,81.60,'2022-12-11 16:00:21','',''),(654,'1','302','1',1,'Retail Sale Id 634',2208.00,0.00,0.00,3.00,180.00,'2022-12-11 16:08:53','',''),(655,'1','302','1',1,'Retail Sale Id 635',2208.00,0.00,0.00,3.00,180.00,'2022-12-11 16:15:51','',''),(656,'1','302','1',1,'Retail Sale Id 635',4416.00,0.00,0.00,6.00,360.00,'2022-12-11 16:15:51','',''),(657,'1','302','1',1,'Retail Sale Id 635',9200.00,0.00,0.00,12.50,750.00,'2022-12-11 16:15:51','',''),(658,'1','302','1',1,'Retail Sale Id 636',3503.36,0.00,0.00,4.76,285.60,'2022-12-11 16:21:16','',''),(659,'1','302','1',1,'Retail Sale Id 637',1803.20,0.00,0.00,2.45,147.00,'2022-12-11 17:08:48','',''),(660,'1','302','1',1,'Retail Sale Id 638',2001.92,0.00,0.00,2.72,163.20,'2022-12-11 17:10:58','',''),(661,'1','302','1',1,'Retail Sale Id 639',4496.96,0.00,0.00,6.11,366.60,'2022-12-11 17:13:56','',''),(662,'1','302','1',1,'Retail Sale Id 640',750.72,0.00,0.00,1.02,61.20,'2022-12-11 17:20:45','',''),(663,'1','302','1',1,'Retail Sale Id 641',2208.00,0.00,0.00,3.00,180.00,'2022-12-11 17:26:15','',''),(664,'1','302','1',1,'Retail Sale Id 642',1501.44,0.00,0.00,2.04,122.40,'2022-12-11 17:46:45','',''),(665,'1','302','1',1,'Retail Sale Id 643',15797.50,0.00,0.00,22.25,756.50,'2022-12-11 18:00:28','',''),(666,'1','302','1',1,'Return of Retail Sale Id 626',0.00,17750.00,25.00,0.00,-850.00,'2022-12-11 18:38:59','',''),(667,'1','302','1',1,'Retail Sale Id 644',17750.00,0.00,0.00,25.00,850.00,'2022-12-11 18:40:35','',''),(668,'1','302','1',1,'Retail Sale Id 645',22.08,0.00,0.00,0.03,1.80,'2022-12-11 18:42:16','',''),(669,'1','302','1',1,'Retail Sale Id 646',9200.00,0.00,0.00,12.50,750.00,'2022-12-12 08:15:28','',''),(670,'1','302','1',1,'Retail Sale Id 647',4416.00,0.00,0.00,6.00,360.00,'2022-12-12 08:16:20','',''),(671,'1','302','1',1,'Retail Sale Id 648',2208.00,0.00,0.00,3.00,180.00,'2022-12-12 08:17:11','',''),(672,'1','302','1',1,'Retail Sale Id 649',4496.96,0.00,0.00,6.11,366.60,'2022-12-12 08:26:14','',''),(673,'1','302','1',1,'Retail Sale Id 650',3680.00,0.00,0.00,5.00,300.00,'2022-12-12 08:27:26','',''),(674,'1','302','1',1,'Retail Sale Id 651',2001.92,0.00,0.00,2.72,163.20,'2022-12-12 08:39:08','',''),(675,'1','302','1',1,'Retail Sale Id 652',1000.96,0.00,0.00,1.36,81.60,'2022-12-12 08:40:11','',''),(676,'1','302','1',1,'Retail Sale Id 653',1000.96,0.00,0.00,1.36,81.60,'2022-12-12 08:50:37','',''),(677,'1','302','1',1,'Retail Sale Id 654',3797.76,0.00,0.00,5.16,309.60,'2022-12-12 09:14:38','',''),(678,'1','302','1',1,'Retail Sale Id 655',3680.00,0.00,0.00,5.00,300.00,'2022-12-12 09:18:37','',''),(679,'1','302','1',1,'Retail Sale Id 656',1000.96,0.00,0.00,1.36,81.60,'2022-12-12 09:41:52','',''),(680,'1','302','1',1,'Retail Sale Id 657',3002.88,0.00,0.00,4.08,244.80,'2022-12-12 09:48:03','',''),(681,'1','302','1',1,'Retail Sale Id 658',1501.44,0.00,0.00,2.04,122.40,'2022-12-12 10:11:40','',''),(682,'1','302','1',1,'Retail Sale Id 659',9200.00,0.00,0.00,12.50,750.00,'2022-12-12 10:13:02','',''),(683,'1','302','1',1,'Retail Sale Id 660',3702.08,0.00,0.00,5.03,301.80,'2022-12-12 10:31:19','',''),(684,'1','302','1',1,'Retail Sale Id 661',3680.00,0.00,0.00,5.00,300.00,'2022-12-12 10:40:27','',''),(685,'1','302','1',1,'Retail Sale Id 662',3002.88,0.00,0.00,4.08,244.80,'2022-12-12 10:42:28','',''),(686,'1','302','1',1,'Retail Sale Id 663',2208.00,0.00,0.00,3.00,180.00,'2022-12-12 10:50:43','',''),(687,'1','302','1',1,'Retail Sale Id 664',1501.44,0.00,0.00,2.04,122.40,'2022-12-12 10:51:37','',''),(688,'1','302','1',1,'Retail Sale Id 665',18400.00,0.00,0.00,25.00,1500.00,'2022-12-12 10:53:21','',''),(689,'1','302','1',1,'Retail Sale Id 666',4416.00,0.00,0.00,6.00,360.00,'2022-12-12 10:57:31','',''),(690,'1','302','1',1,'Retail Sale Id 667',750.72,0.00,0.00,1.02,61.20,'2022-12-12 11:01:37','',''),(691,'1','302','1',1,'Retail Sale Id 668',1000.96,0.00,0.00,1.36,81.60,'2022-12-12 11:13:27','',''),(692,'1','302','1',1,'Retail Sale Id 669',9200.00,0.00,0.00,12.50,750.00,'2022-12-12 11:17:45','',''),(693,'1','302','1',1,'Retail Sale Id 671',2502.40,0.00,0.00,3.40,204.00,'2022-12-12 11:20:33','',''),(694,'1','302','1',1,'Retail Sale Id 672',1000.96,0.00,0.00,1.36,81.60,'2022-12-12 11:21:44','',''),(695,'1','302','1',1,'Retail Sale Id 673',2303.68,0.00,0.00,3.13,187.80,'2022-12-12 11:27:17','',''),(696,'1','302','1',1,'Retail Sale Id 674',3002.88,0.00,0.00,4.08,244.80,'2022-12-12 11:30:19','',''),(697,'1','302','1',1,'Retail Sale Id 675',2208.00,0.00,0.00,3.00,180.00,'2022-12-12 11:40:29','',''),(698,'1','302','1',1,'Retail Sale Id 676',9200.00,0.00,0.00,12.50,750.00,'2022-12-12 12:00:56','',''),(699,'1','302','1',1,'Retail Sale Id 677',3680.00,0.00,0.00,5.00,300.00,'2022-12-12 12:14:16','',''),(700,'1','302','1',1,'Retail Sale Id 678',2149.12,0.00,0.00,2.92,175.20,'2022-12-12 12:25:14','',''),(701,'1','302','1',1,'Retail Sale Id 679',4416.00,0.00,0.00,6.00,360.00,'2022-12-12 12:29:23','',''),(702,'1','302','1',1,'Retail Sale Id 680',1700.16,0.00,0.00,2.31,138.60,'2022-12-12 12:30:57','',''),(703,'1','302','1',1,'Retail Sale Id 681',2303.68,0.00,0.00,3.13,187.80,'2022-12-12 12:33:56','',''),(704,'1','302','1',1,'Retail Sale Id 683',35500.00,0.00,0.00,50.00,1700.00,'2022-12-12 12:43:06','',''),(705,'1','302','1',1,'Retail Sale Id 684',2208.00,0.00,0.00,3.00,180.00,'2022-12-12 13:00:18','',''),(706,'1','302','1',1,'Retail Sale Id 685',500.48,0.00,0.00,0.68,40.80,'2022-12-12 13:20:38','',''),(707,'1','302','1',1,'Retail Sale Id 686',2208.00,0.00,0.00,3.00,180.00,'2022-12-12 13:38:08','',''),(708,'1','302','1',1,'Retail Sale Id 687',9200.00,0.00,0.00,12.50,750.00,'2022-12-12 13:43:40','',''),(709,'1','302','1',1,'Retail Sale Id 688',4416.00,0.00,0.00,6.00,360.00,'2022-12-12 14:02:52','',''),(710,'1','302','1',1,'Retail Sale Id 689',3680.00,0.00,0.00,5.00,300.00,'2022-12-12 14:24:05','',''),(711,'1','302','1',1,'Retail Sale Id 690',3503.36,0.00,0.00,4.76,285.60,'2022-12-12 14:40:30','',''),(712,'1','302','1',1,'Retail Sale Id 691',2001.92,0.00,0.00,2.72,163.20,'2022-12-12 14:47:22','',''),(713,'1','302','1',1,'Retail Sale Id 692',4997.44,0.00,0.00,6.79,407.40,'2022-12-12 14:58:14','',''),(714,'1','302','1',1,'Retail Sale Id 693',3702.08,0.00,0.00,5.03,301.80,'2022-12-12 15:58:40','',''),(715,'1','302','1',1,'Retail Sale Id 694',3002.88,0.00,0.00,4.08,244.80,'2022-12-12 16:18:27','',''),(716,'1','302','1',1,'Retail Sale Id 695',2208.00,0.00,0.00,3.00,180.00,'2022-12-12 16:19:25','',''),(717,'1','302','1',1,'Retail Sale Id 696',1000.96,0.00,0.00,1.36,81.60,'2022-12-12 16:55:27','',''),(718,'1','302','1',1,'Retail Sale Id 696',2001.92,0.00,0.00,2.72,163.20,'2022-12-12 16:55:27','',''),(719,'1','302','1',1,'Retail Sale Id 696',2200.64,0.00,0.00,2.99,179.40,'2022-12-12 16:55:27','',''),(720,'1','302','1',1,'Retail Sale Id 696',2208.00,0.00,0.00,3.00,180.00,'2022-12-12 16:55:27','',''),(721,'1','302','1',1,'Retail Sale Id 696',2303.68,0.00,0.00,3.13,187.80,'2022-12-12 16:55:27','',''),(722,'1','302','1',1,'Retail Sale Id 697',4416.00,0.00,0.00,6.00,360.00,'2022-12-12 16:57:10','',''),(723,'1','302','1',1,'Retail Sale Id 698',8096.00,0.00,0.00,11.00,660.00,'2022-12-12 17:10:19','',''),(724,'1','302','1',1,'Retail Sale Id 699',2208.00,0.00,0.00,3.00,180.00,'2022-12-12 17:11:51','',''),(725,'1','302','1',1,'Retail Sale Id 700',3680.00,0.00,0.00,5.00,300.00,'2022-12-12 17:32:30','',''),(726,'1','302','1',1,'Retail Sale Id 701',3797.76,0.00,0.00,5.16,309.60,'2022-12-12 17:34:57','',''),(727,'1','302','1',1,'Retail Sale Id 703',1501.44,0.00,0.00,2.04,122.40,'2022-12-12 17:56:08','',''),(728,'1','302','1',1,'Retail Sale Id 702',9200.00,0.00,0.00,12.50,750.00,'2022-12-12 18:05:26','',''),(729,'1','302','1',1,'Retail Sale Id 704',36.80,0.00,0.00,0.05,3.00,'2022-12-12 18:38:18','',''),(730,'1','302','1',1,'Retail Sale Id 705',3002.88,0.00,0.00,4.08,244.80,'2022-12-13 07:34:02','',''),(731,'1','302','1',1,'Retail Sale Id 706',2502.40,0.00,0.00,3.40,204.00,'2022-12-13 08:20:16','',''),(732,'1','302','1',1,'Retail Sale Id 707',3002.88,0.00,0.00,4.08,244.80,'2022-12-13 08:21:21','',''),(733,'1','302','1',1,'Retail Sale Id 708',1000.96,0.00,0.00,1.36,81.60,'2022-12-13 08:22:14','',''),(734,'1','302','1',1,'Retail Sale Id 709',5152.00,0.00,0.00,7.00,420.00,'2022-12-13 08:38:25','',''),(735,'1','302','1',1,'Retail Sale Id 710',2208.00,0.00,0.00,3.00,180.00,'2022-12-13 08:50:38','',''),(736,'1','302','1',1,'Retail Sale Id 711',9200.00,0.00,0.00,12.50,750.00,'2022-12-13 08:52:04','',''),(737,'1','302','1',1,'Retail Sale Id 712',2001.92,0.00,0.00,2.72,163.20,'2022-12-13 09:04:02','',''),(738,'1','302','1',1,'Retail Sale Id 713',4416.00,0.00,0.00,6.00,360.00,'2022-12-13 09:34:40','',''),(739,'1','302','1',1,'Retail Sale Id 713',9200.00,0.00,0.00,12.50,750.00,'2022-12-13 09:34:40','',''),(740,'1','302','1',1,'Retail Sale Id 713',9200.00,0.00,0.00,12.50,750.00,'2022-12-13 09:34:40','',''),(741,'1','302','1',1,'Retail Sale Id 714',2208.00,0.00,0.00,3.00,180.00,'2022-12-13 09:54:55','',''),(742,'1','302','1',1,'Retail Sale Id 714',7360.00,0.00,0.00,10.00,600.00,'2022-12-13 09:54:55','',''),(743,'1','302','1',1,'Retail Sale Id 715',9200.00,0.00,0.00,12.50,750.00,'2022-12-13 10:05:12','',''),(744,'1','302','1',1,'Retail Sale Id 716',4416.00,0.00,0.00,6.00,360.00,'2022-12-13 10:11:58','',''),(745,'1','302','1',1,'Retail Sale Id 717',9200.00,0.00,0.00,12.50,750.00,'2022-12-13 10:28:48','',''),(746,'1','302','1',1,'Retail Sale Id 717',9200.00,0.00,0.00,12.50,750.00,'2022-12-13 10:28:48','',''),(747,'1','302','1',1,'Retail Sale Id 718',1449.92,0.00,0.00,1.97,118.20,'2022-12-13 12:17:56','',''),(748,'1','302','1',1,'Retail Sale Id 719',9200.00,0.00,0.00,12.50,750.00,'2022-12-13 12:20:46','',''),(749,'1','302','1',1,'Retail Sale Id 720',2001.92,0.00,0.00,2.72,163.20,'2022-12-13 12:21:39','',''),(750,'1','302','1',1,'Retail Sale Id 721',9200.00,0.00,0.00,12.50,750.00,'2022-12-13 12:22:36','',''),(751,'1','302','1',1,'Retail Sale Id 722',1501.44,0.00,0.00,2.04,122.40,'2022-12-13 12:27:58','',''),(752,'1','302','1',1,'Retail Sale Id 723',4496.96,0.00,0.00,6.11,366.60,'2022-12-13 12:29:09','',''),(753,'1','302','1',1,'Retail Sale Id 725',2208.00,0.00,0.00,3.00,180.00,'2022-12-13 12:32:04','',''),(754,'1','302','1',1,'Retail Sale Id 726',4401.28,0.00,0.00,5.98,358.80,'2022-12-13 12:44:41','',''),(755,'1','302','1',1,'Retail Sale Id 727',4401.28,0.00,0.00,5.98,358.80,'2022-12-13 12:59:59','',''),(756,'1','302','1',1,'Retail Sale Id 728',8000.32,0.00,0.00,10.87,652.20,'2022-12-13 15:00:04','',''),(757,'1','302','1',1,'Retail Sale Id 729',2001.92,0.00,0.00,2.72,163.20,'2022-12-13 16:08:54','',''),(758,'1','302','1',1,'Retail Sale Id 730',17750.00,0.00,0.00,25.00,850.00,'2022-12-13 16:10:35','',''),(759,'1','302','1',1,'Retail Sale Id 731',2208.00,0.00,0.00,3.00,180.00,'2022-12-13 16:12:14','',''),(760,'1','302','1',1,'Retail Sale Id 732',3680.00,0.00,0.00,5.00,300.00,'2022-12-13 16:14:40','',''),(761,'1','302','1',1,'Retail Sale Id 733',2200.64,0.00,0.00,2.99,179.40,'2022-12-13 16:16:17','',''),(762,'1','302','1',1,'Retail Sale Id 734',9200.00,0.00,0.00,12.50,750.00,'2022-12-13 16:21:02','',''),(763,'1','302','1',1,'Retail Sale Id 735',802.24,0.00,0.00,1.09,65.40,'2022-12-13 16:32:25','',''),(764,'1','302','1',1,'Retail Sale Id 736',3002.88,0.00,0.00,4.08,244.80,'2022-12-13 16:56:55','',''),(765,'1','302','1',1,'Retail Sale Id 737',802.24,0.00,0.00,1.09,65.40,'2022-12-13 17:01:03','',''),(766,'1','302','1',1,'Retail Sale Id 738',802.24,0.00,0.00,1.09,65.40,'2022-12-13 17:02:11','',''),(767,'1','302','1',1,'Retail Sale Id 739',2944.00,0.00,0.00,4.00,240.00,'2022-12-13 17:32:09','',''),(768,'1','302','1',1,'Retail Sale Id 740',2208.00,0.00,0.00,3.00,180.00,'2022-12-13 17:33:14','',''),(769,'1','302','1',1,'Retail Sale Id 743',12276.48,0.00,0.00,16.68,1000.80,'2022-12-13 18:05:02','',''),(770,'1','302','1',1,'Retail Sale Id 744',2208.00,0.00,0.00,3.00,180.00,'2022-12-13 18:06:49','',''),(771,'1','302','1',1,'Return of Retail Sale Id 738',0.00,802.24,1.09,0.00,-65.40,'2022-12-13 18:42:42','',''),(772,'1','302','1',1,'Retail Sale Id 745',279.68,0.00,0.00,0.38,22.80,'2022-12-13 18:43:26','',''),(773,'1','302','1',1,'Retail Sale Id 746',9200.00,0.00,0.00,12.50,750.00,'2022-12-14 07:26:17','',''),(774,'1','302','1',1,'Retail Sale Id 747',1501.44,0.00,0.00,2.04,122.40,'2022-12-14 07:33:12','',''),(775,'1','302','1',1,'Retail Sale Id 748',2001.92,0.00,0.00,2.72,163.20,'2022-12-14 07:58:18','',''),(776,'1','302','1',1,'Retail Sale Id 749',3680.00,0.00,0.00,5.00,300.00,'2022-12-14 08:12:17','',''),(777,'1','302','1',1,'Retail Sale Id 750',2208.00,0.00,0.00,3.00,180.00,'2022-12-14 08:35:34','',''),(778,'1','302','1',1,'Retail Sale Id 751',1501.44,0.00,0.00,2.04,122.40,'2022-12-14 08:46:33','',''),(779,'1','302','1',1,'Retail Sale Id 752',9200.00,0.00,0.00,12.50,750.00,'2022-12-14 08:52:11','',''),(780,'1','302','1',1,'Retail Sale Id 753',2208.00,0.00,0.00,3.00,180.00,'2022-12-14 09:13:31','',''),(781,'1','302','1',1,'Retail Sale Id 754',3702.08,0.00,0.00,5.03,301.80,'2022-12-14 09:14:46','',''),(782,'1','302','1',1,'Retail Sale Id 755',3702.08,0.00,0.00,5.03,301.80,'2022-12-14 09:18:32','',''),(783,'1','302','1',1,'Retail Sale Id 756',18105.00,0.00,0.00,25.50,867.00,'2022-12-14 09:39:37','',''),(784,'1','302','1',1,'Retail Sale Id 757',1501.44,0.00,0.00,2.04,122.40,'2022-12-14 09:51:16','',''),(785,'1','302','1',1,'Retail Sale Id 758',1000.96,0.00,0.00,1.36,81.60,'2022-12-14 10:29:27','',''),(786,'1','302','1',1,'Retail Sale Id 759',3503.36,0.00,0.00,4.76,285.60,'2022-12-14 10:40:06','',''),(787,'1','302','1',1,'Retail Sale Id 760',8832.00,0.00,0.00,12.00,720.00,'2022-12-14 10:44:07','',''),(788,'1','302','1',1,'Retail Sale Id 761',9200.00,0.00,0.00,12.50,750.00,'2022-12-14 10:45:08','',''),(789,'1','302','1',1,'Retail Sale Id 762',3680.00,0.00,0.00,5.00,300.00,'2022-12-14 10:47:26','',''),(790,'1','302','1',1,'Retail Sale Id 763',3680.00,0.00,0.00,5.00,300.00,'2022-12-14 10:51:16','',''),(791,'1','302','1',1,'Retail Sale Id 764',4401.28,0.00,0.00,5.98,358.80,'2022-12-14 10:55:45','',''),(792,'1','302','1',1,'Retail Sale Id 765',35500.00,0.00,0.00,50.00,1700.00,'2022-12-14 11:03:46','',''),(793,'1','302','1',1,'Retail Sale Id 766',1501.44,0.00,0.00,2.04,122.40,'2022-12-14 11:16:50','',''),(794,'1','302','1',1,'Retail Sale Id 767',7499.84,0.00,0.00,10.19,611.40,'2022-12-14 11:18:07','',''),(795,'1','302','1',1,'Retail Sale Id 769',4401.28,0.00,0.00,5.98,358.80,'2022-12-14 11:36:56','',''),(796,'1','302','1',1,'Retail Sale Id 769',9200.00,0.00,0.00,12.50,750.00,'2022-12-14 11:36:56','',''),(797,'1','302','1',1,'Retail Sale Id 770',4423.36,0.00,0.00,6.01,360.60,'2022-12-14 11:39:47','',''),(798,'1','302','1',1,'Retail Sale Id 771',1000.96,0.00,0.00,1.36,81.60,'2022-12-14 11:40:45','',''),(799,'1','302','1',1,'Retail Sale Id 772',1199.68,0.00,0.00,1.63,97.80,'2022-12-14 11:41:34','',''),(800,'1','302','1',1,'Retail Sale Id 773',1000.96,0.00,0.00,1.36,81.60,'2022-12-14 11:45:56','',''),(801,'1','302','1',1,'Retail Sale Id 775',4401.28,0.00,0.00,5.98,358.80,'2022-12-14 11:51:23','',''),(802,'1','302','1',1,'Retail Sale Id 775',4401.28,0.00,0.00,5.98,358.80,'2022-12-14 11:51:23','',''),(803,'1','302','1',1,'Retail Sale Id 776',9200.00,0.00,0.00,12.50,750.00,'2022-12-14 11:58:57','',''),(804,'1','302','1',1,'Retail Sale Id 777',3002.88,0.00,0.00,4.08,244.80,'2022-12-14 11:59:35','',''),(805,'1','302','1',1,'Retail Sale Id 778',3680.00,0.00,0.00,5.00,300.00,'2022-12-14 12:00:46','',''),(806,'1','302','1',1,'Retail Sale Id 779',3702.08,0.00,0.00,5.03,301.80,'2022-12-14 12:05:46','',''),(807,'1','302','1',1,'Retail Sale Id 780',2200.64,0.00,0.00,2.99,179.40,'2022-12-14 12:07:40','',''),(808,'1','302','1',1,'Retail Sale Id 781',736000.00,0.00,0.00,1000.00,60000.00,'2022-12-14 12:17:11','',''),(809,'1','302','1',1,'Retail Sale Id 781',736000.00,0.00,0.00,1000.00,60000.00,'2022-12-14 12:17:11','',''),(810,'1','302','1',1,'Retail Sale Id 782',1000.96,0.00,0.00,1.36,81.60,'2022-12-14 12:18:20','',''),(811,'1','302','1',1,'Retail Sale Id 782',1000.96,0.00,0.00,1.36,81.60,'2022-12-14 12:18:20','',''),(812,'1','302','1',1,'Return of Retail Sale Id 781',0.00,736000.00,1000.00,0.00,-60000.00,'2022-12-14 12:24:29','',''),(813,'1','302','1',1,'Return of Retail Sale Id 781',0.00,736000.00,1000.00,0.00,-60000.00,'2022-12-14 12:24:29','',''),(814,'1','302','1',1,'Retail Sale Id 783',4423.36,0.00,0.00,6.01,360.60,'2022-12-14 12:27:20','',''),(815,'1','302','1',1,'Retail Sale Id 784',3996.48,0.00,0.00,5.43,325.80,'2022-12-14 12:35:49','',''),(816,'1','302','1',1,'Retail Sale Id 786',699.20,0.00,0.00,0.95,57.00,'2022-12-14 12:49:36','',''),(817,'1','302','1',1,'Retail Sale Id 787',2001.92,0.00,0.00,2.72,163.20,'2022-12-14 13:19:10','',''),(818,'1','302','1',1,'Retail Sale Id 788',3002.88,0.00,0.00,4.08,244.80,'2022-12-14 13:36:40','',''),(819,'1','302','1',1,'Retail Sale Id 789',1199.68,0.00,0.00,1.63,97.80,'2022-12-14 13:51:07','',''),(820,'1','302','1',1,'Retail Sale Id 790',2001.92,0.00,0.00,2.72,163.20,'2022-12-14 13:56:28','',''),(821,'1','302','1',1,'Retail Sale Id 791',2502.40,0.00,0.00,3.40,204.00,'2022-12-14 14:59:32','',''),(822,'1','302','1',1,'Retail Sale Id 792',2001.92,0.00,0.00,2.72,163.20,'2022-12-14 15:03:49','',''),(823,'1','302','1',1,'Retail Sale Id 793',802.24,0.00,0.00,1.09,65.40,'2022-12-14 15:06:32','',''),(824,'1','302','1',1,'Retail Sale Id 795',8500.80,0.00,0.00,11.55,693.00,'2022-12-14 15:20:06','',''),(825,'1','302','1',1,'Retail Sale Id 796',4401.28,0.00,0.00,5.98,358.80,'2022-12-14 15:22:40','',''),(826,'1','302','1',1,'Retail Sale Id 797',9200.00,0.00,0.00,12.50,750.00,'2022-12-14 15:25:36','',''),(827,'1','302','1',1,'Retail Sale Id 798',9200.00,0.00,0.00,12.50,750.00,'2022-12-14 15:32:28','',''),(828,'1','302','1',1,'Retail Sale Id 799',5998.40,0.00,0.00,8.15,489.00,'2022-12-14 15:36:02','',''),(829,'1','302','1',1,'Retail Sale Id 800',1501.44,0.00,0.00,2.04,122.40,'2022-12-14 15:37:32','',''),(830,'1','302','1',1,'Retail Sale Id 801',18400.00,0.00,0.00,25.00,1500.00,'2022-12-14 15:38:25','',''),(831,'1','302','1',1,'Retail Sale Id 802',9200.00,0.00,0.00,12.50,750.00,'2022-12-14 16:02:37','',''),(832,'1','302','1',1,'Retail Sale Id 803',4496.96,0.00,0.00,6.11,366.60,'2022-12-14 16:11:33','',''),(833,'1','302','1',1,'Retail Sale Id 804',802.24,0.00,0.00,1.09,65.40,'2022-12-14 16:28:55','',''),(834,'1','302','1',1,'Retail Sale Id 805',8199.04,0.00,0.00,11.14,668.40,'2022-12-14 16:50:19','',''),(835,'1','302','1',1,'Retail Sale Id 806',2001.92,0.00,0.00,2.72,163.20,'2022-12-14 17:32:05','',''),(836,'1','302','1',1,'Retail Sale Id 807',4423.36,0.00,0.00,6.01,360.60,'2022-12-14 17:45:47','',''),(837,'1','302','1',1,'Retail Sale Id 808',4496.96,0.00,0.00,6.11,366.60,'2022-12-14 17:56:34','',''),(838,'1','302','1',1,'Retail Sale Id 809',3702.08,0.00,0.00,5.03,301.80,'2022-12-14 17:59:46','',''),(839,'1','302','1',1,'Retail Sale Id 810',4423.36,0.00,0.00,6.01,360.60,'2022-12-14 18:01:49','',''),(840,'1','302','1',1,'Retail Sale Id 811',9200.00,0.00,0.00,12.50,750.00,'2022-12-14 18:10:02','',''),(841,'1','302','1',1,'Retail Sale Id 812',73.60,0.00,0.00,0.10,6.00,'2022-12-14 18:36:24','',''),(842,'1','302','1',1,'Retail Sale Id 813',4416.00,0.00,0.00,6.00,360.00,'2022-12-15 08:21:05','',''),(843,'1','302','1',1,'Retail Sale Id 814',2502.40,0.00,0.00,3.40,204.00,'2022-12-15 08:22:00','',''),(844,'1','302','1',1,'Retail Sale Id 815',9200.00,0.00,0.00,12.50,750.00,'2022-12-15 08:31:19','',''),(845,'1','302','1',1,'Retail Sale Id 816',3797.76,0.00,0.00,5.16,309.60,'2022-12-15 08:32:46','',''),(846,'1','302','1',1,'Retail Sale Id 817',3002.88,0.00,0.00,4.08,244.80,'2022-12-15 08:34:07','',''),(847,'1','302','1',1,'Retail Sale Id 818',1000.96,0.00,0.00,1.36,81.60,'2022-12-15 08:35:15','',''),(848,'1','302','1',1,'Retail Sale Id 819',4496.96,0.00,0.00,6.11,366.60,'2022-12-15 08:36:44','',''),(849,'1','302','1',1,'Retail Sale Id 820',2208.00,0.00,0.00,3.00,180.00,'2022-12-15 08:54:42','',''),(850,'1','302','1',1,'Retail Sale Id 821',1000.96,0.00,0.00,1.36,81.60,'2022-12-15 08:55:26','',''),(851,'1','302','1',1,'Retail Sale Id 822',9200.00,0.00,0.00,12.50,750.00,'2022-12-15 09:59:49','',''),(852,'1','302','1',1,'Retail Sale Id 823',3680.00,0.00,0.00,5.00,300.00,'2022-12-15 10:07:42','',''),(853,'1','302','1',1,'Retail Sale Id 824',7360.00,0.00,0.00,10.00,600.00,'2022-12-15 10:31:14','',''),(854,'1','302','1',1,'Retail Sale Id 825',1501.44,0.00,0.00,2.04,122.40,'2022-12-15 10:33:10','',''),(855,'1','302','1',1,'Retail Sale Id 826',17750.00,0.00,0.00,25.00,850.00,'2022-12-15 10:35:13','',''),(856,'1','302','1',1,'Retail Sale Id 827',2208.00,0.00,0.00,3.00,180.00,'2022-12-15 10:46:44','',''),(857,'1','302','1',1,'Retail Sale Id 828',1398.40,0.00,0.00,1.90,114.00,'2022-12-15 10:47:46','',''),(858,'1','302','1',1,'Retail Sale Id 829',4997.44,0.00,0.00,6.79,407.40,'2022-12-15 10:52:11','',''),(859,'1','302','1',1,'Retail Sale Id 830',1501.44,0.00,0.00,2.04,122.40,'2022-12-15 10:56:17','',''),(860,'1','302','1',1,'Retail Sale Id 831',2208.00,0.00,0.00,3.00,180.00,'2022-12-15 10:59:28','',''),(861,'1','302','1',1,'Retail Sale Id 832',9200.00,0.00,0.00,12.50,750.00,'2022-12-15 11:28:57','',''),(862,'1','302','1',1,'Retail Sale Id 833',9200.00,0.00,0.00,12.50,750.00,'2022-12-15 12:45:48','',''),(863,'1','302','1',1,'Retail Sale Id 834',26297.28,0.00,0.00,35.73,2143.80,'2022-12-15 13:00:48','',''),(864,'1','302','1',1,'Retail Sale Id 835',4416.00,0.00,0.00,6.00,360.00,'2022-12-15 13:27:32','',''),(865,'1','302','1',1,'Retail Sale Id 836',4416.00,0.00,0.00,6.00,360.00,'2022-12-15 13:32:58','',''),(866,'1','302','1',1,'Retail Sale Id 837',9200.00,0.00,0.00,12.50,750.00,'2022-12-15 13:56:09','',''),(867,'1','302','1',1,'Retail Sale Id 838',1501.44,0.00,0.00,2.04,122.40,'2022-12-15 14:03:18','',''),(868,'1','302','1',1,'Retail Sale Id 839',1501.44,0.00,0.00,2.04,122.40,'2022-12-15 14:07:22','',''),(869,'1','302','1',1,'Retail Sale Id 840',1000.96,0.00,0.00,1.36,81.60,'2022-12-15 14:12:37','',''),(870,'1','302','1',1,'Retail Sale Id 841',9200.00,0.00,0.00,12.50,750.00,'2022-12-15 14:18:14','',''),(871,'1','302','1',1,'Retail Sale Id 842',4496.96,0.00,0.00,6.11,366.60,'2022-12-15 15:09:54','',''),(872,'1','302','1',1,'Retail Sale Id 843',2001.92,0.00,0.00,2.72,163.20,'2022-12-15 15:17:16','',''),(873,'1','302','1',1,'Retail Sale Id 844',3002.88,0.00,0.00,4.08,244.80,'2022-12-15 15:19:05','',''),(874,'1','302','1',1,'Retail Sale Id 845',2502.40,0.00,0.00,3.40,204.00,'2022-12-15 15:20:28','',''),(875,'1','302','1',1,'Retail Sale Id 846',3680.00,0.00,0.00,5.00,300.00,'2022-12-15 15:23:22','',''),(876,'1','302','1',1,'Retail Sale Id 847',4496.96,0.00,0.00,6.11,366.60,'2022-12-15 15:38:41','',''),(877,'1','302','1',1,'Retail Sale Id 848',802.24,0.00,0.00,1.09,65.40,'2022-12-15 15:43:37','',''),(878,'1','302','1',1,'Retail Sale Id 849',3996.48,0.00,0.00,5.43,325.80,'2022-12-15 15:45:29','',''),(879,'1','302','1',1,'Retail Sale Id 850',9303.04,0.00,0.00,12.64,758.40,'2022-12-15 15:52:58','',''),(880,'1','302','1',1,'Retail Sale Id 851',4496.96,0.00,0.00,6.11,366.60,'2022-12-15 15:57:20','',''),(881,'1','302','1',1,'Retail Sale Id 852',736.00,0.00,0.00,1.00,60.00,'2022-12-15 16:06:49','',''),(882,'1','302','1',1,'Retail Sale Id 853',9200.00,0.00,0.00,12.50,750.00,'2022-12-15 16:27:25','',''),(883,'1','302','1',1,'Retail Sale Id 857',4423.36,0.00,0.00,6.01,360.60,'2022-12-15 16:31:57','',''),(884,'1','302','1',1,'Retail Sale Id 858',4496.96,0.00,0.00,6.11,366.60,'2022-12-15 16:34:46','',''),(885,'1','302','1',1,'Retail Sale Id 859',2303.68,0.00,0.00,3.13,187.80,'2022-12-15 16:38:10','',''),(886,'1','302','1',1,'Retail Sale Id 860',802.24,0.00,0.00,1.09,65.40,'2022-12-15 16:39:32','',''),(887,'1','302','1',1,'Retail Sale Id 861',4496.96,0.00,0.00,6.11,366.60,'2022-12-15 16:40:22','',''),(888,'1','302','1',1,'Retail Sale Id 862',2208.00,0.00,0.00,3.00,180.00,'2022-12-15 17:55:16','',''),(889,'1','302','1',1,'Retail Sale Id 863',1000.96,0.00,0.00,1.36,81.60,'2022-12-15 18:06:13','',''),(890,'1','302','1',1,'Return of Retail Sale Id 863',0.00,1000.96,1.36,0.00,-81.60,'2022-12-15 18:30:13','',''),(891,'1','302','1',1,'Retail Sale Id 864',993.60,0.00,0.00,1.35,81.00,'2022-12-15 18:31:27','',''),(892,'1','302','1',1,'Retail Sale Id 865',4452.80,0.00,0.00,6.05,363.00,'2022-12-16 07:55:51','',''),(893,'1','302','1',1,'Retail Sale Id 866',1472.00,0.00,0.00,2.00,120.00,'2022-12-16 08:07:31','',''),(894,'1','302','1',1,'Retail Sale Id 867',3702.08,0.00,0.00,5.03,301.80,'2022-12-16 08:14:28','',''),(895,'1','302','1',1,'Retail Sale Id 868',802.24,0.00,0.00,1.09,65.40,'2022-12-16 08:30:36','',''),(896,'1','302','1',1,'Retail Sale Id 869',4423.36,0.00,0.00,6.01,360.60,'2022-12-16 08:57:40','',''),(897,'1','302','1',1,'Retail Sale Id 869',4430.72,0.00,0.00,6.02,361.20,'2022-12-16 08:57:40','',''),(898,'1','302','1',1,'Retail Sale Id 870',1501.44,0.00,0.00,2.04,122.40,'2022-12-16 08:59:28','',''),(899,'1','302','1',1,'Retail Sale Id 871',9200.00,0.00,0.00,12.50,750.00,'2022-12-16 09:23:20','',''),(900,'1','302','1',1,'Retail Sale Id 872',2208.00,0.00,0.00,3.00,180.00,'2022-12-16 09:33:28','',''),(901,'1','302','1',1,'Retail Sale Id 873',3002.88,0.00,0.00,4.08,244.80,'2022-12-16 09:34:39','',''),(902,'1','302','1',1,'Retail Sale Id 874',18400.00,0.00,0.00,25.00,1500.00,'2022-12-16 09:43:52','',''),(903,'1','302','1',1,'Retail Sale Id 875',4423.36,0.00,0.00,6.01,360.60,'2022-12-16 10:06:25','',''),(904,'1','302','1',1,'Retail Sale Id 876',1501.44,0.00,0.00,2.04,122.40,'2022-12-16 10:07:37','',''),(905,'1','302','1',1,'Retail Sale Id 877',142000.00,0.00,0.00,200.00,6800.00,'2022-12-16 10:08:34','',''),(906,'1','302','1',1,'Retail Sale Id 878',4496.96,0.00,0.00,6.11,366.60,'2022-12-16 10:09:40','',''),(907,'1','302','1',1,'Retail Sale Id 879',4997.44,0.00,0.00,6.79,407.40,'2022-12-16 10:10:21','',''),(908,'1','302','1',1,'Retail Sale Id 880',3996.48,0.00,0.00,5.43,325.80,'2022-12-16 10:15:57','',''),(909,'1','302','1',1,'Retail Sale Id 881',2001.92,0.00,0.00,2.72,163.20,'2022-12-16 10:16:34','',''),(910,'1','302','1',1,'Retail Sale Id 881',3002.88,0.00,0.00,4.08,244.80,'2022-12-16 10:16:34','',''),(911,'1','302','1',1,'Retail Sale Id 882',4401.28,0.00,0.00,5.98,358.80,'2022-12-16 10:22:02','',''),(912,'1','302','1',1,'Retail Sale Id 883',1501.44,0.00,0.00,2.04,122.40,'2022-12-16 10:29:00','',''),(913,'1','302','1',1,'Retail Sale Id 884',4401.28,0.00,0.00,5.98,358.80,'2022-12-16 10:32:39','',''),(914,'1','302','1',1,'Retail Sale Id 884',9200.00,0.00,0.00,12.50,750.00,'2022-12-16 10:32:39','',''),(915,'1','302','1',1,'Retail Sale Id 885',9200.00,0.00,0.00,12.50,750.00,'2022-12-16 10:34:38','',''),(916,'1','302','1',1,'Retail Sale Id 886',4423.36,0.00,0.00,6.01,360.60,'2022-12-16 10:41:14','',''),(917,'1','302','1',1,'Retail Sale Id 887',9200.00,0.00,0.00,12.50,750.00,'2022-12-16 10:47:06','',''),(918,'1','302','1',1,'Retail Sale Id 888',11360.00,0.00,0.00,16.00,544.00,'2022-12-16 11:07:00','',''),(919,'1','302','1',1,'Retail Sale Id 889',1501.44,0.00,0.00,2.04,122.40,'2022-12-16 11:08:11','',''),(920,'1','302','1',1,'Retail Sale Id 890',2208.00,0.00,0.00,3.00,180.00,'2022-12-16 11:11:55','',''),(921,'1','302','1',1,'Retail Sale Id 890',4416.00,0.00,0.00,6.00,360.00,'2022-12-16 11:11:55','',''),(922,'1','302','1',1,'Retail Sale Id 891',1000.96,0.00,0.00,1.36,81.60,'2022-12-16 11:13:33','',''),(923,'1','302','1',1,'Retail Sale Id 891',1000.96,0.00,0.00,1.36,81.60,'2022-12-16 11:13:33','',''),(924,'1','302','1',1,'Retail Sale Id 892',7100.00,0.00,0.00,10.00,340.00,'2022-12-16 11:16:21','',''),(925,'1','302','1',1,'Retail Sale Id 893',9200.00,0.00,0.00,12.50,750.00,'2022-12-16 11:18:20','',''),(926,'1','302','1',1,'Retail Sale Id 894',9001.28,0.00,0.00,12.23,733.80,'2022-12-16 11:33:14','',''),(927,'1','302','1',1,'Retail Sale Id 895',1000.96,0.00,0.00,1.36,81.60,'2022-12-16 11:41:56','',''),(928,'1','302','1',1,'Retail Sale Id 896',9200.00,0.00,0.00,12.50,750.00,'2022-12-16 12:01:03','',''),(929,'1','302','1',1,'Retail Sale Id 897',9303.04,0.00,0.00,12.64,758.40,'2022-12-16 12:04:29','',''),(930,'1','302','1',1,'Retail Sale Id 898',9200.00,0.00,0.00,12.50,750.00,'2022-12-16 12:05:43','',''),(931,'1','302','1',1,'Retail Sale Id 899',1501.44,0.00,0.00,2.04,122.40,'2022-12-16 12:07:59','',''),(932,'1','302','1',1,'Retail Sale Id 900',4423.36,0.00,0.00,6.01,360.60,'2022-12-16 12:12:37','',''),(933,'1','302','1',1,'Retail Sale Id 901',3996.48,0.00,0.00,5.43,325.80,'2022-12-16 12:13:43','',''),(934,'1','302','1',1,'Retail Sale Id 902',1000.96,0.00,0.00,1.36,81.60,'2022-12-16 12:14:37','',''),(935,'1','302','1',1,'Retail Sale Id 903',2200.64,0.00,0.00,2.99,179.40,'2022-12-16 12:24:13','',''),(936,'1','302','1',1,'Retail Sale Id 904',9200.00,0.00,0.00,12.50,750.00,'2022-12-16 12:32:08','',''),(937,'1','302','1',1,'Retail Sale Id 905',6999.36,0.00,0.00,9.51,570.60,'2022-12-16 12:32:58','',''),(938,'1','302','1',1,'Retail Sale Id 906',5998.40,0.00,0.00,8.15,489.00,'2022-12-16 12:54:28','',''),(939,'1','302','1',1,'Retail Sale Id 907',9200.00,0.00,0.00,12.50,750.00,'2022-12-16 12:56:32','',''),(940,'1','302','1',1,'Retail Sale Id 908',9200.00,0.00,0.00,12.50,750.00,'2022-12-16 13:02:18','',''),(941,'1','302','1',1,'Retail Sale Id 909',2001.92,0.00,0.00,2.72,163.20,'2022-12-16 13:04:58','',''),(942,'1','302','1',1,'Retail Sale Id 910',2502.40,0.00,0.00,3.40,204.00,'2022-12-16 13:06:34','',''),(943,'1','302','1',1,'Retail Sale Id 911',4298.24,0.00,0.00,5.84,350.40,'2022-12-16 13:12:34','',''),(944,'1','302','1',1,'Retail Sale Id 912',9200.00,0.00,0.00,12.50,750.00,'2022-12-16 13:15:05','',''),(945,'1','302','1',1,'Retail Sale Id 913',4496.96,0.00,0.00,6.11,366.60,'2022-12-16 13:16:46','',''),(946,'1','302','1',1,'Retail Sale Id 914',9200.00,0.00,0.00,12.50,750.00,'2022-12-16 13:23:22','',''),(947,'1','302','1',1,'Retail Sale Id 915',4496.96,0.00,0.00,6.11,366.60,'2022-12-16 13:52:04','',''),(948,'1','302','1',1,'Retail Sale Id 916',18400.00,0.00,0.00,25.00,1500.00,'2022-12-16 14:13:37','',''),(949,'1','302','1',1,'Retail Sale Id 917',1000.96,0.00,0.00,1.36,81.60,'2022-12-16 14:14:16','',''),(950,'1','302','1',1,'Retail Sale Id 918',4401.28,0.00,0.00,5.98,358.80,'2022-12-16 14:33:46','',''),(951,'1','302','1',1,'Retail Sale Id 918',4401.28,0.00,0.00,5.98,358.80,'2022-12-16 14:33:46','',''),(952,'1','302','1',1,'Retail Sale Id 919',9200.00,0.00,0.00,12.50,750.00,'2022-12-16 14:39:16','',''),(953,'1','302','1',1,'Retail Sale Id 920',36800.00,0.00,0.00,50.00,3000.00,'2022-12-16 14:48:11','',''),(954,'1','302','1',1,'Retail Sale Id 921',4423.36,0.00,0.00,6.01,360.60,'2022-12-16 14:49:40','',''),(955,'1','302','1',1,'Retail Sale Id 922',1000.96,0.00,0.00,1.36,81.60,'2022-12-16 14:57:02','',''),(956,'1','302','1',1,'Retail Sale Id 923',1000.96,0.00,0.00,1.36,81.60,'2022-12-16 15:01:59','',''),(957,'1','302','1',1,'Retail Sale Id 924',2252.16,0.00,0.00,3.06,183.60,'2022-12-16 15:13:50','',''),(958,'1','302','1',1,'Retail Sale Id 924',2951.36,0.00,0.00,4.01,240.60,'2022-12-16 15:13:50','',''),(959,'1','302','1',1,'Retail Sale Id 925',9200.00,0.00,0.00,12.50,750.00,'2022-12-16 15:17:20','',''),(960,'1','302','1',1,'Retail Sale Id 926',1501.44,0.00,0.00,2.04,122.40,'2022-12-16 16:26:34','',''),(961,'1','302','1',1,'Retail Sale Id 927',2001.92,0.00,0.00,2.72,163.20,'2022-12-16 16:36:55','',''),(962,'1','302','1',1,'Retail Sale Id 928',1501.44,0.00,0.00,2.04,122.40,'2022-12-16 16:38:02','',''),(963,'1','302','1',1,'Retail Sale Id 929',1501.44,0.00,0.00,2.04,122.40,'2022-12-16 16:51:14','',''),(964,'1','302','1',1,'Retail Sale Id 930',4423.36,0.00,0.00,6.01,360.60,'2022-12-16 16:55:37','',''),(965,'1','302','1',1,'Retail Sale Id 931',9200.00,0.00,0.00,12.50,750.00,'2022-12-16 16:57:35','',''),(966,'1','302','1',1,'Retail Sale Id 932',1000.96,0.00,0.00,1.36,81.60,'2022-12-16 17:10:17','',''),(967,'1','302','1',1,'Retail Sale Id 933',1000.96,0.00,0.00,1.36,81.60,'2022-12-16 17:13:53','',''),(968,'1','302','1',1,'Retail Sale Id 934',4423.36,0.00,0.00,6.01,360.60,'2022-12-16 17:19:13','',''),(969,'1','302','1',1,'Retail Sale Id 935',4423.36,0.00,0.00,6.01,360.60,'2022-12-16 17:29:07','',''),(970,'1','302','1',1,'Retail Sale Id 936',3680.00,0.00,0.00,5.00,300.00,'2022-12-16 17:39:50','',''),(971,'1','302','1',1,'Retail Sale Id 937',4423.36,0.00,0.00,6.01,360.60,'2022-12-16 17:51:32','',''),(972,'1','302','1',1,'Retail Sale Id 938',1000.96,0.00,0.00,1.36,81.60,'2022-12-16 18:00:59','',''),(973,'1','302','1',1,'Retail Sale Id 939',3702.08,0.00,0.00,5.03,301.80,'2022-12-16 18:13:56','',''),(974,'1','302','1',1,'Retail Sale Id 940',2001.92,0.00,0.00,2.72,163.20,'2022-12-16 18:16:22','',''),(975,'1','302','1',1,'Return of Retail Sale Id 937',0.00,4423.36,6.01,0.00,-360.60,'2022-12-16 18:53:45','',''),(976,'1','302','1',1,'Retail Sale Id 941',3208.96,0.00,0.00,4.36,261.60,'2022-12-16 18:55:51','',''),(977,'1','302','1',1,'Retail Sale Id 942',3702.08,0.00,0.00,5.03,301.80,'2022-12-17 07:35:28','',''),(978,'1','302','1',1,'Retail Sale Id 943',1501.44,0.00,0.00,2.04,122.40,'2022-12-17 07:41:23','',''),(979,'1','302','1',1,'Retail Sale Id 944',2208.00,0.00,0.00,3.00,180.00,'2022-12-17 07:45:08','',''),(980,'1','302','1',1,'Retail Sale Id 945',3702.08,0.00,0.00,5.03,301.80,'2022-12-17 08:04:18','',''),(981,'1','302','1',1,'Retail Sale Id 946',500.48,0.00,0.00,0.68,40.80,'2022-12-17 08:08:59','',''),(982,'1','302','1',1,'Retail Sale Id 947',4496.96,0.00,0.00,6.11,366.60,'2022-12-17 08:23:13','',''),(983,'1','302','1',1,'Retail Sale Id 948',2001.92,0.00,0.00,2.72,163.20,'2022-12-17 08:35:27','',''),(984,'1','302','1',1,'Retail Sale Id 949',9200.00,0.00,0.00,12.50,750.00,'2022-12-17 08:40:40','',''),(985,'1','302','1',1,'Retail Sale Id 950',1501.44,0.00,0.00,2.04,122.40,'2022-12-17 08:47:28','',''),(986,'1','302','1',1,'Retail Sale Id 952',699.20,0.00,0.00,0.95,57.00,'2022-12-17 08:57:03','',''),(987,'1','302','1',1,'Retail Sale Id 953',4416.00,0.00,0.00,6.00,360.00,'2022-12-17 09:00:39','',''),(988,'1','302','1',1,'Retail Sale Id 954',3002.88,0.00,0.00,4.08,244.80,'2022-12-17 09:01:33','',''),(989,'1','302','1',1,'Retail Sale Id 955',2001.92,0.00,0.00,2.72,163.20,'2022-12-17 09:06:06','',''),(990,'1','302','1',1,'Retail Sale Id 956',1501.44,0.00,0.00,2.04,122.40,'2022-12-17 09:18:33','',''),(991,'1','302','1',1,'Retail Sale Id 957',4452.80,0.00,0.00,6.05,363.00,'2022-12-17 09:20:43','',''),(992,'1','302','1',1,'Retail Sale Id 958',36800.00,0.00,0.00,50.00,3000.00,'2022-12-17 09:30:51','',''),(993,'1','302','1',1,'Retail Sale Id 960',3002.88,0.00,0.00,4.08,244.80,'2022-12-17 09:41:40','',''),(994,'1','302','1',1,'Retail Sale Id 961',4452.80,0.00,0.00,6.05,363.00,'2022-12-17 09:44:12','',''),(995,'1','302','1',1,'Retail Sale Id 962',9200.00,0.00,0.00,12.50,750.00,'2022-12-17 10:00:47','',''),(996,'1','302','1',1,'Retail Sale Id 963',1501.44,0.00,0.00,2.04,122.40,'2022-12-17 10:45:14','',''),(997,'1','302','1',1,'Retail Sale Id 964',4496.96,0.00,0.00,6.11,366.60,'2022-12-17 10:50:34','',''),(998,'1','302','1',1,'Retail Sale Id 965',750.72,0.00,0.00,1.02,61.20,'2022-12-17 10:57:12','',''),(999,'1','302','1',1,'Retail Sale Id 966',4452.80,0.00,0.00,6.05,363.00,'2022-12-17 11:14:08','',''),(1000,'1','302','1',1,'Retail Sale Id 967',2200.64,0.00,0.00,2.99,179.40,'2022-12-17 11:45:05','',''),(1001,'1','302','1',1,'Retail Sale Id 968',2252.16,0.00,0.00,3.06,183.60,'2022-12-17 11:46:54','',''),(1002,'1','302','1',1,'Retail Sale Id 969',7360.00,0.00,0.00,10.00,600.00,'2022-12-17 11:48:16','',''),(1003,'1','302','1',1,'Retail Sale Id 971',3996.48,0.00,0.00,5.43,325.80,'2022-12-17 11:57:55','',''),(1004,'1','302','1',1,'Retail Sale Id 972',1000.96,0.00,0.00,1.36,81.60,'2022-12-17 12:05:25','',''),(1005,'1','302','1',1,'Retail Sale Id 972',1000.96,0.00,0.00,1.36,81.60,'2022-12-17 12:05:25','',''),(1006,'1','302','1',1,'Retail Sale Id 973',4496.96,0.00,0.00,6.11,366.60,'2022-12-17 12:18:07','',''),(1007,'1','302','1',1,'Retail Sale Id 974',9200.00,0.00,0.00,12.50,750.00,'2022-12-17 12:19:14','',''),(1008,'1','302','1',1,'Retail Sale Id 975',802.24,0.00,0.00,1.09,65.40,'2022-12-17 12:30:48','',''),(1009,'1','302','1',1,'Retail Sale Id 976',4997.44,0.00,0.00,6.79,407.40,'2022-12-17 12:31:55','',''),(1010,'1','302','1',1,'Retail Sale Id 977',3680.00,0.00,0.00,5.00,300.00,'2022-12-17 12:39:39','',''),(1011,'1','302','1',1,'Retail Sale Id 978',4416.00,0.00,0.00,6.00,360.00,'2022-12-17 12:41:28','',''),(1012,'1','302','1',1,'Retail Sale Id 979',2252.16,0.00,0.00,3.06,183.60,'2022-12-17 12:43:30','',''),(1013,'1','302','1',1,'Retail Sale Id 979',2252.16,0.00,0.00,3.06,183.60,'2022-12-17 12:43:30','',''),(1014,'1','302','1',1,'Retail Sale Id 980',9200.00,0.00,0.00,12.50,750.00,'2022-12-17 13:11:56','',''),(1015,'1','302','1',1,'Retail Sale Id 982',2252.16,0.00,0.00,3.06,183.60,'2022-12-17 13:13:50','',''),(1016,'1','302','1',1,'Retail Sale Id 984',35500.00,0.00,0.00,50.00,1700.00,'2022-12-17 13:24:44','',''),(1017,'1','302','1',1,'Retail Sale Id 985',1501.44,0.00,0.00,2.04,122.40,'2022-12-17 13:27:41','',''),(1018,'1','302','1',1,'Retail Sale Id 987',4496.96,0.00,0.00,6.11,366.60,'2022-12-17 13:41:46','',''),(1019,'1','302','1',1,'Retail Sale Id 988',9001.28,0.00,0.00,12.23,733.80,'2022-12-17 13:53:52','',''),(1020,'1','302','1',1,'Retail Sale Id 989',5152.00,0.00,0.00,7.00,420.00,'2022-12-17 14:12:53','',''),(1021,'1','302','1',1,'Retail Sale Id 990',1472.00,0.00,0.00,2.00,120.00,'2022-12-17 14:17:38','',''),(1022,'1','302','1',1,'Retail Sale Id 992',2944.00,0.00,0.00,4.00,240.00,'2022-12-17 14:22:03','',''),(1023,'1','302','1',1,'Retail Sale Id 993',4496.96,0.00,0.00,6.11,366.60,'2022-12-17 14:53:13','',''),(1024,'1','302','1',1,'Retail Sale Id 994',2001.92,0.00,0.00,2.72,163.20,'2022-12-17 14:59:20','',''),(1025,'1','302','1',1,'Retail Sale Id 995',6999.36,0.00,0.00,9.51,570.60,'2022-12-17 14:59:57','',''),(1026,'1','302','1',1,'Retail Sale Id 996',728.64,0.00,0.00,0.99,59.40,'2022-12-17 15:00:40','',''),(1027,'1','302','1',1,'Retail Sale Id 997',7360.00,0.00,0.00,10.00,600.00,'2022-12-17 15:08:36','',''),(1028,'1','302','1',1,'Retail Sale Id 998',4423.36,0.00,0.00,6.01,360.60,'2022-12-17 15:15:10','',''),(1029,'1','302','1',1,'Retail Sale Id 999',3797.76,0.00,0.00,5.16,309.60,'2022-12-17 15:17:47','',''),(1030,'1','302','1',1,'Retail Sale Id 1000',2200.64,0.00,0.00,2.99,179.40,'2022-12-17 15:20:48','',''),(1031,'1','302','1',1,'Retail Sale Id 1001',2001.92,0.00,0.00,2.72,163.20,'2022-12-17 15:24:25','',''),(1032,'1','302','1',1,'Retail Sale Id 1002',3680.00,0.00,0.00,5.00,300.00,'2022-12-17 15:44:40','',''),(1033,'1','302','1',1,'Retail Sale Id 1007',4997.44,0.00,0.00,6.79,407.40,'2022-12-17 15:54:09','',''),(1034,'1','302','1',1,'Retail Sale Id 1008',2001.92,0.00,0.00,2.72,163.20,'2022-12-17 16:37:32','',''),(1035,'1','302','1',1,'Retail Sale Id 1010',1472.00,0.00,0.00,2.00,120.00,'2022-12-17 16:48:06','',''),(1036,'1','302','1',1,'Retail Sale Id 1011',1501.44,0.00,0.00,2.04,122.40,'2022-12-17 16:50:51','',''),(1037,'1','302','1',1,'Retail Sale Id 1012',2208.00,0.00,0.00,3.00,180.00,'2022-12-17 16:53:01','',''),(1038,'1','302','1',1,'Retail Sale Id 1013',1501.44,0.00,0.00,2.04,122.40,'2022-12-17 17:14:14','',''),(1039,'1','302','1',1,'Retail Sale Id 1014',1501.44,0.00,0.00,2.04,122.40,'2022-12-17 17:21:34','',''),(1040,'1','302','1',1,'Retail Sale Id 1015',5998.40,0.00,0.00,8.15,489.00,'2022-12-17 17:37:46','',''),(1041,'1','302','1',1,'Retail Sale Id 1016',2208.00,0.00,0.00,3.00,180.00,'2022-12-17 17:41:27','',''),(1042,'1','302','1',1,'Retail Sale Id 1017',1000.96,0.00,0.00,1.36,81.60,'2022-12-17 17:53:13','',''),(1043,'1','302','1',1,'Retail Sale Id 1018',4997.44,0.00,0.00,6.79,407.40,'2022-12-17 18:16:40','',''),(1044,'1','302','1',1,'Retail Sale Id 1019',22.08,0.00,0.00,0.03,1.80,'2022-12-17 18:36:40','',''),(1045,'1','302','1',1,'Retail Sale Id 1020',1000.96,0.00,0.00,1.36,81.60,'2022-12-18 08:25:02','',''),(1046,'1','302','1',1,'Retail Sale Id 1021',750.72,0.00,0.00,1.02,61.20,'2022-12-18 08:38:05','',''),(1047,'1','302','1',1,'Retail Sale Id 1022',3002.88,0.00,0.00,4.08,244.80,'2022-12-18 08:50:01','',''),(1048,'1','302','1',1,'Retail Sale Id 1023',2001.92,0.00,0.00,2.72,163.20,'2022-12-18 09:17:28','',''),(1049,'1','302','1',1,'Retail Sale Id 1024',3702.08,0.00,0.00,5.03,301.80,'2022-12-18 09:18:18','',''),(1050,'1','302','1',1,'Retail Sale Id 1025',2208.00,0.00,0.00,3.00,180.00,'2022-12-18 09:53:21','',''),(1051,'1','302','1',1,'Retail Sale Id 1026',3996.48,0.00,0.00,5.43,325.80,'2022-12-18 09:58:07','',''),(1052,'1','302','1',1,'Retail Sale Id 1027',3702.08,0.00,0.00,5.03,301.80,'2022-12-18 10:10:14','',''),(1053,'1','302','1',1,'Retail Sale Id 1027',9200.00,0.00,0.00,12.50,750.00,'2022-12-18 10:10:14','',''),(1054,'1','302','1',1,'Retail Sale Id 1028',5152.00,0.00,0.00,7.00,420.00,'2022-12-18 10:17:07','',''),(1055,'1','302','1',1,'Retail Sale Id 1029',1501.44,0.00,0.00,2.04,122.40,'2022-12-18 10:17:54','',''),(1056,'1','302','1',1,'Retail Sale Id 1030',1501.44,0.00,0.00,2.04,122.40,'2022-12-18 10:18:34','',''),(1057,'1','302','1',1,'Retail Sale Id 1031',2001.92,0.00,0.00,2.72,163.20,'2022-12-18 10:25:21','',''),(1058,'1','302','1',1,'Retail Sale Id 1032',2252.16,0.00,0.00,3.06,183.60,'2022-12-18 10:30:27','',''),(1059,'1','302','1',1,'Retail Sale Id 1032',9200.00,0.00,0.00,12.50,750.00,'2022-12-18 10:30:27','',''),(1060,'1','302','1',1,'Retail Sale Id 1033',2001.92,0.00,0.00,2.72,163.20,'2022-12-18 10:35:31','',''),(1061,'1','302','1',1,'Retail Sale Id 1034',9200.00,0.00,0.00,12.50,750.00,'2022-12-18 10:39:49','',''),(1062,'1','302','1',1,'Retail Sale Id 1035',4452.80,0.00,0.00,6.05,363.00,'2022-12-18 11:01:37','',''),(1063,'1','302','1',1,'Retail Sale Id 1036',1501.44,0.00,0.00,2.04,122.40,'2022-12-18 11:40:58','',''),(1064,'1','302','1',1,'Retail Sale Id 1038',9001.28,0.00,0.00,12.23,733.80,'2022-12-18 11:43:10','',''),(1065,'1','302','1',1,'Retail Sale Id 1039',4496.96,0.00,0.00,6.11,366.60,'2022-12-18 11:48:19','',''),(1066,'1','302','1',1,'Retail Sale Id 1040',4496.96,0.00,0.00,6.11,366.60,'2022-12-18 12:10:57','',''),(1067,'1','302','1',1,'Retail Sale Id 1041',4452.80,0.00,0.00,6.05,363.00,'2022-12-18 12:28:45','',''),(1068,'1','302','1',1,'Retail Sale Id 1041',4452.80,0.00,0.00,6.05,363.00,'2022-12-18 12:28:45','',''),(1069,'1','302','1',1,'Retail Sale Id 1042',2001.92,0.00,0.00,2.72,163.20,'2022-12-18 12:30:06','',''),(1070,'1','302','1',1,'Retail Sale Id 1043',5152.00,0.00,0.00,7.00,420.00,'2022-12-18 12:42:03','',''),(1071,'1','302','1',1,'Retail Sale Id 1044',1501.44,0.00,0.00,2.04,122.40,'2022-12-18 13:14:56','',''),(1072,'1','302','1',1,'Retail Sale Id 1046',2200.64,0.00,0.00,2.99,179.40,'2022-12-18 13:29:10','',''),(1073,'1','302','1',1,'Retail Sale Id 1047',1501.44,0.00,0.00,2.04,122.40,'2022-12-18 13:47:10','',''),(1074,'1','302','1',1,'Retail Sale Id 1048',1501.44,0.00,0.00,2.04,122.40,'2022-12-18 14:24:41','',''),(1075,'1','302','1',1,'Retail Sale Id 1049',4496.96,0.00,0.00,6.11,366.60,'2022-12-18 14:27:34','',''),(1076,'1','302','1',1,'Retail Sale Id 1050',9200.00,0.00,0.00,12.50,750.00,'2022-12-18 14:34:59','',''),(1077,'1','302','1',1,'Retail Sale Id 1051',9200.00,0.00,0.00,12.50,750.00,'2022-12-18 14:45:58','',''),(1078,'1','302','1',1,'Retail Sale Id 1052',3680.00,0.00,0.00,5.00,300.00,'2022-12-18 14:48:31','',''),(1079,'1','302','1',1,'Retail Sale Id 1053',3002.88,0.00,0.00,4.08,244.80,'2022-12-18 14:52:16','',''),(1080,'1','302','1',1,'Retail Sale Id 1054',18400.00,0.00,0.00,25.00,1500.00,'2022-12-18 14:56:24','',''),(1081,'1','302','1',1,'Retail Sale Id 1055',2796.80,0.00,0.00,3.80,228.00,'2022-12-18 15:48:58','',''),(1082,'1','302','1',1,'Retail Sale Id 1056',2252.16,0.00,0.00,3.06,183.60,'2022-12-18 15:50:01','',''),(1083,'1','302','1',1,'Retail Sale Id 1057',2252.16,0.00,0.00,3.06,183.60,'2022-12-18 16:04:38','',''),(1084,'1','302','1',1,'Retail Sale Id 1057',9200.00,0.00,0.00,12.50,750.00,'2022-12-18 16:04:38','',''),(1085,'1','302','1',1,'Retail Sale Id 1058',2001.92,0.00,0.00,2.72,163.20,'2022-12-18 16:20:28','',''),(1086,'1','302','1',1,'Retail Sale Id 1059',1501.44,0.00,0.00,2.04,122.40,'2022-12-18 16:23:28','',''),(1087,'1','302','1',1,'Retail Sale Id 1060',2001.92,0.00,0.00,2.72,163.20,'2022-12-18 16:25:12','',''),(1088,'1','302','1',1,'Retail Sale Id 1061',1501.44,0.00,0.00,2.04,122.40,'2022-12-18 16:30:24','',''),(1089,'1','302','1',1,'Retail Sale Id 1062',9200.00,0.00,0.00,12.50,750.00,'2022-12-18 16:37:27','',''),(1090,'1','302','1',1,'Retail Sale Id 1063',1000.96,0.00,0.00,1.36,81.60,'2022-12-18 16:43:10','',''),(1091,'1','302','1',1,'Retail Sale Id 1064',1398.40,0.00,0.00,1.90,114.00,'2022-12-18 16:46:05','',''),(1092,'1','302','1',1,'Retail Sale Id 1064',1501.44,0.00,0.00,2.04,122.40,'2022-12-18 16:46:05','',''),(1093,'1','302','1',1,'Retail Sale Id 1065',3002.88,0.00,0.00,4.08,244.80,'2022-12-18 16:56:46','',''),(1094,'1','302','1',1,'Retail Sale Id 1066',3002.88,0.00,0.00,4.08,244.80,'2022-12-18 16:59:07','',''),(1095,'1','302','1',1,'Retail Sale Id 1067',2200.64,0.00,0.00,2.99,179.40,'2022-12-18 17:07:03','',''),(1096,'1','302','1',1,'Retail Sale Id 1069',2200.64,0.00,0.00,2.99,179.40,'2022-12-18 17:12:14','',''),(1097,'1','302','1',1,'Retail Sale Id 1071',18502.60,0.00,0.00,26.06,886.04,'2022-12-18 17:26:42','',''),(1098,'1','302','1',1,'Retail Sale Id 1072',9200.00,0.00,0.00,12.50,750.00,'2022-12-18 17:28:03','',''),(1099,'1','302','1',1,'Retail Sale Id 1073',2208.00,0.00,0.00,3.00,180.00,'2022-12-18 17:38:23','',''),(1100,'1','302','1',1,'Retail Sale Id 1074',4496.96,0.00,0.00,6.11,366.60,'2022-12-18 18:00:55','',''),(1101,'1','302','1',1,'Retail Sale Id 1075',2001.92,0.00,0.00,2.72,163.20,'2022-12-18 18:01:38','',''),(1102,'1','302','1',1,'Retail Sale Id 1076',3002.88,0.00,0.00,4.08,244.80,'2022-12-18 18:09:17','',''),(1103,'1','302','1',1,'Retail Sale Id 1077',728.64,0.00,0.00,0.99,59.40,'2022-12-18 18:21:43','',''),(1104,'1','302','1',1,'Retail Sale Id 1078',22.08,0.00,0.00,0.03,1.80,'2022-12-18 18:43:20','',''),(1105,'1','302','1',1,'Return of Retail Sale Id 1077',0.00,728.64,0.99,0.00,-59.40,'2022-12-18 18:46:41','',''),(1106,'1','302','1',1,'Retail Sale Id 1079',677.12,0.00,0.00,0.92,55.20,'2022-12-18 18:47:50','',''),(1107,'1','302','1',1,'Retail Sale Id 1080',1501.44,0.00,0.00,2.04,122.40,'2022-12-19 07:23:55','',''),(1108,'1','302','1',1,'Retail Sale Id 1081',9200.00,0.00,0.00,12.50,750.00,'2022-12-19 08:43:55','',''),(1109,'1','302','1',1,'Retail Sale Id 1082',1501.44,0.00,0.00,2.04,122.40,'2022-12-19 09:10:24','',''),(1110,'1','302','1',1,'Retail Sale Id 1083',2502.40,0.00,0.00,3.40,204.00,'2022-12-19 09:11:02','',''),(1111,'1','302','1',1,'Retail Sale Id 1084',1000.96,0.00,0.00,1.36,81.60,'2022-12-19 09:14:11','',''),(1112,'1','302','1',1,'Retail Sale Id 1085',2200.64,0.00,0.00,2.99,179.40,'2022-12-19 09:22:34','',''),(1113,'1','302','1',1,'Retail Sale Id 1086',2303.68,0.00,0.00,3.13,187.80,'2022-12-19 09:32:16','',''),(1114,'1','302','1',1,'Retail Sale Id 1087',8000.32,0.00,0.00,10.87,652.20,'2022-12-19 09:34:47','',''),(1115,'1','302','1',1,'Retail Sale Id 1088',4416.00,0.00,0.00,6.00,360.00,'2022-12-19 09:47:35','',''),(1116,'1','302','1',1,'Retail Sale Id 1089',9501.76,0.00,0.00,12.91,774.60,'2022-12-19 09:49:26','',''),(1117,'1','302','1',1,'Retail Sale Id 1090',9303.04,0.00,0.00,12.64,758.40,'2022-12-19 09:51:36','',''),(1118,'1','302','1',1,'Retail Sale Id 1091',2001.92,0.00,0.00,2.72,163.20,'2022-12-19 09:53:08','',''),(1119,'1','302','1',1,'Retail Sale Id 1092',3002.88,0.00,0.00,4.08,244.80,'2022-12-19 09:54:51','',''),(1120,'1','302','1',1,'Retail Sale Id 1093',8000.32,0.00,0.00,10.87,652.20,'2022-12-19 09:57:08','',''),(1121,'1','302','1',1,'Retail Sale Id 1094',3996.48,0.00,0.00,5.43,325.80,'2022-12-19 10:04:08','',''),(1122,'1','302','1',1,'Retail Sale Id 1095',4496.96,0.00,0.00,6.11,366.60,'2022-12-19 10:11:38','',''),(1123,'1','302','1',1,'Retail Sale Id 1096',9200.00,0.00,0.00,12.50,750.00,'2022-12-19 10:12:54','',''),(1124,'1','302','1',1,'Retail Sale Id 1097',4416.00,0.00,0.00,6.00,360.00,'2022-12-19 10:21:47','',''),(1125,'1','302','1',1,'Retail Sale Id 1098',2001.92,0.00,0.00,2.72,163.20,'2022-12-19 10:22:40','',''),(1126,'1','302','1',1,'Retail Sale Id 1099',4416.00,0.00,0.00,6.00,360.00,'2022-12-19 10:28:10','',''),(1127,'1','302','1',1,'Retail Sale Id 1100',3702.08,0.00,0.00,5.03,301.80,'2022-12-19 10:48:49','',''),(1128,'1','302','1',1,'Retail Sale Id 1100',3702.08,0.00,0.00,5.03,301.80,'2022-12-19 10:48:49','',''),(1129,'1','302','1',1,'Retail Sale Id 1101',9200.00,0.00,0.00,12.50,750.00,'2022-12-19 10:56:11','',''),(1130,'1','302','1',1,'Retail Sale Id 1102',4496.96,0.00,0.00,6.11,366.60,'2022-12-19 10:58:13','',''),(1131,'1','302','1',1,'Retail Sale Id 1103',3996.48,0.00,0.00,5.43,325.80,'2022-12-19 11:00:10','',''),(1132,'1','302','1',1,'Retail Sale Id 1104',106500.00,0.00,0.00,150.00,5100.00,'2022-12-19 11:05:58','',''),(1133,'1','302','1',1,'Retail Sale Id 1105',1501.44,0.00,0.00,2.04,122.40,'2022-12-19 11:12:18','',''),(1134,'1','302','1',1,'Retail Sale Id 1106',35500.00,0.00,0.00,50.00,1700.00,'2022-12-19 11:19:36','',''),(1135,'1','302','1',1,'Retail Sale Id 1107',2208.00,0.00,0.00,3.00,180.00,'2022-12-19 11:22:16','',''),(1136,'1','302','1',1,'Retail Sale Id 1108',2001.92,0.00,0.00,2.72,163.20,'2022-12-19 11:24:24','',''),(1137,'1','302','1',1,'Retail Sale Id 1109',2502.40,0.00,0.00,3.40,204.00,'2022-12-19 11:27:08','',''),(1138,'1','302','1',1,'Retail Sale Id 1110',9200.00,0.00,0.00,12.50,750.00,'2022-12-19 11:28:58','',''),(1139,'1','302','1',1,'Retail Sale Id 1110',36800.00,0.00,0.00,50.00,3000.00,'2022-12-19 11:28:58','',''),(1140,'1','302','1',1,'Retail Sale Id 1111',1472.00,0.00,0.00,2.00,120.00,'2022-12-19 11:31:04','',''),(1141,'1','302','1',1,'Retail Sale Id 1111',3680.00,0.00,0.00,5.00,300.00,'2022-12-19 11:31:04','',''),(1142,'1','302','1',1,'Retail Sale Id 1112',3002.88,0.00,0.00,4.08,244.80,'2022-12-19 11:33:55','',''),(1143,'1','302','1',1,'Retail Sale Id 1113',4423.36,0.00,0.00,6.01,360.60,'2022-12-19 11:39:00','',''),(1144,'1','302','1',1,'Retail Sale Id 1114',1501.44,0.00,0.00,2.04,122.40,'2022-12-19 11:45:13','',''),(1145,'1','302','1',1,'Retail Sale Id 1115',4416.00,0.00,0.00,6.00,360.00,'2022-12-19 12:51:09','',''),(1146,'1','302','1',1,'Retail Sale Id 1116',2208.00,0.00,0.00,3.00,180.00,'2022-12-19 13:02:42','',''),(1147,'1','302','1',1,'Retail Sale Id 1116',4416.00,0.00,0.00,6.00,360.00,'2022-12-19 13:02:42','',''),(1148,'1','302','1',1,'Retail Sale Id 1117',26270.00,0.00,0.00,37.00,1258.00,'2022-12-19 13:04:24','',''),(1149,'1','302','1',1,'Retail Sale Id 1118',2303.68,0.00,0.00,3.13,187.80,'2022-12-19 13:09:04','',''),(1150,'1','302','1',1,'Retail Sale Id 1119',33789.76,0.00,0.00,45.91,2754.60,'2022-12-19 13:10:06','',''),(1151,'1','302','1',1,'Retail Sale Id 1120',35500.00,0.00,0.00,50.00,1700.00,'2022-12-19 13:10:58','',''),(1152,'1','302','1',1,'Retail Sale Id 1121',9200.00,0.00,0.00,12.50,750.00,'2022-12-19 13:17:56','',''),(1153,'1','302','1',1,'Retail Sale Id 1122',4496.96,0.00,0.00,6.11,366.60,'2022-12-19 13:34:31','',''),(1154,'1','302','1',1,'Retail Sale Id 1123',3680.00,0.00,0.00,5.00,300.00,'2022-12-19 13:43:19','',''),(1155,'1','302','1',1,'Retail Sale Id 1124',1000.96,0.00,0.00,1.36,81.60,'2022-12-19 13:56:41','',''),(1156,'1','302','1',1,'Retail Sale Id 1125',2001.92,0.00,0.00,2.72,163.20,'2022-12-19 14:01:37','',''),(1157,'1','302','1',1,'Retail Sale Id 1127',2208.00,0.00,0.00,3.00,180.00,'2022-12-19 14:18:47','',''),(1158,'1','302','1',1,'Retail Sale Id 1128',4997.44,0.00,0.00,6.79,407.40,'2022-12-19 14:45:21','',''),(1159,'1','302','1',1,'Retail Sale Id 1129',3503.36,0.00,0.00,4.76,285.60,'2022-12-19 14:47:23','',''),(1160,'1','302','1',1,'Retail Sale Id 1130',3002.88,0.00,0.00,4.08,244.80,'2022-12-19 14:52:23','',''),(1161,'1','302','1',1,'Retail Sale Id 1131',2208.00,0.00,0.00,3.00,180.00,'2022-12-19 14:57:25','',''),(1162,'1','302','1',1,'Retail Sale Id 1132',2208.00,0.00,0.00,3.00,180.00,'2022-12-19 15:03:19','',''),(1163,'1','302','1',1,'Retail Sale Id 1132',2208.00,0.00,0.00,3.00,180.00,'2022-12-19 15:03:19','',''),(1164,'1','302','1',1,'Retail Sale Id 1133',3996.48,0.00,0.00,5.43,325.80,'2022-12-19 15:09:25','',''),(1165,'1','302','1',1,'Retail Sale Id 1134',1501.44,0.00,0.00,2.04,122.40,'2022-12-19 15:19:22','',''),(1166,'1','302','1',1,'Retail Sale Id 1135',2001.92,0.00,0.00,2.72,163.20,'2022-12-19 15:23:01','',''),(1167,'1','302','1',1,'Retail Sale Id 1136',3002.88,0.00,0.00,4.08,244.80,'2022-12-19 15:34:47','',''),(1168,'1','302','1',1,'Retail Sale Id 1137',9200.00,0.00,0.00,12.50,750.00,'2022-12-19 15:48:23','',''),(1169,'1','302','1',1,'Retail Sale Id 1138',4496.96,0.00,0.00,6.11,366.60,'2022-12-19 15:55:21','',''),(1170,'1','302','1',1,'Retail Sale Id 1139',2200.64,0.00,0.00,2.99,179.40,'2022-12-19 16:07:45','',''),(1171,'1','302','1',1,'Retail Sale Id 1140',2303.68,0.00,0.00,3.13,187.80,'2022-12-19 16:08:52','',''),(1172,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,132137.72,195.47,0.00,0.00,'2022-12-19 19:17:53','',''),(1173,'1','302',NULL,1,'Reception corrector for bridging 6',0.00,0.00,0.00,195.47,0.00,'2022-12-19 19:20:33','',''),(1174,'1','302','1',1,'Received from bridging 6',0.00,0.00,195.47,0.00,0.00,'2022-12-19 19:20:33','',''),(1175,'1','302','1',1,'Retail Sale Id 1141',74358.08,0.00,0.00,101.03,6061.80,'2022-12-19 19:24:01','',''),(1176,'1','302','1',1,'Retail Sale Id 1142',35500.00,0.00,0.00,50.00,1700.00,'2022-12-19 19:24:41','',''),(1177,'1','302','1',1,'Retail Sale Id 1143',3002.88,0.00,0.00,4.08,244.80,'2022-12-20 07:31:24','',''),(1178,'1','302','1',1,'Retail Sale Id 1144',9200.00,0.00,0.00,12.50,750.00,'2022-12-20 08:17:56','',''),(1179,'1','302','1',1,'Retail Sale Id 1145',9597.44,0.00,0.00,13.04,782.40,'2022-12-20 08:25:10','',''),(1180,'1','302','1',1,'Retail Sale Id 1146',750.72,0.00,0.00,1.02,61.20,'2022-12-20 08:35:11','',''),(1181,'1','302','1',1,'Retail Sale Id 1147',3503.36,0.00,0.00,4.76,285.60,'2022-12-20 08:35:42','',''),(1182,'1','302','1',1,'Retail Sale Id 1148',802.24,0.00,0.00,1.09,65.40,'2022-12-20 08:36:12','',''),(1183,'1','302','1',1,'Retail Sale Id 1149',2200.64,0.00,0.00,2.99,179.40,'2022-12-20 08:43:19','',''),(1184,'1','302','1',1,'Retail Sale Id 1150',2200.64,0.00,0.00,2.99,179.40,'2022-12-20 08:51:17','',''),(1185,'1','302','1',1,'Retail Sale Id 1151',1000.96,0.00,0.00,1.36,81.60,'2022-12-20 08:52:34','',''),(1186,'1','302','1',1,'Retail Sale Id 1152',4452.80,0.00,0.00,6.05,363.00,'2022-12-20 08:54:11','',''),(1187,'1','302','1',1,'Retail Sale Id 1154',88.32,0.00,0.00,0.12,7.20,'2022-12-20 10:58:15','',''),(1188,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,160712.24,237.74,0.00,0.00,'2022-12-20 14:17:36','',''),(1189,'1','302',NULL,1,'Reception corrector for bridging 7',0.00,0.00,0.00,237.74,0.00,'2022-12-20 14:20:51','',''),(1190,'1','302','1',1,'Received from bridging 7',0.00,0.00,237.74,0.00,0.00,'2022-12-20 14:20:51','',''),(1191,'1','302','1',1,'Retail Sale Id 1155',114587.84,0.00,0.00,155.69,9341.40,'2022-12-20 14:21:24','',''),(1192,'1','302','1',1,'Retail Sale Id 1156',58234.20,0.00,0.00,82.02,2788.68,'2022-12-20 14:22:43','',''),(1193,'1','302','1',1,'Retail Sale Id 1157',22.08,0.00,0.00,0.03,1.80,'2022-12-20 14:23:58','',''),(1194,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3515200.00,5200.00,0.00,0.00,'2022-12-20 16:14:56','',''),(1195,'1','302',NULL,1,'Reception corrector for bridging 8',0.00,0.00,0.00,5200.00,0.00,'2022-12-20 16:16:22','',''),(1196,'1','302','1',1,'Received from bridging 8',0.00,0.00,5200.00,0.00,0.00,'2022-12-20 16:16:22','',''),(1197,'1','302','1',1,'Retail Sale Id 1158',9251.52,0.00,0.00,12.57,754.20,'2022-12-20 16:30:16','',''),(1198,'1','302','1',1,'Retail Sale Id 1158',9251.52,0.00,0.00,12.57,754.20,'2022-12-20 16:30:16','',''),(1199,'1','302','1',1,'Retail Sale Id 1159',9303.04,0.00,0.00,12.64,758.40,'2022-12-20 16:32:21','',''),(1200,'1','302','1',1,'Retail Sale Id 1160',110014.50,0.00,0.00,154.95,5268.30,'2022-12-20 16:34:42','',''),(1201,'1','302','1',1,'Retail Sale Id 1161',65010.88,0.00,0.00,88.33,5299.80,'2022-12-20 16:35:44','',''),(1202,'1','302','1',1,'Retail Sale Id 1162',4673.60,0.00,0.00,6.35,381.00,'2022-12-20 16:45:57','',''),(1203,'1','302','1',1,'Retail Sale Id 1163',1000.96,0.00,0.00,1.36,81.60,'2022-12-20 17:04:21','',''),(1204,'1','302','1',1,'Retail Sale Id 1164',35500.00,0.00,0.00,50.00,1700.00,'2022-12-20 17:23:33','',''),(1205,'1','302','1',1,'Retail Sale Id 1165',9200.00,0.00,0.00,12.50,750.00,'2022-12-20 17:37:21','',''),(1206,'1','302','1',1,'Retail Sale Id 1166',2001.92,0.00,0.00,2.72,163.20,'2022-12-20 17:43:53','',''),(1207,'1','302','1',1,'Retail Sale Id 1167',2208.00,0.00,0.00,3.00,180.00,'2022-12-20 17:47:09','',''),(1208,'1','302','1',1,'Retail Sale Id 1170',1501.44,0.00,0.00,2.04,122.40,'2022-12-20 18:07:36','',''),(1209,'1','302','1',1,'Retail Sale Id 1171',2951.36,0.00,0.00,4.01,240.60,'2022-12-20 18:10:51','',''),(1210,'1','302','1',1,'Retail Sale Id 1172',2252.16,0.00,0.00,3.06,183.60,'2022-12-20 18:27:19','',''),(1211,'1','302','1',1,'Retail Sale Id 1173',802.24,0.00,0.00,1.09,65.40,'2022-12-20 18:35:24','',''),(1212,'1','302','1',1,'Retail Sale Id 1174',213.44,0.00,0.00,0.29,17.40,'2022-12-20 19:04:48','',''),(1213,'1','302','1',1,'Retail Sale Id 1175',4496.96,0.00,0.00,6.11,366.60,'2022-12-21 07:27:41','',''),(1214,'1','302','1',1,'Retail Sale Id 1176',248500.00,0.00,0.00,350.00,11900.00,'2022-12-21 13:07:46','',''),(1215,'1','302','1',1,'Retail Sale Id 1177',148274.56,0.00,0.00,201.46,12087.60,'2022-12-21 13:50:31','',''),(1216,'1','302','1',1,'Retail Sale Id 1178',195250.00,0.00,0.00,275.00,9350.00,'2022-12-21 18:58:16','',''),(1217,'1','302','1',1,'Retail Sale Id 1179',114536.32,0.00,0.00,155.62,9337.20,'2022-12-21 19:00:03','',''),(1218,'1','302','1',1,'Retail Sale Id 1180',14720.00,0.00,0.00,20.00,1200.00,'2022-12-22 07:21:47','',''),(1219,'1','302','1',1,'Retail Sale Id 1181',1000.96,0.00,0.00,1.36,81.60,'2022-12-22 08:33:40','',''),(1220,'1','302','1',1,'Retail Sale Id 1182',34555.20,0.00,0.00,46.95,2817.00,'2022-12-22 12:04:25','',''),(1221,'1','302','1',1,'Retail Sale Id 1183',88750.00,0.00,0.00,125.00,4250.00,'2022-12-22 12:05:50','',''),(1222,'1','302','1',1,'Retail Sale Id 1184',23529.92,0.00,0.00,31.97,1918.20,'2022-12-22 12:07:14','',''),(1223,'1','302','1',1,'Retail Sale Id 1185',33178.88,0.00,0.00,45.08,2704.80,'2022-12-22 12:59:53','',''),(1224,'1','302','1',1,'Retail Sale Id 1186',11672.96,0.00,0.00,15.86,951.60,'2022-12-22 13:40:33','',''),(1225,'1','302','1',1,'Retail Sale Id 1187',802.24,0.00,0.00,1.09,65.40,'2022-12-22 14:02:03','',''),(1226,'1','302','1',1,'Retail Sale Id 1188',4416.00,0.00,0.00,6.00,360.00,'2022-12-22 14:07:31','',''),(1227,'1','302','1',1,'Retail Sale Id 1189',2944.00,0.00,0.00,4.00,240.00,'2022-12-22 14:11:29','',''),(1228,'1','302','1',1,'Retail Sale Id 1190',4416.00,0.00,0.00,6.00,360.00,'2022-12-22 14:12:37','',''),(1229,'1','302','1',1,'Retail Sale Id 1191',4496.96,0.00,0.00,6.11,366.60,'2022-12-22 14:26:44','',''),(1230,'1','302','1',1,'Retail Sale Id 1192',106500.00,0.00,0.00,150.00,5100.00,'2022-12-22 14:27:41','',''),(1231,'1','302','1',1,'Retail Sale Id 1193',1501.44,0.00,0.00,2.04,122.40,'2022-12-22 14:57:05','',''),(1232,'1','302','1',1,'Retail Sale Id 1194',4496.96,0.00,0.00,6.11,366.60,'2022-12-22 15:07:32','',''),(1233,'1','302','1',1,'Retail Sale Id 1195',4997.44,0.00,0.00,6.79,407.40,'2022-12-22 15:24:21','',''),(1234,'1','302','1',1,'Retail Sale Id 1197',2001.92,0.00,0.00,2.72,163.20,'2022-12-22 15:31:48','',''),(1235,'1','302','1',1,'Retail Sale Id 1198',3002.88,0.00,0.00,4.08,244.80,'2022-12-22 15:40:27','',''),(1236,'1','302','1',1,'Retail Sale Id 1199',3061.76,0.00,0.00,4.16,249.60,'2022-12-22 15:50:10','',''),(1237,'1','302','1',1,'Retail Sale Id 1200',9200.00,0.00,0.00,12.50,750.00,'2022-12-22 16:18:22','',''),(1238,'1','302','1',1,'Retail Sale Id 1201',9200.00,0.00,0.00,12.50,750.00,'2022-12-22 16:23:18','',''),(1239,'1','302','1',1,'Retail Sale Id 1202',9200.00,0.00,0.00,12.50,750.00,'2022-12-22 16:31:20','',''),(1240,'1','302','1',1,'Retail Sale Id 1203',2001.92,0.00,0.00,2.72,163.20,'2022-12-22 16:39:12','',''),(1241,'1','302','1',1,'Retail Sale Id 1204',4496.96,0.00,0.00,6.11,366.60,'2022-12-22 16:43:48','',''),(1242,'1','302','1',1,'Retail Sale Id 1205',1501.44,0.00,0.00,2.04,122.40,'2022-12-22 16:45:22','',''),(1243,'1','302','1',1,'Retail Sale Id 1206',9200.00,0.00,0.00,12.50,750.00,'2022-12-22 16:50:56','',''),(1244,'1','302','1',1,'Retail Sale Id 1207',9200.00,0.00,0.00,12.50,750.00,'2022-12-22 16:52:39','',''),(1245,'1','302','1',1,'Retail Sale Id 1210',802.24,0.00,0.00,1.09,65.40,'2022-12-22 17:34:06','',''),(1246,'1','302','1',1,'Retail Sale Id 1211',802.24,0.00,0.00,1.09,65.40,'2022-12-22 17:35:49','',''),(1247,'1','302','1',1,'Retail Sale Id 1212',2001.92,0.00,0.00,2.72,163.20,'2022-12-22 17:54:33','',''),(1248,'1','302','1',1,'Retail Sale Id 1213',9200.00,0.00,0.00,12.50,750.00,'2022-12-22 18:03:54','',''),(1249,'1','302','1',1,'Retail Sale Id 1214',36.80,0.00,0.00,0.05,3.00,'2022-12-22 18:18:21','',''),(1250,'1','302','1',1,'Retail Sale Id 1215',2502.40,0.00,0.00,3.40,204.00,'2022-12-23 07:36:02','',''),(1251,'1','302','1',1,'Retail Sale Id 1216',1501.44,0.00,0.00,2.04,122.40,'2022-12-23 07:49:23','',''),(1252,'1','302','1',1,'Retail Sale Id 1217',1501.44,0.00,0.00,2.04,122.40,'2022-12-23 08:12:36','',''),(1253,'1','302','1',1,'Retail Sale Id 1219',4496.96,0.00,0.00,6.11,366.60,'2022-12-23 08:33:19','',''),(1254,'1','302','1',1,'Retail Sale Id 1220',4496.96,0.00,0.00,6.11,366.60,'2022-12-23 08:34:16','',''),(1255,'1','302','1',1,'Retail Sale Id 1221',4423.36,0.00,0.00,6.01,360.60,'2022-12-23 08:41:35','',''),(1256,'1','302','1',1,'Retail Sale Id 1223',2001.92,0.00,0.00,2.72,163.20,'2022-12-23 08:44:15','',''),(1257,'1','302','1',1,'Retail Sale Id 1225',4496.96,0.00,0.00,6.11,366.60,'2022-12-23 08:47:18','',''),(1258,'1','302','1',1,'Retail Sale Id 1225',4496.96,0.00,0.00,6.11,366.60,'2022-12-23 08:47:18','',''),(1259,'1','302','1',1,'Retail Sale Id 1226',3002.88,0.00,0.00,4.08,244.80,'2022-12-23 08:50:00','',''),(1260,'1','302','1',1,'Retail Sale Id 1227',4496.96,0.00,0.00,6.11,366.60,'2022-12-23 09:04:28','',''),(1261,'1','302','1',1,'Retail Sale Id 1228',2208.00,0.00,0.00,3.00,180.00,'2022-12-23 09:17:35','',''),(1262,'1','302','1',1,'Retail Sale Id 1229',1501.44,0.00,0.00,2.04,122.40,'2022-12-23 09:32:58','',''),(1263,'1','302','1',1,'Retail Sale Id 1230',4496.96,0.00,0.00,6.11,366.60,'2022-12-23 09:51:12','',''),(1264,'1','302','1',1,'Retail Sale Id 1231',3002.88,0.00,0.00,4.08,244.80,'2022-12-23 10:02:30','',''),(1265,'1','302','1',1,'Retail Sale Id 1232',1486.72,0.00,0.00,2.02,121.20,'2022-12-23 10:09:42','',''),(1266,'1','302','1',1,'Retail Sale Id 1232',4416.00,0.00,0.00,6.00,360.00,'2022-12-23 10:09:42','',''),(1267,'1','302','1',1,'Retail Sale Id 1233',802.24,0.00,0.00,1.09,65.40,'2022-12-23 10:13:34','',''),(1268,'1','302','1',1,'Retail Sale Id 1234',4496.96,0.00,0.00,6.11,366.60,'2022-12-23 10:17:55','',''),(1269,'1','302','1',1,'Retail Sale Id 1235',3002.88,0.00,0.00,4.08,244.80,'2022-12-23 10:21:30','',''),(1270,'1','302','1',1,'Retail Sale Id 1236',3503.36,0.00,0.00,4.76,285.60,'2022-12-23 10:27:41','',''),(1271,'1','302','1',1,'Retail Sale Id 1237',6999.36,0.00,0.00,9.51,570.60,'2022-12-23 10:28:33','',''),(1272,'1','302','1',1,'Retail Sale Id 1238',4496.96,0.00,0.00,6.11,366.60,'2022-12-23 10:47:42','',''),(1273,'1','302','1',1,'Retail Sale Id 1239',3503.36,0.00,0.00,4.76,285.60,'2022-12-23 10:53:54','',''),(1274,'1','302','1',1,'Retail Sale Id 1241',3702.08,0.00,0.00,5.03,301.80,'2022-12-23 12:21:58','',''),(1275,'1','302','1',1,'Retail Sale Id 1242',1501.44,0.00,0.00,2.04,122.40,'2022-12-23 12:23:19','',''),(1276,'1','302','1',1,'Retail Sale Id 1243',1501.44,0.00,0.00,2.04,122.40,'2022-12-23 12:28:33','',''),(1277,'1','302','1',1,'Retail Sale Id 1244',802.24,0.00,0.00,1.09,65.40,'2022-12-23 12:33:37','',''),(1278,'1','302','1',1,'Retail Sale Id 1245',3680.00,0.00,0.00,5.00,300.00,'2022-12-23 12:35:10','',''),(1279,'1','302','1',1,'Retail Sale Id 1245',36800.00,0.00,0.00,50.00,3000.00,'2022-12-23 12:35:10','',''),(1280,'1','302','1',1,'Retail Sale Id 1246',2208.00,0.00,0.00,3.00,180.00,'2022-12-23 13:28:20','',''),(1281,'1','302','1',1,'Retail Sale Id 1247',1000.96,0.00,0.00,1.36,81.60,'2022-12-23 13:31:30','',''),(1282,'1','302','1',1,'Retail Sale Id 1247',1000.96,0.00,0.00,1.36,81.60,'2022-12-23 13:31:30','',''),(1283,'1','302','1',1,'Retail Sale Id 1248',2200.64,0.00,0.00,2.99,179.40,'2022-12-23 13:39:46','',''),(1284,'1','302','1',1,'Retail Sale Id 1249',2208.00,0.00,0.00,3.00,180.00,'2022-12-23 13:40:47','',''),(1285,'1','302','1',1,'Retail Sale Id 1250',4997.44,0.00,0.00,6.79,407.40,'2022-12-23 13:44:11','',''),(1286,'1','302','1',1,'Retail Sale Id 1251',1501.44,0.00,0.00,2.04,122.40,'2022-12-23 13:50:05','',''),(1287,'1','302','1',1,'Retail Sale Id 1252',2208.00,0.00,0.00,3.00,180.00,'2022-12-23 13:50:50','',''),(1288,'1','302','1',1,'Retail Sale Id 1253',7360.00,0.00,0.00,10.00,600.00,'2022-12-23 13:56:23','',''),(1289,'1','302','1',1,'Retail Sale Id 1254',1501.44,0.00,0.00,2.04,122.40,'2022-12-23 14:01:13','',''),(1290,'1','302','1',1,'Retail Sale Id 1255',2502.40,0.00,0.00,3.40,204.00,'2022-12-23 14:04:39','',''),(1291,'1','302','1',1,'Retail Sale Id 1256',802.24,0.00,0.00,1.09,65.40,'2022-12-23 14:08:15','',''),(1292,'1','302','1',1,'Retail Sale Id 1257',9200.00,0.00,0.00,12.50,750.00,'2022-12-23 14:15:55','',''),(1293,'1','302','1',1,'Retail Sale Id 1258',9200.00,0.00,0.00,12.50,750.00,'2022-12-23 14:18:54','',''),(1294,'1','302','1',1,'Retail Sale Id 1259',65297.92,0.00,0.00,88.72,5323.20,'2022-12-23 14:32:54','',''),(1295,'1','302','1',1,'Retail Sale Id 1260',1000.96,0.00,0.00,1.36,81.60,'2022-12-23 14:36:05','',''),(1296,'1','302','1',1,'Retail Sale Id 1261',2001.92,0.00,0.00,2.72,163.20,'2022-12-23 14:56:03','',''),(1297,'1','302','1',1,'Retail Sale Id 1261',9200.00,0.00,0.00,12.50,750.00,'2022-12-23 14:56:03','',''),(1298,'1','302','1',1,'Retail Sale Id 1262',6999.36,0.00,0.00,9.51,570.60,'2022-12-23 15:03:23','',''),(1299,'1','302','1',1,'Retail Sale Id 1263',1398.40,0.00,0.00,1.90,114.00,'2022-12-23 15:12:28','',''),(1300,'1','302','1',1,'Retail Sale Id 1264',1000.96,0.00,0.00,1.36,81.60,'2022-12-23 15:13:35','',''),(1301,'1','302','1',1,'Retail Sale Id 1265',1501.44,0.00,0.00,2.04,122.40,'2022-12-23 15:18:04','',''),(1302,'1','302','1',1,'Retail Sale Id 1266',3996.48,0.00,0.00,5.43,325.80,'2022-12-23 15:22:34','',''),(1303,'1','302','1',1,'Retail Sale Id 1266',5998.40,0.00,0.00,8.15,489.00,'2022-12-23 15:22:34','',''),(1304,'1','302','1',1,'Retail Sale Id 1267',3996.48,0.00,0.00,5.43,325.80,'2022-12-23 15:45:29','',''),(1305,'1','302','1',1,'Retail Sale Id 1268',3503.36,0.00,0.00,4.76,285.60,'2022-12-23 16:05:04','',''),(1306,'1','302','1',1,'Retail Sale Id 1269',2208.00,0.00,0.00,3.00,180.00,'2022-12-23 16:06:52','',''),(1307,'1','302','1',1,'Retail Sale Id 1271',897.92,0.00,0.00,1.22,73.20,'2022-12-23 16:20:28','',''),(1308,'1','302','1',1,'Retail Sale Id 1272',4416.00,0.00,0.00,6.00,360.00,'2022-12-23 16:23:52','',''),(1309,'1','302','1',1,'Retail Sale Id 1273',9200.00,0.00,0.00,12.50,750.00,'2022-12-23 16:27:30','',''),(1310,'1','302','1',1,'Retail Sale Id 1274',1000.96,0.00,0.00,1.36,81.60,'2022-12-23 16:31:18','',''),(1311,'1','302','1',1,'Retail Sale Id 1275',3002.88,0.00,0.00,4.08,244.80,'2022-12-23 16:32:04','',''),(1312,'1','302','1',1,'Retail Sale Id 1276',500.48,0.00,0.00,0.68,40.80,'2022-12-23 16:33:46','',''),(1313,'1','302','1',1,'Retail Sale Id 1277',1803.20,0.00,0.00,2.45,147.00,'2022-12-23 16:37:05','',''),(1314,'1','302','1',1,'Retail Sale Id 1278',2208.00,0.00,0.00,3.00,180.00,'2022-12-23 16:48:05','',''),(1315,'1','302','1',1,'Retail Sale Id 1279',4416.00,0.00,0.00,6.00,360.00,'2022-12-23 16:55:50','',''),(1316,'1','302','1',1,'Retail Sale Id 1280',4496.96,0.00,0.00,6.11,366.60,'2022-12-23 16:56:57','',''),(1317,'1','302','1',1,'Retail Sale Id 1281',9200.00,0.00,0.00,12.50,750.00,'2022-12-23 17:53:56','',''),(1318,'1','302','1',1,'Retail Sale Id 1282',2502.40,0.00,0.00,3.40,204.00,'2022-12-23 17:54:22','',''),(1319,'1','302','1',1,'Retail Sale Id 1283',51.52,0.00,0.00,0.07,4.20,'2022-12-23 18:21:16','',''),(1320,'1','302','1',1,'Retail Sale Id 1284',2222.72,0.00,0.00,3.02,181.20,'2022-12-24 07:35:39','',''),(1321,'1','302','1',1,'Retail Sale Id 1285',2001.92,0.00,0.00,2.72,163.20,'2022-12-24 08:01:35','',''),(1322,'1','302','1',1,'Retail Sale Id 1286',4496.96,0.00,0.00,6.11,366.60,'2022-12-24 08:05:05','',''),(1323,'1','302','1',1,'Retail Sale Id 1287',2001.92,0.00,0.00,2.72,163.20,'2022-12-24 08:09:29','',''),(1324,'1','302','1',1,'Retail Sale Id 1288',3002.88,0.00,0.00,4.08,244.80,'2022-12-24 08:20:45','',''),(1325,'1','302','1',1,'Retail Sale Id 1289',2944.00,0.00,0.00,4.00,240.00,'2022-12-24 08:23:06','',''),(1326,'1','302','1',1,'Retail Sale Id 1290',1472.00,0.00,0.00,2.00,120.00,'2022-12-24 08:24:16','',''),(1327,'1','302','1',1,'Retail Sale Id 1291',2208.00,0.00,0.00,3.00,180.00,'2022-12-24 08:42:18','',''),(1328,'1','302','1',1,'Retail Sale Id 1292',1472.00,0.00,0.00,2.00,120.00,'2022-12-24 08:52:10','',''),(1329,'1','302','1',1,'Retail Sale Id 1293',1840.00,0.00,0.00,2.50,150.00,'2022-12-24 09:08:00','',''),(1330,'1','302','1',1,'Retail Sale Id 1294',1501.44,0.00,0.00,2.04,122.40,'2022-12-24 09:20:34','',''),(1331,'1','302','1',1,'Retail Sale Id 1295',6999.36,0.00,0.00,9.51,570.60,'2022-12-24 09:40:46','',''),(1332,'1','302','1',1,'Retail Sale Id 1296',1000.96,0.00,0.00,1.36,81.60,'2022-12-24 09:47:20','',''),(1333,'1','302','1',1,'Retail Sale Id 1297',3680.00,0.00,0.00,5.00,300.00,'2022-12-24 09:52:05','',''),(1334,'1','302','1',1,'Retail Sale Id 1298',7360.00,0.00,0.00,10.00,600.00,'2022-12-24 10:13:16','',''),(1335,'1','302','1',1,'Retail Sale Id 1299',9200.00,0.00,0.00,12.50,750.00,'2022-12-24 10:21:36','',''),(1336,'1','302','1',1,'Retail Sale Id 1300',9200.00,0.00,0.00,12.50,750.00,'2022-12-24 10:29:17','',''),(1337,'1','302','1',1,'Retail Sale Id 1301',1501.44,0.00,0.00,2.04,122.40,'2022-12-24 10:38:22','',''),(1338,'1','302','1',1,'Retail Sale Id 1302',68870.00,0.00,0.00,97.00,3298.00,'2022-12-24 10:46:41','',''),(1339,'1','302','1',1,'Retail Sale Id 1303',9200.00,0.00,0.00,12.50,750.00,'2022-12-24 10:48:20','',''),(1340,'1','302','1',1,'Retail Sale Id 1304',9200.00,0.00,0.00,12.50,750.00,'2022-12-24 10:50:54','',''),(1341,'1','302','1',1,'Retail Sale Id 1305',1199.68,0.00,0.00,1.63,97.80,'2022-12-24 10:52:28','',''),(1342,'1','302','1',1,'Retail Sale Id 1306',1000.96,0.00,0.00,1.36,81.60,'2022-12-24 10:53:58','',''),(1343,'1','302','1',1,'Retail Sale Id 1307',2598.08,0.00,0.00,3.53,211.80,'2022-12-24 11:00:14','',''),(1344,'1','302','1',1,'Retail Sale Id 1308',3503.36,0.00,0.00,4.76,285.60,'2022-12-24 11:10:31','',''),(1345,'1','302','1',1,'Retail Sale Id 1309',4416.00,0.00,0.00,6.00,360.00,'2022-12-24 11:11:28','',''),(1346,'1','302','1',1,'Retail Sale Id 1310',9200.00,0.00,0.00,12.50,750.00,'2022-12-24 11:15:31','',''),(1347,'1','302','1',1,'Retail Sale Id 1311',2944.00,0.00,0.00,4.00,240.00,'2022-12-24 11:40:01','',''),(1348,'1','302','1',1,'Retail Sale Id 1312',2208.00,0.00,0.00,3.00,180.00,'2022-12-24 11:41:40','',''),(1349,'1','302','1',1,'Retail Sale Id 1312',9200.00,0.00,0.00,12.50,750.00,'2022-12-24 11:41:40','',''),(1350,'1','302','1',1,'Retail Sale Id 1313',4202.56,0.00,0.00,5.71,342.60,'2022-12-24 11:42:30','',''),(1351,'1','302','1',1,'Retail Sale Id 1314',7360.00,0.00,0.00,10.00,600.00,'2022-12-24 11:45:13','',''),(1352,'1','302','1',1,'Retail Sale Id 1315',1000.96,0.00,0.00,1.36,81.60,'2022-12-24 11:47:19','',''),(1353,'1','302','1',1,'Retail Sale Id 1316',3680.00,0.00,0.00,5.00,300.00,'2022-12-24 11:52:42','',''),(1354,'1','302','1',1,'Retail Sale Id 1316',4416.00,0.00,0.00,6.00,360.00,'2022-12-24 11:52:42','',''),(1355,'1','302','1',1,'Retail Sale Id 1316',4416.00,0.00,0.00,6.00,360.00,'2022-12-24 11:52:42','',''),(1356,'1','302','1',1,'Retail Sale Id 1317',1000.96,0.00,0.00,1.36,81.60,'2022-12-24 12:08:54','',''),(1357,'1','302','1',1,'Retail Sale Id 1317',1501.44,0.00,0.00,2.04,122.40,'2022-12-24 12:08:54','',''),(1358,'1','302','1',1,'Retail Sale Id 1318',2208.00,0.00,0.00,3.00,180.00,'2022-12-24 12:19:50','',''),(1359,'1','302','1',1,'Retail Sale Id 1319',9200.00,0.00,0.00,12.50,750.00,'2022-12-24 12:21:01','',''),(1360,'1','302','1',1,'Retail Sale Id 1320',6624.00,0.00,0.00,9.00,540.00,'2022-12-24 12:24:40','',''),(1361,'1','302','1',1,'Retail Sale Id 1321',4416.00,0.00,0.00,6.00,360.00,'2022-12-24 12:30:03','',''),(1362,'1','302','1',1,'Retail Sale Id 1322',11040.00,0.00,0.00,15.00,900.00,'2022-12-24 12:33:24','',''),(1363,'1','302','1',1,'Retail Sale Id 1323',802.24,0.00,0.00,1.09,65.40,'2022-12-24 12:55:39','',''),(1364,'1','302','1',1,'Retail Sale Id 1324',7360.00,0.00,0.00,10.00,600.00,'2022-12-24 13:01:05','',''),(1365,'1','302','1',1,'Retail Sale Id 1325',5152.00,0.00,0.00,7.00,420.00,'2022-12-24 13:11:43','',''),(1366,'1','302','1',1,'Retail Sale Id 1327',2303.68,0.00,0.00,3.13,187.80,'2022-12-24 13:50:27','',''),(1367,'1','302','1',1,'Retail Sale Id 1328',18400.00,0.00,0.00,25.00,1500.00,'2022-12-24 13:58:52','',''),(1368,'1','302','1',1,'Retail Sale Id 1329',4416.00,0.00,0.00,6.00,360.00,'2022-12-24 14:01:13','',''),(1369,'1','302','1',1,'Retail Sale Id 1330',3680.00,0.00,0.00,5.00,300.00,'2022-12-24 14:03:00','',''),(1370,'1','302','1',1,'Retail Sale Id 1331',3002.88,0.00,0.00,4.08,244.80,'2022-12-24 14:17:44','',''),(1371,'1','302','1',1,'Retail Sale Id 1332',2208.00,0.00,0.00,3.00,180.00,'2022-12-24 14:33:09','',''),(1372,'1','302','1',1,'Retail Sale Id 1333',4416.00,0.00,0.00,6.00,360.00,'2022-12-24 14:43:44','',''),(1373,'1','302','1',1,'Retail Sale Id 1334',4416.00,0.00,0.00,6.00,360.00,'2022-12-24 14:44:31','',''),(1374,'1','302','1',1,'Retail Sale Id 1335',1501.44,0.00,0.00,2.04,122.40,'2022-12-24 14:51:40','',''),(1375,'1','302','1',1,'Retail Sale Id 1336',2208.00,0.00,0.00,3.00,180.00,'2022-12-24 14:55:40','',''),(1376,'1','302','1',1,'Retail Sale Id 1337',3680.00,0.00,0.00,5.00,300.00,'2022-12-24 15:03:34','',''),(1377,'1','302','1',1,'Retail Sale Id 1338',3996.48,0.00,0.00,5.43,325.80,'2022-12-24 15:27:34','',''),(1378,'1','302','1',1,'Retail Sale Id 1339',3680.00,0.00,0.00,5.00,300.00,'2022-12-24 15:33:07','',''),(1379,'1','302','1',1,'Retail Sale Id 1340',4416.00,0.00,0.00,6.00,360.00,'2022-12-24 15:51:53','',''),(1380,'1','302','1',1,'Retail Sale Id 1340',9200.00,0.00,0.00,12.50,750.00,'2022-12-24 15:51:53','',''),(1381,'1','302','1',1,'Retail Sale Id 1341',3503.36,0.00,0.00,4.76,285.60,'2022-12-24 16:00:31','',''),(1382,'1','302','1',1,'Retail Sale Id 1342',3002.88,0.00,0.00,4.08,244.80,'2022-12-24 16:11:35','',''),(1383,'1','302','1',1,'Retail Sale Id 1343',4416.00,0.00,0.00,6.00,360.00,'2022-12-24 16:42:04','',''),(1384,'1','302','1',1,'Retail Sale Id 1344',4416.00,0.00,0.00,6.00,360.00,'2022-12-24 16:51:54','',''),(1385,'1','302','1',1,'Retail Sale Id 1345',9200.00,0.00,0.00,12.50,750.00,'2022-12-24 17:08:38','',''),(1386,'1','302','1',1,'Retail Sale Id 1346',4496.96,0.00,0.00,6.11,366.60,'2022-12-24 17:09:49','',''),(1387,'1','302','1',1,'Retail Sale Id 1347',4416.00,0.00,0.00,6.00,360.00,'2022-12-24 17:11:20','',''),(1388,'1','302','1',1,'Retail Sale Id 1348',4416.00,0.00,0.00,6.00,360.00,'2022-12-24 17:13:10','',''),(1389,'1','302','1',1,'Retail Sale Id 1349',736.00,0.00,0.00,1.00,60.00,'2022-12-24 17:25:52','',''),(1390,'1','302','1',1,'Retail Sale Id 1349',1840.00,0.00,0.00,2.50,150.00,'2022-12-24 17:25:52','',''),(1391,'1','302','1',1,'Retail Sale Id 1350',3680.00,0.00,0.00,5.00,300.00,'2022-12-24 17:27:12','',''),(1392,'1','302','1',1,'Retail Sale Id 1351',4416.00,0.00,0.00,6.00,360.00,'2022-12-24 17:46:55','',''),(1393,'1','302','1',1,'Retail Sale Id 1351',4416.00,0.00,0.00,6.00,360.00,'2022-12-24 17:46:55','',''),(1394,'1','302','1',1,'Retail Sale Id 1352',9001.28,0.00,0.00,12.23,733.80,'2022-12-24 17:54:38','',''),(1395,'1','302','1',1,'Retail Sale Id 1353',4416.00,0.00,0.00,6.00,360.00,'2022-12-24 17:57:19','',''),(1396,'1','302','1',1,'Retail Sale Id 1353',9200.00,0.00,0.00,12.50,750.00,'2022-12-24 17:57:19','',''),(1397,'1','302','1',1,'Retail Sale Id 1354',4496.96,0.00,0.00,6.11,366.60,'2022-12-24 18:00:25','',''),(1398,'1','302','1',1,'Retail Sale Id 1355',1501.44,0.00,0.00,2.04,122.40,'2022-12-24 18:10:48','',''),(1399,'1','302','1',1,'Retail Sale Id 1356',1472.00,0.00,0.00,2.00,120.00,'2022-12-24 18:15:11','',''),(1400,'1','302','1',1,'Retail Sale Id 1357',2200.64,0.00,0.00,2.99,179.40,'2022-12-24 18:16:25','',''),(1401,'1','302','1',1,'Return of Retail Sale Id 1355',0.00,1501.44,2.04,0.00,-122.40,'2022-12-24 18:59:58','',''),(1402,'1','302','1',1,'Retail Sale Id 1359',647.68,0.00,0.00,0.88,52.80,'2022-12-24 19:02:58','',''),(1403,'1','302','1',1,'Retail Sale Id 1360',2208.00,0.00,0.00,3.00,180.00,'2022-12-25 08:13:37','',''),(1404,'1','302','1',1,'Retail Sale Id 1361',1398.40,0.00,0.00,1.90,114.00,'2022-12-25 08:15:01','',''),(1405,'1','302','1',1,'Retail Sale Id 1362',4997.44,0.00,0.00,6.79,407.40,'2022-12-25 08:15:58','',''),(1406,'1','302','1',1,'Retail Sale Id 1363',2001.92,0.00,0.00,2.72,163.20,'2022-12-25 08:18:30','',''),(1407,'1','302','1',1,'Retail Sale Id 1364',2001.92,0.00,0.00,2.72,163.20,'2022-12-25 08:38:45','',''),(1408,'1','302','1',1,'Retail Sale Id 1365',1472.00,0.00,0.00,2.00,120.00,'2022-12-25 08:40:13','',''),(1409,'1','302','1',1,'Retail Sale Id 1366',9200.00,0.00,0.00,12.50,750.00,'2022-12-25 08:46:30','',''),(1410,'1','302','1',1,'Retail Sale Id 1367',3002.88,0.00,0.00,4.08,244.80,'2022-12-25 08:50:15','',''),(1411,'1','302','1',1,'Retail Sale Id 1368',9200.00,0.00,0.00,12.50,750.00,'2022-12-25 09:00:56','',''),(1412,'1','302','1',1,'Retail Sale Id 1369',3702.08,0.00,0.00,5.03,301.80,'2022-12-25 09:09:01','',''),(1413,'1','302','1',1,'Retail Sale Id 1370',1501.44,0.00,0.00,2.04,122.40,'2022-12-25 09:17:59','',''),(1414,'1','302','1',1,'Retail Sale Id 1371',4496.96,0.00,0.00,6.11,366.60,'2022-12-25 09:26:59','',''),(1415,'1','302','1',1,'Retail Sale Id 1372',3002.88,0.00,0.00,4.08,244.80,'2022-12-25 09:29:51','',''),(1416,'1','302','1',1,'Retail Sale Id 1373',9200.00,0.00,0.00,12.50,750.00,'2022-12-25 09:45:32','',''),(1417,'1','302','1',1,'Retail Sale Id 1374',9200.00,0.00,0.00,12.50,750.00,'2022-12-25 10:00:39','',''),(1418,'1','302','1',1,'Retail Sale Id 1375',2001.92,0.00,0.00,2.72,163.20,'2022-12-25 10:07:56','',''),(1419,'1','302','1',1,'Retail Sale Id 1376',19136.00,0.00,0.00,26.00,1560.00,'2022-12-25 10:14:30','',''),(1420,'1','302','1',1,'Retail Sale Id 1377',142000.00,0.00,0.00,200.00,6800.00,'2022-12-25 10:40:43','',''),(1421,'1','302','1',1,'Retail Sale Id 1378',2252.16,0.00,0.00,3.06,183.60,'2022-12-25 10:42:39','',''),(1422,'1','302','1',1,'Retail Sale Id 1379',4423.36,0.00,0.00,6.01,360.60,'2022-12-25 10:45:43','',''),(1423,'1','302','1',1,'Retail Sale Id 1380',8802.56,0.00,0.00,11.96,717.60,'2022-12-25 10:55:53','',''),(1424,'1','302','1',1,'Retail Sale Id 1381',2001.92,0.00,0.00,2.72,163.20,'2022-12-25 10:56:47','',''),(1425,'1','302','1',1,'Retail Sale Id 1382',71000.00,0.00,0.00,100.00,3400.00,'2022-12-25 10:59:54','',''),(1426,'1','302','1',1,'Retail Sale Id 1383',71000.00,0.00,0.00,100.00,3400.00,'2022-12-25 11:06:34','',''),(1427,'1','302','1',1,'Retail Sale Id 1384',2001.92,0.00,0.00,2.72,163.20,'2022-12-25 11:26:07','',''),(1428,'1','302','1',1,'Retail Sale Id 1385',17750.00,0.00,0.00,25.00,850.00,'2022-12-25 11:28:38','',''),(1429,'1','302','1',1,'Retail Sale Id 1386',802.24,0.00,0.00,1.09,65.40,'2022-12-25 11:29:16','',''),(1430,'1','302','1',1,'Retail Sale Id 1387',4496.96,0.00,0.00,6.11,366.60,'2022-12-25 11:36:20','',''),(1431,'1','302','1',1,'Retail Sale Id 1389',8875.00,0.00,0.00,12.50,425.00,'2022-12-25 11:42:09','',''),(1432,'1','302','1',1,'Retail Sale Id 1390',4997.44,0.00,0.00,6.79,407.40,'2022-12-25 11:48:00','',''),(1433,'1','302','1',1,'Retail Sale Id 1391',9200.00,0.00,0.00,12.50,750.00,'2022-12-25 11:51:34','',''),(1434,'1','302','1',1,'Retail Sale Id 1392',3002.88,0.00,0.00,4.08,244.80,'2022-12-25 11:57:26','',''),(1435,'1','302','1',1,'Retail Sale Id 1393',4496.96,0.00,0.00,6.11,366.60,'2022-12-25 12:18:58','',''),(1436,'1','302','1',1,'Retail Sale Id 1394',4496.96,0.00,0.00,6.11,366.60,'2022-12-25 12:41:18','',''),(1437,'1','302','1',1,'Retail Sale Id 1395',8103.36,0.00,0.00,11.01,660.60,'2022-12-25 12:45:51','',''),(1438,'1','302','1',1,'Retail Sale Id 1397',71000.00,0.00,0.00,100.00,3400.00,'2022-12-25 12:48:35','',''),(1439,'1','302','1',1,'Retail Sale Id 1398',4401.28,0.00,0.00,5.98,358.80,'2022-12-25 12:50:07','',''),(1440,'1','302','1',1,'Retail Sale Id 1399',2208.00,0.00,0.00,3.00,180.00,'2022-12-25 12:51:22','',''),(1441,'1','302','1',1,'Retail Sale Id 1399',2208.00,0.00,0.00,3.00,180.00,'2022-12-25 12:51:22','',''),(1442,'1','302','1',1,'Retail Sale Id 1400',9200.00,0.00,0.00,12.50,750.00,'2022-12-25 12:56:55','',''),(1443,'1','302','1',1,'Retail Sale Id 1401',8000.32,0.00,0.00,10.87,652.20,'2022-12-25 13:18:15','',''),(1444,'1','302','1',1,'Retail Sale Id 1402',2001.92,0.00,0.00,2.72,163.20,'2022-12-25 13:21:50','',''),(1445,'1','302','1',1,'Retail Sale Id 1403',2208.00,0.00,0.00,3.00,180.00,'2022-12-25 13:56:59','',''),(1446,'1','302','1',1,'Retail Sale Id 1403',4416.00,0.00,0.00,6.00,360.00,'2022-12-25 13:56:59','',''),(1447,'1','302','1',1,'Retail Sale Id 1404',3680.00,0.00,0.00,5.00,300.00,'2022-12-25 14:06:47','',''),(1448,'1','302','1',1,'Retail Sale Id 1405',4496.96,0.00,0.00,6.11,366.60,'2022-12-25 14:18:44','',''),(1449,'1','302','1',1,'Retail Sale Id 1406',2001.92,0.00,0.00,2.72,163.20,'2022-12-25 14:19:24','',''),(1450,'1','302','1',1,'Retail Sale Id 1407',802.24,0.00,0.00,1.09,65.40,'2022-12-25 14:20:26','',''),(1451,'1','302','1',1,'Retail Sale Id 1408',4416.00,0.00,0.00,6.00,360.00,'2022-12-25 14:21:24','',''),(1452,'1','302','1',1,'Retail Sale Id 1409',1501.44,0.00,0.00,2.04,122.40,'2022-12-25 14:24:31','',''),(1453,'1','302','1',1,'Retail Sale Id 1409',1501.44,0.00,0.00,2.04,122.40,'2022-12-25 14:24:31','',''),(1454,'1','302','1',1,'Retail Sale Id 1410',3002.88,0.00,0.00,4.08,244.80,'2022-12-25 14:25:17','',''),(1455,'1','302','1',1,'Retail Sale Id 1411',2208.00,0.00,0.00,3.00,180.00,'2022-12-25 14:28:54','',''),(1456,'1','302','1',1,'Retail Sale Id 1412',3503.36,0.00,0.00,4.76,285.60,'2022-12-25 14:31:10','',''),(1457,'1','302','1',1,'Retail Sale Id 1413',9200.00,0.00,0.00,12.50,750.00,'2022-12-25 14:50:39','',''),(1458,'1','302','1',1,'Retail Sale Id 1414',3503.36,0.00,0.00,4.76,285.60,'2022-12-25 14:51:27','',''),(1459,'1','302','1',1,'Retail Sale Id 1415',2208.00,0.00,0.00,3.00,180.00,'2022-12-25 14:52:17','',''),(1460,'1','302','1',1,'Retail Sale Id 1416',10002.24,0.00,0.00,13.59,815.40,'2022-12-25 15:01:16','',''),(1461,'1','302','1',1,'Retail Sale Id 1417',3996.48,0.00,0.00,5.43,325.80,'2022-12-25 15:03:58','',''),(1462,'1','302','1',1,'Retail Sale Id 1418',2001.92,0.00,0.00,2.72,163.20,'2022-12-25 15:05:23','',''),(1463,'1','302','1',1,'Retail Sale Id 1419',2001.92,0.00,0.00,2.72,163.20,'2022-12-25 15:07:02','',''),(1464,'1','302','1',1,'Retail Sale Id 1419',3702.08,0.00,0.00,5.03,301.80,'2022-12-25 15:07:02','',''),(1465,'1','302','1',1,'Retail Sale Id 1419',9001.28,0.00,0.00,12.23,733.80,'2022-12-25 15:07:02','',''),(1466,'1','302','1',1,'Retail Sale Id 1420',4997.44,0.00,0.00,6.79,407.40,'2022-12-25 15:11:37','',''),(1467,'1','302','1',1,'Retail Sale Id 1421',9200.00,0.00,0.00,12.50,750.00,'2022-12-25 15:14:35','',''),(1468,'1','302','1',1,'Retail Sale Id 1422',3002.88,0.00,0.00,4.08,244.80,'2022-12-25 15:18:55','',''),(1469,'1','302','1',1,'Retail Sale Id 1423',2208.00,0.00,0.00,3.00,180.00,'2022-12-25 15:23:15','',''),(1470,'1','302','1',1,'Retail Sale Id 1424',3002.88,0.00,0.00,4.08,244.80,'2022-12-25 15:42:35','',''),(1471,'1','302','1',1,'Retail Sale Id 1425',2208.00,0.00,0.00,3.00,180.00,'2022-12-25 15:44:00','',''),(1472,'1','302','1',1,'Retail Sale Id 1426',181050.00,0.00,0.00,255.00,8670.00,'2022-12-25 15:45:24','',''),(1473,'1','302','1',1,'Retail Sale Id 1427',9200.00,0.00,0.00,12.50,750.00,'2022-12-25 15:46:35','',''),(1474,'1','302','1',1,'Retail Sale Id 1428',4416.00,0.00,0.00,6.00,360.00,'2022-12-25 15:51:14','',''),(1475,'1','302','1',1,'Retail Sale Id 1429',2502.40,0.00,0.00,3.40,204.00,'2022-12-25 15:56:22','',''),(1476,'1','302','1',1,'Retail Sale Id 1430',9200.00,0.00,0.00,12.50,750.00,'2022-12-25 15:56:45','',''),(1477,'1','302','1',1,'Retail Sale Id 1431',9200.00,0.00,0.00,12.50,750.00,'2022-12-25 15:58:03','',''),(1478,'1','302','1',1,'Retail Sale Id 1432',9200.00,0.00,0.00,12.50,750.00,'2022-12-25 16:00:16','',''),(1479,'1','302','1',1,'Retail Sale Id 1433',2303.68,0.00,0.00,3.13,187.80,'2022-12-25 16:01:45','',''),(1480,'1','302','1',1,'Retail Sale Id 1434',4496.96,0.00,0.00,6.11,366.60,'2022-12-25 16:02:50','',''),(1481,'1','302','1',1,'Retail Sale Id 1435',9200.00,0.00,0.00,12.50,750.00,'2022-12-25 16:04:17','',''),(1482,'1','302','1',1,'Retail Sale Id 1436',9303.04,0.00,0.00,12.64,758.40,'2022-12-25 16:05:35','',''),(1483,'1','302','1',1,'Retail Sale Id 1437',3996.48,0.00,0.00,5.43,325.80,'2022-12-25 16:08:04','',''),(1484,'1','302','1',1,'Retail Sale Id 1438',736.00,0.00,0.00,1.00,60.00,'2022-12-25 16:10:46','',''),(1485,'1','302','1',1,'Retail Sale Id 1439',35500.00,0.00,0.00,50.00,1700.00,'2022-12-25 16:14:05','',''),(1486,'1','302','1',1,'Retail Sale Id 1440',2156.48,0.00,0.00,2.93,175.80,'2022-12-25 16:18:50','',''),(1487,'1','302','1',1,'Retail Sale Id 1441',5998.40,0.00,0.00,8.15,489.00,'2022-12-25 16:19:39','',''),(1488,'1','302','1',1,'Retail Sale Id 1442',9200.00,0.00,0.00,12.50,750.00,'2022-12-25 16:25:29','',''),(1489,'1','302','1',1,'Retail Sale Id 1443',2303.68,0.00,0.00,3.13,187.80,'2022-12-25 16:31:07','',''),(1490,'1','302','1',1,'Retail Sale Id 1444',8103.36,0.00,0.00,11.01,660.60,'2022-12-25 16:35:14','',''),(1491,'1','302','1',1,'Retail Sale Id 1445',9200.00,0.00,0.00,12.50,750.00,'2022-12-25 16:36:08','',''),(1492,'1','302','1',1,'Retail Sale Id 1446',3599.04,0.00,0.00,4.89,293.40,'2022-12-25 16:44:30','',''),(1493,'1','302','1',1,'Retail Sale Id 1447',2001.92,0.00,0.00,2.72,163.20,'2022-12-25 16:45:50','',''),(1494,'1','302','1',1,'Retail Sale Id 1448',9200.00,0.00,0.00,12.50,750.00,'2022-12-25 16:47:16','',''),(1495,'1','302','1',1,'Retail Sale Id 1449',6624.00,0.00,0.00,9.00,540.00,'2022-12-25 16:50:20','',''),(1496,'1','302','1',1,'Retail Sale Id 1450',2208.00,0.00,0.00,3.00,180.00,'2022-12-25 16:51:54','',''),(1497,'1','302','1',1,'Retail Sale Id 1451',7654.40,0.00,0.00,10.40,624.00,'2022-12-25 16:54:50','',''),(1498,'1','302','1',1,'Retail Sale Id 1452',1000.96,0.00,0.00,1.36,81.60,'2022-12-25 17:09:25','',''),(1499,'1','302','1',1,'Retail Sale Id 1453',31950.00,0.00,0.00,45.00,1530.00,'2022-12-25 17:13:39','',''),(1500,'1','302','1',1,'Retail Sale Id 1454',2001.92,0.00,0.00,2.72,163.20,'2022-12-25 17:14:36','',''),(1501,'1','302','1',1,'Retail Sale Id 1455',1501.44,0.00,0.00,2.04,122.40,'2022-12-25 17:18:51','',''),(1502,'1','302','1',1,'Retail Sale Id 1456',9200.00,0.00,0.00,12.50,750.00,'2022-12-25 17:20:16','',''),(1503,'1','302','1',1,'Retail Sale Id 1457',3002.88,0.00,0.00,4.08,244.80,'2022-12-25 17:21:38','',''),(1504,'1','302','1',1,'Retail Sale Id 1458',7360.00,0.00,0.00,10.00,600.00,'2022-12-25 17:22:41','',''),(1505,'1','302','1',1,'Retail Sale Id 1459',1501.44,0.00,0.00,2.04,122.40,'2022-12-25 17:23:38','',''),(1506,'1','302','1',1,'Retail Sale Id 1460',2208.00,0.00,0.00,3.00,180.00,'2022-12-25 17:39:26','',''),(1507,'1','302','1',1,'Retail Sale Id 1461',500.48,0.00,0.00,0.68,40.80,'2022-12-25 17:50:01','',''),(1508,'1','302','1',1,'Retail Sale Id 1462',9200.00,0.00,0.00,12.50,750.00,'2022-12-25 17:54:21','',''),(1509,'1','302','1',1,'Retail Sale Id 1463',4496.96,0.00,0.00,6.11,366.60,'2022-12-25 17:56:04','',''),(1510,'1','302','1',1,'Retail Sale Id 1464',2502.40,0.00,0.00,3.40,204.00,'2022-12-25 17:58:32','',''),(1511,'1','302','1',1,'Retail Sale Id 1465',1501.44,0.00,0.00,2.04,122.40,'2022-12-25 18:00:27','',''),(1512,'1','302','1',1,'Retail Sale Id 1466',2252.16,0.00,0.00,3.06,183.60,'2022-12-25 18:08:56','',''),(1513,'1','302','1',1,'Retail Sale Id 1467',18400.00,0.00,0.00,25.00,1500.00,'2022-12-25 18:09:36','',''),(1514,'1','302','1',1,'Retail Sale Id 1469',58.88,0.00,0.00,0.08,4.80,'2022-12-25 18:52:09','',''),(1515,'1','302','1',1,'Retail Sale Id 1470',1501.44,0.00,0.00,2.04,122.40,'2022-12-26 07:11:30','',''),(1516,'1','302','1',1,'Retail Sale Id 1471',4997.44,0.00,0.00,6.79,407.40,'2022-12-26 07:54:51','',''),(1517,'1','302','1',1,'Retail Sale Id 1472',9001.28,0.00,0.00,12.23,733.80,'2022-12-26 08:15:04','',''),(1518,'1','302','1',1,'Retail Sale Id 1473',1000.96,0.00,0.00,1.36,81.60,'2022-12-26 08:21:13','',''),(1519,'1','302','1',1,'Retail Sale Id 1474',106500.00,0.00,0.00,150.00,5100.00,'2022-12-26 08:24:21','',''),(1520,'1','302','1',1,'Retail Sale Id 1475',3002.88,0.00,0.00,4.08,244.80,'2022-12-26 08:46:12','',''),(1521,'1','302','1',1,'Retail Sale Id 1476',4416.00,0.00,0.00,6.00,360.00,'2022-12-26 08:48:59','',''),(1522,'1','302','1',1,'Retail Sale Id 1477',9200.00,0.00,0.00,12.50,750.00,'2022-12-26 08:54:15','',''),(1523,'1','302','1',1,'Retail Sale Id 1478',4452.80,0.00,0.00,6.05,363.00,'2022-12-26 08:56:15','',''),(1524,'1','302','1',1,'Retail Sale Id 1479',9200.00,0.00,0.00,12.50,750.00,'2022-12-26 08:57:30','',''),(1525,'1','302','1',1,'Retail Sale Id 1480',4496.96,0.00,0.00,6.11,366.60,'2022-12-26 09:17:34','',''),(1526,'1','302','1',1,'Retail Sale Id 1481',1501.44,0.00,0.00,2.04,122.40,'2022-12-26 09:22:27','',''),(1527,'1','302','1',1,'Retail Sale Id 1482',3002.88,0.00,0.00,4.08,244.80,'2022-12-26 09:24:31','',''),(1528,'1','302','1',1,'Retail Sale Id 1483',2200.64,0.00,0.00,2.99,179.40,'2022-12-26 09:25:55','',''),(1529,'1','302','1',1,'Retail Sale Id 1484',1501.44,0.00,0.00,2.04,122.40,'2022-12-26 09:28:13','',''),(1530,'1','302','1',1,'Retail Sale Id 1485',2001.92,0.00,0.00,2.72,163.20,'2022-12-26 09:42:50','',''),(1531,'1','302','1',1,'Retail Sale Id 1486',9200.00,0.00,0.00,12.50,750.00,'2022-12-26 09:49:27','',''),(1532,'1','302','1',1,'Retail Sale Id 1487',2001.92,0.00,0.00,2.72,163.20,'2022-12-26 10:04:56','',''),(1533,'1','302','1',1,'Retail Sale Id 1488',2208.00,0.00,0.00,3.00,180.00,'2022-12-26 10:08:21','',''),(1534,'1','302','1',1,'Retail Sale Id 1489',3002.88,0.00,0.00,4.08,244.80,'2022-12-26 10:11:07','',''),(1535,'1','302','1',1,'Retail Sale Id 1490',3201.60,0.00,0.00,4.35,261.00,'2022-12-26 10:13:06','',''),(1536,'1','302','1',1,'Retail Sale Id 1491',3797.76,0.00,0.00,5.16,309.60,'2022-12-26 10:18:21','',''),(1537,'1','302','1',1,'Retail Sale Id 1492',4416.00,0.00,0.00,6.00,360.00,'2022-12-26 10:27:08','',''),(1538,'1','302','1',1,'Retail Sale Id 1493',2001.92,0.00,0.00,2.72,163.20,'2022-12-26 10:28:59','',''),(1539,'1','302','1',1,'Retail Sale Id 1495',5902.72,0.00,0.00,8.02,481.20,'2022-12-26 10:36:52','',''),(1540,'1','302','1',1,'Retail Sale Id 1496',5888.00,0.00,0.00,8.00,480.00,'2022-12-26 10:40:21','',''),(1541,'1','302','1',1,'Retail Sale Id 1497',1501.44,0.00,0.00,2.04,122.40,'2022-12-26 10:42:11','',''),(1542,'1','302','1',1,'Retail Sale Id 1498',3996.48,0.00,0.00,5.43,325.80,'2022-12-26 10:54:02','',''),(1543,'1','302','1',1,'Retail Sale Id 1499',108630.00,0.00,0.00,153.00,5202.00,'2022-12-26 11:01:28','',''),(1544,'1','302','1',1,'Retail Sale Id 1500',2001.92,0.00,0.00,2.72,163.20,'2022-12-26 11:05:23','',''),(1545,'1','302','1',1,'Retail Sale Id 1501',4997.44,0.00,0.00,6.79,407.40,'2022-12-26 11:17:18','',''),(1546,'1','302','1',1,'Retail Sale Id 1502',9200.00,0.00,0.00,12.50,750.00,'2022-12-26 11:18:53','',''),(1547,'1','302','1',1,'Retail Sale Id 1503',9200.00,0.00,0.00,12.50,750.00,'2022-12-26 11:21:05','',''),(1548,'1','302','1',1,'Retail Sale Id 1505',5203.52,0.00,0.00,7.07,424.20,'2022-12-26 11:23:18','',''),(1549,'1','302','1',1,'Retail Sale Id 1506',11040.00,0.00,0.00,15.00,900.00,'2022-12-26 11:25:12','',''),(1550,'1','302','1',1,'Retail Sale Id 1507',7360.00,0.00,0.00,10.00,600.00,'2022-12-26 11:27:08','',''),(1551,'1','302','1',1,'Retail Sale Id 1508',1501.44,0.00,0.00,2.04,122.40,'2022-12-26 11:30:12','',''),(1552,'1','302','1',1,'Retail Sale Id 1509',7360.00,0.00,0.00,10.00,600.00,'2022-12-26 11:33:16','',''),(1553,'1','302','1',1,'Retail Sale Id 1510',3002.88,0.00,0.00,4.08,244.80,'2022-12-26 11:34:14','',''),(1554,'1','302','1',1,'Retail Sale Id 1511',71000.00,0.00,0.00,100.00,3400.00,'2022-12-26 11:36:05','',''),(1555,'1','302','1',1,'Retail Sale Id 1512',3996.48,0.00,0.00,5.43,325.80,'2022-12-26 11:37:03','',''),(1556,'1','302','1',1,'Retail Sale Id 1513',4416.00,0.00,0.00,6.00,360.00,'2022-12-26 11:40:47','',''),(1557,'1','302','1',1,'Retail Sale Id 1514',1840.00,0.00,0.00,2.50,150.00,'2022-12-26 11:42:12','',''),(1558,'1','302','1',1,'Retail Sale Id 1515',4416.00,0.00,0.00,6.00,360.00,'2022-12-26 11:46:09','',''),(1559,'1','302','1',1,'Retail Sale Id 1515',9200.00,0.00,0.00,12.50,750.00,'2022-12-26 11:46:09','',''),(1560,'1','302','1',1,'Retail Sale Id 1516',4496.96,0.00,0.00,6.11,366.60,'2022-12-26 11:55:51','',''),(1561,'1','302','1',1,'Retail Sale Id 1517',2200.64,0.00,0.00,2.99,179.40,'2022-12-26 11:57:15','',''),(1562,'1','302','1',1,'Retail Sale Id 1518',4496.96,0.00,0.00,6.11,366.60,'2022-12-26 12:01:05','',''),(1563,'1','302','1',1,'Retail Sale Id 1519',9200.00,0.00,0.00,12.50,750.00,'2022-12-26 12:06:56','',''),(1564,'1','302','1',1,'Retail Sale Id 1520',2001.92,0.00,0.00,2.72,163.20,'2022-12-26 12:11:31','',''),(1565,'1','302','1',1,'Retail Sale Id 1521',2885.12,0.00,0.00,3.92,235.20,'2022-12-26 12:21:18','',''),(1566,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,201407.44,297.94,0.00,0.00,'2022-12-26 15:58:55','',''),(1567,'1','302',NULL,1,'Reception corrector for bridging 9',0.00,0.00,0.00,297.94,0.00,'2022-12-26 16:09:04','',''),(1568,'1','302','1',1,'Received from bridging 9',0.00,0.00,297.94,0.00,0.00,'2022-12-26 16:09:04','',''),(1569,'1','302','1',1,'Retail Sale Id 1524',128112.40,0.00,0.00,180.44,6134.96,'2022-12-26 16:09:43','',''),(1570,'1','302','1',1,'Retail Sale Id 1525',86480.00,0.00,0.00,117.50,7050.00,'2022-12-26 16:10:36','',''),(1571,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,676.00,1.00,0.00,0.00,'2022-12-26 16:37:20','',''),(1572,'1','302',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,1.00,0.00,'2022-12-26 16:40:02','',''),(1573,'1','302','1',1,'Received from bridging 10',0.00,0.00,1.00,0.00,0.00,'2022-12-26 16:40:02','',''),(1574,'1','302','1',1,'Retail Sale Id 1526',139.84,0.00,0.00,0.19,11.40,'2022-12-26 16:42:09','',''),(1575,'1','302','1',1,'Retail Sale Id 1527',0.00,0.00,0.00,0.00,0.00,'2022-12-26 16:47:30','',''),(1576,'1','302','1',1,'Return of Retail Sale Id 1521',0.00,2885.12,3.92,0.00,-235.20,'2022-12-26 16:55:11','',''),(1577,'1','302','1',1,'Retail Sale Id 1528',2877.76,0.00,0.00,3.91,234.60,'2022-12-26 16:58:11','',''),(1578,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3515200.00,5200.00,0.00,0.00,'2022-12-26 17:05:29','',''),(1579,'1','302',NULL,1,'Reception corrector for bridging 11',0.00,0.00,0.00,5200.00,0.00,'2022-12-26 17:09:22','',''),(1580,'1','302','1',1,'Received from bridging 11',0.00,0.00,5200.00,0.00,0.00,'2022-12-26 17:09:22','',''),(1581,'1','302','1',1,'Retail Sale Id 1529',93207.04,0.00,0.00,126.64,7598.40,'2022-12-26 18:30:02','',''),(1582,'1','302','1',1,'Retail Sale Id 1530',1501.44,0.00,0.00,2.04,122.40,'2022-12-27 07:51:02','',''),(1583,'1','302','1',1,'Retail Sale Id 1531',4496.96,0.00,0.00,6.11,366.60,'2022-12-27 07:52:12','',''),(1584,'1','302','1',1,'Retail Sale Id 1532',9200.00,0.00,0.00,12.50,750.00,'2022-12-27 07:58:13','',''),(1585,'1','302','1',1,'Retail Sale Id 1533',106500.00,0.00,0.00,150.00,5100.00,'2022-12-27 08:15:02','',''),(1586,'1','302','1',1,'Retail Sale Id 1534',3503.36,0.00,0.00,4.76,285.60,'2022-12-27 08:46:16','',''),(1587,'1','302','1',1,'Retail Sale Id 1535',2208.00,0.00,0.00,3.00,180.00,'2022-12-27 08:51:38','',''),(1588,'1','302','1',1,'Retail Sale Id 1536',2001.92,0.00,0.00,2.72,163.20,'2022-12-27 08:52:58','',''),(1589,'1','302','1',1,'Retail Sale Id 1537',4496.96,0.00,0.00,6.11,366.60,'2022-12-27 08:57:49','',''),(1590,'1','302','1',1,'Retail Sale Id 1538',9200.00,0.00,0.00,12.50,750.00,'2022-12-27 09:08:27','',''),(1591,'1','302','1',1,'Retail Sale Id 1539',3797.76,0.00,0.00,5.16,309.60,'2022-12-27 09:13:44','',''),(1592,'1','302','1',1,'Retail Sale Id 1540',1000.96,0.00,0.00,1.36,81.60,'2022-12-27 09:57:04','',''),(1593,'1','302','1',1,'Retail Sale Id 1541',2944.00,0.00,0.00,4.00,240.00,'2022-12-27 10:07:44','',''),(1594,'1','302','1',1,'Retail Sale Id 1543',1000.96,0.00,0.00,1.36,81.60,'2022-12-27 10:08:41','',''),(1595,'1','302','1',1,'Retail Sale Id 1544',4496.96,0.00,0.00,6.11,366.60,'2022-12-27 10:10:04','',''),(1596,'1','302','1',1,'Retail Sale Id 1545',3996.48,0.00,0.00,5.43,325.80,'2022-12-27 10:12:21','',''),(1597,'1','302','1',1,'Retail Sale Id 1546',3680.00,0.00,0.00,5.00,300.00,'2022-12-27 10:19:32','',''),(1598,'1','302','1',1,'Retail Sale Id 1547',4496.96,0.00,0.00,6.11,366.60,'2022-12-27 10:25:26','',''),(1599,'1','302','1',1,'Retail Sale Id 1548',5100.48,0.00,0.00,6.93,415.80,'2022-12-27 10:33:55','',''),(1600,'1','302','1',1,'Retail Sale Id 1550',4416.00,0.00,0.00,6.00,360.00,'2022-12-27 10:35:20','',''),(1601,'1','302','1',1,'Retail Sale Id 1551',3503.36,0.00,0.00,4.76,285.60,'2022-12-27 10:40:31','',''),(1602,'1','302','1',1,'Retail Sale Id 1552',4416.00,0.00,0.00,6.00,360.00,'2022-12-27 10:43:21','',''),(1603,'1','302','1',1,'Retail Sale Id 1553',9200.00,0.00,0.00,12.50,750.00,'2022-12-27 10:45:22','',''),(1604,'1','302','1',1,'Retail Sale Id 1554',80230.00,0.00,0.00,113.00,3842.00,'2022-12-27 10:57:21','',''),(1605,'1','302','1',1,'Retail Sale Id 1555',2208.00,0.00,0.00,3.00,180.00,'2022-12-27 11:04:01','',''),(1606,'1','302','1',1,'Retail Sale Id 1556',1501.44,0.00,0.00,2.04,122.40,'2022-12-27 11:08:33','',''),(1607,'1','302','1',1,'Retail Sale Id 1557',3702.08,0.00,0.00,5.03,301.80,'2022-12-27 11:09:46','',''),(1608,'1','302','1',1,'Retail Sale Id 1558',1000.96,0.00,0.00,1.36,81.60,'2022-12-27 11:11:03','',''),(1609,'1','302','1',1,'Retail Sale Id 1559',3996.48,0.00,0.00,5.43,325.80,'2022-12-27 11:19:44','',''),(1610,'1','302','1',1,'Retail Sale Id 1560',2303.68,0.00,0.00,3.13,187.80,'2022-12-27 11:25:43','',''),(1611,'1','302','1',1,'Retail Sale Id 1561',9501.76,0.00,0.00,12.91,774.60,'2022-12-27 11:26:45','',''),(1612,'1','302','1',1,'Retail Sale Id 1562',2303.68,0.00,0.00,3.13,187.80,'2022-12-27 11:33:29','',''),(1613,'1','302','1',1,'Retail Sale Id 1563',2200.64,0.00,0.00,2.99,179.40,'2022-12-27 11:34:38','',''),(1614,'1','302','1',1,'Retail Sale Id 1564',1472.00,0.00,0.00,2.00,120.00,'2022-12-27 11:36:04','',''),(1615,'1','302','1',1,'Retail Sale Id 1565',4496.96,0.00,0.00,6.11,366.60,'2022-12-27 11:36:53','',''),(1616,'1','302','1',1,'Retail Sale Id 1566',4496.96,0.00,0.00,6.11,366.60,'2022-12-27 11:39:23','',''),(1617,'1','302','1',1,'Retail Sale Id 1567',67450.00,0.00,0.00,95.00,3230.00,'2022-12-27 11:41:22','',''),(1618,'1','302','1',1,'Retail Sale Id 1568',2303.68,0.00,0.00,3.13,187.80,'2022-12-27 11:43:24','',''),(1619,'1','302','1',1,'Retail Sale Id 1569',3002.88,0.00,0.00,4.08,244.80,'2022-12-27 11:54:00','',''),(1620,'1','302','1',1,'Retail Sale Id 1570',1501.44,0.00,0.00,2.04,122.40,'2022-12-27 11:56:25','',''),(1621,'1','302','1',1,'Retail Sale Id 1571',7360.00,0.00,0.00,10.00,600.00,'2022-12-27 12:03:37','',''),(1622,'1','302','1',1,'Retail Sale Id 1572',4401.28,0.00,0.00,5.98,358.80,'2022-12-27 12:09:17','',''),(1623,'1','302','1',1,'Retail Sale Id 1573',1501.44,0.00,0.00,2.04,122.40,'2022-12-27 12:11:39','',''),(1624,'1','302','1',1,'Retail Sale Id 1574',2208.00,0.00,0.00,3.00,180.00,'2022-12-27 12:12:36','',''),(1625,'1','302','1',1,'Retail Sale Id 1575',3599.04,0.00,0.00,4.89,293.40,'2022-12-27 12:18:10','',''),(1626,'1','302','1',1,'Retail Sale Id 1576',2001.92,0.00,0.00,2.72,163.20,'2022-12-27 12:21:38','',''),(1627,'1','302','1',1,'Retail Sale Id 1577',2230.08,0.00,0.00,3.03,181.80,'2022-12-27 12:25:35','',''),(1628,'1','302','1',1,'Retail Sale Id 1578',1501.44,0.00,0.00,2.04,122.40,'2022-12-27 12:28:23','',''),(1629,'1','302','1',1,'Retail Sale Id 1579',1000.96,0.00,0.00,1.36,81.60,'2022-12-27 12:36:14','',''),(1630,'1','302','1',1,'Retail Sale Id 1580',5998.40,0.00,0.00,8.15,489.00,'2022-12-27 12:43:11','',''),(1631,'1','302','1',1,'Retail Sale Id 1581',1501.44,0.00,0.00,2.04,122.40,'2022-12-27 12:44:08','',''),(1632,'1','302','1',1,'Retail Sale Id 1582',2502.40,0.00,0.00,3.40,204.00,'2022-12-27 12:59:28','',''),(1633,'1','302','1',1,'Retail Sale Id 1583',9200.00,0.00,0.00,12.50,750.00,'2022-12-27 13:20:57','',''),(1634,'1','302','1',1,'Retail Sale Id 1584',79875.00,0.00,0.00,112.50,3825.00,'2022-12-27 13:44:08','',''),(1635,'1','302','1',1,'Retail Sale Id 1585',7360.00,0.00,0.00,10.00,600.00,'2022-12-27 13:50:19','',''),(1636,'1','302','1',1,'Retail Sale Id 1586',3002.88,0.00,0.00,4.08,244.80,'2022-12-27 14:18:44','',''),(1637,'1','302','1',1,'Retail Sale Id 1587',71000.00,0.00,0.00,100.00,3400.00,'2022-12-27 14:24:32','',''),(1638,'1','302','1',1,'Retail Sale Id 1588',4416.00,0.00,0.00,6.00,360.00,'2022-12-27 14:31:14','',''),(1639,'1','302','1',1,'Retail Sale Id 1589',1000.96,0.00,0.00,1.36,81.60,'2022-12-27 14:32:35','',''),(1640,'1','302','1',1,'Retail Sale Id 1592',4496.96,0.00,0.00,6.11,366.60,'2022-12-27 14:36:24','',''),(1641,'1','302','1',1,'Retail Sale Id 1593',4416.00,0.00,0.00,6.00,360.00,'2022-12-27 14:43:26','',''),(1642,'1','302','1',1,'Retail Sale Id 1593',9200.00,0.00,0.00,12.50,750.00,'2022-12-27 14:43:26','',''),(1643,'1','302','1',1,'Retail Sale Id 1594',9200.00,0.00,0.00,12.50,750.00,'2022-12-27 14:56:41','',''),(1644,'1','302','1',1,'Retail Sale Id 1595',1000.96,0.00,0.00,1.36,81.60,'2022-12-27 15:04:44','',''),(1645,'1','302','1',1,'Retail Sale Id 1596',4416.00,0.00,0.00,6.00,360.00,'2022-12-27 15:51:31','',''),(1646,'1','302','1',1,'Retail Sale Id 1596',9200.00,0.00,0.00,12.50,750.00,'2022-12-27 15:51:31','',''),(1647,'1','302','1',1,'Retail Sale Id 1596',9200.00,0.00,0.00,12.50,750.00,'2022-12-27 15:51:31','',''),(1648,'1','302','1',1,'Retail Sale Id 1597',22720.00,0.00,0.00,32.00,1088.00,'2022-12-27 16:19:13','',''),(1649,'1','302','1',1,'Retail Sale Id 1598',2944.00,0.00,0.00,4.00,240.00,'2022-12-27 16:21:16','',''),(1650,'1','302','1',1,'Retail Sale Id 1599',2208.00,0.00,0.00,3.00,180.00,'2022-12-27 16:23:35','',''),(1651,'1','302','1',1,'Retail Sale Id 1600',3002.88,0.00,0.00,4.08,244.80,'2022-12-27 16:32:48','',''),(1652,'1','302','1',1,'Retail Sale Id 1601',3002.88,0.00,0.00,4.08,244.80,'2022-12-27 16:33:33','',''),(1653,'1','302','1',1,'Retail Sale Id 1602',2303.68,0.00,0.00,3.13,187.80,'2022-12-27 16:35:31','',''),(1654,'1','302','1',1,'Retail Sale Id 1603',3002.88,0.00,0.00,4.08,244.80,'2022-12-27 16:36:48','',''),(1655,'1','302','1',1,'Retail Sale Id 1604',4496.96,0.00,0.00,6.11,366.60,'2022-12-27 16:41:24','',''),(1656,'1','302','1',1,'Retail Sale Id 1605',2001.92,0.00,0.00,2.72,163.20,'2022-12-27 16:42:15','',''),(1657,'1','302','1',1,'Retail Sale Id 1606',1501.44,0.00,0.00,2.04,122.40,'2022-12-27 16:45:46','',''),(1658,'1','302','1',1,'Retail Sale Id 1607',3680.00,0.00,0.00,5.00,300.00,'2022-12-27 16:46:50','',''),(1659,'1','302','1',1,'Retail Sale Id 1608',7360.00,0.00,0.00,10.00,600.00,'2022-12-27 16:57:20','',''),(1660,'1','302','1',1,'Retail Sale Id 1609',1096.64,0.00,0.00,1.49,89.40,'2022-12-27 17:00:37','',''),(1661,'1','302','1',1,'Retail Sale Id 1610',802.24,0.00,0.00,1.09,65.40,'2022-12-27 17:04:48','',''),(1662,'1','302','1',1,'Retail Sale Id 1610',1000.96,0.00,0.00,1.36,81.60,'2022-12-27 17:04:48','',''),(1663,'1','302','1',1,'Retail Sale Id 1611',3680.00,0.00,0.00,5.00,300.00,'2022-12-27 17:33:23','',''),(1664,'1','302','1',1,'Retail Sale Id 1612',2208.00,0.00,0.00,3.00,180.00,'2022-12-27 17:38:34','',''),(1665,'1','302','1',1,'Retail Sale Id 1613',3201.60,0.00,0.00,4.35,261.00,'2022-12-27 17:40:07','',''),(1666,'1','302','1',1,'Retail Sale Id 1614',29.44,0.00,0.00,0.04,2.40,'2022-12-27 18:35:56','',''),(1667,'1','302','1',1,'Retail Sale Id 1615',1000.96,0.00,0.00,1.36,81.60,'2022-12-28 07:49:33','',''),(1668,'1','302','1',1,'Retail Sale Id 1616',1000.96,0.00,0.00,1.36,81.60,'2022-12-28 07:58:36','',''),(1669,'1','302','1',1,'Retail Sale Id 1617',9200.00,0.00,0.00,12.50,750.00,'2022-12-28 08:00:46','',''),(1670,'1','302','1',1,'Return of Retail Sale Id 1615',0.00,1000.96,1.36,0.00,-81.60,'2022-12-28 08:06:01','',''),(1671,'1','302','1',1,'Retail Sale Id 1618',4423.36,0.00,0.00,6.01,360.60,'2022-12-28 08:12:26','',''),(1672,'1','302','1',1,'Retail Sale Id 1619',2001.92,0.00,0.00,2.72,163.20,'2022-12-28 08:28:50','',''),(1673,'1','302','1',1,'Retail Sale Id 1620',3002.88,0.00,0.00,4.08,244.80,'2022-12-28 09:12:51','',''),(1674,'1','302','1',1,'Retail Sale Id 1621',4401.28,0.00,0.00,5.98,358.80,'2022-12-28 09:15:03','',''),(1675,'1','302','1',1,'Retail Sale Id 1622',4416.00,0.00,0.00,6.00,360.00,'2022-12-28 09:20:53','',''),(1676,'1','302','1',1,'Retail Sale Id 1623',1501.44,0.00,0.00,2.04,122.40,'2022-12-28 09:28:40','',''),(1677,'1','302','1',1,'Retail Sale Id 1624',9200.00,0.00,0.00,12.50,750.00,'2022-12-28 09:30:03','',''),(1678,'1','302','1',1,'Retail Sale Id 1625',4496.96,0.00,0.00,6.11,366.60,'2022-12-28 09:33:39','',''),(1679,'1','302','1',1,'Retail Sale Id 1626',71000.00,0.00,0.00,100.00,3400.00,'2022-12-28 09:51:44','',''),(1680,'1','302','1',1,'Retail Sale Id 1627',5851.20,0.00,0.00,7.95,477.00,'2022-12-28 10:34:29','',''),(1681,'1','302','1',1,'Retail Sale Id 1628',9200.00,0.00,0.00,12.50,750.00,'2022-12-28 10:35:55','',''),(1682,'1','302','1',1,'Retail Sale Id 1629',4416.00,0.00,0.00,6.00,360.00,'2022-12-28 10:39:31','',''),(1683,'1','302','1',1,'Retail Sale Id 1630',3002.88,0.00,0.00,4.08,244.80,'2022-12-28 10:57:31','',''),(1684,'1','302','1',1,'Retail Sale Id 1631',5152.00,0.00,0.00,7.00,420.00,'2022-12-28 11:00:37','',''),(1685,'1','302','1',1,'Retail Sale Id 1632',1501.44,0.00,0.00,2.04,122.40,'2022-12-28 11:09:54','',''),(1686,'1','302','1',1,'Retail Sale Id 1633',8096.00,0.00,0.00,11.00,660.00,'2022-12-28 11:26:17','',''),(1687,'1','302','1',1,'Retail Sale Id 1633',36800.00,0.00,0.00,50.00,3000.00,'2022-12-28 11:26:17','',''),(1688,'1','302','1',1,'Retail Sale Id 1635',7499.84,0.00,0.00,10.19,611.40,'2022-12-28 11:30:29','',''),(1689,'1','302','1',1,'Retail Sale Id 1636',2208.00,0.00,0.00,3.00,180.00,'2022-12-28 11:35:03','',''),(1690,'1','302','1',1,'Retail Sale Id 1637',1501.44,0.00,0.00,2.04,122.40,'2022-12-28 11:37:30','',''),(1691,'1','302','1',1,'Retail Sale Id 1638',1096.64,0.00,0.00,1.49,89.40,'2022-12-28 11:53:16','',''),(1692,'1','302','1',1,'Retail Sale Id 1639',2944.00,0.00,0.00,4.00,240.00,'2022-12-28 12:02:37','',''),(1693,'1','302','1',1,'Retail Sale Id 1641',802.24,0.00,0.00,1.09,65.40,'2022-12-28 12:04:31','',''),(1694,'1','302','1',1,'Retail Sale Id 1641',2200.64,0.00,0.00,2.99,179.40,'2022-12-28 12:04:31','',''),(1695,'1','302','1',1,'Retail Sale Id 1642',9200.00,0.00,0.00,12.50,750.00,'2022-12-28 12:12:53','',''),(1696,'1','302','1',1,'Retail Sale Id 1643',3702.08,0.00,0.00,5.03,301.80,'2022-12-28 12:53:38','',''),(1697,'1','302','1',1,'Retail Sale Id 1644',4496.96,0.00,0.00,6.11,366.60,'2022-12-28 12:58:15','',''),(1698,'1','302','1',1,'Retail Sale Id 1645',2001.92,0.00,0.00,2.72,163.20,'2022-12-28 12:59:29','',''),(1699,'1','302','1',1,'Retail Sale Id 1646',2001.92,0.00,0.00,2.72,163.20,'2022-12-28 13:00:17','',''),(1700,'1','302','1',1,'Retail Sale Id 1647',3002.88,0.00,0.00,4.08,244.80,'2022-12-28 13:01:33','',''),(1701,'1','302','1',1,'Retail Sale Id 1648',42600.00,0.00,0.00,60.00,2040.00,'2022-12-28 13:03:39','',''),(1702,'1','302','1',1,'Retail Sale Id 1649',2208.00,0.00,0.00,3.00,180.00,'2022-12-28 13:24:26','',''),(1703,'1','302','1',1,'Retail Sale Id 1650',3680.00,0.00,0.00,5.00,300.00,'2022-12-28 13:44:22','',''),(1704,'1','302','1',1,'Retail Sale Id 1651',3680.00,0.00,0.00,5.00,300.00,'2022-12-28 13:46:00','',''),(1705,'1','302','1',1,'Retail Sale Id 1652',7360.00,0.00,0.00,10.00,600.00,'2022-12-28 13:56:01','',''),(1706,'1','302','1',1,'Retail Sale Id 1653',9200.00,0.00,0.00,12.50,750.00,'2022-12-28 13:56:51','',''),(1707,'1','302','1',1,'Retail Sale Id 1654',7360.00,0.00,0.00,10.00,600.00,'2022-12-28 14:20:28','',''),(1708,'1','302','1',1,'Retail Sale Id 1655',1472.00,0.00,0.00,2.00,120.00,'2022-12-28 14:21:53','',''),(1709,'1','302','1',1,'Retail Sale Id 1656',9200.00,0.00,0.00,12.50,750.00,'2022-12-28 14:41:50','',''),(1710,'1','302','1',1,'Retail Sale Id 1657',4496.96,0.00,0.00,6.11,366.60,'2022-12-28 14:49:46','',''),(1711,'1','302','1',1,'Retail Sale Id 1658',3680.00,0.00,0.00,5.00,300.00,'2022-12-28 15:42:51','',''),(1712,'1','302','1',1,'Retail Sale Id 1659',26497.20,0.00,0.00,37.32,1268.88,'2022-12-28 15:57:00','',''),(1713,'1','302','1',1,'Retail Sale Id 1660',4416.00,0.00,0.00,6.00,360.00,'2022-12-28 16:23:23','',''),(1714,'1','302','1',1,'Retail Sale Id 1661',3680.00,0.00,0.00,5.00,300.00,'2022-12-28 16:29:22','',''),(1715,'1','302','1',1,'Retail Sale Id 1662',699.20,0.00,0.00,0.95,57.00,'2022-12-28 16:35:09','',''),(1716,'1','302','1',1,'Retail Sale Id 1663',4452.80,0.00,0.00,6.05,363.00,'2022-12-28 16:41:22','',''),(1717,'1','302','1',1,'Retail Sale Id 1664',2208.00,0.00,0.00,3.00,180.00,'2022-12-28 16:42:56','',''),(1718,'1','302','1',1,'Retail Sale Id 1664',4416.00,0.00,0.00,6.00,360.00,'2022-12-28 16:42:56','',''),(1719,'1','302','1',1,'Retail Sale Id 1665',2001.92,0.00,0.00,2.72,163.20,'2022-12-28 17:13:58','',''),(1720,'1','302','1',1,'Retail Sale Id 1666',4496.96,0.00,0.00,6.11,366.60,'2022-12-28 17:16:35','',''),(1721,'1','302','1',1,'Retail Sale Id 1667',1000.96,0.00,0.00,1.36,81.60,'2022-12-28 17:47:42','',''),(1722,'1','302','1',1,'Retail Sale Id 1668',1501.44,0.00,0.00,2.04,122.40,'2022-12-28 17:57:41','',''),(1723,'1','302','1',1,'Retail Sale Id 1669',2001.92,0.00,0.00,2.72,163.20,'2022-12-28 18:00:04','',''),(1724,'1','302','1',1,'Retail Sale Id 1671',750.72,0.00,0.00,1.02,61.20,'2022-12-28 18:01:32','',''),(1725,'1','302','1',1,'Retail Sale Id 1671',750.72,0.00,0.00,1.02,61.20,'2022-12-28 18:01:32','',''),(1726,'1','302','1',1,'Retail Sale Id 1672',5497.92,0.00,0.00,7.47,448.20,'2022-12-28 18:03:13','',''),(1727,'1','302','1',1,'Retail Sale Id 1673',9200.00,0.00,0.00,12.50,750.00,'2022-12-28 18:04:59','',''),(1728,'1','302','1',1,'Retail Sale Id 1674',22.08,0.00,0.00,0.03,1.80,'2022-12-28 18:14:01','',''),(1729,'1','302','1',1,'Retail Sale Id 1675',3996.48,0.00,0.00,5.43,325.80,'2022-12-29 07:18:54','',''),(1730,'1','302','1',1,'Retail Sale Id 1676',9200.00,0.00,0.00,12.50,750.00,'2022-12-29 07:24:15','',''),(1731,'1','302','1',1,'Retail Sale Id 1677',9200.00,0.00,0.00,12.50,750.00,'2022-12-29 07:33:46','',''),(1732,'1','302','1',1,'Retail Sale Id 1678',3680.00,0.00,0.00,5.00,300.00,'2022-12-29 07:48:43','',''),(1733,'1','302','1',1,'Retail Sale Id 1678',4416.00,0.00,0.00,6.00,360.00,'2022-12-29 07:48:43','',''),(1734,'1','302','1',1,'Retail Sale Id 1679',1501.44,0.00,0.00,2.04,122.40,'2022-12-29 07:52:12','',''),(1735,'1','302','1',1,'Retail Sale Id 1680',4496.96,0.00,0.00,6.11,366.60,'2022-12-29 08:00:04','',''),(1736,'1','302','1',1,'Retail Sale Id 1681',9200.00,0.00,0.00,12.50,750.00,'2022-12-29 08:10:59','',''),(1737,'1','302','1',1,'Retail Sale Id 1682',7360.00,0.00,0.00,10.00,600.00,'2022-12-29 08:30:15','',''),(1738,'1','302','1',1,'Retail Sale Id 1683',2252.16,0.00,0.00,3.06,183.60,'2022-12-29 08:35:12','',''),(1739,'1','302','1',1,'Retail Sale Id 1684',4416.00,0.00,0.00,6.00,360.00,'2022-12-29 08:39:18','',''),(1740,'1','302','1',1,'Retail Sale Id 1685',3702.08,0.00,0.00,5.03,301.80,'2022-12-29 08:41:29','',''),(1741,'1','302','1',1,'Retail Sale Id 1686',2001.92,0.00,0.00,2.72,163.20,'2022-12-29 08:47:19','',''),(1742,'1','302','1',1,'Retail Sale Id 1687',4496.96,0.00,0.00,6.11,366.60,'2022-12-29 08:57:04','',''),(1743,'1','302','1',1,'Retail Sale Id 1688',1803.20,0.00,0.00,2.45,147.00,'2022-12-29 09:04:20','',''),(1744,'1','302','1',1,'Retail Sale Id 1689',7360.00,0.00,0.00,10.00,600.00,'2022-12-29 09:08:25','',''),(1745,'1','302','1',1,'Retail Sale Id 1690',2208.00,0.00,0.00,3.00,180.00,'2022-12-29 09:09:53','',''),(1746,'1','302','1',1,'Retail Sale Id 1691',3996.48,0.00,0.00,5.43,325.80,'2022-12-29 09:16:31','',''),(1747,'1','302','1',1,'Retail Sale Id 1691',3996.48,0.00,0.00,5.43,325.80,'2022-12-29 09:16:31','',''),(1748,'1','302','1',1,'Retail Sale Id 1692',4452.80,0.00,0.00,6.05,363.00,'2022-12-29 09:26:42','',''),(1749,'1','302','1',1,'Retail Sale Id 1693',3996.48,0.00,0.00,5.43,325.80,'2022-12-29 09:27:42','',''),(1750,'1','302','1',1,'Retail Sale Id 1694',2303.68,0.00,0.00,3.13,187.80,'2022-12-29 09:44:45','',''),(1751,'1','302','1',1,'Retail Sale Id 1695',4401.28,0.00,0.00,5.98,358.80,'2022-12-29 09:56:42','',''),(1752,'1','302','1',1,'Retail Sale Id 1696',2208.00,0.00,0.00,3.00,180.00,'2022-12-29 10:07:03','',''),(1753,'1','302','1',1,'Retail Sale Id 1696',2208.00,0.00,0.00,3.00,180.00,'2022-12-29 10:07:03','',''),(1754,'1','302','1',1,'Retail Sale Id 1697',9200.00,0.00,0.00,12.50,750.00,'2022-12-29 10:11:30','',''),(1755,'1','302','1',1,'Retail Sale Id 1699',4430.72,0.00,0.00,6.02,361.20,'2022-12-29 10:16:39','',''),(1756,'1','302','1',1,'Retail Sale Id 1700',1472.00,0.00,0.00,2.00,120.00,'2022-12-29 10:21:04','',''),(1757,'1','302','1',1,'Retail Sale Id 1700',2208.00,0.00,0.00,3.00,180.00,'2022-12-29 10:21:04','',''),(1758,'1','302','1',1,'Retail Sale Id 1701',35500.00,0.00,0.00,50.00,1700.00,'2022-12-29 10:26:33','',''),(1759,'1','302','1',1,'Retail Sale Id 1702',29820.00,0.00,0.00,42.00,1428.00,'2022-12-29 10:32:01','',''),(1760,'1','302','1',1,'Retail Sale Id 1703',3680.00,0.00,0.00,5.00,300.00,'2022-12-29 10:33:40','',''),(1761,'1','302','1',1,'Retail Sale Id 1704',802.24,0.00,0.00,1.09,65.40,'2022-12-29 10:37:25','',''),(1762,'1','302','1',1,'Retail Sale Id 1705',9200.00,0.00,0.00,12.50,750.00,'2022-12-29 10:44:20','',''),(1763,'1','302','1',1,'Retail Sale Id 1706',3702.08,0.00,0.00,5.03,301.80,'2022-12-29 10:45:25','',''),(1764,'1','302','1',1,'Retail Sale Id 1707',4452.80,0.00,0.00,6.05,363.00,'2022-12-29 10:46:39','',''),(1765,'1','302','1',1,'Retail Sale Id 1708',4496.96,0.00,0.00,6.11,366.60,'2022-12-29 10:48:02','',''),(1766,'1','302','1',1,'Retail Sale Id 1709',2502.40,0.00,0.00,3.40,204.00,'2022-12-29 10:52:08','',''),(1767,'1','302','1',1,'Retail Sale Id 1710',9001.28,0.00,0.00,12.23,733.80,'2022-12-29 11:07:12','',''),(1768,'1','302','1',1,'Retail Sale Id 1710',9001.28,0.00,0.00,12.23,733.80,'2022-12-29 11:07:12','',''),(1769,'1','302','1',1,'Retail Sale Id 1711',2502.40,0.00,0.00,3.40,204.00,'2022-12-29 11:08:32','',''),(1770,'1','302','1',1,'Retail Sale Id 1712',2001.92,0.00,0.00,2.72,163.20,'2022-12-29 11:09:15','',''),(1771,'1','302','1',1,'Retail Sale Id 1713',3702.08,0.00,0.00,5.03,301.80,'2022-12-29 11:10:38','',''),(1772,'1','302','1',1,'Retail Sale Id 1714',2200.64,0.00,0.00,2.99,179.40,'2022-12-29 11:18:06','',''),(1773,'1','302','1',1,'Retail Sale Id 1715',9200.00,0.00,0.00,12.50,750.00,'2022-12-29 11:22:55','',''),(1774,'1','302','1',1,'Retail Sale Id 1716',4416.00,0.00,0.00,6.00,360.00,'2022-12-29 11:29:16','',''),(1775,'1','302','1',1,'Retail Sale Id 1717',51120.00,0.00,0.00,72.00,2448.00,'2022-12-29 11:31:56','',''),(1776,'1','302','1',1,'Retail Sale Id 1718',1501.44,0.00,0.00,2.04,122.40,'2022-12-29 11:36:55','',''),(1777,'1','302','1',1,'Retail Sale Id 1719',4496.96,0.00,0.00,6.11,366.60,'2022-12-29 11:38:13','',''),(1778,'1','302','1',1,'Retail Sale Id 1720',8103.36,0.00,0.00,11.01,660.60,'2022-12-29 11:38:39','',''),(1779,'1','302','1',1,'Retail Sale Id 1721',9200.00,0.00,0.00,12.50,750.00,'2022-12-29 11:45:01','',''),(1780,'1','302','1',1,'Retail Sale Id 1722',3599.04,0.00,0.00,4.89,293.40,'2022-12-29 11:47:28','',''),(1781,'1','302','1',1,'Retail Sale Id 1723',4452.80,0.00,0.00,6.05,363.00,'2022-12-29 11:48:29','',''),(1782,'1','302','1',1,'Retail Sale Id 1724',3996.48,0.00,0.00,5.43,325.80,'2022-12-29 11:51:50','',''),(1783,'1','302','1',1,'Retail Sale Id 1725',4416.00,0.00,0.00,6.00,360.00,'2022-12-29 11:54:37','',''),(1784,'1','302','1',1,'Retail Sale Id 1726',3702.08,0.00,0.00,5.03,301.80,'2022-12-29 11:56:24','',''),(1785,'1','302','1',1,'Retail Sale Id 1727',198.72,0.00,0.00,0.27,16.20,'2022-12-29 11:57:48','',''),(1786,'1','302','1',1,'Retail Sale Id 1728',9200.00,0.00,0.00,12.50,750.00,'2022-12-29 11:59:33','',''),(1787,'1','302','1',1,'Retail Sale Id 1729',2303.68,0.00,0.00,3.13,187.80,'2022-12-29 12:03:45','',''),(1788,'1','302','1',1,'Retail Sale Id 1730',2208.00,0.00,0.00,3.00,180.00,'2022-12-29 12:09:29','',''),(1789,'1','302','1',1,'Retail Sale Id 1731',3002.88,0.00,0.00,4.08,244.80,'2022-12-29 12:22:58','',''),(1790,'1','302','1',1,'Retail Sale Id 1732',4496.96,0.00,0.00,6.11,366.60,'2022-12-29 12:25:32','',''),(1791,'1','302','1',1,'Retail Sale Id 1733',1000.96,0.00,0.00,1.36,81.60,'2022-12-29 12:55:42','',''),(1792,'1','302','1',1,'Retail Sale Id 1734',4496.96,0.00,0.00,6.11,366.60,'2022-12-29 13:05:53','',''),(1793,'1','302','1',1,'Retail Sale Id 1735',4416.00,0.00,0.00,6.00,360.00,'2022-12-29 13:20:06','',''),(1794,'1','302','1',1,'Retail Sale Id 1736',2200.64,0.00,0.00,2.99,179.40,'2022-12-29 13:21:17','',''),(1795,'1','302','1',1,'Retail Sale Id 1737',36800.00,0.00,0.00,50.00,3000.00,'2022-12-29 13:22:06','',''),(1796,'1','302','1',1,'Retail Sale Id 1738',5998.40,0.00,0.00,8.15,489.00,'2022-12-29 13:48:14','',''),(1797,'1','302','1',1,'Retail Sale Id 1738',5998.40,0.00,0.00,8.15,489.00,'2022-12-29 13:48:14','',''),(1798,'1','302','1',1,'Retail Sale Id 1739',2200.64,0.00,0.00,2.99,179.40,'2022-12-29 13:50:48','',''),(1799,'1','302','1',1,'Retail Sale Id 1740',9200.00,0.00,0.00,12.50,750.00,'2022-12-29 13:57:57','',''),(1800,'1','302','1',1,'Retail Sale Id 1741',3680.00,0.00,0.00,5.00,300.00,'2022-12-29 13:59:57','',''),(1801,'1','302','1',1,'Retail Sale Id 1742',2001.92,0.00,0.00,2.72,163.20,'2022-12-29 14:02:14','',''),(1802,'1','302','1',1,'Retail Sale Id 1743',1501.44,0.00,0.00,2.04,122.40,'2022-12-29 14:14:25','',''),(1803,'1','302','1',1,'Retail Sale Id 1744',9200.00,0.00,0.00,12.50,750.00,'2022-12-29 14:17:08','',''),(1804,'1','302','1',1,'Retail Sale Id 1745',3002.88,0.00,0.00,4.08,244.80,'2022-12-29 14:28:15','',''),(1805,'1','302','1',1,'Retail Sale Id 1747',4423.36,0.00,0.00,6.01,360.60,'2022-12-29 14:30:13','',''),(1806,'1','302','1',1,'Retail Sale Id 1748',4416.00,0.00,0.00,6.00,360.00,'2022-12-29 14:41:51','',''),(1807,'1','302','1',1,'Retail Sale Id 1749',3680.00,0.00,0.00,5.00,300.00,'2022-12-29 14:55:04','',''),(1808,'1','302','1',1,'Retail Sale Id 1750',2502.40,0.00,0.00,3.40,204.00,'2022-12-29 14:57:00','',''),(1809,'1','302','1',1,'Retail Sale Id 1751',2001.92,0.00,0.00,2.72,163.20,'2022-12-29 15:04:15','',''),(1810,'1','302','1',1,'Retail Sale Id 1752',2208.00,0.00,0.00,3.00,180.00,'2022-12-29 15:14:13','',''),(1811,'1','302','1',1,'Retail Sale Id 1753',2208.00,0.00,0.00,3.00,180.00,'2022-12-29 15:19:37','',''),(1812,'1','302','1',1,'Retail Sale Id 1753',7360.00,0.00,0.00,10.00,600.00,'2022-12-29 15:19:37','',''),(1813,'1','302','1',1,'Retail Sale Id 1754',2001.92,0.00,0.00,2.72,163.20,'2022-12-29 15:20:46','',''),(1814,'1','302','1',1,'Retail Sale Id 1755',2303.68,0.00,0.00,3.13,187.80,'2022-12-29 15:29:30','',''),(1815,'1','302','1',1,'Retail Sale Id 1756',17750.00,0.00,0.00,25.00,850.00,'2022-12-29 15:53:27','',''),(1816,'1','302','1',1,'Retail Sale Id 1757',1700.16,0.00,0.00,2.31,138.60,'2022-12-29 16:40:25','',''),(1817,'1','302','1',1,'Retail Sale Id 1758',4496.96,0.00,0.00,6.11,366.60,'2022-12-29 16:42:29','',''),(1818,'1','302','1',1,'Retail Sale Id 1759',1000.96,0.00,0.00,1.36,81.60,'2022-12-29 16:43:24','',''),(1819,'1','302','1',1,'Retail Sale Id 1760',1000.96,0.00,0.00,1.36,81.60,'2022-12-29 16:44:14','',''),(1820,'1','302','1',1,'Retail Sale Id 1761',1000.96,0.00,0.00,1.36,81.60,'2022-12-29 16:44:38','',''),(1821,'1','302','1',1,'Retail Sale Id 1762',802.24,0.00,0.00,1.09,65.40,'2022-12-29 16:45:44','',''),(1822,'1','302','1',1,'Retail Sale Id 1763',4430.72,0.00,0.00,6.02,361.20,'2022-12-29 16:48:03','',''),(1823,'1','302','1',1,'Retail Sale Id 1764',3002.88,0.00,0.00,4.08,244.80,'2022-12-29 16:48:45','',''),(1824,'1','302','1',1,'Retail Sale Id 1765',5998.40,0.00,0.00,8.15,489.00,'2022-12-29 17:04:32','',''),(1825,'1','302','1',1,'Retail Sale Id 1766',802.24,0.00,0.00,1.09,65.40,'2022-12-29 17:21:48','',''),(1826,'1','302','1',1,'Retail Sale Id 1767',1000.96,0.00,0.00,1.36,81.60,'2022-12-29 17:33:26','',''),(1827,'1','302','1',1,'Retail Sale Id 1768',4496.96,0.00,0.00,6.11,366.60,'2022-12-29 17:43:02','',''),(1828,'1','302','1',1,'Retail Sale Id 1769',17750.00,0.00,0.00,25.00,850.00,'2022-12-29 17:48:18','',''),(1829,'1','302','1',1,'Retail Sale Id 1770',397.44,0.00,0.00,0.54,32.40,'2022-12-29 18:19:01','',''),(1830,'1','302','1',1,'Retail Sale Id 1771',3996.48,0.00,0.00,5.43,325.80,'2022-12-30 07:46:43','',''),(1831,'1','302','1',1,'Retail Sale Id 1772',3002.88,0.00,0.00,4.08,244.80,'2022-12-30 08:06:44','',''),(1832,'1','302','1',1,'Retail Sale Id 1773',3002.88,0.00,0.00,4.08,244.80,'2022-12-30 08:22:54','',''),(1833,'1','302','1',1,'Retail Sale Id 1774',1501.44,0.00,0.00,2.04,122.40,'2022-12-30 08:26:30','',''),(1834,'1','302','1',1,'Retail Sale Id 1775',2502.40,0.00,0.00,3.40,204.00,'2022-12-30 08:28:38','',''),(1835,'1','302','1',1,'Retail Sale Id 1776',4496.96,0.00,0.00,6.11,366.60,'2022-12-30 08:36:28','',''),(1836,'1','302','1',1,'Retail Sale Id 1777',5888.00,0.00,0.00,8.00,480.00,'2022-12-30 08:43:49','',''),(1837,'1','302','1',1,'Retail Sale Id 1778',2208.00,0.00,0.00,3.00,180.00,'2022-12-30 08:49:49','',''),(1838,'1','302','1',1,'Retail Sale Id 1779',7360.00,0.00,0.00,10.00,600.00,'2022-12-30 08:53:13','',''),(1839,'1','302','1',1,'Retail Sale Id 1780',106500.00,0.00,0.00,150.00,5100.00,'2022-12-30 08:57:49','',''),(1840,'1','302','1',1,'Retail Sale Id 1781',44160.00,0.00,0.00,60.00,3600.00,'2022-12-30 09:13:38','',''),(1841,'1','302','1',1,'Retail Sale Id 1782',2001.92,0.00,0.00,2.72,163.20,'2022-12-30 09:14:35','',''),(1842,'1','302','1',1,'Retail Sale Id 1783',4997.44,0.00,0.00,6.79,407.40,'2022-12-30 09:25:23','',''),(1843,'1','302','1',1,'Retail Sale Id 1784',9200.00,0.00,0.00,12.50,750.00,'2022-12-30 09:30:04','',''),(1844,'1','302','1',1,'Retail Sale Id 1785',802.24,0.00,0.00,1.09,65.40,'2022-12-30 09:31:28','',''),(1845,'1','302','1',1,'Retail Sale Id 1786',4416.00,0.00,0.00,6.00,360.00,'2022-12-30 09:39:47','',''),(1846,'1','302','1',1,'Retail Sale Id 1787',9200.00,0.00,0.00,12.50,750.00,'2022-12-30 09:47:56','',''),(1847,'1','302','1',1,'Retail Sale Id 1788',2001.92,0.00,0.00,2.72,163.20,'2022-12-30 09:52:33','',''),(1848,'1','302','1',1,'Retail Sale Id 1789',9200.00,0.00,0.00,12.50,750.00,'2022-12-30 09:54:00','',''),(1849,'1','302','1',1,'Retail Sale Id 1790',3002.88,0.00,0.00,4.08,244.80,'2022-12-30 09:54:54','',''),(1850,'1','302','1',1,'Retail Sale Id 1791',2200.64,0.00,0.00,2.99,179.40,'2022-12-30 09:57:49','',''),(1851,'1','302','1',1,'Retail Sale Id 1792',6498.88,0.00,0.00,8.83,529.80,'2022-12-30 10:00:26','',''),(1852,'1','302','1',1,'Retail Sale Id 1793',9200.00,0.00,0.00,12.50,750.00,'2022-12-30 10:03:09','',''),(1853,'1','302','1',1,'Retail Sale Id 1794',2303.68,0.00,0.00,3.13,187.80,'2022-12-30 10:07:38','',''),(1854,'1','302','1',1,'Retail Sale Id 1795',2208.00,0.00,0.00,3.00,180.00,'2022-12-30 10:10:26','',''),(1855,'1','302','1',1,'Retail Sale Id 1796',750.72,0.00,0.00,1.02,61.20,'2022-12-30 10:11:44','',''),(1856,'1','302','1',1,'Retail Sale Id 1797',2200.64,0.00,0.00,2.99,179.40,'2022-12-30 10:12:53','',''),(1857,'1','302','1',1,'Retail Sale Id 1798',17040.00,0.00,0.00,24.00,816.00,'2022-12-30 10:19:02','',''),(1858,'1','302','1',1,'Retail Sale Id 1799',1501.44,0.00,0.00,2.04,122.40,'2022-12-30 10:20:49','',''),(1859,'1','302','1',1,'Retail Sale Id 1800',4496.96,0.00,0.00,6.11,366.60,'2022-12-30 10:25:37','',''),(1860,'1','302','1',1,'Retail Sale Id 1801',4416.00,0.00,0.00,6.00,360.00,'2022-12-30 10:32:24','',''),(1861,'1','302','1',1,'Retail Sale Id 1802',3680.00,0.00,0.00,5.00,300.00,'2022-12-30 10:35:04','',''),(1862,'1','302','1',1,'Retail Sale Id 1803',9200.00,0.00,0.00,12.50,750.00,'2022-12-30 10:37:20','',''),(1863,'1','302','1',1,'Retail Sale Id 1804',802.24,0.00,0.00,1.09,65.40,'2022-12-30 10:38:22','',''),(1864,'1','302','1',1,'Retail Sale Id 1805',2001.92,0.00,0.00,2.72,163.20,'2022-12-30 10:39:46','',''),(1865,'1','302','1',1,'Retail Sale Id 1806',2208.00,0.00,0.00,3.00,180.00,'2022-12-30 10:42:04','',''),(1866,'1','302','1',1,'Retail Sale Id 1807',9200.00,0.00,0.00,12.50,750.00,'2022-12-30 10:43:17','',''),(1867,'1','302','1',1,'Retail Sale Id 1810',2200.64,0.00,0.00,2.99,179.40,'2022-12-30 10:46:50','',''),(1868,'1','302','1',1,'Retail Sale Id 1811',2208.00,0.00,0.00,3.00,180.00,'2022-12-30 10:52:27','',''),(1869,'1','302','1',1,'Retail Sale Id 1813',2252.16,0.00,0.00,3.06,183.60,'2022-12-30 10:55:52','',''),(1870,'1','302','1',1,'Retail Sale Id 1813',2252.16,0.00,0.00,3.06,183.60,'2022-12-30 10:55:52','',''),(1871,'1','302','1',1,'Retail Sale Id 1814',4416.00,0.00,0.00,6.00,360.00,'2022-12-30 11:03:02','',''),(1872,'1','302','1',1,'Retail Sale Id 1815',2944.00,0.00,0.00,4.00,240.00,'2022-12-30 11:08:30','',''),(1873,'1','302','1',1,'Retail Sale Id 1816',4416.00,0.00,0.00,6.00,360.00,'2022-12-30 11:14:07','',''),(1874,'1','302','1',1,'Retail Sale Id 1817',51120.00,0.00,0.00,72.00,2448.00,'2022-12-30 11:19:01','',''),(1875,'1','302','1',1,'Retail Sale Id 1818',4416.00,0.00,0.00,6.00,360.00,'2022-12-30 11:20:35','',''),(1876,'1','302','1',1,'Retail Sale Id 1819',8096.00,0.00,0.00,11.00,660.00,'2022-12-30 11:22:11','',''),(1877,'1','302','1',1,'Retail Sale Id 1820',4416.00,0.00,0.00,6.00,360.00,'2022-12-30 11:26:58','',''),(1878,'1','302','1',1,'Retail Sale Id 1821',1501.44,0.00,0.00,2.04,122.40,'2022-12-30 11:28:08','',''),(1879,'1','302','1',1,'Retail Sale Id 1822',1501.44,0.00,0.00,2.04,122.40,'2022-12-30 11:41:14','',''),(1880,'1','302','1',1,'Retail Sale Id 1823',4416.00,0.00,0.00,6.00,360.00,'2022-12-30 11:44:34','',''),(1881,'1','302','1',1,'Retail Sale Id 1825',3702.08,0.00,0.00,5.03,301.80,'2022-12-30 11:48:59','',''),(1882,'1','302','1',1,'Retail Sale Id 1826',4416.00,0.00,0.00,6.00,360.00,'2022-12-30 11:49:53','',''),(1883,'1','302','1',1,'Retail Sale Id 1827',3002.88,0.00,0.00,4.08,244.80,'2022-12-30 11:55:55','',''),(1884,'1','302','1',1,'Retail Sale Id 1828',2502.40,0.00,0.00,3.40,204.00,'2022-12-30 11:58:21','',''),(1885,'1','302','1',1,'Retail Sale Id 1829',8096.00,0.00,0.00,11.00,660.00,'2022-12-30 12:01:06','',''),(1886,'1','302','1',1,'Retail Sale Id 1830',9200.00,0.00,0.00,12.50,750.00,'2022-12-30 12:02:12','',''),(1887,'1','302','1',1,'Retail Sale Id 1831',35500.00,0.00,0.00,50.00,1700.00,'2022-12-30 12:14:16','',''),(1888,'1','302','1',1,'Retail Sale Id 1832',7360.00,0.00,0.00,10.00,600.00,'2022-12-30 12:21:07','',''),(1889,'1','302','1',1,'Retail Sale Id 1833',1501.44,0.00,0.00,2.04,122.40,'2022-12-30 12:23:59','',''),(1890,'1','302','1',1,'Retail Sale Id 1834',4416.00,0.00,0.00,6.00,360.00,'2022-12-30 12:25:31','',''),(1891,'1','302','1',1,'Retail Sale Id 1835',2502.40,0.00,0.00,3.40,204.00,'2022-12-30 12:27:51','',''),(1892,'1','302','1',1,'Retail Sale Id 1836',1000.96,0.00,0.00,1.36,81.60,'2022-12-30 12:28:52','',''),(1893,'1','302','1',1,'Retail Sale Id 1837',2502.40,0.00,0.00,3.40,204.00,'2022-12-30 12:30:38','',''),(1894,'1','302','1',1,'Retail Sale Id 1838',3002.88,0.00,0.00,4.08,244.80,'2022-12-30 12:32:18','',''),(1895,'1','302','1',1,'Retail Sale Id 1839',9200.00,0.00,0.00,12.50,750.00,'2022-12-30 12:40:57','',''),(1896,'1','302','1',1,'Retail Sale Id 1841',2208.00,0.00,0.00,3.00,180.00,'2022-12-30 12:42:48','',''),(1897,'1','302','1',1,'Retail Sale Id 1842',2208.00,0.00,0.00,3.00,180.00,'2022-12-30 12:54:00','',''),(1898,'1','302','1',1,'Retail Sale Id 1843',4496.96,0.00,0.00,6.11,366.60,'2022-12-30 13:36:28','',''),(1899,'1','302','1',1,'Retail Sale Id 1843',9200.00,0.00,0.00,12.50,750.00,'2022-12-30 13:36:28','',''),(1900,'1','302','1',1,'Retail Sale Id 1844',3996.48,0.00,0.00,5.43,325.80,'2022-12-30 13:39:44','',''),(1901,'1','302','1',1,'Retail Sale Id 1845',4416.00,0.00,0.00,6.00,360.00,'2022-12-30 13:42:58','',''),(1902,'1','302','1',1,'Retail Sale Id 1846',4416.00,0.00,0.00,6.00,360.00,'2022-12-30 13:55:08','',''),(1903,'1','302','1',1,'Retail Sale Id 1847',1000.96,0.00,0.00,1.36,81.60,'2022-12-30 13:58:38','',''),(1904,'1','302','1',1,'Retail Sale Id 1848',9200.00,0.00,0.00,12.50,750.00,'2022-12-30 14:20:14','',''),(1905,'1','302','1',1,'Retail Sale Id 1849',6999.36,0.00,0.00,9.51,570.60,'2022-12-30 14:28:17','',''),(1906,'1','302','1',1,'Retail Sale Id 1850',4416.00,0.00,0.00,6.00,360.00,'2022-12-30 14:35:46','',''),(1907,'1','302','1',1,'Retail Sale Id 1851',3002.88,0.00,0.00,4.08,244.80,'2022-12-30 14:39:52','',''),(1908,'1','302','1',1,'Retail Sale Id 1852',2208.00,0.00,0.00,3.00,180.00,'2022-12-30 14:41:56','',''),(1909,'1','302','1',1,'Retail Sale Id 1853',1501.44,0.00,0.00,2.04,122.40,'2022-12-30 14:50:28','',''),(1910,'1','302','1',1,'Retail Sale Id 1854',4496.96,0.00,0.00,6.11,366.60,'2022-12-30 15:04:20','',''),(1911,'1','302','1',1,'Retail Sale Id 1855',4496.96,0.00,0.00,6.11,366.60,'2022-12-30 15:07:05','',''),(1912,'1','302','1',1,'Retail Sale Id 1856',9200.00,0.00,0.00,12.50,750.00,'2022-12-30 15:09:02','',''),(1913,'1','302','1',1,'Retail Sale Id 1857',1501.44,0.00,0.00,2.04,122.40,'2022-12-30 15:16:04','',''),(1914,'1','302','1',1,'Retail Sale Id 1858',4416.00,0.00,0.00,6.00,360.00,'2022-12-30 15:33:49','',''),(1915,'1','302','1',1,'Retail Sale Id 1859',3002.88,0.00,0.00,4.08,244.80,'2022-12-30 15:34:43','',''),(1916,'1','302','1',1,'Retail Sale Id 1860',4416.00,0.00,0.00,6.00,360.00,'2022-12-30 15:35:58','',''),(1917,'1','302','1',1,'Retail Sale Id 1861',3503.36,0.00,0.00,4.76,285.60,'2022-12-30 15:37:27','',''),(1918,'1','302','1',1,'Retail Sale Id 1862',3702.08,0.00,0.00,5.03,301.80,'2022-12-30 15:39:38','',''),(1919,'1','302','1',1,'Retail Sale Id 1863',2208.00,0.00,0.00,3.00,180.00,'2022-12-30 15:41:54','',''),(1920,'1','302','1',1,'Retail Sale Id 1864',30998.60,0.00,0.00,43.66,1484.44,'2022-12-30 15:50:28','',''),(1921,'1','302','1',1,'Retail Sale Id 1865',71000.00,0.00,0.00,100.00,3400.00,'2022-12-30 15:59:02','',''),(1922,'1','302','1',1,'Retail Sale Id 1866',3297.28,0.00,0.00,4.48,268.80,'2022-12-30 16:12:34','',''),(1923,'1','302','1',1,'Retail Sale Id 1867',2944.00,0.00,0.00,4.00,240.00,'2022-12-30 16:13:43','',''),(1924,'1','302','1',1,'Retail Sale Id 1868',4416.00,0.00,0.00,6.00,360.00,'2022-12-30 16:26:26','',''),(1925,'1','302','1',1,'Retail Sale Id 1869',9200.00,0.00,0.00,12.50,750.00,'2022-12-30 16:28:24','',''),(1926,'1','302','1',1,'Retail Sale Id 1870',2208.00,0.00,0.00,3.00,180.00,'2022-12-30 16:30:53','',''),(1927,'1','302','1',1,'Retail Sale Id 1871',3002.88,0.00,0.00,4.08,244.80,'2022-12-30 16:31:42','',''),(1928,'1','302','1',1,'Retail Sale Id 1872',1501.44,0.00,0.00,2.04,122.40,'2022-12-30 16:37:36','',''),(1929,'1','302','1',1,'Retail Sale Id 1873',7360.00,0.00,0.00,10.00,600.00,'2022-12-30 16:38:56','',''),(1930,'1','302','1',1,'Retail Sale Id 1874',2208.00,0.00,0.00,3.00,180.00,'2022-12-30 16:53:16','',''),(1931,'1','302','1',1,'Retail Sale Id 1875',71000.00,0.00,0.00,100.00,3400.00,'2022-12-30 17:05:13','',''),(1932,'1','302','1',1,'Retail Sale Id 1877',2944.00,0.00,0.00,4.00,240.00,'2022-12-30 17:06:18','',''),(1933,'1','302','1',1,'Retail Sale Id 1878',2200.64,0.00,0.00,2.99,179.40,'2022-12-30 17:08:38','',''),(1934,'1','302','1',1,'Retail Sale Id 1879',9200.00,0.00,0.00,12.50,750.00,'2022-12-30 17:13:47','',''),(1935,'1','302','1',1,'Retail Sale Id 1880',1501.44,0.00,0.00,2.04,122.40,'2022-12-30 17:15:22','',''),(1936,'1','302','1',1,'Retail Sale Id 1881',4416.00,0.00,0.00,6.00,360.00,'2022-12-30 17:19:44','',''),(1937,'1','302','1',1,'Retail Sale Id 1881',4416.00,0.00,0.00,6.00,360.00,'2022-12-30 17:19:44','',''),(1938,'1','302','1',1,'Retail Sale Id 1882',1000.96,0.00,0.00,1.36,81.60,'2022-12-30 17:20:36','',''),(1939,'1','302','1',1,'Retail Sale Id 1883',4416.00,0.00,0.00,6.00,360.00,'2022-12-30 17:31:23','',''),(1940,'1','302','1',1,'Retail Sale Id 1884',9200.00,0.00,0.00,12.50,750.00,'2022-12-30 17:32:30','',''),(1941,'1','302','1',1,'Retail Sale Id 1885',1000.96,0.00,0.00,1.36,81.60,'2022-12-30 17:39:00','',''),(1942,'1','302','1',1,'Retail Sale Id 1886',2944.00,0.00,0.00,4.00,240.00,'2022-12-30 17:41:42','',''),(1943,'1','302','1',1,'Retail Sale Id 1886',3680.00,0.00,0.00,5.00,300.00,'2022-12-30 17:41:42','',''),(1944,'1','302','1',1,'Retail Sale Id 1886',3680.00,0.00,0.00,5.00,300.00,'2022-12-30 17:41:42','',''),(1945,'1','302','1',1,'Retail Sale Id 1886',5152.00,0.00,0.00,7.00,420.00,'2022-12-30 17:41:42','',''),(1946,'1','302','1',1,'Retail Sale Id 1887',1199.68,0.00,0.00,1.63,97.80,'2022-12-30 17:44:11','',''),(1947,'1','302','1',1,'Retail Sale Id 1888',9200.00,0.00,0.00,12.50,750.00,'2022-12-30 17:46:51','',''),(1948,'1','302','1',1,'Retail Sale Id 1889',1472.00,0.00,0.00,2.00,120.00,'2022-12-30 17:50:16','',''),(1949,'1','302','1',1,'Retail Sale Id 1890',2944.00,0.00,0.00,4.00,240.00,'2022-12-30 18:01:58','',''),(1950,'1','302','1',1,'Retail Sale Id 1891',4416.00,0.00,0.00,6.00,360.00,'2022-12-30 18:09:27','',''),(1951,'1','302','1',1,'Retail Sale Id 1891',9200.00,0.00,0.00,12.50,750.00,'2022-12-30 18:09:27','',''),(1952,'1','302','1',1,'Retail Sale Id 1892',4997.44,0.00,0.00,6.79,407.40,'2022-12-30 18:32:13','',''),(1953,'1','302','1',1,'Return of Retail Sale Id 1889',0.00,1472.00,2.00,0.00,-120.00,'2022-12-30 18:43:58','',''),(1954,'1','302','1',1,'Retail Sale Id 1893',1317.44,0.00,0.00,1.79,107.40,'2022-12-30 18:45:54','',''),(1955,'1','302','1',1,'Retail Sale Id 1894',2399.36,0.00,0.00,3.26,195.60,'2022-12-31 11:23:24','',''),(1956,'1','302','1',1,'Retail Sale Id 1895',2502.40,0.00,0.00,3.40,204.00,'2022-12-31 11:24:37','',''),(1957,'1','302','1',1,'Retail Sale Id 1896',4496.96,0.00,0.00,6.11,366.60,'2022-12-31 11:25:12','',''),(1958,'1','302','1',1,'Retail Sale Id 1897',2001.92,0.00,0.00,2.72,163.20,'2022-12-31 11:27:15','',''),(1959,'1','302','1',1,'Retail Sale Id 1898',5497.92,0.00,0.00,7.47,448.20,'2022-12-31 11:27:54','',''),(1960,'1','302','1',1,'Retail Sale Id 1899',8096.00,0.00,0.00,11.00,660.00,'2022-12-31 11:29:28','',''),(1961,'1','302','1',1,'Retail Sale Id 1899',8832.00,0.00,0.00,12.00,720.00,'2022-12-31 11:29:28','',''),(1962,'1','302','1',1,'Retail Sale Id 1900',3002.88,0.00,0.00,4.08,244.80,'2022-12-31 11:31:05','',''),(1963,'1','302','1',1,'Retail Sale Id 1901',2208.00,0.00,0.00,3.00,180.00,'2022-12-31 11:31:41','',''),(1964,'1','302','1',1,'Retail Sale Id 1902',4496.96,0.00,0.00,6.11,366.60,'2022-12-31 11:32:18','',''),(1965,'1','302','1',1,'Retail Sale Id 1903',9200.00,0.00,0.00,12.50,750.00,'2022-12-31 11:33:22','',''),(1966,'1','302','1',1,'Retail Sale Id 1903',9200.00,0.00,0.00,12.50,750.00,'2022-12-31 11:33:22','',''),(1967,'1','302','1',1,'Retail Sale Id 1904',3702.08,0.00,0.00,5.03,301.80,'2022-12-31 11:33:59','',''),(1968,'1','302','1',1,'Retail Sale Id 1905',4423.36,0.00,0.00,6.01,360.60,'2022-12-31 11:35:09','',''),(1969,'1','302','1',1,'Retail Sale Id 1906',2208.00,0.00,0.00,3.00,180.00,'2022-12-31 11:35:43','',''),(1970,'1','302','1',1,'Retail Sale Id 1907',6999.36,0.00,0.00,9.51,570.60,'2022-12-31 11:40:31','',''),(1971,'1','302','1',1,'Retail Sale Id 1908',1000.96,0.00,0.00,1.36,81.60,'2022-12-31 11:48:13','',''),(1972,'1','302','1',1,'Retail Sale Id 1909',9200.00,0.00,0.00,12.50,750.00,'2022-12-31 11:51:16','',''),(1973,'1','302','1',1,'Retail Sale Id 1910',4496.96,0.00,0.00,6.11,366.60,'2022-12-31 11:52:29','',''),(1974,'1','302','1',1,'Retail Sale Id 1911',4496.96,0.00,0.00,6.11,366.60,'2022-12-31 11:55:04','',''),(1975,'1','302','1',1,'Retail Sale Id 1912',3996.48,0.00,0.00,5.43,325.80,'2022-12-31 11:56:06','',''),(1976,'1','302','1',1,'Retail Sale Id 1913',4416.00,0.00,0.00,6.00,360.00,'2022-12-31 11:57:31','',''),(1977,'1','302','1',1,'Retail Sale Id 1914',4416.00,0.00,0.00,6.00,360.00,'2022-12-31 11:59:06','',''),(1978,'1','302','1',1,'Retail Sale Id 1915',1501.44,0.00,0.00,2.04,122.40,'2022-12-31 12:00:00','',''),(1979,'1','302','1',1,'Retail Sale Id 1916',9251.52,0.00,0.00,12.57,754.20,'2022-12-31 12:01:21','',''),(1980,'1','302','1',1,'Retail Sale Id 1917',35500.00,0.00,0.00,50.00,1700.00,'2022-12-31 12:17:39','',''),(1981,'1','302','1',1,'Retail Sale Id 1918',3702.08,0.00,0.00,5.03,301.80,'2022-12-31 12:18:35','',''),(1982,'1','302','1',1,'Retail Sale Id 1919',4496.96,0.00,0.00,6.11,366.60,'2022-12-31 12:19:59','',''),(1983,'1','302','1',1,'Retail Sale Id 1920',4496.96,0.00,0.00,6.11,366.60,'2022-12-31 12:20:50','',''),(1984,'1','302','1',1,'Retail Sale Id 1921',1199.68,0.00,0.00,1.63,97.80,'2022-12-31 12:21:32','',''),(1985,'1','302','1',1,'Retail Sale Id 1922',2001.92,0.00,0.00,2.72,163.20,'2022-12-31 12:22:37','',''),(1986,'1','302','1',1,'Retail Sale Id 1923',3702.08,0.00,0.00,5.03,301.80,'2022-12-31 12:30:28','',''),(1987,'1','302','1',1,'Retail Sale Id 1924',106500.00,0.00,0.00,150.00,5100.00,'2022-12-31 12:34:36','',''),(1988,'1','302','1',1,'Retail Sale Id 1925',3208.96,0.00,0.00,4.36,261.60,'2022-12-31 12:47:01','',''),(1989,'1','302','1',1,'Retail Sale Id 1926',3680.00,0.00,0.00,5.00,300.00,'2022-12-31 12:52:27','',''),(1990,'1','302','1',1,'Retail Sale Id 1927',4496.96,0.00,0.00,6.11,366.60,'2022-12-31 13:01:04','',''),(1991,'1','302','1',1,'Retail Sale Id 1928',35500.00,0.00,0.00,50.00,1700.00,'2022-12-31 13:03:06','',''),(1992,'1','302','1',1,'Retail Sale Id 1929',9200.00,0.00,0.00,12.50,750.00,'2022-12-31 13:06:29','',''),(1993,'1','302','1',1,'Retail Sale Id 1930',1472.00,0.00,0.00,2.00,120.00,'2022-12-31 13:22:46','',''),(1994,'1','302','1',1,'Retail Sale Id 1931',2001.92,0.00,0.00,2.72,163.20,'2022-12-31 13:26:30','',''),(1995,'1','302','1',1,'Retail Sale Id 1932',11040.00,0.00,0.00,15.00,900.00,'2022-12-31 13:34:37','',''),(1996,'1','302','1',1,'Retail Sale Id 1934',1501.44,0.00,0.00,2.04,122.40,'2022-12-31 13:50:57','',''),(1997,'1','302','1',1,'Retail Sale Id 1935',2208.00,0.00,0.00,3.00,180.00,'2022-12-31 13:53:16','',''),(1998,'1','302','1',1,'Retail Sale Id 1936',3400.32,0.00,0.00,4.62,277.20,'2022-12-31 13:59:40','',''),(1999,'1','302','1',1,'Retail Sale Id 1936',3400.32,0.00,0.00,4.62,277.20,'2022-12-31 13:59:40','',''),(2000,'1','302','1',1,'Retail Sale Id 1936',3400.32,0.00,0.00,4.62,277.20,'2022-12-31 13:59:40','',''),(2001,'1','302','1',1,'Retail Sale Id 1937',9200.00,0.00,0.00,12.50,750.00,'2022-12-31 14:02:23','',''),(2002,'1','302','1',1,'Retail Sale Id 1938',35500.00,0.00,0.00,50.00,1700.00,'2022-12-31 14:04:25','',''),(2003,'1','302','1',1,'Retail Sale Id 1939',11040.00,0.00,0.00,15.00,900.00,'2022-12-31 14:08:23','',''),(2004,'1','302','1',1,'Retail Sale Id 1940',9200.00,0.00,0.00,12.50,750.00,'2022-12-31 14:09:37','',''),(2005,'1','302','1',1,'Retail Sale Id 1941',4416.00,0.00,0.00,6.00,360.00,'2022-12-31 14:10:52','',''),(2006,'1','302','1',1,'Retail Sale Id 1941',9200.00,0.00,0.00,12.50,750.00,'2022-12-31 14:10:52','',''),(2007,'1','302','1',1,'Retail Sale Id 1942',2208.00,0.00,0.00,3.00,180.00,'2022-12-31 14:13:30','',''),(2008,'1','302','1',1,'Retail Sale Id 1943',2001.92,0.00,0.00,2.72,163.20,'2022-12-31 14:15:54','',''),(2009,'1','302','1',1,'Retail Sale Id 1944',1501.44,0.00,0.00,2.04,122.40,'2022-12-31 14:19:32','',''),(2010,'1','302','1',1,'Retail Sale Id 1945',4423.36,0.00,0.00,6.01,360.60,'2022-12-31 14:25:23','',''),(2011,'1','302','1',1,'Retail Sale Id 1946',1000.96,0.00,0.00,1.36,81.60,'2022-12-31 14:31:17','',''),(2012,'1','302','1',1,'Retail Sale Id 1947',3201.60,0.00,0.00,4.35,261.00,'2022-12-31 14:32:58','',''),(2013,'1','302','1',1,'Retail Sale Id 1948',3002.88,0.00,0.00,4.08,244.80,'2022-12-31 14:39:23','',''),(2014,'1','302','1',1,'Retail Sale Id 1949',18400.00,0.00,0.00,25.00,1500.00,'2022-12-31 14:40:25','',''),(2015,'1','302','1',1,'Retail Sale Id 1950',3002.88,0.00,0.00,4.08,244.80,'2022-12-31 14:41:50','',''),(2016,'1','302','1',1,'Retail Sale Id 1951',7360.00,0.00,0.00,10.00,600.00,'2022-12-31 14:54:08','',''),(2017,'1','302','1',1,'Retail Sale Id 1952',1000.96,0.00,0.00,1.36,81.60,'2022-12-31 14:54:58','',''),(2018,'1','302','1',1,'Retail Sale Id 1953',2200.64,0.00,0.00,2.99,179.40,'2022-12-31 15:04:35','',''),(2019,'1','302','1',1,'Retail Sale Id 1954',2001.92,0.00,0.00,2.72,163.20,'2022-12-31 15:05:24','',''),(2020,'1','302','1',1,'Retail Sale Id 1955',2303.68,0.00,0.00,3.13,187.80,'2022-12-31 15:25:21','',''),(2021,'1','302','1',1,'Retail Sale Id 1956',3996.48,0.00,0.00,5.43,325.80,'2022-12-31 15:28:23','',''),(2022,'1','302','1',1,'Retail Sale Id 1957',4423.36,0.00,0.00,6.01,360.60,'2022-12-31 15:37:07','',''),(2023,'1','302','1',1,'Retail Sale Id 1958',166850.00,0.00,0.00,235.00,7990.00,'2022-12-31 15:50:34','',''),(2024,'1','302','1',1,'Retail Sale Id 1959',35500.00,0.00,0.00,50.00,1700.00,'2022-12-31 15:56:38','',''),(2025,'1','302','1',1,'Retail Sale Id 1960',3002.88,0.00,0.00,4.08,244.80,'2022-12-31 15:57:40','',''),(2026,'1','302','1',1,'Retail Sale Id 1961',35500.00,0.00,0.00,50.00,1700.00,'2022-12-31 15:58:33','',''),(2027,'1','302','1',1,'Retail Sale Id 1962',1302.72,0.00,0.00,1.77,106.20,'2022-12-31 16:01:17','',''),(2028,'1','302','1',1,'Retail Sale Id 1963',4416.00,0.00,0.00,6.00,360.00,'2022-12-31 16:03:36','',''),(2029,'1','302','1',1,'Retail Sale Id 1964',2208.00,0.00,0.00,3.00,180.00,'2022-12-31 16:28:13','',''),(2030,'1','302','1',1,'Retail Sale Id 1965',4416.00,0.00,0.00,6.00,360.00,'2022-12-31 16:29:28','',''),(2031,'1','302','1',1,'Retail Sale Id 1966',802.24,0.00,0.00,1.09,65.40,'2022-12-31 16:31:37','',''),(2032,'1','302','1',1,'Retail Sale Id 1968',9200.00,0.00,0.00,12.50,750.00,'2022-12-31 16:42:15','',''),(2033,'1','302','1',1,'Retail Sale Id 1969',2951.36,0.00,0.00,4.01,240.60,'2022-12-31 16:43:18','',''),(2034,'1','302','1',1,'Retail Sale Id 1970',2001.92,0.00,0.00,2.72,163.20,'2022-12-31 16:50:31','',''),(2035,'1','302','1',1,'Retail Sale Id 1971',3599.04,0.00,0.00,4.89,293.40,'2022-12-31 16:54:17','',''),(2036,'1','302','1',1,'Retail Sale Id 1972',1501.44,0.00,0.00,2.04,122.40,'2022-12-31 16:56:11','',''),(2037,'1','302','1',1,'Retail Sale Id 1973',1898.88,0.00,0.00,2.58,154.80,'2022-12-31 17:28:44','',''),(2038,'1','302','1',1,'Retail Sale Id 1974',25986.00,0.00,0.00,36.60,1244.40,'2022-12-31 17:43:51','',''),(2039,'1','302','1',1,'Retail Sale Id 1975',17018.70,0.00,0.00,23.97,814.98,'2022-12-31 17:46:06','',''),(2040,'1','302','1',1,'Retail Sale Id 1976',2502.40,0.00,0.00,3.40,204.00,'2022-12-31 17:48:31','',''),(2041,'1','302','1',1,'Retail Sale Id 1977',35500.00,0.00,0.00,50.00,1700.00,'2022-12-31 17:58:05','',''),(2042,'1','302','1',1,'Return of Retail Sale Id 1949',0.00,18400.00,25.00,0.00,-1500.00,'2022-12-31 18:21:02','',''),(2043,'1','302','1',1,'Return of Retail Sale Id 1965',0.00,4416.00,6.00,0.00,-360.00,'2022-12-31 18:22:55','',''),(2044,'1','302','1',1,'Retail Sale Id 1979',1288.00,0.00,0.00,1.75,105.00,'2022-12-31 18:25:43','',''),(2045,'1','302','1',1,'Retail Sale Id 1980',4496.96,0.00,0.00,6.11,366.60,'2023-01-01 07:28:11','',''),(2046,'1','302','1',1,'Retail Sale Id 1981',2001.92,0.00,0.00,2.72,163.20,'2023-01-01 07:34:10','',''),(2047,'1','302','1',1,'Retail Sale Id 1982',2944.00,0.00,0.00,4.00,240.00,'2023-01-01 07:37:07','',''),(2048,'1','302','1',1,'Retail Sale Id 1983',4496.96,0.00,0.00,6.11,366.60,'2023-01-01 08:00:01','',''),(2049,'1','302','1',1,'Retail Sale Id 1984',3680.00,0.00,0.00,5.00,300.00,'2023-01-01 08:02:46','',''),(2050,'1','302','1',1,'Retail Sale Id 1985',9200.00,0.00,0.00,12.50,750.00,'2023-01-01 08:09:02','',''),(2051,'1','302','1',1,'Retail Sale Id 1986',9200.00,0.00,0.00,12.50,750.00,'2023-01-01 08:17:40','',''),(2052,'1','302','1',1,'Retail Sale Id 1987',2303.68,0.00,0.00,3.13,187.80,'2023-01-01 08:30:16','',''),(2053,'1','302','1',1,'Retail Sale Id 1988',7360.00,0.00,0.00,10.00,600.00,'2023-01-01 09:05:13','',''),(2054,'1','302','1',1,'Retail Sale Id 1989',1000.96,0.00,0.00,1.36,81.60,'2023-01-01 09:06:05','',''),(2055,'1','302','1',1,'Retail Sale Id 1990',2001.92,0.00,0.00,2.72,163.20,'2023-01-01 09:13:58','',''),(2056,'1','302','1',1,'Retail Sale Id 1991',1700.16,0.00,0.00,2.31,138.60,'2023-01-01 09:21:08','',''),(2057,'1','302','1',1,'Retail Sale Id 1992',2303.68,0.00,0.00,3.13,187.80,'2023-01-01 09:37:26','',''),(2058,'1','302','1',1,'Retail Sale Id 1993',1472.00,0.00,0.00,2.00,120.00,'2023-01-01 09:44:38','',''),(2059,'1','302','1',1,'Retail Sale Id 1993',1472.00,0.00,0.00,2.00,120.00,'2023-01-01 09:44:38','',''),(2060,'1','302','1',1,'Retail Sale Id 1994',1000.96,0.00,0.00,1.36,81.60,'2023-01-01 09:53:04','',''),(2061,'1','302','1',1,'Retail Sale Id 1995',2200.64,0.00,0.00,2.99,179.40,'2023-01-01 09:54:20','',''),(2062,'1','302','1',1,'Retail Sale Id 1996',4416.00,0.00,0.00,6.00,360.00,'2023-01-01 09:56:38','',''),(2063,'1','302','1',1,'Retail Sale Id 1997',4416.00,0.00,0.00,6.00,360.00,'2023-01-01 09:57:50','',''),(2064,'1','302','1',1,'Retail Sale Id 1998',3503.36,0.00,0.00,4.76,285.60,'2023-01-01 09:58:44','',''),(2065,'1','302','1',1,'Retail Sale Id 1999',2208.00,0.00,0.00,3.00,180.00,'2023-01-01 10:02:50','',''),(2066,'1','302','1',1,'Retail Sale Id 2000',9200.00,0.00,0.00,12.50,750.00,'2023-01-01 10:09:15','',''),(2067,'1','302','1',1,'Retail Sale Id 2001',3680.00,0.00,0.00,5.00,300.00,'2023-01-01 10:15:26','',''),(2068,'1','302','1',1,'Retail Sale Id 2001',7360.00,0.00,0.00,10.00,600.00,'2023-01-01 10:15:26','',''),(2069,'1','302','1',1,'Retail Sale Id 2002',9200.00,0.00,0.00,12.50,750.00,'2023-01-01 10:17:52','',''),(2070,'1','302','1',1,'Retail Sale Id 2003',8520.00,0.00,0.00,12.00,408.00,'2023-01-01 10:23:41','',''),(2071,'1','302','1',1,'Retail Sale Id 2004',4416.00,0.00,0.00,6.00,360.00,'2023-01-01 10:25:58','',''),(2072,'1','302','1',1,'Retail Sale Id 2005',3680.00,0.00,0.00,5.00,300.00,'2023-01-01 10:27:02','',''),(2073,'1','302','1',1,'Retail Sale Id 2007',2208.00,0.00,0.00,3.00,180.00,'2023-01-01 10:36:37','',''),(2074,'1','302','1',1,'Retail Sale Id 2008',9200.00,0.00,0.00,12.50,750.00,'2023-01-01 10:38:38','',''),(2075,'1','302','1',1,'Retail Sale Id 2009',2208.00,0.00,0.00,3.00,180.00,'2023-01-01 10:41:17','',''),(2076,'1','302','1',1,'Retail Sale Id 2009',4416.00,0.00,0.00,6.00,360.00,'2023-01-01 10:41:17','',''),(2077,'1','302','1',1,'Retail Sale Id 2010',4496.96,0.00,0.00,6.11,366.60,'2023-01-01 10:42:22','',''),(2078,'1','302','1',1,'Retail Sale Id 2011',4416.00,0.00,0.00,6.00,360.00,'2023-01-01 10:43:56','',''),(2079,'1','302','1',1,'Retail Sale Id 2012',9200.00,0.00,0.00,12.50,750.00,'2023-01-01 10:45:07','',''),(2080,'1','302','1',1,'Retail Sale Id 2013',2796.80,0.00,0.00,3.80,228.00,'2023-01-01 10:48:05','',''),(2081,'1','302','1',1,'Retail Sale Id 2014',11040.00,0.00,0.00,15.00,900.00,'2023-01-01 10:49:18','',''),(2082,'1','302','1',1,'Retail Sale Id 2015',4997.44,0.00,0.00,6.79,407.40,'2023-01-01 10:52:29','',''),(2083,'1','302','1',1,'Retail Sale Id 2016',5048.96,0.00,0.00,6.86,411.60,'2023-01-01 10:53:15','',''),(2084,'1','302','1',1,'Retail Sale Id 2017',3680.00,0.00,0.00,5.00,300.00,'2023-01-01 10:59:07','',''),(2085,'1','302','1',1,'Retail Sale Id 2018',2208.00,0.00,0.00,3.00,180.00,'2023-01-01 11:04:44','',''),(2086,'1','302','1',1,'Retail Sale Id 2019',5152.00,0.00,0.00,7.00,420.00,'2023-01-01 11:21:38','',''),(2087,'1','302','1',1,'Retail Sale Id 2020',2208.00,0.00,0.00,3.00,180.00,'2023-01-01 11:25:36','',''),(2088,'1','302','1',1,'Retail Sale Id 2021',2208.00,0.00,0.00,3.00,180.00,'2023-01-01 11:32:08','',''),(2089,'1','302','1',1,'Retail Sale Id 2022',3680.00,0.00,0.00,5.00,300.00,'2023-01-01 11:33:29','',''),(2090,'1','302','1',1,'Retail Sale Id 2023',2944.00,0.00,0.00,4.00,240.00,'2023-01-01 11:34:26','',''),(2091,'1','302','1',1,'Retail Sale Id 2024',4202.56,0.00,0.00,5.71,342.60,'2023-01-01 11:35:38','',''),(2092,'1','302','1',1,'Retail Sale Id 2025',3996.48,0.00,0.00,5.43,325.80,'2023-01-01 11:45:11','',''),(2093,'1','302','1',1,'Retail Sale Id 2026',2208.00,0.00,0.00,3.00,180.00,'2023-01-01 11:50:53','',''),(2094,'1','302','1',1,'Retail Sale Id 2027',3680.00,0.00,0.00,5.00,300.00,'2023-01-01 12:00:01','',''),(2095,'1','302','1',1,'Retail Sale Id 2028',9200.00,0.00,0.00,12.50,750.00,'2023-01-01 12:02:52','',''),(2096,'1','302','1',1,'Retail Sale Id 2029',1803.20,0.00,0.00,2.45,147.00,'2023-01-01 12:04:11','',''),(2097,'1','302','1',1,'Retail Sale Id 2030',5152.00,0.00,0.00,7.00,420.00,'2023-01-01 12:06:14','',''),(2098,'1','302','1',1,'Retail Sale Id 2031',7065.60,0.00,0.00,9.60,576.00,'2023-01-01 12:08:04','',''),(2099,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,248402.96,367.46,0.00,0.00,'2023-01-01 19:33:46','',''),(2100,'1','302',NULL,1,'Reception corrector for bridging 12',0.00,0.00,0.00,367.46,0.00,'2023-01-01 19:36:34','',''),(2101,'1','302','1',1,'Received from bridging 12',0.00,0.00,367.46,0.00,0.00,'2023-01-01 19:36:34','',''),(2102,'1','302','1',1,'Retail Sale Id 2032',107794.56,0.00,0.00,146.46,8787.60,'2023-01-01 19:39:03','',''),(2103,'1','302','1',1,'Retail Sale Id 2033',156910.00,0.00,0.00,221.00,7514.00,'2023-01-01 19:41:25','',''),(2104,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3515200.00,5200.00,0.00,0.00,'2023-01-01 19:48:46','',''),(2105,'1','302',NULL,1,'Reception corrector for bridging 13',0.00,0.00,0.00,5200.00,0.00,'2023-01-01 19:51:23','',''),(2106,'1','302','1',1,'Received from bridging 13',0.00,0.00,5200.00,0.00,0.00,'2023-01-01 19:51:23','',''),(2107,'1','302','1',1,'Retail Sale Id 2034',91484.80,0.00,0.00,124.30,7458.00,'2023-01-01 19:54:20','',''),(2108,'1','302','1',1,'Retail Sale Id 2035',204572.30,0.00,0.00,288.13,9796.42,'2023-01-01 19:55:28','',''),(2109,'1','302','1',1,'Retail Sale Id 2036',802.24,0.00,0.00,1.09,65.40,'2023-01-02 08:04:00','',''),(2110,'1','302','1',1,'Retail Sale Id 2037',1501.44,0.00,0.00,2.04,122.40,'2023-01-02 08:06:34','',''),(2111,'1','302','1',1,'Retail Sale Id 2038',3702.08,0.00,0.00,5.03,301.80,'2023-01-02 08:22:30','',''),(2112,'1','302','1',1,'Retail Sale Id 2039',4496.96,0.00,0.00,6.11,366.60,'2023-01-02 08:43:23','',''),(2113,'1','302','1',1,'Retail Sale Id 2041',4496.96,0.00,0.00,6.11,366.60,'2023-01-02 08:59:40','',''),(2114,'1','302','1',1,'Retail Sale Id 2042',2001.92,0.00,0.00,2.72,163.20,'2023-01-02 09:16:18','',''),(2115,'1','302','1',1,'Retail Sale Id 2043',2200.64,0.00,0.00,2.99,179.40,'2023-01-02 09:23:26','',''),(2116,'1','302','1',1,'Retail Sale Id 2044',1000.96,0.00,0.00,1.36,81.60,'2023-01-02 09:35:03','',''),(2117,'1','302','1',1,'Retail Sale Id 2045',3002.88,0.00,0.00,4.08,244.80,'2023-01-02 09:38:48','',''),(2118,'1','302','1',1,'Retail Sale Id 2046',699.20,0.00,0.00,0.95,57.00,'2023-01-02 09:40:01','',''),(2119,'1','302','1',1,'Retail Sale Id 2047',198.72,0.00,0.00,0.27,16.20,'2023-01-02 09:46:35','',''),(2120,'1','302','1',1,'Retail Sale Id 2048',9200.00,0.00,0.00,12.50,750.00,'2023-01-02 09:48:27','',''),(2121,'1','302','1',1,'Retail Sale Id 2049',35500.00,0.00,0.00,50.00,1700.00,'2023-01-02 09:52:14','',''),(2122,'1','302','1',1,'Retail Sale Id 2051',28002.40,0.00,0.00,39.44,1340.96,'2023-01-02 10:04:17','',''),(2123,'1','302','1',1,'Retail Sale Id 2052',5152.00,0.00,0.00,7.00,420.00,'2023-01-02 10:14:13','',''),(2124,'1','302','1',1,'Retail Sale Id 2053',1501.44,0.00,0.00,2.04,122.40,'2023-01-02 10:21:23','',''),(2125,'1','302','1',1,'Retail Sale Id 2054',3002.88,0.00,0.00,4.08,244.80,'2023-01-02 10:32:45','',''),(2126,'1','302','1',1,'Retail Sale Id 2056',51120.00,0.00,0.00,72.00,2448.00,'2023-01-02 10:36:54','',''),(2127,'1','302','1',1,'Retail Sale Id 2057',1000.96,0.00,0.00,1.36,81.60,'2023-01-02 10:52:28','',''),(2128,'1','302','1',1,'Retail Sale Id 2058',1000.96,0.00,0.00,1.36,81.60,'2023-01-02 10:55:46','',''),(2129,'1','302','1',1,'Retail Sale Id 2059',3002.88,0.00,0.00,4.08,244.80,'2023-01-02 11:00:44','',''),(2130,'1','302','1',1,'Retail Sale Id 2060',2001.92,0.00,0.00,2.72,163.20,'2023-01-02 11:05:34','',''),(2131,'1','302','1',1,'Retail Sale Id 2061',3797.76,0.00,0.00,5.16,309.60,'2023-01-02 11:10:05','',''),(2132,'1','302','1',1,'Retail Sale Id 2062',4496.96,0.00,0.00,6.11,366.60,'2023-01-02 11:14:31','',''),(2133,'1','302','1',1,'Retail Sale Id 2063',2208.00,0.00,0.00,3.00,180.00,'2023-01-02 11:17:32','',''),(2134,'1','302','1',1,'Retail Sale Id 2063',9200.00,0.00,0.00,12.50,750.00,'2023-01-02 11:17:32','',''),(2135,'1','302','1',1,'Retail Sale Id 2064',2222.72,0.00,0.00,3.02,181.20,'2023-01-02 11:37:59','',''),(2136,'1','302','1',1,'Retail Sale Id 2065',1501.44,0.00,0.00,2.04,122.40,'2023-01-02 11:48:02','',''),(2137,'1','302','1',1,'Retail Sale Id 2066',2303.68,0.00,0.00,3.13,187.80,'2023-01-02 11:49:26','',''),(2138,'1','302','1',1,'Retail Sale Id 2067',1000.96,0.00,0.00,1.36,81.60,'2023-01-02 11:53:55','',''),(2139,'1','302','1',1,'Retail Sale Id 2068',2200.64,0.00,0.00,2.99,179.40,'2023-01-02 12:01:23','',''),(2140,'1','302','1',1,'Retail Sale Id 2069',2001.92,0.00,0.00,2.72,163.20,'2023-01-02 12:05:22','',''),(2141,'1','302','1',1,'Retail Sale Id 2070',3002.88,0.00,0.00,4.08,244.80,'2023-01-02 12:10:44','',''),(2142,'1','302','1',1,'Retail Sale Id 2071',9200.00,0.00,0.00,12.50,750.00,'2023-01-02 12:14:39','',''),(2143,'1','302','1',1,'Retail Sale Id 2072',3680.00,0.00,0.00,5.00,300.00,'2023-01-02 12:21:50','',''),(2144,'1','302','1',1,'Retail Sale Id 2072',4416.00,0.00,0.00,6.00,360.00,'2023-01-02 12:21:50','',''),(2145,'1','302','1',1,'Retail Sale Id 2073',3680.00,0.00,0.00,5.00,300.00,'2023-01-02 12:45:05','',''),(2146,'1','302','1',1,'Retail Sale Id 2074',2502.40,0.00,0.00,3.40,204.00,'2023-01-02 12:45:50','',''),(2147,'1','302','1',1,'Retail Sale Id 2075',3996.48,0.00,0.00,5.43,325.80,'2023-01-02 12:49:02','',''),(2148,'1','302','1',1,'Retail Sale Id 2076',2001.92,0.00,0.00,2.72,163.20,'2023-01-02 12:51:37','',''),(2149,'1','302','1',1,'Retail Sale Id 2077',2208.00,0.00,0.00,3.00,180.00,'2023-01-02 13:01:19','',''),(2150,'1','302','1',1,'Retail Sale Id 2077',9200.00,0.00,0.00,12.50,750.00,'2023-01-02 13:01:19','',''),(2151,'1','302','1',1,'Retail Sale Id 2078',17750.00,0.00,0.00,25.00,850.00,'2023-01-02 13:04:28','',''),(2152,'1','302','1',1,'Retail Sale Id 2079',4423.36,0.00,0.00,6.01,360.60,'2023-01-02 13:05:36','',''),(2153,'1','302','1',1,'Retail Sale Id 2080',3002.88,0.00,0.00,4.08,244.80,'2023-01-02 13:06:29','',''),(2154,'1','302','1',1,'Retail Sale Id 2081',1000.96,0.00,0.00,1.36,81.60,'2023-01-02 13:11:45','',''),(2155,'1','302','1',1,'Retail Sale Id 2082',2208.00,0.00,0.00,3.00,180.00,'2023-01-02 13:13:41','',''),(2156,'1','302','1',1,'Retail Sale Id 2083',1479.36,0.00,0.00,2.01,120.60,'2023-01-02 13:14:46','',''),(2157,'1','302','1',1,'Retail Sale Id 2084',9200.00,0.00,0.00,12.50,750.00,'2023-01-02 13:16:03','',''),(2158,'1','302','1',1,'Retail Sale Id 2085',5152.00,0.00,0.00,7.00,420.00,'2023-01-02 13:43:35','',''),(2159,'1','302','1',1,'Retail Sale Id 2086',4496.96,0.00,0.00,6.11,366.60,'2023-01-02 13:46:00','',''),(2160,'1','302','1',1,'Retail Sale Id 2087',1501.44,0.00,0.00,2.04,122.40,'2023-01-02 14:24:54','',''),(2161,'1','302','1',1,'Retail Sale Id 2088',2252.16,0.00,0.00,3.06,183.60,'2023-01-02 14:26:15','',''),(2162,'1','302','1',1,'Retail Sale Id 2089',17750.00,0.00,0.00,25.00,850.00,'2023-01-02 14:38:15','',''),(2163,'1','302','1',1,'Retail Sale Id 2090',36800.00,0.00,0.00,50.00,3000.00,'2023-01-02 14:41:08','',''),(2164,'1','302','1',1,'Retail Sale Id 2091',2200.64,0.00,0.00,2.99,179.40,'2023-01-02 14:49:36','',''),(2165,'1','302','1',1,'Retail Sale Id 2092',3996.48,0.00,0.00,5.43,325.80,'2023-01-02 14:59:56','',''),(2166,'1','302','1',1,'Retail Sale Id 2093',4416.00,0.00,0.00,6.00,360.00,'2023-01-02 15:04:53','',''),(2167,'1','302','1',1,'Retail Sale Id 2094',9200.00,0.00,0.00,12.50,750.00,'2023-01-02 15:07:01','',''),(2168,'1','302','1',1,'Retail Sale Id 2094',9200.00,0.00,0.00,12.50,750.00,'2023-01-02 15:07:01','',''),(2169,'1','302','1',1,'Retail Sale Id 2094',9200.00,0.00,0.00,12.50,750.00,'2023-01-02 15:07:01','',''),(2170,'1','302','1',1,'Retail Sale Id 2095',9200.00,0.00,0.00,12.50,750.00,'2023-01-02 15:18:48','',''),(2171,'1','302','1',1,'Retail Sale Id 2096',2208.00,0.00,0.00,3.00,180.00,'2023-01-02 15:20:39','',''),(2172,'1','302','1',1,'Retail Sale Id 2097',3083.84,0.00,0.00,4.19,251.40,'2023-01-02 15:33:23','',''),(2173,'1','302','1',1,'Retail Sale Id 2097',4416.00,0.00,0.00,6.00,360.00,'2023-01-02 15:33:23','',''),(2174,'1','302','1',1,'Retail Sale Id 2098',1501.44,0.00,0.00,2.04,122.40,'2023-01-02 15:34:28','',''),(2175,'1','302','1',1,'Retail Sale Id 2099',2208.00,0.00,0.00,3.00,180.00,'2023-01-02 15:38:22','',''),(2176,'1','302','1',1,'Retail Sale Id 2099',9200.00,0.00,0.00,12.50,750.00,'2023-01-02 15:38:22','',''),(2177,'1','302','1',1,'Retail Sale Id 2100',2208.00,0.00,0.00,3.00,180.00,'2023-01-02 15:42:07','',''),(2178,'1','302','1',1,'Retail Sale Id 2101',1000.96,0.00,0.00,1.36,81.60,'2023-01-02 15:43:49','',''),(2179,'1','302','1',1,'Retail Sale Id 2102',6999.36,0.00,0.00,9.51,570.60,'2023-01-02 16:03:00','',''),(2180,'1','302','1',1,'Retail Sale Id 2103',1472.00,0.00,0.00,2.00,120.00,'2023-01-02 16:11:39','',''),(2181,'1','302','1',1,'Retail Sale Id 2104',3503.36,0.00,0.00,4.76,285.60,'2023-01-02 16:15:54','',''),(2182,'1','302','1',1,'Retail Sale Id 2105',1000.96,0.00,0.00,1.36,81.60,'2023-01-02 16:19:24','',''),(2183,'1','302','1',1,'Retail Sale Id 2106',2502.40,0.00,0.00,3.40,204.00,'2023-01-02 16:21:16','',''),(2184,'1','302','1',1,'Retail Sale Id 2107',4496.96,0.00,0.00,6.11,366.60,'2023-01-02 16:30:15','',''),(2185,'1','302','1',1,'Retail Sale Id 2108',2944.00,0.00,0.00,4.00,240.00,'2023-01-02 16:32:15','',''),(2186,'1','302','1',1,'Retail Sale Id 2109',4423.36,0.00,0.00,6.01,360.60,'2023-01-02 16:33:20','',''),(2187,'1','302','1',1,'Retail Sale Id 2110',5902.72,0.00,0.00,8.02,481.20,'2023-01-02 16:34:26','',''),(2188,'1','302','1',1,'Retail Sale Id 2111',4496.96,0.00,0.00,6.11,366.60,'2023-01-02 16:36:11','',''),(2189,'1','302','1',1,'Retail Sale Id 2112',3002.88,0.00,0.00,4.08,244.80,'2023-01-02 16:41:07','',''),(2190,'1','302','1',1,'Retail Sale Id 2113',4496.96,0.00,0.00,6.11,366.60,'2023-01-02 16:48:19','',''),(2191,'1','302','1',1,'Retail Sale Id 2114',1000.96,0.00,0.00,1.36,81.60,'2023-01-02 16:51:19','',''),(2192,'1','302','1',1,'Retail Sale Id 2116',2208.00,0.00,0.00,3.00,180.00,'2023-01-02 17:01:38','',''),(2193,'1','302','1',1,'Retail Sale Id 2117',49259.80,0.00,0.00,69.38,2358.92,'2023-01-02 17:12:20','',''),(2194,'1','302','1',1,'Retail Sale Id 2118',3680.00,0.00,0.00,5.00,300.00,'2023-01-02 17:13:05','',''),(2195,'1','302','1',1,'Retail Sale Id 2119',2001.92,0.00,0.00,2.72,163.20,'2023-01-02 17:13:52','',''),(2196,'1','302','1',1,'Retail Sale Id 2120',2001.92,0.00,0.00,2.72,163.20,'2023-01-02 17:15:20','',''),(2197,'1','302','1',1,'Retail Sale Id 2121',7499.84,0.00,0.00,10.19,611.40,'2023-01-02 17:17:00','',''),(2198,'1','302','1',1,'Retail Sale Id 2122',2208.00,0.00,0.00,3.00,180.00,'2023-01-02 17:19:33','',''),(2199,'1','302','1',1,'Retail Sale Id 2123',5998.40,0.00,0.00,8.15,489.00,'2023-01-02 17:26:12','',''),(2200,'1','302','1',1,'Retail Sale Id 2124',1000.96,0.00,0.00,1.36,81.60,'2023-01-02 17:41:35','',''),(2201,'1','302','1',1,'Retail Sale Id 2125',4496.96,0.00,0.00,6.11,366.60,'2023-01-02 17:49:52','',''),(2202,'1','302','1',1,'Retail Sale Id 2126',9200.00,0.00,0.00,12.50,750.00,'2023-01-02 17:53:20','',''),(2203,'1','302','1',1,'Retail Sale Id 2128',699.20,0.00,0.00,0.95,57.00,'2023-01-02 17:54:19','',''),(2204,'1','302','1',1,'Retail Sale Id 2129',699.20,0.00,0.00,0.95,57.00,'2023-01-02 18:07:52','',''),(2205,'1','302','1',1,'Retail Sale Id 2130',9200.00,0.00,0.00,12.50,750.00,'2023-01-02 18:11:59','',''),(2206,'1','302','1',1,'Retail Sale Id 2131',2208.00,0.00,0.00,3.00,180.00,'2023-01-02 18:17:48','',''),(2207,'1','302','1',1,'Retail Sale Id 2132',1000.96,0.00,0.00,1.36,81.60,'2023-01-02 18:18:50','',''),(2208,'1','302','1',1,'Return of Retail Sale Id 2112',0.00,3002.88,4.08,0.00,-244.80,'2023-01-02 19:14:52','',''),(2209,'1','302','1',1,'Retail Sale Id 2133',2752.64,0.00,0.00,3.74,224.40,'2023-01-02 19:17:07','',''),(2210,'1','302','1',1,'Retail Sale Id 2134',4496.96,0.00,0.00,6.11,366.60,'2023-01-03 07:43:25','',''),(2211,'1','302','1',1,'Retail Sale Id 2135',1000.96,0.00,0.00,1.36,81.60,'2023-01-03 07:58:38','',''),(2212,'1','302','1',1,'Retail Sale Id 2136',3503.36,0.00,0.00,4.76,285.60,'2023-01-03 08:02:23','',''),(2213,'1','302','1',1,'Retail Sale Id 2137',9200.00,0.00,0.00,12.50,750.00,'2023-01-03 08:27:21','',''),(2214,'1','302','1',1,'Retail Sale Id 2138',2001.92,0.00,0.00,2.72,163.20,'2023-01-03 08:33:43','',''),(2215,'1','302','1',1,'Retail Sale Id 2139',4416.00,0.00,0.00,6.00,360.00,'2023-01-03 08:51:04','',''),(2216,'1','302','1',1,'Retail Sale Id 2140',2200.64,0.00,0.00,2.99,179.40,'2023-01-03 08:56:24','',''),(2217,'1','302','1',1,'Retail Sale Id 2141',3680.00,0.00,0.00,5.00,300.00,'2023-01-03 09:16:01','',''),(2218,'1','302','1',1,'Retail Sale Id 2142',802.24,0.00,0.00,1.09,65.40,'2023-01-03 09:36:30','',''),(2219,'1','302','1',1,'Retail Sale Id 2143',3996.48,0.00,0.00,5.43,325.80,'2023-01-03 09:41:04','',''),(2220,'1','302','1',1,'Retail Sale Id 2144',2200.64,0.00,0.00,2.99,179.40,'2023-01-03 09:42:00','',''),(2221,'1','302','1',1,'Retail Sale Id 2145',1251.20,0.00,0.00,1.70,102.00,'2023-01-03 09:43:20','',''),(2222,'1','302','1',1,'Retail Sale Id 2146',2208.00,0.00,0.00,3.00,180.00,'2023-01-03 10:03:34','',''),(2223,'1','302','1',1,'Retail Sale Id 2147',1472.00,0.00,0.00,2.00,120.00,'2023-01-03 10:06:09','',''),(2224,'1','302','1',1,'Retail Sale Id 2148',1501.44,0.00,0.00,2.04,122.40,'2023-01-03 10:22:39','',''),(2225,'1','302','1',1,'Retail Sale Id 2149',9200.00,0.00,0.00,12.50,750.00,'2023-01-03 10:26:13','',''),(2226,'1','302','1',1,'Retail Sale Id 2150',18400.00,0.00,0.00,25.00,1500.00,'2023-01-03 10:36:05','',''),(2227,'1','302','1',1,'Retail Sale Id 2151',5888.00,0.00,0.00,8.00,480.00,'2023-01-03 10:40:31','',''),(2228,'1','302','1',1,'Retail Sale Id 2152',2208.00,0.00,0.00,3.00,180.00,'2023-01-03 10:45:23','',''),(2229,'1','302','1',1,'Retail Sale Id 2152',4416.00,0.00,0.00,6.00,360.00,'2023-01-03 10:45:23','',''),(2230,'1','302','1',1,'Retail Sale Id 2153',2208.00,0.00,0.00,3.00,180.00,'2023-01-03 10:49:29','',''),(2231,'1','302','1',1,'Retail Sale Id 2153',4416.00,0.00,0.00,6.00,360.00,'2023-01-03 10:49:29','',''),(2232,'1','302','1',1,'Retail Sale Id 2154',1501.44,0.00,0.00,2.04,122.40,'2023-01-03 10:51:13','',''),(2233,'1','302','1',1,'Retail Sale Id 2155',1501.44,0.00,0.00,2.04,122.40,'2023-01-03 10:51:56','',''),(2234,'1','302','1',1,'Retail Sale Id 2156',5152.00,0.00,0.00,7.00,420.00,'2023-01-03 10:52:48','',''),(2235,'1','302','1',1,'Retail Sale Id 2157',7360.00,0.00,0.00,10.00,600.00,'2023-01-03 10:55:40','',''),(2236,'1','302','1',1,'Retail Sale Id 2158',35500.00,0.00,0.00,50.00,1700.00,'2023-01-03 10:57:51','',''),(2237,'1','302','1',1,'Retail Sale Id 2159',5152.00,0.00,0.00,7.00,420.00,'2023-01-03 11:02:28','',''),(2238,'1','302','1',1,'Retail Sale Id 2160',1501.44,0.00,0.00,2.04,122.40,'2023-01-03 11:08:31','',''),(2239,'1','302','1',1,'Retail Sale Id 2160',2001.92,0.00,0.00,2.72,163.20,'2023-01-03 11:08:31','',''),(2240,'1','302','1',1,'Retail Sale Id 2161',3680.00,0.00,0.00,5.00,300.00,'2023-01-03 11:13:51','',''),(2241,'1','302','1',1,'Retail Sale Id 2162',3996.48,0.00,0.00,5.43,325.80,'2023-01-03 11:15:02','',''),(2242,'1','302','1',1,'Retail Sale Id 2163',4416.00,0.00,0.00,6.00,360.00,'2023-01-03 11:16:40','',''),(2243,'1','302','1',1,'Retail Sale Id 2164',3680.00,0.00,0.00,5.00,300.00,'2023-01-03 11:21:13','',''),(2244,'1','302','1',1,'Retail Sale Id 2165',71000.00,0.00,0.00,100.00,3400.00,'2023-01-03 11:23:23','',''),(2245,'1','302','1',1,'Retail Sale Id 2166',4416.00,0.00,0.00,6.00,360.00,'2023-01-03 11:33:34','',''),(2246,'1','302','1',1,'Retail Sale Id 2167',3002.88,0.00,0.00,4.08,244.80,'2023-01-03 11:34:25','',''),(2247,'1','302','1',1,'Retail Sale Id 2168',3680.00,0.00,0.00,5.00,300.00,'2023-01-03 11:35:41','',''),(2248,'1','302','1',1,'Retail Sale Id 2169',3680.00,0.00,0.00,5.00,300.00,'2023-01-03 11:36:34','',''),(2249,'1','302','1',1,'Retail Sale Id 2170',1840.00,0.00,0.00,2.50,150.00,'2023-01-03 11:54:39','',''),(2250,'1','302','1',1,'Retail Sale Id 2171',7360.00,0.00,0.00,10.00,600.00,'2023-01-03 11:57:56','',''),(2251,'1','302','1',1,'Retail Sale Id 2172',3002.88,0.00,0.00,4.08,244.80,'2023-01-03 12:01:52','',''),(2252,'1','302','1',1,'Retail Sale Id 2172',3996.48,0.00,0.00,5.43,325.80,'2023-01-03 12:01:52','',''),(2253,'1','302','1',1,'Retail Sale Id 2173',4416.00,0.00,0.00,6.00,360.00,'2023-01-03 12:10:43','',''),(2254,'1','302','1',1,'Retail Sale Id 2174',1501.44,0.00,0.00,2.04,122.40,'2023-01-03 12:12:04','',''),(2255,'1','302','1',1,'Retail Sale Id 2175',2208.00,0.00,0.00,3.00,180.00,'2023-01-03 12:28:49','',''),(2256,'1','302','1',1,'Retail Sale Id 2176',2200.64,0.00,0.00,2.99,179.40,'2023-01-03 12:38:02','',''),(2257,'1','302','1',1,'Retail Sale Id 2177',1472.00,0.00,0.00,2.00,120.00,'2023-01-03 12:53:17','',''),(2258,'1','302','1',1,'Retail Sale Id 2178',8000.32,0.00,0.00,10.87,652.20,'2023-01-03 13:05:42','',''),(2259,'1','302','1',1,'Retail Sale Id 2179',4416.00,0.00,0.00,6.00,360.00,'2023-01-03 13:21:31','',''),(2260,'1','302','1',1,'Retail Sale Id 2179',9200.00,0.00,0.00,12.50,750.00,'2023-01-03 13:21:31','',''),(2261,'1','302','1',1,'Retail Sale Id 2180',2944.00,0.00,0.00,4.00,240.00,'2023-01-03 13:23:48','',''),(2262,'1','302','1',1,'Retail Sale Id 2181',1501.44,0.00,0.00,2.04,122.40,'2023-01-03 13:26:15','',''),(2263,'1','302','1',1,'Retail Sale Id 2182',9200.00,0.00,0.00,12.50,750.00,'2023-01-03 13:33:43','',''),(2264,'1','302','1',1,'Retail Sale Id 2183',4416.00,0.00,0.00,6.00,360.00,'2023-01-03 13:34:58','',''),(2265,'1','302','1',1,'Retail Sale Id 2184',4416.00,0.00,0.00,6.00,360.00,'2023-01-03 13:51:22','',''),(2266,'1','302','1',1,'Retail Sale Id 2185',2001.92,0.00,0.00,2.72,163.20,'2023-01-03 13:55:58','',''),(2267,'1','302','1',1,'Retail Sale Id 2186',3680.00,0.00,0.00,5.00,300.00,'2023-01-03 14:04:04','',''),(2268,'1','302','1',1,'Retail Sale Id 2186',9200.00,0.00,0.00,12.50,750.00,'2023-01-03 14:04:04','',''),(2269,'1','302','1',1,'Retail Sale Id 2187',18400.00,0.00,0.00,25.00,1500.00,'2023-01-03 14:06:12','',''),(2270,'1','302','1',1,'Retail Sale Id 2188',9200.00,0.00,0.00,12.50,750.00,'2023-01-03 14:13:38','',''),(2271,'1','302','1',1,'Retail Sale Id 2189',1000.96,0.00,0.00,1.36,81.60,'2023-01-03 14:14:37','',''),(2272,'1','302','1',1,'Retail Sale Id 2190',9200.00,0.00,0.00,12.50,750.00,'2023-01-03 14:17:14','',''),(2273,'1','302','1',1,'Retail Sale Id 2191',4416.00,0.00,0.00,6.00,360.00,'2023-01-03 14:47:55','',''),(2274,'1','302','1',1,'Retail Sale Id 2192',2502.40,0.00,0.00,3.40,204.00,'2023-01-03 14:52:19','',''),(2275,'1','302','1',1,'Retail Sale Id 2193',5152.00,0.00,0.00,7.00,420.00,'2023-01-03 14:56:53','',''),(2276,'1','302','1',1,'Retail Sale Id 2194',4416.00,0.00,0.00,6.00,360.00,'2023-01-03 14:59:03','',''),(2277,'1','302','1',1,'Retail Sale Id 2194',4416.00,0.00,0.00,6.00,360.00,'2023-01-03 14:59:03','',''),(2278,'1','302','1',1,'Retail Sale Id 2194',9200.00,0.00,0.00,12.50,750.00,'2023-01-03 14:59:03','',''),(2279,'1','302','1',1,'Retail Sale Id 2195',1501.44,0.00,0.00,2.04,122.40,'2023-01-03 15:00:13','',''),(2280,'1','302','1',1,'Retail Sale Id 2196',3996.48,0.00,0.00,5.43,325.80,'2023-01-03 15:01:09','',''),(2281,'1','302','1',1,'Retail Sale Id 2197',1000.96,0.00,0.00,1.36,81.60,'2023-01-03 15:02:03','',''),(2282,'1','302','1',1,'Retail Sale Id 2198',36800.00,0.00,0.00,50.00,3000.00,'2023-01-03 15:04:49','',''),(2283,'1','302','1',1,'Retail Sale Id 2199',4416.00,0.00,0.00,6.00,360.00,'2023-01-03 15:08:05','',''),(2284,'1','302','1',1,'Retail Sale Id 2200',2001.92,0.00,0.00,2.72,163.20,'2023-01-03 15:10:56','',''),(2285,'1','302','1',1,'Retail Sale Id 2201',2208.00,0.00,0.00,3.00,180.00,'2023-01-03 15:23:13','',''),(2286,'1','302','1',1,'Retail Sale Id 2202',1501.44,0.00,0.00,2.04,122.40,'2023-01-03 15:25:23','',''),(2287,'1','302','1',1,'Retail Sale Id 2203',2944.00,0.00,0.00,4.00,240.00,'2023-01-03 15:32:55','',''),(2288,'1','302','1',1,'Retail Sale Id 2204',1501.44,0.00,0.00,2.04,122.40,'2023-01-03 15:36:56','',''),(2289,'1','302','1',1,'Retail Sale Id 2205',2208.00,0.00,0.00,3.00,180.00,'2023-01-03 15:39:11','',''),(2290,'1','302','1',1,'Retail Sale Id 2206',1000.96,0.00,0.00,1.36,81.60,'2023-01-03 15:40:47','',''),(2291,'1','302','1',1,'Retail Sale Id 2207',802.24,0.00,0.00,1.09,65.40,'2023-01-03 15:41:37','',''),(2292,'1','302','1',1,'Retail Sale Id 2208',1472.00,0.00,0.00,2.00,120.00,'2023-01-03 15:45:42','',''),(2293,'1','302','1',1,'Retail Sale Id 2209',3680.00,0.00,0.00,5.00,300.00,'2023-01-03 15:48:00','',''),(2294,'1','302','1',1,'Retail Sale Id 2210',6498.88,0.00,0.00,8.83,529.80,'2023-01-03 15:51:47','',''),(2295,'1','302','1',1,'Retail Sale Id 2211',3996.48,0.00,0.00,5.43,325.80,'2023-01-03 15:52:38','',''),(2296,'1','302','1',1,'Retail Sale Id 2212',2502.40,0.00,0.00,3.40,204.00,'2023-01-03 15:57:39','',''),(2297,'1','302','1',1,'Retail Sale Id 2214',3297.28,0.00,0.00,4.48,268.80,'2023-01-03 16:00:01','',''),(2298,'1','302','1',1,'Retail Sale Id 2215',2001.92,0.00,0.00,2.72,163.20,'2023-01-03 16:01:56','',''),(2299,'1','302','1',1,'Retail Sale Id 2216',3002.88,0.00,0.00,4.08,244.80,'2023-01-03 16:05:10','',''),(2300,'1','302','1',1,'Retail Sale Id 2217',9200.00,0.00,0.00,12.50,750.00,'2023-01-03 16:06:36','',''),(2301,'1','302','1',1,'Retail Sale Id 2218',4416.00,0.00,0.00,6.00,360.00,'2023-01-03 16:07:54','',''),(2302,'1','302','1',1,'Retail Sale Id 2219',115375.00,0.00,0.00,162.50,5525.00,'2023-01-03 16:10:28','',''),(2303,'1','302','1',1,'Retail Sale Id 2220',9200.00,0.00,0.00,12.50,750.00,'2023-01-03 16:11:43','',''),(2304,'1','302','1',1,'Retail Sale Id 2221',5998.40,0.00,0.00,8.15,489.00,'2023-01-03 16:26:40','',''),(2305,'1','302','1',1,'Retail Sale Id 2222',36800.00,0.00,0.00,50.00,3000.00,'2023-01-03 16:32:48','',''),(2306,'1','302','1',1,'Retail Sale Id 2223',4997.44,0.00,0.00,6.79,407.40,'2023-01-03 16:34:02','',''),(2307,'1','302','1',1,'Retail Sale Id 2224',67450.00,0.00,0.00,95.00,3230.00,'2023-01-03 16:37:42','',''),(2308,'1','302','1',1,'Retail Sale Id 2226',9200.00,0.00,0.00,12.50,750.00,'2023-01-03 16:40:21','',''),(2309,'1','302','1',1,'Retail Sale Id 2227',2208.00,0.00,0.00,3.00,180.00,'2023-01-03 16:41:28','',''),(2310,'1','302','1',1,'Retail Sale Id 2228',3002.88,0.00,0.00,4.08,244.80,'2023-01-03 16:49:55','',''),(2311,'1','302','1',1,'Retail Sale Id 2229',2001.92,0.00,0.00,2.72,163.20,'2023-01-03 16:53:03','',''),(2312,'1','302','1',1,'Retail Sale Id 2230',9200.00,0.00,0.00,12.50,750.00,'2023-01-03 17:01:29','',''),(2313,'1','302','1',1,'Retail Sale Id 2231',1000.96,0.00,0.00,1.36,81.60,'2023-01-03 17:02:26','',''),(2314,'1','302','1',1,'Retail Sale Id 2232',9200.00,0.00,0.00,12.50,750.00,'2023-01-03 17:03:29','',''),(2315,'1','302','1',1,'Retail Sale Id 2234',5152.00,0.00,0.00,7.00,420.00,'2023-01-03 17:06:12','',''),(2316,'1','302','1',1,'Retail Sale Id 2235',7360.00,0.00,0.00,10.00,600.00,'2023-01-03 17:08:21','',''),(2317,'1','302','1',1,'Retail Sale Id 2235',7360.00,0.00,0.00,10.00,600.00,'2023-01-03 17:08:21','',''),(2318,'1','302','1',1,'Retail Sale Id 2235',7360.00,0.00,0.00,10.00,600.00,'2023-01-03 17:08:21','',''),(2319,'1','302','1',1,'Retail Sale Id 2236',2208.00,0.00,0.00,3.00,180.00,'2023-01-03 17:12:30','',''),(2320,'1','302','1',1,'Retail Sale Id 2237',1472.00,0.00,0.00,2.00,120.00,'2023-01-03 17:25:32','',''),(2321,'1','302','1',1,'Retail Sale Id 2238',2208.00,0.00,0.00,3.00,180.00,'2023-01-03 17:47:23','',''),(2322,'1','302','1',1,'Retail Sale Id 2239',2208.00,0.00,0.00,3.00,180.00,'2023-01-03 17:59:04','',''),(2323,'1','302','1',1,'Retail Sale Id 2240',5998.40,0.00,0.00,8.15,489.00,'2023-01-03 18:02:17','',''),(2324,'1','302','1',1,'Retail Sale Id 2241',2944.00,0.00,0.00,4.00,240.00,'2023-01-03 18:05:58','',''),(2325,'1','302','1',1,'Retail Sale Id 2243',264.96,0.00,0.00,0.36,21.60,'2023-01-03 18:20:44','',''),(2326,'1','302','1',1,'Retail Sale Id 2244',1000.96,0.00,0.00,1.36,81.60,'2023-01-04 08:02:39','',''),(2327,'1','302','1',1,'Retail Sale Id 2245',1501.44,0.00,0.00,2.04,122.40,'2023-01-04 08:04:22','',''),(2328,'1','302','1',1,'Retail Sale Id 2246',106500.00,0.00,0.00,150.00,5100.00,'2023-01-04 08:11:10','',''),(2329,'1','302','1',1,'Retail Sale Id 2247',4496.96,0.00,0.00,6.11,366.60,'2023-01-04 08:18:14','',''),(2330,'1','302','1',1,'Retail Sale Id 2248',2208.00,0.00,0.00,3.00,180.00,'2023-01-04 08:33:04','',''),(2331,'1','302','1',1,'Retail Sale Id 2249',802.24,0.00,0.00,1.09,65.40,'2023-01-04 08:33:53','',''),(2332,'1','302','1',1,'Retail Sale Id 2250',9200.00,0.00,0.00,12.50,750.00,'2023-01-04 08:50:32','',''),(2333,'1','302','1',1,'Retail Sale Id 2251',2001.92,0.00,0.00,2.72,163.20,'2023-01-04 08:52:03','',''),(2334,'1','302','1',1,'Retail Sale Id 2252',71000.00,0.00,0.00,100.00,3400.00,'2023-01-04 09:16:50','',''),(2335,'1','302','1',1,'Retail Sale Id 2253',3996.48,0.00,0.00,5.43,325.80,'2023-01-04 09:18:29','',''),(2336,'1','302','1',1,'Retail Sale Id 2254',1000.96,0.00,0.00,1.36,81.60,'2023-01-04 09:19:11','',''),(2337,'1','302','1',1,'Retail Sale Id 2255',4416.00,0.00,0.00,6.00,360.00,'2023-01-04 09:21:20','',''),(2338,'1','302','1',1,'Retail Sale Id 2256',4416.00,0.00,0.00,6.00,360.00,'2023-01-04 09:23:11','',''),(2339,'1','302','1',1,'Retail Sale Id 2257',4496.96,0.00,0.00,6.11,366.60,'2023-01-04 09:24:13','',''),(2340,'1','302','1',1,'Retail Sale Id 2258',3503.36,0.00,0.00,4.76,285.60,'2023-01-04 09:26:05','',''),(2341,'1','302','1',1,'Retail Sale Id 2259',1501.44,0.00,0.00,2.04,122.40,'2023-01-04 09:26:53','',''),(2342,'1','302','1',1,'Retail Sale Id 2260',8096.00,0.00,0.00,11.00,660.00,'2023-01-04 09:33:30','',''),(2343,'1','302','1',1,'Retail Sale Id 2261',3503.36,0.00,0.00,4.76,285.60,'2023-01-04 09:35:31','',''),(2344,'1','302','1',1,'Retail Sale Id 2262',9501.76,0.00,0.00,12.91,774.60,'2023-01-04 09:58:32','',''),(2345,'1','302','1',1,'Retail Sale Id 2263',4496.96,0.00,0.00,6.11,366.60,'2023-01-04 10:00:12','',''),(2346,'1','302','1',1,'Retail Sale Id 2264',3002.88,0.00,0.00,4.08,244.80,'2023-01-04 10:19:56','',''),(2347,'1','302','1',1,'Retail Sale Id 2265',4496.96,0.00,0.00,6.11,366.60,'2023-01-04 10:20:45','',''),(2348,'1','302','1',1,'Retail Sale Id 2266',2001.92,0.00,0.00,2.72,163.20,'2023-01-04 11:05:18','',''),(2349,'1','302','1',1,'Retail Sale Id 2267',3702.08,0.00,0.00,5.03,301.80,'2023-01-04 11:06:57','',''),(2350,'1','302','1',1,'Retail Sale Id 2268',2944.00,0.00,0.00,4.00,240.00,'2023-01-04 11:18:36','',''),(2351,'1','302','1',1,'Retail Sale Id 2269',9200.00,0.00,0.00,12.50,750.00,'2023-01-04 11:20:04','',''),(2352,'1','302','1',1,'Retail Sale Id 2270',4416.00,0.00,0.00,6.00,360.00,'2023-01-04 11:25:06','',''),(2353,'1','302','1',1,'Retail Sale Id 2271',9200.00,0.00,0.00,12.50,750.00,'2023-01-04 11:26:26','',''),(2354,'1','302','1',1,'Retail Sale Id 2272',4496.96,0.00,0.00,6.11,366.60,'2023-01-04 11:30:09','',''),(2355,'1','302','1',1,'Retail Sale Id 2273',3680.00,0.00,0.00,5.00,300.00,'2023-01-04 11:36:21','',''),(2356,'1','302','1',1,'Retail Sale Id 2274',1000.96,0.00,0.00,1.36,81.60,'2023-01-04 11:38:16','',''),(2357,'1','302','1',1,'Retail Sale Id 2275',4496.96,0.00,0.00,6.11,366.60,'2023-01-04 11:45:20','',''),(2358,'1','302','1',1,'Retail Sale Id 2276',4496.96,0.00,0.00,6.11,366.60,'2023-01-04 11:52:47','',''),(2359,'1','302','1',1,'Retail Sale Id 2277',8000.32,0.00,0.00,10.87,652.20,'2023-01-04 11:55:55','',''),(2360,'1','302','1',1,'Retail Sale Id 2278',2502.40,0.00,0.00,3.40,204.00,'2023-01-04 11:56:40','',''),(2361,'1','302','1',1,'Retail Sale Id 2279',2208.00,0.00,0.00,3.00,180.00,'2023-01-04 12:00:28','',''),(2362,'1','302','1',1,'Retail Sale Id 2279',4416.00,0.00,0.00,6.00,360.00,'2023-01-04 12:00:28','',''),(2363,'1','302','1',1,'Retail Sale Id 2281',4496.96,0.00,0.00,6.11,366.60,'2023-01-04 12:05:57','',''),(2364,'1','302','1',1,'Retail Sale Id 2282',4416.00,0.00,0.00,6.00,360.00,'2023-01-04 12:08:10','',''),(2365,'1','302','1',1,'Retail Sale Id 2283',4416.00,0.00,0.00,6.00,360.00,'2023-01-04 12:12:46','',''),(2366,'1','302','1',1,'Retail Sale Id 2283',9200.00,0.00,0.00,12.50,750.00,'2023-01-04 12:12:46','',''),(2367,'1','302','1',1,'Retail Sale Id 2284',2001.92,0.00,0.00,2.72,163.20,'2023-01-04 12:14:21','',''),(2368,'1','302','1',1,'Retail Sale Id 2285',4496.96,0.00,0.00,6.11,366.60,'2023-01-04 12:15:32','',''),(2369,'1','302','1',1,'Retail Sale Id 2286',18400.00,0.00,0.00,25.00,1500.00,'2023-01-04 12:24:05','',''),(2370,'1','302','1',1,'Retail Sale Id 2287',1472.00,0.00,0.00,2.00,120.00,'2023-01-04 12:25:52','',''),(2371,'1','302','1',1,'Retail Sale Id 2289',4496.96,0.00,0.00,6.11,366.60,'2023-01-04 12:31:28','',''),(2372,'1','302','1',1,'Retail Sale Id 2290',3996.48,0.00,0.00,5.43,325.80,'2023-01-04 12:35:25','',''),(2373,'1','302','1',1,'Retail Sale Id 2291',4496.96,0.00,0.00,6.11,366.60,'2023-01-04 12:44:25','',''),(2374,'1','302','1',1,'Retail Sale Id 2292',3599.04,0.00,0.00,4.89,293.40,'2023-01-04 12:49:05','',''),(2375,'1','302','1',1,'Retail Sale Id 2293',4416.00,0.00,0.00,6.00,360.00,'2023-01-04 13:04:29','',''),(2376,'1','302','1',1,'Retail Sale Id 2294',14800.96,0.00,0.00,20.11,1206.60,'2023-01-04 13:12:03','',''),(2377,'1','302','1',1,'Retail Sale Id 2295',4496.96,0.00,0.00,6.11,366.60,'2023-01-04 13:18:07','',''),(2378,'1','302','1',1,'Retail Sale Id 2296',2944.00,0.00,0.00,4.00,240.00,'2023-01-04 13:26:39','',''),(2379,'1','302','1',1,'Retail Sale Id 2297',3680.00,0.00,0.00,5.00,300.00,'2023-01-04 13:39:25','',''),(2380,'1','302','1',1,'Retail Sale Id 2298',2208.00,0.00,0.00,3.00,180.00,'2023-01-04 13:47:36','',''),(2381,'1','302','1',1,'Retail Sale Id 2298',4416.00,0.00,0.00,6.00,360.00,'2023-01-04 13:47:36','',''),(2382,'1','302','1',1,'Retail Sale Id 2299',1501.44,0.00,0.00,2.04,122.40,'2023-01-04 13:57:40','',''),(2383,'1','302','1',1,'Retail Sale Id 2300',63900.00,0.00,0.00,90.00,3060.00,'2023-01-04 14:09:17','',''),(2384,'1','302','1',1,'Retail Sale Id 2301',2208.00,0.00,0.00,3.00,180.00,'2023-01-04 14:33:18','',''),(2385,'1','302','1',1,'Retail Sale Id 2302',4416.00,0.00,0.00,6.00,360.00,'2023-01-04 14:42:55','',''),(2386,'1','302','1',1,'Retail Sale Id 2302',9200.00,0.00,0.00,12.50,750.00,'2023-01-04 14:42:55','',''),(2387,'1','302','1',1,'Retail Sale Id 2303',9001.28,0.00,0.00,12.23,733.80,'2023-01-04 14:54:16','',''),(2388,'1','302','1',1,'Retail Sale Id 2304',2502.40,0.00,0.00,3.40,204.00,'2023-01-04 14:54:56','',''),(2389,'1','302','1',1,'Retail Sale Id 2305',4496.96,0.00,0.00,6.11,366.60,'2023-01-04 14:57:45','',''),(2390,'1','302','1',1,'Retail Sale Id 2306',5446.40,0.00,0.00,7.40,444.00,'2023-01-04 15:06:40','',''),(2391,'1','302','1',1,'Retail Sale Id 2307',3002.88,0.00,0.00,4.08,244.80,'2023-01-04 15:08:41','',''),(2392,'1','302','1',1,'Retail Sale Id 2308',2303.68,0.00,0.00,3.13,187.80,'2023-01-04 15:10:16','',''),(2393,'1','302','1',1,'Retail Sale Id 2309',2303.68,0.00,0.00,3.13,187.80,'2023-01-04 17:10:19','',''),(2394,'1','302','1',1,'Retail Sale Id 2310',1000.96,0.00,0.00,1.36,81.60,'2023-01-04 17:25:57','',''),(2395,'1','302','1',1,'Retail Sale Id 2310',2001.92,0.00,0.00,2.72,163.20,'2023-01-04 17:25:57','',''),(2396,'1','302','1',1,'Retail Sale Id 2311',2252.16,0.00,0.00,3.06,183.60,'2023-01-04 17:33:55','',''),(2397,'1','302','1',1,'Retail Sale Id 2312',3297.28,0.00,0.00,4.48,268.80,'2023-01-04 17:35:02','',''),(2398,'1','302','1',1,'Retail Sale Id 2313',3002.88,0.00,0.00,4.08,244.80,'2023-01-04 17:44:06','',''),(2399,'1','302','1',1,'Retail Sale Id 2314',1000.96,0.00,0.00,1.36,81.60,'2023-01-04 18:01:28','',''),(2400,'1','302','1',1,'Retail Sale Id 2315',1501.44,0.00,0.00,2.04,122.40,'2023-01-04 18:02:05','',''),(2401,'1','302','1',1,'Retail Sale Id 2316',4416.00,0.00,0.00,6.00,360.00,'2023-01-04 18:04:37','',''),(2402,'1','302','1',1,'Retail Sale Id 2317',1501.44,0.00,0.00,2.04,122.40,'2023-01-04 18:05:34','',''),(2403,'1','302','1',1,'Retail Sale Id 2318',3680.00,0.00,0.00,5.00,300.00,'2023-01-04 18:13:24','',''),(2404,'1','302','1',1,'Retail Sale Id 2318',3680.00,0.00,0.00,5.00,300.00,'2023-01-04 18:13:24','',''),(2405,'1','302','1',1,'Retail Sale Id 2319',2208.00,0.00,0.00,3.00,180.00,'2023-01-05 07:42:49','',''),(2406,'1','302','1',1,'Retail Sale Id 2320',1000.96,0.00,0.00,1.36,81.60,'2023-01-05 08:51:15','',''),(2407,'1','302','1',1,'Retail Sale Id 2321',9200.00,0.00,0.00,12.50,750.00,'2023-01-05 08:52:15','',''),(2408,'1','302','1',1,'Retail Sale Id 2322',9200.00,0.00,0.00,12.50,750.00,'2023-01-05 09:07:24','',''),(2409,'1','302','1',1,'Retail Sale Id 2323',9200.00,0.00,0.00,12.50,750.00,'2023-01-05 09:08:47','',''),(2410,'1','302','1',1,'Retail Sale Id 2324',736.00,0.00,0.00,1.00,60.00,'2023-01-05 09:21:47','',''),(2411,'1','302','1',1,'Retail Sale Id 2325',1000.96,0.00,0.00,1.36,81.60,'2023-01-05 09:37:48','',''),(2412,'1','302','1',1,'Retail Sale Id 2326',4416.00,0.00,0.00,6.00,360.00,'2023-01-05 09:40:25','',''),(2413,'1','302','1',1,'Retail Sale Id 2329',4416.00,0.00,0.00,6.00,360.00,'2023-01-05 09:46:18','',''),(2414,'1','302','1',1,'Retail Sale Id 2330',9001.28,0.00,0.00,12.23,733.80,'2023-01-05 09:47:45','',''),(2415,'1','302','1',1,'Retail Sale Id 2331',3680.00,0.00,0.00,5.00,300.00,'2023-01-05 09:55:32','',''),(2416,'1','302','1',1,'Retail Sale Id 2331',4416.00,0.00,0.00,6.00,360.00,'2023-01-05 09:55:32','',''),(2417,'1','302','1',1,'Retail Sale Id 2332',14720.00,0.00,0.00,20.00,1200.00,'2023-01-05 09:58:57','',''),(2418,'1','302','1',1,'Retail Sale Id 2333',4997.44,0.00,0.00,6.79,407.40,'2023-01-05 10:00:39','',''),(2419,'1','302','1',1,'Retail Sale Id 2334',802.24,0.00,0.00,1.09,65.40,'2023-01-05 10:01:56','',''),(2420,'1','302','1',1,'Retail Sale Id 2335',9200.00,0.00,0.00,12.50,750.00,'2023-01-05 10:07:20','',''),(2421,'1','302','1',1,'Retail Sale Id 2336',2200.64,0.00,0.00,2.99,179.40,'2023-01-05 10:17:44','',''),(2422,'1','302','1',1,'Retail Sale Id 2337',4416.00,0.00,0.00,6.00,360.00,'2023-01-05 10:19:48','',''),(2423,'1','302','1',1,'Retail Sale Id 2338',9200.00,0.00,0.00,12.50,750.00,'2023-01-05 10:32:36','',''),(2424,'1','302','1',1,'Retail Sale Id 2339',1472.00,0.00,0.00,2.00,120.00,'2023-01-05 10:34:03','',''),(2425,'1','302','1',1,'Retail Sale Id 2340',2001.92,0.00,0.00,2.72,163.20,'2023-01-05 10:53:32','',''),(2426,'1','302','1',1,'Retail Sale Id 2341',9200.00,0.00,0.00,12.50,750.00,'2023-01-05 10:55:39','',''),(2427,'1','302','1',1,'Retail Sale Id 2342',2701.12,0.00,0.00,3.67,220.20,'2023-01-05 11:00:21','',''),(2428,'1','302','1',1,'Retail Sale Id 2343',1000.96,0.00,0.00,1.36,81.60,'2023-01-05 11:02:52','',''),(2429,'1','302','1',1,'Retail Sale Id 2345',4997.44,0.00,0.00,6.79,407.40,'2023-01-05 11:07:16','',''),(2430,'1','302','1',1,'Retail Sale Id 2346',1501.44,0.00,0.00,2.04,122.40,'2023-01-05 11:09:01','',''),(2431,'1','302','1',1,'Retail Sale Id 2347',117150.00,0.00,0.00,165.00,5610.00,'2023-01-05 11:30:31','',''),(2432,'1','302','1',1,'Retail Sale Id 2348',9200.00,0.00,0.00,12.50,750.00,'2023-01-05 11:32:48','',''),(2433,'1','302','1',1,'Retail Sale Id 2349',1501.44,0.00,0.00,2.04,122.40,'2023-01-05 11:33:55','',''),(2434,'1','302','1',1,'Retail Sale Id 2350',1501.44,0.00,0.00,2.04,122.40,'2023-01-05 11:36:50','',''),(2435,'1','302','1',1,'Retail Sale Id 2351',1000.96,0.00,0.00,1.36,81.60,'2023-01-05 11:38:06','',''),(2436,'1','302','1',1,'Retail Sale Id 2352',4416.00,0.00,0.00,6.00,360.00,'2023-01-05 11:43:22','',''),(2437,'1','302','1',1,'Retail Sale Id 2352',9200.00,0.00,0.00,12.50,750.00,'2023-01-05 11:43:22','',''),(2438,'1','302','1',1,'Retail Sale Id 2352',9200.00,0.00,0.00,12.50,750.00,'2023-01-05 11:43:22','',''),(2439,'1','302','1',1,'Retail Sale Id 2353',1501.44,0.00,0.00,2.04,122.40,'2023-01-05 11:44:12','',''),(2440,'1','302','1',1,'Retail Sale Id 2354',736.00,0.00,0.00,1.00,60.00,'2023-01-05 11:51:11','',''),(2441,'1','302','1',1,'Retail Sale Id 2355',9200.00,0.00,0.00,12.50,750.00,'2023-01-05 11:52:58','',''),(2442,'1','302','1',1,'Retail Sale Id 2356',3996.48,0.00,0.00,5.43,325.80,'2023-01-05 12:05:36','',''),(2443,'1','302','1',1,'Retail Sale Id 2357',3503.36,0.00,0.00,4.76,285.60,'2023-01-05 12:09:03','',''),(2444,'1','302','1',1,'Retail Sale Id 2358',71000.00,0.00,0.00,100.00,3400.00,'2023-01-05 12:11:56','',''),(2445,'1','302','1',1,'Retail Sale Id 2359',4416.00,0.00,0.00,6.00,360.00,'2023-01-05 12:16:53','',''),(2446,'1','302','1',1,'Retail Sale Id 2359',9200.00,0.00,0.00,12.50,750.00,'2023-01-05 12:16:53','',''),(2447,'1','302','1',1,'Retail Sale Id 2360',4496.96,0.00,0.00,6.11,366.60,'2023-01-05 12:18:25','',''),(2448,'1','302','1',1,'Retail Sale Id 2361',4496.96,0.00,0.00,6.11,366.60,'2023-01-05 12:19:51','',''),(2449,'1','302','1',1,'Retail Sale Id 2362',736.00,0.00,0.00,1.00,60.00,'2023-01-05 12:20:54','',''),(2450,'1','302','1',1,'Retail Sale Id 2363',9200.00,0.00,0.00,12.50,750.00,'2023-01-05 12:35:20','',''),(2451,'1','302','1',1,'Retail Sale Id 2364',14720.00,0.00,0.00,20.00,1200.00,'2023-01-05 12:36:54','',''),(2452,'1','302','1',1,'Retail Sale Id 2365',1000.96,0.00,0.00,1.36,81.60,'2023-01-05 12:42:45','',''),(2453,'1','302','1',1,'Retail Sale Id 2366',18400.00,0.00,0.00,25.00,1500.00,'2023-01-05 12:44:39','',''),(2454,'1','302','1',1,'Retail Sale Id 2367',802.24,0.00,0.00,1.09,65.40,'2023-01-05 12:46:01','',''),(2455,'1','302','1',1,'Retail Sale Id 2368',2208.00,0.00,0.00,3.00,180.00,'2023-01-05 12:56:09','',''),(2456,'1','302','1',1,'Retail Sale Id 2369',2208.00,0.00,0.00,3.00,180.00,'2023-01-05 13:00:36','',''),(2457,'1','302','1',1,'Retail Sale Id 2370',4416.00,0.00,0.00,6.00,360.00,'2023-01-05 13:07:29','',''),(2458,'1','302','1',1,'Retail Sale Id 2371',2200.64,0.00,0.00,2.99,179.40,'2023-01-05 13:08:41','',''),(2459,'1','302','1',1,'Retail Sale Id 2372',2208.00,0.00,0.00,3.00,180.00,'2023-01-05 13:13:27','',''),(2460,'1','302','1',1,'Retail Sale Id 2373',1472.00,0.00,0.00,2.00,120.00,'2023-01-05 13:14:42','',''),(2461,'1','302','1',1,'Retail Sale Id 2374',802.24,0.00,0.00,1.09,65.40,'2023-01-05 13:15:49','',''),(2462,'1','302','1',1,'Retail Sale Id 2375',2208.00,0.00,0.00,3.00,180.00,'2023-01-05 13:17:27','',''),(2463,'1','302','1',1,'Retail Sale Id 2376',5888.00,0.00,0.00,8.00,480.00,'2023-01-05 13:22:26','',''),(2464,'1','302','1',1,'Retail Sale Id 2377',7360.00,0.00,0.00,10.00,600.00,'2023-01-05 13:38:30','',''),(2465,'1','302','1',1,'Retail Sale Id 2378',2208.00,0.00,0.00,3.00,180.00,'2023-01-05 13:41:05','',''),(2466,'1','302','1',1,'Retail Sale Id 2379',2208.00,0.00,0.00,3.00,180.00,'2023-01-05 13:42:27','',''),(2467,'1','302','1',1,'Retail Sale Id 2380',4416.00,0.00,0.00,6.00,360.00,'2023-01-05 13:43:46','',''),(2468,'1','302','1',1,'Retail Sale Id 2381',9200.00,0.00,0.00,12.50,750.00,'2023-01-05 13:56:04','',''),(2469,'1','302','1',1,'Retail Sale Id 2382',2208.00,0.00,0.00,3.00,180.00,'2023-01-05 14:12:46','',''),(2470,'1','302','1',1,'Retail Sale Id 2383',9200.00,0.00,0.00,12.50,750.00,'2023-01-05 14:15:23','',''),(2471,'1','302','1',1,'Retail Sale Id 2384',4416.00,0.00,0.00,6.00,360.00,'2023-01-05 14:21:48','',''),(2472,'1','302','1',1,'Retail Sale Id 2385',4496.96,0.00,0.00,6.11,366.60,'2023-01-05 14:22:49','',''),(2473,'1','302','1',1,'Retail Sale Id 2386',2252.16,0.00,0.00,3.06,183.60,'2023-01-05 14:34:02','',''),(2474,'1','302','1',1,'Retail Sale Id 2386',2252.16,0.00,0.00,3.06,183.60,'2023-01-05 14:34:02','',''),(2475,'1','302','1',1,'Retail Sale Id 2387',2502.40,0.00,0.00,3.40,204.00,'2023-01-05 14:53:01','',''),(2476,'1','302','1',1,'Retail Sale Id 2388',3702.08,0.00,0.00,5.03,301.80,'2023-01-05 14:58:32','',''),(2477,'1','302','1',1,'Retail Sale Id 2389',7360.00,0.00,0.00,10.00,600.00,'2023-01-05 15:15:49','',''),(2478,'1','302','1',1,'Retail Sale Id 2390',3002.88,0.00,0.00,4.08,244.80,'2023-01-05 15:20:13','',''),(2479,'1','302','1',1,'Retail Sale Id 2391',4416.00,0.00,0.00,6.00,360.00,'2023-01-05 15:30:11','',''),(2480,'1','302','1',1,'Retail Sale Id 2392',3996.48,0.00,0.00,5.43,325.80,'2023-01-05 15:34:15','',''),(2481,'1','302','1',1,'Retail Sale Id 2392',3996.48,0.00,0.00,5.43,325.80,'2023-01-05 15:34:15','',''),(2482,'1','302','1',1,'Retail Sale Id 2393',2208.00,0.00,0.00,3.00,180.00,'2023-01-05 15:36:01','',''),(2483,'1','302','1',1,'Retail Sale Id 2394',2208.00,0.00,0.00,3.00,180.00,'2023-01-05 15:40:00','',''),(2484,'1','302','1',1,'Retail Sale Id 2395',11040.00,0.00,0.00,15.00,900.00,'2023-01-05 15:41:31','',''),(2485,'1','302','1',1,'Retail Sale Id 2396',1472.00,0.00,0.00,2.00,120.00,'2023-01-05 15:42:49','',''),(2486,'1','302','1',1,'Retail Sale Id 2397',9200.00,0.00,0.00,12.50,750.00,'2023-01-05 15:50:52','',''),(2487,'1','302','1',1,'Retail Sale Id 2398',35500.00,0.00,0.00,50.00,1700.00,'2023-01-05 16:09:06','',''),(2488,'1','302','1',1,'Retail Sale Id 2399',9501.76,0.00,0.00,12.91,774.60,'2023-01-05 16:18:13','',''),(2489,'1','302','1',1,'Retail Sale Id 2400',1501.44,0.00,0.00,2.04,122.40,'2023-01-05 16:19:12','',''),(2490,'1','302','1',1,'Retail Sale Id 2401',3702.08,0.00,0.00,5.03,301.80,'2023-01-05 16:32:06','',''),(2491,'1','302','1',1,'Retail Sale Id 2402',4416.00,0.00,0.00,6.00,360.00,'2023-01-05 16:39:57','',''),(2492,'1','302','1',1,'Retail Sale Id 2403',1472.00,0.00,0.00,2.00,120.00,'2023-01-05 16:51:24','',''),(2493,'1','302','1',1,'Retail Sale Id 2404',71000.00,0.00,0.00,100.00,3400.00,'2023-01-05 17:15:06','',''),(2494,'1','302','1',1,'Retail Sale Id 2405',4401.28,0.00,0.00,5.98,358.80,'2023-01-05 17:19:32','',''),(2495,'1','302','1',1,'Retail Sale Id 2406',2001.92,0.00,0.00,2.72,163.20,'2023-01-05 17:20:32','',''),(2496,'1','302','1',1,'Retail Sale Id 2407',3680.00,0.00,0.00,5.00,300.00,'2023-01-05 17:21:43','',''),(2497,'1','302','1',1,'Retail Sale Id 2408',4496.96,0.00,0.00,6.11,366.60,'2023-01-05 17:29:44','',''),(2498,'1','302','1',1,'Retail Sale Id 2409',736.00,0.00,0.00,1.00,60.00,'2023-01-05 17:39:03','',''),(2499,'1','302','1',1,'Retail Sale Id 2410',2001.92,0.00,0.00,2.72,163.20,'2023-01-05 17:55:54','',''),(2500,'1','302','1',1,'Retail Sale Id 2411',4997.44,0.00,0.00,6.79,407.40,'2023-01-05 17:57:05','',''),(2501,'1','302','1',1,'Retail Sale Id 2412',1000.96,0.00,0.00,1.36,81.60,'2023-01-05 17:58:28','',''),(2502,'1','302','1',1,'Retail Sale Id 2413',9200.00,0.00,0.00,12.50,750.00,'2023-01-05 17:59:26','',''),(2503,'1','302','1',1,'Retail Sale Id 2414',17750.00,0.00,0.00,25.00,850.00,'2023-01-05 18:01:07','',''),(2504,'1','302','1',1,'Retail Sale Id 2415',1501.44,0.00,0.00,2.04,122.40,'2023-01-05 18:02:32','',''),(2505,'1','302','1',1,'Retail Sale Id 2416',1000.96,0.00,0.00,1.36,81.60,'2023-01-05 18:04:30','',''),(2506,'1','302','1',1,'Retail Sale Id 2417',1472.00,0.00,0.00,2.00,120.00,'2023-01-05 18:11:39','',''),(2507,'1','302','1',1,'Retail Sale Id 2418',4416.00,0.00,0.00,6.00,360.00,'2023-01-05 18:13:21','',''),(2508,'1','302','1',1,'Retail Sale Id 2419',29.44,0.00,0.00,0.04,2.40,'2023-01-05 18:50:41','',''),(2509,'1','302','1',1,'Retail Sale Id 2420',8875.00,0.00,0.00,12.50,425.00,'2023-01-05 18:55:23','',''),(2510,'1','302','1',1,'Retail Sale Id 2421',3503.36,0.00,0.00,4.76,285.60,'2023-01-06 08:11:17','',''),(2511,'1','302','1',1,'Retail Sale Id 2422',2303.68,0.00,0.00,3.13,187.80,'2023-01-06 08:12:47','',''),(2512,'1','302','1',1,'Retail Sale Id 2423',3996.48,0.00,0.00,5.43,325.80,'2023-01-06 08:13:40','',''),(2513,'1','302','1',1,'Retail Sale Id 2424',4496.96,0.00,0.00,6.11,366.60,'2023-01-06 08:14:39','',''),(2514,'1','302','1',1,'Retail Sale Id 2425',4496.96,0.00,0.00,6.11,366.60,'2023-01-06 08:24:06','',''),(2515,'1','302','1',1,'Retail Sale Id 2426',1501.44,0.00,0.00,2.04,122.40,'2023-01-06 08:33:51','',''),(2516,'1','302','1',1,'Retail Sale Id 2427',3996.48,0.00,0.00,5.43,325.80,'2023-01-06 08:36:59','',''),(2517,'1','302','1',1,'Retail Sale Id 2428',2944.00,0.00,0.00,4.00,240.00,'2023-01-06 09:05:38','',''),(2518,'1','302','1',1,'Retail Sale Id 2428',2944.00,0.00,0.00,4.00,240.00,'2023-01-06 09:05:38','',''),(2519,'1','302','1',1,'Retail Sale Id 2428',3312.00,0.00,0.00,4.50,270.00,'2023-01-06 09:05:38','',''),(2520,'1','302','1',1,'Retail Sale Id 2429',4423.36,0.00,0.00,6.01,360.60,'2023-01-06 09:13:37','',''),(2521,'1','302','1',1,'Retail Sale Id 2431',1898.88,0.00,0.00,2.58,154.80,'2023-01-06 09:15:44','',''),(2522,'1','302','1',1,'Retail Sale Id 2432',1501.44,0.00,0.00,2.04,122.40,'2023-01-06 09:24:04','',''),(2523,'1','302','1',1,'Retail Sale Id 2433',1501.44,0.00,0.00,2.04,122.40,'2023-01-06 09:43:19','',''),(2524,'1','302','1',1,'Retail Sale Id 2434',2208.00,0.00,0.00,3.00,180.00,'2023-01-06 09:47:46','',''),(2525,'1','302','1',1,'Retail Sale Id 2435',4423.36,0.00,0.00,6.01,360.60,'2023-01-06 09:48:56','',''),(2526,'1','302','1',1,'Retail Sale Id 2436',3002.88,0.00,0.00,4.08,244.80,'2023-01-06 09:52:01','',''),(2527,'1','302','1',1,'Retail Sale Id 2436',3002.88,0.00,0.00,4.08,244.80,'2023-01-06 09:52:01','',''),(2528,'1','302','1',1,'Retail Sale Id 2436',3002.88,0.00,0.00,4.08,244.80,'2023-01-06 09:52:01','',''),(2529,'1','302','1',1,'Retail Sale Id 2437',3797.76,0.00,0.00,5.16,309.60,'2023-01-06 09:54:26','',''),(2530,'1','302','1',1,'Retail Sale Id 2438',35500.00,0.00,0.00,50.00,1700.00,'2023-01-06 09:59:07','',''),(2531,'1','302','1',1,'Retail Sale Id 2439',9200.00,0.00,0.00,12.50,750.00,'2023-01-06 10:00:52','',''),(2532,'1','302','1',1,'Retail Sale Id 2440',9200.00,0.00,0.00,12.50,750.00,'2023-01-06 10:11:03','',''),(2533,'1','302','1',1,'Retail Sale Id 2442',3680.00,0.00,0.00,5.00,300.00,'2023-01-06 10:18:02','',''),(2534,'1','302','1',1,'Retail Sale Id 2443',4423.36,0.00,0.00,6.01,360.60,'2023-01-06 10:19:57','',''),(2535,'1','302','1',1,'Retail Sale Id 2444',2001.92,0.00,0.00,2.72,163.20,'2023-01-06 10:27:38','',''),(2536,'1','302','1',1,'Retail Sale Id 2445',4496.96,0.00,0.00,6.11,366.60,'2023-01-06 10:35:37','',''),(2537,'1','302','1',1,'Retail Sale Id 2446',9200.00,0.00,0.00,12.50,750.00,'2023-01-06 10:44:21','',''),(2538,'1','302','1',1,'Retail Sale Id 2447',15620.00,0.00,0.00,22.00,748.00,'2023-01-06 10:47:08','',''),(2539,'1','302','1',1,'Retail Sale Id 2448',3503.36,0.00,0.00,4.76,285.60,'2023-01-06 11:03:10','',''),(2540,'1','302','1',1,'Retail Sale Id 2450',743.36,0.00,0.00,1.01,60.60,'2023-01-06 11:15:08','',''),(2541,'1','302','1',1,'Retail Sale Id 2452',2951.36,0.00,0.00,4.01,240.60,'2023-01-06 11:18:30','',''),(2542,'1','302','1',1,'Retail Sale Id 2453',3599.04,0.00,0.00,4.89,293.40,'2023-01-06 11:24:47','',''),(2543,'1','302','1',1,'Retail Sale Id 2454',1501.44,0.00,0.00,2.04,122.40,'2023-01-06 11:30:12','',''),(2544,'1','302','1',1,'Retail Sale Id 2455',9200.00,0.00,0.00,12.50,750.00,'2023-01-06 11:37:29','',''),(2545,'1','302','1',1,'Retail Sale Id 2456',3680.00,0.00,0.00,5.00,300.00,'2023-01-06 11:38:29','',''),(2546,'1','302','1',1,'Retail Sale Id 2457',2208.00,0.00,0.00,3.00,180.00,'2023-01-06 11:40:06','',''),(2547,'1','302','1',1,'Retail Sale Id 2458',9200.00,0.00,0.00,12.50,750.00,'2023-01-06 11:45:28','',''),(2548,'1','302','1',1,'Retail Sale Id 2459',3002.88,0.00,0.00,4.08,244.80,'2023-01-06 11:48:10','',''),(2549,'1','302','1',1,'Retail Sale Id 2460',7352.64,0.00,0.00,9.99,599.40,'2023-01-06 11:52:07','',''),(2550,'1','302','1',1,'Retail Sale Id 2461',2208.00,0.00,0.00,3.00,180.00,'2023-01-06 11:53:39','',''),(2551,'1','302','1',1,'Retail Sale Id 2462',2001.92,0.00,0.00,2.72,163.20,'2023-01-06 11:54:33','',''),(2552,'1','302','1',1,'Retail Sale Id 2463',4416.00,0.00,0.00,6.00,360.00,'2023-01-06 12:01:39','',''),(2553,'1','302','1',1,'Retail Sale Id 2465',9200.00,0.00,0.00,12.50,750.00,'2023-01-06 12:03:45','',''),(2554,'1','302','1',1,'Retail Sale Id 2466',4416.00,0.00,0.00,6.00,360.00,'2023-01-06 12:12:30','',''),(2555,'1','302','1',1,'Retail Sale Id 2467',1000.96,0.00,0.00,1.36,81.60,'2023-01-06 12:14:03','',''),(2556,'1','302','1',1,'Retail Sale Id 2468',9200.00,0.00,0.00,12.50,750.00,'2023-01-06 12:15:31','',''),(2557,'1','302','1',1,'Retail Sale Id 2469',2208.00,0.00,0.00,3.00,180.00,'2023-01-06 12:19:34','',''),(2558,'1','302','1',1,'Retail Sale Id 2469',9200.00,0.00,0.00,12.50,750.00,'2023-01-06 12:19:34','',''),(2559,'1','302','1',1,'Retail Sale Id 2470',4496.96,0.00,0.00,6.11,366.60,'2023-01-06 12:23:01','',''),(2560,'1','302','1',1,'Retail Sale Id 2471',4423.36,0.00,0.00,6.01,360.60,'2023-01-06 12:40:47','',''),(2561,'1','302','1',1,'Retail Sale Id 2472',2399.36,0.00,0.00,3.26,195.60,'2023-01-06 13:27:09','',''),(2562,'1','302','1',1,'Retail Sale Id 2474',3680.00,0.00,0.00,5.00,300.00,'2023-01-06 13:32:22','',''),(2563,'1','302','1',1,'Retail Sale Id 2475',4496.96,0.00,0.00,6.11,366.60,'2023-01-06 13:48:42','',''),(2564,'1','302','1',1,'Retail Sale Id 2476',4401.28,0.00,0.00,5.98,358.80,'2023-01-06 13:57:41','',''),(2565,'1','302','1',1,'Retail Sale Id 2477',9001.28,0.00,0.00,12.23,733.80,'2023-01-06 14:01:05','',''),(2566,'1','302','1',1,'Retail Sale Id 2478',1501.44,0.00,0.00,2.04,122.40,'2023-01-06 14:16:24','',''),(2567,'1','302','1',1,'Retail Sale Id 2479',802.24,0.00,0.00,1.09,65.40,'2023-01-06 14:40:34','',''),(2568,'1','302','1',1,'Retail Sale Id 2481',2281.60,0.00,0.00,3.10,186.00,'2023-01-06 14:46:49','',''),(2569,'1','302','1',1,'Retail Sale Id 2481',4416.00,0.00,0.00,6.00,360.00,'2023-01-06 14:46:49','',''),(2570,'1','302','1',1,'Retail Sale Id 2482',2208.00,0.00,0.00,3.00,180.00,'2023-01-06 14:47:45','',''),(2571,'1','302','1',1,'Retail Sale Id 2483',2252.16,0.00,0.00,3.06,183.60,'2023-01-06 14:49:26','',''),(2572,'1','302','1',1,'Retail Sale Id 2484',9200.00,0.00,0.00,12.50,750.00,'2023-01-06 14:53:39','',''),(2573,'1','302','1',1,'Retail Sale Id 2485',9200.00,0.00,0.00,12.50,750.00,'2023-01-06 14:58:53','',''),(2574,'1','302','1',1,'Retail Sale Id 2486',2944.00,0.00,0.00,4.00,240.00,'2023-01-06 15:00:26','',''),(2575,'1','302','1',1,'Retail Sale Id 2487',1000.96,0.00,0.00,1.36,81.60,'2023-01-06 15:01:43','',''),(2576,'1','302','1',1,'Retail Sale Id 2488',1501.44,0.00,0.00,2.04,122.40,'2023-01-06 15:05:31','',''),(2577,'1','302','1',1,'Retail Sale Id 2489',699.20,0.00,0.00,0.95,57.00,'2023-01-06 15:10:06','',''),(2578,'1','302','1',1,'Retail Sale Id 2489',2303.68,0.00,0.00,3.13,187.80,'2023-01-06 15:10:06','',''),(2579,'1','302','1',1,'Retail Sale Id 2490',5152.00,0.00,0.00,7.00,420.00,'2023-01-06 15:16:08','',''),(2580,'1','302','1',1,'Retail Sale Id 2491',2001.92,0.00,0.00,2.72,163.20,'2023-01-06 15:28:12','',''),(2581,'1','302','1',1,'Retail Sale Id 2492',35500.00,0.00,0.00,50.00,1700.00,'2023-01-06 15:38:51','',''),(2582,'1','302','1',1,'Retail Sale Id 2493',2001.92,0.00,0.00,2.72,163.20,'2023-01-06 15:49:22','',''),(2583,'1','302','1',1,'Retail Sale Id 2494',4416.00,0.00,0.00,6.00,360.00,'2023-01-06 15:52:05','',''),(2584,'1','302','1',1,'Retail Sale Id 2495',3550.00,0.00,0.00,5.00,170.00,'2023-01-06 15:54:55','',''),(2585,'1','302','1',1,'Retail Sale Id 2496',4452.80,0.00,0.00,6.05,363.00,'2023-01-06 16:07:16','',''),(2586,'1','302','1',1,'Retail Sale Id 2497',3680.00,0.00,0.00,5.00,300.00,'2023-01-06 16:13:46','',''),(2587,'1','302','1',1,'Retail Sale Id 2498',2001.92,0.00,0.00,2.72,163.20,'2023-01-06 16:30:48','',''),(2588,'1','302','1',1,'Retail Sale Id 2498',3002.88,0.00,0.00,4.08,244.80,'2023-01-06 16:30:48','',''),(2589,'1','302','1',1,'Retail Sale Id 2499',2001.92,0.00,0.00,2.72,163.20,'2023-01-06 16:40:05','',''),(2590,'1','302','1',1,'Retail Sale Id 2500',2252.16,0.00,0.00,3.06,183.60,'2023-01-06 16:43:41','',''),(2591,'1','302','1',1,'Retail Sale Id 2501',3702.08,0.00,0.00,5.03,301.80,'2023-01-06 16:48:31','',''),(2592,'1','302','1',1,'Retail Sale Id 2502',2001.92,0.00,0.00,2.72,163.20,'2023-01-06 16:54:37','',''),(2593,'1','302','1',1,'Retail Sale Id 2503',3002.88,0.00,0.00,4.08,244.80,'2023-01-06 16:56:28','',''),(2594,'1','302','1',1,'Retail Sale Id 2504',36800.00,0.00,0.00,50.00,3000.00,'2023-01-06 16:59:29','',''),(2595,'1','302','1',1,'Retail Sale Id 2505',2222.72,0.00,0.00,3.02,181.20,'2023-01-06 17:24:47','',''),(2596,'1','302','1',1,'Retail Sale Id 2506',2001.92,0.00,0.00,2.72,163.20,'2023-01-06 17:25:59','',''),(2597,'1','302','1',1,'Retail Sale Id 2507',4416.00,0.00,0.00,6.00,360.00,'2023-01-06 17:41:00','',''),(2598,'1','302','1',1,'Retail Sale Id 2507',4416.00,0.00,0.00,6.00,360.00,'2023-01-06 17:41:00','',''),(2599,'1','302','1',1,'Retail Sale Id 2508',4496.96,0.00,0.00,6.11,366.60,'2023-01-06 17:53:22','',''),(2600,'1','302','1',1,'Retail Sale Id 2509',1302.72,0.00,0.00,1.77,106.20,'2023-01-06 18:12:15','',''),(2601,'1','302','1',1,'Retail Sale Id 2510',6697.60,0.00,0.00,9.10,546.00,'2023-01-06 18:13:57','',''),(2602,'1','302','1',1,'Retail Sale Id 2511',2130.00,0.00,0.00,3.00,102.00,'2023-01-06 18:15:45','',''),(2603,'1','302','1',1,'Return of Retail Sale Id 2507',0.00,4416.00,6.00,0.00,-360.00,'2023-01-06 18:42:17','',''),(2604,'1','302','1',1,'Return of Retail Sale Id 2507',0.00,4416.00,6.00,0.00,-360.00,'2023-01-06 18:42:17','',''),(2605,'1','302','1',1,'Retail Sale Id 2512',897.92,0.00,0.00,1.22,73.20,'2023-01-06 18:44:17','',''),(2606,'1','302','1',1,'Retail Sale Id 2513',7767.40,0.00,0.00,10.94,371.96,'2023-01-06 18:48:30','',''),(2607,'1','302','1',1,'Retail Sale Id 2514',1000.96,0.00,0.00,1.36,81.60,'2023-01-07 07:23:33','',''),(2608,'1','302','1',1,'Retail Sale Id 2515',4496.96,0.00,0.00,6.11,366.60,'2023-01-07 07:34:06','',''),(2609,'1','302','1',1,'Retail Sale Id 2516',9200.00,0.00,0.00,12.50,750.00,'2023-01-07 07:40:33','',''),(2610,'1','302','1',1,'Retail Sale Id 2517',2208.00,0.00,0.00,3.00,180.00,'2023-01-07 08:05:33','',''),(2611,'1','302','1',1,'Retail Sale Id 2518',9200.00,0.00,0.00,12.50,750.00,'2023-01-07 08:09:52','',''),(2612,'1','302','1',1,'Retail Sale Id 2519',2208.00,0.00,0.00,3.00,180.00,'2023-01-07 08:16:03','',''),(2613,'1','302','1',1,'Retail Sale Id 2520',4416.00,0.00,0.00,6.00,360.00,'2023-01-07 08:24:15','',''),(2614,'1','302','1',1,'Retail Sale Id 2521',1803.20,0.00,0.00,2.45,147.00,'2023-01-07 08:25:11','',''),(2615,'1','302','1',1,'Retail Sale Id 2522',3002.88,0.00,0.00,4.08,244.80,'2023-01-07 08:37:29','',''),(2616,'1','302','1',1,'Retail Sale Id 2523',4496.96,0.00,0.00,6.11,366.60,'2023-01-07 08:40:53','',''),(2617,'1','302','1',1,'Retail Sale Id 2524',35003.00,0.00,0.00,49.30,1676.20,'2023-01-07 08:53:23','',''),(2618,'1','302','1',1,'Retail Sale Id 2525',2208.00,0.00,0.00,3.00,180.00,'2023-01-07 08:56:20','',''),(2619,'1','302','1',1,'Return of Retail Sale Id 2525',0.00,2208.00,3.00,0.00,-180.00,'2023-01-07 15:02:48','',''),(2620,'1','302','1',1,'Return of Retail Sale Id 2524',0.00,35003.00,49.30,0.00,-1676.20,'2023-01-07 15:03:59','',''),(2621,'1','302','1',1,'Retail Sale Id 2526',11686.60,0.00,0.00,16.46,559.64,'2023-01-07 19:43:30','',''),(2622,'1','302','1',1,'Retail Sale Id 2527',44.16,0.00,0.00,0.06,3.60,'2023-01-07 19:46:43','',''),(2623,'1','302','1',1,'Return of Retail Sale Id 2527',0.00,44.16,0.06,0.00,-3.60,'2023-01-07 19:49:24','',''),(2624,'1','302','1',1,'Retail Sale Id 2528',36.80,0.00,0.00,0.05,3.00,'2023-01-07 19:51:24','',''),(2625,'1','302','1',1,'Retail Sale Id 2529',6390.00,0.00,0.00,9.00,306.00,'2023-01-08 13:35:16','',''),(2626,'1','302','1',1,'Retail Sale Id 2530',7360.00,0.00,0.00,10.00,600.00,'2023-01-08 13:37:18','',''),(2627,'1','302','1',1,'Retail Sale Id 2531',7360.00,0.00,0.00,10.00,600.00,'2023-01-08 13:40:45','',''),(2628,'1','302','1',1,'Retail Sale Id 2532',4416.00,0.00,0.00,6.00,360.00,'2023-01-08 13:43:01','',''),(2629,'1','302','1',1,'Retail Sale Id 2533',1501.44,0.00,0.00,2.04,122.40,'2023-01-08 13:48:37','',''),(2630,'1','302','1',1,'Retail Sale Id 2534',3002.88,0.00,0.00,4.08,244.80,'2023-01-08 13:49:27','',''),(2631,'1','302','1',1,'Retail Sale Id 2535',1000.96,0.00,0.00,1.36,81.60,'2023-01-08 13:50:11','',''),(2632,'1','302','1',1,'Retail Sale Id 2536',2001.92,0.00,0.00,2.72,163.20,'2023-01-08 13:51:04','',''),(2633,'1','302','1',1,'Retail Sale Id 2537',6999.36,0.00,0.00,9.51,570.60,'2023-01-08 13:51:55','',''),(2634,'1','302','1',1,'Retail Sale Id 2538',3680.00,0.00,0.00,5.00,300.00,'2023-01-08 13:55:41','',''),(2635,'1','302','1',1,'Retail Sale Id 2539',3680.00,0.00,0.00,5.00,300.00,'2023-01-08 13:56:33','',''),(2636,'1','302','1',1,'Retail Sale Id 2540',4430.72,0.00,0.00,6.02,361.20,'2023-01-08 14:04:01','',''),(2637,'1','302','1',1,'Retail Sale Id 2541',9230.00,0.00,0.00,13.00,442.00,'2023-01-08 14:04:59','',''),(2638,'1','302','1',1,'Retail Sale Id 2542',1398.40,0.00,0.00,1.90,114.00,'2023-01-08 14:08:04','',''),(2639,'1','302','1',1,'Retail Sale Id 2543',1501.44,0.00,0.00,2.04,122.40,'2023-01-08 14:10:37','',''),(2640,'1','302','1',1,'Retail Sale Id 2543',1501.44,0.00,0.00,2.04,122.40,'2023-01-08 14:10:37','',''),(2641,'1','302','1',1,'Retail Sale Id 2544',9200.00,0.00,0.00,12.50,750.00,'2023-01-08 14:19:31','',''),(2642,'1','302','1',1,'Retail Sale Id 2545',88750.00,0.00,0.00,125.00,4250.00,'2023-01-08 14:24:29','',''),(2643,'1','302','1',1,'Retail Sale Id 2546',2303.68,0.00,0.00,3.13,187.80,'2023-01-08 14:28:11','',''),(2644,'1','302','1',1,'Retail Sale Id 2547',1000.96,0.00,0.00,1.36,81.60,'2023-01-08 14:31:38','',''),(2645,'1','302','1',1,'Retail Sale Id 2548',4496.96,0.00,0.00,6.11,366.60,'2023-01-08 14:39:20','',''),(2646,'1','302','1',1,'Retail Sale Id 2549',3002.88,0.00,0.00,4.08,244.80,'2023-01-08 14:43:05','',''),(2647,'1','302','1',1,'Retail Sale Id 2550',3996.48,0.00,0.00,5.43,325.80,'2023-01-08 14:46:01','',''),(2648,'1','302','1',1,'Retail Sale Id 2551',1000.96,0.00,0.00,1.36,81.60,'2023-01-08 14:51:30','',''),(2649,'1','302','1',1,'Retail Sale Id 2552',1420.00,0.00,0.00,2.00,68.00,'2023-01-08 14:56:54','',''),(2650,'1','302','1',1,'Retail Sale Id 2553',2303.68,0.00,0.00,3.13,187.80,'2023-01-08 15:04:16','',''),(2651,'1','302','1',1,'Retail Sale Id 2554',3503.36,0.00,0.00,4.76,285.60,'2023-01-08 15:05:01','',''),(2652,'1','302','1',1,'Retail Sale Id 2555',2208.00,0.00,0.00,3.00,180.00,'2023-01-08 15:12:46','',''),(2653,'1','302','1',1,'Retail Sale Id 2556',4416.00,0.00,0.00,6.00,360.00,'2023-01-08 15:20:51','',''),(2654,'1','302','1',1,'Retail Sale Id 2556',4416.00,0.00,0.00,6.00,360.00,'2023-01-08 15:20:51','',''),(2655,'1','302','1',1,'Retail Sale Id 2557',3002.88,0.00,0.00,4.08,244.80,'2023-01-08 15:23:10','',''),(2656,'1','302','1',1,'Retail Sale Id 2558',9200.00,0.00,0.00,12.50,750.00,'2023-01-08 15:25:45','',''),(2657,'1','302','1',1,'Retail Sale Id 2559',4997.44,0.00,0.00,6.79,407.40,'2023-01-08 15:26:26','',''),(2658,'1','302','1',1,'Retail Sale Id 2560',1501.44,0.00,0.00,2.04,122.40,'2023-01-08 15:32:33','',''),(2659,'1','302','1',1,'Retail Sale Id 2562',1000.96,0.00,0.00,1.36,81.60,'2023-01-08 15:39:36','',''),(2660,'1','302','1',1,'Retail Sale Id 2563',3702.08,0.00,0.00,5.03,301.80,'2023-01-08 15:41:26','',''),(2661,'1','302','1',1,'Retail Sale Id 2564',2303.68,0.00,0.00,3.13,187.80,'2023-01-08 15:52:18','',''),(2662,'1','302','1',1,'Retail Sale Id 2565',603.52,0.00,0.00,0.82,49.20,'2023-01-08 15:55:07','',''),(2663,'1','302','1',1,'Retail Sale Id 2566',1501.44,0.00,0.00,2.04,122.40,'2023-01-08 15:57:25','',''),(2664,'1','302','1',1,'Retail Sale Id 2566',2222.72,0.00,0.00,3.02,181.20,'2023-01-08 15:57:25','',''),(2665,'1','302','1',1,'Retail Sale Id 2567',4416.00,0.00,0.00,6.00,360.00,'2023-01-08 15:58:55','',''),(2666,'1','302','1',1,'Retail Sale Id 2568',2200.64,0.00,0.00,2.99,179.40,'2023-01-08 16:00:17','',''),(2667,'1','302','1',1,'Retail Sale Id 2569',3002.88,0.00,0.00,4.08,244.80,'2023-01-08 16:18:46','',''),(2668,'1','302','1',1,'Retail Sale Id 2571',2745.28,0.00,0.00,3.73,223.80,'2023-01-08 16:30:06','',''),(2669,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,301252.64,445.64,0.00,0.00,'2023-01-08 19:46:28','',''),(2670,'1','302',NULL,1,'Reception corrector for bridging 14',0.00,0.00,0.00,445.64,0.00,'2023-01-08 19:48:40','',''),(2671,'1','302','1',1,'Received from bridging 14',0.00,0.00,445.64,0.00,0.00,'2023-01-08 19:48:40','',''),(2672,'1','302','1',1,'Retail Sale Id 2572',305808.00,0.00,0.00,415.50,24930.00,'2023-01-08 19:51:01','',''),(2673,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3380.00,5.00,0.00,0.00,'2023-01-08 19:58:15','',''),(2674,'1','302',NULL,1,'Reception corrector for bridging 15',0.00,0.00,0.00,5.00,0.00,'2023-01-08 19:59:48','',''),(2675,'1','302','1',1,'Received from bridging 15',0.00,0.00,5.00,0.00,0.00,'2023-01-08 19:59:48','',''),(2676,'1','302','1',1,'Retail Sale Id 2574',24949.40,0.00,0.00,35.14,1194.76,'2023-01-08 20:01:37','',''),(2677,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,23619.44,34.94,0.00,0.00,'2023-01-08 20:46:42','',''),(2678,'1','302',NULL,1,'Reception corrector for bridging 16',0.00,0.00,0.00,34.94,0.00,'2023-01-08 20:48:14','',''),(2679,'1','302','1',1,'Received from bridging 16',0.00,0.00,34.94,0.00,0.00,'2023-01-08 20:48:14','',''),(2680,'1','302','1',1,'Retail Sale Id 2575',25715.84,0.00,0.00,34.94,2096.40,'2023-01-08 20:49:52','',''),(2681,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3515200.00,5200.00,0.00,0.00,'2023-01-08 21:45:06','',''),(2682,'1','302',NULL,1,'Reception corrector for bridging 17',0.00,0.00,0.00,5200.00,0.00,'2023-01-08 21:55:33','',''),(2683,'1','302','1',1,'Received from bridging 17',0.00,0.00,5200.00,0.00,0.00,'2023-01-08 21:55:33','',''),(2684,'1','302','1',1,'Retail Sale Id 2576',9200.00,0.00,0.00,12.50,750.00,'2023-01-09 08:07:33','',''),(2685,'1','302','1',1,'Retail Sale Id 2577',9200.00,0.00,0.00,12.50,750.00,'2023-01-09 08:18:11','',''),(2686,'1','302','1',1,'Retail Sale Id 2578',4496.96,0.00,0.00,6.11,366.60,'2023-01-09 08:20:24','',''),(2687,'1','302','1',1,'Retail Sale Id 2579',4997.44,0.00,0.00,6.79,407.40,'2023-01-09 08:22:58','',''),(2688,'1','302','1',1,'Retail Sale Id 2580',9501.76,0.00,0.00,12.91,774.60,'2023-01-09 08:26:32','',''),(2689,'1','302','1',1,'Retail Sale Id 2581',2001.92,0.00,0.00,2.72,163.20,'2023-01-09 08:32:50','',''),(2690,'1','302','1',1,'Retail Sale Id 2582',2200.64,0.00,0.00,2.99,179.40,'2023-01-09 08:43:03','',''),(2691,'1','302','1',1,'Retail Sale Id 2583',9200.00,0.00,0.00,12.50,750.00,'2023-01-09 08:58:33','',''),(2692,'1','302','1',1,'Retail Sale Id 2584',2001.92,0.00,0.00,2.72,163.20,'2023-01-09 09:03:32','',''),(2693,'1','302','1',1,'Retail Sale Id 2585',4416.00,0.00,0.00,6.00,360.00,'2023-01-09 09:21:27','',''),(2694,'1','302','1',1,'Retail Sale Id 2586',9200.00,0.00,0.00,12.50,750.00,'2023-01-09 09:26:11','',''),(2695,'1','302','1',1,'Retail Sale Id 2587',2944.00,0.00,0.00,4.00,240.00,'2023-01-09 09:38:36','',''),(2696,'1','302','1',1,'Retail Sale Id 2587',4416.00,0.00,0.00,6.00,360.00,'2023-01-09 09:38:36','',''),(2697,'1','302','1',1,'Retail Sale Id 2588',3702.08,0.00,0.00,5.03,301.80,'2023-01-09 09:39:53','',''),(2698,'1','302','1',1,'Retail Sale Id 2589',2208.00,0.00,0.00,3.00,180.00,'2023-01-09 09:40:53','',''),(2699,'1','302','1',1,'Retail Sale Id 2590',4496.96,0.00,0.00,6.11,366.60,'2023-01-09 09:44:33','',''),(2700,'1','302','1',1,'Retail Sale Id 2591',2208.00,0.00,0.00,3.00,180.00,'2023-01-09 10:07:22','',''),(2701,'1','302','1',1,'Retail Sale Id 2592',9200.00,0.00,0.00,12.50,750.00,'2023-01-09 10:10:18','',''),(2702,'1','302','1',1,'Retail Sale Id 2593',4416.00,0.00,0.00,6.00,360.00,'2023-01-09 10:23:08','',''),(2703,'1','302','1',1,'Retail Sale Id 2594',2208.00,0.00,0.00,3.00,180.00,'2023-01-09 10:26:50','',''),(2704,'1','302','1',1,'Retail Sale Id 2595',3680.00,0.00,0.00,5.00,300.00,'2023-01-09 10:32:05','',''),(2705,'1','302','1',1,'Retail Sale Id 2596',2208.00,0.00,0.00,3.00,180.00,'2023-01-09 10:33:01','',''),(2706,'1','302','1',1,'Retail Sale Id 2597',2208.00,0.00,0.00,3.00,180.00,'2023-01-09 10:34:57','',''),(2707,'1','302','1',1,'Retail Sale Id 2598',4416.00,0.00,0.00,6.00,360.00,'2023-01-09 10:36:20','',''),(2708,'1','302','1',1,'Retail Sale Id 2599',9200.00,0.00,0.00,12.50,750.00,'2023-01-09 10:40:27','',''),(2709,'1','302','1',1,'Retail Sale Id 2600',4416.00,0.00,0.00,6.00,360.00,'2023-01-09 10:41:46','',''),(2710,'1','302','1',1,'Retail Sale Id 2601',2208.00,0.00,0.00,3.00,180.00,'2023-01-09 10:43:26','',''),(2711,'1','302','1',1,'Retail Sale Id 2602',2944.00,0.00,0.00,4.00,240.00,'2023-01-09 10:46:58','',''),(2712,'1','302','1',1,'Retail Sale Id 2603',7810.00,0.00,0.00,11.00,374.00,'2023-01-09 10:52:31','',''),(2713,'1','302','1',1,'Retail Sale Id 2604',4416.00,0.00,0.00,6.00,360.00,'2023-01-09 10:56:22','',''),(2714,'1','302','1',1,'Retail Sale Id 2605',2502.40,0.00,0.00,3.40,204.00,'2023-01-09 11:08:04','',''),(2715,'1','302','1',1,'Retail Sale Id 2606',3680.00,0.00,0.00,5.00,300.00,'2023-01-09 11:11:39','',''),(2716,'1','302','1',1,'Retail Sale Id 2607',1000.96,0.00,0.00,1.36,81.60,'2023-01-09 11:21:05','',''),(2717,'1','302','1',1,'Retail Sale Id 2608',4416.00,0.00,0.00,6.00,360.00,'2023-01-09 11:25:00','',''),(2718,'1','302','1',1,'Retail Sale Id 2608',9200.00,0.00,0.00,12.50,750.00,'2023-01-09 11:25:00','',''),(2719,'1','302','1',1,'Retail Sale Id 2609',9200.00,0.00,0.00,12.50,750.00,'2023-01-09 11:27:29','',''),(2720,'1','302','1',1,'Retail Sale Id 2610',2001.92,0.00,0.00,2.72,163.20,'2023-01-09 11:28:43','',''),(2721,'1','302','1',1,'Retail Sale Id 2611',3680.00,0.00,0.00,5.00,300.00,'2023-01-09 11:29:40','',''),(2722,'1','302','1',1,'Retail Sale Id 2612',9200.00,0.00,0.00,12.50,750.00,'2023-01-09 11:30:58','',''),(2723,'1','302','1',1,'Retail Sale Id 2613',736.00,0.00,0.00,1.00,60.00,'2023-01-09 11:31:48','',''),(2724,'1','302','1',1,'Retail Sale Id 2614',9200.00,0.00,0.00,12.50,750.00,'2023-01-09 11:33:35','',''),(2725,'1','302','1',1,'Retail Sale Id 2615',2208.00,0.00,0.00,3.00,180.00,'2023-01-09 11:34:28','',''),(2726,'1','302','1',1,'Retail Sale Id 2616',6498.88,0.00,0.00,8.83,529.80,'2023-01-09 11:35:18','',''),(2727,'1','302','1',1,'Retail Sale Id 2617',4416.00,0.00,0.00,6.00,360.00,'2023-01-09 11:39:54','',''),(2728,'1','302','1',1,'Retail Sale Id 2618',2208.00,0.00,0.00,3.00,180.00,'2023-01-09 11:41:23','',''),(2729,'1','302','1',1,'Retail Sale Id 2619',2208.00,0.00,0.00,3.00,180.00,'2023-01-09 11:42:27','',''),(2730,'1','302','1',1,'Retail Sale Id 2620',42600.00,0.00,0.00,60.00,2040.00,'2023-01-09 11:48:23','',''),(2731,'1','302','1',1,'Retail Sale Id 2621',2502.40,0.00,0.00,3.40,204.00,'2023-01-09 11:49:21','',''),(2732,'1','302','1',1,'Retail Sale Id 2622',2502.40,0.00,0.00,3.40,204.00,'2023-01-09 11:50:20','',''),(2733,'1','302','1',1,'Retail Sale Id 2623',6624.00,0.00,0.00,9.00,540.00,'2023-01-09 11:59:23','',''),(2734,'1','302','1',1,'Retail Sale Id 2624',3503.36,0.00,0.00,4.76,285.60,'2023-01-09 12:01:59','',''),(2735,'1','302','1',1,'Retail Sale Id 2625',3996.48,0.00,0.00,5.43,325.80,'2023-01-09 12:04:56','',''),(2736,'1','302','1',1,'Retail Sale Id 2626',2208.00,0.00,0.00,3.00,180.00,'2023-01-09 12:05:56','',''),(2737,'1','302','1',1,'Retail Sale Id 2627',7360.00,0.00,0.00,10.00,600.00,'2023-01-09 12:14:02','',''),(2738,'1','302','1',1,'Retail Sale Id 2628',2208.00,0.00,0.00,3.00,180.00,'2023-01-09 12:17:17','',''),(2739,'1','302','1',1,'Retail Sale Id 2629',2944.00,0.00,0.00,4.00,240.00,'2023-01-09 12:21:13','',''),(2740,'1','302','1',1,'Retail Sale Id 2630',22080.00,0.00,0.00,30.00,1800.00,'2023-01-09 12:29:20','',''),(2741,'1','302','1',1,'Retail Sale Id 2631',2208.00,0.00,0.00,3.00,180.00,'2023-01-09 12:30:54','',''),(2742,'1','302','1',1,'Retail Sale Id 2632',8000.32,0.00,0.00,10.87,652.20,'2023-01-09 12:31:54','',''),(2743,'1','302','1',1,'Retail Sale Id 2633',3680.00,0.00,0.00,5.00,300.00,'2023-01-09 12:33:13','',''),(2744,'1','302','1',1,'Retail Sale Id 2634',2130.00,0.00,0.00,3.00,102.00,'2023-01-09 12:34:34','',''),(2745,'1','302','1',1,'Retail Sale Id 2635',71000.00,0.00,0.00,100.00,3400.00,'2023-01-09 12:41:13','',''),(2746,'1','302','1',1,'Retail Sale Id 2636',9200.00,0.00,0.00,12.50,750.00,'2023-01-09 12:42:33','',''),(2747,'1','302','1',1,'Retail Sale Id 2637',9200.00,0.00,0.00,12.50,750.00,'2023-01-09 12:43:42','',''),(2748,'1','302','1',1,'Retail Sale Id 2638',9200.00,0.00,0.00,12.50,750.00,'2023-01-09 12:44:50','',''),(2749,'1','302','1',1,'Retail Sale Id 2639',2208.00,0.00,0.00,3.00,180.00,'2023-01-09 12:53:52','',''),(2750,'1','302','1',1,'Retail Sale Id 2640',2208.00,0.00,0.00,3.00,180.00,'2023-01-09 13:05:29','',''),(2751,'1','302','1',1,'Retail Sale Id 2640',2208.00,0.00,0.00,3.00,180.00,'2023-01-09 13:05:29','',''),(2752,'1','302','1',1,'Retail Sale Id 2640',4416.00,0.00,0.00,6.00,360.00,'2023-01-09 13:05:29','',''),(2753,'1','302','1',1,'Retail Sale Id 2640',4416.00,0.00,0.00,6.00,360.00,'2023-01-09 13:05:29','',''),(2754,'1','302','1',1,'Retail Sale Id 2641',71000.00,0.00,0.00,100.00,3400.00,'2023-01-09 13:08:57','',''),(2755,'1','302','1',1,'Retail Sale Id 2642',2200.64,0.00,0.00,2.99,179.40,'2023-01-09 13:31:08','',''),(2756,'1','302','1',1,'Retail Sale Id 2643',2944.00,0.00,0.00,4.00,240.00,'2023-01-09 13:32:47','',''),(2757,'1','302','1',1,'Retail Sale Id 2644',2944.00,0.00,0.00,4.00,240.00,'2023-01-09 13:42:58','',''),(2758,'1','302','1',1,'Retail Sale Id 2645',3002.88,0.00,0.00,4.08,244.80,'2023-01-09 13:45:36','',''),(2759,'1','302','1',1,'Retail Sale Id 2646',36565.00,0.00,0.00,51.50,1751.00,'2023-01-09 13:49:11','',''),(2760,'1','302','1',1,'Retail Sale Id 2647',2208.00,0.00,0.00,3.00,180.00,'2023-01-09 13:51:58','',''),(2761,'1','302','1',1,'Retail Sale Id 2648',2252.16,0.00,0.00,3.06,183.60,'2023-01-09 13:53:30','',''),(2762,'1','302','1',1,'Retail Sale Id 2648',2252.16,0.00,0.00,3.06,183.60,'2023-01-09 13:53:30','',''),(2763,'1','302','1',1,'Retail Sale Id 2650',2208.00,0.00,0.00,3.00,180.00,'2023-01-09 14:00:51','',''),(2764,'1','302','1',1,'Retail Sale Id 2651',1501.44,0.00,0.00,2.04,122.40,'2023-01-09 14:06:39','',''),(2765,'1','302','1',1,'Retail Sale Id 2652',3680.00,0.00,0.00,5.00,300.00,'2023-01-09 14:07:59','',''),(2766,'1','302','1',1,'Retail Sale Id 2653',1000.96,0.00,0.00,1.36,81.60,'2023-01-09 14:08:56','',''),(2767,'1','302','1',1,'Retail Sale Id 2654',3503.36,0.00,0.00,4.76,285.60,'2023-01-09 14:09:49','',''),(2768,'1','302','1',1,'Retail Sale Id 2655',1501.44,0.00,0.00,2.04,122.40,'2023-01-09 14:20:02','',''),(2769,'1','302','1',1,'Retail Sale Id 2656',4496.96,0.00,0.00,6.11,366.60,'2023-01-09 14:57:22','',''),(2770,'1','302','1',1,'Retail Sale Id 2657',18400.00,0.00,0.00,25.00,1500.00,'2023-01-09 15:00:12','',''),(2771,'1','302','1',1,'Retail Sale Id 2658',3680.00,0.00,0.00,5.00,300.00,'2023-01-09 15:06:20','',''),(2772,'1','302','1',1,'Retail Sale Id 2659',3002.88,0.00,0.00,4.08,244.80,'2023-01-09 15:12:09','',''),(2773,'1','302','1',1,'Retail Sale Id 2660',4416.00,0.00,0.00,6.00,360.00,'2023-01-09 15:17:20','',''),(2774,'1','302','1',1,'Retail Sale Id 2661',2200.64,0.00,0.00,2.99,179.40,'2023-01-09 15:24:27','',''),(2775,'1','302','1',1,'Retail Sale Id 2662',4452.80,0.00,0.00,6.05,363.00,'2023-01-09 15:25:59','',''),(2776,'1','302','1',1,'Retail Sale Id 2663',4416.00,0.00,0.00,6.00,360.00,'2023-01-09 15:27:25','',''),(2777,'1','302','1',1,'Retail Sale Id 2664',4416.00,0.00,0.00,6.00,360.00,'2023-01-09 15:32:58','',''),(2778,'1','302','1',1,'Retail Sale Id 2665',1501.44,0.00,0.00,2.04,122.40,'2023-01-09 15:40:54','',''),(2779,'1','302','1',1,'Retail Sale Id 2666',35500.00,0.00,0.00,50.00,1700.00,'2023-01-09 15:54:03','',''),(2780,'1','302','1',1,'Retail Sale Id 2667',6498.88,0.00,0.00,8.83,529.80,'2023-01-09 16:14:38','',''),(2781,'1','302','1',1,'Retail Sale Id 2668',4416.00,0.00,0.00,6.00,360.00,'2023-01-09 16:19:21','',''),(2782,'1','302','1',1,'Retail Sale Id 2669',2208.00,0.00,0.00,3.00,180.00,'2023-01-09 16:21:51','',''),(2783,'1','302','1',1,'Retail Sale Id 2670',4416.00,0.00,0.00,6.00,360.00,'2023-01-09 16:27:12','',''),(2784,'1','302','1',1,'Retail Sale Id 2671',2208.00,0.00,0.00,3.00,180.00,'2023-01-09 16:28:48','',''),(2785,'1','302','1',1,'Retail Sale Id 2672',2001.92,0.00,0.00,2.72,163.20,'2023-01-09 16:29:35','',''),(2786,'1','302','1',1,'Retail Sale Id 2673',3996.48,0.00,0.00,5.43,325.80,'2023-01-09 16:30:31','',''),(2787,'1','302','1',1,'Retail Sale Id 2674',2001.92,0.00,0.00,2.72,163.20,'2023-01-09 16:44:47','',''),(2788,'1','302','1',1,'Retail Sale Id 2675',500.48,0.00,0.00,0.68,40.80,'2023-01-09 16:54:31','',''),(2789,'1','302','1',1,'Retail Sale Id 2676',8832.00,0.00,0.00,12.00,720.00,'2023-01-09 16:59:35','',''),(2790,'1','302','1',1,'Retail Sale Id 2677',4416.00,0.00,0.00,6.00,360.00,'2023-01-09 17:01:27','',''),(2791,'1','302','1',1,'Retail Sale Id 2678',3503.36,0.00,0.00,4.76,285.60,'2023-01-09 17:04:03','',''),(2792,'1','302','1',1,'Retail Sale Id 2679',35500.00,0.00,0.00,50.00,1700.00,'2023-01-09 17:08:10','',''),(2793,'1','302','1',1,'Retail Sale Id 2680',3002.88,0.00,0.00,4.08,244.80,'2023-01-09 17:11:32','',''),(2794,'1','302','1',1,'Retail Sale Id 2681',9200.00,0.00,0.00,12.50,750.00,'2023-01-09 17:23:10','',''),(2795,'1','302','1',1,'Retail Sale Id 2682',2001.92,0.00,0.00,2.72,163.20,'2023-01-09 17:25:23','',''),(2796,'1','302','1',1,'Retail Sale Id 2683',2130.00,0.00,0.00,3.00,102.00,'2023-01-09 17:32:29','',''),(2797,'1','302','1',1,'Retail Sale Id 2684',1000.96,0.00,0.00,1.36,81.60,'2023-01-09 17:34:43','',''),(2798,'1','302','1',1,'Retail Sale Id 2685',1000.96,0.00,0.00,1.36,81.60,'2023-01-09 17:36:00','',''),(2799,'1','302','1',1,'Retail Sale Id 2686',1472.00,0.00,0.00,2.00,120.00,'2023-01-09 17:37:06','',''),(2800,'1','302','1',1,'Retail Sale Id 2687',2208.00,0.00,0.00,3.00,180.00,'2023-01-09 17:42:42','',''),(2801,'1','302','1',1,'Retail Sale Id 2688',9200.00,0.00,0.00,12.50,750.00,'2023-01-09 17:44:20','',''),(2802,'1','302','1',1,'Retail Sale Id 2689',3002.88,0.00,0.00,4.08,244.80,'2023-01-09 17:48:54','',''),(2803,'1','302','1',1,'Retail Sale Id 2690',1000.96,0.00,0.00,1.36,81.60,'2023-01-09 17:54:41','',''),(2804,'1','302','1',1,'Retail Sale Id 2691',2001.92,0.00,0.00,2.72,163.20,'2023-01-09 17:58:13','',''),(2805,'1','302','1',1,'Retail Sale Id 2692',3002.88,0.00,0.00,4.08,244.80,'2023-01-09 18:02:29','',''),(2806,'1','302','1',1,'Retail Sale Id 2693',500.48,0.00,0.00,0.68,40.80,'2023-01-09 18:10:36','',''),(2807,'1','302','1',1,'Retail Sale Id 2694',4416.00,0.00,0.00,6.00,360.00,'2023-01-09 18:12:11','',''),(2808,'1','302','1',1,'Retail Sale Id 2695',2502.40,0.00,0.00,3.40,204.00,'2023-01-09 18:14:56','',''),(2809,'1','302','1',1,'Retail Sale Id 2696',9200.00,0.00,0.00,12.50,750.00,'2023-01-09 18:16:03','',''),(2810,'1','302','1',1,'Retail Sale Id 2697',2208.00,0.00,0.00,3.00,180.00,'2023-01-09 18:20:09','',''),(2811,'1','302','1',1,'Retail Sale Id 2698',5998.40,0.00,0.00,8.15,489.00,'2023-01-09 18:24:38','',''),(2812,'1','302','1',1,'Retail Sale Id 2699',103.04,0.00,0.00,0.14,8.40,'2023-01-09 18:53:55','',''),(2813,'1','302','1',1,'Return of Retail Sale Id 2699',0.00,103.04,0.14,0.00,-8.40,'2023-01-09 18:56:41','',''),(2814,'1','302','1',1,'Retail Sale Id 2700',103.04,0.00,0.00,0.14,8.40,'2023-01-09 18:58:43','',''),(2815,'1','302','1',1,'Retail Sale Id 2701',1000.96,0.00,0.00,1.36,81.60,'2023-01-10 08:09:37','',''),(2816,'1','302','1',1,'Retail Sale Id 2702',2200.64,0.00,0.00,2.99,179.40,'2023-01-10 08:17:04','',''),(2817,'1','302','1',1,'Retail Sale Id 2703',2303.68,0.00,0.00,3.13,187.80,'2023-01-10 08:18:47','',''),(2818,'1','302','1',1,'Retail Sale Id 2704',3680.00,0.00,0.00,5.00,300.00,'2023-01-10 09:01:59','',''),(2819,'1','302','1',1,'Retail Sale Id 2704',8832.00,0.00,0.00,12.00,720.00,'2023-01-10 09:01:59','',''),(2820,'1','302','1',1,'Retail Sale Id 2704',8832.00,0.00,0.00,12.00,720.00,'2023-01-10 09:01:59','',''),(2821,'1','302','1',1,'Retail Sale Id 2705',8520.00,0.00,0.00,12.00,408.00,'2023-01-10 09:15:31','',''),(2822,'1','302','1',1,'Retail Sale Id 2706',2208.00,0.00,0.00,3.00,180.00,'2023-01-10 09:16:27','',''),(2823,'1','302','1',1,'Retail Sale Id 2707',20350.40,0.00,0.00,27.65,1659.00,'2023-01-10 09:22:35','',''),(2824,'1','302','1',1,'Retail Sale Id 2708',4312.96,0.00,0.00,5.86,351.60,'2023-01-10 09:26:45','',''),(2825,'1','302','1',1,'Retail Sale Id 2709',2303.68,0.00,0.00,3.13,187.80,'2023-01-10 09:27:33','',''),(2826,'1','302','1',1,'Retail Sale Id 2710',2303.68,0.00,0.00,3.13,187.80,'2023-01-10 09:31:15','',''),(2827,'1','302','1',1,'Retail Sale Id 2711',1479.36,0.00,0.00,2.01,120.60,'2023-01-10 09:37:39','',''),(2828,'1','302','1',1,'Retail Sale Id 2712',1000.96,0.00,0.00,1.36,81.60,'2023-01-10 09:40:10','',''),(2829,'1','302','1',1,'Retail Sale Id 2713',1000.96,0.00,0.00,1.36,81.60,'2023-01-10 09:41:01','',''),(2830,'1','302','1',1,'Retail Sale Id 2714',2001.92,0.00,0.00,2.72,163.20,'2023-01-10 09:46:05','',''),(2831,'1','302','1',1,'Retail Sale Id 2715',802.24,0.00,0.00,1.09,65.40,'2023-01-10 09:47:27','',''),(2832,'1','302','1',1,'Retail Sale Id 2716',802.24,0.00,0.00,1.09,65.40,'2023-01-10 09:50:14','',''),(2833,'1','302','1',1,'Retail Sale Id 2717',750.72,0.00,0.00,1.02,61.20,'2023-01-10 09:51:19','',''),(2834,'1','302','1',1,'Retail Sale Id 2718',9200.00,0.00,0.00,12.50,750.00,'2023-01-10 09:53:45','',''),(2835,'1','302','1',1,'Retail Sale Id 2720',2208.00,0.00,0.00,3.00,180.00,'2023-01-10 09:56:54','',''),(2836,'1','302','1',1,'Retail Sale Id 2721',7360.00,0.00,0.00,10.00,600.00,'2023-01-10 10:00:07','',''),(2837,'1','302','1',1,'Retail Sale Id 2722',3002.88,0.00,0.00,4.08,244.80,'2023-01-10 10:04:12','',''),(2838,'1','302','1',1,'Retail Sale Id 2723',4416.00,0.00,0.00,6.00,360.00,'2023-01-10 10:08:28','',''),(2839,'1','302','1',1,'Retail Sale Id 2724',4416.00,0.00,0.00,6.00,360.00,'2023-01-10 10:14:47','',''),(2840,'1','302','1',1,'Retail Sale Id 2725',3996.48,0.00,0.00,5.43,325.80,'2023-01-10 10:17:19','',''),(2841,'1','302','1',1,'Retail Sale Id 2726',7360.00,0.00,0.00,10.00,600.00,'2023-01-10 10:29:10','',''),(2842,'1','302','1',1,'Retail Sale Id 2727',3996.48,0.00,0.00,5.43,325.80,'2023-01-10 10:30:18','',''),(2843,'1','302','1',1,'Retail Sale Id 2728',4423.36,0.00,0.00,6.01,360.60,'2023-01-10 10:38:12','',''),(2844,'1','302','1',1,'Retail Sale Id 2729',3002.88,0.00,0.00,4.08,244.80,'2023-01-10 10:40:23','',''),(2845,'1','302','1',1,'Retail Sale Id 2730',4496.96,0.00,0.00,6.11,366.60,'2023-01-10 10:49:50','',''),(2846,'1','302','1',1,'Retail Sale Id 2731',3680.00,0.00,0.00,5.00,300.00,'2023-01-10 10:56:19','',''),(2847,'1','302','1',1,'Retail Sale Id 2732',9200.00,0.00,0.00,12.50,750.00,'2023-01-10 10:58:25','',''),(2848,'1','302','1',1,'Retail Sale Id 2733',4416.00,0.00,0.00,6.00,360.00,'2023-01-10 11:03:27','',''),(2849,'1','302','1',1,'Retail Sale Id 2734',2208.00,0.00,0.00,3.00,180.00,'2023-01-10 11:09:58','',''),(2850,'1','302','1',1,'Retail Sale Id 2734',2208.00,0.00,0.00,3.00,180.00,'2023-01-10 11:09:58','',''),(2851,'1','302','1',1,'Retail Sale Id 2735',4298.24,0.00,0.00,5.84,350.40,'2023-01-10 11:13:03','',''),(2852,'1','302','1',1,'Retail Sale Id 2735',9200.00,0.00,0.00,12.50,750.00,'2023-01-10 11:13:03','',''),(2853,'1','302','1',1,'Retail Sale Id 2736',10650.00,0.00,0.00,15.00,510.00,'2023-01-10 11:14:02','',''),(2854,'1','302','1',1,'Retail Sale Id 2737',3002.88,0.00,0.00,4.08,244.80,'2023-01-10 11:24:23','',''),(2855,'1','302','1',1,'Retail Sale Id 2738',2252.16,0.00,0.00,3.06,183.60,'2023-01-10 11:32:40','',''),(2856,'1','302','1',1,'Retail Sale Id 2739',35500.00,0.00,0.00,50.00,1700.00,'2023-01-10 11:42:58','',''),(2857,'1','302','1',1,'Retail Sale Id 2741',4496.96,0.00,0.00,6.11,366.60,'2023-01-10 11:45:16','',''),(2858,'1','302','1',1,'Retail Sale Id 2742',3002.88,0.00,0.00,4.08,244.80,'2023-01-10 11:46:17','',''),(2859,'1','302','1',1,'Retail Sale Id 2743',1501.44,0.00,0.00,2.04,122.40,'2023-01-10 11:47:06','',''),(2860,'1','302','1',1,'Retail Sale Id 2744',3680.00,0.00,0.00,5.00,300.00,'2023-01-10 11:48:38','',''),(2861,'1','302','1',1,'Retail Sale Id 2745',9200.00,0.00,0.00,12.50,750.00,'2023-01-10 11:56:06','',''),(2862,'1','302','1',1,'Retail Sale Id 2746',9230.00,0.00,0.00,13.00,442.00,'2023-01-10 12:01:26','',''),(2863,'1','302','1',1,'Retail Sale Id 2747',9200.00,0.00,0.00,12.50,750.00,'2023-01-10 12:02:38','',''),(2864,'1','302','1',1,'Retail Sale Id 2748',2208.00,0.00,0.00,3.00,180.00,'2023-01-10 12:09:29','',''),(2865,'1','302','1',1,'Retail Sale Id 2749',3680.00,0.00,0.00,5.00,300.00,'2023-01-10 12:12:36','',''),(2866,'1','302','1',1,'Retail Sale Id 2750',4452.80,0.00,0.00,6.05,363.00,'2023-01-10 12:16:11','',''),(2867,'1','302','1',1,'Retail Sale Id 2751',3680.00,0.00,0.00,5.00,300.00,'2023-01-10 12:17:28','',''),(2868,'1','302','1',1,'Retail Sale Id 2752',2001.92,0.00,0.00,2.72,163.20,'2023-01-10 12:19:49','',''),(2869,'1','302','1',1,'Retail Sale Id 2753',1501.44,0.00,0.00,2.04,122.40,'2023-01-10 12:44:29','',''),(2870,'1','302','1',1,'Retail Sale Id 2754',1501.44,0.00,0.00,2.04,122.40,'2023-01-10 12:45:45','',''),(2871,'1','302','1',1,'Retail Sale Id 2755',2200.64,0.00,0.00,2.99,179.40,'2023-01-10 12:49:03','',''),(2872,'1','302','1',1,'Retail Sale Id 2756',802.24,0.00,0.00,1.09,65.40,'2023-01-10 12:51:07','',''),(2873,'1','302','1',1,'Retail Sale Id 2756',2134400.00,0.00,0.00,2900.00,174000.00,'2023-01-10 12:51:07','',''),(2874,'1','302','1',1,'Retail Sale Id 2758',802.24,0.00,0.00,1.09,65.40,'2023-01-10 12:54:41','',''),(2875,'1','302','1',1,'Retail Sale Id 2758',2899.84,0.00,0.00,3.94,236.40,'2023-01-10 12:54:41','',''),(2876,'1','302','1',1,'Retail Sale Id 2759',2130.00,0.00,0.00,3.00,102.00,'2023-01-10 12:58:43','',''),(2877,'1','302','1',1,'Retail Sale Id 2760',1000.96,0.00,0.00,1.36,81.60,'2023-01-10 12:59:24','',''),(2878,'1','302','1',1,'Retail Sale Id 2761',2208.00,0.00,0.00,3.00,180.00,'2023-01-10 13:17:15','',''),(2879,'1','302','1',1,'Retail Sale Id 2762',2208.00,0.00,0.00,3.00,180.00,'2023-01-10 13:25:55','',''),(2880,'1','302','1',1,'Retail Sale Id 2763',3680.00,0.00,0.00,5.00,300.00,'2023-01-10 13:32:02','',''),(2881,'1','302','1',1,'Retail Sale Id 2763',9200.00,0.00,0.00,12.50,750.00,'2023-01-10 13:32:02','',''),(2882,'1','302','1',1,'Retail Sale Id 2764',1000.96,0.00,0.00,1.36,81.60,'2023-01-10 13:52:59','',''),(2883,'1','302','1',1,'Retail Sale Id 2765',4260.00,0.00,0.00,6.00,204.00,'2023-01-10 13:58:36','',''),(2884,'1','302','1',1,'Retail Sale Id 2766',4438.08,0.00,0.00,6.03,361.80,'2023-01-10 14:20:31','',''),(2885,'1','302','1',1,'Retail Sale Id 2767',2252.16,0.00,0.00,3.06,183.60,'2023-01-10 14:32:34','',''),(2886,'1','302','1',1,'Retail Sale Id 2768',6624.00,0.00,0.00,9.00,540.00,'2023-01-10 14:39:09','',''),(2887,'1','302','1',1,'Retail Sale Id 2769',3680.00,0.00,0.00,5.00,300.00,'2023-01-10 14:45:17','',''),(2888,'1','302','1',1,'Retail Sale Id 2770',3996.48,0.00,0.00,5.43,325.80,'2023-01-10 14:46:42','',''),(2889,'1','302','1',1,'Retail Sale Id 2771',2208.00,0.00,0.00,3.00,180.00,'2023-01-10 14:49:12','',''),(2890,'1','302','1',1,'Retail Sale Id 2772',2001.92,0.00,0.00,2.72,163.20,'2023-01-10 14:54:37','',''),(2891,'1','302','1',1,'Retail Sale Id 2773',9200.00,0.00,0.00,12.50,750.00,'2023-01-10 15:03:42','',''),(2892,'1','302','1',1,'Retail Sale Id 2774',2200.64,0.00,0.00,2.99,179.40,'2023-01-10 15:28:16','',''),(2893,'1','302','1',1,'Retail Sale Id 2775',9200.00,0.00,0.00,12.50,750.00,'2023-01-10 15:31:34','',''),(2894,'1','302','1',1,'Retail Sale Id 2776',2208.00,0.00,0.00,3.00,180.00,'2023-01-10 15:35:12','',''),(2895,'1','302','1',1,'Return of Retail Sale Id 2756',0.00,802.24,1.09,0.00,-65.40,'2023-01-10 15:36:30','',''),(2896,'1','302','1',1,'Return of Retail Sale Id 2756',0.00,2134400.00,2900.00,0.00,-174000.00,'2023-01-10 15:36:30','',''),(2897,'1','302','1',1,'Return of Retail Sale Id 2704',0.00,3680.00,5.00,0.00,-300.00,'2023-01-10 15:42:23','',''),(2898,'1','302','1',1,'Return of Retail Sale Id 2704',0.00,8832.00,12.00,0.00,-720.00,'2023-01-10 15:42:23','',''),(2899,'1','302','1',1,'Return of Retail Sale Id 2704',0.00,8832.00,12.00,0.00,-720.00,'2023-01-10 15:42:23','',''),(2900,'1','302','1',1,'Retail Sale Id 2777',1501.44,0.00,0.00,2.04,122.40,'2023-01-10 16:03:41','',''),(2901,'1','302','1',1,'Retail Sale Id 2778',1501.44,0.00,0.00,2.04,122.40,'2023-01-10 16:13:40','',''),(2902,'1','302','1',1,'Retail Sale Id 2779',2200.64,0.00,0.00,2.99,179.40,'2023-01-10 16:14:28','',''),(2903,'1','302','1',1,'Retail Sale Id 2780',3002.88,0.00,0.00,4.08,244.80,'2023-01-10 16:42:45','',''),(2904,'1','302','1',1,'Retail Sale Id 2781',4260.00,0.00,0.00,6.00,204.00,'2023-01-10 16:45:20','',''),(2905,'1','302','1',1,'Retail Sale Id 2782',3680.00,0.00,0.00,5.00,300.00,'2023-01-10 16:46:17','',''),(2906,'1','302','1',1,'Retail Sale Id 2784',1000.96,0.00,0.00,1.36,81.60,'2023-01-10 16:55:30','',''),(2907,'1','302','1',1,'Retail Sale Id 2785',7360.00,0.00,0.00,10.00,600.00,'2023-01-10 17:00:30','',''),(2908,'1','302','1',1,'Retail Sale Id 2786',4460.16,0.00,0.00,6.06,363.60,'2023-01-10 17:05:50','',''),(2909,'1','302','1',1,'Retail Sale Id 2787',4114.24,0.00,0.00,5.59,335.40,'2023-01-10 17:14:39','',''),(2910,'1','302','1',1,'Retail Sale Id 2788',29110.00,0.00,0.00,41.00,1394.00,'2023-01-10 17:19:20','',''),(2911,'1','302','1',1,'Return of Retail Sale Id 2786',0.00,4460.16,6.06,0.00,-363.60,'2023-01-10 17:20:42','',''),(2912,'1','302','1',1,'Retail Sale Id 2789',2001.92,0.00,0.00,2.72,163.20,'2023-01-10 17:21:10','',''),(2913,'1','302','1',1,'Return of Retail Sale Id 2785',0.00,7360.00,10.00,0.00,-600.00,'2023-01-10 17:24:32','',''),(2914,'1','302','1',1,'Retail Sale Id 2790',3201.60,0.00,0.00,4.35,261.00,'2023-01-10 17:26:35','',''),(2915,'1','302','1',1,'Retail Sale Id 2791',3996.48,0.00,0.00,5.43,325.80,'2023-01-10 17:29:44','',''),(2916,'1','302','1',1,'Retail Sale Id 2792',8520.00,0.00,0.00,12.00,408.00,'2023-01-10 17:37:20','',''),(2917,'1','302','1',1,'Retail Sale Id 2793',9200.00,0.00,0.00,12.50,750.00,'2023-01-10 17:39:08','',''),(2918,'1','302','1',1,'Retail Sale Id 2794',2001.92,0.00,0.00,2.72,163.20,'2023-01-10 17:41:57','',''),(2919,'1','302','1',1,'Retail Sale Id 2795',2001.92,0.00,0.00,2.72,163.20,'2023-01-10 17:56:52','',''),(2920,'1','302','1',1,'Retail Sale Id 2797',4997.44,0.00,0.00,6.79,407.40,'2023-01-10 18:01:10','',''),(2921,'1','302','1',1,'Retail Sale Id 2798',566.72,0.00,0.00,0.77,46.20,'2023-01-10 19:06:44','',''),(2922,'1','302','1',1,'Retail Sale Id 2799',3680.00,0.00,0.00,5.00,300.00,'2023-01-11 07:46:42','',''),(2923,'1','302','1',1,'Retail Sale Id 2800',7360.00,0.00,0.00,10.00,600.00,'2023-01-11 07:48:52','',''),(2924,'1','302','1',1,'Retail Sale Id 2801',3996.48,0.00,0.00,5.43,325.80,'2023-01-11 08:06:34','',''),(2925,'1','302','1',1,'Retail Sale Id 2802',1803.20,0.00,0.00,2.45,147.00,'2023-01-11 08:16:53','',''),(2926,'1','302','1',1,'Retail Sale Id 2803',4496.96,0.00,0.00,6.11,366.60,'2023-01-11 08:22:43','',''),(2927,'1','302','1',1,'Retail Sale Id 2804',4997.44,0.00,0.00,6.79,407.40,'2023-01-11 08:24:11','',''),(2928,'1','302','1',1,'Retail Sale Id 2805',802.24,0.00,0.00,1.09,65.40,'2023-01-11 08:25:19','',''),(2929,'1','302','1',1,'Retail Sale Id 2806',1000.96,0.00,0.00,1.36,81.60,'2023-01-11 08:26:22','',''),(2930,'1','302','1',1,'Retail Sale Id 2807',2944.00,0.00,0.00,4.00,240.00,'2023-01-11 08:56:45','',''),(2931,'1','302','1',1,'Retail Sale Id 2808',3002.88,0.00,0.00,4.08,244.80,'2023-01-11 08:58:50','',''),(2932,'1','302','1',1,'Retail Sale Id 2809',3680.00,0.00,0.00,5.00,300.00,'2023-01-11 09:03:37','',''),(2933,'1','302','1',1,'Retail Sale Id 2810',1000.96,0.00,0.00,1.36,81.60,'2023-01-11 09:09:13','',''),(2934,'1','302','1',1,'Retail Sale Id 2811',3996.48,0.00,0.00,5.43,325.80,'2023-01-11 09:10:33','',''),(2935,'1','302','1',1,'Retail Sale Id 2811',3996.48,0.00,0.00,5.43,325.80,'2023-01-11 09:10:33','',''),(2936,'1','302','1',1,'Retail Sale Id 2813',4496.96,0.00,0.00,6.11,366.60,'2023-01-11 09:13:20','',''),(2937,'1','302','1',1,'Retail Sale Id 2814',2001.92,0.00,0.00,2.72,163.20,'2023-01-11 09:14:48','',''),(2938,'1','302','1',1,'Retail Sale Id 2815',3002.88,0.00,0.00,4.08,244.80,'2023-01-11 09:16:12','',''),(2939,'1','302','1',1,'Retail Sale Id 2816',9200.00,0.00,0.00,12.50,750.00,'2023-01-11 09:18:20','',''),(2940,'1','302','1',1,'Retail Sale Id 2817',8096.00,0.00,0.00,11.00,660.00,'2023-01-11 09:20:28','',''),(2941,'1','302','1',1,'Retail Sale Id 2818',2001.92,0.00,0.00,2.72,163.20,'2023-01-11 09:21:30','',''),(2942,'1','302','1',1,'Retail Sale Id 2818',2502.40,0.00,0.00,3.40,204.00,'2023-01-11 09:21:30','',''),(2943,'1','302','1',1,'Retail Sale Id 2819',9200.00,0.00,0.00,12.50,750.00,'2023-01-11 09:22:33','',''),(2944,'1','302','1',1,'Retail Sale Id 2820',9200.00,0.00,0.00,12.50,750.00,'2023-01-11 09:23:36','',''),(2945,'1','302','1',1,'Retail Sale Id 2821',2208.00,0.00,0.00,3.00,180.00,'2023-01-11 09:24:30','',''),(2946,'1','302','1',1,'Retail Sale Id 2822',2208.00,0.00,0.00,3.00,180.00,'2023-01-11 09:32:25','',''),(2947,'1','302','1',1,'Retail Sale Id 2823',9200.00,0.00,0.00,12.50,750.00,'2023-01-11 09:50:57','',''),(2948,'1','302','1',1,'Retail Sale Id 2824',3680.00,0.00,0.00,5.00,300.00,'2023-01-11 09:53:13','',''),(2949,'1','302','1',1,'Retail Sale Id 2825',9200.00,0.00,0.00,12.50,750.00,'2023-01-11 09:55:38','',''),(2950,'1','302','1',1,'Retail Sale Id 2826',4416.00,0.00,0.00,6.00,360.00,'2023-01-11 09:57:38','',''),(2951,'1','302','1',1,'Retail Sale Id 2827',3002.88,0.00,0.00,4.08,244.80,'2023-01-11 09:59:08','',''),(2952,'1','302','1',1,'Retail Sale Id 2828',2208.00,0.00,0.00,3.00,180.00,'2023-01-11 10:01:11','',''),(2953,'1','302','1',1,'Retail Sale Id 2829',2200.64,0.00,0.00,2.99,179.40,'2023-01-11 10:02:37','',''),(2954,'1','302','1',1,'Retail Sale Id 2830',3680.00,0.00,0.00,5.00,300.00,'2023-01-11 10:03:55','',''),(2955,'1','302','1',1,'Retail Sale Id 2831',1501.44,0.00,0.00,2.04,122.40,'2023-01-11 10:05:37','',''),(2956,'1','302','1',1,'Retail Sale Id 2832',3002.88,0.00,0.00,4.08,244.80,'2023-01-11 10:14:35','',''),(2957,'1','302','1',1,'Retail Sale Id 2833',3680.00,0.00,0.00,5.00,300.00,'2023-01-11 10:15:58','',''),(2958,'1','302','1',1,'Retail Sale Id 2834',2200.64,0.00,0.00,2.99,179.40,'2023-01-11 10:17:58','',''),(2959,'1','302','1',1,'Retail Sale Id 2835',4416.00,0.00,0.00,6.00,360.00,'2023-01-11 10:19:53','',''),(2960,'1','302','1',1,'Retail Sale Id 2835',4416.00,0.00,0.00,6.00,360.00,'2023-01-11 10:19:53','',''),(2961,'1','302','1',1,'Retail Sale Id 2836',2208.00,0.00,0.00,3.00,180.00,'2023-01-11 10:22:26','',''),(2962,'1','302','1',1,'Retail Sale Id 2837',2303.68,0.00,0.00,3.13,187.80,'2023-01-11 10:29:43','',''),(2963,'1','302','1',1,'Retail Sale Id 2838',2502.40,0.00,0.00,3.40,204.00,'2023-01-11 10:33:56','',''),(2964,'1','302','1',1,'Retail Sale Id 2839',4496.96,0.00,0.00,6.11,366.60,'2023-01-11 10:39:39','',''),(2965,'1','302','1',1,'Retail Sale Id 2841',2944.00,0.00,0.00,4.00,240.00,'2023-01-11 10:41:04','',''),(2966,'1','302','1',1,'Retail Sale Id 2842',9200.00,0.00,0.00,12.50,750.00,'2023-01-11 10:42:08','',''),(2967,'1','302','1',1,'Retail Sale Id 2843',2001.92,0.00,0.00,2.72,163.20,'2023-01-11 10:44:46','',''),(2968,'1','302','1',1,'Retail Sale Id 2844',1501.44,0.00,0.00,2.04,122.40,'2023-01-11 10:48:44','',''),(2969,'1','302','1',1,'Retail Sale Id 2845',3002.88,0.00,0.00,4.08,244.80,'2023-01-11 10:55:43','',''),(2970,'1','302','1',1,'Retail Sale Id 2846',2200.64,0.00,0.00,2.99,179.40,'2023-01-11 11:01:18','',''),(2971,'1','302','1',1,'Retail Sale Id 2847',2303.68,0.00,0.00,3.13,187.80,'2023-01-11 11:02:43','',''),(2972,'1','302','1',1,'Retail Sale Id 2848',1472.00,0.00,0.00,2.00,120.00,'2023-01-11 11:11:41','',''),(2973,'1','302','1',1,'Retail Sale Id 2849',2001.92,0.00,0.00,2.72,163.20,'2023-01-11 11:13:34','',''),(2974,'1','302','1',1,'Retail Sale Id 2850',4416.00,0.00,0.00,6.00,360.00,'2023-01-11 11:26:03','',''),(2975,'1','302','1',1,'Retail Sale Id 2851',1501.44,0.00,0.00,2.04,122.40,'2023-01-11 11:27:23','',''),(2976,'1','302','1',1,'Retail Sale Id 2852',2208.00,0.00,0.00,3.00,180.00,'2023-01-11 11:36:42','',''),(2977,'1','302','1',1,'Retail Sale Id 2853',1501.44,0.00,0.00,2.04,122.40,'2023-01-11 11:37:54','',''),(2978,'1','302','1',1,'Retail Sale Id 2854',9200.00,0.00,0.00,12.50,750.00,'2023-01-11 11:39:47','',''),(2979,'1','302','1',1,'Retail Sale Id 2855',1000.96,0.00,0.00,1.36,81.60,'2023-01-11 11:42:53','',''),(2980,'1','302','1',1,'Retail Sale Id 2856',3680.00,0.00,0.00,5.00,300.00,'2023-01-11 11:46:03','',''),(2981,'1','302','1',1,'Retail Sale Id 2857',2208.00,0.00,0.00,3.00,180.00,'2023-01-11 11:48:14','',''),(2982,'1','302','1',1,'Retail Sale Id 2858',1000.96,0.00,0.00,1.36,81.60,'2023-01-11 11:54:48','',''),(2983,'1','302','1',1,'Retail Sale Id 2860',1000.96,0.00,0.00,1.36,81.60,'2023-01-11 12:02:40','',''),(2984,'1','302','1',1,'Retail Sale Id 2861',3002.88,0.00,0.00,4.08,244.80,'2023-01-11 12:03:59','',''),(2985,'1','302','1',1,'Retail Sale Id 2862',4997.44,0.00,0.00,6.79,407.40,'2023-01-11 12:12:42','',''),(2986,'1','302','1',1,'Retail Sale Id 2863',2208.00,0.00,0.00,3.00,180.00,'2023-01-11 12:17:42','',''),(2987,'1','302','1',1,'Retail Sale Id 2864',2130.00,0.00,0.00,3.00,102.00,'2023-01-11 12:20:21','',''),(2988,'1','302','1',1,'Retail Sale Id 2865',3680.00,0.00,0.00,5.00,300.00,'2023-01-11 12:24:05','',''),(2989,'1','302','1',1,'Retail Sale Id 2866',2001.92,0.00,0.00,2.72,163.20,'2023-01-11 12:31:21','',''),(2990,'1','302','1',1,'Retail Sale Id 2867',2502.40,0.00,0.00,3.40,204.00,'2023-01-11 12:35:43','',''),(2991,'1','302','1',1,'Retail Sale Id 2868',3996.48,0.00,0.00,5.43,325.80,'2023-01-11 12:46:41','',''),(2992,'1','302','1',1,'Retail Sale Id 2869',2001.92,0.00,0.00,2.72,163.20,'2023-01-11 13:00:31','',''),(2993,'1','302','1',1,'Retail Sale Id 2870',2944.00,0.00,0.00,4.00,240.00,'2023-01-11 13:08:05','',''),(2994,'1','302','1',1,'Retail Sale Id 2871',35500.00,0.00,0.00,50.00,1700.00,'2023-01-11 13:09:51','',''),(2995,'1','302','1',1,'Retail Sale Id 2872',1000.96,0.00,0.00,1.36,81.60,'2023-01-11 13:10:42','',''),(2996,'1','302','1',1,'Retail Sale Id 2873',3680.00,0.00,0.00,5.00,300.00,'2023-01-11 13:16:27','',''),(2997,'1','302','1',1,'Retail Sale Id 2874',17750.00,0.00,0.00,25.00,850.00,'2023-01-11 13:20:43','',''),(2998,'1','302','1',1,'Retail Sale Id 2875',2001.92,0.00,0.00,2.72,163.20,'2023-01-11 13:22:32','',''),(2999,'1','302','1',1,'Retail Sale Id 2876',4416.00,0.00,0.00,6.00,360.00,'2023-01-11 13:38:29','',''),(3000,'1','302','1',1,'Retail Sale Id 2877',6999.36,0.00,0.00,9.51,570.60,'2023-01-11 13:48:58','',''),(3001,'1','302','1',1,'Retail Sale Id 2878',7100.00,0.00,0.00,10.00,340.00,'2023-01-11 13:51:16','',''),(3002,'1','302','1',1,'Retail Sale Id 2879',3680.00,0.00,0.00,5.00,300.00,'2023-01-11 13:53:31','',''),(3003,'1','302','1',1,'Retail Sale Id 2880',2208.00,0.00,0.00,3.00,180.00,'2023-01-11 13:57:03','',''),(3004,'1','302','1',1,'Retail Sale Id 2881',106500.00,0.00,0.00,150.00,5100.00,'2023-01-11 13:59:05','',''),(3005,'1','302','1',1,'Retail Sale Id 2882',3503.36,0.00,0.00,4.76,285.60,'2023-01-11 14:02:22','',''),(3006,'1','302','1',1,'Retail Sale Id 2883',3002.88,0.00,0.00,4.08,244.80,'2023-01-11 14:06:27','',''),(3007,'1','302','1',1,'Retail Sale Id 2884',1501.44,0.00,0.00,2.04,122.40,'2023-01-11 14:11:14','',''),(3008,'1','302','1',1,'Retail Sale Id 2885',10002.24,0.00,0.00,13.59,815.40,'2023-01-11 14:17:31','',''),(3009,'1','302','1',1,'Retail Sale Id 2886',1000.96,0.00,0.00,1.36,81.60,'2023-01-11 14:29:02','',''),(3010,'1','302','1',1,'Retail Sale Id 2887',4416.00,0.00,0.00,6.00,360.00,'2023-01-11 14:33:36','',''),(3011,'1','302','1',1,'Retail Sale Id 2887',9200.00,0.00,0.00,12.50,750.00,'2023-01-11 14:33:36','',''),(3012,'1','302','1',1,'Retail Sale Id 2888',736.00,0.00,0.00,1.00,60.00,'2023-01-11 14:36:23','',''),(3013,'1','302','1',1,'Retail Sale Id 2889',4416.00,0.00,0.00,6.00,360.00,'2023-01-11 14:43:17','',''),(3014,'1','302','1',1,'Retail Sale Id 2890',4416.00,0.00,0.00,6.00,360.00,'2023-01-11 15:00:47','',''),(3015,'1','302','1',1,'Retail Sale Id 2891',1065.00,0.00,0.00,1.50,51.00,'2023-01-11 15:08:32','',''),(3016,'1','302','1',1,'Retail Sale Id 2892',4416.00,0.00,0.00,6.00,360.00,'2023-01-11 15:16:00','',''),(3017,'1','302','1',1,'Retail Sale Id 2893',4416.00,0.00,0.00,6.00,360.00,'2023-01-11 15:20:51','',''),(3018,'1','302','1',1,'Retail Sale Id 2893',7360.00,0.00,0.00,10.00,600.00,'2023-01-11 15:20:51','',''),(3019,'1','302','1',1,'Retail Sale Id 2893',9200.00,0.00,0.00,12.50,750.00,'2023-01-11 15:20:51','',''),(3020,'1','302','1',1,'Retail Sale Id 2894',2001.92,0.00,0.00,2.72,163.20,'2023-01-11 15:28:23','',''),(3021,'1','302','1',1,'Retail Sale Id 2895',3503.36,0.00,0.00,4.76,285.60,'2023-01-11 15:32:00','',''),(3022,'1','302','1',1,'Retail Sale Id 2896',9200.00,0.00,0.00,12.50,750.00,'2023-01-11 15:39:03','',''),(3023,'1','302','1',1,'Retail Sale Id 2897',9200.00,0.00,0.00,12.50,750.00,'2023-01-11 15:41:19','',''),(3024,'1','302','1',1,'Retail Sale Id 2898',1302.72,0.00,0.00,1.77,106.20,'2023-01-11 15:42:29','',''),(3025,'1','302','1',1,'Retail Sale Id 2899',17750.00,0.00,0.00,25.00,850.00,'2023-01-11 15:45:44','',''),(3026,'1','302','1',1,'Retail Sale Id 2900',3503.36,0.00,0.00,4.76,285.60,'2023-01-11 15:47:38','',''),(3027,'1','302','1',1,'Retail Sale Id 2901',3680.00,0.00,0.00,5.00,300.00,'2023-01-11 15:51:57','',''),(3028,'1','302','1',1,'Retail Sale Id 2902',5998.40,0.00,0.00,8.15,489.00,'2023-01-11 15:54:17','',''),(3029,'1','302','1',1,'Retail Sale Id 2903',3996.48,0.00,0.00,5.43,325.80,'2023-01-11 16:03:38','',''),(3030,'1','302','1',1,'Retail Sale Id 2904',1000.96,0.00,0.00,1.36,81.60,'2023-01-11 16:05:28','',''),(3031,'1','302','1',1,'Retail Sale Id 2905',4416.00,0.00,0.00,6.00,360.00,'2023-01-11 16:07:32','',''),(3032,'1','302','1',1,'Retail Sale Id 2906',4997.44,0.00,0.00,6.79,407.40,'2023-01-11 16:33:48','',''),(3033,'1','302','1',1,'Retail Sale Id 2907',4416.00,0.00,0.00,6.00,360.00,'2023-01-11 16:38:00','',''),(3034,'1','302','1',1,'Retail Sale Id 2908',3680.00,0.00,0.00,5.00,300.00,'2023-01-11 16:39:38','',''),(3035,'1','302','1',1,'Retail Sale Id 2909',802.24,0.00,0.00,1.09,65.40,'2023-01-11 16:51:51','',''),(3036,'1','302','1',1,'Retail Sale Id 2910',1501.44,0.00,0.00,2.04,122.40,'2023-01-11 16:53:51','',''),(3037,'1','302','1',1,'Retail Sale Id 2911',500.48,0.00,0.00,0.68,40.80,'2023-01-11 16:57:23','',''),(3038,'1','302','1',1,'Retail Sale Id 2912',3002.88,0.00,0.00,4.08,244.80,'2023-01-11 17:05:37','',''),(3039,'1','302','1',1,'Retail Sale Id 2913',9200.00,0.00,0.00,12.50,750.00,'2023-01-11 17:06:54','',''),(3040,'1','302','1',1,'Retail Sale Id 2914',3002.88,0.00,0.00,4.08,244.80,'2023-01-11 17:08:56','',''),(3041,'1','302','1',1,'Retail Sale Id 2915',8832.00,0.00,0.00,12.00,720.00,'2023-01-11 17:11:12','',''),(3042,'1','302','1',1,'Retail Sale Id 2916',4416.00,0.00,0.00,6.00,360.00,'2023-01-11 17:15:02','',''),(3043,'1','302','1',1,'Retail Sale Id 2917',2001.92,0.00,0.00,2.72,163.20,'2023-01-11 17:18:04','',''),(3044,'1','302','1',1,'Retail Sale Id 2918',1472.00,0.00,0.00,2.00,120.00,'2023-01-11 17:20:00','',''),(3045,'1','302','1',1,'Retail Sale Id 2919',3680.00,0.00,0.00,5.00,300.00,'2023-01-11 17:22:00','',''),(3046,'1','302','1',1,'Retail Sale Id 2920',3680.00,0.00,0.00,5.00,300.00,'2023-01-11 17:41:12','',''),(3047,'1','302','1',1,'Retail Sale Id 2921',7360.00,0.00,0.00,10.00,600.00,'2023-01-11 17:44:16','',''),(3048,'1','302','1',1,'Retail Sale Id 2922',1501.44,0.00,0.00,2.04,122.40,'2023-01-11 17:56:56','',''),(3049,'1','302','1',1,'Retail Sale Id 2923',710.00,0.00,0.00,1.00,34.00,'2023-01-11 18:13:19','',''),(3050,'1','302','1',1,'Retail Sale Id 2924',3002.88,0.00,0.00,4.08,244.80,'2023-01-11 18:14:14','',''),(3051,'1','302','1',1,'Retail Sale Id 2925',2001.92,0.00,0.00,2.72,163.20,'2023-01-11 18:40:39','',''),(3052,'1','302','1',1,'Retail Sale Id 2926',9200.00,0.00,0.00,12.50,750.00,'2023-01-11 18:41:49','',''),(3053,'1','302','1',1,'Retail Sale Id 2927',80.96,0.00,0.00,0.11,6.60,'2023-01-11 20:24:13','',''),(3054,'1','302','1',1,'Retail Sale Id 2928',4496.96,0.00,0.00,6.11,366.60,'2023-01-12 07:52:09','',''),(3055,'1','302','1',1,'Retail Sale Id 2929',4496.96,0.00,0.00,6.11,366.60,'2023-01-12 07:53:01','',''),(3056,'1','302','1',1,'Retail Sale Id 2930',3702.08,0.00,0.00,5.03,301.80,'2023-01-12 08:12:02','',''),(3057,'1','302','1',1,'Retail Sale Id 2931',9200.00,0.00,0.00,12.50,750.00,'2023-01-12 08:13:55','',''),(3058,'1','302','1',1,'Retail Sale Id 2932',2001.92,0.00,0.00,2.72,163.20,'2023-01-12 08:26:25','',''),(3059,'1','302','1',1,'Retail Sale Id 2933',2303.68,0.00,0.00,3.13,187.80,'2023-01-12 08:35:28','',''),(3060,'1','302','1',1,'Retail Sale Id 2934',4997.44,0.00,0.00,6.79,407.40,'2023-01-12 08:40:09','',''),(3061,'1','302','1',1,'Retail Sale Id 2935',3702.08,0.00,0.00,5.03,301.80,'2023-01-12 08:42:42','',''),(3062,'1','302','1',1,'Retail Sale Id 2936',9303.04,0.00,0.00,12.64,758.40,'2023-01-12 08:44:16','',''),(3063,'1','302','1',1,'Retail Sale Id 2937',3680.00,0.00,0.00,5.00,300.00,'2023-01-12 08:51:53','',''),(3064,'1','302','1',1,'Retail Sale Id 2938',1000.96,0.00,0.00,1.36,81.60,'2023-01-12 08:53:57','',''),(3065,'1','302','1',1,'Retail Sale Id 2939',1000.96,0.00,0.00,1.36,81.60,'2023-01-12 09:05:37','',''),(3066,'1','302','1',1,'Retail Sale Id 2940',2001.92,0.00,0.00,2.72,163.20,'2023-01-12 09:08:16','',''),(3067,'1','302','1',1,'Retail Sale Id 2941',2001.92,0.00,0.00,2.72,163.20,'2023-01-12 09:17:55','',''),(3068,'1','302','1',1,'Retail Sale Id 2942',1501.44,0.00,0.00,2.04,122.40,'2023-01-12 09:19:21','',''),(3069,'1','302','1',1,'Retail Sale Id 2943',2001.92,0.00,0.00,2.72,163.20,'2023-01-12 09:27:29','',''),(3070,'1','302','1',1,'Retail Sale Id 2944',17750.00,0.00,0.00,25.00,850.00,'2023-01-12 09:31:31','',''),(3071,'1','302','1',1,'Retail Sale Id 2945',802.24,0.00,0.00,1.09,65.40,'2023-01-12 09:32:38','',''),(3072,'1','302','1',1,'Retail Sale Id 2946',3702.08,0.00,0.00,5.03,301.80,'2023-01-12 09:34:09','',''),(3073,'1','302','1',1,'Retail Sale Id 2947',4416.00,0.00,0.00,6.00,360.00,'2023-01-12 09:36:05','',''),(3074,'1','302','1',1,'Retail Sale Id 2948',4496.96,0.00,0.00,6.11,366.60,'2023-01-12 09:47:13','',''),(3075,'1','302','1',1,'Retail Sale Id 2949',2502.40,0.00,0.00,3.40,204.00,'2023-01-12 09:55:45','',''),(3076,'1','302','1',1,'Retail Sale Id 2950',2502.40,0.00,0.00,3.40,204.00,'2023-01-12 09:57:21','',''),(3077,'1','302','1',1,'Retail Sale Id 2951',36800.00,0.00,0.00,50.00,3000.00,'2023-01-12 10:04:42','',''),(3078,'1','302','1',1,'Retail Sale Id 2953',2303.68,0.00,0.00,3.13,187.80,'2023-01-12 10:09:55','',''),(3079,'1','302','1',1,'Retail Sale Id 2953',9200.00,0.00,0.00,12.50,750.00,'2023-01-12 10:09:55','',''),(3080,'1','302','1',1,'Retail Sale Id 2954',3002.88,0.00,0.00,4.08,244.80,'2023-01-12 10:12:04','',''),(3081,'1','302','1',1,'Retail Sale Id 2955',5680.00,0.00,0.00,8.00,272.00,'2023-01-12 10:14:09','',''),(3082,'1','302','1',1,'Retail Sale Id 2956',9303.04,0.00,0.00,12.64,758.40,'2023-01-12 10:15:49','',''),(3083,'1','302','1',1,'Retail Sale Id 2959',3996.48,0.00,0.00,5.43,325.80,'2023-01-12 10:21:23','',''),(3084,'1','302','1',1,'Retail Sale Id 2960',3002.88,0.00,0.00,4.08,244.80,'2023-01-12 10:22:21','',''),(3085,'1','302','1',1,'Retail Sale Id 2961',1501.44,0.00,0.00,2.04,122.40,'2023-01-12 10:23:24','',''),(3086,'1','302','1',1,'Retail Sale Id 2962',1501.44,0.00,0.00,2.04,122.40,'2023-01-12 10:27:06','',''),(3087,'1','302','1',1,'Retail Sale Id 2963',699.20,0.00,0.00,0.95,57.00,'2023-01-12 11:05:30','',''),(3088,'1','302','1',1,'Retail Sale Id 2964',2001.92,0.00,0.00,2.72,163.20,'2023-01-12 11:13:51','',''),(3089,'1','302','1',1,'Retail Sale Id 2967',4416.00,0.00,0.00,6.00,360.00,'2023-01-12 11:20:28','',''),(3090,'1','302','1',1,'Retail Sale Id 2968',4496.96,0.00,0.00,6.11,366.60,'2023-01-12 11:23:48','',''),(3091,'1','302','1',1,'Retail Sale Id 2969',2252.16,0.00,0.00,3.06,183.60,'2023-01-12 11:25:33','',''),(3092,'1','302','1',1,'Retail Sale Id 2969',2252.16,0.00,0.00,3.06,183.60,'2023-01-12 11:25:33','',''),(3093,'1','302','1',1,'Retail Sale Id 2970',3002.88,0.00,0.00,4.08,244.80,'2023-01-12 11:26:26','',''),(3094,'1','302','1',1,'Retail Sale Id 2971',3753.60,0.00,0.00,5.10,306.00,'2023-01-12 11:39:30','',''),(3095,'1','302','1',1,'Retail Sale Id 2971',3753.60,0.00,0.00,5.10,306.00,'2023-01-12 11:39:30','',''),(3096,'1','302','1',1,'Retail Sale Id 2972',9200.00,0.00,0.00,12.50,750.00,'2023-01-12 11:40:45','',''),(3097,'1','302','1',1,'Retail Sale Id 2973',2303.68,0.00,0.00,3.13,187.80,'2023-01-12 11:55:50','',''),(3098,'1','302','1',1,'Retail Sale Id 2974',8000.32,0.00,0.00,10.87,652.20,'2023-01-12 11:56:52','',''),(3099,'1','302','1',1,'Retail Sale Id 2975',2001.92,0.00,0.00,2.72,163.20,'2023-01-12 11:57:53','',''),(3100,'1','302','1',1,'Retail Sale Id 2976',1501.44,0.00,0.00,2.04,122.40,'2023-01-12 12:05:56','',''),(3101,'1','302','1',1,'Retail Sale Id 2978',1000.96,0.00,0.00,1.36,81.60,'2023-01-12 12:09:00','',''),(3102,'1','302','1',1,'Retail Sale Id 2979',4416.00,0.00,0.00,6.00,360.00,'2023-01-12 12:11:47','',''),(3103,'1','302','1',1,'Retail Sale Id 2979',9200.00,0.00,0.00,12.50,750.00,'2023-01-12 12:11:47','',''),(3104,'1','302','1',1,'Retail Sale Id 2980',3680.00,0.00,0.00,5.00,300.00,'2023-01-12 12:15:10','',''),(3105,'1','302','1',1,'Retail Sale Id 2981',7100.00,0.00,0.00,10.00,340.00,'2023-01-12 12:17:55','',''),(3106,'1','302','1',1,'Retail Sale Id 2982',2502.40,0.00,0.00,3.40,204.00,'2023-01-12 12:19:08','',''),(3107,'1','302','1',1,'Retail Sale Id 2983',4438.08,0.00,0.00,6.03,361.80,'2023-01-12 12:21:14','',''),(3108,'1','302','1',1,'Retail Sale Id 2985',2303.68,0.00,0.00,3.13,187.80,'2023-01-12 12:26:29','',''),(3109,'1','302','1',1,'Retail Sale Id 2986',2222.72,0.00,0.00,3.02,181.20,'2023-01-12 12:46:41','',''),(3110,'1','302','1',1,'Retail Sale Id 2987',35500.00,0.00,0.00,50.00,1700.00,'2023-01-12 12:56:13','',''),(3111,'1','302','1',1,'Retail Sale Id 2988',8875.00,0.00,0.00,12.50,425.00,'2023-01-12 12:57:58','',''),(3112,'1','302','1',1,'Retail Sale Id 2989',4970.00,0.00,0.00,7.00,238.00,'2023-01-12 12:59:25','',''),(3113,'1','302','1',1,'Retail Sale Id 2990',3702.08,0.00,0.00,5.03,301.80,'2023-01-12 13:00:46','',''),(3114,'1','302','1',1,'Retail Sale Id 2991',4416.00,0.00,0.00,6.00,360.00,'2023-01-12 13:03:45','',''),(3115,'1','302','1',1,'Retail Sale Id 2992',33370.00,0.00,0.00,47.00,1598.00,'2023-01-12 13:07:17','',''),(3116,'1','302','1',1,'Retail Sale Id 2993',1501.44,0.00,0.00,2.04,122.40,'2023-01-12 13:08:43','',''),(3117,'1','302','1',1,'Retail Sale Id 2994',802.24,0.00,0.00,1.09,65.40,'2023-01-12 13:10:04','',''),(3118,'1','302','1',1,'Retail Sale Id 2995',3002.88,0.00,0.00,4.08,244.80,'2023-01-12 13:15:21','',''),(3119,'1','302','1',1,'Retail Sale Id 2995',3503.36,0.00,0.00,4.76,285.60,'2023-01-12 13:15:21','',''),(3120,'1','302','1',1,'Retail Sale Id 2996',3996.48,0.00,0.00,5.43,325.80,'2023-01-12 13:30:40','',''),(3121,'1','302','1',1,'Retail Sale Id 2997',9200.00,0.00,0.00,12.50,750.00,'2023-01-12 13:31:45','',''),(3122,'1','302','1',1,'Retail Sale Id 2998',802.24,0.00,0.00,1.09,65.40,'2023-01-12 13:32:36','',''),(3123,'1','302','1',1,'Retail Sale Id 2999',1000.96,0.00,0.00,1.36,81.60,'2023-01-12 13:36:56','',''),(3124,'1','302','1',1,'Retail Sale Id 3000',4416.00,0.00,0.00,6.00,360.00,'2023-01-12 13:38:10','',''),(3125,'1','302','1',1,'Retail Sale Id 3001',35500.00,0.00,0.00,50.00,1700.00,'2023-01-12 13:41:17','',''),(3126,'1','302','1',1,'Retail Sale Id 3002',3400.32,0.00,0.00,4.62,277.20,'2023-01-12 13:45:02','',''),(3127,'1','302','1',1,'Retail Sale Id 3002',3400.32,0.00,0.00,4.62,277.20,'2023-01-12 13:45:02','',''),(3128,'1','302','1',1,'Retail Sale Id 3002',3400.32,0.00,0.00,4.62,277.20,'2023-01-12 13:45:02','',''),(3129,'1','302','1',1,'Retail Sale Id 3003',1501.44,0.00,0.00,2.04,122.40,'2023-01-12 13:49:41','',''),(3130,'1','302','1',1,'Retail Sale Id 3004',2502.40,0.00,0.00,3.40,204.00,'2023-01-12 13:56:13','',''),(3131,'1','302','1',1,'Retail Sale Id 3005',4401.28,0.00,0.00,5.98,358.80,'2023-01-12 13:57:23','',''),(3132,'1','302','1',1,'Retail Sale Id 3006',4496.96,0.00,0.00,6.11,366.60,'2023-01-12 14:16:20','',''),(3133,'1','302','1',1,'Retail Sale Id 3007',2001.92,0.00,0.00,2.72,163.20,'2023-01-12 14:20:30','',''),(3134,'1','302','1',1,'Retail Sale Id 3008',3503.36,0.00,0.00,4.76,285.60,'2023-01-12 14:30:19','',''),(3135,'1','302','1',1,'Retail Sale Id 3009',4430.72,0.00,0.00,6.02,361.20,'2023-01-12 14:33:44','',''),(3136,'1','302','1',1,'Retail Sale Id 3010',1000.96,0.00,0.00,1.36,81.60,'2023-01-12 14:38:55','',''),(3137,'1','302','1',1,'Retail Sale Id 3011',3996.48,0.00,0.00,5.43,325.80,'2023-01-12 14:53:52','',''),(3138,'1','302','1',1,'Retail Sale Id 3012',4496.96,0.00,0.00,6.11,366.60,'2023-01-12 15:02:36','',''),(3139,'1','302','1',1,'Retail Sale Id 3013',2502.40,0.00,0.00,3.40,204.00,'2023-01-12 15:03:37','',''),(3140,'1','302','1',1,'Retail Sale Id 3014',4430.72,0.00,0.00,6.02,361.20,'2023-01-12 15:05:12','',''),(3141,'1','302','1',1,'Retail Sale Id 3015',3503.36,0.00,0.00,4.76,285.60,'2023-01-12 15:06:44','',''),(3142,'1','302','1',1,'Retail Sale Id 3016',3002.88,0.00,0.00,4.08,244.80,'2023-01-12 15:08:58','',''),(3143,'1','302','1',1,'Retail Sale Id 3017',9200.00,0.00,0.00,12.50,750.00,'2023-01-12 15:16:02','',''),(3144,'1','302','1',1,'Retail Sale Id 3018',9200.00,0.00,0.00,12.50,750.00,'2023-01-12 15:18:37','',''),(3145,'1','302','1',1,'Retail Sale Id 3019',4496.96,0.00,0.00,6.11,366.60,'2023-01-12 15:22:04','',''),(3146,'1','302','1',1,'Retail Sale Id 3020',4496.96,0.00,0.00,6.11,366.60,'2023-01-12 15:25:26','',''),(3147,'1','302','1',1,'Retail Sale Id 3021',3680.00,0.00,0.00,5.00,300.00,'2023-01-12 15:31:10','',''),(3148,'1','302','1',1,'Retail Sale Id 3021',9200.00,0.00,0.00,12.50,750.00,'2023-01-12 15:31:10','',''),(3149,'1','302','1',1,'Retail Sale Id 3022',3002.88,0.00,0.00,4.08,244.80,'2023-01-12 15:36:46','',''),(3150,'1','302','1',1,'Retail Sale Id 3024',88750.00,0.00,0.00,125.00,4250.00,'2023-01-12 15:40:50','',''),(3151,'1','302','1',1,'Retail Sale Id 3025',35500.00,0.00,0.00,50.00,1700.00,'2023-01-12 15:52:07','',''),(3152,'1','302','1',1,'Retail Sale Id 3026',4997.44,0.00,0.00,6.79,407.40,'2023-01-12 15:54:12','',''),(3153,'1','302','1',1,'Retail Sale Id 3027',4401.28,0.00,0.00,5.98,358.80,'2023-01-12 15:58:05','',''),(3154,'1','302','1',1,'Retail Sale Id 3028',3702.08,0.00,0.00,5.03,301.80,'2023-01-12 15:59:35','',''),(3155,'1','302','1',1,'Retail Sale Id 3030',4416.00,0.00,0.00,6.00,360.00,'2023-01-12 16:04:17','',''),(3156,'1','302','1',1,'Retail Sale Id 3031',4496.96,0.00,0.00,6.11,366.60,'2023-01-12 16:04:58','',''),(3157,'1','302','1',1,'Retail Sale Id 3032',1000.96,0.00,0.00,1.36,81.60,'2023-01-12 16:06:32','',''),(3158,'1','302','1',1,'Retail Sale Id 3033',9200.00,0.00,0.00,12.50,750.00,'2023-01-12 16:12:37','',''),(3159,'1','302','1',1,'Retail Sale Id 3034',2303.68,0.00,0.00,3.13,187.80,'2023-01-12 16:15:28','',''),(3160,'1','302','1',1,'Retail Sale Id 3035',1501.44,0.00,0.00,2.04,122.40,'2023-01-12 16:22:17','',''),(3161,'1','302','1',1,'Retail Sale Id 3036',8898.24,0.00,0.00,12.09,725.40,'2023-01-12 16:28:16','',''),(3162,'1','302','1',1,'Retail Sale Id 3037',2001.92,0.00,0.00,2.72,163.20,'2023-01-12 16:38:49','',''),(3163,'1','302','1',1,'Retail Sale Id 3038',9200.00,0.00,0.00,12.50,750.00,'2023-01-12 16:44:17','',''),(3164,'1','302','1',1,'Retail Sale Id 3039',802.24,0.00,0.00,1.09,65.40,'2023-01-12 16:46:37','',''),(3165,'1','302','1',1,'Retail Sale Id 3040',1000.96,0.00,0.00,1.36,81.60,'2023-01-12 16:47:31','',''),(3166,'1','302','1',1,'Retail Sale Id 3040',1000.96,0.00,0.00,1.36,81.60,'2023-01-12 16:47:31','',''),(3167,'1','302','1',1,'Retail Sale Id 3041',3002.88,0.00,0.00,4.08,244.80,'2023-01-12 16:50:02','',''),(3168,'1','302','1',1,'Retail Sale Id 3042',5680.00,0.00,0.00,8.00,272.00,'2023-01-12 16:54:49','',''),(3169,'1','302','1',1,'Retail Sale Id 3043',2502.40,0.00,0.00,3.40,204.00,'2023-01-12 17:00:12','',''),(3170,'1','302','1',1,'Retail Sale Id 3044',4401.28,0.00,0.00,5.98,358.80,'2023-01-12 17:03:33','',''),(3171,'1','302','1',1,'Retail Sale Id 3044',9200.00,0.00,0.00,12.50,750.00,'2023-01-12 17:03:33','',''),(3172,'1','302','1',1,'Retail Sale Id 3045',2222.72,0.00,0.00,3.02,181.20,'2023-01-12 17:14:47','',''),(3173,'1','302','1',1,'Retail Sale Id 3046',3002.88,0.00,0.00,4.08,244.80,'2023-01-12 17:18:07','',''),(3174,'1','302','1',1,'Retail Sale Id 3047',1000.96,0.00,0.00,1.36,81.60,'2023-01-12 17:19:12','',''),(3175,'1','302','1',1,'Retail Sale Id 3049',2200.64,0.00,0.00,2.99,179.40,'2023-01-12 17:25:36','',''),(3176,'1','302','1',1,'Retail Sale Id 3050',2001.92,0.00,0.00,2.72,163.20,'2023-01-12 17:28:06','',''),(3177,'1','302','1',1,'Retail Sale Id 3051',1501.44,0.00,0.00,2.04,122.40,'2023-01-12 17:34:23','',''),(3178,'1','302','1',1,'Retail Sale Id 3052',2001.92,0.00,0.00,2.72,163.20,'2023-01-12 17:41:02','',''),(3179,'1','302','1',1,'Retail Sale Id 3053',2001.92,0.00,0.00,2.72,163.20,'2023-01-12 17:41:57','',''),(3180,'1','302','1',1,'Retail Sale Id 3054',4423.36,0.00,0.00,6.01,360.60,'2023-01-12 17:45:50','',''),(3181,'1','302','1',1,'Retail Sale Id 3055',18400.00,0.00,0.00,25.00,1500.00,'2023-01-12 17:49:33','',''),(3182,'1','302','1',1,'Retail Sale Id 3056',3503.36,0.00,0.00,4.76,285.60,'2023-01-12 17:54:22','',''),(3183,'1','302','1',1,'Retail Sale Id 3057',3550.00,0.00,0.00,5.00,170.00,'2023-01-12 17:58:09','',''),(3184,'1','302','1',1,'Retail Sale Id 3058',1000.96,0.00,0.00,1.36,81.60,'2023-01-12 18:09:26','',''),(3185,'1','302','1',1,'Retail Sale Id 3059',1501.44,0.00,0.00,2.04,122.40,'2023-01-12 18:18:11','',''),(3186,'1','302','1',1,'Return of Retail Sale Id 3058',0.00,1000.96,1.36,0.00,-81.60,'2023-01-12 18:44:01','',''),(3187,'1','302','1',1,'Retail Sale Id 3060',986.24,0.00,0.00,1.34,80.40,'2023-01-12 18:45:14','',''),(3188,'1','302','1',1,'Retail Sale Id 3061',2001.92,0.00,0.00,2.72,163.20,'2023-01-13 08:07:11','',''),(3189,'1','302','1',1,'Retail Sale Id 3062',4416.00,0.00,0.00,6.00,360.00,'2023-01-13 08:11:34','',''),(3190,'1','302','1',1,'Retail Sale Id 3063',2001.92,0.00,0.00,2.72,163.20,'2023-01-13 08:12:42','',''),(3191,'1','302','1',1,'Retail Sale Id 3064',18400.00,0.00,0.00,25.00,1500.00,'2023-01-13 08:22:56','',''),(3192,'1','302','1',1,'Retail Sale Id 3065',7499.84,0.00,0.00,10.19,611.40,'2023-01-13 08:24:49','',''),(3193,'1','302','1',1,'Retail Sale Id 3066',9200.00,0.00,0.00,12.50,750.00,'2023-01-13 08:25:56','',''),(3194,'1','302','1',1,'Retail Sale Id 3067',17750.00,0.00,0.00,25.00,850.00,'2023-01-13 08:29:45','',''),(3195,'1','302','1',1,'Retail Sale Id 3068',3680.00,0.00,0.00,5.00,300.00,'2023-01-13 08:40:22','',''),(3196,'1','302','1',1,'Retail Sale Id 3069',3002.88,0.00,0.00,4.08,244.80,'2023-01-13 08:42:04','',''),(3197,'1','302','1',1,'Retail Sale Id 3070',4416.00,0.00,0.00,6.00,360.00,'2023-01-13 09:10:40','',''),(3198,'1','302','1',1,'Retail Sale Id 3071',1501.44,0.00,0.00,2.04,122.40,'2023-01-13 09:12:51','',''),(3199,'1','302','1',1,'Retail Sale Id 3072',2208.00,0.00,0.00,3.00,180.00,'2023-01-13 09:19:19','',''),(3200,'1','302','1',1,'Retail Sale Id 3073',2208.00,0.00,0.00,3.00,180.00,'2023-01-13 09:28:06','',''),(3201,'1','302','1',1,'Retail Sale Id 3074',2208.00,0.00,0.00,3.00,180.00,'2023-01-13 09:30:06','',''),(3202,'1','302','1',1,'Retail Sale Id 3074',7360.00,0.00,0.00,10.00,600.00,'2023-01-13 09:30:06','',''),(3203,'1','302','1',1,'Retail Sale Id 3075',8832.00,0.00,0.00,12.00,720.00,'2023-01-13 09:58:25','',''),(3204,'1','302','1',1,'Retail Sale Id 3076',3002.88,0.00,0.00,4.08,244.80,'2023-01-13 09:59:41','',''),(3205,'1','302','1',1,'Retail Sale Id 3077',2001.92,0.00,0.00,2.72,163.20,'2023-01-13 10:01:24','',''),(3206,'1','302','1',1,'Retail Sale Id 3078',4401.28,0.00,0.00,5.98,358.80,'2023-01-13 10:02:37','',''),(3207,'1','302','1',1,'Retail Sale Id 3079',6624.00,0.00,0.00,9.00,540.00,'2023-01-13 10:05:44','',''),(3208,'1','302','1',1,'Retail Sale Id 3080',4416.00,0.00,0.00,6.00,360.00,'2023-01-13 10:07:43','',''),(3209,'1','302','1',1,'Retail Sale Id 3081',3680.00,0.00,0.00,5.00,300.00,'2023-01-13 10:09:35','',''),(3210,'1','302','1',1,'Retail Sale Id 3082',25993.10,0.00,0.00,36.61,1244.74,'2023-01-13 10:13:18','',''),(3211,'1','302','1',1,'Retail Sale Id 3083',1501.44,0.00,0.00,2.04,122.40,'2023-01-13 10:15:19','',''),(3212,'1','302','1',1,'Retail Sale Id 3084',3002.88,0.00,0.00,4.08,244.80,'2023-01-13 10:18:52','',''),(3213,'1','302','1',1,'Retail Sale Id 3085',8397.76,0.00,0.00,11.41,684.60,'2023-01-13 10:25:25','',''),(3214,'1','302','1',1,'Retail Sale Id 3086',1501.44,0.00,0.00,2.04,122.40,'2023-01-13 10:40:23','',''),(3215,'1','302','1',1,'Retail Sale Id 3087',802.24,0.00,0.00,1.09,65.40,'2023-01-13 10:50:02','',''),(3216,'1','302','1',1,'Retail Sale Id 3088',10002.24,0.00,0.00,13.59,815.40,'2023-01-13 10:51:39','',''),(3217,'1','302','1',1,'Retail Sale Id 3089',1000.96,0.00,0.00,1.36,81.60,'2023-01-13 10:52:43','',''),(3218,'1','302','1',1,'Retail Sale Id 3090',2208.00,0.00,0.00,3.00,180.00,'2023-01-13 10:53:52','',''),(3219,'1','302','1',1,'Retail Sale Id 3091',2208.00,0.00,0.00,3.00,180.00,'2023-01-13 11:07:46','',''),(3220,'1','302','1',1,'Retail Sale Id 3092',4496.96,0.00,0.00,6.11,366.60,'2023-01-13 11:16:02','',''),(3221,'1','302','1',1,'Retail Sale Id 3093',2208.00,0.00,0.00,3.00,180.00,'2023-01-13 11:21:46','',''),(3222,'1','302','1',1,'Retail Sale Id 3094',1000.96,0.00,0.00,1.36,81.60,'2023-01-13 11:33:50','',''),(3223,'1','302','1',1,'Retail Sale Id 3095',4416.00,0.00,0.00,6.00,360.00,'2023-01-13 11:36:59','',''),(3224,'1','302','1',1,'Retail Sale Id 3096',2001.92,0.00,0.00,2.72,163.20,'2023-01-13 11:44:54','',''),(3225,'1','302','1',1,'Retail Sale Id 3097',5152.00,0.00,0.00,7.00,420.00,'2023-01-13 11:49:24','',''),(3226,'1','302','1',1,'Retail Sale Id 3097',9200.00,0.00,0.00,12.50,750.00,'2023-01-13 11:49:24','',''),(3227,'1','302','1',1,'Retail Sale Id 3098',1597.12,0.00,0.00,2.17,130.20,'2023-01-13 11:54:51','',''),(3228,'1','302','1',1,'Retail Sale Id 3099',2502.40,0.00,0.00,3.40,204.00,'2023-01-13 11:56:34','',''),(3229,'1','302','1',1,'Retail Sale Id 3100',2001.92,0.00,0.00,2.72,163.20,'2023-01-13 11:57:44','',''),(3230,'1','302','1',1,'Retail Sale Id 3101',4416.00,0.00,0.00,6.00,360.00,'2023-01-13 11:59:09','',''),(3231,'1','302','1',1,'Retail Sale Id 3102',1803.20,0.00,0.00,2.45,147.00,'2023-01-13 12:01:39','',''),(3232,'1','302','1',1,'Retail Sale Id 3103',9200.00,0.00,0.00,12.50,750.00,'2023-01-13 12:03:40','',''),(3233,'1','302','1',1,'Retail Sale Id 3104',3996.48,0.00,0.00,5.43,325.80,'2023-01-13 12:05:12','',''),(3234,'1','302','1',1,'Retail Sale Id 3105',4416.00,0.00,0.00,6.00,360.00,'2023-01-13 12:10:53','',''),(3235,'1','302','1',1,'Retail Sale Id 3106',3002.88,0.00,0.00,4.08,244.80,'2023-01-13 12:16:07','',''),(3236,'1','302','1',1,'Retail Sale Id 3107',4416.00,0.00,0.00,6.00,360.00,'2023-01-13 12:21:25','',''),(3237,'1','302','1',1,'Retail Sale Id 3108',7360.00,0.00,0.00,10.00,600.00,'2023-01-13 12:25:39','',''),(3238,'1','302','1',1,'Retail Sale Id 3109',4416.00,0.00,0.00,6.00,360.00,'2023-01-13 12:28:20','',''),(3239,'1','302','1',1,'Retail Sale Id 3109',4416.00,0.00,0.00,6.00,360.00,'2023-01-13 12:28:20','',''),(3240,'1','302','1',1,'Retail Sale Id 3110',3680.00,0.00,0.00,5.00,300.00,'2023-01-13 12:36:05','',''),(3241,'1','302','1',1,'Retail Sale Id 3111',802.24,0.00,0.00,1.09,65.40,'2023-01-13 12:40:58','',''),(3242,'1','302','1',1,'Retail Sale Id 3112',802.24,0.00,0.00,1.09,65.40,'2023-01-13 12:41:52','',''),(3243,'1','302','1',1,'Retail Sale Id 3113',8096.00,0.00,0.00,11.00,660.00,'2023-01-13 12:58:31','',''),(3244,'1','302','1',1,'Retail Sale Id 3114',1501.44,0.00,0.00,2.04,122.40,'2023-01-13 13:27:29','',''),(3245,'1','302','1',1,'Retail Sale Id 3115',9200.00,0.00,0.00,12.50,750.00,'2023-01-13 13:28:20','',''),(3246,'1','302','1',1,'Retail Sale Id 3117',2200.64,0.00,0.00,2.99,179.40,'2023-01-13 13:32:05','',''),(3247,'1','302','1',1,'Retail Sale Id 3117',3797.76,0.00,0.00,5.16,309.60,'2023-01-13 13:32:05','',''),(3248,'1','302','1',1,'Retail Sale Id 3118',4416.00,0.00,0.00,6.00,360.00,'2023-01-13 13:35:31','',''),(3249,'1','302','1',1,'Retail Sale Id 3119',3002.88,0.00,0.00,4.08,244.80,'2023-01-13 14:02:03','',''),(3250,'1','302','1',1,'Retail Sale Id 3120',2001.92,0.00,0.00,2.72,163.20,'2023-01-13 14:16:10','',''),(3251,'1','302','1',1,'Retail Sale Id 3121',18400.00,0.00,0.00,25.00,1500.00,'2023-01-13 14:20:09','',''),(3252,'1','302','1',1,'Retail Sale Id 3122',4416.00,0.00,0.00,6.00,360.00,'2023-01-13 14:27:56','',''),(3253,'1','302','1',1,'Retail Sale Id 3123',9200.00,0.00,0.00,12.50,750.00,'2023-01-13 14:32:17','',''),(3254,'1','302','1',1,'Retail Sale Id 3124',2944.00,0.00,0.00,4.00,240.00,'2023-01-13 14:42:26','',''),(3255,'1','302','1',1,'Retail Sale Id 3125',4416.00,0.00,0.00,6.00,360.00,'2023-01-13 14:45:16','',''),(3256,'1','302','1',1,'Retail Sale Id 3126',106500.00,0.00,0.00,150.00,5100.00,'2023-01-13 15:09:22','',''),(3257,'1','302','1',1,'Retail Sale Id 3127',1472.00,0.00,0.00,2.00,120.00,'2023-01-13 15:16:19','',''),(3258,'1','302','1',1,'Retail Sale Id 3128',1501.44,0.00,0.00,2.04,122.40,'2023-01-13 15:18:03','',''),(3259,'1','302','1',1,'Retail Sale Id 3129',2208.00,0.00,0.00,3.00,180.00,'2023-01-13 15:18:49','',''),(3260,'1','302','1',1,'Retail Sale Id 3130',2502.40,0.00,0.00,3.40,204.00,'2023-01-13 15:25:02','',''),(3261,'1','302','1',1,'Retail Sale Id 3131',4416.00,0.00,0.00,6.00,360.00,'2023-01-13 15:35:58','',''),(3262,'1','302','1',1,'Retail Sale Id 3132',802.24,0.00,0.00,1.09,65.40,'2023-01-13 15:36:43','',''),(3263,'1','302','1',1,'Retail Sale Id 3133',2252.16,0.00,0.00,3.06,183.60,'2023-01-13 15:38:38','',''),(3264,'1','302','1',1,'Retail Sale Id 3133',2252.16,0.00,0.00,3.06,183.60,'2023-01-13 15:38:38','',''),(3265,'1','302','1',1,'Retail Sale Id 3134',8520.00,0.00,0.00,12.00,408.00,'2023-01-13 15:40:59','',''),(3266,'1','302','1',1,'Retail Sale Id 3135',1803.20,0.00,0.00,2.45,147.00,'2023-01-13 15:49:24','',''),(3267,'1','302','1',1,'Retail Sale Id 3136',3702.08,0.00,0.00,5.03,301.80,'2023-01-13 15:52:07','',''),(3268,'1','302','1',1,'Retail Sale Id 3137',2208.00,0.00,0.00,3.00,180.00,'2023-01-13 15:59:00','',''),(3269,'1','302','1',1,'Retail Sale Id 3138',2001.92,0.00,0.00,2.72,163.20,'2023-01-13 16:00:08','',''),(3270,'1','302','1',1,'Retail Sale Id 3139',2303.68,0.00,0.00,3.13,187.80,'2023-01-13 16:12:53','',''),(3271,'1','302','1',1,'Retail Sale Id 3140',28400.00,0.00,0.00,40.00,1360.00,'2023-01-13 16:15:50','',''),(3272,'1','302','1',1,'Retail Sale Id 3141',35500.00,0.00,0.00,50.00,1700.00,'2023-01-13 16:16:56','',''),(3273,'1','302','1',1,'Retail Sale Id 3142',2208.00,0.00,0.00,3.00,180.00,'2023-01-13 16:18:57','',''),(3274,'1','302','1',1,'Retail Sale Id 3143',2208.00,0.00,0.00,3.00,180.00,'2023-01-13 16:27:13','',''),(3275,'1','302','1',1,'Retail Sale Id 3144',3002.88,0.00,0.00,4.08,244.80,'2023-01-13 16:42:32','',''),(3276,'1','302','1',1,'Retail Sale Id 3145',1501.44,0.00,0.00,2.04,122.40,'2023-01-13 16:43:22','',''),(3277,'1','302','1',1,'Retail Sale Id 3146',1501.44,0.00,0.00,2.04,122.40,'2023-01-13 16:44:56','',''),(3278,'1','302','1',1,'Retail Sale Id 3147',3002.88,0.00,0.00,4.08,244.80,'2023-01-13 16:48:33','',''),(3279,'1','302','1',1,'Retail Sale Id 3148',4416.00,0.00,0.00,6.00,360.00,'2023-01-13 16:52:15','',''),(3280,'1','302','1',1,'Retail Sale Id 3149',9200.00,0.00,0.00,12.50,750.00,'2023-01-13 16:57:20','',''),(3281,'1','302','1',1,'Retail Sale Id 3150',4416.00,0.00,0.00,6.00,360.00,'2023-01-13 17:00:12','',''),(3282,'1','302','1',1,'Retail Sale Id 3151',3996.48,0.00,0.00,5.43,325.80,'2023-01-13 17:02:13','',''),(3283,'1','302','1',1,'Retail Sale Id 3152',9200.00,0.00,0.00,12.50,750.00,'2023-01-13 17:10:08','',''),(3284,'1','302','1',1,'Retail Sale Id 3153',802.24,0.00,0.00,1.09,65.40,'2023-01-13 17:14:37','',''),(3285,'1','302','1',1,'Retail Sale Id 3154',3680.00,0.00,0.00,5.00,300.00,'2023-01-13 17:18:52','',''),(3286,'1','302','1',1,'Retail Sale Id 3155',2208.00,0.00,0.00,3.00,180.00,'2023-01-13 17:21:27','',''),(3287,'1','302','1',1,'Retail Sale Id 3156',7360.00,0.00,0.00,10.00,600.00,'2023-01-13 17:23:36','',''),(3288,'1','302','1',1,'Retail Sale Id 3157',2001.92,0.00,0.00,2.72,163.20,'2023-01-13 17:25:47','',''),(3289,'1','302','1',1,'Retail Sale Id 3158',9230.00,0.00,0.00,13.00,442.00,'2023-01-13 17:27:43','',''),(3290,'1','302','1',1,'Retail Sale Id 3159',9200.00,0.00,0.00,12.50,750.00,'2023-01-13 17:37:53','',''),(3291,'1','302','1',1,'Retail Sale Id 3160',35500.00,0.00,0.00,50.00,1700.00,'2023-01-13 17:39:52','',''),(3292,'1','302','1',1,'Retail Sale Id 3161',4416.00,0.00,0.00,6.00,360.00,'2023-01-13 17:43:10','',''),(3293,'1','302','1',1,'Retail Sale Id 3162',3680.00,0.00,0.00,5.00,300.00,'2023-01-13 17:45:07','',''),(3294,'1','302','1',1,'Retail Sale Id 3163',1000.96,0.00,0.00,1.36,81.60,'2023-01-13 17:47:18','',''),(3295,'1','302','1',1,'Retail Sale Id 3164',9200.00,0.00,0.00,12.50,750.00,'2023-01-13 17:49:58','',''),(3296,'1','302','1',1,'Retail Sale Id 3165',9200.00,0.00,0.00,12.50,750.00,'2023-01-13 17:51:39','',''),(3297,'1','302','1',1,'Retail Sale Id 3166',1000.96,0.00,0.00,1.36,81.60,'2023-01-13 17:53:57','',''),(3298,'1','302','1',1,'Retail Sale Id 3167',2208.00,0.00,0.00,3.00,180.00,'2023-01-13 18:02:10','',''),(3299,'1','302','1',1,'Retail Sale Id 3168',2502.40,0.00,0.00,3.40,204.00,'2023-01-13 18:09:13','',''),(3300,'1','302','1',1,'Retail Sale Id 3169',3996.48,0.00,0.00,5.43,325.80,'2023-01-13 18:11:42','',''),(3301,'1','302','1',1,'Retail Sale Id 3171',198.72,0.00,0.00,0.27,16.20,'2023-01-13 18:28:51','',''),(3302,'1','302','1',1,'Retail Sale Id 3172',4970.00,0.00,0.00,7.00,238.00,'2023-01-13 18:30:17','',''),(3303,'1','302','1',1,'Retail Sale Id 3173',17750.00,0.00,0.00,25.00,850.00,'2023-01-13 18:42:05','',''),(3304,'1','302','1',1,'Return of Retail Sale Id 3171',0.00,198.72,0.27,0.00,-16.20,'2023-01-13 18:52:05','',''),(3305,'1','302','1',1,'Retail Sale Id 3174',198.72,0.00,0.00,0.27,16.20,'2023-01-13 18:55:15','',''),(3306,'1','302','1',1,'Retail Sale Id 3175',7499.84,0.00,0.00,10.19,611.40,'2023-01-14 08:13:37','',''),(3307,'1','302','1',1,'Retail Sale Id 3176',1501.44,0.00,0.00,2.04,122.40,'2023-01-14 08:39:09','',''),(3308,'1','302','1',1,'Retail Sale Id 3177',1000.96,0.00,0.00,1.36,81.60,'2023-01-14 08:47:53','',''),(3309,'1','302','1',1,'Retail Sale Id 3178',9200.00,0.00,0.00,12.50,750.00,'2023-01-14 08:50:16','',''),(3310,'1','302','1',1,'Retail Sale Id 3179',2001.92,0.00,0.00,2.72,163.20,'2023-01-14 08:51:23','',''),(3311,'1','302','1',1,'Retail Sale Id 3180',36800.00,0.00,0.00,50.00,3000.00,'2023-01-14 13:00:30','',''),(3312,'1','302','1',1,'Retail Sale Id 3181',4452.80,0.00,0.00,6.05,363.00,'2023-01-14 13:09:44','',''),(3313,'1','302','1',1,'Retail Sale Id 3182',2200.64,0.00,0.00,2.99,179.40,'2023-01-14 13:12:30','',''),(3314,'1','302','1',1,'Retail Sale Id 3183',710.00,0.00,0.00,1.00,34.00,'2023-01-14 13:27:36','',''),(3315,'1','302','1',1,'Retail Sale Id 3184',1000.96,0.00,0.00,1.36,81.60,'2023-01-14 13:32:41','',''),(3316,'1','302','1',1,'Retail Sale Id 3185',1472.00,0.00,0.00,2.00,120.00,'2023-01-14 13:36:06','',''),(3317,'1','302','1',1,'Retail Sale Id 3186',147936.00,0.00,0.00,201.00,12060.00,'2023-01-14 13:39:35','',''),(3318,'1','302','1',1,'Retail Sale Id 3187',3002.88,0.00,0.00,4.08,244.80,'2023-01-14 13:40:47','',''),(3319,'1','302','1',1,'Retail Sale Id 3188',78100.00,0.00,0.00,110.00,3740.00,'2023-01-14 13:41:58','',''),(3320,'1','302','1',1,'Retail Sale Id 3189',750.72,0.00,0.00,1.02,61.20,'2023-01-14 13:46:42','',''),(3321,'1','302','1',1,'Retail Sale Id 3190',1501.44,0.00,0.00,2.04,122.40,'2023-01-14 13:48:00','',''),(3322,'1','302','1',1,'Retail Sale Id 3191',17750.00,0.00,0.00,25.00,850.00,'2023-01-14 13:59:05','',''),(3323,'1','302','1',1,'Retail Sale Id 3192',1000.96,0.00,0.00,1.36,81.60,'2023-01-14 13:59:43','',''),(3324,'1','302','1',1,'Retail Sale Id 3193',3550.00,0.00,0.00,5.00,170.00,'2023-01-14 14:08:16','',''),(3325,'1','302','1',1,'Retail Sale Id 3194',35500.00,0.00,0.00,50.00,1700.00,'2023-01-14 14:17:52','',''),(3326,'1','302','1',1,'Retail Sale Id 3195',4416.00,0.00,0.00,6.00,360.00,'2023-01-14 14:20:22','',''),(3327,'1','302','1',1,'Retail Sale Id 3196',2252.16,0.00,0.00,3.06,183.60,'2023-01-14 14:25:26','',''),(3328,'1','302','1',1,'Retail Sale Id 3197',750.72,0.00,0.00,1.02,61.20,'2023-01-14 14:36:16','',''),(3329,'1','302','1',1,'Retail Sale Id 3199',1199.68,0.00,0.00,1.63,97.80,'2023-01-14 14:49:14','',''),(3330,'1','302','1',1,'Retail Sale Id 3200',2208.00,0.00,0.00,3.00,180.00,'2023-01-14 14:50:42','',''),(3331,'1','302','1',1,'Retail Sale Id 3200',3680.00,0.00,0.00,5.00,300.00,'2023-01-14 14:50:42','',''),(3332,'1','302','1',1,'Retail Sale Id 3200',9568.00,0.00,0.00,13.00,780.00,'2023-01-14 14:50:42','',''),(3333,'1','302','1',1,'Retail Sale Id 3201',4416.00,0.00,0.00,6.00,360.00,'2023-01-14 14:52:21','',''),(3334,'1','302','1',1,'Retail Sale Id 3202',2208.00,0.00,0.00,3.00,180.00,'2023-01-14 14:53:45','',''),(3335,'1','302','1',1,'Retail Sale Id 3203',1501.44,0.00,0.00,2.04,122.40,'2023-01-14 14:54:35','',''),(3336,'1','302','1',1,'Retail Sale Id 3204',2208.00,0.00,0.00,3.00,180.00,'2023-01-14 14:55:24','',''),(3337,'1','302','1',1,'Retail Sale Id 3205',1626.56,0.00,0.00,2.21,132.60,'2023-01-14 14:58:08','',''),(3338,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,129528.36,191.61,0.00,0.00,'2023-01-14 20:08:41','',''),(3339,'1','302',NULL,1,'Reception corrector for bridging 18',0.00,0.00,0.00,191.61,0.00,'2023-01-14 20:11:54','',''),(3340,'1','302','1',1,'Received from bridging 18',0.00,0.00,191.61,0.00,0.00,'2023-01-14 20:11:54','',''),(3341,'1','302','1',1,'Retail Sale Id 3206',67424.96,0.00,0.00,91.61,5496.60,'2023-01-14 20:13:35','',''),(3342,'1','302','1',1,'Retail Sale Id 3207',71000.00,0.00,0.00,100.00,3400.00,'2023-01-14 20:14:59','',''),(3343,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,174015.92,257.42,0.00,0.00,'2023-01-15 15:34:56','',''),(3344,'1','302',NULL,1,'Reception corrector for bridging 19',0.00,0.00,0.00,257.42,0.00,'2023-01-15 15:36:37','',''),(3345,'1','302','1',1,'Received from bridging 19',0.00,0.00,257.42,0.00,0.00,'2023-01-15 15:36:37','',''),(3346,'1','302','1',1,'Retail Sale Id 3208',71000.00,0.00,0.00,100.00,3400.00,'2023-01-15 15:37:49','',''),(3347,'1','302','1',1,'Retail Sale Id 3209',115861.12,0.00,0.00,157.42,9445.20,'2023-01-15 15:38:59','',''),(3348,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,2028000.00,3000.00,0.00,0.00,'2023-01-15 17:01:48','',''),(3349,'1','302',NULL,1,'Reception corrector for bridging 20',0.00,0.00,0.00,3000.00,0.00,'2023-01-15 17:05:24','',''),(3350,'1','302','1',1,'Received from bridging 20',0.00,0.00,3000.00,0.00,0.00,'2023-01-15 17:05:24','',''),(3351,'1','302','1',1,'Retail Sale Id 3210',286840.00,0.00,0.00,404.00,13736.00,'2023-01-15 17:13:53','',''),(3352,'1','302','1',1,'Retail Sale Id 3211',20401.92,0.00,0.00,27.72,1663.20,'2023-01-15 17:16:19','',''),(3353,'1','302','1',1,'Retail Sale Id 3212',46515.20,0.00,0.00,63.20,3792.00,'2023-01-15 17:17:48','',''),(3354,'1','302','1',1,'Retail Sale Id 3213',32317.76,0.00,0.00,43.91,2634.60,'2023-01-15 17:19:03','',''),(3355,'1','302','1',1,'Retail Sale Id 3214',6498.88,0.00,0.00,8.83,529.80,'2023-01-15 17:21:10','',''),(3356,'1','302','1',1,'Retail Sale Id 3215',33223.04,0.00,0.00,45.14,2708.40,'2023-01-15 17:22:27','',''),(3357,'1','302','1',1,'Retail Sale Id 3216',37823.04,0.00,0.00,51.39,3083.40,'2023-01-15 17:23:55','',''),(3358,'1','302','1',1,'Retail Sale Id 3217',37079.68,0.00,0.00,50.38,3022.80,'2023-01-15 17:25:25','',''),(3359,'1','302','1',1,'Retail Sale Id 3218',1302.72,0.00,0.00,1.77,106.20,'2023-01-15 17:27:39','',''),(3360,'1','302','1',1,'Retail Sale Id 3219',3550.00,0.00,0.00,5.00,170.00,'2023-01-15 17:30:02','',''),(3361,'1','302','1',1,'Retail Sale Id 3220',1398.40,0.00,0.00,1.90,114.00,'2023-01-15 17:36:07','',''),(3362,'1','302','1',1,'Retail Sale Id 3221',2001.92,0.00,0.00,2.72,163.20,'2023-01-15 17:38:45','',''),(3363,'1','302','1',1,'Retail Sale Id 3222',3002.88,0.00,0.00,4.08,244.80,'2023-01-15 17:39:50','',''),(3364,'1','302','1',1,'Retail Sale Id 3223',9200.00,0.00,0.00,12.50,750.00,'2023-01-15 17:45:27','',''),(3365,'1','302','1',1,'Retail Sale Id 3224',3680.00,0.00,0.00,5.00,300.00,'2023-01-15 17:52:04','',''),(3366,'1','302','1',1,'Retail Sale Id 3225',71000.00,0.00,0.00,100.00,3400.00,'2023-01-15 17:53:38','',''),(3367,'1','302','1',1,'Retail Sale Id 3226',2303.68,0.00,0.00,3.13,187.80,'2023-01-15 17:57:22','',''),(3368,'1','302','1',1,'Retail Sale Id 3227',1501.44,0.00,0.00,2.04,122.40,'2023-01-15 17:59:58','',''),(3369,'1','302','1',1,'Retail Sale Id 3228',802.24,0.00,0.00,1.09,65.40,'2023-01-15 18:05:06','',''),(3370,'1','302','1',1,'Retail Sale Id 3229',9200.00,0.00,0.00,12.50,750.00,'2023-01-15 18:13:42','',''),(3371,'1','302','1',1,'Retail Sale Id 3230',4496.96,0.00,0.00,6.11,366.60,'2023-01-15 18:15:55','',''),(3372,'1','302','1',1,'Retail Sale Id 3231',2130.00,0.00,0.00,3.00,102.00,'2023-01-15 18:17:02','',''),(3373,'1','302','1',1,'Retail Sale Id 3232',5910.08,0.00,0.00,8.03,481.80,'2023-01-15 18:33:37','',''),(3374,'1','302','1',1,'Retail Sale Id 3233',1523.52,0.00,0.00,2.07,124.20,'2023-01-15 20:51:57','',''),(3375,'1','302','1',1,'Retail Sale Id 3234',3996.48,0.00,0.00,5.43,325.80,'2023-01-16 07:31:43','',''),(3376,'1','302','1',1,'Retail Sale Id 3235',3002.88,0.00,0.00,4.08,244.80,'2023-01-16 14:36:38','',''),(3377,'1','302','1',1,'Retail Sale Id 3236',3002.88,0.00,0.00,4.08,244.80,'2023-01-16 14:39:16','',''),(3378,'1','302','1',1,'Retail Sale Id 3237',3702.08,0.00,0.00,5.03,301.80,'2023-01-16 14:41:58','',''),(3379,'1','302','1',1,'Retail Sale Id 3238',500.48,0.00,0.00,0.68,40.80,'2023-01-16 15:02:31','',''),(3380,'1','302','1',1,'Retail Sale Id 3239',17750.00,0.00,0.00,25.00,850.00,'2023-01-16 15:06:54','',''),(3381,'1','302','1',1,'Retail Sale Id 3240',4416.00,0.00,0.00,6.00,360.00,'2023-01-16 15:08:19','',''),(3382,'1','302','1',1,'Retail Sale Id 3241',1501.44,0.00,0.00,2.04,122.40,'2023-01-16 15:09:05','',''),(3383,'1','302','1',1,'Retail Sale Id 3242',9200.00,0.00,0.00,12.50,750.00,'2023-01-16 15:17:03','',''),(3384,'1','302','1',1,'Retail Sale Id 3243',17750.00,0.00,0.00,25.00,850.00,'2023-01-16 15:18:49','',''),(3385,'1','302','1',1,'Retail Sale Id 3244',3002.88,0.00,0.00,4.08,244.80,'2023-01-16 15:22:52','',''),(3386,'1','302','1',1,'Retail Sale Id 3245',249366.20,0.00,0.00,351.22,11941.48,'2023-01-16 15:30:04','',''),(3387,'1','302','1',1,'Retail Sale Id 3246',185994.56,0.00,0.00,252.71,15162.60,'2023-01-16 15:48:50','',''),(3388,'1','302','1',1,'Retail Sale Id 3247',4496.96,0.00,0.00,6.11,366.60,'2023-01-16 15:51:04','',''),(3389,'1','302','1',1,'Retail Sale Id 3248',2001.92,0.00,0.00,2.72,163.20,'2023-01-16 15:52:01','',''),(3390,'1','302','1',1,'Retail Sale Id 3249',35500.00,0.00,0.00,50.00,1700.00,'2023-01-16 15:56:30','',''),(3391,'1','302','1',1,'Retail Sale Id 3250',2252.16,0.00,0.00,3.06,183.60,'2023-01-16 15:58:17','',''),(3392,'1','302','1',1,'Retail Sale Id 3251',35500.00,0.00,0.00,50.00,1700.00,'2023-01-16 16:00:52','',''),(3393,'1','302','1',1,'Retail Sale Id 3252',3002.88,0.00,0.00,4.08,244.80,'2023-01-16 16:01:48','',''),(3394,'1','302','1',1,'Retail Sale Id 3253',1501.44,0.00,0.00,2.04,122.40,'2023-01-16 16:02:13','',''),(3395,'1','302','1',1,'Retail Sale Id 3254',2208.00,0.00,0.00,3.00,180.00,'2023-01-16 16:13:53','',''),(3396,'1','302','1',1,'Retail Sale Id 3255',2200.64,0.00,0.00,2.99,179.40,'2023-01-16 16:21:38','',''),(3397,'1','302','1',1,'Retail Sale Id 3256',7360.00,0.00,0.00,10.00,600.00,'2023-01-16 16:25:13','',''),(3398,'1','302','1',1,'Retail Sale Id 3257',6390.00,0.00,0.00,9.00,306.00,'2023-01-16 16:26:35','',''),(3399,'1','302','1',1,'Retail Sale Id 3258',3680.00,0.00,0.00,5.00,300.00,'2023-01-16 16:29:26','',''),(3400,'1','302','1',1,'Retail Sale Id 3259',9200.00,0.00,0.00,12.50,750.00,'2023-01-16 16:30:22','',''),(3401,'1','302','1',1,'Retail Sale Id 3261',9200.00,0.00,0.00,12.50,750.00,'2023-01-16 16:35:11','',''),(3402,'1','302','1',1,'Retail Sale Id 3262',3550.00,0.00,0.00,5.00,170.00,'2023-01-16 16:36:14','',''),(3403,'1','302','1',1,'Retail Sale Id 3263',750.72,0.00,0.00,1.02,61.20,'2023-01-16 16:37:38','',''),(3404,'1','302','1',1,'Retail Sale Id 3264',1000.96,0.00,0.00,1.36,81.60,'2023-01-16 16:40:04','',''),(3405,'1','302','1',1,'Retail Sale Id 3265',9200.00,0.00,0.00,12.50,750.00,'2023-01-16 16:53:29','',''),(3406,'1','302','1',1,'Retail Sale Id 3266',4997.44,0.00,0.00,6.79,407.40,'2023-01-16 16:54:46','',''),(3407,'1','302','1',1,'Retail Sale Id 3267',3702.08,0.00,0.00,5.03,301.80,'2023-01-16 17:02:23','',''),(3408,'1','302','1',1,'Retail Sale Id 3268',1501.44,0.00,0.00,2.04,122.40,'2023-01-16 17:20:23','',''),(3409,'1','302','1',1,'Retail Sale Id 3269',802.24,0.00,0.00,1.09,65.40,'2023-01-16 17:24:47','',''),(3410,'1','302','1',1,'Retail Sale Id 3270',2303.68,0.00,0.00,3.13,187.80,'2023-01-16 17:28:09','',''),(3411,'1','302','1',1,'Retail Sale Id 3271',4496.96,0.00,0.00,6.11,366.60,'2023-01-16 17:29:48','',''),(3412,'1','302','1',1,'Retail Sale Id 3272',2252.16,0.00,0.00,3.06,183.60,'2023-01-16 17:34:19','',''),(3413,'1','302','1',1,'Retail Sale Id 3273',9200.00,0.00,0.00,12.50,750.00,'2023-01-16 17:39:18','',''),(3414,'1','302','1',1,'Retail Sale Id 3274',4452.80,0.00,0.00,6.05,363.00,'2023-01-16 17:45:22','',''),(3415,'1','302','1',1,'Retail Sale Id 3275',2303.68,0.00,0.00,3.13,187.80,'2023-01-16 17:49:48','',''),(3416,'1','302','1',1,'Retail Sale Id 3276',802.24,0.00,0.00,1.09,65.40,'2023-01-16 17:51:29','',''),(3417,'1','302','1',1,'Retail Sale Id 3277',4496.96,0.00,0.00,6.11,366.60,'2023-01-16 17:56:05','',''),(3418,'1','302','1',1,'Retail Sale Id 3278',6035.00,0.00,0.00,8.50,289.00,'2023-01-16 18:06:03','',''),(3419,'1','302','1',1,'Retail Sale Id 3279',2944.00,0.00,0.00,4.00,240.00,'2023-01-16 18:08:22','',''),(3420,'1','302','1',1,'Retail Sale Id 3280',2303.68,0.00,0.00,3.13,187.80,'2023-01-16 18:16:06','',''),(3421,'1','302','1',1,'Retail Sale Id 3281',1000.96,0.00,0.00,1.36,81.60,'2023-01-16 18:17:34','',''),(3422,'1','302','1',1,'Retail Sale Id 3282',3996.48,0.00,0.00,5.43,325.80,'2023-01-16 18:19:42','',''),(3423,'1','302','1',1,'Retail Sale Id 3283',4224.64,0.00,0.00,5.74,344.40,'2023-01-16 18:51:38','',''),(3424,'1','302','1',1,'Retail Sale Id 3284',4496.96,0.00,0.00,6.11,366.60,'2023-01-17 07:33:57','',''),(3425,'1','302','1',1,'Retail Sale Id 3285',9200.00,0.00,0.00,12.50,750.00,'2023-01-17 07:37:47','',''),(3426,'1','302','1',1,'Retail Sale Id 3287',3702.08,0.00,0.00,5.03,301.80,'2023-01-17 08:11:56','',''),(3427,'1','302','1',1,'Retail Sale Id 3288',2303.68,0.00,0.00,3.13,187.80,'2023-01-17 08:25:45','',''),(3428,'1','302','1',1,'Retail Sale Id 3289',1000.96,0.00,0.00,1.36,81.60,'2023-01-17 08:48:43','',''),(3429,'1','302','1',1,'Retail Sale Id 3290',106500.00,0.00,0.00,150.00,5100.00,'2023-01-17 09:03:21','',''),(3430,'1','302','1',1,'Retail Sale Id 3291',4997.44,0.00,0.00,6.79,407.40,'2023-01-17 09:08:51','',''),(3431,'1','302','1',1,'Retail Sale Id 3292',4401.28,0.00,0.00,5.98,358.80,'2023-01-17 09:11:06','',''),(3432,'1','302','1',1,'Retail Sale Id 3293',750.72,0.00,0.00,1.02,61.20,'2023-01-17 09:23:32','',''),(3433,'1','302','1',1,'Retail Sale Id 3294',9200.00,0.00,0.00,12.50,750.00,'2023-01-17 09:24:25','',''),(3434,'1','302','1',1,'Retail Sale Id 3295',2208.00,0.00,0.00,3.00,180.00,'2023-01-17 09:26:29','',''),(3435,'1','302','1',1,'Retail Sale Id 3296',1494.08,0.00,0.00,2.03,121.80,'2023-01-17 09:58:16','',''),(3436,'1','302','1',1,'Retail Sale Id 3296',2208.00,0.00,0.00,3.00,180.00,'2023-01-17 09:58:16','',''),(3437,'1','302','1',1,'Retail Sale Id 3297',1501.44,0.00,0.00,2.04,122.40,'2023-01-17 10:01:57','',''),(3438,'1','302','1',1,'Retail Sale Id 3298',1501.44,0.00,0.00,2.04,122.40,'2023-01-17 10:04:25','',''),(3439,'1','302','1',1,'Retail Sale Id 3299',2303.68,0.00,0.00,3.13,187.80,'2023-01-17 10:12:05','',''),(3440,'1','302','1',1,'Retail Sale Id 3300',4496.96,0.00,0.00,6.11,366.60,'2023-01-17 10:13:39','',''),(3441,'1','302','1',1,'Retail Sale Id 3301',4416.00,0.00,0.00,6.00,360.00,'2023-01-17 10:14:56','',''),(3442,'1','302','1',1,'Retail Sale Id 3302',2208.00,0.00,0.00,3.00,180.00,'2023-01-17 10:17:35','',''),(3443,'1','302','1',1,'Retail Sale Id 3303',750.72,0.00,0.00,1.02,61.20,'2023-01-17 10:18:35','',''),(3444,'1','302','1',1,'Retail Sale Id 3304',2944.00,0.00,0.00,4.00,240.00,'2023-01-17 10:20:00','',''),(3445,'1','302','1',1,'Retail Sale Id 3305',2001.92,0.00,0.00,2.72,163.20,'2023-01-17 10:27:11','',''),(3446,'1','302','1',1,'Retail Sale Id 3306',2502.40,0.00,0.00,3.40,204.00,'2023-01-17 10:29:47','',''),(3447,'1','302','1',1,'Retail Sale Id 3307',3503.36,0.00,0.00,4.76,285.60,'2023-01-17 10:32:54','',''),(3448,'1','302','1',1,'Retail Sale Id 3308',4202.56,0.00,0.00,5.71,342.60,'2023-01-17 10:35:54','',''),(3449,'1','302','1',1,'Retail Sale Id 3309',3680.00,0.00,0.00,5.00,300.00,'2023-01-17 10:38:00','',''),(3450,'1','302','1',1,'Retail Sale Id 3310',500.48,0.00,0.00,0.68,40.80,'2023-01-17 10:50:22','',''),(3451,'1','302','1',1,'Retail Sale Id 3311',18400.00,0.00,0.00,25.00,1500.00,'2023-01-17 10:54:02','',''),(3452,'1','302','1',1,'Retail Sale Id 3312',4496.96,0.00,0.00,6.11,366.60,'2023-01-17 10:56:38','',''),(3453,'1','302','1',1,'Retail Sale Id 3313',699.20,0.00,0.00,0.95,57.00,'2023-01-17 11:06:50','',''),(3454,'1','302','1',1,'Retail Sale Id 3314',4416.00,0.00,0.00,6.00,360.00,'2023-01-17 11:11:40','',''),(3455,'1','302','1',1,'Retail Sale Id 3315',4496.96,0.00,0.00,6.11,366.60,'2023-01-17 11:15:31','',''),(3456,'1','302','1',1,'Retail Sale Id 3316',1700.16,0.00,0.00,2.31,138.60,'2023-01-17 11:16:27','',''),(3457,'1','302','1',1,'Retail Sale Id 3317',18460.00,0.00,0.00,26.00,884.00,'2023-01-17 11:18:46','',''),(3458,'1','302','1',1,'Retail Sale Id 3318',2303.68,0.00,0.00,3.13,187.80,'2023-01-17 11:19:43','',''),(3459,'1','302','1',1,'Retail Sale Id 3319',1501.44,0.00,0.00,2.04,122.40,'2023-01-17 11:20:35','',''),(3460,'1','302','1',1,'Retail Sale Id 3320',1398.40,0.00,0.00,1.90,114.00,'2023-01-17 11:21:32','',''),(3461,'1','302','1',1,'Retail Sale Id 3321',1000.96,0.00,0.00,1.36,81.60,'2023-01-17 11:23:51','',''),(3462,'1','302','1',1,'Retail Sale Id 3322',2001.92,0.00,0.00,2.72,163.20,'2023-01-17 11:26:25','',''),(3463,'1','302','1',1,'Retail Sale Id 3324',7360.00,0.00,0.00,10.00,600.00,'2023-01-17 11:28:11','',''),(3464,'1','302','1',1,'Retail Sale Id 3325',4416.00,0.00,0.00,6.00,360.00,'2023-01-17 11:30:19','',''),(3465,'1','302','1',1,'Retail Sale Id 3326',2222.72,0.00,0.00,3.02,181.20,'2023-01-17 11:33:12','',''),(3466,'1','302','1',1,'Retail Sale Id 3326',3680.00,0.00,0.00,5.00,300.00,'2023-01-17 11:33:12','',''),(3467,'1','302','1',1,'Retail Sale Id 3327',2208.00,0.00,0.00,3.00,180.00,'2023-01-17 11:35:16','',''),(3468,'1','302','1',1,'Retail Sale Id 3328',3680.00,0.00,0.00,5.00,300.00,'2023-01-17 11:41:20','',''),(3469,'1','302','1',1,'Retail Sale Id 3329',1501.44,0.00,0.00,2.04,122.40,'2023-01-17 11:54:43','',''),(3470,'1','302','1',1,'Retail Sale Id 3330',3680.00,0.00,0.00,5.00,300.00,'2023-01-17 12:07:11','',''),(3471,'1','302','1',1,'Retail Sale Id 3331',1000.96,0.00,0.00,1.36,81.60,'2023-01-17 12:08:02','',''),(3472,'1','302','1',1,'Retail Sale Id 3332',2001.92,0.00,0.00,2.72,163.20,'2023-01-17 12:13:32','',''),(3473,'1','302','1',1,'Retail Sale Id 3333',2208.00,0.00,0.00,3.00,180.00,'2023-01-17 12:14:45','',''),(3474,'1','302','1',1,'Retail Sale Id 3334',9200.00,0.00,0.00,12.50,750.00,'2023-01-17 12:20:28','',''),(3475,'1','302','1',1,'Retail Sale Id 3335',35500.00,0.00,0.00,50.00,1700.00,'2023-01-17 12:22:06','',''),(3476,'1','302','1',1,'Retail Sale Id 3336',2208.00,0.00,0.00,3.00,180.00,'2023-01-17 12:24:11','',''),(3477,'1','302','1',1,'Retail Sale Id 3337',1501.44,0.00,0.00,2.04,122.40,'2023-01-17 12:29:26','',''),(3478,'1','302','1',1,'Retail Sale Id 3338',4260.00,0.00,0.00,6.00,204.00,'2023-01-17 12:38:53','',''),(3479,'1','302','1',1,'Retail Sale Id 3339',2001.92,0.00,0.00,2.72,163.20,'2023-01-17 12:44:36','',''),(3480,'1','302','1',1,'Retail Sale Id 3340',736.00,0.00,0.00,1.00,60.00,'2023-01-17 12:47:01','',''),(3481,'1','302','1',1,'Retail Sale Id 3341',2001.92,0.00,0.00,2.72,163.20,'2023-01-17 12:54:56','',''),(3482,'1','302','1',1,'Retail Sale Id 3342',2208.00,0.00,0.00,3.00,180.00,'2023-01-17 13:08:40','',''),(3483,'1','302','1',1,'Retail Sale Id 3343',2130.00,0.00,0.00,3.00,102.00,'2023-01-17 13:24:54','',''),(3484,'1','302','1',1,'Retail Sale Id 3344',9200.00,0.00,0.00,12.50,750.00,'2023-01-17 13:26:20','',''),(3485,'1','302','1',1,'Retail Sale Id 3345',8832.00,0.00,0.00,12.00,720.00,'2023-01-17 13:33:42','',''),(3486,'1','302','1',1,'Retail Sale Id 3346',17750.00,0.00,0.00,25.00,850.00,'2023-01-17 13:35:07','',''),(3487,'1','302','1',1,'Retail Sale Id 3347',35500.00,0.00,0.00,50.00,1700.00,'2023-01-17 13:49:07','',''),(3488,'1','302','1',1,'Retail Sale Id 3348',9200.00,0.00,0.00,12.50,750.00,'2023-01-17 13:50:29','',''),(3489,'1','302','1',1,'Retail Sale Id 3349',4416.00,0.00,0.00,6.00,360.00,'2023-01-17 14:04:45','',''),(3490,'1','302','1',1,'Retail Sale Id 3350',4997.44,0.00,0.00,6.79,407.40,'2023-01-17 14:05:38','',''),(3491,'1','302','1',1,'Retail Sale Id 3351',1000.96,0.00,0.00,1.36,81.60,'2023-01-17 14:13:49','',''),(3492,'1','302','1',1,'Retail Sale Id 3352',3680.00,0.00,0.00,5.00,300.00,'2023-01-17 14:15:08','',''),(3493,'1','302','1',1,'Retail Sale Id 3353',2130.00,0.00,0.00,3.00,102.00,'2023-01-17 14:16:17','',''),(3494,'1','302','1',1,'Retail Sale Id 3354',1501.44,0.00,0.00,2.04,122.40,'2023-01-17 14:29:04','',''),(3495,'1','302','1',1,'Retail Sale Id 3355',2001.92,0.00,0.00,2.72,163.20,'2023-01-17 14:36:36','',''),(3496,'1','302','1',1,'Retail Sale Id 3356',1501.44,0.00,0.00,2.04,122.40,'2023-01-17 14:37:33','',''),(3497,'1','302','1',1,'Retail Sale Id 3357',4423.36,0.00,0.00,6.01,360.60,'2023-01-17 14:49:40','',''),(3498,'1','302','1',1,'Retail Sale Id 3358',2502.40,0.00,0.00,3.40,204.00,'2023-01-17 14:59:25','',''),(3499,'1','302','1',1,'Retail Sale Id 3359',9200.00,0.00,0.00,12.50,750.00,'2023-01-17 15:00:35','',''),(3500,'1','302','1',1,'Retail Sale Id 3361',3997.30,0.00,0.00,5.63,191.42,'2023-01-17 15:06:50','',''),(3501,'1','302','1',1,'Retail Sale Id 3362',4416.00,0.00,0.00,6.00,360.00,'2023-01-17 15:08:21','',''),(3502,'1','302','1',1,'Retail Sale Id 3363',2208.00,0.00,0.00,3.00,180.00,'2023-01-17 15:12:17','',''),(3503,'1','302','1',1,'Retail Sale Id 3364',2208.00,0.00,0.00,3.00,180.00,'2023-01-17 15:13:54','',''),(3504,'1','302','1',1,'Retail Sale Id 3365',1000.96,0.00,0.00,1.36,81.60,'2023-01-17 15:24:22','',''),(3505,'1','302','1',1,'Retail Sale Id 3366',1000.96,0.00,0.00,1.36,81.60,'2023-01-17 15:29:58','',''),(3506,'1','302','1',1,'Retail Sale Id 3367',3680.00,0.00,0.00,5.00,300.00,'2023-01-17 15:32:24','',''),(3507,'1','302','1',1,'Retail Sale Id 3368',1501.44,0.00,0.00,2.04,122.40,'2023-01-17 15:39:53','',''),(3508,'1','302','1',1,'Retail Sale Id 3369',9200.00,0.00,0.00,12.50,750.00,'2023-01-17 16:01:16','',''),(3509,'1','302','1',1,'Retail Sale Id 3370',3702.08,0.00,0.00,5.03,301.80,'2023-01-17 16:03:39','',''),(3510,'1','302','1',1,'Retail Sale Id 3371',1501.44,0.00,0.00,2.04,122.40,'2023-01-17 16:13:36','',''),(3511,'1','302','1',1,'Retail Sale Id 3372',4416.00,0.00,0.00,6.00,360.00,'2023-01-17 16:21:09','',''),(3512,'1','302','1',1,'Retail Sale Id 3373',9200.00,0.00,0.00,12.50,750.00,'2023-01-17 16:32:46','',''),(3513,'1','302','1',1,'Retail Sale Id 3374',2200.64,0.00,0.00,2.99,179.40,'2023-01-17 16:36:33','',''),(3514,'1','302','1',1,'Retail Sale Id 3375',9200.00,0.00,0.00,12.50,750.00,'2023-01-17 16:37:51','',''),(3515,'1','302','1',1,'Retail Sale Id 3376',3002.88,0.00,0.00,4.08,244.80,'2023-01-17 16:38:38','',''),(3516,'1','302','1',1,'Retail Sale Id 3377',1000.96,0.00,0.00,1.36,81.60,'2023-01-17 16:42:04','',''),(3517,'1','302','1',1,'Retail Sale Id 3378',4496.96,0.00,0.00,6.11,366.60,'2023-01-17 16:43:03','',''),(3518,'1','302','1',1,'Retail Sale Id 3379',1501.44,0.00,0.00,2.04,122.40,'2023-01-17 16:43:49','',''),(3519,'1','302','1',1,'Retail Sale Id 3380',4423.36,0.00,0.00,6.01,360.60,'2023-01-17 16:45:35','',''),(3520,'1','302','1',1,'Retail Sale Id 3381',9200.00,0.00,0.00,12.50,750.00,'2023-01-17 16:48:50','',''),(3521,'1','302','1',1,'Retail Sale Id 3382',4496.96,0.00,0.00,6.11,366.60,'2023-01-17 16:54:49','',''),(3522,'1','302','1',1,'Retail Sale Id 3383',9200.00,0.00,0.00,12.50,750.00,'2023-01-17 17:03:32','',''),(3523,'1','302','1',1,'Retail Sale Id 3384',3680.00,0.00,0.00,5.00,300.00,'2023-01-17 17:05:27','',''),(3524,'1','302','1',1,'Retail Sale Id 3385',4423.36,0.00,0.00,6.01,360.60,'2023-01-17 17:07:17','',''),(3525,'1','302','1',1,'Retail Sale Id 3386',3201.60,0.00,0.00,4.35,261.00,'2023-01-17 17:08:38','',''),(3526,'1','302','1',1,'Retail Sale Id 3387',4416.00,0.00,0.00,6.00,360.00,'2023-01-17 17:15:15','',''),(3527,'1','302','1',1,'Retail Sale Id 3387',9200.00,0.00,0.00,12.50,750.00,'2023-01-17 17:15:15','',''),(3528,'1','302','1',1,'Retail Sale Id 3388',1501.44,0.00,0.00,2.04,122.40,'2023-01-17 17:16:29','',''),(3529,'1','302','1',1,'Retail Sale Id 3389',3503.36,0.00,0.00,4.76,285.60,'2023-01-17 17:21:03','',''),(3530,'1','302','1',1,'Retail Sale Id 3390',17750.00,0.00,0.00,25.00,850.00,'2023-01-17 17:33:40','',''),(3531,'1','302','1',1,'Retail Sale Id 3391',7100.00,0.00,0.00,10.00,340.00,'2023-01-17 17:56:44','',''),(3532,'1','302','1',1,'Retail Sale Id 3392',2001.92,0.00,0.00,2.72,163.20,'2023-01-17 17:57:35','',''),(3533,'1','302','1',1,'Retail Sale Id 3393',1501.44,0.00,0.00,2.04,122.40,'2023-01-17 18:02:18','',''),(3534,'1','302','1',1,'Retail Sale Id 3394',1501.44,0.00,0.00,2.04,122.40,'2023-01-17 18:03:09','',''),(3535,'1','302','1',1,'Retail Sale Id 3395',1501.44,0.00,0.00,2.04,122.40,'2023-01-17 18:05:42','',''),(3536,'1','302','1',1,'Retail Sale Id 3396',2200.64,0.00,0.00,2.99,179.40,'2023-01-17 18:13:58','',''),(3537,'1','302','1',1,'Retail Sale Id 3397',35500.00,0.00,0.00,50.00,1700.00,'2023-01-17 18:15:31','',''),(3538,'1','302','1',1,'Retail Sale Id 3399',2252.16,0.00,0.00,3.06,183.60,'2023-01-17 18:21:36','',''),(3539,'1','302','1',1,'Retail Sale Id 3399',2252.16,0.00,0.00,3.06,183.60,'2023-01-17 18:21:36','',''),(3540,'1','302','1',1,'Retail Sale Id 3400',3002.88,0.00,0.00,4.08,244.80,'2023-01-17 18:28:14','',''),(3541,'1','302','1',1,'Return of Retail Sale Id 3395',0.00,1501.44,2.04,0.00,-122.40,'2023-01-17 19:01:34','',''),(3542,'1','302','1',1,'Retail Sale Id 3401',1383.68,0.00,0.00,1.88,112.80,'2023-01-17 19:03:01','',''),(3543,'1','302','1',1,'Return of Retail Sale Id 3343',0.00,2130.00,3.00,0.00,-102.00,'2023-01-17 19:04:30','',''),(3544,'1','302','1',1,'Retail Sale Id 3402',2130.00,0.00,0.00,3.00,102.00,'2023-01-17 19:06:53','',''),(3545,'1','302','1',1,'Retail Sale Id 3403',59078.72,0.00,0.00,80.27,4816.20,'2023-01-18 09:13:32','',''),(3546,'1','302','1',1,'Retail Sale Id 3404',35500.00,0.00,0.00,50.00,1700.00,'2023-01-18 09:15:19','',''),(3547,'1','302','1',1,'Retail Sale Id 3405',77631.40,0.00,0.00,109.34,3717.56,'2023-01-18 09:17:14','',''),(3548,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,338000.00,500.00,0.00,0.00,'2023-01-18 15:30:37','',''),(3549,'1','302',NULL,1,'Reception corrector for bridging 21',0.00,0.00,0.00,500.00,0.00,'2023-01-18 15:32:13','',''),(3550,'1','302','1',1,'Received from bridging 21',0.00,0.00,500.00,0.00,0.00,'2023-01-18 15:32:13','',''),(3551,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,50159.20,74.20,0.00,0.00,'2023-01-18 15:35:01','',''),(3552,'1','302',NULL,1,'Reception corrector for bridging 22',0.00,0.00,0.00,74.20,0.00,'2023-01-18 15:36:42','',''),(3553,'1','302','1',1,'Received from bridging 22',0.00,0.00,74.20,0.00,0.00,'2023-01-18 15:36:42','',''),(3554,'1','302','1',1,'Retail Sale Id 3406',353.28,0.00,0.00,0.48,28.80,'2023-01-18 15:52:39','',''),(3555,'1','302','1',1,'Retail Sale Id 3407',328020.00,0.00,0.00,462.00,15708.00,'2023-01-18 15:55:12','',''),(3556,'1','302','1',1,'Return of Retail Sale Id 3407',0.00,328020.00,462.00,0.00,-15708.00,'2023-01-18 15:58:33','',''),(3557,'1','302','1',1,'Retail Sale Id 3408',214888.60,0.00,0.00,302.66,10290.44,'2023-01-18 16:01:35','',''),(3558,'1','302','1',1,'Retail Sale Id 3409',199500.16,0.00,0.00,271.06,16263.60,'2023-01-18 16:06:26','',''),(3559,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,676.00,1.00,0.00,0.00,'2023-01-18 16:33:19','',''),(3560,'1','302',NULL,1,'Reception corrector for bridging 23',0.00,0.00,0.00,1.00,0.00,'2023-01-18 16:35:32','',''),(3561,'1','302','1',1,'Received from bridging 23',0.00,0.00,1.00,0.00,0.00,'2023-01-18 16:35:32','',''),(3562,'1','302','1',1,'Retail Sale Id 3410',103.04,0.00,0.00,0.14,8.40,'2023-01-18 16:37:17','',''),(3563,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3650400.00,5400.00,0.00,0.00,'2023-01-18 16:46:37','',''),(3564,'1','302',NULL,1,'Reception corrector for bridging 24',0.00,0.00,0.00,5400.00,0.00,'2023-01-18 19:10:31','',''),(3565,'1','302','1',1,'Received from bridging 24',0.00,0.00,5400.00,0.00,0.00,'2023-01-18 19:10:31','',''),(3566,'1','302','1',1,'Retail Sale Id 3414',178752.32,0.00,0.00,242.87,14572.20,'2023-01-18 19:11:29','',''),(3567,'1','302','1',1,'Retail Sale Id 3415',108275.00,0.00,0.00,152.50,5185.00,'2023-01-18 19:13:04','',''),(3568,'1','302','1',1,'Retail Sale Id 3416',9001.28,0.00,0.00,12.23,733.80,'2023-01-19 10:04:46','',''),(3569,'1','302','1',1,'Retail Sale Id 3417',4496.96,0.00,0.00,6.11,366.60,'2023-01-19 10:05:50','',''),(3570,'1','302','1',1,'Retail Sale Id 3418',56075.84,0.00,0.00,76.19,4571.40,'2023-01-19 10:06:38','',''),(3571,'1','302','1',1,'Retail Sale Id 3419',2303.68,0.00,0.00,3.13,187.80,'2023-01-19 10:14:40','',''),(3572,'1','302','1',1,'Retail Sale Id 3420',327665.00,0.00,0.00,461.50,15691.00,'2023-01-19 18:28:30','',''),(3573,'1','302','1',1,'Retail Sale Id 3421',274189.44,0.00,0.00,372.54,22352.40,'2023-01-19 18:34:18','',''),(3574,'1','302','1',1,'Retail Sale Id 3422',95.68,0.00,0.00,0.13,7.80,'2023-01-19 19:02:24','',''),(3575,'1','302','1',1,'Retail Sale Id 3423',2944.00,0.00,0.00,4.00,240.00,'2023-01-20 07:36:19','',''),(3576,'1','302','1',1,'Retail Sale Id 3425',1000.96,0.00,0.00,1.36,81.60,'2023-01-20 07:37:30','',''),(3577,'1','302','1',1,'Retail Sale Id 3426',2001.92,0.00,0.00,2.72,163.20,'2023-01-20 07:42:45','',''),(3578,'1','302','1',1,'Retail Sale Id 3427',1501.44,0.00,0.00,2.04,122.40,'2023-01-20 07:53:14','',''),(3579,'1','302','1',1,'Retail Sale Id 3428',9200.00,0.00,0.00,12.50,750.00,'2023-01-20 07:55:23','',''),(3580,'1','302','1',1,'Retail Sale Id 3429',4496.96,0.00,0.00,6.11,366.60,'2023-01-20 08:13:39','',''),(3581,'1','302','1',1,'Retail Sale Id 3432',9200.00,0.00,0.00,12.50,750.00,'2023-01-20 08:19:12','',''),(3582,'1','302','1',1,'Retail Sale Id 3433',4496.96,0.00,0.00,6.11,366.60,'2023-01-20 08:23:25','',''),(3583,'1','302','1',1,'Retail Sale Id 3438',9200.00,0.00,0.00,12.50,750.00,'2023-01-20 08:41:55','',''),(3584,'1','302','1',1,'Retail Sale Id 3439',4416.00,0.00,0.00,6.00,360.00,'2023-01-20 08:44:19','',''),(3585,'1','302','1',1,'Retail Sale Id 3443',30175.00,0.00,0.00,42.50,1445.00,'2023-01-20 08:53:49','',''),(3586,'1','302','1',1,'Retail Sale Id 3444',177500.00,0.00,0.00,250.00,8500.00,'2023-01-20 09:03:51','',''),(3587,'1','302','1',1,'Retail Sale Id 3445',9200.00,0.00,0.00,12.50,750.00,'2023-01-20 09:09:29','',''),(3588,'1','302','1',1,'Retail Sale Id 3446',4416.00,0.00,0.00,6.00,360.00,'2023-01-20 09:12:57','',''),(3589,'1','302','1',1,'Retail Sale Id 3447',3680.00,0.00,0.00,5.00,300.00,'2023-01-20 09:16:52','',''),(3590,'1','302','1',1,'Retail Sale Id 3448',1501.44,0.00,0.00,2.04,122.40,'2023-01-20 09:18:57','',''),(3591,'1','302','1',1,'Retail Sale Id 3451',4416.00,0.00,0.00,6.00,360.00,'2023-01-20 09:21:24','',''),(3592,'1','302','1',1,'Retail Sale Id 3451',9200.00,0.00,0.00,12.50,750.00,'2023-01-20 09:21:24','',''),(3593,'1','302','1',1,'Retail Sale Id 3453',1501.44,0.00,0.00,2.04,122.40,'2023-01-20 09:29:14','',''),(3594,'1','302','1',1,'Retail Sale Id 3454',4496.96,0.00,0.00,6.11,366.60,'2023-01-20 09:31:10','',''),(3595,'1','302','1',1,'Retail Sale Id 3455',2001.92,0.00,0.00,2.72,163.20,'2023-01-20 09:44:55','',''),(3596,'1','302','1',1,'Retail Sale Id 3457',3002.88,0.00,0.00,4.08,244.80,'2023-01-20 09:48:36','',''),(3597,'1','302','1',1,'Retail Sale Id 3458',9200.00,0.00,0.00,12.50,750.00,'2023-01-20 09:55:37','',''),(3598,'1','302','1',1,'Retail Sale Id 3459',2252.16,0.00,0.00,3.06,183.60,'2023-01-20 10:05:43','',''),(3599,'1','302','1',1,'Retail Sale Id 3459',2252.16,0.00,0.00,3.06,183.60,'2023-01-20 10:05:43','',''),(3600,'1','302','1',1,'Retail Sale Id 3460',4416.00,0.00,0.00,6.00,360.00,'2023-01-20 10:15:59','',''),(3601,'1','302','1',1,'Retail Sale Id 3462',9200.00,0.00,0.00,12.50,750.00,'2023-01-20 10:17:31','',''),(3602,'1','302','1',1,'Retail Sale Id 3463',1501.44,0.00,0.00,2.04,122.40,'2023-01-20 10:18:41','',''),(3603,'1','302','1',1,'Retail Sale Id 3465',3702.08,0.00,0.00,5.03,301.80,'2023-01-20 10:30:42','',''),(3604,'1','302','1',1,'Retail Sale Id 3466',1000.96,0.00,0.00,1.36,81.60,'2023-01-20 10:47:59','',''),(3605,'1','302','1',1,'Retail Sale Id 3468',231170.24,0.00,0.00,314.09,18845.40,'2023-01-20 19:33:19','',''),(3606,'1','302','1',1,'Retail Sale Id 3469',111825.00,0.00,0.00,157.50,5355.00,'2023-01-20 19:35:42','',''),(3607,'1','302','1',1,'Retail Sale Id 3470',419453.80,0.00,0.00,590.78,20086.52,'2023-01-21 14:55:49','',''),(3608,'1','302','1',1,'Retail Sale Id 3471',274778.24,0.00,0.00,373.34,22400.40,'2023-01-21 14:57:20','',''),(3609,'1','302','1',1,'Retail Sale Id 3472',3002.88,0.00,0.00,4.08,244.80,'2023-01-21 14:58:39','',''),(3610,'1','302','1',1,'Retail Sale Id 3473',3550.00,0.00,0.00,5.00,170.00,'2023-01-21 15:08:03','',''),(3611,'1','302','1',1,'Retail Sale Id 3474',79520.00,0.00,0.00,112.00,3808.00,'2023-01-21 15:21:57','',''),(3612,'1','302','1',1,'Retail Sale Id 3475',2208.00,0.00,0.00,3.00,180.00,'2023-01-21 15:28:42','',''),(3613,'1','302','1',1,'Retail Sale Id 3476',2208.00,0.00,0.00,3.00,180.00,'2023-01-21 15:35:13','',''),(3614,'1','302','1',1,'Retail Sale Id 3477',1000.96,0.00,0.00,1.36,81.60,'2023-01-21 15:39:54','',''),(3615,'1','302','1',1,'Retail Sale Id 3478',2502.40,0.00,0.00,3.40,204.00,'2023-01-21 15:53:36','',''),(3616,'1','302','1',1,'Retail Sale Id 3480',2303.68,0.00,0.00,3.13,187.80,'2023-01-21 15:54:19','',''),(3617,'1','302','1',1,'Retail Sale Id 3481',750.72,0.00,0.00,1.02,61.20,'2023-01-21 15:58:54','',''),(3618,'1','302','1',1,'Retail Sale Id 3482',4496.96,0.00,0.00,6.11,366.60,'2023-01-21 16:01:45','',''),(3619,'1','302','1',1,'Retail Sale Id 3483',4496.96,0.00,0.00,6.11,366.60,'2023-01-21 16:13:13','',''),(3620,'1','302','1',1,'Retail Sale Id 3484',1501.44,0.00,0.00,2.04,122.40,'2023-01-21 16:14:02','',''),(3621,'1','302','1',1,'Retail Sale Id 3485',4423.36,0.00,0.00,6.01,360.60,'2023-01-21 16:30:36','',''),(3622,'1','302','1',1,'Retail Sale Id 3486',3680.00,0.00,0.00,5.00,300.00,'2023-01-21 16:31:20','',''),(3623,'1','302','1',1,'Retail Sale Id 3487',2001.92,0.00,0.00,2.72,163.20,'2023-01-21 16:32:28','',''),(3624,'1','302','1',1,'Retail Sale Id 3488',3002.88,0.00,0.00,4.08,244.80,'2023-01-21 16:39:59','',''),(3625,'1','302','1',1,'Retail Sale Id 3489',3481.28,0.00,0.00,4.73,283.80,'2023-01-21 16:41:27','',''),(3626,'1','302','1',1,'Retail Sale Id 3490',2701.12,0.00,0.00,3.67,220.20,'2023-01-21 16:43:59','',''),(3627,'1','302','1',1,'Retail Sale Id 3491',4260.00,0.00,0.00,6.00,204.00,'2023-01-21 16:49:02','',''),(3628,'1','302','1',1,'Retail Sale Id 3492',1501.44,0.00,0.00,2.04,122.40,'2023-01-21 16:54:11','',''),(3629,'1','302','1',1,'Retail Sale Id 3493',2944.00,0.00,0.00,4.00,240.00,'2023-01-21 16:58:18','',''),(3630,'1','302','1',1,'Retail Sale Id 3494',3680.00,0.00,0.00,5.00,300.00,'2023-01-21 17:03:56','',''),(3631,'1','302','1',1,'Retail Sale Id 3495',1501.44,0.00,0.00,2.04,122.40,'2023-01-21 17:15:14','',''),(3632,'1','302','1',1,'Retail Sale Id 3496',9200.00,0.00,0.00,12.50,750.00,'2023-01-21 17:17:12','',''),(3633,'1','302','1',1,'Retail Sale Id 3497',2208.00,0.00,0.00,3.00,180.00,'2023-01-21 17:18:03','',''),(3634,'1','302','1',1,'Retail Sale Id 3498',4416.00,0.00,0.00,6.00,360.00,'2023-01-21 17:19:53','',''),(3635,'1','302','1',1,'Return of Retail Sale Id 3494',0.00,3680.00,5.00,0.00,-300.00,'2023-01-21 17:29:02','',''),(3636,'1','302','1',1,'Retail Sale Id 3499',2001.92,0.00,0.00,2.72,163.20,'2023-01-21 17:29:31','',''),(3637,'1','302','1',1,'Retail Sale Id 3500',2200.64,0.00,0.00,2.99,179.40,'2023-01-21 17:31:11','',''),(3638,'1','302','1',1,'Retail Sale Id 3501',2208.00,0.00,0.00,3.00,180.00,'2023-01-21 17:35:02','',''),(3639,'1','302','1',1,'Retail Sale Id 3503',3002.88,0.00,0.00,4.08,244.80,'2023-01-21 17:51:45','',''),(3640,'1','302','1',1,'Retail Sale Id 3504',7100.00,0.00,0.00,10.00,340.00,'2023-01-21 17:52:35','',''),(3641,'1','302','1',1,'Retail Sale Id 3505',4997.44,0.00,0.00,6.79,407.40,'2023-01-21 17:53:28','',''),(3642,'1','302','1',1,'Retail Sale Id 3506',3702.08,0.00,0.00,5.03,301.80,'2023-01-21 17:54:35','',''),(3643,'1','302','1',1,'Retail Sale Id 3507',18400.00,0.00,0.00,25.00,1500.00,'2023-01-21 19:17:23','',''),(3644,'1','302','1',1,'Retail Sale Id 3508',35500.00,0.00,0.00,50.00,1700.00,'2023-01-21 19:18:41','',''),(3645,'1','302','1',1,'Retail Sale Id 3509',5888.00,0.00,0.00,8.00,480.00,'2023-01-21 19:20:06','',''),(3646,'1','302','1',1,'Retail Sale Id 3510',4202.56,0.00,0.00,5.71,342.60,'2023-01-21 19:21:30','',''),(3647,'1','302','1',1,'Retail Sale Id 3511',581.44,0.00,0.00,0.79,47.40,'2023-01-21 21:06:30','',''),(3648,'1','302','1',1,'Retail Sale Id 3512',13498.24,0.00,0.00,18.34,1100.40,'2023-01-22 08:22:19','',''),(3649,'1','302','1',1,'Retail Sale Id 3513',3002.88,0.00,0.00,4.08,244.80,'2023-01-22 08:33:15','',''),(3650,'1','302','1',1,'Retail Sale Id 3514',2208.00,0.00,0.00,3.00,180.00,'2023-01-22 08:34:21','',''),(3651,'1','302','1',1,'Retail Sale Id 3515',2252.16,0.00,0.00,3.06,183.60,'2023-01-22 08:35:30','',''),(3652,'1','302','1',1,'Retail Sale Id 3516',7499.84,0.00,0.00,10.19,611.40,'2023-01-22 08:36:43','',''),(3653,'1','302','1',1,'Retail Sale Id 3517',3002.88,0.00,0.00,4.08,244.80,'2023-01-22 08:37:39','',''),(3654,'1','302','1',1,'Retail Sale Id 3518',6999.36,0.00,0.00,9.51,570.60,'2023-01-22 08:38:31','',''),(3655,'1','302','1',1,'Retail Sale Id 3519',2001.92,0.00,0.00,2.72,163.20,'2023-01-22 08:42:42','',''),(3656,'1','302','1',1,'Retail Sale Id 3520',3996.48,0.00,0.00,5.43,325.80,'2023-01-22 08:44:26','',''),(3657,'1','302','1',1,'Retail Sale Id 3522',500.48,0.00,0.00,0.68,40.80,'2023-01-22 08:46:43','',''),(3658,'1','302','1',1,'Retail Sale Id 3523',2252.16,0.00,0.00,3.06,183.60,'2023-01-22 08:47:54','',''),(3659,'1','302','1',1,'Retail Sale Id 3524',3702.08,0.00,0.00,5.03,301.80,'2023-01-22 08:55:29','',''),(3660,'1','302','1',1,'Retail Sale Id 3525',802.24,0.00,0.00,1.09,65.40,'2023-01-22 08:56:40','',''),(3661,'1','302','1',1,'Retail Sale Id 3526',3002.88,0.00,0.00,4.08,244.80,'2023-01-22 09:02:19','',''),(3662,'1','302','1',1,'Retail Sale Id 3527',4496.96,0.00,0.00,6.11,366.60,'2023-01-22 09:07:39','',''),(3663,'1','302','1',1,'Retail Sale Id 3528',4416.00,0.00,0.00,6.00,360.00,'2023-01-22 09:09:06','',''),(3664,'1','302','1',1,'Retail Sale Id 3529',2502.40,0.00,0.00,3.40,204.00,'2023-01-22 09:25:40','',''),(3665,'1','302','1',1,'Retail Sale Id 3530',1501.44,0.00,0.00,2.04,122.40,'2023-01-22 09:29:59','',''),(3666,'1','302','1',1,'Retail Sale Id 3531',26270.00,0.00,0.00,37.00,1258.00,'2023-01-22 09:33:13','',''),(3667,'1','302','1',1,'Retail Sale Id 3532',2252.16,0.00,0.00,3.06,183.60,'2023-01-22 09:35:17','',''),(3668,'1','302','1',1,'Retail Sale Id 3533',802.24,0.00,0.00,1.09,65.40,'2023-01-22 09:37:35','',''),(3669,'1','302','1',1,'Retail Sale Id 3534',35500.00,0.00,0.00,50.00,1700.00,'2023-01-22 09:38:29','',''),(3670,'1','302','1',1,'Retail Sale Id 3535',4997.44,0.00,0.00,6.79,407.40,'2023-01-22 09:39:36','',''),(3671,'1','302','1',1,'Retail Sale Id 3536',9200.00,0.00,0.00,12.50,750.00,'2023-01-22 09:41:17','',''),(3672,'1','302','1',1,'Retail Sale Id 3537',1501.44,0.00,0.00,2.04,122.40,'2023-01-22 09:42:04','',''),(3673,'1','302','1',1,'Retail Sale Id 3538',3002.88,0.00,0.00,4.08,244.80,'2023-01-22 09:49:30','',''),(3674,'1','302','1',1,'Retail Sale Id 3539',4416.00,0.00,0.00,6.00,360.00,'2023-01-22 09:55:44','',''),(3675,'1','302','1',1,'Retail Sale Id 3540',4496.96,0.00,0.00,6.11,366.60,'2023-01-22 09:56:24','',''),(3676,'1','302','1',1,'Retail Sale Id 3541',1501.44,0.00,0.00,2.04,122.40,'2023-01-22 09:58:14','',''),(3677,'1','302','1',1,'Retail Sale Id 3542',9501.76,0.00,0.00,12.91,774.60,'2023-01-22 10:00:37','',''),(3678,'1','302','1',1,'Retail Sale Id 3543',2303.68,0.00,0.00,3.13,187.80,'2023-01-22 10:03:19','',''),(3679,'1','302','1',1,'Retail Sale Id 3544',1501.44,0.00,0.00,2.04,122.40,'2023-01-22 10:04:27','',''),(3680,'1','302','1',1,'Retail Sale Id 3545',2208.00,0.00,0.00,3.00,180.00,'2023-01-22 10:06:02','',''),(3681,'1','302','1',1,'Retail Sale Id 3546',4416.00,0.00,0.00,6.00,360.00,'2023-01-22 10:07:13','',''),(3682,'1','302','1',1,'Retail Sale Id 3547',7360.00,0.00,0.00,10.00,600.00,'2023-01-22 10:08:46','',''),(3683,'1','302','1',1,'Retail Sale Id 3548',2001.92,0.00,0.00,2.72,163.20,'2023-01-22 10:09:43','',''),(3684,'1','302','1',1,'Retail Sale Id 3548',2001.92,0.00,0.00,2.72,163.20,'2023-01-22 10:09:43','',''),(3685,'1','302','1',1,'Retail Sale Id 3549',2502.40,0.00,0.00,3.40,204.00,'2023-01-22 10:10:33','',''),(3686,'1','302','1',1,'Retail Sale Id 3550',4496.96,0.00,0.00,6.11,366.60,'2023-01-22 10:12:28','',''),(3687,'1','302','1',1,'Retail Sale Id 3551',9200.00,0.00,0.00,12.50,750.00,'2023-01-22 10:14:14','',''),(3688,'1','302','1',1,'Retail Sale Id 3552',4496.96,0.00,0.00,6.11,366.60,'2023-01-22 10:18:28','',''),(3689,'1','302','1',1,'Retail Sale Id 3553',3680.00,0.00,0.00,5.00,300.00,'2023-01-22 10:19:47','',''),(3690,'1','302','1',1,'Retail Sale Id 3554',2001.92,0.00,0.00,2.72,163.20,'2023-01-22 10:23:30','',''),(3691,'1','302','1',1,'Retail Sale Id 3555',3002.88,0.00,0.00,4.08,244.80,'2023-01-22 10:24:43','',''),(3692,'1','302','1',1,'Retail Sale Id 3556',1501.44,0.00,0.00,2.04,122.40,'2023-01-22 10:25:23','',''),(3693,'1','302','1',1,'Retail Sale Id 3557',3731.52,0.00,0.00,5.07,304.20,'2023-01-22 10:31:17','',''),(3694,'1','302','1',1,'Retail Sale Id 3558',3002.88,0.00,0.00,4.08,244.80,'2023-01-22 10:34:38','',''),(3695,'1','302','1',1,'Retail Sale Id 3559',1501.44,0.00,0.00,2.04,122.40,'2023-01-22 10:44:51','',''),(3696,'1','302','1',1,'Retail Sale Id 3560',5203.52,0.00,0.00,7.07,424.20,'2023-01-22 10:46:59','',''),(3697,'1','302','1',1,'Retail Sale Id 3561',2208.00,0.00,0.00,3.00,180.00,'2023-01-22 10:51:50','',''),(3698,'1','302','1',1,'Retail Sale Id 3562',9200.00,0.00,0.00,12.50,750.00,'2023-01-22 10:54:18','',''),(3699,'1','302','1',1,'Retail Sale Id 3563',9200.00,0.00,0.00,12.50,750.00,'2023-01-22 10:55:35','',''),(3700,'1','302','1',1,'Retail Sale Id 3564',2001.92,0.00,0.00,2.72,163.20,'2023-01-22 10:56:54','',''),(3701,'1','302','1',1,'Retail Sale Id 3565',7360.00,0.00,0.00,10.00,600.00,'2023-01-22 10:59:55','',''),(3702,'1','302','1',1,'Retail Sale Id 3566',9200.00,0.00,0.00,12.50,750.00,'2023-01-22 11:09:15','',''),(3703,'1','302','1',1,'Retail Sale Id 3567',3002.88,0.00,0.00,4.08,244.80,'2023-01-22 11:16:01','',''),(3704,'1','302','1',1,'Retail Sale Id 3568',4496.96,0.00,0.00,6.11,366.60,'2023-01-22 11:20:48','',''),(3705,'1','302','1',1,'Retail Sale Id 3569',9200.00,0.00,0.00,12.50,750.00,'2023-01-22 11:21:40','',''),(3706,'1','302','1',1,'Retail Sale Id 3570',2303.68,0.00,0.00,3.13,187.80,'2023-01-22 11:22:48','',''),(3707,'1','302','1',1,'Retail Sale Id 3571',1501.44,0.00,0.00,2.04,122.40,'2023-01-22 11:27:36','',''),(3708,'1','302','1',1,'Retail Sale Id 3572',2303.68,0.00,0.00,3.13,187.80,'2023-01-22 11:33:55','',''),(3709,'1','302','1',1,'Retail Sale Id 3573',1501.44,0.00,0.00,2.04,122.40,'2023-01-22 11:35:10','',''),(3710,'1','302','1',1,'Retail Sale Id 3574',9200.00,0.00,0.00,12.50,750.00,'2023-01-22 11:36:18','',''),(3711,'1','302','1',1,'Retail Sale Id 3575',2208.00,0.00,0.00,3.00,180.00,'2023-01-22 11:38:54','',''),(3712,'1','302','1',1,'Retail Sale Id 3576',9200.00,0.00,0.00,12.50,750.00,'2023-01-22 11:40:10','',''),(3713,'1','302','1',1,'Retail Sale Id 3577',14200.00,0.00,0.00,20.00,680.00,'2023-01-22 11:49:20','',''),(3714,'1','302','1',1,'Retail Sale Id 3578',2252.16,0.00,0.00,3.06,183.60,'2023-01-22 11:50:26','',''),(3715,'1','302','1',1,'Retail Sale Id 3579',3297.28,0.00,0.00,4.48,268.80,'2023-01-22 11:51:28','',''),(3716,'1','302','1',1,'Retail Sale Id 3580',1000.96,0.00,0.00,1.36,81.60,'2023-01-22 11:53:32','',''),(3717,'1','302','1',1,'Retail Sale Id 3581',4970.00,0.00,0.00,7.00,238.00,'2023-01-22 11:59:44','',''),(3718,'1','302','1',1,'Retail Sale Id 3582',3996.48,0.00,0.00,5.43,325.80,'2023-01-22 12:04:00','',''),(3719,'1','302','1',1,'Retail Sale Id 3583',9200.00,0.00,0.00,12.50,750.00,'2023-01-22 12:06:19','',''),(3720,'1','302','1',1,'Retail Sale Id 3584',1501.44,0.00,0.00,2.04,122.40,'2023-01-22 12:07:11','',''),(3721,'1','302','1',1,'Retail Sale Id 3585',1000.96,0.00,0.00,1.36,81.60,'2023-01-22 12:09:10','',''),(3722,'1','302','1',1,'Retail Sale Id 3586',1000.96,0.00,0.00,1.36,81.60,'2023-01-22 12:12:57','',''),(3723,'1','302','1',1,'Retail Sale Id 3588',2252.16,0.00,0.00,3.06,183.60,'2023-01-22 12:14:12','',''),(3724,'1','302','1',1,'Retail Sale Id 3589',2208.00,0.00,0.00,3.00,180.00,'2023-01-22 13:31:49','',''),(3725,'1','302','1',1,'Retail Sale Id 3589',2208.00,0.00,0.00,3.00,180.00,'2023-01-22 13:31:49','',''),(3726,'1','302','1',1,'Retail Sale Id 3589',4416.00,0.00,0.00,6.00,360.00,'2023-01-22 13:31:49','',''),(3727,'1','302','1',1,'Retail Sale Id 3590',7291.70,0.00,0.00,10.27,349.18,'2023-01-22 14:27:23','',''),(3728,'1','302','1',1,'Retail Sale Id 3591',8520.00,0.00,0.00,12.00,408.00,'2023-01-22 16:25:34','',''),(3729,'1','302','1',1,'Retail Sale Id 3592',104136.64,0.00,0.00,141.49,8489.40,'2023-01-22 16:31:50','',''),(3730,'1','302','1',1,'Retail Sale Id 3593',2200.64,0.00,0.00,2.99,179.40,'2023-01-22 16:38:52','',''),(3731,'1','302','1',1,'Retail Sale Id 3594',3002.88,0.00,0.00,4.08,244.80,'2023-01-22 16:39:58','',''),(3732,'1','302','1',1,'Retail Sale Id 3595',3680.00,0.00,0.00,5.00,300.00,'2023-01-22 16:41:11','',''),(3733,'1','302','1',1,'Retail Sale Id 3596',1501.44,0.00,0.00,2.04,122.40,'2023-01-22 16:45:53','',''),(3734,'1','302','1',1,'Retail Sale Id 3597',2208.00,0.00,0.00,3.00,180.00,'2023-01-22 16:47:19','',''),(3735,'1','302','1',1,'Retail Sale Id 3598',35003.00,0.00,0.00,49.30,1676.20,'2023-01-22 17:05:19','',''),(3736,'1','302','1',1,'Retail Sale Id 3599',802.24,0.00,0.00,1.09,65.40,'2023-01-22 17:19:29','',''),(3737,'1','302','1',1,'Retail Sale Id 3600',9001.28,0.00,0.00,12.23,733.80,'2023-01-22 17:21:38','',''),(3738,'1','302','1',1,'Retail Sale Id 3601',3680.00,0.00,0.00,5.00,300.00,'2023-01-22 17:22:12','',''),(3739,'1','302','1',1,'Retail Sale Id 3602',2001.92,0.00,0.00,2.72,163.20,'2023-01-22 17:26:26','',''),(3740,'1','302','1',1,'Retail Sale Id 3603',35500.00,0.00,0.00,50.00,1700.00,'2023-01-22 17:45:02','',''),(3741,'1','302','1',1,'Retail Sale Id 3604',1501.44,0.00,0.00,2.04,122.40,'2023-01-22 17:46:32','',''),(3742,'1','302','1',1,'Retail Sale Id 3605',9303.04,0.00,0.00,12.64,758.40,'2023-01-22 17:50:26','',''),(3743,'1','302','1',1,'Retail Sale Id 3606',17750.00,0.00,0.00,25.00,850.00,'2023-01-22 17:53:21','',''),(3744,'1','302','1',1,'Retail Sale Id 3607',35500.00,0.00,0.00,50.00,1700.00,'2023-01-22 17:59:48','',''),(3745,'1','302','1',1,'Retail Sale Id 3608',2208.00,0.00,0.00,3.00,180.00,'2023-01-22 18:02:19','',''),(3746,'1','302','1',1,'Retail Sale Id 3608',5792.32,0.00,0.00,7.87,472.20,'2023-01-22 18:02:19','',''),(3747,'1','302','1',1,'Retail Sale Id 3609',500.48,0.00,0.00,0.68,40.80,'2023-01-22 18:05:15','',''),(3748,'1','302','1',1,'Retail Sale Id 3610',1501.44,0.00,0.00,2.04,122.40,'2023-01-22 18:06:05','',''),(3749,'1','302','1',1,'Retail Sale Id 3611',1000.96,0.00,0.00,1.36,81.60,'2023-01-22 18:14:33','',''),(3750,'1','302','1',1,'Retail Sale Id 3612',397.44,0.00,0.00,0.54,32.40,'2023-01-22 18:14:57','',''),(3751,'1','302','1',1,'Retail Sale Id 3613',2222.72,0.00,0.00,3.02,181.20,'2023-01-22 18:21:02','',''),(3752,'1','302','1',1,'Retail Sale Id 3614',73.60,0.00,0.00,0.10,6.00,'2023-01-22 20:10:08','',''),(3753,'1','302','1',1,'Retail Sale Id 3615',3002.88,0.00,0.00,4.08,244.80,'2023-01-23 07:53:03','',''),(3754,'1','302','1',1,'Retail Sale Id 3616',4496.96,0.00,0.00,6.11,366.60,'2023-01-23 07:54:37','',''),(3755,'1','302','1',1,'Retail Sale Id 3617',2001.92,0.00,0.00,2.72,163.20,'2023-01-23 08:10:54','',''),(3756,'1','302','1',1,'Retail Sale Id 3618',3680.00,0.00,0.00,5.00,300.00,'2023-01-23 08:17:40','',''),(3757,'1','302','1',1,'Retail Sale Id 3619',35500.00,0.00,0.00,50.00,1700.00,'2023-01-23 08:26:40','',''),(3758,'1','302','1',1,'Retail Sale Id 3620',3702.08,0.00,0.00,5.03,301.80,'2023-01-23 08:31:56','',''),(3759,'1','302','1',1,'Retail Sale Id 3621',2001.92,0.00,0.00,2.72,163.20,'2023-01-23 08:36:09','',''),(3760,'1','302','1',1,'Retail Sale Id 3622',1501.44,0.00,0.00,2.04,122.40,'2023-01-23 08:39:54','',''),(3761,'1','302','1',1,'Retail Sale Id 3623',2200.64,0.00,0.00,2.99,179.40,'2023-01-23 08:49:56','',''),(3762,'1','302','1',1,'Retail Sale Id 3624',4401.28,0.00,0.00,5.98,358.80,'2023-01-23 08:54:51','',''),(3763,'1','302','1',1,'Retail Sale Id 3625',2001.92,0.00,0.00,2.72,163.20,'2023-01-23 08:57:13','',''),(3764,'1','302','1',1,'Retail Sale Id 3626',3599.04,0.00,0.00,4.89,293.40,'2023-01-23 09:00:01','',''),(3765,'1','302','1',1,'Retail Sale Id 3627',2208.00,0.00,0.00,3.00,180.00,'2023-01-23 09:16:32','',''),(3766,'1','302','1',1,'Retail Sale Id 3627',4416.00,0.00,0.00,6.00,360.00,'2023-01-23 09:16:32','',''),(3767,'1','302','1',1,'Retail Sale Id 3628',35500.00,0.00,0.00,50.00,1700.00,'2023-01-23 09:41:38','',''),(3768,'1','302','1',1,'Retail Sale Id 3629',71000.00,0.00,0.00,100.00,3400.00,'2023-01-23 09:48:51','',''),(3769,'1','302','1',1,'Retail Sale Id 3630',3702.08,0.00,0.00,5.03,301.80,'2023-01-23 09:50:52','',''),(3770,'1','302','1',1,'Retail Sale Id 3631',2252.16,0.00,0.00,3.06,183.60,'2023-01-23 09:58:49','',''),(3771,'1','302','1',1,'Retail Sale Id 3632',4496.96,0.00,0.00,6.11,366.60,'2023-01-23 10:02:03','',''),(3772,'1','302','1',1,'Retail Sale Id 3633',2097.60,0.00,0.00,2.85,171.00,'2023-01-23 10:12:14','',''),(3773,'1','302','1',1,'Retail Sale Id 3634',2200.64,0.00,0.00,2.99,179.40,'2023-01-23 10:14:25','',''),(3774,'1','302','1',1,'Retail Sale Id 3635',2208.00,0.00,0.00,3.00,180.00,'2023-01-23 10:16:40','',''),(3775,'1','302','1',1,'Retail Sale Id 3636',1862.08,0.00,0.00,2.53,151.80,'2023-01-23 10:28:04','',''),(3776,'1','302','1',1,'Retail Sale Id 3637',79328.30,0.00,0.00,111.73,3798.82,'2023-01-23 10:36:08','',''),(3777,'1','302','1',1,'Retail Sale Id 3638',9200.00,0.00,0.00,12.50,750.00,'2023-01-23 10:49:04','',''),(3778,'1','302','1',1,'Retail Sale Id 3639',3002.88,0.00,0.00,4.08,244.80,'2023-01-23 10:49:56','',''),(3779,'1','302','1',1,'Retail Sale Id 3640',802.24,0.00,0.00,1.09,65.40,'2023-01-23 10:54:03','',''),(3780,'1','302','1',1,'Retail Sale Id 3641',4416.00,0.00,0.00,6.00,360.00,'2023-01-23 11:00:40','',''),(3781,'1','302','1',1,'Retail Sale Id 3641',4416.00,0.00,0.00,6.00,360.00,'2023-01-23 11:00:40','',''),(3782,'1','302','1',1,'Retail Sale Id 3642',1199.68,0.00,0.00,1.63,97.80,'2023-01-23 11:04:28','',''),(3783,'1','302','1',1,'Retail Sale Id 3643',500.48,0.00,0.00,0.68,40.80,'2023-01-23 11:21:39','',''),(3784,'1','302','1',1,'Retail Sale Id 3644',1501.44,0.00,0.00,2.04,122.40,'2023-01-23 11:22:28','',''),(3785,'1','302','1',1,'Retail Sale Id 3645',5888.00,0.00,0.00,8.00,480.00,'2023-01-23 11:29:01','',''),(3786,'1','302','1',1,'Retail Sale Id 3646',9200.00,0.00,0.00,12.50,750.00,'2023-01-23 12:02:17','',''),(3787,'1','302','1',1,'Retail Sale Id 3647',2502.40,0.00,0.00,3.40,204.00,'2023-01-23 12:05:01','',''),(3788,'1','302','1',1,'Retail Sale Id 3648',4496.96,0.00,0.00,6.11,366.60,'2023-01-23 12:05:58','',''),(3789,'1','302','1',1,'Retail Sale Id 3649',2502.40,0.00,0.00,3.40,204.00,'2023-01-23 12:06:58','',''),(3790,'1','302','1',1,'Retail Sale Id 3650',4416.00,0.00,0.00,6.00,360.00,'2023-01-23 12:09:33','',''),(3791,'1','302','1',1,'Retail Sale Id 3651',7810.00,0.00,0.00,11.00,374.00,'2023-01-23 12:15:09','',''),(3792,'1','302','1',1,'Retail Sale Id 3652',3002.88,0.00,0.00,4.08,244.80,'2023-01-23 12:15:57','',''),(3793,'1','302','1',1,'Retail Sale Id 3653',2001.92,0.00,0.00,2.72,163.20,'2023-01-23 12:26:17','',''),(3794,'1','302','1',1,'Retail Sale Id 3654',802.24,0.00,0.00,1.09,65.40,'2023-01-23 12:27:10','',''),(3795,'1','302','1',1,'Retail Sale Id 3655',17750.00,0.00,0.00,25.00,850.00,'2023-01-23 12:30:59','',''),(3796,'1','302','1',1,'Retail Sale Id 3656',2208.00,0.00,0.00,3.00,180.00,'2023-01-23 12:34:39','',''),(3797,'1','302','1',1,'Retail Sale Id 3657',3550.00,0.00,0.00,5.00,170.00,'2023-01-23 12:52:28','',''),(3798,'1','302','1',1,'Retail Sale Id 3658',3996.48,0.00,0.00,5.43,325.80,'2023-01-23 12:54:51','',''),(3799,'1','302','1',1,'Retail Sale Id 3659',44020.00,0.00,0.00,62.00,2108.00,'2023-01-23 12:58:46','',''),(3800,'1','302','1',1,'Retail Sale Id 3660',4496.96,0.00,0.00,6.11,366.60,'2023-01-23 13:01:20','',''),(3801,'1','302','1',1,'Retail Sale Id 3661',3002.88,0.00,0.00,4.08,244.80,'2023-01-23 13:04:54','',''),(3802,'1','302','1',1,'Retail Sale Id 3662',71000.00,0.00,0.00,100.00,3400.00,'2023-01-23 13:21:02','',''),(3803,'1','302','1',1,'Retail Sale Id 3663',9200.00,0.00,0.00,12.50,750.00,'2023-01-23 13:23:00','',''),(3804,'1','302','1',1,'Retail Sale Id 3664',3702.08,0.00,0.00,5.03,301.80,'2023-01-23 13:56:29','',''),(3805,'1','302','1',1,'Retail Sale Id 3665',2252.16,0.00,0.00,3.06,183.60,'2023-01-23 14:09:22','',''),(3806,'1','302','1',1,'Retail Sale Id 3666',35500.00,0.00,0.00,50.00,1700.00,'2023-01-23 14:16:26','',''),(3807,'1','302','1',1,'Retail Sale Id 3667',9200.00,0.00,0.00,12.50,750.00,'2023-01-23 14:19:16','',''),(3808,'1','302','1',1,'Retail Sale Id 3668',2303.68,0.00,0.00,3.13,187.80,'2023-01-23 14:20:10','',''),(3809,'1','302','1',1,'Retail Sale Id 3669',3702.08,0.00,0.00,5.03,301.80,'2023-01-23 14:21:51','',''),(3810,'1','302','1',1,'Retail Sale Id 3670',7396.80,0.00,0.00,10.05,603.00,'2023-01-23 14:33:20','',''),(3811,'1','302','1',1,'Retail Sale Id 3671',2001.92,0.00,0.00,2.72,163.20,'2023-01-23 14:38:17','',''),(3812,'1','302','1',1,'Retail Sale Id 3672',9001.28,0.00,0.00,12.23,733.80,'2023-01-23 14:44:02','',''),(3813,'1','302','1',1,'Retail Sale Id 3673',9200.00,0.00,0.00,12.50,750.00,'2023-01-23 14:51:45','',''),(3814,'1','302','1',1,'Retail Sale Id 3674',17750.00,0.00,0.00,25.00,850.00,'2023-01-23 15:15:40','',''),(3815,'1','302','1',1,'Retail Sale Id 3675',2001.92,0.00,0.00,2.72,163.20,'2023-01-23 15:16:31','',''),(3816,'1','302','1',1,'Retail Sale Id 3676',1501.44,0.00,0.00,2.04,122.40,'2023-01-23 15:17:18','',''),(3817,'1','302','1',1,'Retail Sale Id 3677',5998.40,0.00,0.00,8.15,489.00,'2023-01-23 15:18:05','',''),(3818,'1','302','1',1,'Retail Sale Id 3678',3002.88,0.00,0.00,4.08,244.80,'2023-01-23 15:23:21','',''),(3819,'1','302','1',1,'Retail Sale Id 3679',2200.64,0.00,0.00,2.99,179.40,'2023-01-23 15:34:35','',''),(3820,'1','302','1',1,'Retail Sale Id 3680',4416.00,0.00,0.00,6.00,360.00,'2023-01-23 15:46:40','',''),(3821,'1','302','1',1,'Retail Sale Id 3680',4416.00,0.00,0.00,6.00,360.00,'2023-01-23 15:46:40','',''),(3822,'1','302','1',1,'Retail Sale Id 3680',4416.00,0.00,0.00,6.00,360.00,'2023-01-23 15:46:40','',''),(3823,'1','302','1',1,'Retail Sale Id 3681',2001.92,0.00,0.00,2.72,163.20,'2023-01-23 15:47:19','',''),(3824,'1','302','1',1,'Retail Sale Id 3682',14200.00,0.00,0.00,20.00,680.00,'2023-01-23 16:10:48','',''),(3825,'1','302','1',1,'Retail Sale Id 3683',6035.20,0.00,0.00,8.20,492.00,'2023-01-23 16:12:45','',''),(3826,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,73190.52,108.27,0.00,0.00,'2023-01-23 21:02:17','',''),(3827,'1','302',NULL,1,'Reception corrector for bridging 25',0.00,0.00,0.00,108.27,0.00,'2023-01-23 21:04:18','',''),(3828,'1','302','1',1,'Received from bridging 25',0.00,0.00,108.27,0.00,0.00,'2023-01-23 21:04:18','',''),(3829,'1','302','1',1,'Retail Sale Id 3684',76452.80,0.00,0.00,107.68,3661.12,'2023-01-23 21:07:52','',''),(3830,'1','302','1',1,'Return of Retail Sale Id 3657',0.00,3550.00,5.00,0.00,-170.00,'2023-01-23 21:10:54','',''),(3831,'1','302','1',1,'Retail Sale Id 3685',3507.40,0.00,0.00,4.94,167.96,'2023-01-23 21:12:47','',''),(3832,'1','302','1',1,'Return of Retail Sale Id 3676',0.00,1501.44,2.04,0.00,-122.40,'2023-01-23 21:16:35','',''),(3833,'1','302','1',1,'Retail Sale Id 3686',1494.08,0.00,0.00,2.03,121.80,'2023-01-23 21:17:40','',''),(3834,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3515400.00,5400.00,0.00,0.00,'2023-01-23 21:58:50','',''),(3835,'1','302',NULL,1,'Reception corrector for bridging 26',0.00,0.00,0.00,5400.00,0.00,'2023-01-23 22:01:26','',''),(3836,'1','302','1',1,'Received from bridging 26',0.00,0.00,5400.00,0.00,0.00,'2023-01-23 22:01:26','',''),(3837,'1','302','1',1,'Retail Sale Id 3687',56031.68,0.00,0.00,76.13,6471.05,'2023-01-23 22:09:36','',''),(3838,'1','302','1',1,'Retail Sale Id 3688',279882.00,0.00,0.00,394.20,23257.80,'2023-01-23 22:12:19','',''),(3839,'1','302','1',1,'Retail Sale Id 3689',4452.80,0.00,0.00,6.05,514.25,'2023-01-24 07:30:44','',''),(3840,'1','302','1',1,'Retail Sale Id 3690',1501.44,0.00,0.00,2.04,173.40,'2023-01-24 08:03:59','',''),(3841,'1','302','1',1,'Retail Sale Id 3691',4496.96,0.00,0.00,6.11,519.35,'2023-01-24 08:19:10','',''),(3842,'1','302','1',1,'Retail Sale Id 3693',1000.96,0.00,0.00,1.36,115.60,'2023-01-24 08:20:50','',''),(3843,'1','302','1',1,'Retail Sale Id 3694',1000.96,0.00,0.00,1.36,115.60,'2023-01-24 08:31:55','',''),(3844,'1','302','1',1,'Retail Sale Id 3695',2252.16,0.00,0.00,3.06,260.10,'2023-01-24 08:40:34','',''),(3845,'1','302','1',1,'Retail Sale Id 3696',4997.44,0.00,0.00,6.79,577.15,'2023-01-24 08:48:13','',''),(3846,'1','302','1',1,'Retail Sale Id 3697',2303.68,0.00,0.00,3.13,266.05,'2023-01-24 08:52:40','',''),(3847,'1','302','1',1,'Retail Sale Id 3698',7360.00,0.00,0.00,10.00,850.00,'2023-01-24 08:55:26','',''),(3848,'1','302','1',1,'Retail Sale Id 3699',3680.00,0.00,0.00,5.00,425.00,'2023-01-24 09:00:02','',''),(3849,'1','302','1',1,'Retail Sale Id 3700',4496.96,0.00,0.00,6.11,519.35,'2023-01-24 09:01:29','',''),(3850,'1','302','1',1,'Retail Sale Id 3701',1000.96,0.00,0.00,1.36,115.60,'2023-01-24 09:03:07','',''),(3851,'1','302','1',1,'Retail Sale Id 3702',6182.40,0.00,0.00,8.40,714.00,'2023-01-24 09:08:46','',''),(3852,'1','302','1',1,'Retail Sale Id 3703',2001.92,0.00,0.00,2.72,231.20,'2023-01-24 09:13:12','',''),(3853,'1','302','1',1,'Retail Sale Id 3704',3702.08,0.00,0.00,5.03,427.55,'2023-01-24 09:24:04','',''),(3854,'1','302','1',1,'Retail Sale Id 3705',1501.44,0.00,0.00,2.04,173.40,'2023-01-24 09:25:21','',''),(3855,'1','302','1',1,'Retail Sale Id 3706',699.20,0.00,0.00,0.95,80.75,'2023-01-24 09:30:49','',''),(3856,'1','302','1',1,'Retail Sale Id 3707',20000.70,0.00,0.00,28.17,1662.03,'2023-01-24 09:50:40','',''),(3857,'1','302','1',1,'Retail Sale Id 3708',1501.44,0.00,0.00,2.04,173.40,'2023-01-24 09:51:45','',''),(3858,'1','302','1',1,'Retail Sale Id 3709',35500.00,0.00,0.00,50.00,2950.00,'2023-01-24 09:54:01','',''),(3859,'1','302','1',1,'Retail Sale Id 3710',106500.00,0.00,0.00,150.00,8850.00,'2023-01-24 09:57:26','',''),(3860,'1','302','1',1,'Retail Sale Id 3711',802.24,0.00,0.00,1.09,92.65,'2023-01-24 09:58:59','',''),(3861,'1','302','1',1,'Retail Sale Id 3712',11715.00,0.00,0.00,16.50,973.50,'2023-01-24 10:00:44','',''),(3862,'1','302','1',1,'Retail Sale Id 3713',3002.88,0.00,0.00,4.08,346.80,'2023-01-24 10:03:26','',''),(3863,'1','302','1',1,'Retail Sale Id 3714',2200.64,0.00,0.00,2.99,254.15,'2023-01-24 10:04:30','',''),(3864,'1','302','1',1,'Retail Sale Id 3715',802.24,0.00,0.00,1.09,92.65,'2023-01-24 10:05:19','',''),(3865,'1','302','1',1,'Retail Sale Id 3716',3002.88,0.00,0.00,4.08,346.80,'2023-01-24 10:06:10','',''),(3866,'1','302','1',1,'Retail Sale Id 3717',1501.44,0.00,0.00,2.04,173.40,'2023-01-24 10:06:52','',''),(3867,'1','302','1',1,'Retail Sale Id 3718',9230.00,0.00,0.00,13.00,767.00,'2023-01-24 10:24:10','',''),(3868,'1','302','1',1,'Retail Sale Id 3719',1501.44,0.00,0.00,2.04,173.40,'2023-01-24 10:25:45','',''),(3869,'1','302','1',1,'Retail Sale Id 3720',35500.00,0.00,0.00,50.00,2950.00,'2023-01-24 10:26:55','',''),(3870,'1','302','1',1,'Retail Sale Id 3721',21300.00,0.00,0.00,30.00,1770.00,'2023-01-24 10:28:42','',''),(3871,'1','302','1',1,'Retail Sale Id 3722',2208.00,0.00,0.00,3.00,255.00,'2023-01-24 10:29:47','',''),(3872,'1','302','1',1,'Retail Sale Id 3723',71000.00,0.00,0.00,100.00,5900.00,'2023-01-24 10:32:12','',''),(3873,'1','302','1',1,'Retail Sale Id 3724',2208.00,0.00,0.00,3.00,255.00,'2023-01-24 10:33:22','',''),(3874,'1','302','1',1,'Retail Sale Id 3725',4496.96,0.00,0.00,6.11,519.35,'2023-01-24 10:34:28','',''),(3875,'1','302','1',1,'Retail Sale Id 3726',4496.96,0.00,0.00,6.11,519.35,'2023-01-24 10:36:58','',''),(3876,'1','302','1',1,'Retail Sale Id 3727',9200.00,0.00,0.00,12.50,1062.50,'2023-01-24 10:39:20','',''),(3877,'1','302','1',1,'Retail Sale Id 3728',3599.04,0.00,0.00,4.89,415.65,'2023-01-24 10:53:09','',''),(3878,'1','302','1',1,'Retail Sale Id 3729',2001.92,0.00,0.00,2.72,231.20,'2023-01-24 10:54:32','',''),(3879,'1','302','1',1,'Retail Sale Id 3730',3702.08,0.00,0.00,5.03,427.55,'2023-01-24 10:59:52','',''),(3880,'1','302','1',1,'Retail Sale Id 3731',3702.08,0.00,0.00,5.03,427.55,'2023-01-24 11:04:49','',''),(3881,'1','302','1',1,'Retail Sale Id 3733',3996.48,0.00,0.00,5.43,461.55,'2023-01-24 11:08:36','',''),(3882,'1','302','1',1,'Retail Sale Id 3734',43310.00,0.00,0.00,61.00,3599.00,'2023-01-24 11:10:47','',''),(3883,'1','302','1',1,'Retail Sale Id 3735',4452.80,0.00,0.00,6.05,514.25,'2023-01-24 11:12:31','',''),(3884,'1','302','1',1,'Retail Sale Id 3736',9200.00,0.00,0.00,12.50,1062.50,'2023-01-24 11:16:33','',''),(3885,'1','302','1',1,'Retail Sale Id 3737',9200.00,0.00,0.00,12.50,1062.50,'2023-01-24 11:18:48','',''),(3886,'1','302','1',1,'Retail Sale Id 3738',2502.40,0.00,0.00,3.40,289.00,'2023-01-24 11:21:44','',''),(3887,'1','302','1',1,'Retail Sale Id 3739',3002.88,0.00,0.00,4.08,346.80,'2023-01-24 11:22:27','',''),(3888,'1','302','1',1,'Retail Sale Id 3740',53250.00,0.00,0.00,75.00,4425.00,'2023-01-24 11:43:13','',''),(3889,'1','302','1',1,'Retail Sale Id 3741',3550.00,0.00,0.00,5.00,295.00,'2023-01-24 13:02:12','',''),(3890,'1','302','1',1,'Retail Sale Id 3742',65533.44,0.00,0.00,89.04,7568.40,'2023-01-24 13:05:48','',''),(3891,'1','302','1',1,'Retail Sale Id 3743',3797.76,0.00,0.00,5.16,438.60,'2023-01-24 13:29:24','',''),(3892,'1','302','1',1,'Retail Sale Id 3744',5152.00,0.00,0.00,7.00,595.00,'2023-01-24 13:35:37','',''),(3893,'1','302','1',1,'Retail Sale Id 3745',4496.96,0.00,0.00,6.11,519.35,'2023-01-24 13:42:12','',''),(3894,'1','302','1',1,'Retail Sale Id 3746',4496.96,0.00,0.00,6.11,519.35,'2023-01-24 13:48:53','',''),(3895,'1','302','1',1,'Retail Sale Id 3747',3797.76,0.00,0.00,5.16,438.60,'2023-01-24 13:58:50','',''),(3896,'1','302','1',1,'Retail Sale Id 3748',4416.00,0.00,0.00,6.00,510.00,'2023-01-24 14:10:40','',''),(3897,'1','302','1',1,'Retail Sale Id 3749',4416.00,0.00,0.00,6.00,510.00,'2023-01-24 14:12:20','',''),(3898,'1','302','1',1,'Retail Sale Id 3750',1597.12,0.00,0.00,2.17,184.45,'2023-01-24 14:13:19','',''),(3899,'1','302','1',1,'Retail Sale Id 3751',1501.44,0.00,0.00,2.04,173.40,'2023-01-24 14:14:45','',''),(3900,'1','302','1',1,'Retail Sale Id 3752',4416.00,0.00,0.00,6.00,510.00,'2023-01-24 14:19:04','',''),(3901,'1','302','1',1,'Retail Sale Id 3753',1597.12,0.00,0.00,2.17,184.45,'2023-01-24 14:19:46','',''),(3902,'1','302','1',1,'Retail Sale Id 3754',9200.00,0.00,0.00,12.50,1062.50,'2023-01-24 14:20:35','',''),(3903,'1','302','1',1,'Retail Sale Id 3755',3002.88,0.00,0.00,4.08,346.80,'2023-01-24 14:41:16','',''),(3904,'1','302','1',1,'Retail Sale Id 3755',3002.88,0.00,0.00,4.08,346.80,'2023-01-24 14:41:16','',''),(3905,'1','302','1',1,'Retail Sale Id 3756',1472.00,0.00,0.00,2.00,170.00,'2023-01-24 14:46:10','',''),(3906,'1','302','1',1,'Retail Sale Id 3757',1700.16,0.00,0.00,2.31,196.35,'2023-01-24 14:49:17','',''),(3907,'1','302','1',1,'Retail Sale Id 3758',2252.16,0.00,0.00,3.06,260.10,'2023-01-24 14:56:21','',''),(3908,'1','302','1',1,'Retail Sale Id 3759',2001.92,0.00,0.00,2.72,231.20,'2023-01-24 14:57:00','',''),(3909,'1','302','1',1,'Retail Sale Id 3760',2001.92,0.00,0.00,2.72,231.20,'2023-01-24 14:58:57','',''),(3910,'1','302','1',1,'Retail Sale Id 3761',28400.00,0.00,0.00,40.00,2360.00,'2023-01-24 15:00:25','',''),(3911,'1','302','1',1,'Retail Sale Id 3763',802.24,0.00,0.00,1.09,92.65,'2023-01-24 15:04:36','',''),(3912,'1','302','1',1,'Retail Sale Id 3764',4997.44,0.00,0.00,6.79,577.15,'2023-01-24 15:06:33','',''),(3913,'1','302','1',1,'Retail Sale Id 3765',35500.00,0.00,0.00,50.00,2950.00,'2023-01-24 15:10:59','',''),(3914,'1','302','1',1,'Retail Sale Id 3766',10002.24,0.00,0.00,13.59,1155.15,'2023-01-24 15:11:51','',''),(3915,'1','302','1',1,'Retail Sale Id 3767',9200.00,0.00,0.00,12.50,1062.50,'2023-01-24 15:15:31','',''),(3916,'1','302','1',1,'Retail Sale Id 3768',1501.44,0.00,0.00,2.04,173.40,'2023-01-24 15:30:06','',''),(3917,'1','302','1',1,'Retail Sale Id 3769',6999.36,0.00,0.00,9.51,808.35,'2023-01-24 15:39:04','',''),(3918,'1','302','1',1,'Retail Sale Id 3770',9200.00,0.00,0.00,12.50,1062.50,'2023-01-24 15:50:08','',''),(3919,'1','302','1',1,'Retail Sale Id 3771',1000.96,0.00,0.00,1.36,115.60,'2023-01-24 16:02:48','',''),(3920,'1','302','1',1,'Retail Sale Id 3772',2001.92,0.00,0.00,2.72,231.20,'2023-01-24 16:31:09','',''),(3921,'1','302','1',1,'Retail Sale Id 3773',9230.00,0.00,0.00,13.00,767.00,'2023-01-24 16:33:19','',''),(3922,'1','302','1',1,'Retail Sale Id 3774',13652.80,0.00,0.00,18.55,1576.75,'2023-01-24 16:39:53','',''),(3923,'1','302','1',1,'Retail Sale Id 3775',1000.96,0.00,0.00,1.36,115.60,'2023-01-24 16:52:02','',''),(3924,'1','302','1',1,'Retail Sale Id 3776',10650.00,0.00,0.00,15.00,885.00,'2023-01-24 16:53:59','',''),(3925,'1','302','1',1,'Retail Sale Id 3777',12503.10,0.00,0.00,17.61,1038.99,'2023-01-24 16:56:16','',''),(3926,'1','302','1',1,'Retail Sale Id 3778',2303.68,0.00,0.00,3.13,266.05,'2023-01-24 17:06:26','',''),(3927,'1','302','1',1,'Retail Sale Id 3779',8520.00,0.00,0.00,12.00,708.00,'2023-01-24 17:09:42','',''),(3928,'1','302','1',1,'Retail Sale Id 3780',4416.00,0.00,0.00,6.00,510.00,'2023-01-24 17:19:03','',''),(3929,'1','302','1',1,'Retail Sale Id 3781',3002.88,0.00,0.00,4.08,346.80,'2023-01-24 17:20:19','',''),(3930,'1','302','1',1,'Retail Sale Id 3782',4496.96,0.00,0.00,6.11,519.35,'2023-01-24 17:22:54','',''),(3931,'1','302','1',1,'Retail Sale Id 3783',14200.00,0.00,0.00,20.00,1180.00,'2023-01-24 17:24:35','',''),(3932,'1','302','1',1,'Retail Sale Id 3784',4452.80,0.00,0.00,6.05,514.25,'2023-01-24 17:27:45','',''),(3933,'1','302','1',1,'Retail Sale Id 3785',2200.64,0.00,0.00,2.99,254.15,'2023-01-24 17:35:08','',''),(3934,'1','302','1',1,'Retail Sale Id 3786',2208.00,0.00,0.00,3.00,255.00,'2023-01-24 17:38:06','',''),(3935,'1','302','1',1,'Retail Sale Id 3787',9200.00,0.00,0.00,12.50,1062.50,'2023-01-24 17:39:40','',''),(3936,'1','302','1',1,'Retail Sale Id 3788',7810.00,0.00,0.00,11.00,649.00,'2023-01-24 17:42:49','',''),(3937,'1','302','1',1,'Retail Sale Id 3789',1486.72,0.00,0.00,2.02,171.70,'2023-01-24 17:45:58','',''),(3938,'1','302','1',1,'Retail Sale Id 3789',1501.44,0.00,0.00,2.04,173.40,'2023-01-24 17:45:58','',''),(3939,'1','302','1',1,'Retail Sale Id 3790',8903.40,0.00,0.00,12.54,739.86,'2023-01-24 17:52:22','',''),(3940,'1','302','1',1,'Return of Retail Sale Id 3766',0.00,10002.24,13.59,0.00,-1155.15,'2023-01-24 17:54:08','',''),(3941,'1','302','1',1,'Return of Retail Sale Id 3698',0.00,7360.00,10.00,0.00,-850.00,'2023-01-24 17:56:17','',''),(3942,'1','302','1',1,'Retail Sale Id 3791',2001.92,0.00,0.00,2.72,231.20,'2023-01-24 18:02:47','',''),(3943,'1','302','1',1,'Retail Sale Id 3791',3002.88,0.00,0.00,4.08,346.80,'2023-01-24 18:02:47','',''),(3944,'1','302','1',1,'Retail Sale Id 3792',9200.00,0.00,0.00,12.50,1062.50,'2023-01-24 18:04:35','',''),(3945,'1','302','1',1,'Retail Sale Id 3793',4496.96,0.00,0.00,6.11,519.35,'2023-01-24 18:05:54','',''),(3946,'1','302','1',1,'Retail Sale Id 3794',9200.00,0.00,0.00,12.50,1062.50,'2023-01-24 18:11:40','',''),(3947,'1','302','1',1,'Retail Sale Id 3795',4496.96,0.00,0.00,6.11,519.35,'2023-01-24 18:19:35','',''),(3948,'1','302','1',1,'Retail Sale Id 3796',3680.00,0.00,0.00,5.00,425.00,'2023-01-24 18:20:38','',''),(3949,'1','302','1',1,'Retail Sale Id 3797',3996.48,0.00,0.00,5.43,461.55,'2023-01-24 18:24:31','',''),(3950,'1','302','1',1,'Retail Sale Id 3798',397.44,0.00,0.00,0.54,45.90,'2023-01-24 18:27:52','',''),(3951,'1','302','1',1,'Return of Retail Sale Id 3798',0.00,397.44,0.54,0.00,-45.90,'2023-01-24 19:01:58','',''),(3952,'1','302','1',1,'Retail Sale Id 3799',191.36,0.00,0.00,0.26,22.10,'2023-01-24 19:03:18','',''),(3953,'1','302','1',1,'Retail Sale Id 3800',9700.48,0.00,0.00,13.18,1120.30,'2023-01-25 07:40:21','',''),(3954,'1','302','1',1,'Retail Sale Id 3801',2944.00,0.00,0.00,4.00,340.00,'2023-01-25 07:47:28','',''),(3955,'1','302','1',1,'Retail Sale Id 3802',3702.08,0.00,0.00,5.03,427.55,'2023-01-25 08:19:12','',''),(3956,'1','302','1',1,'Retail Sale Id 3803',10414.40,0.00,0.00,14.15,1202.75,'2023-01-25 08:21:21','',''),(3957,'1','302','1',1,'Retail Sale Id 3804',3680.00,0.00,0.00,5.00,425.00,'2023-01-25 08:24:04','',''),(3958,'1','302','1',1,'Retail Sale Id 3805',4496.96,0.00,0.00,6.11,519.35,'2023-01-25 08:25:58','',''),(3959,'1','302','1',1,'Retail Sale Id 3806',802.24,0.00,0.00,1.09,92.65,'2023-01-25 08:35:28','',''),(3960,'1','302','1',1,'Retail Sale Id 3807',10304.00,0.00,0.00,14.00,1190.00,'2023-01-25 08:37:40','',''),(3961,'1','302','1',1,'Retail Sale Id 3808',9200.00,0.00,0.00,12.50,1062.50,'2023-01-25 08:39:07','',''),(3962,'1','302','1',1,'Retail Sale Id 3809',9200.00,0.00,0.00,12.50,1062.50,'2023-01-25 08:40:50','',''),(3963,'1','302','1',1,'Retail Sale Id 3810',4416.00,0.00,0.00,6.00,510.00,'2023-01-25 08:41:52','',''),(3964,'1','302','1',1,'Retail Sale Id 3811',1000.96,0.00,0.00,1.36,115.60,'2023-01-25 08:44:27','',''),(3965,'1','302','1',1,'Retail Sale Id 3812',8000.32,0.00,0.00,10.87,923.95,'2023-01-25 08:54:21','',''),(3966,'1','302','1',1,'Retail Sale Id 3813',3002.88,0.00,0.00,4.08,346.80,'2023-01-25 08:55:09','',''),(3967,'1','302','1',1,'Retail Sale Id 3814',2068.16,0.00,0.00,2.81,238.85,'2023-01-25 08:56:51','',''),(3968,'1','302','1',1,'Retail Sale Id 3815',4416.00,0.00,0.00,6.00,510.00,'2023-01-25 08:58:23','',''),(3969,'1','302','1',1,'Retail Sale Id 3816',50048.00,0.00,0.00,68.00,5780.00,'2023-01-25 09:18:29','',''),(3970,'1','302','1',1,'Retail Sale Id 3817',2944.00,0.00,0.00,4.00,340.00,'2023-01-25 09:29:55','',''),(3971,'1','302','1',1,'Retail Sale Id 3818',3680.00,0.00,0.00,5.00,425.00,'2023-01-25 09:31:19','',''),(3972,'1','302','1',1,'Retail Sale Id 3819',2200.64,0.00,0.00,2.99,254.15,'2023-01-25 09:39:20','',''),(3973,'1','302','1',1,'Retail Sale Id 3820',1000.96,0.00,0.00,1.36,115.60,'2023-01-25 09:41:24','',''),(3974,'1','302','1',1,'Retail Sale Id 3821',1000.96,0.00,0.00,1.36,115.60,'2023-01-25 10:01:55','',''),(3975,'1','302','1',1,'Retail Sale Id 3822',4416.00,0.00,0.00,6.00,510.00,'2023-01-25 10:03:32','',''),(3976,'1','302','1',1,'Retail Sale Id 3823',2001.92,0.00,0.00,2.72,231.20,'2023-01-25 10:15:39','',''),(3977,'1','302','1',1,'Retail Sale Id 3823',3680.00,0.00,0.00,5.00,425.00,'2023-01-25 10:15:39','',''),(3978,'1','302','1',1,'Retail Sale Id 3823',3680.00,0.00,0.00,5.00,425.00,'2023-01-25 10:15:39','',''),(3979,'1','302','1',1,'Retail Sale Id 3825',56800.00,0.00,0.00,80.00,4720.00,'2023-01-25 10:27:54','',''),(3980,'1','302','1',1,'Retail Sale Id 3826',1000.96,0.00,0.00,1.36,115.60,'2023-01-25 10:28:57','',''),(3981,'1','302','1',1,'Retail Sale Id 3827',7360.00,0.00,0.00,10.00,850.00,'2023-01-25 10:30:14','',''),(3982,'1','302','1',1,'Retail Sale Id 3828',2208.00,0.00,0.00,3.00,255.00,'2023-01-25 10:35:29','',''),(3983,'1','302','1',1,'Retail Sale Id 3829',17750.00,0.00,0.00,25.00,1475.00,'2023-01-25 10:40:05','',''),(3984,'1','302','1',1,'Retail Sale Id 3830',2208.00,0.00,0.00,3.00,255.00,'2023-01-25 10:42:02','',''),(3985,'1','302','1',1,'Retail Sale Id 3830',4416.00,0.00,0.00,6.00,510.00,'2023-01-25 10:42:02','',''),(3986,'1','302','1',1,'Retail Sale Id 3830',4416.00,0.00,0.00,6.00,510.00,'2023-01-25 10:42:02','',''),(3987,'1','302','1',1,'Retail Sale Id 3830',4416.00,0.00,0.00,6.00,510.00,'2023-01-25 10:42:02','',''),(3988,'1','302','1',1,'Retail Sale Id 3831',5152.00,0.00,0.00,7.00,595.00,'2023-01-25 10:49:08','',''),(3989,'1','302','1',1,'Retail Sale Id 3832',802.24,0.00,0.00,1.09,92.65,'2023-01-25 10:50:06','',''),(3990,'1','302','1',1,'Retail Sale Id 3833',3002.88,0.00,0.00,4.08,346.80,'2023-01-25 10:50:59','',''),(3991,'1','302','1',1,'Retail Sale Id 3834',500.48,0.00,0.00,0.68,57.80,'2023-01-25 11:04:40','',''),(3992,'1','302','1',1,'Retail Sale Id 3835',5681.92,0.00,0.00,7.72,656.20,'2023-01-25 11:16:14','',''),(3993,'1','302','1',1,'Retail Sale Id 3836',10650.00,0.00,0.00,15.00,885.00,'2023-01-25 11:19:24','',''),(3994,'1','302','1',1,'Retail Sale Id 3837',35343.80,0.00,0.00,49.78,2937.02,'2023-01-25 11:21:55','',''),(3995,'1','302','1',1,'Retail Sale Id 3838',3002.88,0.00,0.00,4.08,346.80,'2023-01-25 11:26:50','',''),(3996,'1','302','1',1,'Retail Sale Id 3839',2252.16,0.00,0.00,3.06,260.10,'2023-01-25 11:33:12','',''),(3997,'1','302','1',1,'Retail Sale Id 3839',2252.16,0.00,0.00,3.06,260.10,'2023-01-25 11:33:12','',''),(3998,'1','302','1',1,'Retail Sale Id 3840',4416.00,0.00,0.00,6.00,510.00,'2023-01-25 11:37:35','',''),(3999,'1','302','1',1,'Retail Sale Id 3841',4416.00,0.00,0.00,6.00,510.00,'2023-01-25 11:40:33','',''),(4000,'1','302','1',1,'Retail Sale Id 3842',4496.96,0.00,0.00,6.11,519.35,'2023-01-25 11:43:11','',''),(4001,'1','302','1',1,'Retail Sale Id 3843',2001.92,0.00,0.00,2.72,231.20,'2023-01-25 11:45:41','',''),(4002,'1','302','1',1,'Retail Sale Id 3844',8520.00,0.00,0.00,12.00,708.00,'2023-01-25 11:50:23','',''),(4003,'1','302','1',1,'Retail Sale Id 3845',16003.40,0.00,0.00,22.54,1329.86,'2023-01-25 11:52:38','',''),(4004,'1','302','1',1,'Retail Sale Id 3846',1000.96,0.00,0.00,1.36,115.60,'2023-01-25 11:55:03','',''),(4005,'1','302','1',1,'Retail Sale Id 3847',500.48,0.00,0.00,0.68,57.80,'2023-01-25 11:55:47','',''),(4006,'1','302','1',1,'Retail Sale Id 3848',4416.00,0.00,0.00,6.00,510.00,'2023-01-25 12:05:20','',''),(4007,'1','302','1',1,'Retail Sale Id 3849',9200.00,0.00,0.00,12.50,1062.50,'2023-01-25 12:12:08','',''),(4008,'1','302','1',1,'Retail Sale Id 3850',1597.12,0.00,0.00,2.17,184.45,'2023-01-25 12:13:07','',''),(4009,'1','302','1',1,'Retail Sale Id 3852',2208.00,0.00,0.00,3.00,255.00,'2023-01-25 12:15:50','',''),(4010,'1','302','1',1,'Retail Sale Id 3853',2208.00,0.00,0.00,3.00,255.00,'2023-01-25 12:32:42','',''),(4011,'1','302','1',1,'Retail Sale Id 3854',4416.00,0.00,0.00,6.00,510.00,'2023-01-25 13:00:20','',''),(4012,'1','302','1',1,'Retail Sale Id 3855',1000.96,0.00,0.00,1.36,115.60,'2023-01-25 13:01:20','',''),(4013,'1','302','1',1,'Retail Sale Id 3856',1479.36,0.00,0.00,2.01,170.85,'2023-01-25 13:03:39','',''),(4014,'1','302','1',1,'Retail Sale Id 3857',35500.00,0.00,0.00,50.00,2950.00,'2023-01-25 13:05:22','',''),(4015,'1','302','1',1,'Retail Sale Id 3858',4423.36,0.00,0.00,6.01,510.85,'2023-01-25 13:07:56','',''),(4016,'1','302','1',1,'Retail Sale Id 3859',4416.00,0.00,0.00,6.00,510.00,'2023-01-25 13:11:40','',''),(4017,'1','302','1',1,'Retail Sale Id 3860',172735.90,0.00,0.00,243.29,14354.11,'2023-01-25 13:17:55','',''),(4018,'1','302','1',1,'Retail Sale Id 3861',3996.48,0.00,0.00,5.43,461.55,'2023-01-25 13:21:48','',''),(4019,'1','302','1',1,'Retail Sale Id 3862',2001.92,0.00,0.00,2.72,231.20,'2023-01-25 13:22:50','',''),(4020,'1','302','1',1,'Retail Sale Id 3863',17750.00,0.00,0.00,25.00,1475.00,'2023-01-25 13:26:27','',''),(4021,'1','302','1',1,'Retail Sale Id 3864',500.48,0.00,0.00,0.68,57.80,'2023-01-25 14:01:13','',''),(4022,'1','302','1',1,'Retail Sale Id 3865',2208.00,0.00,0.00,3.00,255.00,'2023-01-25 14:02:33','',''),(4023,'1','302','1',1,'Retail Sale Id 3866',1597.12,0.00,0.00,2.17,184.45,'2023-01-25 14:06:25','',''),(4024,'1','302','1',1,'Retail Sale Id 3867',2208.00,0.00,0.00,3.00,255.00,'2023-01-25 14:11:34','',''),(4025,'1','302','1',1,'Retail Sale Id 3868',1501.44,0.00,0.00,2.04,173.40,'2023-01-25 14:14:29','',''),(4026,'1','302','1',1,'Retail Sale Id 3869',3680.00,0.00,0.00,5.00,425.00,'2023-01-25 14:17:26','',''),(4027,'1','302','1',1,'Retail Sale Id 3870',3002.88,0.00,0.00,4.08,346.80,'2023-01-25 14:23:18','',''),(4028,'1','302','1',1,'Retail Sale Id 3871',2252.16,0.00,0.00,3.06,260.10,'2023-01-25 14:33:20','',''),(4029,'1','302','1',1,'Retail Sale Id 3872',9200.00,0.00,0.00,12.50,1062.50,'2023-01-25 14:34:38','',''),(4030,'1','302','1',1,'Retail Sale Id 3873',4416.00,0.00,0.00,6.00,510.00,'2023-01-25 14:38:08','',''),(4031,'1','302','1',1,'Retail Sale Id 3874',2208.00,0.00,0.00,3.00,255.00,'2023-01-25 14:45:30','',''),(4032,'1','302','1',1,'Retail Sale Id 3875',2208.00,0.00,0.00,3.00,255.00,'2023-01-25 14:52:34','',''),(4033,'1','302','1',1,'Retail Sale Id 3876',3002.88,0.00,0.00,4.08,346.80,'2023-01-25 14:53:51','',''),(4034,'1','302','1',1,'Retail Sale Id 3877',3680.00,0.00,0.00,5.00,425.00,'2023-01-25 14:55:48','',''),(4035,'1','302','1',1,'Retail Sale Id 3878',1501.44,0.00,0.00,2.04,173.40,'2023-01-25 14:56:38','',''),(4036,'1','302','1',1,'Retail Sale Id 3879',2001.92,0.00,0.00,2.72,231.20,'2023-01-25 15:01:03','',''),(4037,'1','302','1',1,'Retail Sale Id 3880',4423.36,0.00,0.00,6.01,510.85,'2023-01-25 15:08:13','',''),(4038,'1','302','1',1,'Retail Sale Id 3881',10650.00,0.00,0.00,15.00,885.00,'2023-01-25 15:27:46','',''),(4039,'1','302','1',1,'Retail Sale Id 3882',1000.96,0.00,0.00,1.36,115.60,'2023-01-25 15:44:07','',''),(4040,'1','302','1',1,'Retail Sale Id 3883',7360.00,0.00,0.00,10.00,850.00,'2023-01-25 15:49:41','',''),(4041,'1','302','1',1,'Retail Sale Id 3884',4416.00,0.00,0.00,6.00,510.00,'2023-01-25 15:53:50','',''),(4042,'1','302','1',1,'Retail Sale Id 3885',9200.00,0.00,0.00,12.50,1062.50,'2023-01-25 15:58:01','',''),(4043,'1','302','1',1,'Retail Sale Id 3886',8096.00,0.00,0.00,11.00,935.00,'2023-01-25 15:59:25','',''),(4044,'1','302','1',1,'Retail Sale Id 3887',2200.64,0.00,0.00,2.99,254.15,'2023-01-25 16:18:12','',''),(4045,'1','302','1',1,'Retail Sale Id 3888',4416.00,0.00,0.00,6.00,510.00,'2023-01-25 16:21:34','',''),(4046,'1','302','1',1,'Retail Sale Id 3889',6999.36,0.00,0.00,9.51,808.35,'2023-01-25 16:23:11','',''),(4047,'1','302','1',1,'Retail Sale Id 3890',3002.88,0.00,0.00,4.08,346.80,'2023-01-25 16:23:58','',''),(4048,'1','302','1',1,'Retail Sale Id 3891',2001.92,0.00,0.00,2.72,231.20,'2023-01-25 16:25:16','',''),(4049,'1','302','1',1,'Retail Sale Id 3892',7810.00,0.00,0.00,11.00,649.00,'2023-01-25 16:30:48','',''),(4050,'1','302','1',1,'Retail Sale Id 3893',2502.40,0.00,0.00,3.40,289.00,'2023-01-25 16:44:45','',''),(4051,'1','302','1',1,'Retail Sale Id 3894',397.44,0.00,0.00,0.54,45.90,'2023-01-25 17:00:07','',''),(4052,'1','302','1',1,'Retail Sale Id 3895',1000.96,0.00,0.00,1.36,115.60,'2023-01-25 17:02:39','',''),(4053,'1','302','1',1,'Retail Sale Id 3896',2502.40,0.00,0.00,3.40,289.00,'2023-01-25 17:15:30','',''),(4054,'1','302','1',1,'Retail Sale Id 3897',2208.00,0.00,0.00,3.00,255.00,'2023-01-25 17:16:42','',''),(4055,'1','302','1',1,'Retail Sale Id 3898',9200.00,0.00,0.00,12.50,1062.50,'2023-01-25 17:23:00','',''),(4056,'1','302','1',1,'Retail Sale Id 3899',2200.64,0.00,0.00,2.99,254.15,'2023-01-25 17:27:12','',''),(4057,'1','302','1',1,'Retail Sale Id 3900',3002.88,0.00,0.00,4.08,346.80,'2023-01-25 17:31:22','',''),(4058,'1','302','1',1,'Retail Sale Id 3901',1472.00,0.00,0.00,2.00,170.00,'2023-01-25 17:48:02','',''),(4059,'1','302','1',1,'Retail Sale Id 3902',2001.92,0.00,0.00,2.72,231.20,'2023-01-25 17:49:34','',''),(4060,'1','302','1',1,'Retail Sale Id 3903',3680.00,0.00,0.00,5.00,425.00,'2023-01-25 17:53:45','',''),(4061,'1','302','1',1,'Retail Sale Id 3904',500.48,0.00,0.00,0.68,57.80,'2023-01-25 17:55:30','',''),(4062,'1','302','1',1,'Retail Sale Id 3905',8832.00,0.00,0.00,12.00,1020.00,'2023-01-25 17:58:28','',''),(4063,'1','302','1',1,'Retail Sale Id 3906',4416.00,0.00,0.00,6.00,510.00,'2023-01-25 18:00:42','',''),(4064,'1','302','1',1,'Retail Sale Id 3907',3996.48,0.00,0.00,5.43,461.55,'2023-01-25 18:03:37','',''),(4065,'1','302','1',1,'Retail Sale Id 3908',4496.96,0.00,0.00,6.11,519.35,'2023-01-25 18:05:26','',''),(4066,'1','302','1',1,'Retail Sale Id 3909',9200.00,0.00,0.00,12.50,1062.50,'2023-01-25 18:09:32','',''),(4067,'1','302','1',1,'Retail Sale Id 3910',1501.44,0.00,0.00,2.04,173.40,'2023-01-25 18:10:22','',''),(4068,'1','302','1',1,'Retail Sale Id 3911',2001.92,0.00,0.00,2.72,231.20,'2023-01-25 18:14:31','',''),(4069,'1','302','1',1,'Retail Sale Id 3912',9200.00,0.00,0.00,12.50,1062.50,'2023-01-25 18:15:40','',''),(4070,'1','302','1',1,'Retail Sale Id 3914',4416.00,0.00,0.00,6.00,510.00,'2023-01-25 18:23:24','',''),(4071,'1','302','1',1,'Retail Sale Id 3915',2502.40,0.00,0.00,3.40,289.00,'2023-01-25 18:32:18','',''),(4072,'1','302','1',1,'Retail Sale Id 3916',44793.90,0.00,0.00,63.09,3722.31,'2023-01-25 18:34:51','',''),(4073,'1','302','1',1,'Retail Sale Id 3917',1000.96,0.00,0.00,1.36,115.60,'2023-01-25 18:38:48','',''),(4074,'1','302','1',1,'Retail Sale Id 3918',3002.88,0.00,0.00,4.08,346.80,'2023-01-25 18:49:45','',''),(4075,'1','302','1',1,'Retail Sale Id 3919',736.00,0.00,0.00,1.00,85.00,'2023-01-25 19:05:01','',''),(4076,'1','302','1',1,'Retail Sale Id 3920',4416.00,0.00,0.00,6.00,510.00,'2023-01-26 07:49:38','',''),(4077,'1','302','1',1,'Retail Sale Id 3920',4416.00,0.00,0.00,6.00,510.00,'2023-01-26 07:49:38','',''),(4078,'1','302','1',1,'Retail Sale Id 3921',1000.96,0.00,0.00,1.36,115.60,'2023-01-26 07:56:33','',''),(4079,'1','302','1',1,'Retail Sale Id 3922',2001.92,0.00,0.00,2.72,231.20,'2023-01-26 08:00:15','',''),(4080,'1','302','1',1,'Retail Sale Id 3923',1501.44,0.00,0.00,2.04,173.40,'2023-01-26 08:03:08','',''),(4081,'1','302','1',1,'Retail Sale Id 3924',3680.00,0.00,0.00,5.00,425.00,'2023-01-26 08:13:38','',''),(4082,'1','302','1',1,'Retail Sale Id 3925',4496.96,0.00,0.00,6.11,519.35,'2023-01-26 08:16:44','',''),(4083,'1','302','1',1,'Retail Sale Id 3926',7810.00,0.00,0.00,11.00,649.00,'2023-01-26 08:19:41','',''),(4084,'1','302','1',1,'Retail Sale Id 3927',4496.96,0.00,0.00,6.11,519.35,'2023-01-26 08:21:20','',''),(4085,'1','302','1',1,'Retail Sale Id 3928',4496.96,0.00,0.00,6.11,519.35,'2023-01-26 08:22:05','',''),(4086,'1','302','1',1,'Retail Sale Id 3929',2001.92,0.00,0.00,2.72,231.20,'2023-01-26 08:26:05','',''),(4087,'1','302','1',1,'Retail Sale Id 3930',9200.00,0.00,0.00,12.50,1062.50,'2023-01-26 08:31:33','',''),(4088,'1','302','1',1,'Retail Sale Id 3931',4416.00,0.00,0.00,6.00,510.00,'2023-01-26 08:33:43','',''),(4089,'1','302','1',1,'Retail Sale Id 3932',3996.48,0.00,0.00,5.43,461.55,'2023-01-26 08:35:51','',''),(4090,'1','302','1',1,'Retail Sale Id 3933',1501.44,0.00,0.00,2.04,173.40,'2023-01-26 08:41:26','',''),(4091,'1','302','1',1,'Retail Sale Id 3934',500.48,0.00,0.00,0.68,57.80,'2023-01-26 08:51:13','',''),(4092,'1','302','1',1,'Retail Sale Id 3934',1000.96,0.00,0.00,1.36,115.60,'2023-01-26 08:51:13','',''),(4093,'1','302','1',1,'Retail Sale Id 3936',4496.96,0.00,0.00,6.11,519.35,'2023-01-26 08:55:24','',''),(4094,'1','302','1',1,'Retail Sale Id 3937',9200.00,0.00,0.00,12.50,1062.50,'2023-01-26 09:05:09','',''),(4095,'1','302','1',1,'Retail Sale Id 3938',4401.28,0.00,0.00,5.98,508.30,'2023-01-26 09:06:27','',''),(4096,'1','302','1',1,'Retail Sale Id 3939',2200.64,0.00,0.00,2.99,254.15,'2023-01-26 09:07:15','',''),(4097,'1','302','1',1,'Retail Sale Id 3940',1398.40,0.00,0.00,1.90,161.50,'2023-01-26 09:11:12','',''),(4098,'1','302','1',1,'Retail Sale Id 3942',7810.00,0.00,0.00,11.00,649.00,'2023-01-26 09:18:04','',''),(4099,'1','302','1',1,'Retail Sale Id 3943',3002.88,0.00,0.00,4.08,346.80,'2023-01-26 09:18:55','',''),(4100,'1','302','1',1,'Retail Sale Id 3944',3680.00,0.00,0.00,5.00,425.00,'2023-01-26 09:20:12','',''),(4101,'1','302','1',1,'Retail Sale Id 3945',1000.96,0.00,0.00,1.36,115.60,'2023-01-26 09:26:58','',''),(4102,'1','302','1',1,'Retail Sale Id 3946',4401.28,0.00,0.00,5.98,508.30,'2023-01-26 09:28:32','',''),(4103,'1','302','1',1,'Retail Sale Id 3947',2200.64,0.00,0.00,2.99,254.15,'2023-01-26 09:29:18','',''),(4104,'1','302','1',1,'Retail Sale Id 3948',2208.00,0.00,0.00,3.00,255.00,'2023-01-26 09:30:35','',''),(4105,'1','302','1',1,'Retail Sale Id 3949',2303.68,0.00,0.00,3.13,266.05,'2023-01-26 09:34:15','',''),(4106,'1','302','1',1,'Retail Sale Id 3950',2200.64,0.00,0.00,2.99,254.15,'2023-01-26 09:36:16','',''),(4107,'1','302','1',1,'Retail Sale Id 3951',9200.00,0.00,0.00,12.50,1062.50,'2023-01-26 09:37:10','',''),(4108,'1','302','1',1,'Retail Sale Id 3952',2001.92,0.00,0.00,2.72,231.20,'2023-01-26 09:39:39','',''),(4109,'1','302','1',1,'Retail Sale Id 3953',2399.36,0.00,0.00,3.26,277.10,'2023-01-26 09:48:25','',''),(4110,'1','302','1',1,'Retail Sale Id 3954',3002.88,0.00,0.00,4.08,346.80,'2023-01-26 09:49:07','',''),(4111,'1','302','1',1,'Retail Sale Id 3955',3002.88,0.00,0.00,4.08,346.80,'2023-01-26 09:50:01','',''),(4112,'1','302','1',1,'Retail Sale Id 3956',4416.00,0.00,0.00,6.00,510.00,'2023-01-26 09:51:05','',''),(4113,'1','302','1',1,'Retail Sale Id 3957',9200.00,0.00,0.00,12.50,1062.50,'2023-01-26 09:52:19','',''),(4114,'1','302','1',1,'Retail Sale Id 3957',9200.00,0.00,0.00,12.50,1062.50,'2023-01-26 09:52:19','',''),(4115,'1','302','1',1,'Retail Sale Id 3958',802.24,0.00,0.00,1.09,92.65,'2023-01-26 09:53:38','',''),(4116,'1','302','1',1,'Retail Sale Id 3959',3680.00,0.00,0.00,5.00,425.00,'2023-01-26 10:08:31','',''),(4117,'1','302','1',1,'Retail Sale Id 3960',3680.00,0.00,0.00,5.00,425.00,'2023-01-26 10:09:54','',''),(4118,'1','302','1',1,'Retail Sale Id 3961',2222.72,0.00,0.00,3.02,256.70,'2023-01-26 10:11:12','',''),(4119,'1','302','1',1,'Retail Sale Id 3962',3680.00,0.00,0.00,5.00,425.00,'2023-01-26 10:12:09','',''),(4120,'1','302','1',1,'Retail Sale Id 3963',16192.00,0.00,0.00,22.00,1870.00,'2023-01-26 10:14:01','',''),(4121,'1','302','1',1,'Retail Sale Id 3964',1501.44,0.00,0.00,2.04,173.40,'2023-01-26 10:17:14','',''),(4122,'1','302','1',1,'Retail Sale Id 3965',9200.00,0.00,0.00,12.50,1062.50,'2023-01-26 10:24:54','',''),(4123,'1','302','1',1,'Retail Sale Id 3966',7499.84,0.00,0.00,10.19,866.15,'2023-01-26 10:27:49','',''),(4124,'1','302','1',1,'Retail Sale Id 3967',1000.96,0.00,0.00,1.36,115.60,'2023-01-26 10:30:25','',''),(4125,'1','302','1',1,'Retail Sale Id 3968',4997.44,0.00,0.00,6.79,577.15,'2023-01-26 10:33:19','',''),(4126,'1','302','1',1,'Retail Sale Id 3968',4997.44,0.00,0.00,6.79,577.15,'2023-01-26 10:33:19','',''),(4127,'1','302','1',1,'Retail Sale Id 3969',3002.88,0.00,0.00,4.08,346.80,'2023-01-26 10:34:28','',''),(4128,'1','302','1',1,'Retail Sale Id 3970',2502.40,0.00,0.00,3.40,289.00,'2023-01-26 10:38:50','',''),(4129,'1','302','1',1,'Retail Sale Id 3971',3996.48,0.00,0.00,5.43,461.55,'2023-01-26 10:39:49','',''),(4130,'1','302','1',1,'Retail Sale Id 3972',3002.88,0.00,0.00,4.08,346.80,'2023-01-26 10:50:15','',''),(4131,'1','302','1',1,'Retail Sale Id 3974',3503.36,0.00,0.00,4.76,404.60,'2023-01-26 10:51:09','',''),(4132,'1','302','1',1,'Retail Sale Id 3975',9200.00,0.00,0.00,12.50,1062.50,'2023-01-26 10:54:18','',''),(4133,'1','302','1',1,'Retail Sale Id 3976',2001.92,0.00,0.00,2.72,231.20,'2023-01-26 10:58:30','',''),(4134,'1','302','1',1,'Retail Sale Id 3977',4401.28,0.00,0.00,5.98,508.30,'2023-01-26 11:01:35','',''),(4135,'1','302','1',1,'Retail Sale Id 3978',4416.00,0.00,0.00,6.00,510.00,'2023-01-26 11:04:41','',''),(4136,'1','302','1',1,'Retail Sale Id 3979',1000.96,0.00,0.00,1.36,115.60,'2023-01-26 11:08:29','',''),(4137,'1','302','1',1,'Retail Sale Id 3980',3002.88,0.00,0.00,4.08,346.80,'2023-01-26 11:09:58','',''),(4138,'1','302','1',1,'Retail Sale Id 3981',1000.96,0.00,0.00,1.36,115.60,'2023-01-26 11:11:07','',''),(4139,'1','302','1',1,'Retail Sale Id 3983',35500.00,0.00,0.00,50.00,2950.00,'2023-01-26 11:15:48','',''),(4140,'1','302','1',1,'Retail Sale Id 3985',4997.44,0.00,0.00,6.79,577.15,'2023-01-26 11:34:17','',''),(4141,'1','302','1',1,'Retail Sale Id 3986',2208.00,0.00,0.00,3.00,255.00,'2023-01-26 11:35:24','',''),(4142,'1','302','1',1,'Retail Sale Id 3987',35500.00,0.00,0.00,50.00,2950.00,'2023-01-26 11:43:19','',''),(4143,'1','302','1',1,'Retail Sale Id 3988',30530.00,0.00,0.00,43.00,2537.00,'2023-01-26 11:49:18','',''),(4144,'1','302','1',1,'Retail Sale Id 3989',9200.00,0.00,0.00,12.50,1062.50,'2023-01-26 11:50:12','',''),(4145,'1','302','1',1,'Retail Sale Id 3990',3702.08,0.00,0.00,5.03,427.55,'2023-01-26 11:59:41','',''),(4146,'1','302','1',1,'Retail Sale Id 3991',3503.36,0.00,0.00,4.76,404.60,'2023-01-26 12:08:38','',''),(4147,'1','302','1',1,'Retail Sale Id 3992',9200.00,0.00,0.00,12.50,1062.50,'2023-01-26 12:14:02','',''),(4148,'1','302','1',1,'Retail Sale Id 3993',5680.00,0.00,0.00,8.00,472.00,'2023-01-26 12:17:47','',''),(4149,'1','302','1',1,'Retail Sale Id 3994',4416.00,0.00,0.00,6.00,510.00,'2023-01-26 12:18:56','',''),(4150,'1','302','1',1,'Retail Sale Id 3996',3503.36,0.00,0.00,4.76,404.60,'2023-01-26 12:34:24','',''),(4151,'1','302','1',1,'Retail Sale Id 3997',3702.08,0.00,0.00,5.03,427.55,'2023-01-26 12:42:19','',''),(4152,'1','302','1',1,'Retail Sale Id 3998',2502.40,0.00,0.00,3.40,289.00,'2023-01-26 12:43:06','',''),(4153,'1','302','1',1,'Retail Sale Id 3999',3680.00,0.00,0.00,5.00,425.00,'2023-01-26 12:50:08','',''),(4154,'1','302','1',1,'Retail Sale Id 4000',736.00,0.00,0.00,1.00,85.00,'2023-01-26 13:02:27','',''),(4155,'1','302','1',1,'Retail Sale Id 4001',2001.92,0.00,0.00,2.72,231.20,'2023-01-26 13:16:27','',''),(4156,'1','302','1',1,'Retail Sale Id 4003',9200.00,0.00,0.00,12.50,1062.50,'2023-01-26 13:24:22','',''),(4157,'1','302','1',1,'Retail Sale Id 4003',9200.00,0.00,0.00,12.50,1062.50,'2023-01-26 13:24:22','',''),(4158,'1','302','1',1,'Retail Sale Id 4004',4416.00,0.00,0.00,6.00,510.00,'2023-01-26 13:27:53','',''),(4159,'1','302','1',1,'Retail Sale Id 4004',4416.00,0.00,0.00,6.00,510.00,'2023-01-26 13:27:53','',''),(4160,'1','302','1',1,'Retail Sale Id 4005',3002.88,0.00,0.00,4.08,346.80,'2023-01-26 13:36:55','',''),(4161,'1','302','1',1,'Retail Sale Id 4006',1199.68,0.00,0.00,1.63,138.55,'2023-01-26 13:38:08','',''),(4162,'1','302','1',1,'Retail Sale Id 4007',3002.88,0.00,0.00,4.08,346.80,'2023-01-26 13:44:40','',''),(4163,'1','302','1',1,'Retail Sale Id 4007',3996.48,0.00,0.00,5.43,461.55,'2023-01-26 13:44:40','',''),(4164,'1','302','1',1,'Retail Sale Id 4008',4496.96,0.00,0.00,6.11,519.35,'2023-01-26 13:45:44','',''),(4165,'1','302','1',1,'Retail Sale Id 4009',17750.00,0.00,0.00,25.00,1475.00,'2023-01-26 13:46:58','',''),(4166,'1','302','1',1,'Retail Sale Id 4010',9200.00,0.00,0.00,12.50,1062.50,'2023-01-26 14:11:14','',''),(4167,'1','302','1',1,'Retail Sale Id 4011',3002.88,0.00,0.00,4.08,346.80,'2023-01-26 14:12:52','',''),(4168,'1','302','1',1,'Retail Sale Id 4012',71000.00,0.00,0.00,100.00,5900.00,'2023-01-26 14:15:05','',''),(4169,'1','302','1',1,'Retail Sale Id 4013',1000.96,0.00,0.00,1.36,115.60,'2023-01-26 14:15:43','',''),(4170,'1','302','1',1,'Retail Sale Id 4014',3680.00,0.00,0.00,5.00,425.00,'2023-01-26 14:23:09','',''),(4171,'1','302','1',1,'Retail Sale Id 4016',3680.00,0.00,0.00,5.00,425.00,'2023-01-26 14:25:25','',''),(4172,'1','302','1',1,'Retail Sale Id 4017',4202.56,0.00,0.00,5.71,485.35,'2023-01-26 14:31:07','',''),(4173,'1','302','1',1,'Retail Sale Id 4018',3702.08,0.00,0.00,5.03,427.55,'2023-01-26 14:33:42','',''),(4174,'1','302','1',1,'Retail Sale Id 4019',1501.44,0.00,0.00,2.04,173.40,'2023-01-26 14:36:29','',''),(4175,'1','302','1',1,'Retail Sale Id 4020',9200.00,0.00,0.00,12.50,1062.50,'2023-01-26 14:38:03','',''),(4176,'1','302','1',1,'Retail Sale Id 4021',2208.00,0.00,0.00,3.00,255.00,'2023-01-26 14:42:15','',''),(4177,'1','302','1',1,'Retail Sale Id 4022',4401.28,0.00,0.00,5.98,508.30,'2023-01-26 14:54:41','',''),(4178,'1','302','1',1,'Retail Sale Id 4023',1000.96,0.00,0.00,1.36,115.60,'2023-01-26 14:55:34','',''),(4179,'1','302','1',1,'Retail Sale Id 4023',1000.96,0.00,0.00,1.36,115.60,'2023-01-26 14:55:34','',''),(4180,'1','302','1',1,'Retail Sale Id 4024',9200.00,0.00,0.00,12.50,1062.50,'2023-01-26 14:56:46','',''),(4181,'1','302','1',1,'Retail Sale Id 4025',3002.88,0.00,0.00,4.08,346.80,'2023-01-26 14:57:39','',''),(4182,'1','302','1',1,'Retail Sale Id 4026',4416.00,0.00,0.00,6.00,510.00,'2023-01-26 15:01:15','',''),(4183,'1','302','1',1,'Retail Sale Id 4026',4416.00,0.00,0.00,6.00,510.00,'2023-01-26 15:01:15','',''),(4184,'1','302','1',1,'Retail Sale Id 4027',1472.00,0.00,0.00,2.00,170.00,'2023-01-26 15:02:42','',''),(4185,'1','302','1',1,'Retail Sale Id 4028',3002.88,0.00,0.00,4.08,346.80,'2023-01-26 15:04:26','',''),(4186,'1','302','1',1,'Retail Sale Id 4029',3002.88,0.00,0.00,4.08,346.80,'2023-01-26 15:05:55','',''),(4187,'1','302','1',1,'Retail Sale Id 4030',2208.00,0.00,0.00,3.00,255.00,'2023-01-26 15:10:58','',''),(4188,'1','302','1',1,'Retail Sale Id 4031',9200.00,0.00,0.00,12.50,1062.50,'2023-01-26 15:13:32','',''),(4189,'1','302','1',1,'Retail Sale Id 4032',2200.64,0.00,0.00,2.99,254.15,'2023-01-26 15:19:41','',''),(4190,'1','302','1',1,'Retail Sale Id 4033',3680.00,0.00,0.00,5.00,425.00,'2023-01-26 15:27:56','',''),(4191,'1','302','1',1,'Retail Sale Id 4034',4416.00,0.00,0.00,6.00,510.00,'2023-01-26 15:31:17','',''),(4192,'1','302','1',1,'Retail Sale Id 4034',9200.00,0.00,0.00,12.50,1062.50,'2023-01-26 15:31:17','',''),(4193,'1','302','1',1,'Retail Sale Id 4034',9200.00,0.00,0.00,12.50,1062.50,'2023-01-26 15:31:17','',''),(4194,'1','302','1',1,'Retail Sale Id 4034',9200.00,0.00,0.00,12.50,1062.50,'2023-01-26 15:31:17','',''),(4195,'1','302','1',1,'Retail Sale Id 4035',3797.76,0.00,0.00,5.16,438.60,'2023-01-26 15:43:50','',''),(4196,'1','302','1',1,'Retail Sale Id 4036',3002.88,0.00,0.00,4.08,346.80,'2023-01-26 16:11:18','',''),(4197,'1','302','1',1,'Retail Sale Id 4037',2208.00,0.00,0.00,3.00,255.00,'2023-01-26 16:23:26','',''),(4198,'1','302','1',1,'Retail Sale Id 4038',3002.88,0.00,0.00,4.08,346.80,'2023-01-26 16:25:22','',''),(4199,'1','302','1',1,'Retail Sale Id 4039',17750.00,0.00,0.00,25.00,1475.00,'2023-01-26 16:27:01','',''),(4200,'1','302','1',1,'Retail Sale Id 4040',9200.00,0.00,0.00,12.50,1062.50,'2023-01-26 16:31:11','',''),(4201,'1','302','1',1,'Retail Sale Id 4041',2208.00,0.00,0.00,3.00,255.00,'2023-01-26 16:36:58','',''),(4202,'1','302','1',1,'Retail Sale Id 4042',5888.00,0.00,0.00,8.00,680.00,'2023-01-26 16:38:30','',''),(4203,'1','302','1',1,'Retail Sale Id 4043',9200.00,0.00,0.00,12.50,1062.50,'2023-01-26 16:39:15','',''),(4204,'1','302','1',1,'Retail Sale Id 4044',1803.20,0.00,0.00,2.45,208.25,'2023-01-26 16:40:25','',''),(4205,'1','302','1',1,'Retail Sale Id 4045',3002.88,0.00,0.00,4.08,346.80,'2023-01-26 17:01:47','',''),(4206,'1','302','1',1,'Retail Sale Id 4046',1398.40,0.00,0.00,1.90,161.50,'2023-01-26 17:08:49','',''),(4207,'1','302','1',1,'Retail Sale Id 4047',3797.76,0.00,0.00,5.16,438.60,'2023-01-26 17:09:46','',''),(4208,'1','302','1',1,'Retail Sale Id 4048',1501.44,0.00,0.00,2.04,173.40,'2023-01-26 17:23:32','',''),(4209,'1','302','1',1,'Retail Sale Id 4049',4416.00,0.00,0.00,6.00,510.00,'2023-01-26 17:24:42','',''),(4210,'1','302','1',1,'Retail Sale Id 4050',1000.96,0.00,0.00,1.36,115.60,'2023-01-26 17:40:11','',''),(4211,'1','302','1',1,'Retail Sale Id 4051',1501.44,0.00,0.00,2.04,173.40,'2023-01-26 17:41:27','',''),(4212,'1','302','1',1,'Retail Sale Id 4051',1501.44,0.00,0.00,2.04,173.40,'2023-01-26 17:41:27','',''),(4213,'1','302','1',1,'Retail Sale Id 4052',20887.68,0.00,0.00,28.38,2412.30,'2023-01-26 18:20:39','',''),(4214,'1','302','1',1,'Retail Sale Id 4053',7100.00,0.00,0.00,10.00,590.00,'2023-01-26 18:21:18','',''),(4215,'1','302','1',1,'Retail Sale Id 4054',1000.96,0.00,0.00,1.36,115.60,'2023-01-26 18:23:07','',''),(4216,'1','302','1',1,'Return of Retail Sale Id 4054',0.00,1000.96,1.36,0.00,-115.60,'2023-01-26 21:26:11','',''),(4217,'1','302','1',1,'Retail Sale Id 4055',36.80,0.00,0.00,0.05,4.25,'2023-01-26 21:27:17','',''),(4218,'1','302','1',1,'Retail Sale Id 4056',927.36,0.00,0.00,1.26,107.10,'2023-01-26 21:29:57','',''),(4219,'1','302','1',1,'Retail Sale Id 4057',18819.52,0.00,0.00,25.57,2173.45,'2023-01-27 07:49:57','',''),(4220,'1','302','1',1,'Retail Sale Id 4058',4496.96,0.00,0.00,6.11,519.35,'2023-01-27 07:58:41','',''),(4221,'1','302','1',1,'Retail Sale Id 4059',2208.00,0.00,0.00,3.00,255.00,'2023-01-27 08:06:31','',''),(4222,'1','302','1',1,'Retail Sale Id 4060',9200.00,0.00,0.00,12.50,1062.50,'2023-01-27 08:15:32','',''),(4223,'1','302','1',1,'Retail Sale Id 4061',1803.20,0.00,0.00,2.45,208.25,'2023-01-27 08:16:41','',''),(4224,'1','302','1',1,'Retail Sale Id 4062',4496.96,0.00,0.00,6.11,519.35,'2023-01-27 08:17:39','',''),(4225,'1','302','1',1,'Retail Sale Id 4063',3201.60,0.00,0.00,4.35,369.75,'2023-01-27 08:21:03','',''),(4226,'1','302','1',1,'Retail Sale Id 4064',2200.64,0.00,0.00,2.99,254.15,'2023-01-27 08:30:14','',''),(4227,'1','302','1',1,'Retail Sale Id 4065',3680.00,0.00,0.00,5.00,425.00,'2023-01-27 08:42:17','',''),(4228,'1','302','1',1,'Retail Sale Id 4066',1000.96,0.00,0.00,1.36,115.60,'2023-01-27 08:53:13','',''),(4229,'1','302','1',1,'Retail Sale Id 4067',500.48,0.00,0.00,0.68,57.80,'2023-01-27 08:54:11','',''),(4230,'1','302','1',1,'Retail Sale Id 4068',4496.96,0.00,0.00,6.11,519.35,'2023-01-27 09:06:29','',''),(4231,'1','302','1',1,'Retail Sale Id 4069',1501.44,0.00,0.00,2.04,173.40,'2023-01-27 09:07:25','',''),(4232,'1','302','1',1,'Retail Sale Id 4070',3503.36,0.00,0.00,4.76,404.60,'2023-01-27 09:25:43','',''),(4233,'1','302','1',1,'Retail Sale Id 4071',2200.64,0.00,0.00,2.99,254.15,'2023-01-27 09:26:59','',''),(4234,'1','302','1',1,'Retail Sale Id 4072',9200.00,0.00,0.00,12.50,1062.50,'2023-01-27 09:32:51','',''),(4235,'1','302','1',1,'Retail Sale Id 4073',9200.00,0.00,0.00,12.50,1062.50,'2023-01-27 09:34:14','',''),(4236,'1','302','1',1,'Retail Sale Id 4074',9200.00,0.00,0.00,12.50,1062.50,'2023-01-27 09:54:24','',''),(4237,'1','302','1',1,'Retail Sale Id 4075',3680.00,0.00,0.00,5.00,425.00,'2023-01-27 10:01:12','',''),(4238,'1','302','1',1,'Retail Sale Id 4076',2001.92,0.00,0.00,2.72,231.20,'2023-01-27 10:02:41','',''),(4239,'1','302','1',1,'Retail Sale Id 4077',9200.00,0.00,0.00,12.50,1062.50,'2023-01-27 10:09:13','',''),(4240,'1','302','1',1,'Retail Sale Id 4078',9200.00,0.00,0.00,12.50,1062.50,'2023-01-27 10:18:37','',''),(4241,'1','302','1',1,'Retail Sale Id 4079',2001.92,0.00,0.00,2.72,231.20,'2023-01-27 10:20:12','',''),(4242,'1','302','1',1,'Retail Sale Id 4080',802.24,0.00,0.00,1.09,92.65,'2023-01-27 10:22:33','',''),(4243,'1','302','1',1,'Retail Sale Id 4080',1000.96,0.00,0.00,1.36,115.60,'2023-01-27 10:22:33','',''),(4244,'1','302','1',1,'Retail Sale Id 4081',3002.88,0.00,0.00,4.08,346.80,'2023-01-27 10:25:22','',''),(4245,'1','302','1',1,'Retail Sale Id 4082',2001.92,0.00,0.00,2.72,231.20,'2023-01-27 10:27:02','',''),(4246,'1','302','1',1,'Retail Sale Id 4083',1000.96,0.00,0.00,1.36,115.60,'2023-01-27 10:29:27','',''),(4247,'1','302','1',1,'Retail Sale Id 4085',3680.00,0.00,0.00,5.00,425.00,'2023-01-27 10:45:18','',''),(4248,'1','302','1',1,'Retail Sale Id 4086',2208.00,0.00,0.00,3.00,255.00,'2023-01-27 10:49:42','',''),(4249,'1','302','1',1,'Retail Sale Id 4087',9200.00,0.00,0.00,12.50,1062.50,'2023-01-27 10:59:25','',''),(4250,'1','302','1',1,'Retail Sale Id 4088',4496.96,0.00,0.00,6.11,519.35,'2023-01-27 11:07:23','',''),(4251,'1','302','1',1,'Retail Sale Id 4089',1501.44,0.00,0.00,2.04,173.40,'2023-01-27 11:10:42','',''),(4252,'1','302','1',1,'Retail Sale Id 4090',2208.00,0.00,0.00,3.00,255.00,'2023-01-27 11:12:45','',''),(4253,'1','302','1',1,'Retail Sale Id 4091',3002.88,0.00,0.00,4.08,346.80,'2023-01-27 11:16:26','',''),(4254,'1','302','1',1,'Retail Sale Id 4091',9200.00,0.00,0.00,12.50,1062.50,'2023-01-27 11:16:26','',''),(4255,'1','302','1',1,'Retail Sale Id 4092',2208.00,0.00,0.00,3.00,255.00,'2023-01-27 11:18:46','',''),(4256,'1','302','1',1,'Retail Sale Id 4093',4416.00,0.00,0.00,6.00,510.00,'2023-01-27 11:22:32','',''),(4257,'1','302','1',1,'Retail Sale Id 4093',9200.00,0.00,0.00,12.50,1062.50,'2023-01-27 11:22:32','',''),(4258,'1','302','1',1,'Retail Sale Id 4094',3201.60,0.00,0.00,4.35,369.75,'2023-01-27 11:23:39','',''),(4259,'1','302','1',1,'Retail Sale Id 4095',3002.88,0.00,0.00,4.08,346.80,'2023-01-27 11:24:24','',''),(4260,'1','302','1',1,'Retail Sale Id 4096',4416.00,0.00,0.00,6.00,510.00,'2023-01-27 11:26:29','',''),(4261,'1','302','1',1,'Retail Sale Id 4097',2001.92,0.00,0.00,2.72,231.20,'2023-01-27 11:29:18','',''),(4262,'1','302','1',1,'Retail Sale Id 4098',20590.00,0.00,0.00,29.00,1711.00,'2023-01-27 11:37:17','',''),(4263,'1','302','1',1,'Retail Sale Id 4099',4496.96,0.00,0.00,6.11,519.35,'2023-01-27 11:52:18','',''),(4264,'1','302','1',1,'Retail Sale Id 4100',4496.96,0.00,0.00,6.11,519.35,'2023-01-27 11:53:27','',''),(4265,'1','302','1',1,'Retail Sale Id 4101',2944.00,0.00,0.00,4.00,340.00,'2023-01-27 11:55:44','',''),(4266,'1','302','1',1,'Retail Sale Id 4101',3680.00,0.00,0.00,5.00,425.00,'2023-01-27 11:55:44','',''),(4267,'1','302','1',1,'Retail Sale Id 4102',1501.44,0.00,0.00,2.04,173.40,'2023-01-27 11:57:14','',''),(4268,'1','302','1',1,'Retail Sale Id 4102',1501.44,0.00,0.00,2.04,173.40,'2023-01-27 11:57:14','',''),(4269,'1','302','1',1,'Retail Sale Id 4103',699.20,0.00,0.00,0.95,80.75,'2023-01-27 12:03:08','',''),(4270,'1','302','1',1,'Retail Sale Id 4103',699.20,0.00,0.00,0.95,80.75,'2023-01-27 12:03:08','',''),(4271,'1','302','1',1,'Retail Sale Id 4104',1501.44,0.00,0.00,2.04,173.40,'2023-01-27 12:13:19','',''),(4272,'1','302','1',1,'Retail Sale Id 4105',736.00,0.00,0.00,1.00,85.00,'2023-01-27 12:16:50','',''),(4273,'1','302','1',1,'Retail Sale Id 4106',2001.92,0.00,0.00,2.72,231.20,'2023-01-27 12:26:51','',''),(4274,'1','302','1',1,'Retail Sale Id 4107',3680.00,0.00,0.00,5.00,425.00,'2023-01-27 12:46:27','',''),(4275,'1','302','1',1,'Retail Sale Id 4108',1501.44,0.00,0.00,2.04,173.40,'2023-01-27 13:43:21','',''),(4276,'1','302','1',1,'Retail Sale Id 4109',1501.44,0.00,0.00,2.04,173.40,'2023-01-27 14:02:56','',''),(4277,'1','302','1',1,'Retail Sale Id 4110',4416.00,0.00,0.00,6.00,510.00,'2023-01-27 14:03:38','',''),(4278,'1','302','1',1,'Retail Sale Id 4111',1501.44,0.00,0.00,2.04,173.40,'2023-01-27 14:14:03','',''),(4279,'1','302','1',1,'Retail Sale Id 4112',1000.96,0.00,0.00,1.36,115.60,'2023-01-27 14:14:46','',''),(4280,'1','302','1',1,'Retail Sale Id 4113',35500.00,0.00,0.00,50.00,2950.00,'2023-01-27 14:18:35','',''),(4281,'1','302','1',1,'Retail Sale Id 4114',1096.64,0.00,0.00,1.49,126.65,'2023-01-27 14:25:38','',''),(4282,'1','302','1',1,'Retail Sale Id 4115',4260.00,0.00,0.00,6.00,354.00,'2023-01-27 14:27:44','',''),(4283,'1','302','1',1,'Retail Sale Id 4116',2208.00,0.00,0.00,3.00,255.00,'2023-01-27 14:30:36','',''),(4284,'1','302','1',1,'Retail Sale Id 4117',1000.96,0.00,0.00,1.36,115.60,'2023-01-27 14:42:20','',''),(4285,'1','302','1',1,'Retail Sale Id 4118',4416.00,0.00,0.00,6.00,510.00,'2023-01-27 14:45:09','',''),(4286,'1','302','1',1,'Retail Sale Id 4119',4496.96,0.00,0.00,6.11,519.35,'2023-01-27 14:46:07','',''),(4287,'1','302','1',1,'Retail Sale Id 4120',2001.92,0.00,0.00,2.72,231.20,'2023-01-27 14:48:17','',''),(4288,'1','302','1',1,'Retail Sale Id 4121',2208.00,0.00,0.00,3.00,255.00,'2023-01-27 14:50:53','',''),(4289,'1','302','1',1,'Retail Sale Id 4122',2208.00,0.00,0.00,3.00,255.00,'2023-01-27 14:56:14','',''),(4290,'1','302','1',1,'Retail Sale Id 4123',802.24,0.00,0.00,1.09,92.65,'2023-01-27 14:57:00','',''),(4291,'1','302','1',1,'Retail Sale Id 4124',9200.00,0.00,0.00,12.50,1062.50,'2023-01-27 14:59:46','',''),(4292,'1','302','1',1,'Retail Sale Id 4125',3680.00,0.00,0.00,5.00,425.00,'2023-01-27 15:05:48','',''),(4293,'1','302','1',1,'Retail Sale Id 4126',9200.00,0.00,0.00,12.50,1062.50,'2023-01-27 15:13:42','',''),(4294,'1','302','1',1,'Retail Sale Id 4127',2208.00,0.00,0.00,3.00,255.00,'2023-01-27 15:28:03','',''),(4295,'1','302','1',1,'Retail Sale Id 4128',2502.40,0.00,0.00,3.40,289.00,'2023-01-27 15:33:25','',''),(4296,'1','302','1',1,'Retail Sale Id 4129',53250.00,0.00,0.00,75.00,4425.00,'2023-01-27 15:39:44','',''),(4297,'1','302','1',1,'Retail Sale Id 4130',2208.00,0.00,0.00,3.00,255.00,'2023-01-27 15:41:00','',''),(4298,'1','302','1',1,'Retail Sale Id 4131',64610.00,0.00,0.00,91.00,5369.00,'2023-01-27 16:12:06','',''),(4299,'1','302','1',1,'Retail Sale Id 4132',4416.00,0.00,0.00,6.00,510.00,'2023-01-27 16:13:05','',''),(4300,'1','302','1',1,'Retail Sale Id 4133',1472.00,0.00,0.00,2.00,170.00,'2023-01-27 16:16:11','',''),(4301,'1','302','1',1,'Retail Sale Id 4134',4496.96,0.00,0.00,6.11,519.35,'2023-01-27 16:19:29','',''),(4302,'1','302','1',1,'Retail Sale Id 4135',2944.00,0.00,0.00,4.00,340.00,'2023-01-27 16:21:26','',''),(4303,'1','302','1',1,'Retail Sale Id 4136',9200.00,0.00,0.00,12.50,1062.50,'2023-01-27 16:42:21','',''),(4304,'1','302','1',1,'Retail Sale Id 4137',8832.00,0.00,0.00,12.00,1020.00,'2023-01-27 16:44:20','',''),(4305,'1','302','1',1,'Retail Sale Id 4138',14200.00,0.00,0.00,20.00,1180.00,'2023-01-27 17:00:07','',''),(4306,'1','302','1',1,'Retail Sale Id 4139',4423.36,0.00,0.00,6.01,510.85,'2023-01-27 17:04:16','',''),(4307,'1','302','1',1,'Retail Sale Id 4140',9200.00,0.00,0.00,12.50,1062.50,'2023-01-27 17:20:13','',''),(4308,'1','302','1',1,'Retail Sale Id 4141',9200.00,0.00,0.00,12.50,1062.50,'2023-01-27 17:30:21','',''),(4309,'1','302','1',1,'Retail Sale Id 4142',1000.96,0.00,0.00,1.36,115.60,'2023-01-27 17:30:56','',''),(4310,'1','302','1',1,'Retail Sale Id 4143',2001.92,0.00,0.00,2.72,231.20,'2023-01-27 17:39:55','',''),(4311,'1','302','1',1,'Retail Sale Id 4144',2303.68,0.00,0.00,3.13,266.05,'2023-01-27 17:41:04','',''),(4312,'1','302','1',1,'Retail Sale Id 4145',3002.88,0.00,0.00,4.08,346.80,'2023-01-27 17:41:54','',''),(4313,'1','302','1',1,'Retail Sale Id 4146',3503.36,0.00,0.00,4.76,404.60,'2023-01-27 17:48:36','',''),(4314,'1','302','1',1,'Retail Sale Id 4147',4416.00,0.00,0.00,6.00,510.00,'2023-01-27 17:53:09','',''),(4315,'1','302','1',1,'Retail Sale Id 4148',6624.00,0.00,0.00,9.00,765.00,'2023-01-27 17:58:37','',''),(4316,'1','302','1',1,'Retail Sale Id 4149',3905.00,0.00,0.00,5.50,324.50,'2023-01-27 18:10:59','',''),(4317,'1','302','1',1,'Retail Sale Id 4150',736.00,0.00,0.00,1.00,85.00,'2023-01-27 18:12:07','',''),(4318,'1','302','1',1,'Retail Sale Id 4151',5203.52,0.00,0.00,7.07,600.95,'2023-01-27 18:14:22','',''),(4319,'1','302','1',1,'Retail Sale Id 4152',4416.00,0.00,0.00,6.00,510.00,'2023-01-27 18:24:34','',''),(4320,'1','302','1',1,'Retail Sale Id 4152',9200.00,0.00,0.00,12.50,1062.50,'2023-01-27 18:24:34','',''),(4321,'1','302','1',1,'Return of Retail Sale Id 4143',0.00,2001.92,2.72,0.00,-231.20,'2023-01-27 19:06:09','',''),(4322,'1','302','1',1,'Retail Sale Id 4153',66.24,0.00,0.00,0.09,7.65,'2023-01-27 19:07:09','',''),(4323,'1','302','1',1,'Retail Sale Id 4154',4416.00,0.00,0.00,6.00,510.00,'2023-01-28 11:16:43','',''),(4324,'1','302','1',1,'Retail Sale Id 4155',728.64,0.00,0.00,0.99,84.15,'2023-01-28 11:18:49','',''),(4325,'1','302','1',1,'Retail Sale Id 4156',2200.64,0.00,0.00,2.99,254.15,'2023-01-28 11:19:41','',''),(4326,'1','302','1',1,'Retail Sale Id 4157',3996.48,0.00,0.00,5.43,461.55,'2023-01-28 11:20:33','',''),(4327,'1','302','1',1,'Retail Sale Id 4158',1501.44,0.00,0.00,2.04,173.40,'2023-01-28 11:21:16','',''),(4328,'1','302','1',1,'Retail Sale Id 4159',4496.96,0.00,0.00,6.11,519.35,'2023-01-28 11:29:39','',''),(4329,'1','302','1',1,'Retail Sale Id 4160',4416.00,0.00,0.00,6.00,510.00,'2023-01-28 11:31:14','',''),(4330,'1','302','1',1,'Retail Sale Id 4161',2001.92,0.00,0.00,2.72,231.20,'2023-01-28 11:37:21','',''),(4331,'1','302','1',1,'Retail Sale Id 4162',3996.48,0.00,0.00,5.43,461.55,'2023-01-28 11:39:10','',''),(4332,'1','302','1',1,'Retail Sale Id 4164',2200.64,0.00,0.00,2.99,254.15,'2023-01-28 11:43:12','',''),(4333,'1','302','1',1,'Retail Sale Id 4165',4496.96,0.00,0.00,6.11,519.35,'2023-01-28 11:46:41','',''),(4334,'1','302','1',1,'Retail Sale Id 4166',9200.00,0.00,0.00,12.50,1062.50,'2023-01-28 11:48:29','',''),(4335,'1','302','1',1,'Retail Sale Id 4167',4496.96,0.00,0.00,6.11,519.35,'2023-01-28 11:49:32','',''),(4336,'1','302','1',1,'Retail Sale Id 4168',17750.00,0.00,0.00,25.00,1475.00,'2023-01-28 11:57:25','',''),(4337,'1','302','1',1,'Retail Sale Id 4169',4496.96,0.00,0.00,6.11,519.35,'2023-01-28 12:01:39','',''),(4338,'1','302','1',1,'Retail Sale Id 4170',4416.00,0.00,0.00,6.00,510.00,'2023-01-28 12:02:39','',''),(4339,'1','302','1',1,'Retail Sale Id 4171',1501.44,0.00,0.00,2.04,173.40,'2023-01-28 12:10:55','',''),(4340,'1','302','1',1,'Retail Sale Id 4172',2001.92,0.00,0.00,2.72,231.20,'2023-01-28 12:11:40','',''),(4341,'1','302','1',1,'Retail Sale Id 4173',1501.44,0.00,0.00,2.04,173.40,'2023-01-28 12:13:56','',''),(4342,'1','302','1',1,'Retail Sale Id 4174',4496.96,0.00,0.00,6.11,519.35,'2023-01-28 12:19:34','',''),(4343,'1','302','1',1,'Retail Sale Id 4175',9200.00,0.00,0.00,12.50,1062.50,'2023-01-28 12:20:34','',''),(4344,'1','302','1',1,'Retail Sale Id 4175',9200.00,0.00,0.00,12.50,1062.50,'2023-01-28 12:20:34','',''),(4345,'1','302','1',1,'Retail Sale Id 4176',3680.00,0.00,0.00,5.00,425.00,'2023-01-28 12:22:43','',''),(4346,'1','302','1',1,'Retail Sale Id 4177',4496.96,0.00,0.00,6.11,519.35,'2023-01-28 12:23:58','',''),(4347,'1','302','1',1,'Retail Sale Id 4178',18400.00,0.00,0.00,25.00,2125.00,'2023-01-28 12:27:13','',''),(4348,'1','302','1',1,'Retail Sale Id 4179',699.20,0.00,0.00,0.95,80.75,'2023-01-28 12:29:29','',''),(4349,'1','302','1',1,'Retail Sale Id 4181',4997.44,0.00,0.00,6.79,577.15,'2023-01-28 12:45:18','',''),(4350,'1','302','1',1,'Retail Sale Id 4183',2303.68,0.00,0.00,3.13,266.05,'2023-01-28 12:47:43','',''),(4351,'1','302','1',1,'Retail Sale Id 4184',3702.08,0.00,0.00,5.03,427.55,'2023-01-28 12:51:41','',''),(4352,'1','302','1',1,'Retail Sale Id 4185',4496.96,0.00,0.00,6.11,519.35,'2023-01-28 12:54:47','',''),(4353,'1','302','1',1,'Retail Sale Id 4186',33512.00,0.00,0.00,47.20,2784.80,'2023-01-28 13:05:49','',''),(4354,'1','302','1',1,'Retail Sale Id 4187',9200.00,0.00,0.00,12.50,1062.50,'2023-01-28 13:08:35','',''),(4355,'1','302','1',1,'Retail Sale Id 4188',35500.00,0.00,0.00,50.00,2950.00,'2023-01-28 13:09:36','',''),(4356,'1','302','1',1,'Retail Sale Id 4189',9200.00,0.00,0.00,12.50,1062.50,'2023-01-28 13:10:56','',''),(4357,'1','302','1',1,'Retail Sale Id 4190',65437.76,0.00,0.00,88.91,7557.35,'2023-01-28 13:13:03','',''),(4358,'1','302','1',1,'Retail Sale Id 4191',1472.00,0.00,0.00,2.00,170.00,'2023-01-28 13:29:49','',''),(4359,'1','302','1',1,'Retail Sale Id 4192',4416.00,0.00,0.00,6.00,510.00,'2023-01-28 13:37:41','',''),(4360,'1','302','1',1,'Retail Sale Id 4193',4416.00,0.00,0.00,6.00,510.00,'2023-01-28 13:39:37','',''),(4361,'1','302','1',1,'Retail Sale Id 4194',35500.00,0.00,0.00,50.00,2950.00,'2023-01-28 13:48:04','',''),(4362,'1','302','1',1,'Retail Sale Id 4195',2208.00,0.00,0.00,3.00,255.00,'2023-01-28 13:51:28','',''),(4363,'1','302','1',1,'Retail Sale Id 4195',2208.00,0.00,0.00,3.00,255.00,'2023-01-28 13:51:28','',''),(4364,'1','302','1',1,'Retail Sale Id 4195',4416.00,0.00,0.00,6.00,510.00,'2023-01-28 13:51:28','',''),(4365,'1','302','1',1,'Retail Sale Id 4195',4416.00,0.00,0.00,6.00,510.00,'2023-01-28 13:51:28','',''),(4366,'1','302','1',1,'Retail Sale Id 4196',1501.44,0.00,0.00,2.04,173.40,'2023-01-28 13:52:47','',''),(4367,'1','302','1',1,'Retail Sale Id 4197',1494.08,0.00,0.00,2.03,172.55,'2023-01-28 13:54:38','',''),(4368,'1','302','1',1,'Retail Sale Id 4197',2208.00,0.00,0.00,3.00,255.00,'2023-01-28 13:54:38','',''),(4369,'1','302','1',1,'Retail Sale Id 4198',3680.00,0.00,0.00,5.00,425.00,'2023-01-28 14:03:41','',''),(4370,'1','302','1',1,'Retail Sale Id 4198',4416.00,0.00,0.00,6.00,510.00,'2023-01-28 14:03:41','',''),(4371,'1','302','1',1,'Retail Sale Id 4199',9200.00,0.00,0.00,12.50,1062.50,'2023-01-28 14:19:37','',''),(4372,'1','302','1',1,'Retail Sale Id 4200',9200.00,0.00,0.00,12.50,1062.50,'2023-01-28 14:21:27','',''),(4373,'1','302','1',1,'Retail Sale Id 4201',2200.64,0.00,0.00,2.99,254.15,'2023-01-28 14:27:50','',''),(4374,'1','302','1',1,'Retail Sale Id 4202',9200.00,0.00,0.00,12.50,1062.50,'2023-01-28 14:42:47','',''),(4375,'1','302','1',1,'Retail Sale Id 4203',2840.00,0.00,0.00,4.00,236.00,'2023-01-28 15:00:17','',''),(4376,'1','302','1',1,'Retail Sale Id 4204',4416.00,0.00,0.00,6.00,510.00,'2023-01-28 15:03:28','',''),(4377,'1','302','1',1,'Return of Retail Sale Id 4204',0.00,4416.00,6.00,0.00,-510.00,'2023-01-28 15:30:57','',''),(4378,'1','302','1',1,'Return of Retail Sale Id 4203',0.00,2840.00,4.00,0.00,-236.00,'2023-01-28 15:32:14','',''),(4379,'1','302','1',1,'Retail Sale Id 4205',9975.50,0.00,0.00,14.05,828.95,'2023-01-28 15:39:32','',''),(4380,'1','302','1',1,'Return of Retail Sale Id 4195',0.00,2208.00,3.00,0.00,-255.00,'2023-01-28 17:03:14','',''),(4381,'1','302','1',1,'Return of Retail Sale Id 4195',0.00,2208.00,3.00,0.00,-255.00,'2023-01-28 17:03:14','',''),(4382,'1','302','1',1,'Return of Retail Sale Id 4195',0.00,4416.00,6.00,0.00,-510.00,'2023-01-28 17:03:14','',''),(4383,'1','302','1',1,'Return of Retail Sale Id 4195',0.00,4416.00,6.00,0.00,-510.00,'2023-01-28 17:03:14','',''),(4384,'1','302','1',1,'Return of Retail Sale Id 4193',0.00,4416.00,6.00,0.00,-510.00,'2023-01-28 17:04:38','',''),(4385,'1','302','1',1,'Return of Retail Sale Id 4199',0.00,9200.00,12.50,0.00,-1062.50,'2023-01-28 17:05:48','',''),(4386,'1','302','1',1,'Return of Retail Sale Id 4196',0.00,1501.44,2.04,0.00,-173.40,'2023-01-28 17:08:12','',''),(4387,'1','302','1',1,'Retail Sale Id 4206',1288.00,0.00,0.00,1.75,148.75,'2023-01-28 17:09:17','',''),(4388,'1','302','1',1,'Return of Retail Sale Id 4179',0.00,699.20,0.95,0.00,-80.75,'2023-01-28 17:30:42','',''),(4389,'1','302','1',1,'Retail Sale Id 4207',699.20,0.00,0.00,0.95,80.75,'2023-01-28 17:32:26','',''),(4390,'1','302','1',1,'Retail Sale Id 4208',26120.90,0.00,0.00,36.79,2170.61,'2023-01-28 17:39:07','',''),(4391,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,68355.00,105.00,0.00,0.00,'2023-01-28 17:43:07','',''),(4392,'1','302',NULL,1,'Reception corrector for bridging 27',0.00,0.00,0.00,105.00,0.00,'2023-01-28 17:44:43','',''),(4393,'1','302','1',1,'Received from bridging 27',0.00,0.00,105.00,0.00,0.00,'2023-01-28 17:44:43','',''),(4394,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,651.00,1.00,0.00,0.00,'2023-01-28 17:52:55','',''),(4395,'1','302',NULL,1,'Reception corrector for bridging 28',0.00,0.00,0.00,1.00,0.00,'2023-01-28 17:55:17','',''),(4396,'1','302','1',1,'Received from bridging 28',0.00,0.00,1.00,0.00,0.00,'2023-01-28 17:55:17','',''),(4397,'1','302','1',1,'Returned bridging 27',0.00,0.00,0.00,105.00,0.00,'2023-01-28 20:07:55','',''),(4398,'1','302',NULL,1,'Reception Return corrector for bridging 27',0.00,0.00,105.00,0.00,0.00,'2023-01-28 20:07:55','',''),(4399,'1','302','1',1,'Returned bridging 28',0.00,0.00,0.00,1.00,0.00,'2023-01-28 20:09:14','',''),(4400,'1','302',NULL,1,'Reception Return corrector for bridging 28',0.00,0.00,1.00,0.00,0.00,'2023-01-28 20:09:14','',''),(4401,'1','302',NULL,1,'Reception corrector for bridging 29',0.00,0.00,0.00,105.00,0.00,'2023-01-28 20:13:11','',''),(4402,'1','302','1',1,'Received from bridging 29',0.00,0.00,105.00,0.00,0.00,'2023-01-28 20:13:11','',''),(4403,'1','302','1',1,'Retail Sale Id 4219',736.00,0.00,0.00,1.00,85.00,'2023-01-28 23:02:53','',''),(4404,'1','302','1',1,'Retail Sale Id 4220',73840.00,0.00,0.00,104.00,6136.00,'2023-01-28 23:19:29','',''),(4405,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,1367100.00,2100.00,0.00,0.00,'2023-01-29 09:27:25','',''),(4406,'1','302',NULL,1,'Reception corrector for bridging 30',0.00,0.00,0.00,2100.00,0.00,'2023-01-29 09:58:54','',''),(4407,'1','302','1',1,'Received from bridging 30',0.00,0.00,2100.00,0.00,0.00,'2023-01-29 09:58:54','',''),(4408,'1','302','1',1,'Retail Sale Id 4222',9940.00,0.00,0.00,14.00,826.00,'2023-01-29 10:16:40','',''),(4409,'1','302','1',1,'Retail Sale Id 4223',177500.00,0.00,0.00,250.00,14750.00,'2023-01-29 10:17:32','',''),(4410,'1','302','1',1,'Retail Sale Id 4224',106500.00,0.00,0.00,150.00,8850.00,'2023-01-29 10:18:25','',''),(4411,'1','302','1',1,'Retail Sale Id 4225',83800.96,0.00,0.00,113.86,9678.10,'2023-01-29 10:20:11','',''),(4412,'1','302','1',1,'Retail Sale Id 4226',2130.00,0.00,0.00,3.00,177.00,'2023-01-29 10:21:55','',''),(4413,'1','302','1',1,'Retail Sale Id 4228',21300.00,0.00,0.00,30.00,1770.00,'2023-01-29 10:25:42','',''),(4414,'1','302','1',1,'Retail Sale Id 4229',61375.04,0.00,0.00,83.39,7088.15,'2023-01-29 10:28:18','',''),(4415,'1','302','1',1,'Retail Sale Id 4230',3680.00,0.00,0.00,5.00,425.00,'2023-01-29 10:33:49','',''),(4416,'1','302','1',1,'Retail Sale Id 4231',1000.96,0.00,0.00,1.36,115.60,'2023-01-29 10:35:17','',''),(4417,'1','302','1',1,'Retail Sale Id 4232',9200.00,0.00,0.00,12.50,1062.50,'2023-01-29 10:37:44','',''),(4418,'1','302','1',1,'Retail Sale Id 4233',9200.00,0.00,0.00,12.50,1062.50,'2023-01-29 10:42:09','',''),(4419,'1','302','1',1,'Retail Sale Id 4234',4496.96,0.00,0.00,6.11,519.35,'2023-01-29 10:44:50','',''),(4420,'1','302','1',1,'Retail Sale Id 4235',750.72,0.00,0.00,1.02,86.70,'2023-01-29 10:46:05','',''),(4421,'1','302','1',1,'Retail Sale Id 4236',2001.92,0.00,0.00,2.72,231.20,'2023-01-29 11:00:28','',''),(4422,'1','302','1',1,'Retail Sale Id 4237',802.24,0.00,0.00,1.09,92.65,'2023-01-29 11:18:26','',''),(4423,'1','302','1',1,'Retail Sale Id 4238',3996.48,0.00,0.00,5.43,461.55,'2023-01-29 11:19:21','',''),(4424,'1','302','1',1,'Retail Sale Id 4239',4496.96,0.00,0.00,6.11,519.35,'2023-01-29 11:21:06','',''),(4425,'1','302','1',1,'Retail Sale Id 4240',2001.92,0.00,0.00,2.72,231.20,'2023-01-29 11:29:51','',''),(4426,'1','302','1',1,'Retail Sale Id 4241',1000.96,0.00,0.00,1.36,115.60,'2023-01-29 11:31:47','',''),(4427,'1','302','1',1,'Retail Sale Id 4243',8000.32,0.00,0.00,10.87,923.95,'2023-01-29 11:35:00','',''),(4428,'1','302','1',1,'Retail Sale Id 4244',71000.00,0.00,0.00,100.00,5900.00,'2023-01-29 11:36:03','',''),(4429,'1','302','1',1,'Retail Sale Id 4245',17750.00,0.00,0.00,25.00,1475.00,'2023-01-29 11:37:23','',''),(4430,'1','302','1',1,'Retail Sale Id 4246',4401.28,0.00,0.00,5.98,508.30,'2023-01-29 11:39:43','',''),(4431,'1','302','1',1,'Retail Sale Id 4247',3002.88,0.00,0.00,4.08,346.80,'2023-01-29 11:40:46','',''),(4432,'1','302','1',1,'Retail Sale Id 4248',1472.00,0.00,0.00,2.00,170.00,'2023-01-29 11:44:42','',''),(4433,'1','302','1',1,'Retail Sale Id 4249',1501.44,0.00,0.00,2.04,173.40,'2023-01-29 11:46:28','',''),(4434,'1','302','1',1,'Retail Sale Id 4250',9200.00,0.00,0.00,12.50,1062.50,'2023-01-29 11:48:05','',''),(4435,'1','302','1',1,'Retail Sale Id 4251',5152.00,0.00,0.00,7.00,595.00,'2023-01-29 11:49:17','',''),(4436,'1','302','1',1,'Retail Sale Id 4252',1000.96,0.00,0.00,1.36,115.60,'2023-01-29 11:50:28','',''),(4437,'1','302','1',1,'Retail Sale Id 4253',8875.00,0.00,0.00,12.50,737.50,'2023-01-29 11:57:58','',''),(4438,'1','302','1',1,'Retail Sale Id 4254',9200.00,0.00,0.00,12.50,1062.50,'2023-01-29 11:59:08','',''),(4439,'1','302','1',1,'Retail Sale Id 4255',3680.00,0.00,0.00,5.00,425.00,'2023-01-29 12:00:54','',''),(4440,'1','302','1',1,'Retail Sale Id 4256',4416.00,0.00,0.00,6.00,510.00,'2023-01-29 12:01:56','',''),(4441,'1','302','1',1,'Retail Sale Id 4257',9200.00,0.00,0.00,12.50,1062.50,'2023-01-29 12:14:16','',''),(4442,'1','302','1',1,'Retail Sale Id 4258',4416.00,0.00,0.00,6.00,510.00,'2023-01-29 12:17:59','',''),(4443,'1','302','1',1,'Retail Sale Id 4259',8832.00,0.00,0.00,12.00,1020.00,'2023-01-29 12:19:57','',''),(4444,'1','302','1',1,'Retail Sale Id 4260',4496.96,0.00,0.00,6.11,519.35,'2023-01-29 12:21:09','',''),(4445,'1','302','1',1,'Retail Sale Id 4261',2502.40,0.00,0.00,3.40,289.00,'2023-01-29 12:28:04','',''),(4446,'1','302','1',1,'Retail Sale Id 4262',9200.00,0.00,0.00,12.50,1062.50,'2023-01-29 12:29:24','',''),(4447,'1','302','1',1,'Retail Sale Id 4263',1700.16,0.00,0.00,2.31,196.35,'2023-01-29 12:42:28','',''),(4448,'1','302','1',1,'Retail Sale Id 4264',4416.00,0.00,0.00,6.00,510.00,'2023-01-29 12:43:28','',''),(4449,'1','302','1',1,'Retail Sale Id 4265',3002.88,0.00,0.00,4.08,346.80,'2023-01-29 12:47:43','',''),(4450,'1','302','1',1,'Retail Sale Id 4266',750.72,0.00,0.00,1.02,86.70,'2023-01-29 12:57:45','',''),(4451,'1','302','1',1,'Retail Sale Id 4267',4423.36,0.00,0.00,6.01,510.85,'2023-01-29 12:58:47','',''),(4452,'1','302','1',1,'Retail Sale Id 4269',2222.72,0.00,0.00,3.02,256.70,'2023-01-29 13:03:57','',''),(4453,'1','302','1',1,'Retail Sale Id 4270',3680.00,0.00,0.00,5.00,425.00,'2023-01-29 13:12:52','',''),(4454,'1','302','1',1,'Retail Sale Id 4270',4416.00,0.00,0.00,6.00,510.00,'2023-01-29 13:12:52','',''),(4455,'1','302','1',1,'Retail Sale Id 4271',2208.00,0.00,0.00,3.00,255.00,'2023-01-29 13:14:24','',''),(4456,'1','302','1',1,'Retail Sale Id 4272',1000.96,0.00,0.00,1.36,115.60,'2023-01-29 13:28:01','',''),(4457,'1','302','1',1,'Retail Sale Id 4273',6999.36,0.00,0.00,9.51,808.35,'2023-01-29 13:29:14','',''),(4458,'1','302','1',1,'Retail Sale Id 4274',9200.00,0.00,0.00,12.50,1062.50,'2023-01-29 13:30:55','',''),(4459,'1','302','1',1,'Retail Sale Id 4275',1501.44,0.00,0.00,2.04,173.40,'2023-01-29 13:33:06','',''),(4460,'1','302','1',1,'Retail Sale Id 4276',1000.96,0.00,0.00,1.36,115.60,'2023-01-29 13:34:47','',''),(4461,'1','302','1',1,'Retail Sale Id 4278',4416.00,0.00,0.00,6.00,510.00,'2023-01-29 13:35:39','',''),(4462,'1','302','1',1,'Retail Sale Id 4279',8832.00,0.00,0.00,12.00,1020.00,'2023-01-29 13:36:56','',''),(4463,'1','302','1',1,'Retail Sale Id 4280',4416.00,0.00,0.00,6.00,510.00,'2023-01-29 13:37:58','',''),(4464,'1','302','1',1,'Retail Sale Id 4281',3680.00,0.00,0.00,5.00,425.00,'2023-01-29 13:39:19','',''),(4465,'1','302','1',1,'Retail Sale Id 4282',2208.00,0.00,0.00,3.00,255.00,'2023-01-29 13:46:37','',''),(4466,'1','302','1',1,'Retail Sale Id 4283',35500.00,0.00,0.00,50.00,2950.00,'2023-01-29 13:51:58','',''),(4467,'1','302','1',1,'Retail Sale Id 4284',9200.00,0.00,0.00,12.50,1062.50,'2023-01-29 13:54:20','',''),(4468,'1','302','1',1,'Retail Sale Id 4285',3680.00,0.00,0.00,5.00,425.00,'2023-01-29 14:14:22','',''),(4469,'1','302','1',1,'Retail Sale Id 4285',9200.00,0.00,0.00,12.50,1062.50,'2023-01-29 14:14:22','',''),(4470,'1','302','1',1,'Retail Sale Id 4286',9200.00,0.00,0.00,12.50,1062.50,'2023-01-29 14:24:35','',''),(4471,'1','302','1',1,'Retail Sale Id 4287',4416.00,0.00,0.00,6.00,510.00,'2023-01-29 14:29:17','',''),(4472,'1','302','1',1,'Retail Sale Id 4288',736.00,0.00,0.00,1.00,85.00,'2023-01-29 14:32:02','',''),(4473,'1','302','1',1,'Retail Sale Id 4289',4423.36,0.00,0.00,6.01,510.85,'2023-01-29 14:39:29','',''),(4474,'1','302','1',1,'Retail Sale Id 4291',2001.92,0.00,0.00,2.72,231.20,'2023-01-29 14:41:45','',''),(4475,'1','302','1',1,'Retail Sale Id 4292',9200.00,0.00,0.00,12.50,1062.50,'2023-01-29 14:45:08','',''),(4476,'1','302','1',1,'Retail Sale Id 4293',6999.36,0.00,0.00,9.51,808.35,'2023-01-29 14:49:11','',''),(4477,'1','302','1',1,'Retail Sale Id 4294',1898.88,0.00,0.00,2.58,219.30,'2023-01-29 14:50:19','',''),(4478,'1','302','1',1,'Retail Sale Id 4295',1501.44,0.00,0.00,2.04,173.40,'2023-01-29 14:54:31','',''),(4479,'1','302','1',1,'Retail Sale Id 4296',2944.00,0.00,0.00,4.00,340.00,'2023-01-29 15:05:55','',''),(4480,'1','302','1',1,'Retail Sale Id 4297',1398.40,0.00,0.00,1.90,161.50,'2023-01-29 15:06:51','',''),(4481,'1','302','1',1,'Retail Sale Id 4298',9200.00,0.00,0.00,12.50,1062.50,'2023-01-29 15:08:09','',''),(4482,'1','302','1',1,'Retail Sale Id 4299',1501.44,0.00,0.00,2.04,173.40,'2023-01-29 15:09:19','',''),(4483,'1','302','1',1,'Retail Sale Id 4300',4496.96,0.00,0.00,6.11,519.35,'2023-01-29 15:27:23','',''),(4484,'1','302','1',1,'Retail Sale Id 4301',2208.00,0.00,0.00,3.00,255.00,'2023-01-29 15:30:12','',''),(4485,'1','302','1',1,'Retail Sale Id 4302',9200.00,0.00,0.00,12.50,1062.50,'2023-01-29 15:37:11','',''),(4486,'1','302','1',1,'Retail Sale Id 4303',2200.64,0.00,0.00,2.99,254.15,'2023-01-29 15:40:37','',''),(4487,'1','302','1',1,'Retail Sale Id 4304',2200.64,0.00,0.00,2.99,254.15,'2023-01-29 15:48:19','',''),(4488,'1','302','1',1,'Retail Sale Id 4306',1000.96,0.00,0.00,1.36,115.60,'2023-01-29 15:51:56','',''),(4489,'1','302','1',1,'Retail Sale Id 4307',9200.00,0.00,0.00,12.50,1062.50,'2023-01-29 16:00:40','',''),(4490,'1','302','1',1,'Retail Sale Id 4308',1501.44,0.00,0.00,2.04,173.40,'2023-01-29 16:30:58','',''),(4491,'1','302','1',1,'Retail Sale Id 4309',802.24,0.00,0.00,1.09,92.65,'2023-01-29 16:31:51','',''),(4492,'1','302','1',1,'Retail Sale Id 4310',3002.88,0.00,0.00,4.08,346.80,'2023-01-29 16:36:29','',''),(4493,'1','302','1',1,'Retail Sale Id 4311',2502.40,0.00,0.00,3.40,289.00,'2023-01-29 16:37:27','',''),(4494,'1','302','1',1,'Retail Sale Id 4312',9200.00,0.00,0.00,12.50,1062.50,'2023-01-29 16:39:28','',''),(4495,'1','302','1',1,'Retail Sale Id 4313',2208.00,0.00,0.00,3.00,255.00,'2023-01-29 16:40:34','',''),(4496,'1','302','1',1,'Retail Sale Id 4314',2208.00,0.00,0.00,3.00,255.00,'2023-01-29 16:41:55','',''),(4497,'1','302','1',1,'Retail Sale Id 4315',2001.92,0.00,0.00,2.72,231.20,'2023-01-29 16:45:44','',''),(4498,'1','302','1',1,'Retail Sale Id 4315',4997.44,0.00,0.00,6.79,577.15,'2023-01-29 16:45:44','',''),(4499,'1','302','1',1,'Retail Sale Id 4316',4423.36,0.00,0.00,6.01,510.85,'2023-01-29 16:48:06','',''),(4500,'1','302','1',1,'Retail Sale Id 4316',4423.36,0.00,0.00,6.01,510.85,'2023-01-29 16:48:06','',''),(4501,'1','302','1',1,'Retail Sale Id 4317',2208.00,0.00,0.00,3.00,255.00,'2023-01-29 16:54:41','',''),(4502,'1','302','1',1,'Retail Sale Id 4318',2001.92,0.00,0.00,2.72,231.20,'2023-01-29 16:59:00','',''),(4503,'1','302','1',1,'Retail Sale Id 4319',2001.92,0.00,0.00,2.72,231.20,'2023-01-29 17:01:34','',''),(4504,'1','302','1',1,'Retail Sale Id 4320',17750.00,0.00,0.00,25.00,1475.00,'2023-01-29 17:02:36','',''),(4505,'1','302','1',1,'Retail Sale Id 4321',2208.00,0.00,0.00,3.00,255.00,'2023-01-29 17:11:56','',''),(4506,'1','302','1',1,'Retail Sale Id 4323',3294.40,0.00,0.00,4.64,273.76,'2023-01-29 17:26:17','',''),(4507,'1','302','1',1,'Retail Sale Id 4324',4416.00,0.00,0.00,6.00,510.00,'2023-01-29 17:28:42','',''),(4508,'1','302','1',1,'Retail Sale Id 4325',1803.20,0.00,0.00,2.45,208.25,'2023-01-29 17:30:42','',''),(4509,'1','302','1',1,'Retail Sale Id 4326',4416.00,0.00,0.00,6.00,510.00,'2023-01-29 17:32:22','',''),(4510,'1','302','1',1,'Retail Sale Id 4327',2001.92,0.00,0.00,2.72,231.20,'2023-01-29 17:36:30','',''),(4511,'1','302','1',1,'Retail Sale Id 4328',4423.36,0.00,0.00,6.01,510.85,'2023-01-29 17:43:39','',''),(4512,'1','302','1',1,'Retail Sale Id 4329',9200.00,0.00,0.00,12.50,1062.50,'2023-01-29 17:46:00','',''),(4513,'1','302','1',1,'Retail Sale Id 4330',35500.00,0.00,0.00,50.00,2950.00,'2023-01-29 18:01:03','',''),(4514,'1','302','1',1,'Retail Sale Id 4331',4416.00,0.00,0.00,6.00,510.00,'2023-01-29 18:02:38','',''),(4515,'1','302','1',1,'Retail Sale Id 4332',2130.00,0.00,0.00,3.00,177.00,'2023-01-29 18:10:41','',''),(4516,'1','302','1',1,'Retail Sale Id 4333',2208.00,0.00,0.00,3.00,255.00,'2023-01-29 18:11:43','',''),(4517,'1','302','1',1,'Retail Sale Id 4334',4416.00,0.00,0.00,6.00,510.00,'2023-01-29 18:12:56','',''),(4518,'1','302','1',1,'Retail Sale Id 4335',80.96,0.00,0.00,0.11,9.35,'2023-01-29 20:18:44','',''),(4519,'1','302','1',1,'Retail Sale Id 4336',1803.20,0.00,0.00,2.45,208.25,'2023-01-30 07:49:06','',''),(4520,'1','302','1',1,'Retail Sale Id 4337',4416.00,0.00,0.00,6.00,510.00,'2023-01-30 07:52:35','',''),(4521,'1','302','1',1,'Retail Sale Id 4338',9200.00,0.00,0.00,12.50,1062.50,'2023-01-30 08:15:08','',''),(4522,'1','302','1',1,'Retail Sale Id 4339',9200.00,0.00,0.00,12.50,1062.50,'2023-01-30 08:16:27','',''),(4523,'1','302','1',1,'Retail Sale Id 4340',4496.96,0.00,0.00,6.11,519.35,'2023-01-30 08:17:24','',''),(4524,'1','302','1',1,'Retail Sale Id 4341',2208.00,0.00,0.00,3.00,255.00,'2023-01-30 08:37:23','',''),(4525,'1','302','1',1,'Retail Sale Id 4342',9200.00,0.00,0.00,12.50,1062.50,'2023-01-30 08:39:22','',''),(4526,'1','302','1',1,'Retail Sale Id 4343',4416.00,0.00,0.00,6.00,510.00,'2023-01-30 08:40:35','',''),(4527,'1','302','1',1,'Retail Sale Id 4344',4416.00,0.00,0.00,6.00,510.00,'2023-01-30 08:42:14','',''),(4528,'1','302','1',1,'Retail Sale Id 4345',4496.96,0.00,0.00,6.11,519.35,'2023-01-30 08:53:37','',''),(4529,'1','302','1',1,'Retail Sale Id 4347',2001.92,0.00,0.00,2.72,231.20,'2023-01-30 09:00:40','',''),(4530,'1','302','1',1,'Retail Sale Id 4348',191.36,0.00,0.00,0.26,22.10,'2023-01-30 09:01:54','',''),(4531,'1','302','1',1,'Retail Sale Id 4350',802.24,0.00,0.00,1.09,92.65,'2023-01-30 09:08:52','',''),(4532,'1','302','1',1,'Retail Sale Id 4351',4496.96,0.00,0.00,6.11,519.35,'2023-01-30 09:11:29','',''),(4533,'1','302','1',1,'Retail Sale Id 4352',4416.00,0.00,0.00,6.00,510.00,'2023-01-30 09:19:56','',''),(4534,'1','302','1',1,'Retail Sale Id 4352',9200.00,0.00,0.00,12.50,1062.50,'2023-01-30 09:19:56','',''),(4535,'1','302','1',1,'Retail Sale Id 4353',9200.00,0.00,0.00,12.50,1062.50,'2023-01-30 09:21:28','',''),(4536,'1','302','1',1,'Retail Sale Id 4354',2001.92,0.00,0.00,2.72,231.20,'2023-01-30 09:22:58','',''),(4537,'1','302','1',1,'Retail Sale Id 4355',3503.36,0.00,0.00,4.76,404.60,'2023-01-30 09:31:12','',''),(4538,'1','302','1',1,'Retail Sale Id 4356',1501.44,0.00,0.00,2.04,173.40,'2023-01-30 09:31:39','',''),(4539,'1','302','1',1,'Retail Sale Id 4357',4416.00,0.00,0.00,6.00,510.00,'2023-01-30 09:33:22','',''),(4540,'1','302','1',1,'Retail Sale Id 4358',1457.28,0.00,0.00,1.98,168.30,'2023-01-30 09:39:33','',''),(4541,'1','302','1',1,'Retail Sale Id 4359',3680.00,0.00,0.00,5.00,425.00,'2023-01-30 09:49:01','',''),(4542,'1','302','1',1,'Retail Sale Id 4359',3680.00,0.00,0.00,5.00,425.00,'2023-01-30 09:49:01','',''),(4543,'1','302','1',1,'Retail Sale Id 4360',2303.68,0.00,0.00,3.13,266.05,'2023-01-30 09:53:48','',''),(4544,'1','302','1',1,'Retail Sale Id 4361',500.48,0.00,0.00,0.68,57.80,'2023-01-30 09:55:04','',''),(4545,'1','302','1',1,'Retail Sale Id 4362',1501.44,0.00,0.00,2.04,173.40,'2023-01-30 09:57:22','',''),(4546,'1','302','1',1,'Retail Sale Id 4363',9200.00,0.00,0.00,12.50,1062.50,'2023-01-30 09:59:27','',''),(4547,'1','302','1',1,'Retail Sale Id 4364',802.24,0.00,0.00,1.09,92.65,'2023-01-30 10:03:44','',''),(4548,'1','302','1',1,'Retail Sale Id 4364',2001.92,0.00,0.00,2.72,231.20,'2023-01-30 10:03:44','',''),(4549,'1','302','1',1,'Retail Sale Id 4365',9200.00,0.00,0.00,12.50,1062.50,'2023-01-30 10:05:05','',''),(4550,'1','302','1',1,'Retail Sale Id 4366',14981.00,0.00,0.00,21.10,1244.90,'2023-01-30 10:09:33','',''),(4551,'1','302','1',1,'Retail Sale Id 4367',4416.00,0.00,0.00,6.00,510.00,'2023-01-30 10:10:57','',''),(4552,'1','302','1',1,'Retail Sale Id 4369',3680.00,0.00,0.00,5.00,425.00,'2023-01-30 10:12:18','',''),(4553,'1','302','1',1,'Retail Sale Id 4370',1000.96,0.00,0.00,1.36,115.60,'2023-01-30 10:12:59','',''),(4554,'1','302','1',1,'Retail Sale Id 4371',2208.00,0.00,0.00,3.00,255.00,'2023-01-30 10:15:18','',''),(4555,'1','302','1',1,'Retail Sale Id 4372',1501.44,0.00,0.00,2.04,173.40,'2023-01-30 10:17:20','',''),(4556,'1','302','1',1,'Retail Sale Id 4373',5203.52,0.00,0.00,7.07,600.95,'2023-01-30 10:18:59','',''),(4557,'1','302','1',1,'Retail Sale Id 4374',1501.44,0.00,0.00,2.04,173.40,'2023-01-30 10:25:50','',''),(4558,'1','302','1',1,'Retail Sale Id 4375',7360.00,0.00,0.00,10.00,850.00,'2023-01-30 10:30:40','',''),(4559,'1','302','1',1,'Retail Sale Id 4376',9200.00,0.00,0.00,12.50,1062.50,'2023-01-30 10:36:13','',''),(4560,'1','302','1',1,'Retail Sale Id 4377',3996.48,0.00,0.00,5.43,461.55,'2023-01-30 10:42:44','',''),(4561,'1','302','1',1,'Retail Sale Id 4378',2252.16,0.00,0.00,3.06,260.10,'2023-01-30 10:44:05','',''),(4562,'1','302','1',1,'Retail Sale Id 4379',7360.00,0.00,0.00,10.00,850.00,'2023-01-30 10:50:24','',''),(4563,'1','302','1',1,'Retail Sale Id 4380',4496.96,0.00,0.00,6.11,519.35,'2023-01-30 10:54:02','',''),(4564,'1','302','1',1,'Retail Sale Id 4381',2208.00,0.00,0.00,3.00,255.00,'2023-01-30 10:57:06','',''),(4565,'1','302','1',1,'Retail Sale Id 4382',3680.00,0.00,0.00,5.00,425.00,'2023-01-30 11:17:11','',''),(4566,'1','302','1',1,'Retail Sale Id 4383',4496.96,0.00,0.00,6.11,519.35,'2023-01-30 11:21:30','',''),(4567,'1','302','1',1,'Retail Sale Id 4384',4423.36,0.00,0.00,6.01,510.85,'2023-01-30 11:23:30','',''),(4568,'1','302','1',1,'Retail Sale Id 4385',10650.00,0.00,0.00,15.00,885.00,'2023-01-30 11:29:03','',''),(4569,'1','302','1',1,'Retail Sale Id 4386',4997.44,0.00,0.00,6.79,577.15,'2023-01-30 11:31:03','',''),(4570,'1','302','1',1,'Retail Sale Id 4387',2208.00,0.00,0.00,3.00,255.00,'2023-01-30 11:47:42','',''),(4571,'1','302','1',1,'Retail Sale Id 4388',3680.00,0.00,0.00,5.00,425.00,'2023-01-30 11:50:28','',''),(4572,'1','302','1',1,'Retail Sale Id 4389',9200.00,0.00,0.00,12.50,1062.50,'2023-01-30 12:14:46','',''),(4573,'1','302','1',1,'Retail Sale Id 4390',44375.00,0.00,0.00,62.50,3687.50,'2023-01-30 12:24:49','',''),(4574,'1','302','1',1,'Retail Sale Id 4391',1000.96,0.00,0.00,1.36,115.60,'2023-01-30 12:37:35','',''),(4575,'1','302','1',1,'Retail Sale Id 4393',2001.92,0.00,0.00,2.72,231.20,'2023-01-30 13:02:02','',''),(4576,'1','302','1',1,'Retail Sale Id 4394',802.24,0.00,0.00,1.09,92.65,'2023-01-30 13:18:57','',''),(4577,'1','302','1',1,'Retail Sale Id 4395',7810.00,0.00,0.00,11.00,649.00,'2023-01-30 13:29:50','',''),(4578,'1','302','1',1,'Retail Sale Id 4396',1199.68,0.00,0.00,1.63,138.55,'2023-01-30 13:34:53','',''),(4579,'1','302','1',1,'Retail Sale Id 4397',4416.00,0.00,0.00,6.00,510.00,'2023-01-30 13:37:23','',''),(4580,'1','302','1',1,'Retail Sale Id 4398',9200.00,0.00,0.00,12.50,1062.50,'2023-01-30 13:50:59','',''),(4581,'1','302','1',1,'Retail Sale Id 4399',2208.00,0.00,0.00,3.00,255.00,'2023-01-30 13:57:12','',''),(4582,'1','302','1',1,'Retail Sale Id 4400',3996.48,0.00,0.00,5.43,461.55,'2023-01-30 14:11:20','',''),(4583,'1','302','1',1,'Retail Sale Id 4401',9200.00,0.00,0.00,12.50,1062.50,'2023-01-30 14:15:34','',''),(4584,'1','302','1',1,'Retail Sale Id 4402',8520.00,0.00,0.00,12.00,708.00,'2023-01-30 14:16:42','',''),(4585,'1','302','1',1,'Retail Sale Id 4403',2001.92,0.00,0.00,2.72,231.20,'2023-01-30 14:17:22','',''),(4586,'1','302','1',1,'Retail Sale Id 4404',802.24,0.00,0.00,1.09,92.65,'2023-01-30 14:32:48','',''),(4587,'1','302','1',1,'Retail Sale Id 4405',2001.92,0.00,0.00,2.72,231.20,'2023-01-30 14:52:58','',''),(4588,'1','302','1',1,'Retail Sale Id 4406',2303.68,0.00,0.00,3.13,266.05,'2023-01-30 15:07:54','',''),(4589,'1','302','1',1,'Retail Sale Id 4407',3599.04,0.00,0.00,4.89,415.65,'2023-01-30 15:08:46','',''),(4590,'1','302','1',1,'Retail Sale Id 4410',9200.00,0.00,0.00,12.50,1062.50,'2023-01-30 15:23:24','',''),(4591,'1','302','1',1,'Retail Sale Id 4411',1501.44,0.00,0.00,2.04,173.40,'2023-01-30 15:24:35','',''),(4592,'1','302','1',1,'Retail Sale Id 4412',4416.00,0.00,0.00,6.00,510.00,'2023-01-30 15:29:47','',''),(4593,'1','302','1',1,'Retail Sale Id 4413',1501.44,0.00,0.00,2.04,173.40,'2023-01-30 15:31:09','',''),(4594,'1','302','1',1,'Retail Sale Id 4414',26270.00,0.00,0.00,37.00,2183.00,'2023-01-30 15:35:35','',''),(4595,'1','302','1',1,'Retail Sale Id 4416',2001.92,0.00,0.00,2.72,231.20,'2023-01-30 16:17:15','',''),(4596,'1','302','1',1,'Retail Sale Id 4417',2001.92,0.00,0.00,2.72,231.20,'2023-01-30 16:18:51','',''),(4597,'1','302','1',1,'Retail Sale Id 4418',2001.92,0.00,0.00,2.72,231.20,'2023-01-30 16:19:39','',''),(4598,'1','302','1',1,'Retail Sale Id 4419',2252.16,0.00,0.00,3.06,260.10,'2023-01-30 16:26:34','',''),(4599,'1','302','1',1,'Retail Sale Id 4420',6999.36,0.00,0.00,9.51,808.35,'2023-01-30 16:27:29','',''),(4600,'1','302','1',1,'Retail Sale Id 4421',2001.92,0.00,0.00,2.72,231.20,'2023-01-30 16:30:51','',''),(4601,'1','302','1',1,'Retail Sale Id 4422',9200.00,0.00,0.00,12.50,1062.50,'2023-01-30 16:33:25','',''),(4602,'1','302','1',1,'Retail Sale Id 4423',4997.44,0.00,0.00,6.79,577.15,'2023-01-30 16:42:16','',''),(4603,'1','302','1',1,'Retail Sale Id 4424',2208.00,0.00,0.00,3.00,255.00,'2023-01-30 16:43:22','',''),(4604,'1','302','1',1,'Retail Sale Id 4425',1000.96,0.00,0.00,1.36,115.60,'2023-01-30 17:06:17','',''),(4605,'1','302','1',1,'Retail Sale Id 4426',4401.28,0.00,0.00,5.98,508.30,'2023-01-30 17:10:30','',''),(4606,'1','302','1',1,'Retail Sale Id 4427',5152.00,0.00,0.00,7.00,595.00,'2023-01-30 17:12:51','',''),(4607,'1','302','1',1,'Retail Sale Id 4428',942.08,0.00,0.00,1.28,108.80,'2023-01-30 17:14:57','',''),(4608,'1','302','1',1,'Retail Sale Id 4429',4416.00,0.00,0.00,6.00,510.00,'2023-01-30 17:26:33','',''),(4609,'1','302','1',1,'Retail Sale Id 4430',9200.00,0.00,0.00,12.50,1062.50,'2023-01-30 17:31:24','',''),(4610,'1','302','1',1,'Retail Sale Id 4433',5998.40,0.00,0.00,8.15,692.75,'2023-01-30 17:33:14','',''),(4611,'1','302','1',1,'Retail Sale Id 4434',4997.44,0.00,0.00,6.79,577.15,'2023-01-30 17:33:51','',''),(4612,'1','302','1',1,'Retail Sale Id 4435',2001.92,0.00,0.00,2.72,231.20,'2023-01-30 17:34:37','',''),(4613,'1','302','1',1,'Retail Sale Id 4437',6999.36,0.00,0.00,9.51,808.35,'2023-01-30 17:41:44','',''),(4614,'1','302','1',1,'Retail Sale Id 4440',3002.88,0.00,0.00,4.08,346.80,'2023-01-30 17:54:29','',''),(4615,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,64253.70,98.70,0.00,0.00,'2023-01-31 00:41:30','',''),(4616,'1','302',NULL,1,'Reception corrector for bridging 31',0.00,0.00,0.00,98.70,0.00,'2023-01-31 00:46:32','',''),(4617,'1','302','1',1,'Received from bridging 31',0.00,0.00,98.70,0.00,0.00,'2023-01-31 00:46:32','',''),(4618,'1','302','1',1,'Retail Sale Id 4445',36233.28,0.00,0.00,49.23,4184.55,'2023-01-31 06:25:38','',''),(4619,'1','302','1',1,'Retail Sale Id 4450',35421.90,0.00,0.00,49.89,2943.51,'2023-01-31 08:30:00','',''),(4620,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3515400.00,5400.00,0.00,0.00,'2023-01-31 12:24:13','',''),(4621,'1','302',NULL,1,'Reception corrector for bridging 32',0.00,0.00,0.00,5400.00,0.00,'2023-01-31 12:29:40','',''),(4622,'1','302','1',1,'Received from bridging 32',0.00,0.00,5400.00,0.00,0.00,'2023-01-31 12:29:40','',''),(4623,'1','302','1',1,'Retail Sale Id 4453',37565.44,0.00,0.00,51.04,4338.40,'2023-01-31 12:59:06','',''),(4624,'1','302','1',1,'Retail Sale Id 4454',17750.00,0.00,0.00,25.00,1475.00,'2023-01-31 13:02:34','',''),(4625,'1','302','1',1,'Retail Sale Id 4455',1000.96,0.00,0.00,1.36,115.60,'2023-01-31 13:07:13','',''),(4626,'1','302','1',1,'Retail Sale Id 4456',4416.00,0.00,0.00,6.00,510.00,'2023-01-31 13:12:44','',''),(4627,'1','302','1',1,'Retail Sale Id 4457',3680.00,0.00,0.00,5.00,425.00,'2023-01-31 13:41:55','',''),(4628,'1','302','1',1,'Retail Sale Id 4458',9200.00,0.00,0.00,12.50,1062.50,'2023-01-31 13:43:10','',''),(4629,'1','302','1',1,'Retail Sale Id 4459',2502.40,0.00,0.00,3.40,289.00,'2023-01-31 13:44:41','',''),(4630,'1','302','1',1,'Retail Sale Id 4460',4496.96,0.00,0.00,6.11,519.35,'2023-01-31 13:46:50','',''),(4631,'1','302','1',1,'Retail Sale Id 4461',1000.96,0.00,0.00,1.36,115.60,'2023-01-31 13:47:46','',''),(4632,'1','302','1',1,'Retail Sale Id 4462',2001.92,0.00,0.00,2.72,231.20,'2023-01-31 13:54:22','',''),(4633,'1','302','1',1,'Retail Sale Id 4463',35500.00,0.00,0.00,50.00,2950.00,'2023-01-31 14:05:28','',''),(4634,'1','302','1',1,'Retail Sale Id 4464',2001.92,0.00,0.00,2.72,231.20,'2023-01-31 14:14:09','',''),(4635,'1','302','1',1,'Retail Sale Id 4465',2208.00,0.00,0.00,3.00,255.00,'2023-01-31 14:15:25','',''),(4636,'1','302','1',1,'Retail Sale Id 4466',9200.00,0.00,0.00,12.50,1062.50,'2023-01-31 14:20:57','',''),(4637,'1','302','1',1,'Retail Sale Id 4467',2208.00,0.00,0.00,3.00,255.00,'2023-01-31 14:22:55','',''),(4638,'1','302','1',1,'Retail Sale Id 4468',2208.00,0.00,0.00,3.00,255.00,'2023-01-31 14:29:11','',''),(4639,'1','302','1',1,'Retail Sale Id 4469',7360.00,0.00,0.00,10.00,850.00,'2023-01-31 14:35:41','',''),(4640,'1','302','1',1,'Retail Sale Id 4470',4401.28,0.00,0.00,5.98,508.30,'2023-01-31 14:38:21','',''),(4641,'1','302','1',1,'Retail Sale Id 4471',3002.88,0.00,0.00,4.08,346.80,'2023-01-31 14:42:36','',''),(4642,'1','302','1',1,'Retail Sale Id 4472',3002.88,0.00,0.00,4.08,346.80,'2023-01-31 14:44:41','',''),(4643,'1','302','1',1,'Retail Sale Id 4473',3996.48,0.00,0.00,5.43,461.55,'2023-01-31 14:48:04','',''),(4644,'1','302','1',1,'Retail Sale Id 4474',6498.88,0.00,0.00,8.83,750.55,'2023-01-31 15:09:17','',''),(4645,'1','302','1',1,'Retail Sale Id 4475',3680.00,0.00,0.00,5.00,425.00,'2023-01-31 15:17:13','',''),(4646,'1','302','1',1,'Retail Sale Id 4475',18400.00,0.00,0.00,25.00,2125.00,'2023-01-31 15:17:13','',''),(4647,'1','302','1',1,'Retail Sale Id 4476',3002.88,0.00,0.00,4.08,346.80,'2023-01-31 15:21:42','',''),(4648,'1','302','1',1,'Retail Sale Id 4477',3002.88,0.00,0.00,4.08,346.80,'2023-01-31 15:33:53','',''),(4649,'1','302','1',1,'Retail Sale Id 4478',2208.00,0.00,0.00,3.00,255.00,'2023-01-31 16:13:13','',''),(4650,'1','302','1',1,'Retail Sale Id 4479',1000.96,0.00,0.00,1.36,115.60,'2023-01-31 16:15:17','',''),(4651,'1','302','1',1,'Retail Sale Id 4480',4416.00,0.00,0.00,6.00,510.00,'2023-01-31 16:16:37','',''),(4652,'1','302','1',1,'Retail Sale Id 4481',9200.00,0.00,0.00,12.50,1062.50,'2023-01-31 16:26:56','',''),(4653,'1','302','1',1,'Retail Sale Id 4482',4416.00,0.00,0.00,6.00,510.00,'2023-01-31 16:31:57','',''),(4654,'1','302','1',1,'Retail Sale Id 4483',17750.00,0.00,0.00,25.00,1475.00,'2023-01-31 16:39:37','',''),(4655,'1','302','1',1,'Retail Sale Id 4484',4416.00,0.00,0.00,6.00,510.00,'2023-01-31 16:41:39','',''),(4656,'1','302','1',1,'Retail Sale Id 4485',4416.00,0.00,0.00,6.00,510.00,'2023-01-31 16:45:02','',''),(4657,'1','302','1',1,'Retail Sale Id 4486',294.40,0.00,0.00,0.40,34.00,'2023-01-31 16:49:49','',''),(4658,'1','302','1',1,'Retail Sale Id 4487',1000.96,0.00,0.00,1.36,115.60,'2023-01-31 16:50:55','',''),(4659,'1','302','1',1,'Retail Sale Id 4488',2399.36,0.00,0.00,3.26,277.10,'2023-01-31 16:53:50','',''),(4660,'1','302','1',1,'Retail Sale Id 4489',9200.00,0.00,0.00,12.50,1062.50,'2023-01-31 16:54:28','',''),(4661,'1','302','1',1,'Retail Sale Id 4490',4416.00,0.00,0.00,6.00,510.00,'2023-01-31 16:55:28','',''),(4662,'1','302','1',1,'Retail Sale Id 4491',3503.36,0.00,0.00,4.76,404.60,'2023-01-31 16:57:17','',''),(4663,'1','302','1',1,'Retail Sale Id 4492',3996.48,0.00,0.00,5.43,461.55,'2023-01-31 16:59:18','',''),(4664,'1','302','1',1,'Retail Sale Id 4493',3503.36,0.00,0.00,4.76,404.60,'2023-01-31 17:10:10','',''),(4665,'1','302','1',1,'Retail Sale Id 4494',2208.00,0.00,0.00,3.00,255.00,'2023-01-31 17:11:26','',''),(4666,'1','302','1',1,'Retail Sale Id 4495',2252.16,0.00,0.00,3.06,260.10,'2023-01-31 17:19:35','',''),(4667,'1','302','1',1,'Retail Sale Id 4496',500.48,0.00,0.00,0.68,57.80,'2023-01-31 17:23:35','',''),(4668,'1','302','1',1,'Retail Sale Id 4497',2208.00,0.00,0.00,3.00,255.00,'2023-01-31 17:28:29','',''),(4669,'1','302','1',1,'Retail Sale Id 4498',2001.92,0.00,0.00,2.72,231.20,'2023-01-31 17:30:43','',''),(4670,'1','302','1',1,'Retail Sale Id 4499',2208.00,0.00,0.00,3.00,255.00,'2023-01-31 17:34:49','',''),(4671,'1','302','1',1,'Retail Sale Id 4501',5888.00,0.00,0.00,8.00,680.00,'2023-01-31 17:47:43','',''),(4672,'1','302','1',1,'Retail Sale Id 4502',1000.96,0.00,0.00,1.36,115.60,'2023-01-31 17:50:23','',''),(4673,'1','302','1',1,'Retail Sale Id 4503',5152.00,0.00,0.00,7.00,595.00,'2023-01-31 17:56:58','',''),(4674,'1','302','1',1,'Retail Sale Id 4504',1501.44,0.00,0.00,2.04,173.40,'2023-01-31 18:00:07','',''),(4675,'1','302','1',1,'Retail Sale Id 4505',1398.40,0.00,0.00,1.90,161.50,'2023-01-31 18:02:42','',''),(4676,'1','302','1',1,'Retail Sale Id 4506',500.48,0.00,0.00,0.68,57.80,'2023-01-31 18:05:51','',''),(4677,'1','302','1',1,'Retail Sale Id 4507',2001.92,0.00,0.00,2.72,231.20,'2023-01-31 18:08:57','',''),(4678,'1','302','1',1,'Retail Sale Id 4508',1501.44,0.00,0.00,2.04,173.40,'2023-01-31 18:16:41','',''),(4679,'1','302','1',1,'Retail Sale Id 4509',9200.00,0.00,0.00,12.50,1062.50,'2023-01-31 18:20:48','',''),(4680,'1','302','1',1,'Retail Sale Id 4510',1000.96,0.00,0.00,1.36,115.60,'2023-01-31 18:22:17','',''),(4681,'1','302','1',1,'Retail Sale Id 4511',736.00,0.00,0.00,1.00,85.00,'2023-01-31 18:27:36','',''),(4682,'1','302','1',1,'Retail Sale Id 4512',7.36,0.00,0.00,0.01,0.85,'2023-01-31 19:25:57','',''),(4683,'1','302','1',1,'Retail Sale Id 4513',2200.64,0.00,0.00,2.99,254.15,'2023-02-01 07:52:41','',''),(4684,'1','302','1',1,'Retail Sale Id 4514',3002.88,0.00,0.00,4.08,346.80,'2023-02-01 07:58:38','',''),(4685,'1','302','1',1,'Retail Sale Id 4515',7360.00,0.00,0.00,10.00,850.00,'2023-02-01 07:59:35','',''),(4686,'1','302','1',1,'Retail Sale Id 4516',9200.00,0.00,0.00,12.50,1062.50,'2023-02-01 08:03:52','',''),(4687,'1','302','1',1,'Retail Sale Id 4517',1597.12,0.00,0.00,2.17,184.45,'2023-02-01 08:09:31','',''),(4688,'1','302','1',1,'Retail Sale Id 4518',3996.48,0.00,0.00,5.43,461.55,'2023-02-01 08:15:29','',''),(4689,'1','302','1',1,'Retail Sale Id 4519',3680.00,0.00,0.00,5.00,425.00,'2023-02-01 08:19:17','',''),(4690,'1','302','1',1,'Retail Sale Id 4519',4416.00,0.00,0.00,6.00,510.00,'2023-02-01 08:19:17','',''),(4691,'1','302','1',1,'Retail Sale Id 4520',4496.96,0.00,0.00,6.11,519.35,'2023-02-01 08:22:19','',''),(4692,'1','302','1',1,'Retail Sale Id 4521',4416.00,0.00,0.00,6.00,510.00,'2023-02-01 08:23:09','',''),(4693,'1','302','1',1,'Retail Sale Id 4522',1501.44,0.00,0.00,2.04,173.40,'2023-02-01 08:31:22','',''),(4694,'1','302','1',1,'Retail Sale Id 4523',3680.00,0.00,0.00,5.00,425.00,'2023-02-01 08:39:39','',''),(4695,'1','302','1',1,'Retail Sale Id 4524',2944.00,0.00,0.00,4.00,340.00,'2023-02-01 08:41:31','',''),(4696,'1','302','1',1,'Retail Sale Id 4525',9200.00,0.00,0.00,12.50,1062.50,'2023-02-01 08:48:13','',''),(4697,'1','302','1',1,'Retail Sale Id 4526',4401.28,0.00,0.00,5.98,508.30,'2023-02-01 08:50:04','',''),(4698,'1','302','1',1,'Retail Sale Id 4527',3680.00,0.00,0.00,5.00,425.00,'2023-02-01 08:52:00','',''),(4699,'1','302','1',1,'Retail Sale Id 4528',9200.00,0.00,0.00,12.50,1062.50,'2023-02-01 08:54:09','',''),(4700,'1','302','1',1,'Retail Sale Id 4529',3702.08,0.00,0.00,5.03,427.55,'2023-02-01 09:00:30','',''),(4701,'1','302','1',1,'Retail Sale Id 4530',5152.00,0.00,0.00,7.00,595.00,'2023-02-01 09:02:24','',''),(4702,'1','302','1',1,'Retail Sale Id 4531',1501.44,0.00,0.00,2.04,173.40,'2023-02-01 09:12:45','',''),(4703,'1','302','1',1,'Retail Sale Id 4532',1501.44,0.00,0.00,2.04,173.40,'2023-02-01 09:13:47','',''),(4704,'1','302','1',1,'Retail Sale Id 4533',1501.44,0.00,0.00,2.04,173.40,'2023-02-01 09:19:57','',''),(4705,'1','302','1',1,'Retail Sale Id 4534',4496.96,0.00,0.00,6.11,519.35,'2023-02-01 09:24:17','',''),(4706,'1','302','1',1,'Retail Sale Id 4535',4416.00,0.00,0.00,6.00,510.00,'2023-02-01 09:25:58','',''),(4707,'1','302','1',1,'Retail Sale Id 4536',3002.88,0.00,0.00,4.08,346.80,'2023-02-01 09:27:25','',''),(4708,'1','302','1',1,'Retail Sale Id 4537',1000.96,0.00,0.00,1.36,115.60,'2023-02-01 09:46:15','',''),(4709,'1','302','1',1,'Retail Sale Id 4538',9200.00,0.00,0.00,12.50,1062.50,'2023-02-01 09:49:16','',''),(4710,'1','302','1',1,'Retail Sale Id 4539',7360.00,0.00,0.00,10.00,850.00,'2023-02-01 09:55:11','',''),(4711,'1','302','1',1,'Retail Sale Id 4542',9200.00,0.00,0.00,12.50,1062.50,'2023-02-01 10:08:23','',''),(4712,'1','302','1',1,'Retail Sale Id 4545',3002.88,0.00,0.00,4.08,346.80,'2023-02-01 10:22:59','',''),(4713,'1','302','1',1,'Retail Sale Id 4546',9200.00,0.00,0.00,12.50,1062.50,'2023-02-01 11:25:48','',''),(4714,'1','302','1',1,'Retail Sale Id 4547',31728.96,0.00,0.00,43.11,3664.35,'2023-02-01 11:33:43','',''),(4715,'1','302','1',1,'Retail Sale Id 4548',9200.00,0.00,0.00,12.50,1062.50,'2023-02-01 11:53:49','',''),(4716,'1','302','1',1,'Retail Sale Id 4549',4416.00,0.00,0.00,6.00,510.00,'2023-02-01 11:59:02','',''),(4717,'1','302','1',1,'Retail Sale Id 4550',1000.96,0.00,0.00,1.36,115.60,'2023-02-01 12:00:02','',''),(4718,'1','302','1',1,'Retail Sale Id 4550',2001.92,0.00,0.00,2.72,231.20,'2023-02-01 12:00:02','',''),(4719,'1','302','1',1,'Retail Sale Id 4551',9585.00,0.00,0.00,13.50,796.50,'2023-02-01 12:05:41','',''),(4720,'1','302','1',1,'Retail Sale Id 4552',4496.96,0.00,0.00,6.11,519.35,'2023-02-01 12:07:05','',''),(4721,'1','302','1',1,'Retail Sale Id 4553',2502.40,0.00,0.00,3.40,289.00,'2023-02-01 12:53:02','',''),(4722,'1','302','1',1,'Retail Sale Id 4554',2001.92,0.00,0.00,2.72,231.20,'2023-02-01 12:57:02','',''),(4723,'1','302','1',1,'Retail Sale Id 4555',11360.00,0.00,0.00,16.00,944.00,'2023-02-01 13:02:33','',''),(4724,'1','302','1',1,'Retail Sale Id 4556',3996.48,0.00,0.00,5.43,461.55,'2023-02-01 13:03:12','',''),(4725,'1','302','1',1,'Retail Sale Id 4557',4260.00,0.00,0.00,6.00,354.00,'2023-02-01 13:11:16','',''),(4726,'1','302','1',1,'Retail Sale Id 4558',4496.96,0.00,0.00,6.11,519.35,'2023-02-01 13:16:56','',''),(4727,'1','302','1',1,'Retail Sale Id 4559',4997.44,0.00,0.00,6.79,577.15,'2023-02-01 13:19:55','',''),(4728,'1','302','1',1,'Retail Sale Id 4560',26270.00,0.00,0.00,37.00,2183.00,'2023-02-01 13:21:11','',''),(4729,'1','302','1',1,'Retail Sale Id 4562',2208.00,0.00,0.00,3.00,255.00,'2023-02-01 13:42:22','',''),(4730,'1','302','1',1,'Retail Sale Id 4563',4997.44,0.00,0.00,6.79,577.15,'2023-02-01 13:46:18','',''),(4731,'1','302','1',1,'Retail Sale Id 4564',4416.00,0.00,0.00,6.00,510.00,'2023-02-01 13:49:24','',''),(4732,'1','302','1',1,'Retail Sale Id 4565',3996.48,0.00,0.00,5.43,461.55,'2023-02-01 13:59:47','',''),(4733,'1','302','1',1,'Retail Sale Id 4566',2200.64,0.00,0.00,2.99,254.15,'2023-02-01 14:05:42','',''),(4734,'1','302','1',1,'Retail Sale Id 4567',4416.00,0.00,0.00,6.00,510.00,'2023-02-01 14:08:27','',''),(4735,'1','302','1',1,'Retail Sale Id 4568',2252.16,0.00,0.00,3.06,260.10,'2023-02-01 14:12:20','',''),(4736,'1','302','1',1,'Retail Sale Id 4571',2208.00,0.00,0.00,3.00,255.00,'2023-02-01 14:22:52','',''),(4737,'1','302','1',1,'Retail Sale Id 4572',35500.00,0.00,0.00,50.00,2950.00,'2023-02-01 14:23:57','',''),(4738,'1','302','1',1,'Retail Sale Id 4573',7360.00,0.00,0.00,10.00,850.00,'2023-02-01 14:26:13','',''),(4739,'1','302','1',1,'Retail Sale Id 4574',3002.88,0.00,0.00,4.08,346.80,'2023-02-01 14:30:22','',''),(4740,'1','302','1',1,'Retail Sale Id 4575',3996.48,0.00,0.00,5.43,461.55,'2023-02-01 14:35:17','',''),(4741,'1','302','1',1,'Retail Sale Id 4576',3996.48,0.00,0.00,5.43,461.55,'2023-02-01 14:36:49','',''),(4742,'1','302','1',1,'Retail Sale Id 4577',4496.96,0.00,0.00,6.11,519.35,'2023-02-01 14:38:00','',''),(4743,'1','302','1',1,'Retail Sale Id 4578',1000.96,0.00,0.00,1.36,115.60,'2023-02-01 14:39:44','',''),(4744,'1','302','1',1,'Retail Sale Id 4579',9200.00,0.00,0.00,12.50,1062.50,'2023-02-01 14:44:33','',''),(4745,'1','302','1',1,'Retail Sale Id 4580',3702.08,0.00,0.00,5.03,427.55,'2023-02-01 14:46:46','',''),(4746,'1','302','1',1,'Retail Sale Id 4581',2001.92,0.00,0.00,2.72,231.20,'2023-02-01 14:47:48','',''),(4747,'1','302','1',1,'Retail Sale Id 4582',3680.00,0.00,0.00,5.00,425.00,'2023-02-01 14:50:49','',''),(4748,'1','302','1',1,'Retail Sale Id 4583',2944.00,0.00,0.00,4.00,340.00,'2023-02-01 14:56:39','',''),(4749,'1','302','1',1,'Retail Sale Id 4584',2502.40,0.00,0.00,3.40,289.00,'2023-02-01 14:58:42','',''),(4750,'1','302','1',1,'Retail Sale Id 4585',743.36,0.00,0.00,1.01,85.85,'2023-02-01 15:03:41','',''),(4751,'1','302','1',1,'Retail Sale Id 4586',3680.00,0.00,0.00,5.00,425.00,'2023-02-01 15:09:58','',''),(4752,'1','302','1',1,'Retail Sale Id 4587',802.24,0.00,0.00,1.09,92.65,'2023-02-01 15:12:21','',''),(4753,'1','302','1',1,'Retail Sale Id 4588',1501.44,0.00,0.00,2.04,173.40,'2023-02-01 15:16:51','',''),(4754,'1','302','1',1,'Retail Sale Id 4589',2303.68,0.00,0.00,3.13,266.05,'2023-02-01 15:19:20','',''),(4755,'1','302','1',1,'Retail Sale Id 4590',9200.00,0.00,0.00,12.50,1062.50,'2023-02-01 15:47:42','',''),(4756,'1','302','1',1,'Retail Sale Id 4591',4452.80,0.00,0.00,6.05,514.25,'2023-02-01 15:48:47','',''),(4757,'1','302','1',1,'Retail Sale Id 4591',5998.40,0.00,0.00,8.15,692.75,'2023-02-01 15:48:47','',''),(4758,'1','302','1',1,'Retail Sale Id 4592',4416.00,0.00,0.00,6.00,510.00,'2023-02-01 15:50:57','',''),(4759,'1','302','1',1,'Retail Sale Id 4592',9200.00,0.00,0.00,12.50,1062.50,'2023-02-01 15:50:57','',''),(4760,'1','302','1',1,'Retail Sale Id 4593',3002.88,0.00,0.00,4.08,346.80,'2023-02-01 15:53:02','',''),(4761,'1','302','1',1,'Retail Sale Id 4594',2001.92,0.00,0.00,2.72,231.20,'2023-02-01 15:57:34','',''),(4762,'1','302','1',1,'Retail Sale Id 4595',2001.92,0.00,0.00,2.72,231.20,'2023-02-01 16:01:59','',''),(4763,'1','302','1',1,'Retail Sale Id 4596',5680.00,0.00,0.00,8.00,472.00,'2023-02-01 16:09:59','',''),(4764,'1','302','1',1,'Retail Sale Id 4597',1472.00,0.00,0.00,2.00,170.00,'2023-02-01 16:21:22','',''),(4765,'1','302','1',1,'Retail Sale Id 4598',2208.00,0.00,0.00,3.00,255.00,'2023-02-01 16:22:43','',''),(4766,'1','302','1',1,'Retail Sale Id 4599',1700.16,0.00,0.00,2.31,196.35,'2023-02-01 16:28:07','',''),(4767,'1','302','1',1,'Retail Sale Id 4600',14200.00,0.00,0.00,20.00,1180.00,'2023-02-01 16:32:06','',''),(4768,'1','302','1',1,'Retail Sale Id 4601',3002.88,0.00,0.00,4.08,346.80,'2023-02-01 16:35:34','',''),(4769,'1','302','1',1,'Retail Sale Id 4602',4416.00,0.00,0.00,6.00,510.00,'2023-02-01 16:40:16','',''),(4770,'1','302','1',1,'Retail Sale Id 4603',2208.00,0.00,0.00,3.00,255.00,'2023-02-01 16:42:16','',''),(4771,'1','302','1',1,'Retail Sale Id 4604',736.00,0.00,0.00,1.00,85.00,'2023-02-01 16:44:00','',''),(4772,'1','302','1',1,'Retail Sale Id 4605',9200.00,0.00,0.00,12.50,1062.50,'2023-02-01 16:47:33','',''),(4773,'1','302','1',1,'Retail Sale Id 4605',9200.00,0.00,0.00,12.50,1062.50,'2023-02-01 16:47:33','',''),(4774,'1','302','1',1,'Retail Sale Id 4606',3680.00,0.00,0.00,5.00,425.00,'2023-02-01 16:49:30','',''),(4775,'1','302','1',1,'Retail Sale Id 4607',3002.88,0.00,0.00,4.08,346.80,'2023-02-01 16:50:13','',''),(4776,'1','302','1',1,'Retail Sale Id 4608',1898.88,0.00,0.00,2.58,219.30,'2023-02-01 16:51:30','',''),(4777,'1','302','1',1,'Retail Sale Id 4610',2208.00,0.00,0.00,3.00,255.00,'2023-02-01 16:58:56','',''),(4778,'1','302','1',1,'Retail Sale Id 4611',7360.00,0.00,0.00,10.00,850.00,'2023-02-01 17:10:24','',''),(4779,'1','302','1',1,'Retail Sale Id 4612',4416.00,0.00,0.00,6.00,510.00,'2023-02-01 17:16:51','',''),(4780,'1','302','1',1,'Retail Sale Id 4613',2944.00,0.00,0.00,4.00,340.00,'2023-02-01 17:18:14','',''),(4781,'1','302','1',1,'Retail Sale Id 4614',2303.68,0.00,0.00,3.13,266.05,'2023-02-01 17:30:28','',''),(4782,'1','302','1',1,'Retail Sale Id 4615',9200.00,0.00,0.00,12.50,1062.50,'2023-02-01 17:32:42','',''),(4783,'1','302','1',1,'Retail Sale Id 4615',9200.00,0.00,0.00,12.50,1062.50,'2023-02-01 17:32:42','',''),(4784,'1','302','1',1,'Retail Sale Id 4616',1648.64,0.00,0.00,2.24,190.40,'2023-02-01 17:36:32','',''),(4785,'1','302','1',1,'Retail Sale Id 4617',2001.92,0.00,0.00,2.72,231.20,'2023-02-01 17:43:18','',''),(4786,'1','302','1',1,'Retail Sale Id 4618',4416.00,0.00,0.00,6.00,510.00,'2023-02-01 17:44:33','',''),(4787,'1','302','1',1,'Retail Sale Id 4619',2001.92,0.00,0.00,2.72,231.20,'2023-02-01 17:50:10','',''),(4788,'1','302','1',1,'Retail Sale Id 4620',9200.00,0.00,0.00,12.50,1062.50,'2023-02-01 17:52:06','',''),(4789,'1','302','1',1,'Retail Sale Id 4621',2208.00,0.00,0.00,3.00,255.00,'2023-02-01 17:56:57','',''),(4790,'1','302','1',1,'Retail Sale Id 4622',4416.00,0.00,0.00,6.00,510.00,'2023-02-01 18:01:12','',''),(4791,'1','302','1',1,'Retail Sale Id 4623',4416.00,0.00,0.00,6.00,510.00,'2023-02-01 18:11:09','',''),(4792,'1','302','1',1,'Retail Sale Id 4624',9200.00,0.00,0.00,12.50,1062.50,'2023-02-01 18:15:56','',''),(4793,'1','302','1',1,'Retail Sale Id 4625',1472.00,0.00,0.00,2.00,170.00,'2023-02-01 18:19:36','',''),(4794,'1','302','1',1,'Retail Sale Id 4626',2208.00,0.00,0.00,3.00,255.00,'2023-02-01 18:20:17','',''),(4795,'1','302','1',1,'Retail Sale Id 4627',16928.00,0.00,0.00,23.00,1955.00,'2023-02-01 18:22:34','',''),(4796,'1','302','1',1,'Retail Sale Id 4628',9200.00,0.00,0.00,12.50,1062.50,'2023-02-01 18:25:54','',''),(4797,'1','302','1',1,'Retail Sale Id 4629',3002.88,0.00,0.00,4.08,346.80,'2023-02-01 18:28:45','',''),(4798,'1','302','1',1,'Retail Sale Id 4630',2001.92,0.00,0.00,2.72,231.20,'2023-02-01 18:30:17','',''),(4799,'1','302','1',1,'Retail Sale Id 4631',3002.88,0.00,0.00,4.08,346.80,'2023-02-01 18:33:47','',''),(4800,'1','302','1',1,'Retail Sale Id 4632',736.00,0.00,0.00,1.00,85.00,'2023-02-01 18:35:41','',''),(4801,'1','302','1',1,'Retail Sale Id 4633',802.24,0.00,0.00,1.09,92.65,'2023-02-01 18:38:19','',''),(4802,'1','302','1',1,'Retail Sale Id 4634',1420.00,0.00,0.00,2.00,118.00,'2023-02-01 18:40:34','',''),(4803,'1','302','1',1,'Retail Sale Id 4635',3680.00,0.00,0.00,5.00,425.00,'2023-02-01 18:42:43','',''),(4804,'1','302','1',1,'Retail Sale Id 4635',5888.00,0.00,0.00,8.00,680.00,'2023-02-01 18:42:43','',''),(4805,'1','302','1',1,'Retail Sale Id 4635',9200.00,0.00,0.00,12.50,1062.50,'2023-02-01 18:42:43','',''),(4806,'1','302','1',1,'Return of Retail Sale Id 4590',0.00,9200.00,12.50,0.00,-1062.50,'2023-02-01 19:23:18','',''),(4807,'1','302','1',1,'Retail Sale Id 4637',4658.88,0.00,0.00,6.33,538.05,'2023-02-01 19:25:23','',''),(4808,'1','302','1',1,'Retail Sale Id 4638',2001.92,0.00,0.00,2.72,231.20,'2023-02-02 07:41:31','',''),(4809,'1','302','1',1,'Retail Sale Id 4639',5888.00,0.00,0.00,8.00,680.00,'2023-02-02 07:46:46','',''),(4810,'1','302','1',1,'Retail Sale Id 4640',9200.00,0.00,0.00,12.50,1062.50,'2023-02-02 07:50:34','',''),(4811,'1','302','1',1,'Retail Sale Id 4641',3680.00,0.00,0.00,5.00,425.00,'2023-02-02 07:55:43','',''),(4812,'1','302','1',1,'Retail Sale Id 4642',4416.00,0.00,0.00,6.00,510.00,'2023-02-02 08:04:17','',''),(4813,'1','302','1',1,'Retail Sale Id 4642',9200.00,0.00,0.00,12.50,1062.50,'2023-02-02 08:04:17','',''),(4814,'1','302','1',1,'Retail Sale Id 4643',3680.00,0.00,0.00,5.00,425.00,'2023-02-02 08:05:41','',''),(4815,'1','302','1',1,'Retail Sale Id 4644',2208.00,0.00,0.00,3.00,255.00,'2023-02-02 08:06:56','',''),(4816,'1','302','1',1,'Retail Sale Id 4645',9200.00,0.00,0.00,12.50,1062.50,'2023-02-02 08:23:48','',''),(4817,'1','302','1',1,'Retail Sale Id 4646',5152.00,0.00,0.00,7.00,595.00,'2023-02-02 08:29:08','',''),(4818,'1','302','1',1,'Retail Sale Id 4648',2208.00,0.00,0.00,3.00,255.00,'2023-02-02 08:32:06','',''),(4819,'1','302','1',1,'Retail Sale Id 4649',3002.88,0.00,0.00,4.08,346.80,'2023-02-02 08:41:46','',''),(4820,'1','302','1',1,'Retail Sale Id 4650',2208.00,0.00,0.00,3.00,255.00,'2023-02-02 08:44:21','',''),(4821,'1','302','1',1,'Retail Sale Id 4651',2208.00,0.00,0.00,3.00,255.00,'2023-02-02 08:50:41','',''),(4822,'1','302','1',1,'Retail Sale Id 4652',1501.44,0.00,0.00,2.04,173.40,'2023-02-02 08:51:29','',''),(4823,'1','302','1',1,'Retail Sale Id 4653',5998.40,0.00,0.00,8.15,692.75,'2023-02-02 08:53:48','',''),(4824,'1','302','1',1,'Retail Sale Id 4654',699.20,0.00,0.00,0.95,80.75,'2023-02-02 08:55:29','',''),(4825,'1','302','1',1,'Retail Sale Id 4655',3680.00,0.00,0.00,5.00,425.00,'2023-02-02 09:02:56','',''),(4826,'1','302','1',1,'Retail Sale Id 4656',4416.00,0.00,0.00,6.00,510.00,'2023-02-02 09:09:13','',''),(4827,'1','302','1',1,'Retail Sale Id 4658',3996.48,0.00,0.00,5.43,461.55,'2023-02-02 09:17:25','',''),(4828,'1','302','1',1,'Retail Sale Id 4659',9200.00,0.00,0.00,12.50,1062.50,'2023-02-02 09:24:52','',''),(4829,'1','302','1',1,'Retail Sale Id 4660',2200.64,0.00,0.00,2.99,254.15,'2023-02-02 09:28:47','',''),(4830,'1','302','1',1,'Retail Sale Id 4661',9200.00,0.00,0.00,12.50,1062.50,'2023-02-02 09:33:07','',''),(4831,'1','302','1',1,'Retail Sale Id 4662',2001.92,0.00,0.00,2.72,231.20,'2023-02-02 09:34:05','',''),(4832,'1','302','1',1,'Retail Sale Id 4663',7360.00,0.00,0.00,10.00,850.00,'2023-02-02 09:37:01','',''),(4833,'1','302','1',1,'Retail Sale Id 4664',1000.96,0.00,0.00,1.36,115.60,'2023-02-02 09:38:22','',''),(4834,'1','302','1',1,'Retail Sale Id 4665',2001.92,0.00,0.00,2.72,231.20,'2023-02-02 09:44:46','',''),(4835,'1','302','1',1,'Retail Sale Id 4666',2208.00,0.00,0.00,3.00,255.00,'2023-02-02 09:46:38','',''),(4836,'1','302','1',1,'Retail Sale Id 4667',2944.00,0.00,0.00,4.00,340.00,'2023-02-02 09:47:17','',''),(4837,'1','302','1',1,'Retail Sale Id 4668',2001.92,0.00,0.00,2.72,231.20,'2023-02-02 09:49:35','',''),(4838,'1','302','1',1,'Retail Sale Id 4669',5998.40,0.00,0.00,8.15,692.75,'2023-02-02 09:50:57','',''),(4839,'1','302','1',1,'Retail Sale Id 4670',3996.48,0.00,0.00,5.43,461.55,'2023-02-02 10:02:05','',''),(4840,'1','302','1',1,'Retail Sale Id 4672',7396.80,0.00,0.00,10.05,854.25,'2023-02-02 10:05:10','',''),(4841,'1','302','1',1,'Retail Sale Id 4673',2200.64,0.00,0.00,2.99,254.15,'2023-02-02 10:06:46','',''),(4842,'1','302','1',1,'Retail Sale Id 4674',2208.00,0.00,0.00,3.00,255.00,'2023-02-02 10:14:52','',''),(4843,'1','302','1',1,'Retail Sale Id 4675',2068.16,0.00,0.00,2.81,238.85,'2023-02-02 10:16:57','',''),(4844,'1','302','1',1,'Retail Sale Id 4676',2001.92,0.00,0.00,2.72,231.20,'2023-02-02 10:21:01','',''),(4845,'1','302','1',1,'Retail Sale Id 4677',2944.00,0.00,0.00,4.00,340.00,'2023-02-02 10:23:30','',''),(4846,'1','302','1',1,'Retail Sale Id 4678',1501.44,0.00,0.00,2.04,173.40,'2023-02-02 10:25:21','',''),(4847,'1','302','1',1,'Retail Sale Id 4679',9200.00,0.00,0.00,12.50,1062.50,'2023-02-02 10:26:56','',''),(4848,'1','302','1',1,'Retail Sale Id 4680',500.48,0.00,0.00,0.68,57.80,'2023-02-02 10:28:08','',''),(4849,'1','302','1',1,'Retail Sale Id 4681',9200.00,0.00,0.00,12.50,1062.50,'2023-02-02 10:40:15','',''),(4850,'1','302','1',1,'Retail Sale Id 4682',8832.00,0.00,0.00,12.00,1020.00,'2023-02-02 10:43:08','',''),(4851,'1','302','1',1,'Retail Sale Id 4683',4416.00,0.00,0.00,6.00,510.00,'2023-02-02 10:45:36','',''),(4852,'1','302','1',1,'Retail Sale Id 4684',2215.36,0.00,0.00,3.01,255.85,'2023-02-02 10:46:57','',''),(4853,'1','302','1',1,'Retail Sale Id 4685',3002.88,0.00,0.00,4.08,346.80,'2023-02-02 10:53:56','',''),(4854,'1','302','1',1,'Retail Sale Id 4686',4416.00,0.00,0.00,6.00,510.00,'2023-02-02 10:57:58','',''),(4855,'1','302','1',1,'Retail Sale Id 4687',4416.00,0.00,0.00,6.00,510.00,'2023-02-02 10:59:38','',''),(4856,'1','302','1',1,'Retail Sale Id 4688',35500.00,0.00,0.00,50.00,2950.00,'2023-02-02 11:01:55','',''),(4857,'1','302','1',1,'Retail Sale Id 4689',3002.88,0.00,0.00,4.08,346.80,'2023-02-02 11:19:54','',''),(4858,'1','302','1',1,'Retail Sale Id 4689',9200.00,0.00,0.00,12.50,1062.50,'2023-02-02 11:19:54','',''),(4859,'1','302','1',1,'Retail Sale Id 4690',2944.00,0.00,0.00,4.00,340.00,'2023-02-02 11:30:55','',''),(4860,'1','302','1',1,'Retail Sale Id 4691',4496.96,0.00,0.00,6.11,519.35,'2023-02-02 11:45:13','',''),(4861,'1','302','1',1,'Retail Sale Id 4692',4416.00,0.00,0.00,6.00,510.00,'2023-02-02 11:50:47','',''),(4862,'1','302','1',1,'Retail Sale Id 4693',7360.00,0.00,0.00,10.00,850.00,'2023-02-02 12:11:21','',''),(4863,'1','302','1',1,'Retail Sale Id 4694',3680.00,0.00,0.00,5.00,425.00,'2023-02-02 12:14:14','',''),(4864,'1','302','1',1,'Retail Sale Id 4695',9200.00,0.00,0.00,12.50,1062.50,'2023-02-02 12:18:14','',''),(4865,'1','302','1',1,'Retail Sale Id 4696',2001.92,0.00,0.00,2.72,231.20,'2023-02-02 12:29:13','',''),(4866,'1','302','1',1,'Retail Sale Id 4697',2208.00,0.00,0.00,3.00,255.00,'2023-02-02 12:30:24','',''),(4867,'1','302','1',1,'Retail Sale Id 4698',3002.88,0.00,0.00,4.08,346.80,'2023-02-02 12:31:30','',''),(4868,'1','302','1',1,'Retail Sale Id 4699',3680.00,0.00,0.00,5.00,425.00,'2023-02-02 12:32:41','',''),(4869,'1','302','1',1,'Retail Sale Id 4700',3002.88,0.00,0.00,4.08,346.80,'2023-02-02 12:36:23','',''),(4870,'1','302','1',1,'Retail Sale Id 4701',9200.00,0.00,0.00,12.50,1062.50,'2023-02-02 12:37:50','',''),(4871,'1','302','1',1,'Retail Sale Id 4702',4416.00,0.00,0.00,6.00,510.00,'2023-02-02 12:38:59','',''),(4872,'1','302','1',1,'Retail Sale Id 4703',8832.00,0.00,0.00,12.00,1020.00,'2023-02-02 12:41:13','',''),(4873,'1','302','1',1,'Retail Sale Id 4704',9200.00,0.00,0.00,12.50,1062.50,'2023-02-02 12:48:10','',''),(4874,'1','302','1',1,'Retail Sale Id 4705',3550.00,0.00,0.00,5.00,295.00,'2023-02-02 12:50:16','',''),(4875,'1','302','1',1,'Retail Sale Id 4706',4416.00,0.00,0.00,6.00,510.00,'2023-02-02 12:51:34','',''),(4876,'1','302','1',1,'Retail Sale Id 4707',1000.96,0.00,0.00,1.36,115.60,'2023-02-02 12:54:05','',''),(4877,'1','302','1',1,'Retail Sale Id 4708',1472.00,0.00,0.00,2.00,170.00,'2023-02-02 13:01:06','',''),(4878,'1','302','1',1,'Retail Sale Id 4709',3680.00,0.00,0.00,5.00,425.00,'2023-02-02 13:18:00','',''),(4879,'1','302','1',1,'Retail Sale Id 4710',9200.00,0.00,0.00,12.50,1062.50,'2023-02-02 13:34:12','',''),(4880,'1','302','1',1,'Retail Sale Id 4711',1000.96,0.00,0.00,1.36,115.60,'2023-02-02 13:35:43','',''),(4881,'1','302','1',1,'Retail Sale Id 4712',4416.00,0.00,0.00,6.00,510.00,'2023-02-02 13:50:28','',''),(4882,'1','302','1',1,'Retail Sale Id 4713',3680.00,0.00,0.00,5.00,425.00,'2023-02-02 13:57:08','',''),(4883,'1','302','1',1,'Retail Sale Id 4714',2208.00,0.00,0.00,3.00,255.00,'2023-02-02 14:07:09','',''),(4884,'1','302','1',1,'Retail Sale Id 4715',9200.00,0.00,0.00,12.50,1062.50,'2023-02-02 14:16:26','',''),(4885,'1','302','1',1,'Retail Sale Id 4716',2208.00,0.00,0.00,3.00,255.00,'2023-02-02 14:19:32','',''),(4886,'1','302','1',1,'Retail Sale Id 4717',4416.00,0.00,0.00,6.00,510.00,'2023-02-02 14:21:07','',''),(4887,'1','302','1',1,'Retail Sale Id 4718',11040.00,0.00,0.00,15.00,1275.00,'2023-02-02 14:22:32','',''),(4888,'1','302','1',1,'Retail Sale Id 4719',4997.44,0.00,0.00,6.79,577.15,'2023-02-02 14:27:38','',''),(4889,'1','302','1',1,'Retail Sale Id 4720',4416.00,0.00,0.00,6.00,510.00,'2023-02-02 14:36:43','',''),(4890,'1','302','1',1,'Retail Sale Id 4721',9200.00,0.00,0.00,12.50,1062.50,'2023-02-02 14:52:54','',''),(4891,'1','302','1',1,'Retail Sale Id 4722',17750.00,0.00,0.00,25.00,1475.00,'2023-02-02 14:54:10','',''),(4892,'1','302','1',1,'Retail Sale Id 4723',18400.00,0.00,0.00,25.00,2125.00,'2023-02-02 14:55:36','',''),(4893,'1','302','1',1,'Retail Sale Id 4724',4416.00,0.00,0.00,6.00,510.00,'2023-02-02 14:58:05','',''),(4894,'1','302','1',1,'Retail Sale Id 4725',9200.00,0.00,0.00,12.50,1062.50,'2023-02-02 14:59:24','',''),(4895,'1','302','1',1,'Retail Sale Id 4726',4416.00,0.00,0.00,6.00,510.00,'2023-02-02 15:04:52','',''),(4896,'1','302','1',1,'Retail Sale Id 4726',9200.00,0.00,0.00,12.50,1062.50,'2023-02-02 15:04:52','',''),(4897,'1','302','1',1,'Retail Sale Id 4727',2208.00,0.00,0.00,3.00,255.00,'2023-02-02 15:05:53','',''),(4898,'1','302','1',1,'Retail Sale Id 4728',9200.00,0.00,0.00,12.50,1062.50,'2023-02-02 15:07:07','',''),(4899,'1','302','1',1,'Retail Sale Id 4729',1000.96,0.00,0.00,1.36,115.60,'2023-02-02 15:12:00','',''),(4900,'1','302','1',1,'Retail Sale Id 4730',2208.00,0.00,0.00,3.00,255.00,'2023-02-02 15:12:51','',''),(4901,'1','302','1',1,'Retail Sale Id 4731',2001.92,0.00,0.00,2.72,231.20,'2023-02-02 15:15:11','',''),(4902,'1','302','1',1,'Retail Sale Id 4732',4416.00,0.00,0.00,6.00,510.00,'2023-02-02 15:42:01','',''),(4903,'1','302','1',1,'Retail Sale Id 4733',18400.00,0.00,0.00,25.00,2125.00,'2023-02-02 15:47:06','',''),(4904,'1','302','1',1,'Retail Sale Id 4734',9200.00,0.00,0.00,12.50,1062.50,'2023-02-02 15:53:37','',''),(4905,'1','302','1',1,'Retail Sale Id 4735',4997.44,0.00,0.00,6.79,577.15,'2023-02-02 15:54:54','',''),(4906,'1','302','1',1,'Retail Sale Id 4737',9200.00,0.00,0.00,12.50,1062.50,'2023-02-02 16:21:55','',''),(4907,'1','302','1',1,'Retail Sale Id 4738',2944.00,0.00,0.00,4.00,340.00,'2023-02-02 16:24:26','',''),(4908,'1','302','1',1,'Retail Sale Id 4739',3002.88,0.00,0.00,4.08,346.80,'2023-02-02 16:31:37','',''),(4909,'1','302','1',1,'Retail Sale Id 4740',1000.96,0.00,0.00,1.36,115.60,'2023-02-02 16:37:17','',''),(4910,'1','302','1',1,'Retail Sale Id 4741',4416.00,0.00,0.00,6.00,510.00,'2023-02-02 16:39:00','',''),(4911,'1','302','1',1,'Retail Sale Id 4742',2208.00,0.00,0.00,3.00,255.00,'2023-02-02 16:41:19','',''),(4912,'1','302','1',1,'Retail Sale Id 4743',736.00,0.00,0.00,1.00,85.00,'2023-02-02 16:42:34','',''),(4913,'1','302','1',1,'Retail Sale Id 4744',4416.00,0.00,0.00,6.00,510.00,'2023-02-02 16:48:47','',''),(4914,'1','302','1',1,'Retail Sale Id 4745',8096.00,0.00,0.00,11.00,935.00,'2023-02-02 16:50:27','',''),(4915,'1','302','1',1,'Retail Sale Id 4746',3680.00,0.00,0.00,5.00,425.00,'2023-02-02 16:52:37','',''),(4916,'1','302','1',1,'Retail Sale Id 4746',9200.00,0.00,0.00,12.50,1062.50,'2023-02-02 16:52:37','',''),(4917,'1','302','1',1,'Retail Sale Id 4747',2001.92,0.00,0.00,2.72,231.20,'2023-02-02 17:01:49','',''),(4918,'1','302','1',1,'Retail Sale Id 4748',2502.40,0.00,0.00,3.40,289.00,'2023-02-02 17:03:06','',''),(4919,'1','302','1',1,'Retail Sale Id 4748',2502.40,0.00,0.00,3.40,289.00,'2023-02-02 17:03:06','',''),(4920,'1','302','1',1,'Retail Sale Id 4749',1501.44,0.00,0.00,2.04,173.40,'2023-02-02 17:04:00','',''),(4921,'1','302','1',1,'Retail Sale Id 4750',18400.00,0.00,0.00,25.00,2125.00,'2023-02-02 17:07:22','',''),(4922,'1','302','1',1,'Retail Sale Id 4751',8832.00,0.00,0.00,12.00,1020.00,'2023-02-02 17:08:09','',''),(4923,'1','302','1',1,'Retail Sale Id 4752',8000.32,0.00,0.00,10.87,923.95,'2023-02-02 17:15:43','',''),(4924,'1','302','1',1,'Retail Sale Id 4753',9200.00,0.00,0.00,12.50,1062.50,'2023-02-02 17:17:09','',''),(4925,'1','302','1',1,'Retail Sale Id 4754',3996.48,0.00,0.00,5.43,461.55,'2023-02-02 17:18:13','',''),(4926,'1','302','1',1,'Retail Sale Id 4755',10650.00,0.00,0.00,15.00,885.00,'2023-02-02 17:19:14','',''),(4927,'1','302','1',1,'Retail Sale Id 4756',21300.00,0.00,0.00,30.00,1770.00,'2023-02-02 17:21:09','',''),(4928,'1','302','1',1,'Retail Sale Id 4757',4416.00,0.00,0.00,6.00,510.00,'2023-02-02 17:23:40','',''),(4929,'1','302','1',1,'Retail Sale Id 4758',500.48,0.00,0.00,0.68,57.80,'2023-02-02 17:27:03','',''),(4930,'1','302','1',1,'Retail Sale Id 4759',3680.00,0.00,0.00,5.00,425.00,'2023-02-02 17:27:50','',''),(4931,'1','302','1',1,'Retail Sale Id 4760',2001.92,0.00,0.00,2.72,231.20,'2023-02-02 17:29:50','',''),(4932,'1','302','1',1,'Retail Sale Id 4762',2001.92,0.00,0.00,2.72,231.20,'2023-02-02 17:35:16','',''),(4933,'1','302','1',1,'Retail Sale Id 4763',1501.44,0.00,0.00,2.04,173.40,'2023-02-02 17:41:45','',''),(4934,'1','302','1',1,'Retail Sale Id 4764',35500.00,0.00,0.00,50.00,2950.00,'2023-02-02 17:45:52','',''),(4935,'1','302','1',1,'Retail Sale Id 4765',2001.92,0.00,0.00,2.72,231.20,'2023-02-02 17:51:05','',''),(4936,'1','302','1',1,'Retail Sale Id 4765',2001.92,0.00,0.00,2.72,231.20,'2023-02-02 17:51:05','',''),(4937,'1','302','1',1,'Retail Sale Id 4765',3503.36,0.00,0.00,4.76,404.60,'2023-02-02 17:51:05','',''),(4938,'1','302','1',1,'Retail Sale Id 4766',2001.92,0.00,0.00,2.72,231.20,'2023-02-02 17:55:44','',''),(4939,'1','302','1',1,'Retail Sale Id 4767',2208.00,0.00,0.00,3.00,255.00,'2023-02-02 17:58:06','',''),(4940,'1','302','1',1,'Retail Sale Id 4768',1472.00,0.00,0.00,2.00,170.00,'2023-02-02 18:04:11','',''),(4941,'1','302','1',1,'Retail Sale Id 4769',4416.00,0.00,0.00,6.00,510.00,'2023-02-02 18:06:03','',''),(4942,'1','302','1',1,'Retail Sale Id 4770',3002.88,0.00,0.00,4.08,346.80,'2023-02-02 18:11:03','',''),(4943,'1','302','1',1,'Retail Sale Id 4771',2001.92,0.00,0.00,2.72,231.20,'2023-02-02 18:13:07','',''),(4944,'1','302','1',1,'Retail Sale Id 4772',36.80,0.00,0.00,0.05,4.25,'2023-02-02 19:44:15','',''),(4945,'1','302','1',1,'Retail Sale Id 4773',9200.00,0.00,0.00,12.50,1062.50,'2023-02-03 16:07:09','',''),(4946,'1','302','1',1,'Retail Sale Id 4774',5880.64,0.00,0.00,7.99,679.15,'2023-02-03 16:08:59','',''),(4947,'1','302','1',1,'Retail Sale Id 4775',332701.44,0.00,0.00,452.04,38423.40,'2023-02-03 16:17:42','',''),(4948,'1','302','1',1,'Retail Sale Id 4776',126380.00,0.00,0.00,178.00,10502.00,'2023-02-03 16:18:47','',''),(4949,'1','302','1',1,'Retail Sale Id 4777',4416.00,0.00,0.00,6.00,510.00,'2023-02-03 16:26:47','',''),(4950,'1','302','1',1,'Retail Sale Id 4778',2001.92,0.00,0.00,2.72,231.20,'2023-02-03 16:30:12','',''),(4951,'1','302','1',1,'Retail Sale Id 4779',1472.00,0.00,0.00,2.00,170.00,'2023-02-03 16:33:25','',''),(4952,'1','302','1',1,'Retail Sale Id 4780',2208.00,0.00,0.00,3.00,255.00,'2023-02-03 16:39:24','',''),(4953,'1','302','1',1,'Retail Sale Id 4781',2208.00,0.00,0.00,3.00,255.00,'2023-02-03 16:41:06','',''),(4954,'1','302','1',1,'Retail Sale Id 4782',7100.00,0.00,0.00,10.00,590.00,'2023-02-03 17:01:10','',''),(4955,'1','302','1',1,'Retail Sale Id 4783',1420.00,0.00,0.00,2.00,118.00,'2023-02-03 17:11:13','',''),(4956,'1','302','1',1,'Retail Sale Id 4784',4496.96,0.00,0.00,6.11,519.35,'2023-02-03 17:14:26','',''),(4957,'1','302','1',1,'Retail Sale Id 4785',8000.32,0.00,0.00,10.87,923.95,'2023-02-03 17:15:02','',''),(4958,'1','302','1',1,'Retail Sale Id 4786',2001.92,0.00,0.00,2.72,231.20,'2023-02-03 17:26:01','',''),(4959,'1','302','1',1,'Retail Sale Id 4787',9200.00,0.00,0.00,12.50,1062.50,'2023-02-03 17:28:00','',''),(4960,'1','302','1',1,'Retail Sale Id 4788',2208.00,0.00,0.00,3.00,255.00,'2023-02-03 17:35:21','',''),(4961,'1','302','1',1,'Retail Sale Id 4789',2001.92,0.00,0.00,2.72,231.20,'2023-02-03 17:40:37','',''),(4962,'1','302','1',1,'Retail Sale Id 4790',9200.00,0.00,0.00,12.50,1062.50,'2023-02-03 17:42:15','',''),(4963,'1','302','1',1,'Retail Sale Id 4791',1000.96,0.00,0.00,1.36,115.60,'2023-02-03 17:53:33','',''),(4964,'1','302','1',1,'Retail Sale Id 4792',3680.00,0.00,0.00,5.00,425.00,'2023-02-03 17:54:39','',''),(4965,'1','302','1',1,'Retail Sale Id 4793',1000.96,0.00,0.00,1.36,115.60,'2023-02-03 17:56:04','',''),(4966,'1','302','1',1,'Retail Sale Id 4794',9200.00,0.00,0.00,12.50,1062.50,'2023-02-03 17:59:26','',''),(4967,'1','302','1',1,'Retail Sale Id 4795',3996.48,0.00,0.00,5.43,461.55,'2023-02-03 18:01:26','',''),(4968,'1','302','1',1,'Retail Sale Id 4796',4496.96,0.00,0.00,6.11,519.35,'2023-02-03 18:02:55','',''),(4969,'1','302','1',1,'Retail Sale Id 4797',4997.44,0.00,0.00,6.79,577.15,'2023-02-03 18:03:55','',''),(4970,'1','302','1',1,'Retail Sale Id 4798',1000.96,0.00,0.00,1.36,115.60,'2023-02-03 18:04:49','',''),(4971,'1','302','1',1,'Retail Sale Id 4799',1000.96,0.00,0.00,1.36,115.60,'2023-02-03 18:06:57','',''),(4972,'1','302','1',1,'Retail Sale Id 4801',9200.00,0.00,0.00,12.50,1062.50,'2023-02-03 18:07:49','',''),(4973,'1','302','1',1,'Retail Sale Id 4802',4496.96,0.00,0.00,6.11,519.35,'2023-02-03 18:15:05','',''),(4974,'1','302','1',1,'Retail Sale Id 4803',9200.00,0.00,0.00,12.50,1062.50,'2023-02-03 18:19:06','',''),(4975,'1','302','1',1,'Retail Sale Id 4804',9200.00,0.00,0.00,12.50,1062.50,'2023-02-03 18:27:25','',''),(4976,'1','302','1',1,'Retail Sale Id 4805',4268.80,0.00,0.00,5.80,493.00,'2023-02-03 19:16:56','',''),(4977,'1','302','1',1,'Retail Sale Id 4806',1472.00,0.00,0.00,2.00,170.00,'2023-02-04 08:22:34','',''),(4978,'1','302','1',1,'Retail Sale Id 4807',3996.48,0.00,0.00,5.43,461.55,'2023-02-04 08:25:07','',''),(4979,'1','302','1',1,'Retail Sale Id 4808',1501.44,0.00,0.00,2.04,173.40,'2023-02-04 08:31:21','',''),(4980,'1','302','1',1,'Retail Sale Id 4809',8096.00,0.00,0.00,11.00,935.00,'2023-02-04 08:35:02','',''),(4981,'1','302','1',1,'Retail Sale Id 4810',5888.00,0.00,0.00,8.00,680.00,'2023-02-04 08:40:38','',''),(4982,'1','302','1',1,'Retail Sale Id 4811',3680.00,0.00,0.00,5.00,425.00,'2023-02-04 08:42:33','',''),(4983,'1','302','1',1,'Retail Sale Id 4812',2001.92,0.00,0.00,2.72,231.20,'2023-02-04 08:43:56','',''),(4984,'1','302','1',1,'Retail Sale Id 4813',3996.48,0.00,0.00,5.43,461.55,'2023-02-04 08:53:22','',''),(4985,'1','302','1',1,'Retail Sale Id 4814',2001.92,0.00,0.00,2.72,231.20,'2023-02-04 09:01:28','',''),(4986,'1','302','1',1,'Retail Sale Id 4815',2208.00,0.00,0.00,3.00,255.00,'2023-02-04 09:05:27','',''),(4987,'1','302','1',1,'Retail Sale Id 4817',2208.00,0.00,0.00,3.00,255.00,'2023-02-04 09:13:14','',''),(4988,'1','302','1',1,'Retail Sale Id 4817',7360.00,0.00,0.00,10.00,850.00,'2023-02-04 09:13:15','',''),(4989,'1','302','1',1,'Retail Sale Id 4818',4997.44,0.00,0.00,6.79,577.15,'2023-02-04 09:16:36','',''),(4990,'1','302','1',1,'Retail Sale Id 4819',67450.00,0.00,0.00,95.00,5605.00,'2023-02-04 09:18:59','',''),(4991,'1','302','1',1,'Retail Sale Id 4820',31950.00,0.00,0.00,45.00,2655.00,'2023-02-04 09:25:40','',''),(4992,'1','302','1',1,'Retail Sale Id 4821',9200.00,0.00,0.00,12.50,1062.50,'2023-02-04 09:33:02','',''),(4993,'1','302','1',1,'Retail Sale Id 4822',2001.92,0.00,0.00,2.72,231.20,'2023-02-04 09:37:50','',''),(4994,'1','302','1',1,'Retail Sale Id 4823',5888.00,0.00,0.00,8.00,680.00,'2023-02-04 09:41:05','',''),(4995,'1','302','1',1,'Retail Sale Id 4824',2208.00,0.00,0.00,3.00,255.00,'2023-02-04 09:42:18','',''),(4996,'1','302','1',1,'Retail Sale Id 4825',4416.00,0.00,0.00,6.00,510.00,'2023-02-04 09:46:14','',''),(4997,'1','302','1',1,'Retail Sale Id 4825',9200.00,0.00,0.00,12.50,1062.50,'2023-02-04 09:46:14','',''),(4998,'1','302','1',1,'Retail Sale Id 4826',3680.00,0.00,0.00,5.00,425.00,'2023-02-04 09:51:10','',''),(4999,'1','302','1',1,'Retail Sale Id 4827',9200.00,0.00,0.00,12.50,1062.50,'2023-02-04 09:52:32','',''),(5000,'1','302','1',1,'Retail Sale Id 4828',4416.00,0.00,0.00,6.00,510.00,'2023-02-04 09:57:33','',''),(5001,'1','302','1',1,'Retail Sale Id 4829',736.00,0.00,0.00,1.00,85.00,'2023-02-04 09:58:23','',''),(5002,'1','302','1',1,'Retail Sale Id 4830',7360.00,0.00,0.00,10.00,850.00,'2023-02-04 10:03:04','',''),(5003,'1','302','1',1,'Retail Sale Id 4831',2208.00,0.00,0.00,3.00,255.00,'2023-02-04 10:04:26','',''),(5004,'1','302','1',1,'Retail Sale Id 4832',9200.00,0.00,0.00,12.50,1062.50,'2023-02-04 10:10:47','',''),(5005,'1','302','1',1,'Retail Sale Id 4833',2001.92,0.00,0.00,2.72,231.20,'2023-02-04 10:16:44','',''),(5006,'1','302','1',1,'Retail Sale Id 4834',9200.00,0.00,0.00,12.50,1062.50,'2023-02-04 10:21:18','',''),(5007,'1','302','1',1,'Retail Sale Id 4835',3680.00,0.00,0.00,5.00,425.00,'2023-02-04 10:23:27','',''),(5008,'1','302','1',1,'Retail Sale Id 4836',3680.00,0.00,0.00,5.00,425.00,'2023-02-04 10:24:59','',''),(5009,'1','302','1',1,'Retail Sale Id 4837',3680.00,0.00,0.00,5.00,425.00,'2023-02-04 10:27:44','',''),(5010,'1','302','1',1,'Retail Sale Id 4838',3002.88,0.00,0.00,4.08,346.80,'2023-02-04 10:32:17','',''),(5011,'1','302','1',1,'Retail Sale Id 4839',1501.44,0.00,0.00,2.04,173.40,'2023-02-04 10:35:13','',''),(5012,'1','302','1',1,'Retail Sale Id 4840',4496.96,0.00,0.00,6.11,519.35,'2023-02-04 10:36:56','',''),(5013,'1','302','1',1,'Retail Sale Id 4841',2944.00,0.00,0.00,4.00,340.00,'2023-02-04 10:39:28','',''),(5014,'1','302','1',1,'Retail Sale Id 4842',10650.00,0.00,0.00,15.00,885.00,'2023-02-04 10:44:25','',''),(5015,'1','302','1',1,'Retail Sale Id 4843',9200.00,0.00,0.00,12.50,1062.50,'2023-02-04 10:49:04','',''),(5016,'1','302','1',1,'Retail Sale Id 4844',603.52,0.00,0.00,0.82,69.70,'2023-02-04 10:50:17','',''),(5017,'1','302','1',1,'Retail Sale Id 4845',3002.88,0.00,0.00,4.08,346.80,'2023-02-04 10:51:40','',''),(5018,'1','302','1',1,'Retail Sale Id 4846',9200.00,0.00,0.00,12.50,1062.50,'2023-02-04 10:53:00','',''),(5019,'1','302','1',1,'Retail Sale Id 4847',4416.00,0.00,0.00,6.00,510.00,'2023-02-04 10:58:56','',''),(5020,'1','302','1',1,'Retail Sale Id 4848',4496.96,0.00,0.00,6.11,519.35,'2023-02-04 11:06:17','',''),(5021,'1','302','1',1,'Retail Sale Id 4849',3797.76,0.00,0.00,5.16,438.60,'2023-02-04 11:08:25','',''),(5022,'1','302','1',1,'Retail Sale Id 4850',2208.00,0.00,0.00,3.00,255.00,'2023-02-04 11:09:32','',''),(5023,'1','302','1',1,'Retail Sale Id 4851',9001.28,0.00,0.00,12.23,1039.55,'2023-02-04 11:10:55','',''),(5024,'1','302','1',1,'Retail Sale Id 4852',897.92,0.00,0.00,1.22,103.70,'2023-02-04 11:12:54','',''),(5025,'1','302','1',1,'Retail Sale Id 4853',1501.44,0.00,0.00,2.04,173.40,'2023-02-04 11:13:39','',''),(5026,'1','302','1',1,'Retail Sale Id 4854',500.48,0.00,0.00,0.68,57.80,'2023-02-04 11:14:24','',''),(5027,'1','302','1',1,'Retail Sale Id 4855',2303.68,0.00,0.00,3.13,266.05,'2023-02-04 11:15:34','',''),(5028,'1','302','1',1,'Retail Sale Id 4856',2502.40,0.00,0.00,3.40,289.00,'2023-02-04 11:21:36','',''),(5029,'1','302','1',1,'Retail Sale Id 4857',1501.44,0.00,0.00,2.04,173.40,'2023-02-04 11:30:03','',''),(5030,'1','302','1',1,'Retail Sale Id 4858',2208.00,0.00,0.00,3.00,255.00,'2023-02-04 11:39:39','',''),(5031,'1','302','1',1,'Retail Sale Id 4859',3680.00,0.00,0.00,5.00,425.00,'2023-02-04 11:46:05','',''),(5032,'1','302','1',1,'Retail Sale Id 4860',2208.00,0.00,0.00,3.00,255.00,'2023-02-04 11:48:05','',''),(5033,'1','302','1',1,'Retail Sale Id 4861',3680.00,0.00,0.00,5.00,425.00,'2023-02-04 11:51:49','',''),(5034,'1','302','1',1,'Retail Sale Id 4862',7360.00,0.00,0.00,10.00,850.00,'2023-02-04 11:53:14','',''),(5035,'1','302','1',1,'Retail Sale Id 4863',4416.00,0.00,0.00,6.00,510.00,'2023-02-04 11:56:55','',''),(5036,'1','302','1',1,'Retail Sale Id 4864',4416.00,0.00,0.00,6.00,510.00,'2023-02-04 12:08:33','',''),(5037,'1','302','1',1,'Retail Sale Id 4865',2001.92,0.00,0.00,2.72,231.20,'2023-02-04 12:10:29','',''),(5038,'1','302','1',1,'Retail Sale Id 4866',3503.36,0.00,0.00,4.76,404.60,'2023-02-04 12:14:51','',''),(5039,'1','302','1',1,'Retail Sale Id 4867',699.20,0.00,0.00,0.95,80.75,'2023-02-04 12:15:53','',''),(5040,'1','302','1',1,'Retail Sale Id 4868',4416.00,0.00,0.00,6.00,510.00,'2023-02-04 12:17:13','',''),(5041,'1','302','1',1,'Retail Sale Id 4869',2208.00,0.00,0.00,3.00,255.00,'2023-02-04 12:21:44','',''),(5042,'1','302','1',1,'Retail Sale Id 4870',9200.00,0.00,0.00,12.50,1062.50,'2023-02-04 12:41:00','',''),(5043,'1','302','1',1,'Retail Sale Id 4871',2303.68,0.00,0.00,3.13,266.05,'2023-02-04 12:42:22','',''),(5044,'1','302','1',1,'Retail Sale Id 4872',9200.00,0.00,0.00,12.50,1062.50,'2023-02-04 12:45:46','',''),(5045,'1','302','1',1,'Retail Sale Id 4873',2001.92,0.00,0.00,2.72,231.20,'2023-02-04 12:49:05','',''),(5046,'1','302','1',1,'Retail Sale Id 4874',4416.00,0.00,0.00,6.00,510.00,'2023-02-04 12:54:02','',''),(5047,'1','302','1',1,'Retail Sale Id 4875',9200.00,0.00,0.00,12.50,1062.50,'2023-02-04 12:58:47','',''),(5048,'1','302','1',1,'Retail Sale Id 4876',5998.40,0.00,0.00,8.15,692.75,'2023-02-04 13:00:43','',''),(5049,'1','302','1',1,'Retail Sale Id 4877',7360.00,0.00,0.00,10.00,850.00,'2023-02-04 13:02:09','',''),(5050,'1','302','1',1,'Retail Sale Id 4878',3680.00,0.00,0.00,5.00,425.00,'2023-02-04 13:03:57','',''),(5051,'1','302','1',1,'Retail Sale Id 4879',750.72,0.00,0.00,1.02,86.70,'2023-02-04 13:05:05','',''),(5052,'1','302','1',1,'Retail Sale Id 4880',736.00,0.00,0.00,1.00,85.00,'2023-02-04 13:06:04','',''),(5053,'1','302','1',1,'Retail Sale Id 4881',3680.00,0.00,0.00,5.00,425.00,'2023-02-04 13:09:48','',''),(5054,'1','302','1',1,'Retail Sale Id 4882',2001.92,0.00,0.00,2.72,231.20,'2023-02-04 13:21:21','',''),(5055,'1','302','1',1,'Retail Sale Id 4883',9001.28,0.00,0.00,12.23,1039.55,'2023-02-04 13:34:22','',''),(5056,'1','302','1',1,'Retail Sale Id 4884',9200.00,0.00,0.00,12.50,1062.50,'2023-02-04 13:50:20','',''),(5057,'1','302','1',1,'Retail Sale Id 4885',4416.00,0.00,0.00,6.00,510.00,'2023-02-04 13:51:13','',''),(5058,'1','302','1',1,'Retail Sale Id 4886',4416.00,0.00,0.00,6.00,510.00,'2023-02-04 13:55:11','',''),(5059,'1','302','1',1,'Retail Sale Id 4887',802.24,0.00,0.00,1.09,92.65,'2023-02-04 14:01:00','',''),(5060,'1','302','1',1,'Retail Sale Id 4888',9200.00,0.00,0.00,12.50,1062.50,'2023-02-04 14:02:28','',''),(5061,'1','302','1',1,'Retail Sale Id 4889',2208.00,0.00,0.00,3.00,255.00,'2023-02-04 14:03:53','',''),(5062,'1','302','1',1,'Retail Sale Id 4890',5888.00,0.00,0.00,8.00,680.00,'2023-02-04 14:05:24','',''),(5063,'1','302','1',1,'Retail Sale Id 4891',8832.00,0.00,0.00,12.00,1020.00,'2023-02-04 14:08:26','',''),(5064,'1','302','1',1,'Retail Sale Id 4892',12070.00,0.00,0.00,17.00,1003.00,'2023-02-04 14:13:00','',''),(5065,'1','302','1',1,'Retail Sale Id 4893',2001.92,0.00,0.00,2.72,231.20,'2023-02-04 14:16:59','',''),(5066,'1','302','1',1,'Retail Sale Id 4894',9200.00,0.00,0.00,12.50,1062.50,'2023-02-04 14:21:31','',''),(5067,'1','302','1',1,'Retail Sale Id 4895',8096.00,0.00,0.00,11.00,935.00,'2023-02-04 14:27:31','',''),(5068,'1','302','1',1,'Retail Sale Id 4896',2944.00,0.00,0.00,4.00,340.00,'2023-02-04 14:29:05','',''),(5069,'1','302','1',1,'Retail Sale Id 4897',3680.00,0.00,0.00,5.00,425.00,'2023-02-04 15:02:36','',''),(5070,'1','302','1',1,'Retail Sale Id 4898',1000.96,0.00,0.00,1.36,115.60,'2023-02-04 15:14:35','',''),(5071,'1','302','1',1,'Retail Sale Id 4899',2001.92,0.00,0.00,2.72,231.20,'2023-02-04 15:18:43','',''),(5072,'1','302','1',1,'Retail Sale Id 4900',4416.00,0.00,0.00,6.00,510.00,'2023-02-04 15:42:03','',''),(5073,'1','302','1',1,'Retail Sale Id 4901',9200.00,0.00,0.00,12.50,1062.50,'2023-02-04 15:43:25','',''),(5074,'1','302','1',1,'Retail Sale Id 4902',8832.00,0.00,0.00,12.00,1020.00,'2023-02-04 16:00:37','',''),(5075,'1','302','1',1,'Retail Sale Id 4903',2303.68,0.00,0.00,3.13,266.05,'2023-02-04 16:16:58','',''),(5076,'1','302','1',1,'Retail Sale Id 4904',8832.00,0.00,0.00,12.00,1020.00,'2023-02-04 16:18:24','',''),(5077,'1','302','1',1,'Retail Sale Id 4905',9200.00,0.00,0.00,12.50,1062.50,'2023-02-04 16:28:29','',''),(5078,'1','302','1',1,'Retail Sale Id 4907',500.48,0.00,0.00,0.68,57.80,'2023-02-04 16:36:53','',''),(5079,'1','302','1',1,'Retail Sale Id 4909',3599.04,0.00,0.00,4.89,415.65,'2023-02-04 17:02:58','',''),(5080,'1','302','1',1,'Retail Sale Id 4910',7360.00,0.00,0.00,10.00,850.00,'2023-02-04 17:07:29','',''),(5081,'1','302','1',1,'Retail Sale Id 4911',4496.96,0.00,0.00,6.11,519.35,'2023-02-04 17:10:16','',''),(5082,'1','302','1',1,'Retail Sale Id 4912',2303.68,0.00,0.00,3.13,266.05,'2023-02-04 17:12:45','',''),(5083,'1','302','1',1,'Retail Sale Id 4913',2303.68,0.00,0.00,3.13,266.05,'2023-02-04 17:13:45','',''),(5084,'1','302','1',1,'Retail Sale Id 4914',4416.00,0.00,0.00,6.00,510.00,'2023-02-04 17:40:09','',''),(5085,'1','302','1',1,'Retail Sale Id 4915',4416.00,0.00,0.00,6.00,510.00,'2023-02-04 17:44:39','',''),(5086,'1','302','1',1,'Retail Sale Id 4916',2208.00,0.00,0.00,3.00,255.00,'2023-02-04 17:45:54','',''),(5087,'1','302','1',1,'Retail Sale Id 4917',4298.24,0.00,0.00,5.84,496.40,'2023-02-04 17:49:36','',''),(5088,'1','302','1',1,'Retail Sale Id 4918',3503.36,0.00,0.00,4.76,404.60,'2023-02-04 17:50:49','',''),(5089,'1','302','1',1,'Retail Sale Id 4920',7100.00,0.00,0.00,10.00,590.00,'2023-02-04 17:56:17','',''),(5090,'1','302','1',1,'Retail Sale Id 4921',2001.92,0.00,0.00,2.72,231.20,'2023-02-04 17:56:59','',''),(5091,'1','302','1',1,'Retail Sale Id 4922',2200.64,0.00,0.00,2.99,254.15,'2023-02-04 17:58:07','',''),(5092,'1','302','1',1,'Retail Sale Id 4923',2944.00,0.00,0.00,4.00,340.00,'2023-02-04 18:11:57','',''),(5093,'1','302','1',1,'Retail Sale Id 4923',3680.00,0.00,0.00,5.00,425.00,'2023-02-04 18:11:57','',''),(5094,'1','302','1',1,'Retail Sale Id 4923',4416.00,0.00,0.00,6.00,510.00,'2023-02-04 18:11:57','',''),(5095,'1','302','1',1,'Retail Sale Id 4923',7360.00,0.00,0.00,10.00,850.00,'2023-02-04 18:11:57','',''),(5096,'1','302','1',1,'Retail Sale Id 4924',2208.00,0.00,0.00,3.00,255.00,'2023-02-04 18:13:33','',''),(5097,'1','302','1',1,'Retail Sale Id 4924',9200.00,0.00,0.00,12.50,1062.50,'2023-02-04 18:13:33','',''),(5098,'1','302','1',1,'Retail Sale Id 4925',4416.00,0.00,0.00,6.00,510.00,'2023-02-04 18:24:14','',''),(5099,'1','302','1',1,'Retail Sale Id 4926',3680.00,0.00,0.00,5.00,425.00,'2023-02-04 18:38:51','',''),(5100,'1','302','1',1,'Retail Sale Id 4927',44.16,0.00,0.00,0.06,5.10,'2023-02-04 19:23:51','',''),(5101,'1','302','1',1,'Retail Sale Id 4928',3996.48,0.00,0.00,5.43,461.55,'2023-02-05 08:21:23','',''),(5102,'1','302','1',1,'Retail Sale Id 4929',5152.00,0.00,0.00,7.00,595.00,'2023-02-05 08:27:49','',''),(5103,'1','302','1',1,'Retail Sale Id 4930',2252.16,0.00,0.00,3.06,260.10,'2023-02-05 08:31:31','',''),(5104,'1','302','1',1,'Retail Sale Id 4931',2208.00,0.00,0.00,3.00,255.00,'2023-02-05 08:33:55','',''),(5105,'1','302','1',1,'Retail Sale Id 4932',3680.00,0.00,0.00,5.00,425.00,'2023-02-05 08:38:08','',''),(5106,'1','302','1',1,'Retail Sale Id 4933',1000.96,0.00,0.00,1.36,115.60,'2023-02-05 08:38:55','',''),(5107,'1','302','1',1,'Retail Sale Id 4934',20615.36,0.00,0.00,28.01,2380.85,'2023-02-05 08:43:54','',''),(5108,'1','302','1',1,'Retail Sale Id 4935',3680.00,0.00,0.00,5.00,425.00,'2023-02-05 08:48:22','',''),(5109,'1','302','1',1,'Retail Sale Id 4936',1199.68,0.00,0.00,1.63,138.55,'2023-02-05 08:49:35','',''),(5110,'1','302','1',1,'Retail Sale Id 4937',2502.40,0.00,0.00,3.40,289.00,'2023-02-05 08:54:34','',''),(5111,'1','302','1',1,'Retail Sale Id 4938',802.24,0.00,0.00,1.09,92.65,'2023-02-05 08:55:24','',''),(5112,'1','302','1',1,'Retail Sale Id 4939',3002.88,0.00,0.00,4.08,346.80,'2023-02-05 08:58:33','',''),(5113,'1','302','1',1,'Retail Sale Id 4940',3002.88,0.00,0.00,4.08,346.80,'2023-02-05 09:00:26','',''),(5114,'1','302','1',1,'Retail Sale Id 4941',46150.00,0.00,0.00,65.00,3835.00,'2023-02-05 09:04:14','',''),(5115,'1','302','1',1,'Retail Sale Id 4942',2200.64,0.00,0.00,2.99,254.15,'2023-02-05 09:10:48','',''),(5116,'1','302','1',1,'Retail Sale Id 4943',4496.96,0.00,0.00,6.11,519.35,'2023-02-05 09:13:40','',''),(5117,'1','302','1',1,'Retail Sale Id 4944',2208.00,0.00,0.00,3.00,255.00,'2023-02-05 09:23:14','',''),(5118,'1','302','1',1,'Retail Sale Id 4945',2208.00,0.00,0.00,3.00,255.00,'2023-02-05 09:27:30','',''),(5119,'1','302','1',1,'Retail Sale Id 4947',1000.96,0.00,0.00,1.36,115.60,'2023-02-05 09:34:05','',''),(5120,'1','302','1',1,'Retail Sale Id 4948',2944.00,0.00,0.00,4.00,340.00,'2023-02-05 09:38:00','',''),(5121,'1','302','1',1,'Retail Sale Id 4949',2208.00,0.00,0.00,3.00,255.00,'2023-02-05 09:47:30','',''),(5122,'1','302','1',1,'Retail Sale Id 4950',36800.00,0.00,0.00,50.00,4250.00,'2023-02-05 09:50:00','',''),(5123,'1','302','1',1,'Retail Sale Id 4951',2208.00,0.00,0.00,3.00,255.00,'2023-02-05 10:02:38','',''),(5124,'1','302','1',1,'Retail Sale Id 4952',1000.96,0.00,0.00,1.36,115.60,'2023-02-05 10:04:53','',''),(5125,'1','302','1',1,'Retail Sale Id 4953',6624.00,0.00,0.00,9.00,765.00,'2023-02-05 10:06:31','',''),(5126,'1','302','1',1,'Retail Sale Id 4954',4416.00,0.00,0.00,6.00,510.00,'2023-02-05 10:14:50','',''),(5127,'1','302','1',1,'Retail Sale Id 4955',1000.96,0.00,0.00,1.36,115.60,'2023-02-05 10:26:44','',''),(5128,'1','302','1',1,'Retail Sale Id 4956',9200.00,0.00,0.00,12.50,1062.50,'2023-02-05 10:28:00','',''),(5129,'1','302','1',1,'Retail Sale Id 4961',1472.00,0.00,0.00,2.00,170.00,'2023-02-05 10:34:43','',''),(5130,'1','302','1',1,'Retail Sale Id 4962',9200.00,0.00,0.00,12.50,1062.50,'2023-02-05 10:37:32','',''),(5131,'1','302','1',1,'Retail Sale Id 4963',2944.00,0.00,0.00,4.00,340.00,'2023-02-05 10:38:58','',''),(5132,'1','302','1',1,'Retail Sale Id 4964',500.48,0.00,0.00,0.68,57.80,'2023-02-05 10:47:29','',''),(5133,'1','302','1',1,'Retail Sale Id 4965',4416.00,0.00,0.00,6.00,510.00,'2023-02-05 10:55:18','',''),(5134,'1','302','1',1,'Retail Sale Id 4966',19170.00,0.00,0.00,27.00,1593.00,'2023-02-05 10:57:54','',''),(5135,'1','302','1',1,'Retail Sale Id 4967',9200.00,0.00,0.00,12.50,1062.50,'2023-02-05 11:07:12','',''),(5136,'1','302','1',1,'Retail Sale Id 4968',1000.96,0.00,0.00,1.36,115.60,'2023-02-05 11:08:16','',''),(5137,'1','302','1',1,'Retail Sale Id 4969',2208.00,0.00,0.00,3.00,255.00,'2023-02-05 11:15:44','',''),(5138,'1','302','1',1,'Retail Sale Id 4970',3680.00,0.00,0.00,5.00,425.00,'2023-02-05 11:21:44','',''),(5139,'1','302','1',1,'Retail Sale Id 4972',448.96,0.00,0.00,0.61,51.85,'2023-02-05 11:23:40','',''),(5140,'1','302','1',1,'Retail Sale Id 4973',2001.92,0.00,0.00,2.72,231.20,'2023-02-05 11:36:56','',''),(5141,'1','302','1',1,'Retail Sale Id 4973',2001.92,0.00,0.00,2.72,231.20,'2023-02-05 11:36:56','',''),(5142,'1','302','1',1,'Retail Sale Id 4975',3702.08,0.00,0.00,5.03,427.55,'2023-02-05 11:45:30','',''),(5143,'1','302','1',1,'Retail Sale Id 4976',4416.00,0.00,0.00,6.00,510.00,'2023-02-05 11:46:44','',''),(5144,'1','302','1',1,'Retail Sale Id 4977',8500.80,0.00,0.00,11.55,981.75,'2023-02-05 11:48:45','',''),(5145,'1','302','1',1,'Retail Sale Id 4978',51475.00,0.00,0.00,72.50,4277.50,'2023-02-05 11:51:43','',''),(5146,'1','302','1',1,'Retail Sale Id 4980',2208.00,0.00,0.00,3.00,255.00,'2023-02-05 12:02:35','',''),(5147,'1','302','1',1,'Retail Sale Id 4981',2502.40,0.00,0.00,3.40,289.00,'2023-02-05 12:05:55','',''),(5148,'1','302','1',1,'Retail Sale Id 4982',1501.44,0.00,0.00,2.04,173.40,'2023-02-05 12:08:28','',''),(5149,'1','302','1',1,'Retail Sale Id 4984',500.48,0.00,0.00,0.68,57.80,'2023-02-05 12:17:56','',''),(5150,'1','302','1',1,'Retail Sale Id 4985',4416.00,0.00,0.00,6.00,510.00,'2023-02-05 12:19:48','',''),(5151,'1','302','1',1,'Retail Sale Id 4986',2208.00,0.00,0.00,3.00,255.00,'2023-02-05 12:20:42','',''),(5152,'1','302','1',1,'Retail Sale Id 4987',5998.40,0.00,0.00,8.15,692.75,'2023-02-05 12:22:13','',''),(5153,'1','302','1',1,'Retail Sale Id 4988',2944.00,0.00,0.00,4.00,340.00,'2023-02-05 12:26:51','',''),(5154,'1','302','1',1,'Retail Sale Id 4989',2208.00,0.00,0.00,3.00,255.00,'2023-02-05 12:27:52','',''),(5155,'1','302','1',1,'Retail Sale Id 4990',1700.16,0.00,0.00,2.31,196.35,'2023-02-05 12:28:58','',''),(5156,'1','302','1',1,'Retail Sale Id 4991',5998.40,0.00,0.00,8.15,692.75,'2023-02-05 12:31:01','',''),(5157,'1','302','1',1,'Retail Sale Id 4992',2001.92,0.00,0.00,2.72,231.20,'2023-02-05 12:35:54','',''),(5158,'1','302','1',1,'Retail Sale Id 4993',802.24,0.00,0.00,1.09,92.65,'2023-02-05 12:37:40','',''),(5159,'1','302','1',1,'Retail Sale Id 4994',4416.00,0.00,0.00,6.00,510.00,'2023-02-05 12:43:14','',''),(5160,'1','302','1',1,'Retail Sale Id 4995',3002.88,0.00,0.00,4.08,346.80,'2023-02-05 12:52:42','',''),(5161,'1','302','1',1,'Retail Sale Id 4996',2001.92,0.00,0.00,2.72,231.20,'2023-02-05 13:02:48','',''),(5162,'1','302','1',1,'Retail Sale Id 4997',4401.28,0.00,0.00,5.98,508.30,'2023-02-05 13:05:17','',''),(5163,'1','302','1',1,'Retail Sale Id 4998',2200.64,0.00,0.00,2.99,254.15,'2023-02-05 13:06:36','',''),(5164,'1','302','1',1,'Retail Sale Id 4999',2001.92,0.00,0.00,2.72,231.20,'2023-02-05 13:11:36','',''),(5165,'1','302','1',1,'Retail Sale Id 5000',106500.00,0.00,0.00,150.00,8850.00,'2023-02-05 13:31:32','',''),(5166,'1','302','1',1,'Retail Sale Id 5001',3002.88,0.00,0.00,4.08,346.80,'2023-02-05 13:34:37','',''),(5167,'1','302','1',1,'Retail Sale Id 5002',2252.16,0.00,0.00,3.06,260.10,'2023-02-05 13:39:58','',''),(5168,'1','302','1',1,'Retail Sale Id 5003',10650.00,0.00,0.00,15.00,885.00,'2023-02-05 13:41:58','',''),(5169,'1','302','1',1,'Retail Sale Id 5004',1420.48,0.00,0.00,1.93,164.05,'2023-02-05 13:43:52','',''),(5170,'1','302','1',1,'Retail Sale Id 5005',2130.00,0.00,0.00,3.00,177.00,'2023-02-05 13:45:47','',''),(5171,'1','302','1',1,'Retail Sale Id 5006',3002.88,0.00,0.00,4.08,346.80,'2023-02-05 13:49:44','',''),(5172,'1','302','1',1,'Retail Sale Id 5007',2208.00,0.00,0.00,3.00,255.00,'2023-02-05 14:06:49','',''),(5173,'1','302','1',1,'Retail Sale Id 5008',3680.00,0.00,0.00,5.00,425.00,'2023-02-05 14:12:02','',''),(5174,'1','302','1',1,'Retail Sale Id 5009',9200.00,0.00,0.00,12.50,1062.50,'2023-02-05 14:14:14','',''),(5175,'1','302','1',1,'Retail Sale Id 5010',2951.36,0.00,0.00,4.01,340.85,'2023-02-05 14:23:39','',''),(5176,'1','302','1',1,'Retail Sale Id 5011',1000.96,0.00,0.00,1.36,115.60,'2023-02-05 14:24:47','',''),(5177,'1','302','1',1,'Retail Sale Id 5012',2796.80,0.00,0.00,3.80,323.00,'2023-02-05 14:30:32','',''),(5178,'1','302','1',1,'Retail Sale Id 5013',2208.00,0.00,0.00,3.00,255.00,'2023-02-05 14:31:54','',''),(5179,'1','302','1',1,'Retail Sale Id 5014',9200.00,0.00,0.00,12.50,1062.50,'2023-02-05 14:40:20','',''),(5180,'1','302','1',1,'Retail Sale Id 5015',9200.00,0.00,0.00,12.50,1062.50,'2023-02-05 14:45:03','',''),(5181,'1','302','1',1,'Retail Sale Id 5016',1000.96,0.00,0.00,1.36,115.60,'2023-02-05 14:46:19','',''),(5182,'1','302','1',1,'Retail Sale Id 5017',9200.00,0.00,0.00,12.50,1062.50,'2023-02-05 15:06:20','',''),(5183,'1','302','1',1,'Retail Sale Id 5018',4997.44,0.00,0.00,6.79,577.15,'2023-02-05 15:08:54','',''),(5184,'1','302','1',1,'Retail Sale Id 5019',2178.56,0.00,0.00,2.96,251.60,'2023-02-05 15:10:47','',''),(5185,'1','302','1',1,'Retail Sale Id 5020',9200.00,0.00,0.00,12.50,1062.50,'2023-02-05 15:14:20','',''),(5186,'1','302','1',1,'Retail Sale Id 5021',2001.92,0.00,0.00,2.72,231.20,'2023-02-05 15:16:57','',''),(5187,'1','302','1',1,'Retail Sale Id 5022',2502.40,0.00,0.00,3.40,289.00,'2023-02-05 15:20:25','',''),(5188,'1','302','1',1,'Retail Sale Id 5023',2208.00,0.00,0.00,3.00,255.00,'2023-02-05 15:22:38','',''),(5189,'1','302','1',1,'Retail Sale Id 5024',9200.00,0.00,0.00,12.50,1062.50,'2023-02-05 15:25:05','',''),(5190,'1','302','1',1,'Retail Sale Id 5025',11040.00,0.00,0.00,15.00,1275.00,'2023-02-05 15:27:44','',''),(5191,'1','302','1',1,'Retail Sale Id 5026',2001.92,0.00,0.00,2.72,231.20,'2023-02-05 15:32:04','',''),(5192,'1','302','1',1,'Retail Sale Id 5027',9200.00,0.00,0.00,12.50,1062.50,'2023-02-05 15:37:26','',''),(5193,'1','302','1',1,'Retail Sale Id 5028',3400.32,0.00,0.00,4.62,392.70,'2023-02-05 15:40:32','',''),(5194,'1','302','1',1,'Retail Sale Id 5028',3400.32,0.00,0.00,4.62,392.70,'2023-02-05 15:40:32','',''),(5195,'1','302','1',1,'Retail Sale Id 5029',3002.88,0.00,0.00,4.08,346.80,'2023-02-05 15:41:58','',''),(5196,'1','302','1',1,'Retail Sale Id 5030',4416.00,0.00,0.00,6.00,510.00,'2023-02-05 15:43:50','',''),(5197,'1','302','1',1,'Retail Sale Id 5031',1501.44,0.00,0.00,2.04,173.40,'2023-02-05 15:46:04','',''),(5198,'1','302','1',1,'Retail Sale Id 5032',2208.00,0.00,0.00,3.00,255.00,'2023-02-05 15:51:16','',''),(5199,'1','302','1',1,'Retail Sale Id 5032',4416.00,0.00,0.00,6.00,510.00,'2023-02-05 15:51:16','',''),(5200,'1','302','1',1,'Retail Sale Id 5032',4416.00,0.00,0.00,6.00,510.00,'2023-02-05 15:51:16','',''),(5201,'1','302','1',1,'Retail Sale Id 5032',9200.00,0.00,0.00,12.50,1062.50,'2023-02-05 15:51:16','',''),(5202,'1','302','1',1,'Retail Sale Id 5033',3680.00,0.00,0.00,5.00,425.00,'2023-02-05 15:54:17','',''),(5203,'1','302','1',1,'Retail Sale Id 5034',8520.00,0.00,0.00,12.00,708.00,'2023-02-05 16:07:45','',''),(5204,'1','302','1',1,'Retail Sale Id 5035',4496.96,0.00,0.00,6.11,519.35,'2023-02-05 16:16:15','',''),(5205,'1','302','1',1,'Retail Sale Id 5036',4452.80,0.00,0.00,6.05,514.25,'2023-02-05 16:24:28','',''),(5206,'1','302','1',1,'Retail Sale Id 5037',4416.00,0.00,0.00,6.00,510.00,'2023-02-05 16:26:51','',''),(5207,'1','302','1',1,'Retail Sale Id 5038',9200.00,0.00,0.00,12.50,1062.50,'2023-02-05 16:28:04','',''),(5208,'1','302','1',1,'Retail Sale Id 5039',8096.00,0.00,0.00,11.00,935.00,'2023-02-05 16:29:58','',''),(5209,'1','302','1',1,'Retail Sale Id 5040',3002.88,0.00,0.00,4.08,346.80,'2023-02-05 16:31:59','',''),(5210,'1','302','1',1,'Retail Sale Id 5041',3680.00,0.00,0.00,5.00,425.00,'2023-02-05 16:36:33','',''),(5211,'1','302','1',1,'Retail Sale Id 5042',3002.88,0.00,0.00,4.08,346.80,'2023-02-05 16:39:58','',''),(5212,'1','302','1',1,'Retail Sale Id 5044',4416.00,0.00,0.00,6.00,510.00,'2023-02-05 16:45:09','',''),(5213,'1','302','1',1,'Retail Sale Id 5045',2001.92,0.00,0.00,2.72,231.20,'2023-02-05 16:53:16','',''),(5214,'1','302','1',1,'Retail Sale Id 5046',4416.00,0.00,0.00,6.00,510.00,'2023-02-05 16:54:57','',''),(5215,'1','302','1',1,'Retail Sale Id 5047',3680.00,0.00,0.00,5.00,425.00,'2023-02-05 17:09:35','',''),(5216,'1','302','1',1,'Retail Sale Id 5048',1000.96,0.00,0.00,1.36,115.60,'2023-02-05 17:14:32','',''),(5217,'1','302','1',1,'Retail Sale Id 5049',4416.00,0.00,0.00,6.00,510.00,'2023-02-05 17:18:10','',''),(5218,'1','302','1',1,'Retail Sale Id 5050',1501.44,0.00,0.00,2.04,173.40,'2023-02-05 17:21:15','',''),(5219,'1','302','1',1,'Retail Sale Id 5051',1000.96,0.00,0.00,1.36,115.60,'2023-02-05 17:26:02','',''),(5220,'1','302','1',1,'Retail Sale Id 5052',4416.00,0.00,0.00,6.00,510.00,'2023-02-05 17:28:30','',''),(5221,'1','302','1',1,'Retail Sale Id 5053',2001.92,0.00,0.00,2.72,231.20,'2023-02-05 17:29:47','',''),(5222,'1','302','1',1,'Retail Sale Id 5054',1501.44,0.00,0.00,2.04,173.40,'2023-02-05 17:31:47','',''),(5223,'1','302','1',1,'Retail Sale Id 5055',17750.00,0.00,0.00,25.00,1475.00,'2023-02-05 17:35:30','',''),(5224,'1','302','1',1,'Retail Sale Id 5056',4416.00,0.00,0.00,6.00,510.00,'2023-02-05 17:41:31','',''),(5225,'1','302','1',1,'Retail Sale Id 5057',750.72,0.00,0.00,1.02,86.70,'2023-02-05 17:42:40','',''),(5226,'1','302','1',1,'Retail Sale Id 5058',9001.28,0.00,0.00,12.23,1039.55,'2023-02-05 17:48:42','',''),(5227,'1','302','1',1,'Retail Sale Id 5059',1472.00,0.00,0.00,2.00,170.00,'2023-02-05 17:49:58','',''),(5228,'1','302','1',1,'Retail Sale Id 5060',2208.00,0.00,0.00,3.00,255.00,'2023-02-05 17:51:51','',''),(5229,'1','302','1',1,'Retail Sale Id 5061',2001.92,0.00,0.00,2.72,231.20,'2023-02-05 18:02:36','',''),(5230,'1','302','1',1,'Retail Sale Id 5062',3002.88,0.00,0.00,4.08,346.80,'2023-02-05 18:03:49','',''),(5231,'1','302','1',1,'Retail Sale Id 5063',2208.00,0.00,0.00,3.00,255.00,'2023-02-05 18:06:16','',''),(5232,'1','302','1',1,'Retail Sale Id 5064',9200.00,0.00,0.00,12.50,1062.50,'2023-02-05 18:13:33','',''),(5233,'1','302','1',1,'Retail Sale Id 5065',4416.00,0.00,0.00,6.00,510.00,'2023-02-05 18:23:47','',''),(5234,'1','302','1',1,'Retail Sale Id 5066',4496.96,0.00,0.00,6.11,519.35,'2023-02-05 18:25:36','',''),(5235,'1','302','1',1,'Retail Sale Id 5067',1567.68,0.00,0.00,2.13,181.05,'2023-02-05 22:52:25','',''),(5236,'1','302','1',1,'Retail Sale Id 5068',2001.92,0.00,0.00,2.72,231.20,'2023-02-06 08:09:02','',''),(5237,'1','302','1',1,'Retail Sale Id 5069',9200.00,0.00,0.00,12.50,1062.50,'2023-02-06 08:11:07','',''),(5238,'1','302','1',1,'Retail Sale Id 5070',9200.00,0.00,0.00,12.50,1062.50,'2023-02-06 08:13:14','',''),(5239,'1','302','1',1,'Retail Sale Id 5071',2208.00,0.00,0.00,3.00,255.00,'2023-02-06 08:23:27','',''),(5240,'1','302','1',1,'Retail Sale Id 5072',7360.00,0.00,0.00,10.00,850.00,'2023-02-06 08:28:09','',''),(5241,'1','302','1',1,'Retail Sale Id 5074',3996.48,0.00,0.00,5.43,461.55,'2023-02-06 08:48:47','',''),(5242,'1','302','1',1,'Retail Sale Id 5075',1000.96,0.00,0.00,1.36,115.60,'2023-02-06 08:51:47','',''),(5243,'1','302','1',1,'Retail Sale Id 5075',4496.96,0.00,0.00,6.11,519.35,'2023-02-06 08:51:47','',''),(5244,'1','302','1',1,'Retail Sale Id 5076',2208.00,0.00,0.00,3.00,255.00,'2023-02-06 08:58:42','',''),(5245,'1','302','1',1,'Retail Sale Id 5077',4416.00,0.00,0.00,6.00,510.00,'2023-02-06 09:00:50','',''),(5246,'1','302','1',1,'Retail Sale Id 5078',2001.92,0.00,0.00,2.72,231.20,'2023-02-06 09:01:39','',''),(5247,'1','302','1',1,'Retail Sale Id 5079',3002.88,0.00,0.00,4.08,346.80,'2023-02-06 09:02:20','',''),(5248,'1','302','1',1,'Retail Sale Id 5080',4416.00,0.00,0.00,6.00,510.00,'2023-02-06 09:04:07','',''),(5249,'1','302','1',1,'Retail Sale Id 5081',4416.00,0.00,0.00,6.00,510.00,'2023-02-06 09:07:39','',''),(5250,'1','302','1',1,'Retail Sale Id 5082',3680.00,0.00,0.00,5.00,425.00,'2023-02-06 09:09:02','',''),(5251,'1','302','1',1,'Retail Sale Id 5083',4496.96,0.00,0.00,6.11,519.35,'2023-02-06 09:13:26','',''),(5252,'1','302','1',1,'Retail Sale Id 5084',35500.00,0.00,0.00,50.00,2950.00,'2023-02-06 09:27:36','',''),(5253,'1','302','1',1,'Retail Sale Id 5085',5152.00,0.00,0.00,7.00,595.00,'2023-02-06 09:28:58','',''),(5254,'1','302','1',1,'Retail Sale Id 5086',4416.00,0.00,0.00,6.00,510.00,'2023-02-06 09:33:30','',''),(5255,'1','302','1',1,'Retail Sale Id 5087',97980.00,0.00,0.00,138.00,8142.00,'2023-02-06 09:43:25','',''),(5256,'1','302','1',1,'Retail Sale Id 5088',2001.92,0.00,0.00,2.72,231.20,'2023-02-06 10:04:09','',''),(5257,'1','302','1',1,'Retail Sale Id 5088',8096.00,0.00,0.00,11.00,935.00,'2023-02-06 10:04:09','',''),(5258,'1','302','1',1,'Retail Sale Id 5089',3680.00,0.00,0.00,5.00,425.00,'2023-02-06 10:05:55','',''),(5259,'1','302','1',1,'Retail Sale Id 5090',9200.00,0.00,0.00,12.50,1062.50,'2023-02-06 10:11:16','',''),(5260,'1','302','1',1,'Retail Sale Id 5091',2208.00,0.00,0.00,3.00,255.00,'2023-02-06 10:18:45','',''),(5261,'1','302','1',1,'Retail Sale Id 5092',2208.00,0.00,0.00,3.00,255.00,'2023-02-06 10:19:48','',''),(5262,'1','302','1',1,'Retail Sale Id 5093',3680.00,0.00,0.00,5.00,425.00,'2023-02-06 10:29:25','',''),(5263,'1','302','1',1,'Retail Sale Id 5094',4416.00,0.00,0.00,6.00,510.00,'2023-02-06 10:33:01','',''),(5264,'1','302','1',1,'Retail Sale Id 5099',3680.00,0.00,0.00,5.00,425.00,'2023-02-06 10:49:34','',''),(5265,'1','302','1',1,'Retail Sale Id 5100',2001.92,0.00,0.00,2.72,231.20,'2023-02-06 10:50:29','',''),(5266,'1','302','1',1,'Retail Sale Id 5103',3002.88,0.00,0.00,4.08,346.80,'2023-02-06 10:53:44','',''),(5267,'1','302','1',1,'Retail Sale Id 5105',117.76,0.00,0.00,0.16,13.60,'2023-02-06 18:38:44','',''),(5268,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,81147.15,124.65,0.00,0.00,'2023-02-06 22:14:13','',''),(5269,'1','302',NULL,1,'Reception corrector for bridging 33',0.00,0.00,0.00,124.65,0.00,'2023-02-06 22:15:26','',''),(5270,'1','302','1',1,'Received from bridging 33',0.00,0.00,124.65,0.00,0.00,'2023-02-06 22:15:26','',''),(5271,'1','302','1',1,'Retail Sale Id 5106',63597.76,0.00,0.00,86.41,7344.85,'2023-02-06 22:29:17','',''),(5272,'1','302','1',1,'Retail Sale Id 5109',27150.40,0.00,0.00,38.24,2256.16,'2023-02-06 22:40:39','',''),(5273,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3515400.00,5400.00,0.00,0.00,'2023-02-06 22:44:58','',''),(5274,'1','302',NULL,1,'Reception corrector for bridging 34',0.00,0.00,0.00,5400.00,0.00,'2023-02-06 22:46:52','',''),(5275,'1','302','1',1,'Received from bridging 34',0.00,0.00,5400.00,0.00,0.00,'2023-02-06 22:46:52','',''),(5276,'1','302','1',1,'Retail Sale Id 5110',35500.00,0.00,0.00,50.00,2950.00,'2023-02-06 22:48:57','',''),(5277,'1','302','1',1,'Retail Sale Id 5111',280548.48,0.00,0.00,381.18,32400.30,'2023-02-06 22:49:44','',''),(5278,'1','302','1',1,'Retail Sale Id 5112',35500.00,0.00,0.00,50.00,2950.00,'2023-02-06 22:50:32','',''),(5279,'1','302','1',1,'Retail Sale Id 5113',20235.00,0.00,0.00,28.50,1681.50,'2023-02-06 22:51:50','',''),(5280,'1','302','1',1,'Retail Sale Id 5114',4496.96,0.00,0.00,6.11,519.35,'2023-02-07 07:59:56','',''),(5281,'1','302','1',1,'Retail Sale Id 5115',1472.00,0.00,0.00,2.00,170.00,'2023-02-07 08:01:19','',''),(5282,'1','302','1',1,'Retail Sale Id 5116',3002.88,0.00,0.00,4.08,346.80,'2023-02-07 08:13:52','',''),(5283,'1','302','1',1,'Retail Sale Id 5117',750.72,0.00,0.00,1.02,86.70,'2023-02-07 08:22:51','',''),(5284,'1','302','1',1,'Retail Sale Id 5118',35500.00,0.00,0.00,50.00,2950.00,'2023-02-07 08:34:51','',''),(5285,'1','302','1',1,'Retail Sale Id 5119',4416.00,0.00,0.00,6.00,510.00,'2023-02-07 08:36:50','',''),(5286,'1','302','1',1,'Retail Sale Id 5120',3002.88,0.00,0.00,4.08,346.80,'2023-02-07 08:38:16','',''),(5287,'1','302','1',1,'Retail Sale Id 5121',3680.00,0.00,0.00,5.00,425.00,'2023-02-07 08:40:05','',''),(5288,'1','302','1',1,'Retail Sale Id 5122',3680.00,0.00,0.00,5.00,425.00,'2023-02-07 08:52:17','',''),(5289,'1','302','1',1,'Retail Sale Id 5123',3002.88,0.00,0.00,4.08,346.80,'2023-02-07 08:56:08','',''),(5290,'1','302','1',1,'Retail Sale Id 5124',1000.96,0.00,0.00,1.36,115.60,'2023-02-07 09:01:59','',''),(5291,'1','302','1',1,'Retail Sale Id 5125',2001.92,0.00,0.00,2.72,231.20,'2023-02-07 09:03:51','',''),(5292,'1','302','1',1,'Retail Sale Id 5126',2208.00,0.00,0.00,3.00,255.00,'2023-02-07 09:05:56','',''),(5293,'1','302','1',1,'Retail Sale Id 5127',4496.96,0.00,0.00,6.11,519.35,'2023-02-07 09:21:16','',''),(5294,'1','302','1',1,'Retail Sale Id 5128',4416.00,0.00,0.00,6.00,510.00,'2023-02-07 09:27:11','',''),(5295,'1','302','1',1,'Retail Sale Id 5129',1000.96,0.00,0.00,1.36,115.60,'2023-02-07 09:32:10','',''),(5296,'1','302','1',1,'Retail Sale Id 5130',1000.96,0.00,0.00,1.36,115.60,'2023-02-07 09:35:38','',''),(5297,'1','302','1',1,'Retail Sale Id 5131',1000.96,0.00,0.00,1.36,115.60,'2023-02-07 09:38:06','',''),(5298,'1','302','1',1,'Retail Sale Id 5132',1501.44,0.00,0.00,2.04,173.40,'2023-02-07 09:41:00','',''),(5299,'1','302','1',1,'Retail Sale Id 5133',2208.00,0.00,0.00,3.00,255.00,'2023-02-07 09:46:35','',''),(5300,'1','302','1',1,'Retail Sale Id 5134',2208.00,0.00,0.00,3.00,255.00,'2023-02-07 09:47:26','',''),(5301,'1','302','1',1,'Retail Sale Id 5135',736.00,0.00,0.00,1.00,85.00,'2023-02-07 09:52:11','',''),(5302,'1','302','1',1,'Retail Sale Id 5135',9200.00,0.00,0.00,12.50,1062.50,'2023-02-07 09:52:11','',''),(5303,'1','302','1',1,'Retail Sale Id 5137',4496.96,0.00,0.00,6.11,519.35,'2023-02-07 09:57:34','',''),(5304,'1','302','1',1,'Retail Sale Id 5138',9200.00,0.00,0.00,12.50,1062.50,'2023-02-07 10:03:45','',''),(5305,'1','302','1',1,'Retail Sale Id 5139',3002.88,0.00,0.00,4.08,346.80,'2023-02-07 10:05:30','',''),(5306,'1','302','1',1,'Retail Sale Id 5140',4401.28,0.00,0.00,5.98,508.30,'2023-02-07 10:06:51','',''),(5307,'1','302','1',1,'Retail Sale Id 5141',4416.00,0.00,0.00,6.00,510.00,'2023-02-07 10:10:23','',''),(5308,'1','302','1',1,'Retail Sale Id 5142',500.48,0.00,0.00,0.68,57.80,'2023-02-07 10:11:59','',''),(5309,'1','302','1',1,'Retail Sale Id 5143',5152.00,0.00,0.00,7.00,595.00,'2023-02-07 10:15:03','',''),(5310,'1','302','1',1,'Retail Sale Id 5144',2001.92,0.00,0.00,2.72,231.20,'2023-02-07 10:17:01','',''),(5311,'1','302','1',1,'Retail Sale Id 5145',4416.00,0.00,0.00,6.00,510.00,'2023-02-07 10:24:28','',''),(5312,'1','302','1',1,'Retail Sale Id 5146',4416.00,0.00,0.00,6.00,510.00,'2023-02-07 10:33:05','',''),(5313,'1','302','1',1,'Retail Sale Id 5147',2208.00,0.00,0.00,3.00,255.00,'2023-02-07 10:40:05','',''),(5314,'1','302','1',1,'Retail Sale Id 5148',2208.00,0.00,0.00,3.00,255.00,'2023-02-07 10:48:51','',''),(5315,'1','302','1',1,'Retail Sale Id 5149',2796.80,0.00,0.00,3.80,323.00,'2023-02-07 10:50:12','',''),(5316,'1','302','1',1,'Retail Sale Id 5150',1943.04,0.00,0.00,2.64,224.40,'2023-02-07 10:53:25','',''),(5317,'1','302','1',1,'Retail Sale Id 5151',4416.00,0.00,0.00,6.00,510.00,'2023-02-07 10:57:44','',''),(5318,'1','302','1',1,'Retail Sale Id 5151',9200.00,0.00,0.00,12.50,1062.50,'2023-02-07 10:57:44','',''),(5319,'1','302','1',1,'Retail Sale Id 5152',1472.00,0.00,0.00,2.00,170.00,'2023-02-07 11:07:32','',''),(5320,'1','302','1',1,'Retail Sale Id 5152',2208.00,0.00,0.00,3.00,255.00,'2023-02-07 11:07:32','',''),(5321,'1','302','1',1,'Retail Sale Id 5152',4416.00,0.00,0.00,6.00,510.00,'2023-02-07 11:07:32','',''),(5322,'1','302','1',1,'Retail Sale Id 5152',4416.00,0.00,0.00,6.00,510.00,'2023-02-07 11:07:32','',''),(5323,'1','302','1',1,'Retail Sale Id 5152',4416.00,0.00,0.00,6.00,510.00,'2023-02-07 11:07:32','',''),(5324,'1','302','1',1,'Retail Sale Id 5152',4416.00,0.00,0.00,6.00,510.00,'2023-02-07 11:07:32','',''),(5325,'1','302','1',1,'Retail Sale Id 5152',36800.00,0.00,0.00,50.00,4250.00,'2023-02-07 11:07:32','',''),(5326,'1','302','1',1,'Retail Sale Id 5153',4416.00,0.00,0.00,6.00,510.00,'2023-02-07 11:09:36','',''),(5327,'1','302','1',1,'Retail Sale Id 5154',3996.48,0.00,0.00,5.43,461.55,'2023-02-07 11:16:49','',''),(5328,'1','302','1',1,'Retail Sale Id 5154',3996.48,0.00,0.00,5.43,461.55,'2023-02-07 11:16:49','',''),(5329,'1','302','1',1,'Retail Sale Id 5154',6999.36,0.00,0.00,9.51,808.35,'2023-02-07 11:16:49','',''),(5330,'1','302','1',1,'Retail Sale Id 5155',5152.00,0.00,0.00,7.00,595.00,'2023-02-07 11:31:45','',''),(5331,'1','302','1',1,'Retail Sale Id 5156',7360.00,0.00,0.00,10.00,850.00,'2023-02-07 11:33:04','',''),(5332,'1','302','1',1,'Retail Sale Id 5157',500.48,0.00,0.00,0.68,57.80,'2023-02-07 11:33:44','',''),(5333,'1','302','1',1,'Retail Sale Id 5158',3996.48,0.00,0.00,5.43,461.55,'2023-02-07 11:34:56','',''),(5334,'1','302','1',1,'Retail Sale Id 5158',3996.48,0.00,0.00,5.43,461.55,'2023-02-07 11:34:56','',''),(5335,'1','302','1',1,'Retail Sale Id 5159',4416.00,0.00,0.00,6.00,510.00,'2023-02-07 11:36:45','',''),(5336,'1','302','1',1,'Retail Sale Id 5160',7360.00,0.00,0.00,10.00,850.00,'2023-02-07 11:37:54','',''),(5337,'1','302','1',1,'Retail Sale Id 5161',3680.00,0.00,0.00,5.00,425.00,'2023-02-07 11:39:06','',''),(5338,'1','302','1',1,'Retail Sale Id 5162',4416.00,0.00,0.00,6.00,510.00,'2023-02-07 11:40:25','',''),(5339,'1','302','1',1,'Retail Sale Id 5163',9200.00,0.00,0.00,12.50,1062.50,'2023-02-07 11:49:51','',''),(5340,'1','302','1',1,'Retail Sale Id 5164',3996.48,0.00,0.00,5.43,461.55,'2023-02-07 11:57:20','',''),(5341,'1','302','1',1,'Retail Sale Id 5165',3680.00,0.00,0.00,5.00,425.00,'2023-02-07 12:09:51','',''),(5342,'1','302','1',1,'Retail Sale Id 5166',9200.00,0.00,0.00,12.50,1062.50,'2023-02-07 12:11:44','',''),(5343,'1','302','1',1,'Retail Sale Id 5166',9200.00,0.00,0.00,12.50,1062.50,'2023-02-07 12:11:44','',''),(5344,'1','302','1',1,'Retail Sale Id 5167',4416.00,0.00,0.00,6.00,510.00,'2023-02-07 12:14:05','',''),(5345,'1','302','1',1,'Retail Sale Id 5167',4416.00,0.00,0.00,6.00,510.00,'2023-02-07 12:14:05','',''),(5346,'1','302','1',1,'Retail Sale Id 5168',1000.96,0.00,0.00,1.36,115.60,'2023-02-07 12:15:21','',''),(5347,'1','302','1',1,'Retail Sale Id 5168',3996.48,0.00,0.00,5.43,461.55,'2023-02-07 12:15:21','',''),(5348,'1','302','1',1,'Retail Sale Id 5169',2944.00,0.00,0.00,4.00,340.00,'2023-02-07 12:16:28','',''),(5349,'1','302','1',1,'Retail Sale Id 5170',2208.00,0.00,0.00,3.00,255.00,'2023-02-07 12:17:34','',''),(5350,'1','302','1',1,'Retail Sale Id 5171',3002.88,0.00,0.00,4.08,346.80,'2023-02-07 12:19:07','',''),(5351,'1','302','1',1,'Retail Sale Id 5172',35500.00,0.00,0.00,50.00,2950.00,'2023-02-07 12:27:25','',''),(5352,'1','302','1',1,'Retail Sale Id 5173',9200.00,0.00,0.00,12.50,1062.50,'2023-02-07 12:29:12','',''),(5353,'1','302','1',1,'Retail Sale Id 5174',1000.96,0.00,0.00,1.36,115.60,'2023-02-07 12:30:20','',''),(5354,'1','302','1',1,'Retail Sale Id 5175',802.24,0.00,0.00,1.09,92.65,'2023-02-07 12:31:50','',''),(5355,'1','302','1',1,'Retail Sale Id 5176',1501.44,0.00,0.00,2.04,173.40,'2023-02-07 12:58:34','',''),(5356,'1','302','1',1,'Retail Sale Id 5178',4416.00,0.00,0.00,6.00,510.00,'2023-02-07 13:06:29','',''),(5357,'1','302','1',1,'Retail Sale Id 5179',17750.00,0.00,0.00,25.00,1475.00,'2023-02-07 13:08:34','',''),(5358,'1','302','1',1,'Retail Sale Id 5180',1000.96,0.00,0.00,1.36,115.60,'2023-02-07 13:10:14','',''),(5359,'1','302','1',1,'Retail Sale Id 5181',8520.00,0.00,0.00,12.00,708.00,'2023-02-07 13:12:07','',''),(5360,'1','302','1',1,'Retail Sale Id 5182',1501.44,0.00,0.00,2.04,173.40,'2023-02-07 13:13:09','',''),(5361,'1','302','1',1,'Retail Sale Id 5183',2208.00,0.00,0.00,3.00,255.00,'2023-02-07 13:18:17','',''),(5362,'1','302','1',1,'Retail Sale Id 5184',4416.00,0.00,0.00,6.00,510.00,'2023-02-07 13:19:44','',''),(5363,'1','302','1',1,'Retail Sale Id 5185',9200.00,0.00,0.00,12.50,1062.50,'2023-02-07 13:28:20','',''),(5364,'1','302','1',1,'Retail Sale Id 5186',4416.00,0.00,0.00,6.00,510.00,'2023-02-07 13:29:49','',''),(5365,'1','302','1',1,'Retail Sale Id 5187',9200.00,0.00,0.00,12.50,1062.50,'2023-02-07 13:36:38','',''),(5366,'1','302','1',1,'Retail Sale Id 5188',10650.00,0.00,0.00,15.00,885.00,'2023-02-07 13:42:09','',''),(5367,'1','302','1',1,'Retail Sale Id 5189',4401.28,0.00,0.00,5.98,508.30,'2023-02-07 13:59:37','',''),(5368,'1','302','1',1,'Retail Sale Id 5191',3680.00,0.00,0.00,5.00,425.00,'2023-02-07 14:02:15','',''),(5369,'1','302','1',1,'Retail Sale Id 5192',4416.00,0.00,0.00,6.00,510.00,'2023-02-07 14:03:27','',''),(5370,'1','302','1',1,'Retail Sale Id 5193',2208.00,0.00,0.00,3.00,255.00,'2023-02-07 14:04:05','',''),(5371,'1','302','1',1,'Retail Sale Id 5194',9200.00,0.00,0.00,12.50,1062.50,'2023-02-07 14:06:24','',''),(5372,'1','302','1',1,'Retail Sale Id 5195',4416.00,0.00,0.00,6.00,510.00,'2023-02-07 14:14:07','',''),(5373,'1','302','1',1,'Retail Sale Id 5196',736.00,0.00,0.00,1.00,85.00,'2023-02-07 14:23:27','',''),(5374,'1','302','1',1,'Retail Sale Id 5196',3680.00,0.00,0.00,5.00,425.00,'2023-02-07 14:23:27','',''),(5375,'1','302','1',1,'Retail Sale Id 5197',4416.00,0.00,0.00,6.00,510.00,'2023-02-07 14:49:08','',''),(5376,'1','302','1',1,'Retail Sale Id 5198',4416.00,0.00,0.00,6.00,510.00,'2023-02-07 14:56:48','',''),(5377,'1','302','1',1,'Retail Sale Id 5199',2001.92,0.00,0.00,2.72,231.20,'2023-02-07 15:01:56','',''),(5378,'1','302','1',1,'Retail Sale Id 5200',4416.00,0.00,0.00,6.00,510.00,'2023-02-07 15:06:34','',''),(5379,'1','302','1',1,'Retail Sale Id 5201',2001.92,0.00,0.00,2.72,231.20,'2023-02-07 15:09:35','',''),(5380,'1','302','1',1,'Retail Sale Id 5202',750.72,0.00,0.00,1.02,86.70,'2023-02-07 15:13:52','',''),(5381,'1','302','1',1,'Retail Sale Id 5203',2001.92,0.00,0.00,2.72,231.20,'2023-02-07 15:15:50','',''),(5382,'1','302','1',1,'Retail Sale Id 5204',11040.00,0.00,0.00,15.00,1275.00,'2023-02-07 15:21:38','',''),(5383,'1','302','1',1,'Retail Sale Id 5205',500.48,0.00,0.00,0.68,57.80,'2023-02-07 15:24:03','',''),(5384,'1','302','1',1,'Retail Sale Id 5207',2944.00,0.00,0.00,4.00,340.00,'2023-02-07 15:33:50','',''),(5385,'1','302','1',1,'Retail Sale Id 5207',2944.00,0.00,0.00,4.00,340.00,'2023-02-07 15:33:50','',''),(5386,'1','302','1',1,'Retail Sale Id 5208',11040.00,0.00,0.00,15.00,1275.00,'2023-02-07 15:35:28','',''),(5387,'1','302','1',1,'Retail Sale Id 5210',2208.00,0.00,0.00,3.00,255.00,'2023-02-07 15:39:51','',''),(5388,'1','302','1',1,'Retail Sale Id 5210',9200.00,0.00,0.00,12.50,1062.50,'2023-02-07 15:39:51','',''),(5389,'1','302','1',1,'Retail Sale Id 5211',1472.00,0.00,0.00,2.00,170.00,'2023-02-07 15:41:48','',''),(5390,'1','302','1',1,'Retail Sale Id 5212',9200.00,0.00,0.00,12.50,1062.50,'2023-02-07 15:43:26','',''),(5391,'1','302','1',1,'Retail Sale Id 5212',9200.00,0.00,0.00,12.50,1062.50,'2023-02-07 15:43:26','',''),(5392,'1','302','1',1,'Retail Sale Id 5213',1501.44,0.00,0.00,2.04,173.40,'2023-02-07 15:45:08','',''),(5393,'1','302','1',1,'Retail Sale Id 5214',3996.48,0.00,0.00,5.43,461.55,'2023-02-07 15:46:03','',''),(5394,'1','302','1',1,'Retail Sale Id 5215',1472.00,0.00,0.00,2.00,170.00,'2023-02-07 15:48:06','',''),(5395,'1','302','1',1,'Retail Sale Id 5215',2944.00,0.00,0.00,4.00,340.00,'2023-02-07 15:48:06','',''),(5396,'1','302','1',1,'Retail Sale Id 5215',4416.00,0.00,0.00,6.00,510.00,'2023-02-07 15:48:06','',''),(5397,'1','302','1',1,'Retail Sale Id 5217',3702.08,0.00,0.00,5.03,427.55,'2023-02-07 16:11:03','',''),(5398,'1','302','1',1,'Retail Sale Id 5218',3996.48,0.00,0.00,5.43,461.55,'2023-02-07 16:31:32','',''),(5399,'1','302','1',1,'Retail Sale Id 5219',9200.00,0.00,0.00,12.50,1062.50,'2023-02-07 16:41:34','',''),(5400,'1','302','1',1,'Retail Sale Id 5220',4401.28,0.00,0.00,5.98,508.30,'2023-02-07 16:42:51','',''),(5401,'1','302','1',1,'Retail Sale Id 5221',3002.88,0.00,0.00,4.08,346.80,'2023-02-07 16:43:37','',''),(5402,'1','302','1',1,'Retail Sale Id 5223',3680.00,0.00,0.00,5.00,425.00,'2023-02-07 16:46:39','',''),(5403,'1','302','1',1,'Retail Sale Id 5224',2200.64,0.00,0.00,2.99,254.15,'2023-02-07 16:47:48','',''),(5404,'1','302','1',1,'Retail Sale Id 5228',1000.96,0.00,0.00,1.36,115.60,'2023-02-07 17:16:22','',''),(5405,'1','302','1',1,'Retail Sale Id 5229',3002.88,0.00,0.00,4.08,346.80,'2023-02-07 17:18:37','',''),(5406,'1','302','1',1,'Retail Sale Id 5230',802.24,0.00,0.00,1.09,92.65,'2023-02-07 17:20:20','',''),(5407,'1','302','1',1,'Retail Sale Id 5231',9200.00,0.00,0.00,12.50,1062.50,'2023-02-07 17:21:18','',''),(5408,'1','302','1',1,'Retail Sale Id 5232',3996.48,0.00,0.00,5.43,461.55,'2023-02-07 17:22:32','',''),(5409,'1','302','1',1,'Retail Sale Id 5233',2252.16,0.00,0.00,3.06,260.10,'2023-02-07 17:23:27','',''),(5410,'1','302','1',1,'Retail Sale Id 5234',3002.88,0.00,0.00,4.08,346.80,'2023-02-07 17:25:39','',''),(5411,'1','302','1',1,'Retail Sale Id 5235',9200.00,0.00,0.00,12.50,1062.50,'2023-02-07 17:27:05','',''),(5412,'1','302','1',1,'Retail Sale Id 5236',2001.92,0.00,0.00,2.72,231.20,'2023-02-07 17:27:50','',''),(5413,'1','302','1',1,'Retail Sale Id 5237',9200.00,0.00,0.00,12.50,1062.50,'2023-02-07 17:28:47','',''),(5414,'1','302','1',1,'Retail Sale Id 5238',1501.44,0.00,0.00,2.04,173.40,'2023-02-07 17:34:33','',''),(5415,'1','302','1',1,'Retail Sale Id 5239',3680.00,0.00,0.00,5.00,425.00,'2023-02-07 17:41:44','',''),(5416,'1','302','1',1,'Retail Sale Id 5240',2208.00,0.00,0.00,3.00,255.00,'2023-02-07 17:46:46','',''),(5417,'1','302','1',1,'Retail Sale Id 5242',3996.48,0.00,0.00,5.43,461.55,'2023-02-07 17:55:31','',''),(5418,'1','302','1',1,'Retail Sale Id 5243',9200.00,0.00,0.00,12.50,1062.50,'2023-02-07 17:58:50','',''),(5419,'1','302','1',1,'Retail Sale Id 5243',9200.00,0.00,0.00,12.50,1062.50,'2023-02-07 17:58:50','',''),(5420,'1','302','1',1,'Retail Sale Id 5244',4416.00,0.00,0.00,6.00,510.00,'2023-02-07 18:03:31','',''),(5421,'1','302','1',1,'Retail Sale Id 5245',2208.00,0.00,0.00,3.00,255.00,'2023-02-07 18:05:22','',''),(5422,'1','302','1',1,'Retail Sale Id 5246',4260.00,0.00,0.00,6.00,354.00,'2023-02-07 18:07:12','',''),(5423,'1','302','1',1,'Retail Sale Id 5247',603.52,0.00,0.00,0.82,69.70,'2023-02-07 18:10:29','',''),(5424,'1','302','1',1,'Retail Sale Id 5248',4416.00,0.00,0.00,6.00,510.00,'2023-02-07 18:13:09','',''),(5425,'1','302','1',1,'Retail Sale Id 5248',9200.00,0.00,0.00,12.50,1062.50,'2023-02-07 18:13:09','',''),(5426,'1','302','1',1,'Retail Sale Id 5249',1000.96,0.00,0.00,1.36,115.60,'2023-02-07 18:15:25','',''),(5427,'1','302','1',1,'Retail Sale Id 5250',9200.00,0.00,0.00,12.50,1062.50,'2023-02-07 18:16:47','',''),(5428,'1','302','1',1,'Retail Sale Id 5251',3680.00,0.00,0.00,5.00,425.00,'2023-02-07 18:22:47','',''),(5429,'1','302','1',1,'Retail Sale Id 5252',2208.00,0.00,0.00,3.00,255.00,'2023-02-07 18:24:05','',''),(5430,'1','302','1',1,'Return of Retail Sale Id 5165',0.00,3680.00,5.00,0.00,-425.00,'2023-02-07 21:53:29','',''),(5431,'1','302','1',1,'Retail Sale Id 5254',2907.20,0.00,0.00,3.95,335.75,'2023-02-07 21:56:08','',''),(5432,'1','302','1',1,'Retail Sale Id 5256',2001.92,0.00,0.00,2.72,231.20,'2023-02-08 07:54:07','',''),(5433,'1','302','1',1,'Retail Sale Id 5256',2001.92,0.00,0.00,2.72,231.20,'2023-02-08 07:54:07','',''),(5434,'1','302','1',1,'Retail Sale Id 5257',3996.48,0.00,0.00,5.43,461.55,'2023-02-08 07:59:38','',''),(5435,'1','302','1',1,'Retail Sale Id 5258',3680.00,0.00,0.00,5.00,425.00,'2023-02-08 08:09:27','',''),(5436,'1','302','1',1,'Retail Sale Id 5259',4416.00,0.00,0.00,6.00,510.00,'2023-02-08 08:12:33','',''),(5437,'1','302','1',1,'Retail Sale Id 5260',1501.44,0.00,0.00,2.04,173.40,'2023-02-08 08:24:25','',''),(5438,'1','302','1',1,'Retail Sale Id 5262',4997.44,0.00,0.00,6.79,577.15,'2023-02-08 08:38:55','',''),(5439,'1','302','1',1,'Retail Sale Id 5263',8096.00,0.00,0.00,11.00,935.00,'2023-02-08 08:41:10','',''),(5440,'1','302','1',1,'Retail Sale Id 5264',17750.00,0.00,0.00,25.00,1475.00,'2023-02-08 08:45:51','',''),(5441,'1','302','1',1,'Retail Sale Id 5265',3002.88,0.00,0.00,4.08,346.80,'2023-02-08 08:46:59','',''),(5442,'1','302','1',1,'Retail Sale Id 5267',4496.96,0.00,0.00,6.11,519.35,'2023-02-08 08:54:38','',''),(5443,'1','302','1',1,'Retail Sale Id 5268',4997.44,0.00,0.00,6.79,577.15,'2023-02-08 08:58:17','',''),(5444,'1','302','1',1,'Retail Sale Id 5269',4416.00,0.00,0.00,6.00,510.00,'2023-02-08 09:08:25','',''),(5445,'1','302','1',1,'Retail Sale Id 5270',3996.48,0.00,0.00,5.43,461.55,'2023-02-08 09:10:23','',''),(5446,'1','302','1',1,'Retail Sale Id 5271',4416.00,0.00,0.00,6.00,510.00,'2023-02-08 09:37:27','',''),(5447,'1','302','1',1,'Retail Sale Id 5272',2208.00,0.00,0.00,3.00,255.00,'2023-02-08 09:39:35','',''),(5448,'1','302','1',1,'Retail Sale Id 5273',7360.00,0.00,0.00,10.00,850.00,'2023-02-08 09:47:39','',''),(5449,'1','302','1',1,'Retail Sale Id 5274',3996.48,0.00,0.00,5.43,461.55,'2023-02-08 09:57:30','',''),(5450,'1','302','1',1,'Retail Sale Id 5275',699.20,0.00,0.00,0.95,80.75,'2023-02-08 10:00:10','',''),(5451,'1','302','1',1,'Retail Sale Id 5276',9501.76,0.00,0.00,12.91,1097.35,'2023-02-08 10:13:48','',''),(5452,'1','302','1',1,'Retail Sale Id 5277',24850.00,0.00,0.00,35.00,2065.00,'2023-02-08 10:17:55','',''),(5453,'1','302','1',1,'Retail Sale Id 5278',16928.00,0.00,0.00,23.00,1955.00,'2023-02-08 10:19:58','',''),(5454,'1','302','1',1,'Retail Sale Id 5279',1398.40,0.00,0.00,1.90,161.50,'2023-02-08 10:23:59','',''),(5455,'1','302','1',1,'Retail Sale Id 5280',2001.92,0.00,0.00,2.72,231.20,'2023-02-08 10:30:42','',''),(5456,'1','302','1',1,'Retail Sale Id 5281',29440.00,0.00,0.00,40.00,3400.00,'2023-02-08 10:33:22','',''),(5457,'1','302','1',1,'Retail Sale Id 5282',4496.96,0.00,0.00,6.11,519.35,'2023-02-08 10:42:28','',''),(5458,'1','302','1',1,'Retail Sale Id 5283',4416.00,0.00,0.00,6.00,510.00,'2023-02-08 10:43:48','',''),(5459,'1','302','1',1,'Retail Sale Id 5284',6624.00,0.00,0.00,9.00,765.00,'2023-02-08 10:46:08','',''),(5460,'1','302','1',1,'Retail Sale Id 5285',2899.84,0.00,0.00,3.94,334.90,'2023-02-08 10:47:32','',''),(5461,'1','302','1',1,'Retail Sale Id 5286',2944.00,0.00,0.00,4.00,340.00,'2023-02-08 10:49:11','',''),(5462,'1','302','1',1,'Retail Sale Id 5286',2944.00,0.00,0.00,4.00,340.00,'2023-02-08 10:49:11','',''),(5463,'1','302','1',1,'Retail Sale Id 5287',4416.00,0.00,0.00,6.00,510.00,'2023-02-08 10:50:10','',''),(5464,'1','302','1',1,'Retail Sale Id 5288',4416.00,0.00,0.00,6.00,510.00,'2023-02-08 10:54:42','',''),(5465,'1','302','1',1,'Retail Sale Id 5289',22010.00,0.00,0.00,31.00,1829.00,'2023-02-08 10:57:51','',''),(5466,'1','302','1',1,'Retail Sale Id 5291',35500.00,0.00,0.00,50.00,2950.00,'2023-02-08 11:01:00','',''),(5467,'1','302','1',1,'Retail Sale Id 5292',2208.00,0.00,0.00,3.00,255.00,'2023-02-08 11:02:14','',''),(5468,'1','302','1',1,'Retail Sale Id 5293',2001.92,0.00,0.00,2.72,231.20,'2023-02-08 11:04:54','',''),(5469,'1','302','1',1,'Retail Sale Id 5294',4416.00,0.00,0.00,6.00,510.00,'2023-02-08 11:08:39','',''),(5470,'1','302','1',1,'Retail Sale Id 5296',2001.92,0.00,0.00,2.72,231.20,'2023-02-08 11:18:34','',''),(5471,'1','302','1',1,'Retail Sale Id 5297',3680.00,0.00,0.00,5.00,425.00,'2023-02-08 11:20:41','',''),(5472,'1','302','1',1,'Retail Sale Id 5298',3996.48,0.00,0.00,5.43,461.55,'2023-02-08 11:21:44','',''),(5473,'1','302','1',1,'Retail Sale Id 5300',4416.00,0.00,0.00,6.00,510.00,'2023-02-08 12:16:41','',''),(5474,'1','302','1',1,'Retail Sale Id 5301',17750.00,0.00,0.00,25.00,1475.00,'2023-02-08 12:19:30','',''),(5475,'1','302','1',1,'Retail Sale Id 5302',9200.00,0.00,0.00,12.50,1062.50,'2023-02-08 12:20:56','',''),(5476,'1','302','1',1,'Retail Sale Id 5303',9200.00,0.00,0.00,12.50,1062.50,'2023-02-08 12:21:47','',''),(5477,'1','302','1',1,'Retail Sale Id 5304',9200.00,0.00,0.00,12.50,1062.50,'2023-02-08 12:22:46','',''),(5478,'1','302','1',1,'Retail Sale Id 5305',4416.00,0.00,0.00,6.00,510.00,'2023-02-08 12:24:20','',''),(5479,'1','302','1',1,'Retail Sale Id 5306',1000.96,0.00,0.00,1.36,115.60,'2023-02-08 12:32:34','',''),(5480,'1','302','1',1,'Retail Sale Id 5307',3002.88,0.00,0.00,4.08,346.80,'2023-02-08 12:35:25','',''),(5481,'1','302','1',1,'Retail Sale Id 5308',7100.00,0.00,0.00,10.00,590.00,'2023-02-08 12:39:07','',''),(5482,'1','302','1',1,'Retail Sale Id 5309',9200.00,0.00,0.00,12.50,1062.50,'2023-02-08 12:40:59','',''),(5483,'1','302','1',1,'Retail Sale Id 5310',2303.68,0.00,0.00,3.13,266.05,'2023-02-08 12:45:05','',''),(5484,'1','302','1',1,'Retail Sale Id 5311',2208.00,0.00,0.00,3.00,255.00,'2023-02-08 12:54:43','',''),(5485,'1','302','1',1,'Retail Sale Id 5312',144840.00,0.00,0.00,204.00,12036.00,'2023-02-08 12:57:47','',''),(5486,'1','302','1',1,'Retail Sale Id 5313',11408.00,0.00,0.00,15.50,1317.50,'2023-02-08 12:58:50','',''),(5487,'1','302','1',1,'Retail Sale Id 5314',4416.00,0.00,0.00,6.00,510.00,'2023-02-08 13:00:34','',''),(5488,'1','302','1',1,'Retail Sale Id 5315',4496.96,0.00,0.00,6.11,519.35,'2023-02-08 13:11:17','',''),(5489,'1','302','1',1,'Retail Sale Id 5316',2001.92,0.00,0.00,2.72,231.20,'2023-02-08 13:17:56','',''),(5490,'1','302','1',1,'Retail Sale Id 5317',750.72,0.00,0.00,1.02,86.70,'2023-02-08 13:32:52','',''),(5491,'1','302','1',1,'Retail Sale Id 5318',2208.00,0.00,0.00,3.00,255.00,'2023-02-08 13:34:41','',''),(5492,'1','302','1',1,'Retail Sale Id 5319',3503.36,0.00,0.00,4.76,404.60,'2023-02-08 13:37:09','',''),(5493,'1','302','1',1,'Retail Sale Id 5320',9200.00,0.00,0.00,12.50,1062.50,'2023-02-08 13:39:04','',''),(5494,'1','302','1',1,'Retail Sale Id 5321',9200.00,0.00,0.00,12.50,1062.50,'2023-02-08 13:41:52','',''),(5495,'1','302','1',1,'Retail Sale Id 5322',4416.00,0.00,0.00,6.00,510.00,'2023-02-08 13:43:24','',''),(5496,'1','302','1',1,'Retail Sale Id 5323',5680.00,0.00,0.00,8.00,472.00,'2023-02-08 13:51:29','',''),(5497,'1','302','1',1,'Retail Sale Id 5324',2252.16,0.00,0.00,3.06,260.10,'2023-02-08 13:55:33','',''),(5498,'1','302','1',1,'Retail Sale Id 5325',4416.00,0.00,0.00,6.00,510.00,'2023-02-08 14:07:49','',''),(5499,'1','302','1',1,'Retail Sale Id 5326',2001.92,0.00,0.00,2.72,231.20,'2023-02-08 14:08:59','',''),(5500,'1','302','1',1,'Retail Sale Id 5327',2944.00,0.00,0.00,4.00,340.00,'2023-02-08 14:12:06','',''),(5501,'1','302','1',1,'Retail Sale Id 5328',1472.00,0.00,0.00,2.00,170.00,'2023-02-08 14:14:10','',''),(5502,'1','302','1',1,'Retail Sale Id 5329',4416.00,0.00,0.00,6.00,510.00,'2023-02-08 14:21:13','',''),(5503,'1','302','1',1,'Retail Sale Id 5329',9200.00,0.00,0.00,12.50,1062.50,'2023-02-08 14:21:13','',''),(5504,'1','302','1',1,'Retail Sale Id 5330',2001.92,0.00,0.00,2.72,231.20,'2023-02-08 14:34:11','',''),(5505,'1','302','1',1,'Retail Sale Id 5332',71000.00,0.00,0.00,100.00,5900.00,'2023-02-08 14:45:49','',''),(5506,'1','302','1',1,'Retail Sale Id 5333',1501.44,0.00,0.00,2.04,173.40,'2023-02-08 14:47:31','',''),(5507,'1','302','1',1,'Retail Sale Id 5334',65994.50,0.00,0.00,92.95,5484.05,'2023-02-08 14:49:53','',''),(5508,'1','302','1',1,'Retail Sale Id 5336',35500.00,0.00,0.00,50.00,2950.00,'2023-02-08 14:57:03','',''),(5509,'1','302','1',1,'Retail Sale Id 5337',9200.00,0.00,0.00,12.50,1062.50,'2023-02-08 15:12:04','',''),(5510,'1','302','1',1,'Retail Sale Id 5339',4416.00,0.00,0.00,6.00,510.00,'2023-02-08 15:15:34','',''),(5511,'1','302','1',1,'Retail Sale Id 5340',3680.00,0.00,0.00,5.00,425.00,'2023-02-08 15:16:56','',''),(5512,'1','302','1',1,'Retail Sale Id 5341',2502.40,0.00,0.00,3.40,289.00,'2023-02-08 15:20:40','',''),(5513,'1','302','1',1,'Retail Sale Id 5342',3996.48,0.00,0.00,5.43,461.55,'2023-02-08 15:22:55','',''),(5514,'1','302','1',1,'Retail Sale Id 5343',3680.00,0.00,0.00,5.00,425.00,'2023-02-08 15:40:44','',''),(5515,'1','302','1',1,'Retail Sale Id 5344',4416.00,0.00,0.00,6.00,510.00,'2023-02-08 15:47:17','',''),(5516,'1','302','1',1,'Retail Sale Id 5345',1501.44,0.00,0.00,2.04,173.40,'2023-02-08 15:49:35','',''),(5517,'1','302','1',1,'Retail Sale Id 5346',3680.00,0.00,0.00,5.00,425.00,'2023-02-08 15:53:41','',''),(5518,'1','302','1',1,'Retail Sale Id 5347',4416.00,0.00,0.00,6.00,510.00,'2023-02-08 15:55:52','',''),(5519,'1','302','1',1,'Retail Sale Id 5348',4401.28,0.00,0.00,5.98,508.30,'2023-02-08 16:06:22','',''),(5520,'1','302','1',1,'Retail Sale Id 5349',2502.40,0.00,0.00,3.40,289.00,'2023-02-08 16:08:49','',''),(5521,'1','302','1',1,'Retail Sale Id 5350',9200.00,0.00,0.00,12.50,1062.50,'2023-02-08 16:28:07','',''),(5522,'1','302','1',1,'Retail Sale Id 5351',17750.00,0.00,0.00,25.00,1475.00,'2023-02-08 16:38:39','',''),(5523,'1','302','1',1,'Retail Sale Id 5352',2001.92,0.00,0.00,2.72,231.20,'2023-02-08 16:39:46','',''),(5524,'1','302','1',1,'Retail Sale Id 5353',7360.00,0.00,0.00,10.00,850.00,'2023-02-08 16:44:29','',''),(5525,'1','302','1',1,'Retail Sale Id 5354',3002.88,0.00,0.00,4.08,346.80,'2023-02-08 16:47:05','',''),(5526,'1','302','1',1,'Retail Sale Id 5355',2208.00,0.00,0.00,3.00,255.00,'2023-02-08 16:50:50','',''),(5527,'1','302','1',1,'Retail Sale Id 5356',2208.00,0.00,0.00,3.00,255.00,'2023-02-08 16:56:22','',''),(5528,'1','302','1',1,'Retail Sale Id 5356',2208.00,0.00,0.00,3.00,255.00,'2023-02-08 16:56:22','',''),(5529,'1','302','1',1,'Retail Sale Id 5356',3680.00,0.00,0.00,5.00,425.00,'2023-02-08 16:56:22','',''),(5530,'1','302','1',1,'Retail Sale Id 5356',5888.00,0.00,0.00,8.00,680.00,'2023-02-08 16:56:22','',''),(5531,'1','302','1',1,'Retail Sale Id 5357',46150.00,0.00,0.00,65.00,3835.00,'2023-02-08 16:59:33','',''),(5532,'1','302','1',1,'Retail Sale Id 5358',4416.00,0.00,0.00,6.00,510.00,'2023-02-08 17:03:29','',''),(5533,'1','302','1',1,'Retail Sale Id 5358',9200.00,0.00,0.00,12.50,1062.50,'2023-02-08 17:03:29','',''),(5534,'1','302','1',1,'Retail Sale Id 5359',2208.00,0.00,0.00,3.00,255.00,'2023-02-08 17:04:42','',''),(5535,'1','302','1',1,'Retail Sale Id 5359',9200.00,0.00,0.00,12.50,1062.50,'2023-02-08 17:04:42','',''),(5536,'1','302','1',1,'Retail Sale Id 5360',1398.40,0.00,0.00,1.90,161.50,'2023-02-08 17:06:36','',''),(5537,'1','302','1',1,'Retail Sale Id 5361',3503.36,0.00,0.00,4.76,404.60,'2023-02-08 17:09:24','',''),(5538,'1','302','1',1,'Retail Sale Id 5362',9200.00,0.00,0.00,12.50,1062.50,'2023-02-08 17:10:48','',''),(5539,'1','302','1',1,'Retail Sale Id 5362',9200.00,0.00,0.00,12.50,1062.50,'2023-02-08 17:10:48','',''),(5540,'1','302','1',1,'Retail Sale Id 5363',1501.44,0.00,0.00,2.04,173.40,'2023-02-08 17:13:54','',''),(5541,'1','302','1',1,'Retail Sale Id 5365',9200.00,0.00,0.00,12.50,1062.50,'2023-02-08 17:24:30','',''),(5542,'1','302','1',1,'Retail Sale Id 5366',4416.00,0.00,0.00,6.00,510.00,'2023-02-08 17:27:02','',''),(5543,'1','302','1',1,'Retail Sale Id 5367',736.00,0.00,0.00,1.00,85.00,'2023-02-08 17:28:19','',''),(5544,'1','302','1',1,'Retail Sale Id 5368',7360.00,0.00,0.00,10.00,850.00,'2023-02-08 17:29:18','',''),(5545,'1','302','1',1,'Retail Sale Id 5369',1501.44,0.00,0.00,2.04,173.40,'2023-02-08 17:37:01','',''),(5546,'1','302','1',1,'Retail Sale Id 5370',2502.40,0.00,0.00,3.40,289.00,'2023-02-08 17:41:28','',''),(5547,'1','302','1',1,'Retail Sale Id 5371',6999.36,0.00,0.00,9.51,808.35,'2023-02-08 17:43:22','',''),(5548,'1','302','1',1,'Retail Sale Id 5372',4416.00,0.00,0.00,6.00,510.00,'2023-02-08 17:48:08','',''),(5549,'1','302','1',1,'Retail Sale Id 5373',9200.00,0.00,0.00,12.50,1062.50,'2023-02-08 17:49:02','',''),(5550,'1','302','1',1,'Retail Sale Id 5374',4416.00,0.00,0.00,6.00,510.00,'2023-02-08 17:49:56','',''),(5551,'1','302','1',1,'Retail Sale Id 5375',9200.00,0.00,0.00,12.50,1062.50,'2023-02-08 17:52:09','',''),(5552,'1','302','1',1,'Retail Sale Id 5376',2208.00,0.00,0.00,3.00,255.00,'2023-02-08 17:54:07','',''),(5553,'1','302','1',1,'Retail Sale Id 5377',2208.00,0.00,0.00,3.00,255.00,'2023-02-08 17:55:17','',''),(5554,'1','302','1',1,'Retail Sale Id 5378',3680.00,0.00,0.00,5.00,425.00,'2023-02-08 17:58:54','',''),(5555,'1','302','1',1,'Retail Sale Id 5379',9200.00,0.00,0.00,12.50,1062.50,'2023-02-08 18:08:49','',''),(5556,'1','302','1',1,'Retail Sale Id 5380',3002.88,0.00,0.00,4.08,346.80,'2023-02-08 18:10:01','',''),(5557,'1','302','1',1,'Retail Sale Id 5380',7360.00,0.00,0.00,10.00,850.00,'2023-02-08 18:10:01','',''),(5558,'1','302','1',1,'Retail Sale Id 5381',3002.88,0.00,0.00,4.08,346.80,'2023-02-08 18:10:57','',''),(5559,'1','302','1',1,'Retail Sale Id 5382',4997.44,0.00,0.00,6.79,577.15,'2023-02-08 18:12:03','',''),(5560,'1','302','1',1,'Retail Sale Id 5383',3002.88,0.00,0.00,4.08,346.80,'2023-02-08 18:13:05','',''),(5561,'1','302','1',1,'Retail Sale Id 5384',2208.00,0.00,0.00,3.00,255.00,'2023-02-08 18:14:10','',''),(5562,'1','302','1',1,'Retail Sale Id 5385',3680.00,0.00,0.00,5.00,425.00,'2023-02-08 18:15:45','',''),(5563,'1','302','1',1,'Retail Sale Id 5386',2001.92,0.00,0.00,2.72,231.20,'2023-02-08 18:16:58','',''),(5564,'1','302','1',1,'Retail Sale Id 5387',9940.00,0.00,0.00,14.00,826.00,'2023-02-08 18:24:23','',''),(5565,'1','302','1',1,'Retail Sale Id 5388',736.00,0.00,0.00,1.00,85.00,'2023-02-08 18:25:41','',''),(5566,'1','302','1',1,'Retail Sale Id 5389',9200.00,0.00,0.00,12.50,1062.50,'2023-02-08 18:26:32','',''),(5567,'1','302','1',1,'Retail Sale Id 5390',12512.00,0.00,0.00,17.00,1445.00,'2023-02-08 18:28:14','',''),(5568,'1','302','1',1,'Retail Sale Id 5391',9200.00,0.00,0.00,12.50,1062.50,'2023-02-08 19:10:34','',''),(5569,'1','302','1',1,'Return of Retail Sale Id 5332',0.00,71000.00,100.00,0.00,-5900.00,'2023-02-08 19:39:22','',''),(5570,'1','302','1',1,'Retail Sale Id 5392',2082.88,0.00,0.00,2.83,240.55,'2023-02-08 19:44:33','',''),(5571,'1','302','1',1,'Retail Sale Id 5393',29.44,0.00,0.00,0.04,3.40,'2023-02-08 19:46:04','',''),(5572,'1','302','1',1,'Retail Sale Id 5394',4997.44,0.00,0.00,6.79,577.15,'2023-02-09 08:56:36','',''),(5573,'1','302','1',1,'Retail Sale Id 5395',2208.00,0.00,0.00,3.00,255.00,'2023-02-09 09:38:19','',''),(5574,'1','302','1',1,'Retail Sale Id 5396',2208.00,0.00,0.00,3.00,255.00,'2023-02-09 09:46:02','',''),(5575,'1','302','1',1,'Retail Sale Id 5397',4496.96,0.00,0.00,6.11,519.35,'2023-02-09 09:52:02','',''),(5576,'1','302','1',1,'Retail Sale Id 5398',1199.68,0.00,0.00,1.63,138.55,'2023-02-09 09:52:44','',''),(5577,'1','302','1',1,'Retail Sale Id 5399',3680.00,0.00,0.00,5.00,425.00,'2023-02-09 09:57:33','',''),(5578,'1','302','1',1,'Retail Sale Id 5400',9200.00,0.00,0.00,12.50,1062.50,'2023-02-09 09:58:47','',''),(5579,'1','302','1',1,'Retail Sale Id 5401',99330.56,0.00,0.00,134.96,11471.60,'2023-02-09 10:01:48','',''),(5580,'1','302','1',1,'Retail Sale Id 5402',9200.00,0.00,0.00,12.50,1062.50,'2023-02-09 10:03:48','',''),(5581,'1','302','1',1,'Retail Sale Id 5403',2208.00,0.00,0.00,3.00,255.00,'2023-02-09 10:07:23','',''),(5582,'1','302','1',1,'Retail Sale Id 5403',9200.00,0.00,0.00,12.50,1062.50,'2023-02-09 10:07:23','',''),(5583,'1','302','1',1,'Retail Sale Id 5404',3680.00,0.00,0.00,5.00,425.00,'2023-02-09 10:14:33','',''),(5584,'1','302','1',1,'Retail Sale Id 5405',3002.88,0.00,0.00,4.08,346.80,'2023-02-09 10:15:15','',''),(5585,'1','302','1',1,'Retail Sale Id 5407',1000.96,0.00,0.00,1.36,115.60,'2023-02-09 10:21:37','',''),(5586,'1','302','1',1,'Retail Sale Id 5408',7360.00,0.00,0.00,10.00,850.00,'2023-02-09 10:23:51','',''),(5587,'1','302','1',1,'Retail Sale Id 5409',3702.08,0.00,0.00,5.03,427.55,'2023-02-09 10:25:50','',''),(5588,'1','302','1',1,'Retail Sale Id 5410',9200.00,0.00,0.00,12.50,1062.50,'2023-02-09 10:29:37','',''),(5589,'1','302','1',1,'Retail Sale Id 5411',4416.00,0.00,0.00,6.00,510.00,'2023-02-09 10:33:42','',''),(5590,'1','302','1',1,'Retail Sale Id 5412',4416.00,0.00,0.00,6.00,510.00,'2023-02-09 10:35:51','',''),(5591,'1','302','1',1,'Retail Sale Id 5413',4416.00,0.00,0.00,6.00,510.00,'2023-02-09 10:37:11','',''),(5592,'1','302','1',1,'Retail Sale Id 5414',9200.00,0.00,0.00,12.50,1062.50,'2023-02-09 10:44:05','',''),(5593,'1','302','1',1,'Retail Sale Id 5415',4416.00,0.00,0.00,6.00,510.00,'2023-02-09 10:47:33','',''),(5594,'1','302','1',1,'Retail Sale Id 5416',53250.00,0.00,0.00,75.00,4425.00,'2023-02-09 10:52:04','',''),(5595,'1','302','1',1,'Retail Sale Id 5417',4496.96,0.00,0.00,6.11,519.35,'2023-02-09 10:53:44','',''),(5596,'1','302','1',1,'Retail Sale Id 5418',4416.00,0.00,0.00,6.00,510.00,'2023-02-09 10:57:56','',''),(5597,'1','302','1',1,'Retail Sale Id 5419',9200.00,0.00,0.00,12.50,1062.50,'2023-02-09 11:03:07','',''),(5598,'1','302','1',1,'Retail Sale Id 5420',2001.92,0.00,0.00,2.72,231.20,'2023-02-09 11:03:55','',''),(5599,'1','302','1',1,'Retail Sale Id 5421',3702.08,0.00,0.00,5.03,427.55,'2023-02-09 11:07:17','',''),(5600,'1','302','1',1,'Retail Sale Id 5422',2001.92,0.00,0.00,2.72,231.20,'2023-02-09 11:09:15','',''),(5601,'1','302','1',1,'Retail Sale Id 5423',4496.96,0.00,0.00,6.11,519.35,'2023-02-09 11:11:35','',''),(5602,'1','302','1',1,'Retail Sale Id 5424',1803.20,0.00,0.00,2.45,208.25,'2023-02-09 11:13:38','',''),(5603,'1','302','1',1,'Retail Sale Id 5425',4416.00,0.00,0.00,6.00,510.00,'2023-02-09 11:15:24','',''),(5604,'1','302','1',1,'Retail Sale Id 5426',3680.00,0.00,0.00,5.00,425.00,'2023-02-09 11:17:00','',''),(5605,'1','302','1',1,'Retail Sale Id 5427',500.48,0.00,0.00,0.68,57.80,'2023-02-09 11:20:34','',''),(5606,'1','302','1',1,'Retail Sale Id 5428',3002.88,0.00,0.00,4.08,346.80,'2023-02-09 11:21:46','',''),(5607,'1','302','1',1,'Retail Sale Id 5429',9200.00,0.00,0.00,12.50,1062.50,'2023-02-09 11:23:17','',''),(5608,'1','302','1',1,'Retail Sale Id 5430',9200.00,0.00,0.00,12.50,1062.50,'2023-02-09 11:24:35','',''),(5609,'1','302','1',1,'Retail Sale Id 5431',4416.00,0.00,0.00,6.00,510.00,'2023-02-09 11:26:48','',''),(5610,'1','302','1',1,'Retail Sale Id 5432',9200.00,0.00,0.00,12.50,1062.50,'2023-02-09 11:32:39','',''),(5611,'1','302','1',1,'Retail Sale Id 5433',2208.00,0.00,0.00,3.00,255.00,'2023-02-09 11:34:00','',''),(5612,'1','302','1',1,'Retail Sale Id 5434',7100.00,0.00,0.00,10.00,590.00,'2023-02-09 11:35:40','',''),(5613,'1','302','1',1,'Retail Sale Id 5435',2944.00,0.00,0.00,4.00,340.00,'2023-02-09 11:37:31','',''),(5614,'1','302','1',1,'Retail Sale Id 5436',3002.88,0.00,0.00,4.08,346.80,'2023-02-09 11:40:13','',''),(5615,'1','302','1',1,'Retail Sale Id 5437',9200.00,0.00,0.00,12.50,1062.50,'2023-02-09 11:43:31','',''),(5616,'1','302','1',1,'Retail Sale Id 5438',4416.00,0.00,0.00,6.00,510.00,'2023-02-09 11:49:35','',''),(5617,'1','302','1',1,'Retail Sale Id 5439',4416.00,0.00,0.00,6.00,510.00,'2023-02-09 11:52:41','',''),(5618,'1','302','1',1,'Retail Sale Id 5440',9200.00,0.00,0.00,12.50,1062.50,'2023-02-09 11:57:28','',''),(5619,'1','302','1',1,'Retail Sale Id 5441',1472.00,0.00,0.00,2.00,170.00,'2023-02-09 12:02:37','',''),(5620,'1','302','1',1,'Retail Sale Id 5441',9200.00,0.00,0.00,12.50,1062.50,'2023-02-09 12:02:37','',''),(5621,'1','302','1',1,'Retail Sale Id 5442',1000.96,0.00,0.00,1.36,115.60,'2023-02-09 12:13:24','',''),(5622,'1','302','1',1,'Retail Sale Id 5443',4416.00,0.00,0.00,6.00,510.00,'2023-02-09 12:14:56','',''),(5623,'1','302','1',1,'Retail Sale Id 5444',9200.00,0.00,0.00,12.50,1062.50,'2023-02-09 12:30:28','',''),(5624,'1','302','1',1,'Retail Sale Id 5445',6624.00,0.00,0.00,9.00,765.00,'2023-02-09 12:46:47','',''),(5625,'1','302','1',1,'Retail Sale Id 5446',2576.00,0.00,0.00,3.50,297.50,'2023-02-09 12:49:53','',''),(5626,'1','302','1',1,'Retail Sale Id 5447',4416.00,0.00,0.00,6.00,510.00,'2023-02-09 12:51:14','',''),(5627,'1','302','1',1,'Retail Sale Id 5448',4416.00,0.00,0.00,6.00,510.00,'2023-02-09 12:52:23','',''),(5628,'1','302','1',1,'Retail Sale Id 5449',4416.00,0.00,0.00,6.00,510.00,'2023-02-09 12:53:57','',''),(5629,'1','302','1',1,'Retail Sale Id 5450',9200.00,0.00,0.00,12.50,1062.50,'2023-02-09 12:55:08','',''),(5630,'1','302','1',1,'Retail Sale Id 5452',4997.44,0.00,0.00,6.79,577.15,'2023-02-09 12:57:40','',''),(5631,'1','302','1',1,'Retail Sale Id 5453',2252.16,0.00,0.00,3.06,260.10,'2023-02-09 13:09:53','',''),(5632,'1','302','1',1,'Retail Sale Id 5454',2944.00,0.00,0.00,4.00,340.00,'2023-02-09 13:11:08','',''),(5633,'1','302','1',1,'Retail Sale Id 5455',3002.88,0.00,0.00,4.08,346.80,'2023-02-09 13:24:53','',''),(5634,'1','302','1',1,'Retail Sale Id 5456',9200.00,0.00,0.00,12.50,1062.50,'2023-02-09 13:29:43','',''),(5635,'1','302','1',1,'Retail Sale Id 5458',9200.00,0.00,0.00,12.50,1062.50,'2023-02-09 13:35:32','',''),(5636,'1','302','1',1,'Retail Sale Id 5460',802.24,0.00,0.00,1.09,92.65,'2023-02-09 13:36:54','',''),(5637,'1','302','1',1,'Retail Sale Id 5461',2001.92,0.00,0.00,2.72,231.20,'2023-02-09 13:43:48','',''),(5638,'1','302','1',1,'Retail Sale Id 5462',3680.00,0.00,0.00,5.00,425.00,'2023-02-09 13:50:53','',''),(5639,'1','302','1',1,'Retail Sale Id 5463',1898.88,0.00,0.00,2.58,219.30,'2023-02-09 13:53:19','',''),(5640,'1','302','1',1,'Retail Sale Id 5464',1501.44,0.00,0.00,2.04,173.40,'2023-02-09 14:08:26','',''),(5641,'1','302','1',1,'Retail Sale Id 5465',7360.00,0.00,0.00,10.00,850.00,'2023-02-09 14:12:02','',''),(5642,'1','302','1',1,'Retail Sale Id 5466',9200.00,0.00,0.00,12.50,1062.50,'2023-02-09 14:18:40','',''),(5643,'1','302','1',1,'Retail Sale Id 5466',9200.00,0.00,0.00,12.50,1062.50,'2023-02-09 14:18:40','',''),(5644,'1','302','1',1,'Retail Sale Id 5467',2944.00,0.00,0.00,4.00,340.00,'2023-02-09 14:19:47','',''),(5645,'1','302','1',1,'Retail Sale Id 5468',4997.44,0.00,0.00,6.79,577.15,'2023-02-09 14:30:02','',''),(5646,'1','302','1',1,'Retail Sale Id 5469',17750.00,0.00,0.00,25.00,1475.00,'2023-02-09 14:41:20','',''),(5647,'1','302','1',1,'Retail Sale Id 5470',35500.00,0.00,0.00,50.00,2950.00,'2023-02-09 14:46:13','',''),(5648,'1','302','1',1,'Retail Sale Id 5472',9200.00,0.00,0.00,12.50,1062.50,'2023-02-09 14:52:22','',''),(5649,'1','302','1',1,'Retail Sale Id 5473',4496.96,0.00,0.00,6.11,519.35,'2023-02-09 14:57:02','',''),(5650,'1','302','1',1,'Retail Sale Id 5474',3503.36,0.00,0.00,4.76,404.60,'2023-02-09 15:06:12','',''),(5651,'1','302','1',1,'Retail Sale Id 5476',1501.44,0.00,0.00,2.04,173.40,'2023-02-09 15:13:39','',''),(5652,'1','302','1',1,'Retail Sale Id 5477',4496.96,0.00,0.00,6.11,519.35,'2023-02-09 15:19:20','',''),(5653,'1','302','1',1,'Retail Sale Id 5478',2208.00,0.00,0.00,3.00,255.00,'2023-02-09 15:23:45','',''),(5654,'1','302','1',1,'Retail Sale Id 5479',2208.00,0.00,0.00,3.00,255.00,'2023-02-09 15:29:03','',''),(5655,'1','302','1',1,'Retail Sale Id 5480',1000.96,0.00,0.00,1.36,115.60,'2023-02-09 15:30:04','',''),(5656,'1','302','1',1,'Retail Sale Id 5481',4416.00,0.00,0.00,6.00,510.00,'2023-02-09 15:31:13','',''),(5657,'1','302','1',1,'Retail Sale Id 5482',35500.00,0.00,0.00,50.00,2950.00,'2023-02-09 15:43:46','',''),(5658,'1','302','1',1,'Retail Sale Id 5483',3680.00,0.00,0.00,5.00,425.00,'2023-02-09 15:54:05','',''),(5659,'1','302','1',1,'Retail Sale Id 5483',3680.00,0.00,0.00,5.00,425.00,'2023-02-09 15:54:05','',''),(5660,'1','302','1',1,'Retail Sale Id 5483',9200.00,0.00,0.00,12.50,1062.50,'2023-02-09 15:54:05','',''),(5661,'1','302','1',1,'Retail Sale Id 5484',2200.64,0.00,0.00,2.99,254.15,'2023-02-09 15:58:48','',''),(5662,'1','302','1',1,'Retail Sale Id 5485',7360.00,0.00,0.00,10.00,850.00,'2023-02-09 16:18:52','',''),(5663,'1','302','1',1,'Retail Sale Id 5486',4416.00,0.00,0.00,6.00,510.00,'2023-02-09 16:19:37','',''),(5664,'1','302','1',1,'Retail Sale Id 5487',2001.92,0.00,0.00,2.72,231.20,'2023-02-09 16:21:09','',''),(5665,'1','302','1',1,'Retail Sale Id 5488',4496.96,0.00,0.00,6.11,519.35,'2023-02-09 16:22:05','',''),(5666,'1','302','1',1,'Retail Sale Id 5489',3680.00,0.00,0.00,5.00,425.00,'2023-02-09 16:22:55','',''),(5667,'1','302','1',1,'Retail Sale Id 5490',2208.00,0.00,0.00,3.00,255.00,'2023-02-09 16:23:56','',''),(5668,'1','302','1',1,'Retail Sale Id 5491',71000.00,0.00,0.00,100.00,5900.00,'2023-02-09 16:26:07','',''),(5669,'1','302','1',1,'Retail Sale Id 5492',9200.00,0.00,0.00,12.50,1062.50,'2023-02-09 16:32:59','',''),(5670,'1','302','1',1,'Retail Sale Id 5493',3680.00,0.00,0.00,5.00,425.00,'2023-02-09 16:34:33','',''),(5671,'1','302','1',1,'Retail Sale Id 5494',500.48,0.00,0.00,0.68,57.80,'2023-02-09 16:42:38','',''),(5672,'1','302','1',1,'Retail Sale Id 5495',9200.00,0.00,0.00,12.50,1062.50,'2023-02-09 16:52:38','',''),(5673,'1','302','1',1,'Retail Sale Id 5496',9200.00,0.00,0.00,12.50,1062.50,'2023-02-09 16:53:53','',''),(5674,'1','302','1',1,'Retail Sale Id 5497',3996.48,0.00,0.00,5.43,461.55,'2023-02-09 16:57:31','',''),(5675,'1','302','1',1,'Retail Sale Id 5498',9200.00,0.00,0.00,12.50,1062.50,'2023-02-09 16:58:28','',''),(5676,'1','302','1',1,'Retail Sale Id 5499',2001.92,0.00,0.00,2.72,231.20,'2023-02-09 17:00:43','',''),(5677,'1','302','1',1,'Retail Sale Id 5499',4496.96,0.00,0.00,6.11,519.35,'2023-02-09 17:00:44','',''),(5678,'1','302','1',1,'Retail Sale Id 5500',2502.40,0.00,0.00,3.40,289.00,'2023-02-09 17:01:59','',''),(5679,'1','302','1',1,'Retail Sale Id 5501',3996.48,0.00,0.00,5.43,461.55,'2023-02-09 17:07:30','',''),(5680,'1','302','1',1,'Retail Sale Id 5502',6999.36,0.00,0.00,9.51,808.35,'2023-02-09 17:11:36','',''),(5681,'1','302','1',1,'Retail Sale Id 5503',9001.28,0.00,0.00,12.23,1039.55,'2023-02-09 17:15:42','',''),(5682,'1','302','1',1,'Retail Sale Id 5503',9001.28,0.00,0.00,12.23,1039.55,'2023-02-09 17:15:42','',''),(5683,'1','302','1',1,'Retail Sale Id 5504',3584.32,0.00,0.00,4.87,413.95,'2023-02-09 17:19:11','',''),(5684,'1','302','1',1,'Retail Sale Id 5504',4416.00,0.00,0.00,6.00,510.00,'2023-02-09 17:19:11','',''),(5685,'1','302','1',1,'Retail Sale Id 5505',2502.40,0.00,0.00,3.40,289.00,'2023-02-09 17:20:38','',''),(5686,'1','302','1',1,'Retail Sale Id 5506',4416.00,0.00,0.00,6.00,510.00,'2023-02-09 17:26:32','',''),(5687,'1','302','1',1,'Retail Sale Id 5507',1000.96,0.00,0.00,1.36,115.60,'2023-02-09 17:28:37','',''),(5688,'1','302','1',1,'Retail Sale Id 5508',7360.00,0.00,0.00,10.00,850.00,'2023-02-09 17:33:39','',''),(5689,'1','302','1',1,'Retail Sale Id 5509',3002.88,0.00,0.00,4.08,346.80,'2023-02-09 17:34:40','',''),(5690,'1','302','1',1,'Retail Sale Id 5510',3002.88,0.00,0.00,4.08,346.80,'2023-02-09 17:36:57','',''),(5691,'1','302','1',1,'Retail Sale Id 5511',2502.40,0.00,0.00,3.40,289.00,'2023-02-09 17:38:12','',''),(5692,'1','302','1',1,'Retail Sale Id 5512',4496.96,0.00,0.00,6.11,519.35,'2023-02-09 17:39:11','',''),(5693,'1','302','1',1,'Retail Sale Id 5513',802.24,0.00,0.00,1.09,92.65,'2023-02-09 17:40:01','',''),(5694,'1','302','1',1,'Retail Sale Id 5514',4496.96,0.00,0.00,6.11,519.35,'2023-02-09 17:41:43','',''),(5695,'1','302','1',1,'Retail Sale Id 5515',2001.92,0.00,0.00,2.72,231.20,'2023-02-09 17:42:29','',''),(5696,'1','302','1',1,'Retail Sale Id 5516',736.00,0.00,0.00,1.00,85.00,'2023-02-09 17:43:54','',''),(5697,'1','302','1',1,'Retail Sale Id 5517',35500.00,0.00,0.00,50.00,2950.00,'2023-02-09 17:44:40','',''),(5698,'1','302','1',1,'Retail Sale Id 5518',736.00,0.00,0.00,1.00,85.00,'2023-02-09 17:49:13','',''),(5699,'1','302','1',1,'Retail Sale Id 5519',9200.00,0.00,0.00,12.50,1062.50,'2023-02-09 17:50:21','',''),(5700,'1','302','1',1,'Retail Sale Id 5520',2944.00,0.00,0.00,4.00,340.00,'2023-02-09 17:53:22','',''),(5701,'1','302','1',1,'Retail Sale Id 5520',18400.00,0.00,0.00,25.00,2125.00,'2023-02-09 17:53:22','',''),(5702,'1','302','1',1,'Retail Sale Id 5521',4416.00,0.00,0.00,6.00,510.00,'2023-02-09 17:54:24','',''),(5703,'1','302','1',1,'Retail Sale Id 5522',1000.96,0.00,0.00,1.36,115.60,'2023-02-09 17:55:23','',''),(5704,'1','302','1',1,'Retail Sale Id 5523',1000.96,0.00,0.00,1.36,115.60,'2023-02-09 17:56:19','',''),(5705,'1','302','1',1,'Retail Sale Id 5524',2208.00,0.00,0.00,3.00,255.00,'2023-02-09 18:01:27','',''),(5706,'1','302','1',1,'Retail Sale Id 5526',2502.40,0.00,0.00,3.40,289.00,'2023-02-09 18:07:47','',''),(5707,'1','302','1',1,'Retail Sale Id 5527',2944.00,0.00,0.00,4.00,340.00,'2023-02-09 18:10:16','',''),(5708,'1','302','1',1,'Retail Sale Id 5527',3680.00,0.00,0.00,5.00,425.00,'2023-02-09 18:10:16','',''),(5709,'1','302','1',1,'Retail Sale Id 5527',7360.00,0.00,0.00,10.00,850.00,'2023-02-09 18:10:16','',''),(5710,'1','302','1',1,'Retail Sale Id 5528',3550.00,0.00,0.00,5.00,295.00,'2023-02-09 18:11:22','',''),(5711,'1','302','1',1,'Retail Sale Id 5529',1472.00,0.00,0.00,2.00,170.00,'2023-02-09 18:13:49','',''),(5712,'1','302','1',1,'Retail Sale Id 5530',9200.00,0.00,0.00,12.50,1062.50,'2023-02-09 18:21:54','',''),(5713,'1','302','1',1,'Retail Sale Id 5531',301.76,0.00,0.00,0.41,34.85,'2023-02-09 18:22:42','',''),(5714,'1','302','1',1,'Retail Sale Id 5532',2208.00,0.00,0.00,3.00,255.00,'2023-02-09 18:27:37','',''),(5715,'1','302','1',1,'Retail Sale Id 5533',1501.44,0.00,0.00,2.04,173.40,'2023-02-09 18:28:36','',''),(5716,'1','302','1',1,'Retail Sale Id 5534',4416.00,0.00,0.00,6.00,510.00,'2023-02-09 18:29:53','',''),(5717,'1','302','1',1,'Retail Sale Id 5535',2208.00,0.00,0.00,3.00,255.00,'2023-02-09 18:32:53','',''),(5718,'1','302','1',1,'Retail Sale Id 5536',3996.48,0.00,0.00,5.43,461.55,'2023-02-10 07:46:35','',''),(5719,'1','302','1',1,'Retail Sale Id 5537',3680.00,0.00,0.00,5.00,425.00,'2023-02-10 07:50:19','',''),(5720,'1','302','1',1,'Retail Sale Id 5538',2208.00,0.00,0.00,3.00,255.00,'2023-02-10 07:51:56','',''),(5721,'1','302','1',1,'Retail Sale Id 5539',3996.48,0.00,0.00,5.43,461.55,'2023-02-10 07:54:10','',''),(5722,'1','302','1',1,'Retail Sale Id 5539',3996.48,0.00,0.00,5.43,461.55,'2023-02-10 07:54:10','',''),(5723,'1','302','1',1,'Retail Sale Id 5540',9200.00,0.00,0.00,12.50,1062.50,'2023-02-10 07:55:17','',''),(5724,'1','302','1',1,'Retail Sale Id 5541',2944.00,0.00,0.00,4.00,340.00,'2023-02-10 07:57:14','',''),(5725,'1','302','1',1,'Retail Sale Id 5542',3680.00,0.00,0.00,5.00,425.00,'2023-02-10 08:04:43','',''),(5726,'1','302','1',1,'Retail Sale Id 5543',4997.44,0.00,0.00,6.79,577.15,'2023-02-10 08:08:02','',''),(5727,'1','302','1',1,'Retail Sale Id 5544',4997.44,0.00,0.00,6.79,577.15,'2023-02-10 08:10:16','',''),(5728,'1','302','1',1,'Retail Sale Id 5545',1501.44,0.00,0.00,2.04,173.40,'2023-02-10 08:11:18','',''),(5729,'1','302','1',1,'Retail Sale Id 5546',3702.08,0.00,0.00,5.03,427.55,'2023-02-10 08:20:08','',''),(5730,'1','302','1',1,'Retail Sale Id 5547',3002.88,0.00,0.00,4.08,346.80,'2023-02-10 08:20:50','',''),(5731,'1','302','1',1,'Retail Sale Id 5548',2001.92,0.00,0.00,2.72,231.20,'2023-02-10 08:22:01','',''),(5732,'1','302','1',1,'Retail Sale Id 5549',9200.00,0.00,0.00,12.50,1062.50,'2023-02-10 08:23:25','',''),(5733,'1','302','1',1,'Retail Sale Id 5550',4416.00,0.00,0.00,6.00,510.00,'2023-02-10 08:24:59','',''),(5734,'1','302','1',1,'Retail Sale Id 5552',3503.36,0.00,0.00,4.76,404.60,'2023-02-10 08:27:54','',''),(5735,'1','302','1',1,'Retail Sale Id 5553',3002.88,0.00,0.00,4.08,346.80,'2023-02-10 08:29:17','',''),(5736,'1','302','1',1,'Retail Sale Id 5554',4416.00,0.00,0.00,6.00,510.00,'2023-02-10 08:32:09','',''),(5737,'1','302','1',1,'Retail Sale Id 5555',9200.00,0.00,0.00,12.50,1062.50,'2023-02-10 08:37:52','',''),(5738,'1','302','1',1,'Retail Sale Id 5556',802.24,0.00,0.00,1.09,92.65,'2023-02-10 08:41:47','',''),(5739,'1','302','1',1,'Retail Sale Id 5558',9200.00,0.00,0.00,12.50,1062.50,'2023-02-10 08:53:22','',''),(5740,'1','302','1',1,'Retail Sale Id 5559',3680.00,0.00,0.00,5.00,425.00,'2023-02-10 08:55:23','',''),(5741,'1','302','1',1,'Retail Sale Id 5560',2208.00,0.00,0.00,3.00,255.00,'2023-02-10 09:01:02','',''),(5742,'1','302','1',1,'Retail Sale Id 5561',2200.64,0.00,0.00,2.99,254.15,'2023-02-10 09:01:52','',''),(5743,'1','302','1',1,'Retail Sale Id 5562',3680.00,0.00,0.00,5.00,425.00,'2023-02-10 09:03:42','',''),(5744,'1','302','1',1,'Retail Sale Id 5563',3680.00,0.00,0.00,5.00,425.00,'2023-02-10 09:05:34','',''),(5745,'1','302','1',1,'Retail Sale Id 5564',4496.96,0.00,0.00,6.11,519.35,'2023-02-10 09:20:59','',''),(5746,'1','302','1',1,'Retail Sale Id 5565',85200.00,0.00,0.00,120.00,7080.00,'2023-02-10 09:23:13','',''),(5747,'1','302','1',1,'Retail Sale Id 5566',5998.40,0.00,0.00,8.15,692.75,'2023-02-10 09:25:08','',''),(5748,'1','302','1',1,'Retail Sale Id 5567',9200.00,0.00,0.00,12.50,1062.50,'2023-02-10 09:27:12','',''),(5749,'1','302','1',1,'Retail Sale Id 5568',3680.00,0.00,0.00,5.00,425.00,'2023-02-10 09:33:32','',''),(5750,'1','302','1',1,'Retail Sale Id 5569',1501.44,0.00,0.00,2.04,173.40,'2023-02-10 09:34:35','',''),(5751,'1','302','1',1,'Retail Sale Id 5570',1000.96,0.00,0.00,1.36,115.60,'2023-02-10 09:36:02','',''),(5752,'1','302','1',1,'Retail Sale Id 5571',4798.72,0.00,0.00,6.52,554.20,'2023-02-10 09:37:06','',''),(5753,'1','302','1',1,'Retail Sale Id 5572',2208.00,0.00,0.00,3.00,255.00,'2023-02-10 09:38:51','',''),(5754,'1','302','1',1,'Retail Sale Id 5572',9200.00,0.00,0.00,12.50,1062.50,'2023-02-10 09:38:51','',''),(5755,'1','302','1',1,'Retail Sale Id 5573',9200.00,0.00,0.00,12.50,1062.50,'2023-02-10 09:45:38','',''),(5756,'1','302','1',1,'Retail Sale Id 5574',1000.96,0.00,0.00,1.36,115.60,'2023-02-10 09:46:29','',''),(5757,'1','302','1',1,'Retail Sale Id 5575',2001.92,0.00,0.00,2.72,231.20,'2023-02-10 09:53:48','',''),(5758,'1','302','1',1,'Retail Sale Id 5576',3002.88,0.00,0.00,4.08,346.80,'2023-02-10 09:56:01','',''),(5759,'1','302','1',1,'Retail Sale Id 5577',4401.28,0.00,0.00,5.98,508.30,'2023-02-10 09:57:30','',''),(5760,'1','302','1',1,'Retail Sale Id 5578',1000.96,0.00,0.00,1.36,115.60,'2023-02-10 10:00:01','',''),(5761,'1','302','1',1,'Retail Sale Id 5579',1472.00,0.00,0.00,2.00,170.00,'2023-02-10 10:05:25','',''),(5762,'1','302','1',1,'Retail Sale Id 5580',9200.00,0.00,0.00,12.50,1062.50,'2023-02-10 10:08:01','',''),(5763,'1','302','1',1,'Retail Sale Id 5581',4416.00,0.00,0.00,6.00,510.00,'2023-02-10 10:15:33','',''),(5764,'1','302','1',1,'Retail Sale Id 5582',6999.36,0.00,0.00,9.51,808.35,'2023-02-10 10:17:26','',''),(5765,'1','302','1',1,'Retail Sale Id 5583',9200.00,0.00,0.00,12.50,1062.50,'2023-02-10 10:23:25','',''),(5766,'1','302','1',1,'Retail Sale Id 5584',2001.92,0.00,0.00,2.72,231.20,'2023-02-10 10:24:21','',''),(5767,'1','302','1',1,'Retail Sale Id 5585',4496.96,0.00,0.00,6.11,519.35,'2023-02-10 10:28:46','',''),(5768,'1','302','1',1,'Retail Sale Id 5586',2208.00,0.00,0.00,3.00,255.00,'2023-02-10 10:29:27','',''),(5769,'1','302','1',1,'Retail Sale Id 5587',3996.48,0.00,0.00,5.43,461.55,'2023-02-10 10:31:26','',''),(5770,'1','302','1',1,'Retail Sale Id 5588',9200.00,0.00,0.00,12.50,1062.50,'2023-02-10 10:37:12','',''),(5771,'1','302','1',1,'Retail Sale Id 5589',2944.00,0.00,0.00,4.00,340.00,'2023-02-10 10:39:20','',''),(5772,'1','302','1',1,'Retail Sale Id 5590',7360.00,0.00,0.00,10.00,850.00,'2023-02-10 10:43:46','',''),(5773,'1','302','1',1,'Retail Sale Id 5591',3680.00,0.00,0.00,5.00,425.00,'2023-02-10 10:45:16','',''),(5774,'1','302','1',1,'Retail Sale Id 5592',1000.96,0.00,0.00,1.36,115.60,'2023-02-10 10:46:09','',''),(5775,'1','302','1',1,'Retail Sale Id 5593',4416.00,0.00,0.00,6.00,510.00,'2023-02-10 10:49:52','',''),(5776,'1','302','1',1,'Retail Sale Id 5594',1000.96,0.00,0.00,1.36,115.60,'2023-02-10 10:51:56','',''),(5777,'1','302','1',1,'Retail Sale Id 5594',1000.96,0.00,0.00,1.36,115.60,'2023-02-10 10:51:56','',''),(5778,'1','302','1',1,'Retail Sale Id 5595',2701.12,0.00,0.00,3.67,311.95,'2023-02-10 11:00:26','',''),(5779,'1','302','1',1,'Retail Sale Id 5596',29820.00,0.00,0.00,42.00,2478.00,'2023-02-10 11:05:32','',''),(5780,'1','302','1',1,'Retail Sale Id 5597',4416.00,0.00,0.00,6.00,510.00,'2023-02-10 11:07:39','',''),(5781,'1','302','1',1,'Retail Sale Id 5598',3996.48,0.00,0.00,5.43,461.55,'2023-02-10 11:09:31','',''),(5782,'1','302','1',1,'Retail Sale Id 5599',8000.32,0.00,0.00,10.87,923.95,'2023-02-10 11:17:27','',''),(5783,'1','302','1',1,'Retail Sale Id 5600',3002.88,0.00,0.00,4.08,346.80,'2023-02-10 11:22:06','',''),(5784,'1','302','1',1,'Retail Sale Id 5601',11040.00,0.00,0.00,15.00,1275.00,'2023-02-10 11:28:15','',''),(5785,'1','302','1',1,'Retail Sale Id 5602',802.24,0.00,0.00,1.09,92.65,'2023-02-10 11:29:40','',''),(5786,'1','302','1',1,'Retail Sale Id 5603',2502.40,0.00,0.00,3.40,289.00,'2023-02-10 11:30:30','',''),(5787,'1','302','1',1,'Retail Sale Id 5604',2001.92,0.00,0.00,2.72,231.20,'2023-02-10 11:33:37','',''),(5788,'1','302','1',1,'Retail Sale Id 5605',9200.00,0.00,0.00,12.50,1062.50,'2023-02-10 11:35:07','',''),(5789,'1','302','1',1,'Retail Sale Id 5606',4496.96,0.00,0.00,6.11,519.35,'2023-02-10 11:38:10','',''),(5790,'1','302','1',1,'Retail Sale Id 5607',1501.44,0.00,0.00,2.04,173.40,'2023-02-10 11:39:45','',''),(5791,'1','302','1',1,'Retail Sale Id 5608',3996.48,0.00,0.00,5.43,461.55,'2023-02-10 11:40:56','',''),(5792,'1','302','1',1,'Retail Sale Id 5609',2502.40,0.00,0.00,3.40,289.00,'2023-02-10 11:44:47','',''),(5793,'1','302','1',1,'Retail Sale Id 5610',1501.44,0.00,0.00,2.04,173.40,'2023-02-10 11:58:35','',''),(5794,'1','302','1',1,'Retail Sale Id 5611',3680.00,0.00,0.00,5.00,425.00,'2023-02-10 11:59:58','',''),(5795,'1','302','1',1,'Retail Sale Id 5612',1000.96,0.00,0.00,1.36,115.60,'2023-02-10 12:00:39','',''),(5796,'1','302','1',1,'Retail Sale Id 5613',2001.92,0.00,0.00,2.72,231.20,'2023-02-10 12:01:29','',''),(5797,'1','302','1',1,'Retail Sale Id 5614',2208.00,0.00,0.00,3.00,255.00,'2023-02-10 12:05:02','',''),(5798,'1','302','1',1,'Retail Sale Id 5615',4416.00,0.00,0.00,6.00,510.00,'2023-02-10 12:09:42','',''),(5799,'1','302','1',1,'Retail Sale Id 5619',4494.30,0.00,0.00,6.33,373.47,'2023-02-10 12:14:31','',''),(5800,'1','302','1',1,'Retail Sale Id 5620',3680.00,0.00,0.00,5.00,425.00,'2023-02-10 12:17:24','',''),(5801,'1','302','1',1,'Retail Sale Id 5621',2944.00,0.00,0.00,4.00,340.00,'2023-02-10 12:19:17','',''),(5802,'1','302','1',1,'Retail Sale Id 5622',6390.00,0.00,0.00,9.00,531.00,'2023-02-10 12:20:57','',''),(5803,'1','302','1',1,'Retail Sale Id 5623',3996.48,0.00,0.00,5.43,461.55,'2023-02-10 12:22:42','',''),(5804,'1','302','1',1,'Retail Sale Id 5624',1501.44,0.00,0.00,2.04,173.40,'2023-02-10 12:25:40','',''),(5805,'1','302','1',1,'Retail Sale Id 5625',7100.00,0.00,0.00,10.00,590.00,'2023-02-10 12:27:06','',''),(5806,'1','302','1',1,'Retail Sale Id 5626',9597.44,0.00,0.00,13.04,1108.40,'2023-02-10 12:28:03','',''),(5807,'1','302','1',1,'Retail Sale Id 5627',17750.00,0.00,0.00,25.00,1475.00,'2023-02-10 12:30:09','',''),(5808,'1','302','1',1,'Retail Sale Id 5628',6999.36,0.00,0.00,9.51,808.35,'2023-02-10 12:43:20','',''),(5809,'1','302','1',1,'Retail Sale Id 5629',2208.00,0.00,0.00,3.00,255.00,'2023-02-10 12:46:35','',''),(5810,'1','302','1',1,'Retail Sale Id 5629',2208.00,0.00,0.00,3.00,255.00,'2023-02-10 12:46:35','',''),(5811,'1','302','1',1,'Retail Sale Id 5630',3503.36,0.00,0.00,4.76,404.60,'2023-02-10 12:47:57','',''),(5812,'1','302','1',1,'Retail Sale Id 5631',4997.44,0.00,0.00,6.79,577.15,'2023-02-10 12:49:12','',''),(5813,'1','302','1',1,'Retail Sale Id 5632',3996.48,0.00,0.00,5.43,461.55,'2023-02-10 12:50:37','',''),(5814,'1','302','1',1,'Retail Sale Id 5633',9200.00,0.00,0.00,12.50,1062.50,'2023-02-10 12:52:06','',''),(5815,'1','302','1',1,'Retail Sale Id 5634',6631.36,0.00,0.00,9.01,765.85,'2023-02-10 12:55:18','',''),(5816,'1','302','1',1,'Retail Sale Id 5635',7499.84,0.00,0.00,10.19,866.15,'2023-02-10 12:59:39','',''),(5817,'1','302','1',1,'Retail Sale Id 5636',1000.96,0.00,0.00,1.36,115.60,'2023-02-10 13:56:56','',''),(5818,'1','302','1',1,'Retail Sale Id 5637',2001.92,0.00,0.00,2.72,231.20,'2023-02-10 13:58:22','',''),(5819,'1','302','1',1,'Retail Sale Id 5638',8096.00,0.00,0.00,11.00,935.00,'2023-02-10 14:00:02','',''),(5820,'1','302','1',1,'Retail Sale Id 5639',3996.48,0.00,0.00,5.43,461.55,'2023-02-10 14:02:31','',''),(5821,'1','302','1',1,'Retail Sale Id 5640',3996.48,0.00,0.00,5.43,461.55,'2023-02-10 14:05:09','',''),(5822,'1','302','1',1,'Retail Sale Id 5641',2502.40,0.00,0.00,3.40,289.00,'2023-02-10 14:12:51','',''),(5823,'1','302','1',1,'Retail Sale Id 5642',4416.00,0.00,0.00,6.00,510.00,'2023-02-10 14:14:09','',''),(5824,'1','302','1',1,'Retail Sale Id 5643',2208.00,0.00,0.00,3.00,255.00,'2023-02-10 14:19:29','',''),(5825,'1','302','1',1,'Retail Sale Id 5644',9200.00,0.00,0.00,12.50,1062.50,'2023-02-10 14:20:56','',''),(5826,'1','302','1',1,'Retail Sale Id 5645',9200.00,0.00,0.00,12.50,1062.50,'2023-02-10 14:27:48','',''),(5827,'1','302','1',1,'Retail Sale Id 5645',9200.00,0.00,0.00,12.50,1062.50,'2023-02-10 14:27:48','',''),(5828,'1','302','1',1,'Retail Sale Id 5646',9200.00,0.00,0.00,12.50,1062.50,'2023-02-10 14:30:11','',''),(5829,'1','302','1',1,'Retail Sale Id 5647',4416.00,0.00,0.00,6.00,510.00,'2023-02-10 14:32:04','',''),(5830,'1','302','1',1,'Retail Sale Id 5648',2208.00,0.00,0.00,3.00,255.00,'2023-02-10 14:39:06','',''),(5831,'1','302','1',1,'Retail Sale Id 5649',9200.00,0.00,0.00,12.50,1062.50,'2023-02-10 14:40:24','',''),(5832,'1','302','1',1,'Retail Sale Id 5650',3002.88,0.00,0.00,4.08,346.80,'2023-02-10 14:41:34','',''),(5833,'1','302','1',1,'Retail Sale Id 5651',7360.00,0.00,0.00,10.00,850.00,'2023-02-10 14:51:37','',''),(5834,'1','302','1',1,'Retail Sale Id 5651',9200.00,0.00,0.00,12.50,1062.50,'2023-02-10 14:51:37','',''),(5835,'1','302','1',1,'Retail Sale Id 5652',5152.00,0.00,0.00,7.00,595.00,'2023-02-10 14:56:12','',''),(5836,'1','302','1',1,'Retail Sale Id 5653',4416.00,0.00,0.00,6.00,510.00,'2023-02-10 14:57:37','',''),(5837,'1','302','1',1,'Retail Sale Id 5654',35500.00,0.00,0.00,50.00,2950.00,'2023-02-10 15:05:54','',''),(5838,'1','302','1',1,'Retail Sale Id 5655',9200.00,0.00,0.00,12.50,1062.50,'2023-02-10 15:08:08','',''),(5839,'1','302','1',1,'Retail Sale Id 5656',9200.00,0.00,0.00,12.50,1062.50,'2023-02-10 15:09:12','',''),(5840,'1','302','1',1,'Retail Sale Id 5657',9200.00,0.00,0.00,12.50,1062.50,'2023-02-10 15:27:25','',''),(5841,'1','302','1',1,'Retail Sale Id 5658',7360.00,0.00,0.00,10.00,850.00,'2023-02-10 15:28:07','',''),(5842,'1','302','1',1,'Retail Sale Id 5659',3680.00,0.00,0.00,5.00,425.00,'2023-02-10 15:29:02','',''),(5843,'1','302','1',1,'Retail Sale Id 5660',2001.92,0.00,0.00,2.72,231.20,'2023-02-10 15:29:47','',''),(5844,'1','302','1',1,'Retail Sale Id 5661',2208.00,0.00,0.00,3.00,255.00,'2023-02-10 15:30:50','',''),(5845,'1','302','1',1,'Retail Sale Id 5662',3002.88,0.00,0.00,4.08,346.80,'2023-02-10 15:32:15','',''),(5846,'1','302','1',1,'Retail Sale Id 5663',1501.44,0.00,0.00,2.04,173.40,'2023-02-10 15:37:30','',''),(5847,'1','302','1',1,'Retail Sale Id 5663',1501.44,0.00,0.00,2.04,173.40,'2023-02-10 15:37:30','',''),(5848,'1','302','1',1,'Retail Sale Id 5664',14.72,0.00,0.00,0.02,1.70,'2023-02-10 15:41:48','',''),(5849,'1','302','1',1,'Retail Sale Id 5665',9200.00,0.00,0.00,12.50,1062.50,'2023-02-10 15:42:50','',''),(5850,'1','302','1',1,'Retail Sale Id 5666',9200.00,0.00,0.00,12.50,1062.50,'2023-02-10 15:48:50','',''),(5851,'1','302','1',1,'Retail Sale Id 5667',9200.00,0.00,0.00,12.50,1062.50,'2023-02-10 16:01:00','',''),(5852,'1','302','1',1,'Retail Sale Id 5668',4416.00,0.00,0.00,6.00,510.00,'2023-02-10 16:03:02','',''),(5853,'1','302','1',1,'Retail Sale Id 5669',2200.64,0.00,0.00,2.99,254.15,'2023-02-10 16:11:05','',''),(5854,'1','302','1',1,'Retail Sale Id 5670',2208.00,0.00,0.00,3.00,255.00,'2023-02-10 16:30:28','',''),(5855,'1','302','1',1,'Retail Sale Id 5670',9200.00,0.00,0.00,12.50,1062.50,'2023-02-10 16:30:28','',''),(5856,'1','302','1',1,'Retail Sale Id 5671',4416.00,0.00,0.00,6.00,510.00,'2023-02-10 16:33:27','',''),(5857,'1','302','1',1,'Retail Sale Id 5672',9200.00,0.00,0.00,12.50,1062.50,'2023-02-10 16:34:21','',''),(5858,'1','302','1',1,'Retail Sale Id 5673',2208.00,0.00,0.00,3.00,255.00,'2023-02-10 16:38:44','',''),(5859,'1','302','1',1,'Retail Sale Id 5675',2789.44,0.00,0.00,3.79,322.15,'2023-02-10 16:41:10','',''),(5860,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,66551.73,102.23,0.00,0.00,'2023-02-10 18:08:10','',''),(5861,'1','302',NULL,1,'Reception corrector for bridging 35',0.00,0.00,0.00,102.23,0.00,'2023-02-10 18:17:02','',''),(5862,'1','302','1',1,'Received from bridging 35',0.00,0.00,102.23,0.00,0.00,'2023-02-10 18:17:02','',''),(5863,'1','302','1',1,'Retail Sale Id 5676',75241.28,0.00,0.00,102.23,8689.55,'2023-02-10 18:19:38','',''),(5864,'1','302','1',1,'Return of Retail Sale Id 5676',0.00,75241.28,102.23,0.00,-8689.55,'2023-02-10 18:27:25','',''),(5865,'1','302','1',1,'Retail Sale Id 5677',53250.00,0.00,0.00,75.00,4425.00,'2023-02-10 18:28:19','',''),(5866,'1','302','1',1,'Retail Sale Id 5679',17303.36,0.00,0.00,23.51,1998.35,'2023-02-10 18:30:29','',''),(5867,'1','302','1',1,'Retail Sale Id 5680',2347.84,0.00,0.00,3.19,271.15,'2023-02-10 18:31:56','',''),(5868,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3515400.00,5400.00,0.00,0.00,'2023-02-10 18:40:09','',''),(5869,'1','302',NULL,1,'Reception corrector for bridging 36',0.00,0.00,0.00,5400.00,0.00,'2023-02-10 18:42:35','',''),(5870,'1','302','1',1,'Received from bridging 36',0.00,0.00,5400.00,0.00,0.00,'2023-02-10 18:42:35','',''),(5871,'1','302','1',1,'Retail Sale Id 5681',4416.00,0.00,0.00,6.00,510.00,'2023-02-11 08:00:22','',''),(5872,'1','302','1',1,'Retail Sale Id 5681',7360.00,0.00,0.00,10.00,850.00,'2023-02-11 08:00:22','',''),(5873,'1','302','1',1,'Retail Sale Id 5682',4416.00,0.00,0.00,6.00,510.00,'2023-02-11 08:24:13','',''),(5874,'1','302','1',1,'Retail Sale Id 5683',2001.92,0.00,0.00,2.72,231.20,'2023-02-11 08:29:24','',''),(5875,'1','302','1',1,'Retail Sale Id 5684',2208.00,0.00,0.00,3.00,255.00,'2023-02-11 08:33:07','',''),(5876,'1','302','1',1,'Retail Sale Id 5685',2222.72,0.00,0.00,3.02,256.70,'2023-02-11 08:34:19','',''),(5877,'1','302','1',1,'Retail Sale Id 5686',3680.00,0.00,0.00,5.00,425.00,'2023-02-11 08:39:54','',''),(5878,'1','302','1',1,'Retail Sale Id 5687',5152.00,0.00,0.00,7.00,595.00,'2023-02-11 08:42:26','',''),(5879,'1','302','1',1,'Retail Sale Id 5688',7396.80,0.00,0.00,10.05,854.25,'2023-02-11 08:44:36','',''),(5880,'1','302','1',1,'Retail Sale Id 5689',2208.00,0.00,0.00,3.00,255.00,'2023-02-11 08:53:26','',''),(5881,'1','302','1',1,'Retail Sale Id 5689',3680.00,0.00,0.00,5.00,425.00,'2023-02-11 08:53:26','',''),(5882,'1','302','1',1,'Retail Sale Id 5690',9200.00,0.00,0.00,12.50,1062.50,'2023-02-11 08:54:55','',''),(5883,'1','302','1',1,'Retail Sale Id 5691',1251.20,0.00,0.00,1.70,144.50,'2023-02-11 08:57:33','',''),(5884,'1','302','1',1,'Retail Sale Id 5692',4416.00,0.00,0.00,6.00,510.00,'2023-02-11 09:00:38','',''),(5885,'1','302','1',1,'Retail Sale Id 5693',2200.64,0.00,0.00,2.99,254.15,'2023-02-11 09:02:47','',''),(5886,'1','302','1',1,'Retail Sale Id 5694',49996.48,0.00,0.00,67.93,5774.05,'2023-02-11 09:04:22','',''),(5887,'1','302','1',1,'Retail Sale Id 5695',1199.68,0.00,0.00,1.63,138.55,'2023-02-11 09:05:27','',''),(5888,'1','302','1',1,'Retail Sale Id 5696',2001.92,0.00,0.00,2.72,231.20,'2023-02-11 09:08:37','',''),(5889,'1','302','1',1,'Retail Sale Id 5697',2208.00,0.00,0.00,3.00,255.00,'2023-02-11 09:23:58','',''),(5890,'1','302','1',1,'Retail Sale Id 5698',9200.00,0.00,0.00,12.50,1062.50,'2023-02-11 09:27:10','',''),(5891,'1','302','1',1,'Retail Sale Id 5699',9200.00,0.00,0.00,12.50,1062.50,'2023-02-11 09:29:20','',''),(5892,'1','302','1',1,'Retail Sale Id 5700',2001.92,0.00,0.00,2.72,231.20,'2023-02-11 09:42:18','',''),(5893,'1','302','1',1,'Retail Sale Id 5701',204125.00,0.00,0.00,287.50,16962.50,'2023-02-11 09:48:12','',''),(5894,'1','302','1',1,'Retail Sale Id 5702',9200.00,0.00,0.00,12.50,1062.50,'2023-02-11 09:51:33','',''),(5895,'1','302','1',1,'Retail Sale Id 5704',1501.44,0.00,0.00,2.04,173.40,'2023-02-11 09:53:08','',''),(5896,'1','302','1',1,'Retail Sale Id 5705',2208.00,0.00,0.00,3.00,255.00,'2023-02-11 09:54:40','',''),(5897,'1','302','1',1,'Retail Sale Id 5706',4416.00,0.00,0.00,6.00,510.00,'2023-02-11 09:55:48','',''),(5898,'1','302','1',1,'Retail Sale Id 5707',4416.00,0.00,0.00,6.00,510.00,'2023-02-11 09:56:17','',''),(5899,'1','302','1',1,'Retail Sale Id 5708',4416.00,0.00,0.00,6.00,510.00,'2023-02-11 09:56:49','',''),(5900,'1','302','1',1,'Retail Sale Id 5709',4416.00,0.00,0.00,6.00,510.00,'2023-02-11 09:57:22','',''),(5901,'1','302','1',1,'Retail Sale Id 5710',4416.00,0.00,0.00,6.00,510.00,'2023-02-11 09:57:52','',''),(5902,'1','302','1',1,'Retail Sale Id 5711',9200.00,0.00,0.00,12.50,1062.50,'2023-02-11 09:58:43','',''),(5903,'1','302','1',1,'Retail Sale Id 5712',9200.00,0.00,0.00,12.50,1062.50,'2023-02-11 09:59:07','',''),(5904,'1','302','1',1,'Retail Sale Id 5713',9200.00,0.00,0.00,12.50,1062.50,'2023-02-11 09:59:56','',''),(5905,'1','302','1',1,'Retail Sale Id 5714',2208.00,0.00,0.00,3.00,255.00,'2023-02-11 10:00:29','',''),(5906,'1','302','1',1,'Retail Sale Id 5715',2208.00,0.00,0.00,3.00,255.00,'2023-02-11 10:01:02','',''),(5907,'1','302','1',1,'Retail Sale Id 5716',1000.96,0.00,0.00,1.36,115.60,'2023-02-11 10:01:55','',''),(5908,'1','302','1',1,'Retail Sale Id 5717',4416.00,0.00,0.00,6.00,510.00,'2023-02-11 10:07:40','',''),(5909,'1','302','1',1,'Retail Sale Id 5717',9200.00,0.00,0.00,12.50,1062.50,'2023-02-11 10:07:40','',''),(5910,'1','302','1',1,'Retail Sale Id 5718',2001.92,0.00,0.00,2.72,231.20,'2023-02-11 10:15:05','',''),(5911,'1','302','1',1,'Retail Sale Id 5720',3680.00,0.00,0.00,5.00,425.00,'2023-02-11 10:23:25','',''),(5912,'1','302','1',1,'Retail Sale Id 5721',2001.92,0.00,0.00,2.72,231.20,'2023-02-11 10:24:15','',''),(5913,'1','302','1',1,'Retail Sale Id 5722',3680.00,0.00,0.00,5.00,425.00,'2023-02-11 10:32:13','',''),(5914,'1','302','1',1,'Retail Sale Id 5723',3680.00,0.00,0.00,5.00,425.00,'2023-02-11 10:32:35','',''),(5915,'1','302','1',1,'Retail Sale Id 5724',699.20,0.00,0.00,0.95,80.75,'2023-02-11 10:44:50','',''),(5916,'1','302','1',1,'Retail Sale Id 5725',35500.00,0.00,0.00,50.00,2950.00,'2023-02-11 10:49:48','',''),(5917,'1','302','1',1,'Retail Sale Id 5726',4997.44,0.00,0.00,6.79,577.15,'2023-02-11 10:51:36','',''),(5918,'1','302','1',1,'Retail Sale Id 5727',3002.88,0.00,0.00,4.08,346.80,'2023-02-11 10:52:44','',''),(5919,'1','302','1',1,'Retail Sale Id 5728',500.48,0.00,0.00,0.68,57.80,'2023-02-11 10:58:54','',''),(5920,'1','302','1',1,'Retail Sale Id 5729',8096.00,0.00,0.00,11.00,935.00,'2023-02-11 11:09:36','',''),(5921,'1','302','1',1,'Retail Sale Id 5730',2001.92,0.00,0.00,2.72,231.20,'2023-02-11 11:11:22','',''),(5922,'1','302','1',1,'Retail Sale Id 5730',2001.92,0.00,0.00,2.72,231.20,'2023-02-11 11:11:22','',''),(5923,'1','302','1',1,'Retail Sale Id 5731',1501.44,0.00,0.00,2.04,173.40,'2023-02-11 11:13:16','',''),(5924,'1','302','1',1,'Retail Sale Id 5732',2208.00,0.00,0.00,3.00,255.00,'2023-02-11 11:14:23','',''),(5925,'1','302','1',1,'Retail Sale Id 5733',2208.00,0.00,0.00,3.00,255.00,'2023-02-11 11:14:50','',''),(5926,'1','302','1',1,'Retail Sale Id 5734',2208.00,0.00,0.00,3.00,255.00,'2023-02-11 11:15:31','',''),(5927,'1','302','1',1,'Retail Sale Id 5735',1000.96,0.00,0.00,1.36,115.60,'2023-02-11 11:16:33','',''),(5928,'1','302','1',1,'Retail Sale Id 5736',9200.00,0.00,0.00,12.50,1062.50,'2023-02-11 11:17:35','',''),(5929,'1','302','1',1,'Retail Sale Id 5737',14200.00,0.00,0.00,20.00,1180.00,'2023-02-11 11:25:02','',''),(5930,'1','302','1',1,'Retail Sale Id 5738',2208.00,0.00,0.00,3.00,255.00,'2023-02-11 11:30:54','',''),(5931,'1','302','1',1,'Retail Sale Id 5739',2208.00,0.00,0.00,3.00,255.00,'2023-02-11 11:31:32','',''),(5932,'1','302','1',1,'Retail Sale Id 5740',2208.00,0.00,0.00,3.00,255.00,'2023-02-11 11:32:08','',''),(5933,'1','302','1',1,'Retail Sale Id 5741',9200.00,0.00,0.00,12.50,1062.50,'2023-02-11 11:32:49','',''),(5934,'1','302','1',1,'Retail Sale Id 5742',35500.00,0.00,0.00,50.00,2950.00,'2023-02-11 11:38:40','',''),(5935,'1','302','1',1,'Retail Sale Id 5743',3002.88,0.00,0.00,4.08,346.80,'2023-02-11 11:43:14','',''),(5936,'1','302','1',1,'Retail Sale Id 5744',3680.00,0.00,0.00,5.00,425.00,'2023-02-11 11:59:09','',''),(5937,'1','302','1',1,'Retail Sale Id 5744',4416.00,0.00,0.00,6.00,510.00,'2023-02-11 11:59:09','',''),(5938,'1','302','1',1,'Retail Sale Id 5745',3002.88,0.00,0.00,4.08,346.80,'2023-02-11 12:00:28','',''),(5939,'1','302','1',1,'Retail Sale Id 5746',4496.96,0.00,0.00,6.11,519.35,'2023-02-11 12:02:40','',''),(5940,'1','302','1',1,'Retail Sale Id 5747',3002.88,0.00,0.00,4.08,346.80,'2023-02-11 12:05:15','',''),(5941,'1','302','1',1,'Retail Sale Id 5748',4416.00,0.00,0.00,6.00,510.00,'2023-02-11 12:27:19','',''),(5942,'1','302','1',1,'Retail Sale Id 5748',4416.00,0.00,0.00,6.00,510.00,'2023-02-11 12:27:19','',''),(5943,'1','302','1',1,'Retail Sale Id 5749',1479.36,0.00,0.00,2.01,170.85,'2023-02-11 12:30:01','',''),(5944,'1','302','1',1,'Retail Sale Id 5750',4997.44,0.00,0.00,6.79,577.15,'2023-02-11 12:31:05','',''),(5945,'1','302','1',1,'Retail Sale Id 5750',8000.32,0.00,0.00,10.87,923.95,'2023-02-11 12:31:05','',''),(5946,'1','302','1',1,'Retail Sale Id 5751',4977.10,0.00,0.00,7.01,413.59,'2023-02-11 12:33:49','',''),(5947,'1','302','1',1,'Retail Sale Id 5752',5152.00,0.00,0.00,7.00,595.00,'2023-02-11 12:37:08','',''),(5948,'1','302','1',1,'Retail Sale Id 5754',500.48,0.00,0.00,0.68,57.80,'2023-02-11 12:37:53','',''),(5949,'1','302','1',1,'Retail Sale Id 5755',9200.00,0.00,0.00,12.50,1062.50,'2023-02-11 12:39:14','',''),(5950,'1','302','1',1,'Retail Sale Id 5756',7360.00,0.00,0.00,10.00,850.00,'2023-02-11 12:41:58','',''),(5951,'1','302','1',1,'Retail Sale Id 5757',9200.00,0.00,0.00,12.50,1062.50,'2023-02-11 12:44:31','',''),(5952,'1','302','1',1,'Retail Sale Id 5758',3002.88,0.00,0.00,4.08,346.80,'2023-02-11 12:49:29','',''),(5953,'1','302','1',1,'Retail Sale Id 5759',4452.80,0.00,0.00,6.05,514.25,'2023-02-11 12:53:33','',''),(5954,'1','302','1',1,'Retail Sale Id 5760',7810.00,0.00,0.00,11.00,649.00,'2023-02-11 12:57:22','',''),(5955,'1','302','1',1,'Retail Sale Id 5761',4416.00,0.00,0.00,6.00,510.00,'2023-02-11 12:58:42','',''),(5956,'1','302','1',1,'Retail Sale Id 5762',4416.00,0.00,0.00,6.00,510.00,'2023-02-11 12:59:52','',''),(5957,'1','302','1',1,'Retail Sale Id 5763',2001.92,0.00,0.00,2.72,231.20,'2023-02-11 13:04:21','',''),(5958,'1','302','1',1,'Retail Sale Id 5764',2208.00,0.00,0.00,3.00,255.00,'2023-02-11 13:09:09','',''),(5959,'1','302','1',1,'Retail Sale Id 5764',2208.00,0.00,0.00,3.00,255.00,'2023-02-11 13:09:09','',''),(5960,'1','302','1',1,'Retail Sale Id 5764',2208.00,0.00,0.00,3.00,255.00,'2023-02-11 13:09:09','',''),(5961,'1','302','1',1,'Retail Sale Id 5765',3002.88,0.00,0.00,4.08,346.80,'2023-02-11 13:10:52','',''),(5962,'1','302','1',1,'Retail Sale Id 5766',2001.92,0.00,0.00,2.72,231.20,'2023-02-11 13:11:34','',''),(5963,'1','302','1',1,'Retail Sale Id 5767',7360.00,0.00,0.00,10.00,850.00,'2023-02-11 13:18:06','',''),(5964,'1','302','1',1,'Retail Sale Id 5768',9200.00,0.00,0.00,12.50,1062.50,'2023-02-11 13:19:51','',''),(5965,'1','302','1',1,'Retail Sale Id 5770',2208.00,0.00,0.00,3.00,255.00,'2023-02-11 13:21:30','',''),(5966,'1','302','1',1,'Retail Sale Id 5771',1840.00,0.00,0.00,2.50,212.50,'2023-02-11 13:22:22','',''),(5967,'1','302','1',1,'Retail Sale Id 5773',1472.00,0.00,0.00,2.00,170.00,'2023-02-11 13:23:34','',''),(5968,'1','302','1',1,'Retail Sale Id 5775',4496.96,0.00,0.00,6.11,519.35,'2023-02-11 13:24:54','',''),(5969,'1','302','1',1,'Retail Sale Id 5776',4997.44,0.00,0.00,6.79,577.15,'2023-02-11 13:32:16','',''),(5970,'1','302','1',1,'Retail Sale Id 5777',8520.00,0.00,0.00,12.00,708.00,'2023-02-11 13:33:47','',''),(5971,'1','302','1',1,'Retail Sale Id 5778',3680.00,0.00,0.00,5.00,425.00,'2023-02-11 13:40:31','',''),(5972,'1','302','1',1,'Retail Sale Id 5779',710.00,0.00,0.00,1.00,59.00,'2023-02-11 13:44:58','',''),(5973,'1','302','1',1,'Retail Sale Id 5780',3996.48,0.00,0.00,5.43,461.55,'2023-02-11 13:48:44','',''),(5974,'1','302','1',1,'Retail Sale Id 5781',4997.44,0.00,0.00,6.79,577.15,'2023-02-11 13:51:29','',''),(5975,'1','302','1',1,'Retail Sale Id 5782',1000.96,0.00,0.00,1.36,115.60,'2023-02-11 13:53:01','',''),(5976,'1','302','1',1,'Retail Sale Id 5783',5152.00,0.00,0.00,7.00,595.00,'2023-02-11 13:54:27','',''),(5977,'1','302','1',1,'Retail Sale Id 5784',2001.92,0.00,0.00,2.72,231.20,'2023-02-11 13:55:39','',''),(5978,'1','302','1',1,'Retail Sale Id 5785',9200.00,0.00,0.00,12.50,1062.50,'2023-02-11 13:57:07','',''),(5979,'1','302','1',1,'Retail Sale Id 5786',17750.00,0.00,0.00,25.00,1475.00,'2023-02-11 13:59:42','',''),(5980,'1','302','1',1,'Retail Sale Id 5787',1472.00,0.00,0.00,2.00,170.00,'2023-02-11 14:04:09','',''),(5981,'1','302','1',1,'Retail Sale Id 5788',500.48,0.00,0.00,0.68,57.80,'2023-02-11 14:20:54','',''),(5982,'1','302','1',1,'Retail Sale Id 5789',3680.00,0.00,0.00,5.00,425.00,'2023-02-11 14:25:00','',''),(5983,'1','302','1',1,'Retail Sale Id 5790',2001.92,0.00,0.00,2.72,231.20,'2023-02-11 14:27:21','',''),(5984,'1','302','1',1,'Retail Sale Id 5791',3680.00,0.00,0.00,5.00,425.00,'2023-02-11 14:33:01','',''),(5985,'1','302','1',1,'Retail Sale Id 5791',4416.00,0.00,0.00,6.00,510.00,'2023-02-11 14:33:01','',''),(5986,'1','302','1',1,'Retail Sale Id 5791',9200.00,0.00,0.00,12.50,1062.50,'2023-02-11 14:33:01','',''),(5987,'1','302','1',1,'Retail Sale Id 5791',9200.00,0.00,0.00,12.50,1062.50,'2023-02-11 14:33:01','',''),(5988,'1','302','1',1,'Retail Sale Id 5791',9200.00,0.00,0.00,12.50,1062.50,'2023-02-11 14:33:01','',''),(5989,'1','302','1',1,'Retail Sale Id 5792',4416.00,0.00,0.00,6.00,510.00,'2023-02-11 14:36:07','',''),(5990,'1','302','1',1,'Retail Sale Id 5793',1803.20,0.00,0.00,2.45,208.25,'2023-02-11 14:36:56','',''),(5991,'1','302','1',1,'Retail Sale Id 5794',736.00,0.00,0.00,1.00,85.00,'2023-02-11 14:38:37','',''),(5992,'1','302','1',1,'Retail Sale Id 5794',1000.96,0.00,0.00,1.36,115.60,'2023-02-11 14:38:37','',''),(5993,'1','302','1',1,'Retail Sale Id 5795',11040.00,0.00,0.00,15.00,1275.00,'2023-02-11 14:39:49','',''),(5994,'1','302','1',1,'Retail Sale Id 5796',4496.96,0.00,0.00,6.11,519.35,'2023-02-11 14:42:02','',''),(5995,'1','302','1',1,'Retail Sale Id 5797',9200.00,0.00,0.00,12.50,1062.50,'2023-02-11 14:43:11','',''),(5996,'1','302','1',1,'Retail Sale Id 5798',2001.92,0.00,0.00,2.72,231.20,'2023-02-11 14:54:15','',''),(5997,'1','302','1',1,'Retail Sale Id 5799',4496.96,0.00,0.00,6.11,519.35,'2023-02-11 14:59:48','',''),(5998,'1','302','1',1,'Retail Sale Id 5800',2208.00,0.00,0.00,3.00,255.00,'2023-02-11 15:01:58','',''),(5999,'1','302','1',1,'Retail Sale Id 5800',4997.44,0.00,0.00,6.79,577.15,'2023-02-11 15:01:58','',''),(6000,'1','302','1',1,'Retail Sale Id 5801',2208.00,0.00,0.00,3.00,255.00,'2023-02-11 15:05:04','',''),(6001,'1','302','1',1,'Retail Sale Id 5802',3680.00,0.00,0.00,5.00,425.00,'2023-02-11 15:11:00','',''),(6002,'1','302','1',1,'Retail Sale Id 5803',71000.00,0.00,0.00,100.00,5900.00,'2023-02-11 15:14:54','',''),(6003,'1','302','1',1,'Retail Sale Id 5804',3996.48,0.00,0.00,5.43,461.55,'2023-02-11 15:22:15','',''),(6004,'1','302','1',1,'Retail Sale Id 5805',2208.00,0.00,0.00,3.00,255.00,'2023-02-11 15:44:51','',''),(6005,'1','302','1',1,'Retail Sale Id 5806',1501.44,0.00,0.00,2.04,173.40,'2023-02-11 15:48:52','',''),(6006,'1','302','1',1,'Retail Sale Id 5807',2208.00,0.00,0.00,3.00,255.00,'2023-02-11 15:50:11','',''),(6007,'1','302','1',1,'Retail Sale Id 5808',3680.00,0.00,0.00,5.00,425.00,'2023-02-11 15:56:31','',''),(6008,'1','302','1',1,'Retail Sale Id 5809',9200.00,0.00,0.00,12.50,1062.50,'2023-02-11 15:57:47','',''),(6009,'1','302','1',1,'Retail Sale Id 5810',2001.92,0.00,0.00,2.72,231.20,'2023-02-11 16:50:14','',''),(6010,'1','302','1',1,'Retail Sale Id 5811',1000.96,0.00,0.00,1.36,115.60,'2023-02-11 16:51:16','',''),(6011,'1','302','1',1,'Retail Sale Id 5812',11201.92,0.00,0.00,15.22,1293.70,'2023-02-11 16:52:09','',''),(6012,'1','302','1',1,'Retail Sale Id 5813',2208.00,0.00,0.00,3.00,255.00,'2023-02-11 16:59:29','',''),(6013,'1','302','1',1,'Retail Sale Id 5814',1000.96,0.00,0.00,1.36,115.60,'2023-02-11 17:05:26','',''),(6014,'1','302','1',1,'Retail Sale Id 5815',4416.00,0.00,0.00,6.00,510.00,'2023-02-11 17:07:36','',''),(6015,'1','302','1',1,'Retail Sale Id 5816',2208.00,0.00,0.00,3.00,255.00,'2023-02-11 17:08:56','',''),(6016,'1','302','1',1,'Retail Sale Id 5817',2208.00,0.00,0.00,3.00,255.00,'2023-02-11 17:13:37','',''),(6017,'1','302','1',1,'Retail Sale Id 5818',2001.92,0.00,0.00,2.72,231.20,'2023-02-11 17:16:21','',''),(6018,'1','302','1',1,'Retail Sale Id 5819',2200.64,0.00,0.00,2.99,254.15,'2023-02-11 17:20:41','',''),(6019,'1','302','1',1,'Retail Sale Id 5820',2502.40,0.00,0.00,3.40,289.00,'2023-02-11 17:22:32','',''),(6020,'1','302','1',1,'Retail Sale Id 5821',4416.00,0.00,0.00,6.00,510.00,'2023-02-11 17:24:23','',''),(6021,'1','302','1',1,'Retail Sale Id 5822',2208.00,0.00,0.00,3.00,255.00,'2023-02-11 17:28:20','',''),(6022,'1','302','1',1,'Retail Sale Id 5823',4416.00,0.00,0.00,6.00,510.00,'2023-02-11 17:31:09','',''),(6023,'1','302','1',1,'Retail Sale Id 5824',9200.00,0.00,0.00,12.50,1062.50,'2023-02-11 17:32:47','',''),(6024,'1','302','1',1,'Retail Sale Id 5825',6999.36,0.00,0.00,9.51,808.35,'2023-02-11 17:35:22','',''),(6025,'1','302','1',1,'Retail Sale Id 5826',3680.00,0.00,0.00,5.00,425.00,'2023-02-11 17:42:38','',''),(6026,'1','302','1',1,'Retail Sale Id 5826',5888.00,0.00,0.00,8.00,680.00,'2023-02-11 17:42:38','',''),(6027,'1','302','1',1,'Retail Sale Id 5827',2001.92,0.00,0.00,2.72,231.20,'2023-02-11 17:44:26','',''),(6028,'1','302','1',1,'Retail Sale Id 5828',3550.00,0.00,0.00,5.00,295.00,'2023-02-11 17:47:11','',''),(6029,'1','302','1',1,'Retail Sale Id 5829',3680.00,0.00,0.00,5.00,425.00,'2023-02-11 17:48:30','',''),(6030,'1','302','1',1,'Retail Sale Id 5830',3680.00,0.00,0.00,5.00,425.00,'2023-02-11 17:49:31','',''),(6031,'1','302','1',1,'Retail Sale Id 5831',9200.00,0.00,0.00,12.50,1062.50,'2023-02-11 17:50:32','',''),(6032,'1','302','1',1,'Retail Sale Id 5832',9200.00,0.00,0.00,12.50,1062.50,'2023-02-11 17:52:05','',''),(6033,'1','302','1',1,'Retail Sale Id 5833',4997.44,0.00,0.00,6.79,577.15,'2023-02-11 17:57:06','',''),(6034,'1','302','1',1,'Retail Sale Id 5834',3680.00,0.00,0.00,5.00,425.00,'2023-02-11 17:59:11','',''),(6035,'1','302','1',1,'Retail Sale Id 5835',3996.48,0.00,0.00,5.43,461.55,'2023-02-11 18:01:13','',''),(6036,'1','302','1',1,'Retail Sale Id 5836',1501.44,0.00,0.00,2.04,173.40,'2023-02-11 18:02:21','',''),(6037,'1','302','1',1,'Retail Sale Id 5837',4496.96,0.00,0.00,6.11,519.35,'2023-02-11 18:03:27','',''),(6038,'1','302','1',1,'Retail Sale Id 5838',1000.96,0.00,0.00,1.36,115.60,'2023-02-11 18:10:36','',''),(6039,'1','302','1',1,'Retail Sale Id 5839',2001.92,0.00,0.00,2.72,231.20,'2023-02-11 18:14:39','',''),(6040,'1','302','1',1,'Retail Sale Id 5840',9200.00,0.00,0.00,12.50,1062.50,'2023-02-11 18:17:19','',''),(6041,'1','302','1',1,'Retail Sale Id 5841',9200.00,0.00,0.00,12.50,1062.50,'2023-02-11 18:54:45','',''),(6042,'1','302','1',1,'Retail Sale Id 5842',42600.00,0.00,0.00,60.00,3540.00,'2023-02-11 19:00:42','',''),(6043,'1','302','1',1,'Retail Sale Id 5843',3996.48,0.00,0.00,5.43,461.55,'2023-02-12 08:33:19','',''),(6044,'1','302','1',1,'Retail Sale Id 5844',3680.00,0.00,0.00,5.00,425.00,'2023-02-12 08:34:20','',''),(6045,'1','302','1',1,'Retail Sale Id 5845',7360.00,0.00,0.00,10.00,850.00,'2023-02-12 08:35:12','',''),(6046,'1','302','1',1,'Retail Sale Id 5846',2502.40,0.00,0.00,3.40,289.00,'2023-02-12 08:35:54','',''),(6047,'1','302','1',1,'Retail Sale Id 5847',3680.00,0.00,0.00,5.00,425.00,'2023-02-12 08:36:32','',''),(6048,'1','302','1',1,'Retail Sale Id 5848',9200.00,0.00,0.00,12.50,1062.50,'2023-02-12 08:37:40','',''),(6049,'1','302','1',1,'Retail Sale Id 5849',4997.44,0.00,0.00,6.79,577.15,'2023-02-12 08:42:55','',''),(6050,'1','302','1',1,'Retail Sale Id 5850',4496.96,0.00,0.00,6.11,519.35,'2023-02-12 08:44:22','',''),(6051,'1','302','1',1,'Retail Sale Id 5851',2208.00,0.00,0.00,3.00,255.00,'2023-02-12 08:51:16','',''),(6052,'1','302','1',1,'Retail Sale Id 5852',9200.00,0.00,0.00,12.50,1062.50,'2023-02-12 08:54:18','',''),(6053,'1','302','1',1,'Retail Sale Id 5853',3680.00,0.00,0.00,5.00,425.00,'2023-02-12 08:55:11','',''),(6054,'1','302','1',1,'Retail Sale Id 5854',2502.40,0.00,0.00,3.40,289.00,'2023-02-12 08:56:28','',''),(6055,'1','302','1',1,'Retail Sale Id 5855',4416.00,0.00,0.00,6.00,510.00,'2023-02-12 09:01:46','',''),(6056,'1','302','1',1,'Retail Sale Id 5856',2001.92,0.00,0.00,2.72,231.20,'2023-02-12 09:04:13','',''),(6057,'1','302','1',1,'Retail Sale Id 5857',1501.44,0.00,0.00,2.04,173.40,'2023-02-12 09:11:20','',''),(6058,'1','302','1',1,'Retail Sale Id 5858',1000.96,0.00,0.00,1.36,115.60,'2023-02-12 09:30:35','',''),(6059,'1','302','1',1,'Retail Sale Id 5859',3680.00,0.00,0.00,5.00,425.00,'2023-02-12 09:38:32','',''),(6060,'1','302','1',1,'Retail Sale Id 5860',1000.96,0.00,0.00,1.36,115.60,'2023-02-12 09:39:19','',''),(6061,'1','302','1',1,'Retail Sale Id 5862',802.24,0.00,0.00,1.09,92.65,'2023-02-12 09:45:16','',''),(6062,'1','302','1',1,'Retail Sale Id 5863',2208.00,0.00,0.00,3.00,255.00,'2023-02-12 09:48:44','',''),(6063,'1','302','1',1,'Retail Sale Id 5864',4416.00,0.00,0.00,6.00,510.00,'2023-02-12 09:52:58','',''),(6064,'1','302','1',1,'Retail Sale Id 5865',802.24,0.00,0.00,1.09,92.65,'2023-02-12 09:57:44','',''),(6065,'1','302','1',1,'Retail Sale Id 5866',3680.00,0.00,0.00,5.00,425.00,'2023-02-12 10:03:47','',''),(6066,'1','302','1',1,'Retail Sale Id 5867',2502.40,0.00,0.00,3.40,289.00,'2023-02-12 10:15:42','',''),(6067,'1','302','1',1,'Retail Sale Id 5868',2200.64,0.00,0.00,2.99,254.15,'2023-02-12 10:17:32','',''),(6068,'1','302','1',1,'Retail Sale Id 5869',4997.44,0.00,0.00,6.79,577.15,'2023-02-12 10:19:08','',''),(6069,'1','302','1',1,'Retail Sale Id 5870',2502.40,0.00,0.00,3.40,289.00,'2023-02-12 10:24:12','',''),(6070,'1','302','1',1,'Retail Sale Id 5871',2001.92,0.00,0.00,2.72,231.20,'2023-02-12 10:25:14','',''),(6071,'1','302','1',1,'Retail Sale Id 5872',1501.44,0.00,0.00,2.04,173.40,'2023-02-12 10:26:14','',''),(6072,'1','302','1',1,'Retail Sale Id 5873',3680.00,0.00,0.00,5.00,425.00,'2023-02-12 10:27:48','',''),(6073,'1','302','1',1,'Retail Sale Id 5874',1000.96,0.00,0.00,1.36,115.60,'2023-02-12 10:29:48','',''),(6074,'1','302','1',1,'Retail Sale Id 5875',3680.00,0.00,0.00,5.00,425.00,'2023-02-12 10:31:31','',''),(6075,'1','302','1',1,'Retail Sale Id 5876',4416.00,0.00,0.00,6.00,510.00,'2023-02-12 10:32:44','',''),(6076,'1','302','1',1,'Retail Sale Id 5877',1501.44,0.00,0.00,2.04,173.40,'2023-02-12 10:34:08','',''),(6077,'1','302','1',1,'Retail Sale Id 5878',897.92,0.00,0.00,1.22,103.70,'2023-02-12 10:34:59','',''),(6078,'1','302','1',1,'Retail Sale Id 5879',4416.00,0.00,0.00,6.00,510.00,'2023-02-12 10:36:38','',''),(6079,'1','302','1',1,'Retail Sale Id 5881',4416.00,0.00,0.00,6.00,510.00,'2023-02-12 10:42:11','',''),(6080,'1','302','1',1,'Retail Sale Id 5882',3680.00,0.00,0.00,5.00,425.00,'2023-02-12 10:44:30','',''),(6081,'1','302','1',1,'Retail Sale Id 5883',5152.00,0.00,0.00,7.00,595.00,'2023-02-12 10:46:15','',''),(6082,'1','302','1',1,'Retail Sale Id 5884',3680.00,0.00,0.00,5.00,425.00,'2023-02-12 10:48:07','',''),(6083,'1','302','1',1,'Retail Sale Id 5885',2208.00,0.00,0.00,3.00,255.00,'2023-02-12 10:49:33','',''),(6084,'1','302','1',1,'Retail Sale Id 5886',3002.88,0.00,0.00,4.08,346.80,'2023-02-12 10:58:10','',''),(6085,'1','302','1',1,'Retail Sale Id 5887',2001.92,0.00,0.00,2.72,231.20,'2023-02-12 10:59:50','',''),(6086,'1','302','1',1,'Retail Sale Id 5888',1501.44,0.00,0.00,2.04,173.40,'2023-02-12 11:01:26','',''),(6087,'1','302','1',1,'Retail Sale Id 5889',1501.44,0.00,0.00,2.04,173.40,'2023-02-12 11:03:33','',''),(6088,'1','302','1',1,'Retail Sale Id 5890',9200.00,0.00,0.00,12.50,1062.50,'2023-02-12 11:11:30','',''),(6089,'1','302','1',1,'Retail Sale Id 5891',9303.04,0.00,0.00,12.64,1074.40,'2023-02-12 11:13:06','',''),(6090,'1','302','1',1,'Retail Sale Id 5892',5680.00,0.00,0.00,8.00,472.00,'2023-02-12 11:21:10','',''),(6091,'1','302','1',1,'Retail Sale Id 5893',4416.00,0.00,0.00,6.00,510.00,'2023-02-12 11:29:37','',''),(6092,'1','302','1',1,'Retail Sale Id 5894',2208.00,0.00,0.00,3.00,255.00,'2023-02-12 11:41:59','',''),(6093,'1','302','1',1,'Retail Sale Id 5895',1501.44,0.00,0.00,2.04,173.40,'2023-02-12 11:48:08','',''),(6094,'1','302','1',1,'Retail Sale Id 5896',4416.00,0.00,0.00,6.00,510.00,'2023-02-12 11:53:06','',''),(6095,'1','302','1',1,'Retail Sale Id 5897',1501.44,0.00,0.00,2.04,173.40,'2023-02-12 12:04:00','',''),(6096,'1','302','1',1,'Retail Sale Id 5898',1501.44,0.00,0.00,2.04,173.40,'2023-02-12 12:08:09','',''),(6097,'1','302','1',1,'Retail Sale Id 5899',1501.44,0.00,0.00,2.04,173.40,'2023-02-12 12:09:29','',''),(6098,'1','302','1',1,'Retail Sale Id 5900',3680.00,0.00,0.00,5.00,425.00,'2023-02-12 12:22:53','',''),(6099,'1','302','1',1,'Retail Sale Id 5901',9200.00,0.00,0.00,12.50,1062.50,'2023-02-12 12:27:43','',''),(6100,'1','302','1',1,'Retail Sale Id 5902',2208.00,0.00,0.00,3.00,255.00,'2023-02-12 12:32:59','',''),(6101,'1','302','1',1,'Retail Sale Id 5903',3680.00,0.00,0.00,5.00,425.00,'2023-02-12 12:36:58','',''),(6102,'1','302','1',1,'Retail Sale Id 5904',3680.00,0.00,0.00,5.00,425.00,'2023-02-12 12:38:30','',''),(6103,'1','302','1',1,'Retail Sale Id 5905',500.48,0.00,0.00,0.68,57.80,'2023-02-12 12:39:13','',''),(6104,'1','302','1',1,'Retail Sale Id 5906',1501.44,0.00,0.00,2.04,173.40,'2023-02-12 12:40:13','',''),(6105,'1','302','1',1,'Retail Sale Id 5906',1501.44,0.00,0.00,2.04,173.40,'2023-02-12 12:40:13','',''),(6106,'1','302','1',1,'Retail Sale Id 5907',2208.00,0.00,0.00,3.00,255.00,'2023-02-12 12:42:54','',''),(6107,'1','302','1',1,'Retail Sale Id 5908',4416.00,0.00,0.00,6.00,510.00,'2023-02-12 12:44:16','',''),(6108,'1','302','1',1,'Retail Sale Id 5909',3996.48,0.00,0.00,5.43,461.55,'2023-02-12 12:46:35','',''),(6109,'1','302','1',1,'Retail Sale Id 5909',3996.48,0.00,0.00,5.43,461.55,'2023-02-12 12:46:35','',''),(6110,'1','302','1',1,'Retail Sale Id 5910',9200.00,0.00,0.00,12.50,1062.50,'2023-02-12 12:51:28','',''),(6111,'1','302','1',1,'Retail Sale Id 5911',9200.00,0.00,0.00,12.50,1062.50,'2023-02-12 12:55:22','',''),(6112,'1','302','1',1,'Retail Sale Id 5912',2502.40,0.00,0.00,3.40,289.00,'2023-02-12 12:57:13','',''),(6113,'1','302','1',1,'Retail Sale Id 5913',3680.00,0.00,0.00,5.00,425.00,'2023-02-12 13:03:21','',''),(6114,'1','302','1',1,'Retail Sale Id 5913',9200.00,0.00,0.00,12.50,1062.50,'2023-02-12 13:03:21','',''),(6115,'1','302','1',1,'Retail Sale Id 5914',1501.44,0.00,0.00,2.04,173.40,'2023-02-12 13:05:30','',''),(6116,'1','302','1',1,'Retail Sale Id 5914',1501.44,0.00,0.00,2.04,173.40,'2023-02-12 13:05:30','',''),(6117,'1','302','1',1,'Retail Sale Id 5915',2130.00,0.00,0.00,3.00,177.00,'2023-02-12 13:15:46','',''),(6118,'1','302','1',1,'Retail Sale Id 5916',35500.00,0.00,0.00,50.00,2950.00,'2023-02-12 13:19:08','',''),(6119,'1','302','1',1,'Retail Sale Id 5917',1472.00,0.00,0.00,2.00,170.00,'2023-02-12 13:31:00','',''),(6120,'1','302','1',1,'Retail Sale Id 5919',2208.00,0.00,0.00,3.00,255.00,'2023-02-12 13:34:30','',''),(6121,'1','302','1',1,'Retail Sale Id 5920',1501.44,0.00,0.00,2.04,173.40,'2023-02-12 13:42:39','',''),(6122,'1','302','1',1,'Retail Sale Id 5921',4416.00,0.00,0.00,6.00,510.00,'2023-02-12 13:47:07','',''),(6123,'1','302','1',1,'Retail Sale Id 5922',14200.00,0.00,0.00,20.00,1180.00,'2023-02-12 13:49:35','',''),(6124,'1','302','1',1,'Retail Sale Id 5923',2208.00,0.00,0.00,3.00,255.00,'2023-02-12 13:51:18','',''),(6125,'1','302','1',1,'Retail Sale Id 5924',4416.00,0.00,0.00,6.00,510.00,'2023-02-12 13:53:16','',''),(6126,'1','302','1',1,'Retail Sale Id 5925',3002.88,0.00,0.00,4.08,346.80,'2023-02-12 13:56:25','',''),(6127,'1','302','1',1,'Retail Sale Id 5926',3002.88,0.00,0.00,4.08,346.80,'2023-02-12 14:01:31','',''),(6128,'1','302','1',1,'Retail Sale Id 5927',35500.00,0.00,0.00,50.00,2950.00,'2023-02-12 14:05:08','',''),(6129,'1','302','1',1,'Retail Sale Id 5928',16928.00,0.00,0.00,23.00,1955.00,'2023-02-12 14:06:46','',''),(6130,'1','302','1',1,'Retail Sale Id 5929',2208.00,0.00,0.00,3.00,255.00,'2023-02-12 14:08:07','',''),(6131,'1','302','1',1,'Retail Sale Id 5930',3996.48,0.00,0.00,5.43,461.55,'2023-02-12 14:11:36','',''),(6132,'1','302','1',1,'Retail Sale Id 5931',897.92,0.00,0.00,1.22,103.70,'2023-02-12 14:12:41','',''),(6133,'1','302','1',1,'Retail Sale Id 5932',2208.00,0.00,0.00,3.00,255.00,'2023-02-12 14:14:56','',''),(6134,'1','302','1',1,'Retail Sale Id 5933',35500.00,0.00,0.00,50.00,2950.00,'2023-02-12 14:16:21','',''),(6135,'1','302','1',1,'Retail Sale Id 5934',2502.40,0.00,0.00,3.40,289.00,'2023-02-12 14:34:08','',''),(6136,'1','302','1',1,'Retail Sale Id 5935',11040.00,0.00,0.00,15.00,1275.00,'2023-02-12 14:39:00','',''),(6137,'1','302','1',1,'Retail Sale Id 5936',35500.00,0.00,0.00,50.00,2950.00,'2023-02-12 14:46:39','',''),(6138,'1','302','1',1,'Retail Sale Id 5937',5152.00,0.00,0.00,7.00,595.00,'2023-02-12 14:58:27','',''),(6139,'1','302','1',1,'Retail Sale Id 5938',1501.44,0.00,0.00,2.04,173.40,'2023-02-12 15:01:37','',''),(6140,'1','302','1',1,'Retail Sale Id 5938',1501.44,0.00,0.00,2.04,173.40,'2023-02-12 15:01:37','',''),(6141,'1','302','1',1,'Retail Sale Id 5939',8832.00,0.00,0.00,12.00,1020.00,'2023-02-12 15:07:11','',''),(6142,'1','302','1',1,'Retail Sale Id 5940',9200.00,0.00,0.00,12.50,1062.50,'2023-02-12 15:18:15','',''),(6143,'1','302','1',1,'Retail Sale Id 5941',2303.68,0.00,0.00,3.13,266.05,'2023-02-12 15:20:20','',''),(6144,'1','302','1',1,'Retail Sale Id 5942',3996.48,0.00,0.00,5.43,461.55,'2023-02-12 15:26:10','',''),(6145,'1','302','1',1,'Retail Sale Id 5943',736.00,0.00,0.00,1.00,85.00,'2023-02-12 15:43:09','',''),(6146,'1','302','1',1,'Retail Sale Id 5944',2208.00,0.00,0.00,3.00,255.00,'2023-02-12 15:44:37','',''),(6147,'1','302','1',1,'Retail Sale Id 5945',2208.00,0.00,0.00,3.00,255.00,'2023-02-12 15:46:48','',''),(6148,'1','302','1',1,'Retail Sale Id 5945',9200.00,0.00,0.00,12.50,1062.50,'2023-02-12 15:46:48','',''),(6149,'1','302','1',1,'Retail Sale Id 5946',500.48,0.00,0.00,0.68,57.80,'2023-02-12 15:47:43','',''),(6150,'1','302','1',1,'Retail Sale Id 5947',2208.00,0.00,0.00,3.00,255.00,'2023-02-12 16:01:00','',''),(6151,'1','302','1',1,'Retail Sale Id 5948',699.20,0.00,0.00,0.95,80.75,'2023-02-12 16:03:02','',''),(6152,'1','302','1',1,'Retail Sale Id 5949',2485.00,0.00,0.00,3.50,206.50,'2023-02-12 16:31:34','',''),(6153,'1','302','1',1,'Retail Sale Id 5950',1501.44,0.00,0.00,2.04,173.40,'2023-02-12 16:34:06','',''),(6154,'1','302','1',1,'Retail Sale Id 5951',4416.00,0.00,0.00,6.00,510.00,'2023-02-12 16:35:16','',''),(6155,'1','302','1',1,'Retail Sale Id 5952',736.00,0.00,0.00,1.00,85.00,'2023-02-12 16:36:48','',''),(6156,'1','302','1',1,'Retail Sale Id 5953',2208.00,0.00,0.00,3.00,255.00,'2023-02-12 16:38:38','',''),(6157,'1','302','1',1,'Retail Sale Id 5954',9200.00,0.00,0.00,12.50,1062.50,'2023-02-12 16:39:48','',''),(6158,'1','302','1',1,'Retail Sale Id 5955',2208.00,0.00,0.00,3.00,255.00,'2023-02-12 16:47:09','',''),(6159,'1','302','1',1,'Retail Sale Id 5955',8832.00,0.00,0.00,12.00,1020.00,'2023-02-12 16:47:09','',''),(6160,'1','302','1',1,'Retail Sale Id 5956',9200.00,0.00,0.00,12.50,1062.50,'2023-02-12 16:52:42','',''),(6161,'1','302','1',1,'Retail Sale Id 5957',1501.44,0.00,0.00,2.04,173.40,'2023-02-12 17:00:31','',''),(6162,'1','302','1',1,'Retail Sale Id 5958',2303.68,0.00,0.00,3.13,266.05,'2023-02-12 17:01:38','',''),(6163,'1','302','1',1,'Retail Sale Id 5959',5152.00,0.00,0.00,7.00,595.00,'2023-02-12 17:03:07','',''),(6164,'1','302','1',1,'Retail Sale Id 5960',2001.92,0.00,0.00,2.72,231.20,'2023-02-12 17:06:13','',''),(6165,'1','302','1',1,'Retail Sale Id 5961',5152.00,0.00,0.00,7.00,595.00,'2023-02-12 17:07:15','',''),(6166,'1','302','1',1,'Retail Sale Id 5962',9200.00,0.00,0.00,12.50,1062.50,'2023-02-12 17:08:18','',''),(6167,'1','302','1',1,'Retail Sale Id 5963',16330.00,0.00,0.00,23.00,1357.00,'2023-02-12 17:09:23','',''),(6168,'1','302','1',1,'Retail Sale Id 5964',2208.00,0.00,0.00,3.00,255.00,'2023-02-12 17:11:22','',''),(6169,'1','302','1',1,'Retail Sale Id 5965',9200.00,0.00,0.00,12.50,1062.50,'2023-02-12 17:17:56','',''),(6170,'1','302','1',1,'Retail Sale Id 5966',2001.92,0.00,0.00,2.72,231.20,'2023-02-12 17:20:33','',''),(6171,'1','302','1',1,'Retail Sale Id 5967',7360.00,0.00,0.00,10.00,850.00,'2023-02-12 17:25:05','',''),(6172,'1','302','1',1,'Retail Sale Id 5968',4416.00,0.00,0.00,6.00,510.00,'2023-02-12 17:34:33','',''),(6173,'1','302','1',1,'Retail Sale Id 5969',1501.44,0.00,0.00,2.04,173.40,'2023-02-12 17:35:34','',''),(6174,'1','302','1',1,'Retail Sale Id 5970',2208.00,0.00,0.00,3.00,255.00,'2023-02-12 17:38:11','',''),(6175,'1','302','1',1,'Retail Sale Id 5971',2208.00,0.00,0.00,3.00,255.00,'2023-02-12 17:39:54','',''),(6176,'1','302','1',1,'Retail Sale Id 5972',3680.00,0.00,0.00,5.00,425.00,'2023-02-12 17:47:16','',''),(6177,'1','302','1',1,'Retail Sale Id 5973',3680.00,0.00,0.00,5.00,425.00,'2023-02-12 17:54:10','',''),(6178,'1','302','1',1,'Retail Sale Id 5974',3002.88,0.00,0.00,4.08,346.80,'2023-02-12 17:55:28','',''),(6179,'1','302','1',1,'Retail Sale Id 5975',3996.48,0.00,0.00,5.43,461.55,'2023-02-12 17:59:40','',''),(6180,'1','302','1',1,'Retail Sale Id 5976',1000.96,0.00,0.00,1.36,115.60,'2023-02-12 18:11:07','',''),(6181,'1','302','1',1,'Retail Sale Id 5977',2208.00,0.00,0.00,3.00,255.00,'2023-02-12 18:12:19','',''),(6182,'1','302','1',1,'Retail Sale Id 5978',18400.00,0.00,0.00,25.00,2125.00,'2023-02-12 18:15:19','',''),(6183,'1','302','1',1,'Retail Sale Id 5979',4416.00,0.00,0.00,6.00,510.00,'2023-02-12 18:20:42','',''),(6184,'1','302','1',1,'Retail Sale Id 5980',42600.00,0.00,0.00,60.00,3540.00,'2023-02-12 19:24:57','',''),(6185,'1','302','1',1,'Return of Retail Sale Id 5979',0.00,4416.00,6.00,0.00,-510.00,'2023-02-12 19:30:01','',''),(6186,'1','302','1',1,'Retail Sale Id 5981',17750.00,0.00,0.00,25.00,1475.00,'2023-02-12 19:33:23','',''),(6187,'1','302','1',1,'Retail Sale Id 5982',2355.20,0.00,0.00,3.20,272.00,'2023-02-12 19:49:54','',''),(6188,'1','302','1',1,'Retail Sale Id 5983',7.36,0.00,0.00,0.01,0.85,'2023-02-12 19:52:35','',''),(6189,'1','302','1',1,'Retail Sale Id 5984',1472.00,0.00,0.00,2.00,170.00,'2023-02-13 07:33:15','',''),(6190,'1','302','1',1,'Retail Sale Id 5985',3680.00,0.00,0.00,5.00,425.00,'2023-02-13 07:36:13','',''),(6191,'1','302','1',1,'Retail Sale Id 5985',4416.00,0.00,0.00,6.00,510.00,'2023-02-13 07:36:13','',''),(6192,'1','302','1',1,'Retail Sale Id 5985',4416.00,0.00,0.00,6.00,510.00,'2023-02-13 07:36:13','',''),(6193,'1','302','1',1,'Retail Sale Id 5985',9200.00,0.00,0.00,12.50,1062.50,'2023-02-13 07:36:13','',''),(6194,'1','302','1',1,'Retail Sale Id 5986',4496.96,0.00,0.00,6.11,519.35,'2023-02-13 08:00:07','',''),(6195,'1','302','1',1,'Retail Sale Id 5987',4416.00,0.00,0.00,6.00,510.00,'2023-02-13 08:03:01','',''),(6196,'1','302','1',1,'Retail Sale Id 5987',4416.00,0.00,0.00,6.00,510.00,'2023-02-13 08:03:01','',''),(6197,'1','302','1',1,'Retail Sale Id 5989',2208.00,0.00,0.00,3.00,255.00,'2023-02-13 08:12:38','',''),(6198,'1','302','1',1,'Retail Sale Id 5989',4416.00,0.00,0.00,6.00,510.00,'2023-02-13 08:12:38','',''),(6199,'1','302','1',1,'Retail Sale Id 5990',2097.60,0.00,0.00,2.85,242.25,'2023-02-13 08:16:16','',''),(6200,'1','302','1',1,'Retail Sale Id 5991',2252.16,0.00,0.00,3.06,260.10,'2023-02-13 08:17:08','',''),(6201,'1','302','1',1,'Retail Sale Id 5992',9200.00,0.00,0.00,12.50,1062.50,'2023-02-13 08:18:37','',''),(6202,'1','302','1',1,'Retail Sale Id 5993',2208.00,0.00,0.00,3.00,255.00,'2023-02-13 08:22:14','',''),(6203,'1','302','1',1,'Retail Sale Id 5994',9200.00,0.00,0.00,12.50,1062.50,'2023-02-13 08:23:43','',''),(6204,'1','302','1',1,'Retail Sale Id 5995',4416.00,0.00,0.00,6.00,510.00,'2023-02-13 08:24:33','',''),(6205,'1','302','1',1,'Retail Sale Id 5996',9200.00,0.00,0.00,12.50,1062.50,'2023-02-13 08:25:14','',''),(6206,'1','302','1',1,'Retail Sale Id 5997',9200.00,0.00,0.00,12.50,1062.50,'2023-02-13 08:25:40','',''),(6207,'1','302','1',1,'Retail Sale Id 5998',9200.00,0.00,0.00,12.50,1062.50,'2023-02-13 08:26:10','',''),(6208,'1','302','1',1,'Retail Sale Id 5999',4416.00,0.00,0.00,6.00,510.00,'2023-02-13 08:27:48','',''),(6209,'1','302','1',1,'Retail Sale Id 6000',4416.00,0.00,0.00,6.00,510.00,'2023-02-13 08:28:51','',''),(6210,'1','302','1',1,'Retail Sale Id 6000',4416.00,0.00,0.00,6.00,510.00,'2023-02-13 08:28:51','',''),(6211,'1','302','1',1,'Retail Sale Id 6001',4416.00,0.00,0.00,6.00,510.00,'2023-02-13 08:29:25','',''),(6212,'1','302','1',1,'Retail Sale Id 6002',4416.00,0.00,0.00,6.00,510.00,'2023-02-13 08:29:52','',''),(6213,'1','302','1',1,'Retail Sale Id 6003',4416.00,0.00,0.00,6.00,510.00,'2023-02-13 08:32:21','',''),(6214,'1','302','1',1,'Retail Sale Id 6004',4416.00,0.00,0.00,6.00,510.00,'2023-02-13 08:32:57','',''),(6215,'1','302','1',1,'Retail Sale Id 6005',4416.00,0.00,0.00,6.00,510.00,'2023-02-13 08:33:33','',''),(6216,'1','302','1',1,'Retail Sale Id 6006',2208.00,0.00,0.00,3.00,255.00,'2023-02-13 08:34:02','',''),(6217,'1','302','1',1,'Retail Sale Id 6007',2208.00,0.00,0.00,3.00,255.00,'2023-02-13 08:34:38','',''),(6218,'1','302','1',1,'Retail Sale Id 6008',2208.00,0.00,0.00,3.00,255.00,'2023-02-13 08:35:21','',''),(6219,'1','302','1',1,'Retail Sale Id 6009',2208.00,0.00,0.00,3.00,255.00,'2023-02-13 08:35:58','',''),(6220,'1','302','1',1,'Retail Sale Id 6010',2208.00,0.00,0.00,3.00,255.00,'2023-02-13 08:36:35','',''),(6221,'1','302','1',1,'Retail Sale Id 6012',4496.96,0.00,0.00,6.11,519.35,'2023-02-13 08:40:49','',''),(6222,'1','302','1',1,'Retail Sale Id 6013',1472.00,0.00,0.00,2.00,170.00,'2023-02-13 08:43:23','',''),(6223,'1','302','1',1,'Retail Sale Id 6014',3002.88,0.00,0.00,4.08,346.80,'2023-02-13 08:44:17','',''),(6224,'1','302','1',1,'Retail Sale Id 6015',42600.00,0.00,0.00,60.00,3540.00,'2023-02-13 08:49:24','',''),(6225,'1','302','1',1,'Retail Sale Id 6016',9200.00,0.00,0.00,12.50,1062.50,'2023-02-13 08:51:48','',''),(6226,'1','302','1',1,'Retail Sale Id 6017',9200.00,0.00,0.00,12.50,1062.50,'2023-02-13 08:52:49','',''),(6227,'1','302','1',1,'Retail Sale Id 6018',4416.00,0.00,0.00,6.00,510.00,'2023-02-13 08:54:12','',''),(6228,'1','302','1',1,'Retail Sale Id 6020',4416.00,0.00,0.00,6.00,510.00,'2023-02-13 08:54:45','',''),(6229,'1','302','1',1,'Retail Sale Id 6021',8096.00,0.00,0.00,11.00,935.00,'2023-02-13 08:58:05','',''),(6230,'1','302','1',1,'Retail Sale Id 6022',17750.00,0.00,0.00,25.00,1475.00,'2023-02-13 09:05:54','',''),(6231,'1','302','1',1,'Retail Sale Id 6023',4496.96,0.00,0.00,6.11,519.35,'2023-02-13 09:08:02','',''),(6232,'1','302','1',1,'Retail Sale Id 6024',2060.80,0.00,0.00,2.80,238.00,'2023-02-13 09:29:24','',''),(6233,'1','302','1',1,'Retail Sale Id 6025',1000.96,0.00,0.00,1.36,115.60,'2023-02-13 09:30:32','',''),(6234,'1','302','1',1,'Retail Sale Id 6026',3503.36,0.00,0.00,4.76,404.60,'2023-02-13 09:37:19','',''),(6235,'1','302','1',1,'Retail Sale Id 6027',4997.44,0.00,0.00,6.79,577.15,'2023-02-13 09:39:05','',''),(6236,'1','302','1',1,'Retail Sale Id 6028',2001.92,0.00,0.00,2.72,231.20,'2023-02-13 09:39:52','',''),(6237,'1','302','1',1,'Retail Sale Id 6029',4496.96,0.00,0.00,6.11,519.35,'2023-02-13 09:51:53','',''),(6238,'1','302','1',1,'Retail Sale Id 6030',1000.96,0.00,0.00,1.36,115.60,'2023-02-13 10:14:46','',''),(6239,'1','302','1',1,'Retail Sale Id 6031',71000.00,0.00,0.00,100.00,5900.00,'2023-02-13 10:19:14','',''),(6240,'1','302','1',1,'Retail Sale Id 6032',3996.48,0.00,0.00,5.43,461.55,'2023-02-13 10:20:19','',''),(6241,'1','302','1',1,'Retail Sale Id 6033',4997.44,0.00,0.00,6.79,577.15,'2023-02-13 10:21:03','',''),(6242,'1','302','1',1,'Retail Sale Id 6034',3680.00,0.00,0.00,5.00,425.00,'2023-02-13 10:22:08','',''),(6243,'1','302','1',1,'Retail Sale Id 6035',2208.00,0.00,0.00,3.00,255.00,'2023-02-13 10:23:38','',''),(6244,'1','302','1',1,'Retail Sale Id 6035',9200.00,0.00,0.00,12.50,1062.50,'2023-02-13 10:23:38','',''),(6245,'1','302','1',1,'Retail Sale Id 6036',2001.92,0.00,0.00,2.72,231.20,'2023-02-13 10:38:08','',''),(6246,'1','302','1',1,'Retail Sale Id 6037',5696.64,0.00,0.00,7.74,657.90,'2023-02-13 10:46:25','',''),(6247,'1','302','1',1,'Retail Sale Id 6038',4496.96,0.00,0.00,6.11,519.35,'2023-02-13 10:49:45','',''),(6248,'1','302','1',1,'Retail Sale Id 6039',4496.96,0.00,0.00,6.11,519.35,'2023-02-13 10:50:53','',''),(6249,'1','302','1',1,'Retail Sale Id 6040',3002.88,0.00,0.00,4.08,346.80,'2023-02-13 10:55:51','',''),(6250,'1','302','1',1,'Retail Sale Id 6041',2252.16,0.00,0.00,3.06,260.10,'2023-02-13 11:10:31','',''),(6251,'1','302','1',1,'Retail Sale Id 6042',17750.00,0.00,0.00,25.00,1475.00,'2023-02-13 11:18:11','',''),(6252,'1','302','1',1,'Retail Sale Id 6043',1000.96,0.00,0.00,1.36,115.60,'2023-02-13 11:18:54','',''),(6253,'1','302','1',1,'Retail Sale Id 6044',2944.00,0.00,0.00,4.00,340.00,'2023-02-13 11:44:12','',''),(6254,'1','302','1',1,'Retail Sale Id 6045',35500.00,0.00,0.00,50.00,2950.00,'2023-02-13 11:49:17','',''),(6255,'1','302','1',1,'Retail Sale Id 6047',2200.64,0.00,0.00,2.99,254.15,'2023-02-13 12:14:44','',''),(6256,'1','302','1',1,'Retail Sale Id 6048',802.24,0.00,0.00,1.09,92.65,'2023-02-13 12:15:27','',''),(6257,'1','302','1',1,'Retail Sale Id 6046',3976.00,0.00,0.00,5.60,330.40,'2023-02-13 12:16:12','',''),(6258,'1','302','1',1,'Retail Sale Id 6049',4997.44,0.00,0.00,6.79,577.15,'2023-02-13 12:17:00','',''),(6259,'1','302','1',1,'Retail Sale Id 6050',49898.80,0.00,0.00,70.28,4146.52,'2023-02-13 12:24:01','',''),(6260,'1','302','1',1,'Retail Sale Id 6051',2001.92,0.00,0.00,2.72,231.20,'2023-02-13 12:28:28','',''),(6261,'1','302','1',1,'Retail Sale Id 6052',9200.00,0.00,0.00,12.50,1062.50,'2023-02-13 12:29:38','',''),(6262,'1','302','1',1,'Retail Sale Id 6053',7360.00,0.00,0.00,10.00,850.00,'2023-02-13 12:45:42','',''),(6263,'1','302','1',1,'Retail Sale Id 6054',5888.00,0.00,0.00,8.00,680.00,'2023-02-13 12:59:35','',''),(6264,'1','302','1',1,'Retail Sale Id 6055',1000.96,0.00,0.00,1.36,115.60,'2023-02-13 13:00:36','',''),(6265,'1','302','1',1,'Retail Sale Id 6056',36800.00,0.00,0.00,50.00,4250.00,'2023-02-13 13:10:51','',''),(6266,'1','302','1',1,'Retail Sale Id 6057',1000.96,0.00,0.00,1.36,115.60,'2023-02-13 13:12:11','',''),(6267,'1','302','1',1,'Retail Sale Id 6058',3002.88,0.00,0.00,4.08,346.80,'2023-02-13 13:14:49','',''),(6268,'1','302','1',1,'Retail Sale Id 6059',4416.00,0.00,0.00,6.00,510.00,'2023-02-13 13:16:06','',''),(6269,'1','302','1',1,'Retail Sale Id 6060',9200.00,0.00,0.00,12.50,1062.50,'2023-02-13 13:38:01','',''),(6270,'1','302','1',1,'Retail Sale Id 6061',1000.96,0.00,0.00,1.36,115.60,'2023-02-13 13:43:28','',''),(6271,'1','302','1',1,'Retail Sale Id 6062',1501.44,0.00,0.00,2.04,173.40,'2023-02-13 13:53:07','',''),(6272,'1','302','1',1,'Retail Sale Id 6063',2001.92,0.00,0.00,2.72,231.20,'2023-02-13 13:54:50','',''),(6273,'1','302','1',1,'Retail Sale Id 6064',802.24,0.00,0.00,1.09,92.65,'2023-02-13 14:02:14','',''),(6274,'1','302','1',1,'Retail Sale Id 6065',3680.00,0.00,0.00,5.00,425.00,'2023-02-13 14:27:01','',''),(6275,'1','302','1',1,'Retail Sale Id 6066',3002.88,0.00,0.00,4.08,346.80,'2023-02-13 14:28:15','',''),(6276,'1','302','1',1,'Retail Sale Id 6067',8520.00,0.00,0.00,12.00,708.00,'2023-02-13 14:29:32','',''),(6277,'1','302','1',1,'Retail Sale Id 6068',802.24,0.00,0.00,1.09,92.65,'2023-02-13 14:30:17','',''),(6278,'1','302','1',1,'Retail Sale Id 6069',3996.48,0.00,0.00,5.43,461.55,'2023-02-13 14:50:30','',''),(6279,'1','302','1',1,'Retail Sale Id 6070',1501.44,0.00,0.00,2.04,173.40,'2023-02-13 14:55:41','',''),(6280,'1','302','1',1,'Retail Sale Id 6071',7360.00,0.00,0.00,10.00,850.00,'2023-02-13 15:04:06','',''),(6281,'1','302','1',1,'Retail Sale Id 6072',2001.92,0.00,0.00,2.72,231.20,'2023-02-13 15:07:04','',''),(6282,'1','302','1',1,'Retail Sale Id 6073',4416.00,0.00,0.00,6.00,510.00,'2023-02-13 15:13:59','',''),(6283,'1','302','1',1,'Retail Sale Id 6074',14200.00,0.00,0.00,20.00,1180.00,'2023-02-13 15:19:10','',''),(6284,'1','302','1',1,'Retail Sale Id 6075',9200.00,0.00,0.00,12.50,1062.50,'2023-02-13 15:22:14','',''),(6285,'1','302','1',1,'Retail Sale Id 6076',4416.00,0.00,0.00,6.00,510.00,'2023-02-13 15:23:38','',''),(6286,'1','302','1',1,'Retail Sale Id 6076',9200.00,0.00,0.00,12.50,1062.50,'2023-02-13 15:23:38','',''),(6287,'1','302','1',1,'Retail Sale Id 6077',1000.96,0.00,0.00,1.36,115.60,'2023-02-13 15:25:19','',''),(6288,'1','302','1',1,'Retail Sale Id 6078',9200.00,0.00,0.00,12.50,1062.50,'2023-02-13 15:26:16','',''),(6289,'1','302','1',1,'Retail Sale Id 6079',1501.44,0.00,0.00,2.04,173.40,'2023-02-13 15:54:19','',''),(6290,'1','302','1',1,'Retail Sale Id 6080',3002.88,0.00,0.00,4.08,346.80,'2023-02-13 15:56:01','',''),(6291,'1','302','1',1,'Retail Sale Id 6081',3503.36,0.00,0.00,4.76,404.60,'2023-02-13 16:08:12','',''),(6292,'1','302','1',1,'Retail Sale Id 6082',2001.92,0.00,0.00,2.72,231.20,'2023-02-13 16:11:37','',''),(6293,'1','302','1',1,'Retail Sale Id 6083',2001.92,0.00,0.00,2.72,231.20,'2023-02-13 16:12:28','',''),(6294,'1','302','1',1,'Retail Sale Id 6084',2208.00,0.00,0.00,3.00,255.00,'2023-02-13 16:32:37','',''),(6295,'1','302','1',1,'Retail Sale Id 6084',9200.00,0.00,0.00,12.50,1062.50,'2023-02-13 16:32:37','',''),(6296,'1','302','1',1,'Retail Sale Id 6085',1501.44,0.00,0.00,2.04,173.40,'2023-02-13 16:34:24','',''),(6297,'1','302','1',1,'Retail Sale Id 6086',36800.00,0.00,0.00,50.00,4250.00,'2023-02-13 16:35:44','',''),(6298,'1','302','1',1,'Retail Sale Id 6087',3680.00,0.00,0.00,5.00,425.00,'2023-02-13 16:36:46','',''),(6299,'1','302','1',1,'Retail Sale Id 6088',9200.00,0.00,0.00,12.50,1062.50,'2023-02-13 16:38:01','',''),(6300,'1','302','1',1,'Retail Sale Id 6089',1000.96,0.00,0.00,1.36,115.60,'2023-02-13 16:44:40','',''),(6301,'1','302','1',1,'Retail Sale Id 6090',1501.44,0.00,0.00,2.04,173.40,'2023-02-13 16:50:14','',''),(6302,'1','302','1',1,'Retail Sale Id 6091',2200.64,0.00,0.00,2.99,254.15,'2023-02-13 16:52:48','',''),(6303,'1','302','1',1,'Retail Sale Id 6092',750.72,0.00,0.00,1.02,86.70,'2023-02-13 16:54:19','',''),(6304,'1','302','1',1,'Retail Sale Id 6093',22010.00,0.00,0.00,31.00,1829.00,'2023-02-13 17:04:47','',''),(6305,'1','302','1',1,'Retail Sale Id 6094',2502.40,0.00,0.00,3.40,289.00,'2023-02-13 17:11:37','',''),(6306,'1','302','1',1,'Retail Sale Id 6095',9200.00,0.00,0.00,12.50,1062.50,'2023-02-13 17:13:13','',''),(6307,'1','302','1',1,'Retail Sale Id 6096',1000.96,0.00,0.00,1.36,115.60,'2023-02-13 17:22:35','',''),(6308,'1','302','1',1,'Retail Sale Id 6096',2001.92,0.00,0.00,2.72,231.20,'2023-02-13 17:22:35','',''),(6309,'1','302','1',1,'Retail Sale Id 6097',9940.00,0.00,0.00,14.00,826.00,'2023-02-13 17:24:33','',''),(6310,'1','302','1',1,'Retail Sale Id 6098',2502.40,0.00,0.00,3.40,289.00,'2023-02-13 17:26:17','',''),(6311,'1','302','1',1,'Retail Sale Id 6099',4416.00,0.00,0.00,6.00,510.00,'2023-02-13 17:28:17','',''),(6312,'1','302','1',1,'Retail Sale Id 6100',3599.04,0.00,0.00,4.89,415.65,'2023-02-13 17:40:25','',''),(6313,'1','302','1',1,'Retail Sale Id 6101',2944.00,0.00,0.00,4.00,340.00,'2023-02-13 17:43:00','',''),(6314,'1','302','1',1,'Retail Sale Id 6101',3680.00,0.00,0.00,5.00,425.00,'2023-02-13 17:43:00','',''),(6315,'1','302','1',1,'Retail Sale Id 6101',3680.00,0.00,0.00,5.00,425.00,'2023-02-13 17:43:00','',''),(6316,'1','302','1',1,'Retail Sale Id 6101',5888.00,0.00,0.00,8.00,680.00,'2023-02-13 17:43:00','',''),(6317,'1','302','1',1,'Retail Sale Id 6102',4416.00,0.00,0.00,6.00,510.00,'2023-02-13 17:44:40','',''),(6318,'1','302','1',1,'Retail Sale Id 6103',2502.40,0.00,0.00,3.40,289.00,'2023-02-13 17:46:44','',''),(6319,'1','302','1',1,'Retail Sale Id 6104',2001.92,0.00,0.00,2.72,231.20,'2023-02-13 17:48:16','',''),(6320,'1','302','1',1,'Retail Sale Id 6105',17750.00,0.00,0.00,25.00,1475.00,'2023-02-13 17:49:55','',''),(6321,'1','302','1',1,'Retail Sale Id 6106',4416.00,0.00,0.00,6.00,510.00,'2023-02-13 17:52:24','',''),(6322,'1','302','1',1,'Retail Sale Id 6107',3002.88,0.00,0.00,4.08,346.80,'2023-02-13 17:59:27','',''),(6323,'1','302','1',1,'Retail Sale Id 6108',500.48,0.00,0.00,0.68,57.80,'2023-02-13 18:04:03','',''),(6324,'1','302','1',1,'Retail Sale Id 6109',2001.92,0.00,0.00,2.72,231.20,'2023-02-13 18:08:39','',''),(6325,'1','302','1',1,'Retail Sale Id 6110',4496.96,0.00,0.00,6.11,519.35,'2023-02-13 18:13:10','',''),(6326,'1','302','1',1,'Retail Sale Id 6111',11408.00,0.00,0.00,15.50,1317.50,'2023-02-13 18:14:42','',''),(6327,'1','302','1',1,'Retail Sale Id 6112',2208.00,0.00,0.00,3.00,255.00,'2023-02-13 18:15:42','',''),(6328,'1','302','1',1,'Retail Sale Id 6113',2208.00,0.00,0.00,3.00,255.00,'2023-02-13 18:18:48','',''),(6329,'1','302','1',1,'Retail Sale Id 6114',1501.44,0.00,0.00,2.04,173.40,'2023-02-13 18:21:00','',''),(6330,'1','302','1',1,'Retail Sale Id 6115',1420.00,0.00,0.00,2.00,118.00,'2023-02-13 18:25:02','',''),(6331,'1','302','1',1,'Retail Sale Id 6116',1501.44,0.00,0.00,2.04,173.40,'2023-02-13 18:27:14','',''),(6332,'1','302','1',1,'Retail Sale Id 6117',3503.36,0.00,0.00,4.76,404.60,'2023-02-13 18:28:26','',''),(6333,'1','302','1',1,'Retail Sale Id 6118',3680.00,0.00,0.00,5.00,425.00,'2023-02-13 18:29:20','',''),(6334,'1','302','1',1,'Retail Sale Id 6119',51.52,0.00,0.00,0.07,5.95,'2023-02-13 18:57:24','',''),(6335,'1','302','1',1,'Retail Sale Id 6120',1501.44,0.00,0.00,2.04,173.40,'2023-02-14 07:28:57','',''),(6336,'1','302','1',1,'Retail Sale Id 6121',9200.00,0.00,0.00,12.50,1062.50,'2023-02-14 08:13:10','',''),(6337,'1','302','1',1,'Retail Sale Id 6122',2001.92,0.00,0.00,2.72,231.20,'2023-02-14 08:26:49','',''),(6338,'1','302','1',1,'Retail Sale Id 6123',4496.96,0.00,0.00,6.11,519.35,'2023-02-14 08:29:09','',''),(6339,'1','302','1',1,'Retail Sale Id 6124',3680.00,0.00,0.00,5.00,425.00,'2023-02-14 08:32:17','',''),(6340,'1','302','1',1,'Retail Sale Id 6125',1501.44,0.00,0.00,2.04,173.40,'2023-02-14 08:33:32','',''),(6341,'1','302','1',1,'Retail Sale Id 6126',2001.92,0.00,0.00,2.72,231.20,'2023-02-14 08:36:40','',''),(6342,'1','302','1',1,'Retail Sale Id 6127',2001.92,0.00,0.00,2.72,231.20,'2023-02-14 08:44:03','',''),(6343,'1','302','1',1,'Retail Sale Id 6129',4423.36,0.00,0.00,6.01,510.85,'2023-02-14 08:54:38','',''),(6344,'1','302','1',1,'Retail Sale Id 6130',4416.00,0.00,0.00,6.00,510.00,'2023-02-14 08:56:12','',''),(6345,'1','302','1',1,'Retail Sale Id 6131',4496.96,0.00,0.00,6.11,519.35,'2023-02-14 09:02:00','',''),(6346,'1','302','1',1,'Retail Sale Id 6132',500.48,0.00,0.00,0.68,57.80,'2023-02-14 09:06:11','',''),(6347,'1','302','1',1,'Retail Sale Id 6133',9200.00,0.00,0.00,12.50,1062.50,'2023-02-14 09:15:42','',''),(6348,'1','302','1',1,'Retail Sale Id 6134',4416.00,0.00,0.00,6.00,510.00,'2023-02-14 09:25:30','',''),(6349,'1','302','1',1,'Retail Sale Id 6135',4416.00,0.00,0.00,6.00,510.00,'2023-02-14 09:26:49','',''),(6350,'1','302','1',1,'Retail Sale Id 6136',1501.44,0.00,0.00,2.04,173.40,'2023-02-14 09:29:35','',''),(6351,'1','302','1',1,'Retail Sale Id 6137',4416.00,0.00,0.00,6.00,510.00,'2023-02-14 09:31:53','',''),(6352,'1','302','1',1,'Retail Sale Id 6138',2208.00,0.00,0.00,3.00,255.00,'2023-02-14 09:32:45','',''),(6353,'1','302','1',1,'Retail Sale Id 6139',4496.96,0.00,0.00,6.11,519.35,'2023-02-14 09:51:55','',''),(6354,'1','302','1',1,'Retail Sale Id 6140',2208.00,0.00,0.00,3.00,255.00,'2023-02-14 09:55:16','',''),(6355,'1','302','1',1,'Retail Sale Id 6141',4401.28,0.00,0.00,5.98,508.30,'2023-02-14 09:56:55','',''),(6356,'1','302','1',1,'Retail Sale Id 6142',7360.00,0.00,0.00,10.00,850.00,'2023-02-14 10:12:02','',''),(6357,'1','302','1',1,'Retail Sale Id 6143',1501.44,0.00,0.00,2.04,173.40,'2023-02-14 10:18:42','',''),(6358,'1','302','1',1,'Retail Sale Id 6144',7360.00,0.00,0.00,10.00,850.00,'2023-02-14 10:25:47','',''),(6359,'1','302','1',1,'Retail Sale Id 6145',4416.00,0.00,0.00,6.00,510.00,'2023-02-14 10:31:26','',''),(6360,'1','302','1',1,'Retail Sale Id 6146',7360.00,0.00,0.00,10.00,850.00,'2023-02-14 10:38:19','',''),(6361,'1','302','1',1,'Retail Sale Id 6147',1501.44,0.00,0.00,2.04,173.40,'2023-02-14 10:39:59','',''),(6362,'1','302','1',1,'Retail Sale Id 6148',7360.00,0.00,0.00,10.00,850.00,'2023-02-14 10:43:20','',''),(6363,'1','302','1',1,'Retail Sale Id 6149',4416.00,0.00,0.00,6.00,510.00,'2023-02-14 10:44:58','',''),(6364,'1','302','1',1,'Retail Sale Id 6150',2502.40,0.00,0.00,3.40,289.00,'2023-02-14 10:46:12','',''),(6365,'1','302','1',1,'Retail Sale Id 6151',71000.00,0.00,0.00,100.00,5900.00,'2023-02-14 10:52:08','',''),(6366,'1','302','1',1,'Retail Sale Id 6152',9200.00,0.00,0.00,12.50,1062.50,'2023-02-14 10:54:02','',''),(6367,'1','302','1',1,'Retail Sale Id 6153',4416.00,0.00,0.00,6.00,510.00,'2023-02-14 10:57:29','',''),(6368,'1','302','1',1,'Retail Sale Id 6153',4416.00,0.00,0.00,6.00,510.00,'2023-02-14 10:57:29','',''),(6369,'1','302','1',1,'Retail Sale Id 6154',1501.44,0.00,0.00,2.04,173.40,'2023-02-14 11:03:45','',''),(6370,'1','302','1',1,'Retail Sale Id 6155',2208.00,0.00,0.00,3.00,255.00,'2023-02-14 11:12:51','',''),(6371,'1','302','1',1,'Retail Sale Id 6156',3002.88,0.00,0.00,4.08,346.80,'2023-02-14 11:17:56','',''),(6372,'1','302','1',1,'Retail Sale Id 6157',2208.00,0.00,0.00,3.00,255.00,'2023-02-14 11:21:31','',''),(6373,'1','302','1',1,'Retail Sale Id 6158',2001.92,0.00,0.00,2.72,231.20,'2023-02-14 11:22:21','',''),(6374,'1','302','1',1,'Retail Sale Id 6159',2001.92,0.00,0.00,2.72,231.20,'2023-02-14 11:25:35','',''),(6375,'1','302','1',1,'Retail Sale Id 6160',9200.00,0.00,0.00,12.50,1062.50,'2023-02-14 11:36:37','',''),(6376,'1','302','1',1,'Retail Sale Id 6161',3680.00,0.00,0.00,5.00,425.00,'2023-02-14 11:37:50','',''),(6377,'1','302','1',1,'Retail Sale Id 6162',4416.00,0.00,0.00,6.00,510.00,'2023-02-14 11:45:36','',''),(6378,'1','302','1',1,'Retail Sale Id 6163',9001.28,0.00,0.00,12.23,1039.55,'2023-02-14 11:48:07','',''),(6379,'1','302','1',1,'Retail Sale Id 6164',2001.92,0.00,0.00,2.72,231.20,'2023-02-14 11:49:06','',''),(6380,'1','302','1',1,'Retail Sale Id 6165',3680.00,0.00,0.00,5.00,425.00,'2023-02-14 11:53:06','',''),(6381,'1','302','1',1,'Retail Sale Id 6166',5152.00,0.00,0.00,7.00,595.00,'2023-02-14 11:56:13','',''),(6382,'1','302','1',1,'Retail Sale Id 6167',802.24,0.00,0.00,1.09,92.65,'2023-02-14 12:06:54','',''),(6383,'1','302','1',1,'Retail Sale Id 6168',3002.88,0.00,0.00,4.08,346.80,'2023-02-14 12:19:40','',''),(6384,'1','302','1',1,'Retail Sale Id 6169',2208.00,0.00,0.00,3.00,255.00,'2023-02-14 12:24:00','',''),(6385,'1','302','1',1,'Retail Sale Id 6170',9200.00,0.00,0.00,12.50,1062.50,'2023-02-14 12:33:56','',''),(6386,'1','302','1',1,'Retail Sale Id 6171',2149.12,0.00,0.00,2.92,248.20,'2023-02-14 12:35:08','',''),(6387,'1','302','1',1,'Retail Sale Id 6172',1000.96,0.00,0.00,1.36,115.60,'2023-02-14 12:40:03','',''),(6388,'1','302','1',1,'Retail Sale Id 6173',9200.00,0.00,0.00,12.50,1062.50,'2023-02-14 12:55:16','',''),(6389,'1','302','1',1,'Retail Sale Id 6174',2200.64,0.00,0.00,2.99,254.15,'2023-02-14 12:56:35','',''),(6390,'1','302','1',1,'Retail Sale Id 6174',9200.00,0.00,0.00,12.50,1062.50,'2023-02-14 12:56:35','',''),(6391,'1','302','1',1,'Retail Sale Id 6175',2796.80,0.00,0.00,3.80,323.00,'2023-02-14 13:02:16','',''),(6392,'1','302','1',1,'Retail Sale Id 6176',9200.00,0.00,0.00,12.50,1062.50,'2023-02-14 13:05:28','',''),(6393,'1','302','1',1,'Retail Sale Id 6177',3900.80,0.00,0.00,5.30,450.50,'2023-02-14 13:10:44','',''),(6394,'1','302','1',1,'Retail Sale Id 6178',2208.00,0.00,0.00,3.00,255.00,'2023-02-14 13:12:04','',''),(6395,'1','302','1',1,'Retail Sale Id 6179',9200.00,0.00,0.00,12.50,1062.50,'2023-02-14 13:21:43','',''),(6396,'1','302','1',1,'Retail Sale Id 6180',4416.00,0.00,0.00,6.00,510.00,'2023-02-14 13:22:31','',''),(6397,'1','302','1',1,'Retail Sale Id 6181',3680.00,0.00,0.00,5.00,425.00,'2023-02-14 13:45:06','',''),(6398,'1','302','1',1,'Retail Sale Id 6182',4416.00,0.00,0.00,6.00,510.00,'2023-02-14 13:47:26','',''),(6399,'1','302','1',1,'Retail Sale Id 6183',17750.00,0.00,0.00,25.00,1475.00,'2023-02-14 13:54:54','',''),(6400,'1','302','1',1,'Retail Sale Id 6184',1472.00,0.00,0.00,2.00,170.00,'2023-02-14 14:36:21','',''),(6401,'1','302','1',1,'Retail Sale Id 6185',2001.92,0.00,0.00,2.72,231.20,'2023-02-14 14:37:29','',''),(6402,'1','302','1',1,'Retail Sale Id 6186',2001.92,0.00,0.00,2.72,231.20,'2023-02-14 14:39:54','',''),(6403,'1','302','1',1,'Retail Sale Id 6187',7499.84,0.00,0.00,10.19,866.15,'2023-02-14 14:45:37','',''),(6404,'1','302','1',1,'Retail Sale Id 6188',9200.00,0.00,0.00,12.50,1062.50,'2023-02-14 14:46:55','',''),(6405,'1','302','1',1,'Retail Sale Id 6189',4423.36,0.00,0.00,6.01,510.85,'2023-02-14 14:48:38','',''),(6406,'1','302','1',1,'Retail Sale Id 6190',4401.28,0.00,0.00,5.98,508.30,'2023-02-14 14:50:09','',''),(6407,'1','302','1',1,'Retail Sale Id 6191',736.00,0.00,0.00,1.00,85.00,'2023-02-14 14:55:14','',''),(6408,'1','302','1',1,'Retail Sale Id 6192',699.20,0.00,0.00,0.95,80.75,'2023-02-14 14:57:45','',''),(6409,'1','302','1',1,'Retail Sale Id 6193',4496.96,0.00,0.00,6.11,519.35,'2023-02-14 15:02:45','',''),(6410,'1','302','1',1,'Retail Sale Id 6194',3856.64,0.00,0.00,5.24,445.40,'2023-02-14 15:06:42','',''),(6411,'1','302','1',1,'Retail Sale Id 6195',2208.00,0.00,0.00,3.00,255.00,'2023-02-14 15:08:25','',''),(6412,'1','302','1',1,'Retail Sale Id 6196',1398.40,0.00,0.00,1.90,161.50,'2023-02-14 15:17:18','',''),(6413,'1','302','1',1,'Retail Sale Id 6197',1472.00,0.00,0.00,2.00,170.00,'2023-02-14 15:19:10','',''),(6414,'1','302','1',1,'Retail Sale Id 6198',35500.00,0.00,0.00,50.00,2950.00,'2023-02-14 15:20:52','',''),(6415,'1','302','1',1,'Retail Sale Id 6199',1501.44,0.00,0.00,2.04,173.40,'2023-02-14 15:23:42','',''),(6416,'1','302','1',1,'Retail Sale Id 6200',2208.00,0.00,0.00,3.00,255.00,'2023-02-14 15:29:33','',''),(6417,'1','302','1',1,'Retail Sale Id 6201',42600.00,0.00,0.00,60.00,3540.00,'2023-02-14 15:34:28','',''),(6418,'1','302','1',1,'Retail Sale Id 6202',4416.00,0.00,0.00,6.00,510.00,'2023-02-14 15:46:13','',''),(6419,'1','302','1',1,'Retail Sale Id 6203',3002.88,0.00,0.00,4.08,346.80,'2023-02-14 15:52:07','',''),(6420,'1','302','1',1,'Retail Sale Id 6204',71000.00,0.00,0.00,100.00,5900.00,'2023-02-14 15:57:30','',''),(6421,'1','302','1',1,'Retail Sale Id 6205',3680.00,0.00,0.00,5.00,425.00,'2023-02-14 16:00:57','',''),(6422,'1','302','1',1,'Retail Sale Id 6206',2208.00,0.00,0.00,3.00,255.00,'2023-02-14 16:13:09','',''),(6423,'1','302','1',1,'Retail Sale Id 6207',1501.44,0.00,0.00,2.04,173.40,'2023-02-14 16:26:59','',''),(6424,'1','302','1',1,'Retail Sale Id 6208',1472.00,0.00,0.00,2.00,170.00,'2023-02-14 16:38:58','',''),(6425,'1','302','1',1,'Retail Sale Id 6209',2208.00,0.00,0.00,3.00,255.00,'2023-02-14 16:56:19','',''),(6426,'1','302','1',1,'Retail Sale Id 6210',1501.44,0.00,0.00,2.04,173.40,'2023-02-14 16:57:17','',''),(6427,'1','302','1',1,'Retail Sale Id 6211',35500.00,0.00,0.00,50.00,2950.00,'2023-02-14 17:00:43','',''),(6428,'1','302','1',1,'Retail Sale Id 6212',2001.92,0.00,0.00,2.72,231.20,'2023-02-14 17:05:07','',''),(6429,'1','302','1',1,'Retail Sale Id 6213',1104.00,0.00,0.00,1.50,127.50,'2023-02-14 17:20:26','',''),(6430,'1','302','1',1,'Retail Sale Id 6214',2208.00,0.00,0.00,3.00,255.00,'2023-02-14 17:21:41','',''),(6431,'1','302','1',1,'Retail Sale Id 6215',2208.00,0.00,0.00,3.00,255.00,'2023-02-14 17:25:04','',''),(6432,'1','302','1',1,'Retail Sale Id 6216',1501.44,0.00,0.00,2.04,173.40,'2023-02-14 17:26:05','',''),(6433,'1','302','1',1,'Retail Sale Id 6217',6390.00,0.00,0.00,9.00,531.00,'2023-02-14 17:32:43','',''),(6434,'1','302','1',1,'Retail Sale Id 6218',2001.92,0.00,0.00,2.72,231.20,'2023-02-14 17:50:02','',''),(6435,'1','302','1',1,'Retail Sale Id 6219',4416.00,0.00,0.00,6.00,510.00,'2023-02-14 17:52:12','',''),(6436,'1','302','1',1,'Retail Sale Id 6219',4416.00,0.00,0.00,6.00,510.00,'2023-02-14 17:52:12','',''),(6437,'1','302','1',1,'Retail Sale Id 6220',3680.00,0.00,0.00,5.00,425.00,'2023-02-14 17:52:55','',''),(6438,'1','302','1',1,'Retail Sale Id 6221',2208.00,0.00,0.00,3.00,255.00,'2023-02-14 17:53:39','',''),(6439,'1','302','1',1,'Retail Sale Id 6222',699.20,0.00,0.00,0.95,80.75,'2023-02-14 17:54:21','',''),(6440,'1','302','1',1,'Retail Sale Id 6224',2502.40,0.00,0.00,3.40,289.00,'2023-02-14 18:01:14','',''),(6441,'1','302','1',1,'Retail Sale Id 6225',4416.00,0.00,0.00,6.00,510.00,'2023-02-14 18:10:32','',''),(6442,'1','302','1',1,'Retail Sale Id 6226',802.24,0.00,0.00,1.09,92.65,'2023-02-14 18:16:09','',''),(6443,'1','302','1',1,'Retail Sale Id 6227',2208.00,0.00,0.00,3.00,255.00,'2023-02-14 18:20:08','',''),(6444,'1','302','1',1,'Retail Sale Id 6228',1000.96,0.00,0.00,1.36,115.60,'2023-02-14 18:21:47','',''),(6445,'1','302','1',1,'Retail Sale Id 6230',5005.50,0.00,0.00,7.05,415.95,'2023-02-14 18:30:58','',''),(6446,'1','302','1',1,'Retail Sale Id 6231',4997.44,0.00,0.00,6.79,577.15,'2023-02-14 18:32:57','',''),(6447,'1','302','1',1,'Retail Sale Id 6232',1000.96,0.00,0.00,1.36,115.60,'2023-02-14 18:38:30','',''),(6448,'1','302','1',1,'Retail Sale Id 6233',1000.96,0.00,0.00,1.36,115.60,'2023-02-14 18:43:48','',''),(6449,'1','302','1',1,'Retail Sale Id 6234',35500.00,0.00,0.00,50.00,2950.00,'2023-02-14 18:48:15','',''),(6450,'1','302','1',1,'Return of Retail Sale Id 6190',0.00,4401.28,5.98,0.00,-508.30,'2023-02-14 19:27:35','',''),(6451,'1','302','1',1,'Return of Retail Sale Id 6233',0.00,1000.96,1.36,0.00,-115.60,'2023-02-14 19:29:45','',''),(6452,'1','302','1',1,'Retail Sale Id 6235',309.12,0.00,0.00,0.42,35.70,'2023-02-14 19:30:31','',''),(6453,'1','302','1',1,'Retail Sale Id 6236',1501.44,0.00,0.00,2.04,173.40,'2023-02-15 07:59:16','',''),(6454,'1','302','1',1,'Retail Sale Id 6237',3680.00,0.00,0.00,5.00,425.00,'2023-02-15 08:11:28','',''),(6455,'1','302','1',1,'Retail Sale Id 6237',4416.00,0.00,0.00,6.00,510.00,'2023-02-15 08:11:28','',''),(6456,'1','302','1',1,'Retail Sale Id 6238',9200.00,0.00,0.00,12.50,1062.50,'2023-02-15 08:12:49','',''),(6457,'1','302','1',1,'Retail Sale Id 6239',2208.00,0.00,0.00,3.00,255.00,'2023-02-15 08:13:59','',''),(6458,'1','302','1',1,'Retail Sale Id 6240',2208.00,0.00,0.00,3.00,255.00,'2023-02-15 08:15:12','',''),(6459,'1','302','1',1,'Retail Sale Id 6241',3002.88,0.00,0.00,4.08,346.80,'2023-02-15 08:22:40','',''),(6460,'1','302','1',1,'Retail Sale Id 6241',4997.44,0.00,0.00,6.79,577.15,'2023-02-15 08:22:40','',''),(6461,'1','302','1',1,'Retail Sale Id 6242',2502.40,0.00,0.00,3.40,289.00,'2023-02-15 08:39:47','',''),(6462,'1','302','1',1,'Retail Sale Id 6243',2200.64,0.00,0.00,2.99,254.15,'2023-02-15 08:51:57','',''),(6463,'1','302','1',1,'Retail Sale Id 6245',14499.20,0.00,0.00,19.70,1674.50,'2023-02-15 08:58:44','',''),(6464,'1','302','1',1,'Retail Sale Id 6246',1501.44,0.00,0.00,2.04,173.40,'2023-02-15 09:00:06','',''),(6465,'1','302','1',1,'Retail Sale Id 6247',1597.12,0.00,0.00,2.17,184.45,'2023-02-15 09:03:16','',''),(6466,'1','302','1',1,'Retail Sale Id 6248',1000.96,0.00,0.00,1.36,115.60,'2023-02-15 09:03:59','',''),(6467,'1','302','1',1,'Retail Sale Id 6249',106500.00,0.00,0.00,150.00,8850.00,'2023-02-15 09:05:33','',''),(6468,'1','302','1',1,'Retail Sale Id 6250',802.24,0.00,0.00,1.09,92.65,'2023-02-15 09:09:56','',''),(6469,'1','302','1',1,'Retail Sale Id 6251',2208.00,0.00,0.00,3.00,255.00,'2023-02-15 09:12:54','',''),(6470,'1','302','1',1,'Retail Sale Id 6252',2001.92,0.00,0.00,2.72,231.20,'2023-02-15 09:15:02','',''),(6471,'1','302','1',1,'Retail Sale Id 6253',2001.92,0.00,0.00,2.72,231.20,'2023-02-15 09:17:19','',''),(6472,'1','302','1',1,'Retail Sale Id 6254',3599.04,0.00,0.00,4.89,415.65,'2023-02-15 09:23:44','',''),(6473,'1','302','1',1,'Retail Sale Id 6255',9200.00,0.00,0.00,12.50,1062.50,'2023-02-15 09:49:09','',''),(6474,'1','302','1',1,'Retail Sale Id 6256',802.24,0.00,0.00,1.09,92.65,'2023-02-15 09:54:59','',''),(6475,'1','302','1',1,'Retail Sale Id 6257',2502.40,0.00,0.00,3.40,289.00,'2023-02-15 09:56:37','',''),(6476,'1','302','1',1,'Retail Sale Id 6258',2001.92,0.00,0.00,2.72,231.20,'2023-02-15 09:57:51','',''),(6477,'1','302','1',1,'Retail Sale Id 6259',2208.00,0.00,0.00,3.00,255.00,'2023-02-15 09:59:03','',''),(6478,'1','302','1',1,'Retail Sale Id 6260',4416.00,0.00,0.00,6.00,510.00,'2023-02-15 10:05:11','',''),(6479,'1','302','1',1,'Retail Sale Id 6261',1000.96,0.00,0.00,1.36,115.60,'2023-02-15 10:15:09','',''),(6480,'1','302','1',1,'Retail Sale Id 6262',2944.00,0.00,0.00,4.00,340.00,'2023-02-15 10:30:53','',''),(6481,'1','302','1',1,'Retail Sale Id 6263',4416.00,0.00,0.00,6.00,510.00,'2023-02-15 10:34:31','',''),(6482,'1','302','1',1,'Retail Sale Id 6264',17750.00,0.00,0.00,25.00,1475.00,'2023-02-15 10:40:25','',''),(6483,'1','302','1',1,'Retail Sale Id 6265',9200.00,0.00,0.00,12.50,1062.50,'2023-02-15 10:44:58','',''),(6484,'1','302','1',1,'Retail Sale Id 6266',2001.92,0.00,0.00,2.72,231.20,'2023-02-15 10:46:27','',''),(6485,'1','302','1',1,'Retail Sale Id 6267',3996.48,0.00,0.00,5.43,461.55,'2023-02-15 10:50:48','',''),(6486,'1','302','1',1,'Retail Sale Id 6268',2208.00,0.00,0.00,3.00,255.00,'2023-02-15 10:55:05','',''),(6487,'1','302','1',1,'Retail Sale Id 6269',4997.44,0.00,0.00,6.79,577.15,'2023-02-15 10:56:25','',''),(6488,'1','302','1',1,'Retail Sale Id 6270',2208.00,0.00,0.00,3.00,255.00,'2023-02-15 11:04:23','',''),(6489,'1','302','1',1,'Retail Sale Id 6271',4416.00,0.00,0.00,6.00,510.00,'2023-02-15 11:16:29','',''),(6490,'1','302','1',1,'Retail Sale Id 6272',2001.92,0.00,0.00,2.72,231.20,'2023-02-15 11:17:58','',''),(6491,'1','302','1',1,'Retail Sale Id 6273',35500.00,0.00,0.00,50.00,2950.00,'2023-02-15 11:19:40','',''),(6492,'1','302','1',1,'Retail Sale Id 6274',7360.00,0.00,0.00,10.00,850.00,'2023-02-15 11:30:30','',''),(6493,'1','302','1',1,'Retail Sale Id 6275',3680.00,0.00,0.00,5.00,425.00,'2023-02-15 11:36:16','',''),(6494,'1','302','1',1,'Retail Sale Id 6276',699.20,0.00,0.00,0.95,80.75,'2023-02-15 11:48:16','',''),(6495,'1','302','1',1,'Retail Sale Id 6277',9200.00,0.00,0.00,12.50,1062.50,'2023-02-15 11:54:04','',''),(6496,'1','302','1',1,'Retail Sale Id 6278',2208.00,0.00,0.00,3.00,255.00,'2023-02-15 11:56:32','',''),(6497,'1','302','1',1,'Retail Sale Id 6279',2001.92,0.00,0.00,2.72,231.20,'2023-02-15 11:57:34','',''),(6498,'1','302','1',1,'Retail Sale Id 6280',9200.00,0.00,0.00,12.50,1062.50,'2023-02-15 12:14:54','',''),(6499,'1','302','1',1,'Retail Sale Id 6281',35500.00,0.00,0.00,50.00,2950.00,'2023-02-15 12:18:36','',''),(6500,'1','302','1',1,'Retail Sale Id 6282',11040.00,0.00,0.00,15.00,1275.00,'2023-02-15 12:20:11','',''),(6501,'1','302','1',1,'Retail Sale Id 6283',11040.00,0.00,0.00,15.00,1275.00,'2023-02-15 12:21:25','',''),(6502,'1','302','1',1,'Retail Sale Id 6284',2208.00,0.00,0.00,3.00,255.00,'2023-02-15 12:30:50','',''),(6503,'1','302','1',1,'Retail Sale Id 6285',2001.92,0.00,0.00,2.72,231.20,'2023-02-15 12:32:14','',''),(6504,'1','302','1',1,'Retail Sale Id 6286',5152.00,0.00,0.00,7.00,595.00,'2023-02-15 12:39:01','',''),(6505,'1','302','1',1,'Retail Sale Id 6287',4416.00,0.00,0.00,6.00,510.00,'2023-02-15 12:46:22','',''),(6506,'1','302','1',1,'Retail Sale Id 6288',18400.00,0.00,0.00,25.00,2125.00,'2023-02-15 12:48:54','',''),(6507,'1','302','1',1,'Retail Sale Id 6289',2208.00,0.00,0.00,3.00,255.00,'2023-02-15 12:56:12','',''),(6508,'1','302','1',1,'Retail Sale Id 6290',897.92,0.00,0.00,1.22,103.70,'2023-02-15 13:24:50','',''),(6509,'1','302','1',1,'Retail Sale Id 6292',2130.00,0.00,0.00,3.00,177.00,'2023-02-15 13:28:56','',''),(6510,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,47392.80,72.80,0.00,0.00,'2023-02-15 17:08:55','',''),(6511,'1','302',NULL,1,'Reception corrector for bridging 37',0.00,0.00,0.00,72.80,0.00,'2023-02-15 17:12:48','',''),(6512,'1','302','1',1,'Received from bridging 37',0.00,0.00,72.80,0.00,0.00,'2023-02-15 17:12:48','',''),(6513,'1','302','1',1,'Retail Sale Id 6294',4970.00,0.00,0.00,7.00,413.00,'2023-02-15 17:21:49','',''),(6514,'1','302','1',1,'Retail Sale Id 6295',48428.80,0.00,0.00,65.80,5593.00,'2023-02-15 17:22:32','',''),(6515,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3569400.00,5400.00,0.00,0.00,'2023-02-16 10:45:30','',''),(6516,'1','302',NULL,1,'Reception corrector for bridging 38',0.00,0.00,0.00,5400.00,0.00,'2023-02-16 10:48:00','',''),(6517,'1','302','1',1,'Received from bridging 38',0.00,0.00,5400.00,0.00,0.00,'2023-02-16 10:48:00','',''),(6518,'1','302','1',1,'Retail Sale Id 6298',1501.44,0.00,0.00,2.04,153.00,'2023-02-16 10:51:00','',''),(6519,'1','302','1',1,'Retail Sale Id 6300',9200.00,0.00,0.00,12.50,937.50,'2023-02-16 11:00:03','',''),(6520,'1','302','1',1,'Retail Sale Id 6300',9200.00,0.00,0.00,12.50,937.50,'2023-02-16 11:00:03','',''),(6521,'1','302','1',1,'Retail Sale Id 6300',9200.00,0.00,0.00,12.50,937.50,'2023-02-16 11:00:03','',''),(6522,'1','302','1',1,'Retail Sale Id 6302',134147.40,0.00,0.00,188.94,9258.06,'2023-02-16 11:02:18','',''),(6523,'1','302','1',1,'Retail Sale Id 6303',128468.80,0.00,0.00,174.55,13091.25,'2023-02-16 11:02:59','',''),(6524,'1','302','1',1,'Retail Sale Id 6304',4416.00,0.00,0.00,6.00,450.00,'2023-02-16 11:04:14','',''),(6525,'1','302','1',1,'Retail Sale Id 6305',4416.00,0.00,0.00,6.00,450.00,'2023-02-16 11:10:50','',''),(6526,'1','302','1',1,'Retail Sale Id 6305',4416.00,0.00,0.00,6.00,450.00,'2023-02-16 11:10:50','',''),(6527,'1','302','1',1,'Retail Sale Id 6306',500.48,0.00,0.00,0.68,51.00,'2023-02-16 11:12:32','',''),(6528,'1','302','1',1,'Retail Sale Id 6307',9200.00,0.00,0.00,12.50,937.50,'2023-02-16 11:14:16','',''),(6529,'1','302','1',1,'Retail Sale Id 6308',1803.20,0.00,0.00,2.45,183.75,'2023-02-16 11:18:19','',''),(6530,'1','302','1',1,'Retail Sale Id 6309',9200.00,0.00,0.00,12.50,937.50,'2023-02-16 11:23:28','',''),(6531,'1','302','1',1,'Retail Sale Id 6310',1000.96,0.00,0.00,1.36,102.00,'2023-02-16 11:32:34','',''),(6532,'1','302','1',1,'Retail Sale Id 6311',4416.00,0.00,0.00,6.00,450.00,'2023-02-16 11:34:24','',''),(6533,'1','302','1',1,'Retail Sale Id 6312',3996.48,0.00,0.00,5.43,407.25,'2023-02-16 11:37:39','',''),(6534,'1','302','1',1,'Retail Sale Id 6313',2001.92,0.00,0.00,2.72,204.00,'2023-02-16 11:40:39','',''),(6535,'1','302','1',1,'Retail Sale Id 6314',4416.00,0.00,0.00,6.00,450.00,'2023-02-16 11:50:19','',''),(6536,'1','302','1',1,'Retail Sale Id 6315',4416.00,0.00,0.00,6.00,450.00,'2023-02-16 11:57:19','',''),(6537,'1','302','1',1,'Retail Sale Id 6316',35500.00,0.00,0.00,50.00,2450.00,'2023-02-16 12:02:58','',''),(6538,'1','302','1',1,'Retail Sale Id 6317',9200.00,0.00,0.00,12.50,937.50,'2023-02-16 12:11:47','',''),(6539,'1','302','1',1,'Retail Sale Id 6318',2001.92,0.00,0.00,2.72,204.00,'2023-02-16 12:13:12','',''),(6540,'1','302','1',1,'Retail Sale Id 6319',9200.00,0.00,0.00,12.50,937.50,'2023-02-16 12:20:39','',''),(6541,'1','302','1',1,'Retail Sale Id 6319',9200.00,0.00,0.00,12.50,937.50,'2023-02-16 12:20:39','',''),(6542,'1','302','1',1,'Retail Sale Id 6320',4416.00,0.00,0.00,6.00,450.00,'2023-02-16 12:23:02','',''),(6543,'1','302','1',1,'Retail Sale Id 6320',4416.00,0.00,0.00,6.00,450.00,'2023-02-16 12:23:02','',''),(6544,'1','302','1',1,'Retail Sale Id 6321',1398.40,0.00,0.00,1.90,142.50,'2023-02-16 12:29:02','',''),(6545,'1','302','1',1,'Retail Sale Id 6322',2001.92,0.00,0.00,2.72,204.00,'2023-02-16 12:30:33','',''),(6546,'1','302','1',1,'Retail Sale Id 6323',2001.92,0.00,0.00,2.72,204.00,'2023-02-16 12:33:04','',''),(6547,'1','302','1',1,'Retail Sale Id 6324',1000.96,0.00,0.00,1.36,102.00,'2023-02-16 12:33:57','',''),(6548,'1','302','1',1,'Retail Sale Id 6325',1472.00,0.00,0.00,2.00,150.00,'2023-02-16 12:45:52','',''),(6549,'1','302','1',1,'Retail Sale Id 6326',4416.00,0.00,0.00,6.00,450.00,'2023-02-16 12:47:46','',''),(6550,'1','302','1',1,'Retail Sale Id 6327',35500.00,0.00,0.00,50.00,2450.00,'2023-02-16 12:53:20','',''),(6551,'1','302','1',1,'Retail Sale Id 6328',3680.00,0.00,0.00,5.00,375.00,'2023-02-16 12:56:49','',''),(6552,'1','302','1',1,'Retail Sale Id 6329',4416.00,0.00,0.00,6.00,450.00,'2023-02-16 12:58:53','',''),(6553,'1','302','1',1,'Retail Sale Id 6330',9200.00,0.00,0.00,12.50,937.50,'2023-02-16 13:00:19','',''),(6554,'1','302','1',1,'Retail Sale Id 6331',4416.00,0.00,0.00,6.00,450.00,'2023-02-16 13:02:27','',''),(6555,'1','302','1',1,'Retail Sale Id 6332',4416.00,0.00,0.00,6.00,450.00,'2023-02-16 13:03:39','',''),(6556,'1','302','1',1,'Retail Sale Id 6333',9200.00,0.00,0.00,12.50,937.50,'2023-02-16 13:08:50','',''),(6557,'1','302','1',1,'Retail Sale Id 6334',1501.44,0.00,0.00,2.04,153.00,'2023-02-16 13:10:45','',''),(6558,'1','302','1',1,'Retail Sale Id 6335',4416.00,0.00,0.00,6.00,450.00,'2023-02-16 13:12:48','',''),(6559,'1','302','1',1,'Retail Sale Id 6336',4416.00,0.00,0.00,6.00,450.00,'2023-02-16 13:14:03','',''),(6560,'1','302','1',1,'Retail Sale Id 6337',35500.00,0.00,0.00,50.00,2450.00,'2023-02-16 13:17:06','',''),(6561,'1','302','1',1,'Retail Sale Id 6338',2208.00,0.00,0.00,3.00,225.00,'2023-02-16 13:19:16','',''),(6562,'1','302','1',1,'Retail Sale Id 6339',4416.00,0.00,0.00,6.00,450.00,'2023-02-16 13:20:21','',''),(6563,'1','302','1',1,'Retail Sale Id 6340',2001.92,0.00,0.00,2.72,204.00,'2023-02-16 13:26:17','',''),(6564,'1','302','1',1,'Retail Sale Id 6341',2208.00,0.00,0.00,3.00,225.00,'2023-02-16 13:27:47','',''),(6565,'1','302','1',1,'Retail Sale Id 6342',2001.92,0.00,0.00,2.72,204.00,'2023-02-16 13:35:02','',''),(6566,'1','302','1',1,'Retail Sale Id 6343',3002.88,0.00,0.00,4.08,306.00,'2023-02-16 13:39:13','',''),(6567,'1','302','1',1,'Retail Sale Id 6344',9200.00,0.00,0.00,12.50,937.50,'2023-02-16 13:41:06','',''),(6568,'1','302','1',1,'Retail Sale Id 6345',9200.00,0.00,0.00,12.50,937.50,'2023-02-16 13:45:33','',''),(6569,'1','302','1',1,'Retail Sale Id 6346',3002.88,0.00,0.00,4.08,306.00,'2023-02-16 13:48:01','',''),(6570,'1','302','1',1,'Retail Sale Id 6347',1472.00,0.00,0.00,2.00,150.00,'2023-02-16 13:51:25','',''),(6571,'1','302','1',1,'Retail Sale Id 6348',9200.00,0.00,0.00,12.50,937.50,'2023-02-16 13:52:17','',''),(6572,'1','302','1',1,'Retail Sale Id 6349',3680.00,0.00,0.00,5.00,375.00,'2023-02-16 13:57:29','',''),(6573,'1','302','1',1,'Retail Sale Id 6350',2208.00,0.00,0.00,3.00,225.00,'2023-02-16 14:01:16','',''),(6574,'1','302','1',1,'Retail Sale Id 6351',1501.44,0.00,0.00,2.04,153.00,'2023-02-16 14:02:17','',''),(6575,'1','302','1',1,'Retail Sale Id 6352',3680.00,0.00,0.00,5.00,375.00,'2023-02-16 14:03:27','',''),(6576,'1','302','1',1,'Retail Sale Id 6353',3503.36,0.00,0.00,4.76,357.00,'2023-02-16 14:04:11','',''),(6577,'1','302','1',1,'Retail Sale Id 6354',1472.00,0.00,0.00,2.00,150.00,'2023-02-16 14:07:07','',''),(6578,'1','302','1',1,'Retail Sale Id 6354',1472.00,0.00,0.00,2.00,150.00,'2023-02-16 14:07:07','',''),(6579,'1','302','1',1,'Retail Sale Id 6354',2208.00,0.00,0.00,3.00,225.00,'2023-02-16 14:07:07','',''),(6580,'1','302','1',1,'Retail Sale Id 6355',1302.72,0.00,0.00,1.77,132.75,'2023-02-16 14:09:54','',''),(6581,'1','302','1',1,'Retail Sale Id 6356',2303.68,0.00,0.00,3.13,234.75,'2023-02-16 14:11:53','',''),(6582,'1','302','1',1,'Retail Sale Id 6357',9200.00,0.00,0.00,12.50,937.50,'2023-02-16 14:14:06','',''),(6583,'1','302','1',1,'Retail Sale Id 6358',9200.00,0.00,0.00,12.50,937.50,'2023-02-16 14:15:19','',''),(6584,'1','302','1',1,'Retail Sale Id 6359',2001.92,0.00,0.00,2.72,204.00,'2023-02-16 14:23:58','',''),(6585,'1','302','1',1,'Retail Sale Id 6360',9200.00,0.00,0.00,12.50,937.50,'2023-02-16 14:33:15','',''),(6586,'1','302','1',1,'Retail Sale Id 6361',35500.00,0.00,0.00,50.00,2450.00,'2023-02-16 14:39:00','',''),(6587,'1','302','1',1,'Retail Sale Id 6362',4416.00,0.00,0.00,6.00,450.00,'2023-02-16 14:40:13','',''),(6588,'1','302','1',1,'Retail Sale Id 6363',5888.00,0.00,0.00,8.00,600.00,'2023-02-16 15:06:43','',''),(6589,'1','302','1',1,'Retail Sale Id 6364',3996.48,0.00,0.00,5.43,407.25,'2023-02-16 15:09:26','',''),(6590,'1','302','1',1,'Retail Sale Id 6365',4416.00,0.00,0.00,6.00,450.00,'2023-02-16 15:10:44','',''),(6591,'1','302','1',1,'Retail Sale Id 6366',4416.00,0.00,0.00,6.00,450.00,'2023-02-16 15:13:02','',''),(6592,'1','302','1',1,'Retail Sale Id 6367',29820.00,0.00,0.00,42.00,2058.00,'2023-02-16 15:15:54','',''),(6593,'1','302','1',1,'Retail Sale Id 6369',2502.40,0.00,0.00,3.40,255.00,'2023-02-16 15:19:30','',''),(6594,'1','302','1',1,'Retail Sale Id 6370',7810.00,0.00,0.00,11.00,539.00,'2023-02-16 15:21:38','',''),(6595,'1','302','1',1,'Retail Sale Id 6371',1000.96,0.00,0.00,1.36,102.00,'2023-02-16 15:37:49','',''),(6596,'1','302','1',1,'Retail Sale Id 6373',2303.68,0.00,0.00,3.13,234.75,'2023-02-16 15:55:48','',''),(6597,'1','302','1',1,'Retail Sale Id 6374',1501.44,0.00,0.00,2.04,153.00,'2023-02-16 16:08:02','',''),(6598,'1','302','1',1,'Retail Sale Id 6375',2130.00,0.00,0.00,3.00,147.00,'2023-02-16 16:16:24','',''),(6599,'1','302','1',1,'Retail Sale Id 6376',9200.00,0.00,0.00,12.50,937.50,'2023-02-16 16:24:37','',''),(6600,'1','302','1',1,'Retail Sale Id 6377',9200.00,0.00,0.00,12.50,937.50,'2023-02-16 16:30:53','',''),(6601,'1','302','1',1,'Retail Sale Id 6378',2208.00,0.00,0.00,3.00,225.00,'2023-02-16 16:34:00','',''),(6602,'1','302','1',1,'Retail Sale Id 6379',9200.00,0.00,0.00,12.50,937.50,'2023-02-16 16:35:04','',''),(6603,'1','302','1',1,'Retail Sale Id 6380',3002.88,0.00,0.00,4.08,306.00,'2023-02-16 16:36:12','',''),(6604,'1','302','1',1,'Retail Sale Id 6381',9200.00,0.00,0.00,12.50,937.50,'2023-02-16 16:41:31','',''),(6605,'1','302','1',1,'Retail Sale Id 6383',4416.00,0.00,0.00,6.00,450.00,'2023-02-16 16:55:07','',''),(6606,'1','302','1',1,'Retail Sale Id 6384',9200.00,0.00,0.00,12.50,937.50,'2023-02-16 17:05:03','',''),(6607,'1','302','1',1,'Retail Sale Id 6384',9200.00,0.00,0.00,12.50,937.50,'2023-02-16 17:05:03','',''),(6608,'1','302','1',1,'Retail Sale Id 6385',2208.00,0.00,0.00,3.00,225.00,'2023-02-16 17:05:50','',''),(6609,'1','302','1',1,'Retail Sale Id 6386',9940.00,0.00,0.00,14.00,686.00,'2023-02-16 17:07:32','',''),(6610,'1','302','1',1,'Retail Sale Id 6387',9200.00,0.00,0.00,12.50,937.50,'2023-02-16 17:08:51','',''),(6611,'1','302','1',1,'Retail Sale Id 6388',9001.28,0.00,0.00,12.23,917.25,'2023-02-16 17:10:29','',''),(6612,'1','302','1',1,'Retail Sale Id 6389',4416.00,0.00,0.00,6.00,450.00,'2023-02-16 17:18:33','',''),(6613,'1','302','1',1,'Retail Sale Id 6390',2208.00,0.00,0.00,3.00,225.00,'2023-02-16 17:19:55','',''),(6614,'1','302','1',1,'Retail Sale Id 6391',1472.00,0.00,0.00,2.00,150.00,'2023-02-16 17:20:50','',''),(6615,'1','302','1',1,'Retail Sale Id 6392',1472.00,0.00,0.00,2.00,150.00,'2023-02-16 17:29:04','',''),(6616,'1','302','1',1,'Retail Sale Id 6393',2001.92,0.00,0.00,2.72,204.00,'2023-02-16 17:33:24','',''),(6617,'1','302','1',1,'Retail Sale Id 6394',1501.44,0.00,0.00,2.04,153.00,'2023-02-16 17:34:05','',''),(6618,'1','302','1',1,'Retail Sale Id 6395',9200.00,0.00,0.00,12.50,937.50,'2023-02-16 17:38:25','',''),(6619,'1','302','1',1,'Retail Sale Id 6396',3002.88,0.00,0.00,4.08,306.00,'2023-02-16 17:43:47','',''),(6620,'1','302','1',1,'Retail Sale Id 6397',3002.88,0.00,0.00,4.08,306.00,'2023-02-16 17:45:28','',''),(6621,'1','302','1',1,'Retail Sale Id 6398',1000.96,0.00,0.00,1.36,102.00,'2023-02-16 17:46:55','',''),(6622,'1','302','1',1,'Retail Sale Id 6398',2001.92,0.00,0.00,2.72,204.00,'2023-02-16 17:46:55','',''),(6623,'1','302','1',1,'Retail Sale Id 6399',3680.00,0.00,0.00,5.00,375.00,'2023-02-16 18:00:16','',''),(6624,'1','302','1',1,'Retail Sale Id 6400',2001.92,0.00,0.00,2.72,204.00,'2023-02-16 18:14:43','',''),(6625,'1','302','1',1,'Retail Sale Id 6401',2001.92,0.00,0.00,2.72,204.00,'2023-02-16 18:19:35','',''),(6626,'1','302','1',1,'Retail Sale Id 6402',1000.96,0.00,0.00,1.36,102.00,'2023-02-16 18:24:01','',''),(6627,'1','302','1',1,'Retail Sale Id 6403',750.72,0.00,0.00,1.02,76.50,'2023-02-16 18:41:00','',''),(6628,'1','302','1',1,'Return of Retail Sale Id 6399',0.00,3680.00,5.00,0.00,-375.00,'2023-02-16 19:16:05','',''),(6629,'1','302','1',1,'Retail Sale Id 6404',73.60,0.00,0.00,0.10,7.50,'2023-02-16 19:18:42','',''),(6630,'1','302','1',1,'Retail Sale Id 6405',3002.88,0.00,0.00,4.08,306.00,'2023-02-17 07:50:18','',''),(6631,'1','302','1',1,'Retail Sale Id 6406',4416.00,0.00,0.00,6.00,450.00,'2023-02-17 07:52:30','',''),(6632,'1','302','1',1,'Retail Sale Id 6407',44020.00,0.00,0.00,62.00,3038.00,'2023-02-17 08:13:07','',''),(6633,'1','302','1',1,'Retail Sale Id 6408',4496.96,0.00,0.00,6.11,458.25,'2023-02-17 08:14:20','',''),(6634,'1','302','1',1,'Retail Sale Id 6409',9200.00,0.00,0.00,12.50,937.50,'2023-02-17 08:19:32','',''),(6635,'1','302','1',1,'Retail Sale Id 6411',4416.00,0.00,0.00,6.00,450.00,'2023-02-17 08:22:57','',''),(6636,'1','302','1',1,'Retail Sale Id 6412',9200.00,0.00,0.00,12.50,937.50,'2023-02-17 08:31:53','',''),(6637,'1','302','1',1,'Retail Sale Id 6413',3002.88,0.00,0.00,4.08,306.00,'2023-02-17 08:36:33','',''),(6638,'1','302','1',1,'Retail Sale Id 6414',2502.40,0.00,0.00,3.40,255.00,'2023-02-17 08:37:59','',''),(6639,'1','302','1',1,'Retail Sale Id 6415',9200.00,0.00,0.00,12.50,937.50,'2023-02-17 08:42:39','',''),(6640,'1','302','1',1,'Retail Sale Id 6416',1803.20,0.00,0.00,2.45,183.75,'2023-02-17 08:52:10','',''),(6641,'1','302','1',1,'Retail Sale Id 6417',2208.00,0.00,0.00,3.00,225.00,'2023-02-17 08:55:41','',''),(6642,'1','302','1',1,'Retail Sale Id 6418',1096.64,0.00,0.00,1.49,111.75,'2023-02-17 09:20:54','',''),(6643,'1','302','1',1,'Retail Sale Id 6419',736.00,0.00,0.00,1.00,75.00,'2023-02-17 09:29:20','',''),(6644,'1','302','1',1,'Retail Sale Id 6420',3680.00,0.00,0.00,5.00,375.00,'2023-02-17 09:40:08','',''),(6645,'1','302','1',1,'Retail Sale Id 6421',1000.96,0.00,0.00,1.36,102.00,'2023-02-17 09:44:51','',''),(6646,'1','302','1',1,'Retail Sale Id 6422',1501.44,0.00,0.00,2.04,153.00,'2023-02-17 09:46:29','',''),(6647,'1','302','1',1,'Retail Sale Id 6423',3002.88,0.00,0.00,4.08,306.00,'2023-02-17 09:55:07','',''),(6648,'1','302','1',1,'Retail Sale Id 6424',1000.96,0.00,0.00,1.36,102.00,'2023-02-17 09:56:21','',''),(6649,'1','302','1',1,'Retail Sale Id 6425',736.00,0.00,0.00,1.00,75.00,'2023-02-17 10:00:24','',''),(6650,'1','302','1',1,'Retail Sale Id 6426',4416.00,0.00,0.00,6.00,450.00,'2023-02-17 10:01:06','',''),(6651,'1','302','1',1,'Retail Sale Id 6427',2001.92,0.00,0.00,2.72,204.00,'2023-02-17 10:08:00','',''),(6652,'1','302','1',1,'Retail Sale Id 6428',38340.00,0.00,0.00,54.00,2646.00,'2023-02-17 10:13:31','',''),(6653,'1','302','1',1,'Retail Sale Id 6429',9200.00,0.00,0.00,12.50,937.50,'2023-02-17 10:14:39','',''),(6654,'1','302','1',1,'Retail Sale Id 6430',3680.00,0.00,0.00,5.00,375.00,'2023-02-17 10:15:48','',''),(6655,'1','302','1',1,'Retail Sale Id 6431',9200.00,0.00,0.00,12.50,937.50,'2023-02-17 10:17:56','',''),(6656,'1','302','1',1,'Retail Sale Id 6433',736.00,0.00,0.00,1.00,75.00,'2023-02-17 10:22:39','',''),(6657,'1','302','1',1,'Retail Sale Id 6434',3680.00,0.00,0.00,5.00,375.00,'2023-02-17 10:36:49','',''),(6658,'1','302','1',1,'Retail Sale Id 6435',4997.44,0.00,0.00,6.79,509.25,'2023-02-17 10:41:54','',''),(6659,'1','302','1',1,'Retail Sale Id 6436',4997.44,0.00,0.00,6.79,509.25,'2023-02-17 10:43:26','',''),(6660,'1','302','1',1,'Retail Sale Id 6437',2208.00,0.00,0.00,3.00,225.00,'2023-02-17 10:46:33','',''),(6661,'1','302','1',1,'Retail Sale Id 6437',2208.00,0.00,0.00,3.00,225.00,'2023-02-17 10:46:33','',''),(6662,'1','302','1',1,'Retail Sale Id 6437',9200.00,0.00,0.00,12.50,937.50,'2023-02-17 10:46:33','',''),(6663,'1','302','1',1,'Retail Sale Id 6438',2944.00,0.00,0.00,4.00,300.00,'2023-02-17 10:49:09','',''),(6664,'1','302','1',1,'Retail Sale Id 6439',8000.32,0.00,0.00,10.87,815.25,'2023-02-17 10:51:44','',''),(6665,'1','302','1',1,'Retail Sale Id 6440',1472.00,0.00,0.00,2.00,150.00,'2023-02-17 10:53:21','',''),(6666,'1','302','1',1,'Retail Sale Id 6441',4496.96,0.00,0.00,6.11,458.25,'2023-02-17 10:57:22','',''),(6667,'1','302','1',1,'Retail Sale Id 6442',4416.00,0.00,0.00,6.00,450.00,'2023-02-17 10:59:07','',''),(6668,'1','302','1',1,'Retail Sale Id 6443',6498.88,0.00,0.00,8.83,662.25,'2023-02-17 11:03:56','',''),(6669,'1','302','1',1,'Retail Sale Id 6444',2001.92,0.00,0.00,2.72,204.00,'2023-02-17 11:05:38','',''),(6670,'1','302','1',1,'Retail Sale Id 6445',4416.00,0.00,0.00,6.00,450.00,'2023-02-17 11:07:59','',''),(6671,'1','302','1',1,'Retail Sale Id 6446',4416.00,0.00,0.00,6.00,450.00,'2023-02-17 11:09:36','',''),(6672,'1','302','1',1,'Retail Sale Id 6447',3503.36,0.00,0.00,4.76,357.00,'2023-02-17 11:15:14','',''),(6673,'1','302','1',1,'Retail Sale Id 6448',4416.00,0.00,0.00,6.00,450.00,'2023-02-17 11:22:08','',''),(6674,'1','302','1',1,'Retail Sale Id 6449',2208.00,0.00,0.00,3.00,225.00,'2023-02-17 11:36:54','',''),(6675,'1','302','1',1,'Retail Sale Id 6450',9001.28,0.00,0.00,12.23,917.25,'2023-02-17 11:42:43','',''),(6676,'1','302','1',1,'Retail Sale Id 6451',21300.00,0.00,0.00,30.00,1470.00,'2023-02-17 11:45:49','',''),(6677,'1','302','1',1,'Retail Sale Id 6452',8000.32,0.00,0.00,10.87,815.25,'2023-02-17 11:47:19','',''),(6678,'1','302','1',1,'Retail Sale Id 6453',2208.00,0.00,0.00,3.00,225.00,'2023-02-17 11:50:58','',''),(6679,'1','302','1',1,'Retail Sale Id 6454',1501.44,0.00,0.00,2.04,153.00,'2023-02-17 11:54:23','',''),(6680,'1','302','1',1,'Retail Sale Id 6455',3680.00,0.00,0.00,5.00,375.00,'2023-02-17 12:02:27','',''),(6681,'1','302','1',1,'Retail Sale Id 6456',9200.00,0.00,0.00,12.50,937.50,'2023-02-17 12:04:21','',''),(6682,'1','302','1',1,'Retail Sale Id 6457',1000.96,0.00,0.00,1.36,102.00,'2023-02-17 12:07:46','',''),(6683,'1','302','1',1,'Retail Sale Id 6458',2208.00,0.00,0.00,3.00,225.00,'2023-02-17 12:12:40','',''),(6684,'1','302','1',1,'Retail Sale Id 6459',9568.00,0.00,0.00,13.00,975.00,'2023-02-17 12:18:39','',''),(6685,'1','302','1',1,'Retail Sale Id 6460',4416.00,0.00,0.00,6.00,450.00,'2023-02-17 12:20:04','',''),(6686,'1','302','1',1,'Retail Sale Id 6461',5998.40,0.00,0.00,8.15,611.25,'2023-02-17 12:27:45','',''),(6687,'1','302','1',1,'Retail Sale Id 6462',8520.00,0.00,0.00,12.00,588.00,'2023-02-17 12:29:47','',''),(6688,'1','302','1',1,'Retail Sale Id 6463',2208.00,0.00,0.00,3.00,225.00,'2023-02-17 12:39:17','',''),(6689,'1','302','1',1,'Retail Sale Id 6464',1472.00,0.00,0.00,2.00,150.00,'2023-02-17 12:44:51','',''),(6690,'1','302','1',1,'Retail Sale Id 6465',3996.48,0.00,0.00,5.43,407.25,'2023-02-17 12:47:28','',''),(6691,'1','302','1',1,'Retail Sale Id 6466',4416.00,0.00,0.00,6.00,450.00,'2023-02-17 12:51:29','',''),(6692,'1','302','1',1,'Retail Sale Id 6467',4416.00,0.00,0.00,6.00,450.00,'2023-02-17 12:53:07','',''),(6693,'1','302','1',1,'Retail Sale Id 6468',106500.00,0.00,0.00,150.00,7350.00,'2023-02-17 13:05:13','',''),(6694,'1','302','1',1,'Retail Sale Id 6469',2944.00,0.00,0.00,4.00,300.00,'2023-02-17 13:22:33','',''),(6695,'1','302','1',1,'Retail Sale Id 6470',1000.96,0.00,0.00,1.36,102.00,'2023-02-17 13:23:48','',''),(6696,'1','302','1',1,'Retail Sale Id 6471',2001.92,0.00,0.00,2.72,204.00,'2023-02-17 13:31:14','',''),(6697,'1','302','1',1,'Retail Sale Id 6472',3680.00,0.00,0.00,5.00,375.00,'2023-02-17 13:32:59','',''),(6698,'1','302','1',1,'Retail Sale Id 6473',1501.44,0.00,0.00,2.04,153.00,'2023-02-17 13:44:32','',''),(6699,'1','302','1',1,'Retail Sale Id 6474',71000.00,0.00,0.00,100.00,4900.00,'2023-02-17 14:04:42','',''),(6700,'1','302','1',1,'Retail Sale Id 6475',1472.00,0.00,0.00,2.00,150.00,'2023-02-17 14:12:28','',''),(6701,'1','302','1',1,'Retail Sale Id 6476',2208.00,0.00,0.00,3.00,225.00,'2023-02-17 14:14:01','',''),(6702,'1','302','1',1,'Retail Sale Id 6477',18400.00,0.00,0.00,25.00,1875.00,'2023-02-17 14:22:36','',''),(6703,'1','302','1',1,'Retail Sale Id 6478',8520.00,0.00,0.00,12.00,588.00,'2023-02-17 14:32:37','',''),(6704,'1','302','1',1,'Retail Sale Id 6479',4416.00,0.00,0.00,6.00,450.00,'2023-02-17 14:39:52','',''),(6705,'1','302','1',1,'Retail Sale Id 6480',9940.00,0.00,0.00,14.00,686.00,'2023-02-17 14:52:19','',''),(6706,'1','302','1',1,'Retail Sale Id 6481',2951.36,0.00,0.00,4.01,300.75,'2023-02-17 14:59:26','',''),(6707,'1','302','1',1,'Retail Sale Id 6482',22816.00,0.00,0.00,31.00,2325.00,'2023-02-17 15:12:03','',''),(6708,'1','302','1',1,'Retail Sale Id 6483',1501.44,0.00,0.00,2.04,153.00,'2023-02-17 15:20:43','',''),(6709,'1','302','1',1,'Retail Sale Id 6484',4496.96,0.00,0.00,6.11,458.25,'2023-02-17 15:35:04','',''),(6710,'1','302','1',1,'Retail Sale Id 6485',9200.00,0.00,0.00,12.50,937.50,'2023-02-17 15:56:07','',''),(6711,'1','302','1',1,'Retail Sale Id 6486',9200.00,0.00,0.00,12.50,937.50,'2023-02-17 16:01:18','',''),(6712,'1','302','1',1,'Retail Sale Id 6487',1000.96,0.00,0.00,1.36,102.00,'2023-02-17 16:06:21','',''),(6713,'1','302','1',1,'Retail Sale Id 6488',2001.92,0.00,0.00,2.72,204.00,'2023-02-17 16:13:22','',''),(6714,'1','302','1',1,'Retail Sale Id 6489',736.00,0.00,0.00,1.00,75.00,'2023-02-17 16:24:01','',''),(6715,'1','302','1',1,'Retail Sale Id 6490',1000.96,0.00,0.00,1.36,102.00,'2023-02-17 16:31:08','',''),(6716,'1','302','1',1,'Retail Sale Id 6491',4416.00,0.00,0.00,6.00,450.00,'2023-02-17 16:33:50','',''),(6717,'1','302','1',1,'Retail Sale Id 6492',7100.00,0.00,0.00,10.00,490.00,'2023-02-17 16:39:30','',''),(6718,'1','302','1',1,'Retail Sale Id 6493',2944.00,0.00,0.00,4.00,300.00,'2023-02-17 16:43:17','',''),(6719,'1','302','1',1,'Retail Sale Id 6494',9200.00,0.00,0.00,12.50,937.50,'2023-02-17 16:50:50','',''),(6720,'1','302','1',1,'Retail Sale Id 6495',2001.92,0.00,0.00,2.72,204.00,'2023-02-17 16:54:17','',''),(6721,'1','302','1',1,'Retail Sale Id 6496',2208.00,0.00,0.00,3.00,225.00,'2023-02-17 17:00:26','',''),(6722,'1','302','1',1,'Retail Sale Id 6497',7360.00,0.00,0.00,10.00,750.00,'2023-02-17 17:02:24','',''),(6723,'1','302','1',1,'Retail Sale Id 6498',3550.00,0.00,0.00,5.00,245.00,'2023-02-17 17:04:22','',''),(6724,'1','302','1',1,'Retail Sale Id 6499',2208.00,0.00,0.00,3.00,225.00,'2023-02-17 17:10:17','',''),(6725,'1','302','1',1,'Retail Sale Id 6500',3996.48,0.00,0.00,5.43,407.25,'2023-02-17 17:11:46','',''),(6726,'1','302','1',1,'Retail Sale Id 6501',4997.44,0.00,0.00,6.79,509.25,'2023-02-17 17:23:45','',''),(6727,'1','302','1',1,'Retail Sale Id 6502',500.48,0.00,0.00,0.68,51.00,'2023-02-17 17:24:25','',''),(6728,'1','302','1',1,'Retail Sale Id 6503',1501.44,0.00,0.00,2.04,153.00,'2023-02-17 17:27:51','',''),(6729,'1','302','1',1,'Retail Sale Id 6505',1501.44,0.00,0.00,2.04,153.00,'2023-02-17 17:54:10','',''),(6730,'1','302','1',1,'Retail Sale Id 6506',1000.96,0.00,0.00,1.36,102.00,'2023-02-17 17:54:57','',''),(6731,'1','302','1',1,'Retail Sale Id 6507',12144.00,0.00,0.00,16.50,1237.50,'2023-02-17 17:57:41','',''),(6732,'1','302','1',1,'Retail Sale Id 6508',4496.96,0.00,0.00,6.11,458.25,'2023-02-17 18:00:01','',''),(6733,'1','302','1',1,'Retail Sale Id 6509',3996.48,0.00,0.00,5.43,407.25,'2023-02-17 18:02:03','',''),(6734,'1','302','1',1,'Retail Sale Id 6510',8096.00,0.00,0.00,11.00,825.00,'2023-02-17 18:28:10','',''),(6735,'1','302','1',1,'Retail Sale Id 6511',9722.56,0.00,0.00,13.21,990.75,'2023-02-17 18:32:32','',''),(6736,'1','302','1',1,'Retail Sale Id 6512',29.44,0.00,0.00,0.04,3.00,'2023-02-17 19:08:11','',''),(6737,'1','302','1',1,'Retail Sale Id 6514',1000.96,0.00,0.00,1.36,102.00,'2023-02-18 08:18:00','',''),(6738,'1','302','1',1,'Retail Sale Id 6515',2208.00,0.00,0.00,3.00,225.00,'2023-02-18 09:17:35','',''),(6739,'1','302','1',1,'Retail Sale Id 6516',12997.76,0.00,0.00,17.66,1324.50,'2023-02-18 09:33:00','',''),(6740,'1','302','1',1,'Retail Sale Id 6517',3996.48,0.00,0.00,5.43,407.25,'2023-02-18 09:44:25','',''),(6741,'1','302','1',1,'Retail Sale Id 6518',2208.00,0.00,0.00,3.00,225.00,'2023-02-18 09:55:30','',''),(6742,'1','302','1',1,'Retail Sale Id 6519',4997.44,0.00,0.00,6.79,509.25,'2023-02-18 09:56:37','',''),(6743,'1','302','1',1,'Retail Sale Id 6520',4496.96,0.00,0.00,6.11,458.25,'2023-02-18 09:57:19','',''),(6744,'1','302','1',1,'Retail Sale Id 6521',3702.08,0.00,0.00,5.03,377.25,'2023-02-18 09:58:24','',''),(6745,'1','302','1',1,'Retail Sale Id 6522',3002.88,0.00,0.00,4.08,306.00,'2023-02-18 09:59:20','',''),(6746,'1','302','1',1,'Retail Sale Id 6523',2208.00,0.00,0.00,3.00,225.00,'2023-02-18 10:02:53','',''),(6747,'1','302','1',1,'Retail Sale Id 6524',2208.00,0.00,0.00,3.00,225.00,'2023-02-18 10:07:24','',''),(6748,'1','302','1',1,'Retail Sale Id 6525',500.48,0.00,0.00,0.68,51.00,'2023-02-18 10:10:53','',''),(6749,'1','302','1',1,'Retail Sale Id 6526',9200.00,0.00,0.00,12.50,937.50,'2023-02-18 10:12:06','',''),(6750,'1','302','1',1,'Retail Sale Id 6527',4416.00,0.00,0.00,6.00,450.00,'2023-02-18 10:13:13','',''),(6751,'1','302','1',1,'Retail Sale Id 6528',2208.00,0.00,0.00,3.00,225.00,'2023-02-18 10:14:08','',''),(6752,'1','302','1',1,'Retail Sale Id 6529',1000.96,0.00,0.00,1.36,102.00,'2023-02-18 10:18:18','',''),(6753,'1','302','1',1,'Retail Sale Id 6530',3002.88,0.00,0.00,4.08,306.00,'2023-02-18 10:22:28','',''),(6754,'1','302','1',1,'Retail Sale Id 6531',9200.00,0.00,0.00,12.50,937.50,'2023-02-18 10:24:35','',''),(6755,'1','302','1',1,'Retail Sale Id 6532',2988.16,0.00,0.00,4.06,304.50,'2023-02-18 10:25:29','',''),(6756,'1','302','1',1,'Retail Sale Id 6533',500.48,0.00,0.00,0.68,51.00,'2023-02-18 10:32:54','',''),(6757,'1','302','1',1,'Retail Sale Id 6534',2200.64,0.00,0.00,2.99,224.25,'2023-02-18 10:49:55','',''),(6758,'1','302','1',1,'Retail Sale Id 6535',35500.00,0.00,0.00,50.00,2450.00,'2023-02-18 10:51:23','',''),(6759,'1','302','1',1,'Retail Sale Id 6536',2200.64,0.00,0.00,2.99,224.25,'2023-02-18 10:56:28','',''),(6760,'1','302','1',1,'Retail Sale Id 6537',1472.00,0.00,0.00,2.00,150.00,'2023-02-18 10:57:55','',''),(6761,'1','302','1',1,'Retail Sale Id 6538',9200.00,0.00,0.00,12.50,937.50,'2023-02-18 11:02:51','',''),(6762,'1','302','1',1,'Retail Sale Id 6539',802.24,0.00,0.00,1.09,81.75,'2023-02-18 11:14:10','',''),(6763,'1','302','1',1,'Retail Sale Id 6540',2208.00,0.00,0.00,3.00,225.00,'2023-02-18 11:15:20','',''),(6764,'1','302','1',1,'Retail Sale Id 6541',4416.00,0.00,0.00,6.00,450.00,'2023-02-18 11:16:05','',''),(6765,'1','302','1',1,'Retail Sale Id 6542',4416.00,0.00,0.00,6.00,450.00,'2023-02-18 11:35:17','',''),(6766,'1','302','1',1,'Retail Sale Id 6543',3680.00,0.00,0.00,5.00,375.00,'2023-02-18 11:38:24','',''),(6767,'1','302','1',1,'Retail Sale Id 6544',5998.40,0.00,0.00,8.15,611.25,'2023-02-18 11:39:27','',''),(6768,'1','302','1',1,'Retail Sale Id 6546',1597.12,0.00,0.00,2.17,162.75,'2023-02-18 11:42:15','',''),(6769,'1','302','1',1,'Retail Sale Id 6547',6999.36,0.00,0.00,9.51,713.25,'2023-02-18 11:43:17','',''),(6770,'1','302','1',1,'Retail Sale Id 6548',1000.96,0.00,0.00,1.36,102.00,'2023-02-18 11:45:59','',''),(6771,'1','302','1',1,'Retail Sale Id 6549',2200.64,0.00,0.00,2.99,224.25,'2023-02-18 11:47:07','',''),(6772,'1','302','1',1,'Retail Sale Id 6550',2001.92,0.00,0.00,2.72,204.00,'2023-02-18 12:07:23','',''),(6773,'1','302','1',1,'Retail Sale Id 6551',4496.96,0.00,0.00,6.11,458.25,'2023-02-18 12:16:02','',''),(6774,'1','302','1',1,'Retail Sale Id 6552',34080.00,0.00,0.00,48.00,2352.00,'2023-02-18 12:25:24','',''),(6775,'1','302','1',1,'Retail Sale Id 6553',1000.96,0.00,0.00,1.36,102.00,'2023-02-18 12:35:05','',''),(6776,'1','302','1',1,'Retail Sale Id 6554',2208.00,0.00,0.00,3.00,225.00,'2023-02-18 12:36:08','',''),(6777,'1','302','1',1,'Retail Sale Id 6555',3002.88,0.00,0.00,4.08,306.00,'2023-02-18 12:52:10','',''),(6778,'1','302','1',1,'Retail Sale Id 6556',9200.00,0.00,0.00,12.50,937.50,'2023-02-18 12:57:37','',''),(6779,'1','302','1',1,'Retail Sale Id 6557',4496.96,0.00,0.00,6.11,458.25,'2023-02-18 13:04:04','',''),(6780,'1','302','1',1,'Retail Sale Id 6559',3680.00,0.00,0.00,5.00,375.00,'2023-02-18 13:13:14','',''),(6781,'1','302','1',1,'Retail Sale Id 6559',4416.00,0.00,0.00,6.00,450.00,'2023-02-18 13:13:14','',''),(6782,'1','302','1',1,'Retail Sale Id 6560',2001.92,0.00,0.00,2.72,204.00,'2023-02-18 13:14:05','',''),(6783,'1','302','1',1,'Retail Sale Id 6561',2944.00,0.00,0.00,4.00,300.00,'2023-02-18 13:23:06','',''),(6784,'1','302','1',1,'Retail Sale Id 6562',3996.48,0.00,0.00,5.43,407.25,'2023-02-18 13:38:08','',''),(6785,'1','302','1',1,'Retail Sale Id 6563',2001.92,0.00,0.00,2.72,204.00,'2023-02-18 13:39:09','',''),(6786,'1','302','1',1,'Retail Sale Id 6564',4997.44,0.00,0.00,6.79,509.25,'2023-02-18 14:02:57','',''),(6787,'1','302','1',1,'Retail Sale Id 6565',4997.44,0.00,0.00,6.79,509.25,'2023-02-18 14:03:42','',''),(6788,'1','302','1',1,'Retail Sale Id 6567',3503.36,0.00,0.00,4.76,357.00,'2023-02-18 14:16:54','',''),(6789,'1','302','1',1,'Retail Sale Id 6568',2001.92,0.00,0.00,2.72,204.00,'2023-02-18 14:36:06','',''),(6790,'1','302','1',1,'Retail Sale Id 6569',1501.44,0.00,0.00,2.04,153.00,'2023-02-18 14:37:22','',''),(6791,'1','302','1',1,'Retail Sale Id 6570',8832.00,0.00,0.00,12.00,900.00,'2023-02-18 14:40:54','',''),(6792,'1','302','1',1,'Retail Sale Id 6571',27600.00,0.00,0.00,37.50,2812.50,'2023-02-18 14:49:46','',''),(6793,'1','302','1',1,'Retail Sale Id 6572',3503.36,0.00,0.00,4.76,357.00,'2023-02-18 15:04:01','',''),(6794,'1','302','1',1,'Retail Sale Id 6573',9200.00,0.00,0.00,12.50,937.50,'2023-02-18 15:09:19','',''),(6795,'1','302','1',1,'Retail Sale Id 6574',9200.00,0.00,0.00,12.50,937.50,'2023-02-18 15:12:45','',''),(6796,'1','302','1',1,'Retail Sale Id 6575',9200.00,0.00,0.00,12.50,937.50,'2023-02-18 15:24:15','',''),(6797,'1','302','1',1,'Retail Sale Id 6576',9200.00,0.00,0.00,12.50,937.50,'2023-02-18 15:25:49','',''),(6798,'1','302','1',1,'Retail Sale Id 6577',7360.00,0.00,0.00,10.00,750.00,'2023-02-18 15:36:46','',''),(6799,'1','302','1',1,'Retail Sale Id 6578',18400.00,0.00,0.00,25.00,1875.00,'2023-02-18 15:38:19','',''),(6800,'1','302','1',1,'Retail Sale Id 6579',1000.96,0.00,0.00,1.36,102.00,'2023-02-18 15:47:53','',''),(6801,'1','302','1',1,'Retail Sale Id 6580',1000.96,0.00,0.00,1.36,102.00,'2023-02-18 15:49:22','',''),(6802,'1','302','1',1,'Retail Sale Id 6581',2001.92,0.00,0.00,2.72,204.00,'2023-02-18 15:53:37','',''),(6803,'1','302','1',1,'Retail Sale Id 6582',2208.00,0.00,0.00,3.00,225.00,'2023-02-18 15:54:22','',''),(6804,'1','302','1',1,'Retail Sale Id 6583',4202.56,0.00,0.00,5.71,428.25,'2023-02-18 15:55:29','',''),(6805,'1','302','1',1,'Retail Sale Id 6584',4496.96,0.00,0.00,6.11,458.25,'2023-02-18 16:00:49','',''),(6806,'1','302','1',1,'Retail Sale Id 6585',1501.44,0.00,0.00,2.04,153.00,'2023-02-18 16:02:06','',''),(6807,'1','302','1',1,'Retail Sale Id 6586',4260.00,0.00,0.00,6.00,294.00,'2023-02-18 16:11:07','',''),(6808,'1','302','1',1,'Retail Sale Id 6587',2208.00,0.00,0.00,3.00,225.00,'2023-02-18 16:12:40','',''),(6809,'1','302','1',1,'Retail Sale Id 6588',397.44,0.00,0.00,0.54,40.50,'2023-02-18 16:27:55','',''),(6810,'1','302','1',1,'Retail Sale Id 6589',9200.00,0.00,0.00,12.50,937.50,'2023-02-18 16:28:58','',''),(6811,'1','302','1',1,'Retail Sale Id 6590',2001.92,0.00,0.00,2.72,204.00,'2023-02-18 16:34:50','',''),(6812,'1','302','1',1,'Retail Sale Id 6591',1000.96,0.00,0.00,1.36,102.00,'2023-02-18 16:35:46','',''),(6813,'1','302','1',1,'Retail Sale Id 6592',20608.00,0.00,0.00,28.00,2100.00,'2023-02-18 16:47:11','',''),(6814,'1','302','1',1,'Retail Sale Id 6593',1000.96,0.00,0.00,1.36,102.00,'2023-02-18 16:48:24','',''),(6815,'1','302','1',1,'Retail Sale Id 6594',1501.44,0.00,0.00,2.04,153.00,'2023-02-18 16:53:48','',''),(6816,'1','302','1',1,'Retail Sale Id 6595',2701.12,0.00,0.00,3.67,275.25,'2023-02-18 17:10:11','',''),(6817,'1','302','1',1,'Retail Sale Id 6596',4416.00,0.00,0.00,6.00,450.00,'2023-02-18 17:10:55','',''),(6818,'1','302','1',1,'Retail Sale Id 6597',4997.44,0.00,0.00,6.79,509.25,'2023-02-18 17:17:34','',''),(6819,'1','302','1',1,'Retail Sale Id 6598',14720.00,0.00,0.00,20.00,1500.00,'2023-02-18 17:18:24','',''),(6820,'1','302','1',1,'Retail Sale Id 6599',8832.00,0.00,0.00,12.00,900.00,'2023-02-18 17:19:10','',''),(6821,'1','302','1',1,'Retail Sale Id 6600',1000.96,0.00,0.00,1.36,102.00,'2023-02-18 17:25:41','',''),(6822,'1','302','1',1,'Retail Sale Id 6601',7810.00,0.00,0.00,11.00,539.00,'2023-02-18 17:27:37','',''),(6823,'1','302','1',1,'Retail Sale Id 6602',2208.00,0.00,0.00,3.00,225.00,'2023-02-18 17:35:59','',''),(6824,'1','302','1',1,'Retail Sale Id 6603',9200.00,0.00,0.00,12.50,937.50,'2023-02-18 17:50:43','',''),(6825,'1','302','1',1,'Retail Sale Id 6604',500.48,0.00,0.00,0.68,51.00,'2023-02-18 17:51:32','',''),(6826,'1','302','1',1,'Retail Sale Id 6605',1803.20,0.00,0.00,2.45,183.75,'2023-02-18 17:58:01','',''),(6827,'1','302','1',1,'Retail Sale Id 6606',1000.96,0.00,0.00,1.36,102.00,'2023-02-18 18:05:26','',''),(6828,'1','302','1',1,'Retail Sale Id 6607',3680.00,0.00,0.00,5.00,375.00,'2023-02-18 18:10:48','',''),(6829,'1','302','1',1,'Retail Sale Id 6608',9200.00,0.00,0.00,12.50,937.50,'2023-02-18 18:11:46','',''),(6830,'1','302','1',1,'Retail Sale Id 6609',2208.00,0.00,0.00,3.00,225.00,'2023-02-18 18:14:21','',''),(6831,'1','302','1',1,'Retail Sale Id 6610',3680.00,0.00,0.00,5.00,375.00,'2023-02-18 18:18:47','',''),(6832,'1','302','1',1,'Retail Sale Id 6611',699.20,0.00,0.00,0.95,71.25,'2023-02-18 18:30:02','',''),(6833,'1','302','1',1,'Retail Sale Id 6612',18400.00,0.00,0.00,25.00,1875.00,'2023-02-18 18:31:08','',''),(6834,'1','302','1',1,'Retail Sale Id 6613',802.24,0.00,0.00,1.09,81.75,'2023-02-18 18:31:46','',''),(6835,'1','302','1',1,'Retail Sale Id 6614',1000.96,0.00,0.00,1.36,102.00,'2023-02-18 18:37:16','',''),(6836,'1','302','1',1,'Retail Sale Id 6615',1501.44,0.00,0.00,2.04,153.00,'2023-02-18 18:40:53','',''),(6837,'1','302','1',1,'Retail Sale Id 6616',1000.96,0.00,0.00,1.36,102.00,'2023-02-18 18:42:17','',''),(6838,'1','302','1',1,'Retail Sale Id 6617',12070.00,0.00,0.00,17.00,833.00,'2023-02-18 18:46:13','',''),(6839,'1','302','1',1,'Return of Retail Sale Id 6609',0.00,2208.00,3.00,0.00,-225.00,'2023-02-18 19:58:02','',''),(6840,'1','302','1',1,'Retail Sale Id 6618',51.52,0.00,0.00,0.07,5.25,'2023-02-18 20:00:52','',''),(6841,'1','302','1',1,'Retail Sale Id 6619',500.48,0.00,0.00,0.68,51.00,'2023-02-19 07:37:15','',''),(6842,'1','302','1',1,'Retail Sale Id 6620',2001.92,0.00,0.00,2.72,204.00,'2023-02-19 08:17:46','',''),(6843,'1','302','1',1,'Retail Sale Id 6621',28918.30,0.00,0.00,40.73,1995.77,'2023-02-19 09:33:20','',''),(6844,'1','302','1',1,'Retail Sale Id 6622',3002.88,0.00,0.00,4.08,306.00,'2023-02-19 09:38:02','',''),(6845,'1','302','1',1,'Retail Sale Id 6623',9200.00,0.00,0.00,12.50,937.50,'2023-02-19 09:38:48','',''),(6846,'1','302','1',1,'Retail Sale Id 6624',2001.92,0.00,0.00,2.72,204.00,'2023-02-19 09:39:31','',''),(6847,'1','302','1',1,'Retail Sale Id 6625',4416.00,0.00,0.00,6.00,450.00,'2023-02-19 09:54:15','',''),(6848,'1','302','1',1,'Retail Sale Id 6626',3680.00,0.00,0.00,5.00,375.00,'2023-02-19 09:58:54','',''),(6849,'1','302','1',1,'Retail Sale Id 6627',3002.88,0.00,0.00,4.08,306.00,'2023-02-19 10:01:22','',''),(6850,'1','302','1',1,'Retail Sale Id 6628',4416.00,0.00,0.00,6.00,450.00,'2023-02-19 10:05:35','',''),(6851,'1','302','1',1,'Retail Sale Id 6628',9200.00,0.00,0.00,12.50,937.50,'2023-02-19 10:05:35','',''),(6852,'1','302','1',1,'Retail Sale Id 6629',4496.96,0.00,0.00,6.11,458.25,'2023-02-19 10:10:38','',''),(6853,'1','302','1',1,'Retail Sale Id 6630',3002.88,0.00,0.00,4.08,306.00,'2023-02-19 10:12:27','',''),(6854,'1','302','1',1,'Retail Sale Id 6631',2208.00,0.00,0.00,3.00,225.00,'2023-02-19 10:13:51','',''),(6855,'1','302','1',1,'Retail Sale Id 6632',4997.44,0.00,0.00,6.79,509.25,'2023-02-19 10:21:20','',''),(6856,'1','302','1',1,'Retail Sale Id 6633',9200.00,0.00,0.00,12.50,937.50,'2023-02-19 10:27:48','',''),(6857,'1','302','1',1,'Retail Sale Id 6634',1472.00,0.00,0.00,2.00,150.00,'2023-02-19 10:29:59','',''),(6858,'1','302','1',1,'Retail Sale Id 6634',9200.00,0.00,0.00,12.50,937.50,'2023-02-19 10:29:59','',''),(6859,'1','302','1',1,'Retail Sale Id 6635',1501.44,0.00,0.00,2.04,153.00,'2023-02-19 10:30:54','',''),(6860,'1','302','1',1,'Retail Sale Id 6636',2303.68,0.00,0.00,3.13,234.75,'2023-02-19 10:37:20','',''),(6861,'1','302','1',1,'Retail Sale Id 6637',9200.00,0.00,0.00,12.50,937.50,'2023-02-19 10:40:41','',''),(6862,'1','302','1',1,'Retail Sale Id 6638',16192.00,0.00,0.00,22.00,1650.00,'2023-02-19 10:45:54','',''),(6863,'1','302','1',1,'Retail Sale Id 6639',4997.44,0.00,0.00,6.79,509.25,'2023-02-19 10:47:32','',''),(6864,'1','302','1',1,'Retail Sale Id 6640',1000.96,0.00,0.00,1.36,102.00,'2023-02-19 10:54:17','',''),(6865,'1','302','1',1,'Retail Sale Id 6640',1501.44,0.00,0.00,2.04,153.00,'2023-02-19 10:54:17','',''),(6866,'1','302','1',1,'Retail Sale Id 6641',2001.92,0.00,0.00,2.72,204.00,'2023-02-19 10:55:11','',''),(6867,'1','302','1',1,'Retail Sale Id 6642',1501.44,0.00,0.00,2.04,153.00,'2023-02-19 11:06:44','',''),(6868,'1','302','1',1,'Retail Sale Id 6643',9200.00,0.00,0.00,12.50,937.50,'2023-02-19 11:07:35','',''),(6869,'1','302','1',1,'Retail Sale Id 6644',2208.00,0.00,0.00,3.00,225.00,'2023-02-19 11:19:45','',''),(6870,'1','302','1',1,'Retail Sale Id 6645',736.00,0.00,0.00,1.00,75.00,'2023-02-19 11:24:08','',''),(6871,'1','302','1',1,'Retail Sale Id 6646',3002.88,0.00,0.00,4.08,306.00,'2023-02-19 11:26:21','',''),(6872,'1','302','1',1,'Retail Sale Id 6647',3680.00,0.00,0.00,5.00,375.00,'2023-02-19 11:27:41','',''),(6873,'1','302','1',1,'Retail Sale Id 6648',3002.88,0.00,0.00,4.08,306.00,'2023-02-19 11:30:16','',''),(6874,'1','302','1',1,'Retail Sale Id 6649',1501.44,0.00,0.00,2.04,153.00,'2023-02-19 11:31:07','',''),(6875,'1','302','1',1,'Retail Sale Id 6650',4416.00,0.00,0.00,6.00,450.00,'2023-02-19 11:33:36','',''),(6876,'1','302','1',1,'Retail Sale Id 6651',42600.00,0.00,0.00,60.00,2940.00,'2023-02-19 11:52:28','',''),(6877,'1','302','1',1,'Retail Sale Id 6652',4416.00,0.00,0.00,6.00,450.00,'2023-02-19 11:53:32','',''),(6878,'1','302','1',1,'Retail Sale Id 6653',8520.00,0.00,0.00,12.00,588.00,'2023-02-19 11:57:22','',''),(6879,'1','302','1',1,'Retail Sale Id 6654',9200.00,0.00,0.00,12.50,937.50,'2023-02-19 11:58:18','',''),(6880,'1','302','1',1,'Retail Sale Id 6655',5152.00,0.00,0.00,7.00,525.00,'2023-02-19 11:59:53','',''),(6881,'1','302','1',1,'Retail Sale Id 6656',1000.96,0.00,0.00,1.36,102.00,'2023-02-19 12:07:12','',''),(6882,'1','302','1',1,'Retail Sale Id 6657',3680.00,0.00,0.00,5.00,375.00,'2023-02-19 12:12:37','',''),(6883,'1','302','1',1,'Retail Sale Id 6658',4416.00,0.00,0.00,6.00,450.00,'2023-02-19 12:17:02','',''),(6884,'1','302','1',1,'Retail Sale Id 6659',132060.00,0.00,0.00,186.00,9114.00,'2023-02-19 12:30:54','',''),(6885,'1','302','1',1,'Retail Sale Id 6660',1501.44,0.00,0.00,2.04,153.00,'2023-02-19 12:39:06','',''),(6886,'1','302','1',1,'Retail Sale Id 6661',736.00,0.00,0.00,1.00,75.00,'2023-02-19 12:40:36','',''),(6887,'1','302','1',1,'Retail Sale Id 6662',3680.00,0.00,0.00,5.00,375.00,'2023-02-19 12:44:14','',''),(6888,'1','302','1',1,'Retail Sale Id 6663',9200.00,0.00,0.00,12.50,937.50,'2023-02-19 12:50:35','',''),(6889,'1','302','1',1,'Retail Sale Id 6664',9200.00,0.00,0.00,12.50,937.50,'2023-02-19 12:51:45','',''),(6890,'1','302','1',1,'Retail Sale Id 6665',3002.88,0.00,0.00,4.08,306.00,'2023-02-19 12:52:48','',''),(6891,'1','302','1',1,'Retail Sale Id 6666',9200.00,0.00,0.00,12.50,937.50,'2023-02-19 12:53:40','',''),(6892,'1','302','1',1,'Retail Sale Id 6667',27600.00,0.00,0.00,37.50,2812.50,'2023-02-19 12:55:19','',''),(6893,'1','302','1',1,'Retail Sale Id 6668',3503.36,0.00,0.00,4.76,357.00,'2023-02-19 12:56:38','',''),(6894,'1','302','1',1,'Retail Sale Id 6668',4401.28,0.00,0.00,5.98,448.50,'2023-02-19 12:56:38','',''),(6895,'1','302','1',1,'Retail Sale Id 6669',2208.00,0.00,0.00,3.00,225.00,'2023-02-19 12:58:17','',''),(6896,'1','302','1',1,'Retail Sale Id 6669',9200.00,0.00,0.00,12.50,937.50,'2023-02-19 12:58:17','',''),(6897,'1','302','1',1,'Retail Sale Id 6670',1000.96,0.00,0.00,1.36,102.00,'2023-02-19 13:03:33','',''),(6898,'1','302','1',1,'Retail Sale Id 6671',4416.00,0.00,0.00,6.00,450.00,'2023-02-19 13:15:00','',''),(6899,'1','302','1',1,'Retail Sale Id 6671',8096.00,0.00,0.00,11.00,825.00,'2023-02-19 13:15:00','',''),(6900,'1','302','1',1,'Retail Sale Id 6672',9200.00,0.00,0.00,12.50,937.50,'2023-02-19 13:16:21','',''),(6901,'1','302','1',1,'Retail Sale Id 6673',9200.00,0.00,0.00,12.50,937.50,'2023-02-19 13:19:04','',''),(6902,'1','302','1',1,'Retail Sale Id 6674',1000.96,0.00,0.00,1.36,102.00,'2023-02-19 13:21:46','',''),(6903,'1','302','1',1,'Retail Sale Id 6675',3550.00,0.00,0.00,5.00,245.00,'2023-02-19 13:23:06','',''),(6904,'1','302','1',1,'Retail Sale Id 6676',2001.92,0.00,0.00,2.72,204.00,'2023-02-19 13:25:16','',''),(6905,'1','302','1',1,'Retail Sale Id 6677',6498.88,0.00,0.00,8.83,662.25,'2023-02-19 13:38:31','',''),(6906,'1','302','1',1,'Retail Sale Id 6678',17040.00,0.00,0.00,24.00,1176.00,'2023-02-19 13:44:38','',''),(6907,'1','302','1',1,'Retail Sale Id 6679',1700.16,0.00,0.00,2.31,173.25,'2023-02-19 13:46:13','',''),(6908,'1','302','1',1,'Retail Sale Id 6680',1000.96,0.00,0.00,1.36,102.00,'2023-02-19 13:48:20','',''),(6909,'1','302','1',1,'Retail Sale Id 6681',9200.00,0.00,0.00,12.50,937.50,'2023-02-19 13:59:12','',''),(6910,'1','302','1',1,'Retail Sale Id 6682',9200.00,0.00,0.00,12.50,937.50,'2023-02-19 14:17:18','',''),(6911,'1','302','1',1,'Retail Sale Id 6683',1501.44,0.00,0.00,2.04,153.00,'2023-02-19 14:23:52','',''),(6912,'1','302','1',1,'Retail Sale Id 6684',3680.00,0.00,0.00,5.00,375.00,'2023-02-19 14:25:28','',''),(6913,'1','302','1',1,'Retail Sale Id 6685',4452.80,0.00,0.00,6.05,453.75,'2023-02-19 14:29:22','',''),(6914,'1','302','1',1,'Retail Sale Id 6686',4416.00,0.00,0.00,6.00,450.00,'2023-02-19 14:37:42','',''),(6915,'1','302','1',1,'Retail Sale Id 6687',8520.00,0.00,0.00,12.00,588.00,'2023-02-19 14:47:15','',''),(6916,'1','302','1',1,'Retail Sale Id 6688',2502.40,0.00,0.00,3.40,255.00,'2023-02-19 14:52:09','',''),(6917,'1','302','1',1,'Retail Sale Id 6689',8500.80,0.00,0.00,11.55,866.25,'2023-02-19 14:57:39','',''),(6918,'1','302','1',1,'Retail Sale Id 6690',2502.40,0.00,0.00,3.40,255.00,'2023-02-19 14:58:33','',''),(6919,'1','302','1',1,'Retail Sale Id 6691',4997.44,0.00,0.00,6.79,509.25,'2023-02-19 15:01:39','',''),(6920,'1','302','1',1,'Retail Sale Id 6692',9200.00,0.00,0.00,12.50,937.50,'2023-02-19 15:09:52','',''),(6921,'1','302','1',1,'Retail Sale Id 6693',5152.00,0.00,0.00,7.00,525.00,'2023-02-19 15:12:13','',''),(6922,'1','302','1',1,'Retail Sale Id 6694',1413.12,0.00,0.00,1.92,144.00,'2023-02-19 15:19:48','',''),(6923,'1','302','1',1,'Retail Sale Id 6695',4416.00,0.00,0.00,6.00,450.00,'2023-02-19 15:21:10','',''),(6924,'1','302','1',1,'Retail Sale Id 6696',802.24,0.00,0.00,1.09,81.75,'2023-02-19 15:22:24','',''),(6925,'1','302','1',1,'Retail Sale Id 6697',3996.48,0.00,0.00,5.43,407.25,'2023-02-19 15:23:25','',''),(6926,'1','302','1',1,'Retail Sale Id 6698',1000.96,0.00,0.00,1.36,102.00,'2023-02-19 15:31:11','',''),(6927,'1','302','1',1,'Retail Sale Id 6699',3996.48,0.00,0.00,5.43,407.25,'2023-02-19 15:35:07','',''),(6928,'1','302','1',1,'Retail Sale Id 6700',802.24,0.00,0.00,1.09,81.75,'2023-02-19 15:36:20','',''),(6929,'1','302','1',1,'Retail Sale Id 6703',3680.00,0.00,0.00,5.00,375.00,'2023-02-19 15:37:20','',''),(6930,'1','302','1',1,'Retail Sale Id 6704',1501.44,0.00,0.00,2.04,153.00,'2023-02-19 15:38:24','',''),(6931,'1','302','1',1,'Retail Sale Id 6705',2208.00,0.00,0.00,3.00,225.00,'2023-02-19 15:45:22','',''),(6932,'1','302','1',1,'Retail Sale Id 6706',2208.00,0.00,0.00,3.00,225.00,'2023-02-19 15:46:24','',''),(6933,'1','302','1',1,'Retail Sale Id 6707',4416.00,0.00,0.00,6.00,450.00,'2023-02-19 15:55:24','',''),(6934,'1','302','1',1,'Retail Sale Id 6708',1199.68,0.00,0.00,1.63,122.25,'2023-02-19 16:00:01','',''),(6935,'1','302','1',1,'Retail Sale Id 6709',4416.00,0.00,0.00,6.00,450.00,'2023-02-19 16:05:20','',''),(6936,'1','302','1',1,'Retail Sale Id 6710',3002.88,0.00,0.00,4.08,306.00,'2023-02-19 16:54:30','',''),(6937,'1','302','1',1,'Retail Sale Id 6711',12902.08,0.00,0.00,17.53,1314.75,'2023-02-19 16:55:41','',''),(6938,'1','302','1',1,'Retail Sale Id 6712',3002.88,0.00,0.00,4.08,306.00,'2023-02-19 16:56:33','',''),(6939,'1','302','1',1,'Retail Sale Id 6713',7411.52,0.00,0.00,10.07,755.25,'2023-02-19 16:57:58','',''),(6940,'1','302','1',1,'Retail Sale Id 6714',3002.88,0.00,0.00,4.08,306.00,'2023-02-19 17:01:30','',''),(6941,'1','302','1',1,'Retail Sale Id 6714',3002.88,0.00,0.00,4.08,306.00,'2023-02-19 17:01:30','',''),(6942,'1','302','1',1,'Retail Sale Id 6715',4496.96,0.00,0.00,6.11,458.25,'2023-02-19 17:02:48','',''),(6943,'1','302','1',1,'Retail Sale Id 6716',3680.00,0.00,0.00,5.00,375.00,'2023-02-19 17:03:38','',''),(6944,'1','302','1',1,'Retail Sale Id 6717',1000.96,0.00,0.00,1.36,102.00,'2023-02-19 17:23:06','',''),(6945,'1','302','1',1,'Retail Sale Id 6718',3996.48,0.00,0.00,5.43,407.25,'2023-02-19 17:26:02','',''),(6946,'1','302','1',1,'Retail Sale Id 6719',2502.40,0.00,0.00,3.40,255.00,'2023-02-19 17:27:15','',''),(6947,'1','302','1',1,'Retail Sale Id 6720',4416.00,0.00,0.00,6.00,450.00,'2023-02-19 17:28:26','',''),(6948,'1','302','1',1,'Retail Sale Id 6721',2208.00,0.00,0.00,3.00,225.00,'2023-02-19 17:29:48','',''),(6949,'1','302','1',1,'Retail Sale Id 6722',2208.00,0.00,0.00,3.00,225.00,'2023-02-19 17:31:47','',''),(6950,'1','302','1',1,'Retail Sale Id 6723',4416.00,0.00,0.00,6.00,450.00,'2023-02-19 17:33:01','',''),(6951,'1','302','1',1,'Retail Sale Id 6724',4416.00,0.00,0.00,6.00,450.00,'2023-02-19 17:34:27','',''),(6952,'1','302','1',1,'Retail Sale Id 6725',2208.00,0.00,0.00,3.00,225.00,'2023-02-19 17:35:42','',''),(6953,'1','302','1',1,'Retail Sale Id 6726',3680.00,0.00,0.00,5.00,375.00,'2023-02-19 17:39:03','',''),(6954,'1','302','1',1,'Retail Sale Id 6727',4416.00,0.00,0.00,6.00,450.00,'2023-02-19 17:41:02','',''),(6955,'1','302','1',1,'Retail Sale Id 6728',2001.92,0.00,0.00,2.72,204.00,'2023-02-19 17:49:32','',''),(6956,'1','302','1',1,'Retail Sale Id 6729',4416.00,0.00,0.00,6.00,450.00,'2023-02-19 17:50:29','',''),(6957,'1','302','1',1,'Retail Sale Id 6731',3002.88,0.00,0.00,4.08,306.00,'2023-02-19 17:53:02','',''),(6958,'1','302','1',1,'Retail Sale Id 6732',9001.28,0.00,0.00,12.23,917.25,'2023-02-19 17:54:21','',''),(6959,'1','302','1',1,'Retail Sale Id 6733',4416.00,0.00,0.00,6.00,450.00,'2023-02-19 17:55:34','',''),(6960,'1','302','1',1,'Retail Sale Id 6734',7360.00,0.00,0.00,10.00,750.00,'2023-02-19 17:57:17','',''),(6961,'1','302','1',1,'Retail Sale Id 6735',2208.00,0.00,0.00,3.00,225.00,'2023-02-19 17:58:55','',''),(6962,'1','302','1',1,'Retail Sale Id 6736',9200.00,0.00,0.00,12.50,937.50,'2023-02-19 18:00:23','',''),(6963,'1','302','1',1,'Retail Sale Id 6737',3002.88,0.00,0.00,4.08,306.00,'2023-02-19 18:01:46','',''),(6964,'1','302','1',1,'Retail Sale Id 6738',2001.92,0.00,0.00,2.72,204.00,'2023-02-19 18:03:16','',''),(6965,'1','302','1',1,'Retail Sale Id 6739',17750.00,0.00,0.00,25.00,1225.00,'2023-02-19 18:04:32','',''),(6966,'1','302','1',1,'Retail Sale Id 6740',9200.00,0.00,0.00,12.50,937.50,'2023-02-19 18:06:05','',''),(6967,'1','302','1',1,'Retail Sale Id 6741',1000.96,0.00,0.00,1.36,102.00,'2023-02-19 18:07:30','',''),(6968,'1','302','1',1,'Retail Sale Id 6742',301.76,0.00,0.00,0.41,30.75,'2023-02-19 18:08:25','',''),(6969,'1','302','1',1,'Retail Sale Id 6743',35500.00,0.00,0.00,50.00,2450.00,'2023-02-19 18:11:43','',''),(6970,'1','302','1',1,'Retail Sale Id 6744',2208.00,0.00,0.00,3.00,225.00,'2023-02-19 18:13:13','',''),(6971,'1','302','1',1,'Retail Sale Id 6745',4496.96,0.00,0.00,6.11,458.25,'2023-02-19 18:16:13','',''),(6972,'1','302','1',1,'Retail Sale Id 6746',9200.00,0.00,0.00,12.50,937.50,'2023-02-19 18:17:35','',''),(6973,'1','302','1',1,'Retail Sale Id 6747',7360.00,0.00,0.00,10.00,750.00,'2023-02-19 18:23:05','',''),(6974,'1','302','1',1,'Retail Sale Id 6748',368.00,0.00,0.00,0.50,37.50,'2023-02-19 19:28:27','',''),(6975,'1','302','1',1,'Retail Sale Id 6749',3002.88,0.00,0.00,4.08,306.00,'2023-02-20 08:47:08','',''),(6976,'1','302','1',1,'Retail Sale Id 6750',4997.44,0.00,0.00,6.79,509.25,'2023-02-20 09:00:29','',''),(6977,'1','302','1',1,'Retail Sale Id 6751',3996.48,0.00,0.00,5.43,407.25,'2023-02-20 09:14:54','',''),(6978,'1','302','1',1,'Retail Sale Id 6752',3002.88,0.00,0.00,4.08,306.00,'2023-02-20 09:19:16','',''),(6979,'1','302','1',1,'Retail Sale Id 6753',2208.00,0.00,0.00,3.00,225.00,'2023-02-20 09:31:19','',''),(6980,'1','302','1',1,'Retail Sale Id 6754',4416.00,0.00,0.00,6.00,450.00,'2023-02-20 09:33:23','',''),(6981,'1','302','1',1,'Retail Sale Id 6755',2208.00,0.00,0.00,3.00,225.00,'2023-02-20 09:35:50','',''),(6982,'1','302','1',1,'Retail Sale Id 6756',4416.00,0.00,0.00,6.00,450.00,'2023-02-20 09:38:03','',''),(6983,'1','302','1',1,'Retail Sale Id 6757',9200.00,0.00,0.00,12.50,937.50,'2023-02-20 09:40:32','',''),(6984,'1','302','1',1,'Retail Sale Id 6758',2944.00,0.00,0.00,4.00,300.00,'2023-02-20 09:49:39','',''),(6985,'1','302','1',1,'Retail Sale Id 6759',9200.00,0.00,0.00,12.50,937.50,'2023-02-20 09:53:38','',''),(6986,'1','302','1',1,'Retail Sale Id 6760',2001.92,0.00,0.00,2.72,204.00,'2023-02-20 10:00:43','',''),(6987,'1','302','1',1,'Retail Sale Id 6761',3680.00,0.00,0.00,5.00,375.00,'2023-02-20 10:12:12','',''),(6988,'1','302','1',1,'Retail Sale Id 6762',3996.48,0.00,0.00,5.43,407.25,'2023-02-20 10:21:11','',''),(6989,'1','302','1',1,'Retail Sale Id 6763',4997.44,0.00,0.00,6.79,509.25,'2023-02-20 10:22:00','',''),(6990,'1','302','1',1,'Retail Sale Id 6764',3680.00,0.00,0.00,5.00,375.00,'2023-02-20 10:27:12','',''),(6991,'1','302','1',1,'Retail Sale Id 6765',1501.44,0.00,0.00,2.04,153.00,'2023-02-20 10:29:24','',''),(6992,'1','302','1',1,'Retail Sale Id 6766',1177.60,0.00,0.00,1.60,120.00,'2023-02-20 10:34:46','',''),(6993,'1','302','1',1,'Retail Sale Id 6767',2001.92,0.00,0.00,2.72,204.00,'2023-02-20 10:37:37','',''),(6994,'1','302','1',1,'Retail Sale Id 6768',3238.40,0.00,0.00,4.40,330.00,'2023-02-20 10:39:05','',''),(6995,'1','302','1',1,'Retail Sale Id 6769',3002.88,0.00,0.00,4.08,306.00,'2023-02-20 10:43:56','',''),(6996,'1','302','1',1,'Retail Sale Id 6770',24850.00,0.00,0.00,35.00,1715.00,'2023-02-20 10:51:38','',''),(6997,'1','302','1',1,'Retail Sale Id 6771',4416.00,0.00,0.00,6.00,450.00,'2023-02-20 10:53:33','',''),(6998,'1','302','1',1,'Retail Sale Id 6772',2001.92,0.00,0.00,2.72,204.00,'2023-02-20 10:55:21','',''),(6999,'1','302','1',1,'Retail Sale Id 6773',4416.00,0.00,0.00,6.00,450.00,'2023-02-20 11:18:04','',''),(7000,'1','302','1',1,'Retail Sale Id 6774',3002.88,0.00,0.00,4.08,306.00,'2023-02-20 11:24:30','',''),(7001,'1','302','1',1,'Retail Sale Id 6775',4416.00,0.00,0.00,6.00,450.00,'2023-02-20 11:25:22','',''),(7002,'1','302','1',1,'Retail Sale Id 6776',5998.40,0.00,0.00,8.15,611.25,'2023-02-20 11:26:35','',''),(7003,'1','302','1',1,'Retail Sale Id 6777',2208.00,0.00,0.00,3.00,225.00,'2023-02-20 11:30:01','',''),(7004,'1','302','1',1,'Retail Sale Id 6778',1501.44,0.00,0.00,2.04,153.00,'2023-02-20 11:32:16','',''),(7005,'1','302','1',1,'Retail Sale Id 6779',9200.00,0.00,0.00,12.50,937.50,'2023-02-20 11:33:36','',''),(7006,'1','302','1',1,'Retail Sale Id 6780',35500.00,0.00,0.00,50.00,2450.00,'2023-02-20 11:35:26','',''),(7007,'1','302','1',1,'Retail Sale Id 6781',4416.00,0.00,0.00,6.00,450.00,'2023-02-20 11:36:27','',''),(7008,'1','302','1',1,'Retail Sale Id 6782',2001.92,0.00,0.00,2.72,204.00,'2023-02-20 11:47:49','',''),(7009,'1','302','1',1,'Retail Sale Id 6783',1501.44,0.00,0.00,2.04,153.00,'2023-02-20 11:49:29','',''),(7010,'1','302','1',1,'Retail Sale Id 6784',2208.00,0.00,0.00,3.00,225.00,'2023-02-20 11:50:26','',''),(7011,'1','302','1',1,'Retail Sale Id 6785',1501.44,0.00,0.00,2.04,153.00,'2023-02-20 11:59:35','',''),(7012,'1','302','1',1,'Retail Sale Id 6786',35500.00,0.00,0.00,50.00,2450.00,'2023-02-20 12:10:34','',''),(7013,'1','302','1',1,'Retail Sale Id 6787',8875.00,0.00,0.00,12.50,612.50,'2023-02-20 12:11:46','',''),(7014,'1','302','1',1,'Retail Sale Id 6789',1472.00,0.00,0.00,2.00,150.00,'2023-02-20 12:19:32','',''),(7015,'1','302','1',1,'Retail Sale Id 6790',4416.00,0.00,0.00,6.00,450.00,'2023-02-20 12:21:05','',''),(7016,'1','302','1',1,'Retail Sale Id 6791',3002.88,0.00,0.00,4.08,306.00,'2023-02-20 12:25:07','',''),(7017,'1','302','1',1,'Retail Sale Id 6792',3002.88,0.00,0.00,4.08,306.00,'2023-02-20 12:29:44','',''),(7018,'1','302','1',1,'Retail Sale Id 6793',1840.00,0.00,0.00,2.50,187.50,'2023-02-20 12:31:32','',''),(7019,'1','302','1',1,'Retail Sale Id 6795',9230.00,0.00,0.00,13.00,637.00,'2023-02-20 12:40:58','',''),(7020,'1','302','1',1,'Retail Sale Id 6796',3002.88,0.00,0.00,4.08,306.00,'2023-02-20 12:45:42','',''),(7021,'1','302','1',1,'Retail Sale Id 6797',1000.96,0.00,0.00,1.36,102.00,'2023-02-20 12:46:59','',''),(7022,'1','302','1',1,'Retail Sale Id 6799',9200.00,0.00,0.00,12.50,937.50,'2023-02-20 13:00:26','',''),(7023,'1','302','1',1,'Retail Sale Id 6800',4416.00,0.00,0.00,6.00,450.00,'2023-02-20 13:09:38','',''),(7024,'1','302','1',1,'Retail Sale Id 6801',9200.00,0.00,0.00,12.50,937.50,'2023-02-20 13:15:57','',''),(7025,'1','302','1',1,'Retail Sale Id 6802',2200.64,0.00,0.00,2.99,224.25,'2023-02-20 13:26:59','',''),(7026,'1','302','1',1,'Retail Sale Id 6803',7360.00,0.00,0.00,10.00,750.00,'2023-02-20 13:28:05','',''),(7027,'1','302','1',1,'Retail Sale Id 6804',1501.44,0.00,0.00,2.04,153.00,'2023-02-20 13:29:23','',''),(7028,'1','302','1',1,'Retail Sale Id 6805',2001.92,0.00,0.00,2.72,204.00,'2023-02-20 13:36:31','',''),(7029,'1','302','1',1,'Retail Sale Id 6806',9200.00,0.00,0.00,12.50,937.50,'2023-02-20 13:37:17','',''),(7030,'1','302','1',1,'Retail Sale Id 6807',2001.92,0.00,0.00,2.72,204.00,'2023-02-20 13:41:41','',''),(7031,'1','302','1',1,'Retail Sale Id 6808',1000.96,0.00,0.00,1.36,102.00,'2023-02-20 13:48:41','',''),(7032,'1','302','1',1,'Retail Sale Id 6809',2944.00,0.00,0.00,4.00,300.00,'2023-02-20 13:49:53','',''),(7033,'1','302','1',1,'Retail Sale Id 6810',2502.40,0.00,0.00,3.40,255.00,'2023-02-20 14:08:34','',''),(7034,'1','302','1',1,'Retail Sale Id 6811',6992.00,0.00,0.00,9.50,712.50,'2023-02-20 14:35:40','',''),(7035,'1','302','1',1,'Retail Sale Id 6812',2001.92,0.00,0.00,2.72,204.00,'2023-02-20 14:43:28','',''),(7036,'1','302','1',1,'Retail Sale Id 6813',8000.32,0.00,0.00,10.87,815.25,'2023-02-20 15:05:29','',''),(7037,'1','302','1',1,'Retail Sale Id 6814',4416.00,0.00,0.00,6.00,450.00,'2023-02-20 15:07:47','',''),(7038,'1','302','1',1,'Retail Sale Id 6815',3680.00,0.00,0.00,5.00,375.00,'2023-02-20 15:09:35','',''),(7039,'1','302','1',1,'Retail Sale Id 6816',6697.60,0.00,0.00,9.10,682.50,'2023-02-20 15:10:57','',''),(7040,'1','302','1',1,'Retail Sale Id 6818',7360.00,0.00,0.00,10.00,750.00,'2023-02-20 15:29:25','',''),(7041,'1','302','1',1,'Retail Sale Id 6819',4416.00,0.00,0.00,6.00,450.00,'2023-02-20 15:39:55','',''),(7042,'1','302','1',1,'Retail Sale Id 6820',3680.00,0.00,0.00,5.00,375.00,'2023-02-20 15:41:02','',''),(7043,'1','302','1',1,'Retail Sale Id 6821',2208.00,0.00,0.00,3.00,225.00,'2023-02-20 15:45:01','',''),(7044,'1','302','1',1,'Retail Sale Id 6821',4416.00,0.00,0.00,6.00,450.00,'2023-02-20 15:45:01','',''),(7045,'1','302','1',1,'Retail Sale Id 6823',2208.00,0.00,0.00,3.00,225.00,'2023-02-20 16:06:37','',''),(7046,'1','302','1',1,'Retail Sale Id 6823',2208.00,0.00,0.00,3.00,225.00,'2023-02-20 16:06:37','',''),(7047,'1','302','1',1,'Retail Sale Id 6823',4416.00,0.00,0.00,6.00,450.00,'2023-02-20 16:06:37','',''),(7048,'1','302','1',1,'Retail Sale Id 6823',4416.00,0.00,0.00,6.00,450.00,'2023-02-20 16:06:37','',''),(7049,'1','302','1',1,'Retail Sale Id 6824',3002.88,0.00,0.00,4.08,306.00,'2023-02-20 16:08:12','',''),(7050,'1','302','1',1,'Retail Sale Id 6825',3002.88,0.00,0.00,4.08,306.00,'2023-02-20 16:20:23','',''),(7051,'1','302','1',1,'Retail Sale Id 6826',1501.44,0.00,0.00,2.04,153.00,'2023-02-20 16:32:10','',''),(7052,'1','302','1',1,'Retail Sale Id 6828',9200.00,0.00,0.00,12.50,937.50,'2023-02-20 16:38:55','',''),(7053,'1','302','1',1,'Retail Sale Id 6829',9200.00,0.00,0.00,12.50,937.50,'2023-02-20 16:40:55','',''),(7054,'1','302','1',1,'Retail Sale Id 6830',4416.00,0.00,0.00,6.00,450.00,'2023-02-20 16:49:13','',''),(7055,'1','302','1',1,'Retail Sale Id 6831',1472.00,0.00,0.00,2.00,150.00,'2023-02-20 16:52:00','',''),(7056,'1','302','1',1,'Retail Sale Id 6832',1000.96,0.00,0.00,1.36,102.00,'2023-02-20 16:54:54','',''),(7057,'1','302','1',1,'Retail Sale Id 6833',1000.96,0.00,0.00,1.36,102.00,'2023-02-20 16:56:51','',''),(7058,'1','302','1',1,'Retail Sale Id 6834',500.48,0.00,0.00,0.68,51.00,'2023-02-20 16:58:40','',''),(7059,'1','302','1',1,'Retail Sale Id 6835',4416.00,0.00,0.00,6.00,450.00,'2023-02-20 17:00:27','',''),(7060,'1','302','1',1,'Retail Sale Id 6836',9200.00,0.00,0.00,12.50,937.50,'2023-02-20 17:01:52','',''),(7061,'1','302','1',1,'Retail Sale Id 6837',2001.92,0.00,0.00,2.72,204.00,'2023-02-20 17:03:29','',''),(7062,'1','302','1',1,'Retail Sale Id 6838',4416.00,0.00,0.00,6.00,450.00,'2023-02-20 17:05:05','',''),(7063,'1','302','1',1,'Retail Sale Id 6839',3002.88,0.00,0.00,4.08,306.00,'2023-02-20 17:07:09','',''),(7064,'1','302','1',1,'Retail Sale Id 6841',2502.40,0.00,0.00,3.40,255.00,'2023-02-20 17:11:40','',''),(7065,'1','302','1',1,'Retail Sale Id 6843',2200.64,0.00,0.00,2.99,224.25,'2023-02-20 17:28:36','',''),(7066,'1','302','1',1,'Retail Sale Id 6844',2944.00,0.00,0.00,4.00,300.00,'2023-02-20 17:34:27','',''),(7067,'1','302','1',1,'Retail Sale Id 6845',301.76,0.00,0.00,0.41,30.75,'2023-02-20 17:37:00','',''),(7068,'1','302','1',1,'Retail Sale Id 6846',2208.00,0.00,0.00,3.00,225.00,'2023-02-20 17:38:43','',''),(7069,'1','302','1',1,'Retail Sale Id 6847',2001.92,0.00,0.00,2.72,204.00,'2023-02-20 17:43:32','',''),(7070,'1','302','1',1,'Retail Sale Id 6848',1803.20,0.00,0.00,2.45,183.75,'2023-02-20 17:44:30','',''),(7071,'1','302','1',1,'Retail Sale Id 6849',9200.00,0.00,0.00,12.50,937.50,'2023-02-20 17:45:32','',''),(7072,'1','302','1',1,'Retail Sale Id 6850',9200.00,0.00,0.00,12.50,937.50,'2023-02-20 17:49:15','',''),(7073,'1','302','1',1,'Retail Sale Id 6851',4416.00,0.00,0.00,6.00,450.00,'2023-02-20 18:02:17','',''),(7074,'1','302','1',1,'Retail Sale Id 6852',2944.00,0.00,0.00,4.00,300.00,'2023-02-20 18:05:49','',''),(7075,'1','302','1',1,'Retail Sale Id 6853',2502.40,0.00,0.00,3.40,255.00,'2023-02-20 18:15:08','',''),(7076,'1','302','1',1,'Retail Sale Id 6854',1000.96,0.00,0.00,1.36,102.00,'2023-02-20 18:20:31','',''),(7077,'1','302','1',1,'Return of Retail Sale Id 6850',0.00,9200.00,12.50,0.00,-937.50,'2023-02-20 19:16:47','',''),(7078,'1','302','1',1,'Return of Retail Sale Id 6847',0.00,2001.92,2.72,0.00,-204.00,'2023-02-20 19:17:49','',''),(7079,'1','302','1',1,'Retail Sale Id 6855',147.20,0.00,0.00,0.20,15.00,'2023-02-20 19:20:31','',''),(7080,'1','302','1',1,'Retail Sale Id 6856',9200.00,0.00,0.00,12.50,937.50,'2023-02-21 09:27:51','',''),(7081,'1','302','1',1,'Retail Sale Id 6857',9200.00,0.00,0.00,12.50,937.50,'2023-02-21 09:29:23','',''),(7082,'1','302','1',1,'Retail Sale Id 6858',1000.96,0.00,0.00,1.36,102.00,'2023-02-21 09:30:37','',''),(7083,'1','302','1',1,'Retail Sale Id 6859',1000.96,0.00,0.00,1.36,102.00,'2023-02-21 09:37:50','',''),(7084,'1','302','1',1,'Retail Sale Id 6860',9200.00,0.00,0.00,12.50,937.50,'2023-02-21 09:39:37','',''),(7085,'1','302','1',1,'Retail Sale Id 6861',3680.00,0.00,0.00,5.00,375.00,'2023-02-21 09:40:39','',''),(7086,'1','302','1',1,'Retail Sale Id 6862',1472.00,0.00,0.00,2.00,150.00,'2023-02-21 09:45:32','',''),(7087,'1','302','1',1,'Retail Sale Id 6863',4416.00,0.00,0.00,6.00,450.00,'2023-02-21 09:46:38','',''),(7088,'1','302','1',1,'Retail Sale Id 6864',9200.00,0.00,0.00,12.50,937.50,'2023-02-21 09:47:46','',''),(7089,'1','302','1',1,'Retail Sale Id 6865',9200.00,0.00,0.00,12.50,937.50,'2023-02-21 09:48:27','',''),(7090,'1','302','1',1,'Retail Sale Id 6866',27600.00,0.00,0.00,37.50,2812.50,'2023-02-21 09:49:46','',''),(7091,'1','302','1',1,'Retail Sale Id 6867',4416.00,0.00,0.00,6.00,450.00,'2023-02-21 09:53:10','',''),(7092,'1','302','1',1,'Retail Sale Id 6868',9200.00,0.00,0.00,12.50,937.50,'2023-02-21 09:57:21','',''),(7093,'1','302','1',1,'Retail Sale Id 6869',42342.08,0.00,0.00,57.53,4314.75,'2023-02-21 09:59:47','',''),(7094,'1','302','1',1,'Retail Sale Id 6870',699.20,0.00,0.00,0.95,71.25,'2023-02-21 10:00:44','',''),(7095,'1','302','1',1,'Retail Sale Id 6871',9200.00,0.00,0.00,12.50,937.50,'2023-02-21 10:01:37','',''),(7096,'1','302','1',1,'Retail Sale Id 6872',8875.00,0.00,0.00,12.50,612.50,'2023-02-21 10:16:46','',''),(7097,'1','302','1',1,'Retail Sale Id 6873',2001.92,0.00,0.00,2.72,204.00,'2023-02-21 10:23:43','',''),(7098,'1','302','1',1,'Retail Sale Id 6874',3996.48,0.00,0.00,5.43,407.25,'2023-02-21 10:47:24','',''),(7099,'1','302','1',1,'Retail Sale Id 6875',3680.00,0.00,0.00,5.00,375.00,'2023-02-21 10:49:01','',''),(7100,'1','302','1',1,'Retail Sale Id 6876',2208.00,0.00,0.00,3.00,225.00,'2023-02-21 10:55:52','',''),(7101,'1','302','1',1,'Retail Sale Id 6877',4416.00,0.00,0.00,6.00,450.00,'2023-02-21 10:58:09','',''),(7102,'1','302','1',1,'Retail Sale Id 6878',3680.00,0.00,0.00,5.00,375.00,'2023-02-21 11:01:05','',''),(7103,'1','302','1',1,'Retail Sale Id 6879',9200.00,0.00,0.00,12.50,937.50,'2023-02-21 11:02:28','',''),(7104,'1','302','1',1,'Retail Sale Id 6880',4416.00,0.00,0.00,6.00,450.00,'2023-02-21 11:03:47','',''),(7105,'1','302','1',1,'Retail Sale Id 6881',1472.00,0.00,0.00,2.00,150.00,'2023-02-21 11:22:17','',''),(7106,'1','302','1',1,'Retail Sale Id 6882',2001.92,0.00,0.00,2.72,204.00,'2023-02-21 11:25:50','',''),(7107,'1','302','1',1,'Retail Sale Id 6882',2001.92,0.00,0.00,2.72,204.00,'2023-02-21 11:25:50','',''),(7108,'1','302','1',1,'Retail Sale Id 6882',4997.44,0.00,0.00,6.79,509.25,'2023-02-21 11:25:50','',''),(7109,'1','302','1',1,'Retail Sale Id 6882',9001.28,0.00,0.00,12.23,917.25,'2023-02-21 11:25:50','',''),(7110,'1','302','1',1,'Retail Sale Id 6883',3680.00,0.00,0.00,5.00,375.00,'2023-02-21 11:29:43','',''),(7111,'1','302','1',1,'Retail Sale Id 6884',2208.00,0.00,0.00,3.00,225.00,'2023-02-21 11:45:49','',''),(7112,'1','302','1',1,'Retail Sale Id 6885',3680.00,0.00,0.00,5.00,375.00,'2023-02-21 11:48:41','',''),(7113,'1','302','1',1,'Retail Sale Id 6886',2208.00,0.00,0.00,3.00,225.00,'2023-02-21 12:02:29','',''),(7114,'1','302','1',1,'Retail Sale Id 6887',9200.00,0.00,0.00,12.50,937.50,'2023-02-21 12:03:25','',''),(7115,'1','302','1',1,'Retail Sale Id 6888',3680.00,0.00,0.00,5.00,375.00,'2023-02-21 12:04:11','',''),(7116,'1','302','1',1,'Retail Sale Id 6889',1472.00,0.00,0.00,2.00,150.00,'2023-02-21 12:04:58','',''),(7117,'1','302','1',1,'Retail Sale Id 6890',2944.00,0.00,0.00,4.00,300.00,'2023-02-21 12:08:58','',''),(7118,'1','302','1',1,'Retail Sale Id 6891',4416.00,0.00,0.00,6.00,450.00,'2023-02-21 12:12:40','',''),(7119,'1','302','1',1,'Retail Sale Id 6892',17750.00,0.00,0.00,25.00,1225.00,'2023-02-21 12:14:47','',''),(7120,'1','302','1',1,'Retail Sale Id 6894',4416.00,0.00,0.00,6.00,450.00,'2023-02-21 12:18:34','',''),(7121,'1','302','1',1,'Retail Sale Id 6895',2208.00,0.00,0.00,3.00,225.00,'2023-02-21 12:19:57','',''),(7122,'1','302','1',1,'Retail Sale Id 6896',1472.00,0.00,0.00,2.00,150.00,'2023-02-21 12:25:42','',''),(7123,'1','302','1',1,'Retail Sale Id 6897',5888.00,0.00,0.00,8.00,600.00,'2023-02-21 12:32:05','',''),(7124,'1','302','1',1,'Retail Sale Id 6898',4416.00,0.00,0.00,6.00,450.00,'2023-02-21 12:37:16','',''),(7125,'1','302','1',1,'Retail Sale Id 6899',1472.00,0.00,0.00,2.00,150.00,'2023-02-21 12:43:39','',''),(7126,'1','302','1',1,'Retail Sale Id 6900',4261.44,0.00,0.00,5.79,434.25,'2023-02-21 12:47:52','',''),(7127,'1','302','1',1,'Retail Sale Id 6901',2208.00,0.00,0.00,3.00,225.00,'2023-02-21 12:50:59','',''),(7128,'1','302','1',1,'Retail Sale Id 6902',1000.96,0.00,0.00,1.36,102.00,'2023-02-21 13:06:03','',''),(7129,'1','302','1',1,'Retail Sale Id 6903',4033.28,0.00,0.00,5.48,411.00,'2023-02-21 13:07:03','',''),(7130,'1','302','1',1,'Retail Sale Id 6904',78100.00,0.00,0.00,110.00,5390.00,'2023-02-21 13:09:03','',''),(7131,'1','302','1',1,'Retail Sale Id 6905',2208.00,0.00,0.00,3.00,225.00,'2023-02-21 13:09:56','',''),(7132,'1','302','1',1,'Retail Sale Id 6906',15620.00,0.00,0.00,22.00,1078.00,'2023-02-21 13:16:28','',''),(7133,'1','302','1',1,'Retail Sale Id 6907',3680.00,0.00,0.00,5.00,375.00,'2023-02-21 13:25:45','',''),(7134,'1','302','1',1,'Retail Sale Id 6907',9200.00,0.00,0.00,12.50,937.50,'2023-02-21 13:25:45','',''),(7135,'1','302','1',1,'Retail Sale Id 6908',14910.00,0.00,0.00,21.00,1029.00,'2023-02-21 13:30:20','',''),(7136,'1','302','1',1,'Retail Sale Id 6909',2208.00,0.00,0.00,3.00,225.00,'2023-02-21 13:55:06','',''),(7137,'1','302','1',1,'Retail Sale Id 6909',6992.00,0.00,0.00,9.50,712.50,'2023-02-21 13:55:06','',''),(7138,'1','302','1',1,'Retail Sale Id 6910',1501.44,0.00,0.00,2.04,153.00,'2023-02-21 13:56:48','',''),(7139,'1','302','1',1,'Retail Sale Id 6911',9200.00,0.00,0.00,12.50,937.50,'2023-02-21 14:37:50','',''),(7140,'1','302','1',1,'Retail Sale Id 6912',2208.00,0.00,0.00,3.00,225.00,'2023-02-21 14:42:34','',''),(7141,'1','302','1',1,'Retail Sale Id 6913',1472.00,0.00,0.00,2.00,150.00,'2023-02-21 14:44:14','',''),(7142,'1','302','1',1,'Retail Sale Id 6914',581.44,0.00,0.00,0.79,59.25,'2023-02-21 14:46:51','',''),(7143,'1','302','1',1,'Retail Sale Id 6915',1472.00,0.00,0.00,2.00,150.00,'2023-02-21 14:58:25','',''),(7144,'1','302','1',1,'Retail Sale Id 6916',2252.16,0.00,0.00,3.06,229.50,'2023-02-21 14:59:02','',''),(7145,'1','302','1',1,'Retail Sale Id 6918',2200.64,0.00,0.00,2.99,224.25,'2023-02-21 15:06:07','',''),(7146,'1','302','1',1,'Return of Retail Sale Id 6906',0.00,15620.00,22.00,0.00,-1078.00,'2023-02-21 15:20:51','',''),(7147,'1','302','1',1,'Retail Sale Id 6921',13122.88,0.00,0.00,17.83,1337.25,'2023-02-21 15:24:25','',''),(7148,'1','302','1',1,'Retail Sale Id 6922',2208.00,0.00,0.00,3.00,225.00,'2023-02-21 15:35:02','',''),(7149,'1','302','1',1,'Retail Sale Id 6923',2001.92,0.00,0.00,2.72,204.00,'2023-02-21 15:46:32','',''),(7150,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,69405.00,105.00,0.00,0.00,'2023-02-21 18:11:26','',''),(7151,'1','302',NULL,1,'Reception corrector for bridging 39',0.00,0.00,0.00,105.00,0.00,'2023-02-21 18:13:43','',''),(7152,'1','302','1',1,'Received from bridging 39',0.00,0.00,105.00,0.00,0.00,'2023-02-21 18:13:43','',''),(7153,'1','302','1',1,'Retail Sale Id 6924',60050.24,0.00,0.00,81.59,6119.25,'2023-02-21 18:16:08','',''),(7154,'1','302','1',1,'Retail Sale Id 6926',8875.00,0.00,0.00,12.50,612.50,'2023-02-21 18:18:54','',''),(7155,'1','302','1',1,'Retail Sale Id 6931',8165.00,0.00,0.00,11.50,563.50,'2023-02-21 18:24:54','',''),(7156,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,661.00,1.00,0.00,0.00,'2023-02-21 19:01:54','',''),(7157,'1','302',NULL,1,'Reception corrector for bridging 40',0.00,0.00,0.00,1.00,0.00,'2023-02-21 19:03:29','',''),(7158,'1','302','1',1,'Received from bridging 40',0.00,0.00,1.00,0.00,0.00,'2023-02-21 19:03:29','',''),(7159,'1','302','1',1,'Return of Retail Sale Id 6902',0.00,1000.96,1.36,0.00,-102.00,'2023-02-21 19:06:18','',''),(7160,'1','302','1',1,'Retail Sale Id 6934',956.80,0.00,0.00,1.30,97.50,'2023-02-21 19:07:35','',''),(7161,'1','302','1',1,'Retail Sale Id 6933',710.00,0.00,0.00,1.00,49.00,'2023-02-21 19:08:15','',''),(7162,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3569400.00,5400.00,0.00,0.00,'2023-02-22 10:50:27','',''),(7163,'1','302',NULL,1,'Reception corrector for bridging 41',0.00,0.00,0.00,5400.00,0.00,'2023-02-22 10:51:49','',''),(7164,'1','302','1',1,'Received from bridging 41',0.00,0.00,5400.00,0.00,0.00,'2023-02-22 10:51:49','',''),(7165,'1','302','1',1,'Retail Sale Id 6936',2208.00,0.00,0.00,3.00,225.00,'2023-02-22 12:10:59','',''),(7166,'1','302','1',1,'Retail Sale Id 6938',9200.00,0.00,0.00,12.50,937.50,'2023-02-22 12:30:28','',''),(7167,'1','302','1',1,'Retail Sale Id 6939',2001.92,0.00,0.00,2.72,204.00,'2023-02-22 12:38:15','',''),(7168,'1','302','1',1,'Retail Sale Id 6940',3680.00,0.00,0.00,5.00,375.00,'2023-02-22 12:40:09','',''),(7169,'1','302','1',1,'Retail Sale Id 6941',3002.88,0.00,0.00,4.08,306.00,'2023-02-22 12:41:11','',''),(7170,'1','302','1',1,'Retail Sale Id 6942',7360.00,0.00,0.00,10.00,750.00,'2023-02-22 12:46:11','',''),(7171,'1','302','1',1,'Retail Sale Id 6943',4997.44,0.00,0.00,6.79,509.25,'2023-02-22 12:48:19','',''),(7172,'1','302','1',1,'Retail Sale Id 6944',3996.48,0.00,0.00,5.43,407.25,'2023-02-22 12:49:55','',''),(7173,'1','302','1',1,'Retail Sale Id 6945',9200.00,0.00,0.00,12.50,937.50,'2023-02-22 12:51:31','',''),(7174,'1','302','1',1,'Retail Sale Id 6946',81650.00,0.00,0.00,115.00,5635.00,'2023-02-22 12:57:25','',''),(7175,'1','302','1',1,'Retail Sale Id 6947',4416.00,0.00,0.00,6.00,450.00,'2023-02-22 12:58:13','',''),(7176,'1','302','1',1,'Retail Sale Id 6948',3996.48,0.00,0.00,5.43,407.25,'2023-02-22 12:59:04','',''),(7177,'1','302','1',1,'Retail Sale Id 6949',1000.96,0.00,0.00,1.36,102.00,'2023-02-22 13:08:40','',''),(7178,'1','302','1',1,'Retail Sale Id 6950',4416.00,0.00,0.00,6.00,450.00,'2023-02-22 13:09:59','',''),(7179,'1','302','1',1,'Retail Sale Id 6951',4997.44,0.00,0.00,6.79,509.25,'2023-02-22 13:11:31','',''),(7180,'1','302','1',1,'Retail Sale Id 6952',4703.04,0.00,0.00,6.39,479.25,'2023-02-22 13:30:39','',''),(7181,'1','302','1',1,'Retail Sale Id 6953',71000.00,0.00,0.00,100.00,4900.00,'2023-02-22 13:33:25','',''),(7182,'1','302','1',1,'Retail Sale Id 6954',9200.00,0.00,0.00,12.50,937.50,'2023-02-22 13:35:42','',''),(7183,'1','302','1',1,'Retail Sale Id 6955',9200.00,0.00,0.00,12.50,937.50,'2023-02-22 13:36:56','',''),(7184,'1','302','1',1,'Retail Sale Id 6956',21300.00,0.00,0.00,30.00,1470.00,'2023-02-22 13:38:20','',''),(7185,'1','302','1',1,'Retail Sale Id 6957',2200.64,0.00,0.00,2.99,224.25,'2023-02-22 13:39:22','',''),(7186,'1','302','1',1,'Retail Sale Id 6958',4416.00,0.00,0.00,6.00,450.00,'2023-02-22 13:46:50','',''),(7187,'1','302','1',1,'Retail Sale Id 6959',14200.00,0.00,0.00,20.00,980.00,'2023-02-22 13:53:08','',''),(7188,'1','302','1',1,'Retail Sale Id 6961',2001.92,0.00,0.00,2.72,204.00,'2023-02-22 13:57:48','',''),(7189,'1','302','1',1,'Retail Sale Id 6962',1000.96,0.00,0.00,1.36,102.00,'2023-02-22 13:59:04','',''),(7190,'1','302','1',1,'Retail Sale Id 6963',9200.00,0.00,0.00,12.50,937.50,'2023-02-22 14:11:07','',''),(7191,'1','302','1',1,'Retail Sale Id 6964',3503.36,0.00,0.00,4.76,357.00,'2023-02-22 14:14:34','',''),(7192,'1','302','1',1,'Retail Sale Id 6965',2840.00,0.00,0.00,4.00,196.00,'2023-02-22 14:19:54','',''),(7193,'1','302','1',1,'Retail Sale Id 6966',4416.00,0.00,0.00,6.00,450.00,'2023-02-22 14:34:34','',''),(7194,'1','302','1',1,'Retail Sale Id 6967',9200.00,0.00,0.00,12.50,937.50,'2023-02-22 14:41:43','',''),(7195,'1','302','1',1,'Retail Sale Id 6968',1472.00,0.00,0.00,2.00,150.00,'2023-02-22 14:46:04','',''),(7196,'1','302','1',1,'Retail Sale Id 6970',3680.00,0.00,0.00,5.00,375.00,'2023-02-22 14:47:52','',''),(7197,'1','302','1',1,'Retail Sale Id 6971',4401.28,0.00,0.00,5.98,448.50,'2023-02-22 14:51:12','',''),(7198,'1','302','1',1,'Retail Sale Id 6973',2208.00,0.00,0.00,3.00,225.00,'2023-02-22 14:54:27','',''),(7199,'1','302','1',1,'Retail Sale Id 6974',2200.64,0.00,0.00,2.99,224.25,'2023-02-22 14:56:20','',''),(7200,'1','302','1',1,'Retail Sale Id 6975',4416.00,0.00,0.00,6.00,450.00,'2023-02-22 14:57:34','',''),(7201,'1','302','1',1,'Retail Sale Id 6977',2399.36,0.00,0.00,3.26,244.50,'2023-02-22 15:01:42','',''),(7202,'1','302','1',1,'Retail Sale Id 6978',1597.12,0.00,0.00,2.17,162.75,'2023-02-22 15:10:04','',''),(7203,'1','302','1',1,'Retail Sale Id 6979',4496.96,0.00,0.00,6.11,458.25,'2023-02-22 15:11:36','',''),(7204,'1','302','1',1,'Retail Sale Id 6980',9200.00,0.00,0.00,12.50,937.50,'2023-02-22 15:12:47','',''),(7205,'1','302','1',1,'Retail Sale Id 6981',41952.00,0.00,0.00,57.00,4275.00,'2023-02-22 15:14:10','',''),(7206,'1','302','1',1,'Retail Sale Id 6982',3680.00,0.00,0.00,5.00,375.00,'2023-02-22 15:15:49','',''),(7207,'1','302','1',1,'Retail Sale Id 6983',201818.56,0.00,0.00,274.21,20565.75,'2023-02-22 15:39:19','',''),(7208,'1','302','1',1,'Retail Sale Id 6984',9200.00,0.00,0.00,12.50,937.50,'2023-02-22 15:40:23','',''),(7209,'1','302','1',1,'Retail Sale Id 6985',3002.88,0.00,0.00,4.08,306.00,'2023-02-22 15:41:29','',''),(7210,'1','302','1',1,'Retail Sale Id 6986',16188.00,0.00,0.00,22.80,1117.20,'2023-02-22 15:42:32','',''),(7211,'1','302','1',1,'Retail Sale Id 6987',4416.00,0.00,0.00,6.00,450.00,'2023-02-22 15:45:12','',''),(7212,'1','302','1',1,'Retail Sale Id 6988',2001.92,0.00,0.00,2.72,204.00,'2023-02-22 15:53:07','',''),(7213,'1','302','1',1,'Retail Sale Id 6989',1000.96,0.00,0.00,1.36,102.00,'2023-02-22 16:00:44','',''),(7214,'1','302','1',1,'Retail Sale Id 6990',3599.04,0.00,0.00,4.89,366.75,'2023-02-22 16:05:21','',''),(7215,'1','302','1',1,'Retail Sale Id 6991',80.96,0.00,0.00,0.11,8.25,'2023-02-22 16:07:36','',''),(7216,'1','302','1',1,'Retail Sale Id 6992',1000.96,0.00,0.00,1.36,102.00,'2023-02-22 16:12:12','',''),(7217,'1','302','1',1,'Retail Sale Id 6994',71000.00,0.00,0.00,100.00,4900.00,'2023-02-22 16:14:34','',''),(7218,'1','302','1',1,'Retail Sale Id 6995',9928.64,0.00,0.00,13.49,1011.75,'2023-02-22 16:22:41','',''),(7219,'1','302','1',1,'Retail Sale Id 6996',7360.00,0.00,0.00,10.00,750.00,'2023-02-22 16:35:31','',''),(7220,'1','302','1',1,'Retail Sale Id 6998',4416.00,0.00,0.00,6.00,450.00,'2023-02-22 16:49:49','',''),(7221,'1','302','1',1,'Retail Sale Id 6999',3002.88,0.00,0.00,4.08,306.00,'2023-02-22 16:52:38','',''),(7222,'1','302','1',1,'Retail Sale Id 7001',3002.88,0.00,0.00,4.08,306.00,'2023-02-22 17:08:26','',''),(7223,'1','302','1',1,'Retail Sale Id 7002',6624.00,0.00,0.00,9.00,675.00,'2023-02-22 17:11:22','',''),(7224,'1','302','1',1,'Retail Sale Id 7003',4416.00,0.00,0.00,6.00,450.00,'2023-02-22 17:18:41','',''),(7225,'1','302','1',1,'Retail Sale Id 7004',4416.00,0.00,0.00,6.00,450.00,'2023-02-22 17:20:19','',''),(7226,'1','302','1',1,'Retail Sale Id 7005',4416.00,0.00,0.00,6.00,450.00,'2023-02-22 17:22:45','',''),(7227,'1','302','1',1,'Retail Sale Id 7007',1501.44,0.00,0.00,2.04,153.00,'2023-02-22 17:29:58','',''),(7228,'1','302','1',1,'Retail Sale Id 7008',4416.00,0.00,0.00,6.00,450.00,'2023-02-22 17:34:24','',''),(7229,'1','302','1',1,'Retail Sale Id 7009',13616.00,0.00,0.00,18.50,1387.50,'2023-02-22 17:55:35','',''),(7230,'1','302','1',1,'Retail Sale Id 7010',9200.00,0.00,0.00,12.50,937.50,'2023-02-22 17:57:33','',''),(7231,'1','302','1',1,'Retail Sale Id 7011',8832.00,0.00,0.00,12.00,900.00,'2023-02-22 18:04:34','',''),(7232,'1','302','1',1,'Retail Sale Id 7012',3002.88,0.00,0.00,4.08,306.00,'2023-02-22 18:05:40','',''),(7233,'1','302','1',1,'Retail Sale Id 7013',3680.00,0.00,0.00,5.00,375.00,'2023-02-22 18:06:44','',''),(7234,'1','302','1',1,'Retail Sale Id 7014',1000.96,0.00,0.00,1.36,102.00,'2023-02-22 18:19:26','',''),(7235,'1','302','1',1,'Retail Sale Id 7015',2208.00,0.00,0.00,3.00,225.00,'2023-02-22 18:21:55','',''),(7236,'1','302','1',1,'Retail Sale Id 7016',2208.00,0.00,0.00,3.00,225.00,'2023-02-22 18:29:53','',''),(7237,'1','302','1',1,'Retail Sale Id 7018',36.80,0.00,0.00,0.05,3.75,'2023-02-22 18:54:51','',''),(7238,'1','302','1',1,'Retail Sale Id 7019',4496.96,0.00,0.00,6.11,458.25,'2023-02-23 07:34:17','',''),(7239,'1','302','1',1,'Retail Sale Id 7020',3002.88,0.00,0.00,4.08,306.00,'2023-02-23 07:35:56','',''),(7240,'1','302','1',1,'Retail Sale Id 7021',4997.44,0.00,0.00,6.79,509.25,'2023-02-23 07:42:35','',''),(7241,'1','302','1',1,'Retail Sale Id 7022',35500.00,0.00,0.00,50.00,2450.00,'2023-02-23 07:45:30','',''),(7242,'1','302','1',1,'Retail Sale Id 7023',500.48,0.00,0.00,0.68,51.00,'2023-02-23 07:48:43','',''),(7243,'1','302','1',1,'Retail Sale Id 7024',71000.00,0.00,0.00,100.00,4900.00,'2023-02-23 07:51:58','',''),(7244,'1','302','1',1,'Retail Sale Id 7025',2944.00,0.00,0.00,4.00,300.00,'2023-02-23 07:55:48','',''),(7245,'1','302','1',1,'Retail Sale Id 7026',4416.00,0.00,0.00,6.00,450.00,'2023-02-23 07:58:13','',''),(7246,'1','302','1',1,'Retail Sale Id 7027',3996.48,0.00,0.00,5.43,407.25,'2023-02-23 07:59:35','',''),(7247,'1','302','1',1,'Retail Sale Id 7028',5520.00,0.00,0.00,7.50,562.50,'2023-02-23 08:04:33','',''),(7248,'1','302','1',1,'Retail Sale Id 7029',2001.92,0.00,0.00,2.72,204.00,'2023-02-23 08:06:21','',''),(7249,'1','302','1',1,'Retail Sale Id 7030',9200.00,0.00,0.00,12.50,937.50,'2023-02-23 08:11:29','',''),(7250,'1','302','1',1,'Retail Sale Id 7031',2208.00,0.00,0.00,3.00,225.00,'2023-02-23 08:21:14','',''),(7251,'1','302','1',1,'Retail Sale Id 7033',3680.00,0.00,0.00,5.00,375.00,'2023-02-23 08:25:27','',''),(7252,'1','302','1',1,'Retail Sale Id 7034',9200.00,0.00,0.00,12.50,937.50,'2023-02-23 08:26:38','',''),(7253,'1','302','1',1,'Retail Sale Id 7035',4416.00,0.00,0.00,6.00,450.00,'2023-02-23 08:37:30','',''),(7254,'1','302','1',1,'Retail Sale Id 7036',3996.48,0.00,0.00,5.43,407.25,'2023-02-23 09:03:06','',''),(7255,'1','302','1',1,'Retail Sale Id 7037',3680.00,0.00,0.00,5.00,375.00,'2023-02-23 09:05:03','',''),(7256,'1','302','1',1,'Retail Sale Id 7037',3680.00,0.00,0.00,5.00,375.00,'2023-02-23 09:05:03','',''),(7257,'1','302','1',1,'Retail Sale Id 7038',1472.00,0.00,0.00,2.00,150.00,'2023-02-23 09:10:24','',''),(7258,'1','302','1',1,'Retail Sale Id 7039',2944.00,0.00,0.00,4.00,300.00,'2023-02-23 09:13:16','',''),(7259,'1','302','1',1,'Retail Sale Id 7040',4416.00,0.00,0.00,6.00,450.00,'2023-02-23 09:16:56','',''),(7260,'1','302','1',1,'Retail Sale Id 7041',35500.00,0.00,0.00,50.00,2450.00,'2023-02-23 09:21:34','',''),(7261,'1','302','1',1,'Retail Sale Id 7042',2208.00,0.00,0.00,3.00,225.00,'2023-02-23 09:22:53','',''),(7262,'1','302','1',1,'Retail Sale Id 7043',9200.00,0.00,0.00,12.50,937.50,'2023-02-23 09:24:04','',''),(7263,'1','302','1',1,'Retail Sale Id 7044',3680.00,0.00,0.00,5.00,375.00,'2023-02-23 09:26:07','',''),(7264,'1','302','1',1,'Retail Sale Id 7045',3002.88,0.00,0.00,4.08,306.00,'2023-02-23 09:35:17','',''),(7265,'1','302','1',1,'Retail Sale Id 7046',3002.88,0.00,0.00,4.08,306.00,'2023-02-23 09:36:17','',''),(7266,'1','302','1',1,'Retail Sale Id 7047',3002.88,0.00,0.00,4.08,306.00,'2023-02-23 09:38:27','',''),(7267,'1','302','1',1,'Retail Sale Id 7048',5680.00,0.00,0.00,8.00,392.00,'2023-02-23 09:42:16','',''),(7268,'1','302','1',1,'Retail Sale Id 7049',2001.92,0.00,0.00,2.72,204.00,'2023-02-23 09:42:58','',''),(7269,'1','302','1',1,'Retail Sale Id 7050',1501.44,0.00,0.00,2.04,153.00,'2023-02-23 09:47:33','',''),(7270,'1','302','1',1,'Retail Sale Id 7052',0.00,0.00,0.00,0.00,0.00,'2023-02-23 09:56:34','',''),(7271,'1','302','1',1,'Retail Sale Id 7053',3680.00,0.00,0.00,5.00,375.00,'2023-02-23 10:00:18','',''),(7272,'1','302','1',1,'Retail Sale Id 7054',1501.44,0.00,0.00,2.04,153.00,'2023-02-23 10:02:19','',''),(7273,'1','302','1',1,'Retail Sale Id 7055',736.00,0.00,0.00,1.00,75.00,'2023-02-23 10:03:49','',''),(7274,'1','302','1',1,'Retail Sale Id 7056',106500.00,0.00,0.00,150.00,7350.00,'2023-02-23 10:05:46','',''),(7275,'1','302','1',1,'Retail Sale Id 7057',1501.44,0.00,0.00,2.04,153.00,'2023-02-23 10:06:49','',''),(7276,'1','302','1',1,'Retail Sale Id 7058',1000.96,0.00,0.00,1.36,102.00,'2023-02-23 10:09:15','',''),(7277,'1','302','1',1,'Retail Sale Id 7059',3002.88,0.00,0.00,4.08,306.00,'2023-02-23 10:10:33','',''),(7278,'1','302','1',1,'Retail Sale Id 7060',4416.00,0.00,0.00,6.00,450.00,'2023-02-23 10:11:30','',''),(7279,'1','302','1',1,'Retail Sale Id 7061',2208.00,0.00,0.00,3.00,225.00,'2023-02-23 10:13:25','',''),(7280,'1','302','1',1,'Retail Sale Id 7062',2208.00,0.00,0.00,3.00,225.00,'2023-02-23 10:14:25','',''),(7281,'1','302','1',1,'Retail Sale Id 7063',2208.00,0.00,0.00,3.00,225.00,'2023-02-23 10:20:53','',''),(7282,'1','302','1',1,'Retail Sale Id 7064',2944.00,0.00,0.00,4.00,300.00,'2023-02-23 10:24:20','',''),(7283,'1','302','1',1,'Retail Sale Id 7065',3002.88,0.00,0.00,4.08,306.00,'2023-02-23 10:25:48','',''),(7284,'1','302','1',1,'Retail Sale Id 7066',1501.44,0.00,0.00,2.04,153.00,'2023-02-23 10:28:04','',''),(7285,'1','302','1',1,'Retail Sale Id 7067',390.08,0.00,0.00,0.53,39.75,'2023-02-23 10:34:48','',''),(7286,'1','302','1',1,'Retail Sale Id 7068',4260.00,0.00,0.00,6.00,294.00,'2023-02-23 10:38:50','',''),(7287,'1','302','1',1,'Retail Sale Id 7069',3680.00,0.00,0.00,5.00,375.00,'2023-02-23 10:42:36','',''),(7288,'1','302','1',1,'Retail Sale Id 7069',4416.00,0.00,0.00,6.00,450.00,'2023-02-23 10:42:36','',''),(7289,'1','302','1',1,'Retail Sale Id 7070',2208.00,0.00,0.00,3.00,225.00,'2023-02-23 10:45:08','',''),(7290,'1','302','1',1,'Retail Sale Id 7071',4416.00,0.00,0.00,6.00,450.00,'2023-02-23 10:47:48','',''),(7291,'1','302','1',1,'Retail Sale Id 7072',3680.00,0.00,0.00,5.00,375.00,'2023-02-23 10:49:23','',''),(7292,'1','302','1',1,'Retail Sale Id 7073',1000.96,0.00,0.00,1.36,102.00,'2023-02-23 10:50:28','',''),(7293,'1','302','1',1,'Retail Sale Id 7074',3680.00,0.00,0.00,5.00,375.00,'2023-02-23 10:57:16','',''),(7294,'1','302','1',1,'Retail Sale Id 7075',4416.00,0.00,0.00,6.00,450.00,'2023-02-23 10:59:27','',''),(7295,'1','302','1',1,'Retail Sale Id 7076',500.48,0.00,0.00,0.68,51.00,'2023-02-23 11:00:01','',''),(7296,'1','302','1',1,'Retail Sale Id 7077',3680.00,0.00,0.00,5.00,375.00,'2023-02-23 11:00:55','',''),(7297,'1','302','1',1,'Retail Sale Id 7078',2208.00,0.00,0.00,3.00,225.00,'2023-02-23 11:01:38','',''),(7298,'1','302','1',1,'Retail Sale Id 7079',4416.00,0.00,0.00,6.00,450.00,'2023-02-23 11:02:25','',''),(7299,'1','302','1',1,'Retail Sale Id 7080',4416.00,0.00,0.00,6.00,450.00,'2023-02-23 11:04:52','',''),(7300,'1','302','1',1,'Retail Sale Id 7081',500.48,0.00,0.00,0.68,51.00,'2023-02-23 11:15:42','',''),(7301,'1','302','1',1,'Retail Sale Id 7082',3680.00,0.00,0.00,5.00,375.00,'2023-02-23 11:26:34','',''),(7302,'1','302','1',1,'Retail Sale Id 7083',2208.00,0.00,0.00,3.00,225.00,'2023-02-23 11:31:12','',''),(7303,'1','302','1',1,'Retail Sale Id 7083',3680.00,0.00,0.00,5.00,375.00,'2023-02-23 11:31:12','',''),(7304,'1','302','1',1,'Retail Sale Id 7084',4416.00,0.00,0.00,6.00,450.00,'2023-02-23 11:33:04','',''),(7305,'1','302','1',1,'Retail Sale Id 7085',9200.00,0.00,0.00,12.50,937.50,'2023-02-23 11:34:05','',''),(7306,'1','302','1',1,'Retail Sale Id 7086',3002.88,0.00,0.00,4.08,306.00,'2023-02-23 11:36:39','',''),(7307,'1','302','1',1,'Retail Sale Id 7087',2001.92,0.00,0.00,2.72,204.00,'2023-02-23 11:38:35','',''),(7308,'1','302','1',1,'Retail Sale Id 7087',3002.88,0.00,0.00,4.08,306.00,'2023-02-23 11:38:35','',''),(7309,'1','302','1',1,'Retail Sale Id 7088',4496.96,0.00,0.00,6.11,458.25,'2023-02-23 11:40:05','',''),(7310,'1','302','1',1,'Retail Sale Id 7089',2001.92,0.00,0.00,2.72,204.00,'2023-02-23 11:42:12','',''),(7311,'1','302','1',1,'Retail Sale Id 7090',72420.00,0.00,0.00,102.00,4998.00,'2023-02-23 11:45:22','',''),(7312,'1','302','1',1,'Retail Sale Id 7091',3680.00,0.00,0.00,5.00,375.00,'2023-02-23 11:48:06','',''),(7313,'1','302','1',1,'Retail Sale Id 7092',9200.00,0.00,0.00,12.50,937.50,'2023-02-23 11:54:53','',''),(7314,'1','302','1',1,'Retail Sale Id 7093',2208.00,0.00,0.00,3.00,225.00,'2023-02-23 11:58:31','',''),(7315,'1','302','1',1,'Retail Sale Id 7093',3680.00,0.00,0.00,5.00,375.00,'2023-02-23 11:58:31','',''),(7316,'1','302','1',1,'Retail Sale Id 7094',35500.00,0.00,0.00,50.00,2450.00,'2023-02-23 12:00:16','',''),(7317,'1','302','1',1,'Retail Sale Id 7095',2208.00,0.00,0.00,3.00,225.00,'2023-02-23 12:01:22','',''),(7318,'1','302','1',1,'Retail Sale Id 7096',1501.44,0.00,0.00,2.04,153.00,'2023-02-23 12:04:25','',''),(7319,'1','302','1',1,'Retail Sale Id 7097',1501.44,0.00,0.00,2.04,153.00,'2023-02-23 12:06:46','',''),(7320,'1','302','1',1,'Retail Sale Id 7098',1501.44,0.00,0.00,2.04,153.00,'2023-02-23 12:18:04','',''),(7321,'1','302','1',1,'Retail Sale Id 7099',802.24,0.00,0.00,1.09,81.75,'2023-02-23 12:19:58','',''),(7322,'1','302','1',1,'Retail Sale Id 7100',2208.00,0.00,0.00,3.00,225.00,'2023-02-23 12:22:15','',''),(7323,'1','302','1',1,'Retail Sale Id 7101',3002.88,0.00,0.00,4.08,306.00,'2023-02-23 12:23:36','',''),(7324,'1','302','1',1,'Retail Sale Id 7102',4416.00,0.00,0.00,6.00,450.00,'2023-02-23 12:24:41','',''),(7325,'1','302','1',1,'Retail Sale Id 7103',9200.00,0.00,0.00,12.50,937.50,'2023-02-23 12:25:48','',''),(7326,'1','302','1',1,'Retail Sale Id 7104',9200.00,0.00,0.00,12.50,937.50,'2023-02-23 12:27:19','',''),(7327,'1','302','1',1,'Retail Sale Id 7105',2208.00,0.00,0.00,3.00,225.00,'2023-02-23 12:29:16','',''),(7328,'1','302','1',1,'Retail Sale Id 7106',3680.00,0.00,0.00,5.00,375.00,'2023-02-23 12:30:34','',''),(7329,'1','302','1',1,'Retail Sale Id 7107',1000.96,0.00,0.00,1.36,102.00,'2023-02-23 12:31:59','',''),(7330,'1','302','1',1,'Retail Sale Id 7108',710.00,0.00,0.00,1.00,49.00,'2023-02-23 12:37:38','',''),(7331,'1','302','1',1,'Retail Sale Id 7109',2208.00,0.00,0.00,3.00,225.00,'2023-02-23 12:39:26','',''),(7332,'1','302','1',1,'Retail Sale Id 7110',3680.00,0.00,0.00,5.00,375.00,'2023-02-23 12:40:39','',''),(7333,'1','302','1',1,'Retail Sale Id 7111',9200.00,0.00,0.00,12.50,937.50,'2023-02-23 12:46:02','',''),(7334,'1','302','1',1,'Retail Sale Id 7112',8096.00,0.00,0.00,11.00,825.00,'2023-02-23 12:48:18','',''),(7335,'1','302','1',1,'Retail Sale Id 7113',4416.00,0.00,0.00,6.00,450.00,'2023-02-23 12:49:25','',''),(7336,'1','302','1',1,'Retail Sale Id 7114',71000.00,0.00,0.00,100.00,4900.00,'2023-02-23 12:50:46','',''),(7337,'1','302','1',1,'Retail Sale Id 7115',1501.44,0.00,0.00,2.04,153.00,'2023-02-23 12:55:29','',''),(7338,'1','302','1',1,'Retail Sale Id 7116',3996.48,0.00,0.00,5.43,407.25,'2023-02-23 12:58:07','',''),(7339,'1','302','1',1,'Retail Sale Id 7117',2944.00,0.00,0.00,4.00,300.00,'2023-02-23 13:04:17','',''),(7340,'1','302','1',1,'Retail Sale Id 7118',2001.92,0.00,0.00,2.72,204.00,'2023-02-23 13:10:44','',''),(7341,'1','302','1',1,'Retail Sale Id 7119',3002.88,0.00,0.00,4.08,306.00,'2023-02-23 13:18:14','',''),(7342,'1','302','1',1,'Retail Sale Id 7120',18319.04,0.00,0.00,24.89,1866.75,'2023-02-23 13:20:52','',''),(7343,'1','302','1',1,'Retail Sale Id 7121',9568.00,0.00,0.00,13.00,975.00,'2023-02-23 13:25:57','',''),(7344,'1','302','1',1,'Retail Sale Id 7122',2208.00,0.00,0.00,3.00,225.00,'2023-02-23 13:29:04','',''),(7345,'1','302','1',1,'Retail Sale Id 7123',4416.00,0.00,0.00,6.00,450.00,'2023-02-23 13:32:14','',''),(7346,'1','302','1',1,'Retail Sale Id 7124',9200.00,0.00,0.00,12.50,937.50,'2023-02-23 13:34:32','',''),(7347,'1','302','1',1,'Retail Sale Id 7125',3002.88,0.00,0.00,4.08,306.00,'2023-02-23 13:37:30','',''),(7348,'1','302','1',1,'Retail Sale Id 7126',5998.40,0.00,0.00,8.15,611.25,'2023-02-23 13:39:05','',''),(7349,'1','302','1',1,'Retail Sale Id 7127',4416.00,0.00,0.00,6.00,450.00,'2023-02-23 13:49:43','',''),(7350,'1','302','1',1,'Retail Sale Id 7128',1501.44,0.00,0.00,2.04,153.00,'2023-02-23 13:59:22','',''),(7351,'1','302','1',1,'Retail Sale Id 7129',35500.00,0.00,0.00,50.00,2450.00,'2023-02-23 14:08:43','',''),(7352,'1','302','1',1,'Retail Sale Id 7130',9200.00,0.00,0.00,12.50,937.50,'2023-02-23 14:14:11','',''),(7353,'1','302','1',1,'Retail Sale Id 7131',4416.00,0.00,0.00,6.00,450.00,'2023-02-23 14:19:53','',''),(7354,'1','302','1',1,'Retail Sale Id 7132',5497.92,0.00,0.00,7.47,560.25,'2023-02-23 14:26:07','',''),(7355,'1','302','1',1,'Retail Sale Id 7133',1000.96,0.00,0.00,1.36,102.00,'2023-02-23 14:28:37','',''),(7356,'1','302','1',1,'Retail Sale Id 7134',4997.44,0.00,0.00,6.79,509.25,'2023-02-23 14:33:41','',''),(7357,'1','302','1',1,'Retail Sale Id 7135',9200.00,0.00,0.00,12.50,937.50,'2023-02-23 14:36:27','',''),(7358,'1','302','1',1,'Retail Sale Id 7136',2208.00,0.00,0.00,3.00,225.00,'2023-02-23 14:39:09','',''),(7359,'1','302','1',1,'Retail Sale Id 7137',2001.92,0.00,0.00,2.72,204.00,'2023-02-23 14:47:13','',''),(7360,'1','302','1',1,'Retail Sale Id 7138',4416.00,0.00,0.00,6.00,450.00,'2023-02-23 14:50:45','',''),(7361,'1','302','1',1,'Retail Sale Id 7139',9200.00,0.00,0.00,12.50,937.50,'2023-02-23 14:52:07','',''),(7362,'1','302','1',1,'Retail Sale Id 7140',4416.00,0.00,0.00,6.00,450.00,'2023-02-23 14:55:59','',''),(7363,'1','302','1',1,'Retail Sale Id 7141',9200.00,0.00,0.00,12.50,937.50,'2023-02-23 14:58:23','',''),(7364,'1','302','1',1,'Retail Sale Id 7142',4416.00,0.00,0.00,6.00,450.00,'2023-02-23 15:00:10','',''),(7365,'1','302','1',1,'Retail Sale Id 7143',2502.40,0.00,0.00,3.40,255.00,'2023-02-23 15:02:07','',''),(7366,'1','302','1',1,'Retail Sale Id 7144',17750.00,0.00,0.00,25.00,1225.00,'2023-02-23 15:06:38','',''),(7367,'1','302','1',1,'Retail Sale Id 7145',2208.00,0.00,0.00,3.00,225.00,'2023-02-23 15:13:07','',''),(7368,'1','302','1',1,'Retail Sale Id 7146',3680.00,0.00,0.00,5.00,375.00,'2023-02-23 15:15:03','',''),(7369,'1','302','1',1,'Retail Sale Id 7147',2208.00,0.00,0.00,3.00,225.00,'2023-02-23 15:16:28','',''),(7370,'1','302','1',1,'Retail Sale Id 7148',9200.00,0.00,0.00,12.50,937.50,'2023-02-23 15:19:08','',''),(7371,'1','302','1',1,'Retail Sale Id 7149',2944.00,0.00,0.00,4.00,300.00,'2023-02-23 15:28:39','',''),(7372,'1','302','1',1,'Retail Sale Id 7149',2944.00,0.00,0.00,4.00,300.00,'2023-02-23 15:28:39','',''),(7373,'1','302','1',1,'Retail Sale Id 7149',2944.00,0.00,0.00,4.00,300.00,'2023-02-23 15:28:39','',''),(7374,'1','302','1',1,'Retail Sale Id 7149',4416.00,0.00,0.00,6.00,450.00,'2023-02-23 15:28:39','',''),(7375,'1','302','1',1,'Retail Sale Id 7150',2208.00,0.00,0.00,3.00,225.00,'2023-02-23 15:31:40','',''),(7376,'1','302','1',1,'Retail Sale Id 7151',7360.00,0.00,0.00,10.00,750.00,'2023-02-23 15:32:53','',''),(7377,'1','302','1',1,'Retail Sale Id 7152',4416.00,0.00,0.00,6.00,450.00,'2023-02-23 15:36:16','',''),(7378,'1','302','1',1,'Retail Sale Id 7153',9001.28,0.00,0.00,12.23,917.25,'2023-02-23 15:45:13','',''),(7379,'1','302','1',1,'Retail Sale Id 7154',3680.00,0.00,0.00,5.00,375.00,'2023-02-23 15:47:42','',''),(7380,'1','302','1',1,'Retail Sale Id 7155',2208.00,0.00,0.00,3.00,225.00,'2023-02-23 15:49:11','',''),(7381,'1','302','1',1,'Retail Sale Id 7157',2001.92,0.00,0.00,2.72,204.00,'2023-02-23 16:15:38','',''),(7382,'1','302','1',1,'Retail Sale Id 7158',1000.96,0.00,0.00,1.36,102.00,'2023-02-23 16:19:19','',''),(7383,'1','302','1',1,'Retail Sale Id 7159',3996.48,0.00,0.00,5.43,407.25,'2023-02-23 16:20:05','',''),(7384,'1','302','1',1,'Retail Sale Id 7160',2001.92,0.00,0.00,2.72,204.00,'2023-02-23 16:21:33','',''),(7385,'1','302','1',1,'Retail Sale Id 7161',2208.00,0.00,0.00,3.00,225.00,'2023-02-23 16:24:01','',''),(7386,'1','302','1',1,'Retail Sale Id 7161',9200.00,0.00,0.00,12.50,937.50,'2023-02-23 16:24:01','',''),(7387,'1','302','1',1,'Retail Sale Id 7162',9200.00,0.00,0.00,12.50,937.50,'2023-02-23 16:31:09','',''),(7388,'1','302','1',1,'Retail Sale Id 7163',7360.00,0.00,0.00,10.00,750.00,'2023-02-23 16:43:07','',''),(7389,'1','302','1',1,'Retail Sale Id 7164',8581.76,0.00,0.00,11.66,874.50,'2023-02-23 16:46:24','',''),(7390,'1','302','1',1,'Retail Sale Id 7165',3680.00,0.00,0.00,5.00,375.00,'2023-02-23 16:49:06','',''),(7391,'1','302','1',1,'Retail Sale Id 7166',4416.00,0.00,0.00,6.00,450.00,'2023-02-23 16:51:05','',''),(7392,'1','302','1',1,'Retail Sale Id 7167',2208.00,0.00,0.00,3.00,225.00,'2023-02-23 16:55:12','',''),(7393,'1','302','1',1,'Retail Sale Id 7168',1472.00,0.00,0.00,2.00,150.00,'2023-02-23 17:04:01','',''),(7394,'1','302','1',1,'Retail Sale Id 7168',5888.00,0.00,0.00,8.00,600.00,'2023-02-23 17:04:01','',''),(7395,'1','302','1',1,'Retail Sale Id 7169',3680.00,0.00,0.00,5.00,375.00,'2023-02-23 17:11:36','',''),(7396,'1','302','1',1,'Retail Sale Id 7170',2208.00,0.00,0.00,3.00,225.00,'2023-02-23 17:13:59','',''),(7397,'1','302','1',1,'Retail Sale Id 7171',1000.96,0.00,0.00,1.36,102.00,'2023-02-23 17:19:35','',''),(7398,'1','302','1',1,'Retail Sale Id 7171',1000.96,0.00,0.00,1.36,102.00,'2023-02-23 17:19:35','',''),(7399,'1','302','1',1,'Retail Sale Id 7172',9200.00,0.00,0.00,12.50,937.50,'2023-02-23 17:20:41','',''),(7400,'1','302','1',1,'Retail Sale Id 7173',2001.92,0.00,0.00,2.72,204.00,'2023-02-23 17:22:03','',''),(7401,'1','302','1',1,'Retail Sale Id 7174',2208.00,0.00,0.00,3.00,225.00,'2023-02-23 17:25:20','',''),(7402,'1','302','1',1,'Retail Sale Id 7175',1501.44,0.00,0.00,2.04,153.00,'2023-02-23 17:26:54','',''),(7403,'1','302','1',1,'Retail Sale Id 7176',4997.44,0.00,0.00,6.79,509.25,'2023-02-23 17:28:04','',''),(7404,'1','302','1',1,'Retail Sale Id 7177',2208.00,0.00,0.00,3.00,225.00,'2023-02-23 17:29:43','',''),(7405,'1','302','1',1,'Retail Sale Id 7178',2001.92,0.00,0.00,2.72,204.00,'2023-02-23 17:33:31','',''),(7406,'1','302','1',1,'Retail Sale Id 7179',1501.44,0.00,0.00,2.04,153.00,'2023-02-23 17:34:37','',''),(7407,'1','302','1',1,'Retail Sale Id 7180',4416.00,0.00,0.00,6.00,450.00,'2023-02-23 17:36:07','',''),(7408,'1','302','1',1,'Retail Sale Id 7181',2200.64,0.00,0.00,2.99,224.25,'2023-02-23 17:38:15','',''),(7409,'1','302','1',1,'Retail Sale Id 7182',4416.00,0.00,0.00,6.00,450.00,'2023-02-23 17:40:58','',''),(7410,'1','302','1',1,'Retail Sale Id 7183',1000.96,0.00,0.00,1.36,102.00,'2023-02-23 17:47:02','',''),(7411,'1','302','1',1,'Retail Sale Id 7184',9200.00,0.00,0.00,12.50,937.50,'2023-02-23 17:55:08','',''),(7412,'1','302','1',1,'Retail Sale Id 7185',9200.00,0.00,0.00,12.50,937.50,'2023-02-23 18:00:42','',''),(7413,'1','302','1',1,'Retail Sale Id 7186',2001.92,0.00,0.00,2.72,204.00,'2023-02-23 18:03:01','',''),(7414,'1','302','1',1,'Retail Sale Id 7187',9200.00,0.00,0.00,12.50,937.50,'2023-02-23 18:07:40','',''),(7415,'1','302','1',1,'Retail Sale Id 7188',1501.44,0.00,0.00,2.04,153.00,'2023-02-23 18:14:03','',''),(7416,'1','302','1',1,'Retail Sale Id 7189',1501.44,0.00,0.00,2.04,153.00,'2023-02-23 18:16:39','',''),(7417,'1','302','1',1,'Retail Sale Id 7190',3002.88,0.00,0.00,4.08,306.00,'2023-02-23 18:18:07','',''),(7418,'1','302','1',1,'Retail Sale Id 7191',1000.96,0.00,0.00,1.36,102.00,'2023-02-23 18:20:02','',''),(7419,'1','302','1',1,'Retail Sale Id 7192',2944.00,0.00,0.00,4.00,300.00,'2023-02-23 18:20:49','',''),(7420,'1','302','1',1,'Retail Sale Id 7193',2208.00,0.00,0.00,3.00,225.00,'2023-02-23 18:22:30','',''),(7421,'1','302','1',1,'Retail Sale Id 7194',4416.00,0.00,0.00,6.00,450.00,'2023-02-23 18:23:43','',''),(7422,'1','302','1',1,'Retail Sale Id 7196',3996.48,0.00,0.00,5.43,407.25,'2023-02-23 18:25:12','',''),(7423,'1','302','1',1,'Retail Sale Id 7197',1273.28,0.00,0.00,1.73,129.75,'2023-02-23 19:06:48','',''),(7424,'1','302','1',1,'Retail Sale Id 7198',3680.00,0.00,0.00,5.00,375.00,'2023-02-24 07:55:58','',''),(7425,'1','302','1',1,'Retail Sale Id 7199',2944.00,0.00,0.00,4.00,300.00,'2023-02-24 07:59:06','',''),(7426,'1','302','1',1,'Retail Sale Id 7200',3002.88,0.00,0.00,4.08,306.00,'2023-02-24 08:00:21','',''),(7427,'1','302','1',1,'Retail Sale Id 7201',2208.00,0.00,0.00,3.00,225.00,'2023-02-24 08:04:17','',''),(7428,'1','302','1',1,'Retail Sale Id 7202',2208.00,0.00,0.00,3.00,225.00,'2023-02-24 08:06:14','',''),(7429,'1','302','1',1,'Retail Sale Id 7203',1501.44,0.00,0.00,2.04,153.00,'2023-02-24 08:12:10','',''),(7430,'1','302','1',1,'Retail Sale Id 7204',2001.92,0.00,0.00,2.72,204.00,'2023-02-24 08:16:10','',''),(7431,'1','302','1',1,'Retail Sale Id 7205',3002.88,0.00,0.00,4.08,306.00,'2023-02-24 08:25:03','',''),(7432,'1','302','1',1,'Retail Sale Id 7206',1000.96,0.00,0.00,1.36,102.00,'2023-02-24 08:36:21','',''),(7433,'1','302','1',1,'Retail Sale Id 7207',2001.92,0.00,0.00,2.72,204.00,'2023-02-24 08:49:34','',''),(7434,'1','302','1',1,'Retail Sale Id 7208',2208.00,0.00,0.00,3.00,225.00,'2023-02-24 08:55:17','',''),(7435,'1','302','1',1,'Retail Sale Id 7210',2208.00,0.00,0.00,3.00,225.00,'2023-02-24 09:03:10','',''),(7436,'1','302','1',1,'Retail Sale Id 7211',2208.00,0.00,0.00,3.00,225.00,'2023-02-24 09:04:17','',''),(7437,'1','302','1',1,'Retail Sale Id 7212',802.24,0.00,0.00,1.09,81.75,'2023-02-24 09:05:47','',''),(7438,'1','302','1',1,'Retail Sale Id 7213',2208.00,0.00,0.00,3.00,225.00,'2023-02-24 09:06:57','',''),(7439,'1','302','1',1,'Retail Sale Id 7214',4416.00,0.00,0.00,6.00,450.00,'2023-02-24 09:07:35','',''),(7440,'1','302','1',1,'Retail Sale Id 7215',9200.00,0.00,0.00,12.50,937.50,'2023-02-24 09:16:37','',''),(7441,'1','302','1',1,'Retail Sale Id 7216',2208.00,0.00,0.00,3.00,225.00,'2023-02-24 09:18:04','',''),(7442,'1','302','1',1,'Retail Sale Id 7217',35500.00,0.00,0.00,50.00,2450.00,'2023-02-24 09:23:04','',''),(7443,'1','302','1',1,'Retail Sale Id 7218',2502.40,0.00,0.00,3.40,255.00,'2023-02-24 09:24:16','',''),(7444,'1','302','1',1,'Retail Sale Id 7219',4416.00,0.00,0.00,6.00,450.00,'2023-02-24 09:25:54','',''),(7445,'1','302','1',1,'Retail Sale Id 7220',4416.00,0.00,0.00,6.00,450.00,'2023-02-24 09:27:06','',''),(7446,'1','302','1',1,'Retail Sale Id 7221',3680.00,0.00,0.00,5.00,375.00,'2023-02-24 09:28:22','',''),(7447,'1','302','1',1,'Retail Sale Id 7222',2208.00,0.00,0.00,3.00,225.00,'2023-02-24 09:31:17','',''),(7448,'1','302','1',1,'Retail Sale Id 7223',4416.00,0.00,0.00,6.00,450.00,'2023-02-24 09:31:58','',''),(7449,'1','302','1',1,'Retail Sale Id 7224',9200.00,0.00,0.00,12.50,937.50,'2023-02-24 09:32:38','',''),(7450,'1','302','1',1,'Retail Sale Id 7225',3680.00,0.00,0.00,5.00,375.00,'2023-02-24 09:33:19','',''),(7451,'1','302','1',1,'Retail Sale Id 7226',4416.00,0.00,0.00,6.00,450.00,'2023-02-24 09:39:40','',''),(7452,'1','302','1',1,'Retail Sale Id 7227',4416.00,0.00,0.00,6.00,450.00,'2023-02-24 09:40:53','',''),(7453,'1','302','1',1,'Retail Sale Id 7228',4416.00,0.00,0.00,6.00,450.00,'2023-02-24 09:41:35','',''),(7454,'1','302','1',1,'Retail Sale Id 7229',9200.00,0.00,0.00,12.50,937.50,'2023-02-24 09:42:26','',''),(7455,'1','302','1',1,'Retail Sale Id 7230',2208.00,0.00,0.00,3.00,225.00,'2023-02-24 09:44:14','',''),(7456,'1','302','1',1,'Retail Sale Id 7231',1472.00,0.00,0.00,2.00,150.00,'2023-02-24 09:50:27','',''),(7457,'1','302','1',1,'Retail Sale Id 7232',4997.44,0.00,0.00,6.79,509.25,'2023-02-24 09:54:17','',''),(7458,'1','302','1',1,'Retail Sale Id 7233',4416.00,0.00,0.00,6.00,450.00,'2023-02-24 09:55:13','',''),(7459,'1','302','1',1,'Retail Sale Id 7234',4416.00,0.00,0.00,6.00,450.00,'2023-02-24 09:55:55','',''),(7460,'1','302','1',1,'Retail Sale Id 7235',736.00,0.00,0.00,1.00,75.00,'2023-02-24 09:58:49','',''),(7461,'1','302','1',1,'Retail Sale Id 7236',4496.96,0.00,0.00,6.11,458.25,'2023-02-24 10:00:28','',''),(7462,'1','302','1',1,'Retail Sale Id 7237',6624.00,0.00,0.00,9.00,675.00,'2023-02-24 10:05:57','',''),(7463,'1','302','1',1,'Retail Sale Id 7238',4496.96,0.00,0.00,6.11,458.25,'2023-02-24 10:10:19','',''),(7464,'1','302','1',1,'Retail Sale Id 7239',2208.00,0.00,0.00,3.00,225.00,'2023-02-24 10:21:31','',''),(7465,'1','302','1',1,'Retail Sale Id 7240',4416.00,0.00,0.00,6.00,450.00,'2023-02-24 10:23:02','',''),(7466,'1','302','1',1,'Retail Sale Id 7241',1501.44,0.00,0.00,2.04,153.00,'2023-02-24 10:23:47','',''),(7467,'1','302','1',1,'Retail Sale Id 7242',2208.00,0.00,0.00,3.00,225.00,'2023-02-24 10:25:05','',''),(7468,'1','302','1',1,'Retail Sale Id 7243',3680.00,0.00,0.00,5.00,375.00,'2023-02-24 10:26:39','',''),(7469,'1','302','1',1,'Retail Sale Id 7244',9200.00,0.00,0.00,12.50,937.50,'2023-02-24 10:29:49','',''),(7470,'1','302','1',1,'Retail Sale Id 7246',1501.44,0.00,0.00,2.04,153.00,'2023-02-24 10:41:08','',''),(7471,'1','302','1',1,'Retail Sale Id 7247',18400.00,0.00,0.00,25.00,1875.00,'2023-02-24 10:42:50','',''),(7472,'1','302','1',1,'Retail Sale Id 7248',4416.00,0.00,0.00,6.00,450.00,'2023-02-24 10:45:01','',''),(7473,'1','302','1',1,'Retail Sale Id 7249',2200.64,0.00,0.00,2.99,224.25,'2023-02-24 10:48:02','',''),(7474,'1','302','1',1,'Retail Sale Id 7250',3002.88,0.00,0.00,4.08,306.00,'2023-02-24 10:50:21','',''),(7475,'1','302','1',1,'Retail Sale Id 7251',9200.00,0.00,0.00,12.50,937.50,'2023-02-24 10:51:48','',''),(7476,'1','302','1',1,'Retail Sale Id 7252',1472.00,0.00,0.00,2.00,150.00,'2023-02-24 10:59:24','',''),(7477,'1','302','1',1,'Retail Sale Id 7253',3996.48,0.00,0.00,5.43,407.25,'2023-02-24 11:03:01','',''),(7478,'1','302','1',1,'Retail Sale Id 7254',2208.00,0.00,0.00,3.00,225.00,'2023-02-24 11:04:27','',''),(7479,'1','302','1',1,'Retail Sale Id 7255',4416.00,0.00,0.00,6.00,450.00,'2023-02-24 11:06:03','',''),(7480,'1','302','1',1,'Retail Sale Id 7256',4416.00,0.00,0.00,6.00,450.00,'2023-02-24 11:07:09','',''),(7481,'1','302','1',1,'Retail Sale Id 7258',2208.00,0.00,0.00,3.00,225.00,'2023-02-24 11:08:34','',''),(7482,'1','302','1',1,'Retail Sale Id 7259',6624.00,0.00,0.00,9.00,675.00,'2023-02-24 11:10:18','',''),(7483,'1','302','1',1,'Retail Sale Id 7260',2208.00,0.00,0.00,3.00,225.00,'2023-02-24 11:20:05','',''),(7484,'1','302','1',1,'Retail Sale Id 7261',4416.00,0.00,0.00,6.00,450.00,'2023-02-24 11:21:02','',''),(7485,'1','302','1',1,'Retail Sale Id 7262',13504.20,0.00,0.00,19.02,931.98,'2023-02-24 11:25:00','',''),(7486,'1','302','1',1,'Retail Sale Id 7263',2303.68,0.00,0.00,3.13,234.75,'2023-02-24 11:26:27','',''),(7487,'1','302','1',1,'Retail Sale Id 7264',4416.00,0.00,0.00,6.00,450.00,'2023-02-24 11:27:52','',''),(7488,'1','302','1',1,'Retail Sale Id 7265',2200.64,0.00,0.00,2.99,224.25,'2023-02-24 11:32:58','',''),(7489,'1','302','1',1,'Retail Sale Id 7266',2208.00,0.00,0.00,3.00,225.00,'2023-02-24 11:33:49','',''),(7490,'1','302','1',1,'Retail Sale Id 7267',3002.88,0.00,0.00,4.08,306.00,'2023-02-24 11:38:40','',''),(7491,'1','302','1',1,'Retail Sale Id 7268',1000.96,0.00,0.00,1.36,102.00,'2023-02-24 11:39:44','',''),(7492,'1','302','1',1,'Retail Sale Id 7269',6624.00,0.00,0.00,9.00,675.00,'2023-02-24 11:40:28','',''),(7493,'1','302','1',1,'Retail Sale Id 7270',1000.96,0.00,0.00,1.36,102.00,'2023-02-24 11:42:03','',''),(7494,'1','302','1',1,'Retail Sale Id 7271',2502.40,0.00,0.00,3.40,255.00,'2023-02-24 11:42:43','',''),(7495,'1','302','1',1,'Retail Sale Id 7272',4416.00,0.00,0.00,6.00,450.00,'2023-02-24 11:43:39','',''),(7496,'1','302','1',1,'Retail Sale Id 7274',1000.96,0.00,0.00,1.36,102.00,'2023-02-24 11:46:11','',''),(7497,'1','302','1',1,'Retail Sale Id 7275',9200.00,0.00,0.00,12.50,937.50,'2023-02-24 11:47:33','',''),(7498,'1','302','1',1,'Retail Sale Id 7276',4416.00,0.00,0.00,6.00,450.00,'2023-02-24 11:48:47','',''),(7499,'1','302','1',1,'Retail Sale Id 7278',12780.00,0.00,0.00,18.00,882.00,'2023-02-24 11:54:22','',''),(7500,'1','302','1',1,'Retail Sale Id 7279',8832.00,0.00,0.00,12.00,900.00,'2023-02-24 12:03:33','',''),(7501,'1','302','1',1,'Retail Sale Id 7280',27600.00,0.00,0.00,37.50,2812.50,'2023-02-24 12:05:22','',''),(7502,'1','302','1',1,'Retail Sale Id 7281',3680.00,0.00,0.00,5.00,375.00,'2023-02-24 12:07:24','',''),(7503,'1','302','1',1,'Retail Sale Id 7282',2208.00,0.00,0.00,3.00,225.00,'2023-02-24 12:09:08','',''),(7504,'1','302','1',1,'Retail Sale Id 7283',9200.00,0.00,0.00,12.50,937.50,'2023-02-24 12:10:07','',''),(7505,'1','302','1',1,'Retail Sale Id 7284',3680.00,0.00,0.00,5.00,375.00,'2023-02-24 12:11:32','',''),(7506,'1','302','1',1,'Retail Sale Id 7285',4416.00,0.00,0.00,6.00,450.00,'2023-02-24 12:22:48','',''),(7507,'1','302','1',1,'Retail Sale Id 7286',3996.48,0.00,0.00,5.43,407.25,'2023-02-24 12:26:15','',''),(7508,'1','302','1',1,'Retail Sale Id 7287',3996.48,0.00,0.00,5.43,407.25,'2023-02-24 12:35:47','',''),(7509,'1','302','1',1,'Retail Sale Id 7288',2001.92,0.00,0.00,2.72,204.00,'2023-02-24 12:36:52','',''),(7510,'1','302','1',1,'Retail Sale Id 7289',1000.96,0.00,0.00,1.36,102.00,'2023-02-24 12:49:57','',''),(7511,'1','302','1',1,'Retail Sale Id 7290',3002.88,0.00,0.00,4.08,306.00,'2023-02-24 12:50:46','',''),(7512,'1','302','1',1,'Retail Sale Id 7291',3002.88,0.00,0.00,4.08,306.00,'2023-02-24 12:52:08','',''),(7513,'1','302','1',1,'Retail Sale Id 7292',3680.00,0.00,0.00,5.00,375.00,'2023-02-24 12:55:37','',''),(7514,'1','302','1',1,'Retail Sale Id 7293',3002.88,0.00,0.00,4.08,306.00,'2023-02-24 12:57:10','',''),(7515,'1','302','1',1,'Retail Sale Id 7294',1000.96,0.00,0.00,1.36,102.00,'2023-02-24 13:03:13','',''),(7516,'1','302','1',1,'Retail Sale Id 7295',2951.36,0.00,0.00,4.01,300.75,'2023-02-24 13:11:43','',''),(7517,'1','302','1',1,'Retail Sale Id 7296',4416.00,0.00,0.00,6.00,450.00,'2023-02-24 13:14:36','',''),(7518,'1','302','1',1,'Retail Sale Id 7296',9200.00,0.00,0.00,12.50,937.50,'2023-02-24 13:14:36','',''),(7519,'1','302','1',1,'Retail Sale Id 7298',3680.00,0.00,0.00,5.00,375.00,'2023-02-24 13:26:01','',''),(7520,'1','302','1',1,'Retail Sale Id 7299',3680.00,0.00,0.00,5.00,375.00,'2023-02-24 14:12:06','',''),(7521,'1','302','1',1,'Retail Sale Id 7299',9200.00,0.00,0.00,12.50,937.50,'2023-02-24 14:12:06','',''),(7522,'1','302','1',1,'Retail Sale Id 7300',2502.40,0.00,0.00,3.40,255.00,'2023-02-24 14:13:01','',''),(7523,'1','302','1',1,'Retail Sale Id 7301',5152.00,0.00,0.00,7.00,525.00,'2023-02-24 14:14:04','',''),(7524,'1','302','1',1,'Retail Sale Id 7302',1000.96,0.00,0.00,1.36,102.00,'2023-02-24 14:14:52','',''),(7525,'1','302','1',1,'Retail Sale Id 7303',1501.44,0.00,0.00,2.04,153.00,'2023-02-24 14:15:45','',''),(7526,'1','302','1',1,'Retail Sale Id 7304',1000.96,0.00,0.00,1.36,102.00,'2023-02-24 14:16:38','',''),(7527,'1','302','1',1,'Retail Sale Id 7305',5152.00,0.00,0.00,7.00,525.00,'2023-02-24 14:17:49','',''),(7528,'1','302','1',1,'Retail Sale Id 7306',736.00,0.00,0.00,1.00,75.00,'2023-02-24 14:18:37','',''),(7529,'1','302','1',1,'Retail Sale Id 7307',2303.68,0.00,0.00,3.13,234.75,'2023-02-24 14:19:36','',''),(7530,'1','302','1',1,'Retail Sale Id 7308',4416.00,0.00,0.00,6.00,450.00,'2023-02-24 14:20:24','',''),(7531,'1','302','1',1,'Retail Sale Id 7309',4416.00,0.00,0.00,6.00,450.00,'2023-02-24 14:22:31','',''),(7532,'1','302','1',1,'Retail Sale Id 7310',2208.00,0.00,0.00,3.00,225.00,'2023-02-24 14:23:25','',''),(7533,'1','302','1',1,'Retail Sale Id 7311',9200.00,0.00,0.00,12.50,937.50,'2023-02-24 14:24:04','',''),(7534,'1','302','1',1,'Retail Sale Id 7312',4416.00,0.00,0.00,6.00,450.00,'2023-02-24 14:29:40','',''),(7535,'1','302','1',1,'Retail Sale Id 7313',2001.92,0.00,0.00,2.72,204.00,'2023-02-24 14:35:40','',''),(7536,'1','302','1',1,'Retail Sale Id 7314',4416.00,0.00,0.00,6.00,450.00,'2023-02-24 14:43:34','',''),(7537,'1','302','1',1,'Retail Sale Id 7315',4416.00,0.00,0.00,6.00,450.00,'2023-02-24 14:45:06','',''),(7538,'1','302','1',1,'Retail Sale Id 7316',4496.96,0.00,0.00,6.11,458.25,'2023-02-24 14:47:26','',''),(7539,'1','302','1',1,'Retail Sale Id 7317',3002.88,0.00,0.00,4.08,306.00,'2023-02-24 14:52:37','',''),(7540,'1','302','1',1,'Retail Sale Id 7318',9200.00,0.00,0.00,12.50,937.50,'2023-02-24 14:54:49','',''),(7541,'1','302','1',1,'Retail Sale Id 7319',8000.32,0.00,0.00,10.87,815.25,'2023-02-24 15:25:38','',''),(7542,'1','302','1',1,'Retail Sale Id 7320',2001.92,0.00,0.00,2.72,204.00,'2023-02-24 15:26:30','',''),(7543,'1','302','1',1,'Retail Sale Id 7321',9200.00,0.00,0.00,12.50,937.50,'2023-02-24 15:27:41','',''),(7544,'1','302','1',1,'Retail Sale Id 7322',3996.48,0.00,0.00,5.43,407.25,'2023-02-24 15:29:10','',''),(7545,'1','302','1',1,'Retail Sale Id 7323',1501.44,0.00,0.00,2.04,153.00,'2023-02-24 15:31:54','',''),(7546,'1','302','1',1,'Retail Sale Id 7324',9200.00,0.00,0.00,12.50,937.50,'2023-02-24 15:34:51','',''),(7547,'1','302','1',1,'Retail Sale Id 7325',4416.00,0.00,0.00,6.00,450.00,'2023-02-24 15:36:32','',''),(7548,'1','302','1',1,'Retail Sale Id 7326',9200.00,0.00,0.00,12.50,937.50,'2023-02-24 15:38:24','',''),(7549,'1','302','1',1,'Retail Sale Id 7327',1000.96,0.00,0.00,1.36,102.00,'2023-02-24 15:40:34','',''),(7550,'1','302','1',1,'Retail Sale Id 7328',1501.44,0.00,0.00,2.04,153.00,'2023-02-24 15:41:54','',''),(7551,'1','302','1',1,'Retail Sale Id 7329',4416.00,0.00,0.00,6.00,450.00,'2023-02-24 15:44:41','',''),(7552,'1','302','1',1,'Retail Sale Id 7330',8000.32,0.00,0.00,10.87,815.25,'2023-02-24 15:45:32','',''),(7553,'1','302','1',1,'Retail Sale Id 7331',9200.00,0.00,0.00,12.50,937.50,'2023-02-24 15:46:45','',''),(7554,'1','302','1',1,'Retail Sale Id 7332',1501.44,0.00,0.00,2.04,153.00,'2023-02-24 15:48:10','',''),(7555,'1','302','1',1,'Retail Sale Id 7333',3996.48,0.00,0.00,5.43,407.25,'2023-02-24 15:52:52','',''),(7556,'1','302','1',1,'Retail Sale Id 7334',2252.16,0.00,0.00,3.06,229.50,'2023-02-24 15:54:45','',''),(7557,'1','302','1',1,'Retail Sale Id 7335',750.72,0.00,0.00,1.02,76.50,'2023-02-24 16:03:13','',''),(7558,'1','302','1',1,'Retail Sale Id 7336',1501.44,0.00,0.00,2.04,153.00,'2023-02-24 16:07:25','',''),(7559,'1','302','1',1,'Retail Sale Id 7337',1501.44,0.00,0.00,2.04,153.00,'2023-02-24 16:08:46','',''),(7560,'1','302','1',1,'Retail Sale Id 7338',9200.00,0.00,0.00,12.50,937.50,'2023-02-24 16:09:28','',''),(7561,'1','302','1',1,'Retail Sale Id 7339',1398.40,0.00,0.00,1.90,142.50,'2023-02-24 16:25:21','',''),(7562,'1','302','1',1,'Retail Sale Id 7340',1000.96,0.00,0.00,1.36,102.00,'2023-02-24 16:34:21','',''),(7563,'1','302','1',1,'Retail Sale Id 7341',2200.64,0.00,0.00,2.99,224.25,'2023-02-24 16:36:24','',''),(7564,'1','302','1',1,'Retail Sale Id 7342',2178.56,0.00,0.00,2.96,222.00,'2023-02-24 16:38:12','',''),(7565,'1','302','1',1,'Retail Sale Id 7343',9200.00,0.00,0.00,12.50,937.50,'2023-02-24 16:39:27','',''),(7566,'1','302','1',1,'Retail Sale Id 7345',2001.92,0.00,0.00,2.72,204.00,'2023-02-24 16:54:41','',''),(7567,'1','302','1',1,'Retail Sale Id 7346',2001.92,0.00,0.00,2.72,204.00,'2023-02-24 17:06:40','',''),(7568,'1','302','1',1,'Retail Sale Id 7347',2001.92,0.00,0.00,2.72,204.00,'2023-02-24 17:15:11','',''),(7569,'1','302','1',1,'Retail Sale Id 7348',5998.40,0.00,0.00,8.15,611.25,'2023-02-24 17:16:11','',''),(7570,'1','302','1',1,'Retail Sale Id 7349',2001.92,0.00,0.00,2.72,204.00,'2023-02-24 17:17:20','',''),(7571,'1','302','1',1,'Retail Sale Id 7350',2001.92,0.00,0.00,2.72,204.00,'2023-02-24 17:20:52','',''),(7572,'1','302','1',1,'Retail Sale Id 7351',2001.92,0.00,0.00,2.72,204.00,'2023-02-24 17:24:52','',''),(7573,'1','302','1',1,'Retail Sale Id 7352',2208.00,0.00,0.00,3.00,225.00,'2023-02-24 17:33:53','',''),(7574,'1','302','1',1,'Retail Sale Id 7353',4997.44,0.00,0.00,6.79,509.25,'2023-02-24 17:34:48','',''),(7575,'1','302','1',1,'Retail Sale Id 7354',500.48,0.00,0.00,0.68,51.00,'2023-02-24 17:35:34','',''),(7576,'1','302','1',1,'Retail Sale Id 7355',4997.44,0.00,0.00,6.79,509.25,'2023-02-24 17:36:09','',''),(7577,'1','302','1',1,'Retail Sale Id 7356',2252.16,0.00,0.00,3.06,229.50,'2023-02-24 17:36:57','',''),(7578,'1','302','1',1,'Retail Sale Id 7357',3002.88,0.00,0.00,4.08,306.00,'2023-02-24 17:49:47','',''),(7579,'1','302','1',1,'Retail Sale Id 7358',1501.44,0.00,0.00,2.04,153.00,'2023-02-24 17:57:09','',''),(7580,'1','302','1',1,'Retail Sale Id 7359',1000.96,0.00,0.00,1.36,102.00,'2023-02-24 18:01:53','',''),(7581,'1','302','1',1,'Retail Sale Id 7360',1000.96,0.00,0.00,1.36,102.00,'2023-02-24 18:02:42','',''),(7582,'1','302','1',1,'Retail Sale Id 7361',3996.48,0.00,0.00,5.43,407.25,'2023-02-24 18:03:50','',''),(7583,'1','302','1',1,'Retail Sale Id 7362',2001.92,0.00,0.00,2.72,204.00,'2023-02-24 18:09:32','',''),(7584,'1','302','1',1,'Retail Sale Id 7363',2944.00,0.00,0.00,4.00,300.00,'2023-02-24 18:15:20','',''),(7585,'1','302','1',1,'Retail Sale Id 7364',3702.08,0.00,0.00,5.03,377.25,'2023-02-24 18:17:42','',''),(7586,'1','302','1',1,'Retail Sale Id 7365',3680.00,0.00,0.00,5.00,375.00,'2023-02-24 18:20:33','',''),(7587,'1','302','1',1,'Retail Sale Id 7366',6624.00,0.00,0.00,9.00,675.00,'2023-02-24 18:22:54','',''),(7588,'1','302','1',1,'Retail Sale Id 7367',2502.40,0.00,0.00,3.40,255.00,'2023-02-24 18:24:06','',''),(7589,'1','302','1',1,'Retail Sale Id 7368',1111.36,0.00,0.00,1.51,113.25,'2023-02-24 19:36:18','',''),(7590,'1','302','1',1,'Retail Sale Id 7369',3996.48,0.00,0.00,5.43,407.25,'2023-02-26 10:10:17','',''),(7591,'1','302','1',1,'Retail Sale Id 7370',3996.48,0.00,0.00,5.43,407.25,'2023-02-26 10:16:17','',''),(7592,'1','302','1',1,'Retail Sale Id 7370',4416.00,0.00,0.00,6.00,450.00,'2023-02-26 10:16:17','',''),(7593,'1','302','1',1,'Retail Sale Id 7372',5888.00,0.00,0.00,8.00,600.00,'2023-02-26 10:18:36','',''),(7594,'1','302','1',1,'Retail Sale Id 7374',2208.00,0.00,0.00,3.00,225.00,'2023-02-26 10:19:50','',''),(7595,'1','302','1',1,'Retail Sale Id 7375',4416.00,0.00,0.00,6.00,450.00,'2023-02-26 10:20:48','',''),(7596,'1','302','1',1,'Retail Sale Id 7376',21300.00,0.00,0.00,30.00,1470.00,'2023-02-26 10:31:56','',''),(7597,'1','302','1',1,'Retail Sale Id 7377',9200.00,0.00,0.00,12.50,937.50,'2023-02-26 10:33:05','',''),(7598,'1','302','1',1,'Retail Sale Id 7378',1000.96,0.00,0.00,1.36,102.00,'2023-02-26 10:35:09','',''),(7599,'1','302','1',1,'Retail Sale Id 7379',802.24,0.00,0.00,1.09,81.75,'2023-02-26 10:36:27','',''),(7600,'1','302','1',1,'Retail Sale Id 7380',2208.00,0.00,0.00,3.00,225.00,'2023-02-26 10:40:26','',''),(7601,'1','302','1',1,'Retail Sale Id 7381',2001.92,0.00,0.00,2.72,204.00,'2023-02-26 10:44:13','',''),(7602,'1','302','1',1,'Retail Sale Id 7382',2208.00,0.00,0.00,3.00,225.00,'2023-02-26 10:46:46','',''),(7603,'1','302','1',1,'Retail Sale Id 7384',1501.44,0.00,0.00,2.04,153.00,'2023-02-26 11:42:06','',''),(7604,'1','302','1',1,'Retail Sale Id 7385',2502.40,0.00,0.00,3.40,255.00,'2023-02-26 11:43:17','',''),(7605,'1','302','1',1,'Retail Sale Id 7386',92206.08,0.00,0.00,125.28,9396.00,'2023-02-26 11:46:59','',''),(7606,'1','302','1',1,'Retail Sale Id 7387',35500.00,0.00,0.00,50.00,2450.00,'2023-02-26 11:47:42','',''),(7607,'1','302','1',1,'Retail Sale Id 7388',35500.00,0.00,0.00,50.00,2450.00,'2023-02-26 11:48:59','',''),(7608,'1','302','1',1,'Retail Sale Id 7389',2208.00,0.00,0.00,3.00,225.00,'2023-02-26 11:52:00','',''),(7609,'1','302','1',1,'Retail Sale Id 7390',1000.96,0.00,0.00,1.36,102.00,'2023-02-26 11:53:27','',''),(7610,'1','302','1',1,'Retail Sale Id 7391',4416.00,0.00,0.00,6.00,450.00,'2023-02-26 12:01:18','',''),(7611,'1','302','1',1,'Retail Sale Id 7392',4997.44,0.00,0.00,6.79,509.25,'2023-02-26 12:04:57','',''),(7612,'1','302','1',1,'Retail Sale Id 7393',3002.88,0.00,0.00,4.08,306.00,'2023-02-26 12:07:12','',''),(7613,'1','302','1',1,'Retail Sale Id 7394',17750.00,0.00,0.00,25.00,1225.00,'2023-02-26 12:10:08','',''),(7614,'1','302','1',1,'Retail Sale Id 7395',4416.00,0.00,0.00,6.00,450.00,'2023-02-26 12:11:36','',''),(7615,'1','302','1',1,'Retail Sale Id 7396',1000.96,0.00,0.00,1.36,102.00,'2023-02-26 12:18:46','',''),(7616,'1','302','1',1,'Retail Sale Id 7397',3002.88,0.00,0.00,4.08,306.00,'2023-02-26 12:21:08','',''),(7617,'1','302','1',1,'Retail Sale Id 7398',14403.52,0.00,0.00,19.57,1467.75,'2023-02-26 12:22:00','',''),(7618,'1','302','1',1,'Retail Sale Id 7399',4496.96,0.00,0.00,6.11,458.25,'2023-02-26 12:23:36','',''),(7619,'1','302','1',1,'Retail Sale Id 7400',500.48,0.00,0.00,0.68,51.00,'2023-02-26 12:26:09','',''),(7620,'1','302','1',1,'Retail Sale Id 7401',2001.92,0.00,0.00,2.72,204.00,'2023-02-26 12:27:39','',''),(7621,'1','302','1',1,'Retail Sale Id 7402',1000.96,0.00,0.00,1.36,102.00,'2023-02-26 12:31:21','',''),(7622,'1','302','1',1,'Retail Sale Id 7403',9200.00,0.00,0.00,12.50,937.50,'2023-02-26 12:35:47','',''),(7623,'1','302','1',1,'Retail Sale Id 7404',4997.44,0.00,0.00,6.79,509.25,'2023-02-26 12:41:15','',''),(7624,'1','302','1',1,'Retail Sale Id 7405',9200.00,0.00,0.00,12.50,937.50,'2023-02-26 12:42:15','',''),(7625,'1','302','1',1,'Retail Sale Id 7406',4416.00,0.00,0.00,6.00,450.00,'2023-02-26 12:43:58','',''),(7626,'1','302','1',1,'Retail Sale Id 7407',3002.88,0.00,0.00,4.08,306.00,'2023-02-26 12:47:36','',''),(7627,'1','302','1',1,'Retail Sale Id 7408',4416.00,0.00,0.00,6.00,450.00,'2023-02-26 12:48:22','',''),(7628,'1','302','1',1,'Retail Sale Id 7409',3680.00,0.00,0.00,5.00,375.00,'2023-02-26 12:56:00','',''),(7629,'1','302','1',1,'Retail Sale Id 7410',9200.00,0.00,0.00,12.50,937.50,'2023-02-26 13:09:02','',''),(7630,'1','302','1',1,'Retail Sale Id 7411',2208.00,0.00,0.00,3.00,225.00,'2023-02-26 13:22:30','',''),(7631,'1','302','1',1,'Retail Sale Id 7412',2208.00,0.00,0.00,3.00,225.00,'2023-02-26 13:34:32','',''),(7632,'1','302','1',1,'Retail Sale Id 7413',2208.00,0.00,0.00,3.00,225.00,'2023-02-26 13:43:16','',''),(7633,'1','302','1',1,'Retail Sale Id 7414',3680.00,0.00,0.00,5.00,375.00,'2023-02-26 13:59:05','',''),(7634,'1','302','1',1,'Retail Sale Id 7415',1000.96,0.00,0.00,1.36,102.00,'2023-02-26 14:01:11','',''),(7635,'1','302','1',1,'Retail Sale Id 7416',9200.00,0.00,0.00,12.50,937.50,'2023-02-26 14:02:52','',''),(7636,'1','302','1',1,'Retail Sale Id 7417',3996.48,0.00,0.00,5.43,407.25,'2023-02-26 14:07:57','',''),(7637,'1','302','1',1,'Retail Sale Id 7418',4997.44,0.00,0.00,6.79,509.25,'2023-02-26 14:09:47','',''),(7638,'1','302','1',1,'Retail Sale Id 7419',2001.92,0.00,0.00,2.72,204.00,'2023-02-26 14:17:10','',''),(7639,'1','302','1',1,'Retail Sale Id 7420',3002.88,0.00,0.00,4.08,306.00,'2023-02-26 14:18:29','',''),(7640,'1','302','1',1,'Retail Sale Id 7421',2208.00,0.00,0.00,3.00,225.00,'2023-02-26 14:29:38','',''),(7641,'1','302','1',1,'Retail Sale Id 7422',2303.68,0.00,0.00,3.13,234.75,'2023-02-26 14:31:16','',''),(7642,'1','302','1',1,'Retail Sale Id 7423',2944.00,0.00,0.00,4.00,300.00,'2023-02-26 14:34:37','',''),(7643,'1','302','1',1,'Retail Sale Id 7424',2208.00,0.00,0.00,3.00,225.00,'2023-02-26 14:36:41','',''),(7644,'1','302','1',1,'Retail Sale Id 7425',2502.40,0.00,0.00,3.40,255.00,'2023-02-26 14:37:54','',''),(7645,'1','302','1',1,'Retail Sale Id 7426',2399.36,0.00,0.00,3.26,244.50,'2023-02-26 14:39:16','',''),(7646,'1','302','1',1,'Retail Sale Id 7427',9200.00,0.00,0.00,12.50,937.50,'2023-02-26 14:46:59','',''),(7647,'1','302','1',1,'Retail Sale Id 7428',9200.00,0.00,0.00,12.50,937.50,'2023-02-26 14:49:02','',''),(7648,'1','302','1',1,'Retail Sale Id 7429',3709.44,0.00,0.00,5.04,378.00,'2023-02-26 14:51:22','',''),(7649,'1','302','1',1,'Retail Sale Id 7430',3680.00,0.00,0.00,5.00,375.00,'2023-02-26 14:58:32','',''),(7650,'1','302','1',1,'Retail Sale Id 7430',9200.00,0.00,0.00,12.50,937.50,'2023-02-26 14:58:32','',''),(7651,'1','302','1',1,'Retail Sale Id 7430',9200.00,0.00,0.00,12.50,937.50,'2023-02-26 14:58:32','',''),(7652,'1','302','1',1,'Retail Sale Id 7431',5490.56,0.00,0.00,7.46,559.50,'2023-02-26 15:00:30','',''),(7653,'1','302','1',1,'Retail Sale Id 7433',3002.88,0.00,0.00,4.08,306.00,'2023-02-26 15:06:49','',''),(7654,'1','302','1',1,'Retail Sale Id 7434',3503.36,0.00,0.00,4.76,357.00,'2023-02-26 15:08:47','',''),(7655,'1','302','1',1,'Retail Sale Id 7435',1000.96,0.00,0.00,1.36,102.00,'2023-02-26 15:20:22','',''),(7656,'1','302','1',1,'Retail Sale Id 7437',1413.12,0.00,0.00,1.92,144.00,'2023-02-26 15:23:00','',''),(7657,'1','302','1',1,'Retail Sale Id 7438',9200.00,0.00,0.00,12.50,937.50,'2023-02-26 15:25:38','',''),(7658,'1','302','1',1,'Retail Sale Id 7439',1501.44,0.00,0.00,2.04,153.00,'2023-02-26 15:27:02','',''),(7659,'1','302','1',1,'Retail Sale Id 7440',2252.16,0.00,0.00,3.06,229.50,'2023-02-26 15:28:27','',''),(7660,'1','302','1',1,'Retail Sale Id 7441',4416.00,0.00,0.00,6.00,450.00,'2023-02-26 15:31:58','',''),(7661,'1','302','1',1,'Retail Sale Id 7443',6624.00,0.00,0.00,9.00,675.00,'2023-02-26 15:33:43','',''),(7662,'1','302','1',1,'Retail Sale Id 7444',20608.00,0.00,0.00,28.00,2100.00,'2023-02-26 15:37:08','',''),(7663,'1','302','1',1,'Retail Sale Id 7445',3503.36,0.00,0.00,4.76,357.00,'2023-02-26 15:42:07','',''),(7664,'1','302','1',1,'Retail Sale Id 7446',3002.88,0.00,0.00,4.08,306.00,'2023-02-26 15:46:41','',''),(7665,'1','302','1',1,'Retail Sale Id 7447',2001.92,0.00,0.00,2.72,204.00,'2023-02-26 16:01:20','',''),(7666,'1','302','1',1,'Retail Sale Id 7448',9200.00,0.00,0.00,12.50,937.50,'2023-02-26 16:04:22','',''),(7667,'1','302','1',1,'Retail Sale Id 7449',4416.00,0.00,0.00,6.00,450.00,'2023-02-26 16:07:12','',''),(7668,'1','302','1',1,'Retail Sale Id 7450',2208.00,0.00,0.00,3.00,225.00,'2023-02-26 16:11:34','',''),(7669,'1','302','1',1,'Retail Sale Id 7451',5888.00,0.00,0.00,8.00,600.00,'2023-02-26 16:13:48','',''),(7670,'1','302','1',1,'Retail Sale Id 7452',4416.00,0.00,0.00,6.00,450.00,'2023-02-26 16:20:30','',''),(7671,'1','302','1',1,'Retail Sale Id 7453',9200.00,0.00,0.00,12.50,937.50,'2023-02-26 16:22:40','',''),(7672,'1','302','1',1,'Retail Sale Id 7454',2208.00,0.00,0.00,3.00,225.00,'2023-02-26 16:25:30','',''),(7673,'1','302','1',1,'Retail Sale Id 7455',3002.88,0.00,0.00,4.08,306.00,'2023-02-26 16:36:45','',''),(7674,'1','302','1',1,'Retail Sale Id 7456',1472.00,0.00,0.00,2.00,150.00,'2023-02-26 16:38:50','',''),(7675,'1','302','1',1,'Retail Sale Id 7457',2944.00,0.00,0.00,4.00,300.00,'2023-02-26 16:40:09','',''),(7676,'1','302','1',1,'Retail Sale Id 7458',4416.00,0.00,0.00,6.00,450.00,'2023-02-26 16:41:33','',''),(7677,'1','302','1',1,'Retail Sale Id 7459',9200.00,0.00,0.00,12.50,937.50,'2023-02-26 16:47:02','',''),(7678,'1','302','1',1,'Retail Sale Id 7460',1000.96,0.00,0.00,1.36,102.00,'2023-02-26 16:49:53','',''),(7679,'1','302','1',1,'Retail Sale Id 7461',5998.40,0.00,0.00,8.15,611.25,'2023-02-26 16:51:22','',''),(7680,'1','302','1',1,'Retail Sale Id 7462',1472.00,0.00,0.00,2.00,150.00,'2023-02-26 16:53:23','',''),(7681,'1','302','1',1,'Retail Sale Id 7463',353.28,0.00,0.00,0.48,36.00,'2023-02-26 16:59:30','',''),(7682,'1','302','1',1,'Retail Sale Id 7464',51.52,0.00,0.00,0.07,5.25,'2023-02-26 17:03:37','',''),(7683,'1','302','1',1,'Retail Sale Id 7465',2200.64,0.00,0.00,2.99,224.25,'2023-02-26 17:04:48','',''),(7684,'1','302','1',1,'Retail Sale Id 7466',17750.00,0.00,0.00,25.00,1225.00,'2023-02-26 17:05:52','',''),(7685,'1','302','1',1,'Retail Sale Id 7467',4416.00,0.00,0.00,6.00,450.00,'2023-02-26 17:07:55','',''),(7686,'1','302','1',1,'Retail Sale Id 7469',2208.00,0.00,0.00,3.00,225.00,'2023-02-26 17:10:08','',''),(7687,'1','302','1',1,'Retail Sale Id 7470',4416.00,0.00,0.00,6.00,450.00,'2023-02-26 17:14:14','',''),(7688,'1','302','1',1,'Retail Sale Id 7471',2502.40,0.00,0.00,3.40,255.00,'2023-02-26 17:14:57','',''),(7689,'1','302','1',1,'Retail Sale Id 7472',4496.96,0.00,0.00,6.11,458.25,'2023-02-26 17:15:54','',''),(7690,'1','302','1',1,'Retail Sale Id 7473',1501.44,0.00,0.00,2.04,153.00,'2023-02-26 17:18:02','',''),(7691,'1','302','1',1,'Retail Sale Id 7474',1472.00,0.00,0.00,2.00,150.00,'2023-02-26 17:22:36','',''),(7692,'1','302','1',1,'Retail Sale Id 7475',2208.00,0.00,0.00,3.00,225.00,'2023-02-26 17:24:42','',''),(7693,'1','302','1',1,'Retail Sale Id 7475',9200.00,0.00,0.00,12.50,937.50,'2023-02-26 17:24:42','',''),(7694,'1','302','1',1,'Retail Sale Id 7476',500.48,0.00,0.00,0.68,51.00,'2023-02-26 17:25:41','',''),(7695,'1','302','1',1,'Retail Sale Id 7478',9200.00,0.00,0.00,12.50,937.50,'2023-02-26 17:28:42','',''),(7696,'1','302','1',1,'Retail Sale Id 7479',2252.16,0.00,0.00,3.06,229.50,'2023-02-26 17:29:59','',''),(7697,'1','302','1',1,'Retail Sale Id 7480',9200.00,0.00,0.00,12.50,937.50,'2023-02-26 17:32:06','',''),(7698,'1','302','1',1,'Retail Sale Id 7481',736.00,0.00,0.00,1.00,75.00,'2023-02-26 17:33:39','',''),(7699,'1','302','1',1,'Retail Sale Id 7482',2208.00,0.00,0.00,3.00,225.00,'2023-02-26 17:38:47','',''),(7700,'1','302','1',1,'Retail Sale Id 7483',2001.92,0.00,0.00,2.72,204.00,'2023-02-26 17:42:49','',''),(7701,'1','302','1',1,'Retail Sale Id 7484',2208.00,0.00,0.00,3.00,225.00,'2023-02-26 17:48:08','',''),(7702,'1','302','1',1,'Retail Sale Id 7485',2208.00,0.00,0.00,3.00,225.00,'2023-02-26 17:53:37','',''),(7703,'1','302','1',1,'Retail Sale Id 7486',2208.00,0.00,0.00,3.00,225.00,'2023-02-26 18:09:56','',''),(7704,'1','302','1',1,'Retail Sale Id 7487',9200.00,0.00,0.00,12.50,937.50,'2023-02-26 18:21:32','',''),(7705,'1','302','1',1,'Retail Sale Id 7488',161.92,0.00,0.00,0.22,16.50,'2023-02-26 18:44:32','',''),(7706,'1','302','1',1,'Retail Sale Id 7489',4416.00,0.00,0.00,6.00,450.00,'2023-02-27 10:30:42','',''),(7707,'1','302','1',1,'Retail Sale Id 7490',35500.00,0.00,0.00,50.00,2450.00,'2023-02-27 10:32:06','',''),(7708,'1','302','1',1,'Retail Sale Id 7491',4416.00,0.00,0.00,6.00,450.00,'2023-02-27 10:36:30','',''),(7709,'1','302','1',1,'Retail Sale Id 7492',2944.00,0.00,0.00,4.00,300.00,'2023-02-27 10:37:29','',''),(7710,'1','302','1',1,'Retail Sale Id 7493',74718.72,0.00,0.00,101.52,7614.00,'2023-02-27 10:38:24','',''),(7711,'1','302','1',1,'Retail Sale Id 7494',8875.00,0.00,0.00,12.50,612.50,'2023-02-27 10:41:26','',''),(7712,'1','302','1',1,'Retail Sale Id 7495',4416.00,0.00,0.00,6.00,450.00,'2023-02-27 10:43:49','',''),(7713,'1','302','1',1,'Retail Sale Id 7496',2208.00,0.00,0.00,3.00,225.00,'2023-02-27 10:46:25','',''),(7714,'1','302','1',1,'Retail Sale Id 7497',4416.00,0.00,0.00,6.00,450.00,'2023-02-27 10:47:46','',''),(7715,'1','302','1',1,'Retail Sale Id 7498',2208.00,0.00,0.00,3.00,225.00,'2023-02-27 11:02:04','',''),(7716,'1','302','1',1,'Retail Sale Id 7499',9200.00,0.00,0.00,12.50,937.50,'2023-02-27 11:22:59','',''),(7717,'1','302','1',1,'Retail Sale Id 7500',9200.00,0.00,0.00,12.50,937.50,'2023-02-27 11:24:16','',''),(7718,'1','302','1',1,'Retail Sale Id 7501',4416.00,0.00,0.00,6.00,450.00,'2023-02-27 11:25:04','',''),(7719,'1','302','1',1,'Retail Sale Id 7503',4416.00,0.00,0.00,6.00,450.00,'2023-02-27 11:29:37','',''),(7720,'1','302','1',1,'Retail Sale Id 7504',4416.00,0.00,0.00,6.00,450.00,'2023-02-27 11:30:54','',''),(7721,'1','302','1',1,'Retail Sale Id 7505',1472.00,0.00,0.00,2.00,150.00,'2023-02-27 11:32:27','',''),(7722,'1','302','1',1,'Retail Sale Id 7506',2208.00,0.00,0.00,3.00,225.00,'2023-02-27 11:41:16','',''),(7723,'1','302','1',1,'Retail Sale Id 7506',4416.00,0.00,0.00,6.00,450.00,'2023-02-27 11:41:16','',''),(7724,'1','302','1',1,'Retail Sale Id 7506',4416.00,0.00,0.00,6.00,450.00,'2023-02-27 11:41:16','',''),(7725,'1','302','1',1,'Retail Sale Id 7506',4416.00,0.00,0.00,6.00,450.00,'2023-02-27 11:41:16','',''),(7726,'1','302','1',1,'Retail Sale Id 7507',3680.00,0.00,0.00,5.00,375.00,'2023-02-27 11:42:32','',''),(7727,'1','302','1',1,'Retail Sale Id 7508',4416.00,0.00,0.00,6.00,450.00,'2023-02-27 11:54:56','',''),(7728,'1','302','1',1,'Retail Sale Id 7509',2208.00,0.00,0.00,3.00,225.00,'2023-02-27 11:59:28','',''),(7729,'1','302','1',1,'Retail Sale Id 7510',2130.00,0.00,0.00,3.00,147.00,'2023-02-27 12:03:01','',''),(7730,'1','302','1',1,'Retail Sale Id 7511',3680.00,0.00,0.00,5.00,375.00,'2023-02-27 12:05:17','',''),(7731,'1','302','1',1,'Retail Sale Id 7512',4416.00,0.00,0.00,6.00,450.00,'2023-02-27 12:06:58','',''),(7732,'1','302','1',1,'Retail Sale Id 7513',1000.96,0.00,0.00,1.36,102.00,'2023-02-27 12:07:43','',''),(7733,'1','302','1',1,'Retail Sale Id 7515',4416.00,0.00,0.00,6.00,450.00,'2023-02-27 12:08:56','',''),(7734,'1','302','1',1,'Retail Sale Id 7516',2208.00,0.00,0.00,3.00,225.00,'2023-02-27 12:14:32','',''),(7735,'1','302','1',1,'Retail Sale Id 7516',3680.00,0.00,0.00,5.00,375.00,'2023-02-27 12:14:32','',''),(7736,'1','302','1',1,'Retail Sale Id 7517',2208.00,0.00,0.00,3.00,225.00,'2023-02-27 12:27:11','',''),(7737,'1','302','1',1,'Retail Sale Id 7518',21300.00,0.00,0.00,30.00,1470.00,'2023-02-27 13:04:40','',''),(7738,'1','302','1',1,'Retail Sale Id 7519',4416.00,0.00,0.00,6.00,450.00,'2023-02-27 13:06:08','',''),(7739,'1','302','1',1,'Retail Sale Id 7520',2208.00,0.00,0.00,3.00,225.00,'2023-02-27 13:15:28','',''),(7740,'1','302','1',1,'Retail Sale Id 7522',2208.00,0.00,0.00,3.00,225.00,'2023-02-27 13:21:51','',''),(7741,'1','302','1',1,'Retail Sale Id 7522',9200.00,0.00,0.00,12.50,937.50,'2023-02-27 13:21:51','',''),(7742,'1','302','1',1,'Retail Sale Id 7523',8520.00,0.00,0.00,12.00,588.00,'2023-02-27 13:25:15','',''),(7743,'1','302','1',1,'Retail Sale Id 7524',7100.00,0.00,0.00,10.00,490.00,'2023-02-27 13:26:29','',''),(7744,'1','302','1',1,'Retail Sale Id 7525',6999.36,0.00,0.00,9.51,713.25,'2023-02-27 13:27:31','',''),(7745,'1','302','1',1,'Retail Sale Id 7526',5888.00,0.00,0.00,8.00,600.00,'2023-02-27 13:28:16','',''),(7746,'1','302','1',1,'Retail Sale Id 7527',35500.00,0.00,0.00,50.00,2450.00,'2023-02-27 13:30:12','',''),(7747,'1','302','1',1,'Retail Sale Id 7528',2208.00,0.00,0.00,3.00,225.00,'2023-02-27 13:34:32','',''),(7748,'1','302','1',1,'Retail Sale Id 7529',6999.36,0.00,0.00,9.51,713.25,'2023-02-27 13:46:59','',''),(7749,'1','302','1',1,'Retail Sale Id 7530',2208.00,0.00,0.00,3.00,225.00,'2023-02-27 13:58:27','',''),(7750,'1','302','1',1,'Retail Sale Id 7531',4416.00,0.00,0.00,6.00,450.00,'2023-02-27 14:03:37','',''),(7751,'1','302','1',1,'Retail Sale Id 7532',2208.00,0.00,0.00,3.00,225.00,'2023-02-27 14:14:02','',''),(7752,'1','302','1',1,'Retail Sale Id 7533',1000.96,0.00,0.00,1.36,102.00,'2023-02-27 14:24:46','',''),(7753,'1','302','1',1,'Retail Sale Id 7534',9200.00,0.00,0.00,12.50,937.50,'2023-02-27 14:30:18','',''),(7754,'1','302','1',1,'Retail Sale Id 7535',750.72,0.00,0.00,1.02,76.50,'2023-02-27 14:33:00','',''),(7755,'1','302','1',1,'Retail Sale Id 7535',750.72,0.00,0.00,1.02,76.50,'2023-02-27 14:33:00','',''),(7756,'1','302','1',1,'Retail Sale Id 7536',2001.92,0.00,0.00,2.72,204.00,'2023-02-27 14:34:16','',''),(7757,'1','302','1',1,'Retail Sale Id 7537',4416.00,0.00,0.00,6.00,450.00,'2023-02-27 14:46:26','',''),(7758,'1','302','1',1,'Retail Sale Id 7538',3503.36,0.00,0.00,4.76,357.00,'2023-02-27 14:52:58','',''),(7759,'1','302','1',1,'Retail Sale Id 7539',2208.00,0.00,0.00,3.00,225.00,'2023-02-27 14:55:34','',''),(7760,'1','302','1',1,'Retail Sale Id 7540',7360.00,0.00,0.00,10.00,750.00,'2023-02-27 14:58:06','',''),(7761,'1','302','1',1,'Retail Sale Id 7541',2001.92,0.00,0.00,2.72,204.00,'2023-02-27 15:05:32','',''),(7762,'1','302','1',1,'Retail Sale Id 7542',5152.00,0.00,0.00,7.00,525.00,'2023-02-27 15:14:05','',''),(7763,'1','302','1',1,'Retail Sale Id 7543',2208.00,0.00,0.00,3.00,225.00,'2023-02-27 15:22:20','',''),(7764,'1','302','1',1,'Retail Sale Id 7544',9200.00,0.00,0.00,12.50,937.50,'2023-02-27 15:40:14','',''),(7765,'1','302','1',1,'Retail Sale Id 7545',18400.00,0.00,0.00,25.00,1875.00,'2023-02-27 15:45:38','',''),(7766,'1','302','1',1,'Retail Sale Id 7546',2208.00,0.00,0.00,3.00,225.00,'2023-02-27 15:50:31','',''),(7767,'1','302','1',1,'Retail Sale Id 7546',2944.00,0.00,0.00,4.00,300.00,'2023-02-27 15:50:31','',''),(7768,'1','302','1',1,'Retail Sale Id 7547',3002.88,0.00,0.00,4.08,306.00,'2023-02-27 15:58:03','',''),(7769,'1','302','1',1,'Retail Sale Id 7548',1472.00,0.00,0.00,2.00,150.00,'2023-02-27 16:04:46','',''),(7770,'1','302','1',1,'Retail Sale Id 7549',5888.00,0.00,0.00,8.00,600.00,'2023-02-27 16:08:32','',''),(7771,'1','302','1',1,'Retail Sale Id 7550',35500.00,0.00,0.00,50.00,2450.00,'2023-02-27 16:24:33','',''),(7772,'1','302','1',1,'Retail Sale Id 7551',2208.00,0.00,0.00,3.00,225.00,'2023-02-27 16:34:52','',''),(7773,'1','302','1',1,'Retail Sale Id 7552',2208.00,0.00,0.00,3.00,225.00,'2023-02-27 16:39:30','',''),(7774,'1','302','1',1,'Retail Sale Id 7553',17750.00,0.00,0.00,25.00,1225.00,'2023-02-27 16:45:26','',''),(7775,'1','302','1',1,'Retail Sale Id 7554',3680.00,0.00,0.00,5.00,375.00,'2023-02-27 16:54:32','',''),(7776,'1','302','1',1,'Retail Sale Id 7555',1000.96,0.00,0.00,1.36,102.00,'2023-02-27 17:08:02','',''),(7777,'1','302','1',1,'Retail Sale Id 7556',2001.92,0.00,0.00,2.72,204.00,'2023-02-27 17:10:19','',''),(7778,'1','302','1',1,'Retail Sale Id 7557',2001.92,0.00,0.00,2.72,204.00,'2023-02-27 17:12:05','',''),(7779,'1','302','1',1,'Retail Sale Id 7558',4416.00,0.00,0.00,6.00,450.00,'2023-02-27 17:17:13','',''),(7780,'1','302','1',1,'Retail Sale Id 7559',3002.88,0.00,0.00,4.08,306.00,'2023-02-27 17:18:35','',''),(7781,'1','302','1',1,'Retail Sale Id 7560',71000.00,0.00,0.00,100.00,4900.00,'2023-02-27 17:31:04','',''),(7782,'1','302','1',1,'Retail Sale Id 7561',500.48,0.00,0.00,0.68,51.00,'2023-02-27 17:32:21','',''),(7783,'1','302','1',1,'Retail Sale Id 7562',4416.00,0.00,0.00,6.00,450.00,'2023-02-27 17:33:21','',''),(7784,'1','302','1',1,'Retail Sale Id 7563',4416.00,0.00,0.00,6.00,450.00,'2023-02-27 17:35:38','',''),(7785,'1','302','1',1,'Retail Sale Id 7564',4496.96,0.00,0.00,6.11,458.25,'2023-02-27 17:38:36','',''),(7786,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,82175.52,124.32,0.00,0.00,'2023-02-27 21:31:57','',''),(7787,'1','302',NULL,1,'Reception corrector for bridging 42',0.00,0.00,0.00,124.32,0.00,'2023-02-27 22:22:38','',''),(7788,'1','302','1',1,'Received from bridging 42',0.00,0.00,124.32,0.00,0.00,'2023-02-27 22:22:38','',''),(7789,'1','302','1',1,'Retail Sale Id 7565',91499.52,0.00,0.00,124.32,9324.00,'2023-02-27 22:27:38','',''),(7790,'1','302','1',1,'Return of Retail Sale Id 7564',0.00,4496.96,6.11,0.00,-458.25,'2023-02-27 22:41:49','',''),(7791,'1','302','1',1,'Return of Retail Sale Id 7555',0.00,1000.96,1.36,0.00,-102.00,'2023-02-27 22:44:39','',''),(7792,'1','302','1',1,'Retail Sale Id 7566',794.88,0.00,0.00,1.08,81.00,'2023-02-27 22:47:34','',''),(7793,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3515400.00,5400.00,0.00,0.00,'2023-02-28 13:11:57','',''),(7794,'1','302','1',1,'Retail Sale Id 7567',2502.40,0.00,0.00,3.40,289.00,'2023-02-28 13:23:48','',''),(7795,'1','302',NULL,1,'Reception corrector for bridging 43',0.00,0.00,0.00,5400.00,0.00,'2023-02-28 13:45:44','',''),(7796,'1','302','1',1,'Received from bridging 43',0.00,0.00,5400.00,0.00,0.00,'2023-02-28 13:45:44','',''),(7797,'1','302','1',1,'Retail Sale Id 7571',9200.00,0.00,0.00,12.50,1062.50,'2023-02-28 13:49:33','',''),(7798,'1','302','1',1,'Retail Sale Id 7572',3002.88,0.00,0.00,4.08,346.80,'2023-02-28 13:52:28','',''),(7799,'1','302','1',1,'Retail Sale Id 7573',9200.00,0.00,0.00,12.50,1062.50,'2023-02-28 13:56:56','',''),(7800,'1','302','1',1,'Retail Sale Id 7574',4416.00,0.00,0.00,6.00,510.00,'2023-02-28 13:57:58','',''),(7801,'1','302','1',1,'Retail Sale Id 7575',2208.00,0.00,0.00,3.00,255.00,'2023-02-28 13:59:09','',''),(7802,'1','302','1',1,'Retail Sale Id 7576',8520.00,0.00,0.00,12.00,708.00,'2023-02-28 14:01:39','',''),(7803,'1','302','1',1,'Retail Sale Id 7577',100979.20,0.00,0.00,137.20,11662.00,'2023-02-28 14:02:35','',''),(7804,'1','302','1',1,'Retail Sale Id 7578',1000.96,0.00,0.00,1.36,115.60,'2023-02-28 14:05:41','',''),(7805,'1','302','1',1,'Retail Sale Id 7579',36800.00,0.00,0.00,50.00,4250.00,'2023-02-28 14:09:20','',''),(7806,'1','302','1',1,'Retail Sale Id 7580',802.24,0.00,0.00,1.09,92.65,'2023-02-28 14:12:43','',''),(7807,'1','302','1',1,'Retail Sale Id 7581',2001.92,0.00,0.00,2.72,231.20,'2023-02-28 14:15:50','',''),(7808,'1','302','1',1,'Retail Sale Id 7582',4496.96,0.00,0.00,6.11,519.35,'2023-02-28 14:19:27','',''),(7809,'1','302','1',1,'Retail Sale Id 7583',9200.00,0.00,0.00,12.50,1062.50,'2023-02-28 14:23:32','',''),(7810,'1','302','1',1,'Retail Sale Id 7585',1501.44,0.00,0.00,2.04,173.40,'2023-02-28 14:25:16','',''),(7811,'1','302','1',1,'Retail Sale Id 7586',2208.00,0.00,0.00,3.00,255.00,'2023-02-28 14:26:26','',''),(7812,'1','302','1',1,'Retail Sale Id 7587',9200.00,0.00,0.00,12.50,1062.50,'2023-02-28 14:29:36','',''),(7813,'1','302','1',1,'Retail Sale Id 7588',2208.00,0.00,0.00,3.00,255.00,'2023-02-28 14:30:55','',''),(7814,'1','302','1',1,'Retail Sale Id 7589',2208.00,0.00,0.00,3.00,255.00,'2023-02-28 14:32:54','',''),(7815,'1','302','1',1,'Retail Sale Id 7590',4416.00,0.00,0.00,6.00,510.00,'2023-02-28 14:33:49','',''),(7816,'1','302','1',1,'Retail Sale Id 7591',4416.00,0.00,0.00,6.00,510.00,'2023-02-28 14:37:43','',''),(7817,'1','302','1',1,'Retail Sale Id 7592',1000.96,0.00,0.00,1.36,115.60,'2023-02-28 14:52:46','',''),(7818,'1','302','1',1,'Retail Sale Id 7593',9200.00,0.00,0.00,12.50,1062.50,'2023-02-28 14:56:49','',''),(7819,'1','302','1',1,'Retail Sale Id 7594',9200.00,0.00,0.00,12.50,1062.50,'2023-02-28 14:59:00','',''),(7820,'1','302','1',1,'Retail Sale Id 7596',5600.96,0.00,0.00,7.61,646.85,'2023-02-28 15:08:59','',''),(7821,'1','302','1',1,'Retail Sale Id 7597',2001.92,0.00,0.00,2.72,231.20,'2023-02-28 15:15:59','',''),(7822,'1','302','1',1,'Retail Sale Id 7598',4416.00,0.00,0.00,6.00,510.00,'2023-02-28 15:17:09','',''),(7823,'1','302','1',1,'Retail Sale Id 7599',2208.00,0.00,0.00,3.00,255.00,'2023-02-28 15:18:44','',''),(7824,'1','302','1',1,'Retail Sale Id 7601',3680.00,0.00,0.00,5.00,425.00,'2023-02-28 15:30:22','',''),(7825,'1','302','1',1,'Retail Sale Id 7602',1000.96,0.00,0.00,1.36,115.60,'2023-02-28 16:00:38','',''),(7826,'1','302','1',1,'Retail Sale Id 7603',9200.00,0.00,0.00,12.50,1062.50,'2023-02-28 16:04:17','',''),(7827,'1','302','1',1,'Retail Sale Id 7604',2208.00,0.00,0.00,3.00,255.00,'2023-02-28 16:12:32','',''),(7828,'1','302','1',1,'Retail Sale Id 7605',3680.00,0.00,0.00,5.00,425.00,'2023-02-28 16:16:25','',''),(7829,'1','302','1',1,'Retail Sale Id 7605',4416.00,0.00,0.00,6.00,510.00,'2023-02-28 16:16:25','',''),(7830,'1','302','1',1,'Retail Sale Id 7606',9200.00,0.00,0.00,12.50,1062.50,'2023-02-28 16:19:43','',''),(7831,'1','302','1',1,'Retail Sale Id 7607',2208.00,0.00,0.00,3.00,255.00,'2023-02-28 16:28:25','',''),(7832,'1','302','1',1,'Retail Sale Id 7608',3996.48,0.00,0.00,5.43,461.55,'2023-02-28 16:39:07','',''),(7833,'1','302','1',1,'Retail Sale Id 7609',17750.00,0.00,0.00,25.00,1475.00,'2023-02-28 16:48:42','',''),(7834,'1','302','1',1,'Retail Sale Id 7610',3996.48,0.00,0.00,5.43,461.55,'2023-02-28 16:49:38','',''),(7835,'1','302','1',1,'Retail Sale Id 7611',3503.36,0.00,0.00,4.76,404.60,'2023-02-28 16:53:24','',''),(7836,'1','302','1',1,'Retail Sale Id 7612',2208.00,0.00,0.00,3.00,255.00,'2023-02-28 16:57:57','',''),(7837,'1','302','1',1,'Retail Sale Id 7613',2001.92,0.00,0.00,2.72,231.20,'2023-02-28 16:59:36','',''),(7838,'1','302','1',1,'Retail Sale Id 7614',9568.00,0.00,0.00,13.00,1105.00,'2023-02-28 17:11:23','',''),(7839,'1','302','1',1,'Retail Sale Id 7615',2208.00,0.00,0.00,3.00,255.00,'2023-02-28 17:17:48','',''),(7840,'1','302','1',1,'Retail Sale Id 7616',9200.00,0.00,0.00,12.50,1062.50,'2023-02-28 17:19:44','',''),(7841,'1','302','1',1,'Retail Sale Id 7617',1000.96,0.00,0.00,1.36,115.60,'2023-02-28 17:25:45','',''),(7842,'1','302','1',1,'Retail Sale Id 7618',4416.00,0.00,0.00,6.00,510.00,'2023-02-28 17:31:06','',''),(7843,'1','302','1',1,'Retail Sale Id 7619',9200.00,0.00,0.00,12.50,1062.50,'2023-02-28 17:32:58','',''),(7844,'1','302','1',1,'Retail Sale Id 7620',4416.00,0.00,0.00,6.00,510.00,'2023-02-28 17:41:51','',''),(7845,'1','302','1',1,'Retail Sale Id 7621',2208.00,0.00,0.00,3.00,255.00,'2023-02-28 17:45:44','',''),(7846,'1','302','1',1,'Retail Sale Id 7622',8096.00,0.00,0.00,11.00,935.00,'2023-02-28 18:11:48','',''),(7847,'1','302','1',1,'Retail Sale Id 7623',206.08,0.00,0.00,0.28,23.80,'2023-02-28 18:15:18','',''),(7848,'1','302','1',1,'Return of Retail Sale Id 7623',0.00,206.08,0.28,0.00,-23.80,'2023-02-28 18:19:41','',''),(7849,'1','302','1',1,'Retail Sale Id 7624',22.08,0.00,0.00,0.03,2.55,'2023-02-28 18:20:40','',''),(7850,'1','302','1',1,'Retail Sale Id 7625',3996.48,0.00,0.00,5.43,461.55,'2023-03-01 07:42:10','',''),(7851,'1','302','1',1,'Retail Sale Id 7626',4416.00,0.00,0.00,6.00,510.00,'2023-03-01 07:55:57','',''),(7852,'1','302','1',1,'Retail Sale Id 7627',4416.00,0.00,0.00,6.00,510.00,'2023-03-01 07:58:55','',''),(7853,'1','302','1',1,'Retail Sale Id 7627',4416.00,0.00,0.00,6.00,510.00,'2023-03-01 07:58:55','',''),(7854,'1','302','1',1,'Retail Sale Id 7628',4416.00,0.00,0.00,6.00,510.00,'2023-03-01 08:00:08','',''),(7855,'1','302','1',1,'Retail Sale Id 7629',4416.00,0.00,0.00,6.00,510.00,'2023-03-01 08:02:37','',''),(7856,'1','302','1',1,'Retail Sale Id 7630',3680.00,0.00,0.00,5.00,425.00,'2023-03-01 08:03:57','',''),(7857,'1','302','1',1,'Retail Sale Id 7631',4416.00,0.00,0.00,6.00,510.00,'2023-03-01 08:27:45','',''),(7858,'1','302','1',1,'Retail Sale Id 7632',9200.00,0.00,0.00,12.50,1062.50,'2023-03-01 08:29:23','',''),(7859,'1','302','1',1,'Retail Sale Id 7633',1501.44,0.00,0.00,2.04,173.40,'2023-03-01 08:38:00','',''),(7860,'1','302','1',1,'Retail Sale Id 7634',802.24,0.00,0.00,1.09,92.65,'2023-03-01 08:42:29','',''),(7861,'1','302','1',1,'Retail Sale Id 7635',3680.00,0.00,0.00,5.00,425.00,'2023-03-01 08:48:06','',''),(7862,'1','302','1',1,'Retail Sale Id 7636',1472.00,0.00,0.00,2.00,170.00,'2023-03-01 08:50:13','',''),(7863,'1','302','1',1,'Retail Sale Id 7637',3680.00,0.00,0.00,5.00,425.00,'2023-03-01 08:51:57','',''),(7864,'1','302','1',1,'Retail Sale Id 7638',2001.92,0.00,0.00,2.72,231.20,'2023-03-01 08:54:02','',''),(7865,'1','302','1',1,'Retail Sale Id 7639',4416.00,0.00,0.00,6.00,510.00,'2023-03-01 09:02:26','',''),(7866,'1','302','1',1,'Retail Sale Id 7640',1501.44,0.00,0.00,2.04,173.40,'2023-03-01 09:15:58','',''),(7867,'1','302','1',1,'Retail Sale Id 7641',4416.00,0.00,0.00,6.00,510.00,'2023-03-01 09:22:06','',''),(7868,'1','302','1',1,'Retail Sale Id 7642',2001.92,0.00,0.00,2.72,231.20,'2023-03-01 09:27:30','',''),(7869,'1','302','1',1,'Retail Sale Id 7643',2208.00,0.00,0.00,3.00,255.00,'2023-03-01 09:31:29','',''),(7870,'1','302','1',1,'Retail Sale Id 7644',9200.00,0.00,0.00,12.50,1062.50,'2023-03-01 09:57:21','',''),(7871,'1','302','1',1,'Retail Sale Id 7645',9200.00,0.00,0.00,12.50,1062.50,'2023-03-01 10:17:30','',''),(7872,'1','302','1',1,'Retail Sale Id 7646',2001.92,0.00,0.00,2.72,231.20,'2023-03-01 10:18:54','',''),(7873,'1','302','1',1,'Retail Sale Id 7647',4416.00,0.00,0.00,6.00,510.00,'2023-03-01 10:20:40','',''),(7874,'1','302','1',1,'Retail Sale Id 7648',3002.88,0.00,0.00,4.08,346.80,'2023-03-01 10:23:26','',''),(7875,'1','302','1',1,'Retail Sale Id 7649',29440.00,0.00,0.00,40.00,3400.00,'2023-03-01 10:26:13','',''),(7876,'1','302','1',1,'Retail Sale Id 7650',4416.00,0.00,0.00,6.00,510.00,'2023-03-01 10:32:52','',''),(7877,'1','302','1',1,'Retail Sale Id 7651',4997.44,0.00,0.00,6.79,577.15,'2023-03-01 10:38:01','',''),(7878,'1','302','1',1,'Retail Sale Id 7652',9200.00,0.00,0.00,12.50,1062.50,'2023-03-01 10:39:07','',''),(7879,'1','302','1',1,'Retail Sale Id 7653',4416.00,0.00,0.00,6.00,510.00,'2023-03-01 10:45:24','',''),(7880,'1','302','1',1,'Retail Sale Id 7654',2001.92,0.00,0.00,2.72,231.20,'2023-03-01 11:04:19','',''),(7881,'1','302','1',1,'Retail Sale Id 7655',4416.00,0.00,0.00,6.00,510.00,'2023-03-01 11:05:35','',''),(7882,'1','302','1',1,'Retail Sale Id 7655',4416.00,0.00,0.00,6.00,510.00,'2023-03-01 11:05:35','',''),(7883,'1','302','1',1,'Retail Sale Id 7656',4416.00,0.00,0.00,6.00,510.00,'2023-03-01 11:07:56','',''),(7884,'1','302','1',1,'Retail Sale Id 7657',3680.00,0.00,0.00,5.00,425.00,'2023-03-01 11:11:14','',''),(7885,'1','302','1',1,'Retail Sale Id 7658',4416.00,0.00,0.00,6.00,510.00,'2023-03-01 11:14:24','',''),(7886,'1','302','1',1,'Retail Sale Id 7660',4416.00,0.00,0.00,6.00,510.00,'2023-03-01 11:21:17','',''),(7887,'1','302','1',1,'Retail Sale Id 7661',3680.00,0.00,0.00,5.00,425.00,'2023-03-01 11:23:04','',''),(7888,'1','302','1',1,'Retail Sale Id 7661',4416.00,0.00,0.00,6.00,510.00,'2023-03-01 11:23:04','',''),(7889,'1','302','1',1,'Retail Sale Id 7662',4997.44,0.00,0.00,6.79,577.15,'2023-03-01 11:25:47','',''),(7890,'1','302','1',1,'Retail Sale Id 7663',9200.00,0.00,0.00,12.50,1062.50,'2023-03-01 11:28:24','',''),(7891,'1','302','1',1,'Retail Sale Id 7664',4416.00,0.00,0.00,6.00,510.00,'2023-03-01 11:29:57','',''),(7892,'1','302','1',1,'Retail Sale Id 7665',3002.88,0.00,0.00,4.08,346.80,'2023-03-01 11:37:29','',''),(7893,'1','302','1',1,'Retail Sale Id 7666',2208.00,0.00,0.00,3.00,255.00,'2023-03-01 11:38:34','',''),(7894,'1','302','1',1,'Retail Sale Id 7667',2944.00,0.00,0.00,4.00,340.00,'2023-03-01 11:45:29','',''),(7895,'1','302','1',1,'Retail Sale Id 7668',4416.00,0.00,0.00,6.00,510.00,'2023-03-01 11:48:15','',''),(7896,'1','302','1',1,'Retail Sale Id 7669',10002.24,0.00,0.00,13.59,1155.15,'2023-03-01 11:58:41','',''),(7897,'1','302','1',1,'Retail Sale Id 7670',2001.92,0.00,0.00,2.72,231.20,'2023-03-01 12:04:32','',''),(7898,'1','302','1',1,'Retail Sale Id 7671',2001.92,0.00,0.00,2.72,231.20,'2023-03-01 12:13:54','',''),(7899,'1','302','1',1,'Retail Sale Id 7672',1501.44,0.00,0.00,2.04,173.40,'2023-03-01 12:16:50','',''),(7900,'1','302','1',1,'Retail Sale Id 7673',3680.00,0.00,0.00,5.00,425.00,'2023-03-01 12:17:49','',''),(7901,'1','302','1',1,'Retail Sale Id 7674',3002.88,0.00,0.00,4.08,346.80,'2023-03-01 12:22:55','',''),(7902,'1','302','1',1,'Retail Sale Id 7675',3680.00,0.00,0.00,5.00,425.00,'2023-03-01 12:24:32','',''),(7903,'1','302','1',1,'Retail Sale Id 7676',9200.00,0.00,0.00,12.50,1062.50,'2023-03-01 12:41:57','',''),(7904,'1','302','1',1,'Retail Sale Id 7677',4416.00,0.00,0.00,6.00,510.00,'2023-03-01 12:51:16','',''),(7905,'1','302','1',1,'Retail Sale Id 7678',4416.00,0.00,0.00,6.00,510.00,'2023-03-01 12:52:29','',''),(7906,'1','302','1',1,'Retail Sale Id 7679',1000.96,0.00,0.00,1.36,115.60,'2023-03-01 12:55:13','',''),(7907,'1','302','1',1,'Retail Sale Id 7680',9200.00,0.00,0.00,12.50,1062.50,'2023-03-01 12:56:14','',''),(7908,'1','302','1',1,'Retail Sale Id 7681',9200.00,0.00,0.00,12.50,1062.50,'2023-03-01 12:59:48','',''),(7909,'1','302','1',1,'Retail Sale Id 7682',4416.00,0.00,0.00,6.00,510.00,'2023-03-01 13:07:33','',''),(7910,'1','302','1',1,'Retail Sale Id 7683',2200.64,0.00,0.00,2.99,254.15,'2023-03-01 13:10:01','',''),(7911,'1','302','1',1,'Retail Sale Id 7684',4496.96,0.00,0.00,6.11,519.35,'2023-03-01 13:12:12','',''),(7912,'1','302','1',1,'Retail Sale Id 7685',9200.00,0.00,0.00,12.50,1062.50,'2023-03-01 13:13:01','',''),(7913,'1','302','1',1,'Retail Sale Id 7686',9200.00,0.00,0.00,12.50,1062.50,'2023-03-01 13:14:11','',''),(7914,'1','302','1',1,'Retail Sale Id 7687',2208.00,0.00,0.00,3.00,255.00,'2023-03-01 13:15:12','',''),(7915,'1','302','1',1,'Retail Sale Id 7688',2001.92,0.00,0.00,2.72,231.20,'2023-03-01 13:32:08','',''),(7916,'1','302','1',1,'Retail Sale Id 7689',3763.00,0.00,0.00,5.30,312.70,'2023-03-01 13:44:02','',''),(7917,'1','302','1',1,'Retail Sale Id 7690',2001.92,0.00,0.00,2.72,231.20,'2023-03-01 13:46:53','',''),(7918,'1','302','1',1,'Retail Sale Id 7691',2208.00,0.00,0.00,3.00,255.00,'2023-03-01 13:54:41','',''),(7919,'1','302','1',1,'Retail Sale Id 7693',3002.88,0.00,0.00,4.08,346.80,'2023-03-01 13:57:33','',''),(7920,'1','302','1',1,'Retail Sale Id 7694',4416.00,0.00,0.00,6.00,510.00,'2023-03-01 13:59:55','',''),(7921,'1','302','1',1,'Retail Sale Id 7695',1501.44,0.00,0.00,2.04,173.40,'2023-03-01 14:05:32','',''),(7922,'1','302','1',1,'Retail Sale Id 7696',3002.88,0.00,0.00,4.08,346.80,'2023-03-01 14:08:50','',''),(7923,'1','302','1',1,'Retail Sale Id 7697',8096.00,0.00,0.00,11.00,935.00,'2023-03-01 14:13:19','',''),(7924,'1','302','1',1,'Retail Sale Id 7698',4416.00,0.00,0.00,6.00,510.00,'2023-03-01 14:19:19','',''),(7925,'1','302','1',1,'Retail Sale Id 7699',3680.00,0.00,0.00,5.00,425.00,'2023-03-01 14:26:12','',''),(7926,'1','302','1',1,'Retail Sale Id 7700',1472.00,0.00,0.00,2.00,170.00,'2023-03-01 14:29:35','',''),(7927,'1','302','1',1,'Retail Sale Id 7701',7360.00,0.00,0.00,10.00,850.00,'2023-03-01 14:35:22','',''),(7928,'1','302','1',1,'Retail Sale Id 7702',4452.80,0.00,0.00,6.05,514.25,'2023-03-01 14:38:22','',''),(7929,'1','302','1',1,'Retail Sale Id 7703',9200.00,0.00,0.00,12.50,1062.50,'2023-03-01 14:44:15','',''),(7930,'1','302','1',1,'Retail Sale Id 7704',1037.76,0.00,0.00,1.41,119.85,'2023-03-01 14:51:50','',''),(7931,'1','302','1',1,'Retail Sale Id 7705',2001.92,0.00,0.00,2.72,231.20,'2023-03-01 14:56:06','',''),(7932,'1','302','1',1,'Retail Sale Id 7706',3996.48,0.00,0.00,5.43,461.55,'2023-03-01 14:59:58','',''),(7933,'1','302','1',1,'Retail Sale Id 7707',2001.92,0.00,0.00,2.72,231.20,'2023-03-01 15:01:22','',''),(7934,'1','302','1',1,'Retail Sale Id 7708',2502.40,0.00,0.00,3.40,289.00,'2023-03-01 15:52:30','',''),(7935,'1','302','1',1,'Retail Sale Id 7709',9200.00,0.00,0.00,12.50,1062.50,'2023-03-01 16:03:24','',''),(7936,'1','302','1',1,'Retail Sale Id 7710',4496.96,0.00,0.00,6.11,519.35,'2023-03-01 16:25:58','',''),(7937,'1','302','1',1,'Retail Sale Id 7711',3002.88,0.00,0.00,4.08,346.80,'2023-03-01 16:28:59','',''),(7938,'1','302','1',1,'Retail Sale Id 7712',4416.00,0.00,0.00,6.00,510.00,'2023-03-01 16:33:17','',''),(7939,'1','302','1',1,'Retail Sale Id 7713',11040.00,0.00,0.00,15.00,1275.00,'2023-03-01 16:52:11','',''),(7940,'1','302','1',1,'Retail Sale Id 7714',2944.00,0.00,0.00,4.00,340.00,'2023-03-01 17:10:04','',''),(7941,'1','302','1',1,'Retail Sale Id 7715',2208.00,0.00,0.00,3.00,255.00,'2023-03-01 17:12:23','',''),(7942,'1','302','1',1,'Retail Sale Id 7716',7360.00,0.00,0.00,10.00,850.00,'2023-03-01 17:16:57','',''),(7943,'1','302','1',1,'Retail Sale Id 7717',897.92,0.00,0.00,1.22,103.70,'2023-03-01 17:22:02','',''),(7944,'1','302','1',1,'Retail Sale Id 7718',1472.00,0.00,0.00,2.00,170.00,'2023-03-01 17:23:14','',''),(7945,'1','302','1',1,'Retail Sale Id 7719',9200.00,0.00,0.00,12.50,1062.50,'2023-03-01 17:24:01','',''),(7946,'1','302','1',1,'Retail Sale Id 7720',2208.00,0.00,0.00,3.00,255.00,'2023-03-01 17:25:37','',''),(7947,'1','302','1',1,'Retail Sale Id 7721',3680.00,0.00,0.00,5.00,425.00,'2023-03-01 17:33:56','',''),(7948,'1','302','1',1,'Retail Sale Id 7722',9200.00,0.00,0.00,12.50,1062.50,'2023-03-01 17:34:52','',''),(7949,'1','302','1',1,'Retail Sale Id 7723',9200.00,0.00,0.00,12.50,1062.50,'2023-03-01 17:42:51','',''),(7950,'1','302','1',1,'Retail Sale Id 7724',3680.00,0.00,0.00,5.00,425.00,'2023-03-01 17:56:13','',''),(7951,'1','302','1',1,'Retail Sale Id 7725',1501.44,0.00,0.00,2.04,173.40,'2023-03-01 17:58:12','',''),(7952,'1','302','1',1,'Retail Sale Id 7726',21300.00,0.00,0.00,30.00,1770.00,'2023-03-01 18:01:02','',''),(7953,'1','302','1',1,'Retail Sale Id 7727',3680.00,0.00,0.00,5.00,425.00,'2023-03-01 18:08:54','',''),(7954,'1','302','1',1,'Retail Sale Id 7728',9200.00,0.00,0.00,12.50,1062.50,'2023-03-01 18:11:21','',''),(7955,'1','302','1',1,'Retail Sale Id 7729',3002.88,0.00,0.00,4.08,346.80,'2023-03-01 18:15:30','',''),(7956,'1','302','1',1,'Retail Sale Id 7730',4416.00,0.00,0.00,6.00,510.00,'2023-03-01 18:21:37','',''),(7957,'1','302','1',1,'Retail Sale Id 7730',9200.00,0.00,0.00,12.50,1062.50,'2023-03-01 18:21:37','',''),(7958,'1','302','1',1,'Retail Sale Id 7731',17750.00,0.00,0.00,25.00,1475.00,'2023-03-01 18:38:33','',''),(7959,'1','302','1',1,'Retail Sale Id 7732',7499.84,0.00,0.00,10.19,866.15,'2023-03-01 18:42:27','',''),(7960,'1','302','1',1,'Retail Sale Id 7733',132.48,0.00,0.00,0.18,15.30,'2023-03-01 18:55:23','',''),(7961,'1','302','1',1,'Return of Retail Sale Id 7733',0.00,132.48,0.18,0.00,-15.30,'2023-03-01 19:14:02','',''),(7962,'1','302','1',1,'Return of Retail Sale Id 7718',0.00,1472.00,2.00,0.00,-170.00,'2023-03-01 19:16:08','',''),(7963,'1','302','1',1,'Retail Sale Id 7734',1339.52,0.00,0.00,1.82,154.70,'2023-03-01 19:17:57','',''),(7964,'1','302','1',1,'Retail Sale Id 7735',4416.00,0.00,0.00,6.00,510.00,'2023-03-02 07:34:53','',''),(7965,'1','302','1',1,'Retail Sale Id 7736',2001.92,0.00,0.00,2.72,231.20,'2023-03-02 07:36:55','',''),(7966,'1','302','1',1,'Retail Sale Id 7737',4416.00,0.00,0.00,6.00,510.00,'2023-03-02 07:54:52','',''),(7967,'1','302','1',1,'Retail Sale Id 7738',2208.00,0.00,0.00,3.00,255.00,'2023-03-02 07:56:45','',''),(7968,'1','302','1',1,'Retail Sale Id 7739',2502.40,0.00,0.00,3.40,289.00,'2023-03-02 07:58:34','',''),(7969,'1','302','1',1,'Retail Sale Id 7740',3996.48,0.00,0.00,5.43,461.55,'2023-03-02 08:00:20','',''),(7970,'1','302','1',1,'Retail Sale Id 7741',3002.88,0.00,0.00,4.08,346.80,'2023-03-02 08:01:36','',''),(7971,'1','302','1',1,'Retail Sale Id 7742',699.20,0.00,0.00,0.95,80.75,'2023-03-02 08:03:59','',''),(7972,'1','302','1',1,'Retail Sale Id 7743',4416.00,0.00,0.00,6.00,510.00,'2023-03-02 08:05:19','',''),(7973,'1','302','1',1,'Retail Sale Id 7744',3680.00,0.00,0.00,5.00,425.00,'2023-03-02 08:06:45','',''),(7974,'1','302','1',1,'Retail Sale Id 7745',2796.80,0.00,0.00,3.80,323.00,'2023-03-02 08:13:04','',''),(7975,'1','302','1',1,'Retail Sale Id 7746',1000.96,0.00,0.00,1.36,115.60,'2023-03-02 08:32:52','',''),(7976,'1','302','1',1,'Retail Sale Id 7747',897.92,0.00,0.00,1.22,103.70,'2023-03-02 08:45:10','',''),(7977,'1','302','1',1,'Retail Sale Id 7748',7360.00,0.00,0.00,10.00,850.00,'2023-03-02 08:48:05','',''),(7978,'1','302','1',1,'Retail Sale Id 7749',1501.44,0.00,0.00,2.04,173.40,'2023-03-02 08:52:44','',''),(7979,'1','302','1',1,'Retail Sale Id 7750',4416.00,0.00,0.00,6.00,510.00,'2023-03-02 09:00:47','',''),(7980,'1','302','1',1,'Retail Sale Id 7751',17750.00,0.00,0.00,25.00,1475.00,'2023-03-02 09:14:05','',''),(7981,'1','302','1',1,'Retail Sale Id 7752',4416.00,0.00,0.00,6.00,510.00,'2023-03-02 09:17:13','',''),(7982,'1','302','1',1,'Retail Sale Id 7753',3002.88,0.00,0.00,4.08,346.80,'2023-03-02 09:20:02','',''),(7983,'1','302','1',1,'Retail Sale Id 7754',8096.00,0.00,0.00,11.00,935.00,'2023-03-02 09:30:21','',''),(7984,'1','302','1',1,'Retail Sale Id 7755',4416.00,0.00,0.00,6.00,510.00,'2023-03-02 09:32:04','',''),(7985,'1','302','1',1,'Retail Sale Id 7756',3680.00,0.00,0.00,5.00,425.00,'2023-03-02 09:34:00','',''),(7986,'1','302','1',1,'Retail Sale Id 7757',3702.08,0.00,0.00,5.03,427.55,'2023-03-02 09:35:40','',''),(7987,'1','302','1',1,'Retail Sale Id 7758',2208.00,0.00,0.00,3.00,255.00,'2023-03-02 09:36:49','',''),(7988,'1','302','1',1,'Retail Sale Id 7759',3002.88,0.00,0.00,4.08,346.80,'2023-03-02 09:38:03','',''),(7989,'1','302','1',1,'Retail Sale Id 7760',4416.00,0.00,0.00,6.00,510.00,'2023-03-02 09:48:20','',''),(7990,'1','302','1',1,'Retail Sale Id 7761',3996.48,0.00,0.00,5.43,461.55,'2023-03-02 09:49:45','',''),(7991,'1','302','1',1,'Retail Sale Id 7762',2208.00,0.00,0.00,3.00,255.00,'2023-03-02 09:55:55','',''),(7992,'1','302','1',1,'Retail Sale Id 7763',4416.00,0.00,0.00,6.00,510.00,'2023-03-02 09:58:54','',''),(7993,'1','302','1',1,'Retail Sale Id 7764',4416.00,0.00,0.00,6.00,510.00,'2023-03-02 10:24:16','',''),(7994,'1','302','1',1,'Retail Sale Id 7765',4416.00,0.00,0.00,6.00,510.00,'2023-03-02 10:27:59','',''),(7995,'1','302','1',1,'Retail Sale Id 7766',2208.00,0.00,0.00,3.00,255.00,'2023-03-02 10:30:27','',''),(7996,'1','302','1',1,'Retail Sale Id 7767',3680.00,0.00,0.00,5.00,425.00,'2023-03-02 10:34:17','',''),(7997,'1','302','1',1,'Retail Sale Id 7768',750.72,0.00,0.00,1.02,86.70,'2023-03-02 10:35:36','',''),(7998,'1','302','1',1,'Retail Sale Id 7769',3680.00,0.00,0.00,5.00,425.00,'2023-03-02 10:37:34','',''),(7999,'1','302','1',1,'Retail Sale Id 7770',18400.00,0.00,0.00,25.00,2125.00,'2023-03-02 10:42:05','',''),(8000,'1','302','1',1,'Retail Sale Id 7771',4416.00,0.00,0.00,6.00,510.00,'2023-03-02 10:45:11','',''),(8001,'1','302','1',1,'Retail Sale Id 7772',3002.88,0.00,0.00,4.08,346.80,'2023-03-02 10:45:46','',''),(8002,'1','302','1',1,'Retail Sale Id 7773',9200.00,0.00,0.00,12.50,1062.50,'2023-03-02 11:01:32','',''),(8003,'1','302','1',1,'Retail Sale Id 7774',3002.88,0.00,0.00,4.08,346.80,'2023-03-02 11:04:56','',''),(8004,'1','302','1',1,'Retail Sale Id 7775',1472.00,0.00,0.00,2.00,170.00,'2023-03-02 11:07:45','',''),(8005,'1','302','1',1,'Retail Sale Id 7776',4416.00,0.00,0.00,6.00,510.00,'2023-03-02 11:22:37','',''),(8006,'1','302','1',1,'Retail Sale Id 7777',9200.00,0.00,0.00,12.50,1062.50,'2023-03-02 11:34:12','',''),(8007,'1','302','1',1,'Retail Sale Id 7778',2208.00,0.00,0.00,3.00,255.00,'2023-03-02 11:36:03','',''),(8008,'1','302','1',1,'Retail Sale Id 7779',4401.28,0.00,0.00,5.98,508.30,'2023-03-02 11:37:30','',''),(8009,'1','302','1',1,'Retail Sale Id 7780',4416.00,0.00,0.00,6.00,510.00,'2023-03-02 11:38:44','',''),(8010,'1','302','1',1,'Retail Sale Id 7782',3002.88,0.00,0.00,4.08,346.80,'2023-03-02 11:44:57','',''),(8011,'1','302','1',1,'Retail Sale Id 7783',1000.96,0.00,0.00,1.36,115.60,'2023-03-02 11:47:25','',''),(8012,'1','302','1',1,'Retail Sale Id 7784',1501.44,0.00,0.00,2.04,173.40,'2023-03-02 11:56:17','',''),(8013,'1','302','1',1,'Retail Sale Id 7785',2502.40,0.00,0.00,3.40,289.00,'2023-03-02 11:59:04','',''),(8014,'1','302','1',1,'Retail Sale Id 7786',4416.00,0.00,0.00,6.00,510.00,'2023-03-02 12:00:37','',''),(8015,'1','302','1',1,'Retail Sale Id 7787',2502.40,0.00,0.00,3.40,289.00,'2023-03-02 12:04:48','',''),(8016,'1','302','1',1,'Retail Sale Id 7788',7810.00,0.00,0.00,11.00,649.00,'2023-03-02 12:09:22','',''),(8017,'1','302','1',1,'Retail Sale Id 7789',2001.92,0.00,0.00,2.72,231.20,'2023-03-02 12:15:30','',''),(8018,'1','302','1',1,'Retail Sale Id 7790',2944.00,0.00,0.00,4.00,340.00,'2023-03-02 12:17:20','',''),(8019,'1','302','1',1,'Retail Sale Id 7791',17664.00,0.00,0.00,24.00,2040.00,'2023-03-02 12:23:36','',''),(8020,'1','302','1',1,'Retail Sale Id 7792',3680.00,0.00,0.00,5.00,425.00,'2023-03-02 12:25:16','',''),(8021,'1','302','1',1,'Retail Sale Id 7793',3680.00,0.00,0.00,5.00,425.00,'2023-03-02 12:27:41','',''),(8022,'1','302','1',1,'Retail Sale Id 7794',1000.96,0.00,0.00,1.36,115.60,'2023-03-02 12:35:31','',''),(8023,'1','302','1',1,'Retail Sale Id 7795',3002.88,0.00,0.00,4.08,346.80,'2023-03-02 12:38:22','',''),(8024,'1','302','1',1,'Retail Sale Id 7796',3680.00,0.00,0.00,5.00,425.00,'2023-03-02 12:43:40','',''),(8025,'1','302','1',1,'Retail Sale Id 7797',36800.00,0.00,0.00,50.00,4250.00,'2023-03-02 12:46:59','',''),(8026,'1','302','1',1,'Retail Sale Id 7798',2502.40,0.00,0.00,3.40,289.00,'2023-03-02 12:57:52','',''),(8027,'1','302','1',1,'Retail Sale Id 7799',3002.88,0.00,0.00,4.08,346.80,'2023-03-02 13:01:21','',''),(8028,'1','302','1',1,'Retail Sale Id 7800',3680.00,0.00,0.00,5.00,425.00,'2023-03-02 13:05:48','',''),(8029,'1','302','1',1,'Retail Sale Id 7801',4416.00,0.00,0.00,6.00,510.00,'2023-03-02 13:12:45','',''),(8030,'1','302','1',1,'Retail Sale Id 7802',500.48,0.00,0.00,0.68,57.80,'2023-03-02 13:19:16','',''),(8031,'1','302','1',1,'Retail Sale Id 7803',4997.44,0.00,0.00,6.79,577.15,'2023-03-02 13:21:07','',''),(8032,'1','302','1',1,'Retail Sale Id 7804',397.44,0.00,0.00,0.54,45.90,'2023-03-02 13:26:52','',''),(8033,'1','302','1',1,'Retail Sale Id 7805',9200.00,0.00,0.00,12.50,1062.50,'2023-03-02 13:31:14','',''),(8034,'1','302','1',1,'Retail Sale Id 7806',9200.00,0.00,0.00,12.50,1062.50,'2023-03-02 13:33:06','',''),(8035,'1','302','1',1,'Retail Sale Id 7807',4416.00,0.00,0.00,6.00,510.00,'2023-03-02 13:38:49','',''),(8036,'1','302','1',1,'Retail Sale Id 7808',11040.00,0.00,0.00,15.00,1275.00,'2023-03-02 13:49:50','',''),(8037,'1','302','1',1,'Retail Sale Id 7809',3680.00,0.00,0.00,5.00,425.00,'2023-03-02 14:06:06','',''),(8038,'1','302','1',1,'Retail Sale Id 7810',4416.00,0.00,0.00,6.00,510.00,'2023-03-02 14:14:50','',''),(8039,'1','302','1',1,'Retail Sale Id 7811',1472.00,0.00,0.00,2.00,170.00,'2023-03-02 14:16:18','',''),(8040,'1','302','1',1,'Retail Sale Id 7812',6999.36,0.00,0.00,9.51,808.35,'2023-03-02 14:18:19','',''),(8041,'1','302','1',1,'Retail Sale Id 7813',3002.88,0.00,0.00,4.08,346.80,'2023-03-02 14:21:58','',''),(8042,'1','302','1',1,'Retail Sale Id 7814',1000.96,0.00,0.00,1.36,115.60,'2023-03-02 14:23:02','',''),(8043,'1','302','1',1,'Retail Sale Id 7815',6498.88,0.00,0.00,8.83,750.55,'2023-03-02 14:24:33','',''),(8044,'1','302','1',1,'Retail Sale Id 7816',2208.00,0.00,0.00,3.00,255.00,'2023-03-02 14:30:49','',''),(8045,'1','302','1',1,'Retail Sale Id 7817',1803.20,0.00,0.00,2.45,208.25,'2023-03-02 14:32:07','',''),(8046,'1','302','1',1,'Retail Sale Id 7818',1501.44,0.00,0.00,2.04,173.40,'2023-03-02 14:34:33','',''),(8047,'1','302','1',1,'Retail Sale Id 7819',9200.00,0.00,0.00,12.50,1062.50,'2023-03-02 14:52:04','',''),(8048,'1','302','1',1,'Retail Sale Id 7820',2208.00,0.00,0.00,3.00,255.00,'2023-03-02 14:59:58','',''),(8049,'1','302','1',1,'Retail Sale Id 7821',3680.00,0.00,0.00,5.00,425.00,'2023-03-02 15:05:09','',''),(8050,'1','302','1',1,'Retail Sale Id 7822',5152.00,0.00,0.00,7.00,595.00,'2023-03-02 15:13:26','',''),(8051,'1','302','1',1,'Retail Sale Id 7823',80.96,0.00,0.00,0.11,9.35,'2023-03-02 15:20:07','',''),(8052,'1','302','1',1,'Retail Sale Id 7824',7360.00,0.00,0.00,10.00,850.00,'2023-03-02 15:29:00','',''),(8053,'1','302','1',1,'Retail Sale Id 7825',4416.00,0.00,0.00,6.00,510.00,'2023-03-02 15:34:22','',''),(8054,'1','302','1',1,'Retail Sale Id 7826',2208.00,0.00,0.00,3.00,255.00,'2023-03-02 15:48:19','',''),(8055,'1','302','1',1,'Retail Sale Id 7827',44469.12,0.00,0.00,60.42,5135.70,'2023-03-02 17:07:59','',''),(8056,'1','302','1',1,'Retail Sale Id 7828',3996.48,0.00,0.00,5.43,461.55,'2023-03-02 17:09:17','',''),(8057,'1','302','1',1,'Retail Sale Id 7829',5998.40,0.00,0.00,8.15,692.75,'2023-03-02 17:14:02','',''),(8058,'1','302','1',1,'Retail Sale Id 7830',4416.00,0.00,0.00,6.00,510.00,'2023-03-02 17:18:01','',''),(8059,'1','302','1',1,'Retail Sale Id 7831',1472.00,0.00,0.00,2.00,170.00,'2023-03-02 17:19:10','',''),(8060,'1','302','1',1,'Retail Sale Id 7832',3680.00,0.00,0.00,5.00,425.00,'2023-03-02 17:23:18','',''),(8061,'1','302','1',1,'Retail Sale Id 7833',4416.00,0.00,0.00,6.00,510.00,'2023-03-02 17:26:31','',''),(8062,'1','302','1',1,'Retail Sale Id 7834',9200.00,0.00,0.00,12.50,1062.50,'2023-03-02 17:29:08','',''),(8063,'1','302','1',1,'Retail Sale Id 7835',3680.00,0.00,0.00,5.00,425.00,'2023-03-02 17:30:35','',''),(8064,'1','302','1',1,'Retail Sale Id 7836',9200.00,0.00,0.00,12.50,1062.50,'2023-03-02 17:31:51','',''),(8065,'1','302','1',1,'Retail Sale Id 7839',4401.28,0.00,0.00,5.98,508.30,'2023-03-02 17:46:10','',''),(8066,'1','302','1',1,'Retail Sale Id 7840',743.36,0.00,0.00,1.01,85.85,'2023-03-02 17:59:19','',''),(8067,'1','302','1',1,'Retail Sale Id 7841',1472.00,0.00,0.00,2.00,170.00,'2023-03-02 18:00:19','',''),(8068,'1','302','1',1,'Retail Sale Id 7842',1472.00,0.00,0.00,2.00,170.00,'2023-03-02 18:03:35','',''),(8069,'1','302','1',1,'Retail Sale Id 7843',9200.00,0.00,0.00,12.50,1062.50,'2023-03-02 18:05:54','',''),(8070,'1','302','1',1,'Retail Sale Id 7844',5888.00,0.00,0.00,8.00,680.00,'2023-03-02 18:08:38','',''),(8071,'1','302','1',1,'Retail Sale Id 7845',5152.00,0.00,0.00,7.00,595.00,'2023-03-02 18:11:59','',''),(8072,'1','302','1',1,'Retail Sale Id 7846',35500.00,0.00,0.00,50.00,2950.00,'2023-03-02 18:14:34','',''),(8073,'1','302','1',1,'Retail Sale Id 7847',4416.00,0.00,0.00,6.00,510.00,'2023-03-02 18:15:15','',''),(8074,'1','302','1',1,'Retail Sale Id 7848',9940.00,0.00,0.00,14.00,826.00,'2023-03-02 18:19:03','',''),(8075,'1','302','1',1,'Retail Sale Id 7849',3503.36,0.00,0.00,4.76,404.60,'2023-03-02 18:19:47','',''),(8076,'1','302','1',1,'Retail Sale Id 7850',6999.36,0.00,0.00,9.51,808.35,'2023-03-02 18:21:12','',''),(8077,'1','302','1',1,'Retail Sale Id 7851',2208.00,0.00,0.00,3.00,255.00,'2023-03-02 18:22:35','',''),(8078,'1','302','1',1,'Retail Sale Id 7852',1501.44,0.00,0.00,2.04,173.40,'2023-03-02 18:27:01','',''),(8079,'1','302','1',1,'Retail Sale Id 7853',31999.70,0.00,0.00,45.07,2659.13,'2023-03-02 18:29:50','',''),(8080,'1','302','1',1,'Retail Sale Id 7854',9200.00,0.00,0.00,12.50,1062.50,'2023-03-02 18:31:05','',''),(8081,'1','302','1',1,'Retail Sale Id 7856',4416.00,0.00,0.00,6.00,510.00,'2023-03-02 18:33:30','',''),(8082,'1','302','1',1,'Retail Sale Id 7857',3680.00,0.00,0.00,5.00,425.00,'2023-03-02 18:34:51','',''),(8083,'1','302','1',1,'Retail Sale Id 7858',2899.84,0.00,0.00,3.94,334.90,'2023-03-02 18:35:35','',''),(8084,'1','302','1',1,'Retail Sale Id 7859',4416.00,0.00,0.00,6.00,510.00,'2023-03-02 18:36:32','',''),(8085,'1','302','1',1,'Retail Sale Id 7860',35500.00,0.00,0.00,50.00,2950.00,'2023-03-02 18:38:11','',''),(8086,'1','302','1',1,'Retail Sale Id 7861',1501.44,0.00,0.00,2.04,173.40,'2023-03-02 18:45:07','',''),(8087,'1','302','1',1,'Retail Sale Id 7862',2024.00,0.00,0.00,2.75,233.75,'2023-03-02 18:56:04','',''),(8088,'1','302','1',1,'Retail Sale Id 7863',2303.68,0.00,0.00,3.13,266.05,'2023-03-02 19:05:18','',''),(8089,'1','302','1',1,'Return of Retail Sale Id 7858',0.00,2899.84,3.94,0.00,-334.90,'2023-03-02 19:49:34','',''),(8090,'1','302','1',1,'Retail Sale Id 7864',257.60,0.00,0.00,0.35,29.75,'2023-03-02 19:51:12','',''),(8091,'1','302','1',1,'Retail Sale Id 7865',1472.00,0.00,0.00,2.00,170.00,'2023-03-03 07:31:55','',''),(8092,'1','302','1',1,'Retail Sale Id 7866',1000.96,0.00,0.00,1.36,115.60,'2023-03-03 07:36:41','',''),(8093,'1','302','1',1,'Retail Sale Id 7867',7360.00,0.00,0.00,10.00,850.00,'2023-03-03 07:47:05','',''),(8094,'1','302','1',1,'Retail Sale Id 7868',2208.00,0.00,0.00,3.00,255.00,'2023-03-03 07:57:05','',''),(8095,'1','302','1',1,'Retail Sale Id 7869',9200.00,0.00,0.00,12.50,1062.50,'2023-03-03 07:58:31','',''),(8096,'1','302','1',1,'Retail Sale Id 7870',2208.00,0.00,0.00,3.00,255.00,'2023-03-03 08:01:12','',''),(8097,'1','302','1',1,'Retail Sale Id 7870',5152.00,0.00,0.00,7.00,595.00,'2023-03-03 08:01:12','',''),(8098,'1','302','1',1,'Retail Sale Id 7871',4416.00,0.00,0.00,6.00,510.00,'2023-03-03 08:02:30','',''),(8099,'1','302','1',1,'Retail Sale Id 7872',4416.00,0.00,0.00,6.00,510.00,'2023-03-03 08:05:18','',''),(8100,'1','302','1',1,'Retail Sale Id 7873',3680.00,0.00,0.00,5.00,425.00,'2023-03-03 08:15:36','',''),(8101,'1','302','1',1,'Retail Sale Id 7873',4416.00,0.00,0.00,6.00,510.00,'2023-03-03 08:15:36','',''),(8102,'1','302','1',1,'Retail Sale Id 7874',2208.00,0.00,0.00,3.00,255.00,'2023-03-03 08:25:16','',''),(8103,'1','302','1',1,'Retail Sale Id 7874',2208.00,0.00,0.00,3.00,255.00,'2023-03-03 08:25:16','',''),(8104,'1','302','1',1,'Retail Sale Id 7875',2208.00,0.00,0.00,3.00,255.00,'2023-03-03 08:36:13','',''),(8105,'1','302','1',1,'Retail Sale Id 7875',5152.00,0.00,0.00,7.00,595.00,'2023-03-03 08:36:13','',''),(8106,'1','302','1',1,'Retail Sale Id 7876',3996.48,0.00,0.00,5.43,461.55,'2023-03-03 08:41:18','',''),(8107,'1','302','1',1,'Retail Sale Id 7877',4416.00,0.00,0.00,6.00,510.00,'2023-03-03 08:49:30','',''),(8108,'1','302','1',1,'Retail Sale Id 7878',2208.00,0.00,0.00,3.00,255.00,'2023-03-03 08:52:54','',''),(8109,'1','302','1',1,'Retail Sale Id 7879',1501.44,0.00,0.00,2.04,173.40,'2023-03-03 08:58:07','',''),(8110,'1','302','1',1,'Retail Sale Id 7880',3680.00,0.00,0.00,5.00,425.00,'2023-03-03 08:59:31','',''),(8111,'1','302','1',1,'Retail Sale Id 7881',4416.00,0.00,0.00,6.00,510.00,'2023-03-03 09:00:57','',''),(8112,'1','302','1',1,'Retail Sale Id 7882',5152.00,0.00,0.00,7.00,595.00,'2023-03-03 09:02:18','',''),(8113,'1','302','1',1,'Retail Sale Id 7883',9200.00,0.00,0.00,12.50,1062.50,'2023-03-03 09:04:49','',''),(8114,'1','302','1',1,'Retail Sale Id 7884',9200.00,0.00,0.00,12.50,1062.50,'2023-03-03 09:06:29','',''),(8115,'1','302','1',1,'Retail Sale Id 7885',2208.00,0.00,0.00,3.00,255.00,'2023-03-03 09:08:35','',''),(8116,'1','302','1',1,'Retail Sale Id 7886',9200.00,0.00,0.00,12.50,1062.50,'2023-03-03 09:09:47','',''),(8117,'1','302','1',1,'Retail Sale Id 7887',3002.88,0.00,0.00,4.08,346.80,'2023-03-03 09:11:09','',''),(8118,'1','302','1',1,'Retail Sale Id 7888',3002.88,0.00,0.00,4.08,346.80,'2023-03-03 09:19:46','',''),(8119,'1','302','1',1,'Retail Sale Id 7889',2208.00,0.00,0.00,3.00,255.00,'2023-03-03 09:22:33','',''),(8120,'1','302','1',1,'Retail Sale Id 7890',9200.00,0.00,0.00,12.50,1062.50,'2023-03-03 09:23:48','',''),(8121,'1','302','1',1,'Retail Sale Id 7891',1501.44,0.00,0.00,2.04,173.40,'2023-03-03 09:25:10','',''),(8122,'1','302','1',1,'Retail Sale Id 7892',4416.00,0.00,0.00,6.00,510.00,'2023-03-03 09:26:26','',''),(8123,'1','302','1',1,'Retail Sale Id 7893',4416.00,0.00,0.00,6.00,510.00,'2023-03-03 09:48:41','',''),(8124,'1','302','1',1,'Retail Sale Id 7894',1501.44,0.00,0.00,2.04,173.40,'2023-03-03 09:54:08','',''),(8125,'1','302','1',1,'Retail Sale Id 7895',4416.00,0.00,0.00,6.00,510.00,'2023-03-03 09:55:09','',''),(8126,'1','302','1',1,'Retail Sale Id 7896',2200.64,0.00,0.00,2.99,254.15,'2023-03-03 10:00:31','',''),(8127,'1','302','1',1,'Retail Sale Id 7897',71000.00,0.00,0.00,100.00,5900.00,'2023-03-03 10:02:55','',''),(8128,'1','302','1',1,'Retail Sale Id 7898',9200.00,0.00,0.00,12.50,1062.50,'2023-03-03 10:04:26','',''),(8129,'1','302','1',1,'Retail Sale Id 7899',9200.00,0.00,0.00,12.50,1062.50,'2023-03-03 10:05:53','',''),(8130,'1','302','1',1,'Retail Sale Id 7900',2944.00,0.00,0.00,4.00,340.00,'2023-03-03 10:14:53','',''),(8131,'1','302','1',1,'Retail Sale Id 7901',3503.36,0.00,0.00,4.76,404.60,'2023-03-03 10:20:24','',''),(8132,'1','302','1',1,'Retail Sale Id 7902',5888.00,0.00,0.00,8.00,680.00,'2023-03-03 10:21:59','',''),(8133,'1','302','1',1,'Retail Sale Id 7903',3680.00,0.00,0.00,5.00,425.00,'2023-03-03 10:28:17','',''),(8134,'1','302','1',1,'Retail Sale Id 7904',9200.00,0.00,0.00,12.50,1062.50,'2023-03-03 10:29:35','',''),(8135,'1','302','1',1,'Retail Sale Id 7905',9200.00,0.00,0.00,12.50,1062.50,'2023-03-03 10:34:32','',''),(8136,'1','302','1',1,'Retail Sale Id 7906',9200.00,0.00,0.00,12.50,1062.50,'2023-03-03 10:37:09','',''),(8137,'1','302','1',1,'Retail Sale Id 7907',17750.00,0.00,0.00,25.00,1475.00,'2023-03-03 10:44:19','',''),(8138,'1','302','1',1,'Retail Sale Id 7908',2208.00,0.00,0.00,3.00,255.00,'2023-03-03 10:45:32','',''),(8139,'1','302','1',1,'Retail Sale Id 7910',2001.92,0.00,0.00,2.72,231.20,'2023-03-03 10:47:17','',''),(8140,'1','302','1',1,'Retail Sale Id 7911',3680.00,0.00,0.00,5.00,425.00,'2023-03-03 10:48:35','',''),(8141,'1','302','1',1,'Retail Sale Id 7912',736.00,0.00,0.00,1.00,85.00,'2023-03-03 10:50:21','',''),(8142,'1','302','1',1,'Retail Sale Id 7913',2001.92,0.00,0.00,2.72,231.20,'2023-03-03 10:51:14','',''),(8143,'1','302','1',1,'Retail Sale Id 7914',4416.00,0.00,0.00,6.00,510.00,'2023-03-03 10:53:23','',''),(8144,'1','302','1',1,'Retail Sale Id 7915',2502.40,0.00,0.00,3.40,289.00,'2023-03-03 10:57:17','',''),(8145,'1','302','1',1,'Retail Sale Id 7916',736.00,0.00,0.00,1.00,85.00,'2023-03-03 11:01:23','',''),(8146,'1','302','1',1,'Retail Sale Id 7916',7360.00,0.00,0.00,10.00,850.00,'2023-03-03 11:01:23','',''),(8147,'1','302','1',1,'Retail Sale Id 7917',1472.00,0.00,0.00,2.00,170.00,'2023-03-03 11:06:07','',''),(8148,'1','302','1',1,'Retail Sale Id 7918',4416.00,0.00,0.00,6.00,510.00,'2023-03-03 11:07:49','',''),(8149,'1','302','1',1,'Retail Sale Id 7919',3680.00,0.00,0.00,5.00,425.00,'2023-03-03 11:15:40','',''),(8150,'1','302','1',1,'Retail Sale Id 7920',6999.36,0.00,0.00,9.51,808.35,'2023-03-03 11:18:50','',''),(8151,'1','302','1',1,'Retail Sale Id 7921',3503.36,0.00,0.00,4.76,404.60,'2023-03-03 11:21:50','',''),(8152,'1','302','1',1,'Retail Sale Id 7922',4416.00,0.00,0.00,6.00,510.00,'2023-03-03 11:22:50','',''),(8153,'1','302','1',1,'Retail Sale Id 7923',2208.00,0.00,0.00,3.00,255.00,'2023-03-03 11:24:00','',''),(8154,'1','302','1',1,'Retail Sale Id 7924',4416.00,0.00,0.00,6.00,510.00,'2023-03-03 11:25:27','',''),(8155,'1','302','1',1,'Retail Sale Id 7925',9200.00,0.00,0.00,12.50,1062.50,'2023-03-03 11:38:02','',''),(8156,'1','302','1',1,'Retail Sale Id 7926',9200.00,0.00,0.00,12.50,1062.50,'2023-03-03 11:39:56','',''),(8157,'1','302','1',1,'Retail Sale Id 7927',2208.00,0.00,0.00,3.00,255.00,'2023-03-03 11:57:25','',''),(8158,'1','302','1',1,'Retail Sale Id 7928',2001.92,0.00,0.00,2.72,231.20,'2023-03-03 12:13:39','',''),(8159,'1','302','1',1,'Retail Sale Id 7929',802.24,0.00,0.00,1.09,92.65,'2023-03-03 12:17:42','',''),(8160,'1','302','1',1,'Retail Sale Id 7930',7360.00,0.00,0.00,10.00,850.00,'2023-03-03 12:19:33','',''),(8161,'1','302','1',1,'Retail Sale Id 7931',3996.48,0.00,0.00,5.43,461.55,'2023-03-03 12:20:45','',''),(8162,'1','302','1',1,'Retail Sale Id 7932',1000.96,0.00,0.00,1.36,115.60,'2023-03-03 12:33:39','',''),(8163,'1','302','1',1,'Retail Sale Id 7933',2208.00,0.00,0.00,3.00,255.00,'2023-03-03 12:52:34','',''),(8164,'1','302','1',1,'Retail Sale Id 7934',4416.00,0.00,0.00,6.00,510.00,'2023-03-03 13:04:18','',''),(8165,'1','302','1',1,'Retail Sale Id 7935',3503.36,0.00,0.00,4.76,404.60,'2023-03-03 13:54:50','',''),(8166,'1','302','1',1,'Retail Sale Id 7936',1472.00,0.00,0.00,2.00,170.00,'2023-03-03 14:06:47','',''),(8167,'1','302','1',1,'Retail Sale Id 7939',4416.00,0.00,0.00,6.00,510.00,'2023-03-03 14:28:29','',''),(8168,'1','302','1',1,'Retail Sale Id 7940',2944.00,0.00,0.00,4.00,340.00,'2023-03-03 14:46:20','',''),(8169,'1','302','1',1,'Retail Sale Id 7941',9200.00,0.00,0.00,12.50,1062.50,'2023-03-03 14:47:51','',''),(8170,'1','302','1',1,'Retail Sale Id 7943',10650.00,0.00,0.00,15.00,885.00,'2023-03-03 15:12:36','',''),(8171,'1','302','1',1,'Retail Sale Id 7944',2576.00,0.00,0.00,3.50,297.50,'2023-03-03 15:16:58','',''),(8172,'1','302','1',1,'Retail Sale Id 7945',9200.00,0.00,0.00,12.50,1062.50,'2023-03-03 15:17:47','',''),(8173,'1','302','1',1,'Retail Sale Id 7946',2001.92,0.00,0.00,2.72,231.20,'2023-03-03 15:22:21','',''),(8174,'1','302','1',1,'Retail Sale Id 7947',3503.36,0.00,0.00,4.76,404.60,'2023-03-03 15:24:27','',''),(8175,'1','302','1',1,'Retail Sale Id 7948',1472.00,0.00,0.00,2.00,170.00,'2023-03-03 15:36:48','',''),(8176,'1','302','1',1,'Retail Sale Id 7949',301.76,0.00,0.00,0.41,34.85,'2023-03-03 15:44:47','',''),(8177,'1','302','1',1,'Retail Sale Id 7950',2001.92,0.00,0.00,2.72,231.20,'2023-03-03 15:49:52','',''),(8178,'1','302','1',1,'Retail Sale Id 7951',500.48,0.00,0.00,0.68,57.80,'2023-03-03 15:51:29','',''),(8179,'1','302','1',1,'Retail Sale Id 7952',9200.00,0.00,0.00,12.50,1062.50,'2023-03-03 15:53:46','',''),(8180,'1','302','1',1,'Retail Sale Id 7953',1501.44,0.00,0.00,2.04,173.40,'2023-03-03 15:58:19','',''),(8181,'1','302','1',1,'Retail Sale Id 7954',1000.96,0.00,0.00,1.36,115.60,'2023-03-03 16:01:32','',''),(8182,'1','302','1',1,'Retail Sale Id 7955',3680.00,0.00,0.00,5.00,425.00,'2023-03-03 16:03:22','',''),(8183,'1','302','1',1,'Retail Sale Id 7956',3550.00,0.00,0.00,5.00,295.00,'2023-03-03 16:04:59','',''),(8184,'1','302','1',1,'Retail Sale Id 7957',4600.00,0.00,0.00,6.25,531.25,'2023-03-03 16:06:18','',''),(8185,'1','302','1',1,'Retail Sale Id 7958',5152.00,0.00,0.00,7.00,595.00,'2023-03-03 16:39:55','',''),(8186,'1','302','1',1,'Retail Sale Id 7958',5152.00,0.00,0.00,7.00,595.00,'2023-03-03 16:39:55','',''),(8187,'1','302','1',1,'Retail Sale Id 7959',2208.00,0.00,0.00,3.00,255.00,'2023-03-03 16:43:47','',''),(8188,'1','302','1',1,'Retail Sale Id 7960',4416.00,0.00,0.00,6.00,510.00,'2023-03-03 16:45:33','',''),(8189,'1','302','1',1,'Retail Sale Id 7961',2208.00,0.00,0.00,3.00,255.00,'2023-03-03 16:47:33','',''),(8190,'1','302','1',1,'Retail Sale Id 7962',9200.00,0.00,0.00,12.50,1062.50,'2023-03-03 16:51:42','',''),(8191,'1','302','1',1,'Retail Sale Id 7963',4496.96,0.00,0.00,6.11,519.35,'2023-03-03 16:52:58','',''),(8192,'1','302','1',1,'Retail Sale Id 7964',9200.00,0.00,0.00,12.50,1062.50,'2023-03-03 16:58:21','',''),(8193,'1','302','1',1,'Retail Sale Id 7965',4416.00,0.00,0.00,6.00,510.00,'2023-03-03 17:14:47','',''),(8194,'1','302','1',1,'Retail Sale Id 7966',750.72,0.00,0.00,1.02,86.70,'2023-03-03 17:17:00','',''),(8195,'1','302','1',1,'Retail Sale Id 7967',4416.00,0.00,0.00,6.00,510.00,'2023-03-03 17:19:02','',''),(8196,'1','302','1',1,'Retail Sale Id 7968',2208.00,0.00,0.00,3.00,255.00,'2023-03-03 17:21:24','',''),(8197,'1','302','1',1,'Retail Sale Id 7969',3002.88,0.00,0.00,4.08,346.80,'2023-03-03 17:26:38','',''),(8198,'1','302','1',1,'Retail Sale Id 7970',1398.40,0.00,0.00,1.90,161.50,'2023-03-03 17:27:43','',''),(8199,'1','302','1',1,'Retail Sale Id 7971',1000.96,0.00,0.00,1.36,115.60,'2023-03-03 17:29:40','',''),(8200,'1','302','1',1,'Retail Sale Id 7973',4416.00,0.00,0.00,6.00,510.00,'2023-03-03 17:38:06','',''),(8201,'1','302','1',1,'Retail Sale Id 7974',2001.92,0.00,0.00,2.72,231.20,'2023-03-03 17:40:12','',''),(8202,'1','302','1',1,'Retail Sale Id 7975',2208.00,0.00,0.00,3.00,255.00,'2023-03-03 17:43:26','',''),(8203,'1','302','1',1,'Retail Sale Id 7977',7360.00,0.00,0.00,10.00,850.00,'2023-03-03 17:51:33','',''),(8204,'1','302','1',1,'Retail Sale Id 7978',9200.00,0.00,0.00,12.50,1062.50,'2023-03-03 17:54:18','',''),(8205,'1','302','1',1,'Retail Sale Id 7979',3680.00,0.00,0.00,5.00,425.00,'2023-03-03 17:56:24','',''),(8206,'1','302','1',1,'Retail Sale Id 7980',7360.00,0.00,0.00,10.00,850.00,'2023-03-03 17:58:08','',''),(8207,'1','302','1',1,'Retail Sale Id 7981',1501.44,0.00,0.00,2.04,173.40,'2023-03-03 18:00:09','',''),(8208,'1','302','1',1,'Retail Sale Id 7982',736.00,0.00,0.00,1.00,85.00,'2023-03-03 18:04:45','',''),(8209,'1','302','1',1,'Retail Sale Id 7983',500.48,0.00,0.00,0.68,57.80,'2023-03-03 18:06:30','',''),(8210,'1','302','1',1,'Retail Sale Id 7984',4496.96,0.00,0.00,6.11,519.35,'2023-03-03 18:10:11','',''),(8211,'1','302','1',1,'Retail Sale Id 7985',7360.00,0.00,0.00,10.00,850.00,'2023-03-03 18:17:57','',''),(8212,'1','302','1',1,'Retail Sale Id 7987',2399.36,0.00,0.00,3.26,277.10,'2023-03-03 18:24:36','',''),(8213,'1','302','1',1,'Retail Sale Id 7988',2944.00,0.00,0.00,4.00,340.00,'2023-03-03 18:31:50','',''),(8214,'1','302','1',1,'Retail Sale Id 7989',9001.28,0.00,0.00,12.23,1039.55,'2023-03-03 18:33:53','',''),(8215,'1','302','1',1,'Retail Sale Id 7990',4997.44,0.00,0.00,6.79,577.15,'2023-03-03 18:35:13','',''),(8216,'1','302','1',1,'Retail Sale Id 7991',1501.44,0.00,0.00,2.04,173.40,'2023-03-03 18:36:28','',''),(8217,'1','302','1',1,'Retail Sale Id 7992',2208.00,0.00,0.00,3.00,255.00,'2023-03-03 18:39:02','',''),(8218,'1','302','1',1,'Retail Sale Id 7992',9200.00,0.00,0.00,12.50,1062.50,'2023-03-03 18:39:02','',''),(8219,'1','302','1',1,'Return of Retail Sale Id 7991',0.00,1501.44,2.04,0.00,-173.40,'2023-03-03 19:29:03','',''),(8220,'1','302','1',1,'Retail Sale Id 7993',1229.12,0.00,0.00,1.67,141.95,'2023-03-03 19:29:39','',''),(8221,'1','302','1',1,'Retail Sale Id 7994',3002.88,0.00,0.00,4.08,346.80,'2023-03-04 08:29:47','',''),(8222,'1','302','1',1,'Retail Sale Id 7995',4997.44,0.00,0.00,6.79,577.15,'2023-03-04 08:30:44','',''),(8223,'1','302','1',1,'Retail Sale Id 7996',46000.00,0.00,0.00,62.50,5312.50,'2023-03-04 08:32:08','',''),(8224,'1','302','1',1,'Retail Sale Id 7997',4416.00,0.00,0.00,6.00,510.00,'2023-03-04 08:33:57','',''),(8225,'1','302','1',1,'Retail Sale Id 7999',2208.00,0.00,0.00,3.00,255.00,'2023-03-04 08:35:01','',''),(8226,'1','302','1',1,'Retail Sale Id 8000',2701.12,0.00,0.00,3.67,311.95,'2023-03-04 08:39:57','',''),(8227,'1','302','1',1,'Retail Sale Id 8001',1803.20,0.00,0.00,2.45,208.25,'2023-03-04 08:42:37','',''),(8228,'1','302','1',1,'Retail Sale Id 8002',3002.88,0.00,0.00,4.08,346.80,'2023-03-04 08:43:53','',''),(8229,'1','302','1',1,'Retail Sale Id 8003',9200.00,0.00,0.00,12.50,1062.50,'2023-03-04 08:47:59','',''),(8230,'1','302','1',1,'Retail Sale Id 8004',2001.92,0.00,0.00,2.72,231.20,'2023-03-04 08:52:06','',''),(8231,'1','302','1',1,'Retail Sale Id 8005',3680.00,0.00,0.00,5.00,425.00,'2023-03-04 08:55:35','',''),(8232,'1','302','1',1,'Retail Sale Id 8006',4423.36,0.00,0.00,6.01,510.85,'2023-03-04 09:01:57','',''),(8233,'1','302','1',1,'Retail Sale Id 8007',7360.00,0.00,0.00,10.00,850.00,'2023-03-04 09:09:35','',''),(8234,'1','302','1',1,'Retail Sale Id 8008',4416.00,0.00,0.00,6.00,510.00,'2023-03-04 09:10:53','',''),(8235,'1','302','1',1,'Retail Sale Id 8009',802.24,0.00,0.00,1.09,92.65,'2023-03-04 09:13:26','',''),(8236,'1','302','1',1,'Retail Sale Id 8010',4416.00,0.00,0.00,6.00,510.00,'2023-03-04 09:21:32','',''),(8237,'1','302','1',1,'Retail Sale Id 8011',3996.48,0.00,0.00,5.43,461.55,'2023-03-04 09:25:02','',''),(8238,'1','302','1',1,'Retail Sale Id 8012',3680.00,0.00,0.00,5.00,425.00,'2023-03-04 09:26:21','',''),(8239,'1','302','1',1,'Retail Sale Id 8013',4416.00,0.00,0.00,6.00,510.00,'2023-03-04 09:27:38','',''),(8240,'1','302','1',1,'Retail Sale Id 8014',2208.00,0.00,0.00,3.00,255.00,'2023-03-04 09:29:25','',''),(8241,'1','302','1',1,'Retail Sale Id 8015',3680.00,0.00,0.00,5.00,425.00,'2023-03-04 09:30:56','',''),(8242,'1','302','1',1,'Retail Sale Id 8018',4496.96,0.00,0.00,6.11,519.35,'2023-03-04 09:36:48','',''),(8243,'1','302','1',1,'Retail Sale Id 8019',9200.00,0.00,0.00,12.50,1062.50,'2023-03-04 09:38:13','',''),(8244,'1','302','1',1,'Retail Sale Id 8020',15456.00,0.00,0.00,21.00,1785.00,'2023-03-04 09:41:39','',''),(8245,'1','302','1',1,'Retail Sale Id 8021',2208.00,0.00,0.00,3.00,255.00,'2023-03-04 09:43:03','',''),(8246,'1','302','1',1,'Retail Sale Id 8022',4416.00,0.00,0.00,6.00,510.00,'2023-03-04 09:44:38','',''),(8247,'1','302','1',1,'Retail Sale Id 8023',9200.00,0.00,0.00,12.50,1062.50,'2023-03-04 09:54:38','',''),(8248,'1','302','1',1,'Retail Sale Id 8024',1501.44,0.00,0.00,2.04,173.40,'2023-03-04 09:56:26','',''),(8249,'1','302','1',1,'Retail Sale Id 8025',3503.36,0.00,0.00,4.76,404.60,'2023-03-04 09:58:45','',''),(8250,'1','302','1',1,'Retail Sale Id 8026',4997.44,0.00,0.00,6.79,577.15,'2023-03-04 10:00:06','',''),(8251,'1','302','1',1,'Retail Sale Id 8027',3002.88,0.00,0.00,4.08,346.80,'2023-03-04 10:02:48','',''),(8252,'1','302','1',1,'Retail Sale Id 8028',1472.00,0.00,0.00,2.00,170.00,'2023-03-04 10:04:02','',''),(8253,'1','302','1',1,'Retail Sale Id 8029',4416.00,0.00,0.00,6.00,510.00,'2023-03-04 10:06:19','',''),(8254,'1','302','1',1,'Retail Sale Id 8030',5888.00,0.00,0.00,8.00,680.00,'2023-03-04 10:07:35','',''),(8255,'1','302','1',1,'Retail Sale Id 8031',12144.00,0.00,0.00,16.50,1402.50,'2023-03-04 10:09:31','',''),(8256,'1','302','1',1,'Retail Sale Id 8032',9200.00,0.00,0.00,12.50,1062.50,'2023-03-04 10:13:33','',''),(8257,'1','302','1',1,'Retail Sale Id 8033',3680.00,0.00,0.00,5.00,425.00,'2023-03-04 10:16:44','',''),(8258,'1','302','1',1,'Retail Sale Id 8034',3680.00,0.00,0.00,5.00,425.00,'2023-03-04 10:19:43','',''),(8259,'1','302','1',1,'Retail Sale Id 8035',2208.00,0.00,0.00,3.00,255.00,'2023-03-04 10:22:49','',''),(8260,'1','302','1',1,'Retail Sale Id 8036',4416.00,0.00,0.00,6.00,510.00,'2023-03-04 10:28:24','',''),(8261,'1','302','1',1,'Retail Sale Id 8037',4416.00,0.00,0.00,6.00,510.00,'2023-03-04 10:32:19','',''),(8262,'1','302','1',1,'Retail Sale Id 8038',9200.00,0.00,0.00,12.50,1062.50,'2023-03-04 10:34:21','',''),(8263,'1','302','1',1,'Retail Sale Id 8039',3680.00,0.00,0.00,5.00,425.00,'2023-03-04 10:45:20','',''),(8264,'1','302','1',1,'Retail Sale Id 8040',3996.48,0.00,0.00,5.43,461.55,'2023-03-04 10:51:17','',''),(8265,'1','302','1',1,'Retail Sale Id 8041',9200.00,0.00,0.00,12.50,1062.50,'2023-03-04 10:52:53','',''),(8266,'1','302','1',1,'Retail Sale Id 8042',9200.00,0.00,0.00,12.50,1062.50,'2023-03-04 10:58:12','',''),(8267,'1','302','1',1,'Retail Sale Id 8043',3503.36,0.00,0.00,4.76,404.60,'2023-03-04 11:03:43','',''),(8268,'1','302','1',1,'Retail Sale Id 8044',4416.00,0.00,0.00,6.00,510.00,'2023-03-04 11:06:20','',''),(8269,'1','302','1',1,'Retail Sale Id 8044',4416.00,0.00,0.00,6.00,510.00,'2023-03-04 11:06:20','',''),(8270,'1','302','1',1,'Retail Sale Id 8045',4496.96,0.00,0.00,6.11,519.35,'2023-03-04 11:10:47','',''),(8271,'1','302','1',1,'Retail Sale Id 8046',2001.92,0.00,0.00,2.72,231.20,'2023-03-04 11:13:34','',''),(8272,'1','302','1',1,'Retail Sale Id 8048',4416.00,0.00,0.00,6.00,510.00,'2023-03-04 11:19:20','',''),(8273,'1','302','1',1,'Retail Sale Id 8049',8000.32,0.00,0.00,10.87,923.95,'2023-03-04 11:21:01','',''),(8274,'1','302','1',1,'Retail Sale Id 8050',3680.00,0.00,0.00,5.00,425.00,'2023-03-04 11:23:28','',''),(8275,'1','302','1',1,'Retail Sale Id 8051',4997.44,0.00,0.00,6.79,577.15,'2023-03-04 11:42:52','',''),(8276,'1','302','1',1,'Retail Sale Id 8052',2944.00,0.00,0.00,4.00,340.00,'2023-03-04 11:44:04','',''),(8277,'1','302','1',1,'Retail Sale Id 8053',2944.00,0.00,0.00,4.00,340.00,'2023-03-04 11:46:27','',''),(8278,'1','302','1',1,'Retail Sale Id 8054',500.48,0.00,0.00,0.68,57.80,'2023-03-04 11:49:31','',''),(8279,'1','302','1',1,'Retail Sale Id 8055',35500.00,0.00,0.00,50.00,2950.00,'2023-03-04 11:50:32','',''),(8280,'1','302','1',1,'Retail Sale Id 8056',9200.00,0.00,0.00,12.50,1062.50,'2023-03-04 11:51:50','',''),(8281,'1','302','1',1,'Retail Sale Id 8057',9001.28,0.00,0.00,12.23,1039.55,'2023-03-04 11:53:38','',''),(8282,'1','302','1',1,'Retail Sale Id 8058',2001.92,0.00,0.00,2.72,231.20,'2023-03-04 11:54:33','',''),(8283,'1','302','1',1,'Retail Sale Id 8059',2502.40,0.00,0.00,3.40,289.00,'2023-03-04 11:56:24','',''),(8284,'1','302','1',1,'Retail Sale Id 8061',3996.48,0.00,0.00,5.43,461.55,'2023-03-04 12:08:51','',''),(8285,'1','302','1',1,'Retail Sale Id 8062',1391.04,0.00,0.00,1.89,160.65,'2023-03-04 12:10:59','',''),(8286,'1','302','1',1,'Retail Sale Id 8063',736.00,0.00,0.00,1.00,85.00,'2023-03-04 12:13:19','',''),(8287,'1','302','1',1,'Retail Sale Id 8064',2208.00,0.00,0.00,3.00,255.00,'2023-03-04 12:14:19','',''),(8288,'1','302','1',1,'Retail Sale Id 8065',4416.00,0.00,0.00,6.00,510.00,'2023-03-04 12:15:15','',''),(8289,'1','302','1',1,'Retail Sale Id 8066',1472.00,0.00,0.00,2.00,170.00,'2023-03-04 12:25:56','',''),(8290,'1','302','1',1,'Retail Sale Id 8067',2944.00,0.00,0.00,4.00,340.00,'2023-03-04 12:27:03','',''),(8291,'1','302','1',1,'Retail Sale Id 8068',10672.00,0.00,0.00,14.50,1232.50,'2023-03-04 12:35:43','',''),(8292,'1','302','1',1,'Retail Sale Id 8070',3680.00,0.00,0.00,5.00,425.00,'2023-03-04 12:38:07','',''),(8293,'1','302','1',1,'Retail Sale Id 8071',2502.40,0.00,0.00,3.40,289.00,'2023-03-04 12:38:54','',''),(8294,'1','302','1',1,'Retail Sale Id 8072',4416.00,0.00,0.00,6.00,510.00,'2023-03-04 12:45:32','',''),(8295,'1','302','1',1,'Retail Sale Id 8073',2303.68,0.00,0.00,3.13,266.05,'2023-03-04 12:46:37','',''),(8296,'1','302','1',1,'Retail Sale Id 8074',7360.00,0.00,0.00,10.00,850.00,'2023-03-04 12:49:00','',''),(8297,'1','302','1',1,'Retail Sale Id 8075',14200.00,0.00,0.00,20.00,1180.00,'2023-03-04 12:50:33','',''),(8298,'1','302','1',1,'Retail Sale Id 8076',2001.92,0.00,0.00,2.72,231.20,'2023-03-04 12:52:50','',''),(8299,'1','302','1',1,'Retail Sale Id 8077',1199.68,0.00,0.00,1.63,138.55,'2023-03-04 13:00:28','',''),(8300,'1','302','1',1,'Retail Sale Id 8078',11040.00,0.00,0.00,15.00,1275.00,'2023-03-04 13:03:45','',''),(8301,'1','302','1',1,'Retail Sale Id 8079',4496.96,0.00,0.00,6.11,519.35,'2023-03-04 13:05:12','',''),(8302,'1','302','1',1,'Retail Sale Id 8080',35500.00,0.00,0.00,50.00,2950.00,'2023-03-04 13:06:06','',''),(8303,'1','302','1',1,'Retail Sale Id 8081',2001.92,0.00,0.00,2.72,231.20,'2023-03-04 13:09:05','',''),(8304,'1','302','1',1,'Retail Sale Id 8082',3680.00,0.00,0.00,5.00,425.00,'2023-03-04 13:10:37','',''),(8305,'1','302','1',1,'Retail Sale Id 8083',2208.00,0.00,0.00,3.00,255.00,'2023-03-04 13:20:19','',''),(8306,'1','302','1',1,'Retail Sale Id 8084',4416.00,0.00,0.00,6.00,510.00,'2023-03-04 13:21:48','',''),(8307,'1','302','1',1,'Retail Sale Id 8085',802.24,0.00,0.00,1.09,92.65,'2023-03-04 13:36:10','',''),(8308,'1','302','1',1,'Retail Sale Id 8087',5998.40,0.00,0.00,8.15,692.75,'2023-03-04 13:52:52','',''),(8309,'1','302','1',1,'Retail Sale Id 8088',5998.40,0.00,0.00,8.15,692.75,'2023-03-04 13:54:24','',''),(8310,'1','302','1',1,'Retail Sale Id 8089',4997.44,0.00,0.00,6.79,577.15,'2023-03-04 13:57:05','',''),(8311,'1','302','1',1,'Retail Sale Id 8090',2208.00,0.00,0.00,3.00,255.00,'2023-03-04 13:59:03','',''),(8312,'1','302','1',1,'Retail Sale Id 8091',2502.40,0.00,0.00,3.40,289.00,'2023-03-04 14:09:35','',''),(8313,'1','302','1',1,'Retail Sale Id 8092',9200.00,0.00,0.00,12.50,1062.50,'2023-03-04 14:12:45','',''),(8314,'1','302','1',1,'Retail Sale Id 8093',3002.88,0.00,0.00,4.08,346.80,'2023-03-04 14:15:10','',''),(8315,'1','302','1',1,'Retail Sale Id 8094',1000.96,0.00,0.00,1.36,115.60,'2023-03-04 14:16:09','',''),(8316,'1','302','1',1,'Retail Sale Id 8095',3201.60,0.00,0.00,4.35,369.75,'2023-03-04 14:36:55','',''),(8317,'1','302','1',1,'Retail Sale Id 8096',9200.00,0.00,0.00,12.50,1062.50,'2023-03-04 14:38:09','',''),(8318,'1','302','1',1,'Retail Sale Id 8097',9200.00,0.00,0.00,12.50,1062.50,'2023-03-04 14:49:42','',''),(8319,'1','302','1',1,'Retail Sale Id 8099',9200.00,0.00,0.00,12.50,1062.50,'2023-03-04 15:02:42','',''),(8320,'1','302','1',1,'Retail Sale Id 8100',2208.00,0.00,0.00,3.00,255.00,'2023-03-04 15:03:38','',''),(8321,'1','302','1',1,'Retail Sale Id 8101',3002.88,0.00,0.00,4.08,346.80,'2023-03-04 15:16:50','',''),(8322,'1','302','1',1,'Retail Sale Id 8102',1000.96,0.00,0.00,1.36,115.60,'2023-03-04 15:18:24','',''),(8323,'1','302','1',1,'Retail Sale Id 8103',13616.00,0.00,0.00,18.50,1572.50,'2023-03-04 15:19:42','',''),(8324,'1','302','1',1,'Retail Sale Id 8104',7360.00,0.00,0.00,10.00,850.00,'2023-03-04 16:04:51','',''),(8325,'1','302','1',1,'Retail Sale Id 8105',4416.00,0.00,0.00,6.00,510.00,'2023-03-04 16:12:58','',''),(8326,'1','302','1',1,'Retail Sale Id 8106',2502.40,0.00,0.00,3.40,289.00,'2023-03-04 16:13:55','',''),(8327,'1','302','1',1,'Retail Sale Id 8107',9126.40,0.00,0.00,12.40,1054.00,'2023-03-04 16:17:18','',''),(8328,'1','302','1',1,'Retail Sale Id 8108',2208.00,0.00,0.00,3.00,255.00,'2023-03-04 16:30:30','',''),(8329,'1','302','1',1,'Retail Sale Id 8109',4416.00,0.00,0.00,6.00,510.00,'2023-03-04 16:33:36','',''),(8330,'1','302','1',1,'Retail Sale Id 8110',4416.00,0.00,0.00,6.00,510.00,'2023-03-04 16:36:59','',''),(8331,'1','302','1',1,'Retail Sale Id 8111',12202.88,0.00,0.00,16.58,1409.30,'2023-03-04 16:43:20','',''),(8332,'1','302','1',1,'Retail Sale Id 8112',9200.00,0.00,0.00,12.50,1062.50,'2023-03-04 16:52:43','',''),(8333,'1','302','1',1,'Retail Sale Id 8113',5998.40,0.00,0.00,8.15,692.75,'2023-03-04 17:10:20','',''),(8334,'1','302','1',1,'Retail Sale Id 8114',9200.00,0.00,0.00,12.50,1062.50,'2023-03-04 17:13:03','',''),(8335,'1','302','1',1,'Retail Sale Id 8115',17750.00,0.00,0.00,25.00,1475.00,'2023-03-04 17:15:25','',''),(8336,'1','302','1',1,'Retail Sale Id 8116',2001.92,0.00,0.00,2.72,231.20,'2023-03-04 17:16:48','',''),(8337,'1','302','1',1,'Retail Sale Id 8117',736.00,0.00,0.00,1.00,85.00,'2023-03-04 17:20:18','',''),(8338,'1','302','1',1,'Retail Sale Id 8118',1000.96,0.00,0.00,1.36,115.60,'2023-03-04 17:25:14','',''),(8339,'1','302','1',1,'Retail Sale Id 8119',3996.48,0.00,0.00,5.43,461.55,'2023-03-04 17:31:26','',''),(8340,'1','302','1',1,'Retail Sale Id 8121',2944.00,0.00,0.00,4.00,340.00,'2023-03-04 17:39:00','',''),(8341,'1','302','1',1,'Retail Sale Id 8122',3996.48,0.00,0.00,5.43,461.55,'2023-03-04 17:40:46','',''),(8342,'1','302','1',1,'Retail Sale Id 8123',699.20,0.00,0.00,0.95,80.75,'2023-03-04 17:43:05','',''),(8343,'1','302','1',1,'Retail Sale Id 8124',736.00,0.00,0.00,1.00,85.00,'2023-03-04 17:44:05','',''),(8344,'1','302','1',1,'Retail Sale Id 8125',3680.00,0.00,0.00,5.00,425.00,'2023-03-04 17:52:26','',''),(8345,'1','302','1',1,'Retail Sale Id 8126',7360.00,0.00,0.00,10.00,850.00,'2023-03-04 17:53:49','',''),(8346,'1','302','1',1,'Retail Sale Id 8127',2200.64,0.00,0.00,2.99,254.15,'2023-03-04 17:58:49','',''),(8347,'1','302','1',1,'Retail Sale Id 8128',500.48,0.00,0.00,0.68,57.80,'2023-03-04 18:08:11','',''),(8348,'1','302','1',1,'Retail Sale Id 8129',16928.00,0.00,0.00,23.00,1955.00,'2023-03-04 18:12:11','',''),(8349,'1','302','1',1,'Retail Sale Id 8130',3002.88,0.00,0.00,4.08,346.80,'2023-03-04 18:12:59','',''),(8350,'1','302','1',1,'Retail Sale Id 8131',4416.00,0.00,0.00,6.00,510.00,'2023-03-04 18:15:38','',''),(8351,'1','302','1',1,'Retail Sale Id 8132',5799.68,0.00,0.00,7.88,669.80,'2023-03-04 18:22:04','',''),(8352,'1','302','1',1,'Retail Sale Id 8133',9200.00,0.00,0.00,12.50,1062.50,'2023-03-04 18:27:58','',''),(8353,'1','302','1',1,'Retail Sale Id 8134',301.76,0.00,0.00,0.41,34.85,'2023-03-04 18:39:55','',''),(8354,'1','302','1',1,'Retail Sale Id 8135',4416.00,0.00,0.00,6.00,510.00,'2023-03-04 18:41:03','',''),(8355,'1','302','1',1,'Retail Sale Id 8136',4496.96,0.00,0.00,6.11,519.35,'2023-03-04 19:49:49','',''),(8356,'1','302','1',1,'Retail Sale Id 8138',2944.00,0.00,0.00,4.00,340.00,'2023-03-05 07:37:28','',''),(8357,'1','302','1',1,'Retail Sale Id 8139',1000.96,0.00,0.00,1.36,115.60,'2023-03-05 07:38:13','',''),(8358,'1','302','1',1,'Retail Sale Id 8140',3002.88,0.00,0.00,4.08,346.80,'2023-03-05 07:50:05','',''),(8359,'1','302','1',1,'Retail Sale Id 8141',2502.40,0.00,0.00,3.40,289.00,'2023-03-05 07:52:34','',''),(8360,'1','302','1',1,'Retail Sale Id 8142',2303.68,0.00,0.00,3.13,266.05,'2023-03-05 07:55:16','',''),(8361,'1','302','1',1,'Retail Sale Id 8143',2208.00,0.00,0.00,3.00,255.00,'2023-03-05 08:03:46','',''),(8362,'1','302','1',1,'Retail Sale Id 8143',9200.00,0.00,0.00,12.50,1062.50,'2023-03-05 08:03:46','',''),(8363,'1','302','1',1,'Retail Sale Id 8144',4416.00,0.00,0.00,6.00,510.00,'2023-03-05 08:06:27','',''),(8364,'1','302','1',1,'Retail Sale Id 8145',3996.48,0.00,0.00,5.43,461.55,'2023-03-05 08:19:42','',''),(8365,'1','302','1',1,'Retail Sale Id 8146',4202.56,0.00,0.00,5.71,485.35,'2023-03-05 08:22:08','',''),(8366,'1','302','1',1,'Retail Sale Id 8147',1501.44,0.00,0.00,2.04,173.40,'2023-03-05 08:26:41','',''),(8367,'1','302','1',1,'Retail Sale Id 8148',3680.00,0.00,0.00,5.00,425.00,'2023-03-05 08:33:15','',''),(8368,'1','302','1',1,'Retail Sale Id 8149',3996.48,0.00,0.00,5.43,461.55,'2023-03-05 08:34:30','',''),(8369,'1','302','1',1,'Retail Sale Id 8150',2208.00,0.00,0.00,3.00,255.00,'2023-03-05 08:36:42','',''),(8370,'1','302','1',1,'Retail Sale Id 8152',2208.00,0.00,0.00,3.00,255.00,'2023-03-05 08:37:57','',''),(8371,'1','302','1',1,'Retail Sale Id 8153',2208.00,0.00,0.00,3.00,255.00,'2023-03-05 08:47:58','',''),(8372,'1','302','1',1,'Retail Sale Id 8154',2502.40,0.00,0.00,3.40,289.00,'2023-03-05 08:52:07','',''),(8373,'1','302','1',1,'Retail Sale Id 8155',4416.00,0.00,0.00,6.00,510.00,'2023-03-05 08:53:51','',''),(8374,'1','302','1',1,'Retail Sale Id 8156',2208.00,0.00,0.00,3.00,255.00,'2023-03-05 08:55:09','',''),(8375,'1','302','1',1,'Retail Sale Id 8157',2208.00,0.00,0.00,3.00,255.00,'2023-03-05 08:56:33','',''),(8376,'1','302','1',1,'Retail Sale Id 8158',743.36,0.00,0.00,1.01,85.85,'2023-03-05 09:01:56','',''),(8377,'1','302','1',1,'Retail Sale Id 8159',4416.00,0.00,0.00,6.00,510.00,'2023-03-05 09:10:05','',''),(8378,'1','302','1',1,'Retail Sale Id 8160',5998.40,0.00,0.00,8.15,692.75,'2023-03-05 09:12:24','',''),(8379,'1','302','1',1,'Retail Sale Id 8161',2208.00,0.00,0.00,3.00,255.00,'2023-03-05 09:21:44','',''),(8380,'1','302','1',1,'Retail Sale Id 8162',4416.00,0.00,0.00,6.00,510.00,'2023-03-05 09:25:20','',''),(8381,'1','302','1',1,'Retail Sale Id 8163',3680.00,0.00,0.00,5.00,425.00,'2023-03-05 09:27:32','',''),(8382,'1','302','1',1,'Retail Sale Id 8164',4416.00,0.00,0.00,6.00,510.00,'2023-03-05 09:28:33','',''),(8383,'1','302','1',1,'Retail Sale Id 8165',9200.00,0.00,0.00,12.50,1062.50,'2023-03-05 09:30:36','',''),(8384,'1','302','1',1,'Retail Sale Id 8166',4416.00,0.00,0.00,6.00,510.00,'2023-03-05 09:31:09','',''),(8385,'1','302','1',1,'Retail Sale Id 8167',4416.00,0.00,0.00,6.00,510.00,'2023-03-05 09:31:32','',''),(8386,'1','302','1',1,'Retail Sale Id 8168',4416.00,0.00,0.00,6.00,510.00,'2023-03-05 09:31:59','',''),(8387,'1','302','1',1,'Retail Sale Id 8169',4416.00,0.00,0.00,6.00,510.00,'2023-03-05 09:32:34','',''),(8388,'1','302','1',1,'Retail Sale Id 8170',3680.00,0.00,0.00,5.00,425.00,'2023-03-05 09:34:27','',''),(8389,'1','302','1',1,'Retail Sale Id 8171',4416.00,0.00,0.00,6.00,510.00,'2023-03-05 09:34:56','',''),(8390,'1','302','1',1,'Retail Sale Id 8172',3680.00,0.00,0.00,5.00,425.00,'2023-03-05 09:36:03','',''),(8391,'1','302','1',1,'Retail Sale Id 8173',3680.00,0.00,0.00,5.00,425.00,'2023-03-05 09:37:43','',''),(8392,'1','302','1',1,'Retail Sale Id 8174',3680.00,0.00,0.00,5.00,425.00,'2023-03-05 09:38:07','',''),(8393,'1','302','1',1,'Retail Sale Id 8175',3680.00,0.00,0.00,5.00,425.00,'2023-03-05 09:38:30','',''),(8394,'1','302','1',1,'Retail Sale Id 8176',9200.00,0.00,0.00,12.50,1062.50,'2023-03-05 09:38:53','',''),(8395,'1','302','1',1,'Retail Sale Id 8177',9200.00,0.00,0.00,12.50,1062.50,'2023-03-05 09:39:39','',''),(8396,'1','302','1',1,'Retail Sale Id 8178',9200.00,0.00,0.00,12.50,1062.50,'2023-03-05 09:40:05','',''),(8397,'1','302','1',1,'Retail Sale Id 8179',9200.00,0.00,0.00,12.50,1062.50,'2023-03-05 09:41:58','',''),(8398,'1','302','1',1,'Retail Sale Id 8180',9200.00,0.00,0.00,12.50,1062.50,'2023-03-05 09:42:27','',''),(8399,'1','302','1',1,'Retail Sale Id 8181',2208.00,0.00,0.00,3.00,255.00,'2023-03-05 09:42:52','',''),(8400,'1','302','1',1,'Retail Sale Id 8182',2208.00,0.00,0.00,3.00,255.00,'2023-03-05 09:43:27','',''),(8401,'1','302','1',1,'Retail Sale Id 8183',2208.00,0.00,0.00,3.00,255.00,'2023-03-05 09:43:53','',''),(8402,'1','302','1',1,'Retail Sale Id 8184',2208.00,0.00,0.00,3.00,255.00,'2023-03-05 09:46:35','',''),(8403,'1','302','1',1,'Retail Sale Id 8185',2208.00,0.00,0.00,3.00,255.00,'2023-03-05 09:47:00','',''),(8404,'1','302','1',1,'Retail Sale Id 8186',3002.88,0.00,0.00,4.08,346.80,'2023-03-05 09:49:11','',''),(8405,'1','302','1',1,'Retail Sale Id 8187',2208.00,0.00,0.00,3.00,255.00,'2023-03-05 09:49:50','',''),(8406,'1','302','1',1,'Retail Sale Id 8188',2944.00,0.00,0.00,4.00,340.00,'2023-03-05 10:22:42','',''),(8407,'1','302','1',1,'Retail Sale Id 8189',3996.48,0.00,0.00,5.43,461.55,'2023-03-05 10:23:45','',''),(8408,'1','302','1',1,'Retail Sale Id 8190',1501.44,0.00,0.00,2.04,173.40,'2023-03-05 10:40:22','',''),(8409,'1','302','1',1,'Retail Sale Id 8191',7360.00,0.00,0.00,10.00,850.00,'2023-03-05 10:47:34','',''),(8410,'1','302','1',1,'Retail Sale Id 8192',2001.92,0.00,0.00,2.72,231.20,'2023-03-05 10:49:24','',''),(8411,'1','302','1',1,'Retail Sale Id 8193',4416.00,0.00,0.00,6.00,510.00,'2023-03-05 10:54:03','',''),(8412,'1','302','1',1,'Retail Sale Id 8193',9200.00,0.00,0.00,12.50,1062.50,'2023-03-05 10:54:03','',''),(8413,'1','302','1',1,'Retail Sale Id 8194',802.24,0.00,0.00,1.09,92.65,'2023-03-05 10:58:21','',''),(8414,'1','302','1',1,'Retail Sale Id 8195',7360.00,0.00,0.00,10.00,850.00,'2023-03-05 11:12:05','',''),(8415,'1','302','1',1,'Retail Sale Id 8196',1000.96,0.00,0.00,1.36,115.60,'2023-03-05 11:28:01','',''),(8416,'1','302','1',1,'Retail Sale Id 8197',758.08,0.00,0.00,1.03,87.55,'2023-03-05 11:29:31','',''),(8417,'1','302','1',1,'Retail Sale Id 8198',3797.76,0.00,0.00,5.16,438.60,'2023-03-05 11:31:03','',''),(8418,'1','302','1',1,'Retail Sale Id 8199',4416.00,0.00,0.00,6.00,510.00,'2023-03-05 11:31:40','',''),(8419,'1','302','1',1,'Retail Sale Id 8200',4496.96,0.00,0.00,6.11,519.35,'2023-03-05 11:33:04','',''),(8420,'1','302','1',1,'Retail Sale Id 8201',9200.00,0.00,0.00,12.50,1062.50,'2023-03-05 11:34:49','',''),(8421,'1','302','1',1,'Retail Sale Id 8202',3002.88,0.00,0.00,4.08,346.80,'2023-03-05 11:41:20','',''),(8422,'1','302','1',1,'Retail Sale Id 8203',4997.44,0.00,0.00,6.79,577.15,'2023-03-05 11:45:54','',''),(8423,'1','302','1',1,'Retail Sale Id 8204',4416.00,0.00,0.00,6.00,510.00,'2023-03-05 11:46:59','',''),(8424,'1','302','1',1,'Retail Sale Id 8205',5998.40,0.00,0.00,8.15,692.75,'2023-03-05 11:49:05','',''),(8425,'1','302','1',1,'Retail Sale Id 8206',4416.00,0.00,0.00,6.00,510.00,'2023-03-05 11:52:26','',''),(8426,'1','302','1',1,'Retail Sale Id 8207',7360.00,0.00,0.00,10.00,850.00,'2023-03-05 11:53:25','',''),(8427,'1','302','1',1,'Retail Sale Id 8208',3503.36,0.00,0.00,4.76,404.60,'2023-03-05 11:56:29','',''),(8428,'1','302','1',1,'Retail Sale Id 8209',9200.00,0.00,0.00,12.50,1062.50,'2023-03-05 11:57:45','',''),(8429,'1','302','1',1,'Retail Sale Id 8209',9200.00,0.00,0.00,12.50,1062.50,'2023-03-05 11:57:45','',''),(8430,'1','302','1',1,'Retail Sale Id 8210',2208.00,0.00,0.00,3.00,255.00,'2023-03-05 12:00:17','',''),(8431,'1','302','1',1,'Retail Sale Id 8211',1000.96,0.00,0.00,1.36,115.60,'2023-03-05 12:01:00','',''),(8432,'1','302','1',1,'Retail Sale Id 8212',2502.40,0.00,0.00,3.40,289.00,'2023-03-05 12:15:32','',''),(8433,'1','302','1',1,'Retail Sale Id 8213',3996.48,0.00,0.00,5.43,461.55,'2023-03-05 12:28:27','',''),(8434,'1','302','1',1,'Retail Sale Id 8214',4416.00,0.00,0.00,6.00,510.00,'2023-03-05 12:30:09','',''),(8435,'1','302','1',1,'Retail Sale Id 8215',2208.00,0.00,0.00,3.00,255.00,'2023-03-05 12:31:46','',''),(8436,'1','302','1',1,'Retail Sale Id 8216',1501.44,0.00,0.00,2.04,173.40,'2023-03-05 12:33:26','',''),(8437,'1','302','1',1,'Retail Sale Id 8217',7360.00,0.00,0.00,10.00,850.00,'2023-03-05 12:36:37','',''),(8438,'1','302','1',1,'Retail Sale Id 8218',9200.00,0.00,0.00,12.50,1062.50,'2023-03-05 12:51:20','',''),(8439,'1','302','1',1,'Retail Sale Id 8219',9200.00,0.00,0.00,12.50,1062.50,'2023-03-05 12:51:59','',''),(8440,'1','302','1',1,'Retail Sale Id 8220',4416.00,0.00,0.00,6.00,510.00,'2023-03-05 18:26:14','',''),(8441,'1','302','1',1,'Retail Sale Id 8221',253426.88,0.00,0.00,344.33,29268.05,'2023-03-05 18:35:42','',''),(8442,'1','302','1',1,'Retail Sale Id 8222',110050.00,0.00,0.00,155.00,9145.00,'2023-03-05 18:36:42','',''),(8443,'1','302','1',1,'Return of Retail Sale Id 8216',0.00,1501.44,2.04,0.00,-173.40,'2023-03-05 19:56:10','',''),(8444,'1','302','1',1,'Retail Sale Id 8223',1126.08,0.00,0.00,1.53,130.05,'2023-03-05 20:01:37','',''),(8445,'1','302','1',1,'Retail Sale Id 8224',9200.00,0.00,0.00,12.50,1062.50,'2023-03-06 07:50:31','',''),(8446,'1','302','1',1,'Retail Sale Id 8225',9200.00,0.00,0.00,12.50,1062.50,'2023-03-06 07:55:18','',''),(8447,'1','302','1',1,'Retail Sale Id 8226',1000.96,0.00,0.00,1.36,115.60,'2023-03-06 08:04:17','',''),(8448,'1','302','1',1,'Retail Sale Id 8227',3996.48,0.00,0.00,5.43,461.55,'2023-03-06 08:06:18','',''),(8449,'1','302','1',1,'Retail Sale Id 8228',2208.00,0.00,0.00,3.00,255.00,'2023-03-06 08:15:56','',''),(8450,'1','302','1',1,'Retail Sale Id 8229',4416.00,0.00,0.00,6.00,510.00,'2023-03-06 08:17:38','',''),(8451,'1','302','1',1,'Retail Sale Id 8230',2001.92,0.00,0.00,2.72,231.20,'2023-03-06 08:20:27','',''),(8452,'1','302','1',1,'Retail Sale Id 8231',2001.92,0.00,0.00,2.72,231.20,'2023-03-06 08:27:37','',''),(8453,'1','302','1',1,'Retail Sale Id 8232',1472.00,0.00,0.00,2.00,170.00,'2023-03-06 08:36:04','',''),(8454,'1','302','1',1,'Retail Sale Id 8233',3002.88,0.00,0.00,4.08,346.80,'2023-03-06 08:53:36','',''),(8455,'1','302','1',1,'Retail Sale Id 8234',3680.00,0.00,0.00,5.00,425.00,'2023-03-06 08:55:46','',''),(8456,'1','302','1',1,'Retail Sale Id 8235',17750.00,0.00,0.00,25.00,1475.00,'2023-03-06 09:00:49','',''),(8457,'1','302','1',1,'Retail Sale Id 8236',8875.00,0.00,0.00,12.50,737.50,'2023-03-06 09:01:59','',''),(8458,'1','302','1',1,'Retail Sale Id 8237',2944.00,0.00,0.00,4.00,340.00,'2023-03-06 09:12:39','',''),(8459,'1','302','1',1,'Retail Sale Id 8238',4416.00,0.00,0.00,6.00,510.00,'2023-03-06 09:17:52','',''),(8460,'1','302','1',1,'Retail Sale Id 8239',4416.00,0.00,0.00,6.00,510.00,'2023-03-06 09:19:16','',''),(8461,'1','302','1',1,'Retail Sale Id 8240',9200.00,0.00,0.00,12.50,1062.50,'2023-03-06 09:20:31','',''),(8462,'1','302','1',1,'Retail Sale Id 8241',2001.92,0.00,0.00,2.72,231.20,'2023-03-06 09:21:51','',''),(8463,'1','302','1',1,'Retail Sale Id 8242',750.72,0.00,0.00,1.02,86.70,'2023-03-06 09:25:02','',''),(8464,'1','302','1',1,'Retail Sale Id 8243',1501.44,0.00,0.00,2.04,173.40,'2023-03-06 09:27:47','',''),(8465,'1','302','1',1,'Retail Sale Id 8244',3996.48,0.00,0.00,5.43,461.55,'2023-03-06 09:34:43','',''),(8466,'1','302','1',1,'Retail Sale Id 8245',2208.00,0.00,0.00,3.00,255.00,'2023-03-06 09:36:51','',''),(8467,'1','302','1',1,'Retail Sale Id 8246',3680.00,0.00,0.00,5.00,425.00,'2023-03-06 09:48:00','',''),(8468,'1','302','1',1,'Retail Sale Id 8247',1472.00,0.00,0.00,2.00,170.00,'2023-03-06 09:49:40','',''),(8469,'1','302','1',1,'Retail Sale Id 8248',7360.00,0.00,0.00,10.00,850.00,'2023-03-06 09:57:54','',''),(8470,'1','302','1',1,'Retail Sale Id 8249',2208.00,0.00,0.00,3.00,255.00,'2023-03-06 10:04:40','',''),(8471,'1','302','1',1,'Retail Sale Id 8250',9200.00,0.00,0.00,12.50,1062.50,'2023-03-06 10:10:11','',''),(8472,'1','302','1',1,'Retail Sale Id 8251',4416.00,0.00,0.00,6.00,510.00,'2023-03-06 10:19:41','',''),(8473,'1','302','1',1,'Retail Sale Id 8252',1000.96,0.00,0.00,1.36,115.60,'2023-03-06 10:28:40','',''),(8474,'1','302','1',1,'Retail Sale Id 8253',5203.52,0.00,0.00,7.07,600.95,'2023-03-06 10:33:35','',''),(8475,'1','302','1',1,'Retail Sale Id 8254',22080.00,0.00,0.00,30.00,2550.00,'2023-03-06 10:40:41','',''),(8476,'1','302','1',1,'Retail Sale Id 8255',2208.00,0.00,0.00,3.00,255.00,'2023-03-06 10:44:59','',''),(8477,'1','302','1',1,'Retail Sale Id 8256',9200.00,0.00,0.00,12.50,1062.50,'2023-03-06 10:49:16','',''),(8478,'1','302','1',1,'Retail Sale Id 8257',2502.40,0.00,0.00,3.40,289.00,'2023-03-06 10:52:22','',''),(8479,'1','302','1',1,'Retail Sale Id 8258',1000.96,0.00,0.00,1.36,115.60,'2023-03-06 10:55:48','',''),(8480,'1','302','1',1,'Retail Sale Id 8259',1000.96,0.00,0.00,1.36,115.60,'2023-03-06 10:59:20','',''),(8481,'1','302','1',1,'Retail Sale Id 8260',2208.00,0.00,0.00,3.00,255.00,'2023-03-06 11:00:04','',''),(8482,'1','302','1',1,'Retail Sale Id 8262',8875.00,0.00,0.00,12.50,737.50,'2023-03-06 11:09:05','',''),(8483,'1','302','1',1,'Retail Sale Id 8263',2200.64,0.00,0.00,2.99,254.15,'2023-03-06 11:10:56','',''),(8484,'1','302','1',1,'Retail Sale Id 8264',3996.48,0.00,0.00,5.43,461.55,'2023-03-06 11:16:45','',''),(8485,'1','302','1',1,'Retail Sale Id 8265',1000.96,0.00,0.00,1.36,115.60,'2023-03-06 11:19:00','',''),(8486,'1','302','1',1,'Retail Sale Id 8266',736.00,0.00,0.00,1.00,85.00,'2023-03-06 11:20:24','',''),(8487,'1','302','1',1,'Retail Sale Id 8267',4416.00,0.00,0.00,6.00,510.00,'2023-03-06 11:21:58','',''),(8488,'1','302','1',1,'Retail Sale Id 8268',9200.00,0.00,0.00,12.50,1062.50,'2023-03-06 11:26:56','',''),(8489,'1','302','1',1,'Retail Sale Id 8269',17750.00,0.00,0.00,25.00,1475.00,'2023-03-06 11:27:47','',''),(8490,'1','302','1',1,'Retail Sale Id 8270',4416.00,0.00,0.00,6.00,510.00,'2023-03-06 11:30:16','',''),(8491,'1','302','1',1,'Retail Sale Id 8271',2208.00,0.00,0.00,3.00,255.00,'2023-03-06 11:32:26','',''),(8492,'1','302','1',1,'Retail Sale Id 8272',4416.00,0.00,0.00,6.00,510.00,'2023-03-06 11:37:29','',''),(8493,'1','302','1',1,'Retail Sale Id 8272',9200.00,0.00,0.00,12.50,1062.50,'2023-03-06 11:37:29','',''),(8494,'1','302','1',1,'Retail Sale Id 8273',1840.00,0.00,0.00,2.50,212.50,'2023-03-06 12:28:31','',''),(8495,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,11900.28,18.28,0.00,0.00,'2023-03-06 14:12:45','',''),(8496,'1','302',NULL,1,'Reception corrector for bridging 44',0.00,0.00,0.00,18.28,0.00,'2023-03-06 14:15:35','',''),(8497,'1','302','1',1,'Received from bridging 44',0.00,0.00,18.28,0.00,0.00,'2023-03-06 14:15:35','',''),(8498,'1','302','1',1,'Retail Sale Id 8274',13454.08,0.00,0.00,18.28,1553.80,'2023-03-06 14:16:32','',''),(8499,'1','302',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3515400.00,5400.00,0.00,0.00,'2023-03-06 19:18:30','',''),(8500,'1','302',NULL,1,'Reception corrector for bridging 45',0.00,0.00,0.00,5400.00,0.00,'2023-03-06 19:20:02','',''),(8501,'1','302','1',1,'Received from bridging 45',0.00,0.00,5400.00,0.00,0.00,'2023-03-06 19:20:02','',''),(8502,'1','302','1',1,'Retail Sale Id 8275',132538.88,0.00,0.00,180.08,15306.80,'2023-03-06 19:59:05','',''),(8503,'1','302','1',1,'Retail Sale Id 8276',106500.00,0.00,0.00,150.00,8850.00,'2023-03-06 19:59:41','',''),(8504,'1','302','1',1,'Retail Sale Id 8277',16560.00,0.00,0.00,22.50,1912.50,'2023-03-07 08:22:49','',''),(8505,'1','302','1',1,'Retail Sale Id 8278',4496.96,0.00,0.00,6.11,519.35,'2023-03-07 08:24:34','',''),(8506,'1','302','1',1,'Retail Sale Id 8279',2001.92,0.00,0.00,2.72,231.20,'2023-03-07 08:34:36','',''),(8507,'1','302','1',1,'Retail Sale Id 8280',2208.00,0.00,0.00,3.00,255.00,'2023-03-07 08:40:53','',''),(8508,'1','302','1',1,'Retail Sale Id 8281',9200.00,0.00,0.00,12.50,1062.50,'2023-03-07 08:42:12','',''),(8509,'1','302','1',1,'Retail Sale Id 8282',3680.00,0.00,0.00,5.00,425.00,'2023-03-07 08:44:31','',''),(8510,'1','302','1',1,'Retail Sale Id 8283',2208.00,0.00,0.00,3.00,255.00,'2023-03-07 08:46:43','',''),(8511,'1','302','1',1,'Retail Sale Id 8284',9200.00,0.00,0.00,12.50,1062.50,'2023-03-07 08:52:42','',''),(8512,'1','302','1',1,'Retail Sale Id 8285',9200.00,0.00,0.00,12.50,1062.50,'2023-03-07 08:59:22','',''),(8513,'1','302','1',1,'Retail Sale Id 8286',2208.00,0.00,0.00,3.00,255.00,'2023-03-07 09:01:45','',''),(8514,'1','302','1',1,'Retail Sale Id 8287',1472.00,0.00,0.00,2.00,170.00,'2023-03-07 09:03:10','',''),(8515,'1','302','1',1,'Retail Sale Id 8288',2001.92,0.00,0.00,2.72,231.20,'2023-03-07 09:08:25','',''),(8516,'1','302','1',1,'Retail Sale Id 8289',1472.00,0.00,0.00,2.00,170.00,'2023-03-07 09:10:38','',''),(8517,'1','302','1',1,'Retail Sale Id 8289',4416.00,0.00,0.00,6.00,510.00,'2023-03-07 09:10:38','',''),(8518,'1','302','1',1,'Retail Sale Id 8289',7360.00,0.00,0.00,10.00,850.00,'2023-03-07 09:10:38','',''),(8519,'1','302','1',1,'Retail Sale Id 8290',2944.00,0.00,0.00,4.00,340.00,'2023-03-07 09:11:58','',''),(8520,'1','302','1',1,'Retail Sale Id 8291',500.48,0.00,0.00,0.68,57.80,'2023-03-07 09:14:12','',''),(8521,'1','302','1',1,'Retail Sale Id 8293',1449.92,0.00,0.00,1.97,167.45,'2023-03-07 09:18:03','',''),(8522,'1','302','1',1,'Retail Sale Id 8294',3680.00,0.00,0.00,5.00,425.00,'2023-03-07 09:20:11','',''),(8523,'1','302','1',1,'Retail Sale Id 8295',2208.00,0.00,0.00,3.00,255.00,'2023-03-07 09:24:53','',''),(8524,'1','302','1',1,'Retail Sale Id 8296',4416.00,0.00,0.00,6.00,510.00,'2023-03-07 09:27:42','',''),(8525,'1','302','1',1,'Retail Sale Id 8297',4416.00,0.00,0.00,6.00,510.00,'2023-03-07 09:28:58','',''),(8526,'1','302','1',1,'Retail Sale Id 8298',8832.00,0.00,0.00,12.00,1020.00,'2023-03-07 09:32:12','',''),(8527,'1','302','1',1,'Retail Sale Id 8299',9200.00,0.00,0.00,12.50,1062.50,'2023-03-07 09:34:33','',''),(8528,'1','302','1',1,'Retail Sale Id 8300',4416.00,0.00,0.00,6.00,510.00,'2023-03-07 09:39:37','',''),(8529,'1','302','1',1,'Retail Sale Id 8301',2208.00,0.00,0.00,3.00,255.00,'2023-03-07 09:40:25','',''),(8530,'1','302','1',1,'Retail Sale Id 8305',24850.00,0.00,0.00,35.00,2065.00,'2023-03-07 09:47:28','',''),(8531,'1','302','1',1,'Retail Sale Id 8306',3702.08,0.00,0.00,5.03,427.55,'2023-03-07 09:58:36','',''),(8532,'1','302','1',1,'Retail Sale Id 8307',2208.00,0.00,0.00,3.00,255.00,'2023-03-07 10:03:34','',''),(8533,'1','302','1',1,'Retail Sale Id 8308',1472.00,0.00,0.00,2.00,170.00,'2023-03-07 10:10:56','',''),(8534,'1','302','1',1,'Retail Sale Id 8309',2208.00,0.00,0.00,3.00,255.00,'2023-03-07 10:13:52','',''),(8535,'1','302','1',1,'Retail Sale Id 8310',1000.96,0.00,0.00,1.36,115.60,'2023-03-07 10:17:25','',''),(8536,'1','302','1',1,'Retail Sale Id 8311',3680.00,0.00,0.00,5.00,425.00,'2023-03-07 10:27:48','',''),(8537,'1','302','1',1,'Retail Sale Id 8312',3002.88,0.00,0.00,4.08,346.80,'2023-03-07 10:32:03','',''),(8538,'1','302','1',1,'Retail Sale Id 8313',3002.88,0.00,0.00,4.08,346.80,'2023-03-07 10:40:07','',''),(8539,'1','302','1',1,'Retail Sale Id 8314',17296.00,0.00,0.00,23.50,1997.50,'2023-03-07 10:44:03','',''),(8540,'1','302','1',1,'Retail Sale Id 8315',4416.00,0.00,0.00,6.00,510.00,'2023-03-07 10:47:34','',''),(8541,'1','302','1',1,'Retail Sale Id 8316',3680.00,0.00,0.00,5.00,425.00,'2023-03-07 10:49:57','',''),(8542,'1','302','1',1,'Retail Sale Id 8317',500.48,0.00,0.00,0.68,57.80,'2023-03-07 10:51:00','',''),(8543,'1','302','1',1,'Retail Sale Id 8318',4997.44,0.00,0.00,6.79,577.15,'2023-03-07 10:51:51','',''),(8544,'1','302','1',1,'Retail Sale Id 8319',9200.00,0.00,0.00,12.50,1062.50,'2023-03-07 10:52:58','',''),(8545,'1','302','1',1,'Retail Sale Id 8320',4416.00,0.00,0.00,6.00,510.00,'2023-03-07 10:56:37','',''),(8546,'1','302','1',1,'Retail Sale Id 8321',2208.00,0.00,0.00,3.00,255.00,'2023-03-07 11:13:19','',''),(8547,'1','302','1',1,'Retail Sale Id 8322',3550.00,0.00,0.00,5.00,295.00,'2023-03-07 11:16:49','',''),(8548,'1','302','1',1,'Retail Sale Id 8323',3680.00,0.00,0.00,5.00,425.00,'2023-03-07 11:19:27','',''),(8549,'1','302','1',1,'Retail Sale Id 8324',9200.00,0.00,0.00,12.50,1062.50,'2023-03-07 11:21:08','',''),(8550,'1','302','1',1,'Retail Sale Id 8325',9200.00,0.00,0.00,12.50,1062.50,'2023-03-07 11:22:16','',''),(8551,'1','302','1',1,'Retail Sale Id 8327',2208.00,0.00,0.00,3.00,255.00,'2023-03-07 11:50:07','',''),(8552,'1','302','1',1,'Retail Sale Id 8328',10002.24,0.00,0.00,13.59,1155.15,'2023-03-07 11:51:30','',''),(8553,'1','302','1',1,'Retail Sale Id 8329',1472.00,0.00,0.00,2.00,170.00,'2023-03-07 12:07:08','',''),(8554,'1','302','1',1,'Retail Sale Id 8330',17750.00,0.00,0.00,25.00,1475.00,'2023-03-07 12:10:01','',''),(8555,'1','302','1',1,'Retail Sale Id 8331',3996.48,0.00,0.00,5.43,461.55,'2023-03-07 12:15:33','',''),(8556,'1','302','1',1,'Retail Sale Id 8332',2208.00,0.00,0.00,3.00,255.00,'2023-03-07 12:25:23','',''),(8557,'1','302','1',1,'Retail Sale Id 8333',2208.00,0.00,0.00,3.00,255.00,'2023-03-07 12:41:03','',''),(8558,'1','302','1',1,'Retail Sale Id 8334',35500.00,0.00,0.00,50.00,2950.00,'2023-03-07 12:42:41','',''),(8559,'1','302','1',1,'Retail Sale Id 8335',9200.00,0.00,0.00,12.50,1062.50,'2023-03-07 12:43:51','',''),(8560,'1','302','1',1,'Retail Sale Id 8337',4496.96,0.00,0.00,6.11,519.35,'2023-03-07 12:45:38','',''),(8561,'1','302','1',1,'Retail Sale Id 8338',736.00,0.00,0.00,1.00,85.00,'2023-03-07 12:46:54','',''),(8562,'1','302','1',1,'Retail Sale Id 8339',3002.88,0.00,0.00,4.08,346.80,'2023-03-07