-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_294
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_294`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_294` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_294`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,500,'',0,'6.1','1','294','CASH','','2022-10-18 17:03:12',5,0.00,0.00,'','178','2022-10-18 17:03:12','178',0,0),(2,8000,'',0,'24','1','294','PURCHASES','','2022-10-18 17:03:26',5,0.00,0.00,'','178','2022-10-18 17:03:26','178',0,0),(3,8001,'',0,'24','1','294','SALARIES','','2022-10-18 17:03:35',5,0.00,0.00,'','178','2022-10-18 17:03:35','178',0,0),(4,7000,'',0,'20','1','294','SALES','','2022-10-18 17:03:43',5,0.00,0.00,'','178','2022-10-18 17:03:43','178',0,0),(5,2500,'',0,'2','1','294','ZNB 1014717261','','2022-10-26 15:05:19',5,0.00,0.00,'','975','2022-10-26 15:05:19','975',0,0),(6,2501,'',0,'2','1','294','UBA POS','','2022-10-26 15:06:29',5,0.00,0.00,'','975','2022-10-26 15:06:29','975',0,0),(8,2502,'',0,'2','1','294','FID POS  5620091589','','2023-02-20 13:56:17',5,0.00,0.00,'','975','2023-02-20 13:56:17','975',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','1','294','DRIVER\'S SHORT','DRIVER','080******123','ds@gmail.com','AKURE','ONDO','AKURE 3 S/S','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-02 15:34:36',5,'975','2022-11-02 15:34:36','975'),(2,'','1','294','NIGERIA POLICE FORCE (ELECTION','ANEKE C. FRANCIS','08063961379','dopstransport@gmail.com','AKURE','ONDO','ONDO STATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-21 17:10:21',5,'975','2023-02-21 17:10:21','975');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','294',1,'3',5939.04,6321.00,'2022-11-07','','2022-11-07 20:35:14','614','614',2022,'614','2022-11-07 20:35:14',5),('1','294',2,'3',676.28,1982.00,'2022-11-27','','2022-11-27 14:31:27','614','614',2022,'614','2022-11-27 14:31:27',5),('1','294',3,'3',1082.94,1800.00,'2022-12-07','','2022-12-07 11:56:21','975','975',2022,'975','2022-12-07 11:56:21',5),('1','294',4,'3',3717.89,6000.00,'2023-01-03','','2023-01-03 14:39:15','975','975',2023,'975','2023-01-03 14:39:15',5),('1','294',5,'3',2639.63,3500.00,'2023-02-16','','2023-02-16 21:54:34','734','734',2023,'734','2023-02-16 21:54:34',5),('1','294',6,'2',90.61,9500.00,'2023-02-25','','2023-02-25 19:49:40','734','734',2023,'734','2023-02-25 19:49:40',5),('1','294',7,'2',9544.85,10200.00,'2023-02-28','','2023-02-28 09:00:26','734','734',2023,'734','2023-02-28 09:00:26',5),('1','294',8,'2',115.44,14200.00,'2023-02-28','','2023-02-28 15:50:31','734','734',2023,'734','2023-02-28 15:50:31',5),('1','294',9,'2',126.15,3800.00,'2023-02-28','','2023-02-28 21:11:24','734','734',2023,'734','2023-02-28 21:11:24',5),('1','294',10,'2',9863.00,10000.00,'2023-03-10','','2023-03-10 19:51:07','734','734',2023,'734','2023-03-10 19:51:07',5),('1','294',11,'3',2397.87,3000.00,'2023-03-10','','2023-03-10 20:38:12','734','734',2023,'734','2023-03-10 20:38:12',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','294','1',1,'5','PUMP 9',58008.97,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-25 17:48:14','975'),('1','294','1',2,'5','PUMP 10',48494.54,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-25 17:48:50','975'),('1','294','1',3,'5','PUMP 11',62183.88,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-25 17:49:23','975'),('1','294','1',4,'5','PUMP 12',21448.16,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-25 17:50:14','975'),('1','294','1',5,'5','PUMP 13',72208.06,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-25 17:50:51','975'),('1','294','1',6,'5','PUMP 14',10612.48,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-25 17:51:30','975'),('1','294','1',7,'5','PUMP 15',29358.30,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-25 17:52:04','975'),('1','294','1',8,'5','PUMP 16',6916.34,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-25 17:52:41','975'),('1','294','2',9,'5','PUMP 1',0.00,'DISPENSING PMS',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','294','2',10,'5','PUMP 2',0.00,'DISPENSING PMS',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','294','2',11,'5','PUMP 3',220610.46,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-25 17:53:58','975'),('1','294','2',12,'5','PUMP 4',266293.71,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-25 17:54:29','975'),('1','294','2',13,'5','PUMP 5',108048.58,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-25 17:55:02','975'),('1','294','2',14,'5','PUMP 6',224022.31,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-25 17:55:50','975'),('1','294','2',15,'5','PUMP 7',236318.68,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-25 17:56:28','975'),('1','294','2',16,'5','PUMP 8',47329.90,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-25 17:57:11','975'),('1','294','3',17,'5','AGO PUMP 1',362351.54,'DISPENSING AGO','',NULL,NULL,'',5,'2022-10-25 17:57:59','975'),('1','294','3',18,'5','AGO PUMP 2',27196.53,'DISPENSING AGO','',NULL,NULL,'',5,'2022-10-25 17:58:37','975'),('1','294','3',19,'5','AGO PUMP 3',173270.18,'DISPENSING AGO','',NULL,NULL,'',5,'2022-10-25 17:59:10','975'),('1','294','3',20,'5','AGO PUMP 4',40404.63,'DISPENSING AGO','',NULL,NULL,'',5,'2022-10-25 17:59:48','975');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=305 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','294',1,'MORNING','2022-09-08','2022-10-26 11:16:58','2022-10-27 11:16:58','966',114045.75,114045.75,'966','2022-10-26 11:22:36','614','2022-10-26 12:07:01',10,0),('1','294',2,'MORNING ','2022-09-08','2022-10-26 12:12:27','2022-10-27 12:12:27','966',1546125.55,1546125.55,'966','2022-10-26 12:22:38','614','2022-10-26 12:23:47',10,0),('1','294',3,'AFTERNOON','2022-09-08','2022-10-26 13:26:20','2022-10-27 13:26:20','966',402039.85,402039.85,'966','2022-10-26 13:31:04','614','2022-10-26 13:54:57',10,0),('1','294',4,'MORNING','2022-09-09','2022-10-26 14:19:09','2022-10-27 14:19:09','966',2784328.85,2784328.85,'966','2022-10-26 14:26:18','614','2022-10-26 14:28:54',10,0),('1','294',5,'AFTERNOON','2022-09-09','2022-10-26 14:36:38','2022-10-27 14:36:38','966',395090.40,395090.40,'966','2022-10-26 14:41:18','614','2022-10-26 14:43:05',10,0),('1','294',6,'MORNING','2022-09-10','2022-10-26 14:48:47','2022-10-27 14:48:47','966',-7875.00,-7875.00,'966','2022-10-26 15:01:34','614','2022-10-26 15:02:05',10,0),('1','294',7,'MORNING','2022-09-10','2022-10-26 15:15:41','2022-10-27 15:15:41','966',4026317.25,4026317.25,'966','2022-10-26 15:23:03','614','2022-10-26 15:31:07',10,0),('1','294',8,'AFTERNOON','2022-09-10','2022-10-26 15:44:49','2022-10-27 15:44:49','966',255150.00,255150.00,'966','2022-10-26 15:46:21','614','2022-10-26 16:02:47',10,0),('1','294',9,'MORNING','2022-09-11','2022-10-26 16:52:18','2022-10-27 16:52:18','966',3525038.65,3525038.65,'966','2022-10-26 17:08:56','614','2022-10-26 17:12:11',10,0),('1','294',10,'AFTERNOON','2022-09-11','2022-10-27 10:41:39','2022-10-28 10:41:39','966',752171.15,752171.15,'966','2022-10-27 10:50:21','614','2022-10-27 10:52:18',10,0),('1','294',11,'MORNING','2022-09-12','2022-10-27 10:54:03','2022-10-28 10:54:03','966',1512004.45,1512004.45,'966','2022-10-27 10:59:09','614','2022-10-27 10:59:58',10,0),('1','294',12,'AFTERNOON','2022-09-12','2022-10-27 11:09:58','2022-10-28 11:09:58','966',1520849.30,1520849.30,'966','2022-10-27 11:23:57','614','2022-10-27 11:25:30',10,0),('1','294',13,'MORNING','2022-09-13','2022-10-27 11:28:04','2022-10-28 11:28:04','966',1497052.55,1497052.55,'966','2022-10-27 11:32:41','614','2022-10-27 11:34:46',10,0),('1','294',14,'AFTERNOON','2022-09-13','2022-10-27 11:43:36','2022-10-28 11:43:36','966',1579752.10,1579752.10,'966','2022-10-27 11:47:45','614','2022-10-27 11:48:37',10,0),('1','294',15,'MORNING','2022-09-14','2022-10-27 11:52:07','2022-10-28 11:52:07','966',1535666.20,1535666.20,'966','2022-10-27 11:54:21','614','2022-10-27 11:55:51',10,0),('1','294',16,'AFTERNOON','2022-09-14','2022-10-27 11:56:56','2022-10-28 11:56:56','966',2059120.15,2059120.15,'966','2022-10-27 12:00:24','614','2022-10-27 12:01:17',10,0),('1','294',17,'MORNING','2022-09-15','2022-10-27 12:06:15','2022-10-28 12:06:15','966',1851911.85,1851911.85,'966','2022-10-27 12:09:49','614','2022-10-27 12:11:06',10,0),('1','294',18,'AFTERNOON','2022-09-15','2022-10-27 12:12:50','2022-10-28 12:12:50','966',2727792.65,2727792.65,'966','2022-10-27 12:15:59','614','2022-10-27 12:17:02',10,0),('1','294',19,'MORNING','2022-09-16','2022-10-27 12:17:36','2022-10-28 12:17:36','966',1709401.10,1709401.10,'966','2022-10-27 12:20:21','614','2022-10-27 12:21:28',10,0),('1','294',20,'AFTERNOON','2022-09-16','2022-10-27 12:22:50','2022-10-28 12:22:50','966',2748481.20,2748481.20,'966','2022-10-27 12:27:10','614','2022-10-27 12:27:40',10,0),('1','294',21,'MORNING','2022-09-17','2022-10-27 12:29:07','2022-10-28 12:29:07','966',1385366.25,1385366.25,'966','2022-10-27 12:30:58','614','2022-10-27 12:31:32',10,0),('1','294',22,'AFTERNOON','2022-09-17','2022-10-27 12:32:24','2022-10-28 12:32:24','966',2112013.45,2112013.45,'966','2022-10-27 12:36:53','614','2022-10-27 12:38:49',10,0),('1','294',23,'MORNING','2022-09-18','2022-10-27 12:41:00','2022-10-28 12:41:00','966',1374905.00,1374905.00,'966','2022-10-27 12:43:13','614','2022-10-27 12:45:37',10,0),('1','294',24,'AFTERNOON','2022-09-18','2022-10-27 14:55:05','2022-10-28 14:55:05','966',1653843.75,1653843.75,'966','2022-10-27 14:58:12','614','2022-10-27 14:59:54',10,0),('1','294',25,'MORNING','2022-09-19','2022-10-27 15:01:18','2022-10-28 15:01:18','966',1786133.75,1786133.75,'966','2022-10-27 15:03:39','614','2022-10-27 15:11:28',10,0),('1','294',26,'AFTERNOON','2022-09-19','2022-10-27 15:15:59','2022-10-28 15:15:59','966',1510886.35,1510886.35,'966','2022-10-27 15:18:51','614','2022-10-27 15:19:36',10,0),('1','294',27,'MORNING','2022-09-20','2022-10-27 15:20:57','2022-10-28 15:20:57','966',1454330.80,1454330.80,'966','2022-10-27 15:23:51','614','2022-10-27 15:24:53',10,0),('1','294',28,'AFTERNOON','2022-09-20','2022-10-27 15:26:04','2022-10-28 15:26:04','966',2571698.80,2571698.80,'966','2022-10-27 15:30:06','614','2022-10-27 15:31:09',10,0),('1','294',29,'MORNING','2022-09-21','2022-10-27 15:33:14','2022-10-28 15:33:14','966',1193945.30,1193945.30,'966','2022-10-27 15:35:30','614','2022-10-27 15:37:34',10,0),('1','294',30,'AFTERNOON','2022-09-21','2022-10-27 15:43:59','2022-10-28 15:43:59','966',1894361.20,1894361.20,'966','2022-10-27 15:47:54','614','2022-10-27 16:00:26',10,0),('1','294',31,'MORNING','2022-09-22','2022-10-27 16:18:24','2022-10-28 16:18:24','966',2087351.40,2087351.40,'966','2022-10-27 16:24:36','614','2022-10-27 16:28:12',10,0),('1','294',32,'AFTERNOON','2022-09-22','2022-10-27 16:30:26','2022-10-28 16:30:26','966',1975065.45,1975065.45,'966','2022-10-27 16:33:18','614','2022-10-27 16:39:10',10,0),('1','294',33,'MORNING','2022-09-23','2022-10-27 16:43:13','2022-10-28 16:43:13','966',2151624.10,2151624.10,'966','2022-10-27 16:46:16','614','2022-10-27 16:47:16',10,0),('1','294',34,'AFTERNOON','2022-09-23','2022-10-27 16:48:42','2022-10-28 16:48:42','966',2620561.80,2620561.80,'966','2022-10-27 16:52:19','614','2022-10-27 16:53:52',10,0),('1','294',35,'MORNING','2022-09-24','2022-10-27 16:56:39','2022-10-28 16:56:39','966',1499288.10,1499288.10,'966','2022-10-27 17:00:53','614','2022-10-27 17:01:45',10,0),('1','294',36,'AFTERNOON','2022-09-24','2022-10-27 17:03:59','2022-10-28 17:03:59','966',2655817.65,2655817.65,'966','2022-10-27 17:05:56','614','2022-10-27 17:08:46',10,0),('1','294',37,'MORNING','2022-09-25','2022-10-27 17:18:35','2022-10-28 17:18:35','966',1544157.75,1544157.75,'966','2022-10-27 17:20:50','614','2022-10-27 17:21:11',10,0),('1','294',38,'AFTERNOON','2022-09-25','2022-10-27 17:23:23','2022-10-28 17:23:23','966',2874975.55,2874975.55,'966','2022-10-27 17:25:36','614','2022-10-27 17:26:20',10,0),('1','294',39,'MORNING','2022-09-26','2022-10-27 17:27:18','2022-10-28 17:27:18','966',2025114.80,2025114.80,'966','2022-10-27 17:29:19','614','2022-10-27 17:29:42',10,0),('1','294',40,'AFTERNOON','2022-09-26','2022-10-27 17:30:35','2022-10-28 17:30:35','966',2367027.10,2367027.10,'966','2022-10-27 17:32:24','614','2022-10-27 17:32:55',10,0),('1','294',41,'MORNING','2022-09-27','2022-10-27 17:34:16','2022-10-28 17:34:16','966',2167299.40,2167299.40,'966','2022-10-28 07:37:42','614','2022-10-28 16:54:18',10,0),('1','294',42,'AFTERNOON','2022-09-27','2022-10-28 16:56:47','2022-10-29 16:56:47','966',3274185.00,3274185.00,'966','2022-10-28 16:59:30','614','2022-10-28 17:00:34',10,0),('1','294',43,'MORNING','2022-09-28','2022-10-28 17:03:08','2022-10-29 17:03:08','966',658699.60,658699.60,'966','2022-10-28 17:04:33','614','2022-10-28 17:05:43',10,0),('1','294',44,'MORNING (1)','2022-09-29','2022-10-28 17:07:23','2022-10-29 17:07:23','966',970627.00,970627.00,'966','2022-10-28 17:10:17','614','2022-10-28 17:11:19',10,0),('1','294',45,'MORNING (2)','2022-09-29','2022-10-28 17:15:38','2022-10-29 17:15:38','966',428004.50,435341.72,'966','2022-10-28 17:27:24','614','2022-10-28 17:28:48',10,0),('1','294',46,'AFTERNOON','2022-09-29','2022-10-28 17:30:44','2022-10-29 17:30:44','966',1971428.32,1971428.32,'966','2022-10-28 17:32:56','614','2022-10-28 17:42:21',10,0),('1','294',47,'MORNING','2022-09-30','2022-10-28 17:47:13','2022-10-29 17:47:13','966',1409021.30,1409021.30,'966','2022-10-28 17:50:37','614','2022-10-28 18:17:10',10,0),('1','294',48,'AFTERNOON','2022-09-30','2022-10-29 10:57:25','2022-10-30 10:57:25','966',1705247.12,1705247.12,'966','2022-10-29 11:22:26','614','2022-10-29 11:23:06',10,0),('1','294',49,'MORNING','2022-10-01','2022-10-29 11:24:14','2022-10-30 11:24:14','966',1189768.02,1189768.02,'966','2022-10-29 11:25:41','614','2022-10-29 11:26:28',10,0),('1','294',50,'AFTERNOON','2022-10-01','2022-10-29 11:26:53','2022-10-30 11:26:53','966',1492108.14,1492108.14,'966','2022-10-29 11:29:00','614','2022-10-29 11:30:20',10,0),('1','294',51,'MORNING','2022-10-02','2022-10-29 11:31:03','2022-10-30 11:31:03','966',1170766.52,1170766.52,'966','2022-10-29 11:32:31','614','2022-10-29 11:33:09',10,0),('1','294',52,'AFTERNOON','2022-10-02','2022-10-29 11:36:38','2022-10-30 11:36:38','966',1532136.78,1532136.78,'966','2022-10-29 11:39:30','614','2022-10-29 11:41:02',10,0),('1','294',53,'MORNING','2022-10-03','2022-10-29 11:42:02','2022-10-30 11:42:02','966',1307239.12,1307239.12,'966','2022-10-29 11:43:36','614','2022-10-29 11:44:04',10,0),('1','294',54,'AFTERNOON','2022-10-03','2022-10-29 11:44:37','2022-10-30 11:44:37','966',1487341.30,1487341.30,'966','2022-10-29 11:46:07','614','2022-10-29 11:48:02',10,0),('1','294',55,'MORNING','2022-10-04','2022-10-29 11:49:07','2022-10-30 11:49:07','966',2634304.26,2634304.26,'966','2022-10-29 11:51:29','614','2022-10-29 11:52:17',10,0),('1','294',56,'AFTERNOON','2022-10-04','2022-10-29 11:52:52','2022-10-30 11:52:52','966',2837673.00,2837673.00,'966','2022-10-29 11:54:53','614','2022-10-29 11:55:40',10,0),('1','294',57,'MORNING (1)','2022-10-05','2022-10-29 12:04:30','2022-10-30 12:04:30','966',1402548.58,1402548.58,'966','2022-10-29 12:08:38','614','2022-10-29 12:12:05',10,0),('1','294',58,'MORNING (2)','2022-10-05','2022-10-29 12:13:28','2022-10-30 12:13:28','966',443016.60,443016.60,'966','2022-10-29 12:14:13','614','2022-10-29 12:14:52',10,0),('1','294',59,'AFTERNOON','2022-10-05','2022-10-29 12:15:34','2022-10-30 12:15:34','966',2593333.74,2593333.74,'966','2022-10-29 12:17:21','614','2022-10-29 12:17:37',10,0),('1','294',60,'MORNING','2022-10-06','2022-10-29 12:19:54','2022-10-30 12:19:54','966',1633617.52,1633617.52,'966','2022-10-29 12:21:59','614','2022-10-29 12:24:10',10,0),('1','294',61,'AFTERNOON','2022-10-06','2022-10-29 12:25:56','2022-10-30 12:25:56','966',3603093.28,3603093.28,'966','2022-10-29 12:27:37','614','2022-10-29 12:28:18',10,0),('1','294',62,'AFTERNOON','2022-10-07','2022-10-29 12:28:43','2022-10-30 12:28:43','966',0.00,0.00,'966','2022-10-29 12:31:40','614','2022-10-29 12:32:47',10,0),('1','294',63,'MORNING','2022-10-07','2022-10-29 12:33:53','2022-10-30 12:33:53','966',2099847.20,2116803.80,'966','2022-10-29 12:35:32','614','2022-10-29 12:36:17',10,0),('1','294',64,'AFTERNOON','2022-10-07','2022-10-29 12:36:48','2022-10-30 12:36:48','966',2023667.80,2043834.40,'966','2022-10-29 12:38:46','614','2022-10-29 12:39:23',10,0),('1','294',65,'MORNING','2022-10-08','2022-10-29 12:40:21','2022-10-30 12:40:21','966',1489612.80,1489612.80,'966','2022-10-29 12:41:01','614','2022-10-29 12:42:29',10,0),('1','294',66,'AFTERNOON','2022-10-08','2022-10-29 12:42:49','2022-10-30 12:42:49','966',1140562.80,1140562.80,'966','2022-10-29 12:43:16','614','2022-10-29 12:44:02',10,0),('1','294',67,'MORNING','2022-10-09','2022-10-29 12:44:54','2022-10-30 12:44:54','966',180000.60,180000.60,'966','2022-10-29 12:45:21','614','2022-10-29 12:45:39',10,0),('1','294',68,'AFTERNOON','2022-10-09','2022-10-29 12:46:23','2022-10-30 12:46:23','966',1461415.05,1476202.50,'966','2022-10-29 12:48:03','614','2022-10-29 12:49:45',10,0),('1','294',69,'MORNING','2022-10-10','2022-10-29 12:50:19','2022-10-30 12:50:19','966',1254022.20,1270150.56,'966','2022-10-29 12:51:55','614','2022-10-29 12:52:39',10,0),('1','294',70,'AFTERNOON','2022-10-10','2022-10-29 12:55:31','2022-10-30 12:55:31','966',2786161.40,2811401.60,'966','2022-10-29 12:58:19','614','2022-10-29 13:03:01',10,0),('1','294',71,'MORNING','2022-10-11','2022-10-29 14:26:35','2022-10-30 14:26:35','966',1588428.20,1607366.24,'966','2022-10-29 14:29:01','614','2022-10-29 14:50:27',10,0),('1','294',72,'AFTERNOON','2022-10-11','2022-10-29 15:09:31','2022-10-30 15:09:31','966',1743342.90,1768233.48,'966','2022-10-29 15:12:31','614','2022-10-29 15:13:12',10,0),('1','294',73,'MORNING','2022-10-12','2022-10-29 15:13:58','2022-10-30 15:13:58','966',1157679.25,1177525.18,'966','2022-10-29 15:15:27','614','2022-10-29 15:15:56',10,0),('1','294',74,'AFTERNOON','2022-10-12','2022-10-29 15:16:48','2022-10-30 15:16:48','966',1399790.00,1423786.40,'966','2022-10-29 15:20:24','614','2022-10-29 15:21:07',10,0),('1','294',75,'MORNING','2022-10-13','2022-10-29 15:21:33','2022-10-30 15:21:33','966',1117814.25,1136976.78,'966','2022-10-29 15:22:54','614','2022-10-29 15:23:31',10,0),('1','294',76,'AFTERNOON','2022-10-13','2022-10-29 15:23:51','2022-10-30 15:23:51','966',1041220.25,1059069.74,'966','2022-10-29 15:24:58','614','2022-10-29 15:25:24',10,0),('1','294',77,'MORNING','2022-10-14','2022-10-30 10:03:53','2022-10-31 10:03:53','966',0.00,0.00,'966','2022-10-30 10:04:18','614','2022-10-30 10:16:26',10,0),('1','294',78,'AFTERNOON','2022-10-14','2022-10-30 10:23:58','2022-10-31 10:23:58','966',0.00,0.00,'966','2022-10-30 10:25:07','614','2022-10-30 10:28:25',10,0),('1','294',79,'MORNING SHIFT','2022-10-14','2022-10-31 11:47:21','2022-11-01 11:47:21','975',0.00,0.00,'966','2022-10-31 12:17:25','614','2022-10-31 12:22:00',10,0),('1','294',80,'AFTERNOOM SHIFT','2022-10-16','2022-10-31 13:22:09','2022-11-01 13:22:09','975',811284.84,811284.84,'966','2022-10-31 13:27:29','614','2022-10-31 13:28:26',10,0),('1','294',81,'MORNING SHIFT','2022-10-17','2022-10-31 13:49:52','2022-11-01 13:49:52','966',1560727.14,1560727.14,'966','2022-10-31 13:54:35','614','2022-10-31 14:14:52',10,0),('1','294',82,'AFTERNOON SHIFT','2022-10-17','2022-10-31 14:20:03','2022-11-01 14:20:03','966',4015453.30,4015453.30,'966','2022-10-31 14:22:55','614','2022-10-31 14:23:41',10,0),('1','294',83,'MORNING SHIFT ','2022-10-18','2022-10-31 14:24:38','2022-11-01 14:24:38','966',3605131.14,3605131.14,'966','2022-10-31 14:27:26','614','2022-10-31 14:28:56',10,0),('1','294',84,'AFTERNOON SHIFT','2022-10-18','2022-10-31 14:29:54','2022-11-01 14:29:54','966',2873815.36,2873815.36,'966','2022-10-31 14:32:14','614','2022-10-31 14:33:35',10,0),('1','294',85,'MORNING SHIFT ','2022-10-19','2022-10-31 14:34:24','2022-11-01 14:34:24','966',2515983.20,2515983.20,'966','2022-10-31 14:38:51','614','2022-10-31 14:41:09',10,0),('1','294',86,'AFTERNOON SHIFT','2022-10-19','2022-10-31 14:42:06','2022-11-01 14:42:06','966',2122426.30,2122426.30,'966','2022-10-31 14:44:37','614','2022-10-31 14:45:58',10,0),('1','294',87,'MORNING SHIFT','2022-10-20','2022-10-31 14:46:49','2022-11-01 14:46:49','966',919633.68,919633.68,'966','2022-10-31 14:48:06','614','2022-10-31 14:59:31',10,0),('1','294',88,'AFTERNOON SHIFT','2022-10-20','2022-10-31 15:00:12','2022-11-01 15:00:12','966',670136.00,670136.00,'966','2022-10-31 15:00:49','614','2022-10-31 15:04:15',10,0),('1','294',89,'MORNING SHIFT','2022-10-21','2022-10-31 15:11:49','2022-11-01 15:11:49','966',920400.00,920400.00,'966','2022-10-31 15:12:39','614','2022-10-31 15:13:35',10,0),('1','294',90,'AFTERNOON SHIFT','2022-10-21','2022-10-31 15:14:12','2022-11-01 15:14:12','966',1410280.00,1410280.00,'966','2022-10-31 15:17:19','614','2022-10-31 15:17:59',10,0),('1','294',91,'MORNING SHIFT','2022-10-22','2022-10-31 15:18:43','2022-11-01 15:18:43','966',316200.00,316200.00,'966','2022-10-31 15:19:20','614','2022-10-31 15:19:49',10,0),('1','294',92,'AFTERNOON SHIFT ','2022-10-22','2022-10-31 15:26:51','2022-11-01 15:26:51','966',804888.00,804888.00,'966','2022-10-31 15:27:35','614','2022-10-31 15:28:30',10,0),('1','294',93,'MORNING SHIFT','2022-10-23','2022-10-31 15:29:10','2022-11-01 15:29:10','966',936360.00,936360.00,'966','2022-10-31 15:29:51','614','2022-10-31 15:30:37',10,0),('1','294',94,'AFTERNOON SHIFT','2022-10-23','2022-10-31 15:31:56','2022-11-01 15:31:56','966',1354600.00,1354600.00,'966','2022-10-31 15:32:37','614','2022-10-31 15:36:45',10,0),('1','294',95,'MORNING SHIFT','2022-10-24','2022-10-31 15:40:16','2022-11-01 15:40:16','966',1043168.00,1043168.00,'966','2022-10-31 15:40:53','614','2022-10-31 15:41:27',10,0),('1','294',96,'AFTERNOON SHIFT','2022-10-24','2022-10-31 15:41:59','2022-11-01 15:41:59','966',1502944.00,1502944.00,'966','2022-10-31 15:53:56','614','2022-10-31 15:56:20',10,0),('1','294',97,'MORNING SHIFT ','2022-10-25','2022-10-31 16:37:32','2022-11-01 16:37:32','966',904800.00,904800.00,'966','2022-10-31 16:38:40','614','2022-10-31 22:32:15',10,0),('1','294',98,'AFTERNOON SHIFT ','2022-10-25','2022-11-01 11:59:50','2022-11-02 11:59:50','966',2495896.00,2495896.00,'966','2022-11-01 12:01:54','614','2022-11-01 13:35:11',10,0),('1','294',99,'MORNING SHIFT','2022-10-26','2022-11-01 14:07:43','2022-11-02 14:07:43','966',1280112.00,1280112.00,'966','2022-11-01 14:08:38','614','2022-11-01 14:36:50',10,0),('1','294',100,'AFTERNOON SHIFT ','2022-10-26','2022-11-01 17:34:08','2022-11-02 17:34:08','966',2075352.00,2075352.00,'966','2022-11-01 17:35:36','614','2022-11-01 17:46:57',10,0),('1','294',101,'AFTERNOON SHIFT','2022-10-30','2022-11-01 17:51:31','2022-11-02 17:51:31','966',2245952.00,2245952.00,'966','2022-11-01 18:03:47','614','2022-11-01 18:04:34',10,0),('1','294',102,'MORNING SHIFT ','2022-10-31','2022-11-01 18:06:20','2022-11-02 18:06:20','966',607200.00,607200.00,'966','2022-11-01 18:06:55','614','2022-11-01 18:07:47',10,0),('1','294',103,'AFTERNOON SHIFT','2022-10-31','2022-11-01 18:08:27','2022-11-02 18:08:27','966',1470688.00,1470688.00,'966','2022-11-01 18:09:36','614','2022-11-01 18:10:14',10,0),('1','294',104,'MORNING SHIFT','2022-11-01','2022-11-01 18:10:47','2022-11-02 18:10:47','966',318600.00,318600.00,'966','2022-11-01 18:11:22','614','2022-11-01 18:12:03',10,0),('1','294',105,'AFTERNOON SHIFT ','2022-11-01','2022-11-04 16:32:16','2022-11-05 16:32:16','966',3037920.00,3037920.00,'966','2022-11-04 16:33:43','614','2022-11-04 23:53:33',10,0),('1','294',106,'MORNING SHIFT','2022-11-02','2022-11-05 10:12:09','2022-11-06 10:12:09','966',2265224.00,2265224.00,'966','2022-11-05 10:13:25','614','2022-11-05 10:20:30',10,0),('1','294',107,'AFTERNOON SHIFT ','2022-11-02','2022-11-05 10:24:48','2022-11-06 10:24:48','966',6101576.00,6101576.00,'966','2022-11-05 10:26:23','614','2022-11-05 10:37:26',10,0),('1','294',108,'MORNING SHIFT','2022-11-03','2022-11-05 10:38:41','2022-11-06 10:38:41','966',1531120.00,1531120.00,'966','2022-11-05 10:39:35','614','2022-11-05 10:43:59',10,0),('1','294',109,'AFTERNOON SHIFT ','2022-11-03','2022-11-05 10:44:27','2022-11-06 10:44:27','966',4902736.00,4902736.00,'966','2022-11-05 10:45:46','614','2022-11-05 15:30:30',10,0),('1','294',110,'MORNING SHIFT','2022-11-04','2022-11-07 19:55:59','2022-11-08 19:55:59','966',812600.00,812600.00,'966','2022-11-07 19:57:26','614','2022-11-07 20:00:21',10,0),('1','294',111,'AFTERNOON SHIFT ','2022-11-04','2022-11-07 20:04:02','2022-11-08 20:04:02','966',5056176.00,5056176.00,'966','2022-11-07 20:39:18','614','2022-11-07 20:40:14',10,0),('1','294',112,'AFTERNOON SHIFT ','2022-11-07','2022-11-08 06:28:08','2022-11-09 06:28:08','966',2446061.20,2446061.20,'966','2022-11-08 06:30:50','614','2022-11-08 06:32:59',10,0),('1','294',113,'MORNING SHIFT','2022-11-08','2022-11-08 16:13:46','2022-11-09 16:13:46','966',4545203.60,4545203.60,'966','2022-11-08 16:25:59','614','2022-11-08 16:27:19',10,0),('1','294',114,'AFTERNOON SHIFT ','2022-11-08','2022-11-09 08:56:10','2022-11-10 08:56:10','966',5341018.40,5341018.40,'966','2022-11-09 09:06:44','614','2022-11-09 11:45:47',10,0),('1','294',115,'MORNING SHIFT','2022-11-09','2022-11-09 14:24:30','2022-11-10 14:24:30','966',4040852.75,4040852.75,'966','2022-11-09 14:27:11','614','2022-11-09 17:45:22',10,0),('1','294',116,'AFTERNOON SHIFT ','2022-11-09','2022-11-10 13:18:33','2022-11-11 13:18:33','966',5598772.40,5598772.40,'966','2022-11-10 13:21:38','614','2022-11-10 13:33:25',10,0),('1','294',117,'MORNING SHIFT','2022-11-10','2022-11-10 16:12:14','2022-11-11 16:12:14','966',7566360.35,7566360.35,'966','2022-11-10 16:15:30','614','2022-11-10 20:09:30',10,0),('1','294',118,'AFTERNOON SHIFT ','2022-11-10','2022-11-11 13:58:32','2022-11-12 13:58:32','966',3289014.70,3289014.70,'966','2022-11-11 14:01:36','614','2022-11-11 15:36:06',10,0),('1','294',119,'MORNING SHIFT','2022-11-11','2022-11-11 17:31:24','2022-11-12 17:31:24','966',2435709.20,2435709.20,'966','2022-11-11 17:32:58','614','2022-11-11 18:26:10',10,0),('1','294',120,'AFTERNOON SHIFT ','2022-11-11','2022-11-12 08:43:56','2022-11-13 08:43:56','966',2984759.00,2984759.00,'966','2022-11-12 08:45:52','614','2022-11-12 09:38:29',10,0),('1','294',121,'MORNING SHIFT','2022-11-12','2022-11-12 15:02:01','2022-11-13 15:02:01','966',719871.60,719871.60,'966','2022-11-12 15:05:57','614','2022-11-13 07:48:18',10,0),('1','294',122,'AFTERNOON SHIFT ','2022-11-12','2022-11-13 08:15:42','2022-11-14 08:15:42','966',1625451.60,1625451.60,'966','2022-11-13 08:17:05','614','2022-11-13 15:00:57',10,0),('1','294',123,'MORNING SHIFT','2022-11-13','2022-11-13 15:05:28','2022-11-14 15:05:28','966',545265.80,545265.80,'966','2022-11-13 15:06:05','614','2022-11-13 15:19:17',10,0),('1','294',124,'AFTERNOON SHIFT ','2022-11-13','2022-11-13 21:31:47','2022-11-14 21:31:47','966',1284444.40,1284444.40,'966','2022-11-13 21:33:05','614','2022-11-13 23:25:59',10,0),('1','294',125,'MORNING SHIFT','2022-11-14','2022-11-14 14:47:14','2022-11-15 14:47:14','966',1405334.60,1405334.60,'966','2022-11-14 14:47:58','614','2022-11-14 20:09:46',10,0),('1','294',126,'AFTERNOON SHIFT ','2022-11-14','2022-11-15 09:24:48','2022-11-16 09:24:48','966',1952200.00,1952200.00,'966','2022-11-15 09:30:02','614','2022-11-15 10:47:49',10,0),('1','294',127,'MORNING SHIFT','2022-11-15','2022-11-15 14:36:50','2022-11-16 14:36:50','966',1389785.80,1389785.80,'966','2022-11-15 14:37:41','614','2022-11-15 18:48:17',10,0),('1','294',128,'AFTERNOON SHIFT ','2022-11-15','2022-11-16 13:32:33','2022-11-17 13:32:33','966',1585074.60,1585074.60,'966','2022-11-16 13:35:43','614','2022-11-16 14:11:48',10,0),('1','294',129,'MORNING SHIFT','2022-11-16','2022-11-16 17:38:47','2022-11-17 17:38:47','966',2953018.45,2953018.45,'966','2022-11-16 17:43:12','975','2022-11-16 20:29:43',10,0),('1','294',130,'AFTERNOON SHIFT ','2022-11-16','2022-11-17 11:43:33','2022-11-18 11:43:33','966',2323031.20,2323031.20,'966','2022-11-17 11:55:58','614','2022-11-17 14:42:24',10,0),('1','294',131,'MORNING SHIFT','2022-11-17','2022-11-17 16:38:58','2022-11-18 16:38:58','966',3402279.75,3402279.75,'966','2022-11-17 16:41:15','975','2022-11-17 17:31:33',10,0),('1','294',132,'AFTERNOON SHIFT ','2022-11-17','2022-11-18 08:08:02','2022-11-19 08:08:02','966',1312187.25,1312187.25,'966','2022-11-18 08:09:42','614','2022-11-18 12:21:26',10,0),('1','294',133,'MORNING SHIFT','2022-11-18','2022-11-18 17:01:17','2022-11-19 17:01:17','966',2972659.10,2972659.10,'966','2022-11-18 17:03:12','614','2022-11-18 21:30:37',10,0),('1','294',134,'AFTERNOON SHIFT 1','2022-11-18','2022-11-19 06:57:34','2022-11-20 06:57:34','966',2442239.25,2442239.25,'966','2022-11-19 06:59:02','614','2022-11-19 12:32:54',10,0),('1','294',135,'AFTERNOON SHIFT 2','2022-11-18','2022-11-19 12:44:21','2022-11-20 12:44:21','966',1764159.60,1764159.60,'966','2022-11-19 12:45:25','614','2022-11-19 13:10:36',10,0),('1','294',136,'MORNING SHIFT','2022-11-19','2022-11-19 14:22:08','2022-11-20 14:22:08','966',1010200.80,1010200.80,'966','2022-11-19 14:22:50','614','2022-11-19 18:55:12',10,0),('1','294',137,'AFTERNOON SHIFT ','2022-11-19','2022-11-20 06:07:18','2022-11-21 06:07:18','966',1256001.60,1256001.60,'966','2022-11-20 06:08:54','614','2022-11-20 15:42:30',10,0),('1','294',138,'MORNING SHIFT','2022-11-20','2022-11-20 16:23:34','2022-11-21 16:23:34','966',1731458.40,1731458.40,'966','2022-11-20 16:24:46','614','2022-11-20 23:02:17',10,0),('1','294',139,'AFTERNOON SHIFT ','2022-11-20','2022-11-21 06:44:29','2022-11-22 06:44:29','966',2268924.00,2268924.00,'966','2022-11-21 06:46:01','614','2022-11-21 11:22:43',10,0),('1','294',140,'MORNING SHIFT','2022-11-21','2022-11-21 13:18:19','2022-11-22 13:18:19','966',4837812.00,4837812.00,'966','2022-11-21 13:21:59','614','2022-11-21 15:40:00',10,0),('1','294',141,'AFTERNOON SHIFT ','2022-11-21','2022-11-22 06:21:36','2022-11-23 06:21:36','966',2139496.80,2139496.80,'966','2022-11-22 06:22:53','614','2022-11-22 16:43:00',10,0),('1','294',142,'MORNING SHIFT','2022-11-22','2022-11-22 20:37:18','2022-11-23 20:37:18','966',2122957.20,2122957.20,'966','2022-11-22 20:40:56','614','2022-11-23 12:31:03',10,0),('1','294',143,'AFTERNOON SHIFT ','2022-11-22','2022-11-23 12:40:11','2022-11-24 12:40:11','966',1543752.00,1543752.00,'966','2022-11-23 12:41:37','614','2022-11-23 14:35:18',10,0),('1','294',144,'MORNING SHIFT','2022-11-23','2022-11-23 14:54:29','2022-11-24 14:54:29','966',1232985.60,1232985.60,'966','2022-11-23 14:56:45','614','2022-11-23 15:17:13',10,0),('1','294',145,'AFTERNOON SHIFT ','2022-11-23','2022-11-24 09:43:14','2022-11-25 09:43:14','966',2833378.80,2833378.80,'966','2022-11-24 09:45:59','614','2022-11-24 09:50:56',10,0),('1','294',146,'MORNING SHIFT','2022-11-24','2022-11-24 13:42:28','2022-11-25 13:42:28','966',1984466.40,1984466.40,'966','2022-11-24 13:44:57','614','2022-11-24 14:44:32',10,0),('1','294',147,'AFTERNOON SHIFT ','2022-11-24','2022-11-25 06:14:57','2022-11-26 06:14:57','966',2346642.40,2346642.40,'966','2022-11-25 06:16:19','614','2022-11-25 15:07:01',10,0),('1','294',148,'MORNING SHIFT','2022-11-25','2022-11-25 15:26:51','2022-11-26 15:26:51','966',485707.70,485707.70,'966','2022-11-25 15:28:39','614','2022-11-25 19:22:03',10,0),('1','294',149,'AFTERNOON SHIFT ','2022-11-25','2022-11-26 10:00:37','2022-11-27 10:00:37','966',3331055.60,3331055.60,'966','2022-11-26 10:01:53','614','2022-11-26 11:09:16',10,0),('1','294',150,'MORNING SHIFT','2022-11-26','2022-11-26 15:21:30','2022-11-27 15:21:30','966',1574319.10,1574319.10,'966','2022-11-26 15:22:57','614','2022-11-26 16:25:18',10,0),('1','294',151,'AFTERNOON SHIFT ','2022-11-26','2022-11-27 08:03:34','2022-11-28 08:03:34','966',1145400.00,1145400.00,'966','2022-11-27 14:33:57','614','2022-11-27 21:54:30',10,0),('1','294',152,'MORNING SHIFT','2022-11-27','2022-11-28 10:45:21','2022-11-29 10:45:21','966',498946.20,498946.20,'966','2022-11-28 10:46:54','614','2022-11-28 17:57:00',10,0),('1','294',153,'MORNING SHIFT','2022-11-30','2022-11-30 16:24:35','2022-12-01 16:24:35','966',2595835.20,2595835.20,'966','2022-11-30 16:28:53','975','2022-12-01 09:07:39',10,0),('1','294',154,'AFTERNOON SHIFT ','2022-11-30','2022-12-01 09:43:11','2022-12-02 09:43:11','966',3307953.60,3307953.60,'966','2022-12-01 09:44:22','975','2022-12-01 13:41:28',10,0),('1','294',155,'MORNING SHIFT','2022-12-01','2022-12-01 14:25:49','2022-12-02 14:25:49','966',1702806.00,1702806.00,'966','2022-12-01 14:27:04','975','2022-12-02 10:36:10',10,0),('1','294',156,'AFTERNOON SHIFT ','2022-12-01','2022-12-02 14:41:06','2022-12-03 14:41:06','966',2580958.80,2580958.80,'966','2022-12-02 14:42:34','975','2022-12-02 15:37:16',10,0),('1','294',157,'MORNING SHIFT','2022-12-02','2022-12-02 16:29:19','2022-12-03 16:29:19','966',1937544.00,1937544.00,'966','2022-12-02 16:33:03','975','2022-12-03 13:41:51',10,0),('1','294',158,'AFTERNOON SHIFT ','2022-12-02','2022-12-03 14:50:50','2022-12-04 14:50:50','966',2630728.80,2630728.80,'966','2022-12-03 14:52:55','975','2022-12-03 21:12:06',10,0),('1','294',159,'MORNING SHIFT','2022-12-03','2022-12-04 08:52:14','2022-12-05 08:52:14','966',1965075.80,1965075.80,'966','2022-12-04 09:00:46','975','2022-12-04 09:43:42',10,0),('1','294',160,'AFTERNOON SHIFT 1','2022-12-03','2022-12-04 10:43:14','2022-12-05 10:43:14','966',2123365.40,2123365.40,'966','2022-12-04 10:47:40','975','2022-12-04 12:23:45',10,0),('1','294',161,'AFTERNOON SHIFT 2','2022-12-03','2022-12-04 13:45:22','2022-12-05 13:45:22','966',1270825.60,1270825.60,'966','2022-12-04 13:50:48','975','2022-12-05 05:51:36',10,0),('1','294',162,'MORNING SHIFT','2022-12-04','2022-12-05 10:16:59','2022-12-06 10:16:59','966',2078894.40,2078894.40,'966','2022-12-05 10:24:49','975','2022-12-05 10:31:32',10,0),('1','294',163,'AFTERNOON SHIFT ','2022-12-04','2022-12-05 10:43:33','2022-12-06 10:43:33','966',1794927.20,1794927.20,'966','2022-12-05 10:44:49','975','2022-12-05 10:46:38',10,0),('1','294',164,'MORNING SHIFT','2022-12-05','2022-12-05 16:17:26','2022-12-06 16:17:26','966',1644605.60,1644605.60,'966','2022-12-05 16:21:00','975','2022-12-05 17:51:39',10,0),('1','294',165,'AFTERNOON SHIFT ','2022-12-05','2022-12-06 06:22:09','2022-12-07 06:22:09','966',1802583.20,1802583.20,'966','2022-12-06 06:23:12','975','2022-12-06 10:11:10',10,0),('1','294',166,'MORNING SHIFT','2022-12-06','2022-12-06 19:38:02','2022-12-07 19:38:02','966',2747302.80,2747302.80,'966','2022-12-06 19:39:59','975','2022-12-06 20:24:29',10,0),('1','294',167,'AFTERNOON SHIFT 1','2022-12-06','2022-12-07 09:39:33','2022-12-08 09:39:33','966',2501444.00,2501444.00,'966','2022-12-07 09:42:03','975','2022-12-07 11:09:46',10,0),('1','294',168,'AFTERNOON SHIFT 2','2022-12-06','2022-12-07 11:50:57','2022-12-08 11:50:57','966',1344630.00,1344630.00,'966','2022-12-07 11:57:46','975','2022-12-07 14:03:04',10,0),('1','294',169,'MORNING SHIFT','2022-12-07','2022-12-07 14:10:29','2022-12-08 14:10:29','966',1234897.40,1234897.40,'966','2022-12-07 14:11:59','975','2022-12-07 15:41:13',10,0),('1','294',170,'AFTERNOON SHIFT ','2022-12-14','2022-12-19 13:39:24','2022-12-20 13:39:24','966',5663174.20,5663174.20,'966','2022-12-19 13:42:15','975','2022-12-19 13:43:05',10,0),('1','294',171,'MORNING SHIFT','2022-12-15','2022-12-19 13:45:14','2022-12-20 13:45:14','966',1784746.40,1784746.40,'966','2022-12-19 13:46:38','975','2022-12-19 13:48:54',10,0),('1','294',172,'AFTERNOON SHIFT ','2022-12-15','2022-12-19 13:50:01','2022-12-20 13:50:01','966',7926226.60,7926226.60,'966','2022-12-19 13:52:22','975','2022-12-19 13:53:50',10,0),('1','294',173,'MORNING SHIFT','2022-12-16','2022-12-19 13:55:50','2022-12-20 13:55:50','966',2172483.40,2172483.40,'966','2022-12-19 13:59:16','975','2022-12-19 14:06:37',10,0),('1','294',174,'AFTERNOON SHIFT ','2022-12-16','2022-12-19 14:08:33','2022-12-20 14:08:33','966',1993157.60,1993157.60,'966','2022-12-19 14:09:51','975','2022-12-19 14:34:47',10,0),('1','294',175,'MORNING SHIFT','2022-12-17','2022-12-19 14:36:12','2022-12-20 14:36:12','966',2277500.80,2277500.80,'966','2022-12-19 14:37:32','975','2022-12-19 18:31:20',10,0),('1','294',176,'AFTERNOON SHIFT ','2022-12-17','2022-12-19 20:42:32','2022-12-20 20:42:32','966',2932000.20,2932000.20,'966','2022-12-19 20:44:41','975','2022-12-20 10:39:21',10,0),('1','294',177,'MORNING SHIFT','2022-12-21','2022-12-22 10:38:30','2022-12-23 10:38:30','966',3546903.60,3546903.60,'966','2022-12-22 10:43:24','975','2022-12-22 15:17:30',10,0),('1','294',178,'AFTERNOON SHIFT ','2022-12-21','2022-12-22 15:37:38','2022-12-23 15:37:38','966',3529175.20,3529175.20,'966','2022-12-22 15:40:45','975','2022-12-22 19:50:01',10,0),('1','294',179,'MORNING SHIFT','2022-12-22','2022-12-22 20:13:19','2022-12-23 20:13:19','966',4299551.00,4299551.00,'966','2022-12-22 20:15:29','975','2022-12-23 11:50:15',10,0),('1','294',180,'AFTERNOON SHIFT ','2022-12-22','2022-12-23 12:18:22','2022-12-24 12:18:22','966',4889699.60,4889699.60,'966','2022-12-23 12:21:03','975','2022-12-23 16:34:56',10,0),('1','294',181,'MORNING SHIFT','2022-12-23','2022-12-23 20:25:57','2022-12-24 20:25:57','966',1580427.00,1580427.00,'966','2022-12-23 20:26:35','975','2022-12-24 09:55:33',10,0),('1','294',182,'AFTERNOON SHIFT ','2022-12-23','2022-12-24 10:01:16','2022-12-25 10:01:16','966',3610952.00,3610952.00,'966','2022-12-24 10:02:55','975','2022-12-24 13:13:15',10,0),('1','294',183,'MORNING SHIFT','2022-12-24','2022-12-24 13:49:23','2022-12-25 13:49:23','966',3357859.00,3357859.00,'966','2022-12-24 13:50:59','975','2022-12-24 15:38:41',10,0),('1','294',184,'AFTERNOON SHIFT ','2022-12-24','2022-12-24 23:12:50','2022-12-25 23:12:50','966',2423493.60,2423493.60,'966','2022-12-24 23:14:00','975','2022-12-25 06:58:50',10,0),('1','294',185,'MORNING SHIFT','2022-12-25','2022-12-25 14:35:55','2022-12-26 14:35:55','966',3530337.80,3530337.80,'966','2022-12-25 14:36:51','975','2022-12-26 08:23:41',10,0),('1','294',186,'AFTERNOON SHIFT ','2022-12-25','2022-12-26 10:27:13','2022-12-27 10:27:13','966',3644727.80,3644727.80,'966','2022-12-26 10:28:53','975','2022-12-26 18:53:49',10,0),('1','294',187,'MORNING SHIFT','2022-12-26','2022-12-26 22:53:10','2022-12-27 22:53:10','966',1972477.20,1972477.20,'966','2022-12-26 23:40:15','975','2022-12-27 10:16:17',10,0),('1','294',188,'AFTERNOON SHIFT ','2022-12-27','2022-12-27 12:19:58','2022-12-28 12:19:58','966',5382348.80,5382348.80,'966','2022-12-27 12:25:48','975','2022-12-27 13:10:20',10,0),('1','294',189,'MORNING SHIFT','2022-12-27','2022-12-27 15:32:09','2022-12-28 15:32:09','966',6020439.10,6020439.10,'966','2022-12-27 15:37:17','975','2022-12-28 11:29:21',10,0),('1','294',190,'AFTERNOON SHIFT ','2022-12-27','2022-12-28 11:38:04','2022-12-29 11:38:04','966',7374086.40,7374086.40,'966','2022-12-28 11:41:09','975','2022-12-28 15:44:58',10,0),('1','294',191,'MORNING SHIFT','2022-12-28','2022-12-28 16:19:58','2022-12-29 16:19:58','966',3819824.25,3819824.25,'966','2022-12-28 16:23:12','975','2022-12-29 12:27:10',10,0),('1','294',192,'AFTERNOON SHIFT ','2022-12-28','2022-12-29 13:56:37','2022-12-30 13:56:37','966',10162709.95,10162709.95,'966','2022-12-29 14:02:07','975','2022-12-29 15:09:08',10,0),('1','294',193,'MORNING SHIFT','2022-12-29','2022-12-29 15:13:43','2022-12-30 15:13:43','966',4430003.25,4430003.25,'966','2022-12-29 15:16:50','975','2022-12-29 16:29:27',10,0),('1','294',194,'AFTERNOON SHIFT ','2022-12-29','2022-12-30 09:27:55','2022-12-31 09:27:55','966',3727260.80,3727260.80,'966','2022-12-30 09:29:45','975','2022-12-30 11:39:12',10,0),('1','294',195,'MORNING SHIFT','2022-12-30','2022-12-30 15:21:19','2022-12-31 15:21:19','966',2807950.60,2807950.60,'966','2022-12-30 15:22:36','975','2022-12-30 19:33:07',10,0),('1','294',196,'AFTERNOON SHIFT ','2022-12-30','2022-12-31 08:08:57','2023-01-01 08:08:57','966',6373282.45,6373282.45,'966','2022-12-31 15:23:38','975','2022-12-31 16:56:32',10,0),('1','294',197,'MORNING SHIFT','2022-12-31','2022-12-31 20:30:38','2023-01-01 20:30:38','966',5695444.60,5695444.60,'966','2022-12-31 20:32:44','975','2023-01-01 12:32:41',10,0),('1','294',198,'AFTERNOON SHIFT ','2022-12-31','2023-01-01 16:35:32','2023-01-02 16:35:32','966',3203606.85,3203606.85,'966','2023-01-01 16:37:12','975','2023-01-02 10:47:18',10,0),('1','294',199,'MORNING SHIFT','2023-01-01','2023-01-02 11:13:58','2023-01-03 11:13:58','966',6662823.80,6662823.80,'966','2023-01-02 11:16:53','975','2023-01-02 12:58:08',10,0),('1','294',200,'AFTERNOON SHIFT ','2023-01-01','2023-01-02 16:00:58','2023-01-03 16:00:58','966',5034203.40,5034203.40,'966','2023-01-02 18:02:01','975','2023-01-03 13:16:23',10,0),('1','294',201,'MORNING SHIFT','2023-01-02','2023-01-03 13:44:00','2023-01-04 13:44:00','966',6571246.00,6571246.00,'966','2023-01-03 14:48:33','975','2023-01-04 10:31:55',10,0),('1','294',202,'AFTERNOON SHIFT ','2023-01-02','2023-01-04 11:19:37','2023-01-05 11:19:37','966',2413048.15,2413048.15,'966','2023-01-04 11:21:39','975','2023-01-04 12:13:42',10,0),('1','294',203,'MORNING SHIFT','2023-01-03','2023-01-05 11:29:00','2023-01-06 11:29:00','966',1938529.10,1938529.10,'966','2023-01-05 11:30:21','975','2023-01-05 20:22:16',10,0),('1','294',204,'AFTERNOON SHIFT ','2023-01-06','2023-01-07 10:48:03','2023-01-08 10:48:03','966',1689109.80,1689109.80,'966','2023-01-07 10:49:21','975','2023-01-07 14:44:16',10,0),('1','294',205,'MORNING SHIFT','2023-01-07','2023-01-07 15:30:02','2023-01-08 15:30:02','966',4764429.60,4764429.60,'966','2023-01-07 15:31:19','975','2023-01-08 09:59:08',10,0),('1','294',206,'AFTERNOON SHIFT ','2023-01-07','2023-01-08 10:08:16','2023-01-09 10:08:16','966',2609190.80,2609190.80,'966','2023-01-08 10:10:15','975','2023-01-09 09:36:20',10,0),('1','294',207,'MORNING SHIFT','2023-01-08','2023-01-09 10:00:15','2023-01-10 10:00:15','966',3989947.80,3989947.80,'966','2023-01-09 10:03:36','975','2023-01-09 11:32:59',10,0),('1','294',208,'AFTERNOON SHIFT ','2023-01-08','2023-01-09 14:13:17','2023-01-10 14:13:17','966',3353340.80,3353340.80,'966','2023-01-09 14:14:47','975','2023-01-09 17:03:04',10,0),('1','294',209,'MORNING SHIFT','2023-01-09','2023-01-10 07:40:39','2023-01-11 07:40:39','966',106600.00,106600.00,'966','2023-01-10 07:41:49','975','2023-01-10 09:50:40',10,0),('1','294',210,'MORNING SHIFT','2023-01-10','2023-01-10 14:26:22','2023-01-11 14:26:22','966',2848888.55,2848888.55,'966','2023-01-10 14:28:37','975','2023-01-10 14:37:24',10,0),('1','294',211,'AFTERNOON SHIFT ','2023-01-10','2023-01-11 07:52:06','2023-01-12 07:52:06','966',2846618.45,2846618.45,'966','2023-01-11 07:54:14','975','2023-01-11 10:14:46',10,0),('1','294',212,'MORNING SHIFT','2023-01-11','2023-01-11 14:16:52','2023-01-12 14:16:52','966',2631280.90,2631280.90,'966','2023-01-11 18:35:03','975','2023-01-12 12:25:48',10,0),('1','294',213,'AFTERNOON SHIFT ','2023-01-11','2023-01-12 13:21:47','2023-01-13 13:21:47','966',3440397.65,3440397.65,'966','2023-01-12 13:24:19','975','2023-01-12 15:20:17',10,0),('1','294',214,'MORNING SHIFT','2023-01-12','2023-01-12 16:47:52','2023-01-13 16:47:52','966',3779070.25,3779070.25,'966','2023-01-12 16:50:20','975','2023-01-13 10:38:05',10,0),('1','294',215,'AFTERNOON SHIFT ','2023-01-12','2023-01-13 14:18:00','2023-01-14 14:18:00','966',3245237.20,3245237.20,'966','2023-01-13 14:22:37','975','2023-01-13 21:50:53',10,0),('1','294',216,'AFTERNOON SHIFT ','2023-01-13','2023-01-14 17:21:05','2023-01-15 17:21:05','966',1209008.00,1209008.00,'966','2023-01-14 17:22:24','975','2023-01-14 17:38:51',10,0),('1','294',217,'MORNING SHIFT','2023-01-14','2023-01-15 06:28:47','2023-01-16 06:28:47','966',2185013.00,2185013.00,'966','2023-01-15 06:29:58','975','2023-01-15 12:29:44',10,0),('1','294',218,'AFTERNOON SHIFT','2023-01-14','2023-01-15 12:45:31','2023-01-16 12:45:31','966',3557570.00,3557570.00,'966','2023-01-15 12:52:09','975','2023-01-15 13:57:13',10,0),('1','294',219,'MORNING SHIFT','2023-01-15','2023-01-15 18:00:19','2023-01-16 18:00:19','966',4601134.80,4601134.80,'966','2023-01-15 18:10:08','975','2023-01-16 09:18:36',10,0),('1','294',220,'AFTERNOON SHIFT ','2023-01-15','2023-01-16 10:13:22','2023-01-17 10:13:22','966',2382116.40,2382116.40,'966','2023-01-16 10:15:23','734','2023-01-16 12:54:54',10,0),('1','294',221,'MORNING SHIFT','2023-01-16','2023-01-16 14:26:44','2023-01-17 14:26:44','966',3095172.00,3095172.00,'966','2023-01-16 14:27:37','734','2023-01-16 14:59:37',10,0),('1','294',222,'AFTERNOON SHIFT ','2023-01-16','2023-01-17 11:03:35','2023-01-18 11:03:35','966',5859055.80,5859055.80,'966','2023-01-17 11:05:41','734','2023-01-17 11:53:09',10,0),('1','294',223,'MORNING SHIFT','2023-01-17','2023-01-17 18:26:57','2023-01-18 18:26:57','966',3025521.20,3025521.20,'966','2023-01-17 18:28:10','734','2023-01-17 19:40:59',10,0),('1','294',224,'AFTERNOON SHIFT 1','2023-01-17','2023-01-18 10:02:45','2023-01-19 10:02:45','966',4275652.20,4275652.20,'966','2023-01-18 10:03:48','734','2023-01-18 12:34:17',10,0),('1','294',225,'AFTERNOON SHIFT 2','2023-01-17','2023-01-18 13:34:16','2023-01-19 13:34:16','966',1810163.70,1810163.70,'966','2023-01-18 13:35:38','734','2023-01-18 14:23:26',10,0),('1','294',226,'MORNING SHIFT','2023-01-18','2023-01-18 16:01:16','2023-01-19 16:01:16','966',1874178.00,1874178.00,'966','2023-01-18 16:02:36','734','2023-01-18 18:53:09',10,0),('1','294',227,'AFTERNOON SHIFT ','2023-01-18','2023-01-19 11:19:48','2023-01-20 11:19:48','966',5687439.30,5687439.30,'966','2023-01-19 11:21:04','734','2023-01-19 14:31:25',10,0),('1','294',228,'MORNING SHIFT','2023-01-19','2023-01-19 15:37:13','2023-01-20 15:37:13','966',7444739.80,7444739.80,'966','2023-01-19 15:39:38','734','2023-01-19 16:48:02',10,0),('1','294',229,'AFTERNOON SHIFT ','2023-01-19','2023-01-20 09:18:25','2023-01-21 09:18:25','966',6208155.90,6208155.90,'966','2023-01-20 09:19:38','734','2023-01-20 09:46:54',10,0),('1','294',230,'MORNING SHIFT','2023-01-20','2023-01-21 10:47:53','2023-01-22 10:47:53','966',74805.20,74805.20,'966','2023-01-21 18:22:32','734','2023-01-22 11:11:04',10,0),('1','294',231,'MORNING SHIFT','2023-01-21','2023-01-22 11:39:43','2023-01-23 11:39:43','966',4624370.50,4624370.50,'966','2023-01-22 12:14:34','734','2023-01-22 12:31:49',10,0),('1','294',232,'AFTERNOON SHIFT ','2023-01-21','2023-01-22 21:16:20','2023-01-23 21:16:20','966',5424570.80,5424570.80,'966','2023-01-22 21:20:46','734','2023-01-22 21:22:39',10,0),('1','294',233,'MORNING SHIFT','2023-01-22','2023-01-22 21:26:12','2023-01-23 21:26:12','966',289813.75,289813.75,'966','2023-01-22 21:27:49','734','2023-01-22 21:35:05',10,0),('1','294',234,'MORNING SHIFT','2023-01-28','2023-01-28 14:54:02','2023-01-29 14:54:02','966',1629888.50,1629888.50,'966','2023-01-28 14:55:27','734','2023-01-28 15:04:59',10,0),('1','294',235,'AFTERNOON SHIFT','2023-01-28','2023-01-29 10:50:16','2023-01-30 10:50:16','966',4891387.70,4891387.70,'966','2023-01-29 10:53:18','734','2023-01-29 14:33:30',10,0),('1','294',236,'MORNING SHIFT','2023-01-29','2023-01-29 17:06:56','2023-01-30 17:06:56','966',864181.00,864181.00,'966','2023-01-29 17:08:25','734','2023-01-29 18:53:42',10,0),('1','294',237,'AFTERNOON SHIFT','2023-01-29','2023-01-30 10:19:37','2023-01-31 10:19:37','966',2464760.50,2464760.50,'966','2023-01-30 10:20:39','734','2023-01-30 10:53:05',10,0),('1','294',238,'MORNING SHIFT','2023-01-30','2023-01-30 15:16:06','2023-01-31 15:16:06','966',3412681.50,3412681.50,'966','2023-01-30 15:17:11','734','2023-01-30 16:03:19',10,0),('1','294',239,'AFTERNOON SHIFT','2023-01-30','2023-01-30 21:18:46','2023-01-31 21:18:46','966',342386.00,342386.00,'966','2023-01-30 21:23:09','734','2023-01-30 21:24:01',10,0),('1','294',240,'MORNING SHIFT','2023-01-31','2023-01-31 18:33:29','2023-02-01 18:33:29','966',5025972.50,5025972.50,'966','2023-01-31 18:39:44','734','2023-01-31 22:31:13',10,0),('1','294',241,'AFTERNOON SHIFT','2023-01-31','2023-02-01 08:39:35','2023-02-02 08:39:35','966',2171995.00,2171995.00,'966','2023-02-01 08:41:47','734','2023-02-01 09:34:08',10,0),('1','294',242,'MORNING SHIFT','2023-02-01','2023-02-02 11:54:26','2023-02-03 11:54:26','966',302202.50,302202.50,'966','2023-02-02 11:57:15','734','2023-02-02 12:52:53',10,0),('1','294',243,'MORNING SHIFT','2023-02-07','2023-02-07 18:33:25','2023-02-08 18:33:25','966',3381892.00,3381892.00,'966','2023-02-07 18:37:51','734','2023-02-07 19:55:45',10,0),('1','294',244,'MORNING SHIFT','2023-02-08','2023-02-08 16:42:37','2023-02-09 16:42:37','966',3757350.00,3757350.00,'966','2023-02-08 16:46:18','734','2023-02-08 17:14:58',10,0),('1','294',245,'AFTERNOON SHIFT ','2023-02-08','2023-02-08 20:43:12','2023-02-09 20:43:12','966',2887488.00,2887488.00,'966','2023-02-08 20:44:57','734','2023-02-08 21:10:45',10,0),('1','294',246,'AFTERNOON SHIFT ','2023-02-09','2023-02-10 10:49:59','2023-02-11 10:49:59','966',1782824.00,1782824.00,'966','2023-02-10 10:51:21','734','2023-02-10 12:01:44',10,0),('1','294',247,'MORNING SHIFT','2023-02-10','2023-02-10 15:18:10','2023-02-11 15:18:10','966',2506424.00,2506424.00,'966','2023-02-10 15:19:08','734','2023-02-10 15:21:55',10,0),('1','294',248,'AFTERNOON SHIFT ','2023-02-10','2023-02-11 07:44:23','2023-02-12 07:44:23','966',3768064.00,3768064.00,'966','2023-02-11 07:46:31','734','2023-02-11 09:27:28',10,0),('1','294',249,'MORNING SHIFT','2023-02-11','2023-02-11 15:18:36','2023-02-12 15:18:36','966',4214000.00,4214000.00,'966','2023-02-11 15:19:35','734','2023-02-11 15:26:49',10,0),('1','294',250,'AFTERNOON SHIFT','2023-02-11','2023-02-12 11:15:11','2023-02-13 11:15:11','966',4569368.00,4569368.00,'966','2023-02-12 11:18:23','734','2023-02-12 13:54:55',10,0),('1','294',251,'MORNING SHIFT','2023-02-12','2023-02-12 13:56:09','2023-02-13 13:56:09','966',1519608.00,1519608.00,'966','2023-02-12 13:57:32','734','2023-02-12 13:59:37',10,0),('1','294',252,'AFTERNOON SHIFT ','2023-02-12','2023-02-13 09:33:20','2023-02-14 09:33:20','966',2893392.00,2893392.00,'966','2023-02-13 09:34:21','734','2023-02-13 14:44:14',10,0),('1','294',253,'MORNING SHIFT','2023-02-13','2023-02-13 16:26:14','2023-02-14 16:26:14','966',830008.00,830008.00,'966','2023-02-13 16:27:28','734','2023-02-13 19:16:15',10,0),('1','294',254,'AFTERNOON SHIFT','2023-02-13','2023-02-14 11:32:21','2023-02-15 11:32:21','966',2109016.00,2109016.00,'966','2023-02-14 11:33:32','734','2023-02-14 15:29:50',10,0),('1','294',255,'MORNING SHIFT','2023-02-14','2023-02-14 21:43:47','2023-02-15 21:43:47','966',2392608.00,2392608.00,'966','2023-02-14 21:45:16','734','2023-02-14 23:19:55',10,0),('1','294',256,'AFTERNOON SHIFT ','2023-02-14','2023-02-15 11:05:11','2023-02-16 11:05:11','966',2005168.00,2005168.00,'966','2023-02-15 11:06:14','734','2023-02-15 14:35:49',10,0),('1','294',257,'MORNING SHIFT','2023-02-15','2023-02-15 15:04:55','2023-02-16 15:04:55','966',3390520.00,3390520.00,'966','2023-02-15 15:05:44','734','2023-02-15 15:44:38',10,0),('1','294',258,'AFTERNOON SHIFT ','2023-02-15','2023-02-16 09:59:03','2023-02-17 09:59:03','966',2028176.00,2028176.00,'966','2023-02-16 10:00:55','734','2023-02-16 11:53:54',10,0),('1','294',259,'MORNING SHIFT','2023-02-16','2023-02-16 21:34:19','2023-02-17 21:34:19','966',5995012.00,5995012.00,'966','2023-02-16 22:43:48','734','2023-02-17 08:18:40',10,0),('1','294',260,'MORNING SHIFT','2023-02-17','2023-02-18 09:29:34','2023-02-19 09:29:34','966',3147986.00,3147986.00,'966','2023-02-18 09:34:18','734','2023-02-18 14:35:15',10,0),('1','294',261,'MORNING SHIFT','2023-02-18','2023-02-18 20:12:49','2023-02-19 20:12:49','966',2192340.00,2192340.00,'966','2023-02-18 20:14:00','734','2023-02-18 21:41:10',10,0),('1','294',262,'MORNING SHIFT','2023-02-19','2023-02-19 18:27:49','2023-02-20 18:27:49','966',3176530.00,3176530.00,'966','2023-02-19 18:32:56','734','2023-02-19 21:27:26',10,0),('1','294',263,'MORNING SHIFT','2023-02-20','2023-02-21 10:38:25','2023-02-22 10:38:25','966',5731810.00,5731810.00,'966','2023-02-21 10:42:15','734','2023-02-21 15:36:04',10,0),('1','294',264,'MORNING SHIFT','2023-02-21','2023-02-22 08:13:23','2023-02-23 08:13:23','966',6713742.00,6713742.00,'966','2023-02-22 11:49:21','734','2023-02-22 12:25:35',10,0),('1','294',265,'MORNING SHIFT','2023-02-22','2023-02-23 13:33:09','2023-02-24 13:33:09','966',6965044.00,6965044.00,'966','2023-02-23 13:36:03','734','2023-02-23 16:10:56',10,0),('1','294',266,'MORNING SHIFT','2023-02-23','2023-02-24 10:40:34','2023-02-25 10:40:34','966',3551550.00,3551550.00,'966','2023-02-24 10:44:03','734','2023-02-24 15:28:14',10,0),('1','294',267,'MORNING SHIFT','2023-02-24','2023-02-25 19:30:07','2023-02-26 19:30:07','966',5064866.00,5064866.00,'966','2023-02-25 20:23:00','734','2023-02-25 20:39:50',10,0),('1','294',268,'MORNING SHIFT','2023-02-25','2023-02-26 09:04:04','2023-02-27 09:04:04','966',1710000.00,1710000.00,'966','2023-02-26 09:13:12','734','2023-02-26 10:53:18',10,0),('1','294',269,'MORNING SHIFT','2023-02-26','2023-02-27 07:54:52','2023-02-28 07:54:52','966',2481820.00,2481820.00,'966','2023-02-27 07:58:02','734','2023-02-27 15:50:50',10,0),('1','294',270,'MORNING SHIFT','2023-02-27','2023-02-27 18:16:18','2023-02-28 18:16:18','966',2637212.00,2637212.00,'966','2023-02-27 18:20:34','734','2023-02-27 20:08:51',10,0),('1','294',271,'AFTERNOON SHIFT ','2023-02-27','2023-02-27 23:14:22','2023-02-28 23:14:22','966',2142920.00,2142920.00,'966','2023-02-28 11:06:47','734','2023-02-28 14:12:43',10,0),('1','294',272,'MORNING SHIFT','2023-02-28','2023-02-28 16:38:59','2023-03-01 16:38:59','966',3595058.00,3595058.00,'966','2023-02-28 16:41:16','734','2023-02-28 17:08:27',10,0),('1','294',273,'AFTERNOON SHIFT ','2023-02-28','2023-02-28 21:29:27','2023-03-01 21:29:27','966',1123438.00,1123438.00,'966','2023-02-28 21:31:54','734','2023-02-28 22:33:18',10,0),('1','294',274,'MORNING SHIFT','2023-03-03','2023-03-03 20:48:34','2023-03-04 20:48:34','966',2888652.00,2888652.00,'966','2023-03-03 20:51:10','734','2023-03-03 20:54:45',10,0),('1','294',275,'AFTERNOON SHIFT ','2023-03-03','2023-03-04 09:25:04','2023-03-05 09:25:04','966',1078696.00,1078696.00,'966','2023-03-04 09:27:46','734','2023-03-04 10:07:19',10,0),('1','294',276,'MORNING SHIFT','2023-03-04','2023-03-04 16:28:44','2023-03-05 16:28:44','966',2691196.00,2691196.00,'966','2023-03-04 16:39:04','734','2023-03-04 17:55:12',10,0),('1','294',277,'AFTERNOON SHIFT ','2023-03-04','2023-03-05 11:44:21','2023-03-06 11:44:21','966',2192208.00,2192208.00,'966','2023-03-05 11:45:15','734','2023-03-05 14:27:00',10,0),('1','294',278,'MORNING SHIFT','2023-03-05','2023-03-05 15:42:54','2023-03-06 15:42:54','966',1416800.00,1416800.00,'966','2023-03-05 15:44:49','734','2023-03-05 16:09:26',10,0),('1','294',279,'AFTERNOON SHIFT ','2023-03-05','2023-03-06 10:17:04','2023-03-07 10:17:04','966',2252240.00,2252240.00,'966','2023-03-06 10:18:22','734','2023-03-06 11:44:30',10,0),('1','294',280,'MORNING SHIFT','2023-03-06','2023-03-06 16:41:25','2023-03-07 16:41:25','966',1326808.00,1326808.00,'966','2023-03-06 16:42:27','734','2023-03-06 21:05:34',10,0),('1','294',281,'AFTERNOON SHIFT ','2023-03-06','2023-03-06 21:53:53','2023-03-07 21:53:53','966',2610632.00,2610632.00,'966','2023-03-06 21:55:33','734','2023-03-06 22:22:48',10,0),('1','294',282,'MORNING SHIFT','2023-03-07','2023-03-07 17:55:42','2023-03-08 17:55:42','966',1344912.00,1344912.00,'966','2023-03-07 17:56:46','734','2023-03-07 18:18:16',10,0),('1','294',283,'AFTERNOON SHIFT ','2023-03-07','2023-03-08 09:29:57','2023-03-09 09:29:57','966',1965896.00,1965896.00,'966','2023-03-08 09:31:40','734','2023-03-08 17:49:28',10,0),('1','294',284,'MORNING SHIFT','2023-03-08','2023-03-08 19:25:34','2023-03-09 19:25:34','966',1116920.00,1116920.00,'966','2023-03-08 19:26:28','734','2023-03-09 02:10:56',10,0),('1','294',285,'AFTERNOON SHIFT ','2023-03-08','2023-03-09 06:22:19','2023-03-10 06:22:19','966',3766240.00,3766240.00,'966','2023-03-09 06:23:59','734','2023-03-09 07:59:39',10,0),('1','294',286,'MORNING SHIFT','2023-03-09','2023-03-09 17:01:12','2023-03-10 17:01:12','966',3635220.00,3635220.00,'966','2023-03-09 17:04:32','734','2023-03-09 19:05:19',10,0),('1','294',287,'AFTERNOON SHIFT ','2023-03-09','2023-03-10 09:29:31','2023-03-11 09:29:31','966',6757958.00,6757958.00,'966','2023-03-10 09:39:44','734','2023-03-10 10:44:23',10,0),('1','294',288,'MORNING SHIFT','2023-03-10','2023-03-10 19:29:47','2023-03-11 19:29:47','966',4248872.00,4248872.00,'966','2023-03-10 21:12:21','734','2023-03-10 21:50:00',10,0),('1','294',289,'AFTERNOON SHIFT','2023-03-10','2023-03-11 08:10:03','2023-03-12 08:10:03','966',911822.00,911822.00,'966','2023-03-11 08:13:23','734','2023-03-11 15:37:10',10,0),('1','294',290,'MORNING SHIFT','2023-03-11','2023-03-11 20:38:31','2023-03-12 20:38:31','966',2387444.00,2387444.00,'966','2023-03-11 20:41:04','734','2023-03-11 22:18:21',10,0),('1','294',291,'MORNING SHIFT','2023-03-12','2023-03-12 15:43:36','2023-03-13 15:43:36','966',2381510.00,2381510.00,'966','2023-03-12 15:47:32','734','2023-03-12 18:34:20',10,0),('1','294',292,'AFTERNOON SHIFT ','2023-03-12','2023-03-13 15:02:37','2023-03-14 15:02:37','966',1924496.00,1924496.00,'966','2023-03-13 15:04:58','734','2023-03-13 15:20:08',10,0),('1','294',293,'MORNING SHIFT','2023-03-13','2023-03-13 16:45:27','2023-03-14 16:45:27','966',2053312.00,2053312.00,'966','2023-03-13 16:47:15','734','2023-03-13 17:22:58',10,0),('1','294',294,'AFTERNOON SHIFT ','2023-03-13','2023-03-13 21:25:11','2023-03-14 21:25:11','966',1323260.00,1323260.00,'966','2023-03-13 21:28:37','734','2023-03-13 22:55:42',10,0),('1','294',295,'MORNING SHIFT','2023-03-14','2023-03-14 16:35:43','2023-03-15 16:35:43','966',3908272.00,3908272.00,'966','2023-03-14 16:45:25','734','2023-03-14 18:45:26',10,0),('1','294',296,'AFTERNOON SHIFT ','2023-03-14','2023-03-14 21:55:56','2023-03-15 21:55:56','966',4634670.00,4634670.00,'966','2023-03-14 21:57:44','734','2023-03-14 22:11:07',10,0),('1','294',297,'MORNING SHIFT','2023-03-15','2023-03-15 15:12:10','2023-03-16 15:12:10','966',4351082.00,4351082.00,'966','2023-03-15 15:15:34','734','2023-03-15 16:28:17',10,0),('1','294',298,'AFTERNOON SHIFT ','2023-03-15','2023-03-16 08:24:29','2023-03-17 08:24:29','966',3689504.00,3689504.00,'966','2023-03-16 08:25:57','734','2023-03-16 08:31:35',10,0),('1','294',299,'MORNING SHIFT','2023-03-16','2023-03-16 13:53:33','2023-03-17 13:53:33','966',1523400.00,1523400.00,'966','2023-03-16 13:58:57','734','2023-03-16 14:59:56',10,0),('1','294',300,'AFTERNOON SHIFT ','2023-03-16','2023-03-16 18:18:40','2023-03-17 18:18:40','966',289696.00,289696.00,'966','2023-03-16 18:26:59','734','2023-03-16 21:05:20',10,0),('1','294',301,'MORNING SHIFT','2023-03-17','2023-03-19 15:16:26','2023-03-20 15:16:26','966',4321876.00,4321876.00,'966','2023-03-19 15:21:27','734','2023-03-19 15:27:07',10,0),('1','294',302,'AFTERNOON SHIFT','2023-03-17','2023-03-19 15:29:55','2023-03-20 15:29:55','966',1696684.00,1696684.00,'966','2023-03-19 15:35:43','734','2023-03-19 16:25:54',10,0),('1','294',303,'MORNING SHIFT','2023-03-19','2023-03-19 16:27:51','2023-03-20 16:27:51','966',2908778.00,2908778.00,'966','2023-03-19 16:32:34','734','2023-03-19 16:35:58',10,0),('1','294',304,'MORNING SHIFT','2023-03-20','2023-03-20 13:28:41','2023-03-21 13:28:41','966',742504.00,742504.00,'966','2023-03-20 13:42:42','734','2023-03-20 15:18:08',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=6081 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','294','1','1',1,'1','1',1066.51,1066.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','1',2,'2','1',789.39,789.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','1',3,'3','1',984.22,984.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','1',4,'4','1',1716.90,1716.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','1',5,'5','1',839.37,839.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','1',6,'6','1',638.91,770.31,131.40,22995.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','1',7,'7','1',981.71,1084.97,103.26,18070.50,0.00,0.00,0.00,0.00,0.00),('1','294','1','1',8,'8','1',1299.80,1299.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','1',9,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','1',10,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','1',11,'11','1',700.46,898.12,197.66,34590.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','1',12,'12','1',2063.40,2237.06,173.66,30390.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','1',13,'13','1',983.23,983.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','1',14,'14','1',907.00,952.71,45.71,7999.25,0.00,0.00,0.00,0.00,0.00),('1','294','2','1',15,'15','1',859.70,859.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','1',16,'16','1',1567.40,1567.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','1',17,'17','2',914.28,914.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','1',18,'18','2',730.26,730.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','1',19,'19','2',856.00,856.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','1',20,'20','2',851.36,851.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','2',21,'1','1',1066.51,1066.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','2',22,'2','1',789.39,789.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','2',23,'3','1',984.22,984.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','2',24,'4','1',1716.90,1716.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','2',25,'5','1',839.37,839.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','2',26,'6','1',770.31,1082.13,311.82,54568.50,0.00,0.00,0.00,0.00,0.00),('1','294','1','2',27,'7','1',1084.97,1203.17,118.20,20685.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','2',28,'8','1',1299.80,1299.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','2',29,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','2',30,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','2',31,'11','1',898.12,1558.20,660.08,115514.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','2',32,'12','1',2237.06,3467.09,1230.03,215255.25,0.00,0.00,0.00,0.00,0.00),('1','294','2','2',33,'13','1',983.23,983.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','2',34,'14','1',952.71,2301.83,1349.12,236096.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','2',35,'15','1',859.70,859.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','2',36,'16','1',1567.40,1567.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','2',37,'17','2',914.28,2111.64,1197.36,904006.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','2',38,'18','2',730.26,730.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','2',39,'19','2',856.00,856.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','2',40,'20','2',851.36,851.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','3',41,'1','1',1066.51,1066.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','3',42,'2','1',789.39,789.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','3',43,'3','1',984.22,984.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','3',44,'4','1',1716.90,1716.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','3',45,'5','1',839.37,839.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','3',46,'6','1',1082.13,1092.27,10.14,1774.50,0.00,0.00,0.00,0.00,0.00),('1','294','1','3',47,'7','1',1203.17,1203.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','3',48,'8','1',1299.80,1299.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','3',49,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','3',50,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','3',51,'11','1',1558.20,1622.63,64.43,11275.25,0.00,0.00,0.00,0.00,0.00),('1','294','2','3',52,'12','1',3467.09,4025.03,557.94,97639.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','3',53,'13','1',983.23,983.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','3',54,'14','1',2301.83,2301.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','3',55,'15','1',859.70,859.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','3',56,'16','1',1567.40,2007.78,440.38,77066.50,0.00,0.00,0.00,0.00,0.00),('1','294','3','3',57,'17','2',2111.64,2305.46,193.82,146334.10,0.00,0.00,0.00,0.00,0.00),('1','294','3','3',58,'18','2',730.26,820.26,90.00,67950.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','3',59,'19','2',856.00,856.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','3',60,'20','2',851.36,851.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','4',61,'1','1',1066.51,1066.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','4',62,'2','1',789.39,789.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','4',63,'3','1',984.22,984.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','4',64,'4','1',1716.90,1716.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','4',65,'5','1',839.37,839.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','4',66,'6','1',1092.27,2116.10,963.83,168670.25,0.00,0.00,60.00,0.00,0.00),('1','294','1','4',67,'7','1',1203.17,1203.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','4',68,'8','1',1299.80,1309.80,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','294','2','4',69,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','4',70,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','4',71,'11','1',1622.63,3632.42,1949.79,341213.25,0.00,0.00,60.00,0.00,0.00),('1','294','2','4',72,'12','1',4025.03,5719.18,1664.15,291226.25,0.00,0.00,30.00,0.00,0.00),('1','294','2','4',73,'13','1',983.23,983.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','4',74,'14','1',2301.83,4326.95,1965.12,343896.00,0.00,0.00,60.00,0.00,0.00),('1','294','2','4',75,'15','1',859.70,1760.51,880.81,154141.75,0.00,0.00,20.00,0.00,0.00),('1','294','2','4',76,'16','1',2007.78,3028.45,980.67,171617.25,0.00,0.00,40.00,0.00,0.00),('1','294','3','4',77,'17','2',2305.46,2941.27,635.81,480036.55,0.00,0.00,0.00,0.00,0.00),('1','294','3','4',78,'18','2',820.26,1924.27,1104.01,833527.55,0.00,0.00,0.00,0.00,0.00),('1','294','3','4',79,'19','2',856.00,856.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','4',80,'20','2',851.36,851.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','5',81,'1','1',1066.51,1066.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','5',82,'2','1',789.39,1375.76,586.37,102614.75,0.00,0.00,0.00,0.00,0.00),('1','294','1','5',83,'3','1',984.22,984.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','5',84,'4','1',1716.90,1716.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','5',85,'5','1',839.37,839.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','5',86,'6','1',2116.10,2116.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','5',87,'7','1',1203.17,1203.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','5',88,'8','1',1309.80,1309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','5',89,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','5',90,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','5',91,'11','1',3632.42,3632.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','5',92,'12','1',5719.18,6816.54,1097.36,192038.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','5',93,'13','1',983.23,983.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','5',94,'14','1',4326.95,4326.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','5',95,'15','1',1760.51,1760.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','5',96,'16','1',3028.45,3028.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','5',97,'17','2',2941.27,3074.30,133.03,100437.65,0.00,0.00,0.00,0.00,0.00),('1','294','3','5',98,'18','2',1924.27,1924.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','5',99,'19','2',856.00,856.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','5',100,'20','2',851.36,851.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','6',101,'1','1',1066.51,1066.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','6',102,'2','1',1375.76,1375.76,-10.00,-1750.00,0.00,0.00,10.00,0.00,0.00),('1','294','1','6',103,'3','1',984.22,984.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','6',104,'4','1',1716.90,1716.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','6',105,'5','1',839.37,839.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','6',106,'6','1',2116.10,2116.10,-10.00,-1750.00,0.00,0.00,10.00,0.00,0.00),('1','294','1','6',107,'7','1',1203.17,1203.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','6',108,'8','1',1309.80,1309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','6',109,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','6',110,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','6',111,'11','1',3632.42,3632.42,-10.00,-1750.00,0.00,0.00,10.00,0.00,0.00),('1','294','2','6',112,'12','1',6816.54,6816.54,-10.00,-1750.00,0.00,0.00,10.00,0.00,0.00),('1','294','2','6',113,'13','1',983.23,983.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','6',114,'14','1',4326.95,4326.95,-5.00,-875.00,0.00,0.00,5.00,0.00,0.00),('1','294','2','6',115,'15','1',1760.51,1760.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','6',116,'16','1',3028.45,3028.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','6',117,'17','2',3074.30,3074.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','6',118,'18','2',1924.27,1924.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','6',119,'19','2',856.00,856.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','6',120,'20','2',851.36,851.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','7',121,'1','1',1066.51,1066.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','7',122,'2','1',1375.76,2538.73,1152.97,201769.75,0.00,0.00,10.00,0.00,0.00),('1','294','1','7',123,'3','1',984.22,984.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','7',124,'4','1',1716.90,1814.90,98.00,17150.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','7',125,'5','1',839.37,858.52,19.15,3351.25,0.00,0.00,0.00,0.00,0.00),('1','294','1','7',126,'6','1',2116.10,2194.29,68.19,11933.25,0.00,0.00,10.00,0.00,0.00),('1','294','1','7',127,'7','1',1203.17,1203.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','7',128,'8','1',1309.80,1309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','7',129,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','7',130,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','7',131,'11','1',3632.42,5599.05,1956.63,342410.25,0.00,0.00,10.00,0.00,0.00),('1','294','2','7',132,'12','1',6816.54,8973.55,2147.01,375726.75,0.00,0.00,10.00,0.00,0.00),('1','294','2','7',133,'13','1',983.23,983.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','7',134,'14','1',4326.95,6144.33,1812.38,317166.50,0.00,0.00,5.00,0.00,0.00),('1','294','2','7',135,'15','1',1760.51,2434.45,673.94,117939.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','7',136,'16','1',3028.45,4135.03,1106.58,193651.50,0.00,0.00,0.00,0.00,0.00),('1','294','3','7',137,'17','2',3074.30,6283.00,3208.70,2422568.50,0.00,0.00,0.00,0.00,0.00),('1','294','3','7',138,'18','2',1924.27,1954.27,30.00,22650.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','7',139,'19','2',856.00,856.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','7',140,'20','2',851.36,851.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','8',141,'1','1',1066.51,1066.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','8',142,'2','1',2538.73,2538.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','8',143,'3','1',984.22,984.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','8',144,'4','1',1814.90,1814.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','8',145,'5','1',858.52,858.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','8',146,'6','1',2194.29,2194.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','8',147,'7','1',1203.17,1203.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','8',148,'8','1',1309.80,1309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','8',149,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','8',150,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','8',151,'11','1',5599.05,5599.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','8',152,'12','1',8973.55,9783.79,810.24,141792.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','8',153,'13','1',983.23,983.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','8',154,'14','1',6144.33,6792.09,647.76,113358.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','8',155,'15','1',2434.45,2434.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','8',156,'16','1',4135.03,4135.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','8',157,'17','2',6283.00,6283.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','8',158,'18','2',1954.27,1954.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','8',159,'19','2',856.00,856.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','8',160,'20','2',851.36,851.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','9',161,'1','1',1066.51,1066.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','9',162,'2','1',2538.73,2538.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','9',163,'3','1',984.22,984.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','9',164,'4','1',1814.90,1814.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','9',165,'5','1',858.52,858.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','9',166,'6','1',2194.29,2194.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','9',167,'7','1',1203.17,1218.17,15.00,2625.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','9',168,'8','1',1309.80,1309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','9',169,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','9',170,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','9',171,'11','1',5599.05,7666.36,2067.31,361779.25,0.00,0.00,0.00,0.00,0.00),('1','294','2','9',172,'12','1',9783.79,12102.93,2319.14,405849.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','9',173,'13','1',983.23,983.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','9',174,'14','1',6792.09,8712.69,1920.60,336105.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','9',175,'15','1',2434.45,4396.81,1962.36,343413.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','9',176,'16','1',4135.03,5496.48,1361.45,238253.75,0.00,0.00,0.00,0.00,0.00),('1','294','3','9',177,'17','2',6283.00,8147.12,1864.12,1407410.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','9',178,'18','2',1954.27,1954.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','9',179,'19','2',856.00,1402.01,546.01,412237.55,0.00,0.00,0.00,0.00,0.00),('1','294','3','9',180,'20','2',851.36,874.36,23.00,17365.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','10',181,'1','1',1066.51,1066.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','10',182,'2','1',2538.73,2538.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','10',183,'3','1',984.22,984.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','10',184,'4','1',1814.90,1814.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','10',185,'5','1',858.52,858.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','10',186,'6','1',2194.29,2194.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','10',187,'7','1',1218.17,1218.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','10',188,'8','1',1309.80,1309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','10',189,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','10',190,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','10',191,'11','1',7666.36,8050.58,384.22,67238.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','10',192,'12','1',12102.93,12102.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','10',193,'13','1',983.23,983.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','10',194,'14','1',8712.69,9985.40,1272.71,222724.25,0.00,0.00,0.00,0.00,0.00),('1','294','2','10',195,'15','1',4396.81,4438.73,41.92,7336.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','10',196,'16','1',5496.48,5496.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','10',197,'17','2',8147.12,8749.60,602.48,454872.40,0.00,0.00,0.00,0.00,0.00),('1','294','3','10',198,'18','2',1954.27,1954.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','10',199,'19','2',1402.01,1402.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','10',200,'20','2',874.36,874.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','11',201,'1','1',1066.51,1066.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','11',202,'2','1',2538.73,4172.76,1634.03,285955.25,0.00,0.00,0.00,0.00,0.00),('1','294','1','11',203,'3','1',984.22,2266.43,1282.21,224386.75,0.00,0.00,0.00,0.00,0.00),('1','294','1','11',204,'4','1',1814.90,1814.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','11',205,'5','1',858.52,2314.38,1455.86,254775.50,0.00,0.00,0.00,0.00,0.00),('1','294','1','11',206,'6','1',2194.29,2194.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','11',207,'7','1',1218.17,1392.96,174.79,30588.25,0.00,0.00,0.00,0.00,0.00),('1','294','1','11',208,'8','1',1309.80,1309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','11',209,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','11',210,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','11',211,'11','1',8050.58,8050.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','11',212,'12','1',12102.93,12102.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','11',213,'13','1',983.23,983.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','11',214,'14','1',9985.40,9985.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','11',215,'15','1',4438.73,4438.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','11',216,'16','1',5496.48,5496.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','11',217,'17','2',8749.60,9698.34,948.74,716298.70,0.00,0.00,0.00,0.00,0.00),('1','294','3','11',218,'18','2',1954.27,1954.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','11',219,'19','2',1402.01,1402.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','11',220,'20','2',874.36,874.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','12',221,'1','1',1066.51,1066.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','12',222,'2','1',4172.76,6347.54,2174.78,380586.50,0.00,0.00,0.00,0.00,0.00),('1','294','1','12',223,'3','1',2266.43,3917.06,1650.63,288860.25,0.00,0.00,0.00,0.00,0.00),('1','294','1','12',224,'4','1',1814.90,1814.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','12',225,'5','1',2314.38,3636.51,1322.13,231372.75,0.00,0.00,0.00,0.00,0.00),('1','294','1','12',226,'6','1',2194.29,2194.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','12',227,'7','1',1392.96,1719.86,326.90,57207.50,0.00,0.00,0.00,0.00,0.00),('1','294','1','12',228,'8','1',1309.80,1309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','12',229,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','12',230,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','12',231,'11','1',8050.58,8050.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','12',232,'12','1',12102.93,12102.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','12',233,'13','1',983.23,983.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','12',234,'14','1',9985.40,9985.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','12',235,'15','1',4438.73,4438.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','12',236,'16','1',5496.48,5496.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','12',237,'17','2',9698.34,10443.80,745.46,562822.30,0.00,0.00,0.00,0.00,0.00),('1','294','3','12',238,'18','2',1954.27,1954.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','12',239,'19','2',1402.01,1402.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','12',240,'20','2',874.36,874.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','13',241,'1','1',1066.51,1148.79,82.28,14399.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','13',242,'2','1',6347.54,7949.54,1602.00,280350.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','13',243,'3','1',3917.06,5229.80,1312.74,229729.50,0.00,0.00,0.00,0.00,0.00),('1','294','1','13',244,'4','1',1814.90,1814.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','13',245,'5','1',3636.51,3636.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','13',246,'6','1',2194.29,3554.89,1360.60,238105.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','13',247,'7','1',1719.86,2513.89,794.03,138955.25,0.00,0.00,0.00,0.00,0.00),('1','294','1','13',248,'8','1',1309.80,1309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','13',249,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','13',250,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','13',251,'11','1',8050.58,8050.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','13',252,'12','1',12102.93,12102.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','13',253,'13','1',983.23,983.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','13',254,'14','1',9985.40,9985.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','13',255,'15','1',4438.73,4438.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','13',256,'16','1',5496.48,5496.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','13',257,'17','2',10443.80,11152.54,708.74,535098.70,0.00,0.00,0.00,0.00,0.00),('1','294','3','13',258,'18','2',1954.27,1974.29,20.02,15115.10,0.00,0.00,0.00,0.00,0.00),('1','294','3','13',259,'19','2',1402.01,1442.01,40.00,30200.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','13',260,'20','2',874.36,894.36,20.00,15100.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','14',261,'1','1',1148.79,1552.68,403.89,70680.75,0.00,0.00,0.00,0.00,0.00),('1','294','1','14',262,'2','1',7949.54,10676.92,2727.38,477291.50,0.00,0.00,0.00,0.00,0.00),('1','294','1','14',263,'3','1',5229.80,5229.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','14',264,'4','1',1814.90,2294.13,479.23,83865.25,0.00,0.00,0.00,0.00,0.00),('1','294','1','14',265,'5','1',3636.51,5577.49,1940.98,339671.50,0.00,0.00,0.00,0.00,0.00),('1','294','1','14',266,'6','1',3554.89,3554.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','14',267,'7','1',2513.89,2513.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','14',268,'8','1',1309.80,1309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','14',269,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','14',270,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','14',271,'11','1',8050.58,8050.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','14',272,'12','1',12102.93,12102.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','14',273,'13','1',983.23,983.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','14',274,'14','1',9985.40,9985.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','14',275,'15','1',4438.73,4438.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','14',276,'16','1',5496.48,5496.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','14',277,'17','2',11152.54,11958.16,805.62,608243.10,0.00,0.00,0.00,0.00,0.00),('1','294','3','14',278,'18','2',1974.29,1974.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','14',279,'19','2',1442.01,1442.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','14',280,'20','2',894.36,894.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','15',281,'1','1',1552.68,1552.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','15',282,'2','1',10676.92,12121.54,1444.62,252808.50,0.00,0.00,0.00,0.00,0.00),('1','294','1','15',283,'3','1',5229.80,6905.84,1676.04,293307.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','15',284,'4','1',2294.13,2294.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','15',285,'5','1',5577.49,5577.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','15',286,'6','1',3554.89,4941.17,1386.28,242599.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','15',287,'7','1',2513.89,2513.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','15',288,'8','1',1309.80,1309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','15',289,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','15',290,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','15',291,'11','1',8050.58,8050.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','15',292,'12','1',12102.93,12102.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','15',293,'13','1',983.23,983.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','15',294,'14','1',9985.40,9985.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','15',295,'15','1',4438.73,4438.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','15',296,'16','1',5496.48,5496.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','15',297,'17','2',11958.16,12947.50,989.34,746951.70,0.00,0.00,0.00,0.00,0.00),('1','294','3','15',298,'18','2',1974.29,1974.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','15',299,'19','2',1442.01,1442.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','15',300,'20','2',894.36,894.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','16',301,'1','1',1552.68,1871.86,319.18,55856.50,0.00,0.00,0.00,0.00,0.00),('1','294','1','16',302,'2','1',12121.54,13163.20,1041.66,182290.50,0.00,0.00,0.00,0.00,0.00),('1','294','1','16',303,'3','1',6905.84,8032.90,1127.06,197235.50,0.00,0.00,0.00,0.00,0.00),('1','294','1','16',304,'4','1',2294.13,2294.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','16',305,'5','1',5577.49,6617.13,1039.64,181937.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','16',306,'6','1',4941.17,4941.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','16',307,'7','1',2513.89,2513.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','16',308,'8','1',1309.80,1309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','16',309,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','16',310,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','16',311,'11','1',8050.58,8050.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','16',312,'12','1',12102.93,12382.64,279.71,48949.25,0.00,0.00,0.00,0.00,0.00),('1','294','2','16',313,'13','1',983.23,983.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','16',314,'14','1',9985.40,11024.48,1039.08,181839.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','16',315,'15','1',4438.73,4722.65,283.92,49686.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','16',316,'16','1',5496.48,6018.08,521.60,91280.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','16',317,'17','2',12947.50,14364.78,1417.28,1070046.40,0.00,0.00,0.00,0.00,0.00),('1','294','3','16',318,'18','2',1974.29,1974.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','16',319,'19','2',1442.01,1442.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','16',320,'20','2',894.36,894.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','17',321,'1','1',1871.86,1871.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','17',322,'2','1',13163.20,13163.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','17',323,'3','1',8032.90,8032.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','17',324,'4','1',2294.13,2294.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','17',325,'5','1',6617.13,6617.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','17',326,'6','1',4941.17,4941.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','17',327,'7','1',2513.89,2513.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','17',328,'8','1',1309.80,1309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','17',329,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','17',330,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','17',331,'11','1',8050.58,8250.45,199.87,34977.25,0.00,0.00,0.00,0.00,0.00),('1','294','2','17',332,'12','1',12382.64,15003.90,2621.26,458720.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','17',333,'13','1',983.23,1151.05,167.82,29368.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','17',334,'14','1',11024.48,13158.44,2133.96,373443.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','17',335,'15','1',4722.65,5147.81,425.16,74403.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','17',336,'16','1',6018.08,7578.63,1560.55,273096.25,0.00,0.00,0.00,0.00,0.00),('1','294','3','17',337,'17','2',14364.78,14869.95,505.17,381403.35,0.00,0.00,0.00,0.00,0.00),('1','294','3','17',338,'18','2',1974.29,1974.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','17',339,'19','2',1442.01,1742.01,300.00,226500.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','17',340,'20','2',894.36,894.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','18',341,'1','1',1871.86,1871.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','18',342,'2','1',13163.20,13163.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','18',343,'3','1',8032.90,8032.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','18',344,'4','1',2294.13,2294.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','18',345,'5','1',6617.13,6617.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','18',346,'6','1',4941.17,4941.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','18',347,'7','1',2513.89,2513.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','18',348,'8','1',1309.80,1309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','18',349,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','18',350,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','18',351,'11','1',8250.45,10037.13,1786.68,312669.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','18',352,'12','1',15003.90,15760.32,756.42,132373.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','18',353,'13','1',1151.05,1151.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','18',354,'14','1',13158.44,16151.05,2992.61,523706.75,0.00,0.00,0.00,0.00,0.00),('1','294','2','18',355,'15','1',5147.81,5230.66,82.85,14498.75,0.00,0.00,0.00,0.00,0.00),('1','294','2','18',356,'16','1',7578.63,9543.68,1965.05,343883.75,0.00,0.00,0.00,0.00,0.00),('1','294','3','18',357,'17','2',14869.95,16357.13,1487.18,1122820.90,0.00,0.00,0.00,0.00,0.00),('1','294','3','18',358,'18','2',1974.29,2342.29,368.00,277840.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','18',359,'19','2',1742.01,1742.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','18',360,'20','2',894.36,894.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','19',361,'1','1',1871.86,1871.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','19',362,'2','1',13163.20,13163.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','19',363,'3','1',8032.90,8032.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','19',364,'4','1',2294.13,2294.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','19',365,'5','1',6617.13,6617.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','19',366,'6','1',4941.17,4941.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','19',367,'7','1',2513.89,2513.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','19',368,'8','1',1309.80,1309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','19',369,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','19',370,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','19',371,'11','1',10037.13,10651.77,614.64,107562.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','19',372,'12','1',15760.32,18026.27,2265.95,396541.25,0.00,0.00,0.00,0.00,0.00),('1','294','2','19',373,'13','1',1151.05,1151.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','19',374,'14','1',16151.05,18643.82,2492.77,436234.75,0.00,0.00,0.00,0.00,0.00),('1','294','2','19',375,'15','1',5230.66,5329.51,98.85,17298.75,0.00,0.00,0.00,0.00,0.00),('1','294','2','19',376,'16','1',9543.68,11246.72,1703.04,298032.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','19',377,'17','2',16357.13,16958.10,600.97,453732.35,0.00,0.00,0.00,0.00,0.00),('1','294','3','19',378,'18','2',2342.29,2342.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','19',379,'19','2',1742.01,1742.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','19',380,'20','2',894.36,894.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','20',381,'1','1',1871.86,1871.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','20',382,'2','1',13163.20,13163.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','20',383,'3','1',8032.90,8032.92,0.02,3.50,0.00,0.00,0.00,0.00,0.00),('1','294','1','20',384,'4','1',2294.13,2294.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','20',385,'5','1',6617.13,6617.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','20',386,'6','1',4941.17,4941.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','20',387,'7','1',2513.89,2513.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','20',388,'8','1',1309.80,1309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','20',389,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','20',390,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','20',391,'11','1',10651.77,12801.02,2149.25,376118.75,0.00,0.00,0.00,0.00,0.00),('1','294','2','20',392,'12','1',18026.27,19904.85,1878.58,328751.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','20',393,'13','1',1151.05,1703.47,552.42,96673.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','20',394,'14','1',18643.82,21375.45,2731.63,478035.25,0.00,0.00,0.00,0.00,0.00),('1','294','2','20',395,'15','1',5329.51,5329.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','20',396,'16','1',11246.72,12400.02,1153.30,201827.50,0.00,0.00,0.00,0.00,0.00),('1','294','3','20',397,'17','2',16958.10,17970.90,1012.80,764664.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','20',398,'18','2',2342.29,2372.37,30.08,22710.40,0.00,0.00,0.00,0.00,0.00),('1','294','3','20',399,'19','2',1742.01,2377.37,635.36,479696.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','20',400,'20','2',894.36,894.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','21',401,'1','1',1871.86,1871.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','21',402,'2','1',13163.20,13163.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','21',403,'3','1',8032.92,8032.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','21',404,'4','1',2294.13,2294.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','21',405,'5','1',6617.13,6617.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','21',406,'6','1',4941.17,4941.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','21',407,'7','1',2513.89,2513.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','21',408,'8','1',1309.80,1309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','21',409,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','21',410,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','21',411,'11','1',12801.02,13302.54,501.52,87766.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','21',412,'12','1',19904.85,22237.15,2332.30,408152.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','21',413,'13','1',1703.47,1703.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','21',414,'14','1',21375.45,23714.19,2338.74,409279.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','21',415,'15','1',5329.51,5329.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','21',416,'16','1',12400.02,13610.11,1210.09,211765.75,0.00,0.00,0.00,0.00,0.00),('1','294','3','21',417,'17','2',17970.90,18326.40,355.50,268402.50,0.00,0.00,0.00,0.00,0.00),('1','294','3','21',418,'18','2',2372.37,2372.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','21',419,'19','2',2377.37,2377.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','21',420,'20','2',894.36,894.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','22',421,'1','1',1871.86,2297.18,425.32,74431.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','22',422,'2','1',13163.20,14489.56,1326.36,232113.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','22',423,'3','1',8032.92,9177.37,1144.45,200278.75,0.00,0.00,0.00,0.00,0.00),('1','294','1','22',424,'4','1',2294.13,2515.92,221.79,38813.25,0.00,0.00,0.00,0.00,0.00),('1','294','1','22',425,'5','1',6617.13,7119.06,501.93,87837.75,0.00,0.00,0.00,0.00,0.00),('1','294','1','22',426,'6','1',4941.17,4941.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','22',427,'7','1',2513.89,2560.45,46.56,8148.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','22',428,'8','1',1309.80,1309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','22',429,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','22',430,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','22',431,'11','1',13302.54,13751.15,438.61,76756.75,0.00,0.00,10.00,0.00,0.00),('1','294','2','22',432,'12','1',22237.15,22717.60,480.45,84078.75,0.00,0.00,0.00,0.00,0.00),('1','294','2','22',433,'13','1',1703.47,1703.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','22',434,'14','1',23714.19,24228.33,514.14,89974.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','22',435,'15','1',5329.51,5933.51,604.00,105700.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','22',436,'16','1',13610.11,13610.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','22',437,'17','2',18326.40,19801.74,1475.34,1113881.70,0.00,0.00,0.00,0.00,0.00),('1','294','3','22',438,'18','2',2372.37,2372.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','22',439,'19','2',2377.37,2377.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','22',440,'20','2',894.36,894.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','23',441,'1','1',2297.18,2297.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','23',442,'2','1',14489.56,16504.05,2014.49,352535.75,0.00,0.00,0.00,0.00,0.00),('1','294','1','23',443,'3','1',9177.37,10994.16,1816.79,317938.25,0.00,0.00,0.00,0.00,0.00),('1','294','1','23',444,'4','1',2515.92,2515.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','23',445,'5','1',7119.06,9090.78,1971.72,345051.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','23',446,'6','1',4941.17,4941.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','23',447,'7','1',2560.45,2560.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','23',448,'8','1',1309.80,1309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','23',449,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','23',450,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','23',451,'11','1',13751.15,13751.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','23',452,'12','1',22717.60,22717.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','23',453,'13','1',1703.47,1703.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','23',454,'14','1',24228.33,24228.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','23',455,'15','1',5933.51,5933.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','23',456,'16','1',13610.11,13610.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','23',457,'17','2',19801.74,20178.10,376.36,284151.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','23',458,'18','2',2372.37,2372.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','23',459,'19','2',2377.37,2477.01,99.64,75228.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','23',460,'20','2',894.36,894.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','24',461,'1','1',2297.18,2503.00,205.82,36018.50,0.00,0.00,0.00,0.00,0.00),('1','294','1','24',462,'2','1',16504.05,19625.42,3121.37,546239.75,0.00,0.00,0.00,0.00,0.00),('1','294','1','24',463,'3','1',10994.16,11095.86,101.70,17797.50,0.00,0.00,0.00,0.00,0.00),('1','294','1','24',464,'4','1',2515.92,4488.50,1972.58,345201.50,0.00,0.00,0.00,0.00,0.00),('1','294','1','24',465,'5','1',9090.78,10301.10,1210.32,211806.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','24',466,'6','1',4941.17,4941.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','24',467,'7','1',2560.45,3597.55,1037.10,181492.50,0.00,0.00,0.00,0.00,0.00),('1','294','1','24',468,'8','1',1309.80,1309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','24',469,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','24',470,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','24',471,'11','1',13751.15,13751.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','24',472,'12','1',22717.60,22717.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','24',473,'13','1',1703.47,1703.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','24',474,'14','1',24228.33,24228.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','24',475,'15','1',5933.51,5933.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','24',476,'16','1',13610.11,13610.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','24',477,'17','2',20178.10,20467.70,289.60,218648.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','24',478,'18','2',2372.37,2372.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','24',479,'19','2',2477.01,2605.01,128.00,96640.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','24',480,'20','2',894.36,894.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','25',481,'1','1',2503.00,4442.02,1939.02,339328.50,0.00,0.00,0.00,0.00,0.00),('1','294','1','25',482,'2','1',19625.42,19625.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','25',483,'3','1',11095.86,12924.43,1828.57,319999.75,0.00,0.00,0.00,0.00,0.00),('1','294','1','25',484,'4','1',4488.50,4879.66,391.16,68453.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','25',485,'5','1',10301.10,12362.86,2061.76,360808.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','25',486,'6','1',4941.17,4941.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','25',487,'7','1',3597.55,3597.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','25',488,'8','1',1309.80,1309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','25',489,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','25',490,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','25',491,'11','1',13751.15,13751.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','25',492,'12','1',22717.60,22717.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','25',493,'13','1',1703.47,1703.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','25',494,'14','1',24228.33,24228.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','25',495,'15','1',5933.51,5933.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','25',496,'16','1',13610.11,13610.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','25',497,'17','2',20467.70,21258.63,790.93,597152.15,0.00,0.00,0.00,0.00,0.00),('1','294','3','25',498,'18','2',2372.37,2418.72,46.35,34994.25,0.00,0.00,0.00,0.00,0.00),('1','294','3','25',499,'19','2',2605.01,2691.63,86.62,65398.10,0.00,0.00,0.00,0.00,0.00),('1','294','3','25',500,'20','2',894.36,894.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','26',501,'1','1',4442.02,5918.50,1476.48,258384.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','26',502,'2','1',19625.42,20196.15,570.73,99877.75,0.00,0.00,0.00,0.00,0.00),('1','294','1','26',503,'3','1',12924.43,14994.78,2070.35,362311.25,0.00,0.00,0.00,0.00,0.00),('1','294','1','26',504,'4','1',4879.66,4879.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','26',505,'5','1',12362.86,13943.78,1580.92,276661.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','26',506,'6','1',4941.17,4941.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','26',507,'7','1',3597.55,4601.33,1003.78,175661.50,0.00,0.00,0.00,0.00,0.00),('1','294','1','26',508,'8','1',1309.80,1309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','26',509,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','26',510,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','26',511,'11','1',13751.15,13751.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','26',512,'12','1',22717.60,22717.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','26',513,'13','1',1703.47,1703.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','26',514,'14','1',24228.33,24228.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','26',515,'15','1',5933.51,5933.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','26',516,'16','1',13610.11,13610.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','26',517,'17','2',21258.63,21600.28,341.65,257945.75,0.00,0.00,0.00,0.00,0.00),('1','294','3','26',518,'18','2',2418.72,2524.74,106.02,80045.10,0.00,0.00,0.00,0.00,0.00),('1','294','3','26',519,'19','2',2691.63,2691.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','26',520,'20','2',894.36,894.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','27',521,'1','1',5918.50,6222.80,290.41,50821.75,0.00,0.00,13.89,0.00,0.00),('1','294','1','27',522,'2','1',20196.15,22456.22,2260.07,395512.25,0.00,0.00,0.00,0.00,0.00),('1','294','1','27',523,'3','1',14994.78,17229.70,2234.92,391111.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','27',524,'4','1',4879.66,4879.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','27',525,'5','1',13943.78,15679.95,1736.17,303829.75,0.00,0.00,0.00,0.00,0.00),('1','294','1','27',526,'6','1',4941.17,4941.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','27',527,'7','1',4601.33,5066.34,465.01,81376.75,0.00,0.00,0.00,0.00,0.00),('1','294','1','27',528,'8','1',1309.80,1309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','27',529,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','27',530,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','27',531,'11','1',13751.15,13751.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','27',532,'12','1',22717.60,22717.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','27',533,'13','1',1703.47,1703.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','27',534,'14','1',24228.33,24228.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','27',535,'15','1',5933.51,5933.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','27',536,'16','1',13610.11,13610.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','27',537,'17','2',21600.28,21907.14,306.86,231679.30,0.00,0.00,0.00,0.00,0.00),('1','294','3','27',538,'18','2',2524.74,2524.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','27',539,'19','2',2691.63,2691.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','27',540,'20','2',894.36,894.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','28',541,'1','1',6222.80,6716.22,493.42,86348.50,0.00,0.00,0.00,0.00,0.00),('1','294','1','28',542,'2','1',22456.22,24826.95,2370.73,414877.75,0.00,0.00,0.00,0.00,0.00),('1','294','1','28',543,'3','1',17229.70,18852.88,1623.18,284056.50,0.00,0.00,0.00,0.00,0.00),('1','294','1','28',544,'4','1',4879.66,4879.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','28',545,'5','1',15679.95,17775.20,2095.25,366668.75,0.00,0.00,0.00,0.00,0.00),('1','294','1','28',546,'6','1',4941.17,4941.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','28',547,'7','1',5066.34,5066.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','28',548,'8','1',1309.80,1309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','28',549,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','28',550,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','28',551,'11','1',13751.15,13751.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','28',552,'12','1',22717.60,22717.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','28',553,'13','1',1703.47,1703.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','28',554,'14','1',24228.33,24228.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','28',555,'15','1',5933.51,5933.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','28',556,'16','1',13610.11,13610.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','28',557,'17','2',21907.14,23787.60,1880.46,1419747.30,0.00,0.00,0.00,0.00,0.00),('1','294','3','28',558,'18','2',2524.74,2524.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','28',559,'19','2',2691.63,2691.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','28',560,'20','2',894.36,894.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','29',561,'1','1',6716.22,6891.27,175.05,30633.75,0.00,0.00,0.00,0.00,0.00),('1','294','1','29',562,'2','1',24826.95,24826.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','29',563,'3','1',18852.88,19014.87,161.99,28348.25,0.00,0.00,0.00,0.00,0.00),('1','294','1','29',564,'4','1',4879.66,4879.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','29',565,'5','1',17775.20,18034.50,259.30,45377.50,0.00,0.00,0.00,0.00,0.00),('1','294','1','29',566,'6','1',4941.17,4941.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','29',567,'7','1',5066.34,5066.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','29',568,'8','1',1309.80,1309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','29',569,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','29',570,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','29',571,'11','1',13751.15,13751.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','29',572,'12','1',22717.60,22717.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','29',573,'13','1',1703.47,1703.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','29',574,'14','1',24228.33,24228.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','29',575,'15','1',5933.51,5933.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','29',576,'16','1',13610.11,13610.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','29',577,'17','2',23787.60,25216.19,1428.59,1078585.45,0.00,0.00,0.00,0.00,0.00),('1','294','3','29',578,'18','2',2524.74,2524.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','29',579,'19','2',2691.63,2706.20,14.57,11000.35,0.00,0.00,0.00,0.00,0.00),('1','294','3','29',580,'20','2',894.36,894.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','30',581,'1','1',6891.27,6891.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','30',582,'2','1',24826.95,24826.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','30',583,'3','1',19014.87,19014.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','30',584,'4','1',4879.66,4879.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','30',585,'5','1',18034.50,18034.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','30',586,'6','1',4941.17,4941.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','30',587,'7','1',5066.34,5066.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','30',588,'8','1',1309.80,1309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','30',589,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','30',590,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','30',591,'11','1',13751.15,14616.91,865.76,151508.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','30',592,'12','1',22717.60,23045.75,328.15,57426.25,0.00,0.00,0.00,0.00,0.00),('1','294','2','30',593,'13','1',1703.47,1735.47,32.00,5600.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','30',594,'14','1',24228.33,24571.68,343.35,60086.25,0.00,0.00,0.00,0.00,0.00),('1','294','2','30',595,'15','1',5933.51,6419.35,485.84,85022.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','30',596,'16','1',13610.11,13610.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','30',597,'17','2',25216.19,26603.93,1387.74,1047743.70,0.00,0.00,0.00,0.00,0.00),('1','294','3','30',598,'18','2',2524.74,2524.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','30',599,'19','2',2706.20,3351.20,645.00,486975.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','30',600,'20','2',894.36,894.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','31',601,'1','1',6891.27,6891.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','31',602,'2','1',24826.95,24826.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','31',603,'3','1',19014.87,19014.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','31',604,'4','1',4879.66,4879.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','31',605,'5','1',18034.50,18034.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','31',606,'6','1',4941.17,4941.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','31',607,'7','1',5066.34,5085.20,18.86,3300.50,0.00,0.00,0.00,0.00,0.00),('1','294','1','31',608,'8','1',1309.80,1309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','31',609,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','31',610,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','31',611,'11','1',14616.91,16877.44,2260.53,395592.75,0.00,0.00,0.00,0.00,0.00),('1','294','2','31',612,'12','1',23045.75,23045.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','31',613,'13','1',1735.47,1914.33,178.86,31300.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','31',614,'14','1',24571.68,26647.34,2075.66,363240.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','31',615,'15','1',6419.35,7285.99,866.64,151662.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','31',616,'16','1',13610.11,13816.94,206.83,36195.25,0.00,0.00,0.00,0.00,0.00),('1','294','3','31',617,'17','2',26603.93,27387.50,783.57,591595.35,0.00,0.00,0.00,0.00,0.00),('1','294','3','31',618,'18','2',2524.74,2524.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','31',619,'19','2',3351.20,4032.61,681.41,514464.55,0.00,0.00,0.00,0.00,0.00),('1','294','3','31',620,'20','2',894.36,894.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','32',621,'1','1',6891.27,6891.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','32',622,'2','1',24826.95,24826.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','32',623,'3','1',19014.87,19014.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','32',624,'4','1',4879.66,4879.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','32',625,'5','1',18034.50,19218.60,1184.10,207217.50,0.00,0.00,0.00,0.00,0.00),('1','294','1','32',626,'6','1',4941.17,4941.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','32',627,'7','1',5085.20,5085.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','32',628,'8','1',1309.80,1309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','32',629,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','32',630,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','32',631,'11','1',16877.44,16877.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','32',632,'12','1',23045.75,26805.59,3759.84,657972.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','32',633,'13','1',1914.33,1914.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','32',634,'14','1',26647.34,28850.80,2203.46,385605.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','32',635,'15','1',7285.99,7285.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','32',636,'16','1',13816.94,15573.97,1757.03,307480.25,0.00,0.00,0.00,0.00,0.00),('1','294','3','32',637,'17','2',27387.50,27734.18,346.68,261743.40,0.00,0.00,0.00,0.00,0.00),('1','294','3','32',638,'18','2',2524.74,2524.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','32',639,'19','2',4032.61,4237.97,205.36,155046.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','32',640,'20','2',894.36,894.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','33',641,'1','1',6891.27,7469.01,577.74,101104.50,0.00,0.00,0.00,0.00,0.00),('1','294','1','33',642,'2','1',24826.95,24917.85,90.90,15907.50,0.00,0.00,0.00,0.00,0.00),('1','294','1','33',643,'3','1',19014.87,19014.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','33',644,'4','1',4879.66,4879.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','33',645,'5','1',19218.60,19218.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','33',646,'6','1',4941.17,4941.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','33',647,'7','1',5085.20,5085.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','33',648,'8','1',1309.80,1309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','33',649,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','33',650,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','33',651,'11','1',16877.44,19344.21,2466.77,431684.75,0.00,0.00,0.00,0.00,0.00),('1','294','2','33',652,'12','1',26805.59,26805.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','33',653,'13','1',1914.33,1914.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','33',654,'14','1',28850.80,30281.80,1431.00,250425.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','33',655,'15','1',7285.99,8881.60,1595.61,279231.75,0.00,0.00,0.00,0.00,0.00),('1','294','2','33',656,'16','1',15573.97,16568.76,994.79,174088.25,0.00,0.00,0.00,0.00,0.00),('1','294','3','33',657,'17','2',27734.18,28925.15,1190.97,899182.35,0.00,0.00,0.00,0.00,0.00),('1','294','3','33',658,'18','2',2524.74,2524.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','33',659,'19','2',4237.97,4237.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','33',660,'20','2',894.36,894.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','34',661,'1','1',7469.01,7859.87,390.86,68400.50,0.00,0.00,0.00,0.00,0.00),('1','294','1','34',662,'2','1',24917.85,24917.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','34',663,'3','1',19014.87,19014.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','34',664,'4','1',4879.66,4924.70,45.04,7882.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','34',665,'5','1',19218.60,19594.16,375.56,65723.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','34',666,'6','1',4941.17,4941.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','34',667,'7','1',5085.20,5085.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','34',668,'8','1',1309.80,1309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','34',669,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','34',670,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','34',671,'11','1',19344.21,21468.57,2124.36,371763.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','34',672,'12','1',26805.59,26978.31,172.72,30226.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','34',673,'13','1',1914.33,1914.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','34',674,'14','1',30281.80,34358.19,4056.39,709868.25,0.00,0.00,20.00,0.00,0.00),('1','294','2','34',675,'15','1',8881.60,10865.33,1983.73,347152.75,0.00,0.00,0.00,0.00,0.00),('1','294','2','34',676,'16','1',16568.76,17597.21,1028.45,179978.75,0.00,0.00,0.00,0.00,0.00),('1','294','3','34',677,'17','2',28925.15,29837.16,912.01,688567.55,0.00,0.00,0.00,0.00,0.00),('1','294','3','34',678,'18','2',2524.74,2624.74,100.00,75500.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','34',679,'19','2',4237.97,4337.97,100.00,75500.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','34',680,'20','2',894.36,894.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','35',681,'1','1',7859.87,9994.21,2134.34,373509.50,0.00,0.00,0.00,0.00,0.00),('1','294','1','35',682,'2','1',24917.85,24917.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','35',683,'3','1',19014.87,19382.14,367.27,64272.25,0.00,0.00,0.00,0.00,0.00),('1','294','1','35',684,'4','1',4924.70,5225.90,301.20,52710.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','35',685,'5','1',19594.16,20926.27,1332.11,233119.25,0.00,0.00,0.00,0.00,0.00),('1','294','1','35',686,'6','1',4941.17,5297.72,356.55,62396.25,0.00,0.00,0.00,0.00,0.00),('1','294','1','35',687,'7','1',5085.20,5846.12,760.92,133161.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','35',688,'8','1',1309.80,1310.02,0.22,38.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','35',689,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','35',690,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','35',691,'11','1',21468.57,21468.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','35',692,'12','1',26978.31,26989.73,11.42,1998.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','35',693,'13','1',1914.33,2783.32,868.99,152073.25,0.00,0.00,0.00,0.00,0.00),('1','294','2','35',694,'14','1',34358.19,34491.32,133.13,23297.75,0.00,0.00,0.00,0.00,0.00),('1','294','2','35',695,'15','1',10865.33,11569.09,703.76,123158.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','35',696,'16','1',17597.21,17597.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','35',697,'17','2',29837.16,30207.43,370.27,279553.85,0.00,0.00,0.00,0.00,0.00),('1','294','3','35',698,'18','2',2624.74,2624.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','35',699,'19','2',4337.97,4337.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','35',700,'20','2',894.36,894.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','36',701,'1','1',9994.21,10008.50,14.29,2500.75,0.00,0.00,0.00,0.00,0.00),('1','294','1','36',702,'2','1',24917.85,27648.99,2731.14,477949.50,0.00,0.00,0.00,0.00,0.00),('1','294','1','36',703,'3','1',19382.14,22028.80,2646.66,463165.50,0.00,0.00,0.00,0.00,0.00),('1','294','1','36',704,'4','1',5225.90,5658.44,432.54,75694.50,0.00,0.00,0.00,0.00,0.00),('1','294','1','36',705,'5','1',20926.27,23846.09,2919.82,510968.50,0.00,0.00,0.00,0.00,0.00),('1','294','1','36',706,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','36',707,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','36',708,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','36',709,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','36',710,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','36',711,'11','1',21468.57,21468.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','36',712,'12','1',26989.73,26989.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','36',713,'13','1',2783.32,2783.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','36',714,'14','1',34491.32,34491.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','36',715,'15','1',11569.09,11569.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','36',716,'16','1',17597.21,17597.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','36',717,'17','2',30207.43,31698.21,1490.78,1125538.90,0.00,0.00,0.00,0.00,0.00),('1','294','3','36',718,'18','2',2624.74,2624.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','36',719,'19','2',4337.97,4337.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','36',720,'20','2',894.36,894.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','37',721,'1','1',10008.50,10167.54,159.04,27832.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','37',722,'2','1',27648.99,27648.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','37',723,'3','1',22028.80,22151.56,122.76,21483.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','37',724,'4','1',5658.44,5658.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','37',725,'5','1',23846.09,23932.82,86.73,15177.75,0.00,0.00,0.00,0.00,0.00),('1','294','1','37',726,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','37',727,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','37',728,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','37',729,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','37',730,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','37',731,'11','1',21468.57,21612.25,143.68,25144.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','37',732,'12','1',26989.73,29284.62,2294.89,401605.75,0.00,0.00,0.00,0.00,0.00),('1','294','2','37',733,'13','1',2783.32,2783.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','37',734,'14','1',34491.32,36825.20,2333.88,408429.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','37',735,'15','1',11569.09,13647.17,2078.08,363664.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','37',736,'16','1',17597.21,17597.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','37',737,'17','2',31698.21,32070.16,371.95,280822.25,0.00,0.00,0.00,0.00,0.00),('1','294','3','37',738,'18','2',2624.74,2624.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','37',739,'19','2',4337.97,4337.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','37',740,'20','2',894.36,894.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','38',741,'1','1',10167.54,10167.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','38',742,'2','1',27648.99,27648.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','38',743,'3','1',22151.56,22151.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','38',744,'4','1',5658.44,5658.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','38',745,'5','1',23932.82,23932.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','38',746,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','38',747,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','38',748,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','38',749,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','38',750,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','38',751,'11','1',21612.25,21910.63,298.38,52216.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','38',752,'12','1',29284.62,32294.07,3009.45,526653.75,0.00,0.00,0.00,0.00,0.00),('1','294','2','38',753,'13','1',2783.32,3252.58,469.26,82120.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','38',754,'14','1',36825.20,39189.65,2364.45,413778.75,0.00,0.00,0.00,0.00,0.00),('1','294','2','38',755,'15','1',13647.17,15341.04,1693.87,296427.25,0.00,0.00,0.00,0.00,0.00),('1','294','2','38',756,'16','1',17597.21,17597.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','38',757,'17','2',32070.16,34061.92,1991.76,1503778.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','38',758,'18','2',2624.74,2624.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','38',759,'19','2',4337.97,4337.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','38',760,'20','2',894.36,894.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','39',761,'1','1',10167.54,10167.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','39',762,'2','1',27648.99,27648.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','39',763,'3','1',22151.56,22151.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','39',764,'4','1',5658.44,5658.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','39',765,'5','1',23932.82,23932.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','39',766,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','39',767,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','39',768,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','39',769,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','39',770,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','39',771,'11','1',21910.63,21910.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','39',772,'12','1',32294.07,33876.80,1582.73,276977.75,0.00,0.00,0.00,0.00,0.00),('1','294','2','39',773,'13','1',3252.58,3252.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','39',774,'14','1',39189.65,40552.85,1363.20,238560.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','39',775,'15','1',15341.04,16872.74,1531.70,268047.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','39',776,'16','1',17597.21,17597.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','39',777,'17','2',34061.92,34835.14,773.22,583781.10,0.00,0.00,0.00,0.00,0.00),('1','294','3','39',778,'18','2',2624.74,2624.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','39',779,'19','2',4337.97,5156.18,818.21,617748.55,0.00,0.00,0.00,0.00,0.00),('1','294','3','39',780,'20','2',894.36,947.34,52.98,39999.90,0.00,0.00,0.00,0.00,0.00),('1','294','1','40',781,'1','1',10167.54,10167.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','40',782,'2','1',27648.99,27648.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','40',783,'3','1',22151.56,22151.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','40',784,'4','1',5658.44,5658.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','40',785,'5','1',23932.82,23932.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','40',786,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','40',787,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','40',788,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','40',789,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','40',790,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','40',791,'11','1',21910.63,24413.38,2502.75,437981.25,0.00,0.00,0.00,0.00,0.00),('1','294','2','40',792,'12','1',33876.80,35233.70,1356.90,237457.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','40',793,'13','1',3252.58,3655.14,402.56,70448.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','40',794,'14','1',40552.85,44335.78,3782.93,662012.75,0.00,0.00,0.00,0.00,0.00),('1','294','2','40',795,'15','1',16872.74,18348.00,1475.26,258170.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','40',796,'16','1',17597.21,17597.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','40',797,'17','2',34835.14,35763.56,928.42,700957.10,0.00,0.00,0.00,0.00,0.00),('1','294','3','40',798,'18','2',2624.74,2624.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','40',799,'19','2',5156.18,5156.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','40',800,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','41',801,'1','1',10167.54,10167.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','41',802,'2','1',27648.99,27648.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','41',803,'3','1',22151.56,22151.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','41',804,'4','1',5658.44,5658.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','41',805,'5','1',23932.82,23932.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','41',806,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','41',807,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','41',808,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','41',809,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','41',810,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','41',811,'11','1',24413.38,24413.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','41',812,'12','1',35233.70,37517.68,2283.98,399696.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','41',813,'13','1',3655.14,3655.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','41',814,'14','1',44335.78,46462.43,2126.65,372163.75,0.00,0.00,0.00,0.00,0.00),('1','294','2','41',815,'15','1',18348.00,20721.65,2373.65,415388.75,0.00,0.00,0.00,0.00,0.00),('1','294','2','41',816,'16','1',17597.21,17597.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','41',817,'17','2',35763.56,36808.99,1045.43,789299.65,0.00,0.00,0.00,0.00,0.00),('1','294','3','41',818,'18','2',2624.74,2624.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','41',819,'19','2',5156.18,5408.83,252.65,190750.75,0.00,0.00,0.00,0.00,0.00),('1','294','3','41',820,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','42',821,'1','1',10167.54,10167.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','42',822,'2','1',27648.99,27648.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','42',823,'3','1',22151.56,22151.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','42',824,'4','1',5658.44,5658.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','42',825,'5','1',23932.82,23932.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','42',826,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','42',827,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','42',828,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','42',829,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','42',830,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','42',831,'11','1',24413.38,27618.65,3205.27,560922.25,0.00,0.00,0.00,0.00,0.00),('1','294','2','42',832,'12','1',37517.68,37547.39,29.71,5199.25,0.00,0.00,0.00,0.00,0.00),('1','294','2','42',833,'13','1',3655.14,4306.92,651.78,114061.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','42',834,'14','1',46462.43,50596.60,4134.17,723479.75,0.00,0.00,0.00,0.00,0.00),('1','294','2','42',835,'15','1',20721.65,23148.03,2426.38,424616.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','42',836,'16','1',17597.21,17718.04,120.83,21145.25,0.00,0.00,0.00,0.00,0.00),('1','294','3','42',837,'17','2',36808.99,38460.79,1651.80,1247109.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','42',838,'18','2',2624.74,2630.04,5.30,4001.50,0.00,0.00,0.00,0.00,0.00),('1','294','3','42',839,'19','2',5408.83,5638.83,230.00,173650.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','42',840,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','43',841,'1','1',10167.54,10167.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','43',842,'2','1',27648.99,27648.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','43',843,'3','1',22151.56,22151.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','43',844,'4','1',5658.44,5658.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','43',845,'5','1',23932.82,23932.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','43',846,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','43',847,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','43',848,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','43',849,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','43',850,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','43',851,'11','1',27618.65,27618.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','43',852,'12','1',37547.39,38411.94,864.55,151296.25,0.00,0.00,0.00,0.00,0.00),('1','294','2','43',853,'13','1',4306.92,4306.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','43',854,'14','1',50596.60,51166.12,569.52,99666.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','43',855,'15','1',23148.03,23148.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','43',856,'16','1',17718.04,18306.42,588.38,102966.50,0.00,0.00,0.00,0.00,0.00),('1','294','3','43',857,'17','2',38460.79,38864.46,403.67,304770.85,0.00,0.00,0.00,0.00,0.00),('1','294','3','43',858,'18','2',2630.04,2630.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','43',859,'19','2',5638.83,5638.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','43',860,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','44',861,'1','1',10167.54,10167.54,-20.55,-3596.25,0.00,0.00,20.55,0.00,0.00),('1','294','1','44',862,'2','1',27648.99,27648.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','44',863,'3','1',22151.56,22151.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','44',864,'4','1',5658.44,5658.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','44',865,'5','1',23932.82,23932.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','44',866,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','44',867,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','44',868,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','44',869,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','44',870,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','44',871,'11','1',27618.65,29062.94,1444.29,252750.75,0.00,0.00,0.00,0.00,0.00),('1','294','2','44',872,'12','1',38411.94,39679.74,1267.80,221865.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','44',873,'13','1',4306.92,4486.66,179.74,31454.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','44',874,'14','1',51166.12,52739.51,1573.39,275343.25,0.00,0.00,0.00,0.00,0.00),('1','294','2','44',875,'15','1',23148.03,24249.80,1101.77,192809.75,0.00,0.00,0.00,0.00,0.00),('1','294','2','44',876,'16','1',18306.42,18306.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','44',877,'17','2',38864.46,38864.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','44',878,'18','2',2630.04,2630.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','44',879,'19','2',5638.83,5638.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','44',880,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','45',881,'1','1',10167.54,10167.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','45',882,'2','1',27648.99,27672.59,23.60,4200.80,0.00,0.00,0.00,0.00,0.00),('1','294','1','45',883,'3','1',22151.56,22151.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','45',884,'4','1',5658.44,5658.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','45',885,'5','1',23932.82,23995.41,62.59,11141.02,0.00,0.00,0.00,0.00,0.00),('1','294','1','45',886,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','45',887,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','45',888,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','45',889,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','45',890,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','45',891,'11','1',29062.94,29676.71,613.77,109251.06,0.00,0.00,0.00,0.00,0.00),('1','294','2','45',892,'12','1',39679.74,40272.51,592.77,105513.06,0.00,0.00,0.00,0.00,0.00),('1','294','2','45',893,'13','1',4486.66,4486.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','45',894,'14','1',52739.51,53460.51,721.00,128338.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','45',895,'15','1',24249.80,24681.81,432.01,76897.78,0.00,0.00,0.00,0.00,0.00),('1','294','2','45',896,'16','1',18306.42,18306.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','45',897,'17','2',38864.46,38864.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','45',898,'18','2',2630.04,2630.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','45',899,'19','2',5638.83,5638.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','45',900,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','46',901,'1','1',10167.54,10167.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','46',902,'2','1',27672.59,27672.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','46',903,'3','1',22151.56,22151.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','46',904,'4','1',5658.44,5658.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','46',905,'5','1',23995.41,23995.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','46',906,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','46',907,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','46',908,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','46',909,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','46',910,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','46',911,'11','1',29676.71,32343.85,2667.14,474750.92,0.00,0.00,0.00,0.00,0.00),('1','294','2','46',912,'12','1',40272.51,43665.13,3392.62,603886.36,0.00,0.00,0.00,0.00,0.00),('1','294','2','46',913,'13','1',4486.66,5164.17,677.51,120596.78,0.00,0.00,0.00,0.00,0.00),('1','294','2','46',914,'14','1',53460.51,55879.72,2419.21,430619.38,0.00,0.00,0.00,0.00,0.00),('1','294','2','46',915,'15','1',24681.81,26449.01,1767.20,314561.60,0.00,0.00,0.00,0.00,0.00),('1','294','2','46',916,'16','1',18306.42,18458.18,151.76,27013.28,0.00,0.00,0.00,0.00,0.00),('1','294','3','46',917,'17','2',38864.46,38864.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','46',918,'18','2',2630.04,2630.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','46',919,'19','2',5638.83,5638.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','46',920,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','47',921,'1','1',10167.54,10167.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','47',922,'2','1',27672.59,27672.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','47',923,'3','1',22151.56,22151.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','47',924,'4','1',5658.44,5658.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','47',925,'5','1',23995.41,23995.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','47',926,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','47',927,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','47',928,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','47',929,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','47',930,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','47',931,'11','1',32343.85,34470.85,2127.00,378606.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','47',932,'12','1',43665.13,45760.40,2095.27,372958.06,0.00,0.00,0.00,0.00,0.00),('1','294','2','47',933,'13','1',5164.17,5164.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','47',934,'14','1',55879.72,58065.15,2185.43,389006.54,0.00,0.00,0.00,0.00,0.00),('1','294','2','47',935,'15','1',26449.01,27957.16,1508.15,268450.70,0.00,0.00,0.00,0.00,0.00),('1','294','2','47',936,'16','1',18458.18,18458.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','47',937,'17','2',38864.46,38864.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','47',938,'18','2',2630.04,2630.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','47',939,'19','2',5638.83,5638.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','47',940,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','48',941,'1','1',10167.54,12112.85,1945.31,346265.18,0.00,0.00,0.00,0.00,0.00),('1','294','1','48',942,'2','1',27672.59,28368.62,696.03,123893.34,0.00,0.00,0.00,0.00,0.00),('1','294','1','48',943,'3','1',22151.56,22731.13,579.57,103163.46,0.00,0.00,0.00,0.00,0.00),('1','294','1','48',944,'4','1',5658.44,6752.49,1094.05,194740.90,0.00,0.00,0.00,0.00,0.00),('1','294','1','48',945,'5','1',23995.41,26362.69,2367.28,421375.84,0.00,0.00,0.00,0.00,0.00),('1','294','1','48',946,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','48',947,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','48',948,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','48',949,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','48',950,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','48',951,'11','1',34470.85,35803.43,1332.58,237199.24,0.00,0.00,0.00,0.00,0.00),('1','294','2','48',952,'12','1',45760.40,45760.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','48',953,'13','1',5164.17,5285.97,121.80,21680.40,0.00,0.00,0.00,0.00,0.00),('1','294','2','48',954,'14','1',58065.15,58524.87,459.72,81830.16,0.00,0.00,0.00,0.00,0.00),('1','294','2','48',955,'15','1',27957.16,28940.86,983.70,175098.60,0.00,0.00,0.00,0.00,0.00),('1','294','2','48',956,'16','1',18458.18,18458.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','48',957,'17','2',38864.46,38864.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','48',958,'18','2',2630.04,2630.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','48',959,'19','2',5638.83,5638.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','48',960,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','49',961,'1','1',12112.85,13894.94,1782.09,317212.02,0.00,0.00,0.00,0.00,0.00),('1','294','1','49',962,'2','1',28368.62,29673.11,1304.49,232199.22,0.00,0.00,0.00,0.00,0.00),('1','294','1','49',963,'3','1',22731.13,24449.98,1718.85,305955.30,0.00,0.00,0.00,0.00,0.00),('1','294','1','49',964,'4','1',6752.49,6752.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','49',965,'5','1',26362.69,28241.35,1878.66,334401.48,0.00,0.00,0.00,0.00,0.00),('1','294','1','49',966,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','49',967,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','49',968,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','49',969,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','49',970,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','49',971,'11','1',35803.43,35803.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','49',972,'12','1',45760.40,45760.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','49',973,'13','1',5285.97,5285.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','49',974,'14','1',58524.87,58524.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','49',975,'15','1',28940.86,28940.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','49',976,'16','1',18458.18,18458.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','49',977,'17','2',38864.46,38864.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','49',978,'18','2',2630.04,2630.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','49',979,'19','2',5638.83,5638.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','49',980,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','50',981,'1','1',13894.94,16001.89,2106.95,375037.10,0.00,0.00,0.00,0.00,0.00),('1','294','1','50',982,'2','1',29673.11,31875.14,2202.03,391961.34,0.00,0.00,0.00,0.00,0.00),('1','294','1','50',983,'3','1',24449.98,26272.08,1822.10,324333.80,0.00,0.00,0.00,0.00,0.00),('1','294','1','50',984,'4','1',6752.49,7371.07,618.58,110107.24,0.00,0.00,0.00,0.00,0.00),('1','294','1','50',985,'5','1',28241.35,29874.32,1632.97,290668.66,0.00,0.00,0.00,0.00,0.00),('1','294','1','50',986,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','50',987,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','50',988,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','50',989,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','50',990,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','50',991,'11','1',35803.43,35803.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','50',992,'12','1',45760.40,45760.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','50',993,'13','1',5285.97,5285.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','50',994,'14','1',58524.87,58524.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','50',995,'15','1',28940.86,28940.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','50',996,'16','1',18458.18,18458.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','50',997,'17','2',38864.46,38864.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','50',998,'18','2',2630.04,2630.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','50',999,'19','2',5638.83,5638.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','50',1000,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','51',1001,'1','1',16001.89,17177.52,1175.63,209262.14,0.00,0.00,0.00,0.00,0.00),('1','294','1','51',1002,'2','1',31875.14,33595.57,1720.43,306236.54,0.00,0.00,0.00,0.00,0.00),('1','294','1','51',1003,'3','1',26272.08,28399.43,2127.35,378668.30,0.00,0.00,0.00,0.00,0.00),('1','294','1','51',1004,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','51',1005,'5','1',29874.32,31428.25,1553.93,276599.54,0.00,0.00,0.00,0.00,0.00),('1','294','1','51',1006,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','51',1007,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','51',1008,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','51',1009,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','51',1010,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','51',1011,'11','1',35803.43,35803.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','51',1012,'12','1',45760.40,45760.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','51',1013,'13','1',5285.97,5285.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','51',1014,'14','1',58524.87,58524.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','51',1015,'15','1',28940.86,28940.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','51',1016,'16','1',18458.18,18458.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','51',1017,'17','2',38864.46,38864.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','51',1018,'18','2',2630.04,2630.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','51',1019,'19','2',5638.83,5638.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','51',1020,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','52',1021,'1','1',17177.52,17806.75,629.23,112002.94,0.00,0.00,0.00,0.00,0.00),('1','294','1','52',1022,'2','1',33595.57,33873.52,277.95,49475.10,0.00,0.00,0.00,0.00,0.00),('1','294','1','52',1023,'3','1',28399.43,28786.99,387.56,68985.68,0.00,0.00,0.00,0.00,0.00),('1','294','1','52',1024,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','52',1025,'5','1',31428.25,31867.34,439.09,78158.02,0.00,0.00,0.00,0.00,0.00),('1','294','1','52',1026,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','52',1027,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','52',1028,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','52',1029,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','52',1030,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','52',1031,'11','1',35803.43,37118.45,1315.02,234073.56,0.00,0.00,0.00,0.00,0.00),('1','294','2','52',1032,'12','1',45760.40,47527.97,1767.57,314627.46,0.00,0.00,0.00,0.00,0.00),('1','294','2','52',1033,'13','1',5285.97,5302.82,16.85,2999.30,0.00,0.00,0.00,0.00,0.00),('1','294','2','52',1034,'14','1',58524.87,60178.20,1653.33,294292.74,0.00,0.00,0.00,0.00,0.00),('1','294','2','52',1035,'15','1',28940.86,30008.48,1067.62,190036.36,0.00,0.00,0.00,0.00,0.00),('1','294','2','52',1036,'16','1',18458.18,19511.47,1053.29,187485.62,0.00,0.00,0.00,0.00,0.00),('1','294','3','52',1037,'17','2',38864.46,38864.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','52',1038,'18','2',2630.04,2630.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','52',1039,'19','2',5638.83,5638.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','52',1040,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','53',1041,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','53',1042,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','53',1043,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','53',1044,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','53',1045,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','53',1046,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','53',1047,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','53',1048,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','53',1049,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','53',1050,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','53',1051,'11','1',37118.45,39446.38,2327.93,414371.54,0.00,0.00,0.00,0.00,0.00),('1','294','2','53',1052,'12','1',47527.97,48803.88,1275.91,227111.98,0.00,0.00,0.00,0.00,0.00),('1','294','2','53',1053,'13','1',5302.82,5302.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','53',1054,'14','1',60178.20,62315.70,2137.50,380475.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','53',1055,'15','1',30008.48,31611.18,1602.70,285280.60,0.00,0.00,0.00,0.00,0.00),('1','294','2','53',1056,'16','1',19511.47,19511.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','53',1057,'17','2',38864.46,38864.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','53',1058,'18','2',2630.04,2630.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','53',1059,'19','2',5638.83,5638.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','53',1060,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','54',1061,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','54',1062,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','54',1063,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','54',1064,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','54',1065,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','54',1066,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','54',1067,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','54',1068,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','54',1069,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','54',1070,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','54',1071,'11','1',39446.38,41052.90,1606.52,285960.56,0.00,0.00,0.00,0.00,0.00),('1','294','2','54',1072,'12','1',48803.88,51031.72,2227.84,396555.52,0.00,0.00,0.00,0.00,0.00),('1','294','2','54',1073,'13','1',5302.82,5302.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','54',1074,'14','1',62315.70,65053.66,2737.96,487356.88,0.00,0.00,0.00,0.00,0.00),('1','294','2','54',1075,'15','1',31611.18,32918.97,1307.79,232786.62,0.00,0.00,0.00,0.00,0.00),('1','294','2','54',1076,'16','1',19511.47,19987.21,475.74,84681.72,0.00,0.00,0.00,0.00,0.00),('1','294','3','54',1077,'17','2',38864.46,38864.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','54',1078,'18','2',2630.04,2630.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','54',1079,'19','2',5638.83,5638.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','54',1080,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','55',1081,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','55',1082,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','55',1083,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','55',1084,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','55',1085,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','55',1086,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','55',1087,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','55',1088,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','55',1089,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','55',1090,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','55',1091,'11','1',41052.90,42289.96,1237.06,220196.68,0.00,0.00,0.00,0.00,0.00),('1','294','2','55',1092,'12','1',51031.72,51031.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','55',1093,'13','1',5302.82,7245.98,1943.16,345882.48,0.00,0.00,0.00,0.00,0.00),('1','294','2','55',1094,'14','1',65053.66,66251.87,1198.21,213281.38,0.00,0.00,0.00,0.00,0.00),('1','294','2','55',1095,'15','1',32918.97,34188.23,1269.26,225928.28,0.00,0.00,0.00,0.00,0.00),('1','294','2','55',1096,'16','1',19987.21,20156.24,169.03,30087.34,0.00,0.00,0.00,0.00,0.00),('1','294','3','55',1097,'17','2',38864.46,40940.99,2076.53,1598928.10,0.00,0.00,0.00,0.00,0.00),('1','294','3','55',1098,'18','2',2630.04,2630.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','55',1099,'19','2',5638.83,5638.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','55',1100,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','56',1101,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','56',1102,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','56',1103,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','56',1104,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','56',1105,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','56',1106,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','56',1107,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','56',1108,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','56',1109,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','56',1110,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','56',1111,'11','1',42289.96,44650.52,2360.56,420179.68,0.00,0.00,0.00,0.00,0.00),('1','294','2','56',1112,'12','1',51031.72,52199.27,1167.55,207823.90,0.00,0.00,0.00,0.00,0.00),('1','294','2','56',1113,'13','1',7245.98,7816.88,570.90,101620.20,0.00,0.00,0.00,0.00,0.00),('1','294','2','56',1114,'14','1',66251.87,68030.54,1778.67,316603.26,0.00,0.00,0.00,0.00,0.00),('1','294','2','56',1115,'15','1',34188.23,35580.07,1391.84,247747.52,0.00,0.00,0.00,0.00,0.00),('1','294','2','56',1116,'16','1',20156.24,20352.82,196.58,34991.24,0.00,0.00,0.00,0.00,0.00),('1','294','3','56',1117,'17','2',40940.99,42900.35,1959.36,1508707.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','56',1118,'18','2',2630.04,2630.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','56',1119,'19','2',5638.83,5638.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','56',1120,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','57',1121,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','57',1122,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','57',1123,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','57',1124,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','57',1125,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','57',1126,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','57',1127,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','57',1128,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','57',1129,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','57',1130,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','57',1131,'11','1',44650.52,46615.63,1965.11,349789.58,0.00,0.00,0.00,0.00,0.00),('1','294','2','57',1132,'12','1',52199.27,52248.71,49.44,8800.32,0.00,0.00,0.00,0.00,0.00),('1','294','2','57',1133,'13','1',7816.88,7816.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','57',1134,'14','1',68030.54,70587.26,2556.72,455096.16,0.00,0.00,0.00,0.00,0.00),('1','294','2','57',1135,'15','1',35580.07,37242.70,1662.63,295948.14,0.00,0.00,0.00,0.00,0.00),('1','294','2','57',1136,'16','1',20352.82,20487.13,134.31,23907.18,0.00,0.00,0.00,0.00,0.00),('1','294','3','57',1137,'17','2',42900.35,43249.71,349.36,269007.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','57',1138,'18','2',2630.04,2630.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','57',1139,'19','2',5638.83,5638.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','57',1140,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','58',1141,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','58',1142,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','58',1143,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','58',1144,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','58',1145,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','58',1146,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','58',1147,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','58',1148,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','58',1149,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','58',1150,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','58',1151,'11','1',46615.63,46615.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','58',1152,'12','1',52248.71,52248.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','58',1153,'13','1',7816.88,7816.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','58',1154,'14','1',70587.26,70587.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','58',1155,'15','1',37242.70,37242.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','58',1156,'16','1',20487.13,20487.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','58',1157,'17','2',43249.71,43817.68,567.97,443016.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','58',1158,'18','2',2630.04,2630.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','58',1159,'19','2',5638.83,5638.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','58',1160,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','59',1161,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','59',1162,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','59',1163,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','59',1164,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','59',1165,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','59',1166,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','59',1167,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','59',1168,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','59',1169,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','59',1170,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','59',1171,'11','1',46615.63,46615.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','59',1172,'12','1',52248.71,54832.48,2583.77,459911.06,0.00,0.00,0.00,0.00,0.00),('1','294','2','59',1173,'13','1',7816.88,7816.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','59',1174,'14','1',70587.26,72290.81,1703.55,303231.90,0.00,0.00,0.00,0.00,0.00),('1','294','2','59',1175,'15','1',37242.70,38758.16,1515.46,269751.88,0.00,0.00,0.00,0.00,0.00),('1','294','2','59',1176,'16','1',20487.13,21856.48,1369.35,243744.30,0.00,0.00,0.00,0.00,0.00),('1','294','3','59',1177,'17','2',43817.68,45505.75,1688.07,1316694.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','59',1178,'18','2',2630.04,2630.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','59',1179,'19','2',5638.83,5638.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','59',1180,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','60',1181,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','60',1182,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','60',1183,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','60',1184,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','60',1185,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','60',1186,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','60',1187,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','60',1188,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','60',1189,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','60',1190,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','60',1191,'11','1',46615.63,48660.64,2025.01,360451.78,0.00,0.00,20.00,0.00,0.00),('1','294','2','60',1192,'12','1',54832.48,54832.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','60',1193,'13','1',7816.88,8003.65,186.77,33245.06,0.00,0.00,0.00,0.00,0.00),('1','294','2','60',1194,'14','1',72290.81,74049.72,1758.91,313085.98,0.00,0.00,0.00,0.00,0.00),('1','294','2','60',1195,'15','1',38758.16,40880.81,2122.65,377831.70,0.00,0.00,0.00,0.00,0.00),('1','294','2','60',1196,'16','1',21856.48,21856.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','60',1197,'17','2',45505.75,46209.60,703.85,549003.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','60',1198,'18','2',2630.04,2630.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','60',1199,'19','2',5638.83,5638.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','60',1200,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','61',1201,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','61',1202,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','61',1203,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','61',1204,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','61',1205,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','61',1206,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','61',1207,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','61',1208,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','61',1209,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','61',1210,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','61',1211,'11','1',48660.64,48660.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','61',1212,'12','1',54832.48,58138.14,3305.66,588407.48,0.00,0.00,0.00,0.00,0.00),('1','294','2','61',1213,'13','1',8003.65,8209.54,205.89,36648.42,0.00,0.00,0.00,0.00,0.00),('1','294','2','61',1214,'14','1',74049.72,76044.51,1994.79,355072.62,0.00,0.00,0.00,0.00,0.00),('1','294','2','61',1215,'15','1',40880.81,42265.45,1384.64,246465.92,0.00,0.00,0.00,0.00,0.00),('1','294','2','61',1216,'16','1',21856.48,21924.46,67.98,12100.44,0.00,0.00,0.00,0.00,0.00),('1','294','3','61',1217,'17','2',46209.60,49240.88,3031.28,2364398.40,0.00,0.00,0.00,0.00,0.00),('1','294','3','61',1218,'18','2',2630.04,2630.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','61',1219,'19','2',5638.83,5638.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','61',1220,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','62',1221,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','62',1222,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','62',1223,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','62',1224,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','62',1225,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','62',1226,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','62',1227,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','62',1228,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','62',1229,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','62',1230,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','62',1231,'11','1',48660.64,48660.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','62',1232,'12','1',58138.14,58138.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','62',1233,'13','1',8209.54,8209.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','62',1234,'14','1',76044.51,76044.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','62',1235,'15','1',42265.45,42265.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','62',1236,'16','1',21924.46,21924.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','62',1237,'17','2',49240.88,49240.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','62',1238,'18','2',2630.04,2630.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','62',1239,'19','2',5638.83,5638.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','62',1240,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','63',1241,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','63',1242,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','63',1243,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','63',1244,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','63',1245,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','63',1246,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','63',1247,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','63',1248,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','63',1249,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','63',1250,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','63',1251,'11','1',48660.64,50936.81,2276.17,405158.26,0.00,0.00,0.00,0.00,0.00),('1','294','2','63',1252,'12','1',58138.14,58138.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','63',1253,'13','1',8209.54,8209.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','63',1254,'14','1',76044.51,77831.77,1787.26,318132.28,0.00,0.00,0.00,0.00,0.00),('1','294','2','63',1255,'15','1',42265.45,42265.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','63',1256,'16','1',21924.46,23513.23,1588.77,282801.06,0.00,0.00,0.00,0.00,0.00),('1','294','3','63',1257,'17','2',49240.88,50664.87,1423.99,1110712.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','63',1258,'18','2',2630.04,2630.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','63',1259,'19','2',5638.83,5638.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','63',1260,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','64',1261,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','64',1262,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','64',1263,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','64',1264,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','64',1265,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','64',1266,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','64',1267,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','64',1268,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','64',1269,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','64',1270,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','64',1271,'11','1',50936.81,50936.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','64',1272,'12','1',58138.14,60099.64,1961.50,349147.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','64',1273,'13','1',8209.54,8476.83,267.29,47577.62,0.00,0.00,0.00,0.00,0.00),('1','294','2','64',1274,'14','1',77831.77,79847.27,2015.50,358759.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','64',1275,'15','1',42265.45,42636.04,370.59,65965.02,0.00,0.00,0.00,0.00,0.00),('1','294','2','64',1276,'16','1',23513.23,25620.55,2107.32,375102.96,0.00,0.00,0.00,0.00,0.00),('1','294','3','64',1277,'17','2',50664.87,51247.26,582.39,454264.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','64',1278,'18','2',2630.04,3133.91,503.87,393018.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','64',1279,'19','2',5638.83,5638.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','64',1280,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','65',1281,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','65',1282,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','65',1283,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','65',1284,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','65',1285,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','65',1286,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','65',1287,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','65',1288,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','65',1289,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','65',1290,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','65',1291,'11','1',50936.81,50936.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','65',1292,'12','1',60099.64,60099.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','65',1293,'13','1',8476.83,8476.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','65',1294,'14','1',79847.27,79847.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','65',1295,'15','1',42636.04,42636.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','65',1296,'16','1',25620.55,25620.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','65',1297,'17','2',51247.26,53157.02,1909.76,1489612.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','65',1298,'18','2',3133.91,3133.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','65',1299,'19','2',5638.83,5638.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','65',1300,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','66',1301,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','66',1302,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','66',1303,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','66',1304,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','66',1305,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','66',1306,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','66',1307,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','66',1308,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','66',1309,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','66',1310,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','66',1311,'11','1',50936.81,50936.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','66',1312,'12','1',60099.64,60099.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','66',1313,'13','1',8476.83,8476.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','66',1314,'14','1',79847.27,79847.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','66',1315,'15','1',42636.04,42636.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','66',1316,'16','1',25620.55,25620.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','66',1317,'17','2',53157.02,54619.28,1462.26,1140562.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','66',1318,'18','2',3133.91,3133.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','66',1319,'19','2',5638.83,5638.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','66',1320,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','67',1321,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','67',1322,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','67',1323,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','67',1324,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','67',1325,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','67',1326,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','67',1327,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','67',1328,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','67',1329,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','67',1330,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','67',1331,'11','1',50936.81,50936.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','67',1332,'12','1',60099.64,60099.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','67',1333,'13','1',8476.83,8476.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','67',1334,'14','1',79847.27,79847.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','67',1335,'15','1',42636.04,42636.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','67',1336,'16','1',25620.55,25620.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','67',1337,'17','2',54619.28,54850.05,230.77,180000.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','67',1338,'18','2',3133.91,3133.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','67',1339,'19','2',5638.83,5638.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','67',1340,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','68',1341,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','68',1342,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','68',1343,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','68',1344,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','68',1345,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','68',1346,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','68',1347,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','68',1348,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','68',1349,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','68',1350,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','68',1351,'11','1',50936.81,50936.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','68',1352,'12','1',60099.64,61654.43,1554.79,276752.62,0.00,0.00,0.00,0.00,0.00),('1','294','2','68',1353,'13','1',8476.83,8640.08,163.25,29058.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','68',1354,'14','1',79847.27,81571.57,1724.30,306925.40,0.00,0.00,0.00,0.00,0.00),('1','294','2','68',1355,'15','1',42636.04,43828.41,1192.37,212241.86,0.00,0.00,0.00,0.00,0.00),('1','294','2','68',1356,'16','1',25620.55,25914.99,294.44,52410.32,0.00,0.00,0.00,0.00,0.00),('1','294','3','68',1357,'17','2',54850.05,55617.76,767.71,598813.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','68',1358,'18','2',3133.91,3133.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','68',1359,'19','2',5638.83,5638.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','68',1360,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','69',1361,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','69',1362,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','69',1363,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','69',1364,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','69',1365,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','69',1366,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','69',1367,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','69',1368,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','69',1369,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','69',1370,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','69',1371,'11','1',50936.81,50936.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','69',1372,'12','1',61654.43,63286.90,1632.47,290579.66,0.00,0.00,0.00,0.00,0.00),('1','294','2','69',1373,'13','1',8640.08,8807.66,167.58,29829.24,0.00,0.00,0.00,0.00,0.00),('1','294','2','69',1374,'14','1',81571.57,83272.47,1700.90,302760.20,0.00,0.00,0.00,0.00,0.00),('1','294','2','69',1375,'15','1',43828.41,45703.58,1875.17,333780.26,0.00,0.00,0.00,0.00,0.00),('1','294','2','69',1376,'16','1',25914.99,25914.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','69',1377,'17','2',55617.76,56019.30,401.54,313201.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','69',1378,'18','2',3133.91,3133.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','69',1379,'19','2',5638.83,5638.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','69',1380,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','70',1381,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','70',1382,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','70',1383,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','70',1384,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','70',1385,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','70',1386,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','70',1387,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','70',1388,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','70',1389,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','70',1390,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','70',1391,'11','1',50936.81,50936.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','70',1392,'12','1',63286.90,65375.35,2088.45,371744.10,0.00,0.00,0.00,0.00,0.00),('1','294','2','70',1393,'13','1',8807.66,9498.30,690.64,122933.92,0.00,0.00,0.00,0.00,0.00),('1','294','2','70',1394,'14','1',83272.47,85303.80,2031.33,361576.74,0.00,0.00,0.00,0.00,0.00),('1','294','2','70',1395,'15','1',45703.58,47604.92,1901.34,338438.52,0.00,0.00,0.00,0.00,0.00),('1','294','2','70',1396,'16','1',25914.99,27616.63,1701.64,302891.92,0.00,0.00,0.00,0.00,0.00),('1','294','3','70',1397,'17','2',56019.30,57122.91,1103.61,860815.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','70',1398,'18','2',3133.91,3133.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','70',1399,'19','2',5638.83,6219.60,580.77,453000.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','70',1400,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','71',1401,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','71',1402,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','71',1403,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','71',1404,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','71',1405,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','71',1406,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','71',1407,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','71',1408,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','71',1409,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','71',1410,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','71',1411,'11','1',50936.81,50936.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','71',1412,'12','1',65375.35,67663.13,2287.78,407224.84,0.00,0.00,0.00,0.00,0.00),('1','294','2','71',1413,'13','1',9498.30,9498.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','71',1414,'14','1',85303.80,86963.54,1659.74,295433.72,0.00,0.00,0.00,0.00,0.00),('1','294','2','71',1415,'15','1',47604.92,49970.08,2365.16,420998.48,0.00,0.00,0.00,0.00,0.00),('1','294','2','71',1416,'16','1',27616.63,27616.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','71',1417,'17','2',57122.91,57743.05,620.14,483709.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','71',1418,'18','2',3133.91,3133.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','71',1419,'19','2',6219.60,6219.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','71',1420,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','72',1421,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','72',1422,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','72',1423,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','72',1424,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','72',1425,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','72',1426,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','72',1427,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','72',1428,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','72',1429,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','72',1430,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','72',1431,'11','1',50936.81,53446.00,2509.19,446635.82,0.00,0.00,0.00,0.00,0.00),('1','294','2','72',1432,'12','1',67663.13,67663.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','72',1433,'13','1',9498.30,10626.50,1128.20,200819.60,0.00,0.00,0.00,0.00,0.00),('1','294','2','72',1434,'14','1',86963.54,88783.25,1819.71,323908.38,0.00,0.00,0.00,0.00,0.00),('1','294','2','72',1435,'15','1',49970.08,51744.07,1773.99,315770.22,0.00,0.00,0.00,0.00,0.00),('1','294','2','72',1436,'16','1',27616.63,28682.40,1065.77,189707.06,0.00,0.00,0.00,0.00,0.00),('1','294','3','72',1437,'17','2',57743.05,58116.63,373.58,291392.40,0.00,0.00,0.00,0.00,0.00),('1','294','3','72',1438,'18','2',3133.91,3133.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','72',1439,'19','2',6219.60,6219.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','72',1440,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','73',1441,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','73',1442,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','73',1443,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','73',1444,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','73',1445,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','73',1446,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','73',1447,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','73',1448,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','73',1449,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','73',1450,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','73',1451,'11','1',53446.00,54894.83,1448.83,257891.74,0.00,0.00,0.00,0.00,0.00),('1','294','2','73',1452,'12','1',67663.13,69252.05,1588.92,282827.76,0.00,0.00,0.00,0.00,0.00),('1','294','2','73',1453,'13','1',10626.50,10724.07,97.57,17367.46,0.00,0.00,0.00,0.00,0.00),('1','294','2','73',1454,'14','1',88783.25,90875.21,2091.96,372368.88,0.00,0.00,0.00,0.00,0.00),('1','294','2','73',1455,'15','1',51744.07,53132.10,1388.03,247069.34,0.00,0.00,0.00,0.00,0.00),('1','294','2','73',1456,'16','1',28682.40,28682.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','73',1457,'17','2',58116.63,58116.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','73',1458,'18','2',3133.91,3133.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','73',1459,'19','2',6219.60,6219.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','73',1460,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','74',1461,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','74',1462,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','74',1463,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','74',1464,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','74',1465,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','74',1466,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','74',1467,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','74',1468,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','74',1469,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','74',1470,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','74',1471,'11','1',54894.83,57408.48,2513.65,447429.70,0.00,0.00,0.00,0.00,0.00),('1','294','2','74',1472,'12','1',69252.05,69252.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','74',1473,'13','1',10724.07,11107.75,383.68,68295.04,0.00,0.00,0.00,0.00,0.00),('1','294','2','74',1474,'14','1',90875.21,92598.18,1722.97,306688.66,0.00,0.00,0.00,0.00,0.00),('1','294','2','74',1475,'15','1',53132.10,54140.55,1008.45,179504.10,0.00,0.00,0.00,0.00,0.00),('1','294','2','74',1476,'16','1',28682.40,31052.45,2370.05,421868.90,0.00,0.00,0.00,0.00,0.00),('1','294','3','74',1477,'17','2',58116.63,58116.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','74',1478,'18','2',3133.91,3133.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','74',1479,'19','2',6219.60,6219.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','74',1480,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','75',1481,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','75',1482,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','75',1483,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','75',1484,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','75',1485,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','75',1486,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','75',1487,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','75',1488,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','75',1489,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','75',1490,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','75',1491,'11','1',57408.48,58825.39,1416.91,252209.98,0.00,0.00,0.00,0.00,0.00),('1','294','2','75',1492,'12','1',69252.05,70765.47,1513.42,269388.76,0.00,0.00,0.00,0.00,0.00),('1','294','2','75',1493,'13','1',11107.75,11330.48,222.73,39645.94,0.00,0.00,0.00,0.00,0.00),('1','294','2','75',1494,'14','1',92598.18,94541.63,1943.45,345934.10,0.00,0.00,0.00,0.00,0.00),('1','294','2','75',1495,'15','1',54140.55,55431.55,1291.00,229798.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','75',1496,'16','1',31052.45,31052.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','75',1497,'17','2',58116.63,58116.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','75',1498,'18','2',3133.91,3133.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','75',1499,'19','2',6219.60,6219.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','75',1500,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','76',1501,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','76',1502,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','76',1503,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','76',1504,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','76',1505,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','76',1506,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','76',1507,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','76',1508,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','76',1509,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','76',1510,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','76',1511,'11','1',58825.39,60088.56,1263.17,224844.26,0.00,0.00,0.00,0.00,0.00),('1','294','2','76',1512,'12','1',70765.47,72098.91,1333.44,237352.32,0.00,0.00,0.00,0.00,0.00),('1','294','2','76',1513,'13','1',11330.48,11926.46,595.98,106084.44,0.00,0.00,0.00,0.00,0.00),('1','294','2','76',1514,'14','1',94541.63,95846.24,1304.61,232220.58,0.00,0.00,0.00,0.00,0.00),('1','294','2','76',1515,'15','1',55431.55,56884.18,1452.63,258568.14,0.00,0.00,0.00,0.00,0.00),('1','294','2','76',1516,'16','1',31052.45,31052.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','76',1517,'17','2',58116.63,58116.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','76',1518,'18','2',3133.91,3133.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','76',1519,'19','2',6219.60,6219.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','76',1520,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','77',1521,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','77',1522,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','77',1523,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','77',1524,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','77',1525,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','77',1526,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','77',1527,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','77',1528,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','77',1529,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','77',1530,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','77',1531,'11','1',60088.56,60088.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','77',1532,'12','1',72098.91,72098.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','77',1533,'13','1',11926.46,11926.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','77',1534,'14','1',95846.24,95846.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','77',1535,'15','1',56884.18,56884.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','77',1536,'16','1',31052.45,31052.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','77',1537,'17','2',58116.63,58116.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','77',1538,'18','2',3133.91,3133.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','77',1539,'19','2',6219.60,6219.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','77',1540,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','78',1541,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','78',1542,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','78',1543,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','78',1544,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','78',1545,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','78',1546,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','78',1547,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','78',1548,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','78',1549,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','78',1550,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','78',1551,'11','1',60088.56,60088.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','78',1552,'12','1',72098.91,72098.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','78',1553,'13','1',11926.46,11926.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','78',1554,'14','1',95846.24,95846.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','78',1555,'15','1',56884.18,56884.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','78',1556,'16','1',31052.45,31052.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','78',1557,'17','2',58116.63,58116.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','78',1558,'18','2',3133.91,3133.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','78',1559,'19','2',6219.60,6219.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','78',1560,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','79',1561,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','79',1562,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','79',1563,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','79',1564,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','79',1565,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','79',1566,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','79',1567,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','79',1568,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','79',1569,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','79',1570,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','79',1571,'11','1',60088.56,60088.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','79',1572,'12','1',72098.91,72098.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','79',1573,'13','1',11926.46,11926.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','79',1574,'14','1',95846.24,95846.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','79',1575,'15','1',56884.18,56884.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','79',1576,'16','1',31052.45,31052.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','79',1577,'17','2',58116.63,58116.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','79',1578,'18','2',3133.91,3133.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','79',1579,'19','2',6219.60,6219.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','79',1580,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','80',1581,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','80',1582,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','80',1583,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','80',1584,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','80',1585,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','80',1586,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','80',1587,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','80',1588,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','80',1589,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','80',1590,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','80',1591,'11','1',60088.56,60848.74,760.18,135312.04,0.00,0.00,0.00,0.00,0.00),('1','294','2','80',1592,'12','1',72098.91,72099.10,0.19,33.82,0.00,0.00,0.00,0.00,0.00),('1','294','2','80',1593,'13','1',11926.46,12437.81,511.35,91020.30,0.00,0.00,0.00,0.00,0.00),('1','294','2','80',1594,'14','1',95846.24,96611.88,765.64,136283.92,0.00,0.00,0.00,0.00,0.00),('1','294','2','80',1595,'15','1',56884.18,57501.37,617.19,109859.82,0.00,0.00,0.00,0.00,0.00),('1','294','2','80',1596,'16','1',31052.45,32955.68,1903.23,338774.94,0.00,0.00,0.00,0.00,0.00),('1','294','3','80',1597,'17','2',58116.63,58116.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','80',1598,'18','2',3133.91,3133.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','80',1599,'19','2',6219.60,6219.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','80',1600,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','81',1601,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','81',1602,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','81',1603,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','81',1604,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','81',1605,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','81',1606,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','81',1607,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','81',1608,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','81',1609,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','81',1610,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','81',1611,'11','1',60848.74,63286.59,2437.85,433937.30,0.00,0.00,0.00,0.00,0.00),('1','294','2','81',1612,'12','1',72099.10,73925.63,1826.53,325122.34,0.00,0.00,0.00,0.00,0.00),('1','294','2','81',1613,'13','1',12437.81,12606.15,168.34,29964.52,0.00,0.00,0.00,0.00,0.00),('1','294','2','81',1614,'14','1',96611.88,98847.14,2235.26,397876.28,0.00,0.00,0.00,0.00,0.00),('1','294','2','81',1615,'15','1',57501.37,59171.03,1669.66,297199.48,0.00,0.00,0.00,0.00,0.00),('1','294','2','81',1616,'16','1',32955.68,33386.17,430.49,76627.22,0.00,0.00,0.00,0.00,0.00),('1','294','3','81',1617,'17','2',58116.63,58116.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','81',1618,'18','2',3133.91,3133.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','81',1619,'19','2',6219.60,6219.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','81',1620,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','82',1621,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','82',1622,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','82',1623,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','82',1624,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','82',1625,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','82',1626,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','82',1627,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','82',1628,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','82',1629,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','82',1630,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','82',1631,'11','1',63286.59,65623.75,2337.16,416014.48,0.00,0.00,0.00,0.00,0.00),('1','294','2','82',1632,'12','1',73925.63,75171.01,1245.38,221677.64,0.00,0.00,0.00,0.00,0.00),('1','294','2','82',1633,'13','1',12606.15,13283.90,677.75,120639.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','82',1634,'14','1',98847.14,101453.41,2606.27,463916.06,0.00,0.00,0.00,0.00,0.00),('1','294','2','82',1635,'15','1',59171.03,62692.32,3521.29,626789.62,0.00,0.00,0.00,0.00,0.00),('1','294','2','82',1636,'16','1',33386.17,33386.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','82',1637,'17','2',58116.63,60374.65,2258.02,1806416.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','82',1638,'18','2',3133.91,3133.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','82',1639,'19','2',6219.60,6669.60,450.00,360000.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','82',1640,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','83',1641,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','83',1642,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','83',1643,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','83',1644,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','83',1645,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','83',1646,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','83',1647,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','83',1648,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','83',1649,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','83',1650,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','83',1651,'11','1',65623.75,67609.13,1985.38,353397.64,0.00,0.00,0.00,0.00,0.00),('1','294','2','83',1652,'12','1',75171.01,76591.73,1420.72,252888.16,0.00,0.00,0.00,0.00,0.00),('1','294','2','83',1653,'13','1',13283.90,13408.82,124.92,22235.76,0.00,0.00,0.00,0.00,0.00),('1','294','2','83',1654,'14','1',101453.41,104684.58,3231.17,575148.26,0.00,0.00,0.00,0.00,0.00),('1','294','2','83',1655,'15','1',62692.32,63005.36,313.04,55721.12,0.00,0.00,0.00,0.00,0.00),('1','294','2','83',1656,'16','1',33386.17,36249.07,2862.90,509596.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','83',1657,'17','2',60374.65,62669.83,2295.18,1836144.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','83',1658,'18','2',3133.91,3133.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','83',1659,'19','2',6669.60,6669.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','83',1660,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','84',1661,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','84',1662,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','84',1663,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','84',1664,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','84',1665,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','84',1666,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','84',1667,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','84',1668,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','84',1669,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','84',1670,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','84',1671,'11','1',67609.13,67609.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','84',1672,'12','1',76591.73,79033.82,2442.09,434692.02,0.00,0.00,0.00,0.00,0.00),('1','294','2','84',1673,'13','1',13408.82,13984.77,575.95,102519.10,0.00,0.00,0.00,0.00,0.00),('1','294','2','84',1674,'14','1',104684.58,108345.52,3660.94,651647.32,0.00,0.00,0.00,0.00,0.00),('1','294','2','84',1675,'15','1',63005.36,63323.64,318.28,56653.84,0.00,0.00,0.00,0.00,0.00),('1','294','2','84',1676,'16','1',36249.07,38892.93,2643.86,470607.08,0.00,0.00,0.00,0.00,0.00),('1','294','3','84',1677,'17','2',62669.83,64116.95,1447.12,1157696.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','84',1678,'18','2',3133.91,3133.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','84',1679,'19','2',6669.60,6669.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','84',1680,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','85',1681,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','85',1682,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','85',1683,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','85',1684,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','85',1685,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','85',1686,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','85',1687,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','85',1688,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','85',1689,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','85',1690,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','85',1691,'11','1',67609.13,71116.65,3507.52,624338.56,0.00,0.00,0.00,0.00,0.00),('1','294','2','85',1692,'12','1',79033.82,79033.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','85',1693,'13','1',13984.77,14041.32,56.55,10065.90,0.00,0.00,0.00,0.00,0.00),('1','294','2','85',1694,'14','1',108345.52,111183.67,2838.15,505190.70,0.00,0.00,0.00,0.00,0.00),('1','294','2','85',1695,'15','1',63323.64,65558.62,2234.98,397826.44,0.00,0.00,0.00,0.00,0.00),('1','294','2','85',1696,'16','1',38892.93,39280.13,387.20,68921.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','85',1697,'17','2',64116.95,65254.00,1137.05,909640.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','85',1698,'18','2',3133.91,3133.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','85',1699,'19','2',6669.60,6669.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','85',1700,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','86',1701,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','86',1702,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','86',1703,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','86',1704,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','86',1705,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','86',1706,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','86',1707,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','86',1708,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','86',1709,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','86',1710,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','86',1711,'11','1',71116.65,71116.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','86',1712,'12','1',79033.82,81869.68,2835.86,504783.08,0.00,0.00,0.00,0.00,0.00),('1','294','2','86',1713,'13','1',14041.32,14918.34,877.02,156109.56,0.00,0.00,0.00,0.00,0.00),('1','294','2','86',1714,'14','1',111183.67,112991.81,1808.14,321848.92,0.00,0.00,0.00,0.00,0.00),('1','294','2','86',1715,'15','1',65558.62,67672.19,2113.57,376215.46,0.00,0.00,0.00,0.00,0.00),('1','294','2','86',1716,'16','1',39280.13,39447.89,167.76,29861.28,0.00,0.00,0.00,0.00,0.00),('1','294','3','86',1717,'17','2',65254.00,66171.01,917.01,733608.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','86',1718,'18','2',3133.91,3133.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','86',1719,'19','2',6669.60,6669.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','86',1720,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','87',1721,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','87',1722,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','87',1723,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','87',1724,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','87',1725,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','87',1726,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','87',1727,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','87',1728,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','87',1729,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','87',1730,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','87',1731,'11','1',71116.65,71160.02,43.37,7719.86,0.00,0.00,0.00,0.00,0.00),('1','294','2','87',1732,'12','1',81869.68,81913.87,44.19,7865.82,0.00,0.00,0.00,0.00,0.00),('1','294','2','87',1733,'13','1',14918.34,14918.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','87',1734,'14','1',112991.81,112991.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','87',1735,'15','1',67672.19,67672.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','87',1736,'16','1',39447.89,39447.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','87',1737,'17','2',66171.01,67301.07,1130.06,904048.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','87',1738,'18','2',3133.91,3133.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','87',1739,'19','2',6669.60,6669.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','87',1740,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','88',1741,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','88',1742,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','88',1743,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','88',1744,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','88',1745,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','88',1746,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','88',1747,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','88',1748,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','88',1749,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','88',1750,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','88',1751,'11','1',71160.02,71160.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','88',1752,'12','1',81913.87,81913.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','88',1753,'13','1',14918.34,14918.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','88',1754,'14','1',112991.81,112991.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','88',1755,'15','1',67672.19,67672.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','88',1756,'16','1',39447.89,39447.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','88',1757,'17','2',67301.07,68138.74,837.67,670136.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','88',1758,'18','2',3133.91,3133.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','88',1759,'19','2',6669.60,6669.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','88',1760,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','89',1761,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','89',1762,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','89',1763,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','89',1764,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','89',1765,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','89',1766,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','89',1767,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','89',1768,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','89',1769,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','89',1770,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','89',1771,'11','1',71160.02,71160.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','89',1772,'12','1',81913.87,81913.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','89',1773,'13','1',14918.34,14918.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','89',1774,'14','1',112991.81,112991.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','89',1775,'15','1',67672.19,67672.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','89',1776,'16','1',39447.89,39447.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','89',1777,'17','2',68138.74,69289.24,1150.50,920400.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','89',1778,'18','2',3133.91,3133.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','89',1779,'19','2',6669.60,6669.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','89',1780,'20','2',947.34,947.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','90',1781,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','90',1782,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','90',1783,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','90',1784,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','90',1785,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','90',1786,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','90',1787,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','90',1788,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','90',1789,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','90',1790,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','90',1791,'11','1',71160.02,71160.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','90',1792,'12','1',81913.87,81913.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','90',1793,'13','1',14918.34,14918.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','90',1794,'14','1',112991.81,112991.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','90',1795,'15','1',67672.19,67672.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','90',1796,'16','1',39447.89,39447.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','90',1797,'17','2',69289.24,70096.94,807.70,646160.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','90',1798,'18','2',3133.91,3549.06,415.15,332120.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','90',1799,'19','2',6669.60,7189.60,520.00,416000.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','90',1800,'20','2',947.34,967.34,20.00,16000.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','91',1801,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','91',1802,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','91',1803,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','91',1804,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','91',1805,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','91',1806,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','91',1807,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','91',1808,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','91',1809,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','91',1810,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','91',1811,'11','1',71160.02,71160.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','91',1812,'12','1',81913.87,81913.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','91',1813,'13','1',14918.34,14918.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','91',1814,'14','1',112991.81,112991.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','91',1815,'15','1',67672.19,67672.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','91',1816,'16','1',39447.89,39447.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','91',1817,'17','2',70096.94,70492.19,395.25,316200.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','91',1818,'18','2',3549.06,3549.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','91',1819,'19','2',7189.60,7189.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','91',1820,'20','2',967.34,967.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','92',1821,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','92',1822,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','92',1823,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','92',1824,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','92',1825,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','92',1826,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','92',1827,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','92',1828,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','92',1829,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','92',1830,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','92',1831,'11','1',71160.02,71160.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','92',1832,'12','1',81913.87,81913.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','92',1833,'13','1',14918.34,14918.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','92',1834,'14','1',112991.81,112991.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','92',1835,'15','1',67672.19,67672.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','92',1836,'16','1',39447.89,39447.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','92',1837,'17','2',70492.19,71498.30,1006.11,804888.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','92',1838,'18','2',3549.06,3549.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','92',1839,'19','2',7189.60,7189.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','92',1840,'20','2',967.34,967.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','93',1841,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','93',1842,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','93',1843,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','93',1844,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','93',1845,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','93',1846,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','93',1847,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','93',1848,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','93',1849,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','93',1850,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','93',1851,'11','1',71160.02,71160.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','93',1852,'12','1',81913.87,81913.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','93',1853,'13','1',14918.34,14918.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','93',1854,'14','1',112991.81,112991.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','93',1855,'15','1',67672.19,67672.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','93',1856,'16','1',39447.89,39447.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','93',1857,'17','2',71498.30,72668.75,1170.45,936360.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','93',1858,'18','2',3549.06,3549.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','93',1859,'19','2',7189.60,7189.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','93',1860,'20','2',967.34,967.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','94',1861,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','94',1862,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','94',1863,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','94',1864,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','94',1865,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','94',1866,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','94',1867,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','94',1868,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','94',1869,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','94',1870,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','94',1871,'11','1',71160.02,71160.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','94',1872,'12','1',81913.87,81913.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','94',1873,'13','1',14918.34,14918.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','94',1874,'14','1',112991.81,112991.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','94',1875,'15','1',67672.19,67672.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','94',1876,'16','1',39447.89,39447.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','94',1877,'17','2',72668.75,74362.00,1693.25,1354600.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','94',1878,'18','2',3549.06,3549.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','94',1879,'19','2',7189.60,7189.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','94',1880,'20','2',967.34,967.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','95',1881,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','95',1882,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','95',1883,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','95',1884,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','95',1885,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','95',1886,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','95',1887,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','95',1888,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','95',1889,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','95',1890,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','95',1891,'11','1',71160.02,71160.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','95',1892,'12','1',81913.87,81913.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','95',1893,'13','1',14918.34,14918.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','95',1894,'14','1',112991.81,112991.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','95',1895,'15','1',67672.19,67672.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','95',1896,'16','1',39447.89,39447.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','95',1897,'17','2',74362.00,75665.96,1303.96,1043168.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','95',1898,'18','2',3549.06,3549.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','95',1899,'19','2',7189.60,7189.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','95',1900,'20','2',967.34,967.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','96',1901,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','96',1902,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','96',1903,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','96',1904,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','96',1905,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','96',1906,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','96',1907,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','96',1908,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','96',1909,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','96',1910,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','96',1911,'11','1',71160.02,71160.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','96',1912,'12','1',81913.87,81913.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','96',1913,'13','1',14918.34,14918.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','96',1914,'14','1',112991.81,112991.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','96',1915,'15','1',67672.19,67672.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','96',1916,'16','1',39447.89,39447.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','96',1917,'17','2',75665.96,77064.64,1398.68,1118944.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','96',1918,'18','2',3549.06,3549.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','96',1919,'19','2',7189.60,7669.60,480.00,384000.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','96',1920,'20','2',967.34,967.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','97',1921,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','97',1922,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','97',1923,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','97',1924,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','97',1925,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','97',1926,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','97',1927,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','97',1928,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','97',1929,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','97',1930,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','97',1931,'11','1',71160.02,71160.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','97',1932,'12','1',81913.87,81913.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','97',1933,'13','1',14918.34,14918.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','97',1934,'14','1',112991.81,112991.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','97',1935,'15','1',67672.19,67672.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','97',1936,'16','1',39447.89,39447.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','97',1937,'17','2',77064.64,78019.64,955.00,764000.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','97',1938,'18','2',3549.06,3549.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','97',1939,'19','2',7669.60,7845.60,176.00,140800.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','97',1940,'20','2',967.34,967.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','98',1941,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','98',1942,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','98',1943,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','98',1944,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','98',1945,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','98',1946,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','98',1947,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','98',1948,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','98',1949,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','98',1950,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','98',1951,'11','1',71160.02,71160.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','98',1952,'12','1',81913.87,81913.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','98',1953,'13','1',14918.34,14918.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','98',1954,'14','1',112991.81,112991.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','98',1955,'15','1',67672.19,67672.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','98',1956,'16','1',39447.89,39447.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','98',1957,'17','2',78019.64,80983.81,2964.17,2371336.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','98',1958,'18','2',3549.06,3704.76,155.70,124560.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','98',1959,'19','2',7845.60,7845.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','98',1960,'20','2',967.34,967.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','99',1961,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','99',1962,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','99',1963,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','99',1964,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','99',1965,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','99',1966,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','99',1967,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','99',1968,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','99',1969,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','99',1970,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','99',1971,'11','1',71160.02,71160.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','99',1972,'12','1',81913.87,81913.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','99',1973,'13','1',14918.34,14918.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','99',1974,'14','1',112991.81,112991.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','99',1975,'15','1',67672.19,67672.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','99',1976,'16','1',39447.89,39447.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','99',1977,'17','2',80983.81,82583.95,1600.14,1280112.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','99',1978,'18','2',3704.76,3704.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','99',1979,'19','2',7845.60,7845.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','99',1980,'20','2',967.34,967.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','100',1981,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','100',1982,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','100',1983,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','100',1984,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','100',1985,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','100',1986,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','100',1987,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','100',1988,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','100',1989,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','100',1990,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','100',1991,'11','1',71160.02,71160.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','100',1992,'12','1',81913.87,81913.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','100',1993,'13','1',14918.34,14918.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','100',1994,'14','1',112991.81,112991.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','100',1995,'15','1',67672.19,67672.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','100',1996,'16','1',39447.89,39447.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','100',1997,'17','2',82583.95,84522.39,1938.44,1550752.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','100',1998,'18','2',3704.76,3714.76,10.00,8000.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','100',1999,'19','2',7845.60,8491.35,645.75,516600.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','100',2000,'20','2',967.34,967.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','101',2001,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','101',2002,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','101',2003,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','101',2004,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','101',2005,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','101',2006,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','101',2007,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','101',2008,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','101',2009,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','101',2010,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','101',2011,'11','1',71160.02,71160.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','101',2012,'12','1',81913.87,81913.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','101',2013,'13','1',14918.34,14918.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','101',2014,'14','1',112991.81,112991.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','101',2015,'15','1',67672.19,67672.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','101',2016,'16','1',39447.89,39447.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','101',2017,'17','2',84522.39,87229.83,2707.44,2165952.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','101',2018,'18','2',3714.76,3714.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','101',2019,'19','2',8491.35,8591.35,100.00,80000.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','101',2020,'20','2',967.34,967.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','102',2021,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','102',2022,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','102',2023,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','102',2024,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','102',2025,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','102',2026,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','102',2027,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','102',2028,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','102',2029,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','102',2030,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','102',2031,'11','1',71160.02,71160.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','102',2032,'12','1',81913.87,81913.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','102',2033,'13','1',14918.34,14918.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','102',2034,'14','1',112991.81,112991.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','102',2035,'15','1',67672.19,67672.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','102',2036,'16','1',39447.89,39447.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','102',2037,'17','2',87229.83,87988.83,759.00,607200.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','102',2038,'18','2',3714.76,3714.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','102',2039,'19','2',8591.35,8591.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','102',2040,'20','2',967.34,967.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','103',2041,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','103',2042,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','103',2043,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','103',2044,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','103',2045,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','103',2046,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','103',2047,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','103',2048,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','103',2049,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','103',2050,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','103',2051,'11','1',71160.02,71160.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','103',2052,'12','1',81913.87,81913.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','103',2053,'13','1',14918.34,14918.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','103',2054,'14','1',112991.81,112991.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','103',2055,'15','1',67672.19,67672.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','103',2056,'16','1',39447.89,39447.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','103',2057,'17','2',87988.83,89018.24,1029.41,823528.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','103',2058,'18','2',3714.76,3734.76,20.00,16000.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','103',2059,'19','2',8591.35,9370.30,778.95,623160.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','103',2060,'20','2',967.34,977.34,10.00,8000.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','104',2061,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','104',2062,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','104',2063,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','104',2064,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','104',2065,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','104',2066,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','104',2067,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','104',2068,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','104',2069,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','104',2070,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','104',2071,'11','1',71160.02,71160.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','104',2072,'12','1',81913.87,81913.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','104',2073,'13','1',14918.34,14918.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','104',2074,'14','1',112991.81,112991.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','104',2075,'15','1',67672.19,67672.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','104',2076,'16','1',39447.89,39447.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','104',2077,'17','2',89018.24,89416.49,398.25,318600.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','104',2078,'18','2',3734.76,3734.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','104',2079,'19','2',9370.30,9370.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','104',2080,'20','2',977.34,977.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','105',2081,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','105',2082,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','105',2083,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','105',2084,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','105',2085,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','105',2086,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','105',2087,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','105',2088,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','105',2089,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','105',2090,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','105',2091,'11','1',71160.02,71160.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','105',2092,'12','1',81913.87,81913.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','105',2093,'13','1',14918.34,14918.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','105',2094,'14','1',112991.81,112991.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','105',2095,'15','1',67672.19,67672.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','105',2096,'16','1',39447.89,39447.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','105',2097,'17','2',89416.49,91733.76,2317.27,1853816.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','105',2098,'18','2',3734.76,3834.76,100.00,80000.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','105',2099,'19','2',9370.30,9370.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','105',2100,'20','2',977.34,2357.47,1380.13,1104104.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','106',2101,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','106',2102,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','106',2103,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','106',2104,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','106',2105,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','106',2106,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','106',2107,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','106',2108,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','106',2109,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','106',2110,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','106',2111,'11','1',71160.02,71160.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','106',2112,'12','1',81913.87,81913.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','106',2113,'13','1',14918.34,14918.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','106',2114,'14','1',112991.81,112991.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','106',2115,'15','1',67672.19,67672.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','106',2116,'16','1',39447.89,39447.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','106',2117,'17','2',91733.76,94200.29,2466.53,1973224.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','106',2118,'18','2',3834.76,3834.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','106',2119,'19','2',9370.30,9370.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','106',2120,'20','2',2357.47,2722.47,365.00,292000.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','107',2121,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','107',2122,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','107',2123,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','107',2124,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','107',2125,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','107',2126,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','107',2127,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','107',2128,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','107',2129,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','107',2130,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','107',2131,'11','1',71160.02,71160.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','107',2132,'12','1',81913.87,81913.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','107',2133,'13','1',14918.34,14918.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','107',2134,'14','1',112991.81,112991.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','107',2135,'15','1',67672.19,67672.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','107',2136,'16','1',39447.89,39447.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','107',2137,'17','2',94200.29,96512.88,2312.59,1850072.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','107',2138,'18','2',3834.76,6571.26,2736.50,2189200.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','107',2139,'19','2',9370.30,9778.80,408.50,326800.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','107',2140,'20','2',2722.47,4891.85,2169.38,1735504.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','108',2141,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','108',2142,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','108',2143,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','108',2144,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','108',2145,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','108',2146,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','108',2147,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','108',2148,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','108',2149,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','108',2150,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','108',2151,'11','1',71160.02,71160.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','108',2152,'12','1',81913.87,81913.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','108',2153,'13','1',14918.34,14918.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','108',2154,'14','1',112991.81,112991.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','108',2155,'15','1',67672.19,67672.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','108',2156,'16','1',39447.89,39447.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','108',2157,'17','2',96512.88,98426.78,1913.90,1531120.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','108',2158,'18','2',6571.26,6571.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','108',2159,'19','2',9778.80,9778.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','108',2160,'20','2',4891.85,4891.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','109',2161,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','109',2162,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','109',2163,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','109',2164,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','109',2165,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','109',2166,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','109',2167,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','109',2168,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','109',2169,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','109',2170,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','109',2171,'11','1',71160.02,71160.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','109',2172,'12','1',81913.87,81913.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','109',2173,'13','1',14918.34,14918.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','109',2174,'14','1',112991.81,112991.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','109',2175,'15','1',67672.19,67672.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','109',2176,'16','1',39447.89,39447.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','109',2177,'17','2',98426.78,102612.56,4185.78,3348624.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','109',2178,'18','2',6571.26,7336.80,765.54,612432.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','109',2179,'19','2',9778.80,9778.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','109',2180,'20','2',4891.85,6068.95,1177.10,941680.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','110',2181,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','110',2182,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','110',2183,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','110',2184,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','110',2185,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','110',2186,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','110',2187,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','110',2188,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','110',2189,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','110',2190,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','110',2191,'11','1',71160.02,71160.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','110',2192,'12','1',81913.87,81913.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','110',2193,'13','1',14918.34,14918.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','110',2194,'14','1',112991.81,112991.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','110',2195,'15','1',67672.19,67672.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','110',2196,'16','1',39447.89,39447.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','110',2197,'17','2',102612.56,103628.31,1015.75,812600.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','110',2198,'18','2',7336.80,7336.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','110',2199,'19','2',9778.80,9778.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','110',2200,'20','2',6068.95,6068.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','111',2201,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','111',2202,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','111',2203,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','111',2204,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','111',2205,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','111',2206,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','111',2207,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','111',2208,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','111',2209,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','111',2210,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','111',2211,'11','1',71160.02,71160.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','111',2212,'12','1',81913.87,81913.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','111',2213,'13','1',14918.34,14918.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','111',2214,'14','1',112991.81,112991.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','111',2215,'15','1',67672.19,67672.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','111',2216,'16','1',39447.89,39447.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','111',2217,'17','2',103628.31,107315.77,3687.46,2949968.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','111',2218,'18','2',7336.80,7406.78,69.98,55984.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','111',2219,'19','2',9778.80,10256.80,478.00,382400.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','111',2220,'20','2',6068.95,8153.73,2084.78,1667824.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','112',2221,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','112',2222,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','112',2223,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','112',2224,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','112',2225,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','112',2226,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','112',2227,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','112',2228,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','112',2229,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','112',2230,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','112',2231,'11','1',71160.02,71160.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','112',2232,'12','1',81913.87,81913.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','112',2233,'13','1',14918.34,14918.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','112',2234,'14','1',112991.81,112991.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','112',2235,'15','1',67672.19,69154.23,1482.04,274177.40,0.00,0.00,0.00,0.00,0.00),('1','294','2','112',2236,'16','1',39447.89,40115.37,667.48,123483.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','112',2237,'17','2',107315.77,108320.77,1005.00,804000.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','112',2238,'18','2',7406.78,8783.03,1376.25,1101000.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','112',2239,'19','2',10256.80,10256.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','112',2240,'20','2',8153.73,8332.98,179.25,143400.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','113',2241,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','113',2242,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','113',2243,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','113',2244,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','113',2245,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','113',2246,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','113',2247,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','113',2248,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','113',2249,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','113',2250,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','113',2251,'11','1',71160.02,71931.04,771.02,142638.70,0.00,0.00,0.00,0.00,0.00),('1','294','2','113',2252,'12','1',81913.87,85994.64,4080.77,754942.45,0.00,0.00,0.00,0.00,0.00),('1','294','2','113',2253,'13','1',14918.34,17428.10,2509.76,464305.60,0.00,0.00,0.00,0.00,0.00),('1','294','2','113',2254,'14','1',112991.81,115462.58,2470.77,457092.45,0.00,0.00,0.00,0.00,0.00),('1','294','2','113',2255,'15','1',69154.23,71561.72,2407.49,445385.65,0.00,0.00,0.00,0.00,0.00),('1','294','2','113',2256,'16','1',40115.37,40296.12,180.75,33438.75,0.00,0.00,0.00,0.00,0.00),('1','294','3','113',2257,'17','2',108320.77,110227.00,1906.23,1524984.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','113',2258,'18','2',8783.03,9197.03,414.00,331200.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','113',2259,'19','2',10256.80,10256.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','113',2260,'20','2',8332.98,8822.00,489.02,391216.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','114',2261,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','114',2262,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','114',2263,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','114',2264,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','114',2265,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','114',2266,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','114',2267,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','114',2268,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','114',2269,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','114',2270,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','114',2271,'11','1',71931.04,73308.52,1377.48,254833.80,0.00,0.00,0.00,0.00,0.00),('1','294','2','114',2272,'12','1',85994.64,85994.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','114',2273,'13','1',17428.10,17428.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','114',2274,'14','1',115462.58,116749.44,1286.86,238069.10,0.00,0.00,0.00,0.00,0.00),('1','294','2','114',2275,'15','1',71561.72,71561.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','114',2276,'16','1',40296.12,40447.62,151.50,28027.50,0.00,0.00,0.00,0.00,0.00),('1','294','3','114',2277,'17','2',110227.00,114177.86,3950.86,3160688.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','114',2278,'18','2',9197.03,9197.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','114',2279,'19','2',10256.80,12331.05,2074.25,1659400.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','114',2280,'20','2',8822.00,8822.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','115',2281,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','115',2282,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','115',2283,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','115',2284,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','115',2285,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','115',2286,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','115',2287,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','115',2288,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','115',2289,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','115',2290,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','115',2291,'11','1',73308.52,75502.57,2194.05,405899.25,0.00,0.00,0.00,0.00,0.00),('1','294','2','115',2292,'12','1',85994.64,88815.68,2821.04,521892.40,0.00,0.00,0.00,0.00,0.00),('1','294','2','115',2293,'13','1',17428.10,17428.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','115',2294,'14','1',116749.44,116749.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','115',2295,'15','1',71561.72,75188.17,3626.45,670893.25,0.00,0.00,0.00,0.00,0.00),('1','294','2','115',2296,'16','1',40447.62,40458.43,10.81,1999.85,0.00,0.00,0.00,0.00,0.00),('1','294','3','115',2297,'17','2',114177.86,117228.07,3050.21,2440168.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','115',2298,'18','2',9197.03,9197.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','115',2299,'19','2',12331.05,12331.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','115',2300,'20','2',8822.00,8822.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','116',2301,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','116',2302,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','116',2303,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','116',2304,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','116',2305,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','116',2306,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','116',2307,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','116',2308,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','116',2309,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','116',2310,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','116',2311,'11','1',75502.57,75502.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','116',2312,'12','1',88815.68,91115.42,2299.74,425451.90,0.00,0.00,0.00,0.00,0.00),('1','294','2','116',2313,'13','1',17428.10,17428.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','116',2314,'14','1',116749.44,118794.17,2044.73,378275.05,0.00,0.00,0.00,0.00,0.00),('1','294','2','116',2315,'15','1',75188.17,76935.14,1746.97,323189.45,0.00,0.00,0.00,0.00,0.00),('1','294','2','116',2316,'16','1',40458.43,40458.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','116',2317,'17','2',117228.07,120966.89,3738.82,2991056.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','116',2318,'18','2',9197.03,9197.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','116',2319,'19','2',12331.05,13729.05,1398.00,1118400.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','116',2320,'20','2',8822.00,9275.00,453.00,362400.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','117',2321,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','117',2322,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','117',2323,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','117',2324,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','117',2325,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','117',2326,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','117',2327,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','117',2328,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','117',2329,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','117',2330,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','117',2331,'11','1',75502.57,78772.58,3270.01,604951.85,0.00,0.00,0.00,0.00,0.00),('1','294','2','117',2332,'12','1',91115.42,94347.84,3232.42,597997.70,0.00,0.00,0.00,0.00,0.00),('1','294','2','117',2333,'13','1',17428.10,20637.82,3209.72,593798.20,0.00,0.00,0.00,0.00,0.00),('1','294','2','117',2334,'14','1',118794.17,121603.72,2809.55,519766.75,0.00,0.00,0.00,0.00,0.00),('1','294','2','117',2335,'15','1',76935.14,80187.67,3252.53,601718.05,0.00,0.00,0.00,0.00,0.00),('1','294','2','117',2336,'16','1',40458.43,40661.11,202.68,37495.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','117',2337,'17','2',120966.89,123403.82,2436.93,1949544.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','117',2338,'18','2',9197.03,9197.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','117',2339,'19','2',13729.05,15455.41,1726.36,1381088.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','117',2340,'20','2',9275.00,10875.00,1600.00,1280000.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','118',2341,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','118',2342,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','118',2343,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','118',2344,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','118',2345,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','118',2346,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','118',2347,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','118',2348,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','118',2349,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','118',2350,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','118',2351,'11','1',78772.58,80018.55,1245.97,230504.45,0.00,0.00,0.00,0.00,0.00),('1','294','2','118',2352,'12','1',94347.84,94378.05,30.21,5588.85,0.00,0.00,0.00,0.00,0.00),('1','294','2','118',2353,'13','1',20637.82,20637.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','118',2354,'14','1',121603.72,122363.48,759.76,140555.60,0.00,0.00,0.00,0.00,0.00),('1','294','2','118',2355,'15','1',80187.67,80187.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','118',2356,'16','1',40661.11,40661.63,0.52,96.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','118',2357,'17','2',123403.82,125882.79,2478.97,2131914.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','118',2358,'18','2',9197.03,9197.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','118',2359,'19','2',15455.41,16362.80,907.39,780355.40,0.00,0.00,0.00,0.00,0.00),('1','294','3','118',2360,'20','2',10875.00,10875.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','119',2361,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','119',2362,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','119',2363,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','119',2364,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','119',2365,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','119',2366,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','119',2367,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','119',2368,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','119',2369,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','119',2370,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','119',2371,'11','1',80018.55,80018.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','119',2372,'12','1',94378.05,94378.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','119',2373,'13','1',20637.82,20637.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','119',2374,'14','1',122363.48,122363.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','119',2375,'15','1',80187.67,80187.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','119',2376,'16','1',40661.63,40661.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','119',2377,'17','2',125882.79,127635.00,1752.21,1506900.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','119',2378,'18','2',9197.03,10277.04,1080.01,928808.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','119',2379,'19','2',16362.80,16362.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','119',2380,'20','2',10875.00,10875.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','120',2381,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','120',2382,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','120',2383,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','120',2384,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','120',2385,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','120',2386,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','120',2387,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','120',2388,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','120',2389,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','120',2390,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','120',2391,'11','1',80018.55,80018.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','120',2392,'12','1',94378.05,94378.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','120',2393,'13','1',20637.82,20637.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','120',2394,'14','1',122363.48,122363.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','120',2395,'15','1',80187.67,80187.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','120',2396,'16','1',40661.63,40661.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','120',2397,'17','2',127635.00,130310.76,2675.76,2301153.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','120',2398,'18','2',10277.04,10277.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','120',2399,'19','2',16362.80,17157.69,794.89,683605.40,0.00,0.00,0.00,0.00,0.00),('1','294','3','120',2400,'20','2',10875.00,10875.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','121',2401,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','121',2402,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','121',2403,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','121',2404,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','121',2405,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','121',2406,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','121',2407,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','121',2408,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','121',2409,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','121',2410,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','121',2411,'11','1',80018.55,80018.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','121',2412,'12','1',94378.05,94378.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','121',2413,'13','1',20637.82,20637.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','121',2414,'14','1',122363.48,122363.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','121',2415,'15','1',80187.67,80187.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','121',2416,'16','1',40661.63,40661.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','121',2417,'17','2',130310.76,131147.82,837.06,719871.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','121',2418,'18','2',10277.04,10277.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','121',2419,'19','2',17157.69,17157.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','121',2420,'20','2',10875.00,10875.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','122',2421,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','122',2422,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','122',2423,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','122',2424,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','122',2425,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','122',2426,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','122',2427,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','122',2428,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','122',2429,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','122',2430,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','122',2431,'11','1',80018.55,80018.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','122',2432,'12','1',94378.05,94378.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','122',2433,'13','1',20637.82,20637.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','122',2434,'14','1',122363.48,122363.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','122',2435,'15','1',80187.67,80187.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','122',2436,'16','1',40661.63,40661.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','122',2437,'17','2',131147.82,133037.88,1890.06,1625451.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','122',2438,'18','2',10277.04,10277.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','122',2439,'19','2',17157.69,17157.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','122',2440,'20','2',10875.00,10875.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','123',2441,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','123',2442,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','123',2443,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','123',2444,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','123',2445,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','123',2446,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','123',2447,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','123',2448,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','123',2449,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','123',2450,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','123',2451,'11','1',80018.55,80018.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','123',2452,'12','1',94378.05,94378.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','123',2453,'13','1',20637.82,20637.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','123',2454,'14','1',122363.48,122363.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','123',2455,'15','1',80187.67,80187.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','123',2456,'16','1',40661.63,40661.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','123',2457,'17','2',133037.88,133671.91,634.03,545265.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','123',2458,'18','2',10277.04,10277.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','123',2459,'19','2',17157.69,17157.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','123',2460,'20','2',10875.00,10875.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','124',2461,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','124',2462,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','124',2463,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','124',2464,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','124',2465,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','124',2466,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','124',2467,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','124',2468,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','124',2469,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','124',2470,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','124',2471,'11','1',80018.55,80018.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','124',2472,'12','1',94378.05,94378.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','124',2473,'13','1',20637.82,20637.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','124',2474,'14','1',122363.48,122363.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','124',2475,'15','1',80187.67,80187.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','124',2476,'16','1',40661.63,40661.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','124',2477,'17','2',133671.91,134965.45,1293.54,1112444.40,0.00,0.00,0.00,0.00,0.00),('1','294','3','124',2478,'18','2',10277.04,10277.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','124',2479,'19','2',17157.69,17357.69,200.00,172000.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','124',2480,'20','2',10875.00,10875.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','125',2481,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','125',2482,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','125',2483,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','125',2484,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','125',2485,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','125',2486,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','125',2487,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','125',2488,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','125',2489,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','125',2490,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','125',2491,'11','1',80018.55,80018.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','125',2492,'12','1',94378.05,94378.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','125',2493,'13','1',20637.82,20637.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','125',2494,'14','1',122363.48,122363.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','125',2495,'15','1',80187.67,80187.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','125',2496,'16','1',40661.63,40661.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','125',2497,'17','2',134965.45,136599.56,1634.11,1405334.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','125',2498,'18','2',10277.04,10277.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','125',2499,'19','2',17357.69,17357.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','125',2500,'20','2',10875.00,10875.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','126',2501,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','126',2502,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','126',2503,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','126',2504,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','126',2505,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','126',2506,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','126',2507,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','126',2508,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','126',2509,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','126',2510,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','126',2511,'11','1',80018.55,80018.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','126',2512,'12','1',94378.05,94378.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','126',2513,'13','1',20637.82,20637.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','126',2514,'14','1',122363.48,122363.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','126',2515,'15','1',80187.67,80187.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','126',2516,'16','1',40661.63,40661.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','126',2517,'17','2',136599.56,138359.56,1760.00,1513600.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','126',2518,'18','2',10277.04,10277.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','126',2519,'19','2',17357.69,17867.69,510.00,438600.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','126',2520,'20','2',10875.00,10875.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','127',2521,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','127',2522,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','127',2523,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','127',2524,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','127',2525,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','127',2526,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','127',2527,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','127',2528,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','127',2529,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','127',2530,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','127',2531,'11','1',80018.55,80018.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','127',2532,'12','1',94378.05,94378.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','127',2533,'13','1',20637.82,20637.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','127',2534,'14','1',122363.48,122363.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','127',2535,'15','1',80187.67,80187.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','127',2536,'16','1',40661.63,40661.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','127',2537,'17','2',138359.56,139975.59,1616.03,1389785.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','127',2538,'18','2',10277.04,10277.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','127',2539,'19','2',17867.69,17867.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','127',2540,'20','2',10875.00,10875.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','128',2541,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','128',2542,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','128',2543,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','128',2544,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','128',2545,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','128',2546,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','128',2547,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','128',2548,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','128',2549,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','128',2550,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','128',2551,'11','1',80018.55,80018.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','128',2552,'12','1',94378.05,94378.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','128',2553,'13','1',20637.82,20637.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','128',2554,'14','1',122363.48,122363.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','128',2555,'15','1',80187.67,80187.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','128',2556,'16','1',40661.63,40661.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','128',2557,'17','2',139975.59,141507.89,1532.30,1317778.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','128',2558,'18','2',10277.04,10277.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','128',2559,'19','2',17867.69,17887.69,20.00,17200.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','128',2560,'20','2',10875.00,11165.81,290.81,250096.60,0.00,0.00,0.00,0.00,0.00),('1','294','1','129',2561,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','129',2562,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','129',2563,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','129',2564,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','129',2565,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','129',2566,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','129',2567,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','129',2568,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','129',2569,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','129',2570,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','129',2571,'11','1',80018.55,80212.65,194.10,35908.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','129',2572,'12','1',94378.05,96671.45,2293.40,424279.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','129',2573,'13','1',20637.82,20637.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','129',2574,'14','1',122363.48,124815.20,2451.72,453568.20,0.00,0.00,0.00,0.00,0.00),('1','294','2','129',2575,'15','1',80187.67,82515.97,2328.30,430735.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','129',2576,'16','1',40661.63,40661.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','129',2577,'17','2',141507.89,142467.09,959.20,791340.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','129',2578,'18','2',10277.04,10277.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','129',2579,'19','2',17887.69,18878.22,990.53,817187.25,0.00,0.00,0.00,0.00,0.00),('1','294','3','129',2580,'20','2',11165.81,11165.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','130',2581,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','130',2582,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','130',2583,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','130',2584,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','130',2585,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','130',2586,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','130',2587,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','130',2588,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','130',2589,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','130',2590,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','130',2591,'11','1',80212.65,80212.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','130',2592,'12','1',96671.45,97739.13,1067.68,197520.80,0.00,0.00,0.00,0.00,0.00),('1','294','2','130',2593,'13','1',20637.82,20709.88,72.06,13331.10,0.00,0.00,0.00,0.00,0.00),('1','294','2','130',2594,'14','1',124815.20,125179.35,364.15,67367.75,0.00,0.00,0.00,0.00,0.00),('1','294','2','130',2595,'15','1',82515.97,83023.90,507.93,93967.05,0.00,0.00,0.00,0.00,0.00),('1','294','2','130',2596,'16','1',40661.63,40661.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','130',2597,'17','2',142467.09,143618.90,1151.81,950243.25,0.00,0.00,0.00,0.00,0.00),('1','294','3','130',2598,'18','2',10277.04,10277.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','130',2599,'19','2',18878.22,20091.07,1212.85,1000601.25,0.00,0.00,0.00,0.00,0.00),('1','294','3','130',2600,'20','2',11165.81,11165.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','131',2601,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','131',2602,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','131',2603,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','131',2604,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','131',2605,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','131',2606,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','131',2607,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','131',2608,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','131',2609,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','131',2610,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','131',2611,'11','1',80212.65,83689.23,3476.58,643167.30,0.00,0.00,0.00,0.00,0.00),('1','294','2','131',2612,'12','1',97739.13,98041.51,302.38,55940.30,0.00,0.00,0.00,0.00,0.00),('1','294','2','131',2613,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','131',2614,'14','1',125179.35,128451.80,3272.45,605403.25,0.00,0.00,0.00,0.00,0.00),('1','294','2','131',2615,'15','1',83023.90,85555.09,2531.19,468270.15,0.00,0.00,0.00,0.00,0.00),('1','294','2','131',2616,'16','1',40661.63,40661.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','131',2617,'17','2',143618.90,144641.14,1022.24,843348.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','131',2618,'18','2',10277.04,10277.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','131',2619,'19','2',20091.07,21043.98,952.91,786150.75,0.00,0.00,0.00,0.00,0.00),('1','294','3','131',2620,'20','2',11165.81,11165.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','132',2621,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','132',2622,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','132',2623,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','132',2624,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','132',2625,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','132',2626,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','132',2627,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','132',2628,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','132',2629,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','132',2630,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','132',2631,'11','1',83689.23,83689.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','132',2632,'12','1',98041.51,98041.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','132',2633,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','132',2634,'14','1',128451.80,128451.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','132',2635,'15','1',85555.09,85555.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','132',2636,'16','1',40661.63,40661.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','132',2637,'17','2',144641.14,145831.67,1190.53,982187.25,0.00,0.00,0.00,0.00,0.00),('1','294','3','132',2638,'18','2',10277.04,10277.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','132',2639,'19','2',21043.98,21363.98,320.00,264000.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','132',2640,'20','2',11165.81,11245.81,80.00,66000.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','133',2641,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','133',2642,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','133',2643,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','133',2644,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','133',2645,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','133',2646,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','133',2647,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','133',2648,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','133',2649,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','133',2650,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','133',2651,'11','1',83689.23,83689.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','133',2652,'12','1',98041.51,100841.68,2800.17,518031.45,0.00,0.00,0.00,0.00,0.00),('1','294','2','133',2653,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','133',2654,'14','1',128451.80,130688.51,2236.71,413791.35,0.00,0.00,0.00,0.00,0.00),('1','294','2','133',2655,'15','1',85555.09,87572.64,2017.55,373246.75,0.00,0.00,0.00,0.00,0.00),('1','294','2','133',2656,'16','1',40661.63,40663.06,1.43,264.55,0.00,0.00,0.00,0.00,0.00),('1','294','3','133',2657,'17','2',145831.67,147852.67,2021.00,1667325.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','133',2658,'18','2',10277.04,10277.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','133',2659,'19','2',21363.98,21363.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','133',2660,'20','2',11245.81,11245.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','134',2661,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','134',2662,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','134',2663,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','134',2664,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','134',2665,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','134',2666,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','134',2667,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','134',2668,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','134',2669,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','134',2670,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','134',2671,'11','1',83689.23,83689.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','134',2672,'12','1',100841.68,100841.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','134',2673,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','134',2674,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','134',2675,'15','1',87572.64,87572.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','134',2676,'16','1',40663.06,40663.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','134',2677,'17','2',147852.67,150278.72,2426.05,2001491.25,0.00,0.00,0.00,0.00,0.00),('1','294','3','134',2678,'18','2',10277.04,10277.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','134',2679,'19','2',21363.98,21898.22,534.24,440748.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','134',2680,'20','2',11245.81,11245.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','135',2681,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','135',2682,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','135',2683,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','135',2684,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','135',2685,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','135',2686,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','135',2687,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','135',2688,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','135',2689,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','135',2690,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','135',2691,'11','1',83689.23,83689.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','135',2692,'12','1',100841.68,100841.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','135',2693,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','135',2694,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','135',2695,'15','1',87572.64,87572.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','135',2696,'16','1',40663.06,40663.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','135',2697,'17','2',150278.72,150962.05,683.33,573997.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','135',2698,'18','2',10277.04,10277.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','135',2699,'19','2',21898.22,23315.08,1416.86,1190162.40,0.00,0.00,0.00,0.00,0.00),('1','294','3','135',2700,'20','2',11245.81,11245.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','136',2701,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','136',2702,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','136',2703,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','136',2704,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','136',2705,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','136',2706,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','136',2707,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','136',2708,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','136',2709,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','136',2710,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','136',2711,'11','1',83689.23,83689.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','136',2712,'12','1',100841.68,100841.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','136',2713,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','136',2714,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','136',2715,'15','1',87572.64,87572.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','136',2716,'16','1',40663.06,40663.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','136',2717,'17','2',150962.05,152164.67,1202.62,1010200.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','136',2718,'18','2',10277.04,10277.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','136',2719,'19','2',23315.08,23315.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','136',2720,'20','2',11245.81,11245.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','137',2721,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','137',2722,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','137',2723,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','137',2724,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','137',2725,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','137',2726,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','137',2727,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','137',2728,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','137',2729,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','137',2730,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','137',2731,'11','1',83689.23,83689.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','137',2732,'12','1',100841.68,100841.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','137',2733,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','137',2734,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','137',2735,'15','1',87572.64,87572.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','137',2736,'16','1',40663.06,40663.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','137',2737,'17','2',152164.67,153495.27,1330.60,1117704.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','137',2738,'18','2',10277.04,10277.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','137',2739,'19','2',23315.08,23479.72,164.64,138297.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','137',2740,'20','2',11245.81,11245.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','138',2741,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','138',2742,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','138',2743,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','138',2744,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','138',2745,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','138',2746,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','138',2747,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','138',2748,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','138',2749,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','138',2750,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','138',2751,'11','1',83689.23,83689.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','138',2752,'12','1',100841.68,100841.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','138',2753,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','138',2754,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','138',2755,'15','1',87572.64,87572.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','138',2756,'16','1',40663.06,40663.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','138',2757,'17','2',153495.27,155556.53,2061.26,1731458.40,0.00,0.00,0.00,0.00,0.00),('1','294','3','138',2758,'18','2',10277.04,10277.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','138',2759,'19','2',23479.72,23479.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','138',2760,'20','2',11245.81,11245.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','139',2761,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','139',2762,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','139',2763,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','139',2764,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','139',2765,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','139',2766,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','139',2767,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','139',2768,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','139',2769,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','139',2770,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','139',2771,'11','1',83689.23,83689.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','139',2772,'12','1',100841.68,100841.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','139',2773,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','139',2774,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','139',2775,'15','1',87572.64,87572.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','139',2776,'16','1',40663.06,40663.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','139',2777,'17','2',155556.53,158147.63,2591.10,2176524.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','139',2778,'18','2',10277.04,10287.04,10.00,8400.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','139',2779,'19','2',23479.72,23569.72,90.00,75600.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','139',2780,'20','2',11245.81,11255.81,10.00,8400.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','140',2781,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','140',2782,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','140',2783,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','140',2784,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','140',2785,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','140',2786,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','140',2787,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','140',2788,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','140',2789,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','140',2790,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','140',2791,'11','1',83689.23,83689.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','140',2792,'12','1',100841.68,100841.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','140',2793,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','140',2794,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','140',2795,'15','1',87572.64,87572.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','140',2796,'16','1',40663.06,40663.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','140',2797,'17','2',158147.63,160465.95,2318.32,1947388.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','140',2798,'18','2',10287.04,10987.04,700.00,588000.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','140',2799,'19','2',23569.72,26129.75,2560.03,2150425.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','140',2800,'20','2',11255.81,11436.76,180.95,151998.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','141',2801,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','141',2802,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','141',2803,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','141',2804,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','141',2805,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','141',2806,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','141',2807,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','141',2808,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','141',2809,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','141',2810,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','141',2811,'11','1',83689.23,83689.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','141',2812,'12','1',100841.68,100841.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','141',2813,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','141',2814,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','141',2815,'15','1',87572.64,87572.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','141',2816,'16','1',40663.06,40663.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','141',2817,'17','2',160465.95,162590.59,2124.64,1784697.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','141',2818,'18','2',10987.04,11357.04,370.00,310800.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','141',2819,'19','2',26129.75,26182.13,52.38,43999.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','141',2820,'20','2',11436.76,11436.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','142',2821,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','142',2822,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','142',2823,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','142',2824,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','142',2825,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','142',2826,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','142',2827,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','142',2828,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','142',2829,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','142',2830,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','142',2831,'11','1',83689.23,83689.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','142',2832,'12','1',100841.68,100841.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','142',2833,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','142',2834,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','142',2835,'15','1',87572.64,87572.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','142',2836,'16','1',40663.06,40663.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','142',2837,'17','2',162590.59,165117.92,2527.33,2122957.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','142',2838,'18','2',11357.04,11357.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','142',2839,'19','2',26182.13,26182.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','142',2840,'20','2',11436.76,11436.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','143',2841,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','143',2842,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','143',2843,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','143',2844,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','143',2845,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','143',2846,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','143',2847,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','143',2848,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','143',2849,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','143',2850,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','143',2851,'11','1',83689.23,83689.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','143',2852,'12','1',100841.68,100841.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','143',2853,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','143',2854,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','143',2855,'15','1',87572.64,87572.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','143',2856,'16','1',40663.06,40663.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','143',2857,'17','2',165117.92,166630.96,1513.04,1270953.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','143',2858,'18','2',11357.04,11357.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','143',2859,'19','2',26182.13,26466.89,284.76,239198.40,0.00,0.00,0.00,0.00,0.00),('1','294','3','143',2860,'20','2',11436.76,11476.76,40.00,33600.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','144',2861,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','144',2862,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','144',2863,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','144',2864,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','144',2865,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','144',2866,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','144',2867,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','144',2868,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','144',2869,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','144',2870,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','144',2871,'11','1',83689.23,83689.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','144',2872,'12','1',100841.68,100841.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','144',2873,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','144',2874,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','144',2875,'15','1',87572.64,87572.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','144',2876,'16','1',40663.06,40663.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','144',2877,'17','2',166630.96,167898.80,1267.84,1064985.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','144',2878,'18','2',11357.04,11357.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','144',2879,'19','2',26466.89,26666.89,200.00,168000.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','144',2880,'20','2',11476.76,11476.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','145',2881,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','145',2882,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','145',2883,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','145',2884,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','145',2885,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','145',2886,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','145',2887,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','145',2888,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','145',2889,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','145',2890,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','145',2891,'11','1',83689.23,83689.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','145',2892,'12','1',100841.68,100841.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','145',2893,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','145',2894,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','145',2895,'15','1',87572.64,87572.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','145',2896,'16','1',40663.06,40663.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','145',2897,'17','2',167898.80,170541.72,2642.92,2220052.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','145',2898,'18','2',11357.04,11507.19,150.15,126126.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','145',2899,'19','2',26666.89,27246.89,580.00,487200.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','145',2900,'20','2',11476.76,11476.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','146',2901,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','146',2902,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','146',2903,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','146',2904,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','146',2905,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','146',2906,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','146',2907,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','146',2908,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','146',2909,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','146',2910,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','146',2911,'11','1',83689.23,83689.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','146',2912,'12','1',100841.68,100841.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','146',2913,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','146',2914,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','146',2915,'15','1',87572.64,87572.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','146',2916,'16','1',40663.06,40663.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','146',2917,'17','2',170541.72,172904.18,2362.46,1984466.40,0.00,0.00,0.00,0.00,0.00),('1','294','3','146',2918,'18','2',11507.19,11507.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','146',2919,'19','2',27246.89,27246.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','146',2920,'20','2',11476.76,11476.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','147',2921,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','147',2922,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','147',2923,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','147',2924,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','147',2925,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','147',2926,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','147',2927,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','147',2928,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','147',2929,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','147',2930,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','147',2931,'11','1',83689.23,83689.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','147',2932,'12','1',100841.68,100841.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','147',2933,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','147',2934,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','147',2935,'15','1',87572.64,87572.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','147',2936,'16','1',40663.06,40663.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','147',2937,'17','2',172904.18,174426.65,1522.47,1263650.10,0.00,0.00,0.00,0.00,0.00),('1','294','3','147',2938,'18','2',11507.19,11507.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','147',2939,'19','2',27246.89,28356.70,1109.81,921142.30,0.00,0.00,0.00,0.00,0.00),('1','294','3','147',2940,'20','2',11476.76,11671.76,195.00,161850.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','148',2941,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','148',2942,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','148',2943,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','148',2944,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','148',2945,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','148',2946,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','148',2947,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','148',2948,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','148',2949,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','148',2950,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','148',2951,'11','1',83689.23,83689.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','148',2952,'12','1',100841.68,100841.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','148',2953,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','148',2954,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','148',2955,'15','1',87572.64,87572.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','148',2956,'16','1',40663.06,40663.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','148',2957,'17','2',174426.65,175011.84,585.19,485707.70,0.00,0.00,0.00,0.00,0.00),('1','294','3','148',2958,'18','2',11507.19,11507.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','148',2959,'19','2',28356.70,28356.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','148',2960,'20','2',11671.76,11671.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','149',2961,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','149',2962,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','149',2963,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','149',2964,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','149',2965,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','149',2966,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','149',2967,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','149',2968,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','149',2969,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','149',2970,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','149',2971,'11','1',83689.23,83689.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','149',2972,'12','1',100841.68,100841.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','149',2973,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','149',2974,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','149',2975,'15','1',87572.64,87572.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','149',2976,'16','1',40663.06,40663.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','149',2977,'17','2',175011.84,178253.11,3241.27,2690254.10,0.00,0.00,0.00,0.00,0.00),('1','294','3','149',2978,'18','2',11507.19,11717.19,210.00,174300.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','149',2979,'19','2',28356.70,28518.75,162.05,134501.50,0.00,0.00,0.00,0.00,0.00),('1','294','3','149',2980,'20','2',11671.76,12071.76,400.00,332000.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','150',2981,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','150',2982,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','150',2983,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','150',2984,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','150',2985,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','150',2986,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','150',2987,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','150',2988,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','150',2989,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','150',2990,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','150',2991,'11','1',83689.23,83689.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','150',2992,'12','1',100841.68,100841.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','150',2993,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','150',2994,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','150',2995,'15','1',87572.64,87572.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','150',2996,'16','1',40663.06,40663.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','150',2997,'17','2',178253.11,180149.88,1896.77,1574319.10,0.00,0.00,0.00,0.00,0.00),('1','294','3','150',2998,'18','2',11717.19,11717.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','150',2999,'19','2',28518.75,28518.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','150',3000,'20','2',12071.76,12071.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','151',3001,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','151',3002,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','151',3003,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','151',3004,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','151',3005,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','151',3006,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','151',3007,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','151',3008,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','151',3009,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','151',3010,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','151',3011,'11','1',83689.23,83689.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','151',3012,'12','1',100841.68,100841.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','151',3013,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','151',3014,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','151',3015,'15','1',87572.64,87572.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','151',3016,'16','1',40663.06,40663.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','151',3017,'17','2',180149.88,180149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','151',3018,'18','2',11717.19,13097.19,1380.00,1145400.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','151',3019,'19','2',28518.75,28518.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','151',3020,'20','2',12071.76,12071.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','152',3021,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','152',3022,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','152',3023,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','152',3024,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','152',3025,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','152',3026,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','152',3027,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','152',3028,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','152',3029,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','152',3030,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','152',3031,'11','1',83689.23,83689.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','152',3032,'12','1',100841.68,100841.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','152',3033,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','152',3034,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','152',3035,'15','1',87572.64,87572.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','152',3036,'16','1',40663.06,40663.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','152',3037,'17','2',180149.88,180149.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','152',3038,'18','2',13097.19,13567.19,470.00,390100.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','152',3039,'19','2',28518.75,28649.89,131.14,108846.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','152',3040,'20','2',12071.76,12071.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','153',3041,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','153',3042,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','153',3043,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','153',3044,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','153',3045,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','153',3046,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','153',3047,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','153',3048,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','153',3049,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','153',3050,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','153',3051,'11','1',83689.23,83689.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','153',3052,'12','1',100841.68,100841.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','153',3053,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','153',3054,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','153',3055,'15','1',87572.64,87572.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','153',3056,'16','1',40663.06,40663.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','153',3057,'17','2',180149.88,182538.65,2388.77,2006566.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','153',3058,'18','2',13567.19,14087.15,519.96,436766.40,0.00,0.00,0.00,0.00,0.00),('1','294','3','153',3059,'19','2',28649.89,28676.68,26.79,22503.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','153',3060,'20','2',12071.76,12226.52,154.76,129998.40,0.00,0.00,0.00,0.00,0.00),('1','294','1','154',3061,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','154',3062,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','154',3063,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','154',3064,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','154',3065,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','154',3066,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','154',3067,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','154',3068,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','154',3069,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','154',3070,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','154',3071,'11','1',83689.23,83689.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','154',3072,'12','1',100841.68,100841.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','154',3073,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','154',3074,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','154',3075,'15','1',87572.64,87572.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','154',3076,'16','1',40663.06,40663.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','154',3077,'17','2',182538.65,185796.29,3257.64,2736417.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','154',3078,'18','2',14087.15,14087.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','154',3079,'19','2',28676.68,29357.08,680.40,571536.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','154',3080,'20','2',12226.52,12226.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','155',3081,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','155',3082,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','155',3083,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','155',3084,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','155',3085,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','155',3086,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','155',3087,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','155',3088,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','155',3089,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','155',3090,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','155',3091,'11','1',83689.23,83689.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','155',3092,'12','1',100841.68,100841.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','155',3093,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','155',3094,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','155',3095,'15','1',87572.64,87572.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','155',3096,'16','1',40663.06,40663.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','155',3097,'17','2',185796.29,187723.44,1927.15,1618806.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','155',3098,'18','2',14087.15,14087.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','155',3099,'19','2',29357.08,29457.08,100.00,84000.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','155',3100,'20','2',12226.52,12226.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','156',3101,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','156',3102,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','156',3103,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','156',3104,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','156',3105,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','156',3106,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','156',3107,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','156',3108,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','156',3109,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','156',3110,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','156',3111,'11','1',83689.23,83689.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','156',3112,'12','1',100841.68,100841.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','156',3113,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','156',3114,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','156',3115,'15','1',87572.64,87572.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','156',3116,'16','1',40663.06,40663.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','156',3117,'17','2',187723.44,189610.53,1887.09,1585155.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','156',3118,'18','2',14087.15,14087.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','156',3119,'19','2',29457.08,30562.56,1105.48,928603.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','156',3120,'20','2',12226.52,12306.52,80.00,67200.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','157',3121,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','157',3122,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','157',3123,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','157',3124,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','157',3125,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','157',3126,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','157',3127,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','157',3128,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','157',3129,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','157',3130,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','157',3131,'11','1',83689.23,83689.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','157',3132,'12','1',100841.68,100841.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','157',3133,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','157',3134,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','157',3135,'15','1',87572.64,87572.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','157',3136,'16','1',40663.06,40663.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','157',3137,'17','2',189610.53,191917.13,2306.60,1937544.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','157',3138,'18','2',14087.15,14087.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','157',3139,'19','2',30562.56,30562.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','157',3140,'20','2',12306.52,12306.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','158',3141,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','158',3142,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','158',3143,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','158',3144,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','158',3145,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','158',3146,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','158',3147,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','158',3148,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','158',3149,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','158',3150,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','158',3151,'11','1',83689.23,83689.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','158',3152,'12','1',100841.68,100841.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','158',3153,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','158',3154,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','158',3155,'15','1',87572.64,87572.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','158',3156,'16','1',40663.06,40663.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','158',3157,'17','2',191917.13,194277.04,2359.91,1982324.40,0.00,0.00,0.00,0.00,0.00),('1','294','3','158',3158,'18','2',14087.15,14087.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','158',3159,'19','2',30562.56,31334.47,771.91,648404.40,0.00,0.00,0.00,0.00,0.00),('1','294','3','158',3160,'20','2',12306.52,12306.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','159',3161,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','159',3162,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','159',3163,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','159',3164,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','159',3165,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','159',3166,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','159',3167,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','159',3168,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','159',3169,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','159',3170,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','159',3171,'11','1',83689.23,83689.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','159',3172,'12','1',100841.68,103759.53,2917.85,641927.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','159',3173,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','159',3174,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','159',3175,'15','1',87572.64,90272.58,2699.94,593986.80,0.00,0.00,0.00,0.00,0.00),('1','294','2','159',3176,'16','1',40663.06,40663.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','159',3177,'17','2',194277.04,195145.09,868.05,729162.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','159',3178,'18','2',14087.15,14087.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','159',3179,'19','2',31334.47,31334.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','159',3180,'20','2',12306.52,12306.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','160',3181,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','160',3182,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','160',3183,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','160',3184,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','160',3185,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','160',3186,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','160',3187,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','160',3188,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','160',3189,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','160',3190,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','160',3191,'11','1',83689.23,83689.76,0.53,116.60,0.00,0.00,0.00,0.00,0.00),('1','294','2','160',3192,'12','1',103759.53,104701.67,942.14,207270.80,0.00,0.00,0.00,0.00,0.00),('1','294','2','160',3193,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','160',3194,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','160',3195,'15','1',90272.58,92004.34,1731.76,380987.20,0.00,0.00,0.00,0.00,0.00),('1','294','2','160',3196,'16','1',40663.06,40663.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','160',3197,'17','2',195145.09,195373.67,228.58,192007.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','160',3198,'18','2',14087.15,14087.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','160',3199,'19','2',31334.47,32933.26,1598.79,1342983.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','160',3200,'20','2',12306.52,12306.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','161',3201,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','161',3202,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','161',3203,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','161',3204,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','161',3205,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','161',3206,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','161',3207,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','161',3208,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','161',3209,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','161',3210,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','161',3211,'11','1',83689.76,83689.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','161',3212,'12','1',104701.67,104701.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','161',3213,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','161',3214,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','161',3215,'15','1',92004.34,92004.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','161',3216,'16','1',40663.06,40663.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','161',3217,'17','2',195373.67,195933.24,559.57,492421.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','161',3218,'18','2',14087.15,14087.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','161',3219,'19','2',32933.26,33817.81,884.55,778404.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','161',3220,'20','2',12306.52,12306.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','162',3221,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','162',3222,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','162',3223,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','162',3224,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','162',3225,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','162',3226,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','162',3227,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','162',3228,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','162',3229,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','162',3230,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','162',3231,'11','1',83689.76,83689.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','162',3232,'12','1',104701.67,104701.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','162',3233,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','162',3234,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','162',3235,'15','1',92004.34,92004.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','162',3236,'16','1',40663.06,40663.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','162',3237,'17','2',195933.24,198295.62,2362.38,2078894.40,0.00,0.00,0.00,0.00,0.00),('1','294','3','162',3238,'18','2',14087.15,14087.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','162',3239,'19','2',33817.81,33817.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','162',3240,'20','2',12306.52,12306.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','163',3241,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','163',3242,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','163',3243,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','163',3244,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','163',3245,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','163',3246,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','163',3247,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','163',3248,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','163',3249,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','163',3250,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','163',3251,'11','1',83689.76,83689.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','163',3252,'12','1',104701.67,104701.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','163',3253,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','163',3254,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','163',3255,'15','1',92004.34,92004.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','163',3256,'16','1',40663.06,40663.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','163',3257,'17','2',198295.62,199820.46,1524.84,1341859.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','163',3258,'18','2',14087.15,14087.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','163',3259,'19','2',33817.81,34332.66,514.85,453068.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','163',3260,'20','2',12306.52,12306.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','164',3261,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','164',3262,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','164',3263,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','164',3264,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','164',3265,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','164',3266,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','164',3267,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','164',3268,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','164',3269,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','164',3270,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','164',3271,'11','1',83689.76,83689.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','164',3272,'12','1',104701.67,104701.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','164',3273,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','164',3274,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','164',3275,'15','1',92004.34,92004.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','164',3276,'16','1',40663.06,40663.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','164',3277,'17','2',199820.46,201054.33,1233.87,1085805.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','164',3278,'18','2',14087.15,14087.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','164',3279,'19','2',34332.66,34967.66,635.00,558800.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','164',3280,'20','2',12306.52,12306.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','165',3281,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','165',3282,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','165',3283,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','165',3284,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','165',3285,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','165',3286,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','165',3287,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','165',3288,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','165',3289,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','165',3290,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','165',3291,'11','1',83689.76,83689.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','165',3292,'12','1',104701.67,104701.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','165',3293,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','165',3294,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','165',3295,'15','1',92004.34,92004.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','165',3296,'16','1',40663.06,40663.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','165',3297,'17','2',201054.33,202982.74,1928.41,1697000.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','165',3298,'18','2',14087.15,14087.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','165',3299,'19','2',34967.66,35087.64,119.98,105582.40,0.00,0.00,0.00,0.00,0.00),('1','294','3','165',3300,'20','2',12306.52,12306.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','166',3301,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','166',3302,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','166',3303,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','166',3304,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','166',3305,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','166',3306,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','166',3307,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','166',3308,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','166',3309,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','166',3310,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','166',3311,'11','1',83689.76,83689.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','166',3312,'12','1',104701.67,107843.48,3141.81,691198.20,0.00,0.00,0.00,0.00,0.00),('1','294','2','166',3313,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','166',3314,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','166',3315,'15','1',92004.34,94962.15,2957.81,650718.20,0.00,0.00,0.00,0.00,0.00),('1','294','2','166',3316,'16','1',40663.06,40664.56,0.00,0.00,0.00,0.00,1.50,0.00,0.00),('1','294','3','166',3317,'17','2',202982.74,204579.77,1597.03,1405386.40,0.00,0.00,0.00,0.00,0.00),('1','294','3','166',3318,'18','2',14087.15,14087.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','166',3319,'19','2',35087.64,35087.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','166',3320,'20','2',12306.52,12306.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','167',3321,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','167',3322,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','167',3323,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','167',3324,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','167',3325,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','167',3326,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','167',3327,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','167',3328,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','167',3329,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','167',3330,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','167',3331,'11','1',83689.76,83689.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','167',3332,'12','1',107843.48,112765.91,4922.43,1082934.60,0.00,0.00,0.00,0.00,0.00),('1','294','2','167',3333,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','167',3334,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','167',3335,'15','1',94962.15,99827.68,4865.53,1070416.60,0.00,0.00,0.00,0.00,0.00),('1','294','2','167',3336,'16','1',40664.56,40664.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','167',3337,'17','2',204579.77,204895.33,315.56,277692.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','167',3338,'18','2',14087.15,14087.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','167',3339,'19','2',35087.64,35087.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','167',3340,'20','2',12306.52,12386.52,80.00,70400.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','168',3341,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','168',3342,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','168',3343,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','168',3344,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','168',3345,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','168',3346,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','168',3347,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','168',3348,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','168',3349,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','168',3350,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','168',3351,'11','1',83689.76,83689.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','168',3352,'12','1',112765.91,112765.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','168',3353,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','168',3354,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','168',3355,'15','1',99827.68,99827.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','168',3356,'16','1',40664.56,40664.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','168',3357,'17','2',204895.33,205911.16,1015.83,853297.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','168',3358,'18','2',14087.15,14087.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','168',3359,'19','2',35087.64,35672.56,584.92,491332.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','168',3360,'20','2',12386.52,12386.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','169',3361,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','169',3362,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','169',3363,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','169',3364,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','169',3365,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','169',3366,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','169',3367,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','169',3368,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','169',3369,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','169',3370,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','169',3371,'11','1',83689.76,86550.08,2860.32,629270.40,0.00,0.00,0.00,0.00,0.00),('1','294','2','169',3372,'12','1',112765.91,112765.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','169',3373,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','169',3374,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','169',3375,'15','1',99827.68,102580.53,2752.85,605627.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','169',3376,'16','1',40664.56,40664.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','169',3377,'17','2',205911.16,205911.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','169',3378,'18','2',14087.15,14087.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','169',3379,'19','2',35672.56,35672.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','169',3380,'20','2',12386.52,12386.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','170',3381,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','170',3382,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','170',3383,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','170',3384,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','170',3385,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','170',3386,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','170',3387,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','170',3388,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','170',3389,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','170',3390,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','170',3391,'11','1',86550.08,86550.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','170',3392,'12','1',112765.91,112765.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','170',3393,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','170',3394,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','170',3395,'15','1',102580.53,102580.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','170',3396,'16','1',40664.56,40664.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','170',3397,'17','2',205911.16,207969.31,2058.15,1687683.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','170',3398,'18','2',14087.15,14940.98,853.83,700140.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','170',3399,'19','2',35672.56,38116.89,2444.33,2004350.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','170',3400,'20','2',12386.52,13936.52,1550.00,1271000.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','171',3401,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','171',3402,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','171',3403,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','171',3404,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','171',3405,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','171',3406,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','171',3407,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','171',3408,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','171',3409,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','171',3410,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','171',3411,'11','1',86550.08,86550.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','171',3412,'12','1',112765.91,112765.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','171',3413,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','171',3414,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','171',3415,'15','1',102580.53,102580.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','171',3416,'16','1',40664.56,40664.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','171',3417,'17','2',207969.31,209616.83,1647.52,1350966.40,0.00,0.00,0.00,0.00,0.00),('1','294','3','171',3418,'18','2',14940.98,14940.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','171',3419,'19','2',38116.89,38392.89,276.00,226320.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','171',3420,'20','2',13936.52,14189.52,253.00,207460.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','172',3421,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','172',3422,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','172',3423,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','172',3424,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','172',3425,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','172',3426,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','172',3427,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','172',3428,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','172',3429,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','172',3430,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','172',3431,'11','1',86550.08,86550.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','172',3432,'12','1',112765.91,112765.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','172',3433,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','172',3434,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','172',3435,'15','1',102580.53,102580.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','172',3436,'16','1',40664.56,40664.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','172',3437,'17','2',209616.83,211360.00,1743.17,1429399.40,0.00,0.00,0.00,0.00,0.00),('1','294','3','172',3438,'18','2',14940.98,15549.52,608.54,499002.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','172',3439,'19','2',38392.89,43507.31,5114.42,4193824.40,0.00,0.00,0.00,0.00,0.00),('1','294','3','172',3440,'20','2',14189.52,16389.52,2200.00,1804000.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','173',3441,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','173',3442,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','173',3443,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','173',3444,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','173',3445,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','173',3446,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','173',3447,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','173',3448,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','173',3449,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','173',3450,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','173',3451,'11','1',86550.08,86550.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','173',3452,'12','1',112765.91,112765.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','173',3453,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','173',3454,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','173',3455,'15','1',102580.53,102580.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','173',3456,'16','1',40664.56,40664.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','173',3457,'17','2',211360.00,212642.05,1282.05,1051281.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','173',3458,'18','2',15549.52,15549.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','173',3459,'19','2',43507.31,44567.31,1060.00,869200.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','173',3460,'20','2',16389.52,16696.84,307.32,252002.40,0.00,0.00,0.00,0.00,0.00),('1','294','1','174',3461,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','174',3462,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','174',3463,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','174',3464,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','174',3465,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','174',3466,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','174',3467,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','174',3468,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','174',3469,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','174',3470,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','174',3471,'11','1',86550.08,86550.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','174',3472,'12','1',112765.91,112765.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','174',3473,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','174',3474,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','174',3475,'15','1',102580.53,102580.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','174',3476,'16','1',40664.56,40664.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','174',3477,'17','2',212642.05,214410.54,1768.49,1450161.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','174',3478,'18','2',15549.52,15549.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','174',3479,'19','2',44567.31,45229.50,662.19,542995.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','174',3480,'20','2',16696.84,16696.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','175',3481,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','175',3482,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','175',3483,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','175',3484,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','175',3485,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','175',3486,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','175',3487,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','175',3488,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','175',3489,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','175',3490,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','175',3491,'11','1',86550.08,86550.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','175',3492,'12','1',112765.91,112765.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','175',3493,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','175',3494,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','175',3495,'15','1',102580.53,102580.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','175',3496,'16','1',40664.56,40664.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','175',3497,'17','2',214410.54,216066.27,1655.73,1357698.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','175',3498,'18','2',15549.52,15549.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','175',3499,'19','2',45229.50,46351.21,1121.71,919802.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','175',3500,'20','2',16696.84,16696.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','176',3501,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','176',3502,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','176',3503,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','176',3504,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','176',3505,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','176',3506,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','176',3507,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','176',3508,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','176',3509,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','176',3510,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','176',3511,'11','1',86550.08,86550.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','176',3512,'12','1',112765.91,112765.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','176',3513,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','176',3514,'14','1',130688.51,130688.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','176',3515,'15','1',102580.53,102580.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','176',3516,'16','1',40664.56,40664.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','176',3517,'17','2',216066.27,218955.97,2889.70,2369554.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','176',3518,'18','2',15549.52,15549.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','176',3519,'19','2',46351.21,47037.12,685.91,562446.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','176',3520,'20','2',16696.84,16696.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','177',3521,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','177',3522,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','177',3523,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','177',3524,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','177',3525,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','177',3526,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','177',3527,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','177',3528,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','177',3529,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','177',3530,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','177',3531,'11','1',86550.08,90366.10,3816.02,877684.60,0.00,0.00,0.00,0.00,0.00),('1','294','2','177',3532,'12','1',112765.91,116135.84,3369.93,775083.90,0.00,0.00,0.00,0.00,0.00),('1','294','2','177',3533,'13','1',20709.88,20709.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','177',3534,'14','1',130688.51,135089.21,4400.70,1012161.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','177',3535,'15','1',102580.53,106415.20,3834.67,881974.10,0.00,0.00,0.00,0.00,0.00),('1','294','2','177',3536,'16','1',40664.56,40664.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','177',3537,'17','2',218955.97,218955.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','177',3538,'18','2',15549.52,15549.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','177',3539,'19','2',47037.12,47037.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','177',3540,'20','2',16696.84,16696.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','178',3541,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','178',3542,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','178',3543,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','178',3544,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','178',3545,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','178',3546,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','178',3547,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','178',3548,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','178',3549,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','178',3550,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','178',3551,'11','1',90366.10,94504.76,4138.66,951891.80,0.00,0.00,0.00,0.00,0.00),('1','294','2','178',3552,'12','1',116135.84,117524.94,1389.10,319493.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','178',3553,'13','1',20709.88,21662.53,952.65,219109.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','178',3554,'14','1',135089.21,139228.53,4139.32,952043.60,0.00,0.00,0.00,0.00,0.00),('1','294','2','178',3555,'15','1',106415.20,110739.77,4324.57,994651.10,0.00,0.00,0.00,0.00,0.00),('1','294','2','178',3556,'16','1',40664.56,41064.50,399.94,91986.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','178',3557,'17','2',218955.97,218955.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','178',3558,'18','2',15549.52,15549.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','178',3559,'19','2',47037.12,47037.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','178',3560,'20','2',16696.84,16696.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','179',3561,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','179',3562,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','179',3563,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','179',3564,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','179',3565,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','179',3566,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','179',3567,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','179',3568,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','179',3569,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','179',3570,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','179',3571,'11','1',94504.76,97817.16,3312.40,761852.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','179',3572,'12','1',117524.94,121074.31,3549.37,816355.10,0.00,0.00,0.00,0.00,0.00),('1','294','2','179',3573,'13','1',21662.53,24966.17,3303.64,759837.20,0.00,0.00,0.00,0.00,0.00),('1','294','2','179',3574,'14','1',139228.53,142720.46,3491.93,803143.90,0.00,0.00,0.00,0.00,0.00),('1','294','2','179',3575,'15','1',110739.77,115776.13,5036.36,1158362.80,0.00,0.00,0.00,0.00,0.00),('1','294','2','179',3576,'16','1',41064.50,41064.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','179',3577,'17','2',218955.97,218955.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','179',3578,'18','2',15549.52,15549.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','179',3579,'19','2',47037.12,47037.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','179',3580,'20','2',16696.84,16696.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','180',3581,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','180',3582,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','180',3583,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','180',3584,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','180',3585,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','180',3586,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','180',3587,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','180',3588,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','180',3589,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','180',3590,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','180',3591,'11','1',97817.16,100451.42,2634.26,605879.80,0.00,0.00,0.00,0.00,0.00),('1','294','2','180',3592,'12','1',121074.31,123311.90,2237.59,514645.70,0.00,0.00,0.00,0.00,0.00),('1','294','2','180',3593,'13','1',24966.17,26072.05,1105.88,254352.40,0.00,0.00,0.00,0.00,0.00),('1','294','2','180',3594,'14','1',142720.46,145343.19,2622.73,603227.90,0.00,0.00,0.00,0.00,0.00),('1','294','2','180',3595,'15','1',115776.13,118069.15,2293.02,527394.60,0.00,0.00,0.00,0.00,0.00),('1','294','2','180',3596,'16','1',41064.50,41064.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','180',3597,'17','2',218955.97,220003.65,1047.68,859097.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','180',3598,'18','2',15549.52,15549.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','180',3599,'19','2',47037.12,48072.12,1035.00,848700.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','180',3600,'20','2',16696.84,17521.72,824.88,676401.60,0.00,0.00,0.00,0.00,0.00),('1','294','1','181',3601,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','181',3602,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','181',3603,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','181',3604,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','181',3605,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','181',3606,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','181',3607,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','181',3608,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','181',3609,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','181',3610,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','181',3611,'11','1',100451.42,100451.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','181',3612,'12','1',123311.90,123311.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','181',3613,'13','1',26072.05,26072.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','181',3614,'14','1',145343.19,145343.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','181',3615,'15','1',118069.15,118069.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','181',3616,'16','1',41064.50,41064.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','181',3617,'17','2',220003.65,221931.00,1927.35,1580427.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','181',3618,'18','2',15549.52,15549.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','181',3619,'19','2',48072.12,48072.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','181',3620,'20','2',17521.72,17521.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','182',3621,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','182',3622,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','182',3623,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','182',3624,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','182',3625,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','182',3626,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','182',3627,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','182',3628,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','182',3629,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','182',3630,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','182',3631,'11','1',100451.42,100451.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','182',3632,'12','1',123311.90,123311.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','182',3633,'13','1',26072.05,26072.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','182',3634,'14','1',145343.19,145343.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','182',3635,'15','1',118069.15,118069.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','182',3636,'16','1',41064.50,41064.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','182',3637,'17','2',221931.00,223538.60,1607.60,1318232.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','182',3638,'18','2',15549.52,15669.53,120.01,98408.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','182',3639,'19','2',48072.12,50748.11,2675.99,2194311.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','182',3640,'20','2',17521.72,17521.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','183',3641,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','183',3642,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','183',3643,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','183',3644,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','183',3645,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','183',3646,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','183',3647,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','183',3648,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','183',3649,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','183',3650,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','183',3651,'11','1',100451.42,100451.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','183',3652,'12','1',123311.90,123311.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','183',3653,'13','1',26072.05,26072.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','183',3654,'14','1',145343.19,145343.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','183',3655,'15','1',118069.15,118069.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','183',3656,'16','1',41064.50,41064.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','183',3657,'17','2',223538.60,226389.53,2850.93,2337762.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','183',3658,'18','2',15669.53,15694.52,24.99,20491.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','183',3659,'19','2',50748.11,51792.14,1044.03,856104.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','183',3660,'20','2',17521.72,17696.72,175.00,143500.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','184',3661,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','184',3662,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','184',3663,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','184',3664,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','184',3665,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','184',3666,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','184',3667,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','184',3668,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','184',3669,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','184',3670,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','184',3671,'11','1',100451.42,100451.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','184',3672,'12','1',123311.90,123311.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','184',3673,'13','1',26072.05,26072.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','184',3674,'14','1',145343.19,145343.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','184',3675,'15','1',118069.15,118069.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','184',3676,'16','1',41064.50,41064.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','184',3677,'17','2',226389.53,228010.73,1621.20,1329384.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','184',3678,'18','2',15694.52,16399.53,705.01,578108.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','184',3679,'19','2',51792.14,52421.41,629.27,516001.40,0.00,0.00,0.00,0.00,0.00),('1','294','3','184',3680,'20','2',17696.72,17696.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','185',3681,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','185',3682,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','185',3683,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','185',3684,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','185',3685,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','185',3686,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','185',3687,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','185',3688,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','185',3689,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','185',3690,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','185',3691,'11','1',100451.42,100451.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','185',3692,'12','1',123311.90,123311.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','185',3693,'13','1',26072.05,26072.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','185',3694,'14','1',145343.19,145343.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','185',3695,'15','1',118069.15,118069.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','185',3696,'16','1',41064.50,41064.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','185',3697,'17','2',228010.73,229434.54,1423.81,1167524.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','185',3698,'18','2',16399.53,16399.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','185',3699,'19','2',52421.41,55302.89,2881.48,2362813.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','185',3700,'20','2',17696.72,17696.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','186',3701,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','186',3702,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','186',3703,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','186',3704,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','186',3705,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','186',3706,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','186',3707,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','186',3708,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','186',3709,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','186',3710,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','186',3711,'11','1',100451.42,100451.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','186',3712,'12','1',123311.90,123311.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','186',3713,'13','1',26072.05,26072.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','186',3714,'14','1',145343.19,145343.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','186',3715,'15','1',118069.15,118069.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','186',3716,'16','1',41064.50,41064.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','186',3717,'17','2',229434.54,232982.99,3548.45,2909729.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','186',3718,'18','2',16399.53,16399.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','186',3719,'19','2',55302.89,56199.23,896.34,734998.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','186',3720,'20','2',17696.72,17696.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','187',3721,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','187',3722,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','187',3723,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','187',3724,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','187',3725,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','187',3726,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','187',3727,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','187',3728,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','187',3729,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','187',3730,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','187',3731,'11','1',100451.42,100451.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','187',3732,'12','1',123311.90,123311.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','187',3733,'13','1',26072.05,26072.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','187',3734,'14','1',145343.19,145343.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','187',3735,'15','1',118069.15,118069.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','187',3736,'16','1',41064.50,41064.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','187',3737,'17','2',232982.99,235388.45,2405.46,1972477.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','187',3738,'18','2',16399.53,16399.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','187',3739,'19','2',56199.23,56199.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','187',3740,'20','2',17696.72,17696.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','188',3741,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','188',3742,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','188',3743,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','188',3744,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','188',3745,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','188',3746,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','188',3747,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','188',3748,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','188',3749,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','188',3750,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','188',3751,'11','1',100451.42,100451.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','188',3752,'12','1',123311.90,123311.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','188',3753,'13','1',26072.05,26072.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','188',3754,'14','1',145343.19,145343.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','188',3755,'15','1',118069.15,118069.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','188',3756,'16','1',41064.50,41064.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','188',3757,'17','2',235388.45,237828.26,2439.81,2000644.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','188',3758,'18','2',16399.53,16399.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','188',3759,'19','2',56199.23,60213.26,4014.03,3291504.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','188',3760,'20','2',17696.72,17806.72,110.00,90200.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','189',3761,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','189',3762,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','189',3763,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','189',3764,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','189',3765,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','189',3766,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','189',3767,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','189',3768,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','189',3769,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','189',3770,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','189',3771,'11','1',100451.42,100451.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','189',3772,'12','1',123311.90,127384.98,4073.08,957173.80,0.00,0.00,0.00,0.00,0.00),('1','294','2','189',3773,'13','1',26072.05,26072.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','189',3774,'14','1',145343.19,149543.89,4200.70,987164.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','189',3775,'15','1',118069.15,122125.27,4056.12,953188.20,0.00,0.00,0.00,0.00,0.00),('1','294','2','189',3776,'16','1',41064.50,41064.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','189',3777,'17','2',237828.26,240686.69,2858.43,2343912.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','189',3778,'18','2',16399.53,16399.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','189',3779,'19','2',60213.26,61163.26,950.00,779000.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','189',3780,'20','2',17806.72,17806.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','190',3781,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','190',3782,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','190',3783,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','190',3784,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','190',3785,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','190',3786,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','190',3787,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','190',3788,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','190',3789,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','190',3790,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','190',3791,'11','1',100451.42,103345.15,2873.73,675326.55,0.00,0.00,20.00,0.00,0.00),('1','294','2','190',3792,'12','1',127384.98,131460.96,4075.98,957855.30,0.00,0.00,0.00,0.00,0.00),('1','294','2','190',3793,'13','1',26072.05,26072.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','190',3794,'14','1',149543.89,154301.82,4757.93,1118113.55,0.00,0.00,0.00,0.00,0.00),('1','294','2','190',3795,'15','1',122125.27,122125.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','190',3796,'16','1',41064.50,41064.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','190',3797,'17','2',240686.69,244405.89,3719.20,3049744.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','190',3798,'18','2',16399.53,16609.25,209.72,171970.40,0.00,0.00,0.00,0.00,0.00),('1','294','3','190',3799,'19','2',61163.26,62871.89,1708.63,1401076.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','190',3800,'20','2',17806.72,17806.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','191',3801,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','191',3802,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','191',3803,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','191',3804,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','191',3805,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','191',3806,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','191',3807,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','191',3808,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','191',3809,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','191',3810,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','191',3811,'11','1',103345.15,103955.19,610.04,143359.40,0.00,0.00,0.00,0.00,0.00),('1','294','2','191',3812,'12','1',131460.96,134682.28,3221.32,757010.20,0.00,0.00,0.00,0.00,0.00),('1','294','2','191',3813,'13','1',26072.05,26072.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','191',3814,'14','1',154301.82,154301.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','191',3815,'15','1',122125.27,125171.38,3046.11,715835.85,0.00,0.00,0.00,0.00,0.00),('1','294','2','191',3816,'16','1',41064.50,41064.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','191',3817,'17','2',244405.89,247093.23,2687.34,2203618.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','191',3818,'18','2',16609.25,16609.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','191',3819,'19','2',62871.89,62871.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','191',3820,'20','2',17806.72,17806.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','192',3821,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','192',3822,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','192',3823,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','192',3824,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','192',3825,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','192',3826,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','192',3827,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','192',3828,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','192',3829,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','192',3830,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','192',3831,'11','1',103955.19,107078.87,3123.68,734064.80,0.00,0.00,0.00,0.00,0.00),('1','294','2','192',3832,'12','1',134682.28,139507.08,4824.80,1133828.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','192',3833,'13','1',26072.05,26072.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','192',3834,'14','1',154301.82,154301.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','192',3835,'15','1',125171.38,130018.35,4846.97,1139037.95,0.00,0.00,0.00,0.00,0.00),('1','294','2','192',3836,'16','1',41064.50,41064.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','192',3837,'17','2',247093.23,250548.77,3455.54,2833542.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','192',3838,'18','2',16609.25,16699.23,89.98,73783.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','192',3839,'19','2',62871.89,66607.93,3736.04,3063552.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','192',3840,'20','2',17806.72,19251.72,1445.00,1184900.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','193',3841,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','193',3842,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','193',3843,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','193',3844,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','193',3845,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','193',3846,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','193',3847,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','193',3848,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','193',3849,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','193',3850,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','193',3851,'11','1',107078.87,108058.27,969.40,227809.00,0.00,0.00,10.00,0.00,0.00),('1','294','2','193',3852,'12','1',139507.08,141372.43,1855.35,436007.25,0.00,0.00,10.00,0.00,0.00),('1','294','2','193',3853,'13','1',26072.05,27543.53,1461.48,343447.80,0.00,0.00,10.00,0.00,0.00),('1','294','2','193',3854,'14','1',154301.82,156146.22,1834.40,431084.00,0.00,0.00,10.00,0.00,0.00),('1','294','2','193',3855,'15','1',130018.35,130018.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','193',3856,'16','1',41064.50,41064.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','193',3857,'17','2',250548.77,254197.13,3648.36,2991655.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','193',3858,'18','2',16699.23,16699.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','193',3859,'19','2',66607.93,66607.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','193',3860,'20','2',19251.72,19251.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','194',3861,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','194',3862,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','194',3863,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','194',3864,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','194',3865,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','194',3866,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','194',3867,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','194',3868,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','194',3869,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','194',3870,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','194',3871,'11','1',108058.27,108058.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','194',3872,'12','1',141372.43,141372.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','194',3873,'13','1',27543.53,27543.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','194',3874,'14','1',156146.22,156146.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','194',3875,'15','1',130018.35,130018.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','194',3876,'16','1',41064.50,41064.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','194',3877,'17','2',254197.13,255858.48,1661.35,1362307.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','194',3878,'18','2',16699.23,16699.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','194',3879,'19','2',66607.93,69382.02,2774.09,2274753.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','194',3880,'20','2',19251.72,19361.72,110.00,90200.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','195',3881,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','195',3882,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','195',3883,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','195',3884,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','195',3885,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','195',3886,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','195',3887,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','195',3888,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','195',3889,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','195',3890,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','195',3891,'11','1',108058.27,108058.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','195',3892,'12','1',141372.43,141372.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','195',3893,'13','1',27543.53,27543.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','195',3894,'14','1',156146.22,156146.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','195',3895,'15','1',130018.35,130018.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','195',3896,'16','1',41064.50,41064.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','195',3897,'17','2',255858.48,258557.66,2699.18,2213327.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','195',3898,'18','2',16699.23,16699.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','195',3899,'19','2',69382.02,70107.17,725.15,594623.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','195',3900,'20','2',19361.72,19361.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','196',3901,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','196',3902,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','196',3903,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','196',3904,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','196',3905,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','196',3906,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','196',3907,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','196',3908,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','196',3909,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','196',3910,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','196',3911,'11','1',108058.27,108889.51,831.24,195341.40,0.00,0.00,0.00,0.00,0.00),('1','294','2','196',3912,'12','1',141372.43,145741.66,4369.23,1026769.05,0.00,0.00,0.00,0.00,0.00),('1','294','2','196',3913,'13','1',27543.53,27543.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','196',3914,'14','1',156146.22,158676.51,2530.29,594618.15,0.00,0.00,0.00,0.00,0.00),('1','294','2','196',3915,'15','1',130018.35,133824.94,3806.59,894548.65,0.00,0.00,0.00,0.00,0.00),('1','294','2','196',3916,'16','1',41064.50,41064.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','196',3917,'17','2',258557.66,261857.56,3299.90,2705918.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','196',3918,'18','2',16699.23,16699.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','196',3919,'19','2',70107.17,71273.13,1165.96,956087.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','196',3920,'20','2',19361.72,19361.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','197',3921,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','197',3922,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','197',3923,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','197',3924,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','197',3925,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','197',3926,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','197',3927,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','197',3928,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','197',3929,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','197',3930,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','197',3931,'11','1',108889.51,114441.03,5541.52,1302257.20,0.00,0.00,10.00,0.00,0.00),('1','294','2','197',3932,'12','1',145741.66,146738.76,997.10,234318.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','197',3933,'13','1',27543.53,27543.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','197',3934,'14','1',158676.51,162776.34,4099.83,963460.05,0.00,0.00,0.00,0.00,0.00),('1','294','2','197',3935,'15','1',133824.94,137697.05,3872.11,909945.85,0.00,0.00,0.00,0.00,0.00),('1','294','2','197',3936,'16','1',41064.50,41064.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','197',3937,'17','2',261857.56,264044.71,2187.15,1793463.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','197',3938,'18','2',16699.23,16699.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','197',3939,'19','2',71273.13,71873.13,600.00,492000.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','197',3940,'20','2',19361.72,19361.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','198',3941,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','198',3942,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','198',3943,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','198',3944,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','198',3945,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','198',3946,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','198',3947,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','198',3948,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','198',3949,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','198',3950,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','198',3951,'11','1',114441.03,115978.66,1537.63,361343.05,0.00,0.00,0.00,0.00,0.00),('1','294','2','198',3952,'12','1',146738.76,148860.52,2121.76,498613.60,0.00,0.00,0.00,0.00,0.00),('1','294','2','198',3953,'13','1',27543.53,27543.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','198',3954,'14','1',162776.34,162776.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','198',3955,'15','1',137697.05,137697.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','198',3956,'16','1',41064.50,41064.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','198',3957,'17','2',264044.71,266718.43,2673.72,2192450.40,0.00,0.00,0.00,0.00,0.00),('1','294','3','198',3958,'18','2',16699.23,16699.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','198',3959,'19','2',71873.13,72057.52,184.39,151199.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','198',3960,'20','2',19361.72,19361.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','199',3961,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','199',3962,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','199',3963,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','199',3964,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','199',3965,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','199',3966,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','199',3967,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','199',3968,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','199',3969,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','199',3970,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','199',3971,'11','1',115978.66,120211.06,4212.40,989914.00,0.00,0.00,20.00,0.00,0.00),('1','294','2','199',3972,'12','1',148860.52,151438.93,2578.41,605926.35,0.00,0.00,0.00,0.00,0.00),('1','294','2','199',3973,'13','1',27543.53,30444.39,2900.86,681702.10,0.00,0.00,0.00,0.00,0.00),('1','294','2','199',3974,'14','1',162776.34,163951.99,1175.65,276277.75,0.00,0.00,0.00,0.00,0.00),('1','294','2','199',3975,'15','1',137697.05,137697.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','199',3976,'16','1',41064.50,41064.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','199',3977,'17','2',266718.43,270003.84,3285.41,2694036.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','199',3978,'18','2',16699.23,16699.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','199',3979,'19','2',72057.52,73783.09,1725.57,1414967.40,0.00,0.00,0.00,0.00,0.00),('1','294','3','199',3980,'20','2',19361.72,19361.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','200',3981,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','200',3982,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','200',3983,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','200',3984,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','200',3985,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','200',3986,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','200',3987,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','200',3988,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','200',3989,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','200',3990,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','200',3991,'11','1',120211.06,121165.23,954.17,224229.95,0.00,0.00,0.00,0.00,0.00),('1','294','2','200',3992,'12','1',151438.93,152953.52,1514.59,355928.65,0.00,0.00,0.00,0.00,0.00),('1','294','2','200',3993,'13','1',30444.39,32389.16,1944.77,457020.95,0.00,0.00,0.00,0.00,0.00),('1','294','2','200',3994,'14','1',163951.99,164592.46,640.47,150510.45,0.00,0.00,0.00,0.00,0.00),('1','294','2','200',3995,'15','1',137697.05,137697.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','200',3996,'16','1',41064.50,41064.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','200',3997,'17','2',270003.84,272009.45,2005.61,1644600.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','200',3998,'18','2',16699.23,16699.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','200',3999,'19','2',73783.09,76468.35,2685.26,2201913.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','200',4000,'20','2',19361.72,19361.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','201',4001,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','201',4002,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','201',4003,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','201',4004,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','201',4005,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','201',4006,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','201',4007,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','201',4008,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','201',4009,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','201',4010,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','201',4011,'11','1',121165.23,121821.55,656.32,154235.20,0.00,0.00,0.00,0.00,0.00),('1','294','2','201',4012,'12','1',152953.52,157718.47,4764.95,1119763.25,0.00,0.00,0.00,0.00,0.00),('1','294','2','201',4013,'13','1',32389.16,32389.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','201',4014,'14','1',164592.46,169518.35,4925.89,1157584.15,0.00,0.00,0.00,0.00,0.00),('1','294','2','201',4015,'15','1',137697.05,137697.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','201',4016,'16','1',41064.50,41064.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','201',4017,'17','2',272009.45,275687.82,3678.37,3016263.40,0.00,0.00,0.00,0.00,0.00),('1','294','3','201',4018,'18','2',16699.23,16699.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','201',4019,'19','2',76468.35,77838.35,1370.00,1123400.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','201',4020,'20','2',19361.72,19361.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','202',4021,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','202',4022,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','202',4023,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','202',4024,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','202',4025,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','202',4026,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','202',4027,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','202',4028,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','202',4029,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','202',4030,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','202',4031,'11','1',121821.55,125119.92,3298.37,775116.95,0.00,0.00,0.00,0.00,0.00),('1','294','2','202',4032,'12','1',157718.47,161085.71,3367.24,791301.40,0.00,0.00,0.00,0.00,0.00),('1','294','2','202',4033,'13','1',32389.16,32389.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','202',4034,'14','1',169518.35,172735.50,3217.15,756030.25,0.00,0.00,0.00,0.00,0.00),('1','294','2','202',4035,'15','1',137697.05,138082.58,385.53,90599.55,0.00,0.00,0.00,0.00,0.00),('1','294','2','202',4036,'16','1',41064.50,41064.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','202',4037,'17','2',275687.82,275687.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','202',4038,'18','2',16699.23,16699.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','202',4039,'19','2',77838.35,77838.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','202',4040,'20','2',19361.72,19361.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','203',4041,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','203',4042,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','203',4043,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','203',4044,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','203',4045,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','203',4046,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','203',4047,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','203',4048,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','203',4049,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','203',4050,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','203',4051,'11','1',125119.92,128871.00,3751.08,881503.80,0.00,0.00,0.00,0.00,0.00),('1','294','2','203',4052,'12','1',161085.71,164064.45,2978.74,700003.90,0.00,0.00,0.00,0.00,0.00),('1','294','2','203',4053,'13','1',32389.16,32389.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','203',4054,'14','1',172735.50,172735.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','203',4055,'15','1',138082.58,139601.82,1519.24,357021.40,0.00,0.00,0.00,0.00,0.00),('1','294','2','203',4056,'16','1',41064.50,41064.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','203',4057,'17','2',275687.82,275687.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','203',4058,'18','2',16699.23,16699.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','203',4059,'19','2',77838.35,77838.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','203',4060,'20','2',19361.72,19361.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','204',4061,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','204',4062,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','204',4063,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','204',4064,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','204',4065,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','204',4066,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','204',4067,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','204',4068,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','204',4069,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','204',4070,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','204',4071,'11','1',128871.00,128871.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','204',4072,'12','1',164064.45,164064.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','204',4073,'13','1',32389.16,32389.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','204',4074,'14','1',172735.50,172735.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','204',4075,'15','1',139601.82,139601.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','204',4076,'16','1',41064.50,41064.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','204',4077,'17','2',275687.82,275728.07,40.25,33005.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','204',4078,'18','2',16699.23,16699.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','204',4079,'19','2',77838.35,79725.79,1887.44,1547700.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','204',4080,'20','2',19361.72,19493.92,132.20,108404.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','205',4081,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','205',4082,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','205',4083,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','205',4084,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','205',4085,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','205',4086,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','205',4087,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','205',4088,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','205',4089,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','205',4090,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','205',4091,'11','1',128871.00,128871.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','205',4092,'12','1',164064.45,164064.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','205',4093,'13','1',32389.16,32389.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','205',4094,'14','1',172735.50,172735.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','205',4095,'15','1',139601.82,139601.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','205',4096,'16','1',41064.50,41064.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','205',4097,'17','2',275728.07,277909.32,2181.25,1788625.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','205',4098,'18','2',16699.23,16699.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','205',4099,'19','2',79725.79,82354.82,2629.03,2155804.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','205',4100,'20','2',19493.92,20493.92,1000.00,820000.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','206',4101,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','206',4102,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','206',4103,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','206',4104,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','206',4105,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','206',4106,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','206',4107,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','206',4108,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','206',4109,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','206',4110,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','206',4111,'11','1',128871.00,128871.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','206',4112,'12','1',164064.45,164064.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','206',4113,'13','1',32389.16,32389.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','206',4114,'14','1',172735.50,172735.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','206',4115,'15','1',139601.82,139601.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','206',4116,'16','1',41064.50,41064.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','206',4117,'17','2',277909.32,279107.23,1197.91,982286.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','206',4118,'18','2',16699.23,16699.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','206',4119,'19','2',82354.82,84338.85,1984.03,1626904.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','206',4120,'20','2',20493.92,20493.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','207',4121,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','207',4122,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','207',4123,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','207',4124,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','207',4125,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','207',4126,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','207',4127,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','207',4128,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','207',4129,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','207',4130,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','207',4131,'11','1',128871.00,128871.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','207',4132,'12','1',164064.45,164064.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','207',4133,'13','1',32389.16,32389.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','207',4134,'14','1',172735.50,172735.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','207',4135,'15','1',139601.82,139601.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','207',4136,'16','1',41064.50,41064.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','207',4137,'17','2',279107.23,282295.96,3188.73,2614758.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','207',4138,'18','2',16699.23,16699.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','207',4139,'19','2',84338.85,85885.91,1547.06,1268589.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','207',4140,'20','2',20493.92,20623.92,130.00,106600.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','208',4141,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','208',4142,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','208',4143,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','208',4144,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','208',4145,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','208',4146,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','208',4147,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','208',4148,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','208',4149,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','208',4150,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','208',4151,'11','1',128871.00,128871.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','208',4152,'12','1',164064.45,164064.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','208',4153,'13','1',32389.16,32389.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','208',4154,'14','1',172735.50,172735.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','208',4155,'15','1',139601.82,139601.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','208',4156,'16','1',41064.50,41064.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','208',4157,'17','2',282295.96,284664.22,2368.26,1941973.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','208',4158,'18','2',16699.23,16699.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','208',4159,'19','2',85885.91,87607.09,1721.18,1411367.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','208',4160,'20','2',20623.92,20623.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','209',4161,'1','1',17806.75,17806.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','209',4162,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','209',4163,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','209',4164,'4','1',7371.07,7371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','209',4165,'5','1',31867.34,31867.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','209',4166,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','209',4167,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','209',4168,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','209',4169,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','209',4170,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','209',4171,'11','1',128871.00,128871.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','209',4172,'12','1',164064.45,164064.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','209',4173,'13','1',32389.16,32389.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','209',4174,'14','1',172735.50,172735.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','209',4175,'15','1',139601.82,139601.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','209',4176,'16','1',41064.50,41064.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','209',4177,'17','2',284664.22,284664.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','209',4178,'18','2',16699.23,16699.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','209',4179,'19','2',87607.09,87737.09,130.00,106600.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','209',4180,'20','2',20623.92,20623.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','210',4181,'1','1',17806.75,22314.53,4507.78,1059328.30,0.00,0.00,0.00,0.00,0.00),('1','294','1','210',4182,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','210',4183,'3','1',28786.99,28786.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','210',4184,'4','1',7371.07,10591.43,3200.36,752084.60,0.00,0.00,20.00,0.00,0.00),('1','294','1','210',4185,'5','1',31867.34,36285.59,4414.79,1037475.65,0.00,0.00,3.46,0.00,0.00),('1','294','1','210',4186,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','210',4187,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','210',4188,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','210',4189,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','210',4190,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','210',4191,'11','1',128871.00,128871.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','210',4192,'12','1',164064.45,164064.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','210',4193,'13','1',32389.16,32389.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','210',4194,'14','1',172735.50,172735.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','210',4195,'15','1',139601.82,139601.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','210',4196,'16','1',41064.50,41064.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','210',4197,'17','2',284664.22,284664.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','210',4198,'18','2',16699.23,16699.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','210',4199,'19','2',87737.09,87737.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','210',4200,'20','2',20623.92,20623.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','211',4201,'1','1',22314.53,26506.17,4191.64,985035.40,0.00,0.00,0.00,0.00,0.00),('1','294','1','211',4202,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','211',4203,'3','1',28786.99,32298.11,3511.12,825113.20,0.00,0.00,0.00,0.00,0.00),('1','294','1','211',4204,'4','1',10591.43,10591.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','211',4205,'5','1',36285.59,40696.10,4410.51,1036469.85,0.00,0.00,0.00,0.00,0.00),('1','294','1','211',4206,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','211',4207,'7','1',5846.12,5846.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','211',4208,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','211',4209,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','211',4210,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','211',4211,'11','1',128871.00,128871.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','211',4212,'12','1',164064.45,164064.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','211',4213,'13','1',32389.16,32389.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','211',4214,'14','1',172735.50,172735.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','211',4215,'15','1',139601.82,139601.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','211',4216,'16','1',41064.50,41064.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','211',4217,'17','2',284664.22,284664.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','211',4218,'18','2',16699.23,16699.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','211',4219,'19','2',87737.09,87737.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','211',4220,'20','2',20623.92,20623.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','212',4221,'1','1',26506.17,28002.06,1495.89,351534.15,0.00,0.00,0.00,0.00,0.00),('1','294','1','212',4222,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','212',4223,'3','1',32298.11,33830.56,1532.45,360125.75,0.00,0.00,0.00,0.00,0.00),('1','294','1','212',4224,'4','1',10591.43,10591.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','212',4225,'5','1',40696.10,42268.63,1572.53,369544.55,0.00,0.00,0.00,0.00,0.00),('1','294','1','212',4226,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','212',4227,'7','1',5846.12,6866.97,1020.85,239899.75,0.00,0.00,0.00,0.00,0.00),('1','294','1','212',4228,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','212',4229,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','212',4230,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','212',4231,'11','1',128871.00,130480.33,1609.33,378192.55,0.00,0.00,0.00,0.00,0.00),('1','294','2','212',4232,'12','1',164064.45,165236.93,1172.48,275532.80,0.00,0.00,0.00,0.00,0.00),('1','294','2','212',4233,'13','1',32389.16,32389.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','212',4234,'14','1',172735.50,174065.80,1330.30,312620.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','212',4235,'15','1',139601.82,141064.93,1463.11,343830.85,0.00,0.00,0.00,0.00,0.00),('1','294','2','212',4236,'16','1',41064.50,41064.65,0.00,0.00,0.00,0.00,0.15,0.00,0.00),('1','294','3','212',4237,'17','2',284664.22,284664.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','212',4238,'18','2',16699.23,16699.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','212',4239,'19','2',87737.09,87737.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','212',4240,'20','2',20623.92,20623.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','213',4241,'1','1',28002.06,28002.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','213',4242,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','213',4243,'3','1',33830.56,33830.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','213',4244,'4','1',10591.43,10591.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','213',4245,'5','1',42268.63,42268.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','213',4246,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','213',4247,'7','1',6866.97,6866.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','213',4248,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','213',4249,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','213',4250,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','213',4251,'11','1',130480.33,134750.14,4269.81,1003405.35,0.00,0.00,0.00,0.00,0.00),('1','294','2','213',4252,'12','1',165236.93,168632.29,3395.36,797909.60,0.00,0.00,0.00,0.00,0.00),('1','294','2','213',4253,'13','1',32389.16,32416.82,27.66,6500.10,0.00,0.00,0.00,0.00,0.00),('1','294','2','213',4254,'14','1',174065.80,177000.19,2934.39,689581.65,0.00,0.00,0.00,0.00,0.00),('1','294','2','213',4255,'15','1',141064.93,145077.70,4012.77,943000.95,0.00,0.00,0.00,0.00,0.00),('1','294','2','213',4256,'16','1',41064.65,41064.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','213',4257,'17','2',284664.22,284664.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','213',4258,'18','2',16699.23,16699.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','213',4259,'19','2',87737.09,87737.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','213',4260,'20','2',20623.92,20623.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','214',4261,'1','1',28002.06,28002.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','214',4262,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','214',4263,'3','1',33830.56,33830.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','214',4264,'4','1',10591.43,10591.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','214',4265,'5','1',42268.63,42268.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','214',4266,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','214',4267,'7','1',6866.97,6866.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','214',4268,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','214',4269,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','214',4270,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','214',4271,'11','1',134750.14,138985.08,4234.94,995210.90,0.00,0.00,0.00,0.00,0.00),('1','294','2','214',4272,'12','1',168632.29,172376.09,3743.80,879793.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','214',4273,'13','1',32416.82,34187.83,1771.01,416187.35,0.00,0.00,0.00,0.00,0.00),('1','294','2','214',4274,'14','1',177000.19,180551.52,3551.33,834562.55,0.00,0.00,0.00,0.00,0.00),('1','294','2','214',4275,'15','1',145077.70,147857.77,2780.07,653316.45,0.00,0.00,0.00,0.00,0.00),('1','294','2','214',4276,'16','1',41064.65,41064.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','214',4277,'17','2',284664.22,284664.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','214',4278,'18','2',16699.23,16699.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','214',4279,'19','2',87737.09,87737.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','214',4280,'20','2',20623.92,20623.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','215',4281,'1','1',28002.06,28002.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','215',4282,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','215',4283,'3','1',33830.56,33830.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','215',4284,'4','1',10591.43,10591.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','215',4285,'5','1',42268.63,42268.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','215',4286,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','215',4287,'7','1',6866.97,6866.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','215',4288,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','215',4289,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','215',4290,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','215',4291,'11','1',138985.08,143990.99,4985.91,1171688.85,0.00,0.00,20.00,0.00,0.00),('1','294','2','215',4292,'12','1',172376.09,172376.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','215',4293,'13','1',34187.83,35190.00,1002.17,235509.95,0.00,0.00,0.00,0.00,0.00),('1','294','2','215',4294,'14','1',180551.52,184447.65,3895.53,915449.55,0.00,0.00,0.60,0.00,0.00),('1','294','2','215',4295,'15','1',147857.77,151783.30,3925.53,922499.55,0.00,0.00,0.00,0.00,0.00),('1','294','2','215',4296,'16','1',41064.65,41065.03,0.38,89.30,0.00,0.00,0.00,0.00,0.00),('1','294','3','215',4297,'17','2',284664.22,284664.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','215',4298,'18','2',16699.23,16699.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','215',4299,'19','2',87737.09,87737.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','215',4300,'20','2',20623.92,20623.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','216',4301,'1','1',28002.06,28002.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','216',4302,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','216',4303,'3','1',33830.56,33830.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','216',4304,'4','1',10591.43,10591.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','216',4305,'5','1',42268.63,42268.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','216',4306,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','216',4307,'7','1',6866.97,6866.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','216',4308,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','216',4309,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','216',4310,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','216',4311,'11','1',143990.99,143990.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','216',4312,'12','1',172376.09,172376.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','216',4313,'13','1',35190.00,35190.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','216',4314,'14','1',184447.65,184447.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','216',4315,'15','1',151783.30,151783.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','216',4316,'16','1',41065.03,41065.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','216',4317,'17','2',284664.22,284664.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','216',4318,'18','2',16699.23,16699.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','216',4319,'19','2',87737.09,89091.49,1354.40,1110608.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','216',4320,'20','2',20623.92,20743.92,120.00,98400.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','217',4321,'1','1',28002.06,28002.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','217',4322,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','217',4323,'3','1',33830.56,33830.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','217',4324,'4','1',10591.43,10591.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','217',4325,'5','1',42268.63,42268.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','217',4326,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','217',4327,'7','1',6866.97,6866.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','217',4328,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','217',4329,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','217',4330,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','217',4331,'11','1',143990.99,143990.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','217',4332,'12','1',172376.09,172376.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','217',4333,'13','1',35190.00,35190.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','217',4334,'14','1',184447.65,184447.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','217',4335,'15','1',151783.30,151783.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','217',4336,'16','1',41065.03,41065.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','217',4337,'17','2',284664.22,286715.33,2051.11,1681910.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','217',4338,'18','2',16699.23,16699.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','217',4339,'19','2',89091.49,89705.03,613.54,503102.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','217',4340,'20','2',20743.92,20743.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','218',4341,'1','1',28002.06,28002.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','218',4342,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','218',4343,'3','1',33830.56,33830.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','218',4344,'4','1',10591.43,10591.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','218',4345,'5','1',42268.63,42268.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','218',4346,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','218',4347,'7','1',6866.97,6866.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','218',4348,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','218',4349,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','218',4350,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','218',4351,'11','1',143990.99,143990.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','218',4352,'12','1',172376.09,172376.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','218',4353,'13','1',35190.00,35190.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','218',4354,'14','1',184447.65,184447.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','218',4355,'15','1',151783.30,151783.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','218',4356,'16','1',41065.03,41065.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','218',4357,'17','2',286715.33,288715.53,2000.20,1640164.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','218',4358,'18','2',16699.23,16699.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','218',4359,'19','2',89705.03,91590.97,1885.94,1546470.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','218',4360,'20','2',20743.92,21196.28,452.36,370935.20,0.00,0.00,0.00,0.00,0.00),('1','294','1','219',4361,'1','1',28002.06,28002.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','219',4362,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','219',4363,'3','1',33830.56,33830.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','219',4364,'4','1',10591.43,10591.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','219',4365,'5','1',42268.63,42268.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','219',4366,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','219',4367,'7','1',6866.97,6866.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','219',4368,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','219',4369,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','219',4370,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','219',4371,'11','1',143990.99,143990.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','219',4372,'12','1',172376.09,172376.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','219',4373,'13','1',35190.00,35190.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','219',4374,'14','1',184447.65,184447.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','219',4375,'15','1',151783.30,151783.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','219',4376,'16','1',41065.03,41065.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','219',4377,'17','2',288715.53,291842.12,3126.59,2563803.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','219',4378,'18','2',16699.23,16699.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','219',4379,'19','2',91590.97,94075.52,2484.55,2037331.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','219',4380,'20','2',21196.28,21196.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','220',4381,'1','1',28002.06,28002.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','220',4382,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','220',4383,'3','1',33830.56,33830.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','220',4384,'4','1',10591.43,10591.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','220',4385,'5','1',42268.63,42268.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','220',4386,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','220',4387,'7','1',6866.97,6866.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','220',4388,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','220',4389,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','220',4390,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','220',4391,'11','1',143990.99,143990.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','220',4392,'12','1',172376.09,172376.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','220',4393,'13','1',35190.00,35190.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','220',4394,'14','1',184447.65,184447.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','220',4395,'15','1',151783.30,151783.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','220',4396,'16','1',41065.03,41065.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','220',4397,'17','2',291842.12,291842.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','220',4398,'18','2',16699.23,17219.45,520.22,426580.40,0.00,0.00,0.00,0.00,0.00),('1','294','3','220',4399,'19','2',94075.52,95828.12,1752.60,1437132.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','220',4400,'20','2',21196.28,21828.48,632.20,518404.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','221',4401,'1','1',28002.06,28002.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','221',4402,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','221',4403,'3','1',33830.56,33830.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','221',4404,'4','1',10591.43,10591.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','221',4405,'5','1',42268.63,42268.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','221',4406,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','221',4407,'7','1',6866.97,6866.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','221',4408,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','221',4409,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','221',4410,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','221',4411,'11','1',143990.99,143990.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','221',4412,'12','1',172376.09,172376.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','221',4413,'13','1',35190.00,35190.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','221',4414,'14','1',184447.65,184447.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','221',4415,'15','1',151783.30,151783.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','221',4416,'16','1',41065.03,41065.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','221',4417,'17','2',291842.12,293980.86,2138.74,1753766.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','221',4418,'18','2',17219.45,17219.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','221',4419,'19','2',95828.12,97463.98,1635.86,1341405.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','221',4420,'20','2',21828.48,21828.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','222',4421,'1','1',28002.06,28002.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','222',4422,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','222',4423,'3','1',33830.56,33830.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','222',4424,'4','1',10591.43,10591.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','222',4425,'5','1',42268.63,42268.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','222',4426,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','222',4427,'7','1',6866.97,6866.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','222',4428,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','222',4429,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','222',4430,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','222',4431,'11','1',143990.99,143990.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','222',4432,'12','1',172376.09,172376.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','222',4433,'13','1',35190.00,35190.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','222',4434,'14','1',184447.65,184447.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','222',4435,'15','1',151783.30,151783.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','222',4436,'16','1',41065.03,41065.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','222',4437,'17','2',293980.86,296795.29,2814.43,2307832.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','222',4438,'18','2',17219.45,17219.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','222',4439,'19','2',97463.98,101294.74,3830.76,3141223.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','222',4440,'20','2',21828.48,22328.48,500.00,410000.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','223',4441,'1','1',28002.06,28002.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','223',4442,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','223',4443,'3','1',33830.56,33830.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','223',4444,'4','1',10591.43,10591.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','223',4445,'5','1',42268.63,42268.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','223',4446,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','223',4447,'7','1',6866.97,6866.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','223',4448,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','223',4449,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','223',4450,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','223',4451,'11','1',143990.99,143990.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','223',4452,'12','1',172376.09,172376.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','223',4453,'13','1',35190.00,35190.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','223',4454,'14','1',184447.65,184447.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','223',4455,'15','1',151783.30,151783.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','223',4456,'16','1',41065.03,41065.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','223',4457,'17','2',296795.29,298824.79,2029.50,1664190.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','223',4458,'18','2',17219.45,17219.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','223',4459,'19','2',101294.74,102954.90,1660.16,1361331.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','223',4460,'20','2',22328.48,22328.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','224',4461,'1','1',28002.06,28002.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','224',4462,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','224',4463,'3','1',33830.56,33830.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','224',4464,'4','1',10591.43,10591.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','224',4465,'5','1',42268.63,42268.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','224',4466,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','224',4467,'7','1',6866.97,6866.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','224',4468,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','224',4469,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','224',4470,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','224',4471,'11','1',143990.99,143990.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','224',4472,'12','1',172376.09,172376.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','224',4473,'13','1',35190.00,35190.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','224',4474,'14','1',184447.65,184447.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','224',4475,'15','1',151783.30,151783.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','224',4476,'16','1',41065.03,41065.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','224',4477,'17','2',298824.79,300993.21,2168.42,1778104.40,0.00,0.00,0.00,0.00,0.00),('1','294','3','224',4478,'18','2',17219.45,17219.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','224',4479,'19','2',102954.90,105211.69,2256.79,1850567.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','224',4480,'20','2',22328.48,23117.48,789.00,646980.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','225',4481,'1','1',28002.06,28002.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','225',4482,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','225',4483,'3','1',33830.56,33830.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','225',4484,'4','1',10591.43,10591.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','225',4485,'5','1',42268.63,42268.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','225',4486,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','225',4487,'7','1',6866.97,6866.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','225',4488,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','225',4489,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','225',4490,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','225',4491,'11','1',143990.99,143990.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','225',4492,'12','1',172376.09,172376.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','225',4493,'13','1',35190.00,35190.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','225',4494,'14','1',184447.65,184447.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','225',4495,'15','1',151783.30,151783.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','225',4496,'16','1',41065.03,41065.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','225',4497,'17','2',300993.21,301622.98,629.77,510113.70,0.00,0.00,0.00,0.00,0.00),('1','294','3','225',4498,'18','2',17219.45,17462.54,243.09,196902.90,0.00,0.00,0.00,0.00,0.00),('1','294','3','225',4499,'19','2',105211.69,106573.60,1361.91,1103147.10,0.00,0.00,0.00,0.00,0.00),('1','294','3','225',4500,'20','2',23117.48,23117.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','226',4501,'1','1',28002.06,28002.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','226',4502,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','226',4503,'3','1',33830.56,33830.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','226',4504,'4','1',10591.43,10591.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','226',4505,'5','1',42268.63,42268.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','226',4506,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','226',4507,'7','1',6866.97,6866.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','226',4508,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','226',4509,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','226',4510,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','226',4511,'11','1',143990.99,143990.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','226',4512,'12','1',172376.09,172376.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','226',4513,'13','1',35190.00,35190.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','226',4514,'14','1',184447.65,184447.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','226',4515,'15','1',151783.30,151783.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','226',4516,'16','1',41065.03,41065.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','226',4517,'17','2',301622.98,302689.84,1066.86,864156.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','226',4518,'18','2',17462.54,17462.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','226',4519,'19','2',106573.60,107820.54,1246.94,1010021.40,0.00,0.00,0.00,0.00,0.00),('1','294','3','226',4520,'20','2',23117.48,23117.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','227',4521,'1','1',28002.06,28002.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','227',4522,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','227',4523,'3','1',33830.56,33830.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','227',4524,'4','1',10591.43,10591.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','227',4525,'5','1',42268.63,42268.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','227',4526,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','227',4527,'7','1',6866.97,6866.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','227',4528,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','227',4529,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','227',4530,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','227',4531,'11','1',143990.99,143990.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','227',4532,'12','1',172376.09,172376.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','227',4533,'13','1',35190.00,35190.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','227',4534,'14','1',184447.65,184447.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','227',4535,'15','1',151783.30,151783.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','227',4536,'16','1',41065.03,41065.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','227',4537,'17','2',302689.84,305284.36,2594.52,2101561.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','227',4538,'18','2',17462.54,17462.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','227',4539,'19','2',107820.54,112247.55,4427.01,3585878.10,0.00,0.00,0.00,0.00,0.00),('1','294','3','227',4540,'20','2',23117.48,23117.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','228',4541,'1','1',28002.06,28002.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','228',4542,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','228',4543,'3','1',33830.56,33830.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','228',4544,'4','1',10591.43,10591.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','228',4545,'5','1',42268.63,42268.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','228',4546,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','228',4547,'7','1',6866.97,6866.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','228',4548,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','228',4549,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','228',4550,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','228',4551,'11','1',143990.99,148180.75,4189.76,984593.60,0.00,0.00,0.00,0.00,0.00),('1','294','2','228',4552,'12','1',172376.09,177787.40,5411.31,1271657.85,0.00,0.00,0.00,0.00,0.00),('1','294','2','228',4553,'13','1',35190.00,35190.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','228',4554,'14','1',184447.65,187345.98,2898.33,681107.55,0.00,0.00,0.00,0.00,0.00),('1','294','2','228',4555,'15','1',151783.30,157395.42,5612.12,1318848.20,0.00,0.00,0.00,0.00,0.00),('1','294','2','228',4556,'16','1',41065.03,41065.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','228',4557,'17','2',305284.36,306037.14,752.78,609751.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','228',4558,'18','2',17462.54,17562.55,100.01,81008.10,0.00,0.00,0.00,0.00,0.00),('1','294','3','228',4559,'19','2',112247.55,115031.22,2783.67,2254772.70,0.00,0.00,0.00,0.00,0.00),('1','294','3','228',4560,'20','2',23117.48,23417.48,300.00,243000.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','229',4561,'1','1',28002.06,28002.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','229',4562,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','229',4563,'3','1',33830.56,33830.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','229',4564,'4','1',10591.43,10591.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','229',4565,'5','1',42268.63,42268.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','229',4566,'6','1',5297.72,5297.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','229',4567,'7','1',6866.97,6866.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','229',4568,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','229',4569,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','229',4570,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','229',4571,'11','1',148180.75,148180.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','229',4572,'12','1',177787.40,177787.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','229',4573,'13','1',35190.00,35190.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','229',4574,'14','1',187345.98,187345.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','229',4575,'15','1',157395.42,157395.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','229',4576,'16','1',41065.03,41065.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','229',4577,'17','2',306037.14,308645.12,2607.98,2112463.80,0.00,0.00,0.00,0.00,0.00),('1','294','3','229',4578,'18','2',17562.55,17562.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','229',4579,'19','2',115031.22,117918.58,2887.36,2338761.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','229',4580,'20','2',23417.48,25586.53,2169.05,1756930.50,0.00,0.00,0.00,0.00,0.00),('1','294','1','230',4581,'1','1',28002.06,28002.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','230',4582,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','230',4583,'3','1',33830.56,33830.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','230',4584,'4','1',10591.43,10591.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','230',4585,'5','1',42268.63,42431.64,135.50,31842.50,0.00,0.00,27.51,0.00,0.00),('1','294','1','230',4586,'6','1',5297.72,5372.51,74.79,17575.65,0.00,0.00,0.00,0.00,0.00),('1','294','1','230',4587,'7','1',6866.97,6975.00,108.03,25387.05,0.00,0.00,0.00,0.00,0.00),('1','294','1','230',4588,'8','1',1310.02,1310.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','230',4589,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','230',4590,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','230',4591,'11','1',148180.75,148180.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','230',4592,'12','1',177787.40,177787.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','230',4593,'13','1',35190.00,35190.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','230',4594,'14','1',187345.98,187345.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','230',4595,'15','1',157395.42,157395.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','230',4596,'16','1',41065.03,41065.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','230',4597,'17','2',308645.12,308645.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','230',4598,'18','2',17562.55,17562.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','230',4599,'19','2',117918.58,117918.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','230',4600,'20','2',25586.53,25586.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','231',4601,'1','1',28002.06,32194.59,4192.53,985244.55,0.00,0.00,0.00,0.00,0.00),('1','294','1','231',4602,'2','1',33873.52,33873.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','231',4603,'3','1',33830.56,38130.71,4300.15,1010535.25,0.00,0.00,0.00,0.00,0.00),('1','294','1','231',4604,'4','1',10591.43,10591.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','231',4605,'5','1',42431.64,47436.61,5004.97,1176167.95,0.00,0.00,0.00,0.00,0.00),('1','294','1','231',4606,'6','1',5372.51,5372.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','231',4607,'7','1',6975.00,9808.06,2833.06,665769.10,0.00,0.00,0.00,0.00,0.00),('1','294','1','231',4608,'8','1',1310.02,2062.07,752.05,176731.75,0.00,0.00,0.00,0.00,0.00),('1','294','2','231',4609,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','231',4610,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','231',4611,'11','1',148180.75,148180.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','231',4612,'12','1',177787.40,177787.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','231',4613,'13','1',35190.00,35190.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','231',4614,'14','1',187345.98,187345.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','231',4615,'15','1',157395.42,157395.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','231',4616,'16','1',41065.03,41065.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','231',4617,'17','2',308645.12,308645.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','231',4618,'18','2',17562.55,18205.54,642.99,520821.90,0.00,0.00,0.00,0.00,0.00),('1','294','3','231',4619,'19','2',117918.58,117918.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','231',4620,'20','2',25586.53,25696.53,110.00,89100.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','232',4621,'1','1',32194.59,33986.54,1791.95,421108.25,0.00,0.00,0.00,0.00,0.00),('1','294','1','232',4622,'2','1',33873.52,38618.94,4725.42,1110473.70,0.00,0.00,20.00,0.00,0.00),('1','294','1','232',4623,'3','1',38130.71,41680.27,3549.56,834146.60,0.00,0.00,0.00,0.00,0.00),('1','294','1','232',4624,'4','1',10591.43,13022.18,2430.75,571226.25,0.00,0.00,0.00,0.00,0.00),('1','294','1','232',4625,'5','1',47436.61,51292.18,3855.57,906058.95,0.00,0.00,0.00,0.00,0.00),('1','294','1','232',4626,'6','1',5372.51,6876.95,1504.44,353543.40,0.00,0.00,0.00,0.00,0.00),('1','294','1','232',4627,'7','1',9808.06,13457.18,3649.12,857543.20,0.00,0.00,0.00,0.00,0.00),('1','294','1','232',4628,'8','1',2062.07,3134.43,1072.36,252004.60,0.00,0.00,0.00,0.00,0.00),('1','294','2','232',4629,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','232',4630,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','232',4631,'11','1',148180.75,148180.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','232',4632,'12','1',177787.40,178291.51,504.11,118465.85,0.00,0.00,0.00,0.00,0.00),('1','294','2','232',4633,'13','1',35190.00,35190.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','232',4634,'14','1',187345.98,187345.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','232',4635,'15','1',157395.42,157395.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','232',4636,'16','1',41065.03,41065.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','232',4637,'17','2',308645.12,308645.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','232',4638,'18','2',18205.54,18205.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','232',4639,'19','2',117918.58,117918.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','232',4640,'20','2',25696.53,25696.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','233',4641,'1','1',33986.54,33986.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','233',4642,'2','1',38618.94,38618.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','233',4643,'3','1',41680.27,41680.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','233',4644,'4','1',13022.18,13022.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','233',4645,'5','1',51292.18,51292.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','233',4646,'6','1',6876.95,6876.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','233',4647,'7','1',13457.18,13457.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','233',4648,'8','1',3134.43,3134.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','233',4649,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','233',4650,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','233',4651,'11','1',148180.75,148575.85,395.10,92848.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','233',4652,'12','1',178291.51,178330.32,38.81,9120.35,0.00,0.00,0.00,0.00,0.00),('1','294','2','233',4653,'13','1',35190.00,35190.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','233',4654,'14','1',187345.98,187817.98,452.00,106220.00,0.00,0.00,20.00,0.00,0.00),('1','294','2','233',4655,'15','1',157395.42,157742.76,347.34,81624.90,0.00,0.00,0.00,0.00,0.00),('1','294','2','233',4656,'16','1',41065.03,41065.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','233',4657,'17','2',308645.12,308645.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','233',4658,'18','2',18205.54,18205.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','233',4659,'19','2',117918.58,117918.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','233',4660,'20','2',25696.53,25696.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','234',4661,'1','1',33986.54,33986.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','234',4662,'2','1',38618.94,38618.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','234',4663,'3','1',41680.27,41680.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','234',4664,'4','1',13022.18,13022.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','234',4665,'5','1',51292.18,51292.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','234',4666,'6','1',6876.95,6876.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','234',4667,'7','1',13457.18,13457.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','234',4668,'8','1',3134.43,3134.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','234',4669,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','234',4670,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','234',4671,'11','1',148575.85,148575.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','234',4672,'12','1',178330.32,178330.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','234',4673,'13','1',35190.00,35190.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','234',4674,'14','1',187817.98,187817.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','234',4675,'15','1',157742.76,157742.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','234',4676,'16','1',41065.03,41065.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','234',4677,'17','2',308645.12,309153.86,508.74,401904.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','234',4678,'18','2',18205.54,18456.67,251.13,198392.70,0.00,0.00,0.00,0.00,0.00),('1','294','3','234',4679,'19','2',117918.58,119221.86,1303.28,1029591.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','234',4680,'20','2',25696.53,25696.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','235',4681,'1','1',33986.54,33986.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','235',4682,'2','1',38618.94,38618.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','235',4683,'3','1',41680.27,41680.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','235',4684,'4','1',13022.18,13022.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','235',4685,'5','1',51292.18,51292.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','235',4686,'6','1',6876.95,6876.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','235',4687,'7','1',13457.18,13457.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','235',4688,'8','1',3134.43,3134.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','235',4689,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','235',4690,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','235',4691,'11','1',148575.85,148575.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','235',4692,'12','1',178330.32,178330.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','235',4693,'13','1',35190.00,35190.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','235',4694,'14','1',187817.98,187817.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','235',4695,'15','1',157742.76,157742.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','235',4696,'16','1',41065.03,41065.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','235',4697,'17','2',309153.86,310401.56,1247.70,985683.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','235',4698,'18','2',18456.67,19571.54,1114.87,880747.30,0.00,0.00,0.00,0.00,0.00),('1','294','3','235',4699,'19','2',119221.86,121916.47,2694.61,2128741.90,0.00,0.00,0.00,0.00,0.00),('1','294','3','235',4700,'20','2',25696.53,26830.98,1134.45,896215.50,0.00,0.00,0.00,0.00,0.00),('1','294','1','236',4701,'1','1',33986.54,33986.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','236',4702,'2','1',38618.94,38618.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','236',4703,'3','1',41680.27,41680.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','236',4704,'4','1',13022.18,13022.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','236',4705,'5','1',51292.18,51292.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','236',4706,'6','1',6876.95,6876.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','236',4707,'7','1',13457.18,13457.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','236',4708,'8','1',3134.43,3134.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','236',4709,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','236',4710,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','236',4711,'11','1',148575.85,148575.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','236',4712,'12','1',178330.32,178330.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','236',4713,'13','1',35190.00,35190.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','236',4714,'14','1',187817.98,187817.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','236',4715,'15','1',157742.76,157742.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','236',4716,'16','1',41065.03,41065.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','236',4717,'17','2',310401.56,310929.84,528.28,417341.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','236',4718,'18','2',19571.54,19571.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','236',4719,'19','2',121916.47,122301.96,385.49,304537.10,0.00,0.00,0.00,0.00,0.00),('1','294','3','236',4720,'20','2',26830.98,27011.11,180.13,142302.70,0.00,0.00,0.00,0.00,0.00),('1','294','1','237',4721,'1','1',33986.54,33986.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','237',4722,'2','1',38618.94,38618.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','237',4723,'3','1',41680.27,41680.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','237',4724,'4','1',13022.18,13022.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','237',4725,'5','1',51292.18,51292.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','237',4726,'6','1',6876.95,6876.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','237',4727,'7','1',13457.18,13457.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','237',4728,'8','1',3134.43,3134.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','237',4729,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','237',4730,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','237',4731,'11','1',148575.85,148575.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','237',4732,'12','1',178330.32,178330.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','237',4733,'13','1',35190.00,35190.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','237',4734,'14','1',187817.98,187817.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','237',4735,'15','1',157742.76,157742.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','237',4736,'16','1',41065.03,41065.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','237',4737,'17','2',310929.84,312319.84,1390.00,1098100.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','237',4738,'18','2',19571.54,19696.54,125.00,98750.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','237',4739,'19','2',122301.96,123906.91,1604.95,1267910.50,0.00,0.00,0.00,0.00,0.00),('1','294','3','237',4740,'20','2',27011.11,27011.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','238',4741,'1','1',33986.54,33986.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','238',4742,'2','1',38618.94,38618.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','238',4743,'3','1',41680.27,41680.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','238',4744,'4','1',13022.18,13022.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','238',4745,'5','1',51292.18,51292.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','238',4746,'6','1',6876.95,6876.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','238',4747,'7','1',13457.18,13457.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','238',4748,'8','1',3134.43,3134.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','238',4749,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','238',4750,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','238',4751,'11','1',148575.85,148575.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','238',4752,'12','1',178330.32,178330.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','238',4753,'13','1',35190.00,35190.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','238',4754,'14','1',187817.98,187817.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','238',4755,'15','1',157742.76,157742.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','238',4756,'16','1',41065.03,41065.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','238',4757,'17','2',312319.84,313519.72,1199.88,947905.20,0.00,0.00,0.00,0.00,0.00),('1','294','3','238',4758,'18','2',19696.54,19696.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','238',4759,'19','2',123906.91,127026.88,3119.97,2464776.30,0.00,0.00,0.00,0.00,0.00),('1','294','3','238',4760,'20','2',27011.11,27011.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','239',4761,'1','1',33986.54,33986.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','239',4762,'2','1',38618.94,38618.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','239',4763,'3','1',41680.27,41680.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','239',4764,'4','1',13022.18,13022.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','239',4765,'5','1',51292.18,51292.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','239',4766,'6','1',6876.95,6876.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','239',4767,'7','1',13457.18,13457.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','239',4768,'8','1',3134.43,3134.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','239',4769,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','239',4770,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','239',4771,'11','1',148575.85,148575.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','239',4772,'12','1',178330.32,178330.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','239',4773,'13','1',35190.00,35190.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','239',4774,'14','1',187817.98,187817.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','239',4775,'15','1',157742.76,157742.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','239',4776,'16','1',41065.03,41065.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','239',4777,'17','2',313519.72,313773.75,254.03,200683.70,0.00,0.00,0.00,0.00,0.00),('1','294','3','239',4778,'18','2',19696.54,19698.07,1.53,1208.70,0.00,0.00,0.00,0.00,0.00),('1','294','3','239',4779,'19','2',127026.88,127204.72,177.84,140493.60,0.00,0.00,0.00,0.00,0.00),('1','294','3','239',4780,'20','2',27011.11,27011.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','240',4781,'1','1',33986.54,33986.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','240',4782,'2','1',38618.94,38618.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','240',4783,'3','1',41680.27,41680.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','240',4784,'4','1',13022.18,13022.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','240',4785,'5','1',51292.18,51292.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','240',4786,'6','1',6876.95,6876.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','240',4787,'7','1',13457.18,13457.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','240',4788,'8','1',3134.43,3134.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','240',4789,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','240',4790,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','240',4791,'11','1',148575.85,152238.44,3642.59,910647.50,0.00,0.00,20.00,0.00,0.00),('1','294','2','240',4792,'12','1',178330.32,183050.29,4719.97,1179992.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','240',4793,'13','1',35190.00,39384.85,4194.85,1048712.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','240',4794,'14','1',187817.98,189727.59,1889.61,472402.50,0.00,0.00,20.00,0.00,0.00),('1','294','2','240',4795,'15','1',157742.76,160708.11,2965.35,741337.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','240',4796,'16','1',41065.03,43756.55,2691.52,672880.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','240',4797,'17','2',313773.75,313773.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','240',4798,'18','2',19698.07,19698.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','240',4799,'19','2',127204.72,127204.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','240',4800,'20','2',27011.11,27011.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','241',4801,'1','1',33986.54,33986.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','241',4802,'2','1',38618.94,38618.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','241',4803,'3','1',41680.27,41680.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','241',4804,'4','1',13022.18,13022.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','241',4805,'5','1',51292.18,51292.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','241',4806,'6','1',6876.95,6876.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','241',4807,'7','1',13457.18,13457.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','241',4808,'8','1',3134.43,3134.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','241',4809,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','241',4810,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','241',4811,'11','1',152238.44,153564.36,1325.92,331480.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','241',4812,'12','1',183050.29,184840.46,1790.17,447542.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','241',4813,'13','1',39384.85,40312.57,927.72,231930.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','241',4814,'14','1',189727.59,192011.78,2284.19,571047.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','241',4815,'15','1',160708.11,162757.69,2049.58,512395.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','241',4816,'16','1',43756.55,44066.95,310.40,77600.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','241',4817,'17','2',313773.75,313773.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','241',4818,'18','2',19698.07,19698.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','241',4819,'19','2',127204.72,127204.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','241',4820,'20','2',27011.11,27011.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','242',4821,'1','1',33986.54,33986.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','242',4822,'2','1',38618.94,38618.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','242',4823,'3','1',41680.27,41680.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','242',4824,'4','1',13022.18,13022.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','242',4825,'5','1',51292.18,51292.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','242',4826,'6','1',6876.95,6876.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','242',4827,'7','1',13457.18,13457.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','242',4828,'8','1',3134.43,3134.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','242',4829,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','242',4830,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','242',4831,'11','1',153564.36,153801.44,237.08,59270.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','242',4832,'12','1',184840.46,185244.17,403.71,100927.50,0.00,0.00,0.00,0.00,0.00),('1','294','2','242',4833,'13','1',40312.57,40480.53,167.96,41990.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','242',4834,'14','1',192011.78,192011.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','242',4835,'15','1',162757.69,163157.75,400.06,100015.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','242',4836,'16','1',44066.95,44066.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','242',4837,'17','2',313773.75,313773.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','242',4838,'18','2',19698.07,19698.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','242',4839,'19','2',127204.72,127204.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','242',4840,'20','2',27011.11,27011.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','243',4841,'1','1',33986.54,34170.95,184.41,36882.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','243',4842,'2','1',38618.94,41823.65,3204.71,640942.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','243',4843,'3','1',41680.27,45198.35,3518.08,703616.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','243',4844,'4','1',13022.18,14926.49,1904.31,380862.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','243',4845,'5','1',51292.18,54383.12,3090.94,618188.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','243',4846,'6','1',6876.95,8775.59,1898.64,379728.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','243',4847,'7','1',13457.18,16565.55,3108.37,621674.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','243',4848,'8','1',3134.43,3134.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','243',4849,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','243',4850,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','243',4851,'11','1',153801.44,153801.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','243',4852,'12','1',185244.17,185244.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','243',4853,'13','1',40480.53,40480.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','243',4854,'14','1',192011.78,192011.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','243',4855,'15','1',163157.75,163157.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','243',4856,'16','1',44066.95,44066.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','243',4857,'17','2',313773.75,313773.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','243',4858,'18','2',19698.07,19698.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','243',4859,'19','2',127204.72,127204.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','243',4860,'20','2',27011.11,27011.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','244',4861,'1','1',34170.95,34170.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','244',4862,'2','1',41823.65,41823.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','244',4863,'3','1',45198.35,45198.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','244',4864,'4','1',14926.49,14926.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','244',4865,'5','1',54383.12,54383.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','244',4866,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','244',4867,'7','1',16565.55,16565.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','244',4868,'8','1',3134.43,3134.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','244',4869,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','244',4870,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','244',4871,'11','1',153801.44,157799.70,3978.26,795652.00,0.00,0.00,20.00,0.00,0.00),('1','294','2','244',4872,'12','1',185244.17,189103.56,3859.39,771878.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','244',4873,'13','1',40480.53,43547.34,3066.81,613362.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','244',4874,'14','1',192011.78,194929.94,2898.16,579632.00,0.00,0.00,20.00,0.00,0.00),('1','294','2','244',4875,'15','1',163157.75,166267.32,3109.57,621914.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','244',4876,'16','1',44066.95,45941.51,1874.56,374912.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','244',4877,'17','2',313773.75,313773.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','244',4878,'18','2',19698.07,19698.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','244',4879,'19','2',127204.72,127204.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','244',4880,'20','2',27011.11,27011.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','245',4881,'1','1',34170.95,34170.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','245',4882,'2','1',41823.65,41823.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','245',4883,'3','1',45198.35,45198.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','245',4884,'4','1',14926.49,14926.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','245',4885,'5','1',54383.12,54383.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','245',4886,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','245',4887,'7','1',16565.55,16565.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','245',4888,'8','1',3134.43,3134.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','245',4889,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','245',4890,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','245',4891,'11','1',157799.70,159374.25,1574.55,314910.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','245',4892,'12','1',189103.56,192722.07,3618.51,723702.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','245',4893,'13','1',43547.34,46739.28,3191.94,638388.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','245',4894,'14','1',194929.94,197579.51,2649.57,529914.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','245',4895,'15','1',166267.32,169670.19,3402.87,680574.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','245',4896,'16','1',45941.51,45941.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','245',4897,'17','2',313773.75,313773.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','245',4898,'18','2',19698.07,19698.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','245',4899,'19','2',127204.72,127204.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','245',4900,'20','2',27011.11,27011.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','246',4901,'1','1',34170.95,34170.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','246',4902,'2','1',41823.65,41823.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','246',4903,'3','1',45198.35,45198.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','246',4904,'4','1',14926.49,14926.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','246',4905,'5','1',54383.12,54383.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','246',4906,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','246',4907,'7','1',16565.55,16565.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','246',4908,'8','1',3134.43,3134.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','246',4909,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','246',4910,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','246',4911,'11','1',159374.25,159374.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','246',4912,'12','1',192722.07,192722.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','246',4913,'13','1',46739.28,46739.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','246',4914,'14','1',197579.51,197579.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','246',4915,'15','1',169670.19,169670.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','246',4916,'16','1',45941.51,45941.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','246',4917,'17','2',313773.75,314829.88,1056.13,844904.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','246',4918,'18','2',19698.07,19698.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','246',4919,'19','2',127204.72,128338.99,1134.27,907416.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','246',4920,'20','2',27011.11,27049.24,38.13,30504.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','247',4921,'1','1',34170.95,34170.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','247',4922,'2','1',41823.65,41823.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','247',4923,'3','1',45198.35,45198.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','247',4924,'4','1',14926.49,14926.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','247',4925,'5','1',54383.12,54383.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','247',4926,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','247',4927,'7','1',16565.55,16565.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','247',4928,'8','1',3134.43,3134.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','247',4929,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','247',4930,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','247',4931,'11','1',159374.25,159374.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','247',4932,'12','1',192722.07,192722.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','247',4933,'13','1',46739.28,46739.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','247',4934,'14','1',197579.51,197579.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','247',4935,'15','1',169670.19,169670.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','247',4936,'16','1',45941.51,45941.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','247',4937,'17','2',314829.88,316493.01,1663.13,1330504.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','247',4938,'18','2',19698.07,19698.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','247',4939,'19','2',128338.99,129808.89,1469.90,1175920.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','247',4940,'20','2',27049.24,27049.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','248',4941,'1','1',34170.95,34170.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','248',4942,'2','1',41823.65,41823.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','248',4943,'3','1',45198.35,45198.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','248',4944,'4','1',14926.49,14926.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','248',4945,'5','1',54383.12,54383.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','248',4946,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','248',4947,'7','1',16565.55,16565.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','248',4948,'8','1',3134.43,3134.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','248',4949,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','248',4950,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','248',4951,'11','1',159374.25,159374.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','248',4952,'12','1',192722.07,192722.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','248',4953,'13','1',46739.28,46739.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','248',4954,'14','1',197579.51,197579.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','248',4955,'15','1',169670.19,169670.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','248',4956,'16','1',45941.51,45941.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','248',4957,'17','2',316493.01,317330.50,837.49,669992.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','248',4958,'18','2',19698.07,21028.15,1330.08,1064064.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','248',4959,'19','2',129808.89,131148.90,1340.01,1072008.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','248',4960,'20','2',27049.24,28251.74,1202.50,962000.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','249',4961,'1','1',34170.95,34170.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','249',4962,'2','1',41823.65,41823.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','249',4963,'3','1',45198.35,45198.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','249',4964,'4','1',14926.49,14926.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','249',4965,'5','1',54383.12,54383.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','249',4966,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','249',4967,'7','1',16565.55,16565.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','249',4968,'8','1',3134.43,3134.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','249',4969,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','249',4970,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','249',4971,'11','1',159374.25,159374.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','249',4972,'12','1',192722.07,192722.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','249',4973,'13','1',46739.28,46739.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','249',4974,'14','1',197579.51,197579.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','249',4975,'15','1',169670.19,169670.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','249',4976,'16','1',45941.51,45941.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','249',4977,'17','2',317330.50,319993.00,2662.50,2130000.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','249',4978,'18','2',21028.15,21028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','249',4979,'19','2',131148.90,133753.90,2605.00,2084000.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','249',4980,'20','2',28251.74,28251.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','250',4981,'1','1',34170.95,34170.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','250',4982,'2','1',41823.65,41823.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','250',4983,'3','1',45198.35,45198.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','250',4984,'4','1',14926.49,14926.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','250',4985,'5','1',54383.12,54383.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','250',4986,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','250',4987,'7','1',16565.55,16565.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','250',4988,'8','1',3134.43,3134.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','250',4989,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','250',4990,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','250',4991,'11','1',159374.25,159374.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','250',4992,'12','1',192722.07,192722.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','250',4993,'13','1',46739.28,46739.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','250',4994,'14','1',197579.51,197579.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','250',4995,'15','1',169670.19,169670.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','250',4996,'16','1',45941.51,45941.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','250',4997,'17','2',319993.00,322312.51,2319.51,1855608.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','250',4998,'18','2',21028.15,21028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','250',4999,'19','2',133753.90,137146.10,3392.20,2713760.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','250',5000,'20','2',28251.74,28251.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','251',5001,'1','1',34170.95,34170.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','251',5002,'2','1',41823.65,41823.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','251',5003,'3','1',45198.35,45198.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','251',5004,'4','1',14926.49,14926.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','251',5005,'5','1',54383.12,54383.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','251',5006,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','251',5007,'7','1',16565.55,16565.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','251',5008,'8','1',3134.43,3134.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','251',5009,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','251',5010,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','251',5011,'11','1',159374.25,159374.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','251',5012,'12','1',192722.07,192722.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','251',5013,'13','1',46739.28,46739.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','251',5014,'14','1',197579.51,197579.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','251',5015,'15','1',169670.19,169670.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','251',5016,'16','1',45941.51,45941.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','251',5017,'17','2',322312.51,322813.27,500.76,400608.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','251',5018,'18','2',21028.15,21028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','251',5019,'19','2',137146.10,138444.85,1298.75,1039000.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','251',5020,'20','2',28251.74,28351.74,100.00,80000.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','252',5021,'1','1',34170.95,34170.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','252',5022,'2','1',41823.65,41823.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','252',5023,'3','1',45198.35,45198.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','252',5024,'4','1',14926.49,14926.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','252',5025,'5','1',54383.12,54383.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','252',5026,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','252',5027,'7','1',16565.55,16565.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','252',5028,'8','1',3134.43,3134.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','252',5029,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','252',5030,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','252',5031,'11','1',159374.25,159374.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','252',5032,'12','1',192722.07,192722.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','252',5033,'13','1',46739.28,46739.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','252',5034,'14','1',197579.51,197579.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','252',5035,'15','1',169670.19,169670.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','252',5036,'16','1',45941.51,45941.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','252',5037,'17','2',322813.27,324464.33,1651.06,1320848.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','252',5038,'18','2',21028.15,21028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','252',5039,'19','2',138444.85,140410.53,1965.68,1572544.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','252',5040,'20','2',28351.74,28351.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','253',5041,'1','1',34170.95,34170.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','253',5042,'2','1',41823.65,41823.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','253',5043,'3','1',45198.35,45198.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','253',5044,'4','1',14926.49,14926.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','253',5045,'5','1',54383.12,54383.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','253',5046,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','253',5047,'7','1',16565.55,16565.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','253',5048,'8','1',3134.43,3134.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','253',5049,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','253',5050,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','253',5051,'11','1',159374.25,159374.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','253',5052,'12','1',192722.07,192722.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','253',5053,'13','1',46739.28,46739.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','253',5054,'14','1',197579.51,197579.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','253',5055,'15','1',169670.19,169670.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','253',5056,'16','1',45941.51,45941.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','253',5057,'17','2',324464.33,325132.96,668.63,534904.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','253',5058,'18','2',21028.15,21028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','253',5059,'19','2',140410.53,140779.41,368.88,295104.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','253',5060,'20','2',28351.74,28351.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','254',5061,'1','1',34170.95,34170.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','254',5062,'2','1',41823.65,41823.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','254',5063,'3','1',45198.35,45198.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','254',5064,'4','1',14926.49,14926.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','254',5065,'5','1',54383.12,54383.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','254',5066,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','254',5067,'7','1',16565.55,16565.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','254',5068,'8','1',3134.43,3134.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','254',5069,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','254',5070,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','254',5071,'11','1',159374.25,159374.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','254',5072,'12','1',192722.07,192722.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','254',5073,'13','1',46739.28,46739.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','254',5074,'14','1',197579.51,197579.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','254',5075,'15','1',169670.19,169670.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','254',5076,'16','1',45941.51,45941.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','254',5077,'17','2',325132.96,326076.49,943.53,754824.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','254',5078,'18','2',21028.15,21028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','254',5079,'19','2',140779.41,142472.15,1692.74,1354192.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','254',5080,'20','2',28351.74,28351.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','255',5081,'1','1',34170.95,34170.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','255',5082,'2','1',41823.65,41823.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','255',5083,'3','1',45198.35,45198.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','255',5084,'4','1',14926.49,14926.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','255',5085,'5','1',54383.12,54383.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','255',5086,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','255',5087,'7','1',16565.55,16565.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','255',5088,'8','1',3134.43,3134.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','255',5089,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','255',5090,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','255',5091,'11','1',159374.25,159374.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','255',5092,'12','1',192722.07,192722.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','255',5093,'13','1',46739.28,46739.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','255',5094,'14','1',197579.51,197579.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','255',5095,'15','1',169670.19,169670.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','255',5096,'16','1',45941.51,45941.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','255',5097,'17','2',326076.49,328312.12,2235.63,1788504.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','255',5098,'18','2',21028.15,21028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','255',5099,'19','2',142472.15,143227.28,755.13,604104.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','255',5100,'20','2',28351.74,28351.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','256',5101,'1','1',34170.95,34170.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','256',5102,'2','1',41823.65,41823.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','256',5103,'3','1',45198.35,45198.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','256',5104,'4','1',14926.49,14926.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','256',5105,'5','1',54383.12,54383.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','256',5106,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','256',5107,'7','1',16565.55,16565.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','256',5108,'8','1',3134.43,3134.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','256',5109,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','256',5110,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','256',5111,'11','1',159374.25,159374.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','256',5112,'12','1',192722.07,192722.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','256',5113,'13','1',46739.28,46739.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','256',5114,'14','1',197579.51,197579.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','256',5115,'15','1',169670.19,169670.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','256',5116,'16','1',45941.51,45941.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','256',5117,'17','2',328312.12,328937.13,625.01,500008.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','256',5118,'18','2',21028.15,21028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','256',5119,'19','2',143227.28,144318.72,1091.44,873152.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','256',5120,'20','2',28351.74,29141.75,790.01,632008.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','257',5121,'1','1',34170.95,34170.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','257',5122,'2','1',41823.65,41823.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','257',5123,'3','1',45198.35,45198.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','257',5124,'4','1',14926.49,14926.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','257',5125,'5','1',54383.12,54383.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','257',5126,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','257',5127,'7','1',16565.55,16565.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','257',5128,'8','1',3134.43,3134.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','257',5129,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','257',5130,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','257',5131,'11','1',159374.25,159374.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','257',5132,'12','1',192722.07,192722.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','257',5133,'13','1',46739.28,46739.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','257',5134,'14','1',197579.51,197579.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','257',5135,'15','1',169670.19,169670.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','257',5136,'16','1',45941.51,45941.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','257',5137,'17','2',328937.13,331541.36,2604.23,2083384.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','257',5138,'18','2',21028.15,21028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','257',5139,'19','2',144318.72,145952.64,1633.92,1307136.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','257',5140,'20','2',29141.75,29141.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','258',5141,'1','1',34170.95,34170.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','258',5142,'2','1',41823.65,41823.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','258',5143,'3','1',45198.35,45198.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','258',5144,'4','1',14926.49,14926.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','258',5145,'5','1',54383.12,54383.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','258',5146,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','258',5147,'7','1',16565.55,16565.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','258',5148,'8','1',3134.43,3134.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','258',5149,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','258',5150,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','258',5151,'11','1',159374.25,159374.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','258',5152,'12','1',192722.07,192722.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','258',5153,'13','1',46739.28,46739.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','258',5154,'14','1',197579.51,197579.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','258',5155,'15','1',169670.19,169670.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','258',5156,'16','1',45941.51,45941.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','258',5157,'17','2',331541.36,332093.03,551.67,441336.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','258',5158,'18','2',21028.15,21028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','258',5159,'19','2',145952.64,146825.83,873.19,698552.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','258',5160,'20','2',29141.75,30252.11,1110.36,888288.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','259',5161,'1','1',34170.95,39410.22,5239.27,1047854.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','259',5162,'2','1',41823.65,41823.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','259',5163,'3','1',45198.35,47810.69,2612.34,522468.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','259',5164,'4','1',14926.49,17530.44,2603.95,520790.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','259',5165,'5','1',54383.12,57742.14,3359.02,671804.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','259',5166,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','259',5167,'7','1',16565.55,19686.67,3121.12,624224.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','259',5168,'8','1',3134.43,3134.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','259',5169,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','259',5170,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','259',5171,'11','1',159374.25,159374.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','259',5172,'12','1',192722.07,192722.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','259',5173,'13','1',46739.28,46739.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','259',5174,'14','1',197579.51,197579.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','259',5175,'15','1',169670.19,169670.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','259',5176,'16','1',45941.51,45941.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','259',5177,'17','2',332093.03,334342.44,2249.41,1799528.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','259',5178,'18','2',21028.15,21028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','259',5179,'19','2',146825.83,147836.26,1010.43,808344.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','259',5180,'20','2',30252.11,30252.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','260',5181,'1','1',39410.22,39410.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','260',5182,'2','1',41823.65,41823.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','260',5183,'3','1',47810.69,47810.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','260',5184,'4','1',17530.44,17530.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','260',5185,'5','1',57742.14,57742.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','260',5186,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','260',5187,'7','1',19686.67,19686.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','260',5188,'8','1',3134.43,3134.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','260',5189,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','260',5190,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','260',5191,'11','1',159374.25,163271.30,3897.05,779410.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','260',5192,'12','1',192722.07,196387.57,3665.50,733100.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','260',5193,'13','1',46739.28,52399.09,5659.81,1131962.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','260',5194,'14','1',197579.51,197579.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','260',5195,'15','1',169670.19,172187.18,2516.99,503398.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','260',5196,'16','1',45941.51,45942.09,0.58,116.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','260',5197,'17','2',334342.44,334342.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','260',5198,'18','2',21028.15,21028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','260',5199,'19','2',147836.26,147836.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','260',5200,'20','2',30252.11,30252.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','261',5201,'1','1',39410.22,39410.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','261',5202,'2','1',41823.65,41823.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','261',5203,'3','1',47810.69,47810.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','261',5204,'4','1',17530.44,17530.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','261',5205,'5','1',57742.14,57742.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','261',5206,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','261',5207,'7','1',19686.67,19686.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','261',5208,'8','1',3134.43,3134.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','261',5209,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','261',5210,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','261',5211,'11','1',163271.30,166083.37,2812.07,562414.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','261',5212,'12','1',196387.57,198448.02,2060.45,412090.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','261',5213,'13','1',52399.09,55477.39,3078.30,615660.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','261',5214,'14','1',197579.51,197579.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','261',5215,'15','1',172187.18,175198.06,3010.88,602176.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','261',5216,'16','1',45942.09,45942.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','261',5217,'17','2',334342.44,334342.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','261',5218,'18','2',21028.15,21028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','261',5219,'19','2',147836.26,147836.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','261',5220,'20','2',30252.11,30252.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','262',5221,'1','1',39410.22,39410.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','262',5222,'2','1',41823.65,41823.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','262',5223,'3','1',47810.69,47810.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','262',5224,'4','1',17530.44,17530.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','262',5225,'5','1',57742.14,57742.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','262',5226,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','262',5227,'7','1',19686.67,19686.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','262',5228,'8','1',3134.43,3134.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','262',5229,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','262',5230,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','262',5231,'11','1',166083.37,169531.79,3448.42,689684.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','262',5232,'12','1',198448.02,202517.01,4068.99,813798.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','262',5233,'13','1',55477.39,59589.95,4112.56,822512.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','262',5234,'14','1',197579.51,197579.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','262',5235,'15','1',175198.06,179450.74,4252.68,850536.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','262',5236,'16','1',45942.09,45942.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','262',5237,'17','2',334342.44,334342.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','262',5238,'18','2',21028.15,21028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','262',5239,'19','2',147836.26,147836.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','262',5240,'20','2',30252.11,30252.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','263',5241,'1','1',39410.22,40524.02,1113.80,222760.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','263',5242,'2','1',41823.65,41823.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','263',5243,'3','1',47810.69,48793.92,983.23,196646.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','263',5244,'4','1',17530.44,17530.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','263',5245,'5','1',57742.14,59613.47,1871.33,374266.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','263',5246,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','263',5247,'7','1',19686.67,19686.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','263',5248,'8','1',3134.43,3134.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','263',5249,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','263',5250,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','263',5251,'11','1',169531.79,172351.32,2819.53,563906.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','263',5252,'12','1',202517.01,205742.06,3225.05,645010.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','263',5253,'13','1',59589.95,62180.17,2590.22,518044.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','263',5254,'14','1',197579.51,197579.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','263',5255,'15','1',179450.74,182986.31,3535.57,707114.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','263',5256,'16','1',45942.09,45942.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','263',5257,'17','2',334342.44,335041.61,699.17,559336.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','263',5258,'18','2',21028.15,21028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','263',5259,'19','2',147836.26,150267.17,2430.91,1944728.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','263',5260,'20','2',30252.11,30252.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','264',5261,'1','1',40524.02,45059.40,4535.38,907076.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','264',5262,'2','1',41823.65,41823.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','264',5263,'3','1',48793.92,51840.48,3046.56,609312.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','264',5264,'4','1',17530.44,17530.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','264',5265,'5','1',59613.47,64124.88,4511.41,902282.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','264',5266,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','264',5267,'7','1',19686.67,22306.97,2620.30,524060.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','264',5268,'8','1',3134.43,6593.89,3459.46,691892.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','264',5269,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','264',5270,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','264',5271,'11','1',172351.32,172351.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','264',5272,'12','1',205742.06,205742.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','264',5273,'13','1',62180.17,62180.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','264',5274,'14','1',197579.51,197579.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','264',5275,'15','1',182986.31,182986.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','264',5276,'16','1',45942.09,45942.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','264',5277,'17','2',335041.61,335879.28,837.67,670136.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','264',5278,'18','2',21028.15,21028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','264',5279,'19','2',150267.17,150267.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','264',5280,'20','2',30252.11,33263.34,3011.23,2408984.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','265',5281,'1','1',45059.40,45059.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','265',5282,'2','1',41823.65,41823.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','265',5283,'3','1',51840.48,51840.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','265',5284,'4','1',17530.44,17530.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','265',5285,'5','1',64124.88,64124.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','265',5286,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','265',5287,'7','1',22306.97,22306.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','265',5288,'8','1',6593.89,6593.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','265',5289,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','265',5290,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','265',5291,'11','1',172351.32,176654.90,4303.58,860716.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','265',5292,'12','1',205742.06,211258.89,5516.83,1103366.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','265',5293,'13','1',62180.17,66398.76,4218.59,843718.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','265',5294,'14','1',197579.51,201073.27,3493.76,698752.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','265',5295,'15','1',182986.31,189297.81,6311.50,1262300.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','265',5296,'16','1',45942.09,45942.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','265',5297,'17','2',335879.28,337083.80,1204.52,963616.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','265',5298,'18','2',21028.15,21028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','265',5299,'19','2',150267.17,151782.89,1515.72,1212576.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','265',5300,'20','2',33263.34,33288.34,25.00,20000.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','266',5301,'1','1',45059.40,45059.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','266',5302,'2','1',41823.65,41823.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','266',5303,'3','1',51840.48,51840.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','266',5304,'4','1',17530.44,17530.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','266',5305,'5','1',64124.88,64124.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','266',5306,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','266',5307,'7','1',22306.97,22306.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','266',5308,'8','1',6593.89,6593.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','266',5309,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','266',5310,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','266',5311,'11','1',176654.90,178620.52,1965.62,393124.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','266',5312,'12','1',211258.89,213069.79,1810.90,362180.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','266',5313,'13','1',66398.76,67907.79,1509.03,301806.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','266',5314,'14','1',201073.27,202066.05,992.78,198556.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','266',5315,'15','1',189297.81,191456.59,2158.78,431756.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','266',5316,'16','1',45942.09,45942.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','266',5317,'17','2',337083.80,337083.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','266',5318,'18','2',21028.15,21028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','266',5319,'19','2',151782.89,154113.05,2330.16,1864128.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','266',5320,'20','2',33288.34,33288.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','267',5321,'1','1',45059.40,45059.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','267',5322,'2','1',41823.65,41823.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','267',5323,'3','1',51840.48,51840.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','267',5324,'4','1',17530.44,17530.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','267',5325,'5','1',64124.88,64181.34,56.46,11292.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','267',5326,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','267',5327,'7','1',22306.97,22306.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','267',5328,'8','1',6593.89,6593.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','267',5329,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','267',5330,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','267',5331,'11','1',178620.52,180010.22,1389.70,277940.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','267',5332,'12','1',213069.79,220933.16,7863.37,1572674.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','267',5333,'13','1',67907.79,67907.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','267',5334,'14','1',202066.05,202066.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','267',5335,'15','1',191456.59,191456.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','267',5336,'16','1',45942.09,45942.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','267',5337,'17','2',337083.80,337083.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','267',5338,'18','2',21028.15,21028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','267',5339,'19','2',154113.05,157716.75,3603.70,2882960.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','267',5340,'20','2',33288.34,33688.34,400.00,320000.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','268',5341,'1','1',45059.40,46611.84,1552.44,310488.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','268',5342,'2','1',41823.65,42929.21,1105.56,221112.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','268',5343,'3','1',51840.48,51840.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','268',5344,'4','1',17530.44,17530.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','268',5345,'5','1',64181.34,64181.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','268',5346,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','268',5347,'7','1',22306.97,22306.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','268',5348,'8','1',6593.89,6593.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','268',5349,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','268',5350,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','268',5351,'11','1',180010.22,180010.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','268',5352,'12','1',220933.16,220933.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','268',5353,'13','1',67907.79,67907.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','268',5354,'14','1',202066.05,202066.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','268',5355,'15','1',191456.59,191456.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','268',5356,'16','1',45942.09,45942.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','268',5357,'17','2',337083.80,337083.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','268',5358,'18','2',21028.15,21028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','268',5359,'19','2',157716.75,157716.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','268',5360,'20','2',33688.34,35161.34,1473.00,1178400.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','269',5361,'1','1',46611.84,49169.40,2557.56,511512.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','269',5362,'2','1',42929.21,45515.15,2565.94,513188.00,0.00,0.00,20.00,0.00,0.00),('1','294','1','269',5363,'3','1',51840.48,53673.26,1832.78,366556.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','269',5364,'4','1',17530.44,20212.74,2662.30,532460.00,0.00,0.00,20.00,0.00,0.00),('1','294','1','269',5365,'5','1',64181.34,64181.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','269',5366,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','269',5367,'7','1',22306.97,22306.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','269',5368,'8','1',6593.89,6593.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','269',5369,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','269',5370,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','269',5371,'11','1',180010.22,180010.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','269',5372,'12','1',220933.16,220933.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','269',5373,'13','1',67907.79,67907.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','269',5374,'14','1',202066.05,202066.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','269',5375,'15','1',191456.59,191456.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','269',5376,'16','1',45942.09,45942.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','269',5377,'17','2',337083.80,337083.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','269',5378,'18','2',21028.15,21028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','269',5379,'19','2',157716.75,158414.38,697.63,558104.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','269',5380,'20','2',35161.34,35161.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','270',5381,'1','1',49169.40,50359.77,1190.37,238074.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','270',5382,'2','1',45515.15,46857.49,1342.34,268468.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','270',5383,'3','1',53673.26,54494.18,820.92,164184.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','270',5384,'4','1',20212.74,20822.33,609.59,121918.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','270',5385,'5','1',64181.34,64181.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','270',5386,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','270',5387,'7','1',22306.97,22306.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','270',5388,'8','1',6593.89,6593.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','270',5389,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','270',5390,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','270',5391,'11','1',180010.22,180010.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','270',5392,'12','1',220933.16,223823.39,2890.23,578046.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','270',5393,'13','1',67907.79,70863.43,2955.64,591128.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','270',5394,'14','1',202066.05,202066.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','270',5395,'15','1',191456.59,193312.80,1856.21,371242.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','270',5396,'16','1',45942.09,45942.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','270',5397,'17','2',337083.80,337143.80,60.00,48000.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','270',5398,'18','2',21028.15,21028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','270',5399,'19','2',158414.38,158734.57,320.19,256152.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','270',5400,'20','2',35161.34,35161.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','271',5401,'1','1',50359.77,50359.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','271',5402,'2','1',46857.49,46857.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','271',5403,'3','1',54494.18,54494.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','271',5404,'4','1',20822.33,20822.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','271',5405,'5','1',64181.34,64181.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','271',5406,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','271',5407,'7','1',22306.97,22306.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','271',5408,'8','1',6593.89,6593.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','271',5409,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','271',5410,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','271',5411,'11','1',180010.22,182329.41,2319.19,463838.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','271',5412,'12','1',223823.39,226805.20,2981.81,596362.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','271',5413,'13','1',70863.43,72533.40,1669.97,333994.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','271',5414,'14','1',202066.05,202066.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','271',5415,'15','1',193312.80,196426.39,3113.59,622718.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','271',5416,'16','1',45942.09,45942.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','271',5417,'17','2',337143.80,337143.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','271',5418,'18','2',21028.15,21028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','271',5419,'19','2',158734.57,158834.58,100.01,80008.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','271',5420,'20','2',35161.34,35218.84,57.50,46000.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','272',5421,'1','1',50359.77,50359.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','272',5422,'2','1',46857.49,46857.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','272',5423,'3','1',54494.18,54494.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','272',5424,'4','1',20822.33,20822.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','272',5425,'5','1',64181.34,64181.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','272',5426,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','272',5427,'7','1',22306.97,22306.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','272',5428,'8','1',6593.89,6593.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','272',5429,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','272',5430,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','272',5431,'11','1',182329.41,184092.62,1763.21,352642.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','272',5432,'12','1',226805.20,230242.70,3437.50,687500.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','272',5433,'13','1',72533.40,74440.65,1907.25,381450.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','272',5434,'14','1',202066.05,205162.15,3096.10,619220.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','272',5435,'15','1',196426.39,200296.18,3869.79,773958.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','272',5436,'16','1',45942.09,45942.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','272',5437,'17','2',337143.80,337143.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','272',5438,'18','2',21028.15,21028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','272',5439,'19','2',158834.58,159709.94,875.36,700288.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','272',5440,'20','2',35218.84,35318.84,100.00,80000.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','273',5441,'1','1',50359.77,50359.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','273',5442,'2','1',46857.49,46857.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','273',5443,'3','1',54494.18,54494.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','273',5444,'4','1',20822.33,20822.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','273',5445,'5','1',64181.34,64181.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','273',5446,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','273',5447,'7','1',22306.97,22306.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','273',5448,'8','1',6593.89,6593.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','273',5449,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','273',5450,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','273',5451,'11','1',184092.62,184665.44,572.82,114564.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','273',5452,'12','1',230242.70,231374.16,1131.46,226292.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','273',5453,'13','1',74440.65,75466.60,1025.95,205190.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','273',5454,'14','1',205162.15,205162.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','273',5455,'15','1',200296.18,201229.22,933.04,186608.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','273',5456,'16','1',45942.09,45942.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','273',5457,'17','2',337143.80,337143.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','273',5458,'18','2',21028.15,21028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','273',5459,'19','2',159709.94,160198.42,488.48,390784.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','273',5460,'20','2',35318.84,35318.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','274',5461,'1','1',50359.77,50359.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','274',5462,'2','1',46857.49,46857.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','274',5463,'3','1',54494.18,54494.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','274',5464,'4','1',20822.33,20822.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','274',5465,'5','1',64181.34,64181.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','274',5466,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','274',5467,'7','1',22306.97,22306.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','274',5468,'8','1',6593.89,6593.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','274',5469,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','274',5470,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','274',5471,'11','1',184665.44,188360.54,3695.10,739020.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','274',5472,'12','1',231374.16,234491.21,3117.05,623410.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','274',5473,'13','1',75466.60,77666.50,2199.90,439980.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','274',5474,'14','1',205162.15,206971.73,1809.58,361916.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','274',5475,'15','1',201229.22,204850.85,3621.63,724326.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','274',5476,'16','1',45942.09,45942.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','274',5477,'17','2',337143.80,337143.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','274',5478,'18','2',21028.15,21028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','274',5479,'19','2',160198.42,160198.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','274',5480,'20','2',35318.84,35318.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','275',5481,'1','1',50359.77,50359.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','275',5482,'2','1',46857.49,46857.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','275',5483,'3','1',54494.18,54494.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','275',5484,'4','1',20822.33,20822.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','275',5485,'5','1',64181.34,64181.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','275',5486,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','275',5487,'7','1',22306.97,22306.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','275',5488,'8','1',6593.89,6593.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','275',5489,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','275',5490,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','275',5491,'11','1',188360.54,189452.41,1091.87,218374.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','275',5492,'12','1',234491.21,236764.71,2273.50,454700.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','275',5493,'13','1',77666.50,79694.61,2028.11,405622.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','275',5494,'14','1',206971.73,206971.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','275',5495,'15','1',204850.85,204850.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','275',5496,'16','1',45942.09,45942.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','275',5497,'17','2',337143.80,337143.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','275',5498,'18','2',21028.15,21028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','275',5499,'19','2',160198.42,160198.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','275',5500,'20','2',35318.84,35318.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','276',5501,'1','1',50359.77,50359.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','276',5502,'2','1',46857.49,46857.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','276',5503,'3','1',54494.18,54494.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','276',5504,'4','1',20822.33,20822.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','276',5505,'5','1',64181.34,64181.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','276',5506,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','276',5507,'7','1',22306.97,22306.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','276',5508,'8','1',6593.89,6593.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','276',5509,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','276',5510,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','276',5511,'11','1',189452.41,191182.01,1729.60,345920.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','276',5512,'12','1',236764.71,239264.14,2499.43,499886.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','276',5513,'13','1',79694.61,81595.36,1900.75,380150.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','276',5514,'14','1',206971.73,208464.65,1492.92,298584.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','276',5515,'15','1',204850.85,206836.01,1985.16,397032.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','276',5516,'16','1',45942.09,45942.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','276',5517,'17','2',337143.80,338105.83,962.03,769624.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','276',5518,'18','2',21028.15,21028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','276',5519,'19','2',160198.42,160198.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','276',5520,'20','2',35318.84,35318.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','277',5521,'1','1',50359.77,50359.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','277',5522,'2','1',46857.49,46857.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','277',5523,'3','1',54494.18,54494.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','277',5524,'4','1',20822.33,20822.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','277',5525,'5','1',64181.34,64181.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','277',5526,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','277',5527,'7','1',22306.97,22306.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','277',5528,'8','1',6593.89,6593.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','277',5529,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','277',5530,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','277',5531,'11','1',191182.01,191182.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','277',5532,'12','1',239264.14,239264.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','277',5533,'13','1',81595.36,81595.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','277',5534,'14','1',208464.65,208464.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','277',5535,'15','1',206836.01,206836.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','277',5536,'16','1',45942.09,45942.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','277',5537,'17','2',338105.83,340846.09,2740.26,2192208.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','277',5538,'18','2',21028.15,21028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','277',5539,'19','2',160198.42,160198.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','277',5540,'20','2',35318.84,35318.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','278',5541,'1','1',50359.77,50359.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','278',5542,'2','1',46857.49,46857.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','278',5543,'3','1',54494.18,54494.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','278',5544,'4','1',20822.33,20822.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','278',5545,'5','1',64181.34,64181.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','278',5546,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','278',5547,'7','1',22306.97,22306.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','278',5548,'8','1',6593.89,6593.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','278',5549,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','278',5550,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','278',5551,'11','1',191182.01,191182.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','278',5552,'12','1',239264.14,239264.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','278',5553,'13','1',81595.36,81595.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','278',5554,'14','1',208464.65,208464.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','278',5555,'15','1',206836.01,206836.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','278',5556,'16','1',45942.09,45942.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','278',5557,'17','2',340846.09,342617.09,1771.00,1416800.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','278',5558,'18','2',21028.15,21028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','278',5559,'19','2',160198.42,160198.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','278',5560,'20','2',35318.84,35318.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','279',5561,'1','1',50359.77,50359.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','279',5562,'2','1',46857.49,46857.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','279',5563,'3','1',54494.18,54494.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','279',5564,'4','1',20822.33,20822.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','279',5565,'5','1',64181.34,64181.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','279',5566,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','279',5567,'7','1',22306.97,22306.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','279',5568,'8','1',6593.89,6593.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','279',5569,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','279',5570,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','279',5571,'11','1',191182.01,191182.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','279',5572,'12','1',239264.14,239264.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','279',5573,'13','1',81595.36,81595.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','279',5574,'14','1',208464.65,208464.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','279',5575,'15','1',206836.01,206836.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','279',5576,'16','1',45942.09,45942.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','279',5577,'17','2',342617.09,344099.85,1482.76,1186208.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','279',5578,'18','2',21028.15,22360.69,1332.54,1066032.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','279',5579,'19','2',160198.42,160198.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','279',5580,'20','2',35318.84,35318.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','280',5581,'1','1',50359.77,50359.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','280',5582,'2','1',46857.49,46857.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','280',5583,'3','1',54494.18,54494.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','280',5584,'4','1',20822.33,20822.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','280',5585,'5','1',64181.34,64181.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','280',5586,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','280',5587,'7','1',22306.97,22306.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','280',5588,'8','1',6593.89,6593.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','280',5589,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','280',5590,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','280',5591,'11','1',191182.01,191182.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','280',5592,'12','1',239264.14,239264.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','280',5593,'13','1',81595.36,81595.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','280',5594,'14','1',208464.65,208464.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','280',5595,'15','1',206836.01,206836.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','280',5596,'16','1',45942.09,45942.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','280',5597,'17','2',344099.85,344099.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','280',5598,'18','2',22360.69,22360.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','280',5599,'19','2',160198.42,160198.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','280',5600,'20','2',35318.84,36977.35,1658.51,1326808.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','281',5601,'1','1',50359.77,50359.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','281',5602,'2','1',46857.49,46857.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','281',5603,'3','1',54494.18,54494.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','281',5604,'4','1',20822.33,20822.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','281',5605,'5','1',64181.34,64181.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','281',5606,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','281',5607,'7','1',22306.97,22306.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','281',5608,'8','1',6593.89,6593.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','281',5609,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','281',5610,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','281',5611,'11','1',191182.01,191182.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','281',5612,'12','1',239264.14,239264.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','281',5613,'13','1',81595.36,81595.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','281',5614,'14','1',208464.65,208464.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','281',5615,'15','1',206836.01,206836.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','281',5616,'16','1',45942.09,45942.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','281',5617,'17','2',344099.85,344400.87,301.02,240816.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','281',5618,'18','2',22360.69,23450.70,1090.01,872008.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','281',5619,'19','2',160198.42,160198.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','281',5620,'20','2',36977.35,38849.61,1872.26,1497808.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','282',5621,'1','1',50359.77,50359.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','282',5622,'2','1',46857.49,46857.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','282',5623,'3','1',54494.18,54494.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','282',5624,'4','1',20822.33,20822.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','282',5625,'5','1',64181.34,64181.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','282',5626,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','282',5627,'7','1',22306.97,22306.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','282',5628,'8','1',6593.89,6593.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','282',5629,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','282',5630,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','282',5631,'11','1',191182.01,191182.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','282',5632,'12','1',239264.14,239264.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','282',5633,'13','1',81595.36,81595.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','282',5634,'14','1',208464.65,208464.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','282',5635,'15','1',206836.01,206836.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','282',5636,'16','1',45942.09,45942.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','282',5637,'17','2',344400.87,345601.51,1200.64,960512.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','282',5638,'18','2',23450.70,23450.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','282',5639,'19','2',160198.42,160678.92,480.50,384400.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','282',5640,'20','2',38849.61,38849.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','283',5641,'1','1',50359.77,50359.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','283',5642,'2','1',46857.49,46857.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','283',5643,'3','1',54494.18,54494.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','283',5644,'4','1',20822.33,20822.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','283',5645,'5','1',64181.34,64181.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','283',5646,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','283',5647,'7','1',22306.97,22306.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','283',5648,'8','1',6593.89,6593.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','283',5649,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','283',5650,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','283',5651,'11','1',191182.01,191182.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','283',5652,'12','1',239264.14,239264.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','283',5653,'13','1',81595.36,81595.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','283',5654,'14','1',208464.65,208464.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','283',5655,'15','1',206836.01,206836.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','283',5656,'16','1',45942.09,45942.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','283',5657,'17','2',345601.51,346405.25,803.74,642992.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','283',5658,'18','2',23450.70,24050.70,600.00,480000.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','283',5659,'19','2',160678.92,161732.55,1053.63,842904.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','283',5660,'20','2',38849.61,38849.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','284',5661,'1','1',50359.77,50359.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','284',5662,'2','1',46857.49,46857.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','284',5663,'3','1',54494.18,54494.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','284',5664,'4','1',20822.33,20822.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','284',5665,'5','1',64181.34,64181.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','284',5666,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','284',5667,'7','1',22306.97,22306.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','284',5668,'8','1',6593.89,6593.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','284',5669,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','284',5670,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','284',5671,'11','1',191182.01,191182.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','284',5672,'12','1',239264.14,239264.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','284',5673,'13','1',81595.36,81595.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','284',5674,'14','1',208464.65,208464.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','284',5675,'15','1',206836.01,206836.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','284',5676,'16','1',45942.09,45942.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','284',5677,'17','2',346405.25,347801.40,1396.15,1116920.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','284',5678,'18','2',24050.70,24050.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','284',5679,'19','2',161732.55,161732.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','284',5680,'20','2',38849.61,38849.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','285',5681,'1','1',50359.77,50359.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','285',5682,'2','1',46857.49,46857.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','285',5683,'3','1',54494.18,54494.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','285',5684,'4','1',20822.33,20822.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','285',5685,'5','1',64181.34,64181.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','285',5686,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','285',5687,'7','1',22306.97,22306.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','285',5688,'8','1',6593.89,6593.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','285',5689,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','285',5690,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','285',5691,'11','1',191182.01,191182.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','285',5692,'12','1',239264.14,239264.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','285',5693,'13','1',81595.36,81595.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','285',5694,'14','1',208464.65,208464.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','285',5695,'15','1',206836.01,206836.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','285',5696,'16','1',45942.09,45942.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','285',5697,'17','2',347801.40,348516.40,715.00,572000.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','285',5698,'18','2',24050.70,25468.97,1418.27,1134616.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','285',5699,'19','2',161732.55,164307.08,2574.53,2059624.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','285',5700,'20','2',38849.61,38849.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','286',5701,'1','1',50359.77,50359.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','286',5702,'2','1',46857.49,46857.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','286',5703,'3','1',54494.18,54494.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','286',5704,'4','1',20822.33,20822.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','286',5705,'5','1',64181.34,64181.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','286',5706,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','286',5707,'7','1',22306.97,22306.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','286',5708,'8','1',6593.89,6593.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','286',5709,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','286',5710,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','286',5711,'11','1',191182.01,191182.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','286',5712,'12','1',239264.14,242380.79,3116.65,623330.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','286',5713,'13','1',81595.36,84328.45,2733.09,546618.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','286',5714,'14','1',208464.65,210997.49,2532.84,506568.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','286',5715,'15','1',206836.01,206836.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','286',5716,'16','1',45942.09,45942.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','286',5717,'17','2',348516.40,348516.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','286',5718,'18','2',25468.97,25468.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','286',5719,'19','2',164307.08,166755.46,2448.38,1958704.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','286',5720,'20','2',38849.61,38849.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','287',5721,'1','1',50359.77,50359.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','287',5722,'2','1',46857.49,46857.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','287',5723,'3','1',54494.18,54494.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','287',5724,'4','1',20822.33,20822.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','287',5725,'5','1',64181.34,64181.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','287',5726,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','287',5727,'7','1',22306.97,22306.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','287',5728,'8','1',6593.89,6593.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','287',5729,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','287',5730,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','287',5731,'11','1',191182.01,196061.67,4879.66,975932.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','287',5732,'12','1',242380.79,244105.17,1722.35,344470.00,0.00,0.00,2.03,0.00,0.00),('1','294','2','287',5733,'13','1',84328.45,86653.43,2324.98,464996.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','287',5734,'14','1',210997.49,210997.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','287',5735,'15','1',206836.01,212855.57,6019.56,1203912.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','287',5736,'16','1',45942.09,45942.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','287',5737,'17','2',348516.40,348862.07,345.67,276536.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','287',5738,'18','2',25468.97,27196.53,1727.56,1382048.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','287',5739,'19','2',166755.46,169393.04,2637.58,2110064.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','287',5740,'20','2',38849.61,38849.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','288',5741,'1','1',50359.77,50359.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','288',5742,'2','1',46857.49,46857.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','288',5743,'3','1',54494.18,54494.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','288',5744,'4','1',20822.33,20822.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','288',5745,'5','1',64181.34,64181.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','288',5746,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','288',5747,'7','1',22306.97,22306.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','288',5748,'8','1',6593.89,6916.34,322.45,64490.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','288',5749,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','288',5750,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','288',5751,'11','1',196061.67,197754.20,1692.53,338506.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','288',5752,'12','1',244105.17,246295.98,2190.81,438162.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','288',5753,'13','1',86653.43,89123.34,2469.91,493982.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','288',5754,'14','1',210997.49,212134.50,1137.01,227402.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','288',5755,'15','1',212855.57,214946.02,2090.45,418090.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','288',5756,'16','1',45942.09,45942.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','288',5757,'17','2',348862.07,350392.35,1530.28,1224224.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','288',5758,'18','2',27196.53,27196.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','288',5759,'19','2',169393.04,169393.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','288',5760,'20','2',38849.61,40154.63,1305.02,1044016.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','289',5761,'1','1',50359.77,51100.42,740.65,148130.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','289',5762,'2','1',46857.49,47005.19,147.70,29540.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','289',5763,'3','1',54494.18,55038.50,544.32,108864.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','289',5764,'4','1',20822.33,21444.16,621.83,124366.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','289',5765,'5','1',64181.34,65266.06,1084.72,216944.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','289',5766,'6','1',8775.59,8775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','289',5767,'7','1',22306.97,23726.86,1419.89,283978.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','289',5768,'8','1',6916.34,6916.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','289',5769,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','289',5770,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','289',5771,'11','1',197754.20,197754.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','289',5772,'12','1',246295.98,246295.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','289',5773,'13','1',89123.34,89123.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','289',5774,'14','1',212134.50,212134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','289',5775,'15','1',214946.02,214946.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','289',5776,'16','1',45942.09,45942.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','289',5777,'17','2',350392.35,350392.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','289',5778,'18','2',27196.53,27196.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','289',5779,'19','2',169393.04,169393.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','289',5780,'20','2',40154.63,40154.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','290',5781,'1','1',51100.42,52824.20,1723.78,344756.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','290',5782,'2','1',47005.19,48443.36,1438.17,287634.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','290',5783,'3','1',55038.50,57486.83,2448.33,489666.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','290',5784,'4','1',21444.16,21444.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','290',5785,'5','1',65266.06,67205.69,1939.63,387926.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','290',5786,'6','1',8775.59,10612.45,1836.86,367372.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','290',5787,'7','1',23726.86,26277.31,2550.45,510090.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','290',5788,'8','1',6916.34,6916.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','290',5789,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','290',5790,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','290',5791,'11','1',197754.20,197754.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','290',5792,'12','1',246295.98,246295.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','290',5793,'13','1',89123.34,89123.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','290',5794,'14','1',212134.50,212134.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','290',5795,'15','1',214946.02,214946.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','290',5796,'16','1',45942.09,45942.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','290',5797,'17','2',350392.35,350392.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','290',5798,'18','2',27196.53,27196.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','290',5799,'19','2',169393.04,169393.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','290',5800,'20','2',40154.63,40154.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','291',5801,'1','1',52824.20,52824.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','291',5802,'2','1',48443.36,48443.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','291',5803,'3','1',57486.83,57486.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','291',5804,'4','1',21444.16,21444.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','291',5805,'5','1',67205.69,67205.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','291',5806,'6','1',10612.45,10612.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','291',5807,'7','1',26277.31,26277.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','291',5808,'8','1',6916.34,6916.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','291',5809,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','291',5810,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','291',5811,'11','1',197754.20,200518.52,2764.32,552864.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','291',5812,'12','1',246295.98,248956.98,2661.00,532200.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','291',5813,'13','1',89123.34,92140.81,3017.47,603494.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','291',5814,'14','1',212134.50,213450.61,1316.11,263222.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','291',5815,'15','1',214946.02,217094.67,2148.65,429730.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','291',5816,'16','1',45942.09,45942.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','291',5817,'17','2',350392.35,350392.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','291',5818,'18','2',27196.53,27196.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','291',5819,'19','2',169393.04,169393.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','291',5820,'20','2',40154.63,40154.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','292',5821,'1','1',52824.20,52824.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','292',5822,'2','1',48443.36,48443.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','292',5823,'3','1',57486.83,57486.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','292',5824,'4','1',21444.16,21444.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','292',5825,'5','1',67205.69,67205.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','292',5826,'6','1',10612.45,10612.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','292',5827,'7','1',26277.31,26277.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','292',5828,'8','1',6916.34,6916.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','292',5829,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','292',5830,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','292',5831,'11','1',200518.52,201560.64,1042.12,208424.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','292',5832,'12','1',248956.98,252392.60,3435.62,687124.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','292',5833,'13','1',92140.81,93662.86,1522.05,304410.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','292',5834,'14','1',213450.61,215179.08,1728.47,345694.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','292',5835,'15','1',217094.67,218988.89,1894.22,378844.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','292',5836,'16','1',45942.09,45942.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','292',5837,'17','2',350392.35,350392.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','292',5838,'18','2',27196.53,27196.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','292',5839,'19','2',169393.04,169393.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','292',5840,'20','2',40154.63,40154.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','293',5841,'1','1',52824.20,52824.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','293',5842,'2','1',48443.36,48443.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','293',5843,'3','1',57486.83,57486.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','293',5844,'4','1',21444.16,21444.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','293',5845,'5','1',67205.69,67205.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','293',5846,'6','1',10612.45,10612.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','293',5847,'7','1',26277.31,26277.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','293',5848,'8','1',6916.34,6916.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','293',5849,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','293',5850,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','293',5851,'11','1',201560.64,204286.11,2725.47,545094.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','293',5852,'12','1',252392.60,253922.65,1530.05,306010.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','293',5853,'13','1',93662.86,95538.88,1876.02,375204.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','293',5854,'14','1',215179.08,216356.51,1177.43,235486.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','293',5855,'15','1',218988.89,221946.48,2957.59,591518.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','293',5856,'16','1',45942.09,45942.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','293',5857,'17','2',350392.35,350392.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','293',5858,'18','2',27196.53,27196.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','293',5859,'19','2',169393.04,169393.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','293',5860,'20','2',40154.63,40154.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','294',5861,'1','1',52824.20,54365.90,1541.70,308340.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','294',5862,'2','1',48443.36,48494.54,51.18,10236.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','294',5863,'3','1',57486.83,59493.16,2006.33,401266.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','294',5864,'4','1',21444.16,21444.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','294',5865,'5','1',67205.69,68741.49,1535.80,307160.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','294',5866,'6','1',10612.45,10612.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','294',5867,'7','1',26277.31,27771.10,1481.29,296258.00,0.00,0.00,12.50,0.00,0.00),('1','294','1','294',5868,'8','1',6916.34,6916.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','294',5869,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','294',5870,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','294',5871,'11','1',204286.11,204286.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','294',5872,'12','1',253922.65,253922.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','294',5873,'13','1',95538.88,95538.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','294',5874,'14','1',216356.51,216356.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','294',5875,'15','1',221946.48,221946.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','294',5876,'16','1',45942.09,45942.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','294',5877,'17','2',350392.35,350392.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','294',5878,'18','2',27196.53,27196.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','294',5879,'19','2',169393.04,169393.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','294',5880,'20','2',40154.63,40154.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','295',5881,'1','1',54365.90,58008.97,3643.07,728614.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','295',5882,'2','1',48494.54,48494.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','295',5883,'3','1',59493.16,62183.88,2690.72,538144.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','295',5884,'4','1',21444.16,21448.16,0.00,0.00,0.00,0.00,4.00,0.00,0.00),('1','294','1','295',5885,'5','1',68741.49,72208.06,3466.57,693314.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','295',5886,'6','1',10612.45,10612.48,0.03,6.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','295',5887,'7','1',27771.10,29358.30,1587.20,317440.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','295',5888,'8','1',6916.34,6916.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','295',5889,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','295',5890,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','295',5891,'11','1',204286.11,205081.24,795.13,159026.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','295',5892,'12','1',253922.65,254939.06,1016.41,203282.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','295',5893,'13','1',95538.88,96668.12,1129.24,225848.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','295',5894,'14','1',216356.51,216356.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','295',5895,'15','1',221946.48,222650.51,704.03,140806.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','295',5896,'16','1',45942.09,45942.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','295',5897,'17','2',350392.35,351519.59,1127.24,901792.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','295',5898,'18','2',27196.53,27196.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','295',5899,'19','2',169393.04,169393.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','295',5900,'20','2',40154.63,40154.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','296',5901,'1','1',58008.97,58008.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','296',5902,'2','1',48494.54,48494.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','296',5903,'3','1',62183.88,62183.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','296',5904,'4','1',21448.16,21448.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','296',5905,'5','1',72208.06,72208.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','296',5906,'6','1',10612.48,10612.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','296',5907,'7','1',29358.30,29358.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','296',5908,'8','1',6916.34,6916.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','296',5909,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','296',5910,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','296',5911,'11','1',205081.24,207581.64,2500.40,500080.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','296',5912,'12','1',254939.06,255762.65,823.59,164718.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','296',5913,'13','1',96668.12,97731.55,1063.43,212686.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','296',5914,'14','1',216356.51,218335.84,1979.33,395866.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','296',5915,'15','1',222650.51,223790.31,1139.80,227960.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','296',5916,'16','1',45942.09,46255.61,313.52,62704.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','296',5917,'17','2',351519.59,355357.91,3838.32,3070656.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','296',5918,'18','2',27196.53,27196.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','296',5919,'19','2',169393.04,169393.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','296',5920,'20','2',40154.63,40154.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','297',5921,'1','1',58008.97,58008.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','297',5922,'2','1',48494.54,48494.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','297',5923,'3','1',62183.88,62183.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','297',5924,'4','1',21448.16,21448.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','297',5925,'5','1',72208.06,72208.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','297',5926,'6','1',10612.48,10612.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','297',5927,'7','1',29358.30,29358.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','297',5928,'8','1',6916.34,6916.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','297',5929,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','297',5930,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','297',5931,'11','1',207581.64,210695.56,3113.92,622784.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','297',5932,'12','1',255762.65,255762.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','297',5933,'13','1',97731.55,100111.06,2379.51,475902.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','297',5934,'14','1',218335.84,218614.90,279.06,55812.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','297',5935,'15','1',223790.31,226524.67,2725.36,545072.00,0.00,0.00,9.00,0.00,0.00),('1','294','2','297',5936,'16','1',46255.61,46255.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','297',5937,'17','2',355357.91,356894.16,1536.25,1229000.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','297',5938,'18','2',27196.53,27196.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','297',5939,'19','2',169393.04,171171.18,1778.14,1422512.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','297',5940,'20','2',40154.63,40154.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','298',5941,'1','1',58008.97,58008.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','298',5942,'2','1',48494.54,48494.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','298',5943,'3','1',62183.88,62183.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','298',5944,'4','1',21448.16,21448.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','298',5945,'5','1',72208.06,72208.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','298',5946,'6','1',10612.48,10612.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','298',5947,'7','1',29358.30,29358.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','298',5948,'8','1',6916.34,6916.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','298',5949,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','298',5950,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','298',5951,'11','1',210695.56,210695.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','298',5952,'12','1',255762.65,255762.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','298',5953,'13','1',100111.06,100111.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','298',5954,'14','1',218614.90,218614.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','298',5955,'15','1',226524.67,226524.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','298',5956,'16','1',46255.61,46255.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','298',5957,'17','2',356894.16,360362.29,3468.13,2774504.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','298',5958,'18','2',27196.53,27196.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','298',5959,'19','2',171171.18,172064.93,893.75,715000.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','298',5960,'20','2',40154.63,40404.63,250.00,200000.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','299',5961,'1','1',58008.97,58008.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','299',5962,'2','1',48494.54,48494.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','299',5963,'3','1',62183.88,62183.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','299',5964,'4','1',21448.16,21448.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','299',5965,'5','1',72208.06,72208.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','299',5966,'6','1',10612.48,10612.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','299',5967,'7','1',29358.30,29358.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','299',5968,'8','1',6916.34,6916.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','299',5969,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','299',5970,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','299',5971,'11','1',210695.56,210695.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','299',5972,'12','1',255762.65,255762.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','299',5973,'13','1',100111.06,100111.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','299',5974,'14','1',218614.90,218614.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','299',5975,'15','1',226524.67,226524.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','299',5976,'16','1',46255.61,46255.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','299',5977,'17','2',360362.29,361547.16,1184.87,947896.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','299',5978,'18','2',27196.53,27196.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','299',5979,'19','2',172064.93,172784.31,719.38,575504.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','299',5980,'20','2',40404.63,40404.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','300',5981,'1','1',58008.97,58008.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','300',5982,'2','1',48494.54,48494.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','300',5983,'3','1',62183.88,62183.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','300',5984,'4','1',21448.16,21448.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','300',5985,'5','1',72208.06,72208.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','300',5986,'6','1',10612.48,10612.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','300',5987,'7','1',29358.30,29358.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','300',5988,'8','1',6916.34,6916.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','300',5989,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','300',5990,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','300',5991,'11','1',210695.56,210695.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','300',5992,'12','1',255762.65,255762.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','300',5993,'13','1',100111.06,100111.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','300',5994,'14','1',218614.90,218614.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','300',5995,'15','1',226524.67,226524.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','300',5996,'16','1',46255.61,46255.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','300',5997,'17','2',361547.16,361797.16,250.00,200000.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','300',5998,'18','2',27196.53,27196.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','300',5999,'19','2',172784.31,172896.43,112.12,89696.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','300',6000,'20','2',40404.63,40404.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','301',6001,'1','1',58008.97,58008.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','301',6002,'2','1',48494.54,48494.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','301',6003,'3','1',62183.88,62183.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','301',6004,'4','1',21448.16,21448.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','301',6005,'5','1',72208.06,72208.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','301',6006,'6','1',10612.48,10612.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','301',6007,'7','1',29358.30,29358.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','301',6008,'8','1',6916.34,6916.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','301',6009,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','301',6010,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','301',6011,'11','1',210695.56,216290.90,5595.34,1119068.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','301',6012,'12','1',255762.65,260424.05,4661.40,932280.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','301',6013,'13','1',100111.06,104641.98,4530.92,906184.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','301',6014,'14','1',218614.90,221894.69,3279.79,655958.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','301',6015,'15','1',226524.67,230066.60,3541.93,708386.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','301',6016,'16','1',46255.61,46255.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','301',6017,'17','2',361797.16,361797.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','301',6018,'18','2',27196.53,27196.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','301',6019,'19','2',172896.43,172896.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','301',6020,'20','2',40404.63,40404.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','302',6021,'1','1',58008.97,58008.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','302',6022,'2','1',48494.54,48494.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','302',6023,'3','1',62183.88,62183.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','302',6024,'4','1',21448.16,21448.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','302',6025,'5','1',72208.06,72208.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','302',6026,'6','1',10612.48,10612.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','302',6027,'7','1',29358.30,29358.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','302',6028,'8','1',6916.34,6916.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','302',6029,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','302',6030,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','302',6031,'11','1',216290.90,217246.57,955.67,191134.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','302',6032,'12','1',260424.05,263337.59,2913.54,582708.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','302',6033,'13','1',104641.98,105871.00,1229.02,245804.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','302',6034,'14','1',221894.69,221894.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','302',6035,'15','1',230066.60,233451.79,3385.19,677038.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','302',6036,'16','1',46255.61,46255.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','302',6037,'17','2',361797.16,361797.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','302',6038,'18','2',27196.53,27196.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','302',6039,'19','2',172896.43,172896.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','302',6040,'20','2',40404.63,40404.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','303',6041,'1','1',58008.97,58008.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','303',6042,'2','1',48494.54,48494.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','303',6043,'3','1',62183.88,62183.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','303',6044,'4','1',21448.16,21448.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','303',6045,'5','1',72208.06,72208.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','303',6046,'6','1',10612.48,10612.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','303',6047,'7','1',29358.30,29358.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','303',6048,'8','1',6916.34,6916.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','303',6049,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','303',6050,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','303',6051,'11','1',217246.57,220610.46,3341.39,668278.00,0.00,0.00,22.50,0.00,0.00),('1','294','2','303',6052,'12','1',263337.59,266293.71,2956.12,591224.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','303',6053,'13','1',105871.00,108048.58,2177.58,435516.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','303',6054,'14','1',221894.69,224022.31,2127.62,425524.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','303',6055,'15','1',233451.79,236318.68,2866.89,573378.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','303',6056,'16','1',46255.61,47329.90,1074.29,214858.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','303',6057,'17','2',361797.16,361797.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','303',6058,'18','2',27196.53,27196.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','303',6059,'19','2',172896.43,172896.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','303',6060,'20','2',40404.63,40404.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','304',6061,'1','1',58008.97,58008.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','304',6062,'2','1',48494.54,48494.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','304',6063,'3','1',62183.88,62183.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','304',6064,'4','1',21448.16,21448.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','304',6065,'5','1',72208.06,72208.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','304',6066,'6','1',10612.48,10612.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','304',6067,'7','1',29358.30,29358.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','1','304',6068,'8','1',6916.34,6916.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','304',6069,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','304',6070,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','304',6071,'11','1',220610.46,220610.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','304',6072,'12','1',266293.71,266293.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','304',6073,'13','1',108048.58,108048.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','304',6074,'14','1',224022.31,224022.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','304',6075,'15','1',236318.68,236318.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','2','304',6076,'16','1',47329.90,47329.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','304',6077,'17','2',361797.16,362351.54,554.38,443504.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','304',6078,'18','2',27196.53,27196.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','304',6079,'19','2',172896.43,173270.18,373.75,299000.00,0.00,0.00,0.00,0.00,0.00),('1','294','3','304',6080,'20','2',40404.63,40404.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=609 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','294','1','2',755.00,755.00,0.00,0.00,0.00,0.00,0.00,1),('1','294','1','1',175.00,175.00,651.69,0.00,0.00,0.00,0.00,2),('1','294','2','2',755.00,755.00,1197.36,0.00,0.00,0.00,0.00,3),('1','294','2','1',175.00,175.00,3669.25,0.00,0.00,0.00,0.00,4),('1','294','3','2',755.00,755.00,283.82,0.00,0.00,0.00,0.00,5),('1','294','3','1',175.00,175.00,1072.89,0.00,0.00,0.00,0.00,6),('1','294','4','2',755.00,755.00,1739.82,0.00,0.00,0.00,0.00,7),('1','294','4','1',175.00,175.00,8404.37,0.00,0.00,0.00,0.00,8),('1','294','5','2',755.00,755.00,133.03,0.00,0.00,0.00,0.00,9),('1','294','5','1',175.00,175.00,1683.73,0.00,0.00,0.00,0.00,10),('1','294','6','2',755.00,755.00,0.00,0.00,0.00,0.00,0.00,11),('1','294','6','1',175.00,175.00,-45.00,0.00,0.00,0.00,0.00,12),('1','294','7','2',755.00,755.00,3238.70,0.00,0.00,0.00,0.00,13),('1','294','7','1',175.00,175.00,9034.85,0.00,0.00,0.00,0.00,14),('1','294','8','2',755.00,755.00,0.00,0.00,0.00,0.00,0.00,15),('1','294','8','1',175.00,175.00,1458.00,0.00,0.00,0.00,0.00,16),('1','294','9','2',755.00,755.00,2433.13,0.00,0.00,0.00,0.00,17),('1','294','9','1',175.00,175.00,9645.86,0.00,0.00,0.00,0.00,18),('1','294','10','2',755.00,755.00,602.48,0.00,0.00,0.00,0.00,19),('1','294','10','1',175.00,175.00,1698.85,0.00,0.00,0.00,0.00,20),('1','294','11','2',755.00,755.00,948.74,0.00,0.00,0.00,0.00,21),('1','294','11','1',175.00,175.00,4546.89,0.00,0.00,0.00,0.00,22),('1','294','12','2',755.00,755.00,745.46,0.00,0.00,0.00,0.00,23),('1','294','12','1',175.00,175.00,5474.44,0.00,0.00,0.00,0.00,24),('1','294','13','2',755.00,755.00,788.76,0.00,0.00,0.00,0.00,25),('1','294','13','1',175.00,175.00,5151.65,0.00,0.00,0.00,0.00,26),('1','294','14','2',755.00,755.00,805.62,0.00,0.00,0.00,0.00,27),('1','294','14','1',175.00,175.00,5551.48,0.00,0.00,0.00,0.00,28),('1','294','15','2',755.00,755.00,989.34,0.00,0.00,0.00,0.00,29),('1','294','15','1',175.00,175.00,4506.94,0.00,0.00,0.00,0.00,30),('1','294','16','2',755.00,755.00,1417.28,0.00,0.00,0.00,0.00,31),('1','294','16','1',175.00,175.00,5651.85,0.00,0.00,0.00,0.00,32),('1','294','17','2',755.00,755.00,805.17,0.00,0.00,0.00,0.00,33),('1','294','17','1',175.00,175.00,7108.62,0.00,0.00,0.00,0.00,34),('1','294','18','2',755.00,755.00,1855.18,0.00,0.00,0.00,0.00,35),('1','294','18','1',175.00,175.00,7583.61,0.00,0.00,0.00,0.00,36),('1','294','19','2',755.00,755.00,600.97,0.00,0.00,0.00,0.00,37),('1','294','19','1',175.00,175.00,7175.25,0.00,0.00,0.00,0.00,38),('1','294','20','2',755.00,755.00,1678.24,0.00,0.00,0.00,0.00,39),('1','294','20','1',175.00,175.00,8465.20,0.00,0.00,0.00,0.00,40),('1','294','21','2',755.00,755.00,355.50,0.00,0.00,0.00,0.00,41),('1','294','21','1',175.00,175.00,6382.65,0.00,0.00,0.00,0.00,42),('1','294','22','2',755.00,755.00,1475.34,0.00,0.00,0.00,0.00,43),('1','294','22','1',175.00,175.00,5703.61,0.00,0.00,0.00,0.00,44),('1','294','23','2',755.00,755.00,476.00,0.00,0.00,0.00,0.00,45),('1','294','23','1',175.00,175.00,5803.00,0.00,0.00,0.00,0.00,46),('1','294','24','2',755.00,755.00,417.60,0.00,0.00,0.00,0.00,47),('1','294','24','1',175.00,175.00,7648.89,0.00,0.00,0.00,0.00,48),('1','294','25','2',755.00,755.00,923.90,0.00,0.00,0.00,0.00,49),('1','294','25','1',175.00,175.00,6220.51,0.00,0.00,0.00,0.00,50),('1','294','26','2',755.00,755.00,447.67,0.00,0.00,0.00,0.00,51),('1','294','26','1',175.00,175.00,6702.26,0.00,0.00,0.00,0.00,52),('1','294','27','2',755.00,755.00,306.86,0.00,0.00,0.00,0.00,53),('1','294','27','1',175.00,175.00,6986.58,0.00,0.00,0.00,0.00,54),('1','294','28','2',755.00,755.00,1880.46,0.00,0.00,0.00,0.00,55),('1','294','28','1',175.00,175.00,6582.58,0.00,0.00,0.00,0.00,56),('1','294','29','2',755.00,755.00,1443.16,0.00,0.00,0.00,0.00,57),('1','294','29','1',175.00,175.00,596.34,0.00,0.00,0.00,0.00,58),('1','294','30','2',755.00,755.00,2032.74,0.00,0.00,0.00,0.00,59),('1','294','30','1',175.00,175.00,2055.10,0.00,0.00,0.00,0.00,60),('1','294','31','2',755.00,755.00,1464.98,0.00,0.00,0.00,0.00,61),('1','294','31','1',175.00,175.00,5607.38,0.00,0.00,0.00,0.00,62),('1','294','32','2',755.00,755.00,552.04,0.00,0.00,0.00,0.00,63),('1','294','32','1',175.00,175.00,8904.43,0.00,0.00,0.00,0.00,64),('1','294','33','2',755.00,755.00,1190.97,0.00,0.00,0.00,0.00,65),('1','294','33','1',175.00,175.00,7156.81,0.00,0.00,0.00,0.00,66),('1','294','34','2',755.00,755.00,1112.01,0.00,0.00,0.00,0.00,67),('1','294','34','1',175.00,175.00,10177.11,0.00,0.00,0.00,0.00,68),('1','294','35','2',755.00,755.00,370.27,0.00,0.00,0.00,0.00,69),('1','294','35','1',175.00,175.00,6969.91,0.00,0.00,0.00,0.00,70),('1','294','36','2',755.00,755.00,1490.78,0.00,0.00,0.00,0.00,71),('1','294','36','1',175.00,175.00,8744.45,0.00,0.00,0.00,0.00,72),('1','294','37','2',755.00,755.00,371.95,0.00,0.00,0.00,0.00,73),('1','294','37','1',175.00,175.00,7219.06,0.00,0.00,0.00,0.00,74),('1','294','38','2',755.00,755.00,1991.76,0.00,0.00,0.00,0.00,75),('1','294','38','1',175.00,175.00,7835.41,0.00,0.00,0.00,0.00,76),('1','294','39','2',755.00,755.00,1644.41,0.00,0.00,0.00,0.00,77),('1','294','39','1',175.00,175.00,4477.63,0.00,0.00,0.00,0.00,78),('1','294','40','2',755.00,755.00,928.42,0.00,0.00,0.00,0.00,79),('1','294','40','1',175.00,175.00,9520.40,0.00,0.00,0.00,0.00,80),('1','294','41','2',755.00,755.00,1298.08,0.00,0.00,0.00,0.00,81),('1','294','41','1',175.00,175.00,6784.28,0.00,0.00,0.00,0.00,82),('1','294','42','2',755.00,755.00,1887.10,0.00,0.00,0.00,0.00,83),('1','294','42','1',175.00,175.00,10568.14,0.00,0.00,0.00,0.00,84),('1','294','43','2',755.00,755.00,403.67,0.00,0.00,0.00,0.00,85),('1','294','43','1',175.00,175.00,2022.45,0.00,0.00,0.00,0.00,86),('1','294','44','2',755.00,755.00,0.00,0.00,0.00,0.00,0.00,87),('1','294','44','1',175.00,175.00,5546.44,0.00,0.00,0.00,0.00,88),('1','294','45','2',755.00,770.00,0.00,0.00,0.00,0.00,0.00,89),('1','294','45','1',175.00,178.00,2445.74,0.00,0.00,0.00,0.00,90),('1','294','46','1',178.00,178.00,11075.44,0.00,0.00,0.00,0.00,91),('1','294','46','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,92),('1','294','47','1',178.00,178.00,7915.85,0.00,0.00,0.00,0.00,93),('1','294','47','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,94),('1','294','48','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,95),('1','294','48','1',178.00,178.00,9580.04,0.00,0.00,0.00,0.00,96),('1','294','49','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,97),('1','294','49','1',178.00,178.00,6684.09,0.00,0.00,0.00,0.00,98),('1','294','50','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,99),('1','294','50','1',178.00,178.00,8382.63,0.00,0.00,0.00,0.00,100),('1','294','51','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,101),('1','294','51','1',178.00,178.00,6577.34,0.00,0.00,0.00,0.00,102),('1','294','52','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,103),('1','294','52','1',178.00,178.00,8607.51,0.00,0.00,0.00,0.00,104),('1','294','53','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,105),('1','294','53','1',178.00,178.00,7344.04,0.00,0.00,0.00,0.00,106),('1','294','54','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,107),('1','294','54','1',178.00,178.00,8355.85,0.00,0.00,0.00,0.00,108),('1','294','55','2',770.00,770.00,2076.53,0.00,0.00,0.00,0.00,109),('1','294','55','1',178.00,178.00,5816.72,0.00,0.00,0.00,0.00,110),('1','294','56','2',770.00,770.00,1959.36,0.00,0.00,0.00,0.00,111),('1','294','56','1',178.00,178.00,7466.10,0.00,0.00,0.00,0.00,112),('1','294','57','2',770.00,770.00,349.36,0.00,0.00,0.00,0.00,113),('1','294','57','1',178.00,178.00,6368.21,0.00,0.00,0.00,0.00,114),('1','294','58','2',780.00,780.00,567.97,0.00,0.00,0.00,0.00,115),('1','294','58','1',178.00,178.00,0.00,0.00,0.00,0.00,0.00,116),('1','294','59','2',780.00,780.00,1688.07,0.00,0.00,0.00,0.00,117),('1','294','59','1',178.00,178.00,7172.13,0.00,0.00,0.00,0.00,118),('1','294','60','2',780.00,780.00,703.85,0.00,0.00,0.00,0.00,119),('1','294','60','1',178.00,178.00,6093.34,0.00,0.00,0.00,0.00,120),('1','294','61','2',780.00,780.00,3031.28,0.00,0.00,0.00,0.00,121),('1','294','61','1',178.00,178.00,6958.96,0.00,0.00,0.00,0.00,122),('1','294','62','2',780.00,780.00,0.00,0.00,0.00,0.00,0.00,123),('1','294','62','1',178.00,178.00,0.00,0.00,0.00,0.00,0.00,124),('1','294','63','2',780.00,780.00,1423.99,0.00,0.00,0.00,0.00,125),('1','294','63','1',175.00,178.00,5652.20,0.00,0.00,0.00,0.00,126),('1','294','64','2',780.00,780.00,1086.26,0.00,0.00,0.00,0.00,127),('1','294','64','1',175.00,178.00,6722.20,0.00,0.00,0.00,0.00,128),('1','294','65','2',780.00,780.00,1909.76,0.00,0.00,0.00,0.00,129),('1','294','65','1',175.00,178.00,0.00,0.00,0.00,0.00,0.00,130),('1','294','66','2',780.00,780.00,1462.26,0.00,0.00,0.00,0.00,131),('1','294','66','1',175.00,178.00,0.00,0.00,0.00,0.00,0.00,132),('1','294','67','2',780.00,780.00,230.77,0.00,0.00,0.00,0.00,133),('1','294','67','1',175.00,178.00,0.00,0.00,0.00,0.00,0.00,134),('1','294','68','2',780.00,780.00,767.71,0.00,0.00,0.00,0.00,135),('1','294','68','1',175.00,178.00,4929.15,0.00,0.00,0.00,0.00,136),('1','294','69','2',780.00,780.00,401.54,0.00,0.00,0.00,0.00,137),('1','294','69','1',175.00,178.00,5376.12,0.00,0.00,0.00,0.00,138),('1','294','70','2',780.00,780.00,1684.38,0.00,0.00,0.00,0.00,139),('1','294','70','1',175.00,178.00,8413.40,0.00,0.00,0.00,0.00,140),('1','294','71','2',780.00,780.00,620.14,0.00,0.00,0.00,0.00,141),('1','294','71','1',175.00,178.00,6312.68,0.00,0.00,0.00,0.00,142),('1','294','72','2',780.00,780.00,373.58,0.00,0.00,0.00,0.00,143),('1','294','72','1',175.00,178.00,8296.86,0.00,0.00,0.00,0.00,144),('1','294','73','2',780.00,780.00,0.00,0.00,0.00,0.00,0.00,145),('1','294','73','1',175.00,178.00,6615.31,0.00,0.00,0.00,0.00,146),('1','294','74','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,147),('1','294','74','1',175.00,178.00,7998.80,0.00,0.00,0.00,0.00,148),('1','294','75','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,149),('1','294','75','1',175.00,178.00,6387.51,0.00,0.00,0.00,0.00,150),('1','294','76','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,151),('1','294','76','1',175.00,178.00,5949.83,0.00,0.00,0.00,0.00,152),('1','294','77','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,153),('1','294','77','1',178.00,178.00,0.00,0.00,0.00,0.00,0.00,154),('1','294','78','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,155),('1','294','78','1',178.00,178.00,0.00,0.00,0.00,0.00,0.00,156),('1','294','79','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,157),('1','294','79','1',178.00,178.00,0.00,0.00,0.00,0.00,0.00,158),('1','294','80','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,159),('1','294','80','1',178.00,178.00,4557.78,0.00,0.00,0.00,0.00,160),('1','294','81','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,161),('1','294','81','1',178.00,178.00,8768.13,0.00,0.00,0.00,0.00,162),('1','294','82','2',800.00,800.00,2708.02,0.00,0.00,0.00,0.00,163),('1','294','82','1',178.00,178.00,10387.85,0.00,0.00,0.00,0.00,164),('1','294','83','2',800.00,800.00,2295.18,0.00,0.00,0.00,0.00,165),('1','294','83','1',178.00,178.00,9938.13,0.00,0.00,0.00,0.00,166),('1','294','84','2',800.00,800.00,1447.12,0.00,0.00,0.00,0.00,167),('1','294','84','1',178.00,178.00,9641.12,0.00,0.00,0.00,0.00,168),('1','294','85','2',800.00,800.00,1137.05,0.00,0.00,0.00,0.00,169),('1','294','85','1',178.00,178.00,9024.40,0.00,0.00,0.00,0.00,170),('1','294','86','2',800.00,800.00,917.01,0.00,0.00,0.00,0.00,171),('1','294','86','1',178.00,178.00,7802.35,0.00,0.00,0.00,0.00,172),('1','294','87','2',800.00,800.00,1130.06,0.00,0.00,0.00,0.00,173),('1','294','87','1',178.00,178.00,87.56,0.00,0.00,0.00,0.00,174),('1','294','88','2',800.00,800.00,837.67,0.00,0.00,0.00,0.00,175),('1','294','88','1',178.00,178.00,0.00,0.00,0.00,0.00,0.00,176),('1','294','89','2',800.00,800.00,1150.50,0.00,0.00,0.00,0.00,177),('1','294','89','1',178.00,178.00,0.00,0.00,0.00,0.00,0.00,178),('1','294','90','2',800.00,800.00,1762.85,0.00,0.00,0.00,0.00,179),('1','294','90','1',178.00,178.00,0.00,0.00,0.00,0.00,0.00,180),('1','294','91','2',800.00,800.00,395.25,0.00,0.00,0.00,0.00,181),('1','294','91','1',178.00,178.00,0.00,0.00,0.00,0.00,0.00,182),('1','294','92','2',800.00,800.00,1006.11,0.00,0.00,0.00,0.00,183),('1','294','92','1',178.00,178.00,0.00,0.00,0.00,0.00,0.00,184),('1','294','93','2',800.00,800.00,1170.45,0.00,0.00,0.00,0.00,185),('1','294','93','1',178.00,178.00,0.00,0.00,0.00,0.00,0.00,186),('1','294','94','2',800.00,800.00,1693.25,0.00,0.00,0.00,0.00,187),('1','294','94','1',178.00,178.00,0.00,0.00,0.00,0.00,0.00,188),('1','294','95','2',800.00,800.00,1303.96,0.00,0.00,0.00,0.00,189),('1','294','95','1',178.00,178.00,0.00,0.00,0.00,0.00,0.00,190),('1','294','96','2',800.00,800.00,1878.68,0.00,0.00,0.00,0.00,191),('1','294','96','1',178.00,178.00,0.00,0.00,0.00,0.00,0.00,192),('1','294','97','2',800.00,800.00,1131.00,0.00,0.00,0.00,0.00,193),('1','294','97','1',178.00,178.00,0.00,0.00,0.00,0.00,0.00,194),('1','294','98','2',800.00,800.00,3119.87,0.00,0.00,0.00,0.00,195),('1','294','98','1',178.00,178.00,0.00,0.00,0.00,0.00,0.00,196),('1','294','99','2',800.00,800.00,1600.14,0.00,0.00,0.00,0.00,197),('1','294','99','1',178.00,178.00,0.00,0.00,0.00,0.00,0.00,198),('1','294','100','2',800.00,800.00,2594.19,0.00,0.00,0.00,0.00,199),('1','294','100','1',178.00,178.00,0.00,0.00,0.00,0.00,0.00,200),('1','294','101','2',800.00,800.00,2807.44,0.00,0.00,0.00,0.00,201),('1','294','101','1',178.00,178.00,0.00,0.00,0.00,0.00,0.00,202),('1','294','102','2',800.00,800.00,759.00,0.00,0.00,0.00,0.00,203),('1','294','102','1',178.00,178.00,0.00,0.00,0.00,0.00,0.00,204),('1','294','103','2',800.00,800.00,1838.36,0.00,0.00,0.00,0.00,205),('1','294','103','1',178.00,178.00,0.00,0.00,0.00,0.00,0.00,206),('1','294','104','2',800.00,800.00,398.25,0.00,0.00,0.00,0.00,207),('1','294','104','1',178.00,178.00,0.00,0.00,0.00,0.00,0.00,208),('1','294','105','2',800.00,800.00,3797.40,0.00,0.00,0.00,0.00,209),('1','294','105','1',178.00,178.00,0.00,0.00,0.00,0.00,0.00,210),('1','294','106','2',800.00,800.00,2831.53,0.00,0.00,0.00,0.00,211),('1','294','106','1',178.00,178.00,0.00,0.00,0.00,0.00,0.00,212),('1','294','107','2',800.00,800.00,7626.97,0.00,0.00,0.00,0.00,213),('1','294','107','1',178.00,178.00,0.00,0.00,0.00,0.00,0.00,214),('1','294','108','2',800.00,800.00,1913.90,0.00,0.00,0.00,0.00,215),('1','294','108','1',178.00,178.00,0.00,0.00,0.00,0.00,0.00,216),('1','294','109','2',800.00,800.00,6128.42,0.00,0.00,0.00,0.00,217),('1','294','109','1',178.00,178.00,0.00,0.00,0.00,0.00,0.00,218),('1','294','110','2',800.00,800.00,1015.75,0.00,0.00,0.00,0.00,219),('1','294','110','1',178.00,178.00,0.00,0.00,0.00,0.00,0.00,220),('1','294','111','2',800.00,800.00,6320.22,0.00,0.00,0.00,0.00,221),('1','294','111','1',178.00,178.00,0.00,0.00,0.00,0.00,0.00,222),('1','294','112','2',800.00,800.00,2560.50,0.00,0.00,0.00,0.00,223),('1','294','112','1',185.00,185.00,2149.52,0.00,0.00,0.00,0.00,224),('1','294','113','2',800.00,800.00,2809.25,0.00,0.00,0.00,0.00,225),('1','294','113','1',185.00,185.00,12420.56,0.00,0.00,0.00,0.00,226),('1','294','114','2',800.00,800.00,6025.11,0.00,0.00,0.00,0.00,227),('1','294','114','1',185.00,185.00,2815.84,0.00,0.00,0.00,0.00,228),('1','294','115','2',800.00,800.00,3050.21,0.00,0.00,0.00,0.00,229),('1','294','115','1',185.00,185.00,8652.35,0.00,0.00,0.00,0.00,230),('1','294','116','2',800.00,800.00,5589.82,0.00,0.00,0.00,0.00,231),('1','294','116','1',185.00,185.00,6091.44,0.00,0.00,0.00,0.00,232),('1','294','117','2',800.00,800.00,5763.29,0.00,0.00,0.00,0.00,233),('1','294','117','1',185.00,185.00,15976.91,0.00,0.00,0.00,0.00,234),('1','294','118','2',860.00,860.00,3386.36,0.00,0.00,0.00,0.00,235),('1','294','118','1',185.00,185.00,2036.46,0.00,0.00,0.00,0.00,236),('1','294','119','2',860.00,860.00,2832.22,0.00,0.00,0.00,0.00,237),('1','294','119','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,238),('1','294','120','2',860.00,860.00,3470.65,0.00,0.00,0.00,0.00,239),('1','294','120','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,240),('1','294','121','2',860.00,860.00,837.06,0.00,0.00,0.00,0.00,241),('1','294','121','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,242),('1','294','122','2',860.00,860.00,1890.06,0.00,0.00,0.00,0.00,243),('1','294','122','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,244),('1','294','123','2',860.00,860.00,634.03,0.00,0.00,0.00,0.00,245),('1','294','123','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,246),('1','294','124','2',860.00,860.00,1493.54,0.00,0.00,0.00,0.00,247),('1','294','124','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,248),('1','294','125','2',860.00,860.00,1634.11,0.00,0.00,0.00,0.00,249),('1','294','125','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,250),('1','294','126','2',860.00,860.00,2270.00,0.00,0.00,0.00,0.00,251),('1','294','126','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,252),('1','294','127','2',860.00,860.00,1616.03,0.00,0.00,0.00,0.00,253),('1','294','127','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,254),('1','294','128','2',860.00,860.00,1843.11,0.00,0.00,0.00,0.00,255),('1','294','128','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,256),('1','294','129','2',825.00,825.00,1949.73,0.00,0.00,0.00,0.00,257),('1','294','129','1',185.00,185.00,7267.52,0.00,0.00,0.00,0.00,258),('1','294','130','2',825.00,825.00,2364.66,0.00,0.00,0.00,0.00,259),('1','294','130','1',185.00,185.00,2011.82,0.00,0.00,0.00,0.00,260),('1','294','131','2',825.00,825.00,1975.15,0.00,0.00,0.00,0.00,261),('1','294','131','1',185.00,185.00,9582.60,0.00,0.00,0.00,0.00,262),('1','294','132','2',825.00,825.00,1590.53,0.00,0.00,0.00,0.00,263),('1','294','132','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,264),('1','294','133','2',825.00,825.00,2021.00,0.00,0.00,0.00,0.00,265),('1','294','133','1',185.00,185.00,7055.86,0.00,0.00,0.00,0.00,266),('1','294','134','2',825.00,825.00,2960.29,0.00,0.00,0.00,0.00,267),('1','294','134','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,268),('1','294','135','2',840.00,840.00,2100.19,0.00,0.00,0.00,0.00,269),('1','294','135','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,270),('1','294','136','2',840.00,840.00,1202.62,0.00,0.00,0.00,0.00,271),('1','294','136','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,272),('1','294','137','2',840.00,840.00,1495.24,0.00,0.00,0.00,0.00,273),('1','294','137','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,274),('1','294','138','2',840.00,840.00,2061.26,0.00,0.00,0.00,0.00,275),('1','294','138','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,276),('1','294','139','2',840.00,840.00,2701.10,0.00,0.00,0.00,0.00,277),('1','294','139','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,278),('1','294','140','2',840.00,840.00,5759.30,0.00,0.00,0.00,0.00,279),('1','294','140','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,280),('1','294','141','2',840.00,840.00,2547.02,0.00,0.00,0.00,0.00,281),('1','294','141','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,282),('1','294','142','2',840.00,840.00,2527.33,0.00,0.00,0.00,0.00,283),('1','294','142','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,284),('1','294','143','2',840.00,840.00,1837.80,0.00,0.00,0.00,0.00,285),('1','294','143','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,286),('1','294','144','2',840.00,840.00,1467.84,0.00,0.00,0.00,0.00,287),('1','294','144','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,288),('1','294','145','2',840.00,840.00,3373.07,0.00,0.00,0.00,0.00,289),('1','294','145','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,290),('1','294','146','2',840.00,840.00,2362.46,0.00,0.00,0.00,0.00,291),('1','294','146','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,292),('1','294','147','2',830.00,830.00,2827.28,0.00,0.00,0.00,0.00,293),('1','294','147','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,294),('1','294','148','2',830.00,830.00,585.19,0.00,0.00,0.00,0.00,295),('1','294','148','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,296),('1','294','149','2',830.00,830.00,4013.32,0.00,0.00,0.00,0.00,297),('1','294','149','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,298),('1','294','150','2',830.00,830.00,1896.77,0.00,0.00,0.00,0.00,299),('1','294','150','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,300),('1','294','151','2',830.00,830.00,1380.00,0.00,0.00,0.00,0.00,301),('1','294','151','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,302),('1','294','152','2',830.00,830.00,601.14,0.00,0.00,0.00,0.00,303),('1','294','152','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,304),('1','294','153','2',840.00,840.00,3090.28,0.00,0.00,0.00,0.00,305),('1','294','153','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,306),('1','294','154','2',840.00,840.00,3938.04,0.00,0.00,0.00,0.00,307),('1','294','154','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,308),('1','294','155','2',840.00,840.00,2027.15,0.00,0.00,0.00,0.00,309),('1','294','155','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,310),('1','294','156','2',840.00,840.00,3072.57,0.00,0.00,0.00,0.00,311),('1','294','156','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,312),('1','294','157','2',840.00,840.00,2306.60,0.00,0.00,0.00,0.00,313),('1','294','157','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,314),('1','294','158','2',840.00,840.00,3131.82,0.00,0.00,0.00,0.00,315),('1','294','158','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,316),('1','294','159','2',840.00,840.00,868.05,0.00,0.00,0.00,0.00,317),('1','294','159','1',220.00,220.00,5617.79,0.00,0.00,0.00,0.00,318),('1','294','160','2',840.00,840.00,1827.37,0.00,0.00,0.00,0.00,319),('1','294','160','1',220.00,220.00,2674.43,0.00,0.00,0.00,0.00,320),('1','294','161','2',880.00,880.00,1444.12,0.00,0.00,0.00,0.00,321),('1','294','161','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,322),('1','294','162','2',880.00,880.00,2362.38,0.00,0.00,0.00,0.00,323),('1','294','162','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,324),('1','294','163','2',880.00,880.00,2039.69,0.00,0.00,0.00,0.00,325),('1','294','163','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,326),('1','294','164','2',880.00,880.00,1868.87,0.00,0.00,0.00,0.00,327),('1','294','164','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,328),('1','294','165','2',880.00,880.00,2048.39,0.00,0.00,0.00,0.00,329),('1','294','165','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,330),('1','294','166','2',880.00,880.00,1597.03,0.00,0.00,0.00,0.00,331),('1','294','166','1',220.00,220.00,6099.62,0.00,0.00,0.00,0.00,332),('1','294','167','2',880.00,880.00,395.56,0.00,0.00,0.00,0.00,333),('1','294','167','1',220.00,220.00,9787.96,0.00,0.00,0.00,0.00,334),('1','294','168','2',840.00,840.00,1600.75,0.00,0.00,0.00,0.00,335),('1','294','168','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,336),('1','294','169','2',840.00,840.00,0.00,0.00,0.00,0.00,0.00,337),('1','294','169','1',220.00,220.00,5613.17,0.00,0.00,0.00,0.00,338),('1','294','170','2',820.00,820.00,6906.31,0.00,0.00,0.00,0.00,339),('1','294','170','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,340),('1','294','171','2',820.00,820.00,2176.52,0.00,0.00,0.00,0.00,341),('1','294','171','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,342),('1','294','172','2',820.00,820.00,9666.13,0.00,0.00,0.00,0.00,343),('1','294','172','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,344),('1','294','173','2',820.00,820.00,2649.37,0.00,0.00,0.00,0.00,345),('1','294','173','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,346),('1','294','174','2',820.00,820.00,2430.68,0.00,0.00,0.00,0.00,347),('1','294','174','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,348),('1','294','175','2',820.00,820.00,2777.44,0.00,0.00,0.00,0.00,349),('1','294','175','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,350),('1','294','176','2',820.00,820.00,3575.61,0.00,0.00,0.00,0.00,351),('1','294','176','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,352),('1','294','177','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,353),('1','294','177','1',230.00,230.00,15421.32,0.00,0.00,0.00,0.00,354),('1','294','178','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,355),('1','294','178','1',230.00,230.00,15344.24,0.00,0.00,0.00,0.00,356),('1','294','179','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,357),('1','294','179','1',230.00,230.00,18693.70,0.00,0.00,0.00,0.00,358),('1','294','180','2',820.00,820.00,2907.56,0.00,0.00,0.00,0.00,359),('1','294','180','1',230.00,230.00,10893.48,0.00,0.00,0.00,0.00,360),('1','294','181','2',820.00,820.00,1927.35,0.00,0.00,0.00,0.00,361),('1','294','181','1',230.00,230.00,0.00,0.00,0.00,0.00,0.00,362),('1','294','182','2',820.00,820.00,4403.60,0.00,0.00,0.00,0.00,363),('1','294','182','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,364),('1','294','183','2',820.00,820.00,4094.95,0.00,0.00,0.00,0.00,365),('1','294','183','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,366),('1','294','184','2',820.00,820.00,2955.48,0.00,0.00,0.00,0.00,367),('1','294','184','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,368),('1','294','185','2',820.00,820.00,4305.29,0.00,0.00,0.00,0.00,369),('1','294','185','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,370),('1','294','186','2',820.00,820.00,4444.79,0.00,0.00,0.00,0.00,371),('1','294','186','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,372),('1','294','187','2',820.00,820.00,2405.46,0.00,0.00,0.00,0.00,373),('1','294','187','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,374),('1','294','188','2',820.00,820.00,6563.84,0.00,0.00,0.00,0.00,375),('1','294','188','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,376),('1','294','189','2',820.00,820.00,3808.43,0.00,0.00,0.00,0.00,377),('1','294','189','1',235.00,235.00,12329.90,0.00,0.00,0.00,0.00,378),('1','294','190','2',820.00,820.00,5637.55,0.00,0.00,0.00,0.00,379),('1','294','190','1',235.00,235.00,11707.64,0.00,0.00,0.00,0.00,380),('1','294','191','2',820.00,820.00,2687.34,0.00,0.00,0.00,0.00,381),('1','294','191','1',235.00,235.00,6877.47,0.00,0.00,0.00,0.00,382),('1','294','192','2',820.00,820.00,8726.56,0.00,0.00,0.00,0.00,383),('1','294','192','1',235.00,235.00,12795.45,0.00,0.00,0.00,0.00,384),('1','294','193','2',820.00,820.00,3648.36,0.00,0.00,0.00,0.00,385),('1','294','193','1',235.00,235.00,6120.63,0.00,0.00,0.00,0.00,386),('1','294','194','2',820.00,820.00,4545.44,0.00,0.00,0.00,0.00,387),('1','294','194','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,388),('1','294','195','2',820.00,820.00,3424.33,0.00,0.00,0.00,0.00,389),('1','294','195','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,390),('1','294','196','2',820.00,820.00,4465.86,0.00,0.00,0.00,0.00,391),('1','294','196','1',235.00,235.00,11537.35,0.00,0.00,0.00,0.00,392),('1','294','197','2',820.00,820.00,2787.15,0.00,0.00,0.00,0.00,393),('1','294','197','1',235.00,235.00,14510.56,0.00,0.00,0.00,0.00,394),('1','294','198','2',820.00,820.00,2858.11,0.00,0.00,0.00,0.00,395),('1','294','198','1',235.00,235.00,3659.39,0.00,0.00,0.00,0.00,396),('1','294','199','2',820.00,820.00,5010.98,0.00,0.00,0.00,0.00,397),('1','294','199','1',235.00,235.00,10867.32,0.00,0.00,0.00,0.00,398),('1','294','200','2',820.00,820.00,4690.87,0.00,0.00,0.00,0.00,399),('1','294','200','1',235.00,235.00,5054.00,0.00,0.00,0.00,0.00,400),('1','294','201','2',820.00,820.00,5048.37,0.00,0.00,0.00,0.00,401),('1','294','201','1',235.00,235.00,10347.16,0.00,0.00,0.00,0.00,402),('1','294','202','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,403),('1','294','202','1',235.00,235.00,10268.29,0.00,0.00,0.00,0.00,404),('1','294','203','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,405),('1','294','203','1',235.00,235.00,8249.06,0.00,0.00,0.00,0.00,406),('1','294','204','2',820.00,820.00,2059.89,0.00,0.00,0.00,0.00,407),('1','294','204','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,408),('1','294','205','2',820.00,820.00,5810.28,0.00,0.00,0.00,0.00,409),('1','294','205','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,410),('1','294','206','2',820.00,820.00,3181.94,0.00,0.00,0.00,0.00,411),('1','294','206','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,412),('1','294','207','2',820.00,820.00,4865.79,0.00,0.00,0.00,0.00,413),('1','294','207','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,414),('1','294','208','2',820.00,820.00,4089.44,0.00,0.00,0.00,0.00,415),('1','294','208','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,416),('1','294','209','2',820.00,820.00,130.00,0.00,0.00,0.00,0.00,417),('1','294','209','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,418),('1','294','210','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,419),('1','294','210','1',235.00,235.00,12122.93,0.00,0.00,0.00,0.00,420),('1','294','211','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,421),('1','294','211','1',235.00,235.00,12113.27,0.00,0.00,0.00,0.00,422),('1','294','212','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,423),('1','294','212','1',235.00,235.00,11196.94,0.00,0.00,0.00,0.00,424),('1','294','213','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,425),('1','294','213','1',235.00,235.00,14639.99,0.00,0.00,0.00,0.00,426),('1','294','214','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,427),('1','294','214','1',235.00,235.00,16081.15,0.00,0.00,0.00,0.00,428),('1','294','215','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,429),('1','294','215','1',235.00,235.00,13809.52,0.00,0.00,0.00,0.00,430),('1','294','216','2',820.00,820.00,1474.40,0.00,0.00,0.00,0.00,431),('1','294','216','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,432),('1','294','217','2',820.00,820.00,2664.65,0.00,0.00,0.00,0.00,433),('1','294','217','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,434),('1','294','218','2',820.00,820.00,4338.50,0.00,0.00,0.00,0.00,435),('1','294','218','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,436),('1','294','219','2',820.00,820.00,5611.14,0.00,0.00,0.00,0.00,437),('1','294','219','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,438),('1','294','220','2',820.00,820.00,2905.02,0.00,0.00,0.00,0.00,439),('1','294','220','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,440),('1','294','221','2',820.00,820.00,3774.60,0.00,0.00,0.00,0.00,441),('1','294','221','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,442),('1','294','222','2',820.00,820.00,7145.19,0.00,0.00,0.00,0.00,443),('1','294','222','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,444),('1','294','223','2',820.00,820.00,3689.66,0.00,0.00,0.00,0.00,445),('1','294','223','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,446),('1','294','224','2',820.00,820.00,5214.21,0.00,0.00,0.00,0.00,447),('1','294','224','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,448),('1','294','225','2',810.00,810.00,2234.77,0.00,0.00,0.00,0.00,449),('1','294','225','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,450),('1','294','226','2',810.00,810.00,2313.80,0.00,0.00,0.00,0.00,451),('1','294','226','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,452),('1','294','227','2',810.00,810.00,7021.53,0.00,0.00,0.00,0.00,453),('1','294','227','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,454),('1','294','228','2',810.00,810.00,3936.46,0.00,0.00,0.00,0.00,455),('1','294','228','1',235.00,235.00,18111.52,0.00,0.00,0.00,0.00,456),('1','294','229','2',810.00,810.00,7664.39,0.00,0.00,0.00,0.00,457),('1','294','229','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,458),('1','294','230','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,459),('1','294','230','1',235.00,235.00,318.32,0.00,0.00,0.00,0.00,460),('1','294','231','2',810.00,810.00,752.99,0.00,0.00,0.00,0.00,461),('1','294','231','1',235.00,235.00,17082.76,0.00,0.00,0.00,0.00,462),('1','294','232','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,463),('1','294','232','1',235.00,235.00,23083.28,0.00,0.00,0.00,0.00,464),('1','294','233','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,465),('1','294','233','1',235.00,235.00,1233.25,0.00,0.00,0.00,0.00,466),('1','294','234','2',790.00,790.00,2063.15,0.00,0.00,0.00,0.00,467),('1','294','234','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,468),('1','294','235','2',790.00,790.00,6191.63,0.00,0.00,0.00,0.00,469),('1','294','235','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,470),('1','294','236','2',790.00,790.00,1093.90,0.00,0.00,0.00,0.00,471),('1','294','236','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,472),('1','294','237','2',790.00,790.00,3119.95,0.00,0.00,0.00,0.00,473),('1','294','237','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,474),('1','294','238','2',790.00,790.00,4319.85,0.00,0.00,0.00,0.00,475),('1','294','238','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,476),('1','294','239','2',790.00,790.00,433.40,0.00,0.00,0.00,0.00,477),('1','294','239','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,478),('1','294','240','2',790.00,790.00,0.00,0.00,0.00,0.00,0.00,479),('1','294','240','1',250.00,250.00,20103.89,0.00,0.00,0.00,0.00,480),('1','294','241','2',790.00,790.00,0.00,0.00,0.00,0.00,0.00,481),('1','294','241','1',250.00,250.00,8687.98,0.00,0.00,0.00,0.00,482),('1','294','242','2',790.00,790.00,0.00,0.00,0.00,0.00,0.00,483),('1','294','242','1',250.00,250.00,1208.81,0.00,0.00,0.00,0.00,484),('1','294','243','2',790.00,790.00,0.00,0.00,0.00,0.00,0.00,485),('1','294','243','1',200.00,200.00,16909.46,0.00,0.00,0.00,0.00,486),('1','294','244','2',790.00,790.00,0.00,0.00,0.00,0.00,0.00,487),('1','294','244','1',200.00,200.00,18786.75,0.00,0.00,0.00,0.00,488),('1','294','245','2',790.00,790.00,0.00,0.00,0.00,0.00,0.00,489),('1','294','245','1',200.00,200.00,14437.44,0.00,0.00,0.00,0.00,490),('1','294','246','2',800.00,800.00,2228.53,0.00,0.00,0.00,0.00,491),('1','294','246','1',200.00,200.00,0.00,0.00,0.00,0.00,0.00,492),('1','294','247','2',800.00,800.00,3133.03,0.00,0.00,0.00,0.00,493),('1','294','247','1',200.00,200.00,0.00,0.00,0.00,0.00,0.00,494),('1','294','248','2',800.00,800.00,4710.08,0.00,0.00,0.00,0.00,495),('1','294','248','1',200.00,200.00,0.00,0.00,0.00,0.00,0.00,496),('1','294','249','2',800.00,800.00,5267.50,0.00,0.00,0.00,0.00,497),('1','294','249','1',200.00,200.00,0.00,0.00,0.00,0.00,0.00,498),('1','294','250','2',800.00,800.00,5711.71,0.00,0.00,0.00,0.00,499),('1','294','250','1',200.00,200.00,0.00,0.00,0.00,0.00,0.00,500),('1','294','251','2',800.00,800.00,1899.51,0.00,0.00,0.00,0.00,501),('1','294','251','1',200.00,200.00,0.00,0.00,0.00,0.00,0.00,502),('1','294','252','2',800.00,800.00,3616.74,0.00,0.00,0.00,0.00,503),('1','294','252','1',200.00,200.00,0.00,0.00,0.00,0.00,0.00,504),('1','294','253','2',800.00,800.00,1037.51,0.00,0.00,0.00,0.00,505),('1','294','253','1',200.00,200.00,0.00,0.00,0.00,0.00,0.00,506),('1','294','254','2',800.00,800.00,2636.27,0.00,0.00,0.00,0.00,507),('1','294','254','1',200.00,200.00,0.00,0.00,0.00,0.00,0.00,508),('1','294','255','2',800.00,800.00,2990.76,0.00,0.00,0.00,0.00,509),('1','294','255','1',200.00,200.00,0.00,0.00,0.00,0.00,0.00,510),('1','294','256','2',800.00,800.00,2506.46,0.00,0.00,0.00,0.00,511),('1','294','256','1',200.00,200.00,0.00,0.00,0.00,0.00,0.00,512),('1','294','257','2',800.00,800.00,4238.15,0.00,0.00,0.00,0.00,513),('1','294','257','1',200.00,200.00,0.00,0.00,0.00,0.00,0.00,514),('1','294','258','2',800.00,800.00,2535.22,0.00,0.00,0.00,0.00,515),('1','294','258','1',200.00,200.00,0.00,0.00,0.00,0.00,0.00,516),('1','294','259','2',800.00,800.00,3259.84,0.00,0.00,0.00,0.00,517),('1','294','259','1',200.00,200.00,16935.70,0.00,0.00,0.00,0.00,518),('1','294','260','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,519),('1','294','260','1',200.00,200.00,15739.93,0.00,0.00,0.00,0.00,520),('1','294','261','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,521),('1','294','261','1',200.00,200.00,10961.70,0.00,0.00,0.00,0.00,522),('1','294','262','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,523),('1','294','262','1',200.00,200.00,15882.65,0.00,0.00,0.00,0.00,524),('1','294','263','2',800.00,800.00,3130.08,0.00,0.00,0.00,0.00,525),('1','294','263','1',200.00,200.00,16138.73,0.00,0.00,0.00,0.00,526),('1','294','264','2',800.00,800.00,3848.90,0.00,0.00,0.00,0.00,527),('1','294','264','1',200.00,200.00,18173.11,0.00,0.00,0.00,0.00,528),('1','294','265','2',800.00,800.00,2745.24,0.00,0.00,0.00,0.00,529),('1','294','265','1',200.00,200.00,23844.26,0.00,0.00,0.00,0.00,530),('1','294','266','2',800.00,800.00,2330.16,0.00,0.00,0.00,0.00,531),('1','294','266','1',200.00,200.00,8437.11,0.00,0.00,0.00,0.00,532),('1','294','267','2',800.00,800.00,4003.70,0.00,0.00,0.00,0.00,533),('1','294','267','1',200.00,200.00,9309.53,0.00,0.00,0.00,0.00,534),('1','294','268','2',800.00,800.00,1473.00,0.00,0.00,0.00,0.00,535),('1','294','268','1',200.00,200.00,2658.00,0.00,0.00,0.00,0.00,536),('1','294','269','2',800.00,800.00,697.63,0.00,0.00,0.00,0.00,537),('1','294','269','1',200.00,200.00,9618.58,0.00,0.00,0.00,0.00,538),('1','294','270','2',800.00,800.00,380.19,0.00,0.00,0.00,0.00,539),('1','294','270','1',200.00,200.00,11665.30,0.00,0.00,0.00,0.00,540),('1','294','271','2',800.00,800.00,157.51,0.00,0.00,0.00,0.00,541),('1','294','271','1',200.00,200.00,10084.56,0.00,0.00,0.00,0.00,542),('1','294','272','2',800.00,800.00,975.36,0.00,0.00,0.00,0.00,543),('1','294','272','1',200.00,200.00,14073.85,0.00,0.00,0.00,0.00,544),('1','294','273','2',800.00,800.00,488.48,0.00,0.00,0.00,0.00,545),('1','294','273','1',200.00,200.00,3663.27,0.00,0.00,0.00,0.00,546),('1','294','274','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,547),('1','294','274','1',200.00,200.00,14443.26,0.00,0.00,0.00,0.00,548),('1','294','275','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,549),('1','294','275','1',200.00,200.00,5393.48,0.00,0.00,0.00,0.00,550),('1','294','276','2',800.00,800.00,962.03,0.00,0.00,0.00,0.00,551),('1','294','276','1',200.00,200.00,9607.86,0.00,0.00,0.00,0.00,552),('1','294','277','2',800.00,800.00,2740.26,0.00,0.00,0.00,0.00,553),('1','294','277','1',200.00,200.00,0.00,0.00,0.00,0.00,0.00,554),('1','294','278','2',800.00,800.00,1771.00,0.00,0.00,0.00,0.00,555),('1','294','278','1',200.00,200.00,0.00,0.00,0.00,0.00,0.00,556),('1','294','279','2',800.00,800.00,2815.30,0.00,0.00,0.00,0.00,557),('1','294','279','1',200.00,200.00,0.00,0.00,0.00,0.00,0.00,558),('1','294','280','2',800.00,800.00,1658.51,0.00,0.00,0.00,0.00,559),('1','294','280','1',200.00,200.00,0.00,0.00,0.00,0.00,0.00,560),('1','294','281','2',800.00,800.00,3263.29,0.00,0.00,0.00,0.00,561),('1','294','281','1',200.00,200.00,0.00,0.00,0.00,0.00,0.00,562),('1','294','282','2',800.00,800.00,1681.14,0.00,0.00,0.00,0.00,563),('1','294','282','1',200.00,200.00,0.00,0.00,0.00,0.00,0.00,564),('1','294','283','2',800.00,800.00,2457.37,0.00,0.00,0.00,0.00,565),('1','294','283','1',200.00,200.00,0.00,0.00,0.00,0.00,0.00,566),('1','294','284','2',800.00,800.00,1396.15,0.00,0.00,0.00,0.00,567),('1','294','284','1',200.00,200.00,0.00,0.00,0.00,0.00,0.00,568),('1','294','285','2',800.00,800.00,4707.80,0.00,0.00,0.00,0.00,569),('1','294','285','1',200.00,200.00,0.00,0.00,0.00,0.00,0.00,570),('1','294','286','2',800.00,800.00,2448.38,0.00,0.00,0.00,0.00,571),('1','294','286','1',200.00,200.00,8382.58,0.00,0.00,0.00,0.00,572),('1','294','287','2',800.00,800.00,4710.81,0.00,0.00,0.00,0.00,573),('1','294','287','1',200.00,200.00,14946.55,0.00,0.00,0.00,0.00,574),('1','294','288','2',800.00,800.00,2835.30,0.00,0.00,0.00,0.00,575),('1','294','288','1',200.00,200.00,9903.16,0.00,0.00,0.00,0.00,576),('1','294','289','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,577),('1','294','289','1',200.00,200.00,4559.11,0.00,0.00,0.00,0.00,578),('1','294','290','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,579),('1','294','290','1',200.00,200.00,11937.22,0.00,0.00,0.00,0.00,580),('1','294','291','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,581),('1','294','291','1',200.00,200.00,11907.55,0.00,0.00,0.00,0.00,582),('1','294','292','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,583),('1','294','292','1',200.00,200.00,9622.48,0.00,0.00,0.00,0.00,584),('1','294','293','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,585),('1','294','293','1',200.00,200.00,10266.56,0.00,0.00,0.00,0.00,586),('1','294','294','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,587),('1','294','294','1',200.00,200.00,6616.30,0.00,0.00,0.00,0.00,588),('1','294','295','2',800.00,800.00,1127.24,0.00,0.00,0.00,0.00,589),('1','294','295','1',200.00,200.00,15032.40,0.00,0.00,0.00,0.00,590),('1','294','296','2',800.00,800.00,3838.32,0.00,0.00,0.00,0.00,591),('1','294','296','1',200.00,200.00,7820.07,0.00,0.00,0.00,0.00,592),('1','294','297','2',800.00,800.00,3314.39,0.00,0.00,0.00,0.00,593),('1','294','297','1',200.00,200.00,8497.85,0.00,0.00,0.00,0.00,594),('1','294','298','2',800.00,800.00,4611.88,0.00,0.00,0.00,0.00,595),('1','294','298','1',200.00,200.00,0.00,0.00,0.00,0.00,0.00,596),('1','294','299','2',800.00,800.00,1904.25,0.00,0.00,0.00,0.00,597),('1','294','299','1',200.00,200.00,0.00,0.00,0.00,0.00,0.00,598),('1','294','300','2',800.00,800.00,362.12,0.00,0.00,0.00,0.00,599),('1','294','300','1',200.00,200.00,0.00,0.00,0.00,0.00,0.00,600),('1','294','301','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,601),('1','294','301','1',200.00,200.00,21609.38,0.00,0.00,0.00,0.00,602),('1','294','302','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,603),('1','294','302','1',200.00,200.00,8483.42,0.00,0.00,0.00,0.00,604),('1','294','303','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,605),('1','294','303','1',200.00,200.00,14543.89,0.00,0.00,0.00,0.00,606),('1','294','304','2',800.00,800.00,928.13,0.00,0.00,0.00,0.00,607),('1','294','304','1',200.00,200.00,0.00,0.00,0.00,0.00,0.00,608);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',1,'294','PMS TANKS',''),('1',2,'294','AGO TANKS','');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','294','1',1,0,'1','PMS TANK 1 & 2',102000.00,0.00,NULL,'CONTAING PMS','178','2022-10-19 10:35:15','2022-10-19 10:35:15','178',5,0),('1','294','1',2,0,'1','PMS TANK 3 & 4',102000.00,0.00,NULL,'CONTAING PMS','178','2022-10-19 10:38:02','2022-10-19 10:38:02','178',5,0),('1','294','2',3,0,'2','AGO TANK',51000.00,0.00,NULL,'CONTAING AGO','178','2022-10-19 10:40:22','2022-10-19 10:40:22','178',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','294',3,45006.50,'2023-03-20 13:43:10'),(2,'1','294',2,373.28,'2023-03-20 13:43:10'),(3,'1','294',1,31057.99,'2023-03-20 13:43:10');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=1868 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'1','294',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8750000.00,50000.00,0.00,0.00,'2022-10-25 14:28:05','',''),(2,'1','294',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,33975000.00,45000.00,0.00,0.00,'2022-10-25 14:29:00','',''),(3,'1','294',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,7875000.00,45000.00,0.00,0.00,'2022-10-25 14:30:19','',''),(4,'1','294','1',1,'Sale Id shift 1',0.00,0.00,0.00,131.40,0.00,'2022-10-26 12:07:01','',''),(5,'1','294','1',1,'Sale Id shift 1',0.00,0.00,0.00,103.26,0.00,'2022-10-26 12:07:01','',''),(6,'1','294','2',1,'Sale Id shift 1',0.00,0.00,0.00,197.66,0.00,'2022-10-26 12:07:01','',''),(7,'1','294','2',1,'Sale Id shift 1',0.00,0.00,0.00,173.66,0.00,'2022-10-26 12:07:01','',''),(8,'1','294','2',1,'Sale Id shift 1',0.00,0.00,0.00,45.71,0.00,'2022-10-26 12:07:01','',''),(9,'1','294',NULL,1,'Sale Id shift 1',114045.75,0.00,0.00,0.00,0.00,'2022-10-26 12:07:01','',''),(10,'1','294','2',1,'Sale Id shift 2',0.00,0.00,0.00,660.08,0.00,'2022-10-26 12:23:47','',''),(11,'1','294','2',1,'Sale Id shift 2',0.00,0.00,0.00,1230.03,0.00,'2022-10-26 12:23:47','',''),(12,'1','294','2',1,'Sale Id shift 2',0.00,0.00,0.00,1349.12,0.00,'2022-10-26 12:23:47','',''),(13,'1','294','3',2,'Sale Id shift 2',0.00,0.00,0.00,1197.36,0.00,'2022-10-26 12:23:47','',''),(14,'1','294','1',1,'Sale Id shift 2',0.00,0.00,0.00,311.82,0.00,'2022-10-26 12:23:47','',''),(15,'1','294','1',1,'Sale Id shift 2',0.00,0.00,0.00,118.20,0.00,'2022-10-26 12:23:47','',''),(16,'1','294',NULL,2,'Sale Id shift 2',904006.80,0.00,0.00,0.00,0.00,'2022-10-26 12:23:47','',''),(17,'1','294',NULL,1,'Sale Id shift 2',642118.75,0.00,0.00,0.00,0.00,'2022-10-26 12:23:47','',''),(18,'1','294','2',1,'Sale Id shift 3',0.00,0.00,0.00,64.43,0.00,'2022-10-26 13:54:57','',''),(19,'1','294','2',1,'Sale Id shift 3',0.00,0.00,0.00,557.94,0.00,'2022-10-26 13:54:57','',''),(20,'1','294','2',1,'Sale Id shift 3',0.00,0.00,0.00,440.38,0.00,'2022-10-26 13:54:57','',''),(21,'1','294','3',2,'Sale Id shift 3',0.00,0.00,0.00,193.82,0.00,'2022-10-26 13:54:57','',''),(22,'1','294','3',2,'Sale Id shift 3',0.00,0.00,0.00,90.00,0.00,'2022-10-26 13:54:57','',''),(23,'1','294','1',1,'Sale Id shift 3',0.00,0.00,0.00,10.14,0.00,'2022-10-26 13:54:57','',''),(24,'1','294',NULL,2,'Sale Id shift 3',214284.10,0.00,0.00,0.00,0.00,'2022-10-26 13:54:57','',''),(25,'1','294',NULL,1,'Sale Id shift 3',187755.75,0.00,0.00,0.00,0.00,'2022-10-26 13:54:57','',''),(26,'1','294','2',1,'Sale Id shift 4',0.00,0.00,0.00,1949.79,0.00,'2022-10-26 14:28:54','',''),(27,'1','294','2',1,'Sale Id shift 4',0.00,0.00,0.00,1664.15,0.00,'2022-10-26 14:28:54','',''),(28,'1','294','2',1,'Sale Id shift 4',0.00,0.00,0.00,1965.12,0.00,'2022-10-26 14:28:54','',''),(29,'1','294','2',1,'Sale Id shift 4',0.00,0.00,0.00,880.81,0.00,'2022-10-26 14:28:54','',''),(30,'1','294','2',1,'Sale Id shift 4',0.00,0.00,0.00,980.67,0.00,'2022-10-26 14:28:54','',''),(31,'1','294','3',2,'Sale Id shift 4',0.00,0.00,0.00,635.81,0.00,'2022-10-26 14:28:54','',''),(32,'1','294','3',2,'Sale Id shift 4',0.00,0.00,0.00,1104.01,0.00,'2022-10-26 14:28:54','',''),(33,'1','294','1',1,'Sale Id shift 4',0.00,0.00,0.00,963.83,0.00,'2022-10-26 14:28:54','',''),(34,'1','294',NULL,2,'Sale Id shift 4',1313564.10,0.00,0.00,0.00,0.00,'2022-10-26 14:28:54','',''),(35,'1','294',NULL,1,'Sale Id shift 4',1470764.75,0.00,0.00,0.00,0.00,'2022-10-26 14:28:54','',''),(36,'1','294','2',1,'Sale Id shift 5',0.00,0.00,0.00,1097.36,0.00,'2022-10-26 14:43:05','',''),(37,'1','294','3',2,'Sale Id shift 5',0.00,0.00,0.00,133.03,0.00,'2022-10-26 14:43:05','',''),(38,'1','294','1',1,'Sale Id shift 5',0.00,0.00,0.00,586.37,0.00,'2022-10-26 14:43:05','',''),(39,'1','294',NULL,2,'Sale Id shift 5',100437.65,0.00,0.00,0.00,0.00,'2022-10-26 14:43:05','',''),(40,'1','294',NULL,1,'Sale Id shift 5',294652.75,0.00,0.00,0.00,0.00,'2022-10-26 14:43:05','',''),(41,'1','294','2',1,'Sale Id shift 6',0.00,0.00,0.00,-10.00,0.00,'2022-10-26 15:02:05','',''),(42,'1','294','2',1,'Sale Id shift 6',0.00,0.00,0.00,-10.00,0.00,'2022-10-26 15:02:05','',''),(43,'1','294','2',1,'Sale Id shift 6',0.00,0.00,0.00,-5.00,0.00,'2022-10-26 15:02:05','',''),(44,'1','294','1',1,'Sale Id shift 6',0.00,0.00,0.00,-10.00,0.00,'2022-10-26 15:02:05','',''),(45,'1','294','1',1,'Sale Id shift 6',0.00,0.00,0.00,-10.00,0.00,'2022-10-26 15:02:05','',''),(46,'1','294',NULL,1,'Sale Id shift 6',-7875.00,0.00,0.00,0.00,0.00,'2022-10-26 15:02:05','',''),(47,'1','294','2',1,'Sale Id shift 7',0.00,0.00,0.00,1956.63,0.00,'2022-10-26 15:31:08','',''),(48,'1','294','2',1,'Sale Id shift 7',0.00,0.00,0.00,2147.01,0.00,'2022-10-26 15:31:08','',''),(49,'1','294','2',1,'Sale Id shift 7',0.00,0.00,0.00,1812.38,0.00,'2022-10-26 15:31:08','',''),(50,'1','294','2',1,'Sale Id shift 7',0.00,0.00,0.00,673.94,0.00,'2022-10-26 15:31:08','',''),(51,'1','294','2',1,'Sale Id shift 7',0.00,0.00,0.00,1106.58,0.00,'2022-10-26 15:31:08','',''),(52,'1','294','3',2,'Sale Id shift 7',0.00,0.00,0.00,3208.70,0.00,'2022-10-26 15:31:08','',''),(53,'1','294','3',2,'Sale Id shift 7',0.00,0.00,0.00,30.00,0.00,'2022-10-26 15:31:08','',''),(54,'1','294','1',1,'Sale Id shift 7',0.00,0.00,0.00,1152.97,0.00,'2022-10-26 15:31:08','',''),(55,'1','294','1',1,'Sale Id shift 7',0.00,0.00,0.00,98.00,0.00,'2022-10-26 15:31:08','',''),(56,'1','294','1',1,'Sale Id shift 7',0.00,0.00,0.00,19.15,0.00,'2022-10-26 15:31:08','',''),(57,'1','294','1',1,'Sale Id shift 7',0.00,0.00,0.00,68.19,0.00,'2022-10-26 15:31:08','',''),(58,'1','294',NULL,2,'Sale Id shift 7',2445218.50,0.00,0.00,0.00,0.00,'2022-10-26 15:31:08','',''),(59,'1','294',NULL,1,'Sale Id shift 7',1581098.75,0.00,0.00,0.00,0.00,'2022-10-26 15:31:08','',''),(60,'1','294','2',1,'Sale Id shift 8',0.00,0.00,0.00,810.24,0.00,'2022-10-26 16:02:47','',''),(61,'1','294','2',1,'Sale Id shift 8',0.00,0.00,0.00,647.76,0.00,'2022-10-26 16:02:47','',''),(62,'1','294',NULL,1,'Sale Id shift 8',255150.00,0.00,0.00,0.00,0.00,'2022-10-26 16:02:47','',''),(63,'1','294','2',1,'Sale Id shift 9',0.00,0.00,0.00,2067.31,0.00,'2022-10-26 17:12:11','',''),(64,'1','294','2',1,'Sale Id shift 9',0.00,0.00,0.00,2319.14,0.00,'2022-10-26 17:12:11','',''),(65,'1','294','2',1,'Sale Id shift 9',0.00,0.00,0.00,1920.60,0.00,'2022-10-26 17:12:11','',''),(66,'1','294','2',1,'Sale Id shift 9',0.00,0.00,0.00,1962.36,0.00,'2022-10-26 17:12:11','',''),(67,'1','294','2',1,'Sale Id shift 9',0.00,0.00,0.00,1361.45,0.00,'2022-10-26 17:12:11','',''),(68,'1','294','3',2,'Sale Id shift 9',0.00,0.00,0.00,1864.12,0.00,'2022-10-26 17:12:11','',''),(69,'1','294','3',2,'Sale Id shift 9',0.00,0.00,0.00,546.01,0.00,'2022-10-26 17:12:11','',''),(70,'1','294','3',2,'Sale Id shift 9',0.00,0.00,0.00,23.00,0.00,'2022-10-26 17:12:11','',''),(71,'1','294','1',1,'Sale Id shift 9',0.00,0.00,0.00,15.00,0.00,'2022-10-26 17:12:11','',''),(72,'1','294',NULL,2,'Sale Id shift 9',1837013.15,0.00,0.00,0.00,0.00,'2022-10-26 17:12:11','',''),(73,'1','294',NULL,1,'Sale Id shift 9',1688025.50,0.00,0.00,0.00,0.00,'2022-10-26 17:12:11','',''),(74,'1','294','2',1,'Sale Id shift 10',0.00,0.00,0.00,384.22,0.00,'2022-10-27 10:52:18','',''),(75,'1','294','2',1,'Sale Id shift 10',0.00,0.00,0.00,1272.71,0.00,'2022-10-27 10:52:18','',''),(76,'1','294','2',1,'Sale Id shift 10',0.00,0.00,0.00,41.92,0.00,'2022-10-27 10:52:18','',''),(77,'1','294','3',2,'Sale Id shift 10',0.00,0.00,0.00,602.48,0.00,'2022-10-27 10:52:18','',''),(78,'1','294',NULL,2,'Sale Id shift 10',454872.40,0.00,0.00,0.00,0.00,'2022-10-27 10:52:18','',''),(79,'1','294',NULL,1,'Sale Id shift 10',297298.75,0.00,0.00,0.00,0.00,'2022-10-27 10:52:18','',''),(80,'1','294','3',2,'Sale Id shift 11',0.00,0.00,0.00,948.74,0.00,'2022-10-27 10:59:58','',''),(81,'1','294','1',1,'Sale Id shift 11',0.00,0.00,0.00,1634.03,0.00,'2022-10-27 10:59:58','',''),(82,'1','294','1',1,'Sale Id shift 11',0.00,0.00,0.00,1282.21,0.00,'2022-10-27 10:59:58','',''),(83,'1','294','1',1,'Sale Id shift 11',0.00,0.00,0.00,1455.86,0.00,'2022-10-27 10:59:58','',''),(84,'1','294','1',1,'Sale Id shift 11',0.00,0.00,0.00,174.79,0.00,'2022-10-27 10:59:58','',''),(85,'1','294',NULL,2,'Sale Id shift 11',716298.70,0.00,0.00,0.00,0.00,'2022-10-27 10:59:58','',''),(86,'1','294',NULL,1,'Sale Id shift 11',795705.75,0.00,0.00,0.00,0.00,'2022-10-27 10:59:58','',''),(87,'1','294','3',2,'Sale Id shift 12',0.00,0.00,0.00,745.46,0.00,'2022-10-27 11:25:30','',''),(88,'1','294','1',1,'Sale Id shift 12',0.00,0.00,0.00,2174.78,0.00,'2022-10-27 11:25:30','',''),(89,'1','294','1',1,'Sale Id shift 12',0.00,0.00,0.00,1650.63,0.00,'2022-10-27 11:25:30','',''),(90,'1','294','1',1,'Sale Id shift 12',0.00,0.00,0.00,1322.13,0.00,'2022-10-27 11:25:30','',''),(91,'1','294','1',1,'Sale Id shift 12',0.00,0.00,0.00,326.90,0.00,'2022-10-27 11:25:30','',''),(92,'1','294',NULL,2,'Sale Id shift 12',562822.30,0.00,0.00,0.00,0.00,'2022-10-27 11:25:30','',''),(93,'1','294',NULL,1,'Sale Id shift 12',958027.00,0.00,0.00,0.00,0.00,'2022-10-27 11:25:30','',''),(94,'1','294','1',1,'Sale Id shift 13',0.00,0.00,0.00,82.28,0.00,'2022-10-27 11:34:46','',''),(95,'1','294','3',2,'Sale Id shift 13',0.00,0.00,0.00,708.74,0.00,'2022-10-27 11:34:46','',''),(96,'1','294','3',2,'Sale Id shift 13',0.00,0.00,0.00,20.02,0.00,'2022-10-27 11:34:46','',''),(97,'1','294','3',2,'Sale Id shift 13',0.00,0.00,0.00,40.00,0.00,'2022-10-27 11:34:46','',''),(98,'1','294','1',1,'Sale Id shift 13',0.00,0.00,0.00,1602.00,0.00,'2022-10-27 11:34:46','',''),(99,'1','294','3',2,'Sale Id shift 13',0.00,0.00,0.00,20.00,0.00,'2022-10-27 11:34:46','',''),(100,'1','294','1',1,'Sale Id shift 13',0.00,0.00,0.00,1312.74,0.00,'2022-10-27 11:34:46','',''),(101,'1','294','1',1,'Sale Id shift 13',0.00,0.00,0.00,1360.60,0.00,'2022-10-27 11:34:46','',''),(102,'1','294','1',1,'Sale Id shift 13',0.00,0.00,0.00,794.03,0.00,'2022-10-27 11:34:46','',''),(103,'1','294',NULL,2,'Sale Id shift 13',595513.80,0.00,0.00,0.00,0.00,'2022-10-27 11:34:46','',''),(104,'1','294',NULL,1,'Sale Id shift 13',901538.75,0.00,0.00,0.00,0.00,'2022-10-27 11:34:46','',''),(105,'1','294','1',1,'Sale Id shift 14',0.00,0.00,0.00,403.89,0.00,'2022-10-27 11:48:37','',''),(106,'1','294','3',2,'Sale Id shift 14',0.00,0.00,0.00,805.62,0.00,'2022-10-27 11:48:37','',''),(107,'1','294','1',1,'Sale Id shift 14',0.00,0.00,0.00,2727.38,0.00,'2022-10-27 11:48:37','',''),(108,'1','294','1',1,'Sale Id shift 14',0.00,0.00,0.00,479.23,0.00,'2022-10-27 11:48:37','',''),(109,'1','294','1',1,'Sale Id shift 14',0.00,0.00,0.00,1940.98,0.00,'2022-10-27 11:48:37','',''),(110,'1','294',NULL,2,'Sale Id shift 14',608243.10,0.00,0.00,0.00,0.00,'2022-10-27 11:48:37','',''),(111,'1','294',NULL,1,'Sale Id shift 14',971509.00,0.00,0.00,0.00,0.00,'2022-10-27 11:48:37','',''),(112,'1','294','3',2,'Sale Id shift 15',0.00,0.00,0.00,989.34,0.00,'2022-10-27 11:55:51','',''),(113,'1','294','1',1,'Sale Id shift 15',0.00,0.00,0.00,1444.62,0.00,'2022-10-27 11:55:51','',''),(114,'1','294','1',1,'Sale Id shift 15',0.00,0.00,0.00,1676.04,0.00,'2022-10-27 11:55:51','',''),(115,'1','294','1',1,'Sale Id shift 15',0.00,0.00,0.00,1386.28,0.00,'2022-10-27 11:55:51','',''),(116,'1','294',NULL,2,'Sale Id shift 15',746951.70,0.00,0.00,0.00,0.00,'2022-10-27 11:55:51','',''),(117,'1','294',NULL,1,'Sale Id shift 15',788714.50,0.00,0.00,0.00,0.00,'2022-10-27 11:55:51','',''),(118,'1','294','1',1,'Sale Id shift 16',0.00,0.00,0.00,319.18,0.00,'2022-10-27 12:01:17','',''),(119,'1','294','2',1,'Sale Id shift 16',0.00,0.00,0.00,279.71,0.00,'2022-10-27 12:01:17','',''),(120,'1','294','2',1,'Sale Id shift 16',0.00,0.00,0.00,1039.08,0.00,'2022-10-27 12:01:17','',''),(121,'1','294','2',1,'Sale Id shift 16',0.00,0.00,0.00,283.92,0.00,'2022-10-27 12:01:17','',''),(122,'1','294','2',1,'Sale Id shift 16',0.00,0.00,0.00,521.60,0.00,'2022-10-27 12:01:17','',''),(123,'1','294','3',2,'Sale Id shift 16',0.00,0.00,0.00,1417.28,0.00,'2022-10-27 12:01:17','',''),(124,'1','294','1',1,'Sale Id shift 16',0.00,0.00,0.00,1041.66,0.00,'2022-10-27 12:01:17','',''),(125,'1','294','1',1,'Sale Id shift 16',0.00,0.00,0.00,1127.06,0.00,'2022-10-27 12:01:17','',''),(126,'1','294','1',1,'Sale Id shift 16',0.00,0.00,0.00,1039.64,0.00,'2022-10-27 12:01:17','',''),(127,'1','294',NULL,2,'Sale Id shift 16',1070046.40,0.00,0.00,0.00,0.00,'2022-10-27 12:01:17','',''),(128,'1','294',NULL,1,'Sale Id shift 16',989073.75,0.00,0.00,0.00,0.00,'2022-10-27 12:01:17','',''),(129,'1','294','2',1,'Sale Id shift 17',0.00,0.00,0.00,199.87,0.00,'2022-10-27 12:11:06','',''),(130,'1','294','2',1,'Sale Id shift 17',0.00,0.00,0.00,2621.26,0.00,'2022-10-27 12:11:06','',''),(131,'1','294','2',1,'Sale Id shift 17',0.00,0.00,0.00,167.82,0.00,'2022-10-27 12:11:06','',''),(132,'1','294','2',1,'Sale Id shift 17',0.00,0.00,0.00,2133.96,0.00,'2022-10-27 12:11:06','',''),(133,'1','294','2',1,'Sale Id shift 17',0.00,0.00,0.00,425.16,0.00,'2022-10-27 12:11:06','',''),(134,'1','294','2',1,'Sale Id shift 17',0.00,0.00,0.00,1560.55,0.00,'2022-10-27 12:11:06','',''),(135,'1','294','3',2,'Sale Id shift 17',0.00,0.00,0.00,505.17,0.00,'2022-10-27 12:11:06','',''),(136,'1','294','3',2,'Sale Id shift 17',0.00,0.00,0.00,300.00,0.00,'2022-10-27 12:11:06','',''),(137,'1','294',NULL,2,'Sale Id shift 17',607903.35,0.00,0.00,0.00,0.00,'2022-10-27 12:11:06','',''),(138,'1','294',NULL,1,'Sale Id shift 17',1244008.50,0.00,0.00,0.00,0.00,'2022-10-27 12:11:06','',''),(139,'1','294','2',1,'Sale Id shift 18',0.00,0.00,0.00,1786.68,0.00,'2022-10-27 12:17:02','',''),(140,'1','294','2',1,'Sale Id shift 18',0.00,0.00,0.00,756.42,0.00,'2022-10-27 12:17:02','',''),(141,'1','294','2',1,'Sale Id shift 18',0.00,0.00,0.00,2992.61,0.00,'2022-10-27 12:17:02','',''),(142,'1','294','2',1,'Sale Id shift 18',0.00,0.00,0.00,82.85,0.00,'2022-10-27 12:17:02','',''),(143,'1','294','2',1,'Sale Id shift 18',0.00,0.00,0.00,1965.05,0.00,'2022-10-27 12:17:02','',''),(144,'1','294','3',2,'Sale Id shift 18',0.00,0.00,0.00,1487.18,0.00,'2022-10-27 12:17:02','',''),(145,'1','294','3',2,'Sale Id shift 18',0.00,0.00,0.00,368.00,0.00,'2022-10-27 12:17:02','',''),(146,'1','294',NULL,2,'Sale Id shift 18',1400660.90,0.00,0.00,0.00,0.00,'2022-10-27 12:17:02','',''),(147,'1','294',NULL,1,'Sale Id shift 18',1327131.75,0.00,0.00,0.00,0.00,'2022-10-27 12:17:02','',''),(148,'1','294','2',1,'Sale Id shift 19',0.00,0.00,0.00,614.64,0.00,'2022-10-27 12:21:28','',''),(149,'1','294','2',1,'Sale Id shift 19',0.00,0.00,0.00,2265.95,0.00,'2022-10-27 12:21:28','',''),(150,'1','294','2',1,'Sale Id shift 19',0.00,0.00,0.00,2492.77,0.00,'2022-10-27 12:21:28','',''),(151,'1','294','2',1,'Sale Id shift 19',0.00,0.00,0.00,98.85,0.00,'2022-10-27 12:21:28','',''),(152,'1','294','2',1,'Sale Id shift 19',0.00,0.00,0.00,1703.04,0.00,'2022-10-27 12:21:28','',''),(153,'1','294','3',2,'Sale Id shift 19',0.00,0.00,0.00,600.97,0.00,'2022-10-27 12:21:28','',''),(154,'1','294',NULL,2,'Sale Id shift 19',453732.35,0.00,0.00,0.00,0.00,'2022-10-27 12:21:28','',''),(155,'1','294',NULL,1,'Sale Id shift 19',1255668.75,0.00,0.00,0.00,0.00,'2022-10-27 12:21:28','',''),(156,'1','294','2',1,'Sale Id shift 20',0.00,0.00,0.00,2149.25,0.00,'2022-10-27 12:27:40','',''),(157,'1','294','2',1,'Sale Id shift 20',0.00,0.00,0.00,1878.58,0.00,'2022-10-27 12:27:40','',''),(158,'1','294','2',1,'Sale Id shift 20',0.00,0.00,0.00,552.42,0.00,'2022-10-27 12:27:40','',''),(159,'1','294','2',1,'Sale Id shift 20',0.00,0.00,0.00,2731.63,0.00,'2022-10-27 12:27:40','',''),(160,'1','294','2',1,'Sale Id shift 20',0.00,0.00,0.00,1153.30,0.00,'2022-10-27 12:27:40','',''),(161,'1','294','3',2,'Sale Id shift 20',0.00,0.00,0.00,1012.80,0.00,'2022-10-27 12:27:40','',''),(162,'1','294','3',2,'Sale Id shift 20',0.00,0.00,0.00,30.08,0.00,'2022-10-27 12:27:40','',''),(163,'1','294','3',2,'Sale Id shift 20',0.00,0.00,0.00,635.36,0.00,'2022-10-27 12:27:40','',''),(164,'1','294','1',1,'Sale Id shift 20',0.00,0.00,0.00,0.02,0.00,'2022-10-27 12:27:40','',''),(165,'1','294',NULL,2,'Sale Id shift 20',1267071.20,0.00,0.00,0.00,0.00,'2022-10-27 12:27:40','',''),(166,'1','294',NULL,1,'Sale Id shift 20',1481410.00,0.00,0.00,0.00,0.00,'2022-10-27 12:27:40','',''),(167,'1','294','2',1,'Sale Id shift 21',0.00,0.00,0.00,501.52,0.00,'2022-10-27 12:31:33','',''),(168,'1','294','2',1,'Sale Id shift 21',0.00,0.00,0.00,2332.30,0.00,'2022-10-27 12:31:33','',''),(169,'1','294','2',1,'Sale Id shift 21',0.00,0.00,0.00,2338.74,0.00,'2022-10-27 12:31:33','',''),(170,'1','294','2',1,'Sale Id shift 21',0.00,0.00,0.00,1210.09,0.00,'2022-10-27 12:31:33','',''),(171,'1','294','3',2,'Sale Id shift 21',0.00,0.00,0.00,355.50,0.00,'2022-10-27 12:31:33','',''),(172,'1','294',NULL,2,'Sale Id shift 21',268402.50,0.00,0.00,0.00,0.00,'2022-10-27 12:31:33','',''),(173,'1','294',NULL,1,'Sale Id shift 21',1116963.75,0.00,0.00,0.00,0.00,'2022-10-27 12:31:33','',''),(174,'1','294','1',1,'Sale Id shift 22',0.00,0.00,0.00,425.32,0.00,'2022-10-27 12:38:49','',''),(175,'1','294','2',1,'Sale Id shift 22',0.00,0.00,0.00,438.61,0.00,'2022-10-27 12:38:49','',''),(176,'1','294','2',1,'Sale Id shift 22',0.00,0.00,0.00,480.45,0.00,'2022-10-27 12:38:49','',''),(177,'1','294','2',1,'Sale Id shift 22',0.00,0.00,0.00,514.14,0.00,'2022-10-27 12:38:49','',''),(178,'1','294','2',1,'Sale Id shift 22',0.00,0.00,0.00,604.00,0.00,'2022-10-27 12:38:49','',''),(179,'1','294','3',2,'Sale Id shift 22',0.00,0.00,0.00,1475.34,0.00,'2022-10-27 12:38:49','',''),(180,'1','294','1',1,'Sale Id shift 22',0.00,0.00,0.00,1326.36,0.00,'2022-10-27 12:38:49','',''),(181,'1','294','1',1,'Sale Id shift 22',0.00,0.00,0.00,1144.45,0.00,'2022-10-27 12:38:49','',''),(182,'1','294','1',1,'Sale Id shift 22',0.00,0.00,0.00,221.79,0.00,'2022-10-27 12:38:49','',''),(183,'1','294','1',1,'Sale Id shift 22',0.00,0.00,0.00,501.93,0.00,'2022-10-27 12:38:49','',''),(184,'1','294','1',1,'Sale Id shift 22',0.00,0.00,0.00,46.56,0.00,'2022-10-27 12:38:49','',''),(185,'1','294',NULL,2,'Sale Id shift 22',1113881.70,0.00,0.00,0.00,0.00,'2022-10-27 12:38:49','',''),(186,'1','294',NULL,1,'Sale Id shift 22',998131.75,0.00,0.00,0.00,0.00,'2022-10-27 12:38:49','',''),(187,'1','294','3',2,'Sale Id shift 23',0.00,0.00,0.00,376.36,0.00,'2022-10-27 12:45:37','',''),(188,'1','294','3',2,'Sale Id shift 23',0.00,0.00,0.00,99.64,0.00,'2022-10-27 12:45:37','',''),(189,'1','294','1',1,'Sale Id shift 23',0.00,0.00,0.00,2014.49,0.00,'2022-10-27 12:45:37','',''),(190,'1','294','1',1,'Sale Id shift 23',0.00,0.00,0.00,1816.79,0.00,'2022-10-27 12:45:37','',''),(191,'1','294','1',1,'Sale Id shift 23',0.00,0.00,0.00,1971.72,0.00,'2022-10-27 12:45:37','',''),(192,'1','294',NULL,2,'Sale Id shift 23',359380.00,0.00,0.00,0.00,0.00,'2022-10-27 12:45:37','',''),(193,'1','294',NULL,1,'Sale Id shift 23',1015525.00,0.00,0.00,0.00,0.00,'2022-10-27 12:45:37','',''),(194,'1','294',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,10500000.00,60000.00,0.00,0.00,'2022-10-27 12:47:52','',''),(195,'1','294',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8750000.00,50000.00,0.00,0.00,'2022-10-27 12:48:50','',''),(196,'1','294','1',1,'Sale Id shift 24',0.00,0.00,0.00,205.82,0.00,'2022-10-27 14:59:54','',''),(197,'1','294','3',2,'Sale Id shift 24',0.00,0.00,0.00,289.60,0.00,'2022-10-27 14:59:54','',''),(198,'1','294','3',2,'Sale Id shift 24',0.00,0.00,0.00,128.00,0.00,'2022-10-27 14:59:54','',''),(199,'1','294','1',1,'Sale Id shift 24',0.00,0.00,0.00,3121.37,0.00,'2022-10-27 14:59:54','',''),(200,'1','294','1',1,'Sale Id shift 24',0.00,0.00,0.00,101.70,0.00,'2022-10-27 14:59:54','',''),(201,'1','294','1',1,'Sale Id shift 24',0.00,0.00,0.00,1972.58,0.00,'2022-10-27 14:59:54','',''),(202,'1','294','1',1,'Sale Id shift 24',0.00,0.00,0.00,1210.32,0.00,'2022-10-27 14:59:54','',''),(203,'1','294','1',1,'Sale Id shift 24',0.00,0.00,0.00,1037.10,0.00,'2022-10-27 14:59:54','',''),(204,'1','294',NULL,2,'Sale Id shift 24',315288.00,0.00,0.00,0.00,0.00,'2022-10-27 14:59:54','',''),(205,'1','294',NULL,1,'Sale Id shift 24',1338555.75,0.00,0.00,0.00,0.00,'2022-10-27 14:59:54','',''),(206,'1','294','1',1,'Sale Id shift 25',0.00,0.00,0.00,1939.02,0.00,'2022-10-27 15:11:28','',''),(207,'1','294','3',2,'Sale Id shift 25',0.00,0.00,0.00,790.93,0.00,'2022-10-27 15:11:28','',''),(208,'1','294','3',2,'Sale Id shift 25',0.00,0.00,0.00,46.35,0.00,'2022-10-27 15:11:28','',''),(209,'1','294','3',2,'Sale Id shift 25',0.00,0.00,0.00,86.62,0.00,'2022-10-27 15:11:28','',''),(210,'1','294','1',1,'Sale Id shift 25',0.00,0.00,0.00,1828.57,0.00,'2022-10-27 15:11:28','',''),(211,'1','294','1',1,'Sale Id shift 25',0.00,0.00,0.00,391.16,0.00,'2022-10-27 15:11:28','',''),(212,'1','294','1',1,'Sale Id shift 25',0.00,0.00,0.00,2061.76,0.00,'2022-10-27 15:11:28','',''),(213,'1','294',NULL,2,'Sale Id shift 25',697544.50,0.00,0.00,0.00,0.00,'2022-10-27 15:11:28','',''),(214,'1','294',NULL,1,'Sale Id shift 25',1088589.25,0.00,0.00,0.00,0.00,'2022-10-27 15:11:28','',''),(215,'1','294','1',1,'Sale Id shift 26',0.00,0.00,0.00,1476.48,0.00,'2022-10-27 15:19:36','',''),(216,'1','294','3',2,'Sale Id shift 26',0.00,0.00,0.00,341.65,0.00,'2022-10-27 15:19:36','',''),(217,'1','294','3',2,'Sale Id shift 26',0.00,0.00,0.00,106.02,0.00,'2022-10-27 15:19:36','',''),(218,'1','294','1',1,'Sale Id shift 26',0.00,0.00,0.00,570.73,0.00,'2022-10-27 15:19:36','',''),(219,'1','294','1',1,'Sale Id shift 26',0.00,0.00,0.00,2070.35,0.00,'2022-10-27 15:19:36','',''),(220,'1','294','1',1,'Sale Id shift 26',0.00,0.00,0.00,1580.92,0.00,'2022-10-27 15:19:36','',''),(221,'1','294','1',1,'Sale Id shift 26',0.00,0.00,0.00,1003.78,0.00,'2022-10-27 15:19:36','',''),(222,'1','294',NULL,2,'Sale Id shift 26',337990.85,0.00,0.00,0.00,0.00,'2022-10-27 15:19:36','',''),(223,'1','294',NULL,1,'Sale Id shift 26',1172895.50,0.00,0.00,0.00,0.00,'2022-10-27 15:19:36','',''),(224,'1','294','1',1,'Sale Id shift 27',0.00,0.00,0.00,290.41,0.00,'2022-10-27 15:24:53','',''),(225,'1','294','3',2,'Sale Id shift 27',0.00,0.00,0.00,306.86,0.00,'2022-10-27 15:24:53','',''),(226,'1','294','1',1,'Sale Id shift 27',0.00,0.00,0.00,2260.07,0.00,'2022-10-27 15:24:53','',''),(227,'1','294','1',1,'Sale Id shift 27',0.00,0.00,0.00,2234.92,0.00,'2022-10-27 15:24:53','',''),(228,'1','294','1',1,'Sale Id shift 27',0.00,0.00,0.00,1736.17,0.00,'2022-10-27 15:24:53','',''),(229,'1','294','1',1,'Sale Id shift 27',0.00,0.00,0.00,465.01,0.00,'2022-10-27 15:24:53','',''),(230,'1','294',NULL,2,'Sale Id shift 27',231679.30,0.00,0.00,0.00,0.00,'2022-10-27 15:24:53','',''),(231,'1','294',NULL,1,'Sale Id shift 27',1222651.50,0.00,0.00,0.00,0.00,'2022-10-27 15:24:53','',''),(232,'1','294','1',1,'Sale Id shift 28',0.00,0.00,0.00,493.42,0.00,'2022-10-27 15:31:09','',''),(233,'1','294','3',2,'Sale Id shift 28',0.00,0.00,0.00,1880.46,0.00,'2022-10-27 15:31:09','',''),(234,'1','294','1',1,'Sale Id shift 28',0.00,0.00,0.00,2370.73,0.00,'2022-10-27 15:31:09','',''),(235,'1','294','1',1,'Sale Id shift 28',0.00,0.00,0.00,1623.18,0.00,'2022-10-27 15:31:09','',''),(236,'1','294','1',1,'Sale Id shift 28',0.00,0.00,0.00,2095.25,0.00,'2022-10-27 15:31:09','',''),(237,'1','294',NULL,2,'Sale Id shift 28',1419747.30,0.00,0.00,0.00,0.00,'2022-10-27 15:31:09','',''),(238,'1','294',NULL,1,'Sale Id shift 28',1151951.50,0.00,0.00,0.00,0.00,'2022-10-27 15:31:09','',''),(239,'1','294','1',1,'Sale Id shift 29',0.00,0.00,0.00,175.05,0.00,'2022-10-27 15:37:34','',''),(240,'1','294','3',2,'Sale Id shift 29',0.00,0.00,0.00,1428.59,0.00,'2022-10-27 15:37:34','',''),(241,'1','294','3',2,'Sale Id shift 29',0.00,0.00,0.00,14.57,0.00,'2022-10-27 15:37:34','',''),(242,'1','294','1',1,'Sale Id shift 29',0.00,0.00,0.00,161.99,0.00,'2022-10-27 15:37:34','',''),(243,'1','294','1',1,'Sale Id shift 29',0.00,0.00,0.00,259.30,0.00,'2022-10-27 15:37:34','',''),(244,'1','294',NULL,2,'Sale Id shift 29',1089585.80,0.00,0.00,0.00,0.00,'2022-10-27 15:37:34','',''),(245,'1','294',NULL,1,'Sale Id shift 29',104359.50,0.00,0.00,0.00,0.00,'2022-10-27 15:37:34','',''),(246,'1','294','2',1,'Sale Id shift 30',0.00,0.00,0.00,865.76,0.00,'2022-10-27 16:00:26','',''),(247,'1','294','2',1,'Sale Id shift 30',0.00,0.00,0.00,328.15,0.00,'2022-10-27 16:00:26','',''),(248,'1','294','2',1,'Sale Id shift 30',0.00,0.00,0.00,32.00,0.00,'2022-10-27 16:00:26','',''),(249,'1','294','2',1,'Sale Id shift 30',0.00,0.00,0.00,343.35,0.00,'2022-10-27 16:00:26','',''),(250,'1','294','2',1,'Sale Id shift 30',0.00,0.00,0.00,485.84,0.00,'2022-10-27 16:00:26','',''),(251,'1','294','3',2,'Sale Id shift 30',0.00,0.00,0.00,1387.74,0.00,'2022-10-27 16:00:26','',''),(252,'1','294','3',2,'Sale Id shift 30',0.00,0.00,0.00,645.00,0.00,'2022-10-27 16:00:26','',''),(253,'1','294',NULL,2,'Sale Id shift 30',1534718.70,0.00,0.00,0.00,0.00,'2022-10-27 16:00:26','',''),(254,'1','294',NULL,1,'Sale Id shift 30',359642.50,0.00,0.00,0.00,0.00,'2022-10-27 16:00:26','',''),(255,'1','294','2',1,'Sale Id shift 31',0.00,0.00,0.00,2260.53,0.00,'2022-10-27 16:28:12','',''),(256,'1','294','2',1,'Sale Id shift 31',0.00,0.00,0.00,178.86,0.00,'2022-10-27 16:28:12','',''),(257,'1','294','2',1,'Sale Id shift 31',0.00,0.00,0.00,2075.66,0.00,'2022-10-27 16:28:12','',''),(258,'1','294','2',1,'Sale Id shift 31',0.00,0.00,0.00,866.64,0.00,'2022-10-27 16:28:12','',''),(259,'1','294','2',1,'Sale Id shift 31',0.00,0.00,0.00,206.83,0.00,'2022-10-27 16:28:12','',''),(260,'1','294','3',2,'Sale Id shift 31',0.00,0.00,0.00,783.57,0.00,'2022-10-27 16:28:12','',''),(261,'1','294','3',2,'Sale Id shift 31',0.00,0.00,0.00,681.41,0.00,'2022-10-27 16:28:12','',''),(262,'1','294','1',1,'Sale Id shift 31',0.00,0.00,0.00,18.86,0.00,'2022-10-27 16:28:12','',''),(263,'1','294',NULL,2,'Sale Id shift 31',1106059.90,0.00,0.00,0.00,0.00,'2022-10-27 16:28:12','',''),(264,'1','294',NULL,1,'Sale Id shift 31',981291.50,0.00,0.00,0.00,0.00,'2022-10-27 16:28:12','',''),(265,'1','294','2',1,'Sale Id shift 32',0.00,0.00,0.00,3759.84,0.00,'2022-10-27 16:39:10','',''),(266,'1','294','2',1,'Sale Id shift 32',0.00,0.00,0.00,2203.46,0.00,'2022-10-27 16:39:10','',''),(267,'1','294','2',1,'Sale Id shift 32',0.00,0.00,0.00,1757.03,0.00,'2022-10-27 16:39:10','',''),(268,'1','294','3',2,'Sale Id shift 32',0.00,0.00,0.00,346.68,0.00,'2022-10-27 16:39:10','',''),(269,'1','294','3',2,'Sale Id shift 32',0.00,0.00,0.00,205.36,0.00,'2022-10-27 16:39:10','',''),(270,'1','294','1',1,'Sale Id shift 32',0.00,0.00,0.00,1184.10,0.00,'2022-10-27 16:39:10','',''),(271,'1','294',NULL,2,'Sale Id shift 32',416790.20,0.00,0.00,0.00,0.00,'2022-10-27 16:39:10','',''),(272,'1','294',NULL,1,'Sale Id shift 32',1558275.25,0.00,0.00,0.00,0.00,'2022-10-27 16:39:10','',''),(273,'1','294','1',1,'Sale Id shift 33',0.00,0.00,0.00,577.74,0.00,'2022-10-27 16:47:16','',''),(274,'1','294','2',1,'Sale Id shift 33',0.00,0.00,0.00,2466.77,0.00,'2022-10-27 16:47:16','',''),(275,'1','294','2',1,'Sale Id shift 33',0.00,0.00,0.00,1431.00,0.00,'2022-10-27 16:47:16','',''),(276,'1','294','2',1,'Sale Id shift 33',0.00,0.00,0.00,1595.61,0.00,'2022-10-27 16:47:16','',''),(277,'1','294','2',1,'Sale Id shift 33',0.00,0.00,0.00,994.79,0.00,'2022-10-27 16:47:16','',''),(278,'1','294','3',2,'Sale Id shift 33',0.00,0.00,0.00,1190.97,0.00,'2022-10-27 16:47:16','',''),(279,'1','294','1',1,'Sale Id shift 33',0.00,0.00,0.00,90.90,0.00,'2022-10-27 16:47:16','',''),(280,'1','294',NULL,2,'Sale Id shift 33',899182.35,0.00,0.00,0.00,0.00,'2022-10-27 16:47:16','',''),(281,'1','294',NULL,1,'Sale Id shift 33',1252441.75,0.00,0.00,0.00,0.00,'2022-10-27 16:47:16','',''),(282,'1','294','1',1,'Sale Id shift 34',0.00,0.00,0.00,390.86,0.00,'2022-10-27 16:53:52','',''),(283,'1','294','2',1,'Sale Id shift 34',0.00,0.00,0.00,2124.36,0.00,'2022-10-27 16:53:52','',''),(284,'1','294','2',1,'Sale Id shift 34',0.00,0.00,0.00,172.72,0.00,'2022-10-27 16:53:52','',''),(285,'1','294','2',1,'Sale Id shift 34',0.00,0.00,0.00,4056.39,0.00,'2022-10-27 16:53:52','',''),(286,'1','294','2',1,'Sale Id shift 34',0.00,0.00,0.00,1983.73,0.00,'2022-10-27 16:53:52','',''),(287,'1','294','2',1,'Sale Id shift 34',0.00,0.00,0.00,1028.45,0.00,'2022-10-27 16:53:52','',''),(288,'1','294','3',2,'Sale Id shift 34',0.00,0.00,0.00,912.01,0.00,'2022-10-27 16:53:52','',''),(289,'1','294','3',2,'Sale Id shift 34',0.00,0.00,0.00,100.00,0.00,'2022-10-27 16:53:52','',''),(290,'1','294','3',2,'Sale Id shift 34',0.00,0.00,0.00,100.00,0.00,'2022-10-27 16:53:52','',''),(291,'1','294','1',1,'Sale Id shift 34',0.00,0.00,0.00,45.04,0.00,'2022-10-27 16:53:52','',''),(292,'1','294','1',1,'Sale Id shift 34',0.00,0.00,0.00,375.56,0.00,'2022-10-27 16:53:52','',''),(293,'1','294',NULL,2,'Sale Id shift 34',839567.55,0.00,0.00,0.00,0.00,'2022-10-27 16:53:52','',''),(294,'1','294',NULL,1,'Sale Id shift 34',1780994.25,0.00,0.00,0.00,0.00,'2022-10-27 16:53:52','',''),(295,'1','294','1',1,'Sale Id shift 35',0.00,0.00,0.00,2134.34,0.00,'2022-10-27 17:01:45','',''),(296,'1','294','2',1,'Sale Id shift 35',0.00,0.00,0.00,11.42,0.00,'2022-10-27 17:01:45','',''),(297,'1','294','2',1,'Sale Id shift 35',0.00,0.00,0.00,868.99,0.00,'2022-10-27 17:01:45','',''),(298,'1','294','2',1,'Sale Id shift 35',0.00,0.00,0.00,133.13,0.00,'2022-10-27 17:01:45','',''),(299,'1','294','2',1,'Sale Id shift 35',0.00,0.00,0.00,703.76,0.00,'2022-10-27 17:01:45','',''),(300,'1','294','3',2,'Sale Id shift 35',0.00,0.00,0.00,370.27,0.00,'2022-10-27 17:01:45','',''),(301,'1','294','1',1,'Sale Id shift 35',0.00,0.00,0.00,367.27,0.00,'2022-10-27 17:01:45','',''),(302,'1','294','1',1,'Sale Id shift 35',0.00,0.00,0.00,301.20,0.00,'2022-10-27 17:01:45','',''),(303,'1','294','1',1,'Sale Id shift 35',0.00,0.00,0.00,1332.11,0.00,'2022-10-27 17:01:45','',''),(304,'1','294','1',1,'Sale Id shift 35',0.00,0.00,0.00,356.55,0.00,'2022-10-27 17:01:45','',''),(305,'1','294','1',1,'Sale Id shift 35',0.00,0.00,0.00,760.92,0.00,'2022-10-27 17:01:45','',''),(306,'1','294','1',1,'Sale Id shift 35',0.00,0.00,0.00,0.22,0.00,'2022-10-27 17:01:45','',''),(307,'1','294',NULL,2,'Sale Id shift 35',279553.85,0.00,0.00,0.00,0.00,'2022-10-27 17:01:45','',''),(308,'1','294',NULL,1,'Sale Id shift 35',1219734.25,0.00,0.00,0.00,0.00,'2022-10-27 17:01:45','',''),(309,'1','294','1',1,'Sale Id shift 36',0.00,0.00,0.00,14.29,0.00,'2022-10-27 17:08:46','',''),(310,'1','294','3',2,'Sale Id shift 36',0.00,0.00,0.00,1490.78,0.00,'2022-10-27 17:08:46','',''),(311,'1','294','1',1,'Sale Id shift 36',0.00,0.00,0.00,2731.14,0.00,'2022-10-27 17:08:46','',''),(312,'1','294','1',1,'Sale Id shift 36',0.00,0.00,0.00,2646.66,0.00,'2022-10-27 17:08:46','',''),(313,'1','294','1',1,'Sale Id shift 36',0.00,0.00,0.00,432.54,0.00,'2022-10-27 17:08:46','',''),(314,'1','294','1',1,'Sale Id shift 36',0.00,0.00,0.00,2919.82,0.00,'2022-10-27 17:08:46','',''),(315,'1','294',NULL,2,'Sale Id shift 36',1125538.90,0.00,0.00,0.00,0.00,'2022-10-27 17:08:46','',''),(316,'1','294',NULL,1,'Sale Id shift 36',1530278.75,0.00,0.00,0.00,0.00,'2022-10-27 17:08:46','',''),(317,'1','294','1',1,'Sale Id shift 37',0.00,0.00,0.00,159.04,0.00,'2022-10-27 17:21:11','',''),(318,'1','294','2',1,'Sale Id shift 37',0.00,0.00,0.00,143.68,0.00,'2022-10-27 17:21:11','',''),(319,'1','294','2',1,'Sale Id shift 37',0.00,0.00,0.00,2294.89,0.00,'2022-10-27 17:21:11','',''),(320,'1','294','2',1,'Sale Id shift 37',0.00,0.00,0.00,2333.88,0.00,'2022-10-27 17:21:11','',''),(321,'1','294','2',1,'Sale Id shift 37',0.00,0.00,0.00,2078.08,0.00,'2022-10-27 17:21:11','',''),(322,'1','294','3',2,'Sale Id shift 37',0.00,0.00,0.00,371.95,0.00,'2022-10-27 17:21:11','',''),(323,'1','294','1',1,'Sale Id shift 37',0.00,0.00,0.00,122.76,0.00,'2022-10-27 17:21:11','',''),(324,'1','294','1',1,'Sale Id shift 37',0.00,0.00,0.00,86.73,0.00,'2022-10-27 17:21:11','',''),(325,'1','294',NULL,2,'Sale Id shift 37',280822.25,0.00,0.00,0.00,0.00,'2022-10-27 17:21:11','',''),(326,'1','294',NULL,1,'Sale Id shift 37',1263335.50,0.00,0.00,0.00,0.00,'2022-10-27 17:21:11','',''),(327,'1','294','2',1,'Sale Id shift 38',0.00,0.00,0.00,298.38,0.00,'2022-10-27 17:26:20','',''),(328,'1','294','2',1,'Sale Id shift 38',0.00,0.00,0.00,3009.45,0.00,'2022-10-27 17:26:20','',''),(329,'1','294','2',1,'Sale Id shift 38',0.00,0.00,0.00,469.26,0.00,'2022-10-27 17:26:20','',''),(330,'1','294','2',1,'Sale Id shift 38',0.00,0.00,0.00,2364.45,0.00,'2022-10-27 17:26:20','',''),(331,'1','294','2',1,'Sale Id shift 38',0.00,0.00,0.00,1693.87,0.00,'2022-10-27 17:26:20','',''),(332,'1','294','3',2,'Sale Id shift 38',0.00,0.00,0.00,1991.76,0.00,'2022-10-27 17:26:20','',''),(333,'1','294',NULL,2,'Sale Id shift 38',1503778.80,0.00,0.00,0.00,0.00,'2022-10-27 17:26:20','',''),(334,'1','294',NULL,1,'Sale Id shift 38',1371196.75,0.00,0.00,0.00,0.00,'2022-10-27 17:26:20','',''),(335,'1','294','2',1,'Sale Id shift 39',0.00,0.00,0.00,1582.73,0.00,'2022-10-27 17:29:42','',''),(336,'1','294','2',1,'Sale Id shift 39',0.00,0.00,0.00,1363.20,0.00,'2022-10-27 17:29:42','',''),(337,'1','294','2',1,'Sale Id shift 39',0.00,0.00,0.00,1531.70,0.00,'2022-10-27 17:29:42','',''),(338,'1','294','3',2,'Sale Id shift 39',0.00,0.00,0.00,773.22,0.00,'2022-10-27 17:29:42','',''),(339,'1','294','3',2,'Sale Id shift 39',0.00,0.00,0.00,818.21,0.00,'2022-10-27 17:29:42','',''),(340,'1','294','3',2,'Sale Id shift 39',0.00,0.00,0.00,52.98,0.00,'2022-10-27 17:29:42','',''),(341,'1','294',NULL,2,'Sale Id shift 39',1241529.55,0.00,0.00,0.00,0.00,'2022-10-27 17:29:42','',''),(342,'1','294',NULL,1,'Sale Id shift 39',783585.25,0.00,0.00,0.00,0.00,'2022-10-27 17:29:42','',''),(343,'1','294','2',1,'Sale Id shift 40',0.00,0.00,0.00,2502.75,0.00,'2022-10-27 17:32:55','',''),(344,'1','294','2',1,'Sale Id shift 40',0.00,0.00,0.00,1356.90,0.00,'2022-10-27 17:32:55','',''),(345,'1','294','2',1,'Sale Id shift 40',0.00,0.00,0.00,402.56,0.00,'2022-10-27 17:32:55','',''),(346,'1','294','2',1,'Sale Id shift 40',0.00,0.00,0.00,3782.93,0.00,'2022-10-27 17:32:55','',''),(347,'1','294','2',1,'Sale Id shift 40',0.00,0.00,0.00,1475.26,0.00,'2022-10-27 17:32:55','',''),(348,'1','294','3',2,'Sale Id shift 40',0.00,0.00,0.00,928.42,0.00,'2022-10-27 17:32:55','',''),(349,'1','294',NULL,2,'Sale Id shift 40',700957.10,0.00,0.00,0.00,0.00,'2022-10-27 17:32:55','',''),(350,'1','294',NULL,1,'Sale Id shift 40',1666070.00,0.00,0.00,0.00,0.00,'2022-10-27 17:32:55','',''),(351,'1','294','2',1,'Sale Id shift 41',0.00,0.00,0.00,2283.98,0.00,'2022-10-28 16:54:18','',''),(352,'1','294','2',1,'Sale Id shift 41',0.00,0.00,0.00,2126.65,0.00,'2022-10-28 16:54:18','',''),(353,'1','294','2',1,'Sale Id shift 41',0.00,0.00,0.00,2373.65,0.00,'2022-10-28 16:54:18','',''),(354,'1','294','3',2,'Sale Id shift 41',0.00,0.00,0.00,1045.43,0.00,'2022-10-28 16:54:18','',''),(355,'1','294','3',2,'Sale Id shift 41',0.00,0.00,0.00,252.65,0.00,'2022-10-28 16:54:18','',''),(356,'1','294',NULL,2,'Sale Id shift 41',980050.40,0.00,0.00,0.00,0.00,'2022-10-28 16:54:18','',''),(357,'1','294',NULL,1,'Sale Id shift 41',1187249.00,0.00,0.00,0.00,0.00,'2022-10-28 16:54:18','',''),(358,'1','294','2',1,'Sale Id shift 42',0.00,0.00,0.00,3205.27,0.00,'2022-10-28 17:00:34','',''),(359,'1','294','2',1,'Sale Id shift 42',0.00,0.00,0.00,29.71,0.00,'2022-10-28 17:00:34','',''),(360,'1','294','2',1,'Sale Id shift 42',0.00,0.00,0.00,651.78,0.00,'2022-10-28 17:00:34','',''),(361,'1','294','2',1,'Sale Id shift 42',0.00,0.00,0.00,4134.17,0.00,'2022-10-28 17:00:34','',''),(362,'1','294','2',1,'Sale Id shift 42',0.00,0.00,0.00,2426.38,0.00,'2022-10-28 17:00:34','',''),(363,'1','294','2',1,'Sale Id shift 42',0.00,0.00,0.00,120.83,0.00,'2022-10-28 17:00:34','',''),(364,'1','294','3',2,'Sale Id shift 42',0.00,0.00,0.00,1651.80,0.00,'2022-10-28 17:00:34','',''),(365,'1','294','3',2,'Sale Id shift 42',0.00,0.00,0.00,5.30,0.00,'2022-10-28 17:00:34','',''),(366,'1','294','3',2,'Sale Id shift 42',0.00,0.00,0.00,230.00,0.00,'2022-10-28 17:00:34','',''),(367,'1','294',NULL,2,'Sale Id shift 42',1424760.50,0.00,0.00,0.00,0.00,'2022-10-28 17:00:34','',''),(368,'1','294',NULL,1,'Sale Id shift 42',1849424.50,0.00,0.00,0.00,0.00,'2022-10-28 17:00:34','',''),(369,'1','294','2',1,'Sale Id shift 43',0.00,0.00,0.00,864.55,0.00,'2022-10-28 17:05:43','',''),(370,'1','294','2',1,'Sale Id shift 43',0.00,0.00,0.00,569.52,0.00,'2022-10-28 17:05:43','',''),(371,'1','294','2',1,'Sale Id shift 43',0.00,0.00,0.00,588.38,0.00,'2022-10-28 17:05:43','',''),(372,'1','294','3',2,'Sale Id shift 43',0.00,0.00,0.00,403.67,0.00,'2022-10-28 17:05:43','',''),(373,'1','294',NULL,2,'Sale Id shift 43',304770.85,0.00,0.00,0.00,0.00,'2022-10-28 17:05:43','',''),(374,'1','294',NULL,1,'Sale Id shift 43',353928.75,0.00,0.00,0.00,0.00,'2022-10-28 17:05:43','',''),(375,'1','294','1',1,'Sale Id shift 44',0.00,0.00,0.00,-20.55,0.00,'2022-10-28 17:11:19','',''),(376,'1','294','2',1,'Sale Id shift 44',0.00,0.00,0.00,1444.29,0.00,'2022-10-28 17:11:19','',''),(377,'1','294','2',1,'Sale Id shift 44',0.00,0.00,0.00,1267.80,0.00,'2022-10-28 17:11:19','',''),(378,'1','294','2',1,'Sale Id shift 44',0.00,0.00,0.00,179.74,0.00,'2022-10-28 17:11:19','',''),(379,'1','294','2',1,'Sale Id shift 44',0.00,0.00,0.00,1573.39,0.00,'2022-10-28 17:11:19','',''),(380,'1','294','2',1,'Sale Id shift 44',0.00,0.00,0.00,1101.77,0.00,'2022-10-28 17:11:19','',''),(381,'1','294',NULL,1,'Sale Id shift 44',970627.00,0.00,0.00,0.00,0.00,'2022-10-28 17:11:19','',''),(382,'1','294','2',1,'Sale Id shift 45',0.00,0.00,0.00,613.77,0.00,'2022-10-28 17:28:48','',''),(383,'1','294','2',1,'Sale Id shift 45',0.00,0.00,0.00,592.77,0.00,'2022-10-28 17:28:48','',''),(384,'1','294','2',1,'Sale Id shift 45',0.00,0.00,0.00,721.00,0.00,'2022-10-28 17:28:48','',''),(385,'1','294','2',1,'Sale Id shift 45',0.00,0.00,0.00,432.01,0.00,'2022-10-28 17:28:48','',''),(386,'1','294','1',1,'Sale Id shift 45',0.00,0.00,0.00,23.60,0.00,'2022-10-28 17:28:48','',''),(387,'1','294','1',1,'Sale Id shift 45',0.00,0.00,0.00,62.59,0.00,'2022-10-28 17:28:48','',''),(388,'1','294',NULL,1,'Sale Id shift 45',428004.50,0.00,0.00,0.00,0.00,'2022-10-28 17:28:48','',''),(389,'1','294','2',1,'Sale Id shift 46',0.00,0.00,0.00,2667.14,0.00,'2022-10-28 17:42:21','',''),(390,'1','294','2',1,'Sale Id shift 46',0.00,0.00,0.00,3392.62,0.00,'2022-10-28 17:42:21','',''),(391,'1','294','2',1,'Sale Id shift 46',0.00,0.00,0.00,677.51,0.00,'2022-10-28 17:42:21','',''),(392,'1','294','2',1,'Sale Id shift 46',0.00,0.00,0.00,2419.21,0.00,'2022-10-28 17:42:21','',''),(393,'1','294','2',1,'Sale Id shift 46',0.00,0.00,0.00,1767.20,0.00,'2022-10-28 17:42:21','',''),(394,'1','294','2',1,'Sale Id shift 46',0.00,0.00,0.00,151.76,0.00,'2022-10-28 17:42:21','',''),(395,'1','294',NULL,1,'Sale Id shift 46',1971428.32,0.00,0.00,0.00,0.00,'2022-10-28 17:42:21','',''),(396,'1','294','2',1,'Sale Id shift 47',0.00,0.00,0.00,2127.00,0.00,'2022-10-28 18:17:10','',''),(397,'1','294','2',1,'Sale Id shift 47',0.00,0.00,0.00,2095.27,0.00,'2022-10-28 18:17:10','',''),(398,'1','294','2',1,'Sale Id shift 47',0.00,0.00,0.00,2185.43,0.00,'2022-10-28 18:17:10','',''),(399,'1','294','2',1,'Sale Id shift 47',0.00,0.00,0.00,1508.15,0.00,'2022-10-28 18:17:10','',''),(400,'1','294',NULL,1,'Sale Id shift 47',1409021.30,0.00,0.00,0.00,0.00,'2022-10-28 18:17:10','',''),(401,'1','294','1',1,'Sale Id shift 48',0.00,0.00,0.00,1945.31,0.00,'2022-10-29 11:23:06','',''),(402,'1','294','2',1,'Sale Id shift 48',0.00,0.00,0.00,1332.58,0.00,'2022-10-29 11:23:06','',''),(403,'1','294','2',1,'Sale Id shift 48',0.00,0.00,0.00,121.80,0.00,'2022-10-29 11:23:06','',''),(404,'1','294','2',1,'Sale Id shift 48',0.00,0.00,0.00,459.72,0.00,'2022-10-29 11:23:06','',''),(405,'1','294','2',1,'Sale Id shift 48',0.00,0.00,0.00,983.70,0.00,'2022-10-29 11:23:06','',''),(406,'1','294','1',1,'Sale Id shift 48',0.00,0.00,0.00,696.03,0.00,'2022-10-29 11:23:06','',''),(407,'1','294','1',1,'Sale Id shift 48',0.00,0.00,0.00,579.57,0.00,'2022-10-29 11:23:06','',''),(408,'1','294','1',1,'Sale Id shift 48',0.00,0.00,0.00,1094.05,0.00,'2022-10-29 11:23:06','',''),(409,'1','294','1',1,'Sale Id shift 48',0.00,0.00,0.00,2367.28,0.00,'2022-10-29 11:23:06','',''),(410,'1','294',NULL,1,'Sale Id shift 48',1705247.12,0.00,0.00,0.00,0.00,'2022-10-29 11:23:06','',''),(411,'1','294','1',1,'Sale Id shift 49',0.00,0.00,0.00,1782.09,0.00,'2022-10-29 11:26:28','',''),(412,'1','294','1',1,'Sale Id shift 49',0.00,0.00,0.00,1304.49,0.00,'2022-10-29 11:26:28','',''),(413,'1','294','1',1,'Sale Id shift 49',0.00,0.00,0.00,1718.85,0.00,'2022-10-29 11:26:28','',''),(414,'1','294','1',1,'Sale Id shift 49',0.00,0.00,0.00,1878.66,0.00,'2022-10-29 11:26:28','',''),(415,'1','294',NULL,1,'Sale Id shift 49',1189768.02,0.00,0.00,0.00,0.00,'2022-10-29 11:26:28','',''),(416,'1','294','1',1,'Sale Id shift 50',0.00,0.00,0.00,2106.95,0.00,'2022-10-29 11:30:20','',''),(417,'1','294','1',1,'Sale Id shift 50',0.00,0.00,0.00,2202.03,0.00,'2022-10-29 11:30:20','',''),(418,'1','294','1',1,'Sale Id shift 50',0.00,0.00,0.00,1822.10,0.00,'2022-10-29 11:30:20','',''),(419,'1','294','1',1,'Sale Id shift 50',0.00,0.00,0.00,618.58,0.00,'2022-10-29 11:30:20','',''),(420,'1','294','1',1,'Sale Id shift 50',0.00,0.00,0.00,1632.97,0.00,'2022-10-29 11:30:20','',''),(421,'1','294',NULL,1,'Sale Id shift 50',1492108.14,0.00,0.00,0.00,0.00,'2022-10-29 11:30:20','',''),(422,'1','294','1',1,'Sale Id shift 51',0.00,0.00,0.00,1175.63,0.00,'2022-10-29 11:33:09','',''),(423,'1','294','1',1,'Sale Id shift 51',0.00,0.00,0.00,1720.43,0.00,'2022-10-29 11:33:09','',''),(424,'1','294','1',1,'Sale Id shift 51',0.00,0.00,0.00,2127.35,0.00,'2022-10-29 11:33:09','',''),(425,'1','294','1',1,'Sale Id shift 51',0.00,0.00,0.00,1553.93,0.00,'2022-10-29 11:33:09','',''),(426,'1','294',NULL,1,'Sale Id shift 51',1170766.52,0.00,0.00,0.00,0.00,'2022-10-29 11:33:09','',''),(427,'1','294','1',1,'Sale Id shift 52',0.00,0.00,0.00,629.23,0.00,'2022-10-29 11:41:02','',''),(428,'1','294','2',1,'Sale Id shift 52',0.00,0.00,0.00,1315.02,0.00,'2022-10-29 11:41:02','',''),(429,'1','294','2',1,'Sale Id shift 52',0.00,0.00,0.00,1767.57,0.00,'2022-10-29 11:41:02','',''),(430,'1','294','2',1,'Sale Id shift 52',0.00,0.00,0.00,16.85,0.00,'2022-10-29 11:41:02','',''),(431,'1','294','2',1,'Sale Id shift 52',0.00,0.00,0.00,1653.33,0.00,'2022-10-29 11:41:02','',''),(432,'1','294','2',1,'Sale Id shift 52',0.00,0.00,0.00,1067.62,0.00,'2022-10-29 11:41:02','',''),(433,'1','294','2',1,'Sale Id shift 52',0.00,0.00,0.00,1053.29,0.00,'2022-10-29 11:41:02','',''),(434,'1','294','1',1,'Sale Id shift 52',0.00,0.00,0.00,277.95,0.00,'2022-10-29 11:41:02','',''),(435,'1','294','1',1,'Sale Id shift 52',0.00,0.00,0.00,387.56,0.00,'2022-10-29 11:41:02','',''),(436,'1','294','1',1,'Sale Id shift 52',0.00,0.00,0.00,439.09,0.00,'2022-10-29 11:41:02','',''),(437,'1','294',NULL,1,'Sale Id shift 52',1532136.78,0.00,0.00,0.00,0.00,'2022-10-29 11:41:02','',''),(438,'1','294','2',1,'Sale Id shift 53',0.00,0.00,0.00,2327.93,0.00,'2022-10-29 11:44:04','',''),(439,'1','294','2',1,'Sale Id shift 53',0.00,0.00,0.00,1275.91,0.00,'2022-10-29 11:44:04','',''),(440,'1','294','2',1,'Sale Id shift 53',0.00,0.00,0.00,2137.50,0.00,'2022-10-29 11:44:04','',''),(441,'1','294','2',1,'Sale Id shift 53',0.00,0.00,0.00,1602.70,0.00,'2022-10-29 11:44:04','',''),(442,'1','294',NULL,1,'Sale Id shift 53',1307239.12,0.00,0.00,0.00,0.00,'2022-10-29 11:44:04','',''),(443,'1','294','2',1,'Sale Id shift 54',0.00,0.00,0.00,1606.52,0.00,'2022-10-29 11:48:02','',''),(444,'1','294','2',1,'Sale Id shift 54',0.00,0.00,0.00,2227.84,0.00,'2022-10-29 11:48:02','',''),(445,'1','294','2',1,'Sale Id shift 54',0.00,0.00,0.00,2737.96,0.00,'2022-10-29 11:48:02','',''),(446,'1','294','2',1,'Sale Id shift 54',0.00,0.00,0.00,1307.79,0.00,'2022-10-29 11:48:02','',''),(447,'1','294','2',1,'Sale Id shift 54',0.00,0.00,0.00,475.74,0.00,'2022-10-29 11:48:02','',''),(448,'1','294',NULL,1,'Sale Id shift 54',1487341.30,0.00,0.00,0.00,0.00,'2022-10-29 11:48:02','',''),(449,'1','294','2',1,'Sale Id shift 55',0.00,0.00,0.00,1237.06,0.00,'2022-10-29 11:52:17','',''),(450,'1','294','2',1,'Sale Id shift 55',0.00,0.00,0.00,1943.16,0.00,'2022-10-29 11:52:17','',''),(451,'1','294','2',1,'Sale Id shift 55',0.00,0.00,0.00,1198.21,0.00,'2022-10-29 11:52:17','',''),(452,'1','294','2',1,'Sale Id shift 55',0.00,0.00,0.00,1269.26,0.00,'2022-10-29 11:52:17','',''),(453,'1','294','2',1,'Sale Id shift 55',0.00,0.00,0.00,169.03,0.00,'2022-10-29 11:52:17','',''),(454,'1','294','3',2,'Sale Id shift 55',0.00,0.00,0.00,2076.53,0.00,'2022-10-29 11:52:17','',''),(455,'1','294',NULL,2,'Sale Id shift 55',1598928.10,0.00,0.00,0.00,0.00,'2022-10-29 11:52:17','',''),(456,'1','294',NULL,1,'Sale Id shift 55',1035376.16,0.00,0.00,0.00,0.00,'2022-10-29 11:52:17','',''),(457,'1','294','2',1,'Sale Id shift 56',0.00,0.00,0.00,2360.56,0.00,'2022-10-29 11:55:40','',''),(458,'1','294','2',1,'Sale Id shift 56',0.00,0.00,0.00,1167.55,0.00,'2022-10-29 11:55:40','',''),(459,'1','294','2',1,'Sale Id shift 56',0.00,0.00,0.00,570.90,0.00,'2022-10-29 11:55:40','',''),(460,'1','294','2',1,'Sale Id shift 56',0.00,0.00,0.00,1778.67,0.00,'2022-10-29 11:55:40','',''),(461,'1','294','2',1,'Sale Id shift 56',0.00,0.00,0.00,1391.84,0.00,'2022-10-29 11:55:40','',''),(462,'1','294','2',1,'Sale Id shift 56',0.00,0.00,0.00,196.58,0.00,'2022-10-29 11:55:40','',''),(463,'1','294','3',2,'Sale Id shift 56',0.00,0.00,0.00,1959.36,0.00,'2022-10-29 11:55:40','',''),(464,'1','294',NULL,2,'Sale Id shift 56',1508707.20,0.00,0.00,0.00,0.00,'2022-10-29 11:55:40','',''),(465,'1','294',NULL,1,'Sale Id shift 56',1328965.80,0.00,0.00,0.00,0.00,'2022-10-29 11:55:40','',''),(466,'1','294','2',1,'Sale Id shift 57',0.00,0.00,0.00,1965.11,0.00,'2022-10-29 12:12:05','',''),(467,'1','294','2',1,'Sale Id shift 57',0.00,0.00,0.00,49.44,0.00,'2022-10-29 12:12:05','',''),(468,'1','294','2',1,'Sale Id shift 57',0.00,0.00,0.00,2556.72,0.00,'2022-10-29 12:12:05','',''),(469,'1','294','2',1,'Sale Id shift 57',0.00,0.00,0.00,1662.63,0.00,'2022-10-29 12:12:05','',''),(470,'1','294','2',1,'Sale Id shift 57',0.00,0.00,0.00,134.31,0.00,'2022-10-29 12:12:05','',''),(471,'1','294','3',2,'Sale Id shift 57',0.00,0.00,0.00,349.36,0.00,'2022-10-29 12:12:05','',''),(472,'1','294',NULL,2,'Sale Id shift 57',269007.20,0.00,0.00,0.00,0.00,'2022-10-29 12:12:05','',''),(473,'1','294',NULL,1,'Sale Id shift 57',1133541.38,0.00,0.00,0.00,0.00,'2022-10-29 12:12:05','',''),(474,'1','294','3',2,'Sale Id shift 58',0.00,0.00,0.00,567.97,0.00,'2022-10-29 12:14:52','',''),(475,'1','294',NULL,2,'Sale Id shift 58',443016.60,0.00,0.00,0.00,0.00,'2022-10-29 12:14:52','',''),(476,'1','294','2',1,'Sale Id shift 59',0.00,0.00,0.00,2583.77,0.00,'2022-10-29 12:17:37','',''),(477,'1','294','2',1,'Sale Id shift 59',0.00,0.00,0.00,1703.55,0.00,'2022-10-29 12:17:37','',''),(478,'1','294','2',1,'Sale Id shift 59',0.00,0.00,0.00,1515.46,0.00,'2022-10-29 12:17:37','',''),(479,'1','294','2',1,'Sale Id shift 59',0.00,0.00,0.00,1369.35,0.00,'2022-10-29 12:17:37','',''),(480,'1','294','3',2,'Sale Id shift 59',0.00,0.00,0.00,1688.07,0.00,'2022-10-29 12:17:37','',''),(481,'1','294',NULL,2,'Sale Id shift 59',1316694.60,0.00,0.00,0.00,0.00,'2022-10-29 12:17:37','',''),(482,'1','294',NULL,1,'Sale Id shift 59',1276639.14,0.00,0.00,0.00,0.00,'2022-10-29 12:17:37','',''),(483,'1','294','2',1,'Sale Id shift 60',0.00,0.00,0.00,2025.01,0.00,'2022-10-29 12:24:10','',''),(484,'1','294','2',1,'Sale Id shift 60',0.00,0.00,0.00,186.77,0.00,'2022-10-29 12:24:10','',''),(485,'1','294','2',1,'Sale Id shift 60',0.00,0.00,0.00,1758.91,0.00,'2022-10-29 12:24:10','',''),(486,'1','294','2',1,'Sale Id shift 60',0.00,0.00,0.00,2122.65,0.00,'2022-10-29 12:24:10','',''),(487,'1','294','3',2,'Sale Id shift 60',0.00,0.00,0.00,703.85,0.00,'2022-10-29 12:24:10','',''),(488,'1','294',NULL,2,'Sale Id shift 60',549003.00,0.00,0.00,0.00,0.00,'2022-10-29 12:24:10','',''),(489,'1','294',NULL,1,'Sale Id shift 60',1084614.52,0.00,0.00,0.00,0.00,'2022-10-29 12:24:10','',''),(490,'1','294','2',1,'Sale Id shift 61',0.00,0.00,0.00,3305.66,0.00,'2022-10-29 12:28:18','',''),(491,'1','294','2',1,'Sale Id shift 61',0.00,0.00,0.00,205.89,0.00,'2022-10-29 12:28:18','',''),(492,'1','294','2',1,'Sale Id shift 61',0.00,0.00,0.00,1994.79,0.00,'2022-10-29 12:28:18','',''),(493,'1','294','2',1,'Sale Id shift 61',0.00,0.00,0.00,1384.64,0.00,'2022-10-29 12:28:18','',''),(494,'1','294','2',1,'Sale Id shift 61',0.00,0.00,0.00,67.98,0.00,'2022-10-29 12:28:18','',''),(495,'1','294','3',2,'Sale Id shift 61',0.00,0.00,0.00,3031.28,0.00,'2022-10-29 12:28:18','',''),(496,'1','294',NULL,2,'Sale Id shift 61',2364398.40,0.00,0.00,0.00,0.00,'2022-10-29 12:28:18','',''),(497,'1','294',NULL,1,'Sale Id shift 61',1238694.88,0.00,0.00,0.00,0.00,'2022-10-29 12:28:18','',''),(498,'1','294',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8400000.00,48000.00,0.00,0.00,'2022-10-29 12:29:20','',''),(499,'1','294',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,10500000.00,60000.00,0.00,0.00,'2022-10-29 12:29:34','',''),(500,'1','294','2',1,'Sale Id shift 63',0.00,0.00,0.00,2276.17,0.00,'2022-10-29 12:36:17','',''),(501,'1','294','2',1,'Sale Id shift 63',0.00,0.00,0.00,1787.26,0.00,'2022-10-29 12:36:17','',''),(502,'1','294','2',1,'Sale Id shift 63',0.00,0.00,0.00,1588.77,0.00,'2022-10-29 12:36:17','',''),(503,'1','294','3',2,'Sale Id shift 63',0.00,0.00,0.00,1423.99,0.00,'2022-10-29 12:36:17','',''),(504,'1','294',NULL,2,'Sale Id shift 63',1110712.20,0.00,0.00,0.00,0.00,'2022-10-29 12:36:17','',''),(505,'1','294',NULL,1,'Sale Id shift 63',989135.00,0.00,0.00,0.00,0.00,'2022-10-29 12:36:17','',''),(506,'1','294','2',1,'Sale Id shift 64',0.00,0.00,0.00,1961.50,0.00,'2022-10-29 12:39:23','',''),(507,'1','294','2',1,'Sale Id shift 64',0.00,0.00,0.00,267.29,0.00,'2022-10-29 12:39:23','',''),(508,'1','294','2',1,'Sale Id shift 64',0.00,0.00,0.00,2015.50,0.00,'2022-10-29 12:39:23','',''),(509,'1','294','2',1,'Sale Id shift 64',0.00,0.00,0.00,370.59,0.00,'2022-10-29 12:39:23','',''),(510,'1','294','2',1,'Sale Id shift 64',0.00,0.00,0.00,2107.32,0.00,'2022-10-29 12:39:23','',''),(511,'1','294','3',2,'Sale Id shift 64',0.00,0.00,0.00,582.39,0.00,'2022-10-29 12:39:23','',''),(512,'1','294','3',2,'Sale Id shift 64',0.00,0.00,0.00,503.87,0.00,'2022-10-29 12:39:23','',''),(513,'1','294',NULL,2,'Sale Id shift 64',847282.80,0.00,0.00,0.00,0.00,'2022-10-29 12:39:23','',''),(514,'1','294',NULL,1,'Sale Id shift 64',1176385.00,0.00,0.00,0.00,0.00,'2022-10-29 12:39:23','',''),(515,'1','294','3',2,'Sale Id shift 65',0.00,0.00,0.00,1909.76,0.00,'2022-10-29 12:42:29','',''),(516,'1','294',NULL,2,'Sale Id shift 65',1489612.80,0.00,0.00,0.00,0.00,'2022-10-29 12:42:29','',''),(517,'1','294','3',2,'Sale Id shift 66',0.00,0.00,0.00,1462.26,0.00,'2022-10-29 12:44:02','',''),(518,'1','294',NULL,2,'Sale Id shift 66',1140562.80,0.00,0.00,0.00,0.00,'2022-10-29 12:44:02','',''),(519,'1','294','3',2,'Sale Id shift 67',0.00,0.00,0.00,230.77,0.00,'2022-10-29 12:45:40','',''),(520,'1','294',NULL,2,'Sale Id shift 67',180000.60,0.00,0.00,0.00,0.00,'2022-10-29 12:45:40','',''),(521,'1','294','2',1,'Sale Id shift 68',0.00,0.00,0.00,1554.79,0.00,'2022-10-29 12:49:45','',''),(522,'1','294','2',1,'Sale Id shift 68',0.00,0.00,0.00,163.25,0.00,'2022-10-29 12:49:45','',''),(523,'1','294','2',1,'Sale Id shift 68',0.00,0.00,0.00,1724.30,0.00,'2022-10-29 12:49:45','',''),(524,'1','294','2',1,'Sale Id shift 68',0.00,0.00,0.00,1192.37,0.00,'2022-10-29 12:49:45','',''),(525,'1','294','2',1,'Sale Id shift 68',0.00,0.00,0.00,294.44,0.00,'2022-10-29 12:49:45','',''),(526,'1','294','3',2,'Sale Id shift 68',0.00,0.00,0.00,767.71,0.00,'2022-10-29 12:49:45','',''),(527,'1','294',NULL,2,'Sale Id shift 68',598813.80,0.00,0.00,0.00,0.00,'2022-10-29 12:49:45','',''),(528,'1','294',NULL,1,'Sale Id shift 68',862601.25,0.00,0.00,0.00,0.00,'2022-10-29 12:49:45','',''),(529,'1','294','2',1,'Sale Id shift 69',0.00,0.00,0.00,1632.47,0.00,'2022-10-29 12:52:39','',''),(530,'1','294','2',1,'Sale Id shift 69',0.00,0.00,0.00,167.58,0.00,'2022-10-29 12:52:39','',''),(531,'1','294','2',1,'Sale Id shift 69',0.00,0.00,0.00,1700.90,0.00,'2022-10-29 12:52:39','',''),(532,'1','294','2',1,'Sale Id shift 69',0.00,0.00,0.00,1875.17,0.00,'2022-10-29 12:52:39','',''),(533,'1','294','3',2,'Sale Id shift 69',0.00,0.00,0.00,401.54,0.00,'2022-10-29 12:52:39','',''),(534,'1','294',NULL,2,'Sale Id shift 69',313201.20,0.00,0.00,0.00,0.00,'2022-10-29 12:52:39','',''),(535,'1','294',NULL,1,'Sale Id shift 69',940821.00,0.00,0.00,0.00,0.00,'2022-10-29 12:52:39','',''),(536,'1','294','2',1,'Sale Id shift 70',0.00,0.00,0.00,2088.45,0.00,'2022-10-29 13:03:01','',''),(537,'1','294','2',1,'Sale Id shift 70',0.00,0.00,0.00,690.64,0.00,'2022-10-29 13:03:01','',''),(538,'1','294','2',1,'Sale Id shift 70',0.00,0.00,0.00,2031.33,0.00,'2022-10-29 13:03:01','',''),(539,'1','294','2',1,'Sale Id shift 70',0.00,0.00,0.00,1901.34,0.00,'2022-10-29 13:03:01','',''),(540,'1','294','2',1,'Sale Id shift 70',0.00,0.00,0.00,1701.64,0.00,'2022-10-29 13:03:01','',''),(541,'1','294','3',2,'Sale Id shift 70',0.00,0.00,0.00,1103.61,0.00,'2022-10-29 13:03:01','',''),(542,'1','294','3',2,'Sale Id shift 70',0.00,0.00,0.00,580.77,0.00,'2022-10-29 13:03:01','',''),(543,'1','294',NULL,2,'Sale Id shift 70',1313816.40,0.00,0.00,0.00,0.00,'2022-10-29 13:03:01','',''),(544,'1','294',NULL,1,'Sale Id shift 70',1472345.00,0.00,0.00,0.00,0.00,'2022-10-29 13:03:01','',''),(545,'1','294','2',1,'Sale Id shift 71',0.00,0.00,0.00,2287.78,0.00,'2022-10-29 14:50:27','',''),(546,'1','294','2',1,'Sale Id shift 71',0.00,0.00,0.00,1659.74,0.00,'2022-10-29 14:50:27','',''),(547,'1','294','2',1,'Sale Id shift 71',0.00,0.00,0.00,2365.16,0.00,'2022-10-29 14:50:27','',''),(548,'1','294','3',2,'Sale Id shift 71',0.00,0.00,0.00,620.14,0.00,'2022-10-29 14:50:27','',''),(549,'1','294',NULL,2,'Sale Id shift 71',483709.20,0.00,0.00,0.00,0.00,'2022-10-29 14:50:27','',''),(550,'1','294',NULL,1,'Sale Id shift 71',1104719.00,0.00,0.00,0.00,0.00,'2022-10-29 14:50:27','',''),(551,'1','294','2',1,'Sale Id shift 72',0.00,0.00,0.00,2509.19,0.00,'2022-10-29 15:13:12','',''),(552,'1','294','2',1,'Sale Id shift 72',0.00,0.00,0.00,1128.20,0.00,'2022-10-29 15:13:12','',''),(553,'1','294','2',1,'Sale Id shift 72',0.00,0.00,0.00,1819.71,0.00,'2022-10-29 15:13:12','',''),(554,'1','294','2',1,'Sale Id shift 72',0.00,0.00,0.00,1773.99,0.00,'2022-10-29 15:13:12','',''),(555,'1','294','2',1,'Sale Id shift 72',0.00,0.00,0.00,1065.77,0.00,'2022-10-29 15:13:12','',''),(556,'1','294','3',2,'Sale Id shift 72',0.00,0.00,0.00,373.58,0.00,'2022-10-29 15:13:12','',''),(557,'1','294',NULL,2,'Sale Id shift 72',291392.40,0.00,0.00,0.00,0.00,'2022-10-29 15:13:12','',''),(558,'1','294',NULL,1,'Sale Id shift 72',1451950.50,0.00,0.00,0.00,0.00,'2022-10-29 15:13:12','',''),(559,'1','294','2',1,'Sale Id shift 73',0.00,0.00,0.00,1448.83,0.00,'2022-10-29 15:15:56','',''),(560,'1','294','2',1,'Sale Id shift 73',0.00,0.00,0.00,1588.92,0.00,'2022-10-29 15:15:56','',''),(561,'1','294','2',1,'Sale Id shift 73',0.00,0.00,0.00,97.57,0.00,'2022-10-29 15:15:56','',''),(562,'1','294','2',1,'Sale Id shift 73',0.00,0.00,0.00,2091.96,0.00,'2022-10-29 15:15:56','',''),(563,'1','294','2',1,'Sale Id shift 73',0.00,0.00,0.00,1388.03,0.00,'2022-10-29 15:15:56','',''),(564,'1','294',NULL,1,'Sale Id shift 73',1157679.25,0.00,0.00,0.00,0.00,'2022-10-29 15:15:56','',''),(565,'1','294','2',1,'Sale Id shift 74',0.00,0.00,0.00,2513.65,0.00,'2022-10-29 15:21:07','',''),(566,'1','294','2',1,'Sale Id shift 74',0.00,0.00,0.00,383.68,0.00,'2022-10-29 15:21:07','',''),(567,'1','294','2',1,'Sale Id shift 74',0.00,0.00,0.00,1722.97,0.00,'2022-10-29 15:21:07','',''),(568,'1','294','2',1,'Sale Id shift 74',0.00,0.00,0.00,1008.45,0.00,'2022-10-29 15:21:07','',''),(569,'1','294','2',1,'Sale Id shift 74',0.00,0.00,0.00,2370.05,0.00,'2022-10-29 15:21:07','',''),(570,'1','294',NULL,1,'Sale Id shift 74',1399790.00,0.00,0.00,0.00,0.00,'2022-10-29 15:21:07','',''),(571,'1','294','2',1,'Sale Id shift 75',0.00,0.00,0.00,1416.91,0.00,'2022-10-29 15:23:31','',''),(572,'1','294','2',1,'Sale Id shift 75',0.00,0.00,0.00,1513.42,0.00,'2022-10-29 15:23:31','',''),(573,'1','294','2',1,'Sale Id shift 75',0.00,0.00,0.00,222.73,0.00,'2022-10-29 15:23:31','',''),(574,'1','294','2',1,'Sale Id shift 75',0.00,0.00,0.00,1943.45,0.00,'2022-10-29 15:23:31','',''),(575,'1','294','2',1,'Sale Id shift 75',0.00,0.00,0.00,1291.00,0.00,'2022-10-29 15:23:31','',''),(576,'1','294',NULL,1,'Sale Id shift 75',1117814.25,0.00,0.00,0.00,0.00,'2022-10-29 15:23:31','',''),(577,'1','294',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,10680000.00,60000.00,0.00,0.00,'2022-10-29 15:23:53','',''),(578,'1','294',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,15785000.00,20500.00,0.00,0.00,'2022-10-29 15:24:17','',''),(579,'1','294',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,2598800.00,14600.00,0.00,0.00,'2022-10-29 15:24:35','',''),(580,'1','294',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,10680000.00,60000.00,0.00,0.00,'2022-10-29 15:25:04','',''),(581,'1','294','2',1,'Sale Id shift 76',0.00,0.00,0.00,1263.17,0.00,'2022-10-29 15:25:24','',''),(582,'1','294','2',1,'Sale Id shift 76',0.00,0.00,0.00,1333.44,0.00,'2022-10-29 15:25:24','',''),(583,'1','294','2',1,'Sale Id shift 76',0.00,0.00,0.00,595.98,0.00,'2022-10-29 15:25:24','',''),(584,'1','294','2',1,'Sale Id shift 76',0.00,0.00,0.00,1304.61,0.00,'2022-10-29 15:25:24','',''),(585,'1','294','2',1,'Sale Id shift 76',0.00,0.00,0.00,1452.63,0.00,'2022-10-29 15:25:24','',''),(586,'1','294',NULL,1,'Sale Id shift 76',1041220.25,0.00,0.00,0.00,0.00,'2022-10-29 15:25:24','',''),(587,'1','294',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,10680000.00,60000.00,0.00,0.00,'2022-10-29 15:25:46','',''),(588,'1','294',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,23200000.00,29000.00,0.00,0.00,'2022-10-29 15:26:03','',''),(589,'1','294',NULL,1,'Reception corrector for bridging 9',0.00,0.00,0.00,48000.00,0.00,'2022-10-31 11:39:29','',''),(590,'1','294','2',1,'Received from bridging 9',0.00,0.00,48000.00,0.00,0.00,'2022-10-31 11:39:29','',''),(591,'1','294',NULL,1,'Reception corrector for bridging 2',0.00,0.00,0.00,32500.00,0.00,'2022-10-31 11:40:02','',''),(592,'1','294','2',1,'Received from bridging 2',0.00,0.00,32500.00,0.00,0.00,'2022-10-31 11:40:02','',''),(593,'1','294',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,30000.00,0.00,'2022-10-31 11:40:19','',''),(594,'1','294','1',1,'Received from bridging 10',0.00,0.00,30000.00,0.00,0.00,'2022-10-31 11:40:19','',''),(595,'1','294',NULL,2,'Reception corrector for bridging 3',0.00,0.00,0.00,45000.00,0.00,'2022-10-31 11:40:52','',''),(596,'1','294','3',2,'Received from bridging 3',0.00,0.00,45000.00,0.00,0.00,'2022-10-31 11:40:52','',''),(597,'1','294',NULL,1,'Reception corrector for bridging 4',0.00,0.00,0.00,45000.00,0.00,'2022-10-31 11:41:20','',''),(598,'1','294','1',1,'Received from bridging 4',0.00,0.00,45000.00,0.00,0.00,'2022-10-31 11:41:20','',''),(599,'1','294',NULL,1,'Reception corrector for bridging 11',0.00,0.00,0.00,30000.00,0.00,'2022-10-31 11:41:42','',''),(600,'1','294','2',1,'Received from bridging 11',0.00,0.00,30000.00,0.00,0.00,'2022-10-31 11:41:42','',''),(601,'1','294',NULL,1,'Reception corrector for bridging 5',0.00,0.00,0.00,15000.00,0.00,'2022-10-31 11:41:54','',''),(602,'1','294','1',1,'Received from bridging 5',0.00,0.00,15000.00,0.00,0.00,'2022-10-31 11:41:54','',''),(603,'1','294',NULL,1,'Reception corrector for bridging 1',0.00,0.00,0.00,17500.00,0.00,'2022-10-31 11:42:00','',''),(604,'1','294','1',1,'Received from bridging 1',0.00,0.00,17500.00,0.00,0.00,'2022-10-31 11:42:00','',''),(605,'1','294',NULL,1,'Reception corrector for bridging 6',0.00,0.00,0.00,45000.00,0.00,'2022-10-31 11:42:15','',''),(606,'1','294','2',1,'Received from bridging 6',0.00,0.00,45000.00,0.00,0.00,'2022-10-31 11:42:15','',''),(607,'1','294',NULL,1,'Reception corrector for bridging 7',0.00,0.00,0.00,17000.00,0.00,'2022-10-31 11:42:34','',''),(608,'1','294','1',1,'Received from bridging 7',0.00,0.00,17000.00,0.00,0.00,'2022-10-31 11:42:34','',''),(609,'1','294',NULL,1,'Reception corrector for bridging 8',0.00,0.00,0.00,33000.00,0.00,'2022-10-31 11:42:47','',''),(610,'1','294','2',1,'Received from bridging 8',0.00,0.00,33000.00,0.00,0.00,'2022-10-31 11:42:47','',''),(611,'1','294',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,16000000.00,20000.00,0.00,0.00,'2022-10-31 11:43:39','',''),(612,'1','294',NULL,2,'Reception corrector for bridging 12',0.00,0.00,0.00,20000.00,0.00,'2022-10-31 11:47:21','',''),(613,'1','294','3',2,'Received from bridging 12',0.00,0.00,20000.00,0.00,0.00,'2022-10-31 11:47:21','',''),(614,'1','294',NULL,1,'Reception corrector for bridging 13',0.00,0.00,0.00,60000.00,0.00,'2022-10-31 11:55:55','',''),(615,'1','294','2',1,'Received from bridging 13',0.00,0.00,60000.00,0.00,0.00,'2022-10-31 11:55:55','',''),(616,'1','294',NULL,2,'Reception corrector for bridging 14',0.00,0.00,0.00,20500.00,0.00,'2022-10-31 12:02:35','',''),(617,'1','294','3',2,'Received from bridging 14',0.00,0.00,20500.00,0.00,0.00,'2022-10-31 12:02:35','',''),(618,'1','294',NULL,1,'Reception corrector for bridging 15',0.00,0.00,0.00,14600.00,0.00,'2022-10-31 12:10:27','',''),(619,'1','294','2',1,'Received from bridging 15',0.00,0.00,14600.00,0.00,0.00,'2022-10-31 12:10:27','',''),(620,'1','294',NULL,1,'Reception corrector for bridging 16',0.00,0.00,0.00,30000.00,0.00,'2022-10-31 12:11:09','',''),(621,'1','294','2',1,'Received from bridging 16',0.00,0.00,30000.00,0.00,0.00,'2022-10-31 12:11:09','',''),(622,'1','294',NULL,1,'Reception corrector for bridging 17',0.00,0.00,0.00,30000.00,0.00,'2022-10-31 12:13:12','',''),(623,'1','294','2',1,'Received from bridging 17',0.00,0.00,30000.00,0.00,0.00,'2022-10-31 12:13:12','',''),(624,'1','294',NULL,1,'Reception corrector for bridging 18',0.00,0.00,0.00,60000.00,0.00,'2022-10-31 12:15:01','',''),(625,'1','294','2',1,'Received from bridging 18',0.00,0.00,60000.00,0.00,0.00,'2022-10-31 12:15:01','',''),(626,'1','294',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,12000000.00,15000.00,0.00,0.00,'2022-10-31 12:40:19','',''),(627,'1','294','2',1,'Sale Id shift 80',0.00,0.00,0.00,760.18,0.00,'2022-10-31 13:28:26','',''),(628,'1','294','2',1,'Sale Id shift 80',0.00,0.00,0.00,0.19,0.00,'2022-10-31 13:28:26','',''),(629,'1','294','2',1,'Sale Id shift 80',0.00,0.00,0.00,511.35,0.00,'2022-10-31 13:28:26','',''),(630,'1','294','2',1,'Sale Id shift 80',0.00,0.00,0.00,765.64,0.00,'2022-10-31 13:28:26','',''),(631,'1','294','2',1,'Sale Id shift 80',0.00,0.00,0.00,617.19,0.00,'2022-10-31 13:28:26','',''),(632,'1','294','2',1,'Sale Id shift 80',0.00,0.00,0.00,1903.23,0.00,'2022-10-31 13:28:26','',''),(633,'1','294',NULL,1,'Sale Id shift 80',811284.84,0.00,0.00,0.00,0.00,'2022-10-31 13:28:26','',''),(634,'1','294','2',1,'Sale Id shift 81',0.00,0.00,0.00,2437.85,0.00,'2022-10-31 14:14:52','',''),(635,'1','294','2',1,'Sale Id shift 81',0.00,0.00,0.00,1826.53,0.00,'2022-10-31 14:14:52','',''),(636,'1','294','2',1,'Sale Id shift 81',0.00,0.00,0.00,168.34,0.00,'2022-10-31 14:14:52','',''),(637,'1','294','2',1,'Sale Id shift 81',0.00,0.00,0.00,2235.26,0.00,'2022-10-31 14:14:52','',''),(638,'1','294','2',1,'Sale Id shift 81',0.00,0.00,0.00,1669.66,0.00,'2022-10-31 14:14:52','',''),(639,'1','294','2',1,'Sale Id shift 81',0.00,0.00,0.00,430.49,0.00,'2022-10-31 14:14:52','',''),(640,'1','294',NULL,1,'Sale Id shift 81',1560727.14,0.00,0.00,0.00,0.00,'2022-10-31 14:14:52','',''),(641,'1','294','2',1,'Sale Id shift 82',0.00,0.00,0.00,2337.16,0.00,'2022-10-31 14:23:41','',''),(642,'1','294','2',1,'Sale Id shift 82',0.00,0.00,0.00,1245.38,0.00,'2022-10-31 14:23:41','',''),(643,'1','294','2',1,'Sale Id shift 82',0.00,0.00,0.00,677.75,0.00,'2022-10-31 14:23:41','',''),(644,'1','294','2',1,'Sale Id shift 82',0.00,0.00,0.00,2606.27,0.00,'2022-10-31 14:23:41','',''),(645,'1','294','2',1,'Sale Id shift 82',0.00,0.00,0.00,3521.29,0.00,'2022-10-31 14:23:41','',''),(646,'1','294','3',2,'Sale Id shift 82',0.00,0.00,0.00,2258.02,0.00,'2022-10-31 14:23:41','',''),(647,'1','294','3',2,'Sale Id shift 82',0.00,0.00,0.00,450.00,0.00,'2022-10-31 14:23:41','',''),(648,'1','294',NULL,2,'Sale Id shift 82',2166416.00,0.00,0.00,0.00,0.00,'2022-10-31 14:23:41','',''),(649,'1','294',NULL,1,'Sale Id shift 82',1849037.30,0.00,0.00,0.00,0.00,'2022-10-31 14:23:41','',''),(650,'1','294','2',1,'Sale Id shift 83',0.00,0.00,0.00,1985.38,0.00,'2022-10-31 14:28:56','',''),(651,'1','294','2',1,'Sale Id shift 83',0.00,0.00,0.00,1420.72,0.00,'2022-10-31 14:28:56','',''),(652,'1','294','2',1,'Sale Id shift 83',0.00,0.00,0.00,124.92,0.00,'2022-10-31 14:28:56','',''),(653,'1','294','2',1,'Sale Id shift 83',0.00,0.00,0.00,3231.17,0.00,'2022-10-31 14:28:56','',''),(654,'1','294','2',1,'Sale Id shift 83',0.00,0.00,0.00,313.04,0.00,'2022-10-31 14:28:56','',''),(655,'1','294','2',1,'Sale Id shift 83',0.00,0.00,0.00,2862.90,0.00,'2022-10-31 14:28:56','',''),(656,'1','294','3',2,'Sale Id shift 83',0.00,0.00,0.00,2295.18,0.00,'2022-10-31 14:28:56','',''),(657,'1','294',NULL,2,'Sale Id shift 83',1836144.00,0.00,0.00,0.00,0.00,'2022-10-31 14:28:56','',''),(658,'1','294',NULL,1,'Sale Id shift 83',1768987.14,0.00,0.00,0.00,0.00,'2022-10-31 14:28:56','',''),(659,'1','294','2',1,'Sale Id shift 84',0.00,0.00,0.00,2442.09,0.00,'2022-10-31 14:33:35','',''),(660,'1','294','2',1,'Sale Id shift 84',0.00,0.00,0.00,575.95,0.00,'2022-10-31 14:33:35','',''),(661,'1','294','2',1,'Sale Id shift 84',0.00,0.00,0.00,3660.94,0.00,'2022-10-31 14:33:35','',''),(662,'1','294','2',1,'Sale Id shift 84',0.00,0.00,0.00,318.28,0.00,'2022-10-31 14:33:35','',''),(663,'1','294','2',1,'Sale Id shift 84',0.00,0.00,0.00,2643.86,0.00,'2022-10-31 14:33:35','',''),(664,'1','294','3',2,'Sale Id shift 84',0.00,0.00,0.00,1447.12,0.00,'2022-10-31 14:33:35','',''),(665,'1','294',NULL,2,'Sale Id shift 84',1157696.00,0.00,0.00,0.00,0.00,'2022-10-31 14:33:35','',''),(666,'1','294',NULL,1,'Sale Id shift 84',1716119.36,0.00,0.00,0.00,0.00,'2022-10-31 14:33:35','',''),(667,'1','294','2',1,'Sale Id shift 85',0.00,0.00,0.00,3507.52,0.00,'2022-10-31 14:41:09','',''),(668,'1','294','2',1,'Sale Id shift 85',0.00,0.00,0.00,56.55,0.00,'2022-10-31 14:41:09','',''),(669,'1','294','2',1,'Sale Id shift 85',0.00,0.00,0.00,2838.15,0.00,'2022-10-31 14:41:09','',''),(670,'1','294','2',1,'Sale Id shift 85',0.00,0.00,0.00,2234.98,0.00,'2022-10-31 14:41:09','',''),(671,'1','294','2',1,'Sale Id shift 85',0.00,0.00,0.00,387.20,0.00,'2022-10-31 14:41:09','',''),(672,'1','294','3',2,'Sale Id shift 85',0.00,0.00,0.00,1137.05,0.00,'2022-10-31 14:41:09','',''),(673,'1','294',NULL,2,'Sale Id shift 85',909640.00,0.00,0.00,0.00,0.00,'2022-10-31 14:41:09','',''),(674,'1','294',NULL,1,'Sale Id shift 85',1606343.20,0.00,0.00,0.00,0.00,'2022-10-31 14:41:09','',''),(675,'1','294','2',1,'Sale Id shift 86',0.00,0.00,0.00,2835.86,0.00,'2022-10-31 14:45:58','',''),(676,'1','294','2',1,'Sale Id shift 86',0.00,0.00,0.00,877.02,0.00,'2022-10-31 14:45:58','',''),(677,'1','294','2',1,'Sale Id shift 86',0.00,0.00,0.00,1808.14,0.00,'2022-10-31 14:45:58','',''),(678,'1','294','2',1,'Sale Id shift 86',0.00,0.00,0.00,2113.57,0.00,'2022-10-31 14:45:58','',''),(679,'1','294','2',1,'Sale Id shift 86',0.00,0.00,0.00,167.76,0.00,'2022-10-31 14:45:58','',''),(680,'1','294','3',2,'Sale Id shift 86',0.00,0.00,0.00,917.01,0.00,'2022-10-31 14:45:58','',''),(681,'1','294',NULL,2,'Sale Id shift 86',733608.00,0.00,0.00,0.00,0.00,'2022-10-31 14:45:58','',''),(682,'1','294',NULL,1,'Sale Id shift 86',1388818.30,0.00,0.00,0.00,0.00,'2022-10-31 14:45:58','',''),(683,'1','294','2',1,'Sale Id shift 87',0.00,0.00,0.00,43.37,0.00,'2022-10-31 14:59:31','',''),(684,'1','294','2',1,'Sale Id shift 87',0.00,0.00,0.00,44.19,0.00,'2022-10-31 14:59:31','',''),(685,'1','294','3',2,'Sale Id shift 87',0.00,0.00,0.00,1130.06,0.00,'2022-10-31 14:59:31','',''),(686,'1','294',NULL,2,'Sale Id shift 87',904048.00,0.00,0.00,0.00,0.00,'2022-10-31 14:59:31','',''),(687,'1','294',NULL,1,'Sale Id shift 87',15585.68,0.00,0.00,0.00,0.00,'2022-10-31 14:59:31','',''),(688,'1','294','3',2,'Sale Id shift 88',0.00,0.00,0.00,837.67,0.00,'2022-10-31 15:04:15','',''),(689,'1','294',NULL,2,'Sale Id shift 88',670136.00,0.00,0.00,0.00,0.00,'2022-10-31 15:04:15','',''),(690,'1','294','3',2,'Sale Id shift 89',0.00,0.00,0.00,1150.50,0.00,'2022-10-31 15:13:36','',''),(691,'1','294',NULL,2,'Sale Id shift 89',920400.00,0.00,0.00,0.00,0.00,'2022-10-31 15:13:36','',''),(692,'1','294','3',2,'Sale Id shift 90',0.00,0.00,0.00,807.70,0.00,'2022-10-31 15:17:59','',''),(693,'1','294','3',2,'Sale Id shift 90',0.00,0.00,0.00,415.15,0.00,'2022-10-31 15:17:59','',''),(694,'1','294','3',2,'Sale Id shift 90',0.00,0.00,0.00,520.00,0.00,'2022-10-31 15:17:59','',''),(695,'1','294','3',2,'Sale Id shift 90',0.00,0.00,0.00,20.00,0.00,'2022-10-31 15:17:59','',''),(696,'1','294',NULL,2,'Sale Id shift 90',1410280.00,0.00,0.00,0.00,0.00,'2022-10-31 15:17:59','',''),(697,'1','294','3',2,'Sale Id shift 91',0.00,0.00,0.00,395.25,0.00,'2022-10-31 15:19:49','',''),(698,'1','294',NULL,2,'Sale Id shift 91',316200.00,0.00,0.00,0.00,0.00,'2022-10-31 15:19:49','',''),(699,'1','294','3',2,'Sale Id shift 92',0.00,0.00,0.00,1006.11,0.00,'2022-10-31 15:28:30','',''),(700,'1','294',NULL,2,'Sale Id shift 92',804888.00,0.00,0.00,0.00,0.00,'2022-10-31 15:28:30','',''),(701,'1','294','3',2,'Sale Id shift 93',0.00,0.00,0.00,1170.45,0.00,'2022-10-31 15:30:37','',''),(702,'1','294',NULL,2,'Sale Id shift 93',936360.00,0.00,0.00,0.00,0.00,'2022-10-31 15:30:37','',''),(703,'1','294','3',2,'Sale Id shift 94',0.00,0.00,0.00,1693.25,0.00,'2022-10-31 15:36:45','',''),(704,'1','294',NULL,2,'Sale Id shift 94',1354600.00,0.00,0.00,0.00,0.00,'2022-10-31 15:36:45','',''),(705,'1','294','3',2,'Sale Id shift 95',0.00,0.00,0.00,1303.96,0.00,'2022-10-31 15:41:27','',''),(706,'1','294',NULL,2,'Sale Id shift 95',1043168.00,0.00,0.00,0.00,0.00,'2022-10-31 15:41:27','',''),(707,'1','294',NULL,2,'Reception corrector for bridging 19',0.00,0.00,0.00,29000.00,0.00,'2022-10-31 15:52:23','',''),(708,'1','294','3',2,'Received from bridging 19',0.00,0.00,29000.00,0.00,0.00,'2022-10-31 15:52:23','',''),(709,'1','294','3',2,'Sale Id shift 96',0.00,0.00,0.00,1398.68,0.00,'2022-10-31 15:56:20','',''),(710,'1','294','3',2,'Sale Id shift 96',0.00,0.00,0.00,480.00,0.00,'2022-10-31 15:56:20','',''),(711,'1','294',NULL,2,'Sale Id shift 96',1502944.00,0.00,0.00,0.00,0.00,'2022-10-31 15:56:20','',''),(712,'1','294','3',2,'Sale Id shift 97',0.00,0.00,0.00,955.00,0.00,'2022-10-31 22:32:15','',''),(713,'1','294','3',2,'Sale Id shift 97',0.00,0.00,0.00,176.00,0.00,'2022-10-31 22:32:15','',''),(714,'1','294',NULL,2,'Sale Id shift 97',904800.00,0.00,0.00,0.00,0.00,'2022-10-31 22:32:15','',''),(715,'1','294','3',2,'Sale Id shift 98',0.00,0.00,0.00,2964.17,0.00,'2022-11-01 13:35:11','',''),(716,'1','294','3',2,'Sale Id shift 98',0.00,0.00,0.00,155.70,0.00,'2022-11-01 13:35:11','',''),(717,'1','294',NULL,2,'Sale Id shift 98',2495896.00,0.00,0.00,0.00,0.00,'2022-11-01 13:35:11','',''),(718,'1','294','3',2,'Sale Id shift 99',0.00,0.00,0.00,1600.14,0.00,'2022-11-01 14:36:50','',''),(719,'1','294',NULL,2,'Sale Id shift 99',1280112.00,0.00,0.00,0.00,0.00,'2022-11-01 14:36:50','',''),(720,'1','294','3',2,'Sale Id shift 100',0.00,0.00,0.00,1938.44,0.00,'2022-11-01 17:46:57','',''),(721,'1','294','3',2,'Sale Id shift 100',0.00,0.00,0.00,10.00,0.00,'2022-11-01 17:46:57','',''),(722,'1','294','3',2,'Sale Id shift 100',0.00,0.00,0.00,645.75,0.00,'2022-11-01 17:46:57','',''),(723,'1','294',NULL,2,'Sale Id shift 100',2075352.00,0.00,0.00,0.00,0.00,'2022-11-01 17:46:57','',''),(724,'1','294',NULL,2,'Reception corrector for bridging 20',0.00,0.00,0.00,14900.00,0.00,'2022-11-01 17:50:03','',''),(725,'1','294','3',2,'Received from bridging 20',0.00,0.00,14900.00,0.00,0.00,'2022-11-01 17:50:03','',''),(726,'1','294','3',2,'Sale Id shift 101',0.00,0.00,0.00,2707.44,0.00,'2022-11-01 18:04:34','',''),(727,'1','294','3',2,'Sale Id shift 101',0.00,0.00,0.00,100.00,0.00,'2022-11-01 18:04:34','',''),(728,'1','294',NULL,2,'Sale Id shift 101',2245952.00,0.00,0.00,0.00,0.00,'2022-11-01 18:04:34','',''),(729,'1','294','3',2,'Sale Id shift 102',0.00,0.00,0.00,759.00,0.00,'2022-11-01 18:07:47','',''),(730,'1','294',NULL,2,'Sale Id shift 102',607200.00,0.00,0.00,0.00,0.00,'2022-11-01 18:07:47','',''),(731,'1','294','3',2,'Sale Id shift 103',0.00,0.00,0.00,1029.41,0.00,'2022-11-01 18:10:14','',''),(732,'1','294','3',2,'Sale Id shift 103',0.00,0.00,0.00,20.00,0.00,'2022-11-01 18:10:14','',''),(733,'1','294','3',2,'Sale Id shift 103',0.00,0.00,0.00,778.95,0.00,'2022-11-01 18:10:14','',''),(734,'1','294','3',2,'Sale Id shift 103',0.00,0.00,0.00,10.00,0.00,'2022-11-01 18:10:14','',''),(735,'1','294',NULL,2,'Sale Id shift 103',1470688.00,0.00,0.00,0.00,0.00,'2022-11-01 18:10:14','',''),(736,'1','294','3',2,'Sale Id shift 104',0.00,0.00,0.00,398.25,0.00,'2022-11-01 18:12:03','',''),(737,'1','294',NULL,2,'Sale Id shift 104',318600.00,0.00,0.00,0.00,0.00,'2022-11-01 18:12:03','',''),(738,'1','294','3',2,'Sale Id shift 105',0.00,0.00,0.00,2317.27,0.00,'2022-11-04 23:53:33','',''),(739,'1','294','3',2,'Sale Id shift 105',0.00,0.00,0.00,100.00,0.00,'2022-11-04 23:53:33','',''),(740,'1','294','3',2,'Sale Id shift 105',0.00,0.00,0.00,1380.13,0.00,'2022-11-04 23:53:33','',''),(741,'1','294',NULL,2,'Sale Id shift 105',3037920.00,0.00,0.00,0.00,0.00,'2022-11-04 23:53:33','',''),(742,'1','294','3',2,'Sale Id shift 106',0.00,0.00,0.00,2466.53,0.00,'2022-11-05 10:20:31','',''),(743,'1','294','3',2,'Sale Id shift 106',0.00,0.00,0.00,365.00,0.00,'2022-11-05 10:20:31','',''),(744,'1','294',NULL,2,'Sale Id shift 106',2265224.00,0.00,0.00,0.00,0.00,'2022-11-05 10:20:31','',''),(745,'1','294','3',2,'Sale Id shift 107',0.00,0.00,0.00,2312.59,0.00,'2022-11-05 10:37:26','',''),(746,'1','294','3',2,'Sale Id shift 107',0.00,0.00,0.00,2736.50,0.00,'2022-11-05 10:37:26','',''),(747,'1','294','3',2,'Sale Id shift 107',0.00,0.00,0.00,408.50,0.00,'2022-11-05 10:37:26','',''),(748,'1','294','3',2,'Sale Id shift 107',0.00,0.00,0.00,2169.38,0.00,'2022-11-05 10:37:26','',''),(749,'1','294',NULL,2,'Sale Id shift 107',6101576.00,0.00,0.00,0.00,0.00,'2022-11-05 10:37:26','',''),(750,'1','294','3',2,'Sale Id shift 108',0.00,0.00,0.00,1913.90,0.00,'2022-11-05 10:43:59','',''),(751,'1','294',NULL,2,'Sale Id shift 108',1531120.00,0.00,0.00,0.00,0.00,'2022-11-05 10:43:59','',''),(752,'1','294','3',2,'Sale Id shift 109',0.00,0.00,0.00,4185.78,0.00,'2022-11-05 15:30:30','',''),(753,'1','294','3',2,'Sale Id shift 109',0.00,0.00,0.00,765.54,0.00,'2022-11-05 15:30:30','',''),(754,'1','294','3',2,'Sale Id shift 109',0.00,0.00,0.00,1177.10,0.00,'2022-11-05 15:30:30','',''),(755,'1','294',NULL,2,'Sale Id shift 109',4902736.00,0.00,0.00,0.00,0.00,'2022-11-05 15:30:30','',''),(756,'1','294','3',2,'Sale Id shift 110',0.00,0.00,0.00,1015.75,0.00,'2022-11-07 20:00:21','',''),(757,'1','294',NULL,2,'Sale Id shift 110',812600.00,0.00,0.00,0.00,0.00,'2022-11-07 20:00:21','',''),(758,'1','294','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,5939.04,0.00,'2022-11-07 20:35:14','',''),(759,'1','294','3',0,'Inventory adjustment from tank dipping to 6321',0.00,0.00,6321.00,0.00,0.00,'2022-11-07 20:35:14','',''),(760,'1','294','3',2,'Sale Id shift 111',0.00,0.00,0.00,3687.46,0.00,'2022-11-07 20:40:14','',''),(761,'1','294','3',2,'Sale Id shift 111',0.00,0.00,0.00,69.98,0.00,'2022-11-07 20:40:14','',''),(762,'1','294','3',2,'Sale Id shift 111',0.00,0.00,0.00,478.00,0.00,'2022-11-07 20:40:14','',''),(763,'1','294','3',2,'Sale Id shift 111',0.00,0.00,0.00,2084.78,0.00,'2022-11-07 20:40:14','',''),(764,'1','294',NULL,2,'Sale Id shift 111',5056176.00,0.00,0.00,0.00,0.00,'2022-11-07 20:40:14','',''),(765,'1','294',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9250000.00,50000.00,0.00,0.00,'2022-11-07 22:05:48','',''),(766,'1','294',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,40000000.00,50000.00,0.00,0.00,'2022-11-07 22:10:14','',''),(767,'1','294',NULL,1,'Reception corrector for bridging 21',0.00,0.00,0.00,50000.00,0.00,'2022-11-07 22:24:57','',''),(768,'1','294','2',1,'Received from bridging 21',0.00,0.00,50000.00,0.00,0.00,'2022-11-07 22:24:57','',''),(769,'1','294',NULL,2,'Reception corrector for bridging 22',0.00,0.00,0.00,50000.00,0.00,'2022-11-07 22:26:14','',''),(770,'1','294','3',2,'Received from bridging 22',0.00,0.00,50000.00,0.00,0.00,'2022-11-07 22:26:14','',''),(771,'1','294','2',1,'Sale Id shift 112',0.00,0.00,0.00,1482.04,0.00,'2022-11-08 06:32:59','',''),(772,'1','294','2',1,'Sale Id shift 112',0.00,0.00,0.00,667.48,0.00,'2022-11-08 06:32:59','',''),(773,'1','294','3',2,'Sale Id shift 112',0.00,0.00,0.00,1005.00,0.00,'2022-11-08 06:32:59','',''),(774,'1','294','3',2,'Sale Id shift 112',0.00,0.00,0.00,1376.25,0.00,'2022-11-08 06:32:59','',''),(775,'1','294','3',2,'Sale Id shift 112',0.00,0.00,0.00,179.25,0.00,'2022-11-08 06:32:59','',''),(776,'1','294',NULL,2,'Sale Id shift 112',2048400.00,0.00,0.00,0.00,0.00,'2022-11-08 06:32:59','',''),(777,'1','294',NULL,1,'Sale Id shift 112',397661.20,0.00,0.00,0.00,0.00,'2022-11-08 06:32:59','',''),(778,'1','294','2',1,'Sale Id shift 113',0.00,0.00,0.00,771.02,0.00,'2022-11-08 16:27:19','',''),(779,'1','294','2',1,'Sale Id shift 113',0.00,0.00,0.00,4080.77,0.00,'2022-11-08 16:27:19','',''),(780,'1','294','2',1,'Sale Id shift 113',0.00,0.00,0.00,2509.76,0.00,'2022-11-08 16:27:19','',''),(781,'1','294','2',1,'Sale Id shift 113',0.00,0.00,0.00,2470.77,0.00,'2022-11-08 16:27:19','',''),(782,'1','294','2',1,'Sale Id shift 113',0.00,0.00,0.00,2407.49,0.00,'2022-11-08 16:27:19','',''),(783,'1','294','2',1,'Sale Id shift 113',0.00,0.00,0.00,180.75,0.00,'2022-11-08 16:27:19','',''),(784,'1','294','3',2,'Sale Id shift 113',0.00,0.00,0.00,1906.23,0.00,'2022-11-08 16:27:19','',''),(785,'1','294','3',2,'Sale Id shift 113',0.00,0.00,0.00,414.00,0.00,'2022-11-08 16:27:19','',''),(786,'1','294','3',2,'Sale Id shift 113',0.00,0.00,0.00,489.02,0.00,'2022-11-08 16:27:19','',''),(787,'1','294',NULL,2,'Sale Id shift 113',2247400.00,0.00,0.00,0.00,0.00,'2022-11-08 16:27:19','',''),(788,'1','294',NULL,1,'Sale Id shift 113',2297803.60,0.00,0.00,0.00,0.00,'2022-11-08 16:27:19','',''),(789,'1','294','2',1,'Sale Id shift 114',0.00,0.00,0.00,1377.48,0.00,'2022-11-09 11:45:47','',''),(790,'1','294','2',1,'Sale Id shift 114',0.00,0.00,0.00,1286.86,0.00,'2022-11-09 11:45:47','',''),(791,'1','294','2',1,'Sale Id shift 114',0.00,0.00,0.00,151.50,0.00,'2022-11-09 11:45:47','',''),(792,'1','294','3',2,'Sale Id shift 114',0.00,0.00,0.00,3950.86,0.00,'2022-11-09 11:45:47','',''),(793,'1','294','3',2,'Sale Id shift 114',0.00,0.00,0.00,2074.25,0.00,'2022-11-09 11:45:47','',''),(794,'1','294',NULL,2,'Sale Id shift 114',4820088.00,0.00,0.00,0.00,0.00,'2022-11-09 11:45:47','',''),(795,'1','294',NULL,1,'Sale Id shift 114',520930.40,0.00,0.00,0.00,0.00,'2022-11-09 11:45:47','',''),(796,'1','294','2',1,'Sale Id shift 115',0.00,0.00,0.00,2194.05,0.00,'2022-11-09 17:45:22','',''),(797,'1','294','2',1,'Sale Id shift 115',0.00,0.00,0.00,2821.04,0.00,'2022-11-09 17:45:22','',''),(798,'1','294','2',1,'Sale Id shift 115',0.00,0.00,0.00,3626.45,0.00,'2022-11-09 17:45:22','',''),(799,'1','294','2',1,'Sale Id shift 115',0.00,0.00,0.00,10.81,0.00,'2022-11-09 17:45:22','',''),(800,'1','294','3',2,'Sale Id shift 115',0.00,0.00,0.00,3050.21,0.00,'2022-11-09 17:45:22','',''),(801,'1','294',NULL,2,'Sale Id shift 115',2440168.00,0.00,0.00,0.00,0.00,'2022-11-09 17:45:22','',''),(802,'1','294',NULL,1,'Sale Id shift 115',1600684.75,0.00,0.00,0.00,0.00,'2022-11-09 17:45:22','',''),(803,'1','294','2',1,'Sale Id shift 116',0.00,0.00,0.00,2299.74,0.00,'2022-11-10 13:33:25','',''),(804,'1','294','2',1,'Sale Id shift 116',0.00,0.00,0.00,2044.73,0.00,'2022-11-10 13:33:25','',''),(805,'1','294','2',1,'Sale Id shift 116',0.00,0.00,0.00,1746.97,0.00,'2022-11-10 13:33:25','',''),(806,'1','294','3',2,'Sale Id shift 116',0.00,0.00,0.00,3738.82,0.00,'2022-11-10 13:33:25','',''),(807,'1','294','3',2,'Sale Id shift 116',0.00,0.00,0.00,1398.00,0.00,'2022-11-10 13:33:25','',''),(808,'1','294','3',2,'Sale Id shift 116',0.00,0.00,0.00,453.00,0.00,'2022-11-10 13:33:25','',''),(809,'1','294',NULL,2,'Sale Id shift 116',4471856.00,0.00,0.00,0.00,0.00,'2022-11-10 13:33:25','',''),(810,'1','294',NULL,1,'Sale Id shift 116',1126916.40,0.00,0.00,0.00,0.00,'2022-11-10 13:33:25','',''),(811,'1','294','2',1,'Sale Id shift 117',0.00,0.00,0.00,3270.01,0.00,'2022-11-10 20:09:30','',''),(812,'1','294','2',1,'Sale Id shift 117',0.00,0.00,0.00,3232.42,0.00,'2022-11-10 20:09:30','',''),(813,'1','294','2',1,'Sale Id shift 117',0.00,0.00,0.00,3209.72,0.00,'2022-11-10 20:09:30','',''),(814,'1','294','2',1,'Sale Id shift 117',0.00,0.00,0.00,2809.55,0.00,'2022-11-10 20:09:30','',''),(815,'1','294','2',1,'Sale Id shift 117',0.00,0.00,0.00,3252.53,0.00,'2022-11-10 20:09:30','',''),(816,'1','294','2',1,'Sale Id shift 117',0.00,0.00,0.00,202.68,0.00,'2022-11-10 20:09:30','',''),(817,'1','294','3',2,'Sale Id shift 117',0.00,0.00,0.00,2436.93,0.00,'2022-11-10 20:09:30','',''),(818,'1','294','3',2,'Sale Id shift 117',0.00,0.00,0.00,1726.36,0.00,'2022-11-10 20:09:30','',''),(819,'1','294','3',2,'Sale Id shift 117',0.00,0.00,0.00,1600.00,0.00,'2022-11-10 20:09:30','',''),(820,'1','294',NULL,2,'Sale Id shift 117',4610632.00,0.00,0.00,0.00,0.00,'2022-11-10 20:09:30','',''),(821,'1','294',NULL,1,'Sale Id shift 117',2955728.35,0.00,0.00,0.00,0.00,'2022-11-10 20:09:30','',''),(822,'1','294','2',1,'Sale Id shift 118',0.00,0.00,0.00,1245.97,0.00,'2022-11-11 15:36:06','',''),(823,'1','294','2',1,'Sale Id shift 118',0.00,0.00,0.00,30.21,0.00,'2022-11-11 15:36:06','',''),(824,'1','294','2',1,'Sale Id shift 118',0.00,0.00,0.00,759.76,0.00,'2022-11-11 15:36:06','',''),(825,'1','294','2',1,'Sale Id shift 118',0.00,0.00,0.00,0.52,0.00,'2022-11-11 15:36:06','',''),(826,'1','294','3',2,'Sale Id shift 118',0.00,0.00,0.00,2478.97,0.00,'2022-11-11 15:36:06','',''),(827,'1','294','3',2,'Sale Id shift 118',0.00,0.00,0.00,907.39,0.00,'2022-11-11 15:36:06','',''),(828,'1','294',NULL,2,'Sale Id shift 118',2912269.60,0.00,0.00,0.00,0.00,'2022-11-11 15:36:06','',''),(829,'1','294',NULL,1,'Sale Id shift 118',376745.10,0.00,0.00,0.00,0.00,'2022-11-11 15:36:06','',''),(830,'1','294','3',2,'Sale Id shift 119',0.00,0.00,0.00,1752.21,0.00,'2022-11-11 18:26:10','',''),(831,'1','294','3',2,'Sale Id shift 119',0.00,0.00,0.00,1080.01,0.00,'2022-11-11 18:26:10','',''),(832,'1','294',NULL,2,'Sale Id shift 119',2435709.20,0.00,0.00,0.00,0.00,'2022-11-11 18:26:10','',''),(833,'1','294','3',2,'Sale Id shift 120',0.00,0.00,0.00,2675.76,0.00,'2022-11-12 09:38:29','',''),(834,'1','294','3',2,'Sale Id shift 120',0.00,0.00,0.00,794.89,0.00,'2022-11-12 09:38:29','',''),(835,'1','294',NULL,2,'Sale Id shift 120',2984759.00,0.00,0.00,0.00,0.00,'2022-11-12 09:38:29','',''),(836,'1','294','3',2,'Sale Id shift 121',0.00,0.00,0.00,837.06,0.00,'2022-11-13 07:48:18','',''),(837,'1','294',NULL,2,'Sale Id shift 121',719871.60,0.00,0.00,0.00,0.00,'2022-11-13 07:48:18','',''),(838,'1','294','3',2,'Sale Id shift 122',0.00,0.00,0.00,1890.06,0.00,'2022-11-13 15:00:57','',''),(839,'1','294',NULL,2,'Sale Id shift 122',1625451.60,0.00,0.00,0.00,0.00,'2022-11-13 15:00:57','',''),(840,'1','294','3',2,'Sale Id shift 123',0.00,0.00,0.00,634.03,0.00,'2022-11-13 15:19:17','',''),(841,'1','294',NULL,2,'Sale Id shift 123',545265.80,0.00,0.00,0.00,0.00,'2022-11-13 15:19:17','',''),(842,'1','294','3',2,'Sale Id shift 124',0.00,0.00,0.00,1293.54,0.00,'2022-11-13 23:25:59','',''),(843,'1','294','3',2,'Sale Id shift 124',0.00,0.00,0.00,200.00,0.00,'2022-11-13 23:25:59','',''),(844,'1','294',NULL,2,'Sale Id shift 124',1284444.40,0.00,0.00,0.00,0.00,'2022-11-13 23:25:59','',''),(845,'1','294','3',2,'Sale Id shift 125',0.00,0.00,0.00,1634.11,0.00,'2022-11-14 20:09:46','',''),(846,'1','294',NULL,2,'Sale Id shift 125',1405334.60,0.00,0.00,0.00,0.00,'2022-11-14 20:09:46','',''),(847,'1','294','3',2,'Sale Id shift 126',0.00,0.00,0.00,1760.00,0.00,'2022-11-15 10:47:49','',''),(848,'1','294','3',2,'Sale Id shift 126',0.00,0.00,0.00,510.00,0.00,'2022-11-15 10:47:49','',''),(849,'1','294',NULL,2,'Sale Id shift 126',1952200.00,0.00,0.00,0.00,0.00,'2022-11-15 10:47:49','',''),(850,'1','294','3',2,'Sale Id shift 127',0.00,0.00,0.00,1616.03,0.00,'2022-11-15 18:48:17','',''),(851,'1','294',NULL,2,'Sale Id shift 127',1389785.80,0.00,0.00,0.00,0.00,'2022-11-15 18:48:17','',''),(852,'1','294',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,4773000.00,25800.00,0.00,0.00,'2022-11-15 22:50:47','',''),(853,'1','294',NULL,1,'Reception corrector for bridging 23',0.00,0.00,0.00,25800.00,0.00,'2022-11-16 00:39:51','',''),(854,'1','294','2',1,'Received from bridging 23',0.00,0.00,25800.00,0.00,0.00,'2022-11-16 00:39:51','',''),(855,'1','294','3',2,'Sale Id shift 128',0.00,0.00,0.00,1532.30,0.00,'2022-11-16 14:11:49','',''),(856,'1','294','3',2,'Sale Id shift 128',0.00,0.00,0.00,20.00,0.00,'2022-11-16 14:11:49','',''),(857,'1','294','3',2,'Sale Id shift 128',0.00,0.00,0.00,290.81,0.00,'2022-11-16 14:11:49','',''),(858,'1','294',NULL,2,'Sale Id shift 128',1585074.60,0.00,0.00,0.00,0.00,'2022-11-16 14:11:49','',''),(859,'1','294','2',1,'Sale Id shift 129',0.00,0.00,0.00,194.10,0.00,'2022-11-16 20:29:43','',''),(860,'1','294','2',1,'Sale Id shift 129',0.00,0.00,0.00,2293.40,0.00,'2022-11-16 20:29:43','',''),(861,'1','294','2',1,'Sale Id shift 129',0.00,0.00,0.00,2451.72,0.00,'2022-11-16 20:29:43','',''),(862,'1','294','2',1,'Sale Id shift 129',0.00,0.00,0.00,2328.30,0.00,'2022-11-16 20:29:43','',''),(863,'1','294','3',2,'Sale Id shift 129',0.00,0.00,0.00,959.20,0.00,'2022-11-16 20:29:43','',''),(864,'1','294','3',2,'Sale Id shift 129',0.00,0.00,0.00,990.53,0.00,'2022-11-16 20:29:43','',''),(865,'1','294',NULL,2,'Sale Id shift 129',1608527.25,0.00,0.00,0.00,0.00,'2022-11-16 20:29:43','',''),(866,'1','294',NULL,1,'Sale Id shift 129',1344491.20,0.00,0.00,0.00,0.00,'2022-11-16 20:29:43','',''),(867,'1','294',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,41250000.00,50000.00,0.00,0.00,'2022-11-16 20:39:45','',''),(868,'1','294',NULL,2,'Reception corrector for bridging 24',0.00,0.00,0.00,50000.00,0.00,'2022-11-17 11:52:53','',''),(869,'1','294','3',2,'Received from bridging 24',0.00,0.00,50000.00,0.00,0.00,'2022-11-17 11:52:53','',''),(870,'1','294','2',1,'Sale Id shift 130',0.00,0.00,0.00,1067.68,0.00,'2022-11-17 14:42:24','',''),(871,'1','294','2',1,'Sale Id shift 130',0.00,0.00,0.00,72.06,0.00,'2022-11-17 14:42:24','',''),(872,'1','294','2',1,'Sale Id shift 130',0.00,0.00,0.00,364.15,0.00,'2022-11-17 14:42:24','',''),(873,'1','294','2',1,'Sale Id shift 130',0.00,0.00,0.00,507.93,0.00,'2022-11-17 14:42:24','',''),(874,'1','294','3',2,'Sale Id shift 130',0.00,0.00,0.00,1151.81,0.00,'2022-11-17 14:42:24','',''),(875,'1','294','3',2,'Sale Id shift 130',0.00,0.00,0.00,1212.85,0.00,'2022-11-17 14:42:24','',''),(876,'1','294',NULL,2,'Sale Id shift 130',1950844.50,0.00,0.00,0.00,0.00,'2022-11-17 14:42:24','',''),(877,'1','294',NULL,1,'Sale Id shift 130',372186.70,0.00,0.00,0.00,0.00,'2022-11-17 14:42:24','',''),(878,'1','294','2',1,'Sale Id shift 131',0.00,0.00,0.00,3476.58,0.00,'2022-11-17 17:31:33','',''),(879,'1','294','2',1,'Sale Id shift 131',0.00,0.00,0.00,302.38,0.00,'2022-11-17 17:31:33','',''),(880,'1','294','2',1,'Sale Id shift 131',0.00,0.00,0.00,3272.45,0.00,'2022-11-17 17:31:33','',''),(881,'1','294','2',1,'Sale Id shift 131',0.00,0.00,0.00,2531.19,0.00,'2022-11-17 17:31:33','',''),(882,'1','294','3',2,'Sale Id shift 131',0.00,0.00,0.00,1022.24,0.00,'2022-11-17 17:31:33','',''),(883,'1','294','3',2,'Sale Id shift 131',0.00,0.00,0.00,952.91,0.00,'2022-11-17 17:31:33','',''),(884,'1','294',NULL,2,'Sale Id shift 131',1629498.75,0.00,0.00,0.00,0.00,'2022-11-17 17:31:33','',''),(885,'1','294',NULL,1,'Sale Id shift 131',1772781.00,0.00,0.00,0.00,0.00,'2022-11-17 17:31:33','',''),(886,'1','294','3',2,'Sale Id shift 132',0.00,0.00,0.00,1190.53,0.00,'2022-11-18 12:21:26','',''),(887,'1','294','3',2,'Sale Id shift 132',0.00,0.00,0.00,320.00,0.00,'2022-11-18 12:21:26','',''),(888,'1','294','3',2,'Sale Id shift 132',0.00,0.00,0.00,80.00,0.00,'2022-11-18 12:21:26','',''),(889,'1','294',NULL,2,'Sale Id shift 132',1312187.25,0.00,0.00,0.00,0.00,'2022-11-18 12:21:26','',''),(890,'1','294','2',1,'Sale Id shift 133',0.00,0.00,0.00,2800.17,0.00,'2022-11-18 21:30:37','',''),(891,'1','294','2',1,'Sale Id shift 133',0.00,0.00,0.00,2236.71,0.00,'2022-11-18 21:30:37','',''),(892,'1','294','2',1,'Sale Id shift 133',0.00,0.00,0.00,2017.55,0.00,'2022-11-18 21:30:37','',''),(893,'1','294','2',1,'Sale Id shift 133',0.00,0.00,0.00,1.43,0.00,'2022-11-18 21:30:37','',''),(894,'1','294','3',2,'Sale Id shift 133',0.00,0.00,0.00,2021.00,0.00,'2022-11-18 21:30:37','',''),(895,'1','294',NULL,2,'Sale Id shift 133',1667325.00,0.00,0.00,0.00,0.00,'2022-11-18 21:30:37','',''),(896,'1','294',NULL,1,'Sale Id shift 133',1305334.10,0.00,0.00,0.00,0.00,'2022-11-18 21:30:37','',''),(897,'1','294','3',2,'Sale Id shift 134',0.00,0.00,0.00,2426.05,0.00,'2022-11-19 12:32:54','',''),(898,'1','294','3',2,'Sale Id shift 134',0.00,0.00,0.00,534.24,0.00,'2022-11-19 12:32:54','',''),(899,'1','294',NULL,2,'Sale Id shift 134',2442239.25,0.00,0.00,0.00,0.00,'2022-11-19 12:32:54','',''),(900,'1','294','3',2,'Sale Id shift 135',0.00,0.00,0.00,683.33,0.00,'2022-11-19 13:10:36','',''),(901,'1','294','3',2,'Sale Id shift 135',0.00,0.00,0.00,1416.86,0.00,'2022-11-19 13:10:36','',''),(902,'1','294',NULL,2,'Sale Id shift 135',1764159.60,0.00,0.00,0.00,0.00,'2022-11-19 13:10:36','',''),(903,'1','294','3',2,'Sale Id shift 136',0.00,0.00,0.00,1202.62,0.00,'2022-11-19 18:55:12','',''),(904,'1','294',NULL,2,'Sale Id shift 136',1010200.80,0.00,0.00,0.00,0.00,'2022-11-19 18:55:12','',''),(905,'1','294','3',2,'Sale Id shift 137',0.00,0.00,0.00,1330.60,0.00,'2022-11-20 15:42:30','',''),(906,'1','294','3',2,'Sale Id shift 137',0.00,0.00,0.00,164.64,0.00,'2022-11-20 15:42:30','',''),(907,'1','294',NULL,2,'Sale Id shift 137',1256001.60,0.00,0.00,0.00,0.00,'2022-11-20 15:42:30','',''),(908,'1','294','3',2,'Sale Id shift 138',0.00,0.00,0.00,2061.26,0.00,'2022-11-20 23:02:17','',''),(909,'1','294',NULL,2,'Sale Id shift 138',1731458.40,0.00,0.00,0.00,0.00,'2022-11-20 23:02:17','',''),(910,'1','294','3',2,'Sale Id shift 139',0.00,0.00,0.00,2591.10,0.00,'2022-11-21 11:22:43','',''),(911,'1','294','3',2,'Sale Id shift 139',0.00,0.00,0.00,10.00,0.00,'2022-11-21 11:22:43','',''),(912,'1','294','3',2,'Sale Id shift 139',0.00,0.00,0.00,90.00,0.00,'2022-11-21 11:22:43','',''),(913,'1','294','3',2,'Sale Id shift 139',0.00,0.00,0.00,10.00,0.00,'2022-11-21 11:22:43','',''),(914,'1','294',NULL,2,'Sale Id shift 139',2268924.00,0.00,0.00,0.00,0.00,'2022-11-21 11:22:43','',''),(915,'1','294','3',2,'Sale Id shift 140',0.00,0.00,0.00,2318.32,0.00,'2022-11-21 15:40:00','',''),(916,'1','294','3',2,'Sale Id shift 140',0.00,0.00,0.00,700.00,0.00,'2022-11-21 15:40:00','',''),(917,'1','294','3',2,'Sale Id shift 140',0.00,0.00,0.00,2560.03,0.00,'2022-11-21 15:40:00','',''),(918,'1','294','3',2,'Sale Id shift 140',0.00,0.00,0.00,180.95,0.00,'2022-11-21 15:40:00','',''),(919,'1','294',NULL,2,'Sale Id shift 140',4837812.00,0.00,0.00,0.00,0.00,'2022-11-21 15:40:00','',''),(920,'1','294','3',2,'Sale Id shift 141',0.00,0.00,0.00,2124.64,0.00,'2022-11-22 16:43:00','',''),(921,'1','294','3',2,'Sale Id shift 141',0.00,0.00,0.00,370.00,0.00,'2022-11-22 16:43:00','',''),(922,'1','294','3',2,'Sale Id shift 141',0.00,0.00,0.00,52.38,0.00,'2022-11-22 16:43:00','',''),(923,'1','294',NULL,2,'Sale Id shift 141',2139496.80,0.00,0.00,0.00,0.00,'2022-11-22 16:43:00','',''),(924,'1','294','3',2,'Sale Id shift 142',0.00,0.00,0.00,2527.33,0.00,'2022-11-23 12:31:03','',''),(925,'1','294',NULL,2,'Sale Id shift 142',2122957.20,0.00,0.00,0.00,0.00,'2022-11-23 12:31:03','',''),(926,'1','294','3',2,'Sale Id shift 143',0.00,0.00,0.00,1513.04,0.00,'2022-11-23 14:35:18','',''),(927,'1','294','3',2,'Sale Id shift 143',0.00,0.00,0.00,284.76,0.00,'2022-11-23 14:35:18','',''),(928,'1','294','3',2,'Sale Id shift 143',0.00,0.00,0.00,40.00,0.00,'2022-11-23 14:35:18','',''),(929,'1','294',NULL,2,'Sale Id shift 143',1543752.00,0.00,0.00,0.00,0.00,'2022-11-23 14:35:18','',''),(930,'1','294','3',2,'Sale Id shift 144',0.00,0.00,0.00,1267.84,0.00,'2022-11-23 15:17:13','',''),(931,'1','294','3',2,'Sale Id shift 144',0.00,0.00,0.00,200.00,0.00,'2022-11-23 15:17:13','',''),(932,'1','294',NULL,2,'Sale Id shift 144',1232985.60,0.00,0.00,0.00,0.00,'2022-11-23 15:17:13','',''),(933,'1','294','3',2,'Sale Id shift 145',0.00,0.00,0.00,2642.92,0.00,'2022-11-24 09:50:56','',''),(934,'1','294','3',2,'Sale Id shift 145',0.00,0.00,0.00,150.15,0.00,'2022-11-24 09:50:56','',''),(935,'1','294','3',2,'Sale Id shift 145',0.00,0.00,0.00,580.00,0.00,'2022-11-24 09:50:56','',''),(936,'1','294',NULL,2,'Sale Id shift 145',2833378.80,0.00,0.00,0.00,0.00,'2022-11-24 09:50:56','',''),(937,'1','294','3',2,'Sale Id shift 146',0.00,0.00,0.00,2362.46,0.00,'2022-11-24 14:44:32','',''),(938,'1','294',NULL,2,'Sale Id shift 146',1984466.40,0.00,0.00,0.00,0.00,'2022-11-24 14:44:32','',''),(939,'1','294','3',2,'Sale Id shift 147',0.00,0.00,0.00,1522.47,0.00,'2022-11-25 15:07:01','',''),(940,'1','294','3',2,'Sale Id shift 147',0.00,0.00,0.00,1109.81,0.00,'2022-11-25 15:07:01','',''),(941,'1','294','3',2,'Sale Id shift 147',0.00,0.00,0.00,195.00,0.00,'2022-11-25 15:07:01','',''),(942,'1','294',NULL,2,'Sale Id shift 147',2346642.40,0.00,0.00,0.00,0.00,'2022-11-25 15:07:01','',''),(943,'1','294','3',2,'Sale Id shift 148',0.00,0.00,0.00,585.19,0.00,'2022-11-25 19:22:03','',''),(944,'1','294',NULL,2,'Sale Id shift 148',485707.70,0.00,0.00,0.00,0.00,'2022-11-25 19:22:03','',''),(945,'1','294','3',2,'Sale Id shift 149',0.00,0.00,0.00,3241.27,0.00,'2022-11-26 11:09:16','',''),(946,'1','294','3',2,'Sale Id shift 149',0.00,0.00,0.00,210.00,0.00,'2022-11-26 11:09:16','',''),(947,'1','294','3',2,'Sale Id shift 149',0.00,0.00,0.00,162.05,0.00,'2022-11-26 11:09:16','',''),(948,'1','294','3',2,'Sale Id shift 149',0.00,0.00,0.00,400.00,0.00,'2022-11-26 11:09:16','',''),(949,'1','294',NULL,2,'Sale Id shift 149',3331055.60,0.00,0.00,0.00,0.00,'2022-11-26 11:09:16','',''),(950,'1','294','3',2,'Sale Id shift 150',0.00,0.00,0.00,1896.77,0.00,'2022-11-26 16:25:18','',''),(951,'1','294',NULL,2,'Sale Id shift 150',1574319.10,0.00,0.00,0.00,0.00,'2022-11-26 16:25:18','',''),(952,'1','294','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,676.28,0.00,'2022-11-27 14:31:27','',''),(953,'1','294','3',0,'Inventory adjustment from tank dipping to 1982',0.00,0.00,1982.00,0.00,0.00,'2022-11-27 14:31:27','',''),(954,'1','294','3',2,'Sale Id shift 151',0.00,0.00,0.00,1380.00,0.00,'2022-11-27 21:54:30','',''),(955,'1','294',NULL,2,'Sale Id shift 151',1145400.00,0.00,0.00,0.00,0.00,'2022-11-27 21:54:30','',''),(956,'1','294','3',2,'Sale Id shift 152',0.00,0.00,0.00,470.00,0.00,'2022-11-28 17:57:00','',''),(957,'1','294','3',2,'Sale Id shift 152',0.00,0.00,0.00,131.14,0.00,'2022-11-28 17:57:00','',''),(958,'1','294',NULL,2,'Sale Id shift 152',498946.20,0.00,0.00,0.00,0.00,'2022-11-28 17:57:00','',''),(959,'1','294',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,27972000.00,33300.00,0.00,0.00,'2022-11-30 11:31:57','',''),(960,'1','294',NULL,2,'Reception corrector for bridging 25',0.00,0.00,0.00,33100.00,0.00,'2022-11-30 11:45:38','',''),(961,'1','294','3',2,'Received from bridging 25',0.00,0.00,33100.00,0.00,0.00,'2022-11-30 11:45:38','',''),(962,'1','294','3',2,'Sale Id shift 153',0.00,0.00,0.00,2388.77,0.00,'2022-12-01 09:07:39','',''),(963,'1','294','3',2,'Sale Id shift 153',0.00,0.00,0.00,519.96,0.00,'2022-12-01 09:07:39','',''),(964,'1','294','3',2,'Sale Id shift 153',0.00,0.00,0.00,26.79,0.00,'2022-12-01 09:07:39','',''),(965,'1','294','3',2,'Sale Id shift 153',0.00,0.00,0.00,154.76,0.00,'2022-12-01 09:07:39','',''),(966,'1','294',NULL,2,'Sale Id shift 153',2595835.20,0.00,0.00,0.00,0.00,'2022-12-01 09:07:39','',''),(967,'1','294','3',2,'Sale Id shift 154',0.00,0.00,0.00,3257.64,0.00,'2022-12-01 13:41:28','',''),(968,'1','294','3',2,'Sale Id shift 154',0.00,0.00,0.00,680.40,0.00,'2022-12-01 13:41:28','',''),(969,'1','294',NULL,2,'Sale Id shift 154',3307953.60,0.00,0.00,0.00,0.00,'2022-12-01 13:41:28','',''),(970,'1','294','3',2,'Sale Id shift 155',0.00,0.00,0.00,1927.15,0.00,'2022-12-02 10:36:10','',''),(971,'1','294','3',2,'Sale Id shift 155',0.00,0.00,0.00,100.00,0.00,'2022-12-02 10:36:10','',''),(972,'1','294',NULL,2,'Sale Id shift 155',1702806.00,0.00,0.00,0.00,0.00,'2022-12-02 10:36:10','',''),(973,'1','294','3',2,'Sale Id shift 156',0.00,0.00,0.00,1887.09,0.00,'2022-12-02 15:37:16','',''),(974,'1','294','3',2,'Sale Id shift 156',0.00,0.00,0.00,1105.48,0.00,'2022-12-02 15:37:16','',''),(975,'1','294','3',2,'Sale Id shift 156',0.00,0.00,0.00,80.00,0.00,'2022-12-02 15:37:16','',''),(976,'1','294',NULL,2,'Sale Id shift 156',2580958.80,0.00,0.00,0.00,0.00,'2022-12-02 15:37:16','',''),(977,'1','294','3',2,'Sale Id shift 157',0.00,0.00,0.00,2306.60,0.00,'2022-12-03 13:41:51','',''),(978,'1','294',NULL,2,'Sale Id shift 157',1937544.00,0.00,0.00,0.00,0.00,'2022-12-03 13:41:51','',''),(979,'1','294',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,6600000.00,30000.00,0.00,0.00,'2022-12-03 13:42:25','',''),(980,'1','294','3',2,'Sale Id shift 158',0.00,0.00,0.00,2359.91,0.00,'2022-12-03 21:12:06','',''),(981,'1','294','3',2,'Sale Id shift 158',0.00,0.00,0.00,771.91,0.00,'2022-12-03 21:12:06','',''),(982,'1','294',NULL,2,'Sale Id shift 158',2630728.80,0.00,0.00,0.00,0.00,'2022-12-03 21:12:06','',''),(983,'1','294',NULL,1,'Reception corrector for bridging 26',0.00,0.00,0.00,29850.00,0.00,'2022-12-04 08:58:27','',''),(984,'1','294','2',1,'Received from bridging 26',0.00,0.00,29850.00,0.00,0.00,'2022-12-04 08:58:27','',''),(985,'1','294','2',1,'Sale Id shift 159',0.00,0.00,0.00,2917.85,0.00,'2022-12-04 09:43:42','',''),(986,'1','294','2',1,'Sale Id shift 159',0.00,0.00,0.00,2699.94,0.00,'2022-12-04 09:43:42','',''),(987,'1','294','3',2,'Sale Id shift 159',0.00,0.00,0.00,868.05,0.00,'2022-12-04 09:43:42','',''),(988,'1','294',NULL,2,'Sale Id shift 159',729162.00,0.00,0.00,0.00,0.00,'2022-12-04 09:43:42','',''),(989,'1','294',NULL,1,'Sale Id shift 159',1235913.80,0.00,0.00,0.00,0.00,'2022-12-04 09:43:42','',''),(990,'1','294','2',1,'Sale Id shift 160',0.00,0.00,0.00,0.53,0.00,'2022-12-04 12:23:45','',''),(991,'1','294','2',1,'Sale Id shift 160',0.00,0.00,0.00,942.14,0.00,'2022-12-04 12:23:45','',''),(992,'1','294','2',1,'Sale Id shift 160',0.00,0.00,0.00,1731.76,0.00,'2022-12-04 12:23:45','',''),(993,'1','294','3',2,'Sale Id shift 160',0.00,0.00,0.00,228.58,0.00,'2022-12-04 12:23:45','',''),(994,'1','294','3',2,'Sale Id shift 160',0.00,0.00,0.00,1598.79,0.00,'2022-12-04 12:23:45','',''),(995,'1','294',NULL,2,'Sale Id shift 160',1534990.80,0.00,0.00,0.00,0.00,'2022-12-04 12:23:45','',''),(996,'1','294',NULL,1,'Sale Id shift 160',588374.60,0.00,0.00,0.00,0.00,'2022-12-04 12:23:45','',''),(997,'1','294','3',2,'Sale Id shift 161',0.00,0.00,0.00,559.57,0.00,'2022-12-05 05:51:36','',''),(998,'1','294','3',2,'Sale Id shift 161',0.00,0.00,0.00,884.55,0.00,'2022-12-05 05:51:36','',''),(999,'1','294',NULL,2,'Sale Id shift 161',1270825.60,0.00,0.00,0.00,0.00,'2022-12-05 05:51:36','',''),(1000,'1','294','3',2,'Sale Id shift 162',0.00,0.00,0.00,2362.38,0.00,'2022-12-05 10:31:32','',''),(1001,'1','294',NULL,2,'Sale Id shift 162',2078894.40,0.00,0.00,0.00,0.00,'2022-12-05 10:31:32','',''),(1002,'1','294','3',2,'Sale Id shift 163',0.00,0.00,0.00,1524.84,0.00,'2022-12-05 10:46:38','',''),(1003,'1','294','3',2,'Sale Id shift 163',0.00,0.00,0.00,514.85,0.00,'2022-12-05 10:46:38','',''),(1004,'1','294',NULL,2,'Sale Id shift 163',1794927.20,0.00,0.00,0.00,0.00,'2022-12-05 10:46:38','',''),(1005,'1','294','3',2,'Sale Id shift 164',0.00,0.00,0.00,1233.87,0.00,'2022-12-05 17:51:39','',''),(1006,'1','294','3',2,'Sale Id shift 164',0.00,0.00,0.00,635.00,0.00,'2022-12-05 17:51:39','',''),(1007,'1','294',NULL,2,'Sale Id shift 164',1644605.60,0.00,0.00,0.00,0.00,'2022-12-05 17:51:39','',''),(1008,'1','294','3',2,'Sale Id shift 165',0.00,0.00,0.00,1928.41,0.00,'2022-12-06 10:11:10','',''),(1009,'1','294','3',2,'Sale Id shift 165',0.00,0.00,0.00,119.98,0.00,'2022-12-06 10:11:10','',''),(1010,'1','294',NULL,2,'Sale Id shift 165',1802583.20,0.00,0.00,0.00,0.00,'2022-12-06 10:11:10','',''),(1011,'1','294','2',1,'Sale Id shift 166',0.00,0.00,0.00,3141.81,0.00,'2022-12-06 20:24:29','',''),(1012,'1','294','2',1,'Sale Id shift 166',0.00,0.00,0.00,2957.81,0.00,'2022-12-06 20:24:29','',''),(1013,'1','294','3',2,'Sale Id shift 166',0.00,0.00,0.00,1597.03,0.00,'2022-12-06 20:24:29','',''),(1014,'1','294',NULL,2,'Sale Id shift 166',1405386.40,0.00,0.00,0.00,0.00,'2022-12-06 20:24:29','',''),(1015,'1','294',NULL,1,'Sale Id shift 166',1341916.40,0.00,0.00,0.00,0.00,'2022-12-06 20:24:29','',''),(1016,'1','294','2',1,'Sale Id shift 167',0.00,0.00,0.00,4922.43,0.00,'2022-12-07 11:09:46','',''),(1017,'1','294','2',1,'Sale Id shift 167',0.00,0.00,0.00,4865.53,0.00,'2022-12-07 11:09:46','',''),(1018,'1','294','3',2,'Sale Id shift 167',0.00,0.00,0.00,315.56,0.00,'2022-12-07 11:09:46','',''),(1019,'1','294','3',2,'Sale Id shift 167',0.00,0.00,0.00,80.00,0.00,'2022-12-07 11:09:46','',''),(1020,'1','294',NULL,2,'Sale Id shift 167',348092.80,0.00,0.00,0.00,0.00,'2022-12-07 11:09:46','',''),(1021,'1','294',NULL,1,'Sale Id shift 167',2153351.20,0.00,0.00,0.00,0.00,'2022-12-07 11:09:46','',''),(1022,'1','294','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,1082.94,0.00,'2022-12-07 11:56:21','',''),(1023,'1','294','3',0,'Inventory adjustment from tank dipping to 1800',0.00,0.00,1800.00,0.00,0.00,'2022-12-07 11:56:21','',''),(1024,'1','294','3',2,'Sale Id shift 168',0.00,0.00,0.00,1015.83,0.00,'2022-12-07 14:03:04','',''),(1025,'1','294','3',2,'Sale Id shift 168',0.00,0.00,0.00,584.92,0.00,'2022-12-07 14:03:04','',''),(1026,'1','294',NULL,2,'Sale Id shift 168',1344630.00,0.00,0.00,0.00,0.00,'2022-12-07 14:03:04','',''),(1027,'1','294','2',1,'Sale Id shift 169',0.00,0.00,0.00,2860.32,0.00,'2022-12-07 15:41:13','',''),(1028,'1','294','2',1,'Sale Id shift 169',0.00,0.00,0.00,2752.85,0.00,'2022-12-07 15:41:13','',''),(1029,'1','294',NULL,1,'Sale Id shift 169',1234897.40,0.00,0.00,0.00,0.00,'2022-12-07 15:41:13','',''),(1030,'1','294',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,24600000.00,30000.00,0.00,0.00,'2022-12-19 13:32:30','',''),(1031,'1','294',NULL,2,'Reception corrector for bridging 27',0.00,0.00,0.00,30000.00,0.00,'2022-12-19 13:38:19','',''),(1032,'1','294','3',2,'Received from bridging 27',0.00,0.00,30000.00,0.00,0.00,'2022-12-19 13:38:19','',''),(1033,'1','294','3',2,'Sale Id shift 170',0.00,0.00,0.00,2058.15,0.00,'2022-12-19 13:43:05','',''),(1034,'1','294','3',2,'Sale Id shift 170',0.00,0.00,0.00,853.83,0.00,'2022-12-19 13:43:05','',''),(1035,'1','294','3',2,'Sale Id shift 170',0.00,0.00,0.00,2444.33,0.00,'2022-12-19 13:43:05','',''),(1036,'1','294','3',2,'Sale Id shift 170',0.00,0.00,0.00,1550.00,0.00,'2022-12-19 13:43:05','',''),(1037,'1','294',NULL,2,'Sale Id shift 170',5663174.20,0.00,0.00,0.00,0.00,'2022-12-19 13:43:05','',''),(1038,'1','294','3',2,'Sale Id shift 171',0.00,0.00,0.00,1647.52,0.00,'2022-12-19 13:48:54','',''),(1039,'1','294','3',2,'Sale Id shift 171',0.00,0.00,0.00,276.00,0.00,'2022-12-19 13:48:54','',''),(1040,'1','294','3',2,'Sale Id shift 171',0.00,0.00,0.00,253.00,0.00,'2022-12-19 13:48:54','',''),(1041,'1','294',NULL,2,'Sale Id shift 171',1784746.40,0.00,0.00,0.00,0.00,'2022-12-19 13:48:54','',''),(1042,'1','294','3',2,'Sale Id shift 172',0.00,0.00,0.00,1743.17,0.00,'2022-12-19 13:53:50','',''),(1043,'1','294','3',2,'Sale Id shift 172',0.00,0.00,0.00,608.54,0.00,'2022-12-19 13:53:50','',''),(1044,'1','294','3',2,'Sale Id shift 172',0.00,0.00,0.00,5114.42,0.00,'2022-12-19 13:53:50','',''),(1045,'1','294','3',2,'Sale Id shift 172',0.00,0.00,0.00,2200.00,0.00,'2022-12-19 13:53:50','',''),(1046,'1','294',NULL,2,'Sale Id shift 172',7926226.60,0.00,0.00,0.00,0.00,'2022-12-19 13:53:50','',''),(1047,'1','294','3',2,'Sale Id shift 173',0.00,0.00,0.00,1282.05,0.00,'2022-12-19 14:06:37','',''),(1048,'1','294','3',2,'Sale Id shift 173',0.00,0.00,0.00,1060.00,0.00,'2022-12-19 14:06:37','',''),(1049,'1','294','3',2,'Sale Id shift 173',0.00,0.00,0.00,307.32,0.00,'2022-12-19 14:06:37','',''),(1050,'1','294',NULL,2,'Sale Id shift 173',2172483.40,0.00,0.00,0.00,0.00,'2022-12-19 14:06:37','',''),(1051,'1','294','3',2,'Sale Id shift 174',0.00,0.00,0.00,1768.49,0.00,'2022-12-19 14:34:47','',''),(1052,'1','294','3',2,'Sale Id shift 174',0.00,0.00,0.00,662.19,0.00,'2022-12-19 14:34:47','',''),(1053,'1','294',NULL,2,'Sale Id shift 174',1993157.60,0.00,0.00,0.00,0.00,'2022-12-19 14:34:47','',''),(1054,'1','294','3',2,'Sale Id shift 175',0.00,0.00,0.00,1655.73,0.00,'2022-12-19 18:31:20','',''),(1055,'1','294','3',2,'Sale Id shift 175',0.00,0.00,0.00,1121.71,0.00,'2022-12-19 18:31:20','',''),(1056,'1','294',NULL,2,'Sale Id shift 175',2277500.80,0.00,0.00,0.00,0.00,'2022-12-19 18:31:20','',''),(1057,'1','294','3',2,'Sale Id shift 176',0.00,0.00,0.00,2889.70,0.00,'2022-12-20 10:39:21','',''),(1058,'1','294','3',2,'Sale Id shift 176',0.00,0.00,0.00,685.91,0.00,'2022-12-20 10:39:21','',''),(1059,'1','294',NULL,2,'Sale Id shift 176',2932000.20,0.00,0.00,0.00,0.00,'2022-12-20 10:39:21','',''),(1060,'1','294',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,13800000.00,60000.00,0.00,0.00,'2022-12-22 10:22:06','',''),(1061,'1','294',NULL,1,'Reception corrector for bridging 28',0.00,0.00,0.00,60000.00,0.00,'2022-12-22 10:35:06','',''),(1062,'1','294','2',1,'Received from bridging 28',0.00,0.00,60000.00,0.00,0.00,'2022-12-22 10:35:06','',''),(1063,'1','294','2',1,'Sale Id shift 177',0.00,0.00,0.00,3816.02,0.00,'2022-12-22 15:17:30','',''),(1064,'1','294','2',1,'Sale Id shift 177',0.00,0.00,0.00,3369.93,0.00,'2022-12-22 15:17:30','',''),(1065,'1','294','2',1,'Sale Id shift 177',0.00,0.00,0.00,4400.70,0.00,'2022-12-22 15:17:30','',''),(1066,'1','294','2',1,'Sale Id shift 177',0.00,0.00,0.00,3834.67,0.00,'2022-12-22 15:17:30','',''),(1067,'1','294',NULL,1,'Sale Id shift 177',3546903.60,0.00,0.00,0.00,0.00,'2022-12-22 15:17:30','',''),(1068,'1','294','2',1,'Sale Id shift 178',0.00,0.00,0.00,4138.66,0.00,'2022-12-22 19:50:01','',''),(1069,'1','294','2',1,'Sale Id shift 178',0.00,0.00,0.00,1389.10,0.00,'2022-12-22 19:50:01','',''),(1070,'1','294','2',1,'Sale Id shift 178',0.00,0.00,0.00,952.65,0.00,'2022-12-22 19:50:01','',''),(1071,'1','294','2',1,'Sale Id shift 178',0.00,0.00,0.00,4139.32,0.00,'2022-12-22 19:50:01','',''),(1072,'1','294','2',1,'Sale Id shift 178',0.00,0.00,0.00,4324.57,0.00,'2022-12-22 19:50:01','',''),(1073,'1','294','2',1,'Sale Id shift 178',0.00,0.00,0.00,399.94,0.00,'2022-12-22 19:50:01','',''),(1074,'1','294',NULL,1,'Sale Id shift 178',3529175.20,0.00,0.00,0.00,0.00,'2022-12-22 19:50:01','',''),(1075,'1','294',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,41000000.00,50000.00,0.00,0.00,'2022-12-22 19:50:27','',''),(1076,'1','294',NULL,2,'Reception corrector for bridging 29',0.00,0.00,0.00,50000.00,0.00,'2022-12-22 20:12:35','',''),(1077,'1','294','3',2,'Received from bridging 29',0.00,0.00,50000.00,0.00,0.00,'2022-12-22 20:12:35','',''),(1078,'1','294','2',1,'Sale Id shift 179',0.00,0.00,0.00,3312.40,0.00,'2022-12-23 11:50:15','',''),(1079,'1','294','2',1,'Sale Id shift 179',0.00,0.00,0.00,3549.37,0.00,'2022-12-23 11:50:15','',''),(1080,'1','294','2',1,'Sale Id shift 179',0.00,0.00,0.00,3303.64,0.00,'2022-12-23 11:50:15','',''),(1081,'1','294','2',1,'Sale Id shift 179',0.00,0.00,0.00,3491.93,0.00,'2022-12-23 11:50:15','',''),(1082,'1','294','2',1,'Sale Id shift 179',0.00,0.00,0.00,5036.36,0.00,'2022-12-23 11:50:15','',''),(1083,'1','294',NULL,1,'Sale Id shift 179',4299551.00,0.00,0.00,0.00,0.00,'2022-12-23 11:50:15','',''),(1084,'1','294','2',1,'Sale Id shift 180',0.00,0.00,0.00,2634.26,0.00,'2022-12-23 16:34:56','',''),(1085,'1','294','2',1,'Sale Id shift 180',0.00,0.00,0.00,2237.59,0.00,'2022-12-23 16:34:56','',''),(1086,'1','294','2',1,'Sale Id shift 180',0.00,0.00,0.00,1105.88,0.00,'2022-12-23 16:34:56','',''),(1087,'1','294','2',1,'Sale Id shift 180',0.00,0.00,0.00,2622.73,0.00,'2022-12-23 16:34:56','',''),(1088,'1','294','2',1,'Sale Id shift 180',0.00,0.00,0.00,2293.02,0.00,'2022-12-23 16:34:56','',''),(1089,'1','294','3',2,'Sale Id shift 180',0.00,0.00,0.00,1047.68,0.00,'2022-12-23 16:34:56','',''),(1090,'1','294','3',2,'Sale Id shift 180',0.00,0.00,0.00,1035.00,0.00,'2022-12-23 16:34:56','',''),(1091,'1','294','3',2,'Sale Id shift 180',0.00,0.00,0.00,824.88,0.00,'2022-12-23 16:34:56','',''),(1092,'1','294',NULL,2,'Sale Id shift 180',2384199.20,0.00,0.00,0.00,0.00,'2022-12-23 16:34:56','',''),(1093,'1','294',NULL,1,'Sale Id shift 180',2505500.40,0.00,0.00,0.00,0.00,'2022-12-23 16:34:56','',''),(1094,'1','294','3',2,'Sale Id shift 181',0.00,0.00,0.00,1927.35,0.00,'2022-12-24 09:55:33','',''),(1095,'1','294',NULL,2,'Sale Id shift 181',1580427.00,0.00,0.00,0.00,0.00,'2022-12-24 09:55:33','',''),(1096,'1','294','3',2,'Sale Id shift 182',0.00,0.00,0.00,1607.60,0.00,'2022-12-24 13:13:15','',''),(1097,'1','294','3',2,'Sale Id shift 182',0.00,0.00,0.00,120.01,0.00,'2022-12-24 13:13:15','',''),(1098,'1','294','3',2,'Sale Id shift 182',0.00,0.00,0.00,2675.99,0.00,'2022-12-24 13:13:15','',''),(1099,'1','294',NULL,2,'Sale Id shift 182',3610952.00,0.00,0.00,0.00,0.00,'2022-12-24 13:13:15','',''),(1100,'1','294','3',2,'Sale Id shift 183',0.00,0.00,0.00,2850.93,0.00,'2022-12-24 15:38:41','',''),(1101,'1','294','3',2,'Sale Id shift 183',0.00,0.00,0.00,24.99,0.00,'2022-12-24 15:38:41','',''),(1102,'1','294','3',2,'Sale Id shift 183',0.00,0.00,0.00,1044.03,0.00,'2022-12-24 15:38:41','',''),(1103,'1','294','3',2,'Sale Id shift 183',0.00,0.00,0.00,175.00,0.00,'2022-12-24 15:38:41','',''),(1104,'1','294',NULL,2,'Sale Id shift 183',3357859.00,0.00,0.00,0.00,0.00,'2022-12-24 15:38:41','',''),(1105,'1','294','3',2,'Sale Id shift 184',0.00,0.00,0.00,1621.20,0.00,'2022-12-25 06:58:50','',''),(1106,'1','294','3',2,'Sale Id shift 184',0.00,0.00,0.00,705.01,0.00,'2022-12-25 06:58:50','',''),(1107,'1','294','3',2,'Sale Id shift 184',0.00,0.00,0.00,629.27,0.00,'2022-12-25 06:58:50','',''),(1108,'1','294',NULL,2,'Sale Id shift 184',2423493.60,0.00,0.00,0.00,0.00,'2022-12-25 06:58:50','',''),(1109,'1','294','3',2,'Sale Id shift 185',0.00,0.00,0.00,1423.81,0.00,'2022-12-26 08:23:41','',''),(1110,'1','294','3',2,'Sale Id shift 185',0.00,0.00,0.00,2881.48,0.00,'2022-12-26 08:23:41','',''),(1111,'1','294',NULL,2,'Sale Id shift 185',3530337.80,0.00,0.00,0.00,0.00,'2022-12-26 08:23:41','',''),(1112,'1','294','3',2,'Sale Id shift 186',0.00,0.00,0.00,3548.45,0.00,'2022-12-26 18:53:49','',''),(1113,'1','294','3',2,'Sale Id shift 186',0.00,0.00,0.00,896.34,0.00,'2022-12-26 18:53:49','',''),(1114,'1','294',NULL,2,'Sale Id shift 186',3644727.80,0.00,0.00,0.00,0.00,'2022-12-26 18:53:49','',''),(1115,'1','294','3',2,'Sale Id shift 187',0.00,0.00,0.00,2405.46,0.00,'2022-12-27 10:16:17','',''),(1116,'1','294',NULL,2,'Sale Id shift 187',1972477.20,0.00,0.00,0.00,0.00,'2022-12-27 10:16:17','',''),(1117,'1','294',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,11750000.00,50000.00,0.00,0.00,'2022-12-27 10:16:37','',''),(1118,'1','294',NULL,1,'Reception corrector for bridging 30',0.00,0.00,0.00,50000.00,0.00,'2022-12-27 12:22:16','',''),(1119,'1','294','2',1,'Received from bridging 30',0.00,0.00,50000.00,0.00,0.00,'2022-12-27 12:22:16','',''),(1120,'1','294','3',2,'Sale Id shift 188',0.00,0.00,0.00,2439.81,0.00,'2022-12-27 13:10:20','',''),(1121,'1','294','3',2,'Sale Id shift 188',0.00,0.00,0.00,4014.03,0.00,'2022-12-27 13:10:20','',''),(1122,'1','294','3',2,'Sale Id shift 188',0.00,0.00,0.00,110.00,0.00,'2022-12-27 13:10:20','',''),(1123,'1','294',NULL,2,'Sale Id shift 188',5382348.80,0.00,0.00,0.00,0.00,'2022-12-27 13:10:20','',''),(1124,'1','294','2',1,'Sale Id shift 189',0.00,0.00,0.00,4073.08,0.00,'2022-12-28 11:29:21','',''),(1125,'1','294','2',1,'Sale Id shift 189',0.00,0.00,0.00,4200.70,0.00,'2022-12-28 11:29:21','',''),(1126,'1','294','2',1,'Sale Id shift 189',0.00,0.00,0.00,4056.12,0.00,'2022-12-28 11:29:21','',''),(1127,'1','294','3',2,'Sale Id shift 189',0.00,0.00,0.00,2858.43,0.00,'2022-12-28 11:29:21','',''),(1128,'1','294','3',2,'Sale Id shift 189',0.00,0.00,0.00,950.00,0.00,'2022-12-28 11:29:21','',''),(1129,'1','294',NULL,2,'Sale Id shift 189',3122912.60,0.00,0.00,0.00,0.00,'2022-12-28 11:29:21','',''),(1130,'1','294',NULL,1,'Sale Id shift 189',2897526.50,0.00,0.00,0.00,0.00,'2022-12-28 11:29:21','',''),(1131,'1','294',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,32800000.00,40000.00,0.00,0.00,'2022-12-28 11:29:38','',''),(1132,'1','294','2',1,'Sale Id shift 190',0.00,0.00,0.00,2873.73,0.00,'2022-12-28 15:44:58','',''),(1133,'1','294','2',1,'Sale Id shift 190',0.00,0.00,0.00,4075.98,0.00,'2022-12-28 15:44:58','',''),(1134,'1','294','2',1,'Sale Id shift 190',0.00,0.00,0.00,4757.93,0.00,'2022-12-28 15:44:58','',''),(1135,'1','294','3',2,'Sale Id shift 190',0.00,0.00,0.00,3719.20,0.00,'2022-12-28 15:44:58','',''),(1136,'1','294','3',2,'Sale Id shift 190',0.00,0.00,0.00,209.72,0.00,'2022-12-28 15:44:58','',''),(1137,'1','294','3',2,'Sale Id shift 190',0.00,0.00,0.00,1708.63,0.00,'2022-12-28 15:44:58','',''),(1138,'1','294',NULL,2,'Sale Id shift 190',4622791.00,0.00,0.00,0.00,0.00,'2022-12-28 15:44:58','',''),(1139,'1','294',NULL,1,'Sale Id shift 190',2751295.40,0.00,0.00,0.00,0.00,'2022-12-28 15:44:58','',''),(1140,'1','294','2',1,'Sale Id shift 191',0.00,0.00,0.00,610.04,0.00,'2022-12-29 12:27:10','',''),(1141,'1','294','2',1,'Sale Id shift 191',0.00,0.00,0.00,3221.32,0.00,'2022-12-29 12:27:10','',''),(1142,'1','294','2',1,'Sale Id shift 191',0.00,0.00,0.00,3046.11,0.00,'2022-12-29 12:27:10','',''),(1143,'1','294','3',2,'Sale Id shift 191',0.00,0.00,0.00,2687.34,0.00,'2022-12-29 12:27:10','',''),(1144,'1','294',NULL,2,'Sale Id shift 191',2203618.80,0.00,0.00,0.00,0.00,'2022-12-29 12:27:10','',''),(1145,'1','294',NULL,1,'Sale Id shift 191',1616205.45,0.00,0.00,0.00,0.00,'2022-12-29 12:27:10','',''),(1146,'1','294',NULL,2,'Reception corrector for bridging 31',0.00,0.00,0.00,40000.00,0.00,'2022-12-29 13:59:29','',''),(1147,'1','294','3',2,'Received from bridging 31',0.00,0.00,40000.00,0.00,0.00,'2022-12-29 13:59:29','',''),(1148,'1','294','2',1,'Sale Id shift 192',0.00,0.00,0.00,3123.68,0.00,'2022-12-29 15:09:09','',''),(1149,'1','294','2',1,'Sale Id shift 192',0.00,0.00,0.00,4824.80,0.00,'2022-12-29 15:09:09','',''),(1150,'1','294','2',1,'Sale Id shift 192',0.00,0.00,0.00,4846.97,0.00,'2022-12-29 15:09:09','',''),(1151,'1','294','3',2,'Sale Id shift 192',0.00,0.00,0.00,3455.54,0.00,'2022-12-29 15:09:09','',''),(1152,'1','294','3',2,'Sale Id shift 192',0.00,0.00,0.00,89.98,0.00,'2022-12-29 15:09:09','',''),(1153,'1','294','3',2,'Sale Id shift 192',0.00,0.00,0.00,3736.04,0.00,'2022-12-29 15:09:09','',''),(1154,'1','294','3',2,'Sale Id shift 192',0.00,0.00,0.00,1445.00,0.00,'2022-12-29 15:09:09','',''),(1155,'1','294',NULL,2,'Sale Id shift 192',7155779.20,0.00,0.00,0.00,0.00,'2022-12-29 15:09:09','',''),(1156,'1','294',NULL,1,'Sale Id shift 192',3006930.75,0.00,0.00,0.00,0.00,'2022-12-29 15:09:09','',''),(1157,'1','294','2',1,'Sale Id shift 193',0.00,0.00,0.00,969.40,0.00,'2022-12-29 16:29:27','',''),(1158,'1','294','2',1,'Sale Id shift 193',0.00,0.00,0.00,1855.35,0.00,'2022-12-29 16:29:27','',''),(1159,'1','294','2',1,'Sale Id shift 193',0.00,0.00,0.00,1461.48,0.00,'2022-12-29 16:29:27','',''),(1160,'1','294','2',1,'Sale Id shift 193',0.00,0.00,0.00,1834.40,0.00,'2022-12-29 16:29:27','',''),(1161,'1','294','3',2,'Sale Id shift 193',0.00,0.00,0.00,3648.36,0.00,'2022-12-29 16:29:27','',''),(1162,'1','294',NULL,2,'Sale Id shift 193',2991655.20,0.00,0.00,0.00,0.00,'2022-12-29 16:29:27','',''),(1163,'1','294',NULL,1,'Sale Id shift 193',1438348.05,0.00,0.00,0.00,0.00,'2022-12-29 16:29:27','',''),(1164,'1','294','3',2,'Sale Id shift 194',0.00,0.00,0.00,1661.35,0.00,'2022-12-30 11:39:12','',''),(1165,'1','294','3',2,'Sale Id shift 194',0.00,0.00,0.00,2774.09,0.00,'2022-12-30 11:39:12','',''),(1166,'1','294','3',2,'Sale Id shift 194',0.00,0.00,0.00,110.00,0.00,'2022-12-30 11:39:12','',''),(1167,'1','294',NULL,2,'Sale Id shift 194',3727260.80,0.00,0.00,0.00,0.00,'2022-12-30 11:39:12','',''),(1168,'1','294','3',2,'Sale Id shift 195',0.00,0.00,0.00,2699.18,0.00,'2022-12-30 19:33:07','',''),(1169,'1','294','3',2,'Sale Id shift 195',0.00,0.00,0.00,725.15,0.00,'2022-12-30 19:33:07','',''),(1170,'1','294',NULL,2,'Sale Id shift 195',2807950.60,0.00,0.00,0.00,0.00,'2022-12-30 19:33:07','',''),(1171,'1','294',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,7050000.00,30000.00,0.00,0.00,'2022-12-31 12:38:05','',''),(1172,'1','294',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,10575000.00,45000.00,0.00,0.00,'2022-12-31 12:39:13','',''),(1173,'1','294',NULL,1,'Reception corrector for bridging 32',0.00,0.00,0.00,30000.00,0.00,'2022-12-31 15:18:11','',''),(1174,'1','294','2',1,'Received from bridging 32',0.00,0.00,30000.00,0.00,0.00,'2022-12-31 15:18:11','',''),(1175,'1','294','2',1,'Sale Id shift 196',0.00,0.00,0.00,831.24,0.00,'2022-12-31 16:56:32','',''),(1176,'1','294','2',1,'Sale Id shift 196',0.00,0.00,0.00,4369.23,0.00,'2022-12-31 16:56:32','',''),(1177,'1','294','2',1,'Sale Id shift 196',0.00,0.00,0.00,2530.29,0.00,'2022-12-31 16:56:32','',''),(1178,'1','294','2',1,'Sale Id shift 196',0.00,0.00,0.00,3806.59,0.00,'2022-12-31 16:56:32','',''),(1179,'1','294','3',2,'Sale Id shift 196',0.00,0.00,0.00,3299.90,0.00,'2022-12-31 16:56:32','',''),(1180,'1','294','3',2,'Sale Id shift 196',0.00,0.00,0.00,1165.96,0.00,'2022-12-31 16:56:32','',''),(1181,'1','294',NULL,2,'Sale Id shift 196',3662005.20,0.00,0.00,0.00,0.00,'2022-12-31 16:56:32','',''),(1182,'1','294',NULL,1,'Sale Id shift 196',2711277.25,0.00,0.00,0.00,0.00,'2022-12-31 16:56:32','',''),(1183,'1','294','2',1,'Sale Id shift 197',0.00,0.00,0.00,5541.52,0.00,'2023-01-01 12:32:41','',''),(1184,'1','294','2',1,'Sale Id shift 197',0.00,0.00,0.00,997.10,0.00,'2023-01-01 12:32:41','',''),(1185,'1','294','2',1,'Sale Id shift 197',0.00,0.00,0.00,4099.83,0.00,'2023-01-01 12:32:41','',''),(1186,'1','294','2',1,'Sale Id shift 197',0.00,0.00,0.00,3872.11,0.00,'2023-01-01 12:32:41','',''),(1187,'1','294','3',2,'Sale Id shift 197',0.00,0.00,0.00,2187.15,0.00,'2023-01-01 12:32:41','',''),(1188,'1','294','3',2,'Sale Id shift 197',0.00,0.00,0.00,600.00,0.00,'2023-01-01 12:32:41','',''),(1189,'1','294',NULL,2,'Sale Id shift 197',2285463.00,0.00,0.00,0.00,0.00,'2023-01-01 12:32:41','',''),(1190,'1','294',NULL,1,'Sale Id shift 197',3409981.60,0.00,0.00,0.00,0.00,'2023-01-01 12:32:41','',''),(1191,'1','294',NULL,1,'Reception corrector for bridging 33',0.00,0.00,0.00,45000.00,0.00,'2023-01-01 16:47:52','',''),(1192,'1','294','2',1,'Received from bridging 33',0.00,0.00,45000.00,0.00,0.00,'2023-01-01 16:47:52','',''),(1193,'1','294','2',1,'Sale Id shift 198',0.00,0.00,0.00,1537.63,0.00,'2023-01-02 10:47:19','',''),(1194,'1','294','2',1,'Sale Id shift 198',0.00,0.00,0.00,2121.76,0.00,'2023-01-02 10:47:19','',''),(1195,'1','294','3',2,'Sale Id shift 198',0.00,0.00,0.00,2673.72,0.00,'2023-01-02 10:47:19','',''),(1196,'1','294','3',2,'Sale Id shift 198',0.00,0.00,0.00,184.39,0.00,'2023-01-02 10:47:19','',''),(1197,'1','294',NULL,2,'Sale Id shift 198',2343650.20,0.00,0.00,0.00,0.00,'2023-01-02 10:47:19','',''),(1198,'1','294',NULL,1,'Sale Id shift 198',859956.65,0.00,0.00,0.00,0.00,'2023-01-02 10:47:19','',''),(1199,'1','294','2',1,'Sale Id shift 199',0.00,0.00,0.00,4212.40,0.00,'2023-01-02 12:58:08','',''),(1200,'1','294','2',1,'Sale Id shift 199',0.00,0.00,0.00,2578.41,0.00,'2023-01-02 12:58:08','',''),(1201,'1','294','2',1,'Sale Id shift 199',0.00,0.00,0.00,2900.86,0.00,'2023-01-02 12:58:08','',''),(1202,'1','294','2',1,'Sale Id shift 199',0.00,0.00,0.00,1175.65,0.00,'2023-01-02 12:58:08','',''),(1203,'1','294','3',2,'Sale Id shift 199',0.00,0.00,0.00,3285.41,0.00,'2023-01-02 12:58:08','',''),(1204,'1','294','3',2,'Sale Id shift 199',0.00,0.00,0.00,1725.57,0.00,'2023-01-02 12:58:08','',''),(1205,'1','294',NULL,2,'Sale Id shift 199',4109003.60,0.00,0.00,0.00,0.00,'2023-01-02 12:58:08','',''),(1206,'1','294',NULL,1,'Sale Id shift 199',2553820.20,0.00,0.00,0.00,0.00,'2023-01-02 12:58:08','',''),(1207,'1','294','2',1,'Sale Id shift 200',0.00,0.00,0.00,954.17,0.00,'2023-01-03 13:16:23','',''),(1208,'1','294','2',1,'Sale Id shift 200',0.00,0.00,0.00,1514.59,0.00,'2023-01-03 13:16:23','',''),(1209,'1','294','2',1,'Sale Id shift 200',0.00,0.00,0.00,1944.77,0.00,'2023-01-03 13:16:23','',''),(1210,'1','294','2',1,'Sale Id shift 200',0.00,0.00,0.00,640.47,0.00,'2023-01-03 13:16:23','',''),(1211,'1','294','3',2,'Sale Id shift 200',0.00,0.00,0.00,2005.61,0.00,'2023-01-03 13:16:23','',''),(1212,'1','294','3',2,'Sale Id shift 200',0.00,0.00,0.00,2685.26,0.00,'2023-01-03 13:16:23','',''),(1213,'1','294',NULL,2,'Sale Id shift 200',3846513.40,0.00,0.00,0.00,0.00,'2023-01-03 13:16:23','',''),(1214,'1','294',NULL,1,'Sale Id shift 200',1187690.00,0.00,0.00,0.00,0.00,'2023-01-03 13:16:23','',''),(1215,'1','294','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,3717.89,0.00,'2023-01-03 14:39:15','',''),(1216,'1','294','3',0,'Inventory adjustment from tank dipping to 6000',0.00,0.00,6000.00,0.00,0.00,'2023-01-03 14:39:15','',''),(1217,'1','294','2',1,'Sale Id shift 201',0.00,0.00,0.00,656.32,0.00,'2023-01-04 10:31:55','',''),(1218,'1','294','2',1,'Sale Id shift 201',0.00,0.00,0.00,4764.95,0.00,'2023-01-04 10:31:55','',''),(1219,'1','294','2',1,'Sale Id shift 201',0.00,0.00,0.00,4925.89,0.00,'2023-01-04 10:31:55','',''),(1220,'1','294','3',2,'Sale Id shift 201',0.00,0.00,0.00,3678.37,0.00,'2023-01-04 10:31:55','',''),(1221,'1','294','3',2,'Sale Id shift 201',0.00,0.00,0.00,1370.00,0.00,'2023-01-04 10:31:55','',''),(1222,'1','294',NULL,2,'Sale Id shift 201',4139663.40,0.00,0.00,0.00,0.00,'2023-01-04 10:31:55','',''),(1223,'1','294',NULL,1,'Sale Id shift 201',2431582.60,0.00,0.00,0.00,0.00,'2023-01-04 10:31:55','',''),(1224,'1','294','2',1,'Sale Id shift 202',0.00,0.00,0.00,3298.37,0.00,'2023-01-04 12:13:42','',''),(1225,'1','294','2',1,'Sale Id shift 202',0.00,0.00,0.00,3367.24,0.00,'2023-01-04 12:13:42','',''),(1226,'1','294','2',1,'Sale Id shift 202',0.00,0.00,0.00,3217.15,0.00,'2023-01-04 12:13:42','',''),(1227,'1','294','2',1,'Sale Id shift 202',0.00,0.00,0.00,385.53,0.00,'2023-01-04 12:13:42','',''),(1228,'1','294',NULL,1,'Sale Id shift 202',2413048.15,0.00,0.00,0.00,0.00,'2023-01-04 12:13:42','',''),(1229,'1','294','2',1,'Sale Id shift 203',0.00,0.00,0.00,3751.08,0.00,'2023-01-05 20:22:16','',''),(1230,'1','294','2',1,'Sale Id shift 203',0.00,0.00,0.00,2978.74,0.00,'2023-01-05 20:22:16','',''),(1231,'1','294','2',1,'Sale Id shift 203',0.00,0.00,0.00,1519.24,0.00,'2023-01-05 20:22:16','',''),(1232,'1','294',NULL,1,'Sale Id shift 203',1938529.10,0.00,0.00,0.00,0.00,'2023-01-05 20:22:16','',''),(1233,'1','294',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,16482000.00,20100.00,0.00,0.00,'2023-01-07 10:35:58','',''),(1234,'1','294',NULL,2,'Reception corrector for bridging 34',0.00,0.00,0.00,20100.00,0.00,'2023-01-07 10:47:04','',''),(1235,'1','294','3',2,'Received from bridging 34',0.00,0.00,20100.00,0.00,0.00,'2023-01-07 10:47:04','',''),(1236,'1','294','3',2,'Sale Id shift 204',0.00,0.00,0.00,40.25,0.00,'2023-01-07 14:44:16','',''),(1237,'1','294','3',2,'Sale Id shift 204',0.00,0.00,0.00,1887.44,0.00,'2023-01-07 14:44:16','',''),(1238,'1','294','3',2,'Sale Id shift 204',0.00,0.00,0.00,132.20,0.00,'2023-01-07 14:44:16','',''),(1239,'1','294',NULL,2,'Sale Id shift 204',1689109.80,0.00,0.00,0.00,0.00,'2023-01-07 14:44:16','',''),(1240,'1','294','3',2,'Sale Id shift 205',0.00,0.00,0.00,2181.25,0.00,'2023-01-08 09:59:08','',''),(1241,'1','294','3',2,'Sale Id shift 205',0.00,0.00,0.00,2629.03,0.00,'2023-01-08 09:59:08','',''),(1242,'1','294','3',2,'Sale Id shift 205',0.00,0.00,0.00,1000.00,0.00,'2023-01-08 09:59:08','',''),(1243,'1','294',NULL,2,'Sale Id shift 205',4764429.60,0.00,0.00,0.00,0.00,'2023-01-08 09:59:08','',''),(1244,'1','294','3',2,'Sale Id shift 206',0.00,0.00,0.00,1197.91,0.00,'2023-01-09 09:36:20','',''),(1245,'1','294','3',2,'Sale Id shift 206',0.00,0.00,0.00,1984.03,0.00,'2023-01-09 09:36:20','',''),(1246,'1','294',NULL,2,'Sale Id shift 206',2609190.80,0.00,0.00,0.00,0.00,'2023-01-09 09:36:20','',''),(1247,'1','294','3',2,'Sale Id shift 207',0.00,0.00,0.00,3188.73,0.00,'2023-01-09 11:32:59','',''),(1248,'1','294','3',2,'Sale Id shift 207',0.00,0.00,0.00,1547.06,0.00,'2023-01-09 11:32:59','',''),(1249,'1','294','3',2,'Sale Id shift 207',0.00,0.00,0.00,130.00,0.00,'2023-01-09 11:32:59','',''),(1250,'1','294',NULL,2,'Sale Id shift 207',3989947.80,0.00,0.00,0.00,0.00,'2023-01-09 11:32:59','',''),(1251,'1','294','3',2,'Sale Id shift 208',0.00,0.00,0.00,2368.26,0.00,'2023-01-09 17:03:04','',''),(1252,'1','294','3',2,'Sale Id shift 208',0.00,0.00,0.00,1721.18,0.00,'2023-01-09 17:03:04','',''),(1253,'1','294',NULL,2,'Sale Id shift 208',3353340.80,0.00,0.00,0.00,0.00,'2023-01-09 17:03:04','',''),(1254,'1','294','3',2,'Sale Id shift 209',0.00,0.00,0.00,130.00,0.00,'2023-01-10 09:50:40','',''),(1255,'1','294',NULL,2,'Sale Id shift 209',106600.00,0.00,0.00,0.00,0.00,'2023-01-10 09:50:40','',''),(1256,'1','294',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,7050000.00,30000.00,0.00,0.00,'2023-01-10 09:50:58','',''),(1257,'1','294',NULL,1,'Reception corrector for bridging 35',0.00,0.00,0.00,30000.00,0.00,'2023-01-10 12:10:01','',''),(1258,'1','294','1',1,'Received from bridging 35',0.00,0.00,30000.00,0.00,0.00,'2023-01-10 12:10:01','',''),(1259,'1','294','1',1,'Sale Id shift 210',0.00,0.00,0.00,4507.78,0.00,'2023-01-10 14:37:24','',''),(1260,'1','294','1',1,'Sale Id shift 210',0.00,0.00,0.00,3200.36,0.00,'2023-01-10 14:37:24','',''),(1261,'1','294','1',1,'Sale Id shift 210',0.00,0.00,0.00,4414.79,0.00,'2023-01-10 14:37:24','',''),(1262,'1','294',NULL,1,'Sale Id shift 210',2848888.55,0.00,0.00,0.00,0.00,'2023-01-10 14:37:24','',''),(1263,'1','294','1',1,'Sale Id shift 211',0.00,0.00,0.00,4191.64,0.00,'2023-01-11 10:14:46','',''),(1264,'1','294','1',1,'Sale Id shift 211',0.00,0.00,0.00,3511.12,0.00,'2023-01-11 10:14:46','',''),(1265,'1','294','1',1,'Sale Id shift 211',0.00,0.00,0.00,4410.51,0.00,'2023-01-11 10:14:46','',''),(1266,'1','294',NULL,1,'Sale Id shift 211',2846618.45,0.00,0.00,0.00,0.00,'2023-01-11 10:14:46','',''),(1267,'1','294',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,7050000.00,30000.00,0.00,0.00,'2023-01-11 18:27:57','',''),(1268,'1','294',NULL,1,'Reception corrector for bridging 36',0.00,0.00,0.00,30000.00,0.00,'2023-01-11 18:30:44','',''),(1269,'1','294','2',1,'Received from bridging 36',0.00,0.00,30000.00,0.00,0.00,'2023-01-11 18:30:44','',''),(1270,'1','294','1',1,'Sale Id shift 212',0.00,0.00,0.00,1495.89,0.00,'2023-01-12 12:25:48','',''),(1271,'1','294','2',1,'Sale Id shift 212',0.00,0.00,0.00,1609.33,0.00,'2023-01-12 12:25:48','',''),(1272,'1','294','2',1,'Sale Id shift 212',0.00,0.00,0.00,1172.48,0.00,'2023-01-12 12:25:48','',''),(1273,'1','294','2',1,'Sale Id shift 212',0.00,0.00,0.00,1330.30,0.00,'2023-01-12 12:25:48','',''),(1274,'1','294','2',1,'Sale Id shift 212',0.00,0.00,0.00,1463.11,0.00,'2023-01-12 12:25:48','',''),(1275,'1','294','1',1,'Sale Id shift 212',0.00,0.00,0.00,1532.45,0.00,'2023-01-12 12:25:48','',''),(1276,'1','294','1',1,'Sale Id shift 212',0.00,0.00,0.00,1572.53,0.00,'2023-01-12 12:25:48','',''),(1277,'1','294','1',1,'Sale Id shift 212',0.00,0.00,0.00,1020.85,0.00,'2023-01-12 12:25:48','',''),(1278,'1','294',NULL,1,'Sale Id shift 212',2631280.90,0.00,0.00,0.00,0.00,'2023-01-12 12:25:48','',''),(1279,'1','294','2',1,'Sale Id shift 213',0.00,0.00,0.00,4269.81,0.00,'2023-01-12 15:20:17','',''),(1280,'1','294','2',1,'Sale Id shift 213',0.00,0.00,0.00,3395.36,0.00,'2023-01-12 15:20:17','',''),(1281,'1','294','2',1,'Sale Id shift 213',0.00,0.00,0.00,27.66,0.00,'2023-01-12 15:20:17','',''),(1282,'1','294','2',1,'Sale Id shift 213',0.00,0.00,0.00,2934.39,0.00,'2023-01-12 15:20:17','',''),(1283,'1','294','2',1,'Sale Id shift 213',0.00,0.00,0.00,4012.77,0.00,'2023-01-12 15:20:17','',''),(1284,'1','294',NULL,1,'Sale Id shift 213',3440397.65,0.00,0.00,0.00,0.00,'2023-01-12 15:20:17','',''),(1285,'1','294',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,4700000.00,20000.00,0.00,0.00,'2023-01-12 15:20:33','',''),(1286,'1','294',NULL,1,'Reception corrector for bridging 37',0.00,0.00,0.00,19900.00,0.00,'2023-01-12 16:45:44','',''),(1287,'1','294','2',1,'Received from bridging 37',0.00,0.00,19900.00,0.00,0.00,'2023-01-12 16:45:44','',''),(1288,'1','294','2',1,'Sale Id shift 214',0.00,0.00,0.00,4234.94,0.00,'2023-01-13 10:38:05','',''),(1289,'1','294','2',1,'Sale Id shift 214',0.00,0.00,0.00,3743.80,0.00,'2023-01-13 10:38:05','',''),(1290,'1','294','2',1,'Sale Id shift 214',0.00,0.00,0.00,1771.01,0.00,'2023-01-13 10:38:05','',''),(1291,'1','294','2',1,'Sale Id shift 214',0.00,0.00,0.00,3551.33,0.00,'2023-01-13 10:38:05','',''),(1292,'1','294','2',1,'Sale Id shift 214',0.00,0.00,0.00,2780.07,0.00,'2023-01-13 10:38:05','',''),(1293,'1','294',NULL,1,'Sale Id shift 214',3779070.25,0.00,0.00,0.00,0.00,'2023-01-13 10:38:05','',''),(1294,'1','294','2',1,'Sale Id shift 215',0.00,0.00,0.00,4985.91,0.00,'2023-01-13 21:50:53','',''),(1295,'1','294','2',1,'Sale Id shift 215',0.00,0.00,0.00,1002.17,0.00,'2023-01-13 21:50:53','',''),(1296,'1','294','2',1,'Sale Id shift 215',0.00,0.00,0.00,3895.53,0.00,'2023-01-13 21:50:53','',''),(1297,'1','294','2',1,'Sale Id shift 215',0.00,0.00,0.00,3925.53,0.00,'2023-01-13 21:50:53','',''),(1298,'1','294','2',1,'Sale Id shift 215',0.00,0.00,0.00,0.38,0.00,'2023-01-13 21:50:53','',''),(1299,'1','294',NULL,1,'Sale Id shift 215',3245237.20,0.00,0.00,0.00,0.00,'2023-01-13 21:50:53','',''),(1300,'1','294',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,32800000.00,40000.00,0.00,0.00,'2023-01-14 16:49:32','',''),(1301,'1','294',NULL,2,'Reception corrector for bridging 38',0.00,0.00,0.00,40000.00,0.00,'2023-01-14 17:19:55','',''),(1302,'1','294','3',2,'Received from bridging 38',0.00,0.00,40000.00,0.00,0.00,'2023-01-14 17:19:55','',''),(1303,'1','294','3',2,'Sale Id shift 216',0.00,0.00,0.00,1354.40,0.00,'2023-01-14 17:38:51','',''),(1304,'1','294','3',2,'Sale Id shift 216',0.00,0.00,0.00,120.00,0.00,'2023-01-14 17:38:51','',''),(1305,'1','294',NULL,2,'Sale Id shift 216',1209008.00,0.00,0.00,0.00,0.00,'2023-01-14 17:38:51','',''),(1306,'1','294','3',2,'Sale Id shift 217',0.00,0.00,0.00,2051.11,0.00,'2023-01-15 12:29:44','',''),(1307,'1','294','3',2,'Sale Id shift 217',0.00,0.00,0.00,613.54,0.00,'2023-01-15 12:29:44','',''),(1308,'1','294',NULL,2,'Sale Id shift 217',2185013.00,0.00,0.00,0.00,0.00,'2023-01-15 12:29:44','',''),(1309,'1','294','3',2,'Sale Id shift 218',0.00,0.00,0.00,2000.20,0.00,'2023-01-15 13:57:13','',''),(1310,'1','294','3',2,'Sale Id shift 218',0.00,0.00,0.00,1885.94,0.00,'2023-01-15 13:57:13','',''),(1311,'1','294','3',2,'Sale Id shift 218',0.00,0.00,0.00,452.36,0.00,'2023-01-15 13:57:13','',''),(1312,'1','294',NULL,2,'Sale Id shift 218',3557570.00,0.00,0.00,0.00,0.00,'2023-01-15 13:57:13','',''),(1313,'1','294','3',2,'Sale Id shift 219',0.00,0.00,0.00,3126.59,0.00,'2023-01-16 09:18:36','',''),(1314,'1','294','3',2,'Sale Id shift 219',0.00,0.00,0.00,2484.55,0.00,'2023-01-16 09:18:36','',''),(1315,'1','294',NULL,2,'Sale Id shift 219',4601134.80,0.00,0.00,0.00,0.00,'2023-01-16 09:18:36','',''),(1316,'1','294',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,16400000.00,20000.00,0.00,0.00,'2023-01-16 12:54:33','',''),(1317,'1','294','3',2,'Sale Id shift 220',0.00,0.00,0.00,520.22,0.00,'2023-01-16 12:54:54','',''),(1318,'1','294','3',2,'Sale Id shift 220',0.00,0.00,0.00,1752.60,0.00,'2023-01-16 12:54:54','',''),(1319,'1','294','3',2,'Sale Id shift 220',0.00,0.00,0.00,632.20,0.00,'2023-01-16 12:54:54','',''),(1320,'1','294',NULL,2,'Sale Id shift 220',2382116.40,0.00,0.00,0.00,0.00,'2023-01-16 12:54:54','',''),(1321,'1','294','3',2,'Sale Id shift 221',0.00,0.00,0.00,2138.74,0.00,'2023-01-16 14:59:37','',''),(1322,'1','294','3',2,'Sale Id shift 221',0.00,0.00,0.00,1635.86,0.00,'2023-01-16 14:59:37','',''),(1323,'1','294',NULL,2,'Sale Id shift 221',3095172.00,0.00,0.00,0.00,0.00,'2023-01-16 14:59:37','',''),(1324,'1','294','3',2,'Sale Id shift 222',0.00,0.00,0.00,2814.43,0.00,'2023-01-17 11:53:09','',''),(1325,'1','294','3',2,'Sale Id shift 222',0.00,0.00,0.00,3830.76,0.00,'2023-01-17 11:53:09','',''),(1326,'1','294','3',2,'Sale Id shift 222',0.00,0.00,0.00,500.00,0.00,'2023-01-17 11:53:09','',''),(1327,'1','294',NULL,2,'Sale Id shift 222',5859055.80,0.00,0.00,0.00,0.00,'2023-01-17 11:53:09','',''),(1328,'1','294','3',2,'Sale Id shift 223',0.00,0.00,0.00,2029.50,0.00,'2023-01-17 19:40:59','',''),(1329,'1','294','3',2,'Sale Id shift 223',0.00,0.00,0.00,1660.16,0.00,'2023-01-17 19:40:59','',''),(1330,'1','294',NULL,2,'Sale Id shift 223',3025521.20,0.00,0.00,0.00,0.00,'2023-01-17 19:40:59','',''),(1331,'1','294','3',2,'Sale Id shift 224',0.00,0.00,0.00,2168.42,0.00,'2023-01-18 12:34:17','',''),(1332,'1','294','3',2,'Sale Id shift 224',0.00,0.00,0.00,2256.79,0.00,'2023-01-18 12:34:17','',''),(1333,'1','294','3',2,'Sale Id shift 224',0.00,0.00,0.00,789.00,0.00,'2023-01-18 12:34:17','',''),(1334,'1','294',NULL,2,'Sale Id shift 224',4275652.20,0.00,0.00,0.00,0.00,'2023-01-18 12:34:17','',''),(1335,'1','294',NULL,2,'Reception corrector for bridging 39',0.00,0.00,0.00,20000.00,0.00,'2023-01-18 13:37:57','',''),(1336,'1','294','3',2,'Received from bridging 39',0.00,0.00,20000.00,0.00,0.00,'2023-01-18 13:37:57','',''),(1337,'1','294','3',2,'Sale Id shift 225',0.00,0.00,0.00,629.77,0.00,'2023-01-18 14:23:26','',''),(1338,'1','294','3',2,'Sale Id shift 225',0.00,0.00,0.00,243.09,0.00,'2023-01-18 14:23:26','',''),(1339,'1','294','3',2,'Sale Id shift 225',0.00,0.00,0.00,1361.91,0.00,'2023-01-18 14:23:26','',''),(1340,'1','294',NULL,2,'Sale Id shift 225',1810163.70,0.00,0.00,0.00,0.00,'2023-01-18 14:23:26','',''),(1341,'1','294','3',2,'Sale Id shift 226',0.00,0.00,0.00,1066.86,0.00,'2023-01-18 18:53:09','',''),(1342,'1','294','3',2,'Sale Id shift 226',0.00,0.00,0.00,1246.94,0.00,'2023-01-18 18:53:09','',''),(1343,'1','294',NULL,2,'Sale Id shift 226',1874178.00,0.00,0.00,0.00,0.00,'2023-01-18 18:53:09','',''),(1344,'1','294',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,14100000.00,60000.00,0.00,0.00,'2023-01-19 14:31:07','',''),(1345,'1','294','3',2,'Sale Id shift 227',0.00,0.00,0.00,2594.52,0.00,'2023-01-19 14:31:25','',''),(1346,'1','294','3',2,'Sale Id shift 227',0.00,0.00,0.00,4427.01,0.00,'2023-01-19 14:31:25','',''),(1347,'1','294',NULL,2,'Sale Id shift 227',5687439.30,0.00,0.00,0.00,0.00,'2023-01-19 14:31:25','',''),(1348,'1','294',NULL,1,'Reception corrector for bridging 41',0.00,0.00,0.00,20000.00,0.00,'2023-01-19 15:36:13','',''),(1349,'1','294','2',1,'Received from bridging 41',0.00,0.00,20000.00,0.00,0.00,'2023-01-19 15:36:13','',''),(1350,'1','294',NULL,1,'Reception corrector for bridging 40',0.00,0.00,0.00,40000.00,0.00,'2023-01-19 15:36:13','',''),(1351,'1','294','1',1,'Received from bridging 40',0.00,0.00,40000.00,0.00,0.00,'2023-01-19 15:36:13','',''),(1352,'1','294','2',1,'Sale Id shift 228',0.00,0.00,0.00,4189.76,0.00,'2023-01-19 16:48:02','',''),(1353,'1','294','2',1,'Sale Id shift 228',0.00,0.00,0.00,5411.31,0.00,'2023-01-19 16:48:02','',''),(1354,'1','294','2',1,'Sale Id shift 228',0.00,0.00,0.00,2898.33,0.00,'2023-01-19 16:48:02','',''),(1355,'1','294','2',1,'Sale Id shift 228',0.00,0.00,0.00,5612.12,0.00,'2023-01-19 16:48:02','',''),(1356,'1','294','3',2,'Sale Id shift 228',0.00,0.00,0.00,752.78,0.00,'2023-01-19 16:48:02','',''),(1357,'1','294','3',2,'Sale Id shift 228',0.00,0.00,0.00,100.01,0.00,'2023-01-19 16:48:02','',''),(1358,'1','294','3',2,'Sale Id shift 228',0.00,0.00,0.00,2783.67,0.00,'2023-01-19 16:48:02','',''),(1359,'1','294','3',2,'Sale Id shift 228',0.00,0.00,0.00,300.00,0.00,'2023-01-19 16:48:02','',''),(1360,'1','294',NULL,2,'Sale Id shift 228',3188532.60,0.00,0.00,0.00,0.00,'2023-01-19 16:48:02','',''),(1361,'1','294',NULL,1,'Sale Id shift 228',4256207.20,0.00,0.00,0.00,0.00,'2023-01-19 16:48:02','',''),(1362,'1','294','3',2,'Sale Id shift 229',0.00,0.00,0.00,2607.98,0.00,'2023-01-20 09:46:54','',''),(1363,'1','294','3',2,'Sale Id shift 229',0.00,0.00,0.00,2887.36,0.00,'2023-01-20 09:46:54','',''),(1364,'1','294','3',2,'Sale Id shift 229',0.00,0.00,0.00,2169.05,0.00,'2023-01-20 09:46:54','',''),(1365,'1','294',NULL,2,'Sale Id shift 229',6208155.90,0.00,0.00,0.00,0.00,'2023-01-20 09:46:54','',''),(1366,'1','294','1',1,'Sale Id shift 230',0.00,0.00,0.00,135.50,0.00,'2023-01-22 11:11:04','',''),(1367,'1','294','1',1,'Sale Id shift 230',0.00,0.00,0.00,74.79,0.00,'2023-01-22 11:11:04','',''),(1368,'1','294','1',1,'Sale Id shift 230',0.00,0.00,0.00,108.03,0.00,'2023-01-22 11:11:04','',''),(1369,'1','294',NULL,1,'Sale Id shift 230',74805.20,0.00,0.00,0.00,0.00,'2023-01-22 11:11:04','',''),(1370,'1','294','1',1,'Sale Id shift 231',0.00,0.00,0.00,4192.53,0.00,'2023-01-22 12:31:50','',''),(1371,'1','294','3',2,'Sale Id shift 231',0.00,0.00,0.00,642.99,0.00,'2023-01-22 12:31:50','',''),(1372,'1','294','3',2,'Sale Id shift 231',0.00,0.00,0.00,110.00,0.00,'2023-01-22 12:31:50','',''),(1373,'1','294','1',1,'Sale Id shift 231',0.00,0.00,0.00,4300.15,0.00,'2023-01-22 12:31:50','',''),(1374,'1','294','1',1,'Sale Id shift 231',0.00,0.00,0.00,5004.97,0.00,'2023-01-22 12:31:50','',''),(1375,'1','294','1',1,'Sale Id shift 231',0.00,0.00,0.00,2833.06,0.00,'2023-01-22 12:31:50','',''),(1376,'1','294','1',1,'Sale Id shift 231',0.00,0.00,0.00,752.05,0.00,'2023-01-22 12:31:50','',''),(1377,'1','294',NULL,2,'Sale Id shift 231',609921.90,0.00,0.00,0.00,0.00,'2023-01-22 12:31:50','',''),(1378,'1','294',NULL,1,'Sale Id shift 231',4014448.60,0.00,0.00,0.00,0.00,'2023-01-22 12:31:50','',''),(1379,'1','294','1',1,'Sale Id shift 232',0.00,0.00,0.00,1791.95,0.00,'2023-01-22 21:22:39','',''),(1380,'1','294','2',1,'Sale Id shift 232',0.00,0.00,0.00,504.11,0.00,'2023-01-22 21:22:39','',''),(1381,'1','294','1',1,'Sale Id shift 232',0.00,0.00,0.00,4725.42,0.00,'2023-01-22 21:22:39','',''),(1382,'1','294','1',1,'Sale Id shift 232',0.00,0.00,0.00,3549.56,0.00,'2023-01-22 21:22:39','',''),(1383,'1','294','1',1,'Sale Id shift 232',0.00,0.00,0.00,2430.75,0.00,'2023-01-22 21:22:39','',''),(1384,'1','294','1',1,'Sale Id shift 232',0.00,0.00,0.00,3855.57,0.00,'2023-01-22 21:22:39','',''),(1385,'1','294','1',1,'Sale Id shift 232',0.00,0.00,0.00,1504.44,0.00,'2023-01-22 21:22:39','',''),(1386,'1','294','1',1,'Sale Id shift 232',0.00,0.00,0.00,3649.12,0.00,'2023-01-22 21:22:39','',''),(1387,'1','294','1',1,'Sale Id shift 232',0.00,0.00,0.00,1072.36,0.00,'2023-01-22 21:22:39','',''),(1388,'1','294',NULL,1,'Sale Id shift 232',5424570.80,0.00,0.00,0.00,0.00,'2023-01-22 21:22:39','',''),(1389,'1','294','2',1,'Sale Id shift 233',0.00,0.00,0.00,395.10,0.00,'2023-01-22 21:35:05','',''),(1390,'1','294','2',1,'Sale Id shift 233',0.00,0.00,0.00,38.81,0.00,'2023-01-22 21:35:05','',''),(1391,'1','294','2',1,'Sale Id shift 233',0.00,0.00,0.00,452.00,0.00,'2023-01-22 21:35:05','',''),(1392,'1','294','2',1,'Sale Id shift 233',0.00,0.00,0.00,347.34,0.00,'2023-01-22 21:35:05','',''),(1393,'1','294',NULL,1,'Sale Id shift 233',289813.75,0.00,0.00,0.00,0.00,'2023-01-22 21:35:05','',''),(1394,'1','294',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,13588000.00,17200.00,0.00,0.00,'2023-01-28 14:31:13','',''),(1395,'1','294',NULL,2,'Reception corrector for bridging 42',0.00,0.00,0.00,17200.00,0.00,'2023-01-28 14:52:59','',''),(1396,'1','294','3',2,'Received from bridging 42',0.00,0.00,17200.00,0.00,0.00,'2023-01-28 14:52:59','',''),(1397,'1','294','3',2,'Sale Id shift 234',0.00,0.00,0.00,508.74,0.00,'2023-01-28 15:04:59','',''),(1398,'1','294','3',2,'Sale Id shift 234',0.00,0.00,0.00,251.13,0.00,'2023-01-28 15:04:59','',''),(1399,'1','294','3',2,'Sale Id shift 234',0.00,0.00,0.00,1303.28,0.00,'2023-01-28 15:04:59','',''),(1400,'1','294',NULL,2,'Sale Id shift 234',1629888.50,0.00,0.00,0.00,0.00,'2023-01-28 15:04:59','',''),(1401,'1','294','3',2,'Sale Id shift 235',0.00,0.00,0.00,1247.70,0.00,'2023-01-29 14:33:30','',''),(1402,'1','294','3',2,'Sale Id shift 235',0.00,0.00,0.00,1114.87,0.00,'2023-01-29 14:33:30','',''),(1403,'1','294','3',2,'Sale Id shift 235',0.00,0.00,0.00,2694.61,0.00,'2023-01-29 14:33:30','',''),(1404,'1','294','3',2,'Sale Id shift 235',0.00,0.00,0.00,1134.45,0.00,'2023-01-29 14:33:30','',''),(1405,'1','294',NULL,2,'Sale Id shift 235',4891387.70,0.00,0.00,0.00,0.00,'2023-01-29 14:33:30','',''),(1406,'1','294','3',2,'Sale Id shift 236',0.00,0.00,0.00,528.28,0.00,'2023-01-29 18:53:42','',''),(1407,'1','294','3',2,'Sale Id shift 236',0.00,0.00,0.00,385.49,0.00,'2023-01-29 18:53:42','',''),(1408,'1','294','3',2,'Sale Id shift 236',0.00,0.00,0.00,180.13,0.00,'2023-01-29 18:53:42','',''),(1409,'1','294',NULL,2,'Sale Id shift 236',864181.00,0.00,0.00,0.00,0.00,'2023-01-29 18:53:42','',''),(1410,'1','294','3',2,'Sale Id shift 237',0.00,0.00,0.00,1390.00,0.00,'2023-01-30 10:53:05','',''),(1411,'1','294','3',2,'Sale Id shift 237',0.00,0.00,0.00,125.00,0.00,'2023-01-30 10:53:05','',''),(1412,'1','294','3',2,'Sale Id shift 237',0.00,0.00,0.00,1604.95,0.00,'2023-01-30 10:53:05','',''),(1413,'1','294',NULL,2,'Sale Id shift 237',2464760.50,0.00,0.00,0.00,0.00,'2023-01-30 10:53:05','',''),(1414,'1','294','3',2,'Sale Id shift 238',0.00,0.00,0.00,1199.88,0.00,'2023-01-30 16:03:19','',''),(1415,'1','294','3',2,'Sale Id shift 238',0.00,0.00,0.00,3119.97,0.00,'2023-01-30 16:03:19','',''),(1416,'1','294',NULL,2,'Sale Id shift 238',3412681.50,0.00,0.00,0.00,0.00,'2023-01-30 16:03:19','',''),(1417,'1','294','3',2,'Sale Id shift 239',0.00,0.00,0.00,254.03,0.00,'2023-01-30 21:24:01','',''),(1418,'1','294','3',2,'Sale Id shift 239',0.00,0.00,0.00,1.53,0.00,'2023-01-30 21:24:01','',''),(1419,'1','294','3',2,'Sale Id shift 239',0.00,0.00,0.00,177.84,0.00,'2023-01-30 21:24:01','',''),(1420,'1','294',NULL,2,'Sale Id shift 239',342386.00,0.00,0.00,0.00,0.00,'2023-01-30 21:24:01','',''),(1421,'1','294',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,7500000.00,30000.00,0.00,0.00,'2023-01-31 16:07:50','',''),(1422,'1','294',NULL,1,'Reception corrector for bridging 43',0.00,0.00,0.00,30000.00,0.00,'2023-01-31 18:37:39','',''),(1423,'1','294','2',1,'Received from bridging 43',0.00,0.00,30000.00,0.00,0.00,'2023-01-31 18:37:39','',''),(1424,'1','294','2',1,'Sale Id shift 240',0.00,0.00,0.00,3642.59,0.00,'2023-01-31 22:31:13','',''),(1425,'1','294','2',1,'Sale Id shift 240',0.00,0.00,0.00,4719.97,0.00,'2023-01-31 22:31:13','',''),(1426,'1','294','2',1,'Sale Id shift 240',0.00,0.00,0.00,4194.85,0.00,'2023-01-31 22:31:13','',''),(1427,'1','294','2',1,'Sale Id shift 240',0.00,0.00,0.00,1889.61,0.00,'2023-01-31 22:31:13','',''),(1428,'1','294','2',1,'Sale Id shift 240',0.00,0.00,0.00,2965.35,0.00,'2023-01-31 22:31:13','',''),(1429,'1','294','2',1,'Sale Id shift 240',0.00,0.00,0.00,2691.52,0.00,'2023-01-31 22:31:13','',''),(1430,'1','294',NULL,1,'Sale Id shift 240',5025972.50,0.00,0.00,0.00,0.00,'2023-01-31 22:31:13','',''),(1431,'1','294','2',1,'Sale Id shift 241',0.00,0.00,0.00,1325.92,0.00,'2023-02-01 09:34:08','',''),(1432,'1','294','2',1,'Sale Id shift 241',0.00,0.00,0.00,1790.17,0.00,'2023-02-01 09:34:08','',''),(1433,'1','294','2',1,'Sale Id shift 241',0.00,0.00,0.00,927.72,0.00,'2023-02-01 09:34:08','',''),(1434,'1','294','2',1,'Sale Id shift 241',0.00,0.00,0.00,2284.19,0.00,'2023-02-01 09:34:08','',''),(1435,'1','294','2',1,'Sale Id shift 241',0.00,0.00,0.00,2049.58,0.00,'2023-02-01 09:34:08','',''),(1436,'1','294','2',1,'Sale Id shift 241',0.00,0.00,0.00,310.40,0.00,'2023-02-01 09:34:08','',''),(1437,'1','294',NULL,1,'Sale Id shift 241',2171995.00,0.00,0.00,0.00,0.00,'2023-02-01 09:34:08','',''),(1438,'1','294','2',1,'Sale Id shift 242',0.00,0.00,0.00,237.08,0.00,'2023-02-02 12:52:53','',''),(1439,'1','294','2',1,'Sale Id shift 242',0.00,0.00,0.00,403.71,0.00,'2023-02-02 12:52:53','',''),(1440,'1','294','2',1,'Sale Id shift 242',0.00,0.00,0.00,167.96,0.00,'2023-02-02 12:52:53','',''),(1441,'1','294','2',1,'Sale Id shift 242',0.00,0.00,0.00,400.06,0.00,'2023-02-02 12:52:53','',''),(1442,'1','294',NULL,1,'Sale Id shift 242',302202.50,0.00,0.00,0.00,0.00,'2023-02-02 12:52:53','',''),(1443,'1','294',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,10060000.00,50300.00,0.00,0.00,'2023-02-07 14:16:29','',''),(1444,'1','294',NULL,1,'Reception corrector for bridging 45',0.00,0.00,0.00,33300.00,0.00,'2023-02-07 14:53:26','',''),(1445,'1','294','2',1,'Received from bridging 45',0.00,0.00,33300.00,0.00,0.00,'2023-02-07 14:53:26','',''),(1446,'1','294',NULL,1,'Reception corrector for bridging 44',0.00,0.00,0.00,17000.00,0.00,'2023-02-07 14:53:26','',''),(1447,'1','294','1',1,'Received from bridging 44',0.00,0.00,17000.00,0.00,0.00,'2023-02-07 14:53:26','',''),(1448,'1','294','1',1,'Sale Id shift 243',0.00,0.00,0.00,184.41,0.00,'2023-02-07 19:55:45','',''),(1449,'1','294','1',1,'Sale Id shift 243',0.00,0.00,0.00,3204.71,0.00,'2023-02-07 19:55:45','',''),(1450,'1','294','1',1,'Sale Id shift 243',0.00,0.00,0.00,3518.08,0.00,'2023-02-07 19:55:45','',''),(1451,'1','294','1',1,'Sale Id shift 243',0.00,0.00,0.00,1904.31,0.00,'2023-02-07 19:55:45','',''),(1452,'1','294','1',1,'Sale Id shift 243',0.00,0.00,0.00,3090.94,0.00,'2023-02-07 19:55:45','',''),(1453,'1','294','1',1,'Sale Id shift 243',0.00,0.00,0.00,1898.64,0.00,'2023-02-07 19:55:45','',''),(1454,'1','294','1',1,'Sale Id shift 243',0.00,0.00,0.00,3108.37,0.00,'2023-02-07 19:55:45','',''),(1455,'1','294',NULL,1,'Sale Id shift 243',3381892.00,0.00,0.00,0.00,0.00,'2023-02-07 19:55:45','',''),(1456,'1','294','2',1,'Sale Id shift 244',0.00,0.00,0.00,3978.26,0.00,'2023-02-08 17:14:58','',''),(1457,'1','294','2',1,'Sale Id shift 244',0.00,0.00,0.00,3859.39,0.00,'2023-02-08 17:14:58','',''),(1458,'1','294','2',1,'Sale Id shift 244',0.00,0.00,0.00,3066.81,0.00,'2023-02-08 17:14:58','',''),(1459,'1','294','2',1,'Sale Id shift 244',0.00,0.00,0.00,2898.16,0.00,'2023-02-08 17:14:58','',''),(1460,'1','294','2',1,'Sale Id shift 244',0.00,0.00,0.00,3109.57,0.00,'2023-02-08 17:14:58','',''),(1461,'1','294','2',1,'Sale Id shift 244',0.00,0.00,0.00,1874.56,0.00,'2023-02-08 17:14:58','',''),(1462,'1','294',NULL,1,'Sale Id shift 244',3757350.00,0.00,0.00,0.00,0.00,'2023-02-08 17:14:58','',''),(1463,'1','294','2',1,'Sale Id shift 245',0.00,0.00,0.00,1574.55,0.00,'2023-02-08 21:10:46','',''),(1464,'1','294','2',1,'Sale Id shift 245',0.00,0.00,0.00,3618.51,0.00,'2023-02-08 21:10:46','',''),(1465,'1','294','2',1,'Sale Id shift 245',0.00,0.00,0.00,3191.94,0.00,'2023-02-08 21:10:46','',''),(1466,'1','294','2',1,'Sale Id shift 245',0.00,0.00,0.00,2649.57,0.00,'2023-02-08 21:10:46','',''),(1467,'1','294','2',1,'Sale Id shift 245',0.00,0.00,0.00,3402.87,0.00,'2023-02-08 21:10:46','',''),(1468,'1','294',NULL,1,'Sale Id shift 245',2887488.00,0.00,0.00,0.00,0.00,'2023-02-08 21:10:46','',''),(1469,'1','294',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,36000000.00,45000.00,0.00,0.00,'2023-02-09 18:19:49','',''),(1470,'1','294',NULL,2,'Reception corrector for bridging 46',0.00,0.00,0.00,45000.00,0.00,'2023-02-10 07:10:38','',''),(1471,'1','294','3',2,'Received from bridging 46',0.00,0.00,45000.00,0.00,0.00,'2023-02-10 07:10:38','',''),(1472,'1','294','3',2,'Sale Id shift 246',0.00,0.00,0.00,1056.13,0.00,'2023-02-10 12:01:45','',''),(1473,'1','294','3',2,'Sale Id shift 246',0.00,0.00,0.00,1134.27,0.00,'2023-02-10 12:01:45','',''),(1474,'1','294','3',2,'Sale Id shift 246',0.00,0.00,0.00,38.13,0.00,'2023-02-10 12:01:45','',''),(1475,'1','294',NULL,2,'Sale Id shift 246',1782824.00,0.00,0.00,0.00,0.00,'2023-02-10 12:01:45','',''),(1476,'1','294','3',2,'Sale Id shift 247',0.00,0.00,0.00,1663.13,0.00,'2023-02-10 15:21:56','',''),(1477,'1','294','3',2,'Sale Id shift 247',0.00,0.00,0.00,1469.90,0.00,'2023-02-10 15:21:56','',''),(1478,'1','294',NULL,2,'Sale Id shift 247',2506424.00,0.00,0.00,0.00,0.00,'2023-02-10 15:21:56','',''),(1479,'1','294','3',2,'Sale Id shift 248',0.00,0.00,0.00,837.49,0.00,'2023-02-11 09:27:29','',''),(1480,'1','294','3',2,'Sale Id shift 248',0.00,0.00,0.00,1330.08,0.00,'2023-02-11 09:27:29','',''),(1481,'1','294','3',2,'Sale Id shift 248',0.00,0.00,0.00,1340.01,0.00,'2023-02-11 09:27:29','',''),(1482,'1','294','3',2,'Sale Id shift 248',0.00,0.00,0.00,1202.50,0.00,'2023-02-11 09:27:29','',''),(1483,'1','294',NULL,2,'Sale Id shift 248',3768064.00,0.00,0.00,0.00,0.00,'2023-02-11 09:27:29','',''),(1484,'1','294','3',2,'Sale Id shift 249',0.00,0.00,0.00,2662.50,0.00,'2023-02-11 15:26:49','',''),(1485,'1','294','3',2,'Sale Id shift 249',0.00,0.00,0.00,2605.00,0.00,'2023-02-11 15:26:49','',''),(1486,'1','294',NULL,2,'Sale Id shift 249',4214000.00,0.00,0.00,0.00,0.00,'2023-02-11 15:26:49','',''),(1487,'1','294','3',2,'Sale Id shift 250',0.00,0.00,0.00,2319.51,0.00,'2023-02-12 13:54:55','',''),(1488,'1','294','3',2,'Sale Id shift 250',0.00,0.00,0.00,3392.20,0.00,'2023-02-12 13:54:55','',''),(1489,'1','294',NULL,2,'Sale Id shift 250',4569368.00,0.00,0.00,0.00,0.00,'2023-02-12 13:54:55','',''),(1490,'1','294','3',2,'Sale Id shift 251',0.00,0.00,0.00,500.76,0.00,'2023-02-12 13:59:37','',''),(1491,'1','294','3',2,'Sale Id shift 251',0.00,0.00,0.00,1298.75,0.00,'2023-02-12 13:59:37','',''),(1492,'1','294','3',2,'Sale Id shift 251',0.00,0.00,0.00,100.00,0.00,'2023-02-12 13:59:37','',''),(1493,'1','294',NULL,2,'Sale Id shift 251',1519608.00,0.00,0.00,0.00,0.00,'2023-02-12 13:59:37','',''),(1494,'1','294','3',2,'Sale Id shift 252',0.00,0.00,0.00,1651.06,0.00,'2023-02-13 14:44:14','',''),(1495,'1','294','3',2,'Sale Id shift 252',0.00,0.00,0.00,1965.68,0.00,'2023-02-13 14:44:14','',''),(1496,'1','294',NULL,2,'Sale Id shift 252',2893392.00,0.00,0.00,0.00,0.00,'2023-02-13 14:44:14','',''),(1497,'1','294','3',2,'Sale Id shift 253',0.00,0.00,0.00,668.63,0.00,'2023-02-13 19:16:15','',''),(1498,'1','294','3',2,'Sale Id shift 253',0.00,0.00,0.00,368.88,0.00,'2023-02-13 19:16:15','',''),(1499,'1','294',NULL,2,'Sale Id shift 253',830008.00,0.00,0.00,0.00,0.00,'2023-02-13 19:16:15','',''),(1500,'1','294','3',2,'Sale Id shift 254',0.00,0.00,0.00,943.53,0.00,'2023-02-14 15:29:50','',''),(1501,'1','294','3',2,'Sale Id shift 254',0.00,0.00,0.00,1692.74,0.00,'2023-02-14 15:29:50','',''),(1502,'1','294',NULL,2,'Sale Id shift 254',2109016.00,0.00,0.00,0.00,0.00,'2023-02-14 15:29:50','',''),(1503,'1','294','3',2,'Sale Id shift 255',0.00,0.00,0.00,2235.63,0.00,'2023-02-14 23:19:55','',''),(1504,'1','294','3',2,'Sale Id shift 255',0.00,0.00,0.00,755.13,0.00,'2023-02-14 23:19:55','',''),(1505,'1','294',NULL,2,'Sale Id shift 255',2392608.00,0.00,0.00,0.00,0.00,'2023-02-14 23:19:55','',''),(1506,'1','294','3',2,'Sale Id shift 256',0.00,0.00,0.00,625.01,0.00,'2023-02-15 14:35:49','',''),(1507,'1','294','3',2,'Sale Id shift 256',0.00,0.00,0.00,1091.44,0.00,'2023-02-15 14:35:49','',''),(1508,'1','294','3',2,'Sale Id shift 256',0.00,0.00,0.00,790.01,0.00,'2023-02-15 14:35:49','',''),(1509,'1','294',NULL,2,'Sale Id shift 256',2005168.00,0.00,0.00,0.00,0.00,'2023-02-15 14:35:49','',''),(1510,'1','294','3',2,'Sale Id shift 257',0.00,0.00,0.00,2604.23,0.00,'2023-02-15 15:44:38','',''),(1511,'1','294','3',2,'Sale Id shift 257',0.00,0.00,0.00,1633.92,0.00,'2023-02-15 15:44:38','',''),(1512,'1','294',NULL,2,'Sale Id shift 257',3390520.00,0.00,0.00,0.00,0.00,'2023-02-15 15:44:38','',''),(1513,'1','294','3',2,'Sale Id shift 258',0.00,0.00,0.00,551.67,0.00,'2023-02-16 11:53:54','',''),(1514,'1','294','3',2,'Sale Id shift 258',0.00,0.00,0.00,873.19,0.00,'2023-02-16 11:53:54','',''),(1515,'1','294','3',2,'Sale Id shift 258',0.00,0.00,0.00,1110.36,0.00,'2023-02-16 11:53:54','',''),(1516,'1','294',NULL,2,'Sale Id shift 258',2028176.00,0.00,0.00,0.00,0.00,'2023-02-16 11:53:54','',''),(1517,'1','294',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3400000.00,17000.00,0.00,0.00,'2023-02-16 15:28:29','',''),(1518,'1','294',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,5350000.00,26750.00,0.00,0.00,'2023-02-16 15:28:46','',''),(1519,'1','294',NULL,1,'Reception corrector for bridging 47',0.00,0.00,0.00,17000.00,0.00,'2023-02-16 21:33:17','',''),(1520,'1','294','1',1,'Received from bridging 47',0.00,0.00,17000.00,0.00,0.00,'2023-02-16 21:33:17','',''),(1521,'1','294',NULL,1,'Reception corrector for bridging 48',0.00,0.00,0.00,26600.00,0.00,'2023-02-16 21:33:32','',''),(1522,'1','294','2',1,'Received from bridging 48',0.00,0.00,26600.00,0.00,0.00,'2023-02-16 21:33:32','',''),(1523,'1','294','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,2639.63,0.00,'2023-02-16 21:54:34','',''),(1524,'1','294','3',0,'Inventory adjustment from tank dipping to 3500',0.00,0.00,3500.00,0.00,0.00,'2023-02-16 21:54:34','',''),(1525,'1','294','1',1,'Sale Id shift 259',0.00,0.00,0.00,5239.27,0.00,'2023-02-17 08:18:40','',''),(1526,'1','294','3',2,'Sale Id shift 259',0.00,0.00,0.00,2249.41,0.00,'2023-02-17 08:18:40','',''),(1527,'1','294','3',2,'Sale Id shift 259',0.00,0.00,0.00,1010.43,0.00,'2023-02-17 08:18:40','',''),(1528,'1','294','1',1,'Sale Id shift 259',0.00,0.00,0.00,2612.34,0.00,'2023-02-17 08:18:40','',''),(1529,'1','294','1',1,'Sale Id shift 259',0.00,0.00,0.00,2603.95,0.00,'2023-02-17 08:18:40','',''),(1530,'1','294','1',1,'Sale Id shift 259',0.00,0.00,0.00,3359.02,0.00,'2023-02-17 08:18:40','',''),(1531,'1','294','1',1,'Sale Id shift 259',0.00,0.00,0.00,3121.12,0.00,'2023-02-17 08:18:40','',''),(1532,'1','294',NULL,2,'Sale Id shift 259',2607872.00,0.00,0.00,0.00,0.00,'2023-02-17 08:18:40','',''),(1533,'1','294',NULL,1,'Sale Id shift 259',3387140.00,0.00,0.00,0.00,0.00,'2023-02-17 08:18:40','',''),(1534,'1','294','2',1,'Sale Id shift 260',0.00,0.00,0.00,3897.05,0.00,'2023-02-18 14:35:15','',''),(1535,'1','294','2',1,'Sale Id shift 260',0.00,0.00,0.00,3665.50,0.00,'2023-02-18 14:35:15','',''),(1536,'1','294','2',1,'Sale Id shift 260',0.00,0.00,0.00,5659.81,0.00,'2023-02-18 14:35:15','',''),(1537,'1','294','2',1,'Sale Id shift 260',0.00,0.00,0.00,2516.99,0.00,'2023-02-18 14:35:15','',''),(1538,'1','294','2',1,'Sale Id shift 260',0.00,0.00,0.00,0.58,0.00,'2023-02-18 14:35:15','',''),(1539,'1','294',NULL,1,'Sale Id shift 260',3147986.00,0.00,0.00,0.00,0.00,'2023-02-18 14:35:15','',''),(1540,'1','294','2',1,'Sale Id shift 261',0.00,0.00,0.00,2812.07,0.00,'2023-02-18 21:41:10','',''),(1541,'1','294','2',1,'Sale Id shift 261',0.00,0.00,0.00,2060.45,0.00,'2023-02-18 21:41:10','',''),(1542,'1','294','2',1,'Sale Id shift 261',0.00,0.00,0.00,3078.30,0.00,'2023-02-18 21:41:10','',''),(1543,'1','294','2',1,'Sale Id shift 261',0.00,0.00,0.00,3010.88,0.00,'2023-02-18 21:41:10','',''),(1544,'1','294',NULL,1,'Sale Id shift 261',2192340.00,0.00,0.00,0.00,0.00,'2023-02-18 21:41:10','',''),(1545,'1','294',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,10000000.00,50000.00,0.00,0.00,'2023-02-18 21:41:50','',''),(1546,'1','294',NULL,1,'Reception corrector for bridging 50',0.00,0.00,0.00,28000.00,0.00,'2023-02-19 18:31:36','',''),(1547,'1','294','2',1,'Received from bridging 50',0.00,0.00,28000.00,0.00,0.00,'2023-02-19 18:31:36','',''),(1548,'1','294',NULL,1,'Reception corrector for bridging 49',0.00,0.00,0.00,22000.00,0.00,'2023-02-19 18:31:36','',''),(1549,'1','294','1',1,'Received from bridging 49',0.00,0.00,22000.00,0.00,0.00,'2023-02-19 18:31:36','',''),(1550,'1','294','2',1,'Sale Id shift 262',0.00,0.00,0.00,3448.42,0.00,'2023-02-19 21:27:26','',''),(1551,'1','294','2',1,'Sale Id shift 262',0.00,0.00,0.00,4068.99,0.00,'2023-02-19 21:27:26','',''),(1552,'1','294','2',1,'Sale Id shift 262',0.00,0.00,0.00,4112.56,0.00,'2023-02-19 21:27:26','',''),(1553,'1','294','2',1,'Sale Id shift 262',0.00,0.00,0.00,4252.68,0.00,'2023-02-19 21:27:26','',''),(1554,'1','294',NULL,1,'Sale Id shift 262',3176530.00,0.00,0.00,0.00,0.00,'2023-02-19 21:27:26','',''),(1555,'1','294',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,16000000.00,20000.00,0.00,0.00,'2023-02-21 06:48:32','',''),(1556,'1','294',NULL,2,'Reception corrector for bridging 51',0.00,0.00,0.00,20000.00,0.00,'2023-02-21 10:36:55','',''),(1557,'1','294','3',2,'Received from bridging 51',0.00,0.00,20000.00,0.00,0.00,'2023-02-21 10:36:55','',''),(1558,'1','294','1',1,'Sale Id shift 263',0.00,0.00,0.00,1113.80,0.00,'2023-02-21 15:36:04','',''),(1559,'1','294','2',1,'Sale Id shift 263',0.00,0.00,0.00,2819.53,0.00,'2023-02-21 15:36:04','',''),(1560,'1','294','2',1,'Sale Id shift 263',0.00,0.00,0.00,3225.05,0.00,'2023-02-21 15:36:04','',''),(1561,'1','294','2',1,'Sale Id shift 263',0.00,0.00,0.00,2590.22,0.00,'2023-02-21 15:36:04','',''),(1562,'1','294','2',1,'Sale Id shift 263',0.00,0.00,0.00,3535.57,0.00,'2023-02-21 15:36:04','',''),(1563,'1','294','3',2,'Sale Id shift 263',0.00,0.00,0.00,699.17,0.00,'2023-02-21 15:36:04','',''),(1564,'1','294','3',2,'Sale Id shift 263',0.00,0.00,0.00,2430.91,0.00,'2023-02-21 15:36:04','',''),(1565,'1','294','1',1,'Sale Id shift 263',0.00,0.00,0.00,983.23,0.00,'2023-02-21 15:36:04','',''),(1566,'1','294','1',1,'Sale Id shift 263',0.00,0.00,0.00,1871.33,0.00,'2023-02-21 15:36:04','',''),(1567,'1','294',NULL,2,'Sale Id shift 263',2504064.00,0.00,0.00,0.00,0.00,'2023-02-21 15:36:04','',''),(1568,'1','294',NULL,1,'Sale Id shift 263',3227746.00,0.00,0.00,0.00,0.00,'2023-02-21 15:36:04','',''),(1569,'1','294','1',1,'Sale Id shift 264',0.00,0.00,0.00,4535.38,0.00,'2023-02-22 12:25:35','',''),(1570,'1','294','3',2,'Sale Id shift 264',0.00,0.00,0.00,837.67,0.00,'2023-02-22 12:25:35','',''),(1571,'1','294','3',2,'Sale Id shift 264',0.00,0.00,0.00,3011.23,0.00,'2023-02-22 12:25:35','',''),(1572,'1','294','1',1,'Sale Id shift 264',0.00,0.00,0.00,3046.56,0.00,'2023-02-22 12:25:35','',''),(1573,'1','294','1',1,'Sale Id shift 264',0.00,0.00,0.00,4511.41,0.00,'2023-02-22 12:25:35','',''),(1574,'1','294','1',1,'Sale Id shift 264',0.00,0.00,0.00,2620.30,0.00,'2023-02-22 12:25:35','',''),(1575,'1','294','1',1,'Sale Id shift 264',0.00,0.00,0.00,3459.46,0.00,'2023-02-22 12:25:35','',''),(1576,'1','294',NULL,2,'Sale Id shift 264',3079120.00,0.00,0.00,0.00,0.00,'2023-02-22 12:25:35','',''),(1577,'1','294',NULL,1,'Sale Id shift 264',3634622.00,0.00,0.00,0.00,0.00,'2023-02-22 12:25:35','',''),(1578,'1','294',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,12000000.00,60000.00,0.00,0.00,'2023-02-23 12:34:46','',''),(1579,'1','294',NULL,1,'Reception corrector for bridging 53',0.00,0.00,0.00,30000.00,0.00,'2023-02-23 13:32:39','',''),(1580,'1','294','2',1,'Received from bridging 53',0.00,0.00,30000.00,0.00,0.00,'2023-02-23 13:32:39','',''),(1581,'1','294',NULL,1,'Reception corrector for bridging 52',0.00,0.00,0.00,30000.00,0.00,'2023-02-23 13:32:39','',''),(1582,'1','294','1',1,'Received from bridging 52',0.00,0.00,30000.00,0.00,0.00,'2023-02-23 13:32:39','',''),(1583,'1','294','2',1,'Sale Id shift 265',0.00,0.00,0.00,4303.58,0.00,'2023-02-23 16:10:56','',''),(1584,'1','294','2',1,'Sale Id shift 265',0.00,0.00,0.00,5516.83,0.00,'2023-02-23 16:10:56','',''),(1585,'1','294','2',1,'Sale Id shift 265',0.00,0.00,0.00,4218.59,0.00,'2023-02-23 16:10:56','',''),(1586,'1','294','2',1,'Sale Id shift 265',0.00,0.00,0.00,3493.76,0.00,'2023-02-23 16:10:56','',''),(1587,'1','294','2',1,'Sale Id shift 265',0.00,0.00,0.00,6311.50,0.00,'2023-02-23 16:10:56','',''),(1588,'1','294','3',2,'Sale Id shift 265',0.00,0.00,0.00,1204.52,0.00,'2023-02-23 16:10:56','',''),(1589,'1','294','3',2,'Sale Id shift 265',0.00,0.00,0.00,1515.72,0.00,'2023-02-23 16:10:56','',''),(1590,'1','294','3',2,'Sale Id shift 265',0.00,0.00,0.00,25.00,0.00,'2023-02-23 16:10:56','',''),(1591,'1','294',NULL,2,'Sale Id shift 265',2196192.00,0.00,0.00,0.00,0.00,'2023-02-23 16:10:56','',''),(1592,'1','294',NULL,1,'Sale Id shift 265',4768852.00,0.00,0.00,0.00,0.00,'2023-02-23 16:10:56','',''),(1593,'1','294','2',1,'Sale Id shift 266',0.00,0.00,0.00,1965.62,0.00,'2023-02-24 15:28:14','',''),(1594,'1','294','2',1,'Sale Id shift 266',0.00,0.00,0.00,1810.90,0.00,'2023-02-24 15:28:14','',''),(1595,'1','294','2',1,'Sale Id shift 266',0.00,0.00,0.00,1509.03,0.00,'2023-02-24 15:28:14','',''),(1596,'1','294','2',1,'Sale Id shift 266',0.00,0.00,0.00,992.78,0.00,'2023-02-24 15:28:14','',''),(1597,'1','294','2',1,'Sale Id shift 266',0.00,0.00,0.00,2158.78,0.00,'2023-02-24 15:28:14','',''),(1598,'1','294','3',2,'Sale Id shift 266',0.00,0.00,0.00,2330.16,0.00,'2023-02-24 15:28:14','',''),(1599,'1','294',NULL,2,'Sale Id shift 266',1864128.00,0.00,0.00,0.00,0.00,'2023-02-24 15:28:14','',''),(1600,'1','294',NULL,1,'Sale Id shift 266',1687422.00,0.00,0.00,0.00,0.00,'2023-02-24 15:28:14','',''),(1601,'1','294','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,90.61,0.00,'2023-02-25 19:49:40','',''),(1602,'1','294','2',0,'Inventory adjustment from tank dipping to 9500',0.00,0.00,9500.00,0.00,0.00,'2023-02-25 19:49:40','',''),(1603,'1','294','2',1,'Sale Id shift 267',0.00,0.00,0.00,1389.70,0.00,'2023-02-25 20:39:50','',''),(1604,'1','294','2',1,'Sale Id shift 267',0.00,0.00,0.00,7863.37,0.00,'2023-02-25 20:39:50','',''),(1605,'1','294','3',2,'Sale Id shift 267',0.00,0.00,0.00,3603.70,0.00,'2023-02-25 20:39:50','',''),(1606,'1','294','3',2,'Sale Id shift 267',0.00,0.00,0.00,400.00,0.00,'2023-02-25 20:39:50','',''),(1607,'1','294','1',1,'Sale Id shift 267',0.00,0.00,0.00,56.46,0.00,'2023-02-25 20:39:50','',''),(1608,'1','294',NULL,2,'Sale Id shift 267',3202960.00,0.00,0.00,0.00,0.00,'2023-02-25 20:39:50','',''),(1609,'1','294',NULL,1,'Sale Id shift 267',1861906.00,0.00,0.00,0.00,0.00,'2023-02-25 20:39:50','',''),(1610,'1','294',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3400000.00,17000.00,0.00,0.00,'2023-02-26 08:29:26','',''),(1611,'1','294',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,10000000.00,50000.00,0.00,0.00,'2023-02-26 08:29:35','',''),(1612,'1','294',NULL,1,'Reception corrector for bridging 54',0.00,0.00,0.00,17000.00,0.00,'2023-02-26 09:07:31','',''),(1613,'1','294','2',1,'Received from bridging 54',0.00,0.00,17000.00,0.00,0.00,'2023-02-26 09:07:31','',''),(1614,'1','294',NULL,1,'Reception corrector for bridging 55',0.00,0.00,0.00,16000.00,0.00,'2023-02-26 09:08:07','',''),(1615,'1','294','1',1,'Received from bridging 55',0.00,0.00,16000.00,0.00,0.00,'2023-02-26 09:08:07','',''),(1616,'1','294','1',1,'Sale Id shift 268',0.00,0.00,0.00,1552.44,0.00,'2023-02-26 10:53:18','',''),(1617,'1','294','1',1,'Sale Id shift 268',0.00,0.00,0.00,1105.56,0.00,'2023-02-26 10:53:18','',''),(1618,'1','294','3',2,'Sale Id shift 268',0.00,0.00,0.00,1473.00,0.00,'2023-02-26 10:53:18','',''),(1619,'1','294',NULL,2,'Sale Id shift 268',1178400.00,0.00,0.00,0.00,0.00,'2023-02-26 10:53:18','',''),(1620,'1','294',NULL,1,'Sale Id shift 268',531600.00,0.00,0.00,0.00,0.00,'2023-02-26 10:53:18','',''),(1621,'1','294','1',1,'Sale Id shift 269',0.00,0.00,0.00,2557.56,0.00,'2023-02-27 15:50:50','',''),(1622,'1','294','3',2,'Sale Id shift 269',0.00,0.00,0.00,697.63,0.00,'2023-02-27 15:50:50','',''),(1623,'1','294','1',1,'Sale Id shift 269',0.00,0.00,0.00,2565.94,0.00,'2023-02-27 15:50:50','',''),(1624,'1','294','1',1,'Sale Id shift 269',0.00,0.00,0.00,1832.78,0.00,'2023-02-27 15:50:50','',''),(1625,'1','294','1',1,'Sale Id shift 269',0.00,0.00,0.00,2662.30,0.00,'2023-02-27 15:50:50','',''),(1626,'1','294',NULL,2,'Sale Id shift 269',558104.00,0.00,0.00,0.00,0.00,'2023-02-27 15:50:50','',''),(1627,'1','294',NULL,1,'Sale Id shift 269',1923716.00,0.00,0.00,0.00,0.00,'2023-02-27 15:50:50','',''),(1628,'1','294','1',1,'Sale Id shift 270',0.00,0.00,0.00,1190.37,0.00,'2023-02-27 20:08:51','',''),(1629,'1','294','2',1,'Sale Id shift 270',0.00,0.00,0.00,2890.23,0.00,'2023-02-27 20:08:51','',''),(1630,'1','294','2',1,'Sale Id shift 270',0.00,0.00,0.00,2955.64,0.00,'2023-02-27 20:08:51','',''),(1631,'1','294','2',1,'Sale Id shift 270',0.00,0.00,0.00,1856.21,0.00,'2023-02-27 20:08:51','',''),(1632,'1','294','3',2,'Sale Id shift 270',0.00,0.00,0.00,60.00,0.00,'2023-02-27 20:08:51','',''),(1633,'1','294','3',2,'Sale Id shift 270',0.00,0.00,0.00,320.19,0.00,'2023-02-27 20:08:51','',''),(1634,'1','294','1',1,'Sale Id shift 270',0.00,0.00,0.00,1342.34,0.00,'2023-02-27 20:08:51','',''),(1635,'1','294','1',1,'Sale Id shift 270',0.00,0.00,0.00,820.92,0.00,'2023-02-27 20:08:51','',''),(1636,'1','294','1',1,'Sale Id shift 270',0.00,0.00,0.00,609.59,0.00,'2023-02-27 20:08:51','',''),(1637,'1','294',NULL,2,'Sale Id shift 270',304152.00,0.00,0.00,0.00,0.00,'2023-02-27 20:08:51','',''),(1638,'1','294',NULL,1,'Sale Id shift 270',2333060.00,0.00,0.00,0.00,0.00,'2023-02-27 20:08:51','',''),(1639,'1','294','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,9544.85,0.00,'2023-02-28 09:00:26','',''),(1640,'1','294','2',0,'Inventory adjustment from tank dipping to 10200',0.00,0.00,10200.00,0.00,0.00,'2023-02-28 09:00:26','',''),(1641,'1','294','2',1,'Sale Id shift 271',0.00,0.00,0.00,2319.19,0.00,'2023-02-28 14:12:43','',''),(1642,'1','294','2',1,'Sale Id shift 271',0.00,0.00,0.00,2981.81,0.00,'2023-02-28 14:12:43','',''),(1643,'1','294','2',1,'Sale Id shift 271',0.00,0.00,0.00,1669.97,0.00,'2023-02-28 14:12:43','',''),(1644,'1','294','2',1,'Sale Id shift 271',0.00,0.00,0.00,3113.59,0.00,'2023-02-28 14:12:43','',''),(1645,'1','294','3',2,'Sale Id shift 271',0.00,0.00,0.00,100.01,0.00,'2023-02-28 14:12:43','',''),(1646,'1','294','3',2,'Sale Id shift 271',0.00,0.00,0.00,57.50,0.00,'2023-02-28 14:12:43','',''),(1647,'1','294',NULL,2,'Sale Id shift 271',126008.00,0.00,0.00,0.00,0.00,'2023-02-28 14:12:43','',''),(1648,'1','294',NULL,1,'Sale Id shift 271',2016912.00,0.00,0.00,0.00,0.00,'2023-02-28 14:12:43','',''),(1649,'1','294','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,115.44,0.00,'2023-02-28 15:50:31','',''),(1650,'1','294','2',0,'Inventory adjustment from tank dipping to 14200',0.00,0.00,14200.00,0.00,0.00,'2023-02-28 15:50:31','',''),(1651,'1','294','2',1,'Sale Id shift 272',0.00,0.00,0.00,1763.21,0.00,'2023-02-28 17:08:27','',''),(1652,'1','294','2',1,'Sale Id shift 272',0.00,0.00,0.00,3437.50,0.00,'2023-02-28 17:08:27','',''),(1653,'1','294','2',1,'Sale Id shift 272',0.00,0.00,0.00,1907.25,0.00,'2023-02-28 17:08:27','',''),(1654,'1','294','2',1,'Sale Id shift 272',0.00,0.00,0.00,3096.10,0.00,'2023-02-28 17:08:27','',''),(1655,'1','294','2',1,'Sale Id shift 272',0.00,0.00,0.00,3869.79,0.00,'2023-02-28 17:08:27','',''),(1656,'1','294','3',2,'Sale Id shift 272',0.00,0.00,0.00,875.36,0.00,'2023-02-28 17:08:27','',''),(1657,'1','294','3',2,'Sale Id shift 272',0.00,0.00,0.00,100.00,0.00,'2023-02-28 17:08:27','',''),(1658,'1','294',NULL,2,'Sale Id shift 272',780288.00,0.00,0.00,0.00,0.00,'2023-02-28 17:08:27','',''),(1659,'1','294',NULL,1,'Sale Id shift 272',2814770.00,0.00,0.00,0.00,0.00,'2023-02-28 17:08:27','',''),(1660,'1','294','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,126.15,0.00,'2023-02-28 21:11:24','',''),(1661,'1','294','2',0,'Inventory adjustment from tank dipping to 3800',0.00,0.00,3800.00,0.00,0.00,'2023-02-28 21:11:24','',''),(1662,'1','294','2',1,'Sale Id shift 273',0.00,0.00,0.00,572.82,0.00,'2023-02-28 22:33:18','',''),(1663,'1','294','2',1,'Sale Id shift 273',0.00,0.00,0.00,1131.46,0.00,'2023-02-28 22:33:18','',''),(1664,'1','294','2',1,'Sale Id shift 273',0.00,0.00,0.00,1025.95,0.00,'2023-02-28 22:33:18','',''),(1665,'1','294','2',1,'Sale Id shift 273',0.00,0.00,0.00,933.04,0.00,'2023-02-28 22:33:18','',''),(1666,'1','294','3',2,'Sale Id shift 273',0.00,0.00,0.00,488.48,0.00,'2023-02-28 22:33:18','',''),(1667,'1','294',NULL,2,'Sale Id shift 273',390784.00,0.00,0.00,0.00,0.00,'2023-02-28 22:33:18','',''),(1668,'1','294',NULL,1,'Sale Id shift 273',732654.00,0.00,0.00,0.00,0.00,'2023-02-28 22:33:18','',''),(1669,'1','294',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,5900000.00,29500.00,0.00,0.00,'2023-03-03 19:38:38','',''),(1670,'1','294',NULL,1,'Reception corrector for bridging 56',0.00,0.00,0.00,29500.00,0.00,'2023-03-03 20:48:00','',''),(1671,'1','294','2',1,'Received from bridging 56',0.00,0.00,29500.00,0.00,0.00,'2023-03-03 20:48:00','',''),(1672,'1','294','2',1,'Sale Id shift 274',0.00,0.00,0.00,3695.10,0.00,'2023-03-03 20:54:45','',''),(1673,'1','294','2',1,'Sale Id shift 274',0.00,0.00,0.00,3117.05,0.00,'2023-03-03 20:54:45','',''),(1674,'1','294','2',1,'Sale Id shift 274',0.00,0.00,0.00,2199.90,0.00,'2023-03-03 20:54:45','',''),(1675,'1','294','2',1,'Sale Id shift 274',0.00,0.00,0.00,1809.58,0.00,'2023-03-03 20:54:45','',''),(1676,'1','294','2',1,'Sale Id shift 274',0.00,0.00,0.00,3621.63,0.00,'2023-03-03 20:54:45','',''),(1677,'1','294',NULL,1,'Sale Id shift 274',2888652.00,0.00,0.00,0.00,0.00,'2023-03-03 20:54:45','',''),(1678,'1','294','2',1,'Sale Id shift 275',0.00,0.00,0.00,1091.87,0.00,'2023-03-04 10:07:19','',''),(1679,'1','294','2',1,'Sale Id shift 275',0.00,0.00,0.00,2273.50,0.00,'2023-03-04 10:07:19','',''),(1680,'1','294','2',1,'Sale Id shift 275',0.00,0.00,0.00,2028.11,0.00,'2023-03-04 10:07:19','',''),(1681,'1','294',NULL,1,'Sale Id shift 275',1078696.00,0.00,0.00,0.00,0.00,'2023-03-04 10:07:19','',''),(1682,'1','294',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,26400000.00,33000.00,0.00,0.00,'2023-03-04 10:07:42','',''),(1683,'1','294',NULL,2,'Reception corrector for bridging 57',0.00,0.00,0.00,33000.00,0.00,'2023-03-04 16:36:15','',''),(1684,'1','294','3',2,'Received from bridging 57',0.00,0.00,33000.00,0.00,0.00,'2023-03-04 16:36:15','',''),(1685,'1','294','2',1,'Sale Id shift 276',0.00,0.00,0.00,1729.60,0.00,'2023-03-04 17:55:12','',''),(1686,'1','294','2',1,'Sale Id shift 276',0.00,0.00,0.00,2499.43,0.00,'2023-03-04 17:55:12','',''),(1687,'1','294','2',1,'Sale Id shift 276',0.00,0.00,0.00,1900.75,0.00,'2023-03-04 17:55:12','',''),(1688,'1','294','2',1,'Sale Id shift 276',0.00,0.00,0.00,1492.92,0.00,'2023-03-04 17:55:12','',''),(1689,'1','294','2',1,'Sale Id shift 276',0.00,0.00,0.00,1985.16,0.00,'2023-03-04 17:55:12','',''),(1690,'1','294','3',2,'Sale Id shift 276',0.00,0.00,0.00,962.03,0.00,'2023-03-04 17:55:12','',''),(1691,'1','294',NULL,2,'Sale Id shift 276',769624.00,0.00,0.00,0.00,0.00,'2023-03-04 17:55:12','',''),(1692,'1','294',NULL,1,'Sale Id shift 276',1921572.00,0.00,0.00,0.00,0.00,'2023-03-04 17:55:12','',''),(1693,'1','294','3',2,'Sale Id shift 277',0.00,0.00,0.00,2740.26,0.00,'2023-03-05 14:27:00','',''),(1694,'1','294',NULL,2,'Sale Id shift 277',2192208.00,0.00,0.00,0.00,0.00,'2023-03-05 14:27:00','',''),(1695,'1','294','3',2,'Sale Id shift 278',0.00,0.00,0.00,1771.00,0.00,'2023-03-05 16:09:26','',''),(1696,'1','294',NULL,2,'Sale Id shift 278',1416800.00,0.00,0.00,0.00,0.00,'2023-03-05 16:09:26','',''),(1697,'1','294','3',2,'Sale Id shift 279',0.00,0.00,0.00,1482.76,0.00,'2023-03-06 11:44:30','',''),(1698,'1','294','3',2,'Sale Id shift 279',0.00,0.00,0.00,1332.54,0.00,'2023-03-06 11:44:30','',''),(1699,'1','294',NULL,2,'Sale Id shift 279',2252240.00,0.00,0.00,0.00,0.00,'2023-03-06 11:44:30','',''),(1700,'1','294','3',2,'Sale Id shift 280',0.00,0.00,0.00,1658.51,0.00,'2023-03-06 21:05:34','',''),(1701,'1','294',NULL,2,'Sale Id shift 280',1326808.00,0.00,0.00,0.00,0.00,'2023-03-06 21:05:34','',''),(1702,'1','294','3',2,'Sale Id shift 281',0.00,0.00,0.00,301.02,0.00,'2023-03-06 22:22:48','',''),(1703,'1','294','3',2,'Sale Id shift 281',0.00,0.00,0.00,1090.01,0.00,'2023-03-06 22:22:48','',''),(1704,'1','294','3',2,'Sale Id shift 281',0.00,0.00,0.00,1872.26,0.00,'2023-03-06 22:22:48','',''),(1705,'1','294',NULL,2,'Sale Id shift 281',2610632.00,0.00,0.00,0.00,0.00,'2023-03-06 22:22:48','',''),(1706,'1','294','3',2,'Sale Id shift 282',0.00,0.00,0.00,1200.64,0.00,'2023-03-07 18:18:17','',''),(1707,'1','294','3',2,'Sale Id shift 282',0.00,0.00,0.00,480.50,0.00,'2023-03-07 18:18:17','',''),(1708,'1','294',NULL,2,'Sale Id shift 282',1344912.00,0.00,0.00,0.00,0.00,'2023-03-07 18:18:17','',''),(1709,'1','294','3',2,'Sale Id shift 283',0.00,0.00,0.00,803.74,0.00,'2023-03-08 17:49:28','',''),(1710,'1','294','3',2,'Sale Id shift 283',0.00,0.00,0.00,600.00,0.00,'2023-03-08 17:49:28','',''),(1711,'1','294','3',2,'Sale Id shift 283',0.00,0.00,0.00,1053.63,0.00,'2023-03-08 17:49:28','',''),(1712,'1','294',NULL,2,'Sale Id shift 283',1965896.00,0.00,0.00,0.00,0.00,'2023-03-08 17:49:28','',''),(1713,'1','294','3',2,'Sale Id shift 284',0.00,0.00,0.00,1396.15,0.00,'2023-03-09 02:10:56','',''),(1714,'1','294',NULL,2,'Sale Id shift 284',1116920.00,0.00,0.00,0.00,0.00,'2023-03-09 02:10:56','',''),(1715,'1','294','3',2,'Sale Id shift 285',0.00,0.00,0.00,715.00,0.00,'2023-03-09 07:59:39','',''),(1716,'1','294','3',2,'Sale Id shift 285',0.00,0.00,0.00,1418.27,0.00,'2023-03-09 07:59:39','',''),(1717,'1','294','3',2,'Sale Id shift 285',0.00,0.00,0.00,2574.53,0.00,'2023-03-09 07:59:39','',''),(1718,'1','294',NULL,2,'Sale Id shift 285',3766240.00,0.00,0.00,0.00,0.00,'2023-03-09 07:59:39','',''),(1719,'1','294',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,10000000.00,50000.00,0.00,0.00,'2023-03-09 15:51:44','',''),(1720,'1','294',NULL,1,'Reception corrector for bridging 59',0.00,0.00,0.00,33000.00,0.00,'2023-03-09 17:00:47','',''),(1721,'1','294','2',1,'Received from bridging 59',0.00,0.00,33000.00,0.00,0.00,'2023-03-09 17:00:47','',''),(1722,'1','294',NULL,1,'Reception corrector for bridging 58',0.00,0.00,0.00,17000.00,0.00,'2023-03-09 17:00:47','',''),(1723,'1','294','1',1,'Received from bridging 58',0.00,0.00,17000.00,0.00,0.00,'2023-03-09 17:00:47','',''),(1724,'1','294','2',1,'Sale Id shift 286',0.00,0.00,0.00,3116.65,0.00,'2023-03-09 19:05:20','',''),(1725,'1','294','2',1,'Sale Id shift 286',0.00,0.00,0.00,2733.09,0.00,'2023-03-09 19:05:20','',''),(1726,'1','294','2',1,'Sale Id shift 286',0.00,0.00,0.00,2532.84,0.00,'2023-03-09 19:05:20','',''),(1727,'1','294','3',2,'Sale Id shift 286',0.00,0.00,0.00,2448.38,0.00,'2023-03-09 19:05:20','',''),(1728,'1','294',NULL,2,'Sale Id shift 286',1958704.00,0.00,0.00,0.00,0.00,'2023-03-09 19:05:20','',''),(1729,'1','294',NULL,1,'Sale Id shift 286',1676516.00,0.00,0.00,0.00,0.00,'2023-03-09 19:05:20','',''),(1730,'1','294','2',1,'Sale Id shift 287',0.00,0.00,0.00,4879.66,0.00,'2023-03-10 10:44:23','',''),(1731,'1','294','2',1,'Sale Id shift 287',0.00,0.00,0.00,1722.35,0.00,'2023-03-10 10:44:23','',''),(1732,'1','294','2',1,'Sale Id shift 287',0.00,0.00,0.00,2324.98,0.00,'2023-03-10 10:44:23','',''),(1733,'1','294','2',1,'Sale Id shift 287',0.00,0.00,0.00,6019.56,0.00,'2023-03-10 10:44:23','',''),(1734,'1','294','3',2,'Sale Id shift 287',0.00,0.00,0.00,345.67,0.00,'2023-03-10 10:44:23','',''),(1735,'1','294','3',2,'Sale Id shift 287',0.00,0.00,0.00,1727.56,0.00,'2023-03-10 10:44:23','',''),(1736,'1','294','3',2,'Sale Id shift 287',0.00,0.00,0.00,2637.58,0.00,'2023-03-10 10:44:23','',''),(1737,'1','294',NULL,2,'Sale Id shift 287',3768648.00,0.00,0.00,0.00,0.00,'2023-03-10 10:44:23','',''),(1738,'1','294',NULL,1,'Sale Id shift 287',2989310.00,0.00,0.00,0.00,0.00,'2023-03-10 10:44:23','',''),(1739,'1','294','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,9863.00,0.00,'2023-03-10 19:51:07','',''),(1740,'1','294','2',0,'Inventory adjustment from tank dipping to 10000',0.00,0.00,10000.00,0.00,0.00,'2023-03-10 19:51:07','',''),(1741,'1','294','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,2397.87,0.00,'2023-03-10 20:38:12','',''),(1742,'1','294','3',0,'Inventory adjustment from tank dipping to 3000',0.00,0.00,3000.00,0.00,0.00,'2023-03-10 20:38:12','',''),(1743,'1','294','2',1,'Sale Id shift 288',0.00,0.00,0.00,1692.53,0.00,'2023-03-10 21:50:01','',''),(1744,'1','294','2',1,'Sale Id shift 288',0.00,0.00,0.00,2190.81,0.00,'2023-03-10 21:50:01','',''),(1745,'1','294','2',1,'Sale Id shift 288',0.00,0.00,0.00,2469.91,0.00,'2023-03-10 21:50:01','',''),(1746,'1','294','2',1,'Sale Id shift 288',0.00,0.00,0.00,1137.01,0.00,'2023-03-10 21:50:01','',''),(1747,'1','294','2',1,'Sale Id shift 288',0.00,0.00,0.00,2090.45,0.00,'2023-03-10 21:50:01','',''),(1748,'1','294','3',2,'Sale Id shift 288',0.00,0.00,0.00,1530.28,0.00,'2023-03-10 21:50:01','',''),(1749,'1','294','3',2,'Sale Id shift 288',0.00,0.00,0.00,1305.02,0.00,'2023-03-10 21:50:01','',''),(1750,'1','294','1',1,'Sale Id shift 288',0.00,0.00,0.00,322.45,0.00,'2023-03-10 21:50:01','',''),(1751,'1','294',NULL,2,'Sale Id shift 288',2268240.00,0.00,0.00,0.00,0.00,'2023-03-10 21:50:01','',''),(1752,'1','294',NULL,1,'Sale Id shift 288',1980632.00,0.00,0.00,0.00,0.00,'2023-03-10 21:50:01','',''),(1753,'1','294','1',1,'Sale Id shift 289',0.00,0.00,0.00,740.65,0.00,'2023-03-11 15:37:10','',''),(1754,'1','294','1',1,'Sale Id shift 289',0.00,0.00,0.00,147.70,0.00,'2023-03-11 15:37:10','',''),(1755,'1','294','1',1,'Sale Id shift 289',0.00,0.00,0.00,544.32,0.00,'2023-03-11 15:37:10','',''),(1756,'1','294','1',1,'Sale Id shift 289',0.00,0.00,0.00,621.83,0.00,'2023-03-11 15:37:10','',''),(1757,'1','294','1',1,'Sale Id shift 289',0.00,0.00,0.00,1084.72,0.00,'2023-03-11 15:37:10','',''),(1758,'1','294','1',1,'Sale Id shift 289',0.00,0.00,0.00,1419.89,0.00,'2023-03-11 15:37:10','',''),(1759,'1','294',NULL,1,'Sale Id shift 289',911822.00,0.00,0.00,0.00,0.00,'2023-03-11 15:37:10','',''),(1760,'1','294','1',1,'Sale Id shift 290',0.00,0.00,0.00,1723.78,0.00,'2023-03-11 22:18:21','',''),(1761,'1','294','1',1,'Sale Id shift 290',0.00,0.00,0.00,1438.17,0.00,'2023-03-11 22:18:21','',''),(1762,'1','294','1',1,'Sale Id shift 290',0.00,0.00,0.00,2448.33,0.00,'2023-03-11 22:18:21','',''),(1763,'1','294','1',1,'Sale Id shift 290',0.00,0.00,0.00,1939.63,0.00,'2023-03-11 22:18:21','',''),(1764,'1','294','1',1,'Sale Id shift 290',0.00,0.00,0.00,1836.86,0.00,'2023-03-11 22:18:21','',''),(1765,'1','294','1',1,'Sale Id shift 290',0.00,0.00,0.00,2550.45,0.00,'2023-03-11 22:18:21','',''),(1766,'1','294',NULL,1,'Sale Id shift 290',2387444.00,0.00,0.00,0.00,0.00,'2023-03-11 22:18:21','',''),(1767,'1','294',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,10000000.00,50000.00,0.00,0.00,'2023-03-12 12:09:06','',''),(1768,'1','294',NULL,1,'Reception corrector for bridging 61',0.00,0.00,0.00,31650.00,0.00,'2023-03-12 15:42:44','',''),(1769,'1','294','2',1,'Received from bridging 61',0.00,0.00,31650.00,0.00,0.00,'2023-03-12 15:42:44','',''),(1770,'1','294',NULL,1,'Reception corrector for bridging 60',0.00,0.00,0.00,18200.00,0.00,'2023-03-12 15:42:44','',''),(1771,'1','294','1',1,'Received from bridging 60',0.00,0.00,18200.00,0.00,0.00,'2023-03-12 15:42:44','',''),(1772,'1','294','2',1,'Sale Id shift 291',0.00,0.00,0.00,2764.32,0.00,'2023-03-12 18:34:20','',''),(1773,'1','294','2',1,'Sale Id shift 291',0.00,0.00,0.00,2661.00,0.00,'2023-03-12 18:34:20','',''),(1774,'1','294','2',1,'Sale Id shift 291',0.00,0.00,0.00,3017.47,0.00,'2023-03-12 18:34:20','',''),(1775,'1','294','2',1,'Sale Id shift 291',0.00,0.00,0.00,1316.11,0.00,'2023-03-12 18:34:20','',''),(1776,'1','294','2',1,'Sale Id shift 291',0.00,0.00,0.00,2148.65,0.00,'2023-03-12 18:34:20','',''),(1777,'1','294',NULL,1,'Sale Id shift 291',2381510.00,0.00,0.00,0.00,0.00,'2023-03-12 18:34:20','',''),(1778,'1','294','2',1,'Sale Id shift 292',0.00,0.00,0.00,1042.12,0.00,'2023-03-13 15:20:08','',''),(1779,'1','294','2',1,'Sale Id shift 292',0.00,0.00,0.00,3435.62,0.00,'2023-03-13 15:20:08','',''),(1780,'1','294','2',1,'Sale Id shift 292',0.00,0.00,0.00,1522.05,0.00,'2023-03-13 15:20:08','',''),(1781,'1','294','2',1,'Sale Id shift 292',0.00,0.00,0.00,1728.47,0.00,'2023-03-13 15:20:08','',''),(1782,'1','294','2',1,'Sale Id shift 292',0.00,0.00,0.00,1894.22,0.00,'2023-03-13 15:20:08','',''),(1783,'1','294',NULL,1,'Sale Id shift 292',1924496.00,0.00,0.00,0.00,0.00,'2023-03-13 15:20:08','',''),(1784,'1','294','2',1,'Sale Id shift 293',0.00,0.00,0.00,2725.47,0.00,'2023-03-13 17:22:58','',''),(1785,'1','294','2',1,'Sale Id shift 293',0.00,0.00,0.00,1530.05,0.00,'2023-03-13 17:22:58','',''),(1786,'1','294','2',1,'Sale Id shift 293',0.00,0.00,0.00,1876.02,0.00,'2023-03-13 17:22:58','',''),(1787,'1','294','2',1,'Sale Id shift 293',0.00,0.00,0.00,1177.43,0.00,'2023-03-13 17:22:58','',''),(1788,'1','294','2',1,'Sale Id shift 293',0.00,0.00,0.00,2957.59,0.00,'2023-03-13 17:22:58','',''),(1789,'1','294',NULL,1,'Sale Id shift 293',2053312.00,0.00,0.00,0.00,0.00,'2023-03-13 17:22:58','',''),(1790,'1','294','1',1,'Sale Id shift 294',0.00,0.00,0.00,1541.70,0.00,'2023-03-13 22:55:42','',''),(1791,'1','294','1',1,'Sale Id shift 294',0.00,0.00,0.00,51.18,0.00,'2023-03-13 22:55:42','',''),(1792,'1','294','1',1,'Sale Id shift 294',0.00,0.00,0.00,2006.33,0.00,'2023-03-13 22:55:42','',''),(1793,'1','294','1',1,'Sale Id shift 294',0.00,0.00,0.00,1535.80,0.00,'2023-03-13 22:55:42','',''),(1794,'1','294','1',1,'Sale Id shift 294',0.00,0.00,0.00,1481.29,0.00,'2023-03-13 22:55:42','',''),(1795,'1','294',NULL,1,'Sale Id shift 294',1323260.00,0.00,0.00,0.00,0.00,'2023-03-13 22:55:42','',''),(1796,'1','294',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,4000000.00,20000.00,0.00,0.00,'2023-03-14 13:47:21','',''),(1797,'1','294',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,12000000.00,15000.00,0.00,0.00,'2023-03-14 13:47:36','',''),(1798,'1','294',NULL,2,'Reception corrector for bridging 62',0.00,0.00,0.00,15000.00,0.00,'2023-03-14 16:40:51','',''),(1799,'1','294','3',2,'Received from bridging 62',0.00,0.00,15000.00,0.00,0.00,'2023-03-14 16:40:51','',''),(1800,'1','294',NULL,1,'Reception corrector for bridging 63',0.00,0.00,0.00,20000.00,0.00,'2023-03-14 16:41:07','',''),(1801,'1','294','2',1,'Received from bridging 63',0.00,0.00,20000.00,0.00,0.00,'2023-03-14 16:41:07','',''),(1802,'1','294','1',1,'Sale Id shift 295',0.00,0.00,0.00,3643.07,0.00,'2023-03-14 18:45:27','',''),(1803,'1','294','2',1,'Sale Id shift 295',0.00,0.00,0.00,795.13,0.00,'2023-03-14 18:45:27','',''),(1804,'1','294','2',1,'Sale Id shift 295',0.00,0.00,0.00,1016.41,0.00,'2023-03-14 18:45:27','',''),(1805,'1','294','2',1,'Sale Id shift 295',0.00,0.00,0.00,1129.24,0.00,'2023-03-14 18:45:27','',''),(1806,'1','294','2',1,'Sale Id shift 295',0.00,0.00,0.00,704.03,0.00,'2023-03-14 18:45:27','',''),(1807,'1','294','3',2,'Sale Id shift 295',0.00,0.00,0.00,1127.24,0.00,'2023-03-14 18:45:27','',''),(1808,'1','294','1',1,'Sale Id shift 295',0.00,0.00,0.00,2690.72,0.00,'2023-03-14 18:45:27','',''),(1809,'1','294','1',1,'Sale Id shift 295',0.00,0.00,0.00,3466.57,0.00,'2023-03-14 18:45:27','',''),(1810,'1','294','1',1,'Sale Id shift 295',0.00,0.00,0.00,0.03,0.00,'2023-03-14 18:45:27','',''),(1811,'1','294','1',1,'Sale Id shift 295',0.00,0.00,0.00,1587.20,0.00,'2023-03-14 18:45:27','',''),(1812,'1','294',NULL,2,'Sale Id shift 295',901792.00,0.00,0.00,0.00,0.00,'2023-03-14 18:45:27','',''),(1813,'1','294',NULL,1,'Sale Id shift 295',3006480.00,0.00,0.00,0.00,0.00,'2023-03-14 18:45:27','',''),(1814,'1','294','2',1,'Sale Id shift 296',0.00,0.00,0.00,2500.40,0.00,'2023-03-14 22:11:07','',''),(1815,'1','294','2',1,'Sale Id shift 296',0.00,0.00,0.00,823.59,0.00,'2023-03-14 22:11:07','',''),(1816,'1','294','2',1,'Sale Id shift 296',0.00,0.00,0.00,1063.43,0.00,'2023-03-14 22:11:07','',''),(1817,'1','294','2',1,'Sale Id shift 296',0.00,0.00,0.00,1979.33,0.00,'2023-03-14 22:11:07','',''),(1818,'1','294','2',1,'Sale Id shift 296',0.00,0.00,0.00,1139.80,0.00,'2023-03-14 22:11:07','',''),(1819,'1','294','2',1,'Sale Id shift 296',0.00,0.00,0.00,313.52,0.00,'2023-03-14 22:11:07','',''),(1820,'1','294','3',2,'Sale Id shift 296',0.00,0.00,0.00,3838.32,0.00,'2023-03-14 22:11:07','',''),(1821,'1','294',NULL,2,'Sale Id shift 296',3070656.00,0.00,0.00,0.00,0.00,'2023-03-14 22:11:07','',''),(1822,'1','294',NULL,1,'Sale Id shift 296',1564014.00,0.00,0.00,0.00,0.00,'2023-03-14 22:11:07','',''),(1823,'1','294','2',1,'Sale Id shift 297',0.00,0.00,0.00,3113.92,0.00,'2023-03-15 16:28:17','',''),(1824,'1','294','2',1,'Sale Id shift 297',0.00,0.00,0.00,2379.51,0.00,'2023-03-15 16:28:17','',''),(1825,'1','294','2',1,'Sale Id shift 297',0.00,0.00,0.00,279.06,0.00,'2023-03-15 16:28:17','',''),(1826,'1','294','2',1,'Sale Id shift 297',0.00,0.00,0.00,2725.36,0.00,'2023-03-15 16:28:17','',''),(1827,'1','294','3',2,'Sale Id shift 297',0.00,0.00,0.00,1536.25,0.00,'2023-03-15 16:28:17','',''),(1828,'1','294','3',2,'Sale Id shift 297',0.00,0.00,0.00,1778.14,0.00,'2023-03-15 16:28:17','',''),(1829,'1','294',NULL,2,'Sale Id shift 297',2651512.00,0.00,0.00,0.00,0.00,'2023-03-15 16:28:17','',''),(1830,'1','294',NULL,1,'Sale Id shift 297',1699570.00,0.00,0.00,0.00,0.00,'2023-03-15 16:28:17','',''),(1831,'1','294','3',2,'Sale Id shift 298',0.00,0.00,0.00,3468.13,0.00,'2023-03-16 08:31:35','',''),(1832,'1','294','3',2,'Sale Id shift 298',0.00,0.00,0.00,893.75,0.00,'2023-03-16 08:31:35','',''),(1833,'1','294','3',2,'Sale Id shift 298',0.00,0.00,0.00,250.00,0.00,'2023-03-16 08:31:35','',''),(1834,'1','294',NULL,2,'Sale Id shift 298',3689504.00,0.00,0.00,0.00,0.00,'2023-03-16 08:31:35','',''),(1835,'1','294','3',2,'Sale Id shift 299',0.00,0.00,0.00,1184.87,0.00,'2023-03-16 14:59:56','',''),(1836,'1','294','3',2,'Sale Id shift 299',0.00,0.00,0.00,719.38,0.00,'2023-03-16 14:59:56','',''),(1837,'1','294',NULL,2,'Sale Id shift 299',1523400.00,0.00,0.00,0.00,0.00,'2023-03-16 14:59:56','',''),(1838,'1','294','3',2,'Sale Id shift 300',0.00,0.00,0.00,250.00,0.00,'2023-03-16 21:05:20','',''),(1839,'1','294','3',2,'Sale Id shift 300',0.00,0.00,0.00,112.12,0.00,'2023-03-16 21:05:20','',''),(1840,'1','294',NULL,2,'Sale Id shift 300',289696.00,0.00,0.00,0.00,0.00,'2023-03-16 21:05:20','',''),(1841,'1','294',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9000000.00,45000.00,0.00,0.00,'2023-03-19 15:07:24','',''),(1842,'1','294',NULL,1,'Reception corrector for bridging 64',0.00,0.00,0.00,44700.00,0.00,'2023-03-19 15:12:56','',''),(1843,'1','294','2',1,'Received from bridging 64',0.00,0.00,44700.00,0.00,0.00,'2023-03-19 15:12:56','',''),(1844,'1','294','2',1,'Sale Id shift 301',0.00,0.00,0.00,5595.34,0.00,'2023-03-19 15:27:07','',''),(1845,'1','294','2',1,'Sale Id shift 301',0.00,0.00,0.00,4661.40,0.00,'2023-03-19 15:27:07','',''),(1846,'1','294','2',1,'Sale Id shift 301',0.00,0.00,0.00,4530.92,0.00,'2023-03-19 15:27:07','',''),(1847,'1','294','2',1,'Sale Id shift 301',0.00,0.00,0.00,3279.79,0.00,'2023-03-19 15:27:07','',''),(1848,'1','294','2',1,'Sale Id shift 301',0.00,0.00,0.00,3541.93,0.00,'2023-03-19 15:27:07','',''),(1849,'1','294',NULL,1,'Sale Id shift 301',4321876.00,0.00,0.00,0.00,0.00,'2023-03-19 15:27:07','',''),(1850,'1','294','2',1,'Sale Id shift 302',0.00,0.00,0.00,955.67,0.00,'2023-03-19 16:25:55','',''),(1851,'1','294','2',1,'Sale Id shift 302',0.00,0.00,0.00,2913.54,0.00,'2023-03-19 16:25:55','',''),(1852,'1','294','2',1,'Sale Id shift 302',0.00,0.00,0.00,1229.02,0.00,'2023-03-19 16:25:55','',''),(1853,'1','294','2',1,'Sale Id shift 302',0.00,0.00,0.00,3385.19,0.00,'2023-03-19 16:25:55','',''),(1854,'1','294',NULL,1,'Sale Id shift 302',1696684.00,0.00,0.00,0.00,0.00,'2023-03-19 16:25:55','',''),(1855,'1','294','2',1,'Sale Id shift 303',0.00,0.00,0.00,3341.39,0.00,'2023-03-19 16:35:58','',''),(1856,'1','294','2',1,'Sale Id shift 303',0.00,0.00,0.00,2956.12,0.00,'2023-03-19 16:35:58','',''),(1857,'1','294','2',1,'Sale Id shift 303',0.00,0.00,0.00,2177.58,0.00,'2023-03-19 16:35:58','',''),(1858,'1','294','2',1,'Sale Id shift 303',0.00,0.00,0.00,2127.62,0.00,'2023-03-19 16:35:58','',''),(1859,'1','294','2',1,'Sale Id shift 303',0.00,0.00,0.00,2866.89,0.00,'2023-03-19 16:35:58','',''),(1860,'1','294','2',1,'Sale Id shift 303',0.00,0.00,0.00,1074.29,0.00,'2023-03-19 16:35:58','',''),(1861,'1','294',NULL,1,'Sale Id shift 303',2908778.00,0.00,0.00,0.00,0.00,'2023-03-19 16:35:58','',''),(1862,'1','294',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,36000000.00,45000.00,0.00,0.00,'2023-03-20 12:31:12','',''),(1863,'1','294',NULL,2,'Reception corrector for bridging 65',0.00,0.00,0.00,45000.00,0.00,'2023-03-20 13:32:12','',''),(1864,'1','294','3',2,'Received from bridging 65',0.00,0.00,45000.00,0.00,0.00,'2023-03-20 13:32:12','',''),(1865,'1','294','3',2,'Sale Id shift 304',0.00,0.00,0.00,554.38,0.00,'2023-03-20 15:18:09','',''),(1866,'1','294','3',2,'Sale Id shift 304',0.00,0.00,0.00,373.75,0.00,'2023-03-20 15:18:09','',''),(1867,'1','294',NULL,2,'Sale Id shift 304',742504.00,0.00,0.00,0.00,0.00,'2023-03-20 15:18:09','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'1','294',2,39157.15,'2023-03-20 15:18:09'),(2,'1','294',1,38321.32,'2023-03-20 13:43:10');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=408 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1,'1','294',1,'Sale Id shift 1',0.00,114045.75,175.00,114045.75,0.00,'2022-10-26 12:07:01'),(2,'1','294',2,'Sale Id shift 2',0.00,904006.80,755.00,904006.80,0.00,'2022-10-26 12:23:47'),(3,'1','294',1,'Sale Id shift 2',0.00,642118.75,175.00,642118.75,0.00,'2022-10-26 12:23:47'),(4,'1','294',2,'Sale Id shift 3',0.00,214284.10,755.00,214284.10,0.00,'2022-10-26 13:54:57'),(5,'1','294',1,'Sale Id shift 3',0.00,187755.75,175.00,187755.75,0.00,'2022-10-26 13:54:57'),(6,'1','294',2,'Sale Id shift 4',0.00,1313564.10,755.00,1313564.10,0.00,'2022-10-26 14:28:54'),(7,'1','294',1,'Sale Id shift 4',0.00,1470764.75,175.00,1470764.75,0.00,'2022-10-26 14:28:54'),(8,'1','294',2,'Sale Id shift 5',0.00,100437.65,755.00,100437.65,0.00,'2022-10-26 14:43:05'),(9,'1','294',1,'Sale Id shift 5',0.00,294652.75,175.00,294652.75,0.00,'2022-10-26 14:43:05'),(10,'1','294',1,'Sale Id shift 6',0.00,-7875.00,175.00,-7875.00,0.00,'2022-10-26 15:02:05'),(11,'1','294',2,'Sale Id shift 7',0.00,2445218.50,755.00,2445218.50,0.00,'2022-10-26 15:31:08'),(12,'1','294',1,'Sale Id shift 7',0.00,1581098.75,175.00,1581098.75,0.00,'2022-10-26 15:31:08'),(13,'1','294',1,'Sale Id shift 8',0.00,255150.00,175.00,255150.00,0.00,'2022-10-26 16:02:47'),(14,'1','294',2,'Sale Id shift 9',0.00,1837013.15,755.00,1837013.15,0.00,'2022-10-26 17:12:11'),(15,'1','294',1,'Sale Id shift 9',0.00,1688025.50,175.00,1688025.50,0.00,'2022-10-26 17:12:11'),(16,'1','294',2,'Sale Id shift 10',0.00,454872.40,755.00,454872.40,0.00,'2022-10-27 10:52:18'),(17,'1','294',1,'Sale Id shift 10',0.00,297298.75,175.00,297298.75,0.00,'2022-10-27 10:52:18'),(18,'1','294',2,'Sale Id shift 11',0.00,716298.70,755.00,716298.70,0.00,'2022-10-27 10:59:58'),(19,'1','294',1,'Sale Id shift 11',0.00,795705.75,175.00,795705.75,0.00,'2022-10-27 10:59:58'),(20,'1','294',2,'Sale Id shift 12',0.00,562822.30,755.00,562822.30,0.00,'2022-10-27 11:25:30'),(21,'1','294',1,'Sale Id shift 12',0.00,958027.00,175.00,958027.00,0.00,'2022-10-27 11:25:30'),(22,'1','294',2,'Sale Id shift 13',0.00,595513.80,755.00,595513.80,0.00,'2022-10-27 11:34:46'),(23,'1','294',1,'Sale Id shift 13',0.00,901538.75,175.00,901538.75,0.00,'2022-10-27 11:34:46'),(24,'1','294',2,'Sale Id shift 14',0.00,608243.10,755.00,608243.10,0.00,'2022-10-27 11:48:37'),(25,'1','294',1,'Sale Id shift 14',0.00,971509.00,175.00,971509.00,0.00,'2022-10-27 11:48:37'),(26,'1','294',2,'Sale Id shift 15',0.00,746951.70,755.00,746951.70,0.00,'2022-10-27 11:55:51'),(27,'1','294',1,'Sale Id shift 15',0.00,788714.50,175.00,788714.50,0.00,'2022-10-27 11:55:51'),(28,'1','294',2,'Sale Id shift 16',0.00,1070046.40,755.00,1070046.40,0.00,'2022-10-27 12:01:17'),(29,'1','294',1,'Sale Id shift 16',0.00,989073.75,175.00,989073.75,0.00,'2022-10-27 12:01:17'),(30,'1','294',2,'Sale Id shift 17',0.00,607903.35,755.00,607903.35,0.00,'2022-10-27 12:11:06'),(31,'1','294',1,'Sale Id shift 17',0.00,1244008.50,175.00,1244008.50,0.00,'2022-10-27 12:11:06'),(32,'1','294',2,'Sale Id shift 18',0.00,1400660.90,755.00,1400660.90,0.00,'2022-10-27 12:17:02'),(33,'1','294',1,'Sale Id shift 18',0.00,1327131.75,175.00,1327131.75,0.00,'2022-10-27 12:17:02'),(34,'1','294',2,'Sale Id shift 19',0.00,453732.35,755.00,453732.35,0.00,'2022-10-27 12:21:28'),(35,'1','294',1,'Sale Id shift 19',0.00,1255668.75,175.00,1255668.75,0.00,'2022-10-27 12:21:28'),(36,'1','294',2,'Sale Id shift 20',0.00,1267071.20,755.00,1267071.20,0.00,'2022-10-27 12:27:40'),(37,'1','294',1,'Sale Id shift 20',0.00,1481410.00,175.00,1481410.00,0.00,'2022-10-27 12:27:40'),(38,'1','294',2,'Sale Id shift 21',0.00,268402.50,755.00,268402.50,0.00,'2022-10-27 12:31:33'),(39,'1','294',1,'Sale Id shift 21',0.00,1116963.75,175.00,1116963.75,0.00,'2022-10-27 12:31:33'),(40,'1','294',2,'Sale Id shift 22',0.00,1113881.70,755.00,1113881.70,0.00,'2022-10-27 12:38:49'),(41,'1','294',1,'Sale Id shift 22',0.00,998131.75,175.00,998131.75,0.00,'2022-10-27 12:38:49'),(42,'1','294',2,'Sale Id shift 23',0.00,359380.00,755.00,359380.00,0.00,'2022-10-27 12:45:37'),(43,'1','294',1,'Sale Id shift 23',0.00,1015525.00,175.00,1015525.00,0.00,'2022-10-27 12:45:37'),(44,'1','294',2,'Sale Id shift 24',0.00,315288.00,755.00,315288.00,0.00,'2022-10-27 14:59:54'),(45,'1','294',1,'Sale Id shift 24',0.00,1338555.75,175.00,1338555.75,0.00,'2022-10-27 14:59:54'),(46,'1','294',2,'Sale Id shift 25',0.00,697544.50,755.00,697544.50,0.00,'2022-10-27 15:11:28'),(47,'1','294',1,'Sale Id shift 25',0.00,1088589.25,175.00,1088589.25,0.00,'2022-10-27 15:11:28'),(48,'1','294',2,'Sale Id shift 26',0.00,337990.85,755.00,337990.85,0.00,'2022-10-27 15:19:36'),(49,'1','294',1,'Sale Id shift 26',0.00,1172895.50,175.00,1172895.50,0.00,'2022-10-27 15:19:36'),(50,'1','294',2,'Sale Id shift 27',0.00,231679.30,755.00,231679.30,0.00,'2022-10-27 15:24:53'),(51,'1','294',1,'Sale Id shift 27',0.00,1222651.50,175.00,1222651.50,0.00,'2022-10-27 15:24:53'),(52,'1','294',2,'Sale Id shift 28',0.00,1419747.30,755.00,1419747.30,0.00,'2022-10-27 15:31:09'),(53,'1','294',1,'Sale Id shift 28',0.00,1151951.50,175.00,1151951.50,0.00,'2022-10-27 15:31:09'),(54,'1','294',2,'Sale Id shift 29',0.00,1089585.80,755.00,1089585.80,0.00,'2022-10-27 15:37:34'),(55,'1','294',1,'Sale Id shift 29',0.00,104359.50,175.00,104359.50,0.00,'2022-10-27 15:37:34'),(56,'1','294',2,'Sale Id shift 30',0.00,1534718.70,755.00,1534718.70,0.00,'2022-10-27 16:00:26'),(57,'1','294',1,'Sale Id shift 30',0.00,359642.50,175.00,359642.50,0.00,'2022-10-27 16:00:26'),(58,'1','294',2,'Sale Id shift 31',0.00,1106059.90,755.00,1106059.90,0.00,'2022-10-27 16:28:12'),(59,'1','294',1,'Sale Id shift 31',0.00,981291.50,175.00,981291.50,0.00,'2022-10-27 16:28:12'),(60,'1','294',2,'Sale Id shift 32',0.00,416790.20,755.00,416790.20,0.00,'2022-10-27 16:39:10'),(61,'1','294',1,'Sale Id shift 32',0.00,1558275.25,175.00,1558275.25,0.00,'2022-10-27 16:39:10'),(62,'1','294',2,'Sale Id shift 33',0.00,899182.35,755.00,899182.35,0.00,'2022-10-27 16:47:16'),(63,'1','294',1,'Sale Id shift 33',0.00,1252441.75,175.00,1252441.75,0.00,'2022-10-27 16:47:16'),(64,'1','294',2,'Sale Id shift 34',0.00,839567.55,755.00,839567.55,0.00,'2022-10-27 16:53:52'),(65,'1','294',1,'Sale Id shift 34',0.00,1780994.25,175.00,1780994.25,0.00,'2022-10-27 16:53:52'),(66,'1','294',2,'Sale Id shift 35',0.00,279553.85,755.00,279553.85,0.00,'2022-10-27 17:01:45'),(67,'1','294',1,'Sale Id shift 35',0.00,1219734.25,175.00,1219734.25,0.00,'2022-10-27 17:01:45'),(68,'1','294',2,'Sale Id shift 36',0.00,1125538.90,755.00,1125538.90,0.00,'2022-10-27 17:08:46'),(69,'1','294',1,'Sale Id shift 36',0.00,1530278.75,175.00,1530278.75,0.00,'2022-10-27 17:08:46'),(70,'1','294',2,'Sale Id shift 37',0.00,280822.25,755.00,280822.25,0.00,'2022-10-27 17:21:11'),(71,'1','294',1,'Sale Id shift 37',0.00,1263335.50,175.00,1263335.50,0.00,'2022-10-27 17:21:11'),(72,'1','294',2,'Sale Id shift 38',0.00,1503778.80,755.00,1503778.80,0.00,'2022-10-27 17:26:20'),(73,'1','294',1,'Sale Id shift 38',0.00,1371196.75,175.00,1371196.75,0.00,'2022-10-27 17:26:20'),(74,'1','294',2,'Sale Id shift 39',0.00,1241529.55,755.00,1241529.55,0.00,'2022-10-27 17:29:42'),(75,'1','294',1,'Sale Id shift 39',0.00,783585.25,175.00,783585.25,0.00,'2022-10-27 17:29:42'),(76,'1','294',2,'Sale Id shift 40',0.00,700957.10,755.00,700957.10,0.00,'2022-10-27 17:32:55'),(77,'1','294',1,'Sale Id shift 40',0.00,1666070.00,175.00,1666070.00,0.00,'2022-10-27 17:32:55'),(78,'1','294',2,'Sale Id shift 41',0.00,980050.40,755.00,980050.40,0.00,'2022-10-28 16:54:18'),(79,'1','294',1,'Sale Id shift 41',0.00,1187249.00,175.00,1187249.00,0.00,'2022-10-28 16:54:18'),(80,'1','294',2,'Sale Id shift 42',0.00,1424760.50,755.00,1424760.50,0.00,'2022-10-28 17:00:34'),(81,'1','294',1,'Sale Id shift 42',0.00,1849424.50,175.00,1849424.50,0.00,'2022-10-28 17:00:34'),(82,'1','294',2,'Sale Id shift 43',0.00,304770.85,755.00,304770.85,0.00,'2022-10-28 17:05:43'),(83,'1','294',1,'Sale Id shift 43',0.00,353928.75,175.00,353928.75,0.00,'2022-10-28 17:05:43'),(84,'1','294',1,'Sale Id shift 44',0.00,970627.00,175.00,970627.00,0.00,'2022-10-28 17:11:19'),(85,'1','294',1,'Sale Id shift 45',0.00,428004.50,178.00,435341.72,7337.22,'2022-10-28 17:28:48'),(86,'1','294',1,'Sale Id shift 46',0.00,1971428.32,178.00,1971428.32,0.00,'2022-10-28 17:42:21'),(87,'1','294',1,'Sale Id shift 47',0.00,1409021.30,178.00,1409021.30,0.00,'2022-10-28 18:17:10'),(88,'1','294',1,'Sale Id shift 48',0.00,1705247.12,178.00,1705247.12,0.00,'2022-10-29 11:23:06'),(89,'1','294',1,'Sale Id shift 49',0.00,1189768.02,178.00,1189768.02,0.00,'2022-10-29 11:26:28'),(90,'1','294',1,'Sale Id shift 50',0.00,1492108.14,178.00,1492108.14,0.00,'2022-10-29 11:30:20'),(91,'1','294',1,'Sale Id shift 51',0.00,1170766.52,178.00,1170766.52,0.00,'2022-10-29 11:33:09'),(92,'1','294',1,'Sale Id shift 52',0.00,1532136.78,178.00,1532136.78,0.00,'2022-10-29 11:41:02'),(93,'1','294',1,'Sale Id shift 53',0.00,1307239.12,178.00,1307239.12,0.00,'2022-10-29 11:44:04'),(94,'1','294',1,'Sale Id shift 54',0.00,1487341.30,178.00,1487341.30,0.00,'2022-10-29 11:48:02'),(95,'1','294',2,'Sale Id shift 55',0.00,1598928.10,770.00,1598928.10,0.00,'2022-10-29 11:52:17'),(96,'1','294',1,'Sale Id shift 55',0.00,1035376.16,178.00,1035376.16,0.00,'2022-10-29 11:52:17'),(97,'1','294',2,'Sale Id shift 56',0.00,1508707.20,770.00,1508707.20,0.00,'2022-10-29 11:55:40'),(98,'1','294',1,'Sale Id shift 56',0.00,1328965.80,178.00,1328965.80,0.00,'2022-10-29 11:55:40'),(99,'1','294',2,'Sale Id shift 57',0.00,269007.20,770.00,269007.20,0.00,'2022-10-29 12:12:05'),(100,'1','294',1,'Sale Id shift 57',0.00,1133541.38,178.00,1133541.38,0.00,'2022-10-29 12:12:05'),(101,'1','294',2,'Sale Id shift 58',0.00,443016.60,780.00,443016.60,0.00,'2022-10-29 12:14:52'),(102,'1','294',2,'Sale Id shift 59',0.00,1316694.60,780.00,1316694.60,0.00,'2022-10-29 12:17:37'),(103,'1','294',1,'Sale Id shift 59',0.00,1276639.14,178.00,1276639.14,0.00,'2022-10-29 12:17:37'),(104,'1','294',2,'Sale Id shift 60',0.00,549003.00,780.00,549003.00,0.00,'2022-10-29 12:24:10'),(105,'1','294',1,'Sale Id shift 60',0.00,1084614.52,178.00,1084614.52,0.00,'2022-10-29 12:24:10'),(106,'1','294',2,'Sale Id shift 61',0.00,2364398.40,780.00,2364398.40,0.00,'2022-10-29 12:28:18'),(107,'1','294',1,'Sale Id shift 61',0.00,1238694.88,178.00,1238694.88,0.00,'2022-10-29 12:28:18'),(108,'1','294',2,'Sale Id shift 63',0.00,1110712.20,780.00,1110712.20,0.00,'2022-10-29 12:36:17'),(109,'1','294',1,'Sale Id shift 63',0.00,989135.00,178.00,1006091.60,16956.60,'2022-10-29 12:36:17'),(110,'1','294',2,'Sale Id shift 64',0.00,847282.80,780.00,847282.80,0.00,'2022-10-29 12:39:23'),(111,'1','294',1,'Sale Id shift 64',0.00,1176385.00,178.00,1196551.60,20166.60,'2022-10-29 12:39:23'),(112,'1','294',2,'Sale Id shift 65',0.00,1489612.80,780.00,1489612.80,0.00,'2022-10-29 12:42:29'),(113,'1','294',2,'Sale Id shift 66',0.00,1140562.80,780.00,1140562.80,0.00,'2022-10-29 12:44:02'),(114,'1','294',2,'Sale Id shift 67',0.00,180000.60,780.00,180000.60,0.00,'2022-10-29 12:45:40'),(115,'1','294',2,'Sale Id shift 68',0.00,598813.80,780.00,598813.80,0.00,'2022-10-29 12:49:45'),(116,'1','294',1,'Sale Id shift 68',0.00,862601.25,178.00,877388.70,14787.45,'2022-10-29 12:49:45'),(117,'1','294',2,'Sale Id shift 69',0.00,313201.20,780.00,313201.20,0.00,'2022-10-29 12:52:39'),(118,'1','294',1,'Sale Id shift 69',0.00,940821.00,178.00,956949.36,16128.36,'2022-10-29 12:52:39'),(119,'1','294',2,'Sale Id shift 70',0.00,1313816.40,780.00,1313816.40,0.00,'2022-10-29 13:03:01'),(120,'1','294',1,'Sale Id shift 70',0.00,1472345.00,178.00,1497585.20,25240.20,'2022-10-29 13:03:01'),(121,'1','294',2,'Sale Id shift 71',0.00,483709.20,780.00,483709.20,0.00,'2022-10-29 14:50:27'),(122,'1','294',1,'Sale Id shift 71',0.00,1104719.00,178.00,1123657.04,18938.04,'2022-10-29 14:50:27'),(123,'1','294',2,'Sale Id shift 72',0.00,291392.40,780.00,291392.40,0.00,'2022-10-29 15:13:12'),(124,'1','294',1,'Sale Id shift 72',0.00,1451950.50,178.00,1476841.08,24890.58,'2022-10-29 15:13:12'),(125,'1','294',1,'Sale Id shift 73',0.00,1157679.25,178.00,1177525.18,19845.93,'2022-10-29 15:15:56'),(126,'1','294',1,'Sale Id shift 74',0.00,1399790.00,178.00,1423786.40,23996.40,'2022-10-29 15:21:07'),(127,'1','294',1,'Sale Id shift 75',0.00,1117814.25,178.00,1136976.78,19162.53,'2022-10-29 15:23:31'),(128,'1','294',1,'Sale Id shift 76',0.00,1041220.25,178.00,1059069.74,17849.49,'2022-10-29 15:25:24'),(129,'1','294',1,'Sale Id shift 80',0.00,811284.84,178.00,811284.84,0.00,'2022-10-31 13:28:26'),(130,'1','294',1,'Sale Id shift 81',0.00,1560727.14,178.00,1560727.14,0.00,'2022-10-31 14:14:52'),(131,'1','294',2,'Sale Id shift 82',0.00,2166416.00,800.00,2166416.00,0.00,'2022-10-31 14:23:41'),(132,'1','294',1,'Sale Id shift 82',0.00,1849037.30,178.00,1849037.30,0.00,'2022-10-31 14:23:41'),(133,'1','294',2,'Sale Id shift 83',0.00,1836144.00,800.00,1836144.00,0.00,'2022-10-31 14:28:56'),(134,'1','294',1,'Sale Id shift 83',0.00,1768987.14,178.00,1768987.14,0.00,'2022-10-31 14:28:56'),(135,'1','294',2,'Sale Id shift 84',0.00,1157696.00,800.00,1157696.00,0.00,'2022-10-31 14:33:35'),(136,'1','294',1,'Sale Id shift 84',0.00,1716119.36,178.00,1716119.36,0.00,'2022-10-31 14:33:35'),(137,'1','294',2,'Sale Id shift 85',0.00,909640.00,800.00,909640.00,0.00,'2022-10-31 14:41:09'),(138,'1','294',1,'Sale Id shift 85',0.00,1606343.20,178.00,1606343.20,0.00,'2022-10-31 14:41:09'),(139,'1','294',2,'Sale Id shift 86',0.00,733608.00,800.00,733608.00,0.00,'2022-10-31 14:45:58'),(140,'1','294',1,'Sale Id shift 86',0.00,1388818.30,178.00,1388818.30,0.00,'2022-10-31 14:45:58'),(141,'1','294',2,'Sale Id shift 87',0.00,904048.00,800.00,904048.00,0.00,'2022-10-31 14:59:31'),(142,'1','294',1,'Sale Id shift 87',0.00,15585.68,178.00,15585.68,0.00,'2022-10-31 14:59:31'),(143,'1','294',2,'Sale Id shift 88',0.00,670136.00,800.00,670136.00,0.00,'2022-10-31 15:04:15'),(144,'1','294',2,'Sale Id shift 89',0.00,920400.00,800.00,920400.00,0.00,'2022-10-31 15:13:36'),(145,'1','294',2,'Sale Id shift 90',0.00,1410280.00,800.00,1410280.00,0.00,'2022-10-31 15:17:59'),(146,'1','294',2,'Sale Id shift 91',0.00,316200.00,800.00,316200.00,0.00,'2022-10-31 15:19:49'),(147,'1','294',2,'Sale Id shift 92',0.00,804888.00,800.00,804888.00,0.00,'2022-10-31 15:28:30'),(148,'1','294',2,'Sale Id shift 93',0.00,936360.00,800.00,936360.00,0.00,'2022-10-31 15:30:37'),(149,'1','294',2,'Sale Id shift 94',0.00,1354600.00,800.00,1354600.00,0.00,'2022-10-31 15:36:45'),(150,'1','294',2,'Sale Id shift 95',0.00,1043168.00,800.00,1043168.00,0.00,'2022-10-31 15:41:27'),(151,'1','294',2,'Sale Id shift 96',0.00,1502944.00,800.00,1502944.00,0.00,'2022-10-31 15:56:20'),(152,'1','294',2,'Sale Id shift 97',0.00,904800.00,800.00,904800.00,0.00,'2022-10-31 22:32:15'),(153,'1','294',2,'Sale Id shift 98',0.00,2495896.00,800.00,2495896.00,0.00,'2022-11-01 13:35:11'),(154,'1','294',2,'Sale Id shift 99',0.00,1280112.00,800.00,1280112.00,0.00,'2022-11-01 14:36:50'),(155,'1','294',2,'Sale Id shift 100',0.00,2075352.00,800.00,2075352.00,0.00,'2022-11-01 17:46:57'),(156,'1','294',2,'Sale Id shift 101',0.00,2245952.00,800.00,2245952.00,0.00,'2022-11-01 18:04:34'),(157,'1','294',2,'Sale Id shift 102',0.00,607200.00,800.00,607200.00,0.00,'2022-11-01 18:07:47'),(158,'1','294',2,'Sale Id shift 103',0.00,1470688.00,800.00,1470688.00,0.00,'2022-11-01 18:10:14'),(159,'1','294',2,'Sale Id shift 104',0.00,318600.00,800.00,318600.00,0.00,'2022-11-01 18:12:03'),(160,'1','294',2,'Sale Id shift 105',0.00,3037920.00,800.00,3037920.00,0.00,'2022-11-04 23:53:33'),(161,'1','294',2,'Sale Id shift 106',0.00,2265224.00,800.00,2265224.00,0.00,'2022-11-05 10:20:31'),(162,'1','294',2,'Sale Id shift 107',0.00,6101576.00,800.00,6101576.00,0.00,'2022-11-05 10:37:26'),(163,'1','294',2,'Sale Id shift 108',0.00,1531120.00,800.00,1531120.00,0.00,'2022-11-05 10:43:59'),(164,'1','294',2,'Sale Id shift 109',0.00,4902736.00,800.00,4902736.00,0.00,'2022-11-05 15:30:30'),(165,'1','294',2,'Sale Id shift 110',0.00,812600.00,800.00,812600.00,0.00,'2022-11-07 20:00:21'),(166,'1','294',2,'Sale Id shift 111',0.00,5056176.00,800.00,5056176.00,0.00,'2022-11-07 20:40:14'),(167,'1','294',2,'Sale Id shift 112',0.00,2048400.00,800.00,2048400.00,0.00,'2022-11-08 06:32:59'),(168,'1','294',1,'Sale Id shift 112',0.00,397661.20,185.00,397661.20,0.00,'2022-11-08 06:32:59'),(169,'1','294',2,'Sale Id shift 113',0.00,2247400.00,800.00,2247400.00,0.00,'2022-11-08 16:27:19'),(170,'1','294',1,'Sale Id shift 113',0.00,2297803.60,185.00,2297803.60,0.00,'2022-11-08 16:27:19'),(171,'1','294',2,'Sale Id shift 114',0.00,4820088.00,800.00,4820088.00,0.00,'2022-11-09 11:45:47'),(172,'1','294',1,'Sale Id shift 114',0.00,520930.40,185.00,520930.40,0.00,'2022-11-09 11:45:47'),(173,'1','294',2,'Sale Id shift 115',0.00,2440168.00,800.00,2440168.00,0.00,'2022-11-09 17:45:22'),(174,'1','294',1,'Sale Id shift 115',0.00,1600684.75,185.00,1600684.75,0.00,'2022-11-09 17:45:22'),(175,'1','294',2,'Sale Id shift 116',0.00,4471856.00,800.00,4471856.00,0.00,'2022-11-10 13:33:25'),(176,'1','294',1,'Sale Id shift 116',0.00,1126916.40,185.00,1126916.40,0.00,'2022-11-10 13:33:25'),(177,'1','294',2,'Sale Id shift 117',0.00,4610632.00,800.00,4610632.00,0.00,'2022-11-10 20:09:30'),(178,'1','294',1,'Sale Id shift 117',0.00,2955728.35,185.00,2955728.35,0.00,'2022-11-10 20:09:30'),(179,'1','294',2,'Sale Id shift 118',0.00,2912269.60,860.00,2912269.60,0.00,'2022-11-11 15:36:06'),(180,'1','294',1,'Sale Id shift 118',0.00,376745.10,185.00,376745.10,0.00,'2022-11-11 15:36:06'),(181,'1','294',2,'Sale Id shift 119',0.00,2435709.20,860.00,2435709.20,0.00,'2022-11-11 18:26:10'),(182,'1','294',2,'Sale Id shift 120',0.00,2984759.00,860.00,2984759.00,0.00,'2022-11-12 09:38:29'),(183,'1','294',2,'Sale Id shift 121',0.00,719871.60,860.00,719871.60,0.00,'2022-11-13 07:48:18'),(184,'1','294',2,'Sale Id shift 122',0.00,1625451.60,860.00,1625451.60,0.00,'2022-11-13 15:00:57'),(185,'1','294',2,'Sale Id shift 123',0.00,545265.80,860.00,545265.80,0.00,'2022-11-13 15:19:17'),(186,'1','294',2,'Sale Id shift 124',0.00,1284444.40,860.00,1284444.40,0.00,'2022-11-13 23:25:59'),(187,'1','294',2,'Sale Id shift 125',0.00,1405334.60,860.00,1405334.60,0.00,'2022-11-14 20:09:46'),(188,'1','294',2,'Sale Id shift 126',0.00,1952200.00,860.00,1952200.00,0.00,'2022-11-15 10:47:49'),(189,'1','294',2,'Sale Id shift 127',0.00,1389785.80,860.00,1389785.80,0.00,'2022-11-15 18:48:17'),(190,'1','294',2,'Sale Id shift 128',0.00,1585074.60,860.00,1585074.60,0.00,'2022-11-16 14:11:49'),(191,'1','294',2,'Sale Id shift 129',0.00,1608527.25,825.00,1608527.25,0.00,'2022-11-16 20:29:43'),(192,'1','294',1,'Sale Id shift 129',0.00,1344491.20,185.00,1344491.20,0.00,'2022-11-16 20:29:43'),(193,'1','294',2,'Sale Id shift 130',0.00,1950844.50,825.00,1950844.50,0.00,'2022-11-17 14:42:24'),(194,'1','294',1,'Sale Id shift 130',0.00,372186.70,185.00,372186.70,0.00,'2022-11-17 14:42:24'),(195,'1','294',2,'Sale Id shift 131',0.00,1629498.75,825.00,1629498.75,0.00,'2022-11-17 17:31:33'),(196,'1','294',1,'Sale Id shift 131',0.00,1772781.00,185.00,1772781.00,0.00,'2022-11-17 17:31:33'),(197,'1','294',2,'Sale Id shift 132',0.00,1312187.25,825.00,1312187.25,0.00,'2022-11-18 12:21:26'),(198,'1','294',2,'Sale Id shift 133',0.00,1667325.00,825.00,1667325.00,0.00,'2022-11-18 21:30:37'),(199,'1','294',1,'Sale Id shift 133',0.00,1305334.10,185.00,1305334.10,0.00,'2022-11-18 21:30:37'),(200,'1','294',2,'Sale Id shift 134',0.00,2442239.25,825.00,2442239.25,0.00,'2022-11-19 12:32:54'),(201,'1','294',2,'Sale Id shift 135',0.00,1764159.60,840.00,1764159.60,0.00,'2022-11-19 13:10:36'),(202,'1','294',2,'Sale Id shift 136',0.00,1010200.80,840.00,1010200.80,0.00,'2022-11-19 18:55:12'),(203,'1','294',2,'Sale Id shift 137',0.00,1256001.60,840.00,1256001.60,0.00,'2022-11-20 15:42:30'),(204,'1','294',2,'Sale Id shift 138',0.00,1731458.40,840.00,1731458.40,0.00,'2022-11-20 23:02:17'),(205,'1','294',2,'Sale Id shift 139',0.00,2268924.00,840.00,2268924.00,0.00,'2022-11-21 11:22:43'),(206,'1','294',2,'Sale Id shift 140',0.00,4837812.00,840.00,4837812.00,0.00,'2022-11-21 15:40:00'),(207,'1','294',2,'Sale Id shift 141',0.00,2139496.80,840.00,2139496.80,0.00,'2022-11-22 16:43:00'),(208,'1','294',2,'Sale Id shift 142',0.00,2122957.20,840.00,2122957.20,0.00,'2022-11-23 12:31:03'),(209,'1','294',2,'Sale Id shift 143',0.00,1543752.00,840.00,1543752.00,0.00,'2022-11-23 14:35:18'),(210,'1','294',2,'Sale Id shift 144',0.00,1232985.60,840.00,1232985.60,0.00,'2022-11-23 15:17:13'),(211,'1','294',2,'Sale Id shift 145',0.00,2833378.80,840.00,2833378.80,0.00,'2022-11-24 09:50:56'),(212,'1','294',2,'Sale Id shift 146',0.00,1984466.40,840.00,1984466.40,0.00,'2022-11-24 14:44:32'),(213,'1','294',2,'Sale Id shift 147',0.00,2346642.40,830.00,2346642.40,0.00,'2022-11-25 15:07:01'),(214,'1','294',2,'Sale Id shift 148',0.00,485707.70,830.00,485707.70,0.00,'2022-11-25 19:22:03'),(215,'1','294',2,'Sale Id shift 149',0.00,3331055.60,830.00,3331055.60,0.00,'2022-11-26 11:09:16'),(216,'1','294',2,'Sale Id shift 150',0.00,1574319.10,830.00,1574319.10,0.00,'2022-11-26 16:25:18'),(217,'1','294',2,'Sale Id shift 151',0.00,1145400.00,830.00,1145400.00,0.00,'2022-11-27 21:54:30'),(218,'1','294',2,'Sale Id shift 152',0.00,498946.20,830.00,498946.20,0.00,'2022-11-28 17:57:00'),(219,'1','294',2,'Sale Id shift 153',0.00,2595835.20,840.00,2595835.20,0.00,'2022-12-01 09:07:39'),(220,'1','294',2,'Sale Id shift 154',0.00,3307953.60,840.00,3307953.60,0.00,'2022-12-01 13:41:28'),(221,'1','294',2,'Sale Id shift 155',0.00,1702806.00,840.00,1702806.00,0.00,'2022-12-02 10:36:10'),(222,'1','294',2,'Sale Id shift 156',0.00,2580958.80,840.00,2580958.80,0.00,'2022-12-02 15:37:16'),(223,'1','294',2,'Sale Id shift 157',0.00,1937544.00,840.00,1937544.00,0.00,'2022-12-03 13:41:51'),(224,'1','294',2,'Sale Id shift 158',0.00,2630728.80,840.00,2630728.80,0.00,'2022-12-03 21:12:06'),(225,'1','294',2,'Sale Id shift 159',0.00,729162.00,840.00,729162.00,0.00,'2022-12-04 09:43:42'),(226,'1','294',1,'Sale Id shift 159',0.00,1235913.80,220.00,1235913.80,0.00,'2022-12-04 09:43:42'),(227,'1','294',2,'Sale Id shift 160',0.00,1534990.80,840.00,1534990.80,0.00,'2022-12-04 12:23:45'),(228,'1','294',1,'Sale Id shift 160',0.00,588374.60,220.00,588374.60,0.00,'2022-12-04 12:23:45'),(229,'1','294',2,'Sale Id shift 161',0.00,1270825.60,880.00,1270825.60,0.00,'2022-12-05 05:51:36'),(230,'1','294',2,'Sale Id shift 162',0.00,2078894.40,880.00,2078894.40,0.00,'2022-12-05 10:31:32'),(231,'1','294',2,'Sale Id shift 163',0.00,1794927.20,880.00,1794927.20,0.00,'2022-12-05 10:46:38'),(232,'1','294',2,'Sale Id shift 164',0.00,1644605.60,880.00,1644605.60,0.00,'2022-12-05 17:51:39'),(233,'1','294',2,'Sale Id shift 165',0.00,1802583.20,880.00,1802583.20,0.00,'2022-12-06 10:11:10'),(234,'1','294',2,'Sale Id shift 166',0.00,1405386.40,880.00,1405386.40,0.00,'2022-12-06 20:24:29'),(235,'1','294',1,'Sale Id shift 166',0.00,1341916.40,220.00,1341916.40,0.00,'2022-12-06 20:24:29'),(236,'1','294',2,'Sale Id shift 167',0.00,348092.80,880.00,348092.80,0.00,'2022-12-07 11:09:46'),(237,'1','294',1,'Sale Id shift 167',0.00,2153351.20,220.00,2153351.20,0.00,'2022-12-07 11:09:46'),(238,'1','294',2,'Sale Id shift 168',0.00,1344630.00,840.00,1344630.00,0.00,'2022-12-07 14:03:04'),(239,'1','294',1,'Sale Id shift 169',0.00,1234897.40,220.00,1234897.40,0.00,'2022-12-07 15:41:13'),(240,'1','294',2,'Sale Id shift 170',0.00,5663174.20,820.00,5663174.20,0.00,'2022-12-19 13:43:05'),(241,'1','294',2,'Sale Id shift 171',0.00,1784746.40,820.00,1784746.40,0.00,'2022-12-19 13:48:54'),(242,'1','294',2,'Sale Id shift 172',0.00,7926226.60,820.00,7926226.60,0.00,'2022-12-19 13:53:50'),(243,'1','294',2,'Sale Id shift 173',0.00,2172483.40,820.00,2172483.40,0.00,'2022-12-19 14:06:37'),(244,'1','294',2,'Sale Id shift 174',0.00,1993157.60,820.00,1993157.60,0.00,'2022-12-19 14:34:47'),(245,'1','294',2,'Sale Id shift 175',0.00,2277500.80,820.00,2277500.80,0.00,'2022-12-19 18:31:20'),(246,'1','294',2,'Sale Id shift 176',0.00,2932000.20,820.00,2932000.20,0.00,'2022-12-20 10:39:21'),(247,'1','294',1,'Sale Id shift 177',0.00,3546903.60,230.00,3546903.60,0.00,'2022-12-22 15:17:30'),(248,'1','294',1,'Sale Id shift 178',0.00,3529175.20,230.00,3529175.20,0.00,'2022-12-22 19:50:01'),(249,'1','294',1,'Sale Id shift 179',0.00,4299551.00,230.00,4299551.00,0.00,'2022-12-23 11:50:15'),(250,'1','294',2,'Sale Id shift 180',0.00,2384199.20,820.00,2384199.20,0.00,'2022-12-23 16:34:56'),(251,'1','294',1,'Sale Id shift 180',0.00,2505500.40,230.00,2505500.40,0.00,'2022-12-23 16:34:56'),(252,'1','294',2,'Sale Id shift 181',0.00,1580427.00,820.00,1580427.00,0.00,'2022-12-24 09:55:33'),(253,'1','294',2,'Sale Id shift 182',0.00,3610952.00,820.00,3610952.00,0.00,'2022-12-24 13:13:15'),(254,'1','294',2,'Sale Id shift 183',0.00,3357859.00,820.00,3357859.00,0.00,'2022-12-24 15:38:41'),(255,'1','294',2,'Sale Id shift 184',0.00,2423493.60,820.00,2423493.60,0.00,'2022-12-25 06:58:50'),(256,'1','294',2,'Sale Id shift 185',0.00,3530337.80,820.00,3530337.80,0.00,'2022-12-26 08:23:41'),(257,'1','294',2,'Sale Id shift 186',0.00,3644727.80,820.00,3644727.80,0.00,'2022-12-26 18:53:49'),(258,'1','294',2,'Sale Id shift 187',0.00,1972477.20,820.00,1972477.20,0.00,'2022-12-27 10:16:17'),(259,'1','294',2,'Sale Id shift 188',0.00,5382348.80,820.00,5382348.80,0.00,'2022-12-27 13:10:20'),(260,'1','294',2,'Sale Id shift 189',0.00,3122912.60,820.00,3122912.60,0.00,'2022-12-28 11:29:21'),(261,'1','294',1,'Sale Id shift 189',0.00,2897526.50,235.00,2897526.50,0.00,'2022-12-28 11:29:21'),(262,'1','294',2,'Sale Id shift 190',0.00,4622791.00,820.00,4622791.00,0.00,'2022-12-28 15:44:58'),(263,'1','294',1,'Sale Id shift 190',0.00,2751295.40,235.00,2751295.40,0.00,'2022-12-28 15:44:58'),(264,'1','294',2,'Sale Id shift 191',0.00,2203618.80,820.00,2203618.80,0.00,'2022-12-29 12:27:10'),(265,'1','294',1,'Sale Id shift 191',0.00,1616205.45,235.00,1616205.45,0.00,'2022-12-29 12:27:10'),(266,'1','294',2,'Sale Id shift 192',0.00,7155779.20,820.00,7155779.20,0.00,'2022-12-29 15:09:09'),(267,'1','294',1,'Sale Id shift 192',0.00,3006930.75,235.00,3006930.75,0.00,'2022-12-29 15:09:09'),(268,'1','294',2,'Sale Id shift 193',0.00,2991655.20,820.00,2991655.20,0.00,'2022-12-29 16:29:27'),(269,'1','294',1,'Sale Id shift 193',0.00,1438348.05,235.00,1438348.05,0.00,'2022-12-29 16:29:27'),(270,'1','294',2,'Sale Id shift 194',0.00,3727260.80,820.00,3727260.80,0.00,'2022-12-30 11:39:12'),(271,'1','294',2,'Sale Id shift 195',0.00,2807950.60,820.00,2807950.60,0.00,'2022-12-30 19:33:07'),(272,'1','294',2,'Sale Id shift 196',0.00,3662005.20,820.00,3662005.20,0.00,'2022-12-31 16:56:32'),(273,'1','294',1,'Sale Id shift 196',0.00,2711277.25,235.00,2711277.25,0.00,'2022-12-31 16:56:32'),(274,'1','294',2,'Sale Id shift 197',0.00,2285463.00,820.00,2285463.00,0.00,'2023-01-01 12:32:41'),(275,'1','294',1,'Sale Id shift 197',0.00,3409981.60,235.00,3409981.60,0.00,'2023-01-01 12:32:41'),(276,'1','294',2,'Sale Id shift 198',0.00,2343650.20,820.00,2343650.20,0.00,'2023-01-02 10:47:19'),(277,'1','294',1,'Sale Id shift 198',0.00,859956.65,235.00,859956.65,0.00,'2023-01-02 10:47:19'),(278,'1','294',2,'Sale Id shift 199',0.00,4109003.60,820.00,4109003.60,0.00,'2023-01-02 12:58:08'),(279,'1','294',1,'Sale Id shift 199',0.00,2553820.20,235.00,2553820.20,0.00,'2023-01-02 12:58:08'),(280,'1','294',2,'Sale Id shift 200',0.00,3846513.40,820.00,3846513.40,0.00,'2023-01-03 13:16:23'),(281,'1','294',1,'Sale Id shift 200',0.00,1187690.00,235.00,1187690.00,0.00,'2023-01-03 13:16:23'),(282,'1','294',2,'Sale Id shift 201',0.00,4139663.40,820.00,4139663.40,0.00,'2023-01-04 10:31:55'),(283,'1','294',1,'Sale Id shift 201',0.00,2431582.60,235.00,2431582.60,0.00,'2023-01-04 10:31:55'),(284,'1','294',1,'Sale Id shift 202',0.00,2413048.15,235.00,2413048.15,0.00,'2023-01-04 12:13:42'),(285,'1','294',1,'Sale Id shift 203',0.00,1938529.10,235.00,1938529.10,0.00,'2023-01-05 20:22:16'),(286,'1','294',2,'Sale Id shift 204',0.00,1689109.80,820.00,1689109.80,0.00,'2023-01-07 14:44:16'),(287,'1','294',2,'Sale Id shift 205',0.00,4764429.60,820.00,4764429.60,0.00,'2023-01-08 09:59:08'),(288,'1','294',2,'Sale Id shift 206',0.00,2609190.80,820.00,2609190.80,0.00,'2023-01-09 09:36:20'),(289,'1','294',2,'Sale Id shift 207',0.00,3989947.80,820.00,3989947.80,0.00,'2023-01-09 11:32:59'),(290,'1','294',2,'Sale Id shift 208',0.00,3353340.80,820.00,3353340.80,0.00,'2023-01-09 17:03:04'),(291,'1','294',2,'Sale Id shift 209',0.00,106600.00,820.00,106600.00,0.00,'2023-01-10 09:50:40'),(292,'1','294',1,'Sale Id shift 210',0.00,2848888.55,235.00,2848888.55,0.00,'2023-01-10 14:37:24'),(293,'1','294',1,'Sale Id shift 211',0.00,2846618.45,235.00,2846618.45,0.00,'2023-01-11 10:14:46'),(294,'1','294',1,'Sale Id shift 212',0.00,2631280.90,235.00,2631280.90,0.00,'2023-01-12 12:25:48'),(295,'1','294',1,'Sale Id shift 213',0.00,3440397.65,235.00,3440397.65,0.00,'2023-01-12 15:20:17'),(296,'1','294',1,'Sale Id shift 214',0.00,3779070.25,235.00,3779070.25,0.00,'2023-01-13 10:38:05'),(297,'1','294',1,'Sale Id shift 215',0.00,3245237.20,235.00,3245237.20,0.00,'2023-01-13 21:50:53'),(298,'1','294',2,'Sale Id shift 216',0.00,1209008.00,820.00,1209008.00,0.00,'2023-01-14 17:38:51'),(299,'1','294',2,'Sale Id shift 217',0.00,2185013.00,820.00,2185013.00,0.00,'2023-01-15 12:29:44'),(300,'1','294',2,'Sale Id shift 218',0.00,3557570.00,820.00,3557570.00,0.00,'2023-01-15 13:57:13'),(301,'1','294',2,'Sale Id shift 219',0.00,4601134.80,820.00,4601134.80,0.00,'2023-01-16 09:18:36'),(302,'1','294',2,'Sale Id shift 220',0.00,2382116.40,820.00,2382116.40,0.00,'2023-01-16 12:54:54'),(303,'1','294',2,'Sale Id shift 221',0.00,3095172.00,820.00,3095172.00,0.00,'2023-01-16 14:59:37'),(304,'1','294',2,'Sale Id shift 222',0.00,5859055.80,820.00,5859055.80,0.00,'2023-01-17 11:53:09'),(305,'1','294',2,'Sale Id shift 223',0.00,3025521.20,820.00,3025521.20,0.00,'2023-01-17 19:40:59'),(306,'1','294',2,'Sale Id shift 224',0.00,4275652.20,820.00,4275652.20,0.00,'2023-01-18 12:34:17'),(307,'1','294',2,'Sale Id shift 225',0.00,1810163.70,810.00,1810163.70,0.00,'2023-01-18 14:23:26'),(308,'1','294',2,'Sale Id shift 226',0.00,1874178.00,810.00,1874178.00,0.00,'2023-01-18 18:53:09'),(309,'1','294',2,'Sale Id shift 227',0.00,5687439.30,810.00,5687439.30,0.00,'2023-01-19 14:31:25'),(310,'1','294',2,'Sale Id shift 228',0.00,3188532.60,810.00,3188532.60,0.00,'2023-01-19 16:48:02'),(311,'1','294',1,'Sale Id shift 228',0.00,4256207.20,235.00,4256207.20,0.00,'2023-01-19 16:48:02'),(312,'1','294',2,'Sale Id shift 229',0.00,6208155.90,810.00,6208155.90,0.00,'2023-01-20 09:46:54'),(313,'1','294',1,'Sale Id shift 230',0.00,74805.20,235.00,74805.20,0.00,'2023-01-22 11:11:04'),(314,'1','294',2,'Sale Id shift 231',0.00,609921.90,810.00,609921.90,0.00,'2023-01-22 12:31:50'),(315,'1','294',1,'Sale Id shift 231',0.00,4014448.60,235.00,4014448.60,0.00,'2023-01-22 12:31:50'),(316,'1','294',1,'Sale Id shift 232',0.00,5424570.80,235.00,5424570.80,0.00,'2023-01-22 21:22:39'),(317,'1','294',1,'Sale Id shift 233',0.00,289813.75,235.00,289813.75,0.00,'2023-01-22 21:35:05'),(318,'1','294',2,'Sale Id shift 234',0.00,1629888.50,790.00,1629888.50,0.00,'2023-01-28 15:04:59'),(319,'1','294',2,'Sale Id shift 235',0.00,4891387.70,790.00,4891387.70,0.00,'2023-01-29 14:33:30'),(320,'1','294',2,'Sale Id shift 236',0.00,864181.00,790.00,864181.00,0.00,'2023-01-29 18:53:42'),(321,'1','294',2,'Sale Id shift 237',0.00,2464760.50,790.00,2464760.50,0.00,'2023-01-30 10:53:05'),(322,'1','294',2,'Sale Id shift 238',0.00,3412681.50,790.00,3412681.50,0.00,'2023-01-30 16:03:19'),(323,'1','294',2,'Sale Id shift 239',0.00,342386.00,790.00,342386.00,0.00,'2023-01-30 21:24:01'),(324,'1','294',1,'Sale Id shift 240',0.00,5025972.50,250.00,5025972.50,0.00,'2023-01-31 22:31:13'),(325,'1','294',1,'Sale Id shift 241',0.00,2171995.00,250.00,2171995.00,0.00,'2023-02-01 09:34:08'),(326,'1','294',1,'Sale Id shift 242',0.00,302202.50,250.00,302202.50,0.00,'2023-02-02 12:52:53'),(327,'1','294',1,'Sale Id shift 243',0.00,3381892.00,200.00,3381892.00,0.00,'2023-02-07 19:55:45'),(328,'1','294',1,'Sale Id shift 244',0.00,3757350.00,200.00,3757350.00,0.00,'2023-02-08 17:14:58'),(329,'1','294',1,'Sale Id shift 245',0.00,2887488.00,200.00,2887488.00,0.00,'2023-02-08 21:10:46'),(330,'1','294',2,'Sale Id shift 246',0.00,1782824.00,800.00,1782824.00,0.00,'2023-02-10 12:01:45'),(331,'1','294',2,'Sale Id shift 247',0.00,2506424.00,800.00,2506424.00,0.00,'2023-02-10 15:21:56'),(332,'1','294',2,'Sale Id shift 248',0.00,3768064.00,800.00,3768064.00,0.00,'2023-02-11 09:27:29'),(333,'1','294',2,'Sale Id shift 249',0.00,4214000.00,800.00,4214000.00,0.00,'2023-02-11 15:26:49'),(334,'1','294',2,'Sale Id shift 250',0.00,4569368.00,800.00,4569368.00,0.00,'2023-02-12 13:54:55'),(335,'1','294',2,'Sale Id shift 251',0.00,1519608.00,800.00,1519608.00,0.00,'2023-02-12 13:59:37'),(336,'1','294',2,'Sale Id shift 252',0.00,2893392.00,800.00,2893392.00,0.00,'2023-02-13 14:44:14'),(337,'1','294',2,'Sale Id shift 253',0.00,830008.00,800.00,830008.00,0.00,'2023-02-13 19:16:15'),(338,'1','294',2,'Sale Id shift 254',0.00,2109016.00,800.00,2109016.00,0.00,'2023-02-14 15:29:50'),(339,'1','294',2,'Sale Id shift 255',0.00,2392608.00,800.00,2392608.00,0.00,'2023-02-14 23:19:55'),(340,'1','294',2,'Sale Id shift 256',0.00,2005168.00,800.00,2005168.00,0.00,'2023-02-15 14:35:49'),(341,'1','294',2,'Sale Id shift 257',0.00,3390520.00,800.00,3390520.00,0.00,'2023-02-15 15:44:38'),(342,'1','294',2,'Sale Id shift 258',0.00,2028176.00,800.00,2028176.00,0.00,'2023-02-16 11:53:54'),(343,'1','294',2,'Sale Id shift 259',0.00,2607872.00,800.00,2607872.00,0.00,'2023-02-17 08:18:40'),(344,'1','294',1,'Sale Id shift 259',0.00,3387140.00,200.00,3387140.00,0.00,'2023-02-17 08:18:40'),(345,'1','294',1,'Sale Id shift 260',0.00,3147986.00,200.00,3147986.00,0.00,'2023-02-18 14:35:15'),(346,'1','294',1,'Sale Id shift 261',0.00,2192340.00,200.00,2192340.00,0.00,'2023-02-18 21:41:10'),(347,'1','294',1,'Sale Id shift 262',0.00,3176530.00,200.00,3176530.00,0.00,'2023-02-19 21:27:26'),(348,'1','294',2,'Sale Id shift 263',0.00,2504064.00,800.00,2504064.00,0.00,'2023-02-21 15:36:04'),(349,'1','294',1,'Sale Id shift 263',0.00,3227746.00,200.00,3227746.00,0.00,'2023-02-21 15:36:04'),(350,'1','294',2,'Sale Id shift 264',0.00,3079120.00,800.00,3079120.00,0.00,'2023-02-22 12:25:35'),(351,'1','294',1,'Sale Id shift 264',0.00,3634622.00,200.00,3634622.00,0.00,'2023-02-22 12:25:35'),(352,'1','294',2,'Sale Id shift 265',0.00,2196192.00,800.00,2196192.00,0.00,'2023-02-23 16:10:56'),(353,'1','294',1,'Sale Id shift 265',0.00,4768852.00,200.00,4768852.00,0.00,'2023-02-23 16:10:56'),(354,'1','294',2,'Sale Id shift 266',0.00,1864128.00,800.00,1864128.00,0.00,'2023-02-24 15:28:14'),(355,'1','294',1,'Sale Id shift 266',0.00,1687422.00,200.00,1687422.00,0.00,'2023-02-24 15:28:14'),(356,'1','294',2,'Sale Id shift 267',0.00,3202960.00,800.00,3202960.00,0.00,'2023-02-25 20:39:50'),(357,'1','294',1,'Sale Id shift 267',0.00,1861906.00,200.00,1861906.00,0.00,'2023-02-25 20:39:50'),(358,'1','294',2,'Sale Id shift 268',0.00,1178400.00,800.00,1178400.00,0.00,'2023-02-26 10:53:18'),(359,'1','294',1,'Sale Id shift 268',0.00,531600.00,200.00,531600.00,0.00,'2023-02-26 10:53:18'),(360,'1','294',2,'Sale Id shift 269',0.00,558104.00,800.00,558104.00,0.00,'2023-02-27 15:50:50'),(361,'1','294',1,'Sale Id shift 269',0.00,1923716.00,200.00,1923716.00,0.00,'2023-02-27 15:50:50'),(362,'1','294',2,'Sale Id shift 270',0.00,304152.00,800.00,304152.00,0.00,'2023-02-27 20:08:51'),(363,'1','294',1,'Sale Id shift 270',0.00,2333060.00,200.00,2333060.00,0.00,'2023-02-27 20:08:51'),(364,'1','294',2,'Sale Id shift 271',0.00,126008.00,800.00,126008.00,0.00,'2023-02-28 14:12:43'),(365,'1','294',1,'Sale Id shift 271',0.00,2016912.00,200.00,2016912.00,0.00,'2023-02-28 14:12:43'),(366,'1','294',2,'Sale Id shift 272',0.00,780288.00,800.00,780288.00,0.00,'2023-02-28 17:08:27'),(367,'1','294',1,'Sale Id shift 272',0.00,2814770.00,200.00,2814770.00,0.00,'2023-02-28 17:08:27'),(368,'1','294',2,'Sale Id shift 273',0.00,390784.00,800.00,390784.00,0.00,'2023-02-28 22:33:18'),(369,'1','294',1,'Sale Id shift 273',0.00,732654.00,200.00,732654.00,0.00,'2023-02-28 22:33:18'),(370,'1','294',1,'Sale Id shift 274',0.00,2888652.00,200.00,2888652.00,0.00,'2023-03-03 20:54:45'),(371,'1','294',1,'Sale Id shift 275',0.00,1078696.00,200.00,1078696.00,0.00,'2023-03-04 10:07:19'),(372,'1','294',2,'Sale Id shift 276',0.00,769624.00,800.00,769624.00,0.00,'2023-03-04 17:55:12'),(373,'1','294',1,'Sale Id shift 276',0.00,1921572.00,200.00,1921572.00,0.00,'2023-03-04 17:55:12'),(374,'1','294',2,'Sale Id shift 277',0.00,2192208.00,800.00,2192208.00,0.00,'2023-03-05 14:27:00'),(375,'1','294',2,'Sale Id shift 278',0.00,1416800.00,800.00,1416800.00,0.00,'2023-03-05 16:09:26'),(376,'1','294',2,'Sale Id shift 279',0.00,2252240.00,800.00,2252240.00,0.00,'2023-03-06 11:44:30'),(377,'1','294',2,'Sale Id shift 280',0.00,1326808.00,800.00,1326808.00,0.00,'2023-03-06 21:05:34'),(378,'1','294',2,'Sale Id shift 281',0.00,2610632.00,800.00,2610632.00,0.00,'2023-03-06 22:22:48'),(379,'1','294',2,'Sale Id shift 282',0.00,1344912.00,800.00,1344912.00,0.00,'2023-03-07 18:18:17'),(380,'1','294',2,'Sale Id shift 283',0.00,1965896.00,800.00,1965896.00,0.00,'2023-03-08 17:49:28'),(381,'1','294',2,'Sale Id shift 284',0.00,1116920.00,800.00,1116920.00,0.00,'2023-03-09 02:10:56'),(382,'1','294',2,'Sale Id shift 285',0.00,3766240.00,800.00,3766240.00,0.00,'2023-03-09 07:59:39'),(383,'1','294',2,'Sale Id shift 286',0.00,1958704.00,800.00,1958704.00,0.00,'2023-03-09 19:05:20'),(384,'1','294',1,'Sale Id shift 286',0.00,1676516.00,200.00,1676516.00,0.00,'2023-03-09 19:05:20'),(385,'1','294',2,'Sale Id shift 287',0.00,3768648.00,800.00,3768648.00,0.00,'2023-03-10 10:44:23'),(386,'1','294',1,'Sale Id shift 287',0.00,2989310.00,200.00,2989310.00,0.00,'2023-03-10 10:44:23'),(387,'1','294',2,'Sale Id shift 288',0.00,2268240.00,800.00,2268240.00,0.00,'2023-03-10 21:50:01'),(388,'1','294',1,'Sale Id shift 288',0.00,1980632.00,200.00,1980632.00,0.00,'2023-03-10 21:50:01'),(389,'1','294',1,'Sale Id shift 289',0.00,911822.00,200.00,911822.00,0.00,'2023-03-11 15:37:10'),(390,'1','294',1,'Sale Id shift 290',0.00,2387444.00,200.00,2387444.00,0.00,'2023-03-11 22:18:21'),(391,'1','294',1,'Sale Id shift 291',0.00,2381510.00,200.00,2381510.00,0.00,'2023-03-12 18:34:20'),(392,'1','294',1,'Sale Id shift 292',0.00,1924496.00,200.00,1924496.00,0.00,'2023-03-13 15:20:08'),(393,'1','294',1,'Sale Id shift 293',0.00,2053312.00,200.00,2053312.00,0.00,'2023-03-13 17:22:58'),(394,'1','294',1,'Sale Id shift 294',0.00,1323260.00,200.00,1323260.00,0.00,'2023-03-13 22:55:42'),(395,'1','294',2,'Sale Id shift 295',0.00,901792.00,800.00,901792.00,0.00,'2023-03-14 18:45:27'),(396,'1','294',1,'Sale Id shift 295',0.00,3006480.00,200.00,3006480.00,0.00,'2023-03-14 18:45:27'),(397,'1','294',2,'Sale Id shift 296',0.00,3070656.00,800.00,3070656.00,0.00,'2023-03-14 22:11:07'),(398,'1','294',1,'Sale Id shift 296',0.00,1564014.00,200.00,1564014.00,0.00,'2023-03-14 22:11:07'),(399,'1','294',2,'Sale Id shift 297',0.00,2651512.00,800.00,2651512.00,0.00,'2023-03-15 16:28:17'),(400,'1','294',1,'Sale Id shift 297',0.00,1699570.00,200.00,1699570.00,0.00,'2023-03-15 16:28:17'),(401,'1','294',2,'Sale Id shift 298',0.00,3689504.00,800.00,3689504.00,0.00,'2023-03-16 08:31:35'),(402,'1','294',2,'Sale Id shift 299',0.00,1523400.00,800.00,1523400.00,0.00,'2023-03-16 14:59:56'),(403,'1','294',2,'Sale Id shift 300',0.00,289696.00,800.00,289696.00,0.00,'2023-03-16 21:05:20'),(404,'1','294',1,'Sale Id shift 301',0.00,4321876.00,200.00,4321876.00,0.00,'2023-03-19 15:27:07'),(405,'1','294',1,'Sale Id shift 302',0.00,1696684.00,200.00,1696684.00,0.00,'2023-03-19 16:25:55'),(406,'1','294',1,'Sale Id shift 303',0.00,2908778.00,200.00,2908778.00,0.00,'2023-03-19 16:35:58'),(407,'1','294',2,'Sale Id shift 304',0.00,742504.00,800.00,742504.00,0.00,'2023-03-20 15:18:09');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=1777 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('1','294',1,'','24','2',0.00,8750000.00,'Purchase Id 1 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-10-25 14:28:05','',''),('1','294',2,'','supplier','1',8750000.00,0.00,'Purchase Id 1 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-10-25 14:28:05','',''),('1','294',3,'','24','2',0.00,33975000.00,'Purchase Id 2 for 45,000.00 litters of Diesel - AGO from AA RANO NIGERIA LTD','2022-10-25 14:29:00','',''),('1','294',4,'','supplier','1',33975000.00,0.00,'Purchase Id 2 for 45,000.00 litters of Diesel - AGO from AA RANO NIGERIA LTD','2022-10-25 14:29:00','',''),('1','294',5,'','24','2',0.00,7875000.00,'Purchase Id 3 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-10-25 14:30:19','',''),('1','294',6,'','supplier','1',7875000.00,0.00,'Purchase Id 3 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-10-25 14:30:19','',''),('1','294',7,'','20','4',114045.75,0.00,'Sales from shift 1 on 2022-10-26 12:07:01 ','2022-10-26 12:07:01','',''),('1','294',8,'','6.1','1',0.00,114045.75,'Sales from shift 1 on 2022-10-26 12:07:01 ','2022-10-26 12:07:01','',''),('1','294',9,'','20','4',1546125.55,0.00,'Sales from shift 2 on 2022-10-26 12:23:47 ','2022-10-26 12:23:47','',''),('1','294',10,'','6.1','1',0.00,1546125.55,'Sales from shift 2 on 2022-10-26 12:23:47 ','2022-10-26 12:23:47','',''),('1','294',11,'','20','4',402039.85,0.00,'Sales from shift 3 on 2022-10-26 13:54:57 ','2022-10-26 13:54:57','',''),('1','294',12,'','6.1','1',0.00,402039.85,'Sales from shift 3 on 2022-10-26 13:54:57 ','2022-10-26 13:54:57','',''),('1','294',13,'','20','4',2784328.85,0.00,'Sales from shift 4 on 2022-10-26 14:28:54 ','2022-10-26 14:28:54','',''),('1','294',14,'','6.1','1',0.00,2784328.85,'Sales from shift 4 on 2022-10-26 14:28:54 ','2022-10-26 14:28:54','',''),('1','294',15,'','20','4',395090.40,0.00,'Sales from shift 5 on 2022-10-26 14:43:05 ','2022-10-26 14:43:05','',''),('1','294',16,'','6.1','1',0.00,395090.40,'Sales from shift 5 on 2022-10-26 14:43:05 ','2022-10-26 14:43:05','',''),('1','294',17,'','20','4',-7875.00,0.00,'Sales from shift 6 on 2022-10-26 15:02:05 ','2022-10-26 15:02:05','',''),('1','294',18,'','6.1','1',0.00,-7875.00,'Sales from shift 6 on 2022-10-26 15:02:05 ','2022-10-26 15:02:05','',''),('1','294',19,'','20','4',4026317.25,0.00,'Sales from shift 7 on 2022-10-26 15:31:07 ','2022-10-26 15:31:07','',''),('1','294',20,'','6.1','1',0.00,4026317.25,'Sales from shift 7 on 2022-10-26 15:31:07 ','2022-10-26 15:31:07','',''),('1','294',21,'','20','4',255150.00,0.00,'Sales from shift 8 on 2022-10-26 16:02:47 ','2022-10-26 16:02:47','',''),('1','294',22,'','6.1','1',0.00,255150.00,'Sales from shift 8 on 2022-10-26 16:02:47 ','2022-10-26 16:02:47','',''),('1','294',23,'','20','4',3525038.65,0.00,'Sales from shift 9 on 2022-10-26 17:12:11 ','2022-10-26 17:12:11','',''),('1','294',24,'','6.1','1',0.00,3525038.65,'Sales from shift 9 on 2022-10-26 17:12:11 ','2022-10-26 17:12:11','',''),('1','294',25,'','20','4',752171.15,0.00,'Sales from shift 10 on 2022-10-27 10:52:18 ','2022-10-27 10:52:18','',''),('1','294',26,'','6.1','1',0.00,752171.15,'Sales from shift 10 on 2022-10-27 10:52:18 ','2022-10-27 10:52:18','',''),('1','294',27,'','20','4',1512004.45,0.00,'Sales from shift 11 on 2022-10-27 10:59:58 ','2022-10-27 10:59:58','',''),('1','294',28,'','6.1','1',0.00,1512004.45,'Sales from shift 11 on 2022-10-27 10:59:58 ','2022-10-27 10:59:58','',''),('1','294',29,'','20','4',1520849.30,0.00,'Sales from shift 12 on 2022-10-27 11:25:30 ','2022-10-27 11:25:30','',''),('1','294',30,'','6.1','1',0.00,1520849.30,'Sales from shift 12 on 2022-10-27 11:25:30 ','2022-10-27 11:25:30','',''),('1','294',31,'','20','4',1497052.55,0.00,'Sales from shift 13 on 2022-10-27 11:34:46 ','2022-10-27 11:34:46','',''),('1','294',32,'','6.1','1',0.00,1497052.55,'Sales from shift 13 on 2022-10-27 11:34:46 ','2022-10-27 11:34:46','',''),('1','294',33,'','20','4',1579752.10,0.00,'Sales from shift 14 on 2022-10-27 11:48:37 ','2022-10-27 11:48:37','',''),('1','294',34,'','6.1','1',0.00,1579752.10,'Sales from shift 14 on 2022-10-27 11:48:37 ','2022-10-27 11:48:37','',''),('1','294',35,'','20','4',1535666.20,0.00,'Sales from shift 15 on 2022-10-27 11:55:51 ','2022-10-27 11:55:51','',''),('1','294',36,'','6.1','1',0.00,1535666.20,'Sales from shift 15 on 2022-10-27 11:55:51 ','2022-10-27 11:55:51','',''),('1','294',37,'','20','4',2059120.15,0.00,'Sales from shift 16 on 2022-10-27 12:01:17 ','2022-10-27 12:01:17','',''),('1','294',38,'','6.1','1',0.00,2059120.15,'Sales from shift 16 on 2022-10-27 12:01:17 ','2022-10-27 12:01:17','',''),('1','294',39,'','20','4',1851911.85,0.00,'Sales from shift 17 on 2022-10-27 12:11:06 ','2022-10-27 12:11:06','',''),('1','294',40,'','6.1','1',0.00,1851911.85,'Sales from shift 17 on 2022-10-27 12:11:06 ','2022-10-27 12:11:06','',''),('1','294',41,'','20','4',2727792.65,0.00,'Sales from shift 18 on 2022-10-27 12:17:02 ','2022-10-27 12:17:02','',''),('1','294',42,'','6.1','1',0.00,2727792.65,'Sales from shift 18 on 2022-10-27 12:17:02 ','2022-10-27 12:17:02','',''),('1','294',43,'','20','4',1709401.10,0.00,'Sales from shift 19 on 2022-10-27 12:21:28 ','2022-10-27 12:21:28','',''),('1','294',44,'','6.1','1',0.00,1709401.10,'Sales from shift 19 on 2022-10-27 12:21:28 ','2022-10-27 12:21:28','',''),('1','294',45,'','20','4',2748481.20,0.00,'Sales from shift 20 on 2022-10-27 12:27:40 ','2022-10-27 12:27:40','',''),('1','294',46,'','6.1','1',0.00,2748481.20,'Sales from shift 20 on 2022-10-27 12:27:40 ','2022-10-27 12:27:40','',''),('1','294',47,'','20','4',1385366.25,0.00,'Sales from shift 21 on 2022-10-27 12:31:32 ','2022-10-27 12:31:32','',''),('1','294',48,'','6.1','1',0.00,1385366.25,'Sales from shift 21 on 2022-10-27 12:31:32 ','2022-10-27 12:31:32','',''),('1','294',49,'','20','4',2112013.45,0.00,'Sales from shift 22 on 2022-10-27 12:38:49 ','2022-10-27 12:38:49','',''),('1','294',50,'','6.1','1',0.00,2112013.45,'Sales from shift 22 on 2022-10-27 12:38:49 ','2022-10-27 12:38:49','',''),('1','294',51,'','20','4',1374905.00,0.00,'Sales from shift 23 on 2022-10-27 12:45:37 ','2022-10-27 12:45:37','',''),('1','294',52,'','6.1','1',0.00,1374905.00,'Sales from shift 23 on 2022-10-27 12:45:37 ','2022-10-27 12:45:37','',''),('1','294',53,'','24','2',0.00,10500000.00,'Purchase Id 4 for 60,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-10-27 12:47:52','',''),('1','294',54,'','supplier','1',10500000.00,0.00,'Purchase Id 4 for 60,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-10-27 12:47:52','',''),('1','294',55,'','24','2',0.00,8750000.00,'Purchase Id 5 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-10-27 12:48:50','',''),('1','294',56,'','supplier','1',8750000.00,0.00,'Purchase Id 5 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-10-27 12:48:50','',''),('1','294',57,'','20','4',1653843.75,0.00,'Sales from shift 24 on 2022-10-27 14:59:54 ','2022-10-27 14:59:54','',''),('1','294',58,'','6.1','1',0.00,1653843.75,'Sales from shift 24 on 2022-10-27 14:59:54 ','2022-10-27 14:59:54','',''),('1','294',59,'','20','4',1786133.75,0.00,'Sales from shift 25 on 2022-10-27 15:11:28 ','2022-10-27 15:11:28','',''),('1','294',60,'','6.1','1',0.00,1786133.75,'Sales from shift 25 on 2022-10-27 15:11:28 ','2022-10-27 15:11:28','',''),('1','294',61,'','20','4',1510886.35,0.00,'Sales from shift 26 on 2022-10-27 15:19:36 ','2022-10-27 15:19:36','',''),('1','294',62,'','6.1','1',0.00,1510886.35,'Sales from shift 26 on 2022-10-27 15:19:36 ','2022-10-27 15:19:36','',''),('1','294',63,'','20','4',1454330.80,0.00,'Sales from shift 27 on 2022-10-27 15:24:53 ','2022-10-27 15:24:53','',''),('1','294',64,'','6.1','1',0.00,1454330.80,'Sales from shift 27 on 2022-10-27 15:24:53 ','2022-10-27 15:24:53','',''),('1','294',65,'','20','4',2571698.80,0.00,'Sales from shift 28 on 2022-10-27 15:31:09 ','2022-10-27 15:31:09','',''),('1','294',66,'','6.1','1',0.00,2571698.80,'Sales from shift 28 on 2022-10-27 15:31:09 ','2022-10-27 15:31:09','',''),('1','294',67,'','20','4',1193945.30,0.00,'Sales from shift 29 on 2022-10-27 15:37:34 ','2022-10-27 15:37:34','',''),('1','294',68,'','6.1','1',0.00,1193945.30,'Sales from shift 29 on 2022-10-27 15:37:34 ','2022-10-27 15:37:34','',''),('1','294',69,'','20','4',1894361.20,0.00,'Sales from shift 30 on 2022-10-27 16:00:26 ','2022-10-27 16:00:26','',''),('1','294',70,'','6.1','1',0.00,1894361.20,'Sales from shift 30 on 2022-10-27 16:00:26 ','2022-10-27 16:00:26','',''),('1','294',71,'','20','4',2087351.40,0.00,'Sales from shift 31 on 2022-10-27 16:28:12 ','2022-10-27 16:28:12','',''),('1','294',72,'','6.1','1',0.00,2087351.40,'Sales from shift 31 on 2022-10-27 16:28:12 ','2022-10-27 16:28:12','',''),('1','294',73,'','20','4',1975065.45,0.00,'Sales from shift 32 on 2022-10-27 16:39:10 ','2022-10-27 16:39:10','',''),('1','294',74,'','6.1','1',0.00,1975065.45,'Sales from shift 32 on 2022-10-27 16:39:10 ','2022-10-27 16:39:10','',''),('1','294',75,'','20','4',2151624.10,0.00,'Sales from shift 33 on 2022-10-27 16:47:16 ','2022-10-27 16:47:16','',''),('1','294',76,'','6.1','1',0.00,2151624.10,'Sales from shift 33 on 2022-10-27 16:47:16 ','2022-10-27 16:47:16','',''),('1','294',77,'','20','4',2620561.80,0.00,'Sales from shift 34 on 2022-10-27 16:53:52 ','2022-10-27 16:53:52','',''),('1','294',78,'','6.1','1',0.00,2620561.80,'Sales from shift 34 on 2022-10-27 16:53:52 ','2022-10-27 16:53:52','',''),('1','294',79,'','20','4',1499288.10,0.00,'Sales from shift 35 on 2022-10-27 17:01:45 ','2022-10-27 17:01:45','',''),('1','294',80,'','6.1','1',0.00,1499288.10,'Sales from shift 35 on 2022-10-27 17:01:45 ','2022-10-27 17:01:45','',''),('1','294',81,'','20','4',2655817.65,0.00,'Sales from shift 36 on 2022-10-27 17:08:46 ','2022-10-27 17:08:46','',''),('1','294',82,'','6.1','1',0.00,2655817.65,'Sales from shift 36 on 2022-10-27 17:08:46 ','2022-10-27 17:08:46','',''),('1','294',83,'','20','4',1544157.75,0.00,'Sales from shift 37 on 2022-10-27 17:21:11 ','2022-10-27 17:21:11','',''),('1','294',84,'','6.1','1',0.00,1544157.75,'Sales from shift 37 on 2022-10-27 17:21:11 ','2022-10-27 17:21:11','',''),('1','294',85,'','20','4',2874975.55,0.00,'Sales from shift 38 on 2022-10-27 17:26:20 ','2022-10-27 17:26:20','',''),('1','294',86,'','6.1','1',0.00,2874975.55,'Sales from shift 38 on 2022-10-27 17:26:20 ','2022-10-27 17:26:20','',''),('1','294',87,'','20','4',2025114.80,0.00,'Sales from shift 39 on 2022-10-27 17:29:42 ','2022-10-27 17:29:42','',''),('1','294',88,'','6.1','1',0.00,2025114.80,'Sales from shift 39 on 2022-10-27 17:29:42 ','2022-10-27 17:29:42','',''),('1','294',89,'','20','4',2367027.10,0.00,'Sales from shift 40 on 2022-10-27 17:32:55 ','2022-10-27 17:32:55','',''),('1','294',90,'','6.1','1',0.00,2367027.10,'Sales from shift 40 on 2022-10-27 17:32:55 ','2022-10-27 17:32:55','',''),('1','294',91,'','20','4',2167299.40,0.00,'Sales from shift 41 on 2022-10-28 16:54:18 ','2022-10-28 16:54:18','',''),('1','294',92,'','6.1','1',0.00,2167299.40,'Sales from shift 41 on 2022-10-28 16:54:18 ','2022-10-28 16:54:18','',''),('1','294',93,'','20','4',3274185.00,0.00,'Sales from shift 42 on 2022-10-28 17:00:34 ','2022-10-28 17:00:34','',''),('1','294',94,'','6.1','1',0.00,3274185.00,'Sales from shift 42 on 2022-10-28 17:00:34 ','2022-10-28 17:00:34','',''),('1','294',95,'','20','4',658699.60,0.00,'Sales from shift 43 on 2022-10-28 17:05:43 ','2022-10-28 17:05:43','',''),('1','294',96,'','6.1','1',0.00,658699.60,'Sales from shift 43 on 2022-10-28 17:05:43 ','2022-10-28 17:05:43','',''),('1','294',97,'','20','4',970627.00,0.00,'Sales from shift 44 on 2022-10-28 17:11:19 ','2022-10-28 17:11:19','',''),('1','294',98,'','6.1','1',0.00,970627.00,'Sales from shift 44 on 2022-10-28 17:11:19 ','2022-10-28 17:11:19','',''),('1','294',99,'','20','4',435341.72,0.00,'Sales from shift 45 on 2022-10-28 17:28:48 ','2022-10-28 17:28:48','',''),('1','294',100,'','6.1','1',0.00,435341.72,'Sales from shift 45 on 2022-10-28 17:28:48 ','2022-10-28 17:28:48','',''),('1','294',101,'','20','4',1971428.32,0.00,'Sales from shift 46 on 2022-10-28 17:42:21 ','2022-10-28 17:42:21','',''),('1','294',102,'','6.1','1',0.00,1971428.32,'Sales from shift 46 on 2022-10-28 17:42:21 ','2022-10-28 17:42:21','',''),('1','294',103,'','20','4',1409021.30,0.00,'Sales from shift 47 on 2022-10-28 18:17:10 ','2022-10-28 18:17:10','',''),('1','294',104,'','6.1','1',0.00,1409021.30,'Sales from shift 47 on 2022-10-28 18:17:10 ','2022-10-28 18:17:10','',''),('1','294',105,'','20','4',1705247.12,0.00,'Sales from shift 48 on 2022-10-29 11:23:06 ','2022-10-29 11:23:06','',''),('1','294',106,'','6.1','1',0.00,1705247.12,'Sales from shift 48 on 2022-10-29 11:23:06 ','2022-10-29 11:23:06','',''),('1','294',107,'','20','4',1189768.02,0.00,'Sales from shift 49 on 2022-10-29 11:26:28 ','2022-10-29 11:26:28','',''),('1','294',108,'','6.1','1',0.00,1189768.02,'Sales from shift 49 on 2022-10-29 11:26:28 ','2022-10-29 11:26:28','',''),('1','294',109,'','20','4',1492108.14,0.00,'Sales from shift 50 on 2022-10-29 11:30:20 ','2022-10-29 11:30:20','',''),('1','294',110,'','6.1','1',0.00,1492108.14,'Sales from shift 50 on 2022-10-29 11:30:20 ','2022-10-29 11:30:20','',''),('1','294',111,'','20','4',1170766.52,0.00,'Sales from shift 51 on 2022-10-29 11:33:09 ','2022-10-29 11:33:09','',''),('1','294',112,'','6.1','1',0.00,1170766.52,'Sales from shift 51 on 2022-10-29 11:33:09 ','2022-10-29 11:33:09','',''),('1','294',113,'','20','4',1532136.78,0.00,'Sales from shift 52 on 2022-10-29 11:41:02 ','2022-10-29 11:41:02','',''),('1','294',114,'','6.1','1',0.00,1532136.78,'Sales from shift 52 on 2022-10-29 11:41:02 ','2022-10-29 11:41:02','',''),('1','294',115,'','20','4',1307239.12,0.00,'Sales from shift 53 on 2022-10-29 11:44:04 ','2022-10-29 11:44:04','',''),('1','294',116,'','6.1','1',0.00,1307239.12,'Sales from shift 53 on 2022-10-29 11:44:04 ','2022-10-29 11:44:04','',''),('1','294',117,'','20','4',1487341.30,0.00,'Sales from shift 54 on 2022-10-29 11:48:02 ','2022-10-29 11:48:02','',''),('1','294',118,'','6.1','1',0.00,1487341.30,'Sales from shift 54 on 2022-10-29 11:48:02 ','2022-10-29 11:48:02','',''),('1','294',119,'','20','4',2634304.26,0.00,'Sales from shift 55 on 2022-10-29 11:52:17 ','2022-10-29 11:52:17','',''),('1','294',120,'','6.1','1',0.00,2634304.26,'Sales from shift 55 on 2022-10-29 11:52:17 ','2022-10-29 11:52:17','',''),('1','294',121,'','20','4',2837673.00,0.00,'Sales from shift 56 on 2022-10-29 11:55:40 ','2022-10-29 11:55:40','',''),('1','294',122,'','6.1','1',0.00,2837673.00,'Sales from shift 56 on 2022-10-29 11:55:40 ','2022-10-29 11:55:40','',''),('1','294',123,'','20','4',1402548.58,0.00,'Sales from shift 57 on 2022-10-29 12:12:05 ','2022-10-29 12:12:05','',''),('1','294',124,'','6.1','1',0.00,1402548.58,'Sales from shift 57 on 2022-10-29 12:12:05 ','2022-10-29 12:12:05','',''),('1','294',125,'','20','4',443016.60,0.00,'Sales from shift 58 on 2022-10-29 12:14:52 ','2022-10-29 12:14:52','',''),('1','294',126,'','6.1','1',0.00,443016.60,'Sales from shift 58 on 2022-10-29 12:14:52 ','2022-10-29 12:14:52','',''),('1','294',127,'','20','4',2593333.74,0.00,'Sales from shift 59 on 2022-10-29 12:17:37 ','2022-10-29 12:17:37','',''),('1','294',128,'','6.1','1',0.00,2593333.74,'Sales from shift 59 on 2022-10-29 12:17:37 ','2022-10-29 12:17:37','',''),('1','294',129,'','20','4',1633617.52,0.00,'Sales from shift 60 on 2022-10-29 12:24:10 ','2022-10-29 12:24:10','',''),('1','294',130,'','6.1','1',0.00,1633617.52,'Sales from shift 60 on 2022-10-29 12:24:10 ','2022-10-29 12:24:10','',''),('1','294',131,'','20','4',3603093.28,0.00,'Sales from shift 61 on 2022-10-29 12:28:18 ','2022-10-29 12:28:18','',''),('1','294',132,'','6.1','1',0.00,3603093.28,'Sales from shift 61 on 2022-10-29 12:28:18 ','2022-10-29 12:28:18','',''),('1','294',133,'','24','2',0.00,8400000.00,'Purchase Id 6 for 48,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-10-29 12:29:20','',''),('1','294',134,'','supplier','1',8400000.00,0.00,'Purchase Id 6 for 48,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-10-29 12:29:20','',''),('1','294',135,'','24','2',0.00,10500000.00,'Purchase Id 7 for 60,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-10-29 12:29:34','',''),('1','294',136,'','supplier','1',10500000.00,0.00,'Purchase Id 7 for 60,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-10-29 12:29:34','',''),('1','294',137,'','20','4',0.00,0.00,'Sales from shift 62 on 2022-10-29 12:32:47 ','2022-10-29 12:32:47','',''),('1','294',138,'','6.1','1',0.00,0.00,'Sales from shift 62 on 2022-10-29 12:32:47 ','2022-10-29 12:32:47','',''),('1','294',139,'','20','4',2116803.80,0.00,'Sales from shift 63 on 2022-10-29 12:36:17 ','2022-10-29 12:36:17','',''),('1','294',140,'','6.1','1',0.00,2116803.80,'Sales from shift 63 on 2022-10-29 12:36:17 ','2022-10-29 12:36:17','',''),('1','294',141,'','20','4',2043834.40,0.00,'Sales from shift 64 on 2022-10-29 12:39:23 ','2022-10-29 12:39:23','',''),('1','294',142,'','6.1','1',0.00,2043834.40,'Sales from shift 64 on 2022-10-29 12:39:23 ','2022-10-29 12:39:23','',''),('1','294',143,'','20','4',1489612.80,0.00,'Sales from shift 65 on 2022-10-29 12:42:29 ','2022-10-29 12:42:29','',''),('1','294',144,'','6.1','1',0.00,1489612.80,'Sales from shift 65 on 2022-10-29 12:42:29 ','2022-10-29 12:42:29','',''),('1','294',145,'','20','4',1140562.80,0.00,'Sales from shift 66 on 2022-10-29 12:44:02 ','2022-10-29 12:44:02','',''),('1','294',146,'','6.1','1',0.00,1140562.80,'Sales from shift 66 on 2022-10-29 12:44:02 ','2022-10-29 12:44:02','',''),('1','294',147,'','20','4',180000.60,0.00,'Sales from shift 67 on 2022-10-29 12:45:39 ','2022-10-29 12:45:39','',''),('1','294',148,'','6.1','1',0.00,180000.60,'Sales from shift 67 on 2022-10-29 12:45:39 ','2022-10-29 12:45:39','',''),('1','294',149,'','20','4',1476202.50,0.00,'Sales from shift 68 on 2022-10-29 12:49:45 ','2022-10-29 12:49:45','',''),('1','294',150,'','6.1','1',0.00,1476202.50,'Sales from shift 68 on 2022-10-29 12:49:45 ','2022-10-29 12:49:45','',''),('1','294',151,'','20','4',1270150.56,0.00,'Sales from shift 69 on 2022-10-29 12:52:39 ','2022-10-29 12:52:39','',''),('1','294',152,'','6.1','1',0.00,1270150.56,'Sales from shift 69 on 2022-10-29 12:52:39 ','2022-10-29 12:52:39','',''),('1','294',153,'','20','4',2811401.60,0.00,'Sales from shift 70 on 2022-10-29 13:03:01 ','2022-10-29 13:03:01','',''),('1','294',154,'','6.1','1',0.00,2811401.60,'Sales from shift 70 on 2022-10-29 13:03:01 ','2022-10-29 13:03:01','',''),('1','294',155,'','20','4',1607366.24,0.00,'Sales from shift 71 on 2022-10-29 14:50:27 ','2022-10-29 14:50:27','',''),('1','294',156,'','6.1','1',0.00,1607366.24,'Sales from shift 71 on 2022-10-29 14:50:27 ','2022-10-29 14:50:27','',''),('1','294',157,'','20','4',1768233.48,0.00,'Sales from shift 72 on 2022-10-29 15:13:12 ','2022-10-29 15:13:12','',''),('1','294',158,'','6.1','1',0.00,1768233.48,'Sales from shift 72 on 2022-10-29 15:13:12 ','2022-10-29 15:13:12','',''),('1','294',159,'','20','4',1177525.18,0.00,'Sales from shift 73 on 2022-10-29 15:15:56 ','2022-10-29 15:15:56','',''),('1','294',160,'','6.1','1',0.00,1177525.18,'Sales from shift 73 on 2022-10-29 15:15:56 ','2022-10-29 15:15:56','',''),('1','294',161,'','20','4',1423786.40,0.00,'Sales from shift 74 on 2022-10-29 15:21:07 ','2022-10-29 15:21:07','',''),('1','294',162,'','6.1','1',0.00,1423786.40,'Sales from shift 74 on 2022-10-29 15:21:07 ','2022-10-29 15:21:07','',''),('1','294',163,'','20','4',1136976.78,0.00,'Sales from shift 75 on 2022-10-29 15:23:31 ','2022-10-29 15:23:31','',''),('1','294',164,'','6.1','1',0.00,1136976.78,'Sales from shift 75 on 2022-10-29 15:23:31 ','2022-10-29 15:23:31','',''),('1','294',165,'','24','2',0.00,10680000.00,'Purchase Id 8 for 60,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-10-29 15:23:53','',''),('1','294',166,'','supplier','1',10680000.00,0.00,'Purchase Id 8 for 60,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-10-29 15:23:53','',''),('1','294',167,'','24','2',0.00,15785000.00,'Purchase Id 9 for 20,500.00 litters of Diesel - AGO from AA RANO NIGERIA LTD','2022-10-29 15:24:17','',''),('1','294',168,'','supplier','1',15785000.00,0.00,'Purchase Id 9 for 20,500.00 litters of Diesel - AGO from AA RANO NIGERIA LTD','2022-10-29 15:24:17','',''),('1','294',169,'','24','2',0.00,2598800.00,'Purchase Id 10 for 14,600.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-10-29 15:24:35','',''),('1','294',170,'','supplier','1',2598800.00,0.00,'Purchase Id 10 for 14,600.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-10-29 15:24:35','',''),('1','294',171,'','24','2',0.00,10680000.00,'Purchase Id 11 for 60,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-10-29 15:25:04','',''),('1','294',172,'','supplier','1',10680000.00,0.00,'Purchase Id 11 for 60,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-10-29 15:25:04','',''),('1','294',173,'','20','4',1059069.74,0.00,'Sales from shift 76 on 2022-10-29 15:25:24 ','2022-10-29 15:25:24','',''),('1','294',174,'','6.1','1',0.00,1059069.74,'Sales from shift 76 on 2022-10-29 15:25:24 ','2022-10-29 15:25:24','',''),('1','294',175,'','24','2',0.00,10680000.00,'Purchase Id 12 for 60,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-10-29 15:25:46','',''),('1','294',176,'','supplier','1',10680000.00,0.00,'Purchase Id 12 for 60,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-10-29 15:25:46','',''),('1','294',177,'','24','2',0.00,23200000.00,'Purchase Id 13 for 29,000.00 litters of Diesel - AGO from AA RANO NIGERIA LTD','2022-10-29 15:26:03','',''),('1','294',178,'','supplier','1',23200000.00,0.00,'Purchase Id 13 for 29,000.00 litters of Diesel - AGO from AA RANO NIGERIA LTD','2022-10-29 15:26:03','',''),('1','294',179,'','20','4',0.00,0.00,'Sales from shift 77 on 2022-10-30 10:16:26 ','2022-10-30 10:16:26','',''),('1','294',180,'','6.1','1',0.00,0.00,'Sales from shift 77 on 2022-10-30 10:16:26 ','2022-10-30 10:16:26','',''),('1','294',181,'','20','4',0.00,0.00,'Sales from shift 78 on 2022-10-30 10:28:25 ','2022-10-30 10:28:25','',''),('1','294',182,'','6.1','1',0.00,0.00,'Sales from shift 78 on 2022-10-30 10:28:25 ','2022-10-30 10:28:25','',''),('1','294',183,'','24','2',0.00,16000000.00,'Purchase Id 14 for 20,000.00 litters of Diesel - AGO from AA RANO NIGERIA LTD','2022-10-31 11:43:39','',''),('1','294',184,'','supplier','1',16000000.00,0.00,'Purchase Id 14 for 20,000.00 litters of Diesel - AGO from AA RANO NIGERIA LTD','2022-10-31 11:43:39','',''),('1','294',185,'','20','4',0.00,0.00,'Sales from shift 79 on 2022-10-31 12:22:00 ','2022-10-31 12:22:00','',''),('1','294',186,'','6.1','1',0.00,0.00,'Sales from shift 79 on 2022-10-31 12:22:00 ','2022-10-31 12:22:00','',''),('1','294',187,'','24','2',0.00,12000000.00,'Purchase Id 15 for 15,000.00 litters of Diesel - AGO from AA RANO NIGERIA LTD','2022-10-31 12:40:19','',''),('1','294',188,'','supplier','1',12000000.00,0.00,'Purchase Id 15 for 15,000.00 litters of Diesel - AGO from AA RANO NIGERIA LTD','2022-10-31 12:40:19','',''),('1','294',189,'','20','4',811284.84,0.00,'Sales from shift 80 on 2022-10-31 13:28:26 ','2022-10-31 13:28:26','',''),('1','294',190,'','6.1','1',0.00,811284.84,'Sales from shift 80 on 2022-10-31 13:28:26 ','2022-10-31 13:28:26','',''),('1','294',191,'','20','4',1560727.14,0.00,'Sales from shift 81 on 2022-10-31 14:14:52 ','2022-10-31 14:14:52','',''),('1','294',192,'','6.1','1',0.00,1560727.14,'Sales from shift 81 on 2022-10-31 14:14:52 ','2022-10-31 14:14:52','',''),('1','294',193,'','20','4',4015453.30,0.00,'Sales from shift 82 on 2022-10-31 14:23:41 ','2022-10-31 14:23:41','',''),('1','294',194,'','6.1','1',0.00,4015453.30,'Sales from shift 82 on 2022-10-31 14:23:41 ','2022-10-31 14:23:41','',''),('1','294',195,'','20','4',3605131.14,0.00,'Sales from shift 83 on 2022-10-31 14:28:56 ','2022-10-31 14:28:56','',''),('1','294',196,'','6.1','1',0.00,3605131.14,'Sales from shift 83 on 2022-10-31 14:28:56 ','2022-10-31 14:28:56','',''),('1','294',197,'','20','4',2873815.36,0.00,'Sales from shift 84 on 2022-10-31 14:33:35 ','2022-10-31 14:33:35','',''),('1','294',198,'','6.1','1',0.00,2873815.36,'Sales from shift 84 on 2022-10-31 14:33:35 ','2022-10-31 14:33:35','',''),('1','294',199,'','20','4',2515983.20,0.00,'Sales from shift 85 on 2022-10-31 14:41:09 ','2022-10-31 14:41:09','',''),('1','294',200,'','6.1','1',0.00,2515983.20,'Sales from shift 85 on 2022-10-31 14:41:09 ','2022-10-31 14:41:09','',''),('1','294',201,'','20','4',2122426.30,0.00,'Sales from shift 86 on 2022-10-31 14:45:58 ','2022-10-31 14:45:58','',''),('1','294',202,'','6.1','1',0.00,2122426.30,'Sales from shift 86 on 2022-10-31 14:45:58 ','2022-10-31 14:45:58','',''),('1','294',203,'','20','4',919633.68,0.00,'Sales from shift 87 on 2022-10-31 14:59:31 ','2022-10-31 14:59:31','',''),('1','294',204,'','6.1','1',0.00,919633.68,'Sales from shift 87 on 2022-10-31 14:59:31 ','2022-10-31 14:59:31','',''),('1','294',205,'','20','4',670136.00,0.00,'Sales from shift 88 on 2022-10-31 15:04:15 ','2022-10-31 15:04:15','',''),('1','294',206,'','6.1','1',0.00,670136.00,'Sales from shift 88 on 2022-10-31 15:04:15 ','2022-10-31 15:04:15','',''),('1','294',207,'','20','4',920400.00,0.00,'Sales from shift 89 on 2022-10-31 15:13:35 ','2022-10-31 15:13:35','',''),('1','294',208,'','6.1','1',0.00,920400.00,'Sales from shift 89 on 2022-10-31 15:13:35 ','2022-10-31 15:13:35','',''),('1','294',209,'','20','4',1410280.00,0.00,'Sales from shift 90 on 2022-10-31 15:17:59 ','2022-10-31 15:17:59','',''),('1','294',210,'','6.1','1',0.00,1410280.00,'Sales from shift 90 on 2022-10-31 15:17:59 ','2022-10-31 15:17:59','',''),('1','294',211,'','20','4',316200.00,0.00,'Sales from shift 91 on 2022-10-31 15:19:49 ','2022-10-31 15:19:49','',''),('1','294',212,'','6.1','1',0.00,316200.00,'Sales from shift 91 on 2022-10-31 15:19:49 ','2022-10-31 15:19:49','',''),('1','294',213,'','20','4',804888.00,0.00,'Sales from shift 92 on 2022-10-31 15:28:30 ','2022-10-31 15:28:30','',''),('1','294',214,'','6.1','1',0.00,804888.00,'Sales from shift 92 on 2022-10-31 15:28:30 ','2022-10-31 15:28:30','',''),('1','294',215,'','20','4',936360.00,0.00,'Sales from shift 93 on 2022-10-31 15:30:37 ','2022-10-31 15:30:37','',''),('1','294',216,'','6.1','1',0.00,936360.00,'Sales from shift 93 on 2022-10-31 15:30:37 ','2022-10-31 15:30:37','',''),('1','294',217,'','20','4',1354600.00,0.00,'Sales from shift 94 on 2022-10-31 15:36:45 ','2022-10-31 15:36:45','',''),('1','294',218,'','6.1','1',0.00,1354600.00,'Sales from shift 94 on 2022-10-31 15:36:45 ','2022-10-31 15:36:45','',''),('1','294',219,'','20','4',1043168.00,0.00,'Sales from shift 95 on 2022-10-31 15:41:27 ','2022-10-31 15:41:27','',''),('1','294',220,'','6.1','1',0.00,1043168.00,'Sales from shift 95 on 2022-10-31 15:41:27 ','2022-10-31 15:41:27','',''),('1','294',221,'','20','4',1502944.00,0.00,'Sales from shift 96 on 2022-10-31 15:56:20 ','2022-10-31 15:56:20','',''),('1','294',222,'','6.1','1',0.00,1502944.00,'Sales from shift 96 on 2022-10-31 15:56:20 ','2022-10-31 15:56:20','',''),('1','294',223,'','20','4',904800.00,0.00,'Sales from shift 97 on 2022-10-31 22:32:15 ','2022-10-31 22:32:15','',''),('1','294',224,'','6.1','1',0.00,904800.00,'Sales from shift 97 on 2022-10-31 22:32:15 ','2022-10-31 22:32:15','',''),('1','294',225,'','20','4',2495896.00,0.00,'Sales from shift 98 on 2022-11-01 13:35:11 ','2022-11-01 13:35:11','',''),('1','294',226,'','6.1','1',0.00,2495896.00,'Sales from shift 98 on 2022-11-01 13:35:11 ','2022-11-01 13:35:11','',''),('1','294',227,'','20','4',1280112.00,0.00,'Sales from shift 99 on 2022-11-01 14:36:50 ','2022-11-01 14:36:50','',''),('1','294',228,'','6.1','1',0.00,1280112.00,'Sales from shift 99 on 2022-11-01 14:36:50 ','2022-11-01 14:36:50','',''),('1','294',229,'','20','4',2075352.00,0.00,'Sales from shift 100 on 2022-11-01 17:46:57 ','2022-11-01 17:46:57','',''),('1','294',230,'','6.1','1',0.00,2075352.00,'Sales from shift 100 on 2022-11-01 17:46:57 ','2022-11-01 17:46:57','',''),('1','294',231,'','20','4',2245952.00,0.00,'Sales from shift 101 on 2022-11-01 18:04:34 ','2022-11-01 18:04:34','',''),('1','294',232,'','6.1','1',0.00,2245952.00,'Sales from shift 101 on 2022-11-01 18:04:34 ','2022-11-01 18:04:34','',''),('1','294',233,'','20','4',607200.00,0.00,'Sales from shift 102 on 2022-11-01 18:07:47 ','2022-11-01 18:07:47','',''),('1','294',234,'','6.1','1',0.00,607200.00,'Sales from shift 102 on 2022-11-01 18:07:47 ','2022-11-01 18:07:47','',''),('1','294',235,'','20','4',1470688.00,0.00,'Sales from shift 103 on 2022-11-01 18:10:14 ','2022-11-01 18:10:14','',''),('1','294',236,'','6.1','1',0.00,1470688.00,'Sales from shift 103 on 2022-11-01 18:10:14 ','2022-11-01 18:10:14','',''),('1','294',237,'','20','4',318600.00,0.00,'Sales from shift 104 on 2022-11-01 18:12:03 ','2022-11-01 18:12:03','',''),('1','294',238,'','6.1','1',0.00,318600.00,'Sales from shift 104 on 2022-11-01 18:12:03 ','2022-11-01 18:12:03','',''),('1','294',239,'','20','4',3037920.00,0.00,'Sales from shift 105 on 2022-11-04 23:53:33 ','2022-11-04 23:53:33','',''),('1','294',240,'','6.1','1',0.00,3037920.00,'Sales from shift 105 on 2022-11-04 23:53:33 ','2022-11-04 23:53:33','',''),('1','294',241,'','20','4',2265224.00,0.00,'Sales from shift 106 on 2022-11-05 10:20:30 ','2022-11-05 10:20:30','',''),('1','294',242,'','6.1','1',0.00,2265224.00,'Sales from shift 106 on 2022-11-05 10:20:30 ','2022-11-05 10:20:30','',''),('1','294',243,'','20','4',6101576.00,0.00,'Sales from shift 107 on 2022-11-05 10:37:26 ','2022-11-05 10:37:26','',''),('1','294',244,'','6.1','1',0.00,6101576.00,'Sales from shift 107 on 2022-11-05 10:37:26 ','2022-11-05 10:37:26','',''),('1','294',245,'','20','4',1531120.00,0.00,'Sales from shift 108 on 2022-11-05 10:43:59 ','2022-11-05 10:43:59','',''),('1','294',246,'','6.1','1',0.00,1531120.00,'Sales from shift 108 on 2022-11-05 10:43:59 ','2022-11-05 10:43:59','',''),('1','294',247,'','20','4',4902736.00,0.00,'Sales from shift 109 on 2022-11-05 15:30:30 ','2022-11-05 15:30:30','',''),('1','294',248,'','6.1','1',0.00,4902736.00,'Sales from shift 109 on 2022-11-05 15:30:30 ','2022-11-05 15:30:30','',''),('1','294',249,'','20','4',812600.00,0.00,'Sales from shift 110 on 2022-11-07 20:00:21 ','2022-11-07 20:00:21','',''),('1','294',250,'','6.1','1',0.00,812600.00,'Sales from shift 110 on 2022-11-07 20:00:21 ','2022-11-07 20:00:21','',''),('1','294',251,'','20','4',5056176.00,0.00,'Sales from shift 111 on 2022-11-07 20:40:14 ','2022-11-07 20:40:14','',''),('1','294',252,'','6.1','1',0.00,5056176.00,'Sales from shift 111 on 2022-11-07 20:40:14 ','2022-11-07 20:40:14','',''),('1','294',253,'','24','2',0.00,9250000.00,'Purchase Id 16 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-07 22:05:48','',''),('1','294',254,'','supplier','1',9250000.00,0.00,'Purchase Id 16 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-07 22:05:48','',''),('1','294',255,'','24','2',0.00,40000000.00,'Purchase Id 17 for 50,000.00 litters of Diesel - AGO from AA RANO NIGERIA LTD','2022-11-07 22:10:14','',''),('1','294',256,'','supplier','1',40000000.00,0.00,'Purchase Id 17 for 50,000.00 litters of Diesel - AGO from AA RANO NIGERIA LTD','2022-11-07 22:10:14','',''),('1','294',257,'','20','4',2446061.20,0.00,'Sales from shift 112 on 2022-11-08 06:32:59 ','2022-11-08 06:32:59','',''),('1','294',258,'','6.1','1',0.00,2446061.20,'Sales from shift 112 on 2022-11-08 06:32:59 ','2022-11-08 06:32:59','',''),('1','294',259,'','2','5',326540.00,0.00,'Payment Id 19 for invoice:3, receipt: 002 by AA RANO NIGERIA LTD','2022-11-08 10:31:34','',''),('1','294',260,'','supplier','1',0.00,326540.00,'Payment Id 19 for invoice:3, receipt: 002 by AA RANO NIGERIA LTD','2022-11-08 10:31:34','',''),('1','294',261,'','6.1','1',279250.00,0.00,'Payment Id 18 for invoice:2, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:31:34','',''),('1','294',262,'','supplier','1',0.00,279250.00,'Payment Id 18 for invoice:2, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:31:34','',''),('1','294',263,'','2','5',1274800.00,0.00,'Payment Id 17 for invoice:2, receipt: 001 by AA RANO NIGERIA LTD','2022-11-08 10:31:34','',''),('1','294',264,'','supplier','1',0.00,1274800.00,'Payment Id 17 for invoice:2, receipt: 001 by AA RANO NIGERIA LTD','2022-11-08 10:31:34','',''),('1','294',265,'','2','5',1910470.00,0.00,'Payment Id 29 for invoice:9, receipt: 010 by AA RANO NIGERIA LTD','2022-11-08 10:33:07','',''),('1','294',266,'','supplier','1',0.00,1910470.00,'Payment Id 29 for invoice:9, receipt: 010 by AA RANO NIGERIA LTD','2022-11-08 10:33:07','',''),('1','294',267,'','2','5',1081000.00,0.00,'Payment Id 28 for invoice:9, receipt: 009 by AA RANO NIGERIA LTD','2022-11-08 10:33:07','',''),('1','294',268,'','supplier','1',0.00,1081000.00,'Payment Id 28 for invoice:9, receipt: 009 by AA RANO NIGERIA LTD','2022-11-08 10:33:07','',''),('1','294',269,'','2','5',255150.00,0.00,'Payment Id 27 for invoice:8, receipt: 008 by AA RANO NIGERIA LTD','2022-11-08 10:33:07','',''),('1','294',270,'','supplier','1',0.00,255150.00,'Payment Id 27 for invoice:8, receipt: 008 by AA RANO NIGERIA LTD','2022-11-08 10:33:07','',''),('1','294',271,'','6.1','1',317000.00,0.00,'Payment Id 26 for invoice:7, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:33:07','',''),('1','294',272,'','supplier','1',0.00,317000.00,'Payment Id 26 for invoice:7, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:33:07','',''),('1','294',273,'','2','6',1247260.00,0.00,'Payment Id 25 for invoice:7, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:33:07','',''),('1','294',274,'','supplier','1',0.00,1247260.00,'Payment Id 25 for invoice:7, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:33:07','',''),('1','294',275,'','2','5',829100.00,0.00,'Payment Id 24 for invoice:7, receipt: 007 by AA RANO NIGERIA LTD','2022-11-08 10:33:07','',''),('1','294',276,'','supplier','1',0.00,829100.00,'Payment Id 24 for invoice:7, receipt: 007 by AA RANO NIGERIA LTD','2022-11-08 10:33:07','',''),('1','294',277,'','2','5',1449210.00,0.00,'Payment Id 23 for invoice:7, receipt: 006 by AA RANO NIGERIA LTD','2022-11-08 10:33:07','',''),('1','294',278,'','supplier','1',0.00,1449210.00,'Payment Id 23 for invoice:7, receipt: 006 by AA RANO NIGERIA LTD','2022-11-08 10:33:07','',''),('1','294',279,'','2','5',395090.00,0.00,'Payment Id 22 for invoice:5, receipt: 005 by AA RANO NIGERIA LTD','2022-11-08 10:33:07','',''),('1','294',280,'','supplier','1',0.00,395090.00,'Payment Id 22 for invoice:5, receipt: 005 by AA RANO NIGERIA LTD','2022-11-08 10:33:07','',''),('1','294',281,'','2','5',922535.00,0.00,'Payment Id 21 for invoice:4, receipt: 004 by AA RANO NIGERIA LTD','2022-11-08 10:33:07','',''),('1','294',282,'','supplier','1',0.00,922535.00,'Payment Id 21 for invoice:4, receipt: 004 by AA RANO NIGERIA LTD','2022-11-08 10:33:07','',''),('1','294',283,'','2','5',1264625.00,0.00,'Payment Id 20 for invoice:4, receipt: 003 by AA RANO NIGERIA LTD','2022-11-08 10:33:07','',''),('1','294',284,'','supplier','1',0.00,1264625.00,'Payment Id 20 for invoice:4, receipt: 003 by AA RANO NIGERIA LTD','2022-11-08 10:33:07','',''),('1','294',285,'','2','5',259740.00,0.00,'Payment Id 39 for invoice:15, receipt: 016 by AA RANO NIGERIA LTD','2022-11-08 10:34:47','',''),('1','294',286,'','supplier','1',0.00,259740.00,'Payment Id 39 for invoice:15, receipt: 016 by AA RANO NIGERIA LTD','2022-11-08 10:34:47','',''),('1','294',287,'','2','5',801200.00,0.00,'Payment Id 38 for invoice:15, receipt: 016 by AA RANO NIGERIA LTD','2022-11-08 10:34:47','',''),('1','294',288,'','supplier','1',0.00,801200.00,'Payment Id 38 for invoice:15, receipt: 016 by AA RANO NIGERIA LTD','2022-11-08 10:34:47','',''),('1','294',289,'','2','6',448000.00,0.00,'Payment Id 37 for invoice:13/14, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:34:48','',''),('1','294',290,'','supplier','1',0.00,448000.00,'Payment Id 37 for invoice:13/14, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:34:48','',''),('1','294',291,'','2','5',1462950.00,0.00,'Payment Id 36 for invoice:14, receipt: 015 by AA RANO NIGERIA LTD','2022-11-08 10:34:48','',''),('1','294',292,'','supplier','1',0.00,1462950.00,'Payment Id 36 for invoice:14, receipt: 015 by AA RANO NIGERIA LTD','2022-11-08 10:34:48','',''),('1','294',293,'','2','5',1069615.00,0.00,'Payment Id 35 for invoice:13, receipt: 014 by AA RANO NIGERIA LTD','2022-11-08 10:34:48','',''),('1','294',294,'','supplier','1',0.00,1069615.00,'Payment Id 35 for invoice:13, receipt: 014 by AA RANO NIGERIA LTD','2022-11-08 10:34:48','',''),('1','294',295,'','2','6',918600.00,0.00,'Payment Id 34 for invoice:11/12, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:34:48','',''),('1','294',296,'','supplier','1',0.00,918600.00,'Payment Id 34 for invoice:11/12, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:34:48','',''),('1','294',297,'','2','5',1217550.00,0.00,'Payment Id 33 for invoice:12, receipt: 013 by AA RANO NIGERIA LTD','2022-11-08 10:34:48','',''),('1','294',298,'','supplier','1',0.00,1217550.00,'Payment Id 33 for invoice:12, receipt: 013 by AA RANO NIGERIA LTD','2022-11-08 10:34:48','',''),('1','294',299,'','2','5',895700.00,0.00,'Payment Id 32 for invoice:11, receipt: 012 by AA RANO NIGERIA LTD','2022-11-08 10:34:48','',''),('1','294',300,'','supplier','1',0.00,895700.00,'Payment Id 32 for invoice:11, receipt: 012 by AA RANO NIGERIA LTD','2022-11-08 10:34:48','',''),('1','294',301,'','2','6',550587.00,0.00,'Payment Id 31 for invoice:9/10, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:34:48','',''),('1','294',302,'','supplier','1',0.00,550587.00,'Payment Id 31 for invoice:9/10, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:34:48','',''),('1','294',303,'','2','5',732135.00,0.00,'Payment Id 30 for invoice:10, receipt: 011 by AA RANO NIGERIA LTD','2022-11-08 10:34:48','',''),('1','294',304,'','supplier','1',0.00,732135.00,'Payment Id 30 for invoice:10, receipt: 011 by AA RANO NIGERIA LTD','2022-11-08 10:34:48','',''),('1','294',305,'','2','5',1250565.00,0.00,'Payment Id 49 for invoice:21, receipt: 023 by AA RANO NIGERIA LTD','2022-11-08 10:35:53','',''),('1','294',306,'','supplier','1',0.00,1250565.00,'Payment Id 49 for invoice:21, receipt: 023 by AA RANO NIGERIA LTD','2022-11-08 10:35:53','',''),('1','294',307,'','2','6',946550.00,0.00,'Payment Id 48 for invoice:19/20, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:35:53','',''),('1','294',308,'','supplier','1',0.00,946550.00,'Payment Id 48 for invoice:19/20, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:35:53','',''),('1','294',309,'','2','5',1991480.00,0.00,'Payment Id 47 for invoice:20, receipt: 022 by AA RANO NIGERIA LTD','2022-11-08 10:35:53','',''),('1','294',310,'','supplier','1',0.00,1991480.00,'Payment Id 47 for invoice:20, receipt: 022 by AA RANO NIGERIA LTD','2022-11-08 10:35:53','',''),('1','294',311,'','2','5',1519350.00,0.00,'Payment Id 46 for invoice:19, receipt: 021 by AA RANO NIGERIA LTD','2022-11-08 10:35:53','',''),('1','294',312,'','supplier','1',0.00,1519350.00,'Payment Id 46 for invoice:19, receipt: 021 by AA RANO NIGERIA LTD','2022-11-08 10:35:53','',''),('1','294',313,'','2','6',1439655.00,0.00,'Payment Id 45 for invoice:17/18, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:35:53','',''),('1','294',314,'','supplier','1',0.00,1439655.00,'Payment Id 45 for invoice:17/18, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:35:53','',''),('1','294',315,'','2','5',1538130.00,0.00,'Payment Id 44 for invoice:18, receipt: 020 by AA RANO NIGERIA LTD','2022-11-08 10:35:53','',''),('1','294',316,'','supplier','1',0.00,1538130.00,'Payment Id 44 for invoice:18, receipt: 020 by AA RANO NIGERIA LTD','2022-11-08 10:35:53','',''),('1','294',317,'','2','5',234075.00,0.00,'Payment Id 43 for invoice:17, receipt: 019 by AA RANO NIGERIA LTD','2022-11-08 10:35:53','',''),('1','294',318,'','supplier','1',0.00,234075.00,'Payment Id 43 for invoice:17, receipt: 019 by AA RANO NIGERIA LTD','2022-11-08 10:35:53','',''),('1','294',319,'','2','5',1267890.00,0.00,'Payment Id 42 for invoice:17, receipt: 018 by AA RANO NIGERIA LTD','2022-11-08 10:35:53','',''),('1','294',320,'','supplier','1',0.00,1267890.00,'Payment Id 42 for invoice:17, receipt: 018 by AA RANO NIGERIA LTD','2022-11-08 10:35:53','',''),('1','294',321,'','2','6',864775.00,0.00,'Payment Id 41 for invoice:15/16, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:35:53','',''),('1','294',322,'','supplier','1',0.00,864775.00,'Payment Id 41 for invoice:15/16, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:35:53','',''),('1','294',323,'','2','5',1642605.00,0.00,'Payment Id 40 for invoice:16, receipt: 017 by AA RANO NIGERIA LTD','2022-11-08 10:35:53','',''),('1','294',324,'','supplier','1',0.00,1642605.00,'Payment Id 40 for invoice:16, receipt: 017 by AA RANO NIGERIA LTD','2022-11-08 10:35:53','',''),('1','294',325,'','2','5',1583845.00,0.00,'Payment Id 59 for invoice:28, receipt: 031 by AA RANO NIGERIA LTD','2022-11-08 10:37:20','',''),('1','294',326,'','supplier','1',0.00,1583845.00,'Payment Id 59 for invoice:28, receipt: 031 by AA RANO NIGERIA LTD','2022-11-08 10:37:20','',''),('1','294',327,'','2','5',1454325.00,0.00,'Payment Id 58 for invoice:27, receipt: 030 by AA RANO NIGERIA LTD','2022-11-08 10:37:20','',''),('1','294',328,'','supplier','1',0.00,1454325.00,'Payment Id 58 for invoice:27, receipt: 030 by AA RANO NIGERIA LTD','2022-11-08 10:37:20','',''),('1','294',329,'','2','5',1510585.00,0.00,'Payment Id 57 for invoice:26, receipt: 029 by AA RANO NIGERIA LTD','2022-11-08 10:37:20','',''),('1','294',330,'','supplier','1',0.00,1510585.00,'Payment Id 57 for invoice:26, receipt: 029 by AA RANO NIGERIA LTD','2022-11-08 10:37:20','',''),('1','294',331,'','2','6',176600.00,0.00,'Payment Id 56 for invoice:25, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:37:20','',''),('1','294',332,'','supplier','1',0.00,176600.00,'Payment Id 56 for invoice:25, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:37:20','',''),('1','294',333,'','2','5',1606530.00,0.00,'Payment Id 55 for invoice:25, receipt: 028 by AA RANO NIGERIA LTD','2022-11-08 10:37:20','',''),('1','294',334,'','supplier','1',0.00,1606530.00,'Payment Id 55 for invoice:25, receipt: 028 by AA RANO NIGERIA LTD','2022-11-08 10:37:20','',''),('1','294',335,'','2','5',1653340.00,0.00,'Payment Id 54 for invoice:24, receipt: 027 by AA RANO NIGERIA LTD','2022-11-08 10:37:20','',''),('1','294',336,'','supplier','1',0.00,1653340.00,'Payment Id 54 for invoice:24, receipt: 027 by AA RANO NIGERIA LTD','2022-11-08 10:37:20','',''),('1','294',337,'','2','5',150700.00,0.00,'Payment Id 53 for invoice:23, receipt: 026 by AA RANO NIGERIA LTD','2022-11-08 10:37:20','',''),('1','294',338,'','supplier','1',0.00,150700.00,'Payment Id 53 for invoice:23, receipt: 026 by AA RANO NIGERIA LTD','2022-11-08 10:37:20','',''),('1','294',339,'','2','5',1148925.00,0.00,'Payment Id 52 for invoice:23, receipt: 025 by AA RANO NIGERIA LTD','2022-11-08 10:37:20','',''),('1','294',340,'','supplier','1',0.00,1148925.00,'Payment Id 52 for invoice:23, receipt: 025 by AA RANO NIGERIA LTD','2022-11-08 10:37:20','',''),('1','294',341,'','2','6',991538.81,0.00,'Payment Id 51 for invoice:21/22, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:37:20','',''),('1','294',342,'','supplier','1',0.00,991538.81,'Payment Id 51 for invoice:21/22, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:37:20','',''),('1','294',343,'','2','5',1247165.00,0.00,'Payment Id 50 for invoice:22, receipt: 024 by AA RANO NIGERIA LTD','2022-11-08 10:37:20','',''),('1','294',344,'','supplier','1',0.00,1247165.00,'Payment Id 50 for invoice:22, receipt: 024 by AA RANO NIGERIA LTD','2022-11-08 10:37:20','',''),('1','294',345,'','2','6',896425.00,0.00,'Payment Id 69 for invoice:31/32, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:38:21','',''),('1','294',346,'','supplier','1',0.00,896425.00,'Payment Id 69 for invoice:31/32, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:38:21','',''),('1','294',347,'','2','5',1633350.00,0.00,'Payment Id 68 for invoice:32, receipt: 037 by AA RANO NIGERIA LTD','2022-11-08 10:38:21','',''),('1','294',348,'','supplier','1',0.00,1633350.00,'Payment Id 68 for invoice:32, receipt: 037 by AA RANO NIGERIA LTD','2022-11-08 10:38:21','',''),('1','294',349,'','2','5',10000.00,0.00,'Payment Id 67 for invoice:31, receipt: 036 by AA RANO NIGERIA LTD','2022-11-08 10:38:21','',''),('1','294',350,'','supplier','1',0.00,10000.00,'Payment Id 67 for invoice:31, receipt: 036 by AA RANO NIGERIA LTD','2022-11-08 10:38:21','',''),('1','294',351,'','2','5',1522350.00,0.00,'Payment Id 66 for invoice:31, receipt: 035 by AA RANO NIGERIA LTD','2022-11-08 10:38:21','',''),('1','294',352,'','supplier','1',0.00,1522350.00,'Payment Id 66 for invoice:31, receipt: 035 by AA RANO NIGERIA LTD','2022-11-08 10:38:21','',''),('1','294',353,'','2','6',857150.00,0.00,'Payment Id 65 for invoice:29/30, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:38:21','',''),('1','294',354,'','supplier','1',0.00,857150.00,'Payment Id 65 for invoice:29/30, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:38:21','',''),('1','294',355,'','6.1','1',279250.00,0.00,'Payment Id 64 for invoice:30, receipt: 11 by AA RANO NIGERIA LTD','2022-11-08 10:38:21','',''),('1','294',356,'','supplier','1',0.00,279250.00,'Payment Id 64 for invoice:30, receipt: 11 by AA RANO NIGERIA LTD','2022-11-08 10:38:21','',''),('1','294',357,'','2','5',10000.00,0.00,'Payment Id 63 for invoice:30, receipt: 034 by AA RANO NIGERIA LTD','2022-11-08 10:38:21','',''),('1','294',358,'','supplier','1',0.00,10000.00,'Payment Id 63 for invoice:30, receipt: 034 by AA RANO NIGERIA LTD','2022-11-08 10:38:21','',''),('1','294',359,'','2','5',988760.00,0.00,'Payment Id 62 for invoice:30, receipt: 033 by AA RANO NIGERIA LTD','2022-11-08 10:38:21','',''),('1','294',360,'','supplier','1',0.00,988760.00,'Payment Id 62 for invoice:30, receipt: 033 by AA RANO NIGERIA LTD','2022-11-08 10:38:21','',''),('1','294',361,'','2','5',880270.00,0.00,'Payment Id 61 for invoice:29, receipt: 032 by AA RANO NIGERIA LTD','2022-11-08 10:38:21','',''),('1','294',362,'','supplier','1',0.00,880270.00,'Payment Id 61 for invoice:29, receipt: 032 by AA RANO NIGERIA LTD','2022-11-08 10:38:21','',''),('1','294',363,'','2','6',982300.00,0.00,'Payment Id 60 for invoice:28, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:38:21','',''),('1','294',364,'','supplier','1',0.00,982300.00,'Payment Id 60 for invoice:28, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:38:21','',''),('1','294',365,'','2','6',770928.00,0.00,'Payment Id 79 for invoice:37/38, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:39:22','',''),('1','294',366,'','supplier','1',0.00,770928.00,'Payment Id 79 for invoice:37/38, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:39:22','',''),('1','294',367,'','2','5',2464660.00,0.00,'Payment Id 78 for invoice:38, receipt: 043 by AA RANO NIGERIA LTD','2022-11-08 10:39:22','',''),('1','294',368,'','supplier','1',0.00,2464660.00,'Payment Id 78 for invoice:38, receipt: 043 by AA RANO NIGERIA LTD','2022-11-08 10:39:22','',''),('1','294',369,'','2','5',1107140.00,0.00,'Payment Id 77 for invoice:37, receipt: 042 by AA RANO NIGERIA LTD','2022-11-08 10:39:22','',''),('1','294',370,'','supplier','1',0.00,1107140.00,'Payment Id 77 for invoice:37, receipt: 042 by AA RANO NIGERIA LTD','2022-11-08 10:39:22','',''),('1','294',371,'','2','6',1065500.00,0.00,'Payment Id 76 for invoice:35/36, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:39:22','',''),('1','294',372,'','supplier','1',0.00,1065500.00,'Payment Id 76 for invoice:35/36, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:39:22','',''),('1','294',373,'','6.1','1',279250.00,0.00,'Payment Id 75 for invoice:36, receipt: 015 by AA RANO NIGERIA LTD','2022-11-08 10:39:22','',''),('1','294',374,'','supplier','1',0.00,279250.00,'Payment Id 75 for invoice:36, receipt: 015 by AA RANO NIGERIA LTD','2022-11-08 10:39:22','',''),('1','294',375,'','2','5',1997015.00,0.00,'Payment Id 74 for invoice:36, receipt: 041 by AA RANO NIGERIA LTD','2022-11-08 10:39:22','',''),('1','294',376,'','supplier','1',0.00,1997015.00,'Payment Id 74 for invoice:36, receipt: 041 by AA RANO NIGERIA LTD','2022-11-08 10:39:22','',''),('1','294',377,'','2','5',812735.00,0.00,'Payment Id 73 for invoice:35, receipt: 040 by AA RANO NIGERIA LTD','2022-11-08 10:39:22','',''),('1','294',378,'','supplier','1',0.00,812735.00,'Payment Id 73 for invoice:35, receipt: 040 by AA RANO NIGERIA LTD','2022-11-08 10:39:22','',''),('1','294',379,'','2','6',740308.00,0.00,'Payment Id 72 for invoice:33/34, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:39:22','',''),('1','294',380,'','supplier','1',0.00,740308.00,'Payment Id 72 for invoice:33/34, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:39:22','',''),('1','294',381,'','2','5',2462050.00,0.00,'Payment Id 71 for invoice:34, receipt: 039 by AA RANO NIGERIA LTD','2022-11-08 10:39:22','',''),('1','294',382,'','supplier','1',0.00,2462050.00,'Payment Id 71 for invoice:34, receipt: 039 by AA RANO NIGERIA LTD','2022-11-08 10:39:22','',''),('1','294',383,'','2','5',1493620.00,0.00,'Payment Id 70 for invoice:33, receipt: 038 by AA RANO NIGERIA LTD','2022-11-08 10:39:22','',''),('1','294',384,'','supplier','1',0.00,1493620.00,'Payment Id 70 for invoice:33, receipt: 038 by AA RANO NIGERIA LTD','2022-11-08 10:39:22','',''),('1','294',385,'','2','5',933625.00,0.00,'Payment Id 89 for invoice:44, receipt: 049 by AA RANO NIGERIA LTD','2022-11-08 10:40:31','',''),('1','294',386,'','supplier','1',0.00,933625.00,'Payment Id 89 for invoice:44, receipt: 049 by AA RANO NIGERIA LTD','2022-11-08 10:40:31','',''),('1','294',387,'','2','6',164900.00,0.00,'Payment Id 88 for invoice:43, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:40:31','',''),('1','294',388,'','supplier','1',0.00,164900.00,'Payment Id 88 for invoice:43, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:40:31','',''),('1','294',389,'','2','5',483000.00,0.00,'Payment Id 87 for invoice:43, receipt: 047 by AA RANO NIGERIA LTD','2022-11-08 10:40:31','',''),('1','294',390,'','supplier','1',0.00,483000.00,'Payment Id 87 for invoice:43, receipt: 047 by AA RANO NIGERIA LTD','2022-11-08 10:40:31','',''),('1','294',391,'','2','6',1990023.00,0.00,'Payment Id 86 for invoice:41/42, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:40:31','',''),('1','294',392,'','supplier','1',0.00,1990023.00,'Payment Id 86 for invoice:41/42, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:40:31','',''),('1','294',393,'','6.1','1',279250.00,0.00,'Payment Id 85 for invoice:42, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:40:31','',''),('1','294',394,'','supplier','1',0.00,279250.00,'Payment Id 85 for invoice:42, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:40:31','',''),('1','294',395,'','2','5',1903510.00,0.00,'Payment Id 84 for invoice:42, receipt: 047 by AA RANO NIGERIA LTD','2022-11-08 10:40:31','',''),('1','294',396,'','supplier','1',0.00,1903510.00,'Payment Id 84 for invoice:42, receipt: 047 by AA RANO NIGERIA LTD','2022-11-08 10:40:31','',''),('1','294',397,'','2','5',1244195.00,0.00,'Payment Id 83 for invoice:41, receipt: 046 by AA RANO NIGERIA LTD','2022-11-08 10:40:31','',''),('1','294',398,'','supplier','1',0.00,1244195.00,'Payment Id 83 for invoice:41, receipt: 046 by AA RANO NIGERIA LTD','2022-11-08 10:40:31','',''),('1','294',399,'','2','6',1313195.00,0.00,'Payment Id 82 for invoice:39/40, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:40:31','',''),('1','294',400,'','supplier','1',0.00,1313195.00,'Payment Id 82 for invoice:39/40, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:40:31','',''),('1','294',401,'','2','5',1840530.00,0.00,'Payment Id 81 for invoice:40, receipt: 045 by AA RANO NIGERIA LTD','2022-11-08 10:40:31','',''),('1','294',402,'','supplier','1',0.00,1840530.00,'Payment Id 81 for invoice:40, receipt: 045 by AA RANO NIGERIA LTD','2022-11-08 10:40:31','',''),('1','294',403,'','2','5',1236110.00,0.00,'Payment Id 80 for invoice:39, receipt: 044 by AA RANO NIGERIA LTD','2022-11-08 10:40:32','',''),('1','294',404,'','supplier','1',0.00,1236110.00,'Payment Id 80 for invoice:39, receipt: 044 by AA RANO NIGERIA LTD','2022-11-08 10:40:32','',''),('1','294',405,'','2','5',1092320.00,0.00,'Payment Id 99 for invoice:51, receipt: 061 by AA RANO NIGERIA LTD','2022-11-08 10:41:36','',''),('1','294',406,'','supplier','1',0.00,1092320.00,'Payment Id 99 for invoice:51, receipt: 061 by AA RANO NIGERIA LTD','2022-11-08 10:41:36','',''),('1','294',407,'','2','6',106551.00,0.00,'Payment Id 98 for invoice:49/50, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:41:36','',''),('1','294',408,'','supplier','1',0.00,106551.00,'Payment Id 98 for invoice:49/50, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:41:36','',''),('1','294',409,'','2','5',1326060.00,0.00,'Payment Id 97 for invoice:50, receipt: 060 by AA RANO NIGERIA LTD','2022-11-08 10:41:36','',''),('1','294',410,'','supplier','1',0.00,1326060.00,'Payment Id 97 for invoice:50, receipt: 060 by AA RANO NIGERIA LTD','2022-11-08 10:41:36','',''),('1','294',411,'','2','5',1172970.00,0.00,'Payment Id 96 for invoice:49, receipt: 059 by AA RANO NIGERIA LTD','2022-11-08 10:41:36','',''),('1','294',412,'','supplier','1',0.00,1172970.00,'Payment Id 96 for invoice:49, receipt: 059 by AA RANO NIGERIA LTD','2022-11-08 10:41:36','',''),('1','294',413,'','2','6',238440.00,0.00,'Payment Id 95 for invoice:47/48, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:41:36','',''),('1','294',414,'','supplier','1',0.00,238440.00,'Payment Id 95 for invoice:47/48, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:41:36','',''),('1','294',415,'','2','5',1608155.00,0.00,'Payment Id 94 for invoice:48, receipt: 053 by AA RANO NIGERIA LTD','2022-11-08 10:41:36','',''),('1','294',416,'','supplier','1',0.00,1608155.00,'Payment Id 94 for invoice:48, receipt: 053 by AA RANO NIGERIA LTD','2022-11-08 10:41:36','',''),('1','294',417,'','2','5',1267370.00,0.00,'Payment Id 93 for invoice:47, receipt: 052 by AA RANO NIGERIA LTD','2022-11-08 10:41:37','',''),('1','294',418,'','supplier','1',0.00,1267370.00,'Payment Id 93 for invoice:47, receipt: 052 by AA RANO NIGERIA LTD','2022-11-08 10:41:37','',''),('1','294',419,'','2','6',305100.00,0.00,'Payment Id 92 for invoice:44/45/46, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:41:37','',''),('1','294',420,'','supplier','1',0.00,305100.00,'Payment Id 92 for invoice:44/45/46, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:41:37','',''),('1','294',421,'','2','5',1759330.00,0.00,'Payment Id 91 for invoice:46, receipt: 051 by AA RANO NIGERIA LTD','2022-11-08 10:41:37','',''),('1','294',422,'','supplier','1',0.00,1759330.00,'Payment Id 91 for invoice:46, receipt: 051 by AA RANO NIGERIA LTD','2022-11-08 10:41:37','',''),('1','294',423,'','2','5',293340.00,0.00,'Payment Id 90 for invoice:45, receipt: 050 by AA RANO NIGERIA LTD','2022-11-08 10:41:37','',''),('1','294',424,'','supplier','1',0.00,293340.00,'Payment Id 90 for invoice:45, receipt: 050 by AA RANO NIGERIA LTD','2022-11-08 10:41:37','',''),('1','294',425,'','2','5',2076560.00,0.00,'Payment Id 109 for invoice:56, receipt: 066 by AA RANO NIGERIA LTD','2022-11-08 10:42:30','',''),('1','294',426,'','supplier','1',0.00,2076560.00,'Payment Id 109 for invoice:56, receipt: 066 by AA RANO NIGERIA LTD','2022-11-08 10:42:30','',''),('1','294',427,'','6.1','1',169000.00,0.00,'Payment Id 108 for invoice:55, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:42:30','',''),('1','294',428,'','supplier','1',0.00,169000.00,'Payment Id 108 for invoice:55, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:42:30','',''),('1','294',429,'','6.1','1',400000.00,0.00,'Payment Id 107 for invoice:55, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:42:30','',''),('1','294',430,'','supplier','1',0.00,400000.00,'Payment Id 107 for invoice:55, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:42:30','',''),('1','294',431,'','6.1','1',284500.00,0.00,'Payment Id 106 for invoice:55, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:42:30','',''),('1','294',432,'','supplier','1',0.00,284500.00,'Payment Id 106 for invoice:55, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:42:30','',''),('1','294',433,'','2','5',982020.00,0.00,'Payment Id 105 for invoice:55, receipt: 065 by AA RANO NIGERIA LTD','2022-11-08 10:42:30','',''),('1','294',434,'','supplier','1',0.00,982020.00,'Payment Id 105 for invoice:55, receipt: 065 by AA RANO NIGERIA LTD','2022-11-08 10:42:30','',''),('1','294',435,'','2','6',175805.00,0.00,'Payment Id 104 for invoice:53/54, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:42:30','',''),('1','294',436,'','supplier','1',0.00,175805.00,'Payment Id 104 for invoice:53/54, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:42:30','',''),('1','294',437,'','2','5',1334945.00,0.00,'Payment Id 103 for invoice:54, receipt: 064 by AA RANO NIGERIA LTD','2022-11-08 10:42:30','',''),('1','294',438,'','supplier','1',0.00,1334945.00,'Payment Id 103 for invoice:54, receipt: 064 by AA RANO NIGERIA LTD','2022-11-08 10:42:30','',''),('1','294',439,'','2','5',1207435.00,0.00,'Payment Id 102 for invoice:53, receipt: 063 by AA RANO NIGERIA LTD','2022-11-08 10:42:30','',''),('1','294',440,'','supplier','1',0.00,1207435.00,'Payment Id 102 for invoice:53, receipt: 063 by AA RANO NIGERIA LTD','2022-11-08 10:42:30','',''),('1','294',441,'','2','6',84450.00,0.00,'Payment Id 101 for invoice:51/52, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:42:30','',''),('1','294',442,'','supplier','1',0.00,84450.00,'Payment Id 101 for invoice:51/52, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:42:30','',''),('1','294',443,'','2','5',1525930.00,0.00,'Payment Id 100 for invoice:52, receipt: 062 by AA RANO NIGERIA LTD','2022-11-08 10:42:30','',''),('1','294',444,'','supplier','1',0.00,1525930.00,'Payment Id 100 for invoice:52, receipt: 062 by AA RANO NIGERIA LTD','2022-11-08 10:42:30','',''),('1','294',445,'','2','5',234000.00,0.00,'Payment Id 119 for invoice:64, receipt: 073 by AA RANO NIGERIA LTD','2022-11-08 10:43:45','',''),('1','294',446,'','supplier','1',0.00,234000.00,'Payment Id 119 for invoice:64, receipt: 073 by AA RANO NIGERIA LTD','2022-11-08 10:43:45','',''),('1','294',447,'','2','5',1378355.00,0.00,'Payment Id 118 for invoice:64, receipt: 072 by AA RANO NIGERIA LTD','2022-11-08 10:43:45','',''),('1','294',448,'','supplier','1',0.00,1378355.00,'Payment Id 118 for invoice:64, receipt: 072 by AA RANO NIGERIA LTD','2022-11-08 10:43:45','',''),('1','294',449,'','2','5',2068600.00,0.00,'Payment Id 117 for invoice:63, receipt: 071 by AA RANO NIGERIA LTD','2022-11-08 10:43:45','',''),('1','294',450,'','supplier','1',0.00,2068600.00,'Payment Id 117 for invoice:63, receipt: 071 by AA RANO NIGERIA LTD','2022-11-08 10:43:45','',''),('1','294',451,'','2','6',2496920.00,0.00,'Payment Id 116 for invoice:60/61, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:43:45','',''),('1','294',452,'','supplier','1',0.00,2496920.00,'Payment Id 116 for invoice:60/61, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:43:45','',''),('1','294',453,'','2','5',1401250.00,0.00,'Payment Id 115 for invoice:61, receipt: 070 by AA RANO NIGERIA LTD','2022-11-08 10:43:45','',''),('1','294',454,'','supplier','1',0.00,1401250.00,'Payment Id 115 for invoice:61, receipt: 070 by AA RANO NIGERIA LTD','2022-11-08 10:43:45','',''),('1','294',455,'','2','5',1263780.00,0.00,'Payment Id 114 for invoice:60, receipt: 069 by AA RANO NIGERIA LTD','2022-11-08 10:43:45','',''),('1','294',456,'','supplier','1',0.00,1263780.00,'Payment Id 114 for invoice:60, receipt: 069 by AA RANO NIGERIA LTD','2022-11-08 10:43:45','',''),('1','294',457,'','2','6',1290450.00,0.00,'Payment Id 113 for invoice:57/58/59, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:43:45','',''),('1','294',458,'','supplier','1',0.00,1290450.00,'Payment Id 113 for invoice:57/58/59, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:43:45','',''),('1','294',459,'','2','5',1592025.00,0.00,'Payment Id 112 for invoice:59, receipt: 068 by AA RANO NIGERIA LTD','2022-11-08 10:43:45','',''),('1','294',460,'','supplier','1',0.00,1592025.00,'Payment Id 112 for invoice:59, receipt: 068 by AA RANO NIGERIA LTD','2022-11-08 10:43:45','',''),('1','294',461,'','2','5',1552575.00,0.00,'Payment Id 111 for invoice:57/58, receipt: 067 by AA RANO NIGERIA LTD','2022-11-08 10:43:45','',''),('1','294',462,'','supplier','1',0.00,1552575.00,'Payment Id 111 for invoice:57/58, receipt: 067 by AA RANO NIGERIA LTD','2022-11-08 10:43:45','',''),('1','294',463,'','2','6',1559092.00,0.00,'Payment Id 110 for invoice:55/56, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:43:45','',''),('1','294',464,'','supplier','1',0.00,1559092.00,'Payment Id 110 for invoice:55/56, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:43:45','',''),('1','294',465,'','2','5',2329265.00,0.00,'Payment Id 129 for invoice:70, receipt: 079 by AA RANO NIGERIA LTD','2022-11-08 10:50:22','',''),('1','294',466,'','supplier','1',0.00,2329265.00,'Payment Id 129 for invoice:70, receipt: 079 by AA RANO NIGERIA LTD','2022-11-08 10:50:22','',''),('1','294',467,'','2','5',1175060.00,0.00,'Payment Id 128 for invoice:69, receipt: 078 by AA RANO NIGERIA LTD','2022-11-08 10:50:22','',''),('1','294',468,'','supplier','1',0.00,1175060.00,'Payment Id 128 for invoice:69, receipt: 078 by AA RANO NIGERIA LTD','2022-11-08 10:50:22','',''),('1','294',469,'','2','6',655530.00,0.00,'Payment Id 127 for invoice:67/68, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:50:22','',''),('1','294',470,'','supplier','1',0.00,655530.00,'Payment Id 127 for invoice:67/68, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:50:22','',''),('1','294',471,'','6.1','1',366000.00,0.00,'Payment Id 126 for invoice:68, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:50:22','',''),('1','294',472,'','supplier','1',0.00,366000.00,'Payment Id 126 for invoice:68, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:50:22','',''),('1','294',473,'','2','5',613000.00,0.00,'Payment Id 125 for invoice:68, receipt: 077 by AA RANO NIGERIA LTD','2022-11-08 10:50:22','',''),('1','294',474,'','supplier','1',0.00,613000.00,'Payment Id 125 for invoice:68, receipt: 077 by AA RANO NIGERIA LTD','2022-11-08 10:50:22','',''),('1','294',475,'','2','5',21000.00,0.00,'Payment Id 124 for invoice:67, receipt: 076 by AA RANO NIGERIA LTD','2022-11-08 10:50:22','',''),('1','294',476,'','supplier','1',0.00,21000.00,'Payment Id 124 for invoice:67, receipt: 076 by AA RANO NIGERIA LTD','2022-11-08 10:50:22','',''),('1','294',477,'','2','6',1971000.00,0.00,'Payment Id 123 for invoice:65/66, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:50:22','',''),('1','294',478,'','supplier','1',0.00,1971000.00,'Payment Id 123 for invoice:65/66, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:50:22','',''),('1','294',479,'','2','5',287460.00,0.00,'Payment Id 122 for invoice:66, receipt: 075 by AA RANO NIGERIA LTD','2022-11-08 10:50:22','',''),('1','294',480,'','supplier','1',0.00,287460.00,'Payment Id 122 for invoice:66, receipt: 075 by AA RANO NIGERIA LTD','2022-11-08 10:50:22','',''),('1','294',481,'','2','5',290215.00,0.00,'Payment Id 121 for invoice:65, receipt: 074 by AA RANO NIGERIA LTD','2022-11-08 10:50:22','',''),('1','294',482,'','supplier','1',0.00,290215.00,'Payment Id 121 for invoice:65, receipt: 074 by AA RANO NIGERIA LTD','2022-11-08 10:50:22','',''),('1','294',483,'','2','6',479173.00,0.00,'Payment Id 120 for invoice:63/64, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:50:22','',''),('1','294',484,'','supplier','1',0.00,479173.00,'Payment Id 120 for invoice:63/64, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:50:22','',''),('1','294',485,'','2','6',104530.00,0.00,'Payment Id 139 for invoice:75/76, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:58:28','',''),('1','294',486,'','supplier','1',0.00,104530.00,'Payment Id 139 for invoice:75/76, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:58:28','',''),('1','294',487,'','2','5',1003980.00,0.00,'Payment Id 138 for invoice:76, receipt: 085 by AA RANO NIGERIA LTD','2022-11-08 10:58:28','',''),('1','294',488,'','supplier','1',0.00,1003980.00,'Payment Id 138 for invoice:76, receipt: 085 by AA RANO NIGERIA LTD','2022-11-08 10:58:28','',''),('1','294',489,'','2','5',1086040.00,0.00,'Payment Id 137 for invoice:75, receipt: 084 by AA RANO NIGERIA LTD','2022-11-08 10:58:28','',''),('1','294',490,'','supplier','1',0.00,1086040.00,'Payment Id 137 for invoice:75, receipt: 084 by AA RANO NIGERIA LTD','2022-11-08 10:58:28','',''),('1','294',491,'','2','6',104579.00,0.00,'Payment Id 136 for invoice:73/74, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:58:28','',''),('1','294',492,'','supplier','1',0.00,104579.00,'Payment Id 136 for invoice:73/74, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:58:28','',''),('1','294',493,'','2','5',1351425.00,0.00,'Payment Id 135 for invoice:74, receipt: 083 by AA RANO NIGERIA LTD','2022-11-08 10:58:28','',''),('1','294',494,'','supplier','1',0.00,1351425.00,'Payment Id 135 for invoice:74, receipt: 083 by AA RANO NIGERIA LTD','2022-11-08 10:58:28','',''),('1','294',495,'','2','5',1144650.00,0.00,'Payment Id 134 for invoice:73, receipt: 082 by AA RANO NIGERIA LTD','2022-11-08 10:58:28','',''),('1','294',496,'','supplier','1',0.00,1144650.00,'Payment Id 134 for invoice:73, receipt: 082 by AA RANO NIGERIA LTD','2022-11-08 10:58:28','',''),('1','294',497,'','2','6',229880.00,0.00,'Payment Id 133 for invoice:71/72, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:58:28','',''),('1','294',498,'','supplier','1',0.00,229880.00,'Payment Id 133 for invoice:71/72, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:58:28','',''),('1','294',499,'','2','5',1638025.00,0.00,'Payment Id 132 for invoice:72, receipt: 081 by AA RANO NIGERIA LTD','2022-11-08 10:58:28','',''),('1','294',500,'','supplier','1',0.00,1638025.00,'Payment Id 132 for invoice:72, receipt: 081 by AA RANO NIGERIA LTD','2022-11-08 10:58:28','',''),('1','294',501,'','2','5',1427765.00,0.00,'Payment Id 131 for invoice:71, receipt: 080 by AA RANO NIGERIA LTD','2022-11-08 10:58:28','',''),('1','294',502,'','supplier','1',0.00,1427765.00,'Payment Id 131 for invoice:71, receipt: 080 by AA RANO NIGERIA LTD','2022-11-08 10:58:28','',''),('1','294',503,'','2','6',576979.00,0.00,'Payment Id 130 for invoice:69/70, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:58:28','',''),('1','294',504,'','supplier','1',0.00,576979.00,'Payment Id 130 for invoice:69/70, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 10:58:28','',''),('1','294',505,'','2','5',2136680.00,0.00,'Payment Id 149 for invoice:85, receipt: 091 by AA RANO NIGERIA LTD','2022-11-08 11:00:18','',''),('1','294',506,'','supplier','1',0.00,2136680.00,'Payment Id 149 for invoice:85, receipt: 091 by AA RANO NIGERIA LTD','2022-11-08 11:00:18','',''),('1','294',507,'','2','6',1259850.00,0.00,'Payment Id 148 for invoice:83/84, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 11:00:18','',''),('1','294',508,'','supplier','1',0.00,1259850.00,'Payment Id 148 for invoice:83/84, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 11:00:18','',''),('1','294',509,'','2','5',2334330.00,0.00,'Payment Id 147 for invoice:84, receipt: 090 by AA RANO NIGERIA LTD','2022-11-08 11:00:18','',''),('1','294',510,'','supplier','1',0.00,2334330.00,'Payment Id 147 for invoice:84, receipt: 090 by AA RANO NIGERIA LTD','2022-11-08 11:00:18','',''),('1','294',511,'','2','5',2884380.00,0.00,'Payment Id 146 for invoice:83, receipt: 089 by AA RANO NIGERIA LTD','2022-11-08 11:00:18','',''),('1','294',512,'','supplier','1',0.00,2884380.00,'Payment Id 146 for invoice:83, receipt: 089 by AA RANO NIGERIA LTD','2022-11-08 11:00:18','',''),('1','294',513,'','2','6',810000.00,0.00,'Payment Id 145 for invoice:81/82, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 11:00:18','',''),('1','294',514,'','supplier','1',0.00,810000.00,'Payment Id 145 for invoice:81/82, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 11:00:18','',''),('1','294',515,'','6.1','1',335000.00,0.00,'Payment Id 144 for invoice:82, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 11:00:18','',''),('1','294',516,'','supplier','1',0.00,335000.00,'Payment Id 144 for invoice:82, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 11:00:18','',''),('1','294',517,'','2','5',2983355.00,0.00,'Payment Id 143 for invoice:82, receipt: 088 by AA RANO NIGERIA LTD','2022-11-08 11:00:18','',''),('1','294',518,'','supplier','1',0.00,2983355.00,'Payment Id 143 for invoice:82, receipt: 088 by AA RANO NIGERIA LTD','2022-11-08 11:00:18','',''),('1','294',519,'','2','5',1446820.00,0.00,'Payment Id 142 for invoice:81, receipt: 087 by AA RANO NIGERIA LTD','2022-11-08 11:00:18','',''),('1','294',520,'','supplier','1',0.00,1446820.00,'Payment Id 142 for invoice:81, receipt: 087 by AA RANO NIGERIA LTD','2022-11-08 11:00:18','',''),('1','294',521,'','2','6',81845.00,0.00,'Payment Id 141 for invoice:80, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 11:00:18','',''),('1','294',522,'','supplier','1',0.00,81845.00,'Payment Id 141 for invoice:80, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 11:00:18','',''),('1','294',523,'','2','5',649410.00,0.00,'Payment Id 140 for invoice:80, receipt: 086 by AA RANO NIGERIA LTD','2022-11-08 11:00:18','',''),('1','294',524,'','supplier','1',0.00,649410.00,'Payment Id 140 for invoice:80, receipt: 086 by AA RANO NIGERIA LTD','2022-11-08 11:00:18','',''),('1','294',525,'','2','5',32790.00,0.00,'Payment Id 159 for invoice:92, receipt: 098 by AA RANO NIGERIA LTD','2022-11-08 11:03:04','',''),('1','294',526,'','supplier','1',0.00,32790.00,'Payment Id 159 for invoice:92, receipt: 098 by AA RANO NIGERIA LTD','2022-11-08 11:03:04','',''),('1','294',527,'','2','5',175500.00,0.00,'Payment Id 158 for invoice:91, receipt: 097 by AA RANO NIGERIA LTD','2022-11-08 11:03:04','',''),('1','294',528,'','supplier','1',0.00,175500.00,'Payment Id 158 for invoice:91, receipt: 097 by AA RANO NIGERIA LTD','2022-11-08 11:03:04','',''),('1','294',529,'','2','6',1164900.00,0.00,'Payment Id 157 for invoice:89/90, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 11:03:04','',''),('1','294',530,'','supplier','1',0.00,1164900.00,'Payment Id 157 for invoice:89/90, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 11:03:04','',''),('1','294',531,'','2','5',597780.00,0.00,'Payment Id 156 for invoice:90, receipt: 096 by AA RANO NIGERIA LTD','2022-11-08 11:03:04','',''),('1','294',532,'','supplier','1',0.00,597780.00,'Payment Id 156 for invoice:90, receipt: 096 by AA RANO NIGERIA LTD','2022-11-08 11:03:04','',''),('1','294',533,'','2','5',487500.00,0.00,'Payment Id 155 for invoice:89, receipt: 095 by AA RANO NIGERIA LTD','2022-11-08 11:03:04','',''),('1','294',534,'','supplier','1',0.00,487500.00,'Payment Id 155 for invoice:89, receipt: 095 by AA RANO NIGERIA LTD','2022-11-08 11:03:04','',''),('1','294',535,'','2','6',1007300.00,0.00,'Payment Id 154 for invoice:87/88, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 11:03:04','',''),('1','294',536,'','supplier','1',0.00,1007300.00,'Payment Id 154 for invoice:87/88, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 11:03:04','',''),('1','294',537,'','2','5',259635.00,0.00,'Payment Id 153 for invoice:88, receipt: 094 by AA RANO NIGERIA LTD','2022-11-08 11:03:04','',''),('1','294',538,'','supplier','1',0.00,259635.00,'Payment Id 153 for invoice:88, receipt: 094 by AA RANO NIGERIA LTD','2022-11-08 11:03:04','',''),('1','294',539,'','2','5',322335.00,0.00,'Payment Id 152 for invoice:87, receipt: 093 by AA RANO NIGERIA LTD','2022-11-08 11:03:04','',''),('1','294',540,'','supplier','1',0.00,322335.00,'Payment Id 152 for invoice:87, receipt: 093 by AA RANO NIGERIA LTD','2022-11-08 11:03:04','',''),('1','294',541,'','2','6',700430.00,0.00,'Payment Id 151 for invoice:85/86, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 11:03:04','',''),('1','294',542,'','supplier','1',0.00,700430.00,'Payment Id 151 for invoice:85/86, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 11:03:04','',''),('1','294',543,'','2','5',1717240.00,0.00,'Payment Id 150 for invoice:86, receipt: 092 by AA RANO NIGERIA LTD','2022-11-08 11:03:04','',''),('1','294',544,'','supplier','1',0.00,1717240.00,'Payment Id 150 for invoice:86, receipt: 092 by AA RANO NIGERIA LTD','2022-11-08 11:03:04','',''),('1','294',545,'','2','5',493800.00,0.00,'Payment Id 169 for invoice:97, receipt: 103 by AA RANO NIGERIA LTD','2022-11-08 11:05:01','',''),('1','294',546,'','supplier','1',0.00,493800.00,'Payment Id 169 for invoice:97, receipt: 103 by AA RANO NIGERIA LTD','2022-11-08 11:05:01','',''),('1','294',547,'','2','6',1370000.00,0.00,'Payment Id 168 for invoice:95/96, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 11:05:01','',''),('1','294',548,'','supplier','1',0.00,1370000.00,'Payment Id 168 for invoice:95/96, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 11:05:01','',''),('1','294',549,'','2','5',852445.00,0.00,'Payment Id 167 for invoice:96, receipt: 102 by AA RANO NIGERIA LTD','2022-11-08 11:05:01','',''),('1','294',550,'','supplier','1',0.00,852445.00,'Payment Id 167 for invoice:96, receipt: 102 by AA RANO NIGERIA LTD','2022-11-08 11:05:01','',''),('1','294',551,'','2','5',8665.00,0.00,'Payment Id 166 for invoice:95, receipt: 101 by AA RANO NIGERIA LTD','2022-11-08 11:05:01','',''),('1','294',552,'','supplier','1',0.00,8665.00,'Payment Id 166 for invoice:95, receipt: 101 by AA RANO NIGERIA LTD','2022-11-08 11:05:01','',''),('1','294',553,'','2','6',1556700.00,0.00,'Payment Id 165 for invoice:93/94, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 11:05:01','',''),('1','294',554,'','supplier','1',0.00,1556700.00,'Payment Id 165 for invoice:93/94, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 11:05:01','',''),('1','294',555,'','2','5',1556700.00,0.00,'Payment Id 164 for invoice:93/94, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 11:05:01','',''),('1','294',556,'','supplier','1',0.00,1556700.00,'Payment Id 164 for invoice:93/94, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 11:05:01','',''),('1','294',557,'','2','5',685900.00,0.00,'Payment Id 163 for invoice:94, receipt: 100 by AA RANO NIGERIA LTD','2022-11-08 11:05:01','',''),('1','294',558,'','supplier','1',0.00,685900.00,'Payment Id 163 for invoice:94, receipt: 100 by AA RANO NIGERIA LTD','2022-11-08 11:05:01','',''),('1','294',559,'','2','5',48360.00,0.00,'Payment Id 162 for invoice:93, receipt: 099 by AA RANO NIGERIA LTD','2022-11-08 11:05:01','',''),('1','294',560,'','supplier','1',0.00,48360.00,'Payment Id 162 for invoice:93, receipt: 099 by AA RANO NIGERIA LTD','2022-11-08 11:05:01','',''),('1','294',561,'','2','6',557300.00,0.00,'Payment Id 161 for invoice:91/92, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 11:05:01','',''),('1','294',562,'','supplier','1',0.00,557300.00,'Payment Id 161 for invoice:91/92, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 11:05:01','',''),('1','294',563,'','6.1','1',335000.00,0.00,'Payment Id 160 for invoice:92, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 11:05:01','',''),('1','294',564,'','supplier','1',0.00,335000.00,'Payment Id 160 for invoice:92, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 11:05:01','',''),('1','294',565,'','6.1','1',335000.00,0.00,'Payment Id 179 for invoice:102, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 11:07:05','',''),('1','294',566,'','supplier','1',0.00,335000.00,'Payment Id 179 for invoice:102, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 11:07:05','',''),('1','294',567,'','2','5',110200.00,0.00,'Payment Id 178 for invoice:102, receipt: 105 by AA RANO NIGERIA LTD','2022-11-08 11:07:05','',''),('1','294',568,'','supplier','1',0.00,110200.00,'Payment Id 178 for invoice:102, receipt: 105 by AA RANO NIGERIA LTD','2022-11-08 11:07:05','',''),('1','294',569,'','2','6',1283800.00,0.00,'Payment Id 177 for invoice:101, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 11:07:05','',''),('1','294',570,'','supplier','1',0.00,1283800.00,'Payment Id 177 for invoice:101, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 11:07:05','',''),('1','294',571,'','6.1','1',335000.00,0.00,'Payment Id 176 for invoice:101, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 11:07:05','',''),('1','294',572,'','supplier','1',0.00,335000.00,'Payment Id 176 for invoice:101, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 11:07:05','',''),('1','294',573,'','2','5',627150.00,0.00,'Payment Id 175 for invoice:101, receipt: 107 by AA RANO NIGERIA LTD','2022-11-08 11:07:05','',''),('1','294',574,'','supplier','1',0.00,627150.00,'Payment Id 175 for invoice:101, receipt: 107 by AA RANO NIGERIA LTD','2022-11-08 11:07:05','',''),('1','294',575,'','2','6',1234750.00,0.00,'Payment Id 174 for invoice:99/100, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 11:07:05','',''),('1','294',576,'','supplier','1',0.00,1234750.00,'Payment Id 174 for invoice:99/100, receipt: 0 by AA RANO NIGERIA LTD','2022-11-08 11:07:05','',''),('1','294',577,'','2','5',1021600.00,0.00,'Payment Id 173 for invoice:100, receipt: 106 by AA RANO NIGERIA LTD','2022-11-08 11:07:05','',''),('1','294',578,'','supplier','1',0.00,1021600.00,'Payment Id 173 for invoice:100, receipt: 106 by AA RANO NIGERIA LTD','2022-11-08 11:07:05','',''),('1','294',579,'','2','5',1035110.00,0.00,'Payment Id 172 for invoice:99, receipt: 105 by AA RANO NIGERIA LTD','2022-11-08 11:07:05','',''),('1','294',580,'','supplier','1',0.00,1035110.00,'Payment Id 172 for invoice:99, receipt: 105 by AA RANO NIGERIA 