-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_293
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_293`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_293` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_293`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,7000,'',0,'20','1','293','SALES','','2022-10-18 17:08:49',5,0.00,0.00,'','178','2022-10-18 17:08:49','178',0,0),(2,8000,'',0,'24','1','293','SALARIES','','2022-10-18 17:08:57',5,0.00,0.00,'','178','2022-10-18 17:08:57','178',0,0),(3,8001,'',0,'24','1','293','PURCHASES','','2022-10-18 17:09:08',5,0.00,0.00,'','178','2022-10-18 17:09:08','178',0,0),(4,500,'',0,'6.1','1','293','CASH','','2022-10-18 17:09:20',5,0.00,0.00,'','178','2022-10-18 17:09:20','178',0,0),(5,2500,'',0,'2','1','293','ZENITH  BANK 1014717261','','2022-11-11 10:47:12',5,0.00,0.00,'','975','2022-11-11 10:47:12','975',0,0),(6,2501,'',0,'2','1','293','FIDELITY POS','','2022-11-11 10:50:38',5,0.00,0.00,'','975','2022-11-11 10:50:38','975',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','1','293','DRIVER\'S SHORT','DRIVER','080******123','ds@gmail.com','BAYELSA 2','YENAGOA','BAYELSA 2','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-02 15:40:49',5,'975','2022-11-02 15:40:49','975'),(2,'','1','293','NIGERIA POLICE FORCE (ELECTION','SP UZEBU A. AYANYO','08066436021','dopstransport@gmail.com','YENAGOA','BAYELSA STATE','YENAGOA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-21 17:33:19',5,'975','2023-02-21 17:33:19','975'),(3,'','1','293','NIGERIA POLICE FORCE (ELECTION','SP UZEBU A. AYANYO','08066436021','dopstransport@gmail.com','YENAGOA','BAYELSA STATE','YENAGOA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-21 17:37:25',5,'975','2023-02-21 17:37:25','975');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','293','1',1,'5','PUMP 3',89868.02,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-20 11:09:11','178'),('1','293','1',2,'5','PUMP 4',118037.73,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-20 11:09:37','178'),('1','293','1',3,'5','PUMP 5',123715.25,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-20 11:09:59','178'),('1','293','1',4,'5','PUMP 6',74058.09,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-20 11:10:22','178'),('1','293','1',5,'5','PUMP 9',84225.59,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-20 11:10:48','178'),('1','293','1',6,'5','PUMP 10',177490.47,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-20 11:11:15','178'),('1','293','1',7,'5','PUMP 11',0.00,'DISPENSING PMS',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','293','1',8,'5','PUMP 12',0.00,'DISPENSING PMS',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','293','2',9,'5','PUMP 1',162620.85,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-20 11:12:38','178'),('1','293','2',10,'5','PUMP 2',144507.76,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-20 11:12:58','178'),('1','293','2',11,'5','PUMP 7',166599.95,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-20 11:13:19','178'),('1','293','2',12,'5','PUMP 8',201701.95,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-20 11:13:49','178'),('1','293','3',13,'5','AGO PUMP 1',24.37,'DISPENSING AGO','',NULL,NULL,'',5,'2022-10-20 11:14:38','178'),('1','293','3',14,'5','AGO PUMP 2',32.04,'DISPENSING AGO','',NULL,NULL,'',5,'2022-10-20 11:14:58','178');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=143 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','293',1,'MORNING ','2022-09-27','2022-11-02 22:53:38','2022-11-03 22:53:38','971',1843216.70,1843216.70,'971','2022-11-02 22:59:00','648','2022-11-03 09:56:57',10,0),('1','293',2,'MORNING ','2022-09-28','2022-11-03 21:09:08','2022-11-04 05:09:08','971',1691040.94,1691040.94,'971','2022-11-03 21:14:20','648','2022-11-07 08:25:35',10,0),('1','293',3,'AFTERNOON ','2022-09-28','2022-11-10 16:20:58','2022-11-11 00:20:58','971',1865272.68,1865272.68,'971','2022-11-10 16:27:55','648','2022-11-10 16:31:26',10,0),('1','293',4,'MORNING','2022-09-29','2022-11-10 16:33:29','2022-11-11 00:33:29','971',1819989.48,1819989.48,'971','2022-11-10 16:37:56','648','2022-11-10 16:45:12',10,0),('1','293',5,'AFTERNOON ','2022-09-29','2022-11-10 16:45:59','2022-11-11 00:45:59','971',2175875.56,2175875.56,'971','2022-11-10 16:54:16','648','2022-11-10 16:58:12',10,0),('1','293',6,'MORNING ','2022-09-30','2022-11-10 17:01:01','2022-11-11 03:01:01','971',1920986.68,1920986.68,'971','2022-11-10 17:05:02','648','2022-11-10 17:09:05',10,0),('1','293',7,'AFTERNOON ','2022-09-30','2022-11-10 17:09:59','2022-11-11 01:09:59','971',2146110.40,2146110.40,'971','2022-11-10 17:12:59','648','2022-11-10 17:36:41',10,0),('1','293',8,'MORNING ','2022-10-01','2022-11-11 10:31:13','2022-11-11 18:31:13','971',1838104.54,1838104.54,'971','2022-11-11 10:33:30','648','2022-11-11 10:37:36',10,0),('1','293',9,'AFTERNOON ','2022-10-01','2022-11-11 10:40:05','2022-11-11 18:40:05','971',2113381.54,2113381.54,'971','2022-11-11 10:41:51','648','2022-11-11 12:19:45',10,0),('1','293',10,'MORNING ','2022-10-02','2022-11-11 18:46:12','2022-11-12 02:46:12','971',1618571.80,1618571.80,'971','2022-11-11 18:49:10','648','2022-11-12 08:16:30',10,0),('1','293',11,'AFTERNOON ','2022-10-02','2022-11-12 17:08:51','2022-11-13 01:08:51','971',1692393.74,1692393.74,'971','2022-11-12 17:14:27','648','2022-11-14 09:09:16',10,0),('1','293',12,'MORNING ','2022-10-03','2022-11-14 10:19:43','2022-11-14 18:19:43','971',1757271.18,1757271.18,'971','2022-11-14 10:22:23','648','2022-11-15 21:35:02',10,0),('1','293',13,'AFTERNOON ','2022-10-03','2022-11-16 17:07:26','2022-11-17 01:07:26','971',1643077.06,1643077.06,'971','2022-11-16 17:13:20','648','2022-11-18 06:27:19',10,0),('1','293',14,'MORNING ','2022-10-04','2022-11-19 12:49:06','2022-11-19 20:49:06','971',998930.66,998930.66,'971','2022-11-19 12:51:12','648','2022-11-23 01:31:04',10,0),('1','293',15,'AFTERNOON ','2022-10-04','2022-11-23 17:47:42','2022-11-24 01:47:42','971',408056.10,408056.10,'971','2022-11-23 17:49:02','648','2022-11-24 04:31:02',10,0),('1','293',16,'MORNING ','2022-10-05','2022-11-24 10:16:00','2022-11-24 18:16:00','971',2131422.30,1806634.14,'971','2022-11-24 10:19:32','648','2022-11-24 11:24:08',10,0),('1','293',17,'MORNING ','2022-10-06','2022-11-25 12:15:35','2022-11-25 20:15:35','971',2139267.90,1813284.22,'971','2022-11-25 12:18:27','648','2022-11-25 17:26:36',10,0),('1','293',18,'MORNING ','2022-10-07','2022-11-25 23:58:38','2022-11-26 07:58:38','971',0.00,0.00,'971','2022-11-26 10:02:00','648','2022-11-26 10:04:34',10,0),('1','293',19,'AFTERNOON ','2022-10-06','2022-11-26 10:07:17','2022-11-27 10:07:17','971',2128051.80,1803777.24,'971','2022-11-26 10:10:12','648','2022-11-26 10:14:55',10,0),('1','293',20,'MORNING ','2022-10-07','2022-11-26 10:16:21','2022-11-26 18:16:21','971',2066509.20,1751612.56,'971','2022-11-26 10:19:15','648','2022-11-26 10:26:24',10,0),('1','293',21,'AFTERNOON ','2022-10-07','2022-11-26 10:27:42','2022-11-26 18:27:42','971',2259948.60,1915575.48,'971','2022-11-26 10:30:29','648','2022-11-26 10:39:20',10,0),('1','293',22,'MORNING ','2022-10-08','2022-11-26 10:44:33','2022-11-26 18:44:33','971',2030290.50,1720912.90,'971','2022-11-26 10:48:05','648','2022-11-26 10:49:25',10,0),('1','293',23,'AFTERNOON ','2022-10-08','2022-11-26 10:51:18','2022-11-26 18:51:18','971',2085873.30,1768025.94,'971','2022-11-26 10:57:59','648','2022-11-26 10:59:38',10,0),('1','293',24,'MORNING ','2022-10-09','2022-11-26 11:01:19','2022-11-26 19:01:19','971',1658193.60,1405516.48,'971','2022-11-26 11:04:23','648','2022-11-26 11:05:25',10,0),('1','293',25,'AFTERNOON ','2022-10-09','2022-11-26 11:06:38','2022-11-26 19:06:38','971',2052157.80,1739448.04,'971','2022-11-26 11:10:23','648','2022-11-26 15:17:22',10,0),('1','293',26,'AFTERNOON ','2022-10-10','2022-11-26 23:19:14','2022-11-27 07:19:14','971',2013803.40,1706938.12,'971','2022-11-26 23:24:04','648','2022-11-27 09:19:37',10,0),('1','293',27,'AFTERNOON ','2022-10-10','2022-11-28 10:20:20','2022-11-28 18:20:20','971',1839411.00,1559119.80,'971','2022-11-28 10:25:23','648','2022-11-28 13:57:03',10,0),('1','293',28,'MORNING ','2022-10-11','2022-11-30 12:33:20','2022-11-30 20:33:20','971',2004666.30,1699193.34,'971','2022-11-30 12:36:20','648','2022-11-30 12:49:24',10,0),('1','293',29,'AFTERNOON ','2022-10-11','2022-11-30 13:02:08','2022-11-30 21:02:08','971',2636963.70,2235140.66,'971','2022-11-30 13:05:40','648','2022-11-30 13:06:55',10,0),('1','293',30,'MORNING ','2022-10-12','2022-11-30 13:08:00','2022-11-30 21:08:00','971',2068466.40,1753271.52,'971','2022-11-30 13:10:46','648','2022-11-30 15:21:32',10,0),('1','293',31,'AFTERNOON ','2022-10-12','2022-11-30 22:45:08','2022-12-01 06:45:08','971',265593.30,225121.94,'971','2022-11-30 22:47:17','648','2022-12-01 07:38:38',10,0),('1','293',32,'MORNING ','2022-11-16','2022-12-01 07:48:12','2022-12-01 15:48:12','971',3310139.70,3310139.70,'971','2022-12-01 07:58:41','648','2022-12-01 07:59:38',10,0),('1','293',33,'MORNING ','2022-11-17','2022-12-01 08:01:10','2022-12-01 16:01:10','971',2465450.40,2465450.40,'971','2022-12-01 08:08:14','648','2022-12-01 08:10:53',10,0),('1','293',34,'AFTERNOON ','2022-11-17','2022-12-01 08:12:27','2022-12-01 16:12:27','971',2920747.20,2920747.20,'971','2022-12-01 08:17:01','648','2022-12-01 08:22:37',10,0),('1','293',35,'MORNING ','2022-11-18','2022-12-01 08:24:17','2022-12-01 16:24:17','971',1803263.70,1803263.70,'971','2022-12-01 08:32:10','648','2022-12-01 08:34:51',10,0),('1','293',36,'AFTERNOON ','2022-11-18','2022-12-01 08:46:29','2022-12-01 16:46:29','971',1842363.60,1842363.60,'971','2022-12-01 08:49:02','648','2022-12-01 08:52:33',10,0),('1','293',37,'MORNING ','2022-11-23','2022-12-01 08:54:35','2022-12-01 16:54:35','971',912865.80,912865.80,'971','2022-12-01 08:57:50','648','2022-12-01 08:58:52',10,0),('1','293',38,'AFTERNOON ','2022-11-23','2022-12-01 09:00:34','2022-12-01 17:00:34','971',4402158.60,4402158.60,'971','2022-12-01 09:03:35','648','2022-12-01 09:05:16',10,0),('1','293',39,'MORNING ','2022-11-24','2022-12-01 09:06:51','2022-12-01 19:06:51','971',3302903.10,3302903.10,'971','2022-12-01 09:10:31','648','2022-12-01 09:12:05',10,0),('1','293',40,'AFTERNOON ','2022-11-24','2022-12-01 09:13:10','2022-12-01 17:13:10','971',4294760.40,4294760.40,'971','2022-12-01 09:23:31','648','2022-12-01 09:26:30',10,0),('1','293',41,'MORNING ','2022-11-25','2022-12-01 09:27:56','2022-12-01 19:27:56','971',4151282.10,4151282.10,'971','2022-12-01 09:30:35','648','2022-12-01 09:36:56',10,0),('1','293',42,'AFTERNOON ','2022-11-25','2022-12-01 09:37:39','2022-12-01 17:37:39','971',5281206.00,5281206.00,'971','2022-12-01 09:42:13','648','2022-12-01 09:43:11',10,0),('1','293',43,'MORNING ','2022-12-01','2022-12-01 09:44:20','2022-12-01 17:44:20','971',0.00,0.00,'971','2022-12-01 09:47:48','648','2022-12-01 09:48:55',10,0),('1','293',44,'AFTERNOON ','2022-11-26','2022-12-01 09:50:24','2022-12-01 17:50:24','971',2899722.00,2899722.00,'971','2022-12-01 09:52:38','648','2022-12-01 10:01:13',10,0),('1','293',45,'AFTERNOON ','2022-11-26','2022-12-01 10:02:48','2022-12-01 18:02:48','971',4244373.00,4244373.00,'971','2022-12-01 10:07:51','648','2022-12-01 10:18:51',10,0),('1','293',46,'MORNING ','2022-11-27','2022-12-01 10:19:58','2022-12-01 18:19:58','971',3321843.00,3321843.00,'971','2022-12-01 10:23:33','648','2022-12-01 10:25:57',10,0),('1','293',47,'AFTERNOON ','2022-11-27','2022-12-01 10:27:00','2022-12-01 18:27:00','971',2659091.40,2659091.40,'971','2022-12-01 10:29:08','648','2022-12-01 10:30:06',10,0),('1','293',48,'MORNING ','2022-11-28','2022-12-01 10:30:38','2022-12-01 18:30:38','971',3676732.50,3676732.50,'971','2022-12-01 10:34:05','648','2022-12-01 10:35:24',10,0),('1','293',49,'AFTERNOON ','2022-11-28','2022-12-01 10:36:06','2022-12-01 18:36:06','971',2932150.20,2932150.20,'971','2022-12-01 10:37:36','648','2022-12-01 10:38:40',10,0),('1','293',50,'MONING ','2022-12-02','2022-12-05 15:32:55','2022-12-05 23:32:55','971',2026294.20,2026294.20,'971','2022-12-05 15:34:27','648','2022-12-15 21:49:27',10,0),('1','293',51,'AFTERNOON ','2022-12-05','2022-12-16 10:19:42','2022-12-16 18:19:42','971',0.00,0.00,'971','2022-12-16 15:14:32','648','2022-12-16 15:16:39',10,0),('1','293',52,'AFTERNOON ','2022-12-05','2022-12-16 15:17:43','2022-12-17 15:17:43','971',236049.00,236049.00,'971','2022-12-16 15:20:54','648','2022-12-17 00:18:38',10,0),('1','293',53,'AFTERNOON ','2022-12-15','2022-12-17 11:36:11','2022-12-17 19:36:11','971',2681294.00,2681294.00,'971','2022-12-17 11:44:46','648','2022-12-17 14:58:29',10,0),('1','293',54,'MORNING','2022-12-16','2022-12-17 15:29:37','2022-12-17 23:29:37','971',3430801.90,3430801.90,'971','2022-12-17 15:33:57','648','2022-12-17 15:34:33',10,0),('1','293',55,'AFTERNOON','2022-12-16','2022-12-17 15:36:56','2022-12-17 23:36:56','971',3288151.30,3288151.30,'971','2022-12-17 15:40:01','648','2022-12-17 15:40:26',10,0),('1','293',56,'MONING ','2022-12-18','2022-12-18 15:29:24','2022-12-18 19:29:24','971',1397178.70,1397178.70,'971','2022-12-18 15:33:31','648','2022-12-18 21:05:39',10,0),('1','293',57,'AFTERNOON ','2022-12-18','2022-12-20 11:16:08','2022-12-20 19:16:08','971',2825441.90,2825441.90,'971','2022-12-20 11:20:51','648','2022-12-21 07:56:24',10,0),('1','293',58,'MONING ','2022-12-23','2022-12-23 18:43:15','2022-12-24 02:43:15','971',3724916.70,3724916.70,'971','2022-12-23 18:48:47','648','2022-12-24 06:56:37',10,0),('1','293',59,'AFTERNOON ','2022-12-23','2022-12-24 11:13:40','2022-12-24 19:13:40','971',2238748.80,2238748.80,'971','2022-12-24 11:15:38','648','2022-12-24 23:11:25',10,0),('1','293',60,'MONING ','2022-12-25','2022-12-25 13:24:32','2022-12-25 21:24:32','971',1886966.40,1886966.40,'971','2022-12-25 13:25:46','648','2022-12-25 22:10:44',10,0),('1','293',61,'MORNING','2022-12-29','2022-12-29 16:39:19','2022-12-30 00:39:19','971',917479.20,917479.20,'971','2022-12-29 16:40:40','648','2022-12-31 06:59:30',10,0),('1','293',62,'AFTERNOON ','2022-12-31','2023-01-01 10:26:28','2023-01-02 10:26:28','971',2441904.00,2441904.00,'971','2023-01-01 10:27:11','648','2023-01-05 05:08:26',10,0),('1','293',63,'MORNING','2023-01-07','2023-01-07 17:12:37','2023-01-08 01:12:37','971',0.00,0.00,'971','2023-01-08 16:59:18','648','2023-01-08 17:08:01',10,0),('1','293',64,'MORNING','2023-01-07','2023-01-08 17:17:10','2023-01-08 18:17:10','971',766219.68,766219.68,'971','2023-01-08 17:21:04','648','2023-01-08 17:27:03',10,0),('1','293',65,'AFTERNOON ','2023-01-07','2023-01-09 08:34:21','2023-01-09 16:34:21','971',794061.60,794061.60,'971','2023-01-09 08:40:54','648','2023-01-10 15:03:14',10,0),('1','293',66,'MORNING','2023-01-08','2023-01-10 17:25:03','2023-01-11 01:25:03','971',1502114.40,1502114.40,'971','2023-01-10 17:28:16','648','2023-01-11 07:00:30',10,0),('1','293',67,'AFTERNOON ','2023-01-08','2023-01-11 13:40:09','2023-01-11 21:40:09','971',581088.00,581088.00,'971','2023-01-11 13:43:55','648','2023-01-11 14:34:42',10,0),('1','293',68,'MORNING','2023-01-11','2023-01-11 18:46:46','2023-01-12 02:46:46','971',1685690.40,1685690.40,'971','2023-01-11 18:49:21','648','2023-01-12 07:01:20',10,0),('1','293',69,'AFTERNOON ','2023-01-12','2023-01-13 12:28:26','2023-01-13 20:28:26','971',3326061.60,3326061.60,'971','2023-01-13 15:56:55','648','2023-01-13 23:59:13',10,0),('1','293',70,'MORNING','2023-01-13','2023-01-14 14:10:23','2023-01-14 22:10:23','971',1859337.60,1859337.60,'971','2023-01-14 14:21:05','648','2023-01-14 14:59:56',10,0),('1','293',71,'AFTERNOON ','2023-01-13','2023-01-15 13:20:51','2023-01-15 21:20:51','971',424848.00,424848.00,'971','2023-01-15 13:23:52','648','2023-01-15 21:37:07',10,0),('1','293',72,'MORNING','2023-01-14','2023-01-16 09:06:31','2023-01-16 17:06:31','971',3608870.40,3608870.40,'971','2023-01-16 09:12:36','648','2023-01-16 13:47:06',10,0),('1','293',73,'MORNING','2023-01-15','2023-01-16 17:12:54','2023-01-17 01:12:54','971',2257027.20,2257027.20,'971','2023-01-16 17:16:30','648','2023-01-17 06:17:30',10,0),('1','293',74,'MORNING','2023-01-16','2023-01-17 10:11:50','2023-01-17 18:11:50','971',1424167.20,1424167.20,'971','2023-01-17 10:19:04','648','2023-01-17 10:49:59',10,0),('1','293',75,'MORNING','2023-01-17','2023-01-17 15:29:41','2023-01-17 23:29:41','971',519076.80,519076.80,'971','2023-01-17 15:31:07','648','2023-01-17 17:18:49',10,0),('1','293',76,'MORNING','2023-01-17','2023-01-18 10:26:30','2023-01-18 18:26:30','971',0.00,0.00,'971','2023-01-19 10:59:38','648','2023-01-20 09:16:20',10,0),('1','293',77,'AFTERNOON ','2023-01-17','2023-01-21 08:15:26','2023-01-21 16:15:26','971',2024109.60,2024109.60,'971','2023-01-21 08:22:00','648','2023-01-21 22:01:35',10,0),('1','293',78,'MORNING','2023-01-18','2023-01-23 11:00:40','2023-01-23 19:00:40','971',1557309.60,1557309.60,'971','2023-01-23 11:02:51','648','2023-01-23 16:55:23',10,0),('1','293',79,'AFTERNOON ','2023-01-18','2023-01-24 11:58:39','2023-01-24 19:58:39','971',1282344.00,1282344.00,'971','2023-01-24 12:26:46','648','2023-01-24 12:52:59',10,0),('1','293',80,'MORNING','2023-01-19','2023-01-24 13:06:18','2023-01-24 21:06:18','971',1572256.80,1572256.80,'971','2023-01-24 13:09:21','648','2023-01-24 13:10:36',10,0),('1','293',81,'AFTERNOON ','2023-01-19','2023-01-24 13:12:26','2023-01-24 21:12:26','971',1877196.00,1877196.00,'971','2023-01-24 13:14:02','648','2023-01-24 13:40:55',10,0),('1','293',82,'MORNING','2023-01-20','2023-01-24 13:42:51','2023-01-25 13:42:51','971',833148.00,833148.00,'971','2023-01-24 13:44:03','648','2023-01-24 14:20:47',10,0),('1','293',83,'MORNING','2023-01-21','2023-01-24 19:51:44','2023-01-25 03:51:44','971',1674576.00,1674576.00,'971','2023-01-24 19:53:53','648','2023-01-25 08:35:18',10,0),('1','293',84,'AFTERNOON ','2023-01-21','2023-01-25 12:03:17','2023-01-26 12:03:17','971',1327264.80,1327264.80,'971','2023-01-25 12:05:15','648','2023-01-25 12:32:05',10,0),('1','293',85,'MORNING','2023-01-22','2023-01-25 15:42:37','2023-01-26 01:42:37','971',928423.20,889738.90,'971','2023-01-25 15:47:55','648','2023-01-26 07:03:43',10,0),('1','293',86,'MORNING','2023-01-23','2023-01-26 09:26:13','2023-01-27 09:26:13','971',1549072.80,1484528.10,'971','2023-01-26 09:27:21','648','2023-01-26 19:34:05',10,0),('1','293',87,'AFTERNOON ','2023-01-24','2023-01-26 21:51:20','2023-01-27 05:51:20','971',2184432.00,2184432.00,'971','2023-01-26 21:55:08','648','2023-01-27 09:54:33',10,0),('1','293',88,'MORNING','2023-01-28','2023-01-31 17:08:47','2023-02-01 17:08:47','971',186242.40,186242.40,'971','2023-01-31 17:10:10','648','2023-02-06 10:18:43',10,0),('1','293',89,'MORNING','2023-02-06','2023-02-07 10:34:55','2023-02-07 18:34:55','971',1796689.70,1796689.70,'971','2023-02-07 10:38:20','648','2023-02-07 14:01:58',10,0),('1','293',90,'AFTERNOON ','2023-02-06','2023-02-07 14:03:11','2023-02-07 22:03:11','971',730997.20,730997.20,'971','2023-02-07 14:08:39','648','2023-02-08 08:04:17',10,0),('1','293',91,'AFTERNOON ','2023-02-07','2023-02-08 11:00:26','2023-02-08 19:00:26','971',4031126.15,4031126.15,'971','2023-02-08 11:05:22','648','2023-02-08 14:20:52',10,0),('1','293',92,'MORNING','2023-02-08','2023-02-08 14:29:34','2023-02-08 22:29:34','971',2576995.55,2576995.55,'971','2023-02-08 14:38:23','648','2023-02-08 21:18:29',10,0),('1','293',93,'AFTERNOON ','2023-02-08','2023-02-09 12:11:02','2023-02-09 20:11:02','971',4038124.85,4038124.85,'971','2023-02-09 12:17:31','648','2023-02-09 23:34:41',10,0),('1','293',94,'MORNING','2023-02-09','2023-02-10 12:06:55','2023-02-10 20:06:55','971',2309167.15,2309167.15,'971','2023-02-10 12:09:33','648','2023-02-10 12:14:38',10,0),('1','293',95,'AFTERNOON ','2023-02-09','2023-02-10 12:19:48','2023-02-10 13:19:48','971',1505163.30,1505163.30,'971','2023-02-10 12:23:49','648','2023-02-11 06:33:07',10,0),('1','293',96,'MORNING','2023-02-10','2023-02-11 12:43:47','2023-02-11 20:43:47','971',1498570.50,1498570.50,'971','2023-02-11 12:45:26','648','2023-02-11 16:53:44',10,0),('1','293',97,'MORNING','2023-02-11','2023-02-12 17:52:40','2023-02-13 01:52:40','971',1271649.85,1271649.85,'971','2023-02-12 17:53:40','648','2023-02-13 15:20:43',10,0),('1','293',98,'AFTERNOON ','2023-02-12','2023-02-13 19:33:07','2023-02-14 19:33:07','971',564449.05,564449.05,'971','2023-02-13 19:36:38','648','2023-02-14 06:23:55',10,0),('1','293',99,'MORNING','2023-02-13','2023-02-14 13:51:06','2023-02-14 21:51:06','971',2150425.40,2150425.40,'971','2023-02-14 13:55:21','648','2023-02-15 06:20:31',10,0),('1','293',100,'AFTERNOON ','2023-02-14','2023-02-15 13:28:28','2023-02-16 13:28:28','971',2534402.70,2534402.70,'971','2023-02-15 13:31:22','648','2023-02-16 08:24:23',10,0),('1','293',101,'MORNING','2023-02-15','2023-02-22 19:20:09','2023-02-23 03:20:09','971',1286741.95,1286741.95,'971','2023-02-22 19:21:47','648','2023-02-22 22:22:16',10,0),('1','293',102,'MORNING','2023-02-18','2023-02-24 11:53:31','2023-02-25 11:53:31','971',142860.40,142860.40,'971','2023-02-24 11:55:25','648','2023-02-24 22:29:07',10,0),('1','293',103,'MORNING','2023-02-26','2023-02-26 15:56:11','2023-02-26 16:56:11','971',365941.40,365941.40,'971','2023-02-26 15:57:00','648','2023-02-27 08:18:53',10,0),('1','293',104,'MORNING','2023-02-27','2023-02-27 16:51:46','2023-02-28 00:51:46','971',0.00,0.00,'971','2023-03-01 11:38:26','648','2023-03-01 14:44:21',10,0),('1','293',105,'MORNING','2023-02-27','2023-03-01 15:34:19','2023-03-01 23:34:19','971',1833587.50,1638525.00,'971','2023-03-01 15:38:10','648','2023-03-01 15:39:01',10,0),('1','293',106,'AFTERNOON ','2023-02-27','2023-03-01 15:40:02','2023-03-01 16:40:02','971',1874808.85,1675361.10,'971','2023-03-01 15:41:48','648','2023-03-01 15:48:25',10,0),('1','293',107,'MORNING','2023-02-28','2023-03-01 15:51:53','2023-03-01 23:51:53','971',360407.75,322066.50,'971','2023-03-01 15:52:55','648','2023-03-01 15:57:13',10,0),('1','293',108,'MORNING 1','2023-03-01','2023-03-01 16:03:22','2023-03-02 00:03:22','971',103573.90,92555.40,'971','2023-03-01 16:04:23','648','2023-03-01 16:16:39',10,0),('1','293',109,'AFTERNOON ','2023-03-01','2023-03-02 17:05:15','2023-03-03 01:05:15','971',3774656.95,3774656.95,'971','2023-03-02 17:10:27','648','2023-03-03 09:56:07',10,0),('1','293',110,'MORNING','2023-03-02','2023-03-03 10:56:15','2023-03-03 18:56:15','971',1567981.10,1567981.10,'971','2023-03-03 11:00:06','648','2023-03-03 12:24:15',10,0),('1','293',111,'AFTERNOON ','2023-03-02','2023-03-04 12:45:25','2023-03-04 13:45:25','971',3414061.20,3414061.20,'971','2023-03-04 12:56:54','648','2023-03-05 07:23:27',10,0),('1','293',112,'MORNING','2023-03-03','2023-03-05 13:40:29','2023-03-05 21:40:29','971',1007198.25,1007198.25,'971','2023-03-05 13:42:34','648','2023-03-05 14:31:39',10,0),('1','293',113,'AFTERNOON ','2023-03-03','2023-03-05 14:37:37','2023-03-05 22:37:37','971',3064740.75,3064740.75,'971','2023-03-05 14:44:18','648','2023-03-05 14:59:39',10,0),('1','293',114,'MORNING','2023-03-04','2023-03-05 15:02:27','2023-03-05 23:02:27','971',852269.80,852269.80,'971','2023-03-05 15:05:53','648','2023-03-05 15:18:03',10,0),('1','293',115,'AFTERNOON ','2023-03-04','2023-03-06 17:13:28','2023-03-07 01:13:28','971',4734951.55,4734951.55,'971','2023-03-06 17:18:27','648','2023-03-06 23:06:43',10,0),('1','293',116,'MORNING','2023-03-05','2023-03-07 10:54:12','2023-03-07 18:54:12','971',831392.40,831392.40,'971','2023-03-07 10:55:28','648','2023-03-07 11:28:32',10,0),('1','293',117,'MORNING','2023-03-06','2023-03-08 15:21:25','2023-03-08 23:21:25','971',0.00,0.00,'971','2023-03-08 15:23:32','648','2023-03-08 16:59:54',10,0),('1','293',118,'AFTERNOON ','2023-03-05','2023-03-09 12:05:33','2023-03-09 20:05:33','971',3143531.55,3143531.55,'971','2023-03-09 12:08:38','648','2023-03-09 12:20:06',10,0),('1','293',119,'MORNING','2023-03-06','2023-03-09 12:20:51','2023-03-09 20:20:51','971',4292014.15,4292014.15,'971','2023-03-09 12:24:39','648','2023-03-09 12:26:17',10,0),('1','293',120,'MORNING','2023-03-07','2023-03-09 12:28:38','2023-03-09 20:28:38','971',2124381.20,2124381.20,'971','2023-03-09 12:31:19','648','2023-03-09 12:32:16',10,0),('1','293',121,'AFTERNOON ','2023-03-07','2023-03-09 12:34:28','2023-03-09 20:34:28','971',2660829.80,2660829.80,'971','2023-03-09 12:37:35','648','2023-03-09 12:39:05',10,0),('1','293',122,'MORNING','2023-03-08','2023-03-09 12:44:22','2023-03-09 20:44:22','971',5051896.05,5051896.05,'971','2023-03-09 12:49:07','648','2023-03-09 16:24:38',10,0),('1','293',123,'MORNING','2023-03-09','2023-03-10 10:07:28','2023-03-10 18:07:28','971',2355649.40,2355649.40,'971','2023-03-10 10:09:42','648','2023-03-10 13:16:18',10,0),('1','293',124,'AFTERNOON ','2023-03-09','2023-03-10 18:02:02','2023-03-11 02:02:02','971',3631459.70,3631459.70,'971','2023-03-10 18:08:02','648','2023-03-11 08:21:00',10,0),('1','293',125,'MORNING','2023-03-10','2023-03-11 13:09:26','2023-03-11 21:09:26','971',3591747.05,3591747.05,'971','2023-03-11 13:15:53','648','2023-03-11 17:07:29',10,0),('1','293',126,'AFTERNOON ','2023-03-10','2023-03-11 23:59:21','2023-03-12 09:59:21','971',3001022.85,3001022.85,'971','2023-03-12 00:03:25','648','2023-03-12 06:46:40',10,0),('1','293',127,'MORNING','2023-03-11','2023-03-12 12:04:37','2023-03-12 22:04:37','971',2969873.60,2969873.60,'971','2023-03-12 12:08:09','648','2023-03-12 21:47:55',10,0),('1','293',128,'AFTERNOON ','2023-03-11','2023-03-13 14:54:22','2023-03-14 00:54:22','971',3016001.75,3016001.75,'971','2023-03-13 15:00:15','648','2023-03-13 17:46:05',10,0),('1','293',129,'MORNING','2023-03-12','2023-03-14 14:49:15','2023-03-14 22:49:15','971',1581813.20,1581813.20,'971','2023-03-14 14:53:16','648','2023-03-14 18:30:28',10,0),('1','293',130,'AFTERNOON ','2023-03-12','2023-03-14 23:52:52','2023-03-15 09:52:52','971',1251816.80,1251816.80,'971','2023-03-14 23:56:28','648','2023-03-15 06:53:59',10,0),('1','293',131,'MORNING','2023-03-13','2023-03-15 07:08:39','2023-03-15 13:08:39','971',3221029.85,3221029.85,'971','2023-03-15 07:12:18','648','2023-03-15 09:05:18',10,0),('1','293',132,'MORNING','2023-03-14','2023-03-15 09:58:39','2023-03-15 19:58:39','971',0.00,0.00,'971','2023-03-15 10:01:42','975','2023-03-15 10:09:08',10,0),('1','293',133,'AFTERNOON ','2023-03-13','2023-03-15 10:13:40','2023-03-15 20:13:40','971',2085679.05,2085679.05,'971','2023-03-15 10:16:40','975','2023-03-15 10:19:28',10,0),('1','293',134,'MORNING','2023-03-14','2023-03-15 10:27:01','2023-03-15 16:27:01','971',3163819.10,3163819.10,'971','2023-03-15 10:30:51','648','2023-03-15 18:15:42',10,0),('1','293',135,'AFTERNOON ','2023-03-14','2023-03-15 23:59:12','2023-03-16 05:59:12','971',2997728.15,2997728.15,'971','2023-03-16 00:04:11','648','2023-03-16 09:07:13',10,0),('1','293',136,'MORNING','2023-03-15','2023-03-16 11:16:46','2023-03-16 21:16:46','971',5168444.30,5168444.30,'971','2023-03-16 11:22:15','648','2023-03-16 12:19:57',10,0),('1','293',137,'AFTERNOON ','2023-03-15','2023-03-16 12:21:40','2023-03-16 22:21:40','971',3392603.35,3392603.35,'971','2023-03-16 12:25:47','648','2023-03-16 12:28:27',10,0),('1','293',138,'MORNING','2023-03-16','2023-03-16 21:22:00','2023-03-17 07:22:00','971',3313532.90,3313532.90,'971','2023-03-16 21:25:09','648','2023-03-16 22:01:43',10,0),('1','293',139,'AFTERNOON ','2023-03-16','2023-03-17 07:52:00','2023-03-17 13:52:00','971',3495397.05,3495397.05,'971','2023-03-17 07:57:27','648','2023-03-17 21:31:21',10,0),('1','293',140,'MORNING','2023-03-17','2023-03-17 23:01:22','2023-03-18 05:01:22','971',3259910.60,3259910.60,'971','2023-03-17 23:06:50','648','2023-03-18 07:16:42',10,0),('1','293',141,'AFTERNOON ','2023-03-17','2023-03-18 10:31:34','2023-03-18 16:31:34','971',2426572.40,2426572.40,'971','2023-03-18 10:34:21','648','2023-03-20 08:10:15',10,0),('1','293',142,'MORNING','2023-03-20','2023-03-21 00:34:44','2023-03-21 06:34:44','971',3302353.95,3161828.25,'971','2023-03-21 00:37:59','','0000-00-00 00:00:00',5,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=1989 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','293','1','1',1,'1','1',49.23,732.76,683.53,121668.34,0.00,0.00,0.00,0.00,0.00),('1','293','1','1',2,'2','1',34.74,653.82,619.08,110196.24,0.00,0.00,0.00,0.00,0.00),('1','293','1','1',3,'3','1',35.64,1815.14,1779.50,316751.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','1',4,'4','1',19.40,707.15,687.75,122419.50,0.00,0.00,0.00,0.00,0.00),('1','293','1','1',5,'5','1',66.80,980.72,913.92,162677.76,0.00,0.00,0.00,0.00,0.00),('1','293','1','1',6,'6','1',240.24,1191.84,951.60,169384.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','1',7,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','1',8,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','1',9,'9','1',64.50,1310.34,1245.84,221759.52,0.00,0.00,0.00,0.00,0.00),('1','293','2','1',10,'10','1',69.31,1221.97,1152.66,205173.48,0.00,0.00,0.00,0.00,0.00),('1','293','2','1',11,'11','1',23.40,1348.97,1325.57,235951.46,0.00,0.00,0.00,0.00,0.00),('1','293','2','1',12,'12','1',20.69,1016.39,995.70,177234.60,0.00,0.00,0.00,0.00,0.00),('1','293','3','1',13,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','1',14,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','2',15,'1','1',732.76,1572.59,839.83,149489.74,0.00,0.00,0.00,0.00,0.00),('1','293','1','2',16,'2','1',653.82,1281.31,627.49,111693.22,0.00,0.00,0.00,0.00,0.00),('1','293','1','2',17,'3','1',1815.14,3118.64,1303.50,232023.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','2',18,'4','1',707.15,1212.26,505.11,89909.58,0.00,0.00,0.00,0.00,0.00),('1','293','1','2',19,'5','1',980.72,1467.38,486.66,86625.48,0.00,0.00,0.00,0.00,0.00),('1','293','1','2',20,'6','1',1191.84,1673.79,481.95,85787.10,0.00,0.00,0.00,0.00,0.00),('1','293','1','2',21,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','2',22,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','2',23,'9','1',1310.34,2813.01,1502.67,267475.26,0.00,0.00,0.00,0.00,0.00),('1','293','2','2',24,'10','1',1221.97,2733.46,1511.49,269045.22,0.00,0.00,0.00,0.00,0.00),('1','293','2','2',25,'11','1',1348.97,2560.40,1211.43,215634.54,0.00,0.00,0.00,0.00,0.00),('1','293','2','2',26,'12','1',1016.39,2046.49,1030.10,183357.80,0.00,0.00,0.00,0.00,0.00),('1','293','3','2',27,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','2',28,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','3',29,'1','1',1572.59,2422.09,849.50,151211.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','3',30,'2','1',1281.31,2026.82,745.51,132700.78,0.00,0.00,0.00,0.00,0.00),('1','293','1','3',31,'3','1',3118.64,4397.97,1279.33,227720.74,0.00,0.00,0.00,0.00,0.00),('1','293','1','3',32,'4','1',1212.26,2220.53,1008.27,179472.06,0.00,0.00,0.00,0.00,0.00),('1','293','1','3',33,'5','1',1467.38,2276.27,808.89,143982.42,0.00,0.00,0.00,0.00,0.00),('1','293','1','3',34,'6','1',1673.79,2542.44,868.65,154619.70,0.00,0.00,0.00,0.00,0.00),('1','293','1','3',35,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','3',36,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','3',37,'9','1',2813.01,3790.82,977.81,174050.18,0.00,0.00,0.00,0.00,0.00),('1','293','2','3',38,'10','1',2733.46,4185.74,1452.28,258505.84,0.00,0.00,0.00,0.00,0.00),('1','293','2','3',39,'11','1',2560.40,3631.10,1070.70,190584.60,0.00,0.00,0.00,0.00,0.00),('1','293','2','3',40,'12','1',2046.49,3464.61,1418.12,252425.36,0.00,0.00,0.00,0.00,0.00),('1','293','3','3',41,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','3',42,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','4',43,'1','1',2422.09,3084.04,661.95,117827.10,0.00,0.00,0.00,0.00,0.00),('1','293','1','4',44,'2','1',2026.82,2578.09,551.27,98126.06,0.00,0.00,0.00,0.00,0.00),('1','293','1','4',45,'3','1',4397.97,5416.75,1018.78,181342.84,0.00,0.00,0.00,0.00,0.00),('1','293','1','4',46,'4','1',2220.53,3035.91,815.38,145137.64,0.00,0.00,0.00,0.00,0.00),('1','293','1','4',47,'5','1',2276.27,2954.22,677.95,120675.10,0.00,0.00,0.00,0.00,0.00),('1','293','1','4',48,'6','1',2542.44,3564.23,1021.79,181878.62,0.00,0.00,0.00,0.00,0.00),('1','293','1','4',49,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','4',50,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','4',51,'9','1',3790.82,5618.86,1828.04,325391.12,0.00,0.00,0.00,0.00,0.00),('1','293','2','4',52,'10','1',4185.74,5059.98,874.24,155614.72,0.00,0.00,0.00,0.00,0.00),('1','293','2','4',53,'11','1',3631.10,5146.32,1515.22,269709.16,0.00,0.00,0.00,0.00,0.00),('1','293','2','4',54,'12','1',3464.61,4724.65,1260.04,224287.12,0.00,0.00,0.00,0.00,0.00),('1','293','3','4',55,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','4',56,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','5',57,'1','1',3084.04,4471.04,1387.00,246886.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','5',58,'2','1',2578.09,3541.44,963.35,171476.30,0.00,0.00,0.00,0.00,0.00),('1','293','1','5',59,'3','1',5416.75,7565.23,2148.48,382429.44,0.00,0.00,0.00,0.00,0.00),('1','293','1','5',60,'4','1',3035.91,4067.31,1031.40,183589.20,0.00,0.00,0.00,0.00,0.00),('1','293','1','5',61,'5','1',2954.22,3951.27,997.05,177474.90,0.00,0.00,0.00,0.00,0.00),('1','293','1','5',62,'6','1',3564.23,4454.95,890.72,158548.16,0.00,0.00,0.00,0.00,0.00),('1','293','1','5',63,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','5',64,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','5',65,'9','1',5618.86,6783.49,1164.63,207304.14,0.00,0.00,0.00,0.00,0.00),('1','293','2','5',66,'10','1',5059.98,6280.69,1220.71,217286.38,0.00,0.00,0.00,0.00,0.00),('1','293','2','5',67,'11','1',5146.32,6507.53,1361.21,242295.38,0.00,0.00,0.00,0.00,0.00),('1','293','2','5',68,'12','1',4724.65,5784.12,1059.47,188585.66,0.00,0.00,0.00,0.00,0.00),('1','293','3','5',69,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','5',70,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','6',71,'1','1',4471.04,4471.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','6',72,'2','1',3541.44,5686.81,2145.37,381875.86,0.00,0.00,0.00,0.00,0.00),('1','293','1','6',73,'3','1',7565.23,7565.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','6',74,'4','1',4067.31,6032.08,1964.77,349729.06,0.00,0.00,0.00,0.00,0.00),('1','293','1','6',75,'5','1',3951.27,5881.31,1930.04,343547.12,0.00,0.00,0.00,0.00,0.00),('1','293','1','6',76,'6','1',4454.95,4454.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','6',77,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','6',78,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','6',79,'9','1',6783.49,8832.84,2049.35,364784.30,0.00,0.00,0.00,0.00,0.00),('1','293','2','6',80,'10','1',6280.69,6280.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','6',81,'11','1',6507.53,9210.06,2702.53,481050.34,0.00,0.00,0.00,0.00,0.00),('1','293','2','6',82,'12','1',5784.12,5784.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','6',83,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','6',84,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','7',85,'1','1',4471.04,7360.76,2889.72,514370.16,0.00,0.00,0.00,0.00,0.00),('1','293','1','7',86,'2','1',5686.81,5686.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','7',87,'3','1',7565.23,9978.48,2413.25,429558.50,0.00,0.00,0.00,0.00,0.00),('1','293','1','7',88,'4','1',6032.08,6032.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','7',89,'5','1',5881.31,5881.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','7',90,'6','1',4454.95,6448.01,1993.06,354764.68,0.00,0.00,0.00,0.00,0.00),('1','293','1','7',91,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','7',92,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','7',93,'9','1',8832.84,8832.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','7',94,'10','1',6280.69,8667.22,2386.53,424802.34,0.00,0.00,0.00,0.00,0.00),('1','293','2','7',95,'11','1',9210.06,9210.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','7',96,'12','1',5784.12,8158.36,2374.24,422614.72,0.00,0.00,0.00,0.00,0.00),('1','293','3','7',97,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','7',98,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','8',99,'1','1',7360.76,7360.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','8',100,'2','1',5686.81,7540.04,1853.23,329874.94,0.00,0.00,0.00,0.00,0.00),('1','293','1','8',101,'3','1',9978.48,9978.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','8',102,'4','1',6032.08,7964.44,1932.36,343960.08,0.00,0.00,0.00,0.00,0.00),('1','293','1','8',103,'5','1',5881.31,7917.48,2036.17,362438.26,0.00,0.00,0.00,0.00,0.00),('1','293','1','8',104,'6','1',6448.01,6448.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','8',105,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','8',106,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','8',107,'9','1',8832.84,10924.20,2091.36,372262.08,0.00,0.00,0.00,0.00,0.00),('1','293','2','8',108,'10','1',8667.22,8667.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','8',109,'11','1',9210.06,11623.37,2413.31,429569.18,0.00,0.00,0.00,0.00,0.00),('1','293','2','8',110,'12','1',8158.36,8158.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','8',111,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','8',112,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','9',113,'1','1',7360.76,10094.10,2733.34,486534.52,0.00,0.00,0.00,0.00,0.00),('1','293','1','9',114,'2','1',7540.04,7540.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','9',115,'3','1',9978.48,12397.56,2419.08,430596.24,0.00,0.00,0.00,0.00,0.00),('1','293','1','9',116,'4','1',7964.44,7964.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','9',117,'5','1',7917.48,7917.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','9',118,'6','1',6448.01,8284.99,1836.98,326982.44,0.00,0.00,0.00,0.00,0.00),('1','293','1','9',119,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','9',120,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','9',121,'9','1',10924.20,10924.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','9',122,'10','1',8667.22,11233.46,2566.24,456790.72,0.00,0.00,0.00,0.00,0.00),('1','293','2','9',123,'11','1',11623.37,11623.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','9',124,'12','1',8158.36,10475.65,2317.29,412477.62,0.00,0.00,0.00,0.00,0.00),('1','293','3','9',125,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','9',126,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','10',127,'1','1',10094.10,11819.79,1725.69,307172.82,0.00,0.00,0.00,0.00,0.00),('1','293','1','10',128,'2','1',7540.04,7540.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','10',129,'3','1',12397.56,12397.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','10',130,'4','1',7964.44,9389.51,1425.07,253662.46,0.00,0.00,0.00,0.00,0.00),('1','293','1','10',131,'5','1',7917.48,9639.27,1721.79,306478.62,0.00,0.00,0.00,0.00,0.00),('1','293','1','10',132,'6','1',8284.99,8284.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','10',133,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','10',134,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','10',135,'9','1',10924.20,12745.06,1820.86,324113.08,0.00,0.00,0.00,0.00,0.00),('1','293','2','10',136,'10','1',11233.46,11233.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','10',137,'11','1',11623.37,14023.06,2399.69,427144.82,0.00,0.00,0.00,0.00,0.00),('1','293','2','10',138,'12','1',10475.65,10475.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','10',139,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','10',140,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','11',141,'1','1',11819.79,11819.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','11',142,'2','1',7540.04,8742.10,1202.06,213966.68,0.00,0.00,0.00,0.00,0.00),('1','293','1','11',143,'3','1',12397.56,14822.56,2425.00,431650.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','11',144,'4','1',9389.51,9389.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','11',145,'5','1',9639.27,9639.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','11',146,'6','1',8284.99,9599.62,1314.63,234004.14,0.00,0.00,0.00,0.00,0.00),('1','293','1','11',147,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','11',148,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','11',149,'9','1',12745.06,14353.26,1608.20,286259.60,0.00,0.00,0.00,0.00,0.00),('1','293','2','11',150,'10','1',11233.46,12586.06,1352.60,240762.80,0.00,0.00,0.00,0.00,0.00),('1','293','2','11',151,'11','1',14023.06,14023.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','11',152,'12','1',10475.65,12080.99,1605.34,285750.52,0.00,0.00,0.00,0.00,0.00),('1','293','3','11',153,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','11',154,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','12',155,'1','1',11819.79,11819.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','12',156,'2','1',8742.10,10208.73,1466.63,261060.14,0.00,0.00,0.00,0.00,0.00),('1','293','1','12',157,'3','1',14822.56,17003.24,2180.68,388161.04,0.00,0.00,0.00,0.00,0.00),('1','293','1','12',158,'4','1',9389.51,9400.75,11.24,2000.72,0.00,0.00,0.00,0.00,0.00),('1','293','1','12',159,'5','1',9639.27,9639.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','12',160,'6','1',9599.62,10976.98,1377.36,245170.08,0.00,0.00,0.00,0.00,0.00),('1','293','1','12',161,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','12',162,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','12',163,'9','1',14353.26,15946.12,1592.86,283529.08,0.00,0.00,0.00,0.00,0.00),('1','293','2','12',164,'10','1',12586.06,12586.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','12',165,'11','1',14023.06,15753.83,1730.77,308077.06,0.00,0.00,0.00,0.00,0.00),('1','293','2','12',166,'12','1',12080.99,13593.76,1512.77,269273.06,0.00,0.00,0.00,0.00,0.00),('1','293','3','12',167,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','12',168,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','13',169,'1','1',11819.79,11845.75,25.96,4620.88,0.00,0.00,0.00,0.00,0.00),('1','293','1','13',170,'2','1',10208.73,10208.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','13',171,'3','1',17003.24,17003.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','13',172,'4','1',9400.75,9415.94,15.19,2703.82,0.00,0.00,0.00,0.00,0.00),('1','293','1','13',173,'5','1',9639.27,9650.78,11.51,2048.78,0.00,0.00,0.00,0.00,0.00),('1','293','1','13',174,'6','1',10976.98,10976.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','13',175,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','13',176,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','13',177,'9','1',15946.12,18312.99,2366.87,421302.86,0.00,0.00,0.00,0.00,0.00),('1','293','2','13',178,'10','1',12586.06,15294.09,2708.03,482029.34,0.00,0.00,0.00,0.00,0.00),('1','293','2','13',179,'11','1',15753.83,18225.91,2472.08,440030.24,0.00,0.00,0.00,0.00,0.00),('1','293','2','13',180,'12','1',13593.76,15224.89,1631.13,290341.14,0.00,0.00,0.00,0.00,0.00),('1','293','3','13',181,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','13',182,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','14',183,'1','1',11845.75,11845.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','14',184,'2','1',10208.73,10208.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','14',185,'3','1',17003.24,17003.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','14',186,'4','1',9415.94,9415.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','14',187,'5','1',9650.78,9650.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','14',188,'6','1',10976.98,10976.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','14',189,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','14',190,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','14',191,'9','1',18312.99,19851.89,1538.90,273924.20,0.00,0.00,0.00,0.00,0.00),('1','293','2','14',192,'10','1',15294.09,16562.27,1268.18,225736.04,0.00,0.00,0.00,0.00,0.00),('1','293','2','14',193,'11','1',18225.91,19612.49,1386.58,246811.24,0.00,0.00,0.00,0.00,0.00),('1','293','2','14',194,'12','1',15224.89,16643.20,1418.31,252459.18,0.00,0.00,0.00,0.00,0.00),('1','293','3','14',195,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','14',196,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','15',197,'1','1',11845.75,11845.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','15',198,'2','1',10208.73,10208.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','15',199,'3','1',17003.24,17003.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','15',200,'4','1',9415.94,9415.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','15',201,'5','1',9650.78,9650.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','15',202,'6','1',10976.98,10976.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','15',203,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','15',204,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','15',205,'9','1',19851.89,20554.77,702.88,125112.64,0.00,0.00,0.00,0.00,0.00),('1','293','2','15',206,'10','1',16562.27,17006.37,444.10,79049.80,0.00,0.00,0.00,0.00,0.00),('1','293','2','15',207,'11','1',19612.49,20255.26,642.77,114413.06,0.00,0.00,0.00,0.00,0.00),('1','293','2','15',208,'12','1',16643.20,17145.90,502.70,89480.60,0.00,0.00,0.00,0.00,0.00),('1','293','3','15',209,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','15',210,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','16',211,'1','1',11845.75,13806.22,1960.47,348963.66,0.00,0.00,0.00,0.00,0.00),('1','293','1','16',212,'2','1',10208.73,10208.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','16',213,'3','1',17003.24,19045.09,2041.85,363449.30,0.00,0.00,0.00,0.00,0.00),('1','293','1','16',214,'4','1',9415.94,9763.91,347.97,61938.66,0.00,0.00,0.00,0.00,0.00),('1','293','1','16',215,'5','1',9650.78,9650.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','16',216,'6','1',10976.98,12424.25,1447.27,257614.06,0.00,0.00,0.00,0.00,0.00),('1','293','1','16',217,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','16',218,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','16',219,'9','1',20554.77,22220.16,1665.39,296439.42,0.00,0.00,0.00,0.00,0.00),('1','293','2','16',220,'10','1',17006.37,17578.53,572.16,101844.48,0.00,0.00,0.00,0.00,0.00),('1','293','2','16',221,'11','1',20255.26,22369.78,2114.52,376384.56,0.00,0.00,0.00,0.00,0.00),('1','293','2','16',222,'12','1',17145.90,17145.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','16',223,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','16',224,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','17',225,'1','1',13806.22,15290.68,1484.46,264233.88,0.00,0.00,0.00,0.00,0.00),('1','293','1','17',226,'2','1',10208.73,11341.40,1132.67,201615.26,0.00,0.00,0.00,0.00,0.00),('1','293','1','17',227,'3','1',19045.09,20440.07,1394.98,248306.44,0.00,0.00,0.00,0.00,0.00),('1','293','1','17',228,'4','1',9763.91,9763.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','17',229,'5','1',9650.78,9650.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','17',230,'6','1',12424.25,14333.35,1909.10,339819.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','17',231,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','17',232,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','17',233,'9','1',22220.16,22245.85,25.69,4572.82,0.00,0.00,0.00,0.00,0.00),('1','293','2','17',234,'10','1',17578.53,20172.28,2593.75,461687.50,0.00,0.00,0.00,0.00,0.00),('1','293','2','17',235,'11','1',22369.78,22369.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','17',236,'12','1',17145.90,18792.24,1646.34,293048.52,0.00,0.00,0.00,0.00,0.00),('1','293','3','17',237,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','17',238,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','18',239,'1','1',15290.68,15290.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','18',240,'2','1',11341.40,11341.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','18',241,'3','1',20440.07,20440.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','18',242,'4','1',9763.91,9763.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','18',243,'5','1',9650.78,9650.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','18',244,'6','1',14333.35,14333.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','18',245,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','18',246,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','18',247,'9','1',22245.85,22245.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','18',248,'10','1',20172.28,20172.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','18',249,'11','1',22369.78,22369.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','18',250,'12','1',18792.24,18792.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','18',251,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','18',252,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','19',253,'1','1',15290.68,17519.94,2229.26,396808.28,0.00,0.00,0.00,0.00,0.00),('1','293','1','19',254,'2','1',11341.40,11341.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','19',255,'3','1',20440.07,20440.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','19',256,'4','1',9763.91,11849.24,2085.33,371188.74,0.00,0.00,0.00,0.00,0.00),('1','293','1','19',257,'5','1',9650.78,11216.53,1565.75,278703.50,0.00,0.00,0.00,0.00,0.00),('1','293','1','19',258,'6','1',14333.35,14333.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','19',259,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','19',260,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','19',261,'9','1',22245.85,24271.60,2025.75,360583.50,0.00,0.00,0.00,0.00,0.00),('1','293','2','19',262,'10','1',20172.28,20172.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','19',263,'11','1',22369.78,24597.27,2227.49,396493.22,0.00,0.00,0.00,0.00,0.00),('1','293','2','19',264,'12','1',18792.24,18792.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','19',265,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','19',266,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','20',267,'1','1',17519.94,18554.54,1034.60,184158.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','20',268,'2','1',11341.40,12495.77,1154.37,205477.86,0.00,0.00,0.00,0.00,0.00),('1','293','1','20',269,'3','1',20440.07,22198.98,1758.91,313085.98,0.00,0.00,0.00,0.00,0.00),('1','293','1','20',270,'4','1',11849.24,11849.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','20',271,'5','1',11216.53,11216.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','20',272,'6','1',14333.35,15860.02,1526.67,271747.26,0.00,0.00,0.00,0.00,0.00),('1','293','1','20',273,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','20',274,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','20',275,'9','1',24271.60,24271.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','20',276,'10','1',20172.28,22659.15,2486.87,442662.86,0.00,0.00,0.00,0.00,0.00),('1','293','2','20',277,'11','1',24597.27,24597.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','20',278,'12','1',18792.24,20671.34,1879.10,334479.80,0.00,0.00,0.00,0.00,0.00),('1','293','3','20',279,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','20',280,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','21',281,'1','1',18554.54,20424.87,1870.33,332918.74,0.00,0.00,0.00,0.00,0.00),('1','293','1','21',282,'2','1',12495.77,12495.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','21',283,'3','1',22198.98,22198.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','21',284,'4','1',11849.24,14690.28,2841.04,505705.12,0.00,0.00,0.00,0.00,0.00),('1','293','1','21',285,'5','1',11216.53,12280.83,1064.30,189445.40,0.00,0.00,0.00,0.00,0.00),('1','293','1','21',286,'6','1',15860.02,15860.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','21',287,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','21',288,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','21',289,'9','1',24271.60,26553.09,2281.49,406105.22,0.00,0.00,0.00,0.00,0.00),('1','293','2','21',290,'10','1',22659.15,22659.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','21',291,'11','1',24597.27,27301.77,2704.50,481401.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','21',292,'12','1',20671.34,20671.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','21',293,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','21',294,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','22',295,'1','1',20424.87,20682.15,257.28,45795.84,0.00,0.00,0.00,0.00,0.00),('1','293','1','22',296,'2','1',12495.77,14108.52,1612.75,287069.50,0.00,0.00,0.00,0.00,0.00),('1','293','1','22',297,'3','1',22198.98,23729.45,1530.47,272423.66,0.00,0.00,0.00,0.00,0.00),('1','293','1','22',298,'4','1',14690.28,14690.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','22',299,'5','1',12280.83,12280.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','22',300,'6','1',15860.02,17870.10,2010.08,357794.24,0.00,0.00,0.00,0.00,0.00),('1','293','1','22',301,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','22',302,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','22',303,'9','1',26553.09,26553.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','22',304,'10','1',22659.15,25320.85,2661.70,473782.60,0.00,0.00,0.00,0.00,0.00),('1','293','2','22',305,'11','1',27301.77,27301.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','22',306,'12','1',20671.34,22267.11,1595.77,284047.06,0.00,0.00,0.00,0.00,0.00),('1','293','3','22',307,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','22',308,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','23',309,'1','1',20682.15,22711.12,2028.97,361156.66,0.00,0.00,0.00,0.00,0.00),('1','293','1','23',310,'2','1',14108.52,14108.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','23',311,'3','1',23729.45,23729.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','23',312,'4','1',14690.28,16861.11,2170.83,386407.74,0.00,0.00,0.00,0.00,0.00),('1','293','1','23',313,'5','1',12280.83,12280.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','23',314,'6','1',17870.10,19611.90,1741.80,310040.40,0.00,0.00,0.00,0.00,0.00),('1','293','1','23',315,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','23',316,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','23',317,'9','1',26553.09,28494.30,1941.21,345535.38,0.00,0.00,0.00,0.00,0.00),('1','293','2','23',318,'10','1',25320.85,25320.86,0.01,1.78,0.00,0.00,0.00,0.00,0.00),('1','293','2','23',319,'11','1',27301.77,27332.67,30.90,5500.20,0.00,0.00,0.00,0.00,0.00),('1','293','2','23',320,'12','1',22267.11,24286.12,2019.01,359383.78,0.00,0.00,0.00,0.00,0.00),('1','293','3','23',321,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','23',322,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','24',323,'1','1',22711.12,22711.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','24',324,'2','1',14108.52,15352.33,1243.81,221398.18,0.00,0.00,0.00,0.00,0.00),('1','293','1','24',325,'3','1',23729.45,24835.50,1106.05,196876.90,0.00,0.00,0.00,0.00,0.00),('1','293','1','24',326,'4','1',16861.11,17656.21,795.10,141527.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','24',327,'5','1',12280.83,12280.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','24',328,'6','1',19611.90,20917.92,1306.02,232471.56,0.00,0.00,0.00,0.00,0.00),('1','293','1','24',329,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','24',330,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','24',331,'9','1',28494.30,28494.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','24',332,'10','1',25320.86,27109.07,1788.21,318301.38,0.00,0.00,0.00,0.00,0.00),('1','293','2','24',333,'11','1',27332.67,27332.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','24',334,'12','1',24286.12,25943.09,1656.97,294940.66,0.00,0.00,0.00,0.00,0.00),('1','293','3','24',335,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','24',336,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','25',337,'1','1',22711.12,24821.10,2109.98,375576.44,0.00,0.00,0.00,0.00,0.00),('1','293','1','25',338,'2','1',15352.33,15352.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','25',339,'3','1',24835.50,24835.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','25',340,'4','1',17656.21,19376.84,1720.63,306272.14,0.00,0.00,0.00,0.00,0.00),('1','293','1','25',341,'5','1',12280.83,12280.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','25',342,'6','1',20917.92,22607.87,1689.95,300811.10,0.00,0.00,0.00,0.00,0.00),('1','293','1','25',343,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','25',344,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','25',345,'9','1',28494.30,30776.67,2282.37,406261.86,0.00,0.00,0.00,0.00,0.00),('1','293','2','25',346,'10','1',27109.07,27109.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','25',347,'11','1',27332.67,29301.92,1969.25,350526.50,0.00,0.00,0.00,0.00,0.00),('1','293','2','25',348,'12','1',25943.09,25943.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','25',349,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','25',350,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','26',351,'1','1',24821.10,24821.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','26',352,'2','1',15352.33,17134.74,1782.41,317268.98,0.00,0.00,0.00,0.00,0.00),('1','293','1','26',353,'3','1',24835.50,24835.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','26',354,'4','1',19376.84,21299.94,1923.10,342311.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','26',355,'5','1',12280.83,12280.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','26',356,'6','1',22607.87,24252.94,1645.07,292822.46,0.00,0.00,0.00,0.00,0.00),('1','293','1','26',357,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','26',358,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','26',359,'9','1',30776.67,33083.07,2306.40,410539.20,0.00,0.00,0.00,0.00,0.00),('1','293','2','26',360,'10','1',27109.07,27109.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','26',361,'11','1',29301.92,31234.48,1932.56,343995.68,0.00,0.00,0.00,0.00,0.00),('1','293','2','26',362,'12','1',25943.09,25943.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','26',363,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','26',364,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','27',365,'1','1',24821.10,26013.04,1191.94,212165.32,0.00,0.00,0.00,0.00,0.00),('1','293','1','27',366,'2','1',17134.74,17271.48,136.74,24339.72,0.00,0.00,0.00,0.00,0.00),('1','293','1','27',367,'3','1',24835.50,26622.07,1786.57,318009.46,0.00,0.00,0.00,0.00,0.00),('1','293','1','27',368,'4','1',21299.94,21299.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','27',369,'5','1',12280.83,12468.94,188.11,33483.58,0.00,0.00,0.00,0.00,0.00),('1','293','1','27',370,'6','1',24252.94,25309.81,1056.87,188122.86,0.00,0.00,0.00,0.00,0.00),('1','293','1','27',371,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','27',372,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','27',373,'9','1',33083.07,34373.47,1290.40,229691.20,0.00,0.00,0.00,0.00,0.00),('1','293','2','27',374,'10','1',27109.07,28647.94,1538.87,273918.86,0.00,0.00,0.00,0.00,0.00),('1','293','2','27',375,'11','1',31234.48,31234.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','27',376,'12','1',25943.09,27512.69,1569.60,279388.80,0.00,0.00,0.00,0.00,0.00),('1','293','3','27',377,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','27',378,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','28',379,'1','1',26013.04,27806.28,1793.24,319196.72,0.00,0.00,0.00,0.00,0.00),('1','293','1','28',380,'2','1',17271.48,17340.39,68.91,12265.98,0.00,0.00,0.00,0.00,0.00),('1','293','1','28',381,'3','1',26622.07,28551.20,1929.13,343385.14,0.00,0.00,0.00,0.00,0.00),('1','293','1','28',382,'4','1',21299.94,21299.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','28',383,'5','1',12468.94,12468.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','28',384,'6','1',25309.81,26922.41,1612.60,287042.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','28',385,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','28',386,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','28',387,'9','1',34373.47,36218.86,1845.39,328479.42,0.00,0.00,0.00,0.00,0.00),('1','293','2','28',388,'10','1',28647.94,28647.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','28',389,'11','1',31234.48,33531.24,2296.76,408823.28,0.00,0.00,0.00,0.00,0.00),('1','293','2','28',390,'12','1',27512.69,27512.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','28',391,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','28',392,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','29',393,'1','1',27806.28,27806.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','29',394,'2','1',17340.39,20088.57,2748.18,489176.04,0.00,0.00,0.00,0.00,0.00),('1','293','1','29',395,'3','1',28551.20,28557.94,6.74,1199.72,0.00,0.00,0.00,0.00,0.00),('1','293','1','29',396,'4','1',21299.94,22963.27,1663.33,296072.74,0.00,0.00,0.00,0.00,0.00),('1','293','1','29',397,'5','1',12468.94,12748.47,279.53,49756.34,0.00,0.00,0.00,0.00,0.00),('1','293','1','29',398,'6','1',26922.41,28603.33,1680.92,299203.76,0.00,0.00,0.00,0.00,0.00),('1','293','1','29',399,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','29',400,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','29',401,'9','1',36218.86,38679.00,2460.14,437904.92,0.00,0.00,0.00,0.00,0.00),('1','293','2','29',402,'10','1',28647.94,30507.00,1859.06,330912.68,0.00,0.00,0.00,0.00,0.00),('1','293','2','29',403,'11','1',33531.24,33531.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','29',404,'12','1',27512.69,29371.76,1859.07,330914.46,0.00,0.00,0.00,0.00,0.00),('1','293','3','29',405,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','29',406,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','30',407,'1','1',27806.28,28137.80,331.52,59010.56,0.00,0.00,0.00,0.00,0.00),('1','293','1','30',408,'2','1',20088.57,21260.45,1171.88,208594.64,0.00,0.00,0.00,0.00,0.00),('1','293','1','30',409,'3','1',28557.94,28557.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','30',410,'4','1',22963.27,22963.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','30',411,'5','1',12748.47,12748.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','30',412,'6','1',28603.33,29902.84,1299.51,231312.78,0.00,0.00,0.00,0.00,0.00),('1','293','1','30',413,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','30',414,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','30',415,'9','1',38679.00,41403.03,2724.03,484877.34,0.00,0.00,0.00,0.00,0.00),('1','293','2','30',416,'10','1',30507.00,31253.71,746.71,132914.38,0.00,0.00,0.00,0.00,0.00),('1','293','2','30',417,'11','1',33531.24,36298.87,2767.63,492638.14,0.00,0.00,0.00,0.00,0.00),('1','293','2','30',418,'12','1',29371.76,30180.32,808.56,143923.68,0.00,0.00,0.00,0.00,0.00),('1','293','3','30',419,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','30',420,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','31',421,'1','1',28137.80,28137.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','31',422,'2','1',21260.45,21260.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','31',423,'3','1',28557.94,28557.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','31',424,'4','1',22963.27,22963.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','31',425,'5','1',12748.47,12748.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','31',426,'6','1',29902.84,30478.04,575.20,102385.60,0.00,0.00,0.00,0.00,0.00),('1','293','1','31',427,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','31',428,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','31',429,'9','1',41403.03,41592.40,189.37,33707.86,0.00,0.00,0.00,0.00,0.00),('1','293','2','31',430,'10','1',31253.71,31447.92,194.21,34569.38,0.00,0.00,0.00,0.00,0.00),('1','293','2','31',431,'11','1',36298.87,36463.11,164.24,29234.72,0.00,0.00,0.00,0.00,0.00),('1','293','2','31',432,'12','1',30180.32,30322.03,141.71,25224.38,0.00,0.00,0.00,0.00,0.00),('1','293','3','31',433,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','31',434,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','32',435,'1','1',28137.80,30753.25,2615.45,549244.50,0.00,0.00,0.00,0.00,0.00),('1','293','1','32',436,'2','1',21260.45,21260.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','32',437,'3','1',28557.94,32077.79,3519.85,739168.50,0.00,0.00,0.00,0.00,0.00),('1','293','1','32',438,'4','1',22963.27,24265.26,1301.99,273417.90,0.00,0.00,0.00,0.00,0.00),('1','293','1','32',439,'5','1',12748.47,12748.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','32',440,'6','1',30478.04,32946.81,2468.77,518441.70,0.00,0.00,0.00,0.00,0.00),('1','293','1','32',441,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','32',442,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','32',443,'9','1',41592.40,43052.39,1459.99,306597.90,0.00,0.00,0.00,0.00,0.00),('1','293','2','32',444,'10','1',31447.92,33072.11,1624.19,341079.90,0.00,0.00,0.00,0.00,0.00),('1','293','2','32',445,'11','1',36463.11,39235.44,2772.33,582189.30,0.00,0.00,0.00,0.00,0.00),('1','293','2','32',446,'12','1',30322.03,30322.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','32',447,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','32',448,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','33',449,'1','1',30753.25,30753.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','33',450,'2','1',21260.45,23260.70,2000.25,420052.50,0.00,0.00,0.00,0.00,0.00),('1','293','1','33',451,'3','1',32077.79,34484.24,2406.45,505354.50,0.00,0.00,0.00,0.00,0.00),('1','293','1','33',452,'4','1',24265.26,24265.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','33',453,'5','1',12748.47,12748.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','33',454,'6','1',32946.81,35325.73,2378.92,499573.20,0.00,0.00,0.00,0.00,0.00),('1','293','1','33',455,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','33',456,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','33',457,'9','1',43052.39,43052.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','33',458,'10','1',33072.11,35877.43,2805.32,589117.20,0.00,0.00,0.00,0.00,0.00),('1','293','2','33',459,'11','1',39235.44,39235.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','33',460,'12','1',30322.03,32471.33,2149.30,451353.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','33',461,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','33',462,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','34',463,'1','1',30753.25,33303.12,2549.87,535472.70,0.00,0.00,0.00,0.00,0.00),('1','293','1','34',464,'2','1',23260.70,23260.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','34',465,'3','1',34484.24,35303.14,818.90,171969.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','34',466,'4','1',24265.26,26522.60,2257.34,474041.40,0.00,0.00,0.00,0.00,0.00),('1','293','1','34',467,'5','1',12748.47,12748.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','34',468,'6','1',35325.73,37884.99,2559.26,537444.60,0.00,0.00,0.00,0.00,0.00),('1','293','1','34',469,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','34',470,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','34',471,'9','1',43052.39,45714.66,2662.27,559076.70,0.00,0.00,0.00,0.00,0.00),('1','293','2','34',472,'10','1',35877.43,35877.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','34',473,'11','1',39235.44,42296.12,3060.68,642742.80,0.00,0.00,0.00,0.00,0.00),('1','293','2','34',474,'12','1',32471.33,32471.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','34',475,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','34',476,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','35',477,'1','1',33303.12,33303.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','35',478,'2','1',23260.70,24832.67,1571.97,330113.70,0.00,0.00,0.00,0.00,0.00),('1','293','1','35',479,'3','1',35303.14,36687.61,1384.47,290738.70,0.00,0.00,0.00,0.00,0.00),('1','293','1','35',480,'4','1',26522.60,26522.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','35',481,'5','1',12748.47,12748.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','35',482,'6','1',37884.99,39708.64,1823.65,382966.50,0.00,0.00,0.00,0.00,0.00),('1','293','1','35',483,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','35',484,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','35',485,'9','1',45714.66,45714.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','35',486,'10','1',35877.43,37531.45,1654.02,347344.20,0.00,0.00,0.00,0.00,0.00),('1','293','2','35',487,'11','1',42296.12,43236.46,940.34,197471.40,0.00,0.00,0.00,0.00,0.00),('1','293','2','35',488,'12','1',32471.33,33683.85,1212.52,254629.20,0.00,0.00,0.00,0.00,0.00),('1','293','3','35',489,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','35',490,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','36',491,'1','1',33303.12,34861.45,1558.33,327249.30,0.00,0.00,0.00,0.00,0.00),('1','293','1','36',492,'2','1',24832.67,26535.39,1702.72,357571.20,0.00,0.00,0.00,0.00,0.00),('1','293','1','36',493,'3','1',36687.61,38481.76,1794.15,376771.50,0.00,0.00,0.00,0.00,0.00),('1','293','1','36',494,'4','1',26522.60,26522.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','36',495,'5','1',12748.47,14248.37,1499.90,314979.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','36',496,'6','1',39708.64,41926.70,2218.06,465792.60,0.00,0.00,0.00,0.00,0.00),('1','293','1','36',497,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','36',498,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','36',499,'9','1',45714.66,45714.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','36',500,'10','1',37531.45,37531.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','36',501,'11','1',43236.46,43236.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','36',502,'12','1',33683.85,33683.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','36',503,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','36',504,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','37',505,'1','1',34861.45,34861.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','37',506,'2','1',26535.39,26652.66,107.27,22526.70,0.00,0.00,10.00,0.00,0.00),('1','293','1','37',507,'3','1',38481.76,39222.93,731.17,153545.70,0.00,0.00,10.00,0.00,0.00),('1','293','1','37',508,'4','1',26522.60,26522.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','37',509,'5','1',14248.37,15030.73,762.36,160095.60,0.00,0.00,20.00,0.00,0.00),('1','293','1','37',510,'6','1',41926.70,42944.29,1007.59,211593.90,0.00,0.00,10.00,0.00,0.00),('1','293','1','37',511,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','37',512,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','37',513,'9','1',45714.66,45714.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','37',514,'10','1',37531.45,38496.03,964.58,202561.80,0.00,0.00,0.00,0.00,0.00),('1','293','2','37',515,'11','1',43236.46,43236.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','37',516,'12','1',33683.85,34457.86,774.01,162542.10,0.00,0.00,0.00,0.00,0.00),('1','293','3','37',517,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','37',518,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','38',519,'1','1',34861.45,34861.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','38',520,'2','1',26652.66,29518.82,2866.16,601893.60,0.00,0.00,0.00,0.00,0.00),('1','293','1','38',521,'3','1',39222.93,43640.69,4417.76,927729.60,0.00,0.00,0.00,0.00,0.00),('1','293','1','38',522,'4','1',26522.60,26522.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','38',523,'5','1',15030.73,15030.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','38',524,'6','1',42944.29,45878.81,2934.52,616249.20,0.00,0.00,0.00,0.00,0.00),('1','293','1','38',525,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','38',526,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','38',527,'9','1',45714.66,49381.97,3667.31,770135.10,0.00,0.00,0.00,0.00,0.00),('1','293','2','38',528,'10','1',38496.03,41228.54,2732.51,573827.10,0.00,0.00,0.00,0.00,0.00),('1','293','2','38',529,'11','1',43236.46,46908.48,3672.02,771124.20,0.00,0.00,0.00,0.00,0.00),('1','293','2','38',530,'12','1',34457.86,35130.24,672.38,141199.80,0.00,0.00,0.00,0.00,0.00),('1','293','3','38',531,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','38',532,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','39',533,'1','1',34861.45,37732.20,2870.75,602857.50,0.00,0.00,0.00,0.00,0.00),('1','293','1','39',534,'2','1',29518.82,30974.64,1455.82,305722.20,0.00,0.00,0.00,0.00,0.00),('1','293','1','39',535,'3','1',43640.69,43640.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','39',536,'4','1',26522.60,29825.41,3302.81,693590.10,0.00,0.00,0.00,0.00,0.00),('1','293','1','39',537,'5','1',15030.73,17223.79,2193.06,460542.60,0.00,0.00,0.00,0.00,0.00),('1','293','1','39',538,'6','1',45878.81,47976.69,2097.88,440554.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','39',539,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','39',540,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','39',541,'9','1',49381.97,51288.59,1906.62,400390.20,0.00,0.00,0.00,0.00,0.00),('1','293','2','39',542,'10','1',41228.54,41228.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','39',543,'11','1',46908.48,46908.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','39',544,'12','1',35130.24,37031.41,1901.17,399245.70,0.00,0.00,0.00,0.00,0.00),('1','293','3','39',545,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','39',546,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','40',547,'1','1',37732.20,37732.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','40',548,'2','1',30974.64,35721.06,4746.42,996748.20,0.00,0.00,0.00,0.00,0.00),('1','293','1','40',549,'3','1',43640.69,47508.12,3867.43,812160.30,0.00,0.00,0.00,0.00,0.00),('1','293','1','40',550,'4','1',29825.41,29825.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','40',551,'5','1',17223.79,17223.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','40',552,'6','1',47976.69,51485.74,3509.05,736900.50,0.00,0.00,0.00,0.00,0.00),('1','293','1','40',553,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','40',554,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','40',555,'9','1',51288.59,55344.10,4055.51,851657.10,0.00,0.00,0.00,0.00,0.00),('1','293','2','40',556,'10','1',41228.54,41335.77,107.23,22518.30,0.00,0.00,0.00,0.00,0.00),('1','293','2','40',557,'11','1',46908.48,46908.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','40',558,'12','1',37031.41,41197.01,4165.60,874776.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','40',559,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','40',560,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','41',561,'1','1',37732.20,37732.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','41',562,'2','1',35721.06,39609.38,3888.32,816547.20,0.00,0.00,0.00,0.00,0.00),('1','293','1','41',563,'3','1',47508.12,47508.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','41',564,'4','1',29825.41,33418.83,3593.42,754618.20,0.00,0.00,0.00,0.00,0.00),('1','293','1','41',565,'5','1',17223.79,17223.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','41',566,'6','1',51485.74,55209.74,3724.00,782040.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','41',567,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','41',568,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','41',569,'9','1',55344.10,59843.53,4499.43,944880.30,0.00,0.00,0.00,0.00,0.00),('1','293','2','41',570,'10','1',41335.77,41335.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','41',571,'11','1',46908.48,50971.32,4062.84,853196.40,0.00,0.00,0.00,0.00,0.00),('1','293','2','41',572,'12','1',41197.01,41197.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','41',573,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','41',574,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','42',575,'1','1',37732.20,37732.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','42',576,'2','1',39609.38,44587.72,4978.34,1045451.40,0.00,0.00,0.00,0.00,0.00),('1','293','1','42',577,'3','1',47508.12,51359.39,3851.27,808766.70,0.00,0.00,0.00,0.00,0.00),('1','293','1','42',578,'4','1',33418.83,33418.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','42',579,'5','1',17223.79,18001.35,777.56,163287.60,0.00,0.00,0.00,0.00,0.00),('1','293','1','42',580,'6','1',55209.74,60481.05,5271.31,1106975.10,0.00,0.00,0.00,0.00,0.00),('1','293','1','42',581,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','42',582,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','42',583,'9','1',59843.53,64104.53,4261.00,894810.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','42',584,'10','1',41335.77,42508.54,1172.77,246281.70,0.00,0.00,0.00,0.00,0.00),('1','293','2','42',585,'11','1',50971.32,50971.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','42',586,'12','1',41197.01,46033.36,4836.35,1015633.50,0.00,0.00,0.00,0.00,0.00),('1','293','3','42',587,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','42',588,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','43',589,'1','1',37732.20,37732.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','43',590,'2','1',44587.72,44587.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','43',591,'3','1',51359.39,51359.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','43',592,'4','1',33418.83,33418.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','43',593,'5','1',18001.35,18001.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','43',594,'6','1',60481.05,60481.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','43',595,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','43',596,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','43',597,'9','1',64104.53,64104.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','43',598,'10','1',42508.54,42508.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','43',599,'11','1',50971.32,50971.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','43',600,'12','1',46033.36,46033.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','43',601,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','43',602,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','44',603,'1','1',37732.20,37732.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','44',604,'2','1',44587.72,47162.83,2575.11,540773.10,0.00,0.00,0.00,0.00,0.00),('1','293','1','44',605,'3','1',51359.39,53626.75,2267.36,476145.60,0.00,0.00,0.00,0.00,0.00),('1','293','1','44',606,'4','1',33418.83,33418.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','44',607,'5','1',18001.35,18001.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','44',608,'6','1',60481.05,64776.66,4295.61,902078.10,0.00,0.00,0.00,0.00,0.00),('1','293','1','44',609,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','44',610,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','44',611,'9','1',64104.53,64104.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','44',612,'10','1',42508.54,44530.76,2022.22,424666.20,0.00,0.00,0.00,0.00,0.00),('1','293','2','44',613,'11','1',50971.32,50971.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','44',614,'12','1',46033.36,48681.26,2647.90,556059.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','44',615,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','44',616,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','45',617,'1','1',37732.20,37732.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','45',618,'2','1',47162.83,49854.99,2692.16,565353.60,0.00,0.00,0.00,0.00,0.00),('1','293','1','45',619,'3','1',53626.75,53868.16,241.41,50696.10,0.00,0.00,0.00,0.00,0.00),('1','293','1','45',620,'4','1',33418.83,36318.89,2900.06,609012.60,0.00,0.00,0.00,0.00,0.00),('1','293','1','45',621,'5','1',18001.35,18001.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','45',622,'6','1',64776.66,67497.73,2721.07,571424.70,0.00,0.00,0.00,0.00,0.00),('1','293','1','45',623,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','45',624,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','45',625,'9','1',64104.53,66452.84,2348.31,493145.10,0.00,0.00,0.00,0.00,0.00),('1','293','2','45',626,'10','1',44530.76,49440.73,4909.97,1031093.70,0.00,0.00,0.00,0.00,0.00),('1','293','2','45',627,'11','1',50971.32,55369.64,4398.32,923647.20,0.00,0.00,0.00,0.00,0.00),('1','293','2','45',628,'12','1',48681.26,48681.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','45',629,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','45',630,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','46',631,'1','1',37732.20,37732.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','46',632,'2','1',49854.99,52402.27,2547.28,534928.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','46',633,'3','1',53868.16,56370.98,2502.82,525592.20,0.00,0.00,0.00,0.00,0.00),('1','293','1','46',634,'4','1',36318.89,36318.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','46',635,'5','1',18001.35,18611.58,610.23,128148.30,0.00,0.00,0.00,0.00,0.00),('1','293','1','46',636,'6','1',67497.73,70619.26,3101.53,651321.30,0.00,0.00,20.00,0.00,0.00),('1','293','1','46',637,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','46',638,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','46',639,'9','1',66452.84,70436.26,3983.42,836518.20,0.00,0.00,0.00,0.00,0.00),('1','293','2','46',640,'10','1',49440.73,49440.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','46',641,'11','1',55369.64,55379.64,10.00,2100.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','46',642,'12','1',48681.26,51744.28,3063.02,643234.20,0.00,0.00,0.00,0.00,0.00),('1','293','3','46',643,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','46',644,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','47',645,'1','1',37732.20,37732.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','47',646,'2','1',52402.27,54387.68,1985.41,416936.10,0.00,0.00,0.00,0.00,0.00),('1','293','1','47',647,'3','1',56370.98,58769.84,2398.86,503760.60,0.00,0.00,0.00,0.00,0.00),('1','293','1','47',648,'4','1',36318.89,36318.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','47',649,'5','1',18611.58,18611.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','47',650,'6','1',70619.26,72249.78,1630.52,342409.20,0.00,0.00,0.00,0.00,0.00),('1','293','1','47',651,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','47',652,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','47',653,'9','1',70436.26,72703.77,2267.51,476177.10,0.00,0.00,0.00,0.00,0.00),('1','293','2','47',654,'10','1',49440.73,51044.39,1603.66,336768.60,0.00,0.00,0.00,0.00,0.00),('1','293','2','47',655,'11','1',55379.64,55379.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','47',656,'12','1',51744.28,54520.66,2776.38,583039.80,0.00,0.00,0.00,0.00,0.00),('1','293','3','47',657,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','47',658,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','48',659,'1','1',37732.20,37732.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','48',660,'2','1',54387.68,56654.78,2267.10,476091.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','48',661,'3','1',58769.84,60859.31,2089.47,438788.70,0.00,0.00,0.00,0.00,0.00),('1','293','1','48',662,'4','1',36318.89,37903.54,1584.65,332776.50,0.00,0.00,0.00,0.00,0.00),('1','293','1','48',663,'5','1',18611.58,18611.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','48',664,'6','1',72249.78,74130.47,1880.69,394944.90,0.00,0.00,0.00,0.00,0.00),('1','293','1','48',665,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','48',666,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','48',667,'9','1',72703.77,75125.49,2421.72,508561.20,0.00,0.00,0.00,0.00,0.00),('1','293','2','48',668,'10','1',51044.39,53859.64,2815.25,591202.50,0.00,0.00,0.00,0.00,0.00),('1','293','2','48',669,'11','1',55379.64,56465.70,1086.06,228072.60,0.00,0.00,0.00,0.00,0.00),('1','293','2','48',670,'12','1',54520.66,57883.97,3363.31,706295.10,0.00,0.00,0.00,0.00,0.00),('1','293','3','48',671,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','48',672,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','49',673,'1','1',37732.20,37732.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','49',674,'2','1',56654.78,56654.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','49',675,'3','1',60859.31,60859.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','49',676,'4','1',37903.54,37903.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','49',677,'5','1',18611.58,18611.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','49',678,'6','1',74130.47,74130.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','49',679,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','49',680,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','49',681,'9','1',75125.49,78279.77,3154.28,662398.80,0.00,0.00,0.00,0.00,0.00),('1','293','2','49',682,'10','1',53859.64,57609.65,3750.01,787502.10,0.00,0.00,0.00,0.00,0.00),('1','293','2','49',683,'11','1',56465.70,60245.00,3779.30,793653.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','49',684,'12','1',57883.97,61163.00,3279.03,688596.30,0.00,0.00,0.00,0.00,0.00),('1','293','3','49',685,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','49',686,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','50',687,'1','1',37732.20,37732.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','50',688,'2','1',56654.78,56654.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','50',689,'3','1',60859.31,60859.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','50',690,'4','1',37903.54,37903.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','50',691,'5','1',18611.58,18611.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','50',692,'6','1',74130.47,74130.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','50',693,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','50',694,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','50',695,'9','1',78279.77,78279.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','50',696,'10','1',57609.65,57609.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','50',697,'11','1',60245.00,67310.90,7065.90,1483839.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','50',698,'12','1',61163.00,63746.12,2583.12,542455.20,0.00,0.00,0.00,0.00,0.00),('1','293','3','50',699,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','50',700,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','51',701,'1','1',37732.20,37732.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','51',702,'2','1',56654.78,56654.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','51',703,'3','1',60859.31,60859.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','51',704,'4','1',37903.54,37903.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','51',705,'5','1',18611.58,18611.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','51',706,'6','1',74130.47,74130.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','51',707,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','51',708,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','51',709,'9','1',78279.77,78279.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','51',710,'10','1',57609.65,57609.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','51',711,'11','1',67310.90,67310.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','51',712,'12','1',63746.12,63746.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','51',713,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','51',714,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','52',715,'1','1',37732.20,37732.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','52',716,'2','1',56654.78,56654.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','52',717,'3','1',60859.31,60859.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','52',718,'4','1',37903.54,37903.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','52',719,'5','1',18611.58,18611.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','52',720,'6','1',74130.47,74130.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','52',721,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','52',722,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','52',723,'9','1',78279.77,78279.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','52',724,'10','1',57609.65,57609.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','52',725,'11','1',67310.90,68337.20,1026.30,236049.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','52',726,'12','1',63746.12,63746.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','52',727,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','52',728,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','53',729,'1','1',37732.20,37732.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','53',730,'2','1',56654.78,58470.64,1815.86,417647.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','53',731,'3','1',60859.31,62926.21,2066.90,475387.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','53',732,'4','1',37903.54,37903.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','53',733,'5','1',18611.58,18611.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','53',734,'6','1',74130.47,76353.74,2223.27,511352.10,0.00,0.00,0.00,0.00,0.00),('1','293','1','53',735,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','53',736,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','53',737,'9','1',78279.77,80133.32,1853.55,426316.50,0.00,0.00,0.00,0.00,0.00),('1','293','2','53',738,'10','1',57609.65,59276.97,1667.32,383483.60,0.00,0.00,0.00,0.00,0.00),('1','293','2','53',739,'11','1',68337.20,68337.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','53',740,'12','1',63746.12,65777.02,2030.90,467107.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','53',741,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','53',742,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','54',743,'1','1',37732.20,39444.11,1711.91,393739.30,0.00,0.00,0.00,0.00,0.00),('1','293','1','54',744,'2','1',58470.64,60131.46,1660.82,381988.60,0.00,0.00,0.00,0.00,0.00),('1','293','1','54',745,'3','1',62926.21,65173.47,2247.26,516869.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','54',746,'4','1',37903.54,39492.97,1589.43,365568.90,0.00,0.00,0.00,0.00,0.00),('1','293','1','54',747,'5','1',18611.58,20591.74,1980.16,455436.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','54',748,'6','1',76353.74,78585.34,2231.60,513268.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','54',749,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','54',750,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','54',751,'9','1',80133.32,80133.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','54',752,'10','1',59276.97,59276.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','54',753,'11','1',68337.20,69944.60,1607.40,369702.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','54',754,'12','1',65777.02,67664.97,1887.95,434228.50,0.00,0.00,0.00,0.00,0.00),('1','293','3','54',755,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','54',756,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','55',757,'1','1',39444.11,42244.64,2800.53,644121.90,0.00,0.00,0.00,0.00,0.00),('1','293','1','55',758,'2','1',60131.46,62496.29,2364.83,543910.90,0.00,0.00,0.00,0.00,0.00),('1','293','1','55',759,'3','1',65173.47,66925.97,1752.50,403075.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','55',760,'4','1',39492.97,41656.96,2163.99,497717.70,0.00,0.00,0.00,0.00,0.00),('1','293','1','55',761,'5','1',20591.74,22913.04,2321.30,533899.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','55',762,'6','1',78585.34,81478.50,2893.16,665426.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','55',763,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','55',764,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','55',765,'9','1',80133.32,80133.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','55',766,'10','1',59276.97,59276.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','55',767,'11','1',69944.60,69944.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','55',768,'12','1',67664.97,67664.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','55',769,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','55',770,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','56',771,'1','1',42244.64,42244.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','56',772,'2','1',62496.29,62496.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','56',773,'3','1',66925.97,66925.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','56',774,'4','1',41656.96,41656.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','56',775,'5','1',22913.04,22913.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','56',776,'6','1',81478.50,81478.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','56',777,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','56',778,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','56',779,'9','1',80133.32,81606.20,1472.88,338762.40,0.00,0.00,0.00,0.00,0.00),('1','293','2','56',780,'10','1',59276.97,60908.11,1631.14,375162.20,0.00,0.00,0.00,0.00,0.00),('1','293','2','56',781,'11','1',69944.60,71109.85,1165.25,268007.50,0.00,0.00,0.00,0.00,0.00),('1','293','2','56',782,'12','1',67664.97,69470.39,1805.42,415246.60,0.00,0.00,0.00,0.00,0.00),('1','293','3','56',783,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','56',784,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','57',785,'1','1',42244.64,42244.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','57',786,'2','1',62496.29,62496.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','57',787,'3','1',66925.97,66925.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','57',788,'4','1',41656.96,41656.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','57',789,'5','1',22913.04,22913.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','57',790,'6','1',81478.50,81478.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','57',791,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','57',792,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','57',793,'9','1',81606.20,85586.03,3979.83,915360.90,0.00,0.00,0.00,0.00,0.00),('1','293','2','57',794,'10','1',60908.11,63131.32,2223.21,511338.30,0.00,0.00,0.00,0.00,0.00),('1','293','2','57',795,'11','1',71109.85,73841.41,2731.56,628258.80,0.00,0.00,0.00,0.00,0.00),('1','293','2','57',796,'12','1',69470.39,72820.32,3349.93,770483.90,0.00,0.00,0.00,0.00,0.00),('1','293','3','57',797,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','57',798,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','58',799,'1','1',42244.64,44277.81,2033.17,467629.10,0.00,0.00,0.00,0.00,0.00),('1','293','1','58',800,'2','1',62496.29,64550.55,2054.26,472479.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','58',801,'3','1',66925.97,69286.55,2360.58,542933.40,0.00,0.00,0.00,0.00,0.00),('1','293','1','58',802,'4','1',41656.96,43293.39,1636.43,376378.90,0.00,0.00,0.00,0.00,0.00),('1','293','1','58',803,'5','1',22913.04,25135.91,2222.87,511260.10,0.00,0.00,0.00,0.00,0.00),('1','293','1','58',804,'6','1',81478.50,84352.67,2874.17,661059.10,0.00,0.00,0.00,0.00,0.00),('1','293','1','58',805,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','58',806,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','58',807,'9','1',85586.03,85586.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','58',808,'10','1',63131.32,63131.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','58',809,'11','1',73841.41,73841.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','58',810,'12','1',72820.32,75834.13,3013.81,693176.30,0.00,0.00,0.00,0.00,0.00),('1','293','3','58',811,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','58',812,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','59',813,'1','1',44277.81,45683.73,1405.92,337420.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','59',814,'2','1',64550.55,65880.31,1329.76,319142.40,0.00,0.00,0.00,0.00,0.00),('1','293','1','59',815,'3','1',69286.55,70807.46,1520.91,365018.40,0.00,0.00,0.00,0.00,0.00),('1','293','1','59',816,'4','1',43293.39,44678.63,1385.24,332457.60,0.00,0.00,0.00,0.00,0.00),('1','293','1','59',817,'5','1',25135.91,27182.71,2046.80,491232.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','59',818,'6','1',84352.67,85992.16,1639.49,393477.60,0.00,0.00,0.00,0.00,0.00),('1','293','1','59',819,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','59',820,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','59',821,'9','1',85586.03,85586.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','59',822,'10','1',63131.32,63131.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','59',823,'11','1',73841.41,73841.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','59',824,'12','1',75834.13,75834.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','59',825,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','59',826,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','60',827,'1','1',45683.73,45683.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','60',828,'2','1',65880.31,65880.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','60',829,'3','1',70807.46,70807.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','60',830,'4','1',44678.63,44678.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','60',831,'5','1',27182.71,27182.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','60',832,'6','1',85992.16,85992.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','60',833,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','60',834,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','60',835,'9','1',85586.03,85586.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','60',836,'10','1',63131.32,63131.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','60',837,'11','1',73841.41,76708.19,2866.78,688027.20,0.00,0.00,0.00,0.00,0.00),('1','293','2','60',838,'12','1',75834.13,80829.71,4995.58,1198939.20,0.00,0.00,0.00,0.00,0.00),('1','293','3','60',839,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','60',840,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','61',841,'1','1',45683.73,45683.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','61',842,'2','1',65880.31,65880.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','61',843,'3','1',70807.46,70807.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','61',844,'4','1',44678.63,44678.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','61',845,'5','1',27182.71,27182.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','61',846,'6','1',85992.16,85992.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','61',847,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','61',848,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','61',849,'9','1',85586.03,85586.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','61',850,'10','1',63131.32,63131.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','61',851,'11','1',76708.19,76708.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','61',852,'12','1',80829.71,84652.54,3822.83,917479.20,0.00,0.00,0.00,0.00,0.00),('1','293','3','61',853,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','61',854,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','62',855,'1','1',45683.73,45683.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','62',856,'2','1',65880.31,65880.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','62',857,'3','1',70807.46,70807.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','62',858,'4','1',44678.63,44678.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','62',859,'5','1',27182.71,27182.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','62',860,'6','1',85992.16,85992.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','62',861,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','62',862,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','62',863,'9','1',85586.03,85586.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','62',864,'10','1',63131.32,63131.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','62',865,'11','1',76708.19,79620.56,2912.37,698968.80,0.00,0.00,0.00,0.00,0.00),('1','293','2','62',866,'12','1',84652.54,91914.77,7262.23,1742935.20,0.00,0.00,0.00,0.00,0.00),('1','293','3','62',867,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','62',868,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','63',869,'1','1',45683.73,45683.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','63',870,'2','1',65880.31,65880.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','63',871,'3','1',70807.46,70807.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','63',872,'4','1',44678.63,44678.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','63',873,'5','1',27182.71,27182.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','63',874,'6','1',85992.16,85992.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','63',875,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','63',876,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','63',877,'9','1',85586.03,85586.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','63',878,'10','1',63131.32,63131.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','63',879,'11','1',79620.56,79620.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','63',880,'12','1',91914.77,91914.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','63',881,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','63',882,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','64',883,'1','1',45683.73,45683.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','64',884,'2','1',65880.31,65880.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','64',885,'3','1',70807.46,70807.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','64',886,'4','1',44678.63,44678.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','64',887,'5','1',27182.71,27182.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','64',888,'6','1',85992.16,85992.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','64',889,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','64',890,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','64',891,'9','1',85586.03,86252.90,666.87,160049.28,0.00,0.00,0.00,0.00,0.00),('1','293','2','64',892,'10','1',63131.32,63638.37,507.05,121692.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','64',893,'11','1',79620.56,80848.69,1228.13,294751.20,0.00,0.00,0.00,0.00,0.00),('1','293','2','64',894,'12','1',91914.77,92705.30,790.53,189727.20,0.00,0.00,0.00,0.00,0.00),('1','293','3','64',895,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','64',896,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','65',897,'1','1',45683.73,45683.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','65',898,'2','1',65880.31,65880.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','65',899,'3','1',70807.46,70807.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','65',900,'4','1',44678.63,44678.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','65',901,'5','1',27182.71,27182.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','65',902,'6','1',85992.16,85992.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','65',903,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','65',904,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','65',905,'9','1',86252.90,87249.24,996.34,239121.60,0.00,0.00,0.00,0.00,0.00),('1','293','2','65',906,'10','1',63638.37,64269.64,631.27,151504.80,0.00,0.00,0.00,0.00,0.00),('1','293','2','65',907,'11','1',80848.69,81821.00,972.31,233354.40,0.00,0.00,0.00,0.00,0.00),('1','293','2','65',908,'12','1',92705.30,93413.97,708.67,170080.80,0.00,0.00,0.00,0.00,0.00),('1','293','3','65',909,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','65',910,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','66',911,'1','1',45683.73,45683.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','66',912,'2','1',65880.31,65880.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','66',913,'3','1',70807.46,70807.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','66',914,'4','1',44678.63,44678.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','66',915,'5','1',27182.71,27182.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','66',916,'6','1',85992.16,85992.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','66',917,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','66',918,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','66',919,'9','1',87249.24,89048.48,1799.24,431817.60,0.00,0.00,0.00,0.00,0.00),('1','293','2','66',920,'10','1',64269.64,65781.45,1511.81,362834.40,0.00,0.00,0.00,0.00,0.00),('1','293','2','66',921,'11','1',81821.00,83522.86,1701.86,408446.40,0.00,0.00,0.00,0.00,0.00),('1','293','2','66',922,'12','1',93413.97,94659.87,1245.90,299016.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','66',923,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','66',924,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','67',925,'1','1',45683.73,45683.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','67',926,'2','1',65880.31,65880.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','67',927,'3','1',70807.46,70807.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','67',928,'4','1',44678.63,44678.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','67',929,'5','1',27182.71,27182.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','67',930,'6','1',85992.16,85992.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','67',931,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','67',932,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','67',933,'9','1',89048.48,89843.19,794.71,190730.40,0.00,0.00,0.00,0.00,0.00),('1','293','2','67',934,'10','1',65781.45,66349.57,568.12,136348.80,0.00,0.00,0.00,0.00,0.00),('1','293','2','67',935,'11','1',83522.86,84023.83,500.97,120232.80,0.00,0.00,0.00,0.00,0.00),('1','293','2','67',936,'12','1',94659.87,95217.27,557.40,133776.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','67',937,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','67',938,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','68',939,'1','1',45683.73,45683.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','68',940,'2','1',65880.31,65880.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','68',941,'3','1',70807.46,70807.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','68',942,'4','1',44678.63,44678.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','68',943,'5','1',27182.71,27182.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','68',944,'6','1',85992.16,85992.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','68',945,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','68',946,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','68',947,'9','1',89843.19,91262.07,1418.88,340531.20,0.00,0.00,0.00,0.00,0.00),('1','293','2','68',948,'10','1',66349.57,68202.22,1852.65,444636.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','68',949,'11','1',84023.83,85704.89,1681.06,403454.40,0.00,0.00,0.00,0.00,0.00),('1','293','2','68',950,'12','1',95217.27,97288.39,2071.12,497068.80,0.00,0.00,0.00,0.00,0.00),('1','293','3','68',951,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','68',952,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','69',953,'1','1',45683.73,47817.44,2133.71,512090.40,0.00,0.00,0.00,0.00,0.00),('1','293','1','69',954,'2','1',65880.31,68718.57,2838.26,681182.40,0.00,0.00,0.00,0.00,0.00),('1','293','1','69',955,'3','1',70807.46,72465.46,1658.00,397920.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','69',956,'4','1',44678.63,46947.87,2269.24,544617.60,0.00,0.00,0.00,0.00,0.00),('1','293','1','69',957,'5','1',27182.71,30178.17,2995.46,718910.40,0.00,0.00,0.00,0.00,0.00),('1','293','1','69',958,'6','1',85992.16,87956.08,1963.92,471340.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','69',959,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','69',960,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','69',961,'9','1',91262.07,91262.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','69',962,'10','1',68202.22,68202.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','69',963,'11','1',85704.89,85704.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','69',964,'12','1',97288.39,97288.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','69',965,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','69',966,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','70',967,'1','1',47817.44,47874.20,56.76,13622.40,0.00,0.00,0.00,0.00,0.00),('1','293','1','70',968,'2','1',68718.57,68756.17,37.60,9024.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','70',969,'3','1',72465.46,72549.10,83.64,20073.60,0.00,0.00,0.00,0.00,0.00),('1','293','1','70',970,'4','1',46947.87,46947.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','70',971,'5','1',30178.17,30227.18,49.01,11762.40,0.00,0.00,0.00,0.00,0.00),('1','293','1','70',972,'6','1',87956.08,88051.65,95.57,22936.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','70',973,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','70',974,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','70',975,'9','1',91262.07,92946.72,1684.65,404316.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','70',976,'10','1',68202.22,69584.72,1382.50,331800.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','70',977,'11','1',85704.89,87568.61,1863.72,447292.80,0.00,0.00,0.00,0.00,0.00),('1','293','2','70',978,'12','1',97288.39,99782.18,2493.79,598509.60,0.00,0.00,0.00,0.00,0.00),('1','293','3','70',979,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','70',980,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','71',981,'1','1',47874.20,47874.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','71',982,'2','1',68756.17,68756.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','71',983,'3','1',72549.10,72549.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','71',984,'4','1',46947.87,46947.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','71',985,'5','1',30227.18,30227.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','71',986,'6','1',88051.65,88051.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','71',987,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','71',988,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','71',989,'9','1',92946.72,93358.33,411.61,98786.40,0.00,0.00,0.00,0.00,0.00),('1','293','2','71',990,'10','1',69584.72,70099.00,514.28,123427.20,0.00,0.00,0.00,0.00,0.00),('1','293','2','71',991,'11','1',87568.61,88122.77,554.16,132998.40,0.00,0.00,0.00,0.00,0.00),('1','293','2','71',992,'12','1',99782.18,100072.33,290.15,69636.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','71',993,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','71',994,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','72',995,'1','1',47874.20,48383.96,509.76,122342.40,0.00,0.00,0.00,0.00,0.00),('1','293','1','72',996,'2','1',68756.17,69622.84,866.67,208000.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','72',997,'3','1',72549.10,72949.45,400.35,96084.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','72',998,'4','1',46947.87,47649.45,701.58,168379.20,0.00,0.00,0.00,0.00,0.00),('1','293','1','72',999,'5','1',30227.18,30227.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','72',1000,'6','1',88051.65,88715.06,663.41,159218.40,0.00,0.00,0.00,0.00,0.00),('1','293','1','72',1001,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','72',1002,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','72',1003,'9','1',93358.33,96281.41,2923.08,701539.20,0.00,0.00,0.00,0.00,0.00),('1','293','2','72',1004,'10','1',70099.00,73013.35,2914.35,699444.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','72',1005,'11','1',88122.77,90622.77,2500.00,600000.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','72',1006,'12','1',100072.33,103630.09,3557.76,853862.40,0.00,0.00,0.00,0.00,0.00),('1','293','3','72',1007,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','72',1008,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','73',1009,'1','1',48383.96,48383.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','73',1010,'2','1',69622.84,70810.91,1188.07,285136.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','73',1011,'3','1',72949.45,72949.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','73',1012,'4','1',47649.45,47649.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','73',1013,'5','1',30227.18,30227.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','73',1014,'6','1',88715.06,88715.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','73',1015,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','73',1016,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','73',1017,'9','1',96281.41,96281.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','73',1018,'10','1',73013.35,75005.83,1992.48,478195.20,0.00,0.00,0.00,0.00,0.00),('1','293','2','73',1019,'11','1',90622.77,93454.41,2831.64,679593.60,0.00,0.00,0.00,0.00,0.00),('1','293','2','73',1020,'12','1',103630.09,107022.18,3392.09,814101.60,0.00,0.00,0.00,0.00,0.00),('1','293','3','73',1021,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','73',1022,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','74',1023,'1','1',48383.96,49163.09,779.13,186991.20,0.00,0.00,0.00,0.00,0.00),('1','293','1','74',1024,'2','1',70810.91,71762.98,952.07,228496.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','74',1025,'3','1',72949.45,73436.21,486.76,116822.40,0.00,0.00,0.00,0.00,0.00),('1','293','1','74',1026,'4','1',47649.45,48233.89,584.44,140265.60,0.00,0.00,0.00,0.00,0.00),('1','293','1','74',1027,'5','1',30227.18,31332.00,1104.82,265156.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','74',1028,'6','1',88715.06,89911.47,1196.41,287138.40,0.00,0.00,0.00,0.00,0.00),('1','293','1','74',1029,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','74',1030,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','74',1031,'9','1',96281.41,96596.84,315.43,75703.20,0.00,0.00,0.00,0.00,0.00),('1','293','2','74',1032,'10','1',75005.83,75139.38,133.55,32052.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','74',1033,'11','1',93454.41,93648.91,194.50,46680.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','74',1034,'12','1',107022.18,107209.10,186.92,44860.80,0.00,0.00,0.00,0.00,0.00),('1','293','3','74',1035,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','74',1036,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','75',1037,'1','1',49163.09,49163.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','75',1038,'2','1',71762.98,71762.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','75',1039,'3','1',73436.21,73436.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','75',1040,'4','1',48233.89,48233.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','75',1041,'5','1',31332.00,32097.64,765.64,183753.60,0.00,0.00,0.00,0.00,0.00),('1','293','1','75',1042,'6','1',89911.47,91308.65,1397.18,335323.20,0.00,0.00,0.00,0.00,0.00),('1','293','1','75',1043,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','75',1044,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','75',1045,'9','1',96596.84,96596.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','75',1046,'10','1',75139.38,75139.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','75',1047,'11','1',93648.91,93648.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','75',1048,'12','1',107209.10,107209.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','75',1049,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','75',1050,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','76',1051,'1','1',49163.09,49163.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','76',1052,'2','1',71762.98,71762.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','76',1053,'3','1',73436.21,73436.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','76',1054,'4','1',48233.89,48233.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','76',1055,'5','1',32097.64,32097.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','76',1056,'6','1',91308.65,91308.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','76',1057,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','76',1058,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','76',1059,'9','1',96596.84,96596.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','76',1060,'10','1',75139.38,75139.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','76',1061,'11','1',93648.91,93648.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','76',1062,'12','1',107209.10,107209.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','76',1063,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','76',1064,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','77',1065,'1','1',49163.09,50429.44,1266.35,303924.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','77',1066,'2','1',71762.98,73108.97,1345.99,323037.60,0.00,0.00,0.00,0.00,0.00),('1','293','1','77',1067,'3','1',73436.21,74582.46,1146.25,275100.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','77',1068,'4','1',48233.89,49305.95,1072.06,257294.40,0.00,0.00,0.00,0.00,0.00),('1','293','1','77',1069,'5','1',32097.64,33472.12,1374.48,329875.20,0.00,0.00,0.00,0.00,0.00),('1','293','1','77',1070,'6','1',91308.65,93092.06,1783.41,428018.40,0.00,0.00,0.00,0.00,0.00),('1','293','1','77',1071,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','77',1072,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','77',1073,'9','1',96596.84,96691.73,94.89,22773.60,0.00,0.00,0.00,0.00,0.00),('1','293','2','77',1074,'10','1',75139.38,75266.99,127.61,30626.40,0.00,0.00,0.00,0.00,0.00),('1','293','2','77',1075,'11','1',93648.91,93762.68,113.77,27304.80,0.00,0.00,0.00,0.00,0.00),('1','293','2','77',1076,'12','1',107209.10,107318.08,108.98,26155.20,0.00,0.00,0.00,0.00,0.00),('1','293','3','77',1077,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','77',1078,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','78',1079,'1','1',50429.44,50429.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','78',1080,'2','1',73108.97,74315.12,1206.15,289476.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','78',1081,'3','1',74582.46,75342.02,759.56,182294.40,0.00,0.00,0.00,0.00,0.00),('1','293','1','78',1082,'4','1',49305.95,49305.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','78',1083,'5','1',33472.12,33472.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','78',1084,'6','1',93092.06,94204.34,1112.28,266947.20,0.00,0.00,0.00,0.00,0.00),('1','293','1','78',1085,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','78',1086,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','78',1087,'9','1',96691.73,96691.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','78',1088,'10','1',75266.99,76209.52,942.53,226207.20,0.00,0.00,0.00,0.00,0.00),('1','293','2','78',1089,'11','1',93762.68,95153.41,1390.73,333775.20,0.00,0.00,0.00,0.00,0.00),('1','293','2','78',1090,'12','1',107318.08,108395.62,1077.54,258609.60,0.00,0.00,0.00,0.00,0.00),('1','293','3','78',1091,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','78',1092,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','79',1093,'1','1',50429.44,51423.41,993.97,238552.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','79',1094,'2','1',74315.12,74315.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','79',1095,'3','1',75342.02,76257.49,915.47,219712.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','79',1096,'4','1',49305.95,49305.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','79',1097,'5','1',33472.12,33472.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','79',1098,'6','1',94204.34,95339.25,1134.91,272378.40,0.00,0.00,0.00,0.00,0.00),('1','293','1','79',1099,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','79',1100,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','79',1101,'9','1',96691.73,97473.79,782.06,187694.40,0.00,0.00,0.00,0.00,0.00),('1','293','2','79',1102,'10','1',76209.52,76209.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','79',1103,'11','1',95153.41,95614.11,460.70,110568.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','79',1104,'12','1',108395.62,109451.61,1055.99,253437.60,0.00,0.00,0.00,0.00,0.00),('1','293','3','79',1105,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','79',1106,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','80',1107,'1','1',51423.41,51423.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','80',1108,'2','1',74315.12,74315.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','80',1109,'3','1',76257.49,76257.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','80',1110,'4','1',49305.95,49305.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','80',1111,'5','1',33472.12,34237.24,765.12,183628.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','80',1112,'6','1',95339.25,97250.35,1911.10,458664.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','80',1113,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','80',1114,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','80',1115,'9','1',97473.79,98654.90,1181.11,283466.40,0.00,0.00,0.00,0.00,0.00),('1','293','2','80',1116,'10','1',76209.52,77031.44,821.92,197260.80,0.00,0.00,0.00,0.00,0.00),('1','293','2','80',1117,'11','1',95614.11,96321.60,707.49,169797.60,0.00,0.00,0.00,0.00,0.00),('1','293','2','80',1118,'12','1',109451.61,110615.94,1164.33,279439.20,0.00,0.00,0.00,0.00,0.00),('1','293','3','80',1119,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','80',1120,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','81',1121,'1','1',51423.41,51423.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','81',1122,'2','1',74315.12,74315.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','81',1123,'3','1',76257.49,76257.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','81',1124,'4','1',49305.95,49305.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','81',1125,'5','1',34237.24,34237.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','81',1126,'6','1',97250.35,97250.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','81',1127,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','81',1128,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','81',1129,'9','1',98654.90,100715.04,2060.14,494433.60,0.00,0.00,0.00,0.00,0.00),('1','293','2','81',1130,'10','1',77031.44,79310.03,2278.59,546861.60,0.00,0.00,0.00,0.00,0.00),('1','293','2','81',1131,'11','1',96321.60,98300.83,1979.23,475015.20,0.00,0.00,0.00,0.00,0.00),('1','293','2','81',1132,'12','1',110615.94,112119.63,1503.69,360885.60,0.00,0.00,0.00,0.00,0.00),('1','293','3','81',1133,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','81',1134,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','82',1135,'1','1',51423.41,51423.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','82',1136,'2','1',74315.12,74315.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','82',1137,'3','1',76257.49,76257.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','82',1138,'4','1',49305.95,49305.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','82',1139,'5','1',34237.24,34237.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','82',1140,'6','1',97250.35,97250.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','82',1141,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','82',1142,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','82',1143,'9','1',100715.04,100715.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','82',1144,'10','1',79310.03,79310.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','82',1145,'11','1',98300.83,100056.04,1755.21,421250.40,0.00,0.00,0.00,0.00,0.00),('1','293','2','82',1146,'12','1',112119.63,113835.87,1716.24,411897.60,0.00,0.00,0.00,0.00,0.00),('1','293','3','82',1147,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','82',1148,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','83',1149,'1','1',51423.41,51423.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','83',1150,'2','1',74315.12,74315.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','83',1151,'3','1',76257.49,76257.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','83',1152,'4','1',49305.95,49305.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','83',1153,'5','1',34237.24,34237.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','83',1154,'6','1',97250.35,97250.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','83',1155,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','83',1156,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','83',1157,'9','1',100715.04,101647.99,932.95,223908.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','83',1158,'10','1',79310.03,80680.90,1370.87,329008.80,0.00,0.00,0.00,0.00,0.00),('1','293','2','83',1159,'11','1',100056.04,102542.43,2486.39,596733.60,0.00,0.00,0.00,0.00,0.00),('1','293','2','83',1160,'12','1',113835.87,116023.06,2187.19,524925.60,0.00,0.00,0.00,0.00,0.00),('1','293','3','83',1161,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','83',1162,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','84',1163,'1','1',51423.41,51423.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','84',1164,'2','1',74315.12,74315.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','84',1165,'3','1',76257.49,76257.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','84',1166,'4','1',49305.95,49305.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','84',1167,'5','1',34237.24,34237.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','84',1168,'6','1',97250.35,97250.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','84',1169,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','84',1170,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','84',1171,'9','1',101647.99,103170.99,1523.00,365520.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','84',1172,'10','1',80680.90,81586.14,905.24,217257.60,0.00,0.00,0.00,0.00,0.00),('1','293','2','84',1173,'11','1',102542.43,104264.92,1722.49,413397.60,0.00,0.00,0.00,0.00,0.00),('1','293','2','84',1174,'12','1',116023.06,117402.60,1379.54,331089.60,0.00,0.00,0.00,0.00,0.00),('1','293','3','84',1175,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','84',1176,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','85',1177,'1','1',51423.41,51423.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','85',1178,'2','1',74315.12,74315.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','85',1179,'3','1',76257.49,76257.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','85',1180,'4','1',49305.95,49305.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','85',1181,'5','1',34237.24,34858.15,620.91,142809.30,0.00,0.00,0.00,0.00,0.00),('1','293','1','85',1182,'6','1',97250.35,97658.82,408.47,93948.10,0.00,0.00,0.00,0.00,0.00),('1','293','1','85',1183,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','85',1184,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','85',1185,'9','1',103170.99,103170.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','85',1186,'10','1',81586.14,81586.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','85',1187,'11','1',104264.92,105729.84,1464.92,336931.60,0.00,0.00,0.00,0.00,0.00),('1','293','2','85',1188,'12','1',117402.60,118776.73,1374.13,316049.90,0.00,0.00,0.00,0.00,0.00),('1','293','3','85',1189,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','85',1190,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','86',1191,'1','1',51423.41,51423.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','86',1192,'2','1',74315.12,74315.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','86',1193,'3','1',76257.49,76257.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','86',1194,'4','1',49305.95,49305.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','86',1195,'5','1',34858.15,38098.32,3240.17,745239.10,0.00,0.00,0.00,0.00,0.00),('1','293','1','86',1196,'6','1',97658.82,100873.12,3214.30,739289.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','86',1197,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','86',1198,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','86',1199,'9','1',103170.99,103170.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','86',1200,'10','1',81586.14,81586.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','86',1201,'11','1',105729.84,105729.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','86',1202,'12','1',118776.73,118776.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','86',1203,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','86',1204,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','87',1205,'1','1',51423.41,53405.88,1982.47,475792.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','87',1206,'2','1',74315.12,76563.27,2248.15,539556.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','87',1207,'3','1',76257.49,76257.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','87',1208,'4','1',49305.95,49305.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','87',1209,'5','1',38098.32,40335.68,2237.36,536966.40,0.00,0.00,0.00,0.00,0.00),('1','293','1','87',1210,'6','1',100873.12,103506.94,2633.82,632116.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','87',1211,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','87',1212,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','87',1213,'9','1',103170.99,103170.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','87',1214,'10','1',81586.14,81586.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','87',1215,'11','1',105729.84,105729.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','87',1216,'12','1',118776.73,118776.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','87',1217,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','87',1218,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','88',1219,'1','1',53405.88,53405.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','88',1220,'2','1',76563.27,76563.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','88',1221,'3','1',76257.49,76257.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','88',1222,'4','1',49305.95,49305.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','88',1223,'5','1',40335.68,41141.69,776.01,186242.40,0.00,0.00,30.00,0.00,0.00),('1','293','1','88',1224,'6','1',103506.94,103506.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','88',1225,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','88',1226,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','88',1227,'9','1',103170.99,103170.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','88',1228,'10','1',81586.14,81586.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','88',1229,'11','1',105729.84,105729.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','88',1230,'12','1',118776.73,118776.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','88',1231,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','88',1232,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','89',1233,'1','1',53405.88,53405.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','89',1234,'2','1',76563.27,76563.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','89',1235,'3','1',76257.49,76257.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','89',1236,'4','1',49305.95,49305.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','89',1237,'5','1',41141.69,41779.98,638.29,130849.45,0.00,0.00,0.00,0.00,0.00),('1','293','1','89',1238,'6','1',103506.94,104038.14,521.20,106846.00,0.00,0.00,10.00,0.00,0.00),('1','293','1','89',1239,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','89',1240,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','89',1241,'9','1',103170.99,104777.09,1606.10,329250.50,0.00,0.00,0.00,0.00,0.00),('1','293','2','89',1242,'10','1',81586.14,83115.85,1529.71,313590.55,0.00,0.00,0.00,0.00,0.00),('1','293','2','89',1243,'11','1',105729.84,107925.03,2195.19,450013.95,0.00,0.00,0.00,0.00,0.00),('1','293','2','89',1244,'12','1',118776.73,121050.58,2273.85,466139.25,0.00,0.00,0.00,0.00,0.00),('1','293','3','89',1245,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','89',1246,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','90',1247,'1','1',53405.88,53405.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','90',1248,'2','1',76563.27,76563.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','90',1249,'3','1',76257.49,76257.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','90',1250,'4','1',49305.95,49305.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','90',1251,'5','1',41779.98,41779.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','90',1252,'6','1',104038.14,104038.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','90',1253,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','90',1254,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','90',1255,'9','1',104777.09,105470.08,692.99,142062.95,0.00,0.00,0.00,0.00,0.00),('1','293','2','90',1256,'10','1',83115.85,84126.85,1011.00,207255.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','90',1257,'11','1',107925.03,109129.62,1204.59,246940.95,0.00,0.00,0.00,0.00,0.00),('1','293','2','90',1258,'12','1',121050.58,121707.84,657.26,134738.30,0.00,0.00,0.00,0.00,0.00),('1','293','3','90',1259,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','90',1260,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','91',1261,'1','1',53405.88,54224.86,818.98,167890.90,0.00,0.00,0.00,0.00,0.00),('1','293','1','91',1262,'2','1',76563.27,78244.14,1680.87,344578.35,0.00,0.00,0.00,0.00,0.00),('1','293','1','91',1263,'3','1',76257.49,78338.85,2081.36,426678.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','91',1264,'4','1',49305.95,50058.68,752.73,154309.65,0.00,0.00,0.00,0.00,0.00),('1','293','1','91',1265,'5','1',41779.98,43971.54,2191.56,449269.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','91',1266,'6','1',104038.14,106717.70,2679.56,549309.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','91',1267,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','91',1268,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','91',1269,'9','1',105470.08,106671.43,1201.35,246276.75,0.00,0.00,0.00,0.00,0.00),('1','293','2','91',1270,'10','1',84126.85,87016.50,2889.65,592378.25,0.00,0.00,0.00,0.00,0.00),('1','293','2','91',1271,'11','1',109129.62,111754.06,2624.44,538010.20,0.00,0.00,0.00,0.00,0.00),('1','293','2','91',1272,'12','1',121707.84,124451.37,2743.53,562423.65,0.00,0.00,0.00,0.00,0.00),('1','293','3','91',1273,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','91',1274,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','92',1275,'1','1',54224.86,54224.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','92',1276,'2','1',78244.14,78244.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','92',1277,'3','1',78338.85,78338.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','92',1278,'4','1',50058.68,50058.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','92',1279,'5','1',43971.54,45654.40,1682.86,344986.30,0.00,0.00,0.00,0.00,0.00),('1','293','1','92',1280,'6','1',106717.70,108734.61,2016.91,413466.55,0.00,0.00,0.00,0.00,0.00),('1','293','1','92',1281,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','92',1282,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','92',1283,'9','1',106671.43,106671.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','92',1284,'10','1',87016.50,87016.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','92',1285,'11','1',111754.06,115812.94,4058.88,832070.40,0.00,0.00,0.00,0.00,0.00),('1','293','2','92',1286,'12','1',124451.37,129263.43,4812.06,986472.30,0.00,0.00,0.00,0.00,0.00),('1','293','3','92',1287,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','92',1288,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','93',1289,'1','1',54224.86,54890.24,665.38,136402.90,0.00,0.00,0.00,0.00,0.00),('1','293','1','93',1290,'2','1',78244.14,79503.71,1259.57,258211.85,0.00,0.00,0.00,0.00,0.00),('1','293','1','93',1291,'3','1',78338.85,80767.65,2428.80,497904.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','93',1292,'4','1',50058.68,50765.20,706.52,144836.60,0.00,0.00,0.00,0.00,0.00),('1','293','1','93',1293,'5','1',45654.40,45888.45,234.05,47980.25,0.00,0.00,0.00,0.00,0.00),('1','293','1','93',1294,'6','1',108734.61,109445.12,710.51,145654.55,0.00,0.00,0.00,0.00,0.00),('1','293','1','93',1295,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','93',1296,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','93',1297,'9','1',106671.43,110977.03,4305.60,882648.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','93',1298,'10','1',87016.50,90224.10,3207.60,657558.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','93',1299,'11','1',115812.94,118896.33,3083.39,632094.95,0.00,0.00,0.00,0.00,0.00),('1','293','2','93',1300,'12','1',129263.43,132360.18,3096.75,634833.75,0.00,0.00,0.00,0.00,0.00),('1','293','3','93',1301,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','93',1302,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','94',1303,'1','1',54890.24,54890.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','94',1304,'2','1',79503.71,79503.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','94',1305,'3','1',80767.65,80767.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','94',1306,'4','1',50765.20,50765.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','94',1307,'5','1',45888.45,49783.17,3894.72,798417.60,0.00,0.00,0.00,0.00,0.00),('1','293','1','94',1308,'6','1',109445.12,114446.66,5001.54,1025315.70,0.00,0.00,0.00,0.00,0.00),('1','293','1','94',1309,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','94',1310,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','94',1311,'9','1',110977.03,110977.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','94',1312,'10','1',90224.10,90224.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','94',1313,'11','1',118896.33,120121.71,1225.38,251202.90,0.00,0.00,0.00,0.00,0.00),('1','293','2','94',1314,'12','1',132360.18,133502.77,1142.59,234230.95,0.00,0.00,0.00,0.00,0.00),('1','293','3','94',1315,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','94',1316,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','95',1317,'1','1',54890.24,55828.05,937.81,192251.05,0.00,0.00,0.00,0.00,0.00),('1','293','1','95',1318,'2','1',79503.71,81103.40,1599.69,327936.45,0.00,0.00,0.00,0.00,0.00),('1','293','1','95',1319,'3','1',80767.65,81592.06,824.41,169004.05,0.00,0.00,0.00,0.00,0.00),('1','293','1','95',1320,'4','1',50765.20,51786.17,1020.97,209298.85,0.00,0.00,0.00,0.00,0.00),('1','293','1','95',1321,'5','1',49783.17,51257.88,1474.71,302315.55,0.00,0.00,0.00,0.00,0.00),('1','293','1','95',1322,'6','1',114446.66,115931.33,1484.67,304357.35,0.00,0.00,0.00,0.00,0.00),('1','293','1','95',1323,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','95',1324,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','95',1325,'9','1',110977.03,110977.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','95',1326,'10','1',90224.10,90224.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','95',1327,'11','1',120121.71,120121.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','95',1328,'12','1',133502.77,133502.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','95',1329,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','95',1330,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','96',1331,'1','1',55828.05,55828.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','96',1332,'2','1',81103.40,81103.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','96',1333,'3','1',81592.06,81592.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','96',1334,'4','1',51786.17,51786.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','96',1335,'5','1',51257.88,54996.33,3738.45,766382.25,0.00,0.00,0.00,0.00,0.00),('1','293','1','96',1336,'6','1',115931.33,119502.98,3571.65,732188.25,0.00,0.00,0.00,0.00,0.00),('1','293','1','96',1337,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','96',1338,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','96',1339,'9','1',110977.03,110977.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','96',1340,'10','1',90224.10,90224.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','96',1341,'11','1',120121.71,120121.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','96',1342,'12','1',133502.77,133502.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','96',1343,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','96',1344,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','97',1345,'1','1',55828.05,55828.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','97',1346,'2','1',81103.40,81103.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','97',1347,'3','1',81592.06,81592.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','97',1348,'4','1',51786.17,51786.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','97',1349,'5','1',54996.33,57478.99,2482.66,508945.30,0.00,0.00,0.00,0.00,0.00),('1','293','1','97',1350,'6','1',119502.98,123223.49,3720.51,762704.55,0.00,0.00,0.00,0.00,0.00),('1','293','1','97',1351,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','97',1352,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','97',1353,'9','1',110977.03,110977.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','97',1354,'10','1',90224.10,90224.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','97',1355,'11','1',120121.71,120121.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','97',1356,'12','1',133502.77,133502.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','97',1357,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','97',1358,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','98',1359,'1','1',55828.05,55828.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','98',1360,'2','1',81103.40,81103.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','98',1361,'3','1',81592.06,81592.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','98',1362,'4','1',51786.17,51786.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','98',1363,'5','1',57478.99,59048.48,1569.49,321745.45,0.00,0.00,0.00,0.00,0.00),('1','293','1','98',1364,'6','1',123223.49,124407.41,1183.92,242703.60,0.00,0.00,0.00,0.00,0.00),('1','293','1','98',1365,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','98',1366,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','98',1367,'9','1',110977.03,110977.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','98',1368,'10','1',90224.10,90224.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','98',1369,'11','1',120121.71,120121.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','98',1370,'12','1',133502.77,133502.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','98',1371,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','98',1372,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','99',1373,'1','1',55828.05,57189.28,1361.23,279052.15,0.00,0.00,0.00,0.00,0.00),('1','293','1','99',1374,'2','1',81103.40,82460.65,1357.25,278236.25,0.00,0.00,0.00,0.00,0.00),('1','293','1','99',1375,'3','1',81592.06,81592.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','99',1376,'4','1',51786.17,51786.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','99',1377,'5','1',59048.48,62828.88,3780.40,774982.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','99',1378,'6','1',124407.41,128354.26,3946.85,809104.25,0.00,0.00,0.00,0.00,0.00),('1','293','1','99',1379,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','99',1380,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','99',1381,'9','1',110977.03,110977.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','99',1382,'10','1',90224.10,90224.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','99',1383,'11','1',120121.71,120121.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','99',1384,'12','1',133502.77,133546.92,44.15,9050.75,0.00,0.00,0.00,0.00,0.00),('1','293','3','99',1385,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','99',1386,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','100',1387,'1','1',57189.28,57189.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','100',1388,'2','1',82460.65,82460.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','100',1389,'3','1',81592.06,81592.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','100',1390,'4','1',51786.17,51786.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','100',1391,'5','1',62828.88,62828.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','100',1392,'6','1',128354.26,128354.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','100',1393,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','100',1394,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','100',1395,'9','1',110977.03,112930.92,1953.89,400547.45,0.00,0.00,0.00,0.00,0.00),('1','293','2','100',1396,'10','1',90224.10,90260.78,36.68,7519.40,0.00,0.00,0.00,0.00,0.00),('1','293','2','100',1397,'11','1',120121.71,125183.88,5062.17,1037744.85,0.00,0.00,0.00,0.00,0.00),('1','293','2','100',1398,'12','1',133546.92,138857.12,5310.20,1088591.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','100',1399,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','100',1400,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','101',1401,'1','1',57189.28,57189.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','101',1402,'2','1',82460.65,82460.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','101',1403,'3','1',81592.06,81592.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','101',1404,'4','1',51786.17,51786.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','101',1405,'5','1',62828.88,62828.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','101',1406,'6','1',128354.26,128354.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','101',1407,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','101',1408,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','101',1409,'9','1',112930.92,114016.91,1085.99,222627.95,0.00,0.00,0.00,0.00,0.00),('1','293','2','101',1410,'10','1',90260.78,91899.31,1638.53,335898.65,0.00,0.00,0.00,0.00,0.00),('1','293','2','101',1411,'11','1',125183.88,126847.16,1663.28,340972.40,0.00,0.00,0.00,0.00,0.00),('1','293','2','101',1412,'12','1',138857.12,140746.11,1888.99,387242.95,0.00,0.00,0.00,0.00,0.00),('1','293','3','101',1413,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','101',1414,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','102',1415,'1','1',57189.28,57189.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','102',1416,'2','1',82460.65,82460.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','102',1417,'3','1',81592.06,81592.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','102',1418,'4','1',51786.17,51786.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','102',1419,'5','1',62828.88,62828.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','102',1420,'6','1',128354.26,128354.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','102',1421,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','102',1422,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','102',1423,'9','1',114016.91,114016.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','102',1424,'10','1',91899.31,91899.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','102',1425,'11','1',126847.16,126847.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','102',1426,'12','1',140746.11,141442.99,696.88,142860.40,0.00,0.00,0.00,0.00,0.00),('1','293','3','102',1427,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','102',1428,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','103',1429,'1','1',57189.28,57189.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','103',1430,'2','1',82460.65,82460.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','103',1431,'3','1',81592.06,81592.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','103',1432,'4','1',51786.17,51786.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','103',1433,'5','1',62828.88,62828.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','103',1434,'6','1',128354.26,128354.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','103',1435,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','103',1436,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','103',1437,'9','1',114016.91,114016.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','103',1438,'10','1',91899.31,91899.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','103',1439,'11','1',126847.16,127952.28,1105.12,226549.60,0.00,0.00,0.00,0.00,0.00),('1','293','2','103',1440,'12','1',141442.99,142122.95,679.96,139391.80,0.00,0.00,0.00,0.00,0.00),('1','293','3','103',1441,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','103',1442,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','104',1443,'1','1',57189.28,57189.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','104',1444,'2','1',82460.65,82460.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','104',1445,'3','1',81592.06,81592.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','104',1446,'4','1',51786.17,51786.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','104',1447,'5','1',62828.88,62828.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','104',1448,'6','1',128354.26,128354.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','104',1449,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','104',1450,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','104',1451,'9','1',114016.91,114016.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','104',1452,'10','1',91899.31,91899.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','104',1453,'11','1',127952.28,127952.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','104',1454,'12','1',142122.95,142122.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','104',1455,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','104',1456,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','105',1457,'1','1',57189.28,57189.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','105',1458,'2','1',82460.65,82460.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','105',1459,'3','1',81592.06,81592.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','105',1460,'4','1',51786.17,51786.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','105',1461,'5','1',62828.88,62828.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','105',1462,'6','1',128354.26,128354.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','105',1463,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','105',1464,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','105',1465,'9','1',114016.91,115715.17,1698.26,356634.60,0.00,0.00,0.00,0.00,0.00),('1','293','2','105',1466,'10','1',91899.31,93586.09,1686.78,354223.80,0.00,0.00,0.00,0.00,0.00),('1','293','2','105',1467,'11','1',127952.28,129886.13,1933.85,406108.50,0.00,0.00,0.00,0.00,0.00),('1','293','2','105',1468,'12','1',142122.95,144606.56,2483.61,521558.10,0.00,0.00,0.00,0.00,0.00),('1','293','3','105',1469,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','105',1470,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','106',1471,'1','1',57189.28,57189.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','106',1472,'2','1',82460.65,82460.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','106',1473,'3','1',81592.06,81592.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','106',1474,'4','1',51786.17,51786.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','106',1475,'5','1',62828.88,62828.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','106',1476,'6','1',128354.26,128354.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','106',1477,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','106',1478,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','106',1479,'9','1',115715.17,117723.30,2008.13,421707.30,0.00,0.00,0.00,0.00,0.00),('1','293','2','106',1480,'10','1',93586.09,95485.50,1899.41,398876.10,0.00,0.00,0.00,0.00,0.00),('1','293','2','106',1481,'11','1',129886.13,132147.86,2261.73,474963.30,0.00,0.00,0.00,0.00,0.00),('1','293','2','106',1482,'12','1',144606.56,146415.20,1808.64,379814.40,0.00,0.00,0.00,0.00,0.00),('1','293','3','106',1483,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','106',1484,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','107',1485,'1','1',57189.28,57189.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','107',1486,'2','1',82460.65,82460.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','107',1487,'3','1',81592.06,81592.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','107',1488,'4','1',51786.17,51786.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','107',1489,'5','1',62828.88,62828.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','107',1490,'6','1',128354.26,128354.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','107',1491,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','107',1492,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','107',1493,'9','1',117723.30,117723.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','107',1494,'10','1',95485.50,95485.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','107',1495,'11','1',132147.86,132540.58,392.72,82471.20,0.00,0.00,0.00,0.00,0.00),('1','293','2','107',1496,'12','1',146415.20,147556.13,1140.93,239595.30,0.00,0.00,0.00,0.00,0.00),('1','293','3','107',1497,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','107',1498,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','108',1499,'1','1',57189.28,57189.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','108',1500,'2','1',82460.65,82460.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','108',1501,'3','1',81592.06,81592.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','108',1502,'4','1',51786.17,51786.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','108',1503,'5','1',62828.88,62828.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','108',1504,'6','1',128354.26,128354.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','108',1505,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','108',1506,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','108',1507,'9','1',117723.30,117723.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','108',1508,'10','1',95485.50,95485.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','108',1509,'11','1',132540.58,132860.78,320.20,67242.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','108',1510,'12','1',147556.13,147676.67,120.54,25313.40,0.00,0.00,0.00,0.00,0.00),('1','293','3','108',1511,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','108',1512,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','109',1513,'1','1',57189.28,61118.05,3928.77,923260.95,0.00,0.00,0.00,0.00,0.00),('1','293','1','109',1514,'2','1',82460.65,85838.16,3377.51,793714.85,0.00,0.00,0.00,0.00,0.00),('1','293','1','109',1515,'3','1',81592.06,84043.38,2451.32,576060.20,0.00,0.00,0.00,0.00,0.00),('1','293','1','109',1516,'4','1',51786.17,53497.89,1711.72,402254.20,0.00,0.00,0.00,0.00,0.00),('1','293','1','109',1517,'5','1',62828.88,65693.14,2864.26,673101.10,0.00,0.00,0.00,0.00,0.00),('1','293','1','109',1518,'6','1',128354.26,130083.05,1728.79,406265.65,0.00,0.00,0.00,0.00,0.00),('1','293','1','109',1519,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','109',1520,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','109',1521,'9','1',117723.30,117723.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','109',1522,'10','1',95485.50,95485.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','109',1523,'11','1',132860.78,132860.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','109',1524,'12','1',147676.67,147676.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','109',1525,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','109',1526,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','110',1527,'1','1',61118.05,61118.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','110',1528,'2','1',85838.16,85838.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','110',1529,'3','1',84043.38,84043.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','110',1530,'4','1',53497.89,53497.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','110',1531,'5','1',65693.14,65693.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','110',1532,'6','1',130083.05,130083.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','110',1533,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','110',1534,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','110',1535,'9','1',117723.30,119303.42,1580.12,371328.20,0.00,0.00,0.00,0.00,0.00),('1','293','2','110',1536,'10','1',95485.50,97377.13,1891.63,444533.05,0.00,0.00,0.00,0.00,0.00),('1','293','2','110',1537,'11','1',132860.78,134395.82,1535.04,360734.40,0.00,0.00,0.00,0.00,0.00),('1','293','2','110',1538,'12','1',147676.67,149342.14,1665.47,391385.45,0.00,0.00,0.00,0.00,0.00),('1','293','3','110',1539,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','110',1540,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','111',1541,'1','1',61118.05,62001.86,883.81,207695.35,0.00,0.00,0.00,0.00,0.00),('1','293','1','111',1542,'2','1',85838.16,86475.46,637.30,149765.50,0.00,0.00,0.00,0.00,0.00),('1','293','1','111',1543,'3','1',84043.38,84870.89,827.51,194464.85,0.00,0.00,0.00,0.00,0.00),('1','293','1','111',1544,'4','1',53497.89,54634.01,1136.12,266988.20,0.00,0.00,0.00,0.00,0.00),('1','293','1','111',1545,'5','1',65693.14,66260.10,566.96,133235.60,0.00,0.00,0.00,0.00,0.00),('1','293','1','111',1546,'6','1',130083.05,130612.23,529.18,124357.30,0.00,0.00,0.00,0.00,0.00),('1','293','1','111',1547,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','111',1548,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','111',1549,'9','1',119303.42,122474.01,3170.59,745088.65,0.00,0.00,0.00,0.00,0.00),('1','293','2','111',1550,'10','1',97377.13,100186.90,2809.77,660295.95,0.00,0.00,0.00,0.00,0.00),('1','293','2','111',1551,'11','1',134395.82,136193.27,1797.45,422400.75,0.00,0.00,0.00,0.00,0.00),('1','293','2','111',1552,'12','1',149342.14,151511.37,2169.23,509769.05,0.00,0.00,0.00,0.00,0.00),('1','293','3','111',1553,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','111',1554,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','112',1555,'1','1',62001.86,62001.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','112',1556,'2','1',86475.46,86475.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','112',1557,'3','1',84870.89,84870.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','112',1558,'4','1',54634.01,54634.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','112',1559,'5','1',66260.10,66260.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','112',1560,'6','1',130612.23,130612.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','112',1561,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','112',1562,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','112',1563,'9','1',122474.01,122758.73,284.72,66909.20,0.00,0.00,0.00,0.00,0.00),('1','293','2','112',1564,'10','1',100186.90,101044.37,857.47,201505.45,0.00,0.00,0.00,0.00,0.00),('1','293','2','112',1565,'11','1',136193.27,137399.65,1206.38,283499.30,0.00,0.00,0.00,0.00,0.00),('1','293','2','112',1566,'12','1',151511.37,153448.75,1937.38,455284.30,0.00,0.00,0.00,0.00,0.00),('1','293','3','112',1567,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','112',1568,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','113',1569,'1','1',62001.86,63867.15,1865.29,438343.15,0.00,0.00,0.00,0.00,0.00),('1','293','1','113',1570,'2','1',86475.46,87866.41,1390.95,326873.25,0.00,0.00,0.00,0.00,0.00),('1','293','1','113',1571,'3','1',84870.89,85688.38,817.49,192110.15,0.00,0.00,0.00,0.00,0.00),('1','293','1','113',1572,'4','1',54634.01,55741.49,1107.48,260257.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','113',1573,'5','1',66260.10,67140.89,880.79,206985.65,0.00,0.00,0.00,0.00,0.00),('1','293','1','113',1574,'6','1',130612.23,131542.06,929.83,218510.05,0.00,0.00,0.00,0.00,0.00),('1','293','1','113',1575,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','113',1576,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','113',1577,'9','1',122758.73,125365.01,2606.28,612475.80,0.00,0.00,0.00,0.00,0.00),('1','293','2','113',1578,'10','1',101044.37,102812.91,1768.54,415606.90,0.00,0.00,0.00,0.00,0.00),('1','293','2','113',1579,'11','1',137399.65,137399.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','113',1580,'12','1',153448.75,155123.55,1674.80,393578.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','113',1581,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','113',1582,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','114',1583,'1','1',63867.15,63867.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','114',1584,'2','1',87866.41,87866.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','114',1585,'3','1',85688.38,85688.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','114',1586,'4','1',55741.49,55741.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','114',1587,'5','1',67140.89,67140.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','114',1588,'6','1',131542.06,132205.92,663.86,156007.10,0.00,0.00,0.00,0.00,0.00),('1','293','1','114',1589,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','114',1590,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','114',1591,'9','1',125365.01,125365.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','114',1592,'10','1',102812.91,102812.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','114',1593,'11','1',137399.65,138593.02,1193.37,280441.95,0.00,0.00,0.00,0.00,0.00),('1','293','2','114',1594,'12','1',155123.55,156893.00,1769.45,415820.75,0.00,0.00,0.00,0.00,0.00),('1','293','3','114',1595,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','114',1596,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','115',1597,'1','1',63867.15,65882.20,2015.05,473536.75,0.00,0.00,0.00,0.00,0.00),('1','293','1','115',1598,'2','1',87866.41,90569.87,2703.46,635313.10,0.00,0.00,0.00,0.00,0.00),('1','293','1','115',1599,'3','1',85688.38,88710.03,3021.65,710087.75,0.00,0.00,0.00,0.00,0.00),('1','293','1','115',1600,'4','1',55741.49,57769.14,2027.65,476497.75,0.00,0.00,0.00,0.00,0.00),('1','293','1','115',1601,'5','1',67140.89,68492.68,1351.79,317670.65,0.00,0.00,0.00,0.00,0.00),('1','293','1','115',1602,'6','1',132205.92,133870.65,1664.73,391211.55,0.00,0.00,0.00,0.00,0.00),('1','293','1','115',1603,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','115',1604,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','115',1605,'9','1',125365.01,128160.21,2795.20,656872.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','115',1606,'10','1',102812.91,104975.90,2162.99,508302.65,0.00,0.00,0.00,0.00,0.00),('1','293','2','115',1607,'11','1',138593.02,138994.41,401.39,94326.65,0.00,0.00,0.00,0.00,0.00),('1','293','2','115',1608,'12','1',156893.00,158897.82,2004.82,471132.70,0.00,0.00,0.00,0.00,0.00),('1','293','3','115',1609,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','115',1610,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','116',1611,'1','1',65882.20,65882.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','116',1612,'2','1',90569.87,90569.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','116',1613,'3','1',88710.03,88710.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','116',1614,'4','1',57769.14,57769.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','116',1615,'5','1',68492.68,68492.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','116',1616,'6','1',133870.65,133870.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','116',1617,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','116',1618,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','116',1619,'9','1',128160.21,128160.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','116',1620,'10','1',104975.90,104975.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','116',1621,'11','1',138994.41,141068.77,2074.36,487474.60,0.00,0.00,0.00,0.00,0.00),('1','293','2','116',1622,'12','1',158897.82,160361.30,1463.48,343917.80,0.00,0.00,0.00,0.00,0.00),('1','293','3','116',1623,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','116',1624,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','117',1625,'1','1',65882.20,65882.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','117',1626,'2','1',90569.87,90569.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','117',1627,'3','1',88710.03,88710.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','117',1628,'4','1',57769.14,57769.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','117',1629,'5','1',68492.68,68492.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','117',1630,'6','1',133870.65,133870.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','117',1631,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','117',1632,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','117',1633,'9','1',128160.21,128160.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','117',1634,'10','1',104975.90,104975.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','117',1635,'11','1',141068.77,141068.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','117',1636,'12','1',160361.30,160361.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','117',1637,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','117',1638,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','118',1639,'1','1',65882.20,67108.54,1226.34,288189.90,0.00,0.00,0.00,0.00,0.00),('1','293','1','118',1640,'2','1',90569.87,91121.68,551.81,129675.35,0.00,0.00,0.00,0.00,0.00),('1','293','1','118',1641,'3','1',88710.03,91391.74,2681.71,630201.85,0.00,0.00,0.00,0.00,0.00),('1','293','1','118',1642,'4','1',57769.14,59057.03,1287.89,302654.15,0.00,0.00,0.00,0.00,0.00),('1','293','1','118',1643,'5','1',68492.68,69135.75,643.07,151121.45,0.00,0.00,0.00,0.00,0.00),('1','293','1','118',1644,'6','1',133870.65,134965.47,1094.82,257282.70,0.00,0.00,0.00,0.00,0.00),('1','293','1','118',1645,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','118',1646,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','118',1647,'9','1',128160.21,130012.32,1852.11,435245.85,0.00,0.00,0.00,0.00,0.00),('1','293','2','118',1648,'10','1',104975.90,106911.15,1935.25,454783.75,0.00,0.00,0.00,0.00,0.00),('1','293','2','118',1649,'11','1',141068.77,142055.66,986.89,231919.15,0.00,0.00,0.00,0.00,0.00),('1','293','2','118',1650,'12','1',160361.30,161478.14,1116.84,262457.40,0.00,0.00,0.00,0.00,0.00),('1','293','3','118',1651,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','118',1652,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','119',1653,'1','1',67108.54,68777.96,1669.42,392313.70,0.00,0.00,0.00,0.00,0.00),('1','293','1','119',1654,'2','1',91121.68,92512.25,1390.57,326783.95,0.00,0.00,0.00,0.00,0.00),('1','293','1','119',1655,'3','1',91391.74,93947.87,2556.13,600690.55,0.00,0.00,0.00,0.00,0.00),('1','293','1','119',1656,'4','1',59057.03,60659.29,1602.26,376531.10,0.00,0.00,0.00,0.00,0.00),('1','293','1','119',1657,'5','1',69135.75,70885.89,1750.14,411282.90,0.00,0.00,0.00,0.00,0.00),('1','293','1','119',1658,'6','1',134965.47,136932.24,1966.77,462190.95,0.00,0.00,0.00,0.00,0.00),('1','293','1','119',1659,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','119',1660,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','119',1661,'9','1',130012.32,131928.30,1915.98,450255.30,0.00,0.00,0.00,0.00,0.00),('1','293','2','119',1662,'10','1',106911.15,108835.42,1924.27,452203.45,0.00,0.00,0.00,0.00,0.00),('1','293','2','119',1663,'11','1',142055.66,143502.17,1446.51,339929.85,0.00,0.00,0.00,0.00,0.00),('1','293','2','119',1664,'12','1',161478.14,163519.98,2041.84,479832.40,0.00,0.00,0.00,0.00,0.00),('1','293','3','119',1665,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','119',1666,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','120',1667,'1','1',68777.96,70383.15,1605.19,377219.65,0.00,0.00,0.00,0.00,0.00),('1','293','1','120',1668,'2','1',92512.25,93900.73,1388.48,326292.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','120',1669,'3','1',93947.87,96116.24,2168.37,509566.95,0.00,0.00,0.00,0.00,0.00),('1','293','1','120',1670,'4','1',60659.29,62016.45,1357.16,318932.60,0.00,0.00,0.00,0.00,0.00),('1','293','1','120',1671,'5','1',70885.89,70885.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','120',1672,'6','1',136932.24,139452.96,2520.72,592369.20,0.00,0.00,0.00,0.00,0.00),('1','293','1','120',1673,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','120',1674,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','120',1675,'9','1',131928.30,131928.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','120',1676,'10','1',108835.42,108835.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','120',1677,'11','1',143502.17,143502.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','120',1678,'12','1',163519.98,163519.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','120',1679,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','120',1680,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','121',1681,'1','1',70383.15,70383.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','121',1682,'2','1',93900.73,94653.14,752.41,176816.35,0.00,0.00,0.00,0.00,0.00),('1','293','1','121',1683,'3','1',96116.24,96116.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','121',1684,'4','1',62016.45,62016.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','121',1685,'5','1',70885.89,70885.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','121',1686,'6','1',139452.96,139452.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','121',1687,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','121',1688,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','121',1689,'9','1',131928.30,134373.25,2444.95,574563.25,0.00,0.00,0.00,0.00,0.00),('1','293','2','121',1690,'10','1',108835.42,111798.68,2963.26,696366.10,0.00,0.00,0.00,0.00,0.00),('1','293','2','121',1691,'11','1',143502.17,146383.59,2881.42,677133.70,0.00,0.00,0.00,0.00,0.00),('1','293','2','121',1692,'12','1',163519.98,165800.62,2280.64,535950.40,0.00,0.00,0.00,0.00,0.00),('1','293','3','121',1693,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','121',1694,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','122',1695,'1','1',70383.15,72899.77,2516.62,591405.70,0.00,0.00,0.00,0.00,0.00),('1','293','1','122',1696,'2','1',94653.14,96746.96,2093.82,492047.70,0.00,0.00,0.00,0.00,0.00),('1','293','1','122',1697,'3','1',96116.24,99715.25,3599.01,845767.35,0.00,0.00,0.00,0.00,0.00),('1','293','1','122',1698,'4','1',62016.45,63276.11,1259.66,296020.10,0.00,0.00,0.00,0.00,0.00),('1','293','1','122',1699,'5','1',70885.89,73010.28,2124.39,499231.65,0.00,0.00,0.00,0.00,0.00),('1','293','1','122',1700,'6','1',139452.96,142152.93,2699.97,634492.95,0.00,0.00,0.00,0.00,0.00),('1','293','1','122',1701,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','122',1702,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','122',1703,'9','1',134373.25,135879.82,1506.57,354043.95,0.00,0.00,0.00,0.00,0.00),('1','293','2','122',1704,'10','1',111798.68,113328.78,1530.10,359573.50,0.00,0.00,0.00,0.00,0.00),('1','293','2','122',1705,'11','1',146383.59,147898.01,1514.42,355888.70,0.00,0.00,0.00,0.00,0.00),('1','293','2','122',1706,'12','1',165800.62,168453.49,2652.87,623424.45,0.00,0.00,0.00,0.00,0.00),('1','293','3','122',1707,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','122',1708,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','123',1709,'1','1',72899.77,74624.96,1725.19,405419.65,0.00,0.00,0.00,0.00,0.00),('1','293','1','123',1710,'2','1',96746.96,96746.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','123',1711,'3','1',99715.25,101541.53,1826.28,429175.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','123',1712,'4','1',63276.11,63276.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','123',1713,'5','1',73010.28,73010.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','123',1714,'6','1',142152.93,144039.20,1886.27,443273.45,0.00,0.00,0.00,0.00,0.00),('1','293','1','123',1715,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','123',1716,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','123',1717,'9','1',135879.82,137062.37,1182.55,277899.25,0.00,0.00,0.00,0.00,0.00),('1','293','2','123',1718,'10','1',113328.78,114417.10,1088.32,255755.20,0.00,0.00,0.00,0.00,0.00),('1','293','2','123',1719,'11','1',147898.01,147898.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','123',1720,'12','1',168453.49,170768.92,2315.43,544126.05,0.00,0.00,0.00,0.00,0.00),('1','293','3','123',1721,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','123',1722,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','124',1723,'1','1',74624.96,75968.72,1343.76,315783.60,0.00,0.00,0.00,0.00,0.00),('1','293','1','124',1724,'2','1',96746.96,99261.63,2514.67,590947.45,0.00,0.00,0.00,0.00,0.00),('1','293','1','124',1725,'3','1',101541.53,101834.66,293.13,68885.55,0.00,0.00,0.00,0.00,0.00),('1','293','1','124',1726,'4','1',63276.11,65619.59,2343.48,550717.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','124',1727,'5','1',73010.28,75023.64,2013.36,473139.60,0.00,0.00,0.00,0.00,0.00),('1','293','1','124',1728,'6','1',144039.20,145316.01,1276.81,300050.35,0.00,0.00,0.00,0.00,0.00),('1','293','1','124',1729,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','124',1730,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','124',1731,'9','1',137062.37,138845.12,1782.75,418946.25,0.00,0.00,0.00,0.00,0.00),('1','293','2','124',1732,'10','1',114417.10,116447.68,2030.58,477186.30,0.00,0.00,0.00,0.00,0.00),('1','293','2','124',1733,'11','1',147898.01,149478.13,1580.12,371328.20,0.00,0.00,0.00,0.00,0.00),('1','293','2','124',1734,'12','1',170768.92,171043.28,274.36,64474.60,0.00,0.00,0.00,0.00,0.00),('1','293','3','124',1735,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','124',1736,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','125',1737,'1','1',75968.72,78624.46,2655.74,624098.90,0.00,0.00,0.00,0.00,0.00),('1','293','1','125',1738,'2','1',99261.63,99261.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','125',1739,'3','1',101834.66,104233.04,2398.38,563619.30,0.00,0.00,0.00,0.00,0.00),('1','293','1','125',1740,'4','1',65619.59,65619.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','125',1741,'5','1',75023.64,75023.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','125',1742,'6','1',145316.01,147739.68,2423.67,569562.45,0.00,0.00,0.00,0.00,0.00),('1','293','1','125',1743,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','125',1744,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','125',1745,'9','1',138845.12,140311.48,1466.36,344594.60,0.00,0.00,0.00,0.00,0.00),('1','293','2','125',1746,'10','1',116447.68,119030.68,2583.00,607005.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','125',1747,'11','1',149478.13,150257.15,779.02,183069.70,0.00,0.00,0.00,0.00,0.00),('1','293','2','125',1748,'12','1',171043.28,174021.14,2977.86,699797.10,0.00,0.00,0.00,0.00,0.00),('1','293','3','125',1749,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','125',1750,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','126',1751,'1','1',78624.46,78624.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','126',1752,'2','1',99261.63,101696.80,2435.17,572264.95,0.00,0.00,0.00,0.00,0.00),('1','293','1','126',1753,'3','1',104233.04,105861.98,1628.94,382800.90,0.00,0.00,0.00,0.00,0.00),('1','293','1','126',1754,'4','1',65619.59,65820.17,200.58,47136.30,0.00,0.00,0.00,0.00,0.00),('1','293','1','126',1755,'5','1',75023.64,77241.72,2218.08,521248.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','126',1756,'6','1',147739.68,147739.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','126',1757,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','126',1758,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','126',1759,'9','1',140311.48,141696.09,1384.61,325383.35,0.00,0.00,0.00,0.00,0.00),('1','293','2','126',1760,'10','1',119030.68,121335.09,2304.41,541536.35,0.00,0.00,0.00,0.00,0.00),('1','293','2','126',1761,'11','1',150257.15,151539.09,1281.94,301255.90,0.00,0.00,0.00,0.00,0.00),('1','293','2','126',1762,'12','1',174021.14,175337.72,1316.58,309396.30,0.00,0.00,0.00,0.00,0.00),('1','293','3','126',1763,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','126',1764,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','127',1765,'1','1',78624.46,80003.70,1379.24,324121.40,0.00,0.00,0.00,0.00,0.00),('1','293','1','127',1766,'2','1',101696.80,103488.19,1791.39,420976.65,0.00,0.00,0.00,0.00,0.00),('1','293','1','127',1767,'3','1',105861.98,106781.04,919.06,215979.10,0.00,0.00,0.00,0.00,0.00),('1','293','1','127',1768,'4','1',65820.17,67450.31,1630.14,383082.90,0.00,0.00,0.00,0.00,0.00),('1','293','1','127',1769,'5','1',77241.72,80181.43,2939.71,690831.85,0.00,0.00,0.00,0.00,0.00),('1','293','1','127',1770,'6','1',147739.68,151717.90,3978.22,934881.70,0.00,0.00,0.00,0.00,0.00),('1','293','1','127',1771,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','127',1772,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','127',1773,'9','1',141696.09,141696.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','127',1774,'10','1',121335.09,121335.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','127',1775,'11','1',151539.09,151539.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','127',1776,'12','1',175337.72,175337.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','127',1777,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','127',1778,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','128',1779,'1','1',80003.70,81972.72,1969.02,462719.70,0.00,0.00,0.00,0.00,0.00),('1','293','1','128',1780,'2','1',103488.19,104394.52,906.33,212987.55,0.00,0.00,0.00,0.00,0.00),('1','293','1','128',1781,'3','1',106781.04,107600.35,819.31,192537.85,0.00,0.00,0.00,0.00,0.00),('1','293','1','128',1782,'4','1',67450.31,68209.65,759.34,178444.90,0.00,0.00,0.00,0.00,0.00),('1','293','1','128',1783,'5','1',80181.43,80848.29,666.86,156712.10,0.00,0.00,0.00,0.00,0.00),('1','293','1','128',1784,'6','1',151717.90,153085.31,1367.41,321341.35,0.00,0.00,0.00,0.00,0.00),('1','293','1','128',1785,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','128',1786,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','128',1787,'9','1',141696.09,143640.47,1944.38,456929.30,0.00,0.00,0.00,0.00,0.00),('1','293','2','128',1788,'10','1',121335.09,122423.78,1088.69,255842.15,0.00,0.00,0.00,0.00,0.00),('1','293','2','128',1789,'11','1',151539.09,153033.96,1494.87,351294.45,0.00,0.00,0.00,0.00,0.00),('1','293','2','128',1790,'12','1',175337.72,177155.56,1817.84,427192.40,0.00,0.00,0.00,0.00,0.00),('1','293','3','128',1791,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','128',1792,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','129',1793,'1','1',81972.72,82964.76,992.04,233129.40,0.00,0.00,0.00,0.00,0.00),('1','293','1','129',1794,'2','1',104394.52,105266.33,871.81,204875.35,0.00,0.00,0.00,0.00,0.00),('1','293','1','129',1795,'3','1',107600.35,109297.66,1697.31,398867.85,0.00,0.00,0.00,0.00,0.00),('1','293','1','129',1796,'4','1',68209.65,68209.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','129',1797,'5','1',80848.29,80848.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','129',1798,'6','1',153085.31,153085.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','129',1799,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','129',1800,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','129',1801,'9','1',143640.47,143640.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','129',1802,'10','1',122423.78,123646.31,1222.53,287294.55,0.00,0.00,0.00,0.00,0.00),('1','293','2','129',1803,'11','1',153033.96,153033.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','129',1804,'12','1',177155.56,179102.99,1947.43,457646.05,0.00,0.00,0.00,0.00,0.00),('1','293','3','129',1805,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','129',1806,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','130',1807,'1','1',82964.76,83752.11,787.35,185027.25,0.00,0.00,0.00,0.00,0.00),('1','293','1','130',1808,'2','1',105266.33,105883.92,617.59,145133.65,0.00,0.00,0.00,0.00,0.00),('1','293','1','130',1809,'3','1',109297.66,110051.75,754.09,177211.15,0.00,0.00,0.00,0.00,0.00),('1','293','1','130',1810,'4','1',68209.65,68209.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','130',1811,'5','1',80848.29,80848.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','130',1812,'6','1',153085.31,153875.19,789.88,185621.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','130',1813,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','130',1814,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','130',1815,'9','1',143640.47,143869.19,228.72,53749.20,0.00,0.00,0.00,0.00,0.00),('1','293','2','130',1816,'10','1',123646.31,124251.48,605.17,142214.95,0.00,0.00,0.00,0.00,0.00),('1','293','2','130',1817,'11','1',153033.96,153571.62,537.66,126350.10,0.00,0.00,0.00,0.00,0.00),('1','293','2','130',1818,'12','1',179102.99,180109.41,1006.42,236508.70,0.00,0.00,0.00,0.00,0.00),('1','293','3','130',1819,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','130',1820,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','131',1821,'1','1',83752.11,83752.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','131',1822,'2','1',105883.92,107906.20,2022.28,475235.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','131',1823,'3','1',110051.75,111684.86,1633.11,383780.85,0.00,0.00,0.00,0.00,0.00),('1','293','1','131',1824,'4','1',68209.65,70428.21,2218.56,521361.60,0.00,0.00,0.00,0.00,0.00),('1','293','1','131',1825,'5','1',80848.29,80848.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','131',1826,'6','1',153875.19,156962.68,3087.49,725560.15,0.00,0.00,0.00,0.00,0.00),('1','293','1','131',1827,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','131',1828,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','131',1829,'9','1',143869.19,145937.82,2068.63,486128.05,0.00,0.00,0.00,0.00,0.00),('1','293','2','131',1830,'10','1',124251.48,124251.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','131',1831,'11','1',153571.62,153571.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','131',1832,'12','1',180109.41,182785.85,2676.44,628963.40,0.00,0.00,0.00,0.00,0.00),('1','293','3','131',1833,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','131',1834,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','132',1835,'1','1',83752.11,83752.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','132',1836,'2','1',107906.20,107906.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','132',1837,'3','1',111684.86,111684.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','132',1838,'4','1',70428.21,70428.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','132',1839,'5','1',80848.29,80848.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','132',1840,'6','1',156962.68,156962.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','132',1841,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','132',1842,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','132',1843,'9','1',145937.82,145937.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','132',1844,'10','1',124251.48,124251.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','132',1845,'11','1',153571.62,153571.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','132',1846,'12','1',182785.85,182785.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','132',1847,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','132',1848,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','133',1849,'1','1',83752.11,86059.19,2307.08,542163.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','133',1850,'2','1',107906.20,107906.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','133',1851,'3','1',111684.86,112569.13,884.27,207803.45,0.00,0.00,0.00,0.00,0.00),('1','293','1','133',1852,'4','1',70428.21,70428.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','133',1853,'5','1',80848.29,80848.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','133',1854,'6','1',156962.68,158518.40,1555.72,365594.20,0.00,0.00,0.00,0.00,0.00),('1','293','1','133',1855,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','133',1856,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','133',1857,'9','1',145937.82,145937.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','133',1858,'10','1',124251.48,126650.99,2399.51,563884.85,0.00,0.00,0.00,0.00,0.00),('1','293','2','133',1859,'11','1',153571.62,153571.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','133',1860,'12','1',182785.85,184514.50,1728.65,406232.75,0.00,0.00,0.00,0.00,0.00),('1','293','3','133',1861,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','133',1862,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','134',1863,'1','1',86059.19,87496.27,1437.08,337713.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','134',1864,'2','1',107906.20,108645.88,739.68,173824.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','134',1865,'3','1',112569.13,113346.75,777.62,182740.70,0.00,0.00,0.00,0.00,0.00),('1','293','1','134',1866,'4','1',70428.21,71671.09,1242.88,292076.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','134',1867,'5','1',80848.29,83180.13,2331.84,547982.40,0.00,0.00,0.00,0.00,0.00),('1','293','1','134',1868,'6','1',158518.40,160886.54,2368.14,556512.90,0.00,0.00,0.00,0.00,0.00),('1','293','1','134',1869,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','134',1870,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','134',1871,'9','1',145937.82,147316.85,1379.03,324072.05,0.00,0.00,0.00,0.00,0.00),('1','293','2','134',1872,'10','1',126650.99,127276.14,625.15,146910.25,0.00,0.00,0.00,0.00,0.00),('1','293','2','134',1873,'11','1',153571.62,154218.25,646.63,151958.05,0.00,0.00,0.00,0.00,0.00),('1','293','2','134',1874,'12','1',184514.50,186429.51,1915.01,450027.35,0.00,0.00,0.00,0.00,0.00),('1','293','3','134',1875,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','134',1876,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','135',1877,'1','1',87496.27,87496.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','135',1878,'2','1',108645.88,110981.78,2335.90,548936.50,0.00,0.00,0.00,0.00,0.00),('1','293','1','135',1879,'3','1',113346.75,115144.80,1798.05,422541.75,0.00,0.00,0.00,0.00,0.00),('1','293','1','135',1880,'4','1',71671.09,71671.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','135',1881,'5','1',83180.13,83180.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','135',1882,'6','1',160886.54,163319.50,2432.96,571745.60,0.00,0.00,0.00,0.00,0.00),('1','293','1','135',1883,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','135',1884,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','135',1885,'9','1',147316.85,149965.19,2648.34,622359.90,0.00,0.00,0.00,0.00,0.00),('1','293','2','135',1886,'10','1',127276.14,127413.18,137.04,32204.40,0.00,0.00,0.00,0.00,0.00),('1','293','2','135',1887,'11','1',154218.25,155951.92,1733.67,407412.45,0.00,0.00,0.00,0.00,0.00),('1','293','2','135',1888,'12','1',186429.51,188099.84,1670.33,392527.55,0.00,0.00,0.00,0.00,0.00),('1','293','3','135',1889,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','135',1890,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','136',1891,'1','1',87496.27,88365.42,869.15,204250.25,0.00,0.00,0.00,0.00,0.00),('1','293','1','136',1892,'2','1',110981.78,110981.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','136',1893,'3','1',115144.80,116804.37,1659.57,389998.95,0.00,0.00,0.00,0.00,0.00),('1','293','1','136',1894,'4','1',71671.09,71671.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','136',1895,'5','1',83180.13,83180.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','136',1896,'6','1',163319.50,165602.67,2283.17,536544.95,0.00,0.00,0.00,0.00,0.00),('1','293','1','136',1897,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','136',1898,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','136',1899,'9','1',149965.19,154343.28,4378.09,1028851.15,0.00,0.00,0.00,0.00,0.00),('1','293','2','136',1900,'10','1',127413.18,132798.52,5385.34,1265554.90,0.00,0.00,0.00,0.00,0.00),('1','293','2','136',1901,'11','1',155951.92,158547.54,2595.62,609970.70,0.00,0.00,0.00,0.00,0.00),('1','293','2','136',1902,'12','1',188099.84,192922.28,4822.44,1133273.40,0.00,0.00,0.00,0.00,0.00),('1','293','3','136',1903,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','136',1904,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','137',1905,'1','1',88365.42,88365.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','137',1906,'2','1',110981.78,114059.90,3078.12,723358.20,0.00,0.00,0.00,0.00,0.00),('1','293','1','137',1907,'3','1',116804.37,118712.36,1907.99,448377.65,0.00,0.00,0.00,0.00,0.00),('1','293','1','137',1908,'4','1',71671.09,71671.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','137',1909,'5','1',83180.13,83180.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','137',1910,'6','1',165602.67,168055.22,2452.55,576349.25,0.00,0.00,0.00,0.00,0.00),('1','293','1','137',1911,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','137',1912,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','137',1913,'9','1',154343.28,154343.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','137',1914,'10','1',132798.52,135257.46,2458.94,577850.90,0.00,0.00,0.00,0.00,0.00),('1','293','2','137',1915,'11','1',158547.54,160678.44,2130.90,500761.50,0.00,0.00,0.00,0.00,0.00),('1','293','2','137',1916,'12','1',192922.28,195330.39,2408.11,565905.85,0.00,0.00,0.00,0.00,0.00),('1','293','3','137',1917,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','137',1918,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','138',1919,'1','1',88365.42,89868.02,1502.60,353111.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','138',1920,'2','1',114059.90,114059.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','138',1921,'3','1',118712.36,121568.26,2855.90,671136.50,0.00,0.00,0.00,0.00,0.00),('1','293','1','138',1922,'4','1',71671.09,71671.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','138',1923,'5','1',83180.13,84225.59,1045.46,245683.10,0.00,0.00,0.00,0.00,0.00),('1','293','1','138',1924,'6','1',168055.22,172862.70,4807.48,1129757.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','138',1925,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','138',1926,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','138',1927,'9','1',154343.28,155953.42,1610.14,378382.90,0.00,0.00,0.00,0.00,0.00),('1','293','2','138',1928,'10','1',135257.46,137536.02,2278.56,535461.60,0.00,0.00,0.00,0.00,0.00),('1','293','2','138',1929,'11','1',160678.44,160678.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','138',1930,'12','1',195330.39,195330.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','138',1931,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','138',1932,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','139',1933,'1','1',89868.02,89868.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','139',1934,'2','1',114059.90,116359.25,2299.35,540347.25,0.00,0.00,0.00,0.00,0.00),('1','293','1','139',1935,'3','1',121568.26,121568.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','139',1936,'4','1',71671.09,74058.09,2387.00,560945.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','139',1937,'5','1',84225.59,84225.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','139',1938,'6','1',172862.70,175194.35,2331.65,547937.75,0.00,0.00,0.00,0.00,0.00),('1','293','1','139',1939,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','139',1940,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','139',1941,'9','1',155953.42,157881.47,1928.05,453091.75,0.00,0.00,0.00,0.00,0.00),('1','293','2','139',1942,'10','1',137536.02,139607.76,2071.74,486858.90,0.00,0.00,0.00,0.00,0.00),('1','293','2','139',1943,'11','1',160678.44,162329.94,1651.50,388102.50,0.00,0.00,0.00,0.00,0.00),('1','293','2','139',1944,'12','1',195330.39,197535.13,2204.74,518113.90,0.00,0.00,0.00,0.00,0.00),('1','293','3','139',1945,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','139',1946,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','140',1947,'1','1',89868.02,89868.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','140',1948,'2','1',116359.25,118037.73,1678.48,394442.80,0.00,0.00,0.00,0.00,0.00),('1','293','1','140',1949,'3','1',121568.26,123715.25,2146.99,504542.65,0.00,0.00,0.00,0.00,0.00),('1','293','1','140',1950,'4','1',74058.09,74058.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','140',1951,'5','1',84225.59,84225.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','140',1952,'6','1',175194.35,177490.47,2296.12,539588.20,0.00,0.00,0.00,0.00,0.00),('1','293','1','140',1953,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','140',1954,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','140',1955,'9','1',157881.47,160403.90,2522.43,592771.05,0.00,0.00,0.00,0.00,0.00),('1','293','2','140',1956,'10','1',139607.76,142545.59,2937.83,690390.05,0.00,0.00,0.00,0.00,0.00),('1','293','2','140',1957,'11','1',162329.94,163098.38,768.44,180583.40,0.00,0.00,0.00,0.00,0.00),('1','293','2','140',1958,'12','1',197535.13,199056.80,1521.67,357592.45,0.00,0.00,0.00,0.00,0.00),('1','293','3','140',1959,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','140',1960,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','141',1961,'1','1',89868.02,89868.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','141',1962,'2','1',118037.73,118037.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','141',1963,'3','1',123715.25,123715.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','141',1964,'4','1',74058.09,74058.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','141',1965,'5','1',84225.59,84225.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','141',1966,'6','1',177490.47,177490.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','141',1967,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','141',1968,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','141',1969,'9','1',160403.90,162620.85,2216.95,520983.25,0.00,0.00,0.00,0.00,0.00),('1','293','2','141',1970,'10','1',142545.59,144507.76,1962.17,461109.95,0.00,0.00,0.00,0.00,0.00),('1','293','2','141',1971,'11','1',163098.38,166599.95,3501.57,822868.95,0.00,0.00,0.00,0.00,0.00),('1','293','2','141',1972,'12','1',199056.80,201701.95,2645.15,621610.25,0.00,0.00,0.00,0.00,0.00),('1','293','3','141',1973,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','141',1974,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','142',1975,'1','1',89868.02,91030.36,1162.34,261526.50,0.00,0.00,0.00,0.00,0.00),('1','293','1','142',1976,'2','1',118037.73,119927.55,1889.82,425209.50,0.00,0.00,0.00,0.00,0.00),('1','293','1','142',1977,'3','1',123715.25,123715.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','142',1978,'4','1',74058.09,74058.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','142',1979,'5','1',84225.59,84225.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','142',1980,'6','1',177490.47,180126.40,2635.93,593084.25,0.00,0.00,0.00,0.00,0.00),('1','293','1','142',1981,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','1','142',1982,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','142',1983,'9','1',162620.85,165774.78,3153.93,709634.25,0.00,0.00,0.00,0.00,0.00),('1','293','2','142',1984,'10','1',144507.76,146778.30,2270.54,510871.50,0.00,0.00,0.00,0.00,0.00),('1','293','2','142',1985,'11','1',166599.95,166599.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','2','142',1986,'12','1',201701.95,204641.96,2940.01,661502.25,0.00,0.00,0.00,0.00,0.00),('1','293','3','142',1987,'13','2',24.37,24.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','293','3','142',1988,'14','2',32.04,32.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=285 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','293','1','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,1),('1','293','1','1',178.00,178.00,10355.15,0.00,0.00,0.00,0.00,2),('1','293','2','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,3),('1','293','2','1',178.00,178.00,9500.23,0.00,0.00,0.00,0.00,4),('1','293','3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,5),('1','293','3','1',178.00,178.00,10479.06,0.00,0.00,0.00,0.00,6),('1','293','4','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,7),('1','293','4','1',178.00,178.00,10224.66,0.00,0.00,0.00,0.00,8),('1','293','5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,9),('1','293','5','1',178.00,178.00,12224.02,0.00,0.00,0.00,0.00,10),('1','293','6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,11),('1','293','6','1',178.00,178.00,10792.06,0.00,0.00,0.00,0.00,12),('1','293','7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,13),('1','293','7','1',178.00,178.00,12056.80,0.00,0.00,0.00,0.00,14),('1','293','8','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,15),('1','293','8','1',178.00,178.00,10326.43,0.00,0.00,0.00,0.00,16),('1','293','9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,17),('1','293','9','1',178.00,178.00,11872.93,0.00,0.00,0.00,0.00,18),('1','293','10','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,19),('1','293','10','1',178.00,178.00,9093.10,0.00,0.00,0.00,0.00,20),('1','293','11','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,21),('1','293','11','1',178.00,178.00,9507.83,0.00,0.00,0.00,0.00,22),('1','293','12','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,23),('1','293','12','1',178.00,178.00,9872.31,0.00,0.00,0.00,0.00,24),('1','293','13','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,25),('1','293','13','1',178.00,178.00,9230.77,0.00,0.00,0.00,0.00,26),('1','293','14','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,27),('1','293','14','1',178.00,178.00,5611.97,0.00,0.00,0.00,0.00,28),('1','293','15','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,29),('1','293','15','1',178.00,178.00,2292.45,0.00,0.00,0.00,0.00,30),('1','293','16','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,31),('1','293','16','1',210.00,178.00,10149.63,0.00,0.00,0.00,0.00,32),('1','293','17','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,33),('1','293','17','1',210.00,178.00,10186.99,0.00,0.00,0.00,0.00,34),('1','293','18','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,35),('1','293','18','1',210.00,178.00,0.00,0.00,0.00,0.00,0.00,36),('1','293','19','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,37),('1','293','19','1',210.00,178.00,10133.58,0.00,0.00,0.00,0.00,38),('1','293','20','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,39),('1','293','20','1',210.00,178.00,9840.52,0.00,0.00,0.00,0.00,40),('1','293','21','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,41),('1','293','21','1',210.00,178.00,10761.66,0.00,0.00,0.00,0.00,42),('1','293','22','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,43),('1','293','22','1',210.00,178.00,9668.05,0.00,0.00,0.00,0.00,44),('1','293','23','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,45),('1','293','23','1',210.00,178.00,9932.73,0.00,0.00,0.00,0.00,46),('1','293','24','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,47),('1','293','24','1',210.00,178.00,7896.16,0.00,0.00,0.00,0.00,48),('1','293','25','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,49),('1','293','25','1',210.00,178.00,9772.18,0.00,0.00,0.00,0.00,50),('1','293','26','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,51),('1','293','26','1',210.00,178.00,9589.54,0.00,0.00,0.00,0.00,52),('1','293','27','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,53),('1','293','27','1',210.00,178.00,8759.10,0.00,0.00,0.00,0.00,54),('1','293','28','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,55),('1','293','28','1',210.00,178.00,9546.03,0.00,0.00,0.00,0.00,56),('1','293','29','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,57),('1','293','29','1',210.00,178.00,12556.97,0.00,0.00,0.00,0.00,58),('1','293','30','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,59),('1','293','30','1',210.00,178.00,9849.84,0.00,0.00,0.00,0.00,60),('1','293','31','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,61),('1','293','31','1',210.00,178.00,1264.73,0.00,0.00,0.00,0.00,62),('1','293','32','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,63),('1','293','32','1',210.00,210.00,15762.57,0.00,0.00,0.00,0.00,64),('1','293','33','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,65),('1','293','33','1',210.00,210.00,11740.24,0.00,0.00,0.00,0.00,66),('1','293','34','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,67),('1','293','34','1',210.00,210.00,13908.32,0.00,0.00,0.00,0.00,68),('1','293','35','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,69),('1','293','35','1',210.00,210.00,8586.97,0.00,0.00,0.00,0.00,70),('1','293','36','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,71),('1','293','36','1',210.00,210.00,8773.16,0.00,0.00,0.00,0.00,72),('1','293','37','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,73),('1','293','37','1',210.00,210.00,4346.98,0.00,0.00,0.00,0.00,74),('1','293','38','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,75),('1','293','38','1',210.00,210.00,20962.66,0.00,0.00,0.00,0.00,76),('1','293','39','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,77),('1','293','39','1',210.00,210.00,15728.11,0.00,0.00,0.00,0.00,78),('1','293','40','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,79),('1','293','40','1',210.00,210.00,20451.24,0.00,0.00,0.00,0.00,80),('1','293','41','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,81),('1','293','41','1',210.00,210.00,19768.01,0.00,0.00,0.00,0.00,82),('1','293','42','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,83),('1','293','42','1',210.00,210.00,25148.60,0.00,0.00,0.00,0.00,84),('1','293','43','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,85),('1','293','43','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,86),('1','293','44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,87),('1','293','44','1',210.00,210.00,13808.20,0.00,0.00,0.00,0.00,88),('1','293','45','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,89),('1','293','45','1',210.00,210.00,20211.30,0.00,0.00,0.00,0.00,90),('1','293','46','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,91),('1','293','46','1',210.00,210.00,15818.30,0.00,0.00,0.00,0.00,92),('1','293','47','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,93),('1','293','47','1',210.00,210.00,12662.34,0.00,0.00,0.00,0.00,94),('1','293','48','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,95),('1','293','48','1',210.00,210.00,17508.25,0.00,0.00,0.00,0.00,96),('1','293','49','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,97),('1','293','49','1',210.00,210.00,13962.62,0.00,0.00,0.00,0.00,98),('1','293','50','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,99),('1','293','50','1',210.00,210.00,9649.02,0.00,0.00,0.00,0.00,100),('1','293','51','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,101),('1','293','51','1',230.00,210.00,0.00,0.00,0.00,0.00,0.00,102),('1','293','52','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,103),('1','293','52','1',230.00,230.00,1026.30,0.00,0.00,0.00,0.00,104),('1','293','53','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,105),('1','293','53','1',230.00,230.00,11657.80,0.00,0.00,0.00,0.00,106),('1','293','54','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,107),('1','293','54','1',230.00,230.00,14916.53,0.00,0.00,0.00,0.00,108),('1','293','55','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,109),('1','293','55','1',230.00,230.00,14296.31,0.00,0.00,0.00,0.00,110),('1','293','56','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,111),('1','293','56','1',230.00,230.00,6074.69,0.00,0.00,0.00,0.00,112),('1','293','57','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,113),('1','293','57','1',230.00,230.00,12284.53,0.00,0.00,0.00,0.00,114),('1','293','58','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,115),('1','293','58','1',230.00,230.00,16195.29,0.00,0.00,0.00,0.00,116),('1','293','59','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,117),('1','293','59','1',240.00,240.00,9328.12,0.00,0.00,0.00,0.00,118),('1','293','60','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,119),('1','293','60','1',240.00,240.00,7862.36,0.00,0.00,0.00,0.00,120),('1','293','61','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,121),('1','293','61','1',240.00,240.00,3822.83,0.00,0.00,0.00,0.00,122),('1','293','62','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,123),('1','293','62','1',240.00,240.00,10174.60,0.00,0.00,0.00,0.00,124),('1','293','63','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,125),('1','293','63','1',240.00,240.00,0.00,0.00,0.00,0.00,0.00,126),('1','293','64','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,127),('1','293','64','1',240.00,240.00,3192.58,0.00,0.00,0.00,0.00,128),('1','293','65','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,129),('1','293','65','1',240.00,240.00,3308.59,0.00,0.00,0.00,0.00,130),('1','293','66','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,131),('1','293','66','1',240.00,240.00,6258.81,0.00,0.00,0.00,0.00,132),('1','293','67','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,133),('1','293','67','1',240.00,240.00,2421.20,0.00,0.00,0.00,0.00,134),('1','293','68','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,135),('1','293','68','1',240.00,240.00,7023.71,0.00,0.00,0.00,0.00,136),('1','293','69','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,137),('1','293','69','1',240.00,240.00,13858.59,0.00,0.00,0.00,0.00,138),('1','293','70','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,139),('1','293','70','1',240.00,240.00,7747.24,0.00,0.00,0.00,0.00,140),('1','293','71','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,141),('1','293','71','1',240.00,240.00,1770.20,0.00,0.00,0.00,0.00,142),('1','293','72','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,143),('1','293','72','1',240.00,240.00,15036.96,0.00,0.00,0.00,0.00,144),('1','293','73','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,145),('1','293','73','1',240.00,240.00,9404.28,0.00,0.00,0.00,0.00,146),('1','293','74','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,147),('1','293','74','1',240.00,240.00,5934.03,0.00,0.00,0.00,0.00,148),('1','293','75','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,149),('1','293','75','1',240.00,240.00,2162.82,0.00,0.00,0.00,0.00,150),('1','293','76','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,151),('1','293','76','1',240.00,240.00,0.00,0.00,0.00,0.00,0.00,152),('1','293','77','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,153),('1','293','77','1',240.00,240.00,8433.79,0.00,0.00,0.00,0.00,154),('1','293','78','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,155),('1','293','78','1',240.00,240.00,6488.79,0.00,0.00,0.00,0.00,156),('1','293','79','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,157),('1','293','79','1',240.00,240.00,5343.10,0.00,0.00,0.00,0.00,158),('1','293','80','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,159),('1','293','80','1',240.00,240.00,6551.07,0.00,0.00,0.00,0.00,160),('1','293','81','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,161),('1','293','81','1',240.00,240.00,7821.65,0.00,0.00,0.00,0.00,162),('1','293','82','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,163),('1','293','82','1',240.00,240.00,3471.45,0.00,0.00,0.00,0.00,164),('1','293','83','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,165),('1','293','83','1',240.00,240.00,6977.40,0.00,0.00,0.00,0.00,166),('1','293','84','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,167),('1','293','84','1',240.00,240.00,5530.27,0.00,0.00,0.00,0.00,168),('1','293','85','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,169),('1','293','85','1',240.00,230.00,3868.43,0.00,0.00,0.00,0.00,170),('1','293','86','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,171),('1','293','86','1',240.00,230.00,6454.47,0.00,0.00,0.00,0.00,172),('1','293','87','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,173),('1','293','87','1',240.00,240.00,9101.80,0.00,0.00,0.00,0.00,174),('1','293','88','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,175),('1','293','88','1',240.00,240.00,776.01,0.00,0.00,0.00,0.00,176),('1','293','89','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,177),('1','293','89','1',205.00,205.00,8764.34,0.00,0.00,0.00,0.00,178),('1','293','90','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,179),('1','293','90','1',205.00,205.00,3565.84,0.00,0.00,0.00,0.00,180),('1','293','91','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,181),('1','293','91','1',205.00,205.00,19664.03,0.00,0.00,0.00,0.00,182),('1','293','92','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,183),('1','293','92','1',205.00,205.00,12570.71,0.00,0.00,0.00,0.00,184),('1','293','93','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,185),('1','293','93','1',205.00,205.00,19698.17,0.00,0.00,0.00,0.00,186),('1','293','94','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,187),('1','293','94','1',205.00,205.00,11264.23,0.00,0.00,0.00,0.00,188),('1','293','95','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,189),('1','293','95','1',205.00,205.00,7342.26,0.00,0.00,0.00,0.00,190),('1','293','96','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,191),('1','293','96','1',205.00,205.00,7310.10,0.00,0.00,0.00,0.00,192),('1','293','97','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,193),('1','293','97','1',205.00,205.00,6203.17,0.00,0.00,0.00,0.00,194),('1','293','98','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,195),('1','293','98','1',205.00,205.00,2753.41,0.00,0.00,0.00,0.00,196),('1','293','99','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,197),('1','293','99','1',205.00,205.00,10489.88,0.00,0.00,0.00,0.00,198),('1','293','100','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,199),('1','293','100','1',205.00,205.00,12362.94,0.00,0.00,0.00,0.00,200),('1','293','101','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,201),('1','293','101','1',205.00,205.00,6276.79,0.00,0.00,0.00,0.00,202),('1','293','102','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,203),('1','293','102','1',205.00,205.00,696.88,0.00,0.00,0.00,0.00,204),('1','293','103','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,205),('1','293','103','1',205.00,205.00,1785.08,0.00,0.00,0.00,0.00,206),('1','293','104','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,207),('1','293','104','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,208),('1','293','105','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,209),('1','293','105','1',235.00,210.00,7802.50,0.00,0.00,0.00,0.00,210),('1','293','106','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,211),('1','293','106','1',235.00,210.00,7977.91,0.00,0.00,0.00,0.00,212),('1','293','107','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,213),('1','293','107','1',235.00,210.00,1533.65,0.00,0.00,0.00,0.00,214),('1','293','108','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,215),('1','293','108','1',235.00,210.00,440.74,0.00,0.00,0.00,0.00,216),('1','293','109','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,217),('1','293','109','1',235.00,235.00,16062.37,0.00,0.00,0.00,0.00,218),('1','293','110','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,219),('1','293','110','1',235.00,235.00,6672.26,0.00,0.00,0.00,0.00,220),('1','293','111','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,221),('1','293','111','1',235.00,235.00,14527.92,0.00,0.00,0.00,0.00,222),('1','293','112','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,223),('1','293','112','1',235.00,235.00,4285.95,0.00,0.00,0.00,0.00,224),('1','293','113','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,225),('1','293','113','1',235.00,235.00,13041.45,0.00,0.00,0.00,0.00,226),('1','293','114','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,227),('1','293','114','1',235.00,235.00,3626.68,0.00,0.00,0.00,0.00,228),('1','293','115','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,229),('1','293','115','1',235.00,235.00,20148.73,0.00,0.00,0.00,0.00,230),('1','293','116','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,231),('1','293','116','1',235.00,235.00,3537.84,0.00,0.00,0.00,0.00,232),('1','293','117','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,233),('1','293','117','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,234),('1','293','118','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,235),('1','293','118','1',235.00,235.00,13376.73,0.00,0.00,0.00,0.00,236),('1','293','119','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,237),('1','293','119','1',235.00,235.00,18263.89,0.00,0.00,0.00,0.00,238),('1','293','120','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,239),('1','293','120','1',235.00,235.00,9039.92,0.00,0.00,0.00,0.00,240),('1','293','121','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,241),('1','293','121','1',235.00,235.00,11322.68,0.00,0.00,0.00,0.00,242),('1','293','122','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,243),('1','293','122','1',235.00,235.00,21497.43,0.00,0.00,0.00,0.00,244),('1','293','123','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,245),('1','293','123','1',235.00,235.00,10024.04,0.00,0.00,0.00,0.00,246),('1','293','124','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,247),('1','293','124','1',235.00,235.00,15453.02,0.00,0.00,0.00,0.00,248),('1','293','125','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,249),('1','293','125','1',235.00,235.00,15284.03,0.00,0.00,0.00,0.00,250),('1','293','126','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,251),('1','293','126','1',235.00,235.00,12770.31,0.00,0.00,0.00,0.00,252),('1','293','127','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,253),('1','293','127','1',235.00,235.00,12637.76,0.00,0.00,0.00,0.00,254),('1','293','128','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,255),('1','293','128','1',235.00,235.00,12834.05,0.00,0.00,0.00,0.00,256),('1','293','129','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,257),('1','293','129','1',235.00,235.00,6731.12,0.00,0.00,0.00,0.00,258),('1','293','130','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,259),('1','293','130','1',235.00,235.00,5326.88,0.00,0.00,0.00,0.00,260),('1','293','131','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,261),('1','293','131','1',235.00,235.00,13706.51,0.00,0.00,0.00,0.00,262),('1','293','132','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,263),('1','293','132','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,264),('1','293','133','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,265),('1','293','133','1',235.00,235.00,8875.23,0.00,0.00,0.00,0.00,266),('1','293','134','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,267),('1','293','134','1',235.00,235.00,13463.06,0.00,0.00,0.00,0.00,268),('1','293','135','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,269),('1','293','135','1',235.00,235.00,12756.29,0.00,0.00,0.00,0.00,270),('1','293','136','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,271),('1','293','136','1',235.00,235.00,21993.38,0.00,0.00,0.00,0.00,272),('1','293','137','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,273),('1','293','137','1',235.00,235.00,14436.61,0.00,0.00,0.00,0.00,274),('1','293','138','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,275),('1','293','138','1',235.00,235.00,14100.14,0.00,0.00,0.00,0.00,276),('1','293','139','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,277),('1','293','139','1',235.00,235.00,14874.03,0.00,0.00,0.00,0.00,278),('1','293','140','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,279),('1','293','140','1',235.00,235.00,13871.96,0.00,0.00,0.00,0.00,280),('1','293','141','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,281),('1','293','141','1',235.00,235.00,10325.84,0.00,0.00,0.00,0.00,282),('1','293','142','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,283),('1','293','142','1',235.00,225.00,14052.57,0.00,0.00,0.00,0.00,284);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',1,'293','PMS TANKS',''),('1',2,'293','AGO TANKS','');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','293','1',1,0,'1','PMS TANK 1 & 2',100000.00,0.00,NULL,'CONTAING PMS','178','2022-10-20 11:08:11','2022-10-20 11:08:11','178',5,0),('1','293','1',2,0,'1','PMS TANK 3 & 4',100000.00,0.00,NULL,'CONTAING PMS','178','2022-10-20 11:12:18','2022-10-20 11:12:18','178',5,0),('1','293','2',3,0,'2','AGO TANK 1',50000.00,0.00,NULL,'CONTAING AGO','178','2022-10-20 11:14:18','2022-10-20 11:14:18','178',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','293',3,0.00,'2023-03-21 00:34:44'),(2,'1','293',2,17247.39,'2023-03-21 00:34:44'),(3,'1','293',1,32160.90,'2023-03-21 00:34:44');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=1016 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'1','293',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8544000.00,48000.00,0.00,0.00,'2022-11-01 18:15:56','',''),(2,'1','293',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8900000.00,50000.00,0.00,0.00,'2022-11-01 18:16:23','',''),(3,'1','293',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8900000.00,50000.00,0.00,0.00,'2022-11-01 18:16:49','',''),(4,'1','293',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8900000.00,50000.00,0.00,0.00,'2022-11-01 18:17:15','',''),(5,'1','293',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8010000.00,45000.00,0.00,0.00,'2022-11-01 18:17:52','',''),(6,'1','293',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8010000.00,45000.00,0.00,0.00,'2022-11-01 18:18:14','',''),(7,'1','293',NULL,1,'Reception corrector for bridging 1',0.00,0.00,0.00,48000.00,0.00,'2022-11-02 16:34:03','',''),(8,'1','293','1',1,'Received from bridging 1',0.00,0.00,48000.00,0.00,0.00,'2022-11-02 16:34:03','',''),(9,'1','293',NULL,1,'Reception corrector for bridging 2',0.00,0.00,0.00,50000.00,0.00,'2022-11-02 22:47:20','',''),(10,'1','293','2',1,'Received from bridging 2',0.00,0.00,50000.00,0.00,0.00,'2022-11-02 22:47:20','',''),(11,'1','293',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,50000.00,0.00,'2022-11-02 22:48:41','',''),(12,'1','293','2',1,'Received from bridging 3',0.00,0.00,50000.00,0.00,0.00,'2022-11-02 22:48:41','',''),(13,'1','293',NULL,1,'Reception corrector for bridging 4',0.00,0.00,0.00,50000.00,0.00,'2022-11-02 22:50:18','',''),(14,'1','293','1',1,'Received from bridging 4',0.00,0.00,50000.00,0.00,0.00,'2022-11-02 22:50:18','',''),(15,'1','293','1',1,'Sale Id shift 1',0.00,0.00,0.00,683.53,0.00,'2022-11-03 09:56:57','',''),(16,'1','293','1',1,'Sale Id shift 1',0.00,0.00,0.00,619.08,0.00,'2022-11-03 09:56:57','',''),(17,'1','293','1',1,'Sale Id shift 1',0.00,0.00,0.00,1779.50,0.00,'2022-11-03 09:56:57','',''),(18,'1','293','1',1,'Sale Id shift 1',0.00,0.00,0.00,687.75,0.00,'2022-11-03 09:56:57','',''),(19,'1','293','1',1,'Sale Id shift 1',0.00,0.00,0.00,913.92,0.00,'2022-11-03 09:56:57','',''),(20,'1','293','1',1,'Sale Id shift 1',0.00,0.00,0.00,951.60,0.00,'2022-11-03 09:56:57','',''),(21,'1','293','2',1,'Sale Id shift 1',0.00,0.00,0.00,1245.84,0.00,'2022-11-03 09:56:57','',''),(22,'1','293','2',1,'Sale Id shift 1',0.00,0.00,0.00,1152.66,0.00,'2022-11-03 09:56:57','',''),(23,'1','293','2',1,'Sale Id shift 1',0.00,0.00,0.00,1325.57,0.00,'2022-11-03 09:56:57','',''),(24,'1','293','2',1,'Sale Id shift 1',0.00,0.00,0.00,995.70,0.00,'2022-11-03 09:56:57','',''),(25,'1','293',NULL,1,'Sale Id shift 1',1843216.70,0.00,0.00,0.00,0.00,'2022-11-03 09:56:57','',''),(26,'1','293','1',1,'Sale Id shift 2',0.00,0.00,0.00,839.83,0.00,'2022-11-07 08:25:35','',''),(27,'1','293','1',1,'Sale Id shift 2',0.00,0.00,0.00,627.49,0.00,'2022-11-07 08:25:35','',''),(28,'1','293','1',1,'Sale Id shift 2',0.00,0.00,0.00,1303.50,0.00,'2022-11-07 08:25:35','',''),(29,'1','293','1',1,'Sale Id shift 2',0.00,0.00,0.00,505.11,0.00,'2022-11-07 08:25:35','',''),(30,'1','293','1',1,'Sale Id shift 2',0.00,0.00,0.00,486.66,0.00,'2022-11-07 08:25:35','',''),(31,'1','293','1',1,'Sale Id shift 2',0.00,0.00,0.00,481.95,0.00,'2022-11-07 08:25:35','',''),(32,'1','293','2',1,'Sale Id shift 2',0.00,0.00,0.00,1502.67,0.00,'2022-11-07 08:25:35','',''),(33,'1','293','2',1,'Sale Id shift 2',0.00,0.00,0.00,1511.49,0.00,'2022-11-07 08:25:35','',''),(34,'1','293','2',1,'Sale Id shift 2',0.00,0.00,0.00,1211.43,0.00,'2022-11-07 08:25:35','',''),(35,'1','293','2',1,'Sale Id shift 2',0.00,0.00,0.00,1030.10,0.00,'2022-11-07 08:25:35','',''),(36,'1','293',NULL,1,'Sale Id shift 2',1691040.94,0.00,0.00,0.00,0.00,'2022-11-07 08:25:35','',''),(37,'1','293','1',1,'Sale Id shift 3',0.00,0.00,0.00,849.50,0.00,'2022-11-10 16:31:26','',''),(38,'1','293','2',1,'Sale Id shift 3',0.00,0.00,0.00,1452.28,0.00,'2022-11-10 16:31:26','',''),(39,'1','293','2',1,'Sale Id shift 3',0.00,0.00,0.00,1070.70,0.00,'2022-11-10 16:31:26','',''),(40,'1','293','2',1,'Sale Id shift 3',0.00,0.00,0.00,1418.12,0.00,'2022-11-10 16:31:26','',''),(41,'1','293','1',1,'Sale Id shift 3',0.00,0.00,0.00,745.51,0.00,'2022-11-10 16:31:26','',''),(42,'1','293','1',1,'Sale Id shift 3',0.00,0.00,0.00,1279.33,0.00,'2022-11-10 16:31:26','',''),(43,'1','293','1',1,'Sale Id shift 3',0.00,0.00,0.00,1008.27,0.00,'2022-11-10 16:31:26','',''),(44,'1','293','1',1,'Sale Id shift 3',0.00,0.00,0.00,808.89,0.00,'2022-11-10 16:31:26','',''),(45,'1','293','1',1,'Sale Id shift 3',0.00,0.00,0.00,868.65,0.00,'2022-11-10 16:31:26','',''),(46,'1','293','2',1,'Sale Id shift 3',0.00,0.00,0.00,977.81,0.00,'2022-11-10 16:31:26','',''),(47,'1','293',NULL,1,'Sale Id shift 3',1865272.68,0.00,0.00,0.00,0.00,'2022-11-10 16:31:26','',''),(48,'1','293','1',1,'Sale Id shift 4',0.00,0.00,0.00,661.95,0.00,'2022-11-10 16:45:12','',''),(49,'1','293','2',1,'Sale Id shift 4',0.00,0.00,0.00,874.24,0.00,'2022-11-10 16:45:12','',''),(50,'1','293','2',1,'Sale Id shift 4',0.00,0.00,0.00,1515.22,0.00,'2022-11-10 16:45:12','',''),(51,'1','293','2',1,'Sale Id shift 4',0.00,0.00,0.00,1260.04,0.00,'2022-11-10 16:45:12','',''),(52,'1','293','1',1,'Sale Id shift 4',0.00,0.00,0.00,551.27,0.00,'2022-11-10 16:45:12','',''),(53,'1','293','1',1,'Sale Id shift 4',0.00,0.00,0.00,1018.78,0.00,'2022-11-10 16:45:12','',''),(54,'1','293','1',1,'Sale Id shift 4',0.00,0.00,0.00,815.38,0.00,'2022-11-10 16:45:12','',''),(55,'1','293','1',1,'Sale Id shift 4',0.00,0.00,0.00,677.95,0.00,'2022-11-10 16:45:12','',''),(56,'1','293','1',1,'Sale Id shift 4',0.00,0.00,0.00,1021.79,0.00,'2022-11-10 16:45:12','',''),(57,'1','293','2',1,'Sale Id shift 4',0.00,0.00,0.00,1828.04,0.00,'2022-11-10 16:45:12','',''),(58,'1','293',NULL,1,'Sale Id shift 4',1819989.48,0.00,0.00,0.00,0.00,'2022-11-10 16:45:12','',''),(59,'1','293','1',1,'Sale Id shift 5',0.00,0.00,0.00,1387.00,0.00,'2022-11-10 16:58:12','',''),(60,'1','293','2',1,'Sale Id shift 5',0.00,0.00,0.00,1220.71,0.00,'2022-11-10 16:58:12','',''),(61,'1','293','2',1,'Sale Id shift 5',0.00,0.00,0.00,1361.21,0.00,'2022-11-10 16:58:12','',''),(62,'1','293','2',1,'Sale Id shift 5',0.00,0.00,0.00,1059.47,0.00,'2022-11-10 16:58:12','',''),(63,'1','293','1',1,'Sale Id shift 5',0.00,0.00,0.00,963.35,0.00,'2022-11-10 16:58:12','',''),(64,'1','293','1',1,'Sale Id shift 5',0.00,0.00,0.00,2148.48,0.00,'2022-11-10 16:58:12','',''),(65,'1','293','1',1,'Sale Id shift 5',0.00,0.00,0.00,1031.40,0.00,'2022-11-10 16:58:12','',''),(66,'1','293','1',1,'Sale Id shift 5',0.00,0.00,0.00,997.05,0.00,'2022-11-10 16:58:12','',''),(67,'1','293','1',1,'Sale Id shift 5',0.00,0.00,0.00,890.72,0.00,'2022-11-10 16:58:12','',''),(68,'1','293','2',1,'Sale Id shift 5',0.00,0.00,0.00,1164.63,0.00,'2022-11-10 16:58:12','',''),(69,'1','293',NULL,1,'Sale Id shift 5',2175875.56,0.00,0.00,0.00,0.00,'2022-11-10 16:58:12','',''),(70,'1','293','2',1,'Sale Id shift 6',0.00,0.00,0.00,2702.53,0.00,'2022-11-10 17:09:05','',''),(71,'1','293','1',1,'Sale Id shift 6',0.00,0.00,0.00,2145.37,0.00,'2022-11-10 17:09:05','',''),(72,'1','293','1',1,'Sale Id shift 6',0.00,0.00,0.00,1964.77,0.00,'2022-11-10 17:09:05','',''),(73,'1','293','1',1,'Sale Id shift 6',0.00,0.00,0.00,1930.04,0.00,'2022-11-10 17:09:05','',''),(74,'1','293','2',1,'Sale Id shift 6',0.00,0.00,0.00,2049.35,0.00,'2022-11-10 17:09:05','',''),(75,'1','293',NULL,1,'Sale Id shift 6',1920986.68,0.00,0.00,0.00,0.00,'2022-11-10 17:09:05','',''),(76,'1','293','1',1,'Sale Id shift 7',0.00,0.00,0.00,2889.72,0.00,'2022-11-10 17:36:41','',''),(77,'1','293','2',1,'Sale Id shift 7',0.00,0.00,0.00,2386.53,0.00,'2022-11-10 17:36:41','',''),(78,'1','293','2',1,'Sale Id shift 7',0.00,0.00,0.00,2374.24,0.00,'2022-11-10 17:36:41','',''),(79,'1','293','1',1,'Sale Id shift 7',0.00,0.00,0.00,2413.25,0.00,'2022-11-10 17:36:41','',''),(80,'1','293','1',1,'Sale Id shift 7',0.00,0.00,0.00,1993.06,0.00,'2022-11-10 17:36:41','',''),(81,'1','293',NULL,1,'Sale Id shift 7',2146110.40,0.00,0.00,0.00,0.00,'2022-11-10 17:36:41','',''),(82,'1','293','2',1,'Sale Id shift 8',0.00,0.00,0.00,2413.31,0.00,'2022-11-11 10:37:36','',''),(83,'1','293','1',1,'Sale Id shift 8',0.00,0.00,0.00,1853.23,0.00,'2022-11-11 10:37:36','',''),(84,'1','293','1',1,'Sale Id shift 8',0.00,0.00,0.00,1932.36,0.00,'2022-11-11 10:37:36','',''),(85,'1','293','1',1,'Sale Id shift 8',0.00,0.00,0.00,2036.17,0.00,'2022-11-11 10:37:36','',''),(86,'1','293','2',1,'Sale Id shift 8',0.00,0.00,0.00,2091.36,0.00,'2022-11-11 10:37:36','',''),(87,'1','293',NULL,1,'Sale Id shift 8',1838104.54,0.00,0.00,0.00,0.00,'2022-11-11 10:37:37','',''),(88,'1','293','1',1,'Sale Id shift 9',0.00,0.00,0.00,2733.34,0.00,'2022-11-11 12:19:45','',''),(89,'1','293','2',1,'Sale Id shift 9',0.00,0.00,0.00,2566.24,0.00,'2022-11-11 12:19:45','',''),(90,'1','293','2',1,'Sale Id shift 9',0.00,0.00,0.00,2317.29,0.00,'2022-11-11 12:19:45','',''),(91,'1','293','1',1,'Sale Id shift 9',0.00,0.00,0.00,2419.08,0.00,'2022-11-11 12:19:45','',''),(92,'1','293','1',1,'Sale Id shift 9',0.00,0.00,0.00,1836.98,0.00,'2022-11-11 12:19:45','',''),(93,'1','293',NULL,1,'Sale Id shift 9',2113381.54,0.00,0.00,0.00,0.00,'2022-11-11 12:19:45','',''),(94,'1','293','1',1,'Sale Id shift 10',0.00,0.00,0.00,1725.69,0.00,'2022-11-12 08:16:30','',''),(95,'1','293','2',1,'Sale Id shift 10',0.00,0.00,0.00,2399.69,0.00,'2022-11-12 08:16:30','',''),(96,'1','293','1',1,'Sale Id shift 10',0.00,0.00,0.00,1425.07,0.00,'2022-11-12 08:16:30','',''),(97,'1','293','1',1,'Sale Id shift 10',0.00,0.00,0.00,1721.79,0.00,'2022-11-12 08:16:30','',''),(98,'1','293','2',1,'Sale Id shift 10',0.00,0.00,0.00,1820.86,0.00,'2022-11-12 08:16:30','',''),(99,'1','293',NULL,1,'Sale Id shift 10',1618571.80,0.00,0.00,0.00,0.00,'2022-11-12 08:16:30','',''),(100,'1','293','2',1,'Sale Id shift 11',0.00,0.00,0.00,1352.60,0.00,'2022-11-14 09:09:16','',''),(101,'1','293','2',1,'Sale Id shift 11',0.00,0.00,0.00,1605.34,0.00,'2022-11-14 09:09:16','',''),(102,'1','293','1',1,'Sale Id shift 11',0.00,0.00,0.00,1202.06,0.00,'2022-11-14 09:09:16','',''),(103,'1','293','1',1,'Sale Id shift 11',0.00,0.00,0.00,2425.00,0.00,'2022-11-14 09:09:16','',''),(104,'1','293','1',1,'Sale Id shift 11',0.00,0.00,0.00,1314.63,0.00,'2022-11-14 09:09:16','',''),(105,'1','293','2',1,'Sale Id shift 11',0.00,0.00,0.00,1608.20,0.00,'2022-11-14 09:09:16','',''),(106,'1','293',NULL,1,'Sale Id shift 11',1692393.74,0.00,0.00,0.00,0.00,'2022-11-14 09:09:16','',''),(107,'1','293','2',1,'Sale Id shift 12',0.00,0.00,0.00,1730.77,0.00,'2022-11-15 21:35:02','',''),(108,'1','293','2',1,'Sale Id shift 12',0.00,0.00,0.00,1512.77,0.00,'2022-11-15 21:35:02','',''),(109,'1','293','1',1,'Sale Id shift 12',0.00,0.00,0.00,1466.63,0.00,'2022-11-15 21:35:02','',''),(110,'1','293','1',1,'Sale Id shift 12',0.00,0.00,0.00,2180.68,0.00,'2022-11-15 21:35:02','',''),(111,'1','293','1',1,'Sale Id shift 12',0.00,0.00,0.00,11.24,0.00,'2022-11-15 21:35:02','',''),(112,'1','293','1',1,'Sale Id shift 12',0.00,0.00,0.00,1377.36,0.00,'2022-11-15 21:35:02','',''),(113,'1','293','2',1,'Sale Id shift 12',0.00,0.00,0.00,1592.86,0.00,'2022-11-15 21:35:02','',''),(114,'1','293',NULL,1,'Sale Id shift 12',1757271.18,0.00,0.00,0.00,0.00,'2022-11-15 21:35:02','',''),(115,'1','293',NULL,1,'Reception corrector for bridging 5',0.00,0.00,0.00,45000.00,0.00,'2022-11-16 17:39:49','',''),(116,'1','293','1',1,'Received from bridging 5',0.00,0.00,45000.00,0.00,0.00,'2022-11-16 17:39:49','',''),(117,'1','293',NULL,1,'Reception corrector for bridging 6',0.00,0.00,0.00,45000.00,0.00,'2022-11-16 17:40:45','',''),(118,'1','293','2',1,'Received from bridging 6',0.00,0.00,45000.00,0.00,0.00,'2022-11-16 17:40:45','',''),(119,'1','293','1',1,'Sale Id shift 13',0.00,0.00,0.00,25.96,0.00,'2022-11-18 06:27:19','',''),(120,'1','293','2',1,'Sale Id shift 13',0.00,0.00,0.00,2708.03,0.00,'2022-11-18 06:27:19','',''),(121,'1','293','2',1,'Sale Id shift 13',0.00,0.00,0.00,2472.08,0.00,'2022-11-18 06:27:19','',''),(122,'1','293','2',1,'Sale Id shift 13',0.00,0.00,0.00,1631.13,0.00,'2022-11-18 06:27:19','',''),(123,'1','293','1',1,'Sale Id shift 13',0.00,0.00,0.00,15.19,0.00,'2022-11-18 06:27:19','',''),(124,'1','293','1',1,'Sale Id shift 13',0.00,0.00,0.00,11.51,0.00,'2022-11-18 06:27:19','',''),(125,'1','293','2',1,'Sale Id shift 13',0.00,0.00,0.00,2366.87,0.00,'2022-11-18 06:27:19','',''),(126,'1','293',NULL,1,'Sale Id shift 13',1643077.06,0.00,0.00,0.00,0.00,'2022-11-18 06:27:19','',''),(127,'1','293','2',1,'Sale Id shift 14',0.00,0.00,0.00,1268.18,0.00,'2022-11-23 01:31:04','',''),(128,'1','293','2',1,'Sale Id shift 14',0.00,0.00,0.00,1386.58,0.00,'2022-11-23 01:31:04','',''),(129,'1','293','2',1,'Sale Id shift 14',0.00,0.00,0.00,1418.31,0.00,'2022-11-23 01:31:04','',''),(130,'1','293','2',1,'Sale Id shift 14',0.00,0.00,0.00,1538.90,0.00,'2022-11-23 01:31:04','',''),(131,'1','293',NULL,1,'Sale Id shift 14',998930.66,0.00,0.00,0.00,0.00,'2022-11-23 01:31:04','',''),(132,'1','293','2',1,'Sale Id shift 15',0.00,0.00,0.00,444.10,0.00,'2022-11-24 04:31:02','',''),(133,'1','293','2',1,'Sale Id shift 15',0.00,0.00,0.00,642.77,0.00,'2022-11-24 04:31:02','',''),(134,'1','293','2',1,'Sale Id shift 15',0.00,0.00,0.00,502.70,0.00,'2022-11-24 04:31:02','',''),(135,'1','293','2',1,'Sale Id shift 15',0.00,0.00,0.00,702.88,0.00,'2022-11-24 04:31:02','',''),(136,'1','293',NULL,1,'Sale Id shift 15',408056.10,0.00,0.00,0.00,0.00,'2022-11-24 04:31:02','',''),(137,'1','293',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,12600000.00,60000.00,0.00,0.00,'2022-11-24 04:32:47','',''),(138,'1','293',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9450000.00,45000.00,0.00,0.00,'2022-11-24 04:33:40','',''),(139,'1','293',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9450000.00,45000.00,0.00,0.00,'2022-11-24 04:34:45','',''),(140,'1','293','1',1,'Sale Id shift 16',0.00,0.00,0.00,1960.47,0.00,'2022-11-24 11:24:08','',''),(141,'1','293','2',1,'Sale Id shift 16',0.00,0.00,0.00,572.16,0.00,'2022-11-24 11:24:08','',''),(142,'1','293','2',1,'Sale Id shift 16',0.00,0.00,0.00,2114.52,0.00,'2022-11-24 11:24:08','',''),(143,'1','293','1',1,'Sale Id shift 16',0.00,0.00,0.00,2041.85,0.00,'2022-11-24 11:24:08','',''),(144,'1','293','1',1,'Sale Id shift 16',0.00,0.00,0.00,347.97,0.00,'2022-11-24 11:24:08','',''),(145,'1','293','1',1,'Sale Id shift 16',0.00,0.00,0.00,1447.27,0.00,'2022-11-24 11:24:08','',''),(146,'1','293','2',1,'Sale Id shift 16',0.00,0.00,0.00,1665.39,0.00,'2022-11-24 11:24:08','',''),(147,'1','293',NULL,1,'Sale Id shift 16',2131422.30,0.00,0.00,0.00,0.00,'2022-11-24 11:24:08','',''),(148,'1','293','1',1,'Sale Id shift 17',0.00,0.00,0.00,1484.46,0.00,'2022-11-25 17:26:36','',''),(149,'1','293','2',1,'Sale Id shift 17',0.00,0.00,0.00,2593.75,0.00,'2022-11-25 17:26:36','',''),(150,'1','293','2',1,'Sale Id shift 17',0.00,0.00,0.00,1646.34,0.00,'2022-11-25 17:26:36','',''),(151,'1','293','1',1,'Sale Id shift 17',0.00,0.00,0.00,1132.67,0.00,'2022-11-25 17:26:36','',''),(152,'1','293','1',1,'Sale Id shift 17',0.00,0.00,0.00,1394.98,0.00,'2022-11-25 17:26:36','',''),(153,'1','293','1',1,'Sale Id shift 17',0.00,0.00,0.00,1909.10,0.00,'2022-11-25 17:26:36','',''),(154,'1','293','2',1,'Sale Id shift 17',0.00,0.00,0.00,25.69,0.00,'2022-11-25 17:26:36','',''),(155,'1','293',NULL,1,'Sale Id shift 17',2139267.90,0.00,0.00,0.00,0.00,'2022-11-25 17:26:36','',''),(156,'1','293','1',1,'Sale Id shift 19',0.00,0.00,0.00,2229.26,0.00,'2022-11-26 10:14:55','',''),(157,'1','293','2',1,'Sale Id shift 19',0.00,0.00,0.00,2227.49,0.00,'2022-11-26 10:14:55','',''),(158,'1','293','1',1,'Sale Id shift 19',0.00,0.00,0.00,2085.33,0.00,'2022-11-26 10:14:55','',''),(159,'1','293','1',1,'Sale Id shift 19',0.00,0.00,0.00,1565.75,0.00,'2022-11-26 10:14:55','',''),(160,'1','293','2',1,'Sale Id shift 19',0.00,0.00,0.00,2025.75,0.00,'2022-11-26 10:14:55','',''),(161,'1','293',NULL,1,'Sale Id shift 19',2128051.80,0.00,0.00,0.00,0.00,'2022-11-26 10:14:55','',''),(162,'1','293','1',1,'Sale Id shift 20',0.00,0.00,0.00,1034.60,0.00,'2022-11-26 10:26:24','',''),(163,'1','293','2',1,'Sale Id shift 20',0.00,0.00,0.00,2486.87,0.00,'2022-11-26 10:26:24','',''),(164,'1','293','2',1,'Sale Id shift 20',0.00,0.00,0.00,1879.10,0.00,'2022-11-26 10:26:24','',''),(165,'1','293','1',1,'Sale Id shift 20',0.00,0.00,0.00,1154.37,0.00,'2022-11-26 10:26:24','',''),(166,'1','293','1',1,'Sale Id shift 20',0.00,0.00,0.00,1758.91,0.00,'2022-11-26 10:26:24','',''),(167,'1','293','1',1,'Sale Id shift 20',0.00,0.00,0.00,1526.67,0.00,'2022-11-26 10:26:24','',''),(168,'1','293',NULL,1,'Sale Id shift 20',2066509.20,0.00,0.00,0.00,0.00,'2022-11-26 10:26:24','',''),(169,'1','293',NULL,1,'Reception corrector for bridging 8',0.00,0.00,0.00,30000.00,0.00,'2022-11-26 10:37:28','',''),(170,'1','293','2',1,'Received from bridging 8',0.00,0.00,30000.00,0.00,0.00,'2022-11-26 10:37:28','',''),(171,'1','293',NULL,1,'Reception corrector for bridging 7',0.00,0.00,0.00,30000.00,0.00,'2022-11-26 10:37:28','',''),(172,'1','293','1',1,'Received from bridging 7',0.00,0.00,30000.00,0.00,0.00,'2022-11-26 10:37:28','',''),(173,'1','293','1',1,'Sale Id shift 21',0.00,0.00,0.00,1870.33,0.00,'2022-11-26 10:39:20','',''),(174,'1','293','2',1,'Sale Id shift 21',0.00,0.00,0.00,2704.50,0.00,'2022-11-26 10:39:20','',''),(175,'1','293','1',1,'Sale Id shift 21',0.00,0.00,0.00,2841.04,0.00,'2022-11-26 10:39:20','',''),(176,'1','293','1',1,'Sale Id shift 21',0.00,0.00,0.00,1064.30,0.00,'2022-11-26 10:39:20','',''),(177,'1','293','2',1,'Sale Id shift 21',0.00,0.00,0.00,2281.49,0.00,'2022-11-26 10:39:20','',''),(178,'1','293',NULL,1,'Sale Id shift 21',2259948.60,0.00,0.00,0.00,0.00,'2022-11-26 10:39:20','',''),(179,'1','293','1',1,'Sale Id shift 22',0.00,0.00,0.00,257.28,0.00,'2022-11-26 10:49:25','',''),(180,'1','293','2',1,'Sale Id shift 22',0.00,0.00,0.00,2661.70,0.00,'2022-11-26 10:49:25','',''),(181,'1','293','2',1,'Sale Id shift 22',0.00,0.00,0.00,1595.77,0.00,'2022-11-26 10:49:25','',''),(182,'1','293','1',1,'Sale Id shift 22',0.00,0.00,0.00,1612.75,0.00,'2022-11-26 10:49:25','',''),(183,'1','293','1',1,'Sale Id shift 22',0.00,0.00,0.00,1530.47,0.00,'2022-11-26 10:49:25','',''),(184,'1','293','1',1,'Sale Id shift 22',0.00,0.00,0.00,2010.08,0.00,'2022-11-26 10:49:25','',''),(185,'1','293',NULL,1,'Sale Id shift 22',2030290.50,0.00,0.00,0.00,0.00,'2022-11-26 10:49:25','',''),(186,'1','293','1',1,'Sale Id shift 23',0.00,0.00,0.00,2028.97,0.00,'2022-11-26 10:59:38','',''),(187,'1','293','2',1,'Sale Id shift 23',0.00,0.00,0.00,0.01,0.00,'2022-11-26 10:59:38','',''),(188,'1','293','2',1,'Sale Id shift 23',0.00,0.00,0.00,30.90,0.00,'2022-11-26 10:59:38','',''),(189,'1','293','2',1,'Sale Id shift 23',0.00,0.00,0.00,2019.01,0.00,'2022-11-26 10:59:38','',''),(190,'1','293','1',1,'Sale Id shift 23',0.00,0.00,0.00,2170.83,0.00,'2022-11-26 10:59:38','',''),(191,'1','293','1',1,'Sale Id shift 23',0.00,0.00,0.00,1741.80,0.00,'2022-11-26 10:59:38','',''),(192,'1','293','2',1,'Sale Id shift 23',0.00,0.00,0.00,1941.21,0.00,'2022-11-26 10:59:38','',''),(193,'1','293',NULL,1,'Sale Id shift 23',2085873.30,0.00,0.00,0.00,0.00,'2022-11-26 10:59:38','',''),(194,'1','293','2',1,'Sale Id shift 24',0.00,0.00,0.00,1788.21,0.00,'2022-11-26 11:05:25','',''),(195,'1','293','2',1,'Sale Id shift 24',0.00,0.00,0.00,1656.97,0.00,'2022-11-26 11:05:25','',''),(196,'1','293','1',1,'Sale Id shift 24',0.00,0.00,0.00,1243.81,0.00,'2022-11-26 11:05:25','',''),(197,'1','293','1',1,'Sale Id shift 24',0.00,0.00,0.00,1106.05,0.00,'2022-11-26 11:05:25','',''),(198,'1','293','1',1,'Sale Id shift 24',0.00,0.00,0.00,795.10,0.00,'2022-11-26 11:05:25','',''),(199,'1','293','1',1,'Sale Id shift 24',0.00,0.00,0.00,1306.02,0.00,'2022-11-26 11:05:25','',''),(200,'1','293',NULL,1,'Sale Id shift 24',1658193.60,0.00,0.00,0.00,0.00,'2022-11-26 11:05:25','',''),(201,'1','293','1',1,'Sale Id shift 25',0.00,0.00,0.00,2109.98,0.00,'2022-11-26 15:17:22','',''),(202,'1','293','2',1,'Sale Id shift 25',0.00,0.00,0.00,1969.25,0.00,'2022-11-26 15:17:22','',''),(203,'1','293','1',1,'Sale Id shift 25',0.00,0.00,0.00,1720.63,0.00,'2022-11-26 15:17:22','',''),(204,'1','293','1',1,'Sale Id shift 25',0.00,0.00,0.00,1689.95,0.00,'2022-11-26 15:17:22','',''),(205,'1','293','2',1,'Sale Id shift 25',0.00,0.00,0.00,2282.37,0.00,'2022-11-26 15:17:22','',''),(206,'1','293',NULL,1,'Sale Id shift 25',2052157.80,0.00,0.00,0.00,0.00,'2022-11-26 15:17:22','',''),(207,'1','293','2',1,'Sale Id shift 26',0.00,0.00,0.00,1932.56,0.00,'2022-11-27 09:19:37','',''),(208,'1','293','1',1,'Sale Id shift 26',0.00,0.00,0.00,1782.41,0.00,'2022-11-27 09:19:37','',''),(209,'1','293','1',1,'Sale Id shift 26',0.00,0.00,0.00,1923.10,0.00,'2022-11-27 09:19:37','',''),(210,'1','293','1',1,'Sale Id shift 26',0.00,0.00,0.00,1645.07,0.00,'2022-11-27 09:19:37','',''),(211,'1','293','2',1,'Sale Id shift 26',0.00,0.00,0.00,2306.40,0.00,'2022-11-27 09:19:37','',''),(212,'1','293',NULL,1,'Sale Id shift 26',2013803.40,0.00,0.00,0.00,0.00,'2022-11-27 09:19:37','',''),(213,'1','293',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,10500000.00,50000.00,0.00,0.00,'2022-11-27 14:10:12','',''),(214,'1','293','1',1,'Sale Id shift 27',0.00,0.00,0.00,1191.94,0.00,'2022-11-28 13:57:03','',''),(215,'1','293','2',1,'Sale Id shift 27',0.00,0.00,0.00,1538.87,0.00,'2022-11-28 13:57:03','',''),(216,'1','293','2',1,'Sale Id shift 27',0.00,0.00,0.00,1569.60,0.00,'2022-11-28 13:57:03','',''),(217,'1','293','1',1,'Sale Id shift 27',0.00,0.00,0.00,136.74,0.00,'2022-11-28 13:57:03','',''),(218,'1','293','1',1,'Sale Id shift 27',0.00,0.00,0.00,1786.57,0.00,'2022-11-28 13:57:03','',''),(219,'1','293','1',1,'Sale Id shift 27',0.00,0.00,0.00,188.11,0.00,'2022-11-28 13:57:03','',''),(220,'1','293','1',1,'Sale Id shift 27',0.00,0.00,0.00,1056.87,0.00,'2022-11-28 13:57:03','',''),(221,'1','293','2',1,'Sale Id shift 27',0.00,0.00,0.00,1290.40,0.00,'2022-11-28 13:57:03','',''),(222,'1','293',NULL,1,'Sale Id shift 27',1839411.00,0.00,0.00,0.00,0.00,'2022-11-28 13:57:03','',''),(223,'1','293','1',1,'Sale Id shift 28',0.00,0.00,0.00,1793.24,0.00,'2022-11-30 12:49:24','',''),(224,'1','293','2',1,'Sale Id shift 28',0.00,0.00,0.00,2296.76,0.00,'2022-11-30 12:49:24','',''),(225,'1','293','1',1,'Sale Id shift 28',0.00,0.00,0.00,68.91,0.00,'2022-11-30 12:49:24','',''),(226,'1','293','1',1,'Sale Id shift 28',0.00,0.00,0.00,1929.13,0.00,'2022-11-30 12:49:24','',''),(227,'1','293','1',1,'Sale Id shift 28',0.00,0.00,0.00,1612.60,0.00,'2022-11-30 12:49:24','',''),(228,'1','293','2',1,'Sale Id shift 28',0.00,0.00,0.00,1845.39,0.00,'2022-11-30 12:49:24','',''),(229,'1','293',NULL,1,'Sale Id shift 28',2004666.30,0.00,0.00,0.00,0.00,'2022-11-30 12:49:24','',''),(230,'1','293','2',1,'Sale Id shift 29',0.00,0.00,0.00,1859.06,0.00,'2022-11-30 13:06:55','',''),(231,'1','293','2',1,'Sale Id shift 29',0.00,0.00,0.00,1859.07,0.00,'2022-11-30 13:06:55','',''),(232,'1','293','1',1,'Sale Id shift 29',0.00,0.00,0.00,2748.18,0.00,'2022-11-30 13:06:55','',''),(233,'1','293','1',1,'Sale Id shift 29',0.00,0.00,0.00,6.74,0.00,'2022-11-30 13:06:55','',''),(234,'1','293','1',1,'Sale Id shift 29',0.00,0.00,0.00,1663.33,0.00,'2022-11-30 13:06:55','',''),(235,'1','293','1',1,'Sale Id shift 29',0.00,0.00,0.00,279.53,0.00,'2022-11-30 13:06:55','',''),(236,'1','293','1',1,'Sale Id shift 29',0.00,0.00,0.00,1680.92,0.00,'2022-11-30 13:06:55','',''),(237,'1','293','2',1,'Sale Id shift 29',0.00,0.00,0.00,2460.14,0.00,'2022-11-30 13:06:55','',''),(238,'1','293',NULL,1,'Sale Id shift 29',2636963.70,0.00,0.00,0.00,0.00,'2022-11-30 13:06:55','',''),(239,'1','293','1',1,'Sale Id shift 30',0.00,0.00,0.00,331.52,0.00,'2022-11-30 15:21:32','',''),(240,'1','293','2',1,'Sale Id shift 30',0.00,0.00,0.00,746.71,0.00,'2022-11-30 15:21:32','',''),(241,'1','293','2',1,'Sale Id shift 30',0.00,0.00,0.00,2767.63,0.00,'2022-11-30 15:21:32','',''),(242,'1','293','2',1,'Sale Id shift 30',0.00,0.00,0.00,808.56,0.00,'2022-11-30 15:21:32','',''),(243,'1','293','1',1,'Sale Id shift 30',0.00,0.00,0.00,1171.88,0.00,'2022-11-30 15:21:32','',''),(244,'1','293','1',1,'Sale Id shift 30',0.00,0.00,0.00,1299.51,0.00,'2022-11-30 15:21:32','',''),(245,'1','293','2',1,'Sale Id shift 30',0.00,0.00,0.00,2724.03,0.00,'2022-11-30 15:21:32','',''),(246,'1','293',NULL,1,'Sale Id shift 30',2068466.40,0.00,0.00,0.00,0.00,'2022-11-30 15:21:32','',''),(247,'1','293','2',1,'Sale Id shift 31',0.00,0.00,0.00,194.21,0.00,'2022-12-01 07:38:38','',''),(248,'1','293','2',1,'Sale Id shift 31',0.00,0.00,0.00,164.24,0.00,'2022-12-01 07:38:38','',''),(249,'1','293','2',1,'Sale Id shift 31',0.00,0.00,0.00,141.71,0.00,'2022-12-01 07:38:38','',''),(250,'1','293','1',1,'Sale Id shift 31',0.00,0.00,0.00,575.20,0.00,'2022-12-01 07:38:38','',''),(251,'1','293','2',1,'Sale Id shift 31',0.00,0.00,0.00,189.37,0.00,'2022-12-01 07:38:38','',''),(252,'1','293',NULL,1,'Sale Id shift 31',265593.30,0.00,0.00,0.00,0.00,'2022-12-01 07:38:38','',''),(253,'1','293','1',1,'Sale Id shift 32',0.00,0.00,0.00,2615.45,0.00,'2022-12-01 07:59:38','',''),(254,'1','293','2',1,'Sale Id shift 32',0.00,0.00,0.00,1624.19,0.00,'2022-12-01 07:59:38','',''),(255,'1','293','2',1,'Sale Id shift 32',0.00,0.00,0.00,2772.33,0.00,'2022-12-01 07:59:38','',''),(256,'1','293','1',1,'Sale Id shift 32',0.00,0.00,0.00,3519.85,0.00,'2022-12-01 07:59:38','',''),(257,'1','293','1',1,'Sale Id shift 32',0.00,0.00,0.00,1301.99,0.00,'2022-12-01 07:59:38','',''),(258,'1','293','1',1,'Sale Id shift 32',0.00,0.00,0.00,2468.77,0.00,'2022-12-01 07:59:38','',''),(259,'1','293','2',1,'Sale Id shift 32',0.00,0.00,0.00,1459.99,0.00,'2022-12-01 07:59:38','',''),(260,'1','293',NULL,1,'Sale Id shift 32',3310139.70,0.00,0.00,0.00,0.00,'2022-12-01 07:59:38','',''),(261,'1','293','2',1,'Sale Id shift 33',0.00,0.00,0.00,2805.32,0.00,'2022-12-01 08:10:53','',''),(262,'1','293','2',1,'Sale Id shift 33',0.00,0.00,0.00,2149.30,0.00,'2022-12-01 08:10:53','',''),(263,'1','293','1',1,'Sale Id shift 33',0.00,0.00,0.00,2000.25,0.00,'2022-12-01 08:10:53','',''),(264,'1','293','1',1,'Sale Id shift 33',0.00,0.00,0.00,2406.45,0.00,'2022-12-01 08:10:53','',''),(265,'1','293','1',1,'Sale Id shift 33',0.00,0.00,0.00,2378.92,0.00,'2022-12-01 08:10:53','',''),(266,'1','293',NULL,1,'Sale Id shift 33',2465450.40,0.00,0.00,0.00,0.00,'2022-12-01 08:10:53','',''),(267,'1','293','1',1,'Sale Id shift 34',0.00,0.00,0.00,2549.87,0.00,'2022-12-01 08:22:37','',''),(268,'1','293','2',1,'Sale Id shift 34',0.00,0.00,0.00,3060.68,0.00,'2022-12-01 08:22:37','',''),(269,'1','293','1',1,'Sale Id shift 34',0.00,0.00,0.00,818.90,0.00,'2022-12-01 08:22:37','',''),(270,'1','293','1',1,'Sale Id shift 34',0.00,0.00,0.00,2257.34,0.00,'2022-12-01 08:22:37','',''),(271,'1','293','1',1,'Sale Id shift 34',0.00,0.00,0.00,2559.26,0.00,'2022-12-01 08:22:37','',''),(272,'1','293','2',1,'Sale Id shift 34',0.00,0.00,0.00,2662.27,0.00,'2022-12-01 08:22:37','',''),(273,'1','293',NULL,1,'Sale Id shift 34',2920747.20,0.00,0.00,0.00,0.00,'2022-12-01 08:22:37','',''),(274,'1','293',NULL,1,'Reception corrector for bridging 9',0.00,0.00,0.00,45000.00,0.00,'2022-12-01 08:29:25','',''),(275,'1','293','1',1,'Received from bridging 9',0.00,0.00,45000.00,0.00,0.00,'2022-12-01 08:29:25','',''),(276,'1','293',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,45000.00,0.00,'2022-12-01 08:29:39','',''),(277,'1','293','2',1,'Received from bridging 10',0.00,0.00,45000.00,0.00,0.00,'2022-12-01 08:29:39','',''),(278,'1','293','2',1,'Sale Id shift 35',0.00,0.00,0.00,1654.02,0.00,'2022-12-01 08:34:51','',''),(279,'1','293','2',1,'Sale Id shift 35',0.00,0.00,0.00,940.34,0.00,'2022-12-01 08:34:51','',''),(280,'1','293','2',1,'Sale Id shift 35',0.00,0.00,0.00,1212.52,0.00,'2022-12-01 08:34:51','',''),(281,'1','293','1',1,'Sale Id shift 35',0.00,0.00,0.00,1571.97,0.00,'2022-12-01 08:34:51','',''),(282,'1','293','1',1,'Sale Id shift 35',0.00,0.00,0.00,1384.47,0.00,'2022-12-01 08:34:51','',''),(283,'1','293','1',1,'Sale Id shift 35',0.00,0.00,0.00,1823.65,0.00,'2022-12-01 08:34:51','',''),(284,'1','293',NULL,1,'Sale Id shift 35',1803263.70,0.00,0.00,0.00,0.00,'2022-12-01 08:34:51','',''),(285,'1','293','1',1,'Sale Id shift 36',0.00,0.00,0.00,1558.33,0.00,'2022-12-01 08:52:33','',''),(286,'1','293','1',1,'Sale Id shift 36',0.00,0.00,0.00,1702.72,0.00,'2022-12-01 08:52:33','',''),(287,'1','293','1',1,'Sale Id shift 36',0.00,0.00,0.00,1794.15,0.00,'2022-12-01 08:52:33','',''),(288,'1','293','1',1,'Sale Id shift 36',0.00,0.00,0.00,1499.90,0.00,'2022-12-01 08:52:33','',''),(289,'1','293','1',1,'Sale Id shift 36',0.00,0.00,0.00,2218.06,0.00,'2022-12-01 08:52:33','',''),(290,'1','293',NULL,1,'Sale Id shift 36',1842363.60,0.00,0.00,0.00,0.00,'2022-12-01 08:52:33','',''),(291,'1','293','2',1,'Sale Id shift 37',0.00,0.00,0.00,964.58,0.00,'2022-12-01 08:58:52','',''),(292,'1','293','2',1,'Sale Id shift 37',0.00,0.00,0.00,774.01,0.00,'2022-12-01 08:58:52','',''),(293,'1','293','1',1,'Sale Id shift 37',0.00,0.00,0.00,107.27,0.00,'2022-12-01 08:58:52','',''),(294,'1','293','1',1,'Sale Id shift 37',0.00,0.00,0.00,731.17,0.00,'2022-12-01 08:58:52','',''),(295,'1','293','1',1,'Sale Id shift 37',0.00,0.00,0.00,762.36,0.00,'2022-12-01 08:58:52','',''),(296,'1','293','1',1,'Sale Id shift 37',0.00,0.00,0.00,1007.59,0.00,'2022-12-01 08:58:52','',''),(297,'1','293',NULL,1,'Sale Id shift 37',912865.80,0.00,0.00,0.00,0.00,'2022-12-01 08:58:52','',''),(298,'1','293','2',1,'Sale Id shift 38',0.00,0.00,0.00,2732.51,0.00,'2022-12-01 09:05:16','',''),(299,'1','293','2',1,'Sale Id shift 38',0.00,0.00,0.00,3672.02,0.00,'2022-12-01 09:05:16','',''),(300,'1','293','2',1,'Sale Id shift 38',0.00,0.00,0.00,672.38,0.00,'2022-12-01 09:05:16','',''),(301,'1','293','1',1,'Sale Id shift 38',0.00,0.00,0.00,2866.16,0.00,'2022-12-01 09:05:16','',''),(302,'1','293','1',1,'Sale Id shift 38',0.00,0.00,0.00,4417.76,0.00,'2022-12-01 09:05:16','',''),(303,'1','293','1',1,'Sale Id shift 38',0.00,0.00,0.00,2934.52,0.00,'2022-12-01 09:05:16','',''),(304,'1','293','2',1,'Sale Id shift 38',0.00,0.00,0.00,3667.31,0.00,'2022-12-01 09:05:16','',''),(305,'1','293',NULL,1,'Sale Id shift 38',4402158.60,0.00,0.00,0.00,0.00,'2022-12-01 09:05:16','',''),(306,'1','293','1',1,'Sale Id shift 39',0.00,0.00,0.00,2870.75,0.00,'2022-12-01 09:12:05','',''),(307,'1','293','2',1,'Sale Id shift 39',0.00,0.00,0.00,1901.17,0.00,'2022-12-01 09:12:05','',''),(308,'1','293','1',1,'Sale Id shift 39',0.00,0.00,0.00,1455.82,0.00,'2022-12-01 09:12:05','',''),(309,'1','293','1',1,'Sale Id shift 39',0.00,0.00,0.00,3302.81,0.00,'2022-12-01 09:12:05','',''),(310,'1','293','1',1,'Sale Id shift 39',0.00,0.00,0.00,2193.06,0.00,'2022-12-01 09:12:05','',''),(311,'1','293','1',1,'Sale Id shift 39',0.00,0.00,0.00,2097.88,0.00,'2022-12-01 09:12:05','',''),(312,'1','293','2',1,'Sale Id shift 39',0.00,0.00,0.00,1906.62,0.00,'2022-12-01 09:12:05','',''),(313,'1','293',NULL,1,'Sale Id shift 39',3302903.10,0.00,0.00,0.00,0.00,'2022-12-01 09:12:05','',''),(314,'1','293',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3780000.00,18000.00,0.00,0.00,'2022-12-01 09:13:23','',''),(315,'1','293',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,10710000.00,51000.00,0.00,0.00,'2022-12-01 09:14:37','',''),(316,'1','293',NULL,1,'Reception corrector for bridging 11',0.00,0.00,0.00,50000.00,0.00,'2022-12-01 09:18:42','',''),(317,'1','293','1',1,'Received from bridging 11',0.00,0.00,50000.00,0.00,0.00,'2022-12-01 09:18:42','',''),(318,'1','293',NULL,1,'Reception corrector for bridging 12',0.00,0.00,0.00,51000.00,0.00,'2022-12-01 09:19:46','',''),(319,'1','293','2',1,'Received from bridging 12',0.00,0.00,51000.00,0.00,0.00,'2022-12-01 09:19:46','',''),(320,'1','293','2',1,'Sale Id shift 40',0.00,0.00,0.00,107.23,0.00,'2022-12-01 09:26:30','',''),(321,'1','293','2',1,'Sale Id shift 40',0.00,0.00,0.00,4165.60,0.00,'2022-12-01 09:26:30','',''),(322,'1','293','1',1,'Sale Id shift 40',0.00,0.00,0.00,4746.42,0.00,'2022-12-01 09:26:30','',''),(323,'1','293','1',1,'Sale Id shift 40',0.00,0.00,0.00,3867.43,0.00,'2022-12-01 09:26:30','',''),(324,'1','293','1',1,'Sale Id shift 40',0.00,0.00,0.00,3509.05,0.00,'2022-12-01 09:26:30','',''),(325,'1','293','2',1,'Sale Id shift 40',0.00,0.00,0.00,4055.51,0.00,'2022-12-01 09:26:30','',''),(326,'1','293',NULL,1,'Sale Id shift 40',4294760.40,0.00,0.00,0.00,0.00,'2022-12-01 09:26:30','',''),(327,'1','293','2',1,'Sale Id shift 41',0.00,0.00,0.00,4062.84,0.00,'2022-12-01 09:36:56','',''),(328,'1','293','1',1,'Sale Id shift 41',0.00,0.00,0.00,3888.32,0.00,'2022-12-01 09:36:56','',''),(329,'1','293','1',1,'Sale Id shift 41',0.00,0.00,0.00,3593.42,0.00,'2022-12-01 09:36:56','',''),(330,'1','293','1',1,'Sale Id shift 41',0.00,0.00,0.00,3724.00,0.00,'2022-12-01 09:36:56','',''),(331,'1','293','2',1,'Sale Id shift 41',0.00,0.00,0.00,4499.43,0.00,'2022-12-01 09:36:56','',''),(332,'1','293',NULL,1,'Sale Id shift 41',4151282.10,0.00,0.00,0.00,0.00,'2022-12-01 09:36:56','',''),(333,'1','293','2',1,'Sale Id shift 42',0.00,0.00,0.00,1172.77,0.00,'2022-12-01 09:43:11','',''),(334,'1','293','2',1,'Sale Id shift 42',0.00,0.00,0.00,4836.35,0.00,'2022-12-01 09:43:11','',''),(335,'1','293','1',1,'Sale Id shift 42',0.00,0.00,0.00,4978.34,0.00,'2022-12-01 09:43:11','',''),(336,'1','293','1',1,'Sale Id shift 42',0.00,0.00,0.00,3851.27,0.00,'2022-12-01 09:43:11','',''),(337,'1','293','1',1,'Sale Id shift 42',0.00,0.00,0.00,777.56,0.00,'2022-12-01 09:43:11','',''),(338,'1','293','1',1,'Sale Id shift 42',0.00,0.00,0.00,5271.31,0.00,'2022-12-01 09:43:11','',''),(339,'1','293','2',1,'Sale Id shift 42',0.00,0.00,0.00,4261.00,0.00,'2022-12-01 09:43:11','',''),(340,'1','293',NULL,1,'Sale Id shift 42',5281206.00,0.00,0.00,0.00,0.00,'2022-12-01 09:43:11','',''),(341,'1','293','2',1,'Sale Id shift 44',0.00,0.00,0.00,2022.22,0.00,'2022-12-01 10:01:13','',''),(342,'1','293','2',1,'Sale Id shift 44',0.00,0.00,0.00,2647.90,0.00,'2022-12-01 10:01:13','',''),(343,'1','293','1',1,'Sale Id shift 44',0.00,0.00,0.00,2575.11,0.00,'2022-12-01 10:01:13','',''),(344,'1','293','1',1,'Sale Id shift 44',0.00,0.00,0.00,2267.36,0.00,'2022-12-01 10:01:13','',''),(345,'1','293','1',1,'Sale Id shift 44',0.00,0.00,0.00,4295.61,0.00,'2022-12-01 10:01:13','',''),(346,'1','293',NULL,1,'Sale Id shift 44',2899722.00,0.00,0.00,0.00,0.00,'2022-12-01 10:01:13','',''),(347,'1','293',NULL,1,'Reception corrector for bridging 13',0.00,0.00,0.00,18000.00,0.00,'2022-12-01 10:17:44','',''),(348,'1','293','1',1,'Received from bridging 13',0.00,0.00,18000.00,0.00,0.00,'2022-12-01 10:17:44','',''),(349,'1','293','2',1,'Sale Id shift 45',0.00,0.00,0.00,4909.97,0.00,'2022-12-01 10:18:51','',''),(350,'1','293','2',1,'Sale Id shift 45',0.00,0.00,0.00,4398.32,0.00,'2022-12-01 10:18:51','',''),(351,'1','293','1',1,'Sale Id shift 45',0.00,0.00,0.00,2692.16,0.00,'2022-12-01 10:18:51','',''),(352,'1','293','1',1,'Sale Id shift 45',0.00,0.00,0.00,241.41,0.00,'2022-12-01 10:18:51','',''),(353,'1','293','1',1,'Sale Id shift 45',0.00,0.00,0.00,2900.06,0.00,'2022-12-01 10:18:51','',''),(354,'1','293','1',1,'Sale Id shift 45',0.00,0.00,0.00,2721.07,0.00,'2022-12-01 10:18:51','',''),(355,'1','293','2',1,'Sale Id shift 45',0.00,0.00,0.00,2348.31,0.00,'2022-12-01 10:18:51','',''),(356,'1','293',NULL,1,'Sale Id shift 45',4244373.00,0.00,0.00,0.00,0.00,'2022-12-01 10:18:51','',''),(357,'1','293','2',1,'Sale Id shift 46',0.00,0.00,0.00,10.00,0.00,'2022-12-01 10:25:57','',''),(358,'1','293','2',1,'Sale Id shift 46',0.00,0.00,0.00,3063.02,0.00,'2022-12-01 10:25:57','',''),(359,'1','293','1',1,'Sale Id shift 46',0.00,0.00,0.00,2547.28,0.00,'2022-12-01 10:25:57','',''),(360,'1','293','1',1,'Sale Id shift 46',0.00,0.00,0.00,2502.82,0.00,'2022-12-01 10:25:57','',''),(361,'1','293','1',1,'Sale Id shift 46',0.00,0.00,0.00,610.23,0.00,'2022-12-01 10:25:57','',''),(362,'1','293','1',1,'Sale Id shift 46',0.00,0.00,0.00,3101.53,0.00,'2022-12-01 10:25:57','',''),(363,'1','293','2',1,'Sale Id shift 46',0.00,0.00,0.00,3983.42,0.00,'2022-12-01 10:25:57','',''),(364,'1','293',NULL,1,'Sale Id shift 46',3321843.00,0.00,0.00,0.00,0.00,'2022-12-01 10:25:57','',''),(365,'1','293','2',1,'Sale Id shift 47',0.00,0.00,0.00,1603.66,0.00,'2022-12-01 10:30:06','',''),(366,'1','293','2',1,'Sale Id shift 47',0.00,0.00,0.00,2776.38,0.00,'2022-12-01 10:30:06','',''),(367,'1','293','1',1,'Sale Id shift 47',0.00,0.00,0.00,1985.41,0.00,'2022-12-01 10:30:06','',''),(368,'1','293','1',1,'Sale Id shift 47',0.00,0.00,0.00,2398.86,0.00,'2022-12-01 10:30:06','',''),(369,'1','293','1',1,'Sale Id shift 47',0.00,0.00,0.00,1630.52,0.00,'2022-12-01 10:30:06','',''),(370,'1','293','2',1,'Sale Id shift 47',0.00,0.00,0.00,2267.51,0.00,'2022-12-01 10:30:06','',''),(371,'1','293',NULL,1,'Sale Id shift 47',2659091.40,0.00,0.00,0.00,0.00,'2022-12-01 10:30:06','',''),(372,'1','293','2',1,'Sale Id shift 48',0.00,0.00,0.00,2815.25,0.00,'2022-12-01 10:35:24','',''),(373,'1','293','2',1,'Sale Id shift 48',0.00,0.00,0.00,1086.06,0.00,'2022-12-01 10:35:24','',''),(374,'1','293','2',1,'Sale Id shift 48',0.00,0.00,0.00,3363.31,0.00,'2022-12-01 10:35:24','',''),(375,'1','293','1',1,'Sale Id shift 48',0.00,0.00,0.00,2267.10,0.00,'2022-12-01 10:35:24','',''),(376,'1','293','1',1,'Sale Id shift 48',0.00,0.00,0.00,2089.47,0.00,'2022-12-01 10:35:24','',''),(377,'1','293','1',1,'Sale Id shift 48',0.00,0.00,0.00,1584.65,0.00,'2022-12-01 10:35:24','',''),(378,'1','293','1',1,'Sale Id shift 48',0.00,0.00,0.00,1880.69,0.00,'2022-12-01 10:35:24','',''),(379,'1','293','2',1,'Sale Id shift 48',0.00,0.00,0.00,2421.72,0.00,'2022-12-01 10:35:24','',''),(380,'1','293',NULL,1,'Sale Id shift 48',3676732.50,0.00,0.00,0.00,0.00,'2022-12-01 10:35:24','',''),(381,'1','293','2',1,'Sale Id shift 49',0.00,0.00,0.00,3750.01,0.00,'2022-12-01 10:38:40','',''),(382,'1','293','2',1,'Sale Id shift 49',0.00,0.00,0.00,3779.30,0.00,'2022-12-01 10:38:40','',''),(383,'1','293','2',1,'Sale Id shift 49',0.00,0.00,0.00,3279.03,0.00,'2022-12-01 10:38:40','',''),(384,'1','293','2',1,'Sale Id shift 49',0.00,0.00,0.00,3154.28,0.00,'2022-12-01 10:38:40','',''),(385,'1','293',NULL,1,'Sale Id shift 49',2932150.20,0.00,0.00,0.00,0.00,'2022-12-01 10:38:40','',''),(386,'1','293',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,10350000.00,45000.00,0.00,0.00,'2022-12-15 21:20:00','',''),(387,'1','293','2',1,'Sale Id shift 50',0.00,0.00,0.00,7065.90,0.00,'2022-12-15 21:49:27','',''),(388,'1','293','2',1,'Sale Id shift 50',0.00,0.00,0.00,2583.12,0.00,'2022-12-15 21:49:27','',''),(389,'1','293',NULL,1,'Sale Id shift 50',2026294.20,0.00,0.00,0.00,0.00,'2022-12-15 21:49:27','',''),(390,'1','293','2',1,'Sale Id shift 52',0.00,0.00,0.00,1026.30,0.00,'2022-12-17 00:18:38','',''),(391,'1','293',NULL,1,'Sale Id shift 52',236049.00,0.00,0.00,0.00,0.00,'2022-12-17 00:18:38','',''),(392,'1','293',NULL,1,'Reception corrector for bridging 15',0.00,0.00,0.00,12000.00,0.00,'2022-12-17 11:42:45','',''),(393,'1','293','2',1,'Received from bridging 15',0.00,0.00,12000.00,0.00,0.00,'2022-12-17 11:42:45','',''),(394,'1','293',NULL,1,'Reception corrector for bridging 14',0.00,0.00,0.00,33000.00,0.00,'2022-12-17 11:42:45','',''),(395,'1','293','1',1,'Received from bridging 14',0.00,0.00,33000.00,0.00,0.00,'2022-12-17 11:42:45','',''),(396,'1','293','2',1,'Sale Id shift 53',0.00,0.00,0.00,1667.32,0.00,'2022-12-17 14:58:29','',''),(397,'1','293','2',1,'Sale Id shift 53',0.00,0.00,0.00,2030.90,0.00,'2022-12-17 14:58:29','',''),(398,'1','293','1',1,'Sale Id shift 53',0.00,0.00,0.00,1815.86,0.00,'2022-12-17 14:58:29','',''),(399,'1','293','1',1,'Sale Id shift 53',0.00,0.00,0.00,2066.90,0.00,'2022-12-17 14:58:29','',''),(400,'1','293','1',1,'Sale Id shift 53',0.00,0.00,0.00,2223.27,0.00,'2022-12-17 14:58:29','',''),(401,'1','293','2',1,'Sale Id shift 53',0.00,0.00,0.00,1853.55,0.00,'2022-12-17 14:58:29','',''),(402,'1','293',NULL,1,'Sale Id shift 53',2681294.00,0.00,0.00,0.00,0.00,'2022-12-17 14:58:29','',''),(403,'1','293','1',1,'Sale Id shift 54',0.00,0.00,0.00,1711.91,0.00,'2022-12-17 15:34:33','',''),(404,'1','293','2',1,'Sale Id shift 54',0.00,0.00,0.00,1607.40,0.00,'2022-12-17 15:34:33','',''),(405,'1','293','2',1,'Sale Id shift 54',0.00,0.00,0.00,1887.95,0.00,'2022-12-17 15:34:33','',''),(406,'1','293','1',1,'Sale Id shift 54',0.00,0.00,0.00,1660.82,0.00,'2022-12-17 15:34:33','',''),(407,'1','293','1',1,'Sale Id shift 54',0.00,0.00,0.00,2247.26,0.00,'2022-12-17 15:34:33','',''),(408,'1','293','1',1,'Sale Id shift 54',0.00,0.00,0.00,1589.43,0.00,'2022-12-17 15:34:33','',''),(409,'1','293','1',1,'Sale Id shift 54',0.00,0.00,0.00,1980.16,0.00,'2022-12-17 15:34:33','',''),(410,'1','293','1',1,'Sale Id shift 54',0.00,0.00,0.00,2231.60,0.00,'2022-12-17 15:34:33','',''),(411,'1','293',NULL,1,'Sale Id shift 54',3430801.90,0.00,0.00,0.00,0.00,'2022-12-17 15:34:33','',''),(412,'1','293','1',1,'Sale Id shift 55',0.00,0.00,0.00,2800.53,0.00,'2022-12-17 15:40:26','',''),(413,'1','293','1',1,'Sale Id shift 55',0.00,0.00,0.00,2364.83,0.00,'2022-12-17 15:40:26','',''),(414,'1','293','1',1,'Sale Id shift 55',0.00,0.00,0.00,1752.50,0.00,'2022-12-17 15:40:26','',''),(415,'1','293','1',1,'Sale Id shift 55',0.00,0.00,0.00,2163.99,0.00,'2022-12-17 15:40:26','',''),(416,'1','293','1',1,'Sale Id shift 55',0.00,0.00,0.00,2321.30,0.00,'2022-12-17 15:40:26','',''),(417,'1','293','1',1,'Sale Id shift 55',0.00,0.00,0.00,2893.16,0.00,'2022-12-17 15:40:26','',''),(418,'1','293',NULL,1,'Sale Id shift 55',3288151.30,0.00,0.00,0.00,0.00,'2022-12-17 15:40:26','',''),(419,'1','293','2',1,'Sale Id shift 56',0.00,0.00,0.00,1631.14,0.00,'2022-12-18 21:05:39','',''),(420,'1','293','2',1,'Sale Id shift 56',0.00,0.00,0.00,1165.25,0.00,'2022-12-18 21:05:39','',''),(421,'1','293','2',1,'Sale Id shift 56',0.00,0.00,0.00,1805.42,0.00,'2022-12-18 21:05:39','',''),(422,'1','293','2',1,'Sale Id shift 56',0.00,0.00,0.00,1472.88,0.00,'2022-12-18 21:05:39','',''),(423,'1','293',NULL,1,'Sale Id shift 56',1397178.70,0.00,0.00,0.00,0.00,'2022-12-18 21:05:39','',''),(424,'1','293',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,4140000.00,18000.00,0.00,0.00,'2022-12-20 05:28:40','',''),(425,'1','293',NULL,1,'Reception corrector for bridging 16',0.00,0.00,0.00,18000.00,0.00,'2022-12-20 11:19:20','',''),(426,'1','293','2',1,'Received from bridging 16',0.00,0.00,18000.00,0.00,0.00,'2022-12-20 11:19:20','',''),(427,'1','293','2',1,'Sale Id shift 57',0.00,0.00,0.00,2223.21,0.00,'2022-12-21 07:56:24','',''),(428,'1','293','2',1,'Sale Id shift 57',0.00,0.00,0.00,2731.56,0.00,'2022-12-21 07:56:24','',''),(429,'1','293','2',1,'Sale Id shift 57',0.00,0.00,0.00,3349.93,0.00,'2022-12-21 07:56:24','',''),(430,'1','293','2',1,'Sale Id shift 57',0.00,0.00,0.00,3979.83,0.00,'2022-12-21 07:56:24','',''),(431,'1','293',NULL,1,'Sale Id shift 57',2825441.90,0.00,0.00,0.00,0.00,'2022-12-21 07:56:24','',''),(432,'1','293',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,10350000.00,45000.00,0.00,0.00,'2022-12-23 13:08:14','',''),(433,'1','293',NULL,1,'Reception corrector for bridging 18',0.00,0.00,0.00,22000.00,0.00,'2022-12-23 18:40:17','',''),(434,'1','293','2',1,'Received from bridging 18',0.00,0.00,22000.00,0.00,0.00,'2022-12-23 18:40:17','',''),(435,'1','293',NULL,1,'Reception corrector for bridging 17',0.00,0.00,0.00,23000.00,0.00,'2022-12-23 18:40:17','',''),(436,'1','293','1',1,'Received from bridging 17',0.00,0.00,23000.00,0.00,0.00,'2022-12-23 18:40:17','',''),(437,'1','293','1',1,'Sale Id shift 58',0.00,0.00,0.00,2033.17,0.00,'2022-12-24 06:56:37','',''),(438,'1','293','2',1,'Sale Id shift 58',0.00,0.00,0.00,3013.81,0.00,'2022-12-24 06:56:37','',''),(439,'1','293','1',1,'Sale Id shift 58',0.00,0.00,0.00,2054.26,0.00,'2022-12-24 06:56:37','',''),(440,'1','293','1',1,'Sale Id shift 58',0.00,0.00,0.00,2360.58,0.00,'2022-12-24 06:56:37','',''),(441,'1','293','1',1,'Sale Id shift 58',0.00,0.00,0.00,1636.43,0.00,'2022-12-24 06:56:37','',''),(442,'1','293','1',1,'Sale Id shift 58',0.00,0.00,0.00,2222.87,0.00,'2022-12-24 06:56:37','',''),(443,'1','293','1',1,'Sale Id shift 58',0.00,0.00,0.00,2874.17,0.00,'2022-12-24 06:56:37','',''),(444,'1','293',NULL,1,'Sale Id shift 58',3724916.70,0.00,0.00,0.00,0.00,'2022-12-24 06:56:37','',''),(445,'1','293','1',1,'Sale Id shift 59',0.00,0.00,0.00,1405.92,0.00,'2022-12-24 23:11:25','',''),(446,'1','293','1',1,'Sale Id shift 59',0.00,0.00,0.00,1329.76,0.00,'2022-12-24 23:11:25','',''),(447,'1','293','1',1,'Sale Id shift 59',0.00,0.00,0.00,1520.91,0.00,'2022-12-24 23:11:25','',''),(448,'1','293','1',1,'Sale Id shift 59',0.00,0.00,0.00,1385.24,0.00,'2022-12-24 23:11:25','',''),(449,'1','293','1',1,'Sale Id shift 59',0.00,0.00,0.00,2046.80,0.00,'2022-12-24 23:11:25','',''),(450,'1','293','1',1,'Sale Id shift 59',0.00,0.00,0.00,1639.49,0.00,'2022-12-24 23:11:25','',''),(451,'1','293',NULL,1,'Sale Id shift 59',2238748.80,0.00,0.00,0.00,0.00,'2022-12-24 23:11:25','',''),(452,'1','293','2',1,'Sale Id shift 60',0.00,0.00,0.00,2866.78,0.00,'2022-12-25 22:10:44','',''),(453,'1','293','2',1,'Sale Id shift 60',0.00,0.00,0.00,4995.58,0.00,'2022-12-25 22:10:44','',''),(454,'1','293',NULL,1,'Sale Id shift 60',1886966.40,0.00,0.00,0.00,0.00,'2022-12-25 22:10:45','',''),(455,'1','293','2',1,'Sale Id shift 61',0.00,0.00,0.00,3822.83,0.00,'2022-12-31 06:59:30','',''),(456,'1','293',NULL,1,'Sale Id shift 61',917479.20,0.00,0.00,0.00,0.00,'2022-12-31 06:59:30','',''),(457,'1','293','2',1,'Sale Id shift 62',0.00,0.00,0.00,2912.37,0.00,'2023-01-05 05:08:26','',''),(458,'1','293','2',1,'Sale Id shift 62',0.00,0.00,0.00,7262.23,0.00,'2023-01-05 05:08:26','',''),(459,'1','293',NULL,1,'Sale Id shift 62',2441904.00,0.00,0.00,0.00,0.00,'2023-01-05 05:08:26','',''),(460,'1','293',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,5280000.00,22000.00,0.00,0.00,'2023-01-08 17:07:32','',''),(461,'1','293',NULL,1,'Reception corrector for bridging 19',0.00,0.00,0.00,22000.00,0.00,'2023-01-08 17:14:21','',''),(462,'1','293','2',1,'Received from bridging 19',0.00,0.00,22000.00,0.00,0.00,'2023-01-08 17:14:21','',''),(463,'1','293','2',1,'Sale Id shift 64',0.00,0.00,0.00,507.05,0.00,'2023-01-08 17:27:03','',''),(464,'1','293','2',1,'Sale Id shift 64',0.00,0.00,0.00,1228.13,0.00,'2023-01-08 17:27:03','',''),(465,'1','293','2',1,'Sale Id shift 64',0.00,0.00,0.00,790.53,0.00,'2023-01-08 17:27:03','',''),(466,'1','293','2',1,'Sale Id shift 64',0.00,0.00,0.00,666.87,0.00,'2023-01-08 17:27:03','',''),(467,'1','293',NULL,1,'Sale Id shift 64',766219.20,0.00,0.00,0.00,0.00,'2023-01-08 17:27:03','',''),(468,'1','293','2',1,'Sale Id shift 65',0.00,0.00,0.00,631.27,0.00,'2023-01-10 15:03:14','',''),(469,'1','293','2',1,'Sale Id shift 65',0.00,0.00,0.00,972.31,0.00,'2023-01-10 15:03:14','',''),(470,'1','293','2',1,'Sale Id shift 65',0.00,0.00,0.00,708.67,0.00,'2023-01-10 15:03:14','',''),(471,'1','293','2',1,'Sale Id shift 65',0.00,0.00,0.00,996.34,0.00,'2023-01-10 15:03:14','',''),(472,'1','293',NULL,1,'Sale Id shift 65',794061.60,0.00,0.00,0.00,0.00,'2023-01-10 15:03:14','',''),(473,'1','293','2',1,'Sale Id shift 66',0.00,0.00,0.00,1511.81,0.00,'2023-01-11 07:00:30','',''),(474,'1','293','2',1,'Sale Id shift 66',0.00,0.00,0.00,1701.86,0.00,'2023-01-11 07:00:30','',''),(475,'1','293','2',1,'Sale Id shift 66',0.00,0.00,0.00,1245.90,0.00,'2023-01-11 07:00:30','',''),(476,'1','293','2',1,'Sale Id shift 66',0.00,0.00,0.00,1799.24,0.00,'2023-01-11 07:00:30','',''),(477,'1','293',NULL,1,'Sale Id shift 66',1502114.40,0.00,0.00,0.00,0.00,'2023-01-11 07:00:30','',''),(478,'1','293',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,5280000.00,22000.00,0.00,0.00,'2023-01-11 10:40:08','',''),(479,'1','293','2',1,'Sale Id shift 67',0.00,0.00,0.00,568.12,0.00,'2023-01-11 14:34:42','',''),(480,'1','293','2',1,'Sale Id shift 67',0.00,0.00,0.00,500.97,0.00,'2023-01-11 14:34:42','',''),(481,'1','293','2',1,'Sale Id shift 67',0.00,0.00,0.00,557.40,0.00,'2023-01-11 14:34:42','',''),(482,'1','293','2',1,'Sale Id shift 67',0.00,0.00,0.00,794.71,0.00,'2023-01-11 14:34:42','',''),(483,'1','293',NULL,1,'Sale Id shift 67',581088.00,0.00,0.00,0.00,0.00,'2023-01-11 14:34:42','',''),(484,'1','293','2',1,'Sale Id shift 68',0.00,0.00,0.00,1852.65,0.00,'2023-01-12 07:01:20','',''),(485,'1','293','2',1,'Sale Id shift 68',0.00,0.00,0.00,1681.06,0.00,'2023-01-12 07:01:20','',''),(486,'1','293','2',1,'Sale Id shift 68',0.00,0.00,0.00,2071.12,0.00,'2023-01-12 07:01:20','',''),(487,'1','293','2',1,'Sale Id shift 68',0.00,0.00,0.00,1418.88,0.00,'2023-01-12 07:01:20','',''),(488,'1','293',NULL,1,'Sale Id shift 68',1685690.40,0.00,0.00,0.00,0.00,'2023-01-12 07:01:20','',''),(489,'1','293',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,10800000.00,45000.00,0.00,0.00,'2023-01-13 14:58:43','',''),(490,'1','293',NULL,1,'Reception corrector for bridging 20',0.00,0.00,0.00,22000.00,0.00,'2023-01-13 15:49:58','',''),(491,'1','293','1',1,'Received from bridging 20',0.00,0.00,22000.00,0.00,0.00,'2023-01-13 15:49:58','',''),(492,'1','293',NULL,1,'Reception corrector for bridging 22',0.00,0.00,0.00,30000.00,0.00,'2023-01-13 15:50:32','',''),(493,'1','293','2',1,'Received from bridging 22',0.00,0.00,30000.00,0.00,0.00,'2023-01-13 15:50:32','',''),(494,'1','293',NULL,1,'Reception corrector for bridging 21',0.00,0.00,0.00,15000.00,0.00,'2023-01-13 15:51:15','',''),(495,'1','293','1',1,'Received from bridging 21',0.00,0.00,15000.00,0.00,0.00,'2023-01-13 15:51:15','',''),(496,'1','293','1',1,'Sale Id shift 69',0.00,0.00,0.00,2133.71,0.00,'2023-01-13 23:59:13','',''),(497,'1','293','1',1,'Sale Id shift 69',0.00,0.00,0.00,2838.26,0.00,'2023-01-13 23:59:13','',''),(498,'1','293','1',1,'Sale Id shift 69',0.00,0.00,0.00,1658.00,0.00,'2023-01-13 23:59:13','',''),(499,'1','293','1',1,'Sale Id shift 69',0.00,0.00,0.00,2269.24,0.00,'2023-01-13 23:59:13','',''),(500,'1','293','1',1,'Sale Id shift 69',0.00,0.00,0.00,2995.46,0.00,'2023-01-13 23:59:13','',''),(501,'1','293','1',1,'Sale Id shift 69',0.00,0.00,0.00,1963.92,0.00,'2023-01-13 23:59:13','',''),(502,'1','293',NULL,1,'Sale Id shift 69',3326061.60,0.00,0.00,0.00,0.00,'2023-01-13 23:59:13','',''),(503,'1','293','1',1,'Sale Id shift 70',0.00,0.00,0.00,56.76,0.00,'2023-01-14 14:59:56','',''),(504,'1','293','2',1,'Sale Id shift 70',0.00,0.00,0.00,1382.50,0.00,'2023-01-14 14:59:56','',''),(505,'1','293','2',1,'Sale Id shift 70',0.00,0.00,0.00,1863.72,0.00,'2023-01-14 14:59:56','',''),(506,'1','293','2',1,'Sale Id shift 70',0.00,0.00,0.00,2493.79,0.00,'2023-01-14 14:59:56','',''),(507,'1','293','1',1,'Sale Id shift 70',0.00,0.00,0.00,37.60,0.00,'2023-01-14 14:59:56','',''),(508,'1','293','1',1,'Sale Id shift 70',0.00,0.00,0.00,83.64,0.00,'2023-01-14 14:59:56','',''),(509,'1','293','1',1,'Sale Id shift 70',0.00,0.00,0.00,49.01,0.00,'2023-01-14 14:59:56','',''),(510,'1','293','1',1,'Sale Id shift 70',0.00,0.00,0.00,95.57,0.00,'2023-01-14 14:59:56','',''),(511,'1','293','2',1,'Sale Id shift 70',0.00,0.00,0.00,1684.65,0.00,'2023-01-14 14:59:56','',''),(512,'1','293',NULL,1,'Sale Id shift 70',1859337.60,0.00,0.00,0.00,0.00,'2023-01-14 14:59:56','',''),(513,'1','293','2',1,'Sale Id shift 71',0.00,0.00,0.00,514.28,0.00,'2023-01-15 21:37:07','',''),(514,'1','293','2',1,'Sale Id shift 71',0.00,0.00,0.00,554.16,0.00,'2023-01-15 21:37:07','',''),(515,'1','293','2',1,'Sale Id shift 71',0.00,0.00,0.00,290.15,0.00,'2023-01-15 21:37:07','',''),(516,'1','293','2',1,'Sale Id shift 71',0.00,0.00,0.00,411.61,0.00,'2023-01-15 21:37:07','',''),(517,'1','293',NULL,1,'Sale Id shift 71',424848.00,0.00,0.00,0.00,0.00,'2023-01-15 21:37:07','',''),(518,'1','293','1',1,'Sale Id shift 72',0.00,0.00,0.00,509.76,0.00,'2023-01-16 13:47:06','',''),(519,'1','293','2',1,'Sale Id shift 72',0.00,0.00,0.00,2914.35,0.00,'2023-01-16 13:47:06','',''),(520,'1','293','2',1,'Sale Id shift 72',0.00,0.00,0.00,2500.00,0.00,'2023-01-16 13:47:06','',''),(521,'1','293','2',1,'Sale Id shift 72',0.00,0.00,0.00,3557.76,0.00,'2023-01-16 13:47:06','',''),(522,'1','293','1',1,'Sale Id shift 72',0.00,0.00,0.00,866.67,0.00,'2023-01-16 13:47:06','',''),(523,'1','293','1',1,'Sale Id shift 72',0.00,0.00,0.00,400.35,0.00,'2023-01-16 13:47:06','',''),(524,'1','293','1',1,'Sale Id shift 72',0.00,0.00,0.00,701.58,0.00,'2023-01-16 13:47:06','',''),(525,'1','293','1',1,'Sale Id shift 72',0.00,0.00,0.00,663.41,0.00,'2023-01-16 13:47:06','',''),(526,'1','293','2',1,'Sale Id shift 72',0.00,0.00,0.00,2923.08,0.00,'2023-01-16 13:47:06','',''),(527,'1','293',NULL,1,'Sale Id shift 72',3608870.40,0.00,0.00,0.00,0.00,'2023-01-16 13:47:06','',''),(528,'1','293','2',1,'Sale Id shift 73',0.00,0.00,0.00,1992.48,0.00,'2023-01-17 06:17:31','',''),(529,'1','293','2',1,'Sale Id shift 73',0.00,0.00,0.00,2831.64,0.00,'2023-01-17 06:17:31','',''),(530,'1','293','2',1,'Sale Id shift 73',0.00,0.00,0.00,3392.09,0.00,'2023-01-17 06:17:31','',''),(531,'1','293','1',1,'Sale Id shift 73',0.00,0.00,0.00,1188.07,0.00,'2023-01-17 06:17:31','',''),(532,'1','293',NULL,1,'Sale Id shift 73',2257027.20,0.00,0.00,0.00,0.00,'2023-01-17 06:17:31','',''),(533,'1','293','1',1,'Sale Id shift 74',0.00,0.00,0.00,779.13,0.00,'2023-01-17 10:49:59','',''),(534,'1','293','2',1,'Sale Id shift 74',0.00,0.00,0.00,133.55,0.00,'2023-01-17 10:49:59','',''),(535,'1','293','2',1,'Sale Id shift 74',0.00,0.00,0.00,194.50,0.00,'2023-01-17 10:49:59','',''),(536,'1','293','2',1,'Sale Id shift 74',0.00,0.00,0.00,186.92,0.00,'2023-01-17 10:49:59','',''),(537,'1','293','1',1,'Sale Id shift 74',0.00,0.00,0.00,952.07,0.00,'2023-01-17 10:49:59','',''),(538,'1','293','1',1,'Sale Id shift 74',0.00,0.00,0.00,486.76,0.00,'2023-01-17 10:49:59','',''),(539,'1','293','1',1,'Sale Id shift 74',0.00,0.00,0.00,584.44,0.00,'2023-01-17 10:49:59','',''),(540,'1','293','1',1,'Sale Id shift 74',0.00,0.00,0.00,1104.82,0.00,'2023-01-17 10:49:59','',''),(541,'1','293','1',1,'Sale Id shift 74',0.00,0.00,0.00,1196.41,0.00,'2023-01-17 10:49:59','',''),(542,'1','293','2',1,'Sale Id shift 74',0.00,0.00,0.00,315.43,0.00,'2023-01-17 10:49:59','',''),(543,'1','293',NULL,1,'Sale Id shift 74',1424167.20,0.00,0.00,0.00,0.00,'2023-01-17 10:49:59','',''),(544,'1','293','1',1,'Sale Id shift 75',0.00,0.00,0.00,765.64,0.00,'2023-01-17 17:18:49','',''),(545,'1','293','1',1,'Sale Id shift 75',0.00,0.00,0.00,1397.18,0.00,'2023-01-17 17:18:49','',''),(546,'1','293',NULL,1,'Sale Id shift 75',519076.80,0.00,0.00,0.00,0.00,'2023-01-17 17:18:49','',''),(547,'1','293',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,5520000.00,23000.00,0.00,0.00,'2023-01-18 09:56:43','',''),(548,'1','293',NULL,1,'Reception corrector for bridging 23',0.00,0.00,0.00,23000.00,0.00,'2023-01-19 16:04:50','',''),(549,'1','293','2',1,'Received from bridging 23',0.00,0.00,23000.00,0.00,0.00,'2023-01-19 16:04:50','',''),(550,'1','293',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,10560000.00,44000.00,0.00,0.00,'2023-01-21 06:14:09','',''),(551,'1','293','1',1,'Sale Id shift 77',0.00,0.00,0.00,1266.35,0.00,'2023-01-21 22:01:35','',''),(552,'1','293','2',1,'Sale Id shift 77',0.00,0.00,0.00,127.61,0.00,'2023-01-21 22:01:35','',''),(553,'1','293','2',1,'Sale Id shift 77',0.00,0.00,0.00,113.77,0.00,'2023-01-21 22:01:35','',''),(554,'1','293','2',1,'Sale Id shift 77',0.00,0.00,0.00,108.98,0.00,'2023-01-21 22:01:35','',''),(555,'1','293','1',1,'Sale Id shift 77',0.00,0.00,0.00,1345.99,0.00,'2023-01-21 22:01:35','',''),(556,'1','293','1',1,'Sale Id shift 77',0.00,0.00,0.00,1146.25,0.00,'2023-01-21 22:01:35','',''),(557,'1','293','1',1,'Sale Id shift 77',0.00,0.00,0.00,1072.06,0.00,'2023-01-21 22:01:35','',''),(558,'1','293','1',1,'Sale Id shift 77',0.00,0.00,0.00,1374.48,0.00,'2023-01-21 22:01:35','',''),(559,'1','293','1',1,'Sale Id shift 77',0.00,0.00,0.00,1783.41,0.00,'2023-01-21 22:01:35','',''),(560,'1','293','2',1,'Sale Id shift 77',0.00,0.00,0.00,94.89,0.00,'2023-01-21 22:01:35','',''),(561,'1','293',NULL,1,'Sale Id shift 77',2024109.60,0.00,0.00,0.00,0.00,'2023-01-21 22:01:35','',''),(562,'1','293','2',1,'Sale Id shift 78',0.00,0.00,0.00,942.53,0.00,'2023-01-23 16:55:23','',''),(563,'1','293','2',1,'Sale Id shift 78',0.00,0.00,0.00,1390.73,0.00,'2023-01-23 16:55:23','',''),(564,'1','293','2',1,'Sale Id shift 78',0.00,0.00,0.00,1077.54,0.00,'2023-01-23 16:55:23','',''),(565,'1','293','1',1,'Sale Id shift 78',0.00,0.00,0.00,1206.15,0.00,'2023-01-23 16:55:23','',''),(566,'1','293','1',1,'Sale Id shift 78',0.00,0.00,0.00,759.56,0.00,'2023-01-23 16:55:23','',''),(567,'1','293','1',1,'Sale Id shift 78',0.00,0.00,0.00,1112.28,0.00,'2023-01-23 16:55:23','',''),(568,'1','293',NULL,1,'Sale Id shift 78',1557309.60,0.00,0.00,0.00,0.00,'2023-01-23 16:55:23','',''),(569,'1','293',NULL,1,'Returned purchase #20 to AA RANO NIGERIA LTD',10560000.00,0.00,0.00,44000.00,0.00,'2023-01-24 12:22:59','',''),(570,'1','293',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9600000.00,40000.00,0.00,0.00,'2023-01-24 12:23:14','',''),(571,'1','293',NULL,1,'Reception corrector for bridging 25',0.00,0.00,0.00,13500.00,0.00,'2023-01-24 12:24:46','',''),(572,'1','293','2',1,'Received from bridging 25',0.00,0.00,13500.00,0.00,0.00,'2023-01-24 12:24:46','',''),(573,'1','293',NULL,1,'Reception corrector for bridging 24',0.00,0.00,0.00,26500.00,0.00,'2023-01-24 12:24:46','',''),(574,'1','293','1',1,'Received from bridging 24',0.00,0.00,26500.00,0.00,0.00,'2023-01-24 12:24:46','',''),(575,'1','293','1',1,'Sale Id shift 79',0.00,0.00,0.00,993.97,0.00,'2023-01-24 12:52:59','',''),(576,'1','293','2',1,'Sale Id shift 79',0.00,0.00,0.00,460.70,0.00,'2023-01-24 12:52:59','',''),(577,'1','293','2',1,'Sale Id shift 79',0.00,0.00,0.00,1055.99,0.00,'2023-01-24 12:52:59','',''),(578,'1','293','1',1,'Sale Id shift 79',0.00,0.00,0.00,915.47,0.00,'2023-01-24 12:52:59','',''),(579,'1','293','1',1,'Sale Id shift 79',0.00,0.00,0.00,1134.91,0.00,'2023-01-24 12:52:59','',''),(580,'1','293','2',1,'Sale Id shift 79',0.00,0.00,0.00,782.06,0.00,'2023-01-24 12:52:59','',''),(581,'1','293',NULL,1,'Sale Id shift 79',1282344.00,0.00,0.00,0.00,0.00,'2023-01-24 12:52:59','',''),(582,'1','293','2',1,'Sale Id shift 80',0.00,0.00,0.00,821.92,0.00,'2023-01-24 13:10:36','',''),(583,'1','293','2',1,'Sale Id shift 80',0.00,0.00,0.00,707.49,0.00,'2023-01-24 13:10:36','',''),(584,'1','293','2',1,'Sale Id shift 80',0.00,0.00,0.00,1164.33,0.00,'2023-01-24 13:10:36','',''),(585,'1','293','1',1,'Sale Id shift 80',0.00,0.00,0.00,765.12,0.00,'2023-01-24 13:10:36','',''),(586,'1','293','1',1,'Sale Id shift 80',0.00,0.00,0.00,1911.10,0.00,'2023-01-24 13:10:36','',''),(587,'1','293','2',1,'Sale Id shift 80',0.00,0.00,0.00,1181.11,0.00,'2023-01-24 13:10:36','',''),(588,'1','293',NULL,1,'Sale Id shift 80',1572256.80,0.00,0.00,0.00,0.00,'2023-01-24 13:10:36','',''),(589,'1','293','2',1,'Sale Id shift 81',0.00,0.00,0.00,2278.59,0.00,'2023-01-24 13:40:56','',''),(590,'1','293','2',1,'Sale Id shift 81',0.00,0.00,0.00,1979.23,0.00,'2023-01-24 13:40:56','',''),(591,'1','293','2',1,'Sale Id shift 81',0.00,0.00,0.00,1503.69,0.00,'2023-01-24 13:40:56','',''),(592,'1','293','2',1,'Sale Id shift 81',0.00,0.00,0.00,2060.14,0.00,'2023-01-24 13:40:56','',''),(593,'1','293',NULL,1,'Sale Id shift 81',1877196.00,0.00,0.00,0.00,0.00,'2023-01-24 13:40:56','',''),(594,'1','293','2',1,'Sale Id shift 82',0.00,0.00,0.00,1755.21,0.00,'2023-01-24 14:20:47','',''),(595,'1','293','2',1,'Sale Id shift 82',0.00,0.00,0.00,1716.24,0.00,'2023-01-24 14:20:47','',''),(596,'1','293',NULL,1,'Sale Id shift 82',833148.00,0.00,0.00,0.00,0.00,'2023-01-24 14:20:47','',''),(597,'1','293','2',1,'Sale Id shift 83',0.00,0.00,0.00,1370.87,0.00,'2023-01-25 08:35:18','',''),(598,'1','293','2',1,'Sale Id shift 83',0.00,0.00,0.00,2486.39,0.00,'2023-01-25 08:35:18','',''),(599,'1','293','2',1,'Sale Id shift 83',0.00,0.00,0.00,2187.19,0.00,'2023-01-25 08:35:18','',''),(600,'1','293','2',1,'Sale Id shift 83',0.00,0.00,0.00,932.95,0.00,'2023-01-25 08:35:18','',''),(601,'1','293',NULL,1,'Sale Id shift 83',1674576.00,0.00,0.00,0.00,0.00,'2023-01-25 08:35:18','',''),(602,'1','293','2',1,'Sale Id shift 84',0.00,0.00,0.00,905.24,0.00,'2023-01-25 12:32:05','',''),(603,'1','293','2',1,'Sale Id shift 84',0.00,0.00,0.00,1722.49,0.00,'2023-01-25 12:32:05','',''),(604,'1','293','2',1,'Sale Id shift 84',0.00,0.00,0.00,1379.54,0.00,'2023-01-25 12:32:05','',''),(605,'1','293','2',1,'Sale Id shift 84',0.00,0.00,0.00,1523.00,0.00,'2023-01-25 12:32:05','',''),(606,'1','293',NULL,1,'Sale Id shift 84',1327264.80,0.00,0.00,0.00,0.00,'2023-01-25 12:32:05','',''),(607,'1','293','2',1,'Sale Id shift 85',0.00,0.00,0.00,1464.92,0.00,'2023-01-26 07:03:43','',''),(608,'1','293','2',1,'Sale Id shift 85',0.00,0.00,0.00,1374.13,0.00,'2023-01-26 07:03:43','',''),(609,'1','293','1',1,'Sale Id shift 85',0.00,0.00,0.00,620.91,0.00,'2023-01-26 07:03:43','',''),(610,'1','293','1',1,'Sale Id shift 85',0.00,0.00,0.00,408.47,0.00,'2023-01-26 07:03:43','',''),(611,'1','293',NULL,1,'Sale Id shift 85',928423.20,0.00,0.00,0.00,0.00,'2023-01-26 07:03:43','',''),(612,'1','293','1',1,'Sale Id shift 86',0.00,0.00,0.00,3240.17,0.00,'2023-01-26 19:34:05','',''),(613,'1','293','1',1,'Sale Id shift 86',0.00,0.00,0.00,3214.30,0.00,'2023-01-26 19:34:05','',''),(614,'1','293',NULL,1,'Sale Id shift 86',1549072.80,0.00,0.00,0.00,0.00,'2023-01-26 19:34:05','',''),(615,'1','293','1',1,'Sale Id shift 87',0.00,0.00,0.00,1982.47,0.00,'2023-01-27 09:54:33','',''),(616,'1','293','1',1,'Sale Id shift 87',0.00,0.00,0.00,2248.15,0.00,'2023-01-27 09:54:33','',''),(617,'1','293','1',1,'Sale Id shift 87',0.00,0.00,0.00,2237.36,0.00,'2023-01-27 09:54:33','',''),(618,'1','293','1',1,'Sale Id shift 87',0.00,0.00,0.00,2633.82,0.00,'2023-01-27 09:54:33','',''),(619,'1','293',NULL,1,'Sale Id shift 87',2184432.00,0.00,0.00,0.00,0.00,'2023-01-27 09:54:33','',''),(620,'1','293','1',1,'Sale Id shift 88',0.00,0.00,0.00,776.01,0.00,'2023-02-06 10:18:43','',''),(621,'1','293',NULL,1,'Sale Id shift 88',186242.40,0.00,0.00,0.00,0.00,'2023-02-06 10:18:43','',''),(622,'1','293',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3485000.00,17000.00,0.00,0.00,'2023-02-06 10:19:32','',''),(623,'1','293',NULL,1,'Reception corrector for bridging 26',0.00,0.00,0.00,17000.00,0.00,'2023-02-07 08:52:04','',''),(624,'1','293','2',1,'Received from bridging 26',0.00,0.00,17000.00,0.00,0.00,'2023-02-07 08:52:04','',''),(625,'1','293','2',1,'Sale Id shift 89',0.00,0.00,0.00,1529.71,0.00,'2023-02-07 14:01:58','',''),(626,'1','293','2',1,'Sale Id shift 89',0.00,0.00,0.00,2195.19,0.00,'2023-02-07 14:01:58','',''),(627,'1','293','2',1,'Sale Id shift 89',0.00,0.00,0.00,2273.85,0.00,'2023-02-07 14:01:58','',''),(628,'1','293','1',1,'Sale Id shift 89',0.00,0.00,0.00,638.29,0.00,'2023-02-07 14:01:58','',''),(629,'1','293','1',1,'Sale Id shift 89',0.00,0.00,0.00,521.20,0.00,'2023-02-07 14:01:58','',''),(630,'1','293','2',1,'Sale Id shift 89',0.00,0.00,0.00,1606.10,0.00,'2023-02-07 14:01:58','',''),(631,'1','293',NULL,1,'Sale Id shift 89',1796689.70,0.00,0.00,0.00,0.00,'2023-02-07 14:01:58','',''),(632,'1','293',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,10250000.00,50000.00,0.00,0.00,'2023-02-07 14:02:36','',''),(633,'1','293','2',1,'Sale Id shift 90',0.00,0.00,0.00,1011.00,0.00,'2023-02-08 08:04:17','',''),(634,'1','293','2',1,'Sale Id shift 90',0.00,0.00,0.00,1204.59,0.00,'2023-02-08 08:04:17','',''),(635,'1','293','2',1,'Sale Id shift 90',0.00,0.00,0.00,657.26,0.00,'2023-02-08 08:04:17','',''),(636,'1','293','2',1,'Sale Id shift 90',0.00,0.00,0.00,692.99,0.00,'2023-02-08 08:04:17','',''),(637,'1','293',NULL,1,'Sale Id shift 90',730997.20,0.00,0.00,0.00,0.00,'2023-02-08 08:04:17','',''),(638,'1','293',NULL,1,'Reception corrector for bridging 28',0.00,0.00,0.00,16500.00,0.00,'2023-02-08 10:58:02','',''),(639,'1','293','2',1,'Received from bridging 28',0.00,0.00,16500.00,0.00,0.00,'2023-02-08 10:58:02','',''),(640,'1','293',NULL,1,'Reception corrector for bridging 27',0.00,0.00,0.00,16500.00,0.00,'2023-02-08 10:58:02','',''),(641,'1','293','1',1,'Received from bridging 27',0.00,0.00,16500.00,0.00,0.00,'2023-02-08 10:58:02','',''),(642,'1','293',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,12300000.00,60000.00,0.00,0.00,'2023-02-08 13:49:13','',''),(643,'1','293','1',1,'Sale Id shift 91',0.00,0.00,0.00,818.98,0.00,'2023-02-08 14:20:52','',''),(644,'1','293','2',1,'Sale Id shift 91',0.00,0.00,0.00,2889.65,0.00,'2023-02-08 14:20:52','',''),(645,'1','293','2',1,'Sale Id shift 91',0.00,0.00,0.00,2624.44,0.00,'2023-02-08 14:20:52','',''),(646,'1','293','2',1,'Sale Id shift 91',0.00,0.00,0.00,2743.53,0.00,'2023-02-08 14:20:52','',''),(647,'1','293','1',1,'Sale Id shift 91',0.00,0.00,0.00,1680.87,0.00,'2023-02-08 14:20:52','',''),(648,'1','293','1',1,'Sale Id shift 91',0.00,0.00,0.00,2081.36,0.00,'2023-02-08 14:20:52','',''),(649,'1','293','1',1,'Sale Id shift 91',0.00,0.00,0.00,752.73,0.00,'2023-02-08 14:20:52','',''),(650,'1','293','1',1,'Sale Id shift 91',0.00,0.00,0.00,2191.56,0.00,'2023-02-08 14:20:52','',''),(651,'1','293','1',1,'Sale Id shift 91',0.00,0.00,0.00,2679.56,0.00,'2023-02-08 14:20:52','',''),(652,'1','293','2',1,'Sale Id shift 91',0.00,0.00,0.00,1201.35,0.00,'2023-02-08 14:20:52','',''),(653,'1','293',NULL,1,'Sale Id shift 91',4031126.15,0.00,0.00,0.00,0.00,'2023-02-08 14:20:52','',''),(654,'1','293',NULL,1,'Reception corrector for bridging 30',0.00,0.00,0.00,15000.00,0.00,'2023-02-08 15:28:51','',''),(655,'1','293','2',1,'Received from bridging 30',0.00,0.00,15000.00,0.00,0.00,'2023-02-08 15:28:51','',''),(656,'1','293',NULL,1,'Reception corrector for bridging 29',0.00,0.00,0.00,45000.00,0.00,'2023-02-08 15:28:52','',''),(657,'1','293','1',1,'Received from bridging 29',0.00,0.00,45000.00,0.00,0.00,'2023-02-08 15:28:52','',''),(658,'1','293','2',1,'Sale Id shift 92',0.00,0.00,0.00,4058.88,0.00,'2023-02-08 21:18:29','',''),(659,'1','293','2',1,'Sale Id shift 92',0.00,0.00,0.00,4812.06,0.00,'2023-02-08 21:18:29','',''),(660,'1','293','1',1,'Sale Id shift 92',0.00,0.00,0.00,1682.86,0.00,'2023-02-08 21:18:29','',''),(661,'1','293','1',1,'Sale Id shift 92',0.00,0.00,0.00,2016.91,0.00,'2023-02-08 21:18:29','',''),(662,'1','293',NULL,1,'Sale Id shift 92',2576995.55,0.00,0.00,0.00,0.00,'2023-02-08 21:18:29','',''),(663,'1','293',NULL,1,'Reception corrector for bridging 31',0.00,0.00,0.00,17000.00,0.00,'2023-02-09 12:20:48','',''),(664,'1','293','2',1,'Received from bridging 31',0.00,0.00,17000.00,0.00,0.00,'2023-02-09 12:20:48','',''),(665,'1','293','1',1,'Sale Id shift 93',0.00,0.00,0.00,665.38,0.00,'2023-02-09 23:34:41','',''),(666,'1','293','2',1,'Sale Id shift 93',0.00,0.00,0.00,3207.60,0.00,'2023-02-09 23:34:41','',''),(667,'1','293','2',1,'Sale Id shift 93',0.00,0.00,0.00,3083.39,0.00,'2023-02-09 23:34:41','',''),(668,'1','293','2',1,'Sale Id shift 93',0.00,0.00,0.00,3096.75,0.00,'2023-02-09 23:34:41','',''),(669,'1','293','1',1,'Sale Id shift 93',0.00,0.00,0.00,1259.57,0.00,'2023-02-09 23:34:41','',''),(670,'1','293','1',1,'Sale Id shift 93',0.00,0.00,0.00,2428.80,0.00,'2023-02-09 23:34:41','',''),(671,'1','293','1',1,'Sale Id shift 93',0.00,0.00,0.00,706.52,0.00,'2023-02-09 23:34:41','',''),(672,'1','293','1',1,'Sale Id shift 93',0.00,0.00,0.00,234.05,0.00,'2023-02-09 23:34:41','',''),(673,'1','293','1',1,'Sale Id shift 93',0.00,0.00,0.00,710.51,0.00,'2023-02-09 23:34:41','',''),(674,'1','293','2',1,'Sale Id shift 93',0.00,0.00,0.00,4305.60,0.00,'2023-02-09 23:34:41','',''),(675,'1','293',NULL,1,'Sale Id shift 93',4038124.85,0.00,0.00,0.00,0.00,'2023-02-09 23:34:41','',''),(676,'1','293','2',1,'Sale Id shift 94',0.00,0.00,0.00,1225.38,0.00,'2023-02-10 12:14:38','',''),(677,'1','293','2',1,'Sale Id shift 94',0.00,0.00,0.00,1142.59,0.00,'2023-02-10 12:14:38','',''),(678,'1','293','1',1,'Sale Id shift 94',0.00,0.00,0.00,3894.72,0.00,'2023-02-10 12:14:38','',''),(679,'1','293','1',1,'Sale Id shift 94',0.00,0.00,0.00,5001.54,0.00,'2023-02-10 12:14:38','',''),(680,'1','293',NULL,1,'Sale Id shift 94',2309167.15,0.00,0.00,0.00,0.00,'2023-02-10 12:14:38','',''),(681,'1','293','1',1,'Sale Id shift 95',0.00,0.00,0.00,937.81,0.00,'2023-02-11 06:33:07','',''),(682,'1','293','1',1,'Sale Id shift 95',0.00,0.00,0.00,1599.69,0.00,'2023-02-11 06:33:07','',''),(683,'1','293','1',1,'Sale Id shift 95',0.00,0.00,0.00,824.41,0.00,'2023-02-11 06:33:07','',''),(684,'1','293','1',1,'Sale Id shift 95',0.00,0.00,0.00,1020.97,0.00,'2023-02-11 06:33:07','',''),(685,'1','293','1',1,'Sale Id shift 95',0.00,0.00,0.00,1474.71,0.00,'2023-02-11 06:33:07','',''),(686,'1','293','1',1,'Sale Id shift 95',0.00,0.00,0.00,1484.67,0.00,'2023-02-11 06:33:07','',''),(687,'1','293',NULL,1,'Sale Id shift 95',1505163.30,0.00,0.00,0.00,0.00,'2023-02-11 06:33:07','',''),(688,'1','293','1',1,'Sale Id shift 96',0.00,0.00,0.00,3738.45,0.00,'2023-02-11 16:53:44','',''),(689,'1','293','1',1,'Sale Id shift 96',0.00,0.00,0.00,3571.65,0.00,'2023-02-11 16:53:44','',''),(690,'1','293',NULL,1,'Sale Id shift 96',1498570.50,0.00,0.00,0.00,0.00,'2023-02-11 16:53:44','',''),(691,'1','293','1',1,'Sale Id shift 97',0.00,0.00,0.00,2482.66,0.00,'2023-02-13 15:20:43','',''),(692,'1','293','1',1,'Sale Id shift 97',0.00,0.00,0.00,3720.51,0.00,'2023-02-13 15:20:43','',''),(693,'1','293',NULL,1,'Sale Id shift 97',1271649.85,0.00,0.00,0.00,0.00,'2023-02-13 15:20:43','',''),(694,'1','293','1',1,'Sale Id shift 98',0.00,0.00,0.00,1569.49,0.00,'2023-02-14 06:23:55','',''),(695,'1','293','1',1,'Sale Id shift 98',0.00,0.00,0.00,1183.92,0.00,'2023-02-14 06:23:55','',''),(696,'1','293',NULL,1,'Sale Id shift 98',564449.05,0.00,0.00,0.00,0.00,'2023-02-14 06:23:55','',''),(697,'1','293','1',1,'Sale Id shift 99',0.00,0.00,0.00,1361.23,0.00,'2023-02-15 06:20:31','',''),(698,'1','293','2',1,'Sale Id shift 99',0.00,0.00,0.00,44.15,0.00,'2023-02-15 06:20:31','',''),(699,'1','293','1',1,'Sale Id shift 99',0.00,0.00,0.00,1357.25,0.00,'2023-02-15 06:20:31','',''),(700,'1','293','1',1,'Sale Id shift 99',0.00,0.00,0.00,3780.40,0.00,'2023-02-15 06:20:31','',''),(701,'1','293','1',1,'Sale Id shift 99',0.00,0.00,0.00,3946.85,0.00,'2023-02-15 06:20:31','',''),(702,'1','293',NULL,1,'Sale Id shift 99',2150425.40,0.00,0.00,0.00,0.00,'2023-02-15 06:20:31','',''),(703,'1','293','2',1,'Sale Id shift 100',0.00,0.00,0.00,36.68,0.00,'2023-02-16 08:24:23','',''),(704,'1','293','2',1,'Sale Id shift 100',0.00,0.00,0.00,5062.17,0.00,'2023-02-16 08:24:23','',''),(705,'1','293','2',1,'Sale Id shift 100',0.00,0.00,0.00,5310.20,0.00,'2023-02-16 08:24:23','',''),(706,'1','293','2',1,'Sale Id shift 100',0.00,0.00,0.00,1953.89,0.00,'2023-02-16 08:24:23','',''),(707,'1','293',NULL,1,'Sale Id shift 100',2534402.70,0.00,0.00,0.00,0.00,'2023-02-16 08:24:23','',''),(708,'1','293','2',1,'Sale Id shift 101',0.00,0.00,0.00,1638.53,0.00,'2023-02-22 22:22:16','',''),(709,'1','293','2',1,'Sale Id shift 101',0.00,0.00,0.00,1663.28,0.00,'2023-02-22 22:22:16','',''),(710,'1','293','2',1,'Sale Id shift 101',0.00,0.00,0.00,1888.99,0.00,'2023-02-22 22:22:16','',''),(711,'1','293','2',1,'Sale Id shift 101',0.00,0.00,0.00,1085.99,0.00,'2023-02-22 22:22:16','',''),(712,'1','293',NULL,1,'Sale Id shift 101',1286741.95,0.00,0.00,0.00,0.00,'2023-02-22 22:22:16','',''),(713,'1','293','2',1,'Sale Id shift 102',0.00,0.00,0.00,696.88,0.00,'2023-02-24 22:29:07','',''),(714,'1','293',NULL,1,'Sale Id shift 102',142860.40,0.00,0.00,0.00,0.00,'2023-02-24 22:29:07','',''),(715,'1','293','2',1,'Sale Id shift 103',0.00,0.00,0.00,1105.12,0.00,'2023-02-27 08:18:53','',''),(716,'1','293','2',1,'Sale Id shift 103',0.00,0.00,0.00,679.96,0.00,'2023-02-27 08:18:53','',''),(717,'1','293',NULL,1,'Sale Id shift 103',365941.40,0.00,0.00,0.00,0.00,'2023-02-27 08:18:53','',''),(718,'1','293',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3675000.00,17500.00,0.00,0.00,'2023-03-01 15:21:16','',''),(719,'1','293',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,11750000.00,50000.00,0.00,0.00,'2023-03-01 15:22:08','',''),(720,'1','293',NULL,1,'Reception corrector for bridging 32',0.00,0.00,0.00,17500.00,0.00,'2023-03-01 15:29:49','',''),(721,'1','293','2',1,'Received from bridging 32',0.00,0.00,17500.00,0.00,0.00,'2023-03-01 15:29:49','',''),(722,'1','293',NULL,1,'Reception corrector for bridging 34',0.00,0.00,0.00,33000.00,0.00,'2023-03-01 15:31:37','',''),(723,'1','293','2',1,'Received from bridging 34',0.00,0.00,33000.00,0.00,0.00,'2023-03-01 15:31:37','',''),(724,'1','293',NULL,1,'Reception corrector for bridging 33',0.00,0.00,0.00,17000.00,0.00,'2023-03-01 15:31:38','',''),(725,'1','293','1',1,'Received from bridging 33',0.00,0.00,17000.00,0.00,0.00,'2023-03-01 15:31:38','',''),(726,'1','293','2',1,'Sale Id shift 105',0.00,0.00,0.00,1686.78,0.00,'2023-03-01 15:39:01','',''),(727,'1','293','2',1,'Sale Id shift 105',0.00,0.00,0.00,1933.85,0.00,'2023-03-01 15:39:01','',''),(728,'1','293','2',1,'Sale Id shift 105',0.00,0.00,0.00,2483.61,0.00,'2023-03-01 15:39:01','',''),(729,'1','293','2',1,'Sale Id shift 105',0.00,0.00,0.00,1698.26,0.00,'2023-03-01 15:39:01','',''),(730,'1','293',NULL,1,'Sale Id shift 105',1833587.50,0.00,0.00,0.00,0.00,'2023-03-01 15:39:01','',''),(731,'1','293','2',1,'Sale Id shift 106',0.00,0.00,0.00,1899.41,0.00,'2023-03-01 15:48:25','',''),(732,'1','293','2',1,'Sale Id shift 106',0.00,0.00,0.00,2261.73,0.00,'2023-03-01 15:48:25','',''),(733,'1','293','2',1,'Sale Id shift 106',0.00,0.00,0.00,1808.64,0.00,'2023-03-01 15:48:25','',''),(734,'1','293','2',1,'Sale Id shift 106',0.00,0.00,0.00,2008.13,0.00,'2023-03-01 15:48:25','',''),(735,'1','293',NULL,1,'Sale Id shift 106',1874808.85,0.00,0.00,0.00,0.00,'2023-03-01 15:48:25','',''),(736,'1','293','2',1,'Sale Id shift 107',0.00,0.00,0.00,392.72,0.00,'2023-03-01 15:57:13','',''),(737,'1','293','2',1,'Sale Id shift 107',0.00,0.00,0.00,1140.93,0.00,'2023-03-01 15:57:13','',''),(738,'1','293',NULL,1,'Sale Id shift 107',360407.75,0.00,0.00,0.00,0.00,'2023-03-01 15:57:13','',''),(739,'1','293','2',1,'Sale Id shift 108',0.00,0.00,0.00,320.20,0.00,'2023-03-01 16:16:39','',''),(740,'1','293','2',1,'Sale Id shift 108',0.00,0.00,0.00,120.54,0.00,'2023-03-01 16:16:39','',''),(741,'1','293',NULL,1,'Sale Id shift 108',103573.90,0.00,0.00,0.00,0.00,'2023-03-01 16:16:39','',''),(742,'1','293','1',1,'Sale Id shift 109',0.00,0.00,0.00,3928.77,0.00,'2023-03-03 09:56:07','',''),(743,'1','293','1',1,'Sale Id shift 109',0.00,0.00,0.00,3377.51,0.00,'2023-03-03 09:56:07','',''),(744,'1','293','1',1,'Sale Id shift 109',0.00,0.00,0.00,2451.32,0.00,'2023-03-03 09:56:07','',''),(745,'1','293','1',1,'Sale Id shift 109',0.00,0.00,0.00,1711.72,0.00,'2023-03-03 09:56:07','',''),(746,'1','293','1',1,'Sale Id shift 109',0.00,0.00,0.00,2864.26,0.00,'2023-03-03 09:56:07','',''),(747,'1','293','1',1,'Sale Id shift 109',0.00,0.00,0.00,1728.79,0.00,'2023-03-03 09:56:07','',''),(748,'1','293',NULL,1,'Sale Id shift 109',3774656.95,0.00,0.00,0.00,0.00,'2023-03-03 09:56:07','',''),(749,'1','293','2',1,'Sale Id shift 110',0.00,0.00,0.00,1891.63,0.00,'2023-03-03 12:24:16','',''),(750,'1','293','2',1,'Sale Id shift 110',0.00,0.00,0.00,1535.04,0.00,'2023-03-03 12:24:16','',''),(751,'1','293','2',1,'Sale Id shift 110',0.00,0.00,0.00,1665.47,0.00,'2023-03-03 12:24:16','',''),(752,'1','293','2',1,'Sale Id shift 110',0.00,0.00,0.00,1580.12,0.00,'2023-03-03 12:24:16','',''),(753,'1','293',NULL,1,'Sale Id shift 110',1567981.10,0.00,0.00,0.00,0.00,'2023-03-03 12:24:16','',''),(754,'1','293',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,11750000.00,50000.00,0.00,0.00,'2023-03-03 12:25:57','',''),(755,'1','293',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,11750000.00,50000.00,0.00,0.00,'2023-03-03 12:27:44','',''),(756,'1','293',NULL,1,'Reception corrector for bridging 35',0.00,0.00,0.00,50000.00,0.00,'2023-03-04 12:51:28','',''),(757,'1','293','1',1,'Received from bridging 35',0.00,0.00,50000.00,0.00,0.00,'2023-03-04 12:51:28','',''),(758,'1','293',NULL,1,'Reception corrector for bridging 36',0.00,0.00,0.00,50000.00,0.00,'2023-03-04 12:52:25','',''),(759,'1','293','2',1,'Received from bridging 36',0.00,0.00,50000.00,0.00,0.00,'2023-03-04 12:52:25','',''),(760,'1','293','1',1,'Sale Id shift 111',0.00,0.00,0.00,883.81,0.00,'2023-03-05 07:23:27','',''),(761,'1','293','2',1,'Sale Id shift 111',0.00,0.00,0.00,2809.77,0.00,'2023-03-05 07:23:28','',''),(762,'1','293','2',1,'Sale Id shift 111',0.00,0.00,0.00,1797.45,0.00,'2023-03-05 07:23:28','',''),(763,'1','293','2',1,'Sale Id shift 111',0.00,0.00,0.00,2169.23,0.00,'2023-03-05 07:23:28','',''),(764,'1','293','1',1,'Sale Id shift 111',0.00,0.00,0.00,637.30,0.00,'2023-03-05 07:23:28','',''),(765,'1','293','1',1,'Sale Id shift 111',0.00,0.00,0.00,827.51,0.00,'2023-03-05 07:23:28','',''),(766,'1','293','1',1,'Sale Id shift 111',0.00,0.00,0.00,1136.12,0.00,'2023-03-05 07:23:28','',''),(767,'1','293','1',1,'Sale Id shift 111',0.00,0.00,0.00,566.96,0.00,'2023-03-05 07:23:28','',''),(768,'1','293','1',1,'Sale Id shift 111',0.00,0.00,0.00,529.18,0.00,'2023-03-05 07:23:28','',''),(769,'1','293','2',1,'Sale Id shift 111',0.00,0.00,0.00,3170.59,0.00,'2023-03-05 07:23:28','',''),(770,'1','293',NULL,1,'Sale Id shift 111',3414061.20,0.00,0.00,0.00,0.00,'2023-03-05 07:23:28','',''),(771,'1','293','2',1,'Sale Id shift 112',0.00,0.00,0.00,857.47,0.00,'2023-03-05 14:31:39','',''),(772,'1','293','2',1,'Sale Id shift 112',0.00,0.00,0.00,1206.38,0.00,'2023-03-05 14:31:39','',''),(773,'1','293','2',1,'Sale Id shift 112',0.00,0.00,0.00,1937.38,0.00,'2023-03-05 14:31:39','',''),(774,'1','293','2',1,'Sale Id shift 112',0.00,0.00,0.00,284.72,0.00,'2023-03-05 14:31:39','',''),(775,'1','293',NULL,1,'Sale Id shift 112',1007198.25,0.00,0.00,0.00,0.00,'2023-03-05 14:31:39','',''),(776,'1','293','1',1,'Sale Id shift 113',0.00,0.00,0.00,1865.29,0.00,'2023-03-05 14:59:39','',''),(777,'1','293','2',1,'Sale Id shift 113',0.00,0.00,0.00,1768.54,0.00,'2023-03-05 14:59:39','',''),(778,'1','293','2',1,'Sale Id shift 113',0.00,0.00,0.00,1674.80,0.00,'2023-03-05 14:59:39','',''),(779,'1','293','1',1,'Sale Id shift 113',0.00,0.00,0.00,1390.95,0.00,'2023-03-05 14:59:39','',''),(780,'1','293','1',1,'Sale Id shift 113',0.00,0.00,0.00,817.49,0.00,'2023-03-05 14:59:39','',''),(781,'1','293','1',1,'Sale Id shift 113',0.00,0.00,0.00,1107.48,0.00,'2023-03-05 14:59:39','',''),(782,'1','293','1',1,'Sale Id shift 113',0.00,0.00,0.00,880.79,0.00,'2023-03-05 14:59:39','',''),(783,'1','293','1',1,'Sale Id shift 113',0.00,0.00,0.00,929.83,0.00,'2023-03-05 14:59:39','',''),(784,'1','293','2',1,'Sale Id shift 113',0.00,0.00,0.00,2606.28,0.00,'2023-03-05 14:59:39','',''),(785,'1','293',NULL,1,'Sale Id shift 113',3064740.75,0.00,0.00,0.00,0.00,'2023-03-05 14:59:39','',''),(786,'1','293','2',1,'Sale Id shift 114',0.00,0.00,0.00,1193.37,0.00,'2023-03-05 15:18:03','',''),(787,'1','293','2',1,'Sale Id shift 114',0.00,0.00,0.00,1769.45,0.00,'2023-03-05 15:18:03','',''),(788,'1','293','1',1,'Sale Id shift 114',0.00,0.00,0.00,663.86,0.00,'2023-03-05 15:18:03','',''),(789,'1','293',NULL,1,'Sale Id shift 114',852269.80,0.00,0.00,0.00,0.00,'2023-03-05 15:18:03','',''),(790,'1','293','1',1,'Sale Id shift 115',0.00,0.00,0.00,2015.05,0.00,'2023-03-06 23:06:43','',''),(791,'1','293','2',1,'Sale Id shift 115',0.00,0.00,0.00,2162.99,0.00,'2023-03-06 23:06:43','',''),(792,'1','293','2',1,'Sale Id shift 115',0.00,0.00,0.00,401.39,0.00,'2023-03-06 23:06:43','',''),(793,'1','293','2',1,'Sale Id shift 115',0.00,0.00,0.00,2004.82,0.00,'2023-03-06 23:06:43','',''),(794,'1','293','1',1,'Sale Id shift 115',0.00,0.00,0.00,2703.46,0.00,'2023-03-06 23:06:43','',''),(795,'1','293','1',1,'Sale Id shift 115',0.00,0.00,0.00,3021.65,0.00,'2023-03-06 23:06:43','',''),(796,'1','293','1',1,'Sale Id shift 115',0.00,0.00,0.00,2027.65,0.00,'2023-03-06 23:06:43','',''),(797,'1','293','1',1,'Sale Id shift 115',0.00,0.00,0.00,1351.79,0.00,'2023-03-06 23:06:43','',''),(798,'1','293','1',1,'Sale Id shift 115',0.00,0.00,0.00,1664.73,0.00,'2023-03-06 23:06:43','',''),(799,'1','293','2',1,'Sale Id shift 115',0.00,0.00,0.00,2795.20,0.00,'2023-03-06 23:06:43','',''),(800,'1','293',NULL,1,'Sale Id shift 115',4734951.55,0.00,0.00,0.00,0.00,'2023-03-06 23:06:43','',''),(801,'1','293',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,11750000.00,50000.00,0.00,0.00,'2023-03-06 23:08:06','',''),(802,'1','293','2',1,'Sale Id shift 116',0.00,0.00,0.00,2074.36,0.00,'2023-03-07 11:28:32','',''),(803,'1','293','2',1,'Sale Id shift 116',0.00,0.00,0.00,1463.48,0.00,'2023-03-07 11:28:32','',''),(804,'1','293',NULL,1,'Sale Id shift 116',831392.40,0.00,0.00,0.00,0.00,'2023-03-07 11:28:32','',''),(805,'1','293',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,11750000.00,50000.00,0.00,0.00,'2023-03-08 21:20:22','',''),(806,'1','293',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,10575000.00,45000.00,0.00,0.00,'2023-03-08 21:21:09','',''),(807,'1','293',NULL,1,'Reception corrector for bridging 38',0.00,0.00,0.00,30000.00,0.00,'2023-03-09 12:11:13','',''),(808,'1','293','2',1,'Received from bridging 38',0.00,0.00,30000.00,0.00,0.00,'2023-03-09 12:11:13','',''),(809,'1','293',NULL,1,'Reception corrector for bridging 37',0.00,0.00,0.00,20000.00,0.00,'2023-03-09 12:11:13','',''),(810,'1','293','1',1,'Received from bridging 37',0.00,0.00,20000.00,0.00,0.00,'2023-03-09 12:11:13','',''),(811,'1','293',NULL,1,'Reception corrector for bridging 39',0.00,0.00,0.00,50000.00,0.00,'2023-03-09 12:13:16','',''),(812,'1','293','1',1,'Received from bridging 39',0.00,0.00,50000.00,0.00,0.00,'2023-03-09 12:13:16','',''),(813,'1','293','1',1,'Sale Id shift 118',0.00,0.00,0.00,1226.34,0.00,'2023-03-09 12:20:06','',''),(814,'1','293','2',1,'Sale Id shift 118',0.00,0.00,0.00,1935.25,0.00,'2023-03-09 12:20:06','',''),(815,'1','293','2',1,'Sale Id shift 118',0.00,0.00,0.00,986.89,0.00,'2023-03-09 12:20:06','',''),(816,'1','293','2',1,'Sale Id shift 118',0.00,0.00,0.00,1116.84,0.00,'2023-03-09 12:20:06','',''),(817,'1','293','1',1,'Sale Id shift 118',0.00,0.00,0.00,551.81,0.00,'2023-03-09 12:20:06','',''),(818,'1','293','1',1,'Sale Id shift 118',0.00,0.00,0.00,2681.71,0.00,'2023-03-09 12:20:06','',''),(819,'1','293','1',1,'Sale Id shift 118',0.00,0.00,0.00,1287.89,0.00,'2023-03-09 12:20:06','',''),(820,'1','293','1',1,'Sale Id shift 118',0.00,0.00,0.00,643.07,0.00,'2023-03-09 12:20:06','',''),(821,'1','293','1',1,'Sale Id shift 118',0.00,0.00,0.00,1094.82,0.00,'2023-03-09 12:20:06','',''),(822,'1','293','2',1,'Sale Id shift 118',0.00,0.00,0.00,1852.11,0.00,'2023-03-09 12:20:06','',''),(823,'1','293',NULL,1,'Sale Id shift 118',3143531.55,0.00,0.00,0.00,0.00,'2023-03-09 12:20:06','',''),(824,'1','293','1',1,'Sale Id shift 119',0.00,0.00,0.00,1669.42,0.00,'2023-03-09 12:26:17','',''),(825,'1','293','2',1,'Sale Id shift 119',0.00,0.00,0.00,1924.27,0.00,'2023-03-09 12:26:17','',''),(826,'1','293','2',1,'Sale Id shift 119',0.00,0.00,0.00,1446.51,0.00,'2023-03-09 12:26:17','',''),(827,'1','293','2',1,'Sale Id shift 119',0.00,0.00,0.00,2041.84,0.00,'2023-03-09 12:26:17','',''),(828,'1','293','1',1,'Sale Id shift 119',0.00,0.00,0.00,1390.57,0.00,'2023-03-09 12:26:17','',''),(829,'1','293','1',1,'Sale Id shift 119',0.00,0.00,0.00,2556.13,0.00,'2023-03-09 12:26:17','',''),(830,'1','293','1',1,'Sale Id shift 119',0.00,0.00,0.00,1602.26,0.00,'2023-03-09 12:26:17','',''),(831,'1','293','1',1,'Sale Id shift 119',0.00,0.00,0.00,1750.14,0.00,'2023-03-09 12:26:17','',''),(832,'1','293','1',1,'Sale Id shift 119',0.00,0.00,0.00,1966.77,0.00,'2023-03-09 12:26:17','',''),(833,'1','293','2',1,'Sale Id shift 119',0.00,0.00,0.00,1915.98,0.00,'2023-03-09 12:26:17','',''),(834,'1','293',NULL,1,'Sale Id shift 119',4292014.15,0.00,0.00,0.00,0.00,'2023-03-09 12:26:17','',''),(835,'1','293','1',1,'Sale Id shift 120',0.00,0.00,0.00,1605.19,0.00,'2023-03-09 12:32:16','',''),(836,'1','293','1',1,'Sale Id shift 120',0.00,0.00,0.00,1388.48,0.00,'2023-03-09 12:32:16','',''),(837,'1','293','1',1,'Sale Id shift 120',0.00,0.00,0.00,2168.37,0.00,'2023-03-09 12:32:16','',''),(838,'1','293','1',1,'Sale Id shift 120',0.00,0.00,0.00,1357.16,0.00,'2023-03-09 12:32:16','',''),(839,'1','293','1',1,'Sale Id shift 120',0.00,0.00,0.00,2520.72,0.00,'2023-03-09 12:32:16','',''),(840,'1','293',NULL,1,'Sale Id shift 120',2124381.20,0.00,0.00,0.00,0.00,'2023-03-09 12:32:16','',''),(841,'1','293','2',1,'Sale Id shift 121',0.00,0.00,0.00,2963.26,0.00,'2023-03-09 12:39:05','',''),(842,'1','293','2',1,'Sale Id shift 121',0.00,0.00,0.00,2881.42,0.00,'2023-03-09 12:39:05','',''),(843,'1','293','2',1,'Sale Id shift 121',0.00,0.00,0.00,2280.64,0.00,'2023-03-09 12:39:05','',''),(844,'1','293','1',1,'Sale Id shift 121',0.00,0.00,0.00,752.41,0.00,'2023-03-09 12:39:05','',''),(845,'1','293','2',1,'Sale Id shift 121',0.00,0.00,0.00,2444.95,0.00,'2023-03-09 12:39:05','',''),(846,'1','293',NULL,1,'Sale Id shift 121',2660829.80,0.00,0.00,0.00,0.00,'2023-03-09 12:39:05','',''),(847,'1','293',NULL,1,'Reception corrector for bridging 40',0.00,0.00,0.00,45000.00,0.00,'2023-03-09 12:52:19','',''),(848,'1','293','2',1,'Received from bridging 40',0.00,0.00,45000.00,0.00,0.00,'2023-03-09 12:52:19','',''),(849,'1','293','1',1,'Sale Id shift 122',0.00,0.00,0.00,2516.62,0.00,'2023-03-09 16:24:38','',''),(850,'1','293','2',1,'Sale Id shift 122',0.00,0.00,0.00,1530.10,0.00,'2023-03-09 16:24:38','',''),(851,'1','293','2',1,'Sale Id shift 122',0.00,0.00,0.00,1514.42,0.00,'2023-03-09 16:24:38','',''),(852,'1','293','2',1,'Sale Id shift 122',0.00,0.00,0.00,2652.87,0.00,'2023-03-09 16:24:38','',''),(853,'1','293','1',1,'Sale Id shift 122',0.00,0.00,0.00,2093.82,0.00,'2023-03-09 16:24:38','',''),(854,'1','293','1',1,'Sale Id shift 122',0.00,0.00,0.00,3599.01,0.00,'2023-03-09 16:24:38','',''),(855,'1','293','1',1,'Sale Id shift 122',0.00,0.00,0.00,1259.66,0.00,'2023-03-09 16:24:38','',''),(856,'1','293','1',1,'Sale Id shift 122',0.00,0.00,0.00,2124.39,0.00,'2023-03-09 16:24:38','',''),(857,'1','293','1',1,'Sale Id shift 122',0.00,0.00,0.00,2699.97,0.00,'2023-03-09 16:24:38','',''),(858,'1','293','2',1,'Sale Id shift 122',0.00,0.00,0.00,1506.57,0.00,'2023-03-09 16:24:38','',''),(859,'1','293',NULL,1,'Sale Id shift 122',5051896.05,0.00,0.00,0.00,0.00,'2023-03-09 16:24:38','',''),(860,'1','293','1',1,'Sale Id shift 123',0.00,0.00,0.00,1725.19,0.00,'2023-03-10 13:16:18','',''),(861,'1','293','2',1,'Sale Id shift 123',0.00,0.00,0.00,1088.32,0.00,'2023-03-10 13:16:18','',''),(862,'1','293','2',1,'Sale Id shift 123',0.00,0.00,0.00,2315.43,0.00,'2023-03-10 13:16:18','',''),(863,'1','293','1',1,'Sale Id shift 123',0.00,0.00,0.00,1826.28,0.00,'2023-03-10 13:16:18','',''),(864,'1','293','1',1,'Sale Id shift 123',0.00,0.00,0.00,1886.27,0.00,'2023-03-10 13:16:18','',''),(865,'1','293','2',1,'Sale Id shift 123',0.00,0.00,0.00,1182.55,0.00,'2023-03-10 13:16:18','',''),(866,'1','293',NULL,1,'Sale Id shift 123',2355649.40,0.00,0.00,0.00,0.00,'2023-03-10 13:16:18','',''),(867,'1','293',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9400000.00,40000.00,0.00,0.00,'2023-03-10 15:41:39','',''),(868,'1','293',NULL,1,'Reception corrector for bridging 41',0.00,0.00,0.00,40000.00,0.00,'2023-03-10 18:13:50','',''),(869,'1','293','1',1,'Received from bridging 41',0.00,0.00,40000.00,0.00,0.00,'2023-03-10 18:13:50','',''),(870,'1','293','1',1,'Sale Id shift 124',0.00,0.00,0.00,1343.76,0.00,'2023-03-11 08:21:00','',''),(871,'1','293','2',1,'Sale Id shift 124',0.00,0.00,0.00,2030.58,0.00,'2023-03-11 08:21:00','',''),(872,'1','293','2',1,'Sale Id shift 124',0.00,0.00,0.00,1580.12,0.00,'2023-03-11 08:21:00','',''),(873,'1','293','2',1,'Sale Id shift 124',0.00,0.00,0.00,274.36,0.00,'2023-03-11 08:21:00','',''),(874,'1','293','1',1,'Sale Id shift 124',0.00,0.00,0.00,2514.67,0.00,'2023-03-11 08:21:00','',''),(875,'1','293','1',1,'Sale Id shift 124',0.00,0.00,0.00,293.13,0.00,'2023-03-11 08:21:00','',''),(876,'1','293','1',1,'Sale Id shift 124',0.00,0.00,0.00,2343.48,0.00,'2023-03-11 08:21:00','',''),(877,'1','293','1',1,'Sale Id shift 124',0.00,0.00,0.00,2013.36,0.00,'2023-03-11 08:21:00','',''),(878,'1','293','1',1,'Sale Id shift 124',0.00,0.00,0.00,1276.81,0.00,'2023-03-11 08:21:00','',''),(879,'1','293','2',1,'Sale Id shift 124',0.00,0.00,0.00,1782.75,0.00,'2023-03-11 08:21:00','',''),(880,'1','293',NULL,1,'Sale Id shift 124',3631459.70,0.00,0.00,0.00,0.00,'2023-03-11 08:21:00','',''),(881,'1','293','1',1,'Sale Id shift 125',0.00,0.00,0.00,2655.74,0.00,'2023-03-11 17:07:29','',''),(882,'1','293','2',1,'Sale Id shift 125',0.00,0.00,0.00,2583.00,0.00,'2023-03-11 17:07:29','',''),(883,'1','293','2',1,'Sale Id shift 125',0.00,0.00,0.00,779.02,0.00,'2023-03-11 17:07:29','',''),(884,'1','293','2',1,'Sale Id shift 125',0.00,0.00,0.00,2977.86,0.00,'2023-03-11 17:07:29','',''),(885,'1','293','1',1,'Sale Id shift 125',0.00,0.00,0.00,2398.38,0.00,'2023-03-11 17:07:29','',''),(886,'1','293','1',1,'Sale Id shift 125',0.00,0.00,0.00,2423.67,0.00,'2023-03-11 17:07:29','',''),(887,'1','293','2',1,'Sale Id shift 125',0.00,0.00,0.00,1466.36,0.00,'2023-03-11 17:07:29','',''),(888,'1','293',NULL,1,'Sale Id shift 125',3591747.05,0.00,0.00,0.00,0.00,'2023-03-11 17:07:29','',''),(889,'1','293','2',1,'Sale Id shift 126',0.00,0.00,0.00,2304.41,0.00,'2023-03-12 06:46:40','',''),(890,'1','293','2',1,'Sale Id shift 126',0.00,0.00,0.00,1281.94,0.00,'2023-03-12 06:46:40','',''),(891,'1','293','2',1,'Sale Id shift 126',0.00,0.00,0.00,1316.58,0.00,'2023-03-12 06:46:40','',''),(892,'1','293','1',1,'Sale Id shift 126',0.00,0.00,0.00,2435.17,0.00,'2023-03-12 06:46:40','',''),(893,'1','293','1',1,'Sale Id shift 126',0.00,0.00,0.00,1628.94,0.00,'2023-03-12 06:46:40','',''),(894,'1','293','1',1,'Sale Id shift 126',0.00,0.00,0.00,200.58,0.00,'2023-03-12 06:46:40','',''),(895,'1','293','1',1,'Sale Id shift 126',0.00,0.00,0.00,2218.08,0.00,'2023-03-12 06:46:40','',''),(896,'1','293','2',1,'Sale Id shift 126',0.00,0.00,0.00,1384.61,0.00,'2023-03-12 06:46:40','',''),(897,'1','293',NULL,1,'Sale Id shift 126',3001022.85,0.00,0.00,0.00,0.00,'2023-03-12 06:46:40','',''),(898,'1','293','1',1,'Sale Id shift 127',0.00,0.00,0.00,1379.24,0.00,'2023-03-12 21:47:55','',''),(899,'1','293','1',1,'Sale Id shift 127',0.00,0.00,0.00,1791.39,0.00,'2023-03-12 21:47:55','',''),(900,'1','293','1',1,'Sale Id shift 127',0.00,0.00,0.00,919.06,0.00,'2023-03-12 21:47:55','',''),(901,'1','293','1',1,'Sale Id shift 127',0.00,0.00,0.00,1630.14,0.00,'2023-03-12 21:47:55','',''),(902,'1','293','1',1,'Sale Id shift 127',0.00,0.00,0.00,2939.71,0.00,'2023-03-12 21:47:55','',''),(903,'1','293','1',1,'Sale Id shift 127',0.00,0.00,0.00,3978.22,0.00,'2023-03-12 21:47:55','',''),(904,'1','293',NULL,1,'Sale Id shift 127',2969873.60,0.00,0.00,0.00,0.00,'2023-03-12 21:47:55','',''),(905,'1','293',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,11750000.00,50000.00,0.00,0.00,'2023-03-12 21:48:39','',''),(906,'1','293',NULL,1,'Reception corrector for bridging 43',0.00,0.00,0.00,20000.00,0.00,'2023-03-13 14:14:27','',''),(907,'1','293','2',1,'Received from bridging 43',0.00,0.00,20000.00,0.00,0.00,'2023-03-13 14:14:27','',''),(908,'1','293',NULL,1,'Reception corrector for bridging 42',0.00,0.00,0.00,30000.00,0.00,'2023-03-13 14:14:27','',''),(909,'1','293','1',1,'Received from bridging 42',0.00,0.00,30000.00,0.00,0.00,'2023-03-13 14:14:27','',''),(910,'1','293','1',1,'Sale Id shift 128',0.00,0.00,0.00,1969.02,0.00,'2023-03-13 17:46:05','',''),(911,'1','293','2',1,'Sale Id shift 128',0.00,0.00,0.00,1088.69,0.00,'2023-03-13 17:46:05','',''),(912,'1','293','2',1,'Sale Id shift 128',0.00,0.00,0.00,1494.87,0.00,'2023-03-13 17:46:05','',''),(913,'1','293','2',1,'Sale Id shift 128',0.00,0.00,0.00,1817.84,0.00,'2023-03-13 17:46:05','',''),(914,'1','293','1',1,'Sale Id shift 128',0.00,0.00,0.00,906.33,0.00,'2023-03-13 17:46:05','',''),(915,'1','293','1',1,'Sale Id shift 128',0.00,0.00,0.00,819.31,0.00,'2023-03-13 17:46:05','',''),(916,'1','293','1',1,'Sale Id shift 128',0.00,0.00,0.00,759.34,0.00,'2023-03-13 17:46:05','',''),(917,'1','293','1',1,'Sale Id shift 128',0.00,0.00,0.00,666.86,0.00,'2023-03-13 17:46:05','',''),(918,'1','293','1',1,'Sale Id shift 128',0.00,0.00,0.00,1367.41,0.00,'2023-03-13 17:46:05','',''),(919,'1','293','2',1,'Sale Id shift 128',0.00,0.00,0.00,1944.38,0.00,'2023-03-13 17:46:05','',''),(920,'1','293',NULL,1,'Sale Id shift 128',3016001.75,0.00,0.00,0.00,0.00,'2023-03-13 17:46:05','',''),(921,'1','293','1',1,'Sale Id shift 129',0.00,0.00,0.00,992.04,0.00,'2023-03-14 18:30:28','',''),(922,'1','293','2',1,'Sale Id shift 129',0.00,0.00,0.00,1222.53,0.00,'2023-03-14 18:30:28','',''),(923,'1','293','2',1,'Sale Id shift 129',0.00,0.00,0.00,1947.43,0.00,'2023-03-14 18:30:28','',''),(924,'1','293','1',1,'Sale Id shift 129',0.00,0.00,0.00,871.81,0.00,'2023-03-14 18:30:28','',''),(925,'1','293','1',1,'Sale Id shift 129',0.00,0.00,0.00,1697.31,0.00,'2023-03-14 18:30:28','',''),(926,'1','293',NULL,1,'Sale Id shift 129',1581813.20,0.00,0.00,0.00,0.00,'2023-03-14 18:30:28','',''),(927,'1','293',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,10575000.00,45000.00,0.00,0.00,'2023-03-14 18:31:06','',''),(928,'1','293','1',1,'Sale Id shift 130',0.00,0.00,0.00,787.35,0.00,'2023-03-15 06:53:59','',''),(929,'1','293','2',1,'Sale Id shift 130',0.00,0.00,0.00,605.17,0.00,'2023-03-15 06:53:59','',''),(930,'1','293','2',1,'Sale Id shift 130',0.00,0.00,0.00,537.66,0.00,'2023-03-15 06:53:59','',''),(931,'1','293','2',1,'Sale Id shift 130',0.00,0.00,0.00,1006.42,0.00,'2023-03-15 06:53:59','',''),(932,'1','293','1',1,'Sale Id shift 130',0.00,0.00,0.00,617.59,0.00,'2023-03-15 06:53:59','',''),(933,'1','293','1',1,'Sale Id shift 130',0.00,0.00,0.00,754.09,0.00,'2023-03-15 06:53:59','',''),(934,'1','293','1',1,'Sale Id shift 130',0.00,0.00,0.00,789.88,0.00,'2023-03-15 06:53:59','',''),(935,'1','293','2',1,'Sale Id shift 130',0.00,0.00,0.00,228.72,0.00,'2023-03-15 06:53:59','',''),(936,'1','293',NULL,1,'Sale Id shift 130',1251816.80,0.00,0.00,0.00,0.00,'2023-03-15 06:53:59','',''),(937,'1','293','2',1,'Sale Id shift 131',0.00,0.00,0.00,2676.44,0.00,'2023-03-15 09:05:18','',''),(938,'1','293','1',1,'Sale Id shift 131',0.00,0.00,0.00,2022.28,0.00,'2023-03-15 09:05:18','',''),(939,'1','293','1',1,'Sale Id shift 131',0.00,0.00,0.00,1633.11,0.00,'2023-03-15 09:05:18','',''),(940,'1','293','1',1,'Sale Id shift 131',0.00,0.00,0.00,2218.56,0.00,'2023-03-15 09:05:18','',''),(941,'1','293','1',1,'Sale Id shift 131',0.00,0.00,0.00,3087.49,0.00,'2023-03-15 09:05:18','',''),(942,'1','293','2',1,'Sale Id shift 131',0.00,0.00,0.00,2068.63,0.00,'2023-03-15 09:05:18','',''),(943,'1','293',NULL,1,'Sale Id shift 131',3221029.85,0.00,0.00,0.00,0.00,'2023-03-15 09:05:18','',''),(944,'1','293','1',1,'Sale Id shift 133',0.00,0.00,0.00,2307.08,0.00,'2023-03-15 10:19:28','',''),(945,'1','293','2',1,'Sale Id shift 133',0.00,0.00,0.00,2399.51,0.00,'2023-03-15 10:19:28','',''),(946,'1','293','2',1,'Sale Id shift 133',0.00,0.00,0.00,1728.65,0.00,'2023-03-15 10:19:28','',''),(947,'1','293','1',1,'Sale Id shift 133',0.00,0.00,0.00,884.27,0.00,'2023-03-15 10:19:28','',''),(948,'1','293','1',1,'Sale Id shift 133',0.00,0.00,0.00,1555.72,0.00,'2023-03-15 10:19:28','',''),(949,'1','293',NULL,1,'Sale Id shift 133',2085679.05,0.00,0.00,0.00,0.00,'2023-03-15 10:19:28','',''),(950,'1','293',NULL,1,'Reception corrector for bridging 45',0.00,0.00,0.00,20000.00,0.00,'2023-03-15 13:19:17','',''),(951,'1','293','2',1,'Received from bridging 45',0.00,0.00,20000.00,0.00,0.00,'2023-03-15 13:19:17','',''),(952,'1','293',NULL,1,'Reception corrector for bridging 44',0.00,0.00,0.00,25000.00,0.00,'2023-03-15 13:19:17','',''),(953,'1','293','1',1,'Received from bridging 44',0.00,0.00,25000.00,0.00,0.00,'2023-03-15 13:19:17','',''),(954,'1','293','1',1,'Sale Id shift 134',0.00,0.00,0.00,1437.08,0.00,'2023-03-15 18:15:42','',''),(955,'1','293','2',1,'Sale Id shift 134',0.00,0.00,0.00,625.15,0.00,'2023-03-15 18:15:42','',''),(956,'1','293','2',1,'Sale Id shift 134',0.00,0.00,0.00,646.63,0.00,'2023-03-15 18:15:42','',''),(957,'1','293','2',1,'Sale Id shift 134',0.00,0.00,0.00,1915.01,0.00,'2023-03-15 18:15:42','',''),(958,'1','293','1',1,'Sale Id shift 134',0.00,0.00,0.00,739.68,0.00,'2023-03-15 18:15:42','',''),(959,'1','293','1',1,'Sale Id shift 134',0.00,0.00,0.00,777.62,0.00,'2023-03-15 18:15:42','',''),(960,'1','293','1',1,'Sale Id shift 134',0.00,0.00,0.00,1242.88,0.00,'2023-03-15 18:15:42','',''),(961,'1','293','1',1,'Sale Id shift 134',0.00,0.00,0.00,2331.84,0.00,'2023-03-15 18:15:42','',''),(962,'1','293','1',1,'Sale Id shift 134',0.00,0.00,0.00,2368.14,0.00,'2023-03-15 18:15:42','',''),(963,'1','293','2',1,'Sale Id shift 134',0.00,0.00,0.00,1379.03,0.00,'2023-03-15 18:15:42','',''),(964,'1','293',NULL,1,'Sale Id shift 134',3163819.10,0.00,0.00,0.00,0.00,'2023-03-15 18:15:42','',''),(965,'1','293','2',1,'Sale Id shift 135',0.00,0.00,0.00,137.04,0.00,'2023-03-16 09:07:13','',''),(966,'1','293','2',1,'Sale Id shift 135',0.00,0.00,0.00,1733.67,0.00,'2023-03-16 09:07:13','',''),(967,'1','293','2',1,'Sale Id shift 135',0.00,0.00,0.00,1670.33,0.00,'2023-03-16 09:07:13','',''),(968,'1','293','1',1,'Sale Id shift 135',0.00,0.00,0.00,2335.90,0.00,'2023-03-16 09:07:13','',''),(969,'1','293','1',1,'Sale Id shift 135',0.00,0.00,0.00,1798.05,0.00,'2023-03-16 09:07:13','',''),(970,'1','293','1',1,'Sale Id shift 135',0.00,0.00,0.00,2432.96,0.00,'2023-03-16 09:07:13','',''),(971,'1','293','2',1,'Sale Id shift 135',0.00,0.00,0.00,2648.34,0.00,'2023-03-16 09:07:13','',''),(972,'1','293',NULL,1,'Sale Id shift 135',2997728.15,0.00,0.00,0.00,0.00,'2023-03-16 09:07:13','',''),(973,'1','293','1',1,'Sale Id shift 136',0.00,0.00,0.00,869.15,0.00,'2023-03-16 12:19:57','',''),(974,'1','293','2',1,'Sale Id shift 136',0.00,0.00,0.00,5385.34,0.00,'2023-03-16 12:19:57','',''),(975,'1','293','2',1,'Sale Id shift 136',0.00,0.00,0.00,2595.62,0.00,'2023-03-16 12:19:57','',''),(976,'1','293','2',1,'Sale Id shift 136',0.00,0.00,0.00,4822.44,0.00,'2023-03-16 12:19:57','',''),(977,'1','293','1',1,'Sale Id shift 136',0.00,0.00,0.00,1659.57,0.00,'2023-03-16 12:19:57','',''),(978,'1','293','1',1,'Sale Id shift 136',0.00,0.00,0.00,2283.17,0.00,'2023-03-16 12:19:57','',''),(979,'1','293','2',1,'Sale Id shift 136',0.00,0.00,0.00,4378.09,0.00,'2023-03-16 12:19:57','',''),(980,'1','293',NULL,1,'Sale Id shift 136',5168444.30,0.00,0.00,0.00,0.00,'2023-03-16 12:19:57','',''),(981,'1','293','2',1,'Sale Id shift 137',0.00,0.00,0.00,2458.94,0.00,'2023-03-16 12:28:27','',''),(982,'1','293','2',1,'Sale Id shift 137',0.00,0.00,0.00,2130.90,0.00,'2023-03-16 12:28:27','',''),(983,'1','293','2',1,'Sale Id shift 137',0.00,0.00,0.00,2408.11,0.00,'2023-03-16 12:28:27','',''),(984,'1','293','1',1,'Sale Id shift 137',0.00,0.00,0.00,3078.12,0.00,'2023-03-16 12:28:27','',''),(985,'1','293','1',1,'Sale Id shift 137',0.00,0.00,0.00,1907.99,0.00,'2023-03-16 12:28:27','',''),(986,'1','293','1',1,'Sale Id shift 137',0.00,0.00,0.00,2452.55,0.00,'2023-03-16 12:28:27','',''),(987,'1','293',NULL,1,'Sale Id shift 137',3392603.35,0.00,0.00,0.00,0.00,'2023-03-16 12:28:27','',''),(988,'1','293','1',1,'Sale Id shift 138',0.00,0.00,0.00,1502.60,0.00,'2023-03-16 22:01:43','',''),(989,'1','293','2',1,'Sale Id shift 138',0.00,0.00,0.00,2278.56,0.00,'2023-03-16 22:01:43','',''),(990,'1','293','1',1,'Sale Id shift 138',0.00,0.00,0.00,2855.90,0.00,'2023-03-16 22:01:43','',''),(991,'1','293','1',1,'Sale Id shift 138',0.00,0.00,0.00,1045.46,0.00,'2023-03-16 22:01:43','',''),(992,'1','293','1',1,'Sale Id shift 138',0.00,0.00,0.00,4807.48,0.00,'2023-03-16 22:01:43','',''),(993,'1','293','2',1,'Sale Id shift 138',0.00,0.00,0.00,1610.14,0.00,'2023-03-16 22:01:43','',''),(994,'1','293',NULL,1,'Sale Id shift 138',3313532.90,0.00,0.00,0.00,0.00,'2023-03-16 22:01:43','',''),(995,'1','293','2',1,'Sale Id shift 139',0.00,0.00,0.00,2071.74,0.00,'2023-03-17 21:31:21','',''),(996,'1','293','2',1,'Sale Id shift 139',0.00,0.00,0.00,1651.50,0.00,'2023-03-17 21:31:21','',''),(997,'1','293','2',1,'Sale Id shift 139',0.00,0.00,0.00,2204.74,0.00,'2023-03-17 21:31:21','',''),(998,'1','293','1',1,'Sale Id shift 139',0.00,0.00,0.00,2299.35,0.00,'2023-03-17 21:31:21','',''),(999,'1','293','1',1,'Sale Id shift 139',0.00,0.00,0.00,2387.00,0.00,'2023-03-17 21:31:21','',''),(1000,'1','293','1',1,'Sale Id shift 139',0.00,0.00,0.00,2331.65,0.00,'2023-03-17 21:31:21','',''),(1001,'1','293','2',1,'Sale Id shift 139',0.00,0.00,0.00,1928.05,0.00,'2023-03-17 21:31:21','',''),(1002,'1','293',NULL,1,'Sale Id shift 139',3495397.05,0.00,0.00,0.00,0.00,'2023-03-17 21:31:21','',''),(1003,'1','293','2',1,'Sale Id shift 140',0.00,0.00,0.00,2937.83,0.00,'2023-03-18 07:16:42','',''),(1004,'1','293','2',1,'Sale Id shift 140',0.00,0.00,0.00,768.44,0.00,'2023-03-18 07:16:42','',''),(1005,'1','293','2',1,'Sale Id shift 140',0.00,0.00,0.00,1521.67,0.00,'2023-03-18 07:16:42','',''),(1006,'1','293','1',1,'Sale Id shift 140',0.00,0.00,0.00,1678.48,0.00,'2023-03-18 07:16:42','',''),(1007,'1','293','1',1,'Sale Id shift 140',0.00,0.00,0.00,2146.99,0.00,'2023-03-18 07:16:42','',''),(1008,'1','293','1',1,'Sale Id shift 140',0.00,0.00,0.00,2296.12,0.00,'2023-03-18 07:16:42','',''),(1009,'1','293','2',1,'Sale Id shift 140',0.00,0.00,0.00,2522.43,0.00,'2023-03-18 07:16:42','',''),(1010,'1','293',NULL,1,'Sale Id shift 140',3259910.60,0.00,0.00,0.00,0.00,'2023-03-18 07:16:42','',''),(1011,'1','293','2',1,'Sale Id shift 141',0.00,0.00,0.00,1962.17,0.00,'2023-03-20 08:10:15','',''),(1012,'1','293','2',1,'Sale Id shift 141',0.00,0.00,0.00,3501.57,0.00,'2023-03-20 08:10:15','',''),(1013,'1','293','2',1,'Sale Id shift 141',0.00,0.00,0.00,2645.15,0.00,'2023-03-20 08:10:15','',''),(1014,'1','293','2',1,'Sale Id shift 141',0.00,0.00,0.00,2216.95,0.00,'2023-03-20 08:10:15','',''),(1015,'1','293',NULL,1,'Sale Id shift 141',2426572.40,0.00,0.00,0.00,0.00,'2023-03-20 08:10:15','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'1','293',2,0.00,'2023-03-21 00:34:44'),(2,'1','293',1,49408.29,'2023-03-21 00:34:44');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=134 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1,'1','293',1,'Sale Id shift 1',0.00,1843216.70,178.00,1843216.70,0.00,'2022-11-03 09:56:57'),(2,'1','293',1,'Sale Id shift 2',0.00,1691040.94,178.00,1691040.94,0.00,'2022-11-07 08:25:35'),(3,'1','293',1,'Sale Id shift 3',0.00,1865272.68,178.00,1865272.68,0.00,'2022-11-10 16:31:26'),(4,'1','293',1,'Sale Id shift 4',0.00,1819989.48,178.00,1819989.48,0.00,'2022-11-10 16:45:12'),(5,'1','293',1,'Sale Id shift 5',0.00,2175875.56,178.00,2175875.56,0.00,'2022-11-10 16:58:12'),(6,'1','293',1,'Sale Id shift 6',0.00,1920986.68,178.00,1920986.68,0.00,'2022-11-10 17:09:05'),(7,'1','293',1,'Sale Id shift 7',0.00,2146110.40,178.00,2146110.40,0.00,'2022-11-10 17:36:41'),(8,'1','293',1,'Sale Id shift 8',0.00,1838104.54,178.00,1838104.54,0.00,'2022-11-11 10:37:37'),(9,'1','293',1,'Sale Id shift 9',0.00,2113381.54,178.00,2113381.54,0.00,'2022-11-11 12:19:45'),(10,'1','293',1,'Sale Id shift 10',0.00,1618571.80,178.00,1618571.80,0.00,'2022-11-12 08:16:30'),(11,'1','293',1,'Sale Id shift 11',0.00,1692393.74,178.00,1692393.74,0.00,'2022-11-14 09:09:16'),(12,'1','293',1,'Sale Id shift 12',0.00,1757271.18,178.00,1757271.18,0.00,'2022-11-15 21:35:02'),(13,'1','293',1,'Sale Id shift 13',0.00,1643077.06,178.00,1643077.06,0.00,'2022-11-18 06:27:19'),(14,'1','293',1,'Sale Id shift 14',0.00,998930.66,178.00,998930.66,0.00,'2022-11-23 01:31:04'),(15,'1','293',1,'Sale Id shift 15',0.00,408056.10,178.00,408056.10,0.00,'2022-11-24 04:31:02'),(16,'1','293',1,'Sale Id shift 16',0.00,2131422.30,178.00,1806634.14,-324788.16,'2022-11-24 11:24:08'),(17,'1','293',1,'Sale Id shift 17',0.00,2139267.90,178.00,1813284.22,-325983.68,'2022-11-25 17:26:36'),(18,'1','293',1,'Sale Id shift 19',0.00,2128051.80,178.00,1803777.24,-324274.56,'2022-11-26 10:14:55'),(19,'1','293',1,'Sale Id shift 20',0.00,2066509.20,178.00,1751612.56,-314896.64,'2022-11-26 10:26:24'),(20,'1','293',1,'Sale Id shift 21',0.00,2259948.60,178.00,1915575.48,-344373.12,'2022-11-26 10:39:20'),(21,'1','293',1,'Sale Id shift 22',0.00,2030290.50,178.00,1720912.90,-309377.60,'2022-11-26 10:49:25'),(22,'1','293',1,'Sale Id shift 23',0.00,2085873.30,178.00,1768025.94,-317847.36,'2022-11-26 10:59:38'),(23,'1','293',1,'Sale Id shift 24',0.00,1658193.60,178.00,1405516.48,-252677.12,'2022-11-26 11:05:25'),(24,'1','293',1,'Sale Id shift 25',0.00,2052157.80,178.00,1739448.04,-312709.76,'2022-11-26 15:17:22'),(25,'1','293',1,'Sale Id shift 26',0.00,2013803.40,178.00,1706938.12,-306865.28,'2022-11-27 09:19:37'),(26,'1','293',1,'Sale Id shift 27',0.00,1839411.00,178.00,1559119.80,-280291.20,'2022-11-28 13:57:03'),(27,'1','293',1,'Sale Id shift 28',0.00,2004666.30,178.00,1699193.34,-305472.96,'2022-11-30 12:49:24'),(28,'1','293',1,'Sale Id shift 29',0.00,2636963.70,178.00,2235140.66,-401823.04,'2022-11-30 13:06:55'),(29,'1','293',1,'Sale Id shift 30',0.00,2068466.40,178.00,1753271.52,-315194.88,'2022-11-30 15:21:32'),(30,'1','293',1,'Sale Id shift 31',0.00,265593.30,178.00,225121.94,-40471.36,'2022-12-01 07:38:38'),(31,'1','293',1,'Sale Id shift 32',0.00,3310139.70,210.00,3310139.70,0.00,'2022-12-01 07:59:38'),(32,'1','293',1,'Sale Id shift 33',0.00,2465450.40,210.00,2465450.40,0.00,'2022-12-01 08:10:53'),(33,'1','293',1,'Sale Id shift 34',0.00,2920747.20,210.00,2920747.20,0.00,'2022-12-01 08:22:37'),(34,'1','293',1,'Sale Id shift 35',0.00,1803263.70,210.00,1803263.70,0.00,'2022-12-01 08:34:51'),(35,'1','293',1,'Sale Id shift 36',0.00,1842363.60,210.00,1842363.60,0.00,'2022-12-01 08:52:33'),(36,'1','293',1,'Sale Id shift 37',0.00,912865.80,210.00,912865.80,0.00,'2022-12-01 08:58:52'),(37,'1','293',1,'Sale Id shift 38',0.00,4402158.60,210.00,4402158.60,0.00,'2022-12-01 09:05:16'),(38,'1','293',1,'Sale Id shift 39',0.00,3302903.10,210.00,3302903.10,0.00,'2022-12-01 09:12:05'),(39,'1','293',1,'Sale Id shift 40',0.00,4294760.40,210.00,4294760.40,0.00,'2022-12-01 09:26:30'),(40,'1','293',1,'Sale Id shift 41',0.00,4151282.10,210.00,4151282.10,0.00,'2022-12-01 09:36:56'),(41,'1','293',1,'Sale Id shift 42',0.00,5281206.00,210.00,5281206.00,0.00,'2022-12-01 09:43:11'),(42,'1','293',1,'Sale Id shift 44',0.00,2899722.00,210.00,2899722.00,0.00,'2022-12-01 10:01:13'),(43,'1','293',1,'Sale Id shift 45',0.00,4244373.00,210.00,4244373.00,0.00,'2022-12-01 10:18:51'),(44,'1','293',1,'Sale Id shift 46',0.00,3321843.00,210.00,3321843.00,0.00,'2022-12-01 10:25:57'),(45,'1','293',1,'Sale Id shift 47',0.00,2659091.40,210.00,2659091.40,0.00,'2022-12-01 10:30:06'),(46,'1','293',1,'Sale Id shift 48',0.00,3676732.50,210.00,3676732.50,0.00,'2022-12-01 10:35:24'),(47,'1','293',1,'Sale Id shift 49',0.00,2932150.20,210.00,2932150.20,0.00,'2022-12-01 10:38:40'),(48,'1','293',1,'Sale Id shift 50',0.00,2026294.20,210.00,2026294.20,0.00,'2022-12-15 21:49:27'),(49,'1','293',1,'Sale Id shift 52',0.00,236049.00,230.00,236049.00,0.00,'2022-12-17 00:18:38'),(50,'1','293',1,'Sale Id shift 53',0.00,2681294.00,230.00,2681294.00,0.00,'2022-12-17 14:58:29'),(51,'1','293',1,'Sale Id shift 54',0.00,3430801.90,230.00,3430801.90,0.00,'2022-12-17 15:34:33'),(52,'1','293',1,'Sale Id shift 55',0.00,3288151.30,230.00,3288151.30,0.00,'2022-12-17 15:40:26'),(53,'1','293',1,'Sale Id shift 56',0.00,1397178.70,230.00,1397178.70,0.00,'2022-12-18 21:05:39'),(54,'1','293',1,'Sale Id shift 57',0.00,2825441.90,230.00,2825441.90,0.00,'2022-12-21 07:56:24'),(55,'1','293',1,'Sale Id shift 58',0.00,3724916.70,230.00,3724916.70,0.00,'2022-12-24 06:56:37'),(56,'1','293',1,'Sale Id shift 59',0.00,2238748.80,240.00,2238748.80,0.00,'2022-12-24 23:11:25'),(57,'1','293',1,'Sale Id shift 60',0.00,1886966.40,240.00,1886966.40,0.00,'2022-12-25 22:10:45'),(58,'1','293',1,'Sale Id shift 61',0.00,917479.20,240.00,917479.20,0.00,'2022-12-31 06:59:30'),(59,'1','293',1,'Sale Id shift 62',0.00,2441904.00,240.00,2441904.00,0.00,'2023-01-05 05:08:26'),(60,'1','293',1,'Sale Id shift 64',0.00,766219.20,240.00,766219.20,0.00,'2023-01-08 17:27:03'),(61,'1','293',1,'Sale Id shift 65',0.00,794061.60,240.00,794061.60,0.00,'2023-01-10 15:03:14'),(62,'1','293',1,'Sale Id shift 66',0.00,1502114.40,240.00,1502114.40,0.00,'2023-01-11 07:00:30'),(63,'1','293',1,'Sale Id shift 67',0.00,581088.00,240.00,581088.00,0.00,'2023-01-11 14:34:42'),(64,'1','293',1,'Sale Id shift 68',0.00,1685690.40,240.00,1685690.40,0.00,'2023-01-12 07:01:20'),(65,'1','293',1,'Sale Id shift 69',0.00,3326061.60,240.00,3326061.60,0.00,'2023-01-13 23:59:13'),(66,'1','293',1,'Sale Id shift 70',0.00,1859337.60,240.00,1859337.60,0.00,'2023-01-14 14:59:56'),(67,'1','293',1,'Sale Id shift 71',0.00,424848.00,240.00,424848.00,0.00,'2023-01-15 21:37:07'),(68,'1','293',1,'Sale Id shift 72',0.00,3608870.40,240.00,3608870.40,0.00,'2023-01-16 13:47:06'),(69,'1','293',1,'Sale Id shift 73',0.00,2257027.20,240.00,2257027.20,0.00,'2023-01-17 06:17:31'),(70,'1','293',1,'Sale Id shift 74',0.00,1424167.20,240.00,1424167.20,0.00,'2023-01-17 10:49:59'),(71,'1','293',1,'Sale Id shift 75',0.00,519076.80,240.00,519076.80,0.00,'2023-01-17 17:18:49'),(72,'1','293',1,'Sale Id shift 77',0.00,2024109.60,240.00,2024109.60,0.00,'2023-01-21 22:01:35'),(73,'1','293',1,'Sale Id shift 78',0.00,1557309.60,240.00,1557309.60,0.00,'2023-01-23 16:55:23'),(74,'1','293',1,'Sale Id shift 79',0.00,1282344.00,240.00,1282344.00,0.00,'2023-01-24 12:52:59'),(75,'1','293',1,'Sale Id shift 80',0.00,1572256.80,240.00,1572256.80,0.00,'2023-01-24 13:10:36'),(76,'1','293',1,'Sale Id shift 81',0.00,1877196.00,240.00,1877196.00,0.00,'2023-01-24 13:40:56'),(77,'1','293',1,'Sale Id shift 82',0.00,833148.00,240.00,833148.00,0.00,'2023-01-24 14:20:47'),(78,'1','293',1,'Sale Id shift 83',0.00,1674576.00,240.00,1674576.00,0.00,'2023-01-25 08:35:18'),(79,'1','293',1,'Sale Id shift 84',0.00,1327264.80,240.00,1327264.80,0.00,'2023-01-25 12:32:05'),(80,'1','293',1,'Sale Id shift 85',0.00,928423.20,230.00,889738.90,-38684.30,'2023-01-26 07:03:43'),(81,'1','293',1,'Sale Id shift 86',0.00,1549072.80,230.00,1484528.10,-64544.70,'2023-01-26 19:34:05'),(82,'1','293',1,'Sale Id shift 87',0.00,2184432.00,240.00,2184432.00,0.00,'2023-01-27 09:54:33'),(83,'1','293',1,'Sale Id shift 88',0.00,186242.40,240.00,186242.40,0.00,'2023-02-06 10:18:43'),(84,'1','293',1,'Sale Id shift 89',0.00,1796689.70,205.00,1796689.70,0.00,'2023-02-07 14:01:58'),(85,'1','293',1,'Sale Id shift 90',0.00,730997.20,205.00,730997.20,0.00,'2023-02-08 08:04:17'),(86,'1','293',1,'Sale Id shift 91',0.00,4031126.15,205.00,4031126.15,0.00,'2023-02-08 14:20:52'),(87,'1','293',1,'Sale Id shift 92',0.00,2576995.55,205.00,2576995.55,0.00,'2023-02-08 21:18:29'),(88,'1','293',1,'Sale Id shift 93',0.00,4038124.85,205.00,4038124.85,0.00,'2023-02-09 23:34:41'),(89,'1','293',1,'Sale Id shift 94',0.00,2309167.15,205.00,2309167.15,0.00,'2023-02-10 12:14:38'),(90,'1','293',1,'Sale Id shift 95',0.00,1505163.30,205.00,1505163.30,0.00,'2023-02-11 06:33:07'),(91,'1','293',1,'Sale Id shift 96',0.00,1498570.50,205.00,1498570.50,0.00,'2023-02-11 16:53:44'),(92,'1','293',1,'Sale Id shift 97',0.00,1271649.85,205.00,1271649.85,0.00,'2023-02-13 15:20:43'),(93,'1','293',1,'Sale Id shift 98',0.00,564449.05,205.00,564449.05,0.00,'2023-02-14 06:23:55'),(94,'1','293',1,'Sale Id shift 99',0.00,2150425.40,205.00,2150425.40,0.00,'2023-02-15 06:20:31'),(95,'1','293',1,'Sale Id shift 100',0.00,2534402.70,205.00,2534402.70,0.00,'2023-02-16 08:24:23'),(96,'1','293',1,'Sale Id shift 101',0.00,1286741.95,205.00,1286741.95,0.00,'2023-02-22 22:22:16'),(97,'1','293',1,'Sale Id shift 102',0.00,142860.40,205.00,142860.40,0.00,'2023-02-24 22:29:07'),(98,'1','293',1,'Sale Id shift 103',0.00,365941.40,205.00,365941.40,0.00,'2023-02-27 08:18:53'),(99,'1','293',1,'Sale Id shift 105',0.00,1833587.50,210.00,1638525.00,-195062.50,'2023-03-01 15:39:01'),(100,'1','293',1,'Sale Id shift 106',0.00,1874808.85,210.00,1675361.10,-199447.75,'2023-03-01 15:48:25'),(101,'1','293',1,'Sale Id shift 107',0.00,360407.75,210.00,322066.50,-38341.25,'2023-03-01 15:57:13'),(102,'1','293',1,'Sale Id shift 108',0.00,103573.90,210.00,92555.40,-11018.50,'2023-03-01 16:16:39'),(103,'1','293',1,'Sale Id shift 109',0.00,3774656.95,235.00,3774656.95,0.00,'2023-03-03 09:56:07'),(104,'1','293',1,'Sale Id shift 110',0.00,1567981.10,235.00,1567981.10,0.00,'2023-03-03 12:24:16'),(105,'1','293',1,'Sale Id shift 111',0.00,3414061.20,235.00,3414061.20,0.00,'2023-03-05 07:23:28'),(106,'1','293',1,'Sale Id shift 112',0.00,1007198.25,235.00,1007198.25,0.00,'2023-03-05 14:31:39'),(107,'1','293',1,'Sale Id shift 113',0.00,3064740.75,235.00,3064740.75,0.00,'2023-03-05 14:59:39'),(108,'1','293',1,'Sale Id shift 114',0.00,852269.80,235.00,852269.80,0.00,'2023-03-05 15:18:03'),(109,'1','293',1,'Sale Id shift 115',0.00,4734951.55,235.00,4734951.55,0.00,'2023-03-06 23:06:44'),(110,'1','293',1,'Sale Id shift 116',0.00,831392.40,235.00,831392.40,0.00,'2023-03-07 11:28:32'),(111,'1','293',1,'Sale Id shift 118',0.00,3143531.55,235.00,3143531.55,0.00,'2023-03-09 12:20:06'),(112,'1','293',1,'Sale Id shift 119',0.00,4292014.15,235.00,4292014.15,0.00,'2023-03-09 12:26:17'),(113,'1','293',1,'Sale Id shift 120',0.00,2124381.20,235.00,2124381.20,0.00,'2023-03-09 12:32:16'),(114,'1','293',1,'Sale Id shift 121',0.00,2660829.80,235.00,2660829.80,0.00,'2023-03-09 12:39:05'),(115,'1','293',1,'Sale Id shift 122',0.00,5051896.05,235.00,5051896.05,0.00,'2023-03-09 16:24:38'),(116,'1','293',1,'Sale Id shift 123',0.00,2355649.40,235.00,2355649.40,0.00,'2023-03-10 13:16:18'),(117,'1','293',1,'Sale Id shift 124',0.00,3631459.70,235.00,3631459.70,0.00,'2023-03-11 08:21:00'),(118,'1','293',1,'Sale Id shift 125',0.00,3591747.05,235.00,3591747.05,0.00,'2023-03-11 17:07:29'),(119,'1','293',1,'Sale Id shift 126',0.00,3001022.85,235.00,3001022.85,0.00,'2023-03-12 06:46:40'),(120,'1','293',1,'Sale Id shift 127',0.00,2969873.60,235.00,2969873.60,0.00,'2023-03-12 21:47:55'),(121,'1','293',1,'Sale Id shift 128',0.00,3016001.75,235.00,3016001.75,0.00,'2023-03-13 17:46:05'),(122,'1','293',1,'Sale Id shift 129',0.00,1581813.20,235.00,1581813.20,0.00,'2023-03-14 18:30:28'),(123,'1','293',1,'Sale Id shift 130',0.00,1251816.80,235.00,1251816.80,0.00,'2023-03-15 06:53:59'),(124,'1','293',1,'Sale Id shift 131',0.00,3221029.85,235.00,3221029.85,0.00,'2023-03-15 09:05:18'),(125,'1','293',1,'Sale Id shift 133',0.00,2085679.05,235.00,2085679.05,0.00,'2023-03-15 10:19:28'),(126,'1','293',1,'Sale Id shift 134',0.00,3163819.10,235.00,3163819.10,0.00,'2023-03-15 18:15:42'),(127,'1','293',1,'Sale Id shift 135',0.00,2997728.15,235.00,2997728.15,0.00,'2023-03-16 09:07:13'),(128,'1','293',1,'Sale Id shift 136',0.00,5168444.30,235.00,5168444.30,0.00,'2023-03-16 12:19:57'),(129,'1','293',1,'Sale Id shift 137',0.00,3392603.35,235.00,3392603.35,0.00,'2023-03-16 12:28:27'),(130,'1','293',1,'Sale Id shift 138',0.00,3313532.90,235.00,3313532.90,0.00,'2023-03-16 22:01:43'),(131,'1','293',1,'Sale Id shift 139',0.00,3495397.05,235.00,3495397.05,0.00,'2023-03-17 21:31:21'),(132,'1','293',1,'Sale Id shift 140',0.00,3259910.60,235.00,3259910.60,0.00,'2023-03-18 07:16:42'),(133,'1','293',1,'Sale Id shift 141',0.00,2426572.40,235.00,2426572.40,0.00,'2023-03-20 08:10:15');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=694 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('1','293',1,'','24','3',0.00,8544000.00,'Purchase Id 1 for 48,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-01 18:15:56','',''),('1','293',2,'','supplier','1',8544000.00,0.00,'Purchase Id 1 for 48,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-01 18:15:56','',''),('1','293',3,'','24','3',0.00,8900000.00,'Purchase Id 2 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-01 18:16:23','',''),('1','293',4,'','supplier','1',8900000.00,0.00,'Purchase Id 2 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-01 18:16:23','',''),('1','293',5,'','24','3',0.00,8900000.00,'Purchase Id 3 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-01 18:16:49','',''),('1','293',6,'','supplier','1',8900000.00,0.00,'Purchase Id 3 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-01 18:16:49','',''),('1','293',7,'','24','3',0.00,8900000.00,'Purchase Id 4 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-01 18:17:15','',''),('1','293',8,'','supplier','1',8900000.00,0.00,'Purchase Id 4 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-01 18:17:15','',''),('1','293',9,'','24','3',0.00,8010000.00,'Purchase Id 5 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-01 18:17:52','',''),('1','293',10,'','supplier','1',8010000.00,0.00,'Purchase Id 5 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-01 18:17:52','',''),('1','293',11,'','24','3',0.00,8010000.00,'Purchase Id 6 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-01 18:18:14','',''),('1','293',12,'','supplier','1',8010000.00,0.00,'Purchase Id 6 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-01 18:18:14','',''),('1','293',13,'','20','1',1843216.70,0.00,'Sales from shift 1 on 2022-11-03 09:56:57 ','2022-11-03 09:56:57','',''),('1','293',14,'','6.1','4',0.00,1843216.70,'Sales from shift 1 on 2022-11-03 09:56:57 ','2022-11-03 09:56:57','',''),('1','293',15,'','20','1',1691040.94,0.00,'Sales from shift 2 on 2022-11-07 08:25:35 ','2022-11-07 08:25:35','',''),('1','293',16,'','6.1','4',0.00,1691040.94,'Sales from shift 2 on 2022-11-07 08:25:35 ','2022-11-07 08:25:35','',''),('1','293',17,'','20','1',1865272.68,0.00,'Sales from shift 3 on 2022-11-10 16:31:26 ','2022-11-10 16:31:26','',''),('1','293',18,'','6.1','4',0.00,1865272.68,'Sales from shift 3 on 2022-11-10 16:31:26 ','2022-11-10 16:31:26','',''),('1','293',19,'','20','1',1819989.48,0.00,'Sales from shift 4 on 2022-11-10 16:45:12 ','2022-11-10 16:45:12','',''),('1','293',20,'','6.1','4',0.00,1819989.48,'Sales from shift 4 on 2022-11-10 16:45:12 ','2022-11-10 16:45:12','',''),('1','293',21,'','20','1',2175875.56,0.00,'Sales from shift 5 on 2022-11-10 16:58:12 ','2022-11-10 16:58:12','',''),('1','293',22,'','6.1','4',0.00,2175875.56,'Sales from shift 5 on 2022-11-10 16:58:12 ','2022-11-10 16:58:12','',''),('1','293',23,'','20','1',1920986.68,0.00,'Sales from shift 6 on 2022-11-10 17:09:05 ','2022-11-10 17:09:05','',''),('1','293',24,'','6.1','4',0.00,1920986.68,'Sales from shift 6 on 2022-11-10 17:09:05 ','2022-11-10 17:09:05','',''),('1','293',25,'','20','1',2146110.40,0.00,'Sales from shift 7 on 2022-11-10 17:36:41 ','2022-11-10 17:36:41','',''),('1','293',26,'','6.1','4',0.00,2146110.40,'Sales from shift 7 on 2022-11-10 17:36:41 ','2022-11-10 17:36:41','',''),('1','293',27,'','20','1',1838104.54,0.00,'Sales from shift 8 on 2022-11-11 10:37:36 ','2022-11-11 10:37:36','',''),('1','293',28,'','6.1','4',0.00,1838104.54,'Sales from shift 8 on 2022-11-11 10:37:36 ','2022-11-11 10:37:36','',''),('1','293',29,'','20','1',2113381.54,0.00,'Sales from shift 9 on 2022-11-11 12:19:45 ','2022-11-11 12:19:45','',''),('1','293',30,'','6.1','4',0.00,2113381.54,'Sales from shift 9 on 2022-11-11 12:19:45 ','2022-11-11 12:19:45','',''),('1','293',31,'','20','1',1618571.80,0.00,'Sales from shift 10 on 2022-11-12 08:16:30 ','2022-11-12 08:16:30','',''),('1','293',32,'','6.1','4',0.00,1618571.80,'Sales from shift 10 on 2022-11-12 08:16:30 ','2022-11-12 08:16:30','',''),('1','293',33,'','20','1',1692393.74,0.00,'Sales from shift 11 on 2022-11-14 09:09:16 ','2022-11-14 09:09:16','',''),('1','293',34,'','6.1','4',0.00,1692393.74,'Sales from shift 11 on 2022-11-14 09:09:16 ','2022-11-14 09:09:16','',''),('1','293',35,'','20','1',1757271.18,0.00,'Sales from shift 12 on 2022-11-15 21:35:02 ','2022-11-15 21:35:02','',''),('1','293',36,'','6.1','4',0.00,1757271.18,'Sales from shift 12 on 2022-11-15 21:35:02 ','2022-11-15 21:35:02','',''),('1','293',37,'','2','6',624200.00,0.00,'Payment Id 14 for invoice:08/09, receipt: 08/09 by AA RANO NIGERIA LTD','2022-11-17 16:57:06','',''),('1','293',38,'','supplier','1',0.00,624200.00,'Payment Id 14 for invoice:08/09, receipt: 08/09 by AA RANO NIGERIA LTD','2022-11-17 16:57:06','',''),('1','293',39,'','2','5',1581480.00,0.00,'Payment Id 13 for invoice:09, receipt: 09 by AA RANO NIGERIA LTD','2022-11-17 16:57:06','',''),('1','293',40,'','supplier','1',0.00,1581480.00,'Payment Id 13 for invoice:09, receipt: 09 by AA RANO NIGERIA LTD','2022-11-17 16:57:06','',''),('1','293',41,'','2','5',1745795.00,0.00,'Payment Id 12 for invoice:08, receipt: 08 by AA RANO NIGERIA LTD','2022-11-17 16:57:06','',''),('1','293',42,'','supplier','1',0.00,1745795.00,'Payment Id 12 for invoice:08, receipt: 08 by AA RANO NIGERIA LTD','2022-11-17 16:57:06','',''),('1','293',43,'','2','6',802278.00,0.00,'Payment Id 11 for invoice:06/07, receipt: 06/07 by AA RANO NIGERIA LTD','2022-11-17 16:57:06','',''),('1','293',44,'','supplier','1',0.00,802278.00,'Payment Id 11 for invoice:06/07, receipt: 06/07 by AA RANO NIGERIA LTD','2022-11-17 16:57:06','',''),('1','293',45,'','2','5',1987045.00,0.00,'Payment Id 10 for invoice:07, receipt: 07 by AA RANO NIGERIA LTD','2022-11-17 16:57:06','',''),('1','293',46,'','supplier','1',0.00,1987045.00,'Payment Id 10 for invoice:07, receipt: 07 by AA RANO NIGERIA LTD','2022-11-17 16:57:06','',''),('1','293',47,'','2','5',20800.00,0.00,'Payment Id 9 for invoice:08, receipt: 088 by AA RANO NIGERIA LTD','2022-11-17 16:57:06','',''),('1','293',48,'','supplier','1',0.00,20800.00,'Payment Id 9 for invoice:08, receipt: 088 by AA RANO NIGERIA LTD','2022-11-17 16:57:06','',''),('1','293',49,'','2','5',1264530.00,0.00,'Payment Id 8 for invoice:08, receipt: 08 by AA RANO NIGERIA LTD','2022-11-17 16:57:06','',''),('1','293',50,'','supplier','1',0.00,1264530.00,'Payment Id 8 for invoice:08, receipt: 08 by AA RANO NIGERIA LTD','2022-11-17 16:57:06','',''),('1','293',51,'','2','6',433580.00,0.00,'Payment Id 7 for invoice:04/05, receipt: 04/05 by AA RANO NIGERIA LTD','2022-11-17 16:57:06','',''),('1','293',52,'','supplier','1',0.00,433580.00,'Payment Id 7 for invoice:04/05, receipt: 04/05 by AA RANO NIGERIA LTD','2022-11-17 16:57:06','',''),('1','293',53,'','2','5',1844670.00,0.00,'Payment Id 6 for invoice:05, receipt: 05 by AA RANO NIGERIA LTD','2022-11-17 16:57:06','',''),('1','293',54,'','supplier','1',0.00,1844670.00,'Payment Id 6 for invoice:05, receipt: 05 by AA RANO NIGERIA LTD','2022-11-17 16:57:06','',''),('1','293',55,'','2','5',1423385.00,0.00,'Payment Id 24 for invoice:13, receipt: 13 by AA RANO NIGERIA LTD','2022-11-17 16:58:39','',''),('1','293',56,'','supplier','1',0.00,1423385.00,'Payment Id 24 for invoice:13, receipt: 13 by AA RANO NIGERIA LTD','2022-11-17 16:58:39','',''),('1','293',57,'','2','5',1608575.00,0.00,'Payment Id 23 for invoice:4, receipt: 044 by AA RANO NIGERIA LTD','2022-11-17 16:58:39','',''),('1','293',58,'','supplier','1',0.00,1608575.00,'Payment Id 23 for invoice:4, receipt: 044 by AA RANO NIGERIA LTD','2022-11-17 16:58:39','',''),('1','293',59,'','2','6',59380.00,0.00,'Payment Id 22 for invoice:02/03, receipt: 00 by AA RANO NIGERIA LTD','2022-11-17 16:58:39','',''),('1','293',60,'','supplier','1',0.00,59380.00,'Payment Id 22 for invoice:02/03, receipt: 00 by AA RANO NIGERIA LTD','2022-11-17 16:58:39','',''),('1','293',61,'','2','5',20000.00,0.00,'Payment Id 21 for invoice:03, receipt: 033 by AA RANO NIGERIA LTD','2022-11-17 16:58:39','',''),('1','293',62,'','supplier','1',0.00,20000.00,'Payment Id 21 for invoice:03, receipt: 033 by AA RANO NIGERIA LTD','2022-11-17 16:58:39','',''),('1','293',63,'','2','5',840040.00,0.00,'Payment Id 19 for invoice:01, receipt: 01 by AA RANO NIGERIA LTD','2022-11-17 16:58:39','',''),('1','293',64,'','supplier','1',0.00,840040.00,'Payment Id 19 for invoice:01, receipt: 01 by AA RANO NIGERIA LTD','2022-11-17 16:58:39','',''),('1','293',65,'','2','5',1134670.00,0.00,'Payment Id 18 for invoice:12, receipt: 12 by AA RANO NIGERIA LTD','2022-11-17 16:58:39','',''),('1','293',66,'','supplier','1',0.00,1134670.00,'Payment Id 18 for invoice:12, receipt: 12 by AA RANO NIGERIA LTD','2022-11-17 16:58:39','',''),('1','293',67,'','2','6',315200.00,0.00,'Payment Id 17 for invoice:10/11, receipt: 10/11 by AA RANO NIGERIA LTD','2022-11-17 16:58:39','',''),('1','293',68,'','supplier','1',0.00,315200.00,'Payment Id 17 for invoice:10/11, receipt: 10/11 by AA RANO NIGERIA LTD','2022-11-17 16:58:39','',''),('1','293',69,'','2','5',1239425.00,0.00,'Payment Id 16 for invoice:11, receipt: 11 by AA RANO NIGERIA LTD','2022-11-17 16:58:39','',''),('1','293',70,'','supplier','1',0.00,1239425.00,'Payment Id 16 for invoice:11, receipt: 11 by AA RANO NIGERIA LTD','2022-11-17 16:58:39','',''),('1','293',71,'','2','5',1448345.00,0.00,'Payment Id 15 for invoice:10/11, receipt: 10/11 by AA RANO NIGERIA LTD','2022-11-17 16:58:39','',''),('1','293',72,'','supplier','1',0.00,1448345.00,'Payment Id 15 for invoice:10/11, receipt: 10/11 by AA RANO NIGERIA LTD','2022-11-17 16:58:39','',''),('1','293',73,'','2','5',1832775.00,0.00,'Payment Id 20 for invoice:03, receipt: 03 by AA RANO NIGERIA LTD','2022-11-17 17:01:26','',''),('1','293',74,'','supplier','1',0.00,1832775.00,'Payment Id 20 for invoice:03, receipt: 03 by AA RANO NIGERIA LTD','2022-11-17 17:01:26','',''),('1','293',75,'','20','1',1643077.06,0.00,'Sales from shift 13 on 2022-11-18 06:27:19 ','2022-11-18 06:27:19','',''),('1','293',76,'','6.1','4',0.00,1643077.06,'Sales from shift 13 on 2022-11-18 06:27:19 ','2022-11-18 06:27:19','',''),('1','293',77,'','20','1',998930.66,0.00,'Sales from shift 14 on 2022-11-23 01:31:04 ','2022-11-23 01:31:04','',''),('1','293',78,'','6.1','4',0.00,998930.66,'Sales from shift 14 on 2022-11-23 01:31:04 ','2022-11-23 01:31:04','',''),('1','293',79,'','20','1',408056.10,0.00,'Sales from shift 15 on 2022-11-24 04:31:02 ','2022-11-24 04:31:02','',''),('1','293',80,'','6.1','4',0.00,408056.10,'Sales from shift 15 on 2022-11-24 04:31:02 ','2022-11-24 04:31:02','',''),('1','293',81,'','24','3',0.00,12600000.00,'Purchase Id 7 for 60,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-24 04:32:47','',''),('1','293',82,'','supplier','1',12600000.00,0.00,'Purchase Id 7 for 60,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-24 04:32:47','',''),('1','293',83,'','24','3',0.00,9450000.00,'Purchase Id 9 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-24 04:33:40','',''),('1','293',84,'','supplier','1',9450000.00,0.00,'Purchase Id 9 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-24 04:33:40','',''),('1','293',85,'','24','3',0.00,9450000.00,'Purchase Id 8 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-24 04:34:45','',''),('1','293',86,'','supplier','1',9450000.00,0.00,'Purchase Id 8 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-24 04:34:45','',''),('1','293',87,'','20','1',1806634.14,0.00,'Sales from shift 16 on 2022-11-24 11:24:08 ','2022-11-24 11:24:08','',''),('1','293',88,'','6.1','4',0.00,1806634.14,'Sales from shift 16 on 2022-11-24 11:24:08 ','2022-11-24 11:24:08','',''),('1','293',89,'','20','1',1813284.22,0.00,'Sales from shift 17 on 2022-11-25 17:26:36 ','2022-11-25 17:26:36','',''),('1','293',90,'','6.1','4',0.00,1813284.22,'Sales from shift 17 on 2022-11-25 17:26:36 ','2022-11-25 17:26:36','',''),('1','293',91,'','20','1',0.00,0.00,'Sales from shift 18 on 2022-11-26 10:04:34 ','2022-11-26 10:04:34','',''),('1','293',92,'','6.1','4',0.00,0.00,'Sales from shift 18 on 2022-11-26 10:04:34 ','2022-11-26 10:04:34','',''),('1','293',93,'','20','1',1803777.24,0.00,'Sales from shift 19 on 2022-11-26 10:14:55 ','2022-11-26 10:14:55','',''),('1','293',94,'','6.1','4',0.00,1803777.24,'Sales from shift 19 on 2022-11-26 10:14:55 ','2022-11-26 10:14:55','',''),('1','293',95,'','20','1',1751612.56,0.00,'Sales from shift 20 on 2022-11-26 10:26:24 ','2022-11-26 10:26:24','',''),('1','293',96,'','6.1','4',0.00,1751612.56,'Sales from shift 20 on 2022-11-26 10:26:24 ','2022-11-26 10:26:24','',''),('1','293',97,'','20','1',1915575.48,0.00,'Sales from shift 21 on 2022-11-26 10:39:20 ','2022-11-26 10:39:20','',''),('1','293',98,'','6.1','4',0.00,1915575.48,'Sales from shift 21 on 2022-11-26 10:39:20 ','2022-11-26 10:39:20','',''),('1','293',99,'','20','1',1720912.90,0.00,'Sales from shift 22 on 2022-11-26 10:49:25 ','2022-11-26 10:49:25','',''),('1','293',100,'','6.1','4',0.00,1720912.90,'Sales from shift 22 on 2022-11-26 10:49:25 ','2022-11-26 10:49:25','',''),('1','293',101,'','20','1',1768025.94,0.00,'Sales from shift 23 on 2022-11-26 10:59:38 ','2022-11-26 10:59:38','',''),('1','293',102,'','6.1','4',0.00,1768025.94,'Sales from shift 23 on 2022-11-26 10:59:38 ','2022-11-26 10:59:38','',''),('1','293',103,'','20','1',1405516.48,0.00,'Sales from shift 24 on 2022-11-26 11:05:25 ','2022-11-26 11:05:25','',''),('1','293',104,'','6.1','4',0.00,1405516.48,'Sales from shift 24 on 2022-11-26 11:05:25 ','2022-11-26 11:05:25','',''),('1','293',105,'','20','1',1739448.04,0.00,'Sales from shift 25 on 2022-11-26 15:17:22 ','2022-11-26 15:17:22','',''),('1','293',106,'','6.1','4',0.00,1739448.04,'Sales from shift 25 on 2022-11-26 15:17:22 ','2022-11-26 15:17:22','',''),('1','293',107,'','20','1',1706938.12,0.00,'Sales from shift 26 on 2022-11-27 09:19:37 ','2022-11-27 09:19:37','',''),('1','293',108,'','6.1','4',0.00,1706938.12,'Sales from shift 26 on 2022-11-27 09:19:37 ','2022-11-27 09:19:37','',''),('1','293',109,'','24','3',0.00,10500000.00,'Purchase Id 10 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-27 14:10:12','',''),('1','293',110,'','supplier','1',10500000.00,0.00,'Purchase Id 10 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-27 14:10:12','',''),('1','293',111,'','20','1',1559119.80,0.00,'Sales from shift 27 on 2022-11-28 13:57:03 ','2022-11-28 13:57:03','',''),('1','293',112,'','6.1','4',0.00,1559119.80,'Sales from shift 27 on 2022-11-28 13:57:03 ','2022-11-28 13:57:03','',''),('1','293',113,'','20','1',1699193.34,0.00,'Sales from shift 28 on 2022-11-30 12:49:24 ','2022-11-30 12:49:24','',''),('1','293',114,'','6.1','4',0.00,1699193.34,'Sales from shift 28 on 2022-11-30 12:49:24 ','2022-11-30 12:49:24','',''),('1','293',115,'','20','1',2235140.66,0.00,'Sales from shift 29 on 2022-11-30 13:06:55 ','2022-11-30 13:06:55','',''),('1','293',116,'','6.1','4',0.00,2235140.66,'Sales from shift 29 on 2022-11-30 13:06:55 ','2022-11-30 13:06:55','',''),('1','293',117,'','20','1',1753271.52,0.00,'Sales from shift 30 on 2022-11-30 15:21:32 ','2022-11-30 15:21:32','',''),('1','293',118,'','6.1','4',0.00,1753271.52,'Sales from shift 30 on 2022-11-30 15:21:32 ','2022-11-30 15:21:32','',''),('1','293',119,'','20','1',225121.94,0.00,'Sales from shift 31 on 2022-12-01 07:38:38 ','2022-12-01 07:38:38','',''),('1','293',120,'','6.1','4',0.00,225121.94,'Sales from shift 31 on 2022-12-01 07:38:38 ','2022-12-01 07:38:38','',''),('1','293',121,'','20','1',3310139.70,0.00,'Sales from shift 32 on 2022-12-01 07:59:38 ','2022-12-01 07:59:38','',''),('1','293',122,'','6.1','4',0.00,3310139.70,'Sales from shift 32 on 2022-12-01 07:59:38 ','2022-12-01 07:59:38','',''),('1','293',123,'','20','1',2465450.40,0.00,'Sales from shift 33 on 2022-12-01 08:10:53 ','2022-12-01 08:10:53','',''),('1','293',124,'','6.1','4',0.00,2465450.40,'Sales from shift 33 on 2022-12-01 08:10:53 ','2022-12-01 08:10:53','',''),('1','293',125,'','20','1',2920747.20,0.00,'Sales from shift 34 on 2022-12-01 08:22:37 ','2022-12-01 08:22:37','',''),('1','293',126,'','6.1','4',0.00,2920747.20,'Sales from shift 34 on 2022-12-01 08:22:37 ','2022-12-01 08:22:37','',''),('1','293',127,'','20','1',1803263.70,0.00,'Sales from shift 35 on 2022-12-01 08:34:51 ','2022-12-01 08:34:51','',''),('1','293',128,'','6.1','4',0.00,1803263.70,'Sales from shift 35 on 2022-12-01 08:34:51 ','2022-12-01 08:34:51','',''),('1','293',129,'','20','1',1842363.60,0.00,'Sales from shift 36 on 2022-12-01 08:52:33 ','2022-12-01 08:52:33','',''),('1','293',130,'','6.1','4',0.00,1842363.60,'Sales from shift 36 on 2022-12-01 08:52:33 ','2022-12-01 08:52:33','',''),('1','293',131,'','20','1',912865.80,0.00,'Sales from shift 37 on 2022-12-01 08:58:52 ','2022-12-01 08:58:52','',''),('1','293',132,'','6.1','4',0.00,912865.80,'Sales from shift 37 on 2022-12-01 08:58:52 ','2022-12-01 08:58:52','',''),('1','293',133,'','20','1',4402158.60,0.00,'Sales from shift 38 on 2022-12-01 09:05:16 ','2022-12-01 09:05:16','',''),('1','293',134,'','6.1','4',0.00,4402158.60,'Sales from shift 38 on 2022-12-01 09:05:16 ','2022-12-01 09:05:16','',''),('1','293',135,'','20','1',3302903.10,0.00,'Sales from shift 39 on 2022-12-01 09:12:05 ','2022-12-01 09:12:05','',''),('1','293',136,'','6.1','4',0.00,3302903.10,'Sales from shift 39 on 2022-12-01 09:12:05 ','2022-12-01 09:12:05','',''),('1','293',137,'','24','3',0.00,3780000.00,'Purchase Id 12 for 18,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-12-01 09:13:23','',''),('1','293',138,'','supplier','1',3780000.00,0.00,'Purchase Id 12 for 18,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-12-01 09:13:23','',''),('1','293',139,'','24','3',0.00,10710000.00,'Purchase Id 11 for 51,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-12-01 09:14:37','',''),('1','293',140,'','supplier','1',10710000.00,0.00,'Purchase Id 11 for 51,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-12-01 09:14:37','',''),('1','293',141,'','20','1',4294760.40,0.00,'Sales from shift 40 on 2022-12-01 09:26:30 ','2022-12-01 09:26:30','',''),('1','293',142,'','6.1','4',0.00,4294760.40,'Sales from shift 40 on 2022-12-01 09:26:30 ','2022-12-01 09:26:30','',''),('1','293',143,'','20','1',4151282.10,0.00,'Sales from shift 41 on 2022-12-01 09:36:56 ','2022-12-01 09:36:56','',''),('1','293',144,'','6.1','4',0.00,4151282.10,'Sales from shift 41 on 2022-12-01 09:36:56 ','2022-12-01 09:36:56','',''),('1','293',145,'','20','1',5281206.00,0.00,'Sales from shift 42 on 2022-12-01 09:43:11 ','2022-12-01 09:43:11','',''),('1','293',146,'','6.1','4',0.00,5281206.00,'Sales from shift 42 on 2022-12-01 09:43:11 ','2022-12-01 09:43:11','',''),('1','293',147,'','20','1',0.00,0.00,'Sales from shift 43 on 2022-12-01 09:48:55 ','2022-12-01 09:48:55','',''),('1','293',148,'','6.1','4',0.00,0.00,'Sales from shift 43 on 2022-12-01 09:48:55 ','2022-12-01 09:48:55','',''),('1','293',149,'','20','1',2899722.00,0.00,'Sales from shift 44 on 2022-12-01 10:01:13 ','2022-12-01 10:01:13','',''),('1','293',150,'','6.1','4',0.00,2899722.00,'Sales from shift 44 on 2022-12-01 10:01:13 ','2022-12-01 10:01:13','',''),('1','293',151,'','20','1',4244373.00,0.00,'Sales from shift 45 on 2022-12-01 10:18:51 ','2022-12-01 10:18:51','',''),('1','293',152,'','6.1','4',0.00,4244373.00,'Sales from shift 45 on 2022-12-01 10:18:51 ','2022-12-01 10:18:51','',''),('1','293',153,'','20','1',3321843.00,0.00,'Sales from shift 46 on 2022-12-01 10:25:57 ','2022-12-01 10:25:57','',''),('1','293',154,'','6.1','4',0.00,3321843.00,'Sales from shift 46 on 2022-12-01 10:25:57 ','2022-12-01 10:25:57','',''),('1','293',155,'','20','1',2659091.40,0.00,'Sales from shift 47 on 2022-12-01 10:30:06 ','2022-12-01 10:30:06','',''),('1','293',156,'','6.1','4',0.00,2659091.40,'Sales from shift 47 on 2022-12-01 10:30:06 ','2022-12-01 10:30:06','',''),('1','293',157,'','20','1',3676732.50,0.00,'Sales from shift 48 on 2022-12-01 10:35:24 ','2022-12-01 10:35:24','',''),('1','293',158,'','6.1','4',0.00,3676732.50,'Sales from shift 48 on 2022-12-01 10:35:24 ','2022-12-01 10:35:24','',''),('1','293',159,'','20','1',2932150.20,0.00,'Sales from shift 49 on 2022-12-01 10:38:40 ','2022-12-01 10:38:40','',''),('1','293',160,'','6.1','4',0.00,2932150.20,'Sales from shift 49 on 2022-12-01 10:38:40 ','2022-12-01 10:38:40','',''),('1','293',161,'','2','5',2781135.00,0.00,'Payment Id 84 for invoice:47, receipt: 047 by AA RANO NIGERIA LTD','2022-12-02 12:12:19','',''),('1','293',162,'','supplier','1',0.00,2781135.00,'Payment Id 84 for invoice:47, receipt: 047 by AA RANO NIGERIA LTD','2022-12-02 12:12:19','',''),('1','293',163,'','2','6',1285512.00,0.00,'Payment Id 83 for invoice:45/46, receipt: 4546 by AA RANO NIGERIA LTD','2022-12-02 12:12:19','',''),('1','293',164,'','supplier','1',0.00,1285512.00,'Payment Id 83 for invoice:45/46, receipt: 4546 by AA RANO NIGERIA LTD','2022-12-02 12:12:19','',''),('1','293',165,'','2','5',2178565.00,0.00,'Payment Id 82 for invoice:46, receipt: 046 by AA RANO NIGERIA LTD','2022-12-02 12:12:19','',''),('1','293',166,'','supplier','1',0.00,2178565.00,'Payment Id 82 for invoice:46, receipt: 046 by AA RANO NIGERIA LTD','2022-12-02 12:12:19','',''),('1','293',167,'','6.1','4',134500.00,0.00,'Payment Id 81 for invoice:45, receipt: 0455 by AA RANO NIGERIA LTD','2022-12-02 12:12:19','',''),('1','293',168,'','supplier','1',0.00,134500.00,'Payment Id 81 for invoice:45, receipt: 0455 by AA RANO NIGERIA LTD','2022-12-02 12:12:19','',''),('1','293',169,'','6.1','4',134500.00,0.00,'Payment Id 80 for invoice:45, receipt: 045 by AA RANO NIGERIA LTD','2022-12-02 12:12:19','',''),('1','293',170,'','supplier','1',0.00,134500.00,'Payment Id 80 for invoice:45, receipt: 045 by AA RANO NIGERIA LTD','2022-12-02 12:12:19','',''),('1','293',171,'','2','6',897712.00,0.00,'Payment Id 78 for invoice:44, receipt: 0411 by AA RANO NIGERIA LTD','2022-12-02 12:12:19','',''),('1','293',172,'','supplier','1',0.00,897712.00,'Payment Id 78 for invoice:44, receipt: 0411 by AA RANO NIGERIA LTD','2022-12-02 12:12:19','',''),('1','293',173,'','2','5',3839800.00,0.00,'Payment Id 77 for invoice:44, receipt: 0444 by AA RANO NIGERIA LTD','2022-12-02 12:12:19','',''),('1','293',174,'','supplier','1',0.00,3839800.00,'Payment Id 77 for invoice:44, receipt: 0444 by AA RANO NIGERIA LTD','2022-12-02 12:12:19','',''),('1','293',175,'','2','5',2406590.00,0.00,'Payment Id 76 for invoice:43, receipt: 043 by AA RANO NIGERIA LTD','2022-12-02 12:12:19','',''),('1','293',176,'','supplier','1',0.00,2406590.00,'Payment Id 76 for invoice:43, receipt: 043 by AA RANO NIGERIA LTD','2022-12-02 12:12:19','',''),('1','293',177,'','2','6',842290.00,0.00,'Payment Id 25 for invoice:12/13, receipt: 12/13 by AA RANO NIGERIA LTD','2022-12-02 12:12:56','',''),('1','293',178,'','supplier','1',0.00,842290.00,'Payment Id 25 for invoice:12/13, receipt: 12/13 by AA RANO NIGERIA LTD','2022-12-02 12:12:56','',''),('1','293',179,'','2','6',625860.00,0.00,'Payment Id 36 for invoice:20/21, receipt: 0022 by AA RANO NIGERIA LTD','2022-12-02 12:14:37','',''),('1','293',180,'','supplier','1',0.00,625860.00,'Payment Id 36 for invoice:20/21, receipt: 0022 by AA RANO NIGERIA LTD','2022-12-02 12:14:37','',''),('1','293',181,'','2','5',1471250.00,0.00,'Payment Id 35 for invoice:21, receipt: 021 by AA RANO NIGERIA LTD','2022-12-02 12:14:37','',''),('1','293',182,'','supplier','1',0.00,1471250.00,'Payment Id 35 for invoice:21, receipt: 021 by AA RANO NIGERIA LTD','2022-12-02 12:14:37','',''),('1','293',183,'','2','5',1570135.00,0.00,'Payment Id 34 for invoice:20, receipt: 020 by AA RANO NIGERIA LTD','2022-12-02 12:14:37','',''),('1','293',184,'','supplier','1',0.00,1570135.00,'Payment Id 34 for invoice:20, receipt: 020 by AA RANO NIGERIA LTD','2022-12-02 12:14:37','',''),('1','293',185,'','2','5',1643940.00,0.00,'Payment Id 32 for invoice:19, receipt: 019 by AA RANO NIGERIA LTD','2022-12-02 12:14:37','',''),('1','293',186,'','supplier','1',0.00,1643940.00,'Payment Id 32 for invoice:19, receipt: 019 by AA RANO NIGERIA LTD','2022-12-02 12:14:37','',''),('1','293',187,'','2','5',1017785.00,0.00,'Payment Id 30 for invoice:17, receipt: 017 by AA RANO NIGERIA LTD','2022-12-02 12:14:37','',''),('1','293',188,'','supplier','1',0.00,1017785.00,'Payment Id 30 for invoice:17, receipt: 017 by AA RANO NIGERIA LTD','2022-12-02 12:14:37','',''),('1','293',189,'','2','5',1621495.00,0.00,'Payment Id 29 for invoice:16, receipt: 016 by AA RANO NIGERIA LTD','2022-12-02 12:14:37','',''),('1','293',190,'','supplier','1',0.00,1621495.00,'Payment Id 29 for invoice:16, receipt: 016 by AA RANO NIGERIA LTD','2022-12-02 12:14:37','',''),('1','293',191,'','2','5',375060.00,0.00,'Payment Id 27 for invoice:15, receipt: 0012 by AA RANO NIGERIA LTD','2022-12-02 12:14:37','',''),('1','293',192,'','supplier','1',0.00,375060.00,'Payment Id 27 for invoice:15, receipt: 0012 by AA RANO NIGERIA LTD','2022-12-02 12:14:37','',''),('1','293',193,'','2','5',466430.00,0.00,'Payment Id 26 for invoice:14, receipt: 0000 by AA RANO NIGERIA LTD','2022-12-02 12:14:37','',''),('1','293',194,'','supplier','1',0.00,466430.00,'Payment Id 26 for invoice:14, receipt: 0000 by AA RANO NIGERIA LTD','2022-12-02 12:14:37','',''),('1','293',195,'','2','5',1200165.00,0.00,'Payment Id 44 for invoice:27, receipt: 027 by AA RANO NIGERIA LTD','2022-12-02 12:16:41','',''),('1','293',196,'','supplier','1',0.00,1200165.00,'Payment Id 44 for invoice:27, receipt: 027 by AA RANO NIGERIA LTD','2022-12-02 12:16:41','',''),('1','293',197,'','2','5',724330.00,0.00,'Payment Id 43 for invoice:26, receipt: 26 by AA RANO NIGERIA LTD','2022-12-02 12:16:41','',''),('1','293',198,'','supplier','1',0.00,724330.00,'Payment Id 43 for invoice:26, receipt: 26 by AA RANO NIGERIA LTD','2022-12-02 12:16:41','',''),('1','293',199,'','2','6',528200.00,0.00,'Payment Id 42 for invoice:24/25, receipt: 2425 by AA RANO NIGERIA LTD','2022-12-02 12:16:41','',''),('1','293',200,'','supplier','1',0.00,528200.00,'Payment Id 42 for invoice:24/25, receipt: 2425 by AA RANO NIGERIA LTD','2022-12-02 12:16:41','',''),('1','293',201,'','2','5',1528350.00,0.00,'Payment Id 41 for invoice:25, receipt: 025 by AA RANO NIGERIA LTD','2022-12-02 12:16:41','',''),('1','293',202,'','supplier','1',0.00,1528350.00,'Payment Id 41 for invoice:25, receipt: 025 by AA RANO NIGERIA LTD','2022-12-02 12:16:41','',''),('1','293',203,'','2','5',1088525.00,0.00,'Payment Id 40 for invoice:24, receipt: 24 by AA RANO NIGERIA LTD','2022-12-02 12:16:41','',''),('1','293',204,'','supplier','1',0.00,1088525.00,'Payment Id 40 for invoice:24, receipt: 24 by AA RANO NIGERIA LTD','2022-12-02 12:16:41','',''),('1','293',205,'','2','6',397500.00,0.00,'Payment Id 39 for invoice:22/23, receipt: 2223 by AA RANO NIGERIA LTD','2022-12-02 12:16:41','',''),('1','293',206,'','supplier','1',0.00,397500.00,'Payment Id 39 for invoice:22/23, receipt: 2223 by AA RANO NIGERIA LTD','2022-12-02 12:16:41','',''),('1','293',207,'','2','5',1508540.00,0.00,'Payment Id 38 for invoice:23, receipt: 023 by AA RANO NIGERIA LTD','2022-12-02 12:16:41','',''),('1','293',208,'','supplier','1',0.00,1508540.00,'Payment Id 38 for invoice:23, receipt: 023 by AA RANO NIGERIA LTD','2022-12-02 12:16:41','',''),('1','293',209,'','2','5',1270785.00,0.00,'Payment Id 37 for invoice:22, receipt: 22 by AA RANO NIGERIA LTD','2022-12-02 12:16:41','',''),('1','293',210,'','supplier','1',0.00,1270785.00,'Payment Id 37 for invoice:22, receipt: 22 by AA RANO NIGERIA LTD','2022-12-02 12:16:41','',''),('1','293',211,'','2','5',1086895.00,0.00,'Payment Id 57 for invoice:33, receipt: 33 by AA RANO NIGERIA LTD','2022-12-02 12:18:06','',''),('1','293',212,'','supplier','1',0.00,1086895.00,'Payment Id 57 for invoice:33, receipt: 33 by AA RANO NIGERIA LTD','2022-12-02 12:18:06','',''),('1','293',213,'','2','5',2843840.00,0.00,'Payment Id 55 for invoice:32, receipt: 032 by AA RANO NIGERIA LTD','2022-12-02 12:18:06','',''),('1','293',214,'','supplier','1',0.00,2843840.00,'Payment Id 55 for invoice:32, receipt: 032 by AA RANO NIGERIA LTD','2022-12-02 12:18:06','',''),('1','293',215,'','2','6',355800.00,0.00,'Payment Id 54 for invoice:30/31, receipt: 30311 by AA RANO NIGERIA LTD','2022-12-02 12:18:06','',''),('1','293',216,'','supplier','1',0.00,355800.00,'Payment Id 54 for invoice:30/31, receipt: 30311 by AA RANO NIGERIA LTD','2022-12-02 12:18:06','',''),('1','293',217,'','2','5',46000.00,0.00,'Payment Id 53 for invoice:31, receipt: 031 by AA RANO NIGERIA LTD','2022-12-02 12:18:06','',''),('1','293',218,'','supplier','1',0.00,46000.00,'Payment Id 53 for invoice:31, receipt: 031 by AA RANO NIGERIA LTD','2022-12-02 12:18:06','',''),('1','293',219,'','2','5',1677950.00,0.00,'Payment Id 52 for invoice:30, receipt: 030 by AA RANO NIGERIA LTD','2022-12-02 12:18:06','',''),('1','293',220,'','supplier','1',0.00,1677950.00,'Payment Id 52 for invoice:30, receipt: 030 by AA RANO NIGERIA LTD','2022-12-02 12:18:06','',''),('1','293',221,'','2','6',726700.00,0.00,'Payment Id 51 for invoice:28/29, receipt: 28299 by AA RANO NIGERIA LTD','2022-12-02 12:18:06','',''),('1','293',222,'','supplier','1',0.00,726700.00,'Payment Id 51 for invoice:28/29, receipt: 28299 by AA RANO NIGERIA LTD','2022-12-02 12:18:06','',''),('1','293',223,'','2','5',1256470.00,0.00,'Payment Id 50 for invoice:29, receipt: 029 by AA RANO NIGERIA LTD','2022-12-02 12:18:06','',''),('1','293',224,'','supplier','1',0.00,1256470.00,'Payment Id 50 for invoice:29, receipt: 029 by AA RANO NIGERIA LTD','2022-12-02 12:18:06','',''),('1','293',225,'','2','5',1501310.00,0.00,'Payment Id 49 for invoice:28, receipt: 028 by AA RANO NIGERIA LTD','2022-12-02 12:18:06','',''),('1','293',226,'','supplier','1',0.00,1501310.00,'Payment Id 49 for invoice:28, receipt: 028 by AA RANO NIGERIA LTD','2022-12-02 12:18:06','',''),('1','293',227,'','6.1','4',133750.00,0.00,'Payment Id 67 for invoice:38, receipt: 038 by AA RANO NIGERIA LTD','2022-12-02 12:19:16','',''),('1','293',228,'','supplier','1',0.00,133750.00,'Payment Id 67 for invoice:38, receipt: 038 by AA RANO NIGERIA LTD','2022-12-02 12:19:16','',''),('1','293',229,'','6.1','4',133750.00,0.00,'Payment Id 66 for invoice:38, receipt: 038 by AA RANO NIGERIA LTD','2022-12-02 12:19:16','',''),('1','293',230,'','supplier','1',0.00,133750.00,'Payment Id 66 for invoice:38, receipt: 038 by AA RANO NIGERIA LTD','2022-12-02 12:19:16','',''),('1','293',231,'','2','5',3651700.00,0.00,'Payment Id 65 for invoice:38, receipt: 038 by AA RANO NIGERIA LTD','2022-12-02 12:19:16','',''),('1','293',232,'','supplier','1',0.00,3651700.00,'Payment Id 65 for invoice:38, receipt: 038 by AA RANO NIGERIA LTD','2022-12-02 12:19:16','',''),('1','293',233,'','2','5',1645740.00,0.00,'Payment Id 62 for invoice:36, receipt: 036 by AA RANO NIGERIA LTD','2022-12-02 12:19:16','',''),('1','293',234,'','supplier','1',0.00,1645740.00,'Payment Id 62 for invoice:36, receipt: 036 by AA RANO NIGERIA LTD','2022-12-02 12:19:16','',''),('1','293',235,'','2','5',1142300.00,0.00,'Payment Id 61 for invoice:35, receipt: 035 by AA RANO NIGERIA LTD','2022-12-02 12:19:16','',''),('1','293',236,'','supplier','1',0.00,1142300.00,'Payment Id 61 for invoice:35, receipt: 035 by AA RANO NIGERIA LTD','2022-12-02 12:19:16','',''),('1','293',237,'','2','5',2664895.00,0.00,'Payment Id 59 for invoice:34, receipt: 034 by AA RANO NIGERIA LTD','2022-12-02 12:19:16','',''),('1','293',238,'','supplier','1',0.00,2664895.00,'Payment Id 59 for invoice:34, receipt: 034 by AA RANO NIGERIA LTD','2022-12-02 12:19:16','',''),('1','293',239,'','6.1','4',505000.00,0.00,'Payment Id 58 for invoice:33, receipt: 0344 by AA RANO NIGERIA LTD','2022-12-02 12:19:16','',''),('1','293',240,'','supplier','1',0.00,505000.00,'Payment Id 58 for invoice:33, receipt: 0344 by AA RANO NIGERIA LTD','2022-12-02 12:19:16','',''),('1','293',241,'','2','5',4856460.00,0.00,'Payment Id 74 for invoice:42, receipt: 042 by AA RANO NIGERIA LTD','2022-12-02 12:22:14','',''),('1','293',242,'','supplier','1',0.00,4856460.00,'Payment Id 74 for invoice:42, receipt: 042 by AA RANO NIGERIA LTD','2022-12-02 12:22:14','',''),('1','293',243,'','2','5',3700440.00,0.00,'Payment Id 73 for invoice:41, receipt: 041 by AA RANO NIGERIA LTD','2022-12-02 12:22:14','',''),('1','293',244,'','supplier','1',0.00,3700440.00,'Payment Id 73 for invoice:41, receipt: 041 by AA RANO NIGERIA LTD','2022-12-02 12:22:14','',''),('1','293',245,'','6.1','4',94000.00,0.00,'Payment Id 71 for invoice:40, receipt: 040 by AA RANO NIGERIA LTD','2022-12-02 12:22:14','',''),('1','293',246,'','supplier','1',0.00,94000.00,'Payment Id 71 for invoice:40, receipt: 040 by AA RANO NIGERIA LTD','2022-12-02 12:22:14','',''),('1','293',247,'','2','5',3876600.00,0.00,'Payment Id 70 for invoice:40, receipt: 040 by AA RANO NIGERIA LTD','2022-12-02 12:22:14','',''),('1','293',248,'','supplier','1',0.00,3876600.00,'Payment Id 70 for invoice:40, receipt: 040 by AA RANO NIGERIA LTD','2022-12-02 12:22:14','',''),('1','293',249,'','2','5',2429200.00,0.00,'Payment Id 69 for invoice:39, receipt: 039 by AA RANO NIGERIA LTD','2022-12-02 12:22:14','',''),('1','293',250,'','supplier','1',0.00,2429200.00,'Payment Id 69 for invoice:39, receipt: 039 by AA RANO NIGERIA LTD','2022-12-02 12:22:14','',''),('1','293',251,'','2','5',512890.00,0.00,'Payment Id 68 for invoice:37/38, receipt: 3738 by AA RANO NIGERIA LTD','2022-12-02 12:22:14','',''),('1','293',252,'','supplier','1',0.00,512890.00,'Payment Id 68 for invoice:37/38, receipt: 3738 by AA RANO NIGERIA LTD','2022-12-02 12:22:14','',''),('1','293',253,'','2','5',16500.00,0.00,'Payment Id 47 for invoice:27, receipt: 0277 by AA RANO NIGERIA LTD','2022-12-02 12:23:18','',''),('1','293',254,'','supplier','1',0.00,16500.00,'Payment Id 47 for invoice:27, receipt: 0277 by AA RANO NIGERIA LTD','2022-12-02 12:23:18','',''),('1','293',255,'','2','6',955302.00,0.00,'Payment Id 33 for invoice:16/17, receipt: 16 by AA RANO NIGERIA LTD','2022-12-02 12:25:37','',''),('1','293',256,'','supplier','1',0.00,955302.00,'Payment Id 33 for invoice:16/17, receipt: 16 by AA RANO NIGERIA LTD','2022-12-02 12:25:37','',''),('1','293',257,'','2','6',67500.00,0.00,'Payment Id 28 for invoice:16/15, receipt: 123 by AA RANO NIGERIA LTD','2022-12-02 12:25:37','',''),('1','293',258,'','supplier','1',0.00,67500.00,'Payment Id 28 for invoice:16/15, receipt: 123 by AA RANO NIGERIA LTD','2022-12-02 12:25:37','',''),('1','293',259,'','2','6',847468.00,0.00,'Payment Id 63 for invoice:35/36, receipt: 3536 by AA RANO NIGERIA LTD','2022-12-02 12:28:02','',''),('1','293',260,'','supplier','1',0.00,847468.00,'Payment Id 63 for invoice:35/36, receipt: 3536 by AA RANO NIGERIA LTD','2022-12-02 12:28:02','',''),('1','293',261,'','2','6',157700.00,0.00,'Payment Id 56 for invoice:33, receipt: 0333 by AA RANO NIGERIA LTD','2022-12-02 12:28:02','',''),('1','293',262,'','supplier','1',0.00,157700.00,'Payment Id 56 for invoice:33, receipt: 0333 by AA RANO NIGERIA LTD','2022-12-02 12:28:02','',''),('1','293',263,'','2','6',1246076.00,0.00,'Payment Id 48 for invoice:26/277, receipt: 26277 by AA RANO NIGERIA LTD','2022-12-02 12:28:02','',''),('1','293',264,'','supplier','1',0.00,1246076.00,'Payment Id 48 for invoice:26/277, receipt: 26277 by AA RANO NIGERIA LTD','2022-12-02 12:28:02','',''),('1','293',265,'','2','5',462300.00,0.00,'Payment Id 91 for invoice:50, receipt: 1633834 by AA RANO NIGERIA LTD','2022-12-06 12:30:52','',''),('1','293',266,'','supplier','1',0.00,462300.00,'Payment Id 91 for invoice:50, receipt: 1633834 by AA RANO NIGERIA LTD','2022-12-06 12:30:52','',''),('1','293',267,'','2','5',206000.00,0.00,'Payment Id 90 for invoice:0000, receipt: 1633835 by AA RANO NIGERIA LTD','2022-12-06 12:30:52','',''),('1','293',268,'','supplier','1',0.00,206000.00,'Payment Id 90 for invoice:0000, receipt: 1633835 by AA RANO NIGERIA LTD','2022-12-06 12:30:52','',''),('1','293',269,'','2','5',2799590.00,0.00,'Payment Id 89 for invoice:49, receipt: 00499 by AA RANO NIGERIA LTD','2022-12-06 12:30:52','',''),('1','293',270,'','supplier','1',0.00,2799590.00,'Payment Id 89 for invoice:49, receipt: 00499 by AA RANO NIGERIA LTD','2022-12-06 12:30:52','',''),('1','293',271,'','2','5',36100.00,0.00,'Payment Id 88 for invoice:49, receipt: 0499 by AA RANO NIGERIA LTD','2022-12-06 12:30:52','',''),('1','293',272,'','supplier','1',0.00,36100.00,'Payment Id 88 for invoice:49, receipt: 0499 by AA RANO NIGERIA LTD','2022-12-06 12:30:52','',''),('1','293',273,'','2','5',18210.00,0.00,'Payment Id 87 for invoice:47, receipt: 0477 by AA RANO NIGERIA LTD','2022-12-06 12:30:52','',''),('1','293',274,'','supplier','1',0.00,18210.00,'Payment Id 87 for invoice:47, receipt: 0477 by AA RANO NIGERIA LTD','2022-12-06 12:30:52','',''),('1','293',275,'','2','5',2229730.00,0.00,'Payment Id 86 for invoice:47, receipt: 0047 by AA RANO NIGERIA LTD','2022-12-06 12:30:52','',''),('1','293',276,'','supplier','1',0.00,2229730.00,'Payment Id 86 for invoice:47, receipt: 0047 by AA RANO NIGERIA LTD','2022-12-06 12:30:52','',''),('1','293',277,'','2','6',875800.00,0.00,'Payment Id 75 for invoice:41/42, receipt: 4142 by AA RANO NIGERIA LTD','2022-12-06 12:36:44','',''),('1','293',278,'','supplier','1',0.00,875800.00,'Payment Id 75 for invoice:41/42, receipt: 4142 by AA RANO NIGERIA LTD','2022-12-06 12:36:44','',''),('1','293',279,'','2','6',1170300.00,0.00,'Payment Id 72 for invoice:39/40, receipt: 3940 by AA RANO NIGERIA LTD','2022-12-06 12:36:44','',''),('1','293',280,'','supplier','1',0.00,1170300.00,'Payment Id 72 for invoice:39/40, receipt: 3940 by AA RANO NIGERIA LTD','2022-12-06 12:36:44','',''),('1','293',281,'','2','6',1118790.00,0.00,'Payment Id 60 for invoice:33/34, receipt: 3334 by AA RANO NIGERIA LTD','2022-12-06 12:36:44','',''),('1','293',282,'','supplier','1',0.00,1118790.00,'Payment Id 60 for invoice:33/34, receipt: 3334 by AA RANO NIGERIA LTD','2022-12-06 12:36:44','',''),('1','293',283,'','2','6',235523.00,0.00,'Payment Id 94 for invoice:51, receipt: 00777 by AA RANO NIGERIA LTD','2022-12-12 14:12:23','',''),('1','293',284,'','supplier','1',0.00,235523.00,'Payment Id 94 for invoice:51, receipt: 00777 by AA RANO NIGERIA LTD','2022-12-12 14:12:23','',''),('1','293',285,'','6.1','4',840000.00,0.00,'Payment Id 93 for invoice:50, receipt: 0500 by AA RANO NIGERIA LTD','2022-12-12 14:12:23','',''),('1','293',286,'','supplier','1',0.00,840000.00,'Payment Id 93 for invoice:50, receipt: 0500 by AA RANO NIGERIA LTD','2022-12-12 14:12:23','',''),('1','293',287,'','2','5',883590.00,0.00,'Payment Id 64 for invoice:37, receipt: 037 by AA RANO NIGERIA LTD','2022-12-12 14:19:01','',''),('1','293',288,'','supplier','1',0.00,883590.00,'Payment Id 64 for invoice:37, receipt: 037 by AA RANO NIGERIA LTD','2022-12-12 14:19:01','',''),('1','293',289,'','24','3',0.00,10350000.00,'Purchase Id 13 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-12-15 21:20:00','',''),('1','293',290,'','supplier','1',10350000.00,0.00,'Purchase Id 13 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-12-15 21:20:00','',''),('1','293',291,'','20','1',2026294.20,0.00,'Sales from shift 50 on 2022-12-15 21:49:27 ','2022-12-15 21:49:27','',''),('1','293',292,'','6.1','4',0.00,2026294.20,'Sales from shift 50 on 2022-12-15 21:49:27 ','2022-12-15 21:49:27','',''),('1','293',293,'','20','1',0.00,0.00,'Sales from shift 51 on 2022-12-16 15:16:39 ','2022-12-16 15:16:39','',''),('1','293',294,'','6.1','4',0.00,0.00,'Sales from shift 51 on 2022-12-16 15:16:39 ','2022-12-16 15:16:39','',''),('1','293',295,'','20','1',236049.00,0.00,'Sales from shift 52 on 2022-12-17 00:18:38 ','2022-12-17 00:18:38','',''),('1','293',296,'','6.1','4',0.00,236049.00,'Sales from shift 52 on 2022-12-17 00:18:38 ','2022-12-17 00:18:38','',''),('1','293',297,'','6.1','4',133000.00,0.00,'Payment Id 99 for invoice:53, receipt: 053 by AA RANO NIGERIA LTD','2022-12-17 13:23:45','',''),('1','293',298,'','supplier','1',0.00,133000.00,'Payment Id 99 for invoice:53, receipt: 053 by AA RANO NIGERIA LTD','2022-12-17 13:23:45','',''),('1','293',299,'','2','5',300000.00,0.00,'Payment Id 96 for invoice:000234, receipt: 2093803 by AA RANO NIGERIA LTD','2022-12-17 13:23:45','',''),('1','293',300,'','supplier','1',0.00,300000.00,'Payment Id 96 for invoice:000234, receipt: 2093803 by AA RANO NIGERIA LTD','2022-12-17 13:23:45','',''),('1','293',301,'','2','5',79000.00,0.00,'Payment Id 46 for invoice:26, receipt: 0266 by AA RANO NIGERIA LTD','2022-12-17 13:23:45','',''),('1','293',302,'','supplier','1',0.00,79000.00,'Payment Id 46 for invoice:26, receipt: 0266 by AA RANO NIGERIA LTD','2022-12-17 13:23:45','',''),('1','293',303,'','20','1',2681294.00,0.00,'Sales from shift 53 on 2022-12-17 14:58:29 ','2022-12-17 14:58:29','',''),('1','293',304,'','6.1','4',0.00,2681294.00,'Sales from shift 53 on 2022-12-17 14:58:29 ','2022-12-17 14:58:29','',''),('1','293',305,'','20','1',3430801.90,0.00,'Sales from shift 54 on 2022-12-17 15:34:33 ','2022-12-17 15:34:33','',''),('1','293',306,'','6.1','4',0.00,3430801.90,'Sales from shift 54 on 2022-12-17 15:34:33 ','2022-12-17 15:34:33','',''),('1','293',307,'','20','1',3288151.30,0.00,'Sales from shift 55 on 2022-12-17 15:40:26 ','2022-12-17 15:40:26','',''),('1','293',308,'','6.1','4',0.00,3288151.30,'Sales from shift 55 on 2022-12-17 15:40:26 ','2022-12-17 15:40:26','',''),('1','293',309,'','20','1',1397178.70,0.00,'Sales from shift 56 on 2022-12-18 21:05:39 ','2022-12-18 21:05:39','',''),('1','293',310,'','6.1','4',0.00,1397178.70,'Sales from shift 56 on 2022-12-18 21:05:39 ','2022-12-18 21:05:39','',''),('1','293',311,'','24','3',0.00,4140000.00,'Purchase Id 14 for 18,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-12-20 05:28:40','',''),('1','293',312,'','supplier','1',4140000.00,0.00,'Purchase Id 14 for 18,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-12-20 05:28:40','',''),('1','293',313,'','20','1',2825441.90,0.00,'Sales from shift 57 on 2022-12-21 07:56:24 ','2022-12-21 07:56:24','',''),('1','293',314,'','6.1','4',0.00,2825441.90,'Sales from shift 57 on 2022-12-21 07:56:24 ','2022-12-21 07:56:24','',''),('1','293',315,'','2','5',2671540.00,0.00,'Payment Id 105 for invoice:57, receipt: 057 by AA RANO NIGERIA LTD','2022-12-21 10:50:47','',''),('1','293',316,'','supplier','1',0.00,2671540.00,'Payment Id 105 for invoice:57, receipt: 057 by AA RANO NIGERIA LTD','2022-12-21 10:50:47','',''),('1','293',317,'','2','5',1032210.00,0.00,'Payment Id 104 for invoice:56, receipt: 056 by AA RANO NIGERIA LTD','2022-12-21 10:50:47','',''),('1','293',318,'','supplier','1',0.00,1032210.00,'Payment Id 104 for invoice:56, receipt: 056 by AA RANO NIGERIA LTD','2022-12-21 10:50:47','',''),('1','293',319,'','2','5',2825790.00,0.00,'Payment Id 100 for invoice:54, receipt: 054 by AA RANO NIGERIA LTD','2022-12-21 10:50:47','',''),('1','293',320,'','supplier','1',0.00,2825790.00,'Payment Id 100 for invoice:54, receipt: 054 by AA RANO NIGERIA LTD','2022-12-21 10:50:47','',''),('1','293',321,'','2','5',2548280.00,0.00,'Payment Id 98 for invoice:53, receipt: 053 by AA RANO NIGERIA LTD','2022-12-21 10:50:47','',''),('1','293',322,'','supplier','1',0.00,2548280.00,'Payment Id 98 for invoice:53, receipt: 053 by AA RANO NIGERIA LTD','2022-12-21 10:50:47','',''),('1','293',323,'','24','3',0.00,10350000.00,'Purchase Id 15 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-12-23 13:08:14','',''),('1','293',324,'','supplier','1',10350000.00,0.00,'Purchase Id 15 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-12-23 13:08:14','',''),('1','293',325,'','20','1',3724916.70,0.00,'Sales from shift 58 on 2022-12-24 06:56:37 ','2022-12-24 06:56:37','',''),('1','293',326,'','6.1','4',0.00,3724916.70,'Sales from shift 58 on 2022-12-24 06:56:37 ','2022-12-24 06:56:37','',''),('1','293',327,'','20','1',2238748.80,0.00,'Sales from shift 59 on 2022-12-24 23:11:25 ','2022-12-24 23:11:25','',''),('1','293',328,'','6.1','4',0.00,2238748.80,'Sales from shift 59 on 2022-12-24 23:11:25 ','2022-12-24 23:11:25','',''),('1','293',329,'','20','1',1886966.40,0.00,'Sales from shift 60 on 2022-12-25 22:10:44 ','2022-12-25 22:10:44','',''),('1','293',330,'','6.1','4',0.00,1886966.40,'Sales from shift 60 on 2022-12-25 22:10:44 ','2022-12-25 22:10:44','',''),('1','293',331,'','2','5',518900.00,0.00,'Payment Id 106 for invoice:57/56, receipt: 5756 by AA RANO NIGERIA LTD','2022-12-26 09:45:22','',''),('1','293',332,'','supplier','1',0.00,518900.00,'Payment Id 106 for invoice:57/56, receipt: 5756 by AA RANO NIGERIA LTD','2022-12-26 09:45:22','',''),('1','293',333,'','2','5',1081880.00,0.00,'Payment Id 103 for invoice:55/54, receipt: 5554 by AA RANO NIGERIA LTD','2022-12-26 09:45:22','',''),('1','293',334,'','supplier','1',0.00,1081880.00,'Payment Id 103 for invoice:55/54, receipt: 5554 by AA RANO NIGERIA LTD','2022-12-26 09:45:22','',''),('1','293',335,'','2','5',2811270.00,0.00,'Payment Id 102 for invoice:55, receipt: 055 by AA RANO NIGERIA LTD','2022-12-26 09:45:22','',''),('1','293',336,'','supplier','1',0.00,2811270.00,'Payment Id 102 for invoice:55, receipt: 055 by AA RANO NIGERIA LTD','2022-12-26 09:45:22','',''),('1','293',337,'','2','6',967070.00,0.00,'Payment Id 97 for invoice:47/49, receipt: 0001230 by AA RANO NIGERIA LTD','2022-12-26 09:45:22','',''),('1','293',338,'','supplier','1',0.00,967070.00,'Payment Id 97 for invoice:47/49, receipt: 0001230 by AA RANO NIGERIA LTD','2022-12-26 09:45:22','',''),('1','293',339,'','2','6',724000.00,0.00,'Payment Id 92 for invoice:50, receipt: 5000 by AA RANO NIGERIA LTD','2022-12-26 09:45:22','',''),('1','293',340,'','supplier','1',0.00,724000.00,'Payment Id 92 for invoice:50, receipt: 5000 by AA RANO NIGERIA LTD','2022-12-26 09:45:22','',''),('1','293',341,'','2','5',240200.00,0.00,'Payment Id 101 for invoice:055, receipt: 0555 by AA RANO NIGERIA LTD','2022-12-26 09:46:20','',''),('1','293',342,'','supplier','1',0.00,240200.00,'Payment Id 101 for invoice:055, receipt: 0555 by AA RANO NIGERIA LTD','2022-12-26 09:46:20','',''),('1','293',343,'','2','5',1000000.00,0.00,'Payment Id 95 for invoice:00100, receipt: 1004105 by AA RANO NIGERIA LTD','2022-12-26 10:01:54','',''),('1','293',344,'','supplier','1',0.00,1000000.00,'Payment Id 95 for invoice:00100, receipt: 1004105 by AA RANO NIGERIA LTD','2022-12-26 10:01:54','',''),('1','293',345,'','2','5',917200.00,0.00,'Payment Id 113 for invoice:60, receipt: 0600 by AA RANO NIGERIA LTD','2022-12-29 16:21:23','',''),('1','293',346,'','supplier','1',0.00,917200.00,'Payment Id 113 for invoice:60, receipt: 0600 by AA RANO NIGERIA LTD','2022-12-29 16:21:23','',''),('1','293',347,'','2','5',2174060.00,0.00,'Payment Id 111 for invoice:59, receipt: 2093816 by AA RANO NIGERIA LTD','2022-12-29 16:21:23','',''),('1','293',348,'','supplier','1',0.00,2174060.00,'Payment Id 111 for invoice:59, receipt: 2093816 by AA RANO NIGERIA LTD','2022-12-29 16:21:23','',''),('1','293',349,'','6.1','4',133000.00,0.00,'Payment Id 109 for invoice:58, receipt: 05888 by AA RANO NIGERIA LTD','2022-12-29 16:21:23','',''),('1','293',350,'','supplier','1',0.00,133000.00,'Payment Id 109 for invoice:58, receipt: 05888 by AA RANO NIGERIA LTD','2022-12-29 16:21:23','',''),('1','293',351,'','2','5',2713600.00,0.00,'Payment Id 107 for invoice:58, receipt: 058 by AA RANO NIGERIA LTD','2022-12-29 16:21:23','',''),('1','293',352,'','supplier','1',0.00,2713600.00,'Payment Id 107 for invoice:58, receipt: 058 by AA RANO NIGERIA LTD','2022-12-29 16:21:23','',''),('1','293',353,'','20','1',917479.20,0.00,'Sales from shift 61 on 2022-12-31 06:59:30 ','2022-12-31 06:59:30','',''),('1','293',354,'','6.1','4',0.00,917479.20,'Sales from shift 61 on 2022-12-31 06:59:30 ','2022-12-31 06:59:30','',''),('1','293',355,'','20','1',2441904.00,0.00,'Sales from shift 62 on 2023-01-05 05:08:26 ','2023-01-05 05:08:26','',''),('1','293',356,'','6.1','4',0.00,2441904.00,'Sales from shift 62 on 2023-01-05 05:08:26 ','2023-01-05 05:08:26','',''),('1','293',357,'','2','5',1643000.00,0.00,'Payment Id 117 for invoice:62, receipt: 0622 by AA RANO NIGERIA LTD','2023-01-05 11:16:14','',''),('1','293',358,'','supplier','1',0.00,1643000.00,'Payment Id 117 for invoice:62, receipt: 0622 by AA RANO NIGERIA LTD','2023-01-05 11:16:14','',''),('1','293',359,'','2','6',900000.00,0.00,'Payment Id 115 for invoice:61, receipt: 0611 by AA RANO NIGERIA LTD','2023-01-05 11:16:14','',''),('1','293',360,'','supplier','1',0.00,900000.00,'Payment Id 115 for invoice:61, receipt: 0611 by AA RANO NIGERIA LTD','2023-01-05 11:16:14','',''),('1','293',361,'','2','6',877250.00,0.00,'Payment Id 112 for invoice:58/59, receipt: 5859 by AA RANO NIGERIA LTD','2023-01-05 11:16:14','',''),('1','293',362,'','supplier','1',0.00,877250.00,'Payment Id 112 for invoice:58/59, receipt: 5859 by AA RANO NIGERIA LTD','2023-01-05 11:16:14','',''),('1','293',363,'','24','3',0.00,5280000.00,'Purchase Id 16 for 22,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-01-08 17:07:32','',''),('1','293',364,'','supplier','1',5280000.00,0.00,'Purchase Id 16 for 22,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-01-08 17:07:32','',''),('1','293',365,'','20','1',0.00,0.00,'Sales from shift 63 on 2023-01-08 17:08:01 ','2023-01-08 17:08:01','',''),('1','293',366,'','6.1','4',0.00,0.00,'Sales from shift 63 on 2023-01-08 17:08:01 ','2023-01-08 17:08:01','',''),('1','293',367,'','20','1',766219.68,0.00,'Sales from shift 64 on 2023-01-08 17:27:03 ','2023-01-08 17:27:03','',''),('1','293',368,'','6.1','4',0.00,766219.68,'Sales from shift 64 on 2023-01-08 17:27:03 ','2023-01-08 17:27:03','',''),('1','293',369,'','20','1',794061.60,0.00,'Sales from shift 65 on 2023-01-10 15:03:14 ','2023-01-10 15:03:14','',''),('1','293',370,'','6.1','4',0.00,794061.60,'Sales from shift 65 on 2023-01-10 15:03:14 ','2023-01-10 15:03:14','',''),('1','293',371,'','20','1',1502114.40,0.00,'Sales from shift 66 on 2023-01-11 07:00:30 ','2023-01-11 07:00:30','',''),('1','293',372,'','6.1','4',0.00,1502114.40,'Sales from shift 66 on 2023-01-11 07:00:30 ','2023-01-11 07:00:30','',''),('1','293',373,'','24','3',0.00,5280000.00,'Purchase Id 17 for 22,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-01-11 10:40:08','',''),('1','293',374,'','supplier','1',5280000.00,0.00,'Purchase Id 17 for 22,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-01-11 10:40:08','',''),('1','293',375,'','2','5',17500.00,0.00,'Payment Id 114 for invoice:61, receipt: 061 by AA RANO NIGERIA LTD','2023-01-11 14:13:08','',''),('1','293',376,'','supplier','1',0.00,17500.00,'Payment Id 114 for invoice:61, receipt: 061 by AA RANO NIGERIA LTD','2023-01-11 14:13:08','',''),('1','293',377,'','2','5',900000.00,0.00,'Payment Id 110 for invoice:60, receipt: 060 by AA RANO NIGERIA LTD','2023-01-11 14:13:08','',''),('1','293',378,'','supplier','1',0.00,900000.00,'Payment Id 110 for invoice:60, receipt: 060 by AA RANO NIGERIA LTD','2023-01-11 14:13:08','',''),('1','293',379,'','20','1',581088.00,0.00,'Sales from shift 67 on 2023-01-11 14:34:42 ','2023-01-11 14:34:42','',''),('1','293',380,'','6.1','4',0.00,581088.00,'Sales from shift 67 on 2023-01-11 14:34:42 ','2023-01-11 14:34:42','',''),('1','293',381,'','20','1',1685690.40,0.00,'Sales from shift 68 on 2023-01-12 07:01:20 ','2023-01-12 07:01:20','',''),('1','293',382,'','6.1','4',0.00,1685690.40,'Sales from shift 68 on 2023-01-12 07:01:20 ','2023-01-12 07:01:20','',''),('1','293',383,'','24','3',0.00,10800000.00,'Purchase Id 18 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-01-13 14:58:43','',''),('1','293',384,'','supplier','1',10800000.00,0.00,'Purchase Id 18 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-01-13 14:58:43','',''),('1','293',385,'','20','1',3326061.60,0.00,'Sales from shift 69 on 2023-01-13 23:59:13 ','2023-01-13 23:59:13','',''),('1','293',386,'','6.1','4',0.00,3326061.60,'Sales from shift 69 on 2023-01-13 23:59:13 ','2023-01-13 23:59:13','',''),('1','293',387,'','20','1',1859337.60,0.00,'Sales from shift 70 on 2023-01-14 14:59:56 ','2023-01-14 14:59:56','',''),('1','293',388,'','6.1','4',0.00,1859337.60,'Sales from shift 70 on 2023-01-14 14:59:56 ','2023-01-14 14:59:56','',''),('1','293',389,'','20','1',424848.00,0.00,'Sales from shift 71 on 2023-01-15 21:37:07 ','2023-01-15 21:37:07','',''),('1','293',390,'','6.1','4',0.00,424848.00,'Sales from shift 71 on 2023-01-15 21:37:07 ','2023-01-15 21:37:07','',''),('1','293',391,'','20','1',3608870.40,0.00,'Sales from shift 72 on 2023-01-16 13:47:06 ','2023-01-16 13:47:06','',''),('1','293',392,'','6.1','4',0.00,3608870.40,'Sales from shift 72 on 2023-01-16 13:47:06 ','2023-01-16 13:47:06','',''),('1','293',393,'','20','1',2257027.20,0.00,'Sales from shift 73 on 2023-01-17 06:17:30 ','2023-01-17 06:17:30','',''),('1','293',394,'','6.1','4',0.00,2257027.20,'Sales from shift 73 on 2023-01-17 06:17:30 ','2023-01-17 06:17:30','',''),('1','293',395,'','20','1',1424167.20,0.00,'Sales from shift 74 on 2023-01-17 10:49:59 ','2023-01-17 10:49:59','',''),('1','293',396,'','6.1','4',0.00,1424167.20,'Sales from shift 74 on 2023-01-17 10:49:59 ','2023-01-17 10:49:59','',''),('1','293',397,'','20','1',519076.80,0.00,'Sales from shift 75 on 2023-01-17 17:18:49 ','2023-01-17 17:18:49','',''),('1','293',398,'','6.1','4',0.00,519076.80,'Sales from shift 75 on 2023-01-17 17:18:49 ','2023-01-17 17:18:49','',''),('1','293',399,'','24','3',0.00,5520000.00,'Purchase Id 19 for 23,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-01-18 09:56:43','',''),('1','293',400,'','supplier','1',5520000.00,0.00,'Purchase Id 19 for 23,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-01-18 09:56:43','',''),('1','293',401,'','20','1',0.00,0.00,'Sales from shift 76 on 2023-01-20 09:16:20 ','2023-01-20 09:16:20','',''),('1','293',402,'','6.1','4',0.00,0.00,'Sales from shift 76 on 2023-01-20 09:16:20 ','2023-01-20 09:16:20','',''),('1','293',403,'','2','5',694070.00,0.00,'Payment Id 121 for invoice:65, receipt: 065 by AA RANO NIGERIA LTD','2023-01-20 10:46:40','',''),('1','293',404,'','supplier','1',0.00,694070.00,'Payment Id 121 for invoice:65, receipt: 065 by AA RANO NIGERIA LTD','2023-01-20 10:46:40','',''),('1','293',405,'','2','5',766215.00,0.00,'Payment Id 120 for invoice:64, receipt: 064 by AA RANO NIGERIA LTD','2023-01-20 10:46:40','',''),('1','293',406,'','supplier','1',0.00,766215.00,'Payment Id 120 for invoice:64, receipt: 064 by AA RANO NIGERIA LTD','2023-01-20 10:46:40','',''),('1','293',407,'','2','5',2150.00,0.00,'Payment Id 130 for invoice:70, receipt: 700 by AA RANO NIGERIA LTD','2023-01-20 10:47:41','',''),('1','293',408,'','supplier','1',0.00,2150.00,'Payment Id 130 for invoice:70, receipt: 700 by AA RANO NIGERIA LTD','2023-01-20 10:47:41','',''),('1','293',409,'','2','5',1857180.00,0.00,'Payment Id 129 for invoice:70, receipt: 070 by AA RANO NIGERIA LTD','2023-01-20 10:47:41','',''),('1','293',410,'','supplier','1',0.00,1857180.00,'Payment Id 129 for invoice:70, receipt: 070 by AA RANO NIGERIA LTD','2023-01-20 10:47:41','',''),('1','293',411,'','2','5',2949580.00,0.00,'Payment Id 126 for invoice:69, receipt: 069 by AA RANO NIGERIA LTD','2023-01-20 10:47:41','',''),('1','293',412,'','supplier','1',0.00,2949580.00,'Payment Id 126 for invoice:69, receipt: 069 by AA RANO NIGERIA LTD','2023-01-20 10:47:41','',''),('1','293',413,'','2','5',56140.00,0.00,'Payment Id 125 for invoice:68, receipt: 0688 by AA RANO NIGERIA LTD','2023-01-20 10:47:41','',''),('1','293',414,'','supplier','1',0.00,56140.00,'Payment Id 125 for invoice:68, receipt: 0688 by AA RANO NIGERIA LTD','2023-01-20 10:47:41','',''),('1','293',415,'','2','5',1629550.00,0.00,'Payment Id 124 for invoice:68, receipt: 068 by AA RANO NIGERIA LTD','2023-01-20 10:47:41','',''),('1','293',416,'','supplier','1',0.00,1629550.00,'Payment Id 124 for invoice:68, receipt: 068 by AA RANO NIGERIA LTD','2023-01-20 10:47:41','',''),('1','293',417,'','2','5',581090.00,0.00,'Payment Id 123 for invoice:67, receipt: 067 by AA RANO NIGERIA LTD','2023-01-20 10:47:41','',''),('1','293',418,'','supplier','1',0.00,581090.00,'Payment Id 123 for invoice:67, receipt: 067 by AA RANO NIGERIA LTD','2023-01-20 10:47:41','',''),('1','293',419,'','2','5',1487810.00,0.00,'Payment Id 122 for invoice:66, receipt: 066 by AA RANO NIGERIA LTD','2023-01-20 10:47:41','',''),('1','293',420,'','supplier','1',0.00,1487810.00,'Payment Id 122 for invoice:66, receipt: 066 by AA RANO NIGERIA LTD','2023-01-20 10:47:41','',''),('1','293',421,'','2','5',1246720.00,0.00,'Payment Id 136 for invoice:74, receipt: 074 by AA RANO NIGERIA LTD','2023-01-20 10:48:30','',''),('1','293',422,'','supplier','1',0.00,1246720.00,'Payment Id 136 for invoice:74, receipt: 074 by AA RANO NIGERIA LTD','2023-01-20 10:48:30','',''),('1','293',423,'','2','5',2257090.00,0.00,'Payment Id 135 for invoice:73, receipt: 073 by AA RANO NIGERIA LTD','2023-01-20 10:48:30','',''),('1','293',424,'','supplier','1',0.00,2257090.00,'Payment Id 135 for invoice:73, receipt: 073 by AA RANO NIGERIA LTD','2023-01-20 10:48:30','',''),('1','293',425,'','2','5',1093870.00,0.00,'Payment Id 132 for invoice:72, receipt: 072 by AA RANO NIGERIA LTD','2023-01-20 10:48:30','',''),('1','293',426,'','supplier','1',0.00,1093870.00,'Payment Id 132 for invoice:72, receipt: 072 by AA RANO NIGERIA LTD','2023-01-20 10:48:30','',''),('1','293',427,'','24','3',0.00,10560000.00,'Purchase Id 20 for 44,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-01-21 06:14:09','',''),('1','293',428,'','supplier','1',10560000.00,0.00,'Purchase Id 20 for 44,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-01-21 06:14:09','',''),('1','293',429,'','20','1',2024109.60,0.00,'Sales from shift 77 on 2023-01-21 22:01:35 ','2023-01-21 22:01:35','',''),('1','293',430,'','6.1','4',0.00,2024109.60,'Sales from shift 77 on 2023-01-21 22:01:35 ','2023-01-21 22:01:35','',''),('1','293',431,'','20','1',1557309.60,0.00,'Sales from shift 78 on 2023-01-23 16:55:23 ','2023-01-23 16:55:23','',''),('1','293',432,'','6.1','4',0.00,1557309.60,'Sales from shift 78 on 2023-01-23 16:55:23 ','2023-01-23 16:55:23','',''),('1','293',433,'','supplier','1',0.00,10560000.00,'Purchase Id 20 for 44,000.00 litters of Petrol - PMS returned to AA RANO NIGERIA LTD','2023-01-24 12:22:59','',''),('1','293',434,'','24','3',0.00,9600000.00,'Purchase Id 21 for 40,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-01-24 12:23:14','',''),('1','293',435,'','supplier','1',9600000.00,0.00,'Purchase Id 21 for 40,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-01-24 12:23:14','',''),('1','293',436,'','20','1',1282344.00,0.00,'Sales from shift 79 on 2023-01-24 12:52:59 ','2023-01-24 12:52:59','',''),('1','293',437,'','6.1','4',0.00,1282344.00,'Sales from shift 79 on 2023-01-24 12:52:59 ','2023-01-24 12:52:59','',''),('1','293',438,'','20','1',1572256.80,0.00,'Sales from shift 80 on 2023-01-24 13:10:36 ','2023-01-24 13:10:36','',''),('1','293',439,'','6.1','4',0.00,1572256.80,'Sales from shift 80 on 2023-01-24 13:10:36 ','2023-01-24 13:10:36','',''),('1','293',440,'','20','1',1877196.00,0.00,'Sales from shift 81 on 2023-01-24 13:40:55 ','2023-01-24 13:40:55','',''),('1','293',441,'','6.1','4',0.00,1877196.00,'Sales from shift 81 on 2023-01-24 13:40:55 ','2023-01-24 13:40:55','',''),('1','293',442,'','20','1',833148.00,0.00,'Sales from shift 82 on 2023-01-24 14:20:47 ','2023-01-24 14:20:47','',''),('1','293',443,'','6.1','4',0.00,833148.00,'Sales from shift 82 on 2023-01-24 14:20:47 ','2023-01-24 14:20:47','',''),('1','293',444,'','20','1',1674576.00,0.00,'Sales from shift 83 on 2023-01-25 08:35:18 ','2023-01-25 08:35:18','',''),('1','293',445,'','6.1','4',0.00,1674576.00,'Sales from shift 83 on 2023-01-25 08:35:18 ','2023-01-25 08:35:18','',''),('1','293',446,'','2','5',1152230.00,0.00,'Payment Id 145 for invoice:80, receipt: 080 by AA RANO NIGERIA LTD','2023-01-25 12:11:02','',''),('1','293',447,'','supplier','1',0.00,1152230.00,'Payment Id 145 for invoice:80, receipt: 080 by AA RANO NIGERIA LTD','2023-01-25 12:11:02','',''),('1','293',448,'','2','5',1282335.00,0.00,'Payment Id 144 for invoice:79, receipt: 079 by AA RANO NIGERIA LTD','2023-01-25 12:11:03','',''),('1','293',449,'','supplier','1',0.00,1282335.00,'Payment Id 144 for invoice:79, receipt: 079 by AA RANO NIGERIA LTD','2023-01-25 12:11:03','',''),('1','293',450,'','2','5',1557320.00,0.00,'Payment Id 143 for invoice:78, receipt: 078 by AA RANO NIGERIA LTD','2023-01-25 12:11:03','',''),('1','293',451,'','supplier','1',0.00,1557320.00,'Payment Id 143 for invoice:78, receipt: 078 by AA RANO NIGERIA LTD','2023-01-25 12:11:03','',''),('1','293',452,'','2','5',40760.00,0.00,'Payment Id 142 for invoice:77, receipt: 077 by AA RANO NIGERIA LTD','2023-01-25 12:11:03','',''),('1','293',453,'','supplier','1',0.00,40760.00,'Payment Id 142 for invoice:77, receipt: 077 by AA RANO NIGERIA LTD','2023-01-25 12:11:03','',''),('1','293',454,'','2','5',1792250.00,0.00,'Payment Id 139 for invoice:76, receipt: 076 by AA RANO NIGERIA LTD','2023-01-25 12:11:03','',''),('1','293',455,'','supplier','1',0.00,1792250.00,'Payment Id 139 for invoice:76, receipt: 076 by AA RANO NIGERIA LTD','2023-01-25 12:11:03','',''),('1','293',456,'','2','5',299075.00,0.00,'Payment Id 138 for invoice:75, receipt: 075 by AA RANO NIGERIA LTD','2023-01-25 12:11:03','',''),('1','293',457,'','supplier','1',0.00,299075.00,'Payment Id 138 for invoice:75, receipt: 075 by AA RANO NIGERIA LTD','2023-01-25 12:11:03','',''),('1','293',458,'','2','5',21210.00,0.00,'Payment Id 153 for invoice:85, receipt: 085 by AA RANO NIGERIA LTD','2023-01-25 12:13:05','',''),('1','293',459,'','supplier','1',0.00,21210.00,'Payment Id 153 for invoice:85, receipt: 085 by AA RANO NIGERIA LTD','2023-01-25 12:13:05','',''),('1','293',460,'','2','5',1254465.00,0.00,'Payment Id 151 for invoice:84, receipt: 084 by AA RANO NIGERIA LTD','2023-01-25 12:13:05','',''),('1','293',461,'','supplier','1',0.00,1254465.00,'Payment Id 151 for invoice:84, receipt: 084 by AA RANO NIGERIA LTD','2023-01-25 12:13:05','',''),('1','293',462,'','2','5',1260175.00,0.00,'Payment Id 150 for invoice:83, receipt: 083 by AA RANO NIGERIA LTD','2023-01-25 12:13:05','',''),('1','293',463,'','supplier','1',0.00,1260175.00,'Payment Id 150 for invoice:83, receipt: 083 by AA RANO NIGERIA LTD','2023-01-25 12:13:05','',''),('1','293',464,'','2','5',1688790.00,0.00,'Payment Id 147 for invoice:81, receipt: 081 by AA RANO NIGERIA LTD','2023-01-25 12:13:05','',''),('1','293',465,'','supplier','1',0.00,1688790.00,'Payment Id 147 for invoice:81, receipt: 081 by AA RANO NIGERIA LTD','2023-01-25 12:13:05','',''),('1','293',466,'','6.1','4',420000.00,0.00,'Payment Id 146 for invoice:80, receipt: 0800 by AA RANO NIGERIA LTD','2023-01-25 12:13:33','',''),('1','293',467,'','supplier','1',0.00,420000.00,'Payment Id 146 for invoice:80, receipt: 0800 by AA RANO NIGERIA LTD','2023-01-25 12:13:33','',''),('1','293',468,'','6.1','4',136000.00,0.00,'Payment Id 141 for invoice:76, receipt: 0765 by AA RANO NIGERIA LTD','2023-01-25 12:14:13','',''),('1','293',469,'','supplier','1',0.00,136000.00,'Payment Id 141 for invoice:76, receipt: 0765 by AA RANO NIGERIA LTD','2023-01-25 12:14:13','',''),('1','293',470,'','2','6',275010.00,0.00,'Payment Id 140 for invoice:76, receipt: 0766 by AA RANO NIGERIA LTD','2023-01-25 12:14:34','',''),('1','293',471,'','supplier','1',0.00,275010.00,'Payment Id 140 for invoice:76, receipt: 0766 by AA RANO NIGERIA LTD','2023-01-25 12:14:34','',''),('1','293',472,'','2','6',177450.00,0.00,'Payment Id 137 for invoice:74, receipt: 0744 by AA RANO NIGERIA LTD','2023-01-25 12:14:34','',''),('1','293',473,'','supplier','1',0.00,177450.00,'Payment Id 137 for invoice:74, receipt: 0744 by AA RANO NIGERIA LTD','2023-01-25 12:14:34','',''),('1','293',474,'','2','6',115000.00,0.00,'Payment Id 134 for invoice:72, receipt: 07222 by AA RANO NIGERIA LTD','2023-01-25 12:14:34','',''),('1','293',475,'','supplier','1',0.00,115000.00,'Payment Id 134 for invoice:72, receipt: 07222 by AA RANO NIGERIA LTD','2023-01-25 12:14:34','',''),('1','293',476,'','20','1',1327264.80,0.00,'Sales from shift 84 on 2023-01-25 12:32:05 ','2023-01-25 12:32:05','',''),('1','293',477,'','6.1','4',0.00,1327264.80,'Sales from shift 84 on 2023-01-25 12:32:05 ','2023-01-25 12:32:05','',''),('1','293',478,'','20','1',889738.90,0.00,'Sales from shift 85 on 2023-01-26 07:03:43 ','2023-01-26 07:03:43','',''),('1','293',479,'','6.1','4',0.00,889738.90,'Sales from shift 85 on 2023-01-26 07:03:43 ','2023-01-26 07:03:43','',''),('1','293',480,'','20','1',1484528.10,0.00,'Sales from shift 86 on 2023-01-26 19:34:05 ','2023-01-26 19:34:05','',''),('1','293',481,'','6.1','4',0.00,1484528.10,'Sales from shift 86 on 2023-01-26 19:34:05 ','2023-01-26 19:34:05','',''),('1','293',482,'','20','1',2184432.00,0.00,'Sales from shift 87 on 2023-01-27 09:54:33 ','2023-01-27 09:54:33','',''),('1','293',483,'','6.1','4',0.00,2184432.00,'Sales from shift 87 on 2023-01-27 09:54:33 ','2023-01-27 09:54:33','',''),('1','293',484,'','6.1','4',168000.00,0.00,'Payment Id 128 for invoice:69, receipt: 699 by AA RANO NIGERIA LTD','2023-01-30 12:38:06','',''),('1','293',485,'','supplier','1',0.00,168000.00,'Payment Id 128 for invoice:69, receipt: 699 by AA RANO NIGERIA LTD','2023-01-30 12:38:06','',''),('1','293',486,'','6.1','4',136000.00,0.00,'Payment Id 127 for invoice:69, receipt: 69 by AA RANO NIGERIA LTD','2023-01-30 12:38:06','',''),('1','293',487,'','supplier','1',0.00,136000.00,'Payment Id 127 for invoice:69, receipt: 69 by AA RANO NIGERIA LTD','2023-01-30 12:38:06','',''),('1','293',488,'','2','6',176000.00,0.00,'Payment Id 148 for invoice:81, receipt: 0811 by AA RANO NIGERIA LTD','2023-02-01 14:59:35','',''),('1','293',489,'','supplier','1',0.00,176000.00,'Payment Id 148 for invoice:81, receipt: 0811 by AA RANO NIGERIA LTD','2023-02-01 14:59:35','',''),('1','293',490,'','2','5',2400000.00,0.00,'Payment Id 133 for invoice:72, receipt: 0722 by AA RANO NIGERIA LTD','2023-02-01 14:59:35','',''),('1','293',491,'','supplier','1',0.00,2400000.00,'Payment Id 133 for invoice:72, receipt: 0722 by AA RANO NIGERIA LTD','2023-02-01 14:59:35','',''),('1','293',492,'','2','5',104400.00,0.00,'Payment Id 158 for invoice:87, receipt: 0877 by AA RANO NIGERIA LTD','2023-02-01 15:08:14','',''),('1','293',493,'','supplier','1',0.00,104400.00,'Payment Id 158 for invoice:87, receipt: 0877 by AA RANO NIGERIA LTD','2023-02-01 15:08:14','',''),('1','293',494,'','2','6',828500.00,0.00,'Payment Id 154 for invoice:85/86, receipt: 8586 by AA RANO NIGERIA LTD','2023-02-01 15:08:14','',''),('1','293',495,'','supplier','1',0.00,828500.00,'Payment Id 154 for invoice:85/86, receipt: 8586 by AA RANO NIGERIA LTD','2023-02-01 15:08:14','',''),('1','293',496,'','2','6',360000.00,0.00,'Payment Id 152 for invoice:84/83, receipt: 8483 by AA RANO NIGERIA LTD','2023-02-01 15:08:14','',''),('1','293',497,'','supplier','1',0.00,360000.00,'Payment Id 152 for invoice:84/83, receipt: 8483 by AA RANO NIGERIA LTD','2023-02-01 15:08:14','',''),('1','293',498,'','2','6',833150.00,0.00,'Payment Id 149 for invoice:82, receipt: 082 by AA RANO NIGERIA LTD','2023-02-01 15:08:14','',''),('1','293',499,'','supplier','1',0.00,833150.00,'Payment Id 149 for invoice:82, receipt: 082 by AA RANO NIGERIA LTD','2023-02-01 15:08:14','',''),('1','293',500,'','20','1',186242.40,0.00,'Sales from shift 88 on 2023-02-06 10:18:43 ','2023-02-06 10:18:43','',''),('1','293',501,'','6.1','4',0.00,186242.40,'Sales from shift 88 on 2023-02-06 10:18:43 ','2023-02-06 10:18:43','',''),('1','293',502,'','24','3',0.00,3485000.00,'Purchase Id 22 for 17,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-02-06 10:19:32','',''),('1','293',503,'','supplier','1',3485000.00,0.00,'Purchase Id 22 for 17,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-02-06 10:19:32','',''),('1','293',504,'','20','1',1796689.70,0.00,'Sales from shift 89 on 2023-02-07 14:01:58 ','2023-02-07 14:01:58','',''),('1','293',505,'','6.1','4',0.00,1796689.70,'Sales from shift 89 on 2023-02-07 14:01:58 ','2023-02-07 14:01:58','',''),('1','293',506,'','24','3',0.00,10250000.00,'Purchase Id 23 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-02-07 14:02:36','',''),('1','293',507,'','supplier','1',10250000.00,0.00,'Purchase Id 23 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-02-07 14:02:36','',''),('1','293',508,'','20','1',730997.20,0.00,'Sales from shift 90 on 2023-02-08 08:04:17 ','2023-02-08 08:04:17','',''),('1','293',509,'','6.1','4',0.00,730997.20,'Sales from shift 90 on 2023-02-08 08:04:17 ','2023-02-08 08:04:17','',''),('1','293',510,'','24','3',0.00,12300000.00,'Purchase Id 24 for 60,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-02-08 13:49:13','',''),('1','293',511,'','supplier','1',12300000.00,0.00,'Purchase Id 24 for 60,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-02-08 13:49:13','',''),('1','293',512,'','20','1',4031126.15,0.00,'Sales from shift 91 on 2023-02-08 14:20:52 ','2023-02-08 14:20:52','',''),('1','293',513,'','6.1','4',0.00,4031126.15,'Sales from shift 91 on 2023-02-08 14:20:52 ','2023-02-08 14:20:52','',''),('1','293',514,'','20','1',2576995.55,0.00,'Sales from shift 92 on 2023-02-08 21:18:29 ','2023-02-08 21:18:29','',''),('1','293',515,'','6.1','4',0.00,2576995.55,'Sales from shift 92 on 2023-02-08 21:18:29 ','2023-02-08 21:18:29','',''),('1','293',516,'','20','1',4038124.85,0.00,'Sales from shift 93 on 2023-02-09 23:34:41 ','2023-02-09 23:34:41','',''),('1','293',517,'','6.1','4',0.00,4038124.85,'Sales from shift 93 on 2023-02-09 23:34:41 ','2023-02-09 23:34:41','',''),('1','293',518,'','20','1',2309167.15,0.00,'Sales from shift 94 on 2023-02-10 12:14:38 ','2023-02-10 12:14:38','',''),('1','293',519,'','6.1','4',0.00,2309167.15,'Sales from shift 94 on 2023-02-10 12:14:38 ','2023-02-10 12:14:38','',''),('1','293',520,'','20','1',1505163.30,0.00,'Sales from shift 95 on 2023-02-11 06:33:07 ','2023-02-11 06:33:07','',''),('1','293',521,'','6.1','4',0.00,1505163.30,'Sales from shift 95 on 2023-02-11 06:33:07 ','2023-02-11 06:33:07','',''),('1','293',522,'','20','1',1498570.50,0.00,'Sales from shift 96 on 2023-02-11 16:53:44 ','2023-02-11 16:53:44','',''),('1','293',523,'','6.1','4',0.00,1498570.50,'Sales from shift 96 on 2023-02-11 16:53:44 ','2023-02-11 16:53:44','',''),('1','293',524,'','2','6',2080000.00,0.00,'Payment Id 157 for invoice:87, receipt: 087 by AA RANO NIGERIA LTD','2023-02-13 11:41:39','',''),('1','293',525,'','supplier','1',0.00,2080000.00,'Payment Id 157 for invoice:87, receipt: 087 by AA RANO NIGERIA LTD','2023-02-13 11:41:39','',''),('1','293',526,'','2','6',698000.00,0.00,'Payment Id 119 for invoice:62, receipt: 062220 by AA RANO NIGERIA LTD','2023-02-13 11:41:39','',''),('1','293',527,'','supplier','1',0.00,698000.00,'Payment Id 119 for invoice:62, receipt: 062220 by AA RANO NIGERIA LTD','2023-02-13 11:41:39','',''),('1','293',528,'','6.1','4',567000.00,0.00,'Payment Id 167 for invoice:95, receipt: 095 by AA RANO NIGERIA LTD','2023-02-13 11:42:20','',''),('1','293',529,'','supplier','1',0.00,567000.00,'Payment Id 167 for invoice:95, receipt: 095 by AA RANO NIGERIA LTD','2023-02-13 11:42:20','',''),('1','293',530,'','2','6',3247250.00,0.00,'Payment Id 166 for invoice:94/95, receipt: 9495 by AA RANO NIGERIA LTD','2023-02-13 11:42:20','',''),('1','293',531,'','supplier','1',0.00,3247250.00,'Payment Id 166 for invoice:94/95, receipt: 9495 by AA RANO NIGERIA LTD','2023-02-13 11:42:20','',''),('1','293',532,'','2','6',6615075.00,0.00,'Payment Id 165 for invoice:92/93, receipt: 9293 by AA RANO NIGERIA LTD','2023-02-13 11:42:20','',''),('1','293',533,'','supplier','1',0.00,6615075.00,'Payment Id 165 for invoice:92/93, receipt: 9293 by AA RANO NIGERIA LTD','2023-02-13 11:42:20','',''),('1','293',534,'','2','6',4031114.00,0.00,'Payment Id 164 for invoice:91, receipt: 091 by AA RANO NIGERIA LTD','2023-02-13 11:42:20','',''),('1','293',535,'','supplier','1',0.00,4031114.00,'Payment Id 164 for invoice:91, receipt: 091 by AA RANO NIGERIA LTD','2023-02-13 11:42:20','',''),('1','293',536,'','2','6',2525640.00,0.00,'Payment Id 163 for invoice:89/90, receipt: 090 by AA RANO NIGERIA LTD','2023-02-13 11:42:20','',''),('1','293',537,'','supplier','1',0.00,2525640.00,'Payment Id 163 for invoice:89/90, receipt: 090 by AA RANO NIGERIA LTD','2023-02-13 11:42:20','',''),('1','293',538,'','2','6',1794740.00,0.00,'Payment Id 162 for invoice:89, receipt: 089 by AA RANO NIGERIA LTD','2023-02-13 11:42:20','',''),('1','293',539,'','supplier','1',0.00,1794740.00,'Payment Id 162 for invoice:89, receipt: 089 by AA RANO NIGERIA LTD','2023-02-13 11:42:20','',''),('1','293',540,'','6.1','4',246000.00,0.00,'Payment Id 161 for invoice:85, receipt: 0850 by AA RANO NIGERIA LTD','2023-02-13 11:42:20','',''),('1','293',541,'','supplier','1',0.00,246000.00,'Payment Id 161 for invoice:85, receipt: 0850 by AA RANO NIGERIA LTD','2023-02-13 11:42:20','',''),('1','293',542,'','6.1','4',42000.00,0.00,'Payment Id 160 for invoice:88, receipt: 0889 by AA RANO NIGERIA LTD','2023-02-13 11:42:20','',''),('1','293',543,'','supplier','1',0.00,42000.00,'Payment Id 160 for invoice:88, receipt: 0889 by AA RANO NIGERIA LTD','2023-02-13 11:42:20','',''),('1','293',544,'','20','1',1271649.85,0.00,'Sales from shift 97 on 2023-02-13 15:20:43 ','2023-02-13 15:20:43','',''),('1','293',545,'','6.1','4',0.00,1271649.85,'Sales from shift 97 on 2023-02-13 15:20:43 ','2023-02-13 15:20:43','',''),('1','293',546,'','20','1',564449.05,0.00,'Sales from shift 98 on 2023-02-14 06:23:55 ','2023-02-14 06:23:55','',''),('1','293',547,'','6.1','4',0.00,564449.05,'Sales from shift 98 on 2023-02-14 06:23:55 ','2023-02-14 06:23:55','',''),('1','293',548,'','20','1',2150425.40,0.00,'Sales from shift 99 on 2023-02-15 06:20:31 ','2023-02-15 06:20:31','',''),('1','293',549,'','6.1','4',0.00,2150425.40,'Sales from shift 99 on 2023-02-15 06:20:31 ','2023-02-15 06:20:31','',''),('1','293',550,'','20','1',2534402.70,0.00,'Sales from shift 100 on 2023-02-16 08:24:23 ','2023-02-16 08:24:23','',''),('1','293',551,'','6.1','4',0.00,2534402.70,'Sales from shift 100 on 2023-02-16 08:24:23 ','2023-02-16 08:24:23','',''),('1','293',552,'','20','1',1286741.95,0.00,'Sales from shift 101 on 2023-02-22 22:22:16 ','2023-02-22 22:22:16','',''),('1','293',553,'','6.1','4',0.00,1286741.95,'Sales from shift 101 on 2023-02-22 22:22:16 ','2023-02-22 22:22:16','',''),('1','293',554,'','20','1',142860.40,0.00,'Sales from shift 102 on 2023-02-24 22:29:07 ','2023-02-24 22:29:07','',''),('1','293',555,'','6.1','4',0.00,142860.40,'Sales from shift 102 on 2023-02-24 22:29:07 ','2023-02-24 22:29:07','',''),('1','293',556,'','20','1',365941.40,0.00,'Sales from shift 103 on 2023-02-27 08:18:53 ','2023-02-27 08:18:53','',''),('1','293',557,'','6.1','4',0.00,365941.40,'Sales from shift 103 on 2023-02-27 08:18:53 ','2023-02-27 08:18:53','',''),('1','293',558,'','20','1',0.00,0.00,'Sales from shift 104 on 2023-03-01 14:44:21 ','2023-03-01 14:44:21','',''),('1','293',559,'','6.1','4',0.00,0.00,'Sales from shift 104 on 2023-03-01 14:44:21 ','2023-03-01 14:44:21','',''),('1','293',560,'','24','3',0.00,3675000.00,'Purchase Id 25 for 17,500.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-01 15:21:16','',''),('1','293',561,'','supplier','1',3675000.00,0.00,'Purchase Id 25 for 17,500.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-01 15:21:16','',''),('1','293',562,'','24','3',0.00,11750000.00,'Purchase Id 26 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-01 15:22:08','',''),('1','293',563,'','supplier','1',11750000.00,0.00,'Purchase Id 26 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-01 15:22:08','',''),('1','293',564,'','20','1',1638525.00,0.00,'Sales from shift 105 on 2023-03-01 15:39:01 ','2023-03-01 15:39:01','',''),('1','293',565,'','6.1','4',0.00,1638525.00,'Sales from shift 105 on 2023-03-01 15:39:01 ','2023-03-01 15:39:01','',''),('1','293',566,'','20','1',1675361.10,0.00,'Sales from shift 106 on 2023-03-01 15:48:25 ','2023-03-01 15:48:25','',''),('1','293',567,'','6.1','4',0.00,1675361.10,'Sales from shift 106 on 2023-03-01 15:48:25 ','2023-03-01 15:48:25','',''),('1','293',568,'','20','1',322066.50,0.00,'Sales from shift 107 on 2023-03-01 15:57:13 ','2023-03-01 15:57:13','',''),('1','293',569,'','6.1','4',0.00,322066.50,'Sales from shift 107 on 2023-03-01 15:57:13 ','2023-03-01 15:57:13','',''),('1','293',570,'','20','1',92555.40,0.00,'Sales from shift 108 on 2023-03-01 16:16:39 ','2023-03-01 16:16:39','',''),('1','293',571,'','6.1','4',0.00,92555.40,'Sales from shift 108 on 2023-03-01 16:16:39 ','2023-03-01 16:16:39','',''),('1','293',572,'','20','1',3774656.95,0.00,'Sales from shift 109 on 2023-03-03 09:56:07 ','2023-03-03 09:56:07','',''),('1','293',573,'','6.1','4',0.00,3774656.95,'Sales from shift 109 on 2023-03-03 09:56:07 ','2023-03-03 09:56:07','',''),('1','293',574,'','20','1',1567981.10,0.00,'Sales from shift 110 on 2023-03-03 12:24:15 ','2023-03-03 12:24:15','',''),('1','293',575,'','6.1','4',0.00,1567981.10,'Sales from shift 110 on 2023-03-03 12:24:15 ','2023-03-03 12:24:15','',''),('1','293',576,'','24','3',0.00,11750000.00,'Purchase Id 27 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-03 12:25:57','',''),('1','293',577,'','supplier','1',11750000.00,0.00,'Purchase Id 27 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-03 12:25:57','',''),('1','293',578,'','24','3',0.00,11750000.00,'Purchase Id 28 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-03 12:27:44','',''),('1','293',579,'','supplier','1',11750000.00,0.00,'Purchase Id 28 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-03 12:27:44','',''),('1','293',580,'','20','1',3414061.20,0.00,'Sales from shift 111 on 2023-03-05 07:23:27 ','2023-03-05 07:23:27','',''),('1','293',581,'','6.1','4',0.00,3414061.20,'Sales from shift 111 on 2023-03-05 07:23:27 ','2023-03-05 07:23:27','',''),('1','293',582,'','20','1',1007198.25,0.00,'Sales from shift 112 on 2023-03-05 14:31:39 ','2023-03-05 14:31:39','',''),('1','293',583,'','6.1','4',0.00,1007198.25,'Sales from shift 112 on 2023-03-05 14:31:39 ','2023-03-05 14:31:39','',''),('1','293',584,'','20','1',3064740.75,0.00,'Sales from shift 113 on 2023-03-05 14:59:39 ','2023-03-05 14:59:39','',''),('1','293',585,'','6.1','4',0.00,3064740.75,'Sales from shift 113 on 2023-03-05 14:59:39 ','2023-03-05 14:59:39','',''),('1','293',586,'','20','1',852269.80,0.00,'Sales from shift 114 on 2023-03-05 15:18:03 ','2023-03-05 15:18:03','',''),('1','293',587,'','6.1','4',0.00,852269.80,'Sales from shift 114 on 2023-03-05 15:18:03 ','2023-03-05 15:18:03','',''),('1','293',588,'','20','1',4734951.55,0.00,'Sales from shift 115 on 2023-03-06 23:06:43 ','2023-03-06 23:06:43','',''),('1','293',589,'','6.1','4',0.00,4734951.55,'Sales from shift 115 on 2023-03-06 23:06:43 ','2023-03-06 23:06:43','',''),('1','293',590,'','24','3',0.00,11750000.00,'Purchase Id 29 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-06 23:08:06','',''),('1','293',591,'','supplier','1',11750000.00,0.00,'Purchase Id 29 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-06 23:08:06','',''),('1','293',592,'','20','1',831392.40,0.00,'Sales from shift 116 on 2023-03-07 11:28:32 ','2023-03-07 11:28:32','',''),('1','293',593,'','6.1','4',0.00,831392.40,'Sales from shift 116 on 2023-03-07 11:28:32 ','2023-03-07 11:28:32','',''),('1','293',594,'','20','1',0.00,0.00,'Sales from shift 117 on 2023-03-08 16:59:54 ','2023-03-08 16:59:54','',''),('1','293',595,'','6.1','4',0.00,0.00,'Sales from shift 117 on 2023-03-08 16:59:54 ','2023-03-08 16:59:54','',''),('1','293',596,'','24','3',0.00,11750000.00,'Purchase Id 30 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-08 21:20:22','',''),('1','293',597,'','supplier','1',11750000.00,0.00,'Purchase Id 30 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-08 21:20:22','',''),('1','293',598,'','24','3',0.00,10575000.00,'Purchase Id 31 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-08 21:21:09','',''),('1','293',599,'','supplier','1',10575000.00,0.00,'Purchase Id 31 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-08 21:21:09','',''),('1','293',600,'','20','1',3143531.55,0.00,'Sales from shift 118 on 2023-03-09 12:20:06 ','2023-03-09 12:20:06','',''),('1','293',601,'','6.1','4',0.00,3143531.55,'Sales from shift 118 on 2023-03-09 12:20:06 ','2023-03-09 12:20:06','',''),('1','293',602,'','20','1',4292014.15,0.00,'Sales from shift 119 on 2023-03-09 12:26:17 ','2023-03-09 12:26:17','',''),('1','293',603,'','6.1','4',0.00,4292014.15,'Sales from shift 119 on 2023-03-09 12:26:17 ','2023-03-09 12:26:17','',''),('1','293',604,'','20','1',2124381.20,0.00,'Sales from shift 120 on 2023-03-09 12:32:16 ','2023-03-09 12:32:16','',''),('1','293',605,'','6.1','4',0.00,2124381.20,'Sales from shift 120 on 2023-03-09 12:32:16 ','2023-03-09 12:32:16','',''),('1','293',606,'','20','1',2660829.80,0.00,'Sales from shift 121 on 2023-03-09 12:39:05 ','2023-03-09 12:39:05','',''),('1','293',607,'','6.1','4',0.00,2660829.80,'Sales from shift 121 on 2023-03-09 12:39:05 ','2023-03-09 12:39:05','',''),('1','293',608,'','20','1',5051896.05,0.00,'Sales from shift 122 on 2023-03-09 16:24:38 ','2023-03-09 16:24:38','',''),('1','293',609,'','6.1','4',0.00,5051896.05,'Sales from shift 122 on 2023-03-09 16:24:38 ','2023-03-09 16:24:38','',''),('1','293',610,'','20','1',2355649.40,0.00,'Sales from shift 123 on 2023-03-10 13:16:18 ','2023-03-10 13:16:18','',''),('1','293',611,'','6.1','4',0.00,2355649.40,'Sales from shift 123 on 2023-03-10 13:16:18 ','2023-03-10 13:16:18','',''),('1','293',612,'','24','3',0.00,9400000.00,'Purchase Id 32 for 40,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-10 15:41:39','',''),('1','293',613,'','supplier','1',9400000.00,0.00,'Purchase Id 32 for 40,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-10 15:41:39','',''),('1','293',614,'','20','1',3631459.70,0.00,'Sales from shift 124 on 2023-03-11 08:21:00 ','2023-03-11 08:21:00','',''),('1','293',615,'','6.1','4',0.00,3631459.70,'Sales from shift 124 on 2023-03-11 08:21:00 ','2023-03-11 08:21:00','',''),('1','293',616,'','20','1',3591747.05,0.00,'Sales from shift 125 on 2023-03-11 17:07:29 ','2023-03-11 17:07:29','',''),('1','293',617,'','6.1','4',0.00,3591747.05,'Sales from shift 125 on 2023-03-11 17:07:29 ','2023-03-11 17:07:29','',''),('1','293',618,'','20','1',3001022.85,0.00,'Sales from shift 126 on 2023-03-12 06:46:40 ','2023-03-12 06:46:40','',''),('1','293',619,'','6.1','4',0.00,3001022.85,'Sales from shift 126 on 2023-03-12 06:46:40 ','2023-03-12 06:46:40','',''),('1','293',620,'','20','1',2969873.60,0.00,'Sales from shift 127 on 2023-03-12 21:47:55 ','2023-03-12 21:47:55','',''),('1','293',621,'','6.1','4',0.00,2969873.60,'Sales from shift 127 on 2023-03-12 21:47:55 ','2023-03-12 21:47:55','',''),('1','293',622,'','24','3',0.00,11750000.00,'Purchase Id 33 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-12 21:48:39','',''),('1','293',623,'','supplier','1',11750000.00,0.00,'Purchase Id 33 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-12 21:48:39','',''),('1','293',624,'','20','1',3016001.75,0.00,'Sales from shift 128 on 2023-03-13 17:46:05 ','2023-03-13 17:46:05','',''),('1','293',625,'','6.1','4',0.00,3016001.75,'Sales from shift 128 on 2023-03-13 17:46:05 ','2023-03-13 17:46:05','',''),('1','293',626,'','20','1',1581813.20,0.00,'Sales from shift 129 on 2023-03-14 18:30:28 ','2023-03-14 18:30:28','',''),('1','293',627,'','6.1','4',0.00,1581813.20,'Sales from shift 129 on 2023-03-14 18:30:28 ','2023-03-14 18:30:28','',''),('1','293',628,'','24','3',0.00,10575000.00,'Purchase Id 34 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-14 18:31:06','',''),('1','293',629,'','supplier','1',10575000.00,0.00,'Purchase Id 34 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-14 18:31:06','',''),('1','293',630,'','20','1',1251816.80,0.00,'Sales from shift 130 on 2023-03-15 06:53:59 ','2023-03-15 06:53:59','',''),('1','293',631,'','6.1','4',0.00,1251816.80,'Sales from shift 130 on 2023-03-15 06:53:59 ','2023-03-15 06:53:59','',''),('1','293',632,'','20','1',3221029.85,0.00,'Sales from shift 131 on 2023-03-15 09:05:18 ','2023-03-15 09:05:18','',''),('1','293',633,'','6.1','4',0.00,3221029.85,'Sales from shift 131 on 2023-03-15 09:05:18 ','2023-03-15 09:05:18','',''),('1','293',634,'','20','1',0.00,0.00,'Sales from shift 132 on 2023-03-15 10:09:08 ','2023-03-15 10:09:08','',''),('1','293',635,'','6.1','4',0.00,0.00,'Sales from shift 132 on 2023-03-15 10:09:08 ','2023-03-15 10:09:08','',''),('1','293',636,'','20','1',2085679.05,0.00,'Sales from shift 133 on 2023-03-15 10:19:28 ','2023-03-15 10:19:28','',''),('1','293',637,'','6.1','4',0.00,2085679.05,'Sales from shift 133 on 2023-03-15 10:19:28 ','2023-03-15 10:19:28','',''),('1','293',638,'','2','6',564500.00,0.00,'Payment Id 170 for invoice:98, receipt: 098 by AA RANO NIGERIA LTD','2023-03-15 15:01:45','',''),('1','293',639,'','supplier','1',0.00,564500.00,'Payment Id 170 for invoice:98, receipt: 098 by AA RANO NIGERIA LTD','2023-03-15 15:01:45','',''),('1','293',640,'','2','6',1271800.00,0.00,'Payment Id 169 for invoice:97, receipt: 097 by AA RANO NIGERIA LTD','2023-03-15 15:01:45','',''),('1','293',641,'','supplier','1',0.00,1271800.00,'Payment Id 169 for invoice:97, receipt: 097 by AA RANO NIGERIA LTD','2023-03-15 15:01:45','',''),('1','293',642,'','2','6',1498610.00,0.00,'Payment Id 168 for invoice:96, receipt: 096 by AA RANO NIGERIA LTD','2023-03-15 15:01:45','',''),('1','293',643,'','supplier','1',0.00,1498610.00,'Payment Id 168 for invoice:96, receipt: 096 by AA RANO NIGERIA LTD','2023-03-15 15:01:45','',''),('1','293',644,'','2','6',365940.00,0.00,'Payment Id 176 for invoice:103, receipt: 103 by AA RANO NIGERIA LTD','2023-03-15 15:05:49','',''),('1','293',645,'','supplier','1',0.00,365940.00,'Payment Id 176 for invoice:103, receipt: 103 by AA RANO NIGERIA LTD','2023-03-15 15:05:49','',''),('1','293',646,'','2','6',142860.00,0.00,'Payment Id 175 for invoice:102, receipt: 102 by AA RANO NIGERIA LTD','2023-03-15 15:05:49','',''),('1','293',647,'','supplier','1',0.00,142860.00,'Payment Id 175 for invoice:102, receipt: 102 by AA RANO NIGERIA LTD','2023-03-15 15:05:49','',''),('1','293',648,'','2','6',1286741.00,0.00,'Payment Id 174 for invoice:101, receipt: 101 by AA RANO NIGERIA LTD','2023-03-15 15:05:49','',''),('1','293',649,'','supplier','1',0.00,1286741.00,'Payment Id 174 for invoice:101, receipt: 101 by AA RANO NIGERIA LTD','2023-03-15 15:05:49','',''),('1','293',650,'','2','6',1871070.00,0.00,'Payment Id 173 for invoice:100, receipt: 100 by AA RANO NIGERIA LTD','2023-03-15 15:05:49','',''),('1','293',651,'','supplier','1',0.00,1871070.00,'Payment Id 173 for invoice:100, receipt: 100 by AA RANO NIGERIA LTD','2023-03-15 15:05:49','',''),('1','293',652,'','2','6',1000000.00,0.00,'Payment Id 171 for invoice:99, receipt: 099 by AA RANO NIGERIA LTD','2023-03-15 15:05:49','',''),('1','293',653,'','supplier','1',0.00,1000000.00,'Payment Id 171 for invoice:99, receipt: 099 by AA RANO NIGERIA LTD','2023-03-15 15:05:49','',''),('1','293',654,'','2','6',4072091.00,0.00,'Payment Id 182 for invoice:113/112, receipt: 113/112 by AA RANO NIGERIA LTD','2023-03-15 15:10:33','',''),('1','293',655,'','supplier','1',0.00,4072091.00,'Payment Id 182 for invoice:113/112, receipt: 113/112 by AA RANO NIGERIA LTD','2023-03-15 15:10:33','',''),('1','293',656,'','2','6',4911510.00,0.00,'Payment Id 181 for invoice:111, receipt: 111 by AA RANO NIGERIA LTD','2023-03-15 15:10:33','',''),('1','293',657,'','supplier','1',0.00,4911510.00,'Payment Id 181 for invoice:111, receipt: 111 by AA RANO NIGERIA LTD','2023-03-15 15:10:33','',''),('1','293',658,'','2','6',3937725.00,0.00,'Payment Id 180 for invoice:108, receipt: 108/109 by AA RANO NIGERIA LTD','2023-03-15 15:10:33','',''),('1','293',659,'','supplier','1',0.00,3937725.00,'Payment Id 180 for invoice:108, receipt: 108/109 by AA RANO NIGERIA LTD','2023-03-15 15:10:33','',''),('1','293',660,'','2','6',322070.00,0.00,'Payment Id 179 for invoice:106, receipt: 106 by AA RANO NIGERIA LTD','2023-03-15 15:10:33','',''),('1','293',661,'','supplier','1',0.00,322070.00,'Payment Id 179 for invoice:106, receipt: 106 by AA RANO NIGERIA LTD','2023-03-15 15:10:33','',''),('1','293',662,'','2','6',1675360.00,0.00,'Payment Id 178 for invoice:105, receipt: 105 by AA RANO NIGERIA LTD','2023-03-15 15:10:33','',''),('1','293',663,'','supplier','1',0.00,1675360.00,'Payment Id 178 for invoice:105, receipt: 105 by AA RANO NIGERIA LTD','2023-03-15 15:10:33','',''),('1','293',664,'','2','6',1638525.00,0.00,'Payment Id 177 for invoice:104, receipt: 104 by AA RANO NIGERIA LTD','2023-03-15 15:10:33','',''),('1','293',665,'','supplier','1',0.00,1638525.00,'Payment Id 177 for invoice:104, receipt: 104 by AA RANO NIGERIA LTD','2023-03-15 15:10:33','',''),('1','293',666,'','2','6',4256710.00,0.00,'Payment Id 186 for invoice:121, receipt: 121 by AA RANO NIGERIA LTD','2023-03-15 15:15:48','',''),('1','293',667,'','supplier','1',0.00,4256710.00,'Payment Id 186 for invoice:121, receipt: 121 by AA RANO NIGERIA LTD','2023-03-15 15:15:48','',''),('1','293',668,'','2','6',4292014.00,0.00,'Payment Id 185 for invoice:119, receipt: 119 by AA RANO NIGERIA LTD','2023-03-15 15:15:48','',''),('1','293',669,'','supplier','1',0.00,4292014.00,'Payment Id 185 for invoice:119, receipt: 119 by AA RANO NIGERIA LTD','2023-03-15 15:15:48','',''),('1','293',670,'','2','6',3974788.00,0.00,'Payment Id 184 for invoice:116/117, receipt: 116 by AA RANO NIGERIA LTD','2023-03-15 15:15:48','',''),('1','293',671,'','supplier','1',0.00,3974788.00,'Payment Id 184 for invoice:116/117, receipt: 116 by AA RANO NIGERIA LTD','2023-03-15 15:15:48','',''),('1','293',672,'','2','6',5587258.00,0.00,'Payment Id 183 for invoice:115/115, receipt: 115 by AA RANO NIGERIA LTD','2023-03-15 15:15:48','',''),('1','293',673,'','supplier','1',0.00,5587258.00,'Payment Id 183 for invoice:115/115, receipt: 115 by AA RANO NIGERIA LTD','2023-03-15 15:15:48','',''),('1','293',674,'','2','6',5993981.00,0.00,'Payment Id 190 for invoice:123, receipt: 123 by AA RANO NIGERIA LTD','2023-03-15 15:16:53','',''),('1','293',675,'','supplier','1',0.00,5993981.00,'Payment Id 190 for invoice:123, receipt: 123 by AA RANO NIGERIA LTD','2023-03-15 15:16:53','',''),('1','293',676,'','2','6',4851389.00,0.00,'Payment Id 188 for invoice:122, receipt: 122 by AA RANO NIGERIA LTD','2023-03-15 15:16:53','',''),('1','293',677,'','supplier','1',0.00,4851389.00,'Payment Id 188 for invoice:122, receipt: 122 by AA RANO NIGERIA LTD','2023-03-15 15:16:53','',''),('1','293',678,'','20','1',3163819.10,0.00,'Sales from shift 134 on 2023-03-15 18:15:42 ','2023-03-15 18:15:42','',''),('1','293',679,'','6.1','4',0.00,3163819.10,'Sales from shift 134 on 2023-03-15 18:15:42 ','2023-03-15 18:15:42','',''),('1','293',680,'','20','1',2997728.15,0.00,'Sales from shift 135 on 2023-03-16 09:07:13 ','2023-03-16 09:07:13','',''),('1','293',681,'','6.1','4',0.00,2997728.15,'Sales from shift 135 on 2023-03-16 09:07:13 ','2023-03-16 09:07:13','',''),('1','293',682,'','20','1',5168444.30,0.00,'Sales from shift 136 on 2023-03-16 12:19:57 ','2023-03-16 12:19:57','',''),('1','293',683,'','6.1','4',0.00,5168444.30,'Sales from shift 136 on 2023-03-16 12:19:57 ','2023-03-16 12:19:57','',''),('1','293',684,'','20','1',3392603.35,0.00,'Sales from shift 137 on 2023-03-16 12:28:27 ','2023-03-16 12:28:27','',''),('1','293',685,'','6.1','4',0.00,3392603.35,'Sales from shift 137 on 2023-03-16 12:28:27 ','2023-03-16 12:28:27','',''),('1','293',686,'','20','1',3313532.90,0.00,'Sales from shift 138 on 2023-03-16 22:01:43 ','2023-03-16 22:01:43','',''),('1','293',687,'','6.1','4',0.00,3313532.90,'Sales from shift 138 on 2023-03-16 22:01:43 ','2023-03-16 22:01:43','',''),('1','293',688,'','20','1',3495397.05,0.00,'Sales from shift 139 on 2023-03-17 21:31:21 ','2023-03-17 21:31:21','',''),('1','293',689,'','6.1','4',0.00,3495397.05,'Sales from shift 139 on 2023-03-17 21:31:21 ','2023-03-17 21:31:21','',''),('1','293',690,'','20','1',3259910.60,0.00,'Sales from shift 140 on 2023-03-18 07:16:42 ','2023-03-18 07:16:42','',''),('1','293',691,'','6.1','4',0.00,3259910.60,'Sales from shift 140 on 2023-03-18 07:16:42 ','2023-03-18 07:16:42','',''),('1','293',692,'','20','1',2426572.40,0.00,'Sales from shift 141 on 2023-03-20 08:10:15 ','2023-03-20 08:10:15','',''),('1','293',693,'','6.1','4',0.00,2426572.40,'Sales from shift 141 on 2023-03-20 08:10:15 ','2023-03-20 08:10:15','','');
/*!40000 ALTER TABLE `ledgers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `options`
--

DROP TABLE IF EXISTS `options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `options` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` bigint NOT NULL,
  `station_id` bigint NOT NULL,
  `option_key` varchar(200) NOT NULL,
  `option_value` longtext,
  `thedate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `station_id` (`station_id`,`option_key`),
  KEY `company_id` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `options`
--

LOCK TABLES `options` WRITE;
/*!40000 ALTER TABLE `options` DISABLE KEYS */;
/*!40000 ALTER TABLE `options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `measurement` varchar(20) NOT NULL,
  `quantity2` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`code`,`name`,`measurement`,`quantity2`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `cleanup` (`cleanup`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'1','293','PMS','Petrol','Litres',0,235.00,225.00,225.00,225.00,0.00,0,'2022-10-20 11:08:11','178','971','2023-03-21 00:33:10',0),(2,'1','293','AGO','Diesel','Litres',0,0.00,0.00,0.00,0.00,0.00,0,'2022-10-20 11:14:18','178','178','2022-10-20 11:14:18',0);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_changevalues`
--

DROP TABLE IF EXISTS `products_changevalues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_changevalues` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `change_id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity` bigint NOT NULL,
  `oldrate` decimal(20,2) NOT NULL,
  `newrate` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`change_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_changevalues`
--

LOCK TABLES `products_changevalues` WRITE;
/*!40000 ALTER TABLE `products_changevalues` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_changevalues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_prices`
--

DROP TABLE IF EXISTS `products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_prices`
--

LOCK TABLES `products_prices` WRITE;
/*!40000 ALTER TABLE `products_prices` DISABLE KEYS */;
INSERT INTO `products_prices` VALUES (1,'1','293',1,178.00,0.00,0.00,0.00,'Cost from purchase id #1','2022-11-01 18:15:56','648'),(2,'1','293',1,178.00,178.00,178.00,178.00,'','2022-11-03 09:52:40','971'),(3,'1','293',1,210.00,178.00,0.00,0.00,'Cost from purchase id #7','2022-11-24 04:32:47','648'),(4,'1','293',1,210.00,210.00,210.00,210.00,'INREMENT OF PUMP PRICE ','2022-12-01 07:50:28','971'),(5,'1','293',1,230.00,210.00,0.00,0.00,'Cost from purchase id #13','2022-12-15 21:20:00','648'),(6,'1','293',1,230.00,230.00,230.00,230.00,'INCREMENT OF PUMP PRICE ','2022-12-16 15:20:05','971'),(7,'1','293',1,240.00,240.00,240.00,240000.00,'INCREMENT OF PUMP PRICE ','2022-12-24 11:13:08','971'),(8,'1','293',1,240.00,205.00,205.00,205.00,'DECREMENT OF PUMP PRICE','2023-02-06 10:13:10','971'),(9,'1','293',1,205.00,205.00,0.00,0.00,'Cost from purchase id #22','2023-02-06 10:19:32','648'),(10,'1','293',1,210.00,201.00,210.00,210.00,'INCREMENT OF PUMP PRICE ','2023-02-27 16:20:21','971'),(11,'1','293',1,210.00,210.00,210.00,210.00,'INCREMENT OF PUMP PRICE ','2023-02-27 16:51:13','971'),(12,'1','293',1,235.00,210.00,0.00,0.00,'Cost from purchase id #26','2023-03-01 15:22:08','648'),(13,'1','293',1,235.00,235.00,235.00,235.00,'INCREMENT OF PUMP PRICE ','2023-03-01 16:02:45','971'),(14,'1','293',1,235.00,225.00,225.00,225.00,'DECREMENT OF PUMP PRICE','2023-03-21 00:34:11','971');
/*!40000 ALTER TABLE `products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_reconciliations`
--

DROP TABLE IF EXISTS `products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_reconciliations`
--

LOCK TABLES `products_reconciliations` WRITE;
/*!40000 ALTER TABLE `products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_shortages`
--

DROP TABLE IF EXISTS `products_shortages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_shortages` (
  `shortage_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shortagedate` date NOT NULL,
  `product_id` varchar(10) NOT NULL,
  `type` int NOT NULL DEFAULT '0',
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`shortage_id`),
  KEY `companycode` (`company_id`,`shortagedate`,`product_id`,`rate`,`quantity`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_shortages`
--

LOCK TABLES `products_shortages` WRITE;
/*!40000 ALTER TABLE `products_shortages` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_shortages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pts_nozzles`
--

DROP TABLE IF EXISTS `pts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pts_nozzles` (
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pts_id` int NOT NULL,
  `pump` varchar(20) NOT NULL,
  `code` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `last_volume` decimal(20,2) NOT NULL,
  `last_price` decimal(20,2) NOT NULL,
  `last_amount` decimal(20,2) NOT NULL,
  `last_transaction` int NOT NULL DEFAULT '0',
  `total_volume` decimal(20,2) NOT NULL,
  `total_amount` decimal(20,2) NOT NULL,
  `total_transactions` decimal(20,2) NOT NULL,
  `lastconnect` datetime NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `terminal_id` (`pts_id`,`pump`,`code`,`lastconnect`),
  KEY `companycode` (`company_id`,`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pts_nozzles`
--

LOCK TABLES `pts_nozzles` WRITE;
/*!40000 ALTER TABLE `pts_nozzles` DISABLE KEYS */;
/*!40000 ALTER TABLE `pts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases`
--

DROP TABLE IF EXISTS `purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases`
--

LOCK TABLES `purchases` WRITE;
/*!40000 ALTER TABLE `purchases` DISABLE KEYS */;
INSERT INTO `purchases` VALUES (1,'1','293','2022-09-22',1,1,178.00,48000.00,0.00,0.00,8544000.00,0.00,'','0000','BCH 747 XA','','','','2022-11-01 13:42:49',15,'PURCHASE OF PMS ','971','','0000-00-00 00:00:00','648','2022-11-01 18:15:56'),(2,'1','293','2022-09-22',1,1,178.00,50000.00,0.00,0.00,8900000.00,0.00,'','0000','RAN 825 XA','','','','2022-11-01 13:44:56',15,'PURCHASE OF PMS ','971','','0000-00-00 00:00:00','648','2022-11-01 18:16:23'),(3,'1','293','2022-09-23',1,1,178.00,50000.00,0.00,0.00,8900000.00,0.00,'','0000','KMC 579 ZU','','','','2022-11-01 13:47:36',15,'PMS PURCHASE ','971','','0000-00-00 00:00:00','648','2022-11-01 18:16:49'),(4,'1','293','2022-10-05',1,1,178.00,50000.00,0.00,0.00,8900000.00,0.00,'','0000','RAN 941 XA','','','','2022-11-01 13:49:16',15,'PMS PURCHASE','971','','0000-00-00 00:00:00','648','2022-11-01 18:17:15'),(5,'1','293','2022-10-06',1,1,178.00,45000.00,0.00,0.00,8010000.00,0.00,'','0000','TRN 203 ZG','','','','2022-11-01 13:50:30',15,'PMS PURCHASE ','971','','0000-00-00 00:00:00','648','2022-11-01 18:17:52'),(6,'1','293','2022-10-08',1,1,178.00,45000.00,0.00,0.00,8010000.00,0.00,'','0000','TRN 224 ZQ','','','','2022-11-01 13:51:38',15,'PMS PURCHASE','971','','0000-00-00 00:00:00','648','2022-11-01 18:18:14'),(7,'1','293','2022-11-16',1,1,210.00,60000.00,0.00,0.00,12600000.00,0.00,'','0000','KMC 691 ZE','','','','2022-11-21 11:40:08',15,'PURCHASE OF PMS ','971','','0000-00-00 00:00:00','648','2022-11-24 04:32:47'),(8,'1','293','2022-11-23',1,1,210.00,45000.00,0.00,0.00,9450000.00,0.00,'','0000','KKM 196 XA','','','','2022-11-23 17:45:57',15,'PURCHASE OF PMS ','971','','0000-00-00 00:00:00','648','2022-11-24 04:34:45'),(9,'1','293','2022-11-23',1,1,210.00,45000.00,0.00,0.00,9450000.00,0.00,'','0000','RAN 817 XA','','','','2022-11-23 17:46:37',15,'PURCHASE OF PMS','971','','0000-00-00 00:00:00','648','2022-11-24 04:33:40'),(10,'1','293','2022-11-24',1,1,210.00,50000.00,0.00,0.00,10500000.00,0.00,'','084','GWL 538 YJ','','','','2022-11-26 10:15:15',15,'PURCHASE OF PMS ','971','','0000-00-00 00:00:00','648','2022-11-27 14:10:12'),(11,'1','293','2022-11-26',1,1,210.00,51000.00,0.00,0.00,10710000.00,0.00,'','0000','RAN 902 XA','','','','2022-11-28 18:20:41',15,'PURCHASE OF PMS','971','','0000-00-00 00:00:00','648','2022-12-01 09:14:37'),(12,'1','293','2022-11-27',1,1,210.00,18000.00,0.00,0.00,3780000.00,0.00,'','0000','RAN 899 XA','','','','2022-11-28 18:22:34',15,'PURCHASE OF PMS ','971','','0000-00-00 00:00:00','648','2022-12-01 09:13:23'),(13,'1','293','2022-12-15',1,1,230.00,45000.00,0.00,0.00,10350000.00,0.00,'','0000','TRN 224 ZG','','','','2022-12-15 16:36:14',15,'PURCHASE OF PMS ','971','','0000-00-00 00:00:00','648','2022-12-15 21:20:00'),(14,'1','293','2022-12-18',1,1,230.00,18000.00,0.00,0.00,4140000.00,0.00,'','0000','RAN 545 XA','','','','2022-12-19 16:44:30',15,'PURCHASE OF PMS ','971','','0000-00-00 00:00:00','648','2022-12-20 05:28:40'),(15,'1','293','2022-12-23',1,1,230.00,45000.00,0.00,0.00,10350000.00,0.00,'','0000','KMC 577 ZU','','','','2022-12-23 12:59:57',15,'PURCHASE OF PMS ','971','','0000-00-00 00:00:00','648','2022-12-23 13:08:14'),(16,'1','293','2023-01-07',1,1,240.00,22000.00,0.00,0.00,5280000.00,0.00,'','','kmc 573zu','','','','2023-01-08 12:31:29',15,'pms purchase','971','','0000-00-00 00:00:00','648','2023-01-08 17:07:32'),(17,'1','293','2023-01-10',1,1,240.00,22000.00,0.00,0.00,5280000.00,0.00,'','0000','KMC 573ZU','','','','2023-01-10 19:36:42',15,'PMS PURCHASE','971','','0000-00-00 00:00:00','648','2023-01-11 10:40:08'),(18,'1','293','2023-01-12',1,1,240.00,45000.00,0.00,0.00,10800000.00,0.00,'','0000','RAN545XA','','','','2023-01-13 12:52:03',15,'PMS PURCHASE','971','','0000-00-00 00:00:00','648','2023-01-13 14:58:43'),(19,'1','293','2023-01-12',1,1,240.00,23000.00,0.00,0.00,5520000.00,0.00,'','0000','kmc 573zu','','','','2023-01-13 16:52:34',15,'PMS PURCHASE','971','','0000-00-00 00:00:00','648','2023-01-18 09:56:43'),(20,'1','293','2023-01-17',1,1,240.00,44000.00,0.00,0.00,10560000.00,0.00,'','','TRN 935ZG','','','','2023-01-18 10:14:05',2,'PMS PURCHASE','971','','0000-00-00 00:00:00','975','2023-01-24 12:22:59'),(21,'1','293','2023-01-17',1,1,240.00,40000.00,0.00,0.00,9600000.00,0.00,'','00000','TRN 935 ZG','','','','2023-01-24 12:18:57',15,'PURCHASE OF PMS ','971','','0000-00-00 00:00:00','975','2023-01-24 12:23:14'),(22,'1','293','2023-02-05',1,1,205.00,17000.00,0.00,0.00,3485000.00,0.00,'','0000','TRN 186 ZY','','','','2023-02-06 10:10:56',15,'PURCHASE OF PMS','971','','0000-00-00 00:00:00','648','2023-02-06 10:19:32'),(23,'1','293','2023-02-06',1,1,205.00,50000.00,0.00,0.00,10250000.00,0.00,'','0000','FGE 980 ZY','','','','2023-02-07 08:54:51',15,'PURCHASE OF PMS','971','','0000-00-00 00:00:00','648','2023-02-07 14:02:36'),(24,'1','293','2023-02-07',1,1,205.00,60000.00,0.00,0.00,12300000.00,0.00,'','0000','TRN 22 YZ','','','','2023-02-08 11:07:27',15,'PURCHASE OF PMS','971','','0000-00-00 00:00:00','648','2023-02-08 13:49:13'),(25,'1','293','2023-02-26',1,1,210.00,17500.00,0.00,0.00,3675000.00,0.00,'','0000','RAN 946 XA','','','','2023-02-27 16:21:35',15,'PURCHASE OF PMS','971','','0000-00-00 00:00:00','648','2023-03-01 15:21:16'),(26,'1','293','2023-03-01',1,1,235.00,50000.00,0.00,0.00,11750000.00,0.00,'','00000','RAN 425 XA','','','','2023-03-01 11:29:02',15,'PURCHASE OF PMS','971','','0000-00-00 00:00:00','648','2023-03-01 15:22:08'),(27,'1','293','2023-03-01',1,1,235.00,50000.00,0.00,0.00,11750000.00,0.00,'','0000','ABS 700 XA','','','','2023-03-02 17:14:14',15,'PURCHASE OF PMS','971','','0000-00-00 00:00:00','648','2023-03-03 12:25:57'),(28,'1','293','2023-03-02',1,1,235.00,50000.00,0.00,0.00,11750000.00,0.00,'','0000','NSR 531 ZQ','','','','2023-03-02 17:15:40',15,'PURCHASE OF PMS','971','','0000-00-00 00:00:00','648','2023-03-03 12:27:44'),(29,'1','293','2023-03-04',1,1,235.00,50000.00,0.00,0.00,11750000.00,0.00,'','0000','RAN 425 XA','','','','2023-03-05 13:47:27',15,'PURCHASE OF PMS','971','','0000-00-00 00:00:00','648','2023-03-06 23:08:07'),(30,'1','293','2023-03-07',1,1,235.00,50000.00,0.00,0.00,11750000.00,0.00,'','0000','RAN 425 XA','','','','2023-03-08 15:39:38',15,'POS SALES','971','','0000-00-00 00:00:00','648','2023-03-08 21:20:22'),(31,'1','293','2023-03-08',1,1,235.00,45000.00,0.00,0.00,10575000.00,0.00,'','0000','RAN 829 XA','','','','2023-03-08 15:42:03',15,'POS SALES','971','','0000-00-00 00:00:00','648','2023-03-08 21:21:09'),(32,'1','293','2023-03-10',1,1,235.00,40000.00,0.00,0.00,9400000.00,0.00,'','0000','TRN 935 ZG','','','','2023-03-10 10:15:30',15,'POS SALES ','971','','0000-00-00 00:00:00','648','2023-03-10 15:41:39'),(33,'1','293','2023-03-11',1,1,235.00,50000.00,0.00,0.00,11750000.00,0.00,'','0000','RAN 965 XA','','','','2023-03-11 20:55:53',15,'PURCHASE OF PMS','971','','0000-00-00 00:00:00','648','2023-03-12 21:48:39'),(34,'1','293','2023-03-14',1,1,235.00,45000.00,0.00,0.00,10575000.00,0.00,'','00000','RAN 829 XA','','','','2023-03-14 15:16:50',15,'PURCHASE OF PMS','971','','0000-00-00 00:00:00','648','2023-03-14 18:31:06');
/*!40000 ALTER TABLE `purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_payments`
--

DROP TABLE IF EXISTS `purchases_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `supplier_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`supplier_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=204 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_payments`
--

LOCK TABLES `purchases_payments` WRITE;
/*!40000 ALTER TABLE `purchases_payments` DISABLE KEYS */;
INSERT INTO `purchases_payments` VALUES (6,'1','293','2022-09-29',1,'05','','5',1844670.00,'05','','','5','BAYELSA 2','05',2175875.56,'2022-11-14 13:53:55',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-11-17 16:57:06'),(7,'1','293','2022-09-29',1,'04/05','','10',433580.00,'04/05','','','6','BAYELSA 2','04/05',43580.00,'2022-11-14 13:55:53',5,'POS SALES','971','','0000-00-00 00:00:00','975','2022-11-17 16:57:06'),(8,'1','293','2022-09-30',1,'08','','5',1264530.00,'08','','','5','BAYELSA 2','08',1838104.54,'2022-11-14 13:57:47',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-11-17 16:57:06'),(9,'1','293','2022-09-30',1,'088','','5',20800.00,'08','','','5','BAYELSA 2','088',20800.00,'2022-11-14 13:58:57',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-11-17 16:57:06'),(10,'1','293','2022-09-30',1,'07','','5',1987045.00,'07','','','5','BAYELSA 2','07',2146110.40,'2022-11-14 14:00:32',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-11-17 16:57:06'),(11,'1','293','2022-09-30',1,'06/07','','10',802278.00,'06/07','','','6','BAYELSA 2','06/07',802278.00,'2022-11-14 14:02:12',5,'POS SALES','971','','0000-00-00 00:00:00','975','2022-11-17 16:57:06'),(12,'1','293','2022-10-01',1,'08','','5',1745795.00,'08','','','5','BAYELSA 2','08,',1838104.54,'2022-11-14 14:04:39',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-11-17 16:57:06'),(13,'1','293','2022-10-01',1,'09','','5',1581480.00,'09','','','5','BAYELSA 2','09',2113381.54,'2022-11-14 14:05:42',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-11-17 16:57:06'),(14,'1','293','2022-10-01',1,'08/09','','10',624200.00,'08/09','','','6','BAYELSA 2','08/09',624200.00,'2022-11-14 14:07:16',5,'POS SALES','971','','0000-00-00 00:00:00','975','2022-11-17 16:57:06'),(15,'1','293','2022-10-02',1,'10/11','','5',1448345.00,'10/11','','','5','BAYELSA 2','10/11',1618571.80,'2022-11-14 14:09:50',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-11-17 16:58:39'),(16,'1','293','2022-10-02',1,'11','','5',1239425.00,'11','','','5','BAYELSA 2','11',1692393.74,'2022-11-14 14:10:51',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-11-17 16:58:39'),(17,'1','293','2022-10-02',1,'10/11','','10',315200.00,'10/11','','','6','BAYELSA 2','10/11,',315200.00,'2022-11-14 14:14:38',5,'POS','971','','0000-00-00 00:00:00','975','2022-11-17 16:58:39'),(18,'1','293','2022-10-03',1,'12','','5',1134670.00,'12','','','5','BAYELSA 2','12',1757271.18,'2022-11-14 14:16:48',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-11-17 16:58:39'),(19,'1','293','2022-09-27',1,'01','','5',840040.00,'01','','','5','BAYELSA 2','01',1841977.82,'2022-11-16 17:26:37',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-11-17 16:58:39'),(20,'1','293','2022-09-28',1,'03','','5',1832775.00,'03','','','5','BAYELSA 2','03',1865272.68,'2022-11-16 17:28:39',5,'PAYMENT ON ACCOUNT','971','975','2022-11-17 17:01:07','975','2022-11-17 17:01:26'),(21,'1','293','2022-09-28',1,'033','','5',20000.00,'03','','','5','BAYELSA 2','033',0.00,'2022-11-16 17:30:21',5,'PAYMENT ON  ACCOUNT','971','','0000-00-00 00:00:00','975','2022-11-17 16:58:39'),(22,'1','293','2022-09-28',1,'00','','10',59380.00,'02/03','','','6','BAYELSA 2','00',0.00,'2022-11-16 17:31:43',5,'POS SALES','971','','0000-00-00 00:00:00','975','2022-11-17 16:58:39'),(23,'1','293','2022-09-29',1,'044','','5',1608575.00,'4','','','5','BAYELSA 2','044',1736809.48,'2022-11-16 17:34:23',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-11-17 16:58:39'),(24,'1','293','2022-10-03',1,'13','','5',1423385.00,'13','','','5','BAYELSA 2','13,',1643077.06,'2022-11-16 17:37:59',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-11-17 16:58:39'),(25,'1','293','2022-10-03',1,'12/13','','10',842290.00,'12/13','','','6','BAYELSA 2','12/13',0.00,'2022-11-23 17:53:22',5,'POS SALES','971','','0000-00-00 00:00:00','975','2022-12-02 12:12:56'),(26,'1','293','2022-10-04',1,'0000','','5',466430.00,'14','','','5','BAYELSA 2','0000',998930.66,'2022-11-24 10:24:47',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-02 12:14:37'),(27,'1','293','2022-10-04',1,'0012','','5',375060.00,'15','','','5','BAYELSA 2','0012',408056.10,'2022-11-24 10:28:09',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-02 12:14:37'),(28,'1','293','2022-10-04',1,'123','','5',67500.00,'16/15','','','6','BAYELSA 2','12',0.00,'2022-11-24 10:30:31',5,'POS SALES','971','975','2022-12-02 12:25:21','975','2022-12-02 12:25:37'),(29,'1','293','2022-10-05',1,'016','','5',1621495.00,'16','','','5','BAYELSA 2','016',1776634.14,'2022-11-24 10:33:50',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-02 12:14:37'),(30,'1','293','2022-10-06',1,'017','','5',1017785.00,'17','','','5','BAYELSA 2','017',1813284.22,'2022-12-01 11:12:44',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-02 12:14:37'),(32,'1','293','2022-10-06',1,'019','','5',1643940.00,'19','','','5','BAYELSA 2','019',1803777.24,'2022-12-01 11:16:19',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-02 12:14:37'),(33,'1','293','2022-10-06',1,'16','','10',955302.00,'16/17','','','6','BAYELSA 2','16',0.00,'2022-12-01 11:21:10',5,'POS SALES ','971','','0000-00-00 00:00:00','975','2022-12-02 12:25:37'),(34,'1','293','2022-10-07',1,'020','','5',1570135.00,'20','','','5','BAYELSA 2','020',1751612.56,'2022-12-01 11:22:36',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-02 12:14:37'),(35,'1','293','2022-10-07',1,'021','','5',1471250.00,'21','','','5','BAYELSA 2','021',1915575.48,'2022-12-01 11:23:51',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-02 12:14:37'),(36,'1','293','2022-10-07',1,'0022','','5',625860.00,'20/21','','','6','BAYELSA 2','0022',0.00,'2022-12-01 11:25:29',5,'POS SALES','971','','0000-00-00 00:00:00','975','2022-12-02 12:14:37'),(37,'1','293','2022-10-08',1,'22','','5',1270785.00,'22','','','5','BAYELSA 2','22',1720912.90,'2022-12-01 11:27:51',5,'PAYMENT ON ACCOUNT','971','975','2022-12-02 12:15:19','975','2022-12-02 12:16:41'),(38,'1','293','2022-10-08',1,'023','','5',1508540.00,'23','','','5','BAYELSA 2','023',1768025.94,'2022-12-01 11:30:42',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-02 12:16:41'),(39,'1','293','2022-10-08',1,'2223','','10',397500.00,'22/23','','','6','BAYELSA 2','2223',0.00,'2022-12-01 11:32:33',5,'POS SALES','971','','0000-00-00 00:00:00','975','2022-12-02 12:16:41'),(40,'1','293','2022-10-09',1,'24','','5',1088525.00,'24','','','5','BAYELSA 2','24',1405516.48,'2022-12-01 11:34:49',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-02 12:16:41'),(41,'1','293','2022-10-09',1,'025','','5',1528350.00,'25','','','5','BAYELSA 2','025',1739448.04,'2022-12-01 11:37:32',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-02 12:16:41'),(42,'1','293','2022-10-09',1,'2425','','10',528200.00,'24/25','','','6','BAYELSA 2','2425',0.00,'2022-12-01 11:39:28',5,'POS SALES','971','','0000-00-00 00:00:00','975','2022-12-02 12:16:41'),(43,'1','293','2022-10-10',1,'26','','5',724330.00,'26','','','5','BAYELSA 2','026',1706938.12,'2022-12-01 11:41:28',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-02 12:16:41'),(44,'1','293','2022-10-10',1,'027','','5',1200165.00,'27','','','5','BAYELSA 2','027',1559119.80,'2022-12-01 11:43:34',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-02 12:16:41'),(46,'1','293','2022-10-10',1,'0266','','5',79000.00,'26','','','5','BAYELSA 2','0266',0.00,'2022-12-01 11:49:28',5,'PAYMENT ON ACCOUNT ','971','','0000-00-00 00:00:00','975','2022-12-17 13:23:45'),(47,'1','293','2022-10-10',1,'0277','','5',16500.00,'27','','','5','BAYELSA 2','0277',0.00,'2022-12-01 11:51:07',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-02 12:23:18'),(48,'1','293','2022-10-10',1,'26277','','10',1246076.00,'26/277','','','6','BAYELSA 2','26277',0.00,'2022-12-01 11:55:51',5,'POS SALES','971','','0000-00-00 00:00:00','975','2022-12-02 12:28:02'),(49,'1','293','2022-10-11',1,'028','','5',1501310.00,'28','','','5','BAYELSA 2','028',1699193.34,'2022-12-01 11:58:45',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-02 12:18:06'),(50,'1','293','2022-10-11',1,'029','','5',1256470.00,'29','','','5','BAYELSA 2','029',2235140.66,'2022-12-01 12:01:41',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-02 12:18:06'),(51,'1','293','2022-10-11',1,'28299','','10',726700.00,'28/29','','','6','BAYELSA 2','28299',0.00,'2022-12-01 12:04:15',5,'POS SALES','971','','0000-00-00 00:00:00','975','2022-12-02 12:18:06'),(52,'1','293','2022-10-12',1,'030','','5',1677950.00,'30','','','5','BAYELSA 2','030',1753271.52,'2022-12-01 12:09:08',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-02 12:18:06'),(53,'1','293','2022-10-12',1,'031','','5',46000.00,'31','','','5','BAYELSA 2','031',225121.94,'2022-12-01 12:12:16',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-02 12:18:06'),(54,'1','293','2022-10-12',1,'30311','','10',355800.00,'30/31','','','6','BAYELSA 2','30311',0.00,'2022-12-01 12:14:09',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-02 12:18:06'),(55,'1','293','2022-11-16',1,'032','','5',2843840.00,'32','','','5','BAYELSA 2','032',3310139.70,'2022-12-01 12:16:17',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-02 12:18:06'),(56,'1','293','2022-11-16',1,'0333','','10',157700.00,'33','','','6','BAYELSA 2','0333',0.00,'2022-12-01 12:18:23',5,'POS SALES','971','','0000-00-00 00:00:00','975','2022-12-02 12:28:02'),(57,'1','293','2022-11-17',1,'33','','5',1086895.00,'33','','','5','BAYELSA 2','33',2465450.40,'2022-12-01 12:21:21',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-02 12:18:06'),(58,'1','293','2022-11-17',1,'0344','','2',505000.00,'33','','','','','',0.00,'2022-12-01 12:22:41',5,'GENERATOR CONSUMPTION ','971','','0000-00-00 00:00:00','975','2022-12-02 12:19:16'),(59,'1','293','2022-11-17',1,'034','','5',2664895.00,'34','','','5','BAYELSA 2','034',2920747.20,'2022-12-01 12:25:33',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-02 12:19:16'),(60,'1','293','2022-11-17',1,'3334','','10',1118790.00,'33/34','','','6','BAYELSA 2','3334',0.00,'2022-12-01 12:27:57',5,'POS SALES','971','','0000-00-00 00:00:00','975','2022-12-06 12:36:44'),(61,'1','293','2022-11-18',1,'035','','5',1142300.00,'35','','','5','BAYELSA 2','035',1803263.70,'2022-12-01 12:29:07',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-02 12:19:16'),(62,'1','293','2022-11-18',1,'036','','5',1645740.00,'36','','','5','BAYELSA 2','036',1842363.60,'2022-12-01 12:30:14',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-02 12:19:16'),(63,'1','293','2022-11-18',1,'3536','','10',847468.00,'35/36','','','6','BAYELSA 2','3536',0.00,'2022-12-01 12:31:54',5,'POS SALES','971','','0000-00-00 00:00:00','975','2022-12-02 12:28:02'),(64,'1','293','2022-11-23',1,'037','','5',883590.00,'37','','','5','BAYELSA 2','037',912865.80,'2022-12-01 12:33:34',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-12 14:19:01'),(65,'1','293','2022-11-23',1,'038','','5',3651700.00,'38','','','5','BAYELSA 2','038',4402158.60,'2022-12-01 12:36:36',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-02 12:19:16'),(66,'1','293','2022-11-23',1,'038','','2',133750.00,'38','','','','','',0.00,'2022-12-01 12:38:03',5,'HAULAGE SERVICE ','971','','0000-00-00 00:00:00','975','2022-12-02 12:19:16'),(67,'1','293','2022-11-23',1,'038','','2',133750.00,'38','','','','','',0.00,'2022-12-01 12:39:28',5,'HAULAGE SERVICE \r\nRAN 817 XA','971','','0000-00-00 00:00:00','975','2022-12-02 12:19:16'),(68,'1','293','2022-11-23',1,'3738','','10',512890.00,'37/38','','','5','BAYELSA 2','3738',0.00,'2022-12-01 12:41:35',5,'POS SALES','971','','0000-00-00 00:00:00','975','2022-12-02 12:22:14'),(69,'1','293','2022-11-24',1,'039','','5',2429200.00,'39','','','5','BAYELSA 2','039',3302903.10,'2022-12-01 12:44:07',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-02 12:22:14'),(70,'1','293','2022-11-24',1,'040','','5',3876600.00,'40','','','5','BAYELSA 2','040',4294760.40,'2022-12-01 12:46:01',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-02 12:22:14'),(71,'1','293','2022-11-24',1,'040','','2',94000.00,'40','','','','','',0.00,'2022-12-01 12:46:57',5,'HAULAGE SERVICE \r\nGWL 538 YJ','971','','0000-00-00 00:00:00','975','2022-12-02 12:22:14'),(72,'1','293','2022-11-24',1,'3940','','10',1170300.00,'39/40','','','6','BAYELSA 2','3940',0.00,'2022-12-01 12:49:17',5,'POS SALES','971','','0000-00-00 00:00:00','975','2022-12-06 12:36:44'),(73,'1','293','2022-11-25',1,'041','','5',3700440.00,'41','','','5','BAYELSA 2','041',4151282.10,'2022-12-01 12:51:22',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-02 12:22:14'),(74,'1','293','2022-11-25',1,'042','','5',4856460.00,'42','','','5','BAYELSA 2','042',5281206.00,'2022-12-01 12:53:53',5,'PAYMENT ON ACCOUNT ','971','','0000-00-00 00:00:00','975','2022-12-02 12:22:14'),(75,'1','293','2022-11-25',1,'4142','','10',875800.00,'41/42','','','6','BAYELSA 2','4142',0.00,'2022-12-01 12:55:48',5,'POS SALES ','971','','0000-00-00 00:00:00','975','2022-12-06 12:36:44'),(76,'1','293','2022-11-26',1,'043','','5',2406590.00,'43','','','5','BAYELSA 2','043',2899722.15,'2022-12-01 12:58:51',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-02 12:12:19'),(77,'1','293','2022-11-26',1,'0444','','5',3839800.00,'44','','','5','BAYELSA 2','0444',4244381.40,'2022-12-01 13:01:28',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-02 12:12:19'),(78,'1','293','2022-11-26',1,'0411','','10',897712.00,'44','','','6','BAYELSA 2','0411',0.00,'2022-12-01 13:03:53',5,'POS SALES','971','','0000-00-00 00:00:00','975','2022-12-02 12:12:19'),(80,'1','293','2022-11-27',1,'045','','2',134500.00,'45','','','','','',0.00,'2022-12-01 13:07:14',5,'HAULAGE SERVICE \r\nRAN 902 XA','971','','0000-00-00 00:00:00','975','2022-12-02 12:12:19'),(81,'1','293','2022-11-27',1,'0455','','2',134500.00,'45','','','','','',0.00,'2022-12-01 13:09:10',5,'HAULAGE SERVICE \r\nRAN 899 XA','971','','0000-00-00 00:00:00','975','2022-12-02 12:12:19'),(82,'1','293','2022-11-28',1,'046','','5',2178565.00,'46','','','5','BAYELSA 2','046',2659093.50,'2022-12-01 13:11:09',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-02 12:12:19'),(83,'1','293','2022-11-27',1,'4546','','10',1285512.00,'45/46','','','6','BAYELSA 2','4546',0.00,'2022-12-01 13:13:26',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-02 12:12:19'),(84,'1','293','2022-11-28',1,'047','','5',2781135.00,'47','','','5','BAYELSA 2','047',3676732.00,'2022-12-01 13:16:50',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-02 12:12:19'),(86,'1','293','2022-11-28',1,'0047','','5',2229730.00,'47','','','5','BAYELSA 2','0047',3676732.00,'2022-12-05 15:43:04',5,'PAYMENT ON ACCOUNT ','971','','0000-00-00 00:00:00','975','2022-12-06 12:30:52'),(87,'1','293','2022-11-28',1,'0477','','5',18210.00,'47','','','5','BAYELSA 2','0477',0.00,'2022-12-05 15:44:03',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-06 12:30:52'),(88,'1','293','2022-11-28',1,'0499','','5',36100.00,'49','','','5','BAYELSA 2','0499',0.00,'2022-12-05 15:45:45',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-06 12:30:52'),(89,'1','293','2022-11-28',1,'00499','','5',2799590.00,'49','','','5','BAYELSA 2','00499',2932150.20,'2022-12-05 15:47:20',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-06 12:30:52'),(90,'1','293','2022-12-05',1,'1633835','','5',206000.00,'0000','','','5','BAYELSA 2','1633835',0.00,'2022-12-05 15:52:31',5,'PAYMENT ON ACCOUNT ','971','','0000-00-00 00:00:00','975','2022-12-06 12:30:52'),(91,'1','293','2022-12-05',1,'1633834','','5',462300.00,'50','','','5','BAYELSA 2','1633834',2026294.20,'2022-12-05 15:54:30',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-06 12:30:52'),(92,'1','293','2022-12-05',1,'5000','','10',724000.00,'50','','','6','BAYELSA 2','5000',0.00,'2022-12-05 15:55:20',5,'POS SALES','971','','0000-00-00 00:00:00','975','2022-12-26 09:45:22'),(93,'1','293','2022-12-02',1,'0500','','2',840000.00,'50','','','','','',0.00,'2022-12-06 13:32:48',5,'GENERATOR CONSUMPTION ','971','','0000-00-00 00:00:00','975','2022-12-12 14:12:23'),(94,'1','293','2022-12-05',1,'00777','','10',235523.00,'51','','','6','BAYELSA 2','00777',215523.02,'2022-12-08 22:57:10',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-12 14:12:23'),(95,'1','293','2022-11-11',1,'1004105','','5',1000000.00,'00100','','','5','BAYELSA 2','1004105',0.00,'2022-12-15 11:10:41',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-26 10:01:54'),(96,'1','293','2022-11-17',1,'2093803','','5',300000.00,'000234','','','5','BAYELSA 2','2093803',0.00,'2022-12-15 11:12:01',5,'PAYMENT ON ACCOUNT ','971','','0000-00-00 00:00:00','975','2022-12-17 13:23:45'),(97,'1','293','2022-11-28',1,'0001230','','10',967070.00,'47/49','','','6','BAYELSA 2','0001230',0.00,'2022-12-15 11:19:30',5,'POS SALES','971','','0000-00-00 00:00:00','975','2022-12-26 09:45:22'),(98,'1','293','2022-12-15',1,'053','','5',2548280.00,'53','','','5','BAYELSA 2','053',2681294.00,'2022-12-17 11:46:12',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-21 10:50:47'),(99,'1','293','2022-12-15',1,'053','','2',133000.00,'53','','','','','',0.00,'2022-12-17 11:59:00',5,'HAULAGE SERVICE \r\nTRN 224 ZG','971','','0000-00-00 00:00:00','975','2022-12-17 13:23:45'),(100,'1','293','2022-12-16',1,'054','','5',2825790.00,'54','','','5','Bayelsa 2','054',3430801.90,'2022-12-17 15:35:49',5,'PAYMENT ON ACCOUNT ','971','','0000-00-00 00:00:00','975','2022-12-21 10:50:47'),(101,'1','293','2022-12-16',1,'0555','','5',240200.00,'055','','','5','Bayelsa 2','0555',3288151.30,'2022-12-17 15:42:37',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-26 09:46:20'),(102,'1','293','2022-12-16',1,'055','','5',2811270.00,'55','','','5','Bayelsa 2','055',3288151.30,'2022-12-17 15:43:46',5,'PAMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-26 09:45:22'),(103,'1','293','2022-12-16',1,'5554','','10',1081880.00,'55/54','','','5','Bayelsa 2','5554',0.00,'2022-12-17 15:46:24',5,'POS PAYMENT','971','','0000-00-00 00:00:00','975','2022-12-26 09:45:22'),(104,'1','293','2022-12-18',1,'056','','5',1032210.00,'56','','','5','BAYELSA 2','056',1397178.70,'2022-12-18 16:02:39',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-21 10:50:47'),(105,'1','293','2022-12-18',1,'057','','5',2671540.00,'57','','','5','BAYELSA 2','057',2825441.90,'2022-12-20 11:22:10',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-21 10:50:47'),(106,'1','293','2022-12-18',1,'5756','','10',518900.00,'57/56','','','5','BAYELSA 2','5756',0.00,'2022-12-20 11:23:47',5,'POS SALES','971','','0000-00-00 00:00:00','975','2022-12-26 09:45:22'),(107,'1','293','2022-12-23',1,'058','','5',2713600.00,'58','','','5','BAYELSA 2','058',3724916.70,'2022-12-23 18:50:47',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-29 16:21:23'),(109,'1','293','2022-12-23',1,'05888','','2',133000.00,'58','','','','','',0.00,'2022-12-23 18:54:38',5,'HAULAGE SERVICE \r\nKMC 577 ZU','971','','0000-00-00 00:00:00','975','2022-12-29 16:21:23'),(110,'1','293','2022-12-25',1,'060','','10',900000.00,'60','','','5','BAYELSA 2','060',0.00,'2022-12-26 19:26:34',5,'POS SALES','971','','0000-00-00 00:00:00','975','2023-01-11 14:13:08'),(111,'1','293','2022-12-23',1,'2093816','','5',2174060.00,'59','','','5','BAYELSA 2','2093816',2238748.80,'2022-12-27 11:28:53',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-29 16:21:23'),(112,'1','293','2022-12-23',1,'5859','','10',877250.00,'58/59','','','6','BAYELSA 2','5859',0.00,'2022-12-27 11:30:20',5,'POS SALES','971','','0000-00-00 00:00:00','975','2023-01-05 11:16:14'),(113,'1','293','2022-12-25',1,'0600','','5',917200.00,'60','','','5','BAYELSA 2','0600',1886966.00,'2022-12-27 11:32:17',5,'APYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2022-12-29 16:21:23'),(114,'1','293','2022-12-29',1,'061','','5',17500.00,'61','','','5','BAYELSA 2','061',917479.20,'2022-12-29 16:43:00',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2023-01-11 14:13:08'),(115,'1','293','2022-12-29',1,'0611','','10',900000.00,'61','','','6','BAYELSA 2','0611',0.00,'2022-12-29 16:43:48',5,'POS SALES','971','','0000-00-00 00:00:00','975','2023-01-05 11:16:14'),(117,'1','293','2022-12-31',1,'0622','','5',1643000.00,'62','','','5','BAYELSA 2','0622',2441904.00,'2023-01-01 10:29:14',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2023-01-05 11:16:14'),(119,'1','293','2022-12-31',1,'062220','','10',698000.00,'62','','','6','BAYELSA 2','062220',0.00,'2023-01-01 10:31:56',5,'POS SALES','971','','0000-00-00 00:00:00','975','2023-02-13 11:41:39'),(120,'1','293','2023-01-07',1,'064','','5',766215.00,'64','','','5','BAYELSA 2','064',766219.68,'2023-01-19 10:22:00',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2023-01-20 10:46:40'),(121,'1','293','2023-01-07',1,'065','','5',694070.00,'65','','','5','BAYELSA 2','065',794061.60,'2023-01-19 10:23:02',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2023-01-20 10:46:40'),(122,'1','293','2023-01-08',1,'066','','5',1487810.00,'66','','','5','BAYELSA 2','066',1502114.40,'2023-01-19 10:24:17',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2023-01-20 10:47:41'),(123,'1','293','2023-01-08',1,'067','','5',581090.00,'67','','','5','BAYELSA 2','067',581088.00,'2023-01-19 10:25:30',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2023-01-20 10:47:41'),(124,'1','293','2023-01-11',1,'068','','5',1629550.00,'68','','','5','BAYELSA 2','068',1685690.40,'2023-01-19 10:28:57',5,'PAYMENT  ON ACCOUNT ','971','','0000-00-00 00:00:00','975','2023-01-20 10:47:41'),(125,'1','293','2023-01-11',1,'0688','','5',56140.00,'68','','','5','BAYELSA 2','0688',1685690.40,'2023-01-19 10:29:53',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2023-01-20 10:47:41'),(126,'1','293','2023-01-12',1,'069','','5',2949580.00,'69','','','5','BAYELSA 2','069',3326061.60,'2023-01-19 10:31:24',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2023-01-20 10:47:41'),(127,'1','293','2023-01-12',1,'69','','2',136000.00,'69','','','','','',0.00,'2023-01-19 10:32:40',5,'RAN 545 XA \r\nHAULAGE SERVICE ','971','','0000-00-00 00:00:00','975','2023-01-30 12:38:06'),(128,'1','293','2023-01-12',1,'699','','2',168000.00,'69','','','','','',0.00,'2023-01-19 10:33:47',5,'GENERATOR CON','971','','0000-00-00 00:00:00','975','2023-01-30 12:38:06'),(129,'1','293','2023-01-13',1,'070','','5',1857180.00,'70','','','5','BAYELSA 2','070',1859337.60,'2023-01-19 10:35:57',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2023-01-20 10:47:41'),(130,'1','293','2023-01-13',1,'700','','5',2150.00,'70','','','5','BAYELSA 2','700',0.00,'2023-01-19 10:37:37',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2023-01-20 10:47:41'),(131,'1','293','2023-01-13',1,'071','','5',417650.00,'71','','','5','BAYELSA 2','071',424848.00,'2023-01-19 10:39:07',0,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(132,'1','293','2023-01-14',1,'072','','5',1093870.00,'72','','','5','BAYELSA 2','072',3608870.40,'2023-01-19 10:40:56',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2023-01-20 10:48:30'),(133,'1','293','2023-01-14',1,'0722','','5',2400000.00,'72','','','5','BAYELSA 2','0722',0.00,'2023-01-19 10:42:05',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2023-02-01 14:59:35'),(134,'1','293','2023-01-14',1,'07222','','10',115000.00,'72','','','6','BAYELSA 2','07222',0.00,'2023-01-19 10:43:15',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2023-01-25 12:14:34'),(135,'1','293','2023-01-15',1,'073','','5',2257090.00,'73','','','5','BAYELSA 2','073',0.00,'2023-01-19 10:45:19',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2023-01-20 10:48:30'),(136,'1','293','2023-01-16',1,'074','','5',1246720.00,'74','','','5','BAYELSA 2','074',1424167.20,'2023-01-19 10:48:50',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2023-01-20 10:48:30'),(137,'1','293','2023-01-16',1,'0744','','10',177450.00,'74','','','6','BAYELSA 2','0744',0.00,'2023-01-19 10:50:16',5,'POS SALES','971','','0000-00-00 00:00:00','975','2023-01-25 12:14:34'),(138,'1','293','2023-01-17',1,'075','','5',299075.00,'75','','','5','BAYELSA 2','075',519076.80,'2023-01-19 10:52:06',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2023-01-25 12:11:03'),(139,'1','293','2023-01-17',1,'076','','5',1792250.00,'76','','','5','BAYELSA 2','076',2024013.00,'2023-01-19 10:54:45',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2023-01-25 12:11:03'),(140,'1','293','2023-01-17',1,'0766','','10',275010.00,'76','','','6','BAYELSA 2','0766',0.00,'2023-01-19 10:56:38',5,'POS SALES ','971','','0000-00-00 00:00:00','975','2023-01-25 12:14:34'),(141,'1','293','2023-01-17',1,'0765','','2',136000.00,'76','','','','','',0.00,'2023-01-19 10:58:41',5,'HAULAGE SERVICE \r\nTRN 935 ZG','971','','0000-00-00 00:00:00','975','2023-01-25 12:14:13'),(142,'1','293','2023-01-17',1,'077','','5',40760.00,'77','','','5','BAYELSA 2','077',40760.00,'2023-01-21 08:25:17',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2023-01-25 12:11:03'),(143,'1','293','2023-01-18',1,'078','','5',1557320.00,'78','','','5','BAYELSA 2','078',1557321.00,'2023-01-21 08:27:13',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2023-01-25 12:11:03'),(144,'1','293','2023-01-18',1,'079','','5',1282335.00,'79','','','5','BAYELSA 2','079',1282334.00,'2023-01-21 08:28:13',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2023-01-25 12:11:03'),(145,'1','293','2023-01-19',1,'080','','5',1152230.00,'80','','','5','BAYELSA 2','080',1572230.00,'2023-01-21 08:30:03',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2023-01-25 12:11:02'),(146,'1','293','2023-01-19',1,'0800','','2',420000.00,'80','','','','','',0.00,'2023-01-21 08:30:58',5,'GEN CONS','971','','0000-00-00 00:00:00','975','2023-01-25 12:13:33'),(147,'1','293','2023-01-19',1,'081','','5',1688790.00,'81','','','5','BAYELSA 2','081',1877196.00,'2023-01-21 08:32:37',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2023-01-25 12:13:05'),(148,'1','293','2023-01-21',1,'0811','','10',176000.00,'81','','','6','BAYELSA 2','0811',0.00,'2023-01-21 08:34:25',5,'POS SALES','971','','0000-00-00 00:00:00','975','2023-02-01 14:59:35'),(149,'1','293','2023-01-20',1,'082','','5',833150.00,'82','','','6','BAYELSA 2','082',833148.00,'2023-01-21 08:36:17',5,'POS SALES','971','','0000-00-00 00:00:00','975','2023-02-01 15:08:14'),(150,'1','293','2023-01-21',1,'083','','5',1260175.00,'83','','','5','BAYELSA 2','083',1674576.00,'2023-01-23 11:06:27',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2023-01-25 12:13:05'),(151,'1','293','2023-01-21',1,'084','','5',1254465.00,'84','','','5','BAYELSA 2','084',1322464.00,'2023-01-23 11:07:56',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2023-01-25 12:13:05'),(152,'1','293','2023-01-21',1,'8483','','10',360000.00,'84/83','','','6','BAYELSA 2','8483',0.00,'2023-01-23 11:09:12',5,'POS SALES','971','','0000-00-00 00:00:00','975','2023-02-01 15:08:14'),(153,'1','293','2023-01-22',1,'085','','5',21210.00,'85','','','5','BAYELSA 2','085',889738.90,'2023-01-23 11:10:47',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2023-01-25 12:13:05'),(154,'1','293','2023-01-22',1,'8586','','10',828500.00,'85/86','','','6','BAYELSA 2','8586',0.00,'2023-01-23 11:12:28',5,'POS SALES','971','','0000-00-00 00:00:00','975','2023-02-01 15:08:14'),(157,'1','293','2023-01-24',1,'087','','10',2080000.00,'87','','','6','BAYELSA 2','012300',2184432.00,'2023-01-26 21:59:49',5,'POS SALES','971','','0000-00-00 00:00:00','975','2023-02-13 11:41:39'),(158,'1','293','2023-01-24',1,'0877','','5',104400.00,'87','','','5','BAYELSA 2','0877',0.00,'2023-01-26 22:01:56',5,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','975','2023-02-01 15:08:14'),(159,'1','293','2023-01-31',1,'0888','','5',118300.00,'88','','','5','BAYELSA 2','0888',186242.40,'2023-01-31 17:15:30',0,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(160,'1','293','2023-01-31',1,'0889','','2',42000.00,'88','','','','','',0.00,'2023-01-31 17:16:53',5,'CASH IMPRES , WEIGHT & MEASURES ','971','','0000-00-00 00:00:00','975','2023-02-13 11:42:20'),(161,'1','293','2023-01-22',1,'0850','','2',246000.00,'85','','','','','',0.00,'2023-01-31 17:34:10',5,'GEN CON','971','','0000-00-00 00:00:00','975','2023-02-13 11:42:20'),(162,'1','293','2023-02-06',1,'089','','10',1794740.00,'89','','','6','BAYELSA 2','089',1796689.70,'2023-02-07 10:39:50',5,'POS SALES','971','','0000-00-00 00:00:00','975','2023-02-13 11:42:20'),(163,'1','293','2023-02-06',1,'090','','10',2525640.00,'89/90','','','6','BAYELSA 2','090',730997.20,'2023-02-07 14:12:09',5,'POS SALES','971','','0000-00-00 00:00:00','975','2023-02-13 11:42:20'),(164,'1','293','2023-02-07',1,'091','','10',4031114.00,'91','','','6','BAYELSA 2','091',4031126.15,'2023-02-10 12:47:49',5,'POS SALES','971','','0000-00-00 00:00:00','975','2023-02-13 11:42:20'),(165,'1','293','2023-02-08',1,'9293','','10',6615075.00,'92/93','','','6','BAYELSA 2','9293',2576995.55,'2023-02-10 12:49:39',5,'POS SALES','971','','0000-00-00 00:00:00','975','2023-02-13 11:42:20'),(166,'1','293','2023-02-09',1,'9495','','10',3247250.00,'94/95','','','6','BAYELSA 2','9495',2309167.15,'2023-02-10 12:52:44',5,'POS SALES','971','','0000-00-00 00:00:00','975','2023-02-13 11:42:20'),(167,'1','293','2023-02-09',1,'095','','2',567000.00,'95','','','','','',567000.00,'2023-02-10 12:58:26',5,'GENERATOR CONS','971','','0000-00-00 00:00:00','975','2023-02-13 11:42:20'),(168,'1','293','2023-02-10',1,'096','','10',1498610.00,'96','','','6','BAYELSA 2','096',1498570.50,'2023-02-11 12:48:45',5,'POS SALE','971','','0000-00-00 00:00:00','975','2023-03-15 15:01:45'),(169,'1','293','2023-02-11',1,'097','','10',1271800.00,'97','','','6','BAYELSA 2','097',1271649.85,'2023-02-12 17:55:18',5,'POS SALES','971','','0000-00-00 00:00:00','975','2023-03-15 15:01:45'),(170,'1','293','2023-02-12',1,'098','','5',564500.00,'98','','','6','BAYELSA 2','098',564449.05,'2023-02-13 19:41:48',5,'PAYMENT ON ACCOUNT','971','975','2023-03-15 15:01:09','975','2023-03-15 15:01:45'),(171,'1','293','2023-02-13',1,'099','','5',1000000.00,'99','','','6','BAYELSA 2','1223',2150425.40,'2023-02-14 13:56:55',5,'POS SALES','971','975','2023-03-15 15:03:09','975','2023-03-15 15:05:49'),(172,'1','293','2023-01-13',1,'071000','','5',413650.00,'71','','','5','BAYELSA 2','071000',424848.00,'2023-02-14 14:07:58',0,'PAYMENT ON ACCOUNT','971','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(173,'1','293','2023-02-14',1,'100','','5',1871070.00,'100','','','6','BAYELSA 2','6498',2534402.70,'2023-02-15 13:33:23',5,'POS SALES','971','975','2023-03-15 15:04:11','975','2023-03-15 15:05:49'),(174,'1','293','2023-02-15',1,'101','','10',1286741.00,'101','','','6','BAYELSA 2','101',1286741.95,'2023-02-22 19:22:53',5,'POS SALES','971','','0000-00-00 00:00:00','975','2023-03-15 15:05:49'),(175,'1','293','2023-02-18',1,'102','','10',142860.00,'102','','','6','BAYELSA 2','102',142860.00,'2023-02-22 19:26:19',5,'POS SALES','971','','0000-00-00 00:00:00','975','2023-03-15 15:05:49'),(176,'1','293','2023-02-26',1,'103','','10',365940.00,'103','','','6','BAYELSA 2','103',365941.40,'2023-02-26 16:02:38',5,'POS SALES','971','','0000-00-00 00:00:00','975','2023-03-15 15:05:49'),(177,'1','293','2023-02-27',1,'104','','10',1638525.00,'104','','','6','BAYELSA 2','104',1638525.01,'2023-02-28 18:21:49',5,'POS SALES','971','','0000-00-00 00:00:00','975','2023-03-15 15:10:33'),(178,'1','293','2023-02-27',1,'105','','10',1675360.00,'105','','','6','BAYELSA 2','105',1675361.00,'2023-02-28 18:23:05',5,'POS SALES','971','','0000-00-00 00:00:00','975','2023-03-15 15:10:33'),(179,'1','293','2023-02-28',1,'106','','10',322070.00,'106','','','6','BAYELSA 2','106',322066.00,'2023-02-28 18:24:27',5,'POS SALES','971','','0000-00-00 00:00:00','975','2023-03-15 15:10:33'),(180,'1','293','2023-03-01',1,'108/109','','5',3937725.00,'108','','','6','BAYELSA 2','5874',3867212.35,'2023-03-02 17:03:38',5,'POS SALES','971','975','2023-03-15 15:06:52','975','2023-03-15 15:10:33'),(181,'1','293','2023-03-02',1,'111','','5',4911510.00,'111','','','6','BAYELSA 2','111',4982042.30,'2023-03-04 13:00:06',5,'POS SALES','971','975','2023-03-09 12:25:14','975','2023-03-15 15:10:33'),(182,'1','293','2023-03-03',1,'113/112','','5',4072091.00,'113/112','','','6','BAYELSA 2','113/112',4071939.00,'2023-03-05 15:08:36',5,'POS SALES','971','975','2023-03-09 12:27:58','975','2023-03-15 15:10:33'),(183,'1','293','2023-03-04',1,'115','','5',5587258.00,'115/115','','','6','BAYELSA 2','4522',5587221.35,'2023-03-06 17:22:30',5,'POS SALES','971','975','2023-03-15 15:11:31','975','2023-03-15 15:15:48'),(184,'1','293','2023-03-05',1,'116','','5',3974788.00,'116/117','','','6','BAYELSA 2','116',3974923.95,'2023-03-07 11:03:19',5,'POS SALES','971','975','2023-03-09 12:35:21','975','2023-03-15 15:15:48'),(185,'1','293','2023-03-06',1,'119','','10',4292014.00,'119','','','6','BAYELSA 2','119',4292014.15,'2023-03-09 12:27:10',5,'POS SALES','971','','0000-00-00 00:00:00','975','2023-03-15 15:15:48'),(186,'1','293','2023-03-07',1,'121','','5',4256710.00,'121','','','6','BAYELSA 2','7854',4785211.00,'2023-03-09 12:40:39',5,'POS SALES','971','975','2023-03-15 15:13:58','975','2023-03-15 15:15:48'),(187,'1','293','2023-03-07',1,'120','','2',528500.00,'120','','','','','',0.00,'2023-03-09 12:43:21',0,'GENERATOR CONSUMPTION','971','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(188,'1','293','2023-03-08',1,'122','','10',4851389.00,'122','','','6','BAYELSA 2','122',5051896.05,'2023-03-09 12:50:22',5,'POS SALES','971','','0000-00-00 00:00:00','975','2023-03-15 15:16:53'),(189,'1','293','2023-03-08',1,'122','','2',200500.00,'122','','','','','',0.00,'2023-03-09 12:51:54',0,'GENERATOR CON','971','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(190,'1','293','2023-03-09',1,'123','','5',5993981.00,'123','','','6','BAYELSA 2','123',5987109.10,'2023-03-10 10:31:09',5,'POS SALES','971','975','2023-03-14 14:57:54','975','2023-03-15 15:16:53'),(191,'1','293','2023-03-10',1,'125','','5',6454239.00,'125','','','6','BAYELSA 2','125',6592769.90,'2023-03-11 13:19:02',0,'POS SALES','971','975','2023-03-14 15:00:22','','0000-00-00 00:00:00'),(192,'1','293','2023-03-10',1,'125','','2',131500.00,'125','','','','','',0.00,'2023-03-11 13:20:06',0,'HAULAGE SERVICE \r\nRAN 935 ZG','971','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(193,'1','293','2023-03-11',1,'127','','5',5866248.00,'127','','','6','BAYELSA 2','127',5985875.35,'2023-03-12 12:10:21',0,'POS SALES','971','975','2023-03-14 15:05:40','','0000-00-00 00:00:00'),(194,'1','293','2023-03-11',1,'0127','','2',131500.00,'127','','','','','',0.00,'2023-03-12 12:11:23',0,'HAULAGE SERVICE \r\nRAN 965 XA','971','975','2023-03-14 15:04:43','','0000-00-00 00:00:00'),(195,'1','293','2023-03-12',1,'129','','5',2821049.00,'129','','','6','BAYELSA 2','46523',2833630.00,'2023-03-14 14:59:17',0,'POS SALES','971','975','2023-03-15 15:12:04','','0000-00-00 00:00:00'),(196,'1','293','2023-03-13',1,'131','','5',5330104.00,'131','','','6','BAYELSA 2','7955',5306708.90,'2023-03-15 07:16:20',0,'POS SALES','971','975','2023-03-15 15:13:19','','0000-00-00 00:00:00'),(197,'1','293','2023-03-14',1,'135','','10',5734845.00,'135','','','6','BAYELSA 2','135',0.00,'2023-03-16 11:24:37',0,'POS SALES','971','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(198,'1','293','2023-03-15',1,'136','','10',8560340.00,'136','','','6','BAYELSA 2','136',0.00,'2023-03-16 11:27:49',0,'POS SALES','971','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(199,'1','293','2023-03-16',1,'139','','10',5955961.00,'139','','','6','BAYELSA 2','139',0.00,'2023-03-17 07:59:18',0,'POS SALES','971','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(200,'1','293','2023-03-17',1,'141','','10',5687881.00,'141/140','','','6','BAYELSA 2','141',0.00,'2023-03-18 10:37:14',0,'POS SALES','971','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(201,'1','293','2023-03-17',1,'0141','','2',128500.00,'0141','','','','','',0.00,'2023-03-18 10:39:02',0,'HAULAGE SERVICE \r\nRAN 829 XA','971','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(202,'1','293','2023-03-16',1,'0168','','2',609000.00,'138','','','','','',0.00,'2023-03-18 10:40:34',0,'CASH TO CHAIRMAN','971','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(203,'1','293','2023-03-14',1,'0135','','2',391000.00,'135','','','','','',0.00,'2023-03-18 10:43:54',0,'CASH TO CHAIRMAN ','971','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `purchases_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_receptions`
--

DROP TABLE IF EXISTS `purchases_receptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_receptions` (
  `bridge_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `purchase_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `loadingdate` datetime NOT NULL,
  `loadingpoint` varchar(100) DEFAULT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `received` decimal(20,2) NOT NULL,
  `distributed` decimal(20,2) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `vessel` varchar(50) NOT NULL,
  `drivername` varchar(30) NOT NULL,
  `driverphone` varchar(30) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`bridge_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`supplier_id`,`loadingdate`,`quantity`,`waybill`,`meterno`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`purchase_id`),
  KEY `truck_id` (`tank_id`)
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_receptions`
--

LOCK TABLES `purchases_receptions` WRITE;
/*!40000 ALTER TABLE `purchases_receptions` DISABLE KEYS */;
INSERT INTO `purchases_receptions` VALUES (1,'1',1,'293',1,1,'2022-11-02 00:00:00','DEPORT',48000.00,48000.00,0.00,'0000','','1','BCH 747 XA','UMAR','','Discharge of pms ',5,'2022-11-02 16:31:47','971','0000-00-00 00:00:00','','2022-11-02 16:34:03','971'),(2,'1',2,'293',1,1,'2022-11-02 00:00:00','DEPORT',50000.00,50000.00,0.00,'0000','','2','RAN 825 XA','haruna','','Discharge of pms ',5,'2022-11-02 22:46:52','971','0000-00-00 00:00:00','','2022-11-02 22:47:20','971'),(3,'1',3,'293',1,1,'2022-11-02 00:00:00','DEPORT',50000.00,50000.00,0.00,'0000','','2','KMC 579 ZU','isa','','Discharge of pms ',5,'2022-11-02 22:48:14','971','0000-00-00 00:00:00','','2022-11-02 22:48:41','971'),(4,'1',4,'293',1,1,'2022-11-02 00:00:00','DEPORT',50000.00,50000.00,0.00,'0000','','1','RAN 941 XA','isa','','Discharge of pms ',5,'2022-11-02 22:49:50','971','0000-00-00 00:00:00','','2022-11-02 22:50:18','971'),(5,'1',5,'293',1,1,'2022-11-16 00:00:00','DEPORT',45000.00,45000.00,0.00,'0000','','1','TRN 203 ZG','AHMAD','','Discharge of pms ',5,'2022-11-16 17:39:33','971','0000-00-00 00:00:00','','2022-11-16 17:39:49','971'),(6,'1',6,'293',1,1,'2022-11-16 00:00:00','DEPORT',45000.00,45000.00,0.00,'0000','','2','TRN 224 ZQ','isa','','Discharge of pms ',5,'2022-11-16 17:40:29','971','0000-00-00 00:00:00','','2022-11-16 17:40:45','971'),(7,'1',7,'293',1,1,'2022-11-26 00:00:00','DEPORT',30000.00,30000.00,0.00,'0000','','1','KMC 691 ZE','BAGOBIRI','','Discharge of pms ',5,'2022-11-26 10:37:06','971','0000-00-00 00:00:00','','2022-11-26 10:37:28','971'),(8,'1',7,'293',1,1,'2022-11-26 00:00:00','DEPORT',30000.00,30000.00,0.00,'0000','','2','KMC 691 ZE','BAGOBIRI','','Discharge of pms ',5,'2022-11-26 10:37:06','971','0000-00-00 00:00:00','','2022-11-26 10:37:28','971'),(9,'1',8,'293',1,1,'2022-12-01 00:00:00','DEPORT',45000.00,45000.00,0.00,'0000','','1','KKM 196 XA','isa','','Discharge of pms ',5,'2022-12-01 08:28:14','971','0000-00-00 00:00:00','','2022-12-01 08:29:25','971'),(10,'1',9,'293',1,1,'2022-12-01 00:00:00','DEPORT',45000.00,45000.00,0.00,'0000','','2','RAN 817 XA','UMAR','','Discharge of pms ',5,'2022-12-01 08:29:02','971','0000-00-00 00:00:00','','2022-12-01 08:29:39','971'),(11,'1',10,'293',1,1,'2022-12-01 00:00:00','DEPORT',50000.00,50000.00,0.00,'0000','','1','GWL 538 YJ','AHMAD','','Discharge of pms ',5,'2022-12-01 09:18:27','971','0000-00-00 00:00:00','','2022-12-01 09:18:42','971'),(12,'1',11,'293',1,1,'2022-12-01 00:00:00','DEPORT',51000.00,51000.00,0.00,'0000','','2','RAN 902 XA','AWWAL','','Discharge of pms ',5,'2022-12-01 09:19:32','971','0000-00-00 00:00:00','','2022-12-01 09:19:46','971'),(13,'1',12,'293',1,1,'2022-12-01 00:00:00','DEPORT',18000.00,18000.00,0.00,'0000','','1','RAN 899 XA','DOGO','','Discharge of pms ',5,'2022-12-01 10:17:26','971','0000-00-00 00:00:00','','2022-12-01 10:17:44','971'),(14,'1',13,'293',1,1,'2022-12-17 00:00:00','DEPORT',33000.00,33000.00,0.00,'0000','','1','TRN 224 ZG','YAHUZA','','DISCHARGE OF PMS ',5,'2022-12-17 11:42:25','971','0000-00-00 00:00:00','','2022-12-17 11:42:45','971'),(15,'1',13,'293',1,1,'2022-12-17 00:00:00','DEPORT',12000.00,12000.00,0.00,'0000','','2','TRN 224 ZG','YAHUZA','','DISCHARGE OF PMS ',5,'2022-12-17 11:42:25','971','0000-00-00 00:00:00','','2022-12-17 11:42:45','971'),(16,'1',14,'293',1,1,'2022-12-20 00:00:00','DEPORT',18000.00,18000.00,0.00,'0000','','2','RAN 545 XA','ZAKARI','','DISCHARGE OF PMS ',5,'2022-12-20 11:19:02','971','0000-00-00 00:00:00','','2022-12-20 11:19:20','971'),(17,'1',15,'293',1,1,'2022-12-23 00:00:00','DEPORT',23000.00,23000.00,0.00,'0000','','1','KMC 577 ZU','AUWAL','','DISCHARGE OF PMS ',5,'2022-12-23 18:39:05','971','0000-00-00 00:00:00','','2022-12-23 18:40:17','971'),(18,'1',15,'293',1,1,'2022-12-23 00:00:00','DEPORT',22000.00,22000.00,0.00,'0000','','2','KMC 577 ZU','AUWAL','','DISCHARGE OF PMS ',5,'2022-12-23 18:39:05','971','0000-00-00 00:00:00','','2022-12-23 18:40:17','971'),(19,'1',16,'293',1,1,'2023-01-08 00:00:00','DEPORT',22000.00,22000.00,0.00,'0000','','2','kmc 573zu','MUKHTAR','08032135350','DISCHARGE OF PMS ',5,'2023-01-08 17:13:40','971','0000-00-00 00:00:00','','2023-01-08 17:14:21','971'),(20,'1',17,'293',1,1,'2023-01-11 00:00:00','DEPORT',22000.00,22000.00,0.00,'0000','','1','KMC 573ZU','MUKHTAR','08032135350','DISCHARGE OF PMS',5,'2023-01-11 13:32:08','971','0000-00-00 00:00:00','','2023-01-13 15:49:58','971'),(21,'1',18,'293',1,1,'2023-01-13 00:00:00','DEPORT',15000.00,15000.00,0.00,'0000','','1','RAN545XA','SHAMSU','0701101121','DISCHARGE OF PMS ',5,'2023-01-13 15:18:09','971','0000-00-00 00:00:00','','2023-01-13 15:51:15','971'),(22,'1',18,'293',1,1,'2023-01-13 00:00:00','DEPORT',30000.00,30000.00,0.00,'0000','','2','RAN545XA','SHAMSU','0701101121','DISCHARGE OF PMS ',5,'2023-01-13 15:18:09','971','0000-00-00 00:00:00','','2023-01-13 15:50:32','971'),(23,'1',19,'293',1,1,'2023-01-18 00:00:00','DEPORT',23000.00,23000.00,0.00,'0000','','2','kmc 573zu','MUKHTAR','08032135350','DISCHARGE OF PMS ',5,'2023-01-18 10:17:39','971','0000-00-00 00:00:00','','2023-01-19 16:04:50','971'),(24,'1',21,'293',1,1,'2023-01-24 00:00:00','DEPORT',26500.00,26500.00,0.00,'0000','','1','TRN 935 ZG','GALI','','DISCHARGE OF PMS ',5,'2023-01-24 12:24:23','971','0000-00-00 00:00:00','','2023-01-24 12:24:46','971'),(25,'1',21,'293',1,1,'2023-01-24 00:00:00','DEPORT',13500.00,13500.00,0.00,'0000','','2','TRN 935 ZG','GALI','','DISCHARGE OF PMS ',5,'2023-01-24 12:24:23','971','0000-00-00 00:00:00','','2023-01-24 12:24:46','971'),(26,'1',22,'293',1,1,'2023-02-07 00:00:00','DEPORT',17000.00,17000.00,0.00,'0000','','2','TRN 186 ZY','ADAM','','DISCHARGE OF PMS ',5,'2023-02-07 08:51:41','971','0000-00-00 00:00:00','','2023-02-07 08:52:04','971'),(27,'1',23,'293',1,1,'2023-02-08 00:00:00','DEPORT',16500.00,16500.00,0.00,'0000','','1','FGE 980 ZY','bello','','DISCHARGE OF PMS ',5,'2023-02-08 10:57:26','971','0000-00-00 00:00:00','','2023-02-08 10:58:02','971'),(28,'1',23,'293',1,1,'2023-02-08 00:00:00','DEPORT',16500.00,16500.00,0.00,'0000','','2','FGE 980 ZY','bello','','DISCHARGE OF PMS ',5,'2023-02-08 10:57:26','971','0000-00-00 00:00:00','','2023-02-08 10:58:02','971'),(29,'1',24,'293',1,1,'2023-02-08 00:00:00','DEPORT',45000.00,45000.00,0.00,'0000','','1','TRN 22 YZ','BABANGIDA','','DISCHARGE OF PMS ',5,'2023-02-08 15:27:04','971','0000-00-00 00:00:00','','2023-02-08 15:28:52','971'),(30,'1',24,'293',1,1,'2023-02-08 00:00:00','DEPORT',15000.00,15000.00,0.00,'0000','','2','TRN 22 YZ','BABANGIDA','','DISCHARGE OF PMS ',5,'2023-02-08 15:27:04','971','0000-00-00 00:00:00','','2023-02-08 15:28:51','971'),(31,'1',23,'293',1,1,'2023-02-09 00:00:00','DEPORT',17000.00,17000.00,0.00,'0000','','2','FGE 980 ZY','BELLO','','DISCHARGE OF PMS ',5,'2023-02-09 12:20:06','971','0000-00-00 00:00:00','','2023-02-09 12:20:48','971'),(32,'1',25,'293',1,1,'2023-03-01 00:00:00','DEPORT',17500.00,17500.00,0.00,'0000','','2','RAN 946 XA','GALI','','DISCHARGE OF PMS ',5,'2023-03-01 15:29:28','971','0000-00-00 00:00:00','','2023-03-01 15:29:49','971'),(33,'1',26,'293',1,1,'2023-03-01 00:00:00','DEPORT',17000.00,17000.00,0.00,'0000','','1','RAN 425 XA','GALI','','DISCHARGE OF PMS ',5,'2023-03-01 15:31:16','971','0000-00-00 00:00:00','','2023-03-01 15:31:38','971'),(34,'1',26,'293',1,1,'2023-03-01 00:00:00','DEPORT',33000.00,33000.00,0.00,'0000','','2','RAN 425 XA','GALI','','DISCHARGE OF PMS ',5,'2023-03-01 15:31:16','971','0000-00-00 00:00:00','','2023-03-01 15:31:37','971'),(35,'1',27,'293',1,1,'2023-03-04 00:00:00','DEPORT',50000.00,50000.00,0.00,'0000','','1','ABS 700 XA','SHAMSU','','DISCHARGE OF PMS ',5,'2023-03-04 12:51:10','971','0000-00-00 00:00:00','','2023-03-04 12:51:28','971'),(36,'1',28,'293',1,1,'2023-03-04 00:00:00','DEPORT',50000.00,50000.00,0.00,'0000','','2','NSR 531 ZQ','SHAMSU','','DISCHARGE OF PMS ',5,'2023-03-04 12:52:05','971','0000-00-00 00:00:00','','2023-03-04 12:52:25','971'),(37,'1',29,'293',1,1,'2023-03-09 00:00:00','DEPORT',20000.00,20000.00,0.00,'0000','','1','RAN 425 XA','AUWAL','','DISCHARGE OF PMS ',5,'2023-03-09 12:10:53','971','0000-00-00 00:00:00','','2023-03-09 12:11:13','971'),(38,'1',29,'293',1,1,'2023-03-09 00:00:00','DEPORT',30000.00,30000.00,0.00,'0000','','2','RAN 425 XA','AUWAL','','DISCHARGE OF PMS ',5,'2023-03-09 12:10:53','971','0000-00-00 00:00:00','','2023-03-09 12:11:13','971'),(39,'1',30,'293',1,1,'2023-03-09 00:00:00','DEPORT',50000.00,50000.00,0.00,'0000','','1','RAN 425 XA','SHAMSU','','DISCHARGE OF PMS ',5,'2023-03-09 12:12:41','971','0000-00-00 00:00:00','','2023-03-09 12:13:16','971'),(40,'1',31,'293',1,1,'2023-03-09 00:00:00','DEPORT',45000.00,45000.00,0.00,'0000','','2','RAN 829 XA','ZAKARI','','DISCHARGE OF PMS ',5,'2023-03-09 12:14:02','971','0000-00-00 00:00:00','','2023-03-09 12:52:19','971'),(41,'1',32,'293',1,1,'2023-03-10 00:00:00','DEPORT',40000.00,40000.00,0.00,'0000','','1','TRN 935 ZG','AUWAL','','DISCHARGE OF PMS ',5,'2023-03-10 18:13:23','971','0000-00-00 00:00:00','','2023-03-10 18:13:50','971'),(42,'1',33,'293',1,1,'2023-03-13 00:00:00','DEPORT',30000.00,30000.00,0.00,'0000','','1','RAN 965 XA','SANI ','08032135350','DISCHARGE OF PMS ',5,'2023-03-13 14:14:00','971','0000-00-00 00:00:00','','2023-03-13 14:14:27','971'),(43,'1',33,'293',1,1,'2023-03-13 00:00:00','DEPORT',20000.00,20000.00,0.00,'0000','','2','RAN 965 XA','SANI ','08032135350','DISCHARGE OF PMS ',5,'2023-03-13 14:14:00','971','0000-00-00 00:00:00','','2023-03-13 14:14:27','971'),(44,'1',34,'293',1,1,'2023-03-15 00:00:00','DEPORT',25000.00,25000.00,0.00,'0000','','1','RAN 829 XA','DAYYABU','08062440364','DISCHARGE OF PMS ',5,'2023-03-15 13:16:55','971','0000-00-00 00:00:00','','2023-03-15 13:19:17','971'),(45,'1',34,'293',1,1,'2023-03-15 00:00:00','DEPORT',20000.00,20000.00,0.00,'0000','','2','RAN 829 XA','DAYYABU','08062440364','DISCHARGE OF PMS ',5,'2023-03-15 13:16:55','971','0000-00-00 00:00:00','','2023-03-15 13:19:17','971');
/*!40000 ALTER TABLE `purchases_receptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports`
--

DROP TABLE IF EXISTS `reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `type` varchar(20) NOT NULL,
  `sql` text NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`report_id`),
  KEY `companycode` (`company_id`,`name`,`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports`
--

LOCK TABLES `reports` WRITE;
/*!40000 ALTER TABLE `reports` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_fields`
--

DROP TABLE IF EXISTS `reports_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(20) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `fieldname` varchar(50) NOT NULL,
  `order` int NOT NULL,
  `visibility` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`report_id`,`field_id`,`order`,`visibility`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_fields`
--

LOCK TABLES `reports_fields` WRITE;
/*!40000 ALTER TABLE `reports_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_filters`
--

DROP TABLE IF EXISTS `reports_filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_filters` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(50) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `filter_id` int NOT NULL AUTO_INCREMENT,
  `criteria` varchar(20) NOT NULL,
  `value` varchar(100) NOT NULL,
  PRIMARY KEY (`filter_id`),
  KEY `companycode` (`company_id`,`report_id`),
  KEY `field_id` (`field_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_filters`
--

LOCK TABLES `reports_filters` WRITE;
/*!40000 ALTER TABLE `reports_filters` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_filters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_customers`
--

DROP TABLE IF EXISTS `retail_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_customers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`name`,`phone`,`email`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_customers`
--

LOCK TABLES `retail_customers` WRITE;
/*!40000 ALTER TABLE `retail_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory`
--

DROP TABLE IF EXISTS `retail_inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` int NOT NULL,
  `qtyout` int NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory`
--

LOCK TABLES `retail_inventory` WRITE;
/*!40000 ALTER TABLE `retail_inventory` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_balances`
--

DROP TABLE IF EXISTS `retail_inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_balances`
--

LOCK TABLES `retail_inventory_balances` WRITE;
/*!40000 ALTER TABLE `retail_inventory_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_costs`
--

DROP TABLE IF EXISTS `retail_inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_costs`
--

LOCK TABLES `retail_inventory_costs` WRITE;
/*!40000 ALTER TABLE `retail_inventory_costs` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products`
--

DROP TABLE IF EXISTS `retail_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`name`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `parent_id` (`parent_id`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products`
--

LOCK TABLES `retail_products` WRITE;
/*!40000 ALTER TABLE `retail_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_prices`
--

DROP TABLE IF EXISTS `retail_products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_prices`
--

LOCK TABLES `retail_products_prices` WRITE;
/*!40000 ALTER TABLE `retail_products_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_reconciliations`
--

DROP TABLE IF EXISTS `retail_products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_reconciliations`
--

LOCK TABLES `retail_products_reconciliations` WRITE;
/*!40000 ALTER TABLE `retail_products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_purchases`
--

DROP TABLE IF EXISTS `retail_purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_purchases`
--

LOCK TABLES `retail_purchases` WRITE;
/*!40000 ALTER TABLE `retail_purchases` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales`
--

DROP TABLE IF EXISTS `retail_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `saledate` date NOT NULL,
  `customer_id` varchar(20) NOT NULL DEFAULT '',
  `customer_name` varchar(50) NOT NULL,
  `customer_phone` varchar(30) NOT NULL,
  `quantity_kg` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `payment_method` varchar(10) NOT NULL,
  `payment_account_type` varchar(20) NOT NULL,
  `payment_account_id` varchar(20) NOT NULL,
  `paid` decimal(20,2) DEFAULT NULL,
  `change` decimal(20,2) DEFAULT '0.00',
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`customer_name`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `payment_method` (`payment_method`,`payment_account_type`,`payment_account_id`),
  KEY `customer_id` (`customer_id`),
  KEY `change` (`change`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales`
--

LOCK TABLES `retail_sales` WRITE;
/*!40000 ALTER TABLE `retail_sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_items`
--

DROP TABLE IF EXISTS `retail_sales_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `product_type` varchar(10) NOT NULL,
  `product_name` varchar(100) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `quantity_2` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `parent_cost` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`sale_id`,`product_id`,`rate`,`quantity`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`product_type`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `parent_id` (`parent_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_items`
--

LOCK TABLES `retail_sales_items` WRITE;
/*!40000 ALTER TABLE `retail_sales_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_payments`
--

DROP TABLE IF EXISTS `retail_sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_payments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `payment_method` varchar(50) NOT NULL,
  `account_type` varchar(10) DEFAULT NULL,
  `account_id` bigint DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`sale_id`,`payment_method`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`account_type`),
  KEY `parent_id` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_payments`
--

LOCK TABLES `retail_sales_payments` WRITE;
/*!40000 ALTER TABLE `retail_sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales`
--

DROP TABLE IF EXISTS `sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `is_credit` int NOT NULL DEFAULT '0',
  `saledate` date NOT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `paid` int NOT NULL,
  `details` text NOT NULL,
  `ledger_notes` varchar(150) DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`product_id`,`customer_id`,`rate`,`quantity`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`is_credit`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales`
--

LOCK TABLES `sales` WRITE;
/*!40000 ALTER TABLE `sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_daily`
--

DROP TABLE IF EXISTS `sales_daily`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_daily` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `saledate` date NOT NULL,
  `average` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `target` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`average`,`saledate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_daily`
--

LOCK TABLES `sales_daily` WRITE;
/*!40000 ALTER TABLE `sales_daily` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_daily` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions`
--

DROP TABLE IF EXISTS `sales_distributions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions` (
  `distribution_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `sale_id` int NOT NULL,
  `purchase_id` varchar(20) NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `loadingdate` date NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `destination` varchar(50) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `truckno` varchar(20) NOT NULL,
  `drivername` varchar(50) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`distribution_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`loadingdate`,`quantity`,`destination`,`waybill`,`meterno`,`nozzle_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`tank_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `truckno` (`truckno`),
  KEY `purchase_id_2` (`purchase_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions`
--

LOCK TABLES `sales_distributions` WRITE;
/*!40000 ALTER TABLE `sales_distributions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_delivery`
--

DROP TABLE IF EXISTS `sales_distributions_delivery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_delivery` (
  `delivery_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `distribution_id` int NOT NULL,
  `sale_id` int NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `quantity` int NOT NULL,
  `truck_id` int NOT NULL,
  `deliveredon` date NOT NULL,
  `details` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`delivery_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`quantity`,`thedate`,`createdby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`truck_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `distribution_id` (`distribution_id`),
  KEY `deliveredon` (`deliveredon`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_delivery`
--

LOCK TABLES `sales_distributions_delivery` WRITE;
/*!40000 ALTER TABLE `sales_distributions_delivery` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_delivery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_trucks`
--

DROP TABLE IF EXISTS `sales_distributions_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_trucks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sale_id` varchar(20) NOT NULL,
  `distribution_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `bridge_id` varchar(20) NOT NULL,
  `truck_id` varchar(20) NOT NULL,
  `driver_id` varchar(20) NOT NULL,
  `quantity` int NOT NULL,
  `destination` varchar(150) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `companycode` (`company_id`,`distribution_id`,`truck_id`),
  KEY `sale_id` (`sale_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_trucks`
--

LOCK TABLES `sales_distributions_trucks` WRITE;
/*!40000 ALTER TABLE `sales_distributions_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_fueltickets`
--

DROP TABLE IF EXISTS `sales_fueltickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_fueltickets` (
  `ticket_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `ticketdate` date NOT NULL,
  `code` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `allowance` decimal(10,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `truck_number` varchar(20) NOT NULL,
  `truck_capacity` int NOT NULL,
  `truck_provider` varchar(50) NOT NULL,
  `truck_from` varchar(50) NOT NULL,
  `truck_destination` varchar(50) NOT NULL,
  `driver_name` varchar(50) NOT NULL,
  `driver_phone` varchar(50) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`ticket_id`),
  KEY `companycode` (`company_id`,`ticketdate`,`product_id`,`truck_number`,`rate`,`quantity`,`status`),
  KEY `paid` (`truck_provider`),
  KEY `invoice` (`code`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_fueltickets`
--

LOCK TABLES `sales_fueltickets` WRITE;
/*!40000 ALTER TABLE `sales_fueltickets` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_fueltickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_payments`
--

DROP TABLE IF EXISTS `sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `customer_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`customer_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_payments`
--

LOCK TABLES `sales_payments` WRITE;
/*!40000 ALTER TABLE `sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_cashbacks`
--

DROP TABLE IF EXISTS `shifts_cashbacks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_cashbacks` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `regno` varchar(100) DEFAULT NULL,
  `cashdate` date NOT NULL,
  `driver` varchar(100) DEFAULT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`cashdate`,`driver`,`customer_id`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`regno`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_cashbacks`
--

LOCK TABLES `shifts_cashbacks` WRITE;
/*!40000 ALTER TABLE `shifts_cashbacks` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_cashbacks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_remittance`
--

DROP TABLE IF EXISTS `shifts_remittance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_remittance` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `paymentdate` date NOT NULL,
  `method` int DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paidby` varchar(50) DEFAULT NULL,
  `paidto` varchar(100) DEFAULT NULL,
  `bank` bigint unsigned DEFAULT NULL,
  `depositor` varchar(100) DEFAULT NULL,
  `teller` varchar(100) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  `reversed_at` datetime DEFAULT NULL,
  `reversed_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`paymentdate`,`method`,`bank`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_remittance`
--

LOCK TABLES `shifts_remittance` WRITE;
/*!40000 ALTER TABLE `shifts_remittance` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_remittance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers`
--

DROP TABLE IF EXISTS `suppliers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers` (
  `supplier_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`supplier_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers`
--

LOCK TABLES `suppliers` WRITE;
/*!40000 ALTER TABLE `suppliers` DISABLE KEYS */;
INSERT INTO `suppliers` VALUES (1,'1','293','AA RANO NIGERIA LTD','MUHAMMAD ABDUL SULE','0803540199','mrmohasul@gmail.com','KANO','KANO','No 7 Maiduguri Road,Opposite NNPC Depot. Kano Nigeria','Nigeria',0.00,0.00,'0000-00-00','2022-10-18 17:07:52',5,'178','2022-10-18 17:07:52','178');
/*!40000 ALTER TABLE `suppliers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers_status`
--

DROP TABLE IF EXISTS `suppliers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `supplier_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers_status`
--

LOCK TABLES `suppliers_status` WRITE;
/*!40000 ALTER TABLE `suppliers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `suppliers_status` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-03-21  2:54:23
