-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_292
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_292`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_292` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_292`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,8000,'',0,'24','1','292','PURCHASES','','2022-10-18 17:05:47',5,0.00,0.00,'','178','2022-10-18 17:05:47','178',0,0),(2,500,'',0,'6.1','1','292','CASH','','2022-10-18 17:05:55',5,0.00,0.00,'','178','2022-10-18 17:05:55','178',0,0),(3,7000,'',0,'20','1','292','SALES','','2022-10-18 17:06:14',5,0.00,0.00,'','178','2022-10-18 17:06:14','178',0,0),(4,8001,'',0,'24','1','292','SALARIES','','2022-10-18 17:06:25',5,0.00,0.00,'','178','2022-10-18 17:06:25','178',0,0),(5,2500,'',0,'2','1','292','UBA 1011654947','','2022-11-14 08:58:20',5,0.00,0.00,'','975','2022-11-14 08:58:20','975',0,0),(6,2501,'',0,'2','1','292','UBA POS','','2022-11-14 08:58:58',5,0.00,0.00,'','975','2022-11-14 08:58:58','975',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','1','292','DRIVER\'S SHORT','DRIVER','080******123','ds@gmail.com','AKWA IBOM','KWARA','AKWA IBOM 2','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-02 15:37:45',5,'975','2022-11-02 15:37:45','975'),(2,'','1','292','NIGERIA POLICE FORCE (ELECTION','DSP EMMANUEL INYANG','07034233416','dopstransport@gmail.com','UYO','AKWA-IBOM STATE','UYO','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-21 17:30:39',5,'975','2023-02-21 17:30:39','975');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','292','1',1,'5','PUMP 1',37768.82,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-19 13:56:39','178'),('1','292','1',2,'5','PUMP 2',53272.11,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-19 13:57:16','178'),('1','292','1',3,'5','PUMP 3',54095.77,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-19 13:57:41','178'),('1','292','1',4,'5','PUMP 4',41577.95,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-19 13:58:09','178'),('1','292','2',5,'5','PUMP 5',70389.45,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-19 13:58:58','178'),('1','292','2',6,'5','PUMP 6',55966.36,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-19 13:59:45','178'),('1','292','3',7,'5','PUMP 7',50388.82,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-19 14:00:10','178'),('1','292','3',8,'5','PUMP 8',72907.94,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-19 14:00:36','178'),('1','292','4',9,'5','AGO PUMP 1',1161927.00,'DISPENSING AGO','',NULL,NULL,'',5,'2022-11-15 17:08:17','975'),('1','292','5',10,'5','DPK PUMP',0.00,'DISPENSING DPK',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','292',1,'MORNING SHIFT','2022-10-03','2022-11-02 16:29:45','2022-11-03 16:29:45','967',483584.40,483584.40,'967','2022-11-03 16:50:00','648','2022-11-06 14:22:42',10,0),('1','292',2,'MORNING SHIFT ','2022-10-04','2022-11-06 19:16:12','2022-11-07 19:16:12','967',866050.20,866050.20,'967','2022-11-06 20:00:18','648','2022-11-06 20:52:04',10,0),('1','292',3,'MORNING SHIFT ','2022-10-05','2022-11-06 21:05:59','2022-11-07 21:05:59','967',978663.60,978663.60,'967','2022-11-06 21:09:22','648','2022-11-06 21:15:24',10,0),('1','292',4,'MORNING SHIFT ','2022-10-06','2022-11-06 21:55:14','2022-11-07 21:55:14','967',916713.00,916713.00,'967','2022-11-06 22:02:02','648','2022-11-07 08:26:57',10,0),('1','292',5,'MORNING SHIFT ','2022-10-07','2022-11-07 09:26:51','2022-11-08 09:26:51','967',849182.40,849182.40,'967','2022-11-07 09:31:16','648','2022-11-08 04:18:27',10,0),('1','292',6,'MORNING SHIFT ','2022-10-08','2022-11-08 12:03:27','2022-11-09 12:03:27','967',1086078.60,1086078.60,'967','2022-11-08 12:09:07','648','2022-11-08 16:47:36',10,0),('1','292',7,'MORNING SHIFT','2022-10-09','2022-11-08 19:22:50','2022-11-09 19:22:50','967',863481.60,863481.60,'967','2022-11-08 19:27:31','648','2022-11-08 23:16:44',10,0),('1','292',8,'MORNING SHIFT ','2022-10-10','2022-11-09 06:25:11','2022-11-10 06:25:11','967',1120401.00,1120401.00,'967','2022-11-09 06:29:11','648','2022-11-09 19:27:19',10,0),('1','292',9,'MORNING SHIFT ','2022-10-11','2022-11-09 19:51:45','2022-11-10 19:51:45','967',495586.80,495586.80,'967','2022-11-09 19:54:11','648','2022-11-10 13:00:19',10,0),('1','292',10,'MORNING SHIFT ','2022-10-12','2022-11-10 15:09:16','2022-11-11 15:09:16','967',440816.40,440816.40,'967','2022-11-10 15:11:51','648','2022-11-10 15:21:46',10,0),('1','292',11,'MORNING SHIFT ','2022-10-13','2022-11-10 16:21:49','2022-11-11 16:21:49','967',1174570.20,1174570.20,'967','2022-11-10 16:25:52','648','2022-11-10 16:30:32',10,0),('1','292',12,'MORNING SHIFT ','2022-10-14','2022-11-10 16:45:56','2022-11-11 16:45:56','967',1116001.80,1116001.80,'967','2022-11-10 16:53:13','648','2022-11-10 17:39:17',10,0),('1','292',13,'MORNING SHIFT ','2022-10-15','2022-11-10 18:30:42','2022-11-11 18:30:42','967',1161327.60,1161327.60,'967','2022-11-10 18:33:45','648','2022-11-11 10:38:26',10,0),('1','292',14,'MORNING SHIFT ','2022-10-16','2022-11-11 11:19:19','2022-11-12 11:19:19','967',1050879.60,1050879.60,'967','2022-11-11 11:24:22','648','2022-11-11 12:20:32',10,0),('1','292',15,'MORNING SHIFT ','2022-10-17','2022-11-11 14:40:53','2022-11-12 14:40:53','967',1286112.60,1286112.60,'967','2022-11-11 14:51:58','648','2022-11-11 15:05:45',10,0),('1','292',16,'MORNING SHIFT ','2022-10-18','2022-11-11 15:19:57','2022-11-12 15:19:57','967',1512243.00,1512243.00,'967','2022-11-11 15:24:08','648','2022-11-11 15:40:29',10,0),('1','292',17,'MORNING SHIFT ','2022-10-19','2022-11-11 15:44:39','2022-11-12 15:44:39','967',1523260.80,1523260.80,'967','2022-11-11 15:48:36','648','2022-11-11 15:51:57',10,0),('1','292',18,'MORNING SHIFT ','2022-10-20','2022-11-11 15:54:58','2022-11-12 15:54:58','967',404350.20,404350.20,'967','2022-11-11 15:59:06','648','2022-11-11 16:04:39',10,0),('1','292',19,'AFTERNOON SHIFT ','2022-10-20','2022-11-11 16:33:31','2022-11-12 16:33:31','967',792518.40,792518.40,'967','2022-11-11 16:41:15','648','2022-11-11 16:45:39',10,0),('1','292',20,'MORNING SHIFT ','2022-10-21','2022-11-11 16:55:07','2022-11-12 16:55:07','967',1094673.60,1094673.60,'967','2022-11-11 16:59:13','648','2022-11-12 08:14:29',10,0),('1','292',21,'AFTERNOON SHIFT ','2022-10-21','2022-11-12 08:29:42','2022-11-13 08:29:42','967',1136511.00,1136511.00,'967','2022-11-12 08:32:59','648','2022-11-12 08:53:40',10,0),('1','292',22,'MORNING SHIFT ','2022-10-22','2022-11-12 09:08:38','2022-11-13 09:08:38','967',1087194.60,1087194.60,'967','2022-11-12 09:12:44','648','2022-11-12 09:13:43',10,0),('1','292',23,'AFTERNOON SHIFT ','2022-10-22','2022-11-12 09:15:28','2022-11-13 09:15:28','967',1510590.60,1510590.60,'967','2022-11-12 09:17:33','648','2022-11-12 09:18:30',10,0),('1','292',24,'MORNING SHIFT ','2022-10-23','2022-11-12 09:19:26','2022-11-13 09:19:26','967',717143.40,717143.40,'967','2022-11-12 09:21:58','648','2022-11-12 09:30:00',10,0),('1','292',25,'AFTERNOON SHIFT ','2022-10-23','2022-11-12 09:32:04','2022-11-13 09:32:04','967',1128922.20,1128922.20,'967','2022-11-12 09:34:24','648','2022-11-12 09:43:59',10,0),('1','292',26,'MORNING SHIFT ','2022-10-24','2022-11-12 09:47:21','2022-11-13 09:47:21','967',1315054.80,1315054.80,'967','2022-11-12 09:49:47','648','2022-11-12 10:15:05',10,0),('1','292',27,'AFTERNOON SHIFT ','2022-10-24','2022-11-12 10:58:15','2022-11-13 10:58:15','967',1357691.40,1357691.40,'967','2022-11-12 11:00:38','648','2022-11-12 11:02:27',10,0),('1','292',28,'MORNING SHIFT ','2022-10-26','2022-11-12 11:03:29','2022-11-13 11:03:29','967',1139041.80,1139041.80,'967','2022-11-12 11:05:38','648','2022-11-12 11:12:36',10,0),('1','292',29,'AFTERNOON SHIFT ','2022-10-26','2022-11-12 11:13:27','2022-11-13 11:13:27','967',927468.00,927468.00,'967','2022-11-12 11:17:14','648','2022-11-12 11:28:05',10,0),('1','292',30,'MORNING SHIFT ','2022-10-27','2022-11-12 11:30:22','2022-11-13 11:30:22','967',1697259.60,1697259.60,'967','2022-11-12 11:32:24','648','2022-11-12 11:56:35',10,0),('1','292',31,'AFTERNOON SHIFT ','2022-10-27','2022-11-12 12:01:11','2022-11-13 12:01:11','967',1290524.40,1290524.40,'967','2022-11-12 12:03:35','648','2022-11-12 12:09:11',10,0),('1','292',32,'MORNING SHIFT ','2022-10-28','2022-11-12 12:12:59','2022-11-13 12:12:59','967',1537563.60,1537563.60,'967','2022-11-12 12:14:53','648','2022-11-12 12:24:21',10,0),('1','292',33,'AFTERNOON SHIFT ','2022-11-24','2022-11-25 19:56:56','2022-11-26 19:56:56','967',74760.00,74760.00,'967','2022-11-25 19:58:08','648','2022-11-27 15:06:19',10,0),('1','292',34,'MORNING SHIFT ','2022-11-27','2022-11-28 20:16:23','2022-11-29 20:16:23','967',1288747.20,1288747.20,'967','2022-11-28 20:19:04','648','2022-11-29 17:46:26',10,0),('1','292',35,'AFTERNOON SHIFT ','2022-11-27','2022-11-29 19:57:02','2022-11-30 19:57:02','967',1693398.00,1693398.00,'967','2022-11-29 19:58:43','648','2022-11-30 07:59:16',10,0),('1','292',36,'MORNING SHIFT ','2022-11-28','2022-11-30 11:41:06','2022-12-01 11:41:06','967',1950324.80,1950324.80,'967','2022-11-30 11:44:40','648','2022-11-30 12:44:25',10,0),('1','292',37,'AFTERNOON SHIFT ','2022-11-28','2022-11-30 13:22:10','2022-12-01 13:22:10','967',257514.60,257514.60,'967','2022-11-30 13:24:29','648','2022-12-01 10:32:28',10,0),('1','292',38,'MORNING SHIFT ','2022-11-30','2022-12-01 22:44:06','2022-12-02 22:44:06','967',183120.00,183120.00,'967','2022-12-01 22:44:50','975','2022-12-03 14:33:19',10,0),('1','292',39,'AFTERNOON SHIFT ','2022-12-09','2022-12-09 18:32:02','2022-12-10 18:32:02','967',192360.00,192360.00,'967','2022-12-09 19:08:26','648','2022-12-11 05:57:44',10,0),('1','292',40,'MORNING SHIFT ','2022-12-18','2022-12-18 19:30:24','2022-12-19 19:30:24','967',74620.00,74620.00,'967','2022-12-18 19:38:37','648','2022-12-20 10:11:17',10,0),('1','292',41,'AFTERNOON shift ','2022-12-20','2022-12-20 19:08:01','2022-12-21 19:08:01','967',95120.00,95120.00,'967','2022-12-20 19:10:14','648','2022-12-21 08:01:37',10,0),('1','292',42,'MORNING SHIFT ','2022-12-22','2022-12-22 19:29:16','2022-12-23 19:29:16','967',122180.00,122180.00,'967','2022-12-22 19:30:06','648','2022-12-22 20:48:58',10,0),('1','292',43,'MORNING SHIFT ','2022-12-23','2022-12-23 13:29:45','2022-12-24 13:29:45','967',139400.00,139400.00,'967','2022-12-23 13:30:42','648','2022-12-24 23:15:52',10,0),('1','292',44,'AFTERNOON SHIFT ','2022-12-24','2022-12-25 05:35:17','2022-12-26 05:35:17','967',681420.00,681420.00,'967','2022-12-25 05:35:56','648','2022-12-26 05:58:22',10,0),('1','292',45,'MORNING SHIFT ','2022-12-25','2022-12-26 08:20:11','2022-12-27 08:20:11','967',788020.00,788020.00,'967','2022-12-26 08:21:35','648','2022-12-26 16:44:17',10,0),('1','292',46,'AFTERNOON SHIFT ','2023-01-05','2023-01-05 18:53:42','2023-01-06 18:53:42','967',139400.00,139400.00,'967','2023-01-05 18:54:42','648','2023-01-05 20:57:58',10,0),('1','292',47,'MORNING SHIFT ','2023-01-09','2023-01-09 19:43:38','2023-01-10 19:43:38','967',90200.00,90200.00,'967','2023-01-09 19:44:17','648','2023-01-10 15:05:58',10,0),('1','292',48,'AFTERNOON SHIFT ','2023-01-13','2023-01-13 21:56:53','2023-01-14 21:56:53','967',86920.00,86920.00,'967','2023-01-13 21:57:56','648','2023-01-14 09:50:44',10,0),('1','292',49,'MORNING SHIFT ','2023-01-16','2023-01-17 23:06:01','2023-01-18 23:06:01','967',63960.00,63960.00,'967','2023-01-22 20:43:55','648','2023-01-23 08:34:20',10,0),('1','292',50,'AFTERNOON SHIFT ','2023-01-22','2023-01-23 08:37:28','2023-01-24 08:37:28','967',239040.00,239040.00,'967','2023-01-23 08:39:41','648','2023-01-23 17:00:01',10,0),('1','292',51,'MORNING SHIFT ','2023-02-02','2023-02-02 14:54:07','2023-02-03 14:54:07','967',1065973.60,1065973.60,'967','2023-02-03 11:40:10','648','2023-02-03 21:37:27',10,0),('1','292',52,'AFTERNOON SHIFT ','2023-02-03','2023-02-03 21:57:31','2023-02-04 21:57:31','967',0.00,0.00,'967','2023-02-05 18:00:05','648','2023-02-05 18:02:20',10,0),('1','292',53,'MORNING SHIFT','2023-02-03','2023-02-05 18:09:20','2023-02-06 18:09:20','967',1052952.00,1052952.00,'967','2023-02-05 18:15:43','648','2023-02-05 18:18:15',10,0),('1','292',54,'AFTERNOON SHIFT ','2023-02-04','2023-02-05 18:47:26','2023-02-06 18:47:26','967',362446.15,362446.15,'967','2023-02-05 18:49:05','648','2023-02-06 17:06:00',10,0),('1','292',55,'MORNING SHIFT ','2023-02-06','2023-02-06 19:16:43','2023-02-07 19:16:43','967',447535.50,447535.50,'967','2023-02-06 19:18:03','648','2023-02-06 19:46:11',10,0),('1','292',56,'AFTERNOON SHIFT ','2023-02-06','2023-02-06 19:50:20','2023-02-07 19:50:20','967',888609.40,888609.40,'967','2023-02-06 19:51:35','648','2023-02-06 23:24:09',10,0),('1','292',57,'MORNING SHIFT ','2023-02-16','2023-02-16 12:20:06','2023-02-17 12:20:06','967',950767.45,950767.45,'967','2023-02-16 18:18:01','648','2023-02-16 18:32:43',10,0),('1','292',58,'MORNING SHIFT ','2023-02-17','2023-02-17 09:46:54','2023-02-18 09:46:54','967',1119499.25,1119499.25,'967','2023-02-17 13:39:08','648','2023-02-17 17:53:58',10,0),('1','292',59,'MORNING SHIFT ','2023-02-18','2023-02-18 14:58:56','2023-02-19 14:58:56','967',1099704.05,1099704.05,'967','2023-02-18 15:01:26','648','2023-02-19 13:13:23',10,0),('1','292',60,'MORNING SHIFT ','2023-02-19','2023-02-19 13:19:59','2023-02-20 13:19:59','967',890423.65,890423.65,'967','2023-02-19 16:06:58','648','2023-02-19 22:53:14',10,0),('1','292',61,'MORNING SHIFT ','2023-02-20','2023-02-20 13:53:06','2023-02-21 13:53:06','967',1069187.75,1069187.75,'967','2023-02-20 16:37:51','648','2023-02-20 22:49:43',10,0),('1','292',62,'MORNING SHIFT ','2023-02-21','2023-02-21 15:12:05','2023-02-22 15:12:05','967',1111743.70,1111743.70,'967','2023-02-21 17:17:07','648','2023-02-22 09:29:11',10,0),('1','292',63,'MORNING SHIFT ','2023-03-03','2023-03-03 12:59:09','2023-03-04 12:59:09','967',586205.35,586205.35,'967','2023-03-03 17:20:54','648','2023-03-04 06:42:24',10,0),('1','292',64,'MORNING SHIFT ','2023-03-04','2023-03-04 12:59:19','2023-03-05 12:59:19','967',1504474.70,1504474.70,'967','2023-03-04 16:21:28','648','2023-03-05 07:58:57',10,0),('1','292',65,'AFTERNOON SHIFT ','2023-03-05','2023-03-05 16:27:37','2023-03-06 16:27:37','967',2641971.05,2641971.05,'967','2023-03-08 23:29:40','648','2023-03-09 10:06:01',10,0),('1','292',66,'MORNING SHIFT ','2023-03-09','2023-03-09 11:55:24','2023-03-10 11:55:24','967',0.00,0.00,'967','2023-03-09 11:59:05','648','2023-03-09 12:00:28',10,0),('1','292',67,'MORNING SHIFT ','2023-03-06','2023-03-09 12:05:17','2023-03-10 12:05:17','967',2232462.40,2232462.40,'967','2023-03-09 12:07:31','648','2023-03-09 12:22:16',10,0),('1','292',68,'AFTERNOON SHIFT ','2023-03-07','2023-03-09 12:32:44','2023-03-10 12:32:44','967',3513851.80,3513851.80,'967','2023-03-09 12:35:09','648','2023-03-09 12:36:47',10,0),('1','292',69,'MORNING SHIFT ','2023-03-08','2023-03-09 12:41:10','2023-03-10 12:41:10','967',1089847.75,1089847.75,'967','2023-03-09 12:42:21','648','2023-03-09 12:44:57',10,0),('1','292',70,'AFTERNOON SHIFT ','2023-03-08','2023-03-09 13:10:25','2023-03-10 13:10:25','967',1116280.55,1116280.55,'967','2023-03-09 16:46:18','648','2023-03-10 09:32:53',10,0),('1','292',71,'AFTERNOON SHIFT ','2023-03-09','2023-03-10 09:36:30','2023-03-11 09:36:30','967',2105672.85,2105672.85,'967','2023-03-10 09:54:18','648','2023-03-10 13:20:09',10,0),('1','292',72,'MORNING SHIFT ','2023-03-10','2023-03-10 14:04:00','2023-03-11 14:04:00','967',1968207.25,1968207.25,'967','2023-03-10 14:06:35','648','2023-03-10 15:45:48',10,0),('1','292',73,'AFTERNOON SHIFT ','2023-03-10','2023-03-10 20:00:03','2023-03-11 20:00:03','967',828523.05,828523.05,'967','2023-03-10 22:01:06','648','2023-03-11 08:19:11',10,0),('1','292',74,'AFTERNOON SHIFT ','2023-03-11','2023-03-11 16:57:03','2023-03-12 16:57:03','967',3196070.50,3196070.50,'967','2023-03-11 22:27:38','648','2023-03-12 06:48:39',10,0),('1','292',75,'MORNING SHIFT ','2023-03-12','2023-03-12 13:46:12','2023-03-13 13:46:12','967',1675206.90,1675206.90,'967','2023-03-12 13:54:04','648','2023-03-12 22:06:57',10,0),('1','292',76,'AFTERNOON SHIFT ','2023-03-12','2023-03-12 22:19:40','2023-03-13 22:19:40','967',1268516.20,1268516.20,'967','2023-03-12 23:11:46','648','2023-03-13 18:01:50',10,0),('1','292',77,'MORNING SHIFT ','2023-03-13','2023-03-13 18:31:51','2023-03-14 18:31:51','967',1530733.60,1530733.60,'967','2023-03-13 20:59:53','648','2023-03-14 08:31:39',10,0),('1','292',78,'AFTERNOON SHIFT ','2023-03-13','2023-03-14 08:37:12','2023-03-15 08:37:12','967',1750700.65,1750700.65,'967','2023-03-14 08:43:40','648','2023-03-14 09:40:20',10,0),('1','292',79,'MORNING SHIFT ','2023-03-14','2023-03-14 14:09:41','2023-03-15 14:09:41','967',744919.45,744919.45,'967','2023-03-14 14:11:54','648','2023-03-14 18:40:19',10,0),('1','292',80,'AFTERNOON SHIFT ','2023-03-14','2023-03-14 19:35:29','2023-03-15 19:35:29','967',2015846.45,2015846.45,'967','2023-03-14 19:56:25','648','2023-03-15 06:58:00',10,0),('1','292',81,'MORNING SHIFT ','2023-03-15','2023-03-15 13:16:38','2023-03-16 13:16:38','967',1845906.20,1845906.20,'967','2023-03-15 13:31:38','648','2023-03-15 18:12:51',10,0),('1','292',82,'AFTERNOON SHIFT ','2023-03-15','2023-03-15 21:01:46','2023-03-16 21:01:46','967',851830.35,851830.35,'967','2023-03-15 21:04:24','648','2023-03-16 09:09:55',10,0),('1','292',83,'AFTERNOON SHIFT ','2023-03-16','2023-03-16 21:58:49','2023-03-17 21:58:49','967',1690202.25,1690202.25,'967','2023-03-16 22:02:26','648','2023-03-17 07:46:14',10,0),('1','292',84,'MORNING SHIFT ','2023-03-17','2023-03-17 14:06:27','2023-03-18 14:06:27','967',2306346.40,2306346.40,'967','2023-03-17 14:14:07','648','2023-03-17 21:40:29',10,0),('1','292',85,'AFTERNOON SHIFT ','2023-03-17','2023-03-17 22:34:08','2023-03-18 22:34:08','967',1028996.85,1028996.85,'967','2023-03-17 22:36:27','648','2023-03-18 07:19:14',10,0),('1','292',86,'MORNING SHIFT ','2023-03-19','2023-03-19 13:21:06','2023-03-20 13:21:06','967',2033285.80,2033285.80,'967','2023-03-19 13:23:09','648','2023-03-19 15:31:34',10,0),('1','292',87,'AFTERNOON SHIFT ','2023-03-19','2023-03-19 16:56:11','2023-03-20 16:56:11','967',1333249.00,1333249.00,'967','2023-03-19 19:25:02','648','2023-03-20 08:07:05',10,0),('1','292',88,'MORNING SHIFT ','2023-03-20','2023-03-20 13:24:16','2023-03-21 13:24:16','967',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=881 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','292','1','1',1,'1','1',707.78,1076.24,368.46,66322.80,0.00,0.00,0.00,0.00,0.00),('1','292','1','1',2,'2','1',657.42,1106.92,449.50,80910.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','1',3,'3','1',509.63,900.45,390.82,70347.60,0.00,0.00,0.00,0.00,0.00),('1','292','1','1',4,'4','1',757.74,1182.21,424.47,76404.60,0.00,0.00,0.00,0.00,0.00),('1','292','2','1',5,'5','1',635.32,1029.36,394.04,70927.20,0.00,0.00,0.00,0.00,0.00),('1','292','2','1',6,'6','1',713.79,776.47,62.68,11282.40,0.00,0.00,0.00,0.00,0.00),('1','292','3','1',7,'7','1',752.78,801.12,48.34,8701.20,0.00,0.00,0.00,0.00,0.00),('1','292','3','1',8,'8','1',611.35,1159.62,548.27,98688.60,0.00,0.00,0.00,0.00,0.00),('1','292','4','1',9,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','1',10,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','2',11,'1','1',1076.24,1975.48,899.24,161863.20,0.00,0.00,0.00,0.00,0.00),('1','292','1','2',12,'2','1',1106.92,2056.63,921.71,165907.80,0.00,0.00,28.00,0.00,0.00),('1','292','1','2',13,'3','1',900.45,1595.45,695.00,125100.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','2',14,'4','1',1182.21,1887.85,705.64,127015.20,0.00,0.00,0.00,0.00,0.00),('1','292','2','2',15,'5','1',1029.36,1713.32,683.96,123112.80,0.00,0.00,0.00,0.00,0.00),('1','292','2','2',16,'6','1',776.47,779.35,2.88,518.40,0.00,0.00,0.00,0.00,0.00),('1','292','3','2',17,'7','1',801.12,801.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','2',18,'8','1',1159.62,2062.58,902.96,162532.80,0.00,0.00,0.00,0.00,0.00),('1','292','4','2',19,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','2',20,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','3',21,'1','1',1975.48,3066.24,1090.76,196336.80,0.00,0.00,0.00,0.00,0.00),('1','292','1','3',22,'2','1',2056.63,3146.84,1090.21,196237.80,0.00,0.00,0.00,0.00,0.00),('1','292','1','3',23,'3','1',1595.45,2529.12,933.67,168060.60,0.00,0.00,0.00,0.00,0.00),('1','292','1','3',24,'4','1',1887.85,2570.83,682.98,122936.40,0.00,0.00,0.00,0.00,0.00),('1','292','2','3',25,'5','1',1713.32,1713.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','3',26,'6','1',779.35,1346.92,567.57,102162.60,0.00,0.00,0.00,0.00,0.00),('1','292','3','3',27,'7','1',801.12,801.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','3',28,'8','1',2062.58,3134.41,1071.83,192929.40,0.00,0.00,0.00,0.00,0.00),('1','292','4','3',29,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','3',30,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','4',31,'1','1',3066.24,4071.52,1005.28,180950.40,0.00,0.00,0.00,0.00,0.00),('1','292','1','4',32,'2','1',3146.84,4233.19,1086.35,195543.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','4',33,'3','1',2529.12,3461.97,932.85,167913.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','4',34,'4','1',2570.83,3230.88,660.05,118809.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','4',35,'5','1',1713.32,2272.23,558.91,100603.80,0.00,0.00,0.00,0.00,0.00),('1','292','2','4',36,'6','1',1346.92,1347.02,0.10,18.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','4',37,'7','1',801.12,801.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','4',38,'8','1',3134.41,3983.72,849.31,152875.80,0.00,0.00,0.00,0.00,0.00),('1','292','4','4',39,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','4',40,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','5',41,'1','1',4071.52,4974.47,902.95,162531.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','5',42,'2','1',4233.19,5067.13,833.94,150109.20,0.00,0.00,0.00,0.00,0.00),('1','292','1','5',43,'3','1',3461.97,4193.78,731.81,131725.80,0.00,0.00,0.00,0.00,0.00),('1','292','1','5',44,'4','1',3230.88,3824.35,593.47,106824.60,0.00,0.00,0.00,0.00,0.00),('1','292','2','5',45,'5','1',2272.23,2929.86,657.63,118373.40,0.00,0.00,0.00,0.00,0.00),('1','292','2','5',46,'6','1',1347.02,1347.12,0.10,18.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','5',47,'7','1',801.12,801.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','5',48,'8','1',3983.72,4981.50,997.78,179600.40,0.00,0.00,0.00,0.00,0.00),('1','292','4','5',49,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','5',50,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','6',51,'1','1',4974.47,4974.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','6',52,'2','1',5067.13,5067.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','6',53,'3','1',4193.78,4193.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','6',54,'4','1',3824.35,3824.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','6',55,'5','1',2929.86,5050.46,2120.60,381708.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','6',56,'6','1',1347.12,1347.53,0.41,73.80,0.00,0.00,0.00,0.00,0.00),('1','292','3','6',57,'7','1',801.12,2714.10,1912.98,344336.40,0.00,0.00,0.00,0.00,0.00),('1','292','3','6',58,'8','1',4981.50,6981.28,1999.78,359960.40,0.00,0.00,0.00,0.00,0.00),('1','292','4','6',59,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','6',60,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','7',61,'1','1',4974.47,5674.38,699.91,125983.80,0.00,0.00,0.00,0.00,0.00),('1','292','1','7',62,'2','1',5067.13,6128.16,1061.03,190985.40,0.00,0.00,0.00,0.00,0.00),('1','292','1','7',63,'3','1',4193.78,4956.94,763.16,137368.80,0.00,0.00,0.00,0.00,0.00),('1','292','1','7',64,'4','1',3824.35,3824.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','7',65,'5','1',5050.46,5824.64,774.18,139352.40,0.00,0.00,0.00,0.00,0.00),('1','292','2','7',66,'6','1',1347.53,1347.75,0.22,39.60,0.00,0.00,0.00,0.00,0.00),('1','292','3','7',67,'7','1',2714.10,2714.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','7',68,'8','1',6981.28,8479.90,1498.62,269751.60,0.00,0.00,0.00,0.00,0.00),('1','292','4','7',69,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','7',70,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','8',71,'1','1',5674.38,5674.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','8',72,'2','1',6128.16,7388.80,1260.64,226915.20,0.00,0.00,0.00,0.00,0.00),('1','292','1','8',73,'3','1',4956.94,4956.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','8',74,'4','1',3824.35,5086.42,1262.07,227172.60,0.00,0.00,0.00,0.00,0.00),('1','292','2','8',75,'5','1',5824.64,5824.93,0.29,52.20,0.00,0.00,0.00,0.00,0.00),('1','292','2','8',76,'6','1',1347.75,3076.23,1728.48,311126.40,0.00,0.00,0.00,0.00,0.00),('1','292','3','8',77,'7','1',2714.10,3777.52,1063.42,191415.60,0.00,0.00,0.00,0.00,0.00),('1','292','3','8',78,'8','1',8479.90,9389.45,909.55,163719.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','8',79,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','8',80,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','9',81,'1','1',5674.38,6459.05,784.67,141240.60,0.00,0.00,0.00,0.00,0.00),('1','292','1','9',82,'2','1',7388.80,7388.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','9',83,'3','1',4956.94,5859.54,902.60,162468.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','9',84,'4','1',5086.42,5086.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','9',85,'5','1',5824.93,5824.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','9',86,'6','1',3076.23,3076.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','9',87,'7','1',3777.52,3777.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','9',88,'8','1',9389.45,10455.44,1065.99,191878.20,0.00,0.00,0.00,0.00,0.00),('1','292','4','9',89,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','9',90,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','10',91,'1','1',6459.05,6459.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','10',92,'2','1',7388.80,7388.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','10',93,'3','1',5859.54,6932.54,1073.00,193140.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','10',94,'4','1',5086.42,5086.62,0.20,36.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','10',95,'5','1',5824.93,6402.98,578.05,104049.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','10',96,'6','1',3076.23,3076.51,0.28,50.40,0.00,0.00,0.00,0.00,0.00),('1','292','3','10',97,'7','1',3777.52,4574.97,797.45,143541.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','10',98,'8','1',10455.44,10455.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','10',99,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','10',100,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','11',101,'1','1',6459.05,6459.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','11',102,'2','1',7388.80,9171.04,1782.24,320803.20,0.00,0.00,0.00,0.00,0.00),('1','292','1','11',103,'3','1',6932.54,8052.74,1120.20,201636.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','11',104,'4','1',5086.62,5086.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','11',105,'5','1',6402.98,7022.65,619.67,111540.60,0.00,0.00,0.00,0.00,0.00),('1','292','2','11',106,'6','1',3076.51,4028.58,952.07,171372.60,0.00,0.00,0.00,0.00,0.00),('1','292','3','11',107,'7','1',4574.97,5482.93,907.96,163432.80,0.00,0.00,0.00,0.00,0.00),('1','292','3','11',108,'8','1',10455.44,11598.69,1143.25,205785.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','11',109,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','11',110,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','12',111,'1','1',6459.05,7628.14,1169.09,210436.20,0.00,0.00,0.00,0.00,0.00),('1','292','1','12',112,'2','1',9171.04,9171.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','12',113,'3','1',8052.74,8052.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','12',114,'4','1',5086.62,6272.37,1185.75,213435.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','12',115,'5','1',7022.65,8636.98,1614.33,290579.40,0.00,0.00,0.00,0.00,0.00),('1','292','2','12',116,'6','1',4028.58,4028.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','12',117,'7','1',5482.93,6768.13,1285.20,231336.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','12',118,'8','1',11598.69,12544.33,945.64,170215.20,0.00,0.00,0.00,0.00,0.00),('1','292','4','12',119,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','12',120,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','13',121,'1','1',7628.14,7628.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','13',122,'2','1',9171.04,10419.32,1248.28,224690.40,0.00,0.00,0.00,0.00,0.00),('1','292','1','13',123,'3','1',8052.74,9476.72,1423.98,256316.40,0.00,0.00,0.00,0.00,0.00),('1','292','1','13',124,'4','1',6272.37,6272.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','13',125,'5','1',8636.98,9360.04,723.06,130150.80,0.00,0.00,0.00,0.00,0.00),('1','292','2','13',126,'6','1',4028.58,4825.92,797.34,143521.20,0.00,0.00,0.00,0.00,0.00),('1','292','3','13',127,'7','1',6768.13,7848.02,1079.89,194380.20,0.00,0.00,0.00,0.00,0.00),('1','292','3','13',128,'8','1',12544.33,13723.60,1179.27,212268.60,0.00,0.00,0.00,0.00,0.00),('1','292','4','13',129,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','13',130,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','14',131,'1','1',7628.14,8288.85,660.71,118927.80,0.00,0.00,0.00,0.00,0.00),('1','292','1','14',132,'2','1',10419.32,11414.54,995.22,179139.60,0.00,0.00,0.00,0.00,0.00),('1','292','1','14',133,'3','1',9476.72,10613.37,1136.65,204597.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','14',134,'4','1',6272.37,7016.85,744.48,134006.40,0.00,0.00,0.00,0.00,0.00),('1','292','2','14',135,'5','1',9360.04,9828.75,468.71,84367.80,0.00,0.00,0.00,0.00,0.00),('1','292','2','14',136,'6','1',4825.92,4826.07,0.15,27.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','14',137,'7','1',7848.02,8935.58,1087.56,195760.80,0.00,0.00,0.00,0.00,0.00),('1','292','3','14',138,'8','1',13723.60,14468.34,744.74,134053.20,0.00,0.00,0.00,0.00,0.00),('1','292','4','14',139,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','14',140,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','15',141,'1','1',8288.85,9676.41,1387.56,249760.80,0.00,0.00,0.00,0.00,0.00),('1','292','1','15',142,'2','1',11414.54,12495.35,1080.81,194545.80,0.00,0.00,0.00,0.00,0.00),('1','292','1','15',143,'3','1',10613.37,12376.16,1762.79,317302.20,0.00,0.00,0.00,0.00,0.00),('1','292','1','15',144,'4','1',7016.85,7016.89,0.04,7.20,0.00,0.00,0.00,0.00,0.00),('1','292','2','15',145,'5','1',9828.75,10266.90,438.15,78867.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','15',146,'6','1',4826.07,5079.73,253.66,45658.80,0.00,0.00,0.00,0.00,0.00),('1','292','3','15',147,'7','1',8935.58,10324.97,1369.75,246555.00,0.00,0.00,19.64,0.00,0.00),('1','292','3','15',148,'8','1',14468.34,15320.65,852.31,153415.80,0.00,0.00,0.00,0.00,0.00),('1','292','4','15',149,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','15',150,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','16',151,'1','1',9676.41,10840.54,1164.13,209543.40,0.00,0.00,0.00,0.00,0.00),('1','292','1','16',152,'2','1',12495.35,13945.58,1450.23,261041.40,0.00,0.00,0.00,0.00,0.00),('1','292','1','16',153,'3','1',12376.16,12849.96,473.80,85284.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','16',154,'4','1',7016.89,8288.33,1271.44,228859.20,0.00,0.00,0.00,0.00,0.00),('1','292','2','16',155,'5','1',10266.90,11500.35,1233.45,222021.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','16',156,'6','1',5079.73,5079.93,0.20,36.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','16',157,'7','1',10324.97,11886.23,1561.26,281026.80,0.00,0.00,0.00,0.00,0.00),('1','292','3','16',158,'8','1',15320.65,16567.49,1246.84,224431.20,0.00,0.00,0.00,0.00,0.00),('1','292','4','16',159,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','16',160,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','17',161,'1','1',10840.54,12381.54,1541.00,277380.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','17',162,'2','1',13945.58,14852.40,906.82,163227.60,0.00,0.00,0.00,0.00,0.00),('1','292','1','17',163,'3','1',12849.96,14236.28,1386.32,249537.60,0.00,0.00,0.00,0.00,0.00),('1','292','1','17',164,'4','1',8288.33,9159.58,871.25,156825.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','17',165,'5','1',11500.35,12066.81,566.46,101962.80,0.00,0.00,0.00,0.00,0.00),('1','292','2','17',166,'6','1',5079.93,5735.33,655.40,117972.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','17',167,'7','1',11886.23,13361.76,1475.53,265595.40,0.00,0.00,0.00,0.00,0.00),('1','292','3','17',168,'8','1',16567.49,17627.27,1059.78,190760.40,0.00,0.00,0.00,0.00,0.00),('1','292','4','17',169,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','17',170,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','18',171,'1','1',12381.54,12951.10,569.56,102520.80,0.00,0.00,0.00,0.00,0.00),('1','292','1','18',172,'2','1',14852.40,14852.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','18',173,'3','1',14236.28,15081.78,845.50,152190.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','18',174,'4','1',9159.58,9159.87,0.29,52.20,0.00,0.00,0.00,0.00,0.00),('1','292','2','18',175,'5','1',12066.81,12464.66,397.85,71613.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','18',176,'6','1',5735.33,5735.54,0.21,37.80,0.00,0.00,0.00,0.00,0.00),('1','292','3','18',177,'7','1',13361.76,13794.61,432.85,77913.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','18',178,'8','1',17627.27,17627.40,0.13,23.40,0.00,0.00,0.00,0.00,0.00),('1','292','4','18',179,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','18',180,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','19',181,'1','1',12951.10,13012.21,40.60,7308.00,0.00,0.00,20.51,0.00,0.00),('1','292','1','19',182,'2','1',14852.40,16169.80,1296.92,233445.60,0.00,0.00,20.48,0.00,0.00),('1','292','1','19',183,'3','1',15081.78,15102.26,0.01,1.80,0.00,0.00,20.47,0.00,0.00),('1','292','1','19',184,'4','1',9159.87,10382.59,1202.20,216396.00,0.00,0.00,20.52,0.00,0.00),('1','292','2','19',185,'5','1',12464.66,12485.19,0.00,0.00,0.00,0.00,20.53,0.00,0.00),('1','292','2','19',186,'6','1',5735.54,6591.46,835.46,150382.80,0.00,0.00,20.46,0.00,0.00),('1','292','3','19',187,'7','1',13794.61,13794.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','19',188,'8','1',17627.40,18675.05,1027.69,184984.20,0.00,0.00,19.96,0.00,0.00),('1','292','4','19',189,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','19',190,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','20',191,'1','1',13012.21,13012.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','20',192,'2','1',16169.80,17874.54,1704.74,306853.20,0.00,0.00,0.00,0.00,0.00),('1','292','1','20',193,'3','1',15102.26,16238.82,1136.56,204580.80,0.00,0.00,0.00,0.00,0.00),('1','292','1','20',194,'4','1',10382.59,10382.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','20',195,'5','1',12485.19,12485.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','20',196,'6','1',6591.46,7893.93,1302.47,234444.60,0.00,0.00,0.00,0.00,0.00),('1','292','3','20',197,'7','1',13794.61,15275.97,1481.36,266644.80,0.00,0.00,0.00,0.00,0.00),('1','292','3','20',198,'8','1',18675.05,19131.44,456.39,82150.20,0.00,0.00,0.00,0.00,0.00),('1','292','4','20',199,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','20',200,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','21',201,'1','1',13012.21,13012.64,0.43,77.40,0.00,0.00,0.00,0.00,0.00),('1','292','1','21',202,'2','1',17874.54,18917.43,1042.89,187720.20,0.00,0.00,0.00,0.00,0.00),('1','292','1','21',203,'3','1',16238.82,17681.96,1443.14,259765.20,0.00,0.00,0.00,0.00,0.00),('1','292','1','21',204,'4','1',10382.59,10382.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','21',205,'5','1',12485.19,12485.41,0.22,39.60,0.00,0.00,0.00,0.00,0.00),('1','292','2','21',206,'6','1',7893.93,9425.29,1531.36,275644.80,0.00,0.00,0.00,0.00,0.00),('1','292','3','21',207,'7','1',15275.97,15275.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','21',208,'8','1',19131.44,21427.35,2295.91,413263.80,0.00,0.00,0.00,0.00,0.00),('1','292','4','21',209,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','21',210,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','22',211,'1','1',13012.64,14299.55,1286.91,231643.80,0.00,0.00,0.00,0.00,0.00),('1','292','1','22',212,'2','1',18917.43,18917.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','22',213,'3','1',17681.96,17681.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','22',214,'4','1',10382.59,12620.12,2237.53,402755.40,0.00,0.00,0.00,0.00,0.00),('1','292','2','22',215,'5','1',12485.41,13127.85,642.44,115639.20,0.00,0.00,0.00,0.00,0.00),('1','292','2','22',216,'6','1',9425.29,9425.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','22',217,'7','1',15275.97,17149.06,1873.09,337156.20,0.00,0.00,0.00,0.00,0.00),('1','292','3','22',218,'8','1',21427.35,21427.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','22',219,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','22',220,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','23',221,'1','1',14299.55,14299.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','23',222,'2','1',18917.43,21376.02,2458.59,442546.20,0.00,0.00,0.00,0.00,0.00),('1','292','1','23',223,'3','1',17681.96,19206.92,1524.96,274492.80,0.00,0.00,0.00,0.00,0.00),('1','292','1','23',224,'4','1',12620.12,12620.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','23',225,'5','1',13127.85,13127.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','23',226,'6','1',9425.29,11670.48,2245.19,404134.20,0.00,0.00,0.00,0.00,0.00),('1','292','3','23',227,'7','1',17149.06,17149.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','23',228,'8','1',21427.35,23590.78,2163.43,389417.40,0.00,0.00,0.00,0.00,0.00),('1','292','4','23',229,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','23',230,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','24',231,'1','1',14299.55,15793.27,1493.72,268869.60,0.00,0.00,0.00,0.00,0.00),('1','292','1','24',232,'2','1',21376.02,21376.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','24',233,'3','1',19206.92,19519.54,312.62,56271.60,0.00,0.00,0.00,0.00,0.00),('1','292','1','24',234,'4','1',12620.12,12620.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','24',235,'5','1',13127.85,14404.36,1276.51,229771.80,0.00,0.00,0.00,0.00,0.00),('1','292','2','24',236,'6','1',11670.48,11670.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','24',237,'7','1',17149.06,18050.34,901.28,162230.40,0.00,0.00,0.00,0.00,0.00),('1','292','3','24',238,'8','1',23590.78,23590.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','24',239,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','24',240,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','25',241,'1','1',15793.27,15793.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','25',242,'2','1',21376.02,23139.75,1763.73,317471.40,0.00,0.00,0.00,0.00,0.00),('1','292','1','25',243,'3','1',19519.54,19769.10,249.56,44920.80,0.00,0.00,0.00,0.00,0.00),('1','292','1','25',244,'4','1',12620.12,13785.80,1165.68,209822.40,0.00,0.00,0.00,0.00,0.00),('1','292','2','25',245,'5','1',14404.36,14404.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','25',246,'6','1',11670.48,13015.49,1345.01,242101.80,0.00,0.00,0.00,0.00,0.00),('1','292','3','25',247,'7','1',18050.34,18050.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','25',248,'8','1',23590.78,25338.59,1747.81,314605.80,0.00,0.00,0.00,0.00,0.00),('1','292','4','25',249,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','25',250,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','26',251,'1','1',15793.27,15793.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','26',252,'2','1',23139.75,23139.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','26',253,'3','1',19769.10,19769.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','26',254,'4','1',13785.80,13785.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','26',255,'5','1',14404.36,17202.17,2797.81,503605.80,0.00,0.00,0.00,0.00,0.00),('1','292','2','26',256,'6','1',13015.49,14294.82,1279.33,230279.40,0.00,0.00,0.00,0.00,0.00),('1','292','3','26',257,'7','1',18050.34,19078.05,1027.71,184987.80,0.00,0.00,0.00,0.00,0.00),('1','292','3','26',258,'8','1',25338.59,27539.60,2201.01,396181.80,0.00,0.00,0.00,0.00,0.00),('1','292','4','26',259,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','26',260,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','27',261,'1','1',15793.27,15793.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','27',262,'2','1',23139.75,23139.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','27',263,'3','1',19769.10,19769.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','27',264,'4','1',13785.80,13785.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','27',265,'5','1',17202.17,20231.57,3029.40,545292.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','27',266,'6','1',14294.82,16007.56,1712.74,308293.20,0.00,0.00,0.00,0.00,0.00),('1','292','3','27',267,'7','1',19078.05,20723.99,1645.94,296269.20,0.00,0.00,0.00,0.00,0.00),('1','292','3','27',268,'8','1',27539.60,28694.25,1154.65,207837.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','27',269,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','27',270,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','28',271,'1','1',15793.27,15793.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','28',272,'2','1',23139.75,23146.01,6.26,1126.80,0.00,0.00,0.00,0.00,0.00),('1','292','1','28',273,'3','1',19769.10,19769.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','28',274,'4','1',13785.80,13785.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','28',275,'5','1',20231.57,23549.59,3318.02,597243.60,0.00,0.00,0.00,0.00,0.00),('1','292','2','28',276,'6','1',16007.56,19011.29,3003.73,540671.40,0.00,0.00,0.00,0.00,0.00),('1','292','3','28',277,'7','1',20723.99,20723.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','28',278,'8','1',28694.25,28694.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','28',279,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','28',280,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','29',281,'1','1',15793.27,15869.26,64.88,11678.40,0.00,0.00,11.11,0.00,0.00),('1','292','1','29',282,'2','1',23146.01,24169.82,1013.60,182448.00,0.00,0.00,10.21,0.00,0.00),('1','292','1','29',283,'3','1',19769.10,21086.28,1304.86,234874.80,0.00,0.00,12.32,0.00,0.00),('1','292','1','29',284,'4','1',13785.80,13863.31,66.19,11914.20,0.00,0.00,11.32,0.00,0.00),('1','292','2','29',285,'5','1',23549.59,24981.14,1431.55,257679.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','29',286,'6','1',19011.29,20282.81,1271.52,228873.60,0.00,0.00,0.00,0.00,0.00),('1','292','3','29',287,'7','1',20723.99,20723.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','29',288,'8','1',28694.25,28694.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','29',289,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','29',290,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','30',291,'1','1',15869.26,15869.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','30',292,'2','1',24169.82,27001.95,2832.13,509783.40,0.00,0.00,0.00,0.00,0.00),('1','292','1','30',293,'3','1',21086.28,23495.25,2408.97,433614.60,0.00,0.00,0.00,0.00,0.00),('1','292','1','30',294,'4','1',13863.31,15317.93,1454.62,261831.60,0.00,0.00,0.00,0.00,0.00),('1','292','2','30',295,'5','1',24981.14,27714.64,2733.50,492030.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','30',296,'6','1',20282.81,20282.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','30',297,'7','1',20723.99,20723.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','30',298,'8','1',28694.25,28694.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','30',299,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','30',300,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','31',301,'1','1',15869.26,18038.41,2169.15,390447.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','31',302,'2','1',27001.95,27001.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','31',303,'3','1',23495.25,25578.15,2082.90,374922.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','31',304,'4','1',15317.93,15317.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','31',305,'5','1',27714.64,28367.54,652.90,117522.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','31',306,'6','1',20282.81,22547.44,2264.63,407633.40,0.00,0.00,0.00,0.00,0.00),('1','292','3','31',307,'7','1',20723.99,20723.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','31',308,'8','1',28694.25,28694.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','31',309,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','31',310,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','32',311,'1','1',18038.41,19942.03,1903.62,342651.60,0.00,0.00,0.00,0.00,0.00),('1','292','1','32',312,'2','1',27001.95,29519.45,2517.50,453150.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','32',313,'3','1',25578.15,28577.49,2999.34,539881.20,0.00,0.00,0.00,0.00,0.00),('1','292','1','32',314,'4','1',15317.93,16439.49,1121.56,201880.80,0.00,0.00,0.00,0.00,0.00),('1','292','2','32',315,'5','1',28367.54,28367.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','32',316,'6','1',22547.44,22547.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','32',317,'7','1',20723.99,20723.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','32',318,'8','1',28694.25,28694.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','32',319,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','32',320,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','33',321,'1','1',19942.03,19942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','33',322,'2','1',29519.45,29519.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','33',323,'3','1',28577.49,28577.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','33',324,'4','1',16439.49,16439.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','33',325,'5','1',28367.54,28367.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','33',326,'6','1',22547.44,22547.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','33',327,'7','1',20723.99,20723.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','33',328,'8','1',28694.25,28694.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','33',329,'9','2',1157056.00,1157145.00,89.00,74760.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','33',330,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','34',331,'1','1',19942.03,19942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','34',332,'2','1',29519.45,29519.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','34',333,'3','1',28577.49,28577.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','34',334,'4','1',16439.49,16439.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','34',335,'5','1',28367.54,31516.16,3138.62,659110.20,0.00,0.00,10.00,0.00,0.00),('1','292','2','34',336,'6','1',22547.44,25437.14,2879.70,604737.00,0.00,0.00,10.00,0.00,0.00),('1','292','3','34',337,'7','1',20723.99,20723.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','34',338,'8','1',28694.25,28694.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','34',339,'9','2',1157145.00,1157175.00,30.00,24900.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','34',340,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','35',341,'1','1',19942.03,19942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','35',342,'2','1',29519.45,29519.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','35',343,'3','1',28577.49,28577.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','35',344,'4','1',16439.49,16439.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','35',345,'5','1',31516.16,35744.18,4228.02,887884.20,0.00,0.00,0.00,0.00,0.00),('1','292','2','35',346,'6','1',25437.14,29272.92,3835.78,805513.80,0.00,0.00,0.00,0.00,0.00),('1','292','3','35',347,'7','1',20723.99,20723.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','35',348,'8','1',28694.25,28694.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','35',349,'9','2',1157175.00,1157175.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','35',350,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','36',351,'1','1',19942.03,19942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','36',352,'2','1',29519.45,29519.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','36',353,'3','1',28577.49,28577.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','36',354,'4','1',16439.49,16439.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','36',355,'5','1',35744.18,39149.02,3404.84,715016.40,0.00,0.00,0.00,0.00,0.00),('1','292','2','36',356,'6','1',29272.92,32447.96,3175.04,666758.40,0.00,0.00,0.00,0.00,0.00),('1','292','3','36',357,'7','1',20723.99,20723.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','36',358,'8','1',28694.25,28694.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','36',359,'9','2',1157175.00,1157860.00,685.00,568550.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','36',360,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','37',361,'1','1',19942.03,19942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','37',362,'2','1',29519.45,29519.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','37',363,'3','1',28577.49,28577.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','37',364,'4','1',16439.49,16439.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','37',365,'5','1',39149.02,39756.25,607.23,127518.30,0.00,0.00,0.00,0.00,0.00),('1','292','2','37',366,'6','1',32447.96,33066.99,619.03,129996.30,0.00,0.00,0.00,0.00,0.00),('1','292','3','37',367,'7','1',20723.99,20723.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','37',368,'8','1',28694.25,28694.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','37',369,'9','2',1157860.00,1157860.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','37',370,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','38',371,'1','1',19942.03,19942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','38',372,'2','1',29519.45,29519.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','38',373,'3','1',28577.49,28577.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','38',374,'4','1',16439.49,16439.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','38',375,'5','1',39756.25,39756.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','38',376,'6','1',33066.99,33066.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','38',377,'7','1',20723.99,20723.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','38',378,'8','1',28694.25,28694.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','38',379,'9','2',1157860.00,1158078.00,218.00,183120.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','38',380,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','39',381,'1','1',19942.03,19942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','39',382,'2','1',29519.45,29519.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','39',383,'3','1',28577.49,28577.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','39',384,'4','1',16439.49,16439.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','39',385,'5','1',39756.25,39756.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','39',386,'6','1',33066.99,33066.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','39',387,'7','1',20723.99,20723.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','39',388,'8','1',28694.25,28694.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','39',389,'9','2',1158078.00,1158307.00,229.00,192360.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','39',390,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','40',391,'1','1',19942.03,19942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','40',392,'2','1',29519.45,29519.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','40',393,'3','1',28577.49,28577.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','40',394,'4','1',16439.49,16439.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','40',395,'5','1',39756.25,39756.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','40',396,'6','1',33066.99,33066.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','40',397,'7','1',20723.99,20723.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','40',398,'8','1',28694.25,28694.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','40',399,'9','2',1158307.00,1158398.00,91.00,74620.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','40',400,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','41',401,'1','1',19942.03,19942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','41',402,'2','1',29519.45,29519.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','41',403,'3','1',28577.49,28577.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','41',404,'4','1',16439.49,16439.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','41',405,'5','1',39756.25,39756.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','41',406,'6','1',33066.99,33066.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','41',407,'7','1',20723.99,20723.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','41',408,'8','1',28694.25,28694.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','41',409,'9','2',1158398.00,1158514.00,116.00,95120.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','41',410,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','42',411,'1','1',19942.03,19942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','42',412,'2','1',29519.45,29519.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','42',413,'3','1',28577.49,28577.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','42',414,'4','1',16439.49,16439.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','42',415,'5','1',39756.25,39756.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','42',416,'6','1',33066.99,33066.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','42',417,'7','1',20723.99,20723.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','42',418,'8','1',28694.25,28694.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','42',419,'9','2',1158514.00,1158663.00,149.00,122180.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','42',420,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','43',421,'1','1',19942.03,19942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','43',422,'2','1',29519.45,29519.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','43',423,'3','1',28577.49,28577.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','43',424,'4','1',16439.49,16439.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','43',425,'5','1',39756.25,39756.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','43',426,'6','1',33066.99,33066.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','43',427,'7','1',20723.99,20723.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','43',428,'8','1',28694.25,28694.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','43',429,'9','2',1158663.00,1158833.00,170.00,139400.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','43',430,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','44',431,'1','1',19942.03,19942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','44',432,'2','1',29519.45,29519.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','44',433,'3','1',28577.49,28577.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','44',434,'4','1',16439.49,16439.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','44',435,'5','1',39756.25,39756.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','44',436,'6','1',33066.99,33066.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','44',437,'7','1',20723.99,20723.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','44',438,'8','1',28694.25,28694.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','44',439,'9','2',1158833.00,1159664.00,831.00,681420.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','44',440,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','45',441,'1','1',19942.03,19942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','45',442,'2','1',29519.45,29519.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','45',443,'3','1',28577.49,28577.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','45',444,'4','1',16439.49,16439.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','45',445,'5','1',39756.25,39756.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','45',446,'6','1',33066.99,33066.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','45',447,'7','1',20723.99,20723.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','45',448,'8','1',28694.25,28694.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','45',449,'9','2',1159664.00,1160625.00,961.00,788020.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','45',450,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','46',451,'1','1',19942.03,19942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','46',452,'2','1',29519.45,29519.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','46',453,'3','1',28577.49,28577.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','46',454,'4','1',16439.49,16439.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','46',455,'5','1',39756.25,39756.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','46',456,'6','1',33066.99,33066.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','46',457,'7','1',20723.99,20723.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','46',458,'8','1',28694.25,28694.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','46',459,'9','2',1160625.00,1160795.00,170.00,139400.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','46',460,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','47',461,'1','1',19942.03,19942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','47',462,'2','1',29519.45,29519.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','47',463,'3','1',28577.49,28577.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','47',464,'4','1',16439.49,16439.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','47',465,'5','1',39756.25,39756.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','47',466,'6','1',33066.99,33066.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','47',467,'7','1',20723.99,20723.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','47',468,'8','1',28694.25,28694.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','47',469,'9','2',1160795.00,1160905.00,110.00,90200.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','47',470,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','48',471,'1','1',19942.03,19942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','48',472,'2','1',29519.45,29519.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','48',473,'3','1',28577.49,28577.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','48',474,'4','1',16439.49,16439.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','48',475,'5','1',39756.25,39756.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','48',476,'6','1',33066.99,33066.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','48',477,'7','1',20723.99,20723.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','48',478,'8','1',28694.25,28694.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','48',479,'9','2',1160905.00,1161011.00,106.00,86920.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','48',480,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','49',481,'1','1',19942.03,19942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','49',482,'2','1',29519.45,29519.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','49',483,'3','1',28577.49,28577.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','49',484,'4','1',16439.49,16439.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','49',485,'5','1',39756.25,39756.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','49',486,'6','1',33066.99,33066.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','49',487,'7','1',20723.99,20723.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','49',488,'8','1',28694.25,28694.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','49',489,'9','2',1161011.00,1161089.00,78.00,63960.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','49',490,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','50',491,'1','1',19942.03,19942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','50',492,'2','1',29519.45,29519.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','50',493,'3','1',28577.49,28577.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','50',494,'4','1',16439.49,16439.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','50',495,'5','1',39756.25,39756.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','50',496,'6','1',33066.99,33066.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','50',497,'7','1',20723.99,20723.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','50',498,'8','1',28694.25,28694.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','50',499,'9','2',1161089.00,1161377.00,288.00,239040.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','50',500,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','51',501,'1','1',19942.03,19961.57,0.00,0.00,0.00,0.00,19.54,0.00,0.00),('1','292','1','51',502,'2','1',29519.45,30861.20,1322.58,317419.20,0.00,0.00,19.17,0.00,0.00),('1','292','1','51',503,'3','1',28577.49,31088.74,2471.16,593078.40,0.00,0.00,40.09,0.00,0.00),('1','292','1','51',504,'4','1',16439.49,16787.74,318.65,76476.00,0.00,0.00,29.60,0.00,0.00),('1','292','2','51',505,'5','1',39756.25,39756.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','51',506,'6','1',33066.99,33066.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','51',507,'7','1',20723.99,20723.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','51',508,'8','1',28694.25,28694.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','51',509,'9','2',1161377.00,1161477.00,100.00,79000.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','51',510,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','52',511,'1','1',19961.57,19961.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','52',512,'2','1',30861.20,30861.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','52',513,'3','1',31088.74,31088.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','52',514,'4','1',16787.74,16787.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','52',515,'5','1',39756.25,39756.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','52',516,'6','1',33066.99,33066.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','52',517,'7','1',20723.99,20723.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','52',518,'8','1',28694.25,28694.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','52',519,'9','2',1161477.00,1161477.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','52',520,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','53',521,'1','1',19961.57,19961.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','53',522,'2','1',30861.20,32779.78,1918.58,460459.20,0.00,0.00,0.00,0.00,0.00),('1','292','1','53',523,'3','1',31088.74,33557.46,2468.72,592492.80,0.00,0.00,0.00,0.00,0.00),('1','292','1','53',524,'4','1',16787.74,16787.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','53',525,'5','1',39756.25,39756.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','53',526,'6','1',33066.99,33066.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','53',527,'7','1',20723.99,20723.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','53',528,'8','1',28694.25,28694.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','53',529,'9','2',1161477.00,1161477.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','53',530,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','54',531,'1','1',19961.57,20529.32,567.75,116388.75,0.00,0.00,0.00,0.00,0.00),('1','292','1','54',532,'2','1',32779.78,32779.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','54',533,'3','1',33557.46,34252.53,695.07,142489.35,0.00,0.00,0.00,0.00,0.00),('1','292','1','54',534,'4','1',16787.74,17292.95,505.21,103568.05,0.00,0.00,0.00,0.00,0.00),('1','292','2','54',535,'5','1',39756.25,39756.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','54',536,'6','1',33066.99,33066.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','54',537,'7','1',20723.99,20723.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','54',538,'8','1',28694.25,28694.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','54',539,'9','2',1161477.00,1161477.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','54',540,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','55',541,'1','1',20529.32,20529.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','55',542,'2','1',32779.78,33595.23,815.45,167167.25,0.00,0.00,0.00,0.00,0.00),('1','292','1','55',543,'3','1',34252.53,34695.94,443.41,90899.05,0.00,0.00,0.00,0.00,0.00),('1','292','1','55',544,'4','1',17292.95,18217.19,924.24,189469.20,0.00,0.00,0.00,0.00,0.00),('1','292','2','55',545,'5','1',39756.25,39756.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','55',546,'6','1',33066.99,33066.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','55',547,'7','1',20723.99,20723.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','55',548,'8','1',28694.25,28694.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','55',549,'9','2',1161477.00,1161477.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','55',550,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','56',551,'1','1',20529.32,22252.26,1722.94,353202.70,0.00,0.00,0.00,0.00,0.00),('1','292','1','56',552,'2','1',33595.23,33595.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','56',553,'3','1',34695.94,34695.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','56',554,'4','1',18217.19,20828.93,2611.74,535406.70,0.00,0.00,0.00,0.00,0.00),('1','292','2','56',555,'5','1',39756.25,39756.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','56',556,'6','1',33066.99,33066.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','56',557,'7','1',20723.99,20723.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','56',558,'8','1',28694.25,28694.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','56',559,'9','2',1161477.00,1161477.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','56',560,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','57',561,'1','1',22252.26,22252.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','57',562,'2','1',33595.23,33595.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','57',563,'3','1',34695.94,34695.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','57',564,'4','1',20828.93,20828.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','57',565,'5','1',39756.25,39756.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','57',566,'6','1',33066.99,33066.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','57',567,'7','1',20723.99,22955.56,2231.57,457471.85,0.00,0.00,0.00,0.00,0.00),('1','292','3','57',568,'8','1',28694.25,31100.57,2406.32,493295.60,0.00,0.00,0.00,0.00,0.00),('1','292','4','57',569,'9','2',1161477.00,1161477.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','57',570,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','58',571,'1','1',22252.26,22252.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','58',572,'2','1',33595.23,33595.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','58',573,'3','1',34695.94,34695.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','58',574,'4','1',20828.93,20828.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','58',575,'5','1',39756.25,39756.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','58',576,'6','1',33066.99,33066.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','58',577,'7','1',22955.56,25121.30,2165.74,443976.70,0.00,0.00,0.00,0.00,0.00),('1','292','3','58',578,'8','1',31100.57,34000.68,2900.11,594522.55,0.00,0.00,0.00,0.00,0.00),('1','292','4','58',579,'9','2',1161477.00,1161577.00,100.00,81000.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','58',580,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','59',581,'1','1',22252.26,22252.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','59',582,'2','1',33595.23,33595.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','59',583,'3','1',34695.94,34695.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','59',584,'4','1',20828.93,20828.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','59',585,'5','1',39756.25,39756.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','59',586,'6','1',33066.99,33066.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','59',587,'7','1',25121.30,27572.45,2451.15,502485.75,0.00,0.00,0.00,0.00,0.00),('1','292','3','59',588,'8','1',34000.68,36913.94,2913.26,597218.30,0.00,0.00,0.00,0.00,0.00),('1','292','4','59',589,'9','2',1161577.00,1161577.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','59',590,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','60',591,'1','1',22252.26,22252.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','60',592,'2','1',33595.23,33595.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','60',593,'3','1',34695.94,34695.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','60',594,'4','1',20828.93,20828.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','60',595,'5','1',39756.25,39756.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','60',596,'6','1',33066.99,33066.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','60',597,'7','1',27572.45,29577.71,2005.26,411078.30,0.00,0.00,0.00,0.00,0.00),('1','292','3','60',598,'8','1',36913.94,39252.21,2338.27,479345.35,0.00,0.00,0.00,0.00,0.00),('1','292','4','60',599,'9','2',1161577.00,1161577.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','60',600,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','61',601,'1','1',22252.26,22252.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','61',602,'2','1',33595.23,33595.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','61',603,'3','1',34695.94,34695.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','61',604,'4','1',20828.93,20828.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','61',605,'5','1',39756.25,39756.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','61',606,'6','1',33066.99,33066.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','61',607,'7','1',29577.71,31735.56,2157.85,442359.25,0.00,0.00,0.00,0.00,0.00),('1','292','3','61',608,'8','1',39252.21,42309.91,3057.70,626828.50,0.00,0.00,0.00,0.00,0.00),('1','292','4','61',609,'9','2',1161577.00,1161577.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','61',610,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','62',611,'1','1',22252.26,22252.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','62',612,'2','1',33595.23,33595.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','62',613,'3','1',34695.94,34695.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','62',614,'4','1',20828.93,20828.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','62',615,'5','1',39756.25,39756.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','62',616,'6','1',33066.99,33066.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','62',617,'7','1',31735.56,34052.17,2316.61,474905.05,0.00,0.00,0.00,0.00,0.00),('1','292','3','62',618,'8','1',42309.91,45416.44,3106.53,636838.65,0.00,0.00,0.00,0.00,0.00),('1','292','4','62',619,'9','2',1161577.00,1161577.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','62',620,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','63',621,'1','1',22252.26,22252.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','63',622,'2','1',33595.23,33595.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','63',623,'3','1',34695.94,34695.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','63',624,'4','1',20828.93,20828.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','63',625,'5','1',39756.25,39756.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','63',626,'6','1',33066.99,33066.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','63',627,'7','1',34052.17,34900.83,848.66,199435.10,0.00,0.00,0.00,0.00,0.00),('1','292','3','63',628,'8','1',45416.44,46717.59,1301.15,305770.25,0.00,0.00,0.00,0.00,0.00),('1','292','4','63',629,'9','2',1161577.00,1161677.00,100.00,81000.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','63',630,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','64',631,'1','1',22252.26,22252.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','64',632,'2','1',33595.23,33595.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','64',633,'3','1',34695.94,34695.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','64',634,'4','1',20828.93,20828.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','64',635,'5','1',39756.25,39756.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','64',636,'6','1',33066.99,33066.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','64',637,'7','1',34900.83,37991.29,3090.46,726258.10,0.00,0.00,0.00,0.00,0.00),('1','292','3','64',638,'8','1',46717.59,50029.15,3311.56,778216.60,0.00,0.00,0.00,0.00,0.00),('1','292','4','64',639,'9','2',1161677.00,1161677.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','64',640,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','65',641,'1','1',22252.26,23940.34,1688.08,396698.80,0.00,0.00,0.00,0.00,0.00),('1','292','1','65',642,'2','1',33595.23,34797.40,1202.17,282509.95,0.00,0.00,0.00,0.00,0.00),('1','292','1','65',643,'3','1',34695.94,36449.01,1753.07,411971.45,0.00,0.00,0.00,0.00,0.00),('1','292','1','65',644,'4','1',20828.93,22210.93,1382.00,324770.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','65',645,'5','1',39756.25,43126.89,3370.64,792100.40,0.00,0.00,0.00,0.00,0.00),('1','292','2','65',646,'6','1',33066.99,34913.46,1846.47,433920.45,0.00,0.00,0.00,0.00,0.00),('1','292','3','65',647,'7','1',37991.29,37991.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','65',648,'8','1',50029.15,50029.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','65',649,'9','2',1161677.00,1161677.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','65',650,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','66',651,'1','1',23940.34,23940.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','66',652,'2','1',34797.40,34797.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','66',653,'3','1',36449.01,36449.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','66',654,'4','1',22210.93,22210.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','66',655,'5','1',43126.89,43126.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','66',656,'6','1',34913.46,34913.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','66',657,'7','1',37991.29,37991.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','66',658,'8','1',50029.15,50029.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','66',659,'9','2',1161677.00,1161677.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','66',660,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','67',661,'1','1',23940.34,24862.65,922.31,216742.85,0.00,0.00,0.00,0.00,0.00),('1','292','1','67',662,'2','1',34797.40,36026.03,1228.63,288728.05,0.00,0.00,0.00,0.00,0.00),('1','292','1','67',663,'3','1',36449.01,37874.49,1425.48,334987.80,0.00,0.00,0.00,0.00,0.00),('1','292','1','67',664,'4','1',22210.93,23234.70,1023.77,240585.95,0.00,0.00,0.00,0.00,0.00),('1','292','2','67',665,'5','1',43126.89,46234.05,3107.16,730182.60,0.00,0.00,0.00,0.00,0.00),('1','292','2','67',666,'6','1',34913.46,36705.95,1792.49,421235.15,0.00,0.00,0.00,0.00,0.00),('1','292','3','67',667,'7','1',37991.29,37991.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','67',668,'8','1',50029.15,50029.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','67',669,'9','2',1161677.00,1161677.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','67',670,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','68',671,'1','1',24862.65,27426.60,2563.95,602528.25,0.00,0.00,0.00,0.00,0.00),('1','292','1','68',672,'2','1',36026.03,37011.30,985.27,231538.45,0.00,0.00,0.00,0.00,0.00),('1','292','1','68',673,'3','1',37874.49,37874.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','68',674,'4','1',23234.70,23807.39,572.69,134582.15,0.00,0.00,0.00,0.00,0.00),('1','292','2','68',675,'5','1',46234.05,51489.94,5255.89,1235134.15,0.00,0.00,0.00,0.00,0.00),('1','292','2','68',676,'6','1',36705.95,41936.03,5230.08,1229068.80,0.00,0.00,0.00,0.00,0.00),('1','292','3','68',677,'7','1',37991.29,37991.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','68',678,'8','1',50029.15,50029.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','68',679,'9','2',1161677.00,1161777.00,100.00,81000.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','68',680,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','69',681,'1','1',27426.60,27426.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','69',682,'2','1',37011.30,37011.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','69',683,'3','1',37874.49,37874.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','69',684,'4','1',23807.39,23807.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','69',685,'5','1',51489.94,54250.55,2760.61,648743.35,0.00,0.00,0.00,0.00,0.00),('1','292','2','69',686,'6','1',41936.03,43588.07,1652.04,388229.40,0.00,0.00,0.00,0.00,0.00),('1','292','3','69',687,'7','1',37991.29,37991.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','69',688,'8','1',50029.15,50254.15,225.00,52875.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','69',689,'9','2',1161777.00,1161777.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','69',690,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','70',691,'1','1',27426.60,27426.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','70',692,'2','1',37011.30,37011.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','70',693,'3','1',37874.49,37874.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','70',694,'4','1',23807.39,23807.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','70',695,'5','1',54250.55,56409.42,2158.87,507334.45,0.00,0.00,0.00,0.00,0.00),('1','292','2','70',696,'6','1',43588.07,46179.33,2591.26,608946.10,0.00,0.00,0.00,0.00,0.00),('1','292','3','70',697,'7','1',37991.29,37991.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','70',698,'8','1',50254.15,50254.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','70',699,'9','2',1161777.00,1161777.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','70',700,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','71',701,'1','1',27426.60,28680.46,1253.86,294657.10,0.00,0.00,0.00,0.00,0.00),('1','292','1','71',702,'2','1',37011.30,38180.21,1168.91,274693.85,0.00,0.00,0.00,0.00,0.00),('1','292','1','71',703,'3','1',37874.49,38383.55,509.06,119629.10,0.00,0.00,0.00,0.00,0.00),('1','292','1','71',704,'4','1',23807.39,25782.96,1975.57,464258.95,0.00,0.00,0.00,0.00,0.00),('1','292','2','71',705,'5','1',56409.42,56409.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','71',706,'6','1',46179.33,46179.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','71',707,'7','1',37991.29,39882.43,1891.14,444417.90,0.00,0.00,0.00,0.00,0.00),('1','292','3','71',708,'8','1',50254.15,52415.92,2161.77,508015.95,0.00,0.00,0.00,0.00,0.00),('1','292','4','71',709,'9','2',1161777.00,1161777.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','71',710,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','72',711,'1','1',28680.46,30052.82,1372.36,322504.60,0.00,0.00,0.00,0.00,0.00),('1','292','1','72',712,'2','1',38180.21,39580.67,1400.46,329108.10,0.00,0.00,0.00,0.00,0.00),('1','292','1','72',713,'3','1',38383.55,39425.80,1042.25,244928.75,0.00,0.00,0.00,0.00,0.00),('1','292','1','72',714,'4','1',25782.96,26852.31,1069.35,251297.25,0.00,0.00,0.00,0.00,0.00),('1','292','2','72',715,'5','1',56409.42,56409.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','72',716,'6','1',46179.33,46179.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','72',717,'7','1',39882.43,41605.66,1723.23,404959.05,0.00,0.00,0.00,0.00,0.00),('1','292','3','72',718,'8','1',52415.92,54183.62,1767.70,415409.50,0.00,0.00,0.00,0.00,0.00),('1','292','4','72',719,'9','2',1161777.00,1161777.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','72',720,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','73',721,'1','1',30052.82,30560.66,507.84,119342.40,0.00,0.00,0.00,0.00,0.00),('1','292','1','73',722,'2','1',39580.67,39925.68,345.01,81077.35,0.00,0.00,0.00,0.00,0.00),('1','292','1','73',723,'3','1',39425.80,39769.49,343.69,80767.15,0.00,0.00,0.00,0.00,0.00),('1','292','1','73',724,'4','1',26852.31,27413.43,561.12,131863.20,0.00,0.00,0.00,0.00,0.00),('1','292','2','73',725,'5','1',56409.42,56409.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','73',726,'6','1',46179.33,46179.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','73',727,'7','1',41605.66,42460.76,855.10,200948.50,0.00,0.00,0.00,0.00,0.00),('1','292','3','73',728,'8','1',54183.62,55096.49,912.87,214524.45,0.00,0.00,0.00,0.00,0.00),('1','292','4','73',729,'9','2',1161777.00,1161777.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','73',730,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','74',731,'1','1',30560.66,32778.64,2217.98,521225.30,0.00,0.00,0.00,0.00,0.00),('1','292','1','74',732,'2','1',39925.68,41981.92,2056.24,483216.40,0.00,0.00,0.00,0.00,0.00),('1','292','1','74',733,'3','1',39769.49,41598.90,1829.41,429911.35,0.00,0.00,0.00,0.00,0.00),('1','292','1','74',734,'4','1',27413.43,29990.40,2576.97,605587.95,0.00,0.00,0.00,0.00,0.00),('1','292','2','74',735,'5','1',56409.42,56409.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','74',736,'6','1',46179.33,46179.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','74',737,'7','1',42460.76,44258.05,1797.29,422363.15,0.00,0.00,0.00,0.00,0.00),('1','292','3','74',738,'8','1',55096.49,58218.90,3122.41,733766.35,0.00,0.00,0.00,0.00,0.00),('1','292','4','74',739,'9','2',1161777.00,1161777.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','74',740,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','75',741,'1','1',32778.64,33923.52,1144.88,269046.80,0.00,0.00,0.00,0.00,0.00),('1','292','1','75',742,'2','1',41981.92,43409.66,1427.74,335518.90,0.00,0.00,0.00,0.00,0.00),('1','292','1','75',743,'3','1',41598.90,44382.20,2783.30,654075.50,0.00,0.00,0.00,0.00,0.00),('1','292','1','75',744,'4','1',29990.40,31763.02,1772.62,416565.70,0.00,0.00,0.00,0.00,0.00),('1','292','2','75',745,'5','1',56409.42,56409.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','75',746,'6','1',46179.33,46179.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','75',747,'7','1',44258.05,44258.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','75',748,'8','1',58218.90,58218.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','75',749,'9','2',1161777.00,1161777.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','75',750,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','76',751,'1','1',33923.52,34988.22,1064.70,250204.50,0.00,0.00,0.00,0.00,0.00),('1','292','1','76',752,'2','1',43409.66,44292.75,883.09,207526.15,0.00,0.00,0.00,0.00,0.00),('1','292','1','76',753,'3','1',44382.20,45989.33,1607.13,377675.55,0.00,0.00,0.00,0.00,0.00),('1','292','1','76',754,'4','1',31763.02,32721.52,958.50,225247.50,0.00,0.00,0.00,0.00,0.00),('1','292','2','76',755,'5','1',56409.42,56409.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','76',756,'6','1',46179.33,46179.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','76',757,'7','1',44258.05,44258.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','76',758,'8','1',58218.90,58586.40,367.50,86362.50,0.00,0.00,0.00,0.00,0.00),('1','292','4','76',759,'9','2',1161777.00,1161927.00,150.00,121500.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','76',760,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','77',761,'1','1',34988.22,34988.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','77',762,'2','1',44292.75,45337.65,1044.90,245551.50,0.00,0.00,0.00,0.00,0.00),('1','292','1','77',763,'3','1',45989.33,45989.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','77',764,'4','1',32721.52,33869.20,1147.68,269704.80,0.00,0.00,0.00,0.00,0.00),('1','292','2','77',765,'5','1',56409.42,57289.01,879.59,206703.65,0.00,0.00,0.00,0.00,0.00),('1','292','2','77',766,'6','1',46179.33,46431.13,251.80,59173.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','77',767,'7','1',44258.05,45300.21,1042.16,244907.60,0.00,0.00,0.00,0.00,0.00),('1','292','3','77',768,'8','1',58586.40,60734.03,2147.63,504693.05,0.00,0.00,0.00,0.00,0.00),('1','292','4','77',769,'9','2',1161927.00,1161927.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','77',770,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','78',771,'1','1',34988.22,34988.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','78',772,'2','1',45337.65,46085.92,748.27,175843.45,0.00,0.00,0.00,0.00,0.00),('1','292','1','78',773,'3','1',45989.33,47459.15,1469.82,345407.70,0.00,0.00,0.00,0.00,0.00),('1','292','1','78',774,'4','1',33869.20,34955.78,1086.58,255346.30,0.00,0.00,0.00,0.00,0.00),('1','292','2','78',775,'5','1',57289.01,57821.09,532.08,125038.80,0.00,0.00,0.00,0.00,0.00),('1','292','2','78',776,'6','1',46431.13,47319.22,888.09,208701.15,0.00,0.00,0.00,0.00,0.00),('1','292','3','78',777,'7','1',45300.21,46311.28,1011.07,237601.45,0.00,0.00,0.00,0.00,0.00),('1','292','3','78',778,'8','1',60734.03,62447.91,1713.88,402761.80,0.00,0.00,0.00,0.00,0.00),('1','292','4','78',779,'9','2',1161927.00,1161927.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','78',780,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','79',781,'1','1',34988.22,35152.50,164.28,38605.80,0.00,0.00,0.00,0.00,0.00),('1','292','1','79',782,'2','1',46085.92,46829.41,743.49,174720.15,0.00,0.00,0.00,0.00,0.00),('1','292','1','79',783,'3','1',47459.15,48089.10,629.95,148038.25,0.00,0.00,0.00,0.00,0.00),('1','292','1','79',784,'4','1',34955.78,35298.12,342.34,80449.90,0.00,0.00,0.00,0.00,0.00),('1','292','2','79',785,'5','1',57821.09,57995.70,174.61,41033.35,0.00,0.00,0.00,0.00,0.00),('1','292','2','79',786,'6','1',47319.22,47319.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','79',787,'7','1',46311.28,46311.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','79',788,'8','1',62447.91,63563.11,1115.20,262072.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','79',789,'9','2',1161927.00,1161927.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','79',790,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','80',791,'1','1',35152.50,35284.01,131.51,30904.85,0.00,0.00,0.00,0.00,0.00),('1','292','1','80',792,'2','1',46829.41,47628.78,799.37,187851.95,0.00,0.00,0.00,0.00,0.00),('1','292','1','80',793,'3','1',48089.10,49204.66,1115.56,262156.60,0.00,0.00,0.00,0.00,0.00),('1','292','1','80',794,'4','1',35298.12,37020.49,1722.37,404756.95,0.00,0.00,0.00,0.00,0.00),('1','292','2','80',795,'5','1',57995.70,59079.32,1083.62,254650.70,0.00,0.00,0.00,0.00,0.00),('1','292','2','80',796,'6','1',47319.22,47695.54,376.32,88435.20,0.00,0.00,0.00,0.00,0.00),('1','292','3','80',797,'7','1',46311.28,47722.72,1411.44,331688.40,0.00,0.00,0.00,0.00,0.00),('1','292','3','80',798,'8','1',63563.11,65500.99,1937.88,455401.80,0.00,0.00,0.00,0.00,0.00),('1','292','4','80',799,'9','2',1161927.00,1161927.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','80',800,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','81',801,'1','1',35284.01,35284.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','81',802,'2','1',47628.78,49739.03,2110.25,495908.75,0.00,0.00,0.00,0.00,0.00),('1','292','1','81',803,'3','1',49204.66,51956.36,2751.70,646649.50,0.00,0.00,0.00,0.00,0.00),('1','292','1','81',804,'4','1',37020.49,37020.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','81',805,'5','1',59079.32,59725.90,646.58,151946.30,0.00,0.00,0.00,0.00,0.00),('1','292','2','81',806,'6','1',47695.54,47722.72,27.18,6387.30,0.00,0.00,0.00,0.00,0.00),('1','292','3','81',807,'7','1',47722.72,47722.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','81',808,'8','1',65500.99,67820.20,2319.21,545014.35,0.00,0.00,0.00,0.00,0.00),('1','292','4','81',809,'9','2',1161927.00,1161927.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','81',810,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','82',811,'1','1',35284.01,36709.92,1425.91,335088.85,0.00,0.00,0.00,0.00,0.00),('1','292','1','82',812,'2','1',49739.03,49739.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','82',813,'3','1',51956.36,51956.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','82',814,'4','1',37020.49,38252.84,1232.35,289602.25,0.00,0.00,0.00,0.00,0.00),('1','292','2','82',815,'5','1',59725.90,60580.79,854.89,200899.15,0.00,0.00,0.00,0.00,0.00),('1','292','2','82',816,'6','1',47722.72,47722.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','82',817,'7','1',47722.72,47834.38,111.66,26240.10,0.00,0.00,0.00,0.00,0.00),('1','292','3','82',818,'8','1',67820.20,67820.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','82',819,'9','2',1161927.00,1161927.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','82',820,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','83',821,'1','1',36709.92,37768.82,1018.90,239441.50,0.00,0.00,40.00,0.00,0.00),('1','292','1','83',822,'2','1',49739.03,51092.94,1353.91,318168.85,0.00,0.00,0.00,0.00,0.00),('1','292','1','83',823,'3','1',51956.36,52865.46,909.10,213638.50,0.00,0.00,0.00,0.00,0.00),('1','292','1','83',824,'4','1',38252.84,39567.14,1314.30,308860.50,0.00,0.00,0.00,0.00,0.00),('1','292','2','83',825,'5','1',60580.79,61675.44,1094.65,257242.75,0.00,0.00,0.00,0.00,0.00),('1','292','2','83',826,'6','1',47722.72,47722.82,0.10,23.50,0.00,0.00,0.00,0.00,0.00),('1','292','3','83',827,'7','1',47834.38,47834.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','83',828,'8','1',67820.20,69321.59,1501.39,352826.65,0.00,0.00,0.00,0.00,0.00),('1','292','4','83',829,'9','2',1161927.00,1161927.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','83',830,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','84',831,'1','1',37768.82,37768.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','84',832,'2','1',51092.94,53272.11,2179.17,512104.95,0.00,0.00,0.00,0.00,0.00),('1','292','1','84',833,'3','1',52865.46,54095.77,1230.31,289122.85,0.00,0.00,0.00,0.00,0.00),('1','292','1','84',834,'4','1',39567.14,41577.95,2010.81,472540.35,0.00,0.00,0.00,0.00,0.00),('1','292','2','84',835,'5','1',61675.44,62175.63,500.19,117544.65,0.00,0.00,0.00,0.00,0.00),('1','292','2','84',836,'6','1',47722.82,47973.05,250.23,58804.05,0.00,0.00,0.00,0.00,0.00),('1','292','3','84',837,'7','1',47834.38,48201.32,366.94,86230.90,0.00,0.00,0.00,0.00,0.00),('1','292','3','84',838,'8','1',69321.59,72598.18,3276.59,769998.65,0.00,0.00,0.00,0.00,0.00),('1','292','4','84',839,'9','2',1161927.00,1161927.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','84',840,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','85',841,'1','1',37768.82,37768.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','85',842,'2','1',53272.11,53272.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','85',843,'3','1',54095.77,54095.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','85',844,'4','1',41577.95,41577.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','85',845,'5','1',62175.63,63790.86,1615.23,379579.05,0.00,0.00,0.00,0.00,0.00),('1','292','2','85',846,'6','1',47973.05,48925.82,952.77,223900.95,0.00,0.00,0.00,0.00,0.00),('1','292','3','85',847,'7','1',48201.32,50010.80,1809.48,425227.80,0.00,0.00,0.00,0.00,0.00),('1','292','3','85',848,'8','1',72598.18,72599.41,1.23,289.05,0.00,0.00,0.00,0.00,0.00),('1','292','4','85',849,'9','2',1161927.00,1161927.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','85',850,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','86',851,'1','1',37768.82,37768.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','86',852,'2','1',53272.11,53272.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','86',853,'3','1',54095.77,54095.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','86',854,'4','1',41577.95,41577.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','86',855,'5','1',63790.86,67389.15,3598.29,845598.15,0.00,0.00,0.00,0.00,0.00),('1','292','2','86',856,'6','1',48925.82,53293.26,4367.44,1026348.40,0.00,0.00,0.00,0.00,0.00),('1','292','3','86',857,'7','1',50010.80,50388.82,378.02,88834.70,0.00,0.00,0.00,0.00,0.00),('1','292','3','86',858,'8','1',72599.41,72907.94,308.53,72504.55,0.00,0.00,0.00,0.00,0.00),('1','292','4','86',859,'9','2',1161927.00,1161927.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','86',860,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','87',861,'1','1',37768.82,37768.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','87',862,'2','1',53272.11,53272.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','87',863,'3','1',54095.77,54095.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','87',864,'4','1',41577.95,41577.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','87',865,'5','1',67389.15,70389.45,3000.30,705070.50,0.00,0.00,0.00,0.00,0.00),('1','292','2','87',866,'6','1',53293.26,55966.36,2673.10,628178.50,0.00,0.00,0.00,0.00,0.00),('1','292','3','87',867,'7','1',50388.82,50388.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','87',868,'8','1',72907.94,72907.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','87',869,'9','2',1161927.00,1161927.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','87',870,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','88',871,'1','1',37768.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','88',872,'2','1',53272.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','88',873,'3','1',54095.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','1','88',874,'4','1',41577.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','88',875,'5','1',70389.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','2','88',876,'6','1',55966.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','88',877,'7','1',50388.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','3','88',878,'8','1',72907.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','4','88',879,'9','2',1161927.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','292','5','88',880,'10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=265 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','292','1','1',180.00,180.00,2686.58,0.00,0.00,0.00,0.00,1),('1','292','1','2',800.00,0.00,0.00,0.00,0.00,0.00,0.00,2),('1','292','1','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,3),('1','292','2','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,4),('1','292','2','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,5),('1','292','2','1',180.00,180.00,4811.39,0.00,0.00,0.00,0.00,6),('1','292','3','1',180.00,180.00,5437.02,0.00,0.00,0.00,0.00,7),('1','292','3','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,8),('1','292','3','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,9),('1','292','4','1',180.00,180.00,5092.85,0.00,0.00,0.00,0.00,10),('1','292','4','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,11),('1','292','4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,12),('1','292','5','1',180.00,180.00,4717.68,0.00,0.00,0.00,0.00,13),('1','292','5','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,14),('1','292','5','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,15),('1','292','6','1',180.00,180.00,6033.77,0.00,0.00,0.00,0.00,16),('1','292','6','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,17),('1','292','6','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,18),('1','292','7','1',180.00,180.00,4797.12,0.00,0.00,0.00,0.00,19),('1','292','7','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,20),('1','292','7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,21),('1','292','8','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,22),('1','292','8','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,23),('1','292','8','1',180.00,180.00,6224.45,0.00,0.00,0.00,0.00,24),('1','292','9','1',180.00,180.00,2753.26,0.00,0.00,0.00,0.00,25),('1','292','9','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,26),('1','292','9','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,27),('1','292','10','1',180.00,180.00,2448.98,0.00,0.00,0.00,0.00,28),('1','292','10','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,29),('1','292','10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,30),('1','292','11','1',180.00,180.00,6525.39,0.00,0.00,0.00,0.00,31),('1','292','11','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,32),('1','292','11','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,33),('1','292','12','1',180.00,180.00,6200.01,0.00,0.00,0.00,0.00,34),('1','292','12','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,35),('1','292','12','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,36),('1','292','13','1',180.00,180.00,6451.82,0.00,0.00,0.00,0.00,37),('1','292','13','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,38),('1','292','13','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,39),('1','292','14','1',180.00,180.00,5838.22,0.00,0.00,0.00,0.00,40),('1','292','14','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,41),('1','292','14','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,42),('1','292','15','1',180.00,180.00,7145.07,0.00,0.00,0.00,0.00,43),('1','292','15','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,44),('1','292','15','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,45),('1','292','16','1',180.00,180.00,8401.35,0.00,0.00,0.00,0.00,46),('1','292','16','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,47),('1','292','16','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,48),('1','292','17','1',180.00,180.00,8462.56,0.00,0.00,0.00,0.00,49),('1','292','17','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,50),('1','292','17','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,51),('1','292','18','1',180.00,180.00,2246.39,0.00,0.00,0.00,0.00,52),('1','292','18','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,53),('1','292','18','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,54),('1','292','19','1',180.00,180.00,4402.88,0.00,0.00,0.00,0.00,55),('1','292','19','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,56),('1','292','19','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,57),('1','292','20','1',180.00,180.00,6081.52,0.00,0.00,0.00,0.00,58),('1','292','20','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,59),('1','292','20','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,60),('1','292','21','1',180.00,180.00,6313.95,0.00,0.00,0.00,0.00,61),('1','292','21','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,62),('1','292','21','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,63),('1','292','22','1',180.00,180.00,6039.97,0.00,0.00,0.00,0.00,64),('1','292','22','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,65),('1','292','22','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,66),('1','292','23','1',180.00,180.00,8392.17,0.00,0.00,0.00,0.00,67),('1','292','23','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,68),('1','292','23','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,69),('1','292','24','1',180.00,180.00,3984.13,0.00,0.00,0.00,0.00,70),('1','292','24','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,71),('1','292','24','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,72),('1','292','25','1',180.00,180.00,6271.79,0.00,0.00,0.00,0.00,73),('1','292','25','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,74),('1','292','25','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,75),('1','292','26','1',180.00,180.00,7305.86,0.00,0.00,0.00,0.00,76),('1','292','26','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,77),('1','292','26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,78),('1','292','27','1',180.00,180.00,7542.73,0.00,0.00,0.00,0.00,79),('1','292','27','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,80),('1','292','27','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,81),('1','292','28','1',180.00,180.00,6328.01,0.00,0.00,0.00,0.00,82),('1','292','28','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,83),('1','292','28','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,84),('1','292','29','1',180.00,180.00,5152.60,0.00,0.00,0.00,0.00,85),('1','292','29','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,86),('1','292','29','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,87),('1','292','30','1',180.00,180.00,9429.22,0.00,0.00,0.00,0.00,88),('1','292','30','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,89),('1','292','30','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,90),('1','292','31','1',180.00,180.00,7169.58,0.00,0.00,0.00,0.00,91),('1','292','31','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,92),('1','292','31','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,93),('1','292','32','1',180.00,180.00,8542.02,0.00,0.00,0.00,0.00,94),('1','292','32','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,95),('1','292','32','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,96),('1','292','33','2',840.00,840.00,89.00,0.00,0.00,0.00,0.00,97),('1','292','33','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,98),('1','292','33','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,99),('1','292','34','2',830.00,830.00,30.00,0.00,0.00,0.00,0.00,100),('1','292','34','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,101),('1','292','34','1',210.00,210.00,6018.32,0.00,0.00,0.00,0.00,102),('1','292','35','1',210.00,210.00,8063.80,0.00,0.00,0.00,0.00,103),('1','292','35','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,104),('1','292','35','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,105),('1','292','36','1',210.00,210.00,6579.88,0.00,0.00,0.00,0.00,106),('1','292','36','2',830.00,830.00,685.00,0.00,0.00,0.00,0.00,107),('1','292','36','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,108),('1','292','37','1',210.00,210.00,1226.26,0.00,0.00,0.00,0.00,109),('1','292','37','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,110),('1','292','37','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,111),('1','292','38','2',840.00,840.00,218.00,0.00,0.00,0.00,0.00,112),('1','292','38','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,113),('1','292','38','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,114),('1','292','39','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,115),('1','292','39','2',840.00,840.00,229.00,0.00,0.00,0.00,0.00,116),('1','292','39','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,117),('1','292','40','2',820.00,820.00,91.00,0.00,0.00,0.00,0.00,118),('1','292','40','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,119),('1','292','40','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,120),('1','292','41','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,121),('1','292','41','2',820.00,820.00,116.00,0.00,0.00,0.00,0.00,122),('1','292','41','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,123),('1','292','42','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,124),('1','292','42','2',820.00,820.00,149.00,0.00,0.00,0.00,0.00,125),('1','292','42','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,126),('1','292','43','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,127),('1','292','43','2',820.00,820.00,170.00,0.00,0.00,0.00,0.00,128),('1','292','43','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,129),('1','292','44','2',820.00,820.00,831.00,0.00,0.00,0.00,0.00,130),('1','292','44','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,131),('1','292','44','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,132),('1','292','45','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,133),('1','292','45','2',820.00,820.00,961.00,0.00,0.00,0.00,0.00,134),('1','292','45','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,135),('1','292','46','2',820.00,820.00,170.00,0.00,0.00,0.00,0.00,136),('1','292','46','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,137),('1','292','46','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,138),('1','292','47','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,139),('1','292','47','2',820.00,820.00,110.00,0.00,0.00,0.00,0.00,140),('1','292','47','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,141),('1','292','48','2',820.00,820.00,106.00,0.00,0.00,0.00,0.00,142),('1','292','48','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,143),('1','292','48','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,144),('1','292','49','2',820.00,820.00,78.00,0.00,0.00,0.00,0.00,145),('1','292','49','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,146),('1','292','49','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,147),('1','292','50','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,148),('1','292','50','2',830.00,830.00,288.00,0.00,0.00,0.00,0.00,149),('1','292','50','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,150),('1','292','51','1',240.00,240.00,4112.39,0.00,0.00,0.00,0.00,151),('1','292','51','2',790.00,790.00,100.00,0.00,0.00,0.00,0.00,152),('1','292','51','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,153),('1','292','52','2',790.00,790.00,0.00,0.00,0.00,0.00,0.00,154),('1','292','52','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,155),('1','292','52','1',240.00,240.00,0.00,0.00,0.00,0.00,0.00,156),('1','292','53','1',240.00,240.00,4387.30,0.00,0.00,0.00,0.00,157),('1','292','53','2',790.00,790.00,0.00,0.00,0.00,0.00,0.00,158),('1','292','53','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,159),('1','292','54','1',205.00,205.00,1768.03,0.00,0.00,0.00,0.00,160),('1','292','54','2',790.00,790.00,0.00,0.00,0.00,0.00,0.00,161),('1','292','54','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,162),('1','292','55','1',205.00,205.00,2183.10,0.00,0.00,0.00,0.00,163),('1','292','55','2',790.00,790.00,0.00,0.00,0.00,0.00,0.00,164),('1','292','55','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,165),('1','292','56','1',205.00,205.00,4334.68,0.00,0.00,0.00,0.00,166),('1','292','56','2',790.00,790.00,0.00,0.00,0.00,0.00,0.00,167),('1','292','56','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,168),('1','292','57','1',205.00,205.00,4637.89,0.00,0.00,0.00,0.00,169),('1','292','57','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,170),('1','292','57','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,171),('1','292','58','1',205.00,205.00,5065.85,0.00,0.00,0.00,0.00,172),('1','292','58','2',810.00,810.00,100.00,0.00,0.00,0.00,0.00,173),('1','292','58','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,174),('1','292','59','1',205.00,205.00,5364.41,0.00,0.00,0.00,0.00,175),('1','292','59','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,176),('1','292','59','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,177),('1','292','60','1',205.00,205.00,4343.53,0.00,0.00,0.00,0.00,178),('1','292','60','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,179),('1','292','60','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,180),('1','292','61','1',205.00,205.00,5215.55,0.00,0.00,0.00,0.00,181),('1','292','61','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,182),('1','292','61','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,183),('1','292','62','1',205.00,205.00,5423.14,0.00,0.00,0.00,0.00,184),('1','292','62','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,185),('1','292','62','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,186),('1','292','63','1',235.00,235.00,2149.81,0.00,0.00,0.00,0.00,187),('1','292','63','2',810.00,810.00,100.00,0.00,0.00,0.00,0.00,188),('1','292','63','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,189),('1','292','64','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,190),('1','292','64','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,191),('1','292','64','1',235.00,235.00,6402.02,0.00,0.00,0.00,0.00,192),('1','292','65','1',235.00,235.00,11242.43,0.00,0.00,0.00,0.00,193),('1','292','65','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,194),('1','292','65','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,195),('1','292','66','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,196),('1','292','66','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,197),('1','292','66','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,198),('1','292','67','1',235.00,235.00,9499.84,0.00,0.00,0.00,0.00,199),('1','292','67','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,200),('1','292','67','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,201),('1','292','68','1',235.00,235.00,14607.88,0.00,0.00,0.00,0.00,202),('1','292','68','2',810.00,810.00,100.00,0.00,0.00,0.00,0.00,203),('1','292','68','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,204),('1','292','69','1',235.00,235.00,4637.65,0.00,0.00,0.00,0.00,205),('1','292','69','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,206),('1','292','69','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,207),('1','292','70','1',235.00,235.00,4750.13,0.00,0.00,0.00,0.00,208),('1','292','70','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,209),('1','292','70','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,210),('1','292','71','1',235.00,235.00,8960.31,0.00,0.00,0.00,0.00,211),('1','292','71','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,212),('1','292','71','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,213),('1','292','72','1',235.00,235.00,8375.35,0.00,0.00,0.00,0.00,214),('1','292','72','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,215),('1','292','72','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,216),('1','292','73','1',235.00,235.00,3525.63,0.00,0.00,0.00,0.00,217),('1','292','73','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,218),('1','292','73','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,219),('1','292','74','1',235.00,235.00,13600.30,0.00,0.00,0.00,0.00,220),('1','292','74','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,221),('1','292','74','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,222),('1','292','75','1',235.00,235.00,7128.54,0.00,0.00,0.00,0.00,223),('1','292','75','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,224),('1','292','75','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,225),('1','292','76','1',235.00,235.00,4880.92,0.00,0.00,0.00,0.00,226),('1','292','76','2',810.00,810.00,150.00,0.00,0.00,0.00,0.00,227),('1','292','76','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,228),('1','292','77','2',790.00,790.00,0.00,0.00,0.00,0.00,0.00,229),('1','292','77','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,230),('1','292','77','1',235.00,235.00,6513.76,0.00,0.00,0.00,0.00,231),('1','292','78','1',235.00,235.00,7449.79,0.00,0.00,0.00,0.00,232),('1','292','78','2',790.00,790.00,0.00,0.00,0.00,0.00,0.00,233),('1','292','78','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,234),('1','292','79','2',790.00,790.00,0.00,0.00,0.00,0.00,0.00,235),('1','292','79','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,236),('1','292','79','1',235.00,235.00,3169.87,0.00,0.00,0.00,0.00,237),('1','292','80','1',235.00,235.00,8578.07,0.00,0.00,0.00,0.00,238),('1','292','80','2',790.00,790.00,0.00,0.00,0.00,0.00,0.00,239),('1','292','80','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,240),('1','292','81','1',235.00,235.00,7854.92,0.00,0.00,0.00,0.00,241),('1','292','81','2',790.00,790.00,0.00,0.00,0.00,0.00,0.00,242),('1','292','81','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,243),('1','292','82','1',235.00,235.00,3624.81,0.00,0.00,0.00,0.00,244),('1','292','82','2',790.00,790.00,0.00,0.00,0.00,0.00,0.00,245),('1','292','82','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,246),('1','292','83','2',790.00,790.00,0.00,0.00,0.00,0.00,0.00,247),('1','292','83','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,248),('1','292','83','1',235.00,235.00,7192.35,0.00,0.00,0.00,0.00,249),('1','292','84','1',235.00,235.00,9814.24,0.00,0.00,0.00,0.00,250),('1','292','84','2',790.00,790.00,0.00,0.00,0.00,0.00,0.00,251),('1','292','84','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,252),('1','292','85','1',235.00,235.00,4378.71,0.00,0.00,0.00,0.00,253),('1','292','85','2',790.00,790.00,0.00,0.00,0.00,0.00,0.00,254),('1','292','85','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,255),('1','292','86','1',235.00,235.00,8652.28,0.00,0.00,0.00,0.00,256),('1','292','86','2',790.00,790.00,0.00,0.00,0.00,0.00,0.00,257),('1','292','86','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,258),('1','292','87','1',235.00,235.00,5673.40,0.00,0.00,0.00,0.00,259),('1','292','87','2',790.00,790.00,0.00,0.00,0.00,0.00,0.00,260),('1','292','87','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,261),('1','292','88','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,262),('1','292','88','2',790.00,790.00,0.00,0.00,0.00,0.00,0.00,263),('1','292','88','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,264);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
INSERT INTO `depots_shifts_stocklevels` VALUES (1,'1','292','1','2022-11-02 16:32:43','967','1',0.00,48550.00,0.00),(2,'1','292','6','2022-11-08 12:05:19','967','1',180.00,44750.00,8055000.00),(3,'1','292','12','2022-11-10 16:48:34','967','1',180.00,49200.00,8856000.00),(4,'1','292','15','2022-11-11 14:46:36','967','1',180.00,50000.00,9000000.00),(5,'1','292','36','2022-11-30 11:42:10','967','1',210.00,20500.00,4305000.00),(6,'1','292','51','2023-02-02 14:56:32','967','1',240.00,17000.00,4080000.00),(7,'1','292','57','2023-02-16 12:20:46','967','1',205.00,29750.00,6098750.00),(8,'1','292','63','2023-03-03 12:59:41','967','1',235.00,16500.00,3877500.00),(9,'1','292','71','2023-03-10 09:41:33','967','1',235.00,44550.00,10469250.00),(10,'1','292','71','2023-03-10 09:43:41','967','1',235.00,58150.00,13665250.00);
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',1,'292','PMS TANKS',''),('1',2,'292','AGO TANKS',''),('1',3,'292','DPK TANK','');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','292','1',1,0,'1','PMS TANK 1 & 2',80000.00,0.00,NULL,'CONTAING PMS','178','2022-10-19 10:45:26','2022-10-19 10:45:26','178',5,0),('1','292','1',2,0,'1','PMS TANK 3 & 4',80000.00,0.00,NULL,'CONTAING PMS','178','2022-10-19 10:47:01','2022-10-19 10:47:01','178',5,0),('1','292','1',3,0,'1','PMS TANK 5 & 6',80000.00,0.00,NULL,'CONTAING PMS','178','2022-10-19 10:49:32','2022-10-19 10:49:52','178',5,0),('1','292','2',4,0,'2','AGO TANK',40000.00,0.00,NULL,'CONTAING AGO','178','2022-10-19 10:51:08','2022-10-19 10:51:08','178',5,0),('1','292','3',5,0,'3','DPK TANK',40000.00,0.00,NULL,'CONTAINING DPK','178','2022-10-19 10:52:47','2022-10-19 10:52:47','178',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','292',5,0.00,'2023-03-20 13:24:16'),(2,'1','292',4,25129.00,'2023-03-20 13:24:16'),(3,'1','292',3,7856.97,'2023-03-20 13:24:16'),(4,'1','292',2,6304.29,'2023-03-20 13:24:16'),(5,'1','292',1,2771.26,'2023-03-20 13:24:16');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=517 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'1','292',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9000000.00,50000.00,0.00,0.00,'2022-11-02 15:35:51','',''),(2,'1','292',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8100000.00,45000.00,0.00,0.00,'2022-11-02 15:36:12','',''),(3,'1','292',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9000000.00,50000.00,0.00,0.00,'2022-11-02 15:36:24','',''),(4,'1','292',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9000000.00,50000.00,0.00,0.00,'2022-11-02 15:36:37','',''),(5,'1','292',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,24000000.00,30000.00,0.00,0.00,'2022-11-02 15:36:50','',''),(6,'1','292','1',1,'Sale Id shift 1',0.00,0.00,0.00,368.46,0.00,'2022-11-06 14:22:42','',''),(7,'1','292','1',1,'Sale Id shift 1',0.00,0.00,0.00,449.50,0.00,'2022-11-06 14:22:42','',''),(8,'1','292','1',1,'Sale Id shift 1',0.00,0.00,0.00,390.82,0.00,'2022-11-06 14:22:42','',''),(9,'1','292','1',1,'Sale Id shift 1',0.00,0.00,0.00,424.47,0.00,'2022-11-06 14:22:42','',''),(10,'1','292','2',1,'Sale Id shift 1',0.00,0.00,0.00,394.04,0.00,'2022-11-06 14:22:42','',''),(11,'1','292','2',1,'Sale Id shift 1',0.00,0.00,0.00,62.68,0.00,'2022-11-06 14:22:42','',''),(12,'1','292','3',1,'Sale Id shift 1',0.00,0.00,0.00,48.34,0.00,'2022-11-06 14:22:42','',''),(13,'1','292','3',1,'Sale Id shift 1',0.00,0.00,0.00,548.27,0.00,'2022-11-06 14:22:42','',''),(14,'1','292',NULL,1,'Sale Id shift 1',483584.40,0.00,0.00,0.00,0.00,'2022-11-06 14:22:42','',''),(15,'1','292','1',1,'Sale Id shift 2',0.00,0.00,0.00,899.24,0.00,'2022-11-06 20:52:04','',''),(16,'1','292','1',1,'Sale Id shift 2',0.00,0.00,0.00,921.71,0.00,'2022-11-06 20:52:04','',''),(17,'1','292','1',1,'Sale Id shift 2',0.00,0.00,0.00,695.00,0.00,'2022-11-06 20:52:04','',''),(18,'1','292','1',1,'Sale Id shift 2',0.00,0.00,0.00,705.64,0.00,'2022-11-06 20:52:04','',''),(19,'1','292','2',1,'Sale Id shift 2',0.00,0.00,0.00,683.96,0.00,'2022-11-06 20:52:04','',''),(20,'1','292','2',1,'Sale Id shift 2',0.00,0.00,0.00,2.88,0.00,'2022-11-06 20:52:04','',''),(21,'1','292','3',1,'Sale Id shift 2',0.00,0.00,0.00,902.96,0.00,'2022-11-06 20:52:04','',''),(22,'1','292',NULL,1,'Sale Id shift 2',866050.20,0.00,0.00,0.00,0.00,'2022-11-06 20:52:04','',''),(23,'1','292','1',1,'Sale Id shift 3',0.00,0.00,0.00,1090.76,0.00,'2022-11-06 21:15:24','',''),(24,'1','292','1',1,'Sale Id shift 3',0.00,0.00,0.00,1090.21,0.00,'2022-11-06 21:15:24','',''),(25,'1','292','1',1,'Sale Id shift 3',0.00,0.00,0.00,933.67,0.00,'2022-11-06 21:15:24','',''),(26,'1','292','1',1,'Sale Id shift 3',0.00,0.00,0.00,682.98,0.00,'2022-11-06 21:15:24','',''),(27,'1','292','2',1,'Sale Id shift 3',0.00,0.00,0.00,567.57,0.00,'2022-11-06 21:15:24','',''),(28,'1','292','3',1,'Sale Id shift 3',0.00,0.00,0.00,1071.83,0.00,'2022-11-06 21:15:24','',''),(29,'1','292',NULL,1,'Sale Id shift 3',978663.60,0.00,0.00,0.00,0.00,'2022-11-06 21:15:24','',''),(30,'1','292','1',1,'Sale Id shift 4',0.00,0.00,0.00,1005.28,0.00,'2022-11-07 08:26:57','',''),(31,'1','292','1',1,'Sale Id shift 4',0.00,0.00,0.00,1086.35,0.00,'2022-11-07 08:26:57','',''),(32,'1','292','1',1,'Sale Id shift 4',0.00,0.00,0.00,932.85,0.00,'2022-11-07 08:26:57','',''),(33,'1','292','1',1,'Sale Id shift 4',0.00,0.00,0.00,660.05,0.00,'2022-11-07 08:26:57','',''),(34,'1','292','2',1,'Sale Id shift 4',0.00,0.00,0.00,558.91,0.00,'2022-11-07 08:26:57','',''),(35,'1','292','2',1,'Sale Id shift 4',0.00,0.00,0.00,0.10,0.00,'2022-11-07 08:26:57','',''),(36,'1','292','3',1,'Sale Id shift 4',0.00,0.00,0.00,849.31,0.00,'2022-11-07 08:26:57','',''),(37,'1','292',NULL,1,'Sale Id shift 4',916713.00,0.00,0.00,0.00,0.00,'2022-11-07 08:26:57','',''),(38,'1','292','1',1,'Sale Id shift 5',0.00,0.00,0.00,902.95,0.00,'2022-11-08 04:18:27','',''),(39,'1','292','1',1,'Sale Id shift 5',0.00,0.00,0.00,833.94,0.00,'2022-11-08 04:18:27','',''),(40,'1','292','1',1,'Sale Id shift 5',0.00,0.00,0.00,731.81,0.00,'2022-11-08 04:18:27','',''),(41,'1','292','1',1,'Sale Id shift 5',0.00,0.00,0.00,593.47,0.00,'2022-11-08 04:18:27','',''),(42,'1','292','2',1,'Sale Id shift 5',0.00,0.00,0.00,657.63,0.00,'2022-11-08 04:18:27','',''),(43,'1','292','2',1,'Sale Id shift 5',0.00,0.00,0.00,0.10,0.00,'2022-11-08 04:18:27','',''),(44,'1','292','3',1,'Sale Id shift 5',0.00,0.00,0.00,997.78,0.00,'2022-11-08 04:18:27','',''),(45,'1','292',NULL,1,'Sale Id shift 5',849182.40,0.00,0.00,0.00,0.00,'2022-11-08 04:18:27','',''),(46,'1','292','2',1,'Sale Id shift 6',0.00,0.00,0.00,2120.60,0.00,'2022-11-08 16:47:36','',''),(47,'1','292','2',1,'Sale Id shift 6',0.00,0.00,0.00,0.41,0.00,'2022-11-08 16:47:36','',''),(48,'1','292','3',1,'Sale Id shift 6',0.00,0.00,0.00,1912.98,0.00,'2022-11-08 16:47:36','',''),(49,'1','292','3',1,'Sale Id shift 6',0.00,0.00,0.00,1999.78,0.00,'2022-11-08 16:47:36','',''),(50,'1','292',NULL,1,'Sale Id shift 6',1086078.60,0.00,0.00,0.00,0.00,'2022-11-08 16:47:36','',''),(51,'1','292','1',1,'Sale Id shift 7',0.00,0.00,0.00,699.91,0.00,'2022-11-08 23:16:44','',''),(52,'1','292','1',1,'Sale Id shift 7',0.00,0.00,0.00,1061.03,0.00,'2022-11-08 23:16:44','',''),(53,'1','292','1',1,'Sale Id shift 7',0.00,0.00,0.00,763.16,0.00,'2022-11-08 23:16:44','',''),(54,'1','292','2',1,'Sale Id shift 7',0.00,0.00,0.00,774.18,0.00,'2022-11-08 23:16:44','',''),(55,'1','292','2',1,'Sale Id shift 7',0.00,0.00,0.00,0.22,0.00,'2022-11-08 23:16:44','',''),(56,'1','292','3',1,'Sale Id shift 7',0.00,0.00,0.00,1498.62,0.00,'2022-11-08 23:16:44','',''),(57,'1','292',NULL,1,'Sale Id shift 7',863481.60,0.00,0.00,0.00,0.00,'2022-11-08 23:16:44','',''),(58,'1','292','1',1,'Sale Id shift 8',0.00,0.00,0.00,1260.64,0.00,'2022-11-09 19:27:19','',''),(59,'1','292','1',1,'Sale Id shift 8',0.00,0.00,0.00,1262.07,0.00,'2022-11-09 19:27:19','',''),(60,'1','292','2',1,'Sale Id shift 8',0.00,0.00,0.00,0.29,0.00,'2022-11-09 19:27:19','',''),(61,'1','292','2',1,'Sale Id shift 8',0.00,0.00,0.00,1728.48,0.00,'2022-11-09 19:27:19','',''),(62,'1','292','3',1,'Sale Id shift 8',0.00,0.00,0.00,1063.42,0.00,'2022-11-09 19:27:19','',''),(63,'1','292','3',1,'Sale Id shift 8',0.00,0.00,0.00,909.55,0.00,'2022-11-09 19:27:19','',''),(64,'1','292',NULL,1,'Sale Id shift 8',1120401.00,0.00,0.00,0.00,0.00,'2022-11-09 19:27:19','',''),(65,'1','292','1',1,'Sale Id shift 9',0.00,0.00,0.00,784.67,0.00,'2022-11-10 13:00:19','',''),(66,'1','292','1',1,'Sale Id shift 9',0.00,0.00,0.00,902.60,0.00,'2022-11-10 13:00:19','',''),(67,'1','292','3',1,'Sale Id shift 9',0.00,0.00,0.00,1065.99,0.00,'2022-11-10 13:00:19','',''),(68,'1','292',NULL,1,'Sale Id shift 9',495586.80,0.00,0.00,0.00,0.00,'2022-11-10 13:00:19','',''),(69,'1','292','1',1,'Sale Id shift 10',0.00,0.00,0.00,1073.00,0.00,'2022-11-10 15:21:46','',''),(70,'1','292','1',1,'Sale Id shift 10',0.00,0.00,0.00,0.20,0.00,'2022-11-10 15:21:46','',''),(71,'1','292','2',1,'Sale Id shift 10',0.00,0.00,0.00,578.05,0.00,'2022-11-10 15:21:46','',''),(72,'1','292','2',1,'Sale Id shift 10',0.00,0.00,0.00,0.28,0.00,'2022-11-10 15:21:46','',''),(73,'1','292','3',1,'Sale Id shift 10',0.00,0.00,0.00,797.45,0.00,'2022-11-10 15:21:46','',''),(74,'1','292',NULL,1,'Sale Id shift 10',440816.40,0.00,0.00,0.00,0.00,'2022-11-10 15:21:46','',''),(75,'1','292','1',1,'Sale Id shift 11',0.00,0.00,0.00,1782.24,0.00,'2022-11-10 16:30:32','',''),(76,'1','292','1',1,'Sale Id shift 11',0.00,0.00,0.00,1120.20,0.00,'2022-11-10 16:30:32','',''),(77,'1','292','2',1,'Sale Id shift 11',0.00,0.00,0.00,619.67,0.00,'2022-11-10 16:30:32','',''),(78,'1','292','2',1,'Sale Id shift 11',0.00,0.00,0.00,952.07,0.00,'2022-11-10 16:30:32','',''),(79,'1','292','3',1,'Sale Id shift 11',0.00,0.00,0.00,907.96,0.00,'2022-11-10 16:30:32','',''),(80,'1','292','3',1,'Sale Id shift 11',0.00,0.00,0.00,1143.25,0.00,'2022-11-10 16:30:32','',''),(81,'1','292',NULL,1,'Sale Id shift 11',1174570.20,0.00,0.00,0.00,0.00,'2022-11-10 16:30:32','',''),(82,'1','292','1',1,'Sale Id shift 12',0.00,0.00,0.00,1169.09,0.00,'2022-11-10 17:39:17','',''),(83,'1','292','1',1,'Sale Id shift 12',0.00,0.00,0.00,1185.75,0.00,'2022-11-10 17:39:17','',''),(84,'1','292','2',1,'Sale Id shift 12',0.00,0.00,0.00,1614.33,0.00,'2022-11-10 17:39:17','',''),(85,'1','292','3',1,'Sale Id shift 12',0.00,0.00,0.00,1285.20,0.00,'2022-11-10 17:39:17','',''),(86,'1','292','3',1,'Sale Id shift 12',0.00,0.00,0.00,945.64,0.00,'2022-11-10 17:39:17','',''),(87,'1','292',NULL,1,'Sale Id shift 12',1116001.80,0.00,0.00,0.00,0.00,'2022-11-10 17:39:17','',''),(88,'1','292','1',1,'Sale Id shift 13',0.00,0.00,0.00,1248.28,0.00,'2022-11-11 10:38:26','',''),(89,'1','292','1',1,'Sale Id shift 13',0.00,0.00,0.00,1423.98,0.00,'2022-11-11 10:38:26','',''),(90,'1','292','2',1,'Sale Id shift 13',0.00,0.00,0.00,723.06,0.00,'2022-11-11 10:38:26','',''),(91,'1','292','2',1,'Sale Id shift 13',0.00,0.00,0.00,797.34,0.00,'2022-11-11 10:38:26','',''),(92,'1','292','3',1,'Sale Id shift 13',0.00,0.00,0.00,1079.89,0.00,'2022-11-11 10:38:26','',''),(93,'1','292','3',1,'Sale Id shift 13',0.00,0.00,0.00,1179.27,0.00,'2022-11-11 10:38:26','',''),(94,'1','292',NULL,1,'Sale Id shift 13',1161327.60,0.00,0.00,0.00,0.00,'2022-11-11 10:38:26','',''),(95,'1','292','1',1,'Sale Id shift 14',0.00,0.00,0.00,660.71,0.00,'2022-11-11 12:20:32','',''),(96,'1','292','1',1,'Sale Id shift 14',0.00,0.00,0.00,995.22,0.00,'2022-11-11 12:20:32','',''),(97,'1','292','1',1,'Sale Id shift 14',0.00,0.00,0.00,1136.65,0.00,'2022-11-11 12:20:32','',''),(98,'1','292','1',1,'Sale Id shift 14',0.00,0.00,0.00,744.48,0.00,'2022-11-11 12:20:32','',''),(99,'1','292','2',1,'Sale Id shift 14',0.00,0.00,0.00,468.71,0.00,'2022-11-11 12:20:32','',''),(100,'1','292','2',1,'Sale Id shift 14',0.00,0.00,0.00,0.15,0.00,'2022-11-11 12:20:32','',''),(101,'1','292','3',1,'Sale Id shift 14',0.00,0.00,0.00,1087.56,0.00,'2022-11-11 12:20:32','',''),(102,'1','292','3',1,'Sale Id shift 14',0.00,0.00,0.00,744.74,0.00,'2022-11-11 12:20:32','',''),(103,'1','292',NULL,1,'Sale Id shift 14',1050879.60,0.00,0.00,0.00,0.00,'2022-11-11 12:20:32','',''),(104,'1','292','1',1,'Sale Id shift 15',0.00,0.00,0.00,1387.56,0.00,'2022-11-11 15:05:45','',''),(105,'1','292','1',1,'Sale Id shift 15',0.00,0.00,0.00,1080.81,0.00,'2022-11-11 15:05:45','',''),(106,'1','292','1',1,'Sale Id shift 15',0.00,0.00,0.00,1762.79,0.00,'2022-11-11 15:05:45','',''),(107,'1','292','1',1,'Sale Id shift 15',0.00,0.00,0.00,0.04,0.00,'2022-11-11 15:05:45','',''),(108,'1','292','2',1,'Sale Id shift 15',0.00,0.00,0.00,438.15,0.00,'2022-11-11 15:05:45','',''),(109,'1','292','2',1,'Sale Id shift 15',0.00,0.00,0.00,253.66,0.00,'2022-11-11 15:05:45','',''),(110,'1','292','3',1,'Sale Id shift 15',0.00,0.00,0.00,1369.75,0.00,'2022-11-11 15:05:45','',''),(111,'1','292','3',1,'Sale Id shift 15',0.00,0.00,0.00,852.31,0.00,'2022-11-11 15:05:45','',''),(112,'1','292',NULL,1,'Sale Id shift 15',1286112.60,0.00,0.00,0.00,0.00,'2022-11-11 15:05:45','',''),(113,'1','292','1',1,'Sale Id shift 16',0.00,0.00,0.00,1164.13,0.00,'2022-11-11 15:40:29','',''),(114,'1','292','1',1,'Sale Id shift 16',0.00,0.00,0.00,1450.23,0.00,'2022-11-11 15:40:29','',''),(115,'1','292','1',1,'Sale Id shift 16',0.00,0.00,0.00,473.80,0.00,'2022-11-11 15:40:29','',''),(116,'1','292','1',1,'Sale Id shift 16',0.00,0.00,0.00,1271.44,0.00,'2022-11-11 15:40:29','',''),(117,'1','292','2',1,'Sale Id shift 16',0.00,0.00,0.00,1233.45,0.00,'2022-11-11 15:40:29','',''),(118,'1','292','2',1,'Sale Id shift 16',0.00,0.00,0.00,0.20,0.00,'2022-11-11 15:40:29','',''),(119,'1','292','3',1,'Sale Id shift 16',0.00,0.00,0.00,1561.26,0.00,'2022-11-11 15:40:29','',''),(120,'1','292','3',1,'Sale Id shift 16',0.00,0.00,0.00,1246.84,0.00,'2022-11-11 15:40:29','',''),(121,'1','292',NULL,1,'Sale Id shift 16',1512243.00,0.00,0.00,0.00,0.00,'2022-11-11 15:40:29','',''),(122,'1','292','1',1,'Sale Id shift 17',0.00,0.00,0.00,1541.00,0.00,'2022-11-11 15:51:57','',''),(123,'1','292','1',1,'Sale Id shift 17',0.00,0.00,0.00,906.82,0.00,'2022-11-11 15:51:57','',''),(124,'1','292','1',1,'Sale Id shift 17',0.00,0.00,0.00,1386.32,0.00,'2022-11-11 15:51:57','',''),(125,'1','292','1',1,'Sale Id shift 17',0.00,0.00,0.00,871.25,0.00,'2022-11-11 15:51:57','',''),(126,'1','292','2',1,'Sale Id shift 17',0.00,0.00,0.00,566.46,0.00,'2022-11-11 15:51:57','',''),(127,'1','292','2',1,'Sale Id shift 17',0.00,0.00,0.00,655.40,0.00,'2022-11-11 15:51:57','',''),(128,'1','292','3',1,'Sale Id shift 17',0.00,0.00,0.00,1475.53,0.00,'2022-11-11 15:51:57','',''),(129,'1','292','3',1,'Sale Id shift 17',0.00,0.00,0.00,1059.78,0.00,'2022-11-11 15:51:57','',''),(130,'1','292',NULL,1,'Sale Id shift 17',1523260.80,0.00,0.00,0.00,0.00,'2022-11-11 15:51:57','',''),(131,'1','292','1',1,'Sale Id shift 18',0.00,0.00,0.00,569.56,0.00,'2022-11-11 16:04:39','',''),(132,'1','292','1',1,'Sale Id shift 18',0.00,0.00,0.00,845.50,0.00,'2022-11-11 16:04:39','',''),(133,'1','292','1',1,'Sale Id shift 18',0.00,0.00,0.00,0.29,0.00,'2022-11-11 16:04:39','',''),(134,'1','292','2',1,'Sale Id shift 18',0.00,0.00,0.00,397.85,0.00,'2022-11-11 16:04:39','',''),(135,'1','292','2',1,'Sale Id shift 18',0.00,0.00,0.00,0.21,0.00,'2022-11-11 16:04:39','',''),(136,'1','292','3',1,'Sale Id shift 18',0.00,0.00,0.00,432.85,0.00,'2022-11-11 16:04:39','',''),(137,'1','292','3',1,'Sale Id shift 18',0.00,0.00,0.00,0.13,0.00,'2022-11-11 16:04:39','',''),(138,'1','292',NULL,1,'Sale Id shift 18',404350.20,0.00,0.00,0.00,0.00,'2022-11-11 16:04:39','',''),(139,'1','292','1',1,'Sale Id shift 19',0.00,0.00,0.00,40.60,0.00,'2022-11-11 16:45:39','',''),(140,'1','292','1',1,'Sale Id shift 19',0.00,0.00,0.00,1296.92,0.00,'2022-11-11 16:45:39','',''),(141,'1','292','1',1,'Sale Id shift 19',0.00,0.00,0.00,0.01,0.00,'2022-11-11 16:45:39','',''),(142,'1','292','1',1,'Sale Id shift 19',0.00,0.00,0.00,1202.20,0.00,'2022-11-11 16:45:39','',''),(143,'1','292','2',1,'Sale Id shift 19',0.00,0.00,0.00,835.46,0.00,'2022-11-11 16:45:39','',''),(144,'1','292','3',1,'Sale Id shift 19',0.00,0.00,0.00,1027.69,0.00,'2022-11-11 16:45:39','',''),(145,'1','292',NULL,1,'Sale Id shift 19',792518.40,0.00,0.00,0.00,0.00,'2022-11-11 16:45:39','',''),(146,'1','292','1',1,'Sale Id shift 20',0.00,0.00,0.00,1704.74,0.00,'2022-11-12 08:14:29','',''),(147,'1','292','1',1,'Sale Id shift 20',0.00,0.00,0.00,1136.56,0.00,'2022-11-12 08:14:29','',''),(148,'1','292','2',1,'Sale Id shift 20',0.00,0.00,0.00,1302.47,0.00,'2022-11-12 08:14:29','',''),(149,'1','292','3',1,'Sale Id shift 20',0.00,0.00,0.00,1481.36,0.00,'2022-11-12 08:14:29','',''),(150,'1','292','3',1,'Sale Id shift 20',0.00,0.00,0.00,456.39,0.00,'2022-11-12 08:14:29','',''),(151,'1','292',NULL,1,'Sale Id shift 20',1094673.60,0.00,0.00,0.00,0.00,'2022-11-12 08:14:29','',''),(152,'1','292','1',1,'Sale Id shift 21',0.00,0.00,0.00,0.43,0.00,'2022-11-12 08:53:41','',''),(153,'1','292','1',1,'Sale Id shift 21',0.00,0.00,0.00,1042.89,0.00,'2022-11-12 08:53:41','',''),(154,'1','292','1',1,'Sale Id shift 21',0.00,0.00,0.00,1443.14,0.00,'2022-11-12 08:53:41','',''),(155,'1','292','2',1,'Sale Id shift 21',0.00,0.00,0.00,0.22,0.00,'2022-11-12 08:53:41','',''),(156,'1','292','2',1,'Sale Id shift 21',0.00,0.00,0.00,1531.36,0.00,'2022-11-12 08:53:41','',''),(157,'1','292','3',1,'Sale Id shift 21',0.00,0.00,0.00,2295.91,0.00,'2022-11-12 08:53:41','',''),(158,'1','292',NULL,1,'Sale Id shift 21',1136511.00,0.00,0.00,0.00,0.00,'2022-11-12 08:53:41','',''),(159,'1','292','1',1,'Sale Id shift 22',0.00,0.00,0.00,1286.91,0.00,'2022-11-12 09:13:43','',''),(160,'1','292','1',1,'Sale Id shift 22',0.00,0.00,0.00,2237.53,0.00,'2022-11-12 09:13:43','',''),(161,'1','292','2',1,'Sale Id shift 22',0.00,0.00,0.00,642.44,0.00,'2022-11-12 09:13:43','',''),(162,'1','292','3',1,'Sale Id shift 22',0.00,0.00,0.00,1873.09,0.00,'2022-11-12 09:13:43','',''),(163,'1','292',NULL,1,'Sale Id shift 22',1087194.60,0.00,0.00,0.00,0.00,'2022-11-12 09:13:43','',''),(164,'1','292','1',1,'Sale Id shift 23',0.00,0.00,0.00,2458.59,0.00,'2022-11-12 09:18:30','',''),(165,'1','292','1',1,'Sale Id shift 23',0.00,0.00,0.00,1524.96,0.00,'2022-11-12 09:18:30','',''),(166,'1','292','2',1,'Sale Id shift 23',0.00,0.00,0.00,2245.19,0.00,'2022-11-12 09:18:30','',''),(167,'1','292','3',1,'Sale Id shift 23',0.00,0.00,0.00,2163.43,0.00,'2022-11-12 09:18:30','',''),(168,'1','292',NULL,1,'Sale Id shift 23',1510590.60,0.00,0.00,0.00,0.00,'2022-11-12 09:18:30','',''),(169,'1','292','1',1,'Sale Id shift 24',0.00,0.00,0.00,1493.72,0.00,'2022-11-12 09:30:00','',''),(170,'1','292','1',1,'Sale Id shift 24',0.00,0.00,0.00,312.62,0.00,'2022-11-12 09:30:00','',''),(171,'1','292','2',1,'Sale Id shift 24',0.00,0.00,0.00,1276.51,0.00,'2022-11-12 09:30:00','',''),(172,'1','292','3',1,'Sale Id shift 24',0.00,0.00,0.00,901.28,0.00,'2022-11-12 09:30:00','',''),(173,'1','292',NULL,1,'Sale Id shift 24',717143.40,0.00,0.00,0.00,0.00,'2022-11-12 09:30:00','',''),(174,'1','292','1',1,'Sale Id shift 25',0.00,0.00,0.00,1763.73,0.00,'2022-11-12 09:43:59','',''),(175,'1','292','1',1,'Sale Id shift 25',0.00,0.00,0.00,249.56,0.00,'2022-11-12 09:43:59','',''),(176,'1','292','1',1,'Sale Id shift 25',0.00,0.00,0.00,1165.68,0.00,'2022-11-12 09:43:59','',''),(177,'1','292','2',1,'Sale Id shift 25',0.00,0.00,0.00,1345.01,0.00,'2022-11-12 09:43:59','',''),(178,'1','292','3',1,'Sale Id shift 25',0.00,0.00,0.00,1747.81,0.00,'2022-11-12 09:43:59','',''),(179,'1','292',NULL,1,'Sale Id shift 25',1128922.20,0.00,0.00,0.00,0.00,'2022-11-12 09:43:59','',''),(180,'1','292','2',1,'Sale Id shift 26',0.00,0.00,0.00,2797.81,0.00,'2022-11-12 10:15:05','',''),(181,'1','292','2',1,'Sale Id shift 26',0.00,0.00,0.00,1279.33,0.00,'2022-11-12 10:15:05','',''),(182,'1','292','3',1,'Sale Id shift 26',0.00,0.00,0.00,1027.71,0.00,'2022-11-12 10:15:05','',''),(183,'1','292','3',1,'Sale Id shift 26',0.00,0.00,0.00,2201.01,0.00,'2022-11-12 10:15:05','',''),(184,'1','292',NULL,1,'Sale Id shift 26',1315054.80,0.00,0.00,0.00,0.00,'2022-11-12 10:15:05','',''),(185,'1','292','2',1,'Sale Id shift 27',0.00,0.00,0.00,3029.40,0.00,'2022-11-12 11:02:27','',''),(186,'1','292','2',1,'Sale Id shift 27',0.00,0.00,0.00,1712.74,0.00,'2022-11-12 11:02:27','',''),(187,'1','292','3',1,'Sale Id shift 27',0.00,0.00,0.00,1645.94,0.00,'2022-11-12 11:02:27','',''),(188,'1','292','3',1,'Sale Id shift 27',0.00,0.00,0.00,1154.65,0.00,'2022-11-12 11:02:27','',''),(189,'1','292',NULL,1,'Sale Id shift 27',1357691.40,0.00,0.00,0.00,0.00,'2022-11-12 11:02:27','',''),(190,'1','292','1',1,'Sale Id shift 28',0.00,0.00,0.00,6.26,0.00,'2022-11-12 11:12:36','',''),(191,'1','292','2',1,'Sale Id shift 28',0.00,0.00,0.00,3318.02,0.00,'2022-11-12 11:12:36','',''),(192,'1','292','2',1,'Sale Id shift 28',0.00,0.00,0.00,3003.73,0.00,'2022-11-12 11:12:36','',''),(193,'1','292',NULL,1,'Sale Id shift 28',1139041.80,0.00,0.00,0.00,0.00,'2022-11-12 11:12:36','',''),(194,'1','292','1',1,'Sale Id shift 29',0.00,0.00,0.00,64.88,0.00,'2022-11-12 11:28:05','',''),(195,'1','292','1',1,'Sale Id shift 29',0.00,0.00,0.00,1013.60,0.00,'2022-11-12 11:28:05','',''),(196,'1','292','1',1,'Sale Id shift 29',0.00,0.00,0.00,1304.86,0.00,'2022-11-12 11:28:05','',''),(197,'1','292','1',1,'Sale Id shift 29',0.00,0.00,0.00,66.19,0.00,'2022-11-12 11:28:05','',''),(198,'1','292','2',1,'Sale Id shift 29',0.00,0.00,0.00,1431.55,0.00,'2022-11-12 11:28:05','',''),(199,'1','292','2',1,'Sale Id shift 29',0.00,0.00,0.00,1271.52,0.00,'2022-11-12 11:28:05','',''),(200,'1','292',NULL,1,'Sale Id shift 29',927468.00,0.00,0.00,0.00,0.00,'2022-11-12 11:28:05','',''),(201,'1','292','1',1,'Sale Id shift 30',0.00,0.00,0.00,2832.13,0.00,'2022-11-12 11:56:35','',''),(202,'1','292','1',1,'Sale Id shift 30',0.00,0.00,0.00,2408.97,0.00,'2022-11-12 11:56:35','',''),(203,'1','292','1',1,'Sale Id shift 30',0.00,0.00,0.00,1454.62,0.00,'2022-11-12 11:56:35','',''),(204,'1','292','2',1,'Sale Id shift 30',0.00,0.00,0.00,2733.50,0.00,'2022-11-12 11:56:35','',''),(205,'1','292',NULL,1,'Sale Id shift 30',1697259.60,0.00,0.00,0.00,0.00,'2022-11-12 11:56:35','',''),(206,'1','292','1',1,'Sale Id shift 31',0.00,0.00,0.00,2169.15,0.00,'2022-11-12 12:09:11','',''),(207,'1','292','1',1,'Sale Id shift 31',0.00,0.00,0.00,2082.90,0.00,'2022-11-12 12:09:11','',''),(208,'1','292','2',1,'Sale Id shift 31',0.00,0.00,0.00,652.90,0.00,'2022-11-12 12:09:11','',''),(209,'1','292','2',1,'Sale Id shift 31',0.00,0.00,0.00,2264.63,0.00,'2022-11-12 12:09:11','',''),(210,'1','292',NULL,1,'Sale Id shift 31',1290524.40,0.00,0.00,0.00,0.00,'2022-11-12 12:09:11','',''),(211,'1','292','1',1,'Sale Id shift 32',0.00,0.00,0.00,1903.62,0.00,'2022-11-12 12:24:21','',''),(212,'1','292','1',1,'Sale Id shift 32',0.00,0.00,0.00,2517.50,0.00,'2022-11-12 12:24:21','',''),(213,'1','292','1',1,'Sale Id shift 32',0.00,0.00,0.00,2999.34,0.00,'2022-11-12 12:24:21','',''),(214,'1','292','1',1,'Sale Id shift 32',0.00,0.00,0.00,1121.56,0.00,'2022-11-12 12:24:21','',''),(215,'1','292',NULL,1,'Sale Id shift 32',1537563.60,0.00,0.00,0.00,0.00,'2022-11-12 12:24:21','',''),(216,'1','292','4',2,'Sale Id shift 33',0.00,0.00,0.00,89.00,0.00,'2022-11-27 15:06:19','',''),(217,'1','292',NULL,2,'Sale Id shift 33',74760.00,0.00,0.00,0.00,0.00,'2022-11-27 15:06:19','',''),(218,'1','292',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,4725000.00,22500.00,0.00,0.00,'2022-11-29 16:51:03','',''),(219,'1','292','2',1,'Sale Id shift 34',0.00,0.00,0.00,3138.62,0.00,'2022-11-29 17:46:26','',''),(220,'1','292','2',1,'Sale Id shift 34',0.00,0.00,0.00,2879.70,0.00,'2022-11-29 17:46:26','',''),(221,'1','292','4',2,'Sale Id shift 34',0.00,0.00,0.00,30.00,0.00,'2022-11-29 17:46:26','',''),(222,'1','292',NULL,2,'Sale Id shift 34',24900.00,0.00,0.00,0.00,0.00,'2022-11-29 17:46:26','',''),(223,'1','292',NULL,1,'Sale Id shift 34',1263847.20,0.00,0.00,0.00,0.00,'2022-11-29 17:46:26','',''),(224,'1','292','2',1,'Sale Id shift 35',0.00,0.00,0.00,4228.02,0.00,'2022-11-30 07:59:16','',''),(225,'1','292','2',1,'Sale Id shift 35',0.00,0.00,0.00,3835.78,0.00,'2022-11-30 07:59:16','',''),(226,'1','292',NULL,1,'Sale Id shift 35',1693398.00,0.00,0.00,0.00,0.00,'2022-11-30 07:59:16','',''),(227,'1','292','2',1,'Sale Id shift 36',0.00,0.00,0.00,3404.84,0.00,'2022-11-30 12:44:25','',''),(228,'1','292','2',1,'Sale Id shift 36',0.00,0.00,0.00,3175.04,0.00,'2022-11-30 12:44:25','',''),(229,'1','292','4',2,'Sale Id shift 36',0.00,0.00,0.00,685.00,0.00,'2022-11-30 12:44:25','',''),(230,'1','292',NULL,1,'Sale Id shift 36',1381774.80,0.00,0.00,0.00,0.00,'2022-11-30 12:44:25','',''),(231,'1','292',NULL,2,'Sale Id shift 36',568550.00,0.00,0.00,0.00,0.00,'2022-11-30 12:44:25','',''),(232,'1','292','2',1,'Sale Id shift 37',0.00,0.00,0.00,607.23,0.00,'2022-12-01 10:32:28','',''),(233,'1','292','2',1,'Sale Id shift 37',0.00,0.00,0.00,619.03,0.00,'2022-12-01 10:32:28','',''),(234,'1','292',NULL,1,'Sale Id shift 37',257514.60,0.00,0.00,0.00,0.00,'2022-12-01 10:32:28','',''),(235,'1','292','4',2,'Sale Id shift 38',0.00,0.00,0.00,218.00,0.00,'2022-12-03 14:33:19','',''),(236,'1','292',NULL,2,'Sale Id shift 38',183120.00,0.00,0.00,0.00,0.00,'2022-12-03 14:33:19','',''),(237,'1','292',NULL,1,'Distributed to DRIVER\'S SHORT for sales id:1',178500.00,0.00,0.00,850.00,0.00,'2022-12-09 19:00:42','',''),(238,'1','292',NULL,1,'Distributed to DRIVER\'S SHORT for sales id:2',168000.00,0.00,0.00,800.00,0.00,'2022-12-09 19:06:51','',''),(239,'1','292','4',2,'Sale Id shift 39',0.00,0.00,0.00,229.00,0.00,'2022-12-11 05:57:44','',''),(240,'1','292',NULL,2,'Sale Id shift 39',192360.00,0.00,0.00,0.00,0.00,'2022-12-11 05:57:44','',''),(241,'1','292','4',2,'Sale Id shift 40',0.00,0.00,0.00,91.00,0.00,'2022-12-20 10:11:17','',''),(242,'1','292',NULL,2,'Sale Id shift 40',74620.00,0.00,0.00,0.00,0.00,'2022-12-20 10:11:17','',''),(243,'1','292','4',2,'Sale Id shift 41',0.00,0.00,0.00,116.00,0.00,'2022-12-21 08:01:37','',''),(244,'1','292',NULL,2,'Sale Id shift 41',95120.00,0.00,0.00,0.00,0.00,'2022-12-21 08:01:37','',''),(245,'1','292','4',2,'Sale Id shift 42',0.00,0.00,0.00,149.00,0.00,'2022-12-22 20:48:58','',''),(246,'1','292',NULL,2,'Sale Id shift 42',122180.00,0.00,0.00,0.00,0.00,'2022-12-22 20:48:58','',''),(247,'1','292','4',2,'Sale Id shift 43',0.00,0.00,0.00,170.00,0.00,'2022-12-24 23:15:52','',''),(248,'1','292',NULL,2,'Sale Id shift 43',139400.00,0.00,0.00,0.00,0.00,'2022-12-24 23:15:52','',''),(249,'1','292','4',2,'Sale Id shift 44',0.00,0.00,0.00,831.00,0.00,'2022-12-26 05:58:22','',''),(250,'1','292',NULL,2,'Sale Id shift 44',681420.00,0.00,0.00,0.00,0.00,'2022-12-26 05:58:22','',''),(251,'1','292','4',2,'Sale Id shift 45',0.00,0.00,0.00,961.00,0.00,'2022-12-26 16:44:17','',''),(252,'1','292',NULL,2,'Sale Id shift 45',788020.00,0.00,0.00,0.00,0.00,'2022-12-26 16:44:17','',''),(253,'1','292','4',2,'Sale Id shift 46',0.00,0.00,0.00,170.00,0.00,'2023-01-05 20:57:58','',''),(254,'1','292',NULL,2,'Sale Id shift 46',139400.00,0.00,0.00,0.00,0.00,'2023-01-05 20:57:58','',''),(255,'1','292','4',2,'Sale Id shift 47',0.00,0.00,0.00,110.00,0.00,'2023-01-10 15:05:58','',''),(256,'1','292',NULL,2,'Sale Id shift 47',90200.00,0.00,0.00,0.00,0.00,'2023-01-10 15:05:58','',''),(257,'1','292','4',2,'Sale Id shift 48',0.00,0.00,0.00,106.00,0.00,'2023-01-14 09:50:44','',''),(258,'1','292',NULL,2,'Sale Id shift 48',86920.00,0.00,0.00,0.00,0.00,'2023-01-14 09:50:44','',''),(259,'1','292','4',2,'Sale Id shift 49',0.00,0.00,0.00,78.00,0.00,'2023-01-23 08:34:20','',''),(260,'1','292',NULL,2,'Sale Id shift 49',63960.00,0.00,0.00,0.00,0.00,'2023-01-23 08:34:20','',''),(261,'1','292','4',2,'Sale Id shift 50',0.00,0.00,0.00,288.00,0.00,'2023-01-23 17:00:01','',''),(262,'1','292',NULL,2,'Sale Id shift 50',239040.00,0.00,0.00,0.00,0.00,'2023-01-23 17:00:01','',''),(263,'1','292',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,4080000.00,17000.00,0.00,0.00,'2023-02-02 21:47:18','',''),(264,'1','292','1',1,'Sale Id shift 51',0.00,0.00,0.00,1322.58,0.00,'2023-02-03 21:37:27','',''),(265,'1','292','1',1,'Sale Id shift 51',0.00,0.00,0.00,2471.16,0.00,'2023-02-03 21:37:27','',''),(266,'1','292','1',1,'Sale Id shift 51',0.00,0.00,0.00,318.65,0.00,'2023-02-03 21:37:27','',''),(267,'1','292','4',2,'Sale Id shift 51',0.00,0.00,0.00,100.00,0.00,'2023-02-03 21:37:27','',''),(268,'1','292',NULL,1,'Sale Id shift 51',986973.60,0.00,0.00,0.00,0.00,'2023-02-03 21:37:27','',''),(269,'1','292',NULL,2,'Sale Id shift 51',79000.00,0.00,0.00,0.00,0.00,'2023-02-03 21:37:27','',''),(270,'1','292','1',1,'Sale Id shift 53',0.00,0.00,0.00,1918.58,0.00,'2023-02-05 18:18:15','',''),(271,'1','292','1',1,'Sale Id shift 53',0.00,0.00,0.00,2468.72,0.00,'2023-02-05 18:18:15','',''),(272,'1','292',NULL,1,'Sale Id shift 53',1052952.00,0.00,0.00,0.00,0.00,'2023-02-05 18:18:15','',''),(273,'1','292','1',1,'Sale Id shift 54',0.00,0.00,0.00,567.75,0.00,'2023-02-06 17:06:01','',''),(274,'1','292','1',1,'Sale Id shift 54',0.00,0.00,0.00,695.07,0.00,'2023-02-06 17:06:01','',''),(275,'1','292','1',1,'Sale Id shift 54',0.00,0.00,0.00,505.21,0.00,'2023-02-06 17:06:01','',''),(276,'1','292',NULL,1,'Sale Id shift 54',362446.15,0.00,0.00,0.00,0.00,'2023-02-06 17:06:01','',''),(277,'1','292','1',1,'Sale Id shift 55',0.00,0.00,0.00,815.45,0.00,'2023-02-06 19:46:11','',''),(278,'1','292','1',1,'Sale Id shift 55',0.00,0.00,0.00,443.41,0.00,'2023-02-06 19:46:11','',''),(279,'1','292','1',1,'Sale Id shift 55',0.00,0.00,0.00,924.24,0.00,'2023-02-06 19:46:11','',''),(280,'1','292',NULL,1,'Sale Id shift 55',447535.50,0.00,0.00,0.00,0.00,'2023-02-06 19:46:11','',''),(281,'1','292','1',1,'Sale Id shift 56',0.00,0.00,0.00,1722.94,0.00,'2023-02-06 23:24:09','',''),(282,'1','292','1',1,'Sale Id shift 56',0.00,0.00,0.00,2611.74,0.00,'2023-02-06 23:24:09','',''),(283,'1','292',NULL,1,'Sale Id shift 56',888609.40,0.00,0.00,0.00,0.00,'2023-02-06 23:24:09','',''),(284,'1','292',NULL,1,'Reception corrector for bridging 5',0.00,0.00,0.00,15500.00,0.00,'2023-02-11 07:53:25','',''),(285,'1','292','3',1,'Received from bridging 5',0.00,0.00,15500.00,0.00,0.00,'2023-02-11 07:53:25','',''),(286,'1','292',NULL,1,'Reception corrector for bridging 4',0.00,0.00,0.00,16500.00,0.00,'2023-02-11 07:53:25','',''),(287,'1','292','2',1,'Received from bridging 4',0.00,0.00,16500.00,0.00,0.00,'2023-02-11 07:53:25','',''),(288,'1','292',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,16550.00,0.00,'2023-02-11 07:53:25','',''),(289,'1','292','1',1,'Received from bridging 3',0.00,0.00,16550.00,0.00,0.00,'2023-02-11 07:53:25','',''),(290,'1','292',NULL,1,'Reception corrector for bridging 8',0.00,0.00,0.00,14850.00,0.00,'2023-02-11 07:53:52','',''),(291,'1','292','3',1,'Received from bridging 8',0.00,0.00,14850.00,0.00,0.00,'2023-02-11 07:53:52','',''),(292,'1','292',NULL,1,'Reception corrector for bridging 7',0.00,0.00,0.00,15000.00,0.00,'2023-02-11 07:53:53','',''),(293,'1','292','2',1,'Received from bridging 7',0.00,0.00,15000.00,0.00,0.00,'2023-02-11 07:53:53','',''),(294,'1','292',NULL,1,'Reception corrector for bridging 6',0.00,0.00,0.00,15000.00,0.00,'2023-02-11 07:53:53','',''),(295,'1','292','1',1,'Received from bridging 6',0.00,0.00,15000.00,0.00,0.00,'2023-02-11 07:53:53','',''),(296,'1','292',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,16500.00,0.00,'2023-02-11 07:54:47','',''),(297,'1','292','3',1,'Received from bridging 10',0.00,0.00,16500.00,0.00,0.00,'2023-02-11 07:54:47','',''),(298,'1','292',NULL,1,'Reception corrector for bridging 9',0.00,0.00,0.00,32700.00,0.00,'2023-02-11 07:54:47','',''),(299,'1','292','1',1,'Received from bridging 9',0.00,0.00,32700.00,0.00,0.00,'2023-02-11 07:54:47','',''),(300,'1','292',NULL,2,'Reception corrector for bridging 11',0.00,0.00,0.00,30000.00,0.00,'2023-02-11 07:58:35','',''),(301,'1','292','4',2,'Received from bridging 11',0.00,0.00,30000.00,0.00,0.00,'2023-02-11 07:58:35','',''),(302,'1','292',NULL,1,'Reception corrector for bridging 12',0.00,0.00,0.00,17000.00,0.00,'2023-02-11 08:01:43','',''),(303,'1','292','1',1,'Received from bridging 12',0.00,0.00,17000.00,0.00,0.00,'2023-02-11 08:01:43','',''),(304,'1','292',NULL,1,'Reception corrector for bridging 13',0.00,0.00,0.00,21650.00,0.00,'2023-02-11 08:06:08','',''),(305,'1','292','2',1,'Received from bridging 13',0.00,0.00,21650.00,0.00,0.00,'2023-02-11 08:06:08','',''),(306,'1','292',NULL,1,'Reception corrector for bridging 15',0.00,0.00,0.00,17000.00,0.00,'2023-02-11 08:13:00','',''),(307,'1','292','3',1,'Received from bridging 15',0.00,0.00,17000.00,0.00,0.00,'2023-02-11 08:13:00','',''),(308,'1','292',NULL,1,'Reception corrector for bridging 14',0.00,0.00,0.00,32200.00,0.00,'2023-02-11 08:13:00','',''),(309,'1','292','1',1,'Received from bridging 14',0.00,0.00,32200.00,0.00,0.00,'2023-02-11 08:13:00','',''),(310,'1','292','3',1,'Returned bridging 8',0.00,0.00,0.00,14850.00,0.00,'2023-02-13 06:31:09','',''),(311,'1','292',NULL,1,'Reception Return corrector for bridging 8',0.00,0.00,14850.00,0.00,0.00,'2023-02-13 06:31:09','',''),(312,'1','292',NULL,1,'Reception corrector for bridging 16',0.00,0.00,0.00,14850.00,0.00,'2023-02-13 06:38:40','',''),(313,'1','292','2',1,'Received from bridging 16',0.00,0.00,14850.00,0.00,0.00,'2023-02-13 06:38:40','',''),(314,'1','292',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,6150000.00,30000.00,0.00,0.00,'2023-02-16 17:58:28','',''),(315,'1','292',NULL,1,'Reception corrector for bridging 17',0.00,0.00,0.00,29750.00,0.00,'2023-02-16 18:16:15','',''),(316,'1','292','3',1,'Received from bridging 17',0.00,0.00,29750.00,0.00,0.00,'2023-02-16 18:16:15','',''),(317,'1','292','3',1,'Sale Id shift 57',0.00,0.00,0.00,2231.57,0.00,'2023-02-16 18:32:43','',''),(318,'1','292','3',1,'Sale Id shift 57',0.00,0.00,0.00,2406.32,0.00,'2023-02-16 18:32:43','',''),(319,'1','292',NULL,1,'Sale Id shift 57',950767.45,0.00,0.00,0.00,0.00,'2023-02-16 18:32:43','',''),(320,'1','292','3',1,'Sale Id shift 58',0.00,0.00,0.00,2165.74,0.00,'2023-02-17 17:53:58','',''),(321,'1','292','3',1,'Sale Id shift 58',0.00,0.00,0.00,2900.11,0.00,'2023-02-17 17:53:58','',''),(322,'1','292','4',2,'Sale Id shift 58',0.00,0.00,0.00,100.00,0.00,'2023-02-17 17:53:58','',''),(323,'1','292',NULL,1,'Sale Id shift 58',1038499.25,0.00,0.00,0.00,0.00,'2023-02-17 17:53:58','',''),(324,'1','292',NULL,2,'Sale Id shift 58',81000.00,0.00,0.00,0.00,0.00,'2023-02-17 17:53:58','',''),(325,'1','292','3',1,'Sale Id shift 59',0.00,0.00,0.00,2451.15,0.00,'2023-02-19 13:13:24','',''),(326,'1','292','3',1,'Sale Id shift 59',0.00,0.00,0.00,2913.26,0.00,'2023-02-19 13:13:24','',''),(327,'1','292',NULL,1,'Sale Id shift 59',1099704.05,0.00,0.00,0.00,0.00,'2023-02-19 13:13:24','',''),(328,'1','292','3',1,'Distributed to DRIVER\'S SHORT for sales id:3',51250.00,0.00,0.00,250.00,0.00,'2023-02-19 16:02:53','',''),(329,'1','292','3',1,'Sale Id shift 60',0.00,0.00,0.00,2005.26,0.00,'2023-02-19 22:53:14','',''),(330,'1','292','3',1,'Sale Id shift 60',0.00,0.00,0.00,2338.27,0.00,'2023-02-19 22:53:14','',''),(331,'1','292',NULL,1,'Sale Id shift 60',890423.65,0.00,0.00,0.00,0.00,'2023-02-19 22:53:14','',''),(332,'1','292','3',1,'Sale Id shift 61',0.00,0.00,0.00,2157.85,0.00,'2023-02-20 22:49:43','',''),(333,'1','292','3',1,'Sale Id shift 61',0.00,0.00,0.00,3057.70,0.00,'2023-02-20 22:49:43','',''),(334,'1','292',NULL,1,'Sale Id shift 61',1069187.75,0.00,0.00,0.00,0.00,'2023-02-20 22:49:43','',''),(335,'1','292','3',1,'Sale Id shift 62',0.00,0.00,0.00,2316.61,0.00,'2023-02-22 09:29:11','',''),(336,'1','292','3',1,'Sale Id shift 62',0.00,0.00,0.00,3106.53,0.00,'2023-02-22 09:29:11','',''),(337,'1','292',NULL,1,'Sale Id shift 62',1111743.70,0.00,0.00,0.00,0.00,'2023-02-22 09:29:11','',''),(338,'1','292',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3877500.00,16500.00,0.00,0.00,'2023-03-03 15:03:04','',''),(339,'1','292',NULL,1,'Reception corrector for bridging 18',0.00,0.00,0.00,16500.00,0.00,'2023-03-03 17:17:19','',''),(340,'1','292','3',1,'Received from bridging 18',0.00,0.00,16500.00,0.00,0.00,'2023-03-03 17:17:19','',''),(341,'1','292','3',1,'Sale Id shift 63',0.00,0.00,0.00,848.66,0.00,'2023-03-04 06:42:24','',''),(342,'1','292','3',1,'Sale Id shift 63',0.00,0.00,0.00,1301.15,0.00,'2023-03-04 06:42:24','',''),(343,'1','292','4',2,'Sale Id shift 63',0.00,0.00,0.00,100.00,0.00,'2023-03-04 06:42:24','',''),(344,'1','292',NULL,1,'Sale Id shift 63',505205.35,0.00,0.00,0.00,0.00,'2023-03-04 06:42:24','',''),(345,'1','292',NULL,2,'Sale Id shift 63',81000.00,0.00,0.00,0.00,0.00,'2023-03-04 06:42:24','',''),(346,'1','292','3',1,'Sale Id shift 64',0.00,0.00,0.00,3090.46,0.00,'2023-03-05 07:58:57','',''),(347,'1','292','3',1,'Sale Id shift 64',0.00,0.00,0.00,3311.56,0.00,'2023-03-05 07:58:57','',''),(348,'1','292',NULL,1,'Sale Id shift 64',1504474.70,0.00,0.00,0.00,0.00,'2023-03-05 07:58:57','',''),(349,'1','292',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,10575000.00,45000.00,0.00,0.00,'2023-03-06 23:11:59','',''),(350,'1','292',NULL,1,'Reception corrector for bridging 20',0.00,0.00,0.00,29750.00,0.00,'2023-03-08 23:24:14','',''),(351,'1','292','2',1,'Received from bridging 20',0.00,0.00,29750.00,0.00,0.00,'2023-03-08 23:24:14','',''),(352,'1','292',NULL,1,'Reception corrector for bridging 19',0.00,0.00,0.00,14800.00,0.00,'2023-03-08 23:24:14','',''),(353,'1','292','1',1,'Received from bridging 19',0.00,0.00,14800.00,0.00,0.00,'2023-03-08 23:24:14','',''),(354,'1','292','1',1,'Sale Id shift 65',0.00,0.00,0.00,1688.08,0.00,'2023-03-09 10:06:01','',''),(355,'1','292','1',1,'Sale Id shift 65',0.00,0.00,0.00,1202.17,0.00,'2023-03-09 10:06:01','',''),(356,'1','292','1',1,'Sale Id shift 65',0.00,0.00,0.00,1753.07,0.00,'2023-03-09 10:06:01','',''),(357,'1','292','1',1,'Sale Id shift 65',0.00,0.00,0.00,1382.00,0.00,'2023-03-09 10:06:01','',''),(358,'1','292','2',1,'Sale Id shift 65',0.00,0.00,0.00,3370.64,0.00,'2023-03-09 10:06:01','',''),(359,'1','292','2',1,'Sale Id shift 65',0.00,0.00,0.00,1846.47,0.00,'2023-03-09 10:06:01','',''),(360,'1','292',NULL,1,'Sale Id shift 65',2641971.05,0.00,0.00,0.00,0.00,'2023-03-09 10:06:01','',''),(361,'1','292','1',1,'Sale Id shift 67',0.00,0.00,0.00,922.31,0.00,'2023-03-09 12:22:16','',''),(362,'1','292','1',1,'Sale Id shift 67',0.00,0.00,0.00,1228.63,0.00,'2023-03-09 12:22:16','',''),(363,'1','292','1',1,'Sale Id shift 67',0.00,0.00,0.00,1425.48,0.00,'2023-03-09 12:22:16','',''),(364,'1','292','1',1,'Sale Id shift 67',0.00,0.00,0.00,1023.77,0.00,'2023-03-09 12:22:16','',''),(365,'1','292','2',1,'Sale Id shift 67',0.00,0.00,0.00,3107.16,0.00,'2023-03-09 12:22:16','',''),(366,'1','292','2',1,'Sale Id shift 67',0.00,0.00,0.00,1792.49,0.00,'2023-03-09 12:22:16','',''),(367,'1','292',NULL,1,'Sale Id shift 67',2232462.40,0.00,0.00,0.00,0.00,'2023-03-09 12:22:16','',''),(368,'1','292','1',1,'Sale Id shift 68',0.00,0.00,0.00,2563.95,0.00,'2023-03-09 12:36:47','',''),(369,'1','292','1',1,'Sale Id shift 68',0.00,0.00,0.00,985.27,0.00,'2023-03-09 12:36:47','',''),(370,'1','292','1',1,'Sale Id shift 68',0.00,0.00,0.00,572.69,0.00,'2023-03-09 12:36:47','',''),(371,'1','292','2',1,'Sale Id shift 68',0.00,0.00,0.00,5255.89,0.00,'2023-03-09 12:36:47','',''),(372,'1','292','2',1,'Sale Id shift 68',0.00,0.00,0.00,5230.08,0.00,'2023-03-09 12:36:47','',''),(373,'1','292','4',2,'Sale Id shift 68',0.00,0.00,0.00,100.00,0.00,'2023-03-09 12:36:47','',''),(374,'1','292',NULL,1,'Sale Id shift 68',3432851.80,0.00,0.00,0.00,0.00,'2023-03-09 12:36:47','',''),(375,'1','292',NULL,2,'Sale Id shift 68',81000.00,0.00,0.00,0.00,0.00,'2023-03-09 12:36:47','',''),(376,'1','292','2',1,'Sale Id shift 69',0.00,0.00,0.00,2760.61,0.00,'2023-03-09 12:44:57','',''),(377,'1','292','2',1,'Sale Id shift 69',0.00,0.00,0.00,1652.04,0.00,'2023-03-09 12:44:57','',''),(378,'1','292','3',1,'Sale Id shift 69',0.00,0.00,0.00,225.00,0.00,'2023-03-09 12:44:57','',''),(379,'1','292',NULL,1,'Sale Id shift 69',1089847.75,0.00,0.00,0.00,0.00,'2023-03-09 12:44:57','',''),(380,'1','292',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,14100000.00,60000.00,0.00,0.00,'2023-03-09 13:49:56','',''),(381,'1','292',NULL,1,'Reception corrector for bridging 24',0.00,0.00,0.00,34750.00,0.00,'2023-03-09 16:44:46','',''),(382,'1','292','3',1,'Received from bridging 24',0.00,0.00,34750.00,0.00,0.00,'2023-03-09 16:44:46','',''),(383,'1','292',NULL,1,'Reception corrector for bridging 23',0.00,0.00,0.00,3500.00,0.00,'2023-03-09 16:44:46','',''),(384,'1','292','2',1,'Received from bridging 23',0.00,0.00,3500.00,0.00,0.00,'2023-03-09 16:44:46','',''),(385,'1','292',NULL,1,'Reception corrector for bridging 22',0.00,0.00,0.00,28100.00,0.00,'2023-03-09 16:44:46','',''),(386,'1','292','1',1,'Received from bridging 22',0.00,0.00,28100.00,0.00,0.00,'2023-03-09 16:44:46','',''),(387,'1','292','2',1,'Sale Id shift 70',0.00,0.00,0.00,2158.87,0.00,'2023-03-10 09:32:54','',''),(388,'1','292','2',1,'Sale Id shift 70',0.00,0.00,0.00,2591.26,0.00,'2023-03-10 09:32:54','',''),(389,'1','292',NULL,1,'Sale Id shift 70',1116280.55,0.00,0.00,0.00,0.00,'2023-03-10 09:32:54','',''),(390,'1','292','1',1,'Sale Id shift 71',0.00,0.00,0.00,1253.86,0.00,'2023-03-10 13:20:09','',''),(391,'1','292','1',1,'Sale Id shift 71',0.00,0.00,0.00,1168.91,0.00,'2023-03-10 13:20:09','',''),(392,'1','292','1',1,'Sale Id shift 71',0.00,0.00,0.00,509.06,0.00,'2023-03-10 13:20:09','',''),(393,'1','292','1',1,'Sale Id shift 71',0.00,0.00,0.00,1975.57,0.00,'2023-03-10 13:20:09','',''),(394,'1','292','3',1,'Sale Id shift 71',0.00,0.00,0.00,1891.14,0.00,'2023-03-10 13:20:09','',''),(395,'1','292','3',1,'Sale Id shift 71',0.00,0.00,0.00,2161.77,0.00,'2023-03-10 13:20:09','',''),(396,'1','292',NULL,1,'Sale Id shift 71',2105672.85,0.00,0.00,0.00,0.00,'2023-03-10 13:20:09','',''),(397,'1','292','1',1,'Sale Id shift 72',0.00,0.00,0.00,1372.36,0.00,'2023-03-10 15:45:48','',''),(398,'1','292','1',1,'Sale Id shift 72',0.00,0.00,0.00,1400.46,0.00,'2023-03-10 15:45:48','',''),(399,'1','292','1',1,'Sale Id shift 72',0.00,0.00,0.00,1042.25,0.00,'2023-03-10 15:45:48','',''),(400,'1','292','1',1,'Sale Id shift 72',0.00,0.00,0.00,1069.35,0.00,'2023-03-10 15:45:48','',''),(401,'1','292','3',1,'Sale Id shift 72',0.00,0.00,0.00,1723.23,0.00,'2023-03-10 15:45:48','',''),(402,'1','292','3',1,'Sale Id shift 72',0.00,0.00,0.00,1767.70,0.00,'2023-03-10 15:45:48','',''),(403,'1','292',NULL,1,'Sale Id shift 72',1968207.25,0.00,0.00,0.00,0.00,'2023-03-10 15:45:48','',''),(404,'1','292','1',1,'Returned bridging 19',0.00,0.00,0.00,14800.00,0.00,'2023-03-10 20:38:35','',''),(405,'1','292',NULL,1,'Reception Return corrector for bridging 19',0.00,0.00,14800.00,0.00,0.00,'2023-03-10 20:38:35','',''),(406,'1','292',NULL,1,'Reception corrector for bridging 25',0.00,0.00,0.00,14520.00,0.00,'2023-03-10 20:43:50','',''),(407,'1','292','1',1,'Received from bridging 25',0.00,0.00,14520.00,0.00,0.00,'2023-03-10 20:43:50','',''),(408,'1','292','1',1,'Returned bridging 25',0.00,0.00,0.00,14520.00,0.00,'2023-03-10 20:47:00','',''),(409,'1','292',NULL,1,'Reception Return corrector for bridging 25',0.00,0.00,14520.00,0.00,0.00,'2023-03-10 20:47:00','',''),(410,'1','292',NULL,1,'Reception corrector for bridging 26',0.00,0.00,0.00,14520.00,0.00,'2023-03-10 20:51:57','',''),(411,'1','292','1',1,'Received from bridging 26',0.00,0.00,14520.00,0.00,0.00,'2023-03-10 20:51:57','',''),(412,'1','292','1',1,'Sale Id shift 73',0.00,0.00,0.00,507.84,0.00,'2023-03-11 08:19:11','',''),(413,'1','292','1',1,'Sale Id shift 73',0.00,0.00,0.00,345.01,0.00,'2023-03-11 08:19:11','',''),(414,'1','292','1',1,'Sale Id shift 73',0.00,0.00,0.00,343.69,0.00,'2023-03-11 08:19:11','',''),(415,'1','292','1',1,'Sale Id shift 73',0.00,0.00,0.00,561.12,0.00,'2023-03-11 08:19:11','',''),(416,'1','292','3',1,'Sale Id shift 73',0.00,0.00,0.00,855.10,0.00,'2023-03-11 08:19:11','',''),(417,'1','292','3',1,'Sale Id shift 73',0.00,0.00,0.00,912.87,0.00,'2023-03-11 08:19:11','',''),(418,'1','292',NULL,1,'Sale Id shift 73',828523.05,0.00,0.00,0.00,0.00,'2023-03-11 08:19:11','',''),(419,'1','292','1',1,'Sale Id shift 74',0.00,0.00,0.00,2217.98,0.00,'2023-03-12 06:48:40','',''),(420,'1','292','1',1,'Sale Id shift 74',0.00,0.00,0.00,2056.24,0.00,'2023-03-12 06:48:40','',''),(421,'1','292','1',1,'Sale Id shift 74',0.00,0.00,0.00,1829.41,0.00,'2023-03-12 06:48:40','',''),(422,'1','292','1',1,'Sale Id shift 74',0.00,0.00,0.00,2576.97,0.00,'2023-03-12 06:48:40','',''),(423,'1','292','3',1,'Sale Id shift 74',0.00,0.00,0.00,1797.29,0.00,'2023-03-12 06:48:40','',''),(424,'1','292','3',1,'Sale Id shift 74',0.00,0.00,0.00,3122.41,0.00,'2023-03-12 06:48:40','',''),(425,'1','292',NULL,1,'Sale Id shift 74',3196070.50,0.00,0.00,0.00,0.00,'2023-03-12 06:48:40','',''),(426,'1','292',NULL,1,'Reception corrector for bridging 27',0.00,0.00,0.00,480.00,0.00,'2023-03-12 13:49:26','',''),(427,'1','292','1',1,'Received from bridging 27',0.00,0.00,480.00,0.00,0.00,'2023-03-12 13:49:26','',''),(428,'1','292','1',1,'Sale Id shift 75',0.00,0.00,0.00,1144.88,0.00,'2023-03-12 22:06:57','',''),(429,'1','292','1',1,'Sale Id shift 75',0.00,0.00,0.00,1427.74,0.00,'2023-03-12 22:06:57','',''),(430,'1','292','1',1,'Sale Id shift 75',0.00,0.00,0.00,2783.30,0.00,'2023-03-12 22:06:57','',''),(431,'1','292','1',1,'Sale Id shift 75',0.00,0.00,0.00,1772.62,0.00,'2023-03-12 22:06:57','',''),(432,'1','292',NULL,1,'Sale Id shift 75',1675206.90,0.00,0.00,0.00,0.00,'2023-03-12 22:06:57','',''),(433,'1','292','1',1,'Sale Id shift 76',0.00,0.00,0.00,1064.70,0.00,'2023-03-13 18:01:50','',''),(434,'1','292','1',1,'Sale Id shift 76',0.00,0.00,0.00,883.09,0.00,'2023-03-13 18:01:50','',''),(435,'1','292','1',1,'Sale Id shift 76',0.00,0.00,0.00,1607.13,0.00,'2023-03-13 18:01:50','',''),(436,'1','292','1',1,'Sale Id shift 76',0.00,0.00,0.00,958.50,0.00,'2023-03-13 18:01:50','',''),(437,'1','292','3',1,'Sale Id shift 76',0.00,0.00,0.00,367.50,0.00,'2023-03-13 18:01:50','',''),(438,'1','292','4',2,'Sale Id shift 76',0.00,0.00,0.00,150.00,0.00,'2023-03-13 18:01:50','',''),(439,'1','292',NULL,1,'Sale Id shift 76',1147016.20,0.00,0.00,0.00,0.00,'2023-03-13 18:01:50','',''),(440,'1','292',NULL,2,'Sale Id shift 76',121500.00,0.00,0.00,0.00,0.00,'2023-03-13 18:01:50','',''),(441,'1','292',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,14100000.00,60000.00,0.00,0.00,'2023-03-13 19:54:31','',''),(442,'1','292',NULL,1,'Reception corrector for bridging 29',0.00,0.00,0.00,30000.00,0.00,'2023-03-13 20:56:43','',''),(443,'1','292','2',1,'Received from bridging 29',0.00,0.00,30000.00,0.00,0.00,'2023-03-13 20:56:43','',''),(444,'1','292',NULL,1,'Reception corrector for bridging 28',0.00,0.00,0.00,30000.00,0.00,'2023-03-13 20:56:43','',''),(445,'1','292','1',1,'Received from bridging 28',0.00,0.00,30000.00,0.00,0.00,'2023-03-13 20:56:43','',''),(446,'1','292','1',1,'Sale Id shift 77',0.00,0.00,0.00,1044.90,0.00,'2023-03-14 08:31:39','',''),(447,'1','292','1',1,'Sale Id shift 77',0.00,0.00,0.00,1147.68,0.00,'2023-03-14 08:31:39','',''),(448,'1','292','2',1,'Sale Id shift 77',0.00,0.00,0.00,879.59,0.00,'2023-03-14 08:31:39','',''),(449,'1','292','2',1,'Sale Id shift 77',0.00,0.00,0.00,251.80,0.00,'2023-03-14 08:31:39','',''),(450,'1','292','3',1,'Sale Id shift 77',0.00,0.00,0.00,1042.16,0.00,'2023-03-14 08:31:39','',''),(451,'1','292','3',1,'Sale Id shift 77',0.00,0.00,0.00,2147.63,0.00,'2023-03-14 08:31:39','',''),(452,'1','292',NULL,1,'Sale Id shift 77',1530733.60,0.00,0.00,0.00,0.00,'2023-03-14 08:31:39','',''),(453,'1','292','1',1,'Sale Id shift 78',0.00,0.00,0.00,748.27,0.00,'2023-03-14 09:40:20','',''),(454,'1','292','1',1,'Sale Id shift 78',0.00,0.00,0.00,1469.82,0.00,'2023-03-14 09:40:20','',''),(455,'1','292','1',1,'Sale Id shift 78',0.00,0.00,0.00,1086.58,0.00,'2023-03-14 09:40:20','',''),(456,'1','292','2',1,'Sale Id shift 78',0.00,0.00,0.00,532.08,0.00,'2023-03-14 09:40:20','',''),(457,'1','292','2',1,'Sale Id shift 78',0.00,0.00,0.00,888.09,0.00,'2023-03-14 09:40:20','',''),(458,'1','292','3',1,'Sale Id shift 78',0.00,0.00,0.00,1011.07,0.00,'2023-03-14 09:40:20','',''),(459,'1','292','3',1,'Sale Id shift 78',0.00,0.00,0.00,1713.88,0.00,'2023-03-14 09:40:20','',''),(460,'1','292',NULL,1,'Sale Id shift 78',1750700.65,0.00,0.00,0.00,0.00,'2023-03-14 09:40:20','',''),(461,'1','292','1',1,'Sale Id shift 79',0.00,0.00,0.00,164.28,0.00,'2023-03-14 18:40:19','',''),(462,'1','292','1',1,'Sale Id shift 79',0.00,0.00,0.00,743.49,0.00,'2023-03-14 18:40:19','',''),(463,'1','292','1',1,'Sale Id shift 79',0.00,0.00,0.00,629.95,0.00,'2023-03-14 18:40:19','',''),(464,'1','292','1',1,'Sale Id shift 79',0.00,0.00,0.00,342.34,0.00,'2023-03-14 18:40:19','',''),(465,'1','292','2',1,'Sale Id shift 79',0.00,0.00,0.00,174.61,0.00,'2023-03-14 18:40:19','',''),(466,'1','292','3',1,'Sale Id shift 79',0.00,0.00,0.00,1115.20,0.00,'2023-03-14 18:40:19','',''),(467,'1','292',NULL,1,'Sale Id shift 79',744919.45,0.00,0.00,0.00,0.00,'2023-03-14 18:40:19','',''),(468,'1','292','1',1,'Sale Id shift 80',0.00,0.00,0.00,131.51,0.00,'2023-03-15 06:58:00','',''),(469,'1','292','1',1,'Sale Id shift 80',0.00,0.00,0.00,799.37,0.00,'2023-03-15 06:58:00','',''),(470,'1','292','1',1,'Sale Id shift 80',0.00,0.00,0.00,1115.56,0.00,'2023-03-15 06:58:00','',''),(471,'1','292','1',1,'Sale Id shift 80',0.00,0.00,0.00,1722.37,0.00,'2023-03-15 06:58:00','',''),(472,'1','292','2',1,'Sale Id shift 80',0.00,0.00,0.00,1083.62,0.00,'2023-03-15 06:58:00','',''),(473,'1','292','2',1,'Sale Id shift 80',0.00,0.00,0.00,376.32,0.00,'2023-03-15 06:58:00','',''),(474,'1','292','3',1,'Sale Id shift 80',0.00,0.00,0.00,1411.44,0.00,'2023-03-15 06:58:00','',''),(475,'1','292','3',1,'Sale Id shift 80',0.00,0.00,0.00,1937.88,0.00,'2023-03-15 06:58:00','',''),(476,'1','292',NULL,1,'Sale Id shift 80',2015846.45,0.00,0.00,0.00,0.00,'2023-03-15 06:58:00','',''),(477,'1','292','1',1,'Sale Id shift 81',0.00,0.00,0.00,2110.25,0.00,'2023-03-15 18:12:51','',''),(478,'1','292','1',1,'Sale Id shift 81',0.00,0.00,0.00,2751.70,0.00,'2023-03-15 18:12:51','',''),(479,'1','292','2',1,'Sale Id shift 81',0.00,0.00,0.00,646.58,0.00,'2023-03-15 18:12:51','',''),(480,'1','292','2',1,'Sale Id shift 81',0.00,0.00,0.00,27.18,0.00,'2023-03-15 18:12:51','',''),(481,'1','292','3',1,'Sale Id shift 81',0.00,0.00,0.00,2319.21,0.00,'2023-03-15 18:12:51','',''),(482,'1','292',NULL,1,'Sale Id shift 81',1845906.20,0.00,0.00,0.00,0.00,'2023-03-15 18:12:51','',''),(483,'1','292','1',1,'Sale Id shift 82',0.00,0.00,0.00,1425.91,0.00,'2023-03-16 09:09:55','',''),(484,'1','292','1',1,'Sale Id shift 82',0.00,0.00,0.00,1232.35,0.00,'2023-03-16 09:09:55','',''),(485,'1','292','2',1,'Sale Id shift 82',0.00,0.00,0.00,854.89,0.00,'2023-03-16 09:09:55','',''),(486,'1','292','3',1,'Sale Id shift 82',0.00,0.00,0.00,111.66,0.00,'2023-03-16 09:09:55','',''),(487,'1','292',NULL,1,'Sale Id shift 82',851830.35,0.00,0.00,0.00,0.00,'2023-03-16 09:09:55','',''),(488,'1','292','1',1,'Sale Id shift 83',0.00,0.00,0.00,1018.90,0.00,'2023-03-17 07:46:14','',''),(489,'1','292','1',1,'Sale Id shift 83',0.00,0.00,0.00,1353.91,0.00,'2023-03-17 07:46:14','',''),(490,'1','292','1',1,'Sale Id shift 83',0.00,0.00,0.00,909.10,0.00,'2023-03-17 07:46:14','',''),(491,'1','292','1',1,'Sale Id shift 83',0.00,0.00,0.00,1314.30,0.00,'2023-03-17 07:46:14','',''),(492,'1','292','2',1,'Sale Id shift 83',0.00,0.00,0.00,1094.65,0.00,'2023-03-17 07:46:14','',''),(493,'1','292','2',1,'Sale Id shift 83',0.00,0.00,0.00,0.10,0.00,'2023-03-17 07:46:14','',''),(494,'1','292','3',1,'Sale Id shift 83',0.00,0.00,0.00,1501.39,0.00,'2023-03-17 07:46:14','',''),(495,'1','292',NULL,1,'Sale Id shift 83',1690202.25,0.00,0.00,0.00,0.00,'2023-03-17 07:46:14','',''),(496,'1','292','1',1,'Sale Id shift 84',0.00,0.00,0.00,2179.17,0.00,'2023-03-17 21:40:29','',''),(497,'1','292','1',1,'Sale Id shift 84',0.00,0.00,0.00,1230.31,0.00,'2023-03-17 21:40:29','',''),(498,'1','292','1',1,'Sale Id shift 84',0.00,0.00,0.00,2010.81,0.00,'2023-03-17 21:40:29','',''),(499,'1','292','2',1,'Sale Id shift 84',0.00,0.00,0.00,500.19,0.00,'2023-03-17 21:40:29','',''),(500,'1','292','2',1,'Sale Id shift 84',0.00,0.00,0.00,250.23,0.00,'2023-03-17 21:40:29','',''),(501,'1','292','3',1,'Sale Id shift 84',0.00,0.00,0.00,366.94,0.00,'2023-03-17 21:40:29','',''),(502,'1','292','3',1,'Sale Id shift 84',0.00,0.00,0.00,3276.59,0.00,'2023-03-17 21:40:29','',''),(503,'1','292',NULL,1,'Sale Id shift 84',2306346.40,0.00,0.00,0.00,0.00,'2023-03-17 21:40:29','',''),(504,'1','292','2',1,'Sale Id shift 85',0.00,0.00,0.00,1615.23,0.00,'2023-03-18 07:19:14','',''),(505,'1','292','2',1,'Sale Id shift 85',0.00,0.00,0.00,952.77,0.00,'2023-03-18 07:19:14','',''),(506,'1','292','3',1,'Sale Id shift 85',0.00,0.00,0.00,1809.48,0.00,'2023-03-18 07:19:14','',''),(507,'1','292','3',1,'Sale Id shift 85',0.00,0.00,0.00,1.23,0.00,'2023-03-18 07:19:14','',''),(508,'1','292',NULL,1,'Sale Id shift 85',1028996.85,0.00,0.00,0.00,0.00,'2023-03-18 07:19:14','',''),(509,'1','292','2',1,'Sale Id shift 86',0.00,0.00,0.00,3598.29,0.00,'2023-03-19 15:31:34','',''),(510,'1','292','2',1,'Sale Id shift 86',0.00,0.00,0.00,4367.44,0.00,'2023-03-19 15:31:34','',''),(511,'1','292','3',1,'Sale Id shift 86',0.00,0.00,0.00,378.02,0.00,'2023-03-19 15:31:34','',''),(512,'1','292','3',1,'Sale Id shift 86',0.00,0.00,0.00,308.53,0.00,'2023-03-19 15:31:34','',''),(513,'1','292',NULL,1,'Sale Id shift 86',2033285.80,0.00,0.00,0.00,0.00,'2023-03-19 15:31:34','',''),(514,'1','292','2',1,'Sale Id shift 87',0.00,0.00,0.00,3000.30,0.00,'2023-03-20 08:07:05','',''),(515,'1','292','2',1,'Sale Id shift 87',0.00,0.00,0.00,2673.10,0.00,'2023-03-20 08:07:05','',''),(516,'1','292',NULL,1,'Sale Id shift 87',1333249.00,0.00,0.00,0.00,0.00,'2023-03-20 08:07:05','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'1','292',3,0.00,'2023-03-20 13:24:16'),(2,'1','292',2,25129.00,'2023-03-20 13:24:16'),(3,'1','292',1,13482.52,'2023-03-20 13:24:16');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=96 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1,'1','292',1,'Sale Id shift 1',0.00,483584.40,180.00,483584.40,0.00,'2022-11-06 14:22:42'),(2,'1','292',1,'Sale Id shift 2',0.00,866050.20,180.00,866050.20,0.00,'2022-11-06 20:52:04'),(3,'1','292',1,'Sale Id shift 3',0.00,978663.60,180.00,978663.60,0.00,'2022-11-06 21:15:24'),(4,'1','292',1,'Sale Id shift 4',0.00,916713.00,180.00,916713.00,0.00,'2022-11-07 08:26:57'),(5,'1','292',1,'Sale Id shift 5',0.00,849182.40,180.00,849182.40,0.00,'2022-11-08 04:18:27'),(6,'1','292',1,'Sale Id shift 6',0.00,1086078.60,180.00,1086078.60,0.00,'2022-11-08 16:47:36'),(7,'1','292',1,'Sale Id shift 7',0.00,863481.60,180.00,863481.60,0.00,'2022-11-08 23:16:44'),(8,'1','292',1,'Sale Id shift 8',0.00,1120401.00,180.00,1120401.00,0.00,'2022-11-09 19:27:19'),(9,'1','292',1,'Sale Id shift 9',0.00,495586.80,180.00,495586.80,0.00,'2022-11-10 13:00:19'),(10,'1','292',1,'Sale Id shift 10',0.00,440816.40,180.00,440816.40,0.00,'2022-11-10 15:21:46'),(11,'1','292',1,'Sale Id shift 11',0.00,1174570.20,180.00,1174570.20,0.00,'2022-11-10 16:30:32'),(12,'1','292',1,'Sale Id shift 12',0.00,1116001.80,180.00,1116001.80,0.00,'2022-11-10 17:39:17'),(13,'1','292',1,'Sale Id shift 13',0.00,1161327.60,180.00,1161327.60,0.00,'2022-11-11 10:38:26'),(14,'1','292',1,'Sale Id shift 14',0.00,1050879.60,180.00,1050879.60,0.00,'2022-11-11 12:20:32'),(15,'1','292',1,'Sale Id shift 15',0.00,1286112.60,180.00,1286112.60,0.00,'2022-11-11 15:05:45'),(16,'1','292',1,'Sale Id shift 16',0.00,1512243.00,180.00,1512243.00,0.00,'2022-11-11 15:40:29'),(17,'1','292',1,'Sale Id shift 17',0.00,1523260.80,180.00,1523260.80,0.00,'2022-11-11 15:51:57'),(18,'1','292',1,'Sale Id shift 18',0.00,404350.20,180.00,404350.20,0.00,'2022-11-11 16:04:39'),(19,'1','292',1,'Sale Id shift 19',0.00,792518.40,180.00,792518.40,0.00,'2022-11-11 16:45:39'),(20,'1','292',1,'Sale Id shift 20',0.00,1094673.60,180.00,1094673.60,0.00,'2022-11-12 08:14:29'),(21,'1','292',1,'Sale Id shift 21',0.00,1136511.00,180.00,1136511.00,0.00,'2022-11-12 08:53:41'),(22,'1','292',1,'Sale Id shift 22',0.00,1087194.60,180.00,1087194.60,0.00,'2022-11-12 09:13:43'),(23,'1','292',1,'Sale Id shift 23',0.00,1510590.60,180.00,1510590.60,0.00,'2022-11-12 09:18:30'),(24,'1','292',1,'Sale Id shift 24',0.00,717143.40,180.00,717143.40,0.00,'2022-11-12 09:30:00'),(25,'1','292',1,'Sale Id shift 25',0.00,1128922.20,180.00,1128922.20,0.00,'2022-11-12 09:43:59'),(26,'1','292',1,'Sale Id shift 26',0.00,1315054.80,180.00,1315054.80,0.00,'2022-11-12 10:15:05'),(27,'1','292',1,'Sale Id shift 27',0.00,1357691.40,180.00,1357691.40,0.00,'2022-11-12 11:02:27'),(28,'1','292',1,'Sale Id shift 28',0.00,1139041.80,180.00,1139041.80,0.00,'2022-11-12 11:12:36'),(29,'1','292',1,'Sale Id shift 29',0.00,927468.00,180.00,927468.00,0.00,'2022-11-12 11:28:05'),(30,'1','292',1,'Sale Id shift 30',0.00,1697259.60,180.00,1697259.60,0.00,'2022-11-12 11:56:35'),(31,'1','292',1,'Sale Id shift 31',0.00,1290524.40,180.00,1290524.40,0.00,'2022-11-12 12:09:11'),(32,'1','292',1,'Sale Id shift 32',0.00,1537563.60,180.00,1537563.60,0.00,'2022-11-12 12:24:21'),(33,'1','292',2,'Sale Id shift 33',0.00,74760.00,840.00,74760.00,0.00,'2022-11-27 15:06:19'),(34,'1','292',2,'Sale Id shift 34',0.00,24900.00,830.00,24900.00,0.00,'2022-11-29 17:46:26'),(35,'1','292',1,'Sale Id shift 34',0.00,1263847.20,210.00,1263847.20,0.00,'2022-11-29 17:46:26'),(36,'1','292',1,'Sale Id shift 35',0.00,1693398.00,210.00,1693398.00,0.00,'2022-11-30 07:59:16'),(37,'1','292',1,'Sale Id shift 36',0.00,1381774.80,210.00,1381774.80,0.00,'2022-11-30 12:44:25'),(38,'1','292',2,'Sale Id shift 36',0.00,568550.00,830.00,568550.00,0.00,'2022-11-30 12:44:25'),(39,'1','292',1,'Sale Id shift 37',0.00,257514.60,210.00,257514.60,0.00,'2022-12-01 10:32:28'),(40,'1','292',2,'Sale Id shift 38',0.00,183120.00,840.00,183120.00,0.00,'2022-12-03 14:33:19'),(41,'1','292',1,'Sale Id 1',0.00,178500.00,210.00,178500.00,0.00,'2022-12-09 18:44:20'),(42,'1','292',1,'Sale Id 2',0.00,168000.00,180.00,144000.00,-24000.00,'2022-12-09 19:04:43'),(43,'1','292',2,'Sale Id shift 39',0.00,192360.00,840.00,192360.00,0.00,'2022-12-11 05:57:44'),(44,'1','292',2,'Sale Id shift 40',0.00,74620.00,820.00,74620.00,0.00,'2022-12-20 10:11:17'),(45,'1','292',2,'Sale Id shift 41',0.00,95120.00,820.00,95120.00,0.00,'2022-12-21 08:01:37'),(46,'1','292',2,'Sale Id shift 42',0.00,122180.00,820.00,122180.00,0.00,'2022-12-22 20:48:58'),(47,'1','292',2,'Sale Id shift 43',0.00,139400.00,820.00,139400.00,0.00,'2022-12-24 23:15:52'),(48,'1','292',2,'Sale Id shift 44',0.00,681420.00,820.00,681420.00,0.00,'2022-12-26 05:58:22'),(49,'1','292',2,'Sale Id shift 45',0.00,788020.00,820.00,788020.00,0.00,'2022-12-26 16:44:17'),(50,'1','292',2,'Sale Id shift 46',0.00,139400.00,820.00,139400.00,0.00,'2023-01-05 20:57:58'),(51,'1','292',2,'Sale Id shift 47',0.00,90200.00,820.00,90200.00,0.00,'2023-01-10 15:05:58'),(52,'1','292',2,'Sale Id shift 48',0.00,86920.00,820.00,86920.00,0.00,'2023-01-14 09:50:44'),(53,'1','292',2,'Sale Id shift 49',0.00,63960.00,820.00,63960.00,0.00,'2023-01-23 08:34:20'),(54,'1','292',2,'Sale Id shift 50',0.00,239040.00,830.00,239040.00,0.00,'2023-01-23 17:00:01'),(55,'1','292',1,'Sale Id shift 51',0.00,986973.60,240.00,986973.60,0.00,'2023-02-03 21:37:27'),(56,'1','292',2,'Sale Id shift 51',0.00,79000.00,790.00,79000.00,0.00,'2023-02-03 21:37:27'),(57,'1','292',1,'Sale Id shift 53',0.00,1052952.00,240.00,1052952.00,0.00,'2023-02-05 18:18:15'),(58,'1','292',1,'Sale Id shift 54',0.00,362446.15,205.00,362446.15,0.00,'2023-02-06 17:06:01'),(59,'1','292',1,'Sale Id shift 55',0.00,447535.50,205.00,447535.50,0.00,'2023-02-06 19:46:11'),(60,'1','292',1,'Sale Id shift 56',0.00,888609.40,205.00,888609.40,0.00,'2023-02-06 23:24:09'),(61,'1','292',1,'Sale Id shift 57',0.00,950767.45,205.00,950767.45,0.00,'2023-02-16 18:32:43'),(62,'1','292',1,'Sale Id shift 58',0.00,1038499.25,205.00,1038499.25,0.00,'2023-02-17 17:53:58'),(63,'1','292',2,'Sale Id shift 58',0.00,81000.00,810.00,81000.00,0.00,'2023-02-17 17:53:58'),(64,'1','292',1,'Sale Id shift 59',0.00,1099704.05,205.00,1099704.05,0.00,'2023-02-19 13:13:24'),(65,'1','292',1,'Sale Id 3',0.00,51250.00,205.00,51250.00,0.00,'2023-02-19 15:53:43'),(66,'1','292',1,'Sale Id shift 60',0.00,890423.65,205.00,890423.65,0.00,'2023-02-19 22:53:14'),(67,'1','292',1,'Sale Id shift 61',0.00,1069187.75,205.00,1069187.75,0.00,'2023-02-20 22:49:43'),(68,'1','292',1,'Sale Id shift 62',0.00,1111743.70,205.00,1111743.70,0.00,'2023-02-22 09:29:11'),(69,'1','292',1,'Sale Id shift 63',0.00,505205.35,235.00,505205.35,0.00,'2023-03-04 06:42:24'),(70,'1','292',2,'Sale Id shift 63',0.00,81000.00,810.00,81000.00,0.00,'2023-03-04 06:42:24'),(71,'1','292',1,'Sale Id shift 64',0.00,1504474.70,235.00,1504474.70,0.00,'2023-03-05 07:58:57'),(72,'1','292',1,'Sale Id shift 65',0.00,2641971.05,235.00,2641971.05,0.00,'2023-03-09 10:06:01'),(73,'1','292',1,'Sale Id shift 67',0.00,2232462.40,235.00,2232462.40,0.00,'2023-03-09 12:22:16'),(74,'1','292',1,'Sale Id shift 68',0.00,3432851.80,235.00,3432851.80,0.00,'2023-03-09 12:36:47'),(75,'1','292',2,'Sale Id shift 68',0.00,81000.00,810.00,81000.00,0.00,'2023-03-09 12:36:47'),(76,'1','292',1,'Sale Id shift 69',0.00,1089847.75,235.00,1089847.75,0.00,'2023-03-09 12:44:57'),(77,'1','292',1,'Sale Id shift 70',0.00,1116280.55,235.00,1116280.55,0.00,'2023-03-10 09:32:54'),(78,'1','292',1,'Sale Id shift 71',0.00,2105672.85,235.00,2105672.85,0.00,'2023-03-10 13:20:09'),(79,'1','292',1,'Sale Id shift 72',0.00,1968207.25,235.00,1968207.25,0.00,'2023-03-10 15:45:48'),(80,'1','292',1,'Sale Id shift 73',0.00,828523.05,235.00,828523.05,0.00,'2023-03-11 08:19:11'),(81,'1','292',1,'Sale Id shift 74',0.00,3196070.50,235.00,3196070.50,0.00,'2023-03-12 06:48:40'),(82,'1','292',1,'Sale Id shift 75',0.00,1675206.90,235.00,1675206.90,0.00,'2023-03-12 22:06:57'),(83,'1','292',1,'Sale Id shift 76',0.00,1147016.20,235.00,1147016.20,0.00,'2023-03-13 18:01:50'),(84,'1','292',2,'Sale Id shift 76',0.00,121500.00,810.00,121500.00,0.00,'2023-03-13 18:01:50'),(85,'1','292',1,'Sale Id shift 77',0.00,1530733.60,235.00,1530733.60,0.00,'2023-03-14 08:31:39'),(86,'1','292',1,'Sale Id shift 78',0.00,1750700.65,235.00,1750700.65,0.00,'2023-03-14 09:40:20'),(87,'1','292',1,'Sale Id shift 79',0.00,744919.45,235.00,744919.45,0.00,'2023-03-14 18:40:19'),(88,'1','292',1,'Sale Id shift 80',0.00,2015846.45,235.00,2015846.45,0.00,'2023-03-15 06:58:00'),(89,'1','292',1,'Sale Id shift 81',0.00,1845906.20,235.00,1845906.20,0.00,'2023-03-15 18:12:51'),(90,'1','292',1,'Sale Id shift 82',0.00,851830.35,235.00,851830.35,0.00,'2023-03-16 09:09:55'),(91,'1','292',1,'Sale Id shift 83',0.00,1690202.25,235.00,1690202.25,0.00,'2023-03-17 07:46:14'),(92,'1','292',1,'Sale Id shift 84',0.00,2306346.40,235.00,2306346.40,0.00,'2023-03-17 21:40:29'),(93,'1','292',1,'Sale Id shift 85',0.00,1028996.85,235.00,1028996.85,0.00,'2023-03-18 07:19:14'),(94,'1','292',1,'Sale Id shift 86',0.00,2033285.80,235.00,2033285.80,0.00,'2023-03-19 15:31:34'),(95,'1','292',1,'Sale Id shift 87',0.00,1333249.00,235.00,1333249.00,0.00,'2023-03-20 08:07:05');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=425 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('1','292',1,'','24','1',0.00,9000000.00,'Purchase Id 1 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-02 15:35:51','',''),('1','292',2,'','supplier','1',9000000.00,0.00,'Purchase Id 1 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-02 15:35:51','',''),('1','292',3,'','24','1',0.00,8100000.00,'Purchase Id 2 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-02 15:36:12','',''),('1','292',4,'','supplier','1',8100000.00,0.00,'Purchase Id 2 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-02 15:36:12','',''),('1','292',5,'','24','1',0.00,9000000.00,'Purchase Id 3 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-02 15:36:24','',''),('1','292',6,'','supplier','1',9000000.00,0.00,'Purchase Id 3 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-02 15:36:24','',''),('1','292',7,'','24','1',0.00,9000000.00,'Purchase Id 4 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-02 15:36:37','',''),('1','292',8,'','supplier','1',9000000.00,0.00,'Purchase Id 4 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-02 15:36:37','',''),('1','292',9,'','24','1',0.00,24000000.00,'Purchase Id 5 for 30,000.00 litters of Diesel - AGO from AA RANO NIGERIA LTD','2022-11-02 15:36:50','',''),('1','292',10,'','supplier','1',24000000.00,0.00,'Purchase Id 5 for 30,000.00 litters of Diesel - AGO from AA RANO NIGERIA LTD','2022-11-02 15:36:50','',''),('1','292',11,'','20','3',483584.40,0.00,'Sales from shift 1 on 2022-11-06 14:22:42 ','2022-11-06 14:22:42','',''),('1','292',12,'','6.1','2',0.00,483584.40,'Sales from shift 1 on 2022-11-06 14:22:42 ','2022-11-06 14:22:42','',''),('1','292',13,'','20','3',866050.20,0.00,'Sales from shift 2 on 2022-11-06 20:52:04 ','2022-11-06 20:52:04','',''),('1','292',14,'','6.1','2',0.00,866050.20,'Sales from shift 2 on 2022-11-06 20:52:04 ','2022-11-06 20:52:04','',''),('1','292',15,'','20','3',978663.60,0.00,'Sales from shift 3 on 2022-11-06 21:15:24 ','2022-11-06 21:15:24','',''),('1','292',16,'','6.1','2',0.00,978663.60,'Sales from shift 3 on 2022-11-06 21:15:24 ','2022-11-06 21:15:24','',''),('1','292',17,'','20','3',916713.00,0.00,'Sales from shift 4 on 2022-11-07 08:26:57 ','2022-11-07 08:26:57','',''),('1','292',18,'','6.1','2',0.00,916713.00,'Sales from shift 4 on 2022-11-07 08:26:57 ','2022-11-07 08:26:57','',''),('1','292',19,'','20','3',849182.40,0.00,'Sales from shift 5 on 2022-11-08 04:18:27 ','2022-11-08 04:18:27','',''),('1','292',20,'','6.1','2',0.00,849182.40,'Sales from shift 5 on 2022-11-08 04:18:27 ','2022-11-08 04:18:27','',''),('1','292',21,'','20','3',1086078.60,0.00,'Sales from shift 6 on 2022-11-08 16:47:36 ','2022-11-08 16:47:36','',''),('1','292',22,'','6.1','2',0.00,1086078.60,'Sales from shift 6 on 2022-11-08 16:47:36 ','2022-11-08 16:47:36','',''),('1','292',23,'','20','3',863481.60,0.00,'Sales from shift 7 on 2022-11-08 23:16:44 ','2022-11-08 23:16:44','',''),('1','292',24,'','6.1','2',0.00,863481.60,'Sales from shift 7 on 2022-11-08 23:16:44 ','2022-11-08 23:16:44','',''),('1','292',25,'','20','3',1120401.00,0.00,'Sales from shift 8 on 2022-11-09 19:27:19 ','2022-11-09 19:27:19','',''),('1','292',26,'','6.1','2',0.00,1120401.00,'Sales from shift 8 on 2022-11-09 19:27:19 ','2022-11-09 19:27:19','',''),('1','292',27,'','20','3',495586.80,0.00,'Sales from shift 9 on 2022-11-10 13:00:19 ','2022-11-10 13:00:19','',''),('1','292',28,'','6.1','2',0.00,495586.80,'Sales from shift 9 on 2022-11-10 13:00:19 ','2022-11-10 13:00:19','',''),('1','292',29,'','20','3',440816.40,0.00,'Sales from shift 10 on 2022-11-10 15:21:46 ','2022-11-10 15:21:46','',''),('1','292',30,'','6.1','2',0.00,440816.40,'Sales from shift 10 on 2022-11-10 15:21:46 ','2022-11-10 15:21:46','',''),('1','292',31,'','20','3',1174570.20,0.00,'Sales from shift 11 on 2022-11-10 16:30:32 ','2022-11-10 16:30:32','',''),('1','292',32,'','6.1','2',0.00,1174570.20,'Sales from shift 11 on 2022-11-10 16:30:32 ','2022-11-10 16:30:32','',''),('1','292',33,'','20','3',1116001.80,0.00,'Sales from shift 12 on 2022-11-10 17:39:17 ','2022-11-10 17:39:17','',''),('1','292',34,'','6.1','2',0.00,1116001.80,'Sales from shift 12 on 2022-11-10 17:39:17 ','2022-11-10 17:39:17','',''),('1','292',35,'','20','3',1161327.60,0.00,'Sales from shift 13 on 2022-11-11 10:38:26 ','2022-11-11 10:38:26','',''),('1','292',36,'','6.1','2',0.00,1161327.60,'Sales from shift 13 on 2022-11-11 10:38:26 ','2022-11-11 10:38:26','',''),('1','292',37,'','20','3',1050879.60,0.00,'Sales from shift 14 on 2022-11-11 12:20:32 ','2022-11-11 12:20:32','',''),('1','292',38,'','6.1','2',0.00,1050879.60,'Sales from shift 14 on 2022-11-11 12:20:32 ','2022-11-11 12:20:32','',''),('1','292',39,'','20','3',1286112.60,0.00,'Sales from shift 15 on 2022-11-11 15:05:45 ','2022-11-11 15:05:45','',''),('1','292',40,'','6.1','2',0.00,1286112.60,'Sales from shift 15 on 2022-11-11 15:05:45 ','2022-11-11 15:05:45','',''),('1','292',41,'','20','3',1512243.00,0.00,'Sales from shift 16 on 2022-11-11 15:40:29 ','2022-11-11 15:40:29','',''),('1','292',42,'','6.1','2',0.00,1512243.00,'Sales from shift 16 on 2022-11-11 15:40:29 ','2022-11-11 15:40:29','',''),('1','292',43,'','20','3',1523260.80,0.00,'Sales from shift 17 on 2022-11-11 15:51:57 ','2022-11-11 15:51:57','',''),('1','292',44,'','6.1','2',0.00,1523260.80,'Sales from shift 17 on 2022-11-11 15:51:57 ','2022-11-11 15:51:57','',''),('1','292',45,'','20','3',404350.20,0.00,'Sales from shift 18 on 2022-11-11 16:04:39 ','2022-11-11 16:04:39','',''),('1','292',46,'','6.1','2',0.00,404350.20,'Sales from shift 18 on 2022-11-11 16:04:39 ','2022-11-11 16:04:39','',''),('1','292',47,'','20','3',792518.40,0.00,'Sales from shift 19 on 2022-11-11 16:45:39 ','2022-11-11 16:45:39','',''),('1','292',48,'','6.1','2',0.00,792518.40,'Sales from shift 19 on 2022-11-11 16:45:39 ','2022-11-11 16:45:39','',''),('1','292',49,'','20','3',1094673.60,0.00,'Sales from shift 20 on 2022-11-12 08:14:29 ','2022-11-12 08:14:29','',''),('1','292',50,'','6.1','2',0.00,1094673.60,'Sales from shift 20 on 2022-11-12 08:14:29 ','2022-11-12 08:14:29','',''),('1','292',51,'','20','3',1136511.00,0.00,'Sales from shift 21 on 2022-11-12 08:53:40 ','2022-11-12 08:53:40','',''),('1','292',52,'','6.1','2',0.00,1136511.00,'Sales from shift 21 on 2022-11-12 08:53:40 ','2022-11-12 08:53:40','',''),('1','292',53,'','20','3',1087194.60,0.00,'Sales from shift 22 on 2022-11-12 09:13:43 ','2022-11-12 09:13:43','',''),('1','292',54,'','6.1','2',0.00,1087194.60,'Sales from shift 22 on 2022-11-12 09:13:43 ','2022-11-12 09:13:43','',''),('1','292',55,'','20','3',1510590.60,0.00,'Sales from shift 23 on 2022-11-12 09:18:30 ','2022-11-12 09:18:30','',''),('1','292',56,'','6.1','2',0.00,1510590.60,'Sales from shift 23 on 2022-11-12 09:18:30 ','2022-11-12 09:18:30','',''),('1','292',57,'','20','3',717143.40,0.00,'Sales from shift 24 on 2022-11-12 09:30:00 ','2022-11-12 09:30:00','',''),('1','292',58,'','6.1','2',0.00,717143.40,'Sales from shift 24 on 2022-11-12 09:30:00 ','2022-11-12 09:30:00','',''),('1','292',59,'','20','3',1128922.20,0.00,'Sales from shift 25 on 2022-11-12 09:43:59 ','2022-11-12 09:43:59','',''),('1','292',60,'','6.1','2',0.00,1128922.20,'Sales from shift 25 on 2022-11-12 09:43:59 ','2022-11-12 09:43:59','',''),('1','292',61,'','20','3',1315054.80,0.00,'Sales from shift 26 on 2022-11-12 10:15:05 ','2022-11-12 10:15:05','',''),('1','292',62,'','6.1','2',0.00,1315054.80,'Sales from shift 26 on 2022-11-12 10:15:05 ','2022-11-12 10:15:05','',''),('1','292',63,'','20','3',1357691.40,0.00,'Sales from shift 27 on 2022-11-12 11:02:27 ','2022-11-12 11:02:27','',''),('1','292',64,'','6.1','2',0.00,1357691.40,'Sales from shift 27 on 2022-11-12 11:02:27 ','2022-11-12 11:02:27','',''),('1','292',65,'','20','3',1139041.80,0.00,'Sales from shift 28 on 2022-11-12 11:12:36 ','2022-11-12 11:12:36','',''),('1','292',66,'','6.1','2',0.00,1139041.80,'Sales from shift 28 on 2022-11-12 11:12:36 ','2022-11-12 11:12:36','',''),('1','292',67,'','20','3',927468.00,0.00,'Sales from shift 29 on 2022-11-12 11:28:05 ','2022-11-12 11:28:05','',''),('1','292',68,'','6.1','2',0.00,927468.00,'Sales from shift 29 on 2022-11-12 11:28:05 ','2022-11-12 11:28:05','',''),('1','292',69,'','20','3',1697259.60,0.00,'Sales from shift 30 on 2022-11-12 11:56:35 ','2022-11-12 11:56:35','',''),('1','292',70,'','6.1','2',0.00,1697259.60,'Sales from shift 30 on 2022-11-12 11:56:35 ','2022-11-12 11:56:35','',''),('1','292',71,'','20','3',1290524.40,0.00,'Sales from shift 31 on 2022-11-12 12:09:11 ','2022-11-12 12:09:11','',''),('1','292',72,'','6.1','2',0.00,1290524.40,'Sales from shift 31 on 2022-11-12 12:09:11 ','2022-11-12 12:09:11','',''),('1','292',73,'','20','3',1537563.60,0.00,'Sales from shift 32 on 2022-11-12 12:24:21 ','2022-11-12 12:24:21','',''),('1','292',74,'','6.1','2',0.00,1537563.60,'Sales from shift 32 on 2022-11-12 12:24:21 ','2022-11-12 12:24:21','',''),('1','292',75,'','2','6',111500.00,0.00,'Payment Id 10 for invoice:4, receipt: 04 by AA RANO NIGERIA LTD','2022-11-15 10:47:13','',''),('1','292',76,'','supplier','1',0.00,111500.00,'Payment Id 10 for invoice:4, receipt: 04 by AA RANO NIGERIA LTD','2022-11-15 10:47:13','',''),('1','292',77,'','2','5',39000.00,0.00,'Payment Id 9 for invoice:4, receipt: 005 by AA RANO NIGERIA LTD','2022-11-15 10:47:13','',''),('1','292',78,'','supplier','1',0.00,39000.00,'Payment Id 9 for invoice:4, receipt: 005 by AA RANO NIGERIA LTD','2022-11-15 10:47:13','',''),('1','292',79,'','2','5',766210.00,0.00,'Payment Id 8 for invoice:4, receipt: 004 by AA RANO NIGERIA LTD','2022-11-15 10:47:13','',''),('1','292',80,'','supplier','1',0.00,766210.00,'Payment Id 8 for invoice:4, receipt: 004 by AA RANO NIGERIA LTD','2022-11-15 10:47:13','',''),('1','292',81,'','2','6',107700.00,0.00,'Payment Id 7 for invoice:3, receipt: 03 by AA RANO NIGERIA LTD','2022-11-15 10:47:13','',''),('1','292',82,'','supplier','1',0.00,107700.00,'Payment Id 7 for invoice:3, receipt: 03 by AA RANO NIGERIA LTD','2022-11-15 10:47:13','',''),('1','292',83,'','2','5',870970.00,0.00,'Payment Id 6 for invoice:3, receipt: 003 by AA RANO NIGERIA LTD','2022-11-15 10:47:13','',''),('1','292',84,'','supplier','1',0.00,870970.00,'Payment Id 6 for invoice:3, receipt: 003 by AA RANO NIGERIA LTD','2022-11-15 10:47:13','',''),('1','292',85,'','2','6',218970.00,0.00,'Payment Id 4 for invoice:2, receipt: 0 by AA RANO NIGERIA LTD','2022-11-15 10:47:13','',''),('1','292',86,'','supplier','1',0.00,218970.00,'Payment Id 4 for invoice:2, receipt: 0 by AA RANO NIGERIA LTD','2022-11-15 10:47:13','',''),('1','292',87,'','2','5',531600.00,0.00,'Payment Id 3 for invoice:2, receipt: 002 by AA RANO NIGERIA LTD','2022-11-15 10:47:13','',''),('1','292',88,'','supplier','1',0.00,531600.00,'Payment Id 3 for invoice:2, receipt: 002 by AA RANO NIGERIA LTD','2022-11-15 10:47:13','',''),('1','292',89,'','2','6',103301.00,0.00,'Payment Id 2 for invoice:1, receipt: 0 by AA RANO NIGERIA LTD','2022-11-15 10:47:13','',''),('1','292',90,'','supplier','1',0.00,103301.00,'Payment Id 2 for invoice:1, receipt: 0 by AA RANO NIGERIA LTD','2022-11-15 10:47:13','',''),('1','292',91,'','2','5',380290.00,0.00,'Payment Id 1 for invoice:1, receipt: 001 by AA RANO NIGERIA LTD','2022-11-15 10:47:13','',''),('1','292',92,'','supplier','1',0.00,380290.00,'Payment Id 1 for invoice:1, receipt: 001 by AA RANO NIGERIA LTD','2022-11-15 10:47:13','',''),('1','292',93,'','2','6',107900.00,0.00,'Payment Id 20 for invoice:8, receipt: 08 by AA RANO NIGERIA LTD','2022-11-15 10:48:04','',''),('1','292',94,'','supplier','1',0.00,107900.00,'Payment Id 20 for invoice:8, receipt: 08 by AA RANO NIGERIA LTD','2022-11-15 10:48:04','',''),('1','292',95,'','2','5',973550.00,0.00,'Payment Id 19 for invoice:8, receipt: 009 by AA RANO NIGERIA LTD','2022-11-15 10:48:04','',''),('1','292',96,'','supplier','1',0.00,973550.00,'Payment Id 19 for invoice:8, receipt: 009 by AA RANO NIGERIA LTD','2022-11-15 10:48:04','',''),('1','292',97,'','2','6',86900.00,0.00,'Payment Id 18 for invoice:7, receipt: 07 by AA RANO NIGERIA LTD','2022-11-15 10:48:04','',''),('1','292',98,'','supplier','1',0.00,86900.00,'Payment Id 18 for invoice:7, receipt: 07 by AA RANO NIGERIA LTD','2022-11-15 10:48:04','',''),('1','292',99,'','2','5',776580.00,0.00,'Payment Id 17 for invoice:7, receipt: 007 by AA RANO NIGERIA LTD','2022-11-15 10:48:04','',''),('1','292',100,'','supplier','1',0.00,776580.00,'Payment Id 17 for invoice:7, receipt: 007 by AA RANO NIGERIA LTD','2022-11-15 10:48:04','',''),('1','292',101,'','2','6',86500.00,0.00,'Payment Id 15 for invoice:6, receipt: 06 by AA RANO NIGERIA LTD','2022-11-15 10:48:04','',''),('1','292',102,'','supplier','1',0.00,86500.00,'Payment Id 15 for invoice:6, receipt: 06 by AA RANO NIGERIA LTD','2022-11-15 10:48:04','',''),('1','292',103,'','2','5',960580.00,0.00,'Payment Id 14 for invoice:6, receipt: 006 by AA RANO NIGERIA LTD','2022-11-15 10:48:04','',''),('1','292',104,'','supplier','1',0.00,960580.00,'Payment Id 14 for invoice:6, receipt: 006 by AA RANO NIGERIA LTD','2022-11-15 10:48:04','',''),('1','292',105,'','2','6',56000.00,0.00,'Payment Id 12 for invoice:5, receipt: 05 by AA RANO NIGERIA LTD','2022-11-15 10:48:04','',''),('1','292',106,'','supplier','1',0.00,56000.00,'Payment Id 12 for invoice:5, receipt: 05 by AA RANO NIGERIA LTD','2022-11-15 10:48:04','',''),('1','292',107,'','2','5',754180.00,0.00,'Payment Id 11 for invoice:5, receipt: 006 by AA RANO NIGERIA LTD','2022-11-15 10:48:04','',''),('1','292',108,'','supplier','1',0.00,754180.00,'Payment Id 11 for invoice:5, receipt: 006 by AA RANO NIGERIA LTD','2022-11-15 10:48:04','',''),('1','292',109,'','2','5',782350.00,0.00,'Payment Id 30 for invoice:12, receipt: 14 by AA RANO NIGERIA LTD','2022-11-15 10:48:53','',''),('1','292',110,'','supplier','1',0.00,782350.00,'Payment Id 30 for invoice:12, receipt: 14 by AA RANO NIGERIA LTD','2022-11-15 10:48:53','',''),('1','292',111,'','2','5',144000.00,0.00,'Payment Id 28 for invoice:11, receipt: 13 by AA RANO NIGERIA LTD','2022-11-15 10:48:53','',''),('1','292',112,'','supplier','1',0.00,144000.00,'Payment Id 28 for invoice:11, receipt: 13 by AA RANO NIGERIA LTD','2022-11-15 10:48:53','',''),('1','292',113,'','2','6',139230.00,0.00,'Payment Id 27 for invoice:11, receipt: 12 by AA RANO NIGERIA LTD','2022-11-15 10:48:53','',''),('1','292',114,'','supplier','1',0.00,139230.00,'Payment Id 27 for invoice:11, receipt: 12 by AA RANO NIGERIA LTD','2022-11-15 10:48:53','',''),('1','292',115,'','2','5',996350.00,0.00,'Payment Id 26 for invoice:11, receipt: 12 by AA RANO NIGERIA LTD','2022-11-15 10:48:53','',''),('1','292',116,'','supplier','1',0.00,996350.00,'Payment Id 26 for invoice:11, receipt: 12 by AA RANO NIGERIA LTD','2022-11-15 10:48:53','',''),('1','292',117,'','2','6',79300.00,0.00,'Payment Id 25 for invoice:10, receipt: 10 by AA RANO NIGERIA LTD','2022-11-15 10:48:53','',''),('1','292',118,'','supplier','1',0.00,79300.00,'Payment Id 25 for invoice:10, receipt: 10 by AA RANO NIGERIA LTD','2022-11-15 10:48:53','',''),('1','292',119,'','2','5',311520.00,0.00,'Payment Id 24 for invoice:10, receipt: 11 by AA RANO NIGERIA LTD','2022-11-15 10:48:53','',''),('1','292',120,'','supplier','1',0.00,311520.00,'Payment Id 24 for invoice:10, receipt: 11 by AA RANO NIGERIA LTD','2022-11-15 10:48:53','',''),('1','292',121,'','2','6',48200.00,0.00,'Payment Id 23 for invoice:9, receipt: 09 by AA RANO NIGERIA LTD','2022-11-15 10:48:53','',''),('1','292',122,'','supplier','1',0.00,48200.00,'Payment Id 23 for invoice:9, receipt: 09 by AA RANO NIGERIA LTD','2022-11-15 10:48:53','',''),('1','292',123,'','2','5',387400.00,0.00,'Payment Id 22 for invoice:9, receipt: 10 by AA RANO NIGERIA LTD','2022-11-15 10:48:53','',''),('1','292',124,'','supplier','1',0.00,387400.00,'Payment Id 22 for invoice:9, receipt: 10 by AA RANO NIGERIA LTD','2022-11-15 10:48:53','',''),('1','292',125,'','2','6',104000.00,0.00,'Payment Id 40 for invoice:15, receipt: 15 by AA RANO NIGERIA LTD','2022-11-15 10:49:54','',''),('1','292',126,'','supplier','1',0.00,104000.00,'Payment Id 40 for invoice:15, receipt: 15 by AA RANO NIGERIA LTD','2022-11-15 10:49:54','',''),('1','292',127,'','2','5',1143150.00,0.00,'Payment Id 39 for invoice:15, receipt: 17 by AA RANO NIGERIA LTD','2022-11-15 10:49:54','',''),('1','292',128,'','supplier','1',0.00,1143150.00,'Payment Id 39 for invoice:15, receipt: 17 by AA RANO NIGERIA LTD','2022-11-15 10:49:54','',''),('1','292',129,'','2','6',145850.00,0.00,'Payment Id 37 for invoice:14, receipt: 14 by AA RANO NIGERIA LTD','2022-11-15 10:49:54','',''),('1','292',130,'','supplier','1',0.00,145850.00,'Payment Id 37 for invoice:14, receipt: 14 by AA RANO NIGERIA LTD','2022-11-15 10:49:54','',''),('1','292',131,'','2','5',866030.00,0.00,'Payment Id 36 for invoice:14, receipt: 14 by AA RANO NIGERIA LTD','2022-11-15 10:49:54','',''),('1','292',132,'','supplier','1',0.00,866030.00,'Payment Id 36 for invoice:14, receipt: 14 by AA RANO NIGERIA LTD','2022-11-15 10:49:54','',''),('1','292',133,'','2','6',119330.00,0.00,'Payment Id 34 for invoice:13, receipt: 13 by AA RANO NIGERIA LTD','2022-11-15 10:49:54','',''),('1','292',134,'','supplier','1',0.00,119330.00,'Payment Id 34 for invoice:13, receipt: 13 by AA RANO NIGERIA LTD','2022-11-15 10:49:54','',''),('1','292',135,'','2','5',1003000.00,0.00,'Payment Id 33 for invoice:13, receipt: 14 by AA RANO NIGERIA LTD','2022-11-15 10:49:54','',''),('1','292',136,'','supplier','1',0.00,1003000.00,'Payment Id 33 for invoice:13, receipt: 14 by AA RANO NIGERIA LTD','2022-11-15 10:49:54','',''),('1','292',137,'','2','6',294650.00,0.00,'Payment Id 31 for invoice:12, receipt: 14 by AA RANO NIGERIA LTD','2022-11-15 10:49:54','',''),('1','292',138,'','supplier','1',0.00,294650.00,'Payment Id 31 for invoice:12, receipt: 14 by AA RANO NIGERIA LTD','2022-11-15 10:49:54','',''),('1','292',139,'','2','5',792510.00,0.00,'Payment Id 50 for invoice:19, receipt: 21 by AA RANO NIGERIA LTD','2022-11-15 10:50:40','',''),('1','292',140,'','supplier','1',0.00,792510.00,'Payment Id 50 for invoice:19, receipt: 21 by AA RANO NIGERIA LTD','2022-11-15 10:50:40','',''),('1','292',141,'','2','5',357350.00,0.00,'Payment Id 48 for invoice:18, receipt: 20 by AA RANO NIGERIA LTD','2022-11-15 10:50:41','',''),('1','292',142,'','supplier','1',0.00,357350.00,'Payment Id 48 for invoice:18, receipt: 20 by AA RANO NIGERIA LTD','2022-11-15 10:50:41','',''),('1','292',143,'','2','6',121375.00,0.00,'Payment Id 46 for invoice:17, receipt: 19 by AA RANO NIGERIA LTD','2022-11-15 10:50:41','',''),('1','292',144,'','supplier','1',0.00,121375.00,'Payment Id 46 for invoice:17, receipt: 19 by AA RANO NIGERIA LTD','2022-11-15 10:50:41','',''),('1','292',145,'','2','5',1362885.00,0.00,'Payment Id 45 for invoice:17, receipt: 19 by AA RANO NIGERIA LTD','2022-11-15 10:50:41','',''),('1','292',146,'','supplier','1',0.00,1362885.00,'Payment Id 45 for invoice:17, receipt: 19 by AA RANO NIGERIA LTD','2022-11-15 10:50:41','',''),('1','292',147,'','2','6',140300.00,0.00,'Payment Id 43 for invoice:16, receipt: 16 by AA RANO NIGERIA LTD','2022-11-15 10:50:41','',''),('1','292',148,'','supplier','1',0.00,140300.00,'Payment Id 43 for invoice:16, receipt: 16 by AA RANO NIGERIA LTD','2022-11-15 10:50:41','',''),('1','292',149,'','2','5',1332950.00,0.00,'Payment Id 42 for invoice:16, receipt: 18 by AA RANO NIGERIA LTD','2022-11-15 10:50:41','',''),('1','292',150,'','supplier','1',0.00,1332950.00,'Payment Id 42 for invoice:16, receipt: 18 by AA RANO NIGERIA LTD','2022-11-15 10:50:41','',''),('1','292',151,'','6.1','2',39000.00,0.00,'Payment Id 49 for invoice:18, receipt: 11 by AA RANO NIGERIA LTD','2022-11-15 10:51:18','',''),('1','292',152,'','supplier','1',0.00,39000.00,'Payment Id 49 for invoice:18, receipt: 11 by AA RANO NIGERIA LTD','2022-11-15 10:51:18','',''),('1','292',153,'','6.1','2',39000.00,0.00,'Payment Id 47 for invoice:17, receipt: 10 by AA RANO NIGERIA LTD','2022-11-15 10:51:18','',''),('1','292',154,'','supplier','1',0.00,39000.00,'Payment Id 47 for invoice:17, receipt: 10 by AA RANO NIGERIA LTD','2022-11-15 10:51:18','',''),('1','292',155,'','6.1','2',39000.00,0.00,'Payment Id 44 for invoice:16, receipt: 10 by AA RANO NIGERIA LTD','2022-11-15 10:51:18','',''),('1','292',156,'','supplier','1',0.00,39000.00,'Payment Id 44 for invoice:16, receipt: 10 by AA RANO NIGERIA LTD','2022-11-15 10:51:18','',''),('1','292',157,'','6.1','2',39000.00,0.00,'Payment Id 41 for invoice:15, receipt: 09 by AA RANO NIGERIA LTD','2022-11-15 10:51:18','',''),('1','292',158,'','supplier','1',0.00,39000.00,'Payment Id 41 for invoice:15, receipt: 09 by AA RANO NIGERIA LTD','2022-11-15 10:51:18','',''),('1','292',159,'','6.1','2',39000.00,0.00,'Payment Id 38 for invoice:14, receipt: 08 by AA RANO NIGERIA LTD','2022-11-15 10:51:18','',''),('1','292',160,'','supplier','1',0.00,39000.00,'Payment Id 38 for invoice:14, receipt: 08 by AA RANO NIGERIA LTD','2022-11-15 10:51:18','',''),('1','292',161,'','6.1','2',39000.00,0.00,'Payment Id 35 for invoice:13, receipt: 07 by AA RANO NIGERIA LTD','2022-11-15 10:51:18','',''),('1','292',162,'','supplier','1',0.00,39000.00,'Payment Id 35 for invoice:13, receipt: 07 by AA RANO NIGERIA LTD','2022-11-15 10:51:18','',''),('1','292',163,'','6.1','2',39000.00,0.00,'Payment Id 32 for invoice:12, receipt: 06 by AA RANO NIGERIA LTD','2022-11-15 10:51:18','',''),('1','292',164,'','supplier','1',0.00,39000.00,'Payment Id 32 for invoice:12, receipt: 06 by AA RANO NIGERIA LTD','2022-11-15 10:51:18','',''),('1','292',165,'','6.1','2',39000.00,0.00,'Payment Id 29 for invoice:11, receipt: 13 by AA RANO NIGERIA LTD','2022-11-15 10:51:18','',''),('1','292',166,'','supplier','1',0.00,39000.00,'Payment Id 29 for invoice:11, receipt: 13 by AA RANO NIGERIA LTD','2022-11-15 10:51:18','',''),('1','292',167,'','6.1','2',39000.00,0.00,'Payment Id 21 for invoice:8, receipt: 04 by AA RANO NIGERIA LTD','2022-11-15 10:51:18','',''),('1','292',168,'','supplier','1',0.00,39000.00,'Payment Id 21 for invoice:8, receipt: 04 by AA RANO NIGERIA LTD','2022-11-15 10:51:18','',''),('1','292',169,'','6.1','2',39000.00,0.00,'Payment Id 16 for invoice:6, receipt: 03 by AA RANO NIGERIA LTD','2022-11-15 10:51:18','',''),('1','292',170,'','supplier','1',0.00,39000.00,'Payment Id 16 for invoice:6, receipt: 03 by AA RANO NIGERIA LTD','2022-11-15 10:51:18','',''),('1','292',171,'','6.1','2',39000.00,0.00,'Payment Id 13 for invoice:5, receipt: 02 by AA RANO NIGERIA LTD','2022-11-15 10:51:39','',''),('1','292',172,'','supplier','1',0.00,39000.00,'Payment Id 13 for invoice:5, receipt: 02 by AA RANO NIGERIA LTD','2022-11-15 10:51:39','',''),('1','292',173,'','6.1','2',115500.00,0.00,'Payment Id 5 for invoice:2, receipt: 03 by AA RANO NIGERIA LTD','2022-11-15 10:53:49','',''),('1','292',174,'','supplier','1',0.00,115500.00,'Payment Id 5 for invoice:2, receipt: 03 by AA RANO NIGERIA LTD','2022-11-15 10:53:49','',''),('1','292',175,'','2','5',1078880.00,0.00,'Payment Id 53 for invoice:20, receipt: 21 by AA RANO NIGERIA LTD','2022-11-15 16:29:01','',''),('1','292',176,'','supplier','1',0.00,1078880.00,'Payment Id 53 for invoice:20, receipt: 21 by AA RANO NIGERIA LTD','2022-11-15 16:29:01','',''),('1','292',177,'','2','5',1357690.00,0.00,'Payment Id 64 for invoice:27, receipt: 26 by AA RANO NIGERIA LTD','2022-11-15 16:29:54','',''),('1','292',178,'','supplier','1',0.00,1357690.00,'Payment Id 64 for invoice:27, receipt: 26 by AA RANO NIGERIA LTD','2022-11-15 16:29:54','',''),('1','292',179,'','2','5',1291355.00,0.00,'Payment Id 62 for invoice:26, receipt: 24 by AA RANO NIGERIA LTD','2022-11-15 16:29:54','',''),('1','292',180,'','supplier','1',0.00,1291355.00,'Payment Id 62 for invoice:26, receipt: 24 by AA RANO NIGERIA LTD','2022-11-15 16:29:54','',''),('1','292',181,'','2','5',1128920.00,0.00,'Payment Id 61 for invoice:25, receipt: 23 by AA RANO NIGERIA LTD','2022-11-15 16:29:54','',''),('1','292',182,'','supplier','1',0.00,1128920.00,'Payment Id 61 for invoice:25, receipt: 23 by AA RANO NIGERIA LTD','2022-11-15 16:29:54','',''),('1','292',183,'','2','5',693440.00,0.00,'Payment Id 59 for invoice:24, receipt: 23 by AA RANO NIGERIA LTD','2022-11-15 16:29:54','',''),('1','292',184,'','supplier','1',0.00,693440.00,'Payment Id 59 for invoice:24, receipt: 23 by AA RANO NIGERIA LTD','2022-11-15 16:29:54','',''),('1','292',185,'','2','5',1510600.00,0.00,'Payment Id 58 for invoice:23, receipt: 23 by AA RANO NIGERIA LTD','2022-11-15 16:29:54','',''),('1','292',186,'','supplier','1',0.00,1510600.00,'Payment Id 58 for invoice:23, receipt: 23 by AA RANO NIGERIA LTD','2022-11-15 16:29:54','',''),('1','292',187,'','2','5',1063500.00,0.00,'Payment Id 56 for invoice:22, receipt: 13 by AA RANO NIGERIA LTD','2022-11-15 16:29:54','',''),('1','292',188,'','supplier','1',0.00,1063500.00,'Payment Id 56 for invoice:22, receipt: 13 by AA RANO NIGERIA LTD','2022-11-15 16:29:54','',''),('1','292',189,'','6.1','2',23700.00,0.00,'Payment Id 63 for invoice:26, receipt: 14 by AA RANO NIGERIA LTD','2022-11-15 16:30:28','',''),('1','292',190,'','supplier','1',0.00,23700.00,'Payment Id 63 for invoice:26, receipt: 14 by AA RANO NIGERIA LTD','2022-11-15 16:30:28','',''),('1','292',191,'','6.1','2',23700.00,0.00,'Payment Id 60 for invoice:24, receipt: 11 by AA RANO NIGERIA LTD','2022-11-15 16:30:28','',''),('1','292',192,'','supplier','1',0.00,23700.00,'Payment Id 60 for invoice:24, receipt: 11 by AA RANO NIGERIA LTD','2022-11-15 16:30:28','',''),('1','292',193,'','6.1','2',23700.00,0.00,'Payment Id 57 for invoice:22, receipt: 12 by AA RANO NIGERIA LTD','2022-11-15 16:30:28','',''),('1','292',194,'','supplier','1',0.00,23700.00,'Payment Id 57 for invoice:22, receipt: 12 by AA RANO NIGERIA LTD','2022-11-15 16:30:28','',''),('1','292',195,'','6.1','2',15800.00,0.00,'Payment Id 55 for invoice:20, receipt: 13 by AA RANO NIGERIA LTD','2022-11-15 16:30:28','',''),('1','292',196,'','supplier','1',0.00,15800.00,'Payment Id 55 for invoice:20, receipt: 13 by AA RANO NIGERIA LTD','2022-11-15 16:30:28','',''),('1','292',197,'','2','5',1136510.00,0.00,'Payment Id 54 for invoice:21, receipt: 22 by AA RANO NIGERIA LTD','2022-11-15 16:30:28','',''),('1','292',198,'','supplier','1',0.00,1136510.00,'Payment Id 54 for invoice:21, receipt: 22 by AA RANO NIGERIA LTD','2022-11-15 16:30:28','',''),('1','292',199,'','2','5',927650.00,0.00,'Payment Id 67 for invoice:29, receipt: 26 by AA RANO NIGERIA LTD','2022-11-17 16:48:11','',''),('1','292',200,'','supplier','1',0.00,927650.00,'Payment Id 67 for invoice:29, receipt: 26 by AA RANO NIGERIA LTD','2022-11-17 16:48:11','',''),('1','292',201,'','6.1','2',23700.00,0.00,'Payment Id 66 for invoice:28, receipt: 14 by AA RANO NIGERIA LTD','2022-11-17 16:48:11','',''),('1','292',202,'','supplier','1',0.00,23700.00,'Payment Id 66 for invoice:28, receipt: 14 by AA RANO NIGERIA LTD','2022-11-17 16:48:11','',''),('1','292',203,'','2','5',1115350.00,0.00,'Payment Id 65 for invoice:28, receipt: 24 by AA RANO NIGERIA LTD','2022-11-17 16:48:11','',''),('1','292',204,'','supplier','1',0.00,1115350.00,'Payment Id 65 for invoice:28, receipt: 24 by AA RANO NIGERIA LTD','2022-11-17 16:48:11','',''),('1','292',205,'','2','5',1115350.00,0.00,'Payment Id 75 for invoice:28, receipt: 28 by AA RANO NIGERIA LTD','2022-11-17 16:49:19','',''),('1','292',206,'','supplier','1',0.00,1115350.00,'Payment Id 75 for invoice:28, receipt: 28 by AA RANO NIGERIA LTD','2022-11-17 16:49:19','',''),('1','292',207,'','6.1','2',23700.00,0.00,'Payment Id 72 for invoice:32, receipt: 19 by AA RANO NIGERIA LTD','2022-11-17 16:49:19','',''),('1','292',208,'','supplier','1',0.00,23700.00,'Payment Id 72 for invoice:32, receipt: 19 by AA RANO NIGERIA LTD','2022-11-17 16:49:19','',''),('1','292',209,'','2','5',1290345.00,0.00,'Payment Id 70 for invoice:31, receipt: 29 by AA RANO NIGERIA LTD','2022-11-17 16:49:19','',''),('1','292',210,'','supplier','1',0.00,1290345.00,'Payment Id 70 for invoice:31, receipt: 29 by AA RANO NIGERIA LTD','2022-11-17 16:49:19','',''),('1','292',211,'','6.1','2',23700.00,0.00,'Payment Id 69 for invoice:30, receipt: 14 by AA RANO NIGERIA LTD','2022-11-17 16:49:19','',''),('1','292',212,'','supplier','1',0.00,23700.00,'Payment Id 69 for invoice:30, receipt: 14 by AA RANO NIGERIA LTD','2022-11-17 16:49:19','',''),('1','292',213,'','2','5',1673560.00,0.00,'Payment Id 68 for invoice:30, receipt: 26 by AA RANO NIGERIA LTD','2022-11-17 16:49:19','',''),('1','292',214,'','supplier','1',0.00,1673560.00,'Payment Id 68 for invoice:30, receipt: 26 by AA RANO NIGERIA LTD','2022-11-17 16:49:19','',''),('1','292',215,'','20','3',74760.00,0.00,'Sales from shift 33 on 2022-11-27 15:06:19 ','2022-11-27 15:06:19','',''),('1','292',216,'','6.1','2',0.00,74760.00,'Sales from shift 33 on 2022-11-27 15:06:19 ','2022-11-27 15:06:19','',''),('1','292',217,'','24','1',0.00,4725000.00,'Purchase Id 7 for 22,500.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-29 16:51:03','',''),('1','292',218,'','supplier','1',4725000.00,0.00,'Purchase Id 7 for 22,500.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-29 16:51:03','',''),('1','292',219,'','20','3',1288747.20,0.00,'Sales from shift 34 on 2022-11-29 17:46:26 ','2022-11-29 17:46:26','',''),('1','292',220,'','6.1','2',0.00,1288747.20,'Sales from shift 34 on 2022-11-29 17:46:26 ','2022-11-29 17:46:26','',''),('1','292',221,'','20','3',1693398.00,0.00,'Sales from shift 35 on 2022-11-30 07:59:16 ','2022-11-30 07:59:16','',''),('1','292',222,'','6.1','2',0.00,1693398.00,'Sales from shift 35 on 2022-11-30 07:59:16 ','2022-11-30 07:59:16','',''),('1','292',223,'','20','3',1950324.80,0.00,'Sales from shift 36 on 2022-11-30 12:44:25 ','2022-11-30 12:44:25','',''),('1','292',224,'','6.1','2',0.00,1950324.80,'Sales from shift 36 on 2022-11-30 12:44:25 ','2022-11-30 12:44:25','',''),('1','292',225,'','20','3',257514.60,0.00,'Sales from shift 37 on 2022-12-01 10:32:28 ','2022-12-01 10:32:28','',''),('1','292',226,'','6.1','2',0.00,257514.60,'Sales from shift 37 on 2022-12-01 10:32:28 ','2022-12-01 10:32:28','',''),('1','292',227,'','20','3',183120.00,0.00,'Sales from shift 38 on 2022-12-03 14:33:19 ','2022-12-03 14:33:19','',''),('1','292',228,'','6.1','2',0.00,183120.00,'Sales from shift 38 on 2022-12-03 14:33:19 ','2022-12-03 14:33:19','',''),('1','292',229,'','6.1','2',24900.00,0.00,'Payment Id 79 for invoice:34, receipt: 21 by AA RANO NIGERIA LTD','2022-12-06 12:10:30','',''),('1','292',230,'','supplier','1',0.00,24900.00,'Payment Id 79 for invoice:34, receipt: 21 by AA RANO NIGERIA LTD','2022-12-06 12:10:30','',''),('1','292',231,'','6.1','2',168000.00,0.00,'Payment Id 88 for invoice:38, receipt: 23 by AA RANO NIGERIA LTD','2022-12-06 12:10:42','',''),('1','292',232,'','supplier','1',0.00,168000.00,'Payment Id 88 for invoice:38, receipt: 23 by AA RANO NIGERIA LTD','2022-12-06 12:10:42','',''),('1','292',233,'','6.1','2',18000.00,0.00,'Payment Id 87 for invoice:37, receipt: 23 by AA RANO NIGERIA LTD','2022-12-06 12:10:55','',''),('1','292',234,'','supplier','1',0.00,18000.00,'Payment Id 87 for invoice:37, receipt: 23 by AA RANO NIGERIA LTD','2022-12-06 12:10:55','',''),('1','292',235,'','6.1','2',15000.00,0.00,'Payment Id 89 for invoice:38, receipt: 12 by AA RANO NIGERIA LTD','2022-12-06 12:11:26','',''),('1','292',236,'','supplier','1',0.00,15000.00,'Payment Id 89 for invoice:38, receipt: 12 by AA RANO NIGERIA LTD','2022-12-06 12:11:26','',''),('1','292',237,'','6.1','2',568550.00,0.00,'Payment Id 85 for invoice:36, receipt: 12 by AA RANO NIGERIA LTD','2022-12-06 12:11:44','',''),('1','292',238,'','supplier','1',0.00,568550.00,'Payment Id 85 for invoice:36, receipt: 12 by AA RANO NIGERIA LTD','2022-12-06 12:11:44','',''),('1','292',239,'','2','6',293095.00,0.00,'Payment Id 84 for invoice:36, receipt: 23 by AA RANO NIGERIA LTD','2022-12-06 12:14:20','',''),('1','292',240,'','supplier','1',0.00,293095.00,'Payment Id 84 for invoice:36, receipt: 23 by AA RANO NIGERIA LTD','2022-12-06 12:14:20','',''),('1','292',241,'','2','6',544475.00,0.00,'Payment Id 81 for invoice:35, receipt: 18 by AA RANO NIGERIA LTD','2022-12-06 12:14:20','',''),('1','292',242,'','supplier','1',0.00,544475.00,'Payment Id 81 for invoice:35, receipt: 18 by AA RANO NIGERIA LTD','2022-12-06 12:14:20','',''),('1','292',243,'','2','5',239510.00,0.00,'Payment Id 86 for invoice:37, receipt: 28 by AA RANO NIGERIA LTD','2022-12-06 13:37:14','',''),('1','292',244,'','supplier','1',0.00,239510.00,'Payment Id 86 for invoice:37, receipt: 28 by AA RANO NIGERIA LTD','2022-12-06 13:37:14','',''),('1','292',245,'','2','5',1088680.00,0.00,'Payment Id 83 for invoice:36, receipt: 29 by AA RANO NIGERIA LTD','2022-12-06 13:37:14','',''),('1','292',246,'','supplier','1',0.00,1088680.00,'Payment Id 83 for invoice:36, receipt: 29 by AA RANO NIGERIA LTD','2022-12-06 13:37:14','',''),('1','292',247,'','2','5',74760.00,0.00,'Payment Id 82 for invoice:33, receipt: 22 by AA RANO NIGERIA LTD','2022-12-06 13:37:14','',''),('1','292',248,'','supplier','1',0.00,74760.00,'Payment Id 82 for invoice:33, receipt: 22 by AA RANO NIGERIA LTD','2022-12-06 13:37:14','',''),('1','292',249,'','2','5',1148920.00,0.00,'Payment Id 80 for invoice:35, receipt: 22 by AA RANO NIGERIA LTD','2022-12-06 13:37:15','',''),('1','292',250,'','supplier','1',0.00,1148920.00,'Payment Id 80 for invoice:35, receipt: 22 by AA RANO NIGERIA LTD','2022-12-06 13:37:15','',''),('1','292',251,'','2','5',1263850.00,0.00,'Payment Id 78 for invoice:34, receipt: 23 by AA RANO NIGERIA LTD','2022-12-06 13:37:15','',''),('1','292',252,'','supplier','1',0.00,1263850.00,'Payment Id 78 for invoice:34, receipt: 23 by AA RANO NIGERIA LTD','2022-12-06 13:37:15','',''),('1','292',253,'','2','5',8000.00,0.00,'Payment Id 76 for invoice:18, receipt: 01 by AA RANO NIGERIA LTD','2022-12-06 13:37:15','',''),('1','292',254,'','supplier','1',0.00,8000.00,'Payment Id 76 for invoice:18, receipt: 01 by AA RANO NIGERIA LTD','2022-12-06 13:37:15','',''),('1','292',255,'','2','5',1494860.00,0.00,'Payment Id 71 for invoice:32, receipt: 29 by AA RANO NIGERIA LTD','2022-12-06 13:37:15','',''),('1','292',256,'','supplier','1',0.00,1494860.00,'Payment Id 71 for invoice:32, receipt: 29 by AA RANO NIGERIA LTD','2022-12-06 13:37:15','',''),('1','292',257,'','20','3',178500.00,0.00,'Sales Id 1 for 850.00 litters of Petrol - PMS @ N210.00 to DRIVER\'S SHORT','2022-12-09 18:44:20','',''),('1','292',258,'','customer','1',0.00,178500.00,'Sales Id 1 for 850.00 litters of Petrol - PMS @ N210.00','2022-12-09 18:44:20','',''),('1','292',259,'','20','3',144000.00,0.00,'Sales Id 2 for 800.00 litters of Petrol - PMS @ N180.00 to DRIVER\'S SHORT','2022-12-09 19:04:43','',''),('1','292',260,'','customer','1',0.00,144000.00,'Sales Id 2 for 800.00 litters of Petrol - PMS @ N180.00','2022-12-09 19:04:43','',''),('1','292',261,'','20','3',192360.00,0.00,'Sales from shift 39 on 2022-12-11 05:57:44 ','2022-12-11 05:57:44','',''),('1','292',262,'','6.1','2',0.00,192360.00,'Sales from shift 39 on 2022-12-11 05:57:44 ','2022-12-11 05:57:44','',''),('1','292',263,'','20','3',74620.00,0.00,'Sales from shift 40 on 2022-12-20 10:11:17 ','2022-12-20 10:11:17','',''),('1','292',264,'','6.1','2',0.00,74620.00,'Sales from shift 40 on 2022-12-20 10:11:17 ','2022-12-20 10:11:17','',''),('1','292',265,'','20','3',95120.00,0.00,'Sales from shift 41 on 2022-12-21 08:01:37 ','2022-12-21 08:01:37','',''),('1','292',266,'','6.1','2',0.00,95120.00,'Sales from shift 41 on 2022-12-21 08:01:37 ','2022-12-21 08:01:37','',''),('1','292',267,'','2','5',178500.00,0.00,'Payment Id 92 for invoice:39, receipt: 21 by AA RANO NIGERIA LTD','2022-12-21 10:47:03','',''),('1','292',268,'','supplier','1',0.00,178500.00,'Payment Id 92 for invoice:39, receipt: 21 by AA RANO NIGERIA LTD','2022-12-21 10:47:03','',''),('1','292',269,'','20','3',122180.00,0.00,'Sales from shift 42 on 2022-12-22 20:48:58 ','2022-12-22 20:48:58','',''),('1','292',270,'','6.1','2',0.00,122180.00,'Sales from shift 42 on 2022-12-22 20:48:58 ','2022-12-22 20:48:58','',''),('1','292',271,'','20','3',139400.00,0.00,'Sales from shift 43 on 2022-12-24 23:15:52 ','2022-12-24 23:15:52','',''),('1','292',272,'','6.1','2',0.00,139400.00,'Sales from shift 43 on 2022-12-24 23:15:52 ','2022-12-24 23:15:52','',''),('1','292',273,'','20','3',681420.00,0.00,'Sales from shift 44 on 2022-12-26 05:58:22 ','2022-12-26 05:58:22','',''),('1','292',274,'','6.1','2',0.00,681420.00,'Sales from shift 44 on 2022-12-26 05:58:22 ','2022-12-26 05:58:22','',''),('1','292',275,'','6.1','2',8400.00,0.00,'Payment Id 91 for invoice:39, receipt: 21 by AA RANO NIGERIA LTD','2022-12-26 09:48:05','',''),('1','292',276,'','supplier','1',0.00,8400.00,'Payment Id 91 for invoice:39, receipt: 21 by AA RANO NIGERIA LTD','2022-12-26 09:48:05','',''),('1','292',277,'','6.1','2',16400.00,0.00,'Payment Id 93 for invoice:40, receipt: 23 by AA RANO NIGERIA LTD','2022-12-26 09:48:17','',''),('1','292',278,'','supplier','1',0.00,16400.00,'Payment Id 93 for invoice:40, receipt: 23 by AA RANO NIGERIA LTD','2022-12-26 09:48:17','',''),('1','292',279,'','2','5',63700.00,0.00,'Payment Id 94 for invoice:40, receipt: 002 by AA RANO NIGERIA LTD','2022-12-26 09:49:21','',''),('1','292',280,'','supplier','1',0.00,63700.00,'Payment Id 94 for invoice:40, receipt: 002 by AA RANO NIGERIA LTD','2022-12-26 09:49:21','',''),('1','292',281,'','20','3',788020.00,0.00,'Sales from shift 45 on 2022-12-26 16:44:17 ','2022-12-26 16:44:17','',''),('1','292',282,'','6.1','2',0.00,788020.00,'Sales from shift 45 on 2022-12-26 16:44:17 ','2022-12-26 16:44:17','',''),('1','292',283,'','6.1','2',24600.00,0.00,'Payment Id 100 for invoice:45, receipt: 036 by AA RANO NIGERIA LTD','2022-12-29 16:19:23','',''),('1','292',284,'','supplier','1',0.00,24600.00,'Payment Id 100 for invoice:45, receipt: 036 by AA RANO NIGERIA LTD','2022-12-29 16:19:23','',''),('1','292',285,'','6.1','2',763420.00,0.00,'Payment Id 99 for invoice:45, receipt: 035 by AA RANO NIGERIA LTD','2022-12-29 16:19:23','',''),('1','292',286,'','supplier','1',0.00,763420.00,'Payment Id 99 for invoice:45, receipt: 035 by AA RANO NIGERIA LTD','2022-12-29 16:19:23','',''),('1','292',287,'','6.1','2',681420.00,0.00,'Payment Id 98 for invoice:44, receipt: 023 by AA RANO NIGERIA LTD','2022-12-29 16:19:23','',''),('1','292',288,'','supplier','1',0.00,681420.00,'Payment Id 98 for invoice:44, receipt: 023 by AA RANO NIGERIA LTD','2022-12-29 16:19:23','',''),('1','292',289,'','2','5',139400.00,0.00,'Payment Id 97 for invoice:43, receipt: 24 by AA RANO NIGERIA LTD','2022-12-29 16:19:23','',''),('1','292',290,'','supplier','1',0.00,139400.00,'Payment Id 97 for invoice:43, receipt: 24 by AA RANO NIGERIA LTD','2022-12-29 16:19:23','',''),('1','292',291,'','2','5',122200.00,0.00,'Payment Id 96 for invoice:42, receipt: 24 by AA RANO NIGERIA LTD','2022-12-29 16:19:23','',''),('1','292',292,'','supplier','1',0.00,122200.00,'Payment Id 96 for invoice:42, receipt: 24 by AA RANO NIGERIA LTD','2022-12-29 16:19:23','',''),('1','292',293,'','2','5',95100.00,0.00,'Payment Id 95 for invoice:41, receipt: 23 by AA RANO NIGERIA LTD','2022-12-29 16:19:23','',''),('1','292',294,'','supplier','1',0.00,95100.00,'Payment Id 95 for invoice:41, receipt: 23 by AA RANO NIGERIA LTD','2022-12-29 16:19:23','',''),('1','292',295,'','20','3',139400.00,0.00,'Sales from shift 46 on 2023-01-05 20:57:58 ','2023-01-05 20:57:58','',''),('1','292',296,'','6.1','2',0.00,139400.00,'Sales from shift 46 on 2023-01-05 20:57:58 ','2023-01-05 20:57:58','',''),('1','292',297,'','20','3',90200.00,0.00,'Sales from shift 47 on 2023-01-10 15:05:58 ','2023-01-10 15:05:58','',''),('1','292',298,'','6.1','2',0.00,90200.00,'Sales from shift 47 on 2023-01-10 15:05:58 ','2023-01-10 15:05:58','',''),('1','292',299,'','2','5',139400.00,0.00,'Payment Id 101 for invoice:46, receipt: 025 by AA RANO NIGERIA LTD','2023-01-11 14:07:03','',''),('1','292',300,'','supplier','1',0.00,139400.00,'Payment Id 101 for invoice:46, receipt: 025 by AA RANO NIGERIA LTD','2023-01-11 14:07:03','',''),('1','292',301,'','20','3',86920.00,0.00,'Sales from shift 48 on 2023-01-14 09:50:44 ','2023-01-14 09:50:44','',''),('1','292',302,'','6.1','2',0.00,86920.00,'Sales from shift 48 on 2023-01-14 09:50:44 ','2023-01-14 09:50:44','',''),('1','292',303,'','2','5',64000.00,0.00,'Payment Id 105 for invoice:49, receipt: 026 by AA RANO NIGERIA LTD','2023-01-20 11:26:43','',''),('1','292',304,'','supplier','1',0.00,64000.00,'Payment Id 105 for invoice:49, receipt: 026 by AA RANO NIGERIA LTD','2023-01-20 11:26:43','',''),('1','292',305,'','2','5',70500.00,0.00,'Payment Id 103 for invoice:48, receipt: 026 by AA RANO NIGERIA LTD','2023-01-20 11:26:43','',''),('1','292',306,'','supplier','1',0.00,70500.00,'Payment Id 103 for invoice:48, receipt: 026 by AA RANO NIGERIA LTD','2023-01-20 11:26:43','',''),('1','292',307,'','2','5',90200.00,0.00,'Payment Id 102 for invoice:47, receipt: 025 by AA RANO NIGERIA LTD','2023-01-20 11:26:43','',''),('1','292',308,'','supplier','1',0.00,90200.00,'Payment Id 102 for invoice:47, receipt: 025 by AA RANO NIGERIA LTD','2023-01-20 11:26:43','',''),('1','292',309,'','20','3',63960.00,0.00,'Sales from shift 49 on 2023-01-23 08:34:20 ','2023-01-23 08:34:20','',''),('1','292',310,'','6.1','2',0.00,63960.00,'Sales from shift 49 on 2023-01-23 08:34:20 ','2023-01-23 08:34:20','',''),('1','292',311,'','20','3',239040.00,0.00,'Sales from shift 50 on 2023-01-23 17:00:01 ','2023-01-23 17:00:01','',''),('1','292',312,'','6.1','2',0.00,239040.00,'Sales from shift 50 on 2023-01-23 17:00:01 ','2023-01-23 17:00:01','',''),('1','292',313,'','2','5',239000.00,0.00,'Payment Id 106 for invoice:50, receipt: 030 by AA RANO NIGERIA LTD','2023-01-25 11:49:20','',''),('1','292',314,'','supplier','1',0.00,239000.00,'Payment Id 106 for invoice:50, receipt: 030 by AA RANO NIGERIA LTD','2023-01-25 11:49:20','',''),('1','292',315,'','6.1','2',16400.00,0.00,'Payment Id 104 for invoice:48, receipt: 027 by AA RANO NIGERIA LTD','2023-01-30 12:36:40','',''),('1','292',316,'','supplier','1',0.00,16400.00,'Payment Id 104 for invoice:48, receipt: 027 by AA RANO NIGERIA LTD','2023-01-30 12:36:40','',''),('1','292',317,'','6.1','2',19000.00,0.00,'Payment Id 77 for invoice:32, receipt: 12 by AA RANO NIGERIA LTD','2023-01-30 12:36:40','',''),('1','292',318,'','supplier','1',0.00,19000.00,'Payment Id 77 for invoice:32, receipt: 12 by AA RANO NIGERIA LTD','2023-01-30 12:36:40','',''),('1','292',319,'','24','1',0.00,4080000.00,'Purchase Id 8 for 17,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-02-02 21:47:18','',''),('1','292',320,'','supplier','1',4080000.00,0.00,'Purchase Id 8 for 17,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-02-02 21:47:18','',''),('1','292',321,'','20','3',1065973.60,0.00,'Sales from shift 51 on 2023-02-03 21:37:27 ','2023-02-03 21:37:27','',''),('1','292',322,'','6.1','2',0.00,1065973.60,'Sales from shift 51 on 2023-02-03 21:37:27 ','2023-02-03 21:37:27','',''),('1','292',323,'','20','3',0.00,0.00,'Sales from shift 52 on 2023-02-05 18:02:20 ','2023-02-05 18:02:20','',''),('1','292',324,'','6.1','2',0.00,0.00,'Sales from shift 52 on 2023-02-05 18:02:20 ','2023-02-05 18:02:20','',''),('1','292',325,'','20','3',1052952.00,0.00,'Sales from shift 53 on 2023-02-05 18:18:15 ','2023-02-05 18:18:15','',''),('1','292',326,'','6.1','2',0.00,1052952.00,'Sales from shift 53 on 2023-02-05 18:18:15 ','2023-02-05 18:18:15','',''),('1','292',327,'','20','3',362446.15,0.00,'Sales from shift 54 on 2023-02-06 17:06:00 ','2023-02-06 17:06:00','',''),('1','292',328,'','6.1','2',0.00,362446.15,'Sales from shift 54 on 2023-02-06 17:06:00 ','2023-02-06 17:06:00','',''),('1','292',329,'','20','3',447535.50,0.00,'Sales from shift 55 on 2023-02-06 19:46:11 ','2023-02-06 19:46:11','',''),('1','292',330,'','6.1','2',0.00,447535.50,'Sales from shift 55 on 2023-02-06 19:46:11 ','2023-02-06 19:46:11','',''),('1','292',331,'','20','3',888609.40,0.00,'Sales from shift 56 on 2023-02-06 23:24:09 ','2023-02-06 23:24:09','',''),('1','292',332,'','6.1','2',0.00,888609.40,'Sales from shift 56 on 2023-02-06 23:24:09 ','2023-02-06 23:24:09','',''),('1','292',333,'','2','5',133050.00,0.00,'Payment Id 107 for invoice:51, receipt: 046 by AA RANO NIGERIA LTD','2023-02-13 11:28:20','',''),('1','292',334,'','supplier','1',0.00,133050.00,'Payment Id 107 for invoice:51, receipt: 046 by AA RANO NIGERIA LTD','2023-02-13 11:28:20','',''),('1','292',335,'','2','6',418620.00,0.00,'Payment Id 115 for invoice:55, receipt: 052 by AA RANO NIGERIA LTD','2023-02-13 11:29:07','',''),('1','292',336,'','supplier','1',0.00,418620.00,'Payment Id 115 for invoice:55, receipt: 052 by AA RANO NIGERIA LTD','2023-02-13 11:29:07','',''),('1','292',337,'','2','5',28915.00,0.00,'Payment Id 114 for invoice:55, receipt: 051 by AA RANO NIGERIA LTD','2023-02-13 11:29:07','',''),('1','292',338,'','supplier','1',0.00,28915.00,'Payment Id 114 for invoice:55, receipt: 051 by AA RANO NIGERIA LTD','2023-02-13 11:29:07','',''),('1','292',339,'','2','6',264420.00,0.00,'Payment Id 113 for invoice:54, receipt: 050 by AA RANO NIGERIA LTD','2023-02-13 11:29:07','',''),('1','292',340,'','supplier','1',0.00,264420.00,'Payment Id 113 for invoice:54, receipt: 050 by AA RANO NIGERIA LTD','2023-02-13 11:29:07','',''),('1','292',341,'','2','5',27080.00,0.00,'Payment Id 112 for invoice:54, receipt: 049 by AA RANO NIGERIA LTD','2023-02-13 11:29:07','',''),('1','292',342,'','supplier','1',0.00,27080.00,'Payment Id 112 for invoice:54, receipt: 049 by AA RANO NIGERIA LTD','2023-02-13 11:29:07','',''),('1','292',343,'','2','6',951550.00,0.00,'Payment Id 111 for invoice:53, receipt: 046 by AA RANO NIGERIA LTD','2023-02-13 11:29:07','',''),('1','292',344,'','supplier','1',0.00,951550.00,'Payment Id 111 for invoice:53, receipt: 046 by AA RANO NIGERIA LTD','2023-02-13 11:29:07','',''),('1','292',345,'','2','5',32420.00,0.00,'Payment Id 110 for invoice:53, receipt: 045 by AA RANO NIGERIA LTD','2023-02-13 11:29:07','',''),('1','292',346,'','supplier','1',0.00,32420.00,'Payment Id 110 for invoice:53, receipt: 045 by AA RANO NIGERIA LTD','2023-02-13 11:29:07','',''),('1','292',347,'','6.1','2',79000.00,0.00,'Payment Id 109 for invoice:51, receipt: 025 by AA RANO NIGERIA LTD','2023-02-13 11:29:07','',''),('1','292',348,'','supplier','1',0.00,79000.00,'Payment Id 109 for invoice:51, receipt: 025 by AA RANO NIGERIA LTD','2023-02-13 11:29:07','',''),('1','292',349,'','2','6',853919.00,0.00,'Payment Id 108 for invoice:51, receipt: 036 by AA RANO NIGERIA LTD','2023-02-13 11:29:07','',''),('1','292',350,'','supplier','1',0.00,853919.00,'Payment Id 108 for invoice:51, receipt: 036 by AA RANO NIGERIA LTD','2023-02-13 11:29:07','',''),('1','292',351,'','24','1',0.00,6150000.00,'Purchase Id 9 for 30,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-02-16 17:58:28','',''),('1','292',352,'','supplier','1',6150000.00,0.00,'Purchase Id 9 for 30,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-02-16 17:58:28','',''),('1','292',353,'','20','3',950767.45,0.00,'Sales from shift 57 on 2023-02-16 18:32:43 ','2023-02-16 18:32:43','',''),('1','292',354,'','6.1','2',0.00,950767.45,'Sales from shift 57 on 2023-02-16 18:32:43 ','2023-02-16 18:32:43','',''),('1','292',355,'','20','3',1119499.25,0.00,'Sales from shift 58 on 2023-02-17 17:53:58 ','2023-02-17 17:53:58','',''),('1','292',356,'','6.1','2',0.00,1119499.25,'Sales from shift 58 on 2023-02-17 17:53:58 ','2023-02-17 17:53:58','',''),('1','292',357,'','20','3',1099704.05,0.00,'Sales from shift 59 on 2023-02-19 13:13:23 ','2023-02-19 13:13:23','',''),('1','292',358,'','6.1','2',0.00,1099704.05,'Sales from shift 59 on 2023-02-19 13:13:23 ','2023-02-19 13:13:23','',''),('1','292',359,'','20','3',51250.00,0.00,'Sales Id 3 for 250.00 litters of Petrol - PMS @ N205.00 to DRIVER\'S SHORT','2023-02-19 15:53:43','',''),('1','292',360,'','customer','1',0.00,51250.00,'Sales Id 3 for 250.00 litters of Petrol - PMS @ N205.00','2023-02-19 15:53:43','',''),('1','292',361,'','20','3',890423.65,0.00,'Sales from shift 60 on 2023-02-19 22:53:14 ','2023-02-19 22:53:14','',''),('1','292',362,'','6.1','2',0.00,890423.65,'Sales from shift 60 on 2023-02-19 22:53:14 ','2023-02-19 22:53:14','',''),('1','292',363,'','20','3',1069187.75,0.00,'Sales from shift 61 on 2023-02-20 22:49:43 ','2023-02-20 22:49:43','',''),('1','292',364,'','6.1','2',0.00,1069187.75,'Sales from shift 61 on 2023-02-20 22:49:43 ','2023-02-20 22:49:43','',''),('1','292',365,'','20','3',1111743.70,0.00,'Sales from shift 62 on 2023-02-22 09:29:11 ','2023-02-22 09:29:11','',''),('1','292',366,'','6.1','2',0.00,1111743.70,'Sales from shift 62 on 2023-02-22 09:29:11 ','2023-02-22 09:29:11','',''),('1','292',367,'','24','1',0.00,3877500.00,'Purchase Id 10 for 16,500.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-03 15:03:04','',''),('1','292',368,'','supplier','1',3877500.00,0.00,'Purchase Id 10 for 16,500.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-03 15:03:04','',''),('1','292',369,'','20','3',586205.35,0.00,'Sales from shift 63 on 2023-03-04 06:42:24 ','2023-03-04 06:42:24','',''),('1','292',370,'','6.1','2',0.00,586205.35,'Sales from shift 63 on 2023-03-04 06:42:24 ','2023-03-04 06:42:24','',''),('1','292',371,'','20','3',1504474.70,0.00,'Sales from shift 64 on 2023-03-05 07:58:57 ','2023-03-05 07:58:57','',''),('1','292',372,'','6.1','2',0.00,1504474.70,'Sales from shift 64 on 2023-03-05 07:58:57 ','2023-03-05 07:58:57','',''),('1','292',373,'','24','1',0.00,10575000.00,'Purchase Id 11 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-06 23:11:59','',''),('1','292',374,'','supplier','1',10575000.00,0.00,'Purchase Id 11 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-06 23:11:59','',''),('1','292',375,'','20','3',2641971.05,0.00,'Sales from shift 65 on 2023-03-09 10:06:01 ','2023-03-09 10:06:01','',''),('1','292',376,'','6.1','2',0.00,2641971.05,'Sales from shift 65 on 2023-03-09 10:06:01 ','2023-03-09 10:06:01','',''),('1','292',377,'','20','3',0.00,0.00,'Sales from shift 66 on 2023-03-09 12:00:28 ','2023-03-09 12:00:28','',''),('1','292',378,'','6.1','2',0.00,0.00,'Sales from shift 66 on 2023-03-09 12:00:28 ','2023-03-09 12:00:28','',''),('1','292',379,'','20','3',2232462.40,0.00,'Sales from shift 67 on 2023-03-09 12:22:16 ','2023-03-09 12:22:16','',''),('1','292',380,'','6.1','2',0.00,2232462.40,'Sales from shift 67 on 2023-03-09 12:22:16 ','2023-03-09 12:22:16','',''),('1','292',381,'','20','3',3513851.80,0.00,'Sales from shift 68 on 2023-03-09 12:36:47 ','2023-03-09 12:36:47','',''),('1','292',382,'','6.1','2',0.00,3513851.80,'Sales from shift 68 on 2023-03-09 12:36:47 ','2023-03-09 12:36:47','',''),('1','292',383,'','20','3',1089847.75,0.00,'Sales from shift 69 on 2023-03-09 12:44:57 ','2023-03-09 12:44:57','',''),('1','292',384,'','6.1','2',0.00,1089847.75,'Sales from shift 69 on 2023-03-09 12:44:57 ','2023-03-09 12:44:57','',''),('1','292',385,'','24','1',0.00,14100000.00,'Purchase Id 12 for 60,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-09 13:49:56','',''),('1','292',386,'','supplier','1',14100000.00,0.00,'Purchase Id 12 for 60,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-09 13:49:56','',''),('1','292',387,'','20','3',1116280.55,0.00,'Sales from shift 70 on 2023-03-10 09:32:53 ','2023-03-10 09:32:53','',''),('1','292',388,'','6.1','2',0.00,1116280.55,'Sales from shift 70 on 2023-03-10 09:32:53 ','2023-03-10 09:32:53','',''),('1','292',389,'','20','3',2105672.85,0.00,'Sales from shift 71 on 2023-03-10 13:20:09 ','2023-03-10 13:20:09','',''),('1','292',390,'','6.1','2',0.00,2105672.85,'Sales from shift 71 on 2023-03-10 13:20:09 ','2023-03-10 13:20:09','',''),('1','292',391,'','20','3',1968207.25,0.00,'Sales from shift 72 on 2023-03-10 15:45:48 ','2023-03-10 15:45:48','',''),('1','292',392,'','6.1','2',0.00,1968207.25,'Sales from shift 72 on 2023-03-10 15:45:48 ','2023-03-10 15:45:48','',''),('1','292',393,'','20','3',828523.05,0.00,'Sales from shift 73 on 2023-03-11 08:19:11 ','2023-03-11 08:19:11','',''),('1','292',394,'','6.1','2',0.00,828523.05,'Sales from shift 73 on 2023-03-11 08:19:11 ','2023-03-11 08:19:11','',''),('1','292',395,'','20','3',3196070.50,0.00,'Sales from shift 74 on 2023-03-12 06:48:39 ','2023-03-12 06:48:39','',''),('1','292',396,'','6.1','2',0.00,3196070.50,'Sales from shift 74 on 2023-03-12 06:48:39 ','2023-03-12 06:48:39','',''),('1','292',397,'','20','3',1675206.90,0.00,'Sales from shift 75 on 2023-03-12 22:06:57 ','2023-03-12 22:06:57','',''),('1','292',398,'','6.1','2',0.00,1675206.90,'Sales from shift 75 on 2023-03-12 22:06:57 ','2023-03-12 22:06:57','',''),('1','292',399,'','20','3',1268516.20,0.00,'Sales from shift 76 on 2023-03-13 18:01:50 ','2023-03-13 18:01:50','',''),('1','292',400,'','6.1','2',0.00,1268516.20,'Sales from shift 76 on 2023-03-13 18:01:50 ','2023-03-13 18:01:50','',''),('1','292',401,'','24','1',0.00,14100000.00,'Purchase Id 13 for 60,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-13 19:54:31','',''),('1','292',402,'','supplier','1',14100000.00,0.00,'Purchase Id 13 for 60,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-13 19:54:31','',''),('1','292',403,'','20','3',1530733.60,0.00,'Sales from shift 77 on 2023-03-14 08:31:39 ','2023-03-14 08:31:39','',''),('1','292',404,'','6.1','2',0.00,1530733.60,'Sales from shift 77 on 2023-03-14 08:31:39 ','2023-03-14 08:31:39','',''),('1','292',405,'','20','3',1750700.65,0.00,'Sales from shift 78 on 2023-03-14 09:40:20 ','2023-03-14 09:40:20','',''),('1','292',406,'','6.1','2',0.00,1750700.65,'Sales from shift 78 on 2023-03-14 09:40:20 ','2023-03-14 09:40:20','',''),('1','292',407,'','20','3',744919.45,0.00,'Sales from shift 79 on 2023-03-14 18:40:19 ','2023-03-14 18:40:19','',''),('1','292',408,'','6.1','2',0.00,744919.45,'Sales from shift 79 on 2023-03-14 18:40:19 ','2023-03-14 18:40:19','',''),('1','292',409,'','20','3',2015846.45,0.00,'Sales from shift 80 on 2023-03-15 06:58:00 ','2023-03-15 06:58:00','',''),('1','292',410,'','6.1','2',0.00,2015846.45,'Sales from shift 80 on 2023-03-15 06:58:00 ','2023-03-15 06:58:00','',''),('1','292',411,'','20','3',1845906.20,0.00,'Sales from shift 81 on 2023-03-15 18:12:51 ','2023-03-15 18:12:51','',''),('1','292',412,'','6.1','2',0.00,1845906.20,'Sales from shift 81 on 2023-03-15 18:12:51 ','2023-03-15 18:12:51','',''),('1','292',413,'','20','3',851830.35,0.00,'Sales from shift 82 on 2023-03-16 09:09:55 ','2023-03-16 09:09:55','',''),('1','292',414,'','6.1','2',0.00,851830.35,'Sales from shift 82 on 2023-03-16 09:09:55 ','2023-03-16 09:09:55','',''),('1','292',415,'','20','3',1690202.25,0.00,'Sales from shift 83 on 2023-03-17 07:46:14 ','2023-03-17 07:46:14','',''),('1','292',416,'','6.1','2',0.00,1690202.25,'Sales from shift 83 on 2023-03-17 07:46:14 ','2023-03-17 07:46:14','',''),('1','292',417,'','20','3',2306346.40,0.00,'Sales from shift 84 on 2023-03-17 21:40:29 ','2023-03-17 21:40:29','',''),('1','292',418,'','6.1','2',0.00,2306346.40,'Sales from shift 84 on 2023-03-17 21:40:29 ','2023-03-17 21:40:29','',''),('1','292',419,'','20','3',1028996.85,0.00,'Sales from shift 85 on 2023-03-18 07:19:14 ','2023-03-18 07:19:14','',''),('1','292',420,'','6.1','2',0.00,1028996.85,'Sales from shift 85 on 2023-03-18 07:19:14 ','2023-03-18 07:19:14','',''),('1','292',421,'','20','3',2033285.80,0.00,'Sales from shift 86 on 2023-03-19 15:31:34 ','2023-03-19 15:31:34','',''),('1','292',422,'','6.1','2',0.00,2033285.80,'Sales from shift 86 on 2023-03-19 15:31:34 ','2023-03-19 15:31:34','',''),('1','292',423,'','20','3',1333249.00,0.00,'Sales from shift 87 on 2023-03-20 08:07:05 ','2023-03-20 08:07:05','',''),('1','292',424,'','6.1','2',0.00,1333249.00,'Sales from shift 87 on 2023-03-20 08:07:05 ','2023-03-20 08:07:05','','');
/*!40000 ALTER TABLE `ledgers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `options`
--

DROP TABLE IF EXISTS `options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `options` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` bigint NOT NULL,
  `station_id` bigint NOT NULL,
  `option_key` varchar(200) NOT NULL,
  `option_value` longtext,
  `thedate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `station_id` (`station_id`,`option_key`),
  KEY `company_id` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `options`
--

LOCK TABLES `options` WRITE;
/*!40000 ALTER TABLE `options` DISABLE KEYS */;
/*!40000 ALTER TABLE `options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `measurement` varchar(20) NOT NULL,
  `quantity2` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`code`,`name`,`measurement`,`quantity2`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `cleanup` (`cleanup`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'1','292','PMS','Petrol','Litres',0,235.00,235.00,235.00,235.00,0.00,0,'2022-10-19 10:45:26','178','178','2022-10-19 10:45:26',0),(2,'1','292','AGO','Diesel','Litres',0,790.00,790.00,790.00,790.00,0.00,0,'2022-10-19 10:51:08','178','178','2022-10-19 10:51:08',0),(3,'1','292','DPK','Kerosene','Litres',0,0.00,0.00,0.00,0.00,0.00,0,'2022-10-19 10:52:47','178','178','2022-10-19 10:52:47',0);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_changevalues`
--

DROP TABLE IF EXISTS `products_changevalues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_changevalues` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `change_id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity` bigint NOT NULL,
  `oldrate` decimal(20,2) NOT NULL,
  `newrate` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`change_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_changevalues`
--

LOCK TABLES `products_changevalues` WRITE;
/*!40000 ALTER TABLE `products_changevalues` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_changevalues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_prices`
--

DROP TABLE IF EXISTS `products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_prices`
--

LOCK TABLES `products_prices` WRITE;
/*!40000 ALTER TABLE `products_prices` DISABLE KEYS */;
INSERT INTO `products_prices` VALUES (1,'1','292',1,180.00,0.00,0.00,0.00,'Cost from purchase id #1','2022-11-02 15:35:51','975'),(2,'1','292',2,800.00,0.00,0.00,0.00,'Cost from purchase id #5','2022-11-02 15:36:50','975'),(3,'1','292',1,180.00,180.00,180.00,180.00,'180','2022-11-03 16:37:55','967'),(4,'1','292',2,800.00,800.00,800.00,800.00,'800','2022-11-03 16:39:06','967'),(5,'1','292',2,840.00,840.00,840.00,840.00,'','2022-11-25 19:55:19','967'),(6,'1','292',2,830.00,830.00,830.00,830.00,'830','2022-11-28 20:13:42','967'),(7,'1','292',1,210.00,210.00,210.00,210.00,'210','2022-11-28 20:14:29','967'),(8,'1','292',2,840.00,840.00,840.00,840.00,'840','2022-11-30 13:39:58','967'),(9,'1','292',2,880.00,880.00,880.00,880.00,'880','2022-12-03 20:17:37','967'),(10,'1','292',2,840.00,840.00,840.00,840.00,'840','2022-12-06 14:47:05','967'),(11,'1','292',2,820.00,820.00,820.00,820.00,'820','2022-12-14 16:21:05','967'),(12,'1','292',2,830.00,830.00,830.00,830.00,'830','2023-01-17 23:08:30','967'),(13,'1','292',2,790.00,790.00,790.00,790.00,'','2023-01-30 22:50:51','967'),(14,'1','292',1,240.00,240.00,240.00,240.00,'','2023-02-02 14:53:19','967'),(15,'1','292',1,205.00,205.00,205.00,205.00,'205','2023-02-03 22:08:27','967'),(16,'1','292',1,240.00,240.00,240.00,240.00,'','2023-02-05 18:06:55','967'),(17,'1','292',1,205.00,205.00,205.00,205.00,'','2023-02-05 18:22:41','967'),(18,'1','292',2,810.00,810.00,810.00,810.00,'','2023-02-16 12:18:57','967'),(19,'1','292',1,235.00,235.00,235.00,235.00,'235','2023-03-03 12:55:24','967'),(20,'1','292',2,790.00,790.00,790.00,790.00,'790','2023-03-13 18:31:17','967');
/*!40000 ALTER TABLE `products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_reconciliations`
--

DROP TABLE IF EXISTS `products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_reconciliations`
--

LOCK TABLES `products_reconciliations` WRITE;
/*!40000 ALTER TABLE `products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_shortages`
--

DROP TABLE IF EXISTS `products_shortages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_shortages` (
  `shortage_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shortagedate` date NOT NULL,
  `product_id` varchar(10) NOT NULL,
  `type` int NOT NULL DEFAULT '0',
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`shortage_id`),
  KEY `companycode` (`company_id`,`shortagedate`,`product_id`,`rate`,`quantity`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_shortages`
--

LOCK TABLES `products_shortages` WRITE;
/*!40000 ALTER TABLE `products_shortages` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_shortages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pts_nozzles`
--

DROP TABLE IF EXISTS `pts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pts_nozzles` (
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pts_id` int NOT NULL,
  `pump` varchar(20) NOT NULL,
  `code` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `last_volume` decimal(20,2) NOT NULL,
  `last_price` decimal(20,2) NOT NULL,
  `last_amount` decimal(20,2) NOT NULL,
  `last_transaction` int NOT NULL DEFAULT '0',
  `total_volume` decimal(20,2) NOT NULL,
  `total_amount` decimal(20,2) NOT NULL,
  `total_transactions` decimal(20,2) NOT NULL,
  `lastconnect` datetime NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `terminal_id` (`pts_id`,`pump`,`code`,`lastconnect`),
  KEY `companycode` (`company_id`,`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pts_nozzles`
--

LOCK TABLES `pts_nozzles` WRITE;
/*!40000 ALTER TABLE `pts_nozzles` DISABLE KEYS */;
/*!40000 ALTER TABLE `pts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases`
--

DROP TABLE IF EXISTS `purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases`
--

LOCK TABLES `purchases` WRITE;
/*!40000 ALTER TABLE `purchases` DISABLE KEYS */;
INSERT INTO `purchases` VALUES (1,'1','292','2022-09-30',1,1,180.00,50000.00,0.00,0.00,9000000.00,0.00,'','0137463','NSR856ZQ ','','','','2022-11-02 10:16:18',15,'','967','','0000-00-00 00:00:00','975','2022-11-02 15:35:51'),(2,'1','292','2022-10-08',1,1,180.00,45000.00,0.00,0.00,8100000.00,0.00,'','0138','EKY96XY ','','','','2022-11-02 10:25:46',15,'','967','','0000-00-00 00:00:00','975','2022-11-02 15:36:12'),(3,'1','292','2022-10-13',1,1,180.00,50000.00,0.00,0.00,9000000.00,0.00,'','01908','RAN849XA ','','','','2022-11-02 10:29:00',15,'','967','','0000-00-00 00:00:00','975','2022-11-02 15:36:24'),(4,'1','292','2022-10-13',1,1,180.00,50000.00,0.00,0.00,9000000.00,0.00,'','06231','BCH 994XA ','','','','2022-11-02 10:32:24',15,'','967','','0000-00-00 00:00:00','975','2022-11-02 15:36:37'),(5,'1','292','2022-11-01',2,1,800.00,30000.00,0.00,0.00,24000000.00,0.00,'','0272164','KMC693ZE ','','','','2022-11-02 10:41:08',15,'','967','','0000-00-00 00:00:00','975','2022-11-02 15:36:50'),(7,'1','292','2022-11-27',1,1,210.00,22500.00,0.00,0.00,4725000.00,0.00,'','001','RAN 690 XA','','','','2022-11-29 13:35:23',15,'','967','','0000-00-00 00:00:00','648','2022-11-29 16:51:03'),(8,'1','292','2023-02-01',1,1,240.00,17000.00,0.00,0.00,4080000.00,0.00,'','005','RAN 426 XA','','','','2023-02-02 14:55:27',15,'','967','','0000-00-00 00:00:00','648','2023-02-02 21:47:18'),(9,'1','292','2023-02-16',1,1,205.00,30000.00,0.00,0.00,6150000.00,0.00,'','006','KMC 663 ZE','','','','2023-02-16 12:18:13',15,'','967','','0000-00-00 00:00:00','648','2023-02-16 17:58:28'),(10,'1','292','2023-03-03',1,1,235.00,16500.00,0.00,0.00,3877500.00,0.00,'','007','FGC 982 ZY','','','','2023-03-03 12:57:31',15,'','967','','0000-00-00 00:00:00','648','2023-03-03 15:03:04'),(11,'1','292','2023-03-05',1,1,235.00,45000.00,0.00,0.00,10575000.00,0.00,'','008','NSR515ZU','','','','2023-03-05 16:36:10',15,'','967','','0000-00-00 00:00:00','648','2023-03-06 23:11:59'),(12,'1','292','2023-03-07',1,1,235.00,60000.00,0.00,0.00,14100000.00,0.00,'','009','KMC654ZE','','','','2023-03-09 11:56:41',15,'','967','','0000-00-00 00:00:00','648','2023-03-09 13:49:56'),(13,'1','292','2023-03-12',1,1,235.00,60000.00,0.00,0.00,14100000.00,0.00,'','010','TRN34YZ','','','','2023-03-13 18:42:01',15,'','967','','0000-00-00 00:00:00','648','2023-03-13 19:54:31');
/*!40000 ALTER TABLE `purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_payments`
--

DROP TABLE IF EXISTS `purchases_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `supplier_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`supplier_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=152 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_payments`
--

LOCK TABLES `purchases_payments` WRITE;
/*!40000 ALTER TABLE `purchases_payments` DISABLE KEYS */;
INSERT INTO `purchases_payments` VALUES (1,'1','292','2022-10-03',1,'001','','5',380290.00,'1','','','5','AMINU ISAH','029893',483584.40,'2022-11-14 15:43:55',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:47:13'),(2,'1','292','2022-10-03',1,'0','','10',103301.00,'1','','','6','','001',0.00,'2022-11-14 15:49:52',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:47:13'),(3,'1','292','2022-10-04',1,'002','','5',531600.00,'2','','','5','AMINU ISAH','026336',866050.20,'2022-11-14 15:53:28',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:47:13'),(4,'1','292','2022-10-04',1,'0','','5',218970.00,'2','','','6','','002',0.00,'2022-11-14 15:55:57',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:47:13'),(5,'1','292','2022-10-04',1,'03','','2',115500.00,'2','','','','','',0.00,'2022-11-14 19:30:20',5,'AGO CONSUPTION','967','975','2022-11-15 10:53:36','975','2022-11-15 10:53:49'),(6,'1','292','2022-10-05',1,'003','','5',870970.00,'3','','','5','AMINU ISAH ','012806',978663.60,'2022-11-14 19:35:52',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:47:13'),(7,'1','292','2022-10-05',1,'03','','5',107700.00,'3','','','6','','0',0.00,'2022-11-14 19:37:27',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:47:13'),(8,'1','292','2022-10-06',1,'004','','5',766210.00,'4','','','5','AMINU ISAH','025379',916713.00,'2022-11-14 19:41:04',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:47:13'),(9,'1','292','2022-10-06',1,'005','','5',39000.00,'4','','','5','AMINU ISAH ','005',0.00,'2022-11-14 19:43:42',5,'','967','975','2022-11-15 10:45:11','975','2022-11-15 10:47:13'),(10,'1','292','2022-10-06',1,'04','','10',111500.00,'4','','','6','','04',0.00,'2022-11-14 19:45:19',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:47:13'),(11,'1','292','2022-10-07',1,'006','','5',754180.00,'5','','','5','Aminu isah','019930',849182.40,'2022-11-14 19:48:41',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:48:04'),(12,'1','292','2022-10-07',1,'05','','10',56000.00,'5','','','6','','05',0.00,'2022-11-14 19:50:40',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:48:04'),(13,'1','292','2022-10-07',1,'02','','2',39000.00,'5','','','','','',0.00,'2022-11-14 19:51:58',5,'AGO CONSUMPTION 50L','967','','0000-00-00 00:00:00','975','2022-11-15 10:51:39'),(14,'1','292','2022-10-08',1,'006','','5',960580.00,'6','','','5','AMINU ISAH ','019929',1086078.60,'2022-11-14 19:53:44',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:48:04'),(15,'1','292','2022-11-14',1,'06','','10',86500.00,'6','','','6','','06',0.00,'2022-11-14 19:55:33',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:48:04'),(16,'1','292','2022-10-08',1,'03','','2',39000.00,'6','','','','','',0.00,'2022-11-14 19:57:14',5,'AGO CONSUMPTION 50L','967','','0000-00-00 00:00:00','975','2022-11-15 10:51:18'),(17,'1','292','2022-10-09',1,'007','','5',776580.00,'7','','','5','AMINU ISAH ','019928',863481.60,'2022-11-14 19:58:54',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:48:04'),(18,'1','292','2022-10-09',1,'07','','10',86900.00,'7','','','6','','07',0.00,'2022-11-14 20:00:25',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:48:04'),(19,'1','292','2022-10-10',1,'009','','5',973550.00,'8','','','5','Aminu Isah ','019927',1120401.00,'2022-11-14 20:02:43',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:48:04'),(20,'1','292','2022-10-10',1,'08','','5',107900.00,'8','','','6','','08',0.00,'2022-11-14 20:04:18',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:48:04'),(21,'1','292','2022-10-10',1,'04','','2',39000.00,'8','','','','','',0.00,'2022-11-14 20:06:01',5,'AGO CONSUMPTION 50L','967','','0000-00-00 00:00:00','975','2022-11-15 10:51:18'),(22,'1','292','2022-10-11',1,'10','','5',387400.00,'9','','','5','Aminu isah','10',495586.80,'2022-11-15 09:01:34',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:48:53'),(23,'1','292','2022-10-11',1,'09','','10',48200.00,'9','','','6','','09',0.00,'2022-11-15 09:02:48',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:48:53'),(24,'1','292','2022-10-12',1,'11','','5',311520.00,'10','','','5','Aminu isah ','029253',440816.40,'2022-11-15 09:04:59',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:48:53'),(25,'1','292','2022-10-12',1,'10','','10',79300.00,'10','','','6','','11',0.00,'2022-11-15 09:07:01',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:48:53'),(26,'1','292','2022-10-13',1,'12','','5',996350.00,'11','','','5','Aminu Isah ','029255',1174570.20,'2022-11-15 09:08:56',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:48:53'),(27,'1','292','2022-10-13',1,'12','','10',139230.00,'11','','','6','','12',0.00,'2022-11-15 09:10:47',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:48:53'),(28,'1','292','2022-10-13',1,'13','','5',144000.00,'11','','','5','Aminu isah ','13',0.00,'2022-11-15 09:13:06',5,'DRIVER SHORTAGE ','967','','0000-00-00 00:00:00','975','2022-11-15 10:48:53'),(29,'1','292','2022-10-13',1,'13','','2',39000.00,'11','','','','','',0.00,'2022-11-15 09:14:36',5,'AGO CONSUMPTION 50L','967','','0000-00-00 00:00:00','975','2022-11-15 10:51:18'),(30,'1','292','2022-10-14',1,'14','','5',782350.00,'12','','','5','Aminu isah','029259',1116001.80,'2022-11-15 09:16:10',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:48:53'),(31,'1','292','2022-10-14',1,'14','','10',294650.00,'12','','','6','','14',0.00,'2022-11-15 09:17:29',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:49:54'),(32,'1','292','2022-10-14',1,'06','','2',39000.00,'12','','','','','',0.00,'2022-11-15 09:19:34',5,'AGO CONSUMPTION 50L','967','','0000-00-00 00:00:00','975','2022-11-15 10:51:18'),(33,'1','292','2022-10-15',1,'14','','5',1003000.00,'13','','','5','Aminu isah ','029256',1161327.60,'2022-11-15 09:21:52',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:49:54'),(34,'1','292','2022-10-15',1,'13','','10',119330.00,'13','','','6','','15',0.00,'2022-11-15 09:23:48',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:49:54'),(35,'1','292','2022-10-15',1,'07','','2',39000.00,'13','','','','','',0.00,'2022-11-15 09:24:50',5,'AGO CONSUMPTION 50L','967','','0000-00-00 00:00:00','975','2022-11-15 10:51:18'),(36,'1','292','2022-10-16',1,'14','','5',866030.00,'14','','','5','Aminu Isah','029257',1050879.60,'2022-11-15 09:26:21',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:49:54'),(37,'1','292','2022-10-16',1,'14','','10',145850.00,'14','','','6','','16',0.00,'2022-11-15 09:28:20',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:49:54'),(38,'1','292','2022-11-15',1,'08','','2',39000.00,'14','','','','','',0.00,'2022-11-15 09:30:28',5,'AGO CONSUMPTION 50L','967','','0000-00-00 00:00:00','975','2022-11-15 10:51:18'),(39,'1','292','2022-10-17',1,'17','','5',1143150.00,'15','','','5','Aminu isah ','029258',1286112.60,'2022-11-15 09:37:06',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:49:54'),(40,'1','292','2022-10-17',1,'15','','10',104000.00,'15','','','6','','17',0.00,'2022-11-15 09:38:51',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:49:54'),(41,'1','292','2022-10-17',1,'09','','2',39000.00,'15','','','','','',0.00,'2022-11-15 09:39:58',5,'AGO CONSUMPTION 50L','967','','0000-00-00 00:00:00','975','2022-11-15 10:51:18'),(42,'1','292','2022-10-18',1,'18','','5',1332950.00,'16','','','5','Aminu isah ','029260',1512243.00,'2022-11-15 10:22:32',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:50:41'),(43,'1','292','2022-10-18',1,'16','','10',140300.00,'16','','','6','','18',0.00,'2022-11-15 10:24:07',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:50:41'),(44,'1','292','2022-10-18',1,'10','','2',39000.00,'16','','','','','',0.00,'2022-11-15 10:25:30',5,'AGO CONSUMPTION 50L','967','','0000-00-00 00:00:00','975','2022-11-15 10:51:18'),(45,'1','292','2022-10-19',1,'19','','5',1362885.00,'17','','','5','Aminu isah ','029261',1523260.80,'2022-11-15 10:28:03',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:50:41'),(46,'1','292','2022-10-19',1,'19','','10',121375.00,'17','','','6','','19',0.00,'2022-11-15 10:29:28',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:50:41'),(47,'1','292','2022-10-19',1,'10','','2',39000.00,'17','','','','','',0.00,'2022-11-15 10:30:51',5,'AGO CONSUMPTION 50L','967','','0000-00-00 00:00:00','975','2022-11-15 10:51:18'),(48,'1','292','2022-10-20',1,'20','','5',357350.00,'18','','','5','Aminu Isah','029310',404350.20,'2022-11-15 10:35:32',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:50:41'),(49,'1','292','2022-10-20',1,'11','','2',39000.00,'18','','','','','',0.00,'2022-11-15 10:37:32',5,'AGO CONSUMPTION 50L','967','','0000-00-00 00:00:00','975','2022-11-15 10:51:18'),(50,'1','292','2022-10-20',1,'21','','5',792510.00,'19','','','5','Aminu isah ','029309',792518.40,'2022-11-15 10:39:28',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 10:50:41'),(53,'1','292','2022-10-20',1,'21','','5',1078880.00,'20','','','5','Aminu ','029313',1094673.60,'2022-11-15 11:01:29',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 16:29:01'),(54,'1','292','2022-10-21',1,'22','','5',1136510.00,'21','','','5','Aminu isah','029312',1136511.00,'2022-11-15 11:03:51',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 16:30:28'),(55,'1','292','2022-10-21',1,'13','','2',15800.00,'20','','','','','',0.00,'2022-11-15 11:05:29',5,'AGO CONSUMPTION 20L','967','','0000-00-00 00:00:00','975','2022-11-15 16:30:28'),(56,'1','292','2022-10-22',1,'13','','5',1063500.00,'22','','','5','Aminu isah','029314',1087194.60,'2022-11-15 13:38:02',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 16:29:54'),(57,'1','292','2022-10-22',1,'12','','2',23700.00,'22','','','','','',0.00,'2022-11-15 13:40:49',5,'AGO CONSUMPTION 30L','967','','0000-00-00 00:00:00','975','2022-11-15 16:30:28'),(58,'1','292','2022-10-22',1,'23','','5',1510600.00,'23','','','5','Aminu isah ','029315',1510590.60,'2022-11-15 13:42:40',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 16:29:54'),(59,'1','292','2022-10-23',1,'23','','5',693440.00,'24','','','5','Aminu isah ','029316',717143.40,'2022-11-15 15:59:03',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 16:29:54'),(60,'1','292','2022-10-23',1,'11','','2',23700.00,'24','','','','','',0.00,'2022-11-15 16:21:35',5,'AGO CONSUMPTION 30L','967','','0000-00-00 00:00:00','975','2022-11-15 16:30:28'),(61,'1','292','2022-10-23',1,'23','','5',1128920.00,'25','','','5','Aminu Isah ','029317',1128922.20,'2022-11-15 16:23:20',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 16:29:54'),(62,'1','292','2022-10-24',1,'24','','5',1291355.00,'26','','','5','Aminu isah ','029263',1315054.80,'2022-11-15 16:25:23',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 16:29:54'),(63,'1','292','2022-10-24',1,'14','','2',23700.00,'26','','','','','',0.00,'2022-11-15 16:26:40',5,'AGO CONSUMPTION 30L','967','','0000-00-00 00:00:00','975','2022-11-15 16:30:28'),(64,'1','292','2022-10-24',1,'26','','5',1357690.00,'27','','','5','Aminu isah ','029262',1357691.40,'2022-11-15 16:28:47',5,'','967','','0000-00-00 00:00:00','975','2022-11-15 16:29:54'),(65,'1','292','2022-10-26',1,'24','','5',1115350.00,'28','','','5','Aminu isah ','029319',1139041.80,'2022-11-15 16:30:52',5,'','967','','0000-00-00 00:00:00','975','2022-11-17 16:48:11'),(66,'1','292','2022-10-26',1,'14','','2',23700.00,'28','','','','','',0.00,'2022-11-15 16:31:58',5,'AGO CONSUMPTION 30L','967','','0000-00-00 00:00:00','975','2022-11-17 16:48:11'),(67,'1','292','2022-10-26',1,'26','','5',927650.00,'29','','','5','Aminu isah ','029318',927468.00,'2022-11-15 16:33:44',5,'','967','','0000-00-00 00:00:00','975','2022-11-17 16:48:11'),(68,'1','292','2022-10-27',1,'26','','5',1673560.00,'30','','','5','Aminu isah ','029321',1697259.60,'2022-11-15 16:35:40',5,'','967','','0000-00-00 00:00:00','975','2022-11-17 16:49:19'),(69,'1','292','2022-10-27',1,'14','','2',23700.00,'30','','','','','',0.00,'2022-11-15 16:36:44',5,'AGO CONSUMPTION 30L','967','','0000-00-00 00:00:00','975','2022-11-17 16:49:19'),(70,'1','292','2022-10-27',1,'29','','5',1290345.00,'31','','','5','Aminu isah ','029320',1290524.40,'2022-11-15 16:38:14',5,'','967','','0000-00-00 00:00:00','975','2022-11-17 16:49:19'),(71,'1','292','2022-10-28',1,'29','','5',1494860.00,'32','','','5','Aminu isah ','029322',1537563.60,'2022-11-15 16:39:36',5,'','967','','0000-00-00 00:00:00','975','2022-12-06 13:37:15'),(72,'1','292','2022-10-28',1,'19','','2',23700.00,'32','','','','','',0.00,'2022-11-15 16:41:27',5,'AGO CONSUMPTION 30L','967','','0000-00-00 00:00:00','975','2022-11-17 16:49:19'),(73,'1','292','2022-10-11',1,'3','','2',60000.00,'9','','','','','',0.00,'2022-11-15 17:04:51',0,'AUTHORITY NOT PAID BY ALHAJI SANI HADEJA TO DPR ','967','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(74,'1','292','2022-10-12',1,'5','','2',50000.00,'10','','','','','',0.00,'2022-11-15 17:07:07',0,'AUTHORITY NOT PAID BY DIRECTOR ALHAJI SANI HADEJA TO DPR','967','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(75,'1','292','2022-10-26',1,'28','','5',1115350.00,'28','','','5','Aminu isah ','29319',1139041.80,'2022-11-15 17:21:14',5,'','967','','0000-00-00 00:00:00','975','2022-11-17 16:49:19'),(76,'1','292','2022-10-20',1,'01','','5',8000.00,'18','','','5','Aminu isah ','01',0.00,'2022-11-16 18:43:02',5,'Defund payment for Generator air filter\r\nPaid ','967','','0000-00-00 00:00:00','975','2022-12-06 13:37:15'),(77,'1','292','2022-10-28',1,'12','','2',19000.00,'32','','','','','',0.00,'2022-11-16 18:45:27',5,'TRANSPORT FOR OCTBER AND PURCHASE OF PRINTING PAPER ','967','','0000-00-00 00:00:00','975','2023-01-30 12:36:40'),(78,'1','292','2022-11-27',1,'23','','5',1263850.00,'34','','','5','Aminu isah ','029323',1288747.20,'2022-11-29 19:54:03',5,'','967','','0000-00-00 00:00:00','975','2022-12-06 13:37:15'),(79,'1','292','2022-11-27',1,'21','','2',24900.00,'34','','','','','',0.00,'2022-11-29 19:55:25',5,'AGO CONSUMPTION 30L','967','','0000-00-00 00:00:00','975','2022-12-06 12:10:30'),(80,'1','292','2022-11-27',1,'22','','5',1148920.00,'35','','','5','Aminu isah ','029265',1693398.00,'2022-11-29 20:01:54',5,'','967','','0000-00-00 00:00:00','975','2022-12-06 13:37:15'),(81,'1','292','2022-11-27',1,'18','','10',544475.00,'35','','','6','','26',0.00,'2022-11-29 20:03:06',5,'','967','','0000-00-00 00:00:00','975','2022-12-06 12:14:20'),(82,'1','292','2022-11-23',1,'22','','5',74760.00,'33','','','5','Aminu isah ','029264',74760.00,'2022-11-29 20:06:16',5,'','967','','0000-00-00 00:00:00','975','2022-12-06 13:37:15'),(83,'1','292','2022-11-28',1,'29','','5',1088680.00,'36','','','5','Aminu isah ','029266',1950324.80,'2022-11-30 11:46:39',5,'','967','','0000-00-00 00:00:00','975','2022-12-06 13:37:14'),(84,'1','292','2022-11-28',1,'23','','10',293095.00,'36','','','6','','23',0.00,'2022-11-30 11:47:38',5,'','967','','0000-00-00 00:00:00','975','2022-12-06 12:14:20'),(85,'1','292','2022-11-28',1,'12','','2',568550.00,'36','','','','','',0.00,'2022-11-30 11:49:57',5,'HAULLAGE TO TRUCK =RAN 690XA\r\n685L','967','','0000-00-00 00:00:00','975','2022-12-06 12:11:44'),(86,'1','292','2022-11-28',1,'28','','5',239510.00,'37','','','5','Aminu isah ','029268',257514.60,'2022-11-30 13:26:35',5,'','967','','0000-00-00 00:00:00','975','2022-12-06 13:37:14'),(87,'1','292','2022-11-28',1,'23','','2',18000.00,'37','','','','','',0.00,'2022-11-30 13:28:19',5,'FOOD PAYMENT TO DRIVER WITH RAN 690XA 18,000','967','','0000-00-00 00:00:00','975','2022-12-06 12:10:55'),(88,'1','292','2022-11-30',1,'23','','2',168000.00,'38','','','','','',183120.00,'2022-12-01 22:47:45',5,'HAULAGE OF 200L TO RAN 981 XA','967','','0000-00-00 00:00:00','975','2022-12-06 12:10:42'),(89,'1','292','2022-11-30',1,'12','','2',15000.00,'38','','','','','',0.00,'2022-12-01 22:49:43',5,'FOOD EXPENSES TO DRIVER WITH RAN 981 XA 15,000','967','','0000-00-00 00:00:00','975','2022-12-06 12:11:26'),(91,'1','292','2022-12-09',1,'21','','2',8400.00,'39','','','','','',0.00,'2022-12-09 20:55:05',5,'AGO CONSUMPTION 10L','967','','0000-00-00 00:00:00','975','2022-12-26 09:48:05'),(92,'1','292','2022-12-09',1,'21','','5',178500.00,'39','','','5','Aminu Isah ','029267',0.00,'2022-12-09 20:58:36',5,'DRIVER SHORT 850L@ rate 210','967','','0000-00-00 00:00:00','975','2022-12-21 10:47:03'),(93,'1','292','2022-12-18',1,'23','','2',16400.00,'40','','','','','',0.00,'2022-12-18 19:41:02',5,'AGO CONSUMPTION 20L','967','','0000-00-00 00:00:00','975','2022-12-26 09:48:17'),(94,'1','292','2022-12-18',1,'002','','5',63700.00,'40','','','5','AMINU ISAH','32',74620.00,'2022-12-18 19:45:54',5,'DIRECT TRANSFER TO BANK ','967','','0000-00-00 00:00:00','975','2022-12-26 09:49:21'),(95,'1','292','2022-12-23',1,'23','','5',95100.00,'41','','','5','AMINU ISAH ','030',95120.00,'2022-12-23 14:48:08',5,'','967','','0000-00-00 00:00:00','975','2022-12-29 16:19:23'),(96,'1','292','2022-12-23',1,'24','','5',122200.00,'42','','','5','AMINU ISAH ','031',122180.00,'2022-12-23 14:49:24',5,'','967','','0000-00-00 00:00:00','975','2022-12-29 16:19:23'),(97,'1','292','2022-12-23',1,'24','','5',139400.00,'43','','','5','AMINU ISAH ','032',139400.00,'2022-12-23 14:50:19',5,'','967','','0000-00-00 00:00:00','975','2022-12-29 16:19:23'),(98,'1','292','2022-12-25',1,'023','','2',681420.00,'44','','','','','',681420.00,'2022-12-25 05:39:28',5,'HAULLAGE TO TRN31 ZY 831L price @820 per litre ','967','','0000-00-00 00:00:00','975','2022-12-29 16:19:23'),(99,'1','292','2022-12-26',1,'035','','2',763420.00,'45','','','','','',788020.00,'2022-12-26 08:26:59',5,'HAULLAGE TO FGE 986 ZY 931L WITH FOOD EXPENSES PRICE OF AGO 820per LITRE ','967','','0000-00-00 00:00:00','975','2022-12-29 16:19:23'),(100,'1','292','2022-12-26',1,'036','','2',24600.00,'45','','','','','',0.00,'2022-12-26 08:28:34',5,'AGO CONSUMPTION 30L','967','','0000-00-00 00:00:00','975','2022-12-29 16:19:23'),(101,'1','292','2023-01-06',1,'025','','5',139400.00,'46','','','5','AMINU ISAH ','38',139400.00,'2023-01-06 12:34:37',5,'','967','','0000-00-00 00:00:00','975','2023-01-11 14:07:03'),(102,'1','292','2023-01-11',1,'025','','5',90200.00,'47','','','5','AMINU ISAH ','055',90200.00,'2023-01-11 19:34:13',5,'','967','','0000-00-00 00:00:00','975','2023-01-20 11:26:43'),(103,'1','292','2023-01-13',1,'026','','5',70500.00,'48','','','5','AMINU ISAH ','035',86920.00,'2023-01-13 22:01:14',5,'','967','','0000-00-00 00:00:00','975','2023-01-20 11:26:43'),(104,'1','292','2023-01-13',1,'027','','2',16400.00,'48','','','','','',0.00,'2023-01-13 22:02:15',5,'AGO 20L','967','','0000-00-00 00:00:00','975','2023-01-30 12:36:40'),(105,'1','292','2023-01-18',1,'026','','5',64000.00,'49','','','5','AMINU ISAH ','040',63960.00,'2023-01-18 23:40:22',5,'','967','','0000-00-00 00:00:00','975','2023-01-20 11:26:43'),(106,'1','292','2023-01-23',1,'030','','5',239000.00,'50','','','5','AMINU ISAH ','045',239040.00,'2023-01-23 11:39:44',5,'','967','','0000-00-00 00:00:00','975','2023-01-25 11:49:20'),(107,'1','292','2023-02-03',1,'046','','5',133050.00,'51','','','5','AMINU ISAH ','046',1065973.60,'2023-02-03 11:46:40',5,'','967','','0000-00-00 00:00:00','975','2023-02-13 11:28:20'),(108,'1','292','2023-02-03',1,'036','','10',853919.00,'51','','','6','Aminu isah ','036',0.00,'2023-02-03 11:48:04',5,'','967','','0000-00-00 00:00:00','975','2023-02-13 11:29:08'),(109,'1','292','2023-02-03',1,'025','','2',79000.00,'51','','','','','',0.00,'2023-02-03 11:48:59',5,'AGO CONSUMPTION 100L','967','','0000-00-00 00:00:00','975','2023-02-13 11:29:07'),(110,'1','292','2023-02-07',1,'045','','5',32420.00,'53','','','5','AMINU ISAH ','047',1052952.00,'2023-02-07 12:36:10',5,'','967','','0000-00-00 00:00:00','975','2023-02-13 11:29:07'),(111,'1','292','2023-02-07',1,'046','','10',951550.00,'53','','','6','Aminu isah ','048',0.00,'2023-02-07 12:37:21',5,'','967','','0000-00-00 00:00:00','975','2023-02-13 11:29:07'),(112,'1','292','2023-02-07',1,'049','','5',27080.00,'54','','','5','AMINU ISAH ','049',362446.15,'2023-02-07 12:39:54',5,'','967','','0000-00-00 00:00:00','975','2023-02-13 11:29:07'),(113,'1','292','2023-02-07',1,'050','','10',264420.00,'54','','','6','AMINU ISAH ','050',362446.15,'2023-02-07 12:41:50',5,'','967','','0000-00-00 00:00:00','975','2023-02-13 11:29:07'),(114,'1','292','2023-02-07',1,'051','','5',28915.00,'55','','','5','AMINU ISAH ','051',447535.50,'2023-02-07 12:43:26',5,'','967','','0000-00-00 00:00:00','975','2023-02-13 11:29:07'),(115,'1','292','2023-02-07',1,'052','','10',418620.00,'55','','','6','AMINU ISAH','052',447535.50,'2023-02-07 12:44:53',5,'','967','','0000-00-00 00:00:00','975','2023-02-13 11:29:07'),(116,'1','292','2023-02-07',1,'052','','5',40064.00,'56','','','5','AMINU ISAH ','053',888609.40,'2023-02-07 12:46:02',0,'','967','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(117,'1','292','2023-02-07',1,'053','','10',848544.00,'56','','','','AMINU ','',0.00,'2023-02-07 12:46:56',0,'','967','975','2023-02-13 16:15:28','','0000-00-00 00:00:00'),(118,'1','292','2023-02-16',1,'045','','10',950759.00,'57','','','6','AMINU ISAH','060',950767.45,'2023-02-16 18:20:13',0,'','967','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(119,'1','292','2023-02-17',1,'050','','10',1038514.00,'58','','','6','AMINU ISAH','061',1119499.25,'2023-02-17 13:41:27',0,'','967','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(120,'1','292','2023-02-17',1,'055','','2',81000.00,'58','','','','','',0.00,'2023-02-17 13:42:41',0,'AGO CONSUMPTION 100L@810','967','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(121,'1','292','2023-02-18',1,'055','','5',51250.00,'59','','','5','AMINU ISAH ','65',0.00,'2023-02-18 17:43:49',0,'DRIVER SHORT 250L@205\r\nTRANSFER TO COMPANY ACCOUNT ','967','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(122,'1','292','2023-02-18',1,'066','','10',1049265.00,'59','','','6','AMINU ISAH ','065',1099704.05,'2023-02-18 18:16:00',0,'','967','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(123,'1','292','2023-02-19',1,'065','','10',890433.00,'60','','','6','AMINU ISAH ','067',941673.65,'2023-02-19 18:13:41',0,'','967','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(124,'1','292','2023-02-20',1,'65','','10',1069190.00,'61','','','6','AMINU ISAH','068',1069187.75,'2023-02-20 16:39:53',0,'','967','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(125,'1','292','2023-02-21',1,'067','','10',1115945.00,'62','','','6','AMINU ISAH','069',1111743.70,'2023-02-21 17:18:52',0,'','967','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(126,'1','292','2023-02-25',1,'067','','5',150000.00,'53/54','','','5','AMINU ISAH','070',68982.00,'2023-02-25 08:33:08',0,'','967','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(127,'1','292','2023-02-19',1,'068','','5',46300.00,'59','','','5','AMINU ISAH ','071',0.00,'2023-02-28 18:48:23',0,'TRANSFERED ON 28TH FEBRUARY','967','975','2023-03-01 13:58:59','','0000-00-00 00:00:00'),(128,'1','292','2023-03-03',1,'065','','10',505208.00,'63','','','6','AMINU ISAH','072',586205.35,'2023-03-03 17:22:47',0,'','967','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(129,'1','292','2023-03-03',1,'065','','2',81000.00,'63','','','','','',0.00,'2023-03-03 17:23:49',0,'AGO CONSUMPTION 100L@810perL','967','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(130,'1','292','2023-03-04',1,'076','','10',1504545.00,'64','','','6','AMINU ISAH','078',1504474.70,'2023-03-04 16:23:01',0,'','967','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(131,'1','292','2023-03-05',1,'067','','10',2641971.00,'65','','','6','AMINU ISAH','079',2641971.05,'2023-03-09 16:51:51',0,'','967','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(132,'1','292','2023-03-06',1,'069','','10',2142755.00,'67','','','6','Aminu isah','080',2232462.40,'2023-03-09 16:54:19',0,'','967','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(133,'1','292','2023-03-06',1,'071','','5',89700.00,'67','','','5','Aminu isah','081',0.00,'2023-03-09 16:56:09',0,'TRANSFER TO COMPANY ACCOUNT ','967','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(134,'1','292','2023-03-07',1,'072','','10',3410172.00,'68','','','6','AMINU ISAH','082',3513851.80,'2023-03-09 16:58:24',0,'','967','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(135,'1','292','2023-03-07',1,'082','','2',81000.00,'68','','','','','',0.00,'2023-03-09 17:02:10',0,'DIESEL 100L@810','967','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(136,'1','292','2023-03-07',1,'073','','5',22680.00,'68','','','5','AMINU ISAH','083',0.00,'2023-03-09 17:04:35',0,'','967','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(137,'1','292','2023-03-08',1,'074','','10',2206130.00,'69/70','','','','AMINU ISAH','',2206128.30,'2023-03-09 17:07:35',0,'','967','975','2023-03-14 13:59:07','','0000-00-00 00:00:00'),(138,'1','292','2023-03-09',1,'075','','5',112800.00,'70','','','5','AMINU ISAH','085',0.00,'2023-03-09 17:34:03',0,'DRIVER SHORT FOR 480L@235','967','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(139,'1','292','2023-03-09',1,'077','','10',2105672.00,'71','','','6','AMINU ISAH','086',2105672.85,'2023-03-10 09:55:44',0,'','967','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(140,'1','292','2023-03-10',1,'077','','10',2796724.00,'72/73','','','','AMINU ISAH','',2796730.00,'2023-03-10 22:02:41',0,'','967','975','2023-03-14 13:47:33','','0000-00-00 00:00:00'),(141,'1','292','2023-03-11',1,'078','','10',3196077.00,'74','','','6','AMINU ISAH','090',3196070.50,'2023-03-11 22:28:51',0,'','967','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(142,'1','292','2023-03-12',1,'089','','10',2812860.00,'75/76','','','','AMINU ISAH','',2943723.10,'2023-03-12 23:38:17',0,'','967','975','2023-03-14 13:51:25','','0000-00-00 00:00:00'),(143,'1','292','2023-03-12',1,'079','','2',121500.00,'76','','','','','',0.00,'2023-03-12 23:39:34',0,'AGO CONSUMPTION 150L@810','967','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(144,'1','292','2023-03-13',1,'081','','10',1062375.00,'77/78','','','6','AMINU ISAH','091',1530733.60,'2023-03-14 19:37:48',0,'','967','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(145,'1','292','2023-03-13',1,'085','','5',1956500.00,'77/78','','','5','AMINU ISAH','087',1750700.65,'2023-03-16 13:54:43',0,'This payment was made on 16 of March     It’s the complete payment of on 13 of March ','967','975','2023-03-17 16:51:10','','0000-00-00 00:00:00'),(146,'1','292','2023-03-14',1,'087','','5',1905727.00,'79/80','','','6','AMINU ISAH','088',2760765.90,'2023-03-16 14:02:21',0,'','967','975','2023-03-17 16:55:08','','0000-00-00 00:00:00'),(147,'1','292','2023-03-15',1,'088','','5',2697730.00,'81/82','','','6','AMINU ISAH','089',2697736.55,'2023-03-16 14:24:01',0,'','967','975','2023-03-17 16:57:22','','0000-00-00 00:00:00'),(148,'1','292','2023-03-16',1,'087','','10',1218193.00,'83','','','6','AMINU ISAH','092',1690202.25,'2023-03-17 14:09:18',0,'','967','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(149,'1','292','2023-03-10',1,'086','','2',16000.00,'72','','','','','',0.00,'2023-03-18 13:11:25',0,'PURCHASED OF POS PAPER ON 10/03/23 BUT I FORGOT TO ADD IT IN MY RECONCILIATION PROCESS ','967','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(150,'1','292','2023-03-17',1,'087','','10',2322075.00,'84/85','','','6','AMINU ISAH','093',2306346.40,'2023-03-18 13:14:11',0,'','967','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(151,'1','292','2023-03-17',1,'085','','2',16000.00,'85','','','','','',0.00,'2023-03-18 13:15:40',0,'PURCHASED OF POS PAPER ON 17/03/2023@16,000','967','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `purchases_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_receptions`
--

DROP TABLE IF EXISTS `purchases_receptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_receptions` (
  `bridge_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `purchase_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `loadingdate` datetime NOT NULL,
  `loadingpoint` varchar(100) DEFAULT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `received` decimal(20,2) NOT NULL,
  `distributed` decimal(20,2) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `vessel` varchar(50) NOT NULL,
  `drivername` varchar(30) NOT NULL,
  `driverphone` varchar(30) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`bridge_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`supplier_id`,`loadingdate`,`quantity`,`waybill`,`meterno`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`purchase_id`),
  KEY `truck_id` (`tank_id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_receptions`
--

LOCK TABLES `purchases_receptions` WRITE;
/*!40000 ALTER TABLE `purchases_receptions` DISABLE KEYS */;
INSERT INTO `purchases_receptions` VALUES (1,'1',7,'292',1,1,'2022-12-09 00:00:00',NULL,850.00,0.00,0.00,'001','','','RAN 690 XA','','','Distributed to DRIVER\'S SHORT for sale #1',10,'2022-12-09 19:00:42','967','0000-00-00 00:00:00','','2022-12-09 19:00:42','967'),(2,'1',3,'292',1,1,'2022-12-09 00:00:00',NULL,800.00,0.00,0.00,'01908','','','RAN849XA ','','','Distributed to DRIVER\'S SHORT for sale #2',10,'2022-12-09 19:06:51','967','0000-00-00 00:00:00','','2022-12-09 19:06:51','967'),(3,'1',1,'292',1,1,'2023-02-11 00:00:00','LAGOS',17000.00,16550.00,0.00,'0137463','','1','NSR856ZQ ','AHMAD ','07063913031','',5,'2023-02-11 07:31:34','967','0000-00-00 00:00:00','','2023-02-11 07:53:25','967'),(4,'1',1,'292',1,1,'2023-02-11 00:00:00','LAGOS',17000.00,16500.00,0.00,'0137463','','2','NSR856ZQ ','AHMAD ','07063913031','',5,'2023-02-11 07:31:34','967','0000-00-00 00:00:00','','2023-02-11 07:53:25','967'),(5,'1',1,'292',1,1,'2023-02-11 00:00:00','LAGOS',16000.00,15500.00,0.00,'0137463','','3','NSR856ZQ ','AHMAD ','07063913031','',5,'2023-02-11 07:31:34','967','0000-00-00 00:00:00','','2023-02-11 07:53:25','967'),(6,'1',2,'292',1,1,'2023-02-11 00:00:00','LAGOS',15000.00,15000.00,0.00,'0138','','1','EKY96XY ','UMAR','08039158722','',5,'2023-02-11 07:41:01','967','0000-00-00 00:00:00','','2023-02-11 07:53:53','967'),(7,'1',2,'292',1,1,'2023-02-11 00:00:00','LAGOS',15000.00,15000.00,0.00,'0138','','2','EKY96XY ','UMAR','08039158722','',5,'2023-02-11 07:41:01','967','0000-00-00 00:00:00','','2023-02-11 07:53:53','967'),(8,'1',2,'292',1,1,'2023-02-11 00:00:00','LAGOS',15000.00,14850.00,0.00,'0138','','3','EKY96XY ','UMAR','08039158722','',2,'2023-02-11 07:41:01','967','2023-02-13 06:31:09','967','2023-02-11 07:53:52','967'),(9,'1',4,'292',1,1,'2023-02-11 00:00:00','LAGOS',33000.00,32700.00,0.00,'06231','','1','BCH 994XA ','AMMAR','08135106092','RECEIVED ',5,'2023-02-11 07:50:46','967','0000-00-00 00:00:00','','2023-02-11 07:54:47','967'),(10,'1',4,'292',1,1,'2023-02-11 00:00:00','LAGOS',17000.00,16500.00,0.00,'06231','','3','BCH 994XA ','AMMAR','08135106092','RECEIVED ',5,'2023-02-11 07:50:46','967','0000-00-00 00:00:00','','2023-02-11 07:54:47','967'),(11,'1',5,'292',2,1,'2023-02-11 00:00:00','LAGOS ',30000.00,30000.00,0.00,'0272164','','4','KMC693ZE ','KABIRU ','08033728479','RECEIVED ',5,'2023-02-11 07:58:19','967','0000-00-00 00:00:00','','2023-02-11 07:58:35','967'),(12,'1',8,'292',1,1,'2023-02-11 00:00:00','LAGOS ',17000.00,17000.00,0.00,'005','','1','RAN 426 XA','KABIRU SAID ','07064458804','RECEIVED ',5,'2023-02-11 08:01:26','967','0000-00-00 00:00:00','','2023-02-11 08:01:43','967'),(13,'1',7,'292',1,1,'2023-02-11 00:00:00','LAGOS ',22500.00,21650.00,0.00,'001','','2','RAN 690 XA','USMAN','08062587683','RECEIVED ',5,'2023-02-11 08:05:49','967','0000-00-00 00:00:00','','2023-02-11 08:06:08','967'),(14,'1',3,'292',1,1,'2023-02-11 00:00:00','LAGOS ',33000.00,32200.00,0.00,'01908','','1','RAN849XA ','AMMAR ','09164644145','RECEIVED ',5,'2023-02-11 08:12:38','967','0000-00-00 00:00:00','','2023-02-11 08:13:00','967'),(15,'1',3,'292',1,1,'2023-02-11 00:00:00','LAGOS ',17000.00,17000.00,0.00,'01908','','3','RAN849XA ','AMMAR ','09164644145','RECEIVED ',5,'2023-02-11 08:12:38','967','0000-00-00 00:00:00','','2023-02-11 08:13:00','967'),(16,'1',2,'292',1,1,'2023-02-13 00:00:00','LAGOS ',15000.00,14850.00,0.00,'0138','','2','EKY96XY ','UMAR','08039158722','RECEIVED ',5,'2023-02-13 06:37:52','967','0000-00-00 00:00:00','','2023-02-13 06:38:40','967'),(17,'1',9,'292',1,1,'2023-02-16 00:00:00','LAGOS',30000.00,29750.00,0.00,'006','','3','KMC 663 ZE','Ibrahim Muhammad ','08058404721','RECEIVED ',5,'2023-02-16 18:16:01','967','0000-00-00 00:00:00','','2023-02-16 18:16:15','967'),(18,'1',10,'292',1,1,'2023-03-03 00:00:00','LAGOS',16500.00,16500.00,0.00,'007','','3','FGC 982 ZY','ABUBAKAR ','08068645409','RECEIVED ',5,'2023-03-03 17:16:50','967','0000-00-00 00:00:00','','2023-03-03 17:17:19','967'),(19,'1',11,'292',1,1,'2023-03-08 00:00:00','LAGOS ',15000.00,14800.00,0.00,'008','','1','NSR515ZU','MUBARAK ','08062795955','Received ',2,'2023-03-08 23:23:27','967','2023-03-10 20:38:35','967','2023-03-08 23:24:14','967'),(20,'1',11,'292',1,1,'2023-03-08 00:00:00','LAGOS ',30000.00,29750.00,0.00,'008','','2','NSR515ZU','MUBARAK ','08062795955','Received ',5,'2023-03-08 23:23:27','967','0000-00-00 00:00:00','','2023-03-08 23:24:14','967'),(22,'1',12,'292',1,1,'2023-03-09 00:00:00','LAGOS ',26500.00,28100.00,0.00,'009','','1','KMC654ZE','HARISU','08066122241','Received ',5,'2023-03-09 16:43:59','967','0000-00-00 00:00:00','','2023-03-09 16:44:46','967'),(23,'1',12,'292',1,1,'2023-03-09 00:00:00','LAGOS ',3500.00,3500.00,0.00,'009','','2','KMC654ZE','HARISU','08066122241','Received ',5,'2023-03-09 16:43:59','967','0000-00-00 00:00:00','','2023-03-09 16:44:46','967'),(24,'1',12,'292',1,1,'2023-03-09 00:00:00','LAGOS ',30000.00,34750.00,0.00,'009','','3','KMC654ZE','HARISU','08066122241','Received ',5,'2023-03-09 16:43:59','967','0000-00-00 00:00:00','','2023-03-09 16:44:46','967'),(25,'1',11,'292',1,1,'2023-03-10 00:00:00','LAGOS',14520.00,14520.00,0.00,'008','','1','NSR515ZU','MUBARAK','08062795955','RECIEVED',2,'2023-03-10 20:43:13','967','2023-03-10 20:47:00','967','2023-03-10 20:43:50','967'),(26,'1',11,'292',1,1,'2023-03-10 00:00:00','LAGOS',14520.00,14520.00,0.00,'008','','1','NSR515ZU','MUBARAK','08062795955','RECIEVED',5,'2023-03-10 20:51:16','967','0000-00-00 00:00:00','','2023-03-10 20:51:57','967'),(27,'1',11,'292',1,1,'2023-03-12 00:00:00','LAGOS ',480.00,480.00,0.00,'008','','1','NSR515ZU','MUBARAK ','08062795955','Received ',5,'2023-03-12 13:48:56','967','0000-00-00 00:00:00','','2023-03-12 13:49:26','967'),(28,'1',13,'292',1,1,'2023-03-13 00:00:00','LAGOS ',30000.00,30000.00,0.00,'010','','1','TRN34YZ','Nura','07030171770','Received ',5,'2023-03-13 20:56:20','967','0000-00-00 00:00:00','','2023-03-13 20:56:43','967'),(29,'1',13,'292',1,1,'2023-03-13 00:00:00','LAGOS ',30000.00,30000.00,0.00,'010','','2','TRN34YZ','Nura','07030171770','Received ',5,'2023-03-13 20:56:20','967','0000-00-00 00:00:00','','2023-03-13 20:56:43','967');
/*!40000 ALTER TABLE `purchases_receptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports`
--

DROP TABLE IF EXISTS `reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `type` varchar(20) NOT NULL,
  `sql` text NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`report_id`),
  KEY `companycode` (`company_id`,`name`,`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports`
--

LOCK TABLES `reports` WRITE;
/*!40000 ALTER TABLE `reports` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_fields`
--

DROP TABLE IF EXISTS `reports_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(20) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `fieldname` varchar(50) NOT NULL,
  `order` int NOT NULL,
  `visibility` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`report_id`,`field_id`,`order`,`visibility`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_fields`
--

LOCK TABLES `reports_fields` WRITE;
/*!40000 ALTER TABLE `reports_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_filters`
--

DROP TABLE IF EXISTS `reports_filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_filters` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(50) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `filter_id` int NOT NULL AUTO_INCREMENT,
  `criteria` varchar(20) NOT NULL,
  `value` varchar(100) NOT NULL,
  PRIMARY KEY (`filter_id`),
  KEY `companycode` (`company_id`,`report_id`),
  KEY `field_id` (`field_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_filters`
--

LOCK TABLES `reports_filters` WRITE;
/*!40000 ALTER TABLE `reports_filters` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_filters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_customers`
--

DROP TABLE IF EXISTS `retail_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_customers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`name`,`phone`,`email`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_customers`
--

LOCK TABLES `retail_customers` WRITE;
/*!40000 ALTER TABLE `retail_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory`
--

DROP TABLE IF EXISTS `retail_inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` int NOT NULL,
  `qtyout` int NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory`
--

LOCK TABLES `retail_inventory` WRITE;
/*!40000 ALTER TABLE `retail_inventory` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_balances`
--

DROP TABLE IF EXISTS `retail_inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_balances`
--

LOCK TABLES `retail_inventory_balances` WRITE;
/*!40000 ALTER TABLE `retail_inventory_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_costs`
--

DROP TABLE IF EXISTS `retail_inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_costs`
--

LOCK TABLES `retail_inventory_costs` WRITE;
/*!40000 ALTER TABLE `retail_inventory_costs` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products`
--

DROP TABLE IF EXISTS `retail_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`name`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `parent_id` (`parent_id`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products`
--

LOCK TABLES `retail_products` WRITE;
/*!40000 ALTER TABLE `retail_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_prices`
--

DROP TABLE IF EXISTS `retail_products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_prices`
--

LOCK TABLES `retail_products_prices` WRITE;
/*!40000 ALTER TABLE `retail_products_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_reconciliations`
--

DROP TABLE IF EXISTS `retail_products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_reconciliations`
--

LOCK TABLES `retail_products_reconciliations` WRITE;
/*!40000 ALTER TABLE `retail_products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_purchases`
--

DROP TABLE IF EXISTS `retail_purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_purchases`
--

LOCK TABLES `retail_purchases` WRITE;
/*!40000 ALTER TABLE `retail_purchases` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales`
--

DROP TABLE IF EXISTS `retail_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `saledate` date NOT NULL,
  `customer_id` varchar(20) NOT NULL DEFAULT '',
  `customer_name` varchar(50) NOT NULL,
  `customer_phone` varchar(30) NOT NULL,
  `quantity_kg` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `payment_method` varchar(10) NOT NULL,
  `payment_account_type` varchar(20) NOT NULL,
  `payment_account_id` varchar(20) NOT NULL,
  `paid` decimal(20,2) DEFAULT NULL,
  `change` decimal(20,2) DEFAULT '0.00',
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`customer_name`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `payment_method` (`payment_method`,`payment_account_type`,`payment_account_id`),
  KEY `customer_id` (`customer_id`),
  KEY `change` (`change`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales`
--

LOCK TABLES `retail_sales` WRITE;
/*!40000 ALTER TABLE `retail_sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_items`
--

DROP TABLE IF EXISTS `retail_sales_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `product_type` varchar(10) NOT NULL,
  `product_name` varchar(100) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `quantity_2` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `parent_cost` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`sale_id`,`product_id`,`rate`,`quantity`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`product_type`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `parent_id` (`parent_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_items`
--

LOCK TABLES `retail_sales_items` WRITE;
/*!40000 ALTER TABLE `retail_sales_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_payments`
--

DROP TABLE IF EXISTS `retail_sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_payments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `payment_method` varchar(50) NOT NULL,
  `account_type` varchar(10) DEFAULT NULL,
  `account_id` bigint DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`sale_id`,`payment_method`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`account_type`),
  KEY `parent_id` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_payments`
--

LOCK TABLES `retail_sales_payments` WRITE;
/*!40000 ALTER TABLE `retail_sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales`
--

DROP TABLE IF EXISTS `sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `is_credit` int NOT NULL DEFAULT '0',
  `saledate` date NOT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `paid` int NOT NULL,
  `details` text NOT NULL,
  `ledger_notes` varchar(150) DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`product_id`,`customer_id`,`rate`,`quantity`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`is_credit`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales`
--

LOCK TABLES `sales` WRITE;
/*!40000 ALTER TABLE `sales` DISABLE KEYS */;
INSERT INTO `sales` VALUES (1,'1','292','39',0,'2022-11-27',1,1,210.00,210.00,850.00,0.00,0.00,178500.00,'001','2022-12-09 18:43:02',15,0,'DRIVER SHORTAGE OF 850',NULL,'967','','0000-00-00 00:00:00','967','2022-12-09 18:44:20'),(2,'1','292','39',0,'2022-10-13',1,1,210.00,180.00,800.00,0.00,0.00,144000.00,'002','2022-12-09 19:02:50',15,0,'',NULL,'967','','0000-00-00 00:00:00','967','2022-12-09 19:04:43'),(3,'1','292','60',0,'2023-02-15',1,1,205.00,205.00,250.00,0.00,0.00,51250.00,'0','2023-02-19 15:52:51',15,0,'',NULL,'967','','0000-00-00 00:00:00','967','2023-02-19 15:53:43'),(4,'1','292','71',0,'2023-03-08',1,1,235.00,235.00,480.00,0.00,0.00,112800.00,'03100944','2023-03-10 09:45:44',0,0,'',NULL,'967','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_daily`
--

DROP TABLE IF EXISTS `sales_daily`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_daily` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `saledate` date NOT NULL,
  `average` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `target` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`average`,`saledate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_daily`
--

LOCK TABLES `sales_daily` WRITE;
/*!40000 ALTER TABLE `sales_daily` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_daily` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions`
--

DROP TABLE IF EXISTS `sales_distributions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions` (
  `distribution_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `sale_id` int NOT NULL,
  `purchase_id` varchar(20) NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `loadingdate` date NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `destination` varchar(50) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `truckno` varchar(20) NOT NULL,
  `drivername` varchar(50) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`distribution_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`loadingdate`,`quantity`,`destination`,`waybill`,`meterno`,`nozzle_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`tank_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `truckno` (`truckno`),
  KEY `purchase_id_2` (`purchase_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions`
--

LOCK TABLES `sales_distributions` WRITE;
/*!40000 ALTER TABLE `sales_distributions` DISABLE KEYS */;
INSERT INTO `sales_distributions` VALUES (2,'1',1,'7',1,'292',1,1,'2022-12-09',850.00,'DRIVER SHORT','001','','','','RAN 690 XA','','BULK SALES',5,'2022-12-09 18:58:19','967','0000-00-00 00:00:00','','2022-12-09 19:00:42','967'),(3,'1',2,'3',2,'292',1,1,'2022-12-09',800.00,'DRIVER SHORT ','01908','','','','RAN849XA ','','BULK SALES',5,'2022-12-09 19:06:08','967','0000-00-00 00:00:00','','2022-12-09 19:06:51','967'),(4,'1',3,'',0,'292',1,1,'2023-02-15',250.00,'DRIVER SHORT','006','','3','7','','','BULK SALES',5,'2023-02-19 16:02:28','967','0000-00-00 00:00:00','','2023-02-19 16:02:53','967');
/*!40000 ALTER TABLE `sales_distributions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_delivery`
--

DROP TABLE IF EXISTS `sales_distributions_delivery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_delivery` (
  `delivery_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `distribution_id` int NOT NULL,
  `sale_id` int NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `quantity` int NOT NULL,
  `truck_id` int NOT NULL,
  `deliveredon` date NOT NULL,
  `details` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`delivery_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`quantity`,`thedate`,`createdby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`truck_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `distribution_id` (`distribution_id`),
  KEY `deliveredon` (`deliveredon`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_delivery`
--

LOCK TABLES `sales_distributions_delivery` WRITE;
/*!40000 ALTER TABLE `sales_distributions_delivery` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_delivery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_trucks`
--

DROP TABLE IF EXISTS `sales_distributions_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_trucks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sale_id` varchar(20) NOT NULL,
  `distribution_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `bridge_id` varchar(20) NOT NULL,
  `truck_id` varchar(20) NOT NULL,
  `driver_id` varchar(20) NOT NULL,
  `quantity` int NOT NULL,
  `destination` varchar(150) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `companycode` (`company_id`,`distribution_id`,`truck_id`),
  KEY `sale_id` (`sale_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_trucks`
--

LOCK TABLES `sales_distributions_trucks` WRITE;
/*!40000 ALTER TABLE `sales_distributions_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_fueltickets`
--

DROP TABLE IF EXISTS `sales_fueltickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_fueltickets` (
  `ticket_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `ticketdate` date NOT NULL,
  `code` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `allowance` decimal(10,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `truck_number` varchar(20) NOT NULL,
  `truck_capacity` int NOT NULL,
  `truck_provider` varchar(50) NOT NULL,
  `truck_from` varchar(50) NOT NULL,
  `truck_destination` varchar(50) NOT NULL,
  `driver_name` varchar(50) NOT NULL,
  `driver_phone` varchar(50) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`ticket_id`),
  KEY `companycode` (`company_id`,`ticketdate`,`product_id`,`truck_number`,`rate`,`quantity`,`status`),
  KEY `paid` (`truck_provider`),
  KEY `invoice` (`code`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_fueltickets`
--

LOCK TABLES `sales_fueltickets` WRITE;
/*!40000 ALTER TABLE `sales_fueltickets` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_fueltickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_payments`
--

DROP TABLE IF EXISTS `sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `customer_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`customer_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_payments`
--

LOCK TABLES `sales_payments` WRITE;
/*!40000 ALTER TABLE `sales_payments` DISABLE KEYS */;
INSERT INTO `sales_payments` VALUES (1,'1','292','2022-10-13',1,'01','','5',144000.00,'01','','','5','Aminu Isah ','1','2022-12-01 22:54:35',0,'DRIVER SHORTAGE OF 800LITRES RATE AT 180 PER LITRES','967','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(2,'1','292','2022-11-27',1,'02','','5',178500.00,'002','','','5','AMINU ISAH','029267','2022-12-10 00:01:11',0,'DRIVER SHORT OF 850L@210per litre ','967','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(3,'1','292','2023-02-18',1,'006','','5',51250.00,'006','','','5','AMINU ISAH ','061','2023-02-18 17:50:39',0,'DRIVER SHORT 250L','967','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(4,'1','292','2023-03-09',1,'076','','5',112800.00,'03100944','','','5','AMINU ISAH','085','2023-03-10 09:50:41',0,'DRIVER SHORT 480L @235per L','967','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_cashbacks`
--

DROP TABLE IF EXISTS `shifts_cashbacks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_cashbacks` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `regno` varchar(100) DEFAULT NULL,
  `cashdate` date NOT NULL,
  `driver` varchar(100) DEFAULT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`cashdate`,`driver`,`customer_id`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`regno`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_cashbacks`
--

LOCK TABLES `shifts_cashbacks` WRITE;
/*!40000 ALTER TABLE `shifts_cashbacks` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_cashbacks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_remittance`
--

DROP TABLE IF EXISTS `shifts_remittance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_remittance` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `paymentdate` date NOT NULL,
  `method` int DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paidby` varchar(50) DEFAULT NULL,
  `paidto` varchar(100) DEFAULT NULL,
  `bank` bigint unsigned DEFAULT NULL,
  `depositor` varchar(100) DEFAULT NULL,
  `teller` varchar(100) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  `reversed_at` datetime DEFAULT NULL,
  `reversed_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`paymentdate`,`method`,`bank`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_remittance`
--

LOCK TABLES `shifts_remittance` WRITE;
/*!40000 ALTER TABLE `shifts_remittance` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_remittance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers`
--

DROP TABLE IF EXISTS `suppliers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers` (
  `supplier_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`supplier_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers`
--

LOCK TABLES `suppliers` WRITE;
/*!40000 ALTER TABLE `suppliers` DISABLE KEYS */;
INSERT INTO `suppliers` VALUES (1,'1','292','AA RANO NIGERIA LTD','MUHAMMAD ABDUL SULE','0803540199','mrmohasul@gmail.com','KANO','KANO','No 7 Maiduguri Road,Opposite NNPC Depot. Kano Nigeria','Nigeria',0.00,0.00,'0000-00-00','2022-10-18 17:05:14',5,'178','2022-10-18 17:05:14','178');
/*!40000 ALTER TABLE `suppliers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers_status`
--

DROP TABLE IF EXISTS `suppliers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `supplier_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers_status`
--

LOCK TABLES `suppliers_status` WRITE;
/*!40000 ALTER TABLE `suppliers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `suppliers_status` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-03-21  2:54:23
