-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_291
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_291`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_291` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_291`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,500,'',0,'6.1','1','291','CASH','','2022-10-18 17:11:27',5,0.00,0.00,'','178','2022-10-18 17:11:27','178',0,0),(2,8000,'',0,'24','1','291','PURCHASES','','2022-10-18 17:11:35',5,0.00,0.00,'','178','2022-10-18 17:11:35','178',0,0),(3,8001,'',0,'24','1','291','SALARIES','','2022-10-18 17:11:52',5,0.00,0.00,'','178','2022-10-18 17:11:52','178',0,0),(4,7000,'',0,'20','1','291','SALES','','2022-10-18 17:12:12',5,0.00,0.00,'','178','2022-10-18 17:12:12','178',0,0),(5,2500,'',0,'2','1','291','ZNB 1014717261','','2023-01-18 12:08:38',5,0.00,0.00,'','975','2023-01-18 12:08:38','975',0,0),(6,2501,'',0,'2','1','291','UBA POS','','2023-01-18 12:08:49',5,0.00,0.00,'','975','2023-01-18 12:08:49','975',0,0),(7,2502,'',0,'2','1','291','ZNB 1017823161','','2023-01-19 16:28:16',5,0.00,0.00,'','975','2023-01-19 16:28:16','975',0,0),(8,2503,'',0,'2','1','291','UBA 1022237740','','2023-03-16 12:52:47',5,0.00,0.00,'','975','2023-03-16 12:52:47','975',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','1','291','NIGERIA POLICE FORCE (ELECTION','HILLARY','08024230804','dopstransport@gmail.come','CALABAR','CROSS REVER','CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-21 17:10:13',5,'975','2023-02-21 17:10:13','975'),(2,'','1','291','DRIVER SHORTAGE','UMAR TRANSPORT','08030647174','@gmail.come','KANO','KANO','HEAD OFFICE KANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-15 13:33:49',5,'975','2023-03-15 13:33:49','975');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','291',1,'1',5585.61,150.00,'2023-01-18','','2023-01-18 14:01:15','648','648',2023,'648','2023-01-18 14:01:15',5),('1','291',2,'1',150.00,5600.00,'2023-01-18','','2023-01-18 21:01:54','648','648',2023,'648','2023-01-18 21:01:54',5),('1','291',3,'1',8514.72,9040.00,'2023-03-15','','2023-03-15 08:10:26','648','648',2023,'648','2023-03-15 08:10:26',5),('1','291',4,'1',9040.00,9097.00,'2023-03-15','','2023-03-15 08:23:00','648','648',2023,'648','2023-03-15 08:23:00',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','291','1',1,'5','PUMP 1',8564.03,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-19 13:27:39','178'),('1','291','1',2,'5','PUMP 2',47824.12,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-19 13:27:59','178'),('1','291','1',3,'5','PUMP 3',58085.74,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-19 13:28:18','178'),('1','291','1',4,'5','PUMP 4',25512.36,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-19 13:28:44','178'),('1','291','2',5,'5','AGO PUMP 1',0.00,'DISPENSING AGO',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','291','1',6,'5','PUMP 5',16252.10,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-19 13:41:11','178'),('1','291','1',7,'5','PUMP 6',60523.76,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-19 13:41:32','178'),('1','291','1',8,'5','PUMP 7',19355.02,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-19 13:41:58','178'),('1','291','1',9,'5','PUMP 8',11675.88,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-19 13:42:24','178');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','291',1,'MORNING SHIFT','2022-10-15','2023-01-16 12:46:56','2023-01-17 12:46:56','973',132430.22,132430.22,'973','2023-01-16 12:53:28','648','2023-01-16 13:07:30',10,0),('1','291',2,'AFTERNOON SHIFT','2022-10-15','2023-01-16 13:35:20','2023-01-17 13:35:20','973',461144.60,461144.60,'973','2023-01-16 13:38:19','648','2023-01-16 13:50:19',10,0),('1','291',3,'MORNING SHIFT','2022-10-16','2023-01-16 13:54:07','2023-01-17 13:54:07','973',267589.18,267589.18,'973','2023-01-16 13:56:44','648','2023-01-16 14:02:40',10,0),('1','291',4,'AFTERNOON SHIFT','2022-10-16','2023-01-16 14:05:24','2023-01-17 14:05:24','973',415279.34,415279.34,'973','2023-01-16 14:19:21','648','2023-01-16 14:20:48',10,0),('1','291',5,'MORNING SHIFT','2022-10-17','2023-01-16 14:23:35','2023-01-17 14:23:35','973',324278.62,324278.62,'973','2023-01-16 14:26:02','648','2023-01-16 14:27:30',10,0),('1','291',6,'AFTERNOON SHIFT','2022-10-17','2023-01-16 14:29:24','2023-01-17 14:29:24','973',607211.40,607211.40,'973','2023-01-16 14:32:36','648','2023-01-16 14:35:27',10,0),('1','291',7,'MORNING SHIFT','2022-10-18','2023-01-16 14:36:32','2023-01-17 14:36:32','973',326112.02,326112.02,'973','2023-01-16 14:38:39','648','2023-01-16 14:42:30',10,0),('1','291',8,'AFTERNOON SHIFT','2022-10-18','2023-01-16 14:43:29','2023-01-17 14:43:29','973',44354.04,44354.04,'973','2023-01-16 14:47:02','648','2023-01-16 15:11:37',10,0),('1','291',9,'MORNING SHIFT','2022-10-21','2023-01-16 17:48:31','2023-01-17 17:48:31','973',666052.86,666052.86,'973','2023-01-16 17:52:37','648','2023-01-16 17:54:33',10,0),('1','291',10,'AFTERNOON SHIFT','2022-10-22','2023-01-16 17:56:50','2023-01-17 17:56:50','973',428136.28,428136.28,'973','2023-01-16 18:02:16','648','2023-01-16 18:05:46',10,0),('1','291',11,'MORNING SHIFT','2022-10-22','2023-01-16 18:07:08','2023-01-17 18:07:08','973',604423.92,604423.92,'973','2023-01-16 18:09:44','648','2023-01-16 18:11:49',10,0),('1','291',12,'AFTERNOON SHIFT','2022-10-22','2023-01-16 18:12:28','2023-01-17 18:12:28','973',487137.94,487137.94,'973','2023-01-16 18:16:17','648','2023-01-16 18:17:46',10,0),('1','291',13,'MORNING SHIFT','2022-10-23','2023-01-16 18:18:53','2023-01-17 18:18:53','973',613024.88,613024.88,'973','2023-01-16 18:23:49','648','2023-01-16 18:25:45',10,0),('1','291',14,'AFTERNOON SHIFT','2022-10-23','2023-01-16 18:26:31','2023-01-17 18:26:31','973',378823.16,378823.16,'973','2023-01-16 18:30:53','648','2023-01-16 19:00:46',10,0),('1','291',15,'MORNING SHIFT','2022-10-24','2023-01-16 19:50:14','2023-01-17 19:50:14','973',3967007.68,3967007.68,'973','2023-01-16 20:20:31','648','2023-01-17 07:08:52',10,0),('1','291',16,'AFTERNOON SHIFT','2022-10-24','2023-01-17 11:28:01','2023-01-18 11:28:01','973',721539.02,721539.02,'973','2023-01-17 11:32:07','648','2023-01-17 17:15:43',10,0),('1','291',17,'MORNING SHIFT','2022-10-25','2023-01-17 17:18:28','2023-01-18 17:18:28','973',1205323.44,1205323.44,'973','2023-01-17 17:21:04','648','2023-01-17 17:31:14',10,0),('1','291',18,'AFTERNOON SHIFT','2022-10-25','2023-01-17 17:32:48','2023-01-18 17:32:48','973',1241754.70,1241754.70,'973','2023-01-17 17:36:13','648','2023-01-17 17:37:44',10,0),('1','291',19,'MORNING SHIFT','2022-10-26','2023-01-17 17:38:29','2023-01-18 17:38:29','973',1367073.82,1367073.82,'973','2023-01-17 17:40:49','648','2023-01-17 17:42:12',10,0),('1','291',20,'AFTERNOON SHIFT','2022-10-26','2023-01-17 17:43:02','2023-01-18 17:43:02','973',1306048.30,1306048.30,'973','2023-01-17 17:45:22','648','2023-01-17 17:48:00',10,0),('1','291',21,'MORNING SHIFT','2022-10-27','2023-01-17 17:50:06','2023-01-18 17:50:06','973',1598813.80,1598813.80,'973','2023-01-17 18:05:07','648','2023-01-17 18:19:19',10,0),('1','291',22,'AFTERNOON SHIFT','2022-10-27','2023-01-17 18:20:05','2023-01-18 18:20:05','973',660842.80,660842.80,'973','2023-01-17 18:23:37','648','2023-01-17 18:26:18',10,0),('1','291',23,'MORNING SHIFT','2022-10-28','2023-01-17 18:26:52','2023-01-18 18:26:52','973',2719359.40,2719359.40,'973','2023-01-17 18:32:44','648','2023-01-18 13:46:41',10,0),('1','291',24,'AFTERNOON SHIFT','2022-10-28','2023-01-18 13:47:43','2023-01-19 13:47:43','973',996769.74,996769.74,'973','2023-01-18 21:39:41','648','2023-01-18 23:49:45',10,0),('1','291',25,'AFTERNOON SHIFT','2023-03-04','2023-03-05 11:04:18','2023-03-06 11:04:18','973',1963459.40,1963459.40,'973','2023-03-05 12:08:19','648','2023-03-06 23:16:42',10,0),('1','291',26,'MORNING SHIFT','2023-03-06','2023-03-07 12:46:52','2023-03-08 12:46:52','973',2147786.00,2147786.00,'973','2023-03-07 12:48:36','648','2023-03-08 21:25:28',10,0),('1','291',27,'AFTERNOON SHIFT','2023-03-05','2023-03-09 09:06:39','2023-03-10 09:06:39','973',2588525.80,2588525.80,'973','2023-03-09 09:11:47','648','2023-03-09 10:30:30',10,0),('1','291',28,'MORNING SHIFT','2023-03-06','2023-03-10 14:48:24','2023-03-11 14:48:24','973',2227724.80,2227724.80,'973','2023-03-10 14:50:48','648','2023-03-10 15:47:07',10,0),('1','291',29,'AFTERNOON SHIFT','2023-03-06','2023-03-11 10:46:45','2023-03-12 10:46:45','973',2271252.30,2271252.30,'973','2023-03-11 10:48:41','648','2023-03-11 11:14:05',10,0),('1','291',30,'MORNING SHIFT','2023-03-07','2023-03-11 11:22:51','2023-03-12 11:22:51','973',268460.60,268460.60,'973','2023-03-11 11:28:02','975','2023-03-11 11:45:52',10,0),('1','291',31,'MORNING SHIFT','2023-03-11','2023-03-11 16:59:02','2023-03-12 16:59:02','973',2817615.00,2817615.00,'973','2023-03-11 17:01:42','648','2023-03-11 17:02:33',10,0),('1','291',32,'AFTERNOON SHIFT','2023-03-11','2023-03-13 11:50:48','2023-03-14 11:50:48','973',2263073.50,2263073.50,'973','2023-03-13 11:52:16','648','2023-03-13 18:03:45',10,0),('1','291',33,'MORNING SHIFT','2023-03-14','2023-03-14 21:25:37','2023-03-15 21:25:37','973',3217256.10,3217256.10,'973','2023-03-14 21:27:31','648','2023-03-15 07:01:30',10,0),('1','291',34,'AFTERNOON SHIFT','2023-03-12','2023-03-15 07:59:11','2023-03-16 07:59:11','973',2083004.20,2083004.20,'973','2023-03-15 08:25:00','648','2023-03-15 09:15:25',10,0),('1','291',35,'AFTERNOON SHIFT','2023-03-16','2023-03-17 09:01:00','2023-03-18 09:01:00','973',1943695.50,1943695.50,'973','2023-03-17 09:02:54','648','2023-03-17 21:41:43',10,0),('1','291',36,'MORNING SHIFT','2023-03-17','2023-03-18 07:27:24','2023-03-19 07:27:24','973',1815470.50,1815470.50,'973','2023-03-18 07:29:39','648','2023-03-18 18:52:50',10,0),('1','291',37,'AFTERNOON SHIFT','2023-03-17','2023-03-18 20:51:50','2023-03-19 20:51:50','973',2391712.50,2391712.50,'973','2023-03-18 20:54:31','648','2023-03-19 15:29:32',10,0),('1','291',38,'MORNING SHIFT','2023-03-20','2023-03-20 19:48:56','2023-03-21 19:48:56','973',2736894.20,2736894.20,'973','2023-03-20 19:50:46','','0000-00-00 00:00:00',5,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=343 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','291','1','1',1,'1','1',580.16,580.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','1',2,'2','1',544.44,544.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','1',3,'3','1',599.63,679.78,80.15,14266.70,0.00,0.00,0.00,0.00,0.00),('1','291','1','1',4,'4','1',497.49,576.08,78.59,13989.02,0.00,0.00,0.00,0.00,0.00),('1','291','2','1',5,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','1',6,'6','1',702.42,702.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','1',7,'7','1',553.00,553.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','1',8,'8','1',618.23,868.67,250.44,44578.32,0.00,0.00,0.00,0.00,0.00),('1','291','1','1',9,'9','1',532.33,867.14,334.81,59596.18,0.00,0.00,0.00,0.00,0.00),('1','291','1','2',10,'1','1',580.16,580.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','2',11,'2','1',544.44,544.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','2',12,'3','1',679.78,1489.08,809.30,144055.40,0.00,0.00,0.00,0.00,0.00),('1','291','1','2',13,'4','1',576.08,1233.02,656.94,116935.32,0.00,0.00,0.00,0.00,0.00),('1','291','2','2',14,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','2',15,'6','1',702.42,702.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','2',16,'7','1',553.00,553.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','2',17,'8','1',868.67,1854.74,986.07,175520.46,0.00,0.00,0.00,0.00,0.00),('1','291','1','2',18,'9','1',867.14,1005.53,138.39,24633.42,0.00,0.00,0.00,0.00,0.00),('1','291','1','3',19,'1','1',580.16,580.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','3',20,'2','1',544.44,544.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','3',21,'3','1',1489.08,2011.43,522.35,92978.30,0.00,0.00,0.00,0.00,0.00),('1','291','1','3',22,'4','1',1233.02,1755.19,522.17,92946.26,0.00,0.00,0.00,0.00,0.00),('1','291','2','3',23,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','3',24,'6','1',702.42,702.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','3',25,'7','1',553.00,553.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','3',26,'8','1',1854.74,2313.53,458.79,81664.62,0.00,0.00,0.00,0.00,0.00),('1','291','1','3',27,'9','1',1005.53,1005.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','4',28,'1','1',580.16,580.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','4',29,'2','1',544.44,544.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','4',30,'3','1',2011.43,2852.51,824.08,146686.24,0.00,0.00,17.00,0.00,0.00),('1','291','1','4',31,'4','1',1755.19,2462.24,684.05,121760.90,0.00,0.00,23.00,0.00,0.00),('1','291','2','4',32,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','4',33,'6','1',702.42,702.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','4',34,'7','1',553.00,553.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','4',35,'8','1',2313.53,3116.92,722.10,128533.80,0.00,0.00,81.29,0.00,0.00),('1','291','1','4',36,'9','1',1005.53,1129.83,102.80,18298.40,0.00,0.00,21.50,0.00,0.00),('1','291','1','5',37,'1','1',580.16,580.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','5',38,'2','1',544.44,544.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','5',39,'3','1',2852.51,3531.48,678.97,120856.66,0.00,0.00,0.00,0.00,0.00),('1','291','1','5',40,'4','1',2462.24,2965.95,503.71,89660.38,0.00,0.00,0.00,0.00,0.00),('1','291','2','5',41,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','5',42,'6','1',702.42,702.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','5',43,'7','1',553.00,874.52,321.52,57230.56,0.00,0.00,0.00,0.00,0.00),('1','291','1','5',44,'8','1',3116.92,3434.51,317.59,56531.02,0.00,0.00,0.00,0.00,0.00),('1','291','1','5',45,'9','1',1129.83,1129.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','6',46,'1','1',580.16,580.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','6',47,'2','1',544.44,544.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','6',48,'3','1',3531.48,4297.52,766.04,136355.12,0.00,0.00,0.00,0.00,0.00),('1','291','1','6',49,'4','1',2965.95,3993.74,1027.79,182946.62,0.00,0.00,0.00,0.00,0.00),('1','291','2','6',50,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','6',51,'6','1',702.42,722.42,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','291','1','6',52,'7','1',874.52,1598.10,723.58,128797.24,0.00,0.00,0.00,0.00,0.00),('1','291','1','6',53,'8','1',3434.51,4328.40,893.89,159112.42,0.00,0.00,0.00,0.00,0.00),('1','291','1','6',54,'9','1',1129.83,1129.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','7',55,'1','1',580.16,580.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','7',56,'2','1',544.44,544.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','7',57,'3','1',4297.52,4903.32,605.80,107832.40,0.00,0.00,0.00,0.00,0.00),('1','291','1','7',58,'4','1',3993.74,4622.25,628.51,111874.78,0.00,0.00,0.00,0.00,0.00),('1','291','2','7',59,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','7',60,'6','1',722.42,722.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','7',61,'7','1',1598.10,1960.36,362.26,64482.28,0.00,0.00,0.00,0.00,0.00),('1','291','1','7',62,'8','1',4328.40,4563.92,235.52,41922.56,0.00,0.00,0.00,0.00,0.00),('1','291','1','7',63,'9','1',1129.83,1129.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','8',64,'1','1',580.16,580.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','8',65,'2','1',544.44,544.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','8',66,'3','1',4903.32,4924.02,0.00,0.00,0.00,0.00,20.70,0.00,0.00),('1','291','1','8',67,'4','1',4622.25,4750.07,107.13,19069.14,0.00,0.00,20.69,0.00,0.00),('1','291','2','8',68,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','8',69,'6','1',722.42,722.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','8',70,'7','1',1960.36,2022.63,62.27,11084.06,0.00,0.00,0.00,0.00,0.00),('1','291','1','8',71,'8','1',4563.92,4664.42,79.78,14200.84,0.00,0.00,20.72,0.00,0.00),('1','291','1','8',72,'9','1',1129.83,1129.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','9',73,'1','1',580.16,938.62,358.46,63805.88,0.00,0.00,0.00,0.00,0.00),('1','291','1','9',74,'2','1',544.44,654.56,90.12,16041.36,0.00,0.00,20.00,0.00,0.00),('1','291','1','9',75,'3','1',4924.02,6415.50,1491.48,265483.44,0.00,0.00,0.00,0.00,0.00),('1','291','1','9',76,'4','1',4750.07,4750.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','2','9',77,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','9',78,'6','1',722.42,1084.72,362.30,64489.40,0.00,0.00,0.00,0.00,0.00),('1','291','1','9',79,'7','1',2022.63,2606.55,583.92,103937.76,0.00,0.00,0.00,0.00,0.00),('1','291','1','9',80,'8','1',4664.42,5520.01,855.59,152295.02,0.00,0.00,0.00,0.00,0.00),('1','291','1','9',81,'9','1',1129.83,1129.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','10',82,'1','1',938.62,1501.99,563.37,100279.86,0.00,0.00,0.00,0.00,0.00),('1','291','1','10',83,'2','1',654.56,654.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','10',84,'3','1',6415.50,7351.64,936.14,166632.92,0.00,0.00,0.00,0.00,0.00),('1','291','1','10',85,'4','1',4750.07,4799.33,49.26,8768.28,0.00,0.00,0.00,0.00,0.00),('1','291','2','10',86,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','10',87,'6','1',1084.72,1084.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','10',88,'7','1',2606.55,2988.56,382.01,67997.78,0.00,0.00,0.00,0.00,0.00),('1','291','1','10',89,'8','1',5520.01,5994.49,474.48,84457.44,0.00,0.00,0.00,0.00,0.00),('1','291','1','10',90,'9','1',1129.83,1129.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','11',91,'1','1',1501.99,2171.69,669.70,119206.60,0.00,0.00,0.00,0.00,0.00),('1','291','1','11',92,'2','1',654.56,938.46,283.90,50534.20,0.00,0.00,0.00,0.00,0.00),('1','291','1','11',93,'3','1',7351.64,7351.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','11',94,'4','1',4799.33,5928.57,1129.24,201004.72,0.00,0.00,0.00,0.00,0.00),('1','291','2','11',95,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','11',96,'6','1',1084.72,1084.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','11',97,'7','1',2988.56,3411.05,422.49,75203.22,0.00,0.00,0.00,0.00,0.00),('1','291','1','11',98,'8','1',5994.49,6884.80,890.31,158475.18,0.00,0.00,0.00,0.00,0.00),('1','291','1','11',99,'9','1',1129.83,1129.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','12',100,'1','1',2171.69,2956.93,785.24,139772.72,0.00,0.00,0.00,0.00,0.00),('1','291','1','12',101,'2','1',938.46,1019.91,81.45,14498.10,0.00,0.00,0.00,0.00,0.00),('1','291','1','12',102,'3','1',7351.64,8329.38,977.74,174037.72,0.00,0.00,0.00,0.00,0.00),('1','291','1','12',103,'4','1',5928.57,5928.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','2','12',104,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','12',105,'6','1',1084.72,1084.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','12',106,'7','1',3411.05,3411.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','12',107,'8','1',6884.80,7777.10,892.30,158829.40,0.00,0.00,0.00,0.00,0.00),('1','291','1','12',108,'9','1',1129.83,1129.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','13',109,'1','1',2956.93,3645.66,688.73,122593.94,0.00,0.00,0.00,0.00,0.00),('1','291','1','13',110,'2','1',1019.91,1019.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','13',111,'3','1',8329.38,8329.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','13',112,'4','1',5928.57,7241.21,1312.64,233649.92,0.00,0.00,0.00,0.00,0.00),('1','291','2','13',113,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','13',114,'6','1',1084.72,1505.20,420.48,74845.44,0.00,0.00,0.00,0.00,0.00),('1','291','1','13',115,'7','1',3411.05,3411.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','13',116,'8','1',7777.10,8799.21,1022.11,181935.58,0.00,0.00,0.00,0.00,0.00),('1','291','1','13',117,'9','1',1129.83,1129.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','14',118,'1','1',3645.66,3914.31,253.65,45149.70,0.00,0.00,15.00,0.00,0.00),('1','291','1','14',119,'2','1',1019.91,1020.20,0.29,51.62,0.00,0.00,0.00,0.00,0.00),('1','291','1','14',120,'3','1',8329.38,8984.17,644.79,114772.62,0.00,0.00,10.00,0.00,0.00),('1','291','1','14',121,'4','1',7241.21,7483.88,242.67,43195.26,0.00,0.00,0.00,0.00,0.00),('1','291','2','14',122,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','14',123,'6','1',1505.20,1505.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','14',124,'7','1',3411.05,3719.21,298.16,53072.48,0.00,0.00,10.00,0.00,0.00),('1','291','1','14',125,'8','1',8799.21,9487.87,688.66,122581.48,0.00,0.00,0.00,0.00,0.00),('1','291','1','14',126,'9','1',1129.83,1129.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','15',127,'1','1',3914.31,3914.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','15',128,'2','1',1020.20,1020.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','15',129,'3','1',8984.17,10177.95,1193.78,212492.84,0.00,0.00,0.00,0.00,0.00),('1','291','1','15',130,'4','1',7483.88,9812.15,2328.27,414432.06,0.00,0.00,0.00,0.00,0.00),('1','291','2','15',131,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','15',132,'6','1',1505.20,12005.24,10500.04,1869007.12,0.00,0.00,0.00,0.00,0.00),('1','291','1','15',133,'7','1',3719.21,9899.01,6179.80,1100004.40,0.00,0.00,0.00,0.00,0.00),('1','291','1','15',134,'8','1',9487.87,9487.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','15',135,'9','1',1129.83,3214.50,2084.67,371071.26,0.00,0.00,0.00,0.00,0.00),('1','291','1','16',136,'1','1',3914.31,3914.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','16',137,'2','1',1020.20,1020.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','16',138,'3','1',10177.95,11116.80,938.85,167115.30,0.00,0.00,0.00,0.00,0.00),('1','291','1','16',139,'4','1',9812.15,10884.36,1072.21,190853.38,0.00,0.00,0.00,0.00,0.00),('1','291','2','16',140,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','16',141,'6','1',12005.24,12005.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','16',142,'7','1',9899.01,10481.53,582.52,103688.56,0.00,0.00,0.00,0.00,0.00),('1','291','1','16',143,'8','1',9487.87,10947.88,1460.01,259881.78,0.00,0.00,0.00,0.00,0.00),('1','291','1','16',144,'9','1',3214.50,3214.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','17',145,'1','1',3914.31,3914.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','17',146,'2','1',1020.20,1020.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','17',147,'3','1',11116.80,13918.30,2801.50,498667.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','17',148,'4','1',10884.36,10884.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','2','17',149,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','17',150,'6','1',12005.24,12005.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','17',151,'7','1',10481.53,12213.90,1732.37,308361.86,0.00,0.00,0.00,0.00,0.00),('1','291','1','17',152,'8','1',10947.88,10947.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','17',153,'9','1',3214.50,5452.11,2237.61,398294.58,0.00,0.00,0.00,0.00,0.00),('1','291','1','18',154,'1','1',3914.31,3914.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','18',155,'2','1',1020.20,1020.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','18',156,'3','1',13918.30,15424.27,1505.97,268062.66,0.00,0.00,0.00,0.00,0.00),('1','291','1','18',157,'4','1',10884.36,12825.68,1941.32,345554.96,0.00,0.00,0.00,0.00,0.00),('1','291','2','18',158,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','18',159,'6','1',12005.24,12005.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','18',160,'7','1',12213.90,14184.86,1970.96,350830.88,0.00,0.00,0.00,0.00,0.00),('1','291','1','18',161,'8','1',10947.88,12505.78,1557.90,277306.20,0.00,0.00,0.00,0.00,0.00),('1','291','1','18',162,'9','1',5452.11,5452.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','19',163,'1','1',3914.31,3914.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','19',164,'2','1',1020.20,1413.58,393.38,70021.64,0.00,0.00,0.00,0.00,0.00),('1','291','1','19',165,'3','1',15424.27,15424.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','19',166,'4','1',12825.68,15694.90,2869.22,510721.16,0.00,0.00,0.00,0.00,0.00),('1','291','2','19',167,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','19',168,'6','1',12005.24,14370.31,2365.07,420982.46,0.00,0.00,0.00,0.00,0.00),('1','291','1','19',169,'7','1',14184.86,14184.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','19',170,'8','1',12505.78,12505.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','19',171,'9','1',5452.11,7504.63,2052.52,365348.56,0.00,0.00,0.00,0.00,0.00),('1','291','1','20',172,'1','1',3914.31,3914.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','20',173,'2','1',1413.58,1413.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','20',174,'3','1',15424.27,17168.11,1743.84,310403.52,0.00,0.00,0.00,0.00,0.00),('1','291','1','20',175,'4','1',15694.90,17457.96,1763.06,313824.68,0.00,0.00,0.00,0.00,0.00),('1','291','2','20',176,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','20',177,'6','1',14370.31,14370.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','20',178,'7','1',14184.86,16259.97,2075.11,369369.58,0.00,0.00,0.00,0.00,0.00),('1','291','1','20',179,'8','1',12505.78,14261.12,1755.34,312450.52,0.00,0.00,0.00,0.00,0.00),('1','291','1','20',180,'9','1',7504.63,7504.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','21',181,'1','1',3914.31,3914.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','21',182,'2','1',1413.58,2310.78,897.20,159701.60,0.00,0.00,0.00,0.00,0.00),('1','291','1','21',183,'3','1',17168.11,17168.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','21',184,'4','1',17457.96,21031.73,3573.77,636131.06,0.00,0.00,0.00,0.00,0.00),('1','291','2','21',185,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','21',186,'6','1',14370.31,16249.65,1857.34,330606.52,0.00,0.00,22.00,0.00,0.00),('1','291','1','21',187,'7','1',16259.97,16259.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','21',188,'8','1',14261.12,16919.41,2653.79,472374.62,0.00,0.00,4.50,0.00,0.00),('1','291','1','21',189,'9','1',7504.63,7504.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','22',190,'1','1',3914.31,3914.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','22',191,'2','1',2310.78,3279.13,968.35,172366.30,0.00,0.00,0.00,0.00,0.00),('1','291','1','22',192,'3','1',17168.11,18243.73,1075.62,191460.36,0.00,0.00,0.00,0.00,0.00),('1','291','1','22',193,'4','1',21031.73,21031.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','2','22',194,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','22',195,'6','1',16249.65,16249.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','22',196,'7','1',16259.97,16957.47,697.50,124155.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','22',197,'8','1',16919.41,17890.54,971.13,172861.14,0.00,0.00,0.00,0.00,0.00),('1','291','1','22',198,'9','1',7504.63,7504.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','23',199,'1','1',3914.31,8564.03,4649.72,827650.16,0.00,0.00,0.00,0.00,0.00),('1','291','1','23',200,'2','1',3279.13,4807.87,1528.74,272115.72,0.00,0.00,0.00,0.00,0.00),('1','291','1','23',201,'3','1',18243.73,22559.09,4310.36,767244.08,0.00,0.00,5.00,0.00,0.00),('1','291','1','23',202,'4','1',21031.73,21031.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','2','23',203,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','23',204,'6','1',16249.65,16249.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','23',205,'7','1',16957.47,17589.70,632.23,112536.94,0.00,0.00,0.00,0.00,0.00),('1','291','1','23',206,'8','1',17890.54,17890.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','23',207,'9','1',7504.63,11675.88,4156.25,739812.50,0.00,0.00,15.00,0.00,0.00),('1','291','1','24',208,'1','1',8564.03,8564.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','24',209,'2','1',4807.87,6203.02,1395.15,248336.70,0.00,0.00,0.00,0.00,0.00),('1','291','1','24',210,'3','1',22559.09,24240.76,1681.67,299337.26,0.00,0.00,0.00,0.00,0.00),('1','291','1','24',211,'4','1',21031.73,21031.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','2','24',212,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','24',213,'6','1',16249.65,16249.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','24',214,'7','1',17589.70,18648.23,1058.53,188418.34,0.00,0.00,0.00,0.00,0.00),('1','291','1','24',215,'8','1',17890.54,19355.02,1464.48,260677.44,0.00,0.00,0.00,0.00,0.00),('1','291','1','24',216,'9','1',11675.88,11675.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','25',217,'1','1',8564.03,8564.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','25',218,'2','1',6203.02,9399.38,3196.36,735162.80,0.00,0.00,0.00,0.00,0.00),('1','291','1','25',219,'3','1',24240.76,27227.31,2986.55,686906.50,0.00,0.00,0.00,0.00,0.00),('1','291','1','25',220,'4','1',21031.73,21033.23,0.00,0.00,0.00,0.00,1.50,0.00,0.00),('1','291','2','25',221,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','25',222,'6','1',16249.65,16252.10,0.00,0.00,0.00,0.00,2.45,0.00,0.00),('1','291','1','25',223,'7','1',18648.23,21002.10,2353.87,541390.10,0.00,0.00,0.00,0.00,0.00),('1','291','1','25',224,'8','1',19355.02,19355.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','25',225,'9','1',11675.88,11675.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','26',226,'1','1',8564.03,8564.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','26',227,'2','1',9399.38,11937.28,2537.90,583717.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','26',228,'3','1',27227.31,30939.00,3711.69,853688.70,0.00,0.00,0.00,0.00,0.00),('1','291','1','26',229,'4','1',21033.23,21033.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','2','26',230,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','26',231,'6','1',16252.10,16252.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','26',232,'7','1',21002.10,24090.71,3088.61,710380.30,0.00,0.00,0.00,0.00,0.00),('1','291','1','26',233,'8','1',19355.02,19355.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','26',234,'9','1',11675.88,11675.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','27',235,'1','1',8564.03,8564.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','27',236,'2','1',11937.28,16286.41,4347.13,999839.90,0.00,0.00,2.00,0.00,0.00),('1','291','1','27',237,'3','1',30939.00,34436.37,3497.37,804395.10,0.00,0.00,0.00,0.00,0.00),('1','291','1','27',238,'4','1',21033.23,21033.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','2','27',239,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','27',240,'6','1',16252.10,16252.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','27',241,'7','1',24090.71,27500.67,3409.96,784290.80,0.00,0.00,0.00,0.00,0.00),('1','291','1','27',242,'8','1',19355.02,19355.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','27',243,'9','1',11675.88,11675.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','28',244,'1','1',8564.03,8564.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','28',245,'2','1',16286.41,19045.24,2758.83,634530.90,0.00,0.00,0.00,0.00,0.00),('1','291','1','28',246,'3','1',34436.37,37582.49,3146.12,723607.60,0.00,0.00,0.00,0.00,0.00),('1','291','1','28',247,'4','1',21033.23,21033.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','2','28',248,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','28',249,'6','1',16252.10,16252.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','28',250,'7','1',27500.67,31281.48,3780.81,869586.30,0.00,0.00,0.00,0.00,0.00),('1','291','1','28',251,'8','1',19355.02,19355.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','28',252,'9','1',11675.88,11675.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','29',253,'1','1',8564.03,8564.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','29',254,'2','1',19045.24,22980.34,3935.10,905073.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','29',255,'3','1',37582.49,40596.00,3009.71,692233.30,0.00,0.00,3.80,0.00,0.00),('1','291','1','29',256,'4','1',21033.23,21033.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','2','29',257,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','29',258,'6','1',16252.10,16252.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','29',259,'7','1',31281.48,34211.68,2930.20,673946.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','29',260,'8','1',19355.02,19355.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','29',261,'9','1',11675.88,11675.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','30',262,'1','1',8564.03,8564.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','30',263,'2','1',22980.34,23606.21,625.87,143950.10,0.00,0.00,0.00,0.00,0.00),('1','291','1','30',264,'3','1',40596.00,41137.35,541.35,124510.50,0.00,0.00,0.00,0.00,0.00),('1','291','1','30',265,'4','1',21033.23,21033.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','2','30',266,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','30',267,'6','1',16252.10,16252.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','30',268,'7','1',34211.68,34211.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','30',269,'8','1',19355.02,19355.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','30',270,'9','1',11675.88,11675.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','31',271,'1','1',8564.03,8564.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','31',272,'2','1',23606.21,27345.91,3739.70,860131.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','31',273,'3','1',41137.35,44984.04,3846.69,884738.70,0.00,0.00,0.00,0.00,0.00),('1','291','1','31',274,'4','1',21033.23,21033.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','2','31',275,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','31',276,'6','1',16252.10,16252.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','31',277,'7','1',34211.68,38875.79,4664.11,1072745.30,0.00,0.00,0.00,0.00,0.00),('1','291','1','31',278,'8','1',19355.02,19355.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','31',279,'9','1',11675.88,11675.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','32',280,'1','1',8564.03,8564.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','32',281,'2','1',27345.91,30709.08,3363.17,773529.10,0.00,0.00,0.00,0.00,0.00),('1','291','1','32',282,'3','1',44984.04,47788.48,2804.44,645021.20,0.00,0.00,0.00,0.00,0.00),('1','291','1','32',283,'4','1',21033.23,21033.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','2','32',284,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','32',285,'6','1',16252.10,16252.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','32',286,'7','1',38875.79,42547.63,3671.84,844523.20,0.00,0.00,0.00,0.00,0.00),('1','291','1','32',287,'8','1',19355.02,19355.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','32',288,'9','1',11675.88,11675.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','33',289,'1','1',8564.03,8564.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','33',290,'2','1',30709.08,35634.39,4925.31,1132821.30,0.00,0.00,0.00,0.00,0.00),('1','291','1','33',291,'3','1',47788.48,50574.75,2786.27,640842.10,0.00,0.00,0.00,0.00,0.00),('1','291','1','33',292,'4','1',21033.23,21033.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','2','33',293,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','33',294,'6','1',16252.10,16252.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','33',295,'7','1',42547.63,48824.12,6276.49,1443592.70,0.00,0.00,0.00,0.00,0.00),('1','291','1','33',296,'8','1',19355.02,19355.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','33',297,'9','1',11675.88,11675.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','34',298,'1','1',8564.03,8564.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','34',299,'2','1',35634.39,38608.88,2954.49,679532.70,0.00,0.00,20.00,0.00,0.00),('1','291','1','34',300,'3','1',50574.75,53257.26,2662.51,612377.30,0.00,0.00,20.00,0.00,0.00),('1','291','1','34',301,'4','1',21033.23,21033.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','2','34',302,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','34',303,'6','1',16252.10,16252.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','34',304,'7','1',48824.12,52263.66,3439.54,791094.20,0.00,0.00,0.00,0.00,0.00),('1','291','1','34',305,'8','1',19355.02,19355.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','34',306,'9','1',11675.88,11675.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','35',307,'1','1',8564.03,8564.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','35',308,'2','1',38608.88,41540.56,2931.68,674286.40,0.00,0.00,0.00,0.00,0.00),('1','291','1','35',309,'3','1',53257.26,55851.37,2594.11,596645.30,0.00,0.00,0.00,0.00,0.00),('1','291','1','35',310,'4','1',21033.23,21033.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','2','35',311,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','35',312,'6','1',16252.10,16252.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','35',313,'7','1',52263.66,55188.72,2925.06,672763.80,0.00,0.00,0.00,0.00,0.00),('1','291','1','35',314,'8','1',19355.02,19355.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','35',315,'9','1',11675.88,11675.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','36',316,'1','1',8564.03,8564.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','36',317,'2','1',41540.56,44444.65,2904.09,667940.70,0.00,0.00,0.00,0.00,0.00),('1','291','1','36',318,'3','1',55851.37,55851.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','36',319,'4','1',21033.23,23490.32,2457.09,565130.70,0.00,0.00,0.00,0.00,0.00),('1','291','2','36',320,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','36',321,'6','1',16252.10,16252.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','36',322,'7','1',55188.72,57720.89,2532.17,582399.10,0.00,0.00,0.00,0.00,0.00),('1','291','1','36',323,'8','1',19355.02,19355.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','36',324,'9','1',11675.88,11675.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','37',325,'1','1',8564.03,8564.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','37',326,'2','1',44444.65,47824.12,3369.47,774978.10,0.00,0.00,10.00,0.00,0.00),('1','291','1','37',327,'3','1',55851.37,58085.74,2224.37,511605.10,0.00,0.00,10.00,0.00,0.00),('1','291','1','37',328,'4','1',23490.32,25512.36,2012.04,462769.20,0.00,0.00,10.00,0.00,0.00),('1','291','2','37',329,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','37',330,'6','1',16252.10,16252.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','37',331,'7','1',57720.89,60523.76,2792.87,642360.10,0.00,0.00,10.00,0.00,0.00),('1','291','1','37',332,'8','1',19355.02,19355.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','37',333,'9','1',11675.88,11675.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','38',334,'1','1',8564.03,8564.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','38',335,'2','1',47824.12,51315.26,3491.14,802962.20,0.00,0.00,0.00,0.00,0.00),('1','291','1','38',336,'3','1',58085.74,60917.68,2831.94,651346.20,0.00,0.00,0.00,0.00,0.00),('1','291','1','38',337,'4','1',25512.36,27151.59,1639.23,377022.90,0.00,0.00,0.00,0.00,0.00),('1','291','2','38',338,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','38',339,'6','1',16252.10,16252.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','38',340,'7','1',60523.76,64460.99,3937.23,905562.90,0.00,0.00,0.00,0.00,0.00),('1','291','1','38',341,'8','1',19355.02,19355.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','291','1','38',342,'9','1',11675.88,11675.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','291','1','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,1),('1','291','1','1',178.00,178.00,743.99,0.00,0.00,0.00,0.00,2),('1','291','2','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,3),('1','291','2','1',178.00,178.00,2590.70,0.00,0.00,0.00,0.00,4),('1','291','3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,5),('1','291','3','1',178.00,178.00,1503.31,0.00,0.00,0.00,0.00,6),('1','291','4','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,7),('1','291','4','1',178.00,178.00,2333.03,0.00,0.00,0.00,0.00,8),('1','291','5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,9),('1','291','5','1',178.00,178.00,1821.79,0.00,0.00,0.00,0.00,10),('1','291','6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,11),('1','291','6','1',178.00,178.00,3411.30,0.00,0.00,0.00,0.00,12),('1','291','7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,13),('1','291','7','1',178.00,178.00,1832.09,0.00,0.00,0.00,0.00,14),('1','291','8','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,15),('1','291','8','1',178.00,178.00,249.18,0.00,0.00,0.00,0.00,16),('1','291','9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,17),('1','291','9','1',178.00,178.00,3741.87,0.00,0.00,0.00,0.00,18),('1','291','10','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,19),('1','291','10','1',178.00,178.00,2405.26,0.00,0.00,0.00,0.00,20),('1','291','11','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,21),('1','291','11','1',178.00,178.00,3395.64,0.00,0.00,0.00,0.00,22),('1','291','12','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,23),('1','291','12','1',178.00,178.00,2736.73,0.00,0.00,0.00,0.00,24),('1','291','13','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,25),('1','291','13','1',178.00,178.00,3443.96,0.00,0.00,0.00,0.00,26),('1','291','14','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,27),('1','291','14','1',178.00,178.00,2128.22,0.00,0.00,0.00,0.00,28),('1','291','15','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,29),('1','291','15','1',178.00,178.00,22286.56,0.00,0.00,0.00,0.00,30),('1','291','16','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,31),('1','291','16','1',178.00,178.00,4053.59,0.00,0.00,0.00,0.00,32),('1','291','17','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,33),('1','291','17','1',178.00,178.00,6771.48,0.00,0.00,0.00,0.00,34),('1','291','18','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,35),('1','291','18','1',178.00,178.00,6976.15,0.00,0.00,0.00,0.00,36),('1','291','19','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,37),('1','291','19','1',178.00,178.00,7680.19,0.00,0.00,0.00,0.00,38),('1','291','20','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,39),('1','291','20','1',178.00,178.00,7337.35,0.00,0.00,0.00,0.00,40),('1','291','21','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,41),('1','291','21','1',178.00,178.00,8982.10,0.00,0.00,0.00,0.00,42),('1','291','22','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,43),('1','291','22','1',178.00,178.00,3712.60,0.00,0.00,0.00,0.00,44),('1','291','23','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,45),('1','291','23','1',178.00,178.00,15277.30,0.00,0.00,0.00,0.00,46),('1','291','24','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,47),('1','291','24','1',178.00,178.00,5599.83,0.00,0.00,0.00,0.00,48),('1','291','25','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,49),('1','291','25','1',230.00,230.00,8536.78,0.00,0.00,0.00,0.00,50),('1','291','26','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,51),('1','291','26','1',230.00,230.00,9338.20,0.00,0.00,0.00,0.00,52),('1','291','27','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,53),('1','291','27','1',230.00,230.00,11254.46,0.00,0.00,0.00,0.00,54),('1','291','28','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,55),('1','291','28','1',230.00,230.00,9685.76,0.00,0.00,0.00,0.00,56),('1','291','29','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,57),('1','291','29','1',230.00,230.00,9875.01,0.00,0.00,0.00,0.00,58),('1','291','30','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,59),('1','291','30','1',230.00,230.00,1167.22,0.00,0.00,0.00,0.00,60),('1','291','31','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,61),('1','291','31','1',230.00,230.00,12250.50,0.00,0.00,0.00,0.00,62),('1','291','32','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,63),('1','291','32','1',230.00,230.00,9839.45,0.00,0.00,0.00,0.00,64),('1','291','33','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,65),('1','291','33','1',230.00,230.00,13988.07,0.00,0.00,0.00,0.00,66),('1','291','34','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,67),('1','291','34','1',230.00,230.00,9056.54,0.00,0.00,0.00,0.00,68),('1','291','35','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,69),('1','291','35','1',230.00,230.00,8450.85,0.00,0.00,0.00,0.00,70),('1','291','36','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,71),('1','291','36','1',230.00,230.00,7893.35,0.00,0.00,0.00,0.00,72),('1','291','37','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,73),('1','291','37','1',230.00,230.00,10398.75,0.00,0.00,0.00,0.00,74),('1','291','38','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,75),('1','291','38','1',230.00,230.00,11899.54,0.00,0.00,0.00,0.00,76);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',1,'291','PMS TANKS',''),('1',2,'291','AGO TANKS','');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','291','1',1,0,'1','PMS TANK 1, 2 & 3',90000.00,0.00,NULL,'','178','2022-10-19 10:22:35','2022-10-19 10:22:35','178',5,0),('1','291','2',2,0,'2','AGO TANK',30000.00,0.00,NULL,'CONTAING AGO','178','2022-10-19 10:24:23','2022-10-19 10:24:23','178',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','291',2,0.00,'2023-03-20 19:48:56'),(2,'1','291',1,23047.51,'2023-03-20 19:48:56');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=204 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'1','291',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,5518000.00,31000.00,0.00,0.00,'2023-01-15 21:44:08','',''),(2,'1','291',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8010000.00,45000.00,0.00,0.00,'2023-01-15 21:44:28','',''),(3,'1','291',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8010000.00,45000.00,0.00,0.00,'2023-01-15 21:44:51','',''),(4,'1','291',NULL,1,'Reception corrector for bridging 1',0.00,0.00,0.00,45000.00,0.00,'2023-01-16 12:42:35','',''),(5,'1','291','1',1,'Received from bridging 1',0.00,0.00,45000.00,0.00,0.00,'2023-01-16 12:42:35','',''),(6,'1','291',NULL,1,'Reception corrector for bridging 2',0.00,0.00,0.00,45000.00,0.00,'2023-01-16 12:44:56','',''),(7,'1','291','1',1,'Received from bridging 2',0.00,0.00,45000.00,0.00,0.00,'2023-01-16 12:44:56','',''),(8,'1','291','1',1,'Sale Id shift 1',0.00,0.00,0.00,80.15,0.00,'2023-01-16 13:07:30','',''),(9,'1','291','1',1,'Sale Id shift 1',0.00,0.00,0.00,78.59,0.00,'2023-01-16 13:07:30','',''),(10,'1','291','1',1,'Sale Id shift 1',0.00,0.00,0.00,250.44,0.00,'2023-01-16 13:07:30','',''),(11,'1','291','1',1,'Sale Id shift 1',0.00,0.00,0.00,334.81,0.00,'2023-01-16 13:07:30','',''),(12,'1','291',NULL,1,'Sale Id shift 1',132430.22,0.00,0.00,0.00,0.00,'2023-01-16 13:07:30','',''),(13,'1','291','1',1,'Sale Id shift 2',0.00,0.00,0.00,809.30,0.00,'2023-01-16 13:50:19','',''),(14,'1','291','1',1,'Sale Id shift 2',0.00,0.00,0.00,656.94,0.00,'2023-01-16 13:50:19','',''),(15,'1','291','1',1,'Sale Id shift 2',0.00,0.00,0.00,986.07,0.00,'2023-01-16 13:50:19','',''),(16,'1','291','1',1,'Sale Id shift 2',0.00,0.00,0.00,138.39,0.00,'2023-01-16 13:50:19','',''),(17,'1','291',NULL,1,'Sale Id shift 2',461144.60,0.00,0.00,0.00,0.00,'2023-01-16 13:50:19','',''),(18,'1','291','1',1,'Sale Id shift 3',0.00,0.00,0.00,522.35,0.00,'2023-01-16 14:02:40','',''),(19,'1','291','1',1,'Sale Id shift 3',0.00,0.00,0.00,522.17,0.00,'2023-01-16 14:02:40','',''),(20,'1','291','1',1,'Sale Id shift 3',0.00,0.00,0.00,458.79,0.00,'2023-01-16 14:02:40','',''),(21,'1','291',NULL,1,'Sale Id shift 3',267589.18,0.00,0.00,0.00,0.00,'2023-01-16 14:02:40','',''),(22,'1','291','1',1,'Sale Id shift 4',0.00,0.00,0.00,824.08,0.00,'2023-01-16 14:20:48','',''),(23,'1','291','1',1,'Sale Id shift 4',0.00,0.00,0.00,684.05,0.00,'2023-01-16 14:20:48','',''),(24,'1','291','1',1,'Sale Id shift 4',0.00,0.00,0.00,722.10,0.00,'2023-01-16 14:20:48','',''),(25,'1','291','1',1,'Sale Id shift 4',0.00,0.00,0.00,102.80,0.00,'2023-01-16 14:20:48','',''),(26,'1','291',NULL,1,'Sale Id shift 4',415279.34,0.00,0.00,0.00,0.00,'2023-01-16 14:20:48','',''),(27,'1','291','1',1,'Sale Id shift 5',0.00,0.00,0.00,678.97,0.00,'2023-01-16 14:27:30','',''),(28,'1','291','1',1,'Sale Id shift 5',0.00,0.00,0.00,503.71,0.00,'2023-01-16 14:27:30','',''),(29,'1','291','1',1,'Sale Id shift 5',0.00,0.00,0.00,321.52,0.00,'2023-01-16 14:27:30','',''),(30,'1','291','1',1,'Sale Id shift 5',0.00,0.00,0.00,317.59,0.00,'2023-01-16 14:27:30','',''),(31,'1','291',NULL,1,'Sale Id shift 5',324278.62,0.00,0.00,0.00,0.00,'2023-01-16 14:27:30','',''),(32,'1','291','1',1,'Sale Id shift 6',0.00,0.00,0.00,766.04,0.00,'2023-01-16 14:35:27','',''),(33,'1','291','1',1,'Sale Id shift 6',0.00,0.00,0.00,1027.79,0.00,'2023-01-16 14:35:27','',''),(34,'1','291','1',1,'Sale Id shift 6',0.00,0.00,0.00,723.58,0.00,'2023-01-16 14:35:27','',''),(35,'1','291','1',1,'Sale Id shift 6',0.00,0.00,0.00,893.89,0.00,'2023-01-16 14:35:27','',''),(36,'1','291',NULL,1,'Sale Id shift 6',607211.40,0.00,0.00,0.00,0.00,'2023-01-16 14:35:27','',''),(37,'1','291','1',1,'Sale Id shift 7',0.00,0.00,0.00,605.80,0.00,'2023-01-16 14:42:30','',''),(38,'1','291','1',1,'Sale Id shift 7',0.00,0.00,0.00,628.51,0.00,'2023-01-16 14:42:30','',''),(39,'1','291','1',1,'Sale Id shift 7',0.00,0.00,0.00,362.26,0.00,'2023-01-16 14:42:30','',''),(40,'1','291','1',1,'Sale Id shift 7',0.00,0.00,0.00,235.52,0.00,'2023-01-16 14:42:30','',''),(41,'1','291',NULL,1,'Sale Id shift 7',326112.02,0.00,0.00,0.00,0.00,'2023-01-16 14:42:30','',''),(42,'1','291','1',1,'Sale Id shift 8',0.00,0.00,0.00,107.13,0.00,'2023-01-16 15:11:37','',''),(43,'1','291','1',1,'Sale Id shift 8',0.00,0.00,0.00,62.27,0.00,'2023-01-16 15:11:37','',''),(44,'1','291','1',1,'Sale Id shift 8',0.00,0.00,0.00,79.78,0.00,'2023-01-16 15:11:37','',''),(45,'1','291',NULL,1,'Sale Id shift 8',44354.04,0.00,0.00,0.00,0.00,'2023-01-16 15:11:37','',''),(46,'1','291','1',1,'Sale Id shift 9',0.00,0.00,0.00,358.46,0.00,'2023-01-16 17:54:33','',''),(47,'1','291','1',1,'Sale Id shift 9',0.00,0.00,0.00,90.12,0.00,'2023-01-16 17:54:33','',''),(48,'1','291','1',1,'Sale Id shift 9',0.00,0.00,0.00,1491.48,0.00,'2023-01-16 17:54:33','',''),(49,'1','291','1',1,'Sale Id shift 9',0.00,0.00,0.00,362.30,0.00,'2023-01-16 17:54:33','',''),(50,'1','291','1',1,'Sale Id shift 9',0.00,0.00,0.00,583.92,0.00,'2023-01-16 17:54:33','',''),(51,'1','291','1',1,'Sale Id shift 9',0.00,0.00,0.00,855.59,0.00,'2023-01-16 17:54:33','',''),(52,'1','291',NULL,1,'Sale Id shift 9',666052.86,0.00,0.00,0.00,0.00,'2023-01-16 17:54:33','',''),(53,'1','291','1',1,'Sale Id shift 10',0.00,0.00,0.00,563.37,0.00,'2023-01-16 18:05:46','',''),(54,'1','291','1',1,'Sale Id shift 10',0.00,0.00,0.00,936.14,0.00,'2023-01-16 18:05:46','',''),(55,'1','291','1',1,'Sale Id shift 10',0.00,0.00,0.00,49.26,0.00,'2023-01-16 18:05:46','',''),(56,'1','291','1',1,'Sale Id shift 10',0.00,0.00,0.00,382.01,0.00,'2023-01-16 18:05:46','',''),(57,'1','291','1',1,'Sale Id shift 10',0.00,0.00,0.00,474.48,0.00,'2023-01-16 18:05:46','',''),(58,'1','291',NULL,1,'Sale Id shift 10',428136.28,0.00,0.00,0.00,0.00,'2023-01-16 18:05:46','',''),(59,'1','291','1',1,'Sale Id shift 11',0.00,0.00,0.00,669.70,0.00,'2023-01-16 18:11:50','',''),(60,'1','291','1',1,'Sale Id shift 11',0.00,0.00,0.00,283.90,0.00,'2023-01-16 18:11:50','',''),(61,'1','291','1',1,'Sale Id shift 11',0.00,0.00,0.00,1129.24,0.00,'2023-01-16 18:11:50','',''),(62,'1','291','1',1,'Sale Id shift 11',0.00,0.00,0.00,422.49,0.00,'2023-01-16 18:11:50','',''),(63,'1','291','1',1,'Sale Id shift 11',0.00,0.00,0.00,890.31,0.00,'2023-01-16 18:11:50','',''),(64,'1','291',NULL,1,'Sale Id shift 11',604423.92,0.00,0.00,0.00,0.00,'2023-01-16 18:11:50','',''),(65,'1','291','1',1,'Sale Id shift 12',0.00,0.00,0.00,785.24,0.00,'2023-01-16 18:17:46','',''),(66,'1','291','1',1,'Sale Id shift 12',0.00,0.00,0.00,81.45,0.00,'2023-01-16 18:17:46','',''),(67,'1','291','1',1,'Sale Id shift 12',0.00,0.00,0.00,977.74,0.00,'2023-01-16 18:17:46','',''),(68,'1','291','1',1,'Sale Id shift 12',0.00,0.00,0.00,892.30,0.00,'2023-01-16 18:17:46','',''),(69,'1','291',NULL,1,'Sale Id shift 12',487137.94,0.00,0.00,0.00,0.00,'2023-01-16 18:17:46','',''),(70,'1','291','1',1,'Sale Id shift 13',0.00,0.00,0.00,688.73,0.00,'2023-01-16 18:25:45','',''),(71,'1','291','1',1,'Sale Id shift 13',0.00,0.00,0.00,1312.64,0.00,'2023-01-16 18:25:45','',''),(72,'1','291','1',1,'Sale Id shift 13',0.00,0.00,0.00,420.48,0.00,'2023-01-16 18:25:45','',''),(73,'1','291','1',1,'Sale Id shift 13',0.00,0.00,0.00,1022.11,0.00,'2023-01-16 18:25:45','',''),(74,'1','291',NULL,1,'Sale Id shift 13',613024.88,0.00,0.00,0.00,0.00,'2023-01-16 18:25:45','',''),(75,'1','291','1',1,'Sale Id shift 14',0.00,0.00,0.00,253.65,0.00,'2023-01-16 19:00:46','',''),(76,'1','291','1',1,'Sale Id shift 14',0.00,0.00,0.00,0.29,0.00,'2023-01-16 19:00:46','',''),(77,'1','291','1',1,'Sale Id shift 14',0.00,0.00,0.00,644.79,0.00,'2023-01-16 19:00:46','',''),(78,'1','291','1',1,'Sale Id shift 14',0.00,0.00,0.00,242.67,0.00,'2023-01-16 19:00:46','',''),(79,'1','291','1',1,'Sale Id shift 14',0.00,0.00,0.00,298.16,0.00,'2023-01-16 19:00:46','',''),(80,'1','291','1',1,'Sale Id shift 14',0.00,0.00,0.00,688.66,0.00,'2023-01-16 19:00:46','',''),(81,'1','291',NULL,1,'Sale Id shift 14',378823.16,0.00,0.00,0.00,0.00,'2023-01-16 19:00:46','',''),(82,'1','291','1',1,'Sale Id shift 15',0.00,0.00,0.00,1193.78,0.00,'2023-01-17 07:08:52','',''),(83,'1','291','1',1,'Sale Id shift 15',0.00,0.00,0.00,2328.27,0.00,'2023-01-17 07:08:52','',''),(84,'1','291','1',1,'Sale Id shift 15',0.00,0.00,0.00,10500.04,0.00,'2023-01-17 07:08:52','',''),(85,'1','291','1',1,'Sale Id shift 15',0.00,0.00,0.00,6179.80,0.00,'2023-01-17 07:08:52','',''),(86,'1','291','1',1,'Sale Id shift 15',0.00,0.00,0.00,2084.67,0.00,'2023-01-17 07:08:52','',''),(87,'1','291',NULL,1,'Sale Id shift 15',3967007.68,0.00,0.00,0.00,0.00,'2023-01-17 07:08:52','',''),(88,'1','291',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,31000.00,0.00,'2023-01-17 13:27:35','',''),(89,'1','291','1',1,'Received from bridging 3',0.00,0.00,31000.00,0.00,0.00,'2023-01-17 13:27:35','',''),(90,'1','291','1',1,'Sale Id shift 16',0.00,0.00,0.00,938.85,0.00,'2023-01-17 17:15:43','',''),(91,'1','291','1',1,'Sale Id shift 16',0.00,0.00,0.00,1072.21,0.00,'2023-01-17 17:15:43','',''),(92,'1','291','1',1,'Sale Id shift 16',0.00,0.00,0.00,582.52,0.00,'2023-01-17 17:15:43','',''),(93,'1','291','1',1,'Sale Id shift 16',0.00,0.00,0.00,1460.01,0.00,'2023-01-17 17:15:43','',''),(94,'1','291',NULL,1,'Sale Id shift 16',721539.02,0.00,0.00,0.00,0.00,'2023-01-17 17:15:43','',''),(95,'1','291','1',1,'Sale Id shift 17',0.00,0.00,0.00,2801.50,0.00,'2023-01-17 17:31:14','',''),(96,'1','291','1',1,'Sale Id shift 17',0.00,0.00,0.00,1732.37,0.00,'2023-01-17 17:31:14','',''),(97,'1','291','1',1,'Sale Id shift 17',0.00,0.00,0.00,2237.61,0.00,'2023-01-17 17:31:14','',''),(98,'1','291',NULL,1,'Sale Id shift 17',1205323.44,0.00,0.00,0.00,0.00,'2023-01-17 17:31:14','',''),(99,'1','291','1',1,'Sale Id shift 18',0.00,0.00,0.00,1505.97,0.00,'2023-01-17 17:37:44','',''),(100,'1','291','1',1,'Sale Id shift 18',0.00,0.00,0.00,1941.32,0.00,'2023-01-17 17:37:44','',''),(101,'1','291','1',1,'Sale Id shift 18',0.00,0.00,0.00,1970.96,0.00,'2023-01-17 17:37:44','',''),(102,'1','291','1',1,'Sale Id shift 18',0.00,0.00,0.00,1557.90,0.00,'2023-01-17 17:37:44','',''),(103,'1','291',NULL,1,'Sale Id shift 18',1241754.70,0.00,0.00,0.00,0.00,'2023-01-17 17:37:44','',''),(104,'1','291','1',1,'Sale Id shift 19',0.00,0.00,0.00,393.38,0.00,'2023-01-17 17:42:12','',''),(105,'1','291','1',1,'Sale Id shift 19',0.00,0.00,0.00,2869.22,0.00,'2023-01-17 17:42:12','',''),(106,'1','291','1',1,'Sale Id shift 19',0.00,0.00,0.00,2365.07,0.00,'2023-01-17 17:42:12','',''),(107,'1','291','1',1,'Sale Id shift 19',0.00,0.00,0.00,2052.52,0.00,'2023-01-17 17:42:12','',''),(108,'1','291',NULL,1,'Sale Id shift 19',1367073.82,0.00,0.00,0.00,0.00,'2023-01-17 17:42:12','',''),(109,'1','291','1',1,'Sale Id shift 20',0.00,0.00,0.00,1743.84,0.00,'2023-01-17 17:48:00','',''),(110,'1','291','1',1,'Sale Id shift 20',0.00,0.00,0.00,1763.06,0.00,'2023-01-17 17:48:00','',''),(111,'1','291','1',1,'Sale Id shift 20',0.00,0.00,0.00,2075.11,0.00,'2023-01-17 17:48:00','',''),(112,'1','291','1',1,'Sale Id shift 20',0.00,0.00,0.00,1755.34,0.00,'2023-01-17 17:48:00','',''),(113,'1','291',NULL,1,'Sale Id shift 20',1306048.30,0.00,0.00,0.00,0.00,'2023-01-17 17:48:00','',''),(114,'1','291','1',1,'Sale Id shift 21',0.00,0.00,0.00,897.20,0.00,'2023-01-17 18:19:19','',''),(115,'1','291','1',1,'Sale Id shift 21',0.00,0.00,0.00,3573.77,0.00,'2023-01-17 18:19:19','',''),(116,'1','291','1',1,'Sale Id shift 21',0.00,0.00,0.00,1857.34,0.00,'2023-01-17 18:19:19','',''),(117,'1','291','1',1,'Sale Id shift 21',0.00,0.00,0.00,2653.79,0.00,'2023-01-17 18:19:19','',''),(118,'1','291',NULL,1,'Sale Id shift 21',1598813.80,0.00,0.00,0.00,0.00,'2023-01-17 18:19:19','',''),(119,'1','291','1',1,'Sale Id shift 22',0.00,0.00,0.00,968.35,0.00,'2023-01-17 18:26:18','',''),(120,'1','291','1',1,'Sale Id shift 22',0.00,0.00,0.00,1075.62,0.00,'2023-01-17 18:26:18','',''),(121,'1','291','1',1,'Sale Id shift 22',0.00,0.00,0.00,697.50,0.00,'2023-01-17 18:26:18','',''),(122,'1','291','1',1,'Sale Id shift 22',0.00,0.00,0.00,971.13,0.00,'2023-01-17 18:26:18','',''),(123,'1','291',NULL,1,'Sale Id shift 22',660842.80,0.00,0.00,0.00,0.00,'2023-01-17 18:26:18','',''),(124,'1','291','1',1,'Sale Id shift 23',0.00,0.00,0.00,4649.72,0.00,'2023-01-18 13:46:41','',''),(125,'1','291','1',1,'Sale Id shift 23',0.00,0.00,0.00,1528.74,0.00,'2023-01-18 13:46:41','',''),(126,'1','291','1',1,'Sale Id shift 23',0.00,0.00,0.00,4310.36,0.00,'2023-01-18 13:46:41','',''),(127,'1','291','1',1,'Sale Id shift 23',0.00,0.00,0.00,632.23,0.00,'2023-01-18 13:46:41','',''),(128,'1','291','1',1,'Sale Id shift 23',0.00,0.00,0.00,4156.25,0.00,'2023-01-18 13:46:41','',''),(129,'1','291',NULL,1,'Sale Id shift 23',2719359.40,0.00,0.00,0.00,0.00,'2023-01-18 13:46:41','',''),(130,'1','291','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,5585.61,0.00,'2023-01-18 14:01:15','',''),(131,'1','291','1',0,'Inventory adjustment from tank dipping to 150',0.00,0.00,150.00,0.00,0.00,'2023-01-18 14:01:15','',''),(132,'1','291','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,150.00,0.00,'2023-01-18 21:01:54','',''),(133,'1','291','1',0,'Inventory adjustment from tank dipping to 5600',0.00,0.00,5600.00,0.00,0.00,'2023-01-18 21:01:54','',''),(134,'1','291','1',1,'Sale Id shift 24',0.00,0.00,0.00,1395.15,0.00,'2023-01-18 23:49:45','',''),(135,'1','291','1',1,'Sale Id shift 24',0.00,0.00,0.00,1681.67,0.00,'2023-01-18 23:49:45','',''),(136,'1','291','1',1,'Sale Id shift 24',0.00,0.00,0.00,1058.53,0.00,'2023-01-18 23:49:45','',''),(137,'1','291','1',1,'Sale Id shift 24',0.00,0.00,0.00,1464.48,0.00,'2023-01-18 23:49:45','',''),(138,'1','291',NULL,1,'Sale Id shift 24',996769.74,0.00,0.00,0.00,0.00,'2023-01-18 23:49:45','',''),(139,'1','291',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,11500000.00,50000.00,0.00,0.00,'2023-03-05 07:48:52','',''),(140,'1','291',NULL,1,'Reception corrector for bridging 4',0.00,0.00,0.00,49700.00,0.00,'2023-03-05 10:57:57','',''),(141,'1','291','1',1,'Received from bridging 4',0.00,0.00,49700.00,0.00,0.00,'2023-03-05 10:57:57','',''),(142,'1','291','1',1,'Sale Id shift 25',0.00,0.00,0.00,3196.36,0.00,'2023-03-06 23:16:42','',''),(143,'1','291','1',1,'Sale Id shift 25',0.00,0.00,0.00,2986.55,0.00,'2023-03-06 23:16:42','',''),(144,'1','291','1',1,'Sale Id shift 25',0.00,0.00,0.00,2353.87,0.00,'2023-03-06 23:16:42','',''),(145,'1','291',NULL,1,'Sale Id shift 25',1963459.40,0.00,0.00,0.00,0.00,'2023-03-06 23:16:42','',''),(146,'1','291','1',1,'Sale Id shift 26',0.00,0.00,0.00,2537.90,0.00,'2023-03-08 21:25:28','',''),(147,'1','291','1',1,'Sale Id shift 26',0.00,0.00,0.00,3711.69,0.00,'2023-03-08 21:25:28','',''),(148,'1','291','1',1,'Sale Id shift 26',0.00,0.00,0.00,3088.61,0.00,'2023-03-08 21:25:28','',''),(149,'1','291',NULL,1,'Sale Id shift 26',2147786.00,0.00,0.00,0.00,0.00,'2023-03-08 21:25:28','',''),(150,'1','291','1',1,'Sale Id shift 27',0.00,0.00,0.00,4347.13,0.00,'2023-03-09 10:30:30','',''),(151,'1','291','1',1,'Sale Id shift 27',0.00,0.00,0.00,3497.37,0.00,'2023-03-09 10:30:30','',''),(152,'1','291','1',1,'Sale Id shift 27',0.00,0.00,0.00,3409.96,0.00,'2023-03-09 10:30:30','',''),(153,'1','291',NULL,1,'Sale Id shift 27',2588525.80,0.00,0.00,0.00,0.00,'2023-03-09 10:30:30','',''),(154,'1','291','1',1,'Sale Id shift 28',0.00,0.00,0.00,2758.83,0.00,'2023-03-10 15:47:07','',''),(155,'1','291','1',1,'Sale Id shift 28',0.00,0.00,0.00,3146.12,0.00,'2023-03-10 15:47:07','',''),(156,'1','291','1',1,'Sale Id shift 28',0.00,0.00,0.00,3780.81,0.00,'2023-03-10 15:47:07','',''),(157,'1','291',NULL,1,'Sale Id shift 28',2227724.80,0.00,0.00,0.00,0.00,'2023-03-10 15:47:07','',''),(158,'1','291',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,10350000.00,45000.00,0.00,0.00,'2023-03-11 11:12:58','',''),(159,'1','291','1',1,'Sale Id shift 29',0.00,0.00,0.00,3935.10,0.00,'2023-03-11 11:14:05','',''),(160,'1','291','1',1,'Sale Id shift 29',0.00,0.00,0.00,3009.71,0.00,'2023-03-11 11:14:05','',''),(161,'1','291','1',1,'Sale Id shift 29',0.00,0.00,0.00,2930.20,0.00,'2023-03-11 11:14:05','',''),(162,'1','291',NULL,1,'Sale Id shift 29',2271252.30,0.00,0.00,0.00,0.00,'2023-03-11 11:14:05','',''),(163,'1','291',NULL,1,'Reception corrector for bridging 5',0.00,0.00,0.00,44750.00,0.00,'2023-03-11 11:26:30','',''),(164,'1','291','1',1,'Received from bridging 5',0.00,0.00,44750.00,0.00,0.00,'2023-03-11 11:26:30','',''),(165,'1','291','1',1,'Sale Id shift 30',0.00,0.00,0.00,625.87,0.00,'2023-03-11 11:45:52','',''),(166,'1','291','1',1,'Sale Id shift 30',0.00,0.00,0.00,541.35,0.00,'2023-03-11 11:45:52','',''),(167,'1','291',NULL,1,'Sale Id shift 30',268460.60,0.00,0.00,0.00,0.00,'2023-03-11 11:45:52','',''),(168,'1','291','1',1,'Sale Id shift 31',0.00,0.00,0.00,3739.70,0.00,'2023-03-11 17:02:33','',''),(169,'1','291','1',1,'Sale Id shift 31',0.00,0.00,0.00,3846.69,0.00,'2023-03-11 17:02:33','',''),(170,'1','291','1',1,'Sale Id shift 31',0.00,0.00,0.00,4664.11,0.00,'2023-03-11 17:02:33','',''),(171,'1','291',NULL,1,'Sale Id shift 31',2817615.00,0.00,0.00,0.00,0.00,'2023-03-11 17:02:33','',''),(172,'1','291','1',1,'Sale Id shift 32',0.00,0.00,0.00,3363.17,0.00,'2023-03-13 18:03:45','',''),(173,'1','291','1',1,'Sale Id shift 32',0.00,0.00,0.00,2804.44,0.00,'2023-03-13 18:03:45','',''),(174,'1','291','1',1,'Sale Id shift 32',0.00,0.00,0.00,3671.84,0.00,'2023-03-13 18:03:45','',''),(175,'1','291',NULL,1,'Sale Id shift 32',2263073.50,0.00,0.00,0.00,0.00,'2023-03-13 18:03:45','',''),(176,'1','291','1',1,'Sale Id shift 33',0.00,0.00,0.00,4925.31,0.00,'2023-03-15 07:01:30','',''),(177,'1','291','1',1,'Sale Id shift 33',0.00,0.00,0.00,2786.27,0.00,'2023-03-15 07:01:30','',''),(178,'1','291','1',1,'Sale Id shift 33',0.00,0.00,0.00,6276.49,0.00,'2023-03-15 07:01:30','',''),(179,'1','291',NULL,1,'Sale Id shift 33',3217256.10,0.00,0.00,0.00,0.00,'2023-03-15 07:01:30','',''),(180,'1','291','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,8514.72,0.00,'2023-03-15 08:10:26','',''),(181,'1','291','1',0,'Inventory adjustment from tank dipping to 9040',0.00,0.00,9040.00,0.00,0.00,'2023-03-15 08:10:26','',''),(182,'1','291','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,9040.00,0.00,'2023-03-15 08:23:00','',''),(183,'1','291','1',0,'Inventory adjustment from tank dipping to 9097',0.00,0.00,9097.00,0.00,0.00,'2023-03-15 08:23:00','',''),(184,'1','291','1',1,'Sale Id shift 34',0.00,0.00,0.00,2954.49,0.00,'2023-03-15 09:15:25','',''),(185,'1','291','1',1,'Sale Id shift 34',0.00,0.00,0.00,2662.51,0.00,'2023-03-15 09:15:25','',''),(186,'1','291','1',1,'Sale Id shift 34',0.00,0.00,0.00,3439.54,0.00,'2023-03-15 09:15:25','',''),(187,'1','291',NULL,1,'Sale Id shift 34',2083004.20,0.00,0.00,0.00,0.00,'2023-03-15 09:15:25','',''),(188,'1','291',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,11500000.00,50000.00,0.00,0.00,'2023-03-17 07:48:58','',''),(189,'1','291',NULL,1,'Reception corrector for bridging 6',0.00,0.00,0.00,49750.00,0.00,'2023-03-17 08:59:52','',''),(190,'1','291','1',1,'Received from bridging 6',0.00,0.00,49750.00,0.00,0.00,'2023-03-17 08:59:52','',''),(191,'1','291','1',1,'Sale Id shift 35',0.00,0.00,0.00,2931.68,0.00,'2023-03-17 21:41:43','',''),(192,'1','291','1',1,'Sale Id shift 35',0.00,0.00,0.00,2594.11,0.00,'2023-03-17 21:41:43','',''),(193,'1','291','1',1,'Sale Id shift 35',0.00,0.00,0.00,2925.06,0.00,'2023-03-17 21:41:43','',''),(194,'1','291',NULL,1,'Sale Id shift 35',1943695.50,0.00,0.00,0.00,0.00,'2023-03-17 21:41:43','',''),(195,'1','291','1',1,'Sale Id shift 36',0.00,0.00,0.00,2904.09,0.00,'2023-03-18 18:52:50','',''),(196,'1','291','1',1,'Sale Id shift 36',0.00,0.00,0.00,2457.09,0.00,'2023-03-18 18:52:50','',''),(197,'1','291','1',1,'Sale Id shift 36',0.00,0.00,0.00,2532.17,0.00,'2023-03-18 18:52:50','',''),(198,'1','291',NULL,1,'Sale Id shift 36',1815470.50,0.00,0.00,0.00,0.00,'2023-03-18 18:52:50','',''),(199,'1','291','1',1,'Sale Id shift 37',0.00,0.00,0.00,3369.47,0.00,'2023-03-19 15:29:33','',''),(200,'1','291','1',1,'Sale Id shift 37',0.00,0.00,0.00,2224.37,0.00,'2023-03-19 15:29:33','',''),(201,'1','291','1',1,'Sale Id shift 37',0.00,0.00,0.00,2012.04,0.00,'2023-03-19 15:29:33','',''),(202,'1','291','1',1,'Sale Id shift 37',0.00,0.00,0.00,2792.87,0.00,'2023-03-19 15:29:33','',''),(203,'1','291',NULL,1,'Sale Id shift 37',2391712.50,0.00,0.00,0.00,0.00,'2023-03-19 15:29:33','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'1','291',2,0.00,'2023-03-20 19:48:56'),(2,'1','291',1,23250.84,'2023-03-20 19:48:56');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1,'1','291',1,'Sale Id shift 1',0.00,132430.22,178.00,132430.22,0.00,'2023-01-16 13:07:31'),(2,'1','291',1,'Sale Id shift 2',0.00,461144.60,178.00,461144.60,0.00,'2023-01-16 13:50:19'),(3,'1','291',1,'Sale Id shift 3',0.00,267589.18,178.00,267589.18,0.00,'2023-01-16 14:02:40'),(4,'1','291',1,'Sale Id shift 4',0.00,415279.34,178.00,415279.34,0.00,'2023-01-16 14:20:48'),(5,'1','291',1,'Sale Id shift 5',0.00,324278.62,178.00,324278.62,0.00,'2023-01-16 14:27:30'),(6,'1','291',1,'Sale Id shift 6',0.00,607211.40,178.00,607211.40,0.00,'2023-01-16 14:35:27'),(7,'1','291',1,'Sale Id shift 7',0.00,326112.02,178.00,326112.02,0.00,'2023-01-16 14:42:30'),(8,'1','291',1,'Sale Id shift 8',0.00,44354.04,178.00,44354.04,0.00,'2023-01-16 15:11:37'),(9,'1','291',1,'Sale Id shift 9',0.00,666052.86,178.00,666052.86,0.00,'2023-01-16 17:54:33'),(10,'1','291',1,'Sale Id shift 10',0.00,428136.28,178.00,428136.28,0.00,'2023-01-16 18:05:46'),(11,'1','291',1,'Sale Id shift 11',0.00,604423.92,178.00,604423.92,0.00,'2023-01-16 18:11:50'),(12,'1','291',1,'Sale Id shift 12',0.00,487137.94,178.00,487137.94,0.00,'2023-01-16 18:17:47'),(13,'1','291',1,'Sale Id shift 13',0.00,613024.88,178.00,613024.88,0.00,'2023-01-16 18:25:45'),(14,'1','291',1,'Sale Id shift 14',0.00,378823.16,178.00,378823.16,0.00,'2023-01-16 19:00:46'),(15,'1','291',1,'Sale Id shift 15',0.00,3967007.68,178.00,3967007.68,0.00,'2023-01-17 07:08:52'),(16,'1','291',1,'Sale Id shift 16',0.00,721539.02,178.00,721539.02,0.00,'2023-01-17 17:15:43'),(17,'1','291',1,'Sale Id shift 17',0.00,1205323.44,178.00,1205323.44,0.00,'2023-01-17 17:31:14'),(18,'1','291',1,'Sale Id shift 18',0.00,1241754.70,178.00,1241754.70,0.00,'2023-01-17 17:37:44'),(19,'1','291',1,'Sale Id shift 19',0.00,1367073.82,178.00,1367073.82,0.00,'2023-01-17 17:42:12'),(20,'1','291',1,'Sale Id shift 20',0.00,1306048.30,178.00,1306048.30,0.00,'2023-01-17 17:48:00'),(21,'1','291',1,'Sale Id shift 21',0.00,1598813.80,178.00,1598813.80,0.00,'2023-01-17 18:19:19'),(22,'1','291',1,'Sale Id shift 22',0.00,660842.80,178.00,660842.80,0.00,'2023-01-17 18:26:18'),(23,'1','291',1,'Sale Id shift 23',0.00,2719359.40,178.00,2719359.40,0.00,'2023-01-18 13:46:41'),(24,'1','291',1,'Sale Id shift 24',0.00,996769.74,178.00,996769.74,0.00,'2023-01-18 23:49:45'),(25,'1','291',1,'Sale Id shift 25',0.00,1963459.40,230.00,1963459.40,0.00,'2023-03-06 23:16:42'),(26,'1','291',1,'Sale Id shift 26',0.00,2147786.00,230.00,2147786.00,0.00,'2023-03-08 21:25:28'),(27,'1','291',1,'Sale Id shift 27',0.00,2588525.80,230.00,2588525.80,0.00,'2023-03-09 10:30:30'),(28,'1','291',1,'Sale Id shift 28',0.00,2227724.80,230.00,2227724.80,0.00,'2023-03-10 15:47:07'),(29,'1','291',1,'Sale Id shift 29',0.00,2271252.30,230.00,2271252.30,0.00,'2023-03-11 11:14:05'),(30,'1','291',1,'Sale Id shift 30',0.00,268460.60,230.00,268460.60,0.00,'2023-03-11 11:45:52'),(31,'1','291',1,'Sale Id shift 31',0.00,2817615.00,230.00,2817615.00,0.00,'2023-03-11 17:02:33'),(32,'1','291',1,'Sale Id shift 32',0.00,2263073.50,230.00,2263073.50,0.00,'2023-03-13 18:03:45'),(33,'1','291',1,'Sale Id shift 33',0.00,3217256.10,230.00,3217256.10,0.00,'2023-03-15 07:01:30'),(34,'1','291',1,'Sale Id shift 34',0.00,2083004.20,230.00,2083004.20,0.00,'2023-03-15 09:15:25'),(35,'1','291',1,'Sale Id shift 35',0.00,1943695.50,230.00,1943695.50,0.00,'2023-03-17 21:41:43'),(36,'1','291',1,'Sale Id shift 36',0.00,1815470.50,230.00,1815470.50,0.00,'2023-03-18 18:52:50'),(37,'1','291',1,'Sale Id shift 37',0.00,2391712.50,230.00,2391712.50,0.00,'2023-03-19 15:29:33');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=201 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('1','291',1,'','24','2',0.00,5518000.00,'Purchase Id 3 for 31,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-01-15 21:44:08','',''),('1','291',2,'','supplier','1',5518000.00,0.00,'Purchase Id 3 for 31,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-01-15 21:44:08','',''),('1','291',3,'','24','2',0.00,8010000.00,'Purchase Id 2 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-01-15 21:44:28','',''),('1','291',4,'','supplier','1',8010000.00,0.00,'Purchase Id 2 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-01-15 21:44:28','',''),('1','291',5,'','24','2',0.00,8010000.00,'Purchase Id 1 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-01-15 21:44:51','',''),('1','291',6,'','supplier','1',8010000.00,0.00,'Purchase Id 1 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-01-15 21:44:51','',''),('1','291',7,'','20','4',132430.22,0.00,'Sales from shift 1 on 2023-01-16 13:07:30 ','2023-01-16 13:07:30','',''),('1','291',8,'','6.1','1',0.00,132430.22,'Sales from shift 1 on 2023-01-16 13:07:30 ','2023-01-16 13:07:30','',''),('1','291',9,'','20','4',461144.60,0.00,'Sales from shift 2 on 2023-01-16 13:50:19 ','2023-01-16 13:50:19','',''),('1','291',10,'','6.1','1',0.00,461144.60,'Sales from shift 2 on 2023-01-16 13:50:19 ','2023-01-16 13:50:19','',''),('1','291',11,'','20','4',267589.18,0.00,'Sales from shift 3 on 2023-01-16 14:02:40 ','2023-01-16 14:02:40','',''),('1','291',12,'','6.1','1',0.00,267589.18,'Sales from shift 3 on 2023-01-16 14:02:40 ','2023-01-16 14:02:40','',''),('1','291',13,'','20','4',415279.34,0.00,'Sales from shift 4 on 2023-01-16 14:20:48 ','2023-01-16 14:20:48','',''),('1','291',14,'','6.1','1',0.00,415279.34,'Sales from shift 4 on 2023-01-16 14:20:48 ','2023-01-16 14:20:48','',''),('1','291',15,'','20','4',324278.62,0.00,'Sales from shift 5 on 2023-01-16 14:27:30 ','2023-01-16 14:27:30','',''),('1','291',16,'','6.1','1',0.00,324278.62,'Sales from shift 5 on 2023-01-16 14:27:30 ','2023-01-16 14:27:30','',''),('1','291',17,'','20','4',607211.40,0.00,'Sales from shift 6 on 2023-01-16 14:35:27 ','2023-01-16 14:35:27','',''),('1','291',18,'','6.1','1',0.00,607211.40,'Sales from shift 6 on 2023-01-16 14:35:27 ','2023-01-16 14:35:27','',''),('1','291',19,'','20','4',326112.02,0.00,'Sales from shift 7 on 2023-01-16 14:42:30 ','2023-01-16 14:42:30','',''),('1','291',20,'','6.1','1',0.00,326112.02,'Sales from shift 7 on 2023-01-16 14:42:30 ','2023-01-16 14:42:30','',''),('1','291',21,'','20','4',44354.04,0.00,'Sales from shift 8 on 2023-01-16 15:11:37 ','2023-01-16 15:11:37','',''),('1','291',22,'','6.1','1',0.00,44354.04,'Sales from shift 8 on 2023-01-16 15:11:37 ','2023-01-16 15:11:37','',''),('1','291',23,'','20','4',666052.86,0.00,'Sales from shift 9 on 2023-01-16 17:54:33 ','2023-01-16 17:54:33','',''),('1','291',24,'','6.1','1',0.00,666052.86,'Sales from shift 9 on 2023-01-16 17:54:33 ','2023-01-16 17:54:33','',''),('1','291',25,'','20','4',428136.28,0.00,'Sales from shift 10 on 2023-01-16 18:05:46 ','2023-01-16 18:05:46','',''),('1','291',26,'','6.1','1',0.00,428136.28,'Sales from shift 10 on 2023-01-16 18:05:46 ','2023-01-16 18:05:46','',''),('1','291',27,'','20','4',604423.92,0.00,'Sales from shift 11 on 2023-01-16 18:11:49 ','2023-01-16 18:11:49','',''),('1','291',28,'','6.1','1',0.00,604423.92,'Sales from shift 11 on 2023-01-16 18:11:49 ','2023-01-16 18:11:49','',''),('1','291',29,'','20','4',487137.94,0.00,'Sales from shift 12 on 2023-01-16 18:17:46 ','2023-01-16 18:17:46','',''),('1','291',30,'','6.1','1',0.00,487137.94,'Sales from shift 12 on 2023-01-16 18:17:46 ','2023-01-16 18:17:46','',''),('1','291',31,'','20','4',613024.88,0.00,'Sales from shift 13 on 2023-01-16 18:25:45 ','2023-01-16 18:25:45','',''),('1','291',32,'','6.1','1',0.00,613024.88,'Sales from shift 13 on 2023-01-16 18:25:45 ','2023-01-16 18:25:45','',''),('1','291',33,'','20','4',378823.16,0.00,'Sales from shift 14 on 2023-01-16 19:00:46 ','2023-01-16 19:00:46','',''),('1','291',34,'','6.1','1',0.00,378823.16,'Sales from shift 14 on 2023-01-16 19:00:46 ','2023-01-16 19:00:46','',''),('1','291',35,'','20','4',3967007.68,0.00,'Sales from shift 15 on 2023-01-17 07:08:52 ','2023-01-17 07:08:52','',''),('1','291',36,'','6.1','1',0.00,3967007.68,'Sales from shift 15 on 2023-01-17 07:08:52 ','2023-01-17 07:08:52','',''),('1','291',37,'','20','4',721539.02,0.00,'Sales from shift 16 on 2023-01-17 17:15:43 ','2023-01-17 17:15:43','',''),('1','291',38,'','6.1','1',0.00,721539.02,'Sales from shift 16 on 2023-01-17 17:15:43 ','2023-01-17 17:15:43','',''),('1','291',39,'','20','4',1205323.44,0.00,'Sales from shift 17 on 2023-01-17 17:31:14 ','2023-01-17 17:31:14','',''),('1','291',40,'','6.1','1',0.00,1205323.44,'Sales from shift 17 on 2023-01-17 17:31:14 ','2023-01-17 17:31:14','',''),('1','291',41,'','20','4',1241754.70,0.00,'Sales from shift 18 on 2023-01-17 17:37:44 ','2023-01-17 17:37:44','',''),('1','291',42,'','6.1','1',0.00,1241754.70,'Sales from shift 18 on 2023-01-17 17:37:44 ','2023-01-17 17:37:44','',''),('1','291',43,'','20','4',1367073.82,0.00,'Sales from shift 19 on 2023-01-17 17:42:12 ','2023-01-17 17:42:12','',''),('1','291',44,'','6.1','1',0.00,1367073.82,'Sales from shift 19 on 2023-01-17 17:42:12 ','2023-01-17 17:42:12','',''),('1','291',45,'','20','4',1306048.30,0.00,'Sales from shift 20 on 2023-01-17 17:48:00 ','2023-01-17 17:48:00','',''),('1','291',46,'','6.1','1',0.00,1306048.30,'Sales from shift 20 on 2023-01-17 17:48:00 ','2023-01-17 17:48:00','',''),('1','291',47,'','20','4',1598813.80,0.00,'Sales from shift 21 on 2023-01-17 18:19:19 ','2023-01-17 18:19:19','',''),('1','291',48,'','6.1','1',0.00,1598813.80,'Sales from shift 21 on 2023-01-17 18:19:19 ','2023-01-17 18:19:19','',''),('1','291',49,'','20','4',660842.80,0.00,'Sales from shift 22 on 2023-01-17 18:26:18 ','2023-01-17 18:26:18','',''),('1','291',50,'','6.1','1',0.00,660842.80,'Sales from shift 22 on 2023-01-17 18:26:18 ','2023-01-17 18:26:18','',''),('1','291',51,'','20','4',2719359.40,0.00,'Sales from shift 23 on 2023-01-18 13:46:41 ','2023-01-18 13:46:41','',''),('1','291',52,'','6.1','1',0.00,2719359.40,'Sales from shift 23 on 2023-01-18 13:46:41 ','2023-01-18 13:46:41','',''),('1','291',53,'','20','4',996769.74,0.00,'Sales from shift 24 on 2023-01-18 23:49:45 ','2023-01-18 23:49:45','',''),('1','291',54,'','6.1','1',0.00,996769.74,'Sales from shift 24 on 2023-01-18 23:49:45 ','2023-01-18 23:49:45','',''),('1','291',55,'','2','6',66522.00,0.00,'Payment Id 7 for invoice:2, receipt: 2 by AA RANO NIGERIA LTD','2023-01-19 15:40:57','',''),('1','291',56,'','supplier','1',0.00,66522.00,'Payment Id 7 for invoice:2, receipt: 2 by AA RANO NIGERIA LTD','2023-01-19 15:40:57','',''),('1','291',57,'','2','5',244620.00,0.00,'Payment Id 2 for invoice:2, receipt: 2 by AA RANO NIGERIA LTD','2023-01-19 15:40:57','',''),('1','291',58,'','supplier','1',0.00,244620.00,'Payment Id 2 for invoice:2, receipt: 2 by AA RANO NIGERIA LTD','2023-01-19 15:40:57','',''),('1','291',59,'','2','6',140272.00,0.00,'Payment Id 8 for invoice:3/4, receipt: 3 by AA RANO NIGERIA LTD','2023-01-19 15:47:36','',''),('1','291',60,'','supplier','1',0.00,140272.00,'Payment Id 8 for invoice:3/4, receipt: 3 by AA RANO NIGERIA LTD','2023-01-19 15:47:36','',''),('1','291',61,'','2','5',280360.00,0.00,'Payment Id 4 for invoice:4, receipt: 4 by AA RANO NIGERIA LTD','2023-01-19 15:47:36','',''),('1','291',62,'','supplier','1',0.00,280360.00,'Payment Id 4 for invoice:4, receipt: 4 by AA RANO NIGERIA LTD','2023-01-19 15:47:36','',''),('1','291',63,'','2','5',220740.00,0.00,'Payment Id 3 for invoice:3, receipt: 3 by AA RANO NIGERIA LTD','2023-01-19 15:47:36','',''),('1','291',64,'','supplier','1',0.00,220740.00,'Payment Id 3 for invoice:3, receipt: 3 by AA RANO NIGERIA LTD','2023-01-19 15:47:36','',''),('1','291',65,'','2','6',136300.00,0.00,'Payment Id 9 for invoice:5/6, receipt: 6 by AA RANO NIGERIA LTD','2023-01-19 15:50:50','',''),('1','291',66,'','supplier','1',0.00,136300.00,'Payment Id 9 for invoice:5/6, receipt: 6 by AA RANO NIGERIA LTD','2023-01-19 15:50:50','',''),('1','291',67,'','2','5',551610.00,0.00,'Payment Id 6 for invoice:6, receipt: 6 by AA RANO NIGERIA LTD','2023-01-19 15:50:50','',''),('1','291',68,'','supplier','1',0.00,551610.00,'Payment Id 6 for invoice:6, receipt: 6 by AA RANO NIGERIA LTD','2023-01-19 15:50:50','',''),('1','291',69,'','2','5',25080.00,0.00,'Payment Id 5 for invoice:5, receipt: 5 by AA RANO NIGERIA LTD','2023-01-19 15:50:50','',''),('1','291',70,'','supplier','1',0.00,25080.00,'Payment Id 5 for invoice:5, receipt: 5 by AA RANO NIGERIA LTD','2023-01-19 15:50:50','',''),('1','291',71,'','2','6',64820.00,0.00,'Payment Id 12 for invoice:7/8, receipt: 8 by AA RANO NIGERIA LTD','2023-01-19 16:16:56','',''),('1','291',72,'','supplier','1',0.00,64820.00,'Payment Id 12 for invoice:7/8, receipt: 8 by AA RANO NIGERIA LTD','2023-01-19 16:16:56','',''),('1','291',73,'','2','5',32355.00,0.00,'Payment Id 11 for invoice:8, receipt: 8 by AA RANO NIGERIA LTD','2023-01-19 16:16:56','',''),('1','291',74,'','supplier','1',0.00,32355.00,'Payment Id 11 for invoice:8, receipt: 8 by AA RANO NIGERIA LTD','2023-01-19 16:16:56','',''),('1','291',75,'','2','5',248790.00,0.00,'Payment Id 10 for invoice:7, receipt: 7 by AA RANO NIGERIA LTD','2023-01-19 16:16:56','',''),('1','291',76,'','supplier','1',0.00,248790.00,'Payment Id 10 for invoice:7, receipt: 7 by AA RANO NIGERIA LTD','2023-01-19 16:16:56','',''),('1','291',77,'','2','5',373550.00,0.00,'Payment Id 13 for invoice:9, receipt: 9 by AA RANO NIGERIA LTD','2023-01-19 16:21:43','',''),('1','291',78,'','supplier','1',0.00,373550.00,'Payment Id 13 for invoice:9, receipt: 9 by AA RANO NIGERIA LTD','2023-01-19 16:21:43','',''),('1','291',79,'','2','6',121426.00,0.00,'Payment Id 16 for invoice:10/11, receipt: 11 by AA RANO NIGERIA LTD','2023-01-19 16:22:23','',''),('1','291',80,'','supplier','1',0.00,121426.00,'Payment Id 16 for invoice:10/11, receipt: 11 by AA RANO NIGERIA LTD','2023-01-19 16:22:23','',''),('1','291',81,'','2','5',488700.00,0.00,'Payment Id 15 for invoice:11, receipt: 11 by AA RANO NIGERIA LTD','2023-01-19 16:22:23','',''),('1','291',82,'','supplier','1',0.00,488700.00,'Payment Id 15 for invoice:11, receipt: 11 by AA RANO NIGERIA LTD','2023-01-19 16:22:23','',''),('1','291',83,'','2','5',399830.00,0.00,'Payment Id 14 for invoice:10, receipt: 10 by AA RANO NIGERIA LTD','2023-01-19 16:22:23','',''),('1','291',84,'','supplier','1',0.00,399830.00,'Payment Id 14 for invoice:10, receipt: 10 by AA RANO NIGERIA LTD','2023-01-19 16:22:23','',''),('1','291',85,'','2','6',238800.00,0.00,'Payment Id 39 for invoice:12/13, receipt: 13 by AA RANO NIGERIA LTD','2023-01-19 16:23:36','',''),('1','291',86,'','supplier','1',0.00,238800.00,'Payment Id 39 for invoice:12/13, receipt: 13 by AA RANO NIGERIA LTD','2023-01-19 16:23:36','',''),('1','291',87,'','2','5',440025.00,0.00,'Payment Id 18 for invoice:13, receipt: 13 by AA RANO NIGERIA LTD','2023-01-19 16:23:36','',''),('1','291',88,'','supplier','1',0.00,440025.00,'Payment Id 18 for invoice:13, receipt: 13 by AA RANO NIGERIA LTD','2023-01-19 16:23:36','',''),('1','291',89,'','2','5',382840.00,0.00,'Payment Id 17 for invoice:12, receipt: 12 by AA RANO NIGERIA LTD','2023-01-19 16:23:36','',''),('1','291',90,'','supplier','1',0.00,382840.00,'Payment Id 17 for invoice:12, receipt: 12 by AA RANO NIGERIA LTD','2023-01-19 16:23:36','',''),('1','291',91,'','2','6',211133.00,0.00,'Payment Id 22 for invoice:14/15, receipt: 15 by AA RANO NIGERIA LTD','2023-01-19 16:35:52','',''),('1','291',92,'','supplier','1',0.00,211133.00,'Payment Id 22 for invoice:14/15, receipt: 15 by AA RANO NIGERIA LTD','2023-01-19 16:35:52','',''),('1','291',93,'','2','5',810140.00,0.00,'Payment Id 21 for invoice:15, receipt: 15 by AA RANO NIGERIA LTD','2023-01-19 16:35:52','',''),('1','291',94,'','supplier','1',0.00,810140.00,'Payment Id 21 for invoice:15, receipt: 15 by AA RANO NIGERIA LTD','2023-01-19 16:35:52','',''),('1','291',95,'','2','5',303645.00,0.00,'Payment Id 20 for invoice:14, receipt: 14 by AA RANO NIGERIA LTD','2023-01-19 16:35:52','',''),('1','291',96,'','supplier','1',0.00,303645.00,'Payment Id 20 for invoice:14, receipt: 14 by AA RANO NIGERIA LTD','2023-01-19 16:35:52','',''),('1','291',97,'','2','6',383363.00,0.00,'Payment Id 25 for invoice:16/17, receipt: 17 by AA RANO NIGERIA LTD','2023-01-19 16:37:41','',''),('1','291',98,'','supplier','1',0.00,383363.00,'Payment Id 25 for invoice:16/17, receipt: 17 by AA RANO NIGERIA LTD','2023-01-19 16:37:41','',''),('1','291',99,'','2','5',916470.00,0.00,'Payment Id 24 for invoice:17, receipt: 17 by AA RANO NIGERIA LTD','2023-01-19 16:37:41','',''),('1','291',100,'','supplier','1',0.00,916470.00,'Payment Id 24 for invoice:17, receipt: 17 by AA RANO NIGERIA LTD','2023-01-19 16:37:41','',''),('1','291',101,'','2','5',597035.00,0.00,'Payment Id 23 for invoice:16, receipt: 16 by AA RANO NIGERIA LTD','2023-01-19 16:37:41','',''),('1','291',102,'','supplier','1',0.00,597035.00,'Payment Id 23 for invoice:16, receipt: 16 by AA RANO NIGERIA LTD','2023-01-19 16:37:41','',''),('1','291',103,'','2','7',2937000.00,0.00,'Payment Id 41 for invoice:15, receipt: 15 by AA RANO NIGERIA LTD','2023-01-19 16:39:44','',''),('1','291',104,'','supplier','1',0.00,2937000.00,'Payment Id 41 for invoice:15, receipt: 15 by AA RANO NIGERIA LTD','2023-01-19 16:39:44','',''),('1','291',105,'','2','6',361532.00,0.00,'Payment Id 28 for invoice:18/19, receipt: 19 by AA RANO NIGERIA LTD','2023-01-19 16:42:53','',''),('1','291',106,'','supplier','1',0.00,361532.00,'Payment Id 28 for invoice:18/19, receipt: 19 by AA RANO NIGERIA LTD','2023-01-19 16:42:53','',''),('1','291',107,'','2','5',1130525.00,0.00,'Payment Id 27 for invoice:19, receipt: 19 by AA RANO NIGERIA LTD','2023-01-19 16:42:53','',''),('1','291',108,'','supplier','1',0.00,1130525.00,'Payment Id 27 for invoice:19, receipt: 19 by AA RANO NIGERIA LTD','2023-01-19 16:42:53','',''),('1','291',109,'','2','5',1086770.00,0.00,'Payment Id 26 for invoice:18, receipt: 18 by AA RANO NIGERIA LTD','2023-01-19 16:42:53','',''),('1','291',110,'','supplier','1',0.00,1086770.00,'Payment Id 26 for invoice:18, receipt: 18 by AA RANO NIGERIA LTD','2023-01-19 16:42:53','',''),('1','291',111,'','2','6',507188.00,0.00,'Payment Id 31 for invoice:20/21, receipt: 21 by AA RANO NIGERIA LTD','2023-01-19 16:44:35','',''),('1','291',112,'','supplier','1',0.00,507188.00,'Payment Id 31 for invoice:20/21, receipt: 21 by AA RANO NIGERIA LTD','2023-01-19 16:44:35','',''),('1','291',113,'','2','5',1262840.00,0.00,'Payment Id 30 for invoice:21, receipt: 21 by AA RANO NIGERIA LTD','2023-01-19 16:44:35','',''),('1','291',114,'','supplier','1',0.00,1262840.00,'Payment Id 30 for invoice:21, receipt: 21 by AA RANO NIGERIA LTD','2023-01-19 16:44:35','',''),('1','291',115,'','2','5',1070110.00,0.00,'Payment Id 29 for invoice:20, receipt: 20 by AA RANO NIGERIA LTD','2023-01-19 16:44:35','',''),('1','291',116,'','supplier','1',0.00,1070110.00,'Payment Id 29 for invoice:20, receipt: 20 by AA RANO NIGERIA LTD','2023-01-19 16:44:35','',''),('1','291',117,'','2','6',652348.00,0.00,'Payment Id 40 for invoice:22/23, receipt: 23 by AA RANO NIGERIA LTD','2023-01-19 16:48:35','',''),('1','291',118,'','supplier','1',0.00,652348.00,'Payment Id 40 for invoice:22/23, receipt: 23 by AA RANO NIGERIA LTD','2023-01-19 16:48:35','',''),('1','291',119,'','2','5',31500.00,0.00,'Payment Id 37 for invoice:24, receipt: 24 by AA RANO NIGERIA LTD','2023-01-19 16:48:35','',''),('1','291',120,'','supplier','1',0.00,31500.00,'Payment Id 37 for invoice:24, receipt: 24 by AA RANO NIGERIA LTD','2023-01-19 16:48:35','',''),('1','291',121,'','2','5',2162135.00,0.00,'Payment Id 33 for invoice:23, receipt: 23 by AA RANO NIGERIA LTD','2023-01-19 16:48:35','',''),('1','291',122,'','supplier','1',0.00,2162135.00,'Payment Id 33 for invoice:23, receipt: 23 by AA RANO NIGERIA LTD','2023-01-19 16:48:35','',''),('1','291',123,'','2','5',504700.00,0.00,'Payment Id 32 for invoice:22, receipt: 22 by AA RANO NIGERIA LTD','2023-01-19 16:48:35','',''),('1','291',124,'','supplier','1',0.00,504700.00,'Payment Id 32 for invoice:22, receipt: 22 by AA RANO NIGERIA LTD','2023-01-19 16:48:35','',''),('1','291',125,'','2','6',116620.00,0.00,'Payment Id 38 for invoice:24, receipt: 24 by AA RANO NIGERIA LTD','2023-01-19 16:55:39','',''),('1','291',126,'','supplier','1',0.00,116620.00,'Payment Id 38 for invoice:24, receipt: 24 by AA RANO NIGERIA LTD','2023-01-19 16:55:39','',''),('1','291',127,'','2','5',34190.00,0.00,'Payment Id 36 for invoice:24, receipt: 24 by AA RANO NIGERIA LTD','2023-01-19 16:55:39','',''),('1','291',128,'','supplier','1',0.00,34190.00,'Payment Id 36 for invoice:24, receipt: 24 by AA RANO NIGERIA LTD','2023-01-19 16:55:39','',''),('1','291',129,'','2','5',793975.00,0.00,'Payment Id 35 for invoice:24, receipt: 24 by AA RANO NIGERIA LTD','2023-01-19 16:55:39','',''),('1','291',130,'','supplier','1',0.00,793975.00,'Payment Id 35 for invoice:24, receipt: 24 by AA RANO NIGERIA LTD','2023-01-19 16:55:39','',''),('1','291',131,'','2','7',10000.00,0.00,'Payment Id 44 for invoice:20, receipt: 20 by AA RANO NIGERIA LTD','2023-01-20 15:13:17','',''),('1','291',132,'','supplier','1',0.00,10000.00,'Payment Id 44 for invoice:20, receipt: 20 by AA RANO NIGERIA LTD','2023-01-20 15:13:17','',''),('1','291',133,'','2','7',136000.00,0.00,'Payment Id 43 for invoice:5, receipt: 5 by AA RANO NIGERIA LTD','2023-01-20 15:13:17','',''),('1','291',134,'','supplier','1',0.00,136000.00,'Payment Id 43 for invoice:5, receipt: 5 by AA RANO NIGERIA LTD','2023-01-20 15:13:17','',''),('1','291',135,'','2','7',150000.00,0.00,'Payment Id 42 for invoice:2, receipt: 2 by AA RANO NIGERIA LTD','2023-01-20 15:13:17','',''),('1','291',136,'','supplier','1',0.00,150000.00,'Payment Id 42 for invoice:2, receipt: 2 by AA RANO NIGERIA LTD','2023-01-20 15:13:17','',''),('1','291',137,'','24','2',0.00,11500000.00,'Purchase Id 4 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-05 07:48:52','',''),('1','291',138,'','supplier','1',11500000.00,0.00,'Purchase Id 4 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-05 07:48:52','',''),('1','291',139,'','20','4',1963459.40,0.00,'Sales from shift 25 on 2023-03-06 23:16:42 ','2023-03-06 23:16:42','',''),('1','291',140,'','6.1','1',0.00,1963459.40,'Sales from shift 25 on 2023-03-06 23:16:42 ','2023-03-06 23:16:42','',''),('1','291',141,'','20','4',2147786.00,0.00,'Sales from shift 26 on 2023-03-08 21:25:28 ','2023-03-08 21:25:28','',''),('1','291',142,'','6.1','1',0.00,2147786.00,'Sales from shift 26 on 2023-03-08 21:25:28 ','2023-03-08 21:25:28','',''),('1','291',143,'','20','4',2588525.80,0.00,'Sales from shift 27 on 2023-03-09 10:30:30 ','2023-03-09 10:30:30','',''),('1','291',144,'','6.1','1',0.00,2588525.80,'Sales from shift 27 on 2023-03-09 10:30:30 ','2023-03-09 10:30:30','',''),('1','291',145,'','20','4',2227724.80,0.00,'Sales from shift 28 on 2023-03-10 15:47:07 ','2023-03-10 15:47:07','',''),('1','291',146,'','6.1','1',0.00,2227724.80,'Sales from shift 28 on 2023-03-10 15:47:07 ','2023-03-10 15:47:07','',''),('1','291',147,'','24','2',0.00,10350000.00,'Purchase Id 5 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-11 11:12:58','',''),('1','291',148,'','supplier','1',10350000.00,0.00,'Purchase Id 5 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-11 11:12:58','',''),('1','291',149,'','20','4',2271252.30,0.00,'Sales from shift 29 on 2023-03-11 11:14:05 ','2023-03-11 11:14:05','',''),('1','291',150,'','6.1','1',0.00,2271252.30,'Sales from shift 29 on 2023-03-11 11:14:05 ','2023-03-11 11:14:05','',''),('1','291',151,'','20','4',268460.60,0.00,'Sales from shift 30 on 2023-03-11 11:45:52 ','2023-03-11 11:45:52','',''),('1','291',152,'','6.1','1',0.00,268460.60,'Sales from shift 30 on 2023-03-11 11:45:52 ','2023-03-11 11:45:52','',''),('1','291',153,'','6.1','1',24450.00,0.00,'Payment Id 47 for invoice:25, receipt: 26 by AA RANO NIGERIA LTD','2023-03-11 11:59:30','',''),('1','291',154,'','supplier','1',0.00,24450.00,'Payment Id 47 for invoice:25, receipt: 26 by AA RANO NIGERIA LTD','2023-03-11 11:59:30','',''),('1','291',155,'','2','6',1915660.00,0.00,'Payment Id 46 for invoice:25, receipt: 11 by AA RANO NIGERIA LTD','2023-03-11 11:59:30','',''),('1','291',156,'','supplier','1',0.00,1915660.00,'Payment Id 46 for invoice:25, receipt: 11 by AA RANO NIGERIA LTD','2023-03-11 11:59:30','',''),('1','291',157,'','2','5',23350.00,0.00,'Payment Id 45 for invoice:25, receipt: 111 by AA RANO NIGERIA LTD','2023-03-11 11:59:30','',''),('1','291',158,'','supplier','1',0.00,23350.00,'Payment Id 45 for invoice:25, receipt: 111 by AA RANO NIGERIA LTD','2023-03-11 11:59:30','',''),('1','291',159,'','2','5',46520.00,0.00,'Payment Id 52 for invoice:27, receipt: 27 by AA RANO NIGERIA LTD','2023-03-11 12:21:16','',''),('1','291',160,'','supplier','1',0.00,46520.00,'Payment Id 52 for invoice:27, receipt: 27 by AA RANO NIGERIA LTD','2023-03-11 12:21:16','',''),('1','291',161,'','2','6',4522062.00,0.00,'Payment Id 51 for invoice:26/27, receipt: 26 by AA RANO NIGERIA LTD','2023-03-11 12:21:16','',''),('1','291',162,'','supplier','1',0.00,4522062.00,'Payment Id 51 for invoice:26/27, receipt: 26 by AA RANO NIGERIA LTD','2023-03-11 12:21:16','',''),('1','291',163,'','2','6',268435.00,0.00,'Payment Id 54 for invoice:30, receipt: 30 by AA RANO NIGERIA LTD','2023-03-11 12:22:32','',''),('1','291',164,'','supplier','1',0.00,268435.00,'Payment Id 54 for invoice:30, receipt: 30 by AA RANO NIGERIA LTD','2023-03-11 12:22:32','',''),('1','291',165,'','2','6',4240027.00,0.00,'Payment Id 53 for invoice:28/29, receipt: 29 by AA RANO NIGERIA LTD','2023-03-11 12:24:34','',''),('1','291',166,'','supplier','1',0.00,4240027.00,'Payment Id 53 for invoice:28/29, receipt: 29 by AA RANO NIGERIA LTD','2023-03-11 12:24:34','',''),('1','291',167,'','20','4',2817615.00,0.00,'Sales from shift 31 on 2023-03-11 17:02:33 ','2023-03-11 17:02:33','',''),('1','291',168,'','6.1','1',0.00,2817615.00,'Sales from shift 31 on 2023-03-11 17:02:33 ','2023-03-11 17:02:33','',''),('1','291',169,'','2','5',260700.00,0.00,'Payment Id 55 for invoice:28, receipt: 28 by AA RANO NIGERIA LTD','2023-03-13 16:02:00','',''),('1','291',170,'','supplier','1',0.00,260700.00,'Payment Id 55 for invoice:28, receipt: 28 by AA RANO NIGERIA LTD','2023-03-13 16:02:00','',''),('1','291',171,'','6.1','1',146700.00,0.00,'Payment Id 49 for invoice:26, receipt: 26 by AA RANO NIGERIA LTD','2023-03-13 16:29:16','',''),('1','291',172,'','supplier','1',0.00,146700.00,'Payment Id 49 for invoice:26, receipt: 26 by AA RANO NIGERIA LTD','2023-03-13 16:29:16','',''),('1','291',173,'','20','4',2263073.50,0.00,'Sales from shift 32 on 2023-03-13 18:03:45 ','2023-03-13 18:03:45','',''),('1','291',174,'','6.1','1',0.00,2263073.50,'Sales from shift 32 on 2023-03-13 18:03:45 ','2023-03-13 18:03:45','',''),('1','291',175,'','20','4',3217256.10,0.00,'Sales from shift 33 on 2023-03-15 07:01:30 ','2023-03-15 07:01:30','',''),('1','291',176,'','6.1','1',0.00,3217256.10,'Sales from shift 33 on 2023-03-15 07:01:30 ','2023-03-15 07:01:30','',''),('1','291',177,'','20','4',2083004.20,0.00,'Sales from shift 34 on 2023-03-15 09:15:25 ','2023-03-15 09:15:25','',''),('1','291',178,'','6.1','1',0.00,2083004.20,'Sales from shift 34 on 2023-03-15 09:15:25 ','2023-03-15 09:15:25','',''),('1','291',179,'','2','5',15185.00,0.00,'Payment Id 57 for invoice:31, receipt: 31 by AA RANO NIGERIA LTD','2023-03-15 13:15:52','',''),('1','291',180,'','supplier','1',0.00,15185.00,'Payment Id 57 for invoice:31, receipt: 31 by AA RANO NIGERIA LTD','2023-03-15 13:15:52','',''),('1','291',181,'','2','5',20030.00,0.00,'Payment Id 56 for invoice:27, receipt: 27 by AA RANO NIGERIA LTD','2023-03-15 13:15:53','',''),('1','291',182,'','supplier','1',0.00,20030.00,'Payment Id 56 for invoice:27, receipt: 27 by AA RANO NIGERIA LTD','2023-03-15 13:15:53','',''),('1','291',183,'','6.1','1',49800.00,0.00,'Payment Id 60 for invoice:33, receipt: 33 by AA RANO NIGERIA LTD','2023-03-15 13:20:21','',''),('1','291',184,'','supplier','1',0.00,49800.00,'Payment Id 60 for invoice:33, receipt: 33 by AA RANO NIGERIA LTD','2023-03-15 13:20:21','',''),('1','291',185,'','2','8',57500.00,0.00,'Payment Id 62 for invoice:33, receipt: 33 by AA RANO NIGERIA LTD','2023-03-16 13:45:20','',''),('1','291',186,'','supplier','1',0.00,57500.00,'Payment Id 62 for invoice:33, receipt: 33 by AA RANO NIGERIA LTD','2023-03-16 13:45:20','',''),('1','291',187,'','2','8',69000.00,0.00,'Payment Id 61 for invoice:3, receipt: 3 by AA RANO NIGERIA LTD','2023-03-16 13:45:20','',''),('1','291',188,'','supplier','1',0.00,69000.00,'Payment Id 61 for invoice:3, receipt: 3 by AA RANO NIGERIA LTD','2023-03-16 13:45:20','',''),('1','291',189,'','24','2',0.00,11500000.00,'Purchase Id 6 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-17 07:48:58','',''),('1','291',190,'','supplier','1',11500000.00,0.00,'Purchase Id 6 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-17 07:48:58','',''),('1','291',191,'','20','4',1943695.50,0.00,'Sales from shift 35 on 2023-03-17 21:41:43 ','2023-03-17 21:41:43','',''),('1','291',192,'','6.1','1',0.00,1943695.50,'Sales from shift 35 on 2023-03-17 21:41:43 ','2023-03-17 21:41:43','',''),('1','291',193,'','20','4',1815470.50,0.00,'Sales from shift 36 on 2023-03-18 18:52:50 ','2023-03-18 18:52:50','',''),('1','291',194,'','6.1','1',0.00,1815470.50,'Sales from shift 36 on 2023-03-18 18:52:50 ','2023-03-18 18:52:50','',''),('1','291',195,'','20','4',2391712.50,0.00,'Sales from shift 37 on 2023-03-19 15:29:32 ','2023-03-19 15:29:32','',''),('1','291',196,'','6.1','1',0.00,2391712.50,'Sales from shift 37 on 2023-03-19 15:29:32 ','2023-03-19 15:29:32','',''),('1','291',197,'','2','5',23970.00,0.00,'Payment Id 64 for invoice:35, receipt: 35 by AA RANO NIGERIA LTD','2023-03-20 18:18:44','',''),('1','291',198,'','supplier','1',0.00,23970.00,'Payment Id 64 for invoice:35, receipt: 35 by AA RANO NIGERIA LTD','2023-03-20 18:18:44','',''),('1','291',199,'','2','5',92250.00,0.00,'Payment Id 66 for invoice:36, receipt: 36 by AA RANO NIGERIA LTD','2023-03-20 18:20:42','',''),('1','291',200,'','supplier','1',0.00,92250.00,'Payment Id 66 for invoice:36, receipt: 36 by AA RANO NIGERIA LTD','2023-03-20 18:20:42','','');
/*!40000 ALTER TABLE `ledgers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `options`
--

DROP TABLE IF EXISTS `options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `options` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` bigint NOT NULL,
  `station_id` bigint NOT NULL,
  `option_key` varchar(200) NOT NULL,
  `option_value` longtext,
  `thedate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `station_id` (`station_id`,`option_key`),
  KEY `company_id` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `options`
--

LOCK TABLES `options` WRITE;
/*!40000 ALTER TABLE `options` DISABLE KEYS */;
/*!40000 ALTER TABLE `options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `measurement` varchar(20) NOT NULL,
  `quantity2` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`code`,`name`,`measurement`,`quantity2`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `cleanup` (`cleanup`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'1','291','PMS','Petrol','Litres',0,230.00,230.00,230.00,230.00,0.00,0,'2022-10-19 10:22:35','178','178','2022-10-19 10:22:35',0),(2,'1','291','AGO','Diesel','Litres',0,0.00,0.00,0.00,0.00,0.00,0,'2022-10-19 10:24:23','178','178','2022-10-19 10:24:23',0);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_changevalues`
--

DROP TABLE IF EXISTS `products_changevalues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_changevalues` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `change_id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity` bigint NOT NULL,
  `oldrate` decimal(20,2) NOT NULL,
  `newrate` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`change_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_changevalues`
--

LOCK TABLES `products_changevalues` WRITE;
/*!40000 ALTER TABLE `products_changevalues` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_changevalues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_prices`
--

DROP TABLE IF EXISTS `products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_prices`
--

LOCK TABLES `products_prices` WRITE;
/*!40000 ALTER TABLE `products_prices` DISABLE KEYS */;
INSERT INTO `products_prices` VALUES (1,'1','291',1,178.00,178.00,178.00,178.00,'INITIAL PRICE','2022-12-31 18:49:07','973'),(2,'1','291',1,230.00,230.00,230.00,230.00,'NEW PRECI OF PMS','2023-03-04 15:00:54','973');
/*!40000 ALTER TABLE `products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_reconciliations`
--

DROP TABLE IF EXISTS `products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_reconciliations`
--

LOCK TABLES `products_reconciliations` WRITE;
/*!40000 ALTER TABLE `products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_shortages`
--

DROP TABLE IF EXISTS `products_shortages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_shortages` (
  `shortage_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shortagedate` date NOT NULL,
  `product_id` varchar(10) NOT NULL,
  `type` int NOT NULL DEFAULT '0',
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`shortage_id`),
  KEY `companycode` (`company_id`,`shortagedate`,`product_id`,`rate`,`quantity`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_shortages`
--

LOCK TABLES `products_shortages` WRITE;
/*!40000 ALTER TABLE `products_shortages` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_shortages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pts_nozzles`
--

DROP TABLE IF EXISTS `pts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pts_nozzles` (
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pts_id` int NOT NULL,
  `pump` varchar(20) NOT NULL,
  `code` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `last_volume` decimal(20,2) NOT NULL,
  `last_price` decimal(20,2) NOT NULL,
  `last_amount` decimal(20,2) NOT NULL,
  `last_transaction` int NOT NULL DEFAULT '0',
  `total_volume` decimal(20,2) NOT NULL,
  `total_amount` decimal(20,2) NOT NULL,
  `total_transactions` decimal(20,2) NOT NULL,
  `lastconnect` datetime NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `terminal_id` (`pts_id`,`pump`,`code`,`lastconnect`),
  KEY `companycode` (`company_id`,`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pts_nozzles`
--

LOCK TABLES `pts_nozzles` WRITE;
/*!40000 ALTER TABLE `pts_nozzles` DISABLE KEYS */;
/*!40000 ALTER TABLE `pts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases`
--

DROP TABLE IF EXISTS `purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases`
--

LOCK TABLES `purchases` WRITE;
/*!40000 ALTER TABLE `purchases` DISABLE KEYS */;
INSERT INTO `purchases` VALUES (1,'1','291','2022-10-07',1,1,178.00,45000.00,0.00,0.00,8010000.00,0.00,'','21170','LAU 417 XA','','','','2023-01-15 14:18:45',15,'PURCHASE OF PMS','973','','0000-00-00 00:00:00','648','2023-01-15 21:44:51'),(2,'1','291','2022-10-07',1,1,178.00,45000.00,0.00,0.00,8010000.00,0.00,'','21171','JJJ 475 XU','','','','2023-01-15 14:22:39',15,'PURCHACHASE OF PMS','973','','0000-00-00 00:00:00','648','2023-01-15 21:44:28'),(3,'1','291','2022-10-13',1,1,178.00,31000.00,0.00,0.00,5518000.00,0.00,'','21172','BAL 484 XA','','','','2023-01-15 14:27:06',15,'PURCHASE OF PMS','973','','0000-00-00 00:00:00','648','2023-01-15 21:44:08'),(4,'1','291','2023-03-03',1,1,230.00,50000.00,0.00,0.00,11500000.00,0.00,'','3/2/23','RAN 946 XA','','','','2023-03-04 15:05:29',10,'PURCHASES OF PMS','973','','0000-00-00 00:00:00','648','2023-03-05 07:48:52'),(5,'1','291','2023-03-10',1,1,230.00,45000.00,0.00,0.00,10350000.00,0.00,'','2008285','RAN 831 XA','','','','2023-03-11 10:53:49',10,'PURCHASES OF PMS','973','','0000-00-00 00:00:00','648','2023-03-11 11:12:58'),(6,'1','291','2023-03-16',1,1,230.00,50000.00,0.00,0.00,11500000.00,0.00,'','1','RAN 920 XA','','','','2023-03-16 20:13:35',10,'PURCHASES OF PMS','973','','0000-00-00 00:00:00','648','2023-03-17 07:48:58');
/*!40000 ALTER TABLE `purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_payments`
--

DROP TABLE IF EXISTS `purchases_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `supplier_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`supplier_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=70 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_payments`
--

LOCK TABLES `purchases_payments` WRITE;
/*!40000 ALTER TABLE `purchases_payments` DISABLE KEYS */;
INSERT INTO `purchases_payments` VALUES (1,'1','291','2022-10-15',1,'1','','2',132430.00,'1','','','','','',132430.22,'2023-01-16 13:04:23',0,'GIVE AWAY','973','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(2,'1','291','2022-10-15',1,'2','','5',244620.00,'2','','','5','AARS703','0792532',461144.60,'2023-01-18 14:09:07',5,'PAYMENT ON ACCOUNT','973','975','2023-01-19 11:44:04','975','2023-01-19 15:40:57'),(3,'1','291','2022-10-16',1,'3','','5',220740.00,'3','','','5','AARS703','0792533',267589.18,'2023-01-18 14:12:53',5,'PAYMENT ON ACCOUNT','973','','0000-00-00 00:00:00','975','2023-01-19 15:47:36'),(4,'1','291','2022-10-16',1,'4','','5',280360.00,'4','','','5','AARS703','0792534',415279.34,'2023-01-18 14:17:54',5,'PAYMENT ON ACCOUNT','973','','0000-00-00 00:00:00','975','2023-01-19 15:47:36'),(5,'1','291','2022-10-17',1,'5','','5',25080.00,'5','','','5','AARS703','0792535',324278.62,'2023-01-18 14:22:42',5,'PAYMENT ON ACCOUNT','973','','0000-00-00 00:00:00','975','2023-01-19 15:50:50'),(6,'1','291','2022-10-17',1,'6','','5',551610.00,'6','','','5','AARS703','0751102',607211.40,'2023-01-18 14:25:38',5,'PAYMENT ON ACCOUNT','973','975','2023-01-19 15:49:40','975','2023-01-19 15:50:50'),(7,'1','291','2022-10-15',1,'2','','5',66522.00,'2','','','6','AARS703','0000',0.00,'2023-01-18 14:30:28',5,'P0S PAYMENT','973','975','2023-01-19 15:40:16','975','2023-01-19 15:40:57'),(8,'1','291','2022-10-16',1,'3','','10',140272.00,'3/4','','','6','AARS703','000',0.00,'2023-01-18 14:45:13',5,'P0S PAYMENT','973','','0000-00-00 00:00:00','975','2023-01-19 15:47:36'),(9,'1','291','2022-10-17',1,'6','','10',136300.00,'5/6','','','6','AARS703','0001',0.00,'2023-01-18 14:50:30',5,'POS PAYMENT','973','','0000-00-00 00:00:00','975','2023-01-19 15:50:50'),(10,'1','291','2022-10-18',1,'7','','5',248790.00,'7','','','5','AARS703','0751101',326112.02,'2023-01-18 15:02:01',5,'PAYMENT ON ACCOUNT','973','','0000-00-00 00:00:00','975','2023-01-19 16:16:56'),(11,'1','291','2022-10-18',1,'8','','5',32355.00,'8','','','5','AARS703','0751103',44354.04,'2023-01-18 15:06:31',5,'PAYMENT ON ACCOUNT','973','975','2023-01-19 16:15:11','975','2023-01-19 16:16:56'),(12,'1','291','2022-10-18',1,'8','','5',64820.00,'7/8','','','6','AARS703','001',0.00,'2023-01-18 15:09:11',5,'POS PAYMENT','973','975','2023-01-19 16:15:46','975','2023-01-19 16:16:56'),(13,'1','291','2022-10-21',1,'9','','5',373550.00,'9','','','5','AARS703','0751104',666052.86,'2023-01-18 15:15:35',5,'PAYMENT ON ACCOUNT','973','975','2023-01-19 16:19:42','975','2023-01-19 16:21:43'),(14,'1','291','2022-10-22',1,'10','','5',399830.00,'10','','','5','AARS703','0751105',428136.28,'2023-01-18 15:18:57',5,'PAYMENT ON ACCOUNT','973','','0000-00-00 00:00:00','975','2023-01-19 16:22:23'),(15,'1','291','2022-10-22',1,'11','','5',488700.00,'11','','','5','AARS703','0751106',604423.92,'2023-01-18 15:21:51',5,'PAYMENT ON ACCOUNT','973','975','2023-01-19 16:20:16','975','2023-01-19 16:22:23'),(16,'1','291','2022-10-22',1,'11','','5',121426.00,'10/11','','','6','AARS703','POS',0.00,'2023-01-18 15:24:18',5,'POS PAYMENT','973','975','2023-01-19 16:20:55','975','2023-01-19 16:22:23'),(17,'1','291','2022-10-23',1,'12','','5',382840.00,'12','','','5','AARS703','2203031',487137.94,'2023-01-18 15:27:05',5,'PAYMENT ON ACCOUNT','973','','0000-00-00 00:00:00','975','2023-01-19 16:23:36'),(18,'1','291','2022-10-23',1,'13','','5',440025.00,'13','','','5','AARS703','0751108',613024.88,'2023-01-18 15:28:45',5,'PAYMENT ON ACCOUNT','973','','0000-00-00 00:00:00','975','2023-01-19 16:23:36'),(20,'1','291','2022-10-24',1,'14','','5',303645.00,'14','','','5','AARS703','0751109',378823.16,'2023-01-18 15:35:40',5,'PAYMENT ON ACCOUNT','973','','0000-00-00 00:00:00','975','2023-01-19 16:35:52'),(21,'1','291','2022-10-24',1,'15','','5',810140.00,'15','','','5','AARS703','0751110',3967007.68,'2023-01-18 15:37:40',5,'PAYMENT ON ACCOUNT','973','','0000-00-00 00:00:00','975','2023-01-19 16:35:52'),(22,'1','291','2022-10-24',1,'15','','5',211133.00,'14/15','','','6','AARS703','POS',0.00,'2023-01-18 15:40:02',5,'POS PAYMENT','973','975','2023-01-19 16:32:54','975','2023-01-19 16:35:52'),(23,'1','291','2022-10-25',1,'16','','5',597035.00,'16','','','5','AARS703','0751111',721539.02,'2023-01-18 15:41:55',5,'PAYMENT ON ACCOUNT','973','','0000-00-00 00:00:00','975','2023-01-19 16:37:41'),(24,'1','291','2022-10-25',1,'17','','5',916470.00,'17','','','5','AARS703','0751118',1205323.44,'2023-01-18 15:44:16',5,'PAYMENT ON ACCOUNT','973','','0000-00-00 00:00:00','975','2023-01-19 16:37:41'),(25,'1','291','2022-10-25',1,'17','','5',383363.00,'16/17','','','6','AAR5703','POS',0.00,'2023-01-18 15:54:27',5,'POS PAYMENTS','973','975','2023-01-19 16:36:36','975','2023-01-19 16:37:41'),(26,'1','291','2022-10-26',1,'18','','5',1086770.00,'18','','','5','AAR5703','0751114',1241754.70,'2023-01-18 16:00:03',5,'PAYMENT ON ACCOUNT','973','','0000-00-00 00:00:00','975','2023-01-19 16:42:53'),(27,'1','291','2022-10-26',1,'19','','5',1130525.00,'19','','','5','AAR5703','0751115',1367073.82,'2023-01-18 16:29:13',5,'PAYMENT ON ACCOUNT','973','975','2023-01-19 16:42:03','975','2023-01-19 16:42:53'),(28,'1','291','2022-10-26',1,'19','','5',361532.00,'18/19','','','6','AAR5703','006',0.00,'2023-01-18 16:34:49',5,'POS PAYMENTS','973','975','2023-01-19 16:38:36','975','2023-01-19 16:42:53'),(29,'1','291','2022-10-27',1,'20','','5',1070110.00,'20','','','5','AAR5703','0751116',1306048.30,'2023-01-18 16:38:02',5,'PAYMENT ON ACCOUNT','973','','0000-00-00 00:00:00','975','2023-01-19 16:44:35'),(30,'1','291','2022-10-27',1,'21','','5',1262840.00,'21','','','5','AAR5703','0751117',1598813.80,'2023-01-18 16:41:06',5,'PAYMENT ON ACCOUNT','973','','0000-00-00 00:00:00','975','2023-01-19 16:44:35'),(31,'1','291','2022-10-27',1,'21','','5',507188.00,'20/21','','','6','AAR5703','007',0.00,'2023-01-18 16:44:01',5,'POS PAYMENTS','973','975','2023-01-19 16:43:42','975','2023-01-19 16:44:35'),(32,'1','291','2022-10-28',1,'22','','5',504700.00,'22','','','5','AAR5703','0751119',660842.80,'2023-01-18 16:48:16',5,'PAYMENT ON ACCOUNT','973','','0000-00-00 00:00:00','975','2023-01-19 16:48:35'),(33,'1','291','2022-10-28',1,'23','','5',2162135.00,'23','','','5','AAR5703','0751121',2719359.40,'2023-01-18 16:50:43',5,'PAYMENT ON ACCOUNT','973','','0000-00-00 00:00:00','975','2023-01-19 16:48:35'),(35,'1','291','2022-10-29',1,'24','','5',793975.00,'24','','','5','AAR5703','0751123',996769.74,'2023-01-19 12:03:49',5,'PAYMENT ON ACCOUNT','973','975','2023-01-19 16:53:37','975','2023-01-19 16:55:39'),(36,'1','291','2022-10-29',1,'24','','5',34190.00,'24','','','5','AAR5703','0751124',0.00,'2023-01-19 12:06:33',5,'PAYMENT ON ACCOUNT','973','975','2023-01-19 16:53:19','975','2023-01-19 16:55:39'),(37,'1','291','2022-10-28',1,'24','','5',31500.00,'24','','','5','AAR5703','07511118',0.00,'2023-01-19 12:09:34',5,'PAYMENT ON ACCOUNT','973','975','2023-01-19 16:47:27','975','2023-01-19 16:48:35'),(38,'1','291','2022-10-29',1,'24','','10',116620.00,'24','','','6','AAR5703','009',0.00,'2023-01-19 12:11:48',5,'P0S PAYMENT','973','','0000-00-00 00:00:00','975','2023-01-19 16:55:39'),(39,'1','291','2022-10-23',1,'13','','10',238800.00,'12/13','','','6','AAR5703','00001',0.00,'2023-01-19 13:02:19',5,'POS PAYMENT','973','','0000-00-00 00:00:00','975','2023-01-19 16:23:36'),(40,'1','291','2022-10-28',1,'23','','5',652348.00,'22/23','','','6','AAR5703','00002',0.00,'2023-01-19 13:04:39',5,'POS PAYMENT','973','975','2023-01-19 16:46:06','975','2023-01-19 16:48:35'),(41,'1','291','2022-10-24',1,'15','','5',2937000.00,'15','','','7','AAR5703','15',0.00,'2023-01-19 16:36:58',5,'DIRECT TRANSFER TO C0MPANY ACCOUNT','973','975','2023-01-19 16:38:53','975','2023-01-19 16:39:44'),(42,'1','291','2023-01-19',1,'2','','5',150000.00,'2','','','7','AAR5703','00',0.00,'2023-01-20 14:52:59',5,'Direct Transfer to Company Account','973','','0000-00-00 00:00:00','975','2023-01-20 15:13:17'),(43,'1','291','2023-01-19',1,'5','','5',136000.00,'5','','','7','AAR5703','002',0.00,'2023-01-20 14:56:46',5,'Direct Transfer To Company Account','973','','0000-00-00 00:00:00','975','2023-01-20 15:13:17'),(44,'1','291','2023-01-19',1,'20','','5',10000.00,'20','','','7','AAR5703','003',0.00,'2023-01-20 14:58:47',5,'Direct Transfer To Company Account.','973','','0000-00-00 00:00:00','975','2023-01-20 15:13:17'),(45,'1','291','2023-03-04',1,'111','','5',23350.00,'25','','','5','AAR5703','9751126',1963459.40,'2023-03-07 12:59:41',5,'PAYMENT ON ACCOUNT','973','975','2023-03-07 16:59:09','975','2023-03-11 11:59:30'),(46,'1','291','2023-03-04',1,'11','','5',1915660.00,'25','','','6','AAR5703','26',0.00,'2023-03-07 13:12:21',5,'PAYMENT ON ACCOUNT ','973','975','2023-03-07 16:59:31','975','2023-03-11 11:59:30'),(47,'1','291','2023-03-04',1,'26','','2',24450.00,'25','','','','','',0.00,'2023-03-07 13:16:02',5,'AGO FOR GENERATOR 30 LTRE@815 ','973','975','2023-03-07 17:00:14','975','2023-03-11 11:59:30'),(49,'1','291','2023-03-05',1,'26','','2',146700.00,'26','','','','','',0.00,'2023-03-07 13:20:37',5,'AGO FOR GENERATOR 180 LTRS FOR 6 DAYS @815','973','975','2023-03-07 17:00:55','975','2023-03-13 16:29:16'),(51,'1','291','2023-03-05',1,'26','','10',4522062.00,'26/27','','','6','AAR5703','00.00',2147786.00,'2023-03-11 11:49:44',5,'PAYMENT ON ACCOUNT','973','','0000-00-00 00:00:00','975','2023-03-11 12:21:16'),(52,'1','291','2023-03-05',1,'27','','5',46520.00,'27','','','5','AAR5703','9751127',2588525.80,'2023-03-11 11:52:23',5,'PAYMENT ON ACCOUNT','973','','0000-00-00 00:00:00','975','2023-03-11 12:21:16'),(53,'1','291','2023-03-06',1,'29','','10',4240027.00,'28/29','','','6','AAR5703','28',2227724.80,'2023-03-11 11:55:07',5,'PAYMENT ON ACCOUNT','973','','0000-00-00 00:00:00','975','2023-03-11 12:24:34'),(54,'1','291','2023-03-07',1,'30','','10',268435.00,'30','','','6','AAR5703','30',268460.60,'2023-03-11 11:56:54',5,'PAYMENT ON ACCOUNT .','973','','0000-00-00 00:00:00','975','2023-03-11 12:22:32'),(55,'1','291','2023-03-06',1,'28','','5',260700.00,'28','','','5','AAR5703','9751128',2271252.30,'2023-03-11 12:26:47',5,'PAYMENT ON ACCOUNT','973','975','2023-03-13 15:59:16','975','2023-03-13 16:02:00'),(56,'1','291','2023-03-05',1,'27','','5',20030.00,'27','','','5','AAR5703','9751129',0.00,'2023-03-13 11:41:36',5,'PAYMENT ON ACCOUNT','973','975','2023-03-13 16:27:31','975','2023-03-15 13:15:53'),(57,'1','291','2023-03-11',1,'31','','5',15185.00,'31','','','5','AAR5703','9751130',0.00,'2023-03-13 11:43:50',5,'PAYMENT ON ACCOUNT','973','975','2023-03-13 16:28:22','975','2023-03-15 13:15:52'),(58,'1','291','2023-03-11',1,'32','','10',5023805.00,'31/32','','','6','AAR5703','32',2817615.00,'2023-03-13 11:48:19',0,'PAYMENT ON ACCOUNT','973','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(59,'1','291','2023-03-12',1,'34','','5',5272596.00,'33/34','','','6','AAR5703','34',3217256.10,'2023-03-15 10:04:00',0,'PAYMENT ON ACCOUNT.','973','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(60,'1','291','2023-03-12',1,'33','','2',49800.00,'33','','','','','',2083004.20,'2023-03-15 10:06:47',5,'AGO FOR GEN 60LTRS FOR 2 DAYS @830 ','973','975','2023-03-15 13:19:42','975','2023-03-15 13:20:21'),(61,'1','291','2023-03-13',1,'3','','5',69000.00,'3','','','8','AAR5703','1',0.00,'2023-03-16 13:26:02',5,'DRIVER SHORT PAYMENT','973','975','2023-03-16 13:44:30','975','2023-03-16 13:45:20'),(62,'1','291','2023-03-13',1,'33','','5',57500.00,'33','','','8','AAR5703','2',0.00,'2023-03-16 13:33:33',5,'DRIVER SHORT PAYMENT','973','975','2023-03-16 13:44:54','975','2023-03-16 13:45:20'),(64,'1','291','2023-03-15',1,'35','','5',23970.00,'35','','','5','AAR5703','0751135',0.00,'2023-03-20 11:22:07',5,'PAYMENT ON ACCOUNT','973','975','2023-03-20 18:17:15','975','2023-03-20 18:18:44'),(65,'1','291','2023-03-15',1,'35','','10',1818364.00,'35','','','6','AAR5703','35',1943695.50,'2023-03-20 11:25:01',0,'PAYMENT ON ACCOUNT','973','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(66,'1','291','2023-03-17',1,'36','','5',92250.00,'36','','','5','AAR5703','0751136',2391712.50,'2023-03-20 11:29:30',5,'PAYMENT ON ACCOUNT','973','975','2023-03-20 18:20:12','975','2023-03-20 18:20:42'),(67,'1','291','2023-03-17',1,'37','','10',4114132.00,'36/37','','','6','AAR5703','37',1815470.50,'2023-03-20 11:33:48',0,'PAYMENT ON ACCOUNT','973','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(68,'1','291','2023-03-15',1,'35','','2',74700.00,'35','','','','','',0.00,'2023-03-20 11:39:51',0,'AGO FOR GEN 90LTER FOR 3 DAYS @830','973','975','2023-03-20 18:17:49','','0000-00-00 00:00:00'),(69,'1','291','2023-03-18',1,'36','','5',57500.00,'1','','','8','AAR5703','01',132430.22,'2023-03-20 12:23:37',0,'DRIVER SHORT PAYMENT','973','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `purchases_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_receptions`
--

DROP TABLE IF EXISTS `purchases_receptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_receptions` (
  `bridge_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `purchase_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `loadingdate` datetime NOT NULL,
  `loadingpoint` varchar(100) DEFAULT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `received` decimal(20,2) NOT NULL,
  `distributed` decimal(20,2) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `vessel` varchar(50) NOT NULL,
  `drivername` varchar(30) NOT NULL,
  `driverphone` varchar(30) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`bridge_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`supplier_id`,`loadingdate`,`quantity`,`waybill`,`meterno`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`purchase_id`),
  KEY `truck_id` (`tank_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_receptions`
--

LOCK TABLES `purchases_receptions` WRITE;
/*!40000 ALTER TABLE `purchases_receptions` DISABLE KEYS */;
INSERT INTO `purchases_receptions` VALUES (1,'1',1,'291',1,1,'2023-01-16 00:00:00','CALABER',45000.00,45000.00,0.00,'21170','','1','LAU 417 XA','IBRAHIM','NIL','DISCHAGE OF PMS',5,'2023-01-16 12:42:00','973','0000-00-00 00:00:00','','2023-01-16 12:42:35','973'),(2,'1',2,'291',1,1,'2023-01-16 00:00:00','CALABER',45000.00,45000.00,0.00,'21171','','1','JJJ 475 XU','JOHN','NIL','DISCHAGE OF PMS',5,'2023-01-16 12:44:31','973','0000-00-00 00:00:00','','2023-01-16 12:44:56','973'),(3,'1',3,'291',1,1,'2023-01-16 00:00:00','CALABER',31000.00,31000.00,0.00,'21172','','1','BAL 484 XA','JOHN','NIL','DISCHAGE OF PMS',5,'2023-01-16 20:26:44','973','0000-00-00 00:00:00','','2023-01-17 13:27:35','973'),(4,'1',4,'291',1,1,'2023-03-05 00:00:00','AA RANO NIG LTD',49700.00,49700.00,0.00,'3/4/23','','1','RAN 946 XA','SANI','','DISCHARGE OF PMS',5,'2023-03-05 10:56:49','973','0000-00-00 00:00:00','','2023-03-05 10:57:57','973'),(5,'1',5,'291',1,1,'2023-03-11 00:00:00','WARRI',44750.00,44750.00,0.00,'2008285','','1','RAN 831 XA','IBRAHIM BIN ABUBAKAR','08033664032','DISCHARGE OF PMS',5,'2023-03-11 11:21:54','973','0000-00-00 00:00:00','','2023-03-11 11:26:30','973'),(6,'1',6,'291',1,1,'2023-03-17 00:00:00','WARRI',49750.00,49750.00,0.00,'1','','1','RAN 920 XA','SURAJO ALI','08149682098','DISCHARGE OF PMS',5,'2023-03-17 08:58:31','973','0000-00-00 00:00:00','','2023-03-17 08:59:52','973');
/*!40000 ALTER TABLE `purchases_receptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports`
--

DROP TABLE IF EXISTS `reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `type` varchar(20) NOT NULL,
  `sql` text NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`report_id`),
  KEY `companycode` (`company_id`,`name`,`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports`
--

LOCK TABLES `reports` WRITE;
/*!40000 ALTER TABLE `reports` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_fields`
--

DROP TABLE IF EXISTS `reports_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(20) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `fieldname` varchar(50) NOT NULL,
  `order` int NOT NULL,
  `visibility` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`report_id`,`field_id`,`order`,`visibility`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_fields`
--

LOCK TABLES `reports_fields` WRITE;
/*!40000 ALTER TABLE `reports_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_filters`
--

DROP TABLE IF EXISTS `reports_filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_filters` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(50) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `filter_id` int NOT NULL AUTO_INCREMENT,
  `criteria` varchar(20) NOT NULL,
  `value` varchar(100) NOT NULL,
  PRIMARY KEY (`filter_id`),
  KEY `companycode` (`company_id`,`report_id`),
  KEY `field_id` (`field_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_filters`
--

LOCK TABLES `reports_filters` WRITE;
/*!40000 ALTER TABLE `reports_filters` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_filters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_customers`
--

DROP TABLE IF EXISTS `retail_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_customers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`name`,`phone`,`email`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_customers`
--

LOCK TABLES `retail_customers` WRITE;
/*!40000 ALTER TABLE `retail_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory`
--

DROP TABLE IF EXISTS `retail_inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` int NOT NULL,
  `qtyout` int NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory`
--

LOCK TABLES `retail_inventory` WRITE;
/*!40000 ALTER TABLE `retail_inventory` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_balances`
--

DROP TABLE IF EXISTS `retail_inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_balances`
--

LOCK TABLES `retail_inventory_balances` WRITE;
/*!40000 ALTER TABLE `retail_inventory_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_costs`
--

DROP TABLE IF EXISTS `retail_inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_costs`
--

LOCK TABLES `retail_inventory_costs` WRITE;
/*!40000 ALTER TABLE `retail_inventory_costs` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products`
--

DROP TABLE IF EXISTS `retail_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`name`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `parent_id` (`parent_id`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products`
--

LOCK TABLES `retail_products` WRITE;
/*!40000 ALTER TABLE `retail_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_prices`
--

DROP TABLE IF EXISTS `retail_products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_prices`
--

LOCK TABLES `retail_products_prices` WRITE;
/*!40000 ALTER TABLE `retail_products_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_reconciliations`
--

DROP TABLE IF EXISTS `retail_products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_reconciliations`
--

LOCK TABLES `retail_products_reconciliations` WRITE;
/*!40000 ALTER TABLE `retail_products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_purchases`
--

DROP TABLE IF EXISTS `retail_purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_purchases`
--

LOCK TABLES `retail_purchases` WRITE;
/*!40000 ALTER TABLE `retail_purchases` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales`
--

DROP TABLE IF EXISTS `retail_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `saledate` date NOT NULL,
  `customer_id` varchar(20) NOT NULL DEFAULT '',
  `customer_name` varchar(50) NOT NULL,
  `customer_phone` varchar(30) NOT NULL,
  `quantity_kg` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `payment_method` varchar(10) NOT NULL,
  `payment_account_type` varchar(20) NOT NULL,
  `payment_account_id` varchar(20) NOT NULL,
  `paid` decimal(20,2) DEFAULT NULL,
  `change` decimal(20,2) DEFAULT '0.00',
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`customer_name`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `payment_method` (`payment_method`,`payment_account_type`,`payment_account_id`),
  KEY `customer_id` (`customer_id`),
  KEY `change` (`change`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales`
--

LOCK TABLES `retail_sales` WRITE;
/*!40000 ALTER TABLE `retail_sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_items`
--

DROP TABLE IF EXISTS `retail_sales_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `product_type` varchar(10) NOT NULL,
  `product_name` varchar(100) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `quantity_2` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `parent_cost` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`sale_id`,`product_id`,`rate`,`quantity`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`product_type`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `parent_id` (`parent_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_items`
--

LOCK TABLES `retail_sales_items` WRITE;
/*!40000 ALTER TABLE `retail_sales_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_payments`
--

DROP TABLE IF EXISTS `retail_sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_payments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `payment_method` varchar(50) NOT NULL,
  `account_type` varchar(10) DEFAULT NULL,
  `account_id` bigint DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`sale_id`,`payment_method`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`account_type`),
  KEY `parent_id` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_payments`
--

LOCK TABLES `retail_sales_payments` WRITE;
/*!40000 ALTER TABLE `retail_sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales`
--

DROP TABLE IF EXISTS `sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `is_credit` int NOT NULL DEFAULT '0',
  `saledate` date NOT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `paid` int NOT NULL,
  `details` text NOT NULL,
  `ledger_notes` varchar(150) DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`product_id`,`customer_id`,`rate`,`quantity`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`is_credit`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales`
--

LOCK TABLES `sales` WRITE;
/*!40000 ALTER TABLE `sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_daily`
--

DROP TABLE IF EXISTS `sales_daily`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_daily` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `saledate` date NOT NULL,
  `average` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `target` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`average`,`saledate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_daily`
--

LOCK TABLES `sales_daily` WRITE;
/*!40000 ALTER TABLE `sales_daily` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_daily` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions`
--

DROP TABLE IF EXISTS `sales_distributions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions` (
  `distribution_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `sale_id` int NOT NULL,
  `purchase_id` varchar(20) NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `loadingdate` date NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `destination` varchar(50) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `truckno` varchar(20) NOT NULL,
  `drivername` varchar(50) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`distribution_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`loadingdate`,`quantity`,`destination`,`waybill`,`meterno`,`nozzle_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`tank_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `truckno` (`truckno`),
  KEY `purchase_id_2` (`purchase_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions`
--

LOCK TABLES `sales_distributions` WRITE;
/*!40000 ALTER TABLE `sales_distributions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_delivery`
--

DROP TABLE IF EXISTS `sales_distributions_delivery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_delivery` (
  `delivery_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `distribution_id` int NOT NULL,
  `sale_id` int NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `quantity` int NOT NULL,
  `truck_id` int NOT NULL,
  `deliveredon` date NOT NULL,
  `details` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`delivery_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`quantity`,`thedate`,`createdby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`truck_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `distribution_id` (`distribution_id`),
  KEY `deliveredon` (`deliveredon`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_delivery`
--

LOCK TABLES `sales_distributions_delivery` WRITE;
/*!40000 ALTER TABLE `sales_distributions_delivery` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_delivery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_trucks`
--

DROP TABLE IF EXISTS `sales_distributions_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_trucks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sale_id` varchar(20) NOT NULL,
  `distribution_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `bridge_id` varchar(20) NOT NULL,
  `truck_id` varchar(20) NOT NULL,
  `driver_id` varchar(20) NOT NULL,
  `quantity` int NOT NULL,
  `destination` varchar(150) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `companycode` (`company_id`,`distribution_id`,`truck_id`),
  KEY `sale_id` (`sale_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_trucks`
--

LOCK TABLES `sales_distributions_trucks` WRITE;
/*!40000 ALTER TABLE `sales_distributions_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_fueltickets`
--

DROP TABLE IF EXISTS `sales_fueltickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_fueltickets` (
  `ticket_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `ticketdate` date NOT NULL,
  `code` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `allowance` decimal(10,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `truck_number` varchar(20) NOT NULL,
  `truck_capacity` int NOT NULL,
  `truck_provider` varchar(50) NOT NULL,
  `truck_from` varchar(50) NOT NULL,
  `truck_destination` varchar(50) NOT NULL,
  `driver_name` varchar(50) NOT NULL,
  `driver_phone` varchar(50) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`ticket_id`),
  KEY `companycode` (`company_id`,`ticketdate`,`product_id`,`truck_number`,`rate`,`quantity`,`status`),
  KEY `paid` (`truck_provider`),
  KEY `invoice` (`code`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_fueltickets`
--

LOCK TABLES `sales_fueltickets` WRITE;
/*!40000 ALTER TABLE `sales_fueltickets` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_fueltickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_payments`
--

DROP TABLE IF EXISTS `sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `customer_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`customer_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_payments`
--

LOCK TABLES `sales_payments` WRITE;
/*!40000 ALTER TABLE `sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_cashbacks`
--

DROP TABLE IF EXISTS `shifts_cashbacks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_cashbacks` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `regno` varchar(100) DEFAULT NULL,
  `cashdate` date NOT NULL,
  `driver` varchar(100) DEFAULT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`cashdate`,`driver`,`customer_id`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`regno`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_cashbacks`
--

LOCK TABLES `shifts_cashbacks` WRITE;
/*!40000 ALTER TABLE `shifts_cashbacks` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_cashbacks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_remittance`
--

DROP TABLE IF EXISTS `shifts_remittance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_remittance` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `paymentdate` date NOT NULL,
  `method` int DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paidby` varchar(50) DEFAULT NULL,
  `paidto` varchar(100) DEFAULT NULL,
  `bank` bigint unsigned DEFAULT NULL,
  `depositor` varchar(100) DEFAULT NULL,
  `teller` varchar(100) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  `reversed_at` datetime DEFAULT NULL,
  `reversed_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`paymentdate`,`method`,`bank`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_remittance`
--

LOCK TABLES `shifts_remittance` WRITE;
/*!40000 ALTER TABLE `shifts_remittance` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_remittance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers`
--

DROP TABLE IF EXISTS `suppliers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers` (
  `supplier_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`supplier_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers`
--

LOCK TABLES `suppliers` WRITE;
/*!40000 ALTER TABLE `suppliers` DISABLE KEYS */;
INSERT INTO `suppliers` VALUES (1,'1','291','AA RANO NIGERIA LTD','MUHAMMAD ABDUL SULE','0803540199','mrmohasul@gmail.com','KANO','KANO','No 7 Maiduguri Road,Opposite NNPC Depot. Kano Nigeria','Nigeria',0.00,0.00,'0000-00-00','2022-10-18 17:10:26',5,'178','2022-10-18 17:10:26','178');
/*!40000 ALTER TABLE `suppliers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers_status`
--

DROP TABLE IF EXISTS `suppliers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `supplier_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers_status`
--

LOCK TABLES `suppliers_status` WRITE;
/*!40000 ALTER TABLE `suppliers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `suppliers_status` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-03-21  2:54:22
