-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_289
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_289`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_289` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_289`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,8000,'',0,'24','1','289','SALARIES','','2022-10-19 11:05:34',5,0.00,0.00,'','178','2022-10-19 11:05:34','178',0,0),(2,8001,'',0,'24','1','289','PURCHASES','','2022-10-19 17:12:23',5,0.00,0.00,'','178','2022-10-19 17:12:23','178',0,0),(3,7000,'',0,'20','1','289','SALES','','2022-10-19 17:12:30',5,0.00,0.00,'','178','2022-10-19 17:12:30','178',0,0),(4,500,'',0,'6.1','1','289','CASH','','2022-10-19 17:12:38',5,0.00,0.00,'','178','2022-10-19 17:12:38','178',0,0),(5,2500,'',0,'2','1','289','ZNB 1014717261','','2022-11-01 14:01:27',5,0.00,0.00,'','975','2022-11-01 14:01:27','975',0,0),(6,2501,'',0,'2','1','289','UBA POS','','2022-11-01 14:01:35',5,0.00,0.00,'','975','2022-11-01 14:01:35','975',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
INSERT INTO `attendants` VALUES ('1','289',1,'John ','Victory ','Eebe','','','','','','Nigeria','','','','',0,5,'0000-00-00 00:00:00','2022-10-25 20:02:22','970','2022-10-25 20:06:57','970'),('1','289',2,'Eze','Favour ','Kelechi ','','','','','','Nigeria','','','','',0,5,'0000-00-00 00:00:00','2022-10-25 20:03:16','970','2022-10-25 20:03:16','970'),('1','289',3,'Chikwem ','Confidence ','','','','','','','Nigeria','','','','',0,5,'0000-00-00 00:00:00','2022-10-25 20:08:44','970','2022-10-25 20:13:55','970'),('1','289',4,'Yahaya','Abdulmajid ','Rano','','','','','','Nigeria','','','','',0,5,'0000-00-00 00:00:00','2022-10-25 20:09:25','970','2022-12-05 20:25:04','970'),('1','289',5,'Muhammad ','Fatima ','Hadir','','','','','','Nigeria','','','','',0,5,'0000-00-00 00:00:00','2022-10-25 20:09:55','970','2022-10-25 20:20:36','970'),('1','289',6,'Ali','Ibrahim ','','','','','','','Nigeria','','','','',0,5,'0000-00-00 00:00:00','2022-10-25 20:18:59','970','2022-10-25 20:18:59','970'),('1','289',7,'Usen','Peace ','','','','','','','Nigeria','','.','','',0,5,'0000-00-00 00:00:00','2022-12-05 20:23:36','970','2022-12-05 20:23:36','970');
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','1','289','NIGERIA POLICE FORCE (ELECTION','OHELCA ROWLAND','08038166331','dopstransport@gmail.come','porthercourt','REVERS','PHORTHARCOURT','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-21 16:46:52',5,'975','2023-02-21 16:46:52','975');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','289',1,'1',168.70,9027.00,'2022-11-02','','2022-11-02 16:40:14','975','975',2022,'975','2022-11-02 16:40:14',5),('1','289',2,'2',1753.65,1.00,'2022-11-02','','2022-11-02 16:40:55','975','975',2022,'975','2022-11-02 16:40:55',5),('1','289',3,'3',7104.40,1.00,'2022-11-02','','2022-11-02 16:41:28','975','975',2022,'975','2022-11-02 16:41:28',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','289','1',1,'5','PUMP 1',576701.08,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-19 17:14:10','178'),('1','289','1',2,'5','PUMP 2',748252.47,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-19 17:14:48','178'),('1','289','1',3,'5','PUMP 3',323437.46,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-19 17:15:16','178'),('1','289','1',4,'5','PUMP 4',172549.53,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-19 17:15:59','178'),('1','289','1',5,'5','PUMP 5',1019993.92,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-19 17:16:47','178'),('1','289','1',6,'5','PUMP 6',39508.84,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-19 17:17:17','178'),('1','289','1',7,'5','PUMP 7',32483.34,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-19 17:18:49','178'),('1','289','4',8,'5','AGO PUMP 2',542428.67,'DISPENSING AGO','',NULL,NULL,'',5,'2023-02-25 01:41:39','970'),('1','289','4',9,'5','AGO PUMP 1',772479.16,'DISPENSING AGO','',NULL,NULL,'',5,'2023-02-15 12:18:50','178');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
INSERT INTO `depots_nozzles_tanks` VALUES (1,'1','289','5','1','Bulk switch','2022-11-02 16:35:03',0,'178'),(2,'1','289','6','1','Bulk switch','2022-11-02 16:35:03',0,'178'),(3,'1','289','7','1','Bulk switch','2022-11-02 16:35:03',0,'178'),(4,'1','289','8','1','Bulk switch','2022-11-02 16:35:03',0,'178'),(5,'1','289','8','4','AGO','2023-02-25 01:39:46',0,'970');
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=95 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','289',1,'Afternoon shift ','2022-10-11','2022-10-27 02:00:49','2022-10-27 10:00:49','970',0.00,0.00,'970','2022-10-28 10:29:16','648','2022-10-28 10:34:45',10,0),('1','289',2,'AFTERNOON','2022-10-11','2022-10-28 10:37:41','2022-10-28 18:37:41','970',203315.40,203315.40,'970','2022-10-28 11:01:28','648','2022-10-28 11:03:57',10,0),('1','289',3,'MORNING','2022-10-12','2022-10-28 11:21:55','2022-10-28 19:21:55','970',153250.20,153250.20,'970','2022-10-28 11:24:35','648','2022-10-28 11:27:40',10,0),('1','289',4,'AFTERNOON','2022-10-12','2022-10-28 11:39:05','2022-10-28 19:39:05','970',231595.20,231595.20,'970','2022-10-28 11:45:28','648','2022-10-28 11:47:21',10,0),('1','289',5,'MORNING','2022-10-13','2022-10-28 11:50:51','2022-10-28 19:50:51','970',126937.80,126937.80,'970','2022-10-28 11:56:11','648','2022-10-28 11:59:16',10,0),('1','289',6,'AFTERNOON','2022-10-13','2022-10-28 12:03:05','2022-10-28 20:03:05','970',224958.60,224958.60,'970','2022-10-28 12:17:38','648','2022-10-28 12:23:51',10,0),('1','289',7,'MORNING','2022-10-14','2022-10-28 12:41:08','2022-10-28 20:41:08','970',167337.00,167337.00,'970','2022-10-28 12:45:09','648','2022-10-28 12:49:23',10,0),('1','289',8,'AFTERNOON','2022-10-14','2022-10-28 12:57:37','2022-10-28 20:57:37','970',192074.40,192074.40,'970','2022-10-28 13:13:05','648','2022-10-28 13:17:19',10,0),('1','289',9,'MORNING','2022-10-15','2022-10-29 07:18:56','2022-10-29 15:18:56','970',179181.00,179181.00,'970','2022-10-29 07:21:57','648','2022-10-29 07:33:57',10,0),('1','289',11,'AFTERNOON','2022-10-15','2022-10-29 07:39:41','2022-10-29 15:39:41','970',242834.40,242834.40,'970','2022-10-29 07:45:27','648','2022-10-29 07:48:07',10,0),('1','289',12,'MORNING','2022-10-16','2022-10-29 07:50:24','2022-10-29 15:50:24','970',161323.20,161323.20,'970','2022-10-29 07:52:30','648','2022-10-29 07:54:39',10,0),('1','289',13,'AFTERNOON','2022-10-16','2022-10-29 07:57:37','2022-10-29 15:57:37','970',200894.40,200894.40,'970','2022-10-29 08:02:50','648','2022-10-29 08:16:39',10,0),('1','289',14,'MORNING','2022-10-17','2022-10-29 08:24:39','2022-10-29 16:24:39','970',212461.20,212461.20,'970','2022-10-29 08:31:25','648','2022-10-29 08:33:58',10,0),('1','289',15,'AFTERNOON','2022-10-17','2022-10-29 08:35:16','2022-10-29 16:35:16','970',257472.00,257472.00,'970','2022-10-29 08:36:47','648','2022-10-29 08:40:50',10,0),('1','289',16,'MORNING','2022-10-18','2022-10-29 10:15:31','2022-10-29 18:15:31','970',471927.60,471927.60,'970','2022-10-29 10:20:47','648','2022-10-29 10:28:47',10,0),('1','289',17,'AFTERNOON','2022-10-18','2022-10-29 10:38:27','2022-10-29 18:38:27','970',1647342.00,1647342.00,'970','2022-10-29 11:17:28','648','2022-10-29 11:18:56',10,0),('1','289',18,'MORNING','2022-10-19','2022-10-29 11:20:18','2022-10-29 19:20:18','970',984490.20,984490.20,'970','2022-10-29 11:22:32','648','2022-10-29 11:25:07',10,0),('1','289',19,'AFTERNOON','2022-10-19','2022-10-29 11:26:41','2022-10-29 19:26:41','970',611269.20,611269.20,'970','2022-10-29 11:30:12','648','2022-10-29 11:36:46',10,0),('1','289',20,'MORNING','2022-10-20','2022-10-29 11:45:08','2022-10-29 19:45:08','970',471830.40,471830.40,'970','2022-10-29 11:47:46','648','2022-10-29 11:49:08',10,0),('1','289',21,'AFTERNOON','2022-10-20','2022-10-29 11:50:31','2022-10-29 19:50:31','970',463057.20,463057.20,'970','2022-10-29 11:52:05','648','2022-10-29 11:55:49',10,0),('1','289',22,'MORNING','2022-10-21','2022-10-29 11:58:19','2022-10-29 19:58:19','970',338342.40,338342.40,'970','2022-10-29 12:01:11','648','2022-10-29 12:05:36',10,0),('1','289',23,'AFTERNOON','2022-10-21','2022-10-29 12:08:59','2022-10-29 20:08:59','970',607203.00,607203.00,'970','2022-10-29 12:14:07','648','2022-10-29 12:16:59',10,0),('1','289',24,'MORNING','2022-10-22','2022-10-29 12:17:41','2022-10-29 20:17:41','970',395677.80,395677.80,'970','2022-10-29 12:20:37','648','2022-10-29 12:26:56',10,0),('1','289',25,'AFTERNOON','2022-10-22','2022-10-29 12:34:52','2022-10-29 20:34:52','970',145998.00,145998.00,'970','2022-10-29 12:38:10','648','2022-10-29 12:43:07',10,0),('1','289',26,'MORNING','2022-10-23','2022-10-29 12:45:02','2022-10-29 20:45:02','970',325470.60,325470.60,'970','2022-10-29 12:49:51','648','2022-10-29 12:52:06',10,0),('1','289',27,'AFTERNOON','2022-10-23','2022-10-29 12:55:51','2022-10-29 20:55:51','970',396784.80,396784.80,'970','2022-10-29 13:00:00','648','2022-10-29 13:04:48',10,0),('1','289',28,'MORNING','2022-10-24','2022-10-29 15:54:56','2022-10-29 23:54:56','970',584334.00,584334.00,'970','2022-10-29 16:05:35','648','2022-10-29 16:22:49',10,0),('1','289',29,'AFTERNOON','2022-10-24','2022-10-29 17:47:41','2022-10-30 01:47:41','970',568900.80,568900.80,'970','2022-10-29 18:13:32','648','2022-10-30 11:15:04',10,0),('1','289',30,'MORNING','2022-10-25','2022-10-30 11:44:37','2022-10-30 19:44:37','970',567009.00,567009.00,'970','2022-10-30 11:50:50','648','2022-10-30 11:54:16',10,0),('1','289',31,'AFTERNOON','2022-10-25','2022-10-30 11:55:29','2022-10-30 19:55:29','970',421417.80,421417.80,'970','2022-10-30 11:57:52','648','2022-10-30 11:58:51',10,0),('1','289',32,'MORNING','2022-10-26','2022-10-30 12:02:44','2022-10-30 20:02:44','970',532810.80,532810.80,'970','2022-10-30 12:05:16','648','2022-10-30 12:10:41',10,0),('1','289',33,'AFTERNOON','2022-10-26','2022-10-30 12:12:01','2022-10-30 20:12:01','970',445368.60,445368.60,'970','2022-10-30 12:13:59','648','2022-10-30 12:15:12',10,0),('1','289',34,'MORNING','2022-10-27','2022-10-30 12:16:33','2022-10-30 20:16:33','970',0.00,0.00,'970','2022-10-31 17:12:39','648','2022-11-01 18:08:29',10,0),('1','289',35,'MORNING','2022-10-27','2022-11-02 09:41:57','2022-11-02 17:41:57','970',482490.00,482490.00,'970','2022-11-02 09:43:24','648','2022-11-02 09:48:12',10,0),('1','289',36,'AFTERNOON','2022-10-27','2022-11-02 09:50:41','2022-11-02 17:50:41','970',513860.40,513860.40,'970','2022-11-02 09:54:14','648','2022-11-02 10:03:29',10,0),('1','289',37,'MORNING','2022-10-29','2022-11-02 10:08:05','2022-11-02 18:08:05','970',351441.00,351441.00,'970','2022-11-02 10:14:49','648','2022-11-02 10:19:10',10,0),('1','289',38,'MORNING','2022-10-30','2022-11-02 10:21:04','2022-11-02 18:21:04','970',473911.20,473911.20,'970','2022-11-02 10:23:55','648','2022-11-02 10:25:25',10,0),('1','289',39,'AFTERNOON','2022-10-30','2022-11-02 10:29:24','2022-11-02 18:29:24','970',527954.40,527954.40,'970','2022-11-02 10:31:20','648','2022-11-02 10:39:48',10,0),('1','289',40,'MORNING','2022-10-31','2022-11-02 10:47:07','2022-11-02 18:47:07','970',585712.80,585712.80,'970','2022-11-02 10:50:54','648','2022-11-02 11:09:28',10,0),('1','289',41,'AFTERNOON','2022-10-31','2022-11-02 12:23:14','2022-11-02 20:23:14','970',582946.20,582946.20,'970','2022-11-02 12:27:23','648','2022-11-02 12:50:52',10,0),('1','289',42,'MORNING','2022-11-01','2022-11-02 12:54:17','2022-11-02 20:54:17','970',477122.40,477122.40,'970','2022-11-02 12:57:57','648','2022-11-02 20:11:19',10,0),('1','289',43,'AFTERNOON','2022-11-04','2022-11-04 21:11:24','2022-11-05 05:11:24','970',640440.00,640440.00,'970','2022-11-04 21:19:07','648','2022-11-06 14:18:49',10,0),('1','289',44,'AFTERNOON','2022-11-23','2022-11-24 11:40:32','2022-11-24 19:40:32','970',70761.60,60652.80,'970','2022-11-24 11:45:56','648','2022-11-24 11:52:44',10,0),('1','289',45,'MORNING','2022-11-24','2022-11-24 14:46:06','2022-11-24 22:46:06','970',619609.20,619609.20,'970','2022-11-24 14:53:06','648','2022-11-24 16:29:32',10,0),('1','289',46,'AFTERNOON','2022-11-24','2022-11-25 10:03:09','2022-11-25 18:03:09','970',719090.40,719090.40,'970','2022-11-25 10:23:43','648','2022-11-25 10:31:20',10,0),('1','289',47,'MORNING','2022-11-25','2022-11-25 16:40:01','2022-11-26 00:40:01','970',866218.50,866218.50,'970','2022-11-25 17:04:43','648','2022-11-25 17:51:36',10,0),('1','289',48,'Afternoon shift ','2022-11-25','2022-11-25 20:46:36','2022-11-26 04:46:36','970',0.00,0.00,'970','2022-11-26 09:57:12','648','2022-11-26 10:24:50',10,0),('1','289',49,'AFTERNOON','2022-11-25','2022-11-26 10:26:59','2022-11-26 18:26:59','970',919522.80,919522.80,'970','2022-11-26 10:40:22','648','2022-11-26 15:12:40',10,0),('1','289',50,'MORNING','2022-11-26','2022-11-26 16:00:09','2022-11-27 00:00:09','970',0.00,0.00,'970','2022-11-27 11:29:55','648','2022-11-27 14:56:27',10,0),('1','289',51,'MORNING','2022-11-26','2022-11-27 15:26:28','2022-11-27 23:26:28','970',0.00,0.00,'970','2022-11-30 08:52:24','648','2022-11-30 08:56:19',10,0),('1','289',52,'MORNING','2022-11-26','2022-11-30 17:20:44','2022-12-01 01:20:44','970',1280892.90,1280892.90,'970','2022-11-30 17:24:45','648','2022-11-30 17:39:05',10,0),('1','289',53,'MORNING','2022-11-26','2022-11-30 17:44:15','2022-12-01 01:44:15','970',42869.40,42869.40,'970','2022-11-30 17:45:32','648','2022-12-01 07:49:21',10,0),('1','289',54,'AFTERNOON','2022-11-26','2022-12-01 12:24:22','2022-12-01 20:24:22','970',1106198.10,1106198.10,'970','2022-12-01 12:30:01','648','2022-12-01 14:55:39',10,0),('1','289',55,'MORNING','2022-11-27','2022-12-01 14:59:26','2022-12-01 22:59:26','970',1035499.50,1035499.50,'970','2022-12-01 15:07:01','648','2022-12-01 15:12:29',10,0),('1','289',56,'AFTERNOON','2022-11-27','2022-12-01 15:15:52','2022-12-01 23:15:52','970',1152087.30,1152087.30,'970','2022-12-01 15:22:43','648','2022-12-01 15:23:44',10,0),('1','289',57,'MORNING','2022-11-28','2022-12-01 15:24:51','2022-12-01 23:24:51','970',1104805.80,1104805.80,'970','2022-12-01 15:31:57','648','2022-12-01 15:32:56',10,0),('1','289',58,'AFTERNOON','2022-11-28','2022-12-01 15:33:59','2022-12-01 23:33:59','970',872634.00,872634.00,'970','2022-12-01 15:41:51','648','2022-12-01 16:27:29',10,0),('1','289',59,'MORNING','2022-11-29','2022-12-01 16:28:52','2022-12-02 00:28:52','970',1150491.30,1150491.30,'970','2022-12-01 16:31:04','648','2022-12-01 16:36:48',10,0),('1','289',60,'AFTERNOON','2022-11-29','2022-12-01 16:38:13','2022-12-02 00:38:13','970',1068274.20,1068274.20,'970','2022-12-01 16:41:17','648','2022-12-02 10:25:51',10,0),('1','289',61,'MORNING','2022-11-30','2022-12-02 11:09:44','2022-12-02 19:09:44','970',408655.80,408655.80,'970','2022-12-02 11:13:19','648','2022-12-02 12:19:57',10,0),('1','289',62,'AFTERNOON','2022-12-06','2022-12-07 08:39:33','2022-12-07 16:39:33','970',454803.30,454803.30,'970','2022-12-07 08:49:00','648','2022-12-09 17:43:04',10,0),('1','289',63,'AFTERNOON','2023-02-11','2023-02-15 13:32:23','2023-02-15 21:32:23','970',987563.20,987563.20,'970','2023-02-15 13:33:39','648','2023-02-16 09:19:06',10,0),('1','289',64,'AFTERNOON','2023-02-12','2023-02-16 10:40:16','2023-02-16 18:40:16','970',1059026.60,1059026.60,'970','2023-02-16 10:41:13','648','2023-02-16 18:35:19',10,0),('1','289',65,'AFTERNOON','2023-02-13','2023-02-17 19:39:13','2023-02-18 19:39:13','970',2158532.80,2158532.80,'970','2023-02-17 19:41:48','648','2023-02-19 22:57:04',10,0),('1','289',66,'AFTERNOON','2023-02-14','2023-02-20 17:26:39','2023-02-21 17:26:39','970',19947.50,19947.50,'970','2023-02-20 17:28:34','648','2023-02-20 22:51:26',10,0),('1','289',67,'AFTERNOON ','2023-02-16','2023-02-21 03:55:03','2023-02-22 03:55:03','970',590272.20,590272.20,'970','2023-02-21 10:01:55','648','2023-02-21 11:42:31',10,0),('1','289',68,'AFTERNOON','2023-02-17','2023-02-25 23:15:33','2023-02-26 23:15:33','970',326499.10,326499.10,'970','2023-02-25 23:16:51','648','2023-02-26 13:18:07',10,0),('1','289',69,'AFTERNOON','2023-02-20','2023-02-26 13:37:56','2023-02-27 13:37:56','970',400000.70,400000.70,'970','2023-02-26 13:39:40','648','2023-03-01 07:42:01',10,0),('1','289',70,'AFTERNOON','2023-02-21','2023-03-01 22:13:10','2023-03-02 22:13:10','970',552044.10,552044.10,'970','2023-03-01 22:16:05','648','2023-03-02 10:07:05',10,0),('1','289',71,'AFTERNOON','2023-02-22','2023-03-02 11:36:56','2023-03-03 11:36:56','970',634030.30,634030.30,'970','2023-03-02 11:50:34','648','2023-03-02 12:52:47',10,0),('1','289',72,'AFTERNOON','2023-02-23','2023-03-02 23:49:32','2023-03-03 23:49:32','970',1060575.00,1060575.00,'970','2023-03-02 23:53:06','648','2023-03-03 09:59:58',10,0),('1','289',73,'AFTERNOON','2023-02-24','2023-03-03 21:40:25','2023-03-04 21:40:25','970',15468397.50,15468397.50,'970','2023-03-03 21:44:19','648','2023-03-04 06:40:53',10,0),('1','289',74,'AFTERNOON','2023-03-02','2023-03-05 18:44:41','2023-03-06 06:44:41','970',811259.95,811259.95,'970','2023-03-05 18:47:36','648','2023-03-07 15:02:28',10,0),('1','289',75,'MORNING','2023-03-02','2023-03-07 23:08:21','2023-03-08 23:08:21','970',830891.85,830891.85,'970','2023-03-07 23:12:30','648','2023-03-08 09:49:21',10,0),('1','289',76,'MORNING','2023-03-03','2023-03-08 14:50:34','2023-03-09 14:50:34','970',1269183.30,1269183.30,'970','2023-03-08 14:52:48','975','2023-03-08 15:37:46',10,0),('1','289',77,'AFTERNOON','2023-03-04','2023-03-08 15:49:42','2023-03-09 15:49:42','970',1798490.25,1798490.25,'970','2023-03-08 15:53:00','975','2023-03-08 16:00:23',10,0),('1','289',78,'MORNING','2023-03-06','2023-03-08 16:04:22','2023-03-09 16:04:22','970',2086980.95,2086980.95,'970','2023-03-08 16:09:25','975','2023-03-08 16:22:53',10,0),('1','289',79,'AFTERNOON','2023-03-06','2023-03-08 16:42:47','2023-03-09 16:42:47','970',678400.00,678400.00,'970','2023-03-08 16:43:48','975','2023-03-08 16:59:47',10,0),('1','289',80,'MORNING','2023-03-07','2023-03-08 17:10:26','2023-03-09 17:10:26','970',2479856.30,2479856.30,'970','2023-03-09 08:15:12','648','2023-03-09 10:22:54',10,0),('1','289',81,'AFTERNOON','2023-03-07','2023-03-09 15:08:56','2023-03-10 15:08:56','970',2132096.00,2132096.00,'970','2023-03-09 15:09:57','648','2023-03-09 16:16:57',10,0),('1','289',82,'MORNING','2023-03-08','2023-03-09 18:36:51','2023-03-10 18:36:51','970',3290699.20,3290699.20,'970','2023-03-09 18:38:59','648','2023-03-10 09:28:22',10,0),('1','289',83,'AFTERNOON','2023-03-09','2023-03-10 10:01:30','2023-03-11 10:01:30','970',0.00,0.00,'970','2023-03-10 10:37:44','648','2023-03-10 13:19:19',10,0),('1','289',84,'AFTERNOON','2023-03-09','2023-03-10 15:02:51','2023-03-11 15:02:51','970',3071676.05,3071676.05,'970','2023-03-10 15:04:56','648','2023-03-10 15:44:08',10,0),('1','289',85,'MORNING','2023-03-10','2023-03-11 11:17:57','2023-03-12 11:17:57','970',5152549.55,5152549.55,'970','2023-03-11 11:24:21','648','2023-03-11 17:05:53',10,0),('1','289',86,'AFTERNOON','2023-03-11','2023-03-12 22:47:47','2023-03-13 22:47:47','970',3657984.15,3657984.15,'970','2023-03-12 23:01:44','648','2023-03-13 17:58:07',10,0),('1','289',87,'MORNING','2023-03-11','2023-03-14 00:24:54','2023-03-15 00:24:54','970',854600.00,854600.00,'970','2023-03-14 00:28:06','648','2023-03-14 08:29:09',10,0),('1','289',88,'AFTERNOON','2023-03-13','2023-03-14 12:07:32','2023-03-15 12:07:32','970',4469651.45,4469651.45,'970','2023-03-14 12:15:03','648','2023-03-14 18:37:36',10,0),('1','289',89,'MORNING','2023-03-14','2023-03-16 10:08:54','2023-03-17 10:08:54','970',4356303.85,4356303.85,'970','2023-03-16 10:15:29','648','2023-03-16 10:45:48',10,0),('1','289',90,'AFTERNOON','2023-03-15','2023-03-16 10:58:44','2023-03-17 10:58:44','970',4773019.45,4773019.45,'970','2023-03-16 11:04:57','648','2023-03-16 12:21:25',10,0),('1','289',91,'MORNING','2023-03-16','2023-03-17 09:56:46','2023-03-18 09:56:46','970',3193565.40,3193565.40,'970','2023-03-17 09:59:59','648','2023-03-17 21:38:06',10,0),('1','289',92,'AFTERNOON','2023-03-17','2023-03-18 18:32:26','2023-03-19 18:32:26','970',4565515.30,4565515.30,'970','2023-03-18 18:41:31','648','2023-03-20 08:06:14',10,0),('1','289',93,'MORNING','2023-02-24','2023-03-20 08:41:23','2023-03-21 08:41:23','970',0.00,0.00,'970','2023-03-20 08:48:37','648','2023-03-20 14:49:58',10,0),('1','289',94,'AFTERNOON','2023-03-19','2023-03-20 19:48:30','2023-03-21 19:48:30','970',2330518.50,2330518.50,'970','2023-03-20 19:52:08','','0000-00-00 00:00:00',5,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=841 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','289','1','1',1,'1','1',470868.02,470868.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','1',2,'2','1',746512.12,746512.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','1',3,'3','1',264970.34,264970.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','1',4,'4','1',151716.53,151716.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','1',5,'5','1',961141.25,961141.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','1',6,'6','1',278.38,278.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','1',7,'7','1',275.83,275.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','1',8,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','1',9,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','2',10,'1','1',470868.02,471203.51,335.49,60388.20,0.00,0.00,0.00,0.00,0.00),('1','289','1','2',11,'2','1',746512.12,746512.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','2',12,'3','1',264970.34,265235.62,265.28,47750.40,0.00,0.00,0.00,0.00,0.00),('1','289','1','2',13,'4','1',151716.53,151716.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','2',14,'5','1',961141.25,961409.43,268.18,48272.40,0.00,0.00,0.00,0.00,0.00),('1','289','2','2',15,'6','1',278.38,278.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','2',16,'7','1',275.83,536.41,260.58,46904.40,0.00,0.00,0.00,0.00,0.00),('1','289','3','2',17,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','2',18,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','3',19,'1','1',471203.51,471355.66,152.15,27387.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','3',20,'2','1',746512.12,746512.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','3',21,'3','1',265235.62,265596.61,360.99,64978.20,0.00,0.00,0.00,0.00,0.00),('1','289','1','3',22,'4','1',151716.53,151944.35,227.82,41007.60,0.00,0.00,0.00,0.00,0.00),('1','289','2','3',23,'5','1',961409.43,961409.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','3',24,'6','1',278.38,388.81,110.43,19877.40,0.00,0.00,0.00,0.00,0.00),('1','289','3','3',25,'7','1',536.41,536.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','3',26,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','3',27,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','4',28,'1','1',471355.66,471710.84,355.18,63932.40,0.00,0.00,0.00,0.00,0.00),('1','289','1','4',29,'2','1',746512.12,746512.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','4',30,'3','1',265596.61,265983.36,386.75,69615.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','4',31,'4','1',151944.35,152283.67,339.32,61077.60,0.00,0.00,0.00,0.00,0.00),('1','289','2','4',32,'5','1',961409.43,961409.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','4',33,'6','1',388.81,604.20,205.39,36970.20,0.00,0.00,10.00,0.00,0.00),('1','289','3','4',34,'7','1',536.41,536.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','4',35,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','4',36,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','5',37,'1','1',471710.84,471853.95,143.11,25759.80,0.00,0.00,0.00,0.00,0.00),('1','289','1','5',38,'2','1',746512.12,746610.50,98.38,17708.40,0.00,0.00,0.00,0.00,0.00),('1','289','1','5',39,'3','1',265983.36,266311.48,328.12,59061.60,0.00,0.00,0.00,0.00,0.00),('1','289','1','5',40,'4','1',152283.67,152283.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','5',41,'5','1',961409.43,961460.00,50.57,9102.60,0.00,0.00,0.00,0.00,0.00),('1','289','2','5',42,'6','1',604.20,604.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','5',43,'7','1',536.41,621.44,85.03,15305.40,0.00,0.00,0.00,0.00,0.00),('1','289','3','5',44,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','5',45,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','6',46,'1','1',471853.95,472125.34,271.39,48850.20,0.00,0.00,0.00,0.00,0.00),('1','289','1','6',47,'2','1',746610.50,746863.52,253.02,45543.60,0.00,0.00,0.00,0.00,0.00),('1','289','1','6',48,'3','1',266311.48,266617.65,306.17,55110.60,0.00,0.00,0.00,0.00,0.00),('1','289','1','6',49,'4','1',152283.67,152283.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','6',50,'5','1',961460.00,961678.42,218.42,39315.60,0.00,0.00,0.00,0.00,0.00),('1','289','2','6',51,'6','1',604.20,604.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','6',52,'7','1',621.44,822.21,200.77,36138.60,0.00,0.00,0.00,0.00,0.00),('1','289','3','6',53,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','6',54,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','7',55,'1','1',472125.34,472318.72,193.38,34808.40,0.00,0.00,0.00,0.00,0.00),('1','289','1','7',56,'2','1',746863.52,747040.28,176.76,31816.80,0.00,0.00,0.00,0.00,0.00),('1','289','1','7',57,'3','1',266617.65,266922.42,304.77,54858.60,0.00,0.00,0.00,0.00,0.00),('1','289','1','7',58,'4','1',152283.67,152412.42,128.75,23175.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','7',59,'5','1',961678.42,961678.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','7',60,'6','1',604.20,730.19,125.99,22678.20,0.00,0.00,0.00,0.00,0.00),('1','289','3','7',61,'7','1',822.21,822.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','7',62,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','7',63,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','8',64,'1','1',472318.72,472527.93,209.21,37657.80,0.00,0.00,0.00,0.00,0.00),('1','289','1','8',65,'2','1',747040.28,747319.26,278.98,50216.40,0.00,0.00,0.00,0.00,0.00),('1','289','1','8',66,'3','1',266922.42,267229.17,306.75,55215.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','8',67,'4','1',152412.42,152612.87,200.45,36081.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','8',68,'5','1',961678.42,961678.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','8',69,'6','1',730.19,801.88,71.69,12904.20,0.00,0.00,0.00,0.00,0.00),('1','289','3','8',70,'7','1',822.21,822.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','8',71,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','8',72,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','9',73,'1','1',472527.93,472772.52,244.59,44026.20,0.00,0.00,0.00,0.00,0.00),('1','289','1','9',74,'2','1',747319.26,747462.35,143.09,25756.20,0.00,0.00,0.00,0.00,0.00),('1','289','1','9',75,'3','1',267229.17,267496.39,267.22,48099.60,0.00,0.00,0.00,0.00,0.00),('1','289','1','9',76,'4','1',152612.87,152612.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','9',77,'5','1',961678.42,961929.59,251.17,45210.60,0.00,0.00,0.00,0.00,0.00),('1','289','2','9',78,'6','1',801.88,801.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','9',79,'7','1',822.21,911.59,89.38,16088.40,0.00,0.00,0.00,0.00,0.00),('1','289','3','9',80,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','9',81,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','11',85,'1','1',472772.52,473102.16,319.64,57535.20,0.00,0.00,10.00,0.00,0.00),('1','289','1','11',86,'2','1',747462.35,747633.03,160.68,28922.40,0.00,0.00,10.00,0.00,0.00),('1','289','1','11',87,'3','1',267496.39,267813.09,306.70,55206.00,0.00,0.00,10.00,0.00,0.00),('1','289','1','11',88,'4','1',152612.87,152735.94,113.07,20352.60,0.00,0.00,10.00,0.00,0.00),('1','289','2','11',89,'5','1',961929.59,962246.28,306.69,55204.20,0.00,0.00,10.00,0.00,0.00),('1','289','2','11',90,'6','1',801.88,801.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','11',91,'7','1',911.59,1063.89,142.30,25614.00,0.00,0.00,10.00,0.00,0.00),('1','289','3','11',92,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','11',93,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','12',94,'1','1',473102.16,473456.46,344.30,61974.00,0.00,0.00,10.00,0.00,0.00),('1','289','1','12',95,'2','1',747633.03,747633.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','12',96,'3','1',267813.09,267813.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','12',97,'4','1',152735.94,153117.38,351.44,63259.20,0.00,0.00,30.00,0.00,0.00),('1','289','2','12',98,'5','1',962246.28,962246.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','12',99,'6','1',801.88,1012.38,200.50,36090.00,0.00,0.00,10.00,0.00,0.00),('1','289','3','12',100,'7','1',1063.89,1063.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','12',101,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','12',102,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','13',103,'1','1',473456.46,474060.50,594.04,106927.20,0.00,0.00,10.00,0.00,0.00),('1','289','1','13',104,'2','1',747633.03,747633.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','13',105,'3','1',267813.09,267813.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','13',106,'4','1',153117.38,153117.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','13',107,'5','1',962246.28,962684.79,418.51,75331.80,0.00,0.00,20.00,0.00,0.00),('1','289','2','13',108,'6','1',1012.38,1115.91,103.53,18635.40,0.00,0.00,0.00,0.00,0.00),('1','289','3','13',109,'7','1',1063.89,1093.89,0.00,0.00,0.00,0.00,30.00,0.00,0.00),('1','289','3','13',110,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','13',111,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','14',112,'1','1',474060.50,474601.69,541.19,97414.20,0.00,0.00,0.00,0.00,0.00),('1','289','1','14',113,'2','1',747633.03,747633.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','14',114,'3','1',267813.09,268238.96,425.87,76656.60,0.00,0.00,0.00,0.00,0.00),('1','289','1','14',115,'4','1',153117.38,153117.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','14',116,'5','1',962684.79,962684.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','14',117,'6','1',1115.91,1329.19,213.28,38390.40,0.00,0.00,0.00,0.00,0.00),('1','289','3','14',118,'7','1',1093.89,1093.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','14',119,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','14',120,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','15',121,'1','1',474601.69,475204.45,602.76,108496.80,0.00,0.00,0.00,0.00,0.00),('1','289','1','15',122,'2','1',747633.03,747633.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','15',123,'3','1',268238.96,268238.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','15',124,'4','1',153117.38,153856.93,739.55,133119.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','15',125,'5','1',962684.79,962684.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','15',126,'6','1',1329.19,1417.28,88.09,15856.20,0.00,0.00,0.00,0.00,0.00),('1','289','3','15',127,'7','1',1093.89,1093.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','15',128,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','15',129,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','16',130,'1','1',475204.45,476203.69,999.24,179863.20,0.00,0.00,0.00,0.00,0.00),('1','289','1','16',131,'2','1',747633.03,747633.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','16',132,'3','1',268238.96,268238.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','16',133,'4','1',153856.93,153856.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','16',134,'5','1',962684.79,963426.00,721.21,129817.80,0.00,0.00,20.00,0.00,0.00),('1','289','2','16',135,'6','1',1417.28,2358.98,901.37,162246.60,0.00,0.00,40.33,0.00,0.00),('1','289','3','16',136,'7','1',1093.89,1093.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','16',137,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','16',138,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','17',139,'1','1',476203.69,478970.68,2766.99,498058.20,0.00,0.00,0.00,0.00,0.00),('1','289','1','17',140,'2','1',747633.03,747826.73,193.70,34866.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','17',141,'3','1',268238.96,271473.64,3234.68,582242.40,0.00,0.00,0.00,0.00,0.00),('1','289','1','17',142,'4','1',153856.93,154335.32,478.39,86110.20,0.00,0.00,0.00,0.00,0.00),('1','289','2','17',143,'5','1',963426.00,963426.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','17',144,'6','1',2358.98,4837.12,2478.14,446065.20,0.00,0.00,0.00,0.00,0.00),('1','289','3','17',145,'7','1',1093.89,1093.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','17',146,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','17',147,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','18',148,'1','1',478970.68,480792.90,1822.22,327999.60,0.00,0.00,0.00,0.00,0.00),('1','289','1','18',149,'2','1',747826.73,747826.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','18',150,'3','1',271473.64,273433.97,1960.33,352859.40,0.00,0.00,0.00,0.00,0.00),('1','289','1','18',151,'4','1',154335.32,154335.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','18',152,'5','1',963426.00,963426.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','18',153,'6','1',4837.12,6523.96,1686.84,303631.20,0.00,0.00,0.00,0.00,0.00),('1','289','3','18',154,'7','1',1093.89,1093.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','18',155,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','18',156,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','19',157,'1','1',480792.90,482372.00,1579.10,284238.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','19',158,'2','1',747826.73,747826.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','19',159,'3','1',273433.97,273464.80,0.83,149.40,0.00,0.00,30.00,0.00,0.00),('1','289','1','19',160,'4','1',154335.32,154393.99,44.95,8091.00,0.00,0.00,13.72,0.00,0.00),('1','289','2','19',161,'5','1',963426.00,963478.92,42.92,7725.60,0.00,0.00,10.00,0.00,0.00),('1','289','2','19',162,'6','1',6523.96,8252.10,1728.14,311065.20,0.00,0.00,0.00,0.00,0.00),('1','289','3','19',163,'7','1',1093.89,1093.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','19',164,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','19',165,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','20',166,'1','1',482372.00,483410.99,1038.99,187018.20,0.00,0.00,0.00,0.00,0.00),('1','289','1','20',167,'2','1',747826.73,747898.58,51.85,9333.00,0.00,0.00,20.00,0.00,0.00),('1','289','1','20',168,'3','1',273464.80,273464.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','20',169,'4','1',154393.99,155041.09,647.10,116478.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','20',170,'5','1',963478.92,963478.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','20',171,'6','1',8252.10,9135.44,883.34,159001.20,0.00,0.00,0.00,0.00,0.00),('1','289','3','20',172,'7','1',1093.89,1093.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','20',173,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','20',174,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','21',175,'1','1',483410.99,484588.18,1177.19,211894.20,0.00,0.00,0.00,0.00,0.00),('1','289','1','21',176,'2','1',747898.58,747898.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','21',177,'3','1',273464.80,273553.77,88.97,16014.60,0.00,0.00,0.00,0.00,0.00),('1','289','1','21',178,'4','1',155041.09,156347.47,1306.38,235148.40,0.00,0.00,0.00,0.00,0.00),('1','289','2','21',179,'5','1',963478.92,963478.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','21',180,'6','1',9135.44,9135.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','21',181,'7','1',1093.89,1093.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','21',182,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','21',183,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','22',184,'1','1',484588.18,485289.98,701.80,126324.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','22',185,'2','1',747898.58,747898.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','22',186,'3','1',273553.77,274128.31,574.54,103417.20,0.00,0.00,0.00,0.00,0.00),('1','289','1','22',187,'4','1',156347.47,156347.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','22',188,'5','1',963478.92,963478.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','22',189,'6','1',9135.44,9738.78,603.34,108601.20,0.00,0.00,0.00,0.00,0.00),('1','289','3','22',190,'7','1',1093.89,1093.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','22',191,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','22',192,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','23',193,'1','1',485289.98,486984.64,1694.66,305038.80,0.00,0.00,0.00,0.00,0.00),('1','289','1','23',194,'2','1',747898.58,747898.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','23',195,'3','1',274128.31,274128.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','23',196,'4','1',156347.47,158026.16,1678.69,302164.20,0.00,0.00,0.00,0.00,540.00),('1','289','2','23',197,'5','1',963478.92,963478.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','23',198,'6','1',9738.78,9738.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','23',199,'7','1',1093.89,1093.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','23',200,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','23',201,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','24',202,'1','1',486984.64,488008.89,1024.25,184365.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','24',203,'2','1',747898.58,747898.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','24',204,'3','1',274128.31,274128.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','24',205,'4','1',158026.16,158096.76,70.60,12708.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','24',206,'5','1',963478.92,964007.08,528.16,95068.80,0.00,0.00,0.00,0.00,0.00),('1','289','2','24',207,'6','1',9738.78,10313.98,575.20,103536.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','24',208,'7','1',1093.89,1093.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','24',209,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','24',210,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','25',211,'1','1',488008.89,488549.17,422.08,75974.40,0.00,0.00,118.20,0.00,0.00),('1','289','1','25',212,'2','1',747898.58,747898.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','25',213,'3','1',274128.31,274128.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','25',214,'4','1',158096.76,158096.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','25',215,'5','1',964007.08,964007.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','25',216,'6','1',10313.98,10766.49,389.02,70023.60,0.00,0.00,63.49,0.00,0.00),('1','289','3','25',217,'7','1',1093.89,1093.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','25',218,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','25',219,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','26',220,'1','1',488549.17,489562.53,1013.36,182404.80,0.00,0.00,0.00,0.00,0.00),('1','289','1','26',221,'2','1',747898.58,747898.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','26',222,'3','1',274128.31,274128.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','26',223,'4','1',158096.76,158096.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','26',224,'5','1',964007.08,964150.97,143.89,25900.20,0.00,0.00,0.00,0.00,0.00),('1','289','2','26',225,'6','1',10766.49,11417.41,650.92,117165.60,0.00,0.00,0.00,0.00,0.00),('1','289','3','26',226,'7','1',1093.89,1093.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','26',227,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','26',228,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','27',229,'1','1',489562.53,490420.44,857.91,154423.80,0.00,0.00,0.00,0.00,0.00),('1','289','1','27',230,'2','1',747898.58,747898.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','27',231,'3','1',274128.31,274128.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','27',232,'4','1',158096.76,158959.27,862.51,155251.80,0.00,0.00,0.00,0.00,0.00),('1','289','2','27',233,'5','1',964150.97,964150.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','27',234,'6','1',11417.41,11901.35,483.94,87109.20,0.00,0.00,0.00,0.00,0.00),('1','289','3','27',235,'7','1',1093.89,1093.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','27',236,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','27',237,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','28',238,'1','1',490420.44,490420.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','28',239,'2','1',747898.58,747898.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','28',240,'3','1',274128.31,275749.15,1620.84,291751.20,0.00,0.00,0.00,0.00,0.00),('1','289','1','28',241,'4','1',158959.27,158959.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','28',242,'5','1',964150.97,964150.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','28',243,'6','1',11901.35,13526.81,1625.46,292582.80,0.00,0.00,0.00,0.00,0.00),('1','289','3','28',244,'7','1',1093.89,1093.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','28',245,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','28',246,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','29',247,'1','1',490420.44,491683.00,1262.56,227260.80,0.00,0.00,0.00,0.00,0.00),('1','289','1','29',248,'2','1',747898.58,747898.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','29',249,'3','1',275749.15,276638.78,889.63,160133.40,0.00,0.00,0.00,0.00,0.00),('1','289','1','29',250,'4','1',158959.27,158959.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','29',251,'5','1',964150.97,965159.34,1008.37,181506.60,0.00,0.00,0.00,0.00,0.00),('1','289','2','29',252,'6','1',13526.81,13526.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','29',253,'7','1',1093.89,1093.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','29',254,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','29',255,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','30',256,'1','1',491683.00,493368.95,1685.95,303471.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','30',257,'2','1',747898.58,747898.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','30',258,'3','1',276638.78,276790.91,152.13,27383.40,0.00,0.00,0.00,0.00,0.00),('1','289','1','30',259,'4','1',158959.27,158959.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','30',260,'5','1',965159.34,965159.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','30',261,'6','1',13526.81,14838.78,1311.97,236154.60,0.00,0.00,0.00,0.00,0.00),('1','289','3','30',262,'7','1',1093.89,1093.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','30',263,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','30',264,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','31',265,'1','1',493368.95,494344.79,975.84,175651.20,0.00,0.00,0.00,0.00,0.00),('1','289','1','31',266,'2','1',747898.58,747898.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','31',267,'3','1',276790.91,276790.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','31',268,'4','1',158959.27,159412.97,453.70,81666.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','31',269,'5','1',965159.34,965159.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','31',270,'6','1',14838.78,15750.45,911.67,164100.60,0.00,0.00,0.00,0.00,0.00),('1','289','3','31',271,'7','1',1093.89,1093.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','31',272,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','31',273,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','32',274,'1','1',494344.79,495356.11,1011.32,182037.60,0.00,0.00,0.00,0.00,0.00),('1','289','1','32',275,'2','1',747898.58,748048.33,149.75,26955.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','32',276,'3','1',276790.91,276790.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','32',277,'4','1',159412.97,159412.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','32',278,'5','1',965159.34,965523.36,364.02,65523.60,0.00,0.00,0.00,0.00,0.00),('1','289','2','32',279,'6','1',15750.45,17185.42,1434.97,258294.60,0.00,0.00,0.00,0.00,0.00),('1','289','3','32',280,'7','1',1093.89,1093.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','32',281,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','32',282,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','33',283,'1','1',495356.11,496468.77,1112.66,200278.80,0.00,0.00,0.00,0.00,0.00),('1','289','1','33',284,'2','1',748048.33,748048.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','33',285,'3','1',276790.91,276790.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','33',286,'4','1',159412.97,160062.22,649.25,116865.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','33',287,'5','1',965523.36,965523.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','33',288,'6','1',17185.42,17897.78,712.36,128224.80,0.00,0.00,0.00,0.00,0.00),('1','289','3','33',289,'7','1',1093.89,1093.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','33',290,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','33',291,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','34',292,'1','1',496468.77,496468.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','34',293,'2','1',748048.33,748048.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','34',294,'3','1',276790.91,276790.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','34',295,'4','1',160062.22,160062.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','34',296,'5','1',965523.36,965523.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','34',297,'6','1',17897.78,17897.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','34',298,'7','1',1093.89,1093.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','34',299,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','34',300,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','35',301,'1','1',496468.77,496468.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','35',302,'2','1',748048.33,748048.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','35',303,'3','1',276790.91,276790.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','35',304,'4','1',160062.22,160062.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','35',305,'5','1',965523.36,965523.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','35',306,'6','1',17897.78,19109.55,1211.77,218118.60,0.00,0.00,0.00,0.00,0.00),('1','289','3','35',307,'7','1',1093.89,2562.62,1468.73,264371.40,0.00,0.00,0.00,0.00,0.00),('1','289','3','35',308,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','35',309,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','36',310,'1','1',496468.77,496468.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','36',311,'2','1',748048.33,748048.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','36',312,'3','1',276790.91,276790.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','36',313,'4','1',160062.22,160062.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','36',314,'5','1',965523.36,965523.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','36',315,'6','1',19109.55,20347.71,1238.16,222868.80,0.00,0.00,0.00,0.00,0.00),('1','289','3','36',316,'7','1',2562.62,4179.24,1616.62,290991.60,0.00,0.00,0.00,0.00,0.00),('1','289','3','36',317,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','36',318,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','37',319,'1','1',496468.77,496468.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','37',320,'2','1',748048.33,748048.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','37',321,'3','1',276790.91,276790.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','37',322,'4','1',160062.22,160062.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','37',323,'5','1',965523.36,965523.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','37',324,'6','1',20347.71,21228.96,881.25,158625.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','37',325,'7','1',4179.24,5250.44,1071.20,192816.00,0.00,0.00,0.00,0.00,0.00),('1','289','3','37',326,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','37',327,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','38',328,'1','1',496468.77,496468.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','38',329,'2','1',748048.33,748048.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','38',330,'3','1',276790.91,276790.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','38',331,'4','1',160062.22,160062.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','38',332,'5','1',965523.36,965523.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','38',333,'6','1',21228.96,22519.54,1290.58,232304.40,0.00,0.00,0.00,0.00,0.00),('1','289','3','38',334,'7','1',5250.44,6592.70,1342.26,241606.80,0.00,0.00,0.00,0.00,0.00),('1','289','3','38',335,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','38',336,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','39',337,'1','1',496468.77,496468.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','39',338,'2','1',748048.33,748048.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','39',339,'3','1',276790.91,276790.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','39',340,'4','1',160062.22,160062.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','39',341,'5','1',965523.36,965523.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','39',342,'6','1',22519.54,24154.28,1634.74,294253.20,0.00,0.00,0.00,0.00,0.00),('1','289','3','39',343,'7','1',6592.70,7891.04,1298.34,233701.20,0.00,0.00,0.00,0.00,0.00),('1','289','3','39',344,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','39',345,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','40',346,'1','1',496468.77,496468.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','40',347,'2','1',748048.33,748048.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','40',348,'3','1',276790.91,276790.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','40',349,'4','1',160062.22,160062.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','40',350,'5','1',965523.36,965523.36,-106.85,-19233.00,0.00,0.00,106.85,0.00,0.00),('1','289','2','40',351,'6','1',24154.28,25938.96,1580.54,284497.20,0.00,0.00,204.14,0.00,0.00),('1','289','3','40',352,'7','1',7891.04,9671.31,1780.27,320448.60,0.00,0.00,0.00,0.00,0.00),('1','289','3','40',353,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','40',354,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','41',355,'1','1',496468.77,496468.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','41',356,'2','1',748048.33,748048.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','41',357,'3','1',276790.91,276790.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','41',358,'4','1',160062.22,160062.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','41',359,'5','1',965523.36,965523.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','41',360,'6','1',25938.96,27637.43,1698.47,305724.60,0.00,0.00,0.00,0.00,0.00),('1','289','3','41',361,'7','1',9671.31,11211.43,1540.12,277221.60,0.00,0.00,0.00,0.00,0.00),('1','289','3','41',362,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','41',363,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','42',364,'1','1',496468.77,496468.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','42',365,'2','1',748048.33,748048.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','42',366,'3','1',276790.91,276790.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','42',367,'4','1',160062.22,160062.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','42',368,'5','1',965523.36,965523.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','2','42',369,'6','1',27637.43,28901.72,1264.29,227572.20,0.00,0.00,0.00,0.00,0.00),('1','289','3','42',370,'7','1',11211.43,12597.82,1386.39,249550.20,0.00,0.00,0.00,0.00,0.00),('1','289','3','42',371,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','42',372,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','43',373,'1','1',496468.77,498196.23,1727.46,310942.80,0.00,0.00,0.00,0.00,0.00),('1','289','1','43',374,'2','1',748048.33,748048.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','43',375,'3','1',276790.91,276938.78,147.87,26616.60,0.00,0.00,0.00,0.00,0.00),('1','289','1','43',376,'4','1',160062.22,161267.50,1205.28,216950.40,0.00,0.00,0.00,0.00,0.00),('1','289','1','43',377,'5','1',965523.36,965523.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','43',378,'6','1',28901.72,28901.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','43',379,'7','1',12597.82,13075.21,477.39,85930.20,0.00,0.00,0.00,0.00,0.00),('1','289','1','43',380,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','43',381,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','44',382,'1','1',498196.23,498208.83,12.60,2268.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','44',383,'2','1',748048.33,748048.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','44',384,'3','1',276938.78,277283.99,345.21,62137.80,0.00,0.00,0.00,0.00,0.00),('1','289','1','44',385,'4','1',161267.50,161267.50,-12.07,-2172.60,0.00,0.00,12.07,0.00,0.00),('1','289','1','44',386,'5','1',965523.36,965523.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','44',387,'6','1',28901.72,28901.72,-38.07,-6852.60,0.00,0.00,38.07,0.00,0.00),('1','289','1','44',388,'7','1',13075.21,13104.50,29.29,5272.20,0.00,0.00,0.00,0.00,0.00),('1','289','1','44',389,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','44',390,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','45',391,'1','1',498208.83,499852.87,1644.04,345248.40,0.00,0.00,0.00,0.00,0.00),('1','289','1','45',392,'2','1',748048.33,748048.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','45',393,'3','1',277283.99,277283.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','45',394,'4','1',161267.50,161267.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','45',395,'5','1',965523.36,966829.84,1306.48,274360.80,0.00,0.00,0.00,0.00,0.00),('1','289','1','45',396,'6','1',28901.72,28901.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','45',397,'7','1',13104.50,13104.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','45',398,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','45',399,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','46',400,'1','1',499852.87,501372.04,1519.17,319025.70,0.00,0.00,0.00,0.00,0.00),('1','289','1','46',401,'2','1',748048.33,748048.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','46',402,'3','1',277283.99,278908.41,1624.42,341128.20,0.00,0.00,0.00,0.00,0.00),('1','289','1','46',403,'4','1',161267.50,161267.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','46',404,'5','1',966829.84,967110.49,280.65,58936.50,0.00,0.00,0.00,0.00,0.00),('1','289','1','46',405,'6','1',28901.72,28901.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','46',406,'7','1',13104.50,13104.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','46',407,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','46',408,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','47',409,'1','1',501372.04,502992.34,1620.30,340263.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','47',410,'2','1',748048.33,748048.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','47',411,'3','1',278908.41,281412.96,2504.55,525955.50,0.00,0.00,0.00,0.00,0.00),('1','289','1','47',412,'4','1',161267.50,161267.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','47',413,'5','1',967110.49,967110.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','47',414,'6','1',28901.72,28901.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','47',415,'7','1',13104.50,13104.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','47',416,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','47',417,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','48',418,'1','1',502992.34,502992.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','48',419,'2','1',748048.33,748048.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','48',420,'3','1',281412.96,281412.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','48',421,'4','1',161267.50,161267.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','48',422,'5','1',967110.49,967110.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','48',423,'6','1',28901.72,28901.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','48',424,'7','1',13104.50,13104.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','48',425,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','48',426,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','49',427,'1','1',502992.34,505060.76,2058.42,432268.20,0.00,0.00,10.00,0.00,0.00),('1','289','1','49',428,'2','1',748048.33,748048.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','49',429,'3','1',281412.96,281412.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','49',430,'4','1',161267.50,163597.76,2320.26,487254.60,0.00,0.00,10.00,0.00,0.00),('1','289','1','49',431,'5','1',967110.49,967110.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','49',432,'6','1',28901.72,28901.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','49',433,'7','1',13104.50,13104.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','49',434,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','49',435,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','50',436,'1','1',505060.76,505060.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','50',437,'2','1',748048.33,748048.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','50',438,'3','1',281412.96,281412.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','50',439,'4','1',163597.76,163597.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','50',440,'5','1',967110.49,967110.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','50',441,'6','1',28901.72,28901.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','50',442,'7','1',13104.50,13104.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','50',443,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','50',444,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','51',445,'1','1',505060.76,505060.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','51',446,'2','1',748048.33,748048.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','51',447,'3','1',281412.96,281412.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','51',448,'4','1',163597.76,163597.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','51',449,'5','1',967110.49,967110.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','51',450,'6','1',28901.72,28901.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','51',451,'7','1',13104.50,13104.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','51',452,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','51',453,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','52',454,'1','1',505060.76,506068.69,905.41,190136.10,0.00,0.00,102.52,0.00,0.00),('1','289','1','52',455,'2','1',748048.33,748048.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','52',456,'3','1',281412.96,281412.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','52',457,'4','1',163597.76,167290.74,3552.84,746096.40,0.00,0.00,140.14,0.00,0.00),('1','289','1','52',458,'5','1',967110.49,967110.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','52',459,'6','1',28901.72,30542.96,1641.24,344660.40,0.00,0.00,0.00,0.00,0.00),('1','289','1','52',460,'7','1',13104.50,13104.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','52',461,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','52',462,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','53',463,'1','1',506068.69,506068.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','53',464,'2','1',748048.33,748252.47,204.14,42869.40,0.00,0.00,0.00,0.00,0.00),('1','289','1','53',465,'3','1',281412.96,281412.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','53',466,'4','1',167290.74,167290.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','53',467,'5','1',967110.49,967110.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','53',468,'6','1',30542.96,30542.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','53',469,'7','1',13104.50,13104.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','53',470,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','53',471,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','54',472,'1','1',506068.69,508504.56,2435.87,511532.70,0.00,0.00,0.00,0.00,0.00),('1','289','1','54',473,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','54',474,'3','1',281412.96,281412.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','54',475,'4','1',167290.74,170122.48,2831.74,594665.40,0.00,0.00,0.00,0.00,0.00),('1','289','1','54',476,'5','1',967110.49,967110.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','54',477,'6','1',30542.96,30542.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','54',478,'7','1',13104.50,13104.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','54',479,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','54',480,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','55',481,'1','1',508504.56,511362.84,2858.28,600238.80,0.00,0.00,0.00,0.00,0.00),('1','289','1','55',482,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','55',483,'3','1',281412.96,283485.63,2072.67,435260.70,0.00,0.00,0.00,0.00,0.00),('1','289','1','55',484,'4','1',170122.48,170122.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','55',485,'5','1',967110.49,967110.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','55',486,'6','1',30542.96,30542.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','55',487,'7','1',13104.50,13104.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','55',488,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','55',489,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','56',490,'1','1',511362.84,513323.56,1960.72,411751.20,0.00,0.00,0.00,0.00,0.00),('1','289','1','56',491,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','56',492,'3','1',283485.63,283580.00,94.37,19817.70,0.00,0.00,0.00,0.00,0.00),('1','289','1','56',493,'4','1',170122.48,172009.06,1886.58,396181.80,0.00,0.00,0.00,0.00,0.00),('1','289','1','56',494,'5','1',967110.49,968625.45,1514.96,318141.60,0.00,0.00,0.00,0.00,0.00),('1','289','1','56',495,'6','1',30542.96,30572.46,29.50,6195.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','56',496,'7','1',13104.50,13104.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','56',497,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','56',498,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','57',499,'1','1',513323.56,515589.72,2266.16,475893.60,0.00,0.00,0.00,0.00,0.00),('1','289','1','57',500,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','57',501,'3','1',283580.00,283580.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','57',502,'4','1',172009.06,172479.53,470.47,98798.70,0.00,0.00,0.00,0.00,0.00),('1','289','1','57',503,'5','1',968625.45,968625.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','57',504,'6','1',30572.46,30715.33,142.87,30002.70,0.00,0.00,0.00,0.00,0.00),('1','289','1','57',505,'7','1',13104.50,15485.98,2381.48,500110.80,0.00,0.00,0.00,0.00,0.00),('1','289','1','57',506,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','57',507,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','58',508,'1','1',515589.72,517415.07,1825.35,383323.50,0.00,0.00,0.00,0.00,0.00),('1','289','1','58',509,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','58',510,'3','1',283580.00,283591.92,11.92,2503.20,0.00,0.00,0.00,0.00,0.00),('1','289','1','58',511,'4','1',172479.53,172549.53,70.00,14700.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','58',512,'5','1',968625.45,968967.65,342.20,71862.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','58',513,'6','1',30715.33,30725.33,10.00,2100.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','58',514,'7','1',15485.98,17381.91,1895.93,398145.30,0.00,0.00,0.00,0.00,0.00),('1','289','1','58',515,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','58',516,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','59',517,'1','1',517415.07,519870.23,2455.16,515583.60,0.00,0.00,0.00,0.00,0.00),('1','289','1','59',518,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','59',519,'3','1',283591.92,283591.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','59',520,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','59',521,'5','1',968967.65,968967.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','59',522,'6','1',30725.33,30725.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','59',523,'7','1',17381.91,20405.28,3023.37,634907.70,0.00,0.00,0.00,0.00,0.00),('1','289','1','59',524,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','59',525,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','60',526,'1','1',519870.23,522576.43,2706.20,568302.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','60',527,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','60',528,'3','1',283591.92,283591.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','60',529,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','60',530,'5','1',968967.65,968967.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','60',531,'6','1',30725.33,30725.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','60',532,'7','1',20405.28,22786.10,2380.82,499972.20,0.00,0.00,0.00,0.00,0.00),('1','289','1','60',533,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','60',534,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','61',535,'1','1',522576.43,522934.31,357.88,75154.80,0.00,0.00,0.00,0.00,0.00),('1','289','1','61',536,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','61',537,'3','1',283591.92,284371.03,779.11,163613.10,0.00,0.00,0.00,0.00,0.00),('1','289','1','61',538,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','61',539,'5','1',968967.65,968967.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','61',540,'6','1',30725.33,30725.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','61',541,'7','1',22786.10,23595.09,808.99,169887.90,0.00,0.00,0.00,0.00,0.00),('1','289','1','61',542,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','61',543,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','62',544,'1','1',522934.31,524721.84,1787.53,375381.30,0.00,0.00,0.00,0.00,0.00),('1','289','1','62',545,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','62',546,'3','1',284371.03,284371.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','62',547,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','62',548,'5','1',968967.65,968967.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','62',549,'6','1',30725.33,30725.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','62',550,'7','1',23595.09,23973.29,378.20,79422.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','62',551,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','62',552,'9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','63',553,'1','1',524721.84,524721.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','63',554,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','63',555,'3','1',284371.03,284371.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','63',556,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','63',557,'5','1',968967.65,968967.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','63',558,'6','1',30725.33,30725.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','63',559,'7','1',23973.29,23973.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','63',560,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','63',561,'9','2',733360.78,734610.86,1250.08,987563.20,0.00,0.00,0.00,0.00,0.00),('1','289','1','64',562,'1','1',524721.84,524721.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','64',563,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','64',564,'3','1',284371.03,284371.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','64',565,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','64',566,'5','1',968967.65,968967.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','64',567,'6','1',30725.33,30725.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','64',568,'7','1',23973.29,23973.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','64',569,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','64',570,'9','2',734610.86,735951.40,1340.54,1059026.60,0.00,0.00,0.00,0.00,0.00),('1','289','1','65',571,'1','1',524721.84,524721.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','65',572,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','65',573,'3','1',284371.03,284371.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','65',574,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','65',575,'5','1',968967.65,968967.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','65',576,'6','1',30725.33,30725.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','65',577,'7','1',23973.29,23973.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','65',578,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','65',579,'9','2',735951.40,738683.72,2732.32,2158532.80,0.00,0.00,0.00,0.00,0.00),('1','289','1','66',580,'1','1',524721.84,524721.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','66',581,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','66',582,'3','1',284371.03,284371.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','66',583,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','66',584,'5','1',968967.65,968967.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','66',585,'6','1',30725.33,30725.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','66',586,'7','1',23973.29,23973.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','66',587,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','66',588,'9','2',738683.72,738708.97,25.25,19947.50,0.00,0.00,0.00,0.00,0.00),('1','289','1','67',589,'1','1',524721.84,524721.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','67',590,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','67',591,'3','1',284371.03,284371.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','67',592,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','67',593,'5','1',968967.65,968967.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','67',594,'6','1',30725.33,30725.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','67',595,'7','1',23973.29,23973.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','67',596,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','67',597,'9','2',738708.97,739456.15,747.18,590272.20,0.00,0.00,0.00,0.00,0.00),('1','289','1','68',598,'1','1',524721.84,524721.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','68',599,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','68',600,'3','1',284371.03,284371.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','68',601,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','68',602,'5','1',968967.65,968967.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','68',603,'6','1',30725.33,30725.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','68',604,'7','1',23973.29,23973.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','68',605,'8','2',537008.25,537421.54,413.29,326499.10,0.00,0.00,0.00,0.00,0.00),('1','289','4','68',606,'9','2',739456.15,739456.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','69',607,'1','1',524721.84,524721.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','69',608,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','69',609,'3','1',284371.03,284371.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','69',610,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','69',611,'5','1',968967.65,968967.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','69',612,'6','1',30725.33,30725.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','69',613,'7','1',23973.29,23973.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','69',614,'8','2',537421.54,537421.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','69',615,'9','2',739456.15,739962.48,506.33,400000.70,0.00,0.00,0.00,0.00,0.00),('1','289','1','70',616,'1','1',524721.84,524721.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','70',617,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','70',618,'3','1',284371.03,284371.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','70',619,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','70',620,'5','1',968967.65,968967.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','70',621,'6','1',30725.33,30725.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','70',622,'7','1',23973.29,23973.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','70',623,'8','2',537421.54,537421.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','70',624,'9','2',739962.48,740661.27,698.79,552044.10,0.00,0.00,0.00,0.00,0.00),('1','289','1','71',625,'1','1',524721.84,524721.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','71',626,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','71',627,'3','1',284371.03,284371.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','71',628,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','71',629,'5','1',968967.65,968967.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','71',630,'6','1',30725.33,30725.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','71',631,'7','1',23973.29,23973.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','71',632,'8','2',537421.54,537421.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','71',633,'9','2',740661.27,741463.84,802.57,634030.30,0.00,0.00,0.00,0.00,0.00),('1','289','1','72',634,'1','1',524721.84,524721.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','72',635,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','72',636,'3','1',284371.03,284371.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','72',637,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','72',638,'5','1',968967.65,968967.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','72',639,'6','1',30725.33,30725.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','72',640,'7','1',23973.29,23973.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','72',641,'8','2',537421.54,537421.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','72',642,'9','2',741463.84,742806.34,1342.50,1060575.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','73',643,'1','1',524721.84,524721.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','73',644,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','73',645,'3','1',284371.03,284371.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','73',646,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','73',647,'5','1',968967.65,968967.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','73',648,'6','1',30725.33,30725.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','73',649,'7','1',23973.29,23973.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','73',650,'8','2',537421.54,542428.67,5007.13,3955632.70,0.00,0.00,0.00,0.00,0.00),('1','289','4','73',651,'9','2',742806.34,757379.46,14573.12,11512764.80,0.00,0.00,0.00,0.00,0.00),('1','289','1','74',652,'1','1',524721.84,524721.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','74',653,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','74',654,'3','1',284371.03,286126.02,1754.99,412422.65,0.00,0.00,0.00,0.00,0.00),('1','289','1','74',655,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','74',656,'5','1',968967.65,970664.83,1697.18,398837.30,0.00,0.00,0.00,0.00,0.00),('1','289','1','74',657,'6','1',30725.33,30725.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','74',658,'7','1',23973.29,23973.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','74',659,'8','2',542428.67,542428.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','74',660,'9','2',757379.46,757379.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','75',661,'1','1',524721.84,524721.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','75',662,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','75',663,'3','1',286126.02,288220.75,2094.73,492261.55,0.00,0.00,0.00,0.00,0.00),('1','289','1','75',664,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','75',665,'5','1',970664.83,972105.81,1440.98,338630.30,0.00,0.00,0.00,0.00,0.00),('1','289','1','75',666,'6','1',30725.33,30725.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','75',667,'7','1',23973.29,23973.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','75',668,'8','2',542428.67,542428.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','75',669,'9','2',757379.46,757379.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','76',670,'1','1',524721.84,524721.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','76',671,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','76',672,'3','1',288220.75,291076.02,2855.27,670988.45,0.00,0.00,0.00,0.00,0.00),('1','289','1','76',673,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','76',674,'5','1',972105.81,974651.32,2545.51,598194.85,0.00,0.00,0.00,0.00,0.00),('1','289','1','76',675,'6','1',30725.33,30725.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','76',676,'7','1',23973.29,23973.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','76',677,'8','2',542428.67,542428.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','76',678,'9','2',757379.46,757379.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','77',679,'1','1',524721.84,524721.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','77',680,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','77',681,'3','1',291076.02,295156.93,4080.91,959013.85,0.00,0.00,0.00,0.00,0.00),('1','289','1','77',682,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','77',683,'5','1',974651.32,978223.56,3572.24,839476.40,0.00,0.00,0.00,0.00,0.00),('1','289','1','77',684,'6','1',30725.33,30725.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','77',685,'7','1',23973.29,23973.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','77',686,'8','2',542428.67,542428.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','77',687,'9','2',757379.46,757379.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','78',688,'1','1',524721.84,524721.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','78',689,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','78',690,'3','1',295156.93,299716.95,4560.02,1071604.70,0.00,0.00,0.00,0.00,0.00),('1','289','1','78',691,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','78',692,'5','1',978223.56,978223.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','78',693,'6','1',30725.33,30725.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','78',694,'7','1',23973.29,28294.04,4320.75,1015376.25,0.00,0.00,0.00,0.00,0.00),('1','289','4','78',695,'8','2',542428.67,542428.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','78',696,'9','2',757379.46,757379.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','79',697,'1','1',524721.84,524721.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','79',698,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','79',699,'3','1',299716.95,299716.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','79',700,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','79',701,'5','1',978223.56,978223.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','79',702,'6','1',30725.33,30725.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','79',703,'7','1',28294.04,28294.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','79',704,'8','2',542428.67,542428.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','79',705,'9','2',757379.46,758227.46,848.00,678400.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','80',706,'1','1',524721.84,527877.48,3155.64,741575.40,0.00,0.00,0.00,0.00,0.00),('1','289','1','80',707,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','80',708,'3','1',299716.95,300102.43,385.48,90587.80,0.00,0.00,0.00,0.00,0.00),('1','289','1','80',709,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','80',710,'5','1',978223.56,982438.38,4214.82,990482.70,0.00,0.00,0.00,0.00,0.00),('1','289','1','80',711,'6','1',30725.33,30725.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','80',712,'7','1',28294.04,31090.68,2796.64,657210.40,0.00,0.00,0.00,0.00,0.00),('1','289','4','80',713,'8','2',542428.67,542428.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','80',714,'9','2',758227.46,758227.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','81',715,'1','1',527877.48,527877.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','81',716,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','81',717,'3','1',300102.43,300102.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','81',718,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','81',719,'5','1',982438.38,982438.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','81',720,'6','1',30725.33,30725.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','81',721,'7','1',31090.68,31090.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','81',722,'8','2',542428.67,542428.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','81',723,'9','2',758227.46,760892.58,2665.12,2132096.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','82',724,'1','1',527877.48,529706.80,1829.32,429890.20,0.00,0.00,0.00,0.00,0.00),('1','289','1','82',725,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','82',726,'3','1',300102.43,300102.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','82',727,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','82',728,'5','1',982438.38,984267.92,1829.54,429941.90,0.00,0.00,0.00,0.00,0.00),('1','289','1','82',729,'6','1',30725.33,30725.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','82',730,'7','1',31090.68,32483.34,1392.66,327275.10,0.00,0.00,0.00,0.00,0.00),('1','289','4','82',731,'8','2',542428.67,542428.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','82',732,'9','2',760892.58,763522.07,2629.49,2103592.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','83',733,'1','1',529706.80,529706.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','83',734,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','83',735,'3','1',300102.43,300102.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','83',736,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','83',737,'5','1',984267.92,984267.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','83',738,'6','1',30725.33,30725.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','83',739,'7','1',32483.34,32483.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','83',740,'8','2',542428.67,542428.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','83',741,'9','2',763522.07,763522.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','84',742,'1','1',529706.80,534026.90,4320.10,1015223.50,0.00,0.00,0.00,0.00,0.00),('1','289','1','84',743,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','84',744,'3','1',300102.43,300102.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','84',745,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','84',746,'5','1',984267.92,987727.00,3459.08,812883.80,0.00,0.00,0.00,0.00,0.00),('1','289','1','84',747,'6','1',30725.33,33785.18,3059.85,719064.75,0.00,0.00,0.00,0.00,0.00),('1','289','1','84',748,'7','1',32483.34,32483.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','84',749,'8','2',542428.67,542428.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','84',750,'9','2',763522.07,764177.70,655.63,524504.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','85',751,'1','1',534026.90,539404.33,5377.43,1263696.05,0.00,0.00,0.00,0.00,0.00),('1','289','1','85',752,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','85',753,'3','1',300102.43,304407.84,4305.41,1011771.35,0.00,0.00,0.00,0.00,0.00),('1','289','1','85',754,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','85',755,'5','1',987727.00,991866.89,4139.89,972874.15,0.00,0.00,0.00,0.00,0.00),('1','289','1','85',756,'6','1',33785.18,33785.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','85',757,'7','1',32483.34,32483.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','85',758,'8','2',542428.67,542428.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','85',759,'9','2',764177.70,766557.96,2380.26,1904208.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','86',760,'1','1',539404.33,545454.01,6049.68,1421674.80,0.00,0.00,0.00,0.00,0.00),('1','289','1','86',761,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','86',762,'3','1',304407.84,309210.91,4803.07,1128721.45,0.00,0.00,0.00,0.00,0.00),('1','289','1','86',763,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','86',764,'5','1',991866.89,996580.03,4713.14,1107587.90,0.00,0.00,0.00,0.00,0.00),('1','289','1','86',765,'6','1',33785.18,33785.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','86',766,'7','1',32483.34,32483.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','86',767,'8','2',542428.67,542428.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','86',768,'9','2',766557.96,766557.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','87',769,'1','1',545454.01,545454.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','87',770,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','87',771,'3','1',309210.91,309210.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','87',772,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','87',773,'5','1',996580.03,996580.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','87',774,'6','1',33785.18,33785.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','87',775,'7','1',32483.34,32483.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','87',776,'8','2',542428.67,542428.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','87',777,'9','2',766557.96,767626.21,1068.25,854600.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','88',778,'1','1',545454.01,552422.34,6968.33,1637557.55,0.00,0.00,0.00,0.00,0.00),('1','289','1','88',779,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','88',780,'3','1',309210.91,313506.22,4295.31,1009397.85,0.00,0.00,0.00,0.00,0.00),('1','289','1','88',781,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','88',782,'5','1',996580.03,1000379.46,3799.43,892866.05,0.00,0.00,0.00,0.00,0.00),('1','289','1','88',783,'6','1',33785.18,33785.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','88',784,'7','1',32483.34,32483.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','88',785,'8','2',542428.67,542428.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','88',786,'9','2',767626.21,768803.21,1177.00,929830.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','89',787,'1','1',552422.34,558431.30,6008.96,1412105.60,0.00,0.00,0.00,0.00,0.00),('1','289','1','89',788,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','89',789,'3','1',313506.22,319016.48,5510.26,1294911.10,0.00,0.00,0.00,0.00,0.00),('1','289','1','89',790,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','89',791,'5','1',1000379.46,1005317.65,4938.19,1160474.65,0.00,0.00,0.00,0.00,0.00),('1','289','1','89',792,'6','1',33785.18,33785.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','89',793,'7','1',32483.34,32483.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','89',794,'8','2',542428.67,542428.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','89',795,'9','2',768803.21,769421.96,618.75,488812.50,0.00,0.00,0.00,0.00,0.00),('1','289','1','90',796,'1','1',558431.30,563596.52,5165.22,1213826.70,0.00,0.00,0.00,0.00,0.00),('1','289','1','90',797,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','90',798,'3','1',319016.48,322951.95,3935.47,924835.45,0.00,0.00,0.00,0.00,0.00),('1','289','1','90',799,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','90',800,'5','1',1005317.65,1007826.89,2509.24,589671.40,0.00,0.00,0.00,0.00,0.00),('1','289','1','90',801,'6','1',33785.18,33785.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','90',802,'7','1',32483.34,32483.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','90',803,'8','2',542428.67,542428.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','90',804,'9','2',769421.96,772010.17,2588.21,2044685.90,0.00,0.00,0.00,0.00,0.00),('1','289','1','91',805,'1','1',563596.52,569954.61,6358.09,1494151.15,0.00,0.00,0.00,0.00,0.00),('1','289','1','91',806,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','91',807,'3','1',322951.95,323437.46,485.51,114094.85,0.00,0.00,0.00,0.00,0.00),('1','289','1','91',808,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','91',809,'5','1',1007826.89,1014572.93,6746.04,1585319.40,0.00,0.00,0.00,0.00,0.00),('1','289','1','91',810,'6','1',33785.18,33785.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','91',811,'7','1',32483.34,32483.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','91',812,'8','2',542428.67,542428.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','91',813,'9','2',772010.17,772010.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','92',814,'1','1',569954.61,576701.08,6736.47,1583070.45,0.00,0.00,10.00,0.00,0.00),('1','289','1','92',815,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','92',816,'3','1',323437.46,323437.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','92',817,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','92',818,'5','1',1014572.93,1019993.92,5410.99,1271582.65,0.00,0.00,10.00,0.00,0.00),('1','289','1','92',819,'6','1',33785.18,39508.84,5703.66,1340360.10,0.00,0.00,20.00,0.00,0.00),('1','289','1','92',820,'7','1',32483.34,32483.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','92',821,'8','2',542428.67,542428.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','92',822,'9','2',772010.17,772479.16,468.99,370502.10,0.00,0.00,0.00,0.00,0.00),('1','289','1','93',823,'1','1',576701.08,576701.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','93',824,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','93',825,'3','1',323437.46,323437.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','93',826,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','93',827,'5','1',1019993.92,1019993.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','93',828,'6','1',39508.84,39508.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','93',829,'7','1',32483.34,32483.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','93',830,'8','2',542428.67,542428.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','93',831,'9','2',772479.16,772479.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','94',832,'1','1',576701.08,581522.08,4821.00,1132935.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','94',833,'2','1',748252.47,748252.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','94',834,'3','1',323437.46,323437.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','94',835,'4','1',172549.53,172549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','1','94',836,'5','1',1019993.92,1023388.66,3394.74,797763.90,0.00,0.00,0.00,0.00,0.00),('1','289','1','94',837,'6','1',39508.84,41210.20,1701.36,399819.60,0.00,0.00,0.00,0.00,0.00),('1','289','1','94',838,'7','1',32483.34,32483.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','94',839,'8','2',542428.67,542428.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','289','4','94',840,'9','2',772479.16,772479.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=189 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','289','1','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,1),('1','289','1','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,2),('1','289','2','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,3),('1','289','2','1',180.00,180.00,1129.53,0.00,0.00,0.00,0.00,4),('1','289','3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,5),('1','289','3','1',180.00,180.00,851.39,0.00,0.00,0.00,0.00,6),('1','289','4','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,7),('1','289','4','1',180.00,180.00,1286.64,0.00,0.00,0.00,0.00,8),('1','289','5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,9),('1','289','5','1',180.00,180.00,705.21,0.00,0.00,0.00,0.00,10),('1','289','6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,11),('1','289','6','1',180.00,180.00,1249.77,0.00,0.00,0.00,0.00,12),('1','289','7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,13),('1','289','7','1',180.00,180.00,929.65,0.00,0.00,0.00,0.00,14),('1','289','8','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,15),('1','289','8','1',180.00,180.00,1067.08,0.00,0.00,0.00,0.00,16),('1','289','9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,17),('1','289','9','1',180.00,180.00,995.45,0.00,0.00,0.00,0.00,18),('1','289','11','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,21),('1','289','11','1',180.00,180.00,1349.08,0.00,0.00,0.00,0.00,22),('1','289','12','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,23),('1','289','12','1',180.00,180.00,896.24,0.00,0.00,0.00,0.00,24),('1','289','13','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,25),('1','289','13','1',180.00,180.00,1116.08,0.00,0.00,0.00,0.00,26),('1','289','14','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,27),('1','289','14','1',180.00,180.00,1180.34,0.00,0.00,0.00,0.00,28),('1','289','15','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,29),('1','289','15','1',180.00,180.00,1430.40,0.00,0.00,0.00,0.00,30),('1','289','16','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,31),('1','289','16','1',180.00,180.00,2621.82,0.00,0.00,0.00,0.00,32),('1','289','17','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,33),('1','289','17','1',180.00,180.00,9151.90,0.00,0.00,0.00,0.00,34),('1','289','18','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,35),('1','289','18','1',180.00,180.00,5469.39,0.00,0.00,0.00,0.00,36),('1','289','19','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,37),('1','289','19','1',180.00,180.00,3395.94,0.00,0.00,0.00,0.00,38),('1','289','20','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,39),('1','289','20','1',180.00,180.00,2621.28,0.00,0.00,0.00,0.00,40),('1','289','21','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,41),('1','289','21','1',180.00,180.00,2572.54,0.00,0.00,0.00,0.00,42),('1','289','22','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,43),('1','289','22','1',180.00,180.00,1879.68,0.00,0.00,0.00,0.00,44),('1','289','23','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,45),('1','289','23','1',180.00,180.00,3373.35,0.00,0.00,0.00,0.00,46),('1','289','24','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,47),('1','289','24','1',180.00,180.00,2198.21,0.00,0.00,0.00,0.00,48),('1','289','25','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,49),('1','289','25','1',180.00,180.00,811.10,0.00,0.00,0.00,0.00,50),('1','289','26','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,51),('1','289','26','1',180.00,180.00,1808.17,0.00,0.00,0.00,0.00,52),('1','289','27','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,53),('1','289','27','1',180.00,180.00,2204.36,0.00,0.00,0.00,0.00,54),('1','289','28','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,55),('1','289','28','1',180.00,180.00,3246.30,0.00,0.00,0.00,0.00,56),('1','289','29','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,57),('1','289','29','1',180.00,180.00,3160.56,0.00,0.00,0.00,0.00,58),('1','289','30','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,59),('1','289','30','1',180.00,180.00,3150.05,0.00,0.00,0.00,0.00,60),('1','289','31','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,61),('1','289','31','1',180.00,180.00,2341.21,0.00,0.00,0.00,0.00,62),('1','289','32','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,63),('1','289','32','1',180.00,180.00,2960.06,0.00,0.00,0.00,0.00,64),('1','289','33','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,65),('1','289','33','1',180.00,180.00,2474.27,0.00,0.00,0.00,0.00,66),('1','289','34','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,67),('1','289','34','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,68),('1','289','35','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,69),('1','289','35','1',180.00,180.00,2680.50,0.00,0.00,0.00,0.00,70),('1','289','36','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,71),('1','289','36','1',180.00,180.00,2854.78,0.00,0.00,0.00,0.00,72),('1','289','37','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,73),('1','289','37','1',180.00,180.00,1952.45,0.00,0.00,0.00,0.00,74),('1','289','38','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,75),('1','289','38','1',180.00,180.00,2632.84,0.00,0.00,0.00,0.00,76),('1','289','39','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,77),('1','289','39','1',180.00,180.00,2933.08,0.00,0.00,0.00,0.00,78),('1','289','40','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,79),('1','289','40','1',180.00,180.00,3253.96,0.00,0.00,0.00,0.00,80),('1','289','41','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,81),('1','289','41','1',180.00,180.00,3238.59,0.00,0.00,0.00,0.00,82),('1','289','42','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,83),('1','289','42','1',180.00,180.00,2650.68,0.00,0.00,0.00,0.00,84),('1','289','43','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,85),('1','289','43','1',180.00,180.00,3558.00,0.00,0.00,0.00,0.00,86),('1','289','44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,87),('1','289','44','1',210.00,180.00,336.96,0.00,0.00,0.00,0.00,88),('1','289','45','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,89),('1','289','45','1',210.00,210.00,2950.52,0.00,0.00,0.00,0.00,90),('1','289','46','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,91),('1','289','46','1',210.00,210.00,3424.24,0.00,0.00,0.00,0.00,92),('1','289','47','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,93),('1','289','47','1',210.00,210.00,4124.85,0.00,0.00,0.00,0.00,94),('1','289','48','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,95),('1','289','48','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,96),('1','289','49','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,97),('1','289','49','1',210.00,210.00,4378.68,0.00,0.00,0.00,0.00,98),('1','289','50','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,99),('1','289','50','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,100),('1','289','51','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,101),('1','289','51','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,102),('1','289','52','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,103),('1','289','52','1',210.00,210.00,6099.49,0.00,0.00,0.00,0.00,104),('1','289','53','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,105),('1','289','53','1',210.00,210.00,204.14,0.00,0.00,0.00,0.00,106),('1','289','54','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,107),('1','289','54','1',210.00,210.00,5267.61,0.00,0.00,0.00,0.00,108),('1','289','55','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,109),('1','289','55','1',210.00,210.00,4930.95,0.00,0.00,0.00,0.00,110),('1','289','56','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,111),('1','289','56','1',210.00,210.00,5486.13,0.00,0.00,0.00,0.00,112),('1','289','57','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,113),('1','289','57','1',210.00,210.00,5260.98,0.00,0.00,0.00,0.00,114),('1','289','58','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,115),('1','289','58','1',210.00,210.00,4155.40,0.00,0.00,0.00,0.00,116),('1','289','59','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,117),('1','289','59','1',210.00,210.00,5478.53,0.00,0.00,0.00,0.00,118),('1','289','60','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,119),('1','289','60','1',210.00,210.00,5087.02,0.00,0.00,0.00,0.00,120),('1','289','61','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,121),('1','289','61','1',210.00,210.00,1945.98,0.00,0.00,0.00,0.00,122),('1','289','62','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,123),('1','289','62','1',210.00,210.00,2165.73,0.00,0.00,0.00,0.00,124),('1','289','63','2',790.00,790.00,1250.08,0.00,0.00,0.00,0.00,125),('1','289','63','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,126),('1','289','64','2',790.00,790.00,1340.54,0.00,0.00,0.00,0.00,127),('1','289','64','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,128),('1','289','65','2',790.00,790.00,2732.32,0.00,0.00,0.00,0.00,129),('1','289','65','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,130),('1','289','66','2',790.00,790.00,25.25,0.00,0.00,0.00,0.00,131),('1','289','66','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,132),('1','289','67','2',790.00,790.00,747.18,0.00,0.00,0.00,0.00,133),('1','289','67','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,134),('1','289','68','2',790.00,790.00,413.29,0.00,0.00,0.00,0.00,135),('1','289','68','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,136),('1','289','69','2',790.00,790.00,506.33,0.00,0.00,0.00,0.00,137),('1','289','69','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,138),('1','289','70','2',790.00,790.00,698.79,0.00,0.00,0.00,0.00,139),('1','289','70','1',210.00,235.00,0.00,0.00,0.00,0.00,0.00,140),('1','289','71','2',790.00,790.00,802.57,0.00,0.00,0.00,0.00,141),('1','289','71','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,142),('1','289','72','2',790.00,790.00,1342.50,0.00,0.00,0.00,0.00,143),('1','289','72','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,144),('1','289','73','2',790.00,790.00,19580.25,0.00,0.00,0.00,0.00,145),('1','289','73','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,146),('1','289','74','2',790.00,790.00,0.00,0.00,0.00,0.00,0.00,147),('1','289','74','1',235.00,235.00,3452.17,0.00,0.00,0.00,0.00,148),('1','289','75','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,149),('1','289','75','1',235.00,235.00,3535.71,0.00,0.00,0.00,0.00,150),('1','289','76','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,151),('1','289','76','1',235.00,235.00,5400.78,0.00,0.00,0.00,0.00,152),('1','289','77','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,153),('1','289','77','1',235.00,235.00,7653.15,0.00,0.00,0.00,0.00,154),('1','289','78','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,155),('1','289','78','1',235.00,235.00,8880.77,0.00,0.00,0.00,0.00,156),('1','289','79','2',800.00,800.00,848.00,0.00,0.00,0.00,0.00,157),('1','289','79','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,158),('1','289','80','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,159),('1','289','80','1',235.00,235.00,10552.58,0.00,0.00,0.00,0.00,160),('1','289','81','2',800.00,800.00,2665.12,0.00,0.00,0.00,0.00,161),('1','289','81','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,162),('1','289','82','2',800.00,800.00,2629.49,0.00,0.00,0.00,0.00,163),('1','289','82','1',235.00,235.00,5051.52,0.00,0.00,0.00,0.00,164),('1','289','83','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,165),('1','289','83','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,166),('1','289','84','2',800.00,800.00,655.63,0.00,0.00,0.00,0.00,167),('1','289','84','1',235.00,235.00,10839.03,0.00,0.00,0.00,0.00,168),('1','289','85','2',800.00,800.00,2380.26,0.00,0.00,0.00,0.00,169),('1','289','85','1',235.00,235.00,13822.73,0.00,0.00,0.00,0.00,170),('1','289','86','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,171),('1','289','86','1',235.00,235.00,15565.89,0.00,0.00,0.00,0.00,172),('1','289','87','2',800.00,800.00,1068.25,0.00,0.00,0.00,0.00,173),('1','289','87','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,174),('1','289','88','2',790.00,790.00,1177.00,0.00,0.00,0.00,0.00,175),('1','289','88','1',235.00,235.00,15063.07,0.00,0.00,0.00,0.00,176),('1','289','89','2',790.00,790.00,618.75,0.00,0.00,0.00,0.00,177),('1','289','89','1',235.00,235.00,16457.41,0.00,0.00,0.00,0.00,178),('1','289','90','2',790.00,790.00,2588.21,0.00,0.00,0.00,0.00,179),('1','289','90','1',235.00,235.00,11609.93,0.00,0.00,0.00,0.00,180),('1','289','91','2',790.00,790.00,0.00,0.00,0.00,0.00,0.00,181),('1','289','91','1',235.00,235.00,13589.64,0.00,0.00,0.00,0.00,182),('1','289','92','2',790.00,790.00,468.99,0.00,0.00,0.00,0.00,183),('1','289','92','1',235.00,235.00,17851.12,0.00,0.00,0.00,0.00,184),('1','289','93','2',790.00,790.00,0.00,0.00,0.00,0.00,0.00,185),('1','289','93','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,186),('1','289','94','2',790.00,790.00,0.00,0.00,0.00,0.00,0.00,187),('1','289','94','1',235.00,235.00,9917.10,0.00,0.00,0.00,0.00,188);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',1,'289','PMS TANKS',''),('1',2,'289','AGO TANK','');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','289','1',1,0,'1','PMS TANK 1, 2 & 3',146000.00,0.00,NULL,'CONTAING PMS','178','2022-10-19 17:13:45','2022-11-02 16:34:26','178',5,0),('1','289','1',2,0,'1','PUMP 2',26000.00,0.00,NULL,'CONTAING PMS','178','2022-10-19 17:16:25','2022-11-02 16:35:31','178',0,0),('1','289','1',3,0,'1','PMS TANK 3',45400.00,0.00,NULL,'CONTAING PMS','178','2022-10-19 17:17:55','2022-11-02 16:36:40','178',0,0),('1','289','2',4,0,'2','AGO TANK',50000.00,0.00,NULL,'CONTAINING AGO','178','2022-10-19 17:19:27','2022-11-02 16:39:36','178',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','289',4,30461.20,'2023-03-20 19:48:30'),(2,'1','289',3,-1385.39,'2023-03-20 19:48:30'),(3,'1','289',2,-1263.29,'2023-03-20 19:48:30'),(4,'1','289',1,96646.29,'2023-03-20 19:48:30');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=384 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'1','289',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9000000.00,50000.00,0.00,0.00,'2022-10-26 11:25:32','',''),(2,'1','289',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9000000.00,50000.00,0.00,0.00,'2022-10-26 11:25:56','',''),(3,'1','289',NULL,1,'Reception corrector for bridging 5',0.00,0.00,0.00,17000.00,0.00,'2022-10-26 16:54:17','',''),(4,'1','289','2',1,'Received from bridging 5',0.00,0.00,17000.00,0.00,0.00,'2022-10-26 16:54:17','',''),(5,'1','289',NULL,1,'Reception corrector for bridging 4',0.00,0.00,0.00,18000.00,0.00,'2022-10-26 16:54:48','',''),(6,'1','289','3',1,'Received from bridging 4',0.00,0.00,18000.00,0.00,0.00,'2022-10-26 16:54:48','',''),(7,'1','289',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,13200.00,0.00,'2022-10-26 16:55:04','',''),(8,'1','289','1',1,'Received from bridging 3',0.00,0.00,13200.00,0.00,0.00,'2022-10-26 16:55:04','',''),(9,'1','289','1',1,'Sale Id shift 2',0.00,0.00,0.00,335.49,0.00,'2022-10-28 11:03:57','',''),(10,'1','289','1',1,'Sale Id shift 2',0.00,0.00,0.00,265.28,0.00,'2022-10-28 11:03:57','',''),(11,'1','289','2',1,'Sale Id shift 2',0.00,0.00,0.00,268.18,0.00,'2022-10-28 11:03:57','',''),(12,'1','289','3',1,'Sale Id shift 2',0.00,0.00,0.00,260.58,0.00,'2022-10-28 11:03:57','',''),(13,'1','289',NULL,1,'Sale Id shift 2',203315.40,0.00,0.00,0.00,0.00,'2022-10-28 11:03:57','',''),(14,'1','289','1',1,'Sale Id shift 3',0.00,0.00,0.00,152.15,0.00,'2022-10-28 11:27:40','',''),(15,'1','289','1',1,'Sale Id shift 3',0.00,0.00,0.00,360.99,0.00,'2022-10-28 11:27:40','',''),(16,'1','289','1',1,'Sale Id shift 3',0.00,0.00,0.00,227.82,0.00,'2022-10-28 11:27:40','',''),(17,'1','289','2',1,'Sale Id shift 3',0.00,0.00,0.00,110.43,0.00,'2022-10-28 11:27:40','',''),(18,'1','289',NULL,1,'Sale Id shift 3',153250.20,0.00,0.00,0.00,0.00,'2022-10-28 11:27:40','',''),(19,'1','289','1',1,'Sale Id shift 4',0.00,0.00,0.00,355.18,0.00,'2022-10-28 11:47:21','',''),(20,'1','289','1',1,'Sale Id shift 4',0.00,0.00,0.00,386.75,0.00,'2022-10-28 11:47:21','',''),(21,'1','289','1',1,'Sale Id shift 4',0.00,0.00,0.00,339.32,0.00,'2022-10-28 11:47:21','',''),(22,'1','289','2',1,'Sale Id shift 4',0.00,0.00,0.00,205.39,0.00,'2022-10-28 11:47:21','',''),(23,'1','289',NULL,1,'Sale Id shift 4',231595.20,0.00,0.00,0.00,0.00,'2022-10-28 11:47:21','',''),(24,'1','289','1',1,'Sale Id shift 5',0.00,0.00,0.00,143.11,0.00,'2022-10-28 11:59:16','',''),(25,'1','289','1',1,'Sale Id shift 5',0.00,0.00,0.00,98.38,0.00,'2022-10-28 11:59:16','',''),(26,'1','289','1',1,'Sale Id shift 5',0.00,0.00,0.00,328.12,0.00,'2022-10-28 11:59:16','',''),(27,'1','289','2',1,'Sale Id shift 5',0.00,0.00,0.00,50.57,0.00,'2022-10-28 11:59:16','',''),(28,'1','289','3',1,'Sale Id shift 5',0.00,0.00,0.00,85.03,0.00,'2022-10-28 11:59:16','',''),(29,'1','289',NULL,1,'Sale Id shift 5',126937.80,0.00,0.00,0.00,0.00,'2022-10-28 11:59:16','',''),(30,'1','289','1',1,'Sale Id shift 6',0.00,0.00,0.00,271.39,0.00,'2022-10-28 12:23:51','',''),(31,'1','289','1',1,'Sale Id shift 6',0.00,0.00,0.00,253.02,0.00,'2022-10-28 12:23:51','',''),(32,'1','289','1',1,'Sale Id shift 6',0.00,0.00,0.00,306.17,0.00,'2022-10-28 12:23:51','',''),(33,'1','289','2',1,'Sale Id shift 6',0.00,0.00,0.00,218.42,0.00,'2022-10-28 12:23:51','',''),(34,'1','289','3',1,'Sale Id shift 6',0.00,0.00,0.00,200.77,0.00,'2022-10-28 12:23:51','',''),(35,'1','289',NULL,1,'Sale Id shift 6',224958.60,0.00,0.00,0.00,0.00,'2022-10-28 12:23:51','',''),(36,'1','289','1',1,'Sale Id shift 7',0.00,0.00,0.00,193.38,0.00,'2022-10-28 12:49:23','',''),(37,'1','289','1',1,'Sale Id shift 7',0.00,0.00,0.00,176.76,0.00,'2022-10-28 12:49:23','',''),(38,'1','289','1',1,'Sale Id shift 7',0.00,0.00,0.00,304.77,0.00,'2022-10-28 12:49:23','',''),(39,'1','289','1',1,'Sale Id shift 7',0.00,0.00,0.00,128.75,0.00,'2022-10-28 12:49:23','',''),(40,'1','289','2',1,'Sale Id shift 7',0.00,0.00,0.00,125.99,0.00,'2022-10-28 12:49:23','',''),(41,'1','289',NULL,1,'Sale Id shift 7',167337.00,0.00,0.00,0.00,0.00,'2022-10-28 12:49:23','',''),(42,'1','289','1',1,'Sale Id shift 8',0.00,0.00,0.00,209.21,0.00,'2022-10-28 13:17:19','',''),(43,'1','289','1',1,'Sale Id shift 8',0.00,0.00,0.00,278.98,0.00,'2022-10-28 13:17:19','',''),(44,'1','289','1',1,'Sale Id shift 8',0.00,0.00,0.00,306.75,0.00,'2022-10-28 13:17:19','',''),(45,'1','289','1',1,'Sale Id shift 8',0.00,0.00,0.00,200.45,0.00,'2022-10-28 13:17:19','',''),(46,'1','289','2',1,'Sale Id shift 8',0.00,0.00,0.00,71.69,0.00,'2022-10-28 13:17:19','',''),(47,'1','289',NULL,1,'Sale Id shift 8',192074.40,0.00,0.00,0.00,0.00,'2022-10-28 13:17:19','',''),(48,'1','289','1',1,'Sale Id shift 9',0.00,0.00,0.00,244.59,0.00,'2022-10-29 07:33:57','',''),(49,'1','289','1',1,'Sale Id shift 9',0.00,0.00,0.00,143.09,0.00,'2022-10-29 07:33:57','',''),(50,'1','289','1',1,'Sale Id shift 9',0.00,0.00,0.00,267.22,0.00,'2022-10-29 07:33:57','',''),(51,'1','289','2',1,'Sale Id shift 9',0.00,0.00,0.00,251.17,0.00,'2022-10-29 07:33:57','',''),(52,'1','289','3',1,'Sale Id shift 9',0.00,0.00,0.00,89.38,0.00,'2022-10-29 07:33:57','',''),(53,'1','289',NULL,1,'Sale Id shift 9',179181.00,0.00,0.00,0.00,0.00,'2022-10-29 07:33:57','',''),(54,'1','289','1',1,'Sale Id shift 11',0.00,0.00,0.00,319.64,0.00,'2022-10-29 07:48:07','',''),(55,'1','289','1',1,'Sale Id shift 11',0.00,0.00,0.00,160.68,0.00,'2022-10-29 07:48:07','',''),(56,'1','289','1',1,'Sale Id shift 11',0.00,0.00,0.00,306.70,0.00,'2022-10-29 07:48:07','',''),(57,'1','289','1',1,'Sale Id shift 11',0.00,0.00,0.00,113.07,0.00,'2022-10-29 07:48:07','',''),(58,'1','289','2',1,'Sale Id shift 11',0.00,0.00,0.00,306.69,0.00,'2022-10-29 07:48:07','',''),(59,'1','289','3',1,'Sale Id shift 11',0.00,0.00,0.00,142.30,0.00,'2022-10-29 07:48:07','',''),(60,'1','289',NULL,1,'Sale Id shift 11',242834.40,0.00,0.00,0.00,0.00,'2022-10-29 07:48:07','',''),(61,'1','289','1',1,'Sale Id shift 12',0.00,0.00,0.00,344.30,0.00,'2022-10-29 07:54:39','',''),(62,'1','289','1',1,'Sale Id shift 12',0.00,0.00,0.00,351.44,0.00,'2022-10-29 07:54:39','',''),(63,'1','289','2',1,'Sale Id shift 12',0.00,0.00,0.00,200.50,0.00,'2022-10-29 07:54:39','',''),(64,'1','289',NULL,1,'Sale Id shift 12',161323.20,0.00,0.00,0.00,0.00,'2022-10-29 07:54:39','',''),(65,'1','289','1',1,'Sale Id shift 13',0.00,0.00,0.00,594.04,0.00,'2022-10-29 08:16:39','',''),(66,'1','289','2',1,'Sale Id shift 13',0.00,0.00,0.00,418.51,0.00,'2022-10-29 08:16:39','',''),(67,'1','289','2',1,'Sale Id shift 13',0.00,0.00,0.00,103.53,0.00,'2022-10-29 08:16:39','',''),(68,'1','289',NULL,1,'Sale Id shift 13',200894.40,0.00,0.00,0.00,0.00,'2022-10-29 08:16:39','',''),(69,'1','289','1',1,'Sale Id shift 14',0.00,0.00,0.00,541.19,0.00,'2022-10-29 08:33:58','',''),(70,'1','289','1',1,'Sale Id shift 14',0.00,0.00,0.00,425.87,0.00,'2022-10-29 08:33:58','',''),(71,'1','289','2',1,'Sale Id shift 14',0.00,0.00,0.00,213.28,0.00,'2022-10-29 08:33:58','',''),(72,'1','289',NULL,1,'Sale Id shift 14',212461.20,0.00,0.00,0.00,0.00,'2022-10-29 08:33:58','',''),(73,'1','289','1',1,'Sale Id shift 15',0.00,0.00,0.00,602.76,0.00,'2022-10-29 08:40:50','',''),(74,'1','289','1',1,'Sale Id shift 15',0.00,0.00,0.00,739.55,0.00,'2022-10-29 08:40:50','',''),(75,'1','289','2',1,'Sale Id shift 15',0.00,0.00,0.00,88.09,0.00,'2022-10-29 08:40:50','',''),(76,'1','289',NULL,1,'Sale Id shift 15',257472.00,0.00,0.00,0.00,0.00,'2022-10-29 08:40:50','',''),(77,'1','289','1',1,'Sale Id shift 16',0.00,0.00,0.00,999.24,0.00,'2022-10-29 10:28:47','',''),(78,'1','289','2',1,'Sale Id shift 16',0.00,0.00,0.00,721.21,0.00,'2022-10-29 10:28:47','',''),(79,'1','289','2',1,'Sale Id shift 16',0.00,0.00,0.00,901.37,0.00,'2022-10-29 10:28:47','',''),(80,'1','289',NULL,1,'Sale Id shift 16',471927.60,0.00,0.00,0.00,0.00,'2022-10-29 10:28:47','',''),(81,'1','289',NULL,1,'Reception corrector for bridging 6',0.00,0.00,0.00,24000.00,0.00,'2022-10-29 11:15:03','',''),(82,'1','289','1',1,'Received from bridging 6',0.00,0.00,24000.00,0.00,0.00,'2022-10-29 11:15:03','',''),(83,'1','289','1',1,'Sale Id shift 17',0.00,0.00,0.00,2766.99,0.00,'2022-10-29 11:18:56','',''),(84,'1','289','1',1,'Sale Id shift 17',0.00,0.00,0.00,193.70,0.00,'2022-10-29 11:18:56','',''),(85,'1','289','1',1,'Sale Id shift 17',0.00,0.00,0.00,3234.68,0.00,'2022-10-29 11:18:56','',''),(86,'1','289','1',1,'Sale Id shift 17',0.00,0.00,0.00,478.39,0.00,'2022-10-29 11:18:56','',''),(87,'1','289','2',1,'Sale Id shift 17',0.00,0.00,0.00,2478.14,0.00,'2022-10-29 11:18:56','',''),(88,'1','289',NULL,1,'Sale Id shift 17',1647342.00,0.00,0.00,0.00,0.00,'2022-10-29 11:18:56','',''),(89,'1','289','1',1,'Sale Id shift 18',0.00,0.00,0.00,1822.22,0.00,'2022-10-29 11:25:07','',''),(90,'1','289','1',1,'Sale Id shift 18',0.00,0.00,0.00,1960.33,0.00,'2022-10-29 11:25:07','',''),(91,'1','289','2',1,'Sale Id shift 18',0.00,0.00,0.00,1686.84,0.00,'2022-10-29 11:25:07','',''),(92,'1','289',NULL,1,'Sale Id shift 18',984490.20,0.00,0.00,0.00,0.00,'2022-10-29 11:25:07','',''),(93,'1','289','1',1,'Sale Id shift 19',0.00,0.00,0.00,1579.10,0.00,'2022-10-29 11:36:46','',''),(94,'1','289','1',1,'Sale Id shift 19',0.00,0.00,0.00,0.83,0.00,'2022-10-29 11:36:46','',''),(95,'1','289','1',1,'Sale Id shift 19',0.00,0.00,0.00,44.95,0.00,'2022-10-29 11:36:46','',''),(96,'1','289','2',1,'Sale Id shift 19',0.00,0.00,0.00,42.92,0.00,'2022-10-29 11:36:46','',''),(97,'1','289','2',1,'Sale Id shift 19',0.00,0.00,0.00,1728.14,0.00,'2022-10-29 11:36:46','',''),(98,'1','289',NULL,1,'Sale Id shift 19',611269.20,0.00,0.00,0.00,0.00,'2022-10-29 11:36:46','',''),(99,'1','289','1',1,'Sale Id shift 20',0.00,0.00,0.00,1038.99,0.00,'2022-10-29 11:49:08','',''),(100,'1','289','1',1,'Sale Id shift 20',0.00,0.00,0.00,51.85,0.00,'2022-10-29 11:49:08','',''),(101,'1','289','1',1,'Sale Id shift 20',0.00,0.00,0.00,647.10,0.00,'2022-10-29 11:49:08','',''),(102,'1','289','2',1,'Sale Id shift 20',0.00,0.00,0.00,883.34,0.00,'2022-10-29 11:49:08','',''),(103,'1','289',NULL,1,'Sale Id shift 20',471830.40,0.00,0.00,0.00,0.00,'2022-10-29 11:49:08','',''),(104,'1','289','1',1,'Sale Id shift 21',0.00,0.00,0.00,1177.19,0.00,'2022-10-29 11:55:49','',''),(105,'1','289','1',1,'Sale Id shift 21',0.00,0.00,0.00,88.97,0.00,'2022-10-29 11:55:49','',''),(106,'1','289','1',1,'Sale Id shift 21',0.00,0.00,0.00,1306.38,0.00,'2022-10-29 11:55:49','',''),(107,'1','289',NULL,1,'Sale Id shift 21',463057.20,0.00,0.00,0.00,0.00,'2022-10-29 11:55:49','',''),(108,'1','289','1',1,'Sale Id shift 22',0.00,0.00,0.00,701.80,0.00,'2022-10-29 12:05:36','',''),(109,'1','289','1',1,'Sale Id shift 22',0.00,0.00,0.00,574.54,0.00,'2022-10-29 12:05:36','',''),(110,'1','289','2',1,'Sale Id shift 22',0.00,0.00,0.00,603.34,0.00,'2022-10-29 12:05:36','',''),(111,'1','289',NULL,1,'Sale Id shift 22',338342.40,0.00,0.00,0.00,0.00,'2022-10-29 12:05:36','',''),(112,'1','289','1',1,'Sale Id shift 23',0.00,0.00,0.00,1694.66,0.00,'2022-10-29 12:16:59','',''),(113,'1','289','1',1,'Sale Id shift 23',0.00,0.00,0.00,1678.69,0.00,'2022-10-29 12:16:59','',''),(114,'1','289',NULL,1,'Sale Id shift 23',607203.00,0.00,0.00,0.00,0.00,'2022-10-29 12:16:59','',''),(115,'1','289','1',1,'Sale Id shift 24',0.00,0.00,0.00,1024.25,0.00,'2022-10-29 12:26:56','',''),(116,'1','289','1',1,'Sale Id shift 24',0.00,0.00,0.00,70.60,0.00,'2022-10-29 12:26:56','',''),(117,'1','289','2',1,'Sale Id shift 24',0.00,0.00,0.00,528.16,0.00,'2022-10-29 12:26:56','',''),(118,'1','289','2',1,'Sale Id shift 24',0.00,0.00,0.00,575.20,0.00,'2022-10-29 12:26:56','',''),(119,'1','289',NULL,1,'Sale Id shift 24',395677.80,0.00,0.00,0.00,0.00,'2022-10-29 12:26:56','',''),(120,'1','289','1',1,'Sale Id shift 25',0.00,0.00,0.00,422.08,0.00,'2022-10-29 12:43:07','',''),(121,'1','289','2',1,'Sale Id shift 25',0.00,0.00,0.00,389.02,0.00,'2022-10-29 12:43:07','',''),(122,'1','289',NULL,1,'Sale Id shift 25',145998.00,0.00,0.00,0.00,0.00,'2022-10-29 12:43:07','',''),(123,'1','289','1',1,'Sale Id shift 26',0.00,0.00,0.00,1013.36,0.00,'2022-10-29 12:52:06','',''),(124,'1','289','2',1,'Sale Id shift 26',0.00,0.00,0.00,143.89,0.00,'2022-10-29 12:52:06','',''),(125,'1','289','2',1,'Sale Id shift 26',0.00,0.00,0.00,650.92,0.00,'2022-10-29 12:52:06','',''),(126,'1','289',NULL,1,'Sale Id shift 26',325470.60,0.00,0.00,0.00,0.00,'2022-10-29 12:52:06','',''),(127,'1','289','1',1,'Sale Id shift 27',0.00,0.00,0.00,857.91,0.00,'2022-10-29 13:04:48','',''),(128,'1','289','1',1,'Sale Id shift 27',0.00,0.00,0.00,862.51,0.00,'2022-10-29 13:04:48','',''),(129,'1','289','2',1,'Sale Id shift 27',0.00,0.00,0.00,483.94,0.00,'2022-10-29 13:04:48','',''),(130,'1','289',NULL,1,'Sale Id shift 27',396784.80,0.00,0.00,0.00,0.00,'2022-10-29 13:04:48','',''),(131,'1','289',NULL,1,'Reception corrector for bridging 8',0.00,0.00,0.00,10000.00,0.00,'2022-10-29 16:03:15','',''),(132,'1','289','1',1,'Received from bridging 8',0.00,0.00,10000.00,0.00,0.00,'2022-10-29 16:03:15','',''),(133,'1','289','1',1,'Sale Id shift 28',0.00,0.00,0.00,1620.84,0.00,'2022-10-29 16:22:49','',''),(134,'1','289','2',1,'Sale Id shift 28',0.00,0.00,0.00,1625.46,0.00,'2022-10-29 16:22:49','',''),(135,'1','289',NULL,1,'Sale Id shift 28',584334.00,0.00,0.00,0.00,0.00,'2022-10-29 16:22:49','',''),(136,'1','289',NULL,1,'Reception corrector for bridging 9',0.00,0.00,0.00,16000.00,0.00,'2022-10-29 18:12:09','',''),(137,'1','289','2',1,'Received from bridging 9',0.00,0.00,16000.00,0.00,0.00,'2022-10-29 18:12:09','',''),(138,'1','289','1',1,'Sale Id shift 29',0.00,0.00,0.00,1262.56,0.00,'2022-10-30 11:15:04','',''),(139,'1','289','1',1,'Sale Id shift 29',0.00,0.00,0.00,889.63,0.00,'2022-10-30 11:15:04','',''),(140,'1','289','2',1,'Sale Id shift 29',0.00,0.00,0.00,1008.37,0.00,'2022-10-30 11:15:04','',''),(141,'1','289',NULL,1,'Sale Id shift 29',568900.80,0.00,0.00,0.00,0.00,'2022-10-30 11:15:04','',''),(142,'1','289','1',1,'Sale Id shift 30',0.00,0.00,0.00,1685.95,0.00,'2022-10-30 11:54:16','',''),(143,'1','289','1',1,'Sale Id shift 30',0.00,0.00,0.00,152.13,0.00,'2022-10-30 11:54:16','',''),(144,'1','289','2',1,'Sale Id shift 30',0.00,0.00,0.00,1311.97,0.00,'2022-10-30 11:54:16','',''),(145,'1','289',NULL,1,'Sale Id shift 30',567009.00,0.00,0.00,0.00,0.00,'2022-10-30 11:54:16','',''),(146,'1','289','1',1,'Sale Id shift 31',0.00,0.00,0.00,975.84,0.00,'2022-10-30 11:58:51','',''),(147,'1','289','1',1,'Sale Id shift 31',0.00,0.00,0.00,453.70,0.00,'2022-10-30 11:58:51','',''),(148,'1','289','2',1,'Sale Id shift 31',0.00,0.00,0.00,911.67,0.00,'2022-10-30 11:58:51','',''),(149,'1','289',NULL,1,'Sale Id shift 31',421417.80,0.00,0.00,0.00,0.00,'2022-10-30 11:58:51','',''),(150,'1','289','1',1,'Sale Id shift 32',0.00,0.00,0.00,1011.32,0.00,'2022-10-30 12:10:41','',''),(151,'1','289','1',1,'Sale Id shift 32',0.00,0.00,0.00,149.75,0.00,'2022-10-30 12:10:41','',''),(152,'1','289','2',1,'Sale Id shift 32',0.00,0.00,0.00,364.02,0.00,'2022-10-30 12:10:41','',''),(153,'1','289','2',1,'Sale Id shift 32',0.00,0.00,0.00,1434.97,0.00,'2022-10-30 12:10:41','',''),(154,'1','289',NULL,1,'Sale Id shift 32',532810.80,0.00,0.00,0.00,0.00,'2022-10-30 12:10:41','',''),(155,'1','289','1',1,'Sale Id shift 33',0.00,0.00,0.00,1112.66,0.00,'2022-10-30 12:15:12','',''),(156,'1','289','1',1,'Sale Id shift 33',0.00,0.00,0.00,649.25,0.00,'2022-10-30 12:15:12','',''),(157,'1','289','2',1,'Sale Id shift 33',0.00,0.00,0.00,712.36,0.00,'2022-10-30 12:15:12','',''),(158,'1','289',NULL,1,'Sale Id shift 33',445368.60,0.00,0.00,0.00,0.00,'2022-10-30 12:15:12','',''),(159,'1','289','2',1,'Sale Id shift 35',0.00,0.00,0.00,1211.77,0.00,'2022-11-02 09:48:12','',''),(160,'1','289','3',1,'Sale Id shift 35',0.00,0.00,0.00,1468.73,0.00,'2022-11-02 09:48:12','',''),(161,'1','289',NULL,1,'Sale Id shift 35',482490.00,0.00,0.00,0.00,0.00,'2022-11-02 09:48:12','',''),(162,'1','289','2',1,'Sale Id shift 36',0.00,0.00,0.00,1238.16,0.00,'2022-11-02 10:03:29','',''),(163,'1','289','3',1,'Sale Id shift 36',0.00,0.00,0.00,1616.62,0.00,'2022-11-02 10:03:29','',''),(164,'1','289',NULL,1,'Sale Id shift 36',513860.40,0.00,0.00,0.00,0.00,'2022-11-02 10:03:29','',''),(165,'1','289','2',1,'Sale Id shift 37',0.00,0.00,0.00,881.25,0.00,'2022-11-02 10:19:10','',''),(166,'1','289','3',1,'Sale Id shift 37',0.00,0.00,0.00,1071.20,0.00,'2022-11-02 10:19:10','',''),(167,'1','289',NULL,1,'Sale Id shift 37',351441.00,0.00,0.00,0.00,0.00,'2022-11-02 10:19:10','',''),(168,'1','289','2',1,'Sale Id shift 38',0.00,0.00,0.00,1290.58,0.00,'2022-11-02 10:25:25','',''),(169,'1','289','3',1,'Sale Id shift 38',0.00,0.00,0.00,1342.26,0.00,'2022-11-02 10:25:25','',''),(170,'1','289',NULL,1,'Sale Id shift 38',473911.20,0.00,0.00,0.00,0.00,'2022-11-02 10:25:25','',''),(171,'1','289','2',1,'Sale Id shift 39',0.00,0.00,0.00,1634.74,0.00,'2022-11-02 10:39:48','',''),(172,'1','289','3',1,'Sale Id shift 39',0.00,0.00,0.00,1298.34,0.00,'2022-11-02 10:39:48','',''),(173,'1','289',NULL,1,'Sale Id shift 39',527954.40,0.00,0.00,0.00,0.00,'2022-11-02 10:39:48','',''),(174,'1','289','2',1,'Sale Id shift 40',0.00,0.00,0.00,-106.85,0.00,'2022-11-02 11:09:28','',''),(175,'1','289','2',1,'Sale Id shift 40',0.00,0.00,0.00,1580.54,0.00,'2022-11-02 11:09:28','',''),(176,'1','289','3',1,'Sale Id shift 40',0.00,0.00,0.00,1780.27,0.00,'2022-11-02 11:09:28','',''),(177,'1','289',NULL,1,'Sale Id shift 40',585712.80,0.00,0.00,0.00,0.00,'2022-11-02 11:09:28','',''),(178,'1','289','2',1,'Sale Id shift 41',0.00,0.00,0.00,1698.47,0.00,'2022-11-02 12:50:52','',''),(179,'1','289','3',1,'Sale Id shift 41',0.00,0.00,0.00,1540.12,0.00,'2022-11-02 12:50:52','',''),(180,'1','289',NULL,1,'Sale Id shift 41',582946.20,0.00,0.00,0.00,0.00,'2022-11-02 12:50:52','',''),(181,'1','289','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,168.70,0.00,'2022-11-02 16:40:14','',''),(182,'1','289','1',0,'Inventory adjustment from tank dipping to 9027',0.00,0.00,9027.00,0.00,0.00,'2022-11-02 16:40:14','',''),(183,'1','289','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,1753.65,0.00,'2022-11-02 16:40:55','',''),(184,'1','289','2',0,'Inventory adjustment from tank dipping to 1',0.00,0.00,1.00,0.00,0.00,'2022-11-02 16:40:55','',''),(185,'1','289','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,7104.40,0.00,'2022-11-02 16:41:28','',''),(186,'1','289','3',0,'Inventory adjustment from tank dipping to 1',0.00,0.00,1.00,0.00,0.00,'2022-11-02 16:41:28','',''),(187,'1','289','2',1,'Sale Id shift 42',0.00,0.00,0.00,1264.29,0.00,'2022-11-02 20:11:19','',''),(188,'1','289','3',1,'Sale Id shift 42',0.00,0.00,0.00,1386.39,0.00,'2022-11-02 20:11:19','',''),(189,'1','289',NULL,1,'Sale Id shift 42',477122.40,0.00,0.00,0.00,0.00,'2022-11-02 20:11:19','',''),(190,'1','289','1',1,'Sale Id shift 43',0.00,0.00,0.00,1727.46,0.00,'2022-11-06 14:18:50','',''),(191,'1','289','1',1,'Sale Id shift 43',0.00,0.00,0.00,147.87,0.00,'2022-11-06 14:18:50','',''),(192,'1','289','1',1,'Sale Id shift 43',0.00,0.00,0.00,1205.28,0.00,'2022-11-06 14:18:50','',''),(193,'1','289','1',1,'Sale Id shift 43',0.00,0.00,0.00,477.39,0.00,'2022-11-06 14:18:50','',''),(194,'1','289',NULL,1,'Sale Id shift 43',640440.00,0.00,0.00,0.00,0.00,'2022-11-06 14:18:50','',''),(195,'1','289',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,12600000.00,60000.00,0.00,0.00,'2022-11-24 04:46:06','',''),(196,'1','289',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,60000.00,0.00,'2022-11-24 11:36:48','',''),(197,'1','289','1',1,'Received from bridging 10',0.00,0.00,60000.00,0.00,0.00,'2022-11-24 11:36:48','',''),(198,'1','289','1',1,'Sale Id shift 44',0.00,0.00,0.00,12.60,0.00,'2022-11-24 11:52:44','',''),(199,'1','289','1',1,'Sale Id shift 44',0.00,0.00,0.00,345.21,0.00,'2022-11-24 11:52:44','',''),(200,'1','289','1',1,'Sale Id shift 44',0.00,0.00,0.00,-12.07,0.00,'2022-11-24 11:52:44','',''),(201,'1','289','1',1,'Sale Id shift 44',0.00,0.00,0.00,-38.07,0.00,'2022-11-24 11:52:44','',''),(202,'1','289','1',1,'Sale Id shift 44',0.00,0.00,0.00,29.29,0.00,'2022-11-24 11:52:44','',''),(203,'1','289',NULL,1,'Sale Id shift 44',70761.60,0.00,0.00,0.00,0.00,'2022-11-24 11:52:44','',''),(204,'1','289','1',1,'Sale Id shift 45',0.00,0.00,0.00,1644.04,0.00,'2022-11-24 16:29:32','',''),(205,'1','289','1',1,'Sale Id shift 45',0.00,0.00,0.00,1306.48,0.00,'2022-11-24 16:29:32','',''),(206,'1','289',NULL,1,'Sale Id shift 45',619609.20,0.00,0.00,0.00,0.00,'2022-11-24 16:29:32','',''),(207,'1','289','1',1,'Sale Id shift 46',0.00,0.00,0.00,1519.17,0.00,'2022-11-25 10:31:20','',''),(208,'1','289','1',1,'Sale Id shift 46',0.00,0.00,0.00,1624.42,0.00,'2022-11-25 10:31:20','',''),(209,'1','289','1',1,'Sale Id shift 46',0.00,0.00,0.00,280.65,0.00,'2022-11-25 10:31:20','',''),(210,'1','289',NULL,1,'Sale Id shift 46',719090.40,0.00,0.00,0.00,0.00,'2022-11-25 10:31:20','',''),(211,'1','289','1',1,'Sale Id shift 47',0.00,0.00,0.00,1620.30,0.00,'2022-11-25 17:51:36','',''),(212,'1','289','1',1,'Sale Id shift 47',0.00,0.00,0.00,2504.55,0.00,'2022-11-25 17:51:36','',''),(213,'1','289',NULL,1,'Sale Id shift 47',866218.50,0.00,0.00,0.00,0.00,'2022-11-25 17:51:36','',''),(214,'1','289','1',1,'Sale Id shift 49',0.00,0.00,0.00,2058.42,0.00,'2022-11-26 15:12:40','',''),(215,'1','289','1',1,'Sale Id shift 49',0.00,0.00,0.00,2320.26,0.00,'2022-11-26 15:12:40','',''),(216,'1','289',NULL,1,'Sale Id shift 49',919522.80,0.00,0.00,0.00,0.00,'2022-11-26 15:12:40','',''),(217,'1','289','1',1,'Sale Id shift 52',0.00,0.00,0.00,905.41,0.00,'2022-11-30 17:39:05','',''),(218,'1','289','1',1,'Sale Id shift 52',0.00,0.00,0.00,3552.84,0.00,'2022-11-30 17:39:05','',''),(219,'1','289','1',1,'Sale Id shift 52',0.00,0.00,0.00,1641.24,0.00,'2022-11-30 17:39:05','',''),(220,'1','289',NULL,1,'Sale Id shift 52',1280892.90,0.00,0.00,0.00,0.00,'2022-11-30 17:39:05','',''),(221,'1','289','1',1,'Sale Id shift 53',0.00,0.00,0.00,204.14,0.00,'2022-12-01 07:49:21','',''),(222,'1','289',NULL,1,'Sale Id shift 53',42869.40,0.00,0.00,0.00,0.00,'2022-12-01 07:49:21','',''),(223,'1','289','1',1,'Sale Id shift 54',0.00,0.00,0.00,2435.87,0.00,'2022-12-01 14:55:39','',''),(224,'1','289','1',1,'Sale Id shift 54',0.00,0.00,0.00,2831.74,0.00,'2022-12-01 14:55:39','',''),(225,'1','289',NULL,1,'Sale Id shift 54',1106198.10,0.00,0.00,0.00,0.00,'2022-12-01 14:55:39','',''),(226,'1','289','1',1,'Sale Id shift 55',0.00,0.00,0.00,2858.28,0.00,'2022-12-01 15:12:29','',''),(227,'1','289','1',1,'Sale Id shift 55',0.00,0.00,0.00,2072.67,0.00,'2022-12-01 15:12:29','',''),(228,'1','289',NULL,1,'Sale Id shift 55',1035499.50,0.00,0.00,0.00,0.00,'2022-12-01 15:12:29','',''),(229,'1','289','1',1,'Sale Id shift 56',0.00,0.00,0.00,1960.72,0.00,'2022-12-01 15:23:44','',''),(230,'1','289','1',1,'Sale Id shift 56',0.00,0.00,0.00,94.37,0.00,'2022-12-01 15:23:44','',''),(231,'1','289','1',1,'Sale Id shift 56',0.00,0.00,0.00,1886.58,0.00,'2022-12-01 15:23:44','',''),(232,'1','289','1',1,'Sale Id shift 56',0.00,0.00,0.00,1514.96,0.00,'2022-12-01 15:23:44','',''),(233,'1','289','1',1,'Sale Id shift 56',0.00,0.00,0.00,29.50,0.00,'2022-12-01 15:23:44','',''),(234,'1','289',NULL,1,'Sale Id shift 56',1152087.30,0.00,0.00,0.00,0.00,'2022-12-01 15:23:44','',''),(235,'1','289','1',1,'Sale Id shift 57',0.00,0.00,0.00,2266.16,0.00,'2022-12-01 15:32:56','',''),(236,'1','289','1',1,'Sale Id shift 57',0.00,0.00,0.00,470.47,0.00,'2022-12-01 15:32:56','',''),(237,'1','289','1',1,'Sale Id shift 57',0.00,0.00,0.00,142.87,0.00,'2022-12-01 15:32:56','',''),(238,'1','289','1',1,'Sale Id shift 57',0.00,0.00,0.00,2381.48,0.00,'2022-12-01 15:32:56','',''),(239,'1','289',NULL,1,'Sale Id shift 57',1104805.80,0.00,0.00,0.00,0.00,'2022-12-01 15:32:56','',''),(240,'1','289','1',1,'Sale Id shift 58',0.00,0.00,0.00,1825.35,0.00,'2022-12-01 16:27:29','',''),(241,'1','289','1',1,'Sale Id shift 58',0.00,0.00,0.00,11.92,0.00,'2022-12-01 16:27:29','',''),(242,'1','289','1',1,'Sale Id shift 58',0.00,0.00,0.00,70.00,0.00,'2022-12-01 16:27:29','',''),(243,'1','289','1',1,'Sale Id shift 58',0.00,0.00,0.00,342.20,0.00,'2022-12-01 16:27:29','',''),(244,'1','289','1',1,'Sale Id shift 58',0.00,0.00,0.00,10.00,0.00,'2022-12-01 16:27:29','',''),(245,'1','289','1',1,'Sale Id shift 58',0.00,0.00,0.00,1895.93,0.00,'2022-12-01 16:27:29','',''),(246,'1','289',NULL,1,'Sale Id shift 58',872634.00,0.00,0.00,0.00,0.00,'2022-12-01 16:27:29','',''),(247,'1','289','1',1,'Sale Id shift 59',0.00,0.00,0.00,2455.16,0.00,'2022-12-01 16:36:48','',''),(248,'1','289','1',1,'Sale Id shift 59',0.00,0.00,0.00,3023.37,0.00,'2022-12-01 16:36:48','',''),(249,'1','289',NULL,1,'Sale Id shift 59',1150491.30,0.00,0.00,0.00,0.00,'2022-12-01 16:36:48','',''),(250,'1','289','1',1,'Sale Id shift 60',0.00,0.00,0.00,2706.20,0.00,'2022-12-02 10:25:51','',''),(251,'1','289','1',1,'Sale Id shift 60',0.00,0.00,0.00,2380.82,0.00,'2022-12-02 10:25:51','',''),(252,'1','289',NULL,1,'Sale Id shift 60',1068274.20,0.00,0.00,0.00,0.00,'2022-12-02 10:25:51','',''),(253,'1','289','1',1,'Sale Id shift 61',0.00,0.00,0.00,357.88,0.00,'2022-12-02 12:19:57','',''),(254,'1','289','1',1,'Sale Id shift 61',0.00,0.00,0.00,779.11,0.00,'2022-12-02 12:19:57','',''),(255,'1','289','1',1,'Sale Id shift 61',0.00,0.00,0.00,808.99,0.00,'2022-12-02 12:19:57','',''),(256,'1','289',NULL,1,'Sale Id shift 61',408655.80,0.00,0.00,0.00,0.00,'2022-12-02 12:19:57','',''),(257,'1','289',NULL,1,'Reception corrector for bridging 11',0.00,0.00,0.00,1800.00,0.00,'2022-12-05 22:02:03','',''),(258,'1','289','1',1,'Received from bridging 11',0.00,0.00,1800.00,0.00,0.00,'2022-12-05 22:02:03','',''),(259,'1','289','1',1,'Sale Id shift 62',0.00,0.00,0.00,1787.53,0.00,'2022-12-09 17:43:04','',''),(260,'1','289','1',1,'Sale Id shift 62',0.00,0.00,0.00,378.20,0.00,'2022-12-09 17:43:04','',''),(261,'1','289',NULL,1,'Sale Id shift 62',454803.30,0.00,0.00,0.00,0.00,'2022-12-09 17:43:04','',''),(262,'1','289',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,23700000.00,30000.00,0.00,0.00,'2023-02-11 10:14:08','',''),(263,'1','289',NULL,2,'Reception corrector for bridging 12',0.00,0.00,0.00,30000.00,0.00,'2023-02-11 13:00:24','',''),(264,'1','289','4',2,'Received from bridging 12',0.00,0.00,30000.00,0.00,0.00,'2023-02-11 13:00:24','',''),(265,'1','289','4',2,'Sale Id shift 63',0.00,0.00,0.00,1250.08,0.00,'2023-02-16 09:19:06','',''),(266,'1','289',NULL,2,'Sale Id shift 63',987563.20,0.00,0.00,0.00,0.00,'2023-02-16 09:19:06','',''),(267,'1','289','4',2,'Sale Id shift 64',0.00,0.00,0.00,1340.54,0.00,'2023-02-16 18:35:19','',''),(268,'1','289',NULL,2,'Sale Id shift 64',1059026.60,0.00,0.00,0.00,0.00,'2023-02-16 18:35:19','',''),(269,'1','289','4',2,'Sale Id shift 65',0.00,0.00,0.00,2732.32,0.00,'2023-02-19 22:57:04','',''),(270,'1','289',NULL,2,'Sale Id shift 65',2158532.80,0.00,0.00,0.00,0.00,'2023-02-19 22:57:04','',''),(271,'1','289','4',2,'Sale Id shift 66',0.00,0.00,0.00,25.25,0.00,'2023-02-20 22:51:26','',''),(272,'1','289',NULL,2,'Sale Id shift 66',19947.50,0.00,0.00,0.00,0.00,'2023-02-20 22:51:26','',''),(273,'1','289','4',2,'Sale Id shift 67',0.00,0.00,0.00,747.18,0.00,'2023-02-21 11:42:31','',''),(274,'1','289',NULL,2,'Sale Id shift 67',590272.20,0.00,0.00,0.00,0.00,'2023-02-21 11:42:31','',''),(275,'1','289','4',2,'Sale Id shift 68',0.00,0.00,0.00,413.29,0.00,'2023-02-26 13:18:07','',''),(276,'1','289',NULL,2,'Sale Id shift 68',326499.10,0.00,0.00,0.00,0.00,'2023-02-26 13:18:07','',''),(277,'1','289','4',2,'Sale Id shift 69',0.00,0.00,0.00,506.33,0.00,'2023-03-01 07:42:01','',''),(278,'1','289',NULL,2,'Sale Id shift 69',400000.70,0.00,0.00,0.00,0.00,'2023-03-01 07:42:01','',''),(279,'1','289','4',2,'Sale Id shift 70',0.00,0.00,0.00,698.79,0.00,'2023-03-02 10:07:05','',''),(280,'1','289',NULL,2,'Sale Id shift 70',552044.10,0.00,0.00,0.00,0.00,'2023-03-02 10:07:05','',''),(281,'1','289','4',2,'Sale Id shift 71',0.00,0.00,0.00,802.57,0.00,'2023-03-02 12:52:47','',''),(282,'1','289',NULL,2,'Sale Id shift 71',634030.30,0.00,0.00,0.00,0.00,'2023-03-02 12:52:47','',''),(283,'1','289','4',2,'Sale Id shift 72',0.00,0.00,0.00,1342.50,0.00,'2023-03-03 09:59:58','',''),(284,'1','289',NULL,2,'Sale Id shift 72',1060575.00,0.00,0.00,0.00,0.00,'2023-03-03 09:59:58','',''),(285,'1','289','4',2,'Sale Id shift 73',0.00,0.00,0.00,5007.13,0.00,'2023-03-04 06:40:54','',''),(286,'1','289','4',2,'Sale Id shift 73',0.00,0.00,0.00,14573.12,0.00,'2023-03-04 06:40:54','',''),(287,'1','289',NULL,2,'Sale Id shift 73',15468397.50,0.00,0.00,0.00,0.00,'2023-03-04 06:40:54','',''),(288,'1','289',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,11750000.00,50000.00,0.00,0.00,'2023-03-05 07:43:56','',''),(289,'1','289',NULL,1,'Reception corrector for bridging 13',0.00,0.00,0.00,50000.00,0.00,'2023-03-05 10:30:30','',''),(290,'1','289','1',1,'Received from bridging 13',0.00,0.00,50000.00,0.00,0.00,'2023-03-05 10:30:30','',''),(291,'1','289',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,36000000.00,45000.00,0.00,0.00,'2023-03-07 11:34:54','',''),(292,'1','289','1',1,'Sale Id shift 74',0.00,0.00,0.00,1754.99,0.00,'2023-03-07 15:02:28','',''),(293,'1','289','1',1,'Sale Id shift 74',0.00,0.00,0.00,1697.18,0.00,'2023-03-07 15:02:28','',''),(294,'1','289',NULL,1,'Sale Id shift 74',811259.95,0.00,0.00,0.00,0.00,'2023-03-07 15:02:28','',''),(295,'1','289',NULL,2,'Reception corrector for bridging 14',0.00,0.00,0.00,45000.00,0.00,'2023-03-07 21:35:18','',''),(296,'1','289','4',2,'Received from bridging 14',0.00,0.00,45000.00,0.00,0.00,'2023-03-07 21:35:18','',''),(297,'1','289','1',1,'Sale Id shift 75',0.00,0.00,0.00,2094.73,0.00,'2023-03-08 09:49:21','',''),(298,'1','289','1',1,'Sale Id shift 75',0.00,0.00,0.00,1440.98,0.00,'2023-03-08 09:49:21','',''),(299,'1','289',NULL,1,'Sale Id shift 75',830891.85,0.00,0.00,0.00,0.00,'2023-03-08 09:49:21','',''),(300,'1','289','1',1,'Sale Id shift 76',0.00,0.00,0.00,2855.27,0.00,'2023-03-08 15:37:46','',''),(301,'1','289','1',1,'Sale Id shift 76',0.00,0.00,0.00,2545.51,0.00,'2023-03-08 15:37:46','',''),(302,'1','289',NULL,1,'Sale Id shift 76',1269183.30,0.00,0.00,0.00,0.00,'2023-03-08 15:37:46','',''),(303,'1','289','1',1,'Sale Id shift 77',0.00,0.00,0.00,4080.91,0.00,'2023-03-08 16:00:23','',''),(304,'1','289','1',1,'Sale Id shift 77',0.00,0.00,0.00,3572.24,0.00,'2023-03-08 16:00:23','',''),(305,'1','289',NULL,1,'Sale Id shift 77',1798490.25,0.00,0.00,0.00,0.00,'2023-03-08 16:00:23','',''),(306,'1','289','1',1,'Sale Id shift 78',0.00,0.00,0.00,4560.02,0.00,'2023-03-08 16:22:53','',''),(307,'1','289','1',1,'Sale Id shift 78',0.00,0.00,0.00,4320.75,0.00,'2023-03-08 16:22:53','',''),(308,'1','289',NULL,1,'Sale Id shift 78',2086980.95,0.00,0.00,0.00,0.00,'2023-03-08 16:22:53','',''),(309,'1','289','4',2,'Sale Id shift 79',0.00,0.00,0.00,848.00,0.00,'2023-03-08 16:59:47','',''),(310,'1','289',NULL,2,'Sale Id shift 79',678400.00,0.00,0.00,0.00,0.00,'2023-03-08 16:59:47','',''),(311,'1','289','1',1,'Sale Id shift 80',0.00,0.00,0.00,3155.64,0.00,'2023-03-09 10:22:55','',''),(312,'1','289','1',1,'Sale Id shift 80',0.00,0.00,0.00,385.48,0.00,'2023-03-09 10:22:55','',''),(313,'1','289','1',1,'Sale Id shift 80',0.00,0.00,0.00,4214.82,0.00,'2023-03-09 10:22:55','',''),(314,'1','289','1',1,'Sale Id shift 80',0.00,0.00,0.00,2796.64,0.00,'2023-03-09 10:22:55','',''),(315,'1','289',NULL,1,'Sale Id shift 80',2479856.30,0.00,0.00,0.00,0.00,'2023-03-09 10:22:55','',''),(316,'1','289',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9870000.00,42000.00,0.00,0.00,'2023-03-09 13:51:41','',''),(317,'1','289',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,11750000.00,50000.00,0.00,0.00,'2023-03-09 13:52:09','',''),(318,'1','289',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,14100000.00,60000.00,0.00,0.00,'2023-03-09 13:52:57','',''),(319,'1','289','4',2,'Sale Id shift 81',0.00,0.00,0.00,2665.12,0.00,'2023-03-09 16:16:57','',''),(320,'1','289',NULL,2,'Sale Id shift 81',2132096.00,0.00,0.00,0.00,0.00,'2023-03-09 16:16:57','',''),(321,'1','289','1',1,'Sale Id shift 82',0.00,0.00,0.00,1829.32,0.00,'2023-03-10 09:28:22','',''),(322,'1','289','1',1,'Sale Id shift 82',0.00,0.00,0.00,1829.54,0.00,'2023-03-10 09:28:22','',''),(323,'1','289','1',1,'Sale Id shift 82',0.00,0.00,0.00,1392.66,0.00,'2023-03-10 09:28:22','',''),(324,'1','289','4',2,'Sale Id shift 82',0.00,0.00,0.00,2629.49,0.00,'2023-03-10 09:28:22','',''),(325,'1','289',NULL,2,'Sale Id shift 82',2103592.00,0.00,0.00,0.00,0.00,'2023-03-10 09:28:22','',''),(326,'1','289',NULL,1,'Sale Id shift 82',1187107.20,0.00,0.00,0.00,0.00,'2023-03-10 09:28:22','',''),(327,'1','289',NULL,1,'Reception corrector for bridging 15',0.00,0.00,0.00,50000.00,0.00,'2023-03-10 09:56:33','',''),(328,'1','289','1',1,'Received from bridging 15',0.00,0.00,50000.00,0.00,0.00,'2023-03-10 09:56:33','',''),(329,'1','289','1',1,'Sale Id shift 84',0.00,0.00,0.00,4320.10,0.00,'2023-03-10 15:44:08','',''),(330,'1','289','1',1,'Sale Id shift 84',0.00,0.00,0.00,3459.08,0.00,'2023-03-10 15:44:08','',''),(331,'1','289','1',1,'Sale Id shift 84',0.00,0.00,0.00,3059.85,0.00,'2023-03-10 15:44:08','',''),(332,'1','289','4',2,'Sale Id shift 84',0.00,0.00,0.00,655.63,0.00,'2023-03-10 15:44:08','',''),(333,'1','289',NULL,2,'Sale Id shift 84',524504.00,0.00,0.00,0.00,0.00,'2023-03-10 15:44:08','',''),(334,'1','289',NULL,1,'Sale Id shift 84',2547172.05,0.00,0.00,0.00,0.00,'2023-03-10 15:44:08','',''),(335,'1','289','1',1,'Sale Id shift 85',0.00,0.00,0.00,5377.43,0.00,'2023-03-11 17:05:53','',''),(336,'1','289','1',1,'Sale Id shift 85',0.00,0.00,0.00,4305.41,0.00,'2023-03-11 17:05:53','',''),(337,'1','289','1',1,'Sale Id shift 85',0.00,0.00,0.00,4139.89,0.00,'2023-03-11 17:05:53','',''),(338,'1','289','4',2,'Sale Id shift 85',0.00,0.00,0.00,2380.26,0.00,'2023-03-11 17:05:53','',''),(339,'1','289',NULL,2,'Sale Id shift 85',1904208.00,0.00,0.00,0.00,0.00,'2023-03-11 17:05:53','',''),(340,'1','289',NULL,1,'Sale Id shift 85',3248341.55,0.00,0.00,0.00,0.00,'2023-03-11 17:05:53','',''),(341,'1','289',NULL,1,'Reception corrector for bridging 16',0.00,0.00,0.00,60000.00,0.00,'2023-03-12 22:41:25','',''),(342,'1','289','1',1,'Received from bridging 16',0.00,0.00,60000.00,0.00,0.00,'2023-03-12 22:41:25','',''),(343,'1','289','1',1,'Sale Id shift 86',0.00,0.00,0.00,6049.68,0.00,'2023-03-13 17:58:08','',''),(344,'1','289','1',1,'Sale Id shift 86',0.00,0.00,0.00,4803.07,0.00,'2023-03-13 17:58:08','',''),(345,'1','289','1',1,'Sale Id shift 86',0.00,0.00,0.00,4713.14,0.00,'2023-03-13 17:58:08','',''),(346,'1','289',NULL,1,'Sale Id shift 86',3657984.15,0.00,0.00,0.00,0.00,'2023-03-13 17:58:08','',''),(347,'1','289','4',2,'Sale Id shift 87',0.00,0.00,0.00,1068.25,0.00,'2023-03-14 08:29:09','',''),(348,'1','289',NULL,2,'Sale Id shift 87',854600.00,0.00,0.00,0.00,0.00,'2023-03-14 08:29:09','',''),(349,'1','289','1',1,'Sale Id shift 88',0.00,0.00,0.00,6968.33,0.00,'2023-03-14 18:37:36','',''),(350,'1','289','1',1,'Sale Id shift 88',0.00,0.00,0.00,4295.31,0.00,'2023-03-14 18:37:36','',''),(351,'1','289','1',1,'Sale Id shift 88',0.00,0.00,0.00,3799.43,0.00,'2023-03-14 18:37:36','',''),(352,'1','289','4',2,'Sale Id shift 88',0.00,0.00,0.00,1177.00,0.00,'2023-03-14 18:37:36','',''),(353,'1','289',NULL,2,'Sale Id shift 88',929830.00,0.00,0.00,0.00,0.00,'2023-03-14 18:37:36','',''),(354,'1','289',NULL,1,'Sale Id shift 88',3539821.45,0.00,0.00,0.00,0.00,'2023-03-14 18:37:36','',''),(355,'1','289',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,10575000.00,45000.00,0.00,0.00,'2023-03-14 18:38:54','',''),(356,'1','289',NULL,1,'Reception corrector for bridging 17',0.00,0.00,0.00,45000.00,0.00,'2023-03-15 21:49:01','',''),(357,'1','289','1',1,'Received from bridging 17',0.00,0.00,45000.00,0.00,0.00,'2023-03-15 21:49:01','',''),(358,'1','289','1',1,'Sale Id shift 89',0.00,0.00,0.00,6008.96,0.00,'2023-03-16 10:45:48','',''),(359,'1','289','1',1,'Sale Id shift 89',0.00,0.00,0.00,5510.26,0.00,'2023-03-16 10:45:48','',''),(360,'1','289','1',1,'Sale Id shift 89',0.00,0.00,0.00,4938.19,0.00,'2023-03-16 10:45:48','',''),(361,'1','289','4',2,'Sale Id shift 89',0.00,0.00,0.00,618.75,0.00,'2023-03-16 10:45:48','',''),(362,'1','289',NULL,2,'Sale Id shift 89',488812.50,0.00,0.00,0.00,0.00,'2023-03-16 10:45:48','',''),(363,'1','289',NULL,1,'Sale Id shift 89',3867491.35,0.00,0.00,0.00,0.00,'2023-03-16 10:45:48','',''),(364,'1','289',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,10575000.00,45000.00,0.00,0.00,'2023-03-16 10:47:25','',''),(365,'1','289','1',1,'Sale Id shift 90',0.00,0.00,0.00,5165.22,0.00,'2023-03-16 12:21:25','',''),(366,'1','289','1',1,'Sale Id shift 90',0.00,0.00,0.00,3935.47,0.00,'2023-03-16 12:21:25','',''),(367,'1','289','1',1,'Sale Id shift 90',0.00,0.00,0.00,2509.24,0.00,'2023-03-16 12:21:25','',''),(368,'1','289','4',2,'Sale Id shift 90',0.00,0.00,0.00,2588.21,0.00,'2023-03-16 12:21:25','',''),(369,'1','289',NULL,2,'Sale Id shift 90',2044685.90,0.00,0.00,0.00,0.00,'2023-03-16 12:21:25','',''),(370,'1','289',NULL,1,'Sale Id shift 90',2728333.55,0.00,0.00,0.00,0.00,'2023-03-16 12:21:25','',''),(371,'1','289',NULL,1,'Reception corrector for bridging 18',0.00,0.00,0.00,45000.00,0.00,'2023-03-16 16:18:54','',''),(372,'1','289','1',1,'Received from bridging 18',0.00,0.00,45000.00,0.00,0.00,'2023-03-16 16:18:54','',''),(373,'1','289','1',1,'Sale Id shift 91',0.00,0.00,0.00,6358.09,0.00,'2023-03-17 21:38:06','',''),(374,'1','289','1',1,'Sale Id shift 91',0.00,0.00,0.00,485.51,0.00,'2023-03-17 21:38:06','',''),(375,'1','289','1',1,'Sale Id shift 91',0.00,0.00,0.00,6746.04,0.00,'2023-03-17 21:38:06','',''),(376,'1','289',NULL,1,'Sale Id shift 91',3193565.40,0.00,0.00,0.00,0.00,'2023-03-17 21:38:06','',''),(377,'1','289','1',1,'Sale Id shift 92',0.00,0.00,0.00,6736.47,0.00,'2023-03-20 08:06:14','',''),(378,'1','289','1',1,'Sale Id shift 92',0.00,0.00,0.00,5410.99,0.00,'2023-03-20 08:06:14','',''),(379,'1','289','1',1,'Sale Id shift 92',0.00,0.00,0.00,5703.66,0.00,'2023-03-20 08:06:14','',''),(380,'1','289','4',2,'Sale Id shift 92',0.00,0.00,0.00,468.99,0.00,'2023-03-20 08:06:14','',''),(381,'1','289',NULL,2,'Sale Id shift 92',370502.10,0.00,0.00,0.00,0.00,'2023-03-20 08:06:14','',''),(382,'1','289',NULL,1,'Sale Id shift 92',4195013.20,0.00,0.00,0.00,0.00,'2023-03-20 08:06:14','',''),(383,'1','289',NULL,1,'Distributed to NIGERIA POLICE FORCE (ELECTION for sales id:1',9870000.00,0.00,0.00,42000.00,0.00,'2023-03-20 08:47:47','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'1','289',2,30461.20,'2023-03-20 19:48:30'),(2,'1','289',1,93995.36,'2023-03-20 19:48:30');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=94 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1,'1','289',1,'Sale Id shift 2',0.00,203315.40,180.00,203315.40,0.00,'2022-10-28 11:03:57'),(2,'1','289',1,'Sale Id shift 3',0.00,153250.20,180.00,153250.20,0.00,'2022-10-28 11:27:40'),(3,'1','289',1,'Sale Id shift 4',0.00,231595.20,180.00,231595.20,0.00,'2022-10-28 11:47:21'),(4,'1','289',1,'Sale Id shift 5',0.00,126937.80,180.00,126937.80,0.00,'2022-10-28 11:59:16'),(5,'1','289',1,'Sale Id shift 6',0.00,224958.60,180.00,224958.60,0.00,'2022-10-28 12:23:51'),(6,'1','289',1,'Sale Id shift 7',0.00,167337.00,180.00,167337.00,0.00,'2022-10-28 12:49:23'),(7,'1','289',1,'Sale Id shift 8',0.00,192074.40,180.00,192074.40,0.00,'2022-10-28 13:17:19'),(8,'1','289',1,'Sale Id shift 9',0.00,179181.00,180.00,179181.00,0.00,'2022-10-29 07:33:57'),(9,'1','289',1,'Sale Id shift 11',0.00,242834.40,180.00,242834.40,0.00,'2022-10-29 07:48:07'),(10,'1','289',1,'Sale Id shift 12',0.00,161323.20,180.00,161323.20,0.00,'2022-10-29 07:54:39'),(11,'1','289',1,'Sale Id shift 13',0.00,200894.40,180.00,200894.40,0.00,'2022-10-29 08:16:39'),(12,'1','289',1,'Sale Id shift 14',0.00,212461.20,180.00,212461.20,0.00,'2022-10-29 08:33:58'),(13,'1','289',1,'Sale Id shift 15',0.00,257472.00,180.00,257472.00,0.00,'2022-10-29 08:40:50'),(14,'1','289',1,'Sale Id shift 16',0.00,471927.60,180.00,471927.60,0.00,'2022-10-29 10:28:47'),(15,'1','289',1,'Sale Id shift 17',0.00,1647342.00,180.00,1647342.00,0.00,'2022-10-29 11:18:56'),(16,'1','289',1,'Sale Id shift 18',0.00,984490.20,180.00,984490.20,0.00,'2022-10-29 11:25:07'),(17,'1','289',1,'Sale Id shift 19',0.00,611269.20,180.00,611269.20,0.00,'2022-10-29 11:36:46'),(18,'1','289',1,'Sale Id shift 20',0.00,471830.40,180.00,471830.40,0.00,'2022-10-29 11:49:08'),(19,'1','289',1,'Sale Id shift 21',0.00,463057.20,180.00,463057.20,0.00,'2022-10-29 11:55:49'),(20,'1','289',1,'Sale Id shift 22',0.00,338342.40,180.00,338342.40,0.00,'2022-10-29 12:05:36'),(21,'1','289',1,'Sale Id shift 23',0.00,607203.00,180.00,607203.00,0.00,'2022-10-29 12:16:59'),(22,'1','289',1,'Sale Id shift 24',0.00,395677.80,180.00,395677.80,0.00,'2022-10-29 12:26:56'),(23,'1','289',1,'Sale Id shift 25',0.00,145998.00,180.00,145998.00,0.00,'2022-10-29 12:43:07'),(24,'1','289',1,'Sale Id shift 26',0.00,325470.60,180.00,325470.60,0.00,'2022-10-29 12:52:06'),(25,'1','289',1,'Sale Id shift 27',0.00,396784.80,180.00,396784.80,0.00,'2022-10-29 13:04:48'),(26,'1','289',1,'Sale Id shift 28',0.00,584334.00,180.00,584334.00,0.00,'2022-10-29 16:22:49'),(27,'1','289',1,'Sale Id shift 29',0.00,568900.80,180.00,568900.80,0.00,'2022-10-30 11:15:04'),(28,'1','289',1,'Sale Id shift 30',0.00,567009.00,180.00,567009.00,0.00,'2022-10-30 11:54:16'),(29,'1','289',1,'Sale Id shift 31',0.00,421417.80,180.00,421417.80,0.00,'2022-10-30 11:58:51'),(30,'1','289',1,'Sale Id shift 32',0.00,532810.80,180.00,532810.80,0.00,'2022-10-30 12:10:41'),(31,'1','289',1,'Sale Id shift 33',0.00,445368.60,180.00,445368.60,0.00,'2022-10-30 12:15:12'),(32,'1','289',1,'Sale Id shift 35',0.00,482490.00,180.00,482490.00,0.00,'2022-11-02 09:48:12'),(33,'1','289',1,'Sale Id shift 36',0.00,513860.40,180.00,513860.40,0.00,'2022-11-02 10:03:29'),(34,'1','289',1,'Sale Id shift 37',0.00,351441.00,180.00,351441.00,0.00,'2022-11-02 10:19:10'),(35,'1','289',1,'Sale Id shift 38',0.00,473911.20,180.00,473911.20,0.00,'2022-11-02 10:25:25'),(36,'1','289',1,'Sale Id shift 39',0.00,527954.40,180.00,527954.40,0.00,'2022-11-02 10:39:48'),(37,'1','289',1,'Sale Id shift 40',0.00,585712.80,180.00,585712.80,0.00,'2022-11-02 11:09:28'),(38,'1','289',1,'Sale Id shift 41',0.00,582946.20,180.00,582946.20,0.00,'2022-11-02 12:50:52'),(39,'1','289',1,'Sale Id shift 42',0.00,477122.40,180.00,477122.40,0.00,'2022-11-02 20:11:19'),(40,'1','289',1,'Sale Id shift 43',0.00,640440.00,180.00,640440.00,0.00,'2022-11-06 14:18:50'),(41,'1','289',1,'Sale Id shift 44',0.00,70761.60,180.00,60652.80,-10108.80,'2022-11-24 11:52:44'),(42,'1','289',1,'Sale Id shift 45',0.00,619609.20,210.00,619609.20,0.00,'2022-11-24 16:29:32'),(43,'1','289',1,'Sale Id shift 46',0.00,719090.40,210.00,719090.40,0.00,'2022-11-25 10:31:20'),(44,'1','289',1,'Sale Id shift 47',0.00,866218.50,210.00,866218.50,0.00,'2022-11-25 17:51:36'),(45,'1','289',1,'Sale Id shift 49',0.00,919522.80,210.00,919522.80,0.00,'2022-11-26 15:12:40'),(46,'1','289',1,'Sale Id shift 52',0.00,1280892.90,210.00,1280892.90,0.00,'2022-11-30 17:39:05'),(47,'1','289',1,'Sale Id shift 53',0.00,42869.40,210.00,42869.40,0.00,'2022-12-01 07:49:21'),(48,'1','289',1,'Sale Id shift 54',0.00,1106198.10,210.00,1106198.10,0.00,'2022-12-01 14:55:39'),(49,'1','289',1,'Sale Id shift 55',0.00,1035499.50,210.00,1035499.50,0.00,'2022-12-01 15:12:29'),(50,'1','289',1,'Sale Id shift 56',0.00,1152087.30,210.00,1152087.30,0.00,'2022-12-01 15:23:44'),(51,'1','289',1,'Sale Id shift 57',0.00,1104805.80,210.00,1104805.80,0.00,'2022-12-01 15:32:56'),(52,'1','289',1,'Sale Id shift 58',0.00,872634.00,210.00,872634.00,0.00,'2022-12-01 16:27:29'),(53,'1','289',1,'Sale Id shift 59',0.00,1150491.30,210.00,1150491.30,0.00,'2022-12-01 16:36:48'),(54,'1','289',1,'Sale Id shift 60',0.00,1068274.20,210.00,1068274.20,0.00,'2022-12-02 10:25:51'),(55,'1','289',1,'Sale Id shift 61',0.00,408655.80,210.00,408655.80,0.00,'2022-12-02 12:19:57'),(56,'1','289',1,'Sale Id shift 62',0.00,454803.30,210.00,454803.30,0.00,'2022-12-09 17:43:04'),(57,'1','289',2,'Sale Id shift 63',0.00,987563.20,790.00,987563.20,0.00,'2023-02-16 09:19:06'),(58,'1','289',2,'Sale Id shift 64',0.00,1059026.60,790.00,1059026.60,0.00,'2023-02-16 18:35:19'),(59,'1','289',2,'Sale Id shift 65',0.00,2158532.80,790.00,2158532.80,0.00,'2023-02-19 22:57:04'),(60,'1','289',2,'Sale Id shift 66',0.00,19947.50,790.00,19947.50,0.00,'2023-02-20 22:51:26'),(61,'1','289',2,'Sale Id shift 67',0.00,590272.20,790.00,590272.20,0.00,'2023-02-21 11:42:31'),(62,'1','289',2,'Sale Id shift 68',0.00,326499.10,790.00,326499.10,0.00,'2023-02-26 13:18:07'),(63,'1','289',2,'Sale Id shift 69',0.00,400000.70,790.00,400000.70,0.00,'2023-03-01 07:42:01'),(64,'1','289',2,'Sale Id shift 70',0.00,552044.10,790.00,552044.10,0.00,'2023-03-02 10:07:05'),(65,'1','289',2,'Sale Id shift 71',0.00,634030.30,790.00,634030.30,0.00,'2023-03-02 12:52:47'),(66,'1','289',2,'Sale Id shift 72',0.00,1060575.00,790.00,1060575.00,0.00,'2023-03-03 09:59:58'),(67,'1','289',2,'Sale Id shift 73',0.00,15468397.50,790.00,15468397.50,0.00,'2023-03-04 06:40:54'),(68,'1','289',1,'Sale Id shift 74',0.00,811259.95,235.00,811259.95,0.00,'2023-03-07 15:02:28'),(69,'1','289',1,'Sale Id shift 75',0.00,830891.85,235.00,830891.85,0.00,'2023-03-08 09:49:21'),(70,'1','289',1,'Sale Id shift 76',0.00,1269183.30,235.00,1269183.30,0.00,'2023-03-08 15:37:46'),(71,'1','289',1,'Sale Id shift 77',0.00,1798490.25,235.00,1798490.25,0.00,'2023-03-08 16:00:23'),(72,'1','289',1,'Sale Id shift 78',0.00,2086980.95,235.00,2086980.95,0.00,'2023-03-08 16:22:53'),(73,'1','289',2,'Sale Id shift 79',0.00,678400.00,800.00,678400.00,0.00,'2023-03-08 16:59:47'),(74,'1','289',1,'Sale Id shift 80',0.00,2479856.30,235.00,2479856.30,0.00,'2023-03-09 10:22:55'),(75,'1','289',2,'Sale Id shift 81',0.00,2132096.00,800.00,2132096.00,0.00,'2023-03-09 16:16:57'),(76,'1','289',2,'Sale Id shift 82',0.00,2103592.00,800.00,2103592.00,0.00,'2023-03-10 09:28:22'),(77,'1','289',1,'Sale Id shift 82',0.00,1187107.20,235.00,1187107.20,0.00,'2023-03-10 09:28:22'),(78,'1','289',2,'Sale Id shift 84',0.00,524504.00,800.00,524504.00,0.00,'2023-03-10 15:44:08'),(79,'1','289',1,'Sale Id shift 84',0.00,2547172.05,235.00,2547172.05,0.00,'2023-03-10 15:44:08'),(80,'1','289',2,'Sale Id shift 85',0.00,1904208.00,800.00,1904208.00,0.00,'2023-03-11 17:05:53'),(81,'1','289',1,'Sale Id shift 85',0.00,3248341.55,235.00,3248341.55,0.00,'2023-03-11 17:05:53'),(82,'1','289',1,'Sale Id shift 86',0.00,3657984.15,235.00,3657984.15,0.00,'2023-03-13 17:58:08'),(83,'1','289',2,'Sale Id shift 87',0.00,854600.00,800.00,854600.00,0.00,'2023-03-14 08:29:09'),(84,'1','289',2,'Sale Id shift 88',0.00,929830.00,790.00,929830.00,0.00,'2023-03-14 18:37:36'),(85,'1','289',1,'Sale Id shift 88',0.00,3539821.45,235.00,3539821.45,0.00,'2023-03-14 18:37:36'),(86,'1','289',2,'Sale Id shift 89',0.00,488812.50,790.00,488812.50,0.00,'2023-03-16 10:45:48'),(87,'1','289',1,'Sale Id shift 89',0.00,3867491.35,235.00,3867491.35,0.00,'2023-03-16 10:45:48'),(88,'1','289',2,'Sale Id shift 90',0.00,2044685.90,790.00,2044685.90,0.00,'2023-03-16 12:21:25'),(89,'1','289',1,'Sale Id shift 90',0.00,2728333.55,235.00,2728333.55,0.00,'2023-03-16 12:21:25'),(90,'1','289',1,'Sale Id shift 91',0.00,3193565.40,235.00,3193565.40,0.00,'2023-03-17 21:38:06'),(91,'1','289',2,'Sale Id shift 92',0.00,370502.10,790.00,370502.10,0.00,'2023-03-20 08:06:14'),(92,'1','289',1,'Sale Id shift 92',0.00,4195013.20,235.00,4195013.20,0.00,'2023-03-20 08:06:14'),(93,'1','289',1,'Sale Id 1',0.00,9870000.00,235.00,9870000.00,0.00,'2023-03-20 08:44:16');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=519 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('1','289',1,'','24','2',0.00,9000000.00,'Purchase Id 1 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-10-26 11:25:32','',''),('1','289',2,'','supplier','1',9000000.00,0.00,'Purchase Id 1 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-10-26 11:25:32','',''),('1','289',3,'','24','2',0.00,9000000.00,'Purchase Id 2 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-10-26 11:25:56','',''),('1','289',4,'','supplier','1',9000000.00,0.00,'Purchase Id 2 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-10-26 11:25:56','',''),('1','289',5,'','20','3',0.00,0.00,'Sales from shift 1 on 2022-10-28 10:34:45 ','2022-10-28 10:34:45','',''),('1','289',6,'','6.1','4',0.00,0.00,'Sales from shift 1 on 2022-10-28 10:34:45 ','2022-10-28 10:34:45','',''),('1','289',7,'','20','3',203315.40,0.00,'Sales from shift 2 on 2022-10-28 11:03:57 ','2022-10-28 11:03:57','',''),('1','289',8,'','6.1','4',0.00,203315.40,'Sales from shift 2 on 2022-10-28 11:03:57 ','2022-10-28 11:03:57','',''),('1','289',9,'','20','3',153250.20,0.00,'Sales from shift 3 on 2022-10-28 11:27:40 ','2022-10-28 11:27:40','',''),('1','289',10,'','6.1','4',0.00,153250.20,'Sales from shift 3 on 2022-10-28 11:27:40 ','2022-10-28 11:27:40','',''),('1','289',11,'','20','3',231595.20,0.00,'Sales from shift 4 on 2022-10-28 11:47:21 ','2022-10-28 11:47:21','',''),('1','289',12,'','6.1','4',0.00,231595.20,'Sales from shift 4 on 2022-10-28 11:47:21 ','2022-10-28 11:47:21','',''),('1','289',13,'','20','3',126937.80,0.00,'Sales from shift 5 on 2022-10-28 11:59:16 ','2022-10-28 11:59:16','',''),('1','289',14,'','6.1','4',0.00,126937.80,'Sales from shift 5 on 2022-10-28 11:59:16 ','2022-10-28 11:59:16','',''),('1','289',15,'','20','3',224958.60,0.00,'Sales from shift 6 on 2022-10-28 12:23:51 ','2022-10-28 12:23:51','',''),('1','289',16,'','6.1','4',0.00,224958.60,'Sales from shift 6 on 2022-10-28 12:23:51 ','2022-10-28 12:23:51','',''),('1','289',17,'','20','3',167337.00,0.00,'Sales from shift 7 on 2022-10-28 12:49:23 ','2022-10-28 12:49:23','',''),('1','289',18,'','6.1','4',0.00,167337.00,'Sales from shift 7 on 2022-10-28 12:49:23 ','2022-10-28 12:49:23','',''),('1','289',19,'','20','3',192074.40,0.00,'Sales from shift 8 on 2022-10-28 13:17:19 ','2022-10-28 13:17:19','',''),('1','289',20,'','6.1','4',0.00,192074.40,'Sales from shift 8 on 2022-10-28 13:17:19 ','2022-10-28 13:17:19','',''),('1','289',21,'','20','3',179181.00,0.00,'Sales from shift 9 on 2022-10-29 07:33:57 ','2022-10-29 07:33:57','',''),('1','289',22,'','6.1','4',0.00,179181.00,'Sales from shift 9 on 2022-10-29 07:33:57 ','2022-10-29 07:33:57','',''),('1','289',23,'','20','3',242834.40,0.00,'Sales from shift 11 on 2022-10-29 07:48:07 ','2022-10-29 07:48:07','',''),('1','289',24,'','6.1','4',0.00,242834.40,'Sales from shift 11 on 2022-10-29 07:48:07 ','2022-10-29 07:48:07','',''),('1','289',25,'','20','3',161323.20,0.00,'Sales from shift 12 on 2022-10-29 07:54:39 ','2022-10-29 07:54:39','',''),('1','289',26,'','6.1','4',0.00,161323.20,'Sales from shift 12 on 2022-10-29 07:54:39 ','2022-10-29 07:54:39','',''),('1','289',27,'','20','3',200894.40,0.00,'Sales from shift 13 on 2022-10-29 08:16:39 ','2022-10-29 08:16:39','',''),('1','289',28,'','6.1','4',0.00,200894.40,'Sales from shift 13 on 2022-10-29 08:16:39 ','2022-10-29 08:16:39','',''),('1','289',29,'','20','3',212461.20,0.00,'Sales from shift 14 on 2022-10-29 08:33:58 ','2022-10-29 08:33:58','',''),('1','289',30,'','6.1','4',0.00,212461.20,'Sales from shift 14 on 2022-10-29 08:33:58 ','2022-10-29 08:33:58','',''),('1','289',31,'','20','3',257472.00,0.00,'Sales from shift 15 on 2022-10-29 08:40:50 ','2022-10-29 08:40:50','',''),('1','289',32,'','6.1','4',0.00,257472.00,'Sales from shift 15 on 2022-10-29 08:40:50 ','2022-10-29 08:40:50','',''),('1','289',33,'','20','3',471927.60,0.00,'Sales from shift 16 on 2022-10-29 10:28:47 ','2022-10-29 10:28:47','',''),('1','289',34,'','6.1','4',0.00,471927.60,'Sales from shift 16 on 2022-10-29 10:28:47 ','2022-10-29 10:28:47','',''),('1','289',35,'','20','3',1647342.00,0.00,'Sales from shift 17 on 2022-10-29 11:18:56 ','2022-10-29 11:18:56','',''),('1','289',36,'','6.1','4',0.00,1647342.00,'Sales from shift 17 on 2022-10-29 11:18:56 ','2022-10-29 11:18:56','',''),('1','289',37,'','20','3',984490.20,0.00,'Sales from shift 18 on 2022-10-29 11:25:07 ','2022-10-29 11:25:07','',''),('1','289',38,'','6.1','4',0.00,984490.20,'Sales from shift 18 on 2022-10-29 11:25:07 ','2022-10-29 11:25:07','',''),('1','289',39,'','20','3',611269.20,0.00,'Sales from shift 19 on 2022-10-29 11:36:46 ','2022-10-29 11:36:46','',''),('1','289',40,'','6.1','4',0.00,611269.20,'Sales from shift 19 on 2022-10-29 11:36:46 ','2022-10-29 11:36:46','',''),('1','289',41,'','20','3',471830.40,0.00,'Sales from shift 20 on 2022-10-29 11:49:08 ','2022-10-29 11:49:08','',''),('1','289',42,'','6.1','4',0.00,471830.40,'Sales from shift 20 on 2022-10-29 11:49:08 ','2022-10-29 11:49:08','',''),('1','289',43,'','20','3',463057.20,0.00,'Sales from shift 21 on 2022-10-29 11:55:49 ','2022-10-29 11:55:49','',''),('1','289',44,'','6.1','4',0.00,463057.20,'Sales from shift 21 on 2022-10-29 11:55:49 ','2022-10-29 11:55:49','',''),('1','289',45,'','20','3',338342.40,0.00,'Sales from shift 22 on 2022-10-29 12:05:36 ','2022-10-29 12:05:36','',''),('1','289',46,'','6.1','4',0.00,338342.40,'Sales from shift 22 on 2022-10-29 12:05:36 ','2022-10-29 12:05:36','',''),('1','289',47,'','20','3',607203.00,0.00,'Sales from shift 23 on 2022-10-29 12:16:59 ','2022-10-29 12:16:59','',''),('1','289',48,'','6.1','4',0.00,607203.00,'Sales from shift 23 on 2022-10-29 12:16:59 ','2022-10-29 12:16:59','',''),('1','289',49,'','20','3',395677.80,0.00,'Sales from shift 24 on 2022-10-29 12:26:56 ','2022-10-29 12:26:56','',''),('1','289',50,'','6.1','4',0.00,395677.80,'Sales from shift 24 on 2022-10-29 12:26:56 ','2022-10-29 12:26:56','',''),('1','289',51,'','20','3',145998.00,0.00,'Sales from shift 25 on 2022-10-29 12:43:07 ','2022-10-29 12:43:07','',''),('1','289',52,'','6.1','4',0.00,145998.00,'Sales from shift 25 on 2022-10-29 12:43:07 ','2022-10-29 12:43:07','',''),('1','289',53,'','20','3',325470.60,0.00,'Sales from shift 26 on 2022-10-29 12:52:06 ','2022-10-29 12:52:06','',''),('1','289',54,'','6.1','4',0.00,325470.60,'Sales from shift 26 on 2022-10-29 12:52:06 ','2022-10-29 12:52:06','',''),('1','289',55,'','20','3',396784.80,0.00,'Sales from shift 27 on 2022-10-29 13:04:48 ','2022-10-29 13:04:48','',''),('1','289',56,'','6.1','4',0.00,396784.80,'Sales from shift 27 on 2022-10-29 13:04:48 ','2022-10-29 13:04:48','',''),('1','289',57,'','20','3',584334.00,0.00,'Sales from shift 28 on 2022-10-29 16:22:49 ','2022-10-29 16:22:49','',''),('1','289',58,'','6.1','4',0.00,584334.00,'Sales from shift 28 on 2022-10-29 16:22:49 ','2022-10-29 16:22:49','',''),('1','289',59,'','20','3',568900.80,0.00,'Sales from shift 29 on 2022-10-30 11:15:04 ','2022-10-30 11:15:04','',''),('1','289',60,'','6.1','4',0.00,568900.80,'Sales from shift 29 on 2022-10-30 11:15:04 ','2022-10-30 11:15:04','',''),('1','289',61,'','20','3',567009.00,0.00,'Sales from shift 30 on 2022-10-30 11:54:16 ','2022-10-30 11:54:16','',''),('1','289',62,'','6.1','4',0.00,567009.00,'Sales from shift 30 on 2022-10-30 11:54:16 ','2022-10-30 11:54:16','',''),('1','289',63,'','20','3',421417.80,0.00,'Sales from shift 31 on 2022-10-30 11:58:51 ','2022-10-30 11:58:51','',''),('1','289',64,'','6.1','4',0.00,421417.80,'Sales from shift 31 on 2022-10-30 11:58:51 ','2022-10-30 11:58:51','',''),('1','289',65,'','20','3',532810.80,0.00,'Sales from shift 32 on 2022-10-30 12:10:41 ','2022-10-30 12:10:41','',''),('1','289',66,'','6.1','4',0.00,532810.80,'Sales from shift 32 on 2022-10-30 12:10:41 ','2022-10-30 12:10:41','',''),('1','289',67,'','20','3',445368.60,0.00,'Sales from shift 33 on 2022-10-30 12:15:12 ','2022-10-30 12:15:12','',''),('1','289',68,'','6.1','4',0.00,445368.60,'Sales from shift 33 on 2022-10-30 12:15:12 ','2022-10-30 12:15:12','',''),('1','289',69,'','20','3',0.00,0.00,'Sales from shift 34 on 2022-11-01 18:08:29 ','2022-11-01 18:08:29','',''),('1','289',70,'','6.1','4',0.00,0.00,'Sales from shift 34 on 2022-11-01 18:08:29 ','2022-11-01 18:08:29','',''),('1','289',71,'','20','3',482490.00,0.00,'Sales from shift 35 on 2022-11-02 09:48:12 ','2022-11-02 09:48:12','',''),('1','289',72,'','6.1','4',0.00,482490.00,'Sales from shift 35 on 2022-11-02 09:48:12 ','2022-11-02 09:48:12','',''),('1','289',73,'','20','3',513860.40,0.00,'Sales from shift 36 on 2022-11-02 10:03:29 ','2022-11-02 10:03:29','',''),('1','289',74,'','6.1','4',0.00,513860.40,'Sales from shift 36 on 2022-11-02 10:03:29 ','2022-11-02 10:03:29','',''),('1','289',75,'','20','3',351441.00,0.00,'Sales from shift 37 on 2022-11-02 10:19:10 ','2022-11-02 10:19:10','',''),('1','289',76,'','6.1','4',0.00,351441.00,'Sales from shift 37 on 2022-11-02 10:19:10 ','2022-11-02 10:19:10','',''),('1','289',77,'','20','3',473911.20,0.00,'Sales from shift 38 on 2022-11-02 10:25:25 ','2022-11-02 10:25:25','',''),('1','289',78,'','6.1','4',0.00,473911.20,'Sales from shift 38 on 2022-11-02 10:25:25 ','2022-11-02 10:25:25','',''),('1','289',79,'','20','3',527954.40,0.00,'Sales from shift 39 on 2022-11-02 10:39:48 ','2022-11-02 10:39:48','',''),('1','289',80,'','6.1','4',0.00,527954.40,'Sales from shift 39 on 2022-11-02 10:39:48 ','2022-11-02 10:39:48','',''),('1','289',81,'','20','3',585712.80,0.00,'Sales from shift 40 on 2022-11-02 11:09:28 ','2022-11-02 11:09:28','',''),('1','289',82,'','6.1','4',0.00,585712.80,'Sales from shift 40 on 2022-11-02 11:09:28 ','2022-11-02 11:09:28','',''),('1','289',83,'','20','3',582946.20,0.00,'Sales from shift 41 on 2022-11-02 12:50:52 ','2022-11-02 12:50:52','',''),('1','289',84,'','6.1','4',0.00,582946.20,'Sales from shift 41 on 2022-11-02 12:50:52 ','2022-11-02 12:50:52','',''),('1','289',85,'','20','3',477122.40,0.00,'Sales from shift 42 on 2022-11-02 20:11:19 ','2022-11-02 20:11:19','',''),('1','289',86,'','6.1','4',0.00,477122.40,'Sales from shift 42 on 2022-11-02 20:11:19 ','2022-11-02 20:11:19','',''),('1','289',87,'','20','3',640440.00,0.00,'Sales from shift 43 on 2022-11-06 14:18:49 ','2022-11-06 14:18:49','',''),('1','289',88,'','6.1','4',0.00,640440.00,'Sales from shift 43 on 2022-11-06 14:18:49 ','2022-11-06 14:18:49','',''),('1','289',89,'','2','5',127000.00,0.00,'Payment Id 4 for invoice:5, receipt: 0632534 by AA RANO NIGERIA LTD','2022-11-10 14:54:22','',''),('1','289',90,'','supplier','1',0.00,127000.00,'Payment Id 4 for invoice:5, receipt: 0632534 by AA RANO NIGERIA LTD','2022-11-10 14:54:22','',''),('1','289',91,'','2','5',231595.00,0.00,'Payment Id 3 for invoice:4, receipt: 0632814 by AA RANO NIGERIA LTD','2022-11-10 14:54:22','',''),('1','289',92,'','supplier','1',0.00,231595.00,'Payment Id 3 for invoice:4, receipt: 0632814 by AA RANO NIGERIA LTD','2022-11-10 14:54:22','',''),('1','289',93,'','2','5',146100.00,0.00,'Payment Id 2 for invoice:3, receipt: 0632822 by AA RANO NIGERIA LTD','2022-11-10 14:54:22','',''),('1','289',94,'','supplier','1',0.00,146100.00,'Payment Id 2 for invoice:3, receipt: 0632822 by AA RANO NIGERIA LTD','2022-11-10 14:54:22','',''),('1','289',95,'','2','5',203320.00,0.00,'Payment Id 1 for invoice:2, receipt: 0632815 by AA RANO NIGERIA LTD','2022-11-10 14:54:22','',''),('1','289',96,'','supplier','1',0.00,203320.00,'Payment Id 1 for invoice:2, receipt: 0632815 by AA RANO NIGERIA LTD','2022-11-10 14:54:22','',''),('1','289',97,'','2','6',38005.00,0.00,'Payment Id 78 for invoice:6, receipt: 2033XOYF,,,,, by AA RANO NIGERIA LTD','2022-11-10 14:57:31','',''),('1','289',98,'','supplier','1',0.00,38005.00,'Payment Id 78 for invoice:6, receipt: 2033XOYF,,,,, by AA RANO NIGERIA LTD','2022-11-10 14:57:31','',''),('1','289',99,'','2','5',183210.00,0.00,'Payment Id 5 for invoice:6, receipt: 0632533 by AA RANO NIGERIA LTD','2022-11-10 14:57:31','',''),('1','289',100,'','supplier','1',0.00,183210.00,'Payment Id 5 for invoice:6, receipt: 0632533 by AA RANO NIGERIA LTD','2022-11-10 14:57:31','',''),('1','289',101,'','2','6',55500.00,0.00,'Payment Id 79 for invoice:7/8, receipt: KHG by AA RANO NIGERIA LTD','2022-11-10 14:58:35','',''),('1','289',102,'','supplier','1',0.00,55500.00,'Payment Id 79 for invoice:7/8, receipt: KHG by AA RANO NIGERIA LTD','2022-11-10 14:58:35','',''),('1','289',103,'','2','5',178580.00,0.00,'Payment Id 9 for invoice:8, receipt: 0632532 by AA RANO NIGERIA LTD','2022-11-10 14:58:35','',''),('1','289',104,'','supplier','1',0.00,178580.00,'Payment Id 9 for invoice:8, receipt: 0632532 by AA RANO NIGERIA LTD','2022-11-10 14:58:35','',''),('1','289',105,'','2','5',125380.00,0.00,'Payment Id 7 for invoice:7, receipt: 0632825 by AA RANO NIGERIA LTD','2022-11-10 14:58:35','',''),('1','289',106,'','supplier','1',0.00,125380.00,'Payment Id 7 for invoice:7, receipt: 0632825 by AA RANO NIGERIA LTD','2022-11-10 14:58:35','',''),('1','289',107,'','2','6',98900.00,0.00,'Payment Id 80 for invoice:9/11, receipt: HGVH by AA RANO NIGERIA LTD','2022-11-10 15:01:00','',''),('1','289',108,'','supplier','1',0.00,98900.00,'Payment Id 80 for invoice:9/11, receipt: HGVH by AA RANO NIGERIA LTD','2022-11-10 15:01:00','',''),('1','289',109,'','2','5',184440.00,0.00,'Payment Id 13 for invoice:11, receipt: 0632530 by AA RANO NIGERIA LTD','2022-11-10 15:01:00','',''),('1','289',110,'','supplier','1',0.00,184440.00,'Payment Id 13 for invoice:11, receipt: 0632530 by AA RANO NIGERIA LTD','2022-11-10 15:01:00','',''),('1','289',111,'','2','5',138320.00,0.00,'Payment Id 11 for invoice:9, receipt: 0632531 by AA RANO NIGERIA LTD','2022-11-10 15:01:00','',''),('1','289',112,'','supplier','1',0.00,138320.00,'Payment Id 11 for invoice:9, receipt: 0632531 by AA RANO NIGERIA LTD','2022-11-10 15:01:00','',''),('1','289',113,'','2','6',49408.00,0.00,'Payment Id 81 for invoice:12/13, receipt: BGFGUIJ by AA RANO NIGERIA LTD','2022-11-10 15:04:31','',''),('1','289',114,'','supplier','1',0.00,49408.00,'Payment Id 81 for invoice:12/13, receipt: BGFGUIJ by AA RANO NIGERIA LTD','2022-11-10 15:04:31','',''),('1','289',115,'','2','5',188300.00,0.00,'Payment Id 17 for invoice:13, receipt: 0632522 by AA RANO NIGERIA LTD','2022-11-10 15:04:31','',''),('1','289',116,'','supplier','1',0.00,188300.00,'Payment Id 17 for invoice:13, receipt: 0632522 by AA RANO NIGERIA LTD','2022-11-10 15:04:31','',''),('1','289',117,'','2','5',112520.00,0.00,'Payment Id 15 for invoice:12, receipt: 0632528 by AA RANO NIGERIA LTD','2022-11-10 15:04:31','',''),('1','289',118,'','supplier','1',0.00,112520.00,'Payment Id 15 for invoice:12, receipt: 0632528 by AA RANO NIGERIA LTD','2022-11-10 15:04:31','',''),('1','289',119,'','2','6',56600.00,0.00,'Payment Id 84 for invoice:14/15, receipt: DFGH by AA RANO NIGERIA LTD','2022-11-10 15:06:27','',''),('1','289',120,'','supplier','1',0.00,56600.00,'Payment Id 84 for invoice:14/15, receipt: DFGH by AA RANO NIGERIA LTD','2022-11-10 15:06:27','',''),('1','289',121,'','2','5',157875.00,0.00,'Payment Id 21 for invoice:15, receipt: 0632524 by AA RANO NIGERIA LTD','2022-11-10 15:06:27','',''),('1','289',122,'','supplier','1',0.00,157875.00,'Payment Id 21 for invoice:15, receipt: 0632524 by AA RANO NIGERIA LTD','2022-11-10 15:06:27','',''),('1','289',123,'','2','5',156920.00,0.00,'Payment Id 19 for invoice:14, receipt: 0632523 by AA RANO NIGERIA LTD','2022-11-10 15:06:27','',''),('1','289',124,'','supplier','1',0.00,156920.00,'Payment Id 19 for invoice:14, receipt: 0632523 by AA RANO NIGERIA LTD','2022-11-10 15:06:27','',''),('1','289',125,'','2','6',590834.00,0.00,'Payment Id 85 for invoice:16/17, receipt: jhgfc by AA RANO NIGERIA LTD','2022-11-10 16:21:19','',''),('1','289',126,'','supplier','1',0.00,590834.00,'Payment Id 85 for invoice:16/17, receipt: jhgfc by AA RANO NIGERIA LTD','2022-11-10 16:21:19','',''),('1','289',127,'','2','5',969430.00,0.00,'Payment Id 25 for invoice:17, receipt: 0632526 by AA RANO NIGERIA LTD','2022-11-10 16:21:19','',''),('1','289',128,'','supplier','1',0.00,969430.00,'Payment Id 25 for invoice:17, receipt: 0632526 by AA RANO NIGERIA LTD','2022-11-10 16:21:19','',''),('1','289',129,'','2','5',405780.00,0.00,'Payment Id 23 for invoice:16, receipt: 0632525 by AA RANO NIGERIA LTD','2022-11-10 16:21:19','',''),('1','289',130,'','supplier','1',0.00,405780.00,'Payment Id 23 for invoice:16, receipt: 0632525 by AA RANO NIGERIA LTD','2022-11-10 16:21:19','',''),('1','289',131,'','2','6',287738.00,0.00,'Payment Id 86 for invoice:18/19, receipt: bnm by AA RANO NIGERIA LTD','2022-11-10 16:22:37','',''),('1','289',132,'','supplier','1',0.00,287738.00,'Payment Id 86 for invoice:18/19, receipt: bnm by AA RANO NIGERIA LTD','2022-11-10 16:22:37','',''),('1','289',133,'','2','5',428190.00,0.00,'Payment Id 29 for invoice:19, receipt: 0581786 by AA RANO NIGERIA LTD','2022-11-10 16:22:37','',''),('1','289',134,'','supplier','1',0.00,428190.00,'Payment Id 29 for invoice:19, receipt: 0581786 by AA RANO NIGERIA LTD','2022-11-10 16:22:37','',''),('1','289',135,'','2','5',879690.00,0.00,'Payment Id 27 for invoice:18, receipt: 0581787 by AA RANO NIGERIA LTD','2022-11-10 16:22:37','',''),('1','289',136,'','supplier','1',0.00,879690.00,'Payment Id 27 for invoice:18, receipt: 0581787 by AA RANO NIGERIA LTD','2022-11-10 16:22:37','',''),('1','289',137,'','2','6',192980.00,0.00,'Payment Id 87 for invoice:20/21, receipt: rthjk, by AA RANO NIGERIA LTD','2022-11-10 16:23:54','',''),('1','289',138,'','supplier','1',0.00,192980.00,'Payment Id 87 for invoice:20/21, receipt: rthjk, by AA RANO NIGERIA LTD','2022-11-10 16:23:54','',''),('1','289',139,'','2','5',199160.00,0.00,'Payment Id 33 for invoice:21, receipt: 0581782 by AA RANO NIGERIA LTD','2022-11-10 16:23:54','',''),('1','289',140,'','supplier','1',0.00,199160.00,'Payment Id 33 for invoice:21, receipt: 0581782 by AA RANO NIGERIA LTD','2022-11-10 16:23:54','',''),('1','289',141,'','2','5',332750.00,0.00,'Payment Id 31 for invoice:20, receipt: 0282094 by AA RANO NIGERIA LTD','2022-11-10 16:23:54','',''),('1','289',142,'','supplier','1',0.00,332750.00,'Payment Id 31 for invoice:20, receipt: 0282094 by AA RANO NIGERIA LTD','2022-11-10 16:23:54','',''),('1','289',143,'','2','6',96900.00,0.00,'Payment Id 88 for invoice:22/23, receipt: efghnm by AA RANO NIGERIA LTD','2022-11-10 16:26:09','',''),('1','289',144,'','supplier','1',0.00,96900.00,'Payment Id 88 for invoice:22/23, receipt: efghnm by AA RANO NIGERIA LTD','2022-11-10 16:26:09','',''),('1','289',145,'','2','5',537765.00,0.00,'Payment Id 37 for invoice:23, receipt: 0581780 by AA RANO NIGERIA LTD','2022-11-10 16:26:09','',''),('1','289',146,'','supplier','1',0.00,537765.00,'Payment Id 37 for invoice:23, receipt: 0581780 by AA RANO NIGERIA LTD','2022-11-10 16:26:09','',''),('1','289',147,'','2','5',310340.00,0.00,'Payment Id 35 for invoice:22, receipt: 0581781 by AA RANO NIGERIA LTD','2022-11-10 16:26:09','',''),('1','289',148,'','supplier','1',0.00,310340.00,'Payment Id 35 for invoice:22, receipt: 0581781 by AA RANO NIGERIA LTD','2022-11-10 16:26:09','',''),('1','289',149,'','2','6',92800.00,0.00,'Payment Id 89 for invoice:24/25, receipt: ngfef by AA RANO NIGERIA LTD','2022-11-10 16:43:39','',''),('1','289',150,'','supplier','1',0.00,92800.00,'Payment Id 89 for invoice:24/25, receipt: ngfef by AA RANO NIGERIA LTD','2022-11-10 16:43:39','',''),('1','289',151,'','2','5',47210.00,0.00,'Payment Id 41 for invoice:25, receipt: 0581778 by AA RANO NIGERIA LTD','2022-11-10 16:43:39','',''),('1','289',152,'','supplier','1',0.00,47210.00,'Payment Id 41 for invoice:25, receipt: 0581778 by AA RANO NIGERIA LTD','2022-11-10 16:43:39','',''),('1','289',153,'','2','5',355880.00,0.00,'Payment Id 39 for invoice:24, receipt: 0581779 by AA RANO NIGERIA LTD','2022-11-10 16:43:39','',''),('1','289',154,'','supplier','1',0.00,355880.00,'Payment Id 39 for invoice:24, receipt: 0581779 by AA RANO NIGERIA LTD','2022-11-10 16:43:39','',''),('1','289',155,'','2','6',108178.60,0.00,'Payment Id 90 for invoice:26/27, receipt: /kfcvhu by AA RANO NIGERIA LTD','2022-11-10 16:44:41','',''),('1','289',156,'','supplier','1',0.00,108178.60,'Payment Id 90 for invoice:26/27, receipt: /kfcvhu by AA RANO NIGERIA LTD','2022-11-10 16:44:41','',''),('1','289',157,'','2','5',317110.00,0.00,'Payment Id 45 for invoice:27, receipt: 0581776 by AA RANO NIGERIA LTD','2022-11-10 16:44:41','',''),('1','289',158,'','supplier','1',0.00,317110.00,'Payment Id 45 for invoice:27, receipt: 0581776 by AA RANO NIGERIA LTD','2022-11-10 16:44:41','',''),('1','289',159,'','2','5',212870.00,0.00,'Payment Id 43 for invoice:26, receipt: 0581777 by AA RANO NIGERIA LTD','2022-11-10 16:44:41','',''),('1','289',160,'','supplier','1',0.00,212870.00,'Payment Id 43 for invoice:26, receipt: 0581777 by AA RANO NIGERIA LTD','2022-11-10 16:44:41','',''),('1','289',161,'','2','6',150218.00,0.00,'Payment Id 91 for invoice:28/29, receipt: nhyujm by AA RANO NIGERIA LTD','2022-11-10 16:45:41','',''),('1','289',162,'','supplier','1',0.00,150218.00,'Payment Id 91 for invoice:28/29, receipt: nhyujm by AA RANO NIGERIA LTD','2022-11-10 16:45:41','',''),('1','289',163,'','2','5',485270.00,0.00,'Payment Id 49 for invoice:29, receipt: 0581774 by AA RANO NIGERIA LTD','2022-11-10 16:45:41','',''),('1','289',164,'','supplier','1',0.00,485270.00,'Payment Id 49 for invoice:29, receipt: 0581774 by AA RANO NIGERIA LTD','2022-11-10 16:45:41','',''),('1','289',165,'','2','5',484620.00,0.00,'Payment Id 47 for invoice:28, receipt: 0581775 by AA RANO NIGERIA LTD','2022-11-10 16:45:41','',''),('1','289',166,'','supplier','1',0.00,484620.00,'Payment Id 47 for invoice:28, receipt: 0581775 by AA RANO NIGERIA LTD','2022-11-10 16:45:41','',''),('1','289',167,'','2','6',142680.00,0.00,'Payment Id 92 for invoice:30/31, receipt: zxjolmn by AA RANO NIGERIA LTD','2022-11-10 16:46:54','',''),('1','289',168,'','supplier','1',0.00,142680.00,'Payment Id 92 for invoice:30/31, receipt: zxjolmn by AA RANO NIGERIA LTD','2022-11-10 16:46:54','',''),('1','289',169,'','2','5',338280.00,0.00,'Payment Id 53 for invoice:31, receipt: 0581771 by AA RANO NIGERIA LTD','2022-11-10 16:46:54','',''),('1','289',170,'','supplier','1',0.00,338280.00,'Payment Id 53 for invoice:31, receipt: 0581771 by AA RANO NIGERIA LTD','2022-11-10 16:46:54','',''),('1','289',171,'','2','5',507540.00,0.00,'Payment Id 51 for invoice:30, receipt: 0581770 by AA RANO NIGERIA LTD','2022-11-10 16:46:54','',''),('1','289',172,'','supplier','1',0.00,507540.00,'Payment Id 51 for invoice:30, receipt: 0581770 by AA RANO NIGERIA LTD','2022-11-10 16:46:54','',''),('1','289',173,'','2','6',98891.00,0.00,'Payment Id 93 for invoice:32/33, receipt: tghnm by AA RANO NIGERIA LTD','2022-11-10 16:49:45','',''),('1','289',174,'','supplier','1',0.00,98891.00,'Payment Id 93 for invoice:32/33, receipt: tghnm by AA RANO NIGERIA LTD','2022-11-10 16:49:45','',''),('1','289',175,'','2','5',392980.00,0.00,'Payment Id 57 for invoice:33, receipt: 0581773 by AA RANO NIGERIA LTD','2022-11-10 16:49:45','',''),('1','289',176,'','supplier','1',0.00,392980.00,'Payment Id 57 for invoice:33, receipt: 0581773 by AA RANO NIGERIA LTD','2022-11-10 16:49:45','',''),('1','289',177,'','2','6',218516.00,0.00,'Payment Id 94 for invoice:35/36, receipt: tghjkjnb by AA RANO NIGERIA LTD','2022-11-10 16:52:08','',''),('1','289',178,'','supplier','1',0.00,218516.00,'Payment Id 94 for invoice:35/36, receipt: tghjkjnb by AA RANO NIGERIA LTD','2022-11-10 16:52:08','',''),('1','289',179,'','2','5',416175.00,0.00,'Payment Id 61 for invoice:36, receipt: 0282096 by AA RANO NIGERIA LTD','2022-11-10 16:52:08','',''),('1','289',180,'','supplier','1',0.00,416175.00,'Payment Id 61 for invoice:36, receipt: 0282096 by AA RANO NIGERIA LTD','2022-11-10 16:52:08','',''),('1','289',181,'','2','5',360150.00,0.00,'Payment Id 59 for invoice:35, receipt: 0282097 by AA RANO NIGERIA LTD','2022-11-10 16:52:08','',''),('1','289',182,'','supplier','1',0.00,360150.00,'Payment Id 59 for invoice:35, receipt: 0282097 by AA RANO NIGERIA LTD','2022-11-10 16:52:08','',''),('1','289',183,'','2','6',48944.00,0.00,'Payment Id 95 for invoice:37, receipt: yhjin by AA RANO NIGERIA LTD','2022-11-10 16:53:39','',''),('1','289',184,'','supplier','1',0.00,48944.00,'Payment Id 95 for invoice:37, receipt: yhjin by AA RANO NIGERIA LTD','2022-11-10 16:53:39','',''),('1','289',185,'','2','5',270100.00,0.00,'Payment Id 63 for invoice:37, receipt: 0282095 by AA RANO NIGERIA LTD','2022-11-10 16:53:39','',''),('1','289',186,'','supplier','1',0.00,270100.00,'Payment Id 63 for invoice:37, receipt: 0282095 by AA RANO NIGERIA LTD','2022-11-10 16:53:39','',''),('1','289',187,'','2','6',263495.00,0.00,'Payment Id 96 for invoice:38/39, receipt: tyjnfg by AA RANO NIGERIA LTD','2022-11-10 16:54:48','',''),('1','289',188,'','supplier','1',0.00,263495.00,'Payment Id 96 for invoice:38/39, receipt: tyjnfg by AA RANO NIGERIA LTD','2022-11-10 16:54:48','',''),('1','289',189,'','2','5',402505.00,0.00,'Payment Id 67 for invoice:39, receipt: 0282093 by AA RANO NIGERIA LTD','2022-11-10 16:54:48','',''),('1','289',190,'','supplier','1',0.00,402505.00,'Payment Id 67 for invoice:39, receipt: 0282093 by AA RANO NIGERIA LTD','2022-11-10 16:54:48','',''),('1','289',191,'','2','5',335870.00,0.00,'Payment Id 65 for invoice:38, receipt: 028,2094 by AA RANO NIGERIA LTD','2022-11-17 13:14:20','',''),('1','289',192,'','supplier','1',0.00,335870.00,'Payment Id 65 for invoice:38, receipt: 028,2094 by AA RANO NIGERIA LTD','2022-11-17 13:14:20','',''),('1','289',193,'','2','6',202100.00,0.00,'Payment Id 97 for invoice:40/41, receipt: poijnbvfdr by AA RANO NIGERIA LTD','2022-11-17 13:22:04','',''),('1','289',194,'','supplier','1',0.00,202100.00,'Payment Id 97 for invoice:40/41, receipt: poijnbvfdr by AA RANO NIGERIA LTD','2022-11-17 13:22:04','',''),('1','289',195,'','2','5',377450.00,0.00,'Payment Id 71 for invoice:41, receipt: 0581768 by AA RANO NIGERIA LTD','2022-11-17 13:22:04','',''),('1','289',196,'','supplier','1',0.00,377450.00,'Payment Id 71 for invoice:41, receipt: 0581768 by AA RANO NIGERIA LTD','2022-11-17 13:22:04','',''),('1','289',197,'','2','5',473630.00,0.00,'Payment Id 69 for invoice:40, receipt: 0581767 by AA RANO NIGERIA LTD','2022-11-17 13:22:04','',''),('1','289',198,'','supplier','1',0.00,473630.00,'Payment Id 69 for invoice:40, receipt: 0581767 by AA RANO NIGERIA LTD','2022-11-17 13:22:04','',''),('1','289',199,'','2','6',147500.00,0.00,'Payment Id 99 for invoice:43, receipt: ikjhyhbvgf by AA RANO NIGERIA LTD','2022-11-17 13:28:27','',''),('1','289',200,'','supplier','1',0.00,147500.00,'Payment Id 99 for invoice:43, receipt: ikjhyhbvgf by AA RANO NIGERIA LTD','2022-11-17 13:28:27','',''),('1','289',201,'','2','5',492940.00,0.00,'Payment Id 76 for invoice:43, receipt: 0581765 by AA RANO NIGERIA LTD','2022-11-17 13:28:27','',''),('1','289',202,'','supplier','1',0.00,492940.00,'Payment Id 76 for invoice:43, receipt: 0581765 by AA RANO NIGERIA LTD','2022-11-17 13:28:27','',''),('1','289',203,'','2','6',96914.00,0.00,'Payment Id 98 for invoice:42, receipt: erghjkfg by AA RANO NIGERIA LTD','2022-11-17 13:30:03','',''),('1','289',204,'','supplier','1',0.00,96914.00,'Payment Id 98 for invoice:42, receipt: erghjkfg by AA RANO NIGERIA LTD','2022-11-17 13:30:03','',''),('1','289',205,'','2','5',142880.00,0.00,'Payment Id 73 for invoice:42, receipt: 0282092 by AA RANO NIGERIA LTD','2022-11-17 13:30:03','',''),('1','289',206,'','supplier','1',0.00,142880.00,'Payment Id 73 for invoice:42, receipt: 0282092 by AA RANO NIGERIA LTD','2022-11-17 13:30:03','',''),('1','289',207,'','2','5',258040.00,0.00,'Payment Id 55 for invoice:32, receipt: 0581769 by AA RANO NIGERIA LTD','2022-11-17 13:34:11','',''),('1','289',208,'','supplier','1',0.00,258040.00,'Payment Id 55 for invoice:32, receipt: 0581769 by AA RANO NIGERIA LTD','2022-11-17 13:34:11','',''),('1','289',209,'','24','2',0.00,12600000.00,'Purchase Id 3 for 60,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-24 04:46:06','',''),('1','289',210,'','supplier','1',12600000.00,0.00,'Purchase Id 3 for 60,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-24 04:46:06','',''),('1','289',211,'','20','3',60652.80,0.00,'Sales from shift 44 on 2022-11-24 11:52:44 ','2022-11-24 11:52:44','',''),('1','289',212,'','6.1','4',0.00,60652.80,'Sales from shift 44 on 2022-11-24 11:52:44 ','2022-11-24 11:52:44','',''),('1','289',213,'','20','3',619609.20,0.00,'Sales from shift 45 on 2022-11-24 16:29:32 ','2022-11-24 16:29:32','',''),('1','289',214,'','6.1','4',0.00,619609.20,'Sales from shift 45 on 2022-11-24 16:29:32 ','2022-11-24 16:29:32','',''),('1','289',215,'','20','3',719090.40,0.00,'Sales from shift 46 on 2022-11-25 10:31:20 ','2022-11-25 10:31:20','',''),('1','289',216,'','6.1','4',0.00,719090.40,'Sales from shift 46 on 2022-11-25 10:31:20 ','2022-11-25 10:31:20','',''),('1','289',217,'','20','3',866218.50,0.00,'Sales from shift 47 on 2022-11-25 17:51:36 ','2022-11-25 17:51:36','',''),('1','289',218,'','6.1','4',0.00,866218.50,'Sales from shift 47 on 2022-11-25 17:51:36 ','2022-11-25 17:51:36','',''),('1','289',219,'','20','3',0.00,0.00,'Sales from shift 48 on 2022-11-26 10:24:50 ','2022-11-26 10:24:50','',''),('1','289',220,'','6.1','4',0.00,0.00,'Sales from shift 48 on 2022-11-26 10:24:50 ','2022-11-26 10:24:50','',''),('1','289',221,'','20','3',919522.80,0.00,'Sales from shift 49 on 2022-11-26 15:12:40 ','2022-11-26 15:12:40','',''),('1','289',222,'','6.1','4',0.00,919522.80,'Sales from shift 49 on 2022-11-26 15:12:40 ','2022-11-26 15:12:40','',''),('1','289',223,'','20','3',0.00,0.00,'Sales from shift 50 on 2022-11-27 14:56:27 ','2022-11-27 14:56:27','',''),('1','289',224,'','6.1','4',0.00,0.00,'Sales from shift 50 on 2022-11-27 14:56:27 ','2022-11-27 14:56:27','',''),('1','289',225,'','2','5',37650.00,0.00,'Payment Id 100 for invoice:44, receipt: 0581764 by AA RANO NIGERIA LTD','2022-11-29 15:29:59','',''),('1','289',226,'','supplier','1',0.00,37650.00,'Payment Id 100 for invoice:44, receipt: 0581764 by AA RANO NIGERIA LTD','2022-11-29 15:29:59','',''),('1','289',227,'','2','5',478170.00,0.00,'Payment Id 103 for invoice:46, receipt: 0581762 by AA RANO NIGERIA LTD','2022-11-29 15:34:54','',''),('1','289',228,'','supplier','1',0.00,478170.00,'Payment Id 103 for invoice:46, receipt: 0581762 by AA RANO NIGERIA LTD','2022-11-29 15:34:54','',''),('1','289',229,'','2','5',586110.00,0.00,'Payment Id 101 for invoice:45, receipt: 0581763 by AA RANO NIGERIA LTD','2022-11-29 15:34:54','',''),('1','289',230,'','supplier','1',0.00,586110.00,'Payment Id 101 for invoice:45, receipt: 0581763 by AA RANO NIGERIA LTD','2022-11-29 15:34:54','',''),('1','289',231,'','2','5',678675.00,0.00,'Payment Id 106 for invoice:49, receipt: 0581756 by AA RANO NIGERIA LTD','2022-11-29 16:03:40','',''),('1','289',232,'','supplier','1',0.00,678675.00,'Payment Id 106 for invoice:49, receipt: 0581756 by AA RANO NIGERIA LTD','2022-11-29 16:03:40','',''),('1','289',233,'','2','5',633520.00,0.00,'Payment Id 105 for invoice:47, receipt: 0581757 by AA RANO NIGERIA LTD','2022-11-29 16:03:40','',''),('1','289',234,'','supplier','1',0.00,633520.00,'Payment Id 105 for invoice:47, receipt: 0581757 by AA RANO NIGERIA LTD','2022-11-29 16:03:40','',''),('1','289',235,'','2','5',143400.00,0.00,'Payment Id 109 for invoice:17, receipt: 0581760 by AA RANO NIGERIA LTD','2022-11-29 16:05:25','',''),('1','289',236,'','supplier','1',0.00,143400.00,'Payment Id 109 for invoice:17, receipt: 0581760 by AA RANO NIGERIA LTD','2022-11-29 16:05:25','',''),('1','289',237,'','20','3',0.00,0.00,'Sales from shift 51 on 2022-11-30 08:56:19 ','2022-11-30 08:56:19','',''),('1','289',238,'','6.1','4',0.00,0.00,'Sales from shift 51 on 2022-11-30 08:56:19 ','2022-11-30 08:56:19','',''),('1','289',239,'','2','6',240850.00,0.00,'Payment Id 107 for invoice:49, receipt: LUHBNMK by AA RANO NIGERIA LTD','2022-11-30 17:08:45','',''),('1','289',240,'','supplier','1',0.00,240850.00,'Payment Id 107 for invoice:49, receipt: LUHBNMK by AA RANO NIGERIA LTD','2022-11-30 17:08:45','',''),('1','289',241,'','2','6',240920.00,0.00,'Payment Id 104 for invoice:46, receipt: ASDFGHJKMN by AA RANO NIGERIA LTD','2022-11-30 17:08:45','',''),('1','289',242,'','supplier','1',0.00,240920.00,'Payment Id 104 for invoice:46, receipt: ASDFGHJKMN by AA RANO NIGERIA LTD','2022-11-30 17:08:45','',''),('1','289',243,'','2','6',33000.00,0.00,'Payment Id 102 for invoice:44, receipt: DFGHJKLKJN by AA RANO NIGERIA LTD','2022-11-30 17:08:45','',''),('1','289',244,'','supplier','1',0.00,33000.00,'Payment Id 102 for invoice:44, receipt: DFGHJKLKJN by AA RANO NIGERIA LTD','2022-11-30 17:08:45','',''),('1','289',245,'','20','3',1280892.90,0.00,'Sales from shift 52 on 2022-11-30 17:39:05 ','2022-11-30 17:39:05','',''),('1','289',246,'','6.1','4',0.00,1280892.90,'Sales from shift 52 on 2022-11-30 17:39:05 ','2022-11-30 17:39:05','',''),('1','289',247,'','20','3',42869.40,0.00,'Sales from shift 53 on 2022-12-01 07:49:21 ','2022-12-01 07:49:21','',''),('1','289',248,'','6.1','4',0.00,42869.40,'Sales from shift 53 on 2022-12-01 07:49:21 ','2022-12-01 07:49:21','',''),('1','289',249,'','2','6',432491.00,0.00,'Payment Id 114 for invoice:55, receipt: KYTRFCVBNJK by AA RANO NIGERIA LTD','2022-12-01 10:28:59','',''),('1','289',250,'','supplier','1',0.00,432491.00,'Payment Id 114 for invoice:55, receipt: KYTRFCVBNJK by AA RANO NIGERIA LTD','2022-12-01 10:28:59','',''),('1','289',251,'','2','6',400378.00,0.00,'Payment Id 111 for invoice:53, receipt: FTYUJBVC by AA RANO NIGERIA LTD','2022-12-01 10:28:59','',''),('1','289',252,'','supplier','1',0.00,400378.00,'Payment Id 111 for invoice:53, receipt: FTYUJBVC by AA RANO NIGERIA LTD','2022-12-01 10:28:59','',''),('1','289',253,'','20','3',1106198.10,0.00,'Sales from shift 54 on 2022-12-01 14:55:39 ','2022-12-01 14:55:39','',''),('1','289',254,'','6.1','4',0.00,1106198.10,'Sales from shift 54 on 2022-12-01 14:55:39 ','2022-12-01 14:55:39','',''),('1','289',255,'','20','3',1035499.50,0.00,'Sales from shift 55 on 2022-12-01 15:12:29 ','2022-12-01 15:12:29','',''),('1','289',256,'','6.1','4',0.00,1035499.50,'Sales from shift 55 on 2022-12-01 15:12:29 ','2022-12-01 15:12:29','',''),('1','289',257,'','20','3',1152087.30,0.00,'Sales from shift 56 on 2022-12-01 15:23:44 ','2022-12-01 15:23:44','',''),('1','289',258,'','6.1','4',0.00,1152087.30,'Sales from shift 56 on 2022-12-01 15:23:44 ','2022-12-01 15:23:44','',''),('1','289',259,'','20','3',1104805.80,0.00,'Sales from shift 57 on 2022-12-01 15:32:56 ','2022-12-01 15:32:56','',''),('1','289',260,'','6.1','4',0.00,1104805.80,'Sales from shift 57 on 2022-12-01 15:32:56 ','2022-12-01 15:32:56','',''),('1','289',261,'','20','3',872634.00,0.00,'Sales from shift 58 on 2022-12-01 16:27:29 ','2022-12-01 16:27:29','',''),('1','289',262,'','6.1','4',0.00,872634.00,'Sales from shift 58 on 2022-12-01 16:27:29 ','2022-12-01 16:27:29','',''),('1','289',263,'','20','3',1150491.30,0.00,'Sales from shift 59 on 2022-12-01 16:36:48 ','2022-12-01 16:36:48','',''),('1','289',264,'','6.1','4',0.00,1150491.30,'Sales from shift 59 on 2022-12-01 16:36:48 ','2022-12-01 16:36:48','',''),('1','289',265,'','20','3',1068274.20,0.00,'Sales from shift 60 on 2022-12-02 10:25:51 ','2022-12-02 10:25:51','',''),('1','289',266,'','6.1','4',0.00,1068274.20,'Sales from shift 60 on 2022-12-02 10:25:51 ','2022-12-02 10:25:51','',''),('1','289',267,'','20','3',408655.80,0.00,'Sales from shift 61 on 2022-12-02 12:19:57 ','2022-12-02 12:19:57','',''),('1','289',268,'','6.1','4',0.00,408655.80,'Sales from shift 61 on 2022-12-02 12:19:57 ','2022-12-02 12:19:57','',''),('1','289',269,'','2','5',705820.00,0.00,'Payment Id 110 for invoice:52, receipt: 0282088 by AA RANO NIGERIA LTD','2022-12-02 12:52:35','',''),('1','289',270,'','supplier','1',0.00,705820.00,'Payment Id 110 for invoice:52, receipt: 0282088 by AA RANO NIGERIA LTD','2022-12-02 12:52:35','',''),('1','289',271,'','2','5',1317030.00,0.00,'Payment Id 108 for invoice:50, receipt: 0282090 by AA RANO NIGERIA LTD','2022-12-02 12:52:35','',''),('1','289',272,'','supplier','1',0.00,1317030.00,'Payment Id 108 for invoice:50, receipt: 0282090 by AA RANO NIGERIA LTD','2022-12-02 12:52:35','',''),('1','289',273,'','2','5',719600.00,0.00,'Payment Id 113 for invoice:55, receipt: 0282087 by AA RANO NIGERIA LTD','2022-12-02 12:55:28','',''),('1','289',274,'','supplier','1',0.00,719600.00,'Payment Id 113 for invoice:55, receipt: 0282087 by AA RANO NIGERIA LTD','2022-12-02 12:55:28','',''),('1','289',275,'','2','5',1035500.00,0.00,'Payment Id 112 for invoice:54, receipt: 0282086 by AA RANO NIGERIA LTD','2022-12-02 12:55:28','',''),('1','289',276,'','supplier','1',0.00,1035500.00,'Payment Id 112 for invoice:54, receipt: 0282086 by AA RANO NIGERIA LTD','2022-12-02 12:55:28','',''),('1','289',277,'','2','6',395875.00,0.00,'Payment Id 117 for invoice:57, receipt: JGBNJK by AA RANO NIGERIA LTD','2022-12-02 12:57:33','',''),('1','289',278,'','supplier','1',0.00,395875.00,'Payment Id 117 for invoice:57, receipt: JGBNJK by AA RANO NIGERIA LTD','2022-12-02 12:57:33','',''),('1','289',279,'','2','5',475260.00,0.00,'Payment Id 116 for invoice:56, receipt: 0320373 by AA RANO NIGERIA LTD','2022-12-02 12:57:33','',''),('1','289',280,'','supplier','1',0.00,475260.00,'Payment Id 116 for invoice:56, receipt: 0320373 by AA RANO NIGERIA LTD','2022-12-02 12:57:33','',''),('1','289',281,'','2','5',1104805.00,0.00,'Payment Id 115 for invoice:56, receipt: 0320372 by AA RANO NIGERIA LTD','2022-12-02 12:57:33','',''),('1','289',282,'','supplier','1',0.00,1104805.00,'Payment Id 115 for invoice:56, receipt: 0320372 by AA RANO NIGERIA LTD','2022-12-02 12:57:33','',''),('1','289',283,'','6.1','4',27000.00,0.00,'Payment Id 119 for invoice:45, receipt: EMPRESS by AA RANO NIGERIA LTD','2022-12-02 15:05:31','',''),('1','289',284,'','supplier','1',0.00,27000.00,'Payment Id 119 for invoice:45, receipt: EMPRESS by AA RANO NIGERIA LTD','2022-12-02 15:05:31','',''),('1','289',285,'','2','5',188000.00,0.00,'Payment Id 125 for invoice:61, receipt: 0282100 by AA RANO NIGERIA LTD','2022-12-06 12:23:02','',''),('1','289',286,'','supplier','1',0.00,188000.00,'Payment Id 125 for invoice:61, receipt: 0282100 by AA RANO NIGERIA LTD','2022-12-06 12:23:02','',''),('1','289',287,'','2','6',23000.00,0.00,'Payment Id 124 for invoice:61, receipt: JHGERT by AA RANO NIGERIA LTD','2022-12-06 12:23:02','',''),('1','289',288,'','supplier','1',0.00,23000.00,'Payment Id 124 for invoice:61, receipt: JHGERT by AA RANO NIGERIA LTD','2022-12-06 12:23:02','',''),('1','289',289,'','2','5',196155.00,0.00,'Payment Id 122 for invoice:61, receipt: 0633173 by AA RANO NIGERIA LTD','2022-12-06 12:23:02','',''),('1','289',290,'','supplier','1',0.00,196155.00,'Payment Id 122 for invoice:61, receipt: 0633173 by AA RANO NIGERIA LTD','2022-12-06 12:23:02','',''),('1','289',291,'','2','5',1150880.00,0.00,'Payment Id 118 for invoice:59, receipt: 2022112 by AA RANO NIGERIA LTD','2022-12-06 12:25:10','',''),('1','289',292,'','supplier','1',0.00,1150880.00,'Payment Id 118 for invoice:59, receipt: 2022112 by AA RANO NIGERIA LTD','2022-12-06 12:25:10','',''),('1','289',293,'','2','6',466863.70,0.00,'Payment Id 123 for invoice:59/60, receipt: ERTYUIKJNB by AA RANO NIGERIA LTD','2022-12-06 12:34:19','',''),('1','289',294,'','supplier','1',0.00,466863.70,'Payment Id 123 for invoice:59/60, receipt: ERTYUIKJNB by AA RANO NIGERIA LTD','2022-12-06 12:34:19','',''),('1','289',295,'','2','5',589520.00,0.00,'Payment Id 121 for invoice:60, receipt: 0633174 by AA RANO NIGERIA LTD','2022-12-06 12:34:19','',''),('1','289',296,'','supplier','1',0.00,589520.00,'Payment Id 121 for invoice:60, receipt: 0633174 by AA RANO NIGERIA LTD','2022-12-06 12:34:19','',''),('1','289',297,'','2','5',50000.00,0.00,'Payment Id 75 for invoice:42, receipt: 0581783 by AA RANO NIGERIA LTD','2022-12-06 12:34:32','',''),('1','289',298,'','supplier','1',0.00,50000.00,'Payment Id 75 for invoice:42, receipt: 0581783 by AA RANO NIGERIA LTD','2022-12-06 12:34:32','',''),('1','289',299,'','20','3',454803.30,0.00,'Sales from shift 62 on 2022-12-09 17:43:04 ','2022-12-09 17:43:04','',''),('1','289',300,'','6.1','4',0.00,454803.30,'Sales from shift 62 on 2022-12-09 17:43:04 ','2022-12-09 17:43:04','',''),('1','289',301,'','6.1','4',52800.00,0.00,'Payment Id 127 for invoice:62, receipt: SDFGHJKJHG by AA RANO NIGERIA LTD','2022-12-15 10:38:16','',''),('1','289',302,'','supplier','1',0.00,52800.00,'Payment Id 127 for invoice:62, receipt: SDFGHJKJHG by AA RANO NIGERIA LTD','2022-12-15 10:38:16','',''),('1','289',303,'','2','5',175000.00,0.00,'Payment Id 126 for invoice:62, receipt: 0581789 by AA RANO NIGERIA LTD','2022-12-15 10:38:16','',''),('1','289',304,'','supplier','1',0.00,175000.00,'Payment Id 126 for invoice:62, receipt: 0581789 by AA RANO NIGERIA LTD','2022-12-15 10:38:16','',''),('1','289',305,'','2','5',158100.00,0.00,'Payment Id 128 for invoice:62, receipt: 0849351 by AA RANO NIGERIA LTD','2022-12-28 14:54:21','',''),('1','289',306,'','supplier','1',0.00,158100.00,'Payment Id 128 for invoice:62, receipt: 0849351 by AA RANO NIGERIA LTD','2022-12-28 14:54:21','',''),('1','289',307,'','24','2',0.00,23700000.00,'Purchase Id 4 for 30,000.00 litters of Diesel - AGO from AA RANO NIGERIA LTD','2023-02-11 10:14:08','',''),('1','289',308,'','supplier','1',23700000.00,0.00,'Purchase Id 4 for 30,000.00 litters of Diesel - AGO from AA RANO NIGERIA LTD','2023-02-11 10:14:08','',''),('1','289',309,'','6.1','4',71100.00,0.00,'Payment Id 132 for invoice:00, receipt: SDFGH by AA RANO NIGERIA LTD','2023-02-15 16:49:49','',''),('1','289',310,'','supplier','1',0.00,71100.00,'Payment Id 132 for invoice:00, receipt: SDFGH by AA RANO NIGERIA LTD','2023-02-15 16:49:49','',''),('1','289',311,'','6.1','4',173000.00,0.00,'Payment Id 131 for invoice:00, receipt: WWWERT by AA RANO NIGERIA LTD','2023-02-15 16:49:49','',''),('1','289',312,'','supplier','1',0.00,173000.00,'Payment Id 131 for invoice:00, receipt: WWWERT by AA RANO NIGERIA LTD','2023-02-15 16:49:49','',''),('1','289',313,'','6.1','4',212500.00,0.00,'Payment Id 130 for invoice:00, receipt: WAERFT by AA RANO NIGERIA LTD','2023-02-15 16:49:49','',''),('1','289',314,'','supplier','1',0.00,212500.00,'Payment Id 130 for invoice:00, receipt: WAERFT by AA RANO NIGERIA LTD','2023-02-15 16:49:49','',''),('1','289',315,'','20','3',987563.20,0.00,'Sales from shift 63 on 2023-02-16 09:19:06 ','2023-02-16 09:19:06','',''),('1','289',316,'','6.1','4',0.00,987563.20,'Sales from shift 63 on 2023-02-16 09:19:06 ','2023-02-16 09:19:06','',''),('1','289',317,'','2','6',238500.00,0.00,'Payment Id 129 for invoice:00, receipt: 34ESDRTFGVYBHUNJKM by AA RANO NIGERIA LTD','2023-02-16 15:39:39','',''),('1','289',318,'','supplier','1',0.00,238500.00,'Payment Id 129 for invoice:00, receipt: 34ESDRTFGVYBHUNJKM by AA RANO NIGERIA LTD','2023-02-16 15:39:39','',''),('1','289',319,'','2','6',105500.00,0.00,'Payment Id 139 for invoice:00, receipt: LKJHJGFGTD by AA RANO NIGERIA LTD','2023-02-16 15:39:52','',''),('1','289',320,'','supplier','1',0.00,105500.00,'Payment Id 139 for invoice:00, receipt: LKJHJGFGTD by AA RANO NIGERIA LTD','2023-02-16 15:39:52','',''),('1','289',321,'','2','6',591810.00,0.00,'Payment Id 135 for invoice:00, receipt: DFGHJN by AA RANO NIGERIA LTD','2023-02-16 15:40:16','',''),('1','289',322,'','supplier','1',0.00,591810.00,'Payment Id 135 for invoice:00, receipt: DFGHJN by AA RANO NIGERIA LTD','2023-02-16 15:40:16','',''),('1','289',323,'','20','3',1059026.60,0.00,'Sales from shift 64 on 2023-02-16 18:35:19 ','2023-02-16 18:35:19','',''),('1','289',324,'','6.1','4',0.00,1059026.60,'Sales from shift 64 on 2023-02-16 18:35:19 ','2023-02-16 18:35:19','',''),('1','289',325,'','20','3',2158532.80,0.00,'Sales from shift 65 on 2023-02-19 22:57:04 ','2023-02-19 22:57:04','',''),('1','289',326,'','6.1','4',0.00,2158532.80,'Sales from shift 65 on 2023-02-19 22:57:04 ','2023-02-19 22:57:04','',''),('1','289',327,'','20','3',19947.50,0.00,'Sales from shift 66 on 2023-02-20 22:51:26 ','2023-02-20 22:51:26','',''),('1','289',328,'','6.1','4',0.00,19947.50,'Sales from shift 66 on 2023-02-20 22:51:26 ','2023-02-20 22:51:26','',''),('1','289',329,'','20','3',590272.20,0.00,'Sales from shift 67 on 2023-02-21 11:42:31 ','2023-02-21 11:42:31','',''),('1','289',330,'','6.1','4',0.00,590272.20,'Sales from shift 67 on 2023-02-21 11:42:31 ','2023-02-21 11:42:31','',''),('1','289',331,'','2','6',19875.00,0.00,'Payment Id 140 for invoice:00, receipt: .KJHGF by AA RANO NIGERIA LTD','2023-02-21 14:51:51','',''),('1','289',332,'','supplier','1',0.00,19875.00,'Payment Id 140 for invoice:00, receipt: .KJHGF by AA RANO NIGERIA LTD','2023-02-21 14:51:51','',''),('1','289',333,'','6.1','4',27000.00,0.00,'Payment Id 137 for invoice:00, receipt: KJHGFV by AA RANO NIGERIA LTD','2023-02-21 14:52:04','',''),('1','289',334,'','supplier','1',0.00,27000.00,'Payment Id 137 for invoice:00, receipt: KJHGFV by AA RANO NIGERIA LTD','2023-02-21 14:52:04','',''),('1','289',335,'','20','3',326499.10,0.00,'Sales from shift 68 on 2023-02-26 13:18:07 ','2023-02-26 13:18:07','',''),('1','289',336,'','6.1','4',0.00,326499.10,'Sales from shift 68 on 2023-02-26 13:18:07 ','2023-02-26 13:18:07','',''),('1','289',337,'','20','3',400000.70,0.00,'Sales from shift 69 on 2023-03-01 07:42:01 ','2023-03-01 07:42:01','',''),('1','289',338,'','6.1','4',0.00,400000.70,'Sales from shift 69 on 2023-03-01 07:42:01 ','2023-03-01 07:42:01','',''),('1','289',339,'','2','5',2053030.00,0.00,'Payment Id 138 for invoice:00, receipt: 1014717 by AA RANO NIGERIA LTD','2023-03-01 17:12:46','',''),('1','289',340,'','supplier','1',0.00,2053030.00,'Payment Id 138 for invoice:00, receipt: 1014717 by AA RANO NIGERIA LTD','2023-03-01 17:12:46','',''),('1','289',341,'','2','5',416720.00,0.00,'Payment Id 134 for invoice:00, receipt: 10147172 by AA RANO NIGERIA LTD','2023-03-01 17:13:16','',''),('1','289',342,'','supplier','1',0.00,416720.00,'Payment Id 134 for invoice:00, receipt: 10147172 by AA RANO NIGERIA LTD','2023-03-01 17:13:16','',''),('1','289',343,'','2','5',292500.00,0.00,'Payment Id 133 for invoice:00, receipt: 101471726 by AA RANO NIGERIA LTD','2023-03-01 17:13:16','',''),('1','289',344,'','supplier','1',0.00,292500.00,'Payment Id 133 for invoice:00, receipt: 101471726 by AA RANO NIGERIA LTD','2023-03-01 17:13:16','',''),('1','289',345,'','6.1','4',171100.00,0.00,'Payment Id 143 for invoice:67, receipt: Fuiihh by AA RANO NIGERIA LTD','2023-03-01 17:15:06','',''),('1','289',346,'','supplier','1',0.00,171100.00,'Payment Id 143 for invoice:67, receipt: Fuiihh by AA RANO NIGERIA LTD','2023-03-01 17:15:06','',''),('1','289',347,'','20','3',552044.10,0.00,'Sales from shift 70 on 2023-03-02 10:07:05 ','2023-03-02 10:07:05','',''),('1','289',348,'','6.1','4',0.00,552044.10,'Sales from shift 70 on 2023-03-02 10:07:05 ','2023-03-02 10:07:05','',''),('1','289',349,'','20','3',634030.30,0.00,'Sales from shift 71 on 2023-03-02 12:52:47 ','2023-03-02 12:52:47','',''),('1','289',350,'','6.1','4',0.00,634030.30,'Sales from shift 71 on 2023-03-02 12:52:47 ','2023-03-02 12:52:47','',''),('1','289',351,'','2','6',400000.00,0.00,'Payment Id 145 for invoice:69, receipt: FGHJKOI by AA RANO NIGERIA LTD','2023-03-02 14:01:27','',''),('1','289',352,'','supplier','1',0.00,400000.00,'Payment Id 145 for invoice:69, receipt: FGHJKOI by AA RANO NIGERIA LTD','2023-03-02 14:01:27','',''),('1','289',353,'','2','6',326500.00,0.00,'Payment Id 144 for invoice:68, receipt: WARTYUI by AA RANO NIGERIA LTD','2023-03-02 14:01:27','',''),('1','289',354,'','supplier','1',0.00,326500.00,'Payment Id 144 for invoice:68, receipt: WARTYUI by AA RANO NIGERIA LTD','2023-03-02 14:01:27','',''),('1','289',355,'','2','6',178875.00,0.00,'Payment Id 142 for invoice:67, receipt: Lbggv by AA RANO NIGERIA LTD','2023-03-02 14:01:27','',''),('1','289',356,'','supplier','1',0.00,178875.00,'Payment Id 142 for invoice:67, receipt: Lbggv by AA RANO NIGERIA LTD','2023-03-02 14:01:27','',''),('1','289',357,'','20','3',1060575.00,0.00,'Sales from shift 72 on 2023-03-03 09:59:58 ','2023-03-03 09:59:58','',''),('1','289',358,'','6.1','4',0.00,1060575.00,'Sales from shift 72 on 2023-03-03 09:59:58 ','2023-03-03 09:59:58','',''),('1','289',359,'','2','6',624030.00,0.00,'Payment Id 150 for invoice:71, receipt: 101471JIHUGCYGU by AA RANO NIGERIA LTD','2023-03-03 10:23:11','',''),('1','289',360,'','supplier','1',0.00,624030.00,'Payment Id 150 for invoice:71, receipt: 101471JIHUGCYGU by AA RANO NIGERIA LTD','2023-03-03 10:23:11','',''),('1','289',361,'','2','5',10000.00,0.00,'Payment Id 149 for invoice:71, receipt: 2033256 by AA RANO NIGERIA LTD','2023-03-03 10:23:11','',''),('1','289',362,'','supplier','1',0.00,10000.00,'Payment Id 149 for invoice:71, receipt: 2033256 by AA RANO NIGERIA LTD','2023-03-03 10:23:11','',''),('1','289',363,'','2','6',444000.00,0.00,'Payment Id 148 for invoice:70, receipt: 2033XOYF,./ by AA RANO NIGERIA LTD','2023-03-03 10:23:12','',''),('1','289',364,'','supplier','1',0.00,444000.00,'Payment Id 148 for invoice:70, receipt: 2033XOYF,./ by AA RANO NIGERIA LTD','2023-03-03 10:23:12','',''),('1','289',365,'','2','6',1061000.00,0.00,'Payment Id 146 for invoice:72, receipt: FGHJKLKJHGVBNHJ by AA RANO NIGERIA LTD','2023-03-03 10:23:12','',''),('1','289',366,'','supplier','1',0.00,1061000.00,'Payment Id 146 for invoice:72, receipt: FGHJKLKJHGVBNHJ by AA RANO NIGERIA LTD','2023-03-03 10:23:12','',''),('1','289',367,'','20','3',15468397.50,0.00,'Sales from shift 73 on 2023-03-04 06:40:53 ','2023-03-04 06:40:53','',''),('1','289',368,'','6.1','4',0.00,15468397.50,'Sales from shift 73 on 2023-03-04 06:40:53 ','2023-03-04 06:40:53','',''),('1','289',369,'','2','5',340300.00,0.00,'Payment Id 141 for invoice:67, receipt: 0973468 by AA RANO NIGERIA LTD','2023-03-04 13:25:21','',''),('1','289',370,'','supplier','1',0.00,340300.00,'Payment Id 141 for invoice:67, receipt: 0973468 by AA RANO NIGERIA LTD','2023-03-04 13:25:21','',''),('1','289',371,'','2','5',108050.00,0.00,'Payment Id 147 for invoice:70, receipt: 1014717262 by AA RANO NIGERIA LTD','2023-03-04 13:25:30','',''),('1','289',372,'','supplier','1',0.00,108050.00,'Payment Id 147 for invoice:70, receipt: 1014717262 by AA RANO NIGERIA LTD','2023-03-04 13:25:30','',''),('1','289',373,'','6.1','4',165900.00,0.00,'Payment Id 154 for invoice:73, receipt: DFGHJ by AA RANO NIGERIA LTD','2023-03-04 13:27:04','',''),('1','289',374,'','supplier','1',0.00,165900.00,'Payment Id 154 for invoice:73, receipt: DFGHJ by AA RANO NIGERIA LTD','2023-03-04 13:27:04','',''),('1','289',375,'','6.1','4',212500.00,0.00,'Payment Id 153 for invoice:73, receipt: HJK,MJH by AA RANO NIGERIA LTD','2023-03-04 13:27:04','',''),('1','289',376,'','supplier','1',0.00,212500.00,'Payment Id 153 for invoice:73, receipt: HJK,MJH by AA RANO NIGERIA LTD','2023-03-04 13:27:04','',''),('1','289',377,'','24','2',0.00,11750000.00,'Purchase Id 5 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-05 07:43:56','',''),('1','289',378,'','supplier','1',11750000.00,0.00,'Purchase Id 5 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-05 07:43:56','',''),('1','289',379,'','24','2',0.00,36000000.00,'Purchase Id 6 for 45,000.00 litters of Diesel - AGO from AA RANO NIGERIA LTD','2023-03-07 11:34:54','',''),('1','289',380,'','supplier','1',36000000.00,0.00,'Purchase Id 6 for 45,000.00 litters of Diesel - AGO from AA RANO NIGERIA LTD','2023-03-07 11:34:54','',''),('1','289',381,'','20','3',811259.95,0.00,'Sales from shift 74 on 2023-03-07 15:02:28 ','2023-03-07 15:02:28','',''),('1','289',382,'','6.1','4',0.00,811259.95,'Sales from shift 74 on 2023-03-07 15:02:28 ','2023-03-07 15:02:28','',''),('1','289',383,'','6.1','4',7980000.00,0.00,'Payment Id 151 for invoice:73, receipt: EFCC by AA RANO NIGERIA LTD','2023-03-07 16:57:30','',''),('1','289',384,'','supplier','1',0.00,7980000.00,'Payment Id 151 for invoice:73, receipt: EFCC by AA RANO NIGERIA LTD','2023-03-07 16:57:30','',''),('1','289',385,'','20','3',830891.85,0.00,'Sales from shift 75 on 2023-03-08 09:49:21 ','2023-03-08 09:49:21','',''),('1','289',386,'','6.1','4',0.00,830891.85,'Sales from shift 75 on 2023-03-08 09:49:21 ','2023-03-08 09:49:21','',''),('1','289',387,'','20','3',1269183.30,0.00,'Sales from shift 76 on 2023-03-08 15:37:46 ','2023-03-08 15:37:46','',''),('1','289',388,'','6.1','4',0.00,1269183.30,'Sales from shift 76 on 2023-03-08 15:37:46 ','2023-03-08 15:37:46','',''),('1','289',389,'','20','3',1798490.25,0.00,'Sales from shift 77 on 2023-03-08 16:00:23 ','2023-03-08 16:00:23','',''),('1','289',390,'','6.1','4',0.00,1798490.25,'Sales from shift 77 on 2023-03-08 16:00:23 ','2023-03-08 16:00:23','',''),('1','289',391,'','20','3',2086980.95,0.00,'Sales from shift 78 on 2023-03-08 16:22:53 ','2023-03-08 16:22:53','',''),('1','289',392,'','6.1','4',0.00,2086980.95,'Sales from shift 78 on 2023-03-08 16:22:53 ','2023-03-08 16:22:53','',''),('1','289',393,'','20','3',678400.00,0.00,'Sales from shift 79 on 2023-03-08 16:59:47 ','2023-03-08 16:59:47','',''),('1','289',394,'','6.1','4',0.00,678400.00,'Sales from shift 79 on 2023-03-08 16:59:47 ','2023-03-08 16:59:47','',''),('1','289',395,'','20','3',2479856.30,0.00,'Sales from shift 80 on 2023-03-09 10:22:54 ','2023-03-09 10:22:54','',''),('1','289',396,'','6.1','4',0.00,2479856.30,'Sales from shift 80 on 2023-03-09 10:22:54 ','2023-03-09 10:22:54','',''),('1','289',397,'','24','2',0.00,9870000.00,'Purchase Id 7 for 42,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-09 13:51:41','',''),('1','289',398,'','supplier','1',9870000.00,0.00,'Purchase Id 7 for 42,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-09 13:51:41','',''),('1','289',399,'','24','2',0.00,11750000.00,'Purchase Id 8 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-09 13:52:09','',''),('1','289',400,'','supplier','1',11750000.00,0.00,'Purchase Id 8 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-09 13:52:09','',''),('1','289',401,'','24','2',0.00,14100000.00,'Purchase Id 9 for 60,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-09 13:52:57','',''),('1','289',402,'','supplier','1',14100000.00,0.00,'Purchase Id 9 for 60,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-09 13:52:57','',''),('1','289',403,'','20','3',2132096.00,0.00,'Sales from shift 81 on 2023-03-09 16:16:57 ','2023-03-09 16:16:57','',''),('1','289',404,'','6.1','4',0.00,2132096.00,'Sales from shift 81 on 2023-03-09 16:16:57 ','2023-03-09 16:16:57','',''),('1','289',405,'','20','3',3290699.20,0.00,'Sales from shift 82 on 2023-03-10 09:28:22 ','2023-03-10 09:28:22','',''),('1','289',406,'','6.1','4',0.00,3290699.20,'Sales from shift 82 on 2023-03-10 09:28:22 ','2023-03-10 09:28:22','',''),('1','289',407,'','6.1','4',375000.00,0.00,'Payment Id 170 for invoice:81, receipt: ,NBV  by AA RANO NIGERIA LTD','2023-03-10 10:51:57','',''),('1','289',408,'','supplier','1',0.00,375000.00,'Payment Id 170 for invoice:81, receipt: ,NBV  by AA RANO NIGERIA LTD','2023-03-10 10:51:57','',''),('1','289',409,'','2','5',439560.00,0.00,'Payment Id 156 for invoice:75, receipt: UYTRDCVBNM by AA RANO NIGERIA LTD','2023-03-10 10:53:30','',''),('1','289',410,'','supplier','1',0.00,439560.00,'Payment Id 156 for invoice:75, receipt: UYTRDCVBNM by AA RANO NIGERIA LTD','2023-03-10 10:53:30','',''),('1','289',411,'','2','5',314650.00,0.00,'Payment Id 158 for invoice:76, receipt: kjbvbn by AA RANO NIGERIA LTD','2023-03-10 10:54:32','',''),('1','289',412,'','supplier','1',0.00,314650.00,'Payment Id 158 for invoice:76, receipt: kjbvbn by AA RANO NIGERIA LTD','2023-03-10 10:54:32','',''),('1','289',413,'','2','5',18000.00,0.00,'Payment Id 160 for invoice:77, receipt: DYHH by AA RANO NIGERIA LTD','2023-03-10 10:54:54','',''),('1','289',414,'','supplier','1',0.00,18000.00,'Payment Id 160 for invoice:77, receipt: DYHH by AA RANO NIGERIA LTD','2023-03-10 10:54:54','',''),('1','289',415,'','2','5',18000.00,0.00,'Payment Id 166 for invoice:79, receipt: KJHGVC by AA RANO NIGERIA LTD','2023-03-10 10:55:33','',''),('1','289',416,'','supplier','1',0.00,18000.00,'Payment Id 166 for invoice:79, receipt: KJHGVC by AA RANO NIGERIA LTD','2023-03-10 10:55:33','',''),('1','289',417,'','6.1','4',660000.00,0.00,'Payment Id 165 for invoice:79, receipt: KJHGFDFGH by AA RANO NIGERIA LTD','2023-03-10 10:55:33','',''),('1','289',418,'','supplier','1',0.00,660000.00,'Payment Id 165 for invoice:79, receipt: KJHGFDFGH by AA RANO NIGERIA LTD','2023-03-10 10:55:33','',''),('1','289',419,'','2','5',1495755.00,0.00,'Payment Id 163 for invoice:78, receipt: DFGHJGV by AA RANO NIGERIA LTD','2023-03-10 10:55:33','',''),('1','289',420,'','supplier','1',0.00,1495755.00,'Payment Id 163 for invoice:78, receipt: DFGHJGV by AA RANO NIGERIA LTD','2023-03-10 10:55:33','',''),('1','289',421,'','6.1','4',335000.00,0.00,'Payment Id 176 for invoice:82, receipt:  CFTYHN  by AA RANO NIGERIA LTD','2023-03-10 10:56:31','',''),('1','289',422,'','supplier','1',0.00,335000.00,'Payment Id 176 for invoice:82, receipt:  CFTYHN  by AA RANO NIGERIA LTD','2023-03-10 10:56:31','',''),('1','289',423,'','6.1','4',335000.00,0.00,'Payment Id 175 for invoice:82, receipt: GTGVJ by AA RANO NIGERIA LTD','2023-03-10 10:56:31','',''),('1','289',424,'','supplier','1',0.00,335000.00,'Payment Id 175 for invoice:82, receipt: GTGVJ by AA RANO NIGERIA LTD','2023-03-10 10:56:31','',''),('1','289',425,'','20','3',0.00,0.00,'Sales from shift 83 on 2023-03-10 13:19:19 ','2023-03-10 13:19:19','',''),('1','289',426,'','6.1','4',0.00,0.00,'Sales from shift 83 on 2023-03-10 13:19:19 ','2023-03-10 13:19:19','',''),('1','289',427,'','20','3',3071676.05,0.00,'Sales from shift 84 on 2023-03-10 15:44:08 ','2023-03-10 15:44:08','',''),('1','289',428,'','6.1','4',0.00,3071676.05,'Sales from shift 84 on 2023-03-10 15:44:08 ','2023-03-10 15:44:08','',''),('1','289',429,'','20','3',5152549.55,0.00,'Sales from shift 85 on 2023-03-11 17:05:53 ','2023-03-11 17:05:53','',''),('1','289',430,'','6.1','4',0.00,5152549.55,'Sales from shift 85 on 2023-03-11 17:05:53 ','2023-03-11 17:05:53','',''),('1','289',431,'','2','6',1191083.00,0.00,'Payment Id 157 for invoice:74/75, receipt: ASDFGHJJHGF by AA RANO NIGERIA LTD','2023-03-11 17:11:55','',''),('1','289',432,'','supplier','1',0.00,1191083.00,'Payment Id 157 for invoice:74/75, receipt: ASDFGHJJHGF by AA RANO NIGERIA LTD','2023-03-11 17:11:55','',''),('1','289',433,'','2','6',954532.00,0.00,'Payment Id 159 for invoice:76, receipt: .kjhb by AA RANO NIGERIA LTD','2023-03-11 17:12:13','',''),('1','289',434,'','supplier','1',0.00,954532.00,'Payment Id 159 for invoice:76, receipt: .kjhb by AA RANO NIGERIA LTD','2023-03-11 17:12:13','',''),('1','289',435,'','2','6',1415989.25,0.00,'Payment Id 161 for invoice:77, receipt: ZSRJHG by AA RANO NIGERIA LTD','2023-03-11 17:12:40','',''),('1','289',436,'','supplier','1',0.00,1415989.25,'Payment Id 161 for invoice:77, receipt: ZSRJHG by AA RANO NIGERIA LTD','2023-03-11 17:12:40','',''),('1','289',437,'','2','6',591228.00,0.00,'Payment Id 164 for invoice:78, receipt: NFGBNM by AA RANO NIGERIA LTD','2023-03-11 17:13:05','',''),('1','289',438,'','supplier','1',0.00,591228.00,'Payment Id 164 for invoice:78, receipt: NFGBNM by AA RANO NIGERIA LTD','2023-03-11 17:13:05','',''),('1','289',439,'','2','6',1131553.00,0.00,'Payment Id 168 for invoice:80, receipt: ,KJHGV by AA RANO NIGERIA LTD','2023-03-11 17:18:05','',''),('1','289',440,'','supplier','1',0.00,1131553.00,'Payment Id 168 for invoice:80, receipt: ,KJHGV by AA RANO NIGERIA LTD','2023-03-11 17:18:05','',''),('1','289',441,'','6.1','4',210000.00,0.00,'Payment Id 181 for invoice:84, receipt: ERFGKHBV by AA RANO NIGERIA LTD','2023-03-11 17:18:21','',''),('1','289',442,'','supplier','1',0.00,210000.00,'Payment Id 181 for invoice:84, receipt: ERFGKHBV by AA RANO NIGERIA LTD','2023-03-11 17:18:21','',''),('1','289',443,'','6.1','4',210000.00,0.00,'Payment Id 180 for invoice:84, receipt: YRTLKMNBV by AA RANO NIGERIA LTD','2023-03-11 17:18:21','',''),('1','289',444,'','supplier','1',0.00,210000.00,'Payment Id 180 for invoice:84, receipt: YRTLKMNBV by AA RANO NIGERIA LTD','2023-03-11 17:18:21','',''),('1','289',445,'','6.1','4',745000.00,0.00,'Payment Id 174 for invoice:82, receipt: JHGF  by AA RANO NIGERIA LTD','2023-03-11 17:18:40','',''),('1','289',446,'','supplier','1',0.00,745000.00,'Payment Id 174 for invoice:82, receipt: JHGF  by AA RANO NIGERIA LTD','2023-03-11 17:18:40','',''),('1','289',447,'','6.1','4',210000.00,0.00,'Payment Id 173 for invoice:82, receipt: UYGFGHJK by AA RANO NIGERIA LTD','2023-03-11 17:18:41','',''),('1','289',448,'','supplier','1',0.00,210000.00,'Payment Id 173 for invoice:82, receipt: UYGFGHJK by AA RANO NIGERIA LTD','2023-03-11 17:18:41','',''),('1','289',449,'','2','6',245720.00,0.00,'Payment Id 172 for invoice:82, receipt: ,MNBVC  by AA RANO NIGERIA LTD','2023-03-11 17:18:41','',''),('1','289',450,'','supplier','1',0.00,245720.00,'Payment Id 172 for invoice:82, receipt: ,MNBVC  by AA RANO NIGERIA LTD','2023-03-11 17:18:41','',''),('1','289',451,'','20','3',3657984.15,0.00,'Sales from shift 86 on 2023-03-13 17:58:07 ','2023-03-13 17:58:07','',''),('1','289',452,'','6.1','4',0.00,3657984.15,'Sales from shift 86 on 2023-03-13 17:58:07 ','2023-03-13 17:58:07','',''),('1','289',453,'','20','3',854600.00,0.00,'Sales from shift 87 on 2023-03-14 08:29:09 ','2023-03-14 08:29:09','',''),('1','289',454,'','6.1','4',0.00,854600.00,'Sales from shift 87 on 2023-03-14 08:29:09 ','2023-03-14 08:29:09','',''),('1','289',455,'','20','3',4469651.45,0.00,'Sales from shift 88 on 2023-03-14 18:37:36 ','2023-03-14 18:37:36','',''),('1','289',456,'','6.1','4',0.00,4469651.45,'Sales from shift 88 on 2023-03-14 18:37:36 ','2023-03-14 18:37:36','',''),('1','289',457,'','24','2',0.00,10575000.00,'Purchase Id 10 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-14 18:38:54','',''),('1','289',458,'','supplier','1',10575000.00,0.00,'Purchase Id 10 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-14 18:38:54','',''),('1','289',459,'','2','5',1420000.00,0.00,'Payment Id 171 for invoice:82, receipt: LKJHGVBN by AA RANO NIGERIA LTD','2023-03-15 12:23:21','',''),('1','289',460,'','supplier','1',0.00,1420000.00,'Payment Id 171 for invoice:82, receipt: LKJHGVBN by AA RANO NIGERIA LTD','2023-03-15 12:23:21','',''),('1','289',461,'','2','5',1757100.00,0.00,'Payment Id 169 for invoice:81, receipt: DFGHKJH by AA RANO NIGERIA LTD','2023-03-15 12:23:21','',''),('1','289',462,'','supplier','1',0.00,1757100.00,'Payment Id 169 for invoice:81, receipt: DFGHKJH by AA RANO NIGERIA LTD','2023-03-15 12:23:21','',''),('1','289',463,'','2','5',1348300.00,0.00,'Payment Id 167 for invoice:80, receipt: KJHGFCX by AA RANO NIGERIA LTD','2023-03-15 12:23:21','',''),('1','289',464,'','supplier','1',0.00,1348300.00,'Payment Id 167 for invoice:80, receipt: KJHGFCX by AA RANO NIGERIA LTD','2023-03-15 12:23:21','',''),('1','289',465,'','6.1','4',295000.00,0.00,'Payment Id 186 for invoice:85, receipt: NJHUJ by AA RANO NIGERIA LTD','2023-03-15 12:25:21','',''),('1','289',466,'','supplier','1',0.00,295000.00,'Payment Id 186 for invoice:85, receipt: NJHUJ by AA RANO NIGERIA LTD','2023-03-15 12:25:21','',''),('1','289',467,'','6.1','4',210000.00,0.00,'Payment Id 185 for invoice:85, receipt: MHGFVBHN by AA RANO NIGERIA LTD','2023-03-15 12:25:21','',''),('1','289',468,'','supplier','1',0.00,210000.00,'Payment Id 185 for invoice:85, receipt: MHGFVBHN by AA RANO NIGERIA LTD','2023-03-15 12:25:21','',''),('1','289',469,'','2','5',3120350.00,0.00,'Payment Id 183 for invoice:85, receipt: ERGHJ, by AA RANO NIGERIA LTD','2023-03-15 12:25:21','',''),('1','289',470,'','supplier','1',0.00,3120350.00,'Payment Id 183 for invoice:85, receipt: ERGHJ, by AA RANO NIGERIA LTD','2023-03-15 12:25:21','',''),('1','289',471,'','2','5',1649650.00,0.00,'Payment Id 178 for invoice:84, receipt: HGFDTYJK by AA RANO NIGERIA LTD','2023-03-15 12:25:21','',''),('1','289',472,'','supplier','1',0.00,1649650.00,'Payment Id 178 for invoice:84, receipt: HGFDTYJK by AA RANO NIGERIA LTD','2023-03-15 12:25:21','',''),('1','289',473,'','2','5',2542015.00,0.00,'Payment Id 189 for invoice:86, receipt: ;LKJHG by AA RANO NIGERIA LTD','2023-03-15 12:26:03','',''),('1','289',474,'','supplier','1',0.00,2542015.00,'Payment Id 189 for invoice:86, receipt: ;LKJHG by AA RANO NIGERIA LTD','2023-03-15 12:26:03','',''),('1','289',475,'','6.1','4',210000.00,0.00,'Payment Id 188 for invoice:85, receipt: UYHVF by AA RANO NIGERIA LTD','2023-03-15 12:26:03','',''),('1','289',476,'','supplier','1',0.00,210000.00,'Payment Id 188 for invoice:85, receipt: UYHVF by AA RANO NIGERIA LTD','2023-03-15 12:26:03','',''),('1','289',477,'','6.1','4',745000.00,0.00,'Payment Id 187 for invoice:85, receipt: WFHK by AA RANO NIGERIA LTD','2023-03-15 12:26:03','',''),('1','289',478,'','supplier','1',0.00,745000.00,'Payment Id 187 for invoice:85, receipt: WFHK by AA RANO NIGERIA LTD','2023-03-15 12:26:03','',''),('1','289',479,'','6.1','4',505000.00,0.00,'Payment Id 193 for invoice:86, receipt: .LKJHG by AA RANO NIGERIA LTD','2023-03-15 12:29:46','',''),('1','289',480,'','supplier','1',0.00,505000.00,'Payment Id 193 for invoice:86, receipt: .LKJHG by AA RANO NIGERIA LTD','2023-03-15 12:29:46','',''),('1','289',481,'','6.1','4',375000.00,0.00,'Payment Id 192 for invoice:86, receipt: FTYHNM by AA RANO NIGERIA LTD','2023-03-15 12:29:46','',''),('1','289',482,'','supplier','1',0.00,375000.00,'Payment Id 192 for invoice:86, receipt: FTYHNM by AA RANO NIGERIA LTD','2023-03-15 12:29:46','',''),('1','289',483,'','20','3',4356303.85,0.00,'Sales from shift 89 on 2023-03-16 10:45:48 ','2023-03-16 10:45:48','',''),('1','289',484,'','6.1','4',0.00,4356303.85,'Sales from shift 89 on 2023-03-16 10:45:48 ','2023-03-16 10:45:48','',''),('1','289',485,'','24','2',0.00,10575000.00,'Purchase Id 11 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-16 10:47:25','',''),('1','289',486,'','supplier','1',10575000.00,0.00,'Purchase Id 11 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-16 10:47:25','',''),('1','289',487,'','20','3',4773019.45,0.00,'Sales from shift 90 on 2023-03-16 12:21:25 ','2023-03-16 12:21:25','',''),('1','289',488,'','6.1','4',0.00,4773019.45,'Sales from shift 90 on 2023-03-16 12:21:25 ','2023-03-16 12:21:25','',''),('1','289',489,'','2','6',1002025.00,0.00,'Payment Id 179 for invoice:84, receipt: LKJHJKLKM by AA RANO NIGERIA LTD','2023-03-16 15:29:50','',''),('1','289',490,'','supplier','1',0.00,1002025.00,'Payment Id 179 for invoice:84, receipt: LKJHJKLKM by AA RANO NIGERIA LTD','2023-03-16 15:29:50','',''),('1','289',491,'','2','6',572200.00,0.00,'Payment Id 184 for invoice:85, receipt: WDFGHJIUJ by AA RANO NIGERIA LTD','2023-03-16 15:30:31','',''),('1','289',492,'','supplier','1',0.00,572200.00,'Payment Id 184 for invoice:85, receipt: WDFGHJIUJ by AA RANO NIGERIA LTD','2023-03-16 15:30:31','',''),('1','289',493,'','2','6',1090570.00,0.00,'Payment Id 190 for invoice:86, receipt: RTYGUHIKOP[ by AA RANO NIGERIA LTD','2023-03-16 15:33:18','',''),('1','289',494,'','supplier','1',0.00,1090570.00,'Payment Id 190 for invoice:86, receipt: RTYGUHIKOP[ by AA RANO NIGERIA LTD','2023-03-16 15:33:18','',''),('1','289',495,'','6.1','4',295000.00,0.00,'Payment Id 196 for invoice:87, receipt: CRT by AA RANO NIGERIA LTD','2023-03-16 15:37:48','',''),('1','289',496,'','supplier','1',0.00,295000.00,'Payment Id 196 for invoice:87, receipt: CRT by AA RANO NIGERIA LTD','2023-03-16 15:37:48','',''),('1','289',497,'','2','6',445861.00,0.00,'Payment Id 195 for invoice:87, receipt: ESZRDFCGHJ by AA RANO NIGERIA LTD','2023-03-16 15:37:48','',''),('1','289',498,'','supplier','1',0.00,445861.00,'Payment Id 195 for invoice:87, receipt: ESZRDFCGHJ by AA RANO NIGERIA LTD','2023-03-16 15:37:48','',''),('1','289',499,'','6.1','4',335000.00,0.00,'Payment Id 197 for invoice:87, receipt: NBGYHJ by AA RANO NIGERIA LTD','2023-03-17 13:50:49','',''),('1','289',500,'','supplier','1',0.00,335000.00,'Payment Id 197 for invoice:87, receipt: NBGYHJ by AA RANO NIGERIA LTD','2023-03-17 13:50:49','',''),('1','289',501,'','6.1','4',370500.00,0.00,'Payment Id 200 for invoice:89, receipt: KJHN by AA RANO NIGERIA LTD','2023-03-17 14:53:55','',''),('1','289',502,'','supplier','1',0.00,370500.00,'Payment Id 200 for invoice:89, receipt: KJHN by AA RANO NIGERIA LTD','2023-03-17 14:53:55','',''),('1','289',503,'','6.1','4',179500.00,0.00,'Payment Id 207 for invoice:90, receipt: BHHB by AA RANO NIGERIA LTD','2023-03-17 15:49:55','',''),('1','289',504,'','supplier','1',0.00,179500.00,'Payment Id 207 for invoice:90, receipt: BHHB by AA RANO NIGERIA LTD','2023-03-17 15:49:55','',''),('1','289',505,'','6.1','4',79000.00,0.00,'Payment Id 206 for invoice:90, receipt: JH by AA RANO NIGERIA LTD','2023-03-17 15:49:55','',''),('1','289',506,'','supplier','1',0.00,79000.00,'Payment Id 206 for invoice:90, receipt: JH by AA RANO NIGERIA LTD','2023-03-17 15:49:55','',''),('1','289',507,'','6.1','4',449000.00,0.00,'Payment Id 205 for invoice:90, receipt: A by AA RANO NIGERIA LTD','2023-03-17 15:49:55','',''),('1','289',508,'','supplier','1',0.00,449000.00,'Payment Id 205 for invoice:90, receipt: A by AA RANO NIGERIA LTD','2023-03-17 15:49:55','',''),('1','289',509,'','6.1','4',578000.00,0.00,'Payment Id 204 for invoice:90, receipt: WDFJKLL by AA RANO NIGERIA LTD','2023-03-17 15:49:55','',''),('1','289',510,'','supplier','1',0.00,578000.00,'Payment Id 204 for invoice:90, receipt: WDFJKLL by AA RANO NIGERIA LTD','2023-03-17 15:49:55','',''),('1','289',511,'','20','3',3193565.40,0.00,'Sales from shift 91 on 2023-03-17 21:38:06 ','2023-03-17 21:38:06','',''),('1','289',512,'','6.1','4',0.00,3193565.40,'Sales from shift 91 on 2023-03-17 21:38:06 ','2023-03-17 21:38:06','',''),('1','289',513,'','20','3',4565515.30,0.00,'Sales from shift 92 on 2023-03-20 08:06:14 ','2023-03-20 08:06:14','',''),('1','289',514,'','6.1','4',0.00,4565515.30,'Sales from shift 92 on 2023-03-20 08:06:14 ','2023-03-20 08:06:14','',''),('1','289',515,'','20','3',9870000.00,0.00,'Sales Id 1 for 42,000.00 litters of Petrol - PMS @ N235.00 to NIGERIA POLICE FORCE (ELECTION','2023-03-20 08:44:16','',''),('1','289',516,'','customer','1',0.00,9870000.00,'Sales Id 1 for 42,000.00 litters of Petrol - PMS @ N235.00','2023-03-20 08:44:16','',''),('1','289',517,'','20','3',0.00,0.00,'Sales from shift 93 on 2023-03-20 14:49:58 ','2023-03-20 14:49:58','',''),('1','289',518,'','6.1','4',0.00,0.00,'Sales from shift 93 on 2023-03-20 14:49:58 ','2023-03-20 14:49:58','','');
/*!40000 ALTER TABLE `ledgers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `options`
--

DROP TABLE IF EXISTS `options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `options` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` bigint NOT NULL,
  `station_id` bigint NOT NULL,
  `option_key` varchar(200) NOT NULL,
  `option_value` longtext,
  `thedate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `station_id` (`station_id`,`option_key`),
  KEY `company_id` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `options`
--

LOCK TABLES `options` WRITE;
/*!40000 ALTER TABLE `options` DISABLE KEYS */;
/*!40000 ALTER TABLE `options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `measurement` varchar(20) NOT NULL,
  `quantity2` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`code`,`name`,`measurement`,`quantity2`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `cleanup` (`cleanup`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'1','289','PMS','Petrol','Litres',0,235.00,235.00,210.00,210.00,0.00,0,'2022-10-19 17:13:45','178','178','2022-10-19 17:13:45',0),(2,'1','289','AGO','Diesel','Litres',0,790.00,790.00,790.00,790.00,0.00,0,'2022-10-19 17:19:27','178','178','2022-10-19 17:19:27',0);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_changevalues`
--

DROP TABLE IF EXISTS `products_changevalues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_changevalues` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `change_id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity` bigint NOT NULL,
  `oldrate` decimal(20,2) NOT NULL,
  `newrate` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`change_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_changevalues`
--

LOCK TABLES `products_changevalues` WRITE;
/*!40000 ALTER TABLE `products_changevalues` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_changevalues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_prices`
--

DROP TABLE IF EXISTS `products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_prices`
--

LOCK TABLES `products_prices` WRITE;
/*!40000 ALTER TABLE `products_prices` DISABLE KEYS */;
INSERT INTO `products_prices` VALUES (1,'1','289',2,180.00,180.00,180.00,180.00,'','2022-10-25 19:56:46','970'),(2,'1','289',2,0.00,0.00,0.00,0.00,'','2022-10-25 19:58:55','970'),(3,'1','289',1,180.00,180.00,180.00,180.00,'','2022-10-25 19:59:56','970'),(4,'1','289',1,210.00,180.00,0.00,0.00,'Cost from purchase id #3','2022-11-24 04:46:06','648'),(5,'1','289',1,210.00,210.00,210.00,210.00,'NEW PRICE 60,600 LTRS ON GROUND','2022-11-24 11:51:37','970'),(6,'1','289',2,790.00,790.00,790.00,790.00,'','2023-02-10 22:17:45','970'),(7,'1','289',1,235.00,235.00,210.00,210.00,'NEW PRICE 300 LTRS ON GROUND','2023-03-02 23:47:06','970'),(8,'1','289',2,800.00,800.00,800.00,800.00,'NEW PRICE 500 LTRS ON GROUND','2023-03-05 18:49:54','970'),(9,'1','289',2,790.00,790.00,790.00,790.00,'NEW PRICE 35,350 LTRS ON GROUND','2023-03-14 00:34:59','970');
/*!40000 ALTER TABLE `products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_reconciliations`
--

DROP TABLE IF EXISTS `products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_reconciliations`
--

LOCK TABLES `products_reconciliations` WRITE;
/*!40000 ALTER TABLE `products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_shortages`
--

DROP TABLE IF EXISTS `products_shortages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_shortages` (
  `shortage_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shortagedate` date NOT NULL,
  `product_id` varchar(10) NOT NULL,
  `type` int NOT NULL DEFAULT '0',
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`shortage_id`),
  KEY `companycode` (`company_id`,`shortagedate`,`product_id`,`rate`,`quantity`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_shortages`
--

LOCK TABLES `products_shortages` WRITE;
/*!40000 ALTER TABLE `products_shortages` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_shortages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pts_nozzles`
--

DROP TABLE IF EXISTS `pts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pts_nozzles` (
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pts_id` int NOT NULL,
  `pump` varchar(20) NOT NULL,
  `code` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `last_volume` decimal(20,2) NOT NULL,
  `last_price` decimal(20,2) NOT NULL,
  `last_amount` decimal(20,2) NOT NULL,
  `last_transaction` int NOT NULL DEFAULT '0',
  `total_volume` decimal(20,2) NOT NULL,
  `total_amount` decimal(20,2) NOT NULL,
  `total_transactions` decimal(20,2) NOT NULL,
  `lastconnect` datetime NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `terminal_id` (`pts_id`,`pump`,`code`,`lastconnect`),
  KEY `companycode` (`company_id`,`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pts_nozzles`
--

LOCK TABLES `pts_nozzles` WRITE;
/*!40000 ALTER TABLE `pts_nozzles` DISABLE KEYS */;
/*!40000 ALTER TABLE `pts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases`
--

DROP TABLE IF EXISTS `purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases`
--

LOCK TABLES `purchases` WRITE;
/*!40000 ALTER TABLE `purchases` DISABLE KEYS */;
INSERT INTO `purchases` VALUES (1,'1','289','2022-10-25',1,1,180.00,50000.00,0.00,0.00,9000000.00,0.00,'','','RAN849XA','','','','2022-10-25 19:41:58',15,'','970','','0000-00-00 00:00:00','648','2022-10-26 11:25:32'),(2,'1','289','2022-10-19',1,1,180.00,50000.00,0.00,0.00,9000000.00,0.00,'','','NSR488ZU','','','','2022-10-25 19:45:07',15,'','970','','0000-00-00 00:00:00','648','2022-10-26 11:25:56'),(3,'1','289','2022-11-23',1,1,210.00,60000.00,0.00,0.00,12600000.00,0.00,'','','KMC667ZE','','','','2022-11-23 15:10:59',15,'','970','','0000-00-00 00:00:00','648','2022-11-24 04:46:06'),(4,'1','289','2023-02-10',2,1,790.00,30000.00,0.00,0.00,23700000.00,0.00,'','','TRN-16-YZ','','','','2023-02-10 22:19:14',15,'','970','','0000-00-00 00:00:00','648','2023-02-11 10:14:08'),(5,'1','289','2023-03-01',1,1,235.00,50000.00,0.00,0.00,11750000.00,0.00,'','','KMC717ZJ','','','','2023-03-02 23:48:31',15,'','970','','0000-00-00 00:00:00','648','2023-03-05 07:43:56'),(6,'1','289','2023-03-05',2,1,800.00,45000.00,0.00,0.00,36000000.00,0.00,'','0285816','KMC-662-ZE','','','','2023-03-05 18:51:43',15,'RECIEVED','970','','0000-00-00 00:00:00','648','2023-03-07 11:34:54'),(7,'1','289','2023-02-24',1,1,235.00,42000.00,0.00,0.00,9870000.00,0.00,'','','ABS-700-XA','','','','2023-03-09 13:13:43',15,'DISCHARGED AT RIVER STATE POLICE COMMAND','970','','0000-00-00 00:00:00','648','2023-03-09 13:51:41'),(8,'1','289','2023-03-09',1,1,235.00,50000.00,0.00,0.00,11750000.00,0.00,'','','RAN-920-XA','','','','2023-03-09 13:15:38',15,'RECIEVED','970','','0000-00-00 00:00:00','648','2023-03-09 13:52:09'),(9,'1','289','2023-03-09',1,1,235.00,60000.00,0.00,0.00,14100000.00,0.00,'','','TRN-34-ZY','','','','2023-03-09 13:16:33',15,'RECIEVED','970','','0000-00-00 00:00:00','648','2023-03-09 13:52:57'),(10,'1','289','2023-03-09',1,1,235.00,45000.00,0.00,0.00,10575000.00,0.00,'','','RAN-807-XA','','','','2023-03-14 00:21:10',15,'RECIEVED','970','','0000-00-00 00:00:00','648','2023-03-14 18:38:54'),(11,'1','289','2023-03-15',1,1,235.00,45000.00,0.00,0.00,10575000.00,0.00,'','2007617','RAN-831-XA','','','','2023-03-16 10:17:54',15,'RECIEVED SUCCESSFULLY','970','','0000-00-00 00:00:00','648','2023-03-16 10:47:25');
/*!40000 ALTER TABLE `purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_payments`
--

DROP TABLE IF EXISTS `purchases_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `supplier_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`supplier_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=217 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_payments`
--

LOCK TABLES `purchases_payments` WRITE;
/*!40000 ALTER TABLE `purchases_payments` DISABLE KEYS */;
INSERT INTO `purchases_payments` VALUES (1,'1','289','2022-10-11',1,'0632815','','5',203320.00,'2','','','5','PH3-AAR-5700','0632815',203315.40,'2022-11-01 20:14:39',5,'cash lodge to bank','970','975','2022-11-10 14:17:35','975','2022-11-10 14:54:22'),(2,'1','289','2022-10-12',1,'0632822','','5',146100.00,'3','','','5','PH3-AAR-5700','0632822',153250.20,'2022-11-01 20:18:46',5,'cash lodged to bank','970','975','2022-11-10 14:18:20','975','2022-11-10 14:54:22'),(3,'1','289','2022-10-12',1,'0632814','','5',231595.00,'4','','','5','PH3-AAR-5700','0632814',231595.20,'2022-11-01 20:23:09',5,'cash lodged to bank','970','','0000-00-00 00:00:00','975','2022-11-10 14:54:22'),(4,'1','289','2022-10-13',1,'0632534','','5',127000.00,'5','','','5','PH3-AAR-5700','0632534',126937.80,'2022-11-01 20:25:26',5,'cash lodged to bank','970','','0000-00-00 00:00:00','975','2022-11-10 14:54:22'),(5,'1','289','2022-10-13',1,'0632533','','5',183210.00,'6','','','5','PH3-AAR-5700','0632533',224958.60,'2022-11-01 20:27:31',5,'cash lodge to bank','970','975','2022-11-10 14:21:00','975','2022-11-10 14:57:31'),(7,'1','289','2022-10-14',1,'0632825','','5',125380.00,'7','','','5','PH3-AAR-5700','0632825',167337.00,'2022-11-01 20:35:18',5,'CASH LODGED TO BANK','970','975','2022-11-10 14:22:22','975','2022-11-10 14:58:35'),(9,'1','289','2022-10-14',1,'0632532','','5',178580.00,'8','','','5','PH3-AAR-5700','0632532',192074.40,'2022-11-01 20:38:29',5,'CASH LODGED TO BANK','970','975','2022-11-10 14:25:51','975','2022-11-10 14:58:35'),(11,'1','289','2022-10-15',1,'0632531','','5',138320.00,'9','','','5','PH3-AAR-5700','0632531',179181.00,'2022-11-01 20:42:12',5,'CASH LODGED TO BANK','970','','0000-00-00 00:00:00','975','2022-11-10 15:01:00'),(13,'1','289','2022-10-15',1,'0632530','','5',184440.00,'11','','','5','PH3-AAR-5700','0632530',242834.40,'2022-11-01 20:49:49',5,'CASH LODGED TO BANK','970','','0000-00-00 00:00:00','975','2022-11-10 15:01:00'),(15,'1','289','2022-10-16',1,'0632528','','5',112520.00,'12','','','5','PH3-AAR-5700','0632528',161323.20,'2022-11-01 20:53:15',5,'CASH LODGED TO BANK','970','','0000-00-00 00:00:00','975','2022-11-10 15:04:31'),(17,'1','289','2022-10-16',1,'0632522','','5',188300.00,'13','','','5','PH3-AAR-5700','0632522',200894.40,'2022-11-01 20:58:55',5,'CASH LODGED TO BANK','970','','0000-00-00 00:00:00','975','2022-11-10 15:04:31'),(19,'1','289','2022-10-17',1,'0632523','','5',156920.00,'14','','','5','PH3-AAR-5700','0632523',212461.20,'2022-11-01 21:03:11',5,'CASH LODGED TO BANK','970','','0000-00-00 00:00:00','975','2022-11-10 15:06:27'),(21,'1','289','2022-10-17',1,'0632524','','5',157875.00,'15','','','5','PH3-AAR-5700','0632524',257472.00,'2022-11-01 21:05:57',5,'CASH LODGED TO BANK','970','','0000-00-00 00:00:00','975','2022-11-10 15:06:27'),(23,'1','289','2022-10-18',1,'0632525','','5',405780.00,'16','','','5','PH3-AAR-5700','0632525',471927.60,'2022-11-01 21:10:02',5,'CASH LODGED TO BANK','970','','0000-00-00 00:00:00','975','2022-11-10 16:21:19'),(25,'1','289','2022-10-18',1,'0632526','','5',969430.00,'17','','','5','PH3-AAR-5700','0632526',1647342.00,'2022-11-01 21:13:34',5,'CASH LODGED TO BANK','970','','0000-00-00 00:00:00','975','2022-11-10 16:21:19'),(27,'1','289','2022-10-19',1,'0581787','','5',879690.00,'18','','','5','PH3-AAR-5700','0581787',984490.20,'2022-11-01 21:16:47',5,'PAID TO ACCOUNT','970','975','2022-11-10 14:35:02','975','2022-11-10 16:22:37'),(29,'1','289','2022-10-19',1,'0581786','','5',428190.00,'19','','','5','PH3-AAR-5700','0581786',611269.20,'2022-11-01 21:20:00',5,'PAID TO BANK','970','','0000-00-00 00:00:00','975','2022-11-10 16:22:37'),(31,'1','289','2022-10-20',1,'0282094','','5',332750.00,'20','','','5','PH3-AAR-5700','0282094',471830.40,'2022-11-02 08:21:18',5,'CASH LODGED TO BANK','970','','0000-00-00 00:00:00','975','2022-11-10 16:23:54'),(33,'1','289','2022-10-20',1,'0581782','','5',199160.00,'21','','','5','PH3-AAR-5700','0581782',463057.20,'2022-11-02 08:25:52',5,'CASH LODGED TO BANK','970','','0000-00-00 00:00:00','975','2022-11-10 16:23:54'),(35,'1','289','2022-10-21',1,'0581781','','5',310340.00,'22','','','5','PH3-AAR-5700','0581781',338342.40,'2022-11-02 08:30:14',5,'CASH DEPOSIT TO BANK','970','','0000-00-00 00:00:00','975','2022-11-10 16:26:09'),(37,'1','289','2022-10-21',1,'0581780','','5',537765.00,'23','','','5','PH3-AAR-5700','0581780',607203.00,'2022-11-02 08:38:21',5,'PAID CASH TO BANK','970','','0000-00-00 00:00:00','975','2022-11-10 16:26:09'),(39,'1','289','2022-10-22',1,'0581779','','5',355880.00,'24','','','5','PH3-AAR-5700','0581779',395677.80,'2022-11-02 08:42:07',5,'PAID CASH TO BANK','970','','0000-00-00 00:00:00','975','2022-11-10 16:43:39'),(41,'1','289','2022-10-22',1,'0581778','','5',47210.00,'25','','','5','PH3-AAR-5700','0581778',145998.00,'2022-11-02 08:47:11',5,'CASH PAID TO BANK','970','','0000-00-00 00:00:00','975','2022-11-10 16:43:39'),(43,'1','289','2022-10-23',1,'0581777','','5',212870.00,'26','','','5','PH3-AAR-5700','0581777',325470.60,'2022-11-02 08:51:12',5,'CASH TO BANK','970','','0000-00-00 00:00:00','975','2022-11-10 16:44:41'),(45,'1','289','2022-10-23',1,'0581776','','5',317110.00,'27','','','5','PH3-AAR-5700','0581776',396784.80,'2022-11-02 08:55:06',5,'CASH PAID TO BANK','970','','0000-00-00 00:00:00','975','2022-11-10 16:44:41'),(47,'1','289','2022-10-24',1,'0581775','','5',484620.00,'28','','','5','PH3-AAR-5700','0581775',584334.00,'2022-11-02 09:12:59',5,'CASH PAID TO BANK','970','','0000-00-00 00:00:00','975','2022-11-10 16:45:41'),(49,'1','289','2022-10-24',1,'0581774','','5',485270.00,'29','','','5','PH3-AAR-5700','0581774',568900.80,'2022-11-02 09:16:16',5,'PAID CASH TO BANK','970','','0000-00-00 00:00:00','975','2022-11-10 16:45:41'),(51,'1','289','2022-10-25',1,'0581770','','5',507540.00,'30','','','5','PH3-AAR-5700','0581770',567009.00,'2022-11-02 09:21:21',5,'CASH PAID TO BANK','970','','0000-00-00 00:00:00','975','2022-11-10 16:46:54'),(53,'1','289','2022-10-25',1,'0581771','','5',338280.00,'31','','','5','PH3-AAR-5700','0581771',421417.80,'2022-11-02 09:25:31',5,'CASH PAID TO BANK','970','','0000-00-00 00:00:00','975','2022-11-10 16:46:54'),(55,'1','289','2022-10-26',1,'0581769','','5',258040.00,'32','','','5','PH3-AAR-5700','0581769',532810.80,'2022-11-02 09:29:08',5,'CASH PAID TO BANK','970','','0000-00-00 00:00:00','975','2022-11-17 13:34:11'),(57,'1','289','2022-10-26',1,'0581773','','5',392980.00,'33','','','5','PH3-AAR-5700','0581773',445368.60,'2022-11-02 09:31:57',5,'CASH PAID TO BANK','970','','0000-00-00 00:00:00','975','2022-11-10 16:49:45'),(59,'1','289','2022-10-27',1,'0282097','','5',360150.00,'35','','','5','PH3-AAR-5700','0282097',482490.00,'2022-11-02 10:38:28',5,'CASH PAID TO BANK','970','','0000-00-00 00:00:00','975','2022-11-10 16:52:08'),(61,'1','289','2022-10-27',1,'0282096','','5',416175.00,'36','','','5','PH3-AAR-5700','0282096',513860.40,'2022-11-02 10:42:47',5,'CASH PAID TO BANK','970','','0000-00-00 00:00:00','975','2022-11-10 16:52:08'),(63,'1','289','2022-10-29',1,'0282095','','5',270100.00,'37','','','5','PH3-AAR-5700','0282095',351441.00,'2022-11-02 10:54:16',5,'CASH PAID TO BSANK','970','','0000-00-00 00:00:00','975','2022-11-10 16:53:39'),(65,'1','289','2022-10-30',1,'028,2094','','5',335870.00,'38','','','5','PH3-AAR-5700','028,2094',473911.20,'2022-11-02 11:02:05',5,'CASH PAID TO BANK','970','975','2022-11-17 13:13:13','975','2022-11-17 13:14:20'),(67,'1','289','2022-10-30',1,'0282093','','5',402505.00,'39','','','5','PH3-AAR-5700','0282093',527954.40,'2022-11-02 12:42:49',5,'PAID TO BANK','970','','0000-00-00 00:00:00','975','2022-11-10 16:54:48'),(69,'1','289','2022-10-31',1,'0581767','','5',473630.00,'40','','','5','PH3-AAR-5700','0581767',585712.80,'2022-11-02 13:08:38',5,'PAID TO BANK','970','975','2022-11-17 13:18:24','975','2022-11-17 13:22:04'),(71,'1','289','2022-10-31',1,'0581768','','5',377450.00,'41','','','5','PH3-AAR-5700','0581768',582946.20,'2022-11-02 13:16:04',5,'PAID CASH TO BANK','970','','0000-00-00 00:00:00','975','2022-11-17 13:22:04'),(73,'1','289','2022-11-01',1,'0282092','','5',142880.00,'42','','','5','PH3-AAR-5700','0282092',477122.40,'2022-11-02 13:20:58',5,'PAID CASH TO BANK','970','','0000-00-00 00:00:00','975','2022-11-17 13:30:03'),(75,'1','289','2022-11-01',1,'0581783','','5',50000.00,'42','','','5','PH3-AAR-5700','0581783',0.00,'2022-11-08 18:12:59',5,'ADDITIONAL PAYMENT. LODGED CASH TO BANK','970','975','2022-11-17 13:22:55','975','2022-12-06 12:34:32'),(76,'1','289','2022-11-04',1,'0581765','','5',492940.00,'43','','','5','PH3-AAR-5700','0581765',640440.00,'2022-11-08 18:16:36',5,'CASH LODGED TO BANK','970','975','2022-11-17 13:26:02','975','2022-11-17 13:28:27'),(78,'1','289','2022-10-13',1,'2033XOYF,,,,,','','10',38005.00,'6','','','6','PH3-AAR-5700','2033XOYF,,,,,',0.00,'2022-11-10 14:35:50',5,'PAID BY POS','970','','0000-00-00 00:00:00','975','2022-11-10 14:57:31'),(79,'1','289','2022-10-14',1,'KHG','','10',55500.00,'7/8','','','6','PH3-AAR-5700','GDGHNH',0.00,'2022-11-10 14:40:58',5,'','970','','0000-00-00 00:00:00','975','2022-11-10 14:58:35'),(80,'1','289','2022-10-15',1,'HGVH','','10',98900.00,'9/11','','','6','PH3-AAR-5700','GFJUG',0.00,'2022-11-10 14:42:46',5,'','970','','0000-00-00 00:00:00','975','2022-11-10 15:01:00'),(81,'1','289','2022-10-16',1,'BGFGUIJ','','10',49408.00,'12/13','','','6','PH3-AAR-5700','GUYGYUI',0.00,'2022-11-10 14:47:06',5,'','970','','0000-00-00 00:00:00','975','2022-11-10 15:04:31'),(84,'1','289','2022-10-17',1,'DFGH','','10',56600.00,'14/15','','','6','PH3-AAR-5700','WEFGHJ',0.00,'2022-11-10 14:57:40',5,'','970','','0000-00-00 00:00:00','975','2022-11-10 15:06:27'),(85,'1','289','2022-10-18',1,'jhgfc','','10',590834.00,'16/17','','','6','PH3-AAR-5700','zdfgh',0.00,'2022-11-10 15:12:01',5,'','970','','0000-00-00 00:00:00','975','2022-11-10 16:21:19'),(86,'1','289','2022-10-19',1,'bnm','','10',287738.00,'18/19','','','6','PH3-AAR-5700','bnm',0.00,'2022-11-10 15:18:10',5,'','970','','0000-00-00 00:00:00','975','2022-11-10 16:22:37'),(87,'1','289','2022-10-20',1,'rthjk,','','10',192980.00,'20/21','','','6','PH3-AAR-5700','wghjk',0.00,'2022-11-10 15:20:39',5,'','970','','0000-00-00 00:00:00','975','2022-11-10 16:23:54'),(88,'1','289','2022-10-21',1,'efghnm','','10',96900.00,'22/23','','','6','PH3-AAR-5700','fghlknb',0.00,'2022-11-10 15:26:16',5,'','970','','0000-00-00 00:00:00','975','2022-11-10 16:26:09'),(89,'1','289','2022-10-22',1,'ngfef','','10',92800.00,'24/25','','','6','PH3-AAR-5700',',kythj',0.00,'2022-11-10 15:27:37',5,'','970','','0000-00-00 00:00:00','975','2022-11-10 16:43:39'),(90,'1','289','2022-10-23',1,'/kfcvhu','','10',108178.60,'26/27','','','6','PH3-AAR-5700','hthjm',0.00,'2022-11-10 15:29:51',5,'','970','','0000-00-00 00:00:00','975','2022-11-10 16:44:41'),(91,'1','289','2022-10-24',1,'nhyujm','','10',150218.00,'28/29','','','6','PH3-AAR-5700','yghjuh',0.00,'2022-11-10 15:31:40',5,'','970','','0000-00-00 00:00:00','975','2022-11-10 16:45:41'),(92,'1','289','2022-10-25',1,'zxjolmn','','10',142680.00,'30/31','','','6','PH3-AAR-5700','jhgbnjiuy',0.00,'2022-11-10 15:33:01',5,'','970','','0000-00-00 00:00:00','975','2022-11-10 16:46:54'),(93,'1','289','2022-10-26',1,'tghnm','','10',98891.00,'32/33','','','6','PH3-AAR-5700','jhnji',0.00,'2022-11-10 15:34:35',5,'','970','','0000-00-00 00:00:00','975','2022-11-10 16:49:45'),(94,'1','289','2022-10-27',1,'tghjkjnb','','10',218516.00,'35/36','','','6','PH3-AAR-5700','mjtghju8',0.00,'2022-11-10 15:36:01',5,'','970','','0000-00-00 00:00:00','975','2022-11-10 16:52:08'),(95,'1','289','2022-10-29',1,'yhjin','','10',48944.00,'37','','','6','PH3-AAR-5700',',kjhghbnm',0.00,'2022-11-10 15:37:17',5,'','970','','0000-00-00 00:00:00','975','2022-11-10 16:53:39'),(96,'1','289','2022-10-30',1,'tyjnfg','','10',263495.00,'38/39','','','6','PH3-AAR-5700','hghjkjuhyg',0.00,'2022-11-10 15:40:24',5,'','970','','0000-00-00 00:00:00','975','2022-11-10 16:54:48'),(97,'1','289','2022-10-31',1,'poijnbvfdr','','10',202100.00,'40/41','','','6','PH3-AAR-5700','nhjhn',0.00,'2022-11-10 15:41:54',5,'','970','','0000-00-00 00:00:00','975','2022-11-17 13:22:04'),(98,'1','289','2022-11-01',1,'erghjkfg','','10',96914.00,'42','','','6','PH3-AAR-5700','.lkiuyhjkl',0.00,'2022-11-10 15:43:17',5,'','970','','0000-00-00 00:00:00','975','2022-11-17 13:30:03'),(99,'1','289','2022-11-04',1,'ikjhyhbvgf','','10',147500.00,'43','','','6','PH3-AAR-5700','yujhgbh',0.00,'2022-11-10 15:44:10',5,'','970','','0000-00-00 00:00:00','975','2022-11-17 13:28:27'),(100,'1','289','2022-11-23',1,'0581764','','5',37650.00,'44','','','5','PH3-AAR-5700','0581764',60652.80,'2022-11-25 12:34:29',5,'CASH TO BANK','970','975','2022-11-25 13:00:37','975','2022-11-29 15:29:59'),(101,'1','289','2022-11-24',1,'0581763','','5',586110.00,'45','','','5','PH3-AAR-5700','0581763',619609.20,'2022-11-25 12:36:07',5,'CASH TO BANK','970','975','2022-11-25 13:03:05','975','2022-11-29 15:34:54'),(102,'1','289','2022-11-23',1,'DFGHJKLKJN','','5',33000.00,'44','','','6','PH3-AAR-5700','SDFGUYTGH',0.00,'2022-11-25 12:37:56',5,'POS PAYMENT','970','975','2022-11-29 15:29:40','975','2022-11-30 17:08:45'),(103,'1','289','2022-11-24',1,'0581762','','5',478170.00,'46','','','5','PH3-AAR-5700','0581762',719090.40,'2022-11-25 12:41:11',5,'CASH TO BANK','970','975','2022-11-25 13:03:53','975','2022-11-29 15:34:54'),(104,'1','289','2022-11-24',1,'ASDFGHJKMN','','5',240920.00,'46','','','6','PH3-AAR-5700','POS',0.00,'2022-11-25 12:42:14',5,'POS LODGEMENT','970','975','2022-11-29 15:33:43','975','2022-11-30 17:08:45'),(105,'1','289','2022-11-25',1,'0581757','','5',633520.00,'47','','','5','PH3-AAR-5700','0581757',866218.50,'2022-11-25 17:12:56',5,'CASH TO BANK','970','975','2022-11-29 15:35:46','975','2022-11-29 16:03:40'),(106,'1','289','2022-11-25',1,'0581756','','5',678675.00,'49','','','5','PH3-AAR-5700','0581756',919522.80,'2022-11-26 10:00:36',5,'CASH TO BANK','970','975','2022-11-29 15:36:20','975','2022-11-29 16:03:40'),(107,'1','289','2022-11-25',1,'LUHBNMK','','10',240850.00,'49','','','6','PH3-AAR-5700','GYJHK',0.00,'2022-11-26 10:01:39',5,'POS ','970','','0000-00-00 00:00:00','975','2022-11-30 17:08:45'),(108,'1','289','2022-11-26',1,'0282090','','5',1317030.00,'50','','','5','PH3-AAR-5700','0282090',1323761.00,'2022-11-26 16:14:10',5,'CASH TO BANK','970','975','2022-12-02 12:51:09','975','2022-12-02 12:52:35'),(109,'1','289','2022-10-18',1,'0581760','','5',143400.00,'17','','','5','PH3-AAR-5700','0581760',0.00,'2022-11-26 16:26:31',5,'DIRECTOR ALH ZAKARI (STATION  OPENING EXPENSES)','970','975','2022-11-29 16:04:42','975','2022-11-29 16:05:25'),(110,'1','289','2022-11-26',1,'0282088','','5',705820.00,'52','','','5','PH3-AAR-5700','0282088',1106198.10,'2022-11-29 17:45:18',5,'CASH TO BANK','970','975','2022-12-02 12:49:36','975','2022-12-02 12:52:35'),(111,'1','289','2022-11-26',1,'FTYUJBVC','','10',400378.00,'53','','','6','PH3-AAR-5700','JTRFVBJ',0.00,'2022-11-29 17:46:48',5,'POS LODGEMENT','970','','0000-00-00 00:00:00','975','2022-12-01 10:28:59'),(112,'1','289','2022-11-27',1,'0282086','','5',1035500.00,'54','','','5','PH3-AAR-5700','0282086',1035499.50,'2022-11-29 17:48:25',5,'CASH TO BANK','970','975','2022-12-02 12:54:34','975','2022-12-02 12:55:28'),(113,'1','289','2022-11-27',1,'0282087','','5',719600.00,'55','','','5','PH3-AAR-5700','0282087',1152087.30,'2022-11-29 17:50:10',5,'CASH TO BANK','970','975','2022-12-02 12:54:08','975','2022-12-02 12:55:28'),(114,'1','289','2022-11-27',1,'KYTRFCVBNJK','','10',432491.00,'55','','','6','PH3-AAR-5700','CYUHNM',0.00,'2022-11-29 17:51:06',5,'POS LODGEMENT','970','','0000-00-00 00:00:00','975','2022-12-01 10:28:59'),(115,'1','289','2022-11-28',1,'0320372','','5',1104805.00,'56','','','5','PH3-AAR-5700','0320372',1104805.80,'2022-11-29 17:52:29',5,'CASH TO BANK','970','975','2022-12-02 12:56:10','975','2022-12-02 12:57:33'),(116,'1','289','2022-11-28',1,'0320373','','5',475260.00,'56','','','5','PH3-AAR-5700','0320373',872634.00,'2022-11-29 17:53:43',5,'CASH TO BANK','970','975','2022-12-02 12:56:35','975','2022-12-02 12:57:33'),(117,'1','289','2022-11-28',1,'JGBNJK','','10',395875.00,'57','','','6','PH3-AAR-5700','UYTRHB',0.00,'2022-11-29 17:59:16',5,'POS LODGEMENT','970','','0000-00-00 00:00:00','975','2022-12-02 12:57:33'),(118,'1','289','2022-11-29',1,'2022112','','5',1150880.00,'59','','','5','PH3-AAR-5700','2022112',1150491.30,'2022-11-29 18:04:14',5,'CASH TO BANK','970','975','2022-12-02 13:02:41','975','2022-12-06 12:25:10'),(119,'1','289','2022-11-24',1,'EMPRESS','','2',27000.00,'45','','','','PH3-AAR-5700','',0.00,'2022-11-30 17:40:52',5,'CASH EMPRESS','970','975','2022-12-02 15:05:14','975','2022-12-02 15:05:31'),(120,'1','289','2022-10-20',1,'WEIGHT & MEASURE','','2',130000.00,'21','','','','','',0.00,'2022-11-30 17:42:59',0,'ALH SANI HADEJIA','970','975','2022-12-02 15:03:44','','0000-00-00 00:00:00'),(121,'1','289','2022-11-29',1,'0633174','','5',589520.00,'60','','','5','PH3-AAR-5700','0633174',1068274.20,'2022-11-30 17:53:18',5,'CASH TO BANK','970','975','2022-12-06 12:21:28','975','2022-12-06 12:34:19'),(122,'1','289','2022-11-30',1,'0633173','','5',196155.00,'61','','','5','PH3-AAR-5700','0633173',408655.80,'2022-11-30 17:54:58',5,'CASH TO BANK','970','975','2022-12-06 12:19:40','975','2022-12-06 12:23:02'),(123,'1','289','2022-11-29',1,'ERTYUIKJNB','','5',466863.70,'59/60','','','6','PH3-AAR-5700','POS',0.00,'2022-11-30 20:46:06',5,'POS LODGEMENTS','970','975','2022-12-06 12:22:41','975','2022-12-06 12:34:19'),(124,'1','289','2022-11-30',1,'JHGERT','','5',23000.00,'61','','','6','PH3-AAR-5700','WERJKL',0.00,'2022-11-30 20:48:09',5,'POS LODGEMENT','970','975','2022-12-06 12:20:14','975','2022-12-06 12:23:02'),(125,'1','289','2022-11-30',1,'0282100','','5',188000.00,'61','','','5','PH3-AAR-5700','0282100',0.00,'2022-12-01 18:07:39',5,'CASH TO BANK','970','975','2022-12-06 12:20:42','975','2022-12-06 12:23:02'),(126,'1','289','2022-12-06',1,'0581789','','5',175000.00,'62','','','5','PH3-AAR-5700','0581789',454803.30,'2022-12-07 08:59:40',5,'CASH LODGEMENT','970','975','2022-12-15 10:37:58','975','2022-12-15 10:38:16'),(127,'1','289','2022-12-06',1,'SDFGHJKJHG','','2',52800.00,'62','','','','','',0.00,'2022-12-07 09:00:54',5,'AGO CONSUMPTION','970','975','2022-12-08 14:45:14','975','2022-12-15 10:38:16'),(128,'1','289','2022-12-06',1,'0849351','','5',158100.00,'62','','','5','PH3-AAR-5700','0849351',0.00,'2022-12-16 21:00:08',5,'POS DECLINED, WAITING FOR REVERSAL ','970','975','2022-12-19 10:40:40','975','2022-12-28 14:54:21'),(129,'1','289','2023-02-11',1,'34ESDRTFGVYBHUNJKM','','10',238500.00,'00','','','6','PH3-AAR-5700','WSEDRTFGYHUJINKM',0.00,'2023-02-11 23:00:59',5,'','970','','0000-00-00 00:00:00','975','2023-02-16 15:39:39'),(130,'1','289','2023-02-11',1,'WAERFT','','2',212500.00,'00','','','','','',0.00,'2023-02-11 23:03:14',5,'HAULAGE :\r\nRAN-972-XA (LPG) 250LTRS @ 790 + 15,000\r\nPHC TO CALABAR','970','','0000-00-00 00:00:00','975','2023-02-15 16:49:49'),(131,'1','289','2023-02-11',1,'WWWERT','','2',173000.00,'00','','','','','',0.00,'2023-02-11 23:05:06',5,'HAULAGE:\r\nFKJ-74-XT 200 LTRS @ 790 + 15,000\r\nPHC TO AKWA-IBOM','970','','0000-00-00 00:00:00','975','2023-02-15 16:49:49'),(132,'1','289','2023-02-11',1,'SDFGH','','2',71100.00,'00','','','','','',0.00,'2023-02-11 23:06:28',5,'GENERATOR CONSUMPTION FOR 3 DAYS USE','970','','0000-00-00 00:00:00','975','2023-02-15 16:49:49'),(133,'1','289','2023-02-11',1,'101471726','','5',292500.00,'00','','','5','PH3-AAR-5700','10141726',987563.20,'2023-02-11 23:09:33',5,'CASH TO BANK','970','','0000-00-00 00:00:00','975','2023-03-01 17:13:16'),(134,'1','289','2023-02-12',1,'10147172','','5',416720.00,'00','','','5','PH3-AAR-5700','1014172',1059026.60,'2023-02-12 22:39:25',5,'CASH TO BANK','970','','0000-00-00 00:00:00','975','2023-03-01 17:13:16'),(135,'1','289','2023-02-12',1,'DFGHJN','','10',591810.00,'00','','','6','PH3-AAR-5700','KJHGFCVGBH',0.00,'2023-02-12 22:41:14',5,'POS LODGEMENT','970','','0000-00-00 00:00:00','975','2023-02-16 15:40:16'),(136,'1','289','2023-02-12',1,'ZCVB','','2',23500.00,'00','','','','','',0.00,'2023-02-12 22:42:31',0,'AUTHORITY BY DIR. I. ATTAMRA\r\nSTATION REPAIR','970','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(137,'1','289','2023-02-12',1,'KJHGFV','','2',27000.00,'00','','','','','',0.00,'2023-02-12 22:43:37',5,'DECEMBER 2022 CASH IMPRESS','970','','0000-00-00 00:00:00','975','2023-02-21 14:52:04'),(138,'1','289','2023-02-13',1,'1014717','','5',2053030.00,'00','','','5','PH3-AAR-5700','101417',2158530.00,'2023-02-14 00:52:26',5,'CASH TO BANK','970','','0000-00-00 00:00:00','975','2023-03-01 17:12:46'),(139,'1','289','2023-02-13',1,'LKJHJGFGTD','','10',105500.00,'00','','','6','PH3-AAR-5700','ERTFGYHUIJ',0.00,'2023-02-14 00:53:42',5,'POS LODGEMENT','970','','0000-00-00 00:00:00','975','2023-02-16 15:39:52'),(140,'1','289','2023-02-14',1,'.KJHGF','','5',19875.00,'00','','','6','PH3-AAR-5700','DDFGHJKMNB',19947.50,'2023-02-15 11:00:46',5,'POS LODGEMENT','970','975','2023-02-21 14:51:44','975','2023-02-21 14:51:52'),(141,'1','289','2023-02-16',1,'0973468','','5',340300.00,'67','','','5','PH3-AAR-5700','0973468',590272.20,'2023-02-22 07:20:23',5,'Bank','970','','0000-00-00 00:00:00','975','2023-03-04 13:25:21'),(142,'1','289','2023-02-16',1,'Lbggv','','10',178875.00,'67','','','6','PH3-AAR-5700','Hhgdduu',0.00,'2023-02-22 07:21:43',5,'POS','970','','0000-00-00 00:00:00','975','2023-03-02 14:01:27'),(143,'1','289','2023-02-16',1,'Fuiihh','','2',171100.00,'67','','','','','',0.00,'2023-02-22 07:23:01',5,'Generator AGO consumption ','970','','0000-00-00 00:00:00','975','2023-03-01 17:15:06'),(144,'1','289','2023-02-17',1,'WARTYUI','','10',326500.00,'68','','','6','PH3-AAR-5700','POIUG',326499.10,'2023-02-25 23:19:12',5,'POS LODGEMENT','970','','0000-00-00 00:00:00','975','2023-03-02 14:01:27'),(145,'1','289','2023-02-20',1,'FGHJKOI','','10',400000.00,'69','','','6','PH3-AAR-5700','ESRDTFYGUHIKJL,',400000.70,'2023-02-26 13:40:52',5,'POS LODGEMENT','970','','0000-00-00 00:00:00','975','2023-03-02 14:01:27'),(146,'1','289','2023-02-23',1,'FGHJKLKJHGVBNHJ','','10',1061000.00,'72','','','6','PH3-AAR-5700','SERTYHBHJK',1060575.00,'2023-03-02 23:56:05',5,'POS LODGEMENT','970','','0000-00-00 00:00:00','975','2023-03-03 10:23:12'),(147,'1','289','2023-02-21',1,'1014717262','','5',108050.00,'70','','','5','PH3-AAR-5700','101471726',552044.10,'2023-03-03 00:00:30',5,'CASH TO BANK','970','','0000-00-00 00:00:00','975','2023-03-04 13:25:30'),(148,'1','289','2023-02-21',1,'2033XOYF,./','','10',444000.00,'70','','','6','PH3-AAR-5700','2033XOYF,./',0.00,'2023-03-03 00:03:29',5,'POS LODGEMENT','970','','0000-00-00 00:00:00','975','2023-03-03 10:23:12'),(149,'1','289','2023-02-22',1,'2033256','','5',10000.00,'71','','','5','PH3-AAR-5700','2033256',634030.30,'2023-03-03 00:08:47',5,'CASH TO BANK','970','','0000-00-00 00:00:00','975','2023-03-03 10:23:11'),(150,'1','289','2023-02-22',1,'101471JIHUGCYGU','','10',624030.00,'71','','','6','PH3-AAR-5700','CFGYUKJK',0.00,'2023-03-03 00:11:16',5,'POS LODGEMENT','970','','0000-00-00 00:00:00','975','2023-03-03 10:23:11'),(151,'1','289','2023-02-24',1,'EFCC','','2',7980000.00,'73','','','','','',0.00,'2023-03-03 21:47:12',5,'SUPPLY OF 10,000 LTRS TO EFCC PORTHARCOURT','970','','0000-00-00 00:00:00','975','2023-03-07 16:57:30'),(152,'1','289','2023-02-24',1,'MNVCFR6YU','','2',7110000.00,'73','','','','','',0.00,'2023-03-03 21:48:52',0,'SUPPLY TO BAYELSA POLICE COMMAND\r\n9,000 LTRS','970','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(153,'1','289','2023-02-24',1,'HJK,MJH','','2',212500.00,'73','','','','','',0.00,'2023-03-03 21:50:45',5,'ABS-700-XA 250 LTRS + 15,000\r\nWARRI TO PORTHARCOURT','970','','0000-00-00 00:00:00','975','2023-03-04 13:27:04'),(154,'1','289','2023-02-24',1,'DFGHJ','','2',165900.00,'73','','','','','',15468397.50,'2023-03-03 21:52:21',5,'GENERATOR CONSUMPTION FOR ONE WEEK','970','','0000-00-00 00:00:00','975','2023-03-04 13:27:04'),(156,'1','289','2023-03-02',1,'UYTRDCVBNM','','5',439560.00,'75','','','5','PH3-AAR-5700','SDFGBHNM',830891.85,'2023-03-08 14:45:22',5,'CASH TO BANK','970','','0000-00-00 00:00:00','975','2023-03-10 10:53:30'),(157,'1','289','2023-03-02',1,'ASDFGHJJHGF','','5',1191083.00,'74/75','','','6','PH3-AAR-5700','FGHJKJHN',811259.95,'2023-03-08 14:49:43',5,'POS LODGEMENT','970','975','2023-03-11 17:11:07','975','2023-03-11 17:11:55'),(158,'1','289','2023-03-03',1,'kjbvbn','','5',314650.00,'76','','','5','PH3-AAR-5700','dfghjk',0.00,'2023-03-08 15:09:41',5,'cash to bank','970','975','2023-03-08 16:02:22','975','2023-03-10 10:54:32'),(159,'1','289','2023-03-03',1,'.kjhb','','10',954532.00,'76','','','6','PH3-AAR-5700',',mnbv',1269183.30,'2023-03-08 15:10:33',5,'pos lodgement','970','','0000-00-00 00:00:00','975','2023-03-11 17:12:13'),(160,'1','289','2023-03-04',1,'DYHH','','5',18000.00,'77','','','5','PH3-AAR-5700','XFGHJK',1798490.25,'2023-03-08 15:55:46',5,'CASH TO BANK','970','','0000-00-00 00:00:00','975','2023-03-10 10:54:54'),(161,'1','289','2023-03-04',1,'ZSRJHG','','10',1415989.25,'77','','','6','PH3-AAR-5700','MNHGFG',0.00,'2023-03-08 15:56:47',5,'POS LODGEMENT','970','','0000-00-00 00:00:00','975','2023-03-11 17:12:40'),(162,'1','289','2023-03-04',1,'VFYUJH','','2',364500.00,'77','','','','','',0.00,'2023-03-08 16:31:40',0,'AGO CONSUMPTION','970','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(163,'1','289','2023-03-06',1,'DFGHJGV','','5',1495755.00,'78','','','5','PH3-AAR-5700','EFGBNM',2086980.95,'2023-03-08 16:40:36',5,'CASH TO BANK','970','','0000-00-00 00:00:00','975','2023-03-10 10:55:33'),(164,'1','289','2023-03-06',1,'NFGBNM','','10',591228.00,'78','','','6','PH3-AAR-5700',' VGHNMKJHN',0.00,'2023-03-08 16:41:49',5,'POS LODGEMENT','970','','0000-00-00 00:00:00','975','2023-03-11 17:13:05'),(165,'1','289','2023-03-06',1,'KJHGFDFGH','','2',660000.00,'79','','','','','',678400.00,'2023-03-08 16:57:50',5,'HAULAGE;  KMC-662-ZE 800 LTRS + N 20,000','970','','0000-00-00 00:00:00','975','2023-03-10 10:55:33'),(166,'1','289','2023-03-06',1,'KJHGVC','','5',18000.00,'79','','','5','PH3-AAR-5700','.;;KJHB',0.00,'2023-03-08 16:58:58',5,'CASH TO BANK','970','','0000-00-00 00:00:00','975','2023-03-10 10:55:33'),(167,'1','289','2023-03-07',1,'KJHGFCX','','5',1348300.00,'80','','','5','PH3-AAR-5700','KJHGV',2479856.30,'2023-03-09 15:20:46',5,'CASH TO BANK','970','','0000-00-00 00:00:00','975','2023-03-15 12:23:21'),(168,'1','289','2023-03-07',1,',KJHGV','','10',1131553.00,'80','','','6','PH3-AAR-5700','.KJHGVC',0.00,'2023-03-09 15:21:44',5,'POS LODGEMENT','970','','0000-00-00 00:00:00','975','2023-03-11 17:18:05'),(169,'1','289','2023-03-07',1,'DFGHKJH','','5',1757100.00,'81','','','5','PH3-AAR-5700',',MNBVBN',0.00,'2023-03-09 15:24:07',5,'CASH TO BANK','970','975','2023-03-10 10:52:36','975','2023-03-15 12:23:21'),(170,'1','289','2023-03-07',1,',NBV ','','2',375000.00,'81','','','','','',2132096.00,'2023-03-09 15:25:32',5,'HAULAGE: RAN-807-XA 450 LTRS @ 800 + 15,000','970','','0000-00-00 00:00:00','975','2023-03-10 10:51:57'),(171,'1','289','2023-03-08',1,'LKJHGVBN','','5',1420000.00,'82','','','5','PH3-AAR-5700','CGHJN ',3290699.20,'2023-03-09 18:40:46',5,'CASH TO BANK','970','','0000-00-00 00:00:00','975','2023-03-15 12:23:21'),(172,'1','289','2023-03-08',1,',MNBVC ','','10',245720.00,'82','','','6','PH3-AAR-5700','MNBV  ',0.00,'2023-03-09 18:42:13',5,'POS LODGEMENT','970','','0000-00-00 00:00:00','975','2023-03-11 17:18:41'),(173,'1','289','2023-03-08',1,'UYGFGHJK','','2',210000.00,'82','','','','','',0.00,'2023-03-09 18:43:36',5,'HAULAGE : RAN-831-XA = 250 LTRS + 10,000 NAIRA','970','','0000-00-00 00:00:00','975','2023-03-11 17:18:41'),(174,'1','289','2023-03-08',1,'JHGF ','','2',745000.00,'82','','','','','',0.00,'2023-03-09 18:45:27',5,'HAULAGE : RAN-826-XA (LPG) = 900 LTRS + 25,000 NAIRA','970','','0000-00-00 00:00:00','975','2023-03-11 17:18:41'),(175,'1','289','2023-03-08',1,'GTGVJ','','2',335000.00,'82','','','','','',0.00,'2023-03-09 18:47:09',5,'HAULAGE: KMC-662-ZE 400LTRS + 15,000 NAIRA','970','','0000-00-00 00:00:00','975','2023-03-10 10:56:32'),(176,'1','289','2023-03-08',1,' CFTYHN ','','2',335000.00,'82','','','','','',0.00,'2023-03-09 18:48:33',5,'HAULAGE: KMC-654-ZE 400LTRS + 15,000 NAIRA','970','','0000-00-00 00:00:00','975','2023-03-10 10:56:31'),(178,'1','289','2023-03-09',1,'HGFDTYJK','','5',1649650.00,'84','','','5','PH3-AAR-5700','LKYUIK',3071676.05,'2023-03-10 15:08:29',5,'CASH TO BANK','970','','0000-00-00 00:00:00','975','2023-03-15 12:25:21'),(179,'1','289','2023-03-09',1,'LKJHJKLKM','','10',1002025.00,'84','','','6','PH3-AAR-5700','CFGHJKL',0.00,'2023-03-10 15:09:33',5,'POS LODGEMENT','970','','0000-00-00 00:00:00','975','2023-03-16 15:29:50'),(180,'1','289','2023-03-09',1,'YRTLKMNBV','','2',210000.00,'84','','','','','',0.00,'2023-03-10 15:14:41',5,'HAULAGE: RAN-920-XA = 250LTRS + 10,000','970','','0000-00-00 00:00:00','975','2023-03-11 17:18:21'),(181,'1','289','2023-03-09',1,'ERFGKHBV','','2',210000.00,'84','','','','','',0.00,'2023-03-10 15:15:55',5,'TRN-34-YZ = 250LTRS + 10,000','970','','0000-00-00 00:00:00','975','2023-03-11 17:18:21'),(182,'1','289','2023-03-07',1,'DFGHNM,','','5',40970.00,'80','','','5','PH3-AAR-5700','WDFGHJM',0.00,'2023-03-10 15:24:11',0,'CASH TO BANK','970','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(183,'1','289','2023-03-10',1,'ERGHJ,','','5',3120350.00,'85','','','5','PH3-AAR-5700','MNHGFRE',5152549.55,'2023-03-11 11:25:47',5,'CASH TO BANK','970','','0000-00-00 00:00:00','975','2023-03-15 12:25:21'),(184,'1','289','2023-03-10',1,'WDFGHJIUJ','','10',572200.00,'85','','','6','PH3-AAR-5700','POIHBN',0.00,'2023-03-11 11:28:14',5,'POS LODGEMENT','970','','0000-00-00 00:00:00','975','2023-03-16 15:30:31'),(185,'1','289','2023-03-10',1,'MHGFVBHN','','2',210000.00,'85','','','','','',0.00,'2023-03-11 11:34:38',5,'HAULAGE: NSR-515-ZU 250LTSR @ 800 + 10,000. WRR/PHC','970','','0000-00-00 00:00:00','975','2023-03-15 12:25:21'),(186,'1','289','2023-03-10',1,'NJHUJ','','2',295000.00,'85','','','','','',0.00,'2023-03-11 11:37:50',5,'HAULAGE: NSR-515-ZU 350LTRS @ 800 + 15,000','970','','0000-00-00 00:00:00','975','2023-03-15 12:25:21'),(187,'1','289','2023-03-10',1,'WFHK','','2',745000.00,'85','','','','','',0.00,'2023-03-11 11:39:07',5,'HAULAGE: NSR-858-ZQ 900LTRS @ 800 + 25,000','970','','0000-00-00 00:00:00','975','2023-03-15 12:26:03'),(188,'1','289','2023-03-10',1,'UYHVF','','2',210000.00,'85','','','','','',0.00,'2023-03-11 11:40:17',5,'HAULAGE: NSR-807-XA 250LTRS @ 800 + 10,000','970','','0000-00-00 00:00:00','975','2023-03-15 12:26:03'),(189,'1','289','2023-03-11',1,';LKJHG','','5',2542015.00,'86','','','5','PH3-AAR-5700','CDERVTBYNUMI,O.P/[}|',3657984.15,'2023-03-12 23:05:48',5,'CASH TO BANK','970','','0000-00-00 00:00:00','975','2023-03-15 12:26:03'),(190,'1','289','2023-03-11',1,'RTYGUHIKOP[','','10',1090570.00,'86','','','6','PH3-AAR-5700','YVGUHNJKML,;\'',0.00,'2023-03-12 23:08:34',5,'PAYMENT ON POS','970','','0000-00-00 00:00:00','975','2023-03-16 15:33:18'),(192,'1','289','2023-03-11',1,'FTYHNM','','2',375000.00,'86','','','','','',854600.00,'2023-03-12 23:22:07',5,'RAN-831-XA 450 LTRS @ 800 + 15,000','970','975','2023-03-15 12:29:24','975','2023-03-15 12:29:46'),(193,'1','289','2023-03-11',1,'.LKJHG','','2',505000.00,'86','','','','','',0.00,'2023-03-12 23:24:08',5,'KKM-203-XA 600LTRS @ 800 + 25,000','970','','0000-00-00 00:00:00','975','2023-03-15 12:29:46'),(194,'1','289','2023-03-13',1,'ESDRFGHBJM','','5',3393710.00,'87','','','5','PH3-AAR-5700','F',4469651.45,'2023-03-14 11:06:41',0,'CASH TO BANK','970','975','2023-03-16 15:36:05','','0000-00-00 00:00:00'),(195,'1','289','2023-03-13',1,'ESZRDFCGHJ','','10',445861.00,'87','','','6','PH3-AAR-5700','S6P[',0.00,'2023-03-14 11:08:08',5,'PAYMENT ON POS','970','','0000-00-00 00:00:00','975','2023-03-16 15:37:48'),(196,'1','289','2023-03-13',1,'CRT','','2',295000.00,'87','','','','','',0.00,'2023-03-14 11:25:14',5,'GWL-538-YJ 350 LTRS + 15,000= 295  TRN-34-YZ 400 LTRS + 15,000= 335,000','970','','0000-00-00 00:00:00','975','2023-03-16 15:37:48'),(197,'1','289','2023-03-13',1,'NBGYHJ','','2',335000.00,'87','','','','','',0.00,'2023-03-16 16:44:04',5,'HAULAGE : TRN-34-YZ = 400LTRS @ 800 + 15,000','970','','0000-00-00 00:00:00','975','2023-03-17 13:50:49'),(198,'1','289','2023-03-14',1,',JHB','','5',3140040.00,'89','','','5','PH3-AAR-5700','MNBVG',4356303.85,'2023-03-16 16:54:59',0,'CASH DEPOSITED TO BANK','970','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(199,'1','289','2023-03-14',1,'.,MNB','','10',845763.00,'89','','','6','PH3-AAR-5700',' VGHN',0.00,'2023-03-16 16:57:07',0,'POS LODGEMENTS','970','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(200,'1','289','2023-03-14',1,'KJHN','','2',370500.00,'89','','','','','',0.00,'2023-03-16 17:09:48',5,'HAULAGE: NSR-855-ZU = 450LTRS @ 790 + 15,000','970','','0000-00-00 00:00:00','975','2023-03-17 14:53:55'),(202,'1','289','2023-03-15',1,'BGYH','','5',2319920.00,'90','','','5','PH3-AAR-5700','CFGYHN',4773019.45,'2023-03-16 17:15:46',0,'CASH TO BANK','970','975','2023-03-17 14:18:03','','0000-00-00 00:00:00'),(203,'1','289','2023-03-15',1,'CFRZXD','','10',794100.00,'90','','','6','PH3-AAR-5700','WSGN',0.00,'2023-03-16 17:16:49',0,'POS  LODGEMENTS','970','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(204,'1','289','2023-03-15',1,'WDFJKLL','','2',578000.00,'90','','','','','',0.00,'2023-03-16 17:18:29',5,'FGE-986-ZY 700LTRS @ 790 + 25,000','970','','0000-00-00 00:00:00','975','2023-03-17 15:49:55'),(205,'1','289','2023-03-15',1,'A','','2',449000.00,'90','','','','','',0.00,'2023-03-16 17:19:51',5,'NSR-855-ZU 600LTRS @ 790 + 25,000','970','','0000-00-00 00:00:00','975','2023-03-17 15:49:55'),(206,'1','289','2023-03-15',1,'JH','','2',79000.00,'90','','','','','',0.00,'2023-03-16 17:22:58',5,'NSR-855-ZU 100LTRS @790','970','','0000-00-00 00:00:00','975','2023-03-17 15:49:55'),(207,'1','289','2023-03-15',1,'BHHB','','2',179500.00,'90','','','','','',0.00,'2023-03-16 17:24:40',5,'RAN-831-XA 250LTRS @ 790 + 10,000','970','','0000-00-00 00:00:00','975','2023-03-17 15:49:55'),(208,'1','289','2023-03-15',1,'M','','2',355500.00,'90','','','','','',0.00,'2023-03-16 17:26:40',0,'GENERATOR CONSUMPTION 450 LTRS @ 790 FOR 15 DAYS USES ','970','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(209,'1','289','2023-03-16',1,'RGJ','','5',953715.00,'91','','','5','PH3-AAR-5700','NHF',3193565.40,'2023-03-17 14:10:38',0,'','970','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(210,'1','289','2023-03-16',1,'Q246','','2',1400000.00,'91','','','','','',0.00,'2023-03-17 14:14:10',0,'CHAIRMAN\'S CASH RAISING, COLLECTED BY AREA MANAGER YUNUSA ALIYU','970','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(211,'1','289','2023-03-16',1,'NJH','','10',839850.00,'91','','','6','PH3-AAR-5700','NUY',0.00,'2023-03-17 14:15:29',0,'POS LODGEMENTS','970','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(212,'1','289','2023-03-17',1,'956MNH','','5',3029595.00,'92','','','5','PH3-AAR-5700','23/KJH',4565515.00,'2023-03-18 18:48:26',0,'LODGED TO BANK','970','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(213,'1','289','2023-03-17',1,'1,K.','','10',842720.00,'92','','','6','PH3-AAR-5700','1KJ',0.00,'2023-03-18 18:49:26',0,'POS LODGEMENT','970','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(214,'1','289','2023-03-17',1,';85','','2',394200.00,'92','','','','','',0.00,'2023-03-18 18:50:32',0,'RAN-920-XA = 480 @ 790 + 15,000','970','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(215,'1','289','2023-03-17',1,'./\'5','','2',300000.00,'92','','','','','',0.00,'2023-03-18 18:51:56',0,'CHAIRMAN\'S CASH RAISING THROUGH AREA MANAGER','970','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(216,'1','289','2023-02-24',1,'POLICE','','2',9870000.00,'93','','','','','',9870000.00,'2023-03-20 14:42:02',0,'POLICE ELECTION FUEL','970','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `purchases_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_receptions`
--

DROP TABLE IF EXISTS `purchases_receptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_receptions` (
  `bridge_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `purchase_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `loadingdate` datetime NOT NULL,
  `loadingpoint` varchar(100) DEFAULT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `received` decimal(20,2) NOT NULL,
  `distributed` decimal(20,2) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `vessel` varchar(50) NOT NULL,
  `drivername` varchar(30) NOT NULL,
  `driverphone` varchar(30) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`bridge_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`supplier_id`,`loadingdate`,`quantity`,`waybill`,`meterno`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`purchase_id`),
  KEY `truck_id` (`tank_id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_receptions`
--

LOCK TABLES `purchases_receptions` WRITE;
/*!40000 ALTER TABLE `purchases_receptions` DISABLE KEYS */;
INSERT INTO `purchases_receptions` VALUES (3,'1',1,'289',1,1,'2022-10-26 00:00:00','AA RANO NIG LTD ',13200.00,13200.00,0.00,'Nil','','1','RAN849XA','Ammar','09164644145','Discharge successfully ',5,'2022-10-26 16:51:44','970','0000-00-00 00:00:00','','2022-10-26 16:55:04','970'),(4,'1',1,'289',1,1,'2022-10-26 00:00:00','AA RANO NIG LTD ',18000.00,18000.00,0.00,'Nil','','3','RAN849XA','Ammar','09164644145','Discharge successfully ',5,'2022-10-26 16:51:44','970','0000-00-00 00:00:00','','2022-10-26 16:54:48','970'),(5,'1',1,'289',1,1,'2022-10-26 00:00:00','AA RANO NIG LTD ',17000.00,17000.00,0.00,'Nil','','2','RAN849XA','Ammar','09164644145','Discharge successfully ',5,'2022-10-26 16:51:44','970','0000-00-00 00:00:00','','2022-10-26 16:54:17','970'),(6,'1',2,'289',1,1,'2022-10-29 00:00:00','AA RANO',24000.00,24000.00,0.00,'','','1','NSR488ZU','SULAIMAN','','DISCHAGED',5,'2022-10-29 11:14:37','970','0000-00-00 00:00:00','','2022-10-29 11:15:03','970'),(8,'1',2,'289',1,1,'2022-10-29 00:00:00','AA RANO',10000.00,10000.00,0.00,'','','1','NSR488ZU','SULAIMAN','','DISCHAGED',5,'2022-10-29 16:02:43','970','0000-00-00 00:00:00','','2022-10-29 16:03:15','970'),(9,'1',2,'289',1,1,'2022-10-29 00:00:00','AA RANO',16000.00,16000.00,0.00,'','','2','NSR488ZU','SULAIMAN','','DISCHAGED',5,'2022-10-29 18:11:46','970','0000-00-00 00:00:00','','2022-10-29 18:12:09','970'),(10,'1',3,'289',1,1,'2022-11-24 00:00:00','AA RANO',60000.00,60000.00,0.00,'','','1','KMC667ZE','AMINU MALAM','07039499861','DISCHAGED',5,'2022-11-24 11:35:57','970','0000-00-00 00:00:00','','2022-11-24 11:36:48','970'),(11,'1',1,'289',1,1,'2022-12-05 00:00:00','AA RANO NIG LTD ',1800.00,1800.00,0.00,'','','1','RAN849XA','Ammar','09164644145','Driver\'s short',5,'2022-12-05 22:01:14','970','0000-00-00 00:00:00','','2022-12-05 22:02:03','970'),(12,'1',4,'289',2,1,'2023-02-11 00:00:00','AA RANO NIG LTD ',30000.00,30000.00,0.00,'','','4','TRN-16-YZ','ALH DAYYANU','08039370794','DISCHAGED',5,'2023-02-11 12:59:50','970','0000-00-00 00:00:00','','2023-02-11 13:00:24','970'),(13,'1',5,'289',1,1,'2023-03-05 00:00:00','AA RANO NIG LTD ',50000.00,50000.00,0.00,'2007325','','1','KMC717ZJ','ABDULLAHI DAURA','07037673012','DISCHAGED',5,'2023-03-05 10:29:56','970','0000-00-00 00:00:00','','2023-03-05 10:30:30','970'),(14,'1',6,'289',2,1,'2023-03-07 00:00:00','AA RANO NIG LTD ',45000.00,45000.00,0.00,'','','4','KMC-662-ZE','SHEHU MUSA BUNKURE','08032273354','Discharge successfully ',5,'2023-03-07 21:34:31','970','0000-00-00 00:00:00','','2023-03-07 21:35:18','970'),(15,'1',8,'289',1,1,'2023-03-10 00:00:00','AA RANO NIG LTD ',50000.00,50000.00,0.00,'','','1','RAN-920-XA','','','',5,'2023-03-10 09:56:10','970','0000-00-00 00:00:00','','2023-03-10 09:56:33','970'),(16,'1',9,'289',1,1,'2023-03-12 00:00:00','AA RANO NIG LTD ',60000.00,60000.00,0.00,'','','1','TRN-34-ZY','','','DISCHAGED',5,'2023-03-12 22:40:54','970','0000-00-00 00:00:00','','2023-03-12 22:41:25','970'),(17,'1',10,'289',1,1,'2023-03-15 00:00:00','AA RANO NIG LTD ',45000.00,45000.00,0.00,'','','1','RAN-807-XA','','','Received ',5,'2023-03-15 21:47:59','970','0000-00-00 00:00:00','','2023-03-15 21:49:01','970'),(18,'1',11,'289',1,1,'2023-03-16 00:00:00','AA RANO NIG LTD ',45000.00,45000.00,0.00,'2007617','','1','RAN-831-XA','IBRAHIM ABUBAKAR','08033664032','Discharge successfully ',5,'2023-03-16 16:18:15','970','0000-00-00 00:00:00','','2023-03-16 16:18:54','970'),(19,'1',7,'289',1,1,'2023-02-24 00:00:00',NULL,42000.00,0.00,0.00,'','','','ABS-700-XA','','','Distributed to NIGERIA POLICE FORCE (ELECTION for sale #1',10,'2023-03-20 08:47:47','970','0000-00-00 00:00:00','','2023-03-20 08:47:47','970');
/*!40000 ALTER TABLE `purchases_receptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports`
--

DROP TABLE IF EXISTS `reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `type` varchar(20) NOT NULL,
  `sql` text NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`report_id`),
  KEY `companycode` (`company_id`,`name`,`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports`
--

LOCK TABLES `reports` WRITE;
/*!40000 ALTER TABLE `reports` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_fields`
--

DROP TABLE IF EXISTS `reports_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(20) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `fieldname` varchar(50) NOT NULL,
  `order` int NOT NULL,
  `visibility` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`report_id`,`field_id`,`order`,`visibility`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_fields`
--

LOCK TABLES `reports_fields` WRITE;
/*!40000 ALTER TABLE `reports_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_filters`
--

DROP TABLE IF EXISTS `reports_filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_filters` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(50) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `filter_id` int NOT NULL AUTO_INCREMENT,
  `criteria` varchar(20) NOT NULL,
  `value` varchar(100) NOT NULL,
  PRIMARY KEY (`filter_id`),
  KEY `companycode` (`company_id`,`report_id`),
  KEY `field_id` (`field_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_filters`
--

LOCK TABLES `reports_filters` WRITE;
/*!40000 ALTER TABLE `reports_filters` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_filters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_customers`
--

DROP TABLE IF EXISTS `retail_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_customers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`name`,`phone`,`email`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_customers`
--

LOCK TABLES `retail_customers` WRITE;
/*!40000 ALTER TABLE `retail_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory`
--

DROP TABLE IF EXISTS `retail_inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` int NOT NULL,
  `qtyout` int NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory`
--

LOCK TABLES `retail_inventory` WRITE;
/*!40000 ALTER TABLE `retail_inventory` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_balances`
--

DROP TABLE IF EXISTS `retail_inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_balances`
--

LOCK TABLES `retail_inventory_balances` WRITE;
/*!40000 ALTER TABLE `retail_inventory_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_costs`
--

DROP TABLE IF EXISTS `retail_inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_costs`
--

LOCK TABLES `retail_inventory_costs` WRITE;
/*!40000 ALTER TABLE `retail_inventory_costs` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products`
--

DROP TABLE IF EXISTS `retail_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`name`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `parent_id` (`parent_id`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products`
--

LOCK TABLES `retail_products` WRITE;
/*!40000 ALTER TABLE `retail_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_prices`
--

DROP TABLE IF EXISTS `retail_products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_prices`
--

LOCK TABLES `retail_products_prices` WRITE;
/*!40000 ALTER TABLE `retail_products_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_reconciliations`
--

DROP TABLE IF EXISTS `retail_products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_reconciliations`
--

LOCK TABLES `retail_products_reconciliations` WRITE;
/*!40000 ALTER TABLE `retail_products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_purchases`
--

DROP TABLE IF EXISTS `retail_purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_purchases`
--

LOCK TABLES `retail_purchases` WRITE;
/*!40000 ALTER TABLE `retail_purchases` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales`
--

DROP TABLE IF EXISTS `retail_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `saledate` date NOT NULL,
  `customer_id` varchar(20) NOT NULL DEFAULT '',
  `customer_name` varchar(50) NOT NULL,
  `customer_phone` varchar(30) NOT NULL,
  `quantity_kg` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `payment_method` varchar(10) NOT NULL,
  `payment_account_type` varchar(20) NOT NULL,
  `payment_account_id` varchar(20) NOT NULL,
  `paid` decimal(20,2) DEFAULT NULL,
  `change` decimal(20,2) DEFAULT '0.00',
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`customer_name`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `payment_method` (`payment_method`,`payment_account_type`,`payment_account_id`),
  KEY `customer_id` (`customer_id`),
  KEY `change` (`change`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales`
--

LOCK TABLES `retail_sales` WRITE;
/*!40000 ALTER TABLE `retail_sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_items`
--

DROP TABLE IF EXISTS `retail_sales_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `product_type` varchar(10) NOT NULL,
  `product_name` varchar(100) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `quantity_2` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `parent_cost` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`sale_id`,`product_id`,`rate`,`quantity`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`product_type`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `parent_id` (`parent_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_items`
--

LOCK TABLES `retail_sales_items` WRITE;
/*!40000 ALTER TABLE `retail_sales_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_payments`
--

DROP TABLE IF EXISTS `retail_sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_payments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `payment_method` varchar(50) NOT NULL,
  `account_type` varchar(10) DEFAULT NULL,
  `account_id` bigint DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`sale_id`,`payment_method`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`account_type`),
  KEY `parent_id` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_payments`
--

LOCK TABLES `retail_sales_payments` WRITE;
/*!40000 ALTER TABLE `retail_sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales`
--

DROP TABLE IF EXISTS `sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `is_credit` int NOT NULL DEFAULT '0',
  `saledate` date NOT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `paid` int NOT NULL,
  `details` text NOT NULL,
  `ledger_notes` varchar(150) DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`product_id`,`customer_id`,`rate`,`quantity`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`is_credit`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales`
--

LOCK TABLES `sales` WRITE;
/*!40000 ALTER TABLE `sales` DISABLE KEYS */;
INSERT INTO `sales` VALUES (1,'1','289','93',0,'2023-02-24',1,1,235.00,235.00,42000.00,0.00,0.00,9870000.00,'03200842','2023-03-20 08:43:12',15,0,'',NULL,'970','','0000-00-00 00:00:00','970','2023-03-20 08:44:16');
/*!40000 ALTER TABLE `sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_daily`
--

DROP TABLE IF EXISTS `sales_daily`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_daily` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `saledate` date NOT NULL,
  `average` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `target` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`average`,`saledate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_daily`
--

LOCK TABLES `sales_daily` WRITE;
/*!40000 ALTER TABLE `sales_daily` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_daily` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions`
--

DROP TABLE IF EXISTS `sales_distributions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions` (
  `distribution_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `sale_id` int NOT NULL,
  `purchase_id` varchar(20) NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `loadingdate` date NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `destination` varchar(50) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `truckno` varchar(20) NOT NULL,
  `drivername` varchar(50) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`distribution_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`loadingdate`,`quantity`,`destination`,`waybill`,`meterno`,`nozzle_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`tank_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `truckno` (`truckno`),
  KEY `purchase_id_2` (`purchase_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions`
--

LOCK TABLES `sales_distributions` WRITE;
/*!40000 ALTER TABLE `sales_distributions` DISABLE KEYS */;
INSERT INTO `sales_distributions` VALUES (1,'1',1,'7',19,'289',1,1,'2023-02-24',42000.00,'BOROKIRI POLICE FILLING STATION','','','','','ABS-700-XA','','BULK SALES',5,'2023-03-20 08:46:32','970','0000-00-00 00:00:00','','2023-03-20 08:47:47','970');
/*!40000 ALTER TABLE `sales_distributions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_delivery`
--

DROP TABLE IF EXISTS `sales_distributions_delivery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_delivery` (
  `delivery_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `distribution_id` int NOT NULL,
  `sale_id` int NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `quantity` int NOT NULL,
  `truck_id` int NOT NULL,
  `deliveredon` date NOT NULL,
  `details` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`delivery_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`quantity`,`thedate`,`createdby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`truck_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `distribution_id` (`distribution_id`),
  KEY `deliveredon` (`deliveredon`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_delivery`
--

LOCK TABLES `sales_distributions_delivery` WRITE;
/*!40000 ALTER TABLE `sales_distributions_delivery` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_delivery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_trucks`
--

DROP TABLE IF EXISTS `sales_distributions_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_trucks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sale_id` varchar(20) NOT NULL,
  `distribution_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `bridge_id` varchar(20) NOT NULL,
  `truck_id` varchar(20) NOT NULL,
  `driver_id` varchar(20) NOT NULL,
  `quantity` int NOT NULL,
  `destination` varchar(150) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `companycode` (`company_id`,`distribution_id`,`truck_id`),
  KEY `sale_id` (`sale_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_trucks`
--

LOCK TABLES `sales_distributions_trucks` WRITE;
/*!40000 ALTER TABLE `sales_distributions_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_fueltickets`
--

DROP TABLE IF EXISTS `sales_fueltickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_fueltickets` (
  `ticket_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `ticketdate` date NOT NULL,
  `code` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `allowance` decimal(10,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `truck_number` varchar(20) NOT NULL,
  `truck_capacity` int NOT NULL,
  `truck_provider` varchar(50) NOT NULL,
  `truck_from` varchar(50) NOT NULL,
  `truck_destination` varchar(50) NOT NULL,
  `driver_name` varchar(50) NOT NULL,
  `driver_phone` varchar(50) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`ticket_id`),
  KEY `companycode` (`company_id`,`ticketdate`,`product_id`,`truck_number`,`rate`,`quantity`,`status`),
  KEY `paid` (`truck_provider`),
  KEY `invoice` (`code`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_fueltickets`
--

LOCK TABLES `sales_fueltickets` WRITE;
/*!40000 ALTER TABLE `sales_fueltickets` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_fueltickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_payments`
--

DROP TABLE IF EXISTS `sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `customer_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`customer_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_payments`
--

LOCK TABLES `sales_payments` WRITE;
/*!40000 ALTER TABLE `sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_cashbacks`
--

DROP TABLE IF EXISTS `shifts_cashbacks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_cashbacks` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `regno` varchar(100) DEFAULT NULL,
  `cashdate` date NOT NULL,
  `driver` varchar(100) DEFAULT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`cashdate`,`driver`,`customer_id`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`regno`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_cashbacks`
--

LOCK TABLES `shifts_cashbacks` WRITE;
/*!40000 ALTER TABLE `shifts_cashbacks` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_cashbacks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_remittance`
--

DROP TABLE IF EXISTS `shifts_remittance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_remittance` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `paymentdate` date NOT NULL,
  `method` int DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paidby` varchar(50) DEFAULT NULL,
  `paidto` varchar(100) DEFAULT NULL,
  `bank` bigint unsigned DEFAULT NULL,
  `depositor` varchar(100) DEFAULT NULL,
  `teller` varchar(100) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  `reversed_at` datetime DEFAULT NULL,
  `reversed_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`paymentdate`,`method`,`bank`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_remittance`
--

LOCK TABLES `shifts_remittance` WRITE;
/*!40000 ALTER TABLE `shifts_remittance` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_remittance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers`
--

DROP TABLE IF EXISTS `suppliers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers` (
  `supplier_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`supplier_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers`
--

LOCK TABLES `suppliers` WRITE;
/*!40000 ALTER TABLE `suppliers` DISABLE KEYS */;
INSERT INTO `suppliers` VALUES (1,'1','289','AA RANO NIGERIA LTD','MUHAMMAD ABDUL SULE','0803540199','mrmohasul@gmail.com','KANO','KANO','No 7 Maiduguri Road,Opposite NNPC Depot. Kano Nigeria','Nigeria',0.00,0.00,'0000-00-00','2022-10-19 11:05:01',5,'178','2022-10-19 11:05:01','178');
/*!40000 ALTER TABLE `suppliers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers_status`
--

DROP TABLE IF EXISTS `suppliers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `supplier_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers_status`
--

LOCK TABLES `suppliers_status` WRITE;
/*!40000 ALTER TABLE `suppliers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `suppliers_status` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-03-21  2:54:19
