-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_288
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_288`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_288` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_288`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,8000,'',0,'24','1','288','PURCHASES','','2022-10-19 11:01:37',5,0.00,0.00,'','178','2022-10-19 11:01:37','178',0,0),(2,8001,'',0,'24','1','288','SALARIES','','2022-10-19 11:01:45',5,0.00,0.00,'','178','2022-10-19 11:01:45','178',0,0),(3,7000,'',0,'20','1','288','SALES','','2022-10-19 11:01:59',5,0.00,0.00,'','178','2022-10-19 11:01:59','178',0,0),(4,500,'',0,'6.1','1','288','CASH','','2022-10-19 11:02:06',5,0.00,0.00,'','178','2022-10-19 11:02:06','178',0,0),(5,2500,'',0,'2','1','288','1020879289 UBA EBILLS','','2022-11-01 13:59:23',5,0.00,0.00,'','975','2022-11-01 13:59:23','975',0,0),(6,2501,'',0,'2','1','288','UBA POS','','2022-11-01 13:59:34',5,0.00,0.00,'','975','2022-11-01 13:59:34','975',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','1','288','EFCC','SANI AYUBA','08065310217','efcc@gmail.com','porthercourt','rivers','efcc ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-24 11:31:41',5,'975','2022-11-24 11:31:41','975'),(2,'','1','288','NIGERIA POLICE FORCE (ELECTION','OHELCA ROWLAND','08038166331','dopstransport@gmail.come','porthercourt','REVERS','PORTHERCOURT','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-21 16:45:58',5,'975','2023-02-21 16:45:58','975');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','288',1,'2',225.06,750.00,'2023-03-07','','2023-03-07 17:21:26','975','975',2023,'975','2023-03-07 17:21:26',5),('1','288',2,'2',80.00,413.00,'2023-03-20','','2023-03-20 10:09:35','975','975',2023,'975','2023-03-20 10:09:35',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','288','1',1,'5','PUMP 1',38088.87,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-19 14:20:27','178'),('1','288','1',2,'5','PUMP 2',20869.58,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-19 14:20:54','178'),('1','288','1',3,'5','PUMP 3',74173.68,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-19 14:21:19','178'),('1','288','1',4,'5','PUMP 4',69072.94,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-19 14:21:42','178'),('1','288','1',5,'5','PUMP 5',26455.85,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-19 14:22:04','178'),('1','288','1',6,'5','PUMP 6',19534.69,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-19 14:22:25','178'),('1','288','1',7,'5','PUMP 7',50033.63,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-19 14:22:45','178'),('1','288','1',8,'5','PUMP 8',41251.10,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-19 14:23:02','178'),('1','288','2',9,'5','AGO PUMP 1',448618.10,'DISPENSING AGO','',NULL,NULL,'',5,'2022-10-19 16:18:37','178');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=119 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','288',1,'DAY SHIFT','2022-09-23','2022-10-27 20:39:43','2022-10-28 20:39:43','969',263988.00,263988.00,'969','2022-10-27 20:46:38','648','2022-10-28 07:23:01',10,0),('1','288',2,'DAY SHIFT','2022-09-24','2022-10-28 18:30:17','2022-10-29 18:30:17','969',345909.60,345909.60,'969','2022-10-28 18:34:10','648','2022-10-30 11:14:04',10,0),('1','288',3,'DAY SHIFT','2022-09-25','2022-10-30 13:50:25','2022-10-31 13:50:25','969',282423.60,0.00,'969','2022-10-30 13:55:26','648','2022-10-30 23:08:27',10,0),('1','288',4,'DAY SHIFT ','2022-09-26','2022-10-31 10:15:14','2022-11-01 10:15:14','969',0.00,0.00,'969','2022-11-01 09:56:45','648','2022-11-01 18:07:32',10,0),('1','288',5,'DAY SHIFT','2022-09-25','2022-11-01 20:06:43','2022-11-02 20:06:43','969',0.00,0.00,'969','2022-11-02 12:01:35','648','2022-11-02 12:07:53',10,0),('1','288',6,'MORNING','2022-09-27','2022-11-02 12:14:30','2022-11-02 20:14:30','969',0.00,0.00,'969','2022-11-03 08:10:08','648','2022-11-03 08:25:02',10,0),('1','288',7,'MORNING','2022-09-26','2022-11-03 08:49:53','2022-11-04 08:49:53','969',350026.20,350026.20,'969','2022-11-03 08:55:37','648','2022-11-03 09:18:47',10,0),('1','288',8,'MORNING','2022-09-27','2022-11-03 16:50:38','2022-11-04 16:50:38','969',236435.40,236435.40,'969','2022-11-03 17:14:07','648','2022-11-03 23:27:16',10,0),('1','288',9,'AFTERNOON SHIFT','2022-09-27','2022-11-04 08:33:17','2022-11-05 08:33:17','969',174416.40,174416.40,'969','2022-11-04 08:35:33','648','2022-11-06 11:17:44',10,0),('1','288',10,'MORNING','2022-09-28','2022-11-06 13:07:02','2022-11-07 13:07:02','969',216774.00,216774.00,'969','2022-11-06 13:09:46','648','2022-11-06 14:20:04',10,0),('1','288',11,'AFTERNOON SHIFT','2022-09-28','2022-11-06 19:58:40','2022-11-07 19:58:40','969',171936.00,171936.00,'969','2022-11-06 20:01:22','648','2022-11-06 20:46:51',10,0),('1','288',12,'MORNING','2022-09-29','2022-11-06 21:11:29','2022-11-07 21:11:29','969',1225029.60,1225029.60,'969','2022-11-06 21:13:47','648','2022-11-06 21:20:17',10,0),('1','288',13,'AFTERNOON SHIFT','2022-09-29','2022-11-06 21:22:47','2022-11-07 21:22:47','969',174994.20,174994.20,'969','2022-11-06 21:24:52','648','2022-11-07 08:24:11',10,0),('1','288',14,'MORNING','2022-09-30','2022-11-07 12:37:41','2022-11-08 12:37:41','969',210657.60,210657.60,'969','2022-11-07 12:40:42','648','2022-11-08 04:14:24',10,0),('1','288',15,'AFTERNOON SHIFT','2022-09-30','2022-11-08 10:30:31','2022-11-09 10:30:31','969',238546.80,238546.80,'969','2022-11-08 10:32:39','648','2022-11-08 11:20:20',10,0),('1','288',16,'MORNING','2022-10-01','2022-11-08 11:28:01','2022-11-09 11:28:01','969',1996698.60,1996698.60,'969','2022-11-08 11:31:20','648','2022-11-08 13:04:32',10,0),('1','288',17,'AFTERNOON SHIFT','2022-10-01','2022-11-08 17:55:02','2022-11-09 17:55:02','969',156486.60,156486.60,'969','2022-11-08 17:57:55','648','2022-11-08 23:07:23',10,0),('1','288',18,'MORNING','2022-10-02','2022-11-09 11:29:09','2022-11-10 11:29:09','969',89389.80,89389.80,'969','2022-11-09 11:31:28','648','2022-11-09 12:04:36',10,0),('1','288',19,'MORNING','2022-10-03','2022-11-09 13:50:16','2022-11-10 13:50:16','969',217404.00,217404.00,'969','2022-11-09 13:54:12','648','2022-11-09 14:37:03',10,0),('1','288',20,'MORNING','2022-10-04','2022-11-09 14:54:15','2022-11-10 14:54:15','969',241473.60,241473.60,'969','2022-11-09 15:04:50','648','2022-11-09 19:26:00',10,0),('1','288',21,'AFTERNOON SHIFT','2022-10-04','2022-11-09 19:42:48','2022-11-10 19:42:48','969',213625.80,213625.80,'969','2022-11-09 19:45:55','648','2022-11-10 10:29:39',10,0),('1','288',22,'MORNING','2022-10-05','2022-11-10 10:57:15','2022-11-11 10:57:15','969',92329.20,92329.20,'969','2022-11-10 11:00:43','648','2022-11-10 12:58:36',10,0),('1','288',23,'AFTERNOON SHIFT','2022-10-05','2022-11-10 17:44:59','2022-11-11 17:44:59','969',174576.60,174576.60,'969','2022-11-10 17:46:45','648','2022-11-10 17:56:07',10,0),('1','288',24,'MORNING SHIFT','2022-10-06','2022-11-10 17:58:42','2022-11-11 17:58:42','969',210040.20,210040.20,'969','2022-11-10 18:00:21','648','2022-11-10 18:07:39',10,0),('1','288',25,'AFTERNOON SHIFT','2022-10-06','2022-11-10 18:32:49','2022-11-11 18:32:49','969',205243.20,205243.20,'969','2022-11-10 18:34:41','648','2022-11-11 01:59:01',10,0),('1','288',26,'MORNING SHIFT','2022-10-07','2022-11-11 08:16:00','2022-11-12 08:16:00','969',228732.30,228732.30,'969','2022-11-11 08:24:01','648','2022-11-11 10:35:50',10,0),('1','288',27,'AFTERNOON SHIFT','2022-10-07','2022-11-11 12:33:58','2022-11-12 12:33:58','969',200714.40,200714.40,'969','2022-11-11 12:43:17','648','2022-11-11 15:04:20',10,0),('1','288',28,'MORNING SHIFT','2022-10-08','2022-11-12 09:05:16','2022-11-13 09:05:16','969',280387.80,280387.80,'969','2022-11-12 09:08:41','648','2022-11-12 09:17:07',10,0),('1','288',29,'AFTERNOON SHIFT','2022-10-08','2022-11-12 09:21:44','2022-11-13 09:21:44','969',217121.40,217121.40,'969','2022-11-12 09:23:37','648','2022-11-12 09:32:48',10,0),('1','288',30,'MORNING SHIFT','2022-10-09','2022-11-12 09:37:03','2022-11-13 09:37:03','969',164824.20,164824.20,'969','2022-11-12 09:39:06','648','2022-11-12 09:44:53',10,0),('1','288',31,'AFTERNOON SHIFT','2022-10-09','2022-11-12 09:48:21','2022-11-13 09:48:21','969',202474.80,202474.80,'969','2022-11-12 09:50:39','648','2022-11-12 10:13:24',10,0),('1','288',32,'MORNING SHIFT','2022-10-10','2022-11-12 10:23:41','2022-11-13 10:23:41','969',214491.60,214491.60,'969','2022-11-12 10:27:13','648','2022-11-12 10:33:35',10,0),('1','288',33,'AFTERNOON SHIFT','2022-10-10','2022-11-12 10:36:14','2022-11-13 10:36:14','969',265550.20,265550.20,'969','2022-11-12 10:48:46','648','2022-11-12 10:52:41',10,0),('1','288',34,'MORNING SHIFT','2022-10-11','2022-11-12 10:54:54','2022-11-13 10:54:54','969',376592.00,376592.00,'969','2022-11-12 10:58:12','648','2022-11-12 11:01:47',10,0),('1','288',35,'AFTERNOON SHIFT','2022-10-11','2022-11-12 11:03:14','2022-11-13 11:03:14','969',260022.60,260022.60,'969','2022-11-12 11:07:52','648','2022-11-12 11:11:06',10,0),('1','288',36,'MORNING SHIFT','2022-10-12','2022-11-12 11:28:05','2022-11-13 11:28:05','969',251273.10,251273.10,'969','2022-11-12 11:33:40','648','2022-11-12 11:55:40',10,0),('1','288',37,'AFTERNOON SHIFT','2022-10-12','2022-11-12 11:57:38','2022-11-13 11:57:38','969',206218.80,206218.80,'969','2022-11-12 12:00:19','648','2022-11-12 12:01:38',10,0),('1','288',38,'MORNING SHIFT','2022-10-13','2022-11-12 12:09:52','2022-11-13 12:09:52','969',1051843.00,1051843.00,'969','2022-11-12 12:17:47','648','2022-11-12 12:22:08',10,0),('1','288',39,'AFTERNOON SHIFT','2022-10-13','2022-11-12 12:23:02','2022-11-13 12:23:02','969',296868.60,296868.60,'969','2022-11-12 12:24:57','648','2022-11-12 12:26:17',10,0),('1','288',40,'MORNING SHIFT','2022-10-14','2022-11-12 12:35:53','2022-11-13 12:35:53','969',312521.80,312521.80,'969','2022-11-12 12:45:42','648','2022-11-13 06:32:16',10,0),('1','288',41,'AFTERNOON SHIFT','2022-10-14','2022-11-13 07:53:49','2022-11-14 07:53:49','969',265856.40,265856.40,'969','2022-11-13 07:58:29','648','2022-11-13 08:43:11',10,0),('1','288',42,'MORNING SHIFT','2022-10-15','2022-11-13 08:45:51','2022-11-14 08:45:51','969',241005.60,241005.60,'969','2022-11-13 08:48:02','648','2022-11-13 08:57:46',10,0),('1','288',43,'AFTERNOON SHIFT','2022-10-15','2022-11-13 09:03:23','2022-11-14 09:03:23','969',284486.40,284486.40,'969','2022-11-13 09:05:33','648','2022-11-13 09:06:51',10,0),('1','288',44,'MORNING SHIFT','2022-10-16','2022-11-13 09:08:09','2022-11-14 09:08:09','969',252202.00,252202.00,'969','2022-11-13 09:18:46','648','2022-11-13 09:25:13',10,0),('1','288',45,'AFTERNOON SHIFT','2022-10-16','2022-11-13 09:27:26','2022-11-14 09:27:26','969',326379.60,326379.60,'969','2022-11-13 09:30:37','648','2022-11-13 09:34:49',10,0),('1','288',46,'MORNING SHIFT','2022-10-17','2022-11-13 09:35:51','2022-11-14 09:35:51','969',244548.00,244548.00,'969','2022-11-13 09:37:41','648','2022-11-13 09:48:22',10,0),('1','288',47,'AFTERNOON SHIFT','2022-10-17','2022-11-13 09:52:50','2022-11-14 09:52:50','969',458994.60,458994.60,'969','2022-11-13 09:56:06','648','2022-11-13 10:08:44',10,0),('1','288',48,'MORNING SHIFT','2022-10-18','2022-11-13 10:11:55','2022-11-14 10:11:55','969',651809.20,651809.20,'969','2022-11-13 10:39:35','648','2022-11-13 11:11:09',10,0),('1','288',49,'AFTERNOON SHIFT','2022-10-18','2022-11-13 11:14:31','2022-11-14 11:14:31','969',1819051.20,1819051.20,'969','2022-11-13 11:32:30','648','2022-11-13 23:11:34',10,0),('1','288',50,'MORNING SHIFT','2022-10-19','2022-11-14 11:29:32','2022-11-15 11:29:32','969',961216.80,961216.80,'969','2022-11-14 11:34:24','648','2022-11-14 11:50:51',10,0),('1','288',51,'AFTERNOON SHIFT','2022-10-19','2022-11-14 12:14:44','2022-11-15 12:14:44','969',250156.80,250156.80,'969','2022-11-14 12:17:21','648','2022-11-14 14:15:00',10,0),('1','288',52,'MORNING SHIFT','2022-10-20','2022-11-14 14:45:31','2022-11-15 14:45:31','969',281880.60,281880.60,'969','2022-11-14 14:48:43','648','2022-11-15 09:41:24',10,0),('1','288',53,'AFTERNOON SHIFT','2022-10-20','2022-11-15 10:00:46','2022-11-16 10:00:46','969',333549.00,333549.00,'969','2022-11-15 11:50:15','648','2022-11-15 11:53:35',10,0),('1','288',54,'MORNING SHIFT','2022-10-21','2022-11-15 12:02:15','2022-11-16 12:02:15','969',487626.00,487626.00,'969','2022-11-15 12:04:22','648','2022-11-15 12:40:05',10,0),('1','288',55,'AFTERNOON SHIFT','2022-10-21','2022-11-15 13:22:08','2022-11-16 13:22:08','969',286324.20,286324.20,'969','2022-11-15 13:23:58','648','2022-11-15 21:36:23',10,0),('1','288',56,'MORNING SHIFT','2022-10-22','2022-11-16 11:52:36','2022-11-17 11:52:36','969',511861.20,511861.20,'969','2022-11-16 11:59:50','648','2022-11-18 06:29:01',10,0),('1','288',57,'AFTERNOON SHIFT','2022-10-22','2022-11-18 09:12:12','2022-11-19 09:12:12','969',468252.00,468252.00,'969','2022-11-18 09:14:36','648','2022-11-18 09:27:16',10,0),('1','288',58,'MORNING SHIFT','2022-10-23','2022-11-18 09:28:59','2022-11-19 09:28:59','969',405060.00,405060.00,'969','2022-11-18 09:30:43','648','2022-11-18 09:34:34',10,0),('1','288',59,'AFTERNOON SHIFT','2022-10-23','2022-11-18 09:37:42','2022-11-19 09:37:42','969',430756.20,430756.20,'969','2022-11-18 09:41:40','648','2022-11-18 09:49:03',10,0),('1','288',60,'MORNING SHIFT','2022-10-24','2022-11-18 09:52:18','2022-11-19 09:52:18','969',520897.20,520897.20,'969','2022-11-18 09:56:02','648','2022-11-18 09:59:21',10,0),('1','288',61,'AFTERNOON SHIFT','2022-10-24','2022-11-18 10:00:51','2022-11-19 10:00:51','969',473650.20,473650.20,'969','2022-11-18 10:03:12','648','2022-11-18 10:11:32',10,0),('1','288',62,'MORNING SHIFT','2022-10-25','2022-11-18 10:16:12','2022-11-19 10:16:12','969',410183.80,410183.80,'969','2022-11-18 10:31:05','648','2022-11-18 10:41:15',10,0),('1','288',63,'AFTERNOON SHIFT','2022-10-25','2022-11-18 10:44:22','2022-11-19 10:44:22','969',407072.80,407072.80,'969','2022-11-18 10:46:30','648','2022-11-18 10:52:54',10,0),('1','288',64,'MORNING SHIFT','2022-10-26','2022-11-18 10:54:14','2022-11-19 10:54:14','969',534994.80,534994.80,'969','2022-11-18 10:56:30','648','2022-11-18 13:17:41',10,0),('1','288',65,'AFTERNOON SHIFT','2022-10-26','2022-11-18 15:28:02','2022-11-19 15:28:02','969',370902.80,370902.80,'969','2022-11-18 15:32:23','648','2022-11-18 15:42:48',10,0),('1','288',66,'MORNING SHIFT','2022-10-27','2022-11-18 15:48:29','2022-11-19 15:48:29','969',532491.00,532491.00,'969','2022-11-18 15:55:27','648','2022-11-18 16:12:12',10,0),('1','288',67,'AFTERNOON SHIFT','2022-10-27','2022-11-18 16:15:23','2022-11-19 16:15:23','969',427194.00,427194.00,'969','2022-11-18 16:17:40','648','2022-11-18 16:19:15',10,0),('1','288',68,'MORNING SHIFT','2022-10-28','2022-11-18 16:24:43','2022-11-19 16:24:43','969',443119.20,443119.20,'969','2022-11-18 16:28:53','648','2022-11-18 16:30:11',10,0),('1','288',69,'AFTERNOON SHIFT','2022-10-28','2022-11-18 16:33:12','2022-11-19 16:33:12','969',409296.60,409296.60,'969','2022-11-18 16:37:22','648','2022-11-18 16:39:41',10,0),('1','288',70,'MORNING SHIFT','2022-10-29','2022-11-18 16:40:59','2022-11-19 16:40:59','969',489195.60,489195.60,'969','2022-11-18 16:47:11','648','2022-11-18 16:51:09',10,0),('1','288',71,'AFTERNOON SHIFT','2022-10-29','2022-11-18 16:53:22','2022-11-19 16:53:22','969',424929.60,424929.60,'969','2022-11-18 16:56:39','648','2022-11-18 16:59:11',10,0),('1','288',72,'MORNING SHIFT','2022-10-30','2022-11-18 17:00:15','2022-11-19 17:00:15','969',391221.60,391221.60,'969','2022-11-18 17:03:54','648','2022-11-18 17:10:28',10,0),('1','288',73,'AFTERNOON SHIFT','2022-10-30','2022-11-18 17:13:07','2022-11-19 17:13:07','969',296204.40,296204.40,'969','2022-11-18 17:14:42','648','2022-11-18 17:19:09',10,0),('1','288',74,'MORNING SHIFT','2022-10-31','2022-11-18 17:21:13','2022-11-19 17:21:13','969',347884.80,347884.80,'969','2022-11-18 17:24:20','648','2022-11-18 17:27:24',10,0),('1','288',75,'MORNING SHIFT','2022-11-08','2022-11-18 17:45:55','2022-11-19 17:45:55','969',40000.00,40000.00,'969','2022-11-18 19:56:23','648','2022-11-24 23:28:19',10,0),('1','288',76,'MORNING SHIFT','2022-11-17','2022-11-25 10:30:24','2022-11-26 10:30:24','969',8250000.00,8250000.00,'969','2022-11-25 15:07:21','648','2022-11-25 17:36:17',10,0),('1','288',77,'MORNING SHIFT','2022-11-18','2022-11-25 17:38:18','2022-11-26 17:38:18','969',9075.00,9075.00,'969','2022-11-25 17:39:54','648','2022-11-26 09:51:54',10,0),('1','288',78,'MORNING SHIFT','2022-11-23','2022-11-27 07:43:46','2022-11-28 07:43:46','969',158974.20,158974.20,'969','2022-11-27 07:45:16','648','2022-11-27 09:22:53',10,0),('1','288',79,'DAY SHIFT','2022-11-25','2022-11-27 09:50:24','2022-11-28 09:50:24','969',215054.70,215054.70,'969','2022-11-27 09:51:47','648','2022-11-27 14:33:49',10,0),('1','288',80,'MORNING SHIFT','2022-11-26','2022-11-27 14:36:16','2022-11-28 14:36:16','969',616308.00,616308.00,'969','2022-11-27 17:02:29','648','2022-11-28 12:08:55',10,0),('1','288',81,'AFTERNOON SHIFT','2022-11-26','2022-11-28 13:00:31','2022-11-29 13:00:31','969',340783.80,340783.80,'969','2022-11-28 13:38:30','648','2022-11-28 13:58:10',10,0),('1','288',82,'MORNING SHIFT','2022-11-27','2022-11-28 14:00:38','2022-11-29 14:00:38','969',338778.30,338778.30,'969','2022-11-28 14:03:11','648','2022-11-28 14:10:37',10,0),('1','288',83,'AFTERNOON SHIFT','2022-11-27','2022-11-28 14:11:32','2022-11-29 14:11:32','969',853927.20,853927.20,'969','2022-11-28 14:14:17','648','2022-11-28 14:42:29',10,0),('1','288',84,'MORNING SHIFT','2022-11-28','2022-11-28 15:23:28','2022-11-29 15:23:28','969',574975.80,574975.80,'969','2022-11-28 15:27:37','648','2022-11-29 11:18:29',10,0),('1','288',85,'AFTERNOON SHIFT','2022-11-28','2022-11-29 11:36:12','2022-11-30 11:36:12','969',436033.50,436033.50,'969','2022-11-29 11:39:05','648','2022-11-29 16:54:56',10,0),('1','288',86,'MORNING SHIFT','2022-11-29','2022-11-29 17:35:01','2022-11-30 17:35:01','969',651966.00,651966.00,'969','2022-11-29 17:38:03','648','2022-11-30 11:32:32',10,0),('1','288',87,'AFTERNOON SHIFT','2022-11-29','2022-11-30 14:09:06','2022-12-01 14:09:06','969',611442.30,611442.30,'969','2022-11-30 14:12:15','648','2022-12-01 07:48:40',10,0),('1','288',88,'MORNING SHIFT','2022-11-30','2022-12-01 11:22:36','2022-12-02 11:22:36','969',848261.40,848261.40,'969','2022-12-01 11:24:23','648','2022-12-01 14:56:27',10,0),('1','288',89,'AFTERNOON SHIFT','2022-11-30','2022-12-01 15:01:03','2022-12-02 15:01:03','969',648062.10,648062.10,'969','2022-12-01 15:03:40','648','2022-12-01 15:11:40',10,0),('1','288',90,'MORNING SHIFT','2022-12-01','2022-12-02 10:18:00','2022-12-03 10:18:00','969',952228.20,952228.20,'969','2022-12-02 10:20:18','648','2022-12-02 10:25:05',10,0),('1','288',91,'AFTERNOON SHIFT','2022-12-01','2022-12-02 10:33:44','2022-12-03 10:33:44','969',661626.00,661626.00,'969','2022-12-02 10:38:07','648','2022-12-02 12:20:38',10,0),('1','288',92,'MORNING SHIFT','2022-12-02','2022-12-02 16:24:24','2022-12-03 16:24:24','969',1095129.00,1095129.00,'969','2022-12-02 16:27:02','648','2022-12-03 06:11:41',10,0),('1','288',93,'AFTERNOON SHIFT','2022-12-02','2022-12-03 11:03:13','2022-12-04 11:03:13','969',1024932.30,1024932.30,'969','2022-12-04 10:08:34','648','2022-12-04 12:10:22',10,0),('1','288',94,'MORNING SHIFT','2022-12-03','2022-12-04 12:11:23','2022-12-05 12:11:23','969',728704.20,728704.20,'969','2022-12-04 12:14:11','648','2022-12-04 12:15:32',10,0),('1','288',95,'AFTERNOON SHIFT','2022-12-03','2022-12-04 12:16:19','2022-12-05 12:16:19','969',480345.60,480345.60,'969','2022-12-04 12:18:10','648','2022-12-04 12:24:01',10,0),('1','288',96,'MORNING SHIFT','2022-12-04','2022-12-04 17:44:49','2022-12-05 17:44:49','969',471695.70,471695.70,'969','2022-12-04 18:17:17','648','2022-12-05 14:32:12',10,0),('1','288',97,'AFTERNOON SHIFT','2022-12-04','2022-12-05 15:00:36','2022-12-06 15:00:36','969',456221.70,456221.70,'969','2022-12-05 15:02:22','648','2022-12-06 16:15:05',10,0),('1','288',98,'MORNING SHIFT','2022-12-05','2022-12-06 16:40:00','2022-12-07 16:40:00','969',733890.00,733890.00,'969','2022-12-06 16:43:23','648','2022-12-07 04:17:07',10,0),('1','288',99,'MORNING SHIFT','2022-12-06','2022-12-07 15:30:54','2022-12-08 15:30:54','969',704660.10,704660.10,'969','2022-12-07 15:34:45','648','2022-12-11 05:56:02',10,0),('1','288',100,'DAY SHIFT','2023-03-02','2023-03-02 14:36:12','2023-03-03 14:36:12','969',5694300.00,5694300.00,'969','2023-03-02 14:55:38','648','2023-03-03 09:58:29',10,0),('1','288',101,'DAY SHIFT','2023-03-03','2023-03-04 19:14:29','2023-03-05 19:14:29','969',0.00,0.00,'969','2023-03-05 16:36:00','975','2023-03-05 16:55:05',10,0),('1','288',102,'DAY SHIFT','2023-03-03','2023-03-06 15:15:51','2023-03-07 15:15:51','969',0.00,0.00,'969','2023-03-07 13:25:03','975','2023-03-07 14:28:09',10,0),('1','288',103,'DAY SHIFT','2023-03-03','2023-03-07 16:57:03','2023-03-08 16:57:03','969',1448516.95,1448516.95,'969','2023-03-07 17:24:13','975','2023-03-07 17:25:17',10,0),('1','288',104,'DAY SHIFT','2023-03-04','2023-03-07 18:34:12','2023-03-08 18:34:12','969',1155690.05,1155690.05,'969','2023-03-07 18:39:30','648','2023-03-08 09:47:45',10,0),('1','288',105,'DAY SHIFT','2023-03-05','2023-03-08 23:39:32','2023-03-09 23:39:32','969',1447919.60,1447919.60,'969','2023-03-08 23:44:41','648','2023-03-09 10:21:17',10,0),('1','288',106,'DAY SHIFT','2023-03-06','2023-03-09 17:40:20','2023-03-10 17:40:20','969',1584710.75,1584710.75,'969','2023-03-09 17:45:09','648','2023-03-10 09:26:45',10,0),('1','288',107,'DAY SHIFT','2023-03-07','2023-03-10 10:03:29','2023-03-11 10:03:29','969',1877266.95,1877266.95,'969','2023-03-10 10:07:43','648','2023-03-10 13:18:34',10,0),('1','288',108,'DAY SHIFT','2023-03-08','2023-03-10 14:59:34','2023-03-11 14:59:34','969',2325889.00,2325889.00,'969','2023-03-10 15:02:38','648','2023-03-10 15:42:46',10,0),('1','288',109,'DAY SHIFT','2023-03-09','2023-03-10 17:45:35','2023-03-11 17:45:35','969',1147808.15,1147808.15,'969','2023-03-10 17:47:04','648','2023-03-11 08:21:44',10,0),('1','288',110,'DAY SHIFT','2023-03-10','2023-03-11 09:16:43','2023-03-12 09:16:43','969',1634998.40,1634998.40,'969','2023-03-11 12:24:03','648','2023-03-11 17:04:50',10,0),('1','288',111,'DAY SHIFT','2023-03-11','2023-03-12 07:23:57','2023-03-13 07:23:57','969',1634869.15,1634869.15,'969','2023-03-12 07:39:24','648','2023-03-12 21:58:45',10,0),('1','288',112,'DAY SHIFT','2023-03-12','2023-03-13 07:07:42','2023-03-14 07:07:42','969',1618732.55,1618732.55,'969','2023-03-13 09:55:00','648','2023-03-13 13:15:36',10,0),('1','288',113,'DAY SHIFT','2023-03-13','2023-03-14 08:06:30','2023-03-15 08:06:30','969',1514412.85,1514412.85,'969','2023-03-14 08:08:45','648','2023-03-14 08:28:16',10,0),('1','288',114,'DAY SHIFT','2023-03-14','2023-03-15 08:12:00','2023-03-16 08:12:00','969',877631.00,877631.00,'969','2023-03-15 08:13:59','648','2023-03-15 09:13:41',10,0),('1','288',115,'DAY SHIFT','2023-03-15','2023-03-16 07:11:35','2023-03-17 07:11:35','969',1081843.65,1081843.65,'969','2023-03-16 07:14:15','648','2023-03-16 09:08:48',10,0),('1','288',116,'DAY SHIFT','2023-03-16','2023-03-17 07:28:10','2023-03-18 07:28:10','969',2383059.80,2383059.80,'969','2023-03-17 07:30:35','648','2023-03-17 07:50:19',10,0),('1','288',117,'DAY SHIFT','2023-03-17','2023-03-18 00:13:11','2023-03-19 00:13:11','969',2750968.75,2750968.75,'969','2023-03-18 00:16:41','648','2023-03-20 08:09:35',10,0),('1','288',118,'DAY SHIFT','2023-03-19','2023-03-20 08:58:58','2023-03-21 08:58:58','969',2168055.05,2168055.05,'969','2023-03-20 10:16:22','975','2023-03-20 10:26:57',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=1063 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','288','1','1',1,'1','1',160.09,359.93,199.84,35971.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','1',2,'2','1',5213.69,5610.73,397.04,71467.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','1',3,'3','1',5171.71,5226.70,54.99,9898.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','1',4,'4','1',116.34,272.04,155.70,28026.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','1',5,'5','1',5150.40,5297.55,147.15,26487.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','1',6,'6','1',96.78,345.61,248.83,44789.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','1',7,'7','1',5199.33,5241.53,42.20,7596.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','1',8,'8','1',95.44,316.29,220.85,39753.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','1',9,'9','2',428327.03,428327.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','2',10,'1','1',359.93,937.21,577.28,103910.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','2',11,'2','1',5610.73,5862.51,251.78,45320.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','2',12,'3','1',5226.70,5365.82,139.12,25041.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','2',13,'4','1',272.04,602.46,330.42,59475.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','2',14,'5','1',5297.55,5423.04,125.49,22588.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','2',15,'6','1',345.61,553.90,208.29,37492.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','2',16,'7','1',5241.53,5358.96,117.43,21137.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','2',17,'8','1',316.29,488.20,171.91,30943.80,0.00,0.00,0.00,0.00,0.00),('1','288','2','2',18,'9','2',428327.03,428327.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','3',19,'1','1',937.21,1170.57,233.36,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','3',20,'2','1',5862.51,6007.56,145.05,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','3',21,'3','1',5365.82,5547.98,182.16,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','3',22,'4','1',602.46,845.89,243.43,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','3',23,'5','1',5423.04,5624.87,201.83,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','3',24,'6','1',553.90,640.55,86.65,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','3',25,'7','1',5358.96,5432.80,73.84,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','3',26,'8','1',488.20,890.90,402.70,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','3',27,'9','2',428327.03,428327.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','4',28,'1','1',1170.57,1170.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','4',29,'2','1',6007.56,6007.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','4',30,'3','1',5547.98,5547.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','4',31,'4','1',845.89,845.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','4',32,'5','1',5624.87,5624.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','4',33,'6','1',640.55,640.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','4',34,'7','1',5432.80,5432.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','4',35,'8','1',890.90,890.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','4',36,'9','2',428327.03,428327.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','5',37,'1','1',1170.57,1170.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','5',38,'2','1',6007.56,6007.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','5',39,'3','1',5547.98,5547.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','5',40,'4','1',845.89,845.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','5',41,'5','1',5624.87,5624.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','5',42,'6','1',640.55,640.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','5',43,'7','1',5432.80,5432.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','5',44,'8','1',890.90,890.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','5',45,'9','2',428327.03,428327.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','6',46,'1','1',1170.57,1170.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','6',47,'2','1',6007.56,6007.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','6',48,'3','1',5547.98,5547.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','6',49,'4','1',845.89,845.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','6',50,'5','1',5624.87,5624.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','6',51,'6','1',640.55,640.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','6',52,'7','1',5432.80,5432.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','6',53,'8','1',890.90,890.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','6',54,'9','2',428327.03,428327.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','7',55,'1','1',1170.57,1487.58,317.01,57061.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','7',56,'2','1',6007.56,6350.18,342.62,61671.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','7',57,'3','1',5547.98,5842.38,294.40,52992.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','7',58,'4','1',845.89,1074.85,228.96,41212.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','7',59,'5','1',5624.87,5802.04,177.17,31890.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','7',60,'6','1',640.55,851.62,211.07,37992.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','7',61,'7','1',5432.80,5523.16,90.36,16264.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','7',62,'8','1',890.90,1173.90,283.00,50940.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','7',63,'9','2',428327.03,428327.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','8',64,'1','1',1487.58,1933.49,445.91,80263.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','8',65,'2','1',6350.18,6350.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','8',66,'3','1',5842.38,5842.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','8',67,'4','1',1074.85,1500.95,426.10,76698.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','8',68,'5','1',5802.04,5982.07,180.03,32405.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','8',69,'6','1',851.62,851.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','8',70,'7','1',5523.16,5523.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','8',71,'8','1',1173.90,1435.39,261.49,47068.20,0.00,0.00,0.00,0.00,0.00),('1','288','2','8',72,'9','2',428327.03,428327.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','9',73,'1','1',1933.49,1933.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','9',74,'2','1',6350.18,6683.92,333.74,60073.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','9',75,'3','1',5842.38,6118.30,275.92,49665.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','9',76,'4','1',1500.95,1500.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','9',77,'5','1',5982.07,5982.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','9',78,'6','1',851.62,1022.96,171.34,30841.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','9',79,'7','1',5523.16,5711.14,187.98,33836.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','9',80,'8','1',1435.39,1435.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','9',81,'9','2',428327.03,428327.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','10',82,'1','1',1933.49,1933.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','10',83,'2','1',6683.92,7084.59,400.67,72120.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','10',84,'3','1',6118.30,6285.63,167.33,30119.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','10',85,'4','1',1500.95,1500.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','10',86,'5','1',5982.07,5982.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','10',87,'6','1',1022.96,1331.01,308.05,55449.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','10',88,'7','1',5711.14,5711.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','10',89,'8','1',1435.39,1763.64,328.25,59085.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','10',90,'9','2',428327.03,428327.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','11',91,'1','1',1933.49,2138.69,205.20,36936.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','11',92,'2','1',7084.59,7084.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','11',93,'3','1',6285.63,6285.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','11',94,'4','1',1500.95,1692.52,191.57,34482.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','11',95,'5','1',5982.07,6241.62,259.55,46719.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','11',96,'6','1',1331.01,1331.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','11',97,'7','1',5711.14,6010.02,298.88,53798.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','11',98,'8','1',1763.64,1763.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','11',99,'9','2',428327.03,428327.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','12',100,'1','1',2138.69,5547.57,3408.88,613598.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','12',101,'2','1',7084.59,7084.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','12',102,'3','1',6285.63,6285.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','12',103,'4','1',1692.52,4156.76,2464.24,443563.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','12',104,'5','1',6241.62,6575.36,333.74,60073.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','12',105,'6','1',1331.01,1331.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','12',106,'7','1',6010.02,6010.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','12',107,'8','1',1763.64,2362.50,598.86,107794.80,0.00,0.00,0.00,0.00,0.00),('1','288','2','12',108,'9','2',428327.03,428327.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','13',109,'1','1',5547.57,5547.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','13',110,'2','1',7084.59,7284.05,199.46,35902.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','13',111,'3','1',6285.63,6472.74,187.11,33679.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','13',112,'4','1',4156.76,4156.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','13',113,'5','1',6575.36,6575.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','13',114,'6','1',1331.01,1661.19,330.18,59432.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','13',115,'7','1',6010.02,6265.46,255.44,45979.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','13',116,'8','1',2362.50,2362.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','13',117,'9','2',428327.03,428327.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','14',118,'1','1',5547.57,5547.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','14',119,'2','1',7284.05,7675.12,391.07,70392.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','14',120,'3','1',6472.74,6714.78,242.04,43567.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','14',121,'4','1',4156.76,4156.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','14',122,'5','1',6575.36,6575.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','14',123,'6','1',1661.19,1988.96,327.77,58998.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','14',124,'7','1',6265.46,6474.90,209.44,37699.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','14',125,'8','1',2362.50,2362.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','14',126,'9','2',428327.03,428327.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','15',127,'1','1',5547.57,6043.89,496.32,89337.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','15',128,'2','1',7675.12,7675.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','15',129,'3','1',6714.78,6714.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','15',130,'4','1',4156.76,4524.31,367.55,66159.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','15',131,'5','1',6575.36,6776.08,200.72,36129.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','15',132,'6','1',1988.96,1988.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','15',133,'7','1',6474.90,6474.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','15',134,'8','1',2362.50,2623.17,260.67,46920.60,0.00,0.00,0.00,0.00,0.00),('1','288','2','15',135,'9','2',428327.03,428327.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','16',136,'1','1',6043.89,9336.78,3292.89,592720.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','16',137,'2','1',7675.12,10286.16,2611.04,469987.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','16',138,'3','1',6714.78,8895.75,2180.97,392574.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','16',139,'4','1',4524.31,6832.93,2308.62,415551.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','16',140,'5','1',6776.08,7015.61,239.53,43115.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','16',141,'6','1',1988.96,1988.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','16',142,'7','1',6474.90,6934.62,459.72,82749.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','16',143,'8','1',2623.17,2623.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','16',144,'9','2',428327.03,428327.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','17',145,'1','1',9336.78,9336.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','17',146,'2','1',10286.16,10628.82,342.66,61678.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','17',147,'3','1',8895.75,9139.67,243.92,43905.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','17',148,'4','1',6832.93,6832.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','17',149,'5','1',7015.61,7015.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','17',150,'6','1',1988.96,2176.23,187.27,33708.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','17',151,'7','1',6934.62,7030.14,95.52,17193.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','17',152,'8','1',2623.17,2623.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','17',153,'9','2',428327.03,428327.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','18',154,'1','1',9336.78,9336.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','18',155,'2','1',10628.82,10870.38,241.56,43480.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','18',156,'3','1',9139.67,9194.65,54.98,9896.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','18',157,'4','1',6832.93,6832.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','18',158,'5','1',7015.61,7015.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','18',159,'6','1',2176.23,2319.12,142.89,25720.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','18',160,'7','1',7030.14,7087.32,57.18,10292.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','18',161,'8','1',2623.17,2623.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','18',162,'9','2',428327.03,428327.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','19',163,'1','1',9336.78,9618.84,282.06,50770.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','19',164,'2','1',10870.38,11087.55,217.17,39090.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','19',165,'3','1',9194.65,9284.50,89.85,16173.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','19',166,'4','1',6832.93,7003.04,170.11,30619.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','19',167,'5','1',7015.61,7095.25,79.64,14335.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','19',168,'6','1',2319.12,2411.90,92.78,16700.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','19',169,'7','1',7087.32,7265.57,178.25,32085.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','19',170,'8','1',2623.17,2721.11,97.94,17629.20,0.00,0.00,0.00,0.00,0.00),('1','288','2','19',171,'9','2',428327.03,428327.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','20',172,'1','1',9618.84,9897.02,278.18,50072.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','20',173,'2','1',11087.55,11087.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','20',174,'3','1',9284.50,9610.48,325.98,58676.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','20',175,'4','1',7003.04,7003.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','20',176,'5','1',7095.25,7269.60,174.35,31383.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','20',177,'6','1',2411.90,2411.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','20',178,'7','1',7265.57,7828.58,563.01,101341.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','20',179,'8','1',2721.11,2721.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','20',180,'9','2',428327.03,428327.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','21',181,'1','1',9897.02,9897.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','21',182,'2','1',11087.55,11568.20,480.65,86517.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','21',183,'3','1',9610.48,9610.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','21',184,'4','1',7003.04,7241.24,238.20,42876.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','21',185,'5','1',7269.60,7269.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','21',186,'6','1',2411.90,2722.14,310.24,55843.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','21',187,'7','1',7828.58,7828.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','21',188,'8','1',2721.11,2878.83,157.72,28389.60,0.00,0.00,0.00,0.00,0.00),('1','288','2','21',189,'9','2',428327.03,428327.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','22',190,'1','1',9897.02,9897.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','22',191,'2','1',11568.20,11656.12,87.92,15825.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','22',192,'3','1',9610.48,9610.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','22',193,'4','1',7241.24,7331.74,90.50,16290.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','22',194,'5','1',7269.60,7269.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','22',195,'6','1',2722.14,2960.96,238.82,42987.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','22',196,'7','1',7828.58,7828.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','22',197,'8','1',2878.83,2974.53,95.70,17226.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','22',198,'9','2',428327.03,428327.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','23',199,'1','1',9897.02,10367.33,470.31,84655.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','23',200,'2','1',11656.12,11656.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','23',201,'3','1',9610.48,9638.94,28.46,5122.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','23',202,'4','1',7331.74,7331.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','23',203,'5','1',7269.60,7740.70,471.10,84798.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','23',204,'6','1',2960.96,2960.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','23',205,'7','1',7828.58,7828.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','23',206,'8','1',2974.53,2974.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','23',207,'9','2',428327.03,428327.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','24',208,'1','1',10367.33,10893.40,526.07,94692.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','24',209,'2','1',11656.12,11950.01,293.89,52900.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','24',210,'3','1',9638.94,9638.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','24',211,'4','1',7331.74,7331.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','24',212,'5','1',7740.70,7925.46,184.76,33256.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','24',213,'6','1',2960.96,3123.13,162.17,29190.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','24',214,'7','1',7828.58,7828.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','24',215,'8','1',2974.53,2974.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','24',216,'9','2',428327.03,428327.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','25',217,'1','1',10893.40,11360.99,467.59,84166.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','25',218,'2','1',11950.01,12315.10,365.09,65716.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','25',219,'3','1',9638.94,9638.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','25',220,'4','1',7331.74,7331.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','25',221,'5','1',7925.46,8175.69,250.23,45041.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','25',222,'6','1',3123.13,3180.46,57.33,10319.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','25',223,'7','1',7828.58,7828.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','25',224,'8','1',2974.53,2974.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','25',225,'9','2',428327.03,428327.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','26',226,'1','1',11360.99,11624.96,263.97,47514.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','26',227,'2','1',12315.10,12759.84,444.74,80053.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','26',228,'3','1',9638.94,9638.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','26',229,'4','1',7331.74,7331.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','26',230,'5','1',8175.69,8354.49,178.80,32184.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','26',231,'6','1',3180.46,3454.73,274.27,49368.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','26',232,'7','1',7828.58,7828.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','26',233,'8','1',2974.53,2974.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','26',234,'9','2',428327.03,428352.50,25.47,19611.90,0.00,0.00,0.00,0.00,0.00),('1','288','1','27',235,'1','1',11624.96,12031.96,407.00,73260.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','27',236,'2','1',12759.84,12759.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','27',237,'3','1',9638.94,9876.70,237.76,42796.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','27',238,'4','1',7331.74,7331.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','27',239,'5','1',8354.49,8713.63,359.14,64645.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','27',240,'6','1',3454.73,3454.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','27',241,'7','1',7828.58,7828.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','27',242,'8','1',2974.53,3085.71,111.18,20012.40,0.00,0.00,0.00,0.00,0.00),('1','288','2','27',243,'9','2',428352.50,428352.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','28',244,'1','1',12031.96,12031.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','28',245,'2','1',12759.84,13348.08,588.24,105883.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','28',246,'3','1',9876.70,9876.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','28',247,'4','1',7331.74,7719.71,387.97,69834.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','28',248,'5','1',8713.63,9059.50,345.87,62256.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','28',249,'6','1',3454.73,3454.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','28',250,'7','1',7828.58,8064.21,235.63,42413.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','28',251,'8','1',3085.71,3085.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','28',252,'9','2',428352.50,428352.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','29',253,'1','1',12031.96,12392.13,360.17,64830.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','29',254,'2','1',13348.08,13348.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','29',255,'3','1',9876.70,10270.99,394.29,70972.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','29',256,'4','1',7719.71,7719.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','29',257,'5','1',9059.50,9059.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','29',258,'6','1',3454.73,3615.36,160.63,28913.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','29',259,'7','1',8064.21,8064.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','29',260,'8','1',3085.71,3376.85,291.14,52405.20,0.00,0.00,0.00,0.00,0.00),('1','288','2','29',261,'9','2',428352.50,428352.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','30',262,'1','1',12392.13,12552.69,160.56,28900.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','30',263,'2','1',13348.08,13348.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','30',264,'3','1',10270.99,10527.56,256.57,46182.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','30',265,'4','1',7719.71,7719.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','30',266,'5','1',9059.50,9218.38,158.88,28598.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','30',267,'6','1',3615.36,3955.04,339.68,61142.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','30',268,'7','1',8064.21,8064.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','30',269,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','30',270,'9','2',428352.50,428352.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','31',271,'1','1',12552.69,12552.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','31',272,'2','1',13348.08,13611.45,263.37,47406.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','31',273,'3','1',10527.56,10527.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','31',274,'4','1',7719.71,8066.93,347.22,62499.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','31',275,'5','1',9218.38,9541.12,322.74,58093.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','31',276,'6','1',3955.04,4146.57,191.53,34475.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','31',277,'7','1',8064.21,8064.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','31',278,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','31',279,'9','2',428352.50,428352.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','32',280,'1','1',12552.69,12844.10,291.41,52453.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','32',281,'2','1',13611.45,13611.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','32',282,'3','1',10527.56,10685.75,158.19,28474.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','32',283,'4','1',8066.93,8288.72,221.79,39922.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','32',284,'5','1',9541.12,9541.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','32',285,'6','1',4146.57,4666.80,520.23,93641.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','32',286,'7','1',8064.21,8064.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','32',287,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','32',288,'9','2',428352.50,428352.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','33',289,'1','1',12844.10,12844.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','33',290,'2','1',13611.45,13808.89,197.44,35539.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','33',291,'3','1',10685.75,11011.71,325.96,58672.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','33',292,'4','1',8288.72,8744.84,456.12,82101.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','33',293,'5','1',9541.12,9822.99,281.87,50736.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','33',294,'6','1',4666.80,4666.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','33',295,'7','1',8064.21,8064.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','33',296,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','33',297,'9','2',428352.50,428402.50,50.00,38500.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','34',298,'1','1',12844.10,12844.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','34',299,'2','1',13808.89,14248.01,439.12,79041.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','34',300,'3','1',11011.71,11383.62,371.91,66943.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','34',301,'4','1',8744.84,9214.07,469.23,84461.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','34',302,'5','1',9822.99,10207.13,384.14,69145.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','34',303,'6','1',4666.80,4666.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','34',304,'7','1',8064.21,8064.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','34',305,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','34',306,'9','2',428402.50,428502.50,100.00,77000.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','35',307,'1','1',12844.10,13357.36,513.26,92386.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','35',308,'2','1',14248.01,14248.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','35',309,'3','1',11383.62,11546.33,162.71,29287.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','35',310,'4','1',9214.07,9493.87,279.17,50250.60,0.00,0.00,0.63,0.00,0.00),('1','288','1','35',311,'5','1',10207.13,10207.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','35',312,'6','1',4666.80,5156.23,489.43,88097.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','35',313,'7','1',8064.21,8064.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','35',314,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','35',315,'9','2',428502.50,428502.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','36',316,'1','1',13357.36,13623.83,266.47,47964.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','36',317,'2','1',14248.01,14248.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','36',318,'3','1',11546.33,11862.76,316.43,56957.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','36',319,'4','1',9493.87,9724.27,230.40,41472.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','36',320,'5','1',10207.13,10575.86,368.73,66371.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','36',321,'6','1',5156.23,5156.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','36',322,'7','1',8064.21,8064.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','36',323,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','36',324,'9','2',428502.50,428586.10,50.01,38507.70,0.00,0.00,33.59,0.00,0.00),('1','288','1','37',325,'1','1',13623.83,13623.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','37',326,'2','1',14248.01,14442.63,194.62,35031.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','37',327,'3','1',11862.76,12126.30,263.54,47437.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','37',328,'4','1',9724.27,9949.01,224.74,40453.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','37',329,'5','1',10575.86,10575.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','37',330,'6','1',5156.23,5618.99,462.76,83296.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','37',331,'7','1',8064.21,8064.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','37',332,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','37',333,'9','2',428586.10,428586.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','38',334,'1','1',13623.83,14125.32,501.49,90268.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','38',335,'2','1',14442.63,14442.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','38',336,'3','1',12126.30,14175.73,2049.43,368897.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','38',337,'4','1',9949.01,12350.62,2401.61,432289.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','38',338,'5','1',10575.86,11244.68,668.82,120387.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','38',339,'6','1',5618.99,5618.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','38',340,'7','1',8064.21,8064.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','38',341,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','38',342,'9','2',428586.10,428636.10,50.00,40000.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','39',343,'1','1',14125.32,14125.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','39',344,'2','1',14442.63,14928.19,485.56,87400.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','39',345,'3','1',14175.73,14394.48,218.75,39375.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','39',346,'4','1',12350.62,12789.65,439.03,79025.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','39',347,'5','1',11244.68,11244.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','39',348,'6','1',5618.99,6124.92,505.93,91067.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','39',349,'7','1',8064.21,8064.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','39',350,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','39',351,'9','2',428636.10,428636.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','40',352,'1','1',14125.32,14125.32,-20.51,-3691.80,0.00,0.00,20.51,0.00,0.00),('1','288','1','40',353,'2','1',14928.19,15209.66,260.98,46976.40,0.00,0.00,20.49,0.00,0.00),('1','288','1','40',354,'3','1',14394.48,14666.56,272.08,48974.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','40',355,'4','1',12789.65,13178.95,389.30,70074.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','40',356,'5','1',11244.68,11244.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','40',357,'6','1',6124.92,6737.08,612.16,110188.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','40',358,'7','1',8064.21,8064.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','40',359,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','40',360,'9','2',428636.10,428686.10,50.00,40000.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','41',361,'1','1',14125.32,14444.07,318.75,57375.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','41',362,'2','1',15209.66,15537.46,327.80,59004.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','41',363,'3','1',14666.56,14666.56,-20.00,-3600.00,0.00,0.00,20.00,0.00,0.00),('1','288','1','41',364,'4','1',13178.95,13652.26,473.31,85195.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','41',365,'5','1',11244.68,11621.80,377.12,67881.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','41',366,'6','1',6737.08,6737.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','41',367,'7','1',8064.21,8064.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','41',368,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','41',369,'9','2',428686.10,428686.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','42',370,'1','1',14444.07,14771.69,327.62,58971.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','42',371,'2','1',15537.46,15537.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','42',372,'3','1',14666.56,14666.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','42',373,'4','1',13652.26,14180.85,528.59,95146.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','42',374,'5','1',11621.80,11828.78,206.98,37256.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','42',375,'6','1',6737.08,7012.81,275.73,49631.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','42',376,'7','1',8064.21,8064.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','42',377,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','42',378,'9','2',428686.10,428686.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','43',379,'1','1',14771.69,15183.98,412.29,74212.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','43',380,'2','1',15537.46,15817.50,280.04,50407.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','43',381,'3','1',14666.56,15136.30,469.74,84553.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','43',382,'4','1',14180.85,14180.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','43',383,'5','1',11828.78,11828.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','43',384,'6','1',7012.81,7431.22,418.41,75313.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','43',385,'7','1',8064.21,8064.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','43',386,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','43',387,'9','2',428686.10,428686.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','44',388,'1','1',15183.98,15183.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','44',389,'2','1',15817.50,16216.29,398.79,71782.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','44',390,'3','1',15136.30,15136.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','44',391,'4','1',14180.85,14541.52,360.67,64920.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','44',392,'5','1',11828.78,12082.78,254.00,45720.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','44',393,'6','1',7431.22,7596.66,165.44,29779.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','44',394,'7','1',8064.21,8064.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','44',395,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','44',396,'9','2',428686.10,428736.10,50.00,40000.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','45',397,'1','1',15183.98,15724.23,540.25,97245.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','45',398,'2','1',16216.29,16216.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','45',399,'3','1',15136.30,15600.01,463.71,83467.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','45',400,'4','1',14541.52,14942.84,401.32,72237.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','45',401,'5','1',12082.78,12490.72,407.94,73429.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','45',402,'6','1',7596.66,7596.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','45',403,'7','1',8064.21,8064.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','45',404,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','45',405,'9','2',428736.10,428736.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','46',406,'1','1',15724.23,15944.97,220.74,39733.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','46',407,'2','1',16216.29,16216.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','46',408,'3','1',15600.01,15795.81,195.80,35244.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','46',409,'4','1',14942.84,15287.69,344.85,62073.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','46',410,'5','1',12490.72,13087.93,597.21,107497.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','46',411,'6','1',7596.66,7596.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','46',412,'7','1',8064.21,8064.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','46',413,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','46',414,'9','2',428736.10,428736.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','47',415,'1','1',15944.97,16598.07,653.10,117558.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','47',416,'2','1',16216.29,16611.39,395.10,71118.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','47',417,'3','1',15795.81,16609.35,813.54,146437.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','47',418,'4','1',15287.69,15287.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','47',419,'5','1',13087.93,13087.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','47',420,'6','1',7596.66,8284.89,688.23,123881.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','47',421,'7','1',8064.21,8064.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','47',422,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','47',423,'9','2',428736.10,428736.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','48',424,'1','1',16598.07,17382.23,784.16,141148.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','48',425,'2','1',16611.39,16611.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','48',426,'3','1',16609.35,17659.30,1049.95,188991.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','48',427,'4','1',15287.69,15503.20,215.51,38791.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','48',428,'5','1',13087.93,13087.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','48',429,'6','1',8284.89,9634.21,1349.32,242877.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','48',430,'7','1',8064.21,8064.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','48',431,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','48',432,'9','2',428736.10,428786.10,50.00,40000.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','49',433,'1','1',17382.23,20264.78,2872.55,517059.00,0.00,0.00,10.00,0.00,0.00),('1','288','1','49',434,'2','1',16611.39,16611.39,-10.00,-1800.00,0.00,0.00,10.00,0.00,0.00),('1','288','1','49',435,'3','1',17659.30,17659.30,-10.00,-1800.00,0.00,0.00,10.00,0.00,0.00),('1','288','1','49',436,'4','1',15503.20,18380.14,2876.94,517849.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','49',437,'5','1',13087.93,15232.91,2144.98,386096.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','49',438,'6','1',9634.21,11865.58,2231.37,401646.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','49',439,'7','1',8064.21,8064.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','49',440,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','49',441,'9','2',428786.10,428786.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','50',442,'1','1',20264.78,21904.42,1639.64,295135.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','50',443,'2','1',16611.39,16611.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','50',444,'3','1',17659.30,18353.06,693.76,124876.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','50',445,'4','1',18380.14,19258.46,878.32,158097.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','50',446,'5','1',15232.91,17227.95,1995.04,359107.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','50',447,'6','1',11865.58,11865.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','50',448,'7','1',8064.21,8064.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','50',449,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','50',450,'9','2',428786.10,428816.10,30.00,24000.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','51',451,'1','1',21904.42,21904.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','51',452,'2','1',16611.39,17201.97,590.58,106304.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','51',453,'3','1',18353.06,18353.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','51',454,'4','1',19258.46,19440.60,182.14,32785.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','51',455,'5','1',17227.95,17534.21,306.26,55126.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','51',456,'6','1',11865.58,12176.36,310.78,55940.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','51',457,'7','1',8064.21,8064.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','51',458,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','51',459,'9','2',428816.10,428816.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','52',460,'1','1',21904.42,21904.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','52',461,'2','1',17201.97,17414.64,212.67,38280.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','52',462,'3','1',18353.06,18693.51,340.45,61281.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','52',463,'4','1',19440.60,19749.78,309.18,55652.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','52',464,'5','1',17534.21,17534.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','52',465,'6','1',12176.36,12746.73,570.37,102666.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','52',466,'7','1',8064.21,8064.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','52',467,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','52',468,'9','2',428816.10,428846.10,30.00,24000.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','53',469,'1','1',21904.42,22673.35,768.93,138407.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','53',470,'2','1',17414.64,17414.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','53',471,'3','1',18693.51,19258.49,564.98,101696.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','53',472,'4','1',19749.78,19749.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','53',473,'5','1',17534.21,17827.63,293.42,52815.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','53',474,'6','1',12746.73,12972.45,225.72,40629.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','53',475,'7','1',8064.21,8064.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','53',476,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','53',477,'9','2',428846.10,428846.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','54',478,'1','1',22673.35,23860.23,1186.88,213638.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','54',479,'2','1',17414.64,17414.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','54',480,'3','1',19258.49,19258.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','54',481,'4','1',19749.78,20231.89,482.11,86779.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','54',482,'5','1',17827.63,18533.85,706.22,127119.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','54',483,'6','1',12972.45,12972.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','54',484,'7','1',8064.21,8264.70,200.49,36088.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','54',485,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','54',486,'9','2',428846.10,428876.10,30.00,24000.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','55',487,'1','1',23860.23,24553.05,692.82,124707.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','55',488,'2','1',17414.64,17414.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','55',489,'3','1',19258.49,19271.26,12.77,2298.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','55',490,'4','1',20231.89,20231.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','55',491,'5','1',18533.85,18885.94,352.09,63376.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','55',492,'6','1',12972.45,13505.46,533.01,95941.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','55',493,'7','1',8264.70,8264.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','55',494,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','55',495,'9','2',428876.10,428876.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','56',496,'1','1',24553.05,25144.60,591.55,106479.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','56',497,'2','1',17414.64,17414.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','56',498,'3','1',19271.26,20276.97,1005.71,181027.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','56',499,'4','1',20231.89,20567.45,335.56,60400.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','56',500,'5','1',18885.94,18885.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','56',501,'6','1',13505.46,14282.98,777.52,139953.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','56',502,'7','1',8264.70,8264.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','56',503,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','56',504,'9','2',428876.10,428906.10,30.00,24000.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','57',505,'1','1',25144.60,25932.86,788.26,141886.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','57',506,'2','1',17414.64,17414.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','57',507,'3','1',20276.97,21173.82,896.85,161433.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','57',508,'4','1',20567.45,20567.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','57',509,'5','1',18885.94,19802.23,916.29,164932.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','57',510,'6','1',14282.98,14282.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','57',511,'7','1',8264.70,8264.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','57',512,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','57',513,'9','2',428906.10,428906.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','58',514,'1','1',25932.86,26847.97,915.11,164719.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','58',515,'2','1',17414.64,17414.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','58',516,'3','1',21173.82,21824.27,650.45,117081.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','58',517,'4','1',20567.45,20567.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','58',518,'5','1',19802.23,20353.67,551.44,99259.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','58',519,'6','1',14282.98,14282.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','58',520,'7','1',8264.70,8264.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','58',521,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','58',522,'9','2',428906.10,428936.10,30.00,24000.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','59',523,'1','1',26847.97,27743.22,895.25,161145.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','59',524,'2','1',17414.64,17414.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','59',525,'3','1',21824.27,21824.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','59',526,'4','1',20567.45,21283.62,716.17,128910.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','59',527,'5','1',20353.67,20353.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','59',528,'6','1',14282.98,15064.65,781.67,140700.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','59',529,'7','1',8264.70,8264.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','59',530,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','59',531,'9','2',428936.10,428936.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','60',532,'1','1',27743.22,28634.51,891.29,160432.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','60',533,'2','1',17414.64,17414.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','60',534,'3','1',21824.27,22888.05,1063.78,191480.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','60',535,'4','1',21283.62,21283.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','60',536,'5','1',20353.67,21159.14,805.47,144984.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','60',537,'6','1',15064.65,15064.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','60',538,'7','1',8264.70,8264.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','60',539,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','60',540,'9','2',428936.10,428966.10,30.00,24000.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','61',541,'1','1',28634.51,29430.70,796.19,143314.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','61',542,'2','1',17414.64,17414.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','61',543,'3','1',22888.05,22888.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','61',544,'4','1',21283.62,22098.05,814.43,146597.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','61',545,'5','1',21159.14,21159.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','61',546,'6','1',15064.65,15734.02,669.37,120486.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','61',547,'7','1',8264.70,8264.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','61',548,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','61',549,'9','2',428966.10,429045.17,79.07,63252.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','62',550,'1','1',29430.70,30348.78,918.08,165254.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','62',551,'2','1',17414.64,17414.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','62',552,'3','1',22888.05,22888.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','62',553,'4','1',22098.05,22464.18,366.13,65903.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','62',554,'5','1',21159.14,22020.44,861.30,155034.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','62',555,'6','1',15734.02,15734.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','62',556,'7','1',8264.70,8264.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','62',557,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','62',558,'9','2',429045.17,429075.16,29.99,23992.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','63',559,'1','1',30348.78,31178.03,829.25,149265.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','63',560,'2','1',17414.64,17414.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','63',561,'3','1',22888.05,22888.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','63',562,'4','1',22464.18,23266.32,802.14,144385.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','63',563,'5','1',22020.44,22645.01,624.57,112422.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','63',564,'6','1',15734.02,15734.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','63',565,'7','1',8264.70,8264.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','63',566,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','63',567,'9','2',429075.16,429076.41,1.25,1000.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','64',568,'1','1',31178.03,32082.95,904.92,162885.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','64',569,'2','1',17414.64,17414.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','64',570,'3','1',22888.05,23788.07,900.02,162003.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','64',571,'4','1',23266.32,23266.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','64',572,'5','1',22645.01,22645.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','64',573,'6','1',15734.02,16767.94,1033.92,186105.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','64',574,'7','1',8264.70,8264.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','64',575,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','64',576,'9','2',429076.41,429106.41,30.00,24000.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','65',577,'1','1',32082.95,32082.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','65',578,'2','1',17414.64,18096.54,681.90,122742.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','65',579,'3','1',23788.07,23788.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','65',580,'4','1',23266.32,23800.04,533.72,96069.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','65',581,'5','1',22645.01,23258.85,613.84,110491.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','65',582,'6','1',16767.94,16767.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','65',583,'7','1',8264.70,8264.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','65',584,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','65',585,'9','2',429106.41,429158.41,52.00,41600.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','66',586,'1','1',32082.95,32082.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','66',587,'2','1',18096.54,19130.36,1033.82,186087.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','66',588,'3','1',23788.07,24742.95,954.88,171878.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','66',589,'4','1',23800.04,23800.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','66',590,'5','1',23258.85,24095.10,836.25,150525.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','66',591,'6','1',16767.94,16767.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','66',592,'7','1',8264.70,8264.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','66',593,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','66',594,'9','2',429158.41,429188.41,30.00,24000.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','67',595,'1','1',32082.95,32967.89,884.94,159289.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','67',596,'2','1',19130.36,19130.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','67',597,'3','1',24742.95,25599.46,856.51,154171.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','67',598,'4','1',23800.04,23800.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','67',599,'5','1',24095.10,24095.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','67',600,'6','1',16767.94,17399.79,631.85,113733.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','67',601,'7','1',8264.70,8264.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','67',602,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','67',603,'9','2',429188.41,429188.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','68',604,'1','1',32967.89,33923.62,955.73,172031.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','68',605,'2','1',19130.36,19130.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','68',606,'3','1',25599.46,26399.41,799.95,143991.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','68',607,'4','1',23800.04,23800.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','68',608,'5','1',24095.10,24095.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','68',609,'6','1',17399.79,17972.55,572.76,103096.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','68',610,'7','1',8264.70,8264.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','68',611,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','68',612,'9','2',429188.41,429218.41,30.00,24000.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','69',613,'1','1',33923.62,34766.08,842.46,151642.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','69',614,'2','1',19130.36,19130.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','69',615,'3','1',26399.41,26399.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','69',616,'4','1',23800.04,24508.04,708.00,127440.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','69',617,'5','1',24095.10,24768.51,673.41,121213.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','69',618,'6','1',17972.55,17972.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','69',619,'7','1',8264.70,8264.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','69',620,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','69',621,'9','2',429218.41,429229.66,11.25,9000.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','70',622,'1','1',34766.08,34766.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','70',623,'2','1',19130.36,20044.68,914.32,164577.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','70',624,'3','1',26399.41,26399.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','70',625,'4','1',24508.04,25296.89,788.85,141993.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','70',626,'5','1',24768.51,25649.76,881.25,158625.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','70',627,'6','1',17972.55,17972.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','70',628,'7','1',8264.70,8264.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','70',629,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','70',630,'9','2',429229.66,429259.66,30.00,24000.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','71',631,'1','1',34766.08,35797.11,1031.03,185585.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','71',632,'2','1',20044.68,20044.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','71',633,'3','1',26399.41,26999.22,599.81,107965.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','71',634,'4','1',25296.89,25296.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','71',635,'5','1',25649.76,25974.06,324.30,58374.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','71',636,'6','1',17972.55,18378.13,405.58,73004.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','71',637,'7','1',8264.70,8264.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','71',638,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','71',639,'9','2',429259.66,429259.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','72',640,'1','1',35797.11,36680.67,883.56,159040.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','72',641,'2','1',20044.68,20044.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','72',642,'3','1',26999.22,26999.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','72',643,'4','1',25296.89,25296.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','72',644,'5','1',25974.06,25974.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','72',645,'6','1',18378.13,19534.69,1156.56,208180.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','72',646,'7','1',8264.70,8264.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','72',647,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','72',648,'9','2',429259.66,429289.66,30.00,24000.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','73',649,'1','1',36680.67,37224.08,543.41,97813.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','73',650,'2','1',20044.68,20044.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','73',651,'3','1',26999.22,26999.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','73',652,'4','1',25296.89,25917.27,620.38,111668.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','73',653,'5','1',25974.06,26455.85,481.79,86722.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','73',654,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','73',655,'7','1',8264.70,8264.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','73',656,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','73',657,'9','2',429289.66,429289.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','74',658,'1','1',37224.08,38088.87,864.79,155662.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','74',659,'2','1',20044.68,20869.58,824.90,148482.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','74',660,'3','1',26999.22,26999.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','74',661,'4','1',25917.27,26026.94,109.67,19740.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','74',662,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','74',663,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','74',664,'7','1',8264.70,8264.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','74',665,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','74',666,'9','2',429289.66,429319.66,30.00,24000.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','75',667,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','75',668,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','75',669,'3','1',26999.22,26999.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','75',670,'4','1',26026.94,26026.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','75',671,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','75',672,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','75',673,'7','1',8264.70,8264.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','75',674,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','75',675,'9','2',429319.66,429369.66,50.00,40000.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','76',676,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','76',677,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','76',678,'3','1',26999.22,26999.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','76',679,'4','1',26026.94,26026.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','76',680,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','76',681,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','76',682,'7','1',8264.70,8264.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','76',683,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','76',684,'9','2',429369.66,439369.66,10000.00,8250000.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','77',685,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','77',686,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','77',687,'3','1',26999.22,26999.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','77',688,'4','1',26026.94,26026.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','77',689,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','77',690,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','77',691,'7','1',8264.70,8264.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','77',692,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','77',693,'9','2',439369.66,439380.66,11.00,9075.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','78',694,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','78',695,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','78',696,'3','1',26999.22,27032.96,33.74,7085.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','78',697,'4','1',26026.94,26070.22,43.28,9088.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','78',698,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','78',699,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','78',700,'7','1',8264.70,8264.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','78',701,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','78',702,'9','2',439380.66,439550.66,170.00,142800.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','79',703,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','79',704,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','79',705,'3','1',27032.96,27338.06,305.10,64071.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','79',706,'4','1',26070.22,26589.19,518.97,108983.70,0.00,0.00,0.00,0.00,0.00),('1','288','1','79',707,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','79',708,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','79',709,'7','1',8264.70,8264.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','79',710,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','79',711,'9','2',439550.66,439600.66,50.00,42000.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','80',712,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','80',713,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','80',714,'3','1',27338.06,28627.92,1289.86,270870.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','80',715,'4','1',26589.19,28114.13,1524.94,320237.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','80',716,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','80',717,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','80',718,'7','1',8264.70,8264.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','80',719,'8','1',3376.85,3376.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','80',720,'9','2',439600.66,439630.66,30.00,25200.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','81',721,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','81',722,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','81',723,'3','1',28627.92,29132.34,504.42,105928.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','81',724,'4','1',28114.13,28667.20,553.07,116144.70,0.00,0.00,0.00,0.00,0.00),('1','288','1','81',725,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','81',726,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','81',727,'7','1',8264.70,8540.46,275.76,57909.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','81',728,'8','1',3376.85,3666.38,289.53,60801.30,0.00,0.00,0.00,0.00,0.00),('1','288','2','81',729,'9','2',439630.66,439630.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','82',730,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','82',731,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','82',732,'3','1',29132.34,29570.44,438.10,92001.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','82',733,'4','1',28667.20,29210.08,542.88,114004.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','82',734,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','82',735,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','82',736,'7','1',8540.46,9042.37,501.91,105401.10,0.00,0.00,0.00,0.00,0.00),('1','288','1','82',737,'8','1',3666.38,3796.72,130.34,27371.40,0.00,0.00,0.00,0.00,0.00),('1','288','2','82',738,'9','2',439630.66,439630.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','83',739,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','83',740,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','83',741,'3','1',29570.44,30186.41,615.97,129353.70,0.00,0.00,0.00,0.00,0.00),('1','288','1','83',742,'4','1',29210.08,29677.49,467.41,98156.10,0.00,0.00,0.00,0.00,0.00),('1','288','1','83',743,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','83',744,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','83',745,'7','1',9042.37,9042.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','83',746,'8','1',3796.72,4519.66,722.94,151817.40,0.00,0.00,0.00,0.00,0.00),('1','288','2','83',747,'9','2',439630.66,440195.66,565.00,474600.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','84',748,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','84',749,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','84',750,'3','1',30186.41,31313.70,1127.29,236730.90,0.00,0.00,0.00,0.00,0.00),('1','288','1','84',751,'4','1',29677.49,30261.17,583.68,122572.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','84',752,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','84',753,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','84',754,'7','1',9042.37,9584.33,541.96,113811.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','84',755,'8','1',4519.66,5004.71,485.05,101860.50,0.00,0.00,0.00,0.00,0.00),('1','288','2','84',756,'9','2',440195.66,440195.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','85',757,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','85',758,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','85',759,'3','1',31313.70,31313.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','85',760,'4','1',30261.17,31257.26,996.09,209178.90,0.00,0.00,0.00,0.00,0.00),('1','288','1','85',761,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','85',762,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','85',763,'7','1',9584.33,10154.49,570.16,119733.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','85',764,'8','1',5004.71,5514.81,510.10,107121.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','85',765,'9','2',440195.66,440195.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','86',766,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','86',767,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','86',768,'3','1',31313.70,32042.43,728.73,153033.30,0.00,0.00,0.00,0.00,0.00),('1','288','1','86',769,'4','1',31257.26,31985.73,728.47,152978.70,0.00,0.00,0.00,0.00,0.00),('1','288','1','86',770,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','86',771,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','86',772,'7','1',10154.49,11282.96,1128.47,236978.70,0.00,0.00,0.00,0.00,0.00),('1','288','1','86',773,'8','1',5514.81,6033.74,518.93,108975.30,0.00,0.00,0.00,0.00,0.00),('1','288','2','86',774,'9','2',440195.66,440195.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','87',775,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','87',776,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','87',777,'3','1',32042.43,33755.64,1713.21,359774.10,0.00,0.00,0.00,0.00,0.00),('1','288','1','87',778,'4','1',31985.73,31985.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','87',779,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','87',780,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','87',781,'7','1',11282.96,11282.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','87',782,'8','1',6033.74,7112.16,1078.42,226468.20,0.00,0.00,0.00,0.00,0.00),('1','288','2','87',783,'9','2',440195.66,440225.66,30.00,25200.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','88',784,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','88',785,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','88',786,'3','1',33755.64,35356.38,1600.74,336155.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','88',787,'4','1',31985.73,33005.17,1019.44,214082.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','88',788,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','88',789,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','88',790,'7','1',11282.96,11907.68,624.72,131191.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','88',791,'8','1',7112.16,7906.60,794.44,166832.40,0.00,0.00,0.00,0.00,0.00),('1','288','2','88',792,'9','2',440225.66,440225.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','89',793,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','89',794,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','89',795,'3','1',35356.38,35356.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','89',796,'4','1',33005.17,34656.45,1651.28,346768.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','89',797,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','89',798,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','89',799,'7','1',11907.68,13342.41,1434.73,301293.30,0.00,0.00,0.00,0.00,0.00),('1','288','1','89',800,'8','1',7906.60,7906.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','89',801,'9','2',440225.66,440225.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','90',802,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','90',803,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','90',804,'3','1',35356.38,36364.48,1008.10,211701.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','90',805,'4','1',34656.45,35570.08,913.63,191862.30,0.00,0.00,0.00,0.00,0.00),('1','288','1','90',806,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','90',807,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','90',808,'7','1',13342.41,14527.98,1185.57,248969.70,0.00,0.00,0.00,0.00,0.00),('1','288','1','90',809,'8','1',7906.60,9333.72,1427.12,299695.20,0.00,0.00,0.00,0.00,0.00),('1','288','2','90',810,'9','2',440225.66,440225.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','91',811,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','91',812,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','91',813,'3','1',36364.48,38125.97,1761.49,369912.90,0.00,0.00,0.00,0.00,0.00),('1','288','1','91',814,'4','1',35570.08,35570.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','91',815,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','91',816,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','91',817,'7','1',14527.98,14527.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','91',818,'8','1',9333.72,10602.83,1269.11,266513.10,0.00,0.00,0.00,0.00,0.00),('1','288','2','91',819,'9','2',440225.66,440255.66,30.00,25200.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','92',820,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','92',821,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','92',822,'3','1',38125.97,39514.92,1388.95,291679.50,0.00,0.00,0.00,0.00,0.00),('1','288','1','92',823,'4','1',35570.08,36720.17,1150.09,241518.90,0.00,0.00,0.00,0.00,0.00),('1','288','1','92',824,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','92',825,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','92',826,'7','1',14527.98,16245.20,1717.22,360616.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','92',827,'8','1',10602.83,11561.47,958.64,201314.40,0.00,0.00,0.00,0.00,0.00),('1','288','2','92',828,'9','2',440255.66,440255.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','93',829,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','93',830,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','93',831,'3','1',39514.92,40670.91,1155.99,242757.90,0.00,0.00,0.00,0.00,0.00),('1','288','1','93',832,'4','1',36720.17,37702.42,982.25,206272.50,0.00,0.00,0.00,0.00,0.00),('1','288','1','93',833,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','93',834,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','93',835,'7','1',16245.20,16245.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','93',836,'8','1',11561.47,12984.26,1422.79,298785.90,0.00,0.00,0.00,0.00,0.00),('1','288','2','93',837,'9','2',440255.66,440585.56,329.90,277116.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','94',838,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','94',839,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','94',840,'3','1',40670.91,41908.88,1237.97,259973.70,0.00,0.00,0.00,0.00,0.00),('1','288','1','94',841,'4','1',37702.42,38379.79,677.37,142247.70,0.00,0.00,0.00,0.00,0.00),('1','288','1','94',842,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','94',843,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','94',844,'7','1',16245.20,17014.62,769.42,161578.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','94',845,'8','1',12984.26,13769.52,785.26,164904.60,0.00,0.00,0.00,0.00,0.00),('1','288','2','94',846,'9','2',440585.56,440585.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','95',847,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','95',848,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','95',849,'3','1',41908.88,42768.89,860.01,180602.10,0.00,0.00,0.00,0.00,0.00),('1','288','1','95',850,'4','1',38379.79,38860.22,480.43,100890.30,0.00,0.00,0.00,0.00,0.00),('1','288','1','95',851,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','95',852,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','95',853,'7','1',17014.62,17841.54,826.92,173653.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','95',854,'8','1',13769.52,13769.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','95',855,'9','2',440585.56,440615.56,30.00,25200.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','96',856,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','96',857,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','96',858,'3','1',42768.89,43589.08,820.19,172239.90,0.00,0.00,0.00,0.00,0.00),('1','288','1','96',859,'4','1',38860.22,39572.66,712.44,149612.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','96',860,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','96',861,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','96',862,'7','1',17841.54,18555.08,713.54,149843.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','96',863,'8','1',13769.52,13769.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','96',864,'9','2',440615.56,440615.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','97',865,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','97',866,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','97',867,'3','1',43589.08,43589.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','97',868,'4','1',39572.66,40497.22,924.56,194157.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','97',869,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','97',870,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','97',871,'7','1',18555.08,19270.54,715.46,150246.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','97',872,'8','1',13769.52,14176.27,406.75,85417.50,0.00,0.00,0.00,0.00,0.00),('1','288','2','97',873,'9','2',440615.56,440645.56,30.00,26400.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','98',874,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','98',875,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','98',876,'3','1',43589.08,44826.91,1237.83,259944.30,0.00,0.00,0.00,0.00,0.00),('1','288','1','98',877,'4','1',40497.22,41228.68,731.46,153606.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','98',878,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','98',879,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','98',880,'7','1',19270.54,20102.85,832.31,174785.10,0.00,0.00,0.00,0.00,0.00),('1','288','1','98',881,'8','1',14176.27,14743.67,567.40,119154.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','98',882,'9','2',440645.56,440675.56,30.00,26400.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','99',883,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','99',884,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','99',885,'3','1',44826.91,45886.70,1059.79,222555.90,0.00,0.00,0.00,0.00,0.00),('1','288','1','99',886,'4','1',41228.68,41894.27,665.59,139773.90,0.00,0.00,0.00,0.00,0.00),('1','288','1','99',887,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','99',888,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','99',889,'7','1',20102.85,21071.93,969.08,203506.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','99',890,'8','1',14743.67,15279.02,535.35,112423.50,0.00,0.00,0.00,0.00,0.00),('1','288','2','99',891,'9','2',440675.56,440705.56,30.00,26400.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','100',892,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','100',893,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','100',894,'3','1',45886.70,45886.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','100',895,'4','1',41894.27,41894.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','100',896,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','100',897,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','100',898,'7','1',21071.93,21071.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','100',899,'8','1',15279.02,15279.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','100',900,'9','2',440705.56,447735.56,7030.00,5694300.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','101',901,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','101',902,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','101',903,'3','1',45886.70,45886.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','101',904,'4','1',41894.27,41894.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','101',905,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','101',906,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','101',907,'7','1',21071.93,21071.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','101',908,'8','1',15279.02,15279.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','101',909,'9','2',447735.56,447735.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','102',910,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','102',911,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','102',912,'3','1',45886.70,45886.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','102',913,'4','1',41894.27,41894.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','102',914,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','102',915,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','102',916,'7','1',21071.93,21071.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','102',917,'8','1',15279.02,15279.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','102',918,'9','2',447735.56,447735.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','103',919,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','103',920,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','103',921,'3','1',45886.70,46986.97,1100.27,258563.45,0.00,0.00,0.00,0.00,0.00),('1','288','1','103',922,'4','1',41894.27,43152.65,1258.38,295719.30,0.00,0.00,0.00,0.00,0.00),('1','288','1','103',923,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','103',924,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','103',925,'7','1',21071.93,22093.03,1021.10,239958.50,0.00,0.00,0.00,0.00,0.00),('1','288','1','103',926,'8','1',15279.02,16477.64,1198.62,281675.70,0.00,0.00,0.00,0.00,0.00),('1','288','2','103',927,'9','2',447735.56,448195.56,460.00,372600.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','104',928,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','104',929,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','104',930,'3','1',46986.97,48260.24,1273.27,299218.45,0.00,0.00,0.00,0.00,0.00),('1','288','1','104',931,'4','1',43152.65,44212.84,1060.19,249144.65,0.00,0.00,0.00,0.00,0.00),('1','288','1','104',932,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','104',933,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','104',934,'7','1',22093.03,22957.31,864.28,203105.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','104',935,'8','1',16477.64,18197.73,1720.09,404221.15,0.00,0.00,0.00,0.00,0.00),('1','288','2','104',936,'9','2',448195.56,448195.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','105',937,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','105',938,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','105',939,'3','1',48260.24,49832.44,1572.20,369467.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','105',940,'4','1',44212.84,45682.18,1469.34,345294.90,0.00,0.00,0.00,0.00,0.00),('1','288','1','105',941,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','105',942,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','105',943,'7','1',22957.31,23901.07,943.76,221783.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','105',944,'8','1',18197.73,20373.79,2176.06,511374.10,0.00,0.00,0.00,0.00,0.00),('1','288','2','105',945,'9','2',448195.56,448195.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','106',946,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','106',947,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','106',948,'3','1',49832.44,51137.49,1305.05,306686.75,0.00,0.00,0.00,0.00,0.00),('1','288','1','106',949,'4','1',45682.18,47769.79,2087.61,490588.35,0.00,0.00,0.00,0.00,0.00),('1','288','1','106',950,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','106',951,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','106',952,'7','1',23901.07,25783.44,1882.37,442356.95,0.00,0.00,0.00,0.00,0.00),('1','288','1','106',953,'8','1',20373.79,21842.21,1468.42,345078.70,0.00,0.00,0.00,0.00,0.00),('1','288','2','106',954,'9','2',448195.56,448195.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','107',955,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','107',956,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','107',957,'3','1',51137.49,53077.25,1939.76,455843.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','107',958,'4','1',47769.79,49845.00,2075.21,487674.35,0.00,0.00,0.00,0.00,0.00),('1','288','1','107',959,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','107',960,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','107',961,'7','1',25783.44,27732.88,1949.44,458118.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','107',962,'8','1',21842.21,23866.17,2023.96,475630.60,0.00,0.00,0.00,0.00,0.00),('1','288','2','107',963,'9','2',448195.56,448195.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','108',964,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','108',965,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','108',966,'3','1',53077.25,55899.74,2822.49,663285.15,0.00,0.00,0.00,0.00,0.00),('1','288','1','108',967,'4','1',49845.00,52328.47,2483.47,583615.45,0.00,0.00,0.00,0.00,0.00),('1','288','1','108',968,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','108',969,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','108',970,'7','1',27732.88,29790.98,2058.10,483653.50,0.00,0.00,0.00,0.00,0.00),('1','288','1','108',971,'8','1',23866.17,26399.51,2533.34,595334.90,0.00,0.00,0.00,0.00,0.00),('1','288','2','108',972,'9','2',448195.56,448195.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','109',973,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','109',974,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','109',975,'3','1',55899.74,57372.90,1473.16,346192.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','109',976,'4','1',52328.47,53198.97,870.50,204567.50,0.00,0.00,0.00,0.00,0.00),('1','288','1','109',977,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','109',978,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','109',979,'7','1',29790.98,31632.52,1841.54,432761.90,0.00,0.00,0.00,0.00,0.00),('1','288','1','109',980,'8','1',26399.51,27098.60,699.09,164286.15,0.00,0.00,0.00,0.00,0.00),('1','288','2','109',981,'9','2',448195.56,448195.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','110',982,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','110',983,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','110',984,'3','1',57372.90,58688.46,1315.56,309156.60,0.00,0.00,0.00,0.00,0.00),('1','288','1','110',985,'4','1',53198.97,55132.69,1933.72,454424.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','110',986,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','110',987,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','110',988,'7','1',31632.52,33476.22,1843.70,433269.50,0.00,0.00,0.00,0.00,0.00),('1','288','1','110',989,'8','1',27098.60,28963.06,1864.46,438148.10,0.00,0.00,0.00,0.00,0.00),('1','288','2','110',990,'9','2',448195.56,448195.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','111',991,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','111',992,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','111',993,'3','1',58688.46,60293.12,1604.66,377095.10,0.00,0.00,0.00,0.00,0.00),('1','288','1','111',994,'4','1',55132.69,56872.07,1739.38,408754.30,0.00,0.00,0.00,0.00,0.00),('1','288','1','111',995,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','111',996,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','111',997,'7','1',33476.22,35159.14,1682.92,395486.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','111',998,'8','1',28963.06,30892.99,1929.93,453533.55,0.00,0.00,0.00,0.00,0.00),('1','288','2','111',999,'9','2',448195.56,448195.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','112',1000,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','112',1001,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','112',1002,'3','1',60293.12,61305.94,1012.82,238012.70,0.00,0.00,0.00,0.00,0.00),('1','288','1','112',1003,'4','1',56872.07,58826.19,1954.12,459218.20,0.00,0.00,0.00,0.00,0.00),('1','288','1','112',1004,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','112',1005,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','112',1006,'7','1',35159.14,36727.68,1568.54,368606.90,0.00,0.00,0.00,0.00,0.00),('1','288','1','112',1007,'8','1',30892.99,32530.84,1637.85,384894.75,0.00,0.00,0.00,0.00,0.00),('1','288','2','112',1008,'9','2',448195.56,448405.56,210.00,168000.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','113',1009,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','113',1010,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','113',1011,'3','1',61305.94,63084.57,1778.63,417978.05,0.00,0.00,0.00,0.00,0.00),('1','288','1','113',1012,'4','1',58826.19,60497.83,1671.64,392835.40,0.00,0.00,0.00,0.00,0.00),('1','288','1','113',1013,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','113',1014,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','113',1015,'7','1',36727.68,37904.50,1176.82,276552.70,0.00,0.00,0.00,0.00,0.00),('1','288','1','113',1016,'8','1',32530.84,34348.06,1817.22,427046.70,0.00,0.00,0.00,0.00,0.00),('1','288','2','113',1017,'9','2',448405.56,448405.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','114',1018,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','114',1019,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','114',1020,'3','1',63084.57,64141.96,1057.39,248486.65,0.00,0.00,0.00,0.00,0.00),('1','288','1','114',1021,'4','1',60497.83,61323.84,826.01,194112.35,0.00,0.00,0.00,0.00,0.00),('1','288','1','114',1022,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','114',1023,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','114',1024,'7','1',37904.50,38869.50,965.00,226775.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','114',1025,'8','1',34348.06,35234.26,886.20,208257.00,0.00,0.00,0.00,0.00,0.00),('1','288','2','114',1026,'9','2',448405.56,448405.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','115',1027,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','115',1028,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','115',1029,'3','1',64141.96,65714.16,1572.20,369467.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','115',1030,'4','1',61323.84,62213.32,889.48,209027.80,0.00,0.00,0.00,0.00,0.00),('1','288','1','115',1031,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','115',1032,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','115',1033,'7','1',38869.50,40618.36,1748.86,410982.10,0.00,0.00,0.00,0.00,0.00),('1','288','1','115',1034,'8','1',35234.26,35627.31,393.05,92366.75,0.00,0.00,0.00,0.00,0.00),('1','288','2','115',1035,'9','2',448405.56,448405.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','116',1036,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','116',1037,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','116',1038,'3','1',65714.16,68266.74,2552.58,599856.30,0.00,0.00,0.00,0.00,0.00),('1','288','1','116',1039,'4','1',62213.32,64263.66,2050.34,481829.90,0.00,0.00,0.00,0.00,0.00),('1','288','1','116',1040,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','116',1041,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','116',1042,'7','1',40618.36,43875.16,3256.80,765348.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','116',1043,'8','1',35627.31,37908.27,2280.96,536025.60,0.00,0.00,0.00,0.00,0.00),('1','288','2','116',1044,'9','2',448405.56,448405.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','117',1045,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','117',1046,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','117',1047,'3','1',68266.74,72094.67,3827.93,899563.55,0.00,0.00,0.00,0.00,0.00),('1','288','1','117',1048,'4','1',64263.66,66930.08,2666.42,626608.70,0.00,0.00,0.00,0.00,0.00),('1','288','1','117',1049,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','117',1050,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','117',1051,'7','1',43875.16,47285.58,3410.42,801448.70,0.00,0.00,0.00,0.00,0.00),('1','288','1','117',1052,'8','1',37908.27,39709.75,1801.48,423347.80,0.00,0.00,0.00,0.00,0.00),('1','288','2','117',1053,'9','2',448405.56,448405.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','118',1054,'1','1',38088.87,38088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','118',1055,'2','1',20869.58,20869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','118',1056,'3','1',72094.67,74173.68,2079.01,488567.35,0.00,0.00,0.00,0.00,0.00),('1','288','1','118',1057,'4','1',66930.08,69072.94,2142.86,503572.10,0.00,0.00,0.00,0.00,0.00),('1','288','1','118',1058,'5','1',26455.85,26455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','118',1059,'6','1',19534.69,19534.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','288','1','118',1060,'7','1',47285.58,50033.63,2748.05,645791.75,0.00,0.00,0.00,0.00,0.00),('1','288','1','118',1061,'8','1',39709.75,41251.10,1541.35,362217.25,0.00,0.00,0.00,0.00,0.00),('1','288','2','118',1062,'9','2',448405.56,448618.10,212.54,167906.60,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=237 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','288','1','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,1),('1','288','1','1',180.00,180.00,1466.60,0.00,0.00,0.00,0.00,2),('1','288','2','1',180.00,180.00,1921.72,0.00,0.00,0.00,0.00,3),('1','288','2','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,4),('1','288','3','1',180.00,0.00,1569.02,0.00,0.00,0.00,0.00,5),('1','288','3','2',770.00,0.00,0.00,0.00,0.00,0.00,0.00,6),('1','288','4','1',180.00,0.00,0.00,0.00,0.00,0.00,0.00,7),('1','288','4','2',770.00,0.00,0.00,0.00,0.00,0.00,0.00,8),('1','288','5','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,9),('1','288','5','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,10),('1','288','6','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,11),('1','288','6','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,12),('1','288','7','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,13),('1','288','7','1',180.00,180.00,1944.59,0.00,0.00,0.00,0.00,14),('1','288','8','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,15),('1','288','8','1',180.00,180.00,1313.53,0.00,0.00,0.00,0.00,16),('1','288','9','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,17),('1','288','9','1',180.00,180.00,968.98,0.00,0.00,0.00,0.00,18),('1','288','10','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,19),('1','288','10','1',180.00,180.00,1204.30,0.00,0.00,0.00,0.00,20),('1','288','11','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,21),('1','288','11','1',180.00,180.00,955.20,0.00,0.00,0.00,0.00,22),('1','288','12','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,23),('1','288','12','1',180.00,180.00,6805.72,0.00,0.00,0.00,0.00,24),('1','288','13','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,25),('1','288','13','1',180.00,180.00,972.19,0.00,0.00,0.00,0.00,26),('1','288','14','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,27),('1','288','14','1',180.00,180.00,1170.32,0.00,0.00,0.00,0.00,28),('1','288','15','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,29),('1','288','15','1',180.00,180.00,1325.26,0.00,0.00,0.00,0.00,30),('1','288','16','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,31),('1','288','16','1',180.00,180.00,11092.77,0.00,0.00,0.00,0.00,32),('1','288','17','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,33),('1','288','17','1',180.00,180.00,869.37,0.00,0.00,0.00,0.00,34),('1','288','18','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,35),('1','288','18','1',180.00,180.00,496.61,0.00,0.00,0.00,0.00,36),('1','288','19','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,37),('1','288','19','1',180.00,180.00,1207.80,0.00,0.00,0.00,0.00,38),('1','288','20','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,39),('1','288','20','1',180.00,180.00,1341.52,0.00,0.00,0.00,0.00,40),('1','288','21','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,41),('1','288','21','1',180.00,180.00,1186.81,0.00,0.00,0.00,0.00,42),('1','288','22','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,43),('1','288','22','1',180.00,180.00,512.94,0.00,0.00,0.00,0.00,44),('1','288','23','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,45),('1','288','23','1',180.00,180.00,969.87,0.00,0.00,0.00,0.00,46),('1','288','24','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,47),('1','288','24','1',180.00,180.00,1166.89,0.00,0.00,0.00,0.00,48),('1','288','25','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,49),('1','288','25','1',180.00,180.00,1140.24,0.00,0.00,0.00,0.00,50),('1','288','26','2',770.00,770.00,25.47,0.00,0.00,0.00,0.00,51),('1','288','26','1',180.00,180.00,1161.78,0.00,0.00,0.00,0.00,52),('1','288','27','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,53),('1','288','27','1',180.00,180.00,1115.08,0.00,0.00,0.00,0.00,54),('1','288','28','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,55),('1','288','28','1',180.00,180.00,1557.71,0.00,0.00,0.00,0.00,56),('1','288','29','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,57),('1','288','29','1',180.00,180.00,1206.23,0.00,0.00,0.00,0.00,58),('1','288','30','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,59),('1','288','30','1',180.00,180.00,915.69,0.00,0.00,0.00,0.00,60),('1','288','31','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,61),('1','288','31','1',180.00,180.00,1124.86,0.00,0.00,0.00,0.00,62),('1','288','32','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,63),('1','288','32','1',180.00,180.00,1191.62,0.00,0.00,0.00,0.00,64),('1','288','33','2',770.00,770.00,50.00,0.00,0.00,0.00,0.00,65),('1','288','33','1',180.00,180.00,1261.39,0.00,0.00,0.00,0.00,66),('1','288','34','2',770.00,770.00,100.00,0.00,0.00,0.00,0.00,67),('1','288','34','1',180.00,180.00,1664.40,0.00,0.00,0.00,0.00,68),('1','288','35','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,69),('1','288','35','1',180.00,180.00,1444.57,0.00,0.00,0.00,0.00,70),('1','288','36','2',770.00,770.00,50.01,0.00,0.00,0.00,0.00,71),('1','288','36','1',180.00,180.00,1182.03,0.00,0.00,0.00,0.00,72),('1','288','37','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,73),('1','288','37','1',180.00,180.00,1145.66,0.00,0.00,0.00,0.00,74),('1','288','38','2',800.00,800.00,50.00,0.00,0.00,0.00,0.00,75),('1','288','38','1',180.00,180.00,5621.35,0.00,0.00,0.00,0.00,76),('1','288','39','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,77),('1','288','39','1',180.00,180.00,1649.27,0.00,0.00,0.00,0.00,78),('1','288','40','2',800.00,800.00,50.00,0.00,0.00,0.00,0.00,79),('1','288','40','1',180.00,180.00,1514.01,0.00,0.00,0.00,0.00,80),('1','288','41','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,81),('1','288','41','1',180.00,180.00,1476.98,0.00,0.00,0.00,0.00,82),('1','288','42','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,83),('1','288','42','1',180.00,180.00,1338.92,0.00,0.00,0.00,0.00,84),('1','288','43','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,85),('1','288','43','1',180.00,180.00,1580.48,0.00,0.00,0.00,0.00,86),('1','288','44','2',800.00,800.00,50.00,0.00,0.00,0.00,0.00,87),('1','288','44','1',180.00,180.00,1178.90,0.00,0.00,0.00,0.00,88),('1','288','45','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,89),('1','288','45','1',180.00,180.00,1813.22,0.00,0.00,0.00,0.00,90),('1','288','46','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,91),('1','288','46','1',180.00,180.00,1358.60,0.00,0.00,0.00,0.00,92),('1','288','47','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,93),('1','288','47','1',180.00,180.00,2549.97,0.00,0.00,0.00,0.00,94),('1','288','48','2',800.00,800.00,50.00,0.00,0.00,0.00,0.00,95),('1','288','48','1',180.00,180.00,3398.94,0.00,0.00,0.00,0.00,96),('1','288','49','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,97),('1','288','49','1',180.00,180.00,10105.84,0.00,0.00,0.00,0.00,98),('1','288','50','2',800.00,800.00,30.00,0.00,0.00,0.00,0.00,99),('1','288','50','1',180.00,180.00,5206.76,0.00,0.00,0.00,0.00,100),('1','288','51','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,101),('1','288','51','1',180.00,180.00,1389.76,0.00,0.00,0.00,0.00,102),('1','288','52','2',800.00,800.00,30.00,0.00,0.00,0.00,0.00,103),('1','288','52','1',180.00,180.00,1432.67,0.00,0.00,0.00,0.00,104),('1','288','53','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,105),('1','288','53','1',180.00,180.00,1853.05,0.00,0.00,0.00,0.00,106),('1','288','54','2',800.00,800.00,30.00,0.00,0.00,0.00,0.00,107),('1','288','54','1',180.00,180.00,2575.70,0.00,0.00,0.00,0.00,108),('1','288','55','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,109),('1','288','55','1',180.00,180.00,1590.69,0.00,0.00,0.00,0.00,110),('1','288','56','2',800.00,800.00,30.00,0.00,0.00,0.00,0.00,111),('1','288','56','1',180.00,180.00,2710.34,0.00,0.00,0.00,0.00,112),('1','288','57','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,113),('1','288','57','1',180.00,180.00,2601.40,0.00,0.00,0.00,0.00,114),('1','288','58','2',800.00,800.00,30.00,0.00,0.00,0.00,0.00,115),('1','288','58','1',180.00,180.00,2117.00,0.00,0.00,0.00,0.00,116),('1','288','59','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,117),('1','288','59','1',180.00,180.00,2393.09,0.00,0.00,0.00,0.00,118),('1','288','60','2',800.00,800.00,30.00,0.00,0.00,0.00,0.00,119),('1','288','60','1',180.00,180.00,2760.54,0.00,0.00,0.00,0.00,120),('1','288','61','2',800.00,800.00,79.07,0.00,0.00,0.00,0.00,121),('1','288','61','1',180.00,180.00,2279.99,0.00,0.00,0.00,0.00,122),('1','288','62','2',800.00,800.00,29.99,0.00,0.00,0.00,0.00,123),('1','288','62','1',180.00,180.00,2145.51,0.00,0.00,0.00,0.00,124),('1','288','63','2',800.00,800.00,1.25,0.00,0.00,0.00,0.00,125),('1','288','63','1',180.00,180.00,2255.96,0.00,0.00,0.00,0.00,126),('1','288','64','2',800.00,800.00,30.00,0.00,0.00,0.00,0.00,127),('1','288','64','1',180.00,180.00,2838.86,0.00,0.00,0.00,0.00,128),('1','288','65','2',800.00,800.00,52.00,0.00,0.00,0.00,0.00,129),('1','288','65','1',180.00,180.00,1829.46,0.00,0.00,0.00,0.00,130),('1','288','66','2',800.00,800.00,30.00,0.00,0.00,0.00,0.00,131),('1','288','66','1',180.00,180.00,2824.95,0.00,0.00,0.00,0.00,132),('1','288','67','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,133),('1','288','67','1',180.00,180.00,2373.30,0.00,0.00,0.00,0.00,134),('1','288','68','2',800.00,800.00,30.00,0.00,0.00,0.00,0.00,135),('1','288','68','1',180.00,180.00,2328.44,0.00,0.00,0.00,0.00,136),('1','288','69','2',800.00,800.00,11.25,0.00,0.00,0.00,0.00,137),('1','288','69','1',180.00,180.00,2223.87,0.00,0.00,0.00,0.00,138),('1','288','70','2',800.00,800.00,30.00,0.00,0.00,0.00,0.00,139),('1','288','70','1',180.00,180.00,2584.42,0.00,0.00,0.00,0.00,140),('1','288','71','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,141),('1','288','71','1',180.00,180.00,2360.72,0.00,0.00,0.00,0.00,142),('1','288','72','2',800.00,800.00,30.00,0.00,0.00,0.00,0.00,143),('1','288','72','1',180.00,180.00,2040.12,0.00,0.00,0.00,0.00,144),('1','288','73','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,145),('1','288','73','1',180.00,180.00,1645.58,0.00,0.00,0.00,0.00,146),('1','288','74','2',800.00,800.00,30.00,0.00,0.00,0.00,0.00,147),('1','288','74','1',180.00,180.00,1799.36,0.00,0.00,0.00,0.00,148),('1','288','75','2',800.00,800.00,50.00,0.00,0.00,0.00,0.00,149),('1','288','75','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,150),('1','288','76','2',825.00,825.00,10000.00,0.00,0.00,0.00,0.00,151),('1','288','76','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,152),('1','288','77','2',825.00,825.00,11.00,0.00,0.00,0.00,0.00,153),('1','288','77','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,154),('1','288','78','2',840.00,840.00,170.00,0.00,0.00,0.00,0.00,155),('1','288','78','1',210.00,210.00,77.02,0.00,0.00,0.00,0.00,156),('1','288','79','2',840.00,840.00,50.00,0.00,0.00,0.00,0.00,157),('1','288','79','1',210.00,210.00,824.07,0.00,0.00,0.00,0.00,158),('1','288','80','2',840.00,840.00,30.00,0.00,0.00,0.00,0.00,159),('1','288','80','1',210.00,210.00,2814.80,0.00,0.00,0.00,0.00,160),('1','288','81','2',840.00,840.00,0.00,0.00,0.00,0.00,0.00,161),('1','288','81','1',210.00,210.00,1622.78,0.00,0.00,0.00,0.00,162),('1','288','82','2',840.00,840.00,0.00,0.00,0.00,0.00,0.00,163),('1','288','82','1',210.00,210.00,1613.23,0.00,0.00,0.00,0.00,164),('1','288','83','2',840.00,840.00,565.00,0.00,0.00,0.00,0.00,165),('1','288','83','1',210.00,210.00,1806.32,0.00,0.00,0.00,0.00,166),('1','288','84','2',840.00,840.00,0.00,0.00,0.00,0.00,0.00,167),('1','288','84','1',210.00,210.00,2737.98,0.00,0.00,0.00,0.00,168),('1','288','85','2',840.00,840.00,0.00,0.00,0.00,0.00,0.00,169),('1','288','85','1',210.00,210.00,2076.35,0.00,0.00,0.00,0.00,170),('1','288','86','2',840.00,840.00,0.00,0.00,0.00,0.00,0.00,171),('1','288','86','1',210.00,210.00,3104.60,0.00,0.00,0.00,0.00,172),('1','288','87','2',840.00,840.00,30.00,0.00,0.00,0.00,0.00,173),('1','288','87','1',210.00,210.00,2791.63,0.00,0.00,0.00,0.00,174),('1','288','88','2',840.00,840.00,0.00,0.00,0.00,0.00,0.00,175),('1','288','88','1',210.00,210.00,4039.34,0.00,0.00,0.00,0.00,176),('1','288','89','2',840.00,840.00,0.00,0.00,0.00,0.00,0.00,177),('1','288','89','1',210.00,210.00,3086.01,0.00,0.00,0.00,0.00,178),('1','288','90','2',840.00,840.00,0.00,0.00,0.00,0.00,0.00,179),('1','288','90','1',210.00,210.00,4534.42,0.00,0.00,0.00,0.00,180),('1','288','91','2',840.00,840.00,30.00,0.00,0.00,0.00,0.00,181),('1','288','91','1',210.00,210.00,3030.60,0.00,0.00,0.00,0.00,182),('1','288','92','2',840.00,840.00,0.00,0.00,0.00,0.00,0.00,183),('1','288','92','1',210.00,210.00,5214.90,0.00,0.00,0.00,0.00,184),('1','288','93','2',840.00,840.00,329.90,0.00,0.00,0.00,0.00,185),('1','288','93','1',210.00,210.00,3561.03,0.00,0.00,0.00,0.00,186),('1','288','94','2',840.00,840.00,0.00,0.00,0.00,0.00,0.00,187),('1','288','94','1',210.00,210.00,3470.02,0.00,0.00,0.00,0.00,188),('1','288','95','2',840.00,840.00,30.00,0.00,0.00,0.00,0.00,189),('1','288','95','1',210.00,210.00,2167.36,0.00,0.00,0.00,0.00,190),('1','288','96','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,191),('1','288','96','1',210.00,210.00,2246.17,0.00,0.00,0.00,0.00,192),('1','288','97','2',880.00,880.00,30.00,0.00,0.00,0.00,0.00,193),('1','288','97','1',210.00,210.00,2046.77,0.00,0.00,0.00,0.00,194),('1','288','98','2',880.00,880.00,30.00,0.00,0.00,0.00,0.00,195),('1','288','98','1',210.00,210.00,3369.00,0.00,0.00,0.00,0.00,196),('1','288','99','2',880.00,880.00,30.00,0.00,0.00,0.00,0.00,197),('1','288','99','1',210.00,210.00,3229.81,0.00,0.00,0.00,0.00,198),('1','288','100','2',810.00,810.00,7030.00,0.00,0.00,0.00,0.00,199),('1','288','100','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,200),('1','288','101','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,201),('1','288','101','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,202),('1','288','102','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,203),('1','288','102','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,204),('1','288','103','2',810.00,810.00,460.00,0.00,0.00,0.00,0.00,205),('1','288','103','1',235.00,235.00,4578.37,0.00,0.00,0.00,0.00,206),('1','288','104','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,207),('1','288','104','1',235.00,235.00,4917.83,0.00,0.00,0.00,0.00,208),('1','288','105','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,209),('1','288','105','1',235.00,235.00,6161.36,0.00,0.00,0.00,0.00,210),('1','288','106','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,211),('1','288','106','1',235.00,235.00,6743.45,0.00,0.00,0.00,0.00,212),('1','288','107','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,213),('1','288','107','1',235.00,235.00,7988.37,0.00,0.00,0.00,0.00,214),('1','288','108','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,215),('1','288','108','1',235.00,235.00,9897.40,0.00,0.00,0.00,0.00,216),('1','288','109','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,217),('1','288','109','1',235.00,235.00,4884.29,0.00,0.00,0.00,0.00,218),('1','288','110','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,219),('1','288','110','1',235.00,235.00,6957.44,0.00,0.00,0.00,0.00,220),('1','288','111','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,221),('1','288','111','1',235.00,235.00,6956.89,0.00,0.00,0.00,0.00,222),('1','288','112','2',800.00,800.00,210.00,0.00,0.00,0.00,0.00,223),('1','288','112','1',235.00,235.00,6173.33,0.00,0.00,0.00,0.00,224),('1','288','113','2',790.00,790.00,0.00,0.00,0.00,0.00,0.00,225),('1','288','113','1',235.00,235.00,6444.31,0.00,0.00,0.00,0.00,226),('1','288','114','2',790.00,790.00,0.00,0.00,0.00,0.00,0.00,227),('1','288','114','1',235.00,235.00,3734.60,0.00,0.00,0.00,0.00,228),('1','288','115','2',790.00,790.00,0.00,0.00,0.00,0.00,0.00,229),('1','288','115','1',235.00,235.00,4603.59,0.00,0.00,0.00,0.00,230),('1','288','116','2',790.00,790.00,0.00,0.00,0.00,0.00,0.00,231),('1','288','116','1',235.00,235.00,10140.68,0.00,0.00,0.00,0.00,232),('1','288','117','2',790.00,790.00,0.00,0.00,0.00,0.00,0.00,233),('1','288','117','1',235.00,235.00,11706.25,0.00,0.00,0.00,0.00,234),('1','288','118','2',790.00,790.00,212.54,0.00,0.00,0.00,0.00,235),('1','288','118','1',235.00,235.00,8511.27,0.00,0.00,0.00,0.00,236);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',1,'288','PMS TANKS',''),('1',2,'288','AGO TANK','');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','288','1',1,0,'1','PMS TANK 1,2,3 & 4',180000.00,0.00,NULL,'CONTAING PMS','178','2022-10-19 14:18:56','2022-10-19 14:18:56','178',5,0),('1','288','2',2,0,'2','AGO TANK',45000.00,0.00,NULL,'CONTAING AGO','178','2022-10-19 16:18:08','2022-10-19 16:18:08','178',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','288',2,80.00,'2023-03-20 08:58:58'),(2,'1','288',1,39526.34,'2023-03-20 08:58:58');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=653 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'1','288',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8856000.00,49200.00,0.00,0.00,'2022-10-27 11:10:27','',''),(2,'1','288',NULL,1,'Reception corrector for bridging 4',0.00,0.00,0.00,49200.00,0.00,'2022-10-27 17:37:54','',''),(3,'1','288','1',1,'Received from bridging 4',0.00,0.00,49200.00,0.00,0.00,'2022-10-27 17:37:54','',''),(4,'1','288',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9000000.00,50000.00,0.00,0.00,'2022-10-27 18:06:00','',''),(5,'1','288',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,15092000.00,19600.00,0.00,0.00,'2022-10-27 18:07:00','',''),(6,'1','288','1',1,'Sale Id shift 1',0.00,0.00,0.00,199.84,0.00,'2022-10-28 07:23:01','',''),(7,'1','288','1',1,'Sale Id shift 1',0.00,0.00,0.00,397.04,0.00,'2022-10-28 07:23:01','',''),(8,'1','288','1',1,'Sale Id shift 1',0.00,0.00,0.00,54.99,0.00,'2022-10-28 07:23:01','',''),(9,'1','288','1',1,'Sale Id shift 1',0.00,0.00,0.00,155.70,0.00,'2022-10-28 07:23:01','',''),(10,'1','288','1',1,'Sale Id shift 1',0.00,0.00,0.00,147.15,0.00,'2022-10-28 07:23:01','',''),(11,'1','288','1',1,'Sale Id shift 1',0.00,0.00,0.00,248.83,0.00,'2022-10-28 07:23:01','',''),(12,'1','288','1',1,'Sale Id shift 1',0.00,0.00,0.00,42.20,0.00,'2022-10-28 07:23:01','',''),(13,'1','288','1',1,'Sale Id shift 1',0.00,0.00,0.00,220.85,0.00,'2022-10-28 07:23:01','',''),(14,'1','288',NULL,1,'Sale Id shift 1',263988.00,0.00,0.00,0.00,0.00,'2022-10-28 07:23:01','',''),(15,'1','288','1',1,'Sale Id shift 2',0.00,0.00,0.00,577.28,0.00,'2022-10-30 11:14:04','',''),(16,'1','288','1',1,'Sale Id shift 2',0.00,0.00,0.00,251.78,0.00,'2022-10-30 11:14:04','',''),(17,'1','288','1',1,'Sale Id shift 2',0.00,0.00,0.00,139.12,0.00,'2022-10-30 11:14:04','',''),(18,'1','288','1',1,'Sale Id shift 2',0.00,0.00,0.00,330.42,0.00,'2022-10-30 11:14:04','',''),(19,'1','288','1',1,'Sale Id shift 2',0.00,0.00,0.00,125.49,0.00,'2022-10-30 11:14:04','',''),(20,'1','288','1',1,'Sale Id shift 2',0.00,0.00,0.00,208.29,0.00,'2022-10-30 11:14:04','',''),(21,'1','288','1',1,'Sale Id shift 2',0.00,0.00,0.00,117.43,0.00,'2022-10-30 11:14:04','',''),(22,'1','288','1',1,'Sale Id shift 2',0.00,0.00,0.00,171.91,0.00,'2022-10-30 11:14:04','',''),(23,'1','288',NULL,1,'Sale Id shift 2',345909.60,0.00,0.00,0.00,0.00,'2022-10-30 11:14:04','',''),(24,'1','288','1',1,'Sale Id shift 3',0.00,0.00,0.00,233.36,0.00,'2022-10-30 23:08:27','',''),(25,'1','288','1',1,'Sale Id shift 3',0.00,0.00,0.00,145.05,0.00,'2022-10-30 23:08:27','',''),(26,'1','288','1',1,'Sale Id shift 3',0.00,0.00,0.00,182.16,0.00,'2022-10-30 23:08:27','',''),(27,'1','288','1',1,'Sale Id shift 3',0.00,0.00,0.00,243.43,0.00,'2022-10-30 23:08:27','',''),(28,'1','288','1',1,'Sale Id shift 3',0.00,0.00,0.00,201.83,0.00,'2022-10-30 23:08:27','',''),(29,'1','288','1',1,'Sale Id shift 3',0.00,0.00,0.00,86.65,0.00,'2022-10-30 23:08:27','',''),(30,'1','288','1',1,'Sale Id shift 3',0.00,0.00,0.00,73.84,0.00,'2022-10-30 23:08:27','',''),(31,'1','288','1',1,'Sale Id shift 3',0.00,0.00,0.00,402.70,0.00,'2022-10-30 23:08:27','',''),(32,'1','288',NULL,1,'Sale Id shift 3',282423.60,0.00,0.00,0.00,0.00,'2022-10-30 23:08:27','',''),(33,'1','288','1',1,'Sale Id shift 7',0.00,0.00,0.00,317.01,0.00,'2022-11-03 09:18:47','',''),(34,'1','288','1',1,'Sale Id shift 7',0.00,0.00,0.00,342.62,0.00,'2022-11-03 09:18:47','',''),(35,'1','288','1',1,'Sale Id shift 7',0.00,0.00,0.00,294.40,0.00,'2022-11-03 09:18:47','',''),(36,'1','288','1',1,'Sale Id shift 7',0.00,0.00,0.00,228.96,0.00,'2022-11-03 09:18:47','',''),(37,'1','288','1',1,'Sale Id shift 7',0.00,0.00,0.00,177.17,0.00,'2022-11-03 09:18:47','',''),(38,'1','288','1',1,'Sale Id shift 7',0.00,0.00,0.00,211.07,0.00,'2022-11-03 09:18:47','',''),(39,'1','288','1',1,'Sale Id shift 7',0.00,0.00,0.00,90.36,0.00,'2022-11-03 09:18:47','',''),(40,'1','288','1',1,'Sale Id shift 7',0.00,0.00,0.00,283.00,0.00,'2022-11-03 09:18:47','',''),(41,'1','288',NULL,1,'Sale Id shift 7',350026.20,0.00,0.00,0.00,0.00,'2022-11-03 09:18:47','',''),(42,'1','288','1',1,'Sale Id shift 8',0.00,0.00,0.00,445.91,0.00,'2022-11-03 23:27:16','',''),(43,'1','288','1',1,'Sale Id shift 8',0.00,0.00,0.00,426.10,0.00,'2022-11-03 23:27:16','',''),(44,'1','288','1',1,'Sale Id shift 8',0.00,0.00,0.00,180.03,0.00,'2022-11-03 23:27:16','',''),(45,'1','288','1',1,'Sale Id shift 8',0.00,0.00,0.00,261.49,0.00,'2022-11-03 23:27:16','',''),(46,'1','288',NULL,1,'Sale Id shift 8',236435.40,0.00,0.00,0.00,0.00,'2022-11-03 23:27:16','',''),(47,'1','288','1',1,'Sale Id shift 9',0.00,0.00,0.00,333.74,0.00,'2022-11-06 11:17:44','',''),(48,'1','288','1',1,'Sale Id shift 9',0.00,0.00,0.00,275.92,0.00,'2022-11-06 11:17:44','',''),(49,'1','288','1',1,'Sale Id shift 9',0.00,0.00,0.00,171.34,0.00,'2022-11-06 11:17:44','',''),(50,'1','288','1',1,'Sale Id shift 9',0.00,0.00,0.00,187.98,0.00,'2022-11-06 11:17:44','',''),(51,'1','288',NULL,1,'Sale Id shift 9',174416.40,0.00,0.00,0.00,0.00,'2022-11-06 11:17:44','',''),(52,'1','288','1',1,'Sale Id shift 10',0.00,0.00,0.00,400.67,0.00,'2022-11-06 14:20:04','',''),(53,'1','288','1',1,'Sale Id shift 10',0.00,0.00,0.00,167.33,0.00,'2022-11-06 14:20:04','',''),(54,'1','288','1',1,'Sale Id shift 10',0.00,0.00,0.00,308.05,0.00,'2022-11-06 14:20:04','',''),(55,'1','288','1',1,'Sale Id shift 10',0.00,0.00,0.00,328.25,0.00,'2022-11-06 14:20:04','',''),(56,'1','288',NULL,1,'Sale Id shift 10',216774.00,0.00,0.00,0.00,0.00,'2022-11-06 14:20:04','',''),(57,'1','288','1',1,'Sale Id shift 11',0.00,0.00,0.00,205.20,0.00,'2022-11-06 20:46:51','',''),(58,'1','288','1',1,'Sale Id shift 11',0.00,0.00,0.00,191.57,0.00,'2022-11-06 20:46:51','',''),(59,'1','288','1',1,'Sale Id shift 11',0.00,0.00,0.00,259.55,0.00,'2022-11-06 20:46:51','',''),(60,'1','288','1',1,'Sale Id shift 11',0.00,0.00,0.00,298.88,0.00,'2022-11-06 20:46:51','',''),(61,'1','288',NULL,1,'Sale Id shift 11',171936.00,0.00,0.00,0.00,0.00,'2022-11-06 20:46:51','',''),(62,'1','288','1',1,'Sale Id shift 12',0.00,0.00,0.00,3408.88,0.00,'2022-11-06 21:20:17','',''),(63,'1','288','1',1,'Sale Id shift 12',0.00,0.00,0.00,2464.24,0.00,'2022-11-06 21:20:17','',''),(64,'1','288','1',1,'Sale Id shift 12',0.00,0.00,0.00,333.74,0.00,'2022-11-06 21:20:17','',''),(65,'1','288','1',1,'Sale Id shift 12',0.00,0.00,0.00,598.86,0.00,'2022-11-06 21:20:17','',''),(66,'1','288',NULL,1,'Sale Id shift 12',1225029.60,0.00,0.00,0.00,0.00,'2022-11-06 21:20:17','',''),(67,'1','288','1',1,'Sale Id shift 13',0.00,0.00,0.00,199.46,0.00,'2022-11-07 08:24:11','',''),(68,'1','288','1',1,'Sale Id shift 13',0.00,0.00,0.00,187.11,0.00,'2022-11-07 08:24:11','',''),(69,'1','288','1',1,'Sale Id shift 13',0.00,0.00,0.00,330.18,0.00,'2022-11-07 08:24:11','',''),(70,'1','288','1',1,'Sale Id shift 13',0.00,0.00,0.00,255.44,0.00,'2022-11-07 08:24:11','',''),(71,'1','288',NULL,1,'Sale Id shift 13',174994.20,0.00,0.00,0.00,0.00,'2022-11-07 08:24:11','',''),(72,'1','288','1',1,'Sale Id shift 14',0.00,0.00,0.00,391.07,0.00,'2022-11-08 04:14:24','',''),(73,'1','288','1',1,'Sale Id shift 14',0.00,0.00,0.00,242.04,0.00,'2022-11-08 04:14:24','',''),(74,'1','288','1',1,'Sale Id shift 14',0.00,0.00,0.00,327.77,0.00,'2022-11-08 04:14:24','',''),(75,'1','288','1',1,'Sale Id shift 14',0.00,0.00,0.00,209.44,0.00,'2022-11-08 04:14:24','',''),(76,'1','288',NULL,1,'Sale Id shift 14',210657.60,0.00,0.00,0.00,0.00,'2022-11-08 04:14:24','',''),(77,'1','288','1',1,'Sale Id shift 15',0.00,0.00,0.00,496.32,0.00,'2022-11-08 11:20:20','',''),(78,'1','288','1',1,'Sale Id shift 15',0.00,0.00,0.00,367.55,0.00,'2022-11-08 11:20:20','',''),(79,'1','288','1',1,'Sale Id shift 15',0.00,0.00,0.00,200.72,0.00,'2022-11-08 11:20:20','',''),(80,'1','288','1',1,'Sale Id shift 15',0.00,0.00,0.00,260.67,0.00,'2022-11-08 11:20:20','',''),(81,'1','288',NULL,1,'Sale Id shift 15',238546.80,0.00,0.00,0.00,0.00,'2022-11-08 11:20:20','',''),(82,'1','288','1',1,'Sale Id shift 16',0.00,0.00,0.00,3292.89,0.00,'2022-11-08 13:04:32','',''),(83,'1','288','1',1,'Sale Id shift 16',0.00,0.00,0.00,2611.04,0.00,'2022-11-08 13:04:32','',''),(84,'1','288','1',1,'Sale Id shift 16',0.00,0.00,0.00,2180.97,0.00,'2022-11-08 13:04:32','',''),(85,'1','288','1',1,'Sale Id shift 16',0.00,0.00,0.00,2308.62,0.00,'2022-11-08 13:04:32','',''),(86,'1','288','1',1,'Sale Id shift 16',0.00,0.00,0.00,239.53,0.00,'2022-11-08 13:04:32','',''),(87,'1','288','1',1,'Sale Id shift 16',0.00,0.00,0.00,459.72,0.00,'2022-11-08 13:04:32','',''),(88,'1','288',NULL,1,'Sale Id shift 16',1996698.60,0.00,0.00,0.00,0.00,'2022-11-08 13:04:32','',''),(89,'1','288','1',1,'Sale Id shift 17',0.00,0.00,0.00,342.66,0.00,'2022-11-08 23:07:23','',''),(90,'1','288','1',1,'Sale Id shift 17',0.00,0.00,0.00,243.92,0.00,'2022-11-08 23:07:23','',''),(91,'1','288','1',1,'Sale Id shift 17',0.00,0.00,0.00,187.27,0.00,'2022-11-08 23:07:23','',''),(92,'1','288','1',1,'Sale Id shift 17',0.00,0.00,0.00,95.52,0.00,'2022-11-08 23:07:23','',''),(93,'1','288',NULL,1,'Sale Id shift 17',156486.60,0.00,0.00,0.00,0.00,'2022-11-08 23:07:23','',''),(94,'1','288','1',1,'Sale Id shift 18',0.00,0.00,0.00,241.56,0.00,'2022-11-09 12:04:36','',''),(95,'1','288','1',1,'Sale Id shift 18',0.00,0.00,0.00,54.98,0.00,'2022-11-09 12:04:36','',''),(96,'1','288','1',1,'Sale Id shift 18',0.00,0.00,0.00,142.89,0.00,'2022-11-09 12:04:36','',''),(97,'1','288','1',1,'Sale Id shift 18',0.00,0.00,0.00,57.18,0.00,'2022-11-09 12:04:36','',''),(98,'1','288',NULL,1,'Sale Id shift 18',89389.80,0.00,0.00,0.00,0.00,'2022-11-09 12:04:36','',''),(99,'1','288','1',1,'Sale Id shift 19',0.00,0.00,0.00,282.06,0.00,'2022-11-09 14:37:03','',''),(100,'1','288','1',1,'Sale Id shift 19',0.00,0.00,0.00,217.17,0.00,'2022-11-09 14:37:03','',''),(101,'1','288','1',1,'Sale Id shift 19',0.00,0.00,0.00,89.85,0.00,'2022-11-09 14:37:03','',''),(102,'1','288','1',1,'Sale Id shift 19',0.00,0.00,0.00,170.11,0.00,'2022-11-09 14:37:03','',''),(103,'1','288','1',1,'Sale Id shift 19',0.00,0.00,0.00,79.64,0.00,'2022-11-09 14:37:03','',''),(104,'1','288','1',1,'Sale Id shift 19',0.00,0.00,0.00,92.78,0.00,'2022-11-09 14:37:03','',''),(105,'1','288','1',1,'Sale Id shift 19',0.00,0.00,0.00,178.25,0.00,'2022-11-09 14:37:03','',''),(106,'1','288','1',1,'Sale Id shift 19',0.00,0.00,0.00,97.94,0.00,'2022-11-09 14:37:03','',''),(107,'1','288',NULL,1,'Sale Id shift 19',217404.00,0.00,0.00,0.00,0.00,'2022-11-09 14:37:03','',''),(108,'1','288','1',1,'Sale Id shift 20',0.00,0.00,0.00,278.18,0.00,'2022-11-09 19:26:00','',''),(109,'1','288','1',1,'Sale Id shift 20',0.00,0.00,0.00,325.98,0.00,'2022-11-09 19:26:00','',''),(110,'1','288','1',1,'Sale Id shift 20',0.00,0.00,0.00,174.35,0.00,'2022-11-09 19:26:00','',''),(111,'1','288','1',1,'Sale Id shift 20',0.00,0.00,0.00,563.01,0.00,'2022-11-09 19:26:00','',''),(112,'1','288',NULL,1,'Sale Id shift 20',241473.60,0.00,0.00,0.00,0.00,'2022-11-09 19:26:00','',''),(113,'1','288','1',1,'Sale Id shift 21',0.00,0.00,0.00,480.65,0.00,'2022-11-10 10:29:39','',''),(114,'1','288','1',1,'Sale Id shift 21',0.00,0.00,0.00,238.20,0.00,'2022-11-10 10:29:39','',''),(115,'1','288','1',1,'Sale Id shift 21',0.00,0.00,0.00,310.24,0.00,'2022-11-10 10:29:39','',''),(116,'1','288','1',1,'Sale Id shift 21',0.00,0.00,0.00,157.72,0.00,'2022-11-10 10:29:39','',''),(117,'1','288',NULL,1,'Sale Id shift 21',213625.80,0.00,0.00,0.00,0.00,'2022-11-10 10:29:39','',''),(118,'1','288','1',1,'Sale Id shift 22',0.00,0.00,0.00,87.92,0.00,'2022-11-10 12:58:36','',''),(119,'1','288','1',1,'Sale Id shift 22',0.00,0.00,0.00,90.50,0.00,'2022-11-10 12:58:36','',''),(120,'1','288','1',1,'Sale Id shift 22',0.00,0.00,0.00,238.82,0.00,'2022-11-10 12:58:37','',''),(121,'1','288','1',1,'Sale Id shift 22',0.00,0.00,0.00,95.70,0.00,'2022-11-10 12:58:37','',''),(122,'1','288',NULL,1,'Sale Id shift 22',92329.20,0.00,0.00,0.00,0.00,'2022-11-10 12:58:37','',''),(123,'1','288',NULL,2,'Reception corrector for bridging 5',0.00,0.00,0.00,19600.00,0.00,'2022-11-10 17:38:50','',''),(124,'1','288','2',2,'Received from bridging 5',0.00,0.00,19600.00,0.00,0.00,'2022-11-10 17:38:50','',''),(125,'1','288',NULL,1,'Reception corrector for bridging 6',0.00,0.00,0.00,50000.00,0.00,'2022-11-10 17:39:14','',''),(126,'1','288','1',1,'Received from bridging 6',0.00,0.00,50000.00,0.00,0.00,'2022-11-10 17:39:14','',''),(127,'1','288','1',1,'Sale Id shift 23',0.00,0.00,0.00,470.31,0.00,'2022-11-10 17:56:07','',''),(128,'1','288','1',1,'Sale Id shift 23',0.00,0.00,0.00,28.46,0.00,'2022-11-10 17:56:07','',''),(129,'1','288','1',1,'Sale Id shift 23',0.00,0.00,0.00,471.10,0.00,'2022-11-10 17:56:07','',''),(130,'1','288',NULL,1,'Sale Id shift 23',174576.60,0.00,0.00,0.00,0.00,'2022-11-10 17:56:07','',''),(131,'1','288','1',1,'Sale Id shift 24',0.00,0.00,0.00,526.07,0.00,'2022-11-10 18:07:39','',''),(132,'1','288','1',1,'Sale Id shift 24',0.00,0.00,0.00,293.89,0.00,'2022-11-10 18:07:39','',''),(133,'1','288','1',1,'Sale Id shift 24',0.00,0.00,0.00,184.76,0.00,'2022-11-10 18:07:39','',''),(134,'1','288','1',1,'Sale Id shift 24',0.00,0.00,0.00,162.17,0.00,'2022-11-10 18:07:39','',''),(135,'1','288',NULL,1,'Sale Id shift 24',210040.20,0.00,0.00,0.00,0.00,'2022-11-10 18:07:39','',''),(136,'1','288','1',1,'Sale Id shift 25',0.00,0.00,0.00,467.59,0.00,'2022-11-11 01:59:01','',''),(137,'1','288','1',1,'Sale Id shift 25',0.00,0.00,0.00,365.09,0.00,'2022-11-11 01:59:01','',''),(138,'1','288','1',1,'Sale Id shift 25',0.00,0.00,0.00,250.23,0.00,'2022-11-11 01:59:01','',''),(139,'1','288','1',1,'Sale Id shift 25',0.00,0.00,0.00,57.33,0.00,'2022-11-11 01:59:01','',''),(140,'1','288',NULL,1,'Sale Id shift 25',205243.20,0.00,0.00,0.00,0.00,'2022-11-11 01:59:01','',''),(141,'1','288','1',1,'Sale Id shift 26',0.00,0.00,0.00,263.97,0.00,'2022-11-11 10:35:50','',''),(142,'1','288','1',1,'Sale Id shift 26',0.00,0.00,0.00,444.74,0.00,'2022-11-11 10:35:50','',''),(143,'1','288','1',1,'Sale Id shift 26',0.00,0.00,0.00,178.80,0.00,'2022-11-11 10:35:50','',''),(144,'1','288','1',1,'Sale Id shift 26',0.00,0.00,0.00,274.27,0.00,'2022-11-11 10:35:50','',''),(145,'1','288','2',2,'Sale Id shift 26',0.00,0.00,0.00,25.47,0.00,'2022-11-11 10:35:50','',''),(146,'1','288',NULL,2,'Sale Id shift 26',19611.90,0.00,0.00,0.00,0.00,'2022-11-11 10:35:50','',''),(147,'1','288',NULL,1,'Sale Id shift 26',209120.40,0.00,0.00,0.00,0.00,'2022-11-11 10:35:50','',''),(148,'1','288','1',1,'Sale Id shift 27',0.00,0.00,0.00,407.00,0.00,'2022-11-11 15:04:20','',''),(149,'1','288','1',1,'Sale Id shift 27',0.00,0.00,0.00,237.76,0.00,'2022-11-11 15:04:20','',''),(150,'1','288','1',1,'Sale Id shift 27',0.00,0.00,0.00,359.14,0.00,'2022-11-11 15:04:20','',''),(151,'1','288','1',1,'Sale Id shift 27',0.00,0.00,0.00,111.18,0.00,'2022-11-11 15:04:20','',''),(152,'1','288',NULL,1,'Sale Id shift 27',200714.40,0.00,0.00,0.00,0.00,'2022-11-11 15:04:20','',''),(153,'1','288','1',1,'Sale Id shift 28',0.00,0.00,0.00,588.24,0.00,'2022-11-12 09:17:07','',''),(154,'1','288','1',1,'Sale Id shift 28',0.00,0.00,0.00,387.97,0.00,'2022-11-12 09:17:07','',''),(155,'1','288','1',1,'Sale Id shift 28',0.00,0.00,0.00,345.87,0.00,'2022-11-12 09:17:07','',''),(156,'1','288','1',1,'Sale Id shift 28',0.00,0.00,0.00,235.63,0.00,'2022-11-12 09:17:07','',''),(157,'1','288',NULL,1,'Sale Id shift 28',280387.80,0.00,0.00,0.00,0.00,'2022-11-12 09:17:07','',''),(158,'1','288','1',1,'Sale Id shift 29',0.00,0.00,0.00,360.17,0.00,'2022-11-12 09:32:48','',''),(159,'1','288','1',1,'Sale Id shift 29',0.00,0.00,0.00,394.29,0.00,'2022-11-12 09:32:48','',''),(160,'1','288','1',1,'Sale Id shift 29',0.00,0.00,0.00,160.63,0.00,'2022-11-12 09:32:48','',''),(161,'1','288','1',1,'Sale Id shift 29',0.00,0.00,0.00,291.14,0.00,'2022-11-12 09:32:48','',''),(162,'1','288',NULL,1,'Sale Id shift 29',217121.40,0.00,0.00,0.00,0.00,'2022-11-12 09:32:48','',''),(163,'1','288','1',1,'Sale Id shift 30',0.00,0.00,0.00,160.56,0.00,'2022-11-12 09:44:53','',''),(164,'1','288','1',1,'Sale Id shift 30',0.00,0.00,0.00,256.57,0.00,'2022-11-12 09:44:53','',''),(165,'1','288','1',1,'Sale Id shift 30',0.00,0.00,0.00,158.88,0.00,'2022-11-12 09:44:53','',''),(166,'1','288','1',1,'Sale Id shift 30',0.00,0.00,0.00,339.68,0.00,'2022-11-12 09:44:53','',''),(167,'1','288',NULL,1,'Sale Id shift 30',164824.20,0.00,0.00,0.00,0.00,'2022-11-12 09:44:53','',''),(168,'1','288','1',1,'Sale Id shift 31',0.00,0.00,0.00,263.37,0.00,'2022-11-12 10:13:24','',''),(169,'1','288','1',1,'Sale Id shift 31',0.00,0.00,0.00,347.22,0.00,'2022-11-12 10:13:24','',''),(170,'1','288','1',1,'Sale Id shift 31',0.00,0.00,0.00,322.74,0.00,'2022-11-12 10:13:24','',''),(171,'1','288','1',1,'Sale Id shift 31',0.00,0.00,0.00,191.53,0.00,'2022-11-12 10:13:24','',''),(172,'1','288',NULL,1,'Sale Id shift 31',202474.80,0.00,0.00,0.00,0.00,'2022-11-12 10:13:24','',''),(173,'1','288','1',1,'Sale Id shift 32',0.00,0.00,0.00,291.41,0.00,'2022-11-12 10:33:35','',''),(174,'1','288','1',1,'Sale Id shift 32',0.00,0.00,0.00,158.19,0.00,'2022-11-12 10:33:35','',''),(175,'1','288','1',1,'Sale Id shift 32',0.00,0.00,0.00,221.79,0.00,'2022-11-12 10:33:35','',''),(176,'1','288','1',1,'Sale Id shift 32',0.00,0.00,0.00,520.23,0.00,'2022-11-12 10:33:35','',''),(177,'1','288',NULL,1,'Sale Id shift 32',214491.60,0.00,0.00,0.00,0.00,'2022-11-12 10:33:35','',''),(178,'1','288','1',1,'Sale Id shift 33',0.00,0.00,0.00,197.44,0.00,'2022-11-12 10:52:41','',''),(179,'1','288','1',1,'Sale Id shift 33',0.00,0.00,0.00,325.96,0.00,'2022-11-12 10:52:41','',''),(180,'1','288','1',1,'Sale Id shift 33',0.00,0.00,0.00,456.12,0.00,'2022-11-12 10:52:41','',''),(181,'1','288','1',1,'Sale Id shift 33',0.00,0.00,0.00,281.87,0.00,'2022-11-12 10:52:41','',''),(182,'1','288','2',2,'Sale Id shift 33',0.00,0.00,0.00,50.00,0.00,'2022-11-12 10:52:41','',''),(183,'1','288',NULL,2,'Sale Id shift 33',38500.00,0.00,0.00,0.00,0.00,'2022-11-12 10:52:41','',''),(184,'1','288',NULL,1,'Sale Id shift 33',227050.20,0.00,0.00,0.00,0.00,'2022-11-12 10:52:41','',''),(185,'1','288','1',1,'Sale Id shift 34',0.00,0.00,0.00,439.12,0.00,'2022-11-12 11:01:47','',''),(186,'1','288','1',1,'Sale Id shift 34',0.00,0.00,0.00,371.91,0.00,'2022-11-12 11:01:47','',''),(187,'1','288','1',1,'Sale Id shift 34',0.00,0.00,0.00,469.23,0.00,'2022-11-12 11:01:47','',''),(188,'1','288','1',1,'Sale Id shift 34',0.00,0.00,0.00,384.14,0.00,'2022-11-12 11:01:47','',''),(189,'1','288','2',2,'Sale Id shift 34',0.00,0.00,0.00,100.00,0.00,'2022-11-12 11:01:47','',''),(190,'1','288',NULL,2,'Sale Id shift 34',77000.00,0.00,0.00,0.00,0.00,'2022-11-12 11:01:47','',''),(191,'1','288',NULL,1,'Sale Id shift 34',299592.00,0.00,0.00,0.00,0.00,'2022-11-12 11:01:47','',''),(192,'1','288','1',1,'Sale Id shift 35',0.00,0.00,0.00,513.26,0.00,'2022-11-12 11:11:06','',''),(193,'1','288','1',1,'Sale Id shift 35',0.00,0.00,0.00,162.71,0.00,'2022-11-12 11:11:06','',''),(194,'1','288','1',1,'Sale Id shift 35',0.00,0.00,0.00,279.17,0.00,'2022-11-12 11:11:06','',''),(195,'1','288','1',1,'Sale Id shift 35',0.00,0.00,0.00,489.43,0.00,'2022-11-12 11:11:06','',''),(196,'1','288',NULL,1,'Sale Id shift 35',260022.60,0.00,0.00,0.00,0.00,'2022-11-12 11:11:06','',''),(197,'1','288','1',1,'Sale Id shift 36',0.00,0.00,0.00,266.47,0.00,'2022-11-12 11:55:41','',''),(198,'1','288','1',1,'Sale Id shift 36',0.00,0.00,0.00,316.43,0.00,'2022-11-12 11:55:41','',''),(199,'1','288','1',1,'Sale Id shift 36',0.00,0.00,0.00,230.40,0.00,'2022-11-12 11:55:41','',''),(200,'1','288','1',1,'Sale Id shift 36',0.00,0.00,0.00,368.73,0.00,'2022-11-12 11:55:41','',''),(201,'1','288','2',2,'Sale Id shift 36',0.00,0.00,0.00,50.01,0.00,'2022-11-12 11:55:41','',''),(202,'1','288',NULL,2,'Sale Id shift 36',38507.70,0.00,0.00,0.00,0.00,'2022-11-12 11:55:41','',''),(203,'1','288',NULL,1,'Sale Id shift 36',212765.40,0.00,0.00,0.00,0.00,'2022-11-12 11:55:41','',''),(204,'1','288','1',1,'Sale Id shift 37',0.00,0.00,0.00,194.62,0.00,'2022-11-12 12:01:38','',''),(205,'1','288','1',1,'Sale Id shift 37',0.00,0.00,0.00,263.54,0.00,'2022-11-12 12:01:38','',''),(206,'1','288','1',1,'Sale Id shift 37',0.00,0.00,0.00,224.74,0.00,'2022-11-12 12:01:38','',''),(207,'1','288','1',1,'Sale Id shift 37',0.00,0.00,0.00,462.76,0.00,'2022-11-12 12:01:38','',''),(208,'1','288',NULL,1,'Sale Id shift 37',206218.80,0.00,0.00,0.00,0.00,'2022-11-12 12:01:38','',''),(209,'1','288','1',1,'Sale Id shift 38',0.00,0.00,0.00,501.49,0.00,'2022-11-12 12:22:08','',''),(210,'1','288','1',1,'Sale Id shift 38',0.00,0.00,0.00,2049.43,0.00,'2022-11-12 12:22:08','',''),(211,'1','288','1',1,'Sale Id shift 38',0.00,0.00,0.00,2401.61,0.00,'2022-11-12 12:22:08','',''),(212,'1','288','1',1,'Sale Id shift 38',0.00,0.00,0.00,668.82,0.00,'2022-11-12 12:22:08','',''),(213,'1','288','2',2,'Sale Id shift 38',0.00,0.00,0.00,50.00,0.00,'2022-11-12 12:22:08','',''),(214,'1','288',NULL,2,'Sale Id shift 38',40000.00,0.00,0.00,0.00,0.00,'2022-11-12 12:22:08','',''),(215,'1','288',NULL,1,'Sale Id shift 38',1011843.00,0.00,0.00,0.00,0.00,'2022-11-12 12:22:08','',''),(216,'1','288','1',1,'Sale Id shift 39',0.00,0.00,0.00,485.56,0.00,'2022-11-12 12:26:17','',''),(217,'1','288','1',1,'Sale Id shift 39',0.00,0.00,0.00,218.75,0.00,'2022-11-12 12:26:17','',''),(218,'1','288','1',1,'Sale Id shift 39',0.00,0.00,0.00,439.03,0.00,'2022-11-12 12:26:17','',''),(219,'1','288','1',1,'Sale Id shift 39',0.00,0.00,0.00,505.93,0.00,'2022-11-12 12:26:18','',''),(220,'1','288',NULL,1,'Sale Id shift 39',296868.60,0.00,0.00,0.00,0.00,'2022-11-12 12:26:18','',''),(221,'1','288','1',1,'Sale Id shift 40',0.00,0.00,0.00,-20.51,0.00,'2022-11-13 06:32:16','',''),(222,'1','288','1',1,'Sale Id shift 40',0.00,0.00,0.00,260.98,0.00,'2022-11-13 06:32:16','',''),(223,'1','288','1',1,'Sale Id shift 40',0.00,0.00,0.00,272.08,0.00,'2022-11-13 06:32:16','',''),(224,'1','288','1',1,'Sale Id shift 40',0.00,0.00,0.00,389.30,0.00,'2022-11-13 06:32:16','',''),(225,'1','288','1',1,'Sale Id shift 40',0.00,0.00,0.00,612.16,0.00,'2022-11-13 06:32:16','',''),(226,'1','288','2',2,'Sale Id shift 40',0.00,0.00,0.00,50.00,0.00,'2022-11-13 06:32:16','',''),(227,'1','288',NULL,2,'Sale Id shift 40',40000.00,0.00,0.00,0.00,0.00,'2022-11-13 06:32:16','',''),(228,'1','288',NULL,1,'Sale Id shift 40',272521.80,0.00,0.00,0.00,0.00,'2022-11-13 06:32:16','',''),(229,'1','288','1',1,'Sale Id shift 41',0.00,0.00,0.00,318.75,0.00,'2022-11-13 08:43:11','',''),(230,'1','288','1',1,'Sale Id shift 41',0.00,0.00,0.00,327.80,0.00,'2022-11-13 08:43:11','',''),(231,'1','288','1',1,'Sale Id shift 41',0.00,0.00,0.00,-20.00,0.00,'2022-11-13 08:43:11','',''),(232,'1','288','1',1,'Sale Id shift 41',0.00,0.00,0.00,473.31,0.00,'2022-11-13 08:43:11','',''),(233,'1','288','1',1,'Sale Id shift 41',0.00,0.00,0.00,377.12,0.00,'2022-11-13 08:43:11','',''),(234,'1','288',NULL,1,'Sale Id shift 41',265856.40,0.00,0.00,0.00,0.00,'2022-11-13 08:43:11','',''),(235,'1','288','1',1,'Sale Id shift 42',0.00,0.00,0.00,327.62,0.00,'2022-11-13 08:57:46','',''),(236,'1','288','1',1,'Sale Id shift 42',0.00,0.00,0.00,528.59,0.00,'2022-11-13 08:57:46','',''),(237,'1','288','1',1,'Sale Id shift 42',0.00,0.00,0.00,206.98,0.00,'2022-11-13 08:57:46','',''),(238,'1','288','1',1,'Sale Id shift 42',0.00,0.00,0.00,275.73,0.00,'2022-11-13 08:57:46','',''),(239,'1','288',NULL,1,'Sale Id shift 42',241005.60,0.00,0.00,0.00,0.00,'2022-11-13 08:57:46','',''),(240,'1','288','1',1,'Sale Id shift 43',0.00,0.00,0.00,412.29,0.00,'2022-11-13 09:06:51','',''),(241,'1','288','1',1,'Sale Id shift 43',0.00,0.00,0.00,280.04,0.00,'2022-11-13 09:06:51','',''),(242,'1','288','1',1,'Sale Id shift 43',0.00,0.00,0.00,469.74,0.00,'2022-11-13 09:06:51','',''),(243,'1','288','1',1,'Sale Id shift 43',0.00,0.00,0.00,418.41,0.00,'2022-11-13 09:06:51','',''),(244,'1','288',NULL,1,'Sale Id shift 43',284486.40,0.00,0.00,0.00,0.00,'2022-11-13 09:06:51','',''),(245,'1','288','1',1,'Sale Id shift 44',0.00,0.00,0.00,398.79,0.00,'2022-11-13 09:25:13','',''),(246,'1','288','1',1,'Sale Id shift 44',0.00,0.00,0.00,360.67,0.00,'2022-11-13 09:25:13','',''),(247,'1','288','1',1,'Sale Id shift 44',0.00,0.00,0.00,254.00,0.00,'2022-11-13 09:25:13','',''),(248,'1','288','1',1,'Sale Id shift 44',0.00,0.00,0.00,165.44,0.00,'2022-11-13 09:25:13','',''),(249,'1','288','2',2,'Sale Id shift 44',0.00,0.00,0.00,50.00,0.00,'2022-11-13 09:25:13','',''),(250,'1','288',NULL,2,'Sale Id shift 44',40000.00,0.00,0.00,0.00,0.00,'2022-11-13 09:25:13','',''),(251,'1','288',NULL,1,'Sale Id shift 44',212202.00,0.00,0.00,0.00,0.00,'2022-11-13 09:25:13','',''),(252,'1','288','1',1,'Sale Id shift 45',0.00,0.00,0.00,540.25,0.00,'2022-11-13 09:34:49','',''),(253,'1','288','1',1,'Sale Id shift 45',0.00,0.00,0.00,463.71,0.00,'2022-11-13 09:34:49','',''),(254,'1','288','1',1,'Sale Id shift 45',0.00,0.00,0.00,401.32,0.00,'2022-11-13 09:34:49','',''),(255,'1','288','1',1,'Sale Id shift 45',0.00,0.00,0.00,407.94,0.00,'2022-11-13 09:34:49','',''),(256,'1','288',NULL,1,'Sale Id shift 45',326379.60,0.00,0.00,0.00,0.00,'2022-11-13 09:34:49','',''),(257,'1','288','1',1,'Sale Id shift 46',0.00,0.00,0.00,220.74,0.00,'2022-11-13 09:48:22','',''),(258,'1','288','1',1,'Sale Id shift 46',0.00,0.00,0.00,195.80,0.00,'2022-11-13 09:48:22','',''),(259,'1','288','1',1,'Sale Id shift 46',0.00,0.00,0.00,344.85,0.00,'2022-11-13 09:48:22','',''),(260,'1','288','1',1,'Sale Id shift 46',0.00,0.00,0.00,597.21,0.00,'2022-11-13 09:48:22','',''),(261,'1','288',NULL,1,'Sale Id shift 46',244548.00,0.00,0.00,0.00,0.00,'2022-11-13 09:48:22','',''),(262,'1','288','1',1,'Sale Id shift 47',0.00,0.00,0.00,653.10,0.00,'2022-11-13 10:08:44','',''),(263,'1','288','1',1,'Sale Id shift 47',0.00,0.00,0.00,395.10,0.00,'2022-11-13 10:08:44','',''),(264,'1','288','1',1,'Sale Id shift 47',0.00,0.00,0.00,813.54,0.00,'2022-11-13 10:08:44','',''),(265,'1','288','1',1,'Sale Id shift 47',0.00,0.00,0.00,688.23,0.00,'2022-11-13 10:08:44','',''),(266,'1','288',NULL,1,'Sale Id shift 47',458994.60,0.00,0.00,0.00,0.00,'2022-11-13 10:08:44','',''),(267,'1','288','1',1,'Sale Id shift 48',0.00,0.00,0.00,784.16,0.00,'2022-11-13 11:11:09','',''),(268,'1','288','1',1,'Sale Id shift 48',0.00,0.00,0.00,1049.95,0.00,'2022-11-13 11:11:09','',''),(269,'1','288','1',1,'Sale Id shift 48',0.00,0.00,0.00,215.51,0.00,'2022-11-13 11:11:09','',''),(270,'1','288','1',1,'Sale Id shift 48',0.00,0.00,0.00,1349.32,0.00,'2022-11-13 11:11:09','',''),(271,'1','288','2',2,'Sale Id shift 48',0.00,0.00,0.00,50.00,0.00,'2022-11-13 11:11:09','',''),(272,'1','288',NULL,2,'Sale Id shift 48',40000.00,0.00,0.00,0.00,0.00,'2022-11-13 11:11:09','',''),(273,'1','288',NULL,1,'Sale Id shift 48',611809.20,0.00,0.00,0.00,0.00,'2022-11-13 11:11:09','',''),(274,'1','288','1',1,'Sale Id shift 49',0.00,0.00,0.00,2872.55,0.00,'2022-11-13 23:11:34','',''),(275,'1','288','1',1,'Sale Id shift 49',0.00,0.00,0.00,-10.00,0.00,'2022-11-13 23:11:34','',''),(276,'1','288','1',1,'Sale Id shift 49',0.00,0.00,0.00,-10.00,0.00,'2022-11-13 23:11:34','',''),(277,'1','288','1',1,'Sale Id shift 49',0.00,0.00,0.00,2876.94,0.00,'2022-11-13 23:11:34','',''),(278,'1','288','1',1,'Sale Id shift 49',0.00,0.00,0.00,2144.98,0.00,'2022-11-13 23:11:34','',''),(279,'1','288','1',1,'Sale Id shift 49',0.00,0.00,0.00,2231.37,0.00,'2022-11-13 23:11:34','',''),(280,'1','288',NULL,1,'Sale Id shift 49',1819051.20,0.00,0.00,0.00,0.00,'2022-11-13 23:11:34','',''),(281,'1','288','1',1,'Sale Id shift 50',0.00,0.00,0.00,1639.64,0.00,'2022-11-14 11:50:51','',''),(282,'1','288','1',1,'Sale Id shift 50',0.00,0.00,0.00,693.76,0.00,'2022-11-14 11:50:51','',''),(283,'1','288','1',1,'Sale Id shift 50',0.00,0.00,0.00,878.32,0.00,'2022-11-14 11:50:51','',''),(284,'1','288','1',1,'Sale Id shift 50',0.00,0.00,0.00,1995.04,0.00,'2022-11-14 11:50:51','',''),(285,'1','288','2',2,'Sale Id shift 50',0.00,0.00,0.00,30.00,0.00,'2022-11-14 11:50:51','',''),(286,'1','288',NULL,2,'Sale Id shift 50',24000.00,0.00,0.00,0.00,0.00,'2022-11-14 11:50:51','',''),(287,'1','288',NULL,1,'Sale Id shift 50',937216.80,0.00,0.00,0.00,0.00,'2022-11-14 11:50:51','',''),(288,'1','288','1',1,'Sale Id shift 51',0.00,0.00,0.00,590.58,0.00,'2022-11-14 14:15:00','',''),(289,'1','288','1',1,'Sale Id shift 51',0.00,0.00,0.00,182.14,0.00,'2022-11-14 14:15:00','',''),(290,'1','288','1',1,'Sale Id shift 51',0.00,0.00,0.00,306.26,0.00,'2022-11-14 14:15:00','',''),(291,'1','288','1',1,'Sale Id shift 51',0.00,0.00,0.00,310.78,0.00,'2022-11-14 14:15:00','',''),(292,'1','288',NULL,1,'Sale Id shift 51',250156.80,0.00,0.00,0.00,0.00,'2022-11-14 14:15:00','',''),(293,'1','288','1',1,'Sale Id shift 52',0.00,0.00,0.00,212.67,0.00,'2022-11-15 09:41:24','',''),(294,'1','288','1',1,'Sale Id shift 52',0.00,0.00,0.00,340.45,0.00,'2022-11-15 09:41:24','',''),(295,'1','288','1',1,'Sale Id shift 52',0.00,0.00,0.00,309.18,0.00,'2022-11-15 09:41:24','',''),(296,'1','288','1',1,'Sale Id shift 52',0.00,0.00,0.00,570.37,0.00,'2022-11-15 09:41:24','',''),(297,'1','288','2',2,'Sale Id shift 52',0.00,0.00,0.00,30.00,0.00,'2022-11-15 09:41:24','',''),(298,'1','288',NULL,2,'Sale Id shift 52',24000.00,0.00,0.00,0.00,0.00,'2022-11-15 09:41:24','',''),(299,'1','288',NULL,1,'Sale Id shift 52',257880.60,0.00,0.00,0.00,0.00,'2022-11-15 09:41:24','',''),(300,'1','288',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9000000.00,50000.00,0.00,0.00,'2022-11-15 10:26:30','',''),(301,'1','288',NULL,1,'Reception corrector for bridging 7',0.00,0.00,0.00,50000.00,0.00,'2022-11-15 10:49:28','',''),(302,'1','288','1',1,'Received from bridging 7',0.00,0.00,50000.00,0.00,0.00,'2022-11-15 10:49:28','',''),(303,'1','288','1',1,'Sale Id shift 53',0.00,0.00,0.00,768.93,0.00,'2022-11-15 11:53:35','',''),(304,'1','288','1',1,'Sale Id shift 53',0.00,0.00,0.00,564.98,0.00,'2022-11-15 11:53:35','',''),(305,'1','288','1',1,'Sale Id shift 53',0.00,0.00,0.00,293.42,0.00,'2022-11-15 11:53:35','',''),(306,'1','288','1',1,'Sale Id shift 53',0.00,0.00,0.00,225.72,0.00,'2022-11-15 11:53:35','',''),(307,'1','288',NULL,1,'Sale Id shift 53',333549.00,0.00,0.00,0.00,0.00,'2022-11-15 11:53:35','',''),(308,'1','288','1',1,'Sale Id shift 54',0.00,0.00,0.00,1186.88,0.00,'2022-11-15 12:40:05','',''),(309,'1','288','1',1,'Sale Id shift 54',0.00,0.00,0.00,482.11,0.00,'2022-11-15 12:40:05','',''),(310,'1','288','1',1,'Sale Id shift 54',0.00,0.00,0.00,706.22,0.00,'2022-11-15 12:40:05','',''),(311,'1','288','1',1,'Sale Id shift 54',0.00,0.00,0.00,200.49,0.00,'2022-11-15 12:40:05','',''),(312,'1','288','2',2,'Sale Id shift 54',0.00,0.00,0.00,30.00,0.00,'2022-11-15 12:40:05','',''),(313,'1','288',NULL,2,'Sale Id shift 54',24000.00,0.00,0.00,0.00,0.00,'2022-11-15 12:40:05','',''),(314,'1','288',NULL,1,'Sale Id shift 54',463626.00,0.00,0.00,0.00,0.00,'2022-11-15 12:40:05','',''),(315,'1','288','1',1,'Sale Id shift 55',0.00,0.00,0.00,692.82,0.00,'2022-11-15 21:36:23','',''),(316,'1','288','1',1,'Sale Id shift 55',0.00,0.00,0.00,12.77,0.00,'2022-11-15 21:36:23','',''),(317,'1','288','1',1,'Sale Id shift 55',0.00,0.00,0.00,352.09,0.00,'2022-11-15 21:36:23','',''),(318,'1','288','1',1,'Sale Id shift 55',0.00,0.00,0.00,533.01,0.00,'2022-11-15 21:36:23','',''),(319,'1','288',NULL,1,'Sale Id shift 55',286324.20,0.00,0.00,0.00,0.00,'2022-11-15 21:36:23','',''),(320,'1','288','1',1,'Sale Id shift 56',0.00,0.00,0.00,591.55,0.00,'2022-11-18 06:29:01','',''),(321,'1','288','1',1,'Sale Id shift 56',0.00,0.00,0.00,1005.71,0.00,'2022-11-18 06:29:01','',''),(322,'1','288','1',1,'Sale Id shift 56',0.00,0.00,0.00,335.56,0.00,'2022-11-18 06:29:01','',''),(323,'1','288','1',1,'Sale Id shift 56',0.00,0.00,0.00,777.52,0.00,'2022-11-18 06:29:01','',''),(324,'1','288','2',2,'Sale Id shift 56',0.00,0.00,0.00,30.00,0.00,'2022-11-18 06:29:01','',''),(325,'1','288',NULL,2,'Sale Id shift 56',24000.00,0.00,0.00,0.00,0.00,'2022-11-18 06:29:01','',''),(326,'1','288',NULL,1,'Sale Id shift 56',487861.20,0.00,0.00,0.00,0.00,'2022-11-18 06:29:01','',''),(327,'1','288','1',1,'Sale Id shift 57',0.00,0.00,0.00,788.26,0.00,'2022-11-18 09:27:16','',''),(328,'1','288','1',1,'Sale Id shift 57',0.00,0.00,0.00,896.85,0.00,'2022-11-18 09:27:16','',''),(329,'1','288','1',1,'Sale Id shift 57',0.00,0.00,0.00,916.29,0.00,'2022-11-18 09:27:16','',''),(330,'1','288',NULL,1,'Sale Id shift 57',468252.00,0.00,0.00,0.00,0.00,'2022-11-18 09:27:16','',''),(331,'1','288','1',1,'Sale Id shift 58',0.00,0.00,0.00,915.11,0.00,'2022-11-18 09:34:34','',''),(332,'1','288','1',1,'Sale Id shift 58',0.00,0.00,0.00,650.45,0.00,'2022-11-18 09:34:34','',''),(333,'1','288','1',1,'Sale Id shift 58',0.00,0.00,0.00,551.44,0.00,'2022-11-18 09:34:34','',''),(334,'1','288','2',2,'Sale Id shift 58',0.00,0.00,0.00,30.00,0.00,'2022-11-18 09:34:34','',''),(335,'1','288',NULL,2,'Sale Id shift 58',24000.00,0.00,0.00,0.00,0.00,'2022-11-18 09:34:34','',''),(336,'1','288',NULL,1,'Sale Id shift 58',381060.00,0.00,0.00,0.00,0.00,'2022-11-18 09:34:34','',''),(337,'1','288','1',1,'Sale Id shift 59',0.00,0.00,0.00,895.25,0.00,'2022-11-18 09:49:03','',''),(338,'1','288','1',1,'Sale Id shift 59',0.00,0.00,0.00,716.17,0.00,'2022-11-18 09:49:03','',''),(339,'1','288','1',1,'Sale Id shift 59',0.00,0.00,0.00,781.67,0.00,'2022-11-18 09:49:03','',''),(340,'1','288',NULL,1,'Sale Id shift 59',430756.20,0.00,0.00,0.00,0.00,'2022-11-18 09:49:03','',''),(341,'1','288','1',1,'Sale Id shift 60',0.00,0.00,0.00,891.29,0.00,'2022-11-18 09:59:21','',''),(342,'1','288','1',1,'Sale Id shift 60',0.00,0.00,0.00,1063.78,0.00,'2022-11-18 09:59:21','',''),(343,'1','288','1',1,'Sale Id shift 60',0.00,0.00,0.00,805.47,0.00,'2022-11-18 09:59:21','',''),(344,'1','288','2',2,'Sale Id shift 60',0.00,0.00,0.00,30.00,0.00,'2022-11-18 09:59:21','',''),(345,'1','288',NULL,2,'Sale Id shift 60',24000.00,0.00,0.00,0.00,0.00,'2022-11-18 09:59:21','',''),(346,'1','288',NULL,1,'Sale Id shift 60',496897.20,0.00,0.00,0.00,0.00,'2022-11-18 09:59:21','',''),(347,'1','288','1',1,'Sale Id shift 61',0.00,0.00,0.00,796.19,0.00,'2022-11-18 10:11:32','',''),(348,'1','288','1',1,'Sale Id shift 61',0.00,0.00,0.00,814.43,0.00,'2022-11-18 10:11:32','',''),(349,'1','288','1',1,'Sale Id shift 61',0.00,0.00,0.00,669.37,0.00,'2022-11-18 10:11:32','',''),(350,'1','288','2',2,'Sale Id shift 61',0.00,0.00,0.00,79.07,0.00,'2022-11-18 10:11:32','',''),(351,'1','288',NULL,2,'Sale Id shift 61',63256.00,0.00,0.00,0.00,0.00,'2022-11-18 10:11:32','',''),(352,'1','288',NULL,1,'Sale Id shift 61',410398.20,0.00,0.00,0.00,0.00,'2022-11-18 10:11:32','',''),(353,'1','288','1',1,'Sale Id shift 62',0.00,0.00,0.00,918.08,0.00,'2022-11-18 10:41:15','',''),(354,'1','288','1',1,'Sale Id shift 62',0.00,0.00,0.00,366.13,0.00,'2022-11-18 10:41:15','',''),(355,'1','288','1',1,'Sale Id shift 62',0.00,0.00,0.00,861.30,0.00,'2022-11-18 10:41:15','',''),(356,'1','288','2',2,'Sale Id shift 62',0.00,0.00,0.00,29.99,0.00,'2022-11-18 10:41:15','',''),(357,'1','288',NULL,2,'Sale Id shift 62',23992.00,0.00,0.00,0.00,0.00,'2022-11-18 10:41:15','',''),(358,'1','288',NULL,1,'Sale Id shift 62',386191.80,0.00,0.00,0.00,0.00,'2022-11-18 10:41:15','',''),(359,'1','288','1',1,'Sale Id shift 63',0.00,0.00,0.00,829.25,0.00,'2022-11-18 10:52:54','',''),(360,'1','288','1',1,'Sale Id shift 63',0.00,0.00,0.00,802.14,0.00,'2022-11-18 10:52:54','',''),(361,'1','288','1',1,'Sale Id shift 63',0.00,0.00,0.00,624.57,0.00,'2022-11-18 10:52:54','',''),(362,'1','288','2',2,'Sale Id shift 63',0.00,0.00,0.00,1.25,0.00,'2022-11-18 10:52:54','',''),(363,'1','288',NULL,2,'Sale Id shift 63',1000.00,0.00,0.00,0.00,0.00,'2022-11-18 10:52:54','',''),(364,'1','288',NULL,1,'Sale Id shift 63',406072.80,0.00,0.00,0.00,0.00,'2022-11-18 10:52:54','',''),(365,'1','288','1',1,'Sale Id shift 64',0.00,0.00,0.00,904.92,0.00,'2022-11-18 13:17:41','',''),(366,'1','288','1',1,'Sale Id shift 64',0.00,0.00,0.00,900.02,0.00,'2022-11-18 13:17:41','',''),(367,'1','288','1',1,'Sale Id shift 64',0.00,0.00,0.00,1033.92,0.00,'2022-11-18 13:17:41','',''),(368,'1','288','2',2,'Sale Id shift 64',0.00,0.00,0.00,30.00,0.00,'2022-11-18 13:17:41','',''),(369,'1','288',NULL,2,'Sale Id shift 64',24000.00,0.00,0.00,0.00,0.00,'2022-11-18 13:17:41','',''),(370,'1','288',NULL,1,'Sale Id shift 64',510994.80,0.00,0.00,0.00,0.00,'2022-11-18 13:17:41','',''),(371,'1','288','1',1,'Sale Id shift 65',0.00,0.00,0.00,681.90,0.00,'2022-11-18 15:42:48','',''),(372,'1','288','1',1,'Sale Id shift 65',0.00,0.00,0.00,533.72,0.00,'2022-11-18 15:42:48','',''),(373,'1','288','1',1,'Sale Id shift 65',0.00,0.00,0.00,613.84,0.00,'2022-11-18 15:42:48','',''),(374,'1','288','2',2,'Sale Id shift 65',0.00,0.00,0.00,52.00,0.00,'2022-11-18 15:42:48','',''),(375,'1','288',NULL,2,'Sale Id shift 65',41600.00,0.00,0.00,0.00,0.00,'2022-11-18 15:42:48','',''),(376,'1','288',NULL,1,'Sale Id shift 65',329302.80,0.00,0.00,0.00,0.00,'2022-11-18 15:42:48','',''),(377,'1','288','1',1,'Sale Id shift 66',0.00,0.00,0.00,1033.82,0.00,'2022-11-18 16:12:12','',''),(378,'1','288','1',1,'Sale Id shift 66',0.00,0.00,0.00,954.88,0.00,'2022-11-18 16:12:12','',''),(379,'1','288','1',1,'Sale Id shift 66',0.00,0.00,0.00,836.25,0.00,'2022-11-18 16:12:12','',''),(380,'1','288','2',2,'Sale Id shift 66',0.00,0.00,0.00,30.00,0.00,'2022-11-18 16:12:12','',''),(381,'1','288',NULL,2,'Sale Id shift 66',24000.00,0.00,0.00,0.00,0.00,'2022-11-18 16:12:12','',''),(382,'1','288',NULL,1,'Sale Id shift 66',508491.00,0.00,0.00,0.00,0.00,'2022-11-18 16:12:12','',''),(383,'1','288','1',1,'Sale Id shift 67',0.00,0.00,0.00,884.94,0.00,'2022-11-18 16:19:15','',''),(384,'1','288','1',1,'Sale Id shift 67',0.00,0.00,0.00,856.51,0.00,'2022-11-18 16:19:15','',''),(385,'1','288','1',1,'Sale Id shift 67',0.00,0.00,0.00,631.85,0.00,'2022-11-18 16:19:15','',''),(386,'1','288',NULL,1,'Sale Id shift 67',427194.00,0.00,0.00,0.00,0.00,'2022-11-18 16:19:15','',''),(387,'1','288','1',1,'Sale Id shift 68',0.00,0.00,0.00,955.73,0.00,'2022-11-18 16:30:11','',''),(388,'1','288','1',1,'Sale Id shift 68',0.00,0.00,0.00,799.95,0.00,'2022-11-18 16:30:11','',''),(389,'1','288','1',1,'Sale Id shift 68',0.00,0.00,0.00,572.76,0.00,'2022-11-18 16:30:11','',''),(390,'1','288','2',2,'Sale Id shift 68',0.00,0.00,0.00,30.00,0.00,'2022-11-18 16:30:11','',''),(391,'1','288',NULL,2,'Sale Id shift 68',24000.00,0.00,0.00,0.00,0.00,'2022-11-18 16:30:11','',''),(392,'1','288',NULL,1,'Sale Id shift 68',419119.20,0.00,0.00,0.00,0.00,'2022-11-18 16:30:11','',''),(393,'1','288','1',1,'Sale Id shift 69',0.00,0.00,0.00,842.46,0.00,'2022-11-18 16:39:41','',''),(394,'1','288','1',1,'Sale Id shift 69',0.00,0.00,0.00,708.00,0.00,'2022-11-18 16:39:41','',''),(395,'1','288','1',1,'Sale Id shift 69',0.00,0.00,0.00,673.41,0.00,'2022-11-18 16:39:41','',''),(396,'1','288','2',2,'Sale Id shift 69',0.00,0.00,0.00,11.25,0.00,'2022-11-18 16:39:41','',''),(397,'1','288',NULL,2,'Sale Id shift 69',9000.00,0.00,0.00,0.00,0.00,'2022-11-18 16:39:41','',''),(398,'1','288',NULL,1,'Sale Id shift 69',400296.60,0.00,0.00,0.00,0.00,'2022-11-18 16:39:41','',''),(399,'1','288','1',1,'Sale Id shift 70',0.00,0.00,0.00,914.32,0.00,'2022-11-18 16:51:09','',''),(400,'1','288','1',1,'Sale Id shift 70',0.00,0.00,0.00,788.85,0.00,'2022-11-18 16:51:09','',''),(401,'1','288','1',1,'Sale Id shift 70',0.00,0.00,0.00,881.25,0.00,'2022-11-18 16:51:09','',''),(402,'1','288','2',2,'Sale Id shift 70',0.00,0.00,0.00,30.00,0.00,'2022-11-18 16:51:09','',''),(403,'1','288',NULL,2,'Sale Id shift 70',24000.00,0.00,0.00,0.00,0.00,'2022-11-18 16:51:09','',''),(404,'1','288',NULL,1,'Sale Id shift 70',465195.60,0.00,0.00,0.00,0.00,'2022-11-18 16:51:09','',''),(405,'1','288','1',1,'Sale Id shift 71',0.00,0.00,0.00,1031.03,0.00,'2022-11-18 16:59:11','',''),(406,'1','288','1',1,'Sale Id shift 71',0.00,0.00,0.00,599.81,0.00,'2022-11-18 16:59:11','',''),(407,'1','288','1',1,'Sale Id shift 71',0.00,0.00,0.00,324.30,0.00,'2022-11-18 16:59:11','',''),(408,'1','288','1',1,'Sale Id shift 71',0.00,0.00,0.00,405.58,0.00,'2022-11-18 16:59:11','',''),(409,'1','288',NULL,1,'Sale Id shift 71',424929.60,0.00,0.00,0.00,0.00,'2022-11-18 16:59:11','',''),(410,'1','288','1',1,'Sale Id shift 72',0.00,0.00,0.00,883.56,0.00,'2022-11-18 17:10:28','',''),(411,'1','288','1',1,'Sale Id shift 72',0.00,0.00,0.00,1156.56,0.00,'2022-11-18 17:10:28','',''),(412,'1','288','2',2,'Sale Id shift 72',0.00,0.00,0.00,30.00,0.00,'2022-11-18 17:10:28','',''),(413,'1','288',NULL,2,'Sale Id shift 72',24000.00,0.00,0.00,0.00,0.00,'2022-11-18 17:10:28','',''),(414,'1','288',NULL,1,'Sale Id shift 72',367221.60,0.00,0.00,0.00,0.00,'2022-11-18 17:10:28','',''),(415,'1','288','1',1,'Sale Id shift 73',0.00,0.00,0.00,543.41,0.00,'2022-11-18 17:19:09','',''),(416,'1','288','1',1,'Sale Id shift 73',0.00,0.00,0.00,620.38,0.00,'2022-11-18 17:19:09','',''),(417,'1','288','1',1,'Sale Id shift 73',0.00,0.00,0.00,481.79,0.00,'2022-11-18 17:19:09','',''),(418,'1','288',NULL,1,'Sale Id shift 73',296204.40,0.00,0.00,0.00,0.00,'2022-11-18 17:19:09','',''),(419,'1','288','1',1,'Sale Id shift 74',0.00,0.00,0.00,864.79,0.00,'2022-11-18 17:27:24','',''),(420,'1','288','1',1,'Sale Id shift 74',0.00,0.00,0.00,824.90,0.00,'2022-11-18 17:27:24','',''),(421,'1','288','1',1,'Sale Id shift 74',0.00,0.00,0.00,109.67,0.00,'2022-11-18 17:27:24','',''),(422,'1','288','2',2,'Sale Id shift 74',0.00,0.00,0.00,30.00,0.00,'2022-11-18 17:27:24','',''),(423,'1','288',NULL,2,'Sale Id shift 74',24000.00,0.00,0.00,0.00,0.00,'2022-11-18 17:27:24','',''),(424,'1','288',NULL,1,'Sale Id shift 74',323884.80,0.00,0.00,0.00,0.00,'2022-11-18 17:27:24','',''),(425,'1','288',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,12600000.00,60000.00,0.00,0.00,'2022-11-24 04:45:14','',''),(426,'1','288','2',2,'Sale Id shift 75',0.00,0.00,0.00,50.00,0.00,'2022-11-24 23:28:19','',''),(427,'1','288',NULL,2,'Sale Id shift 75',40000.00,0.00,0.00,0.00,0.00,'2022-11-24 23:28:19','',''),(428,'1','288','2',2,'Sale Id shift 76',0.00,0.00,0.00,10000.00,0.00,'2022-11-25 17:36:17','',''),(429,'1','288',NULL,2,'Sale Id shift 76',8250000.00,0.00,0.00,0.00,0.00,'2022-11-25 17:36:17','',''),(430,'1','288','2',2,'Sale Id shift 77',0.00,0.00,0.00,11.00,0.00,'2022-11-26 09:51:54','',''),(431,'1','288',NULL,2,'Sale Id shift 77',9075.00,0.00,0.00,0.00,0.00,'2022-11-26 09:51:54','',''),(432,'1','288',NULL,1,'Reception corrector for bridging 8',0.00,0.00,0.00,60000.00,0.00,'2022-11-27 07:12:25','',''),(433,'1','288','1',1,'Received from bridging 8',0.00,0.00,60000.00,0.00,0.00,'2022-11-27 07:12:25','',''),(434,'1','288','1',1,'Sale Id shift 78',0.00,0.00,0.00,33.74,0.00,'2022-11-27 09:22:53','',''),(435,'1','288','1',1,'Sale Id shift 78',0.00,0.00,0.00,43.28,0.00,'2022-11-27 09:22:53','',''),(436,'1','288','2',2,'Sale Id shift 78',0.00,0.00,0.00,170.00,0.00,'2022-11-27 09:22:53','',''),(437,'1','288',NULL,2,'Sale Id shift 78',142800.00,0.00,0.00,0.00,0.00,'2022-11-27 09:22:53','',''),(438,'1','288',NULL,1,'Sale Id shift 78',16174.20,0.00,0.00,0.00,0.00,'2022-11-27 09:22:53','',''),(439,'1','288','1',1,'Sale Id shift 79',0.00,0.00,0.00,305.10,0.00,'2022-11-27 14:33:49','',''),(440,'1','288','1',1,'Sale Id shift 79',0.00,0.00,0.00,518.97,0.00,'2022-11-27 14:33:49','',''),(441,'1','288','2',2,'Sale Id shift 79',0.00,0.00,0.00,50.00,0.00,'2022-11-27 14:33:49','',''),(442,'1','288',NULL,2,'Sale Id shift 79',42000.00,0.00,0.00,0.00,0.00,'2022-11-27 14:33:49','',''),(443,'1','288',NULL,1,'Sale Id shift 79',173054.70,0.00,0.00,0.00,0.00,'2022-11-27 14:33:49','',''),(444,'1','288','1',1,'Sale Id shift 80',0.00,0.00,0.00,1289.86,0.00,'2022-11-28 12:08:55','',''),(445,'1','288','1',1,'Sale Id shift 80',0.00,0.00,0.00,1524.94,0.00,'2022-11-28 12:08:55','',''),(446,'1','288','2',2,'Sale Id shift 80',0.00,0.00,0.00,30.00,0.00,'2022-11-28 12:08:55','',''),(447,'1','288',NULL,2,'Sale Id shift 80',25200.00,0.00,0.00,0.00,0.00,'2022-11-28 12:08:55','',''),(448,'1','288',NULL,1,'Sale Id shift 80',591108.00,0.00,0.00,0.00,0.00,'2022-11-28 12:08:55','',''),(449,'1','288','1',1,'Sale Id shift 81',0.00,0.00,0.00,504.42,0.00,'2022-11-28 13:58:10','',''),(450,'1','288','1',1,'Sale Id shift 81',0.00,0.00,0.00,553.07,0.00,'2022-11-28 13:58:10','',''),(451,'1','288','1',1,'Sale Id shift 81',0.00,0.00,0.00,275.76,0.00,'2022-11-28 13:58:10','',''),(452,'1','288','1',1,'Sale Id shift 81',0.00,0.00,0.00,289.53,0.00,'2022-11-28 13:58:10','',''),(453,'1','288',NULL,1,'Sale Id shift 81',340783.80,0.00,0.00,0.00,0.00,'2022-11-28 13:58:10','',''),(454,'1','288','1',1,'Sale Id shift 82',0.00,0.00,0.00,438.10,0.00,'2022-11-28 14:10:37','',''),(455,'1','288','1',1,'Sale Id shift 82',0.00,0.00,0.00,542.88,0.00,'2022-11-28 14:10:37','',''),(456,'1','288','1',1,'Sale Id shift 82',0.00,0.00,0.00,501.91,0.00,'2022-11-28 14:10:37','',''),(457,'1','288','1',1,'Sale Id shift 82',0.00,0.00,0.00,130.34,0.00,'2022-11-28 14:10:37','',''),(458,'1','288',NULL,1,'Sale Id shift 82',338778.30,0.00,0.00,0.00,0.00,'2022-11-28 14:10:37','',''),(459,'1','288','1',1,'Sale Id shift 83',0.00,0.00,0.00,615.97,0.00,'2022-11-28 14:42:29','',''),(460,'1','288','1',1,'Sale Id shift 83',0.00,0.00,0.00,467.41,0.00,'2022-11-28 14:42:29','',''),(461,'1','288','1',1,'Sale Id shift 83',0.00,0.00,0.00,722.94,0.00,'2022-11-28 14:42:29','',''),(462,'1','288','2',2,'Sale Id shift 83',0.00,0.00,0.00,565.00,0.00,'2022-11-28 14:42:29','',''),(463,'1','288',NULL,2,'Sale Id shift 83',474600.00,0.00,0.00,0.00,0.00,'2022-11-28 14:42:29','',''),(464,'1','288',NULL,1,'Sale Id shift 83',379327.20,0.00,0.00,0.00,0.00,'2022-11-28 14:42:29','',''),(465,'1','288','1',1,'Sale Id shift 84',0.00,0.00,0.00,1127.29,0.00,'2022-11-29 11:18:29','',''),(466,'1','288','1',1,'Sale Id shift 84',0.00,0.00,0.00,583.68,0.00,'2022-11-29 11:18:29','',''),(467,'1','288','1',1,'Sale Id shift 84',0.00,0.00,0.00,541.96,0.00,'2022-11-29 11:18:29','',''),(468,'1','288','1',1,'Sale Id shift 84',0.00,0.00,0.00,485.05,0.00,'2022-11-29 11:18:29','',''),(469,'1','288',NULL,1,'Sale Id shift 84',574975.80,0.00,0.00,0.00,0.00,'2022-11-29 11:18:29','',''),(470,'1','288','1',1,'Sale Id shift 85',0.00,0.00,0.00,996.09,0.00,'2022-11-29 16:54:56','',''),(471,'1','288','1',1,'Sale Id shift 85',0.00,0.00,0.00,570.16,0.00,'2022-11-29 16:54:56','',''),(472,'1','288','1',1,'Sale Id shift 85',0.00,0.00,0.00,510.10,0.00,'2022-11-29 16:54:56','',''),(473,'1','288',NULL,1,'Sale Id shift 85',436033.50,0.00,0.00,0.00,0.00,'2022-11-29 16:54:56','',''),(474,'1','288','1',1,'Sale Id shift 86',0.00,0.00,0.00,728.73,0.00,'2022-11-30 11:32:32','',''),(475,'1','288','1',1,'Sale Id shift 86',0.00,0.00,0.00,728.47,0.00,'2022-11-30 11:32:32','',''),(476,'1','288','1',1,'Sale Id shift 86',0.00,0.00,0.00,1128.47,0.00,'2022-11-30 11:32:32','',''),(477,'1','288','1',1,'Sale Id shift 86',0.00,0.00,0.00,518.93,0.00,'2022-11-30 11:32:32','',''),(478,'1','288',NULL,1,'Sale Id shift 86',651966.00,0.00,0.00,0.00,0.00,'2022-11-30 11:32:32','',''),(479,'1','288','1',1,'Sale Id shift 87',0.00,0.00,0.00,1713.21,0.00,'2022-12-01 07:48:40','',''),(480,'1','288','1',1,'Sale Id shift 87',0.00,0.00,0.00,1078.42,0.00,'2022-12-01 07:48:40','',''),(481,'1','288','2',2,'Sale Id shift 87',0.00,0.00,0.00,30.00,0.00,'2022-12-01 07:48:40','',''),(482,'1','288',NULL,2,'Sale Id shift 87',25200.00,0.00,0.00,0.00,0.00,'2022-12-01 07:48:40','',''),(483,'1','288',NULL,1,'Sale Id shift 87',586242.30,0.00,0.00,0.00,0.00,'2022-12-01 07:48:40','',''),(484,'1','288','1',1,'Sale Id shift 88',0.00,0.00,0.00,1600.74,0.00,'2022-12-01 14:56:27','',''),(485,'1','288','1',1,'Sale Id shift 88',0.00,0.00,0.00,1019.44,0.00,'2022-12-01 14:56:27','',''),(486,'1','288','1',1,'Sale Id shift 88',0.00,0.00,0.00,624.72,0.00,'2022-12-01 14:56:27','',''),(487,'1','288','1',1,'Sale Id shift 88',0.00,0.00,0.00,794.44,0.00,'2022-12-01 14:56:27','',''),(488,'1','288',NULL,1,'Sale Id shift 88',848261.40,0.00,0.00,0.00,0.00,'2022-12-01 14:56:27','',''),(489,'1','288','1',1,'Sale Id shift 89',0.00,0.00,0.00,1651.28,0.00,'2022-12-01 15:11:40','',''),(490,'1','288','1',1,'Sale Id shift 89',0.00,0.00,0.00,1434.73,0.00,'2022-12-01 15:11:40','',''),(491,'1','288',NULL,1,'Sale Id shift 89',648062.10,0.00,0.00,0.00,0.00,'2022-12-01 15:11:40','',''),(492,'1','288','1',1,'Sale Id shift 90',0.00,0.00,0.00,1008.10,0.00,'2022-12-02 10:25:05','',''),(493,'1','288','1',1,'Sale Id shift 90',0.00,0.00,0.00,913.63,0.00,'2022-12-02 10:25:05','',''),(494,'1','288','1',1,'Sale Id shift 90',0.00,0.00,0.00,1185.57,0.00,'2022-12-02 10:25:05','',''),(495,'1','288','1',1,'Sale Id shift 90',0.00,0.00,0.00,1427.12,0.00,'2022-12-02 10:25:05','',''),(496,'1','288',NULL,1,'Sale Id shift 90',952228.20,0.00,0.00,0.00,0.00,'2022-12-02 10:25:05','',''),(497,'1','288','1',1,'Sale Id shift 91',0.00,0.00,0.00,1761.49,0.00,'2022-12-02 12:20:38','',''),(498,'1','288','1',1,'Sale Id shift 91',0.00,0.00,0.00,1269.11,0.00,'2022-12-02 12:20:38','',''),(499,'1','288','2',2,'Sale Id shift 91',0.00,0.00,0.00,30.00,0.00,'2022-12-02 12:20:38','',''),(500,'1','288',NULL,2,'Sale Id shift 91',25200.00,0.00,0.00,0.00,0.00,'2022-12-02 12:20:38','',''),(501,'1','288',NULL,1,'Sale Id shift 91',636426.00,0.00,0.00,0.00,0.00,'2022-12-02 12:20:38','',''),(502,'1','288','1',1,'Sale Id shift 92',0.00,0.00,0.00,1388.95,0.00,'2022-12-03 06:11:41','',''),(503,'1','288','1',1,'Sale Id shift 92',0.00,0.00,0.00,1150.09,0.00,'2022-12-03 06:11:41','',''),(504,'1','288','1',1,'Sale Id shift 92',0.00,0.00,0.00,1717.22,0.00,'2022-12-03 06:11:41','',''),(505,'1','288','1',1,'Sale Id shift 92',0.00,0.00,0.00,958.64,0.00,'2022-12-03 06:11:41','',''),(506,'1','288',NULL,1,'Sale Id shift 92',1095129.00,0.00,0.00,0.00,0.00,'2022-12-03 06:11:41','',''),(507,'1','288','1',1,'Sale Id shift 93',0.00,0.00,0.00,1155.99,0.00,'2022-12-04 12:10:22','',''),(508,'1','288','1',1,'Sale Id shift 93',0.00,0.00,0.00,982.25,0.00,'2022-12-04 12:10:22','',''),(509,'1','288','1',1,'Sale Id shift 93',0.00,0.00,0.00,1422.79,0.00,'2022-12-04 12:10:22','',''),(510,'1','288','2',2,'Sale Id shift 93',0.00,0.00,0.00,329.90,0.00,'2022-12-04 12:10:22','',''),(511,'1','288',NULL,2,'Sale Id shift 93',277116.00,0.00,0.00,0.00,0.00,'2022-12-04 12:10:22','',''),(512,'1','288',NULL,1,'Sale Id shift 93',747816.30,0.00,0.00,0.00,0.00,'2022-12-04 12:10:22','',''),(513,'1','288','1',1,'Sale Id shift 94',0.00,0.00,0.00,1237.97,0.00,'2022-12-04 12:15:32','',''),(514,'1','288','1',1,'Sale Id shift 94',0.00,0.00,0.00,677.37,0.00,'2022-12-04 12:15:32','',''),(515,'1','288','1',1,'Sale Id shift 94',0.00,0.00,0.00,769.42,0.00,'2022-12-04 12:15:32','',''),(516,'1','288','1',1,'Sale Id shift 94',0.00,0.00,0.00,785.26,0.00,'2022-12-04 12:15:32','',''),(517,'1','288',NULL,1,'Sale Id shift 94',728704.20,0.00,0.00,0.00,0.00,'2022-12-04 12:15:32','',''),(518,'1','288','1',1,'Sale Id shift 95',0.00,0.00,0.00,860.01,0.00,'2022-12-04 12:24:01','',''),(519,'1','288','1',1,'Sale Id shift 95',0.00,0.00,0.00,480.43,0.00,'2022-12-04 12:24:01','',''),(520,'1','288','1',1,'Sale Id shift 95',0.00,0.00,0.00,826.92,0.00,'2022-12-04 12:24:01','',''),(521,'1','288','2',2,'Sale Id shift 95',0.00,0.00,0.00,30.00,0.00,'2022-12-04 12:24:01','',''),(522,'1','288',NULL,2,'Sale Id shift 95',25200.00,0.00,0.00,0.00,0.00,'2022-12-04 12:24:01','',''),(523,'1','288',NULL,1,'Sale Id shift 95',455145.60,0.00,0.00,0.00,0.00,'2022-12-04 12:24:01','',''),(524,'1','288','1',1,'Sale Id shift 96',0.00,0.00,0.00,820.19,0.00,'2022-12-05 14:32:12','',''),(525,'1','288','1',1,'Sale Id shift 96',0.00,0.00,0.00,712.44,0.00,'2022-12-05 14:32:12','',''),(526,'1','288','1',1,'Sale Id shift 96',0.00,0.00,0.00,713.54,0.00,'2022-12-05 14:32:12','',''),(527,'1','288',NULL,1,'Sale Id shift 96',471695.70,0.00,0.00,0.00,0.00,'2022-12-05 14:32:12','',''),(528,'1','288','1',1,'Sale Id shift 97',0.00,0.00,0.00,924.56,0.00,'2022-12-06 16:15:05','',''),(529,'1','288','1',1,'Sale Id shift 97',0.00,0.00,0.00,715.46,0.00,'2022-12-06 16:15:05','',''),(530,'1','288','1',1,'Sale Id shift 97',0.00,0.00,0.00,406.75,0.00,'2022-12-06 16:15:05','',''),(531,'1','288','2',2,'Sale Id shift 97',0.00,0.00,0.00,30.00,0.00,'2022-12-06 16:15:05','',''),(532,'1','288',NULL,2,'Sale Id shift 97',26400.00,0.00,0.00,0.00,0.00,'2022-12-06 16:15:05','',''),(533,'1','288',NULL,1,'Sale Id shift 97',429821.70,0.00,0.00,0.00,0.00,'2022-12-06 16:15:05','',''),(534,'1','288','1',1,'Sale Id shift 98',0.00,0.00,0.00,1237.83,0.00,'2022-12-07 04:17:07','',''),(535,'1','288','1',1,'Sale Id shift 98',0.00,0.00,0.00,731.46,0.00,'2022-12-07 04:17:07','',''),(536,'1','288','1',1,'Sale Id shift 98',0.00,0.00,0.00,832.31,0.00,'2022-12-07 04:17:07','',''),(537,'1','288','1',1,'Sale Id shift 98',0.00,0.00,0.00,567.40,0.00,'2022-12-07 04:17:07','',''),(538,'1','288','2',2,'Sale Id shift 98',0.00,0.00,0.00,30.00,0.00,'2022-12-07 04:17:07','',''),(539,'1','288',NULL,2,'Sale Id shift 98',26400.00,0.00,0.00,0.00,0.00,'2022-12-07 04:17:07','',''),(540,'1','288',NULL,1,'Sale Id shift 98',707490.00,0.00,0.00,0.00,0.00,'2022-12-07 04:17:07','',''),(541,'1','288','1',1,'Sale Id shift 99',0.00,0.00,0.00,1059.79,0.00,'2022-12-11 05:56:02','',''),(542,'1','288','1',1,'Sale Id shift 99',0.00,0.00,0.00,665.59,0.00,'2022-12-11 05:56:02','',''),(543,'1','288','1',1,'Sale Id shift 99',0.00,0.00,0.00,969.08,0.00,'2022-12-11 05:56:02','',''),(544,'1','288','1',1,'Sale Id shift 99',0.00,0.00,0.00,535.35,0.00,'2022-12-11 05:56:02','',''),(545,'1','288','2',2,'Sale Id shift 99',0.00,0.00,0.00,30.00,0.00,'2022-12-11 05:56:02','',''),(546,'1','288',NULL,2,'Sale Id shift 99',26400.00,0.00,0.00,0.00,0.00,'2022-12-11 05:56:02','',''),(547,'1','288',NULL,1,'Sale Id shift 99',678260.10,0.00,0.00,0.00,0.00,'2022-12-11 05:56:02','',''),(548,'1','288','2',2,'Sale Id shift 100',0.00,0.00,0.00,7030.00,0.00,'2023-03-03 09:58:29','',''),(549,'1','288',NULL,2,'Sale Id shift 100',5694300.00,0.00,0.00,0.00,0.00,'2023-03-03 09:58:29','',''),(550,'1','288',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,11750000.00,50000.00,0.00,0.00,'2023-03-04 06:39:33','',''),(551,'1','288',NULL,1,'Reception corrector for bridging 9',0.00,0.00,0.00,50000.00,0.00,'2023-03-04 14:55:29','',''),(552,'1','288','1',1,'Received from bridging 9',0.00,0.00,50000.00,0.00,0.00,'2023-03-04 14:55:29','',''),(553,'1','288','1',1,'Returned bridging 9',0.00,0.00,0.00,50000.00,0.00,'2023-03-04 19:25:43','',''),(554,'1','288',NULL,1,'Reception Return corrector for bridging 9',0.00,0.00,50000.00,0.00,0.00,'2023-03-04 19:25:43','',''),(555,'1','288',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,50000.00,0.00,'2023-03-04 22:32:20','',''),(556,'1','288','1',1,'Received from bridging 10',0.00,0.00,50000.00,0.00,0.00,'2023-03-04 22:32:20','',''),(557,'1','288','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,225.06,0.00,'2023-03-07 17:21:26','',''),(558,'1','288','2',0,'Inventory adjustment from tank dipping to 750',0.00,0.00,750.00,0.00,0.00,'2023-03-07 17:21:26','',''),(559,'1','288','1',1,'Sale Id shift 103',0.00,0.00,0.00,1100.27,0.00,'2023-03-07 17:25:17','',''),(560,'1','288','1',1,'Sale Id shift 103',0.00,0.00,0.00,1258.38,0.00,'2023-03-07 17:25:17','',''),(561,'1','288','1',1,'Sale Id shift 103',0.00,0.00,0.00,1021.10,0.00,'2023-03-07 17:25:17','',''),(562,'1','288','1',1,'Sale Id shift 103',0.00,0.00,0.00,1198.62,0.00,'2023-03-07 17:25:17','',''),(563,'1','288','2',2,'Sale Id shift 103',0.00,0.00,0.00,460.00,0.00,'2023-03-07 17:25:17','',''),(564,'1','288',NULL,2,'Sale Id shift 103',372600.00,0.00,0.00,0.00,0.00,'2023-03-07 17:25:17','',''),(565,'1','288',NULL,1,'Sale Id shift 103',1075916.95,0.00,0.00,0.00,0.00,'2023-03-07 17:25:17','',''),(566,'1','288','1',1,'Sale Id shift 104',0.00,0.00,0.00,1273.27,0.00,'2023-03-08 09:47:45','',''),(567,'1','288','1',1,'Sale Id shift 104',0.00,0.00,0.00,1060.19,0.00,'2023-03-08 09:47:45','',''),(568,'1','288','1',1,'Sale Id shift 104',0.00,0.00,0.00,864.28,0.00,'2023-03-08 09:47:45','',''),(569,'1','288','1',1,'Sale Id shift 104',0.00,0.00,0.00,1720.09,0.00,'2023-03-08 09:47:45','',''),(570,'1','288',NULL,1,'Sale Id shift 104',1155690.05,0.00,0.00,0.00,0.00,'2023-03-08 09:47:45','',''),(571,'1','288','1',1,'Sale Id shift 105',0.00,0.00,0.00,1572.20,0.00,'2023-03-09 10:21:17','',''),(572,'1','288','1',1,'Sale Id shift 105',0.00,0.00,0.00,1469.34,0.00,'2023-03-09 10:21:17','',''),(573,'1','288','1',1,'Sale Id shift 105',0.00,0.00,0.00,943.76,0.00,'2023-03-09 10:21:17','',''),(574,'1','288','1',1,'Sale Id shift 105',0.00,0.00,0.00,2176.06,0.00,'2023-03-09 10:21:17','',''),(575,'1','288',NULL,1,'Sale Id shift 105',1447919.60,0.00,0.00,0.00,0.00,'2023-03-09 10:21:17','',''),(576,'1','288','1',1,'Sale Id shift 106',0.00,0.00,0.00,1305.05,0.00,'2023-03-10 09:26:45','',''),(577,'1','288','1',1,'Sale Id shift 106',0.00,0.00,0.00,2087.61,0.00,'2023-03-10 09:26:45','',''),(578,'1','288','1',1,'Sale Id shift 106',0.00,0.00,0.00,1882.37,0.00,'2023-03-10 09:26:45','',''),(579,'1','288','1',1,'Sale Id shift 106',0.00,0.00,0.00,1468.42,0.00,'2023-03-10 09:26:45','',''),(580,'1','288',NULL,1,'Sale Id shift 106',1584710.75,0.00,0.00,0.00,0.00,'2023-03-10 09:26:45','',''),(581,'1','288','1',1,'Sale Id shift 107',0.00,0.00,0.00,1939.76,0.00,'2023-03-10 13:18:34','',''),(582,'1','288','1',1,'Sale Id shift 107',0.00,0.00,0.00,2075.21,0.00,'2023-03-10 13:18:34','',''),(583,'1','288','1',1,'Sale Id shift 107',0.00,0.00,0.00,1949.44,0.00,'2023-03-10 13:18:34','',''),(584,'1','288','1',1,'Sale Id shift 107',0.00,0.00,0.00,2023.96,0.00,'2023-03-10 13:18:34','',''),(585,'1','288',NULL,1,'Sale Id shift 107',1877266.95,0.00,0.00,0.00,0.00,'2023-03-10 13:18:34','',''),(586,'1','288','1',1,'Sale Id shift 108',0.00,0.00,0.00,2822.49,0.00,'2023-03-10 15:42:46','',''),(587,'1','288','1',1,'Sale Id shift 108',0.00,0.00,0.00,2483.47,0.00,'2023-03-10 15:42:46','',''),(588,'1','288','1',1,'Sale Id shift 108',0.00,0.00,0.00,2058.10,0.00,'2023-03-10 15:42:46','',''),(589,'1','288','1',1,'Sale Id shift 108',0.00,0.00,0.00,2533.34,0.00,'2023-03-10 15:42:46','',''),(590,'1','288',NULL,1,'Sale Id shift 108',2325889.00,0.00,0.00,0.00,0.00,'2023-03-10 15:42:46','',''),(591,'1','288',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,10575000.00,45000.00,0.00,0.00,'2023-03-10 15:43:10','',''),(592,'1','288',NULL,1,'Reception corrector for bridging 11',0.00,0.00,0.00,45000.00,0.00,'2023-03-10 17:42:51','',''),(593,'1','288','1',1,'Received from bridging 11',0.00,0.00,45000.00,0.00,0.00,'2023-03-10 17:42:51','',''),(594,'1','288','1',1,'Sale Id shift 109',0.00,0.00,0.00,1473.16,0.00,'2023-03-11 08:21:44','',''),(595,'1','288','1',1,'Sale Id shift 109',0.00,0.00,0.00,870.50,0.00,'2023-03-11 08:21:44','',''),(596,'1','288','1',1,'Sale Id shift 109',0.00,0.00,0.00,1841.54,0.00,'2023-03-11 08:21:44','',''),(597,'1','288','1',1,'Sale Id shift 109',0.00,0.00,0.00,699.09,0.00,'2023-03-11 08:21:44','',''),(598,'1','288',NULL,1,'Sale Id shift 109',1147808.15,0.00,0.00,0.00,0.00,'2023-03-11 08:21:44','',''),(599,'1','288','1',1,'Sale Id shift 110',0.00,0.00,0.00,1315.56,0.00,'2023-03-11 17:04:50','',''),(600,'1','288','1',1,'Sale Id shift 110',0.00,0.00,0.00,1933.72,0.00,'2023-03-11 17:04:50','',''),(601,'1','288','1',1,'Sale Id shift 110',0.00,0.00,0.00,1843.70,0.00,'2023-03-11 17:04:50','',''),(602,'1','288','1',1,'Sale Id shift 110',0.00,0.00,0.00,1864.46,0.00,'2023-03-11 17:04:50','',''),(603,'1','288',NULL,1,'Sale Id shift 110',1634998.40,0.00,0.00,0.00,0.00,'2023-03-11 17:04:50','',''),(604,'1','288','1',1,'Sale Id shift 111',0.00,0.00,0.00,1604.66,0.00,'2023-03-12 21:58:45','',''),(605,'1','288','1',1,'Sale Id shift 111',0.00,0.00,0.00,1739.38,0.00,'2023-03-12 21:58:45','',''),(606,'1','288','1',1,'Sale Id shift 111',0.00,0.00,0.00,1682.92,0.00,'2023-03-12 21:58:45','',''),(607,'1','288','1',1,'Sale Id shift 111',0.00,0.00,0.00,1929.93,0.00,'2023-03-12 21:58:45','',''),(608,'1','288',NULL,1,'Sale Id shift 111',1634869.15,0.00,0.00,0.00,0.00,'2023-03-12 21:58:45','',''),(609,'1','288','1',1,'Sale Id shift 112',0.00,0.00,0.00,1012.82,0.00,'2023-03-13 13:15:36','',''),(610,'1','288','1',1,'Sale Id shift 112',0.00,0.00,0.00,1954.12,0.00,'2023-03-13 13:15:36','',''),(611,'1','288','1',1,'Sale Id shift 112',0.00,0.00,0.00,1568.54,0.00,'2023-03-13 13:15:36','',''),(612,'1','288','1',1,'Sale Id shift 112',0.00,0.00,0.00,1637.85,0.00,'2023-03-13 13:15:36','',''),(613,'1','288','2',2,'Sale Id shift 112',0.00,0.00,0.00,210.00,0.00,'2023-03-13 13:15:36','',''),(614,'1','288',NULL,2,'Sale Id shift 112',168000.00,0.00,0.00,0.00,0.00,'2023-03-13 13:15:36','',''),(615,'1','288',NULL,1,'Sale Id shift 112',1450732.55,0.00,0.00,0.00,0.00,'2023-03-13 13:15:36','',''),(616,'1','288','1',1,'Sale Id shift 113',0.00,0.00,0.00,1778.63,0.00,'2023-03-14 08:28:16','',''),(617,'1','288','1',1,'Sale Id shift 113',0.00,0.00,0.00,1671.64,0.00,'2023-03-14 08:28:16','',''),(618,'1','288','1',1,'Sale Id shift 113',0.00,0.00,0.00,1176.82,0.00,'2023-03-14 08:28:16','',''),(619,'1','288','1',1,'Sale Id shift 113',0.00,0.00,0.00,1817.22,0.00,'2023-03-14 08:28:16','',''),(620,'1','288',NULL,1,'Sale Id shift 113',1514412.85,0.00,0.00,0.00,0.00,'2023-03-14 08:28:16','',''),(621,'1','288','1',1,'Sale Id shift 114',0.00,0.00,0.00,1057.39,0.00,'2023-03-15 09:13:41','',''),(622,'1','288','1',1,'Sale Id shift 114',0.00,0.00,0.00,826.01,0.00,'2023-03-15 09:13:41','',''),(623,'1','288','1',1,'Sale Id shift 114',0.00,0.00,0.00,965.00,0.00,'2023-03-15 09:13:41','',''),(624,'1','288','1',1,'Sale Id shift 114',0.00,0.00,0.00,886.20,0.00,'2023-03-15 09:13:41','',''),(625,'1','288',NULL,1,'Sale Id shift 114',877631.00,0.00,0.00,0.00,0.00,'2023-03-15 09:13:41','',''),(626,'1','288',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,10575000.00,45000.00,0.00,0.00,'2023-03-15 20:29:25','',''),(627,'1','288',NULL,1,'Reception corrector for bridging 12',0.00,0.00,0.00,45000.00,0.00,'2023-03-16 08:52:30','',''),(628,'1','288','1',1,'Received from bridging 12',0.00,0.00,45000.00,0.00,0.00,'2023-03-16 08:52:30','',''),(629,'1','288','1',1,'Sale Id shift 115',0.00,0.00,0.00,1572.20,0.00,'2023-03-16 09:08:48','',''),(630,'1','288','1',1,'Sale Id shift 115',0.00,0.00,0.00,889.48,0.00,'2023-03-16 09:08:48','',''),(631,'1','288','1',1,'Sale Id shift 115',0.00,0.00,0.00,1748.86,0.00,'2023-03-16 09:08:48','',''),(632,'1','288','1',1,'Sale Id shift 115',0.00,0.00,0.00,393.05,0.00,'2023-03-16 09:08:48','',''),(633,'1','288',NULL,1,'Sale Id shift 115',1081843.65,0.00,0.00,0.00,0.00,'2023-03-16 09:08:48','',''),(634,'1','288','1',1,'Sale Id shift 116',0.00,0.00,0.00,2552.58,0.00,'2023-03-17 07:50:19','',''),(635,'1','288','1',1,'Sale Id shift 116',0.00,0.00,0.00,2050.34,0.00,'2023-03-17 07:50:19','',''),(636,'1','288','1',1,'Sale Id shift 116',0.00,0.00,0.00,3256.80,0.00,'2023-03-17 07:50:19','',''),(637,'1','288','1',1,'Sale Id shift 116',0.00,0.00,0.00,2280.96,0.00,'2023-03-17 07:50:19','',''),(638,'1','288',NULL,1,'Sale Id shift 116',2383059.80,0.00,0.00,0.00,0.00,'2023-03-17 07:50:19','',''),(639,'1','288','1',1,'Sale Id shift 117',0.00,0.00,0.00,3827.93,0.00,'2023-03-20 08:09:35','',''),(640,'1','288','1',1,'Sale Id shift 117',0.00,0.00,0.00,2666.42,0.00,'2023-03-20 08:09:35','',''),(641,'1','288','1',1,'Sale Id shift 117',0.00,0.00,0.00,3410.42,0.00,'2023-03-20 08:09:35','',''),(642,'1','288','1',1,'Sale Id shift 117',0.00,0.00,0.00,1801.48,0.00,'2023-03-20 08:09:35','',''),(643,'1','288',NULL,1,'Sale Id shift 117',2750968.75,0.00,0.00,0.00,0.00,'2023-03-20 08:09:35','',''),(644,'1','288','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,80.00,0.00,'2023-03-20 10:09:35','',''),(645,'1','288','2',0,'Inventory adjustment from tank dipping to 413',0.00,0.00,413.00,0.00,0.00,'2023-03-20 10:09:35','',''),(646,'1','288','1',1,'Sale Id shift 118',0.00,0.00,0.00,2079.01,0.00,'2023-03-20 10:26:58','',''),(647,'1','288','1',1,'Sale Id shift 118',0.00,0.00,0.00,2142.86,0.00,'2023-03-20 10:26:58','',''),(648,'1','288','1',1,'Sale Id shift 118',0.00,0.00,0.00,2748.05,0.00,'2023-03-20 10:26:58','',''),(649,'1','288','1',1,'Sale Id shift 118',0.00,0.00,0.00,1541.35,0.00,'2023-03-20 10:26:58','',''),(650,'1','288','2',2,'Sale Id shift 118',0.00,0.00,0.00,212.54,0.00,'2023-03-20 10:26:58','',''),(651,'1','288',NULL,2,'Sale Id shift 118',167906.60,0.00,0.00,0.00,0.00,'2023-03-20 10:26:58','',''),(652,'1','288',NULL,1,'Sale Id shift 118',2000148.45,0.00,0.00,0.00,0.00,'2023-03-20 10:26:58','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'1','288',2,-444.94,'2023-03-20 10:26:58'),(2,'1','288',1,39526.34,'2023-03-20 10:26:58');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=153 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1,'1','288',1,'Sale Id shift 1',0.00,263988.00,180.00,263988.00,0.00,'2022-10-28 07:23:01'),(2,'1','288',1,'Sale Id shift 2',0.00,345909.60,180.00,345909.60,0.00,'2022-10-30 11:14:04'),(3,'1','288',1,'Sale Id shift 3',0.00,282423.60,0.00,0.00,-282423.60,'2022-10-30 23:08:27'),(4,'1','288',1,'Sale Id shift 7',0.00,350026.20,180.00,350026.20,0.00,'2022-11-03 09:18:47'),(5,'1','288',1,'Sale Id shift 8',0.00,236435.40,180.00,236435.40,0.00,'2022-11-03 23:27:16'),(6,'1','288',1,'Sale Id shift 9',0.00,174416.40,180.00,174416.40,0.00,'2022-11-06 11:17:44'),(7,'1','288',1,'Sale Id shift 10',0.00,216774.00,180.00,216774.00,0.00,'2022-11-06 14:20:04'),(8,'1','288',1,'Sale Id shift 11',0.00,171936.00,180.00,171936.00,0.00,'2022-11-06 20:46:51'),(9,'1','288',1,'Sale Id shift 12',0.00,1225029.60,180.00,1225029.60,0.00,'2022-11-06 21:20:17'),(10,'1','288',1,'Sale Id shift 13',0.00,174994.20,180.00,174994.20,0.00,'2022-11-07 08:24:11'),(11,'1','288',1,'Sale Id shift 14',0.00,210657.60,180.00,210657.60,0.00,'2022-11-08 04:14:24'),(12,'1','288',1,'Sale Id shift 15',0.00,238546.80,180.00,238546.80,0.00,'2022-11-08 11:20:20'),(13,'1','288',1,'Sale Id shift 16',0.00,1996698.60,180.00,1996698.60,0.00,'2022-11-08 13:04:32'),(14,'1','288',1,'Sale Id shift 17',0.00,156486.60,180.00,156486.60,0.00,'2022-11-08 23:07:23'),(15,'1','288',1,'Sale Id shift 18',0.00,89389.80,180.00,89389.80,0.00,'2022-11-09 12:04:36'),(16,'1','288',1,'Sale Id shift 19',0.00,217404.00,180.00,217404.00,0.00,'2022-11-09 14:37:03'),(17,'1','288',1,'Sale Id shift 20',0.00,241473.60,180.00,241473.60,0.00,'2022-11-09 19:26:00'),(18,'1','288',1,'Sale Id shift 21',0.00,213625.80,180.00,213625.80,0.00,'2022-11-10 10:29:39'),(19,'1','288',1,'Sale Id shift 22',0.00,92329.20,180.00,92329.20,0.00,'2022-11-10 12:58:37'),(20,'1','288',1,'Sale Id shift 23',0.00,174576.60,180.00,174576.60,0.00,'2022-11-10 17:56:07'),(21,'1','288',1,'Sale Id shift 24',0.00,210040.20,180.00,210040.20,0.00,'2022-11-10 18:07:39'),(22,'1','288',1,'Sale Id shift 25',0.00,205243.20,180.00,205243.20,0.00,'2022-11-11 01:59:01'),(23,'1','288',2,'Sale Id shift 26',0.00,19611.90,770.00,19611.90,0.00,'2022-11-11 10:35:50'),(24,'1','288',1,'Sale Id shift 26',0.00,209120.40,180.00,209120.40,0.00,'2022-11-11 10:35:50'),(25,'1','288',1,'Sale Id shift 27',0.00,200714.40,180.00,200714.40,0.00,'2022-11-11 15:04:20'),(26,'1','288',1,'Sale Id shift 28',0.00,280387.80,180.00,280387.80,0.00,'2022-11-12 09:17:07'),(27,'1','288',1,'Sale Id shift 29',0.00,217121.40,180.00,217121.40,0.00,'2022-11-12 09:32:48'),(28,'1','288',1,'Sale Id shift 30',0.00,164824.20,180.00,164824.20,0.00,'2022-11-12 09:44:53'),(29,'1','288',1,'Sale Id shift 31',0.00,202474.80,180.00,202474.80,0.00,'2022-11-12 10:13:24'),(30,'1','288',1,'Sale Id shift 32',0.00,214491.60,180.00,214491.60,0.00,'2022-11-12 10:33:35'),(31,'1','288',2,'Sale Id shift 33',0.00,38500.00,770.00,38500.00,0.00,'2022-11-12 10:52:41'),(32,'1','288',1,'Sale Id shift 33',0.00,227050.20,180.00,227050.20,0.00,'2022-11-12 10:52:41'),(33,'1','288',2,'Sale Id shift 34',0.00,77000.00,770.00,77000.00,0.00,'2022-11-12 11:01:47'),(34,'1','288',1,'Sale Id shift 34',0.00,299592.00,180.00,299592.00,0.00,'2022-11-12 11:01:47'),(35,'1','288',1,'Sale Id shift 35',0.00,260022.60,180.00,260022.60,0.00,'2022-11-12 11:11:06'),(36,'1','288',2,'Sale Id shift 36',0.00,38507.70,770.00,38507.70,0.00,'2022-11-12 11:55:41'),(37,'1','288',1,'Sale Id shift 36',0.00,212765.40,180.00,212765.40,0.00,'2022-11-12 11:55:41'),(38,'1','288',1,'Sale Id shift 37',0.00,206218.80,180.00,206218.80,0.00,'2022-11-12 12:01:38'),(39,'1','288',2,'Sale Id shift 38',0.00,40000.00,800.00,40000.00,0.00,'2022-11-12 12:22:08'),(40,'1','288',1,'Sale Id shift 38',0.00,1011843.00,180.00,1011843.00,0.00,'2022-11-12 12:22:08'),(41,'1','288',1,'Sale Id shift 39',0.00,296868.60,180.00,296868.60,0.00,'2022-11-12 12:26:18'),(42,'1','288',2,'Sale Id shift 40',0.00,40000.00,800.00,40000.00,0.00,'2022-11-13 06:32:16'),(43,'1','288',1,'Sale Id shift 40',0.00,272521.80,180.00,272521.80,0.00,'2022-11-13 06:32:16'),(44,'1','288',1,'Sale Id shift 41',0.00,265856.40,180.00,265856.40,0.00,'2022-11-13 08:43:11'),(45,'1','288',1,'Sale Id shift 42',0.00,241005.60,180.00,241005.60,0.00,'2022-11-13 08:57:46'),(46,'1','288',1,'Sale Id shift 43',0.00,284486.40,180.00,284486.40,0.00,'2022-11-13 09:06:51'),(47,'1','288',2,'Sale Id shift 44',0.00,40000.00,800.00,40000.00,0.00,'2022-11-13 09:25:13'),(48,'1','288',1,'Sale Id shift 44',0.00,212202.00,180.00,212202.00,0.00,'2022-11-13 09:25:13'),(49,'1','288',1,'Sale Id shift 45',0.00,326379.60,180.00,326379.60,0.00,'2022-11-13 09:34:49'),(50,'1','288',1,'Sale Id shift 46',0.00,244548.00,180.00,244548.00,0.00,'2022-11-13 09:48:22'),(51,'1','288',1,'Sale Id shift 47',0.00,458994.60,180.00,458994.60,0.00,'2022-11-13 10:08:44'),(52,'1','288',2,'Sale Id shift 48',0.00,40000.00,800.00,40000.00,0.00,'2022-11-13 11:11:09'),(53,'1','288',1,'Sale Id shift 48',0.00,611809.20,180.00,611809.20,0.00,'2022-11-13 11:11:09'),(54,'1','288',1,'Sale Id shift 49',0.00,1819051.20,180.00,1819051.20,0.00,'2022-11-13 23:11:34'),(55,'1','288',2,'Sale Id shift 50',0.00,24000.00,800.00,24000.00,0.00,'2022-11-14 11:50:51'),(56,'1','288',1,'Sale Id shift 50',0.00,937216.80,180.00,937216.80,0.00,'2022-11-14 11:50:51'),(57,'1','288',1,'Sale Id shift 51',0.00,250156.80,180.00,250156.80,0.00,'2022-11-14 14:15:00'),(58,'1','288',2,'Sale Id shift 52',0.00,24000.00,800.00,24000.00,0.00,'2022-11-15 09:41:24'),(59,'1','288',1,'Sale Id shift 52',0.00,257880.60,180.00,257880.60,0.00,'2022-11-15 09:41:24'),(60,'1','288',1,'Sale Id shift 53',0.00,333549.00,180.00,333549.00,0.00,'2022-11-15 11:53:35'),(61,'1','288',2,'Sale Id shift 54',0.00,24000.00,800.00,24000.00,0.00,'2022-11-15 12:40:05'),(62,'1','288',1,'Sale Id shift 54',0.00,463626.00,180.00,463626.00,0.00,'2022-11-15 12:40:05'),(63,'1','288',1,'Sale Id shift 55',0.00,286324.20,180.00,286324.20,0.00,'2022-11-15 21:36:23'),(64,'1','288',2,'Sale Id shift 56',0.00,24000.00,800.00,24000.00,0.00,'2022-11-18 06:29:01'),(65,'1','288',1,'Sale Id shift 56',0.00,487861.20,180.00,487861.20,0.00,'2022-11-18 06:29:01'),(66,'1','288',1,'Sale Id shift 57',0.00,468252.00,180.00,468252.00,0.00,'2022-11-18 09:27:16'),(67,'1','288',2,'Sale Id shift 58',0.00,24000.00,800.00,24000.00,0.00,'2022-11-18 09:34:34'),(68,'1','288',1,'Sale Id shift 58',0.00,381060.00,180.00,381060.00,0.00,'2022-11-18 09:34:34'),(69,'1','288',1,'Sale Id shift 59',0.00,430756.20,180.00,430756.20,0.00,'2022-11-18 09:49:03'),(70,'1','288',2,'Sale Id shift 60',0.00,24000.00,800.00,24000.00,0.00,'2022-11-18 09:59:21'),(71,'1','288',1,'Sale Id shift 60',0.00,496897.20,180.00,496897.20,0.00,'2022-11-18 09:59:21'),(72,'1','288',2,'Sale Id shift 61',0.00,63256.00,800.00,63256.00,0.00,'2022-11-18 10:11:32'),(73,'1','288',1,'Sale Id shift 61',0.00,410398.20,180.00,410398.20,0.00,'2022-11-18 10:11:32'),(74,'1','288',2,'Sale Id shift 62',0.00,23992.00,800.00,23992.00,0.00,'2022-11-18 10:41:15'),(75,'1','288',1,'Sale Id shift 62',0.00,386191.80,180.00,386191.80,0.00,'2022-11-18 10:41:15'),(76,'1','288',2,'Sale Id shift 63',0.00,1000.00,800.00,1000.00,0.00,'2022-11-18 10:52:54'),(77,'1','288',1,'Sale Id shift 63',0.00,406072.80,180.00,406072.80,0.00,'2022-11-18 10:52:54'),(78,'1','288',2,'Sale Id shift 64',0.00,24000.00,800.00,24000.00,0.00,'2022-11-18 13:17:41'),(79,'1','288',1,'Sale Id shift 64',0.00,510994.80,180.00,510994.80,0.00,'2022-11-18 13:17:41'),(80,'1','288',2,'Sale Id shift 65',0.00,41600.00,800.00,41600.00,0.00,'2022-11-18 15:42:48'),(81,'1','288',1,'Sale Id shift 65',0.00,329302.80,180.00,329302.80,0.00,'2022-11-18 15:42:48'),(82,'1','288',2,'Sale Id shift 66',0.00,24000.00,800.00,24000.00,0.00,'2022-11-18 16:12:12'),(83,'1','288',1,'Sale Id shift 66',0.00,508491.00,180.00,508491.00,0.00,'2022-11-18 16:12:12'),(84,'1','288',1,'Sale Id shift 67',0.00,427194.00,180.00,427194.00,0.00,'2022-11-18 16:19:15'),(85,'1','288',2,'Sale Id shift 68',0.00,24000.00,800.00,24000.00,0.00,'2022-11-18 16:30:11'),(86,'1','288',1,'Sale Id shift 68',0.00,419119.20,180.00,419119.20,0.00,'2022-11-18 16:30:11'),(87,'1','288',2,'Sale Id shift 69',0.00,9000.00,800.00,9000.00,0.00,'2022-11-18 16:39:41'),(88,'1','288',1,'Sale Id shift 69',0.00,400296.60,180.00,400296.60,0.00,'2022-11-18 16:39:41'),(89,'1','288',2,'Sale Id shift 70',0.00,24000.00,800.00,24000.00,0.00,'2022-11-18 16:51:09'),(90,'1','288',1,'Sale Id shift 70',0.00,465195.60,180.00,465195.60,0.00,'2022-11-18 16:51:09'),(91,'1','288',1,'Sale Id shift 71',0.00,424929.60,180.00,424929.60,0.00,'2022-11-18 16:59:11'),(92,'1','288',2,'Sale Id shift 72',0.00,24000.00,800.00,24000.00,0.00,'2022-11-18 17:10:28'),(93,'1','288',1,'Sale Id shift 72',0.00,367221.60,180.00,367221.60,0.00,'2022-11-18 17:10:28'),(94,'1','288',1,'Sale Id shift 73',0.00,296204.40,180.00,296204.40,0.00,'2022-11-18 17:19:09'),(95,'1','288',2,'Sale Id shift 74',0.00,24000.00,800.00,24000.00,0.00,'2022-11-18 17:27:24'),(96,'1','288',1,'Sale Id shift 74',0.00,323884.80,180.00,323884.80,0.00,'2022-11-18 17:27:24'),(97,'1','288',2,'Sale Id shift 75',0.00,40000.00,800.00,40000.00,0.00,'2022-11-24 23:28:19'),(98,'1','288',2,'Sale Id shift 76',0.00,8250000.00,825.00,8250000.00,0.00,'2022-11-25 17:36:17'),(99,'1','288',2,'Sale Id shift 77',0.00,9075.00,825.00,9075.00,0.00,'2022-11-26 09:51:54'),(100,'1','288',2,'Sale Id shift 78',0.00,142800.00,840.00,142800.00,0.00,'2022-11-27 09:22:53'),(101,'1','288',1,'Sale Id shift 78',0.00,16174.20,210.00,16174.20,0.00,'2022-11-27 09:22:53'),(102,'1','288',2,'Sale Id shift 79',0.00,42000.00,840.00,42000.00,0.00,'2022-11-27 14:33:49'),(103,'1','288',1,'Sale Id shift 79',0.00,173054.70,210.00,173054.70,0.00,'2022-11-27 14:33:49'),(104,'1','288',2,'Sale Id shift 80',0.00,25200.00,840.00,25200.00,0.00,'2022-11-28 12:08:55'),(105,'1','288',1,'Sale Id shift 80',0.00,591108.00,210.00,591108.00,0.00,'2022-11-28 12:08:55'),(106,'1','288',1,'Sale Id shift 81',0.00,340783.80,210.00,340783.80,0.00,'2022-11-28 13:58:10'),(107,'1','288',1,'Sale Id shift 82',0.00,338778.30,210.00,338778.30,0.00,'2022-11-28 14:10:37'),(108,'1','288',2,'Sale Id shift 83',0.00,474600.00,840.00,474600.00,0.00,'2022-11-28 14:42:29'),(109,'1','288',1,'Sale Id shift 83',0.00,379327.20,210.00,379327.20,0.00,'2022-11-28 14:42:29'),(110,'1','288',1,'Sale Id shift 84',0.00,574975.80,210.00,574975.80,0.00,'2022-11-29 11:18:29'),(111,'1','288',1,'Sale Id shift 85',0.00,436033.50,210.00,436033.50,0.00,'2022-11-29 16:54:56'),(112,'1','288',1,'Sale Id shift 86',0.00,651966.00,210.00,651966.00,0.00,'2022-11-30 11:32:32'),(113,'1','288',2,'Sale Id shift 87',0.00,25200.00,840.00,25200.00,0.00,'2022-12-01 07:48:40'),(114,'1','288',1,'Sale Id shift 87',0.00,586242.30,210.00,586242.30,0.00,'2022-12-01 07:48:40'),(115,'1','288',1,'Sale Id shift 88',0.00,848261.40,210.00,848261.40,0.00,'2022-12-01 14:56:27'),(116,'1','288',1,'Sale Id shift 89',0.00,648062.10,210.00,648062.10,0.00,'2022-12-01 15:11:40'),(117,'1','288',1,'Sale Id shift 90',0.00,952228.20,210.00,952228.20,0.00,'2022-12-02 10:25:05'),(118,'1','288',2,'Sale Id shift 91',0.00,25200.00,840.00,25200.00,0.00,'2022-12-02 12:20:38'),(119,'1','288',1,'Sale Id shift 91',0.00,636426.00,210.00,636426.00,0.00,'2022-12-02 12:20:38'),(120,'1','288',1,'Sale Id shift 92',0.00,1095129.00,210.00,1095129.00,0.00,'2022-12-03 06:11:41'),(121,'1','288',2,'Sale Id shift 93',0.00,277116.00,840.00,277116.00,0.00,'2022-12-04 12:10:22'),(122,'1','288',1,'Sale Id shift 93',0.00,747816.30,210.00,747816.30,0.00,'2022-12-04 12:10:22'),(123,'1','288',1,'Sale Id shift 94',0.00,728704.20,210.00,728704.20,0.00,'2022-12-04 12:15:32'),(124,'1','288',2,'Sale Id shift 95',0.00,25200.00,840.00,25200.00,0.00,'2022-12-04 12:24:01'),(125,'1','288',1,'Sale Id shift 95',0.00,455145.60,210.00,455145.60,0.00,'2022-12-04 12:24:01'),(126,'1','288',1,'Sale Id shift 96',0.00,471695.70,210.00,471695.70,0.00,'2022-12-05 14:32:12'),(127,'1','288',2,'Sale Id shift 97',0.00,26400.00,880.00,26400.00,0.00,'2022-12-06 16:15:05'),(128,'1','288',1,'Sale Id shift 97',0.00,429821.70,210.00,429821.70,0.00,'2022-12-06 16:15:05'),(129,'1','288',2,'Sale Id shift 98',0.00,26400.00,880.00,26400.00,0.00,'2022-12-07 04:17:07'),(130,'1','288',1,'Sale Id shift 98',0.00,707490.00,210.00,707490.00,0.00,'2022-12-07 04:17:07'),(131,'1','288',2,'Sale Id shift 99',0.00,26400.00,880.00,26400.00,0.00,'2022-12-11 05:56:02'),(132,'1','288',1,'Sale Id shift 99',0.00,678260.10,210.00,678260.10,0.00,'2022-12-11 05:56:02'),(133,'1','288',2,'Sale Id shift 100',0.00,5694300.00,810.00,5694300.00,0.00,'2023-03-03 09:58:29'),(134,'1','288',2,'Sale Id shift 103',0.00,372600.00,810.00,372600.00,0.00,'2023-03-07 17:25:17'),(135,'1','288',1,'Sale Id shift 103',0.00,1075916.95,235.00,1075916.95,0.00,'2023-03-07 17:25:17'),(136,'1','288',1,'Sale Id shift 104',0.00,1155690.05,235.00,1155690.05,0.00,'2023-03-08 09:47:45'),(137,'1','288',1,'Sale Id shift 105',0.00,1447919.60,235.00,1447919.60,0.00,'2023-03-09 10:21:17'),(138,'1','288',1,'Sale Id shift 106',0.00,1584710.75,235.00,1584710.75,0.00,'2023-03-10 09:26:45'),(139,'1','288',1,'Sale Id shift 107',0.00,1877266.95,235.00,1877266.95,0.00,'2023-03-10 13:18:34'),(140,'1','288',1,'Sale Id shift 108',0.00,2325889.00,235.00,2325889.00,0.00,'2023-03-10 15:42:46'),(141,'1','288',1,'Sale Id shift 109',0.00,1147808.15,235.00,1147808.15,0.00,'2023-03-11 08:21:44'),(142,'1','288',1,'Sale Id shift 110',0.00,1634998.40,235.00,1634998.40,0.00,'2023-03-11 17:04:50'),(143,'1','288',1,'Sale Id shift 111',0.00,1634869.15,235.00,1634869.15,0.00,'2023-03-12 21:58:45'),(144,'1','288',2,'Sale Id shift 112',0.00,168000.00,800.00,168000.00,0.00,'2023-03-13 13:15:36'),(145,'1','288',1,'Sale Id shift 112',0.00,1450732.55,235.00,1450732.55,0.00,'2023-03-13 13:15:36'),(146,'1','288',1,'Sale Id shift 113',0.00,1514412.85,235.00,1514412.85,0.00,'2023-03-14 08:28:16'),(147,'1','288',1,'Sale Id shift 114',0.00,877631.00,235.00,877631.00,0.00,'2023-03-15 09:13:41'),(148,'1','288',1,'Sale Id shift 115',0.00,1081843.65,235.00,1081843.65,0.00,'2023-03-16 09:08:48'),(149,'1','288',1,'Sale Id shift 116',0.00,2383059.80,235.00,2383059.80,0.00,'2023-03-17 07:50:19'),(150,'1','288',1,'Sale Id shift 117',0.00,2750968.75,235.00,2750968.75,0.00,'2023-03-20 08:09:35'),(151,'1','288',2,'Sale Id shift 118',0.00,167906.60,790.00,167906.60,0.00,'2023-03-20 10:26:58'),(152,'1','288',1,'Sale Id shift 118',0.00,2000148.45,235.00,2000148.45,0.00,'2023-03-20 10:26:58');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=645 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('1','288',1,'','24','1',0.00,8856000.00,'Purchase Id 2 for 49,200.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-10-27 11:10:27','',''),('1','288',2,'','supplier','1',8856000.00,0.00,'Purchase Id 2 for 49,200.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-10-27 11:10:27','',''),('1','288',3,'','24','1',0.00,9000000.00,'Purchase Id 4 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-10-27 18:06:00','',''),('1','288',4,'','supplier','1',9000000.00,0.00,'Purchase Id 4 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-10-27 18:06:00','',''),('1','288',5,'','24','1',0.00,15092000.00,'Purchase Id 3 for 19,600.00 litters of Diesel - AGO from AA RANO NIGERIA LTD','2022-10-27 18:07:00','',''),('1','288',6,'','supplier','1',15092000.00,0.00,'Purchase Id 3 for 19,600.00 litters of Diesel - AGO from AA RANO NIGERIA LTD','2022-10-27 18:07:00','',''),('1','288',7,'','20','3',263988.00,0.00,'Sales from shift 1 on 2022-10-28 07:23:01 ','2022-10-28 07:23:01','',''),('1','288',8,'','6.1','4',0.00,263988.00,'Sales from shift 1 on 2022-10-28 07:23:01 ','2022-10-28 07:23:01','',''),('1','288',9,'','20','3',345909.60,0.00,'Sales from shift 2 on 2022-10-30 11:14:04 ','2022-10-30 11:14:04','',''),('1','288',10,'','6.1','4',0.00,345909.60,'Sales from shift 2 on 2022-10-30 11:14:04 ','2022-10-30 11:14:04','',''),('1','288',11,'','20','3',0.00,0.00,'Sales from shift 3 on 2022-10-30 23:08:27 ','2022-10-30 23:08:27','',''),('1','288',12,'','6.1','4',0.00,0.00,'Sales from shift 3 on 2022-10-30 23:08:27 ','2022-10-30 23:08:27','',''),('1','288',13,'','20','3',0.00,0.00,'Sales from shift 4 on 2022-11-01 18:07:32 ','2022-11-01 18:07:32','',''),('1','288',14,'','6.1','4',0.00,0.00,'Sales from shift 4 on 2022-11-01 18:07:32 ','2022-11-01 18:07:32','',''),('1','288',15,'','20','3',0.00,0.00,'Sales from shift 5 on 2022-11-02 12:07:53 ','2022-11-02 12:07:53','',''),('1','288',16,'','6.1','4',0.00,0.00,'Sales from shift 5 on 2022-11-02 12:07:53 ','2022-11-02 12:07:53','',''),('1','288',17,'','20','3',0.00,0.00,'Sales from shift 6 on 2022-11-03 08:25:02 ','2022-11-03 08:25:02','',''),('1','288',18,'','6.1','4',0.00,0.00,'Sales from shift 6 on 2022-11-03 08:25:02 ','2022-11-03 08:25:02','',''),('1','288',19,'','20','3',350026.20,0.00,'Sales from shift 7 on 2022-11-03 09:18:47 ','2022-11-03 09:18:47','',''),('1','288',20,'','6.1','4',0.00,350026.20,'Sales from shift 7 on 2022-11-03 09:18:47 ','2022-11-03 09:18:47','',''),('1','288',21,'','20','3',236435.40,0.00,'Sales from shift 8 on 2022-11-03 23:27:16 ','2022-11-03 23:27:16','',''),('1','288',22,'','6.1','4',0.00,236435.40,'Sales from shift 8 on 2022-11-03 23:27:16 ','2022-11-03 23:27:16','',''),('1','288',23,'','20','3',174416.40,0.00,'Sales from shift 9 on 2022-11-06 11:17:44 ','2022-11-06 11:17:44','',''),('1','288',24,'','6.1','4',0.00,174416.40,'Sales from shift 9 on 2022-11-06 11:17:44 ','2022-11-06 11:17:44','',''),('1','288',25,'','20','3',216774.00,0.00,'Sales from shift 10 on 2022-11-06 14:20:04 ','2022-11-06 14:20:04','',''),('1','288',26,'','6.1','4',0.00,216774.00,'Sales from shift 10 on 2022-11-06 14:20:04 ','2022-11-06 14:20:04','',''),('1','288',27,'','20','3',171936.00,0.00,'Sales from shift 11 on 2022-11-06 20:46:51 ','2022-11-06 20:46:51','',''),('1','288',28,'','6.1','4',0.00,171936.00,'Sales from shift 11 on 2022-11-06 20:46:51 ','2022-11-06 20:46:51','',''),('1','288',29,'','20','3',1225029.60,0.00,'Sales from shift 12 on 2022-11-06 21:20:17 ','2022-11-06 21:20:17','',''),('1','288',30,'','6.1','4',0.00,1225029.60,'Sales from shift 12 on 2022-11-06 21:20:17 ','2022-11-06 21:20:17','',''),('1','288',31,'','20','3',174994.20,0.00,'Sales from shift 13 on 2022-11-07 08:24:11 ','2022-11-07 08:24:11','',''),('1','288',32,'','6.1','4',0.00,174994.20,'Sales from shift 13 on 2022-11-07 08:24:11 ','2022-11-07 08:24:11','',''),('1','288',33,'','20','3',210657.60,0.00,'Sales from shift 14 on 2022-11-08 04:14:24 ','2022-11-08 04:14:24','',''),('1','288',34,'','6.1','4',0.00,210657.60,'Sales from shift 14 on 2022-11-08 04:14:24 ','2022-11-08 04:14:24','',''),('1','288',35,'','20','3',238546.80,0.00,'Sales from shift 15 on 2022-11-08 11:20:20 ','2022-11-08 11:20:20','',''),('1','288',36,'','6.1','4',0.00,238546.80,'Sales from shift 15 on 2022-11-08 11:20:20 ','2022-11-08 11:20:20','',''),('1','288',37,'','20','3',1996698.60,0.00,'Sales from shift 16 on 2022-11-08 13:04:32 ','2022-11-08 13:04:32','',''),('1','288',38,'','6.1','4',0.00,1996698.60,'Sales from shift 16 on 2022-11-08 13:04:32 ','2022-11-08 13:04:32','',''),('1','288',39,'','20','3',156486.60,0.00,'Sales from shift 17 on 2022-11-08 23:07:23 ','2022-11-08 23:07:23','',''),('1','288',40,'','6.1','4',0.00,156486.60,'Sales from shift 17 on 2022-11-08 23:07:23 ','2022-11-08 23:07:23','',''),('1','288',41,'','20','3',89389.80,0.00,'Sales from shift 18 on 2022-11-09 12:04:36 ','2022-11-09 12:04:36','',''),('1','288',42,'','6.1','4',0.00,89389.80,'Sales from shift 18 on 2022-11-09 12:04:36 ','2022-11-09 12:04:36','',''),('1','288',43,'','20','3',217404.00,0.00,'Sales from shift 19 on 2022-11-09 14:37:03 ','2022-11-09 14:37:03','',''),('1','288',44,'','6.1','4',0.00,217404.00,'Sales from shift 19 on 2022-11-09 14:37:03 ','2022-11-09 14:37:03','',''),('1','288',45,'','20','3',241473.60,0.00,'Sales from shift 20 on 2022-11-09 19:26:00 ','2022-11-09 19:26:00','',''),('1','288',46,'','6.1','4',0.00,241473.60,'Sales from shift 20 on 2022-11-09 19:26:00 ','2022-11-09 19:26:00','',''),('1','288',47,'','20','3',213625.80,0.00,'Sales from shift 21 on 2022-11-10 10:29:39 ','2022-11-10 10:29:39','',''),('1','288',48,'','6.1','4',0.00,213625.80,'Sales from shift 21 on 2022-11-10 10:29:39 ','2022-11-10 10:29:39','',''),('1','288',49,'','20','3',92329.20,0.00,'Sales from shift 22 on 2022-11-10 12:58:36 ','2022-11-10 12:58:36','',''),('1','288',50,'','6.1','4',0.00,92329.20,'Sales from shift 22 on 2022-11-10 12:58:36 ','2022-11-10 12:58:36','',''),('1','288',51,'','20','3',174576.60,0.00,'Sales from shift 23 on 2022-11-10 17:56:07 ','2022-11-10 17:56:07','',''),('1','288',52,'','6.1','4',0.00,174576.60,'Sales from shift 23 on 2022-11-10 17:56:07 ','2022-11-10 17:56:07','',''),('1','288',53,'','20','3',210040.20,0.00,'Sales from shift 24 on 2022-11-10 18:07:39 ','2022-11-10 18:07:39','',''),('1','288',54,'','6.1','4',0.00,210040.20,'Sales from shift 24 on 2022-11-10 18:07:39 ','2022-11-10 18:07:39','',''),('1','288',55,'','20','3',205243.20,0.00,'Sales from shift 25 on 2022-11-11 01:59:01 ','2022-11-11 01:59:01','',''),('1','288',56,'','6.1','4',0.00,205243.20,'Sales from shift 25 on 2022-11-11 01:59:01 ','2022-11-11 01:59:01','',''),('1','288',57,'','20','3',228732.30,0.00,'Sales from shift 26 on 2022-11-11 10:35:50 ','2022-11-11 10:35:50','',''),('1','288',58,'','6.1','4',0.00,228732.30,'Sales from shift 26 on 2022-11-11 10:35:50 ','2022-11-11 10:35:50','',''),('1','288',59,'','20','3',200714.40,0.00,'Sales from shift 27 on 2022-11-11 15:04:20 ','2022-11-11 15:04:20','',''),('1','288',60,'','6.1','4',0.00,200714.40,'Sales from shift 27 on 2022-11-11 15:04:20 ','2022-11-11 15:04:20','',''),('1','288',61,'','20','3',280387.80,0.00,'Sales from shift 28 on 2022-11-12 09:17:07 ','2022-11-12 09:17:07','',''),('1','288',62,'','6.1','4',0.00,280387.80,'Sales from shift 28 on 2022-11-12 09:17:07 ','2022-11-12 09:17:07','',''),('1','288',63,'','20','3',217121.40,0.00,'Sales from shift 29 on 2022-11-12 09:32:48 ','2022-11-12 09:32:48','',''),('1','288',64,'','6.1','4',0.00,217121.40,'Sales from shift 29 on 2022-11-12 09:32:48 ','2022-11-12 09:32:48','',''),('1','288',65,'','20','3',164824.20,0.00,'Sales from shift 30 on 2022-11-12 09:44:53 ','2022-11-12 09:44:53','',''),('1','288',66,'','6.1','4',0.00,164824.20,'Sales from shift 30 on 2022-11-12 09:44:53 ','2022-11-12 09:44:53','',''),('1','288',67,'','20','3',202474.80,0.00,'Sales from shift 31 on 2022-11-12 10:13:24 ','2022-11-12 10:13:24','',''),('1','288',68,'','6.1','4',0.00,202474.80,'Sales from shift 31 on 2022-11-12 10:13:24 ','2022-11-12 10:13:24','',''),('1','288',69,'','20','3',214491.60,0.00,'Sales from shift 32 on 2022-11-12 10:33:35 ','2022-11-12 10:33:35','',''),('1','288',70,'','6.1','4',0.00,214491.60,'Sales from shift 32 on 2022-11-12 10:33:35 ','2022-11-12 10:33:35','',''),('1','288',71,'','20','3',265550.20,0.00,'Sales from shift 33 on 2022-11-12 10:52:41 ','2022-11-12 10:52:41','',''),('1','288',72,'','6.1','4',0.00,265550.20,'Sales from shift 33 on 2022-11-12 10:52:41 ','2022-11-12 10:52:41','',''),('1','288',73,'','20','3',376592.00,0.00,'Sales from shift 34 on 2022-11-12 11:01:47 ','2022-11-12 11:01:47','',''),('1','288',74,'','6.1','4',0.00,376592.00,'Sales from shift 34 on 2022-11-12 11:01:47 ','2022-11-12 11:01:47','',''),('1','288',75,'','20','3',260022.60,0.00,'Sales from shift 35 on 2022-11-12 11:11:06 ','2022-11-12 11:11:06','',''),('1','288',76,'','6.1','4',0.00,260022.60,'Sales from shift 35 on 2022-11-12 11:11:06 ','2022-11-12 11:11:06','',''),('1','288',77,'','20','3',251273.10,0.00,'Sales from shift 36 on 2022-11-12 11:55:40 ','2022-11-12 11:55:40','',''),('1','288',78,'','6.1','4',0.00,251273.10,'Sales from shift 36 on 2022-11-12 11:55:40 ','2022-11-12 11:55:40','',''),('1','288',79,'','20','3',206218.80,0.00,'Sales from shift 37 on 2022-11-12 12:01:38 ','2022-11-12 12:01:38','',''),('1','288',80,'','6.1','4',0.00,206218.80,'Sales from shift 37 on 2022-11-12 12:01:38 ','2022-11-12 12:01:38','',''),('1','288',81,'','20','3',1051843.00,0.00,'Sales from shift 38 on 2022-11-12 12:22:08 ','2022-11-12 12:22:08','',''),('1','288',82,'','6.1','4',0.00,1051843.00,'Sales from shift 38 on 2022-11-12 12:22:08 ','2022-11-12 12:22:08','',''),('1','288',83,'','20','3',296868.60,0.00,'Sales from shift 39 on 2022-11-12 12:26:17 ','2022-11-12 12:26:17','',''),('1','288',84,'','6.1','4',0.00,296868.60,'Sales from shift 39 on 2022-11-12 12:26:17 ','2022-11-12 12:26:17','',''),('1','288',85,'','20','3',312521.80,0.00,'Sales from shift 40 on 2022-11-13 06:32:16 ','2022-11-13 06:32:16','',''),('1','288',86,'','6.1','4',0.00,312521.80,'Sales from shift 40 on 2022-11-13 06:32:16 ','2022-11-13 06:32:16','',''),('1','288',87,'','20','3',265856.40,0.00,'Sales from shift 41 on 2022-11-13 08:43:11 ','2022-11-13 08:43:11','',''),('1','288',88,'','6.1','4',0.00,265856.40,'Sales from shift 41 on 2022-11-13 08:43:11 ','2022-11-13 08:43:11','',''),('1','288',89,'','20','3',241005.60,0.00,'Sales from shift 42 on 2022-11-13 08:57:46 ','2022-11-13 08:57:46','',''),('1','288',90,'','6.1','4',0.00,241005.60,'Sales from shift 42 on 2022-11-13 08:57:46 ','2022-11-13 08:57:46','',''),('1','288',91,'','20','3',284486.40,0.00,'Sales from shift 43 on 2022-11-13 09:06:51 ','2022-11-13 09:06:51','',''),('1','288',92,'','6.1','4',0.00,284486.40,'Sales from shift 43 on 2022-11-13 09:06:51 ','2022-11-13 09:06:51','',''),('1','288',93,'','20','3',252202.00,0.00,'Sales from shift 44 on 2022-11-13 09:25:13 ','2022-11-13 09:25:13','',''),('1','288',94,'','6.1','4',0.00,252202.00,'Sales from shift 44 on 2022-11-13 09:25:13 ','2022-11-13 09:25:13','',''),('1','288',95,'','20','3',326379.60,0.00,'Sales from shift 45 on 2022-11-13 09:34:49 ','2022-11-13 09:34:49','',''),('1','288',96,'','6.1','4',0.00,326379.60,'Sales from shift 45 on 2022-11-13 09:34:49 ','2022-11-13 09:34:49','',''),('1','288',97,'','20','3',244548.00,0.00,'Sales from shift 46 on 2022-11-13 09:48:22 ','2022-11-13 09:48:22','',''),('1','288',98,'','6.1','4',0.00,244548.00,'Sales from shift 46 on 2022-11-13 09:48:22 ','2022-11-13 09:48:22','',''),('1','288',99,'','20','3',458994.60,0.00,'Sales from shift 47 on 2022-11-13 10:08:44 ','2022-11-13 10:08:44','',''),('1','288',100,'','6.1','4',0.00,458994.60,'Sales from shift 47 on 2022-11-13 10:08:44 ','2022-11-13 10:08:44','',''),('1','288',101,'','20','3',651809.20,0.00,'Sales from shift 48 on 2022-11-13 11:11:09 ','2022-11-13 11:11:09','',''),('1','288',102,'','6.1','4',0.00,651809.20,'Sales from shift 48 on 2022-11-13 11:11:09 ','2022-11-13 11:11:09','',''),('1','288',103,'','20','3',1819051.20,0.00,'Sales from shift 49 on 2022-11-13 23:11:34 ','2022-11-13 23:11:34','',''),('1','288',104,'','6.1','4',0.00,1819051.20,'Sales from shift 49 on 2022-11-13 23:11:34 ','2022-11-13 23:11:34','',''),('1','288',105,'','20','3',961216.80,0.00,'Sales from shift 50 on 2022-11-14 11:50:51 ','2022-11-14 11:50:51','',''),('1','288',106,'','6.1','4',0.00,961216.80,'Sales from shift 50 on 2022-11-14 11:50:51 ','2022-11-14 11:50:51','',''),('1','288',107,'','20','3',250156.80,0.00,'Sales from shift 51 on 2022-11-14 14:15:00 ','2022-11-14 14:15:00','',''),('1','288',108,'','6.1','4',0.00,250156.80,'Sales from shift 51 on 2022-11-14 14:15:00 ','2022-11-14 14:15:00','',''),('1','288',109,'','20','3',281880.60,0.00,'Sales from shift 52 on 2022-11-15 09:41:24 ','2022-11-15 09:41:24','',''),('1','288',110,'','6.1','4',0.00,281880.60,'Sales from shift 52 on 2022-11-15 09:41:24 ','2022-11-15 09:41:24','',''),('1','288',111,'','24','1',0.00,9000000.00,'Purchase Id 5 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-15 10:26:30','',''),('1','288',112,'','supplier','1',9000000.00,0.00,'Purchase Id 5 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-15 10:26:30','',''),('1','288',113,'','20','3',333549.00,0.00,'Sales from shift 53 on 2022-11-15 11:53:35 ','2022-11-15 11:53:35','',''),('1','288',114,'','6.1','4',0.00,333549.00,'Sales from shift 53 on 2022-11-15 11:53:35 ','2022-11-15 11:53:35','',''),('1','288',115,'','20','3',487626.00,0.00,'Sales from shift 54 on 2022-11-15 12:40:05 ','2022-11-15 12:40:05','',''),('1','288',116,'','6.1','4',0.00,487626.00,'Sales from shift 54 on 2022-11-15 12:40:05 ','2022-11-15 12:40:05','',''),('1','288',117,'','20','3',286324.20,0.00,'Sales from shift 55 on 2022-11-15 21:36:23 ','2022-11-15 21:36:23','',''),('1','288',118,'','6.1','4',0.00,286324.20,'Sales from shift 55 on 2022-11-15 21:36:23 ','2022-11-15 21:36:23','',''),('1','288',119,'','20','3',511861.20,0.00,'Sales from shift 56 on 2022-11-18 06:29:01 ','2022-11-18 06:29:01','',''),('1','288',120,'','6.1','4',0.00,511861.20,'Sales from shift 56 on 2022-11-18 06:29:01 ','2022-11-18 06:29:01','',''),('1','288',121,'','20','3',468252.00,0.00,'Sales from shift 57 on 2022-11-18 09:27:16 ','2022-11-18 09:27:16','',''),('1','288',122,'','6.1','4',0.00,468252.00,'Sales from shift 57 on 2022-11-18 09:27:16 ','2022-11-18 09:27:16','',''),('1','288',123,'','20','3',405060.00,0.00,'Sales from shift 58 on 2022-11-18 09:34:34 ','2022-11-18 09:34:34','',''),('1','288',124,'','6.1','4',0.00,405060.00,'Sales from shift 58 on 2022-11-18 09:34:34 ','2022-11-18 09:34:34','',''),('1','288',125,'','20','3',430756.20,0.00,'Sales from shift 59 on 2022-11-18 09:49:03 ','2022-11-18 09:49:03','',''),('1','288',126,'','6.1','4',0.00,430756.20,'Sales from shift 59 on 2022-11-18 09:49:03 ','2022-11-18 09:49:03','',''),('1','288',127,'','20','3',520897.20,0.00,'Sales from shift 60 on 2022-11-18 09:59:21 ','2022-11-18 09:59:21','',''),('1','288',128,'','6.1','4',0.00,520897.20,'Sales from shift 60 on 2022-11-18 09:59:21 ','2022-11-18 09:59:21','',''),('1','288',129,'','20','3',473650.20,0.00,'Sales from shift 61 on 2022-11-18 10:11:32 ','2022-11-18 10:11:32','',''),('1','288',130,'','6.1','4',0.00,473650.20,'Sales from shift 61 on 2022-11-18 10:11:32 ','2022-11-18 10:11:32','',''),('1','288',131,'','20','3',410183.80,0.00,'Sales from shift 62 on 2022-11-18 10:41:15 ','2022-11-18 10:41:15','',''),('1','288',132,'','6.1','4',0.00,410183.80,'Sales from shift 62 on 2022-11-18 10:41:15 ','2022-11-18 10:41:15','',''),('1','288',133,'','20','3',407072.80,0.00,'Sales from shift 63 on 2022-11-18 10:52:54 ','2022-11-18 10:52:54','',''),('1','288',134,'','6.1','4',0.00,407072.80,'Sales from shift 63 on 2022-11-18 10:52:54 ','2022-11-18 10:52:54','',''),('1','288',135,'','20','3',534994.80,0.00,'Sales from shift 64 on 2022-11-18 13:17:41 ','2022-11-18 13:17:41','',''),('1','288',136,'','6.1','4',0.00,534994.80,'Sales from shift 64 on 2022-11-18 13:17:41 ','2022-11-18 13:17:41','',''),('1','288',137,'','20','3',370902.80,0.00,'Sales from shift 65 on 2022-11-18 15:42:48 ','2022-11-18 15:42:48','',''),('1','288',138,'','6.1','4',0.00,370902.80,'Sales from shift 65 on 2022-11-18 15:42:48 ','2022-11-18 15:42:48','',''),('1','288',139,'','20','3',532491.00,0.00,'Sales from shift 66 on 2022-11-18 16:12:12 ','2022-11-18 16:12:12','',''),('1','288',140,'','6.1','4',0.00,532491.00,'Sales from shift 66 on 2022-11-18 16:12:12 ','2022-11-18 16:12:12','',''),('1','288',141,'','20','3',427194.00,0.00,'Sales from shift 67 on 2022-11-18 16:19:15 ','2022-11-18 16:19:15','',''),('1','288',142,'','6.1','4',0.00,427194.00,'Sales from shift 67 on 2022-11-18 16:19:15 ','2022-11-18 16:19:15','',''),('1','288',143,'','20','3',443119.20,0.00,'Sales from shift 68 on 2022-11-18 16:30:11 ','2022-11-18 16:30:11','',''),('1','288',144,'','6.1','4',0.00,443119.20,'Sales from shift 68 on 2022-11-18 16:30:11 ','2022-11-18 16:30:11','',''),('1','288',145,'','20','3',409296.60,0.00,'Sales from shift 69 on 2022-11-18 16:39:41 ','2022-11-18 16:39:41','',''),('1','288',146,'','6.1','4',0.00,409296.60,'Sales from shift 69 on 2022-11-18 16:39:41 ','2022-11-18 16:39:41','',''),('1','288',147,'','20','3',489195.60,0.00,'Sales from shift 70 on 2022-11-18 16:51:09 ','2022-11-18 16:51:09','',''),('1','288',148,'','6.1','4',0.00,489195.60,'Sales from shift 70 on 2022-11-18 16:51:09 ','2022-11-18 16:51:09','',''),('1','288',149,'','20','3',424929.60,0.00,'Sales from shift 71 on 2022-11-18 16:59:11 ','2022-11-18 16:59:11','',''),('1','288',150,'','6.1','4',0.00,424929.60,'Sales from shift 71 on 2022-11-18 16:59:11 ','2022-11-18 16:59:11','',''),('1','288',151,'','20','3',391221.60,0.00,'Sales from shift 72 on 2022-11-18 17:10:28 ','2022-11-18 17:10:28','',''),('1','288',152,'','6.1','4',0.00,391221.60,'Sales from shift 72 on 2022-11-18 17:10:28 ','2022-11-18 17:10:28','',''),('1','288',153,'','20','3',296204.40,0.00,'Sales from shift 73 on 2022-11-18 17:19:09 ','2022-11-18 17:19:09','',''),('1','288',154,'','6.1','4',0.00,296204.40,'Sales from shift 73 on 2022-11-18 17:19:09 ','2022-11-18 17:19:09','',''),('1','288',155,'','20','3',347884.80,0.00,'Sales from shift 74 on 2022-11-18 17:27:24 ','2022-11-18 17:27:24','',''),('1','288',156,'','6.1','4',0.00,347884.80,'Sales from shift 74 on 2022-11-18 17:27:24 ','2022-11-18 17:27:24','',''),('1','288',157,'','2','6',13000.00,0.00,'Payment Id 2 for invoice:1, receipt: 00 by AA RANO NIGERIA LTD','2022-11-21 10:43:32','',''),('1','288',158,'','supplier','1',0.00,13000.00,'Payment Id 2 for invoice:1, receipt: 00 by AA RANO NIGERIA LTD','2022-11-21 10:43:32','',''),('1','288',159,'','2','5',96250.00,0.00,'Payment Id 1 for invoice:1, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 10:43:32','',''),('1','288',160,'','supplier','1',0.00,96250.00,'Payment Id 1 for invoice:1, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 10:43:32','',''),('1','288',161,'','2','6',49000.00,0.00,'Payment Id 6 for invoice:2, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-21 10:45:39','',''),('1','288',162,'','supplier','1',0.00,49000.00,'Payment Id 6 for invoice:2, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-21 10:45:39','',''),('1','288',163,'','2','5',296910.00,0.00,'Payment Id 5 for invoice:2, receipt: 0 by AA RANO NIGERIA LTD','2022-11-21 10:45:39','',''),('1','288',164,'','supplier','1',0.00,296910.00,'Payment Id 5 for invoice:2, receipt: 0 by AA RANO NIGERIA LTD','2022-11-21 10:45:39','',''),('1','288',165,'','2','6',61500.00,0.00,'Payment Id 12 for invoice:9, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-21 11:03:20','',''),('1','288',166,'','supplier','1',0.00,61500.00,'Payment Id 12 for invoice:9, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-21 11:03:20','',''),('1','288',167,'','2','5',135920.00,0.00,'Payment Id 11 for invoice:9, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 11:03:20','',''),('1','288',168,'','supplier','1',0.00,135920.00,'Payment Id 11 for invoice:9, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 11:03:20','',''),('1','288',169,'','2','5',213435.00,0.00,'Payment Id 10 for invoice:8, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 11:03:20','',''),('1','288',170,'','supplier','1',0.00,213435.00,'Payment Id 10 for invoice:8, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 11:03:20','',''),('1','288',171,'','2','6',65780.00,0.00,'Payment Id 9 for invoice:7, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-21 11:03:20','',''),('1','288',172,'','supplier','1',0.00,65780.00,'Payment Id 9 for invoice:7, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-21 11:03:20','',''),('1','288',173,'','2','5',284250.00,0.00,'Payment Id 8 for invoice:7, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 11:03:20','',''),('1','288',174,'','supplier','1',0.00,284250.00,'Payment Id 8 for invoice:7, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 11:03:20','',''),('1','288',175,'','2','5',282500.00,0.00,'Payment Id 7 for invoice:3, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 11:03:20','',''),('1','288',176,'','supplier','1',0.00,282500.00,'Payment Id 7 for invoice:3, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 11:03:20','',''),('1','288',177,'','2','6',61116.00,0.00,'Payment Id 16 for invoice:10/11, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-21 11:06:40','',''),('1','288',178,'','supplier','1',0.00,61116.00,'Payment Id 16 for invoice:10/11, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-21 11:06:40','',''),('1','288',179,'','2','5',153500.00,0.00,'Payment Id 15 for invoice:11, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 11:06:40','',''),('1','288',180,'','supplier','1',0.00,153500.00,'Payment Id 15 for invoice:11, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 11:06:40','',''),('1','288',181,'','2','5',174160.00,0.00,'Payment Id 14 for invoice:10, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 11:06:40','',''),('1','288',182,'','supplier','1',0.00,174160.00,'Payment Id 14 for invoice:10, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 11:06:40','',''),('1','288',183,'','2','6',71350.00,0.00,'Payment Id 19 for invoice:12/13, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-21 11:14:19','',''),('1','288',184,'','supplier','1',0.00,71350.00,'Payment Id 19 for invoice:12/13, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-21 11:14:19','',''),('1','288',185,'','2','5',136400.00,0.00,'Payment Id 18 for invoice:13, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 11:14:19','',''),('1','288',186,'','supplier','1',0.00,136400.00,'Payment Id 18 for invoice:13, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 11:14:19','',''),('1','288',187,'','2','5',1192300.00,0.00,'Payment Id 17 for invoice:12, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 11:14:19','',''),('1','288',188,'','supplier','1',0.00,1192300.00,'Payment Id 17 for invoice:12, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 11:14:19','',''),('1','288',189,'','2','6',100823.00,0.00,'Payment Id 38 for invoice:24/25, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-21 16:58:32','',''),('1','288',190,'','supplier','1',0.00,100823.00,'Payment Id 38 for invoice:24/25, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-21 16:58:32','',''),('1','288',191,'','2','5',59420.00,0.00,'Payment Id 37 for invoice:25, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 16:58:32','',''),('1','288',192,'','supplier','1',0.00,59420.00,'Payment Id 37 for invoice:25, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 16:58:32','',''),('1','288',193,'','2','5',180040.00,0.00,'Payment Id 36 for invoice:24, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 16:58:32','',''),('1','288',194,'','supplier','1',0.00,180040.00,'Payment Id 36 for invoice:24, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 16:58:32','',''),('1','288',195,'','2','6',67810.00,0.00,'Payment Id 41 for invoice:26/27, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-21 16:59:35','',''),('1','288',196,'','supplier','1',0.00,67810.00,'Payment Id 41 for invoice:26/27, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-21 16:59:35','',''),('1','288',197,'','2','5',170220.00,0.00,'Payment Id 40 for invoice:27, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 16:59:35','',''),('1','288',198,'','supplier','1',0.00,170220.00,'Payment Id 40 for invoice:27, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 16:59:35','',''),('1','288',199,'','2','5',171370.00,0.00,'Payment Id 39 for invoice:26, receipt: E BILLS  by AA RANO NIGERIA LTD','2022-11-21 16:59:35','',''),('1','288',200,'','supplier','1',0.00,171370.00,'Payment Id 39 for invoice:26, receipt: E BILLS  by AA RANO NIGERIA LTD','2022-11-21 16:59:35','',''),('1','288',201,'','2','6',126462.75,0.00,'Payment Id 44 for invoice:28/29, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-21 17:01:02','',''),('1','288',202,'','supplier','1',0.00,126462.75,'Payment Id 44 for invoice:28/29, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-21 17:01:02','',''),('1','288',203,'','2','5',180070.00,0.00,'Payment Id 43 for invoice:29, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 17:01:02','',''),('1','288',204,'','supplier','1',0.00,180070.00,'Payment Id 43 for invoice:29, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 17:01:02','',''),('1','288',205,'','2','5',130960.00,0.00,'Payment Id 42 for invoice:28, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 17:01:02','',''),('1','288',206,'','supplier','1',0.00,130960.00,'Payment Id 42 for invoice:28, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 17:01:02','',''),('1','288',207,'','2','6',64300.00,0.00,'Payment Id 47 for invoice:29/30, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-21 17:02:16','',''),('1','288',208,'','supplier','1',0.00,64300.00,'Payment Id 47 for invoice:29/30, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-21 17:02:16','',''),('1','288',209,'','2','5',173675.00,0.00,'Payment Id 46 for invoice:31, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 17:02:16','',''),('1','288',210,'','supplier','1',0.00,173675.00,'Payment Id 46 for invoice:31, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 17:02:16','',''),('1','288',211,'','2','5',129335.00,0.00,'Payment Id 45 for invoice:30, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 17:02:16','',''),('1','288',212,'','supplier','1',0.00,129335.00,'Payment Id 45 for invoice:30, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 17:02:16','',''),('1','288',213,'','2','6',98940.00,0.00,'Payment Id 50 for invoice:32/33, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-21 17:03:43','',''),('1','288',214,'','supplier','1',0.00,98940.00,'Payment Id 50 for invoice:32/33, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-21 17:03:43','',''),('1','288',215,'','2','5',166150.00,0.00,'Payment Id 49 for invoice:33, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 17:03:43','',''),('1','288',216,'','supplier','1',0.00,166150.00,'Payment Id 49 for invoice:33, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 17:03:43','',''),('1','288',217,'','2','5',176455.00,0.00,'Payment Id 48 for invoice:32, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 17:03:43','',''),('1','288',218,'','supplier','1',0.00,176455.00,'Payment Id 48 for invoice:32, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-21 17:03:43','',''),('1','288',219,'','2','6',103966.00,0.00,'Payment Id 53 for invoice:34/35, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-21 17:06:10','',''),('1','288',220,'','supplier','1',0.00,103966.00,'Payment Id 53 for invoice:34/35, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-21 17:06:10','',''),('1','288',221,'','2','5',235700.00,0.00,'Payment Id 51 for invoice:34, receipt: 0567375 by AA RANO NIGERIA LTD','2022-11-21 17:06:10','',''),('1','288',222,'','supplier','1',0.00,235700.00,'Payment Id 51 for invoice:34, receipt: 0567375 by AA RANO NIGERIA LTD','2022-11-21 17:06:10','',''),('1','288',223,'','2','6',87870.00,0.00,'Payment Id 56 for invoice:36/37, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-21 17:09:27','',''),('1','288',224,'','supplier','1',0.00,87870.00,'Payment Id 56 for invoice:36/37, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-21 17:09:27','',''),('1','288',225,'','2','5',157450.00,0.00,'Payment Id 55 for invoice:37, receipt: 0449090 by AA RANO NIGERIA LTD','2022-11-21 17:09:27','',''),('1','288',226,'','supplier','1',0.00,157450.00,'Payment Id 55 for invoice:37, receipt: 0449090 by AA RANO NIGERIA LTD','2022-11-21 17:09:27','',''),('1','288',227,'','2','5',165250.00,0.00,'Payment Id 54 for invoice:36, receipt: 0449088 by AA RANO NIGERIA LTD','2022-11-21 17:09:27','',''),('1','288',228,'','supplier','1',0.00,165250.00,'Payment Id 54 for invoice:36, receipt: 0449088 by AA RANO NIGERIA LTD','2022-11-21 17:09:27','',''),('1','288',229,'','2','6',98817.00,0.00,'Payment Id 59 for invoice:38/39, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-21 17:12:25','',''),('1','288',230,'','supplier','1',0.00,98817.00,'Payment Id 59 for invoice:38/39, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-21 17:12:25','',''),('1','288',231,'','2','5',214425.00,0.00,'Payment Id 58 for invoice:39, receipt: 0567375 by AA RANO NIGERIA LTD','2022-11-21 17:12:25','',''),('1','288',232,'','supplier','1',0.00,214425.00,'Payment Id 58 for invoice:39, receipt: 0567375 by AA RANO NIGERIA LTD','2022-11-21 17:12:25','',''),('1','288',233,'','2','5',988050.00,0.00,'Payment Id 57 for invoice:38, receipt: 0567380 by AA RANO NIGERIA LTD','2022-11-21 17:12:25','',''),('1','288',234,'','supplier','1',0.00,988050.00,'Payment Id 57 for invoice:38, receipt: 0567380 by AA RANO NIGERIA LTD','2022-11-21 17:12:25','',''),('1','288',235,'','2','5',183660.00,0.00,'Payment Id 20 for invoice:14, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 12:36:21','',''),('1','288',236,'','supplier','1',0.00,183660.00,'Payment Id 20 for invoice:14, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 12:36:21','',''),('1','288',237,'','2','6',72600.00,0.00,'Payment Id 22 for invoice:14/15, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 12:46:50','',''),('1','288',238,'','supplier','1',0.00,72600.00,'Payment Id 22 for invoice:14/15, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 12:46:50','',''),('1','288',239,'','2','5',192930.00,0.00,'Payment Id 21 for invoice:15, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 12:46:50','',''),('1','288',240,'','supplier','1',0.00,192930.00,'Payment Id 21 for invoice:15, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 12:46:50','',''),('1','288',241,'','2','6',42190.00,0.00,'Payment Id 25 for invoice:16, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 12:50:02','',''),('1','288',242,'','supplier','1',0.00,42190.00,'Payment Id 25 for invoice:16, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 12:50:02','',''),('1','288',243,'','2','5',114285.00,0.00,'Payment Id 24 for invoice:17, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 12:50:02','',''),('1','288',244,'','supplier','1',0.00,114285.00,'Payment Id 24 for invoice:17, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 12:50:02','',''),('1','288',245,'','2','5',1996700.00,0.00,'Payment Id 23 for invoice:16, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 12:50:02','',''),('1','288',246,'','supplier','1',0.00,1996700.00,'Payment Id 23 for invoice:16, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 12:50:02','',''),('1','288',247,'','2','6',41624.00,0.00,'Payment Id 27 for invoice:18, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 12:51:52','',''),('1','288',248,'','supplier','1',0.00,41624.00,'Payment Id 27 for invoice:18, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 12:51:52','',''),('1','288',249,'','2','5',47750.00,0.00,'Payment Id 26 for invoice:18, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 12:51:52','',''),('1','288',250,'','supplier','1',0.00,47750.00,'Payment Id 26 for invoice:18, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 12:51:52','',''),('1','288',251,'','2','6',89920.00,0.00,'Payment Id 32 for invoice:20/21, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 13:29:38','',''),('1','288',252,'','supplier','1',0.00,89920.00,'Payment Id 32 for invoice:20/21, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 13:29:38','',''),('1','288',253,'','2','5',146300.00,0.00,'Payment Id 31 for invoice:21, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 13:29:38','',''),('1','288',254,'','supplier','1',0.00,146300.00,'Payment Id 31 for invoice:21, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 13:29:38','',''),('1','288',255,'','2','5',202475.00,0.00,'Payment Id 30 for invoice:20, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 13:29:38','',''),('1','288',256,'','supplier','1',0.00,202475.00,'Payment Id 30 for invoice:20, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 13:29:38','',''),('1','288',257,'','2','6',59500.00,0.00,'Payment Id 35 for invoice:22/23, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 13:33:02','',''),('1','288',258,'','supplier','1',0.00,59500.00,'Payment Id 35 for invoice:22/23, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 13:33:02','',''),('1','288',259,'','2','5',117600.00,0.00,'Payment Id 34 for invoice:23, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 13:33:02','',''),('1','288',260,'','supplier','1',0.00,117600.00,'Payment Id 34 for invoice:23, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 13:33:02','',''),('1','288',261,'','2','5',58930.00,0.00,'Payment Id 33 for invoice:22, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 13:33:02','',''),('1','288',262,'','supplier','1',0.00,58930.00,'Payment Id 33 for invoice:22, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 13:33:02','',''),('1','288',263,'','2','6',32804.00,0.00,'Payment Id 29 for invoice:19, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 13:34:41','',''),('1','288',264,'','supplier','1',0.00,32804.00,'Payment Id 29 for invoice:19, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 13:34:41','',''),('1','288',265,'','2','5',160700.00,0.00,'Payment Id 28 for invoice:19, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 13:34:41','',''),('1','288',266,'','supplier','1',0.00,160700.00,'Payment Id 28 for invoice:19, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 13:34:41','',''),('1','288',267,'','2','6',136039.56,0.00,'Payment Id 65 for invoice:42/43, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 13:48:24','',''),('1','288',268,'','supplier','1',0.00,136039.56,'Payment Id 65 for invoice:42/43, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 13:48:24','',''),('1','288',269,'','2','5',213950.00,0.00,'Payment Id 64 for invoice:43, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 13:48:24','',''),('1','288',270,'','supplier','1',0.00,213950.00,'Payment Id 64 for invoice:43, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 13:48:24','',''),('1','288',271,'','2','5',175505.00,0.00,'Payment Id 63 for invoice:42, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 13:48:24','',''),('1','288',272,'','supplier','1',0.00,175505.00,'Payment Id 63 for invoice:42, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 13:48:24','',''),('1','288',273,'','2','6',138100.00,0.00,'Payment Id 62 for invoice:40/41, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 13:48:24','',''),('1','288',274,'','supplier','1',0.00,138100.00,'Payment Id 62 for invoice:40/41, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 13:48:24','',''),('1','288',275,'','2','5',196760.00,0.00,'Payment Id 61 for invoice:41, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 13:48:24','',''),('1','288',276,'','supplier','1',0.00,196760.00,'Payment Id 61 for invoice:41, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 13:48:24','',''),('1','288',277,'','2','5',196900.00,0.00,'Payment Id 52 for invoice:35, receipt: 0567376 by AA RANO NIGERIA LTD','2022-11-22 13:53:12','',''),('1','288',278,'','supplier','1',0.00,196900.00,'Payment Id 52 for invoice:35, receipt: 0567376 by AA RANO NIGERIA LTD','2022-11-22 13:53:12','',''),('1','288',279,'','2','6',94300.00,0.00,'Payment Id 68 for invoice:44/45, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 13:55:18','',''),('1','288',280,'','supplier','1',0.00,94300.00,'Payment Id 68 for invoice:44/45, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 13:55:18','',''),('1','288',281,'','2','5',288080.00,0.00,'Payment Id 67 for invoice:45, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 13:55:18','',''),('1','288',282,'','supplier','1',0.00,288080.00,'Payment Id 67 for invoice:45, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 13:55:18','',''),('1','288',283,'','2','5',156205.00,0.00,'Payment Id 66 for invoice:44, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 13:55:18','',''),('1','288',284,'','supplier','1',0.00,156205.00,'Payment Id 66 for invoice:44, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 13:55:18','',''),('1','288',285,'','2','6',591375.00,0.00,'Payment Id 74 for invoice:48/49, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 13:56:21','',''),('1','288',286,'','supplier','1',0.00,591375.00,'Payment Id 74 for invoice:48/49, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 13:56:21','',''),('1','288',287,'','2','5',1298380.00,0.00,'Payment Id 73 for invoice:49, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 13:56:21','',''),('1','288',288,'','supplier','1',0.00,1298380.00,'Payment Id 73 for invoice:49, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 13:56:21','',''),('1','288',289,'','2','5',175600.00,0.00,'Payment Id 71 for invoice:46/47, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 13:56:21','',''),('1','288',290,'','supplier','1',0.00,175600.00,'Payment Id 71 for invoice:46/47, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 13:56:21','',''),('1','288',291,'','2','5',333400.00,0.00,'Payment Id 70 for invoice:47, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 13:56:21','',''),('1','288',292,'','supplier','1',0.00,333400.00,'Payment Id 70 for invoice:47, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 13:56:21','',''),('1','288',293,'','2','5',194550.00,0.00,'Payment Id 69 for invoice:46, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 13:56:21','',''),('1','288',294,'','supplier','1',0.00,194550.00,'Payment Id 69 for invoice:46, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 13:56:21','',''),('1','288',295,'','2','5',533110.00,0.00,'Payment Id 72 for invoice:48, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 13:57:12','',''),('1','288',296,'','supplier','1',0.00,533110.00,'Payment Id 72 for invoice:48, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 13:57:12','',''),('1','288',297,'','2','5',87420.00,0.00,'Payment Id 78 for invoice:52, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:02:02','',''),('1','288',298,'','supplier','1',0.00,87420.00,'Payment Id 78 for invoice:52, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:02:02','',''),('1','288',299,'','2','6',223375.00,0.00,'Payment Id 77 for invoice:50/51, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 14:02:02','',''),('1','288',300,'','supplier','1',0.00,223375.00,'Payment Id 77 for invoice:50/51, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 14:02:02','',''),('1','288',301,'','2','5',209250.00,0.00,'Payment Id 76 for invoice:51, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:02:02','',''),('1','288',302,'','supplier','1',0.00,209250.00,'Payment Id 76 for invoice:51, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:02:02','',''),('1','288',303,'','2','5',746341.00,0.00,'Payment Id 75 for invoice:50, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:02:02','',''),('1','288',304,'','supplier','1',0.00,746341.00,'Payment Id 75 for invoice:50, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:02:02','',''),('1','288',305,'','2','6',278483.00,0.00,'Payment Id 91 for invoice:58/59, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 14:13:01','',''),('1','288',306,'','supplier','1',0.00,278483.00,'Payment Id 91 for invoice:58/59, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 14:13:01','',''),('1','288',307,'','2','5',242270.00,0.00,'Payment Id 90 for invoice:59, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:13:01','',''),('1','288',308,'','supplier','1',0.00,242270.00,'Payment Id 90 for invoice:59, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:13:01','',''),('1','288',309,'','2','5',286360.00,0.00,'Payment Id 89 for invoice:58, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:13:01','',''),('1','288',310,'','supplier','1',0.00,286360.00,'Payment Id 89 for invoice:58, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:13:01','',''),('1','288',311,'','2','6',152231.00,0.00,'Payment Id 87 for invoice:56/57, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 14:13:01','',''),('1','288',312,'','supplier','1',0.00,152231.00,'Payment Id 87 for invoice:56/57, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 14:13:01','',''),('1','288',313,'','2','5',391660.00,0.00,'Payment Id 86 for invoice:57, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:13:01','',''),('1','288',314,'','supplier','1',0.00,391660.00,'Payment Id 86 for invoice:57, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:13:01','',''),('1','288',315,'','2','5',407230.00,0.00,'Payment Id 85 for invoice:56, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:13:01','',''),('1','288',316,'','supplier','1',0.00,407230.00,'Payment Id 85 for invoice:56, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:13:01','',''),('1','288',317,'','2','6',138560.00,0.00,'Payment Id 84 for invoice:54/55, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 14:13:01','',''),('1','288',318,'','supplier','1',0.00,138560.00,'Payment Id 84 for invoice:54/55, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 14:13:01','',''),('1','288',319,'','2','5',374460.00,0.00,'Payment Id 82 for invoice:54, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:13:01','',''),('1','288',320,'','supplier','1',0.00,374460.00,'Payment Id 82 for invoice:54, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:13:01','',''),('1','288',321,'','2','6',169274.00,0.00,'Payment Id 98 for invoice:62/63, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 14:15:51','',''),('1','288',322,'','supplier','1',0.00,169274.00,'Payment Id 98 for invoice:62/63, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 14:15:51','',''),('1','288',323,'','2','5',320998.00,0.00,'Payment Id 97 for invoice:63, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:15:51','',''),('1','288',324,'','supplier','1',0.00,320998.00,'Payment Id 97 for invoice:63, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:15:51','',''),('1','288',325,'','2','6',245396.00,0.00,'Payment Id 94 for invoice:60/61, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 14:15:51','',''),('1','288',326,'','supplier','1',0.00,245396.00,'Payment Id 94 for invoice:60/61, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 14:15:51','',''),('1','288',327,'','2','5',379350.00,0.00,'Payment Id 93 for invoice:61, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:15:51','',''),('1','288',328,'','supplier','1',0.00,379350.00,'Payment Id 93 for invoice:61, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:15:51','',''),('1','288',329,'','2','5',317740.00,0.00,'Payment Id 92 for invoice:60, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:15:51','',''),('1','288',330,'','supplier','1',0.00,317740.00,'Payment Id 92 for invoice:60, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:15:51','',''),('1','288',331,'','2','6',91820.00,0.00,'Payment Id 80 for invoice:52/53, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 14:17:29','',''),('1','288',332,'','supplier','1',0.00,91820.00,'Payment Id 80 for invoice:52/53, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 14:17:29','',''),('1','288',333,'','2','5',282200.00,0.00,'Payment Id 79 for invoice:53, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:17:29','',''),('1','288',334,'','supplier','1',0.00,282200.00,'Payment Id 79 for invoice:53, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:17:29','',''),('1','288',335,'','2','5',302991.00,0.00,'Payment Id 96 for invoice:62, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:19:06','',''),('1','288',336,'','supplier','1',0.00,302991.00,'Payment Id 96 for invoice:62, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:19:06','',''),('1','288',337,'','2','5',286119.00,0.00,'Payment Id 105 for invoice:68, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:20:25','',''),('1','288',338,'','supplier','1',0.00,286119.00,'Payment Id 105 for invoice:68, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:20:25','',''),('1','288',339,'','2','6',238615.00,0.00,'Payment Id 104 for invoice:66/67, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 14:20:25','',''),('1','288',340,'','supplier','1',0.00,238615.00,'Payment Id 104 for invoice:66/67, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 14:20:25','',''),('1','288',341,'','2','5',327779.00,0.00,'Payment Id 103 for invoice:67, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:20:25','',''),('1','288',342,'','supplier','1',0.00,327779.00,'Payment Id 103 for invoice:67, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:20:25','',''),('1','288',343,'','2','5',369291.00,0.00,'Payment Id 102 for invoice:66, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:20:25','',''),('1','288',344,'','supplier','1',0.00,369291.00,'Payment Id 102 for invoice:66, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:20:25','',''),('1','288',345,'','2','6',175328.00,0.00,'Payment Id 101 for invoice:64/65, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 14:20:25','',''),('1','288',346,'','supplier','1',0.00,175328.00,'Payment Id 101 for invoice:64/65, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 14:20:25','',''),('1','288',347,'','2','5',306815.00,0.00,'Payment Id 100 for invoice:65, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:20:25','',''),('1','288',348,'','supplier','1',0.00,306815.00,'Payment Id 100 for invoice:65, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:20:25','',''),('1','288',349,'','2','5',399730.00,0.00,'Payment Id 99 for invoice:64, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:20:25','',''),('1','288',350,'','supplier','1',0.00,399730.00,'Payment Id 99 for invoice:64, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:20:25','',''),('1','288',351,'','2','6',201770.00,0.00,'Payment Id 107 for invoice:68/69, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 14:22:04','',''),('1','288',352,'','supplier','1',0.00,201770.00,'Payment Id 107 for invoice:68/69, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 14:22:04','',''),('1','288',353,'','2','5',340526.00,0.00,'Payment Id 106 for invoice:69, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:22:04','',''),('1','288',354,'','supplier','1',0.00,340526.00,'Payment Id 106 for invoice:69, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:22:04','',''),('1','288',355,'','2','6',212282.00,0.00,'Payment Id 110 for invoice:70/71, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 14:22:37','',''),('1','288',356,'','supplier','1',0.00,212282.00,'Payment Id 110 for invoice:70/71, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 14:22:37','',''),('1','288',357,'','2','5',338197.00,0.00,'Payment Id 109 for invoice:71, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:22:37','',''),('1','288',358,'','supplier','1',0.00,338197.00,'Payment Id 109 for invoice:71, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:22:37','',''),('1','288',359,'','2','5',339645.00,0.00,'Payment Id 108 for invoice:70, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:22:37','',''),('1','288',360,'','supplier','1',0.00,339645.00,'Payment Id 108 for invoice:70, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:22:37','',''),('1','288',361,'','2','6',305249.00,0.00,'Payment Id 115 for invoice:74, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 14:23:28','',''),('1','288',362,'','supplier','1',0.00,305249.00,'Payment Id 115 for invoice:74, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 14:23:28','',''),('1','288',363,'','2','5',18635.00,0.00,'Payment Id 114 for invoice:74, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:23:29','',''),('1','288',364,'','supplier','1',0.00,18635.00,'Payment Id 114 for invoice:74, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:23:29','',''),('1','288',365,'','2','6',189160.00,0.00,'Payment Id 113 for invoice:72/73, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 14:23:29','',''),('1','288',366,'','supplier','1',0.00,189160.00,'Payment Id 113 for invoice:72/73, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-22 14:23:29','',''),('1','288',367,'','2','5',233205.00,0.00,'Payment Id 112 for invoice:73, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:23:29','',''),('1','288',368,'','supplier','1',0.00,233205.00,'Payment Id 112 for invoice:73, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:23:29','',''),('1','288',369,'','2','5',239065.00,0.00,'Payment Id 111 for invoice:72, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:23:29','',''),('1','288',370,'','supplier','1',0.00,239065.00,'Payment Id 111 for invoice:72, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 14:23:29','',''),('1','288',371,'','2','5',210905.00,0.00,'Payment Id 60 for invoice:40, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 15:02:33','',''),('1','288',372,'','supplier','1',0.00,210905.00,'Payment Id 60 for invoice:40, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-22 15:02:33','',''),('1','288',373,'','24','1',0.00,12600000.00,'Purchase Id 6 for 60,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-24 04:45:14','',''),('1','288',374,'','supplier','1',12600000.00,0.00,'Purchase Id 6 for 60,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-24 04:45:14','',''),('1','288',375,'','20','3',40000.00,0.00,'Sales from shift 75 on 2022-11-24 23:28:19 ','2022-11-24 23:28:19','',''),('1','288',376,'','6.1','4',0.00,40000.00,'Sales from shift 75 on 2022-11-24 23:28:19 ','2022-11-24 23:28:19','',''),('1','288',377,'','2','5',40000.00,0.00,'Payment Id 116 for invoice:75, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-25 12:18:14','',''),('1','288',378,'','supplier','1',0.00,40000.00,'Payment Id 116 for invoice:75, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-25 12:18:14','',''),('1','288',379,'','customer','1',0.00,8250000.00,'Credit Sales for 10,000.00 Litres of Diesel from shift 76 on 2022-11-25 17:36:17 ','2022-11-25 17:36:17','',''),('1','288',380,'','20','3',8250000.00,0.00,'Sales from shift 76 on 2022-11-25 17:36:17 ','2022-11-25 17:36:17','',''),('1','288',381,'','6.1','4',0.00,0.00,'Sales from shift 76 on 2022-11-25 17:36:17 ','2022-11-25 17:36:17','',''),('1','288',382,'','20','3',9075.00,0.00,'Sales from shift 77 on 2022-11-26 09:51:54 ','2022-11-26 09:51:54','',''),('1','288',383,'','6.1','4',0.00,9075.00,'Sales from shift 77 on 2022-11-26 09:51:54 ','2022-11-26 09:51:54','',''),('1','288',384,'','20','3',158974.20,0.00,'Sales from shift 78 on 2022-11-27 09:22:53 ','2022-11-27 09:22:53','',''),('1','288',385,'','6.1','4',0.00,158974.20,'Sales from shift 78 on 2022-11-27 09:22:53 ','2022-11-27 09:22:53','',''),('1','288',386,'','20','3',215054.70,0.00,'Sales from shift 79 on 2022-11-27 14:33:49 ','2022-11-27 14:33:49','',''),('1','288',387,'','6.1','4',0.00,215054.70,'Sales from shift 79 on 2022-11-27 14:33:49 ','2022-11-27 14:33:49','',''),('1','288',388,'','20','3',616308.00,0.00,'Sales from shift 80 on 2022-11-28 12:08:55 ','2022-11-28 12:08:55','',''),('1','288',389,'','6.1','4',0.00,616308.00,'Sales from shift 80 on 2022-11-28 12:08:55 ','2022-11-28 12:08:55','',''),('1','288',390,'','20','3',340783.80,0.00,'Sales from shift 81 on 2022-11-28 13:58:10 ','2022-11-28 13:58:10','',''),('1','288',391,'','6.1','4',0.00,340783.80,'Sales from shift 81 on 2022-11-28 13:58:10 ','2022-11-28 13:58:10','',''),('1','288',392,'','20','3',338778.30,0.00,'Sales from shift 82 on 2022-11-28 14:10:37 ','2022-11-28 14:10:37','',''),('1','288',393,'','6.1','4',0.00,338778.30,'Sales from shift 82 on 2022-11-28 14:10:37 ','2022-11-28 14:10:37','',''),('1','288',394,'','20','3',853927.20,0.00,'Sales from shift 83 on 2022-11-28 14:42:29 ','2022-11-28 14:42:29','',''),('1','288',395,'','6.1','4',0.00,853927.20,'Sales from shift 83 on 2022-11-28 14:42:29 ','2022-11-28 14:42:29','',''),('1','288',396,'','20','3',574975.80,0.00,'Sales from shift 84 on 2022-11-29 11:18:29 ','2022-11-29 11:18:29','',''),('1','288',397,'','6.1','4',0.00,574975.80,'Sales from shift 84 on 2022-11-29 11:18:29 ','2022-11-29 11:18:29','',''),('1','288',398,'','6.1','4',34400.00,0.00,'Payment Id 120 for invoice:78, receipt: CREDIT NOTE by AA RANO NIGERIA LTD','2022-11-29 15:05:18','',''),('1','288',399,'','supplier','1',0.00,34400.00,'Payment Id 120 for invoice:78, receipt: CREDIT NOTE by AA RANO NIGERIA LTD','2022-11-29 15:05:18','',''),('1','288',400,'','2','5',63475.00,0.00,'Payment Id 119 for invoice:78, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-29 15:05:18','',''),('1','288',401,'','supplier','1',0.00,63475.00,'Payment Id 119 for invoice:78, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-29 15:05:18','',''),('1','288',402,'','6.1','4',8250000.00,0.00,'Payment Id 117 for invoice:76, receipt: CREDIT NOTE by AA RANO NIGERIA LTD','2022-11-29 15:05:18','',''),('1','288',403,'','supplier','1',0.00,8250000.00,'Payment Id 117 for invoice:76, receipt: CREDIT NOTE by AA RANO NIGERIA LTD','2022-11-29 15:05:18','',''),('1','288',404,'','6.1','4',34400.00,0.00,'Payment Id 121 for invoice:78, receipt: CREDIT NOTE by AA RANO NIGERIA LTD','2022-11-29 15:05:31','',''),('1','288',405,'','supplier','1',0.00,34400.00,'Payment Id 121 for invoice:78, receipt: CREDIT NOTE by AA RANO NIGERIA LTD','2022-11-29 15:05:31','',''),('1','288',406,'','2','5',161900.00,0.00,'Payment Id 122 for invoice:79, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-29 15:08:18','',''),('1','288',407,'','supplier','1',0.00,161900.00,'Payment Id 122 for invoice:79, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-29 15:08:18','',''),('1','288',408,'','2','5',296130.00,0.00,'Payment Id 125 for invoice:81, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-29 15:12:43','',''),('1','288',409,'','supplier','1',0.00,296130.00,'Payment Id 125 for invoice:81, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-29 15:12:43','',''),('1','288',410,'','2','5',458010.00,0.00,'Payment Id 124 for invoice:80, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-29 15:12:43','',''),('1','288',411,'','supplier','1',0.00,458010.00,'Payment Id 124 for invoice:80, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-29 15:12:43','',''),('1','288',412,'','6.1','4',80000.00,0.00,'Payment Id 130 for invoice:83, receipt: CREDIT NOTE by AA RANO NIGERIA LTD','2022-11-29 15:18:12','',''),('1','288',413,'','supplier','1',0.00,80000.00,'Payment Id 130 for invoice:83, receipt: CREDIT NOTE by AA RANO NIGERIA LTD','2022-11-29 15:18:12','',''),('1','288',414,'','2','5',393860.00,0.00,'Payment Id 128 for invoice:83, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-29 15:18:12','',''),('1','288',415,'','supplier','1',0.00,393860.00,'Payment Id 128 for invoice:83, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-29 15:18:12','',''),('1','288',416,'','2','5',281300.00,0.00,'Payment Id 127 for invoice:82, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-29 15:18:12','',''),('1','288',417,'','supplier','1',0.00,281300.00,'Payment Id 127 for invoice:82, receipt: E BILLS by AA RANO NIGERIA LTD','2022-11-29 15:18:12','',''),('1','288',418,'','6.1','4',28000.00,0.00,'Payment Id 95 for invoice:061, receipt: 061 by AA RANO NIGERIA LTD','2022-11-29 15:19:25','',''),('1','288',419,'','supplier','1',0.00,28000.00,'Payment Id 95 for invoice:061, receipt: 061 by AA RANO NIGERIA LTD','2022-11-29 15:19:25','',''),('1','288',420,'','6.1','4',5000.00,0.00,'Payment Id 88 for invoice:58, receipt: 058 by AA RANO NIGERIA LTD','2022-11-29 15:19:25','',''),('1','288',421,'','supplier','1',0.00,5000.00,'Payment Id 88 for invoice:58, receipt: 058 by AA RANO NIGERIA LTD','2022-11-29 15:19:25','',''),('1','288',422,'','20','3',436033.50,0.00,'Sales from shift 85 on 2022-11-29 16:54:56 ','2022-11-29 16:54:56','',''),('1','288',423,'','6.1','4',0.00,436033.50,'Sales from shift 85 on 2022-11-29 16:54:56 ','2022-11-29 16:54:56','',''),('1','288',424,'','20','3',651966.00,0.00,'Sales from shift 86 on 2022-11-30 11:32:32 ','2022-11-30 11:32:32','',''),('1','288',425,'','6.1','4',0.00,651966.00,'Sales from shift 86 on 2022-11-30 11:32:32 ','2022-11-30 11:32:32','',''),('1','288',426,'','2','6',336770.30,0.00,'Payment Id 129 for invoice:83, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-30 17:07:02','',''),('1','288',427,'','supplier','1',0.00,336770.30,'Payment Id 129 for invoice:83, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-30 17:07:02','',''),('1','288',428,'','2','6',171500.00,0.00,'Payment Id 126 for invoice:81, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-30 17:07:02','',''),('1','288',429,'','supplier','1',0.00,171500.00,'Payment Id 126 for invoice:81, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-30 17:07:02','',''),('1','288',430,'','2','6',23800.00,0.00,'Payment Id 123 for invoice:79, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-30 17:07:02','',''),('1','288',431,'','supplier','1',0.00,23800.00,'Payment Id 123 for invoice:79, receipt: P.o.s by AA RANO NIGERIA LTD','2022-11-30 17:07:02','',''),('1','288',432,'','20','3',611442.30,0.00,'Sales from shift 87 on 2022-12-01 07:48:40 ','2022-12-01 07:48:40','',''),('1','288',433,'','6.1','4',0.00,611442.30,'Sales from shift 87 on 2022-12-01 07:48:40 ','2022-12-01 07:48:40','',''),('1','288',434,'','20','3',848261.40,0.00,'Sales from shift 88 on 2022-12-01 14:56:27 ','2022-12-01 14:56:27','',''),('1','288',435,'','6.1','4',0.00,848261.40,'Sales from shift 88 on 2022-12-01 14:56:27 ','2022-12-01 14:56:27','',''),('1','288',436,'','20','3',648062.10,0.00,'Sales from shift 89 on 2022-12-01 15:11:40 ','2022-12-01 15:11:40','',''),('1','288',437,'','6.1','4',0.00,648062.10,'Sales from shift 89 on 2022-12-01 15:11:40 ','2022-12-01 15:11:40','',''),('1','288',438,'','20','3',952228.20,0.00,'Sales from shift 90 on 2022-12-02 10:25:05 ','2022-12-02 10:25:05','',''),('1','288',439,'','6.1','4',0.00,952228.20,'Sales from shift 90 on 2022-12-02 10:25:05 ','2022-12-02 10:25:05','',''),('1','288',440,'','2','6',114600.00,0.00,'Payment Id 133 for invoice:84/85, receipt: 85 by AA RANO NIGERIA LTD','2022-12-02 12:16:34','',''),('1','288',441,'','supplier','1',0.00,114600.00,'Payment Id 133 for invoice:84/85, receipt: 85 by AA RANO NIGERIA LTD','2022-12-02 12:16:34','',''),('1','288',442,'','2','5',406035.00,0.00,'Payment Id 132 for invoice:85, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-02 12:16:35','',''),('1','288',443,'','supplier','1',0.00,406035.00,'Payment Id 132 for invoice:85, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-02 12:16:35','',''),('1','288',444,'','2','5',488375.00,0.00,'Payment Id 131 for invoice:84, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-02 12:16:35','',''),('1','288',445,'','supplier','1',0.00,488375.00,'Payment Id 131 for invoice:84, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-02 12:16:35','',''),('1','288',446,'','20','3',661626.00,0.00,'Sales from shift 91 on 2022-12-02 12:20:38 ','2022-12-02 12:20:38','',''),('1','288',447,'','6.1','4',0.00,661626.00,'Sales from shift 91 on 2022-12-02 12:20:38 ','2022-12-02 12:20:38','',''),('1','288',448,'','2','6',183312.00,0.00,'Payment Id 136 for invoice:86/87, receipt: P.o.s by AA RANO NIGERIA LTD','2022-12-02 12:23:34','',''),('1','288',449,'','supplier','1',0.00,183312.00,'Payment Id 136 for invoice:86/87, receipt: P.o.s by AA RANO NIGERIA LTD','2022-12-02 12:23:34','',''),('1','288',450,'','2','5',566920.00,0.00,'Payment Id 135 for invoice:87, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-02 12:23:34','',''),('1','288',451,'','supplier','1',0.00,566920.00,'Payment Id 135 for invoice:87, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-02 12:23:34','',''),('1','288',452,'','2','5',502780.00,0.00,'Payment Id 134 for invoice:86, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-02 12:23:34','',''),('1','288',453,'','supplier','1',0.00,502780.00,'Payment Id 134 for invoice:86, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-02 12:23:34','',''),('1','288',454,'','2','6',160101.00,0.00,'Payment Id 139 for invoice:88/89, receipt: P.o.s by AA RANO NIGERIA LTD','2022-12-02 12:24:20','',''),('1','288',455,'','supplier','1',0.00,160101.00,'Payment Id 139 for invoice:88/89, receipt: P.o.s by AA RANO NIGERIA LTD','2022-12-02 12:24:20','',''),('1','288',456,'','2','5',594030.00,0.00,'Payment Id 138 for invoice:89, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-02 12:24:20','',''),('1','288',457,'','supplier','1',0.00,594030.00,'Payment Id 138 for invoice:89, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-02 12:24:20','',''),('1','288',458,'','2','5',740190.00,0.00,'Payment Id 137 for invoice:88, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-02 12:24:20','',''),('1','288',459,'','supplier','1',0.00,740190.00,'Payment Id 137 for invoice:88, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-02 12:24:20','',''),('1','288',460,'','2','5',9100.00,0.00,'Payment Id 118 for invoice:77, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-02 12:48:32','',''),('1','288',461,'','supplier','1',0.00,9100.00,'Payment Id 118 for invoice:77, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-02 12:48:32','',''),('1','288',462,'','2','5',234230.00,0.00,'Payment Id 83 for invoice:55, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-02 12:48:32','',''),('1','288',463,'','supplier','1',0.00,234230.00,'Payment Id 83 for invoice:55, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-02 12:48:32','',''),('1','288',464,'','20','3',1095129.00,0.00,'Sales from shift 92 on 2022-12-03 06:11:41 ','2022-12-03 06:11:41','',''),('1','288',465,'','6.1','4',0.00,1095129.00,'Sales from shift 92 on 2022-12-03 06:11:41 ','2022-12-03 06:11:41','',''),('1','288',466,'','20','3',1024932.30,0.00,'Sales from shift 93 on 2022-12-04 12:10:22 ','2022-12-04 12:10:22','',''),('1','288',467,'','6.1','4',0.00,1024932.30,'Sales from shift 93 on 2022-12-04 12:10:22 ','2022-12-04 12:10:22','',''),('1','288',468,'','20','3',728704.20,0.00,'Sales from shift 94 on 2022-12-04 12:15:32 ','2022-12-04 12:15:32','',''),('1','288',469,'','6.1','4',0.00,728704.20,'Sales from shift 94 on 2022-12-04 12:15:32 ','2022-12-04 12:15:32','',''),('1','288',470,'','20','3',480345.60,0.00,'Sales from shift 95 on 2022-12-04 12:24:01 ','2022-12-04 12:24:01','',''),('1','288',471,'','6.1','4',0.00,480345.60,'Sales from shift 95 on 2022-12-04 12:24:01 ','2022-12-04 12:24:01','',''),('1','288',472,'','20','3',471695.70,0.00,'Sales from shift 96 on 2022-12-05 14:32:12 ','2022-12-05 14:32:12','',''),('1','288',473,'','6.1','4',0.00,471695.70,'Sales from shift 96 on 2022-12-05 14:32:12 ','2022-12-05 14:32:12','',''),('1','288',474,'','2','5',550425.00,0.00,'Payment Id 141 for invoice:91, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-06 12:04:47','',''),('1','288',475,'','supplier','1',0.00,550425.00,'Payment Id 141 for invoice:91, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-06 12:04:47','',''),('1','288',476,'','2','5',840350.00,0.00,'Payment Id 140 for invoice:90, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-06 12:04:47','',''),('1','288',477,'','supplier','1',0.00,840350.00,'Payment Id 140 for invoice:90, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-06 12:04:47','',''),('1','288',478,'','6.1','4',34400.00,0.00,'Payment Id 146 for invoice:93, receipt: CREDIT NOTE by AA RANO NIGERIA LTD','2022-12-06 12:07:17','',''),('1','288',479,'','supplier','1',0.00,34400.00,'Payment Id 146 for invoice:93, receipt: CREDIT NOTE by AA RANO NIGERIA LTD','2022-12-06 12:07:17','',''),('1','288',480,'','2','5',1091150.00,0.00,'Payment Id 143 for invoice:92, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-06 12:07:17','',''),('1','288',481,'','supplier','1',0.00,1091150.00,'Payment Id 143 for invoice:92, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-06 12:07:17','',''),('1','288',482,'','2','5',445145.00,0.00,'Payment Id 148 for invoice:95, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-06 12:08:14','',''),('1','288',483,'','supplier','1',0.00,445145.00,'Payment Id 148 for invoice:95, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-06 12:08:14','',''),('1','288',484,'','2','5',728705.00,0.00,'Payment Id 147 for invoice:94, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-06 12:08:14','',''),('1','288',485,'','supplier','1',0.00,728705.00,'Payment Id 147 for invoice:94, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-06 12:08:14','',''),('1','288',486,'','2','5',425820.00,0.00,'Payment Id 150 for invoice:97, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-06 12:11:15','',''),('1','288',487,'','supplier','1',0.00,425820.00,'Payment Id 150 for invoice:97, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-06 12:11:15','',''),('1','288',488,'','2','5',471700.00,0.00,'Payment Id 149 for invoice:96, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-06 12:11:15','',''),('1','288',489,'','supplier','1',0.00,471700.00,'Payment Id 149 for invoice:96, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-06 12:11:15','',''),('1','288',490,'','20','3',456221.70,0.00,'Sales from shift 97 on 2022-12-06 16:15:05 ','2022-12-06 16:15:05','',''),('1','288',491,'','6.1','4',0.00,456221.70,'Sales from shift 97 on 2022-12-06 16:15:05 ','2022-12-06 16:15:05','',''),('1','288',492,'','20','3',733890.00,0.00,'Sales from shift 98 on 2022-12-07 04:17:07 ','2022-12-07 04:17:07','',''),('1','288',493,'','6.1','4',0.00,733890.00,'Sales from shift 98 on 2022-12-07 04:17:07 ','2022-12-07 04:17:07','',''),('1','288',494,'','2','6',5500.00,0.00,'Payment Id 145 for invoice:92/93, receipt: P.o.s by AA RANO NIGERIA LTD','2022-12-08 14:30:49','',''),('1','288',495,'','supplier','1',0.00,5500.00,'Payment Id 145 for invoice:92/93, receipt: P.o.s by AA RANO NIGERIA LTD','2022-12-08 14:30:49','',''),('1','288',496,'','2','6',195900.00,0.00,'Payment Id 142 for invoice:90/91, receipt: P.o.s by AA RANO NIGERIA LTD','2022-12-08 14:32:08','',''),('1','288',497,'','supplier','1',0.00,195900.00,'Payment Id 142 for invoice:90/91, receipt: P.o.s by AA RANO NIGERIA LTD','2022-12-08 14:32:08','',''),('1','288',498,'','20','3',704660.10,0.00,'Sales from shift 99 on 2022-12-11 05:56:02 ','2022-12-11 05:56:02','',''),('1','288',499,'','6.1','4',0.00,704660.10,'Sales from shift 99 on 2022-12-11 05:56:02 ','2022-12-11 05:56:02','',''),('1','288',500,'','2','5',235125.00,0.00,'Payment Id 171 for invoice:93, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-12 14:09:46','',''),('1','288',501,'','supplier','1',0.00,235125.00,'Payment Id 171 for invoice:93, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-12 14:09:46','',''),('1','288',502,'','2','5',728705.00,0.00,'Payment Id 144 for invoice:93, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-12 14:09:46','',''),('1','288',503,'','supplier','1',0.00,728705.00,'Payment Id 144 for invoice:93, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-12 14:09:46','',''),('1','288',504,'','2','5',707500.00,0.00,'Payment Id 151 for invoice:98, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-12 14:11:53','',''),('1','288',505,'','supplier','1',0.00,707500.00,'Payment Id 151 for invoice:98, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-12 14:11:53','',''),('1','288',506,'','2','5',6020.00,0.00,'Payment Id 172 for invoice:95, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-12 14:15:31','',''),('1','288',507,'','supplier','1',0.00,6020.00,'Payment Id 172 for invoice:95, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-12 14:15:31','',''),('1','288',508,'','2','5',154500.00,0.00,'Payment Id 173 for invoice:01, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-13 16:17:56','',''),('1','288',509,'','supplier','1',0.00,154500.00,'Payment Id 173 for invoice:01, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-13 16:17:56','',''),('1','288',510,'','2','5',23900.00,0.00,'Payment Id 176 for invoice:19, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-13 16:20:09','',''),('1','288',511,'','supplier','1',0.00,23900.00,'Payment Id 176 for invoice:19, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-13 16:20:09','',''),('1','288',512,'','2','5',16400.00,0.00,'Payment Id 177 for invoice:21, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-13 16:21:53','',''),('1','288',513,'','supplier','1',0.00,16400.00,'Payment Id 177 for invoice:21, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-13 16:21:53','',''),('1','288',514,'','2','5',30000.00,0.00,'Payment Id 178 for invoice:23, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-13 16:22:56','',''),('1','288',515,'','supplier','1',0.00,30000.00,'Payment Id 178 for invoice:23, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-13 16:22:56','',''),('1','288',516,'','2','5',15000.00,0.00,'Payment Id 179 for invoice:25, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-13 16:24:30','',''),('1','288',517,'','supplier','1',0.00,15000.00,'Payment Id 179 for invoice:25, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-13 16:24:30','',''),('1','288',518,'','2','5',10600.00,0.00,'Payment Id 182 for invoice:35, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-13 16:31:27','',''),('1','288',519,'','supplier','1',0.00,10600.00,'Payment Id 182 for invoice:35, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-13 16:31:27','',''),('1','288',520,'','2','5',77000.00,0.00,'Payment Id 180 for invoice:34, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-13 16:31:27','',''),('1','288',521,'','supplier','1',0.00,77000.00,'Payment Id 180 for invoice:34, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-13 16:31:27','',''),('1','288',522,'','2','5',8000.00,0.00,'Payment Id 183 for invoice:36, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-13 16:32:40','',''),('1','288',523,'','supplier','1',0.00,8000.00,'Payment Id 183 for invoice:36, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-13 16:32:40','',''),('1','288',524,'','2','5',12300.00,0.00,'Payment Id 181 for invoice:34, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-13 16:32:40','',''),('1','288',525,'','supplier','1',0.00,12300.00,'Payment Id 181 for invoice:34, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-13 16:32:40','',''),('1','288',526,'','2','5',310560.00,0.00,'Payment Id 153 for invoice:99, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-13 16:33:13','',''),('1','288',527,'','supplier','1',0.00,310560.00,'Payment Id 153 for invoice:99, receipt: E BILLS by AA RANO NIGERIA LTD','2022-12-13 16:33:13','',''),('1','288',528,'','2','6',367700.00,0.00,'Payment Id 184 for invoice:99, receipt: P.o.s by AA RANO NIGERIA LTD','2022-12-13 16:46:47','',''),('1','288',529,'','supplier','1',0.00,367700.00,'Payment Id 184 for invoice:99, receipt: P.o.s by AA RANO NIGERIA LTD','2022-12-13 16:46:47','',''),('1','288',530,'','6.1','4',26400.00,0.00,'Payment Id 167 for invoice:93, receipt: CREDIT NOTE by AA RANO NIGERIA LTD','2022-12-15 10:22:35','',''),('1','288',531,'','supplier','1',0.00,26400.00,'Payment Id 167 for invoice:93, receipt: CREDIT NOTE by AA RANO NIGERIA LTD','2022-12-15 10:22:35','',''),('1','288',532,'','6.1','4',26400.00,0.00,'Payment Id 166 for invoice:98, receipt: CREDIT NOTE by AA RANO NIGERIA LTD','2022-12-15 10:22:35','',''),('1','288',533,'','supplier','1',0.00,26400.00,'Payment Id 166 for invoice:98, receipt: CREDIT NOTE by AA RANO NIGERIA LTD','2022-12-15 10:22:35','',''),('1','288',534,'','6.1','4',26400.00,0.00,'Payment Id 165 for invoice:97, receipt: CREDIT NOTE by AA RANO NIGERIA LTD','2022-12-15 10:22:35','',''),('1','288',535,'','supplier','1',0.00,26400.00,'Payment Id 165 for invoice:97, receipt: CREDIT NOTE by AA RANO NIGERIA LTD','2022-12-15 10:22:35','',''),('1','288',536,'','6.1','4',25200.00,0.00,'Payment Id 164 for invoice:95, receipt: CREDIT NOTE by AA RANO NIGERIA LTD','2022-12-15 10:22:35','',''),('1','288',537,'','supplier','1',0.00,25200.00,'Payment Id 164 for invoice:95, receipt: CREDIT NOTE by AA RANO NIGERIA LTD','2022-12-15 10:22:35','',''),('1','288',538,'','6.1','4',25200.00,0.00,'Payment Id 163 for invoice:91, receipt: CREDIT NOTE by AA RANO NIGERIA LTD','2022-12-15 10:22:35','',''),('1','288',539,'','supplier','1',0.00,25200.00,'Payment Id 163 for invoice:91, receipt: CREDIT NOTE by AA RANO NIGERIA LTD','2022-12-15 10:22:35','',''),('1','288',540,'','6.1','4',26400.00,0.00,'Payment Id 154 for invoice:99, receipt: CREDIT NOTE by AA RANO NIGERIA LTD','2022-12-15 10:22:35','',''),('1','288',541,'','supplier','1',0.00,26400.00,'Payment Id 154 for invoice:99, receipt: CREDIT NOTE by AA RANO NIGERIA LTD','2022-12-15 10:22:35','',''),('1','288',542,'','2','6',5000.00,0.00,'Payment Id 185 for invoice:94, receipt: P.o.s by AA RANO NIGERIA LTD','2022-12-27 10:55:58','',''),('1','288',543,'','supplier','1',0.00,5000.00,'Payment Id 185 for invoice:94, receipt: P.o.s by AA RANO NIGERIA LTD','2022-12-27 10:55:58','',''),('1','288',544,'','customer','2',0.00,5670000.00,'Credit Sales for 7,000.00 Litres of Diesel from shift 100 on 2023-03-03 09:58:29 ','2023-03-03 09:58:29','',''),('1','288',545,'','20','3',5694300.00,0.00,'Sales from shift 100 on 2023-03-03 09:58:29 ','2023-03-03 09:58:29','',''),('1','288',546,'','6.1','4',0.00,24300.00,'Sales from shift 100 on 2023-03-03 09:58:29 ','2023-03-03 09:58:29','',''),('1','288',547,'','24','1',0.00,11750000.00,'Purchase Id 7 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-04 06:39:33','',''),('1','288',548,'','supplier','1',11750000.00,0.00,'Purchase Id 7 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-04 06:39:33','',''),('1','288',549,'','20','3',0.00,0.00,'Sales from shift 101 on 2023-03-05 16:55:05 ','2023-03-05 16:55:05','',''),('1','288',550,'','6.1','4',0.00,0.00,'Sales from shift 101 on 2023-03-05 16:55:05 ','2023-03-05 16:55:05','',''),('1','288',551,'','20','3',0.00,0.00,'Sales from shift 102 on 2023-03-07 14:28:09 ','2023-03-07 14:28:09','',''),('1','288',552,'','6.1','4',0.00,0.00,'Sales from shift 102 on 2023-03-07 14:28:09 ','2023-03-07 14:28:09','',''),('1','288',553,'','20','3',1448516.95,0.00,'Sales from shift 103 on 2023-03-07 17:25:17 ','2023-03-07 17:25:17','',''),('1','288',554,'','6.1','4',0.00,1448516.95,'Sales from shift 103 on 2023-03-07 17:25:17 ','2023-03-07 17:25:17','',''),('1','288',555,'','20','3',1155690.05,0.00,'Sales from shift 104 on 2023-03-08 09:47:45 ','2023-03-08 09:47:45','',''),('1','288',556,'','6.1','4',0.00,1155690.05,'Sales from shift 104 on 2023-03-08 09:47:45 ','2023-03-08 09:47:45','',''),('1','288',557,'','6.1','4',212500.00,0.00,'Payment Id 187 for invoice:100, receipt: CREDIT NOTE by AA RANO NIGERIA LTD','2023-03-08 14:28:37','',''),('1','288',558,'','supplier','1',0.00,212500.00,'Payment Id 187 for invoice:100, receipt: CREDIT NOTE by AA RANO NIGERIA LTD','2023-03-08 14:28:37','',''),('1','288',559,'','20','3',1447919.60,0.00,'Sales from shift 105 on 2023-03-09 10:21:17 ','2023-03-09 10:21:17','',''),('1','288',560,'','6.1','4',0.00,1447919.60,'Sales from shift 105 on 2023-03-09 10:21:17 ','2023-03-09 10:21:17','',''),('1','288',561,'','20','3',1584710.75,0.00,'Sales from shift 106 on 2023-03-10 09:26:45 ','2023-03-10 09:26:45','',''),('1','288',562,'','6.1','4',0.00,1584710.75,'Sales from shift 106 on 2023-03-10 09:26:45 ','2023-03-10 09:26:45','',''),('1','288',563,'','6.1','4',170100.00,0.00,'Payment Id 192 for invoice:187, receipt: CREDIT NOTE by AA RANO NIGERIA LTD','2023-03-10 11:06:43','',''),('1','288',564,'','supplier','1',0.00,170100.00,'Payment Id 192 for invoice:187, receipt: CREDIT NOTE by AA RANO NIGERIA LTD','2023-03-10 11:06:43','',''),('1','288',565,'','6.1','4',24300.00,0.00,'Payment Id 191 for invoice:186, receipt: CREDIT NOTE by AA RANO NIGERIA LTD','2023-03-10 11:06:43','',''),('1','288',566,'','supplier','1',0.00,24300.00,'Payment Id 191 for invoice:186, receipt: CREDIT NOTE by AA RANO NIGERIA LTD','2023-03-10 11:06:43','',''),('1','288',567,'','20','3',1877266.95,0.00,'Sales from shift 107 on 2023-03-10 13:18:34 ','2023-03-10 13:18:34','',''),('1','288',568,'','6.1','4',0.00,1877266.95,'Sales from shift 107 on 2023-03-10 13:18:34 ','2023-03-10 13:18:34','',''),('1','288',569,'','20','3',2325889.00,0.00,'Sales from shift 108 on 2023-03-10 15:42:46 ','2023-03-10 15:42:46','',''),('1','288',570,'','6.1','4',0.00,2325889.00,'Sales from shift 108 on 2023-03-10 15:42:46 ','2023-03-10 15:42:46','',''),('1','288',571,'','24','1',0.00,10575000.00,'Purchase Id 8 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-10 15:43:10','',''),('1','288',572,'','supplier','1',10575000.00,0.00,'Purchase Id 8 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-10 15:43:10','',''),('1','288',573,'','20','3',1147808.15,0.00,'Sales from shift 109 on 2023-03-11 08:21:44 ','2023-03-11 08:21:44','',''),('1','288',574,'','6.1','4',0.00,1147808.15,'Sales from shift 109 on 2023-03-11 08:21:44 ','2023-03-11 08:21:44','',''),('1','288',575,'','2','6',1039182.25,0.00,'Payment Id 189 for invoice:187, receipt: P.o.s by AA RANO NIGERIA LTD','2023-03-11 17:02:33','',''),('1','288',576,'','supplier','1',0.00,1039182.25,'Payment Id 189 for invoice:187, receipt: P.o.s by AA RANO NIGERIA LTD','2023-03-11 17:02:33','',''),('1','288',577,'','2','6',1105320.00,0.00,'Payment Id 193 for invoice:104, receipt: P.o.s by AA RANO NIGERIA LTD','2023-03-11 17:03:06','',''),('1','288',578,'','supplier','1',0.00,1105320.00,'Payment Id 193 for invoice:104, receipt: P.o.s by AA RANO NIGERIA LTD','2023-03-11 17:03:06','',''),('1','288',579,'','2','6',1441690.00,0.00,'Payment Id 200 for invoice:105, receipt: P.o.s by AA RANO NIGERIA LTD','2023-03-11 17:03:24','',''),('1','288',580,'','supplier','1',0.00,1441690.00,'Payment Id 200 for invoice:105, receipt: P.o.s by AA RANO NIGERIA LTD','2023-03-11 17:03:24','',''),('1','288',581,'','2','6',1449408.00,0.00,'Payment Id 201 for invoice:106, receipt: P.o.s by AA RANO NIGERIA LTD','2023-03-11 17:03:45','',''),('1','288',582,'','supplier','1',0.00,1449408.00,'Payment Id 201 for invoice:106, receipt: P.o.s by AA RANO NIGERIA LTD','2023-03-11 17:03:45','',''),('1','288',583,'','2','6',1760143.00,0.00,'Payment Id 202 for invoice:107, receipt: P.o.s by AA RANO NIGERIA LTD','2023-03-11 17:04:03','',''),('1','288',584,'','supplier','1',0.00,1760143.00,'Payment Id 202 for invoice:107, receipt: P.o.s by AA RANO NIGERIA LTD','2023-03-11 17:04:03','',''),('1','288',585,'','2','6',2013426.00,0.00,'Payment Id 203 for invoice:108, receipt: P.o.s by AA RANO NIGERIA LTD','2023-03-11 17:04:18','',''),('1','288',586,'','supplier','1',0.00,2013426.00,'Payment Id 203 for invoice:108, receipt: P.o.s by AA RANO NIGERIA LTD','2023-03-11 17:04:18','',''),('1','288',587,'','20','3',1634998.40,0.00,'Sales from shift 110 on 2023-03-11 17:04:50 ','2023-03-11 17:04:50','',''),('1','288',588,'','6.1','4',0.00,1634998.40,'Sales from shift 110 on 2023-03-11 17:04:50 ','2023-03-11 17:04:50','',''),('1','288',589,'','20','3',1634869.15,0.00,'Sales from shift 111 on 2023-03-12 21:58:45 ','2023-03-12 21:58:45','',''),('1','288',590,'','6.1','4',0.00,1634869.15,'Sales from shift 111 on 2023-03-12 21:58:45 ','2023-03-12 21:58:45','',''),('1','288',591,'','20','3',1618732.55,0.00,'Sales from shift 112 on 2023-03-13 13:15:36 ','2023-03-13 13:15:36','',''),('1','288',592,'','6.1','4',0.00,1618732.55,'Sales from shift 112 on 2023-03-13 13:15:36 ','2023-03-13 13:15:36','',''),('1','288',593,'','20','3',1514412.85,0.00,'Sales from shift 113 on 2023-03-14 08:28:16 ','2023-03-14 08:28:16','',''),('1','288',594,'','6.1','4',0.00,1514412.85,'Sales from shift 113 on 2023-03-14 08:28:16 ','2023-03-14 08:28:16','',''),('1','288',595,'','20','3',877631.00,0.00,'Sales from shift 114 on 2023-03-15 09:13:41 ','2023-03-15 09:13:41','',''),('1','288',596,'','6.1','4',0.00,877631.00,'Sales from shift 114 on 2023-03-15 09:13:41 ','2023-03-15 09:13:41','',''),('1','288',597,'','2','5',78230.00,0.00,'Payment Id 198 for invoice:109, receipt: E BILLS by AA RANO NIGERIA LTD','2023-03-15 14:25:27','',''),('1','288',598,'','supplier','1',0.00,78230.00,'Payment Id 198 for invoice:109, receipt: E BILLS by AA RANO NIGERIA LTD','2023-03-15 14:25:27','',''),('1','288',599,'','2','5',117125.00,0.00,'Payment Id 196 for invoice:107, receipt: E BILLS by AA RANO NIGERIA LTD','2023-03-15 14:25:27','',''),('1','288',600,'','supplier','1',0.00,117125.00,'Payment Id 196 for invoice:107, receipt: E BILLS by AA RANO NIGERIA LTD','2023-03-15 14:25:27','',''),('1','288',601,'','2','5',2895.00,0.00,'Payment Id 199 for invoice:110, receipt: E BILLS by AA RANO NIGERIA LTD','2023-03-15 14:27:35','',''),('1','288',602,'','supplier','1',0.00,2895.00,'Payment Id 199 for invoice:110, receipt: E BILLS by AA RANO NIGERIA LTD','2023-03-15 14:27:35','',''),('1','288',603,'','2','5',312470.00,0.00,'Payment Id 197 for invoice:108, receipt: E BILLS by AA RANO NIGERIA LTD','2023-03-15 14:28:50','',''),('1','288',604,'','supplier','1',0.00,312470.00,'Payment Id 197 for invoice:108, receipt: E BILLS by AA RANO NIGERIA LTD','2023-03-15 14:28:50','',''),('1','288',605,'','2','5',29775.00,0.00,'Payment Id 206 for invoice:111, receipt: E BILLS by AA RANO NIGERIA LTD','2023-03-15 15:22:46','',''),('1','288',606,'','supplier','1',0.00,29775.00,'Payment Id 206 for invoice:111, receipt: E BILLS by AA RANO NIGERIA LTD','2023-03-15 15:22:46','',''),('1','288',607,'','24','1',0.00,10575000.00,'Purchase Id 9 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-15 20:29:25','',''),('1','288',608,'','supplier','1',10575000.00,0.00,'Purchase Id 9 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-15 20:29:25','',''),('1','288',609,'','20','3',1081843.65,0.00,'Sales from shift 115 on 2023-03-16 09:08:48 ','2023-03-16 09:08:48','',''),('1','288',610,'','6.1','4',0.00,1081843.65,'Sales from shift 115 on 2023-03-16 09:08:48 ','2023-03-16 09:08:48','',''),('1','288',611,'','2','5',135000.00,0.00,'Payment Id 195 for invoice:106, receipt: E BILLS by AA RANO NIGERIA LTD','2023-03-16 15:05:42','',''),('1','288',612,'','supplier','1',0.00,135000.00,'Payment Id 195 for invoice:106, receipt: E BILLS by AA RANO NIGERIA LTD','2023-03-16 15:05:42','',''),('1','288',613,'','2','5',6230.00,0.00,'Payment Id 194 for invoice:105, receipt: E BILLS by AA RANO NIGERIA LTD','2023-03-16 15:05:42','',''),('1','288',614,'','supplier','1',0.00,6230.00,'Payment Id 194 for invoice:105, receipt: E BILLS by AA RANO NIGERIA LTD','2023-03-16 15:05:42','',''),('1','288',615,'','2','6',1632100.00,0.00,'Payment Id 205 for invoice:110, receipt: P.o.s by AA RANO NIGERIA LTD','2023-03-16 15:10:04','',''),('1','288',616,'','supplier','1',0.00,1632100.00,'Payment Id 205 for invoice:110, receipt: P.o.s by AA RANO NIGERIA LTD','2023-03-16 15:10:04','',''),('1','288',617,'','2','6',1069580.00,0.00,'Payment Id 204 for invoice:109, receipt: P.o.s by AA RANO NIGERIA LTD','2023-03-16 15:10:04','',''),('1','288',618,'','supplier','1',0.00,1069580.00,'Payment Id 204 for invoice:109, receipt: P.o.s by AA RANO NIGERIA LTD','2023-03-16 15:10:04','',''),('1','288',619,'','2','6',1274321.00,0.00,'Payment Id 213 for invoice:113, receipt: P.o.s by AA RANO NIGERIA LTD','2023-03-16 15:14:45','',''),('1','288',620,'','supplier','1',0.00,1274321.00,'Payment Id 213 for invoice:113, receipt: P.o.s by AA RANO NIGERIA LTD','2023-03-16 15:14:45','',''),('1','288',621,'','6.1','4',168000.00,0.00,'Payment Id 211 for invoice:112, receipt: CREDIT NOTE by AA RANO NIGERIA LTD','2023-03-16 15:14:46','',''),('1','288',622,'','supplier','1',0.00,168000.00,'Payment Id 211 for invoice:112, receipt: CREDIT NOTE by AA RANO NIGERIA LTD','2023-03-16 15:14:46','',''),('1','288',623,'','2','6',1432226.00,0.00,'Payment Id 210 for invoice:112, receipt: P.o.s by AA RANO NIGERIA LTD','2023-03-16 15:14:46','',''),('1','288',624,'','supplier','1',0.00,1432226.00,'Payment Id 210 for invoice:112, receipt: P.o.s by AA RANO NIGERIA LTD','2023-03-16 15:14:46','',''),('1','288',625,'','2','5',18505.00,0.00,'Payment Id 209 for invoice:112, receipt: E BILLS by AA RANO NIGERIA LTD','2023-03-16 15:14:46','',''),('1','288',626,'','supplier','1',0.00,18505.00,'Payment Id 209 for invoice:112, receipt: E BILLS by AA RANO NIGERIA LTD','2023-03-16 15:14:46','',''),('1','288',627,'','2','6',1605095.00,0.00,'Payment Id 207 for invoice:111, receipt: P.o.s by AA RANO NIGERIA LTD','2023-03-16 15:14:46','',''),('1','288',628,'','supplier','1',0.00,1605095.00,'Payment Id 207 for invoice:111, receipt: P.o.s by AA RANO NIGERIA LTD','2023-03-16 15:14:46','',''),('1','288',629,'','2','5',4300.00,0.00,'Payment Id 214 for invoice:114, receipt: E BILLS by AA RANO NIGERIA LTD','2023-03-16 15:17:26','',''),('1','288',630,'','supplier','1',0.00,4300.00,'Payment Id 214 for invoice:114, receipt: E BILLS by AA RANO NIGERIA LTD','2023-03-16 15:17:26','',''),('1','288',631,'','2','5',240100.00,0.00,'Payment Id 212 for invoice:113, receipt: E BILLS by AA RANO NIGERIA LTD','2023-03-16 15:17:26','',''),('1','288',632,'','supplier','1',0.00,240100.00,'Payment Id 212 for invoice:113, receipt: E BILLS by AA RANO NIGERIA LTD','2023-03-16 15:17:26','',''),('1','288',633,'','2','6',859850.00,0.00,'Payment Id 215 for invoice:114, receipt: P.o.s by AA RANO NIGERIA LTD','2023-03-16 15:18:30','',''),('1','288',634,'','supplier','1',0.00,859850.00,'Payment Id 215 for invoice:114, receipt: P.o.s by AA RANO NIGERIA LTD','2023-03-16 15:18:30','',''),('1','288',635,'','20','3',2383059.80,0.00,'Sales from shift 116 on 2023-03-17 07:50:19 ','2023-03-17 07:50:19','',''),('1','288',636,'','6.1','4',0.00,2383059.80,'Sales from shift 116 on 2023-03-17 07:50:19 ','2023-03-17 07:50:19','',''),('1','288',637,'','2','5',26735.00,0.00,'Payment Id 218 for invoice:187, receipt: E BILLS by AA RANO NIGERIA LTD','2023-03-17 14:24:24','',''),('1','288',638,'','supplier','1',0.00,26735.00,'Payment Id 218 for invoice:187, receipt: E BILLS by AA RANO NIGERIA LTD','2023-03-17 14:24:24','',''),('1','288',639,'','2','5',50371.00,0.00,'Payment Id 219 for invoice:104, receipt: E BILLS by AA RANO NIGERIA LTD','2023-03-17 14:24:55','',''),('1','288',640,'','supplier','1',0.00,50371.00,'Payment Id 219 for invoice:104, receipt: E BILLS by AA RANO NIGERIA LTD','2023-03-17 14:24:55','',''),('1','288',641,'','20','3',2750968.75,0.00,'Sales from shift 117 on 2023-03-20 08:09:35 ','2023-03-20 08:09:35','',''),('1','288',642,'','6.1','4',0.00,2750968.75,'Sales from shift 117 on 2023-03-20 08:09:35 ','2023-03-20 08:09:35','',''),('1','288',643,'','20','3',2168055.05,0.00,'Sales from shift 118 on 2023-03-20 10:26:57 ','2023-03-20 10:26:57','',''),('1','288',644,'','6.1','4',0.00,2168055.05,'Sales from shift 118 on 2023-03-20 10:26:57 ','2023-03-20 10:26:57','','');
/*!40000 ALTER TABLE `ledgers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `options`
--

DROP TABLE IF EXISTS `options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `options` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` bigint NOT NULL,
  `station_id` bigint NOT NULL,
  `option_key` varchar(200) NOT NULL,
  `option_value` longtext,
  `thedate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `station_id` (`station_id`,`option_key`),
  KEY `company_id` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `options`
--

LOCK TABLES `options` WRITE;
/*!40000 ALTER TABLE `options` DISABLE KEYS */;
/*!40000 ALTER TABLE `options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `measurement` varchar(20) NOT NULL,
  `quantity2` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`code`,`name`,`measurement`,`quantity2`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `cleanup` (`cleanup`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'1','288','PMS','Petrol','Litres',0,235.00,235.00,235.00,235.00,0.00,0,'2022-10-19 14:18:56','178','178','2022-10-19 14:18:56',0),(2,'1','288','AGO','Diesel','Litres',0,790.00,790.00,790.00,790.00,0.00,0,'2022-10-19 16:18:08','178','178','2022-10-19 16:18:08',0);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_changevalues`
--

DROP TABLE IF EXISTS `products_changevalues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_changevalues` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `change_id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity` bigint NOT NULL,
  `oldrate` decimal(20,2) NOT NULL,
  `newrate` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`change_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_changevalues`
--

LOCK TABLES `products_changevalues` WRITE;
/*!40000 ALTER TABLE `products_changevalues` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_changevalues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_prices`
--

DROP TABLE IF EXISTS `products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_prices`
--

LOCK TABLES `products_prices` WRITE;
/*!40000 ALTER TABLE `products_prices` DISABLE KEYS */;
INSERT INTO `products_prices` VALUES (1,'1','288',1,180.00,0.00,0.00,0.00,'Cost from purchase id #2','2022-10-27 11:10:27','648'),(2,'1','288',2,770.00,0.00,0.00,0.00,'Cost from purchase id #3','2022-10-27 18:07:00','648'),(3,'1','288',2,770.00,770.00,770.00,770.00,'','2022-11-02 12:11:44','969'),(4,'1','288',1,180.00,180.00,180.00,180.00,'','2022-11-02 12:12:56','969'),(5,'1','288',2,800.00,800.00,800.00,800.00,'','2022-11-12 12:04:00','969'),(6,'1','288',1,210.00,210.00,210.00,210.00,'','2022-11-23 15:58:48','969'),(7,'1','288',2,840.00,840.00,840.00,840.00,'','2022-11-24 11:51:23','969'),(8,'1','288',2,825.00,825.00,825.00,825.00,'','2022-11-25 10:27:41','969'),(9,'1','288',2,840.00,840.00,840.00,840.00,'','2022-11-26 14:56:55','969'),(10,'1','288',2,880.00,880.00,880.00,880.00,'','2022-12-04 12:19:15','969'),(11,'1','288',2,840.00,840.00,840.00,840.00,'','2022-12-08 13:02:36','969'),(12,'1','288',2,820.00,820.00,820.00,820.00,'','2022-12-14 14:15:18','969'),(13,'1','288',1,235.00,235.00,235.00,235.00,'','2022-12-26 14:09:08','969'),(14,'1','288',2,830.00,830.00,830.00,830.00,'','2023-01-23 14:32:25','969'),(15,'1','288',2,790.00,790.00,790.00,790.00,'','2023-01-28 11:53:36','969'),(16,'1','288',2,810.00,810.00,810.00,810.00,'','2023-02-13 10:17:33','969'),(17,'1','288',1,210.00,210.00,210.00,210.00,'','2023-03-02 14:23:30','969'),(18,'1','288',1,235.00,235.00,235.00,235.00,'','2023-03-03 15:51:32','969'),(19,'1','288',2,800.00,800.00,800.00,800.00,'','2023-03-06 14:22:37','969'),(20,'1','288',2,810.00,810.00,810.00,810.00,'','2023-03-06 14:26:34','969'),(21,'1','288',2,800.00,800.00,800.00,800.00,'','2023-03-07 18:30:33','969'),(22,'1','288',2,790.00,790.00,790.00,790.00,'','2023-03-14 08:05:29','969');
/*!40000 ALTER TABLE `products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_reconciliations`
--

DROP TABLE IF EXISTS `products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_reconciliations`
--

LOCK TABLES `products_reconciliations` WRITE;
/*!40000 ALTER TABLE `products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_shortages`
--

DROP TABLE IF EXISTS `products_shortages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_shortages` (
  `shortage_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shortagedate` date NOT NULL,
  `product_id` varchar(10) NOT NULL,
  `type` int NOT NULL DEFAULT '0',
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`shortage_id`),
  KEY `companycode` (`company_id`,`shortagedate`,`product_id`,`rate`,`quantity`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_shortages`
--

LOCK TABLES `products_shortages` WRITE;
/*!40000 ALTER TABLE `products_shortages` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_shortages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pts_nozzles`
--

DROP TABLE IF EXISTS `pts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pts_nozzles` (
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pts_id` int NOT NULL,
  `pump` varchar(20) NOT NULL,
  `code` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `last_volume` decimal(20,2) NOT NULL,
  `last_price` decimal(20,2) NOT NULL,
  `last_amount` decimal(20,2) NOT NULL,
  `last_transaction` int NOT NULL DEFAULT '0',
  `total_volume` decimal(20,2) NOT NULL,
  `total_amount` decimal(20,2) NOT NULL,
  `total_transactions` decimal(20,2) NOT NULL,
  `lastconnect` datetime NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `terminal_id` (`pts_id`,`pump`,`code`,`lastconnect`),
  KEY `companycode` (`company_id`,`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pts_nozzles`
--

LOCK TABLES `pts_nozzles` WRITE;
/*!40000 ALTER TABLE `pts_nozzles` DISABLE KEYS */;
/*!40000 ALTER TABLE `pts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases`
--

DROP TABLE IF EXISTS `purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases`
--

LOCK TABLES `purchases` WRITE;
/*!40000 ALTER TABLE `purchases` DISABLE KEYS */;
INSERT INTO `purchases` VALUES (2,'1','288','2022-09-18',1,1,180.00,49200.00,0.00,0.00,8856000.00,0.00,'','','NSR 70 ZQ','','','','2022-10-27 10:58:53',15,'PURCHASE OF PMS','969','','0000-00-00 00:00:00','648','2022-10-27 11:10:27'),(3,'1','288','2022-09-26',2,1,770.00,19600.00,0.00,0.00,15092000.00,0.00,'','','NSR 70 ZQ','','','','2022-10-27 17:47:51',15,'PURCHASE OF A.G.O','969','','0000-00-00 00:00:00','648','2022-10-27 18:07:00'),(4,'1','288','2022-10-07',1,1,180.00,50000.00,0.00,0.00,9000000.00,0.00,'','','RAN 850 XA','','','','2022-10-27 17:52:39',15,'PURCHASE OF PMS','969','','0000-00-00 00:00:00','648','2022-10-27 18:06:00'),(5,'1','288','2022-10-20',1,1,180.00,50000.00,0.00,0.00,9000000.00,0.00,'','','RAN 849 XA','','','','2022-10-30 13:46:13',15,'PURCHASE OF PMS','969','','0000-00-00 00:00:00','648','2022-11-15 10:26:30'),(6,'1','288','2022-11-23',1,1,210.00,60000.00,0.00,0.00,12600000.00,0.00,'','','TRN 23 YZ','','','','2022-11-23 15:55:58',15,'PURCHASE OF PMS','969','','0000-00-00 00:00:00','648','2022-11-24 04:45:14'),(7,'1','288','2023-03-03',1,1,235.00,50000.00,0.00,0.00,11750000.00,0.00,'',' ','BCH 462 XA','','','','2023-03-03 16:03:53',15,'RECIEVED PMS','969','','0000-00-00 00:00:00','648','2023-03-04 06:39:33'),(8,'1','288','2023-03-10',1,1,235.00,45000.00,0.00,0.00,10575000.00,0.00,'','','RAN-831-XA','','','','2023-03-10 10:11:34',15,'PURCHASE OF PMS','969','','0000-00-00 00:00:00','648','2023-03-10 15:43:10'),(9,'1','288','2023-03-15',1,1,235.00,45000.00,0.00,0.00,10575000.00,0.00,'','','KKM 196 XA','','','','2023-03-15 18:06:01',15,'PURCHASE OF PMS','969','','0000-00-00 00:00:00','648','2023-03-15 20:29:25');
/*!40000 ALTER TABLE `purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_payments`
--

DROP TABLE IF EXISTS `purchases_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `supplier_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`supplier_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=228 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_payments`
--

LOCK TABLES `purchases_payments` WRITE;
/*!40000 ALTER TABLE `purchases_payments` DISABLE KEYS */;
INSERT INTO `purchases_payments` VALUES (1,'1','288','2022-09-23',1,'E BILLS','','5',96250.00,'1','','','5','PORT HARCOURT 2','00',263988.00,'2022-11-04 10:57:01',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-11-21 10:43:32'),(2,'1','288','2022-09-23',1,'00','','10',13000.00,'1','','','6','PORT HARCOURT 2','POS',0.00,'2022-11-04 11:21:59',5,'U.B.A POS','969','','0000-00-00 00:00:00','975','2022-11-21 10:43:32'),(5,'1','288','2022-09-24',1,'0','','5',296910.00,'2','','','5','PORT HARCOURT 2','02',345909.60,'2022-11-04 11:44:44',5,'CASH TO BANK \'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-11-21 10:45:39'),(6,'1','288','2022-09-24',1,'P.o.s','','10',49000.00,'2','','','6','PORT HARCOURT 2','002',0.00,'2022-11-04 11:48:49',5,'U.B.A POS','969','','0000-00-00 00:00:00','975','2022-11-21 10:45:39'),(7,'1','288','2022-09-25',1,'E BILLS','','5',282500.00,'3','','','5','PORT HARCOURT 2','003',282333.00,'2022-11-04 11:59:44',5,'CASH TO BANK \'\'M\'\'','969','975','2022-11-21 10:53:53','975','2022-11-21 11:03:20'),(8,'1','288','2022-09-26',1,'E BILLS','','5',284250.00,'7','','','5','PORT HARCOURT 2','0474453',350026.20,'2022-11-04 12:05:12',5,'CASH TO BANK \'\'M\'\'','969','975','2022-11-21 10:54:58','975','2022-11-21 11:03:20'),(9,'1','288','2022-09-26',1,'P.o.s','','10',65780.00,'7','','','6','PORT HARCOURT 2','004',0.00,'2022-11-04 12:09:17',5,'U.B.A POS','969','','0000-00-00 00:00:00','975','2022-11-21 11:03:20'),(10,'1','288','2022-09-27',1,'E BILLS','','5',213435.00,'8','','','5','PORT HARCOURT 2','005',236435.40,'2022-11-04 12:12:26',5,'CASH TO BANK \'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-11-21 11:03:20'),(11,'1','288','2022-09-27',1,'E BILLS','','5',135920.00,'9','','','5','PORT HARCOURT 2','006',174416.40,'2022-11-04 12:15:25',5,'CASH TO BANK \'\'A\'\'','969','','0000-00-00 00:00:00','975','2022-11-21 11:03:20'),(12,'1','288','2022-09-27',1,'P.o.s','','10',61500.00,'9','','','6','PORT HARCOURT 2','06',0.00,'2022-11-04 12:18:09',5,'U.B.A POS','969','','0000-00-00 00:00:00','975','2022-11-21 11:03:20'),(14,'1','288','2022-09-28',1,'E BILLS','','5',174160.00,'10','','','5','PORT HARCOURT 2','0668305',216774.00,'2022-11-08 12:48:31',5,'CASH TO BANK\'\'M\'\'','969','975','2022-11-21 11:04:57','975','2022-11-21 11:06:40'),(15,'1','288','2022-09-28',1,'E BILLS','','5',153500.00,'11','','','5','PORT HARCOURT 2','0668304',171936.00,'2022-11-08 12:51:39',5,'CASH TO BANK\'\'A\'','969','975','2022-11-21 11:05:34','975','2022-11-21 11:06:40'),(16,'1','288','2022-09-28',1,'P.o.s','','10',61116.00,'10/11','','','6','PORT HARCOURT 2','00.0',0.00,'2022-11-08 12:56:36',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-21 11:06:40'),(17,'1','288','2022-09-29',1,'E BILLS','','5',1192300.00,'12','','','5','PORT HARCOURT 2','0668310',1225029.60,'2022-11-08 13:00:54',5,'CASH TO BANK\'\'M\'\'','969','975','2022-11-21 11:08:25','975','2022-11-21 11:14:19'),(18,'1','288','2022-09-29',1,'E BILLS','','5',136400.00,'13','','','5','PORT HARCOURT 2','0668312',174994.20,'2022-11-08 13:03:03',5,'CASH TO BANK\'\'A\'\'','969','975','2022-11-21 11:11:43','975','2022-11-21 11:14:19'),(19,'1','288','2022-09-29',1,'P.o.s','','10',71350.00,'12/13','','','6','PORT HARCOURT 2','012/13',0.00,'2022-11-08 13:07:34',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-21 11:14:19'),(20,'1','288','2022-09-30',1,'E BILLS','','5',183660.00,'14','','','5','PORT HARCOURT 2','0449148',210657.60,'2022-11-08 13:11:57',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-11-22 12:36:21'),(21,'1','288','2022-09-30',1,'E BILLS','','5',192930.00,'15','','','5','PORT HARCOURT 2','0449146',238546.80,'2022-11-08 13:14:41',5,'CASH TO B ANK\'\'A\'\'','969','975','2022-11-22 12:42:37','975','2022-11-22 12:46:50'),(22,'1','288','2022-09-30',1,'P.o.s','','10',72600.00,'14/15','','','6','PORT HARCOURT 2','14/15',0.00,'2022-11-08 13:18:21',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-22 12:46:50'),(23,'1','288','2022-10-01',1,'E BILLS','','5',1996700.00,'16','','','5','PORT HARCOURT 2','0949298',1996698.60,'2022-11-10 20:29:39',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-11-22 12:50:02'),(24,'1','288','2022-10-01',1,'E BILLS','','5',114285.00,'17','','','5','PORT HARCOURT 2','0949299',156486.60,'2022-11-10 20:33:40',5,'CASH TO BANK\'\'A\'\'','969','975','2022-11-22 12:49:14','975','2022-11-22 12:50:02'),(25,'1','288','2022-10-01',1,'P.o.s','','10',42190.00,'16','','','6','PORT HARCOURT 2','16',0.00,'2022-11-10 20:35:48',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-22 12:50:02'),(26,'1','288','2022-10-02',1,'E BILLS','','5',47750.00,'18','','','5','PORT HARCOURT 2','0449145',89389.80,'2022-11-10 20:38:45',5,'CASH TO BANK\'\'M\'\'','969','975','2022-11-22 12:51:06','975','2022-11-22 12:51:52'),(27,'1','288','2022-10-02',1,'P.o.s','','10',41624.00,'18','','','6','PORT HARCOURT 2','18',0.00,'2022-11-10 20:41:23',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-22 12:51:52'),(28,'1','288','2022-10-03',1,'E BILLS','','5',160700.00,'19','','','5','PORT HARCOURT 2','0668569',217404.00,'2022-11-10 20:48:26',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-11-22 13:34:41'),(29,'1','288','2022-10-03',1,'P.o.s','','10',32804.00,'19','','','6','PORT HARCOURT 2','19',0.00,'2022-11-10 20:50:14',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-22 13:34:41'),(30,'1','288','2022-10-04',1,'E BILLS','','5',202475.00,'20','','','5','PORT HARCOURT 2','0668568',241473.60,'2022-11-10 20:55:18',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-11-22 13:29:38'),(31,'1','288','2022-10-04',1,'E BILLS','','5',146300.00,'21','','','5','PORT HARCOURT 2','0668567',213625.80,'2022-11-10 20:58:21',5,'CASH TO BANK\'\'A\'\'','969','','0000-00-00 00:00:00','975','2022-11-22 13:29:38'),(32,'1','288','2022-10-04',1,'P.o.s','','10',89920.00,'20/21','','','6','PORT HARCOURT 2','20/21',0.00,'2022-11-10 21:01:52',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-22 13:29:38'),(33,'1','288','2022-10-05',1,'E BILLS','','5',58930.00,'22','','','5','PORT HARCOURT 2','0668570',92329.20,'2022-11-10 21:07:47',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-11-22 13:33:02'),(34,'1','288','2022-10-05',1,'E BILLS','','5',117600.00,'23','','','5','PORT HARCOURT 2','0668566',174576.60,'2022-11-10 21:13:38',5,'CASH TO BANK\'\'A\'\'','969','','0000-00-00 00:00:00','975','2022-11-22 13:33:02'),(35,'1','288','2022-10-05',1,'P.o.s','','10',59500.00,'22/23','','','6','PORT HARCOURT 2','22/23',0.00,'2022-11-10 21:15:55',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-22 13:33:02'),(36,'1','288','2022-10-06',1,'E BILLS','','5',180040.00,'24','','','5','PORT HARCOURT 2','24',210040.20,'2022-11-10 21:19:56',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-11-21 16:58:32'),(37,'1','288','2022-10-06',1,'E BILLS','','5',59420.00,'25','','','5','PORT HARCOURT 2','25',205243.20,'2022-11-10 21:22:31',5,'CASH TO BANK\'\'A\'\'','969','','0000-00-00 00:00:00','975','2022-11-21 16:58:32'),(38,'1','288','2022-10-06',1,'P.o.s','','10',100823.00,'24/25','','','6','PORT HARCOURT 2','24/25',0.00,'2022-11-10 21:45:30',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-21 16:58:32'),(39,'1','288','2022-10-07',1,'E BILLS ','','5',171370.00,'26','','','5','PORT HARCOURT 2','000',228732.30,'2022-11-16 12:53:54',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-11-21 16:59:35'),(40,'1','288','2022-10-07',1,'E BILLS','','5',170220.00,'27','','','5','PORT HARCOURT 2','007',200714.40,'2022-11-16 12:57:34',5,'CASH TO BANK\'\'A\'\'','969','','0000-00-00 00:00:00','975','2022-11-21 16:59:35'),(41,'1','288','2022-10-07',1,'P.o.s','','10',67810.00,'26/27','','','6','PORT HARCOURT 2','000/007',0.00,'2022-11-16 13:00:34',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-21 16:59:35'),(42,'1','288','2022-10-08',1,'E BILLS','','5',130960.00,'28','','','5','PORT HARCOURT 2','08',280387.80,'2022-11-16 13:04:07',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-11-21 17:01:02'),(43,'1','288','2022-10-08',1,'E BILLS','','5',180070.00,'29','','','5','PORT HARCOURT 2','008',217121.40,'2022-11-16 13:54:06',5,'CASH TO BANK\'\'A\'\'','969','','0000-00-00 00:00:00','975','2022-11-21 17:01:02'),(44,'1','288','2022-10-08',1,'P.o.s','','10',126462.75,'28/29','','','6','PORT HARCOURT 2','0008',0.00,'2022-11-16 13:58:04',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-21 17:01:02'),(45,'1','288','2022-10-09',1,'E BILLS','','5',129335.00,'30','','','5','PORT HARCOURT 2','009',164824.20,'2022-11-16 14:06:17',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-11-21 17:02:16'),(46,'1','288','2022-10-09',1,'E BILLS','','5',173675.00,'31','','','5','PORT HARCOURT 2','0009',202474.80,'2022-11-16 14:08:04',5,'CASH TO BANK\'\'A\'\'','969','','0000-00-00 00:00:00','975','2022-11-21 17:02:16'),(47,'1','288','2022-10-09',1,'P.o.s','','10',64300.00,'29/30','','','6','PORT HARCOURT 2','0000',0.00,'2022-11-16 14:22:16',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-21 17:02:16'),(48,'1','288','2022-10-10',1,'E BILLS','','5',176455.00,'32','','','5','PORT HARCOURT 2','010',214491.60,'2022-11-16 14:30:31',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-11-21 17:03:43'),(49,'1','288','2022-10-10',1,'E BILLS','','5',166150.00,'33','','','5','PORT HARCOURT 2','0010',265550.20,'2022-11-16 15:00:42',5,'CASH TO BANK \'\'A\'\' ','969','','0000-00-00 00:00:00','975','2022-11-21 17:03:43'),(50,'1','288','2022-10-10',1,'P.o.s','','10',98940.00,'32/33','','','6','PORT HARCOURT 2','00010',0.00,'2022-11-16 15:02:46',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-21 17:03:43'),(51,'1','288','2022-10-11',1,'0567375','','5',235700.00,'34','','','5','PORT HARCOURT 2','011 ',376592.00,'2022-11-16 15:17:33',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-11-21 17:06:10'),(52,'1','288','2022-10-11',1,'0567376','','5',196900.00,'35','','','5','PORT HARCOURT 2','0011',260022.60,'2022-11-16 15:20:33',5,'CASH TO BANK\'\'A\'\'','969','975','2022-11-22 13:52:21','975','2022-11-22 13:53:12'),(53,'1','288','2022-10-11',1,'P.o.s','','10',103966.00,'34/35','','','6','PORT HARCOURT 2','00011',0.00,'2022-11-16 15:22:51',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-21 17:06:10'),(54,'1','288','2022-10-12',1,'0449088','','5',165250.00,'36','','','5','PORT HARCOURT 2','0012',251273.10,'2022-11-16 15:30:05',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-11-21 17:09:27'),(55,'1','288','2022-10-12',1,'0449090','','5',157450.00,'37','','','5','PORT HARCOURT 2','00012',206218.80,'2022-11-16 15:35:37',5,'CASH TO BANK\'\'A\'\'','969','','0000-00-00 00:00:00','975','2022-11-21 17:09:27'),(56,'1','288','2022-10-12',1,'P.o.s','','10',87870.00,'36/37','','','6','PORT HARCOURT 2','000012',0.00,'2022-11-16 15:38:20',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-21 17:09:27'),(57,'1','288','2022-10-13',1,'0567380','','5',988050.00,'38','','','5','PORT HARCOURT 2','013',1051843.00,'2022-11-16 15:41:26',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-11-21 17:12:25'),(58,'1','288','2022-10-13',1,'0567375','','5',214425.00,'39','','','5','PORT HARCOURT 2','0013',296868.60,'2022-11-16 15:45:12',5,'CASH TO BANK\'\'A\'\'','969','','0000-00-00 00:00:00','975','2022-11-21 17:12:25'),(59,'1','288','2022-10-13',1,'P.o.s','','10',98817.00,'38/39','','','6','PORT HARCOURT 2','00013',0.00,'2022-11-16 15:59:53',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-21 17:12:25'),(60,'1','288','2022-10-14',1,'E BILLS','','5',210905.00,'40','','','5','PORT HARCOURT 2','0014',312521.80,'2022-11-16 16:08:10',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-11-22 15:02:33'),(61,'1','288','2022-10-14',1,'E BILLS','','5',196760.00,'41','','','5','PORT HARCOURT 2','00014 ',265856.40,'2022-11-16 16:25:12',5,'CASH TO BANK\'\'A\'\'','969','','0000-00-00 00:00:00','975','2022-11-22 13:48:24'),(62,'1','288','2022-10-14',1,'P.o.s','','10',138100.00,'40/41','','','6','PORT HARCOURT 2','000014',0.00,'2022-11-16 16:28:48',5,'U.B.A.POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-22 13:48:24'),(63,'1','288','2022-10-15',1,'E BILLS','','5',175505.00,'42','','','5','PORT HARCOURT 2','042',241005.60,'2022-11-16 16:32:04',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-11-22 13:48:24'),(64,'1','288','2022-10-15',1,'E BILLS','','5',213950.00,'43','','','5','PORT HARCOURT 2','043',284486.40,'2022-11-16 16:34:58',5,'CASH TO BANK\'\'A\'\'','969','','0000-00-00 00:00:00','975','2022-11-22 13:48:24'),(65,'1','288','2022-10-15',1,'P.o.s','','10',136039.56,'42/43','','','6','PORT HARCOURT 2','0043',0.00,'2022-11-16 16:37:54',5,'U.B.A.POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-22 13:48:24'),(66,'1','288','2022-10-16',1,'E BILLS','','5',156205.00,'44','','','5','PORT HARCOURT 2','016',252202.00,'2022-11-16 17:06:11',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-11-22 13:55:18'),(67,'1','288','2022-10-16',1,'E BILLS','','5',288080.00,'45','','','5','PORT HARCOURT 2','0016',326379.60,'2022-11-16 17:08:06',5,'CASH TO BANK\'\'A\'\'','969','','0000-00-00 00:00:00','975','2022-11-22 13:55:18'),(68,'1','288','2022-10-16',1,'P.o.s','','10',94300.00,'44/45','','','6','PORT HARCOURT 2','00016',0.00,'2022-11-16 17:10:32',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-22 13:55:18'),(69,'1','288','2022-10-17',1,'E BILLS','','5',194550.00,'46','','','5','PORT HARCOURT 2','017',244548.00,'2022-11-16 17:18:20',5,'CASH TO BANK \'\'M\'\'\r\n\r\n','969','','0000-00-00 00:00:00','975','2022-11-22 13:56:21'),(70,'1','288','2022-10-17',1,'E BILLS','','5',333400.00,'47','','','5','PORT HARCOURT 2','0017',458994.60,'2022-11-16 17:19:34',5,'CASHB TO BANK\'\'A\'\'','969','','0000-00-00 00:00:00','975','2022-11-22 13:56:21'),(71,'1','288','2022-10-17',1,'P.o.s','','10',175600.00,'46/47','','','5','PORT HARCOURT 2','00017',0.00,'2022-11-16 17:21:54',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-22 13:56:21'),(72,'1','288','2022-10-18',1,'E BILLS','','5',533110.00,'48','','','5','PORT HARCOURT 2','018',651809.20,'2022-11-16 17:25:05',5,'CASH TO BANK\'\'M\'\'','969','975','2022-11-22 13:56:46','975','2022-11-22 13:57:12'),(73,'1','288','2022-10-18',1,'E BILLS','','5',1298380.00,'49','','','5','PORT HARCOURT 2','0018',1819051.20,'2022-11-16 17:34:34',5,'CASH TO BANK\'\'A\'\'','969','','0000-00-00 00:00:00','975','2022-11-22 13:56:21'),(74,'1','288','2022-10-18',1,'P.o.s','','10',591375.00,'48/49','','','6','PORT HARCOURT 2','00049',0.00,'2022-11-16 17:36:58',5,'U.B.A.POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-22 13:56:21'),(75,'1','288','2022-10-19',1,'E BILLS','','5',746341.00,'50','','','5','PORT HARCOURT 2','050',961216.80,'2022-11-19 14:45:56',5,'CASH TO BANK\'\'M\'\'','969','975','2022-11-22 13:58:04','975','2022-11-22 14:02:02'),(76,'1','288','2022-10-19',1,'E BILLS','','5',209250.00,'51','','','5','PORT HARCOURT 2','051',250156.80,'2022-11-19 14:52:07',5,'CASH NTO BANK\'\'A\'\'','969','975','2022-11-22 13:59:08','975','2022-11-22 14:02:02'),(77,'1','288','2022-10-19',1,'P.o.s','','10',223375.00,'50/51','','','6','PORT HARCOURT 2','50/51',0.00,'2022-11-19 14:55:37',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-22 14:02:02'),(78,'1','288','2022-10-20',1,'E BILLS','','5',87420.00,'52','','','5','PORT HARCOURT 2','052',281880.60,'2022-11-19 14:58:19',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-11-22 14:02:02'),(79,'1','288','2022-10-20',1,'E BILLS','','5',282200.00,'53','','','5','PORT HARCOURT 2','053',333549.00,'2022-11-19 15:00:25',5,'CASH TO BANK\'\'A\'\'','969','975','2022-11-22 14:05:42','975','2022-11-22 14:17:29'),(80,'1','288','2022-10-20',1,'P.o.s','','10',91820.00,'52/53','','','6','PORT HARCOURT 2','0052/53',0.00,'2022-11-19 15:06:04',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-22 14:17:29'),(81,'1','288','2022-10-20',1,'052','','2',130000.00,'52','','','','','',0.00,'2022-11-19 15:15:22',0,'WEIGHT AND MEASURE','969','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82,'1','288','2022-10-21',1,'E BILLS','','5',374460.00,'54','','','5','PORT HARCOURT 2','054',487626.00,'2022-11-19 15:23:28',5,'CASH TO BANK\'\'M\'\'','969','975','2022-11-22 14:08:07','975','2022-11-22 14:13:01'),(83,'1','288','2022-10-21',1,'E BILLS','','5',234230.00,'55','','','5','PORT HARCOURT 2','055',286324.20,'2022-11-19 15:25:48',5,'CASH TO BANK\'\'A\'\'','969','','0000-00-00 00:00:00','975','2022-12-02 12:48:32'),(84,'1','288','2022-10-21',1,'P.o.s','','10',138560.00,'54/55','','','6','PORT HARCOURT 2','0054/55',0.00,'2022-11-19 15:29:16',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-22 14:13:01'),(85,'1','288','2022-10-22',1,'E BILLS','','5',407230.00,'56','','','5','PORT HARCOURT 2','056',511861.20,'2022-11-19 15:34:04',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-11-22 14:13:01'),(86,'1','288','2022-10-22',1,'E BILLS','','5',391660.00,'57','','','5','PORT HARCOURT 2','057',468252.00,'2022-11-19 15:36:16',5,'CASH TO BANK\'\'A\'\'','969','','0000-00-00 00:00:00','975','2022-11-22 14:13:01'),(87,'1','288','2022-10-22',1,'P.o.s','','10',152231.00,'56/57','','','6','PORT HARCOURT 2','0057',0.00,'2022-11-19 15:42:49',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-22 14:13:01'),(88,'1','288','2022-10-22',1,'058','','2',5000.00,'58','','','','','',0.00,'2022-11-19 15:46:53',5,'HAULAGE SERVICE RAN-850-XA','969','','0000-00-00 00:00:00','975','2022-11-29 15:19:25'),(89,'1','288','2022-10-23',1,'E BILLS','','5',286360.00,'58','','','5','PORT HARCOURT 2','058',405060.00,'2022-11-19 16:00:01',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-11-22 14:13:01'),(90,'1','288','2022-10-23',1,'E BILLS','','5',242270.00,'59','','','5','PORT HARCOURT 2','059',430756.20,'2022-11-19 16:10:30',5,'CASH TO BANK\'\'A\'\'','969','','0000-00-00 00:00:00','975','2022-11-22 14:13:01'),(91,'1','288','2022-10-23',1,'P.o.s','','10',278483.00,'58/59','','','6','PORT HARCOURT 2','0059',0.00,'2022-11-19 16:12:33',5,'U.B.A.POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-22 14:13:01'),(92,'1','288','2022-10-24',1,'E BILLS','','5',317740.00,'60','','','5','PORT HARCOURT 2','060',520897.20,'2022-11-19 16:19:15',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-11-22 14:15:51'),(93,'1','288','2022-10-24',1,'E BILLS','','5',379350.00,'61','','','5','PORT HARCOURT 2','061',473650.20,'2022-11-19 16:21:50',5,'CASH TO BANK\'\'A\'\'','969','','0000-00-00 00:00:00','975','2022-11-22 14:15:51'),(94,'1','288','2022-10-24',1,'P.o.s','','10',245396.00,'60/61','','','6','PORT HARCOURT 2','0061',0.00,'2022-11-19 16:24:18',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-22 14:15:51'),(95,'1','288','2022-10-24',1,'061','','2',28000.00,'061','','','','','',0.00,'2022-11-19 16:30:53',5,'HAULAGE SERVICE RAN-850XA','969','','0000-00-00 00:00:00','975','2022-11-29 15:19:25'),(96,'1','288','2022-10-25',1,'E BILLS','','5',302991.00,'62','','','5','PORT HARCOURT 2','062',410183.80,'2022-11-19 16:33:45',5,'CASH TO BANK\'\'M\'\'','969','975','2022-11-22 14:18:02','975','2022-11-22 14:19:06'),(97,'1','288','2022-10-25',1,'E BILLS','','5',320998.00,'63','','','5','PORT HARCOURT 2','063',407072.80,'2022-11-19 16:39:29',5,'CASH TO BANK\'\'A\'\'','969','','0000-00-00 00:00:00','975','2022-11-22 14:15:51'),(98,'1','288','2022-10-25',1,'P.o.s','','10',169274.00,'62/63','','','6','PORT HARCOURT 2','0063',0.00,'2022-11-19 16:41:26',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-22 14:15:51'),(99,'1','288','2022-10-26',1,'E BILLS','','5',399730.00,'64','','','5','PORT HARCOURT 2','064',534994.80,'2022-11-19 16:43:24',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-11-22 14:20:25'),(100,'1','288','2022-10-26',1,'E BILLS','','5',306815.00,'65','','','5','PORT HARCOURT 2','065',370902.80,'2022-11-19 16:50:37',5,'CASH TO BANK\'\'A\'\'','969','','0000-00-00 00:00:00','975','2022-11-22 14:20:25'),(101,'1','288','2022-10-26',1,'P.o.s','','10',175328.00,'64/65','','','6','PORT HARCOURT 2','0065',0.00,'2022-11-19 16:52:47',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-22 14:20:25'),(102,'1','288','2022-10-27',1,'E BILLS','','5',369291.00,'66','','','5','PORT HARCOURT 2','066',532491.00,'2022-11-19 16:56:42',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-11-22 14:20:25'),(103,'1','288','2022-10-27',1,'E BILLS','','5',327779.00,'67','','','5','PORT HARCOURT 2','067',427194.00,'2022-11-19 16:58:10',5,'CASH TO BANK\'\'A\'\'','969','','0000-00-00 00:00:00','975','2022-11-22 14:20:25'),(104,'1','288','2022-10-27',1,'P.o.s','','10',238615.00,'66/67','','','6','PORT HARCOURT 2','0067',0.00,'2022-11-19 16:59:58',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-22 14:20:25'),(105,'1','288','2022-10-28',1,'E BILLS','','5',286119.00,'68','','','5','PORT HARCOURT 2','068',443119.20,'2022-11-19 17:04:12',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-11-22 14:20:25'),(106,'1','288','2022-10-28',1,'E BILLS','','5',340526.00,'69','','','5','PORT HARCOURT 2','069',409296.60,'2022-11-19 17:05:46',5,'CASH TO BANK\'\'A\'\'','969','975','2022-11-22 14:21:05','975','2022-11-22 14:22:04'),(107,'1','288','2022-10-28',1,'P.o.s','','10',201770.00,'68/69','','','6','PORT HARCOURT 2','0069',0.00,'2022-11-19 17:07:52',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-22 14:22:04'),(108,'1','288','2022-10-29',1,'E BILLS','','5',339645.00,'70','','','5','PORT HARCOURT 2','070',489195.60,'2022-11-19 17:09:55',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-11-22 14:22:37'),(109,'1','288','2022-10-29',1,'E BILLS','','5',338197.00,'71','','','5','PORT HARCOURT 2','071',424929.60,'2022-11-19 17:12:12',5,'CASH TO BANK\'\'A\'\'','969','','0000-00-00 00:00:00','975','2022-11-22 14:22:37'),(110,'1','288','2022-10-29',1,'P.o.s','','10',212282.00,'70/71','','','6','PORT HARCOURT 2','0071',0.00,'2022-11-19 17:14:25',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-22 14:22:37'),(111,'1','288','2022-10-30',1,'E BILLS','','5',239065.00,'72','','','5','PORT HARCOURT 2','072',391221.60,'2022-11-19 17:16:28',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-11-22 14:23:29'),(112,'1','288','2022-10-30',1,'E BILLS','','5',233205.00,'73','','','5','PORT HARCOURT 2','073',296204.40,'2022-11-19 17:18:30',5,'CASH TO BANK\'\'A\'\'','969','','0000-00-00 00:00:00','975','2022-11-22 14:23:29'),(113,'1','288','2022-10-30',1,'P.o.s','','10',189160.00,'72/73','','','6','PORT HARCOURT 2','0073',0.00,'2022-11-19 17:21:11',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-22 14:23:29'),(114,'1','288','2022-10-31',1,'E BILLS','','5',18635.00,'74','','','5','PORT HARCOURT 2','074',347884.80,'2022-11-19 17:23:46',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-11-22 14:23:29'),(115,'1','288','2022-10-31',1,'P.o.s','','10',305249.00,'74','','','6','PORT HARCOURT 2','0074',0.00,'2022-11-19 17:26:39',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-22 14:23:28'),(116,'1','288','2022-11-08',1,'E BILLS','','5',40000.00,'75','','','5','PORT HARCOURT 2','075',40000.00,'2022-11-24 11:35:35',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-11-25 12:18:14'),(117,'1','288','2022-11-17',1,'CREDIT NOTE','','2',8250000.00,'76','','','','','',8250000.00,'2022-11-25 19:03:32',5,'E.F.C.C','969','','0000-00-00 00:00:00','975','2022-11-29 15:05:18'),(118,'1','288','2022-11-18',1,'E BILLS','','5',9100.00,'77','','','5','PORT HARCOURT 2','077',9075.00,'2022-11-25 19:06:40',5,'CASH TO BANK\'\'M\'\'','969','975','2022-12-02 12:48:16','975','2022-12-02 12:48:32'),(119,'1','288','2022-11-23',1,'E BILLS','','5',63475.00,'78','','','5','PORT HARCOURT 2','0558643',63475.00,'2022-11-28 15:35:30',5,'CASH TO BANK \'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-11-29 15:05:18'),(120,'1','288','2022-11-23',1,'CREDIT NOTE','','2',34400.00,'78','','','','','',0.00,'2022-11-28 15:39:52',5,'HAULAGE SERVICE KMC-667-ZE','969','','0000-00-00 00:00:00','975','2022-11-29 15:05:18'),(121,'1','288','2022-11-23',1,'CREDIT NOTE','','2',34400.00,'78','','','','','',0.00,'2022-11-28 15:43:00',5,'HAULAGE SERVICE TRN-23-YZ','969','','0000-00-00 00:00:00','975','2022-11-29 15:05:31'),(122,'1','288','2022-11-25',1,'E BILLS','','5',161900.00,'79','','','5','PORT HARCOURT 2','0558644',215054.70,'2022-11-28 15:47:16',5,'CASH TO BANK\'\'M\'\'','969','975','2022-11-29 15:07:08','975','2022-11-29 15:08:18'),(123,'1','288','2022-11-25',1,'P.o.s','','10',23800.00,'79','','','6','PORT HARCOURT 2','079',0.00,'2022-11-28 15:50:54',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-30 17:07:02'),(124,'1','288','2022-11-26',1,'E BILLS','','5',458010.00,'80','','','5','PORT HARCOURT 2','0558645',616308.00,'2022-11-28 15:57:21',5,'CASH TO BANK\'\'M\'\'','969','975','2022-11-29 15:08:57','975','2022-11-29 15:12:43'),(125,'1','288','2022-11-26',1,'E BILLS','','5',296130.00,'81','','','5','PORT HARCOURT 2','0558647',340783.80,'2022-11-28 16:07:28',5,'CASH TO BANK\'\'A\'\'','969','','0000-00-00 00:00:00','975','2022-11-29 15:12:43'),(126,'1','288','2022-11-26',1,'P.o.s','','10',171500.00,'81','','','6','PORT HARCOURT 2','80/81',0.00,'2022-11-28 16:11:16',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-30 17:07:02'),(127,'1','288','2022-11-27',1,'E BILLS','','5',281300.00,'82','','','5','PORT HARCOURT 2','0558646',338778.30,'2022-11-28 16:14:44',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-11-29 15:18:13'),(128,'1','288','2022-11-27',1,'E BILLS','','5',393860.00,'83','','','5','PORT HARCOURT 2','0558642',853927.20,'2022-11-28 16:19:04',5,'CASH TO BANK\'\'A\'\'','969','','0000-00-00 00:00:00','975','2022-11-29 15:18:12'),(129,'1','288','2022-11-27',1,'P.o.s','','10',336770.30,'83','','','6','PORT HARCOURT 2','82/83',0.00,'2022-11-28 16:23:10',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-11-30 17:07:02'),(130,'1','288','2022-11-27',1,'CREDIT NOTE','','2',80000.00,'83','','','','','',0.00,'2022-11-29 11:46:48',5,'E.F.C.C','969','','0000-00-00 00:00:00','975','2022-11-29 15:18:12'),(131,'1','288','2022-11-28',1,'E BILLS','','5',488375.00,'84','','','5','PORT HARCOURT 2','084',574975.80,'2022-12-01 13:45:14',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-12-02 12:16:35'),(132,'1','288','2022-11-28',1,'E BILLS','','5',406035.00,'85','','','5','PORT HARCOURT 2','085',436033.50,'2022-12-01 13:48:54',5,'CASH TO BANK\'\'A\'\'','969','','0000-00-00 00:00:00','975','2022-12-02 12:16:35'),(133,'1','288','2022-11-28',1,'85','','10',114600.00,'84/85','','','6','PORT HARCOURT 2','0085',0.00,'2022-12-01 13:51:21',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-12-02 12:16:35'),(134,'1','288','2022-11-29',1,'E BILLS','','5',502780.00,'86','','','5','PORT HARCOURT 2','0549400',651966.00,'2022-12-01 13:53:14',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-12-02 12:23:35'),(135,'1','288','2022-11-29',1,'E BILLS','','5',566920.00,'87','','','5','PORT HARCOURT 2','0549398',611442.30,'2022-12-01 13:55:53',5,'CASH TO BANK \'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-12-02 12:23:34'),(136,'1','288','2022-11-29',1,'P.o.s','','10',183312.00,'86/87','','','6','PORT HARCOURT 2','087',0.00,'2022-12-01 15:06:44',5,'U.B.A.POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-12-02 12:23:34'),(137,'1','288','2022-11-30',1,'E BILLS','','5',740190.00,'88','','','5','PORT HARCOURT 2','0458555',848261.40,'2022-12-01 15:09:17',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-12-02 12:24:20'),(138,'1','288','2022-11-30',1,'E BILLS','','5',594030.00,'89','','','5','PORT HARCOURT 2','0458554',648062.10,'2022-12-01 15:10:47',5,'CASH TO BANK\'\'A\'\'','969','','0000-00-00 00:00:00','975','2022-12-02 12:24:20'),(139,'1','288','2022-11-30',1,'P.o.s','','10',160101.00,'88/89','','','6','PORT HARCOURT 2','089',0.00,'2022-12-01 15:13:18',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-12-02 12:24:20'),(140,'1','288','2022-12-01',1,'E BILLS','','5',840350.00,'90','','','5','PORT HARCOURT 2','0668477',952228.20,'2022-12-02 16:30:53',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-12-06 12:04:47'),(141,'1','288','2022-12-01',1,'E BILLS','','5',550425.00,'91','','','5','PORT HARCOURT 2','0668476',661626.00,'2022-12-02 16:33:04',5,'CASH TO BANK\'\'A\'\'','969','','0000-00-00 00:00:00','975','2022-12-06 12:04:47'),(142,'1','288','2022-12-01',1,'P.o.s','','10',195900.00,'90/91','','','6','PORT HARCOURT 2','091',0.00,'2022-12-02 16:35:10',5,'U.B.A0POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-12-08 14:32:08'),(143,'1','288','2022-12-02',1,'E BILLS','','5',1091150.00,'92','','','5','PORT HARCOURT 2','0668468',1095129.00,'2022-12-05 15:11:40',5,'CASH TO BANK\'\'M\'\'','969','975','2022-12-06 12:05:43','975','2022-12-06 12:07:17'),(144,'1','288','2022-12-02',1,'E BILLS','','5',728705.00,'93','','','5','PORT HARCOURT 2','0558669',1024932.30,'2022-12-05 15:13:30',5,'CASH TO BANK\'\'A\'\'','969','975','2022-12-12 14:01:27','975','2022-12-12 14:09:46'),(145,'1','288','2022-12-02',1,'P.o.s','','10',5500.00,'92/93','','','6','PORT HARCOURT 2','093',0.00,'2022-12-05 15:15:43',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-12-08 14:30:49'),(146,'1','288','2022-12-02',1,'CREDIT NOTE','','2',34400.00,'93','','','','','',0.00,'2022-12-05 15:22:59',5,'HAULAGE SERVICE RAN 849 XA 35 LTRS OF A.G.O + 5000 FOR FEEDING ALLOWANCE','969','','0000-00-00 00:00:00','975','2022-12-06 12:07:17'),(147,'1','288','2022-12-03',1,'E BILLS','','5',728705.00,'94','','','5','PORT HARCOURT 2','0558670',728704.20,'2022-12-05 15:24:52',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-12-06 12:08:14'),(148,'1','288','2022-12-03',1,'E BILLS','','5',445145.00,'95','','','5','PORT HARCOURT 2',' 0558672',480345.60,'2022-12-05 15:33:58',5,'CASH TO BANK\'\'A\'\'','969','','0000-00-00 00:00:00','975','2022-12-06 12:08:14'),(149,'1','288','2022-12-04',1,'E BILLS','','5',471700.00,'96','','','5','PORT HARCOURT 2','0558671',471695.70,'2022-12-05 15:36:53',5,'CASH TO BANK\'\'M\'\'','969','975','2022-12-06 12:10:35','975','2022-12-06 12:11:15'),(150,'1','288','2022-12-04',1,'E BILLS','','5',425820.00,'97','','','5','PORT HARCOURT 2','0668465',456221.70,'2022-12-05 15:38:18',5,'CASH TO BANK\'\'A\'\'','969','','0000-00-00 00:00:00','975','2022-12-06 12:11:15'),(151,'1','288','2022-12-05',1,'E BILLS','','5',707500.00,'98','','','5','PORT HARCOURT 2','098',733890.00,'2022-12-07 15:40:12',5,'CASH TO BANK\'\'M\'\'','969','975','2022-12-12 14:11:39','975','2022-12-12 14:11:53'),(153,'1','288','2022-12-06',1,'E BILLS','','5',310560.00,'99','','','5','PORT HARCOURT 2','099',704660.10,'2022-12-07 15:44:59',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-12-13 16:33:13'),(154,'1','288','2022-12-06',1,'CREDIT NOTE','','2',26400.00,'99','','','','','',0.00,'2022-12-07 15:46:21',5,'A.G.O CONSUMPTION[30 LTRS]','969','','0000-00-00 00:00:00','975','2022-12-15 10:22:35'),(163,'1','288','2022-12-01',1,'CREDIT NOTE','','2',25200.00,'91','','','','','',0.00,'2022-12-08 12:52:18',5,'A.G..O CONSUMPTION','969','','0000-00-00 00:00:00','975','2022-12-15 10:22:35'),(164,'1','288','2022-12-03',1,'CREDIT NOTE','','2',25200.00,'95','','','','','',0.00,'2022-12-08 13:08:49',5,'AGO CONSUMPTION[30LTRS]','969','','0000-00-00 00:00:00','975','2022-12-15 10:22:35'),(165,'1','288','2022-12-04',1,'CREDIT NOTE','','2',26400.00,'97','','','','','',0.00,'2022-12-08 13:18:17',5,'AGO CONSUMPTION [30LTRS]@880','969','','0000-00-00 00:00:00','975','2022-12-15 10:22:35'),(166,'1','288','2022-12-05',1,'CREDIT NOTE','','2',26400.00,'98','','','','','',0.00,'2022-12-08 13:22:06',5,'AGO CONSUMPTION[30LTRS]@880','969','','0000-00-00 00:00:00','975','2022-12-15 10:22:35'),(167,'1','288','2022-12-02',1,'CREDIT NOTE','','2',26400.00,'93','','','','','',0.00,'2022-12-08 13:25:10',5,'AGO CONSUMPTION[30LTRS]@880','969','975','2022-12-12 14:14:11','975','2022-12-15 10:22:35'),(171,'1','288','2022-12-02',1,'E BILLS','','5',235125.00,'93','','','5','PORT HARCOURT 2','000093',0.00,'2022-12-09 15:45:01',5,'CASH TO BANK\'\'A\'\'','969','975','2022-12-12 14:02:50','975','2022-12-12 14:09:46'),(172,'1','288','2022-12-03',1,'E BILLS','','5',6020.00,'95','','','5','PORT HARCOURT 2','0095',0.00,'2022-12-09 15:48:38',5,'CASH TO BANK\'\'A\'\'','969','975','2022-12-12 14:15:12','975','2022-12-12 14:15:31'),(173,'1','288','2022-09-23',1,'E BILLS','','5',154500.00,'01','','','5','PORT HARCOURT 2','01',0.00,'2022-12-13 14:22:58',5,'CASH TO BANK\'\'M\'\' FOR FREE TCKET 505.9LTRS','969','975','2022-12-13 16:17:23','975','2022-12-13 16:17:56'),(176,'1','288','2022-10-03',1,'E BILLS','','5',23900.00,'19','','','5','PORT HARCOURT 2','019',0.00,'2022-12-13 14:58:35',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-12-13 16:20:09'),(177,'1','288','2022-10-04',1,'E BILLS','','5',16400.00,'21','','','5','PORT HARCOURT 2','021',0.00,'2022-12-13 15:00:21',5,'CASH TO BANK\'\'A\'\'','969','','0000-00-00 00:00:00','975','2022-12-13 16:21:53'),(178,'1','288','2022-10-05',1,'E BILLS','','5',30000.00,'23','','','5','PORT HARCOURT 2','023',0.00,'2022-12-13 15:02:50',5,'CASH TO BANK\'\'A\'\'','969','','0000-00-00 00:00:00','975','2022-12-13 16:22:56'),(179,'1','288','2022-10-06',1,'E BILLS','','5',15000.00,'25','','','5','PORT HARCOURT 2','025',0.00,'2022-12-13 15:11:12',5,'CASH TO BANK\'\'A\'\'','969','','0000-00-00 00:00:00','975','2022-12-13 16:24:30'),(180,'1','288','2022-10-11',1,'E BILLS','','5',77000.00,'34','','','5','PORT HARCOURT 2','034',0.00,'2022-12-13 15:14:32',5,'CASH TO BANK\'\'M\'\' 100LTRS FOR AGO @770','969','','0000-00-00 00:00:00','975','2022-12-13 16:31:27'),(181,'1','288','2022-10-11',1,'E BILLS','','5',12300.00,'34','','','5','PORT HARCOURT 2','0034',0.00,'2022-12-13 15:16:40',5,'CASH TO BANK\'\'M\'\'','969','975','2022-12-13 16:32:21','975','2022-12-13 16:32:40'),(182,'1','288','2022-10-11',1,'E BILLS','','5',10600.00,'35','','','5','PORT HARCOURT 2','035',0.00,'2022-12-13 15:18:06',5,'CASH TO BANK\'\'A\'\'','969','','0000-00-00 00:00:00','975','2022-12-13 16:31:27'),(183,'1','288','2022-10-12',1,'E BILLS','','5',8000.00,'36','','','5','PORT HARCOURT 2','036',0.00,'2022-12-13 15:20:26',5,'CASH TO BANK\'\'M\'\'','969','','0000-00-00 00:00:00','975','2022-12-13 16:32:40'),(184,'1','288','2022-12-06',1,'P.o.s','','10',367700.00,'99','','','6','PORT HARCOURT 2','99',0.00,'2022-12-13 16:39:22',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-12-13 16:46:47'),(185,'1','288','2022-12-03',1,'P.o.s','','10',5000.00,'94','','','6','PORT HARCOURT 2','094',0.00,'2022-12-25 17:15:02',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2022-12-27 10:55:58'),(187,'1','288','2023-03-03',1,'CREDIT NOTE','','2',212500.00,'100','','','','','',1448516.95,'2023-03-03 16:19:13',5,'HAULAGE SERVICE BCH-426-XA[250LTRS]+TRIP ALLOWANCE N10,000=212,500','969','975','2023-03-08 14:23:41','975','2023-03-08 14:28:37'),(189,'1','288','2023-03-03',1,'P.o.s','','10',1039182.25,'187','','','6','PORT HARCOURT 2','0187',0.00,'2023-03-07 18:53:51',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2023-03-11 17:02:33'),(191,'1','288','2023-03-02',1,'CREDIT NOTE','','2',24300.00,'186','','','','','',5694300.00,'2023-03-07 18:59:31',5,'A.G.O CONSUMPTION FOR GEN ','969','975','2023-03-08 14:19:28','975','2023-03-10 11:06:43'),(192,'1','288','2023-03-03',1,'CREDIT NOTE','','2',170100.00,'187','','','','','',0.00,'2023-03-07 19:02:31',5,'A.G.O CONSUMPTION FOR ONE[ 1]WEEK','969','','0000-00-00 00:00:00','975','2023-03-10 11:06:43'),(193,'1','288','2023-03-04',1,'P.o.s','','10',1105320.00,'104','','','6','PORT HARCOURT 2','0104',1155690.05,'2023-03-07 19:12:32',5,'U.B\'A POS PAYMENT','969','','0000-00-00 00:00:00','975','2023-03-11 17:03:06'),(194,'1','288','2023-03-05',1,'E BILLS','','5',6230.00,'105','','','5','PORT HARCOURT 2','0105',1447919.60,'2023-03-10 11:28:34',5,'CASH TO BE TRANSFER TO shagamu account','969','975','2023-03-16 15:03:20','975','2023-03-16 15:05:42'),(195,'1','288','2023-03-06',1,'E BILLS','','5',135000.00,'106','','','5','PORT HARCOURT 2','0106',1584710.75,'2023-03-10 11:32:48',5,'CASH TO BE TRANSFER TO shagamu account','969','975','2023-03-16 15:04:55','975','2023-03-16 15:05:42'),(196,'1','288','2023-03-07',1,'E BILLS','','5',117125.00,'107','','','5','PORT HARCOURT 2','0107',1877266.95,'2023-03-10 11:36:07',5,'CASH TO BE TRANSFER TO 3053956063 FIRST BNK','969','','0000-00-00 00:00:00','975','2023-03-15 14:25:27'),(197,'1','288','2023-03-08',1,'E BILLS','','5',312470.00,'108','','','5','PORT HARCOURT 2','0108',2325889.00,'2023-03-10 11:41:33',5,'CASH TO BE TRANFER TO ','969','975','2023-03-15 14:28:39','975','2023-03-15 14:28:50'),(198,'1','288','2023-03-10',1,'E BILLS','','5',78230.00,'109','','','5','PORT HARCOURT 2','0109',1147808.00,'2023-03-10 11:46:30',5,'CASH TO BE TRANFER TO 3053956063 FIRST BANK','969','','0000-00-00 00:00:00','975','2023-03-15 14:25:27'),(199,'1','288','2023-03-10',1,'E BILLS','','5',2895.00,'110','','','5','PORT HARCOURT 2','0110',1634998.40,'2023-03-11 12:38:36',5,'CASH TO BE PAID TO 3053956063 FIRST BANK ','969','','0000-00-00 00:00:00','975','2023-03-15 14:27:35'),(200,'1','288','2023-03-05',1,'P.o.s','','10',1441690.00,'105','','','6','PORT HARCOURT 2','105',0.00,'2023-03-11 12:45:23',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2023-03-11 17:03:24'),(201,'1','288','2023-03-06',1,'P.o.s','','10',1449408.00,'106','','','6','PORT HARCOURT 2','106',0.00,'2023-03-11 12:47:37',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2023-03-11 17:03:45'),(202,'1','288','2023-03-07',1,'P.o.s','','10',1760143.00,'107','','','6','PORT HARCOURT 2','107',0.00,'2023-03-11 12:50:49',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2023-03-11 17:04:03'),(203,'1','288','2023-03-08',1,'P.o.s','','10',2013426.00,'108','','','6','PORT HARCOURT 2','108',0.00,'2023-03-11 12:55:49',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2023-03-11 17:04:18'),(204,'1','288','2023-03-09',1,'P.o.s','','10',1069580.00,'109','','','6','PORT HARCOURT 2','109',0.00,'2023-03-11 12:59:29',5,'U.B.A  POS PAYMENT','969','','0000-00-00 00:00:00','975','2023-03-16 15:10:04'),(205,'1','288','2023-03-10',1,'P.o.s','','10',1632100.00,'110','','','6','PORT HARCOURT 2','110',0.00,'2023-03-11 13:00:56',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2023-03-16 15:10:04'),(206,'1','288','2023-03-11',1,'E BILLS','','5',29775.00,'111','','','5','PORT HARCOURT 2','0111',1634869.15,'2023-03-12 13:43:48',5,'CASH TO BE PAID TO ','969','','0000-00-00 00:00:00','975','2023-03-15 15:22:46'),(207,'1','288','2023-03-11',1,'P.o.s','','10',1605095.00,'111','','','6','PORT HARCOURT 2','111',0.00,'2023-03-12 14:21:10',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2023-03-16 15:14:46'),(209,'1','288','2023-03-12',1,'E BILLS','','5',18505.00,'112','','','5','PORT HARCOURT 2','0112',1618732.55,'2023-03-13 10:01:08',5,'CASH TO BE PAID TO 3053956063 FIRST BNK','969','','0000-00-00 00:00:00','975','2023-03-16 15:14:46'),(210,'1','288','2023-03-12',1,'P.o.s','','10',1432226.00,'112','','','6','PORT HARCOURT 2','112',0.00,'2023-03-13 10:02:47',5,'U.B.A POS PAYMENT ','969','','0000-00-00 00:00:00','975','2023-03-16 15:14:46'),(211,'1','288','2023-03-12',1,'CREDIT NOTE','','2',168000.00,'112','','','','','',0.00,'2023-03-13 10:04:14',5,'A.G,O CONSUMPTION 210 LTRS FOR 1 WEEK','969','','0000-00-00 00:00:00','975','2023-03-16 15:14:46'),(212,'1','288','2023-03-13',1,'E BILLS','','5',240100.00,'113','','','5','PORT HARCOURT 2','0113',1514412.85,'2023-03-14 08:11:46',5,'CASH TO BE PAID TO ','969','975','2023-03-16 15:16:25','975','2023-03-16 15:17:26'),(213,'1','288','2023-03-13',1,'P.o.s','','10',1274321.00,'113','','','6','PORT HARCOURT 2','113',0.00,'2023-03-14 08:16:12',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2023-03-16 15:14:45'),(214,'1','288','2023-03-14',1,'E BILLS','','5',4300.00,'114','','','5','PORT HARCOURT 2','0114',877631.00,'2023-03-15 08:08:55',5,'CASH BTO BE PAID TO 3053956063 ','969','','0000-00-00 00:00:00','975','2023-03-16 15:17:26'),(215,'1','288','2023-03-14',1,'P.o.s','','10',859850.00,'114','','','6','PORT HARCOURT 2','114',0.00,'2023-03-15 08:11:01',5,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','975','2023-03-16 15:18:30'),(216,'1','288','2023-03-15',1,'E BILLS','','5',50905.00,'115','','','5','PORT HARCOURT 2','0115',1081843.65,'2023-03-16 07:19:21',0,'CASH TO BANK \'\'D\'\'','969','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(217,'1','288','2023-03-15',1,'P.o.s','','10',1030940.00,'115','','','6','PORT HARCOURT 2','115',0.00,'2023-03-16 07:21:10',0,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(218,'1','288','2023-03-03',1,'E BILLS','','5',26735.00,'187','','','5','PORT HARCOURT 2','187',0.00,'2023-03-16 15:27:34',5,'CASH TO BANK \'\'D\'\'','969','','0000-00-00 00:00:00','975','2023-03-17 14:24:24'),(219,'1','288','2023-03-04',1,'E BILLS','','5',50371.00,'104','','','5','PORT HARCOURT 2','104',0.00,'2023-03-16 15:32:06',5,'CASH TO  BANK\'\'D\'\'','969','975','2023-03-17 14:24:46','975','2023-03-17 14:24:55'),(220,'1','288','2023-03-14',1,'CREDIT NOTE','','2',13000.00,'114','','','','','',0.00,'2023-03-16 15:34:01',0,'CARTON OF POS PAPER','969','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(221,'1','288','2023-03-16',1,'E BILLS','','5',365765.00,'116','','','5','PORT HARCOURT 2','0116',2383059.80,'2023-03-17 16:11:52',0,'CASH TO BANK \'\'D\'\'','969','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(222,'1','288','2023-03-16',1,'P.o.s','','10',2017292.00,'116','','','6','PORT HARCOURT 2','116',0.00,'2023-03-17 16:13:10',0,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(223,'1','288','2023-03-17',1,'E BILLS','','5',100620.00,'117','','','5','PORT HARCOURT 2','0117',2750968.75,'2023-03-20 08:56:06',0,'CAH TO BANK\'\'D\'\'','969','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(224,'1','288','2023-03-17',1,'P.o.s','','10',2650358.00,'117','','','6','PORT HARCOURT 2','117',0.00,'2023-03-20 08:57:37',0,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(225,'1','288','2023-03-19',1,'E BILLS','','5',169635.00,'118','','','5','PORT HARCOURT 2','0118',2168055.05,'2023-03-20 10:19:20',0,'CASH TO BANK\'\'D\'\'','969','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(226,'1','288','2023-03-19',1,'CREDIT NOTE','','2',165900.00,'118','','','','','',0.00,'2023-03-20 10:21:41',0,'A.G.O CONSUMPTION 210 LTRS FOR 1  WEEK @ 790','969','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(227,'1','288','2023-03-19',1,'P.o.s','','10',1832522.00,'118','','','6','PORT HARCOURT 2','118',0.00,'2023-03-20 10:23:01',0,'U.B.A POS PAYMENT','969','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `purchases_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_receptions`
--

DROP TABLE IF EXISTS `purchases_receptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_receptions` (
  `bridge_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `purchase_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `loadingdate` datetime NOT NULL,
  `loadingpoint` varchar(100) DEFAULT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `received` decimal(20,2) NOT NULL,
  `distributed` decimal(20,2) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `vessel` varchar(50) NOT NULL,
  `drivername` varchar(30) NOT NULL,
  `driverphone` varchar(30) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`bridge_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`supplier_id`,`loadingdate`,`quantity`,`waybill`,`meterno`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`purchase_id`),
  KEY `truck_id` (`tank_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_receptions`
--

LOCK TABLES `purchases_receptions` WRITE;
/*!40000 ALTER TABLE `purchases_receptions` DISABLE KEYS */;
INSERT INTO `purchases_receptions` VALUES (4,'1',2,'288',1,1,'2022-10-27 00:00:00','portharcourt ',49200.00,49200.00,0.00,'','','1','NSR 70 ZQ','','','pms discharged',5,'2022-10-27 17:37:24','969','0000-00-00 00:00:00','','2022-10-27 17:37:54','969'),(5,'1',3,'288',2,1,'2022-10-27 00:00:00','portharcourt ',19600.00,19600.00,0.00,'','','2','NSR 70 ZQ','Mustapha Abubakar','08034493242','A.G.O Discharged',5,'2022-10-27 19:52:01','969','0000-00-00 00:00:00','','2022-11-10 17:38:50','969'),(6,'1',4,'288',1,1,'2022-10-27 00:00:00','portharcourt ',50000.00,50000.00,0.00,'','','1','RAN 850 XA','Abdullahi','08022862872','pms discharged',5,'2022-10-27 19:56:09','969','0000-00-00 00:00:00','','2022-11-10 17:39:14','969'),(7,'1',5,'288',1,1,'2022-11-15 00:00:00','portharcourt ',50000.00,50000.00,0.00,'','','1','RAN 849 XA','AMMAR','09164644145','',5,'2022-11-15 10:49:04','969','0000-00-00 00:00:00','','2022-11-15 10:49:28','969'),(8,'1',6,'288',1,1,'2022-11-27 00:00:00','portharcourt ',60000.00,60000.00,0.00,'','','1','TRN 23 YZ','IBRAHIM','08035017737','',5,'2022-11-27 07:01:05','969','0000-00-00 00:00:00','','2022-11-27 07:12:25','969'),(9,'1',7,'288',1,1,'2023-03-04 00:00:00','WARRI',50000.00,50000.00,0.00,'','','1','BCH 462 XA','AUWALU SHARU','08032079401','PMS DISCHARGE',2,'2023-03-04 14:52:43','969','2023-03-04 19:25:43','969','2023-03-04 14:55:29','969'),(10,'1',7,'288',1,1,'2023-03-04 00:00:00','WARRI',50000.00,50000.00,0.00,'','','1','BCH 462 XA','AUWALU SHARU','08032079401','PMS DISCHARGE',5,'2023-03-04 22:31:32','969','0000-00-00 00:00:00','','2023-03-04 22:32:20','969'),(11,'1',8,'288',1,1,'2023-03-10 00:00:00','WARRI',45000.00,45000.00,0.00,'','','1','RAN-831-XA','IBRAHIM BIN ABUBAKAR','08028712336','pms discharged',5,'2023-03-10 17:40:30','969','0000-00-00 00:00:00','','2023-03-10 17:42:51','969'),(12,'1',9,'288',1,1,'2023-03-16 00:00:00','WARRI',45000.00,45000.00,0.00,'','','1','KKM 196 XA','ALIYU AHMAD','07030952095','PMS DISCHARGE',5,'2023-03-16 08:51:28','969','0000-00-00 00:00:00','','2023-03-16 08:52:30','969');
/*!40000 ALTER TABLE `purchases_receptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports`
--

DROP TABLE IF EXISTS `reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `type` varchar(20) NOT NULL,
  `sql` text NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`report_id`),
  KEY `companycode` (`company_id`,`name`,`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports`
--

LOCK TABLES `reports` WRITE;
/*!40000 ALTER TABLE `reports` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_fields`
--

DROP TABLE IF EXISTS `reports_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(20) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `fieldname` varchar(50) NOT NULL,
  `order` int NOT NULL,
  `visibility` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`report_id`,`field_id`,`order`,`visibility`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_fields`
--

LOCK TABLES `reports_fields` WRITE;
/*!40000 ALTER TABLE `reports_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_filters`
--

DROP TABLE IF EXISTS `reports_filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_filters` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(50) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `filter_id` int NOT NULL AUTO_INCREMENT,
  `criteria` varchar(20) NOT NULL,
  `value` varchar(100) NOT NULL,
  PRIMARY KEY (`filter_id`),
  KEY `companycode` (`company_id`,`report_id`),
  KEY `field_id` (`field_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_filters`
--

LOCK TABLES `reports_filters` WRITE;
/*!40000 ALTER TABLE `reports_filters` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_filters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_customers`
--

DROP TABLE IF EXISTS `retail_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_customers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`name`,`phone`,`email`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_customers`
--

LOCK TABLES `retail_customers` WRITE;
/*!40000 ALTER TABLE `retail_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory`
--

DROP TABLE IF EXISTS `retail_inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` int NOT NULL,
  `qtyout` int NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory`
--

LOCK TABLES `retail_inventory` WRITE;
/*!40000 ALTER TABLE `retail_inventory` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_balances`
--

DROP TABLE IF EXISTS `retail_inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_balances`
--

LOCK TABLES `retail_inventory_balances` WRITE;
/*!40000 ALTER TABLE `retail_inventory_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_costs`
--

DROP TABLE IF EXISTS `retail_inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_costs`
--

LOCK TABLES `retail_inventory_costs` WRITE;
/*!40000 ALTER TABLE `retail_inventory_costs` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products`
--

DROP TABLE IF EXISTS `retail_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`name`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `parent_id` (`parent_id`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products`
--

LOCK TABLES `retail_products` WRITE;
/*!40000 ALTER TABLE `retail_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_prices`
--

DROP TABLE IF EXISTS `retail_products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_prices`
--

LOCK TABLES `retail_products_prices` WRITE;
/*!40000 ALTER TABLE `retail_products_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_reconciliations`
--

DROP TABLE IF EXISTS `retail_products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_reconciliations`
--

LOCK TABLES `retail_products_reconciliations` WRITE;
/*!40000 ALTER TABLE `retail_products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_purchases`
--

DROP TABLE IF EXISTS `retail_purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_purchases`
--

LOCK TABLES `retail_purchases` WRITE;
/*!40000 ALTER TABLE `retail_purchases` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales`
--

DROP TABLE IF EXISTS `retail_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `saledate` date NOT NULL,
  `customer_id` varchar(20) NOT NULL DEFAULT '',
  `customer_name` varchar(50) NOT NULL,
  `customer_phone` varchar(30) NOT NULL,
  `quantity_kg` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `payment_method` varchar(10) NOT NULL,
  `payment_account_type` varchar(20) NOT NULL,
  `payment_account_id` varchar(20) NOT NULL,
  `paid` decimal(20,2) DEFAULT NULL,
  `change` decimal(20,2) DEFAULT '0.00',
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`customer_name`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `payment_method` (`payment_method`,`payment_account_type`,`payment_account_id`),
  KEY `customer_id` (`customer_id`),
  KEY `change` (`change`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales`
--

LOCK TABLES `retail_sales` WRITE;
/*!40000 ALTER TABLE `retail_sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_items`
--

DROP TABLE IF EXISTS `retail_sales_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `product_type` varchar(10) NOT NULL,
  `product_name` varchar(100) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `quantity_2` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `parent_cost` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`sale_id`,`product_id`,`rate`,`quantity`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`product_type`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `parent_id` (`parent_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_items`
--

LOCK TABLES `retail_sales_items` WRITE;
/*!40000 ALTER TABLE `retail_sales_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_payments`
--

DROP TABLE IF EXISTS `retail_sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_payments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `payment_method` varchar(50) NOT NULL,
  `account_type` varchar(10) DEFAULT NULL,
  `account_id` bigint DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`sale_id`,`payment_method`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`account_type`),
  KEY `parent_id` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_payments`
--

LOCK TABLES `retail_sales_payments` WRITE;
/*!40000 ALTER TABLE `retail_sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales`
--

DROP TABLE IF EXISTS `sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `is_credit` int NOT NULL DEFAULT '0',
  `saledate` date NOT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `paid` int NOT NULL,
  `details` text NOT NULL,
  `ledger_notes` varchar(150) DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`product_id`,`customer_id`,`rate`,`quantity`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`is_credit`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales`
--

LOCK TABLES `sales` WRITE;
/*!40000 ALTER TABLE `sales` DISABLE KEYS */;
INSERT INTO `sales` VALUES (1,'1','288','76',1,'2022-11-25',2,1,825.00,825.00,10000.00,0.00,0.00,8250000.00,'1669385241','2022-11-25 15:07:21',15,0,'','','969','','0000-00-00 00:00:00','648','2022-11-25 17:36:17'),(2,'1','288','100',1,'2023-03-02',2,2,810.00,810.00,7000.00,0.00,0.00,5670000.00,'1677765338','2023-03-02 14:55:38',15,0,'','','969','','0000-00-00 00:00:00','648','2023-03-03 09:58:29');
/*!40000 ALTER TABLE `sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_daily`
--

DROP TABLE IF EXISTS `sales_daily`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_daily` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `saledate` date NOT NULL,
  `average` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `target` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`average`,`saledate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_daily`
--

LOCK TABLES `sales_daily` WRITE;
/*!40000 ALTER TABLE `sales_daily` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_daily` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions`
--

DROP TABLE IF EXISTS `sales_distributions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions` (
  `distribution_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `sale_id` int NOT NULL,
  `purchase_id` varchar(20) NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `loadingdate` date NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `destination` varchar(50) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `truckno` varchar(20) NOT NULL,
  `drivername` varchar(50) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`distribution_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`loadingdate`,`quantity`,`destination`,`waybill`,`meterno`,`nozzle_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`tank_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `truckno` (`truckno`),
  KEY `purchase_id_2` (`purchase_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions`
--

LOCK TABLES `sales_distributions` WRITE;
/*!40000 ALTER TABLE `sales_distributions` DISABLE KEYS */;
INSERT INTO `sales_distributions` VALUES (1,'1',1,'',0,'288',2,1,'2022-11-25',10000.00,'','','','2','9','','','Dispensed on shift # 76',5,'2022-11-25 17:36:17','648','0000-00-00 00:00:00','','2022-11-25 17:36:17','648'),(2,'1',2,'',0,'288',2,2,'2023-03-03',7000.00,'','','','2','9','','','Dispensed on shift # 100',5,'2023-03-03 09:58:29','648','0000-00-00 00:00:00','','2023-03-03 09:58:29','648');
/*!40000 ALTER TABLE `sales_distributions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_delivery`
--

DROP TABLE IF EXISTS `sales_distributions_delivery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_delivery` (
  `delivery_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `distribution_id` int NOT NULL,
  `sale_id` int NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `quantity` int NOT NULL,
  `truck_id` int NOT NULL,
  `deliveredon` date NOT NULL,
  `details` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`delivery_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`quantity`,`thedate`,`createdby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`truck_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `distribution_id` (`distribution_id`),
  KEY `deliveredon` (`deliveredon`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_delivery`
--

LOCK TABLES `sales_distributions_delivery` WRITE;
/*!40000 ALTER TABLE `sales_distributions_delivery` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_delivery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_trucks`
--

DROP TABLE IF EXISTS `sales_distributions_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_trucks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sale_id` varchar(20) NOT NULL,
  `distribution_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `bridge_id` varchar(20) NOT NULL,
  `truck_id` varchar(20) NOT NULL,
  `driver_id` varchar(20) NOT NULL,
  `quantity` int NOT NULL,
  `destination` varchar(150) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `companycode` (`company_id`,`distribution_id`,`truck_id`),
  KEY `sale_id` (`sale_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_trucks`
--

LOCK TABLES `sales_distributions_trucks` WRITE;
/*!40000 ALTER TABLE `sales_distributions_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_fueltickets`
--

DROP TABLE IF EXISTS `sales_fueltickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_fueltickets` (
  `ticket_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `ticketdate` date NOT NULL,
  `code` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `allowance` decimal(10,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `truck_number` varchar(20) NOT NULL,
  `truck_capacity` int NOT NULL,
  `truck_provider` varchar(50) NOT NULL,
  `truck_from` varchar(50) NOT NULL,
  `truck_destination` varchar(50) NOT NULL,
  `driver_name` varchar(50) NOT NULL,
  `driver_phone` varchar(50) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`ticket_id`),
  KEY `companycode` (`company_id`,`ticketdate`,`product_id`,`truck_number`,`rate`,`quantity`,`status`),
  KEY `paid` (`truck_provider`),
  KEY `invoice` (`code`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_fueltickets`
--

LOCK TABLES `sales_fueltickets` WRITE;
/*!40000 ALTER TABLE `sales_fueltickets` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_fueltickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_payments`
--

DROP TABLE IF EXISTS `sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `customer_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`customer_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_payments`
--

LOCK TABLES `sales_payments` WRITE;
/*!40000 ALTER TABLE `sales_payments` DISABLE KEYS */;
INSERT INTO `sales_payments` VALUES (1,'1','288','2022-11-17',1,'CREDIT NOTE','','2',80000.00,'','','','','PORT HARCOURT 2','','2022-11-27 07:21:26',0,'380.95 LTRS PMS','969','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_cashbacks`
--

DROP TABLE IF EXISTS `shifts_cashbacks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_cashbacks` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `regno` varchar(100) DEFAULT NULL,
  `cashdate` date NOT NULL,
  `driver` varchar(100) DEFAULT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`cashdate`,`driver`,`customer_id`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`regno`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_cashbacks`
--

LOCK TABLES `shifts_cashbacks` WRITE;
/*!40000 ALTER TABLE `shifts_cashbacks` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_cashbacks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_remittance`
--

DROP TABLE IF EXISTS `shifts_remittance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_remittance` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `paymentdate` date NOT NULL,
  `method` int DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paidby` varchar(50) DEFAULT NULL,
  `paidto` varchar(100) DEFAULT NULL,
  `bank` bigint unsigned DEFAULT NULL,
  `depositor` varchar(100) DEFAULT NULL,
  `teller` varchar(100) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  `reversed_at` datetime DEFAULT NULL,
  `reversed_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`paymentdate`,`method`,`bank`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_remittance`
--

LOCK TABLES `shifts_remittance` WRITE;
/*!40000 ALTER TABLE `shifts_remittance` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_remittance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers`
--

DROP TABLE IF EXISTS `suppliers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers` (
  `supplier_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`supplier_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers`
--

LOCK TABLES `suppliers` WRITE;
/*!40000 ALTER TABLE `suppliers` DISABLE KEYS */;
INSERT INTO `suppliers` VALUES (1,'1','288','AA RANO NIGERIA LTD','MUHAMMAD ABDUL SULE','0803540199','mrmohasul@gmail.com','KANO','KANO','No 7 Maiduguri Road,Opposite NNPC Depot. Kano Nigeria','Nigeria',0.00,0.00,'0000-00-00','2022-10-19 11:01:05',5,'178','2022-10-19 11:01:05','178');
/*!40000 ALTER TABLE `suppliers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers_status`
--

DROP TABLE IF EXISTS `suppliers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `supplier_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers_status`
--

LOCK TABLES `suppliers_status` WRITE;
/*!40000 ALTER TABLE `suppliers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `suppliers_status` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-03-21  2:54:18
