-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_287
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_287`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_287` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_287`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,8000,'',0,'24','1','287','PURCHASES','','2022-10-19 10:56:19',5,0.00,0.00,'','178','2022-10-19 10:56:19','178',0,0),(2,8001,'',0,'24','1','287','SALARIES','','2022-10-19 10:56:25',5,0.00,0.00,'','178','2022-10-19 10:56:25','178',0,0),(3,7000,'',0,'20','1','287','SALES','','2022-10-19 10:56:41',5,0.00,0.00,'','178','2022-10-19 10:56:41','178',0,0),(4,500,'',0,'6.1','1','287','CASH','','2022-10-19 10:56:51',5,0.00,0.00,'','178','2022-10-19 10:56:51','178',0,0),(5,2500,'',0,'2','1','287','1020879289 UBA EBILLS','','2022-11-01 13:57:02',5,0.00,0.00,'','975','2022-11-01 13:57:02','975',0,0),(6,2501,'',0,'2','1','287','UBA POS','','2022-11-01 13:57:20',5,0.00,0.00,'','975','2022-11-01 13:57:20','975',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','1','287','NIGERIA POLICE FORCE (ELECTION','OHELCA ROWLAND','08038166331','dopstransport@gmail.come','porthercourt','REVERS','PORTHARCUORT','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-21 16:44:37',5,'975','2023-02-21 16:44:37','975');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','287',1,'2',2940.87,3159.00,'2022-11-14','','2022-11-14 11:06:36','648','648',2022,'648','2022-11-14 11:06:36',5),('1','287',2,'1',277.07,587.00,'2022-11-27','','2022-11-27 15:44:29','648','648',2022,'648','2022-11-27 15:44:29',5),('1','287',3,'4',15345.55,4493.00,'2023-03-15','','2023-03-15 09:07:52','648','648',2023,'648','2023-03-15 09:07:52',5),('1','287',4,'4',4493.00,15350.00,'2023-03-15','','2023-03-15 09:10:57','648','648',2023,'648','2023-03-15 09:10:57',5),('1','287',5,'1',4346.71,4493.00,'2023-03-15','','2023-03-15 09:11:38','648','648',2023,'648','2023-03-15 09:11:38',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','287','1',1,'5','PUMP 1',66338.45,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-22 13:41:12','178'),('1','287','1',2,'5','PUMP 2',60625.41,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-22 13:41:37','178'),('1','287','1',3,'5','PUMP 3',65570.17,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-22 13:41:59','178'),('1','287','1',4,'5','PUMP 4',61555.19,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-22 13:42:28','178'),('1','287','2',5,'5','PUMP 5',103931.59,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-22 13:43:27','178'),('1','287','2',6,'5','PUMP 6',49830.54,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-22 13:43:54','178'),('1','287','3',7,'5','PUMP 7',109096.09,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-22 13:47:36','178'),('1','287','3',8,'5','PUMP 8',73571.87,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-22 13:47:59','178'),('1','287','4',9,'5','AGO PUMP 1',234952.00,'DISPENSING AGO','',NULL,NULL,'',5,'2022-10-22 13:49:51','178');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=121 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','287',1,'MORNING ','2022-09-21','2022-10-27 14:29:17','2022-10-28 14:29:17','968',0.00,0.00,'968','2022-10-28 08:29:46','648','2022-10-28 08:31:08',10,0),('1','287',2,'DAY SHIFT','2022-09-21','2022-10-28 08:50:27','2022-11-04 08:50:27','968',0.00,0.00,'968','2022-10-28 08:57:11','648','2022-10-28 09:03:04',10,0),('1','287',3,'DAY SHIFT','2022-09-21','2022-10-28 09:05:18','2022-10-29 09:05:18','968',592057.80,592057.80,'968','2022-10-28 09:06:54','648','2022-10-28 09:13:13',10,0),('1','287',4,'DAY SHIFT','2022-09-22','2022-10-28 09:15:13','2022-10-29 09:15:13','968',1044462.60,1044462.60,'968','2022-10-28 09:21:29','648','2022-10-28 09:30:32',10,0),('1','287',5,'MORNING SHIFT','2022-09-23','2022-10-28 11:20:17','2022-10-29 11:20:17','968',809145.00,809145.00,'968','2022-10-28 21:15:10','648','2022-10-29 08:34:54',10,0),('1','287',6,'AFTERNOON SHIFT','2022-09-23','2022-10-29 09:06:25','2022-10-30 09:06:25','968',723850.20,723850.20,'968','2022-10-29 09:09:43','648','2022-10-29 09:17:35',10,0),('1','287',7,'MORNING SHIFT','2022-09-24','2022-10-29 09:22:40','2022-10-30 09:22:40','968',647643.60,647643.60,'968','2022-10-29 09:28:20','648','2022-10-29 09:33:52',10,0),('1','287',8,'AFTERNOON SHIFT','2022-09-24','2022-10-29 10:01:19','2022-10-30 10:01:19','968',492969.60,492969.60,'968','2022-10-29 10:05:32','648','2022-10-29 10:27:34',10,0),('1','287',9,'MORNING SHIFT','2022-09-25','2022-10-29 10:31:20','2022-10-30 10:31:20','968',671328.00,671328.00,'968','2022-10-29 10:53:28','648','2022-10-29 10:55:36',10,0),('1','287',10,'AFTERNOON SHIFT','2022-09-25','2022-10-29 11:04:27','2022-10-30 11:04:27','968',692247.60,692247.60,'968','2022-10-29 11:07:51','648','2022-10-29 11:17:27',10,0),('1','287',11,'MORNING SHIFT','2022-09-26','2022-10-29 13:38:53','2022-10-30 13:38:53','968',580806.00,580806.00,'968','2022-10-29 14:17:03','648','2022-10-30 11:13:03',10,0),('1','287',12,'AFTERNOON SHIFT','2022-09-26','2022-10-30 11:23:09','2022-10-31 11:23:09','968',646309.80,646309.80,'968','2022-10-30 11:29:16','648','2022-10-30 11:33:23',10,0),('1','287',13,'MORNING SHIFT','2022-09-27','2022-10-30 11:38:49','2022-10-31 11:38:49','968',649638.00,649638.00,'968','2022-10-30 12:50:43','648','2022-10-30 13:01:58',10,0),('1','287',14,'AFTERNOON SHIFT','2022-09-27','2022-10-30 14:04:48','2022-10-31 14:04:48','968',597324.60,597324.60,'968','2022-10-30 14:10:08','648','2022-10-30 14:23:09',10,0),('1','287',15,'MORNING SHIFT','2022-09-28','2022-10-30 15:14:28','2022-10-31 15:14:28','968',390495.60,390495.60,'968','2022-10-30 17:22:37','648','2022-10-30 23:07:04',10,0),('1','287',16,'AFTERNOON SHIFT','2022-09-28','2022-11-01 08:44:57','2022-11-02 08:44:57','968',207176.40,207176.40,'968','2022-11-01 08:46:54','648','2022-11-01 09:09:19',10,0),('1','287',17,'MORNING SHIFT','2022-09-29','2022-11-01 09:38:13','2022-11-02 09:38:13','968',690136.20,690136.20,'968','2022-11-01 09:41:40','648','2022-11-01 18:06:41',10,0),('1','287',18,'AFTERNOON SHIFT','2022-09-29','2022-11-01 19:38:32','2022-11-02 19:38:32','968',605701.10,605701.10,'968','2022-11-01 20:03:30','648','2022-11-01 20:44:44',10,0),('1','287',19,'DAY SHIFT','2022-09-30','2022-11-02 15:28:08','2022-11-03 15:28:08','968',531770.40,531770.40,'968','2022-11-02 15:32:24','648','2022-11-02 18:58:52',10,0),('1','287',20,'DAY SHIFT','2022-10-04','2022-11-02 20:38:05','2022-11-03 20:38:05','968',417297.60,417297.60,'968','2022-11-02 20:52:06','648','2022-11-03 07:44:23',10,0),('1','287',21,'MORNING SHIFT','2022-10-05','2022-11-03 08:03:29','2022-11-04 08:03:29','968',458814.40,458814.40,'968','2022-11-03 08:12:43','648','2022-11-03 09:03:40',10,0),('1','287',22,'AFTERNOON SHIFT','2022-10-05','2022-11-03 11:02:06','2022-11-04 11:02:06','968',546832.80,546832.80,'968','2022-11-03 11:07:51','648','2022-11-03 14:01:16',10,0),('1','287',23,'MORNING SHIFT','2022-10-06','2022-11-03 20:47:24','2022-11-04 20:47:24','968',485026.20,485026.20,'968','2022-11-03 20:50:45','648','2022-11-06 11:16:15',10,0),('1','287',24,'AFTERNOON SHIFT','2022-10-06','2022-11-06 11:37:48','2022-11-07 11:37:48','968',778116.10,778116.10,'968','2022-11-06 11:55:16','648','2022-11-06 14:21:24',10,0),('1','287',25,'MORNING SHIFT','2022-10-07','2022-11-06 20:42:37','2022-11-07 20:42:37','968',530803.60,530803.60,'968','2022-11-06 20:44:44','648','2022-11-06 20:48:04',10,0),('1','287',26,'AFTERNOON SHIFT','2022-10-07','2022-11-06 20:50:45','2022-11-07 20:50:45','968',552670.20,552670.20,'968','2022-11-06 20:52:35','648','2022-11-06 20:56:22',10,0),('1','287',27,'MORNING SHIFT','2022-10-08','2022-11-06 20:58:00','2022-11-07 20:58:00','968',513605.10,513605.10,'968','2022-11-06 21:01:54','648','2022-11-06 21:04:08',10,0),('1','287',28,'AFTERNOON SHIFT','2022-10-09','2022-11-06 21:09:45','2022-11-07 21:09:45','968',0.00,0.00,'968','2022-11-06 21:19:02','648','2022-11-06 21:22:50',10,0),('1','287',29,'AFTERNOON SHIFT','2022-10-08','2022-11-06 21:24:01','2022-11-07 21:24:01','968',480798.00,480798.00,'968','2022-11-06 21:27:37','648','2022-11-07 08:21:44',10,0),('1','287',30,'MORNING SHIFT','2022-10-09','2022-11-08 12:16:26','2022-11-09 12:16:26','968',271107.00,271107.00,'968','2022-11-08 12:39:33','648','2022-11-08 13:03:37',10,0),('1','287',31,'AFTERNOON SHIFT','2022-10-09','2022-11-08 15:38:07','2022-11-09 15:38:07','968',623635.90,623635.90,'968','2022-11-08 15:42:02','648','2022-11-08 16:46:02',10,0),('1','287',32,'MORNING SHIFT','2022-10-10','2022-11-08 17:54:45','2022-11-09 17:54:45','968',306957.60,306957.60,'968','2022-11-09 14:57:41','648','2022-11-09 19:25:04',10,0),('1','287',33,'AFTERNOON SHIFT','2022-10-10','2022-11-10 07:42:53','2022-11-11 07:42:53','968',620698.10,620698.10,'968','2022-11-10 07:46:48','648','2022-11-10 10:21:59',10,0),('1','287',34,'MORNING SHIFT','2022-10-11','2022-11-10 10:28:06','2022-11-11 10:28:06','968',472718.00,472718.00,'968','2022-11-10 10:29:58','648','2022-11-10 10:30:38',10,0),('1','287',35,'AFTERNOON SHIFT','2022-10-11','2022-11-10 10:58:25','2022-11-11 10:58:25','968',589168.80,589168.80,'968','2022-11-10 11:00:01','648','2022-11-10 12:57:44',10,0),('1','287',36,'MORNING SHIFT','2022-10-12','2022-11-10 13:34:40','2022-11-11 13:34:40','968',423387.00,423387.00,'968','2022-11-10 13:38:52','648','2022-11-10 14:26:41',10,0),('1','287',37,'AFTERNOON SHIFT','2022-10-12','2022-11-10 15:35:56','2022-11-11 15:35:56','968',747431.80,747431.80,'968','2022-11-10 15:41:22','648','2022-11-10 15:52:24',10,0),('1','287',38,'MORNING SHIFT','2022-10-13','2022-11-10 15:58:13','2022-11-11 15:58:13','968',523011.40,523011.40,'968','2022-11-10 16:03:21','648','2022-11-10 16:11:28',10,0),('1','287',39,'AFTERNOON SHIFT','2022-10-13','2022-11-10 16:13:40','2022-11-11 16:13:40','968',708327.00,708327.00,'968','2022-11-10 16:19:30','648','2022-11-10 16:29:27',10,0),('1','287',40,'MORNING SHIFT','2022-10-14','2022-11-10 16:31:04','2022-11-11 16:31:04','968',618175.20,618175.20,'968','2022-11-10 16:36:28','648','2022-11-10 16:46:32',10,0),('1','287',41,'AFTERNOON SHIFT','2022-10-14','2022-11-10 16:56:52','2022-11-11 16:56:52','968',706804.50,706917.00,'968','2022-11-10 16:59:56','648','2022-11-10 17:07:49',10,0),('1','287',42,'MORNING SHIFT','2022-10-15','2022-11-10 17:09:54','2022-11-11 17:09:54','968',564460.00,565960.00,'968','2022-11-10 17:14:50','648','2022-11-10 17:37:42',10,0),('1','287',43,'AFTERNOON SHIFT','2022-10-15','2022-11-10 17:44:17','2022-11-11 17:44:17','968',784395.20,784515.20,'968','2022-11-10 17:48:04','648','2022-11-10 18:10:06',10,0),('1','287',44,'MORNING SHIFT','2022-10-16','2022-11-10 18:51:42','2022-11-11 18:51:42','968',940591.60,942091.60,'968','2022-11-10 18:55:12','648','2022-11-11 01:58:03',10,0),('1','287',45,'AFTERNOON SHIFT','2022-11-11','2022-11-11 07:57:35','2022-11-12 07:57:35','968',0.00,0.00,'968','2022-11-11 07:58:21','648','2022-11-11 10:36:44',10,0),('1','287',46,'AFTERNOON SHIFT','2022-10-16','2022-11-11 11:06:27','2022-11-12 11:06:27','968',1315629.00,1315629.00,'968','2022-11-11 12:29:56','648','2022-11-11 12:41:46',10,0),('1','287',47,'MORNING SHIFT','2022-10-17','2022-11-11 12:45:21','2022-11-12 12:45:21','968',545770.40,545770.40,'968','2022-11-11 12:47:49','648','2022-11-11 12:51:53',10,0),('1','287',48,'AFTERNOON SHIFT','2022-10-17','2022-11-11 12:53:16','2022-11-12 12:53:16','968',1118475.00,1118475.00,'968','2022-11-11 12:55:59','648','2022-11-11 13:14:01',10,0),('1','287',49,'MORNING SHIFT','2022-10-18','2022-11-11 13:15:32','2022-11-12 13:15:32','968',197573.40,197573.40,'968','2022-11-11 13:21:11','648','2022-11-11 15:02:13',10,0),('1','287',50,'AFTERNOON SHIFT','2022-10-10','2022-11-11 15:10:45','2022-11-12 15:10:45','968',0.00,0.00,'968','2022-11-11 15:19:23','648','2022-11-11 15:27:46',10,0),('1','287',51,'AFTERNOON SHIFT','2022-10-18','2022-11-11 15:29:34','2022-11-12 15:29:34','968',1840743.00,1840743.00,'968','2022-11-11 15:32:35','648','2022-11-11 15:37:40',10,0),('1','287',52,'MORNING SHIFT','2022-10-19','2022-11-11 15:38:37','2022-11-12 15:38:37','968',1165493.60,1165493.60,'968','2022-11-11 16:00:24','648','2022-11-11 16:03:16',10,0),('1','287',53,'AFTERNOON SHIFT','2022-10-19','2022-11-11 16:05:43','2022-11-12 16:05:43','968',1060119.00,1060119.00,'968','2022-11-11 16:10:52','648','2022-11-11 16:14:59',10,0),('1','287',54,'MORNING SHIFT','2022-10-20','2022-11-11 16:17:56','2022-11-12 16:17:56','968',1798374.00,1798374.00,'968','2022-11-11 16:22:20','648','2022-11-11 16:24:55',10,0),('1','287',55,'AFTERNOON SHIFT','2022-10-20','2022-11-11 16:26:04','2022-11-12 16:26:04','968',1106454.60,1106454.60,'968','2022-11-11 16:31:26','648','2022-11-11 16:41:28',10,0),('1','287',56,'MORNING SHIFT','2022-10-21','2022-11-11 16:50:24','2022-11-12 16:50:24','968',1018712.40,1018712.40,'968','2022-11-11 16:52:53','648','2022-11-11 16:57:13',10,0),('1','287',57,'AFTERNOON SHIFT','2022-10-21','2022-11-11 17:03:01','2022-11-12 17:03:01','968',1390849.20,1390849.20,'968','2022-11-11 17:06:54','648','2022-11-12 08:12:44',10,0),('1','287',58,'MORNING SHIFT','2022-10-22','2022-11-12 08:47:06','2022-11-13 08:47:06','968',1089337.20,1089337.20,'968','2022-11-12 09:00:04','648','2022-11-12 09:02:47',10,0),('1','287',59,'AFTERNOON SHIFT','2022-10-22','2022-11-12 09:06:33','2022-11-13 09:06:33','968',1245926.72,1245926.72,'968','2022-11-12 10:17:24','648','2022-11-12 10:25:51',10,0),('1','287',60,'MORNING SHIFT','2022-10-23','2022-11-12 10:29:33','2022-11-13 10:29:33','968',1057497.00,1057497.00,'968','2022-11-12 10:32:45','648','2022-11-12 10:38:16',10,0),('1','287',61,'AFTERNOON SHIFT','2022-10-23','2022-11-12 10:42:15','2022-11-13 10:42:15','968',1310617.80,1310617.80,'968','2022-11-12 10:46:17','648','2022-11-12 10:48:17',10,0),('1','287',62,'MORNING SHIFT','2022-10-24','2022-11-12 10:50:06','2022-11-13 10:50:06','968',1130013.60,1130013.60,'968','2022-11-12 10:53:33','648','2022-11-12 11:00:46',10,0),('1','287',63,'AFTERNOON SHIFT','2022-10-23','2022-11-12 11:02:49','2022-11-13 11:02:49','968',0.00,0.00,'968','2022-11-12 11:10:58','648','2022-11-12 11:13:52',10,0),('1','287',64,'AFTERNOON SHIFT','2022-10-24','2022-11-12 11:21:13','2022-11-13 11:21:13','968',1900447.20,1900447.20,'968','2022-11-12 11:27:52','648','2022-11-12 11:31:22',10,0),('1','287',65,'MORNING SHIFT','2022-10-25','2022-11-12 11:38:48','2022-11-13 11:38:48','968',1204751.40,1204751.40,'968','2022-11-12 11:46:36','648','2022-11-12 11:52:24',10,0),('1','287',66,'AFTERNOON SHIFT','2022-10-25','2022-11-12 11:55:05','2022-11-13 11:55:05','968',1407256.20,1407256.20,'968','2022-11-12 12:00:11','648','2022-11-12 12:02:44',10,0),('1','287',67,'MORNING SHIFT','2022-10-26','2022-11-12 12:05:49','2022-11-13 12:05:49','968',1418584.40,1418584.40,'968','2022-11-12 12:10:09','648','2022-11-12 12:23:33',10,0),('1','287',68,'AFTERNOON SHIFT','2022-10-26','2022-11-12 12:25:15','2022-11-13 12:25:15','968',1212283.80,1212283.80,'968','2022-11-12 12:29:33','648','2022-11-12 12:31:20',10,0),('1','287',69,'MORNING SHIFT','2022-10-27','2022-11-12 12:35:05','2022-11-13 12:35:05','968',956162.40,956162.40,'968','2022-11-12 12:39:40','648','2022-11-13 06:26:57',10,0),('1','287',70,'AFTERNOON SHIFT','2022-10-27','2022-11-13 07:19:44','2022-11-14 07:19:44','968',1038794.40,1038794.40,'968','2022-11-14 10:02:30','648','2022-11-14 10:13:20',10,0),('1','287',71,'MORNING SHIFT','2022-10-28','2022-11-14 10:15:02','2022-11-15 10:15:02','968',739370.40,739370.40,'968','2022-11-14 10:16:50','648','2022-11-14 10:22:12',10,0),('1','287',72,'AFTERNOON SHIFT','2022-10-28','2022-11-14 10:23:43','2022-11-15 10:23:43','968',958867.20,958867.20,'968','2022-11-14 10:25:18','648','2022-11-14 10:29:13',10,0),('1','287',73,'MORNING SHIFT','2022-10-29','2022-11-14 10:31:49','2022-11-15 10:31:49','968',725949.60,725949.60,'968','2022-11-14 10:33:45','648','2022-11-14 10:39:51',10,0),('1','287',74,'AFTERNOON SHIFT','2022-10-29','2022-11-14 10:41:00','2022-11-15 10:41:00','968',722791.80,722791.80,'968','2022-11-14 10:42:53','648','2022-11-14 10:46:43',10,0),('1','287',75,'DAY SHIFT','2022-10-30','2022-11-14 10:55:07','2022-11-15 10:55:07','968',592474.20,592474.20,'968','2022-11-14 11:10:03','648','2022-11-14 11:14:02',10,0),('1','287',76,'MORNING SHIFT','2022-11-16','2022-11-23 09:50:38','2022-11-24 09:50:38','968',0.00,0.00,'968','2022-11-24 09:35:32','648','2022-11-24 09:41:44',10,0),('1','287',77,'DAY SHIFT','2022-11-16','2022-11-24 09:54:11','2022-11-25 09:54:11','968',1509750.00,1509750.00,'968','2022-11-24 09:57:55','648','2022-11-24 11:21:47',10,0),('1','287',78,'MORNING SHIFT','2022-11-23','2022-11-24 11:58:10','2022-11-25 11:58:10','968',234796.80,234796.80,'968','2022-11-24 12:00:13','648','2022-11-25 07:53:06',10,0),('1','287',79,'AFTERNOON SHIFT','2022-11-23','2022-11-25 08:07:16','2022-11-26 08:07:16','968',2496261.60,2496261.60,'968','2022-11-25 08:17:23','648','2022-11-25 08:44:39',10,0),('1','287',80,'MORNING SHIFT','2022-11-24','2022-11-25 08:54:21','2022-11-26 08:54:21','968',2961806.40,2961806.40,'968','2022-11-25 09:03:25','648','2022-11-25 09:10:20',10,0),('1','287',81,'AFTERNOON SHIFT','2022-11-24','2022-11-25 09:24:24','2022-11-26 09:24:24','968',2213160.60,2213160.60,'968','2022-11-25 09:28:24','648','2022-11-25 17:32:20',10,0),('1','287',82,'MORNING SHIFT','2022-11-25','2022-11-26 07:47:22','2022-11-27 07:47:22','968',2280238.80,2280238.80,'968','2022-11-26 07:52:30','648','2022-11-26 07:59:39',10,0),('1','287',83,'AFTERNOON SHIFT','2022-11-25','2022-11-26 08:06:14','2022-11-27 08:06:14','968',2294667.90,2294667.90,'968','2022-11-26 08:12:10','648','2022-11-26 09:49:09',10,0),('1','287',84,'MORNING SHIFT','2022-11-25','2022-11-26 14:28:10','2022-11-27 14:28:10','968',2110348.80,2110348.80,'968','2022-11-26 14:32:55','648','2022-11-27 09:21:42',10,0),('1','287',85,'AFTERNOON SHIFT','2022-11-26','2022-11-27 09:38:01','2022-11-28 09:38:01','968',2737841.40,2737841.40,'968','2022-11-27 09:43:38','648','2022-11-27 14:43:45',10,0),('1','287',86,'MORNING SHIFT','2022-11-27','2022-11-27 15:11:11','2022-11-28 15:11:11','968',2440964.40,2440964.40,'968','2022-11-27 15:47:13','648','2022-11-27 15:52:56',10,0),('1','287',87,'AFTERNOON SHIFT','2022-11-27','2022-11-28 07:04:39','2022-11-29 07:04:39','968',2849408.10,2849408.10,'968','2022-11-28 07:08:32','648','2022-11-28 12:07:39',10,0),('1','287',88,'MORNING SHIFT','2022-11-28','2022-11-28 14:53:49','2022-11-29 14:53:49','968',1945051.50,1945051.50,'968','2022-11-28 14:56:41','648','2022-11-28 15:00:40',10,0),('1','287',89,'AFTERNOON SHIFT','2022-11-28','2022-11-29 06:43:17','2022-11-30 06:43:17','968',3014018.70,3014018.70,'968','2022-11-29 07:15:39','648','2022-11-29 11:16:25',10,0),('1','287',90,'MORNING SHIFT','2022-11-29','2022-11-29 14:23:40','2022-11-30 14:23:40','968',799173.90,799173.90,'968','2022-11-29 14:24:22','648','2022-11-29 16:54:09',10,0),('1','287',91,'AFTERNOON SHIFT','2022-11-29','2022-11-30 06:25:30','2022-12-01 06:25:30','968',445544.40,445544.40,'968','2022-11-30 07:06:23','648','2022-11-30 11:34:56',10,0),('1','287',92,'AFTERNOON SHIFT','2022-12-01','2022-12-02 08:14:34','2022-12-03 08:14:34','968',737595.60,737595.60,'968','2022-12-02 08:17:04','648','2022-12-02 10:19:52',10,0),('1','287',93,'MORNING SHIFT','2022-12-03','2022-12-03 13:56:46','2022-12-04 13:56:46','968',739200.00,739200.00,'968','2022-12-03 13:57:51','648','2022-12-03 21:44:47',10,0),('1','287',94,'AFTERNOON SHIFT','2022-12-03','2022-12-04 08:19:29','2022-12-05 08:19:29','968',984622.80,984622.80,'968','2022-12-04 08:20:56','648','2022-12-04 12:08:42',10,0),('1','287',95,'MORNING SHIFT','2022-12-14','2022-12-14 15:22:36','2022-12-15 15:22:36','968',299880.00,299880.00,'968','2022-12-14 15:23:56','648','2022-12-15 21:51:11',10,0),('1','287',96,'MORNING SHIFT','2022-12-17','2022-12-17 15:27:14','2022-12-18 15:27:14','968',235504.00,235504.00,'968','2022-12-17 15:33:19','648','2022-12-18 14:24:55',10,0),('1','287',97,'AFTERNOON SHIFT','2022-12-17','2022-12-19 07:49:03','2022-12-20 07:49:03','968',410598.60,410598.60,'968','2022-12-19 07:51:52','648','2022-12-21 08:00:29',10,0),('1','287',98,'DAY SHIFT','2022-12-18','2022-12-21 08:30:31','2022-12-22 08:30:31','968',290993.40,290993.40,'968','2022-12-21 08:31:07','648','2022-12-21 08:33:09',10,0),('1','287',99,'DAY SHIFT','2022-12-28','2022-12-29 08:38:20','2022-12-30 08:38:20','968',531237.00,531237.00,'968','2022-12-29 08:39:07','648','2022-12-29 09:24:42',10,0),('1','287',100,'DAY SHIFT','2023-01-19','2023-01-20 08:11:50','2023-01-21 08:11:50','968',1540480.00,1540480.00,'968','2023-01-20 08:13:29','648','2023-01-20 09:18:05',10,0),('1','287',101,'DAY SHIFT','2023-01-26','2023-01-27 07:38:42','2023-01-28 07:38:42','968',900002.20,900002.20,'968','2023-01-27 07:48:32','648','2023-01-27 09:51:58',10,0),('1','287',102,'DAY SHIFT','2023-01-31','2023-02-01 08:02:15','2023-02-02 08:02:15','968',437407.20,437407.20,'968','2023-02-01 08:03:26','648','2023-02-01 14:34:43',10,0),('1','287',103,'DAY SHIFT','2023-02-04','2023-02-05 08:21:18','2023-02-06 08:21:18','968',171698.60,171698.60,'968','2023-02-05 08:21:52','648','2023-02-06 11:19:36',10,0),('1','287',104,'DAY SHIFT','2023-02-05','2023-02-06 12:31:17','2023-02-07 12:31:17','968',250003.40,250003.40,'968','2023-02-06 12:33:17','648','2023-02-06 16:57:27',10,0),('1','287',105,'DAY SHIFT','2023-02-06','2023-02-07 07:57:57','2023-02-08 07:57:57','968',148837.50,148837.50,'968','2023-02-07 07:59:09','648','2023-02-08 08:08:27',10,0),('1','287',106,'DAY SHIFT','2023-02-11','2023-02-11 08:01:24','2023-02-12 08:01:24','968',48600.00,48600.00,'968','2023-02-11 08:02:28','648','2023-02-11 15:04:44',10,0),('1','287',107,'DAY SHIFT','2023-02-15','2023-02-16 08:05:35','2023-02-17 08:05:35','968',388597.50,388597.50,'968','2023-02-16 08:08:00','648','2023-02-16 09:18:13',10,0),('1','287',108,'DAY SHIFT','2023-03-02','2023-03-03 08:36:08','2023-03-04 08:36:08','968',2746665.65,2746665.65,'968','2023-03-03 08:42:14','648','2023-03-03 09:57:05',10,0),('1','287',109,'DAY SHIFT','2023-03-03','2023-03-04 10:56:25','2023-03-05 10:56:25','968',2494781.15,2494781.15,'968','2023-03-04 10:59:04','648','2023-03-04 11:28:51',10,0),('1','287',110,'DAY SHIFT','2023-03-04','2023-03-05 08:00:44','2023-03-06 08:00:44','968',1903697.40,1903697.40,'968','2023-03-05 08:03:57','648','2023-03-06 23:22:14',10,0),('1','287',111,'DAY SHIFT','2023-03-06','2023-03-07 08:08:05','2023-03-08 08:08:05','968',3131783.90,3131783.90,'968','2023-03-07 08:11:42','648','2023-03-07 11:31:06',10,0),('1','287',112,'DAY SHIFT','2023-03-07','2023-03-08 07:58:52','2023-03-09 07:58:52','968',1931288.75,1931288.75,'968','2023-03-08 08:05:34','648','2023-03-08 09:46:03',10,0),('1','287',113,'DAY SHIFT','2023-03-08','2023-03-09 08:02:53','2023-03-10 08:02:53','968',2946037.00,2946037.00,'968','2023-03-09 08:09:29','648','2023-03-09 10:17:48',10,0),('1','287',114,'DAY SHIFT','2023-03-09','2023-03-10 08:19:52','2023-03-11 08:19:52','968',2215723.35,2215723.35,'968','2023-03-10 08:25:15','648','2023-03-10 09:30:19',10,0),('1','287',115,'DAY SHIFT','2023-03-10','2023-03-11 09:22:39','2023-03-12 09:22:39','968',2029142.75,2029142.75,'968','2023-03-11 09:25:00','648','2023-03-11 17:03:13',10,0),('1','287',116,'DAY SHIFT','2023-03-11','2023-03-12 08:16:52','2023-03-13 08:16:52','968',3383654.55,3383654.55,'968','2023-03-12 09:05:16','648','2023-03-12 21:55:31',10,0),('1','287',117,'MORNING SHIFT','2023-03-13','2023-03-14 07:59:48','2023-03-15 07:59:48','968',2812250.95,2812250.95,'968','2023-03-14 08:02:38','648','2023-03-14 08:27:28',10,0),('1','287',118,'AFTERNOON SHIFT','2023-03-14','2023-03-15 08:02:56','2023-03-16 08:02:56','968',2938663.50,2938663.50,'968','2023-03-15 09:21:15','648','2023-03-15 18:09:27',10,0),('1','287',119,'MORNING SHIFT','2023-03-15','2023-03-16 08:13:33','2023-03-17 08:13:33','968',2919651.95,2919651.95,'968','2023-03-16 08:18:45','648','2023-03-16 09:08:02',10,0),('1','287',120,'AFTERNOON SHIFT','2023-03-17','2023-03-19 13:47:52','2023-03-20 13:47:52','968',3923543.55,3923543.55,'968','2023-03-20 09:05:50','','0000-00-00 00:00:00',5,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=1081 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','287','1','1',1,'1','1',5659.57,5659.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','1',2,'2','1',5607.93,5607.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','1',3,'3','1',5554.99,5554.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','1',4,'4','1',5222.77,5222.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','1',5,'5','1',5321.48,5321.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','1',6,'6','1',5208.41,5208.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','1',7,'7','1',5719.71,5719.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','1',8,'8','1',5714.68,5714.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','1',9,'9','2',214497.55,214497.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','2',10,'1','1',5659.57,5659.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','2',11,'2','1',5607.93,5607.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','2',12,'3','1',5554.99,5554.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','2',13,'4','1',5222.77,5222.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','2',14,'5','1',5321.48,5321.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','2',15,'6','1',5208.41,5208.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','2',16,'7','1',5719.71,5719.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','2',17,'8','1',5714.68,5714.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','2',18,'9','2',214497.55,214497.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','3',19,'1','1',5659.57,6738.21,1078.64,194155.20,0.00,0.00,0.00,0.00,0.00),('1','287','1','3',20,'2','1',5607.93,5607.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','3',21,'3','1',5554.99,6225.29,670.30,120654.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','3',22,'4','1',5222.77,5222.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','3',23,'5','1',5321.48,6440.16,1118.68,201362.40,0.00,0.00,0.00,0.00,0.00),('1','287','2','3',24,'6','1',5208.41,5208.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','3',25,'7','1',5719.71,6141.30,421.59,75886.20,0.00,0.00,0.00,0.00,0.00),('1','287','3','3',26,'8','1',5714.68,5714.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','3',27,'9','2',214497.55,214497.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','4',28,'1','1',6738.21,8811.41,2073.20,373176.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','4',29,'2','1',5607.93,5607.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','4',30,'3','1',6225.29,7362.05,1136.76,204616.80,0.00,0.00,0.00,0.00,0.00),('1','287','1','4',31,'4','1',5222.77,5222.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','4',32,'5','1',6440.16,8520.98,2080.82,374547.60,0.00,0.00,0.00,0.00,0.00),('1','287','2','4',33,'6','1',5208.41,5208.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','4',34,'7','1',6141.30,6667.95,511.78,92120.40,0.00,0.00,14.87,0.00,0.00),('1','287','3','4',35,'8','1',5714.68,5795.63,0.01,1.80,0.00,0.00,80.94,0.00,0.00),('1','287','4','4',36,'9','2',214497.55,214497.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','5',37,'1','1',8811.41,8811.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','5',38,'2','1',5607.93,5607.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','5',39,'3','1',7362.05,9289.67,1927.62,346971.60,0.00,0.00,0.00,0.00,0.00),('1','287','1','5',40,'4','1',5222.77,5222.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','5',41,'5','1',8520.98,9484.80,963.82,173487.60,0.00,0.00,0.00,0.00,0.00),('1','287','2','5',42,'6','1',5208.41,5762.70,554.29,99772.20,0.00,0.00,0.00,0.00,0.00),('1','287','3','5',43,'7','1',6667.95,7717.47,1049.52,188913.60,0.00,0.00,0.00,0.00,0.00),('1','287','3','5',44,'8','1',5795.63,5795.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','5',45,'9','2',214497.55,214497.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','6',46,'1','1',8811.41,8811.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','6',47,'2','1',5607.93,5607.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','6',48,'3','1',9289.67,10776.36,1486.69,267604.20,0.00,0.00,0.00,0.00,0.00),('1','287','1','6',49,'4','1',5222.77,5222.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','6',50,'5','1',9484.80,10728.60,1243.80,223884.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','6',51,'6','1',5762.70,6382.79,620.09,111616.20,0.00,0.00,0.00,0.00,0.00),('1','287','3','6',52,'7','1',7717.47,8388.28,670.81,120745.80,0.00,0.00,0.00,0.00,0.00),('1','287','3','6',53,'8','1',5795.63,5795.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','6',54,'9','2',214497.55,214497.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','7',55,'1','1',8811.41,8811.69,0.00,0.00,0.00,0.00,0.28,0.00,0.00),('1','287','1','7',56,'2','1',5607.93,5607.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','7',57,'3','1',10776.36,11672.23,895.87,161256.60,0.00,0.00,0.00,0.00,0.00),('1','287','1','7',58,'4','1',5222.77,5325.49,102.72,18489.60,0.00,0.00,0.00,0.00,0.00),('1','287','2','7',59,'5','1',10728.60,10728.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','7',60,'6','1',6382.79,7444.07,1061.28,191030.40,0.00,0.00,0.00,0.00,0.00),('1','287','3','7',61,'7','1',8388.28,9246.71,858.43,154517.40,0.00,0.00,0.00,0.00,0.00),('1','287','3','7',62,'8','1',5795.63,6475.65,679.72,122349.60,0.00,0.00,0.30,0.00,0.00),('1','287','4','7',63,'9','2',214497.55,214497.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','8',64,'1','1',8811.69,9349.19,528.24,95083.20,0.00,0.00,9.26,0.00,0.00),('1','287','1','8',65,'2','1',5607.93,5621.29,0.00,0.00,0.00,0.00,13.36,0.00,0.00),('1','287','1','8',66,'3','1',11672.23,11672.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','8',67,'4','1',5325.49,5529.83,99.00,17820.00,0.00,0.00,105.34,0.00,0.00),('1','287','2','8',68,'5','1',10728.60,10833.94,105.34,18961.20,0.00,0.00,0.00,0.00,0.00),('1','287','2','8',69,'6','1',7444.07,8765.98,1321.91,237943.80,0.00,0.00,0.00,0.00,0.00),('1','287','3','8',70,'7','1',9246.71,9930.94,684.23,123161.40,0.00,0.00,0.00,0.00,0.00),('1','287','3','8',71,'8','1',6475.65,6496.66,0.00,0.00,0.00,0.00,21.01,0.00,0.00),('1','287','4','8',72,'9','2',214497.55,214497.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','9',73,'1','1',9349.19,10425.97,1066.78,192020.40,0.00,0.00,10.00,0.00,0.00),('1','287','1','9',74,'2','1',5621.29,5631.29,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','287','1','9',75,'3','1',11672.23,13268.57,1586.34,285541.20,0.00,0.00,10.00,0.00,0.00),('1','287','1','9',76,'4','1',5529.83,5539.83,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','287','2','9',77,'5','1',10833.94,11492.81,648.87,116796.60,0.00,0.00,10.00,0.00,0.00),('1','287','2','9',78,'6','1',8765.98,8795.67,19.69,3544.20,0.00,0.00,10.00,0.00,0.00),('1','287','3','9',79,'7','1',9930.94,10207.46,266.52,47973.60,0.00,0.00,10.00,0.00,0.00),('1','287','3','9',80,'8','1',6496.66,6648.06,141.40,25452.00,0.00,0.00,10.00,0.00,0.00),('1','287','4','9',81,'9','2',214497.55,214497.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','10',82,'1','1',10425.97,11612.66,1186.69,213604.20,0.00,0.00,0.00,0.00,0.00),('1','287','1','10',83,'2','1',5631.29,5631.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','10',84,'3','1',13268.57,13378.51,109.94,19789.20,0.00,0.00,0.00,0.00,0.00),('1','287','1','10',85,'4','1',5539.83,5539.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','10',86,'5','1',11492.81,12302.50,809.69,145744.20,0.00,0.00,0.00,0.00,0.00),('1','287','2','10',87,'6','1',8795.67,9592.29,796.62,143391.60,0.00,0.00,0.00,0.00,0.00),('1','287','3','10',88,'7','1',10207.46,11150.34,942.88,169718.40,0.00,0.00,0.00,0.00,0.00),('1','287','3','10',89,'8','1',6648.06,6648.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','10',90,'9','2',214497.55,214497.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','11',91,'1','1',11612.66,12646.33,1033.67,186060.60,0.00,0.00,0.00,0.00,0.00),('1','287','1','11',92,'2','1',5631.29,6271.68,640.39,115270.20,0.00,0.00,0.00,0.00,0.00),('1','287','1','11',93,'3','1',13378.51,13378.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','11',94,'4','1',5539.83,5539.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','11',95,'5','1',12302.50,13344.02,1041.52,187473.60,0.00,0.00,0.00,0.00,0.00),('1','287','2','11',96,'6','1',9592.29,9592.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','11',97,'7','1',11150.34,11661.46,511.12,92001.60,0.00,0.00,0.00,0.00,0.00),('1','287','3','11',98,'8','1',6648.06,6648.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','11',99,'9','2',214497.55,214497.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','12',100,'1','1',12646.33,14093.25,1446.92,260445.60,0.00,0.00,0.00,0.00,0.00),('1','287','1','12',101,'2','1',6271.68,6271.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','12',102,'3','1',13378.51,14112.30,683.79,123082.20,0.00,0.00,50.00,0.00,0.00),('1','287','1','12',103,'4','1',5539.83,5612.00,0.00,0.00,0.00,0.00,72.17,0.00,0.00),('1','287','2','12',104,'5','1',13344.02,14062.88,718.86,129394.80,0.00,0.00,0.00,0.00,0.00),('1','287','2','12',105,'6','1',9592.29,9626.71,0.00,0.00,0.00,0.00,34.42,0.00,0.00),('1','287','3','12',106,'7','1',11661.46,12402.50,741.04,133387.20,0.00,0.00,0.00,0.00,0.00),('1','287','3','12',107,'8','1',6648.06,6648.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','12',108,'9','2',214497.55,214497.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','13',109,'1','1',14093.25,15411.91,1318.66,237358.80,0.00,0.00,0.00,0.00,0.00),('1','287','1','13',110,'2','1',6271.68,6271.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','13',111,'3','1',14112.30,14906.02,793.72,142869.60,0.00,0.00,0.00,0.00,0.00),('1','287','1','13',112,'4','1',5612.00,5612.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','13',113,'5','1',14062.88,15229.69,1166.81,210025.80,0.00,0.00,0.00,0.00,0.00),('1','287','2','13',114,'6','1',9626.71,9626.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','13',115,'7','1',12402.50,12732.41,329.91,59383.80,0.00,0.00,0.00,0.00,0.00),('1','287','3','13',116,'8','1',6648.06,6648.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','13',117,'9','2',214497.55,214497.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','14',118,'1','1',15411.91,15411.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','14',119,'2','1',6271.68,7631.41,1359.73,244751.40,0.00,0.00,0.00,0.00,0.00),('1','287','1','14',120,'3','1',14906.02,14908.42,0.00,0.00,0.00,0.00,2.40,0.00,0.00),('1','287','1','14',121,'4','1',5612.00,5792.16,180.16,32428.80,0.00,0.00,0.00,0.00,0.00),('1','287','2','14',122,'5','1',15229.69,15229.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','14',123,'6','1',9626.71,10094.49,467.78,84200.40,0.00,0.00,0.00,0.00,0.00),('1','287','3','14',124,'7','1',12732.41,12768.51,36.10,6498.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','14',125,'8','1',6648.06,7922.76,1274.70,229446.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','14',126,'9','2',214497.55,214497.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','15',127,'1','1',15411.91,16151.86,739.95,133191.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','15',128,'2','1',7631.41,7631.42,0.00,0.00,0.00,0.00,0.01,0.00,0.00),('1','287','1','15',129,'3','1',14908.42,14909.18,0.76,136.80,0.00,0.00,0.00,0.00,0.00),('1','287','1','15',130,'4','1',5792.16,5792.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','15',131,'5','1',15229.69,15854.91,625.22,112539.60,0.00,0.00,0.00,0.00,0.00),('1','287','2','15',132,'6','1',10094.49,10104.63,0.00,0.00,0.00,0.00,10.14,0.00,0.00),('1','287','3','15',133,'7','1',12768.51,13295.80,527.29,94912.20,0.00,0.00,0.00,0.00,0.00),('1','287','3','15',134,'8','1',7922.76,8198.96,276.20,49716.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','15',135,'9','2',214497.55,214497.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','16',136,'1','1',16151.86,16380.13,228.27,41088.60,0.00,0.00,0.00,0.00,0.00),('1','287','1','16',137,'2','1',7631.42,7878.43,247.01,44461.80,0.00,0.00,0.00,0.00,0.00),('1','287','1','16',138,'3','1',14909.18,14909.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','16',139,'4','1',5792.16,5792.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','16',140,'5','1',15854.91,16295.03,440.12,79221.60,0.00,0.00,0.00,0.00,0.00),('1','287','2','16',141,'6','1',10104.63,10104.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','16',142,'7','1',13295.80,13295.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','16',143,'8','1',8198.96,8434.54,235.58,42404.40,0.00,0.00,0.00,0.00,0.00),('1','287','4','16',144,'9','2',214497.55,214497.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','17',145,'1','1',16380.13,17509.63,1129.50,203310.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','17',146,'2','1',7878.43,8281.37,402.94,72529.20,0.00,0.00,0.00,0.00,0.00),('1','287','1','17',147,'3','1',14909.18,15278.15,339.65,61137.00,0.00,0.00,29.32,0.00,0.00),('1','287','1','17',148,'4','1',5792.16,5802.90,0.00,0.00,0.00,0.00,10.74,0.00,0.00),('1','287','2','17',149,'5','1',16295.03,17126.63,831.60,149688.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','17',150,'6','1',10104.63,10104.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','17',151,'7','1',13295.80,14426.20,1130.40,203472.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','17',152,'8','1',8434.54,8434.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','17',153,'9','2',214497.55,214497.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','18',154,'1','1',17509.63,18491.00,981.37,176646.60,0.00,0.00,0.00,0.00,0.00),('1','287','1','18',155,'2','1',8281.37,9088.97,807.60,145368.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','18',156,'3','1',15278.15,15279.61,0.00,0.00,0.00,0.00,1.46,0.00,0.00),('1','287','1','18',157,'4','1',5802.90,5869.52,66.62,11991.60,0.00,0.00,0.00,0.00,0.00),('1','287','2','18',158,'5','1',17126.63,17944.18,817.55,147159.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','18',159,'6','1',10104.63,10185.71,81.08,14594.40,0.00,0.00,0.00,0.00,0.00),('1','287','3','18',160,'7','1',14426.20,14426.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','18',161,'8','1',8434.54,9000.88,566.34,101941.20,0.00,0.00,0.00,0.00,0.00),('1','287','4','18',162,'9','2',214497.55,214507.94,10.39,8000.30,0.00,0.00,0.00,0.00,0.00),('1','287','1','19',163,'1','1',18491.00,19641.56,1140.30,205254.00,0.00,0.00,10.26,0.00,0.00),('1','287','1','19',164,'2','1',9088.97,9088.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','19',165,'3','1',15279.61,15279.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','19',166,'4','1',5869.52,5869.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','19',167,'5','1',17944.18,18642.06,687.63,123773.40,0.00,0.00,10.25,0.00,0.00),('1','287','2','19',168,'6','1',10185.71,10659.57,473.86,85294.80,0.00,0.00,0.00,0.00,0.00),('1','287','3','19',169,'7','1',14426.20,15078.69,652.49,117448.20,0.00,0.00,0.00,0.00,0.00),('1','287','3','19',170,'8','1',9000.88,9000.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','19',171,'9','2',214507.94,214507.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','20',172,'1','1',19641.56,20110.87,469.31,84475.80,0.00,0.00,0.00,0.00,0.00),('1','287','1','20',173,'2','1',9088.97,9607.52,518.55,93339.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','20',174,'3','1',15279.61,15279.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','20',175,'4','1',5869.52,5869.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','20',176,'5','1',18642.06,19323.19,681.13,122603.40,0.00,0.00,0.00,0.00,0.00),('1','287','2','20',177,'6','1',10659.57,10664.53,4.96,892.80,0.00,0.00,0.00,0.00,0.00),('1','287','3','20',178,'7','1',15078.69,15723.06,644.37,115986.60,0.00,0.00,0.00,0.00,0.00),('1','287','3','20',179,'8','1',9000.88,9001.10,0.00,0.00,0.00,0.00,0.22,0.00,0.00),('1','287','4','20',180,'9','2',214507.94,214507.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','21',181,'1','1',20110.87,21051.10,940.23,169241.40,0.00,0.00,0.00,0.00,0.00),('1','287','1','21',182,'2','1',9607.52,10099.87,492.35,88623.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','21',183,'3','1',15279.61,15279.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','21',184,'4','1',5869.52,5869.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','21',185,'5','1',19323.19,19500.79,177.60,31968.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','21',186,'6','1',10664.53,10665.70,0.00,0.00,0.00,0.00,1.17,0.00,0.00),('1','287','3','21',187,'7','1',15723.06,16188.86,465.80,83844.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','21',188,'8','1',9001.10,9260.20,259.10,46638.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','21',189,'9','2',214507.94,214557.94,50.00,38500.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','22',190,'1','1',21051.10,21940.62,889.52,160113.60,0.00,0.00,0.00,0.00,0.00),('1','287','1','22',191,'2','1',10099.87,10955.91,856.04,154087.20,0.00,0.00,0.00,0.00,0.00),('1','287','1','22',192,'3','1',15279.61,15279.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','22',193,'4','1',5869.52,5869.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','22',194,'5','1',19500.79,19500.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','22',195,'6','1',10665.70,10665.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','22',196,'7','1',16188.86,17062.39,873.53,157235.40,0.00,0.00,0.00,0.00,0.00),('1','287','3','22',197,'8','1',9260.20,9679.07,418.87,75396.60,0.00,0.00,0.00,0.00,0.00),('1','287','4','22',198,'9','2',214557.94,214557.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','23',199,'1','1',21940.62,23085.49,1144.87,206076.60,0.00,0.00,0.00,0.00,0.00),('1','287','1','23',200,'2','1',10955.91,11002.56,46.65,8397.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','23',201,'3','1',15279.61,15280.50,0.00,0.00,0.00,0.00,0.89,0.00,0.00),('1','287','1','23',202,'4','1',5869.52,5869.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','23',203,'5','1',19500.79,19844.66,343.87,61896.60,0.00,0.00,0.00,0.00,0.00),('1','287','2','23',204,'6','1',10665.70,11211.78,546.08,98294.40,0.00,0.00,0.00,0.00,0.00),('1','287','3','23',205,'7','1',17062.39,17553.60,491.21,88417.80,0.00,0.00,0.00,0.00,0.00),('1','287','3','23',206,'8','1',9679.07,9800.98,121.91,21943.80,0.00,0.00,0.00,0.00,0.00),('1','287','4','23',207,'9','2',214557.94,214557.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','24',208,'1','1',23085.49,23404.84,319.35,57483.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','24',209,'2','1',11002.56,11002.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','24',210,'3','1',15280.50,15280.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','24',211,'4','1',5869.52,5869.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','24',212,'5','1',19844.66,21073.95,1229.29,221272.20,0.00,0.00,0.00,0.00,0.00),('1','287','2','24',213,'6','1',11211.78,12310.25,1088.47,195924.60,0.00,0.00,10.00,0.00,0.00),('1','287','3','24',214,'7','1',17553.60,18168.67,605.07,108912.60,0.00,0.00,10.00,0.00,0.00),('1','287','3','24',215,'8','1',9800.98,10446.66,645.68,116222.40,0.00,0.00,0.00,0.00,0.00),('1','287','4','24',216,'9','2',214557.94,214659.63,101.69,78301.30,0.00,0.00,0.00,0.00,0.00),('1','287','1','25',217,'1','1',23404.84,23404.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','25',218,'2','1',11002.56,11002.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','25',219,'3','1',15280.50,15280.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','25',220,'4','1',5869.52,5869.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','25',221,'5','1',21073.95,22245.55,1171.60,210888.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','25',222,'6','1',12310.25,12473.47,163.22,29379.60,0.00,0.00,0.00,0.00,0.00),('1','287','3','25',223,'7','1',18168.67,18168.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','25',224,'8','1',10446.66,11846.86,1400.20,252036.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','25',225,'9','2',214659.63,214709.63,50.00,38500.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','26',226,'1','1',23404.84,23404.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','26',227,'2','1',11002.56,11002.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','26',228,'3','1',15280.50,15280.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','26',229,'4','1',5869.52,5869.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','26',230,'5','1',22245.55,24463.41,2197.86,395614.80,0.00,0.00,20.00,0.00,0.00),('1','287','2','26',231,'6','1',12473.47,13369.78,872.53,157055.40,0.00,0.00,23.78,0.00,0.00),('1','287','3','26',232,'7','1',18168.67,18168.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','26',233,'8','1',11846.86,11885.60,0.00,0.00,0.00,0.00,38.74,0.00,0.00),('1','287','4','26',234,'9','2',214709.63,214709.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','27',235,'1','1',23404.84,23404.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','27',236,'2','1',11002.56,11002.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','27',237,'3','1',15280.50,15280.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','27',238,'4','1',5869.52,5869.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','27',239,'5','1',24463.41,25784.60,1291.19,232414.20,0.00,0.00,30.00,0.00,0.00),('1','287','2','27',240,'6','1',13369.78,13878.65,508.87,91596.60,0.00,0.00,0.00,0.00,0.00),('1','287','3','27',241,'7','1',18168.67,18642.64,456.35,82143.00,0.00,0.00,17.62,0.00,0.00),('1','287','3','27',242,'8','1',11885.60,12165.04,259.05,46629.00,0.00,0.00,20.39,0.00,0.00),('1','287','4','27',243,'9','2',214709.63,214788.62,78.99,60822.30,0.00,0.00,0.00,0.00,0.00),('1','287','1','28',244,'1','1',23404.84,23404.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','28',245,'2','1',11002.56,11002.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','28',246,'3','1',15280.50,15280.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','28',247,'4','1',5869.52,5869.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','28',248,'5','1',25784.60,25784.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','28',249,'6','1',13878.65,13878.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','28',250,'7','1',18642.64,18642.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','28',251,'8','1',12165.04,12165.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','28',252,'9','2',214788.62,214788.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','29',253,'1','1',23404.84,23404.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','29',254,'2','1',11002.56,11002.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','29',255,'3','1',15280.50,15280.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','29',256,'4','1',5869.52,5869.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','29',257,'5','1',25784.60,26192.71,312.80,56304.00,0.00,0.00,95.31,0.00,0.00),('1','287','2','29',258,'6','1',13878.65,14907.26,953.68,171662.40,0.00,0.00,74.93,0.00,0.00),('1','287','3','29',259,'7','1',18642.64,19789.47,1098.50,197730.00,0.00,0.00,48.33,0.00,0.00),('1','287','3','29',260,'8','1',12165.04,12580.61,306.12,55101.60,0.00,0.00,109.45,0.00,0.00),('1','287','4','29',261,'9','2',214788.62,214788.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','30',262,'1','1',23404.84,23404.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','30',263,'2','1',11002.56,11002.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','30',264,'3','1',15280.50,15280.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','30',265,'4','1',5869.52,5869.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','30',266,'5','1',26192.71,26635.90,443.19,79774.20,0.00,0.00,0.00,0.00,0.00),('1','287','2','30',267,'6','1',14907.26,15276.81,344.00,61920.00,0.00,0.00,25.55,0.00,0.00),('1','287','3','30',268,'7','1',19789.47,20364.08,574.61,103429.80,0.00,0.00,0.00,0.00,0.00),('1','287','3','30',269,'8','1',12580.61,12724.96,144.35,25983.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','30',270,'9','2',214788.62,214788.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','31',271,'1','1',23404.84,23404.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','31',272,'2','1',11002.56,11002.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','31',273,'3','1',15280.50,15280.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','31',274,'4','1',5869.52,5869.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','31',275,'5','1',26635.90,27760.00,1124.10,202338.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','31',276,'6','1',15276.81,15823.25,546.44,98359.20,0.00,0.00,0.00,0.00,0.00),('1','287','3','31',277,'7','1',20364.08,21163.54,799.46,143902.80,0.00,0.00,0.00,0.00,0.00),('1','287','3','31',278,'8','1',12724.96,13323.61,598.65,107757.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','31',279,'9','2',214788.62,214881.19,92.57,71278.90,0.00,0.00,0.00,0.00,0.00),('1','287','1','32',280,'1','1',23404.84,23404.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','32',281,'2','1',11002.56,11002.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','32',282,'3','1',15280.50,15280.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','32',283,'4','1',5869.52,5869.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','32',284,'5','1',27760.00,27791.90,31.90,5742.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','32',285,'6','1',15823.25,15873.82,50.57,9102.60,0.00,0.00,0.00,0.00,0.00),('1','287','3','32',286,'7','1',21163.54,21781.58,618.04,111247.20,0.00,0.00,0.00,0.00,0.00),('1','287','3','32',287,'8','1',13323.61,14328.42,1004.81,180865.80,0.00,0.00,0.00,0.00,0.00),('1','287','4','32',288,'9','2',214881.19,214881.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','33',289,'1','1',23404.84,23404.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','33',290,'2','1',11002.56,11002.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','33',291,'3','1',15280.50,15280.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','33',292,'4','1',5869.52,5869.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','33',293,'5','1',27791.90,27791.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','33',294,'6','1',15873.82,15873.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','33',295,'7','1',21781.58,23613.20,1831.62,329691.60,0.00,0.00,0.00,0.00,0.00),('1','287','3','33',296,'8','1',14328.42,15668.65,1340.23,241241.40,0.00,0.00,0.00,0.00,0.00),('1','287','4','33',297,'9','2',214881.19,214945.82,64.63,49765.10,0.00,0.00,0.00,0.00,0.00),('1','287','1','34',298,'1','1',23404.84,23404.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','34',299,'2','1',11002.56,11002.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','34',300,'3','1',15280.50,15280.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','34',301,'4','1',5869.52,5869.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','34',302,'5','1',27791.90,27791.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','34',303,'6','1',15873.82,15873.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','34',304,'7','1',23613.20,25268.32,1655.12,297921.60,0.00,0.00,0.00,0.00,0.00),('1','287','3','34',305,'8','1',15668.65,16468.63,799.98,143996.40,0.00,0.00,0.00,0.00,0.00),('1','287','4','34',306,'9','2',214945.82,214985.82,40.00,30800.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','35',307,'1','1',23404.84,23404.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','35',308,'2','1',11002.56,11002.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','35',309,'3','1',15280.50,15280.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','35',310,'4','1',5869.52,5869.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','35',311,'5','1',27791.90,28424.28,632.38,113828.40,0.00,0.00,0.00,0.00,0.00),('1','287','2','35',312,'6','1',15873.82,16078.58,172.14,30985.20,0.00,0.00,32.62,0.00,0.00),('1','287','3','35',313,'7','1',25268.32,26914.59,1646.27,296328.60,0.00,0.00,0.00,0.00,0.00),('1','287','3','35',314,'8','1',16468.63,17291.00,822.37,148026.60,0.00,0.00,0.00,0.00,0.00),('1','287','4','35',315,'9','2',214985.82,214985.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','36',316,'1','1',23404.84,23646.44,199.46,35902.80,0.00,0.00,42.14,0.00,0.00),('1','287','1','36',317,'2','1',11002.56,11023.84,0.00,0.00,0.00,0.00,21.28,0.00,0.00),('1','287','1','36',318,'3','1',15280.50,15351.77,44.42,7995.60,0.00,0.00,26.85,0.00,0.00),('1','287','1','36',319,'4','1',5869.52,5883.53,0.00,0.00,0.00,0.00,14.01,0.00,0.00),('1','287','2','36',320,'5','1',28424.28,29610.40,1185.89,213460.20,0.00,0.00,0.23,0.00,0.00),('1','287','2','36',321,'6','1',16078.58,16324.94,246.36,44344.80,0.00,0.00,0.00,0.00,0.00),('1','287','3','36',322,'7','1',26914.59,27323.09,388.50,69930.00,0.00,0.00,20.00,0.00,0.00),('1','287','3','36',323,'8','1',17291.00,17578.52,287.52,51753.60,0.00,0.00,0.00,0.00,0.00),('1','287','4','36',324,'9','2',214985.82,214985.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','37',325,'1','1',23646.44,23646.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','37',326,'2','1',11023.84,12516.29,1492.45,268641.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','37',327,'3','1',15351.77,15351.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','37',328,'4','1',5883.53,7000.96,1117.43,201137.40,0.00,0.00,0.00,0.00,0.00),('1','287','2','37',329,'5','1',29610.40,29610.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','37',330,'6','1',16324.94,17202.29,877.35,157923.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','37',331,'7','1',27323.09,27323.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','37',332,'8','1',17578.52,18029.80,451.28,81230.40,0.00,0.00,0.00,0.00,0.00),('1','287','4','37',333,'9','2',214985.82,215035.82,50.00,38500.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','38',334,'1','1',23646.44,24749.21,1102.77,198498.60,0.00,0.00,0.00,0.00,0.00),('1','287','1','38',335,'2','1',12516.29,12516.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','38',336,'3','1',15351.77,15856.75,504.98,90896.40,0.00,0.00,0.00,0.00,0.00),('1','287','1','38',337,'4','1',7000.96,7000.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','38',338,'5','1',29610.40,30308.41,698.01,125641.80,0.00,0.00,0.00,0.00,0.00),('1','287','2','38',339,'6','1',17202.29,17202.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','38',340,'7','1',27323.09,27709.06,385.97,69474.60,0.00,0.00,0.00,0.00,0.00),('1','287','3','38',341,'8','1',18029.80,18029.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','38',342,'9','2',215035.82,215085.82,50.00,38500.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','39',343,'1','1',24749.21,25554.47,805.26,144946.80,0.00,0.00,0.00,0.00,0.00),('1','287','1','39',344,'2','1',12516.29,12825.71,309.42,55695.60,0.00,0.00,0.00,0.00,0.00),('1','287','1','39',345,'3','1',15856.75,16089.05,232.30,41814.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','39',346,'4','1',7000.96,8033.23,1032.27,185808.60,0.00,0.00,0.00,0.00,0.00),('1','287','2','39',347,'5','1',30308.41,30308.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','39',348,'6','1',17202.29,18196.93,994.64,179035.20,0.00,0.00,0.00,0.00,0.00),('1','287','3','39',349,'7','1',27709.06,27709.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','39',350,'8','1',18029.80,18591.06,561.26,101026.80,0.00,0.00,0.00,0.00,0.00),('1','287','4','39',351,'9','2',215085.82,215085.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','40',352,'1','1',25554.47,25554.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','40',353,'2','1',12825.71,12825.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','40',354,'3','1',16089.05,16867.79,778.74,140173.20,0.00,0.00,0.00,0.00,0.00),('1','287','1','40',355,'4','1',8033.23,8033.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','40',356,'5','1',30308.41,31255.40,946.99,170458.20,0.00,0.00,0.00,0.00,0.00),('1','287','2','40',357,'6','1',18196.93,18935.43,738.50,132930.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','40',358,'7','1',27709.06,28037.47,328.41,59113.80,0.00,0.00,0.00,0.00,0.00),('1','287','3','40',359,'8','1',18591.06,18591.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','40',360,'9','2',215085.82,215235.82,150.00,115500.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','41',361,'1','1',25554.47,25740.45,185.98,33476.40,0.00,0.00,0.00,0.00,0.00),('1','287','1','41',362,'2','1',12825.71,13585.39,759.68,136742.40,0.00,0.00,0.00,0.00,0.00),('1','287','1','41',363,'3','1',16867.79,16867.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','41',364,'4','1',8033.23,8876.28,843.05,151749.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','41',365,'5','1',31255.40,32502.66,1247.26,224506.80,0.00,0.00,0.00,0.00,0.00),('1','287','2','41',366,'6','1',18935.43,18935.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','41',367,'7','1',28037.47,28037.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','41',368,'8','1',18591.06,19465.74,874.68,157442.40,0.00,0.00,0.00,0.00,0.00),('1','287','4','41',369,'9','2',215235.82,215239.57,3.75,3000.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','42',370,'1','1',25740.45,26751.11,1010.66,181918.80,0.00,0.00,0.00,0.00,0.00),('1','287','1','42',371,'2','1',13585.39,13585.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','42',372,'3','1',16867.79,17227.28,359.49,64708.20,0.00,0.00,0.00,0.00,0.00),('1','287','1','42',373,'4','1',8876.28,8876.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','42',374,'5','1',32502.66,33300.58,797.92,143625.60,0.00,0.00,0.00,0.00,0.00),('1','287','2','42',375,'6','1',18935.43,19117.00,181.57,32682.60,0.00,0.00,0.00,0.00,0.00),('1','287','3','42',376,'7','1',28037.47,28609.83,572.36,103024.80,0.00,0.00,0.00,0.00,0.00),('1','287','3','42',377,'8','1',19465.74,19465.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','42',378,'9','2',215239.57,215289.57,50.00,40000.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','43',379,'1','1',26751.11,27923.14,1172.03,210965.40,0.00,0.00,0.00,0.00,0.00),('1','287','1','43',380,'2','1',13585.39,13786.87,201.48,36266.40,0.00,0.00,0.00,0.00,0.00),('1','287','1','43',381,'3','1',17227.28,17803.81,576.53,103775.40,0.00,0.00,0.00,0.00,0.00),('1','287','1','43',382,'4','1',8876.28,8989.01,112.73,20291.40,0.00,0.00,0.00,0.00,0.00),('1','287','2','43',383,'5','1',33300.58,33300.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','43',384,'6','1',19117.00,19961.55,844.55,152019.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','43',385,'7','1',28609.83,28609.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','43',386,'8','1',19465.74,20899.06,1433.32,257997.60,0.00,0.00,0.00,0.00,0.00),('1','287','4','43',387,'9','2',215289.57,215293.57,4.00,3200.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','44',388,'1','1',27923.14,29020.62,1097.48,197546.40,0.00,0.00,0.00,0.00,0.00),('1','287','1','44',389,'2','1',13786.87,14400.88,614.01,110521.80,0.00,0.00,0.00,0.00,0.00),('1','287','1','44',390,'3','1',17803.81,19434.81,1631.00,293580.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','44',391,'4','1',8989.01,8989.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','44',392,'5','1',33300.58,34969.71,1669.13,300443.40,0.00,0.00,0.00,0.00,0.00),('1','287','2','44',393,'6','1',19961.55,19961.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','44',394,'7','1',28609.83,28609.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','44',395,'8','1',20899.06,20899.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','44',396,'9','2',215293.57,215343.57,50.00,40000.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','45',397,'1','1',29020.62,29020.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','45',398,'2','1',14400.88,14400.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','45',399,'3','1',19434.81,19434.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','45',400,'4','1',8989.01,8989.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','45',401,'5','1',34969.71,34969.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','45',402,'6','1',19961.55,19961.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','45',403,'7','1',28609.83,28609.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','45',404,'8','1',20899.06,20899.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','45',405,'9','2',215343.57,215343.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','46',406,'1','1',29020.62,29020.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','46',407,'2','1',14400.88,14770.42,369.54,66517.20,0.00,0.00,0.00,0.00,0.00),('1','287','1','46',408,'3','1',19434.81,19434.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','46',409,'4','1',8989.01,9318.88,329.87,59376.60,0.00,0.00,0.00,0.00,0.00),('1','287','2','46',410,'5','1',34969.71,37994.30,3024.59,544426.20,0.00,0.00,0.00,0.00,0.00),('1','287','2','46',411,'6','1',19961.55,20406.01,444.46,80002.80,0.00,0.00,0.00,0.00,0.00),('1','287','3','46',412,'7','1',28609.83,31750.42,3140.59,565306.20,0.00,0.00,0.00,0.00,0.00),('1','287','3','46',413,'8','1',20899.06,20899.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','46',414,'9','2',215343.57,215343.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','47',415,'1','1',29020.62,29020.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','47',416,'2','1',14770.42,14770.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','47',417,'3','1',19434.81,19434.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','47',418,'4','1',9318.88,9318.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','47',419,'5','1',37994.30,38749.23,754.93,135887.40,0.00,0.00,0.00,0.00,0.00),('1','287','2','47',420,'6','1',20406.01,20406.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','47',421,'7','1',31750.42,33036.39,1285.97,231474.60,0.00,0.00,0.00,0.00,0.00),('1','287','3','47',422,'8','1',20899.06,21542.44,643.38,115808.40,0.00,0.00,0.00,0.00,0.00),('1','287','4','47',423,'9','2',215343.57,215421.82,78.25,62600.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','48',424,'1','1',29020.62,29020.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','48',425,'2','1',14770.42,14770.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','48',426,'3','1',19434.81,19434.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','48',427,'4','1',9318.88,9318.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','48',428,'5','1',38749.23,38749.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','48',429,'6','1',20406.01,20406.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','48',430,'7','1',33036.39,36860.15,3823.76,688276.80,0.00,0.00,0.00,0.00,0.00),('1','287','3','48',431,'8','1',21542.44,23932.43,2389.99,430198.20,0.00,0.00,0.00,0.00,0.00),('1','287','4','48',432,'9','2',215421.82,215421.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','49',433,'1','1',29020.62,29020.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','49',434,'2','1',14770.42,14770.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','49',435,'3','1',19434.81,19434.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','49',436,'4','1',9318.88,9318.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','49',437,'5','1',38749.23,38749.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','49',438,'6','1',20406.01,20406.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','49',439,'7','1',36860.15,37449.69,589.54,106117.20,0.00,0.00,0.00,0.00,0.00),('1','287','3','49',440,'8','1',23932.43,24290.52,358.09,64456.20,0.00,0.00,0.00,0.00,0.00),('1','287','4','49',441,'9','2',215421.82,215455.57,33.75,27000.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','50',442,'1','1',29020.62,29020.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','50',443,'2','1',14770.42,14770.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','50',444,'3','1',19434.81,19434.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','50',445,'4','1',9318.88,9318.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','50',446,'5','1',38749.23,38749.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','50',447,'6','1',20406.01,20406.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','50',448,'7','1',37449.69,37449.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','50',449,'8','1',24290.52,24290.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','50',450,'9','2',215455.57,215455.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','51',451,'1','1',29020.62,31433.19,2411.53,434075.40,0.00,0.00,1.04,0.00,0.00),('1','287','1','51',452,'2','1',14770.42,16984.86,2214.44,398599.20,0.00,0.00,0.00,0.00,0.00),('1','287','1','51',453,'3','1',19434.81,21427.07,1992.26,358606.80,0.00,0.00,0.00,0.00,0.00),('1','287','1','51',454,'4','1',9318.88,11696.65,2377.77,427998.60,0.00,0.00,0.00,0.00,0.00),('1','287','2','51',455,'5','1',38749.23,38749.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','51',456,'6','1',20406.01,20406.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','51',457,'7','1',37449.69,38680.04,1230.35,221463.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','51',458,'8','1',24290.52,24290.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','51',459,'9','2',215455.57,215455.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','52',460,'1','1',31433.19,33817.99,2384.80,429264.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','52',461,'2','1',16984.86,16984.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','52',462,'3','1',21427.07,22755.74,1328.67,239160.60,0.00,0.00,0.00,0.00,0.00),('1','287','1','52',463,'4','1',11696.65,11696.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','52',464,'5','1',38749.23,40153.73,1404.50,252810.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','52',465,'6','1',20406.01,20406.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','52',466,'7','1',38680.04,39892.59,1212.55,218259.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','52',467,'8','1',24290.52,24290.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','52',468,'9','2',215455.57,215488.07,32.50,26000.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','53',469,'1','1',33817.99,33817.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','53',470,'2','1',16984.86,18721.29,1736.43,312557.40,0.00,0.00,0.00,0.00,0.00),('1','287','1','53',471,'3','1',22755.74,22755.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','53',472,'4','1',11696.65,12898.92,1202.27,216408.60,0.00,0.00,0.00,0.00,0.00),('1','287','2','53',473,'5','1',40153.73,40153.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','53',474,'6','1',20406.01,22023.93,1607.81,289405.80,0.00,0.00,10.11,0.00,0.00),('1','287','3','53',475,'7','1',39892.59,39892.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','53',476,'8','1',24290.52,25633.56,1343.04,241747.20,0.00,0.00,0.00,0.00,0.00),('1','287','4','53',477,'9','2',215488.07,215488.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','54',478,'1','1',33817.99,33919.50,80.75,14535.00,0.00,0.00,20.76,0.00,0.00),('1','287','1','54',479,'2','1',18721.29,19277.27,555.86,100054.80,0.00,0.00,0.12,0.00,0.00),('1','287','1','54',480,'3','1',22755.74,24947.08,2191.34,394441.20,0.00,0.00,0.00,0.00,0.00),('1','287','1','54',481,'4','1',12898.92,12898.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','54',482,'5','1',40153.73,42266.97,2113.24,380383.20,0.00,0.00,0.00,0.00,0.00),('1','287','2','54',483,'6','1',22023.93,22023.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','54',484,'7','1',39892.59,41485.70,1593.11,286759.80,0.00,0.00,0.00,0.00,0.00),('1','287','3','54',485,'8','1',25633.56,25633.56,-10.00,-1800.00,0.00,0.00,10.00,0.00,0.00),('1','287','4','54',486,'9','2',215488.07,216268.07,780.00,624000.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','55',487,'1','1',33919.50,35726.27,1786.50,321570.00,0.00,0.00,20.27,0.00,0.00),('1','287','1','55',488,'2','1',19277.27,19277.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','55',489,'3','1',24947.08,26180.43,1233.35,222003.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','55',490,'4','1',12898.92,12973.91,73.98,13316.40,0.00,0.00,1.01,0.00,0.00),('1','287','2','55',491,'5','1',42266.97,42266.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','55',492,'6','1',22023.93,23476.59,1452.66,261478.80,0.00,0.00,0.00,0.00,0.00),('1','287','3','55',493,'7','1',41485.70,41485.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','55',494,'8','1',25633.56,27234.04,1600.48,288086.40,0.00,0.00,0.00,0.00,0.00),('1','287','4','55',495,'9','2',216268.07,216268.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','56',496,'1','1',35726.27,37334.06,1607.79,289402.20,0.00,0.00,0.00,0.00,0.00),('1','287','1','56',497,'2','1',19277.27,19277.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','56',498,'3','1',26180.43,27423.68,1243.25,223785.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','56',499,'4','1',12973.91,12973.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','56',500,'5','1',42266.97,44098.55,1831.58,329684.40,0.00,0.00,0.00,0.00,0.00),('1','287','2','56',501,'6','1',23476.59,23476.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','56',502,'7','1',41485.70,42329.26,843.56,151840.80,0.00,0.00,0.00,0.00,0.00),('1','287','3','56',503,'8','1',27234.04,27234.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','56',504,'9','2',216268.07,216298.07,30.00,24000.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','57',505,'1','1',37334.06,37334.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','57',506,'2','1',19277.27,21327.21,2031.94,365749.20,0.00,0.00,18.00,0.00,0.00),('1','287','1','57',507,'3','1',27423.68,27423.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','57',508,'4','1',12973.91,14715.84,1741.83,313529.40,0.00,0.00,0.10,0.00,0.00),('1','287','2','57',509,'5','1',44098.55,45420.12,1321.57,237882.60,0.00,0.00,0.00,0.00,0.00),('1','287','2','57',510,'6','1',23476.59,24589.24,1112.65,200277.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','57',511,'7','1',42329.26,42329.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','57',512,'8','1',27234.04,28752.99,1518.95,273411.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','57',513,'9','2',216298.07,216298.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','58',514,'1','1',37334.06,38974.11,1640.05,295209.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','58',515,'2','1',21327.21,21327.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','58',516,'3','1',27423.68,28652.62,1228.94,221209.20,0.00,0.00,0.00,0.00,0.00),('1','287','1','58',517,'4','1',14715.84,14715.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','58',518,'5','1',45420.12,46587.41,1167.29,210112.20,0.00,0.00,0.00,0.00,0.00),('1','287','2','58',519,'6','1',24589.24,24589.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','58',520,'7','1',42329.26,44211.52,1882.26,338806.80,0.00,0.00,0.00,0.00,0.00),('1','287','3','58',521,'8','1',28752.99,28752.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','58',522,'9','2',216298.07,216328.07,30.00,24000.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','59',523,'1','1',38974.11,40107.86,1133.75,204075.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','59',524,'2','1',21327.21,22302.55,975.34,175561.20,0.00,0.00,0.00,0.00,0.00),('1','287','1','59',525,'3','1',28652.62,29086.21,433.59,78046.92,0.00,0.00,0.00,0.00,0.00),('1','287','1','59',526,'4','1',14715.84,16138.75,1412.91,254323.80,0.00,0.00,10.00,0.00,0.00),('1','287','2','59',527,'5','1',46587.41,47329.84,742.43,133637.40,0.00,0.00,0.00,0.00,0.00),('1','287','2','59',528,'6','1',24589.24,24606.59,17.35,3123.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','59',529,'7','1',44211.52,44618.78,407.26,73306.80,0.00,0.00,0.00,0.00,0.00),('1','287','3','59',530,'8','1',28752.99,30241.06,1488.07,267852.60,0.00,0.00,0.00,0.00,0.00),('1','287','4','59',531,'9','2',216328.07,216398.07,70.00,56000.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','60',532,'1','1',40107.86,41305.08,1197.22,215499.60,0.00,0.00,0.00,0.00,0.00),('1','287','1','60',533,'2','1',22302.55,23164.16,861.61,155089.80,0.00,0.00,0.00,0.00,0.00),('1','287','1','60',534,'3','1',29086.21,30258.25,1172.04,210967.20,0.00,0.00,0.00,0.00,0.00),('1','287','1','60',535,'4','1',16138.75,16138.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','60',536,'5','1',47329.84,48793.07,1463.23,263381.40,0.00,0.00,0.00,0.00,0.00),('1','287','2','60',537,'6','1',24606.59,24606.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','60',538,'7','1',44618.78,45666.33,1047.55,188559.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','60',539,'8','1',30241.06,30241.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','60',540,'9','2',216398.07,216428.07,30.00,24000.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','61',541,'1','1',41305.08,41305.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','61',542,'2','1',23164.16,25747.89,2583.73,465071.40,0.00,0.00,0.00,0.00,0.00),('1','287','1','61',543,'3','1',30258.25,30258.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','61',544,'4','1',16138.75,16319.22,180.47,32484.60,0.00,0.00,0.00,0.00,0.00),('1','287','2','61',545,'5','1',48793.07,51264.15,2471.08,444794.40,0.00,0.00,0.00,0.00,0.00),('1','287','2','61',546,'6','1',24606.59,24606.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','61',547,'7','1',45666.33,45666.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','61',548,'8','1',30241.06,32286.99,2045.93,368267.40,0.00,0.00,0.00,0.00,0.00),('1','287','4','61',549,'9','2',216428.07,216428.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','62',550,'1','1',41305.08,41683.61,364.97,65694.60,0.00,0.00,13.56,0.00,0.00),('1','287','1','62',551,'2','1',25747.89,27321.16,1573.27,283188.60,0.00,0.00,0.00,0.00,0.00),('1','287','1','62',552,'3','1',30258.25,30258.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','62',553,'4','1',16319.22,17293.15,973.93,175307.40,0.00,0.00,0.00,0.00,0.00),('1','287','2','62',554,'5','1',51264.15,53193.59,1907.97,343434.60,0.00,0.00,21.47,0.00,0.00),('1','287','2','62',555,'6','1',24606.59,25265.56,658.97,118614.60,0.00,0.00,0.00,0.00,0.00),('1','287','3','62',556,'7','1',45666.33,46331.74,665.41,119773.80,0.00,0.00,0.00,0.00,0.00),('1','287','3','62',557,'8','1',32286.99,32286.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','62',558,'9','2',216428.07,216458.07,30.00,24000.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','63',559,'1','1',41683.61,41683.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','63',560,'2','1',27321.16,27321.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','63',561,'3','1',30258.25,30258.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','63',562,'4','1',17293.15,17293.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','63',563,'5','1',53193.59,53193.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','63',564,'6','1',25265.56,25265.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','63',565,'7','1',46331.74,46331.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','63',566,'8','1',32286.99,32286.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','63',567,'9','2',216458.07,216458.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','64',568,'1','1',41683.61,44098.83,2415.22,434739.60,0.00,0.00,0.00,0.00,0.00),('1','287','1','64',569,'2','1',27321.16,27321.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','64',570,'3','1',30258.25,33323.77,3065.52,551793.60,0.00,0.00,0.00,0.00,0.00),('1','287','1','64',571,'4','1',17293.15,17440.05,146.90,26442.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','64',572,'5','1',53193.59,56192.67,2994.08,538934.40,0.00,0.00,5.00,0.00,0.00),('1','287','2','64',573,'6','1',25265.56,25552.52,265.50,47790.00,0.00,0.00,21.46,0.00,0.00),('1','287','3','64',574,'7','1',46331.74,46331.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','64',575,'8','1',32286.99,33958.37,1670.82,300747.60,0.00,0.00,0.56,0.00,0.00),('1','287','4','64',576,'9','2',216458.07,216458.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','65',577,'1','1',44098.83,45960.14,1861.31,335035.80,0.00,0.00,0.00,0.00,0.00),('1','287','1','65',578,'2','1',27321.16,27321.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','65',579,'3','1',33323.77,33323.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','65',580,'4','1',17440.05,18961.29,1521.04,273787.20,0.00,0.00,0.20,0.00,0.00),('1','287','2','65',581,'5','1',56192.67,58055.49,1862.82,335307.60,0.00,0.00,0.00,0.00,0.00),('1','287','2','65',582,'6','1',25552.52,25552.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','65',583,'7','1',46331.74,47646.30,1314.56,236620.80,0.00,0.00,0.00,0.00,0.00),('1','287','3','65',584,'8','1',33958.37,33958.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','65',585,'9','2',216458.07,216488.07,30.00,24000.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','66',586,'1','1',45960.14,45960.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','66',587,'2','1',27321.16,29129.95,1808.79,325582.20,0.00,0.00,0.00,0.00,0.00),('1','287','1','66',588,'3','1',33323.77,33323.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','66',589,'4','1',18961.29,20657.55,1696.26,305326.80,0.00,0.00,0.00,0.00,0.00),('1','287','2','66',590,'5','1',58055.49,60208.68,2153.19,387574.20,0.00,0.00,0.00,0.00,0.00),('1','287','2','66',591,'6','1',25552.52,25552.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','66',592,'7','1',47646.30,47646.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','66',593,'8','1',33958.37,36118.22,2159.85,388773.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','66',594,'9','2',216488.07,216488.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','67',595,'1','1',45960.14,45960.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','67',596,'2','1',29129.95,29810.97,680.33,122459.40,0.00,0.00,0.69,0.00,0.00),('1','287','1','67',597,'3','1',33323.77,35788.10,2464.33,443579.40,0.00,0.00,0.00,0.00,0.00),('1','287','1','67',598,'4','1',20657.55,20657.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','67',599,'5','1',60208.68,62704.19,2495.51,449191.80,0.00,0.00,0.00,0.00,0.00),('1','287','2','67',600,'6','1',25552.52,25552.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','67',601,'7','1',47646.30,49687.11,2040.81,367345.80,0.00,0.00,0.00,0.00,0.00),('1','287','3','67',602,'8','1',36118.22,36118.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','67',603,'9','2',216488.07,216533.08,45.01,36008.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','68',604,'1','1',45960.14,47438.37,1478.23,266081.40,0.00,0.00,0.00,0.00,0.00),('1','287','1','68',605,'2','1',29810.97,29810.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','68',606,'3','1',35788.10,35788.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','68',607,'4','1',20657.55,22548.05,1890.50,340290.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','68',608,'5','1',62704.19,63396.23,692.04,124567.20,0.00,0.00,0.00,0.00,0.00),('1','287','2','68',609,'6','1',25552.52,26125.47,572.95,103131.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','68',610,'7','1',49687.11,49687.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','68',611,'8','1',36118.22,38219.41,2101.19,378214.20,0.00,0.00,0.00,0.00,0.00),('1','287','4','68',612,'9','2',216533.08,216533.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','69',613,'1','1',47438.37,49309.80,1871.43,336857.40,0.00,0.00,0.00,0.00,0.00),('1','287','1','69',614,'2','1',29810.97,29810.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','69',615,'3','1',35788.10,35788.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','69',616,'4','1',22548.05,22548.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','69',617,'5','1',63396.23,64353.59,957.36,172324.80,0.00,0.00,0.00,0.00,0.00),('1','287','2','69',618,'6','1',26125.47,26764.50,619.03,111425.40,0.00,0.00,20.00,0.00,0.00),('1','287','3','69',619,'7','1',49687.11,49687.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','69',620,'8','1',38219.41,39600.27,1380.86,248554.80,0.00,0.00,0.00,0.00,0.00),('1','287','4','69',621,'9','2',216533.08,216641.83,108.75,87000.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','70',622,'1','1',49309.80,49309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','70',623,'2','1',29810.97,29810.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','70',624,'3','1',35788.10,35788.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','70',625,'4','1',22548.05,24846.44,2298.39,413710.20,0.00,0.00,0.00,0.00,0.00),('1','287','2','70',626,'5','1',64353.59,66240.37,1886.78,339620.40,0.00,0.00,0.00,0.00,0.00),('1','287','2','70',627,'6','1',26764.50,26764.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','70',628,'7','1',49687.11,50581.67,894.56,161020.80,0.00,0.00,0.00,0.00,0.00),('1','287','3','70',629,'8','1',39600.27,40293.62,691.35,124443.00,0.00,0.00,2.00,0.00,0.00),('1','287','4','70',630,'9','2',216641.83,216641.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','71',631,'1','1',49309.80,49309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','71',632,'2','1',29810.97,29810.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','71',633,'3','1',35788.10,35788.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','71',634,'4','1',24846.44,24846.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','71',635,'5','1',66240.37,67588.92,1348.55,242739.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','71',636,'6','1',26764.50,26764.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','71',637,'7','1',50581.67,51891.55,1309.88,235778.40,0.00,0.00,0.00,0.00,0.00),('1','287','3','71',638,'8','1',40293.62,41609.47,1315.85,236853.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','71',639,'9','2',216641.83,216671.83,30.00,24000.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','72',640,'1','1',49309.80,49309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','72',641,'2','1',29810.97,29810.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','72',642,'3','1',35788.10,35788.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','72',643,'4','1',24846.44,24846.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','72',644,'5','1',67588.92,70575.73,2986.81,537625.80,0.00,0.00,0.00,0.00,0.00),('1','287','2','72',645,'6','1',26764.50,26764.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','72',646,'7','1',51891.55,53396.42,1504.87,270876.60,0.00,0.00,0.00,0.00,0.00),('1','287','3','72',647,'8','1',41609.47,42444.83,835.36,150364.80,0.00,0.00,0.00,0.00,0.00),('1','287','4','72',648,'9','2',216671.83,216671.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','73',649,'1','1',49309.80,49309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','73',650,'2','1',29810.97,29810.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','73',651,'3','1',35788.10,35788.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','73',652,'4','1',24846.44,24846.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','73',653,'5','1',70575.73,73949.58,3373.85,607293.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','73',654,'6','1',26764.50,27290.37,525.87,94656.60,0.00,0.00,0.00,0.00,0.00),('1','287','3','73',655,'7','1',53396.42,53396.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','73',656,'8','1',42444.83,42444.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','73',657,'9','2',216671.83,216701.83,30.00,24000.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','74',658,'1','1',49309.80,49309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','74',659,'2','1',29810.97,29810.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','74',660,'3','1',35788.10,35788.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','74',661,'4','1',24846.44,24846.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','74',662,'5','1',73949.58,77965.09,4015.51,722791.80,0.00,0.00,0.00,0.00,0.00),('1','287','2','74',663,'6','1',27290.37,27290.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','74',664,'7','1',53396.42,53396.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','74',665,'8','1',42444.83,42444.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','74',666,'9','2',216701.83,216701.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','75',667,'1','1',49309.80,49309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','75',668,'2','1',29810.97,29810.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','75',669,'3','1',35788.10,35788.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','75',670,'4','1',24846.44,24846.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','75',671,'5','1',77965.09,81123.28,3158.19,568474.20,0.00,0.00,0.00,0.00,0.00),('1','287','2','75',672,'6','1',27290.37,27290.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','75',673,'7','1',53396.42,53396.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','75',674,'8','1',42444.83,42444.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','75',675,'9','2',216701.83,216731.83,30.00,24000.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','76',676,'1','1',49309.80,49309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','76',677,'2','1',29810.97,29810.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','76',678,'3','1',35788.10,35788.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','76',679,'4','1',24846.44,24846.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','76',680,'5','1',81123.28,81123.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','76',681,'6','1',27290.37,27290.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','76',682,'7','1',53396.42,53396.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','76',683,'8','1',42444.83,42444.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','76',684,'9','2',216731.83,216731.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','77',685,'1','1',49309.80,49309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','77',686,'2','1',29810.97,29810.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','77',687,'3','1',35788.10,35788.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','77',688,'4','1',24846.44,24846.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','77',689,'5','1',81123.28,81123.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','77',690,'6','1',27290.37,27290.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','77',691,'7','1',53396.42,53396.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','77',692,'8','1',42444.83,42444.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','77',693,'9','2',216731.83,218561.83,1830.00,1509750.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','78',694,'1','1',49309.80,49309.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','78',695,'2','1',29810.97,29810.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','78',696,'3','1',35788.10,35788.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','78',697,'4','1',24846.44,24846.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','78',698,'5','1',81123.28,81123.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','78',699,'6','1',27290.37,27290.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','78',700,'7','1',53396.42,53396.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','78',701,'8','1',42444.83,42444.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','78',702,'9','2',218561.83,218841.35,279.52,234796.80,0.00,0.00,0.00,0.00,0.00),('1','287','1','79',703,'1','1',49309.80,52210.49,2900.69,609144.90,0.00,0.00,0.00,0.00,0.00),('1','287','1','79',704,'2','1',29810.97,30299.12,488.15,102511.50,0.00,0.00,0.00,0.00,0.00),('1','287','1','79',705,'3','1',35788.10,37163.14,1375.04,288758.40,0.00,0.00,0.00,0.00,0.00),('1','287','1','79',706,'4','1',24846.44,26896.75,2050.31,430565.10,0.00,0.00,0.00,0.00,0.00),('1','287','2','79',707,'5','1',81123.28,82399.26,1270.98,266905.80,0.00,0.00,5.00,0.00,0.00),('1','287','2','79',708,'6','1',27290.37,28630.51,1340.14,281429.40,0.00,0.00,0.00,0.00,0.00),('1','287','3','79',709,'7','1',53396.42,54714.73,1318.31,276845.10,0.00,0.00,0.00,0.00,0.00),('1','287','3','79',710,'8','1',42444.83,43588.17,1143.34,240101.40,0.00,0.00,0.00,0.00,0.00),('1','287','4','79',711,'9','2',218841.35,218841.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','80',712,'1','1',52210.49,52210.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','80',713,'2','1',30299.12,31907.60,1608.48,337780.80,0.00,0.00,0.00,0.00,0.00),('1','287','1','80',714,'3','1',37163.14,39391.94,2228.80,468048.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','80',715,'4','1',26896.75,28032.04,1135.29,238410.90,0.00,0.00,0.00,0.00,0.00),('1','287','2','80',716,'5','1',82399.26,82399.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','80',717,'6','1',28630.51,31149.62,2519.11,529013.10,0.00,0.00,0.00,0.00,0.00),('1','287','3','80',718,'7','1',54714.73,56111.09,1396.36,293235.60,0.00,0.00,0.00,0.00,0.00),('1','287','3','80',719,'8','1',43588.17,45138.57,1550.40,325584.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','80',720,'9','2',218841.35,219757.70,916.35,769734.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','81',721,'1','1',52210.49,53366.24,1155.75,242707.50,0.00,0.00,0.00,0.00,0.00),('1','287','1','81',722,'2','1',31907.60,33605.09,1697.49,356472.90,0.00,0.00,0.00,0.00,0.00),('1','287','1','81',723,'3','1',39391.94,41597.44,2205.50,463155.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','81',724,'4','1',28032.04,29312.60,1279.97,268793.70,0.00,0.00,0.59,0.00,0.00),('1','287','2','81',725,'5','1',82399.26,82399.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','81',726,'6','1',31149.62,33120.19,1970.57,413819.70,0.00,0.00,0.00,0.00,0.00),('1','287','3','81',727,'7','1',56111.09,57334.32,1223.23,256878.30,0.00,0.00,0.00,0.00,0.00),('1','287','3','81',728,'8','1',45138.57,46144.92,1006.35,211333.50,0.00,0.00,0.00,0.00,0.00),('1','287','4','81',729,'9','2',219757.70,219757.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','82',730,'1','1',53366.24,53366.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','82',731,'2','1',33605.09,36535.90,2930.81,615470.10,0.00,0.00,0.00,0.00,0.00),('1','287','1','82',732,'3','1',41597.44,41597.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','82',733,'4','1',29312.60,31712.96,2400.36,504075.60,0.00,0.00,0.00,0.00,0.00),('1','287','2','82',734,'5','1',82399.26,84897.55,2477.40,520254.00,0.00,0.00,20.89,0.00,0.00),('1','287','2','82',735,'6','1',33120.19,33120.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','82',736,'7','1',57334.32,59743.43,2409.11,505913.10,0.00,0.00,0.00,0.00,0.00),('1','287','3','82',737,'8','1',46144.92,46144.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','82',738,'9','2',219757.70,219917.85,160.15,134526.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','83',739,'1','1',53366.24,53400.04,33.80,7098.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','83',740,'2','1',36535.90,39557.70,3011.80,632478.00,0.00,0.00,10.00,0.00,0.00),('1','287','1','83',741,'3','1',41597.44,41597.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','83',742,'4','1',31712.96,34213.71,2490.75,523057.50,0.00,0.00,10.00,0.00,0.00),('1','287','2','83',743,'5','1',84897.55,84897.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','83',744,'6','1',33120.19,36649.10,3518.91,738971.10,0.00,0.00,10.00,0.00,0.00),('1','287','3','83',745,'7','1',59743.43,59743.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','83',746,'8','1',46144.92,48026.65,1871.73,393063.30,0.00,0.00,10.00,0.00,0.00),('1','287','4','83',747,'9','2',219917.85,219917.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','84',748,'1','1',53400.04,53400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','84',749,'2','1',39557.70,42161.25,2603.55,546745.50,0.00,0.00,0.00,0.00,0.00),('1','287','1','84',750,'3','1',41597.44,41597.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','84',751,'4','1',34213.71,36617.49,2403.78,504793.80,0.00,0.00,0.00,0.00,0.00),('1','287','2','84',752,'5','1',84897.55,87489.29,2591.74,544265.40,0.00,0.00,0.00,0.00,0.00),('1','287','2','84',753,'6','1',36649.10,36649.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','84',754,'7','1',59743.43,59743.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','84',755,'8','1',48026.65,50476.86,2450.21,514544.10,0.00,0.00,0.00,0.00,0.00),('1','287','4','84',756,'9','2',219917.85,219917.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','85',757,'1','1',53400.04,53400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','85',758,'2','1',42161.25,44460.45,2299.20,482832.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','85',759,'3','1',41597.44,41597.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','85',760,'4','1',36617.49,40116.37,3498.88,734764.80,0.00,0.00,0.00,0.00,0.00),('1','287','2','85',761,'5','1',87489.29,87489.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','85',762,'6','1',36649.10,39296.67,2647.57,555989.70,0.00,0.00,0.00,0.00,0.00),('1','287','3','85',763,'7','1',59743.43,59743.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','85',764,'8','1',50476.86,52748.55,2271.69,477054.90,0.00,0.00,0.00,0.00,0.00),('1','287','4','85',765,'9','2',219917.85,220497.85,580.00,487200.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','86',766,'1','1',53400.04,53400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','86',767,'2','1',44460.45,44460.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','86',768,'3','1',41597.44,41597.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','86',769,'4','1',40116.37,40702.78,586.41,123146.10,0.00,0.00,0.00,0.00,0.00),('1','287','2','86',770,'5','1',87489.29,90011.35,2522.06,529632.60,0.00,0.00,0.00,0.00,0.00),('1','287','2','86',771,'6','1',39296.67,42076.93,2780.26,583854.60,0.00,0.00,0.00,0.00,0.00),('1','287','3','86',772,'7','1',59743.43,59743.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','86',773,'8','1',52748.55,58483.46,5734.91,1204331.10,0.00,0.00,0.00,0.00,0.00),('1','287','4','86',774,'9','2',220497.85,220497.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','87',775,'1','1',53400.04,53400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','87',776,'2','1',44460.45,44460.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','87',777,'3','1',41597.44,41597.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','87',778,'4','1',40702.78,40702.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','87',779,'5','1',90011.35,92909.61,2898.26,608634.60,0.00,0.00,0.00,0.00,0.00),('1','287','2','87',780,'6','1',42076.93,45288.07,3211.14,674339.40,0.00,0.00,0.00,0.00,0.00),('1','287','3','87',781,'7','1',59743.43,59743.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','87',782,'8','1',58483.46,65368.03,6884.57,1445759.70,0.00,0.00,0.00,0.00,0.00),('1','287','4','87',783,'9','2',220497.85,220641.51,143.66,120674.40,0.00,0.00,0.00,0.00,0.00),('1','287','1','88',784,'1','1',53400.04,53400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','88',785,'2','1',44460.45,44460.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','88',786,'3','1',41597.44,41597.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','88',787,'4','1',40702.78,40702.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','88',788,'5','1',92909.61,94740.74,1831.13,384537.30,0.00,0.00,0.00,0.00,0.00),('1','287','2','88',789,'6','1',45288.07,48444.21,3156.14,662789.40,0.00,0.00,0.00,0.00,0.00),('1','287','3','88',790,'7','1',59743.43,62739.50,2996.07,629174.70,0.00,0.00,0.00,0.00,0.00),('1','287','3','88',791,'8','1',65368.03,66646.84,1278.81,268550.10,0.00,0.00,0.00,0.00,0.00),('1','287','4','88',792,'9','2',220641.51,220641.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','89',793,'1','1',53400.04,53400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','89',794,'2','1',44460.45,44460.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','89',795,'3','1',41597.44,41597.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','89',796,'4','1',40702.78,40702.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','89',797,'5','1',94740.74,96220.55,1469.81,308660.10,0.00,0.00,10.00,0.00,0.00),('1','287','2','89',798,'6','1',48444.21,49568.06,1113.85,233908.50,0.00,0.00,10.00,0.00,0.00),('1','287','3','89',799,'7','1',62739.50,67600.91,4861.41,1020896.10,0.00,0.00,0.00,0.00,0.00),('1','287','3','89',800,'8','1',66646.84,66646.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','89',801,'9','2',220641.51,222368.36,1726.85,1450554.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','90',802,'1','1',53400.04,53400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','90',803,'2','1',44460.45,44460.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','90',804,'3','1',41597.44,41597.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','90',805,'4','1',40702.78,40702.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','90',806,'5','1',96220.55,96220.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','90',807,'6','1',49568.06,49568.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','90',808,'7','1',67600.91,71406.50,3805.59,799173.90,0.00,0.00,0.00,0.00,0.00),('1','287','3','90',809,'8','1',66646.84,66646.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','90',810,'9','2',222368.36,222368.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','91',811,'1','1',53400.04,53400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','91',812,'2','1',44460.45,44460.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','91',813,'3','1',41597.44,41597.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','91',814,'4','1',40702.78,40702.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','91',815,'5','1',96220.55,96220.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','91',816,'6','1',49568.06,49568.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','91',817,'7','1',71406.50,71406.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','91',818,'8','1',66646.84,66646.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','91',819,'9','2',222368.36,222898.77,530.41,445544.40,0.00,0.00,0.00,0.00,0.00),('1','287','1','92',820,'1','1',53400.04,53400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','92',821,'2','1',44460.45,44460.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','92',822,'3','1',41597.44,41597.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','92',823,'4','1',40702.78,40702.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','92',824,'5','1',96220.55,96220.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','92',825,'6','1',49568.06,49568.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','92',826,'7','1',71406.50,71406.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','92',827,'8','1',66646.84,66646.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','92',828,'9','2',222898.77,223776.86,878.09,737595.60,0.00,0.00,0.00,0.00,0.00),('1','287','1','93',829,'1','1',53400.04,53400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','93',830,'2','1',44460.45,44460.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','93',831,'3','1',41597.44,41597.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','93',832,'4','1',40702.78,40702.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','93',833,'5','1',96220.55,96220.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','93',834,'6','1',49568.06,49568.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','93',835,'7','1',71406.50,71406.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','93',836,'8','1',66646.84,66646.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','93',837,'9','2',223776.86,224656.86,880.00,739200.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','94',838,'1','1',53400.04,53400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','94',839,'2','1',44460.45,44460.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','94',840,'3','1',41597.44,41597.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','94',841,'4','1',40702.78,40702.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','94',842,'5','1',96220.55,96220.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','94',843,'6','1',49568.06,49568.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','94',844,'7','1',71406.50,71406.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','94',845,'8','1',66646.84,66646.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','94',846,'9','2',224656.86,225829.03,1172.17,984622.80,0.00,0.00,0.00,0.00,0.00),('1','287','1','95',847,'1','1',53400.04,53400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','95',848,'2','1',44460.45,44460.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','95',849,'3','1',41597.44,41597.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','95',850,'4','1',40702.78,40702.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','95',851,'5','1',96220.55,96220.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','95',852,'6','1',49568.06,49568.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','95',853,'7','1',71406.50,71406.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','95',854,'8','1',66646.84,66646.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','95',855,'9','2',225829.03,226186.03,357.00,299880.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','96',856,'1','1',53400.04,53400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','96',857,'2','1',44460.45,44460.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','96',858,'3','1',41597.44,41597.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','96',859,'4','1',40702.78,40702.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','96',860,'5','1',96220.55,96220.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','96',861,'6','1',49568.06,49568.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','96',862,'7','1',71406.50,71406.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','96',863,'8','1',66646.84,66646.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','96',864,'9','2',226186.03,226473.23,287.20,235504.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','97',865,'1','1',53400.04,53400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','97',866,'2','1',44460.45,44460.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','97',867,'3','1',41597.44,41597.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','97',868,'4','1',40702.78,40702.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','97',869,'5','1',96220.55,96220.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','97',870,'6','1',49568.06,49568.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','97',871,'7','1',71406.50,71406.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','97',872,'8','1',66646.84,66646.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','97',873,'9','2',226473.23,226973.96,500.73,410598.60,0.00,0.00,0.00,0.00,0.00),('1','287','1','98',874,'1','1',53400.04,53400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','98',875,'2','1',44460.45,44460.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','98',876,'3','1',41597.44,41597.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','98',877,'4','1',40702.78,40702.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','98',878,'5','1',96220.55,96220.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','98',879,'6','1',49568.06,49568.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','98',880,'7','1',71406.50,71406.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','98',881,'8','1',66646.84,66646.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','98',882,'9','2',226973.96,227328.83,354.87,290993.40,0.00,0.00,0.00,0.00,0.00),('1','287','1','99',883,'1','1',53400.04,53400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','99',884,'2','1',44460.45,44460.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','99',885,'3','1',41597.44,41597.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','99',886,'4','1',40702.78,40702.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','99',887,'5','1',96220.55,96220.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','99',888,'6','1',49568.06,49568.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','99',889,'7','1',71406.50,71406.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','99',890,'8','1',66646.84,66646.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','99',891,'9','2',227328.83,227976.68,647.85,531237.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','100',892,'1','1',53400.04,53400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','100',893,'2','1',44460.45,44460.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','100',894,'3','1',41597.44,41597.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','100',895,'4','1',40702.78,40702.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','100',896,'5','1',96220.55,96220.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','100',897,'6','1',49568.06,49568.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','100',898,'7','1',71406.50,71406.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','100',899,'8','1',66646.84,66646.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','100',900,'9','2',227976.68,229832.68,1856.00,1540480.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','101',901,'1','1',53400.04,53400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','101',902,'2','1',44460.45,44460.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','101',903,'3','1',41597.44,41597.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','101',904,'4','1',40702.78,40702.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','101',905,'5','1',96220.55,96220.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','101',906,'6','1',49568.06,49568.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','101',907,'7','1',71406.50,71406.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','101',908,'8','1',66646.84,66646.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','101',909,'9','2',229832.68,230917.02,1084.34,900002.20,0.00,0.00,0.00,0.00,0.00),('1','287','1','102',910,'1','1',53400.04,53400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','102',911,'2','1',44460.45,44460.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','102',912,'3','1',41597.44,41597.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','102',913,'4','1',40702.78,40702.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','102',914,'5','1',96220.55,96220.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','102',915,'6','1',49568.06,49568.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','102',916,'7','1',71406.50,71406.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','102',917,'8','1',66646.84,66646.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','102',918,'9','2',230917.02,231470.70,553.68,437407.20,0.00,0.00,0.00,0.00,0.00),('1','287','1','103',919,'1','1',53400.04,53400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','103',920,'2','1',44460.45,44460.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','103',921,'3','1',41597.44,41597.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','103',922,'4','1',40702.78,40702.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','103',923,'5','1',96220.55,96220.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','103',924,'6','1',49568.06,49568.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','103',925,'7','1',71406.50,71406.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','103',926,'8','1',66646.84,66646.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','103',927,'9','2',231470.70,231688.04,217.34,171698.60,0.00,0.00,0.00,0.00,0.00),('1','287','1','104',928,'1','1',53400.04,53400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','104',929,'2','1',44460.45,44460.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','104',930,'3','1',41597.44,41597.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','104',931,'4','1',40702.78,40702.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','104',932,'5','1',96220.55,96220.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','104',933,'6','1',49568.06,49568.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','104',934,'7','1',71406.50,71406.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','104',935,'8','1',66646.84,66646.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','104',936,'9','2',231688.04,232004.50,316.46,250003.40,0.00,0.00,0.00,0.00,0.00),('1','287','1','105',937,'1','1',53400.04,53400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','105',938,'2','1',44460.45,44460.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','105',939,'3','1',41597.44,41597.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','105',940,'4','1',40702.78,40702.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','105',941,'5','1',96220.55,96220.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','105',942,'6','1',49568.06,49568.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','105',943,'7','1',71406.50,71406.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','105',944,'8','1',66646.84,66646.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','105',945,'9','2',232004.50,232188.25,183.75,148837.50,0.00,0.00,0.00,0.00,0.00),('1','287','1','106',946,'1','1',53400.04,53400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','106',947,'2','1',44460.45,44460.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','106',948,'3','1',41597.44,41597.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','106',949,'4','1',40702.78,40702.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','106',950,'5','1',96220.55,96220.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','106',951,'6','1',49568.06,49568.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','106',952,'7','1',71406.50,71406.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','106',953,'8','1',66646.84,66646.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','106',954,'9','2',232188.25,232248.25,60.00,48600.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','107',955,'1','1',53400.04,53400.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','107',956,'2','1',44460.45,44460.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','107',957,'3','1',41597.44,41597.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','107',958,'4','1',40702.78,40702.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','107',959,'5','1',96220.55,96220.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','107',960,'6','1',49568.06,49568.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','107',961,'7','1',71406.50,71406.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','107',962,'8','1',66646.84,66646.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','107',963,'9','2',232248.25,232728.00,479.75,388597.50,0.00,0.00,0.00,0.00,0.00),('1','287','1','108',964,'1','1',53400.04,55221.55,1811.51,425704.85,0.00,0.00,10.00,0.00,0.00),('1','287','1','108',965,'2','1',44460.45,44529.09,58.64,13780.40,0.00,0.00,10.00,0.00,0.00),('1','287','1','108',966,'3','1',41597.44,43709.06,2106.62,495055.70,0.00,0.00,5.00,0.00,0.00),('1','287','1','108',967,'4','1',40702.78,40702.78,-7.04,-1654.40,0.00,0.00,7.04,0.00,0.00),('1','287','2','108',968,'5','1',96220.55,96220.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','108',969,'6','1',49568.06,49568.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','108',970,'7','1',71406.50,75545.79,4139.29,972733.15,0.00,0.00,0.00,0.00,0.00),('1','287','3','108',971,'8','1',66646.84,67912.61,1255.77,295105.95,0.00,0.00,10.00,0.00,0.00),('1','287','4','108',972,'9','2',232728.00,233402.00,674.00,545940.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','109',973,'1','1',55221.55,55221.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','109',974,'2','1',44529.09,44529.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','109',975,'3','1',43709.06,49027.67,5318.61,1249873.35,0.00,0.00,0.00,0.00,0.00),('1','287','1','109',976,'4','1',40702.78,43359.12,2656.34,624239.90,0.00,0.00,0.00,0.00,0.00),('1','287','2','109',977,'5','1',96220.55,96220.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','109',978,'6','1',49568.06,49568.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','109',979,'7','1',75545.79,78186.93,2641.14,620667.90,0.00,0.00,0.00,0.00,0.00),('1','287','3','109',980,'8','1',67912.61,67912.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','109',981,'9','2',233402.00,233402.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','110',982,'1','1',55221.55,55221.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','110',983,'2','1',44529.09,44529.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','110',984,'3','1',49027.67,53496.20,4468.53,1050104.55,0.00,0.00,0.00,0.00,0.00),('1','287','1','110',985,'4','1',43359.12,43476.42,117.30,27565.50,0.00,0.00,0.00,0.00,0.00),('1','287','2','110',986,'5','1',96220.55,96220.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','110',987,'6','1',49568.06,49568.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','110',988,'7','1',78186.93,81701.94,3515.01,826027.35,0.00,0.00,0.00,0.00,0.00),('1','287','3','110',989,'8','1',67912.61,67912.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','110',990,'9','2',233402.00,233402.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','111',991,'1','1',55221.55,55234.32,0.01,2.35,0.00,0.00,12.76,0.00,0.00),('1','287','1','111',992,'2','1',44529.09,44665.25,136.16,31997.60,0.00,0.00,0.00,0.00,0.00),('1','287','1','111',993,'3','1',53496.20,61527.52,8031.32,1887360.20,0.00,0.00,0.00,0.00,0.00),('1','287','1','111',994,'4','1',43476.42,43476.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','111',995,'5','1',96220.55,96220.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','111',996,'6','1',49568.06,49568.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','111',997,'7','1',81701.94,86861.19,5159.25,1212423.75,0.00,0.00,0.00,0.00,0.00),('1','287','3','111',998,'8','1',67912.61,67912.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','111',999,'9','2',233402.00,233402.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','112',1000,'1','1',55234.32,55234.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','112',1001,'2','1',44665.25,48811.61,4146.36,974394.60,0.00,0.00,0.00,0.00,0.00),('1','287','1','112',1002,'3','1',61527.52,61527.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','112',1003,'4','1',43476.42,47548.31,4071.89,956894.15,0.00,0.00,0.00,0.00,0.00),('1','287','2','112',1004,'5','1',96220.55,96220.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','112',1005,'6','1',49568.06,49568.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','112',1006,'7','1',86861.19,86861.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','112',1007,'8','1',67912.61,67912.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','112',1008,'9','2',233402.00,233402.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','113',1009,'1','1',55234.32,55234.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','113',1010,'2','1',48811.61,53260.90,4449.29,1045583.15,0.00,0.00,0.00,0.00,0.00),('1','287','1','113',1011,'3','1',61527.52,61527.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','113',1012,'4','1',47548.31,50798.66,3250.35,763832.25,0.00,0.00,0.00,0.00,0.00),('1','287','2','113',1013,'5','1',96220.55,96220.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','113',1014,'6','1',49568.06,49568.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','113',1015,'7','1',86861.19,89995.75,3134.56,736621.60,0.00,0.00,0.00,0.00,0.00),('1','287','3','113',1016,'8','1',67912.61,67912.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','113',1017,'9','2',233402.00,233902.00,500.00,400000.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','114',1018,'1','1',55234.32,55234.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','114',1019,'2','1',53260.90,56787.66,3526.76,828788.60,0.00,0.00,0.00,0.00,0.00),('1','287','1','114',1020,'3','1',61527.52,61527.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','114',1021,'4','1',50798.66,53783.17,2984.51,701359.85,0.00,0.00,0.00,0.00,0.00),('1','287','2','114',1022,'5','1',96220.55,96220.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','114',1023,'6','1',49568.06,49568.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','114',1024,'7','1',89995.75,92913.09,2917.34,685574.90,0.00,0.00,0.00,0.00,0.00),('1','287','3','114',1025,'8','1',67912.61,67912.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','114',1026,'9','2',233902.00,233902.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','115',1027,'1','1',55234.32,55234.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','115',1028,'2','1',56787.66,60625.41,3837.75,901871.25,0.00,0.00,0.00,0.00,0.00),('1','287','1','115',1029,'3','1',61527.52,61527.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','115',1030,'4','1',53783.17,56250.29,2467.12,579773.20,0.00,0.00,0.00,0.00,0.00),('1','287','2','115',1031,'5','1',96220.55,96220.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','115',1032,'6','1',49568.06,49568.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','115',1033,'7','1',92913.09,95242.87,2329.78,547498.30,0.00,0.00,0.00,0.00,0.00),('1','287','3','115',1034,'8','1',67912.61,67912.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','115',1035,'9','2',233902.00,233902.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','116',1036,'1','1',55234.32,59505.08,4256.75,1000336.25,0.00,0.00,14.01,0.00,0.00),('1','287','1','116',1037,'2','1',60625.41,60625.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','116',1038,'3','1',61527.52,65570.17,4034.73,948161.55,0.00,0.00,7.92,0.00,0.00),('1','287','1','116',1039,'4','1',56250.29,56321.79,56.30,13230.50,0.00,0.00,15.20,0.00,0.00),('1','287','2','116',1040,'5','1',96220.55,98631.11,2336.39,549051.65,0.00,0.00,74.17,0.00,0.00),('1','287','2','116',1041,'6','1',49568.06,49589.42,0.00,0.00,0.00,0.00,21.36,0.00,0.00),('1','287','3','116',1042,'7','1',95242.87,98957.22,3714.35,872872.25,0.00,0.00,0.00,0.00,0.00),('1','287','3','116',1043,'8','1',67912.61,67923.17,0.01,2.35,0.00,0.00,10.55,0.00,0.00),('1','287','4','116',1044,'9','2',233902.00,233902.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','117',1045,'1','1',59505.08,64352.16,4847.08,1139063.80,0.00,0.00,0.00,0.00,0.00),('1','287','1','117',1046,'2','1',60625.41,60625.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','117',1047,'3','1',65570.17,65570.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','117',1048,'4','1',56321.79,59048.78,2726.99,640842.65,0.00,0.00,0.00,0.00,0.00),('1','287','2','117',1049,'5','1',98631.11,100623.40,1992.29,468188.15,0.00,0.00,0.00,0.00,0.00),('1','287','2','117',1050,'6','1',49589.42,49589.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','117',1051,'7','1',98957.22,100853.63,1896.41,445656.35,0.00,0.00,0.00,0.00,0.00),('1','287','3','117',1052,'8','1',67923.17,67923.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','117',1053,'9','2',233902.00,234052.00,150.00,118500.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','118',1054,'1','1',64352.16,66338.45,1986.29,466778.15,0.00,0.00,0.00,0.00,0.00),('1','287','1','118',1055,'2','1',60625.41,60625.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','118',1056,'3','1',65570.17,65570.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','118',1057,'4','1',59048.78,61555.19,2506.41,589006.35,0.00,0.00,0.00,0.00,0.00),('1','287','2','118',1058,'5','1',100623.40,103840.75,3217.35,756077.25,0.00,0.00,0.00,0.00,0.00),('1','287','2','118',1059,'6','1',49589.42,49589.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','3','118',1060,'7','1',100853.63,103967.68,3114.05,731801.75,0.00,0.00,0.00,0.00,0.00),('1','287','3','118',1061,'8','1',67923.17,67923.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','118',1062,'9','2',234052.00,234552.00,500.00,395000.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','119',1063,'1','1',66338.45,66338.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','119',1064,'2','1',60625.41,60625.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','119',1065,'3','1',65570.17,65570.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','119',1066,'4','1',61555.19,61555.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','2','119',1067,'5','1',103840.75,103931.59,73.44,17258.40,0.00,0.00,17.40,0.00,0.00),('1','287','2','119',1068,'6','1',49589.42,49830.54,228.82,53772.70,0.00,0.00,12.30,0.00,0.00),('1','287','3','119',1069,'7','1',103967.68,109096.09,5128.41,1205176.35,0.00,0.00,0.00,0.00,0.00),('1','287','3','119',1070,'8','1',67923.17,73571.87,5648.70,1327444.50,0.00,0.00,0.00,0.00,0.00),('1','287','4','119',1071,'9','2',234552.00,234952.00,400.00,316000.00,0.00,0.00,0.00,0.00,0.00),('1','287','1','120',1072,'1','1',66338.45,71931.02,5592.57,1314253.95,0.00,0.00,0.00,0.00,0.00),('1','287','1','120',1073,'2','1',60625.41,60631.42,6.01,1412.35,0.00,0.00,0.00,0.00,0.00),('1','287','1','120',1074,'3','1',65570.17,65865.67,0.00,0.00,0.00,0.00,295.50,0.00,0.00),('1','287','1','120',1075,'4','1',61555.19,67917.91,6362.72,1495239.20,0.00,0.00,0.00,0.00,0.00),('1','287','2','120',1076,'5','1',103931.59,103992.19,0.00,0.00,0.00,0.00,60.60,0.00,0.00),('1','287','2','120',1077,'6','1',49830.54,49852.30,0.00,0.00,0.00,0.00,21.76,0.00,0.00),('1','287','3','120',1078,'7','1',109096.09,114173.72,4734.63,1112638.05,0.00,0.00,343.00,0.00,0.00),('1','287','3','120',1079,'8','1',73571.87,73571.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','287','4','120',1080,'9','2',234952.00,234952.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=241 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','287','1','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,1),('1','287','1','1',180.00,0.00,0.00,0.00,0.00,0.00,0.00,2),('1','287','2','2',770.00,0.00,0.00,0.00,0.00,0.00,0.00,3),('1','287','2','1',180.00,0.00,0.00,0.00,0.00,0.00,0.00,4),('1','287','3','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,5),('1','287','3','1',180.00,180.00,3289.21,0.00,0.00,0.00,0.00,6),('1','287','4','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,7),('1','287','4','1',180.00,180.00,5802.57,0.00,0.00,0.00,0.00,8),('1','287','5','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,9),('1','287','5','1',180.00,180.00,4495.25,0.00,0.00,0.00,0.00,10),('1','287','6','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,11),('1','287','6','1',180.00,180.00,4021.39,0.00,0.00,0.00,0.00,12),('1','287','7','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,13),('1','287','7','1',180.00,180.00,3598.02,0.00,0.00,0.00,0.00,14),('1','287','8','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,15),('1','287','8','1',180.00,180.00,2738.72,0.00,0.00,0.00,0.00,16),('1','287','9','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,17),('1','287','9','1',180.00,180.00,3729.60,0.00,0.00,0.00,0.00,18),('1','287','10','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,19),('1','287','10','1',180.00,180.00,3845.82,0.00,0.00,0.00,0.00,20),('1','287','11','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,21),('1','287','11','1',180.00,180.00,3226.70,0.00,0.00,0.00,0.00,22),('1','287','12','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,23),('1','287','12','1',180.00,180.00,3590.61,0.00,0.00,0.00,0.00,24),('1','287','13','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,25),('1','287','13','1',180.00,180.00,3609.10,0.00,0.00,0.00,0.00,26),('1','287','14','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,27),('1','287','14','1',180.00,180.00,3318.47,0.00,0.00,0.00,0.00,28),('1','287','15','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,29),('1','287','15','1',180.00,180.00,2169.42,0.00,0.00,0.00,0.00,30),('1','287','16','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,31),('1','287','16','1',180.00,180.00,1150.98,0.00,0.00,0.00,0.00,32),('1','287','17','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,33),('1','287','17','1',180.00,180.00,3834.09,0.00,0.00,0.00,0.00,34),('1','287','18','2',770.00,770.00,10.39,0.00,0.00,0.00,0.00,35),('1','287','18','1',180.00,180.00,3320.56,0.00,0.00,0.00,0.00,36),('1','287','19','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,37),('1','287','19','1',180.00,180.00,2954.28,0.00,0.00,0.00,0.00,38),('1','287','20','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,39),('1','287','20','1',180.00,180.00,2318.32,0.00,0.00,0.00,0.00,40),('1','287','21','2',770.00,770.00,50.00,0.00,0.00,0.00,0.00,41),('1','287','21','1',180.00,180.00,2335.08,0.00,0.00,0.00,0.00,42),('1','287','22','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,43),('1','287','22','1',180.00,180.00,3037.96,0.00,0.00,0.00,0.00,44),('1','287','23','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,45),('1','287','23','1',180.00,180.00,2694.59,0.00,0.00,0.00,0.00,46),('1','287','24','2',770.00,770.00,101.69,0.00,0.00,0.00,0.00,47),('1','287','24','1',180.00,180.00,3887.86,0.00,0.00,0.00,0.00,48),('1','287','25','2',770.00,770.00,50.00,0.00,0.00,0.00,0.00,49),('1','287','25','1',180.00,180.00,2735.02,0.00,0.00,0.00,0.00,50),('1','287','26','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,51),('1','287','26','1',180.00,180.00,3070.39,0.00,0.00,0.00,0.00,52),('1','287','27','2',770.00,770.00,78.99,0.00,0.00,0.00,0.00,53),('1','287','27','1',180.00,180.00,2515.46,0.00,0.00,0.00,0.00,54),('1','287','28','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,55),('1','287','28','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,56),('1','287','29','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,57),('1','287','29','1',180.00,180.00,2671.10,0.00,0.00,0.00,0.00,58),('1','287','30','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,59),('1','287','30','1',180.00,180.00,1506.15,0.00,0.00,0.00,0.00,60),('1','287','31','2',770.00,770.00,92.57,0.00,0.00,0.00,0.00,61),('1','287','31','1',180.00,180.00,3068.65,0.00,0.00,0.00,0.00,62),('1','287','32','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,63),('1','287','32','1',180.00,180.00,1705.32,0.00,0.00,0.00,0.00,64),('1','287','33','2',770.00,770.00,64.63,0.00,0.00,0.00,0.00,65),('1','287','33','1',180.00,180.00,3171.85,0.00,0.00,0.00,0.00,66),('1','287','34','2',770.00,770.00,40.00,0.00,0.00,0.00,0.00,67),('1','287','34','1',180.00,180.00,2455.10,0.00,0.00,0.00,0.00,68),('1','287','35','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,69),('1','287','35','1',180.00,180.00,3273.16,0.00,0.00,0.00,0.00,70),('1','287','36','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,71),('1','287','36','1',180.00,180.00,2352.15,0.00,0.00,0.00,0.00,72),('1','287','37','2',770.00,770.00,50.00,0.00,0.00,0.00,0.00,73),('1','287','37','1',180.00,180.00,3938.51,0.00,0.00,0.00,0.00,74),('1','287','38','2',770.00,770.00,50.00,0.00,0.00,0.00,0.00,75),('1','287','38','1',180.00,180.00,2691.73,0.00,0.00,0.00,0.00,76),('1','287','39','2',770.00,770.00,0.00,0.00,0.00,0.00,0.00,77),('1','287','39','1',180.00,180.00,3935.15,0.00,0.00,0.00,0.00,78),('1','287','40','2',770.00,770.00,150.00,0.00,0.00,0.00,0.00,79),('1','287','40','1',180.00,180.00,2792.64,0.00,0.00,0.00,0.00,80),('1','287','41','2',770.00,800.00,3.75,0.00,0.00,0.00,0.00,81),('1','287','41','1',180.00,180.00,3910.65,0.00,0.00,0.00,0.00,82),('1','287','42','2',770.00,800.00,50.00,0.00,0.00,0.00,0.00,83),('1','287','42','1',180.00,180.00,2922.00,0.00,0.00,0.00,0.00,84),('1','287','43','2',770.00,800.00,4.00,0.00,0.00,0.00,0.00,85),('1','287','43','1',180.00,180.00,4340.64,0.00,0.00,0.00,0.00,86),('1','287','44','2',770.00,800.00,50.00,0.00,0.00,0.00,0.00,87),('1','287','44','1',180.00,180.00,5011.62,0.00,0.00,0.00,0.00,88),('1','287','45','2',770.00,800.00,0.00,0.00,0.00,0.00,0.00,89),('1','287','45','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,90),('1','287','46','2',770.00,800.00,0.00,0.00,0.00,0.00,0.00,91),('1','287','46','1',180.00,180.00,7309.05,0.00,0.00,0.00,0.00,92),('1','287','47','2',800.00,800.00,78.25,0.00,0.00,0.00,0.00,93),('1','287','47','1',180.00,180.00,2684.28,0.00,0.00,0.00,0.00,94),('1','287','48','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,95),('1','287','48','1',180.00,180.00,6213.75,0.00,0.00,0.00,0.00,96),('1','287','49','2',800.00,800.00,33.75,0.00,0.00,0.00,0.00,97),('1','287','49','1',180.00,180.00,947.63,0.00,0.00,0.00,0.00,98),('1','287','50','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,99),('1','287','50','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,100),('1','287','51','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,101),('1','287','51','1',180.00,180.00,10226.35,0.00,0.00,0.00,0.00,102),('1','287','52','2',800.00,800.00,32.50,0.00,0.00,0.00,0.00,103),('1','287','52','1',180.00,180.00,6330.52,0.00,0.00,0.00,0.00,104),('1','287','53','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,105),('1','287','53','1',180.00,180.00,5889.55,0.00,0.00,0.00,0.00,106),('1','287','54','2',800.00,800.00,780.00,0.00,0.00,0.00,0.00,107),('1','287','54','1',180.00,180.00,6524.30,0.00,0.00,0.00,0.00,108),('1','287','55','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,109),('1','287','55','1',180.00,180.00,6146.97,0.00,0.00,0.00,0.00,110),('1','287','56','2',800.00,800.00,30.00,0.00,0.00,0.00,0.00,111),('1','287','56','1',180.00,180.00,5526.18,0.00,0.00,0.00,0.00,112),('1','287','57','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,113),('1','287','57','1',180.00,180.00,7726.94,0.00,0.00,0.00,0.00,114),('1','287','58','2',800.00,800.00,30.00,0.00,0.00,0.00,0.00,115),('1','287','58','1',180.00,180.00,5918.54,0.00,0.00,0.00,0.00,116),('1','287','59','2',800.00,800.00,70.00,0.00,0.00,0.00,0.00,117),('1','287','59','1',180.00,180.00,6610.70,0.00,0.00,0.00,0.00,118),('1','287','60','2',800.00,800.00,30.00,0.00,0.00,0.00,0.00,119),('1','287','60','1',180.00,180.00,5741.65,0.00,0.00,0.00,0.00,120),('1','287','61','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,121),('1','287','61','1',180.00,180.00,7281.21,0.00,0.00,0.00,0.00,122),('1','287','62','2',800.00,800.00,30.00,0.00,0.00,0.00,0.00,123),('1','287','62','1',180.00,180.00,6144.52,0.00,0.00,0.00,0.00,124),('1','287','63','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,125),('1','287','63','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,126),('1','287','64','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,127),('1','287','64','1',180.00,180.00,10558.04,0.00,0.00,0.00,0.00,128),('1','287','65','2',800.00,800.00,30.00,0.00,0.00,0.00,0.00,129),('1','287','65','1',180.00,180.00,6559.73,0.00,0.00,0.00,0.00,130),('1','287','66','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,131),('1','287','66','1',180.00,180.00,7818.09,0.00,0.00,0.00,0.00,132),('1','287','67','2',800.00,800.00,45.01,0.00,0.00,0.00,0.00,133),('1','287','67','1',180.00,180.00,7680.98,0.00,0.00,0.00,0.00,134),('1','287','68','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,135),('1','287','68','1',180.00,180.00,6734.91,0.00,0.00,0.00,0.00,136),('1','287','69','2',800.00,800.00,108.75,0.00,0.00,0.00,0.00,137),('1','287','69','1',180.00,180.00,4828.68,0.00,0.00,0.00,0.00,138),('1','287','70','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,139),('1','287','70','1',180.00,180.00,5771.08,0.00,0.00,0.00,0.00,140),('1','287','71','2',800.00,800.00,30.00,0.00,0.00,0.00,0.00,141),('1','287','71','1',180.00,180.00,3974.28,0.00,0.00,0.00,0.00,142),('1','287','72','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,143),('1','287','72','1',180.00,180.00,5327.04,0.00,0.00,0.00,0.00,144),('1','287','73','2',800.00,800.00,30.00,0.00,0.00,0.00,0.00,145),('1','287','73','1',180.00,180.00,3899.72,0.00,0.00,0.00,0.00,146),('1','287','74','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,147),('1','287','74','1',180.00,180.00,4015.51,0.00,0.00,0.00,0.00,148),('1','287','75','2',800.00,800.00,30.00,0.00,0.00,0.00,0.00,149),('1','287','75','1',180.00,180.00,3158.19,0.00,0.00,0.00,0.00,150),('1','287','76','2',825.00,825.00,0.00,0.00,0.00,0.00,0.00,151),('1','287','76','1',180.00,180.00,0.00,0.00,0.00,0.00,0.00,152),('1','287','77','2',825.00,825.00,1830.00,0.00,0.00,0.00,0.00,153),('1','287','77','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,154),('1','287','78','2',840.00,840.00,279.52,0.00,0.00,0.00,0.00,155),('1','287','78','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,156),('1','287','79','2',840.00,840.00,0.00,0.00,0.00,0.00,0.00,157),('1','287','79','1',210.00,210.00,11886.96,0.00,0.00,0.00,0.00,158),('1','287','80','2',840.00,840.00,916.35,0.00,0.00,0.00,0.00,159),('1','287','80','1',210.00,210.00,10438.44,0.00,0.00,0.00,0.00,160),('1','287','81','2',840.00,840.00,0.00,0.00,0.00,0.00,0.00,161),('1','287','81','1',210.00,210.00,10538.86,0.00,0.00,0.00,0.00,162),('1','287','82','2',840.00,840.00,160.15,0.00,0.00,0.00,0.00,163),('1','287','82','1',210.00,210.00,10217.68,0.00,0.00,0.00,0.00,164),('1','287','83','2',840.00,840.00,0.00,0.00,0.00,0.00,0.00,165),('1','287','83','1',210.00,210.00,10926.99,0.00,0.00,0.00,0.00,166),('1','287','84','2',840.00,840.00,0.00,0.00,0.00,0.00,0.00,167),('1','287','84','1',210.00,210.00,10049.28,0.00,0.00,0.00,0.00,168),('1','287','85','2',840.00,840.00,580.00,0.00,0.00,0.00,0.00,169),('1','287','85','1',210.00,210.00,10717.34,0.00,0.00,0.00,0.00,170),('1','287','86','2',840.00,840.00,0.00,0.00,0.00,0.00,0.00,171),('1','287','86','1',210.00,210.00,11623.64,0.00,0.00,0.00,0.00,172),('1','287','87','2',840.00,840.00,143.66,0.00,0.00,0.00,0.00,173),('1','287','87','1',210.00,210.00,12993.97,0.00,0.00,0.00,0.00,174),('1','287','88','2',840.00,840.00,0.00,0.00,0.00,0.00,0.00,175),('1','287','88','1',210.00,210.00,9262.15,0.00,0.00,0.00,0.00,176),('1','287','89','2',840.00,840.00,1726.85,0.00,0.00,0.00,0.00,177),('1','287','89','1',210.00,210.00,7445.07,0.00,0.00,0.00,0.00,178),('1','287','90','2',840.00,840.00,0.00,0.00,0.00,0.00,0.00,179),('1','287','90','1',210.00,210.00,3805.59,0.00,0.00,0.00,0.00,180),('1','287','91','2',840.00,840.00,530.41,0.00,0.00,0.00,0.00,181),('1','287','91','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,182),('1','287','92','2',840.00,840.00,878.09,0.00,0.00,0.00,0.00,183),('1','287','92','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,184),('1','287','93','2',840.00,840.00,880.00,0.00,0.00,0.00,0.00,185),('1','287','93','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,186),('1','287','94','2',840.00,840.00,1172.17,0.00,0.00,0.00,0.00,187),('1','287','94','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,188),('1','287','95','2',840.00,840.00,357.00,0.00,0.00,0.00,0.00,189),('1','287','95','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,190),('1','287','96','2',820.00,820.00,287.20,0.00,0.00,0.00,0.00,191),('1','287','96','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,192),('1','287','97','2',820.00,820.00,500.73,0.00,0.00,0.00,0.00,193),('1','287','97','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,194),('1','287','98','2',820.00,820.00,354.87,0.00,0.00,0.00,0.00,195),('1','287','98','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,196),('1','287','99','2',820.00,820.00,647.85,0.00,0.00,0.00,0.00,197),('1','287','99','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,198),('1','287','100','2',830.00,830.00,1856.00,0.00,0.00,0.00,0.00,199),('1','287','100','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,200),('1','287','101','2',830.00,830.00,1084.34,0.00,0.00,0.00,0.00,201),('1','287','101','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,202),('1','287','102','2',790.00,790.00,553.68,0.00,0.00,0.00,0.00,203),('1','287','102','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,204),('1','287','103','2',790.00,790.00,217.34,0.00,0.00,0.00,0.00,205),('1','287','103','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,206),('1','287','104','2',790.00,790.00,316.46,0.00,0.00,0.00,0.00,207),('1','287','104','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,208),('1','287','105','2',810.00,810.00,183.75,0.00,0.00,0.00,0.00,209),('1','287','105','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,210),('1','287','106','2',810.00,810.00,60.00,0.00,0.00,0.00,0.00,211),('1','287','106','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,212),('1','287','107','2',810.00,810.00,479.75,0.00,0.00,0.00,0.00,213),('1','287','107','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,214),('1','287','108','2',810.00,810.00,674.00,0.00,0.00,0.00,0.00,215),('1','287','108','1',235.00,235.00,9364.79,0.00,0.00,0.00,0.00,216),('1','287','109','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,217),('1','287','109','1',235.00,235.00,10616.09,0.00,0.00,0.00,0.00,218),('1','287','110','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,219),('1','287','110','1',235.00,235.00,8100.84,0.00,0.00,0.00,0.00,220),('1','287','111','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,221),('1','287','111','1',235.00,235.00,13326.74,0.00,0.00,0.00,0.00,222),('1','287','112','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,223),('1','287','112','1',235.00,235.00,8218.25,0.00,0.00,0.00,0.00,224),('1','287','113','2',800.00,800.00,500.00,0.00,0.00,0.00,0.00,225),('1','287','113','1',235.00,235.00,10834.20,0.00,0.00,0.00,0.00,226),('1','287','114','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,227),('1','287','114','1',235.00,235.00,9428.61,0.00,0.00,0.00,0.00,228),('1','287','115','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,229),('1','287','115','1',235.00,235.00,8634.65,0.00,0.00,0.00,0.00,230),('1','287','116','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,231),('1','287','116','1',235.00,235.00,14398.53,0.00,0.00,0.00,0.00,232),('1','287','117','2',790.00,790.00,150.00,0.00,0.00,0.00,0.00,233),('1','287','117','1',235.00,235.00,11462.77,0.00,0.00,0.00,0.00,234),('1','287','118','2',790.00,790.00,500.00,0.00,0.00,0.00,0.00,235),('1','287','118','1',235.00,235.00,10824.10,0.00,0.00,0.00,0.00,236),('1','287','119','2',790.00,790.00,400.00,0.00,0.00,0.00,0.00,237),('1','287','119','1',235.00,235.00,11079.37,0.00,0.00,0.00,0.00,238),('1','287','120','2',790.00,790.00,0.00,0.00,0.00,0.00,0.00,239),('1','287','120','1',235.00,235.00,16695.93,0.00,0.00,0.00,0.00,240);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
INSERT INTO `depots_shifts_stocklevels` VALUES (1,'1','287','9','2022-10-29 10:45:14','968','1',0.00,73550.00,0.00),(2,'1','287','11','2022-10-29 13:52:40','968','1',0.00,67400.00,0.00),(3,'1','287','11','2022-10-29 13:53:38','968','1',0.00,48550.00,0.00),(4,'1','287','11','2022-10-29 13:54:39','968','1',0.00,45750.00,0.00),(5,'1','287','11','2022-10-29 13:54:42','968','1',0.00,45750.00,0.00),(6,'1','287','11','2022-10-29 13:56:16','968','1',0.00,39900.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',1,'287','PMS TANKS',''),('1',2,'287','AGO TANKS','');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','287','1',1,0,'1','PMS TANK 1',40000.00,0.00,NULL,'CONTAING PMS','178','2022-10-22 13:40:34','2022-10-22 13:40:34','178',5,0),('1','287','1',2,0,'1','PMS TANK 2',40000.00,0.00,NULL,'CONTAING PMS','178','2022-10-22 13:43:01','2022-10-22 13:43:01','178',5,0),('1','287','1',3,0,'1','PMS TANK 3',40000.00,0.00,NULL,'CONTAING PMS','178','2022-10-22 13:45:05','2022-10-22 13:45:05','178',5,0),('1','287','2',4,0,'2','AGO TANK 1',40000.00,0.00,NULL,'CONTAING AGO','178','2022-10-22 13:49:12','2022-10-22 13:49:12','178',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','287',4,14450.00,'2023-03-19 13:47:52'),(2,'1','287',3,13061.41,'2023-03-19 13:47:52'),(3,'1','287',2,7733.45,'2023-03-19 13:47:52'),(4,'1','287',1,25000.30,'2023-03-19 13:47:52');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=712 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'1','287',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9000000.00,50000.00,0.00,0.00,'2022-10-27 11:18:29','',''),(2,'1','287',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,16100.00,0.00,'2022-10-27 17:18:03','',''),(3,'1','287','3',1,'Received from bridging 3',0.00,0.00,16100.00,0.00,0.00,'2022-10-27 17:18:03','',''),(4,'1','287',NULL,1,'Reception corrector for bridging 2',0.00,0.00,0.00,16200.00,0.00,'2022-10-27 17:18:03','',''),(5,'1','287','2',1,'Received from bridging 2',0.00,0.00,16200.00,0.00,0.00,'2022-10-27 17:18:03','',''),(6,'1','287',NULL,1,'Reception corrector for bridging 1',0.00,0.00,0.00,16250.00,0.00,'2022-10-27 17:18:03','',''),(7,'1','287','1',1,'Received from bridging 1',0.00,0.00,16250.00,0.00,0.00,'2022-10-27 17:18:03','',''),(8,'1','287',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,15323000.00,19900.00,0.00,0.00,'2022-10-28 07:08:49','',''),(9,'1','287',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9000000.00,50000.00,0.00,0.00,'2022-10-28 07:09:10','',''),(10,'1','287',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9000000.00,50000.00,0.00,0.00,'2022-10-28 07:09:30','',''),(11,'1','287',NULL,1,'Returned purchase #3 to AA RANO NIGERIA LTD',9000000.00,0.00,0.00,50000.00,0.00,'2022-10-28 07:11:04','',''),(12,'1','287','1',1,'Sale Id shift 3',0.00,0.00,0.00,1078.64,0.00,'2022-10-28 09:13:13','',''),(13,'1','287','1',1,'Sale Id shift 3',0.00,0.00,0.00,670.30,0.00,'2022-10-28 09:13:13','',''),(14,'1','287','2',1,'Sale Id shift 3',0.00,0.00,0.00,1118.68,0.00,'2022-10-28 09:13:13','',''),(15,'1','287','3',1,'Sale Id shift 3',0.00,0.00,0.00,421.59,0.00,'2022-10-28 09:13:13','',''),(16,'1','287',NULL,1,'Sale Id shift 3',592057.80,0.00,0.00,0.00,0.00,'2022-10-28 09:13:13','',''),(17,'1','287','1',1,'Sale Id shift 4',0.00,0.00,0.00,2073.20,0.00,'2022-10-28 09:30:32','',''),(18,'1','287','1',1,'Sale Id shift 4',0.00,0.00,0.00,1136.76,0.00,'2022-10-28 09:30:32','',''),(19,'1','287','2',1,'Sale Id shift 4',0.00,0.00,0.00,2080.82,0.00,'2022-10-28 09:30:32','',''),(20,'1','287','3',1,'Sale Id shift 4',0.00,0.00,0.00,511.78,0.00,'2022-10-28 09:30:32','',''),(21,'1','287','3',1,'Sale Id shift 4',0.00,0.00,0.00,0.01,0.00,'2022-10-28 09:30:32','',''),(22,'1','287',NULL,1,'Sale Id shift 4',1044462.60,0.00,0.00,0.00,0.00,'2022-10-28 09:30:32','',''),(23,'1','287','1',1,'Sale Id shift 5',0.00,0.00,0.00,1927.62,0.00,'2022-10-29 08:34:54','',''),(24,'1','287','2',1,'Sale Id shift 5',0.00,0.00,0.00,963.82,0.00,'2022-10-29 08:34:54','',''),(25,'1','287','2',1,'Sale Id shift 5',0.00,0.00,0.00,554.29,0.00,'2022-10-29 08:34:54','',''),(26,'1','287','3',1,'Sale Id shift 5',0.00,0.00,0.00,1049.52,0.00,'2022-10-29 08:34:54','',''),(27,'1','287',NULL,1,'Sale Id shift 5',809145.00,0.00,0.00,0.00,0.00,'2022-10-29 08:34:54','',''),(28,'1','287','1',1,'Sale Id shift 6',0.00,0.00,0.00,1486.69,0.00,'2022-10-29 09:17:35','',''),(29,'1','287','2',1,'Sale Id shift 6',0.00,0.00,0.00,1243.80,0.00,'2022-10-29 09:17:35','',''),(30,'1','287','2',1,'Sale Id shift 6',0.00,0.00,0.00,620.09,0.00,'2022-10-29 09:17:35','',''),(31,'1','287','3',1,'Sale Id shift 6',0.00,0.00,0.00,670.81,0.00,'2022-10-29 09:17:35','',''),(32,'1','287',NULL,1,'Sale Id shift 6',723850.20,0.00,0.00,0.00,0.00,'2022-10-29 09:17:35','',''),(33,'1','287','1',1,'Sale Id shift 7',0.00,0.00,0.00,895.87,0.00,'2022-10-29 09:33:52','',''),(34,'1','287','1',1,'Sale Id shift 7',0.00,0.00,0.00,102.72,0.00,'2022-10-29 09:33:52','',''),(35,'1','287','2',1,'Sale Id shift 7',0.00,0.00,0.00,1061.28,0.00,'2022-10-29 09:33:52','',''),(36,'1','287','3',1,'Sale Id shift 7',0.00,0.00,0.00,858.43,0.00,'2022-10-29 09:33:52','',''),(37,'1','287','3',1,'Sale Id shift 7',0.00,0.00,0.00,679.72,0.00,'2022-10-29 09:33:52','',''),(38,'1','287',NULL,1,'Sale Id shift 7',647643.60,0.00,0.00,0.00,0.00,'2022-10-29 09:33:52','',''),(39,'1','287','1',1,'Sale Id shift 8',0.00,0.00,0.00,528.24,0.00,'2022-10-29 10:27:34','',''),(40,'1','287','1',1,'Sale Id shift 8',0.00,0.00,0.00,99.00,0.00,'2022-10-29 10:27:34','',''),(41,'1','287','2',1,'Sale Id shift 8',0.00,0.00,0.00,105.34,0.00,'2022-10-29 10:27:34','',''),(42,'1','287','2',1,'Sale Id shift 8',0.00,0.00,0.00,1321.91,0.00,'2022-10-29 10:27:34','',''),(43,'1','287','3',1,'Sale Id shift 8',0.00,0.00,0.00,684.23,0.00,'2022-10-29 10:27:34','',''),(44,'1','287',NULL,1,'Sale Id shift 8',492969.60,0.00,0.00,0.00,0.00,'2022-10-29 10:27:34','',''),(45,'1','287','1',1,'Sale Id shift 9',0.00,0.00,0.00,1066.78,0.00,'2022-10-29 10:55:36','',''),(46,'1','287','1',1,'Sale Id shift 9',0.00,0.00,0.00,1586.34,0.00,'2022-10-29 10:55:36','',''),(47,'1','287','2',1,'Sale Id shift 9',0.00,0.00,0.00,648.87,0.00,'2022-10-29 10:55:36','',''),(48,'1','287','2',1,'Sale Id shift 9',0.00,0.00,0.00,19.69,0.00,'2022-10-29 10:55:36','',''),(49,'1','287','3',1,'Sale Id shift 9',0.00,0.00,0.00,266.52,0.00,'2022-10-29 10:55:36','',''),(50,'1','287','3',1,'Sale Id shift 9',0.00,0.00,0.00,141.40,0.00,'2022-10-29 10:55:36','',''),(51,'1','287',NULL,1,'Sale Id shift 9',671328.00,0.00,0.00,0.00,0.00,'2022-10-29 10:55:36','',''),(52,'1','287','1',1,'Sale Id shift 10',0.00,0.00,0.00,1186.69,0.00,'2022-10-29 11:17:27','',''),(53,'1','287','1',1,'Sale Id shift 10',0.00,0.00,0.00,109.94,0.00,'2022-10-29 11:17:27','',''),(54,'1','287','2',1,'Sale Id shift 10',0.00,0.00,0.00,809.69,0.00,'2022-10-29 11:17:27','',''),(55,'1','287','2',1,'Sale Id shift 10',0.00,0.00,0.00,796.62,0.00,'2022-10-29 11:17:27','',''),(56,'1','287','3',1,'Sale Id shift 10',0.00,0.00,0.00,942.88,0.00,'2022-10-29 11:17:27','',''),(57,'1','287',NULL,1,'Sale Id shift 10',692247.60,0.00,0.00,0.00,0.00,'2022-10-29 11:17:27','',''),(58,'1','287',NULL,1,'Reception corrector for bridging 6',0.00,0.00,0.00,16500.00,0.00,'2022-10-29 14:58:09','',''),(59,'1','287','3',1,'Received from bridging 6',0.00,0.00,16500.00,0.00,0.00,'2022-10-29 14:58:09','',''),(60,'1','287',NULL,1,'Reception corrector for bridging 5',0.00,0.00,0.00,16500.00,0.00,'2022-10-29 14:58:09','',''),(61,'1','287','2',1,'Received from bridging 5',0.00,0.00,16500.00,0.00,0.00,'2022-10-29 14:58:09','',''),(62,'1','287',NULL,1,'Reception corrector for bridging 4',0.00,0.00,0.00,17000.00,0.00,'2022-10-29 14:58:09','',''),(63,'1','287','1',1,'Received from bridging 4',0.00,0.00,17000.00,0.00,0.00,'2022-10-29 14:58:09','',''),(64,'1','287',NULL,2,'Reception corrector for bridging 7',0.00,0.00,0.00,19900.00,0.00,'2022-10-29 15:02:55','',''),(65,'1','287','4',2,'Received from bridging 7',0.00,0.00,19900.00,0.00,0.00,'2022-10-29 15:02:55','',''),(66,'1','287','1',1,'Sale Id shift 11',0.00,0.00,0.00,1033.67,0.00,'2022-10-30 11:13:03','',''),(67,'1','287','1',1,'Sale Id shift 11',0.00,0.00,0.00,640.39,0.00,'2022-10-30 11:13:03','',''),(68,'1','287','2',1,'Sale Id shift 11',0.00,0.00,0.00,1041.52,0.00,'2022-10-30 11:13:03','',''),(69,'1','287','3',1,'Sale Id shift 11',0.00,0.00,0.00,511.12,0.00,'2022-10-30 11:13:03','',''),(70,'1','287',NULL,1,'Sale Id shift 11',580806.00,0.00,0.00,0.00,0.00,'2022-10-30 11:13:03','',''),(71,'1','287','1',1,'Sale Id shift 12',0.00,0.00,0.00,1446.92,0.00,'2022-10-30 11:33:23','',''),(72,'1','287','1',1,'Sale Id shift 12',0.00,0.00,0.00,683.79,0.00,'2022-10-30 11:33:23','',''),(73,'1','287','2',1,'Sale Id shift 12',0.00,0.00,0.00,718.86,0.00,'2022-10-30 11:33:23','',''),(74,'1','287','3',1,'Sale Id shift 12',0.00,0.00,0.00,741.04,0.00,'2022-10-30 11:33:23','',''),(75,'1','287',NULL,1,'Sale Id shift 12',646309.80,0.00,0.00,0.00,0.00,'2022-10-30 11:33:23','',''),(76,'1','287','1',1,'Sale Id shift 13',0.00,0.00,0.00,1318.66,0.00,'2022-10-30 13:01:58','',''),(77,'1','287','1',1,'Sale Id shift 13',0.00,0.00,0.00,793.72,0.00,'2022-10-30 13:01:58','',''),(78,'1','287','2',1,'Sale Id shift 13',0.00,0.00,0.00,1166.81,0.00,'2022-10-30 13:01:58','',''),(79,'1','287','3',1,'Sale Id shift 13',0.00,0.00,0.00,329.91,0.00,'2022-10-30 13:01:58','',''),(80,'1','287',NULL,1,'Sale Id shift 13',649638.00,0.00,0.00,0.00,0.00,'2022-10-30 13:01:58','',''),(81,'1','287','1',1,'Sale Id shift 14',0.00,0.00,0.00,1359.73,0.00,'2022-10-30 14:23:09','',''),(82,'1','287','1',1,'Sale Id shift 14',0.00,0.00,0.00,180.16,0.00,'2022-10-30 14:23:09','',''),(83,'1','287','2',1,'Sale Id shift 14',0.00,0.00,0.00,467.78,0.00,'2022-10-30 14:23:09','',''),(84,'1','287','3',1,'Sale Id shift 14',0.00,0.00,0.00,36.10,0.00,'2022-10-30 14:23:09','',''),(85,'1','287','3',1,'Sale Id shift 14',0.00,0.00,0.00,1274.70,0.00,'2022-10-30 14:23:09','',''),(86,'1','287',NULL,1,'Sale Id shift 14',597324.60,0.00,0.00,0.00,0.00,'2022-10-30 14:23:09','',''),(87,'1','287','1',1,'Sale Id shift 15',0.00,0.00,0.00,739.95,0.00,'2022-10-30 23:07:04','',''),(88,'1','287','1',1,'Sale Id shift 15',0.00,0.00,0.00,0.76,0.00,'2022-10-30 23:07:04','',''),(89,'1','287','2',1,'Sale Id shift 15',0.00,0.00,0.00,625.22,0.00,'2022-10-30 23:07:04','',''),(90,'1','287','3',1,'Sale Id shift 15',0.00,0.00,0.00,527.29,0.00,'2022-10-30 23:07:04','',''),(91,'1','287','3',1,'Sale Id shift 15',0.00,0.00,0.00,276.20,0.00,'2022-10-30 23:07:04','',''),(92,'1','287',NULL,1,'Sale Id shift 15',390495.60,0.00,0.00,0.00,0.00,'2022-10-30 23:07:04','',''),(93,'1','287','1',1,'Sale Id shift 16',0.00,0.00,0.00,228.27,0.00,'2022-11-01 09:09:19','',''),(94,'1','287','1',1,'Sale Id shift 16',0.00,0.00,0.00,247.01,0.00,'2022-11-01 09:09:19','',''),(95,'1','287','2',1,'Sale Id shift 16',0.00,0.00,0.00,440.12,0.00,'2022-11-01 09:09:19','',''),(96,'1','287','3',1,'Sale Id shift 16',0.00,0.00,0.00,235.58,0.00,'2022-11-01 09:09:19','',''),(97,'1','287',NULL,1,'Sale Id shift 16',207176.40,0.00,0.00,0.00,0.00,'2022-11-01 09:09:19','',''),(98,'1','287','1',1,'Sale Id shift 17',0.00,0.00,0.00,1129.50,0.00,'2022-11-01 18:06:41','',''),(99,'1','287','1',1,'Sale Id shift 17',0.00,0.00,0.00,402.94,0.00,'2022-11-01 18:06:41','',''),(100,'1','287','1',1,'Sale Id shift 17',0.00,0.00,0.00,339.65,0.00,'2022-11-01 18:06:41','',''),(101,'1','287','2',1,'Sale Id shift 17',0.00,0.00,0.00,831.60,0.00,'2022-11-01 18:06:41','',''),(102,'1','287','3',1,'Sale Id shift 17',0.00,0.00,0.00,1130.40,0.00,'2022-11-01 18:06:41','',''),(103,'1','287',NULL,1,'Sale Id shift 17',690136.20,0.00,0.00,0.00,0.00,'2022-11-01 18:06:41','',''),(104,'1','287','1',1,'Sale Id shift 18',0.00,0.00,0.00,981.37,0.00,'2022-11-01 20:44:44','',''),(105,'1','287','1',1,'Sale Id shift 18',0.00,0.00,0.00,807.60,0.00,'2022-11-01 20:44:44','',''),(106,'1','287','1',1,'Sale Id shift 18',0.00,0.00,0.00,66.62,0.00,'2022-11-01 20:44:44','',''),(107,'1','287','2',1,'Sale Id shift 18',0.00,0.00,0.00,817.55,0.00,'2022-11-01 20:44:44','',''),(108,'1','287','2',1,'Sale Id shift 18',0.00,0.00,0.00,81.08,0.00,'2022-11-01 20:44:44','',''),(109,'1','287','3',1,'Sale Id shift 18',0.00,0.00,0.00,566.34,0.00,'2022-11-01 20:44:44','',''),(110,'1','287','4',2,'Sale Id shift 18',0.00,0.00,0.00,10.39,0.00,'2022-11-01 20:44:44','',''),(111,'1','287',NULL,2,'Sale Id shift 18',8000.30,0.00,0.00,0.00,0.00,'2022-11-01 20:44:44','',''),(112,'1','287',NULL,1,'Sale Id shift 18',597700.80,0.00,0.00,0.00,0.00,'2022-11-01 20:44:44','',''),(113,'1','287','1',1,'Sale Id shift 19',0.00,0.00,0.00,1140.30,0.00,'2022-11-02 18:58:52','',''),(114,'1','287','2',1,'Sale Id shift 19',0.00,0.00,0.00,687.63,0.00,'2022-11-02 18:58:52','',''),(115,'1','287','2',1,'Sale Id shift 19',0.00,0.00,0.00,473.86,0.00,'2022-11-02 18:58:52','',''),(116,'1','287','3',1,'Sale Id shift 19',0.00,0.00,0.00,652.49,0.00,'2022-11-02 18:58:52','',''),(117,'1','287',NULL,1,'Sale Id shift 19',531770.40,0.00,0.00,0.00,0.00,'2022-11-02 18:58:52','',''),(118,'1','287',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9000000.00,50000.00,0.00,0.00,'2022-11-02 18:59:22','',''),(119,'1','287',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9000000.00,50000.00,0.00,0.00,'2022-11-02 19:00:10','',''),(120,'1','287',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9000000.00,50000.00,0.00,0.00,'2022-11-02 19:01:14','',''),(121,'1','287',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9000000.00,50000.00,0.00,0.00,'2022-11-02 19:03:57','',''),(122,'1','287','1',1,'Sale Id shift 20',0.00,0.00,0.00,469.31,0.00,'2022-11-03 07:44:23','',''),(123,'1','287','1',1,'Sale Id shift 20',0.00,0.00,0.00,518.55,0.00,'2022-11-03 07:44:23','',''),(124,'1','287','2',1,'Sale Id shift 20',0.00,0.00,0.00,681.13,0.00,'2022-11-03 07:44:23','',''),(125,'1','287','2',1,'Sale Id shift 20',0.00,0.00,0.00,4.96,0.00,'2022-11-03 07:44:23','',''),(126,'1','287','3',1,'Sale Id shift 20',0.00,0.00,0.00,644.37,0.00,'2022-11-03 07:44:23','',''),(127,'1','287',NULL,1,'Sale Id shift 20',417297.60,0.00,0.00,0.00,0.00,'2022-11-03 07:44:23','',''),(128,'1','287','1',1,'Sale Id shift 21',0.00,0.00,0.00,940.23,0.00,'2022-11-03 09:03:40','',''),(129,'1','287','1',1,'Sale Id shift 21',0.00,0.00,0.00,492.35,0.00,'2022-11-03 09:03:40','',''),(130,'1','287','2',1,'Sale Id shift 21',0.00,0.00,0.00,177.60,0.00,'2022-11-03 09:03:40','',''),(131,'1','287','3',1,'Sale Id shift 21',0.00,0.00,0.00,465.80,0.00,'2022-11-03 09:03:40','',''),(132,'1','287','3',1,'Sale Id shift 21',0.00,0.00,0.00,259.10,0.00,'2022-11-03 09:03:40','',''),(133,'1','287','4',2,'Sale Id shift 21',0.00,0.00,0.00,50.00,0.00,'2022-11-03 09:03:40','',''),(134,'1','287',NULL,2,'Sale Id shift 21',38500.00,0.00,0.00,0.00,0.00,'2022-11-03 09:03:40','',''),(135,'1','287',NULL,1,'Sale Id shift 21',420314.40,0.00,0.00,0.00,0.00,'2022-11-03 09:03:40','',''),(136,'1','287','1',1,'Sale Id shift 22',0.00,0.00,0.00,889.52,0.00,'2022-11-03 14:01:16','',''),(137,'1','287','1',1,'Sale Id shift 22',0.00,0.00,0.00,856.04,0.00,'2022-11-03 14:01:16','',''),(138,'1','287','3',1,'Sale Id shift 22',0.00,0.00,0.00,873.53,0.00,'2022-11-03 14:01:16','',''),(139,'1','287','3',1,'Sale Id shift 22',0.00,0.00,0.00,418.87,0.00,'2022-11-03 14:01:16','',''),(140,'1','287',NULL,1,'Sale Id shift 22',546832.80,0.00,0.00,0.00,0.00,'2022-11-03 14:01:16','',''),(141,'1','287','1',1,'Sale Id shift 23',0.00,0.00,0.00,1144.87,0.00,'2022-11-06 11:16:15','',''),(142,'1','287','1',1,'Sale Id shift 23',0.00,0.00,0.00,46.65,0.00,'2022-11-06 11:16:15','',''),(143,'1','287','2',1,'Sale Id shift 23',0.00,0.00,0.00,343.87,0.00,'2022-11-06 11:16:15','',''),(144,'1','287','2',1,'Sale Id shift 23',0.00,0.00,0.00,546.08,0.00,'2022-11-06 11:16:15','',''),(145,'1','287','3',1,'Sale Id shift 23',0.00,0.00,0.00,491.21,0.00,'2022-11-06 11:16:15','',''),(146,'1','287','3',1,'Sale Id shift 23',0.00,0.00,0.00,121.91,0.00,'2022-11-06 11:16:15','',''),(147,'1','287',NULL,1,'Sale Id shift 23',485026.20,0.00,0.00,0.00,0.00,'2022-11-06 11:16:15','',''),(148,'1','287','1',1,'Sale Id shift 24',0.00,0.00,0.00,319.35,0.00,'2022-11-06 14:21:24','',''),(149,'1','287','2',1,'Sale Id shift 24',0.00,0.00,0.00,1229.29,0.00,'2022-11-06 14:21:24','',''),(150,'1','287','2',1,'Sale Id shift 24',0.00,0.00,0.00,1088.47,0.00,'2022-11-06 14:21:24','',''),(151,'1','287','3',1,'Sale Id shift 24',0.00,0.00,0.00,605.07,0.00,'2022-11-06 14:21:24','',''),(152,'1','287','3',1,'Sale Id shift 24',0.00,0.00,0.00,645.68,0.00,'2022-11-06 14:21:24','',''),(153,'1','287','4',2,'Sale Id shift 24',0.00,0.00,0.00,101.69,0.00,'2022-11-06 14:21:24','',''),(154,'1','287',NULL,2,'Sale Id shift 24',78301.30,0.00,0.00,0.00,0.00,'2022-11-06 14:21:24','',''),(155,'1','287',NULL,1,'Sale Id shift 24',699814.80,0.00,0.00,0.00,0.00,'2022-11-06 14:21:24','',''),(156,'1','287','2',1,'Sale Id shift 25',0.00,0.00,0.00,1171.60,0.00,'2022-11-06 20:48:04','',''),(157,'1','287','2',1,'Sale Id shift 25',0.00,0.00,0.00,163.22,0.00,'2022-11-06 20:48:04','',''),(158,'1','287','3',1,'Sale Id shift 25',0.00,0.00,0.00,1400.20,0.00,'2022-11-06 20:48:04','',''),(159,'1','287','4',2,'Sale Id shift 25',0.00,0.00,0.00,50.00,0.00,'2022-11-06 20:48:04','',''),(160,'1','287',NULL,2,'Sale Id shift 25',38500.00,0.00,0.00,0.00,0.00,'2022-11-06 20:48:04','',''),(161,'1','287',NULL,1,'Sale Id shift 25',492303.60,0.00,0.00,0.00,0.00,'2022-11-06 20:48:04','',''),(162,'1','287','2',1,'Sale Id shift 26',0.00,0.00,0.00,2197.86,0.00,'2022-11-06 20:56:22','',''),(163,'1','287','2',1,'Sale Id shift 26',0.00,0.00,0.00,872.53,0.00,'2022-11-06 20:56:22','',''),(164,'1','287',NULL,1,'Sale Id shift 26',552670.20,0.00,0.00,0.00,0.00,'2022-11-06 20:56:22','',''),(165,'1','287','2',1,'Sale Id shift 27',0.00,0.00,0.00,1291.19,0.00,'2022-11-06 21:04:08','',''),(166,'1','287','2',1,'Sale Id shift 27',0.00,0.00,0.00,508.87,0.00,'2022-11-06 21:04:08','',''),(167,'1','287','3',1,'Sale Id shift 27',0.00,0.00,0.00,456.35,0.00,'2022-11-06 21:04:08','',''),(168,'1','287','3',1,'Sale Id shift 27',0.00,0.00,0.00,259.05,0.00,'2022-11-06 21:04:08','',''),(169,'1','287','4',2,'Sale Id shift 27',0.00,0.00,0.00,78.99,0.00,'2022-11-06 21:04:08','',''),(170,'1','287',NULL,2,'Sale Id shift 27',60822.30,0.00,0.00,0.00,0.00,'2022-11-06 21:04:08','',''),(171,'1','287',NULL,1,'Sale Id shift 27',452782.80,0.00,0.00,0.00,0.00,'2022-11-06 21:04:08','',''),(172,'1','287','2',1,'Sale Id shift 29',0.00,0.00,0.00,312.80,0.00,'2022-11-07 08:21:44','',''),(173,'1','287','2',1,'Sale Id shift 29',0.00,0.00,0.00,953.68,0.00,'2022-11-07 08:21:44','',''),(174,'1','287','3',1,'Sale Id shift 29',0.00,0.00,0.00,1098.50,0.00,'2022-11-07 08:21:44','',''),(175,'1','287','3',1,'Sale Id shift 29',0.00,0.00,0.00,306.12,0.00,'2022-11-07 08:21:44','',''),(176,'1','287',NULL,1,'Sale Id shift 29',480798.00,0.00,0.00,0.00,0.00,'2022-11-07 08:21:44','',''),(177,'1','287','2',1,'Sale Id shift 30',0.00,0.00,0.00,443.19,0.00,'2022-11-08 13:03:37','',''),(178,'1','287','2',1,'Sale Id shift 30',0.00,0.00,0.00,344.00,0.00,'2022-11-08 13:03:37','',''),(179,'1','287','3',1,'Sale Id shift 30',0.00,0.00,0.00,574.61,0.00,'2022-11-08 13:03:37','',''),(180,'1','287','3',1,'Sale Id shift 30',0.00,0.00,0.00,144.35,0.00,'2022-11-08 13:03:37','',''),(181,'1','287',NULL,1,'Sale Id shift 30',271107.00,0.00,0.00,0.00,0.00,'2022-11-08 13:03:37','',''),(182,'1','287','2',1,'Sale Id shift 31',0.00,0.00,0.00,1124.10,0.00,'2022-11-08 16:46:02','',''),(183,'1','287','2',1,'Sale Id shift 31',0.00,0.00,0.00,546.44,0.00,'2022-11-08 16:46:02','',''),(184,'1','287','3',1,'Sale Id shift 31',0.00,0.00,0.00,799.46,0.00,'2022-11-08 16:46:02','',''),(185,'1','287','3',1,'Sale Id shift 31',0.00,0.00,0.00,598.65,0.00,'2022-11-08 16:46:02','',''),(186,'1','287','4',2,'Sale Id shift 31',0.00,0.00,0.00,92.57,0.00,'2022-11-08 16:46:02','',''),(187,'1','287',NULL,2,'Sale Id shift 31',71278.90,0.00,0.00,0.00,0.00,'2022-11-08 16:46:02','',''),(188,'1','287',NULL,1,'Sale Id shift 31',552357.00,0.00,0.00,0.00,0.00,'2022-11-08 16:46:02','',''),(189,'1','287',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,16500.00,0.00,'2022-11-09 14:54:05','',''),(190,'1','287','3',1,'Received from bridging 10',0.00,0.00,16500.00,0.00,0.00,'2022-11-09 14:54:05','',''),(191,'1','287',NULL,1,'Reception corrector for bridging 9',0.00,0.00,0.00,16500.00,0.00,'2022-11-09 14:54:05','',''),(192,'1','287','2',1,'Received from bridging 9',0.00,0.00,16500.00,0.00,0.00,'2022-11-09 14:54:05','',''),(193,'1','287',NULL,1,'Reception corrector for bridging 8',0.00,0.00,0.00,17000.00,0.00,'2022-11-09 14:54:05','',''),(194,'1','287','1',1,'Received from bridging 8',0.00,0.00,17000.00,0.00,0.00,'2022-11-09 14:54:05','',''),(195,'1','287','2',1,'Sale Id shift 32',0.00,0.00,0.00,31.90,0.00,'2022-11-09 19:25:04','',''),(196,'1','287','2',1,'Sale Id shift 32',0.00,0.00,0.00,50.57,0.00,'2022-11-09 19:25:04','',''),(197,'1','287','3',1,'Sale Id shift 32',0.00,0.00,0.00,618.04,0.00,'2022-11-09 19:25:04','',''),(198,'1','287','3',1,'Sale Id shift 32',0.00,0.00,0.00,1004.81,0.00,'2022-11-09 19:25:04','',''),(199,'1','287',NULL,1,'Sale Id shift 32',306957.60,0.00,0.00,0.00,0.00,'2022-11-09 19:25:04','',''),(200,'1','287','3',1,'Sale Id shift 33',0.00,0.00,0.00,1831.62,0.00,'2022-11-10 10:21:59','',''),(201,'1','287','3',1,'Sale Id shift 33',0.00,0.00,0.00,1340.23,0.00,'2022-11-10 10:21:59','',''),(202,'1','287','4',2,'Sale Id shift 33',0.00,0.00,0.00,64.63,0.00,'2022-11-10 10:21:59','',''),(203,'1','287',NULL,2,'Sale Id shift 33',49765.10,0.00,0.00,0.00,0.00,'2022-11-10 10:21:59','',''),(204,'1','287',NULL,1,'Sale Id shift 33',570933.00,0.00,0.00,0.00,0.00,'2022-11-10 10:21:59','',''),(205,'1','287','3',1,'Sale Id shift 34',0.00,0.00,0.00,1655.12,0.00,'2022-11-10 10:30:38','',''),(206,'1','287','3',1,'Sale Id shift 34',0.00,0.00,0.00,799.98,0.00,'2022-11-10 10:30:38','',''),(207,'1','287','4',2,'Sale Id shift 34',0.00,0.00,0.00,40.00,0.00,'2022-11-10 10:30:38','',''),(208,'1','287',NULL,2,'Sale Id shift 34',30800.00,0.00,0.00,0.00,0.00,'2022-11-10 10:30:38','',''),(209,'1','287',NULL,1,'Sale Id shift 34',441918.00,0.00,0.00,0.00,0.00,'2022-11-10 10:30:38','',''),(210,'1','287','2',1,'Sale Id shift 35',0.00,0.00,0.00,632.38,0.00,'2022-11-10 12:57:44','',''),(211,'1','287','2',1,'Sale Id shift 35',0.00,0.00,0.00,172.14,0.00,'2022-11-10 12:57:44','',''),(212,'1','287','3',1,'Sale Id shift 35',0.00,0.00,0.00,1646.27,0.00,'2022-11-10 12:57:44','',''),(213,'1','287','3',1,'Sale Id shift 35',0.00,0.00,0.00,822.37,0.00,'2022-11-10 12:57:44','',''),(214,'1','287',NULL,1,'Sale Id shift 35',589168.80,0.00,0.00,0.00,0.00,'2022-11-10 12:57:44','',''),(215,'1','287','1',1,'Sale Id shift 36',0.00,0.00,0.00,199.46,0.00,'2022-11-10 14:26:41','',''),(216,'1','287','1',1,'Sale Id shift 36',0.00,0.00,0.00,44.42,0.00,'2022-11-10 14:26:41','',''),(217,'1','287','2',1,'Sale Id shift 36',0.00,0.00,0.00,1185.89,0.00,'2022-11-10 14:26:41','',''),(218,'1','287','2',1,'Sale Id shift 36',0.00,0.00,0.00,246.36,0.00,'2022-11-10 14:26:41','',''),(219,'1','287','3',1,'Sale Id shift 36',0.00,0.00,0.00,388.50,0.00,'2022-11-10 14:26:41','',''),(220,'1','287','3',1,'Sale Id shift 36',0.00,0.00,0.00,287.52,0.00,'2022-11-10 14:26:41','',''),(221,'1','287',NULL,1,'Sale Id shift 36',423387.00,0.00,0.00,0.00,0.00,'2022-11-10 14:26:41','',''),(222,'1','287','1',1,'Sale Id shift 37',0.00,0.00,0.00,1492.45,0.00,'2022-11-10 15:52:24','',''),(223,'1','287','1',1,'Sale Id shift 37',0.00,0.00,0.00,1117.43,0.00,'2022-11-10 15:52:24','',''),(224,'1','287','2',1,'Sale Id shift 37',0.00,0.00,0.00,877.35,0.00,'2022-11-10 15:52:24','',''),(225,'1','287','3',1,'Sale Id shift 37',0.00,0.00,0.00,451.28,0.00,'2022-11-10 15:52:24','',''),(226,'1','287','4',2,'Sale Id shift 37',0.00,0.00,0.00,50.00,0.00,'2022-11-10 15:52:24','',''),(227,'1','287',NULL,2,'Sale Id shift 37',38500.00,0.00,0.00,0.00,0.00,'2022-11-10 15:52:24','',''),(228,'1','287',NULL,1,'Sale Id shift 37',708931.80,0.00,0.00,0.00,0.00,'2022-11-10 15:52:24','',''),(229,'1','287','1',1,'Sale Id shift 38',0.00,0.00,0.00,1102.77,0.00,'2022-11-10 16:11:28','',''),(230,'1','287','1',1,'Sale Id shift 38',0.00,0.00,0.00,504.98,0.00,'2022-11-10 16:11:28','',''),(231,'1','287','2',1,'Sale Id shift 38',0.00,0.00,0.00,698.01,0.00,'2022-11-10 16:11:28','',''),(232,'1','287','3',1,'Sale Id shift 38',0.00,0.00,0.00,385.97,0.00,'2022-11-10 16:11:28','',''),(233,'1','287','4',2,'Sale Id shift 38',0.00,0.00,0.00,50.00,0.00,'2022-11-10 16:11:28','',''),(234,'1','287',NULL,2,'Sale Id shift 38',38500.00,0.00,0.00,0.00,0.00,'2022-11-10 16:11:28','',''),(235,'1','287',NULL,1,'Sale Id shift 38',484511.40,0.00,0.00,0.00,0.00,'2022-11-10 16:11:28','',''),(236,'1','287','1',1,'Sale Id shift 39',0.00,0.00,0.00,805.26,0.00,'2022-11-10 16:29:27','',''),(237,'1','287','1',1,'Sale Id shift 39',0.00,0.00,0.00,309.42,0.00,'2022-11-10 16:29:27','',''),(238,'1','287','1',1,'Sale Id shift 39',0.00,0.00,0.00,232.30,0.00,'2022-11-10 16:29:27','',''),(239,'1','287','1',1,'Sale Id shift 39',0.00,0.00,0.00,1032.27,0.00,'2022-11-10 16:29:27','',''),(240,'1','287','2',1,'Sale Id shift 39',0.00,0.00,0.00,994.64,0.00,'2022-11-10 16:29:27','',''),(241,'1','287','3',1,'Sale Id shift 39',0.00,0.00,0.00,561.26,0.00,'2022-11-10 16:29:27','',''),(242,'1','287',NULL,1,'Sale Id shift 39',708327.00,0.00,0.00,0.00,0.00,'2022-11-10 16:29:27','',''),(243,'1','287','1',1,'Sale Id shift 40',0.00,0.00,0.00,778.74,0.00,'2022-11-10 16:46:32','',''),(244,'1','287','2',1,'Sale Id shift 40',0.00,0.00,0.00,946.99,0.00,'2022-11-10 16:46:32','',''),(245,'1','287','2',1,'Sale Id shift 40',0.00,0.00,0.00,738.50,0.00,'2022-11-10 16:46:32','',''),(246,'1','287','3',1,'Sale Id shift 40',0.00,0.00,0.00,328.41,0.00,'2022-11-10 16:46:32','',''),(247,'1','287','4',2,'Sale Id shift 40',0.00,0.00,0.00,150.00,0.00,'2022-11-10 16:46:32','',''),(248,'1','287',NULL,2,'Sale Id shift 40',115500.00,0.00,0.00,0.00,0.00,'2022-11-10 16:46:32','',''),(249,'1','287',NULL,1,'Sale Id shift 40',502675.20,0.00,0.00,0.00,0.00,'2022-11-10 16:46:32','',''),(250,'1','287','1',1,'Sale Id shift 41',0.00,0.00,0.00,185.98,0.00,'2022-11-10 17:07:49','',''),(251,'1','287','1',1,'Sale Id shift 41',0.00,0.00,0.00,759.68,0.00,'2022-11-10 17:07:49','',''),(252,'1','287','1',1,'Sale Id shift 41',0.00,0.00,0.00,843.05,0.00,'2022-11-10 17:07:49','',''),(253,'1','287','2',1,'Sale Id shift 41',0.00,0.00,0.00,1247.26,0.00,'2022-11-10 17:07:49','',''),(254,'1','287','3',1,'Sale Id shift 41',0.00,0.00,0.00,874.68,0.00,'2022-11-10 17:07:49','',''),(255,'1','287','4',2,'Sale Id shift 41',0.00,0.00,0.00,3.75,0.00,'2022-11-10 17:07:49','',''),(256,'1','287',NULL,2,'Sale Id shift 41',2887.50,0.00,0.00,0.00,0.00,'2022-11-10 17:07:49','',''),(257,'1','287',NULL,1,'Sale Id shift 41',703917.00,0.00,0.00,0.00,0.00,'2022-11-10 17:07:49','',''),(258,'1','287','1',1,'Sale Id shift 42',0.00,0.00,0.00,1010.66,0.00,'2022-11-10 17:37:42','',''),(259,'1','287','1',1,'Sale Id shift 42',0.00,0.00,0.00,359.49,0.00,'2022-11-10 17:37:42','',''),(260,'1','287','2',1,'Sale Id shift 42',0.00,0.00,0.00,797.92,0.00,'2022-11-10 17:37:42','',''),(261,'1','287','2',1,'Sale Id shift 42',0.00,0.00,0.00,181.57,0.00,'2022-11-10 17:37:42','',''),(262,'1','287','3',1,'Sale Id shift 42',0.00,0.00,0.00,572.36,0.00,'2022-11-10 17:37:42','',''),(263,'1','287','4',2,'Sale Id shift 42',0.00,0.00,0.00,50.00,0.00,'2022-11-10 17:37:42','',''),(264,'1','287',NULL,2,'Sale Id shift 42',38500.00,0.00,0.00,0.00,0.00,'2022-11-10 17:37:42','',''),(265,'1','287',NULL,1,'Sale Id shift 42',525960.00,0.00,0.00,0.00,0.00,'2022-11-10 17:37:42','',''),(266,'1','287','1',1,'Sale Id shift 43',0.00,0.00,0.00,1172.03,0.00,'2022-11-10 18:10:06','',''),(267,'1','287','1',1,'Sale Id shift 43',0.00,0.00,0.00,201.48,0.00,'2022-11-10 18:10:06','',''),(268,'1','287','1',1,'Sale Id shift 43',0.00,0.00,0.00,576.53,0.00,'2022-11-10 18:10:06','',''),(269,'1','287','1',1,'Sale Id shift 43',0.00,0.00,0.00,112.73,0.00,'2022-11-10 18:10:06','',''),(270,'1','287','2',1,'Sale Id shift 43',0.00,0.00,0.00,844.55,0.00,'2022-11-10 18:10:06','',''),(271,'1','287','3',1,'Sale Id shift 43',0.00,0.00,0.00,1433.32,0.00,'2022-11-10 18:10:06','',''),(272,'1','287','4',2,'Sale Id shift 43',0.00,0.00,0.00,4.00,0.00,'2022-11-10 18:10:06','',''),(273,'1','287',NULL,2,'Sale Id shift 43',3080.00,0.00,0.00,0.00,0.00,'2022-11-10 18:10:06','',''),(274,'1','287',NULL,1,'Sale Id shift 43',781315.20,0.00,0.00,0.00,0.00,'2022-11-10 18:10:06','',''),(275,'1','287','1',1,'Sale Id shift 44',0.00,0.00,0.00,1097.48,0.00,'2022-11-11 01:58:03','',''),(276,'1','287','1',1,'Sale Id shift 44',0.00,0.00,0.00,614.01,0.00,'2022-11-11 01:58:03','',''),(277,'1','287','1',1,'Sale Id shift 44',0.00,0.00,0.00,1631.00,0.00,'2022-11-11 01:58:03','',''),(278,'1','287','2',1,'Sale Id shift 44',0.00,0.00,0.00,1669.13,0.00,'2022-11-11 01:58:03','',''),(279,'1','287','4',2,'Sale Id shift 44',0.00,0.00,0.00,50.00,0.00,'2022-11-11 01:58:03','',''),(280,'1','287',NULL,2,'Sale Id shift 44',38500.00,0.00,0.00,0.00,0.00,'2022-11-11 01:58:03','',''),(281,'1','287',NULL,1,'Sale Id shift 44',902091.60,0.00,0.00,0.00,0.00,'2022-11-11 01:58:03','',''),(282,'1','287','1',1,'Sale Id shift 46',0.00,0.00,0.00,369.54,0.00,'2022-11-11 12:41:46','',''),(283,'1','287','1',1,'Sale Id shift 46',0.00,0.00,0.00,329.87,0.00,'2022-11-11 12:41:46','',''),(284,'1','287','2',1,'Sale Id shift 46',0.00,0.00,0.00,3024.59,0.00,'2022-11-11 12:41:46','',''),(285,'1','287','2',1,'Sale Id shift 46',0.00,0.00,0.00,444.46,0.00,'2022-11-11 12:41:46','',''),(286,'1','287','3',1,'Sale Id shift 46',0.00,0.00,0.00,3140.59,0.00,'2022-11-11 12:41:46','',''),(287,'1','287',NULL,1,'Sale Id shift 46',1315629.00,0.00,0.00,0.00,0.00,'2022-11-11 12:41:46','',''),(288,'1','287','2',1,'Sale Id shift 47',0.00,0.00,0.00,754.93,0.00,'2022-11-11 12:51:53','',''),(289,'1','287','3',1,'Sale Id shift 47',0.00,0.00,0.00,1285.97,0.00,'2022-11-11 12:51:53','',''),(290,'1','287','3',1,'Sale Id shift 47',0.00,0.00,0.00,643.38,0.00,'2022-11-11 12:51:53','',''),(291,'1','287','4',2,'Sale Id shift 47',0.00,0.00,0.00,78.25,0.00,'2022-11-11 12:51:53','',''),(292,'1','287',NULL,2,'Sale Id shift 47',62600.00,0.00,0.00,0.00,0.00,'2022-11-11 12:51:53','',''),(293,'1','287',NULL,1,'Sale Id shift 47',483170.40,0.00,0.00,0.00,0.00,'2022-11-11 12:51:53','',''),(294,'1','287','3',1,'Sale Id shift 48',0.00,0.00,0.00,3823.76,0.00,'2022-11-11 13:14:01','',''),(295,'1','287','3',1,'Sale Id shift 48',0.00,0.00,0.00,2389.99,0.00,'2022-11-11 13:14:01','',''),(296,'1','287',NULL,1,'Sale Id shift 48',1118475.00,0.00,0.00,0.00,0.00,'2022-11-11 13:14:01','',''),(297,'1','287',NULL,1,'Reception corrector for bridging 12',0.00,0.00,0.00,17000.00,0.00,'2022-11-11 13:19:56','',''),(298,'1','287','3',1,'Received from bridging 12',0.00,0.00,17000.00,0.00,0.00,'2022-11-11 13:19:56','',''),(299,'1','287',NULL,1,'Reception corrector for bridging 11',0.00,0.00,0.00,33000.00,0.00,'2022-11-11 13:19:56','',''),(300,'1','287','1',1,'Received from bridging 11',0.00,0.00,33000.00,0.00,0.00,'2022-11-11 13:19:56','',''),(301,'1','287','3',1,'Sale Id shift 49',0.00,0.00,0.00,589.54,0.00,'2022-11-11 15:02:13','',''),(302,'1','287','3',1,'Sale Id shift 49',0.00,0.00,0.00,358.09,0.00,'2022-11-11 15:02:13','',''),(303,'1','287','4',2,'Sale Id shift 49',0.00,0.00,0.00,33.75,0.00,'2022-11-11 15:02:13','',''),(304,'1','287',NULL,2,'Sale Id shift 49',27000.00,0.00,0.00,0.00,0.00,'2022-11-11 15:02:13','',''),(305,'1','287',NULL,1,'Sale Id shift 49',170573.40,0.00,0.00,0.00,0.00,'2022-11-11 15:02:13','',''),(306,'1','287','1',1,'Sale Id shift 51',0.00,0.00,0.00,2411.53,0.00,'2022-11-11 15:37:40','',''),(307,'1','287','1',1,'Sale Id shift 51',0.00,0.00,0.00,2214.44,0.00,'2022-11-11 15:37:40','',''),(308,'1','287','1',1,'Sale Id shift 51',0.00,0.00,0.00,1992.26,0.00,'2022-11-11 15:37:40','',''),(309,'1','287','1',1,'Sale Id shift 51',0.00,0.00,0.00,2377.77,0.00,'2022-11-11 15:37:40','',''),(310,'1','287','3',1,'Sale Id shift 51',0.00,0.00,0.00,1230.35,0.00,'2022-11-11 15:37:40','',''),(311,'1','287',NULL,1,'Sale Id shift 51',1840743.00,0.00,0.00,0.00,0.00,'2022-11-11 15:37:40','',''),(312,'1','287',NULL,1,'Reception corrector for bridging 13',0.00,0.00,0.00,16000.00,0.00,'2022-11-11 15:58:23','',''),(313,'1','287','2',1,'Received from bridging 13',0.00,0.00,16000.00,0.00,0.00,'2022-11-11 15:58:23','',''),(314,'1','287','1',1,'Sale Id shift 52',0.00,0.00,0.00,2384.80,0.00,'2022-11-11 16:03:16','',''),(315,'1','287','1',1,'Sale Id shift 52',0.00,0.00,0.00,1328.67,0.00,'2022-11-11 16:03:16','',''),(316,'1','287','2',1,'Sale Id shift 52',0.00,0.00,0.00,1404.50,0.00,'2022-11-11 16:03:16','',''),(317,'1','287','3',1,'Sale Id shift 52',0.00,0.00,0.00,1212.55,0.00,'2022-11-11 16:03:16','',''),(318,'1','287','4',2,'Sale Id shift 52',0.00,0.00,0.00,32.50,0.00,'2022-11-11 16:03:16','',''),(319,'1','287',NULL,2,'Sale Id shift 52',26000.00,0.00,0.00,0.00,0.00,'2022-11-11 16:03:16','',''),(320,'1','287',NULL,1,'Sale Id shift 52',1139493.60,0.00,0.00,0.00,0.00,'2022-11-11 16:03:16','',''),(321,'1','287','1',1,'Sale Id shift 53',0.00,0.00,0.00,1736.43,0.00,'2022-11-11 16:14:59','',''),(322,'1','287','1',1,'Sale Id shift 53',0.00,0.00,0.00,1202.27,0.00,'2022-11-11 16:14:59','',''),(323,'1','287','2',1,'Sale Id shift 53',0.00,0.00,0.00,1607.81,0.00,'2022-11-11 16:14:59','',''),(324,'1','287','3',1,'Sale Id shift 53',0.00,0.00,0.00,1343.04,0.00,'2022-11-11 16:14:59','',''),(325,'1','287',NULL,1,'Sale Id shift 53',1060119.00,0.00,0.00,0.00,0.00,'2022-11-11 16:14:59','',''),(326,'1','287','1',1,'Sale Id shift 54',0.00,0.00,0.00,80.75,0.00,'2022-11-11 16:24:55','',''),(327,'1','287','1',1,'Sale Id shift 54',0.00,0.00,0.00,555.86,0.00,'2022-11-11 16:24:55','',''),(328,'1','287','1',1,'Sale Id shift 54',0.00,0.00,0.00,2191.34,0.00,'2022-11-11 16:24:55','',''),(329,'1','287','2',1,'Sale Id shift 54',0.00,0.00,0.00,2113.24,0.00,'2022-11-11 16:24:55','',''),(330,'1','287','3',1,'Sale Id shift 54',0.00,0.00,0.00,1593.11,0.00,'2022-11-11 16:24:55','',''),(331,'1','287','3',1,'Sale Id shift 54',0.00,0.00,0.00,-10.00,0.00,'2022-11-11 16:24:55','',''),(332,'1','287','4',2,'Sale Id shift 54',0.00,0.00,0.00,780.00,0.00,'2022-11-11 16:24:55','',''),(333,'1','287',NULL,2,'Sale Id shift 54',624000.00,0.00,0.00,0.00,0.00,'2022-11-11 16:24:55','',''),(334,'1','287',NULL,1,'Sale Id shift 54',1174374.00,0.00,0.00,0.00,0.00,'2022-11-11 16:24:55','',''),(335,'1','287','1',1,'Sale Id shift 55',0.00,0.00,0.00,1786.50,0.00,'2022-11-11 16:41:28','',''),(336,'1','287','1',1,'Sale Id shift 55',0.00,0.00,0.00,1233.35,0.00,'2022-11-11 16:41:28','',''),(337,'1','287','1',1,'Sale Id shift 55',0.00,0.00,0.00,73.98,0.00,'2022-11-11 16:41:28','',''),(338,'1','287','2',1,'Sale Id shift 55',0.00,0.00,0.00,1452.66,0.00,'2022-11-11 16:41:28','',''),(339,'1','287','3',1,'Sale Id shift 55',0.00,0.00,0.00,1600.48,0.00,'2022-11-11 16:41:28','',''),(340,'1','287',NULL,1,'Sale Id shift 55',1106454.60,0.00,0.00,0.00,0.00,'2022-11-11 16:41:28','',''),(341,'1','287','1',1,'Sale Id shift 56',0.00,0.00,0.00,1607.79,0.00,'2022-11-11 16:57:13','',''),(342,'1','287','1',1,'Sale Id shift 56',0.00,0.00,0.00,1243.25,0.00,'2022-11-11 16:57:13','',''),(343,'1','287','2',1,'Sale Id shift 56',0.00,0.00,0.00,1831.58,0.00,'2022-11-11 16:57:13','',''),(344,'1','287','3',1,'Sale Id shift 56',0.00,0.00,0.00,843.56,0.00,'2022-11-11 16:57:13','',''),(345,'1','287','4',2,'Sale Id shift 56',0.00,0.00,0.00,30.00,0.00,'2022-11-11 16:57:13','',''),(346,'1','287',NULL,2,'Sale Id shift 56',24000.00,0.00,0.00,0.00,0.00,'2022-11-11 16:57:13','',''),(347,'1','287',NULL,1,'Sale Id shift 56',994712.40,0.00,0.00,0.00,0.00,'2022-11-11 16:57:13','',''),(348,'1','287','1',1,'Sale Id shift 57',0.00,0.00,0.00,2031.94,0.00,'2022-11-12 08:12:44','',''),(349,'1','287','1',1,'Sale Id shift 57',0.00,0.00,0.00,1741.83,0.00,'2022-11-12 08:12:44','',''),(350,'1','287','2',1,'Sale Id shift 57',0.00,0.00,0.00,1321.57,0.00,'2022-11-12 08:12:44','',''),(351,'1','287','2',1,'Sale Id shift 57',0.00,0.00,0.00,1112.65,0.00,'2022-11-12 08:12:44','',''),(352,'1','287','3',1,'Sale Id shift 57',0.00,0.00,0.00,1518.95,0.00,'2022-11-12 08:12:44','',''),(353,'1','287',NULL,1,'Sale Id shift 57',1390849.20,0.00,0.00,0.00,0.00,'2022-11-12 08:12:44','',''),(354,'1','287','1',1,'Sale Id shift 58',0.00,0.00,0.00,1640.05,0.00,'2022-11-12 09:02:47','',''),(355,'1','287','1',1,'Sale Id shift 58',0.00,0.00,0.00,1228.94,0.00,'2022-11-12 09:02:47','',''),(356,'1','287','2',1,'Sale Id shift 58',0.00,0.00,0.00,1167.29,0.00,'2022-11-12 09:02:47','',''),(357,'1','287','3',1,'Sale Id shift 58',0.00,0.00,0.00,1882.26,0.00,'2022-11-12 09:02:47','',''),(358,'1','287','4',2,'Sale Id shift 58',0.00,0.00,0.00,30.00,0.00,'2022-11-12 09:02:47','',''),(359,'1','287',NULL,2,'Sale Id shift 58',24000.00,0.00,0.00,0.00,0.00,'2022-11-12 09:02:47','',''),(360,'1','287',NULL,1,'Sale Id shift 58',1065337.20,0.00,0.00,0.00,0.00,'2022-11-12 09:02:47','',''),(361,'1','287',NULL,1,'Reception corrector for bridging 14',0.00,0.00,0.00,34000.00,0.00,'2022-11-12 09:20:34','',''),(362,'1','287','3',1,'Received from bridging 14',0.00,0.00,34000.00,0.00,0.00,'2022-11-12 09:20:34','',''),(363,'1','287',NULL,1,'Reception corrector for bridging 15',0.00,0.00,0.00,34000.00,0.00,'2022-11-12 09:40:49','',''),(364,'1','287','1',1,'Received from bridging 15',0.00,0.00,34000.00,0.00,0.00,'2022-11-12 09:40:49','',''),(365,'1','287',NULL,1,'Reception corrector for bridging 16',0.00,0.00,0.00,16000.00,0.00,'2022-11-12 09:41:10','',''),(366,'1','287','2',1,'Received from bridging 16',0.00,0.00,16000.00,0.00,0.00,'2022-11-12 09:41:10','',''),(367,'1','287','1',1,'Sale Id shift 59',0.00,0.00,0.00,1133.75,0.00,'2022-11-12 10:25:51','',''),(368,'1','287','1',1,'Sale Id shift 59',0.00,0.00,0.00,975.34,0.00,'2022-11-12 10:25:51','',''),(369,'1','287','1',1,'Sale Id shift 59',0.00,0.00,0.00,433.59,0.00,'2022-11-12 10:25:51','',''),(370,'1','287','1',1,'Sale Id shift 59',0.00,0.00,0.00,1412.91,0.00,'2022-11-12 10:25:51','',''),(371,'1','287','2',1,'Sale Id shift 59',0.00,0.00,0.00,742.43,0.00,'2022-11-12 10:25:51','',''),(372,'1','287','2',1,'Sale Id shift 59',0.00,0.00,0.00,17.35,0.00,'2022-11-12 10:25:51','',''),(373,'1','287','3',1,'Sale Id shift 59',0.00,0.00,0.00,407.26,0.00,'2022-11-12 10:25:51','',''),(374,'1','287','3',1,'Sale Id shift 59',0.00,0.00,0.00,1488.07,0.00,'2022-11-12 10:25:51','',''),(375,'1','287','4',2,'Sale Id shift 59',0.00,0.00,0.00,70.00,0.00,'2022-11-12 10:25:51','',''),(376,'1','287',NULL,2,'Sale Id shift 59',56000.00,0.00,0.00,0.00,0.00,'2022-11-12 10:25:51','',''),(377,'1','287',NULL,1,'Sale Id shift 59',1189926.00,0.00,0.00,0.00,0.00,'2022-11-12 10:25:51','',''),(378,'1','287','1',1,'Sale Id shift 60',0.00,0.00,0.00,1197.22,0.00,'2022-11-12 10:38:16','',''),(379,'1','287','1',1,'Sale Id shift 60',0.00,0.00,0.00,861.61,0.00,'2022-11-12 10:38:16','',''),(380,'1','287','1',1,'Sale Id shift 60',0.00,0.00,0.00,1172.04,0.00,'2022-11-12 10:38:16','',''),(381,'1','287','2',1,'Sale Id shift 60',0.00,0.00,0.00,1463.23,0.00,'2022-11-12 10:38:16','',''),(382,'1','287','3',1,'Sale Id shift 60',0.00,0.00,0.00,1047.55,0.00,'2022-11-12 10:38:16','',''),(383,'1','287','4',2,'Sale Id shift 60',0.00,0.00,0.00,30.00,0.00,'2022-11-12 10:38:16','',''),(384,'1','287',NULL,2,'Sale Id shift 60',24000.00,0.00,0.00,0.00,0.00,'2022-11-12 10:38:16','',''),(385,'1','287',NULL,1,'Sale Id shift 60',1033497.00,0.00,0.00,0.00,0.00,'2022-11-12 10:38:16','',''),(386,'1','287','1',1,'Sale Id shift 61',0.00,0.00,0.00,2583.73,0.00,'2022-11-12 10:48:17','',''),(387,'1','287','1',1,'Sale Id shift 61',0.00,0.00,0.00,180.47,0.00,'2022-11-12 10:48:17','',''),(388,'1','287','2',1,'Sale Id shift 61',0.00,0.00,0.00,2471.08,0.00,'2022-11-12 10:48:17','',''),(389,'1','287','3',1,'Sale Id shift 61',0.00,0.00,0.00,2045.93,0.00,'2022-11-12 10:48:17','',''),(390,'1','287',NULL,1,'Sale Id shift 61',1310617.80,0.00,0.00,0.00,0.00,'2022-11-12 10:48:17','',''),(391,'1','287','1',1,'Sale Id shift 62',0.00,0.00,0.00,364.97,0.00,'2022-11-12 11:00:46','',''),(392,'1','287','1',1,'Sale Id shift 62',0.00,0.00,0.00,1573.27,0.00,'2022-11-12 11:00:46','',''),(393,'1','287','1',1,'Sale Id shift 62',0.00,0.00,0.00,973.93,0.00,'2022-11-12 11:00:46','',''),(394,'1','287','2',1,'Sale Id shift 62',0.00,0.00,0.00,1907.97,0.00,'2022-11-12 11:00:46','',''),(395,'1','287','2',1,'Sale Id shift 62',0.00,0.00,0.00,658.97,0.00,'2022-11-12 11:00:46','',''),(396,'1','287','3',1,'Sale Id shift 62',0.00,0.00,0.00,665.41,0.00,'2022-11-12 11:00:46','',''),(397,'1','287','4',2,'Sale Id shift 62',0.00,0.00,0.00,30.00,0.00,'2022-11-12 11:00:46','',''),(398,'1','287',NULL,2,'Sale Id shift 62',24000.00,0.00,0.00,0.00,0.00,'2022-11-12 11:00:46','',''),(399,'1','287',NULL,1,'Sale Id shift 62',1106013.60,0.00,0.00,0.00,0.00,'2022-11-12 11:00:46','',''),(400,'1','287','1',1,'Sale Id shift 64',0.00,0.00,0.00,2415.22,0.00,'2022-11-12 11:31:22','',''),(401,'1','287','1',1,'Sale Id shift 64',0.00,0.00,0.00,3065.52,0.00,'2022-11-12 11:31:22','',''),(402,'1','287','1',1,'Sale Id shift 64',0.00,0.00,0.00,146.90,0.00,'2022-11-12 11:31:22','',''),(403,'1','287','2',1,'Sale Id shift 64',0.00,0.00,0.00,2994.08,0.00,'2022-11-12 11:31:22','',''),(404,'1','287','2',1,'Sale Id shift 64',0.00,0.00,0.00,265.50,0.00,'2022-11-12 11:31:22','',''),(405,'1','287','3',1,'Sale Id shift 64',0.00,0.00,0.00,1670.82,0.00,'2022-11-12 11:31:22','',''),(406,'1','287',NULL,1,'Sale Id shift 64',1900447.20,0.00,0.00,0.00,0.00,'2022-11-12 11:31:22','',''),(407,'1','287','1',1,'Sale Id shift 65',0.00,0.00,0.00,1861.31,0.00,'2022-11-12 11:52:24','',''),(408,'1','287','1',1,'Sale Id shift 65',0.00,0.00,0.00,1521.04,0.00,'2022-11-12 11:52:24','',''),(409,'1','287','2',1,'Sale Id shift 65',0.00,0.00,0.00,1862.82,0.00,'2022-11-12 11:52:24','',''),(410,'1','287','3',1,'Sale Id shift 65',0.00,0.00,0.00,1314.56,0.00,'2022-11-12 11:52:24','',''),(411,'1','287','4',2,'Sale Id shift 65',0.00,0.00,0.00,30.00,0.00,'2022-11-12 11:52:24','',''),(412,'1','287',NULL,2,'Sale Id shift 65',24000.00,0.00,0.00,0.00,0.00,'2022-11-12 11:52:24','',''),(413,'1','287',NULL,1,'Sale Id shift 65',1180751.40,0.00,0.00,0.00,0.00,'2022-11-12 11:52:24','',''),(414,'1','287','1',1,'Sale Id shift 66',0.00,0.00,0.00,1808.79,0.00,'2022-11-12 12:02:44','',''),(415,'1','287','1',1,'Sale Id shift 66',0.00,0.00,0.00,1696.26,0.00,'2022-11-12 12:02:44','',''),(416,'1','287','2',1,'Sale Id shift 66',0.00,0.00,0.00,2153.19,0.00,'2022-11-12 12:02:44','',''),(417,'1','287','3',1,'Sale Id shift 66',0.00,0.00,0.00,2159.85,0.00,'2022-11-12 12:02:44','',''),(418,'1','287',NULL,1,'Sale Id shift 66',1407256.20,0.00,0.00,0.00,0.00,'2022-11-12 12:02:44','',''),(419,'1','287','1',1,'Sale Id shift 67',0.00,0.00,0.00,680.33,0.00,'2022-11-12 12:23:33','',''),(420,'1','287','1',1,'Sale Id shift 67',0.00,0.00,0.00,2464.33,0.00,'2022-11-12 12:23:33','',''),(421,'1','287','2',1,'Sale Id shift 67',0.00,0.00,0.00,2495.51,0.00,'2022-11-12 12:23:33','',''),(422,'1','287','3',1,'Sale Id shift 67',0.00,0.00,0.00,2040.81,0.00,'2022-11-12 12:23:33','',''),(423,'1','287','4',2,'Sale Id shift 67',0.00,0.00,0.00,45.01,0.00,'2022-11-12 12:23:33','',''),(424,'1','287',NULL,2,'Sale Id shift 67',36008.00,0.00,0.00,0.00,0.00,'2022-11-12 12:23:33','',''),(425,'1','287',NULL,1,'Sale Id shift 67',1382576.40,0.00,0.00,0.00,0.00,'2022-11-12 12:23:33','',''),(426,'1','287','1',1,'Sale Id shift 68',0.00,0.00,0.00,1478.23,0.00,'2022-11-12 12:31:20','',''),(427,'1','287','1',1,'Sale Id shift 68',0.00,0.00,0.00,1890.50,0.00,'2022-11-12 12:31:20','',''),(428,'1','287','2',1,'Sale Id shift 68',0.00,0.00,0.00,692.04,0.00,'2022-11-12 12:31:20','',''),(429,'1','287','2',1,'Sale Id shift 68',0.00,0.00,0.00,572.95,0.00,'2022-11-12 12:31:20','',''),(430,'1','287','3',1,'Sale Id shift 68',0.00,0.00,0.00,2101.19,0.00,'2022-11-12 12:31:20','',''),(431,'1','287',NULL,1,'Sale Id shift 68',1212283.80,0.00,0.00,0.00,0.00,'2022-11-12 12:31:20','',''),(432,'1','287','1',1,'Sale Id shift 69',0.00,0.00,0.00,1871.43,0.00,'2022-11-13 06:26:57','',''),(433,'1','287','2',1,'Sale Id shift 69',0.00,0.00,0.00,957.36,0.00,'2022-11-13 06:26:57','',''),(434,'1','287','2',1,'Sale Id shift 69',0.00,0.00,0.00,619.03,0.00,'2022-11-13 06:26:57','',''),(435,'1','287','3',1,'Sale Id shift 69',0.00,0.00,0.00,1380.86,0.00,'2022-11-13 06:26:57','',''),(436,'1','287','4',2,'Sale Id shift 69',0.00,0.00,0.00,108.75,0.00,'2022-11-13 06:26:57','',''),(437,'1','287',NULL,2,'Sale Id shift 69',87000.00,0.00,0.00,0.00,0.00,'2022-11-13 06:26:57','',''),(438,'1','287',NULL,1,'Sale Id shift 69',869162.40,0.00,0.00,0.00,0.00,'2022-11-13 06:26:57','',''),(439,'1','287','3',1,'Returned bridging 12',0.00,0.00,0.00,17000.00,0.00,'2022-11-14 09:31:01','',''),(440,'1','287',NULL,1,'Reception Return corrector for bridging 12',0.00,0.00,17000.00,0.00,0.00,'2022-11-14 09:31:01','',''),(441,'1','287',NULL,1,'Reception corrector for bridging 17',0.00,0.00,0.00,16000.00,0.00,'2022-11-14 09:47:55','',''),(442,'1','287','2',1,'Received from bridging 17',0.00,0.00,16000.00,0.00,0.00,'2022-11-14 09:47:55','',''),(443,'1','287',NULL,1,'Reception corrector for bridging 18',0.00,0.00,0.00,1000.00,0.00,'2022-11-14 09:49:59','',''),(444,'1','287','3',1,'Received from bridging 18',0.00,0.00,1000.00,0.00,0.00,'2022-11-14 09:49:59','',''),(445,'1','287','1',1,'Sale Id shift 70',0.00,0.00,0.00,2298.39,0.00,'2022-11-14 10:13:20','',''),(446,'1','287','2',1,'Sale Id shift 70',0.00,0.00,0.00,1886.78,0.00,'2022-11-14 10:13:20','',''),(447,'1','287','3',1,'Sale Id shift 70',0.00,0.00,0.00,894.56,0.00,'2022-11-14 10:13:20','',''),(448,'1','287','3',1,'Sale Id shift 70',0.00,0.00,0.00,691.35,0.00,'2022-11-14 10:13:20','',''),(449,'1','287',NULL,1,'Sale Id shift 70',1038794.40,0.00,0.00,0.00,0.00,'2022-11-14 10:13:20','',''),(450,'1','287','2',1,'Sale Id shift 71',0.00,0.00,0.00,1348.55,0.00,'2022-11-14 10:22:12','',''),(451,'1','287','3',1,'Sale Id shift 71',0.00,0.00,0.00,1309.88,0.00,'2022-11-14 10:22:12','',''),(452,'1','287','3',1,'Sale Id shift 71',0.00,0.00,0.00,1315.85,0.00,'2022-11-14 10:22:12','',''),(453,'1','287','4',2,'Sale Id shift 71',0.00,0.00,0.00,30.00,0.00,'2022-11-14 10:22:12','',''),(454,'1','287',NULL,2,'Sale Id shift 71',24000.00,0.00,0.00,0.00,0.00,'2022-11-14 10:22:12','',''),(455,'1','287',NULL,1,'Sale Id shift 71',715370.40,0.00,0.00,0.00,0.00,'2022-11-14 10:22:12','',''),(456,'1','287','2',1,'Sale Id shift 72',0.00,0.00,0.00,2986.81,0.00,'2022-11-14 10:29:13','',''),(457,'1','287','3',1,'Sale Id shift 72',0.00,0.00,0.00,1504.87,0.00,'2022-11-14 10:29:13','',''),(458,'1','287','3',1,'Sale Id shift 72',0.00,0.00,0.00,835.36,0.00,'2022-11-14 10:29:13','',''),(459,'1','287',NULL,1,'Sale Id shift 72',958867.20,0.00,0.00,0.00,0.00,'2022-11-14 10:29:13','',''),(460,'1','287','2',1,'Sale Id shift 73',0.00,0.00,0.00,3373.85,0.00,'2022-11-14 10:39:51','',''),(461,'1','287','2',1,'Sale Id shift 73',0.00,0.00,0.00,525.87,0.00,'2022-11-14 10:39:51','',''),(462,'1','287','4',2,'Sale Id shift 73',0.00,0.00,0.00,30.00,0.00,'2022-11-14 10:39:51','',''),(463,'1','287',NULL,2,'Sale Id shift 73',24000.00,0.00,0.00,0.00,0.00,'2022-11-14 10:39:51','',''),(464,'1','287',NULL,1,'Sale Id shift 73',701949.60,0.00,0.00,0.00,0.00,'2022-11-14 10:39:51','',''),(465,'1','287','2',1,'Sale Id shift 74',0.00,0.00,0.00,4015.51,0.00,'2022-11-14 10:46:43','',''),(466,'1','287',NULL,1,'Sale Id shift 74',722791.80,0.00,0.00,0.00,0.00,'2022-11-14 10:46:43','',''),(467,'1','287','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,2940.87,0.00,'2022-11-14 11:06:36','',''),(468,'1','287','2',0,'Inventory adjustment from tank dipping to 3159',0.00,0.00,3159.00,0.00,0.00,'2022-11-14 11:06:36','',''),(469,'1','287','2',1,'Sale Id shift 75',0.00,0.00,0.00,3158.19,0.00,'2022-11-14 11:14:02','',''),(470,'1','287','4',2,'Sale Id shift 75',0.00,0.00,0.00,30.00,0.00,'2022-11-14 11:14:02','',''),(471,'1','287',NULL,2,'Sale Id shift 75',24000.00,0.00,0.00,0.00,0.00,'2022-11-14 11:14:02','',''),(472,'1','287',NULL,1,'Sale Id shift 75',568474.20,0.00,0.00,0.00,0.00,'2022-11-14 11:14:02','',''),(473,'1','287',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,12600000.00,60000.00,0.00,0.00,'2022-11-24 04:39:21','',''),(474,'1','287',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,12600000.00,60000.00,0.00,0.00,'2022-11-24 04:39:39','',''),(475,'1','287',NULL,1,'Reception corrector for bridging 19',0.00,0.00,0.00,29700.00,0.00,'2022-11-24 09:21:28','',''),(476,'1','287','1',1,'Received from bridging 19',0.00,0.00,29700.00,0.00,0.00,'2022-11-24 09:21:28','',''),(477,'1','287',NULL,1,'Reception corrector for bridging 20',0.00,0.00,0.00,30300.00,0.00,'2022-11-24 09:21:46','',''),(478,'1','287','2',1,'Received from bridging 20',0.00,0.00,30300.00,0.00,0.00,'2022-11-24 09:21:46','',''),(479,'1','287',NULL,1,'Reception corrector for bridging 22',0.00,0.00,0.00,30000.00,0.00,'2022-11-24 09:26:17','',''),(480,'1','287','3',1,'Received from bridging 22',0.00,0.00,30000.00,0.00,0.00,'2022-11-24 09:26:17','',''),(481,'1','287',NULL,1,'Reception corrector for bridging 21',0.00,0.00,0.00,7500.00,0.00,'2022-11-24 09:26:17','',''),(482,'1','287','2',1,'Received from bridging 21',0.00,0.00,7500.00,0.00,0.00,'2022-11-24 09:26:17','',''),(483,'1','287','4',2,'Sale Id shift 77',0.00,0.00,0.00,1830.00,0.00,'2022-11-24 11:21:47','',''),(484,'1','287',NULL,2,'Sale Id shift 77',1509750.00,0.00,0.00,0.00,0.00,'2022-11-24 11:21:47','',''),(485,'1','287','4',2,'Sale Id shift 78',0.00,0.00,0.00,279.52,0.00,'2022-11-25 07:53:06','',''),(486,'1','287',NULL,2,'Sale Id shift 78',234796.80,0.00,0.00,0.00,0.00,'2022-11-25 07:53:06','',''),(487,'1','287','1',1,'Sale Id shift 79',0.00,0.00,0.00,2900.69,0.00,'2022-11-25 08:44:39','',''),(488,'1','287','1',1,'Sale Id shift 79',0.00,0.00,0.00,488.15,0.00,'2022-11-25 08:44:39','',''),(489,'1','287','1',1,'Sale Id shift 79',0.00,0.00,0.00,1375.04,0.00,'2022-11-25 08:44:39','',''),(490,'1','287','1',1,'Sale Id shift 79',0.00,0.00,0.00,2050.31,0.00,'2022-11-25 08:44:39','',''),(491,'1','287','2',1,'Sale Id shift 79',0.00,0.00,0.00,1270.98,0.00,'2022-11-25 08:44:39','',''),(492,'1','287','2',1,'Sale Id shift 79',0.00,0.00,0.00,1340.14,0.00,'2022-11-25 08:44:39','',''),(493,'1','287','3',1,'Sale Id shift 79',0.00,0.00,0.00,1318.31,0.00,'2022-11-25 08:44:39','',''),(494,'1','287','3',1,'Sale Id shift 79',0.00,0.00,0.00,1143.34,0.00,'2022-11-25 08:44:39','',''),(495,'1','287',NULL,1,'Sale Id shift 79',2496261.60,0.00,0.00,0.00,0.00,'2022-11-25 08:44:39','',''),(496,'1','287','1',1,'Sale Id shift 80',0.00,0.00,0.00,1608.48,0.00,'2022-11-25 09:10:20','',''),(497,'1','287','1',1,'Sale Id shift 80',0.00,0.00,0.00,2228.80,0.00,'2022-11-25 09:10:20','',''),(498,'1','287','1',1,'Sale Id shift 80',0.00,0.00,0.00,1135.29,0.00,'2022-11-25 09:10:20','',''),(499,'1','287','2',1,'Sale Id shift 80',0.00,0.00,0.00,2519.11,0.00,'2022-11-25 09:10:20','',''),(500,'1','287','3',1,'Sale Id shift 80',0.00,0.00,0.00,1396.36,0.00,'2022-11-25 09:10:20','',''),(501,'1','287','3',1,'Sale Id shift 80',0.00,0.00,0.00,1550.40,0.00,'2022-11-25 09:10:20','',''),(502,'1','287','4',2,'Sale Id shift 80',0.00,0.00,0.00,916.35,0.00,'2022-11-25 09:10:20','',''),(503,'1','287',NULL,2,'Sale Id shift 80',769734.00,0.00,0.00,0.00,0.00,'2022-11-25 09:10:20','',''),(504,'1','287',NULL,1,'Sale Id shift 80',2192072.40,0.00,0.00,0.00,0.00,'2022-11-25 09:10:20','',''),(505,'1','287','1',1,'Sale Id shift 81',0.00,0.00,0.00,1155.75,0.00,'2022-11-25 17:32:20','',''),(506,'1','287','1',1,'Sale Id shift 81',0.00,0.00,0.00,1697.49,0.00,'2022-11-25 17:32:20','',''),(507,'1','287','1',1,'Sale Id shift 81',0.00,0.00,0.00,2205.50,0.00,'2022-11-25 17:32:20','',''),(508,'1','287','1',1,'Sale Id shift 81',0.00,0.00,0.00,1279.97,0.00,'2022-11-25 17:32:20','',''),(509,'1','287','2',1,'Sale Id shift 81',0.00,0.00,0.00,1970.57,0.00,'2022-11-25 17:32:20','',''),(510,'1','287','3',1,'Sale Id shift 81',0.00,0.00,0.00,1223.23,0.00,'2022-11-25 17:32:20','',''),(511,'1','287','3',1,'Sale Id shift 81',0.00,0.00,0.00,1006.35,0.00,'2022-11-25 17:32:20','',''),(512,'1','287',NULL,1,'Sale Id shift 81',2213160.60,0.00,0.00,0.00,0.00,'2022-11-25 17:32:20','',''),(513,'1','287',NULL,1,'Reception corrector for bridging 24',0.00,0.00,0.00,13000.00,0.00,'2022-11-26 07:37:20','',''),(514,'1','287','3',1,'Received from bridging 24',0.00,0.00,13000.00,0.00,0.00,'2022-11-26 07:37:20','',''),(515,'1','287',NULL,1,'Reception corrector for bridging 23',0.00,0.00,0.00,10300.00,0.00,'2022-11-26 07:37:20','',''),(516,'1','287','1',1,'Received from bridging 23',0.00,0.00,10300.00,0.00,0.00,'2022-11-26 07:37:20','',''),(517,'1','287','1',1,'Sale Id shift 82',0.00,0.00,0.00,2930.81,0.00,'2022-11-26 07:59:39','',''),(518,'1','287','1',1,'Sale Id shift 82',0.00,0.00,0.00,2400.36,0.00,'2022-11-26 07:59:39','',''),(519,'1','287','2',1,'Sale Id shift 82',0.00,0.00,0.00,2477.40,0.00,'2022-11-26 07:59:39','',''),(520,'1','287','3',1,'Sale Id shift 82',0.00,0.00,0.00,2409.11,0.00,'2022-11-26 07:59:39','',''),(521,'1','287','4',2,'Sale Id shift 82',0.00,0.00,0.00,160.15,0.00,'2022-11-26 07:59:39','',''),(522,'1','287',NULL,2,'Sale Id shift 82',134526.00,0.00,0.00,0.00,0.00,'2022-11-26 07:59:39','',''),(523,'1','287',NULL,1,'Sale Id shift 82',2145712.80,0.00,0.00,0.00,0.00,'2022-11-26 07:59:39','',''),(524,'1','287','1',1,'Sale Id shift 83',0.00,0.00,0.00,33.80,0.00,'2022-11-26 09:49:09','',''),(525,'1','287','1',1,'Sale Id shift 83',0.00,0.00,0.00,3011.80,0.00,'2022-11-26 09:49:09','',''),(526,'1','287','1',1,'Sale Id shift 83',0.00,0.00,0.00,2490.75,0.00,'2022-11-26 09:49:09','',''),(527,'1','287','2',1,'Sale Id shift 83',0.00,0.00,0.00,3518.91,0.00,'2022-11-26 09:49:09','',''),(528,'1','287','3',1,'Sale Id shift 83',0.00,0.00,0.00,1871.73,0.00,'2022-11-26 09:49:09','',''),(529,'1','287',NULL,1,'Sale Id shift 83',2294667.90,0.00,0.00,0.00,0.00,'2022-11-26 09:49:09','',''),(530,'1','287','1',1,'Sale Id shift 84',0.00,0.00,0.00,2603.55,0.00,'2022-11-27 09:21:42','',''),(531,'1','287','1',1,'Sale Id shift 84',0.00,0.00,0.00,2403.78,0.00,'2022-11-27 09:21:42','',''),(532,'1','287','2',1,'Sale Id shift 84',0.00,0.00,0.00,2591.74,0.00,'2022-11-27 09:21:42','',''),(533,'1','287','3',1,'Sale Id shift 84',0.00,0.00,0.00,2450.21,0.00,'2022-11-27 09:21:42','',''),(534,'1','287',NULL,1,'Sale Id shift 84',2110348.80,0.00,0.00,0.00,0.00,'2022-11-27 09:21:42','',''),(535,'1','287','1',1,'Sale Id shift 85',0.00,0.00,0.00,2299.20,0.00,'2022-11-27 14:43:45','',''),(536,'1','287','1',1,'Sale Id shift 85',0.00,0.00,0.00,3498.88,0.00,'2022-11-27 14:43:45','',''),(537,'1','287','2',1,'Sale Id shift 85',0.00,0.00,0.00,2647.57,0.00,'2022-11-27 14:43:45','',''),(538,'1','287','3',1,'Sale Id shift 85',0.00,0.00,0.00,2271.69,0.00,'2022-11-27 14:43:45','',''),(539,'1','287','4',2,'Sale Id shift 85',0.00,0.00,0.00,580.00,0.00,'2022-11-27 14:43:45','',''),(540,'1','287',NULL,2,'Sale Id shift 85',487200.00,0.00,0.00,0.00,0.00,'2022-11-27 14:43:45','',''),(541,'1','287',NULL,1,'Sale Id shift 85',2250641.40,0.00,0.00,0.00,0.00,'2022-11-27 14:43:45','',''),(542,'1','287','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,277.07,0.00,'2022-11-27 15:44:29','',''),(543,'1','287','1',0,'Inventory adjustment from tank dipping to 587',0.00,0.00,587.00,0.00,0.00,'2022-11-27 15:44:29','',''),(544,'1','287','1',1,'Sale Id shift 86',0.00,0.00,0.00,586.41,0.00,'2022-11-27 15:52:56','',''),(545,'1','287','2',1,'Sale Id shift 86',0.00,0.00,0.00,2522.06,0.00,'2022-11-27 15:52:56','',''),(546,'1','287','2',1,'Sale Id shift 86',0.00,0.00,0.00,2780.26,0.00,'2022-11-27 15:52:56','',''),(547,'1','287','3',1,'Sale Id shift 86',0.00,0.00,0.00,5734.91,0.00,'2022-11-27 15:52:56','',''),(548,'1','287',NULL,1,'Sale Id shift 86',2440964.40,0.00,0.00,0.00,0.00,'2022-11-27 15:52:56','',''),(549,'1','287','2',1,'Sale Id shift 87',0.00,0.00,0.00,2898.26,0.00,'2022-11-28 12:07:39','',''),(550,'1','287','2',1,'Sale Id shift 87',0.00,0.00,0.00,3211.14,0.00,'2022-11-28 12:07:39','',''),(551,'1','287','3',1,'Sale Id shift 87',0.00,0.00,0.00,6884.57,0.00,'2022-11-28 12:07:39','',''),(552,'1','287','4',2,'Sale Id shift 87',0.00,0.00,0.00,143.66,0.00,'2022-11-28 12:07:39','',''),(553,'1','287',NULL,2,'Sale Id shift 87',120674.40,0.00,0.00,0.00,0.00,'2022-11-28 12:07:39','',''),(554,'1','287',NULL,1,'Sale Id shift 87',2728733.70,0.00,0.00,0.00,0.00,'2022-11-28 12:07:39','',''),(555,'1','287','2',1,'Sale Id shift 88',0.00,0.00,0.00,1831.13,0.00,'2022-11-28 15:00:40','',''),(556,'1','287','2',1,'Sale Id shift 88',0.00,0.00,0.00,3156.14,0.00,'2022-11-28 15:00:41','',''),(557,'1','287','3',1,'Sale Id shift 88',0.00,0.00,0.00,2996.07,0.00,'2022-11-28 15:00:41','',''),(558,'1','287','3',1,'Sale Id shift 88',0.00,0.00,0.00,1278.81,0.00,'2022-11-28 15:00:41','',''),(559,'1','287',NULL,1,'Sale Id shift 88',1945051.50,0.00,0.00,0.00,0.00,'2022-11-28 15:00:41','',''),(560,'1','287','2',1,'Sale Id shift 89',0.00,0.00,0.00,1469.81,0.00,'2022-11-29 11:16:25','',''),(561,'1','287','2',1,'Sale Id shift 89',0.00,0.00,0.00,1113.85,0.00,'2022-11-29 11:16:25','',''),(562,'1','287','3',1,'Sale Id shift 89',0.00,0.00,0.00,4861.41,0.00,'2022-11-29 11:16:25','',''),(563,'1','287','4',2,'Sale Id shift 89',0.00,0.00,0.00,1726.85,0.00,'2022-11-29 11:16:25','',''),(564,'1','287',NULL,2,'Sale Id shift 89',1450554.00,0.00,0.00,0.00,0.00,'2022-11-29 11:16:25','',''),(565,'1','287',NULL,1,'Sale Id shift 89',1563464.70,0.00,0.00,0.00,0.00,'2022-11-29 11:16:25','',''),(566,'1','287','3',1,'Sale Id shift 90',0.00,0.00,0.00,3805.59,0.00,'2022-11-29 16:54:09','',''),(567,'1','287',NULL,1,'Sale Id shift 90',799173.90,0.00,0.00,0.00,0.00,'2022-11-29 16:54:09','',''),(568,'1','287','4',2,'Sale Id shift 91',0.00,0.00,0.00,530.41,0.00,'2022-11-30 11:34:56','',''),(569,'1','287',NULL,2,'Sale Id shift 91',445544.40,0.00,0.00,0.00,0.00,'2022-11-30 11:34:56','',''),(570,'1','287','4',2,'Sale Id shift 92',0.00,0.00,0.00,878.09,0.00,'2022-12-02 10:19:52','',''),(571,'1','287',NULL,2,'Sale Id shift 92',737595.60,0.00,0.00,0.00,0.00,'2022-12-02 10:19:52','',''),(572,'1','287','4',2,'Sale Id shift 93',0.00,0.00,0.00,880.00,0.00,'2022-12-03 21:44:47','',''),(573,'1','287',NULL,2,'Sale Id shift 93',739200.00,0.00,0.00,0.00,0.00,'2022-12-03 21:44:47','',''),(574,'1','287','4',2,'Sale Id shift 94',0.00,0.00,0.00,1172.17,0.00,'2022-12-04 12:08:42','',''),(575,'1','287',NULL,2,'Sale Id shift 94',984622.80,0.00,0.00,0.00,0.00,'2022-12-04 12:08:42','',''),(576,'1','287','4',2,'Sale Id shift 95',0.00,0.00,0.00,357.00,0.00,'2022-12-15 21:51:11','',''),(577,'1','287',NULL,2,'Sale Id shift 95',299880.00,0.00,0.00,0.00,0.00,'2022-12-15 21:51:11','',''),(578,'1','287','4',2,'Sale Id shift 96',0.00,0.00,0.00,287.20,0.00,'2022-12-18 14:24:55','',''),(579,'1','287',NULL,2,'Sale Id shift 96',235504.00,0.00,0.00,0.00,0.00,'2022-12-18 14:24:55','',''),(580,'1','287','4',2,'Sale Id shift 97',0.00,0.00,0.00,500.73,0.00,'2022-12-21 08:00:29','',''),(581,'1','287',NULL,2,'Sale Id shift 97',410598.60,0.00,0.00,0.00,0.00,'2022-12-21 08:00:29','',''),(582,'1','287','4',2,'Sale Id shift 98',0.00,0.00,0.00,354.87,0.00,'2022-12-21 08:33:09','',''),(583,'1','287',NULL,2,'Sale Id shift 98',290993.40,0.00,0.00,0.00,0.00,'2022-12-21 08:33:09','',''),(584,'1','287','4',2,'Sale Id shift 99',0.00,0.00,0.00,647.85,0.00,'2022-12-29 09:24:42','',''),(585,'1','287',NULL,2,'Sale Id shift 99',531237.00,0.00,0.00,0.00,0.00,'2022-12-29 09:24:42','',''),(586,'1','287','4',2,'Sale Id shift 100',0.00,0.00,0.00,1856.00,0.00,'2023-01-20 09:18:05','',''),(587,'1','287',NULL,2,'Sale Id shift 100',1540480.00,0.00,0.00,0.00,0.00,'2023-01-20 09:18:05','',''),(588,'1','287','4',2,'Sale Id shift 101',0.00,0.00,0.00,1084.34,0.00,'2023-01-27 09:51:58','',''),(589,'1','287',NULL,2,'Sale Id shift 101',900002.20,0.00,0.00,0.00,0.00,'2023-01-27 09:51:58','',''),(590,'1','287','4',2,'Sale Id shift 102',0.00,0.00,0.00,553.68,0.00,'2023-02-01 14:34:43','',''),(591,'1','287',NULL,2,'Sale Id shift 102',437407.20,0.00,0.00,0.00,0.00,'2023-02-01 14:34:43','',''),(592,'1','287','4',2,'Sale Id shift 103',0.00,0.00,0.00,217.34,0.00,'2023-02-06 11:19:36','',''),(593,'1','287',NULL,2,'Sale Id shift 103',171698.60,0.00,0.00,0.00,0.00,'2023-02-06 11:19:36','',''),(594,'1','287','4',2,'Sale Id shift 104',0.00,0.00,0.00,316.46,0.00,'2023-02-06 16:57:27','',''),(595,'1','287',NULL,2,'Sale Id shift 104',250003.40,0.00,0.00,0.00,0.00,'2023-02-06 16:57:27','',''),(596,'1','287','4',2,'Sale Id shift 105',0.00,0.00,0.00,183.75,0.00,'2023-02-08 08:08:27','',''),(597,'1','287',NULL,2,'Sale Id shift 105',148837.50,0.00,0.00,0.00,0.00,'2023-02-08 08:08:27','',''),(598,'1','287','4',2,'Sale Id shift 106',0.00,0.00,0.00,60.00,0.00,'2023-02-11 15:04:45','',''),(599,'1','287',NULL,2,'Sale Id shift 106',48600.00,0.00,0.00,0.00,0.00,'2023-02-11 15:04:45','',''),(600,'1','287','4',2,'Sale Id shift 107',0.00,0.00,0.00,479.75,0.00,'2023-02-16 09:18:13','',''),(601,'1','287',NULL,2,'Sale Id shift 107',388597.50,0.00,0.00,0.00,0.00,'2023-02-16 09:18:13','',''),(602,'1','287',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,11750000.00,50000.00,0.00,0.00,'2023-03-02 12:54:33','',''),(603,'1','287',NULL,1,'Reception corrector for bridging 26',0.00,0.00,0.00,16500.00,0.00,'2023-03-02 19:24:47','',''),(604,'1','287','3',1,'Received from bridging 26',0.00,0.00,16500.00,0.00,0.00,'2023-03-02 19:24:47','',''),(605,'1','287',NULL,1,'Reception corrector for bridging 25',0.00,0.00,0.00,33500.00,0.00,'2023-03-02 19:25:45','',''),(606,'1','287','1',1,'Received from bridging 25',0.00,0.00,33500.00,0.00,0.00,'2023-03-02 19:25:45','',''),(607,'1','287','1',1,'Sale Id shift 108',0.00,0.00,0.00,1811.51,0.00,'2023-03-03 09:57:05','',''),(608,'1','287','1',1,'Sale Id shift 108',0.00,0.00,0.00,58.64,0.00,'2023-03-03 09:57:05','',''),(609,'1','287','1',1,'Sale Id shift 108',0.00,0.00,0.00,2106.62,0.00,'2023-03-03 09:57:05','',''),(610,'1','287','1',1,'Sale Id shift 108',0.00,0.00,0.00,-7.04,0.00,'2023-03-03 09:57:05','',''),(611,'1','287','3',1,'Sale Id shift 108',0.00,0.00,0.00,4139.29,0.00,'2023-03-03 09:57:05','',''),(612,'1','287','3',1,'Sale Id shift 108',0.00,0.00,0.00,1255.77,0.00,'2023-03-03 09:57:05','',''),(613,'1','287','4',2,'Sale Id shift 108',0.00,0.00,0.00,674.00,0.00,'2023-03-03 09:57:05','',''),(614,'1','287',NULL,2,'Sale Id shift 108',545940.00,0.00,0.00,0.00,0.00,'2023-03-03 09:57:05','',''),(615,'1','287',NULL,1,'Sale Id shift 108',2200725.65,0.00,0.00,0.00,0.00,'2023-03-03 09:57:05','',''),(616,'1','287','1',1,'Sale Id shift 109',0.00,0.00,0.00,5318.61,0.00,'2023-03-04 11:28:51','',''),(617,'1','287','1',1,'Sale Id shift 109',0.00,0.00,0.00,2656.34,0.00,'2023-03-04 11:28:51','',''),(618,'1','287','3',1,'Sale Id shift 109',0.00,0.00,0.00,2641.14,0.00,'2023-03-04 11:28:51','',''),(619,'1','287',NULL,1,'Sale Id shift 109',2494781.15,0.00,0.00,0.00,0.00,'2023-03-04 11:28:51','',''),(620,'1','287','1',1,'Sale Id shift 110',0.00,0.00,0.00,4468.53,0.00,'2023-03-06 23:22:14','',''),(621,'1','287','1',1,'Sale Id shift 110',0.00,0.00,0.00,117.30,0.00,'2023-03-06 23:22:14','',''),(622,'1','287','3',1,'Sale Id shift 110',0.00,0.00,0.00,3515.01,0.00,'2023-03-06 23:22:14','',''),(623,'1','287',NULL,1,'Sale Id shift 110',1903697.40,0.00,0.00,0.00,0.00,'2023-03-06 23:22:14','',''),(624,'1','287','1',1,'Sale Id shift 111',0.00,0.00,0.00,0.01,0.00,'2023-03-07 11:31:06','',''),(625,'1','287','1',1,'Sale Id shift 111',0.00,0.00,0.00,136.16,0.00,'2023-03-07 11:31:06','',''),(626,'1','287','1',1,'Sale Id shift 111',0.00,0.00,0.00,8031.32,0.00,'2023-03-07 11:31:06','',''),(627,'1','287','3',1,'Sale Id shift 111',0.00,0.00,0.00,5159.25,0.00,'2023-03-07 11:31:06','',''),(628,'1','287',NULL,1,'Sale Id shift 111',3131783.90,0.00,0.00,0.00,0.00,'2023-03-07 11:31:06','',''),(629,'1','287','1',1,'Sale Id shift 112',0.00,0.00,0.00,4146.36,0.00,'2023-03-08 09:46:03','',''),(630,'1','287','1',1,'Sale Id shift 112',0.00,0.00,0.00,4071.89,0.00,'2023-03-08 09:46:03','',''),(631,'1','287',NULL,1,'Sale Id shift 112',1931288.75,0.00,0.00,0.00,0.00,'2023-03-08 09:46:03','',''),(632,'1','287',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,12000000.00,15000.00,0.00,0.00,'2023-03-08 21:32:21','',''),(633,'1','287',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,11750000.00,50000.00,0.00,0.00,'2023-03-08 21:33:01','',''),(634,'1','287',NULL,1,'Reception corrector for bridging 29',0.00,0.00,0.00,25000.00,0.00,'2023-03-09 07:55:46','',''),(635,'1','287','3',1,'Received from bridging 29',0.00,0.00,25000.00,0.00,0.00,'2023-03-09 07:55:46','',''),(636,'1','287',NULL,1,'Reception corrector for bridging 28',0.00,0.00,0.00,25000.00,0.00,'2023-03-09 07:55:46','',''),(637,'1','287','1',1,'Received from bridging 28',0.00,0.00,25000.00,0.00,0.00,'2023-03-09 07:55:46','',''),(638,'1','287',NULL,2,'Reception corrector for bridging 27',0.00,0.00,0.00,15000.00,0.00,'2023-03-09 07:56:09','',''),(639,'1','287','4',2,'Received from bridging 27',0.00,0.00,15000.00,0.00,0.00,'2023-03-09 07:56:09','',''),(640,'1','287','1',1,'Sale Id shift 113',0.00,0.00,0.00,4449.29,0.00,'2023-03-09 10:17:48','',''),(641,'1','287','1',1,'Sale Id shift 113',0.00,0.00,0.00,3250.35,0.00,'2023-03-09 10:17:48','',''),(642,'1','287','3',1,'Sale Id shift 113',0.00,0.00,0.00,3134.56,0.00,'2023-03-09 10:17:48','',''),(643,'1','287','4',2,'Sale Id shift 113',0.00,0.00,0.00,500.00,0.00,'2023-03-09 10:17:48','',''),(644,'1','287',NULL,2,'Sale Id shift 113',400000.00,0.00,0.00,0.00,0.00,'2023-03-09 10:17:48','',''),(645,'1','287',NULL,1,'Sale Id shift 113',2546037.00,0.00,0.00,0.00,0.00,'2023-03-09 10:17:48','',''),(646,'1','287',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,11879250.00,50550.00,0.00,0.00,'2023-03-09 18:54:16','',''),(647,'1','287',NULL,1,'Reception corrector for bridging 32',0.00,0.00,0.00,15250.00,0.00,'2023-03-10 08:18:11','',''),(648,'1','287','3',1,'Received from bridging 32',0.00,0.00,15250.00,0.00,0.00,'2023-03-10 08:18:11','',''),(649,'1','287',NULL,1,'Reception corrector for bridging 31',0.00,0.00,0.00,15100.00,0.00,'2023-03-10 08:18:11','',''),(650,'1','287','2',1,'Received from bridging 31',0.00,0.00,15100.00,0.00,0.00,'2023-03-10 08:18:11','',''),(651,'1','287',NULL,1,'Reception corrector for bridging 30',0.00,0.00,0.00,15200.00,0.00,'2023-03-10 08:18:11','',''),(652,'1','287','1',1,'Received from bridging 30',0.00,0.00,15200.00,0.00,0.00,'2023-03-10 08:18:11','',''),(653,'1','287','1',1,'Sale Id shift 114',0.00,0.00,0.00,3526.76,0.00,'2023-03-10 09:30:19','',''),(654,'1','287','1',1,'Sale Id shift 114',0.00,0.00,0.00,2984.51,0.00,'2023-03-10 09:30:19','',''),(655,'1','287','3',1,'Sale Id shift 114',0.00,0.00,0.00,2917.34,0.00,'2023-03-10 09:30:19','',''),(656,'1','287',NULL,1,'Sale Id shift 114',2215723.35,0.00,0.00,0.00,0.00,'2023-03-10 09:30:19','',''),(657,'1','287','3',1,'Returned bridging 32',0.00,0.00,0.00,15250.00,0.00,'2023-03-11 09:44:40','',''),(658,'1','287',NULL,1,'Reception Return corrector for bridging 32',0.00,0.00,15250.00,0.00,0.00,'2023-03-11 09:44:40','',''),(659,'1','287','2',1,'Returned bridging 31',0.00,0.00,0.00,15100.00,0.00,'2023-03-11 09:45:11','',''),(660,'1','287',NULL,1,'Reception Return corrector for bridging 31',0.00,0.00,15100.00,0.00,0.00,'2023-03-11 09:45:11','',''),(661,'1','287','1',1,'Returned bridging 30',0.00,0.00,0.00,15200.00,0.00,'2023-03-11 09:45:40','',''),(662,'1','287',NULL,1,'Reception Return corrector for bridging 30',0.00,0.00,15200.00,0.00,0.00,'2023-03-11 09:45:40','',''),(663,'1','287',NULL,1,'Returned purchase #14 to AA RANO NIGERIA LTD',11879250.00,0.00,0.00,50550.00,0.00,'2023-03-11 10:13:06','',''),(664,'1','287','1',1,'Sale Id shift 115',0.00,0.00,0.00,3837.75,0.00,'2023-03-11 17:03:13','',''),(665,'1','287','1',1,'Sale Id shift 115',0.00,0.00,0.00,2467.12,0.00,'2023-03-11 17:03:13','',''),(666,'1','287','3',1,'Sale Id shift 115',0.00,0.00,0.00,2329.78,0.00,'2023-03-11 17:03:13','',''),(667,'1','287',NULL,1,'Sale Id shift 115',2029142.75,0.00,0.00,0.00,0.00,'2023-03-11 17:03:13','',''),(668,'1','287',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,10704250.00,45550.00,0.00,0.00,'2023-03-11 17:03:59','',''),(669,'1','287',NULL,1,'Reception corrector for bridging 34',0.00,0.00,0.00,15100.00,0.00,'2023-03-12 08:33:31','',''),(670,'1','287','2',1,'Received from bridging 34',0.00,0.00,15100.00,0.00,0.00,'2023-03-12 08:33:31','',''),(671,'1','287',NULL,1,'Reception corrector for bridging 35',0.00,0.00,0.00,15250.00,0.00,'2023-03-12 08:46:40','',''),(672,'1','287','3',1,'Received from bridging 35',0.00,0.00,15250.00,0.00,0.00,'2023-03-12 08:46:40','',''),(673,'1','287',NULL,1,'Reception corrector for bridging 33',0.00,0.00,0.00,15200.00,0.00,'2023-03-12 08:47:03','',''),(674,'1','287','1',1,'Received from bridging 33',0.00,0.00,15200.00,0.00,0.00,'2023-03-12 08:47:03','',''),(675,'1','287','1',1,'Sale Id shift 116',0.00,0.00,0.00,4256.75,0.00,'2023-03-12 21:55:31','',''),(676,'1','287','1',1,'Sale Id shift 116',0.00,0.00,0.00,4034.73,0.00,'2023-03-12 21:55:31','',''),(677,'1','287','1',1,'Sale Id shift 116',0.00,0.00,0.00,56.30,0.00,'2023-03-12 21:55:31','',''),(678,'1','287','2',1,'Sale Id shift 116',0.00,0.00,0.00,2336.39,0.00,'2023-03-12 21:55:31','',''),(679,'1','287','3',1,'Sale Id shift 116',0.00,0.00,0.00,3714.35,0.00,'2023-03-12 21:55:31','',''),(680,'1','287','3',1,'Sale Id shift 116',0.00,0.00,0.00,0.01,0.00,'2023-03-12 21:55:31','',''),(681,'1','287',NULL,1,'Sale Id shift 116',3383654.55,0.00,0.00,0.00,0.00,'2023-03-12 21:55:31','',''),(682,'1','287','1',1,'Sale Id shift 117',0.00,0.00,0.00,4847.08,0.00,'2023-03-14 08:27:28','',''),(683,'1','287','1',1,'Sale Id shift 117',0.00,0.00,0.00,2726.99,0.00,'2023-03-14 08:27:28','',''),(684,'1','287','2',1,'Sale Id shift 117',0.00,0.00,0.00,1992.29,0.00,'2023-03-14 08:27:28','',''),(685,'1','287','3',1,'Sale Id shift 117',0.00,0.00,0.00,1896.41,0.00,'2023-03-14 08:27:28','',''),(686,'1','287','4',2,'Sale Id shift 117',0.00,0.00,0.00,150.00,0.00,'2023-03-14 08:27:28','',''),(687,'1','287',NULL,2,'Sale Id shift 117',118500.00,0.00,0.00,0.00,0.00,'2023-03-14 08:27:28','',''),(688,'1','287',NULL,1,'Sale Id shift 117',2693750.95,0.00,0.00,0.00,0.00,'2023-03-14 08:27:28','',''),(689,'1','287','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,15345.55,0.00,'2023-03-15 09:07:52','',''),(690,'1','287','4',0,'Inventory adjustment from tank dipping to 4493',0.00,0.00,4493.00,0.00,0.00,'2023-03-15 09:07:52','',''),(691,'1','287','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,4493.00,0.00,'2023-03-15 09:10:57','',''),(692,'1','287','4',0,'Inventory adjustment from tank dipping to 15350',0.00,0.00,15350.00,0.00,0.00,'2023-03-15 09:10:57','',''),(693,'1','287','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,4346.71,0.00,'2023-03-15 09:11:38','',''),(694,'1','287','1',0,'Inventory adjustment from tank dipping to 4493',0.00,0.00,4493.00,0.00,0.00,'2023-03-15 09:11:38','',''),(695,'1','287','1',1,'Sale Id shift 118',0.00,0.00,0.00,1986.29,0.00,'2023-03-15 18:09:27','',''),(696,'1','287','1',1,'Sale Id shift 118',0.00,0.00,0.00,2506.41,0.00,'2023-03-15 18:09:27','',''),(697,'1','287','2',1,'Sale Id shift 118',0.00,0.00,0.00,3217.35,0.00,'2023-03-15 18:09:27','',''),(698,'1','287','3',1,'Sale Id shift 118',0.00,0.00,0.00,3114.05,0.00,'2023-03-15 18:09:27','',''),(699,'1','287','4',2,'Sale Id shift 118',0.00,0.00,0.00,500.00,0.00,'2023-03-15 18:09:27','',''),(700,'1','287',NULL,2,'Sale Id shift 118',395000.00,0.00,0.00,0.00,0.00,'2023-03-15 18:09:27','',''),(701,'1','287',NULL,1,'Sale Id shift 118',2543663.50,0.00,0.00,0.00,0.00,'2023-03-15 18:09:27','',''),(702,'1','287','2',1,'Sale Id shift 119',0.00,0.00,0.00,73.44,0.00,'2023-03-16 09:08:02','',''),(703,'1','287','2',1,'Sale Id shift 119',0.00,0.00,0.00,228.82,0.00,'2023-03-16 09:08:02','',''),(704,'1','287','3',1,'Sale Id shift 119',0.00,0.00,0.00,5128.41,0.00,'2023-03-16 09:08:02','',''),(705,'1','287','3',1,'Sale Id shift 119',0.00,0.00,0.00,5648.70,0.00,'2023-03-16 09:08:02','',''),(706,'1','287','4',2,'Sale Id shift 119',0.00,0.00,0.00,400.00,0.00,'2023-03-16 09:08:02','',''),(707,'1','287',NULL,2,'Sale Id shift 119',316000.00,0.00,0.00,0.00,0.00,'2023-03-16 09:08:02','',''),(708,'1','287',NULL,1,'Sale Id shift 119',2603651.95,0.00,0.00,0.00,0.00,'2023-03-16 09:08:02','',''),(709,'1','287',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,11750000.00,50000.00,0.00,0.00,'2023-03-16 09:15:35','',''),(710,'1','287',NULL,1,'Reception corrector for bridging 36',0.00,0.00,0.00,25000.00,0.00,'2023-03-17 08:35:21','',''),(711,'1','287','1',1,'Received from bridging 36',0.00,0.00,25000.00,0.00,0.00,'2023-03-17 08:35:21','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'1','287',2,14445.55,'2023-03-19 13:47:52'),(2,'1','287',1,70770.81,'2023-03-19 13:47:52');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=153 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1,'1','287',1,'Sale Id shift 3',0.00,592057.80,180.00,592057.80,0.00,'2022-10-28 09:13:13'),(2,'1','287',1,'Sale Id shift 4',0.00,1044462.60,180.00,1044462.60,0.00,'2022-10-28 09:30:32'),(3,'1','287',1,'Sale Id shift 5',0.00,809145.00,180.00,809145.00,0.00,'2022-10-29 08:34:54'),(4,'1','287',1,'Sale Id shift 6',0.00,723850.20,180.00,723850.20,0.00,'2022-10-29 09:17:35'),(5,'1','287',1,'Sale Id shift 7',0.00,647643.60,180.00,647643.60,0.00,'2022-10-29 09:33:52'),(6,'1','287',1,'Sale Id shift 8',0.00,492969.60,180.00,492969.60,0.00,'2022-10-29 10:27:34'),(7,'1','287',1,'Sale Id shift 9',0.00,671328.00,180.00,671328.00,0.00,'2022-10-29 10:55:36'),(8,'1','287',1,'Sale Id shift 10',0.00,692247.60,180.00,692247.60,0.00,'2022-10-29 11:17:27'),(9,'1','287',1,'Sale Id shift 11',0.00,580806.00,180.00,580806.00,0.00,'2022-10-30 11:13:03'),(10,'1','287',1,'Sale Id shift 12',0.00,646309.80,180.00,646309.80,0.00,'2022-10-30 11:33:23'),(11,'1','287',1,'Sale Id shift 13',0.00,649638.00,180.00,649638.00,0.00,'2022-10-30 13:01:58'),(12,'1','287',1,'Sale Id shift 14',0.00,597324.60,180.00,597324.60,0.00,'2022-10-30 14:23:09'),(13,'1','287',1,'Sale Id shift 15',0.00,390495.60,180.00,390495.60,0.00,'2022-10-30 23:07:04'),(14,'1','287',1,'Sale Id shift 16',0.00,207176.40,180.00,207176.40,0.00,'2022-11-01 09:09:19'),(15,'1','287',1,'Sale Id shift 17',0.00,690136.20,180.00,690136.20,0.00,'2022-11-01 18:06:41'),(16,'1','287',2,'Sale Id shift 18',0.00,8000.30,770.00,8000.30,0.00,'2022-11-01 20:44:44'),(17,'1','287',1,'Sale Id shift 18',0.00,597700.80,180.00,597700.80,0.00,'2022-11-01 20:44:44'),(18,'1','287',1,'Sale Id shift 19',0.00,531770.40,180.00,531770.40,0.00,'2022-11-02 18:58:52'),(19,'1','287',1,'Sale Id shift 20',0.00,417297.60,180.00,417297.60,0.00,'2022-11-03 07:44:23'),(20,'1','287',2,'Sale Id shift 21',0.00,38500.00,770.00,38500.00,0.00,'2022-11-03 09:03:40'),(21,'1','287',1,'Sale Id shift 21',0.00,420314.40,180.00,420314.40,0.00,'2022-11-03 09:03:40'),(22,'1','287',1,'Sale Id shift 22',0.00,546832.80,180.00,546832.80,0.00,'2022-11-03 14:01:16'),(23,'1','287',1,'Sale Id shift 23',0.00,485026.20,180.00,485026.20,0.00,'2022-11-06 11:16:15'),(24,'1','287',2,'Sale Id shift 24',0.00,78301.30,770.00,78301.30,0.00,'2022-11-06 14:21:24'),(25,'1','287',1,'Sale Id shift 24',0.00,699814.80,180.00,699814.80,0.00,'2022-11-06 14:21:24'),(26,'1','287',2,'Sale Id shift 25',0.00,38500.00,770.00,38500.00,0.00,'2022-11-06 20:48:04'),(27,'1','287',1,'Sale Id shift 25',0.00,492303.60,180.00,492303.60,0.00,'2022-11-06 20:48:04'),(28,'1','287',1,'Sale Id shift 26',0.00,552670.20,180.00,552670.20,0.00,'2022-11-06 20:56:22'),(29,'1','287',2,'Sale Id shift 27',0.00,60822.30,770.00,60822.30,0.00,'2022-11-06 21:04:08'),(30,'1','287',1,'Sale Id shift 27',0.00,452782.80,180.00,452782.80,0.00,'2022-11-06 21:04:08'),(31,'1','287',1,'Sale Id shift 29',0.00,480798.00,180.00,480798.00,0.00,'2022-11-07 08:21:44'),(32,'1','287',1,'Sale Id shift 30',0.00,271107.00,180.00,271107.00,0.00,'2022-11-08 13:03:37'),(33,'1','287',2,'Sale Id shift 31',0.00,71278.90,770.00,71278.90,0.00,'2022-11-08 16:46:02'),(34,'1','287',1,'Sale Id shift 31',0.00,552357.00,180.00,552357.00,0.00,'2022-11-08 16:46:02'),(35,'1','287',1,'Sale Id shift 32',0.00,306957.60,180.00,306957.60,0.00,'2022-11-09 19:25:04'),(36,'1','287',2,'Sale Id shift 33',0.00,49765.10,770.00,49765.10,0.00,'2022-11-10 10:21:59'),(37,'1','287',1,'Sale Id shift 33',0.00,570933.00,180.00,570933.00,0.00,'2022-11-10 10:21:59'),(38,'1','287',2,'Sale Id shift 34',0.00,30800.00,770.00,30800.00,0.00,'2022-11-10 10:30:38'),(39,'1','287',1,'Sale Id shift 34',0.00,441918.00,180.00,441918.00,0.00,'2022-11-10 10:30:38'),(40,'1','287',1,'Sale Id shift 35',0.00,589168.80,180.00,589168.80,0.00,'2022-11-10 12:57:44'),(41,'1','287',1,'Sale Id shift 36',0.00,423387.00,180.00,423387.00,0.00,'2022-11-10 14:26:41'),(42,'1','287',2,'Sale Id shift 37',0.00,38500.00,770.00,38500.00,0.00,'2022-11-10 15:52:24'),(43,'1','287',1,'Sale Id shift 37',0.00,708931.80,180.00,708931.80,0.00,'2022-11-10 15:52:24'),(44,'1','287',2,'Sale Id shift 38',0.00,38500.00,770.00,38500.00,0.00,'2022-11-10 16:11:28'),(45,'1','287',1,'Sale Id shift 38',0.00,484511.40,180.00,484511.40,0.00,'2022-11-10 16:11:28'),(46,'1','287',1,'Sale Id shift 39',0.00,708327.00,180.00,708327.00,0.00,'2022-11-10 16:29:27'),(47,'1','287',2,'Sale Id shift 40',0.00,115500.00,770.00,115500.00,0.00,'2022-11-10 16:46:32'),(48,'1','287',1,'Sale Id shift 40',0.00,502675.20,180.00,502675.20,0.00,'2022-11-10 16:46:32'),(49,'1','287',2,'Sale Id shift 41',0.00,2887.50,800.00,3000.00,112.50,'2022-11-10 17:07:49'),(50,'1','287',1,'Sale Id shift 41',0.00,703917.00,180.00,703917.00,0.00,'2022-11-10 17:07:49'),(51,'1','287',2,'Sale Id shift 42',0.00,38500.00,800.00,40000.00,1500.00,'2022-11-10 17:37:42'),(52,'1','287',1,'Sale Id shift 42',0.00,525960.00,180.00,525960.00,0.00,'2022-11-10 17:37:42'),(53,'1','287',2,'Sale Id shift 43',0.00,3080.00,800.00,3200.00,120.00,'2022-11-10 18:10:06'),(54,'1','287',1,'Sale Id shift 43',0.00,781315.20,180.00,781315.20,0.00,'2022-11-10 18:10:06'),(55,'1','287',2,'Sale Id shift 44',0.00,38500.00,800.00,40000.00,1500.00,'2022-11-11 01:58:03'),(56,'1','287',1,'Sale Id shift 44',0.00,902091.60,180.00,902091.60,0.00,'2022-11-11 01:58:03'),(57,'1','287',1,'Sale Id shift 46',0.00,1315629.00,180.00,1315629.00,0.00,'2022-11-11 12:41:46'),(58,'1','287',2,'Sale Id shift 47',0.00,62600.00,800.00,62600.00,0.00,'2022-11-11 12:51:53'),(59,'1','287',1,'Sale Id shift 47',0.00,483170.40,180.00,483170.40,0.00,'2022-11-11 12:51:53'),(60,'1','287',1,'Sale Id shift 48',0.00,1118475.00,180.00,1118475.00,0.00,'2022-11-11 13:14:01'),(61,'1','287',2,'Sale Id shift 49',0.00,27000.00,800.00,27000.00,0.00,'2022-11-11 15:02:13'),(62,'1','287',1,'Sale Id shift 49',0.00,170573.40,180.00,170573.40,0.00,'2022-11-11 15:02:13'),(63,'1','287',1,'Sale Id shift 51',0.00,1840743.00,180.00,1840743.00,0.00,'2022-11-11 15:37:40'),(64,'1','287',2,'Sale Id shift 52',0.00,26000.00,800.00,26000.00,0.00,'2022-11-11 16:03:16'),(65,'1','287',1,'Sale Id shift 52',0.00,1139493.60,180.00,1139493.60,0.00,'2022-11-11 16:03:16'),(66,'1','287',1,'Sale Id shift 53',0.00,1060119.00,180.00,1060119.00,0.00,'2022-11-11 16:14:59'),(67,'1','287',2,'Sale Id shift 54',0.00,624000.00,800.00,624000.00,0.00,'2022-11-11 16:24:55'),(68,'1','287',1,'Sale Id shift 54',0.00,1174374.00,180.00,1174374.00,0.00,'2022-11-11 16:24:55'),(69,'1','287',1,'Sale Id shift 55',0.00,1106454.60,180.00,1106454.60,0.00,'2022-11-11 16:41:28'),(70,'1','287',2,'Sale Id shift 56',0.00,24000.00,800.00,24000.00,0.00,'2022-11-11 16:57:13'),(71,'1','287',1,'Sale Id shift 56',0.00,994712.40,180.00,994712.40,0.00,'2022-11-11 16:57:13'),(72,'1','287',1,'Sale Id shift 57',0.00,1390849.20,180.00,1390849.20,0.00,'2022-11-12 08:12:44'),(73,'1','287',2,'Sale Id shift 58',0.00,24000.00,800.00,24000.00,0.00,'2022-11-12 09:02:47'),(74,'1','287',1,'Sale Id shift 58',0.00,1065337.20,180.00,1065337.20,0.00,'2022-11-12 09:02:47'),(75,'1','287',2,'Sale Id shift 59',0.00,56000.00,800.00,56000.00,0.00,'2022-11-12 10:25:51'),(76,'1','287',1,'Sale Id shift 59',0.00,1189926.00,180.00,1189926.00,0.00,'2022-11-12 10:25:51'),(77,'1','287',2,'Sale Id shift 60',0.00,24000.00,800.00,24000.00,0.00,'2022-11-12 10:38:16'),(78,'1','287',1,'Sale Id shift 60',0.00,1033497.00,180.00,1033497.00,0.00,'2022-11-12 10:38:16'),(79,'1','287',1,'Sale Id shift 61',0.00,1310617.80,180.00,1310617.80,0.00,'2022-11-12 10:48:17'),(80,'1','287',2,'Sale Id shift 62',0.00,24000.00,800.00,24000.00,0.00,'2022-11-12 11:00:46'),(81,'1','287',1,'Sale Id shift 62',0.00,1106013.60,180.00,1106013.60,0.00,'2022-11-12 11:00:46'),(82,'1','287',1,'Sale Id shift 64',0.00,1900447.20,180.00,1900447.20,0.00,'2022-11-12 11:31:22'),(83,'1','287',2,'Sale Id shift 65',0.00,24000.00,800.00,24000.00,0.00,'2022-11-12 11:52:24'),(84,'1','287',1,'Sale Id shift 65',0.00,1180751.40,180.00,1180751.40,0.00,'2022-11-12 11:52:24'),(85,'1','287',1,'Sale Id shift 66',0.00,1407256.20,180.00,1407256.20,0.00,'2022-11-12 12:02:44'),(86,'1','287',2,'Sale Id shift 67',0.00,36008.00,800.00,36008.00,0.00,'2022-11-12 12:23:33'),(87,'1','287',1,'Sale Id shift 67',0.00,1382576.40,180.00,1382576.40,0.00,'2022-11-12 12:23:33'),(88,'1','287',1,'Sale Id shift 68',0.00,1212283.80,180.00,1212283.80,0.00,'2022-11-12 12:31:20'),(89,'1','287',2,'Sale Id shift 69',0.00,87000.00,800.00,87000.00,0.00,'2022-11-13 06:26:57'),(90,'1','287',1,'Sale Id shift 69',0.00,869162.40,180.00,869162.40,0.00,'2022-11-13 06:26:57'),(91,'1','287',1,'Sale Id shift 70',0.00,1038794.40,180.00,1038794.40,0.00,'2022-11-14 10:13:20'),(92,'1','287',2,'Sale Id shift 71',0.00,24000.00,800.00,24000.00,0.00,'2022-11-14 10:22:12'),(93,'1','287',1,'Sale Id shift 71',0.00,715370.40,180.00,715370.40,0.00,'2022-11-14 10:22:12'),(94,'1','287',1,'Sale Id shift 72',0.00,958867.20,180.00,958867.20,0.00,'2022-11-14 10:29:13'),(95,'1','287',2,'Sale Id shift 73',0.00,24000.00,800.00,24000.00,0.00,'2022-11-14 10:39:51'),(96,'1','287',1,'Sale Id shift 73',0.00,701949.60,180.00,701949.60,0.00,'2022-11-14 10:39:51'),(97,'1','287',1,'Sale Id shift 74',0.00,722791.80,180.00,722791.80,0.00,'2022-11-14 10:46:43'),(98,'1','287',2,'Sale Id shift 75',0.00,24000.00,800.00,24000.00,0.00,'2022-11-14 11:14:02'),(99,'1','287',1,'Sale Id shift 75',0.00,568474.20,180.00,568474.20,0.00,'2022-11-14 11:14:02'),(100,'1','287',2,'Sale Id shift 77',0.00,1509750.00,825.00,1509750.00,0.00,'2022-11-24 11:21:47'),(101,'1','287',2,'Sale Id shift 78',0.00,234796.80,840.00,234796.80,0.00,'2022-11-25 07:53:06'),(102,'1','287',1,'Sale Id shift 79',0.00,2496261.60,210.00,2496261.60,0.00,'2022-11-25 08:44:39'),(103,'1','287',2,'Sale Id shift 80',0.00,769734.00,840.00,769734.00,0.00,'2022-11-25 09:10:20'),(104,'1','287',1,'Sale Id shift 80',0.00,2192072.40,210.00,2192072.40,0.00,'2022-11-25 09:10:20'),(105,'1','287',1,'Sale Id shift 81',0.00,2213160.60,210.00,2213160.60,0.00,'2022-11-25 17:32:20'),(106,'1','287',2,'Sale Id shift 82',0.00,134526.00,840.00,134526.00,0.00,'2022-11-26 07:59:39'),(107,'1','287',1,'Sale Id shift 82',0.00,2145712.80,210.00,2145712.80,0.00,'2022-11-26 07:59:39'),(108,'1','287',1,'Sale Id shift 83',0.00,2294667.90,210.00,2294667.90,0.00,'2022-11-26 09:49:09'),(109,'1','287',1,'Sale Id shift 84',0.00,2110348.80,210.00,2110348.80,0.00,'2022-11-27 09:21:42'),(110,'1','287',2,'Sale Id shift 85',0.00,487200.00,840.00,487200.00,0.00,'2022-11-27 14:43:45'),(111,'1','287',1,'Sale Id shift 85',0.00,2250641.40,210.00,2250641.40,0.00,'2022-11-27 14:43:45'),(112,'1','287',1,'Sale Id shift 86',0.00,2440964.40,210.00,2440964.40,0.00,'2022-11-27 15:52:56'),(113,'1','287',2,'Sale Id shift 87',0.00,120674.40,840.00,120674.40,0.00,'2022-11-28 12:07:39'),(114,'1','287',1,'Sale Id shift 87',0.00,2728733.70,210.00,2728733.70,0.00,'2022-11-28 12:07:39'),(115,'1','287',1,'Sale Id shift 88',0.00,1945051.50,210.00,1945051.50,0.00,'2022-11-28 15:00:41'),(116,'1','287',2,'Sale Id shift 89',0.00,1450554.00,840.00,1450554.00,0.00,'2022-11-29 11:16:25'),(117,'1','287',1,'Sale Id shift 89',0.00,1563464.70,210.00,1563464.70,0.00,'2022-11-29 11:16:25'),(118,'1','287',1,'Sale Id shift 90',0.00,799173.90,210.00,799173.90,0.00,'2022-11-29 16:54:09'),(119,'1','287',2,'Sale Id shift 91',0.00,445544.40,840.00,445544.40,0.00,'2022-11-30 11:34:56'),(120,'1','287',2,'Sale Id shift 92',0.00,737595.60,840.00,737595.60,0.00,'2022-12-02 10:19:52'),(121,'1','287',2,'Sale Id shift 93',0.00,739200.00,840.00,739200.00,0.00,'2022-12-03 21:44:47'),(122,'1','287',2,'Sale Id shift 94',0.00,984622.80,840.00,984622.80,0.00,'2022-12-04 12:08:42'),(123,'1','287',2,'Sale Id shift 95',0.00,299880.00,840.00,299880.00,0.00,'2022-12-15 21:51:11'),(124,'1','287',2,'Sale Id shift 96',0.00,235504.00,820.00,235504.00,0.00,'2022-12-18 14:24:55'),(125,'1','287',2,'Sale Id shift 97',0.00,410598.60,820.00,410598.60,0.00,'2022-12-21 08:00:29'),(126,'1','287',2,'Sale Id shift 98',0.00,290993.40,820.00,290993.40,0.00,'2022-12-21 08:33:09'),(127,'1','287',2,'Sale Id shift 99',0.00,531237.00,820.00,531237.00,0.00,'2022-12-29 09:24:42'),(128,'1','287',2,'Sale Id shift 100',0.00,1540480.00,830.00,1540480.00,0.00,'2023-01-20 09:18:05'),(129,'1','287',2,'Sale Id shift 101',0.00,900002.20,830.00,900002.20,0.00,'2023-01-27 09:51:58'),(130,'1','287',2,'Sale Id shift 102',0.00,437407.20,790.00,437407.20,0.00,'2023-02-01 14:34:43'),(131,'1','287',2,'Sale Id shift 103',0.00,171698.60,790.00,171698.60,0.00,'2023-02-06 11:19:36'),(132,'1','287',2,'Sale Id shift 104',0.00,250003.40,790.00,250003.40,0.00,'2023-02-06 16:57:27'),(133,'1','287',2,'Sale Id shift 105',0.00,148837.50,810.00,148837.50,0.00,'2023-02-08 08:08:28'),(134,'1','287',2,'Sale Id shift 106',0.00,48600.00,810.00,48600.00,0.00,'2023-02-11 15:04:45'),(135,'1','287',2,'Sale Id shift 107',0.00,388597.50,810.00,388597.50,0.00,'2023-02-16 09:18:13'),(136,'1','287',2,'Sale Id shift 108',0.00,545940.00,810.00,545940.00,0.00,'2023-03-03 09:57:05'),(137,'1','287',1,'Sale Id shift 108',0.00,2200725.65,235.00,2200725.65,0.00,'2023-03-03 09:57:05'),(138,'1','287',1,'Sale Id shift 109',0.00,2494781.15,235.00,2494781.15,0.00,'2023-03-04 11:28:51'),(139,'1','287',1,'Sale Id shift 110',0.00,1903697.40,235.00,1903697.40,0.00,'2023-03-06 23:22:14'),(140,'1','287',1,'Sale Id shift 111',0.00,3131783.90,235.00,3131783.90,0.00,'2023-03-07 11:31:06'),(141,'1','287',1,'Sale Id shift 112',0.00,1931288.75,235.00,1931288.75,0.00,'2023-03-08 09:46:03'),(142,'1','287',2,'Sale Id shift 113',0.00,400000.00,800.00,400000.00,0.00,'2023-03-09 10:17:48'),(143,'1','287',1,'Sale Id shift 113',0.00,2546037.00,235.00,2546037.00,0.00,'2023-03-09 10:17:48'),(144,'1','287',1,'Sale Id shift 114',0.00,2215723.35,235.00,2215723.35,0.00,'2023-03-10 09:30:19'),(145,'1','287',1,'Sale Id shift 115',0.00,2029142.75,235.00,2029142.75,0.00,'2023-03-11 17:03:13'),(146,'1','287',1,'Sale Id shift 116',0.00,3383654.55,235.00,3383654.55,0.00,'2023-03-12 21:55:31'),(147,'1','287',2,'Sale Id shift 117',0.00,118500.00,790.00,118500.00,0.00,'2023-03-14 08:27:28'),(148,'1','287',1,'Sale Id shift 117',0.00,2693750.95,235.00,2693750.95,0.00,'2023-03-14 08:27:28'),(149,'1','287',2,'Sale Id shift 118',0.00,395000.00,790.00,395000.00,0.00,'2023-03-15 18:09:27'),(150,'1','287',1,'Sale Id shift 118',0.00,2543663.50,235.00,2543663.50,0.00,'2023-03-15 18:09:27'),(151,'1','287',2,'Sale Id shift 119',0.00,316000.00,790.00,316000.00,0.00,'2023-03-16 09:08:02'),(152,'1','287',1,'Sale Id shift 119',0.00,2603651.95,235.00,2603651.95,0.00,'2023-03-16 09:08:02');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=647 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('1','287',1,'','24','1',0.00,9000000.00,'Purchase Id 1 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-10-27 11:18:29','',''),('1','287',2,'','supplier','1',9000000.00,0.00,'Purchase Id 1 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-10-27 11:18:29','',''),('1','287',3,'','24','1',0.00,15323000.00,'Purchase Id 4 for 19,900.00 litters of Diesel - AGO from AA RANO NIGERIA LTD','2022-10-28 07:08:49','',''),('1','287',4,'','supplier','1',15323000.00,0.00,'Purchase Id 4 for 19,900.00 litters of Diesel - AGO from AA RANO NIGERIA LTD','2022-10-28 07:08:49','',''),('1','287',5,'','24','1',0.00,9000000.00,'Purchase Id 3 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-10-28 07:09:10','',''),('1','287',6,'','supplier','1',9000000.00,0.00,'Purchase Id 3 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-10-28 07:09:10','',''),('1','287',7,'','24','1',0.00,9000000.00,'Purchase Id 2 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-10-28 07:09:30','',''),('1','287',8,'','supplier','1',9000000.00,0.00,'Purchase Id 2 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-10-28 07:09:30','',''),('1','287',9,'','supplier','1',0.00,9000000.00,'Purchase Id 3 for 50,000.00 litters of Petrol - PMS returned to AA RANO NIGERIA LTD','2022-10-28 07:11:04','',''),('1','287',10,'','20','3',0.00,0.00,'Sales from shift 1 on 2022-10-28 08:31:08 ','2022-10-28 08:31:08','',''),('1','287',11,'','6.1','4',0.00,0.00,'Sales from shift 1 on 2022-10-28 08:31:08 ','2022-10-28 08:31:08','',''),('1','287',12,'','20','3',0.00,0.00,'Sales from shift 2 on 2022-10-28 09:03:04 ','2022-10-28 09:03:04','',''),('1','287',13,'','6.1','4',0.00,0.00,'Sales from shift 2 on 2022-10-28 09:03:04 ','2022-10-28 09:03:04','',''),('1','287',14,'','20','3',592057.80,0.00,'Sales from shift 3 on 2022-10-28 09:13:13 ','2022-10-28 09:13:13','',''),('1','287',15,'','6.1','4',0.00,592057.80,'Sales from shift 3 on 2022-10-28 09:13:13 ','2022-10-28 09:13:13','',''),('1','287',16,'','20','3',1044462.60,0.00,'Sales from shift 4 on 2022-10-28 09:30:32 ','2022-10-28 09:30:32','',''),('1','287',17,'','6.1','4',0.00,1044462.60,'Sales from shift 4 on 2022-10-28 09:30:32 ','2022-10-28 09:30:32','',''),('1','287',18,'','20','3',809145.00,0.00,'Sales from shift 5 on 2022-10-29 08:34:54 ','2022-10-29 08:34:54','',''),('1','287',19,'','6.1','4',0.00,809145.00,'Sales from shift 5 on 2022-10-29 08:34:54 ','2022-10-29 08:34:54','',''),('1','287',20,'','20','3',723850.20,0.00,'Sales from shift 6 on 2022-10-29 09:17:35 ','2022-10-29 09:17:35','',''),('1','287',21,'','6.1','4',0.00,723850.20,'Sales from shift 6 on 2022-10-29 09:17:35 ','2022-10-29 09:17:35','',''),('1','287',22,'','20','3',647643.60,0.00,'Sales from shift 7 on 2022-10-29 09:33:52 ','2022-10-29 09:33:52','',''),('1','287',23,'','6.1','4',0.00,647643.60,'Sales from shift 7 on 2022-10-29 09:33:52 ','2022-10-29 09:33:52','',''),('1','287',24,'','20','3',492969.60,0.00,'Sales from shift 8 on 2022-10-29 10:27:34 ','2022-10-29 10:27:34','',''),('1','287',25,'','6.1','4',0.00,492969.60,'Sales from shift 8 on 2022-10-29 10:27:34 ','2022-10-29 10:27:34','',''),('1','287',26,'','20','3',671328.00,0.00,'Sales from shift 9 on 2022-10-29 10:55:36 ','2022-10-29 10:55:36','',''),('1','287',27,'','6.1','4',0.00,671328.00,'Sales from shift 9 on 2022-10-29 10:55:36 ','2022-10-29 10:55:36','',''),('1','287',28,'','20','3',692247.60,0.00,'Sales from shift 10 on 2022-10-29 11:17:27 ','2022-10-29 11:17:27','',''),('1','287',29,'','6.1','4',0.00,692247.60,'Sales from shift 10 on 2022-10-29 11:17:27 ','2022-10-29 11:17:27','',''),('1','287',30,'','20','3',580806.00,0.00,'Sales from shift 11 on 2022-10-30 11:13:03 ','2022-10-30 11:13:03','',''),('1','287',31,'','6.1','4',0.00,580806.00,'Sales from shift 11 on 2022-10-30 11:13:03 ','2022-10-30 11:13:03','',''),('1','287',32,'','20','3',646309.80,0.00,'Sales from shift 12 on 2022-10-30 11:33:23 ','2022-10-30 11:33:23','',''),('1','287',33,'','6.1','4',0.00,646309.80,'Sales from shift 12 on 2022-10-30 11:33:23 ','2022-10-30 11:33:23','',''),('1','287',34,'','20','3',649638.00,0.00,'Sales from shift 13 on 2022-10-30 13:01:58 ','2022-10-30 13:01:58','',''),('1','287',35,'','6.1','4',0.00,649638.00,'Sales from shift 13 on 2022-10-30 13:01:58 ','2022-10-30 13:01:58','',''),('1','287',36,'','20','3',597324.60,0.00,'Sales from shift 14 on 2022-10-30 14:23:09 ','2022-10-30 14:23:09','',''),('1','287',37,'','6.1','4',0.00,597324.60,'Sales from shift 14 on 2022-10-30 14:23:09 ','2022-10-30 14:23:09','',''),('1','287',38,'','20','3',390495.60,0.00,'Sales from shift 15 on 2022-10-30 23:07:04 ','2022-10-30 23:07:04','',''),('1','287',39,'','6.1','4',0.00,390495.60,'Sales from shift 15 on 2022-10-30 23:07:04 ','2022-10-30 23:07:04','',''),('1','287',40,'','20','3',207176.40,0.00,'Sales from shift 16 on 2022-11-01 09:09:19 ','2022-11-01 09:09:19','',''),('1','287',41,'','6.1','4',0.00,207176.40,'Sales from shift 16 on 2022-11-01 09:09:19 ','2022-11-01 09:09:19','',''),('1','287',42,'','20','3',690136.20,0.00,'Sales from shift 17 on 2022-11-01 18:06:41 ','2022-11-01 18:06:41','',''),('1','287',43,'','6.1','4',0.00,690136.20,'Sales from shift 17 on 2022-11-01 18:06:41 ','2022-11-01 18:06:41','',''),('1','287',44,'','20','3',605701.10,0.00,'Sales from shift 18 on 2022-11-01 20:44:44 ','2022-11-01 20:44:44','',''),('1','287',45,'','6.1','4',0.00,605701.10,'Sales from shift 18 on 2022-11-01 20:44:44 ','2022-11-01 20:44:44','',''),('1','287',46,'','20','3',531770.40,0.00,'Sales from shift 19 on 2022-11-02 18:58:52 ','2022-11-02 18:58:52','',''),('1','287',47,'','6.1','4',0.00,531770.40,'Sales from shift 19 on 2022-11-02 18:58:52 ','2022-11-02 18:58:52','',''),('1','287',48,'','24','1',0.00,9000000.00,'Purchase Id 5 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-02 18:59:22','',''),('1','287',49,'','supplier','1',9000000.00,0.00,'Purchase Id 5 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-02 18:59:22','',''),('1','287',50,'','24','1',0.00,9000000.00,'Purchase Id 8 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-02 19:00:10','',''),('1','287',51,'','supplier','1',9000000.00,0.00,'Purchase Id 8 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-02 19:00:10','',''),('1','287',52,'','24','1',0.00,9000000.00,'Purchase Id 7 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-02 19:01:14','',''),('1','287',53,'','supplier','1',9000000.00,0.00,'Purchase Id 7 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-02 19:01:14','',''),('1','287',54,'','24','1',0.00,9000000.00,'Purchase Id 6 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-02 19:03:57','',''),('1','287',55,'','supplier','1',9000000.00,0.00,'Purchase Id 6 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-02 19:03:57','',''),('1','287',56,'','20','3',417297.60,0.00,'Sales from shift 20 on 2022-11-03 07:44:23 ','2022-11-03 07:44:23','',''),('1','287',57,'','6.1','4',0.00,417297.60,'Sales from shift 20 on 2022-11-03 07:44:23 ','2022-11-03 07:44:23','',''),('1','287',58,'','20','3',458814.40,0.00,'Sales from shift 21 on 2022-11-03 09:03:40 ','2022-11-03 09:03:40','',''),('1','287',59,'','6.1','4',0.00,458814.40,'Sales from shift 21 on 2022-11-03 09:03:40 ','2022-11-03 09:03:40','',''),('1','287',60,'','20','3',546832.80,0.00,'Sales from shift 22 on 2022-11-03 14:01:16 ','2022-11-03 14:01:16','',''),('1','287',61,'','6.1','4',0.00,546832.80,'Sales from shift 22 on 2022-11-03 14:01:16 ','2022-11-03 14:01:16','',''),('1','287',62,'','20','3',485026.20,0.00,'Sales from shift 23 on 2022-11-06 11:16:15 ','2022-11-06 11:16:15','',''),('1','287',63,'','6.1','4',0.00,485026.20,'Sales from shift 23 on 2022-11-06 11:16:15 ','2022-11-06 11:16:15','',''),('1','287',64,'','20','3',778116.10,0.00,'Sales from shift 24 on 2022-11-06 14:21:24 ','2022-11-06 14:21:24','',''),('1','287',65,'','6.1','4',0.00,778116.10,'Sales from shift 24 on 2022-11-06 14:21:24 ','2022-11-06 14:21:24','',''),('1','287',66,'','20','3',530803.60,0.00,'Sales from shift 25 on 2022-11-06 20:48:04 ','2022-11-06 20:48:04','',''),('1','287',67,'','6.1','4',0.00,530803.60,'Sales from shift 25 on 2022-11-06 20:48:04 ','2022-11-06 20:48:04','',''),('1','287',68,'','20','3',552670.20,0.00,'Sales from shift 26 on 2022-11-06 20:56:22 ','2022-11-06 20:56:22','',''),('1','287',69,'','6.1','4',0.00,552670.20,'Sales from shift 26 on 2022-11-06 20:56:22 ','2022-11-06 20:56:22','',''),('1','287',70,'','20','3',513605.10,0.00,'Sales from shift 27 on 2022-11-06 21:04:08 ','2022-11-06 21:04:08','',''),('1','287',71,'','6.1','4',0.00,513605.10,'Sales from shift 27 on 2022-11-06 21:04:08 ','2022-11-06 21:04:08','',''),('1','287',72,'','20','3',0.00,0.00,'Sales from shift 28 on 2022-11-06 21:22:50 ','2022-11-06 21:22:50','',''),('1','287',73,'','6.1','4',0.00,0.00,'Sales from shift 28 on 2022-11-06 21:22:50 ','2022-11-06 21:22:50','',''),('1','287',74,'','20','3',480798.00,0.00,'Sales from shift 29 on 2022-11-07 08:21:44 ','2022-11-07 08:21:44','',''),('1','287',75,'','6.1','4',0.00,480798.00,'Sales from shift 29 on 2022-11-07 08:21:44 ','2022-11-07 08:21:44','',''),('1','287',76,'','20','3',271107.00,0.00,'Sales from shift 30 on 2022-11-08 13:03:37 ','2022-11-08 13:03:37','',''),('1','287',77,'','6.1','4',0.00,271107.00,'Sales from shift 30 on 2022-11-08 13:03:37 ','2022-11-08 13:03:37','',''),('1','287',78,'','20','3',623635.90,0.00,'Sales from shift 31 on 2022-11-08 16:46:02 ','2022-11-08 16:46:02','',''),('1','287',79,'','6.1','4',0.00,623635.90,'Sales from shift 31 on 2022-11-08 16:46:02 ','2022-11-08 16:46:02','',''),('1','287',80,'','20','3',306957.60,0.00,'Sales from shift 32 on 2022-11-09 19:25:04 ','2022-11-09 19:25:04','',''),('1','287',81,'','6.1','4',0.00,306957.60,'Sales from shift 32 on 2022-11-09 19:25:04 ','2022-11-09 19:25:04','',''),('1','287',82,'','20','3',620698.10,0.00,'Sales from shift 33 on 2022-11-10 10:21:59 ','2022-11-10 10:21:59','',''),('1','287',83,'','6.1','4',0.00,620698.10,'Sales from shift 33 on 2022-11-10 10:21:59 ','2022-11-10 10:21:59','',''),('1','287',84,'','20','3',472718.00,0.00,'Sales from shift 34 on 2022-11-10 10:30:38 ','2022-11-10 10:30:38','',''),('1','287',85,'','6.1','4',0.00,472718.00,'Sales from shift 34 on 2022-11-10 10:30:38 ','2022-11-10 10:30:38','',''),('1','287',86,'','20','3',589168.80,0.00,'Sales from shift 35 on 2022-11-10 12:57:44 ','2022-11-10 12:57:44','',''),('1','287',87,'','6.1','4',0.00,589168.80,'Sales from shift 35 on 2022-11-10 12:57:44 ','2022-11-10 12:57:44','',''),('1','287',88,'','20','3',423387.00,0.00,'Sales from shift 36 on 2022-11-10 14:26:41 ','2022-11-10 14:26:41','',''),('1','287',89,'','6.1','4',0.00,423387.00,'Sales from shift 36 on 2022-11-10 14:26:41 ','2022-11-10 14:26:41','',''),('1','287',90,'','20','3',747431.80,0.00,'Sales from shift 37 on 2022-11-10 15:52:24 ','2022-11-10 15:52:24','',''),('1','287',91,'','6.1','4',0.00,747431.80,'Sales from shift 37 on 2022-11-10 15:52:24 ','2022-11-10 15:52:24','',''),('1','287',92,'','20','3',523011.40,0.00,'Sales from shift 38 on 2022-11-10 16:11:28 ','2022-11-10 16:11:28','',''),('1','287',93,'','6.1','4',0.00,523011.40,'Sales from shift 38 on 2022-11-10 16:11:28 ','2022-11-10 16:11:28','',''),('1','287',94,'','20','3',708327.00,0.00,'Sales from shift 39 on 2022-11-10 16:29:27 ','2022-11-10 16:29:27','',''),('1','287',95,'','6.1','4',0.00,708327.00,'Sales from shift 39 on 2022-11-10 16:29:27 ','2022-11-10 16:29:27','',''),('1','287',96,'','20','3',618175.20,0.00,'Sales from shift 40 on 2022-11-10 16:46:32 ','2022-11-10 16:46:32','',''),('1','287',97,'','6.1','4',0.00,618175.20,'Sales from shift 40 on 2022-11-10 16:46:32 ','2022-11-10 16:46:32','',''),('1','287',98,'','20','3',706917.00,0.00,'Sales from shift 41 on 2022-11-10 17:07:49 ','2022-11-10 17:07:49','',''),('1','287',99,'','6.1','4',0.00,706917.00,'Sales from shift 41 on 2022-11-10 17:07:49 ','2022-11-10 17:07:49','',''),('1','287',100,'','20','3',565960.00,0.00,'Sales from shift 42 on 2022-11-10 17:37:42 ','2022-11-10 17:37:42','',''),('1','287',101,'','6.1','4',0.00,565960.00,'Sales from shift 42 on 2022-11-10 17:37:42 ','2022-11-10 17:37:42','',''),('1','287',102,'','20','3',784515.20,0.00,'Sales from shift 43 on 2022-11-10 18:10:06 ','2022-11-10 18:10:06','',''),('1','287',103,'','6.1','4',0.00,784515.20,'Sales from shift 43 on 2022-11-10 18:10:06 ','2022-11-10 18:10:06','',''),('1','287',104,'','20','3',942091.60,0.00,'Sales from shift 44 on 2022-11-11 01:58:03 ','2022-11-11 01:58:03','',''),('1','287',105,'','6.1','4',0.00,942091.60,'Sales from shift 44 on 2022-11-11 01:58:03 ','2022-11-11 01:58:03','',''),('1','287',106,'','20','3',0.00,0.00,'Sales from shift 45 on 2022-11-11 10:36:44 ','2022-11-11 10:36:44','',''),('1','287',107,'','6.1','4',0.00,0.00,'Sales from shift 45 on 2022-11-11 10:36:44 ','2022-11-11 10:36:44','',''),('1','287',108,'','20','3',1315629.00,0.00,'Sales from shift 46 on 2022-11-11 12:41:46 ','2022-11-11 12:41:46','',''),('1','287',109,'','6.1','4',0.00,1315629.00,'Sales from shift 46 on 2022-11-11 12:41:46 ','2022-11-11 12:41:46','',''),('1','287',110,'','20','3',545770.40,0.00,'Sales from shift 47 on 2022-11-11 12:51:53 ','2022-11-11 12:51:53','',''),('1','287',111,'','6.1','4',0.00,545770.40,'Sales from shift 47 on 2022-11-11 12:51:53 ','2022-11-11 12:51:53','',''),('1','287',112,'','20','3',1118475.00,0.00,'Sales from shift 48 on 2022-11-11 13:14:01 ','2022-11-11 13:14:01','',''),('1','287',113,'','6.1','4',0.00,1118475.00,'Sales from shift 48 on 2022-11-11 13:14:01 ','2022-11-11 13:14:01','',''),('1','287',114,'','20','3',197573.40,0.00,'Sales from shift 49 on 2022-11-11 15:02:13 ','2022-11-11 15:02:13','',''),('1','287',115,'','6.1','4',0.00,197573.40,'Sales from shift 49 on 2022-11-11 15:02:13 ','2022-11-11 15:02:13','',''),('1','287',116,'','20','3',0.00,0.00,'Sales from shift 50 on 2022-11-11 15:27:46 ','2022-11-11 15:27:46','',''),('1','287',117,'','6.1','4',0.00,0.00,'Sales from shift 50 on 2022-11-11 15:27:46 ','2022-11-11 15:27:46','',''),('1','287',118,'','20','3',1840743.00,0.00,'Sales from shift 51 on 2022-11-11 15:37:40 ','2022-11-11 15:37:40','',''),('1','287',119,'','6.1','4',0.00,1840743.00,'Sales from shift 51 on 2022-11-11 15:37:40 ','2022-11-11 15:37:40','',''),('1','287',120,'','20','3',1165493.60,0.00,'Sales from shift 52 on 2022-11-11 16:03:16 ','2022-11-11 16:03:16','',''),('1','287',121,'','6.1','4',0.00,1165493.60,'Sales from shift 52 on 2022-11-11 16:03:16 ','2022-11-11 16:03:16','',''),('1','287',122,'','20','3',1060119.00,0.00,'Sales from shift 53 on 2022-11-11 16:14:59 ','2022-11-11 16:14:59','',''),('1','287',123,'','6.1','4',0.00,1060119.00,'Sales from shift 53 on 2022-11-11 16:14:59 ','2022-11-11 16:14:59','',''),('1','287',124,'','20','3',1798374.00,0.00,'Sales from shift 54 on 2022-11-11 16:24:55 ','2022-11-11 16:24:55','',''),('1','287',125,'','6.1','4',0.00,1798374.00,'Sales from shift 54 on 2022-11-11 16:24:55 ','2022-11-11 16:24:55','',''),('1','287',126,'','20','3',1106454.60,0.00,'Sales from shift 55 on 2022-11-11 16:41:28 ','2022-11-11 16:41:28','',''),('1','287',127,'','6.1','4',0.00,1106454.60,'Sales from shift 55 on 2022-11-11 16:41:28 ','2022-11-11 16:41:28','',''),('1','287',128,'','20','3',1018712.40,0.00,'Sales from shift 56 on 2022-11-11 16:57:13 ','2022-11-11 16:57:13','',''),('1','287',129,'','6.1','4',0.00,1018712.40,'Sales from shift 56 on 2022-11-11 16:57:13 ','2022-11-11 16:57:13','',''),('1','287',130,'','20','3',1390849.20,0.00,'Sales from shift 57 on 2022-11-12 08:12:44 ','2022-11-12 08:12:44','',''),('1','287',131,'','6.1','4',0.00,1390849.20,'Sales from shift 57 on 2022-11-12 08:12:44 ','2022-11-12 08:12:44','',''),('1','287',132,'','20','3',1089337.20,0.00,'Sales from shift 58 on 2022-11-12 09:02:47 ','2022-11-12 09:02:47','',''),('1','287',133,'','6.1','4',0.00,1089337.20,'Sales from shift 58 on 2022-11-12 09:02:47 ','2022-11-12 09:02:47','',''),('1','287',134,'','20','3',1245926.72,0.00,'Sales from shift 59 on 2022-11-12 10:25:51 ','2022-11-12 10:25:51','',''),('1','287',135,'','6.1','4',0.00,1245926.72,'Sales from shift 59 on 2022-11-12 10:25:51 ','2022-11-12 10:25:51','',''),('1','287',136,'','20','3',1057497.00,0.00,'Sales from shift 60 on 2022-11-12 10:38:16 ','2022-11-12 10:38:16','',''),('1','287',137,'','6.1','4',0.00,1057497.00,'Sales from shift 60 on 2022-11-12 10:38:16 ','2022-11-12 10:38:16','',''),('1','287',138,'','20','3',1310617.80,0.00,'Sales from shift 61 on 2022-11-12 10:48:17 ','2022-11-12 10:48:17','',''),('1','287',139,'','6.1','4',0.00,1310617.80,'Sales from shift 61 on 2022-11-12 10:48:17 ','2022-11-12 10:48:17','',''),('1','287',140,'','20','3',1130013.60,0.00,'Sales from shift 62 on 2022-11-12 11:00:46 ','2022-11-12 11:00:46','',''),('1','287',141,'','6.1','4',0.00,1130013.60,'Sales from shift 62 on 2022-11-12 11:00:46 ','2022-11-12 11:00:46','',''),('1','287',142,'','20','3',0.00,0.00,'Sales from shift 63 on 2022-11-12 11:13:52 ','2022-11-12 11:13:52','',''),('1','287',143,'','6.1','4',0.00,0.00,'Sales from shift 63 on 2022-11-12 11:13:52 ','2022-11-12 11:13:52','',''),('1','287',144,'','20','3',1900447.20,0.00,'Sales from shift 64 on 2022-11-12 11:31:22 ','2022-11-12 11:31:22','',''),('1','287',145,'','6.1','4',0.00,1900447.20,'Sales from shift 64 on 2022-11-12 11:31:22 ','2022-11-12 11:31:22','',''),('1','287',146,'','20','3',1204751.40,0.00,'Sales from shift 65 on 2022-11-12 11:52:24 ','2022-11-12 11:52:24','',''),('1','287',147,'','6.1','4',0.00,1204751.40,'Sales from shift 65 on 2022-11-12 11:52:24 ','2022-11-12 11:52:24','',''),('1','287',148,'','20','3',1407256.20,0.00,'Sales from shift 66 on 2022-11-12 12:02:44 ','2022-11-12 12:02:44','',''),('1','287',149,'','6.1','4',0.00,1407256.20,'Sales from shift 66 on 2022-11-12 12:02:44 ','2022-11-12 12:02:44','',''),('1','287',150,'','20','3',1418584.40,0.00,'Sales from shift 67 on 2022-11-12 12:23:33 ','2022-11-12 12:23:33','',''),('1','287',151,'','6.1','4',0.00,1418584.40,'Sales from shift 67 on 2022-11-12 12:23:33 ','2022-11-12 12:23:33','',''),('1','287',152,'','20','3',1212283.80,0.00,'Sales from shift 68 on 2022-11-12 12:31:20 ','2022-11-12 12:31:20','',''),('1','287',153,'','6.1','4',0.00,1212283.80,'Sales from shift 68 on 2022-11-12 12:31:20 ','2022-11-12 12:31:20','',''),('1','287',154,'','20','3',956162.40,0.00,'Sales from shift 69 on 2022-11-13 06:26:57 ','2022-11-13 06:26:57','',''),('1','287',155,'','6.1','4',0.00,956162.40,'Sales from shift 69 on 2022-11-13 06:26:57 ','2022-11-13 06:26:57','',''),('1','287',156,'','20','3',1038794.40,0.00,'Sales from shift 70 on 2022-11-14 10:13:20 ','2022-11-14 10:13:20','',''),('1','287',157,'','6.1','4',0.00,1038794.40,'Sales from shift 70 on 2022-11-14 10:13:20 ','2022-11-14 10:13:20','',''),('1','287',158,'','20','3',739370.40,0.00,'Sales from shift 71 on 2022-11-14 10:22:12 ','2022-11-14 10:22:12','',''),('1','287',159,'','6.1','4',0.00,739370.40,'Sales from shift 71 on 2022-11-14 10:22:12 ','2022-11-14 10:22:12','',''),('1','287',160,'','20','3',958867.20,0.00,'Sales from shift 72 on 2022-11-14 10:29:13 ','2022-11-14 10:29:13','',''),('1','287',161,'','6.1','4',0.00,958867.20,'Sales from shift 72 on 2022-11-14 10:29:13 ','2022-11-14 10:29:13','',''),('1','287',162,'','20','3',725949.60,0.00,'Sales from shift 73 on 2022-11-14 10:39:51 ','2022-11-14 10:39:51','',''),('1','287',163,'','6.1','4',0.00,725949.60,'Sales from shift 73 on 2022-11-14 10:39:51 ','2022-11-14 10:39:51','',''),('1','287',164,'','20','3',722791.80,0.00,'Sales from shift 74 on 2022-11-14 10:46:43 ','2022-11-14 10:46:43','',''),('1','287',165,'','6.1','4',0.00,722791.80,'Sales from shift 74 on 2022-11-14 10:46:43 ','2022-11-14 10:46:43','',''),('1','287',166,'','20','3',592474.20,0.00,'Sales from shift 75 on 2022-11-14 11:14:02 ','2022-11-14 11:14:02','',''),('1','287',167,'','6.1','4',0.00,592474.20,'Sales from shift 75 on 2022-11-14 11:14:02 ','2022-11-14 11:14:02','',''),('1','287',168,'','2','6',381845.00,0.00,'Payment Id 39 for invoice:13/14, receipt: 013/14 by AA RANO NIGERIA LTD','2022-11-19 14:27:33','',''),('1','287',169,'','supplier','1',0.00,381845.00,'Payment Id 39 for invoice:13/14, receipt: 013/14 by AA RANO NIGERIA LTD','2022-11-19 14:27:33','',''),('1','287',170,'','2','5',303900.00,0.00,'Payment Id 27 for invoice:14, receipt: 0014 by AA RANO NIGERIA LTD','2022-11-19 14:27:33','',''),('1','287',171,'','supplier','1',0.00,303900.00,'Payment Id 27 for invoice:14, receipt: 0014 by AA RANO NIGERIA LTD','2022-11-19 14:27:33','',''),('1','287',172,'','2','5',434690.00,0.00,'Payment Id 26 for invoice:13, receipt: 0013 by AA RANO NIGERIA LTD','2022-11-19 14:27:33','',''),('1','287',173,'','supplier','1',0.00,434690.00,'Payment Id 26 for invoice:13, receipt: 0013 by AA RANO NIGERIA LTD','2022-11-19 14:27:33','',''),('1','287',174,'','2','6',138290.00,0.00,'Payment Id 43 for invoice:20, receipt: 020 by AA RANO NIGERIA LTD','2022-11-19 14:53:41','',''),('1','287',175,'','supplier','1',0.00,138290.00,'Payment Id 43 for invoice:20, receipt: 020 by AA RANO NIGERIA LTD','2022-11-19 14:53:41','',''),('1','287',176,'','2','5',269700.00,0.00,'Payment Id 29 for invoice:20, receipt: 0020 by AA RANO NIGERIA LTD','2022-11-19 14:53:41','',''),('1','287',177,'','supplier','1',0.00,269700.00,'Payment Id 29 for invoice:20, receipt: 0020 by AA RANO NIGERIA LTD','2022-11-19 14:53:41','',''),('1','287',178,'','2','6',461179.00,0.00,'Payment Id 44 for invoice:21/22, receipt: 021/22 by AA RANO NIGERIA LTD','2022-11-19 14:57:33','',''),('1','287',179,'','supplier','1',0.00,461179.00,'Payment Id 44 for invoice:21/22, receipt: 021/22 by AA RANO NIGERIA LTD','2022-11-19 14:57:33','',''),('1','287',180,'','2','5',357480.00,0.00,'Payment Id 31 for invoice:22, receipt: 00022 by AA RANO NIGERIA LTD','2022-11-19 14:57:33','',''),('1','287',181,'','supplier','1',0.00,357480.00,'Payment Id 31 for invoice:22, receipt: 00022 by AA RANO NIGERIA LTD','2022-11-19 14:57:33','',''),('1','287',182,'','2','5',141700.00,0.00,'Payment Id 30 for invoice:21, receipt: 00021 by AA RANO NIGERIA LTD','2022-11-19 14:57:33','',''),('1','287',183,'','supplier','1',0.00,141700.00,'Payment Id 30 for invoice:21, receipt: 00021 by AA RANO NIGERIA LTD','2022-11-19 14:57:33','',''),('1','287',184,'','2','6',510310.00,0.00,'Payment Id 46 for invoice:23/24, receipt: 023/24 by AA RANO NIGERIA LTD','2022-11-19 15:00:28','',''),('1','287',185,'','supplier','1',0.00,510310.00,'Payment Id 46 for invoice:23/24, receipt: 023/24 by AA RANO NIGERIA LTD','2022-11-19 15:00:28','',''),('1','287',186,'','2','5',363350.00,0.00,'Payment Id 45 for invoice:24, receipt: 024 by AA RANO NIGERIA LTD','2022-11-19 15:00:28','',''),('1','287',187,'','supplier','1',0.00,363350.00,'Payment Id 45 for invoice:24, receipt: 024 by AA RANO NIGERIA LTD','2022-11-19 15:00:28','',''),('1','287',188,'','2','5',222720.00,0.00,'Payment Id 32 for invoice:23, receipt: 00023 by AA RANO NIGERIA LTD','2022-11-19 15:00:28','',''),('1','287',189,'','supplier','1',0.00,222720.00,'Payment Id 32 for invoice:23, receipt: 00023 by AA RANO NIGERIA LTD','2022-11-19 15:00:28','',''),('1','287',190,'','2','6',392420.00,0.00,'Payment Id 49 for invoice:25/26, receipt: 025/26 by AA RANO NIGERIA LTD','2022-11-19 15:09:04','',''),('1','287',191,'','supplier','1',0.00,392420.00,'Payment Id 49 for invoice:25/26, receipt: 025/26 by AA RANO NIGERIA LTD','2022-11-19 15:09:04','',''),('1','287',192,'','2','5',303310.00,0.00,'Payment Id 48 for invoice:26, receipt: 026 by AA RANO NIGERIA LTD','2022-11-19 15:09:04','',''),('1','287',193,'','supplier','1',0.00,303310.00,'Payment Id 48 for invoice:26, receipt: 026 by AA RANO NIGERIA LTD','2022-11-19 15:09:04','',''),('1','287',194,'','2','5',273795.00,0.00,'Payment Id 47 for invoice:25, receipt: 025 by AA RANO NIGERIA LTD','2022-11-19 15:09:04','',''),('1','287',195,'','supplier','1',0.00,273795.00,'Payment Id 47 for invoice:25, receipt: 025 by AA RANO NIGERIA LTD','2022-11-19 15:09:04','',''),('1','287',196,'','2','6',356644.00,0.00,'Payment Id 52 for invoice:27/29, receipt: 027/29 by AA RANO NIGERIA LTD','2022-11-19 15:11:32','',''),('1','287',197,'','supplier','1',0.00,356644.00,'Payment Id 52 for invoice:27/29, receipt: 027/29 by AA RANO NIGERIA LTD','2022-11-19 15:11:32','',''),('1','287',198,'','2','5',264250.00,0.00,'Payment Id 51 for invoice:29, receipt: 029 by AA RANO NIGERIA LTD','2022-11-19 15:11:32','',''),('1','287',199,'','supplier','1',0.00,264250.00,'Payment Id 51 for invoice:29, receipt: 029 by AA RANO NIGERIA LTD','2022-11-19 15:11:32','',''),('1','287',200,'','2','5',335050.00,0.00,'Payment Id 50 for invoice:27, receipt: 027 by AA RANO NIGERIA LTD','2022-11-19 15:11:32','',''),('1','287',201,'','supplier','1',0.00,335050.00,'Payment Id 50 for invoice:27, receipt: 027 by AA RANO NIGERIA LTD','2022-11-19 15:11:32','',''),('1','287',202,'','2','6',362077.00,0.00,'Payment Id 55 for invoice:30/31, receipt: 030/31 by AA RANO NIGERIA LTD','2022-11-19 15:14:59','',''),('1','287',203,'','supplier','1',0.00,362077.00,'Payment Id 55 for invoice:30/31, receipt: 030/31 by AA RANO NIGERIA LTD','2022-11-19 15:14:59','',''),('1','287',204,'','2','5',265210.00,0.00,'Payment Id 54 for invoice:31, receipt: 031 by AA RANO NIGERIA LTD','2022-11-19 15:14:59','',''),('1','287',205,'','supplier','1',0.00,265210.00,'Payment Id 54 for invoice:31, receipt: 031 by AA RANO NIGERIA LTD','2022-11-19 15:14:59','',''),('1','287',206,'','2','5',209300.00,0.00,'Payment Id 53 for invoice:30, receipt: 030 by AA RANO NIGERIA LTD','2022-11-19 15:14:59','',''),('1','287',207,'','supplier','1',0.00,209300.00,'Payment Id 53 for invoice:30, receipt: 030 by AA RANO NIGERIA LTD','2022-11-19 15:14:59','',''),('1','287',208,'','2','6',350840.00,0.00,'Payment Id 58 for invoice:32/33, receipt: 032/33 by AA RANO NIGERIA LTD','2022-11-19 15:15:46','',''),('1','287',209,'','supplier','1',0.00,350840.00,'Payment Id 58 for invoice:32/33, receipt: 032/33 by AA RANO NIGERIA LTD','2022-11-19 15:15:46','',''),('1','287',210,'','2','5',363060.00,0.00,'Payment Id 57 for invoice:33, receipt: 033 by AA RANO NIGERIA LTD','2022-11-19 15:15:46','',''),('1','287',211,'','supplier','1',0.00,363060.00,'Payment Id 57 for invoice:33, receipt: 033 by AA RANO NIGERIA LTD','2022-11-19 15:15:46','',''),('1','287',212,'','2','5',175260.00,0.00,'Payment Id 56 for invoice:32, receipt: 032 by AA RANO NIGERIA LTD','2022-11-19 15:15:46','',''),('1','287',213,'','supplier','1',0.00,175260.00,'Payment Id 56 for invoice:32, receipt: 032 by AA RANO NIGERIA LTD','2022-11-19 15:15:46','',''),('1','287',214,'','2','6',328987.00,0.00,'Payment Id 61 for invoice:34/35, receipt: 034/35 by AA RANO NIGERIA LTD','2022-11-19 15:16:41','',''),('1','287',215,'','supplier','1',0.00,328987.00,'Payment Id 61 for invoice:34/35, receipt: 034/35 by AA RANO NIGERIA LTD','2022-11-19 15:16:41','',''),('1','287',216,'','2','5',400100.00,0.00,'Payment Id 60 for invoice:35, receipt: 035 by AA RANO NIGERIA LTD','2022-11-19 15:16:41','',''),('1','287',217,'','supplier','1',0.00,400100.00,'Payment Id 60 for invoice:35, receipt: 035 by AA RANO NIGERIA LTD','2022-11-19 15:16:41','',''),('1','287',218,'','2','5',299200.00,0.00,'Payment Id 59 for invoice:34, receipt: 034 by AA RANO NIGERIA LTD','2022-11-19 15:16:41','',''),('1','287',219,'','supplier','1',0.00,299200.00,'Payment Id 59 for invoice:34, receipt: 034 by AA RANO NIGERIA LTD','2022-11-19 15:16:41','',''),('1','287',220,'','2','6',419377.00,0.00,'Payment Id 64 for invoice:36/37, receipt: 036/37 by AA RANO NIGERIA LTD','2022-11-19 15:17:25','',''),('1','287',221,'','supplier','1',0.00,419377.00,'Payment Id 64 for invoice:36/37, receipt: 036/37 by AA RANO NIGERIA LTD','2022-11-19 15:17:25','',''),('1','287',222,'','2','5',432900.00,0.00,'Payment Id 63 for invoice:37, receipt: 037 by AA RANO NIGERIA LTD','2022-11-19 15:17:25','',''),('1','287',223,'','supplier','1',0.00,432900.00,'Payment Id 63 for invoice:37, receipt: 037 by AA RANO NIGERIA LTD','2022-11-19 15:17:25','',''),('1','287',224,'','2','5',276860.00,0.00,'Payment Id 62 for invoice:36, receipt: 036 by AA RANO NIGERIA LTD','2022-11-19 15:17:25','',''),('1','287',225,'','supplier','1',0.00,276860.00,'Payment Id 62 for invoice:36, receipt: 036 by AA RANO NIGERIA LTD','2022-11-19 15:17:25','',''),('1','287',226,'','2','5',393654.00,0.00,'Payment Id 67 for invoice:38/39, receipt: 038/39 by AA RANO NIGERIA LTD','2022-11-19 15:18:13','',''),('1','287',227,'','supplier','1',0.00,393654.00,'Payment Id 67 for invoice:38/39, receipt: 038/39 by AA RANO NIGERIA LTD','2022-11-19 15:18:13','',''),('1','287',228,'','2','5',447770.00,0.00,'Payment Id 66 for invoice:39, receipt: 039 by AA RANO NIGERIA LTD','2022-11-19 15:18:13','',''),('1','287',229,'','supplier','1',0.00,447770.00,'Payment Id 66 for invoice:39, receipt: 039 by AA RANO NIGERIA LTD','2022-11-19 15:18:13','',''),('1','287',230,'','2','5',235420.00,0.00,'Payment Id 65 for invoice:38, receipt: 038 by AA RANO NIGERIA LTD','2022-11-19 15:18:13','',''),('1','287',231,'','supplier','1',0.00,235420.00,'Payment Id 65 for invoice:38, receipt: 038 by AA RANO NIGERIA LTD','2022-11-19 15:18:13','',''),('1','287',232,'','2','6',517250.00,0.00,'Payment Id 73 for invoice:42/43, receipt: 042/43 by AA RANO NIGERIA LTD','2022-11-19 15:19:58','',''),('1','287',233,'','supplier','1',0.00,517250.00,'Payment Id 73 for invoice:42/43, receipt: 042/43 by AA RANO NIGERIA LTD','2022-11-19 15:19:58','',''),('1','287',234,'','2','5',477800.00,0.00,'Payment Id 72 for invoice:43, receipt: 043 by AA RANO NIGERIA LTD','2022-11-19 15:19:58','',''),('1','287',235,'','supplier','1',0.00,477800.00,'Payment Id 72 for invoice:43, receipt: 043 by AA RANO NIGERIA LTD','2022-11-19 15:19:58','',''),('1','287',236,'','2','5',315360.00,0.00,'Payment Id 71 for invoice:42, receipt: 042 by AA RANO NIGERIA LTD','2022-11-19 15:19:58','',''),('1','287',237,'','supplier','1',0.00,315360.00,'Payment Id 71 for invoice:42, receipt: 042 by AA RANO NIGERIA LTD','2022-11-19 15:19:58','',''),('1','287',238,'','2','6',904558.17,0.00,'Payment Id 76 for invoice:44/46, receipt: 044/46 by AA RANO NIGERIA LTD','2022-11-19 15:20:57','',''),('1','287',239,'','supplier','1',0.00,904558.17,'Payment Id 76 for invoice:44/46, receipt: 044/46 by AA RANO NIGERIA LTD','2022-11-19 15:20:57','',''),('1','287',240,'','2','5',806740.00,0.00,'Payment Id 75 for invoice:46, receipt: 046 by AA RANO NIGERIA LTD','2022-11-19 15:20:57','',''),('1','287',241,'','supplier','1',0.00,806740.00,'Payment Id 75 for invoice:46, receipt: 046 by AA RANO NIGERIA LTD','2022-11-19 15:20:57','',''),('1','287',242,'','2','5',504360.00,0.00,'Payment Id 74 for invoice:44, receipt: 044 by AA RANO NIGERIA LTD','2022-11-19 15:20:57','',''),('1','287',243,'','supplier','1',0.00,504360.00,'Payment Id 74 for invoice:44, receipt: 044 by AA RANO NIGERIA LTD','2022-11-19 15:20:57','',''),('1','287',244,'','2','6',596952.00,0.00,'Payment Id 79 for invoice:47/48, receipt: 047/48 by AA RANO NIGERIA LTD','2022-11-19 15:25:16','',''),('1','287',245,'','supplier','1',0.00,596952.00,'Payment Id 79 for invoice:47/48, receipt: 047/48 by AA RANO NIGERIA LTD','2022-11-19 15:25:16','',''),('1','287',246,'','2','5',696015.00,0.00,'Payment Id 78 for invoice:48, receipt: 048 by AA RANO NIGERIA LTD','2022-11-19 15:25:16','',''),('1','287',247,'','supplier','1',0.00,696015.00,'Payment Id 78 for invoice:48, receipt: 048 by AA RANO NIGERIA LTD','2022-11-19 15:25:16','',''),('1','287',248,'','2','5',326275.00,0.00,'Payment Id 77 for invoice:47, receipt: 047 by AA RANO NIGERIA LTD','2022-11-19 15:25:16','',''),('1','287',249,'','supplier','1',0.00,326275.00,'Payment Id 77 for invoice:47, receipt: 047 by AA RANO NIGERIA LTD','2022-11-19 15:25:16','',''),('1','287',250,'','2','6',938701.00,0.00,'Payment Id 82 for invoice:49/51, receipt: 049/51 by AA RANO NIGERIA LTD','2022-11-19 15:29:40','',''),('1','287',251,'','supplier','1',0.00,938701.00,'Payment Id 82 for invoice:49/51, receipt: 049/51 by AA RANO NIGERIA LTD','2022-11-19 15:29:40','',''),('1','287',252,'','2','5',913925.00,0.00,'Payment Id 81 for invoice:51, receipt: 051 by AA RANO NIGERIA LTD','2022-11-19 15:29:40','',''),('1','287',253,'','supplier','1',0.00,913925.00,'Payment Id 81 for invoice:51, receipt: 051 by AA RANO NIGERIA LTD','2022-11-19 15:29:40','',''),('1','287',254,'','2','5',68570.00,0.00,'Payment Id 80 for invoice:49, receipt: 049 by AA RANO NIGERIA LTD','2022-11-19 15:29:40','',''),('1','287',255,'','supplier','1',0.00,68570.00,'Payment Id 80 for invoice:49, receipt: 049 by AA RANO NIGERIA LTD','2022-11-19 15:29:40','',''),('1','287',256,'','2','6',944397.00,0.00,'Payment Id 85 for invoice:52/53, receipt: 052/53 by AA RANO NIGERIA LTD','2022-11-19 15:30:24','',''),('1','287',257,'','supplier','1',0.00,944397.00,'Payment Id 85 for invoice:52/53, receipt: 052/53 by AA RANO NIGERIA LTD','2022-11-19 15:30:24','',''),('1','287',258,'','2','5',666390.00,0.00,'Payment Id 84 for invoice:53, receipt: 053 by AA RANO NIGERIA LTD','2022-11-19 15:30:24','',''),('1','287',259,'','supplier','1',0.00,666390.00,'Payment Id 84 for invoice:53, receipt: 053 by AA RANO NIGERIA LTD','2022-11-19 15:30:24','',''),('1','287',260,'','2','5',576930.00,0.00,'Payment Id 83 for invoice:52, receipt: 052 by AA RANO NIGERIA LTD','2022-11-19 15:30:24','',''),('1','287',261,'','supplier','1',0.00,576930.00,'Payment Id 83 for invoice:52, receipt: 052 by AA RANO NIGERIA LTD','2022-11-19 15:30:24','',''),('1','287',262,'','2','6',738726.00,0.00,'Payment Id 89 for invoice:54/55, receipt: 054/55 by AA RANO NIGERIA LTD','2022-11-19 15:31:27','',''),('1','287',263,'','supplier','1',0.00,738726.00,'Payment Id 89 for invoice:54/55, receipt: 054/55 by AA RANO NIGERIA LTD','2022-11-19 15:31:27','',''),('1','287',264,'','2','5',705080.00,0.00,'Payment Id 88 for invoice:55, receipt: 055 by AA RANO NIGERIA LTD','2022-11-19 15:31:27','',''),('1','287',265,'','supplier','1',0.00,705080.00,'Payment Id 88 for invoice:55, receipt: 055 by AA RANO NIGERIA LTD','2022-11-19 15:31:27','',''),('1','287',266,'','6.1','4',618000.00,0.00,'Payment Id 87 for invoice:54, receipt: 054 by AA RANO NIGERIA LTD','2022-11-19 15:31:27','',''),('1','287',267,'','supplier','1',0.00,618000.00,'Payment Id 87 for invoice:54, receipt: 054 by AA RANO NIGERIA LTD','2022-11-19 15:31:27','',''),('1','287',268,'','2','5',814300.00,0.00,'Payment Id 86 for invoice:54, receipt: 054 by AA RANO NIGERIA LTD','2022-11-19 15:31:27','',''),('1','287',269,'','supplier','1',0.00,814300.00,'Payment Id 86 for invoice:54, receipt: 054 by AA RANO NIGERIA LTD','2022-11-19 15:31:27','',''),('1','287',270,'','2','5',902675.00,0.00,'Payment Id 91 for invoice:57, receipt: 057 by AA RANO NIGERIA LTD','2022-11-19 15:32:15','',''),('1','287',271,'','supplier','1',0.00,902675.00,'Payment Id 91 for invoice:57, receipt: 057 by AA RANO NIGERIA LTD','2022-11-19 15:32:15','',''),('1','287',272,'','2','5',470585.00,0.00,'Payment Id 90 for invoice:56, receipt: 056 by AA RANO NIGERIA LTD','2022-11-19 15:32:15','',''),('1','287',273,'','supplier','1',0.00,470585.00,'Payment Id 90 for invoice:56, receipt: 056 by AA RANO NIGERIA LTD','2022-11-19 15:32:15','',''),('1','287',274,'','2','6',751586.00,0.00,'Payment Id 94 for invoice:58/59, receipt: 058/59 by AA RANO NIGERIA LTD','2022-11-19 15:34:56','',''),('1','287',275,'','supplier','1',0.00,751586.00,'Payment Id 94 for invoice:58/59, receipt: 058/59 by AA RANO NIGERIA LTD','2022-11-19 15:34:56','',''),('1','287',276,'','2','5',816040.00,0.00,'Payment Id 93 for invoice:59, receipt: 059 by AA RANO NIGERIA LTD','2022-11-19 15:34:56','',''),('1','287',277,'','supplier','1',0.00,816040.00,'Payment Id 93 for invoice:59, receipt: 059 by AA RANO NIGERIA LTD','2022-11-19 15:34:56','',''),('1','287',278,'','2','5',679440.00,0.00,'Payment Id 92 for invoice:58, receipt: 058 by AA RANO NIGERIA LTD','2022-11-19 15:34:56','',''),('1','287',279,'','supplier','1',0.00,679440.00,'Payment Id 92 for invoice:58, receipt: 058 by AA RANO NIGERIA LTD','2022-11-19 15:34:56','',''),('1','287',280,'','2','6',918247.00,0.00,'Payment Id 97 for invoice:60/61, receipt: 060/61 by AA RANO NIGERIA LTD','2022-11-19 15:35:44','',''),('1','287',281,'','supplier','1',0.00,918247.00,'Payment Id 97 for invoice:60/61, receipt: 060/61 by AA RANO NIGERIA LTD','2022-11-19 15:35:44','',''),('1','287',282,'','2','5',812860.00,0.00,'Payment Id 96 for invoice:61, receipt: 061 by AA RANO NIGERIA LTD','2022-11-19 15:35:44','',''),('1','287',283,'','supplier','1',0.00,812860.00,'Payment Id 96 for invoice:61, receipt: 061 by AA RANO NIGERIA LTD','2022-11-19 15:35:44','',''),('1','287',284,'','2','5',612700.00,0.00,'Payment Id 95 for invoice:60, receipt: 060 by AA RANO NIGERIA LTD','2022-11-19 15:35:44','',''),('1','287',285,'','supplier','1',0.00,612700.00,'Payment Id 95 for invoice:60, receipt: 060 by AA RANO NIGERIA LTD','2022-11-19 15:35:44','',''),('1','287',286,'','2','6',758696.00,0.00,'Payment Id 101 for invoice:62/64, receipt: 062/64 by AA RANO NIGERIA LTD','2022-11-19 15:38:50','',''),('1','287',287,'','supplier','1',0.00,758696.00,'Payment Id 101 for invoice:62/64, receipt: 062/64 by AA RANO NIGERIA LTD','2022-11-19 15:38:50','',''),('1','287',288,'','2','5',1407270.00,0.00,'Payment Id 100 for invoice:64, receipt: 064 by AA RANO NIGERIA LTD','2022-11-19 15:38:50','',''),('1','287',289,'','supplier','1',0.00,1407270.00,'Payment Id 100 for invoice:64, receipt: 064 by AA RANO NIGERIA LTD','2022-11-19 15:38:50','',''),('1','287',290,'','2','5',86740.00,0.00,'Payment Id 99 for invoice:62, receipt: 0062 by AA RANO NIGERIA LTD','2022-11-19 15:38:50','',''),('1','287',291,'','supplier','1',0.00,86740.00,'Payment Id 99 for invoice:62, receipt: 0062 by AA RANO NIGERIA LTD','2022-11-19 15:38:50','',''),('1','287',292,'','2','6',576093.00,0.00,'Payment Id 104 for invoice:65/66, receipt: 065/66 by AA RANO NIGERIA LTD','2022-11-19 15:39:25','',''),('1','287',293,'','supplier','1',0.00,576093.00,'Payment Id 104 for invoice:65/66, receipt: 065/66 by AA RANO NIGERIA LTD','2022-11-19 15:39:25','',''),('1','287',294,'','2','5',1068830.00,0.00,'Payment Id 103 for invoice:66, receipt: 066 by AA RANO NIGERIA LTD','2022-11-19 15:39:25','',''),('1','287',295,'','supplier','1',0.00,1068830.00,'Payment Id 103 for invoice:66, receipt: 066 by AA RANO NIGERIA LTD','2022-11-19 15:39:25','',''),('1','287',296,'','2','5',938430.00,0.00,'Payment Id 102 for invoice:65, receipt: 065 by AA RANO NIGERIA LTD','2022-11-19 15:39:25','',''),('1','287',297,'','supplier','1',0.00,938430.00,'Payment Id 102 for invoice:65, receipt: 065 by AA RANO NIGERIA LTD','2022-11-19 15:39:25','',''),('1','287',298,'','2','5',640380.00,0.00,'Payment Id 106 for invoice:68, receipt: 068 by AA RANO NIGERIA LTD','2022-11-19 15:40:23','',''),('1','287',299,'','supplier','1',0.00,640380.00,'Payment Id 106 for invoice:68, receipt: 068 by AA RANO NIGERIA LTD','2022-11-19 15:40:23','',''),('1','287',300,'','2','5',936200.00,0.00,'Payment Id 105 for invoice:67, receipt: 067 by AA RANO NIGERIA LTD','2022-11-19 15:40:23','',''),('1','287',301,'','supplier','1',0.00,936200.00,'Payment Id 105 for invoice:67, receipt: 067 by AA RANO NIGERIA LTD','2022-11-19 15:40:23','',''),('1','287',302,'','2','6',560932.00,0.00,'Payment Id 110 for invoice:69/70, receipt: 069/70 by AA RANO NIGERIA LTD','2022-11-19 15:41:32','',''),('1','287',303,'','supplier','1',0.00,560932.00,'Payment Id 110 for invoice:69/70, receipt: 069/70 by AA RANO NIGERIA LTD','2022-11-19 15:41:32','',''),('1','287',304,'','2','5',738325.00,0.00,'Payment Id 109 for invoice:70, receipt: 070 by AA RANO NIGERIA LTD','2022-11-19 15:41:32','',''),('1','287',305,'','supplier','1',0.00,738325.00,'Payment Id 109 for invoice:70, receipt: 070 by AA RANO NIGERIA LTD','2022-11-19 15:41:32','',''),('1','287',306,'','2','5',602700.00,0.00,'Payment Id 108 for invoice:69, receipt: 069 by AA RANO NIGERIA LTD','2022-11-19 15:41:32','',''),('1','287',307,'','supplier','1',0.00,602700.00,'Payment Id 108 for invoice:69, receipt: 069 by AA RANO NIGERIA LTD','2022-11-19 15:41:32','',''),('1','287',308,'','2','6',1027355.31,0.00,'Payment Id 107 for invoice:67/68, receipt: 067/68 by AA RANO NIGERIA LTD','2022-11-19 15:41:53','',''),('1','287',309,'','supplier','1',0.00,1027355.31,'Payment Id 107 for invoice:67/68, receipt: 067/68 by AA RANO NIGERIA LTD','2022-11-19 15:41:53','',''),('1','287',310,'','2','5',2263265.00,0.00,'Payment Id 114 for invoice:71/72/73/74/75, receipt: 071/72/73/74/75 by AA RANO NIGERIA LTD','2022-11-19 15:44:57','',''),('1','287',311,'','supplier','1',0.00,2263265.00,'Payment Id 114 for invoice:71/72/73/74/75, receipt: 071/72/73/74/75 by AA RANO NIGERIA LTD','2022-11-19 15:44:57','',''),('1','287',312,'','2','6',185367.00,0.00,'Payment Id 113 for invoice:75, receipt: 075 by AA RANO NIGERIA LTD','2022-11-19 15:44:57','',''),('1','287',313,'','supplier','1',0.00,185367.00,'Payment Id 113 for invoice:75, receipt: 075 by AA RANO NIGERIA LTD','2022-11-19 15:44:57','',''),('1','287',314,'','2','6',555670.00,0.00,'Payment Id 112 for invoice:73/74, receipt: 073/74 by AA RANO NIGERIA LTD','2022-11-19 15:44:57','',''),('1','287',315,'','supplier','1',0.00,555670.00,'Payment Id 112 for invoice:73/74, receipt: 073/74 by AA RANO NIGERIA LTD','2022-11-19 15:44:57','',''),('1','287',316,'','2','6',626407.00,0.00,'Payment Id 111 for invoice:71/72, receipt: 071/72 by AA RANO NIGERIA LTD','2022-11-19 15:44:57','',''),('1','287',317,'','supplier','1',0.00,626407.00,'Payment Id 111 for invoice:71/72, receipt: 071/72 by AA RANO NIGERIA LTD','2022-11-19 15:44:57','',''),('1','287',318,'','2','6',878901.00,0.00,'Payment Id 122 for invoice:56/57, receipt: 056/57 by AA RANO NIGERIA LTD','2022-11-19 15:46:26','',''),('1','287',319,'','supplier','1',0.00,878901.00,'Payment Id 122 for invoice:56/57, receipt: 056/57 by AA RANO NIGERIA LTD','2022-11-19 15:46:26','',''),('1','287',320,'','2','6',485038.00,0.00,'Payment Id 34 for invoice:5/6, receipt: 05/6 by AA RANO NIGERIA LTD','2022-11-19 15:54:05','',''),('1','287',321,'','supplier','1',0.00,485038.00,'Payment Id 34 for invoice:5/6, receipt: 05/6 by AA RANO NIGERIA LTD','2022-11-19 15:54:05','',''),('1','287',322,'','2','6',326700.00,0.00,'Payment Id 33 for invoice:4, receipt: 004 by AA RANO NIGERIA LTD','2022-11-19 15:54:05','',''),('1','287',323,'','supplier','1',0.00,326700.00,'Payment Id 33 for invoice:4, receipt: 004 by AA RANO NIGERIA LTD','2022-11-19 15:54:05','',''),('1','287',324,'','2','5',1753065.00,0.00,'Payment Id 23 for invoice:3/4/5, receipt: 0345 by AA RANO NIGERIA LTD','2022-11-19 15:54:05','',''),('1','287',325,'','supplier','1',0.00,1753065.00,'Payment Id 23 for invoice:3/4/5, receipt: 0345 by AA RANO NIGERIA LTD','2022-11-19 15:54:05','',''),('1','287',326,'','2','6',434793.00,0.00,'Payment Id 36 for invoice:9/10, receipt: 09/10 by AA RANO NIGERIA LTD','2022-11-19 16:08:13','',''),('1','287',327,'','supplier','1',0.00,434793.00,'Payment Id 36 for invoice:9/10, receipt: 09/10 by AA RANO NIGERIA LTD','2022-11-19 16:08:13','',''),('1','287',328,'','2','6',403325.00,0.00,'Payment Id 35 for invoice:7/8, receipt: 07/8 by AA RANO NIGERIA LTD','2022-11-19 16:08:13','',''),('1','287',329,'','supplier','1',0.00,403325.00,'Payment Id 35 for invoice:7/8, receipt: 07/8 by AA RANO NIGERIA LTD','2022-11-19 16:08:13','',''),('1','287',330,'','2','5',437970.00,0.00,'Payment Id 25 for invoice:12, receipt: 0012 by AA RANO NIGERIA LTD','2022-11-19 16:08:13','',''),('1','287',331,'','supplier','1',0.00,437970.00,'Payment Id 25 for invoice:12, receipt: 0012 by AA RANO NIGERIA LTD','2022-11-19 16:08:13','',''),('1','287',332,'','6.1','4',49000.00,0.00,'Payment Id 5 for invoice:7, receipt: 0007 by AA RANO NIGERIA LTD','2022-11-19 16:08:13','',''),('1','287',333,'','supplier','1',0.00,49000.00,'Payment Id 5 for invoice:7, receipt: 0007 by AA RANO NIGERIA LTD','2022-11-19 16:08:13','',''),('1','287',334,'','2','6',364623.00,0.00,'Payment Id 38 for invoice:11/12, receipt: 011/12 by AA RANO NIGERIA LTD','2022-11-19 16:22:06','',''),('1','287',335,'','supplier','1',0.00,364623.00,'Payment Id 38 for invoice:11/12, receipt: 011/12 by AA RANO NIGERIA LTD','2022-11-19 16:22:06','',''),('1','287',336,'','2','5',2044950.00,0.00,'Payment Id 24 for invoice:6/7/8/9/10/11, receipt: 06789 by AA RANO NIGERIA LTD','2022-11-19 16:22:06','',''),('1','287',337,'','supplier','1',0.00,2044950.00,'Payment Id 24 for invoice:6/7/8/9/10/11, receipt: 06789 by AA RANO NIGERIA LTD','2022-11-19 16:22:06','',''),('1','287',338,'','2','6',410600.00,0.00,'Payment Id 42 for invoice:19, receipt: 019 by AA RANO NIGERIA LTD','2022-11-19 16:23:51','',''),('1','287',339,'','supplier','1',0.00,410600.00,'Payment Id 42 for invoice:19, receipt: 019 by AA RANO NIGERIA LTD','2022-11-19 16:23:51','',''),('1','287',340,'','2','6',603807.00,0.00,'Payment Id 41 for invoice:17/18, receipt: 017/18 by AA RANO NIGERIA LTD','2022-11-19 16:23:51','',''),('1','287',341,'','supplier','1',0.00,603807.00,'Payment Id 41 for invoice:17/18, receipt: 017/18 by AA RANO NIGERIA LTD','2022-11-19 16:23:51','',''),('1','287',342,'','2','6',323700.00,0.00,'Payment Id 40 for invoice:15/16, receipt: 015/16 by AA RANO NIGERIA LTD','2022-11-19 16:23:51','',''),('1','287',343,'','supplier','1',0.00,323700.00,'Payment Id 40 for invoice:15/16, receipt: 015/16 by AA RANO NIGERIA LTD','2022-11-19 16:23:51','',''),('1','287',344,'','2','5',1423220.00,0.00,'Payment Id 28 for invoice:15/16/17/18, receipt: 015/16/17/18 by AA RANO NIGERIA LTD','2022-11-19 16:25:27','',''),('1','287',345,'','supplier','1',0.00,1423220.00,'Payment Id 28 for invoice:15/16/17/18, receipt: 015/16/17/18 by AA RANO NIGERIA LTD','2022-11-19 16:25:27','',''),('1','287',346,'','2','6',489122.00,0.00,'Payment Id 70 for invoice:40/41, receipt: 040/41 by AA RANO NIGERIA LTD','2022-11-19 16:27:19','',''),('1','287',347,'','supplier','1',0.00,489122.00,'Payment Id 70 for invoice:40/41, receipt: 040/41 by AA RANO NIGERIA LTD','2022-11-19 16:27:19','',''),('1','287',348,'','2','5',438900.00,0.00,'Payment Id 69 for invoice:41, receipt: 041 by AA RANO NIGERIA LTD','2022-11-19 16:27:19','',''),('1','287',349,'','supplier','1',0.00,438900.00,'Payment Id 69 for invoice:41, receipt: 041 by AA RANO NIGERIA LTD','2022-11-19 16:27:19','',''),('1','287',350,'','2','5',273595.00,0.00,'Payment Id 68 for invoice:40, receipt: 040 by AA RANO NIGERIA LTD','2022-11-19 16:27:19','',''),('1','287',351,'','supplier','1',0.00,273595.00,'Payment Id 68 for invoice:40, receipt: 040 by AA RANO NIGERIA LTD','2022-11-19 16:27:19','',''),('1','287',352,'','2','5',750470.00,0.00,'Payment Id 98 for invoice:62, receipt: 062 by AA RANO NIGERIA LTD','2022-11-19 16:36:14','',''),('1','287',353,'','supplier','1',0.00,750470.00,'Payment Id 98 for invoice:62, receipt: 062 by AA RANO NIGERIA LTD','2022-11-19 16:36:14','',''),('1','287',354,'','2','5',30000.00,0.00,'Payment Id 120 for invoice:21, receipt: 21 by AA RANO NIGERIA LTD','2022-11-21 10:50:07','',''),('1','287',355,'','supplier','1',0.00,30000.00,'Payment Id 120 for invoice:21, receipt: 21 by AA RANO NIGERIA LTD','2022-11-21 10:50:07','',''),('1','287',356,'','2','5',9347.20,0.00,'Payment Id 119 for invoice:20, receipt: 20 by AA RANO NIGERIA LTD','2022-11-21 10:50:07','',''),('1','287',357,'','supplier','1',0.00,9347.20,'Payment Id 119 for invoice:20, receipt: 20 by AA RANO NIGERIA LTD','2022-11-21 10:50:07','',''),('1','287',358,'','2','5',121170.40,0.00,'Payment Id 118 for invoice:19, receipt: 19 by AA RANO NIGERIA LTD','2022-11-21 10:50:07','',''),('1','287',359,'','supplier','1',0.00,121170.40,'Payment Id 118 for invoice:19, receipt: 19 by AA RANO NIGERIA LTD','2022-11-21 10:50:07','',''),('1','287',360,'','2','5',60221.90,0.00,'Payment Id 117 for invoice:13/14, receipt: 13/14 by AA RANO NIGERIA LTD','2022-11-21 10:50:07','',''),('1','287',361,'','supplier','1',0.00,60221.90,'Payment Id 117 for invoice:13/14, receipt: 13/14 by AA RANO NIGERIA LTD','2022-11-21 10:50:07','',''),('1','287',362,'','2','5',15000.00,0.00,'Payment Id 116 for invoice:12, receipt: 012 by AA RANO NIGERIA LTD','2022-11-21 10:50:07','',''),('1','287',363,'','supplier','1',0.00,15000.00,'Payment Id 116 for invoice:12, receipt: 012 by AA RANO NIGERIA LTD','2022-11-21 10:50:07','',''),('1','287',364,'','2','5',121686.60,0.00,'Payment Id 115 for invoice:3/4/5, receipt: 03/4/5 by AA RANO NIGERIA LTD','2022-11-21 10:50:07','',''),('1','287',365,'','supplier','1',0.00,121686.60,'Payment Id 115 for invoice:3/4/5, receipt: 03/4/5 by AA RANO NIGERIA LTD','2022-11-21 10:50:07','',''),('1','287',366,'','2','5',24700.00,0.00,'Payment Id 130 for invoice:75, receipt: 75 by AA RANO NIGERIA LTD','2022-11-21 10:51:53','',''),('1','287',367,'','supplier','1',0.00,24700.00,'Payment Id 130 for invoice:75, receipt: 75 by AA RANO NIGERIA LTD','2022-11-21 10:51:53','',''),('1','287',368,'','2','5',4000.00,0.00,'Payment Id 129 for invoice:71, receipt: 71 by AA RANO NIGERIA LTD','2022-11-21 10:51:53','',''),('1','287',369,'','supplier','1',0.00,4000.00,'Payment Id 129 for invoice:71, receipt: 71 by AA RANO NIGERIA LTD','2022-11-21 10:51:53','',''),('1','287',370,'','2','5',10000.00,0.00,'Payment Id 128 for invoice:52, receipt: 52 by AA RANO NIGERIA LTD','2022-11-21 10:51:53','',''),('1','287',371,'','supplier','1',0.00,10000.00,'Payment Id 128 for invoice:52, receipt: 52 by AA RANO NIGERIA LTD','2022-11-21 10:51:53','',''),('1','287',372,'','2','5',85000.00,0.00,'Payment Id 127 for invoice:40, receipt: 40 by AA RANO NIGERIA LTD','2022-11-21 10:51:53','',''),('1','287',373,'','supplier','1',0.00,85000.00,'Payment Id 127 for invoice:40, receipt: 40 by AA RANO NIGERIA LTD','2022-11-21 10:51:53','',''),('1','287',374,'','2','5',111494.40,0.00,'Payment Id 126 for invoice:38, receipt: 38 by AA RANO NIGERIA LTD','2022-11-21 10:51:53','',''),('1','287',375,'','supplier','1',0.00,111494.40,'Payment Id 126 for invoice:38, receipt: 38 by AA RANO NIGERIA LTD','2022-11-21 10:51:53','',''),('1','287',376,'','2','5',12000.00,0.00,'Payment Id 125 for invoice:31, receipt: 31 by AA RANO NIGERIA LTD','2022-11-21 10:51:53','',''),('1','287',377,'','supplier','1',0.00,12000.00,'Payment Id 125 for invoice:31, receipt: 31 by AA RANO NIGERIA LTD','2022-11-21 10:51:53','',''),('1','287',378,'','2','5',24292.00,0.00,'Payment Id 124 for invoice:25, receipt: 0025 by AA RANO NIGERIA LTD','2022-11-21 10:51:53','',''),('1','287',379,'','supplier','1',0.00,24292.00,'Payment Id 124 for invoice:25, receipt: 0025 by AA RANO NIGERIA LTD','2022-11-21 10:51:53','',''),('1','287',380,'','2','5',2699.80,0.00,'Payment Id 123 for invoice:25, receipt: 25 by AA RANO NIGERIA LTD','2022-11-21 10:51:53','',''),('1','287',381,'','supplier','1',0.00,2699.80,'Payment Id 123 for invoice:25, receipt: 25 by AA RANO NIGERIA LTD','2022-11-21 10:51:53','',''),('1','287',382,'','2','5',21762.30,0.00,'Payment Id 121 for invoice:23, receipt: 23 by AA RANO NIGERIA LTD','2022-11-21 10:51:54','',''),('1','287',383,'','supplier','1',0.00,21762.30,'Payment Id 121 for invoice:23, receipt: 23 by AA RANO NIGERIA LTD','2022-11-21 10:51:54','',''),('1','287',384,'','6.1','4',24250.00,0.00,'Payment Id 136 for invoice:25, receipt: 0025 by AA RANO NIGERIA LTD','2022-11-22 11:18:48','',''),('1','287',385,'','supplier','1',0.00,24250.00,'Payment Id 136 for invoice:25, receipt: 0025 by AA RANO NIGERIA LTD','2022-11-22 11:18:48','',''),('1','287',386,'','6.1','4',33000.00,0.00,'Payment Id 135 for invoice:70, receipt: 0070 by AA RANO NIGERIA LTD','2022-11-22 11:18:48','',''),('1','287',387,'','supplier','1',0.00,33000.00,'Payment Id 135 for invoice:70, receipt: 0070 by AA RANO NIGERIA LTD','2022-11-22 11:18:48','',''),('1','287',388,'','6.1','4',66000.00,0.00,'Payment Id 134 for invoice:70, receipt: 0070 by AA RANO NIGERIA LTD','2022-11-22 11:18:48','',''),('1','287',389,'','supplier','1',0.00,66000.00,'Payment Id 134 for invoice:70, receipt: 0070 by AA RANO NIGERIA LTD','2022-11-22 11:18:48','',''),('1','287',390,'','24','1',0.00,12600000.00,'Purchase Id 10 for 60,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-24 04:39:21','',''),('1','287',391,'','supplier','1',12600000.00,0.00,'Purchase Id 10 for 60,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-24 04:39:21','',''),('1','287',392,'','24','1',0.00,12600000.00,'Purchase Id 9 for 60,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-24 04:39:39','',''),('1','287',393,'','supplier','1',12600000.00,0.00,'Purchase Id 9 for 60,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2022-11-24 04:39:39','',''),('1','287',394,'','20','3',0.00,0.00,'Sales from shift 76 on 2022-11-24 09:41:44 ','2022-11-24 09:41:44','',''),('1','287',395,'','6.1','4',0.00,0.00,'Sales from shift 76 on 2022-11-24 09:41:44 ','2022-11-24 09:41:44','',''),('1','287',396,'','20','3',1509750.00,0.00,'Sales from shift 77 on 2022-11-24 11:21:47 ','2022-11-24 11:21:47','',''),('1','287',397,'','6.1','4',0.00,1509750.00,'Sales from shift 77 on 2022-11-24 11:21:47 ','2022-11-24 11:21:47','',''),('1','287',398,'','20','3',234796.80,0.00,'Sales from shift 78 on 2022-11-25 07:53:06 ','2022-11-25 07:53:06','',''),('1','287',399,'','6.1','4',0.00,234796.80,'Sales from shift 78 on 2022-11-25 07:53:06 ','2022-11-25 07:53:06','',''),('1','287',400,'','20','3',2496261.60,0.00,'Sales from shift 79 on 2022-11-25 08:44:39 ','2022-11-25 08:44:39','',''),('1','287',401,'','6.1','4',0.00,2496261.60,'Sales from shift 79 on 2022-11-25 08:44:39 ','2022-11-25 08:44:39','',''),('1','287',402,'','20','3',2961806.40,0.00,'Sales from shift 80 on 2022-11-25 09:10:20 ','2022-11-25 09:10:20','',''),('1','287',403,'','6.1','4',0.00,2961806.40,'Sales from shift 80 on 2022-11-25 09:10:20 ','2022-11-25 09:10:20','',''),('1','287',404,'','20','3',2213160.60,0.00,'Sales from shift 81 on 2022-11-25 17:32:20 ','2022-11-25 17:32:20','',''),('1','287',405,'','6.1','4',0.00,2213160.60,'Sales from shift 81 on 2022-11-25 17:32:20 ','2022-11-25 17:32:20','',''),('1','287',406,'','20','3',2280238.80,0.00,'Sales from shift 82 on 2022-11-26 07:59:39 ','2022-11-26 07:59:39','',''),('1','287',407,'','6.1','4',0.00,2280238.80,'Sales from shift 82 on 2022-11-26 07:59:39 ','2022-11-26 07:59:39','',''),('1','287',408,'','20','3',2294667.90,0.00,'Sales from shift 83 on 2022-11-26 09:49:09 ','2022-11-26 09:49:09','',''),('1','287',409,'','6.1','4',0.00,2294667.90,'Sales from shift 83 on 2022-11-26 09:49:09 ','2022-11-26 09:49:09','',''),('1','287',410,'','20','3',2110348.80,0.00,'Sales from shift 84 on 2022-11-27 09:21:42 ','2022-11-27 09:21:42','',''),('1','287',411,'','6.1','4',0.00,2110348.80,'Sales from shift 84 on 2022-11-27 09:21:42 ','2022-11-27 09:21:42','',''),('1','287',412,'','20','3',2737841.40,0.00,'Sales from shift 85 on 2022-11-27 14:43:45 ','2022-11-27 14:43:45','',''),('1','287',413,'','6.1','4',0.00,2737841.40,'Sales from shift 85 on 2022-11-27 14:43:45 ','2022-11-27 14:43:45','',''),('1','287',414,'','20','3',2440964.40,0.00,'Sales from shift 86 on 2022-11-27 15:52:56 ','2022-11-27 15:52:56','',''),('1','287',415,'','6.1','4',0.00,2440964.40,'Sales from shift 86 on 2022-11-27 15:52:56 ','2022-11-27 15:52:56','',''),('1','287',416,'','20','3',2849408.10,0.00,'Sales from shift 87 on 2022-11-28 12:07:39 ','2022-11-28 12:07:39','',''),('1','287',417,'','6.1','4',0.00,2849408.10,'Sales from shift 87 on 2022-11-28 12:07:39 ','2022-11-28 12:07:39','',''),('1','287',418,'','20','3',1945051.50,0.00,'Sales from shift 88 on 2022-11-28 15:00:40 ','2022-11-28 15:00:40','',''),('1','287',419,'','6.1','4',0.00,1945051.50,'Sales from shift 88 on 2022-11-28 15:00:40 ','2022-11-28 15:00:40','',''),('1','287',420,'','6.1','4',1485000.00,0.00,'Payment Id 137 for invoice:77, receipt: 077 by AA RANO NIGERIA LTD','2022-11-28 16:48:29','',''),('1','287',421,'','supplier','1',0.00,1485000.00,'Payment Id 137 for invoice:77, receipt: 077 by AA RANO NIGERIA LTD','2022-11-28 16:48:29','',''),('1','287',422,'','6.1','4',40000.00,0.00,'Payment Id 147 for invoice:78, receipt: 78 by AA RANO NIGERIA LTD','2022-11-28 17:07:21','',''),('1','287',423,'','supplier','1',0.00,40000.00,'Payment Id 147 for invoice:78, receipt: 78 by AA RANO NIGERIA LTD','2022-11-28 17:07:21','',''),('1','287',424,'','2','5',1566940.00,0.00,'Payment Id 141 for invoice:79, receipt: 00079 by AA RANO NIGERIA LTD','2022-11-28 17:07:21','',''),('1','287',425,'','supplier','1',0.00,1566940.00,'Payment Id 141 for invoice:79, receipt: 00079 by AA RANO NIGERIA LTD','2022-11-28 17:07:21','',''),('1','287',426,'','6.1','4',34400.00,0.00,'Payment Id 140 for invoice:79, receipt: 079 by AA RANO NIGERIA LTD','2022-11-28 17:07:21','',''),('1','287',427,'','supplier','1',0.00,34400.00,'Payment Id 140 for invoice:79, receipt: 079 by AA RANO NIGERIA LTD','2022-11-28 17:07:21','',''),('1','287',428,'','6.1','4',34400.00,0.00,'Payment Id 139 for invoice:79, receipt: 079 by AA RANO NIGERIA LTD','2022-11-28 17:07:21','',''),('1','287',429,'','supplier','1',0.00,34400.00,'Payment Id 139 for invoice:79, receipt: 079 by AA RANO NIGERIA LTD','2022-11-28 17:07:21','',''),('1','287',430,'','20','3',3014018.70,0.00,'Sales from shift 89 on 2022-11-29 11:16:25 ','2022-11-29 11:16:25','',''),('1','287',431,'','6.1','4',0.00,3014018.70,'Sales from shift 89 on 2022-11-29 11:16:25 ','2022-11-29 11:16:25','',''),('1','287',432,'','6.1','4',576000.00,0.00,'Payment Id 146 for invoice:80, receipt: 80 by AA RANO NIGERIA LTD','2022-11-29 14:48:04','',''),('1','287',433,'','supplier','1',0.00,576000.00,'Payment Id 146 for invoice:80, receipt: 80 by AA RANO NIGERIA LTD','2022-11-29 14:48:04','',''),('1','287',434,'','2','5',1562070.00,0.00,'Payment Id 144 for invoice:81, receipt: 81 by AA RANO NIGERIA LTD','2022-11-29 14:53:16','',''),('1','287',435,'','supplier','1',0.00,1562070.00,'Payment Id 144 for invoice:81, receipt: 81 by AA RANO NIGERIA LTD','2022-11-29 14:53:16','',''),('1','287',436,'','2','5',1307195.00,0.00,'Payment Id 143 for invoice:80, receipt: 80 by AA RANO NIGERIA LTD','2022-11-29 14:53:16','',''),('1','287',437,'','supplier','1',0.00,1307195.00,'Payment Id 143 for invoice:80, receipt: 80 by AA RANO NIGERIA LTD','2022-11-29 14:53:16','',''),('1','287',438,'','2','5',1669410.00,0.00,'Payment Id 149 for invoice:83, receipt: 83 by AA RANO NIGERIA LTD','2022-11-29 14:54:08','',''),('1','287',439,'','supplier','1',0.00,1669410.00,'Payment Id 149 for invoice:83, receipt: 83 by AA RANO NIGERIA LTD','2022-11-29 14:54:08','',''),('1','287',440,'','2','5',1548680.00,0.00,'Payment Id 148 for invoice:82, receipt: 82 by AA RANO NIGERIA LTD','2022-11-29 14:54:08','',''),('1','287',441,'','supplier','1',0.00,1548680.00,'Payment Id 148 for invoice:82, receipt: 82 by AA RANO NIGERIA LTD','2022-11-29 14:54:08','',''),('1','287',442,'','2','5',1433240.00,0.00,'Payment Id 152 for invoice:87, receipt: 87 by AA RANO NIGERIA LTD','2022-11-29 14:56:42','',''),('1','287',443,'','supplier','1',0.00,1433240.00,'Payment Id 152 for invoice:87, receipt: 87 by AA RANO NIGERIA LTD','2022-11-29 14:56:42','',''),('1','287',444,'','2','5',1518410.00,0.00,'Payment Id 151 for invoice:86, receipt: 86 by AA RANO NIGERIA LTD','2022-11-29 14:56:42','',''),('1','287',445,'','supplier','1',0.00,1518410.00,'Payment Id 151 for invoice:86, receipt: 86 by AA RANO NIGERIA LTD','2022-11-29 14:56:42','',''),('1','287',446,'','2','5',1360630.00,0.00,'Payment Id 156 for invoice:89, receipt: 89 by AA RANO NIGERIA LTD','2022-11-29 14:57:56','',''),('1','287',447,'','supplier','1',0.00,1360630.00,'Payment Id 156 for invoice:89, receipt: 89 by AA RANO NIGERIA LTD','2022-11-29 14:57:56','',''),('1','287',448,'','2','5',1455680.00,0.00,'Payment Id 154 for invoice:88, receipt: 88 by AA RANO NIGERIA LTD','2022-11-29 14:57:56','',''),('1','287',449,'','supplier','1',0.00,1455680.00,'Payment Id 154 for invoice:88, receipt: 88 by AA RANO NIGERIA LTD','2022-11-29 14:57:56','',''),('1','287',450,'','20','3',799173.90,0.00,'Sales from shift 90 on 2022-11-29 16:54:09 ','2022-11-29 16:54:09','',''),('1','287',451,'','6.1','4',0.00,799173.90,'Sales from shift 90 on 2022-11-29 16:54:09 ','2022-11-29 16:54:09','',''),('1','287',452,'','20','3',445544.40,0.00,'Sales from shift 91 on 2022-11-30 11:34:56 ','2022-11-30 11:34:56','',''),('1','287',453,'','6.1','4',0.00,445544.40,'Sales from shift 91 on 2022-11-30 11:34:56 ','2022-11-30 11:34:56','',''),('1','287',454,'','2','6',1353818.88,0.00,'Payment Id 150 for invoice:82/83, receipt: 82/83 by AA RANO NIGERIA LTD','2022-11-30 16:56:04','',''),('1','287',455,'','supplier','1',0.00,1353818.88,'Payment Id 150 for invoice:82/83, receipt: 82/83 by AA RANO NIGERIA LTD','2022-11-30 16:56:04','',''),('1','287',456,'','2','6',1726822.00,0.00,'Payment Id 145 for invoice:80/81, receipt: 80/81 by AA RANO NIGERIA LTD','2022-11-30 16:56:04','',''),('1','287',457,'','supplier','1',0.00,1726822.00,'Payment Id 145 for invoice:80/81, receipt: 80/81 by AA RANO NIGERIA LTD','2022-11-30 16:56:04','',''),('1','287',458,'','2','6',929318.00,0.00,'Payment Id 142 for invoice:79, receipt: 0/79 by AA RANO NIGERIA LTD','2022-11-30 16:56:04','',''),('1','287',459,'','supplier','1',0.00,929318.00,'Payment Id 142 for invoice:79, receipt: 0/79 by AA RANO NIGERIA LTD','2022-11-30 16:56:04','',''),('1','287',460,'','2','6',1863790.00,0.00,'Payment Id 161 for invoice:84/85, receipt: 84/85 by AA RANO NIGERIA LTD','2022-11-30 16:56:42','',''),('1','287',461,'','supplier','1',0.00,1863790.00,'Payment Id 161 for invoice:84/85, receipt: 84/85 by AA RANO NIGERIA LTD','2022-11-30 16:56:42','',''),('1','287',462,'','2','6',2338721.25,0.00,'Payment Id 153 for invoice:86/87, receipt: 86/87 by AA RANO NIGERIA LTD','2022-11-30 16:56:42','',''),('1','287',463,'','supplier','1',0.00,2338721.25,'Payment Id 153 for invoice:86/87, receipt: 86/87 by AA RANO NIGERIA LTD','2022-11-30 16:56:42','',''),('1','287',464,'','2','5',1551655.00,0.00,'Payment Id 160 for invoice:85, receipt: 85 by AA RANO NIGERIA LTD','2022-11-30 16:57:43','',''),('1','287',465,'','supplier','1',0.00,1551655.00,'Payment Id 160 for invoice:85, receipt: 85 by AA RANO NIGERIA LTD','2022-11-30 16:57:43','',''),('1','287',466,'','2','5',1432745.00,0.00,'Payment Id 159 for invoice:84, receipt: 84 by AA RANO NIGERIA LTD','2022-11-30 16:57:44','',''),('1','287',467,'','supplier','1',0.00,1432745.00,'Payment Id 159 for invoice:84, receipt: 84 by AA RANO NIGERIA LTD','2022-11-30 16:57:44','',''),('1','287',468,'','20','3',737595.60,0.00,'Sales from shift 92 on 2022-12-02 10:19:52 ','2022-12-02 10:19:52','',''),('1','287',469,'','6.1','4',0.00,737595.60,'Sales from shift 92 on 2022-12-02 10:19:52 ','2022-12-02 10:19:52','',''),('1','287',470,'','2','6',517312.00,0.00,'Payment Id 164 for invoice:90/91, receipt: 90/91 by AA RANO NIGERIA LTD','2022-12-02 12:11:52','',''),('1','287',471,'','supplier','1',0.00,517312.00,'Payment Id 164 for invoice:90/91, receipt: 90/91 by AA RANO NIGERIA LTD','2022-12-02 12:11:52','',''),('1','287',472,'','2','5',189340.00,0.00,'Payment Id 163 for invoice:91, receipt: 91 by AA RANO NIGERIA LTD','2022-12-02 12:11:52','',''),('1','287',473,'','supplier','1',0.00,189340.00,'Payment Id 163 for invoice:91, receipt: 91 by AA RANO NIGERIA LTD','2022-12-02 12:11:52','',''),('1','287',474,'','2','5',535060.00,0.00,'Payment Id 162 for invoice:90, receipt: 90 by AA RANO NIGERIA LTD','2022-12-02 12:11:52','',''),('1','287',475,'','supplier','1',0.00,535060.00,'Payment Id 162 for invoice:90, receipt: 90 by AA RANO NIGERIA LTD','2022-12-02 12:11:52','',''),('1','287',476,'','2','6',2064154.00,0.00,'Payment Id 157 for invoice:88/89, receipt: 88/89 by AA RANO NIGERIA LTD','2022-12-02 12:12:26','',''),('1','287',477,'','supplier','1',0.00,2064154.00,'Payment Id 157 for invoice:88/89, receipt: 88/89 by AA RANO NIGERIA LTD','2022-12-02 12:12:26','',''),('1','287',478,'','20','3',739200.00,0.00,'Sales from shift 93 on 2022-12-03 21:44:47 ','2022-12-03 21:44:47','',''),('1','287',479,'','6.1','4',0.00,739200.00,'Sales from shift 93 on 2022-12-03 21:44:47 ','2022-12-03 21:44:47','',''),('1','287',480,'','20','3',984622.80,0.00,'Sales from shift 94 on 2022-12-04 12:08:42 ','2022-12-04 12:08:42','',''),('1','287',481,'','6.1','4',0.00,984622.80,'Sales from shift 94 on 2022-12-04 12:08:42 ','2022-12-04 12:08:42','',''),('1','287',482,'','2','5',295000.00,0.00,'Payment Id 165 for invoice:92, receipt: 92 by AA RANO NIGERIA LTD','2022-12-06 11:58:26','',''),('1','287',483,'','supplier','1',0.00,295000.00,'Payment Id 165 for invoice:92, receipt: 92 by AA RANO NIGERIA LTD','2022-12-06 11:58:26','',''),('1','287',484,'','2','5',984620.00,0.00,'Payment Id 168 for invoice:94, receipt: 94 by AA RANO NIGERIA LTD','2022-12-06 11:59:51','',''),('1','287',485,'','supplier','1',0.00,984620.00,'Payment Id 168 for invoice:94, receipt: 94 by AA RANO NIGERIA LTD','2022-12-06 11:59:51','',''),('1','287',486,'','6.1','4',24750.00,0.00,'Payment Id 169 for invoice:77, receipt: 77 by AA RANO NIGERIA LTD','2022-12-06 12:00:36','',''),('1','287',487,'','supplier','1',0.00,24750.00,'Payment Id 169 for invoice:77, receipt: 77 by AA RANO NIGERIA LTD','2022-12-06 12:00:36','',''),('1','287',488,'','2','6',714000.00,0.00,'Payment Id 167 for invoice:93, receipt: 93 by AA RANO NIGERIA LTD','2022-12-08 14:32:45','',''),('1','287',489,'','supplier','1',0.00,714000.00,'Payment Id 167 for invoice:93, receipt: 93 by AA RANO NIGERIA LTD','2022-12-08 14:32:45','',''),('1','287',490,'','2','6',442600.00,0.00,'Payment Id 166 for invoice:92, receipt: 0092 by AA RANO NIGERIA LTD','2022-12-08 14:32:45','',''),('1','287',491,'','supplier','1',0.00,442600.00,'Payment Id 166 for invoice:92, receipt: 0092 by AA RANO NIGERIA LTD','2022-12-08 14:32:45','',''),('1','287',492,'','6.1','4',75600.00,0.00,'Payment Id 158 for invoice:89, receipt: 00089 by AA RANO NIGERIA LTD','2022-12-08 14:33:20','',''),('1','287',493,'','supplier','1',0.00,75600.00,'Payment Id 158 for invoice:89, receipt: 00089 by AA RANO NIGERIA LTD','2022-12-08 14:33:20','',''),('1','287',494,'','6.1','4',126000.00,0.00,'Payment Id 155 for invoice:78, receipt: 78 by AA RANO NIGERIA LTD','2022-12-08 14:33:20','',''),('1','287',495,'','supplier','1',0.00,126000.00,'Payment Id 155 for invoice:78, receipt: 78 by AA RANO NIGERIA LTD','2022-12-08 14:33:20','',''),('1','287',496,'','6.1','4',25200.00,0.00,'Payment Id 170 for invoice:93, receipt: 93 by AA RANO NIGERIA LTD','2022-12-15 09:37:51','',''),('1','287',497,'','supplier','1',0.00,25200.00,'Payment Id 170 for invoice:93, receipt: 93 by AA RANO NIGERIA LTD','2022-12-15 09:37:51','',''),('1','287',498,'','20','3',299880.00,0.00,'Sales from shift 95 on 2022-12-15 21:51:11 ','2022-12-15 21:51:11','',''),('1','287',499,'','6.1','4',0.00,299880.00,'Sales from shift 95 on 2022-12-15 21:51:11 ','2022-12-15 21:51:11','',''),('1','287',500,'','6.1','4',25200.00,0.00,'Payment Id 172 for invoice:95, receipt: 0095 by AA RANO NIGERIA LTD','2022-12-16 13:39:30','',''),('1','287',501,'','supplier','1',0.00,25200.00,'Payment Id 172 for invoice:95, receipt: 0095 by AA RANO NIGERIA LTD','2022-12-16 13:39:30','',''),('1','287',502,'','2','5',259680.00,0.00,'Payment Id 171 for invoice:95, receipt: 95 by AA RANO NIGERIA LTD','2022-12-16 13:39:30','',''),('1','287',503,'','supplier','1',0.00,259680.00,'Payment Id 171 for invoice:95, receipt: 95 by AA RANO NIGERIA LTD','2022-12-16 13:39:30','',''),('1','287',504,'','20','3',235504.00,0.00,'Sales from shift 96 on 2022-12-18 14:24:55 ','2022-12-18 14:24:55','',''),('1','287',505,'','6.1','4',0.00,235504.00,'Sales from shift 96 on 2022-12-18 14:24:55 ','2022-12-18 14:24:55','',''),('1','287',506,'','2','5',73790.00,0.00,'Payment Id 175 for invoice:0096, receipt: 0096 by AA RANO NIGERIA LTD','2022-12-20 11:18:25','',''),('1','287',507,'','supplier','1',0.00,73790.00,'Payment Id 175 for invoice:0096, receipt: 0096 by AA RANO NIGERIA LTD','2022-12-20 11:18:25','',''),('1','287',508,'','2','6',263000.00,0.00,'Payment Id 174 for invoice:96, receipt: 096 by AA RANO NIGERIA LTD','2022-12-20 11:40:05','',''),('1','287',509,'','supplier','1',0.00,263000.00,'Payment Id 174 for invoice:96, receipt: 096 by AA RANO NIGERIA LTD','2022-12-20 11:40:05','',''),('1','287',510,'','2','6',235500.00,0.00,'Payment Id 173 for invoice:96, receipt: 96 by AA RANO NIGERIA LTD','2022-12-20 11:40:05','',''),('1','287',511,'','supplier','1',0.00,235500.00,'Payment Id 173 for invoice:96, receipt: 96 by AA RANO NIGERIA LTD','2022-12-20 11:40:05','',''),('1','287',512,'','20','3',410598.60,0.00,'Sales from shift 97 on 2022-12-21 08:00:29 ','2022-12-21 08:00:29','',''),('1','287',513,'','6.1','4',0.00,410598.60,'Sales from shift 97 on 2022-12-21 08:00:29 ','2022-12-21 08:00:29','',''),('1','287',514,'','20','3',290993.40,0.00,'Sales from shift 98 on 2022-12-21 08:33:09 ','2022-12-21 08:33:09','',''),('1','287',515,'','6.1','4',0.00,290993.40,'Sales from shift 98 on 2022-12-21 08:33:09 ','2022-12-21 08:33:09','',''),('1','287',516,'','2','5',290990.00,0.00,'Payment Id 177 for invoice:98, receipt: 98 by AA RANO NIGERIA LTD','2022-12-22 15:29:41','',''),('1','287',517,'','supplier','1',0.00,290990.00,'Payment Id 177 for invoice:98, receipt: 98 by AA RANO NIGERIA LTD','2022-12-22 15:29:41','',''),('1','287',518,'','6.1','4',73800.00,0.00,'Payment Id 176 for invoice:97, receipt: 97 by AA RANO NIGERIA LTD','2022-12-23 11:21:32','',''),('1','287',519,'','supplier','1',0.00,73800.00,'Payment Id 176 for invoice:97, receipt: 97 by AA RANO NIGERIA LTD','2022-12-23 11:21:32','',''),('1','287',520,'','20','3',531237.00,0.00,'Sales from shift 99 on 2022-12-29 09:24:42 ','2022-12-29 09:24:42','',''),('1','287',521,'','6.1','4',0.00,531237.00,'Sales from shift 99 on 2022-12-29 09:24:42 ','2022-12-29 09:24:42','',''),('1','287',522,'','2','5',57940.00,0.00,'Payment Id 178 for invoice:99, receipt: 99 by AA RANO NIGERIA LTD','2023-01-04 13:33:33','',''),('1','287',523,'','supplier','1',0.00,57940.00,'Payment Id 178 for invoice:99, receipt: 99 by AA RANO NIGERIA LTD','2023-01-04 13:33:33','',''),('1','287',524,'','20','3',1540480.00,0.00,'Sales from shift 100 on 2023-01-20 09:18:05 ','2023-01-20 09:18:05','',''),('1','287',525,'','6.1','4',0.00,1540480.00,'Sales from shift 100 on 2023-01-20 09:18:05 ','2023-01-20 09:18:05','',''),('1','287',526,'','2','5',1538480.00,0.00,'Payment Id 179 for invoice:100, receipt: 100 by AA RANO NIGERIA LTD','2023-01-25 12:08:19','',''),('1','287',527,'','supplier','1',0.00,1538480.00,'Payment Id 179 for invoice:100, receipt: 100 by AA RANO NIGERIA LTD','2023-01-25 12:08:19','',''),('1','287',528,'','20','3',900002.20,0.00,'Sales from shift 101 on 2023-01-27 09:51:58 ','2023-01-27 09:51:58','',''),('1','287',529,'','6.1','4',0.00,900002.20,'Sales from shift 101 on 2023-01-27 09:51:58 ','2023-01-27 09:51:58','',''),('1','287',530,'','20','3',437407.20,0.00,'Sales from shift 102 on 2023-02-01 14:34:43 ','2023-02-01 14:34:43','',''),('1','287',531,'','6.1','4',0.00,437407.20,'Sales from shift 102 on 2023-02-01 14:34:43 ','2023-02-01 14:34:43','',''),('1','287',532,'','2','6',900000.00,0.00,'Payment Id 180 for invoice:101, receipt: 101 by AA RANO NIGERIA LTD','2023-02-02 16:39:17','',''),('1','287',533,'','supplier','1',0.00,900000.00,'Payment Id 180 for invoice:101, receipt: 101 by AA RANO NIGERIA LTD','2023-02-02 16:39:17','',''),('1','287',534,'','2','5',435400.00,0.00,'Payment Id 181 for invoice:102, receipt: 102 by AA RANO NIGERIA LTD','2023-02-03 11:13:44','',''),('1','287',535,'','supplier','1',0.00,435400.00,'Payment Id 181 for invoice:102, receipt: 102 by AA RANO NIGERIA LTD','2023-02-03 11:13:44','',''),('1','287',536,'','20','3',171698.60,0.00,'Sales from shift 103 on 2023-02-06 11:19:36 ','2023-02-06 11:19:36','',''),('1','287',537,'','6.1','4',0.00,171698.60,'Sales from shift 103 on 2023-02-06 11:19:36 ','2023-02-06 11:19:36','',''),('1','287',538,'','20','3',250003.40,0.00,'Sales from shift 104 on 2023-02-06 16:57:27 ','2023-02-06 16:57:27','',''),('1','287',539,'','6.1','4',0.00,250003.40,'Sales from shift 104 on 2023-02-06 16:57:27 ','2023-02-06 16:57:27','',''),('1','287',540,'','20','3',148837.50,0.00,'Sales from shift 105 on 2023-02-08 08:08:27 ','2023-02-08 08:08:27','',''),('1','287',541,'','6.1','4',0.00,148837.50,'Sales from shift 105 on 2023-02-08 08:08:27 ','2023-02-08 08:08:27','',''),('1','287',542,'','20','3',48600.00,0.00,'Sales from shift 106 on 2023-02-11 15:04:44 ','2023-02-11 15:04:44','',''),('1','287',543,'','6.1','4',0.00,48600.00,'Sales from shift 106 on 2023-02-11 15:04:44 ','2023-02-11 15:04:44','',''),('1','287',544,'','6.1','4',48600.00,0.00,'Payment Id 185 for invoice:105, receipt: 105 by AA RANO NIGERIA LTD','2023-02-15 12:01:54','',''),('1','287',545,'','supplier','1',0.00,48600.00,'Payment Id 185 for invoice:105, receipt: 105 by AA RANO NIGERIA LTD','2023-02-15 12:01:54','',''),('1','287',546,'','2','6',100243.00,0.00,'Payment Id 184 for invoice:105, receipt: 105 by AA RANO NIGERIA LTD','2023-02-15 12:01:54','',''),('1','287',547,'','supplier','1',0.00,100243.00,'Payment Id 184 for invoice:105, receipt: 105 by AA RANO NIGERIA LTD','2023-02-15 12:01:54','',''),('1','287',548,'','2','6',171700.00,0.00,'Payment Id 182 for invoice:103, receipt: 103 by AA RANO NIGERIA LTD','2023-02-15 12:01:54','',''),('1','287',549,'','supplier','1',0.00,171700.00,'Payment Id 182 for invoice:103, receipt: 103 by AA RANO NIGERIA LTD','2023-02-15 12:01:54','',''),('1','287',550,'','20','3',388597.50,0.00,'Sales from shift 107 on 2023-02-16 09:18:13 ','2023-02-16 09:18:13','',''),('1','287',551,'','6.1','4',0.00,388597.50,'Sales from shift 107 on 2023-02-16 09:18:13 ','2023-02-16 09:18:13','',''),('1','287',552,'','2','6',48600.00,0.00,'Payment Id 186 for invoice:106, receipt: 106 by AA RANO NIGERIA LTD','2023-02-18 17:18:17','',''),('1','287',553,'','supplier','1',0.00,48600.00,'Payment Id 186 for invoice:106, receipt: 106 by AA RANO NIGERIA LTD','2023-02-18 17:18:17','',''),('1','287',554,'','24','1',0.00,11750000.00,'Purchase Id 11 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-02 12:54:33','',''),('1','287',555,'','supplier','1',11750000.00,0.00,'Purchase Id 11 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-02 12:54:33','',''),('1','287',556,'','2','6',388600.00,0.00,'Payment Id 187 for invoice:107, receipt: 107 by AA RANO NIGERIA LTD','2023-03-02 14:04:02','',''),('1','287',557,'','supplier','1',0.00,388600.00,'Payment Id 187 for invoice:107, receipt: 107 by AA RANO NIGERIA LTD','2023-03-02 14:04:02','',''),('1','287',558,'','20','3',2746665.65,0.00,'Sales from shift 108 on 2023-03-03 09:57:05 ','2023-03-03 09:57:05','',''),('1','287',559,'','6.1','4',0.00,2746665.65,'Sales from shift 108 on 2023-03-03 09:57:05 ','2023-03-03 09:57:05','',''),('1','287',560,'','20','3',2494781.15,0.00,'Sales from shift 109 on 2023-03-04 11:28:51 ','2023-03-04 11:28:51','',''),('1','287',561,'','6.1','4',0.00,2494781.15,'Sales from shift 109 on 2023-03-04 11:28:51 ','2023-03-04 11:28:51','',''),('1','287',562,'','6.1','4',565500.00,0.00,'Payment Id 188 for invoice:108, receipt: 108 by AA RANO NIGERIA LTD','2023-03-04 13:43:37','',''),('1','287',563,'','supplier','1',0.00,565500.00,'Payment Id 188 for invoice:108, receipt: 108 by AA RANO NIGERIA LTD','2023-03-04 13:43:37','',''),('1','287',564,'','20','3',1903697.40,0.00,'Sales from shift 110 on 2023-03-06 23:22:14 ','2023-03-06 23:22:14','',''),('1','287',565,'','6.1','4',0.00,1903697.40,'Sales from shift 110 on 2023-03-06 23:22:14 ','2023-03-06 23:22:14','',''),('1','287',566,'','20','3',3131783.90,0.00,'Sales from shift 111 on 2023-03-07 11:31:06 ','2023-03-07 11:31:06','',''),('1','287',567,'','6.1','4',0.00,3131783.90,'Sales from shift 111 on 2023-03-07 11:31:06 ','2023-03-07 11:31:06','',''),('1','287',568,'','20','3',1931288.75,0.00,'Sales from shift 112 on 2023-03-08 09:46:03 ','2023-03-08 09:46:03','',''),('1','287',569,'','6.1','4',0.00,1931288.75,'Sales from shift 112 on 2023-03-08 09:46:03 ','2023-03-08 09:46:03','',''),('1','287',570,'','24','1',0.00,12000000.00,'Purchase Id 12 for 15,000.00 litters of Diesel - AGO from AA RANO NIGERIA LTD','2023-03-08 21:32:21','',''),('1','287',571,'','supplier','1',12000000.00,0.00,'Purchase Id 12 for 15,000.00 litters of Diesel - AGO from AA RANO NIGERIA LTD','2023-03-08 21:32:21','',''),('1','287',572,'','24','1',0.00,11750000.00,'Purchase Id 13 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-08 21:33:01','',''),('1','287',573,'','supplier','1',11750000.00,0.00,'Purchase Id 13 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-08 21:33:01','',''),('1','287',574,'','20','3',2946037.00,0.00,'Sales from shift 113 on 2023-03-09 10:17:48 ','2023-03-09 10:17:48','',''),('1','287',575,'','6.1','4',0.00,2946037.00,'Sales from shift 113 on 2023-03-09 10:17:48 ','2023-03-09 10:17:48','',''),('1','287',576,'','24','1',0.00,11879250.00,'Purchase Id 14 for 50,550.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-09 18:54:16','',''),('1','287',577,'','supplier','1',11879250.00,0.00,'Purchase Id 14 for 50,550.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-09 18:54:16','',''),('1','287',578,'','20','3',2215723.35,0.00,'Sales from shift 114 on 2023-03-10 09:30:19 ','2023-03-10 09:30:19','',''),('1','287',579,'','6.1','4',0.00,2215723.35,'Sales from shift 114 on 2023-03-10 09:30:19 ','2023-03-10 09:30:19','',''),('1','287',580,'','2','6',1401180.00,0.00,'Payment Id 193 for invoice:110, receipt: 0110 by AA RANO NIGERIA LTD','2023-03-10 16:33:00','',''),('1','287',581,'','supplier','1',0.00,1401180.00,'Payment Id 193 for invoice:110, receipt: 0110 by AA RANO NIGERIA LTD','2023-03-10 16:33:00','',''),('1','287',582,'','2','6',1702398.25,0.00,'Payment Id 191 for invoice:109, receipt: 109 by AA RANO NIGERIA LTD','2023-03-10 16:33:00','',''),('1','287',583,'','supplier','1',0.00,1702398.25,'Payment Id 191 for invoice:109, receipt: 109 by AA RANO NIGERIA LTD','2023-03-10 16:33:00','',''),('1','287',584,'','2','6',1887260.00,0.00,'Payment Id 189 for invoice:108, receipt: 0108 by AA RANO NIGERIA LTD','2023-03-10 16:33:00','',''),('1','287',585,'','supplier','1',0.00,1887260.00,'Payment Id 189 for invoice:108, receipt: 0108 by AA RANO NIGERIA LTD','2023-03-10 16:33:00','',''),('1','287',586,'','2','6',1886899.50,0.00,'Payment Id 197 for invoice:111, receipt: 00111 by AA RANO NIGERIA LTD','2023-03-10 16:36:01','',''),('1','287',587,'','supplier','1',0.00,1886899.50,'Payment Id 197 for invoice:111, receipt: 00111 by AA RANO NIGERIA LTD','2023-03-10 16:36:01','',''),('1','287',588,'','2','6',1395783.00,0.00,'Payment Id 198 for invoice:112, receipt: 00112 by AA RANO NIGERIA LTD','2023-03-10 16:37:07','',''),('1','287',589,'','supplier','1',0.00,1395783.00,'Payment Id 198 for invoice:112, receipt: 00112 by AA RANO NIGERIA LTD','2023-03-10 16:37:07','',''),('1','287',590,'','2','6',1557650.00,0.00,'Payment Id 201 for invoice:113, receipt: 000113 by AA RANO NIGERIA LTD','2023-03-10 16:38:12','',''),('1','287',591,'','supplier','1',0.00,1557650.00,'Payment Id 201 for invoice:113, receipt: 000113 by AA RANO NIGERIA LTD','2023-03-10 16:38:12','',''),('1','287',592,'','6.1','4',330000.00,0.00,'Payment Id 199 for invoice:113, receipt: 113 by AA RANO NIGERIA LTD','2023-03-10 16:38:29','',''),('1','287',593,'','supplier','1',0.00,330000.00,'Payment Id 199 for invoice:113, receipt: 113 by AA RANO NIGERIA LTD','2023-03-10 16:38:29','',''),('1','287',594,'','supplier','1',0.00,11879250.00,'Purchase Id 14 for 50,550.00 litters of Petrol - PMS returned to AA RANO NIGERIA LTD','2023-03-11 10:13:06','',''),('1','287',595,'','2','5',792385.00,0.00,'Payment Id 192 for invoice:109, receipt: 0109 by AA RANO NIGERIA LTD','2023-03-11 17:00:37','',''),('1','287',596,'','supplier','1',0.00,792385.00,'Payment Id 192 for invoice:109, receipt: 0109 by AA RANO NIGERIA LTD','2023-03-11 17:00:37','',''),('1','287',597,'','2','5',350450.00,0.00,'Payment Id 190 for invoice:108, receipt: 00108 by AA RANO NIGERIA LTD','2023-03-11 17:00:38','',''),('1','287',598,'','supplier','1',0.00,350450.00,'Payment Id 190 for invoice:108, receipt: 00108 by AA RANO NIGERIA LTD','2023-03-11 17:00:38','',''),('1','287',599,'','2','5',818630.00,0.00,'Payment Id 202 for invoice:114, receipt: 0144 by AA RANO NIGERIA LTD','2023-03-11 17:01:31','',''),('1','287',600,'','supplier','1',0.00,818630.00,'Payment Id 202 for invoice:114, receipt: 0144 by AA RANO NIGERIA LTD','2023-03-11 17:01:31','',''),('1','287',601,'','2','5',1088210.00,0.00,'Payment Id 200 for invoice:113, receipt: 0113 by AA RANO NIGERIA LTD','2023-03-11 17:01:31','',''),('1','287',602,'','supplier','1',0.00,1088210.00,'Payment Id 200 for invoice:113, receipt: 0113 by AA RANO NIGERIA LTD','2023-03-11 17:01:31','',''),('1','287',603,'','2','5',505690.00,0.00,'Payment Id 196 for invoice:112, receipt: 0112 by AA RANO NIGERIA LTD','2023-03-11 17:01:31','',''),('1','287',604,'','supplier','1',0.00,505690.00,'Payment Id 196 for invoice:112, receipt: 0112 by AA RANO NIGERIA LTD','2023-03-11 17:01:31','',''),('1','287',605,'','2','5',1244880.00,0.00,'Payment Id 195 for invoice:111, receipt: 0111 by AA RANO NIGERIA LTD','2023-03-11 17:01:31','',''),('1','287',606,'','supplier','1',0.00,1244880.00,'Payment Id 195 for invoice:111, receipt: 0111 by AA RANO NIGERIA LTD','2023-03-11 17:01:31','',''),('1','287',607,'','2','5',502515.00,0.00,'Payment Id 194 for invoice:110, receipt: 110 by AA RANO NIGERIA LTD','2023-03-11 17:01:31','',''),('1','287',608,'','supplier','1',0.00,502515.00,'Payment Id 194 for invoice:110, receipt: 110 by AA RANO NIGERIA LTD','2023-03-11 17:01:31','',''),('1','287',609,'','20','3',2029142.75,0.00,'Sales from shift 115 on 2023-03-11 17:03:13 ','2023-03-11 17:03:13','',''),('1','287',610,'','6.1','4',0.00,2029142.75,'Sales from shift 115 on 2023-03-11 17:03:13 ','2023-03-11 17:03:13','',''),('1','287',611,'','24','1',0.00,10704250.00,'Purchase Id 17 for 45,550.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-11 17:03:59','',''),('1','287',612,'','supplier','1',10704250.00,0.00,'Purchase Id 17 for 45,550.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-11 17:03:59','',''),('1','287',613,'','20','3',3383654.55,0.00,'Sales from shift 116 on 2023-03-12 21:55:31 ','2023-03-12 21:55:31','',''),('1','287',614,'','6.1','4',0.00,3383654.55,'Sales from shift 116 on 2023-03-12 21:55:31 ','2023-03-12 21:55:31','',''),('1','287',615,'','20','3',2812250.95,0.00,'Sales from shift 117 on 2023-03-14 08:27:28 ','2023-03-14 08:27:28','',''),('1','287',616,'','6.1','4',0.00,2812250.95,'Sales from shift 117 on 2023-03-14 08:27:28 ','2023-03-14 08:27:28','',''),('1','287',617,'','2','5',684770.00,0.00,'Payment Id 211 for invoice:118, receipt: 118 by AA RANO NIGERIA LTD','2023-03-15 15:21:05','',''),('1','287',618,'','supplier','1',0.00,684770.00,'Payment Id 211 for invoice:118, receipt: 118 by AA RANO NIGERIA LTD','2023-03-15 15:21:05','',''),('1','287',619,'','2','5',1665005.00,0.00,'Payment Id 208 for invoice:117, receipt: 117 by AA RANO NIGERIA LTD','2023-03-15 15:21:05','',''),('1','287',620,'','supplier','1',0.00,1665005.00,'Payment Id 208 for invoice:117, receipt: 117 by AA RANO NIGERIA LTD','2023-03-15 15:21:05','',''),('1','287',621,'','2','5',1148195.00,0.00,'Payment Id 206 for invoice:116, receipt: 116 by AA RANO NIGERIA LTD','2023-03-15 15:21:05','',''),('1','287',622,'','supplier','1',0.00,1148195.00,'Payment Id 206 for invoice:116, receipt: 116 by AA RANO NIGERIA LTD','2023-03-15 15:21:05','',''),('1','287',623,'','2','5',558230.00,0.00,'Payment Id 204 for invoice:115, receipt: 115 by AA RANO NIGERIA LTD','2023-03-15 15:21:06','',''),('1','287',624,'','supplier','1',0.00,558230.00,'Payment Id 204 for invoice:115, receipt: 115 by AA RANO NIGERIA LTD','2023-03-15 15:21:06','',''),('1','287',625,'','6.1','4',118500.00,0.00,'Payment Id 210 for invoice:117, receipt: 00117 by AA RANO NIGERIA LTD','2023-03-15 15:21:23','',''),('1','287',626,'','supplier','1',0.00,118500.00,'Payment Id 210 for invoice:117, receipt: 00117 by AA RANO NIGERIA LTD','2023-03-15 15:21:23','',''),('1','287',627,'','20','3',2938663.50,0.00,'Sales from shift 118 on 2023-03-15 18:09:27 ','2023-03-15 18:09:27','',''),('1','287',628,'','6.1','4',0.00,2938663.50,'Sales from shift 118 on 2023-03-15 18:09:27 ','2023-03-15 18:09:27','',''),('1','287',629,'','20','3',2919651.95,0.00,'Sales from shift 119 on 2023-03-16 09:08:02 ','2023-03-16 09:08:02','',''),('1','287',630,'','6.1','4',0.00,2919651.95,'Sales from shift 119 on 2023-03-16 09:08:02 ','2023-03-16 09:08:02','',''),('1','287',631,'','24','1',0.00,11750000.00,'Purchase Id 18 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-16 09:15:35','',''),('1','287',632,'','supplier','1',11750000.00,0.00,'Purchase Id 18 for 50,000.00 litters of Petrol - PMS from AA RANO NIGERIA LTD','2023-03-16 09:15:35','',''),('1','287',633,'','2','5',0.00,684770.00,'Payment Id 211 for invoice:118, receipt: 118 by AA RANO NIGERIA LTD','2023-03-16 14:09:06','',''),('1','287',634,'','supplier','1',684770.00,0.00,'Payment Id 211 for invoice:118, receipt: 118 by AA RANO NIGERIA LTD','2023-03-16 14:09:06','',''),('1','287',635,'','2','6',770741.00,0.00,'Payment Id 209 for invoice:117, receipt: 0117 by AA RANO NIGERIA LTD','2023-03-16 15:26:46','',''),('1','287',636,'','supplier','1',0.00,770741.00,'Payment Id 209 for invoice:117, receipt: 0117 by AA RANO NIGERIA LTD','2023-03-16 15:26:46','',''),('1','287',637,'','2','6',2235462.00,0.00,'Payment Id 207 for invoice:116, receipt: 0116 by AA RANO NIGERIA LTD','2023-03-16 15:26:46','',''),('1','287',638,'','supplier','1',0.00,2235462.00,'Payment Id 207 for invoice:116, receipt: 0116 by AA RANO NIGERIA LTD','2023-03-16 15:26:46','',''),('1','287',639,'','2','6',1322164.50,0.00,'Payment Id 205 for invoice:115, receipt: 0115 by AA RANO NIGERIA LTD','2023-03-16 15:26:46','',''),('1','287',640,'','supplier','1',0.00,1322164.50,'Payment Id 205 for invoice:115, receipt: 0115 by AA RANO NIGERIA LTD','2023-03-16 15:26:46','',''),('1','287',641,'','2','6',1397092.12,0.00,'Payment Id 203 for invoice:114, receipt: 114 by AA RANO NIGERIA LTD','2023-03-16 15:26:46','',''),('1','287',642,'','supplier','1',0.00,1397092.12,'Payment Id 203 for invoice:114, receipt: 114 by AA RANO NIGERIA LTD','2023-03-16 15:26:46','',''),('1','287',643,'','6.1','4',410000.00,0.00,'Payment Id 216 for invoice:118, receipt: 0.0118 by AA RANO NIGERIA LTD','2023-03-17 14:27:19','',''),('1','287',644,'','supplier','1',0.00,410000.00,'Payment Id 216 for invoice:118, receipt: 0.0118 by AA RANO NIGERIA LTD','2023-03-17 14:27:19','',''),('1','287',645,'','2','5',684770.00,0.00,'Payment Id 214 for invoice:118, receipt: 00118 by AA RANO NIGERIA LTD','2023-03-17 14:27:20','',''),('1','287',646,'','supplier','1',0.00,684770.00,'Payment Id 214 for invoice:118, receipt: 00118 by AA RANO NIGERIA LTD','2023-03-17 14:27:20','','');
/*!40000 ALTER TABLE `ledgers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `options`
--

DROP TABLE IF EXISTS `options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `options` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` bigint NOT NULL,
  `station_id` bigint NOT NULL,
  `option_key` varchar(200) NOT NULL,
  `option_value` longtext,
  `thedate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `station_id` (`station_id`,`option_key`),
  KEY `company_id` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `options`
--

LOCK TABLES `options` WRITE;
/*!40000 ALTER TABLE `options` DISABLE KEYS */;
/*!40000 ALTER TABLE `options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `measurement` varchar(20) NOT NULL,
  `quantity2` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`code`,`name`,`measurement`,`quantity2`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `cleanup` (`cleanup`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'1','287','PMS','Petrol','Litres',0,235.00,235.00,235.00,235.00,0.00,0,'2022-10-22 13:40:34','178','178','2022-10-22 13:40:34',0),(2,'1','287','AGO','Diesel','Litres',0,790.00,790.00,790.00,790.00,0.00,0,'2022-10-22 13:49:12','178','178','2022-10-22 13:49:12',0);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_changevalues`
--

DROP TABLE IF EXISTS `products_changevalues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_changevalues` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `change_id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity` bigint NOT NULL,
  `oldrate` decimal(20,2) NOT NULL,
  `newrate` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`change_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_changevalues`
--

LOCK TABLES `products_changevalues` WRITE;
/*!40000 ALTER TABLE `products_changevalues` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_changevalues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_prices`
--

DROP TABLE IF EXISTS `products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_prices`
--

LOCK TABLES `products_prices` WRITE;
/*!40000 ALTER TABLE `products_prices` DISABLE KEYS */;
INSERT INTO `products_prices` VALUES (1,'1','287',1,180.00,0.00,0.00,0.00,'Cost from purchase id #1','2022-10-27 11:18:29','648'),(2,'1','287',2,770.00,0.00,0.00,0.00,'Cost from purchase id #4','2022-10-28 07:08:49','648'),(3,'1','287',1,180.00,180.00,180.00,180.00,'','2022-11-02 10:01:19','968'),(4,'1','287',2,770.00,770.00,770.00,770.00,'','2022-11-02 10:02:19','968'),(5,'1','287',2,800.00,800.00,800.00,800.00,'','2022-11-11 12:00:59','968'),(6,'1','287',2,825.00,825.00,825.00,825.00,'','2022-11-16 20:00:02','968'),(7,'1','287',2,840.00,840.00,840.00,840.00,'','2022-11-23 09:54:46','968'),(8,'1','287',1,210.00,210.00,210.00,210.00,'','2022-11-23 09:55:33','968'),(9,'1','287',2,825.00,825.00,825.00,825.00,'','2022-11-24 09:39:10','968'),(10,'1','287',2,840.00,840.00,840.00,840.00,'','2022-11-24 11:37:09','968'),(11,'1','287',2,820.00,820.00,820.00,820.00,'DECREMENT','2022-12-17 15:26:36','968'),(12,'1','287',2,830.00,830.00,830.00,830.00,'','2023-01-20 08:10:55','968'),(13,'1','287',2,790.00,790.00,790.00,790.00,'','2023-02-01 08:01:13','968'),(14,'1','287',2,810.00,810.00,810.00,810.00,'INCREMENT','2023-02-06 23:54:23','968'),(15,'1','287',2,800.00,800.00,800.00,800.00,'','2023-03-01 18:38:28','968'),(16,'1','287',1,235.00,235.00,235.00,235.00,'','2023-03-01 18:39:14','968'),(17,'1','287',2,810.00,810.00,810.00,810.00,'','2023-03-02 07:12:05','968'),(18,'1','287',2,800.00,800.00,800.00,800.00,'','2023-03-06 10:06:34','968'),(19,'1','287',2,790.00,790.00,790.00,790.00,'','2023-03-13 07:06:38','968');
/*!40000 ALTER TABLE `products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_reconciliations`
--

DROP TABLE IF EXISTS `products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_reconciliations`
--

LOCK TABLES `products_reconciliations` WRITE;
/*!40000 ALTER TABLE `products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_shortages`
--

DROP TABLE IF EXISTS `products_shortages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_shortages` (
  `shortage_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shortagedate` date NOT NULL,
  `product_id` varchar(10) NOT NULL,
  `type` int NOT NULL DEFAULT '0',
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`shortage_id`),
  KEY `companycode` (`company_id`,`shortagedate`,`product_id`,`rate`,`quantity`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_shortages`
--

LOCK TABLES `products_shortages` WRITE;
/*!40000 ALTER TABLE `products_shortages` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_shortages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pts_nozzles`
--

DROP TABLE IF EXISTS `pts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pts_nozzles` (
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pts_id` int NOT NULL,
  `pump` varchar(20) NOT NULL,
  `code` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `last_volume` decimal(20,2) NOT NULL,
  `last_price` decimal(20,2) NOT NULL,
  `last_amount` decimal(20,2) NOT NULL,
  `last_transaction` int NOT NULL DEFAULT '0',
  `total_volume` decimal(20,2) NOT NULL,
  `total_amount` decimal(20,2) NOT NULL,
  `total_transactions` decimal(20,2) NOT NULL,
  `lastconnect` datetime NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `terminal_id` (`pts_id`,`pump`,`code`,`lastconnect`),
  KEY `companycode` (`company_id`,`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pts_nozzles`
--

LOCK TABLES `pts_nozzles` WRITE;
/*!40000 ALTER TABLE `pts_nozzles` DISABLE KEYS */;
/*!40000 ALTER TABLE `pts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases`
--

DROP TABLE IF EXISTS `purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases`
--

LOCK TABLES `purchases` WRITE;
/*!40000 ALTER TABLE `purchases` DISABLE KEYS */;
INSERT INTO `purchases` VALUES (1,'1','287','2022-09-17',1,1,180.00,50000.00,0.00,0.00,9000000.00,0.00,'','','RAN849XA','','','','2022-10-27 10:58:44',15,'','968','','0000-00-00 00:00:00','648','2022-10-27 11:18:29'),(2,'1','287','2022-09-24',1,1,180.00,50000.00,0.00,0.00,9000000.00,0.00,'','','RAN 849 XA','','','','2022-10-27 11:35:00',15,'','968','','0000-00-00 00:00:00','648','2022-10-28 07:09:30'),(3,'1','287','2022-09-24',1,1,180.00,50000.00,0.00,0.00,9000000.00,0.00,'','','','','','','2022-10-27 12:46:21',2,'','968','','0000-00-00 00:00:00','648','2022-10-28 07:11:04'),(4,'1','287','2022-09-26',2,1,770.00,19900.00,0.00,0.00,15323000.00,0.00,'','','NSR 70 ZQ','','','','2022-10-27 19:02:24',15,'PURCHASE 0F AGO','968','','0000-00-00 00:00:00','648','2022-10-28 07:08:49'),(5,'1','287','2022-10-11',1,1,180.00,50000.00,0.00,0.00,9000000.00,0.00,'','','RAN 849 XA','','','','2022-10-29 14:47:16',15,'PURCHASE OF PMS','968','','0000-00-00 00:00:00','648','2022-11-02 18:59:22'),(6,'1','287','2022-10-18',1,1,180.00,50000.00,0.00,0.00,9000000.00,0.00,'','','RAN 849 XA','','','','2022-10-30 13:34:47',15,'PURCHASE OF PMS','968','','0000-00-00 00:00:00','648','2022-11-02 19:03:57'),(7,'1','287','2022-10-18',1,1,180.00,50000.00,0.00,0.00,9000000.00,0.00,'','','NSR 75 ZS','','','','2022-10-30 13:35:48',15,'PURCHASE OF PMS','968','','0000-00-00 00:00:00','648','2022-11-02 19:01:14'),(8,'1','287','2022-10-22',1,1,180.00,50000.00,0.00,0.00,9000000.00,0.00,'','','NSR 75 ZS','','','','2022-10-30 13:36:46',15,'PURCHASE OF PMS','968','','0000-00-00 00:00:00','648','2022-11-02 19:00:10'),(9,'1','287','2022-11-23',1,1,210.00,60000.00,0.00,0.00,12600000.00,0.00,'','0860','KMC 662 ZE','','','','2022-11-23 18:25:13',15,'','968','','0000-00-00 00:00:00','648','2022-11-24 04:39:39'),(10,'1','287','2022-11-23',1,1,210.00,60000.00,0.00,0.00,12600000.00,0.00,'','0861','KMC 664 ZE','','','','2022-11-23 18:25:58',15,'','968','','0000-00-00 00:00:00','648','2022-11-24 04:39:21'),(11,'1','287','2023-03-01',1,1,235.00,50000.00,0.00,0.00,11750000.00,0.00,'','0926','RAN 922 XA','','','','2023-03-02 09:59:08',15,'','968','','0000-00-00 00:00:00','648','2023-03-02 12:54:33'),(12,'1','287','2023-03-05',2,1,800.00,15000.00,0.00,0.00,12000000.00,0.00,'','28052','KMC 662 ZE','','','','2023-03-06 10:21:09',15,'RECEIVED 15000, TRUCK DELIVERED AFTER PH03.','968','','0000-00-00 00:00:00','648','2023-03-08 21:32:21'),(13,'1','287','2023-03-08',1,1,235.00,50000.00,0.00,0.00,11750000.00,0.00,'','62657498','KMC 571 ZU','','','','2023-03-08 09:17:30',15,'','968','','0000-00-00 00:00:00','648','2023-03-08 21:33:01'),(14,'1','287','2023-03-09',1,1,235.00,50550.00,0.00,0.00,11879250.00,0.00,'','2005468','NSR 515 ZU','','','','2023-03-09 18:45:21',2,'','968','','0000-00-00 00:00:00','648','2023-03-11 10:13:06'),(15,'1','287','2023-03-09',1,1,235.00,50550.00,0.00,0.00,11879250.00,0.00,'','2005468','NSR 515 ZU','','','','2023-03-09 18:45:25',0,'','968','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(16,'1','287','2023-03-09',1,1,235.00,50550.00,0.00,0.00,11879250.00,0.00,'','2005468','NSR 515 ZU','','','','2023-03-09 18:45:41',0,'','968','648','2023-03-11 10:14:09','','0000-00-00 00:00:00'),(17,'1','287','2023-03-09',1,1,235.00,45550.00,0.00,0.00,10704250.00,0.00,'','2005468','NSR 515 ZU','','','','2023-03-11 14:54:03',15,'','968','','0000-00-00 00:00:00','648','2023-03-11 17:03:59'),(18,'1','287','2023-03-15',1,1,235.00,50000.00,0.00,0.00,11750000.00,0.00,'','2007582','KMC 571 ZU','','','','2023-03-16 08:03:05',10,'','968','','0000-00-00 00:00:00','648','2023-03-16 09:15:35');
/*!40000 ALTER TABLE `purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_payments`
--

DROP TABLE IF EXISTS `purchases_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `supplier_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`supplier_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=220 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_payments`
--

LOCK TABLES `purchases_payments` WRITE;
/*!40000 ALTER TABLE `purchases_payments` DISABLE KEYS */;
INSERT INTO `purchases_payments` VALUES (5,'1','287','2022-09-24',1,'0007','','2',49000.00,'7','','','','','',0.00,'2022-11-05 08:49:30',5,'RAN 849 XA','968','','0000-00-00 00:00:00','975','2022-11-19 16:08:13'),(23,'1','287','2022-09-23',1,'0345','','5',1753065.00,'3/4/5','','','5','PORTHARCOURT 1','0345',2445664.00,'2022-11-11 08:10:12',5,'PAYMENT FOR 3/4/5','968','975','2022-11-17 13:50:47','975','2022-11-19 15:54:05'),(24,'1','287','2022-09-26',1,'06789','','5',2044950.00,'6/7/8/9/10/11','','','5','PORTHARCOURT 1','06789',3808845.00,'2022-11-11 08:15:48',5,'PAYMENT FOR 6/7/8/9/10/11','968','975','2022-11-19 16:12:41','975','2022-11-19 16:22:06'),(25,'1','287','2022-09-26',1,'0012','','5',437970.00,'12','','','5','PORTHARCOURT 1','0012',646309.80,'2022-11-11 08:17:29',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 16:08:13'),(26,'1','287','2022-09-27',1,'0013','','5',434690.00,'13','','','5','PORTHARCOURT 1','0013',649638.00,'2022-11-11 08:18:37',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 14:27:33'),(27,'1','287','2022-09-27',1,'0014','','5',303900.00,'14','','','5','PORTHARCOURT 1','0014',597324.60,'2022-11-11 08:20:07',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 14:27:33'),(28,'1','287','2022-09-30',1,'015/16/17/18','','5',1423220.00,'15/16/17/18','','','5','PORTHARCOURT 1','015/16/17/18',1893509.30,'2022-11-11 08:31:38',5,'PAYMENT FOR 15/16/17/18','968','975','2022-11-19 16:24:43','975','2022-11-19 16:25:27'),(29,'1','287','2022-10-04',1,'0020','','5',269700.00,'20','','','5','PORTHARCOURT 1','0020',417297.60,'2022-11-11 09:40:44',5,'CASH TO BANK','968','','0000-00-00 00:00:00','975','2022-11-19 14:53:41'),(30,'1','287','2022-10-05',1,'00021','','5',141700.00,'21','','','5','PORTHARCOURT 1','00021',458814.40,'2022-11-11 09:42:37',5,'CASH TO BANK','968','975','2022-11-19 14:56:01','975','2022-11-19 14:57:33'),(31,'1','287','2022-10-05',1,'00022','','5',357480.00,'22','','','5','PORTHARCOURT 1','00022',546832.80,'2022-11-11 09:44:45',5,'CASH TO BANK','968','975','2022-11-19 14:56:55','975','2022-11-19 14:57:33'),(32,'1','287','2022-10-06',1,'00023','','5',222720.00,'23','','','5','PORTHARCOURT 1','00023',485026.20,'2022-11-11 09:46:55',5,'CASH TO BANK','968','','0000-00-00 00:00:00','975','2022-11-19 15:00:28'),(33,'1','287','2022-09-22',1,'004','','10',326700.00,'4','','','6','PORTHARCOURT 1','004',0.00,'2022-11-14 13:50:50',5,'POS PAYMENT','968','','0000-00-00 00:00:00','975','2022-11-19 15:54:05'),(34,'1','287','2022-09-23',1,'05/6','','10',485038.00,'5/6','','','6','PORTHARCOURT 1','05/6',0.00,'2022-11-14 13:52:42',5,'POS PAYMENT','968','','0000-00-00 00:00:00','975','2022-11-19 15:54:05'),(35,'1','287','2022-09-24',1,'07/8','','10',403325.00,'7/8','','','6','PORTHARCOURT 1','07/8',0.00,'2022-11-14 13:54:27',5,'POS PAYMENT','968','','0000-00-00 00:00:00','975','2022-11-19 16:08:13'),(36,'1','287','2022-09-25',1,'09/10','','10',434793.00,'9/10','','','6','PORTHARCOURT 1','09/10',0.00,'2022-11-14 13:56:20',5,'POS PAYMENT','968','','0000-00-00 00:00:00','975','2022-11-19 16:08:13'),(38,'1','287','2022-09-26',1,'011/12','','5',364623.00,'11/12','','','6','PORTHARCOURT 1','POS',0.00,'2022-11-14 14:07:47',5,'POS PAYMENT','968','975','2022-11-19 16:14:01','975','2022-11-19 16:22:06'),(39,'1','287','2022-09-27',1,'013/14','','10',381845.00,'13/14','','','6','PORTHARCOURT 1','013/14',0.00,'2022-11-14 14:11:05',5,'POS PAYMENT','968','','0000-00-00 00:00:00','975','2022-11-19 14:27:33'),(40,'1','287','2022-09-28',1,'015/16','','10',323700.00,'15/16','','','6','PORTHARCOURT 1','015/16',0.00,'2022-11-14 14:12:40',5,'POS PAYMENT','968','','0000-00-00 00:00:00','975','2022-11-19 16:23:51'),(41,'1','287','2022-09-29',1,'017/18','','10',603807.00,'17/18','','','6','PORTHARCOURT 1','017/18',0.00,'2022-11-14 14:15:27',5,'POS PAYMENT','968','','0000-00-00 00:00:00','975','2022-11-19 16:23:51'),(42,'1','287','2022-09-30',1,'019','','10',410600.00,'19','','','6','PORTHARCOURT 1','019',0.00,'2022-11-14 14:21:35',5,'POS PAYMENT FOR THIS SHIFT\r\n30/09/2022 EOD 310600\r\nOUT OF CASH AT HAND\r\nPOS WITHDRAWAL OF 100000\r\n01/10/2022 SATURDAY','968','','0000-00-00 00:00:00','975','2022-11-19 16:23:51'),(43,'1','287','2022-10-04',1,'020','','10',138290.00,'20','','','6','PORTHARCOURT 1','020',0.00,'2022-11-14 14:29:01',5,'POS PAYMENT','968','','0000-00-00 00:00:00','975','2022-11-19 14:53:41'),(44,'1','287','2022-10-05',1,'021/22','','10',461179.00,'21/22','','','6','PORTHARCOURT 1','021/22',0.00,'2022-11-14 14:30:42',5,'POS PAYMENT','968','','0000-00-00 00:00:00','975','2022-11-19 14:57:33'),(45,'1','287','2022-10-06',1,'024','','5',363350.00,'24','','','5','PORTHARCOURT 1','024',778116.10,'2022-11-14 14:37:59',5,'EBILLS','968','','0000-00-00 00:00:00','975','2022-11-19 15:00:28'),(46,'1','287','2022-10-06',1,'023/24','','10',510310.00,'23/24','','','6','PORTHARCOURT 1','023/24',0.00,'2022-11-14 14:40:15',5,'POS PAYMENT','968','','0000-00-00 00:00:00','975','2022-11-19 15:00:28'),(47,'1','287','2022-10-07',1,'025','','5',273795.00,'25','','','5','PORTHARCOURT 1','025',530803.60,'2022-11-14 14:42:46',5,'','968','975','2022-11-19 15:07:25','975','2022-11-19 15:09:04'),(48,'1','287','2022-10-07',1,'026','','5',303310.00,'26','','','5','PORTHARCOURT 1','026',552670.20,'2022-11-14 14:44:31',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:09:04'),(49,'1','287','2022-10-07',1,'025/26','','10',392420.00,'25/26','','','6','PORTHARCOURT 1','025/26',0.00,'2022-11-14 14:46:18',5,'POS PAYMENT','968','','0000-00-00 00:00:00','975','2022-11-19 15:09:04'),(50,'1','287','2022-10-08',1,'027','','5',335050.00,'27','','','5','PORTHARCOURT 1','027',513605.10,'2022-11-14 14:47:46',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:11:32'),(51,'1','287','2022-10-08',1,'029','','5',264250.00,'29','','','5','PORTHARCOURT 1','029',480798.00,'2022-11-14 14:49:23',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:11:32'),(52,'1','287','2022-10-08',1,'027/29','','10',356644.00,'27/29','','','6','PORTHARCOURT 1','027/29',0.00,'2022-11-14 14:50:21',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:11:32'),(53,'1','287','2022-10-09',1,'030','','5',209300.00,'30','','','5','PORTHARCOURT 1','030',271107.00,'2022-11-14 14:52:13',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:14:59'),(54,'1','287','2022-10-09',1,'031','','5',265210.00,'31','','','5','PORTHARCOURT 1','031',623635.90,'2022-11-14 14:53:40',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:14:59'),(55,'1','287','2022-10-09',1,'030/31','','5',362077.00,'30/31','','','6','PORTHARCOURT 1','030/31',0.00,'2022-11-14 14:54:47',5,'POS PAYMENT','968','975','2022-11-14 15:08:16','975','2022-11-19 15:14:59'),(56,'1','287','2022-10-10',1,'032','','5',175260.00,'32','','','5','PORTHARCOURT 1','032',306957.60,'2022-11-14 14:58:25',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:15:46'),(57,'1','287','2022-10-10',1,'033','','5',363060.00,'33','','','5','PORTHARCOURT 1','033',620698.10,'2022-11-14 14:59:22',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:15:46'),(58,'1','287','2022-10-10',1,'032/33','','10',350840.00,'32/33','','','6','PORTHARCOURT 1','032/33',0.00,'2022-11-14 15:00:35',5,'POS PAYMENT','968','','0000-00-00 00:00:00','975','2022-11-19 15:15:46'),(59,'1','287','2022-10-11',1,'034','','5',299200.00,'34','','','5','PORTHARCOURT 1','034',472718.00,'2022-11-14 15:01:44',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:16:41'),(60,'1','287','2022-10-11',1,'035','','5',400100.00,'35','','','5','PORTHARCOURT 1','035',589168.80,'2022-11-14 15:03:15',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:16:41'),(61,'1','287','2022-10-11',1,'034/35','','10',328987.00,'34/35','','','6','PORTHARCOURT 1','034/35',0.00,'2022-11-14 15:04:35',5,'POS PAYMENT','968','','0000-00-00 00:00:00','975','2022-11-19 15:16:41'),(62,'1','287','2022-10-12',1,'036','','5',276860.00,'36','','','5','PORTHARCOURT 1','036',423387.00,'2022-11-14 15:07:09',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:17:25'),(63,'1','287','2022-10-12',1,'037','','5',432900.00,'37','','','5','PORTHARCOURT 1','037',747431.80,'2022-11-14 15:08:14',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:17:25'),(64,'1','287','2022-10-12',1,'036/37','','10',419377.00,'36/37','','','6','PORTHARCOURT 1','036/37',0.00,'2022-11-14 15:09:53',5,'POS PAYMENT','968','','0000-00-00 00:00:00','975','2022-11-19 15:17:25'),(65,'1','287','2022-10-13',1,'038','','5',235420.00,'38','','','5','PORTHARCOURT 1','038',523011.40,'2022-11-14 15:12:04',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:18:13'),(66,'1','287','2022-10-13',1,'039','','5',447770.00,'39','','','5','PORTHARCOURT 1','039',708327.00,'2022-11-14 15:13:21',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:18:13'),(67,'1','287','2022-10-13',1,'038/39','','5',393654.00,'38/39','','','5','PORTHARCOURT 1','038/39',0.00,'2022-11-14 15:15:01',5,'POS PAYMENT','968','','0000-00-00 00:00:00','975','2022-11-19 15:18:13'),(68,'1','287','2022-10-14',1,'040','','5',273595.00,'40','','','5','PORTHARCOURT 1','040',618175.20,'2022-11-14 15:19:03',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 16:27:19'),(69,'1','287','2022-10-14',1,'041','','5',438900.00,'41','','','5','PORTHARCOURT 1','041',706917.00,'2022-11-14 15:20:19',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 16:27:19'),(70,'1','287','2022-10-14',1,'040/41','','10',489122.00,'40/41','','','6','PORTHARCOURT 1','040/41',0.00,'2022-11-14 15:21:54',5,'POS PAYMENT','968','','0000-00-00 00:00:00','975','2022-11-19 16:27:19'),(71,'1','287','2022-10-15',1,'042','','5',315360.00,'42','','','5','PORTHARCOURT 1','042',565960.00,'2022-11-14 15:24:56',5,'','968','975','2022-11-19 15:19:38','975','2022-11-19 15:19:58'),(72,'1','287','2022-10-15',1,'043','','5',477800.00,'43','','','5','PORTHARCOURT 1','043',784515.20,'2022-11-14 15:27:04',5,'','968','975','2022-11-19 15:19:12','975','2022-11-19 15:19:58'),(73,'1','287','2022-10-15',1,'042/43','','10',517250.00,'42/43','','','6','PORTHARCOURT 1','042/43',0.00,'2022-11-14 15:28:26',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:19:58'),(74,'1','287','2022-10-16',1,'044','','5',504360.00,'44','','','5','PORTHARCOURT 1','044',942091.60,'2022-11-14 15:30:16',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:20:57'),(75,'1','287','2022-10-16',1,'046','','5',806740.00,'46','','','5','PORTHARCOURT 1','046',1315629.00,'2022-11-14 17:47:46',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:20:57'),(76,'1','287','2022-10-16',1,'044/46','','10',904558.17,'44/46','','','6','PORTHARCOURT 1','044/46',0.00,'2022-11-14 17:50:15',5,'POS PAYMENT','968','','0000-00-00 00:00:00','975','2022-11-19 15:20:57'),(77,'1','287','2022-10-17',1,'047','','5',326275.00,'47','','','5','PORTHARCOURT 1','047',545770.40,'2022-11-14 17:51:36',5,'','968','975','2022-11-19 15:22:13','975','2022-11-19 15:25:16'),(78,'1','287','2022-10-17',1,'048','','5',696015.00,'48','','','5','PORTHARCOURT 1','048',1118475.00,'2022-11-14 17:53:35',5,'','968','975','2022-11-19 15:23:29','975','2022-11-19 15:25:16'),(79,'1','287','2022-10-17',1,'047/48','','10',596952.00,'47/48','','','6','PORTHARCOURT 1','047/48',0.00,'2022-11-14 17:55:38',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:25:16'),(80,'1','287','2022-10-18',1,'049','','5',68570.00,'49','','','5','PORTHARCOURT 1','049',197573.40,'2022-11-14 17:59:11',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:29:40'),(81,'1','287','2022-10-18',1,'051','','5',913925.00,'51','','','5','PORTHARCOURT 1','051',1840743.00,'2022-11-14 18:03:06',5,'','968','975','2022-11-19 15:26:05','975','2022-11-19 15:29:40'),(82,'1','287','2022-10-18',1,'049/51','','10',938701.00,'49/51','','','6','PORTHARCOURT 1','049/51',0.00,'2022-11-14 18:05:10',5,'POS PAYMENT','968','','0000-00-00 00:00:00','975','2022-11-19 15:29:40'),(83,'1','287','2022-10-19',1,'052','','5',576930.00,'52','','','5','PORTHARCOURT 1','052',1165493.60,'2022-11-14 18:08:27',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:30:24'),(84,'1','287','2022-10-19',1,'053','','5',666390.00,'53','','','5','PORTHARCOURT 1','053',1060119.00,'2022-11-14 18:10:09',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:30:24'),(85,'1','287','2022-10-19',1,'052/53','','10',944397.00,'52/53','','','6','PORTHARCOURT 1','052/53',0.00,'2022-11-14 18:12:14',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:30:24'),(86,'1','287','2022-10-20',1,'054','','5',814300.00,'54','','','5','PORTHARCOURT 1','054',1798374.00,'2022-11-14 18:16:57',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:31:27'),(87,'1','287','2022-10-20',1,'054','','2',618000.00,'54','','','','','',0.00,'2022-11-15 08:14:16',5,'HAULAGE SERVICES \r\n(BCH 994 XA) 750L AGO + 18000 FEEDING ALLOWANCE. ','968','975','2022-11-19 15:30:48','975','2022-11-19 15:31:27'),(88,'1','287','2022-10-20',1,'055','','5',705080.00,'55','','','5','PORTHARCOURT 1','055',1106454.60,'2022-11-15 08:15:44',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:31:27'),(89,'1','287','2022-10-20',1,'054/55','','10',738726.00,'54/55','','','6','PORTHARCOURT 1','054/55',0.00,'2022-11-15 08:17:06',5,'POS PAYMENT','968','','0000-00-00 00:00:00','975','2022-11-19 15:31:27'),(90,'1','287','2022-10-21',1,'056','','5',470585.00,'56','','','5','PORTHARCOURT 1','056',1018712.40,'2022-11-15 08:18:19',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:32:15'),(91,'1','287','2022-10-21',1,'057','','5',902675.00,'57','','','5','PORTHARCOURT 1','057',1390849.20,'2022-11-15 08:19:21',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:32:15'),(92,'1','287','2022-10-22',1,'058','','5',679440.00,'58','','','5','PORTHARCOURT 1','058',1089337.20,'2022-11-15 08:20:52',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:34:56'),(93,'1','287','2022-10-22',1,'059','','5',816040.00,'59','','','5','PORTHARCOURT 1','059',1245926.72,'2022-11-15 08:21:52',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:34:56'),(94,'1','287','2022-10-22',1,'058/59','','10',751586.00,'58/59','','','6','PORTHARCOURT 1','058/59',0.00,'2022-11-15 08:23:32',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:34:56'),(95,'1','287','2022-10-23',1,'060','','5',612700.00,'60','','','5','PORTHARCOURT 1','060',1057497.00,'2022-11-15 08:24:37',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:35:44'),(96,'1','287','2022-10-23',1,'061','','5',812860.00,'61','','','5','PORTHARCOURT 1','061',1310617.80,'2022-11-15 08:25:51',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:35:44'),(97,'1','287','2022-10-23',1,'060/61','','10',918247.00,'60/61','','','6','PORTHARCOURT 1','060/61',0.00,'2022-11-15 08:27:23',5,'POS PAYMENT','968','','0000-00-00 00:00:00','975','2022-11-19 15:35:44'),(98,'1','287','2022-10-24',1,'062','','5',750470.00,'62','','','5','PORTHARCOURT 1','062',1130013.60,'2022-11-15 08:29:25',5,'SUBSEQUENT PAYMENT OF 86740 MADE','968','','0000-00-00 00:00:00','975','2022-11-19 16:36:14'),(99,'1','287','2022-10-24',1,'0062','','5',86740.00,'62','','','5','PORTHARCOURT 1','0062',0.00,'2022-11-15 08:31:12',5,'ADDITIONAL PAYMENT TO BAL. THE SHIFT','968','975','2022-11-19 15:36:20','975','2022-11-19 15:38:50'),(100,'1','287','2022-10-24',1,'064','','5',1407270.00,'64','','','5','PORTHARCOURT 1','064',1900447.20,'2022-11-15 08:32:49',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:38:50'),(101,'1','287','2022-10-24',1,'062/64','','10',758696.00,'62/64','','','6','PORTHARCOURT 1','062/64',0.00,'2022-11-15 08:34:50',5,'POS PAYMENT','968','','0000-00-00 00:00:00','975','2022-11-19 15:38:50'),(102,'1','287','2022-10-25',1,'065','','5',938430.00,'65','','','5','PORTHARCOURT 1','065',1204751.40,'2022-11-15 08:36:51',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:39:25'),(103,'1','287','2022-10-25',1,'066','','5',1068830.00,'66','','','5','PORTHARCOURT 1','066',1407256.20,'2022-11-15 08:44:05',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:39:25'),(104,'1','287','2022-10-25',1,'065/66','','10',576093.00,'65/66','','','6','PORTHARCOURT 1','065/66',0.00,'2022-11-15 08:45:36',5,'POS PAYMENT','968','','0000-00-00 00:00:00','975','2022-11-19 15:39:25'),(105,'1','287','2022-10-26',1,'067','','5',936200.00,'67','','','5','PORTHARCOURT 1','067',1418584.40,'2022-11-15 08:46:56',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:40:23'),(106,'1','287','2022-10-26',1,'068','','5',640380.00,'68','','','5','PORTHARCOURT 1','068',1212283.80,'2022-11-15 08:48:07',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:40:23'),(107,'1','287','2022-10-26',1,'067/68','','10',1027355.31,'67/68','','','6','PORTHARCOURT 1','067/68',0.00,'2022-11-15 08:49:54',5,'POS PAYMENT','968','','0000-00-00 00:00:00','975','2022-11-19 15:41:53'),(108,'1','287','2022-10-27',1,'069','','5',602700.00,'69','','','5','PORTHARCOURT 1','069',956162.40,'2022-11-15 08:51:39',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:41:32'),(109,'1','287','2022-10-27',1,'070','','5',738325.00,'70','','','5','PORTHARCOURT 1','070',1038794.40,'2022-11-15 08:52:45',5,'','968','','0000-00-00 00:00:00','975','2022-11-19 15:41:32'),(110,'1','287','2022-10-27',1,'069/70','','10',560932.00,'69/70','','','6','PORTHARCOURT 1','069/70',0.00,'2022-11-15 08:55:40',5,'POS PAYMENT','968','','0000-00-00 00:00:00','975','2022-11-19 15:41:32'),(111,'1','287','2022-10-28',1,'071/72','','10',626407.00,'71/72','','','6','PORTHARCOURT 1','071/72',0.00,'2022-11-15 09:00:28',5,'POS PAYMENT','968','','0000-00-00 00:00:00','975','2022-11-19 15:44:57'),(112,'1','287','2022-10-29',1,'073/74','','10',555670.00,'73/74','','','6','PORTHARCOURT 1','073/74',0.00,'2022-11-15 09:03:13',5,'POS PAYMENT','968','','0000-00-00 00:00:00','975','2022-11-19 15:44:57'),(113,'1','287','2022-10-30',1,'075','','10',185367.00,'75','','','6','PORTHARCOURT 1','075',0.00,'2022-11-15 09:06:00',5,'POS PAYMENT','968','','0000-00-00 00:00:00','975','2022-11-19 15:44:57'),(114,'1','287','2022-10-31',1,'071/72/73/74/75','','5',2263265.00,'71/72/73/74/75','','','5','PORTHARCOURT 1','071/72/73/74/75',3739453.20,'2022-11-15 09:13:15',5,'SHIFTS: 71. 482260\r\n72. 554065\r\n73. 443515\r\n74. 425020\r\n75. 358405','968','975','2022-11-19 15:44:04','975','2022-11-19 15:44:57'),(115,'1','287','2022-09-21',1,'03/4/5','','5',121686.60,'3/4/5','','','5','PORTHARCOURT 1','03/4/5',0.00,'2022-11-19 14:43:08',5,'','968','975','2022-11-19 15:51:59','975','2022-11-21 10:50:07'),(116,'1','287','2022-09-26',1,'012','','5',15000.00,'12','','','5','PORTHARCOURT 1','012',0.00,'2022-11-19 14:47:09',5,'','968','975','2022-11-19 16:09:26','975','2022-11-21 10:50:07'),(117,'1','287','2022-09-27',1,'13/14','','5',60221.90,'13/14','','','5','PORTHARCOURT 1','13/14',0.00,'2022-11-19 14:55:27',5,'','968','','0000-00-00 00:00:00','975','2022-11-21 10:50:07'),(118,'1','287','2022-09-30',1,'19','','5',121170.40,'19','','','5','PORTHARCOURT 1','19',0.00,'2022-11-19 14:57:56',5,'','968','975','2022-11-19 16:29:06','975','2022-11-21 10:50:07'),(119,'1','287','2022-10-04',1,'20','','5',9347.20,'20','','','5','PORTHARCOURT 1','20',0.00,'2022-11-19 15:18:09',5,'','968','975','2022-11-19 16:29:28','975','2022-11-21 10:50:07'),(120,'1','287','2022-10-05',1,'21','','5',30000.00,'21','','','5','PORTHARCOURT 1','21',0.00,'2022-11-19 15:21:10',5,'','968','975','2022-11-19 16:29:40','975','2022-11-21 10:50:07'),(121,'1','287','2022-10-06',1,'23','','5',21762.30,'23','','','5','PORTHARCOURT 1','23',0.00,'2022-11-19 15:25:08',5,'','968','975','2022-11-19 16:28:53','975','2022-11-21 10:51:54'),(122,'1','287','2022-10-21',1,'056/57','','5',878901.00,'56/57','','','6','PORTHARCOURT 1','056/57',0.00,'2022-11-19 15:39:41',5,'','968','975','2022-11-19 15:46:17','975','2022-11-19 15:46:26'),(123,'1','287','2022-10-07',1,'25','','5',2699.80,'25','','','5','PORTHARCOURT 1','25',0.00,'2022-11-19 15:58:04',5,'INSTEAD OF 26991.8, THE BANK TELLER POSTED 2699.8 OMITTED 1.','968','975','2022-11-19 16:28:43','975','2022-11-21 10:51:53'),(124,'1','287','2022-10-07',1,'0025','','5',24292.00,'25','','','5','PORTHARCOURT 1','0025',0.00,'2022-11-19 15:59:53',5,'THE BALANCE FOR THE OMITTED AMOUNT','968','975','2022-11-19 16:28:30','975','2022-11-21 10:51:53'),(125,'1','287','2022-10-09',1,'31','','5',12000.00,'31','','','5','PORTHARCOURT 1','31',0.00,'2022-11-19 16:04:57',5,'','968','975','2022-11-19 16:28:19','975','2022-11-21 10:51:53'),(126,'1','287','2022-10-13',1,'38','','5',111494.40,'38','','','5','PORTHARCOURT 1','38',0.00,'2022-11-19 16:08:01',5,'','968','975','2022-11-19 16:28:08','975','2022-11-21 10:51:53'),(127,'1','287','2022-10-14',1,'40','','5',85000.00,'40','','','5','PORTHARCOURT 1','40',0.00,'2022-11-19 16:10:39',5,'AGO SUPPLIED TO ELEME + TRANPORT','968','975','2022-11-19 16:27:57','975','2022-11-21 10:51:53'),(128,'1','287','2022-10-19',1,'52','','5',10000.00,'52','','','5','PORTHARCOURT 1','52',0.00,'2022-11-19 16:13:23',5,'FIRE SERVICE INSPECTION','968','975','2022-11-19 16:27:47','975','2022-11-21 10:51:53'),(129,'1','287','2022-10-28',1,'71','','5',4000.00,'71','','','5','PORTHARCOURT 1','71',0.00,'2022-11-19 16:16:21',5,'STAFF SHORTAGE','968','975','2022-11-19 16:27:38','975','2022-11-21 10:51:53'),(130,'1','287','2022-10-30',1,'75','','5',24700.00,'75','','','5','PORTHARCOURT 1','75',0.00,'2022-11-19 16:17:14',5,'','968','975','2022-11-19 16:27:28','975','2022-11-21 10:51:53'),(131,'1','287','2022-10-05',1,'0021','','2',108000.00,'21','','','','','',0.00,'2022-11-21 21:23:54',0,'authority payment of half salary','968','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(132,'1','287','2022-10-18',1,'0051','','2',90000.00,'51','','','','','',926818.00,'2022-11-21 21:30:08',0,'rivers state internal revenue payment\r\nauthority by ALH SANI HADEJIA','968','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(133,'1','287','2022-10-21',1,'0056','','2',130000.00,'56','','','','','',548127.40,'2022-11-21 21:33:17',0,'WEIGHT AND MEASURE','968','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(134,'1','287','2022-10-27',1,'0070','','2',66000.00,'70','','','','','',0.00,'2022-11-21 21:37:37',5,'HAULAGE NSR 448 ZU','968','','0000-00-00 00:00:00','975','2022-11-22 11:18:48'),(135,'1','287','2022-10-27',1,'0070','','2',33000.00,'70','','','','','',0.00,'2022-11-21 21:39:19',5,'RAN 849 XA','968','','0000-00-00 00:00:00','975','2022-11-22 11:18:48'),(136,'1','287','2022-10-07',1,'0025','','2',24250.00,'25','','','','','',0.00,'2022-11-21 21:45:06',5,'RAN 849 XA','968','','0000-00-00 00:00:00','975','2022-11-22 11:18:48'),(137,'1','287','2022-11-16',1,'077','','2',1485000.00,'77','','','','','',1509750.00,'2022-11-25 19:42:06',5,'KMC 691 ZE\r\nKMC 668 ZEHAULAGE SERVICES','968','975','2022-11-28 16:44:10','975','2022-11-28 16:48:29'),(139,'1','287','2022-11-23',1,'079','','2',34400.00,'79','','','','','',234796.80,'2022-11-25 19:51:17',5,'HAULAGE SERVICES\r\nKMC 664 ZE','968','975','2022-11-28 16:53:34','975','2022-11-28 17:07:21'),(140,'1','287','2022-11-23',1,'079','','2',34400.00,'79','','','','','',0.00,'2022-11-25 19:51:18',5,'HAULAGE SERVICES\r\nKMC 664 ZE','968','','0000-00-00 00:00:00','975','2022-11-28 17:07:21'),(141,'1','287','2022-11-23',1,'00079','','5',1566940.00,'79','','','5','PORTHARCOURT 1','00079',2496261.60,'2022-11-25 20:20:40',5,'','968','','0000-00-00 00:00:00','975','2022-11-28 17:07:21'),(142,'1','287','2022-11-23',1,'0/79','','5',929318.00,'79','','','6','PORTHARCOURT 1','POS',0.00,'2022-11-25 20:22:44',5,'','968','975','2022-11-28 16:16:24','975','2022-11-30 16:56:04'),(143,'1','287','2022-11-24',1,'80','','5',1307195.00,'80','','','5','PORTHARCOURT 1','80',2961806.40,'2022-11-25 20:24:09',5,'','968','','0000-00-00 00:00:00','975','2022-11-29 14:53:16'),(144,'1','287','2022-11-24',1,'81','','5',1562070.00,'81','','','5','PORTHARCOURT 1','81',2213160.60,'2022-11-25 20:25:15',5,'','968','','0000-00-00 00:00:00','975','2022-11-29 14:53:16'),(145,'1','287','2022-11-24',1,'80/81','','10',1726822.00,'80/81','','','6','PORTHARCOURT 1','80/81',0.00,'2022-11-25 20:26:48',5,'','968','','0000-00-00 00:00:00','975','2022-11-30 16:56:04'),(146,'1','287','2022-11-24',1,'80','','2',576000.00,'80','','','','','',0.00,'2022-11-25 20:33:06',5,'HAULAGE SERVICES\r\nNSR 450 ZU','968','','0000-00-00 00:00:00','975','2022-11-29 14:48:04'),(147,'1','287','2022-11-23',1,'78','','2',40000.00,'78','','','','','',0.00,'2022-11-26 15:11:00',5,'TRIP ALLOWANCE\r\nKMC 691 ZE\r\nKMC 668 ZE','968','','0000-00-00 00:00:00','975','2022-11-28 17:07:21'),(148,'1','287','2022-11-25',1,'82','','5',1548680.00,'82','','','5','PORTHARCOURT 1','82',2280238.80,'2022-11-27 10:16:09',5,'','968','','0000-00-00 00:00:00','975','2022-11-29 14:54:08'),(149,'1','287','2022-11-25',1,'83','','5',1669410.00,'83','','','5','PORTHARCOURT 1','83',2294667.90,'2022-11-27 10:21:12',5,'','968','','0000-00-00 00:00:00','975','2022-11-29 14:54:08'),(150,'1','287','2022-11-25',1,'82/83','','5',1353818.88,'82/83','','','6','PORTHARCOURT 1','82/83',0.00,'2022-11-27 10:24:46',5,'POS PAYMENT','968','975','2022-11-28 16:40:28','975','2022-11-30 16:56:04'),(151,'1','287','2022-11-27',1,'86','','5',1518410.00,'86','','','5','PORTHARCOURT 1','86',2440964.40,'2022-11-27 16:07:13',5,'','968','','0000-00-00 00:00:00','975','2022-11-29 14:56:42'),(152,'1','287','2022-11-27',1,'87','','5',1433240.00,'87','','','5','PORTHARCOURT 1','87',2849408.10,'2022-11-28 07:16:45',5,'','968','','0000-00-00 00:00:00','975','2022-11-29 14:56:42'),(153,'1','287','2022-11-27',1,'86/87','','10',2338721.25,'86/87','','','6','PORTHARCOURT 1','86/87',0.00,'2022-11-28 07:19:25',5,'POS PAYMENT','968','','0000-00-00 00:00:00','975','2022-11-30 16:56:42'),(154,'1','287','2022-11-28',1,'88','','5',1455680.00,'88','','','5','PORTHARCOURT 1','88',1945051.50,'2022-11-28 15:31:40',5,'','968','','0000-00-00 00:00:00','975','2022-11-29 14:57:56'),(155,'1','287','2022-11-23',1,'78','','2',126000.00,'78','','','','','',0.00,'2022-11-28 17:04:58',5,'AGO CONSUMPTION FOR 5 DAYS','968','','0000-00-00 00:00:00','975','2022-12-08 14:33:20'),(156,'1','287','2022-11-28',1,'89','','5',1360630.00,'89','','','5','PORTHARCOURT 1','89',3014018.70,'2022-11-29 09:01:54',5,'','968','','0000-00-00 00:00:00','975','2022-11-29 14:57:56'),(157,'1','287','2022-11-28',1,'88/89','','10',2064154.00,'88/89','','','6','PORTHARCOURT 1','88/89',0.00,'2022-11-29 09:04:13',5,'POS PAYMENT','968','','0000-00-00 00:00:00','975','2022-12-02 12:12:26'),(158,'1','287','2022-11-28',1,'00089','','2',75600.00,'89','','','','','',0.00,'2022-11-29 09:06:05',5,'AGO CONSUMPTION 90L ','968','','0000-00-00 00:00:00','975','2022-12-08 14:33:20'),(159,'1','287','2022-11-26',1,'84','','5',1432745.00,'84','','','5','PORTHARCOURT 1','84',2110348.80,'2022-11-29 14:59:06',5,'','968','','0000-00-00 00:00:00','975','2022-11-30 16:57:44'),(160,'1','287','2022-11-26',1,'85','','5',1551655.00,'85','','','5','PORTHARCOURT 1','85',2737841.40,'2022-11-29 14:59:56',5,'','968','','0000-00-00 00:00:00','975','2022-11-30 16:57:43'),(161,'1','287','2022-11-26',1,'84/85','','10',1863790.00,'84/85','','','6','PORTHARCOURT 1','84/85',0.00,'2022-11-29 15:01:54',5,'','968','','0000-00-00 00:00:00','975','2022-11-30 16:56:42'),(162,'1','287','2022-11-29',1,'90','','5',535060.00,'90','','','5','PORTHARCOURT 1','90',799173.90,'2022-11-30 07:15:46',5,'','968','','0000-00-00 00:00:00','975','2022-12-02 12:11:52'),(163,'1','287','2022-11-29',1,'91','','5',189340.00,'91','','','5','PORTHARCOURT 1','91',445544.40,'2022-11-30 07:16:32',5,'','968','','0000-00-00 00:00:00','975','2022-12-02 12:11:52'),(164,'1','287','2022-11-29',1,'90/91','','10',517312.00,'90/91','','','6','PORTHARCOURT 1','90/91',0.00,'2022-11-30 07:18:17',5,'POS PAYMENT','968','','0000-00-00 00:00:00','975','2022-12-02 12:11:52'),(165,'1','287','2022-12-01',1,'92','','5',295000.00,'92','','','5','PORTHARCOURT 1','92',737595.60,'2022-12-02 08:19:08',5,'','968','','0000-00-00 00:00:00','975','2022-12-06 11:58:26'),(166,'1','287','2022-12-01',1,'0092','','10',442600.00,'92','','','6','PORTHARCOURT 1','0092',0.00,'2022-12-02 08:24:43',5,'POS PAYMENT','968','','0000-00-00 00:00:00','975','2022-12-08 14:32:45'),(167,'1','287','2022-12-03',1,'93','','10',714000.00,'93','','','6','PORTHARCOURT 1','93',739200.00,'2022-12-04 12:34:02',5,'','968','','0000-00-00 00:00:00','975','2022-12-08 14:32:45'),(168,'1','287','2022-12-03',1,'94','','5',984620.00,'94','','','5','PORTHARCOURT 1','94',984622.80,'2022-12-04 12:37:46',5,'','968','','0000-00-00 00:00:00','975','2022-12-06 11:59:51'),(169,'1','287','2022-11-16',1,'77','','2',24750.00,'77','','','','','',0.00,'2022-12-05 11:11:21',5,'AGO CONSUMPTION 30L','968','','0000-00-00 00:00:00','975','2022-12-06 12:00:36'),(170,'1','287','2022-12-03',1,'93','','2',25200.00,'93','','','','','',0.00,'2022-12-08 12:57:02',5,'AGO CONSUMPTION','968','','0000-00-00 00:00:00','975','2022-12-15 09:37:51'),(171,'1','287','2022-12-14',1,'95','','5',259680.00,'95','','','5','PORTHARCOURT 1','95',299880.00,'2022-12-14 15:26:01',5,'','968','975','2022-12-16 13:39:07','975','2022-12-16 13:39:30'),(172,'1','287','2022-12-14',1,'0095','','2',25200.00,'95','','','','','',0.00,'2022-12-14 15:26:57',5,'AGO CONSUMPTION ','968','','0000-00-00 00:00:00','975','2022-12-16 13:39:30'),(173,'1','287','2022-12-17',1,'96','','10',235500.00,'96','','','6','PORTHARCOURT 1','96',235504.00,'2022-12-18 14:25:42',5,'','968','','0000-00-00 00:00:00','975','2022-12-20 11:40:05'),(174,'1','287','2022-12-17',1,'096','','5',263000.00,'96','','','6','PORTHARCOURT 1','096',0.00,'2022-12-18 14:34:53',5,'','968','975','2022-12-19 12:01:40','975','2022-12-20 11:40:05'),(175,'1','287','2022-12-17',1,'0096','','5',73790.00,'0096','','','5','PORTHARCOURT 1','0096',410598.60,'2022-12-18 14:36:01',5,'','968','975','2022-12-19 12:01:18','975','2022-12-20 11:18:25'),(176,'1','287','2022-12-17',1,'97','','2',73800.00,'97','','','','','',0.00,'2022-12-19 07:53:31',5,'AGO CONSUMPTION','968','','0000-00-00 00:00:00','975','2022-12-23 11:21:32'),(177,'1','287','2022-12-18',1,'98','','5',290990.00,'98','','','5','PORTHARCOURT 1','98',290993.40,'2022-12-21 08:32:22',5,'','968','','0000-00-00 00:00:00','975','2022-12-22 15:29:41'),(178,'1','287','2022-12-28',1,'99','','5',57940.00,'99','','','5','PORTHARCOURT 1','99',531237.00,'2022-12-30 09:59:11',5,'','968','','0000-00-00 00:00:00','975','2023-01-04 13:33:33'),(179,'1','287','2023-01-19',1,'100','','5',1538480.00,'100','','','5','PORTHARCOURT 1','100',1540480.00,'2023-01-20 08:18:39',5,'','968','975','2023-01-25 12:05:55','975','2023-01-25 12:08:19'),(180,'1','287','2023-01-26',1,'101','','10',900000.00,'101','','','6','PORTHARCOURT 1','101',0.00,'2023-01-27 07:51:13',5,'','968','','0000-00-00 00:00:00','975','2023-02-02 16:39:17'),(181,'1','287','2023-01-31',1,'102','','5',435400.00,'102','','','5','PORTHARCOURT 1','102',437407.20,'2023-02-01 08:09:02',5,'','968','975','2023-02-03 11:13:33','975','2023-02-03 11:13:44'),(182,'1','287','2023-02-04',1,'103','','5',171700.00,'103','','','6','PORTHARCOURT 1','103',171698.60,'2023-02-05 08:23:12',5,'','968','975','2023-02-15 11:53:09','975','2023-02-15 12:01:54'),(183,'1','287','2023-02-05',1,'104','','10',250000.00,'104','','','6','PORTHARCOURT 1','104',0.00,'2023-02-06 12:35:10',0,'','968','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(184,'1','287','2023-02-06',1,'105','','5',100243.00,'105','','','6','PORTHARCOURT 1','POS',148837.50,'2023-02-07 08:01:07',5,'','968','975','2023-02-15 12:01:34','975','2023-02-15 12:01:54'),(185,'1','287','2023-02-06',1,'105','','2',48600.00,'105','','','','','',0.00,'2023-02-11 08:07:33',5,'ago consumption','968','','0000-00-00 00:00:00','975','2023-02-15 12:01:54'),(186,'1','287','2023-02-11',1,'106','','5',48600.00,'106','','','6','PORTHARCOURT 1','106',48600.00,'2023-02-15 12:05:18',5,'','968','975','2023-02-18 17:18:01','975','2023-02-18 17:18:17'),(187,'1','287','2023-02-15',1,'107','','10',388600.00,'107','','','6','PORTHARCOURT 1','107',0.00,'2023-02-16 08:22:37',5,'','968','','0000-00-00 00:00:00','975','2023-03-02 14:04:02'),(188,'1','287','2023-03-02',1,'108','','2',565500.00,'108','','','','','',0.00,'2023-03-03 08:57:54',5,'HAULAGE (RAN 922 XA) 250L \r\nHAULAGE (KMC 717 ZJ) 250L\r\nAGO CONSUMPTION 150L ','968','','0000-00-00 00:00:00','975','2023-03-04 13:43:37'),(189,'1','287','2023-03-02',1,'0108','','5',1887260.00,'108','','','6','PORTHARCOURT 1','POS',2746665.65,'2023-03-03 09:29:04',5,'','968','975','2023-03-06 13:37:07','975','2023-03-10 16:33:00'),(190,'1','287','2023-03-02',1,'00108','','5',350450.00,'108','','','5','PORTHARCOURT 1','00108',0.00,'2023-03-03 09:32:01',5,'','968','975','2023-03-06 13:36:42','975','2023-03-11 17:00:38'),(191,'1','287','2023-03-03',1,'109','','10',1702398.25,'109','','','6','PORTHARCOURT 1','109',0.00,'2023-03-06 13:49:32',5,'','968','','0000-00-00 00:00:00','975','2023-03-10 16:33:00'),(192,'1','287','2023-03-03',1,'0109','','5',792385.00,'109','','','5','PORTHARCOURT 1','0109',2494781.15,'2023-03-06 13:50:53',5,'','968','975','2023-03-08 14:12:57','975','2023-03-11 17:00:38'),(193,'1','287','2023-03-04',1,'0110','','10',1401180.00,'110','','','6','PORTHARCOURT 1','0110',0.00,'2023-03-06 13:53:48',5,'','968','','0000-00-00 00:00:00','975','2023-03-10 16:33:00'),(194,'1','287','2023-03-04',1,'110','','5',502515.00,'110','','','5','PORTHARCOURT 1','110',1903697.40,'2023-03-06 13:55:48',5,'','968','975','2023-03-08 14:14:04','975','2023-03-11 17:01:31'),(195,'1','287','2023-03-06',1,'0111','','5',1244880.00,'111','','','5','PORTHARCOURT 1','0111',3131783.90,'2023-03-08 14:23:37',5,'','968','','0000-00-00 00:00:00','975','2023-03-11 17:01:31'),(196,'1','287','2023-03-07',1,'0112','','5',505690.00,'112','','','5','PORTHARCOURT 1','0112',0.00,'2023-03-08 14:24:25',5,'','968','975','2023-03-10 16:36:34','975','2023-03-11 17:01:31'),(197,'1','287','2023-03-06',1,'00111','','10',1886899.50,'111','','','6','PORTHARCOURT 1','00111',0.00,'2023-03-09 08:13:42',5,'','968','','0000-00-00 00:00:00','975','2023-03-10 16:36:01'),(198,'1','287','2023-03-07',1,'00112','','10',1395783.00,'112','','','6','PORTHARCOURT 1','00112',1931288.75,'2023-03-09 08:15:44',5,'','968','','0000-00-00 00:00:00','975','2023-03-10 16:37:07'),(199,'1','287','2023-03-08',1,'113','','2',330000.00,'113','','','','','',0.00,'2023-03-09 08:23:52',5,'HAULAGE SERVICE KMC 571 ZU 250L 10,000\r\nAGO CONSUMPTION 150L','968','','0000-00-00 00:00:00','975','2023-03-10 16:38:29'),(200,'1','287','2023-03-08',1,'0113','','5',1088210.00,'113','','','5','PORTHARCOURT 1','0113',0.00,'2023-03-09 10:17:55',5,'','968','975','2023-03-10 16:37:42','975','2023-03-11 17:01:31'),(201,'1','287','2023-03-08',1,'000113','','10',1557650.00,'113','','','6','PORTHARCOURT 1','000113',2946037.00,'2023-03-09 10:19:33',5,'','968','','0000-00-00 00:00:00','975','2023-03-10 16:38:12'),(202,'1','287','2023-03-09',1,'0144','','5',818630.00,'114','','','5','PORTHARCOURT 1','0114',2215723.35,'2023-03-10 09:38:25',5,'','968','','0000-00-00 00:00:00','975','2023-03-11 17:01:31'),(203,'1','287','2023-03-09',1,'114','','10',1397092.12,'114','','','6','PORTHARCOURT 1','114',0.00,'2023-03-10 09:41:18',5,'','968','','0000-00-00 00:00:00','975','2023-03-16 15:26:46'),(204,'1','287','2023-03-10',1,'115','','5',558230.00,'115','','','5','PORTHARCOURT 1','115',0.00,'2023-03-13 09:37:02',5,'','968','975','2023-03-15 12:11:40','975','2023-03-15 15:21:06'),(205,'1','287','2023-03-10',1,'0115','','10',1322164.50,'115','','','6','PORTHARCOURT 1','0115',2029142.75,'2023-03-13 09:45:15',5,'','968','','0000-00-00 00:00:00','975','2023-03-16 15:26:46'),(206,'1','287','2023-03-11',1,'116','','5',1148195.00,'116','','','5','PORTHARCOURT 1','116',3383654.55,'2023-03-13 09:49:55',5,'','968','','0000-00-00 00:00:00','975','2023-03-15 15:21:05'),(207,'1','287','2023-03-11',1,'0116','','10',2235462.00,'116','','','6','PORTHARCOURT 1','0116',0.00,'2023-03-13 09:54:18',5,'','968','','0000-00-00 00:00:00','975','2023-03-16 15:26:46'),(208,'1','287','2023-03-13',1,'117','','5',1665005.00,'117','','','5','PORTHARCOURT 1','117',2812250.95,'2023-03-15 09:22:51',5,'','968','','0000-00-00 00:00:00','975','2023-03-15 15:21:05'),(209,'1','287','2023-03-13',1,'0117','','5',770741.00,'117','','','6','PORTHARCOURT 1','POS',0.00,'2023-03-15 09:24:01',5,'','968','975','2023-03-16 14:07:30','975','2023-03-16 15:26:46'),(210,'1','287','2023-03-13',1,'00117','','2',118500.00,'117','','','','','',0.00,'2023-03-15 09:25:12',5,'AGO CONSUMPTION 150L','968','','0000-00-00 00:00:00','975','2023-03-15 15:21:23'),(211,'1','287','2023-03-15',1,'118','','5',684770.00,'118','','','5','PORTHARCOURT 1','118',2938663.50,'2023-03-15 09:32:16',2,'','968','','0000-00-00 00:00:00','975','2023-03-15 15:21:05'),(214,'1','287','2023-03-14',1,'00118','','5',684770.00,'118','','','5','PORTHARCOURT 1','00118',2938663.50,'2023-03-17 13:20:29',5,'','968','','0000-00-00 00:00:00','975','2023-03-17 14:27:20'),(215,'1','287','2023-03-14',1,'000118','','10',1843896.00,'118','','','6','PORTHARCOURT 1','000118',0.00,'2023-03-17 13:21:33',0,'','968','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(216,'1','287','2023-03-14',1,'0.0118','','2',410000.00,'118','','','','','',0.00,'2023-03-17 13:33:22',5,'HAULAGE FOR TRN 31 YZ (LPG TRUCK)\r\nAGO 500L AND 15000 TRIP ALLOWANCE','968','','0000-00-00 00:00:00','975','2023-03-17 14:27:19'),(217,'1','287','2023-03-15',1,'0119','','5',615440.00,'119','','','5','PORTHARCOURT 1','0119',2919651.95,'2023-03-17 13:36:40',0,'','968','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(218,'1','287','2023-03-15',1,'00119','','10',1975211.00,'119','','','6','PORTHARCOURT 1','00119',0.00,'2023-03-17 13:37:54',0,'','968','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(219,'1','287','2023-03-15',1,'000119','','2',326000.00,'119','','','','','',0.00,'2023-03-17 13:41:03',0,'KMC 571 ZU \r\n250L 10000 WARRI TP PORT HARCOURT\r\n150L WITHOUT TRIP ALLOWANCE, HAULAGE FOR TRIP TO BAYELSA','968','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `purchases_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_receptions`
--

DROP TABLE IF EXISTS `purchases_receptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_receptions` (
  `bridge_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `purchase_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `loadingdate` datetime NOT NULL,
  `loadingpoint` varchar(100) DEFAULT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `received` decimal(20,2) NOT NULL,
  `distributed` decimal(20,2) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `vessel` varchar(50) NOT NULL,
  `drivername` varchar(30) NOT NULL,
  `driverphone` varchar(30) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`bridge_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`supplier_id`,`loadingdate`,`quantity`,`waybill`,`meterno`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`purchase_id`),
  KEY `truck_id` (`tank_id`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_receptions`
--

LOCK TABLES `purchases_receptions` WRITE;
/*!40000 ALTER TABLE `purchases_receptions` DISABLE KEYS */;
INSERT INTO `purchases_receptions` VALUES (1,'1',1,'287',1,1,'2022-10-27 00:00:00','PORTHARCOURT',17000.00,16250.00,0.00,'','','1','RAN849XA','','','',5,'2022-10-27 12:44:35','968','0000-00-00 00:00:00','','2022-10-27 17:18:03','968'),(2,'1',1,'287',1,1,'2022-10-27 00:00:00','PORTHARCOURT',16500.00,16200.00,0.00,'','','2','RAN849XA','','','',5,'2022-10-27 12:44:35','968','0000-00-00 00:00:00','','2022-10-27 17:18:03','968'),(3,'1',1,'287',1,1,'2022-10-27 00:00:00','PORTHARCOURT',16500.00,16100.00,0.00,'','','3','RAN849XA','','','',5,'2022-10-27 12:44:35','968','0000-00-00 00:00:00','','2022-10-27 17:18:03','968'),(4,'1',2,'287',1,1,'2022-10-29 00:00:00','PORTHARCOURT',17000.00,17000.00,0.00,'','','1','RAN 849 XA','AMMAR','','',5,'2022-10-29 14:57:04','968','0000-00-00 00:00:00','','2022-10-29 14:58:09','968'),(5,'1',2,'287',1,1,'2022-10-29 00:00:00','PORTHARCOURT',16500.00,16500.00,0.00,'','','2','RAN 849 XA','AMMAR','','',5,'2022-10-29 14:57:04','968','0000-00-00 00:00:00','','2022-10-29 14:58:09','968'),(6,'1',2,'287',1,1,'2022-10-29 00:00:00','PORTHARCOURT',16500.00,16500.00,0.00,'','','3','RAN 849 XA','AMMAR','','',5,'2022-10-29 14:57:04','968','0000-00-00 00:00:00','','2022-10-29 14:58:09','968'),(7,'1',4,'287',2,1,'2022-10-29 00:00:00','PORTHARCOURT',19900.00,19900.00,0.00,'','','4','NSR 70 ZQ','AMMAR','','',5,'2022-10-29 15:02:31','968','0000-00-00 00:00:00','','2022-10-29 15:02:55','968'),(8,'1',5,'287',1,1,'2022-11-09 00:00:00','PORTHARCOURT',17000.00,17000.00,0.00,'','','1','RAN 849 XA','AMMAR AHMAD','','',5,'2022-11-09 14:48:37','968','0000-00-00 00:00:00','','2022-11-09 14:54:05','968'),(9,'1',5,'287',1,1,'2022-11-09 00:00:00','PORTHARCOURT',16500.00,16500.00,0.00,'','','2','RAN 849 XA','AMMAR AHMAD','','',5,'2022-11-09 14:48:37','968','0000-00-00 00:00:00','','2022-11-09 14:54:05','968'),(10,'1',5,'287',1,1,'2022-11-09 00:00:00','PORTHARCOURT',16500.00,16500.00,0.00,'','','3','RAN 849 XA','AMMAR AHMAD','','',5,'2022-11-09 14:48:37','968','0000-00-00 00:00:00','','2022-11-09 14:54:05','968'),(11,'1',6,'287',1,1,'2022-11-09 00:00:00','PORTHARCOURT',33000.00,33000.00,0.00,'','','1','RAN 849 XA','AMMAR','','',5,'2022-11-09 14:53:38','968','0000-00-00 00:00:00','','2022-11-11 13:19:56','968'),(12,'1',6,'287',1,1,'2022-11-09 00:00:00','PORTHARCOURT',17000.00,17000.00,0.00,'','','3','RAN 849 XA','AMMAR','','',2,'2022-11-09 14:53:38','968','2022-11-14 09:31:01','968','2022-11-11 13:19:56','968'),(13,'1',7,'287',1,1,'2022-11-11 00:00:00','PORTHARCOURT',16000.00,16000.00,0.00,'','','2','NSR 75 ZS','YAKUBU','','',5,'2022-11-11 15:57:46','968','0000-00-00 00:00:00','','2022-11-11 15:58:23','968'),(14,'1',7,'287',1,1,'2022-11-11 00:00:00','PORTHARCOURT',34000.00,34000.00,0.00,'','','3','NSR 75 ZS','YAKUBU','','',5,'2022-11-11 15:57:46','968','0000-00-00 00:00:00','','2022-11-12 09:20:34','968'),(15,'1',8,'287',1,1,'2022-11-12 00:00:00','PORTHARCOURT',34000.00,34000.00,0.00,'','','1','NSR 75 ZS','YAKUBU','','',5,'2022-11-12 09:40:27','968','0000-00-00 00:00:00','','2022-11-12 09:40:49','968'),(16,'1',8,'287',1,1,'2022-11-12 00:00:00','PORTHARCOURT',16000.00,16000.00,0.00,'','','2','NSR 75 ZS','YAKUBU','','',5,'2022-11-12 09:40:27','968','0000-00-00 00:00:00','','2022-11-12 09:41:10','968'),(17,'1',6,'287',1,1,'2022-11-14 00:00:00','PORTHARCOURT',16000.00,16000.00,0.00,'','','2','RAN 849 XA','AMMAR','','',5,'2022-11-14 09:44:05','968','0000-00-00 00:00:00','','2022-11-14 09:47:55','968'),(18,'1',6,'287',1,1,'2022-11-14 00:00:00','PORTHARCOURT',1000.00,1000.00,0.00,'','','3','RAN 849 XA','AMMAR','','',5,'2022-11-14 09:47:26','968','0000-00-00 00:00:00','','2022-11-14 09:49:59','968'),(19,'1',9,'287',1,1,'2022-11-24 00:00:00','PORTHARCOURT',29700.00,29700.00,0.00,'','','1','KMC 662 ZE','SHEHU BUNKURE','08032273354','',5,'2022-11-24 09:21:02','968','0000-00-00 00:00:00','','2022-11-24 09:21:28','968'),(20,'1',9,'287',1,1,'2022-11-24 00:00:00','PORTHARCOURT',30300.00,30300.00,0.00,'','','2','KMC 662 ZE','SHEHU BUNKURE','08032273354','',5,'2022-11-24 09:21:02','968','0000-00-00 00:00:00','','2022-11-24 09:21:46','968'),(21,'1',10,'287',1,1,'2022-11-24 00:00:00','PORTHARCOURT',7000.00,7500.00,0.00,'','','2','KMC 664 ZE','BASHIR ABUBAKAR','08033872297','',5,'2022-11-24 09:25:53','968','0000-00-00 00:00:00','','2022-11-24 09:26:17','968'),(22,'1',10,'287',1,1,'2022-11-24 00:00:00','PORTHARCOURT',30000.00,30000.00,0.00,'','','3','KMC 664 ZE','BASHIR ABUBAKAR','08033872297','',5,'2022-11-24 09:25:53','968','0000-00-00 00:00:00','','2022-11-24 09:26:17','968'),(23,'1',10,'287',1,1,'2022-11-26 00:00:00','PORTHARCOURT',10000.00,10300.00,0.00,'','','1','KMC 664 ZE','BASHIR ABUBAKAR','08033872297','',5,'2022-11-26 07:32:55','968','0000-00-00 00:00:00','','2022-11-26 07:37:20','968'),(24,'1',10,'287',1,1,'2022-11-26 00:00:00','PORTHARCOURT',13000.00,13000.00,0.00,'','','3','KMC 664 ZE','BASHIR ABUBAKAR','08033872297','',5,'2022-11-26 07:32:55','968','0000-00-00 00:00:00','','2022-11-26 07:37:20','968'),(25,'1',11,'287',1,1,'2023-03-02 00:00:00','WARRI',33500.00,33500.00,0.00,'0926','','1','RAN 922 XA','ISAH AHMAD','08034127601','',5,'2023-03-02 19:23:41','968','0000-00-00 00:00:00','','2023-03-02 19:25:45','968'),(26,'1',11,'287',1,1,'2023-03-02 00:00:00','WARRI',16500.00,16500.00,0.00,'0926','','3','RAN 922 XA','ISAH AHMAD','08034127601','',5,'2023-03-02 19:23:41','968','0000-00-00 00:00:00','','2023-03-02 19:24:47','968'),(27,'1',12,'287',2,1,'2023-03-09 00:00:00','WARRI',15000.00,15000.00,0.00,'','','4','KMC 662 ZE','BASHIR ABUBAKAR','08032273354','',5,'2023-03-09 07:50:40','968','0000-00-00 00:00:00','','2023-03-09 07:56:09','968'),(28,'1',13,'287',1,1,'2023-03-09 00:00:00','PORTHARCOURT',25000.00,25000.00,0.00,'','','1','KMC 571 ZU','AUWAL S RANO','08022792619','',5,'2023-03-09 07:55:12','968','0000-00-00 00:00:00','','2023-03-09 07:55:46','968'),(29,'1',13,'287',1,1,'2023-03-09 00:00:00','PORTHARCOURT',25000.00,25000.00,0.00,'','','3','KMC 571 ZU','AUWAL S RANO','08022792619','',5,'2023-03-09 07:55:12','968','0000-00-00 00:00:00','','2023-03-09 07:55:46','968'),(30,'1',14,'287',1,1,'2023-03-10 00:00:00','WARRI',15200.00,15200.00,0.00,'2005468','','1','NSR 515 ZU','MUBARAK ISAH','08062795955','',2,'2023-03-10 08:17:40','968','2023-03-11 09:45:40','968','2023-03-10 08:18:11','968'),(31,'1',14,'287',1,1,'2023-03-10 00:00:00','WARRI',15100.00,15100.00,0.00,'2005468','','2','NSR 515 ZU','MUBARAK ISAH','08062795955','',2,'2023-03-10 08:17:40','968','2023-03-11 09:45:11','968','2023-03-10 08:18:11','968'),(32,'1',14,'287',1,1,'2023-03-10 00:00:00','WARRI',15250.00,15250.00,0.00,'2005468','','3','NSR 515 ZU','MUBARAK ISAH','08062795955','',2,'2023-03-10 08:17:40','968','2023-03-11 09:44:40','968','2023-03-10 08:18:11','968'),(33,'1',17,'287',1,1,'2023-03-12 00:00:00','WARRI',15200.00,15200.00,0.00,'','','1','NSR 515 ZU','MUBARAK ISAH','08062795955','',5,'2023-03-12 08:33:00','968','0000-00-00 00:00:00','','2023-03-12 08:47:03','968'),(34,'1',17,'287',1,1,'2023-03-12 00:00:00','WARRI',15100.00,15100.00,0.00,'','','2','NSR 515 ZU','MUBARAK ISAH','08062795955','',5,'2023-03-12 08:33:00','968','0000-00-00 00:00:00','','2023-03-12 08:33:31','968'),(35,'1',17,'287',1,1,'2023-03-12 00:00:00','WARRI',15250.00,15250.00,0.00,'','','3','NSR 515 ZU','MUBARAK ISAH','08062795955','',5,'2023-03-12 08:33:00','968','0000-00-00 00:00:00','','2023-03-12 08:46:40','968'),(36,'1',18,'287',1,1,'2023-03-17 00:00:00','WARRI',25000.00,25000.00,0.00,'0926','','1','KMC 571 ZU','AUWAL S SABO','08022792619','',5,'2023-03-17 08:34:50','968','0000-00-00 00:00:00','','2023-03-17 08:35:21','968'),(37,'1',18,'287',1,1,'2023-03-17 00:00:00','WARRI',25000.00,25000.00,0.00,'0926','','3','KMC 571 ZU','AUWAL S SABO','08022792619','',0,'2023-03-17 08:34:50','968','0000-00-00 00:00:00','','0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `purchases_receptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports`
--

DROP TABLE IF EXISTS `reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `type` varchar(20) NOT NULL,
  `sql` text NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`report_id`),
  KEY `companycode` (`company_id`,`name`,`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports`
--

LOCK TABLES `reports` WRITE;
/*!40000 ALTER TABLE `reports` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_fields`
--

DROP TABLE IF EXISTS `reports_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(20) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `fieldname` varchar(50) NOT NULL,
  `order` int NOT NULL,
  `visibility` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`report_id`,`field_id`,`order`,`visibility`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_fields`
--

LOCK TABLES `reports_fields` WRITE;
/*!40000 ALTER TABLE `reports_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_filters`
--

DROP TABLE IF EXISTS `reports_filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_filters` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(50) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `filter_id` int NOT NULL AUTO_INCREMENT,
  `criteria` varchar(20) NOT NULL,
  `value` varchar(100) NOT NULL,
  PRIMARY KEY (`filter_id`),
  KEY `companycode` (`company_id`,`report_id`),
  KEY `field_id` (`field_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_filters`
--

LOCK TABLES `reports_filters` WRITE;
/*!40000 ALTER TABLE `reports_filters` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_filters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_customers`
--

DROP TABLE IF EXISTS `retail_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_customers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`name`,`phone`,`email`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_customers`
--

LOCK TABLES `retail_customers` WRITE;
/*!40000 ALTER TABLE `retail_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory`
--

DROP TABLE IF EXISTS `retail_inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` int NOT NULL,
  `qtyout` int NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory`
--

LOCK TABLES `retail_inventory` WRITE;
/*!40000 ALTER TABLE `retail_inventory` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_balances`
--

DROP TABLE IF EXISTS `retail_inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_balances`
--

LOCK TABLES `retail_inventory_balances` WRITE;
/*!40000 ALTER TABLE `retail_inventory_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_costs`
--

DROP TABLE IF EXISTS `retail_inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_costs`
--

LOCK TABLES `retail_inventory_costs` WRITE;
/*!40000 ALTER TABLE `retail_inventory_costs` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products`
--

DROP TABLE IF EXISTS `retail_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`name`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `parent_id` (`parent_id`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products`
--

LOCK TABLES `retail_products` WRITE;
/*!40000 ALTER TABLE `retail_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_prices`
--

DROP TABLE IF EXISTS `retail_products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_prices`
--

LOCK TABLES `retail_products_prices` WRITE;
/*!40000 ALTER TABLE `retail_products_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_reconciliations`
--

DROP TABLE IF EXISTS `retail_products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_reconciliations`
--

LOCK TABLES `retail_products_reconciliations` WRITE;
/*!40000 ALTER TABLE `retail_products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_purchases`
--

DROP TABLE IF EXISTS `retail_purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_purchases`
--

LOCK TABLES `retail_purchases` WRITE;
/*!40000 ALTER TABLE `retail_purchases` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales`
--

DROP TABLE IF EXISTS `retail_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `saledate` date NOT NULL,
  `customer_id` varchar(20) NOT NULL DEFAULT '',
  `customer_name` varchar(50) NOT NULL,
  `customer_phone` varchar(30) NOT NULL,
  `quantity_kg` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `payment_method` varchar(10) NOT NULL,
  `payment_account_type` varchar(20) NOT NULL,
  `payment_account_id` varchar(20) NOT NULL,
  `paid` decimal(20,2) DEFAULT NULL,
  `change` decimal(20,2) DEFAULT '0.00',
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`customer_name`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `payment_method` (`payment_method`,`payment_account_type`,`payment_account_id`),
  KEY `customer_id` (`customer_id`),
  KEY `change` (`change`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales`
--

LOCK TABLES `retail_sales` WRITE;
/*!40000 ALTER TABLE `retail_sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_items`
--

DROP TABLE IF EXISTS `retail_sales_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `product_type` varchar(10) NOT NULL,
  `product_name` varchar(100) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `quantity_2` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `parent_cost` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`sale_id`,`product_id`,`rate`,`quantity`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`product_type`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `parent_id` (`parent_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_items`
--

LOCK TABLES `retail_sales_items` WRITE;
/*!40000 ALTER TABLE `retail_sales_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_payments`
--

DROP TABLE IF EXISTS `retail_sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_payments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `payment_method` varchar(50) NOT NULL,
  `account_type` varchar(10) DEFAULT NULL,
  `account_id` bigint DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`sale_id`,`payment_method`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`account_type`),
  KEY `parent_id` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_payments`
--

LOCK TABLES `retail_sales_payments` WRITE;
/*!40000 ALTER TABLE `retail_sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales`
--

DROP TABLE IF EXISTS `sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `is_credit` int NOT NULL DEFAULT '0',
  `saledate` date NOT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `paid` int NOT NULL,
  `details` text NOT NULL,
  `ledger_notes` varchar(150) DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`product_id`,`customer_id`,`rate`,`quantity`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`is_credit`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales`
--

LOCK TABLES `sales` WRITE;
/*!40000 ALTER TABLE `sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_daily`
--

DROP TABLE IF EXISTS `sales_daily`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_daily` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `saledate` date NOT NULL,
  `average` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `target` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`average`,`saledate`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_daily`
--

LOCK TABLES `sales_daily` WRITE;
/*!40000 ALTER TABLE `sales_daily` DISABLE KEYS */;
INSERT INTO `sales_daily` VALUES (1,'1','287','2022-11-26',0.00,'2022-11-27 06:41:39','968','2',840.00,580.00,0.00),(2,'1','287','2022-11-26',0.00,'2022-11-27 06:41:39','968','1',210.00,20766.62,0.00),(3,'1','287','2022-11-27',0.00,'2022-11-28 07:05:45','968','2',840.00,143.66,0.00),(4,'1','287','2022-11-27',0.00,'2022-11-28 07:05:45','968','1',210.00,24617.61,0.00),(5,'1','287','2022-11-28',0.00,'2022-11-29 06:59:33','968','2',840.00,1726.85,0.00),(6,'1','287','2022-11-28',0.00,'2022-11-29 06:59:33','968','1',210.00,16707.22,0.00),(7,'1','287','2022-11-29',0.00,'2022-11-30 07:07:41','968','2',840.00,530.41,0.00),(8,'1','287','2022-11-29',0.00,'2022-11-30 07:07:41','968','1',210.00,3805.59,0.00),(9,'1','287','2022-12-14',0.00,'2022-12-15 08:24:08','968','2',840.00,357.00,0.00),(10,'1','287','2022-12-14',0.00,'2022-12-15 08:24:08','968','1',210.00,0.00,0.00);
/*!40000 ALTER TABLE `sales_daily` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions`
--

DROP TABLE IF EXISTS `sales_distributions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions` (
  `distribution_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `sale_id` int NOT NULL,
  `purchase_id` varchar(20) NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `loadingdate` date NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `destination` varchar(50) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `truckno` varchar(20) NOT NULL,
  `drivername` varchar(50) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`distribution_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`loadingdate`,`quantity`,`destination`,`waybill`,`meterno`,`nozzle_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`tank_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `truckno` (`truckno`),
  KEY `purchase_id_2` (`purchase_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions`
--

LOCK TABLES `sales_distributions` WRITE;
/*!40000 ALTER TABLE `sales_distributions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_delivery`
--

DROP TABLE IF EXISTS `sales_distributions_delivery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_delivery` (
  `delivery_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `distribution_id` int NOT NULL,
  `sale_id` int NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `quantity` int NOT NULL,
  `truck_id` int NOT NULL,
  `deliveredon` date NOT NULL,
  `details` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`delivery_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`quantity`,`thedate`,`createdby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`truck_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `distribution_id` (`distribution_id`),
  KEY `deliveredon` (`deliveredon`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_delivery`
--

LOCK TABLES `sales_distributions_delivery` WRITE;
/*!40000 ALTER TABLE `sales_distributions_delivery` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_delivery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_trucks`
--

DROP TABLE IF EXISTS `sales_distributions_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_trucks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sale_id` varchar(20) NOT NULL,
  `distribution_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `bridge_id` varchar(20) NOT NULL,
  `truck_id` varchar(20) NOT NULL,
  `driver_id` varchar(20) NOT NULL,
  `quantity` int NOT NULL,
  `destination` varchar(150) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `companycode` (`company_id`,`distribution_id`,`truck_id`),
  KEY `sale_id` (`sale_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_trucks`
--

LOCK TABLES `sales_distributions_trucks` WRITE;
/*!40000 ALTER TABLE `sales_distributions_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_fueltickets`
--

DROP TABLE IF EXISTS `sales_fueltickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_fueltickets` (
  `ticket_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `ticketdate` date NOT NULL,
  `code` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `allowance` decimal(10,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `truck_number` varchar(20) NOT NULL,
  `truck_capacity` int NOT NULL,
  `truck_provider` varchar(50) NOT NULL,
  `truck_from` varchar(50) NOT NULL,
  `truck_destination` varchar(50) NOT NULL,
  `driver_name` varchar(50) NOT NULL,
  `driver_phone` varchar(50) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`ticket_id`),
  KEY `companycode` (`company_id`,`ticketdate`,`product_id`,`truck_number`,`rate`,`quantity`,`status`),
  KEY `paid` (`truck_provider`),
  KEY `invoice` (`code`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_fueltickets`
--

LOCK TABLES `sales_fueltickets` WRITE;
/*!40000 ALTER TABLE `sales_fueltickets` DISABLE KEYS */;
INSERT INTO `sales_fueltickets` VALUES (1,'1','287','2022-10-29','1029180523',2,800.00,35,5000.00,33000.00,'NSR 448 ZU',50000,'','PORTHARCOURT','LOCAL','SULEIMAN','','2022-10-29 18:09:13',5,'','968','','0000-00-00 00:00:00','968','2022-10-29 18:09:47'),(2,'1','287','2022-10-30','1030133736',1,770.00,25,5000.00,24250.00,'RAN 849 XA',50000,'','PORTHARCOURT','LOCAL','AMMAR','09164644145','2022-10-30 13:41:33',0,'','968','968','2022-10-30 13:45:09','','0000-00-00 00:00:00'),(3,'1','287','2022-10-30','1030134136',1,770.00,25,5000.00,24250.00,'RAN 849 XA',50000,'','PORTHARCOURT','LOCAL','AMMAR','09164644145','2022-10-30 13:44:14',0,'','968','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(4,'1','287','2022-11-16','1116200154',2,825.00,900,20000.00,762500.00,'KMC 691 ZE',60000,'AA RANO NIG LIMITED','LAGOS','LAGOS','HASSAN','08066815181','2022-11-16 20:29:31',5,'','968','','0000-00-00 00:00:00','968','2022-11-16 20:31:22'),(5,'1','287','2022-11-16','1116202937',2,825.00,900,20000.00,762500.00,'KMC 668 ZE',60000,'AA RANO NIG LIMITED','LAGOS','CALABAR','BASIRI SAMAILA','08062877740','2022-11-16 20:30:50',5,'','968','968','2022-11-16 20:38:42','968','2022-11-16 20:45:17'),(6,'1','287','2022-11-23','1123111951',2,840.00,35,5000.00,34400.00,'KMC 662 ZE',60000,'AA RANO NIG LIMITED','PORTHARCOURT','LOCAL','SHEHU','08032273354','2022-11-23 11:22:29',5,'','968','968','2022-11-23 18:34:31','968','2022-11-23 18:34:48'),(7,'1','287','2022-11-23','1123112231',2,840.00,35,5000.00,34400.00,'KMC 664 ZE',60000,'AA RANO NIG LIMITED','PORTHARCOURT','LOCAL','BASHIRU','08033872297','2022-11-23 11:23:44',5,'','968','968','2022-11-23 18:36:04','968','2022-11-23 18:36:17'),(8,'1','287','2022-11-24','1123182733',2,840.00,650,30000.00,576000.00,'NSR 450 ZU',60000,'AA RANO NIG LIMITED','PORTHARCOURT','CALABAR','ABUBAKAR MUHAMMAD','08036932729','2022-11-23 18:33:56',5,'LPG','968','968','2022-11-24 07:08:53','968','2022-11-24 07:09:22'),(9,'1','287','2023-03-01','0301183939',2,800.00,250,10000.00,210000.00,'RAN 922 XA',50000,'AA RANO NIG LIMITED','WARRI','PORT HARCOURT','ISAH AHMAD','08034127601','2023-03-01 18:46:54',5,'','968','','0000-00-00 00:00:00','968','2023-03-01 18:49:00'),(10,'1','287','2023-03-02','0302071354',2,810.00,250,10000.00,212500.00,'KMC 717 ZJ',50000,'AA RANO NIG LIMITED','WARRI','PORT HARCOURT','ABDULLAHI YALO','08037673012','2023-03-02 07:15:26',5,'','968','','0000-00-00 00:00:00','968','2023-03-02 07:15:48'),(11,'1','287','2023-03-08','0308142434',2,800.00,250,10000.00,210000.00,'KMC 571 ZU',50000,'AA RANO NIG LIMITED','WARRI','PORT HARCOURT','AUWAL S RANO','08022792619','2023-03-08 14:32:20',5,'','968','','0000-00-00 00:00:00','968','2023-03-08 14:32:45'),(12,'1','287','2023-03-14','0314145531',2,790.00,500,15000.00,410000.00,'TRN31YZ',25,'AA RANO NIG LIMITED','PORTHARCOURT','CALABAR','YAKUBU SAIDU','08037805061','2023-03-14 15:02:30',5,'','968','','0000-00-00 00:00:00','968','2023-03-14 15:04:03'),(13,'1','287','2023-03-15','0315183543',2,790.00,250,10000.00,207500.00,'KMC 571 ZU',50000,'AA RANO NIG LIMITED','WARRI','PORT HARCOURT','AUWAL S RANO','08022792619','2023-03-15 18:39:33',5,'','968','968','2023-03-15 18:44:11','968','2023-03-15 18:44:39'),(14,'1','287','2023-03-15','0315183935',2,790.00,150,0.00,118500.00,'KMC 571 ZU',50000,'AA RANO NIG LIMITED','WARRI','PORT HARCOURT','AUWAL S RANO','08022792619','2023-03-15 18:42:56',5,'','968','','0000-00-00 00:00:00','968','2023-03-15 18:45:27');
/*!40000 ALTER TABLE `sales_fueltickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_payments`
--

DROP TABLE IF EXISTS `sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `customer_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`customer_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_payments`
--

LOCK TABLES `sales_payments` WRITE;
/*!40000 ALTER TABLE `sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_cashbacks`
--

DROP TABLE IF EXISTS `shifts_cashbacks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_cashbacks` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `regno` varchar(100) DEFAULT NULL,
  `cashdate` date NOT NULL,
  `driver` varchar(100) DEFAULT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`cashdate`,`driver`,`customer_id`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`regno`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_cashbacks`
--

LOCK TABLES `shifts_cashbacks` WRITE;
/*!40000 ALTER TABLE `shifts_cashbacks` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_cashbacks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_remittance`
--

DROP TABLE IF EXISTS `shifts_remittance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_remittance` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `paymentdate` date NOT NULL,
  `method` int DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paidby` varchar(50) DEFAULT NULL,
  `paidto` varchar(100) DEFAULT NULL,
  `bank` bigint unsigned DEFAULT NULL,
  `depositor` varchar(100) DEFAULT NULL,
  `teller` varchar(100) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  `reversed_at` datetime DEFAULT NULL,
  `reversed_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`paymentdate`,`method`,`bank`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_remittance`
--

LOCK TABLES `shifts_remittance` WRITE;
/*!40000 ALTER TABLE `shifts_remittance` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_remittance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers`
--

DROP TABLE IF EXISTS `suppliers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers` (
  `supplier_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`supplier_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers`
--

LOCK TABLES `suppliers` WRITE;
/*!40000 ALTER TABLE `suppliers` DISABLE KEYS */;
INSERT INTO `suppliers` VALUES (1,'1','287','AA RANO NIGERIA LTD','MUHAMMAD ABDUL SULE','0803540199','mrmohasul@gmail.com','KANO','KANO','No 7 Maiduguri Road,Opposite NNPC Depot. Kano Nigeria','Nigeria',0.00,0.00,'0000-00-00','2022-10-19 10:55:28',5,'178','2022-10-19 10:55:28','178');
/*!40000 ALTER TABLE `suppliers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers_status`
--

DROP TABLE IF EXISTS `suppliers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `supplier_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers_status`
--

LOCK TABLES `suppliers_status` WRITE;
/*!40000 ALTER TABLE `suppliers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `suppliers_status` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-03-21  2:54:17
