-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_285
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_285`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_285` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_285`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,4000,'',0,'22','1','285','PURCHASES','','2022-10-15 17:15:56',5,0.00,0.00,'','479','2022-10-15 17:15:56','479',0,0),(2,7000,'',0,'20','1','285','SALES','','2022-10-15 17:16:07',5,0.00,0.00,'','479','2022-10-15 17:16:07','479',0,0),(3,500,'',0,'6.1','1','285','CASH','','2022-10-15 17:16:20',5,0.00,0.00,'','479','2022-10-15 17:16:20','479',0,0),(4,8000,'',0,'24','1','285','PURCHASES','','2022-10-15 17:16:34',5,0.00,0.00,'','479','2022-10-15 17:16:34','479',0,0),(5,2500,'',0,'2','1','285','ZB(LPG)1014471475','','2022-10-15 17:17:34',5,0.00,0.00,'','479','2022-10-15 17:17:34','479',0,0),(6,2501,'',0,'2','1','285','E-BILLS 1015372548','','2022-10-15 17:18:00',5,0.00,0.00,'','479','2022-10-15 17:18:00','479',0,0),(7,2502,'',0,'2','1','285','TAJJ BANK CITY GATE:0001875361','','2022-10-15 17:18:13',5,0.00,0.00,'','479','2022-10-15 17:18:13','479',0,0),(8,2503,'',0,'2','1','285','FID POS COLLECTION-5620141491','','2022-10-15 17:18:29',5,0.00,0.00,'','479','2022-10-15 17:18:29','479',0,0),(9,2504,'',0,'2','1','285','DANKANO-EBILLS:ZNB1014717618','','2022-10-15 17:18:43',5,0.00,0.00,'','479','2022-10-15 17:18:43','479',0,0),(10,2505,'',0,'2','1','285','ZNB POS COLL ACCT:-1015965368','ZNB POS COLLECTION ACCT:-1015965368','2022-10-20 13:50:35',5,0.00,0.00,'','792','2022-10-20 13:50:35','792',0,0),(11,2506,'',0,'2','1','285','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:41:56',5,0.00,0.00,'','792','2023-02-20 14:41:56','792',0,0),(12,2507,'',0,'2','1','285','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:45:02',5,0.00,0.00,'2023-03-15','792','2023-03-17 14:01:10','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=168 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','1','285','ALL DEALERS','ALL DEALERS','08101269792','usmanyahyaahmad97@gmail.com','Uyo city','Akwa-Ibom','Akwa-Ibom LPG Plant2','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-18 09:50:33',5,'961','2022-10-18 09:50:33','961'),(2,'','1','285','EDET AKANINYENE ','OKON','08033371456','edetakaninyene44@gmail.com','Uyo city','Akwa-Ibom','no. 10 ikot Ambang ibiono','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-19 12:52:41',5,'961','2022-10-19 12:52:41','961'),(3,'','1','285','OKORIE IMOH','ANIEFIOK','09059394126','imohaniefiok2019@9mail.com','Uyo city','Akwa-Ibom','34 CALABAR ITU HIGHWAY ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-20 07:36:00',5,'961','2022-10-20 07:36:00','961'),(4,'','1','285','BONT GAS','BONT','08065192745','bonigas@yahoo.com','Uyo city','Akwa-Ibom','185 1kot express road ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-20 14:20:03',5,'961','2022-10-20 14:20:03','961'),(5,'','1','285','IMTECH  GAS','IMTECH','08062293330','cgfdre98@gmail.com','Uyo city','Akwa-Ibom','NO.60 IKOT UDORO ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-22 09:20:57',5,'961','2022-10-22 09:20:57','961'),(6,'','1','285','AK2 GAS','REX  ENDURANCE','08066735255','dsawasaboss@gmai.com','Uyo city','Akwa-Ibom','NO.1 UBONG STREET MBORK','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-22 09:28:29',5,'961','2022-10-22 09:28:29','961'),(7,'','1','285','A B GAS','IKOT ','08022053000','ytrgfrwbd@','Uyo city','Akwa-Ibom','NO. CALABAR ITU HIGHWAY','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-22 10:27:49',5,'961','2022-10-22 10:27:49','961'),(8,'','1','285','A B GAS ONE','IKOT ','08022053000','edetakaninyene44@gmail.com','Uyo city','Akwa-Ibom','CALABAR ITU ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-22 10:30:16',5,'961','2022-10-22 10:30:16','961'),(9,'','1','285','EVREMATIC GAS','EVREMATIC','07035345799','edetakaninyene44@gmail.com','Uyo city','Akwa-Ibom','CALABAR ITU RAOD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-22 11:06:59',5,'961','2022-10-22 11:06:59','961'),(10,'','1','285','JELO GAS','JELO','08036811608','jelo88@gailm.com','Uyo city','Akwa-Ibom','CALABAR ITU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-22 14:08:37',5,'961','2022-10-22 14:08:37','961'),(11,'','1','285','GIBSON GAS','OFONIME','08039360943','ofnimegibson33@gmaiil.com','UYO CITY','AKWA IBOM','No.12 Anana Ekong close, Uyo','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-25 11:21:24',5,'961','2022-10-25 11:21:24','961'),(12,'','1','285','JASPER  GAS','STONE','08037549054','jasperstone@gmail.com','UYO CITY','AKWA IBOM','IKOT OSUKPONE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-25 12:26:25',5,'961','2022-10-25 12:26:25','961'),(13,'','1','285','GAREZ GAS','LENDER','07088525865','garez@gmail.com','UYO CITY','AKWA IBOM','51 UKO ESSHIET STREET','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-25 14:18:17',5,'961','2022-10-25 14:18:17','961'),(14,'','1','285','KUFA GAS','KUFA','08028181721','ofnimegibson33@gmaiil.com','UYO CITY','AKWA IBOM','77 CHURCH ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-26 14:19:24',5,'961','2022-10-26 14:19:24','961'),(15,'','1','285','GRACE GAS','GRACE','09027297596','mercyeygom@gmail.com','UYO CITY','AKWA IBOM','2 HIGHTENSION URUAEKPA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-27 14:13:00',5,'961','2022-10-27 14:13:00','961'),(16,'','1','285','Abaz Gas','Abaz','09027065798','aaranolpg6@gmail.com','Uyo city','Akwa Ibom ','Atu Effiong, Uyo city','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-30 10:11:22',5,'961','2022-10-30 10:11:22','961'),(17,'','1','285','AA RANO NIGERIA LTD','AA RANO NIGERIA LTD','08035742431','aaranolpg3@gmail.com','Kano city','Kano state','No. 7 Maiduguri Road, Opposite NNPC Deport. Kano Nigeria','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-30 14:47:04',5,'961','2022-10-30 14:47:04','961'),(18,'','1','285','WISDOM GAS','KINGSLY','09130594317','info@aaranonigeria.com','UYO CITY','AKWA IBOM','CALABAR  ITU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-31 09:44:05',5,'961','2022-10-31 09:44:05','961'),(19,'','1','285','MIDDLE GAS','EKEMINI ','0901691915','info@aaranonigeria.com','UYO CITY','AKWA IBOM','ITAM POLICE STATION','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-31 09:47:27',5,'961','2022-10-31 09:47:27','961'),(20,'','1','285','EDET MFONOBONG','OKON','07067071247','edetmfonobong47@gmail.com','UYO CITY','AKWA IBOM','MBAK ITAM AKTC','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-31 12:01:39',5,'961','2022-10-31 12:01:39','961'),(21,'','1','285','VIBAS GAS','VIBAS','08138984500','caleb@gmail.com','UYO CITY','AKWA IBOM','ITAM','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-31 12:04:56',5,'961','2022-10-31 12:04:56','961'),(22,'','1','285','SUCCESS GAS','SUCCESS','08111863075','otoekong058@gmail.com','UYO CITY','AKWA IBOM','IKPA ROAD IK','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-31 12:07:14',5,'961','2022-10-31 12:07:14','961'),(23,'','1','285','DAVID GAS','DAVID','08166825015','davidudofia98@gmail.com','UYO CITY','AKWA IBOM','itam','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-31 12:16:08',5,'961','2022-10-31 12:16:08','961'),(24,'','1','285','FINE GAS','VENTURES','08033745919','fine@gmail.com','UYO CITY','AKWA IBOM','ITAM','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-31 12:21:01',5,'961','2022-10-31 12:21:01','961'),(25,'','1','285','SALARY GAS','SALARY','08082590072','salary@gmail.com','UYO CITY','AKWA IBOM','faith road','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-31 12:25:43',5,'961','2022-10-31 12:25:43','961'),(26,'','1','285','EBONY GSA','EBONY','08023904040','ebony@gmail.com','UYO CITY','AKWA IBOM','IKOT AKPA ETOK','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-31 12:28:15',5,'961','2022-10-31 12:28:15','961'),(27,'','1','285','NSITEA GAS','NSITEA','07037211332','ekpenyong@gmail.com','UYO CITY','AKWA IBOM','meffiat','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-31 13:01:02',5,'961','2022-10-31 13:01:02','961'),(28,'','1','285','NWANA GSA','NWANA','08036309257','info@aaranonigeria.com','UYO CITY','AKWA IBOM','10 AKA ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-31 13:13:12',5,'961','2022-10-31 13:13:12','961'),(29,'','1','285','PATIBA GAS','PATIBA','08030924444','info@aaranonigeria.com','UYO CITY','AKWA IBOM','CALABAR ITU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-31 14:59:38',5,'961','2022-10-31 14:59:38','961'),(30,'','1','285','EMDAVE GAS','EMDAVE','08083049038','info@aaranonigeria.com','UYO CITY','AKWA IBOM','CALABAR ITU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-31 16:26:57',5,'961','2022-10-31 16:26:57','961'),(31,'','1','285','ACE GAS','ACE','09067600414','itohowogeorge1828@gmail.com','UYO CITY','AKWA IBOM','IKOT EKWERE ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-01 08:58:36',5,'961','2022-11-01 08:58:36','961'),(32,'','1','285','ENEBROS GAS','VENTURES','08067871051','enebrogas@mail.com','UYO CITY','AKWA IBOM','IKOT AMBANG','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-01 09:38:23',5,'961','2022-11-01 09:38:23','961'),(33,'','1','285','UNYIMZE GAS','UNYIME','07084697636','info@aaranonigeria.com','UYO CITY','AKWA IBOM','186 IKPA ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-01 10:08:54',5,'961','2022-11-01 10:08:54','961'),(34,'','1','285','XENOS GAS','XENOS','07030873281','info@aaranonigeria.com','UYO CITY','AKWA IBOM','173 IKPA ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-01 10:48:32',5,'961','2022-11-01 10:48:32','961'),(35,'','1','285','JOE BOY GAS','JOE','09139103477','info@aaranonigeria.com','UYO CITY','AKWA IBOM','EKIT ITAM','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-01 11:00:42',5,'961','2022-11-01 11:00:42','961'),(36,'','1','285','JOROEFON GAS','JOROEFON','08023755193','info@aaranonigeria.com','UYO CITY','AKWA IBOM','IKOT NDEM STREET','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-01 11:03:01',5,'961','2022-11-01 11:03:01','961'),(37,'','1','285','DACHVIC GAS','VENTURES','07032808883','info@aaranonigeria.com','UYO CITY','AKWA IBOM','50 AKA COMMUNITY','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-02 13:01:11',5,'961','2022-11-02 13:01:11','961'),(38,'','1','285','ACE DIST GAS','UDEME','08037192755','info@aaranonigeria.com','UYO CITY','AKWA IBOM','21 ETTE IBA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-02 14:43:02',5,'961','2022-11-02 14:43:02','961'),(39,'','1','285','SAMPERK GAS','SAM','08141915525','info@aaranonigeria.com','UYO CITY','AKWA IBOM','13 EBONG','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-03 09:40:20',5,'961','2022-11-03 09:40:20','961'),(40,'','1','285','GODSOWN GAS','GODS','07081077621','info@aaranonigeria.com','UYO CITY','AKWA IBOM','15 UDOSANGA STREET','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-03 11:45:33',5,'961','2022-11-03 11:45:33','961'),(41,'','1','285','CHARLIE UMOH GAS','UMOH','09031321272','info@aaranonigeria.com','UYO CITY','AKWA IBOM','IKOT','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-03 12:52:41',5,'961','2022-11-03 12:52:41','961'),(42,'','1','285','REMMY GAS','REMMY','07052118939','info@aaranonigeria.com','UYO CITY','AKWA IBOM','OBIO ENANG','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-03 15:35:48',5,'961','2022-11-03 15:35:48','961'),(43,'','1','285','FABULOUS GAS','FABULOUS','07030524853','info@aaranonigeria.com','UYO CITY','AKWA IBOM','7 EKA STREETUYO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-03 15:42:06',5,'961','2022-11-03 15:42:06','961'),(44,'','1','285','NSIITEX GAS','NSITEX','07037211332','nsiter123@gmail.com','UYO','AKWA IBOM','19 EFFIAT STREET','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-04 10:55:25',5,'961','2022-11-04 10:55:25','961'),(45,'','1','285','EKPENE GAS','EKPENE','07062753184','nsiter123@gmail.com','UYO','AKWA IBOM','EDIENE IKOT UMIOH','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-04 13:54:50',5,'961','2022-11-04 13:54:50','961'),(46,'','1','285','VICTOR GAS','VICTOR','08175401121','nsiter123@gmail.com','UYO','AKWA IBOM','4 IDARK OKPO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-07 09:43:04',5,'961','2022-11-07 09:43:04','961'),(47,'','1','285','IDY GAS','IDY','08038381174','nsiter123@gmail.com','UYO','AKWA IBOM','UDOETE STREET','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-07 09:44:58',5,'961','2022-11-07 09:44:58','961'),(48,'','1','285','EMEM GAS','EMEM','08021127310','nsiter123@gmail.com','UYO','AKWA IBOM','IDORO ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-07 13:56:29',5,'961','2022-11-07 13:56:29','961'),(49,'','1','285','OUK GAS','OUK','08031877411','nsiter123@gmail.com','UYO','AKWA IBOM','UODETTE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-07 13:59:42',5,'961','2022-11-07 13:59:42','961'),(50,'','1','285','ANIEFIOK GAS','ANIEFIOK','07084489794','nsiter123@gmail.com','UYO','AKWA IBOM','NUNY UKPON','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-07 14:01:43',5,'961','2022-11-07 14:01:43','961'),(51,'','1','285','ELCELLENCE GAS','ELCELLENCE','09136667788','nsiter123@gmail.com','UYO','AKWA IBOM','P0LICE STATION ITAM','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-07 15:26:19',5,'961','2022-11-07 15:26:19','961'),(52,'','1','285','DISMAN GAS','DISMAN','07088536681','nsiter123@gmail.com','UYO','AKWA IBOM','AFAHA IDORO JUNCTION','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-08 08:51:07',5,'961','2022-11-08 08:51:07','961'),(53,'','1','285','JOHNSONS GAS','JOHNSON','08064558966','nsiter123@gmail.com','UYO','AKWA IBOM','189 IKOT EKPENE ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-08 09:06:48',5,'961','2022-11-08 09:06:48','961'),(54,'','1','285','GODS GRACE GAS','GODS','07064555495','nsiter123@gmail.com','UYO','AKWA IBOM','IKOT NDEIA ITU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-08 09:30:23',5,'961','2022-11-08 09:30:23','961'),(55,'','1','285','SHARON COOKING GAS','SHARON','07039485780','nsiter123@gmail.com','UYO','AKWA IBOM','18 URUA EKPA ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-08 10:04:34',5,'961','2022-11-08 10:04:34','961'),(56,'','1','285','SOC GAS','IMOH','09059394126','nsiter123@gmail.com','UYO','AKWA IBOM','CALABAR ITU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-09 10:13:33',5,'961','2022-11-09 10:13:33','961'),(57,'','1','285','GABICSON GAS','GABIC','08037207483','chukwaere emmy@ mail.com','UYO','AKWA IBOM','GOODLAND ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-11 08:02:26',5,'961','2022-11-11 08:02:26','961'),(58,'','1','285','UDEME A A GAS','UDEME','07040505042','nsiter123@gmail.com','UYO','AKWA IBOM','CALABAR ITU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-11 08:59:59',5,'961','2022-11-11 08:59:59','961'),(59,'','1','285','TK GAS','UDO EDET','09018372996','nsiter123@gmail.com','UYO','AKWA IBOM','N0 2 NELSON MANDELA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-12 15:21:14',5,'961','2022-11-12 15:21:14','961'),(60,'','1','285','NSIKAK GAS','BOINFACE AKPAN','08124890775','nsiter123@gmail.com','UYO','AKWA IBOM','CALABAR ITU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-12 16:34:47',5,'961','2022-11-12 16:34:47','961'),(61,'','1','285','SAMMY GAS','205 URUA EKPA JUNCTION','07033321555','infor@aaranonigeria.com','UYO','AKWA IBOM','205 URUA EKPA JUNCTION','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-13 10:50:00',5,'961','2022-11-13 10:50:00','961'),(62,'','1','285','EVANS GAS','EVANS','07058939293','evans@ gmail .com','UOY','AKWA IBOM','ATKU ABUBAKA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-15 11:44:34',5,'961','2022-11-15 11:44:34','961'),(63,'','1','285','ODESON GAS','ODESON','08100260196','evans@gamil.com','UYO','AKWA IBOM','ITAM PARK ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-15 13:00:32',5,'961','2022-11-15 13:00:32','961'),(64,'','1','285','UBEE GAS','UBEE','08062288059','evans@gamil.com','UYO','AKWA IBOM','IDORO ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-15 13:41:16',5,'961','2022-11-15 13:41:16','961'),(65,'','1','285','DOMINIC GAS','DOMINIC','08024485150','evans@gamil.com','UYO','AKWA IBOM','63 AKA RAOD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-15 15:42:38',5,'961','2022-11-15 15:42:38','961'),(66,'','1','285','4SURE OIL GAS','4SURE','09078024825','evans@gamil.com','UYO','AKWA IBOM','AFAHA EDIENE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-16 13:26:17',5,'961','2022-11-16 13:26:17','961'),(67,'','1','285','PHIDAS GAS','PHIDAS','08102447446','evans@gamil.com','UYO','AKWA IBOM','55 AKPAN ESEN STRET','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 08:14:04',5,'961','2022-11-22 08:14:04','961'),(68,'','1','285','DEALER','TIMBER MARKET','08101269792','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','ALONG HIGH WAY','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-29 07:15:08',5,'961','2022-11-29 07:15:08','961'),(69,'','1','285','EMICO GAS','EMICO','07064856142','evans@gamil.com','UYO','AKWA IBOM','ITU ITAM ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-29 14:21:29',5,'961','2022-11-29 14:21:29','961'),(70,'','1','285','felix gas','felix','09035996153','elviessunday@yahoo.com','UYO','AKWA IBOM','NO 30 IKOT MBONDE ITU ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-30 10:47:54',5,'961','2022-11-30 10:47:54','961'),(71,'','1','285','NSIXS GAS','NSIXS','07032409842','nsisxsmkpong@gmail.com','UYO','AKWA IBOM','I UDO EKONG STREAT UYO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-30 12:51:25',5,'961','2022-11-30 12:51:25','961'),(72,'','1','285','PETU GAS','PETU','08063613837','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','100 ITU ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-02 07:42:13',5,'961','2022-12-02 07:42:13','961'),(73,'','1','285','DONDAN GAS','DONDAN','08028328794','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','405 ORON ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-03 12:12:21',5,'961','2022-12-03 12:12:21','961'),(74,'','1','285','SECPAT GAS','SECPAT','08023424961','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','ABAK ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-04 14:24:47',5,'961','2022-12-04 14:24:47','961'),(75,'','1','285','TEE GAS','TEE','08102561743, 08173885926','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','ORON ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-04 15:50:10',5,'961','2022-12-04 15:50:10','961'),(76,'','1','285','ANISOL GAS','ANISOL','08108571844','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','21 IDAK OKPO STREET OFF IKPA ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-04 16:35:27',5,'961','2022-12-04 16:35:27','961'),(77,'','1','285','JOHN GENERATING GAS','JOHN','07037975116','josdon4 @yahoo.com','UYO','AKWA IBOM','MBAK ITAM','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-05 14:02:19',5,'961','2022-12-05 14:02:19','961'),(78,'','1','285','STANDARD GAS','STANDARD','09064664857','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','8 NSIT STREET','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-07 12:25:40',5,'961','2022-12-07 12:25:40','961'),(79,'','1','285','E & P GAS','IKOT OSUKPONG','08023189951','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','IKOT OSUKPONG','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-08 13:00:36',5,'961','2022-12-08 13:00:36','961'),(80,'','1','285','EMMA GAS','EMMA','09036328540','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','EKONO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-08 16:09:11',5,'961','2022-12-08 16:09:11','961'),(81,'','1','285','EPHRAIM GAS','EPHRAIM ','08063613837','zahraddeenyusee422@gmail.com','UYO','AKWA IBOM','Calbar Etu','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-08 19:01:36',5,'961','2022-12-08 19:01:36','961'),(82,'','1','285','ETORO GAS','IKPE JUNCTION','08028248369','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','IKOT EKPENE ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-13 08:01:26',5,'961','2022-12-13 08:01:26','961'),(83,'','1','285','MM ETUBOM GAS','EKPENE LGA','08035097301','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','49 ABIAKYRO ROAD, IKOT','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-13 10:35:54',5,'961','2022-12-13 10:35:54','961'),(84,'','1','285','ABRAHAM GAS','ABRAHAM','09033606362','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','NUNG EKU STRESS','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-14 08:34:10',5,'961','2022-12-14 08:34:10','961'),(85,'','1','285','USEN GAS','USEN','08065405234','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','65 ITU ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-14 08:36:16',5,'961','2022-12-14 08:36:16','961'),(86,'','1','285','JIREH GLOBAL GAS','FAVOUR EDEM','09131501500','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','PRIMARY SCHOOL MBIAK','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-14 08:38:39',5,'961','2022-12-14 08:38:39','961'),(87,'','1','285','PATRIC GAS','PATRIC','08157752334','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','IKOT ABMAG','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-14 12:13:32',5,'961','2022-12-14 12:13:32','961'),(88,'','1','285','HOLY KING GAS','ITAM POLICE STATION ','08164235870','elviessunday@yahoo.com','UYO','AKWA IBOM','ITAM POLICE STATION ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-15 08:25:24',5,'961','2022-12-15 08:25:24','961'),(89,'','1','285','OWOABASI GAS','OWOABASI','09026312011','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','IK ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-15 09:29:54',5,'961','2022-12-15 09:29:54','961'),(90,'','1','285','ANIEBIET AB GAS','ANIEBIET','09053507340','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','IKOT UDO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-17 13:27:38',5,'961','2022-12-17 13:27:38','961'),(91,'','1','285','TIM BEST GAS','BEST','07066029957/ 07065304830','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','ABAK','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-20 08:02:51',5,'961','2022-12-20 08:02:51','961'),(92,'','1','285','EKPE GAS','EKPE','07087209415','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','3 JAME EKPO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-21 07:28:31',5,'961','2022-12-21 07:28:31','961'),(93,'','1','285','EM GAS','EM GAS','08164753284','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','NUNG UKIM IKOT','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-21 10:50:18',5,'961','2022-12-21 10:50:18','961'),(94,'','1','285','SAMBOS GAS','SAMBOS','08030725128','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','ITU ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-22 07:24:25',5,'961','2022-12-22 07:24:25','961'),(95,'','1','285','USSEIN GAS','UKEME AKONINYE ESSIEN','07034493082',' info@aaranonigeria.com','UYO','AKWA IBOM','NO. 437 NWONIBN ROAD UYO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-25 10:53:49',5,'961','2022-12-25 10:53:49','961'),(96,'','1','285','NSYBROS GAS','NSYBROS','08037412163','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','IKOT OSURUA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-27 15:46:07',5,'961','2022-12-27 15:46:07','961'),(97,'','1','285','USSIEN GAS','UKEME','07034493082','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','47 NWANAIBAN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-27 15:49:46',5,'961','2022-12-27 15:49:46','961'),(98,'','1','285','popular gas','popular','09013915330','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','46 ikot ndem','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-29 08:28:04',5,'961','2022-12-29 08:28:04','961'),(99,'','1','285','ONYEKA GAS','ONYEKA','08132356141','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','IDORO ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-29 15:24:34',5,'961','2022-12-29 15:24:34','961'),(100,'','1','285','KALU GAS','KALU','08034144535','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','NWANIBA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-29 15:32:17',5,'961','2022-12-29 15:32:17','961'),(101,'','1','285','ANNY GAS','ANNY','08032753173','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','64 EDIDEM ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-29 15:37:28',5,'961','2022-12-29 15:37:28','961'),(102,'','1','285','CHRISM GAS','CHRISM','08133650163','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','7 ORON ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-29 15:39:25',5,'961','2022-12-29 15:39:25','961'),(103,'','1','285','NOBLE GAS','NOBLE','08069200387','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','IBIAKU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-30 07:47:11',5,'961','2022-12-30 07:47:11','961'),(104,'','1','285','REIGNETH GAS','REIGNETH','09034725591','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','NUNNG IDORO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-30 11:54:31',5,'961','2022-12-30 11:54:31','961'),(105,'','1','285','ERIGGA GAS','ERIGGA','07044242641','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','66 NELSON','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-30 11:57:10',5,'961','2022-12-30 11:57:10','961'),(106,'','1','285','NOAH\'S GLOBAL GAS','VENTURE','08088182811','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','215 IKOT EKPENE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-30 13:33:04',5,'961','2022-12-30 13:33:04','961'),(107,'','1','285','EDARA ABASI GAS','EDARA','09093683628','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','62 UDOMANA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-02 09:08:38',5,'961','2023-01-02 09:08:38','961'),(108,'','1','285','UWEM GAS','UWEM','09015097851','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','3 USUAG IKOT EKPENE','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-02 09:10:56',5,'961','2023-01-02 09:10:56','961'),(109,'','1','285','VICTORY GAS','VOICTRY','08032790143','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','ITAM','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-02 17:12:02',5,'961','2023-01-02 17:12:02','961'),(110,'','1','285','CHARLE GAS','CHARLE','08084119612','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','4 NEPA LINE','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-03 08:42:15',5,'961','2023-01-03 08:42:15','961'),(111,'','1','285','MALL GAS','MALL','08108956545','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','12 AYA ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-03 11:53:29',5,'961','2023-01-03 11:53:29','961'),(112,'','1','285','ABEDEM GAS','ABEDEM','081685554709','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','42 HOSPITAL ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-04 15:07:00',5,'961','2023-01-04 15:07:00','961'),(113,'','1','285','JIMMY GAS','JIMMY','08031354394','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','OKO ITA JUNCTION','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-04 15:08:27',5,'961','2023-01-04 15:08:27','961'),(114,'','1','285','UB GAS','UBONG','08030799118','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','21 AKPA AKPA STREET','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-05 09:23:46',5,'961','2023-01-05 09:23:46','961'),(115,'','1','285','EKITEX GAS','EKITEX','08023795273','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','ABAK','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-07 17:13:51',5,'961','2023-01-07 17:13:51','961'),(116,'','1','285','DE-TOTAL GAS','DETOTAL','08037656588','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','125 IKOT','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-08 17:26:49',5,'961','2023-01-08 17:26:49','961'),(117,'','1','285','ALBERT GAS','ALBERT','09070719522','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','ADR OKO ITA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-12 08:33:47',5,'961','2023-01-12 08:33:47','961'),(118,'','1','285','MUSA GAS','NUSA','08126384040','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','TRANSFER','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-13 08:10:30',5,'961','2023-01-13 08:10:30','961'),(119,'','1','285','IFIOK GAS','IFIOK','07040758496','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','56 IKOT EDEM','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-13 11:35:02',5,'961','2023-01-13 11:35:02','961'),(120,'','1','285','OTOVERO GAS','OTOVERO','07032721625','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','EKOM IMAM','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-17 09:29:37',5,'961','2023-01-17 09:29:37','961'),(121,'','1','285','ROCKWAY GAS','ROCKWAY','08034129759','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','66 URUA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-26 09:05:18',5,'961','2023-01-26 09:05:18','961'),(122,'','1','285','MIGHTY GAS','MIGHTY','08059349079','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','SCHOOL ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-26 09:10:54',5,'961','2023-01-26 09:10:54','961'),(123,'','1','285','ANIEDI GAS','ANIEDI','08126307963','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','89 ABA ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-26 09:34:58',5,'961','2023-01-26 09:34:58','961'),(124,'','1','285','UFAN ABASI GAS','UFAN','08108758477','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','ABA ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-26 09:37:53',5,'961','2023-01-26 09:37:53','961'),(125,'','1','285','GODBLISS GAS','GODBLISS','07030779735','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','IKOT EKEPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-26 10:03:57',5,'961','2023-01-26 10:03:57','961'),(126,'','1','285','WISDOM CHRISM GAS','WISDOM  ','07082069900','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','IKOT','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-27 12:49:41',5,'961','2023-01-27 12:49:41','961'),(127,'','1','285','G GODS PLAN GAS','MBAK ATAI ITAM ITU LGA','09039232818','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','MBAK ATAI ITAM ITU LGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-30 07:11:40',5,'961','2023-01-30 07:11:40','961'),(128,'','1','285','IMO GAS','IMO','09059394126','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','34 CALBAR ITU','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-30 11:48:43',5,'961','2023-01-30 11:48:43','961'),(129,'','1','285','SAVIOUR GAS','SAVIOUR','08160127578','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','95 IKONO ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-02 08:15:12',5,'961','2023-02-02 08:15:12','961'),(130,'','1','285','UNAAMS GAS','UNAAMS','09068969137','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','18 UDOETTE STREET','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-03 12:09:04',5,'961','2023-02-03 12:09:04','961'),(131,'','1','285','GOODLUCK GAS','GOODLUCK','08134079093','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','IKOT USORUA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-04 15:12:17',5,'961','2023-02-04 15:12:17','961'),(132,'','1','285','UDEME P GAS','UDEME','0815778234','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','IKOT AMBAN','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-06 07:57:20',5,'961','2023-02-06 07:57:20','961'),(133,'','1','285','FELIX 2 GAS','FELIX','08023968902','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','IDORO ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-07 09:57:07',5,'961','2023-02-07 09:57:07','961'),(134,'','1','285','SAMBO GAS','SAMBO','09081901123','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','NUNG IDORO','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-13 15:19:43',5,'961','2023-02-13 15:19:43','961'),(135,'','1','285','A,U GAS','SISTER AU','09065324902','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','NSEITEN','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-15 14:32:19',5,'961','2023-02-15 14:32:19','961'),(136,'','1','285','LORD KOIFI GAS','KOIFI','08068400081','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','IKOT EBOM ITAM','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-15 14:33:42',5,'961','2023-02-15 14:33:42','961'),(137,'','1','285','INI-GAS','INIOBONG','08147437986','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','ITU ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-15 16:27:41',5,'961','2023-02-15 16:27:41','961'),(138,'','1','285','BELOVE GAS','BELOVE','08121856688','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','5 AKPAN','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-18 08:16:03',5,'961','2023-02-18 08:16:03','961'),(139,'','1','285','UBON GAS','UBON','08039540934','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','NKEMBA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-18 10:46:41',5,'961','2023-02-18 10:46:41','961'),(140,'','1','285','DOT2 VENTURES GAS','DOTS','08140054983','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','CALABER ITU','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-18 17:22:26',5,'961','2023-02-18 17:22:26','961'),(141,'','1','285','VENTEKO GAS','VENTEKO ','08030726716','elviessunday@yahoo.com','UYO','AKWA IBOM','25 IKOT NTUEN STREET, OFF ABAK ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-19 13:03:52',5,'961','2023-02-19 13:03:52','961'),(142,'','1','285','TOPETS GAS','TOPETS','09060533239','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','17 UYO ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-20 07:18:46',5,'961','2023-02-20 07:18:46','961'),(143,'','1','285','EDO ABASI GAS','EDO','09138019663','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','25 ABIA ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-20 07:24:38',5,'961','2023-02-20 07:24:38','961'),(144,'','1','285','TEA GAS','TEA','08104590754','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','FOLGA STREET','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-20 07:32:59',5,'961','2023-02-20 07:32:59','961'),(145,'','1','285','GABICOSON GAS','CHUKWWA','08037207483','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','GOODLAND','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-20 16:00:09',5,'961','2023-02-20 16:00:09','961'),(146,'','1','285','NETWORK GAS','NETWORK','09079360034','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','ITAM JUNCTION','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-21 07:13:40',5,'961','2023-02-21 07:13:40','961'),(147,'','1','285','ONOSCO GAS','ONOSCO','08035486265','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','9 UMOITONG','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-21 10:06:30',5,'961','2023-02-21 10:06:30','961'),(148,'','1','285','HUMBLE GAS','HUMBLE','09138652739','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','ITU ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-24 07:35:52',5,'961','2023-02-24 07:35:52','961'),(149,'','1','285','A.U GAS','AUGAS','09065324902','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','IBIONO','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-24 14:51:18',5,'961','2023-02-24 14:51:18','961'),(150,'','1','285','DANIFIK GAS','DANIFIK','07066021395','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','NUNG AYAN','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-27 09:25:10',5,'961','2023-02-27 09:25:10','961'),(151,'','1','285','EMMA SOLUTION GAS','EMMA','08083246579','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','EKID ITAM','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-27 09:27:12',5,'961','2023-02-27 09:27:12','961'),(152,'','1','285','EMEDIZZY GAS','EMEDIZZY','09019603997','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','30 IKOT UDORO','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-28 08:51:33',5,'961','2023-02-28 08:51:33','961'),(153,'','1','285','EKEMINI ABASI GAS','EKEMINI','07066719698','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','UYO ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-28 09:36:48',5,'961','2023-02-28 09:36:48','961'),(154,'','1','285','UTY  GAS','UTYGAS','09079755462','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','OKO ITA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-28 15:37:52',5,'961','2023-02-28 15:37:52','961'),(155,'','1','285','DE GRACIOUS LANDMARK GAS','GRACIOUS','08060479015','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','NDINYA AMAFI','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-01 08:40:55',5,'961','2023-03-01 08:40:55','961'),(156,'','1','285','ABRAHAM 2 GAS','ABRAHAM 2 GAS','09033606362','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','IKOT EUK STREET IDORO  UYO','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-01 14:39:04',5,'961','2023-03-01 14:39:04','961'),(157,'','1','285','PATTE GAS','PATTE','08057433316','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','127 URUA EKPA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-02 08:58:04',5,'961','2023-03-02 08:58:04','961'),(158,'','1','285','UBONG ABASI GAS','UBONG','08169294146','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','AKPAN UDO STREET','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-04 13:34:03',5,'961','2023-03-04 13:34:03','961'),(159,'','1','285','DE JOHNSON\'S GAS','JOHNSON','08037625158','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','23 ODOR ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-11 13:07:40',5,'961','2023-03-11 13:07:40','961'),(160,'','1','285','SIGNATURE GAS','SIGNATURE','09116836889','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','54 IDORO RD','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-14 08:42:13',5,'961','2023-03-14 08:42:13','961'),(161,'','1','285','PAULO GAS','PAUL','08163235763','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','IKOT EKPENE ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-14 10:18:51',5,'961','2023-03-14 10:18:51','961'),(162,'','1','285','ANIMASO GAS','ANIMAN','09061341770','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','71 IBANG STREET','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-14 10:21:28',5,'961','2023-03-14 10:21:28','961'),(163,'','1','285','NSE-OBONG GAS','NSEOBONG','09013053922','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','IKOT IDAHA IBIONO','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-14 10:23:32',5,'961','2023-03-14 10:23:32','961'),(164,'','1','285','G 4 GAS','G4GAS','08121488444','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','406 ABQ ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-15 11:32:59',5,'961','2023-03-15 11:32:59','961'),(165,'','1','285','PERRUST GAS','PERRUST','09057565789','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','IKOT EKPENE','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-16 11:03:06',5,'961','2023-03-16 11:03:06','961'),(166,'','1','285','IDONG AMAZY GAS','AMAZY','08109738449','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','IKOT EDIM','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-17 16:16:38',5,'961','2023-03-17 16:16:38','961'),(167,'','1','285','GAS 247 ','GAS247','09064626499','usmanyahyaahmad97@gmail.com','UYO','AKWA IBOM','ATTA IDUNG URAU EKPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-20 14:38:28',5,'961','2023-03-20 14:38:28','961');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','285','1',1,'5','LPG NOZZLE 1',37746.71,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','285','1',2,'5','LPG NOZZLE 2',72138.73,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','285','1',3,'5','LPG NOZZLE 3',122236.13,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','285','1',4,'5','LPG NOZZLE 4',79771.38,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','285','1',5,'5','LPG NOZZLE 5',65473.74,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','285','1',6,'5','LPG NOZZLE 6',48585.82,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=181 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','285',1,'DAILY SHIFT','2022-10-17','2022-10-17 13:49:59','2022-10-18 13:49:59','961',0.00,0.00,'961','2022-10-17 20:38:51','961','2022-10-17 20:39:19',10,0),('1','285',2,'DAILY SHIFT','2022-10-18','2022-10-18 07:34:20','2022-10-19 07:34:20','961',0.00,0.00,'961','2022-10-18 18:47:37','961','2022-10-18 18:50:10',10,0),('1','285',3,'DAILY SHIFT','2022-10-19','2022-10-19 08:29:55','2022-10-20 08:29:55','961',0.00,0.00,'961','2022-10-19 17:27:53','961','2022-10-19 17:28:36',10,0),('1','285',4,'DAILY SHIFT','2022-10-20','2022-10-20 07:10:38','2022-10-21 07:10:38','961',0.00,0.00,'961','2022-10-20 19:00:41','961','2022-10-20 19:01:03',10,0),('1','285',5,'DAILY SHIFT','2022-10-21','2022-10-21 07:08:09','2022-10-22 07:08:09','961',0.00,0.00,'961','2022-10-21 19:41:51','961','2022-10-21 19:42:19',10,0),('1','285',6,'DAILY SHIFT','2022-10-22','2022-10-22 07:38:34','2022-10-23 07:38:34','961',0.00,0.00,'961','2022-10-22 20:15:15','961','2022-10-22 20:15:38',10,0),('1','285',7,'DAILY SHIFT','2022-10-23','2022-10-23 07:18:47','2022-10-24 07:18:47','961',0.00,0.00,'961','2022-10-23 18:06:56','961','2022-10-23 18:07:15',10,0),('1','285',8,'DAILY SHIFT','2022-10-24','2022-10-24 07:20:25','2022-10-25 07:20:25','961',0.00,0.00,'961','2022-10-24 20:01:04','961','2022-10-24 20:01:28',10,0),('1','285',9,'DAILY SHIFT','2022-10-25','2022-10-25 07:25:11','2022-10-26 07:25:11','961',0.00,0.00,'961','2022-10-25 19:34:26','961','2022-10-25 19:34:49',10,0),('1','285',10,'DAILY SHIFT','2022-10-26','2022-10-26 07:00:13','2022-10-27 07:00:13','961',0.00,0.00,'961','2022-10-26 18:21:32','961','2022-10-26 18:21:54',10,0),('1','285',11,'DAILY SHIFT','2022-10-27','2022-10-27 07:01:30','2022-10-28 07:01:30','961',0.00,0.00,'961','2022-10-27 19:04:10','961','2022-10-27 19:04:31',10,0),('1','285',12,'DAILY SHIFT','2022-10-28','2022-10-28 07:12:11','2022-10-29 07:12:11','961',0.00,0.00,'961','2022-10-28 18:59:56','961','2022-10-28 19:00:20',10,0),('1','285',13,'DAILY SHIFT','2022-10-29','2022-10-29 10:06:10','2022-10-30 10:06:10','961',0.00,0.00,'961','2022-10-29 18:00:09','961','2022-10-29 18:00:27',10,0),('1','285',14,'DAILY SHIFT','2022-10-30','2022-10-30 07:31:59','2022-10-31 07:31:59','961',0.00,0.00,'961','2022-10-30 14:38:12','961','2022-10-30 14:40:28',10,0),('1','285',15,'DAILY SHIFT','2022-10-30','2022-10-30 14:41:24','2022-10-31 14:41:24','961',0.00,0.00,'961','2022-10-30 14:51:39','961','2022-10-30 14:52:00',10,0),('1','285',16,'DAILY SHIFT','2022-10-30','2022-10-30 15:11:42','2022-10-31 15:11:42','961',0.00,0.00,'961','2022-10-30 18:50:47','961','2022-10-30 18:51:05',10,0),('1','285',17,'DAILY SHIFT','2022-10-31','2022-10-31 07:39:27','2022-11-01 07:39:27','961',0.00,0.00,'961','2022-10-31 22:50:12','961','2022-10-31 22:52:15',10,0),('1','285',18,'DAILY SHIFT','2022-11-01','2022-11-01 07:49:20','2022-11-02 07:49:20','961',0.00,0.00,'961','2022-11-01 18:57:02','961','2022-11-01 18:57:21',10,0),('1','285',19,'DAILY SHIFT','2022-11-02','2022-11-02 07:32:26','2022-11-03 07:32:26','961',0.00,0.00,'961','2022-11-02 20:01:17','961','2022-11-02 20:01:42',10,0),('1','285',20,'DAILY SHIFT','2022-11-03','2022-11-03 07:58:48','2022-11-04 07:58:48','961',0.00,0.00,'961','2022-11-03 18:41:05','961','2022-11-03 18:41:26',10,0),('1','285',21,'DAILY SHIFT','2022-11-04','2022-11-04 07:57:15','2022-11-05 07:57:15','961',0.00,0.00,'961','2022-11-04 19:16:19','961','2022-11-04 19:16:41',10,0),('1','285',22,'DAILY SHIFT','2022-11-05','2022-11-05 08:25:11','2022-11-06 08:25:11','961',0.00,0.00,'961','2022-11-05 17:51:34','961','2022-11-05 17:51:57',10,0),('1','285',23,'DAILY SHIFT','2022-11-05','2022-11-05 18:16:56','2022-11-06 18:16:56','961',0.00,0.00,'961','2022-11-05 18:28:26','961','2022-11-05 18:28:54',10,0),('1','285',24,'DAILY SHIFT','2022-11-07','2022-11-07 06:12:19','2022-11-08 06:12:19','961',0.00,0.00,'961','2022-11-07 18:55:12','961','2022-11-07 18:55:37',10,0),('1','285',25,'DAILY SHIFT','2022-11-08','2022-11-08 05:49:16','2022-11-09 05:49:16','961',0.00,0.00,'961','2022-11-08 18:56:13','961','2022-11-08 18:56:35',10,0),('1','285',26,'DAILY SHIFT','2022-11-09','2022-11-09 06:01:43','2022-11-10 06:01:43','961',0.00,0.00,'961','2022-11-09 19:05:31','961','2022-11-09 19:06:03',10,0),('1','285',27,'DAILY SHIFT','2022-11-10','2022-11-10 05:38:12','2022-11-11 05:38:12','961',0.00,0.00,'961','2022-11-10 17:46:25','961','2022-11-10 17:46:46',10,0),('1','285',28,'DAILY SHIFT','2022-11-11','2022-11-11 06:13:22','2022-11-12 06:13:22','961',0.00,0.00,'961','2022-11-11 18:02:38','961','2022-11-11 18:03:01',10,0),('1','285',29,'DAILY SHIFT','2022-11-12','2022-11-12 05:48:49','2022-11-13 05:48:49','961',0.00,0.00,'961','2022-11-12 19:22:37','961','2022-11-12 19:22:57',10,0),('1','285',30,'DAILY SHIFT','2022-11-13','2022-11-13 05:56:25','2022-11-14 05:56:25','961',0.00,0.00,'961','2022-11-13 17:40:29','961','2022-11-13 17:40:48',10,0),('1','285',31,'DAILY SHIFT','2022-11-14','2022-11-14 06:04:49','2022-11-15 06:04:49','961',0.00,0.00,'961','2022-11-14 18:02:47','961','2022-11-14 18:03:12',10,0),('1','285',32,'DAILY SHIFT','2022-11-15','2022-11-15 06:38:07','2022-11-16 06:38:07','961',0.00,0.00,'961','2022-11-15 18:48:36','961','2022-11-15 18:49:00',10,0),('1','285',33,'DAILY SHIFT','2022-11-16','2022-11-16 05:47:59','2022-11-17 05:47:59','961',0.00,0.00,'961','2022-11-16 17:57:05','961','2022-11-16 17:57:31',10,0),('1','285',34,'DAILY SHIFT','2022-11-19','2022-11-19 07:07:40','2022-11-20 07:07:40','961',0.00,0.00,'961','2022-11-19 19:02:04','961','2022-11-19 19:02:23',10,0),('1','285',35,'DAILY SHIFT','2022-11-20','2022-11-20 07:38:14','2022-11-21 07:38:14','961',0.00,0.00,'961','2022-11-20 18:39:17','961','2022-11-20 18:39:37',10,0),('1','285',36,'DAILY SHIFT ','2022-11-21','2022-11-21 06:11:28','2022-11-22 06:11:28','961',0.00,0.00,'961','2022-11-21 18:03:35','961','2022-11-21 18:03:54',10,0),('1','285',37,'DAILY SHIFT ','2022-11-22','2022-11-22 06:28:54','2022-11-23 06:28:54','961',0.00,0.00,'961','2022-11-22 17:49:22','961','2022-11-22 17:49:43',10,0),('1','285',38,'DAILY SHIFT','2022-11-22','2022-11-22 17:50:04','2022-11-23 17:50:04','961',0.00,0.00,'961','2022-11-22 17:54:17','961','2022-11-22 17:54:35',10,0),('1','285',39,'DAILY SHIFT ','2022-11-23','2022-11-23 05:54:32','2022-11-24 05:54:32','961',0.00,0.00,'961','2022-11-23 18:39:19','961','2022-11-23 18:39:54',10,0),('1','285',40,'DAILY SHIFT ','2022-11-24','2022-11-24 05:38:26','2022-11-25 05:38:26','961',0.00,0.00,'961','2022-11-24 18:38:47','961','2022-11-24 18:39:14',10,0),('1','285',41,'DAILY SHIFT ','2022-11-25','2022-11-25 06:14:30','2022-11-26 06:14:30','961',0.00,0.00,'961','2022-11-25 18:49:04','961','2022-11-25 18:49:23',10,0),('1','285',42,'DAILY SHIFT ','2022-11-26','2022-11-26 05:58:35','2022-11-27 05:58:35','961',0.00,0.00,'961','2022-11-26 18:37:00','961','2022-11-26 18:37:19',10,0),('1','285',43,'DAILY SHIFT ','2022-11-27','2022-11-27 06:07:38','2022-11-28 06:07:38','961',0.00,0.00,'961','2022-11-27 17:58:27','961','2022-11-27 17:58:48',10,0),('1','285',44,'DAILY SHIFT ','2022-11-28','2022-11-28 05:53:19','2022-11-29 05:53:19','961',0.00,0.00,'961','2022-11-28 17:57:35','961','2022-11-28 17:57:55',10,0),('1','285',45,'DAILY SHIFT ','2022-11-29','2022-11-29 06:17:14','2022-11-30 06:17:14','961',0.00,0.00,'961','2022-11-29 18:20:32','961','2022-11-29 18:20:51',10,0),('1','285',46,'DAILY SHIFT ','2022-11-30','2022-11-30 05:57:55','2022-12-01 05:57:55','961',0.00,0.00,'961','2022-11-30 18:12:51','961','2022-11-30 18:13:12',10,0),('1','285',47,'DAILY SHIFT ','2022-12-01','2022-12-01 06:06:20','2022-12-02 06:06:20','961',0.00,0.00,'961','2022-12-01 18:24:05','961','2022-12-01 18:24:27',10,0),('1','285',48,'DAILY SHIFT ','2022-12-02','2022-12-02 06:21:40','2022-12-03 06:21:40','961',0.00,0.00,'961','2022-12-02 18:21:00','961','2022-12-02 18:21:20',10,0),('1','285',49,'DAILY SHIFT ','2022-12-03','2022-12-03 05:50:28','2022-12-04 05:50:28','961',0.00,0.00,'961','2022-12-03 19:15:40','961','2022-12-03 19:16:03',10,0),('1','285',50,'DAILY SHIFT','2022-12-03','2022-12-03 19:20:52','2022-12-04 19:20:52','961',0.00,0.00,'961','2022-12-03 19:36:43','961','2022-12-03 19:37:02',10,0),('1','285',51,'DAILY SHIFT','2022-12-04','2022-12-04 06:25:59','2022-12-05 06:25:59','961',0.00,0.00,'961','2022-12-04 18:51:01','961','2022-12-04 18:51:26',10,0),('1','285',52,'DAILY SHIFT ','2022-12-05','2022-12-05 06:30:54','2022-12-06 06:30:54','961',0.00,0.00,'961','2022-12-05 19:42:34','961','2022-12-05 19:43:12',10,0),('1','285',53,'DAILY SHIFT','2022-12-06','2022-12-06 06:43:42','2022-12-07 06:43:42','961',0.00,0.00,'961','2022-12-06 18:00:21','961','2022-12-06 18:00:51',10,0),('1','285',54,'DAILY SHIFT','2022-12-07','2022-12-07 06:23:20','2022-12-08 06:23:20','961',0.00,0.00,'961','2022-12-07 18:39:33','961','2022-12-07 18:40:01',10,0),('1','285',55,'DAILY SHIFT ','2022-12-08','2022-12-08 05:56:05','2022-12-09 05:56:05','961',0.00,0.00,'961','2022-12-08 19:07:24','961','2022-12-08 19:07:45',10,0),('1','285',56,'DAILY SHIFT','2022-12-09','2022-12-09 06:26:18','2022-12-10 06:26:18','961',0.00,0.00,'961','2022-12-10 06:25:57','961','2022-12-10 06:26:25',10,0),('1','285',57,'DAILY SHIFT','2022-12-10','2022-12-10 06:29:36','2022-12-11 06:29:36','961',0.00,0.00,'961','2022-12-10 17:55:43','961','2022-12-10 17:56:03',10,0),('1','285',58,'DAILY SHIFT','2022-12-11','2022-12-11 06:25:50','2022-12-12 06:25:50','961',0.00,0.00,'961','2022-12-11 17:47:54','961','2022-12-11 17:48:16',10,0),('1','285',59,'DAILY SHIFT','2022-12-12','2022-12-12 06:32:42','2022-12-13 06:32:42','961',0.00,0.00,'961','2022-12-12 19:22:36','961','2022-12-12 19:23:01',10,0),('1','285',60,'DAILY SHIFT','2022-12-13','2022-12-13 06:22:42','2022-12-14 06:22:42','961',0.00,0.00,'961','2022-12-14 06:41:10','961','2022-12-14 06:41:38',10,0),('1','285',61,'DAILY SHIFT','2022-12-14','2022-12-14 06:42:15','2022-12-15 06:42:15','961',0.00,0.00,'961','2022-12-14 13:10:30','961','2022-12-14 13:10:53',10,0),('1','285',62,'DAILY SHIFT','2022-12-14','2022-12-14 13:11:38','2022-12-15 13:11:38','961',0.00,0.00,'961','2022-12-14 13:18:04','961','2022-12-14 13:20:29',10,0),('1','285',63,'DAILY SHIFT','2022-12-14','2022-12-14 13:41:50','2022-12-15 13:41:50','961',0.00,0.00,'961','2022-12-15 06:35:39','961','2022-12-15 06:36:07',10,0),('1','285',64,'DAILY SHIFT','2022-12-15','2022-12-15 06:36:44','2022-12-16 06:36:44','961',0.00,0.00,'961','2022-12-15 19:21:56','961','2022-12-15 19:22:36',10,0),('1','285',65,'DAILY SHIFT','2022-12-16','2022-12-16 06:40:00','2022-12-17 06:40:00','961',0.00,0.00,'961','2022-12-16 19:20:33','961','2022-12-16 19:20:54',10,0),('1','285',66,'DAILY SHIFT','2022-12-17','2022-12-17 06:48:40','2022-12-18 06:48:40','961',0.00,0.00,'961','2022-12-17 18:20:41','961','2022-12-17 18:21:09',10,0),('1','285',67,'DAILY SHIFT','2022-12-18','2022-12-18 06:27:37','2022-12-19 06:27:37','961',0.00,0.00,'961','2022-12-18 19:06:47','961','2022-12-18 19:07:09',10,0),('1','285',68,'DAILY SHIFT','2022-12-19','2022-12-19 06:31:26','2022-12-20 06:31:26','961',0.00,0.00,'961','2022-12-19 19:13:53','961','2022-12-19 19:14:18',10,0),('1','285',69,'DAILY SHIFT','2022-12-20','2022-12-20 06:38:22','2022-12-21 06:38:22','961',0.00,0.00,'961','2022-12-20 18:03:40','961','2022-12-20 18:04:08',10,0),('1','285',70,'DAILY SHIFT','2022-12-21','2022-12-21 06:44:43','2022-12-22 06:44:43','961',0.00,0.00,'961','2022-12-21 18:07:14','961','2022-12-21 18:07:37',10,0),('1','285',71,'DAILY SHIFT','2022-12-22','2022-12-22 06:39:10','2022-12-23 06:39:10','961',0.00,0.00,'961','2022-12-22 18:14:47','961','2022-12-22 18:15:13',10,0),('1','285',72,'DAILY SHIFT','2022-12-23','2022-12-23 06:36:55','2022-12-24 06:36:55','961',0.00,0.00,'961','2022-12-23 19:11:11','961','2022-12-23 19:11:33',10,0),('1','285',73,'DAILY SHIFT','2022-12-24','2022-12-24 06:28:00','2022-12-25 06:28:00','961',0.00,0.00,'961','2022-12-24 09:05:22','961','2022-12-24 09:05:47',10,0),('1','285',74,'DAILY SHIFT','2022-12-24','2022-12-24 09:07:14','2022-12-25 09:07:14','961',0.00,0.00,'961','2022-12-24 09:56:17','961','2022-12-24 09:56:36',10,0),('1','285',75,'DAILY SHIFT','2022-12-24','2022-12-24 10:04:00','2022-12-25 10:04:00','961',0.00,0.00,'961','2022-12-24 20:19:40','961','2022-12-24 20:20:06',10,0),('1','285',76,'DAILY SHIFT','2022-12-25','2022-12-25 06:38:24','2022-12-26 06:38:24','961',0.00,0.00,'961','2022-12-25 18:49:41','961','2022-12-25 18:50:05',10,0),('1','285',77,'DAILY SHIFT','2022-12-26','2022-12-26 07:18:21','2022-12-27 07:18:21','961',0.00,0.00,'961','2022-12-26 15:08:51','961','2022-12-26 15:09:17',10,0),('1','285',78,'DAILY SHIFT','2022-12-26','2022-12-26 15:16:57','2022-12-27 15:16:57','961',0.00,0.00,'961','2022-12-26 15:21:22','961','2022-12-26 15:21:43',10,0),('1','285',79,'DAILY SHIFT','2022-12-27','2022-12-27 06:34:48','2022-12-28 06:34:48','961',0.00,0.00,'961','2022-12-27 17:48:52','961','2022-12-27 17:49:16',10,0),('1','285',80,'DAILY SHIFT','2022-12-28','2022-12-28 06:56:39','2022-12-29 06:56:39','961',0.00,0.00,'961','2022-12-28 19:15:26','961','2022-12-28 19:15:48',10,0),('1','285',81,'DAILY SHIFT','2022-12-29','2022-12-29 07:07:50','2022-12-30 07:07:50','961',0.00,0.00,'961','2022-12-29 19:31:02','961','2022-12-29 19:31:24',10,0),('1','285',82,'DAILY SHIFT','2022-12-30','2022-12-30 06:41:56','2022-12-31 06:41:56','961',0.00,0.00,'961','2022-12-30 19:27:31','961','2022-12-30 19:28:04',10,0),('1','285',83,'DAILY SHIFT','2022-12-31','2022-12-31 06:59:58','2023-01-01 06:59:58','961',0.00,0.00,'961','2022-12-31 13:42:47','961','2022-12-31 13:43:08',10,0),('1','285',84,'DAILY SHIFT','2022-12-31','2022-12-31 13:44:17','2023-01-01 13:44:17','961',0.00,0.00,'961','2022-12-31 13:47:39','961','2022-12-31 13:48:13',10,0),('1','285',85,'DAILY SHIFT','2022-12-31','2022-12-31 13:53:32','2023-01-01 13:53:32','961',0.00,0.00,'961','2022-12-31 19:16:07','961','2022-12-31 19:16:45',10,0),('1','285',86,'DAILY SHIFT','2023-01-01','2023-01-01 07:36:34','2023-01-02 07:36:34','961',0.00,0.00,'961','2023-01-01 18:19:55','961','2023-01-01 18:20:15',10,0),('1','285',87,'DAILY SHIFT','2023-01-02','2023-01-02 06:15:58','2023-01-03 06:15:58','961',0.00,0.00,'961','2023-01-02 18:35:09','961','2023-01-02 18:35:34',10,0),('1','285',88,'DAILY SHIFT','2023-01-03','2023-01-03 06:45:04','2023-01-04 06:45:04','961',0.00,0.00,'961','2023-01-03 19:21:16','961','2023-01-03 19:21:56',10,0),('1','285',89,'DAILY SHIFT','2023-01-04','2023-01-04 06:33:35','2023-01-05 06:33:35','961',0.00,0.00,'961','2023-01-04 17:28:15','961','2023-01-04 17:28:37',10,0),('1','285',90,'DAILY SHIFT','2023-01-04','2023-01-04 17:32:28','2023-01-05 17:32:28','961',0.00,0.00,'961','2023-01-04 17:37:14','961','2023-01-04 17:37:37',10,0),('1','285',91,'DAILY SHIFT','2023-01-05','2023-01-05 06:57:24','2023-01-06 06:57:24','961',0.00,0.00,'961','2023-01-05 18:55:49','961','2023-01-05 18:56:09',10,0),('1','285',92,'DAILY SHIFT','2023-01-06','2023-01-06 07:09:55','2023-01-07 07:09:55','961',0.00,0.00,'961','2023-01-06 17:36:31','961','2023-01-06 17:36:53',10,0),('1','285',93,'DAILY SHIFT','2023-01-07','2023-01-07 06:51:51','2023-01-08 06:51:51','961',0.00,0.00,'961','2023-01-07 19:12:21','961','2023-01-07 19:12:44',10,0),('1','285',94,'DAILY SHIFT','2023-01-08','2023-01-08 07:08:55','2023-01-09 07:08:55','961',0.00,0.00,'961','2023-01-08 18:33:52','961','2023-01-08 18:34:13',10,0),('1','285',95,'DAILY SHIFT','2023-01-09','2023-01-09 06:42:10','2023-01-10 06:42:10','961',0.00,0.00,'961','2023-01-09 19:25:37','961','2023-01-09 19:26:19',10,0),('1','285',96,'DAILY SHIFT','2023-01-09','2023-01-09 19:32:13','2023-01-10 19:32:13','961',0.00,0.00,'961','2023-01-09 19:36:10','961','2023-01-09 19:36:42',10,0),('1','285',97,'DAILY SHIFT','2023-01-10','2023-01-10 06:28:59','2023-01-11 06:28:59','961',0.00,0.00,'961','2023-01-11 06:42:58','961','2023-01-11 06:43:20',10,0),('1','285',98,'DAILY SHIFT','2023-01-11','2023-01-11 06:44:45','2023-01-12 06:44:45','961',0.00,0.00,'961','2023-01-11 18:20:21','961','2023-01-11 18:21:02',10,0),('1','285',99,'DAILY SHIFT','2023-01-12','2023-01-12 06:45:14','2023-01-13 06:45:14','961',0.00,0.00,'961','2023-01-12 17:55:12','961','2023-01-12 17:55:31',10,0),('1','285',100,'DAILY SHIFT','2023-01-13','2023-01-13 06:59:08','2023-01-14 06:59:08','961',0.00,0.00,'961','2023-01-13 16:51:03','961','2023-01-13 16:51:24',10,0),('1','285',101,'DAILY SHIFT','2023-01-13','2023-01-13 16:51:51','2023-01-14 16:51:51','961',0.00,0.00,'961','2023-01-14 06:48:39','961','2023-01-14 06:49:07',10,0),('1','285',102,'DAILY SHIFT','2023-01-14','2023-01-14 06:49:31','2023-01-15 06:49:31','961',0.00,0.00,'961','2023-01-14 18:29:08','961','2023-01-14 18:29:30',10,0),('1','285',103,'DAILY SHIFT','2023-01-14','2023-01-14 18:59:55','2023-01-15 18:59:55','961',0.00,0.00,'961','2023-01-14 19:03:29','961','2023-01-14 19:03:48',10,0),('1','285',104,'DAILY SHIFT','2023-01-15','2023-01-15 06:46:34','2023-01-16 06:46:34','961',0.00,0.00,'961','2023-01-15 18:12:17','961','2023-01-15 18:12:37',10,0),('1','285',105,'DAILY SHIFT','2023-01-16','2023-01-16 06:43:43','2023-01-17 06:43:43','961',0.00,0.00,'961','2023-01-16 18:34:01','961','2023-01-16 18:34:46',10,0),('1','285',106,'DAILY SHIFT','2023-01-17','2023-01-17 06:36:33','2023-01-18 06:36:33','961',0.00,0.00,'961','2023-01-17 18:28:19','961','2023-01-17 18:29:01',10,0),('1','285',107,'DAILY SHIFT','2023-01-18','2023-01-18 06:36:34','2023-01-19 06:36:34','961',0.00,0.00,'961','2023-01-18 18:36:18','961','2023-01-18 18:36:40',10,0),('1','285',108,'DAILY SHIFT','2023-01-18','2023-01-18 18:41:23','2023-01-19 18:41:23','961',0.00,0.00,'961','2023-01-18 18:45:06','961','2023-01-18 18:45:33',10,0),('1','285',109,'DAILY SHIFT','2023-01-19','2023-01-19 06:41:53','2023-01-20 06:41:53','961',0.00,0.00,'961','2023-01-19 18:20:43','961','2023-01-19 18:21:09',10,0),('1','285',110,'DAILY SHIFT','2023-01-20','2023-01-20 06:48:00','2023-01-21 06:48:00','961',0.00,0.00,'961','2023-01-20 17:55:13','961','2023-01-20 17:55:34',10,0),('1','285',111,'DAILY SHIFT','2023-01-21','2023-01-21 06:36:11','2023-01-22 06:36:11','961',0.00,0.00,'961','2023-01-22 06:09:03','961','2023-01-22 06:09:25',10,0),('1','285',112,'DAILY SHIFT','2023-01-22','2023-01-22 06:10:03','2023-01-23 06:10:03','961',0.00,0.00,'961','2023-01-22 16:02:36','961','2023-01-22 16:03:20',10,0),('1','285',113,'DAILY SHIFT','2023-01-23','2023-01-23 06:02:37','2023-01-24 06:02:37','961',0.00,0.00,'961','2023-01-23 18:51:40','961','2023-01-23 18:51:58',10,0),('1','285',114,'DAILY SHIFT','2023-01-24','2023-01-24 06:04:11','2023-01-25 06:04:11','961',0.00,0.00,'961','2023-01-24 08:40:14','961','2023-01-24 08:40:33',10,0),('1','285',115,'DAILY SHIFT','2023-01-24','2023-01-24 08:41:06','2023-01-25 08:41:06','961',0.00,0.00,'961','2023-01-24 08:57:07','961','2023-01-24 08:57:58',10,0),('1','285',116,'DAILY SHIFT','2023-01-24','2023-01-24 09:00:43','2023-01-25 09:00:43','961',0.00,0.00,'961','2023-01-24 17:58:17','961','2023-01-24 17:58:36',10,0),('1','285',117,'DAILY SHIFT','2023-01-25','2023-01-25 06:18:13','2023-01-26 06:18:13','961',0.00,0.00,'961','2023-01-25 18:03:57','961','2023-01-25 18:04:17',10,0),('1','285',118,'DAILY SHIFT','2023-01-26','2023-01-26 05:59:42','2023-01-27 05:59:42','961',0.00,0.00,'961','2023-01-26 17:54:58','961','2023-01-26 17:55:24',10,0),('1','285',119,'DAILY SHIFT','2023-01-27','2023-01-27 06:17:05','2023-01-28 06:17:05','961',0.00,0.00,'961','2023-01-27 18:40:59','961','2023-01-27 18:41:23',10,0),('1','285',120,'DAILY SHIFT','2023-01-28','2023-01-28 06:19:45','2023-01-29 06:19:45','961',0.00,0.00,'961','2023-01-28 17:15:05','961','2023-01-28 17:15:30',10,0),('1','285',121,'DAILY SHIFT','2023-01-29','2023-01-29 06:07:34','2023-01-30 06:07:34','961',0.00,0.00,'961','2023-01-29 08:04:47','961','2023-01-29 08:05:15',10,0),('1','285',122,'DAILY SHIFT','2023-01-29','2023-01-29 08:07:08','2023-01-30 08:07:08','961',0.00,0.00,'961','2023-01-29 08:11:16','961','2023-01-29 08:11:34',10,0),('1','285',123,'DAILY SHIFT','2023-01-29','2023-01-29 08:12:12','2023-01-30 08:12:12','961',0.00,0.00,'961','2023-01-29 19:03:07','961','2023-01-29 19:03:27',10,0),('1','285',124,'DAILY SHIFT','2023-01-30','2023-01-30 06:38:25','2023-01-31 06:38:25','961',0.00,0.00,'961','2023-01-30 18:34:47','961','2023-01-30 18:35:09',10,0),('1','285',125,'DAILY SHIFT','2023-01-31','2023-01-31 06:09:53','2023-02-01 06:09:53','961',0.00,0.00,'961','2023-01-31 18:25:05','961','2023-01-31 18:25:26',10,0),('1','285',126,'DAILY SHIFT','2023-02-01','2023-02-01 06:02:42','2023-02-02 06:02:42','961',0.00,0.00,'961','2023-02-01 18:22:39','961','2023-02-01 18:23:03',10,0),('1','285',127,'DAILY SHIFT','2023-02-02','2023-02-02 06:03:34','2023-02-03 06:03:34','961',0.00,0.00,'961','2023-02-02 16:13:57','961','2023-02-02 16:14:20',10,0),('1','285',128,'DAILY SHIFT','2023-02-02','2023-02-02 16:19:52','2023-02-03 16:19:52','961',0.00,0.00,'961','2023-02-02 17:12:58','961','2023-02-02 17:13:14',10,0),('1','285',129,'DAILY SHIFT','2023-02-03','2023-02-03 07:30:39','2023-02-04 07:30:39','961',0.00,0.00,'961','2023-02-03 19:28:51','961','2023-02-03 19:29:16',10,0),('1','285',130,'DAILY SHIFT','2023-02-04','2023-02-04 06:02:51','2023-02-05 06:02:51','961',0.00,0.00,'961','2023-02-04 19:29:33','961','2023-02-04 19:29:52',10,0),('1','285',131,'DAILY SHIFT','2023-02-05','2023-02-05 06:22:02','2023-02-06 06:22:02','961',0.00,0.00,'961','2023-02-05 17:27:44','961','2023-02-05 17:28:09',10,0),('1','285',132,'DAILY SHIFT','2023-02-06','2023-02-06 05:46:46','2023-02-07 05:46:46','961',0.00,0.00,'961','2023-02-06 18:47:52','961','2023-02-06 18:48:11',10,0),('1','285',133,'DAILY SHIFT','2023-02-07','2023-02-07 06:32:20','2023-02-08 06:32:20','961',0.00,0.00,'961','2023-02-07 18:58:17','961','2023-02-07 18:58:35',10,0),('1','285',134,'DAILY SHIFT','2023-02-08','2023-02-08 06:14:07','2023-02-09 06:14:07','961',0.00,0.00,'961','2023-02-08 15:48:01','961','2023-02-08 15:48:22',10,0),('1','285',135,'BULK SALES','2023-02-08','2023-02-08 15:54:31','2023-02-09 15:54:31','961',0.00,0.00,'961','2023-02-08 15:59:02','961','2023-02-08 15:59:25',10,0),('1','285',136,'DAILY SHIFT','2023-02-09','2023-02-09 05:59:30','2023-02-10 05:59:30','961',0.00,0.00,'961','2023-02-10 05:48:05','961','2023-02-10 05:48:33',10,0),('1','285',137,'DAILY SHIFT','2023-02-10','2023-02-10 05:49:10','2023-02-11 05:49:10','961',0.00,0.00,'961','2023-02-10 19:51:41','961','2023-02-10 19:52:03',10,0),('1','285',138,'DAILY SHIFT','2023-02-11','2023-02-11 07:01:08','2023-02-12 07:01:08','961',0.00,0.00,'961','2023-02-11 19:08:25','961','2023-02-11 19:08:50',10,0),('1','285',139,'DAILY SHIFT','2023-02-12','2023-02-12 07:03:58','2023-02-13 07:03:58','961',0.00,0.00,'961','2023-02-12 17:11:37','961','2023-02-12 17:11:56',10,0),('1','285',140,'DAILY SHIFT','2023-02-13','2023-02-13 06:07:57','2023-02-14 06:07:57','961',0.00,0.00,'961','2023-02-13 19:21:35','961','2023-02-13 19:22:03',10,0),('1','285',141,'DAILY SHIFT','2023-02-14','2023-02-14 06:14:45','2023-02-15 06:14:45','961',0.00,0.00,'961','2023-02-14 11:25:17','961','2023-02-14 11:25:39',10,0),('1','285',142,'DAILY SHIFT','2023-02-14','2023-02-14 11:27:08','2023-02-15 11:27:08','961',0.00,0.00,'961','2023-02-14 11:39:11','961','2023-02-14 11:39:31',10,0),('1','285',143,'DAILY SHIFT','2023-02-14','2023-02-14 11:39:51','2023-02-15 11:39:51','961',0.00,0.00,'961','2023-02-14 20:14:58','961','2023-02-14 20:15:24',10,0),('1','285',144,'DAILY SHIFT','2023-02-15','2023-02-15 06:33:59','2023-02-16 06:33:59','961',0.00,0.00,'961','2023-02-15 19:17:50','961','2023-02-15 19:18:48',10,0),('1','285',145,'DAILY SHIFT','2023-02-16','2023-02-16 06:02:11','2023-02-17 06:02:11','961',0.00,0.00,'961','2023-02-16 18:27:55','961','2023-02-16 18:28:18',10,0),('1','285',146,'DAILY SHIFT','2023-02-17','2023-02-17 06:09:25','2023-02-18 06:09:25','961',0.00,0.00,'961','2023-02-17 17:39:03','961','2023-02-17 17:39:21',10,0),('1','285',147,'DAILY SHIFT','2023-02-18','2023-02-18 06:30:29','2023-02-19 06:30:29','961',0.00,0.00,'961','2023-02-18 20:25:47','961','2023-02-18 20:26:06',10,0),('1','285',148,'DAILY SHIFT','2023-02-19','2023-02-19 06:01:25','2023-02-20 06:01:25','961',0.00,0.00,'961','2023-02-19 18:32:58','961','2023-02-19 18:34:04',10,0),('1','285',149,'DAILY SHIFT','2023-02-20','2023-02-20 06:08:22','2023-02-21 06:08:22','961',0.00,0.00,'961','2023-02-20 19:01:48','961','2023-02-20 19:02:35',10,0),('1','285',150,'DAILY SHIFT','2023-02-21','2023-02-21 06:27:33','2023-02-22 06:27:33','961',0.00,0.00,'961','2023-02-21 08:45:32','961','2023-02-21 08:45:48',10,0),('1','285',151,'BULK SALES','2023-02-21','2023-02-21 08:47:14','2023-02-22 08:47:14','961',0.00,0.00,'961','2023-02-21 08:51:22','961','2023-02-21 08:51:41',10,0),('1','285',152,'DAILY SHIFT','2023-02-21','2023-02-21 08:57:08','2023-02-22 08:57:08','961',0.00,0.00,'961','2023-02-21 18:39:53','961','2023-02-21 18:40:11',10,0),('1','285',153,'DAILY SHIFT','2023-02-22','2023-02-22 06:00:20','2023-02-23 06:00:20','961',0.00,0.00,'961','2023-02-22 20:42:03','961','2023-02-22 20:42:24',10,0),('1','285',154,'DAILY SHIFT','2023-02-23','2023-02-23 06:03:00','2023-02-24 06:03:00','961',0.00,0.00,'961','2023-02-23 19:30:09','961','2023-02-23 19:30:27',10,0),('1','285',155,'DAILY SHIFT','2023-02-24','2023-02-24 06:17:04','2023-02-25 06:17:04','961',0.00,0.00,'961','2023-02-24 19:29:17','961','2023-02-24 19:29:47',10,0),('1','285',156,'DAILY SHIFT','2023-02-27','2023-02-27 06:05:58','2023-02-28 06:05:58','961',0.00,0.00,'961','2023-02-27 17:13:13','961','2023-02-27 17:13:35',10,0),('1','285',157,'BULK SALES','2023-02-27','2023-02-27 17:36:30','2023-02-28 17:36:30','961',0.00,0.00,'961','2023-02-27 17:40:14','961','2023-02-27 17:40:31',10,0),('1','285',158,'DAILY SHIFT','2023-02-28','2023-02-28 05:34:53','2023-03-01 05:34:53','961',0.00,0.00,'961','2023-02-28 18:31:28','961','2023-02-28 18:31:51',10,0),('1','285',159,'DAILY SHIFT','2023-03-01','2023-03-01 06:25:41','2023-03-02 06:25:41','961',0.00,0.00,'961','2023-03-01 19:15:00','961','2023-03-01 19:15:18',10,0),('1','285',160,'DAILY SHIFT','2023-03-02','2023-03-02 06:12:30','2023-03-03 06:12:30','961',0.00,0.00,'961','2023-03-02 17:34:24','961','2023-03-02 17:34:58',10,0),('1','285',161,'DAILY SHIFT','2023-03-03','2023-03-03 06:27:16','2023-03-04 06:27:16','961',0.00,0.00,'961','2023-03-03 19:49:53','961','2023-03-03 19:50:13',10,0),('1','285',162,'DAILY SHIFT','2023-03-04','2023-03-04 05:59:03','2023-03-05 05:59:03','961',0.00,0.00,'961','2023-03-04 16:31:31','961','2023-03-04 16:31:51',10,0),('1','285',163,'BULK SALES','2023-03-05','2023-03-05 06:39:50','2023-03-06 06:39:50','961',0.00,0.00,'961','2023-03-05 06:51:04','961','2023-03-05 06:52:13',10,0),('1','285',164,'DAILY SHIFT','2023-03-05','2023-03-05 08:20:01','2023-03-06 08:20:01','961',0.00,0.00,'961','2023-03-05 16:26:12','961','2023-03-05 16:26:33',10,0),('1','285',165,'DAILY SHIFT','2023-03-06','2023-03-06 06:44:31','2023-03-07 06:44:31','961',0.00,0.00,'961','2023-03-06 18:23:40','961','2023-03-06 18:23:59',10,0),('1','285',166,'DAILY SHIFT','2023-03-07','2023-03-07 05:47:51','2023-03-08 05:47:51','961',0.00,0.00,'961','2023-03-07 18:10:09','961','2023-03-07 18:10:30',10,0),('1','285',167,'DAILY SHIFT','2023-03-08','2023-03-08 05:51:33','2023-03-09 05:51:33','961',0.00,0.00,'961','2023-03-08 17:30:04','961','2023-03-08 17:30:30',10,0),('1','285',168,'DAILY SHIFT','2023-03-09','2023-03-09 06:08:29','2023-03-10 06:08:29','961',0.00,0.00,'961','2023-03-09 18:06:28','961','2023-03-09 18:07:00',10,0),('1','285',169,'DAILY SHIFT','2023-03-10','2023-03-10 06:07:13','2023-03-11 06:07:13','961',0.00,0.00,'961','2023-03-10 13:12:24','961','2023-03-10 13:12:43',10,0),('1','285',170,'BULK SALES','2023-03-10','2023-03-10 13:13:18','2023-03-11 13:13:18','961',0.00,0.00,'961','2023-03-10 16:42:23','961','2023-03-10 16:42:42',10,0),('1','285',171,'DAILY SHIFT','2023-03-11','2023-03-11 06:27:03','2023-03-12 06:27:03','961',0.00,0.00,'961','2023-03-11 18:37:45','961','2023-03-11 18:38:41',10,0),('1','285',172,'DAILY SHIFT','2023-03-12','2023-03-12 05:52:02','2023-03-13 05:52:02','961',0.00,0.00,'961','2023-03-12 16:41:28','961','2023-03-12 16:41:51',10,0),('1','285',173,'DAILY SHIFT','2023-03-13','2023-03-13 05:56:21','2023-03-14 05:56:21','961',0.00,0.00,'961','2023-03-13 18:31:55','961','2023-03-13 18:32:20',10,0),('1','285',174,'DAILY SHIFT','2023-03-14','2023-03-14 06:16:24','2023-03-15 06:16:24','961',0.00,0.00,'961','2023-03-14 17:13:48','961','2023-03-14 17:14:15',10,0),('1','285',175,'DAILY SHIFT','2023-03-15','2023-03-15 05:57:54','2023-03-16 05:57:54','961',0.00,0.00,'961','2023-03-15 09:31:38','961','2023-03-15 09:31:58',10,0),('1','285',176,'BULK SALES','2023-03-15','2023-03-15 09:32:23','2023-03-16 09:32:23','961',0.00,0.00,'961','2023-03-15 09:35:41','961','2023-03-15 09:35:59',10,0),('1','285',177,'DAILY SHIFT','2023-03-15','2023-03-15 10:45:31','2023-03-16 10:45:31','961',0.00,0.00,'961','2023-03-15 17:44:23','961','2023-03-15 17:44:44',10,0),('1','285',178,'DAILY SHIFT','2023-03-16','2023-03-16 05:59:26','2023-03-17 05:59:26','961',0.00,0.00,'961','2023-03-16 17:37:08','961','2023-03-16 17:37:30',10,0),('1','285',179,'DAILY SHIFT','2023-03-17','2023-03-17 06:04:18','2023-03-18 06:04:18','961',0.00,0.00,'961','2023-03-17 19:15:07','961','2023-03-17 19:15:30',10,0),('1','285',180,'DAILY SHIFT','2023-03-20','2023-03-20 05:52:52','2023-03-21 05:52:52','961',0.00,0.00,'961','2023-03-20 19:19:06','961','2023-03-20 19:19:25',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=1081 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','285','1','1',1,'1','1',0.00,119.80,0.00,0.00,119.80,86256.00,0.00,0.00,0.00),('1','285','1','1',2,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','1',3,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','1',4,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','1',5,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','1',6,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','2',7,'1','1',119.80,250.25,0.00,0.00,130.45,93924.00,0.00,0.00,0.00),('1','285','1','2',8,'2','1',0.00,61.97,0.00,0.00,61.97,41829.75,0.00,0.00,0.00),('1','285','1','2',9,'3','1',0.00,404.81,0.00,0.00,404.81,273246.75,0.00,0.00,0.00),('1','285','1','2',10,'4','1',0.00,50.00,0.00,0.00,50.00,33750.00,0.00,0.00,0.00),('1','285','1','2',11,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','2',12,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','3',13,'1','1',250.25,387.30,0.00,0.00,137.05,98676.00,0.00,0.00,0.00),('1','285','1','3',14,'2','1',61.97,61.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','3',15,'3','1',404.81,404.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','3',16,'4','1',50.00,111.94,0.00,0.00,61.94,41809.50,0.00,0.00,0.00),('1','285','1','3',17,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','3',18,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','4',19,'1','1',387.30,506.46,0.00,0.00,119.16,85795.20,0.00,0.00,0.00),('1','285','1','4',20,'2','1',61.97,921.34,0.00,0.00,859.37,580074.75,0.00,0.00,0.00),('1','285','1','4',21,'3','1',404.81,622.18,0.00,0.00,217.37,146724.75,0.00,0.00,0.00),('1','285','1','4',22,'4','1',111.94,313.07,0.00,0.00,201.13,135762.75,0.00,0.00,0.00),('1','285','1','4',23,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','4',24,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','5',25,'1','1',506.46,637.38,0.00,0.00,130.92,94262.40,0.00,0.00,0.00),('1','285','1','5',26,'2','1',921.34,1869.51,0.00,0.00,948.17,637014.75,0.00,0.00,0.00),('1','285','1','5',27,'3','1',622.18,823.36,0.00,0.00,201.18,135796.50,0.00,0.00,0.00),('1','285','1','5',28,'4','1',313.07,383.72,0.00,0.00,70.65,47688.75,0.00,0.00,0.00),('1','285','1','5',29,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','5',30,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','6',31,'1','1',637.38,770.54,0.00,0.00,133.16,95875.20,0.00,0.00,0.00),('1','285','1','6',32,'2','1',1869.51,3711.23,0.00,0.00,1841.72,1239782.10,0.00,0.00,0.00),('1','285','1','6',33,'3','1',823.36,2053.54,0.00,0.00,1230.18,830371.50,0.00,0.00,0.00),('1','285','1','6',34,'4','1',383.72,991.31,0.00,0.00,607.59,410123.25,0.00,0.00,0.00),('1','285','1','6',35,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','6',36,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','7',37,'1','1',770.54,902.77,0.00,0.00,132.23,95205.60,0.00,0.00,0.00),('1','285','1','7',38,'2','1',3711.23,4440.06,0.00,0.00,728.83,491960.25,0.00,0.00,0.00),('1','285','1','7',39,'3','1',2053.54,2697.88,0.00,0.00,644.34,434929.50,0.00,0.00,0.00),('1','285','1','7',40,'4','1',991.31,1034.53,0.00,0.00,43.22,29173.50,0.00,0.00,0.00),('1','285','1','7',41,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','7',42,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','8',43,'1','1',902.77,1126.58,0.00,0.00,223.81,160956.45,0.00,0.00,0.00),('1','285','1','8',44,'2','1',4440.06,5224.03,0.00,0.00,783.97,529179.75,0.00,0.00,0.00),('1','285','1','8',45,'3','1',2697.88,3777.26,0.00,0.00,1079.38,728581.50,0.00,0.00,0.00),('1','285','1','8',46,'4','1',1034.53,2499.16,0.00,0.00,1464.63,988625.25,0.00,0.00,0.00),('1','285','1','8',47,'5','1',0.00,24.88,0.00,0.00,24.88,16794.00,0.00,0.00,0.00),('1','285','1','8',48,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','9',49,'1','1',1126.58,1310.16,0.00,0.00,183.58,132177.60,0.00,0.00,0.00),('1','285','1','9',50,'2','1',5224.03,6172.89,0.00,0.00,948.86,640480.50,0.00,0.00,0.00),('1','285','1','9',51,'3','1',3777.26,4406.38,0.00,0.00,629.12,424656.00,0.00,0.00,0.00),('1','285','1','9',52,'4','1',2499.16,2805.16,0.00,0.00,306.00,206550.00,0.00,0.00,0.00),('1','285','1','9',53,'5','1',24.88,271.28,0.00,0.00,246.40,166320.00,0.00,0.00,0.00),('1','285','1','9',54,'6','1',0.00,174.44,0.00,0.00,174.44,117747.00,0.00,0.00,0.00),('1','285','1','10',55,'1','1',1310.16,1507.41,0.00,0.00,197.25,142020.00,0.00,0.00,0.00),('1','285','1','10',56,'2','1',6172.89,6819.83,0.00,0.00,646.94,436684.50,0.00,0.00,0.00),('1','285','1','10',57,'3','1',4406.38,4829.13,0.00,0.00,422.75,285356.25,0.00,0.00,0.00),('1','285','1','10',58,'4','1',2805.16,3099.55,0.00,0.00,294.39,198713.25,0.00,0.00,0.00),('1','285','1','10',59,'5','1',271.28,429.88,0.00,0.00,158.60,107055.00,0.00,0.00,0.00),('1','285','1','10',60,'6','1',174.44,320.50,0.00,0.00,146.06,98590.50,0.00,0.00,0.00),('1','285','1','11',61,'1','1',1507.41,1690.26,0.00,0.00,182.85,131652.00,0.00,0.00,0.00),('1','285','1','11',62,'2','1',6819.83,7395.63,0.00,0.00,575.80,388665.00,0.00,0.00,0.00),('1','285','1','11',63,'3','1',4829.13,5049.43,0.00,0.00,220.30,148837.50,0.00,0.00,0.00),('1','285','1','11',64,'4','1',3099.55,3159.18,0.00,0.00,59.63,40250.25,0.00,0.00,0.00),('1','285','1','11',65,'5','1',429.88,901.13,0.00,0.00,471.25,318093.75,0.00,0.00,0.00),('1','285','1','11',66,'6','1',320.50,518.49,0.00,0.00,197.99,133643.25,0.00,0.00,0.00),('1','285','1','12',67,'1','1',1690.26,1801.23,0.00,0.00,110.97,79898.40,0.00,0.00,0.00),('1','285','1','12',68,'2','1',7395.63,7795.82,0.00,0.00,400.19,270128.25,0.00,0.00,0.00),('1','285','1','12',69,'3','1',5049.43,6063.70,0.00,0.00,1014.27,684632.25,0.00,0.00,0.00),('1','285','1','12',70,'4','1',3159.18,3219.18,0.00,0.00,60.00,40500.00,0.00,0.00,0.00),('1','285','1','12',71,'5','1',901.13,1297.02,0.00,0.00,395.89,267225.75,0.00,0.00,0.00),('1','285','1','12',72,'6','1',518.49,636.38,0.00,0.00,117.89,79575.75,0.00,0.00,0.00),('1','285','1','13',73,'1','1',1801.23,1959.09,0.00,0.00,157.86,113659.20,0.00,0.00,0.00),('1','285','1','13',74,'2','1',7795.82,8120.45,0.00,0.00,324.63,219125.25,0.00,0.00,0.00),('1','285','1','13',75,'3','1',6063.70,6597.37,0.00,0.00,533.67,360227.25,0.00,0.00,0.00),('1','285','1','13',76,'4','1',3219.18,3280.98,0.00,0.00,61.80,41715.00,0.00,0.00,0.00),('1','285','1','13',77,'5','1',1297.02,1299.80,0.00,0.00,2.78,1876.50,0.00,0.00,0.00),('1','285','1','13',78,'6','1',636.38,1623.22,0.00,0.00,986.84,662714.55,0.00,0.00,0.00),('1','285','1','14',79,'1','1',1959.09,2045.26,0.00,0.00,86.17,62042.40,0.00,0.00,0.00),('1','285','1','14',80,'2','1',8120.45,8544.80,0.00,0.00,424.35,286436.25,0.00,0.00,0.00),('1','285','1','14',81,'3','1',6597.37,6870.78,0.00,0.00,273.41,184641.75,0.00,0.00,0.00),('1','285','1','14',82,'4','1',3280.98,3371.36,0.00,0.00,90.38,61006.50,0.00,0.00,0.00),('1','285','1','14',83,'5','1',1299.80,1299.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','14',84,'6','1',1623.22,1758.58,0.00,0.00,135.36,91368.00,0.00,0.00,0.00),('1','285','1','15',85,'1','1',2045.26,2045.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','15',86,'2','1',8544.80,8544.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','15',87,'3','1',6870.78,6870.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','15',88,'4','1',3371.36,3371.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','15',89,'5','1',1299.80,1299.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','15',90,'6','1',1758.58,1758.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','16',91,'1','1',2045.26,2060.13,0.00,0.00,14.87,10706.40,0.00,0.00,0.00),('1','285','1','16',92,'2','1',8544.80,8544.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','16',93,'3','1',6870.78,7088.78,0.00,0.00,218.00,147150.00,0.00,0.00,0.00),('1','285','1','16',94,'4','1',3371.36,3371.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','16',95,'5','1',1299.80,1364.44,0.00,0.00,64.64,43632.00,0.00,0.00,0.00),('1','285','1','16',96,'6','1',1758.58,1758.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','17',97,'1','1',2060.13,2416.57,0.00,0.00,356.44,256636.80,0.00,0.00,0.00),('1','285','1','17',98,'2','1',8544.80,9427.27,0.00,0.00,882.47,595760.85,0.00,0.00,0.00),('1','285','1','17',99,'3','1',7088.78,7797.66,0.00,0.00,708.88,478762.65,0.00,0.00,0.00),('1','285','1','17',100,'4','1',3371.36,3603.81,0.00,0.00,232.45,156903.75,0.00,0.00,0.00),('1','285','1','17',101,'5','1',1364.44,1915.27,0.00,0.00,550.83,371810.25,0.00,0.00,0.00),('1','285','1','17',102,'6','1',1758.58,2369.93,0.00,0.00,611.35,412661.25,0.00,0.00,0.00),('1','285','1','18',103,'1','1',2416.57,2668.54,0.00,0.00,251.97,181418.40,0.00,0.00,0.00),('1','285','1','18',104,'2','1',9427.27,9864.67,0.00,0.00,437.40,295245.00,0.00,0.00,0.00),('1','285','1','18',105,'3','1',7797.66,9047.58,0.00,0.00,1249.92,843696.00,0.00,0.00,0.00),('1','285','1','18',106,'4','1',3603.81,3698.81,0.00,0.00,95.00,64125.00,0.00,0.00,0.00),('1','285','1','18',107,'5','1',1915.27,2066.42,0.00,0.00,151.15,102026.25,0.00,0.00,0.00),('1','285','1','18',108,'6','1',2369.93,2532.93,0.00,0.00,163.00,110025.00,0.00,0.00,0.00),('1','285','1','19',109,'1','1',2668.54,2887.99,0.00,0.00,219.45,158004.00,0.00,0.00,0.00),('1','285','1','19',110,'2','1',9864.67,10309.24,0.00,0.00,444.57,300084.75,0.00,0.00,0.00),('1','285','1','19',111,'3','1',9047.58,9488.29,0.00,0.00,440.71,297212.13,0.00,0.00,0.00),('1','285','1','19',112,'4','1',3698.81,4221.18,0.00,0.00,522.37,352599.75,0.00,0.00,0.00),('1','285','1','19',113,'5','1',2066.42,2294.63,0.00,0.00,228.21,154041.75,0.00,0.00,0.00),('1','285','1','19',114,'6','1',2532.93,3027.18,0.00,0.00,494.25,333618.75,0.00,0.00,0.00),('1','285','1','20',115,'1','1',2887.99,3154.87,0.00,0.00,266.88,192153.60,0.00,0.00,0.00),('1','285','1','20',116,'2','1',10309.24,10397.81,0.00,0.00,88.57,59784.75,0.00,0.00,0.00),('1','285','1','20',117,'3','1',9488.29,10465.96,0.00,0.00,977.67,659927.25,0.00,0.00,0.00),('1','285','1','20',118,'4','1',4221.18,5097.70,0.00,0.00,876.52,591651.00,0.00,0.00,0.00),('1','285','1','20',119,'5','1',2294.63,2583.51,0.00,0.00,288.88,194994.00,0.00,0.00,0.00),('1','285','1','20',120,'6','1',3027.18,3706.10,0.00,0.00,678.92,458271.00,0.00,0.00,0.00),('1','285','1','21',121,'1','1',3154.87,3360.25,0.00,0.00,205.38,147873.60,0.00,0.00,0.00),('1','285','1','21',122,'2','1',10397.81,10851.15,0.00,0.00,453.34,306004.50,0.00,0.00,0.00),('1','285','1','21',123,'3','1',10465.96,11984.32,0.00,0.00,1518.36,1024893.00,0.00,0.00,0.00),('1','285','1','21',124,'4','1',5097.70,5525.84,0.00,0.00,428.14,288994.50,0.00,0.00,0.00),('1','285','1','21',125,'5','1',2583.51,2786.27,0.00,0.00,202.76,136863.00,0.00,0.00,0.00),('1','285','1','21',126,'6','1',3706.10,4013.57,0.00,0.00,307.47,207542.25,0.00,0.00,0.00),('1','285','1','22',127,'1','1',3360.25,3650.45,0.00,0.00,290.20,208944.00,0.00,0.00,0.00),('1','285','1','22',128,'2','1',10851.15,11393.13,0.00,0.00,541.98,366063.75,0.00,0.00,0.00),('1','285','1','22',129,'3','1',11984.32,12814.13,0.00,0.00,829.81,560121.75,0.00,0.00,0.00),('1','285','1','22',130,'4','1',5525.84,5654.61,0.00,0.00,128.77,86919.75,0.00,0.00,0.00),('1','285','1','22',131,'5','1',2786.27,3701.19,0.00,0.00,914.92,617571.00,0.00,0.00,0.00),('1','285','1','22',132,'6','1',4013.57,4190.14,0.00,0.00,176.57,119184.75,0.00,0.00,0.00),('1','285','1','23',133,'1','1',3650.45,3650.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','23',134,'2','1',11393.13,11393.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','23',135,'3','1',12814.13,12814.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','23',136,'4','1',5654.61,5654.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','23',137,'5','1',3701.19,3701.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','23',138,'6','1',4190.14,4190.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','24',139,'1','1',3650.45,3823.66,0.00,0.00,173.21,129907.50,0.00,0.00,0.00),('1','285','1','24',140,'2','1',11393.13,11707.27,0.00,0.00,314.14,216756.60,0.00,0.00,0.00),('1','285','1','24',141,'3','1',12814.13,13323.15,0.00,0.00,509.02,351223.80,0.00,0.00,0.00),('1','285','1','24',142,'4','1',5654.61,5916.89,0.00,0.00,262.28,181033.20,0.00,0.00,0.00),('1','285','1','24',143,'5','1',3701.19,4240.82,0.00,0.00,539.63,372344.70,0.00,0.00,0.00),('1','285','1','24',144,'6','1',4190.14,4537.14,0.00,0.00,347.00,239430.00,0.00,0.00,0.00),('1','285','1','25',145,'1','1',3823.66,4051.68,0.00,0.00,228.02,171015.00,0.00,0.00,0.00),('1','285','1','25',146,'2','1',11707.27,12423.77,0.00,0.00,716.50,494385.00,0.00,0.00,0.00),('1','285','1','25',147,'3','1',13323.15,14050.34,0.00,0.00,727.19,501761.10,0.00,0.00,0.00),('1','285','1','25',148,'4','1',5916.89,6089.73,0.00,0.00,172.84,119259.60,0.00,0.00,0.00),('1','285','1','25',149,'5','1',4240.82,4336.36,0.00,0.00,95.54,65922.60,0.00,0.00,0.00),('1','285','1','25',150,'6','1',4537.14,4926.60,0.00,0.00,389.46,268727.40,0.00,0.00,0.00),('1','285','1','26',151,'1','1',4051.68,4200.00,0.00,0.00,148.32,111240.00,0.00,0.00,0.00),('1','285','1','26',152,'2','1',12423.77,12887.50,0.00,0.00,463.73,319973.70,0.00,0.00,0.00),('1','285','1','26',153,'3','1',14050.34,14514.88,0.00,0.00,464.54,320532.60,0.00,0.00,0.00),('1','285','1','26',154,'4','1',6089.73,6229.73,0.00,0.00,140.00,96600.00,0.00,0.00,0.00),('1','285','1','26',155,'5','1',4336.36,4428.36,0.00,0.00,92.00,63480.00,0.00,0.00,0.00),('1','285','1','26',156,'6','1',4926.60,5138.56,0.00,0.00,211.96,146252.40,0.00,0.00,0.00),('1','285','1','27',157,'1','1',4200.00,4357.90,0.00,0.00,157.90,118425.00,0.00,0.00,0.00),('1','285','1','27',158,'2','1',12887.50,13094.56,0.00,0.00,207.06,142871.40,0.00,0.00,0.00),('1','285','1','27',159,'3','1',14514.88,14872.88,0.00,0.00,358.00,247020.00,0.00,0.00,0.00),('1','285','1','27',160,'4','1',6229.73,6229.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','27',161,'5','1',4428.36,4609.55,0.00,0.00,181.19,125021.10,0.00,0.00,0.00),('1','285','1','27',162,'6','1',5138.56,5138.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','28',163,'1','1',4357.90,4542.09,0.00,0.00,184.19,138142.50,0.00,0.00,0.00),('1','285','1','28',164,'2','1',13094.56,13357.22,0.00,0.00,262.66,181235.40,0.00,0.00,0.00),('1','285','1','28',165,'3','1',14872.88,15607.78,0.00,0.00,734.90,507081.00,0.00,0.00,0.00),('1','285','1','28',166,'4','1',6229.73,6234.73,0.00,0.00,5.00,3450.00,0.00,0.00,0.00),('1','285','1','28',167,'5','1',4609.55,4686.58,0.00,0.00,77.03,53150.70,0.00,0.00,0.00),('1','285','1','28',168,'6','1',5138.56,5138.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','29',169,'1','1',4542.09,4668.41,0.00,0.00,126.32,94740.00,0.00,0.00,0.00),('1','285','1','29',170,'2','1',13357.22,13910.08,0.00,0.00,552.86,381473.40,0.00,0.00,0.00),('1','285','1','29',171,'3','1',15607.78,15902.78,0.00,0.00,295.00,203550.00,0.00,0.00,0.00),('1','285','1','29',172,'4','1',6234.73,6487.09,0.00,0.00,252.36,174128.40,0.00,0.00,0.00),('1','285','1','29',173,'5','1',4686.58,4770.58,0.00,0.00,84.00,57960.00,0.00,0.00,0.00),('1','285','1','29',174,'6','1',5138.56,5273.61,0.00,0.00,135.05,93184.50,0.00,0.00,0.00),('1','285','1','30',175,'1','1',4668.41,4835.78,0.00,0.00,167.37,125527.50,0.00,0.00,0.00),('1','285','1','30',176,'2','1',13910.08,14075.05,0.00,0.00,164.97,113829.30,0.00,0.00,0.00),('1','285','1','30',177,'3','1',15902.78,16363.02,0.00,0.00,460.24,317565.60,0.00,0.00,0.00),('1','285','1','30',178,'4','1',6487.09,6651.81,0.00,0.00,164.72,113656.80,0.00,0.00,0.00),('1','285','1','30',179,'5','1',4770.58,4855.15,0.00,0.00,84.57,58353.30,0.00,0.00,0.00),('1','285','1','30',180,'6','1',5273.61,5273.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','31',181,'1','1',4835.78,5065.29,0.00,0.00,229.51,172132.50,0.00,0.00,0.00),('1','285','1','31',182,'2','1',14075.05,14353.42,0.00,0.00,278.37,192075.30,0.00,0.00,0.00),('1','285','1','31',183,'3','1',16363.02,16968.39,0.00,0.00,605.37,417705.30,0.00,0.00,0.00),('1','285','1','31',184,'4','1',6651.81,6924.95,0.00,0.00,273.14,188466.60,0.00,0.00,0.00),('1','285','1','31',185,'5','1',4855.15,5000.48,0.00,0.00,145.33,100277.70,0.00,0.00,0.00),('1','285','1','31',186,'6','1',5273.61,5404.22,0.00,0.00,130.61,90120.90,0.00,0.00,0.00),('1','285','1','32',187,'1','1',5065.29,5275.24,0.00,0.00,209.95,157462.50,0.00,0.00,0.00),('1','285','1','32',188,'2','1',14353.42,14611.57,0.00,0.00,258.15,178123.50,0.00,0.00,0.00),('1','285','1','32',189,'3','1',16968.39,17366.81,0.00,0.00,398.42,274909.80,0.00,0.00,0.00),('1','285','1','32',190,'4','1',6924.95,7211.52,0.00,0.00,286.57,197733.30,0.00,0.00,0.00),('1','285','1','32',191,'5','1',5000.48,5172.26,0.00,0.00,171.78,118528.20,0.00,0.00,0.00),('1','285','1','32',192,'6','1',5404.22,5467.48,0.00,0.00,63.26,43649.40,0.00,0.00,0.00),('1','285','1','33',193,'1','1',5275.24,5423.74,0.00,0.00,148.50,111375.00,0.00,0.00,0.00),('1','285','1','33',194,'2','1',14611.57,14784.02,0.00,0.00,172.45,118990.50,0.00,0.00,0.00),('1','285','1','33',195,'3','1',17366.81,17777.62,0.00,0.00,410.81,283458.90,0.00,0.00,0.00),('1','285','1','33',196,'4','1',7211.52,7340.07,0.00,0.00,128.55,88699.50,0.00,0.00,0.00),('1','285','1','33',197,'5','1',5172.26,5222.26,0.00,0.00,50.00,34500.00,0.00,0.00,0.00),('1','285','1','33',198,'6','1',5467.48,5530.72,0.00,0.00,63.24,43635.60,0.00,0.00,0.00),('1','285','1','34',199,'1','1',5423.74,5586.76,0.00,0.00,163.02,122265.00,0.00,0.00,0.00),('1','285','1','34',200,'2','1',14784.02,15563.49,0.00,0.00,779.47,537834.30,0.00,0.00,0.00),('1','285','1','34',201,'3','1',17777.62,18004.16,0.00,0.00,226.54,156312.60,0.00,0.00,0.00),('1','285','1','34',202,'4','1',7340.07,7390.07,0.00,0.00,50.00,34500.00,0.00,0.00,0.00),('1','285','1','34',203,'5','1',5222.26,5222.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','34',204,'6','1',5530.72,5530.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','35',205,'1','1',5586.76,5735.24,0.00,0.00,148.48,111360.00,0.00,0.00,0.00),('1','285','1','35',206,'2','1',15563.49,15692.48,0.00,0.00,128.99,87713.20,0.00,0.00,0.00),('1','285','1','35',207,'3','1',18004.16,18333.26,0.00,0.00,329.10,223788.00,0.00,0.00,0.00),('1','285','1','35',208,'4','1',7390.07,7530.35,0.00,0.00,140.28,95390.40,0.00,0.00,0.00),('1','285','1','35',209,'5','1',5222.26,5289.43,0.00,0.00,67.17,45675.60,0.00,0.00,0.00),('1','285','1','35',210,'6','1',5530.72,5627.68,0.00,0.00,96.96,65932.80,0.00,0.00,0.00),('1','285','1','36',211,'1','1',5735.24,5968.03,0.00,0.00,232.79,174592.50,0.00,0.00,0.00),('1','285','1','36',212,'2','1',15692.48,16256.94,0.00,0.00,564.46,383832.80,0.00,0.00,0.00),('1','285','1','36',213,'3','1',18333.26,18699.66,0.00,0.00,366.40,249152.00,0.00,0.00,0.00),('1','285','1','36',214,'4','1',7530.35,7743.79,0.00,0.00,213.44,145139.20,0.00,0.00,0.00),('1','285','1','36',215,'5','1',5289.43,5289.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','36',216,'6','1',5627.68,5712.31,0.00,0.00,84.63,57548.40,0.00,0.00,0.00),('1','285','1','37',217,'1','1',5968.03,6085.67,0.00,0.00,117.64,88230.00,0.00,0.00,0.00),('1','285','1','37',218,'2','1',16256.94,16650.09,0.00,0.00,393.15,267342.00,0.00,0.00,0.00),('1','285','1','37',219,'3','1',18699.66,18966.22,0.00,0.00,266.56,181260.80,0.00,0.00,0.00),('1','285','1','37',220,'4','1',7743.79,7917.82,0.00,0.00,174.03,118340.40,0.00,0.00,0.00),('1','285','1','37',221,'5','1',5289.43,5348.43,0.00,0.00,59.00,40120.00,0.00,0.00,0.00),('1','285','1','37',222,'6','1',5712.31,5712.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','38',223,'1','1',6085.67,6085.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','38',224,'2','1',16650.09,16650.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','38',225,'3','1',18966.22,18966.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','38',226,'4','1',7917.82,7917.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','38',227,'5','1',5348.43,5348.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','38',228,'6','1',5712.31,5712.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','39',229,'1','1',6085.67,6232.45,0.00,0.00,146.78,110085.00,0.00,0.00,0.00),('1','285','1','39',230,'2','1',16650.09,17106.02,0.00,0.00,455.93,307752.75,0.00,0.00,0.00),('1','285','1','39',231,'3','1',18966.22,19482.02,0.00,0.00,515.80,348165.00,0.00,0.00,0.00),('1','285','1','39',232,'4','1',7917.82,8105.47,0.00,0.00,187.65,126663.75,0.00,0.00,0.00),('1','285','1','39',233,'5','1',5348.43,5513.07,0.00,0.00,164.64,111132.00,0.00,0.00,0.00),('1','285','1','39',234,'6','1',5712.31,5712.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','40',235,'1','1',6232.45,6400.65,0.00,0.00,168.20,126150.00,0.00,0.00,0.00),('1','285','1','40',236,'2','1',17106.02,17519.80,0.00,0.00,413.78,279301.50,0.00,0.00,0.00),('1','285','1','40',237,'3','1',19482.02,19956.28,0.00,0.00,474.26,320125.50,0.00,0.00,0.00),('1','285','1','40',238,'4','1',8105.47,8105.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','40',239,'5','1',5513.07,5595.57,0.00,0.00,82.50,55687.50,0.00,0.00,0.00),('1','285','1','40',240,'6','1',5712.31,5712.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','41',241,'1','1',6400.65,6592.20,0.00,0.00,191.55,143662.50,0.00,0.00,0.00),('1','285','1','41',242,'2','1',17519.80,17905.24,0.00,0.00,385.44,260172.00,0.00,0.00,0.00),('1','285','1','41',243,'3','1',19956.28,20176.19,0.00,0.00,219.91,148439.25,0.00,0.00,0.00),('1','285','1','41',244,'4','1',8105.47,8165.47,0.00,0.00,60.00,40500.00,0.00,0.00,0.00),('1','285','1','41',245,'5','1',5595.57,5595.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','41',246,'6','1',5712.31,5712.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','42',247,'1','1',6592.20,6753.57,0.00,0.00,161.37,121027.50,0.00,0.00,0.00),('1','285','1','42',248,'2','1',17905.24,18185.19,0.00,0.00,279.95,188966.25,0.00,0.00,0.00),('1','285','1','42',249,'3','1',20176.19,20498.45,0.00,0.00,322.26,217525.50,0.00,0.00,0.00),('1','285','1','42',250,'4','1',8165.47,8222.16,0.00,0.00,56.69,38265.75,0.00,0.00,0.00),('1','285','1','42',251,'5','1',5595.57,5595.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','42',252,'6','1',5712.31,5833.75,0.00,0.00,121.44,81972.00,0.00,0.00,0.00),('1','285','1','43',253,'1','1',6753.57,6919.11,0.00,0.00,165.54,124155.00,0.00,0.00,0.00),('1','285','1','43',254,'2','1',18185.19,18368.16,0.00,0.00,182.97,123504.75,0.00,0.00,0.00),('1','285','1','43',255,'3','1',20498.45,20786.22,0.00,0.00,287.77,194244.75,0.00,0.00,0.00),('1','285','1','43',256,'4','1',8222.16,8357.64,0.00,0.00,135.48,91449.00,0.00,0.00,0.00),('1','285','1','43',257,'5','1',5595.57,5595.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','43',258,'6','1',5833.75,5833.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','44',259,'1','1',6919.11,7081.51,0.00,0.00,162.40,121800.00,0.00,0.00,0.00),('1','285','1','44',260,'2','1',18368.16,18541.39,0.00,0.00,173.23,116930.25,0.00,0.00,0.00),('1','285','1','44',261,'3','1',20786.22,21250.43,0.00,0.00,464.21,313341.75,0.00,0.00,0.00),('1','285','1','44',262,'4','1',8357.64,8523.49,0.00,0.00,165.85,111948.75,0.00,0.00,0.00),('1','285','1','44',263,'5','1',5595.57,5851.92,0.00,0.00,256.35,173036.25,0.00,0.00,0.00),('1','285','1','44',264,'6','1',5833.75,5833.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','45',265,'1','1',7081.51,7313.60,0.00,0.00,232.09,174067.50,0.00,0.00,0.00),('1','285','1','45',266,'2','1',18541.39,19010.07,0.00,0.00,468.68,316359.00,0.00,0.00,0.00),('1','285','1','45',267,'3','1',21250.43,21647.36,0.00,0.00,396.93,267927.75,0.00,0.00,0.00),('1','285','1','45',268,'4','1',8523.49,8668.71,0.00,0.00,145.22,98023.50,0.00,0.00,0.00),('1','285','1','45',269,'5','1',5851.92,6174.70,0.00,0.00,322.78,217876.50,0.00,0.00,0.00),('1','285','1','45',270,'6','1',5833.75,6006.03,0.00,0.00,172.28,116289.00,0.00,0.00,0.00),('1','285','1','46',271,'1','1',7313.60,7456.34,0.00,0.00,142.74,107055.00,0.00,0.00,0.00),('1','285','1','46',272,'2','1',19010.07,19261.85,0.00,0.00,251.78,169951.50,0.00,0.00,0.00),('1','285','1','46',273,'3','1',21647.36,22323.67,0.00,0.00,676.31,456509.25,0.00,0.00,0.00),('1','285','1','46',274,'4','1',8668.71,8734.71,0.00,0.00,66.00,44625.00,0.00,0.00,0.00),('1','285','1','46',275,'5','1',6174.70,6174.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','46',276,'6','1',6006.03,6030.37,0.00,0.00,24.34,16429.50,0.00,0.00,0.00),('1','285','1','47',277,'1','1',7456.34,7658.12,0.00,0.00,201.78,151335.00,0.00,0.00,0.00),('1','285','1','47',278,'2','1',19261.85,19527.02,0.00,0.00,265.17,177663.90,0.00,0.00,0.00),('1','285','1','47',279,'3','1',22323.67,22689.87,0.00,0.00,366.20,245354.00,0.00,0.00,0.00),('1','285','1','47',280,'4','1',8734.71,8907.21,0.00,0.00,172.50,115575.00,0.00,0.00,0.00),('1','285','1','47',281,'5','1',6174.70,6238.13,0.00,0.00,63.43,42498.10,0.00,0.00,0.00),('1','285','1','47',282,'6','1',6030.37,6030.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','48',283,'1','1',7658.12,7856.39,0.00,0.00,198.27,148702.50,0.00,0.00,0.00),('1','285','1','48',284,'2','1',19527.02,19876.20,0.00,0.00,349.18,233950.60,0.00,0.00,0.00),('1','285','1','48',285,'3','1',22689.87,23273.56,0.00,0.00,583.69,391072.30,0.00,0.00,0.00),('1','285','1','48',286,'4','1',8907.21,9102.26,0.00,0.00,195.05,130763.50,0.00,0.00,0.00),('1','285','1','48',287,'5','1',6238.13,6360.15,0.00,0.00,122.02,81753.40,0.00,0.00,0.00),('1','285','1','48',288,'6','1',6030.37,6030.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','49',289,'1','1',7856.39,8047.22,0.00,0.00,190.83,143122.50,0.00,0.00,0.00),('1','285','1','49',290,'2','1',19876.20,20069.89,0.00,0.00,193.69,129772.30,0.00,0.00,0.00),('1','285','1','49',291,'3','1',23273.56,24186.71,0.00,0.00,913.15,611810.50,0.00,0.00,0.00),('1','285','1','49',292,'4','1',9102.26,9443.37,0.00,0.00,341.11,228543.70,0.00,0.00,0.00),('1','285','1','49',293,'5','1',6360.15,6532.09,0.00,0.00,171.94,115199.80,0.00,0.00,0.00),('1','285','1','49',294,'6','1',6030.37,6350.93,0.00,0.00,320.56,214775.20,0.00,0.00,0.00),('1','285','1','50',295,'1','1',8047.22,8047.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','50',296,'2','1',20069.89,20069.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','50',297,'3','1',24186.71,24186.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','50',298,'4','1',9443.37,9443.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','50',299,'5','1',6532.09,6532.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','50',300,'6','1',6350.93,6350.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','51',301,'1','1',8047.22,8227.80,0.00,0.00,180.58,135435.00,0.00,0.00,0.00),('1','285','1','51',302,'2','1',20069.89,20163.31,0.00,0.00,93.42,62591.40,0.00,0.00,0.00),('1','285','1','51',303,'3','1',24186.71,24916.38,0.00,0.00,729.67,489678.90,0.00,0.00,0.00),('1','285','1','51',304,'4','1',9443.37,9519.25,0.00,0.00,75.88,50839.60,0.00,0.00,0.00),('1','285','1','51',305,'5','1',6532.09,6532.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','51',306,'6','1',6350.93,6350.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','52',307,'1','1',8227.80,8513.78,0.00,0.00,285.98,214485.00,0.00,0.00,0.00),('1','285','1','52',308,'2','1',20163.31,20672.15,0.00,0.00,508.84,340922.80,0.00,0.00,0.00),('1','285','1','52',309,'3','1',24916.38,25252.63,0.00,0.00,336.25,225287.50,0.00,0.00,0.00),('1','285','1','52',310,'4','1',9519.25,9808.76,0.00,0.00,289.51,193971.70,0.00,0.00,0.00),('1','285','1','52',311,'5','1',6532.09,6532.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','52',312,'6','1',6350.93,6865.77,0.00,0.00,514.84,344942.80,0.00,0.00,0.00),('1','285','1','53',313,'1','1',8513.78,8669.18,0.00,0.00,155.40,116550.00,0.00,0.00,0.00),('1','285','1','53',314,'2','1',20672.15,21151.39,0.00,0.00,479.24,321090.80,0.00,0.00,0.00),('1','285','1','53',315,'3','1',25252.63,26438.34,0.00,0.00,1185.71,794425.70,0.00,0.00,0.00),('1','285','1','53',316,'4','1',9808.76,9951.76,0.00,0.00,143.00,95810.00,0.00,0.00,0.00),('1','285','1','53',317,'5','1',6532.09,6532.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','53',318,'6','1',6865.77,7602.76,0.00,0.00,736.99,493783.30,0.00,0.00,0.00),('1','285','1','54',319,'1','1',8669.18,8848.64,0.00,0.00,179.46,134595.00,0.00,0.00,0.00),('1','285','1','54',320,'2','1',21151.39,21624.15,0.00,0.00,472.76,316749.20,0.00,0.00,0.00),('1','285','1','54',321,'3','1',26438.34,26833.83,0.00,0.00,395.49,264978.30,0.00,0.00,0.00),('1','285','1','54',322,'4','1',9951.76,10393.39,0.00,0.00,441.63,295892.10,0.00,0.00,0.00),('1','285','1','54',323,'5','1',6532.09,6532.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','54',324,'6','1',7602.76,8230.36,0.00,0.00,627.60,420492.00,0.00,0.00,0.00),('1','285','1','55',325,'1','1',8848.64,9015.25,0.00,0.00,166.61,124957.50,0.00,0.00,0.00),('1','285','1','55',326,'2','1',21624.15,21872.57,0.00,0.00,248.42,166441.40,0.00,0.00,0.00),('1','285','1','55',327,'3','1',26833.83,27184.49,0.00,0.00,350.66,234942.20,0.00,0.00,0.00),('1','285','1','55',328,'4','1',10393.39,10455.05,0.00,0.00,61.66,41312.20,0.00,0.00,0.00),('1','285','1','55',329,'5','1',6532.09,7517.86,0.00,0.00,985.77,656497.05,0.00,0.00,0.00),('1','285','1','55',330,'6','1',8230.36,8530.36,0.00,0.00,300.00,201000.00,0.00,0.00,0.00),('1','285','1','56',331,'1','1',9015.25,9204.29,0.00,0.00,189.04,141780.00,0.00,0.00,0.00),('1','285','1','56',332,'2','1',21872.57,22187.61,0.00,0.00,315.04,211076.80,0.00,0.00,0.00),('1','285','1','56',333,'3','1',27184.49,27736.56,0.00,0.00,552.07,369314.65,0.00,0.00,0.00),('1','285','1','56',334,'4','1',10455.05,10691.14,0.00,0.00,236.09,158180.30,0.00,0.00,0.00),('1','285','1','56',335,'5','1',7517.86,7517.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','56',336,'6','1',8530.36,8630.36,0.00,0.00,100.00,67000.00,0.00,0.00,0.00),('1','285','1','57',337,'1','1',9204.29,9486.15,0.00,0.00,281.86,211395.00,0.00,0.00,0.00),('1','285','1','57',338,'2','1',22187.61,22426.39,0.00,0.00,238.78,159982.60,0.00,0.00,0.00),('1','285','1','57',339,'3','1',27736.56,28301.28,0.00,0.00,564.72,378362.40,0.00,0.00,0.00),('1','285','1','57',340,'4','1',10691.14,10891.75,0.00,0.00,200.61,134408.70,0.00,0.00,0.00),('1','285','1','57',341,'5','1',7517.86,7517.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','57',342,'6','1',8630.36,8630.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','58',343,'1','1',9486.15,9626.68,0.00,0.00,140.53,105397.50,0.00,0.00,0.00),('1','285','1','58',344,'2','1',22426.39,22471.04,0.00,0.00,44.65,29915.50,0.00,0.00,0.00),('1','285','1','58',345,'3','1',28301.28,28639.65,0.00,0.00,338.37,226707.90,0.00,0.00,0.00),('1','285','1','58',346,'4','1',10891.75,11161.41,0.00,0.00,269.66,180672.20,0.00,0.00,0.00),('1','285','1','58',347,'5','1',7517.86,7517.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','58',348,'6','1',8630.36,8630.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','59',349,'1','1',9626.68,9905.01,0.00,0.00,278.33,208747.50,0.00,0.00,0.00),('1','285','1','59',350,'2','1',22471.04,22747.89,0.00,0.00,276.85,185489.50,0.00,0.00,0.00),('1','285','1','59',351,'3','1',28639.65,29742.87,0.00,0.00,1103.22,739157.40,0.00,0.00,0.00),('1','285','1','59',352,'4','1',11161.41,11266.41,0.00,0.00,105.00,70350.00,0.00,0.00,0.00),('1','285','1','59',353,'5','1',7517.86,7652.86,0.00,0.00,135.00,90450.00,0.00,0.00,0.00),('1','285','1','59',354,'6','1',8630.36,9121.09,0.00,0.00,490.73,328789.10,0.00,0.00,0.00),('1','285','1','60',355,'1','1',9905.01,10089.20,0.00,0.00,184.19,138142.50,0.00,0.00,0.00),('1','285','1','60',356,'2','1',22747.89,23215.44,0.00,0.00,467.55,313258.50,0.00,0.00,0.00),('1','285','1','60',357,'3','1',29742.87,30804.22,0.00,0.00,1061.35,711104.50,0.00,0.00,0.00),('1','285','1','60',358,'4','1',11266.41,11357.03,0.00,0.00,90.62,60715.40,0.00,0.00,0.00),('1','285','1','60',359,'5','1',7652.86,7724.02,0.00,0.00,71.16,47677.20,0.00,0.00,0.00),('1','285','1','60',360,'6','1',9121.09,9271.38,0.00,0.00,150.29,100694.30,0.00,0.00,0.00),('1','285','1','61',361,'1','1',10089.20,10216.25,0.00,0.00,127.05,95287.50,0.00,0.00,0.00),('1','285','1','61',362,'2','1',23215.44,23570.68,0.00,0.00,355.24,238010.80,0.00,0.00,0.00),('1','285','1','61',363,'3','1',30804.22,31351.99,0.00,0.00,547.77,367005.90,0.00,0.00,0.00),('1','285','1','61',364,'4','1',11357.03,11357.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','61',365,'5','1',7724.02,7724.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','61',366,'6','1',9271.38,9689.71,0.00,0.00,418.33,280281.10,0.00,0.00,0.00),('1','285','1','62',367,'1','1',10216.25,10216.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','62',368,'2','1',23570.68,23570.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','62',369,'3','1',31351.99,31351.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','62',370,'4','1',11357.03,11357.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','62',371,'5','1',7724.02,7724.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','62',372,'6','1',9689.71,9689.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','63',373,'1','1',10216.25,10297.71,0.00,0.00,81.46,61095.00,0.00,0.00,0.00),('1','285','1','63',374,'2','1',23570.68,23787.78,0.00,0.00,217.10,145457.00,0.00,0.00,0.00),('1','285','1','63',375,'3','1',31351.99,31607.97,0.00,0.00,255.98,171506.60,0.00,0.00,0.00),('1','285','1','63',376,'4','1',11357.03,11417.03,0.00,0.00,60.00,40200.00,0.00,0.00,0.00),('1','285','1','63',377,'5','1',7724.02,7741.45,0.00,0.00,17.43,11678.10,0.00,0.00,0.00),('1','285','1','63',378,'6','1',9689.71,9689.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','64',379,'1','1',10297.71,10458.00,0.00,0.00,160.29,120217.50,0.00,0.00,0.00),('1','285','1','64',380,'2','1',23787.78,24100.56,0.00,0.00,312.78,209562.60,0.00,0.00,0.00),('1','285','1','64',381,'3','1',31607.97,32074.40,0.00,0.00,466.43,312508.10,0.00,0.00,0.00),('1','285','1','64',382,'4','1',11417.03,11417.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','64',383,'5','1',7741.45,7943.52,0.00,0.00,202.07,135386.90,0.00,0.00,0.00),('1','285','1','64',384,'6','1',9689.71,9689.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','65',385,'1','1',10458.00,10685.55,0.00,0.00,227.55,170662.50,0.00,0.00,0.00),('1','285','1','65',386,'2','1',24100.56,24385.62,0.00,0.00,285.06,190990.20,0.00,0.00,0.00),('1','285','1','65',387,'3','1',32074.40,32557.51,0.00,0.00,483.11,323683.70,0.00,0.00,0.00),('1','285','1','65',388,'4','1',11417.03,11434.03,0.00,0.00,17.00,11390.00,0.00,0.00,0.00),('1','285','1','65',389,'5','1',7943.52,7943.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','65',390,'6','1',9689.71,10476.98,0.00,0.00,787.27,523809.55,0.00,0.00,0.00),('1','285','1','66',391,'1','1',10685.55,11003.63,0.00,0.00,318.08,238560.00,0.00,0.00,0.00),('1','285','1','66',392,'2','1',24385.62,24552.26,0.00,0.00,166.64,111888.80,0.00,0.00,0.00),('1','285','1','66',393,'3','1',32557.51,33370.74,0.00,0.00,813.23,544864.10,0.00,0.00,0.00),('1','285','1','66',394,'4','1',11434.03,11584.30,0.00,0.00,150.27,100680.90,0.00,0.00,0.00),('1','285','1','66',395,'5','1',7943.52,7943.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','66',396,'6','1',10476.98,10476.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','67',397,'1','1',11003.63,11152.54,0.00,0.00,148.91,111682.50,0.00,0.00,0.00),('1','285','1','67',398,'2','1',24552.26,24721.75,0.00,0.00,169.49,113558.30,0.00,0.00,0.00),('1','285','1','67',399,'3','1',33370.74,33912.15,0.00,0.00,541.41,362744.70,0.00,0.00,0.00),('1','285','1','67',400,'4','1',11584.30,11694.77,0.00,0.00,110.47,74014.90,0.00,0.00,0.00),('1','285','1','67',401,'5','1',7943.52,7943.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','67',402,'6','1',10476.98,10514.38,0.00,0.00,37.40,25058.00,0.00,0.00,0.00),('1','285','1','68',403,'1','1',11152.54,11380.22,0.00,0.00,227.68,170760.00,0.00,0.00,0.00),('1','285','1','68',404,'2','1',24721.75,25325.71,0.00,0.00,603.96,403211.50,0.00,0.00,0.00),('1','285','1','68',405,'3','1',33912.15,34407.48,0.00,0.00,495.33,331871.10,0.00,0.00,0.00),('1','285','1','68',406,'4','1',11694.77,12313.75,0.00,0.00,618.98,414716.60,0.00,0.00,0.00),('1','285','1','68',407,'5','1',7943.52,8390.96,0.00,0.00,447.44,299784.80,0.00,0.00,0.00),('1','285','1','68',408,'6','1',10514.38,11361.43,0.00,0.00,847.05,565323.50,0.00,0.00,0.00),('1','285','1','69',409,'1','1',11380.22,11627.77,0.00,0.00,247.55,185662.50,0.00,0.00,0.00),('1','285','1','69',410,'2','1',25325.71,25781.18,0.00,0.00,455.47,305164.90,0.00,0.00,0.00),('1','285','1','69',411,'3','1',34407.48,35022.11,0.00,0.00,614.63,411802.10,0.00,0.00,0.00),('1','285','1','69',412,'4','1',12313.75,12613.53,0.00,0.00,299.78,200852.60,0.00,0.00,0.00),('1','285','1','69',413,'5','1',8390.96,8543.54,0.00,0.00,152.58,102228.60,0.00,0.00,0.00),('1','285','1','69',414,'6','1',11361.43,11361.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','70',415,'1','1',11627.77,11958.49,0.00,0.00,330.72,248040.00,0.00,0.00,0.00),('1','285','1','70',416,'2','1',25781.18,25921.60,0.00,0.00,140.42,94081.40,0.00,0.00,0.00),('1','285','1','70',417,'3','1',35022.11,35303.71,0.00,0.00,281.60,188672.00,0.00,0.00,0.00),('1','285','1','70',418,'4','1',12613.53,12777.91,0.00,0.00,164.38,110134.60,0.00,0.00,0.00),('1','285','1','70',419,'5','1',8543.54,8812.22,0.00,0.00,268.68,180015.60,0.00,0.00,0.00),('1','285','1','70',420,'6','1',11361.43,11492.93,0.00,0.00,131.50,88105.00,0.00,0.00,0.00),('1','285','1','71',421,'1','1',11958.49,12127.74,0.00,0.00,169.25,126937.50,0.00,0.00,0.00),('1','285','1','71',422,'2','1',25921.60,26174.12,0.00,0.00,252.52,169188.40,0.00,0.00,0.00),('1','285','1','71',423,'3','1',35303.71,35773.04,0.00,0.00,469.33,314451.10,0.00,0.00,0.00),('1','285','1','71',424,'4','1',12777.91,12911.77,0.00,0.00,133.86,89686.20,0.00,0.00,0.00),('1','285','1','71',425,'5','1',8812.22,8915.89,0.00,0.00,103.67,69458.90,0.00,0.00,0.00),('1','285','1','71',426,'6','1',11492.93,11779.86,0.00,0.00,286.93,192243.10,0.00,0.00,0.00),('1','285','1','72',427,'1','1',12127.74,12521.81,0.00,0.00,394.07,295552.50,0.00,0.00,0.00),('1','285','1','72',428,'2','1',26174.12,26782.24,0.00,0.00,608.12,407440.40,0.00,0.00,0.00),('1','285','1','72',429,'3','1',35773.04,36250.45,0.00,0.00,477.41,319864.70,0.00,0.00,0.00),('1','285','1','72',430,'4','1',12911.77,13113.20,0.00,0.00,201.43,134958.10,0.00,0.00,0.00),('1','285','1','72',431,'5','1',8915.89,9111.89,0.00,0.00,196.00,131320.00,0.00,0.00,0.00),('1','285','1','72',432,'6','1',11779.86,13292.62,0.00,0.00,1512.76,1007535.40,0.00,0.00,0.00),('1','285','1','73',433,'1','1',12521.81,12583.17,0.00,0.00,61.36,46020.00,0.00,0.00,0.00),('1','285','1','73',434,'2','1',26782.24,26802.24,0.00,0.00,20.00,13400.00,0.00,0.00,0.00),('1','285','1','73',435,'3','1',36250.45,36670.45,0.00,0.00,420.00,281400.00,0.00,0.00,0.00),('1','285','1','73',436,'4','1',13113.20,13174.20,0.00,0.00,61.00,40870.00,0.00,0.00,0.00),('1','285','1','73',437,'5','1',9111.89,9111.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','73',438,'6','1',13292.62,13292.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','74',439,'1','1',12583.17,12583.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','74',440,'2','1',26802.24,26802.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','74',441,'3','1',36670.45,36670.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','74',442,'4','1',13174.20,13174.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','74',443,'5','1',9111.89,9111.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','74',444,'6','1',13292.62,13292.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','75',445,'1','1',12583.17,13050.57,0.00,0.00,467.40,350550.00,0.00,0.00,0.00),('1','285','1','75',446,'2','1',26802.24,28569.59,0.00,0.00,1767.35,1184124.50,0.00,0.00,0.00),('1','285','1','75',447,'3','1',36670.45,37560.07,0.00,0.00,889.62,596045.40,0.00,0.00,0.00),('1','285','1','75',448,'4','1',13174.20,14317.31,0.00,0.00,1143.11,765883.70,0.00,0.00,0.00),('1','285','1','75',449,'5','1',9111.89,11330.67,0.00,0.00,2218.78,1479958.75,0.00,0.00,0.00),('1','285','1','75',450,'6','1',13292.62,15902.23,0.00,0.00,2609.61,1736343.10,0.00,0.00,0.00),('1','285','1','76',451,'1','1',13050.57,13442.81,0.00,0.00,392.24,294180.00,0.00,0.00,0.00),('1','285','1','76',452,'2','1',28569.59,29836.34,0.00,0.00,1266.75,846401.85,0.00,0.00,0.00),('1','285','1','76',453,'3','1',37560.07,38162.48,0.00,0.00,602.41,403614.70,0.00,0.00,0.00),('1','285','1','76',454,'4','1',14317.31,14869.93,0.00,0.00,552.62,370255.40,0.00,0.00,0.00),('1','285','1','76',455,'5','1',11330.67,12643.50,0.00,0.00,1312.83,877596.10,0.00,0.00,0.00),('1','285','1','76',456,'6','1',15902.23,16559.14,0.00,0.00,656.91,440129.70,0.00,0.00,0.00),('1','285','1','77',457,'1','1',13442.81,13623.54,0.00,0.00,180.73,135547.50,0.00,0.00,0.00),('1','285','1','77',458,'2','1',29836.34,30047.00,0.00,0.00,210.66,141142.20,0.00,0.00,0.00),('1','285','1','77',459,'3','1',38162.48,39140.09,0.00,0.00,977.61,654998.70,0.00,0.00,0.00),('1','285','1','77',460,'4','1',14869.93,15658.94,0.00,0.00,789.01,528636.70,0.00,0.00,0.00),('1','285','1','77',461,'5','1',12643.50,13662.37,0.00,0.00,1018.87,680217.90,0.00,0.00,0.00),('1','285','1','77',462,'6','1',16559.14,16755.79,0.00,0.00,196.65,131755.50,0.00,0.00,0.00),('1','285','1','78',463,'1','1',13623.54,13623.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','78',464,'2','1',30047.00,30047.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','78',465,'3','1',39140.09,39140.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','78',466,'4','1',15658.94,15658.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','78',467,'5','1',13662.37,13662.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','78',468,'6','1',16755.79,16755.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','79',469,'1','1',13623.54,13910.56,0.00,0.00,287.02,215265.00,0.00,0.00,0.00),('1','285','1','79',470,'2','1',30047.00,30790.70,0.00,0.00,743.70,498279.00,0.00,0.00,0.00),('1','285','1','79',471,'3','1',39140.09,40108.22,0.00,0.00,968.13,648647.10,0.00,0.00,0.00),('1','285','1','79',472,'4','1',15658.94,15834.91,0.00,0.00,175.97,117899.90,0.00,0.00,0.00),('1','285','1','79',473,'5','1',13662.37,14192.19,0.00,0.00,529.82,354364.40,0.00,0.00,0.00),('1','285','1','79',474,'6','1',16755.79,16816.41,0.00,0.00,60.62,40615.40,0.00,0.00,0.00),('1','285','1','80',475,'1','1',13910.56,14164.56,0.00,0.00,254.00,190500.00,0.00,0.00,0.00),('1','285','1','80',476,'2','1',30790.70,31505.17,0.00,0.00,714.47,478934.90,0.00,0.00,0.00),('1','285','1','80',477,'3','1',40108.22,40562.59,0.00,0.00,454.37,304427.90,0.00,0.00,0.00),('1','285','1','80',478,'4','1',15834.91,16134.58,0.00,0.00,299.67,200778.90,0.00,0.00,0.00),('1','285','1','80',479,'5','1',14192.19,14328.32,0.00,0.00,136.13,91207.10,0.00,0.00,0.00),('1','285','1','80',480,'6','1',16816.41,17841.73,0.00,0.00,1025.32,682955.75,0.00,0.00,0.00),('1','285','1','81',481,'1','1',14164.56,14389.59,0.00,0.00,225.03,168772.50,0.00,0.00,0.00),('1','285','1','81',482,'2','1',31505.17,32146.55,0.00,0.00,641.38,429484.60,0.00,0.00,0.00),('1','285','1','81',483,'3','1',40562.59,41159.06,0.00,0.00,596.47,399634.90,0.00,0.00,0.00),('1','285','1','81',484,'4','1',16134.58,16830.91,0.00,0.00,696.33,466541.10,0.00,0.00,0.00),('1','285','1','81',485,'5','1',14328.32,16418.60,0.00,0.00,2090.28,1390036.20,0.00,0.00,0.00),('1','285','1','81',486,'6','1',17841.73,19254.18,0.00,0.00,1412.45,940263.60,0.00,0.00,0.00),('1','285','1','82',487,'1','1',14389.59,14664.98,0.00,0.00,275.39,206542.50,0.00,0.00,0.00),('1','285','1','82',488,'2','1',32146.55,33159.23,0.00,0.00,1012.68,676283.70,0.00,0.00,0.00),('1','285','1','82',489,'3','1',41159.06,42463.48,0.00,0.00,1304.42,873661.40,0.00,0.00,0.00),('1','285','1','82',490,'4','1',16830.91,18196.84,0.00,0.00,1365.93,911507.40,0.00,0.00,0.00),('1','285','1','82',491,'5','1',16418.60,18220.24,0.00,0.00,1801.64,1199175.45,0.00,0.00,0.00),('1','285','1','82',492,'6','1',19254.18,19291.81,0.00,0.00,37.63,25212.10,0.00,0.00,0.00),('1','285','1','83',493,'1','1',14664.98,14840.17,0.00,0.00,175.19,131392.50,0.00,0.00,0.00),('1','285','1','83',494,'2','1',33159.23,34171.16,0.00,0.00,1011.93,676742.50,0.00,0.00,0.00),('1','285','1','83',495,'3','1',42463.48,42606.49,0.00,0.00,143.01,95816.70,0.00,0.00,0.00),('1','285','1','83',496,'4','1',18196.84,18498.38,0.00,0.00,301.54,201786.30,0.00,0.00,0.00),('1','285','1','83',497,'5','1',18220.24,18637.98,0.00,0.00,417.74,277797.10,0.00,0.00,0.00),('1','285','1','83',498,'6','1',19291.81,20341.76,0.00,0.00,1049.95,698216.75,0.00,0.00,0.00),('1','285','1','84',499,'1','1',14840.17,14840.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','84',500,'2','1',34171.16,34171.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','84',501,'3','1',42606.49,42606.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','84',502,'4','1',18498.38,18498.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','84',503,'5','1',18637.98,18637.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','84',504,'6','1',20341.76,20341.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','85',505,'1','1',14840.17,15083.56,0.00,0.00,243.39,182542.50,0.00,0.00,0.00),('1','285','1','85',506,'2','1',34171.16,34705.85,0.00,0.00,534.69,357906.95,0.00,0.00,0.00),('1','285','1','85',507,'3','1',42606.49,43212.09,0.00,0.00,605.60,404232.75,0.00,0.00,0.00),('1','285','1','85',508,'4','1',18498.38,18620.96,0.00,0.00,122.58,82128.60,0.00,0.00,0.00),('1','285','1','85',509,'5','1',18637.98,20185.98,0.00,0.00,1548.00,1030186.10,0.00,0.00,0.00),('1','285','1','85',510,'6','1',20341.76,20907.00,0.00,0.00,565.24,375884.60,0.00,0.00,0.00),('1','285','1','86',511,'1','1',15083.56,15382.38,0.00,0.00,298.82,224115.00,0.00,0.00,0.00),('1','285','1','86',512,'2','1',34705.85,35093.02,0.00,0.00,387.17,259403.90,0.00,0.00,0.00),('1','285','1','86',513,'3','1',43212.09,43719.49,0.00,0.00,507.40,339958.00,0.00,0.00,0.00),('1','285','1','86',514,'4','1',18620.96,18746.78,0.00,0.00,125.82,84299.40,0.00,0.00,0.00),('1','285','1','86',515,'5','1',20185.98,20444.80,0.00,0.00,258.82,173409.40,0.00,0.00,0.00),('1','285','1','86',516,'6','1',20907.00,21015.57,0.00,0.00,108.57,72741.90,0.00,0.00,0.00),('1','285','1','87',517,'1','1',15382.38,15742.71,0.00,0.00,360.33,270247.50,0.00,0.00,0.00),('1','285','1','87',518,'2','1',35093.02,35882.71,0.00,0.00,789.69,529077.50,0.00,0.00,0.00),('1','285','1','87',519,'3','1',43719.49,44241.78,0.00,0.00,522.29,349767.80,0.00,0.00,0.00),('1','285','1','87',520,'4','1',18746.78,19199.24,0.00,0.00,452.46,303148.20,0.00,0.00,0.00),('1','285','1','87',521,'5','1',20444.80,22959.08,0.00,0.00,2514.28,1674520.90,0.00,0.00,0.00),('1','285','1','87',522,'6','1',21015.57,21647.47,0.00,0.00,631.90,421253.50,0.00,0.00,0.00),('1','285','1','88',523,'1','1',15742.71,15961.38,0.00,0.00,218.67,164002.50,0.00,0.00,0.00),('1','285','1','88',524,'2','1',35882.71,36665.07,0.00,0.00,782.36,523841.20,0.00,0.00,0.00),('1','285','1','88',525,'3','1',44241.78,44849.17,0.00,0.00,607.39,406951.30,0.00,0.00,0.00),('1','285','1','88',526,'4','1',19199.24,20020.47,0.00,0.00,821.23,547324.10,0.00,0.00,0.00),('1','285','1','88',527,'5','1',22959.08,24455.27,0.00,0.00,1496.19,995874.40,0.00,0.00,0.00),('1','285','1','88',528,'6','1',21647.47,22683.39,0.00,0.00,1035.92,688886.80,0.00,0.00,0.00),('1','285','1','89',529,'1','1',15961.38,16272.83,0.00,0.00,311.45,233587.50,0.00,0.00,0.00),('1','285','1','89',530,'2','1',36665.07,37010.64,0.00,0.00,345.57,231531.90,0.00,0.00,0.00),('1','285','1','89',531,'3','1',44849.17,45689.99,0.00,0.00,840.82,562149.40,0.00,0.00,0.00),('1','285','1','89',532,'4','1',20020.47,20685.23,0.00,0.00,664.76,444789.20,0.00,0.00,0.00),('1','285','1','89',533,'5','1',24455.27,25140.35,0.00,0.00,685.08,458413.20,0.00,0.00,0.00),('1','285','1','89',534,'6','1',22683.39,23819.75,0.00,0.00,1136.36,755679.40,0.00,0.00,0.00),('1','285','1','90',535,'1','1',16272.83,16272.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','90',536,'2','1',37010.64,37010.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','90',537,'3','1',45689.99,45689.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','90',538,'4','1',20685.23,20685.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','90',539,'5','1',25140.35,25140.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','90',540,'6','1',23819.75,23819.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','91',541,'1','1',16272.83,16504.21,0.00,0.00,231.38,173535.00,0.00,0.00,0.00),('1','285','1','91',542,'2','1',37010.64,37563.54,0.00,0.00,552.90,370139.05,0.00,0.00,0.00),('1','285','1','91',543,'3','1',45689.99,46896.07,0.00,0.00,1206.08,806060.10,0.00,0.00,0.00),('1','285','1','91',544,'4','1',20685.23,21119.58,0.00,0.00,434.35,291014.50,0.00,0.00,0.00),('1','285','1','91',545,'5','1',25140.35,26811.01,0.00,0.00,1670.66,1113265.50,0.00,0.00,0.00),('1','285','1','91',546,'6','1',23819.75,24979.03,0.00,0.00,1159.28,770921.20,0.00,0.00,0.00),('1','285','1','92',547,'1','1',16504.21,16706.05,0.00,0.00,201.84,151380.00,0.00,0.00,0.00),('1','285','1','92',548,'2','1',37563.54,38140.48,0.00,0.00,576.94,386212.00,0.00,0.00,0.00),('1','285','1','92',549,'3','1',46896.07,47726.18,0.00,0.00,830.11,555083.70,0.00,0.00,0.00),('1','285','1','92',550,'4','1',21119.58,21444.32,0.00,0.00,324.74,217575.80,0.00,0.00,0.00),('1','285','1','92',551,'5','1',26811.01,27964.83,0.00,0.00,1153.82,769602.95,0.00,0.00,0.00),('1','285','1','92',552,'6','1',24979.03,24979.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','93',553,'1','1',16706.05,17028.57,0.00,0.00,322.52,241890.00,0.00,0.00,0.00),('1','285','1','93',554,'2','1',38140.48,39132.60,0.00,0.00,992.12,664720.40,0.00,0.00,0.00),('1','285','1','93',555,'3','1',47726.18,48816.24,0.00,0.00,1090.06,730040.65,0.00,0.00,0.00),('1','285','1','93',556,'4','1',21444.32,21837.69,0.00,0.00,393.37,263557.90,0.00,0.00,0.00),('1','285','1','93',557,'5','1',27964.83,28575.36,0.00,0.00,610.53,408055.10,0.00,0.00,0.00),('1','285','1','93',558,'6','1',24979.03,26660.50,0.00,0.00,1681.47,1118512.55,0.00,0.00,0.00),('1','285','1','94',559,'1','1',17028.57,17315.45,0.00,0.00,286.88,215160.00,0.00,0.00,0.00),('1','285','1','94',560,'2','1',39132.60,39772.70,0.00,0.00,640.10,428450.90,0.00,0.00,0.00),('1','285','1','94',561,'3','1',48816.24,50123.16,0.00,0.00,1306.92,872936.40,0.00,0.00,0.00),('1','285','1','94',562,'4','1',21837.69,21970.48,0.00,0.00,132.79,88666.15,0.00,0.00,0.00),('1','285','1','94',563,'5','1',28575.36,28881.64,0.00,0.00,306.28,203676.20,0.00,0.00,0.00),('1','285','1','94',564,'6','1',26660.50,26721.78,0.00,0.00,61.28,41057.60,0.00,0.00,0.00),('1','285','1','95',565,'1','1',17315.45,17478.34,0.00,0.00,162.89,122167.50,0.00,0.00,0.00),('1','285','1','95',566,'2','1',39772.70,39940.01,0.00,0.00,167.31,112097.70,0.00,0.00,0.00),('1','285','1','95',567,'3','1',50123.16,52153.18,0.00,0.00,2030.02,1356417.45,0.00,0.00,0.00),('1','285','1','95',568,'4','1',21970.48,22489.48,0.00,0.00,519.00,347730.00,0.00,0.00,0.00),('1','285','1','95',569,'5','1',28881.64,28971.64,0.00,0.00,90.00,60300.00,0.00,0.00,0.00),('1','285','1','95',570,'6','1',26721.78,27281.91,0.00,0.00,560.13,372787.10,0.00,0.00,0.00),('1','285','1','96',571,'1','1',17478.34,17478.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','96',572,'2','1',39940.01,39940.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','96',573,'3','1',52153.18,52153.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','96',574,'4','1',22489.48,22489.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','96',575,'5','1',28971.64,28971.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','96',576,'6','1',27281.91,27281.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','97',577,'1','1',17478.34,17719.02,0.00,0.00,240.68,180510.00,0.00,0.00,0.00),('1','285','1','97',578,'2','1',39940.01,40590.88,0.00,0.00,650.87,436082.90,0.00,0.00,0.00),('1','285','1','97',579,'3','1',52153.18,54033.56,0.00,0.00,1880.38,1255802.10,0.00,0.00,0.00),('1','285','1','97',580,'4','1',22489.48,25115.60,0.00,0.00,2626.12,1754110.85,0.00,0.00,0.00),('1','285','1','97',581,'5','1',28971.64,30712.66,0.00,0.00,1741.02,1160173.95,0.00,0.00,0.00),('1','285','1','97',582,'6','1',27281.91,27466.44,0.00,0.00,184.53,123635.10,0.00,0.00,0.00),('1','285','1','98',583,'1','1',17719.02,17904.56,0.00,0.00,185.54,139155.00,0.00,0.00,0.00),('1','285','1','98',584,'2','1',40590.88,41170.81,0.00,0.00,579.93,388553.10,0.00,0.00,0.00),('1','285','1','98',585,'3','1',54033.56,55412.45,0.00,0.00,1378.89,921937.10,0.00,0.00,0.00),('1','285','1','98',586,'4','1',25115.60,25684.81,0.00,0.00,569.21,381370.70,0.00,0.00,0.00),('1','285','1','98',587,'5','1',30712.66,31716.85,0.00,0.00,1004.19,670307.30,0.00,0.00,0.00),('1','285','1','98',588,'6','1',27466.44,28673.83,0.00,0.00,1207.39,803515.15,0.00,0.00,0.00),('1','285','1','99',589,'1','1',17904.56,18137.88,0.00,0.00,233.32,174990.00,0.00,0.00,0.00),('1','285','1','99',590,'2','1',41170.81,41473.56,0.00,0.00,302.75,202842.50,0.00,0.00,0.00),('1','285','1','99',591,'3','1',55412.45,56130.52,0.00,0.00,718.07,481106.90,0.00,0.00,0.00),('1','285','1','99',592,'4','1',25684.81,26688.80,0.00,0.00,1003.99,672673.30,0.00,0.00,0.00),('1','285','1','99',593,'5','1',31716.85,32577.45,0.00,0.00,860.60,575679.05,0.00,0.00,0.00),('1','285','1','99',594,'6','1',28673.83,29036.83,0.00,0.00,363.00,241995.00,0.00,0.00,0.00),('1','285','1','100',595,'1','1',18137.88,18339.96,0.00,0.00,202.08,143476.80,0.00,0.00,0.00),('1','285','1','100',596,'2','1',41473.56,41868.91,0.00,0.00,395.35,264884.50,0.00,0.00,0.00),('1','285','1','100',597,'3','1',56130.52,57490.20,0.00,0.00,1359.68,910347.60,0.00,0.00,0.00),('1','285','1','100',598,'4','1',26688.80,28730.81,0.00,0.00,2042.01,1359649.60,0.00,0.00,0.00),('1','285','1','100',599,'5','1',32577.45,32699.97,0.00,0.00,122.52,82088.40,0.00,0.00,0.00),('1','285','1','100',600,'6','1',29036.83,29246.62,0.00,0.00,209.79,140559.30,0.00,0.00,0.00),('1','285','1','101',601,'1','1',18339.96,18339.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','101',602,'2','1',41868.91,41868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','101',603,'3','1',57490.20,57490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','101',604,'4','1',28730.81,28730.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','101',605,'5','1',32699.97,32699.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','101',606,'6','1',29246.62,29246.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','102',607,'1','1',18339.96,18736.44,0.00,0.00,396.48,281500.80,0.00,0.00,0.00),('1','285','1','102',608,'2','1',41868.91,42107.48,0.00,0.00,238.57,159841.90,0.00,0.00,0.00),('1','285','1','102',609,'3','1',57490.20,60300.28,0.00,0.00,2810.08,1874785.70,0.00,0.00,0.00),('1','285','1','102',610,'4','1',28730.81,30106.51,0.00,0.00,1375.70,919868.00,0.00,0.00,0.00),('1','285','1','102',611,'5','1',32699.97,33772.93,0.00,0.00,1072.96,715883.20,0.00,0.00,0.00),('1','285','1','102',612,'6','1',29246.62,29307.35,0.00,0.00,60.73,40689.10,0.00,0.00,0.00),('1','285','1','103',613,'1','1',18736.44,18736.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','103',614,'2','1',42107.48,42107.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','103',615,'3','1',60300.28,60300.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','103',616,'4','1',30106.51,30106.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','103',617,'5','1',33772.93,33772.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','103',618,'6','1',29307.35,29307.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','104',619,'1','1',18736.44,18943.08,0.00,0.00,206.64,146714.40,0.00,0.00,0.00),('1','285','1','104',620,'2','1',42107.48,42199.04,0.00,0.00,91.56,61345.20,0.00,0.00,0.00),('1','285','1','104',621,'3','1',60300.28,60861.51,0.00,0.00,561.23,375416.80,0.00,0.00,0.00),('1','285','1','104',622,'4','1',30106.51,30519.36,0.00,0.00,412.85,276609.50,0.00,0.00,0.00),('1','285','1','104',623,'5','1',33772.93,33909.13,0.00,0.00,136.20,91254.00,0.00,0.00,0.00),('1','285','1','104',624,'6','1',29307.35,29417.35,0.00,0.00,110.00,73700.00,0.00,0.00,0.00),('1','285','1','105',625,'1','1',18943.08,19212.78,0.00,0.00,269.70,191487.00,0.00,0.00,0.00),('1','285','1','105',626,'2','1',42199.04,43190.10,0.00,0.00,991.06,664010.20,0.00,0.00,0.00),('1','285','1','105',627,'3','1',60861.51,64622.25,0.00,0.00,3760.74,2506410.70,0.00,0.00,0.00),('1','285','1','105',628,'4','1',30519.36,31045.95,0.00,0.00,526.59,351244.85,0.00,0.00,0.00),('1','285','1','105',629,'5','1',33909.13,35103.53,0.00,0.00,1194.40,794523.65,0.00,0.00,0.00),('1','285','1','105',630,'6','1',29417.35,29417.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','106',631,'1','1',19212.78,19514.62,0.00,0.00,301.84,214306.40,0.00,0.00,0.00),('1','285','1','106',632,'2','1',43190.10,43686.21,0.00,0.00,496.11,332393.70,0.00,0.00,0.00),('1','285','1','106',633,'3','1',64622.25,65642.07,0.00,0.00,1019.82,681736.15,0.00,0.00,0.00),('1','285','1','106',634,'4','1',31045.95,32073.57,0.00,0.00,1027.62,685622.05,0.00,0.00,0.00),('1','285','1','106',635,'5','1',35103.53,36244.97,0.00,0.00,1141.44,761067.10,0.00,0.00,0.00),('1','285','1','106',636,'6','1',29417.35,30119.87,0.00,0.00,702.52,468556.90,0.00,0.00,0.00),('1','285','1','107',637,'1','1',19514.62,19751.19,0.00,0.00,236.57,167964.70,0.00,0.00,0.00),('1','285','1','107',638,'2','1',43686.21,43860.66,0.00,0.00,174.45,116543.70,0.00,0.00,0.00),('1','285','1','107',639,'3','1',65642.07,66705.29,0.00,0.00,1063.22,712357.40,0.00,0.00,0.00),('1','285','1','107',640,'4','1',32073.57,32333.86,0.00,0.00,260.29,173790.30,0.00,0.00,0.00),('1','285','1','107',641,'5','1',36244.97,36741.27,0.00,0.00,496.30,332521.00,0.00,0.00,0.00),('1','285','1','107',642,'6','1',30119.87,30302.37,0.00,0.00,182.50,122275.00,0.00,0.00,0.00),('1','285','1','108',643,'1','1',19751.19,19751.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','108',644,'2','1',43860.66,43860.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','108',645,'3','1',66705.29,66705.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','108',646,'4','1',32333.86,32333.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','108',647,'5','1',36741.27,36741.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','108',648,'6','1',30302.37,30302.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','109',649,'1','1',19751.19,20038.88,0.00,0.00,287.69,204259.90,0.00,0.00,0.00),('1','285','1','109',650,'2','1',43860.66,44128.55,0.00,0.00,267.89,179486.30,0.00,0.00,0.00),('1','285','1','109',651,'3','1',66705.29,69081.27,0.00,0.00,2375.98,1586344.10,0.00,0.00,0.00),('1','285','1','109',652,'4','1',32333.86,33319.60,0.00,0.00,985.74,657830.20,0.00,0.00,0.00),('1','285','1','109',653,'5','1',36741.27,38416.75,0.00,0.00,1675.48,1117293.75,0.00,0.00,0.00),('1','285','1','109',654,'6','1',30302.37,30756.03,0.00,0.00,453.66,302596.95,0.00,0.00,0.00),('1','285','1','110',655,'1','1',20038.88,20268.38,0.00,0.00,229.50,162945.00,0.00,0.00,0.00),('1','285','1','110',656,'2','1',44128.55,44349.11,0.00,0.00,220.56,147775.20,0.00,0.00,0.00),('1','285','1','110',657,'3','1',69081.27,69871.43,0.00,0.00,790.16,529407.20,0.00,0.00,0.00),('1','285','1','110',658,'4','1',33319.60,34171.34,0.00,0.00,851.74,570665.80,0.00,0.00,0.00),('1','285','1','110',659,'5','1',38416.75,38573.66,0.00,0.00,156.91,105129.70,0.00,0.00,0.00),('1','285','1','110',660,'6','1',30756.03,31138.20,0.00,0.00,382.17,254489.30,0.00,0.00,0.00),('1','285','1','111',661,'1','1',20268.38,20568.69,0.00,0.00,300.31,213220.10,0.00,0.00,0.00),('1','285','1','111',662,'2','1',44349.11,44808.45,0.00,0.00,459.34,307757.80,0.00,0.00,0.00),('1','285','1','111',663,'3','1',69871.43,71208.67,0.00,0.00,1337.24,895296.30,0.00,0.00,0.00),('1','285','1','111',664,'4','1',34171.34,34848.11,0.00,0.00,676.77,453435.90,0.00,0.00,0.00),('1','285','1','111',665,'5','1',38573.66,39461.53,0.00,0.00,887.87,590870.35,0.00,0.00,0.00),('1','285','1','111',666,'6','1',31138.20,31517.54,0.00,0.00,379.34,252923.70,0.00,0.00,0.00),('1','285','1','112',667,'1','1',20568.69,20730.96,0.00,0.00,162.27,115211.70,0.00,0.00,0.00),('1','285','1','112',668,'2','1',44808.45,44823.45,0.00,0.00,15.00,10050.00,0.00,0.00,0.00),('1','285','1','112',669,'3','1',71208.67,71828.64,0.00,0.00,619.97,414179.90,0.00,0.00,0.00),('1','285','1','112',670,'4','1',34848.11,35470.61,0.00,0.00,622.50,416367.25,0.00,0.00,0.00),('1','285','1','112',671,'5','1',39461.53,39852.75,0.00,0.00,391.22,262117.40,0.00,0.00,0.00),('1','285','1','112',672,'6','1',31517.54,31517.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','113',673,'1','1',20730.96,21144.14,0.00,0.00,413.18,293357.80,0.00,0.00,0.00),('1','285','1','113',674,'2','1',44823.45,45748.68,0.00,0.00,925.23,617804.10,0.00,0.00,0.00),('1','285','1','113',675,'3','1',71828.64,73188.45,0.00,0.00,1359.81,911072.70,0.00,0.00,0.00),('1','285','1','113',676,'4','1',35470.61,36902.80,0.00,0.00,1432.19,957305.15,0.00,0.00,0.00),('1','285','1','113',677,'5','1',39852.75,40366.12,0.00,0.00,513.37,343957.90,0.00,0.00,0.00),('1','285','1','113',678,'6','1',31517.54,31605.69,0.00,0.00,88.15,59060.50,0.00,0.00,0.00),('1','285','1','114',679,'1','1',21144.14,21144.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','114',680,'2','1',45748.68,45748.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','114',681,'3','1',73188.45,73188.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','114',682,'4','1',36902.80,36902.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','114',683,'5','1',40366.12,40366.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','114',684,'6','1',31605.69,31605.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','115',685,'1','1',21144.14,21144.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','115',686,'2','1',45748.68,45748.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','115',687,'3','1',73188.45,73250.89,0.00,0.00,62.44,41834.80,0.00,0.00,0.00),('1','285','1','115',688,'4','1',36902.80,36902.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','115',689,'5','1',40366.12,40366.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','115',690,'6','1',31605.69,31605.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','116',691,'1','1',21144.14,21446.45,0.00,0.00,302.31,214640.10,0.00,0.00,0.00),('1','285','1','116',692,'2','1',45748.68,46600.53,0.00,0.00,851.85,569499.25,0.00,0.00,0.00),('1','285','1','116',693,'3','1',73250.89,74152.25,0.00,0.00,901.36,603911.20,0.00,0.00,0.00),('1','285','1','116',694,'4','1',36902.80,38406.22,0.00,0.00,1503.42,1004043.25,0.00,0.00,0.00),('1','285','1','116',695,'5','1',40366.12,40908.08,0.00,0.00,541.96,363113.20,0.00,0.00,0.00),('1','285','1','116',696,'6','1',31605.69,31640.39,0.00,0.00,34.70,23249.00,0.00,0.00,0.00),('1','285','1','117',697,'1','1',21446.45,21778.58,0.00,0.00,332.13,235812.30,0.00,0.00,0.00),('1','285','1','117',698,'2','1',46600.53,46941.47,0.00,0.00,340.94,228429.80,0.00,0.00,0.00),('1','285','1','117',699,'3','1',74152.25,75015.78,0.00,0.00,863.53,578565.10,0.00,0.00,0.00),('1','285','1','117',700,'4','1',38406.22,39152.26,0.00,0.00,746.04,498569.60,0.00,0.00,0.00),('1','285','1','117',701,'5','1',40908.08,41394.32,0.00,0.00,486.24,325780.80,0.00,0.00,0.00),('1','285','1','117',702,'6','1',31640.39,32019.34,0.00,0.00,378.95,253154.00,0.00,0.00,0.00),('1','285','1','118',703,'1','1',21778.58,22021.03,0.00,0.00,242.45,172139.50,0.00,0.00,0.00),('1','285','1','118',704,'2','1',46941.47,47296.77,0.00,0.00,355.30,237746.90,0.00,0.00,0.00),('1','285','1','118',705,'3','1',75015.78,76436.26,0.00,0.00,1420.48,950864.30,0.00,0.00,0.00),('1','285','1','118',706,'4','1',39152.26,39497.34,0.00,0.00,345.08,231203.60,0.00,0.00,0.00),('1','285','1','118',707,'5','1',41394.32,41726.06,0.00,0.00,331.74,222265.80,0.00,0.00,0.00),('1','285','1','118',708,'6','1',32019.34,32241.34,0.00,0.00,222.00,148740.00,0.00,0.00,0.00),('1','285','1','119',709,'1','1',22021.03,22286.00,0.00,0.00,264.97,188128.70,0.00,0.00,0.00),('1','285','1','119',710,'2','1',47296.77,48120.63,0.00,0.00,823.86,551821.20,0.00,0.00,0.00),('1','285','1','119',711,'3','1',76436.26,77542.87,0.00,0.00,1106.61,740194.00,0.00,0.00,0.00),('1','285','1','119',712,'4','1',39497.34,40413.35,0.00,0.00,916.01,613726.70,0.00,0.00,0.00),('1','285','1','119',713,'5','1',41726.06,42325.29,0.00,0.00,599.23,399579.85,0.00,0.00,0.00),('1','285','1','119',714,'6','1',32241.34,33385.22,0.00,0.00,1143.88,755504.50,0.00,0.00,0.00),('1','285','1','120',715,'1','1',22286.00,22648.23,0.00,0.00,362.23,257183.30,0.00,0.00,0.00),('1','285','1','120',716,'2','1',48120.63,48987.61,0.00,0.00,866.98,579705.00,0.00,0.00,0.00),('1','285','1','120',717,'3','1',77542.87,78127.04,0.00,0.00,584.17,391393.90,0.00,0.00,0.00),('1','285','1','120',718,'4','1',40413.35,41577.14,0.00,0.00,1163.79,772225.70,0.00,0.00,0.00),('1','285','1','120',719,'5','1',42325.29,42916.07,0.00,0.00,590.78,395822.60,0.00,0.00,0.00),('1','285','1','120',720,'6','1',33385.22,33753.28,0.00,0.00,368.06,246000.20,0.00,0.00,0.00),('1','285','1','121',721,'1','1',22648.23,22655.27,0.00,0.00,7.04,4998.40,0.00,0.00,0.00),('1','285','1','121',722,'2','1',48987.61,49037.61,0.00,0.00,50.00,33500.00,0.00,0.00,0.00),('1','285','1','121',723,'3','1',78127.04,78127.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','121',724,'4','1',41577.14,41627.14,0.00,0.00,50.00,33500.00,0.00,0.00,0.00),('1','285','1','121',725,'5','1',42916.07,42916.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','121',726,'6','1',33753.28,33753.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','122',727,'1','1',22655.27,22655.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','122',728,'2','1',49037.61,49037.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','122',729,'3','1',78127.04,78127.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','122',730,'4','1',41627.14,41627.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','122',731,'5','1',42916.07,42916.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','122',732,'6','1',33753.28,33753.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','123',733,'1','1',22655.27,22914.30,0.00,0.00,259.03,183911.30,0.00,0.00,0.00),('1','285','1','123',734,'2','1',49037.61,49135.15,0.00,0.00,97.54,65351.80,0.00,0.00,0.00),('1','285','1','123',735,'3','1',78127.04,79535.00,0.00,0.00,1407.96,942433.20,0.00,0.00,0.00),('1','285','1','123',736,'4','1',41627.14,43494.64,0.00,0.00,1867.50,1244519.70,0.00,0.00,0.00),('1','285','1','123',737,'5','1',42916.07,43173.18,0.00,0.00,257.11,171423.40,0.00,0.00,0.00),('1','285','1','123',738,'6','1',33753.28,33813.61,0.00,0.00,60.33,40421.10,0.00,0.00,0.00),('1','285','1','124',739,'1','1',22914.30,23262.60,0.00,0.00,348.30,247293.00,0.00,0.00,0.00),('1','285','1','124',740,'2','1',49135.15,50003.47,0.00,0.00,868.32,580907.45,0.00,0.00,0.00),('1','285','1','124',741,'3','1',79535.00,81190.84,0.00,0.00,1655.84,1108729.95,0.00,0.00,0.00),('1','285','1','124',742,'4','1',43494.64,44603.53,0.00,0.00,1108.89,739566.70,0.00,0.00,0.00),('1','285','1','124',743,'5','1',43173.18,43661.38,0.00,0.00,488.20,324899.90,0.00,0.00,0.00),('1','285','1','124',744,'6','1',33813.61,33813.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','125',745,'1','1',23262.60,23600.00,0.00,0.00,337.40,239554.00,0.00,0.00,0.00),('1','285','1','125',746,'2','1',50003.47,50684.54,0.00,0.00,681.07,455911.90,0.00,0.00,0.00),('1','285','1','125',747,'3','1',81190.84,82463.21,0.00,0.00,1272.37,850721.70,0.00,0.00,0.00),('1','285','1','125',748,'4','1',44603.53,45550.20,0.00,0.00,946.67,632346.50,0.00,0.00,0.00),('1','285','1','125',749,'5','1',43661.38,44047.14,0.00,0.00,385.76,258459.20,0.00,0.00,0.00),('1','285','1','125',750,'6','1',33813.61,33865.61,0.00,0.00,52.00,34840.00,0.00,0.00,0.00),('1','285','1','126',751,'1','1',23600.00,23887.09,0.00,0.00,287.09,203833.90,0.00,0.00,0.00),('1','285','1','126',752,'2','1',50684.54,51679.85,0.00,0.00,995.31,666857.70,0.00,0.00,0.00),('1','285','1','126',753,'3','1',82463.21,83818.27,0.00,0.00,1355.06,907191.40,0.00,0.00,0.00),('1','285','1','126',754,'4','1',45550.20,46189.95,0.00,0.00,639.75,428482.50,0.00,0.00,0.00),('1','285','1','126',755,'5','1',44047.14,44096.66,0.00,0.00,49.52,33178.40,0.00,0.00,0.00),('1','285','1','126',756,'6','1',33865.61,34496.05,0.00,0.00,630.44,420814.20,0.00,0.00,0.00),('1','285','1','127',757,'1','1',23887.09,24100.93,0.00,0.00,213.84,151826.40,0.00,0.00,0.00),('1','285','1','127',758,'2','1',51679.85,52384.57,0.00,0.00,704.72,472162.40,0.00,0.00,0.00),('1','285','1','127',759,'3','1',83818.27,84997.21,0.00,0.00,1178.94,787231.30,0.00,0.00,0.00),('1','285','1','127',760,'4','1',46189.95,46523.12,0.00,0.00,333.17,223223.90,0.00,0.00,0.00),('1','285','1','127',761,'5','1',44096.66,44608.77,0.00,0.00,512.11,340553.15,0.00,0.00,0.00),('1','285','1','127',762,'6','1',34496.05,34496.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','128',763,'1','1',24100.93,24100.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','128',764,'2','1',52384.57,52384.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','128',765,'3','1',84997.21,84997.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','128',766,'4','1',46523.12,46523.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','128',767,'5','1',44608.77,44608.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','128',768,'6','1',34496.05,34496.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','129',769,'1','1',24100.93,24367.55,0.00,0.00,266.62,189300.20,0.00,0.00,0.00),('1','285','1','129',770,'2','1',52384.57,53137.33,0.00,0.00,752.76,504174.60,0.00,0.00,0.00),('1','285','1','129',771,'3','1',84997.21,86346.52,0.00,0.00,1349.31,900575.20,0.00,0.00,0.00),('1','285','1','129',772,'4','1',46523.12,47453.87,0.00,0.00,930.75,622005.10,0.00,0.00,0.00),('1','285','1','129',773,'5','1',44608.77,44903.47,0.00,0.00,294.70,196352.20,0.00,0.00,0.00),('1','285','1','129',774,'6','1',34496.05,35063.02,0.00,0.00,566.97,377035.05,0.00,0.00,0.00),('1','285','1','130',775,'1','1',24367.55,24675.82,0.00,0.00,308.27,218871.70,0.00,0.00,0.00),('1','285','1','130',776,'2','1',53137.33,53512.76,0.00,0.00,375.43,251538.10,0.00,0.00,0.00),('1','285','1','130',777,'3','1',86346.52,88510.12,0.00,0.00,2163.60,1446583.00,0.00,0.00,0.00),('1','285','1','130',778,'4','1',47453.87,48900.54,0.00,0.00,1446.67,961178.10,0.00,0.00,0.00),('1','285','1','130',779,'5','1',44903.47,44966.55,0.00,0.00,63.08,42263.60,0.00,0.00,0.00),('1','285','1','130',780,'6','1',35063.02,35087.76,0.00,0.00,24.74,16575.80,0.00,0.00,0.00),('1','285','1','131',781,'1','1',24675.82,24850.23,0.00,0.00,174.41,123831.10,0.00,0.00,0.00),('1','285','1','131',782,'2','1',53512.76,53602.76,0.00,0.00,90.00,60150.00,0.00,0.00,0.00),('1','285','1','131',783,'3','1',88510.12,89429.63,0.00,0.00,919.51,615986.70,0.00,0.00,0.00),('1','285','1','131',784,'4','1',48900.54,49327.14,0.00,0.00,426.60,285472.00,0.00,0.00,0.00),('1','285','1','131',785,'5','1',44966.55,45264.49,0.00,0.00,297.94,199619.80,0.00,0.00,0.00),('1','285','1','131',786,'6','1',35087.76,35195.20,0.00,0.00,107.44,71984.80,0.00,0.00,0.00),('1','285','1','132',787,'1','1',24850.23,25135.69,0.00,0.00,285.46,202676.60,0.00,0.00,0.00),('1','285','1','132',788,'2','1',53602.76,54352.47,0.00,0.00,749.71,502305.70,0.00,0.00,0.00),('1','285','1','132',789,'3','1',89429.63,90356.58,0.00,0.00,926.95,620826.50,0.00,0.00,0.00),('1','285','1','132',790,'4','1',49327.14,50040.47,0.00,0.00,713.33,477846.10,0.00,0.00,0.00),('1','285','1','132',791,'5','1',45264.49,45796.34,0.00,0.00,531.85,354750.70,0.00,0.00,0.00),('1','285','1','132',792,'6','1',35195.20,35569.84,0.00,0.00,374.64,249724.60,0.00,0.00,0.00),('1','285','1','133',793,'1','1',25135.69,25392.99,0.00,0.00,257.30,182683.00,0.00,0.00,0.00),('1','285','1','133',794,'2','1',54352.47,54681.67,0.00,0.00,329.20,220260.85,0.00,0.00,0.00),('1','285','1','133',795,'3','1',90356.58,91396.83,0.00,0.00,1040.25,696807.50,0.00,0.00,0.00),('1','285','1','133',796,'4','1',50040.47,51028.34,0.00,0.00,987.87,660034.50,0.00,0.00,0.00),('1','285','1','133',797,'5','1',45796.34,45886.63,0.00,0.00,90.29,60494.30,0.00,0.00,0.00),('1','285','1','133',798,'6','1',35569.84,35569.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','134',799,'1','1',25392.99,25635.12,0.00,0.00,242.13,171912.30,0.00,0.00,0.00),('1','285','1','134',800,'2','1',54681.67,54832.67,0.00,0.00,151.00,101170.00,0.00,0.00,0.00),('1','285','1','134',801,'3','1',91396.83,92227.66,0.00,0.00,830.83,556491.10,0.00,0.00,0.00),('1','285','1','134',802,'4','1',51028.34,51206.03,0.00,0.00,177.69,118897.30,0.00,0.00,0.00),('1','285','1','134',803,'5','1',45886.63,46412.44,0.00,0.00,525.81,351634.00,0.00,0.00,0.00),('1','285','1','134',804,'6','1',35569.84,35803.95,0.00,0.00,234.11,155992.30,0.00,0.00,0.00),('1','285','1','135',805,'1','1',25635.12,25635.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','135',806,'2','1',54832.67,54832.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','135',807,'3','1',92227.66,92227.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','135',808,'4','1',51206.03,51206.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','135',809,'5','1',46412.44,46412.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','135',810,'6','1',35803.95,35803.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','136',811,'1','1',25635.12,26034.33,0.00,0.00,399.21,283439.10,0.00,0.00,0.00),('1','285','1','136',812,'2','1',54832.67,55085.37,0.00,0.00,252.70,169084.00,0.00,0.00,0.00),('1','285','1','136',813,'3','1',92227.66,93570.97,0.00,0.00,1343.31,898035.00,0.00,0.00,0.00),('1','285','1','136',814,'4','1',51206.03,52571.01,0.00,0.00,1364.98,910912.80,0.00,0.00,0.00),('1','285','1','136',815,'5','1',46412.44,46923.65,0.00,0.00,511.21,342423.60,0.00,0.00,0.00),('1','285','1','136',816,'6','1',35803.95,36148.89,0.00,0.00,344.94,229840.90,0.00,0.00,0.00),('1','285','1','137',817,'1','1',26034.33,26334.04,0.00,0.00,299.71,212794.10,0.00,0.00,0.00),('1','285','1','137',818,'2','1',55085.37,55836.46,0.00,0.00,751.09,501045.30,0.00,0.00,0.00),('1','285','1','137',819,'3','1',93570.97,95950.42,0.00,0.00,2379.45,1589904.65,0.00,0.00,0.00),('1','285','1','137',820,'4','1',52571.01,53031.34,0.00,0.00,460.33,308421.10,0.00,0.00,0.00),('1','285','1','137',821,'5','1',46923.65,46949.52,0.00,0.00,25.87,17332.90,0.00,0.00,0.00),('1','285','1','137',822,'6','1',36148.89,36148.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','138',823,'1','1',26334.04,26678.96,0.00,0.00,344.92,244893.20,0.00,0.00,0.00),('1','285','1','138',824,'2','1',55836.46,56402.98,0.00,0.00,566.52,378023.50,0.00,0.00,0.00),('1','285','1','138',825,'3','1',95950.42,97632.59,0.00,0.00,1682.17,1122267.85,0.00,0.00,0.00),('1','285','1','138',826,'4','1',53031.34,54238.44,0.00,0.00,1207.10,805464.60,0.00,0.00,0.00),('1','285','1','138',827,'5','1',46949.52,47208.77,0.00,0.00,259.25,173697.50,0.00,0.00,0.00),('1','285','1','138',828,'6','1',36148.89,36278.89,0.00,0.00,130.00,87100.00,0.00,0.00,0.00),('1','285','1','139',829,'1','1',26678.96,26921.93,0.00,0.00,242.97,172508.70,0.00,0.00,0.00),('1','285','1','139',830,'2','1',56402.98,56535.64,0.00,0.00,132.66,88882.20,0.00,0.00,0.00),('1','285','1','139',831,'3','1',97632.59,98017.80,0.00,0.00,385.21,258090.70,0.00,0.00,0.00),('1','285','1','139',832,'4','1',54238.44,54849.07,0.00,0.00,610.63,409122.10,0.00,0.00,0.00),('1','285','1','139',833,'5','1',47208.77,47427.76,0.00,0.00,218.99,146278.25,0.00,0.00,0.00),('1','285','1','139',834,'6','1',36278.89,36450.46,0.00,0.00,171.57,114951.90,0.00,0.00,0.00),('1','285','1','140',835,'1','1',26921.93,27244.27,0.00,0.00,322.34,228861.40,0.00,0.00,0.00),('1','285','1','140',836,'2','1',56535.64,56937.52,0.00,0.00,401.88,268735.20,0.00,0.00,0.00),('1','285','1','140',837,'3','1',98017.80,99757.80,0.00,0.00,1740.00,1163149.75,0.00,0.00,0.00),('1','285','1','140',838,'4','1',54849.07,55965.42,0.00,0.00,1116.35,746398.15,0.00,0.00,0.00),('1','285','1','140',839,'5','1',47427.76,47589.08,0.00,0.00,161.32,108084.40,0.00,0.00,0.00),('1','285','1','140',840,'6','1',36450.46,36649.48,0.00,0.00,199.02,133198.40,0.00,0.00,0.00),('1','285','1','141',841,'1','1',27244.27,27319.15,0.00,0.00,74.88,53164.80,0.00,0.00,0.00),('1','285','1','141',842,'2','1',56937.52,57192.26,0.00,0.00,254.74,170455.80,0.00,0.00,0.00),('1','285','1','141',843,'3','1',99757.80,100298.98,0.00,0.00,541.18,361646.90,0.00,0.00,0.00),('1','285','1','141',844,'4','1',55965.42,56219.83,0.00,0.00,254.41,169608.45,0.00,0.00,0.00),('1','285','1','141',845,'5','1',47589.08,47589.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','141',846,'6','1',36649.48,36649.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','142',847,'1','1',27319.15,27319.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','142',848,'2','1',57192.26,57192.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','142',849,'3','1',100298.98,100298.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','142',850,'4','1',56219.83,56219.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','142',851,'5','1',47589.08,47589.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','142',852,'6','1',36649.48,36649.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','143',853,'1','1',27319.15,27496.09,0.00,0.00,176.94,125627.40,0.00,0.00,0.00),('1','285','1','143',854,'2','1',57192.26,57399.78,0.00,0.00,207.52,138388.40,0.00,0.00,0.00),('1','285','1','143',855,'3','1',100298.98,100771.48,0.00,0.00,472.50,316575.00,0.00,0.00,0.00),('1','285','1','143',856,'4','1',56219.83,56395.10,0.00,0.00,175.27,117430.90,0.00,0.00,0.00),('1','285','1','143',857,'5','1',47589.08,48692.12,0.00,0.00,1103.04,734342.65,0.00,0.00,0.00),('1','285','1','143',858,'6','1',36649.48,36854.48,0.00,0.00,205.00,136590.00,0.00,0.00,0.00),('1','285','1','144',859,'1','1',27496.09,27696.32,0.00,0.00,200.23,142163.30,0.00,0.00,0.00),('1','285','1','144',860,'2','1',57399.78,57673.71,0.00,0.00,273.93,183348.10,0.00,0.00,0.00),('1','285','1','144',861,'3','1',100771.48,101398.08,0.00,0.00,626.60,419822.00,0.00,0.00,0.00),('1','285','1','144',862,'4','1',56395.10,57619.52,0.00,0.00,1224.42,816791.15,0.00,0.00,0.00),('1','285','1','144',863,'5','1',48692.12,48766.22,0.00,0.00,74.10,49587.00,0.00,0.00,0.00),('1','285','1','144',864,'6','1',36854.48,37006.55,0.00,0.00,152.07,101886.90,0.00,0.00,0.00),('1','285','1','145',865,'1','1',27696.32,27986.68,0.00,0.00,290.36,206155.60,0.00,0.00,0.00),('1','285','1','145',866,'2','1',57673.71,57725.94,0.00,0.00,52.23,34994.10,0.00,0.00,0.00),('1','285','1','145',867,'3','1',101398.08,101732.93,0.00,0.00,334.85,223692.10,0.00,0.00,0.00),('1','285','1','145',868,'4','1',57619.52,58615.92,0.00,0.00,996.40,664295.00,0.00,0.00,0.00),('1','285','1','145',869,'5','1',48766.22,49092.19,0.00,0.00,325.97,218399.90,0.00,0.00,0.00),('1','285','1','145',870,'6','1',37006.55,37006.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','146',871,'1','1',27986.68,28245.66,0.00,0.00,258.98,183875.80,0.00,0.00,0.00),('1','285','1','146',872,'2','1',57725.94,57826.94,0.00,0.00,101.00,67670.00,0.00,0.00,0.00),('1','285','1','146',873,'3','1',101732.93,102133.32,0.00,0.00,400.39,268261.30,0.00,0.00,0.00),('1','285','1','146',874,'4','1',58615.92,59229.95,0.00,0.00,614.03,409597.70,0.00,0.00,0.00),('1','285','1','146',875,'5','1',49092.19,49826.80,0.00,0.00,734.61,489886.75,0.00,0.00,0.00),('1','285','1','146',876,'6','1',37006.55,37569.67,0.00,0.00,563.12,376216.25,0.00,0.00,0.00),('1','285','1','147',877,'1','1',28245.66,28449.43,0.00,0.00,203.77,144676.70,0.00,0.00,0.00),('1','285','1','147',878,'2','1',57826.94,57888.59,0.00,0.00,61.65,41305.50,0.00,0.00,0.00),('1','285','1','147',879,'3','1',102133.32,102469.49,0.00,0.00,336.17,224868.95,0.00,0.00,0.00),('1','285','1','147',880,'4','1',59229.95,60118.14,0.00,0.00,888.19,594037.30,0.00,0.00,0.00),('1','285','1','147',881,'5','1',49826.80,50847.09,0.00,0.00,1020.29,680959.95,0.00,0.00,0.00),('1','285','1','147',882,'6','1',37569.67,38958.92,0.00,0.00,1389.25,926620.05,0.00,0.00,0.00),('1','285','1','148',883,'1','1',28449.43,28653.42,0.00,0.00,203.99,144832.90,0.00,0.00,0.00),('1','285','1','148',884,'2','1',57888.59,57906.03,0.00,0.00,17.44,11684.80,0.00,0.00,0.00),('1','285','1','148',885,'3','1',102469.49,102914.09,0.00,0.00,444.60,297882.00,0.00,0.00,0.00),('1','285','1','148',886,'4','1',60118.14,60622.88,0.00,0.00,504.74,337630.80,0.00,0.00,0.00),('1','285','1','148',887,'5','1',50847.09,51449.77,0.00,0.00,602.68,403345.60,0.00,0.00,0.00),('1','285','1','148',888,'6','1',38958.92,39289.92,0.00,0.00,331.00,221020.00,0.00,0.00,0.00),('1','285','1','149',889,'1','1',28653.42,28944.69,0.00,0.00,291.27,206801.70,0.00,0.00,0.00),('1','285','1','149',890,'2','1',57906.03,58014.06,0.00,0.00,108.03,72380.10,0.00,0.00,0.00),('1','285','1','149',891,'3','1',102914.09,103504.19,0.00,0.00,590.10,395367.00,0.00,0.00,0.00),('1','285','1','149',892,'4','1',60622.88,61641.33,0.00,0.00,1018.45,681253.30,0.00,0.00,0.00),('1','285','1','149',893,'5','1',51449.77,51957.35,0.00,0.00,507.58,338817.75,0.00,0.00,0.00),('1','285','1','149',894,'6','1',39289.92,39656.89,0.00,0.00,366.97,244640.95,0.00,0.00,0.00),('1','285','1','150',895,'1','1',28944.69,28980.76,0.00,0.00,36.07,25609.70,0.00,0.00,0.00),('1','285','1','150',896,'2','1',58014.06,58212.66,0.00,0.00,198.60,133062.00,0.00,0.00,0.00),('1','285','1','150',897,'3','1',103504.19,103528.51,0.00,0.00,24.32,16294.40,0.00,0.00,0.00),('1','285','1','150',898,'4','1',61641.33,61720.71,0.00,0.00,79.38,53096.95,0.00,0.00,0.00),('1','285','1','150',899,'5','1',51957.35,52144.85,0.00,0.00,187.50,125025.00,0.00,0.00,0.00),('1','285','1','150',900,'6','1',39656.89,39686.89,0.00,0.00,30.00,20100.00,0.00,0.00,0.00),('1','285','1','151',901,'1','1',28980.76,28980.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','151',902,'2','1',58212.66,58212.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','151',903,'3','1',103528.51,103528.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','151',904,'4','1',61720.71,61720.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','151',905,'5','1',52144.85,52144.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','151',906,'6','1',39686.89,39686.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','152',907,'1','1',28980.76,29237.72,0.00,0.00,256.96,182441.60,0.00,0.00,0.00),('1','285','1','152',908,'2','1',58212.66,58806.57,0.00,0.00,593.91,397919.70,0.00,0.00,0.00),('1','285','1','152',909,'3','1',103528.51,103867.03,0.00,0.00,338.52,226053.40,0.00,0.00,0.00),('1','285','1','152',910,'4','1',61720.71,62439.93,0.00,0.00,719.22,481487.40,0.00,0.00,0.00),('1','285','1','152',911,'5','1',52144.85,52545.63,0.00,0.00,400.78,267502.15,0.00,0.00,0.00),('1','285','1','152',912,'6','1',39686.89,40666.65,0.00,0.00,979.76,652651.30,0.00,0.00,0.00),('1','285','1','153',913,'1','1',29237.72,29500.65,0.00,0.00,262.93,186680.30,0.00,0.00,0.00),('1','285','1','153',914,'2','1',58806.57,59343.01,0.00,0.00,536.44,358849.80,0.00,0.00,0.00),('1','285','1','153',915,'3','1',103867.03,104335.32,0.00,0.00,468.29,313466.40,0.00,0.00,0.00),('1','285','1','153',916,'4','1',62439.93,63416.38,0.00,0.00,976.45,650916.50,0.00,0.00,0.00),('1','285','1','153',917,'5','1',52545.63,52854.29,0.00,0.00,308.66,206802.20,0.00,0.00,0.00),('1','285','1','153',918,'6','1',40666.65,41218.14,0.00,0.00,551.49,367349.45,0.00,0.00,0.00),('1','285','1','154',919,'1','1',29500.65,29857.69,0.00,0.00,357.04,253498.40,0.00,0.00,0.00),('1','285','1','154',920,'2','1',59343.01,60291.42,0.00,0.00,948.41,634057.65,0.00,0.00,0.00),('1','285','1','154',921,'3','1',104335.32,105079.67,0.00,0.00,744.35,498414.50,0.00,0.00,0.00),('1','285','1','154',922,'4','1',63416.38,64208.68,0.00,0.00,792.30,529267.50,0.00,0.00,0.00),('1','285','1','154',923,'5','1',52854.29,53364.12,0.00,0.00,509.83,340304.10,0.00,0.00,0.00),('1','285','1','154',924,'6','1',41218.14,41652.80,0.00,0.00,434.66,289422.20,0.00,0.00,0.00),('1','285','1','155',925,'1','1',29857.69,30307.86,0.00,0.00,450.17,319620.70,0.00,0.00,0.00),('1','285','1','155',926,'2','1',60291.42,61084.51,0.00,0.00,793.09,530580.90,0.00,0.00,0.00),('1','285','1','155',927,'3','1',105079.67,106183.32,0.00,0.00,1103.65,737295.65,0.00,0.00,0.00),('1','285','1','155',928,'4','1',64208.68,64513.36,0.00,0.00,304.68,204135.60,0.00,0.00,0.00),('1','285','1','155',929,'5','1',53364.12,53862.83,0.00,0.00,498.71,333473.45,0.00,0.00,0.00),('1','285','1','155',930,'6','1',41652.80,41774.52,0.00,0.00,121.72,81552.40,0.00,0.00,0.00),('1','285','1','156',931,'1','1',30307.86,30522.78,0.00,0.00,214.92,152593.20,0.00,0.00,0.00),('1','285','1','156',932,'2','1',61084.51,61922.55,0.00,0.00,838.04,561009.90,0.00,0.00,0.00),('1','285','1','156',933,'3','1',106183.32,107301.83,0.00,0.00,1118.51,746605.30,0.00,0.00,0.00),('1','285','1','156',934,'4','1',64513.36,64851.89,0.00,0.00,338.53,226815.10,0.00,0.00,0.00),('1','285','1','156',935,'5','1',53862.83,54319.27,0.00,0.00,456.44,305506.55,0.00,0.00,0.00),('1','285','1','156',936,'6','1',41774.52,42096.01,0.00,0.00,321.49,213790.85,0.00,0.00,0.00),('1','285','1','157',937,'1','1',30522.78,30522.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','157',938,'2','1',61922.55,61922.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','157',939,'3','1',107301.83,107301.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','157',940,'4','1',64851.89,64851.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','157',941,'5','1',54319.27,54319.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','157',942,'6','1',42096.01,42096.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','158',943,'1','1',30522.78,30896.54,0.00,0.00,373.76,265369.60,0.00,0.00,0.00),('1','285','1','158',944,'2','1',61922.55,62204.91,0.00,0.00,282.36,189181.20,0.00,0.00,0.00),('1','285','1','158',945,'3','1',107301.83,108438.31,0.00,0.00,1136.48,759926.80,0.00,0.00,0.00),('1','285','1','158',946,'4','1',64851.89,66248.54,0.00,0.00,1396.65,932525.45,0.00,0.00,0.00),('1','285','1','158',947,'5','1',54319.27,54609.14,0.00,0.00,289.87,194212.90,0.00,0.00,0.00),('1','285','1','158',948,'6','1',42096.01,42994.77,0.00,0.00,898.76,597983.35,0.00,0.00,0.00),('1','285','1','159',949,'1','1',30896.54,31286.82,0.00,0.00,390.28,277098.80,0.00,0.00,0.00),('1','285','1','159',950,'2','1',62204.91,62593.70,0.00,0.00,388.79,260187.30,0.00,0.00,0.00),('1','285','1','159',951,'3','1',108438.31,110193.20,0.00,0.00,1754.89,1170122.40,0.00,0.00,0.00),('1','285','1','159',952,'4','1',66248.54,66819.86,0.00,0.00,571.32,381920.45,0.00,0.00,0.00),('1','285','1','159',953,'5','1',54609.14,54953.59,0.00,0.00,344.45,230781.50,0.00,0.00,0.00),('1','285','1','159',954,'6','1',42994.77,42994.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','160',955,'1','1',31286.82,31544.64,0.00,0.00,257.82,183052.20,0.00,0.00,0.00),('1','285','1','160',956,'2','1',62593.70,62902.19,0.00,0.00,308.49,206688.30,0.00,0.00,0.00),('1','285','1','160',957,'3','1',110193.20,111020.13,0.00,0.00,826.93,554043.10,0.00,0.00,0.00),('1','285','1','160',958,'4','1',66819.86,67078.40,0.00,0.00,258.54,173221.80,0.00,0.00,0.00),('1','285','1','160',959,'5','1',54953.59,55063.30,0.00,0.00,109.71,73505.70,0.00,0.00,0.00),('1','285','1','160',960,'6','1',42994.77,42994.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','161',961,'1','1',31544.64,31972.97,0.00,0.00,428.33,304114.30,0.00,0.00,0.00),('1','285','1','161',962,'2','1',62902.19,63082.18,0.00,0.00,179.99,120593.30,0.00,0.00,0.00),('1','285','1','161',963,'3','1',111020.13,111610.42,0.00,0.00,590.29,395195.05,0.00,0.00,0.00),('1','285','1','161',964,'4','1',67078.40,67724.89,0.00,0.00,646.49,431168.80,0.00,0.00,0.00),('1','285','1','161',965,'5','1',55063.30,55424.86,0.00,0.00,361.56,241942.15,0.00,0.00,0.00),('1','285','1','161',966,'6','1',42994.77,43662.20,0.00,0.00,667.43,445272.90,0.00,0.00,0.00),('1','285','1','162',967,'1','1',31972.97,32334.29,0.00,0.00,361.32,256537.20,0.00,0.00,0.00),('1','285','1','162',968,'2','1',63082.18,63409.44,0.00,0.00,327.26,219264.20,0.00,0.00,0.00),('1','285','1','162',969,'3','1',111610.42,112147.32,0.00,0.00,536.90,358903.05,0.00,0.00,0.00),('1','285','1','162',970,'4','1',67724.89,68499.91,0.00,0.00,775.02,518476.75,0.00,0.00,0.00),('1','285','1','162',971,'5','1',55424.86,55815.86,0.00,0.00,391.00,261661.90,0.00,0.00,0.00),('1','285','1','162',972,'6','1',43662.20,43859.59,0.00,0.00,197.39,132251.30,0.00,0.00,0.00),('1','285','1','163',973,'1','1',32334.29,32334.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','163',974,'2','1',63409.44,63409.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','163',975,'3','1',112147.32,112147.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','163',976,'4','1',68499.91,68499.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','163',977,'5','1',55815.86,55815.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','163',978,'6','1',43859.59,43859.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','164',979,'1','1',32334.29,32524.45,0.00,0.00,190.16,135013.60,0.00,0.00,0.00),('1','285','1','164',980,'2','1',63409.44,63471.92,0.00,0.00,62.48,41861.60,0.00,0.00,0.00),('1','285','1','164',981,'3','1',112147.32,112461.23,0.00,0.00,313.91,210319.70,0.00,0.00,0.00),('1','285','1','164',982,'4','1',68499.91,68983.09,0.00,0.00,483.18,323730.60,0.00,0.00,0.00),('1','285','1','164',983,'5','1',55815.86,56410.85,0.00,0.00,594.99,396403.30,0.00,0.00,0.00),('1','285','1','164',984,'6','1',43859.59,44052.92,0.00,0.00,193.33,129531.10,0.00,0.00,0.00),('1','285','1','165',985,'1','1',32524.45,32957.52,0.00,0.00,433.07,307479.70,0.00,0.00,0.00),('1','285','1','165',986,'2','1',63471.92,64338.78,0.00,0.00,866.86,579906.20,0.00,0.00,0.00),('1','285','1','165',987,'3','1',112461.23,114052.03,0.00,0.00,1590.80,1059691.75,0.00,0.00,0.00),('1','285','1','165',988,'4','1',68983.09,69827.35,0.00,0.00,844.26,563853.10,0.00,0.00,0.00),('1','285','1','165',989,'5','1',56410.85,56844.57,0.00,0.00,433.72,289211.60,0.00,0.00,0.00),('1','285','1','165',990,'6','1',44052.92,44148.68,0.00,0.00,95.76,64159.20,0.00,0.00,0.00),('1','285','1','166',991,'1','1',32957.52,33454.35,0.00,0.00,496.83,352749.30,0.00,0.00,0.00),('1','285','1','166',992,'2','1',64338.78,65454.36,0.00,0.00,1115.58,742740.70,0.00,0.00,0.00),('1','285','1','166',993,'3','1',114052.03,114905.19,0.00,0.00,853.16,570705.65,0.00,0.00,0.00),('1','285','1','166',994,'4','1',69827.35,70468.14,0.00,0.00,640.79,428834.30,0.00,0.00,0.00),('1','285','1','166',995,'5','1',56844.57,57486.80,0.00,0.00,642.23,427427.80,0.00,0.00,0.00),('1','285','1','166',996,'6','1',44148.68,44423.68,0.00,0.00,275.00,183430.00,0.00,0.00,0.00),('1','285','1','167',997,'1','1',33454.35,33781.66,0.00,0.00,327.31,232390.10,0.00,0.00,0.00),('1','285','1','167',998,'2','1',65454.36,65637.14,0.00,0.00,182.78,122161.85,0.00,0.00,0.00),('1','285','1','167',999,'3','1',114905.19,115051.60,0.00,0.00,146.41,98094.70,0.00,0.00,0.00),('1','285','1','167',1000,'4','1',70468.14,71493.51,0.00,0.00,1025.37,685792.65,0.00,0.00,0.00),('1','285','1','167',1001,'5','1',57486.80,57663.68,0.00,0.00,176.88,118509.60,0.00,0.00,0.00),('1','285','1','167',1002,'6','1',44423.68,45164.29,0.00,0.00,740.61,493027.65,0.00,0.00,0.00),('1','285','1','168',1003,'1','1',33781.66,34329.77,0.00,0.00,548.11,389158.10,0.00,0.00,0.00),('1','285','1','168',1004,'2','1',65637.14,66479.04,0.00,0.00,841.90,563359.75,0.00,0.00,0.00),('1','285','1','168',1005,'3','1',115051.60,115408.72,0.00,0.00,357.12,239270.40,0.00,0.00,0.00),('1','285','1','168',1006,'4','1',71493.51,71874.87,0.00,0.00,381.36,255205.60,0.00,0.00,0.00),('1','285','1','168',1007,'5','1',57663.68,58606.66,0.00,0.00,942.98,628386.20,0.00,0.00,0.00),('1','285','1','168',1008,'6','1',45164.29,45486.74,0.00,0.00,322.45,214429.25,0.00,0.00,0.00),('1','285','1','169',1009,'1','1',34329.77,34506.83,0.00,0.00,177.06,125712.60,0.00,0.00,0.00),('1','285','1','169',1010,'2','1',66479.04,66909.45,0.00,0.00,430.41,288374.70,0.00,0.00,0.00),('1','285','1','169',1011,'3','1',115408.72,116454.10,0.00,0.00,1045.38,697921.10,0.00,0.00,0.00),('1','285','1','169',1012,'4','1',71874.87,72519.04,0.00,0.00,644.17,429793.90,0.00,0.00,0.00),('1','285','1','169',1013,'5','1',58606.66,58990.89,0.00,0.00,384.23,257434.10,0.00,0.00,0.00),('1','285','1','169',1014,'6','1',45486.74,45486.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','170',1015,'1','1',34506.83,34506.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','170',1016,'2','1',66909.45,66909.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','170',1017,'3','1',116454.10,116454.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','170',1018,'4','1',72519.04,72519.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','170',1019,'5','1',58990.89,58990.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','170',1020,'6','1',45486.74,45486.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','171',1021,'1','1',34506.83,35096.51,0.00,0.00,589.68,418672.80,0.00,0.00,0.00),('1','285','1','171',1022,'2','1',66909.45,67510.29,0.00,0.00,600.84,401932.80,0.00,0.00,0.00),('1','285','1','171',1023,'3','1',116454.10,117095.43,0.00,0.00,641.33,429441.10,0.00,0.00,0.00),('1','285','1','171',1024,'4','1',72519.04,73637.08,0.00,0.00,1118.04,746779.25,0.00,0.00,0.00),('1','285','1','171',1025,'5','1',58990.89,60229.21,0.00,0.00,1238.32,828702.90,0.00,0.00,0.00),('1','285','1','171',1026,'6','1',45486.74,46079.18,0.00,0.00,592.44,396934.80,0.00,0.00,0.00),('1','285','1','172',1027,'1','1',35096.51,35314.62,0.00,0.00,218.11,154858.10,0.00,0.00,0.00),('1','285','1','172',1028,'2','1',67510.29,67510.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','172',1029,'3','1',117095.43,117130.28,0.00,0.00,34.85,23349.50,0.00,0.00,0.00),('1','285','1','172',1030,'4','1',73637.08,74106.13,0.00,0.00,469.05,314263.50,0.00,0.00,0.00),('1','285','1','172',1031,'5','1',60229.21,60933.55,0.00,0.00,704.34,471907.80,0.00,0.00,0.00),('1','285','1','172',1032,'6','1',46079.18,46140.78,0.00,0.00,61.60,41272.00,0.00,0.00,0.00),('1','285','1','173',1033,'1','1',35314.62,35665.07,0.00,0.00,350.45,248819.50,0.00,0.00,0.00),('1','285','1','173',1034,'2','1',67510.29,68141.32,0.00,0.00,631.03,422317.05,0.00,0.00,0.00),('1','285','1','173',1035,'3','1',117130.28,117960.80,0.00,0.00,830.52,556145.55,0.00,0.00,0.00),('1','285','1','173',1036,'4','1',74106.13,74902.01,0.00,0.00,795.88,532264.40,0.00,0.00,0.00),('1','285','1','173',1037,'5','1',60933.55,61253.55,0.00,0.00,320.00,213438.45,0.00,0.00,0.00),('1','285','1','173',1038,'6','1',46140.78,46202.78,0.00,0.00,62.00,41540.00,0.00,0.00,0.00),('1','285','1','174',1039,'1','1',35665.07,35986.72,0.00,0.00,321.65,228371.50,0.00,0.00,0.00),('1','285','1','174',1040,'2','1',68141.32,69343.72,0.00,0.00,1202.40,801096.50,0.00,0.00,0.00),('1','285','1','174',1041,'3','1',117960.80,118597.44,0.00,0.00,636.64,426261.85,0.00,0.00,0.00),('1','285','1','174',1042,'4','1',74902.01,75639.57,0.00,0.00,737.56,493915.20,0.00,0.00,0.00),('1','285','1','174',1043,'5','1',61253.55,62004.83,0.00,0.00,751.28,500132.05,0.00,0.00,0.00),('1','285','1','174',1044,'6','1',46202.78,46634.04,0.00,0.00,431.26,288641.45,0.00,0.00,0.00),('1','285','1','175',1045,'1','1',35986.72,36071.63,0.00,0.00,84.91,60286.10,0.00,0.00,0.00),('1','285','1','175',1046,'2','1',69343.72,69420.15,0.00,0.00,76.43,51208.10,0.00,0.00,0.00),('1','285','1','175',1047,'3','1',118597.44,118996.77,0.00,0.00,399.33,265804.45,0.00,0.00,0.00),('1','285','1','175',1048,'4','1',75639.57,75998.17,0.00,0.00,358.60,240262.00,0.00,0.00,0.00),('1','285','1','175',1049,'5','1',62004.83,62153.47,0.00,0.00,148.64,99588.80,0.00,0.00,0.00),('1','285','1','175',1050,'6','1',46634.04,46712.04,0.00,0.00,78.00,52260.00,0.00,0.00,0.00),('1','285','1','176',1051,'1','1',36071.63,36071.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','176',1052,'2','1',69420.15,69420.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','176',1053,'3','1',118996.77,118996.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','176',1054,'4','1',75998.17,75998.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','176',1055,'5','1',62153.47,62153.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','176',1056,'6','1',46712.04,46712.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','177',1057,'1','1',36071.63,36303.91,0.00,0.00,232.28,164918.80,0.00,0.00,0.00),('1','285','1','177',1058,'2','1',69420.15,69666.54,0.00,0.00,246.39,165081.30,0.00,0.00,0.00),('1','285','1','177',1059,'3','1',118996.77,119904.91,0.00,0.00,908.14,606653.80,0.00,0.00,0.00),('1','285','1','177',1060,'4','1',75998.17,76376.93,0.00,0.00,378.76,252225.40,0.00,0.00,0.00),('1','285','1','177',1061,'5','1',62153.47,63112.67,0.00,0.00,959.20,638489.00,0.00,0.00,0.00),('1','285','1','177',1062,'6','1',46712.04,46712.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','285','1','178',1063,'1','1',36303.91,36756.53,0.00,0.00,452.62,321360.20,0.00,0.00,0.00),('1','285','1','178',1064,'2','1',69666.54,70173.59,0.00,0.00,507.05,339723.50,0.00,0.00,0.00),('1','285','1','178',1065,'3','1',119904.91,120390.65,0.00,0.00,485.74,325144.05,0.00,0.00,0.00),('1','285','1','178',1066,'4','1',76376.93,77438.09,0.00,0.00,1061.16,710511.40,0.00,0.00,0.00),('1','285','1','178',1067,'5','1',63112.67,63310.20,0.00,0.00,197.53,132041.15,0.00,0.00,0.00),('1','285','1','178',1068,'6','1',46712.04,47164.71,0.00,0.00,452.67,302085.60,0.00,0.00,0.00),('1','285','1','179',1069,'1','1',36756.53,37268.14,0.00,0.00,511.61,363243.10,0.00,0.00,0.00),('1','285','1','179',1070,'2','1',70173.59,70866.82,0.00,0.00,693.23,463836.55,0.00,0.00,0.00),('1','285','1','179',1071,'3','1',120390.65,121172.09,0.00,0.00,781.44,522654.10,0.00,0.00,0.00),('1','285','1','179',1072,'4','1',77438.09,78345.15,0.00,0.00,907.06,605840.85,0.00,0.00,0.00),('1','285','1','179',1073,'5','1',63310.20,63777.18,0.00,0.00,466.98,312511.60,0.00,0.00,0.00),('1','285','1','179',1074,'6','1',47164.71,47297.92,0.00,0.00,133.21,89250.70,0.00,0.00,0.00),('1','285','1','180',1075,'1','1',37268.14,37746.71,0.00,0.00,478.57,339784.70,0.00,0.00,0.00),('1','285','1','180',1076,'2','1',70866.82,72138.73,0.00,0.00,1271.91,847979.70,0.00,0.00,0.00),('1','285','1','180',1077,'3','1',121172.09,122236.13,0.00,0.00,1064.04,711729.80,0.00,0.00,0.00),('1','285','1','180',1078,'4','1',78345.15,79771.38,0.00,0.00,1426.23,953300.15,0.00,0.00,0.00),('1','285','1','180',1079,'5','1',63777.18,65473.74,0.00,0.00,1696.56,1132619.70,0.00,0.00,0.00),('1','285','1','180',1080,'6','1',47297.92,48585.82,0.00,0.00,1287.90,859848.70,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=181 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','285','1','1',615.00,720.00,0.00,119.80,73677.00,86256.00,12579.00,1),('1','285','2','1',615.00,0.00,0.00,647.23,398046.45,442750.50,44704.05,2),('1','285','3','1',615.00,0.00,0.00,198.99,122378.85,140485.50,18106.65,3),('1','285','4','1',615.00,0.00,0.00,1397.03,859173.45,948357.45,89184.00,4),('1','285','5','1',615.00,720.00,0.00,1350.92,830815.80,914762.40,83946.60,5),('1','285','6','1',615.00,0.00,0.00,3812.65,2344779.75,2576152.05,231372.30,6),('1','285','7','1',615.00,0.00,0.00,1548.62,952401.30,1051268.85,98867.55,7),('1','285','8','1',615.00,0.00,0.00,3576.67,2199652.05,2424136.95,224484.90,8),('1','285','9','1',615.00,720.00,0.00,2488.40,1530366.00,1687931.10,157565.10,9),('1','285','10','1',615.00,750.00,0.00,1865.99,1147583.85,1268419.50,120835.65,10),('1','285','11','1',615.00,720.00,0.00,1707.82,1050309.30,1161141.75,110832.45,11),('1','285','12','1',615.00,720.00,0.00,2099.21,1291014.15,1421960.40,130946.25,12),('1','285','13','1',615.00,720.00,0.00,2067.58,1271561.70,1399317.75,127756.05,13),('1','285','14','1',615.00,720.00,0.00,1009.67,620947.05,685494.90,64547.85,14),('1','285','15','1',615.00,720.00,0.00,0.00,0.00,0.00,0.00,15),('1','285','16','1',630.00,720.00,0.00,297.51,187431.30,201488.40,14057.10,16),('1','285','17','1',630.00,720.00,0.00,3342.42,2105724.60,2272535.55,166810.95,17),('1','285','18','1',630.00,720.00,0.00,2348.44,1479517.20,1596535.65,117018.45,18),('1','285','19','1',630.00,720.00,0.00,2349.56,1480222.80,1595561.13,115338.33,19),('1','285','20','1',630.00,720.00,0.00,3177.44,2001787.20,2156781.60,154994.40,20),('1','285','21','1',630.00,720.00,0.00,3115.45,1962733.50,2112170.85,149437.35,21),('1','285','22','1',630.00,720.00,0.00,2882.25,1815817.50,1958805.00,142987.50,22),('1','285','23','1',630.00,720.00,0.00,0.00,0.00,0.00,0.00,23),('1','285','24','1',650.00,750.00,0.00,2145.28,1394432.00,1490695.80,96263.80,24),('1','285','25','1',650.00,750.00,0.00,2329.55,1514207.50,1621070.70,106863.20,25),('1','285','26','1',650.00,750.00,0.00,1520.55,988357.50,1058078.70,69721.20,26),('1','285','27','1',650.00,750.00,0.00,904.15,587697.50,633337.50,45640.00,27),('1','285','28','1',650.00,750.00,0.00,1263.78,821457.00,883059.60,61602.60,28),('1','285','29','1',650.00,750.00,0.00,1445.59,939633.50,1005036.30,65402.80,29),('1','285','30','1',650.00,750.00,0.00,1041.87,677215.50,728932.50,51717.00,30),('1','285','31','1',650.00,750.00,0.00,1662.33,1080514.50,1160778.30,80263.80,31),('1','285','32','1',650.00,750.00,0.00,1388.13,902284.50,970406.70,68122.20,32),('1','285','33','1',650.00,750.00,0.00,973.55,632807.50,680659.50,47852.00,33),('1','285','34','1',650.00,750.00,0.00,1219.03,792369.50,850911.90,58542.40,34),('1','285','35','1',650.00,750.00,0.00,910.98,592137.00,629860.00,37723.00,35),('1','285','36','1',650.00,750.00,0.00,1461.72,950118.00,1010264.90,60146.90,36),('1','285','37','1',650.00,750.00,0.00,1010.38,656747.00,695293.20,38546.20,37),('1','285','38','1',650.00,750.00,0.00,0.00,0.00,0.00,0.00,38),('1','285','39','1',640.00,750.00,0.00,1470.80,955315.60,1003798.50,48482.90,39),('1','285','40','1',650.00,750.00,0.00,1138.74,740181.00,781264.50,41083.50,40),('1','285','41','1',650.00,750.00,0.00,856.90,556985.00,592773.75,35788.75,41),('1','285','42','1',650.00,750.00,0.00,941.71,612111.50,647757.00,35645.50,42),('1','285','43','1',650.00,750.00,0.00,771.76,501644.00,533353.50,31709.50,43),('1','285','44','1',650.00,750.00,0.00,1222.04,794326.00,837057.00,42731.00,44),('1','285','45','1',650.00,750.00,0.00,1737.98,1129687.00,1190543.25,60856.25,45),('1','285','46','1',650.00,750.00,0.00,1161.17,754760.50,794570.25,39809.75,46),('1','285','47','1',650.00,750.00,0.00,1069.08,673520.40,732426.00,58905.60,47),('1','285','48','1',630.00,750.00,0.00,1448.21,912372.30,986242.30,73870.00,48),('1','285','49','1',630.00,750.00,0.00,2131.28,1342706.40,1443224.00,100517.60,49),('1','285','50','1',630.00,750.00,0.00,0.00,0.00,0.00,0.00,50),('1','285','51','1',630.00,750.00,0.00,1079.55,680116.50,738544.90,58428.40,51),('1','285','52','1',630.00,750.00,0.00,1935.42,1219314.60,1319609.80,100295.20,52),('1','285','53','1',630.00,750.00,0.00,2700.34,1701214.20,1821659.80,120445.60,53),('1','285','54','1',630.00,750.00,0.00,2116.94,1333672.20,1432706.60,99034.40,54),('1','285','55','1',630.00,750.00,0.00,2113.12,1331265.60,1425150.35,93884.75,55),('1','285','56','1',630.00,750.00,0.00,1392.24,877111.20,947351.75,70240.55,56),('1','285','57','1',630.00,750.00,0.00,1285.97,810161.10,884148.70,73987.60,57),('1','285','58','1',630.00,750.00,0.00,793.21,499722.30,542693.10,42970.80,58),('1','285','59','1',630.00,750.00,0.00,2389.13,1505151.90,1622983.50,117831.60,59),('1','285','60','1',630.00,750.00,0.00,2025.16,1275850.80,1371592.40,95741.60,60),('1','285','61','1',630.00,750.00,0.00,1448.39,912485.70,980585.30,68099.60,61),('1','285','62','1',630.00,750.00,0.00,0.00,0.00,0.00,0.00,62),('1','285','63','1',630.00,750.00,0.00,631.97,398141.10,429936.70,31795.60,63),('1','285','64','1',630.00,750.00,0.00,1141.57,719189.10,777675.10,58486.00,64),('1','285','65','1',630.00,750.00,0.00,1799.99,1133993.70,1220535.95,86542.25,65),('1','285','66','1',630.00,750.00,0.00,1448.22,912378.60,995993.80,83615.20,66),('1','285','67','1',630.00,750.00,0.00,1007.68,634838.40,687058.40,52220.00,67),('1','285','68','1',630.00,750.00,0.00,3240.44,2041477.20,2185667.50,144190.30,68),('1','285','69','1',630.00,750.00,0.00,1770.01,1115106.30,1205710.70,90604.40,69),('1','285','70','1',630.00,750.00,0.00,1317.30,829899.00,909048.60,79149.60,70),('1','285','71','1',630.00,750.00,0.00,1415.56,891802.80,961965.20,70162.40,71),('1','285','72','1',630.00,750.00,0.00,3389.79,2135567.70,2296671.10,161103.40,72),('1','285','73','1',630.00,750.00,0.00,562.36,354286.80,381690.00,27403.20,73),('1','285','74','1',630.00,750.00,0.00,0.00,0.00,0.00,0.00,74),('1','285','75','1',630.00,750.00,0.00,9095.87,5730398.10,6112905.45,382507.35,75),('1','285','76','1',630.00,750.00,0.00,4783.76,3013768.80,3232177.75,218408.95,76),('1','285','77','1',630.00,750.00,0.00,3373.53,2125323.90,2272298.50,146974.60,77),('1','285','78','1',630.00,750.00,0.00,0.00,0.00,0.00,0.00,78),('1','285','79','1',630.00,750.00,0.00,2765.26,1742113.80,1875070.80,132957.00,79),('1','285','80','1',630.00,750.00,0.00,2883.96,1816894.80,1948804.55,131909.75,80),('1','285','81','1',630.00,750.00,0.00,5661.94,3567022.20,3794732.90,227710.70,81),('1','285','82','1',630.00,750.00,0.00,5797.69,3652544.70,3892382.55,239837.85,82),('1','285','83','1',630.00,750.00,0.00,3099.36,1952596.80,2081751.85,129155.05,83),('1','285','84','1',630.00,750.00,0.00,0.00,0.00,0.00,0.00,84),('1','285','85','1',630.00,750.00,0.00,3619.50,2280285.00,2432881.50,152596.50,85),('1','285','86','1',630.00,750.00,0.00,1686.60,1062558.00,1153927.60,91369.60,86),('1','285','87','1',630.00,750.00,0.00,5270.95,3320698.50,3548015.40,227316.90,87),('1','285','88','1',630.00,750.00,0.00,4961.76,3125908.80,3326880.30,200971.50,88),('1','285','89','1',630.00,750.00,0.00,3984.04,2509945.20,2686150.60,176205.40,89),('1','285','90','1',630.00,750.00,0.00,0.00,0.00,0.00,0.00,90),('1','285','91','1',630.00,750.00,0.00,5254.65,3310429.50,3524935.35,214505.85,91),('1','285','92','1',630.00,750.00,0.00,3087.45,1945093.50,2079854.45,134760.95,92),('1','285','93','1',630.00,750.00,0.00,5090.07,3206744.10,3426776.60,220032.50,93),('1','285','94','1',630.00,750.00,0.00,2734.25,1722577.50,1849947.25,127369.75,94),('1','285','95','1',630.00,750.00,0.00,3529.35,2223490.50,2371499.75,148009.25,95),('1','285','96','1',630.00,750.00,0.00,0.00,0.00,0.00,0.00,96),('1','285','97','1',630.00,750.00,0.00,7323.60,4613868.00,4910314.90,296446.90,97),('1','285','98','1',630.00,750.00,0.00,4925.15,3102844.50,3304838.35,201993.85,98),('1','285','99','1',630.00,750.00,0.00,3481.73,2193489.90,2349286.75,155796.85,99),('1','285','100','1',630.00,750.00,0.00,4331.43,2728800.90,2901006.20,172205.30,100),('1','285','101','1',630.00,710.00,0.00,0.00,0.00,0.00,0.00,101),('1','285','102','1',630.00,710.00,0.00,5954.52,3751347.60,3992568.70,241221.10,102),('1','285','103','1',630.00,710.00,0.00,0.00,0.00,0.00,0.00,103),('1','285','104','1',630.00,710.00,0.00,1518.48,956642.40,1025039.90,68397.50,104),('1','285','105','1',630.00,710.00,0.00,6742.49,4247768.70,4507676.40,259907.70,105),('1','285','106','1',630.00,710.00,0.00,4689.35,2954290.50,3143682.30,189391.80,106),('1','285','107','1',630.00,710.00,0.00,2413.33,1520397.90,1625452.10,105054.20,107),('1','285','108','1',630.00,710.00,0.00,0.00,0.00,0.00,0.00,108),('1','285','109','1',593.00,710.00,0.00,6046.44,3585538.92,4047811.20,462272.28,109),('1','285','110','1',593.00,710.00,0.00,2631.04,1560206.72,1770412.20,210205.48,110),('1','285','111','1',593.00,710.00,0.00,4040.87,2396235.91,2713504.15,317268.24,111),('1','285','112','1',593.00,710.00,0.00,1810.96,1073899.28,1217926.25,144026.97,112),('1','285','113','1',593.00,710.00,0.00,4731.93,2806034.49,3182558.15,376523.66,113),('1','285','114','1',593.00,710.00,0.00,0.00,0.00,0.00,0.00,114),('1','285','115','1',593.00,710.00,0.00,62.44,37026.92,41834.80,4807.88,115),('1','285','116','1',593.00,710.00,0.00,4135.60,2452410.80,2778456.00,326045.20,116),('1','285','117','1',593.00,710.00,0.00,3147.83,1866663.19,2120311.60,253648.41,117),('1','285','118','1',593.00,710.00,0.00,2917.05,1729810.65,1962960.10,233149.45,118),('1','285','119','1',593.00,710.00,0.00,4854.56,2878754.08,3248954.95,370200.87,119),('1','285','120','1',593.00,710.00,0.00,3936.01,2334053.93,2642330.70,308276.77,120),('1','285','121','1',593.00,710.00,0.00,107.04,63474.72,71998.40,8523.68,121),('1','285','122','1',593.00,710.00,0.00,0.00,0.00,0.00,0.00,122),('1','285','123','1',593.00,710.00,0.00,3949.47,2476317.69,2648060.50,171742.81,123),('1','285','124','1',627.00,710.00,0.00,4469.55,2802407.85,3001397.00,198989.15,124),('1','285','125','1',627.00,710.00,0.00,3675.27,2304394.29,2471833.30,167439.01,125),('1','285','126','1',627.00,710.00,0.00,3957.17,2481145.59,2660358.10,179212.51,126),('1','285','127','1',627.00,710.00,0.00,2942.78,1845123.06,1974997.15,129874.09,127),('1','285','128','1',627.00,710.00,0.00,0.00,0.00,0.00,0.00,128),('1','285','129','1',593.00,710.00,0.00,4161.11,2467538.23,2789442.35,321904.12,129),('1','285','130','1',593.00,710.00,0.00,4381.79,2598401.47,2937010.30,338608.83,130),('1','285','131','1',593.00,710.00,0.00,2015.90,1195428.70,1357044.40,161615.70,131),('1','285','132','1',593.00,710.00,0.00,3581.94,2124090.42,2408130.20,284039.78,132),('1','285','133','1',593.00,710.00,0.00,2704.91,1604011.63,1820280.15,216268.52,133),('1','285','134','1',593.00,710.00,0.00,2161.57,1281811.01,1456097.00,174285.99,134),('1','285','135','1',593.00,710.00,0.00,0.00,0.00,0.00,0.00,135),('1','285','136','1',593.00,710.00,0.00,4216.35,2500295.55,2833735.40,333439.85,136),('1','285','137','1',593.00,710.00,0.00,3916.45,2322454.85,2629498.05,307043.20,137),('1','285','138','1',593.00,710.00,0.00,4189.96,2484646.28,2811446.65,326800.37,138),('1','285','139','1',593.00,710.00,0.00,1762.03,1044883.79,1189833.85,144950.06,139),('1','285','140','1',593.00,710.00,0.00,3940.91,2336959.63,2648427.30,311467.67,140),('1','285','141','1',593.00,710.00,0.00,1125.21,667249.53,754875.95,87626.42,141),('1','285','142','1',593.00,710.00,0.00,0.00,0.00,0.00,0.00,142),('1','285','143','1',593.00,710.00,0.00,2340.27,1387780.11,1568954.35,181174.24,143),('1','285','144','1',593.00,710.00,0.00,2551.35,1512950.55,1713598.45,200647.90,144),('1','285','145','1',593.00,710.00,0.00,1999.81,1185887.33,1347536.70,161649.37,145),('1','285','146','1',593.00,710.00,0.00,2672.13,1584573.09,1795507.80,210934.71,146),('1','285','147','1',593.00,710.00,0.00,3899.32,2312296.76,2612468.45,300171.69,147),('1','285','148','1',593.00,710.00,0.00,2104.45,1247938.85,1416396.10,168457.25,148),('1','285','149','1',593.00,710.00,0.00,2882.40,1709263.20,1939260.80,229997.60,149),('1','285','150','1',593.00,710.00,0.00,555.87,329630.91,373188.05,43557.14,150),('1','285','151','1',593.00,710.00,0.00,0.00,0.00,0.00,0.00,151),('1','285','152','1',593.00,710.00,0.00,3289.15,1950465.95,2208055.55,257589.60,152),('1','285','153','1',593.00,710.00,0.00,3104.26,1840826.18,2084064.65,243238.47,153),('1','285','154','1',593.00,710.00,0.00,3786.59,2245447.87,2544964.35,299516.48,154),('1','285','155','1',593.00,710.00,0.00,3272.02,1940307.86,2206658.70,266350.84,155),('1','285','156','1',593.00,710.00,0.00,3287.93,1949742.49,2206320.90,256578.41,156),('1','285','157','1',593.00,710.00,0.00,0.00,0.00,0.00,0.00,157),('1','285','158','1',593.00,710.00,0.00,4377.88,2596082.84,2939199.30,343116.46,158),('1','285','159','1',593.00,710.00,0.00,3449.73,2045689.89,2320110.45,274420.56,159),('1','285','160','1',593.00,710.00,0.00,1761.49,1044563.57,1190511.10,145947.53,160),('1','285','161','1',593.00,710.00,0.00,2874.09,1704335.37,1938286.50,233951.13,161),('1','285','162','1',593.00,710.00,0.00,2588.89,1535211.77,1747094.40,211882.63,162),('1','285','163','1',593.00,710.00,0.00,0.00,0.00,0.00,0.00,163),('1','285','164','1',593.00,710.00,0.00,1838.05,1089963.65,1236859.90,146896.25,164),('1','285','165','1',593.00,710.00,0.00,4264.47,2528830.71,2864301.55,335470.84,165),('1','285','166','1',593.00,710.00,0.00,4023.59,2385988.87,2705887.75,319898.88,166),('1','285','167','1',593.00,710.00,0.00,2599.36,1541420.48,1749976.55,208556.07,167),('1','285','168','1',593.00,710.00,0.00,3393.92,2012594.56,2289809.30,277214.74,168),('1','285','169','1',593.00,710.00,0.00,2681.25,1589981.25,1799236.40,209255.15,169),('1','285','170','1',593.00,710.00,0.00,0.00,0.00,0.00,0.00,170),('1','285','171','1',593.00,710.00,0.00,4780.65,2834925.45,3222463.65,387538.20,171),('1','285','172','1',593.00,710.00,0.00,1487.95,882354.35,1005650.90,123296.55,172),('1','285','173','1',593.00,710.00,0.00,2989.88,1772998.84,2014524.95,241526.11,173),('1','285','174','1',593.00,710.00,0.00,4080.79,2419908.47,2738418.55,318510.08,174),('1','285','175','1',593.00,710.00,0.00,1145.91,679524.63,769409.45,89884.82,175),('1','285','176','1',593.00,710.00,0.00,0.00,0.00,0.00,0.00,176),('1','285','177','1',593.00,710.00,0.00,2724.77,1615788.61,1827368.30,211579.69,177),('1','285','178','1',593.00,710.00,0.00,3156.77,1871964.61,2130865.90,258901.29,178),('1','285','179','1',593.00,710.00,0.00,3493.53,2071663.29,2357336.90,285673.61,179),('1','285','180','1',593.00,710.00,0.00,7225.21,4284549.53,4845262.75,560713.22,180);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',1,'285','LPG PRODUCT TANK','Tank Containig LPG Product.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','285','1',1,1,'1','LPG TANK ',25000.00,0.00,NULL,'LPG PRODUCT TANK.','479','2022-10-15 17:11:24','2022-10-15 17:11:24','479',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','285',1,2909.72,'2023-03-20 19:18:15');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=16847 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'1','285',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,15375000.00,25000.00,0.00,0.00,'2022-10-15 19:17:26','',''),(2,'1','285',NULL,1,'Reception corrector for bridging 1',0.00,0.00,0.00,25000.00,0.00,'2022-10-15 19:21:10','',''),(3,'1','285','1',1,'Received from bridging 1',0.00,0.00,25000.00,0.00,0.00,'2022-10-15 19:21:10','',''),(4,'1','285','1',1,'Retail Sale Id 1',720.00,0.00,0.00,1.00,105.00,'2022-10-17 13:52:14','',''),(5,'1','285','1',1,'Retail Sale Id 2',9000.00,0.00,0.00,12.50,1312.50,'2022-10-17 14:30:59','',''),(6,'1','285','1',1,'Retail Sale Id 3',1000.80,0.00,0.00,1.39,145.95,'2022-10-17 14:34:40','',''),(7,'1','285','1',1,'Return of Retail Sale Id 1',0.00,720.00,1.00,0.00,-105.00,'2022-10-17 14:36:07','',''),(8,'1','285','1',1,'Retail Sale Id 4',3700.80,0.00,0.00,5.14,539.70,'2022-10-17 14:37:22','',''),(9,'1','285','1',1,'Retail Sale Id 5',1800.00,0.00,0.00,2.50,262.50,'2022-10-17 14:39:41','',''),(10,'1','285','1',1,'Retail Sale Id 6',34279.20,0.00,0.00,47.61,4999.05,'2022-10-17 14:44:35','',''),(11,'1','285','1',1,'Retail Sale Id 7',3499.20,0.00,0.00,4.86,510.30,'2022-10-17 14:47:07','',''),(12,'1','285','1',1,'Retail Sale Id 9',720.00,0.00,0.00,1.00,105.00,'2022-10-17 14:54:37','',''),(13,'1','285','1',1,'Retail Sale Id 10',799.20,0.00,0.00,1.11,116.55,'2022-10-17 15:29:17','',''),(14,'1','285','1',1,'Retail Sale Id 11',799.20,0.00,0.00,1.11,116.55,'2022-10-17 15:32:45','',''),(15,'1','285','1',1,'Retail Sale Id 14',2203.20,0.00,0.00,3.06,321.30,'2022-10-17 15:51:59','',''),(16,'1','285','1',1,'Retail Sale Id 15',3499.20,0.00,0.00,4.86,510.30,'2022-10-17 16:01:23','',''),(17,'1','285','1',1,'Retail Sale Id 16',2203.20,0.00,0.00,3.06,321.30,'2022-10-17 16:23:22','',''),(18,'1','285','1',1,'Retail Sale Id 17',748.80,0.00,0.00,1.04,109.20,'2022-10-17 16:33:37','',''),(19,'1','285','1',1,'Retail Sale Id 21',2901.60,0.00,0.00,4.03,423.15,'2022-10-17 16:46:08','',''),(20,'1','285','1',1,'Retail Sale Id 23',3002.40,0.00,0.00,4.17,437.85,'2022-10-17 16:56:02','',''),(21,'1','285','1',1,'Retail Sale Id 24',7200.00,0.00,0.00,10.00,1050.00,'2022-10-17 17:15:10','',''),(22,'1','285','1',1,'Retail Sale Id 25',4996.80,0.00,0.00,6.94,728.70,'2022-10-17 17:15:54','',''),(23,'1','285','1',1,'Retail Sale Id 27',2901.60,0.00,0.00,4.03,423.15,'2022-10-17 17:21:05','',''),(24,'1','285','1',1,'Retail Sale Id 28',1000.80,0.00,0.00,1.39,145.95,'2022-10-17 17:26:29','',''),(25,'1','285','1',1,'Retail Sale Id 29',3268.80,0.00,0.00,4.54,476.70,'2022-10-17 17:52:11','',''),(26,'1','285','1',1,'Return of Retail Sale Id 29',0.00,3268.80,4.54,0.00,-476.70,'2022-10-17 20:37:13','',''),(27,'1','285','1',1,'Retail Sale Id 31',4348.80,0.00,0.00,6.04,634.20,'2022-10-18 07:53:23','',''),(28,'1','285','1',1,'Retail Sale Id 33',41829.75,0.00,0.00,61.97,3718.20,'2022-10-18 09:51:57','',''),(29,'1','285','1',1,'Retail Sale Id 34',273246.75,0.00,0.00,404.81,24288.60,'2022-10-18 09:53:31','',''),(30,'1','285','1',1,'Retail Sale Id 35',14817.60,0.00,0.00,20.58,2160.90,'2022-10-18 09:56:27','',''),(31,'1','285','1',1,'Retail Sale Id 36',2203.20,0.00,0.00,3.06,321.30,'2022-10-18 10:51:32','',''),(32,'1','285','1',1,'Retail Sale Id 37',12189.60,0.00,0.00,16.93,1777.65,'2022-10-18 18:23:17','',''),(33,'1','285','1',1,'Retail Sale Id 38',6544.80,0.00,0.00,9.09,954.45,'2022-10-18 18:23:55','',''),(34,'1','285','1',1,'Retail Sale Id 39',4435.20,0.00,0.00,6.16,646.80,'2022-10-18 18:24:33','',''),(35,'1','285','1',1,'Retail Sale Id 40',9000.00,0.00,0.00,12.50,1312.50,'2022-10-18 18:25:12','',''),(36,'1','285','1',1,'Retail Sale Id 41',8589.60,0.00,0.00,11.93,1252.65,'2022-10-18 18:25:49','',''),(37,'1','285','1',1,'Retail Sale Id 42',9259.20,0.00,0.00,12.86,1350.30,'2022-10-18 18:26:23','',''),(38,'1','285','1',1,'Retail Sale Id 43',10800.00,0.00,0.00,15.00,1575.00,'2022-10-18 18:27:13','',''),(39,'1','285','1',1,'Retail Sale Id 44',14565.60,0.00,0.00,20.23,2124.15,'2022-10-18 18:28:07','',''),(40,'1','285','1',1,'Retail Sale Id 45',33750.00,0.00,0.00,50.00,3000.00,'2022-10-18 18:30:34','',''),(41,'1','285','1',1,'Return of Retail Sale Id 44',0.00,14565.60,20.23,0.00,-2124.15,'2022-10-18 18:35:48','',''),(42,'1','285','1',1,'Retail Sale Id 46',11736.00,0.00,0.00,16.30,1711.50,'2022-10-18 18:37:39','',''),(43,'1','285','1',1,'Retail Sale Id 47',41809.50,0.00,0.00,61.94,3716.40,'2022-10-19 08:35:34','',''),(44,'1','285','1',1,'Retail Sale Id 48',7956.00,0.00,0.00,11.05,1160.25,'2022-10-19 08:44:46','',''),(45,'1','285','1',1,'Retail Sale Id 49',7394.40,0.00,0.00,10.27,1078.35,'2022-10-19 08:46:26','',''),(46,'1','285','1',1,'Retail Sale Id 50',2001.60,0.00,0.00,2.78,291.90,'2022-10-19 08:49:01','',''),(47,'1','285','1',1,'Retail Sale Id 51',5760.00,0.00,0.00,8.00,840.00,'2022-10-19 08:52:37','',''),(48,'1','285','1',1,'Retail Sale Id 52',9000.00,0.00,0.00,12.50,1312.50,'2022-10-19 08:55:18','',''),(49,'1','285','1',1,'Retail Sale Id 57',6595.20,0.00,0.00,9.16,961.80,'2022-10-19 13:05:40','',''),(50,'1','285','1',1,'Retail Sale Id 59',5191.20,0.00,0.00,7.21,757.05,'2022-10-19 13:06:56','',''),(51,'1','285','1',1,'Retail Sale Id 60',5220.00,0.00,0.00,7.25,761.25,'2022-10-19 13:08:00','',''),(52,'1','285','1',1,'Retail Sale Id 61',6631.20,0.00,0.00,9.21,967.05,'2022-10-19 13:12:27','',''),(53,'1','285','1',1,'Retail Sale Id 62',2160.00,0.00,0.00,3.00,315.00,'2022-10-19 13:13:46','',''),(54,'1','285','1',1,'Retail Sale Id 63',1440.00,0.00,0.00,2.00,210.00,'2022-10-19 13:14:48','',''),(55,'1','285','1',1,'Retail Sale Id 64',1202.40,0.00,0.00,1.67,175.35,'2022-10-19 13:55:23','',''),(56,'1','285','1',1,'Retail Sale Id 65',3600.00,0.00,0.00,5.00,525.00,'2022-10-19 14:16:15','',''),(57,'1','285','1',1,'Retail Sale Id 66',1497.60,0.00,0.00,2.08,218.40,'2022-10-19 14:45:24','',''),(58,'1','285','1',1,'Retail Sale Id 67',1497.60,0.00,0.00,2.08,218.40,'2022-10-19 14:47:44','',''),(59,'1','285','1',1,'Retail Sale Id 68',10080.00,0.00,0.00,14.00,1470.00,'2022-10-19 15:02:37','',''),(60,'1','285','1',1,'Retail Sale Id 69',9000.00,0.00,0.00,12.50,1312.50,'2022-10-19 15:06:56','',''),(61,'1','285','1',1,'Retail Sale Id 70',2001.60,0.00,0.00,2.78,291.90,'2022-10-19 15:20:59','',''),(62,'1','285','1',1,'Retail Sale Id 71',799.20,0.00,0.00,1.11,116.55,'2022-10-19 15:32:25','',''),(63,'1','285','1',1,'Retail Sale Id 72',4320.00,0.00,0.00,6.00,630.00,'2022-10-19 15:42:32','',''),(64,'1','285','1',1,'Retail Sale Id 73',1497.60,0.00,0.00,2.08,218.40,'2022-10-19 16:32:12','',''),(65,'1','285','1',1,'Retail Sale Id 74',1497.60,0.00,0.00,2.08,218.40,'2022-10-19 16:34:13','',''),(66,'1','285','1',1,'Retail Sale Id 75',2203.20,0.00,0.00,3.06,321.30,'2022-10-19 16:50:47','',''),(67,'1','285','1',1,'Return of Retail Sale Id 74',0.00,1497.60,2.08,0.00,-218.40,'2022-10-19 17:06:13','',''),(68,'1','285','1',1,'Retail Sale Id 76',1627.20,0.00,0.00,2.26,237.30,'2022-10-19 17:07:12','',''),(69,'1','285','1',1,'Retail Sale Id 77',168750.00,0.00,0.00,250.00,15000.00,'2022-10-20 07:11:14','',''),(70,'1','285','1',1,'Return of Retail Sale Id 77',0.00,168750.00,250.00,0.00,-15000.00,'2022-10-20 07:14:42','',''),(71,'1','285','1',1,'Retail Sale Id 78',168750.00,0.00,0.00,250.00,15000.00,'2022-10-20 07:15:25','',''),(72,'1','285','1',1,'Retail Sale Id 79',27000.00,0.00,0.00,40.00,2400.00,'2022-10-20 07:16:35','',''),(73,'1','285','1',1,'Retail Sale Id 80',2001.60,0.00,0.00,2.78,291.90,'2022-10-20 07:17:33','',''),(74,'1','285','1',1,'Retail Sale Id 81',40500.00,0.00,0.00,60.00,3600.00,'2022-10-20 07:21:04','',''),(75,'1','285','1',1,'Retail Sale Id 82',2203.20,0.00,0.00,3.06,321.30,'2022-10-20 07:27:33','',''),(76,'1','285','1',1,'Retail Sale Id 83',41829.75,0.00,0.00,61.97,3718.20,'2022-10-20 07:31:17','',''),(77,'1','285','1',1,'Retail Sale Id 84',799.20,0.00,0.00,1.11,116.55,'2022-10-20 07:46:34','',''),(78,'1','285','1',1,'Retail Sale Id 85',1497.60,0.00,0.00,2.08,218.40,'2022-10-20 07:58:30','',''),(79,'1','285','1',1,'Retail Sale Id 86',1497.60,0.00,0.00,2.08,218.40,'2022-10-20 08:31:30','',''),(80,'1','285','1',1,'Retail Sale Id 88',799.20,0.00,0.00,1.11,116.55,'2022-10-20 08:32:59','',''),(81,'1','285','1',1,'Retail Sale Id 89',2203.20,0.00,0.00,3.06,321.30,'2022-10-20 08:35:49','',''),(82,'1','285','1',1,'Retail Sale Id 90',3643.20,0.00,0.00,5.06,531.30,'2022-10-20 10:32:15','',''),(83,'1','285','1',1,'Retail Sale Id 91',8200.80,0.00,0.00,11.39,1195.95,'2022-10-20 10:33:57','',''),(84,'1','285','1',1,'Retail Sale Id 92',41397.75,0.00,0.00,61.33,3679.80,'2022-10-20 10:35:50','',''),(85,'1','285','1',1,'Retail Sale Id 93',41269.50,0.00,0.00,61.14,3668.40,'2022-10-20 10:36:45','',''),(86,'1','285','1',1,'Retail Sale Id 94',41492.25,0.00,0.00,61.47,3688.20,'2022-10-20 10:38:05','',''),(87,'1','285','1',1,'Retail Sale Id 95',41688.00,0.00,0.00,61.76,3705.60,'2022-10-20 10:39:19','',''),(88,'1','285','1',1,'Retail Sale Id 96',1000.80,0.00,0.00,1.39,145.95,'2022-10-20 10:40:29','',''),(89,'1','285','1',1,'Retail Sale Id 97',60621.75,0.00,0.00,89.81,5388.60,'2022-10-20 10:42:27','',''),(90,'1','285','1',1,'Retail Sale Id 98',40500.00,0.00,0.00,60.00,3600.00,'2022-10-20 10:43:43','',''),(91,'1','285','1',1,'Retail Sale Id 99',10084.50,0.00,0.00,14.94,896.40,'2022-10-20 10:44:51','',''),(92,'1','285','1',1,'Retail Sale Id 101',4320.00,0.00,0.00,6.00,630.00,'2022-10-20 11:08:12','',''),(93,'1','285','1',1,'Retail Sale Id 102',2880.00,0.00,0.00,4.00,420.00,'2022-10-20 11:08:59','',''),(94,'1','285','1',1,'Retail Sale Id 103',4500.00,0.00,0.00,6.25,656.25,'2022-10-20 11:21:17','',''),(95,'1','285','1',1,'Retail Sale Id 104',33750.00,0.00,0.00,50.00,3000.00,'2022-10-20 11:26:12','',''),(96,'1','285','1',1,'Retail Sale Id 105',5760.00,0.00,0.00,8.00,840.00,'2022-10-20 11:36:06','',''),(97,'1','285','1',1,'Retail Sale Id 106',1497.60,0.00,0.00,2.08,218.40,'2022-10-20 11:46:43','',''),(98,'1','285','1',1,'Retail Sale Id 107',7200.00,0.00,0.00,10.00,1050.00,'2022-10-20 11:52:11','',''),(99,'1','285','1',1,'Retail Sale Id 108',9000.00,0.00,0.00,12.50,1312.50,'2022-10-20 12:04:56','',''),(100,'1','285','1',1,'Retail Sale Id 109',1000.80,0.00,0.00,1.39,145.95,'2022-10-20 12:22:09','',''),(101,'1','285','1',1,'Retail Sale Id 110',6750.00,0.00,0.00,10.00,600.00,'2022-10-20 12:45:03','',''),(102,'1','285','1',1,'Return of Retail Sale Id 110',0.00,6750.00,10.00,0.00,-600.00,'2022-10-20 12:46:36','',''),(103,'1','285','1',1,'Retail Sale Id 111',15187.50,0.00,0.00,22.50,1350.00,'2022-10-20 12:47:15','',''),(104,'1','285','1',1,'Return of Retail Sale Id 108',0.00,9000.00,12.50,0.00,-1312.50,'2022-10-20 12:47:53','',''),(105,'1','285','1',1,'Retail Sale Id 112',53001.00,0.00,0.00,78.52,4711.20,'2022-10-20 12:59:16','',''),(106,'1','285','1',1,'Retail Sale Id 113',41958.00,0.00,0.00,62.16,3729.60,'2022-10-20 13:00:33','',''),(107,'1','285','1',1,'Retail Sale Id 114',16814.25,0.00,0.00,24.91,1494.60,'2022-10-20 13:01:41','',''),(108,'1','285','1',1,'Retail Sale Id 115',40500.00,0.00,0.00,60.00,3600.00,'2022-10-20 13:34:51','',''),(109,'1','285','1',1,'Retail Sale Id 116',27000.00,0.00,0.00,40.00,2400.00,'2022-10-20 13:43:54','',''),(110,'1','285','1',1,'Retail Sale Id 117',41242.50,0.00,0.00,61.10,3666.00,'2022-10-20 13:46:50','',''),(111,'1','285','1',1,'Retail Sale Id 118',1440.00,0.00,0.00,2.00,210.00,'2022-10-20 13:56:53','',''),(112,'1','285','1',1,'Retail Sale Id 119',12237.75,0.00,0.00,18.13,1087.80,'2022-10-20 14:11:13','',''),(113,'1','285','1',1,'Retail Sale Id 120',1440.00,0.00,0.00,2.00,210.00,'2022-10-20 14:45:45','',''),(114,'1','285','1',1,'Retail Sale Id 121',13680.00,0.00,0.00,19.00,1995.00,'2022-10-20 14:50:29','',''),(115,'1','285','1',1,'Retail Sale Id 122',748.80,0.00,0.00,1.04,109.20,'2022-10-20 14:57:34','',''),(116,'1','285','1',1,'Retail Sale Id 123',16962.75,0.00,0.00,25.13,1507.80,'2022-10-20 15:08:47','',''),(117,'1','285','1',1,'Retail Sale Id 124',2498.40,0.00,0.00,3.47,364.35,'2022-10-20 15:19:05','',''),(118,'1','285','1',1,'Retail Sale Id 127',1000.80,0.00,0.00,1.39,145.95,'2022-10-20 15:24:34','',''),(119,'1','285','1',1,'Retail Sale Id 128',2001.60,0.00,0.00,2.78,291.90,'2022-10-20 15:27:02','',''),(120,'1','285','1',1,'Retail Sale Id 129',3002.40,0.00,0.00,4.17,437.85,'2022-10-20 15:44:35','',''),(121,'1','285','1',1,'Retail Sale Id 130',799.20,0.00,0.00,1.11,116.55,'2022-10-20 15:46:10','',''),(122,'1','285','1',1,'Retail Sale Id 131',1497.60,0.00,0.00,2.08,218.40,'2022-10-20 15:48:54','',''),(123,'1','285','1',1,'Retail Sale Id 132',9360.00,0.00,0.00,13.00,1365.00,'2022-10-20 15:56:59','',''),(124,'1','285','1',1,'Retail Sale Id 133',1440.00,0.00,0.00,2.00,210.00,'2022-10-20 15:58:58','',''),(125,'1','285','1',1,'Retail Sale Id 134',1440.00,0.00,0.00,2.00,210.00,'2022-10-20 16:00:43','',''),(126,'1','285','1',1,'Retail Sale Id 136',10000.80,0.00,0.00,13.89,1458.45,'2022-10-20 16:09:23','',''),(127,'1','285','1',1,'Return of Retail Sale Id 132',0.00,9360.00,13.00,0.00,-1365.00,'2022-10-20 16:10:35','',''),(128,'1','285','1',1,'Retail Sale Id 137',8775.00,0.00,0.00,13.00,780.00,'2022-10-20 16:11:19','',''),(129,'1','285','1',1,'Retail Sale Id 138',1000.80,0.00,0.00,1.39,145.95,'2022-10-20 16:26:37','',''),(130,'1','285','1',1,'Return of Retail Sale Id 107',0.00,7200.00,10.00,0.00,-1050.00,'2022-10-20 16:45:27','',''),(131,'1','285','1',1,'Retail Sale Id 139',39150.00,0.00,0.00,58.00,3480.00,'2022-10-21 07:14:07','',''),(132,'1','285','1',1,'Retail Sale Id 140',41904.00,0.00,0.00,62.08,3724.80,'2022-10-21 07:16:03','',''),(133,'1','285','1',1,'Retail Sale Id 142',1893.60,0.00,0.00,2.63,276.15,'2022-10-21 07:23:15','',''),(134,'1','285','1',1,'Retail Sale Id 143',748.80,0.00,0.00,1.04,109.20,'2022-10-21 07:25:25','',''),(135,'1','285','1',1,'Retail Sale Id 144',7200.00,0.00,0.00,10.00,1050.00,'2022-10-21 07:27:08','',''),(136,'1','285','1',1,'Retail Sale Id 145',720.00,0.00,0.00,1.00,105.00,'2022-10-21 07:32:18','',''),(137,'1','285','1',1,'Retail Sale Id 146',1447.20,0.00,0.00,2.01,211.05,'2022-10-21 07:46:24','',''),(138,'1','285','1',1,'Retail Sale Id 147',2800.80,0.00,0.00,3.89,408.45,'2022-10-21 07:48:08','',''),(139,'1','285','1',1,'Retail Sale Id 148',1497.60,0.00,0.00,2.08,218.40,'2022-10-21 07:49:27','',''),(140,'1','285','1',1,'Retail Sale Id 149',799.20,0.00,0.00,1.11,116.55,'2022-10-21 08:09:26','',''),(141,'1','285','1',1,'Retail Sale Id 150',41620.50,0.00,0.00,61.66,3699.60,'2022-10-21 08:14:58','',''),(142,'1','285','1',1,'Retail Sale Id 151',1440.00,0.00,0.00,2.00,210.00,'2022-10-21 08:26:35','',''),(143,'1','285','1',1,'Retail Sale Id 152',7200.00,0.00,0.00,10.00,1050.00,'2022-10-21 08:33:09','',''),(144,'1','285','1',1,'Retail Sale Id 153',2001.60,0.00,0.00,2.78,291.90,'2022-10-21 08:43:00','',''),(145,'1','285','1',1,'Retail Sale Id 154',43402.50,0.00,0.00,64.30,3858.00,'2022-10-21 09:03:03','',''),(146,'1','285','1',1,'Retail Sale Id 155',33750.00,0.00,0.00,50.00,3000.00,'2022-10-21 09:03:46','',''),(147,'1','285','1',1,'Retail Sale Id 156',5997.60,0.00,0.00,8.33,874.65,'2022-10-21 09:08:16','',''),(148,'1','285','1',1,'Retail Sale Id 157',1440.00,0.00,0.00,2.00,210.00,'2022-10-21 09:23:31','',''),(149,'1','285','1',1,'Retail Sale Id 158',720.00,0.00,0.00,1.00,105.00,'2022-10-21 09:33:23','',''),(150,'1','285','1',1,'Retail Sale Id 160',2800.80,0.00,0.00,3.89,408.45,'2022-10-21 10:15:15','',''),(151,'1','285','1',1,'Retail Sale Id 161',37125.00,0.00,0.00,55.00,3300.00,'2022-10-21 11:10:41','',''),(152,'1','285','1',1,'Retail Sale Id 162',38475.00,0.00,0.00,57.00,3420.00,'2022-10-21 11:14:34','',''),(153,'1','285','1',1,'Retail Sale Id 163',1497.60,0.00,0.00,2.08,218.40,'2022-10-21 11:16:49','',''),(154,'1','285','1',1,'Retail Sale Id 164',2203.20,0.00,0.00,3.06,321.30,'2022-10-21 11:23:15','',''),(155,'1','285','1',1,'Retail Sale Id 165',1497.60,0.00,0.00,2.08,218.40,'2022-10-21 11:30:15','',''),(156,'1','285','1',1,'Retail Sale Id 166',1497.60,0.00,0.00,2.08,218.40,'2022-10-21 12:10:49','',''),(157,'1','285','1',1,'Retail Sale Id 167',2203.20,0.00,0.00,3.06,321.30,'2022-10-21 12:35:07','',''),(158,'1','285','1',1,'Retail Sale Id 168',1497.60,0.00,0.00,2.08,218.40,'2022-10-21 12:36:34','',''),(159,'1','285','1',1,'Retail Sale Id 169',3002.40,0.00,0.00,4.17,437.85,'2022-10-21 12:52:32','',''),(160,'1','285','1',1,'Retail Sale Id 170',41465.25,0.00,0.00,61.43,3685.80,'2022-10-21 13:28:43','',''),(161,'1','285','1',1,'Retail Sale Id 171',1000.80,0.00,0.00,1.39,145.95,'2022-10-21 13:41:34','',''),(162,'1','285','1',1,'Retail Sale Id 172',33750.00,0.00,0.00,50.00,3000.00,'2022-10-21 15:26:31','',''),(163,'1','285','1',1,'Retail Sale Id 173',4320.00,0.00,0.00,6.00,630.00,'2022-10-21 15:29:43','',''),(164,'1','285','1',1,'Retail Sale Id 174',3744.00,0.00,0.00,5.20,546.00,'2022-10-21 15:31:59','',''),(165,'1','285','1',1,'Retail Sale Id 175',2203.20,0.00,0.00,3.06,321.30,'2022-10-21 15:33:02','',''),(166,'1','285','1',1,'Retail Sale Id 176',720.00,0.00,0.00,1.00,105.00,'2022-10-21 15:33:43','',''),(167,'1','285','1',1,'Retail Sale Id 177',5097.60,0.00,0.00,7.08,743.40,'2022-10-21 15:46:25','',''),(168,'1','285','1',1,'Retail Sale Id 178',41559.75,0.00,0.00,61.57,3694.20,'2022-10-21 15:51:35','',''),(169,'1','285','1',1,'Retail Sale Id 180',4492.80,0.00,0.00,6.24,655.20,'2022-10-21 16:15:08','',''),(170,'1','285','1',1,'Retail Sale Id 181',1720.80,0.00,0.00,2.39,250.95,'2022-10-21 16:40:47','',''),(171,'1','285','1',1,'Retail Sale Id 182',12359.25,0.00,0.00,18.31,1098.60,'2022-10-21 16:44:09','',''),(172,'1','285','1',1,'Retail Sale Id 183',2059.20,0.00,0.00,2.86,300.30,'2022-10-21 16:57:49','',''),(173,'1','285','1',1,'Retail Sale Id 184',4320.00,0.00,0.00,6.00,630.00,'2022-10-21 17:05:13','',''),(174,'1','285','1',1,'Retail Sale Id 186',1497.60,0.00,0.00,2.08,218.40,'2022-10-21 17:11:02','',''),(175,'1','285','1',1,'Retail Sale Id 187',1497.60,0.00,0.00,2.08,218.40,'2022-10-21 17:48:50','',''),(176,'1','285','1',1,'Retail Sale Id 188',7207.20,0.00,0.00,10.01,1051.05,'2022-10-21 17:51:27','',''),(177,'1','285','1',1,'Retail Sale Id 189',1497.60,0.00,0.00,2.08,218.40,'2022-10-21 17:58:06','',''),(178,'1','285','1',1,'Retail Sale Id 190',402000.00,0.00,0.00,600.00,33000.00,'2022-10-21 18:01:59','',''),(179,'1','285','1',1,'Retail Sale Id 191',14600.25,0.00,0.00,21.63,1297.80,'2022-10-21 18:10:06','',''),(180,'1','285','1',1,'Retail Sale Id 192',777.60,0.00,0.00,1.08,113.40,'2022-10-21 19:21:56','',''),(181,'1','285','1',1,'Return of Retail Sale Id 191',0.00,14600.25,21.63,0.00,-1297.80,'2022-10-21 19:31:05','',''),(182,'1','285','1',1,'Retail Sale Id 193',14600.25,0.00,0.00,21.63,1297.80,'2022-10-21 19:35:41','',''),(183,'1','285','1',1,'Return of Retail Sale Id 193',0.00,14600.25,21.63,0.00,-1297.80,'2022-10-21 19:38:47','',''),(184,'1','285','1',1,'Retail Sale Id 194',13938.75,0.00,0.00,20.65,1239.00,'2022-10-21 19:40:09','',''),(185,'1','285','1',1,'Retail Sale Id 195',41748.75,0.00,0.00,61.85,3711.00,'2022-10-22 07:39:54','',''),(186,'1','285','1',1,'Retail Sale Id 196',41384.25,0.00,0.00,61.31,3678.60,'2022-10-22 07:41:34','',''),(187,'1','285','1',1,'Retail Sale Id 197',8676.00,0.00,0.00,12.05,1265.25,'2022-10-22 07:42:33','',''),(188,'1','285','1',1,'Retail Sale Id 198',2203.20,0.00,0.00,3.06,321.30,'2022-10-22 07:45:09','',''),(189,'1','285','1',1,'Retail Sale Id 199',1000.80,0.00,0.00,1.39,145.95,'2022-10-22 07:48:56','',''),(190,'1','285','1',1,'Retail Sale Id 200',168750.00,0.00,0.00,250.00,15000.00,'2022-10-22 07:58:28','',''),(191,'1','285','1',1,'Retail Sale Id 201',5500.80,0.00,0.00,7.64,802.20,'2022-10-22 08:00:12','',''),(192,'1','285','1',1,'Retail Sale Id 202',45839.25,0.00,0.00,67.91,4074.60,'2022-10-22 08:10:28','',''),(193,'1','285','1',1,'Retail Sale Id 203',42147.00,0.00,0.00,62.44,3746.40,'2022-10-22 08:12:49','',''),(194,'1','285','1',1,'Retail Sale Id 204',41769.00,0.00,0.00,61.88,3712.80,'2022-10-22 08:21:41','',''),(195,'1','285','1',1,'Retail Sale Id 205',900.00,0.00,0.00,1.25,131.25,'2022-10-22 08:56:46','',''),(196,'1','285','1',1,'Retail Sale Id 206',3002.40,0.00,0.00,4.17,437.85,'2022-10-22 09:13:00','',''),(197,'1','285','1',1,'Retail Sale Id 207',51273.60,0.00,0.00,76.30,4349.10,'2022-10-22 09:31:39','',''),(198,'1','285','1',1,'Retail Sale Id 208',5040.00,0.00,0.00,7.00,735.00,'2022-10-22 09:37:46','',''),(199,'1','285','1',1,'Retail Sale Id 209',44455.50,0.00,0.00,65.86,3951.60,'2022-10-22 09:56:52','',''),(200,'1','285','1',1,'Retail Sale Id 211',44219.25,0.00,0.00,65.51,3930.60,'2022-10-22 09:58:17','',''),(201,'1','285','1',1,'Retail Sale Id 212',41141.25,0.00,0.00,60.95,3657.00,'2022-10-22 10:00:08','',''),(202,'1','285','1',1,'Retail Sale Id 213',2160.00,0.00,0.00,3.00,315.00,'2022-10-22 10:10:30','',''),(203,'1','285','1',1,'Retail Sale Id 214',2203.20,0.00,0.00,3.06,321.30,'2022-10-22 10:15:14','',''),(204,'1','285','1',1,'Retail Sale Id 215',47250.00,0.00,0.00,70.00,4200.00,'2022-10-22 10:30:59','',''),(205,'1','285','1',1,'Retail Sale Id 216',16659.00,0.00,0.00,24.68,1480.80,'2022-10-22 10:32:30','',''),(206,'1','285','1',1,'Retail Sale Id 218',44327.25,0.00,0.00,65.67,3940.20,'2022-10-22 10:33:44','',''),(207,'1','285','1',1,'Retail Sale Id 219',42153.75,0.00,0.00,62.45,3747.00,'2022-10-22 11:00:54','',''),(208,'1','285','1',1,'Retail Sale Id 220',23625.00,0.00,0.00,35.00,2100.00,'2022-10-22 11:10:04','',''),(209,'1','285','1',1,'Retail Sale Id 221',1000.80,0.00,0.00,1.39,145.95,'2022-10-22 11:30:47','',''),(210,'1','285','1',1,'Retail Sale Id 222',107277.75,0.00,0.00,158.93,9535.80,'2022-10-22 11:37:47','',''),(211,'1','285','1',1,'Retail Sale Id 223',422100.00,0.00,0.00,630.00,34650.00,'2022-10-22 11:42:44','',''),(212,'1','285','1',1,'Retail Sale Id 224',2001.60,0.00,0.00,2.78,291.90,'2022-10-22 11:44:48','',''),(213,'1','285','1',1,'Retail Sale Id 225',1497.60,0.00,0.00,2.08,218.40,'2022-10-22 11:51:34','',''),(214,'1','285','1',1,'Retail Sale Id 226',13439.25,0.00,0.00,19.91,1194.60,'2022-10-22 12:11:28','',''),(215,'1','285','1',1,'Retail Sale Id 227',108243.00,0.00,0.00,160.36,9621.60,'2022-10-22 12:25:51','',''),(216,'1','285','1',1,'Retail Sale Id 228',82809.00,0.00,0.00,122.68,7360.80,'2022-10-22 12:41:11','',''),(217,'1','285','1',1,'Retail Sale Id 229',41316.75,0.00,0.00,61.21,3672.60,'2022-10-22 12:42:46','',''),(218,'1','285','1',1,'Retail Sale Id 230',3600.00,0.00,0.00,5.00,525.00,'2022-10-22 12:51:08','',''),(219,'1','285','1',1,'Retail Sale Id 231',48107.25,0.00,0.00,71.27,4276.20,'2022-10-22 13:03:57','',''),(220,'1','285','1',1,'Retail Sale Id 233',69754.50,0.00,0.00,103.34,6200.40,'2022-10-22 13:31:52','',''),(221,'1','285','1',1,'Retail Sale Id 234',41782.50,0.00,0.00,61.90,3714.00,'2022-10-22 13:41:15','',''),(222,'1','285','1',1,'Retail Sale Id 235',32737.50,0.00,0.00,48.50,2910.00,'2022-10-22 13:46:31','',''),(223,'1','285','1',1,'Retail Sale Id 236',9000.00,0.00,0.00,12.50,1312.50,'2022-10-22 13:53:02','',''),(224,'1','285','1',1,'Retail Sale Id 237',3600.00,0.00,0.00,5.00,525.00,'2022-10-22 13:56:39','',''),(225,'1','285','1',1,'Retail Sale Id 238',33750.00,0.00,0.00,50.00,3000.00,'2022-10-22 13:59:55','',''),(226,'1','285','1',1,'Retail Sale Id 240',43038.00,0.00,0.00,63.76,3825.60,'2022-10-22 14:02:36','',''),(227,'1','285','1',1,'Retail Sale Id 241',42484.50,0.00,0.00,62.94,3776.40,'2022-10-22 14:20:43','',''),(228,'1','285','1',1,'Retail Sale Id 242',41573.25,0.00,0.00,61.59,3695.40,'2022-10-22 14:22:49','',''),(229,'1','285','1',1,'Retail Sale Id 243',2203.20,0.00,0.00,3.06,321.30,'2022-10-22 14:28:09','',''),(230,'1','285','1',1,'Retail Sale Id 244',9537.75,0.00,0.00,14.13,847.80,'2022-10-22 14:36:53','',''),(231,'1','285','1',1,'Retail Sale Id 245',41877.00,0.00,0.00,62.04,3722.40,'2022-10-22 14:41:37','',''),(232,'1','285','1',1,'Retail Sale Id 246',3002.40,0.00,0.00,4.17,437.85,'2022-10-22 14:47:52','',''),(233,'1','285','1',1,'Retail Sale Id 247',2203.20,0.00,0.00,3.06,321.30,'2022-10-22 14:49:20','',''),(234,'1','285','1',1,'Retail Sale Id 248',5040.00,0.00,0.00,7.00,735.00,'2022-10-22 14:50:49','',''),(235,'1','285','1',1,'Retail Sale Id 249',86447.25,0.00,0.00,128.07,7684.20,'2022-10-22 14:56:13','',''),(236,'1','285','1',1,'Retail Sale Id 250',53203.50,0.00,0.00,78.82,4729.20,'2022-10-22 15:06:15','',''),(237,'1','285','1',1,'Retail Sale Id 251',1699.20,0.00,0.00,2.36,247.80,'2022-10-22 15:13:11','',''),(238,'1','285','1',1,'Retail Sale Id 252',1497.60,0.00,0.00,2.08,218.40,'2022-10-22 15:16:30','',''),(239,'1','285','1',1,'Retail Sale Id 253',1497.60,0.00,0.00,2.08,218.40,'2022-10-22 15:25:44','',''),(240,'1','285','1',1,'Retail Sale Id 254',720.00,0.00,0.00,1.00,105.00,'2022-10-22 15:28:13','',''),(241,'1','285','1',1,'Retail Sale Id 255',720.00,0.00,0.00,1.00,105.00,'2022-10-22 15:30:23','',''),(242,'1','285','1',1,'Retail Sale Id 256',40500.00,0.00,0.00,60.00,3600.00,'2022-10-22 15:32:26','',''),(243,'1','285','1',1,'Retail Sale Id 257',41175.00,0.00,0.00,61.00,3660.00,'2022-10-22 15:39:31','',''),(244,'1','285','1',1,'Retail Sale Id 258',2880.00,0.00,0.00,4.00,420.00,'2022-10-22 15:46:40','',''),(245,'1','285','1',1,'Retail Sale Id 259',999.00,0.00,0.00,3.70,-1276.50,'2022-10-22 15:48:39','',''),(246,'1','285','1',1,'Retail Sale Id 260',7998.75,0.00,0.00,11.85,711.00,'2022-10-22 15:49:27','',''),(247,'1','285','1',1,'Retail Sale Id 261',41661.00,0.00,0.00,61.72,3703.20,'2022-10-22 15:54:56','',''),(248,'1','285','1',1,'Retail Sale Id 262',31853.25,0.00,0.00,47.19,2831.40,'2022-10-22 15:56:09','',''),(249,'1','285','1',1,'Retail Sale Id 263',1497.60,0.00,0.00,2.08,218.40,'2022-10-22 15:57:57','',''),(250,'1','285','1',1,'Retail Sale Id 264',1000.80,0.00,0.00,1.39,145.95,'2022-10-22 16:00:17','',''),(251,'1','285','1',1,'Return of Retail Sale Id 259',0.00,999.00,3.70,0.00,1276.50,'2022-10-22 16:03:38','',''),(252,'1','285','1',1,'Return of Retail Sale Id 260',0.00,7998.75,11.85,0.00,-711.00,'2022-10-22 16:05:11','',''),(253,'1','285','1',1,'Retail Sale Id 267',7999.20,0.00,0.00,11.11,1166.55,'2022-10-22 16:05:53','',''),(254,'1','285','1',1,'Retail Sale Id 268',2203.20,0.00,0.00,3.06,321.30,'2022-10-22 16:06:47','',''),(255,'1','285','1',1,'Retail Sale Id 269',2203.20,0.00,0.00,3.06,321.30,'2022-10-22 16:07:59','',''),(256,'1','285','1',1,'Retail Sale Id 270',2203.20,0.00,0.00,3.06,321.30,'2022-10-22 16:10:04','',''),(257,'1','285','1',1,'Retail Sale Id 271',5400.00,0.00,0.00,8.00,480.00,'2022-10-22 16:10:51','',''),(258,'1','285','1',1,'Retail Sale Id 273',37125.00,0.00,0.00,55.00,3300.00,'2022-10-22 16:27:34','',''),(259,'1','285','1',1,'Retail Sale Id 274',2001.60,0.00,0.00,2.78,291.90,'2022-10-22 16:29:07','',''),(260,'1','285','1',1,'Retail Sale Id 276',7200.00,0.00,0.00,10.00,1050.00,'2022-10-22 16:30:18','',''),(261,'1','285','1',1,'Retail Sale Id 277',1440.00,0.00,0.00,2.00,210.00,'2022-10-22 16:35:16','',''),(262,'1','285','1',1,'Retail Sale Id 278',2203.20,0.00,0.00,3.06,321.30,'2022-10-22 16:43:19','',''),(263,'1','285','1',1,'Retail Sale Id 280',30456.00,0.00,0.00,45.12,2707.20,'2022-10-22 16:44:47','',''),(264,'1','285','1',1,'Retail Sale Id 281',168750.00,0.00,0.00,250.00,15000.00,'2022-10-22 16:46:16','',''),(265,'1','285','1',1,'Retail Sale Id 282',792.00,0.00,0.00,0.11,724.35,'2022-10-22 17:00:27','',''),(266,'1','285','1',1,'Retail Sale Id 283',6750.00,0.00,0.00,10.00,600.00,'2022-10-22 17:02:37','',''),(267,'1','285','1',1,'Retail Sale Id 284',19575.00,0.00,0.00,29.00,1740.00,'2022-10-22 17:09:00','',''),(268,'1','285','1',1,'Return of Retail Sale Id 282',0.00,792.00,0.11,0.00,-724.35,'2022-10-22 17:26:40','',''),(269,'1','285','1',1,'Retail Sale Id 285',799.20,0.00,0.00,1.11,116.55,'2022-10-22 17:27:23','',''),(270,'1','285','1',1,'Return of Retail Sale Id 276',0.00,7200.00,10.00,0.00,-1050.00,'2022-10-22 17:51:31','',''),(271,'1','285','1',1,'Return of Retail Sale Id 278',0.00,2203.20,3.06,0.00,-321.30,'2022-10-22 17:52:29','',''),(272,'1','285','1',1,'Retail Sale Id 286',1706.40,0.00,0.00,2.37,248.85,'2022-10-22 17:53:25','',''),(273,'1','285','1',1,'Return of Retail Sale Id 286',0.00,1706.40,2.37,0.00,-248.85,'2022-10-22 17:55:00','',''),(274,'1','285','1',1,'Retail Sale Id 287',1677.60,0.00,0.00,2.33,244.65,'2022-10-22 17:56:22','',''),(275,'1','285','1',1,'Return of Retail Sale Id 284',0.00,19575.00,29.00,0.00,-1740.00,'2022-10-22 20:03:15','',''),(276,'1','285','1',1,'Retail Sale Id 288',20385.00,0.00,0.00,30.20,1812.00,'2022-10-22 20:05:13','',''),(277,'1','285','1',1,'Retail Sale Id 289',40500.00,0.00,0.00,60.00,3600.00,'2022-10-23 07:20:05','',''),(278,'1','285','1',1,'Retail Sale Id 290',2203.20,0.00,0.00,3.06,321.30,'2022-10-23 07:24:50','',''),(279,'1','285','1',1,'Retail Sale Id 291',168750.00,0.00,0.00,250.00,15000.00,'2022-10-23 07:38:31','',''),(280,'1','285','1',1,'Retail Sale Id 292',5040.00,0.00,0.00,7.00,735.00,'2022-10-23 07:40:01','',''),(281,'1','285','1',1,'Retail Sale Id 293',720.00,0.00,0.00,1.00,105.00,'2022-10-23 07:46:13','',''),(282,'1','285','1',1,'Retail Sale Id 294',1440.00,0.00,0.00,2.00,210.00,'2022-10-23 07:48:19','',''),(283,'1','285','1',1,'Retail Sale Id 295',216796.50,0.00,0.00,321.18,19270.80,'2022-10-23 10:06:07','',''),(284,'1','285','1',1,'Retail Sale Id 296',10296.00,0.00,0.00,14.30,1501.50,'2022-10-23 10:07:34','',''),(285,'1','285','1',1,'Retail Sale Id 297',1000.80,0.00,0.00,1.39,145.95,'2022-10-23 10:09:05','',''),(286,'1','285','1',1,'Retail Sale Id 298',799.20,0.00,0.00,1.11,116.55,'2022-10-23 10:11:11','',''),(287,'1','285','1',1,'Retail Sale Id 299',799.20,0.00,0.00,1.11,116.55,'2022-10-23 10:21:04','',''),(288,'1','285','1',1,'Retail Sale Id 300',1000.80,0.00,0.00,1.39,145.95,'2022-10-23 10:35:16','',''),(289,'1','285','1',1,'Retail Sale Id 301',1440.00,0.00,0.00,2.00,210.00,'2022-10-23 10:36:01','',''),(290,'1','285','1',1,'Retail Sale Id 302',2001.60,0.00,0.00,2.78,291.90,'2022-10-23 10:56:56','',''),(291,'1','285','1',1,'Retail Sale Id 303',1497.60,0.00,0.00,2.08,218.40,'2022-10-23 11:01:40','',''),(292,'1','285','1',1,'Retail Sale Id 304',799.20,0.00,0.00,1.11,116.55,'2022-10-23 11:03:49','',''),(293,'1','285','1',1,'Retail Sale Id 305',1497.60,0.00,0.00,2.08,218.40,'2022-10-23 11:16:21','',''),(294,'1','285','1',1,'Retail Sale Id 306',5040.00,0.00,0.00,7.00,735.00,'2022-10-23 12:28:55','',''),(295,'1','285','1',1,'Retail Sale Id 307',1440.00,0.00,0.00,2.00,210.00,'2022-10-23 12:34:37','',''),(296,'1','285','1',1,'Retail Sale Id 308',1101.60,0.00,0.00,1.53,160.65,'2022-10-23 12:36:55','',''),(297,'1','285','1',1,'Retail Sale Id 310',1440.00,0.00,0.00,2.00,210.00,'2022-10-23 12:41:34','',''),(298,'1','285','1',1,'Retail Sale Id 311',1000.80,0.00,0.00,1.39,145.95,'2022-10-23 12:42:48','',''),(299,'1','285','1',1,'Retail Sale Id 312',42039.00,0.00,0.00,62.28,3736.80,'2022-10-23 13:00:37','',''),(300,'1','285','1',1,'Retail Sale Id 313',5760.00,0.00,0.00,8.00,840.00,'2022-10-23 13:08:51','',''),(301,'1','285','1',1,'Retail Sale Id 314',2203.20,0.00,0.00,3.06,321.30,'2022-10-23 13:14:09','',''),(302,'1','285','1',1,'Retail Sale Id 315',0.00,0.00,0.00,0.00,0.00,'2022-10-23 13:44:22','',''),(303,'1','285','1',1,'Retail Sale Id 316',20.50,0.00,0.00,1.00,-594.50,'2022-10-23 13:46:51','',''),(304,'1','285','1',1,'Return of Retail Sale Id 316',0.00,20.50,1.00,0.00,594.50,'2022-10-23 13:48:02','',''),(305,'1','285','1',1,'Retail Sale Id 317',2203.20,0.00,0.00,3.06,321.30,'2022-10-23 13:48:35','',''),(306,'1','285','1',1,'Return of Retail Sale Id 315',0.00,0.00,0.00,0.00,0.00,'2022-10-23 13:49:21','',''),(307,'1','285','1',1,'Retail Sale Id 318',14760.00,0.00,0.00,20.50,2152.50,'2022-10-23 13:50:26','',''),(308,'1','285','1',1,'Retail Sale Id 319',27000.00,0.00,0.00,40.00,2400.00,'2022-10-23 13:51:40','',''),(309,'1','285','1',1,'Retail Sale Id 320',3600.00,0.00,0.00,5.00,525.00,'2022-10-23 14:01:00','',''),(310,'1','285','1',1,'Retail Sale Id 321',2203.20,0.00,0.00,3.06,321.30,'2022-10-23 14:01:31','',''),(311,'1','285','1',1,'Retail Sale Id 322',41721.75,0.00,0.00,61.81,3708.60,'2022-10-23 14:03:01','',''),(312,'1','285','1',1,'Retail Sale Id 323',1497.60,0.00,0.00,2.08,218.40,'2022-10-23 14:08:33','',''),(313,'1','285','1',1,'Retail Sale Id 324',48897.00,0.00,0.00,72.44,4346.40,'2022-10-23 14:12:12','',''),(314,'1','285','1',1,'Retail Sale Id 325',3002.40,0.00,0.00,4.17,437.85,'2022-10-23 14:30:01','',''),(315,'1','285','1',1,'Retail Sale Id 326',720.00,0.00,0.00,1.00,105.00,'2022-10-23 14:30:47','',''),(316,'1','285','1',1,'Retail Sale Id 327',799.20,0.00,0.00,1.11,116.55,'2022-10-23 14:31:23','',''),(317,'1','285','1',1,'Return of Retail Sale Id 302',0.00,2001.60,2.78,0.00,-291.90,'2022-10-23 14:59:46','',''),(318,'1','285','1',1,'Return of Retail Sale Id 318',0.00,14760.00,20.50,0.00,-2152.50,'2022-10-23 15:00:36','',''),(319,'1','285','1',1,'Retail Sale Id 328',15795.00,0.00,0.00,23.40,1404.00,'2022-10-23 15:01:29','',''),(320,'1','285','1',1,'Retail Sale Id 329',1497.60,0.00,0.00,2.08,218.40,'2022-10-23 15:03:24','',''),(321,'1','285','1',1,'Retail Sale Id 330',183640.50,0.00,0.00,272.06,16323.60,'2022-10-23 15:19:14','',''),(322,'1','285','1',1,'Retail Sale Id 331',720.00,0.00,0.00,1.00,105.00,'2022-10-23 15:20:18','',''),(323,'1','285','1',1,'Retail Sale Id 332',3002.40,0.00,0.00,4.17,437.85,'2022-10-23 15:24:25','',''),(324,'1','285','1',1,'Retail Sale Id 333',1000.80,0.00,0.00,1.39,145.95,'2022-10-23 15:35:44','',''),(325,'1','285','1',1,'Retail Sale Id 334',1000.80,0.00,0.00,1.39,145.95,'2022-10-23 15:36:27','',''),(326,'1','285','1',1,'Retail Sale Id 335',3002.40,0.00,0.00,4.17,437.85,'2022-10-23 15:41:28','',''),(327,'1','285','1',1,'Retail Sale Id 336',1000.80,0.00,0.00,1.39,145.95,'2022-10-23 15:49:04','',''),(328,'1','285','1',1,'Retail Sale Id 337',2160.00,0.00,0.00,3.00,315.00,'2022-10-23 15:56:20','',''),(329,'1','285','1',1,'Retail Sale Id 338',2203.20,0.00,0.00,3.06,321.30,'2022-10-23 16:10:10','',''),(330,'1','285','1',1,'Retail Sale Id 339',168750.00,0.00,0.00,250.00,15000.00,'2022-10-23 16:21:09','',''),(331,'1','285','1',1,'Retail Sale Id 340',2808.00,0.00,0.00,4.16,249.60,'2022-10-23 16:55:33','',''),(332,'1','285','1',1,'Retail Sale Id 341',16200.00,0.00,0.00,22.50,2362.50,'2022-10-23 17:04:30','',''),(333,'1','285','1',1,'Retail Sale Id 342',2872.80,0.00,0.00,3.99,418.95,'2022-10-23 17:59:02','',''),(334,'1','285','1',1,'Return of Retail Sale Id 340',0.00,2808.00,4.16,0.00,-249.60,'2022-10-23 18:03:12','',''),(335,'1','285','1',1,'Retail Sale Id 343',2173.50,0.00,0.00,3.22,193.20,'2022-10-23 18:04:45','',''),(336,'1','285','1',1,'Retail Sale Id 344',5839.20,0.00,0.00,8.11,851.55,'2022-10-24 07:21:16','',''),(337,'1','285','1',1,'Retail Sale Id 345',41850.00,0.00,0.00,62.00,3720.00,'2022-10-24 07:26:18','',''),(338,'1','285','1',1,'Retail Sale Id 346',2203.20,0.00,0.00,3.06,321.30,'2022-10-24 07:30:49','',''),(339,'1','285','1',1,'Retail Sale Id 347',85164.75,0.00,0.00,126.17,7570.20,'2022-10-24 07:35:56','',''),(340,'1','285','1',1,'Retail Sale Id 348',93966.75,0.00,0.00,139.21,8352.60,'2022-10-24 07:48:18','',''),(341,'1','285','1',1,'Retail Sale Id 349',56700.00,0.00,0.00,84.00,5040.00,'2022-10-24 07:49:01','',''),(342,'1','285','1',1,'Retail Sale Id 350',2801.25,0.00,0.00,4.15,249.00,'2022-10-24 07:52:41','',''),(343,'1','285','1',1,'Return of Retail Sale Id 348',0.00,93966.75,139.21,0.00,-8352.60,'2022-10-24 07:57:57','',''),(344,'1','285','1',1,'Retail Sale Id 351',93966.75,0.00,0.00,139.21,8352.60,'2022-10-24 07:59:12','',''),(345,'1','285','1',1,'Retail Sale Id 352',10253.25,0.00,0.00,15.19,911.40,'2022-10-24 08:00:35','',''),(346,'1','285','1',1,'Retail Sale Id 353',40500.00,0.00,0.00,60.00,3600.00,'2022-10-24 08:01:30','',''),(347,'1','285','1',1,'Return of Retail Sale Id 349',0.00,56700.00,84.00,0.00,-5040.00,'2022-10-24 08:04:08','',''),(348,'1','285','1',1,'Retail Sale Id 354',57267.00,0.00,0.00,84.84,5090.40,'2022-10-24 08:04:59','',''),(349,'1','285','1',1,'Retail Sale Id 355',83693.25,0.00,0.00,123.99,7439.40,'2022-10-24 08:17:32','',''),(350,'1','285','1',1,'Retail Sale Id 356',42093.00,0.00,0.00,62.36,3741.60,'2022-10-24 08:25:46','',''),(351,'1','285','1',1,'Retail Sale Id 357',13776.75,0.00,0.00,20.41,1224.60,'2022-10-24 08:32:50','',''),(352,'1','285','1',1,'Retail Sale Id 358',9450.00,0.00,0.00,14.00,840.00,'2022-10-24 08:33:47','',''),(353,'1','285','1',1,'Retail Sale Id 359',4002.75,0.00,0.00,5.93,355.80,'2022-10-24 09:07:08','',''),(354,'1','285','1',1,'Retail Sale Id 360',123862.50,0.00,0.00,183.50,11010.00,'2022-10-24 10:29:10','',''),(355,'1','285','1',1,'Retail Sale Id 361',56362.50,0.00,0.00,83.50,5010.00,'2022-10-24 10:30:23','',''),(356,'1','285','1',1,'Retail Sale Id 362',83362.50,0.00,0.00,123.50,7410.00,'2022-10-24 10:31:40','',''),(357,'1','285','1',1,'Retail Sale Id 364',41843.25,0.00,0.00,61.99,3719.40,'2022-10-24 10:32:51','',''),(358,'1','285','1',1,'Retail Sale Id 366',39150.00,0.00,0.00,58.00,3480.00,'2022-10-24 10:33:33','',''),(359,'1','285','1',1,'Retail Sale Id 368',39150.00,0.00,0.00,58.00,3480.00,'2022-10-24 10:36:02','',''),(360,'1','285','1',1,'Retail Sale Id 369',51300.00,0.00,0.00,76.00,4560.00,'2022-10-24 10:36:36','',''),(361,'1','285','1',1,'Retail Sale Id 370',16200.00,0.00,0.00,24.00,1440.00,'2022-10-24 10:37:11','',''),(362,'1','285','1',1,'Retail Sale Id 371',46912.50,0.00,0.00,69.50,4170.00,'2022-10-24 10:37:48','',''),(363,'1','285','1',1,'Retail Sale Id 372',31725.00,0.00,0.00,47.00,2820.00,'2022-10-24 10:38:30','',''),(364,'1','285','1',1,'Retail Sale Id 373',40439.25,0.00,0.00,59.91,3594.60,'2022-10-24 10:40:27','',''),(365,'1','285','1',1,'Retail Sale Id 374',41478.75,0.00,0.00,61.45,3687.00,'2022-10-24 10:45:08','',''),(366,'1','285','1',1,'Retail Sale Id 375',41175.00,0.00,0.00,61.00,3660.00,'2022-10-24 10:45:58','',''),(367,'1','285','1',1,'Retail Sale Id 377',67500.00,0.00,0.00,100.00,6000.00,'2022-10-24 10:46:52','',''),(368,'1','285','1',1,'Retail Sale Id 379',52130.25,0.00,0.00,77.23,4633.80,'2022-10-24 10:47:29','',''),(369,'1','285','1',1,'Retail Sale Id 380',40500.00,0.00,0.00,60.00,3600.00,'2022-10-24 10:48:05','',''),(370,'1','285','1',1,'Retail Sale Id 381',40500.00,0.00,0.00,60.00,3600.00,'2022-10-24 10:49:13','',''),(371,'1','285','1',1,'Retail Sale Id 382',5313.60,0.00,0.00,7.38,774.90,'2022-10-24 10:51:05','',''),(372,'1','285','1',1,'Retail Sale Id 383',2160.00,0.00,0.00,3.00,315.00,'2022-10-24 10:52:12','',''),(373,'1','285','1',1,'Retail Sale Id 384',117207.00,0.00,0.00,173.64,10418.40,'2022-10-24 11:01:23','',''),(374,'1','285','1',1,'Retail Sale Id 385',52879.50,0.00,0.00,78.34,4700.40,'2022-10-24 11:02:47','',''),(375,'1','285','1',1,'Retail Sale Id 386',720.00,0.00,0.00,1.00,105.00,'2022-10-24 11:08:56','',''),(376,'1','285','1',1,'Retail Sale Id 388',799.20,0.00,0.00,1.11,116.55,'2022-10-24 11:09:28','',''),(377,'1','285','1',1,'Retail Sale Id 389',2203.20,0.00,0.00,3.06,321.30,'2022-10-24 11:10:29','',''),(378,'1','285','1',1,'Retail Sale Id 390',2880.00,0.00,0.00,4.00,420.00,'2022-10-24 11:11:15','',''),(379,'1','285','1',1,'Retail Sale Id 391',1497.60,0.00,0.00,2.08,218.40,'2022-10-24 11:14:33','',''),(380,'1','285','1',1,'Retail Sale Id 392',4003.20,0.00,0.00,5.56,583.80,'2022-10-24 11:17:35','',''),(381,'1','285','1',1,'Retail Sale Id 393',3600.00,0.00,0.00,5.00,525.00,'2022-10-24 11:18:28','',''),(382,'1','285','1',1,'Retail Sale Id 394',2160.00,0.00,0.00,3.00,315.00,'2022-10-24 11:19:11','',''),(383,'1','285','1',1,'Retail Sale Id 395',2880.00,0.00,0.00,4.00,420.00,'2022-10-24 11:19:56','',''),(384,'1','285','1',1,'Retail Sale Id 396',91125.00,0.00,0.00,135.00,8100.00,'2022-10-24 11:51:48','',''),(385,'1','285','1',1,'Retail Sale Id 397',3600.00,0.00,0.00,5.00,525.00,'2022-10-24 11:53:03','',''),(386,'1','285','1',1,'Retail Sale Id 398',3160.80,0.00,0.00,4.39,460.95,'2022-10-24 11:53:58','',''),(387,'1','285','1',1,'Retail Sale Id 399',2995.20,0.00,0.00,4.16,436.80,'2022-10-24 11:54:39','',''),(388,'1','285','1',1,'Retail Sale Id 400',3600.00,0.00,0.00,5.00,525.00,'2022-10-24 11:55:14','',''),(389,'1','285','1',1,'Retail Sale Id 401',2700.00,0.00,0.00,4.00,240.00,'2022-10-24 11:59:14','',''),(390,'1','285','1',1,'Retail Sale Id 402',2001.60,0.00,0.00,2.78,291.90,'2022-10-24 12:44:52','',''),(391,'1','285','1',1,'Retail Sale Id 403',40500.00,0.00,0.00,60.00,3600.00,'2022-10-24 12:52:49','',''),(392,'1','285','1',1,'Retail Sale Id 404',3600.00,0.00,0.00,5.00,525.00,'2022-10-24 12:54:03','',''),(393,'1','285','1',1,'Retail Sale Id 405',1000.80,0.00,0.00,1.39,145.95,'2022-10-24 12:54:48','',''),(394,'1','285','1',1,'Retail Sale Id 406',45225.00,0.00,0.00,67.00,4020.00,'2022-10-24 13:01:36','',''),(395,'1','285','1',1,'Retail Sale Id 407',799.20,0.00,0.00,1.11,116.55,'2022-10-24 13:13:21','',''),(396,'1','285','1',1,'Retail Sale Id 408',3600.00,0.00,0.00,5.00,525.00,'2022-10-24 13:23:02','',''),(397,'1','285','1',1,'Retail Sale Id 409',1497.60,0.00,0.00,2.08,218.40,'2022-10-24 13:24:16','',''),(398,'1','285','1',1,'Retail Sale Id 410',180292.50,0.00,0.00,267.10,16026.00,'2022-10-24 13:33:39','',''),(399,'1','285','1',1,'Retail Sale Id 411',720.00,0.00,0.00,1.00,105.00,'2022-10-24 13:41:02','',''),(400,'1','285','1',1,'Retail Sale Id 412',4996.80,0.00,0.00,6.94,728.70,'2022-10-24 14:01:37','',''),(401,'1','285','1',1,'Retail Sale Id 413',2203.20,0.00,0.00,3.06,321.30,'2022-10-24 14:29:12','',''),(402,'1','285','1',1,'Retail Sale Id 414',2160.00,0.00,0.00,3.00,315.00,'2022-10-24 14:32:47','',''),(403,'1','285','1',1,'Retail Sale Id 415',748.80,0.00,0.00,1.04,109.20,'2022-10-24 14:42:38','',''),(404,'1','285','1',1,'Retail Sale Id 417',7999.20,0.00,0.00,11.11,1166.55,'2022-10-24 14:50:13','',''),(405,'1','285','1',1,'Retail Sale Id 418',3600.00,0.00,0.00,5.00,525.00,'2022-10-24 14:51:08','',''),(406,'1','285','1',1,'Retail Sale Id 419',8640.00,0.00,0.00,12.00,1260.00,'2022-10-24 15:03:10','',''),(407,'1','285','1',1,'Retail Sale Id 420',1440.00,0.00,0.00,2.00,210.00,'2022-10-24 15:16:31','',''),(408,'1','285','1',1,'Retail Sale Id 421',2160.00,0.00,0.00,3.00,315.00,'2022-10-24 15:17:07','',''),(409,'1','285','1',1,'Retail Sale Id 422',2203.20,0.00,0.00,3.06,321.30,'2022-10-24 15:17:54','',''),(410,'1','285','1',1,'Retail Sale Id 423',2203.20,0.00,0.00,3.06,321.30,'2022-10-24 15:19:07','',''),(411,'1','285','1',1,'Retail Sale Id 424',40500.00,0.00,0.00,60.00,3600.00,'2022-10-24 15:25:54','',''),(412,'1','285','1',1,'Retail Sale Id 425',2880.00,0.00,0.00,4.00,420.00,'2022-10-24 15:30:18','',''),(413,'1','285','1',1,'Retail Sale Id 427',42525.00,0.00,0.00,63.00,3780.00,'2022-10-24 15:36:17','',''),(414,'1','285','1',1,'Retail Sale Id 428',9496.80,0.00,0.00,13.19,1384.95,'2022-10-24 15:38:11','',''),(415,'1','285','1',1,'Retail Sale Id 429',2217.60,0.00,0.00,3.08,323.40,'2022-10-24 15:59:45','',''),(416,'1','285','1',1,'Retail Sale Id 430',112050.00,0.00,0.00,166.00,9960.00,'2022-10-24 16:00:44','',''),(417,'1','285','1',1,'Retail Sale Id 432',2848.50,0.00,0.00,4.22,253.20,'2022-10-24 16:21:21','',''),(418,'1','285','1',1,'Retail Sale Id 433',3002.40,0.00,0.00,4.17,437.85,'2022-10-24 16:25:44','',''),(419,'1','285','1',1,'Retail Sale Id 434',23803.20,0.00,0.00,33.06,3471.30,'2022-10-24 16:30:10','',''),(420,'1','285','1',1,'Retail Sale Id 435',720.00,0.00,0.00,1.00,105.00,'2022-10-24 16:46:36','',''),(421,'1','285','1',1,'Retail Sale Id 436',72900.00,0.00,0.00,108.00,6480.00,'2022-10-24 17:01:54','',''),(422,'1','285','1',1,'Retail Sale Id 437',3600.00,0.00,0.00,5.00,525.00,'2022-10-24 17:03:53','',''),(423,'1','285','1',1,'Retail Sale Id 438',5040.00,0.00,0.00,7.00,735.00,'2022-10-24 17:11:17','',''),(424,'1','285','1',1,'Retail Sale Id 439',99900.00,0.00,0.00,148.00,8880.00,'2022-10-24 17:13:18','',''),(425,'1','285','1',1,'Retail Sale Id 440',2880.00,0.00,0.00,4.00,420.00,'2022-10-24 17:23:13','',''),(426,'1','285','1',1,'Retail Sale Id 441',68175.00,0.00,0.00,101.00,6060.00,'2022-10-24 17:26:47','',''),(427,'1','285','1',1,'Retail Sale Id 442',41850.00,0.00,0.00,62.00,3720.00,'2022-10-24 17:27:43','',''),(428,'1','285','1',1,'Return of Retail Sale Id 439',0.00,99900.00,148.00,0.00,-8880.00,'2022-10-24 19:51:38','',''),(429,'1','285','1',1,'Retail Sale Id 443',16794.00,0.00,0.00,24.88,1492.80,'2022-10-24 19:57:27','',''),(430,'1','285','1',1,'Retail Sale Id 444',3326.40,0.00,0.00,4.62,485.10,'2022-10-24 19:58:07','',''),(431,'1','285','1',1,'Retail Sale Id 445',8280.00,0.00,0.00,11.50,1207.50,'2022-10-25 07:26:35','',''),(432,'1','285','1',1,'Retail Sale Id 446',1303.20,0.00,0.00,1.81,190.05,'2022-10-25 07:27:08','',''),(433,'1','285','1',1,'Retail Sale Id 447',799.20,0.00,0.00,1.11,116.55,'2022-10-25 07:29:17','',''),(434,'1','285','1',1,'Retail Sale Id 448',3002.40,0.00,0.00,4.17,437.85,'2022-10-25 07:29:58','',''),(435,'1','285','1',1,'Retail Sale Id 449',40500.00,0.00,0.00,60.00,3600.00,'2022-10-25 07:44:57','',''),(436,'1','285','1',1,'Retail Sale Id 450',168750.00,0.00,0.00,250.00,15000.00,'2022-10-25 07:48:09','',''),(437,'1','285','1',1,'Retail Sale Id 451',20925.00,0.00,0.00,31.00,1860.00,'2022-10-25 07:50:41','',''),(438,'1','285','1',1,'Retail Sale Id 452',4320.00,0.00,0.00,6.00,630.00,'2022-10-25 07:52:29','',''),(439,'1','285','1',1,'Retail Sale Id 453',71550.00,0.00,0.00,106.00,6360.00,'2022-10-25 07:53:11','',''),(440,'1','285','1',1,'Retail Sale Id 454',1497.60,0.00,0.00,2.08,218.40,'2022-10-25 07:54:42','',''),(441,'1','285','1',1,'Retail Sale Id 455',46926.00,0.00,0.00,69.52,4171.20,'2022-10-25 08:03:09','',''),(442,'1','285','1',1,'Retail Sale Id 456',2203.20,0.00,0.00,3.06,321.30,'2022-10-25 08:11:22','',''),(443,'1','285','1',1,'Retail Sale Id 457',1680.75,0.00,0.00,2.49,149.40,'2022-10-25 08:12:20','',''),(444,'1','285','1',1,'Retail Sale Id 458',2880.00,0.00,0.00,4.00,420.00,'2022-10-25 08:13:27','',''),(445,'1','285','1',1,'Retail Sale Id 459',2203.20,0.00,0.00,3.06,321.30,'2022-10-25 08:25:44','',''),(446,'1','285','1',1,'Retail Sale Id 460',3002.40,0.00,0.00,4.17,437.85,'2022-10-25 08:28:11','',''),(447,'1','285','1',1,'Retail Sale Id 461',799.20,0.00,0.00,1.11,116.55,'2022-10-25 08:31:35','',''),(448,'1','285','1',1,'Retail Sale Id 462',20925.00,0.00,0.00,31.00,1860.00,'2022-10-25 08:39:26','',''),(449,'1','285','1',1,'Retail Sale Id 463',3002.40,0.00,0.00,4.17,437.85,'2022-10-25 08:42:44','',''),(450,'1','285','1',1,'Retail Sale Id 464',5040.00,0.00,0.00,7.00,735.00,'2022-10-25 08:50:24','',''),(451,'1','285','1',1,'Retail Sale Id 465',2880.00,0.00,0.00,4.00,420.00,'2022-10-25 08:54:15','',''),(452,'1','285','1',1,'Retail Sale Id 466',1440.00,0.00,0.00,2.00,210.00,'2022-10-25 08:55:43','',''),(453,'1','285','1',1,'Retail Sale Id 467',2001.60,0.00,0.00,2.78,291.90,'2022-10-25 09:02:42','',''),(454,'1','285','1',1,'Retail Sale Id 468',42147.00,0.00,0.00,62.44,3746.40,'2022-10-25 09:05:01','',''),(455,'1','285','1',1,'Retail Sale Id 470',2203.20,0.00,0.00,3.06,321.30,'2022-10-25 09:06:52','',''),(456,'1','285','1',1,'Retail Sale Id 471',2520.00,0.00,0.00,3.50,367.50,'2022-10-25 09:08:38','',''),(457,'1','285','1',1,'Retail Sale Id 472',5803.20,0.00,0.00,8.06,846.30,'2022-10-25 09:14:45','',''),(458,'1','285','1',1,'Retail Sale Id 473',40500.00,0.00,0.00,60.00,3600.00,'2022-10-25 09:17:16','',''),(459,'1','285','1',1,'Retail Sale Id 475',13500.00,0.00,0.00,20.00,1200.00,'2022-10-25 09:21:06','',''),(460,'1','285','1',1,'Retail Sale Id 476',5040.00,0.00,0.00,7.00,735.00,'2022-10-25 09:24:14','',''),(461,'1','285','1',1,'Retail Sale Id 477',799.20,0.00,0.00,1.11,116.55,'2022-10-25 09:27:46','',''),(462,'1','285','1',1,'Retail Sale Id 478',40500.00,0.00,0.00,60.00,3600.00,'2022-10-25 09:39:57','',''),(463,'1','285','1',1,'Retail Sale Id 479',16200.00,0.00,0.00,24.00,1440.00,'2022-10-25 09:42:52','',''),(464,'1','285','1',1,'Retail Sale Id 480',72900.00,0.00,0.00,108.00,6480.00,'2022-10-25 09:43:42','',''),(465,'1','285','1',1,'Retail Sale Id 481',3002.40,0.00,0.00,4.17,437.85,'2022-10-25 09:44:38','',''),(466,'1','285','1',1,'Retail Sale Id 482',45873.00,0.00,0.00,67.96,4077.60,'2022-10-25 09:46:11','',''),(467,'1','285','1',1,'Retail Sale Id 483',6750.00,0.00,0.00,10.00,600.00,'2022-10-25 09:49:49','',''),(468,'1','285','1',1,'Retail Sale Id 484',3002.40,0.00,0.00,4.17,437.85,'2022-10-25 09:52:21','',''),(469,'1','285','1',1,'Retail Sale Id 485',35100.00,0.00,0.00,52.00,3120.00,'2022-10-25 10:08:44','',''),(470,'1','285','1',1,'Retail Sale Id 486',20880.00,0.00,0.00,29.00,3045.00,'2022-10-25 10:13:02','',''),(471,'1','285','1',1,'Retail Sale Id 487',748.80,0.00,0.00,1.04,109.20,'2022-10-25 10:44:07','',''),(472,'1','285','1',1,'Retail Sale Id 488',2203.20,0.00,0.00,3.06,321.30,'2022-10-25 10:51:02','',''),(473,'1','285','1',1,'Retail Sale Id 489',34425.00,0.00,0.00,51.00,3060.00,'2022-10-25 10:57:04','',''),(474,'1','285','1',1,'Retail Sale Id 490',66150.00,0.00,0.00,98.00,5880.00,'2022-10-25 11:22:19','',''),(475,'1','285','1',1,'Retail Sale Id 491',41175.00,0.00,0.00,61.00,3660.00,'2022-10-25 11:24:10','',''),(476,'1','285','1',1,'Return of Retail Sale Id 491',0.00,41175.00,61.00,0.00,-3660.00,'2022-10-25 11:31:49','',''),(477,'1','285','1',1,'Retail Sale Id 492',41276.25,0.00,0.00,61.15,3669.00,'2022-10-25 11:33:06','',''),(478,'1','285','1',1,'Retail Sale Id 493',3600.00,0.00,0.00,5.00,525.00,'2022-10-25 11:34:23','',''),(479,'1','285','1',1,'Return of Retail Sale Id 492',0.00,41276.25,61.15,0.00,-3669.00,'2022-10-25 11:36:12','',''),(480,'1','285','1',1,'Retail Sale Id 494',41073.75,0.00,0.00,60.85,3651.00,'2022-10-25 11:37:16','',''),(481,'1','285','1',1,'Retail Sale Id 495',3600.00,0.00,0.00,5.00,525.00,'2022-10-25 11:55:12','',''),(482,'1','285','1',1,'Retail Sale Id 496',83990.25,0.00,0.00,124.43,7465.80,'2022-10-25 11:58:33','',''),(483,'1','285','1',1,'Retail Sale Id 497',2203.20,0.00,0.00,3.06,321.30,'2022-10-25 11:59:54','',''),(484,'1','285','1',1,'Retail Sale Id 498',3600.00,0.00,0.00,5.00,525.00,'2022-10-25 12:06:42','',''),(485,'1','285','1',1,'Retail Sale Id 499',40500.00,0.00,0.00,60.00,3600.00,'2022-10-25 12:09:30','',''),(486,'1','285','1',1,'Retail Sale Id 500',2880.00,0.00,0.00,4.00,420.00,'2022-10-25 12:11:25','',''),(487,'1','285','1',1,'Retail Sale Id 501',40500.00,0.00,0.00,60.00,3600.00,'2022-10-25 12:13:43','',''),(488,'1','285','1',1,'Return of Retail Sale Id 499',0.00,40500.00,60.00,0.00,-3600.00,'2022-10-25 12:15:20','',''),(489,'1','285','1',1,'Retail Sale Id 502',41323.50,0.00,0.00,61.22,3673.20,'2022-10-25 12:16:31','',''),(490,'1','285','1',1,'Retail Sale Id 503',2275.20,0.00,0.00,3.16,331.80,'2022-10-25 12:20:36','',''),(491,'1','285','1',1,'Retail Sale Id 504',6480.00,0.00,0.00,9.00,945.00,'2022-10-25 12:38:57','',''),(492,'1','285','1',1,'Retail Sale Id 505',9000.00,0.00,0.00,12.50,1312.50,'2022-10-25 12:40:39','',''),(493,'1','285','1',1,'Return of Retail Sale Id 486',0.00,20880.00,29.00,0.00,-3045.00,'2022-10-25 12:52:50','',''),(494,'1','285','1',1,'Retail Sale Id 506',748.80,0.00,0.00,1.04,109.20,'2022-10-25 12:55:15','',''),(495,'1','285','1',1,'Retail Sale Id 507',748.80,0.00,0.00,1.04,109.20,'2022-10-25 13:01:25','',''),(496,'1','285','1',1,'Retail Sale Id 508',135000.00,0.00,0.00,200.00,12000.00,'2022-10-25 13:04:14','',''),(497,'1','285','1',1,'Retail Sale Id 509',40500.00,0.00,0.00,60.00,3600.00,'2022-10-25 13:06:35','',''),(498,'1','285','1',1,'Retail Sale Id 510',41829.75,0.00,0.00,61.97,3718.20,'2022-10-25 13:09:06','',''),(499,'1','285','1',1,'Return of Retail Sale Id 505',0.00,9000.00,12.50,0.00,-1312.50,'2022-10-25 13:17:23','',''),(500,'1','285','1',1,'Retail Sale Id 511',10125.00,0.00,0.00,15.00,900.00,'2022-10-25 13:18:45','',''),(501,'1','285','1',1,'Retail Sale Id 512',41985.00,0.00,0.00,62.20,3732.00,'2022-10-25 13:20:15','',''),(502,'1','285','1',1,'Retail Sale Id 513',4298.40,0.00,0.00,5.97,626.85,'2022-10-25 13:24:08','',''),(503,'1','285','1',1,'Return of Retail Sale Id 511',0.00,10125.00,15.00,0.00,-900.00,'2022-10-25 13:25:29','',''),(504,'1','285','1',1,'Retail Sale Id 514',9855.00,0.00,0.00,14.60,876.00,'2022-10-25 13:26:34','',''),(505,'1','285','1',1,'Retail Sale Id 516',2203.20,0.00,0.00,3.06,321.30,'2022-10-25 13:28:36','',''),(506,'1','285','1',1,'Retail Sale Id 517',720.00,0.00,0.00,1.00,105.00,'2022-10-25 13:31:06','',''),(507,'1','285','1',1,'Retail Sale Id 518',41870.25,0.00,0.00,62.03,3721.80,'2022-10-25 13:37:49','',''),(508,'1','285','1',1,'Return of Retail Sale Id 504',0.00,6480.00,9.00,0.00,-945.00,'2022-10-25 13:40:07','',''),(509,'1','285','1',1,'Return of Retail Sale Id 465',0.00,2880.00,4.00,0.00,-420.00,'2022-10-25 13:42:24','',''),(510,'1','285','1',1,'Return of Retail Sale Id 481',0.00,3002.40,4.17,0.00,-437.85,'2022-10-25 13:43:24','',''),(511,'1','285','1',1,'Retail Sale Id 519',2203.20,0.00,0.00,3.06,321.30,'2022-10-25 13:45:06','',''),(512,'1','285','1',1,'Retail Sale Id 521',20250.00,0.00,0.00,30.00,1800.00,'2022-10-25 13:46:40','',''),(513,'1','285','1',1,'Return of Retail Sale Id 466',0.00,1440.00,2.00,0.00,-210.00,'2022-10-25 13:48:07','',''),(514,'1','285','1',1,'Return of Retail Sale Id 493',0.00,3600.00,5.00,0.00,-525.00,'2022-10-25 13:48:42','',''),(515,'1','285','1',1,'Return of Retail Sale Id 488',0.00,2203.20,3.06,0.00,-321.30,'2022-10-25 13:49:10','',''),(516,'1','285','1',1,'Retail Sale Id 522',46392.75,0.00,0.00,68.73,4123.80,'2022-10-25 13:50:31','',''),(517,'1','285','1',1,'Retail Sale Id 523',799.20,0.00,0.00,1.11,116.55,'2022-10-25 13:55:24','',''),(518,'1','285','1',1,'Retail Sale Id 524',1497.60,0.00,0.00,2.08,218.40,'2022-10-25 14:08:08','',''),(519,'1','285','1',1,'Retail Sale Id 525',799.20,0.00,0.00,1.11,116.55,'2022-10-25 14:09:19','',''),(520,'1','285','1',1,'Retail Sale Id 526',2001.60,0.00,0.00,2.78,291.90,'2022-10-25 14:10:26','',''),(521,'1','285','1',1,'Retail Sale Id 527',4003.20,0.00,0.00,5.56,583.80,'2022-10-25 14:20:11','',''),(522,'1','285','1',1,'Retail Sale Id 528',2001.60,0.00,0.00,2.78,291.90,'2022-10-25 14:33:58','',''),(523,'1','285','1',1,'Retail Sale Id 529',2160.00,0.00,0.00,3.00,315.00,'2022-10-25 14:43:28','',''),(524,'1','285','1',1,'Retail Sale Id 530',1497.60,0.00,0.00,2.08,218.40,'2022-10-25 14:44:54','',''),(525,'1','285','1',1,'Retail Sale Id 531',1440.00,0.00,0.00,2.00,210.00,'2022-10-25 14:55:59','',''),(526,'1','285','1',1,'Retail Sale Id 532',22612.50,0.00,0.00,33.50,2010.00,'2022-10-25 15:08:06','',''),(527,'1','285','1',1,'Return of Retail Sale Id 532',0.00,22612.50,33.50,0.00,-2010.00,'2022-10-25 15:16:17','',''),(528,'1','285','1',1,'Retail Sale Id 533',1440.00,0.00,0.00,2.00,210.00,'2022-10-25 15:18:39','',''),(529,'1','285','1',1,'Retail Sale Id 534',22268.25,0.00,0.00,32.99,1979.40,'2022-10-25 15:19:42','',''),(530,'1','285','1',1,'Retail Sale Id 535',1497.60,0.00,0.00,2.08,218.40,'2022-10-25 15:24:04','',''),(531,'1','285','1',1,'Retail Sale Id 536',2160.00,0.00,0.00,3.00,315.00,'2022-10-25 15:32:17','',''),(532,'1','285','1',1,'Retail Sale Id 537',3002.40,0.00,0.00,4.17,437.85,'2022-10-25 15:36:03','',''),(533,'1','285','1',1,'Return of Retail Sale Id 501',0.00,40500.00,60.00,0.00,-3600.00,'2022-10-25 16:09:38','',''),(534,'1','285','1',1,'Retail Sale Id 540',5040.00,0.00,0.00,7.00,735.00,'2022-10-25 16:10:14','',''),(535,'1','285','1',1,'Retail Sale Id 541',2880.00,0.00,0.00,4.00,420.00,'2022-10-25 16:11:47','',''),(536,'1','285','1',1,'Retail Sale Id 542',2203.20,0.00,0.00,3.06,321.30,'2022-10-25 16:18:59','',''),(537,'1','285','1',1,'Retail Sale Id 543',2160.00,0.00,0.00,3.00,315.00,'2022-10-25 16:22:02','',''),(538,'1','285','1',1,'Retail Sale Id 544',1440.00,0.00,0.00,2.00,210.00,'2022-10-25 16:23:37','',''),(539,'1','285','1',1,'Retail Sale Id 546',799.20,0.00,0.00,1.11,116.55,'2022-10-25 16:29:56','',''),(540,'1','285','1',1,'Retail Sale Id 547',2880.00,0.00,0.00,4.00,420.00,'2022-10-25 16:31:20','',''),(541,'1','285','1',1,'Retail Sale Id 548',22275.00,0.00,0.00,33.00,1980.00,'2022-10-25 16:35:36','',''),(542,'1','285','1',1,'Retail Sale Id 549',1440.00,0.00,0.00,2.00,210.00,'2022-10-25 16:38:14','',''),(543,'1','285','1',1,'Return of Retail Sale Id 548',0.00,22275.00,33.00,0.00,-1980.00,'2022-10-25 16:44:53','',''),(544,'1','285','1',1,'Retail Sale Id 550',23091.75,0.00,0.00,34.21,2052.60,'2022-10-25 16:46:03','',''),(545,'1','285','1',1,'Retail Sale Id 552',799.20,0.00,0.00,1.11,116.55,'2022-10-25 16:46:54','',''),(546,'1','285','1',1,'Retail Sale Id 553',1497.60,0.00,0.00,2.08,218.40,'2022-10-25 16:48:15','',''),(547,'1','285','1',1,'Retail Sale Id 554',81000.00,0.00,0.00,120.00,7200.00,'2022-10-25 16:51:49','',''),(548,'1','285','1',1,'Retail Sale Id 555',99353.25,0.00,0.00,147.19,8831.40,'2022-10-25 17:04:18','',''),(549,'1','285','1',1,'Retail Sale Id 556',806.40,0.00,0.00,1.12,117.60,'2022-10-25 19:22:42','',''),(550,'1','285','1',1,'Return of Retail Sale Id 514',0.00,9855.00,14.60,0.00,-876.00,'2022-10-25 19:31:05','',''),(551,'1','285','1',1,'Retail Sale Id 557',10523.25,0.00,0.00,15.59,935.40,'2022-10-25 19:32:32','',''),(552,'1','285','1',1,'Retail Sale Id 558',1000.80,0.00,0.00,1.39,145.95,'2022-10-26 07:08:09','',''),(553,'1','285','1',1,'Retail Sale Id 559',40500.00,0.00,0.00,60.00,3600.00,'2022-10-26 07:25:25','',''),(554,'1','285','1',1,'Retail Sale Id 560',4996.80,0.00,0.00,6.94,728.70,'2022-10-26 07:28:07','',''),(555,'1','285','1',1,'Retail Sale Id 561',42795.00,0.00,0.00,63.40,3804.00,'2022-10-26 07:49:25','',''),(556,'1','285','1',1,'Retail Sale Id 562',1440.00,0.00,0.00,2.00,210.00,'2022-10-26 07:58:38','',''),(557,'1','285','1',1,'Retail Sale Id 563',67290.75,0.00,0.00,99.69,5981.40,'2022-10-26 08:03:04','',''),(558,'1','285','1',1,'Retail Sale Id 564',2160.00,0.00,0.00,3.00,315.00,'2022-10-26 08:07:23','',''),(559,'1','285','1',1,'Retail Sale Id 565',41769.00,0.00,0.00,61.88,3712.80,'2022-10-26 08:14:28','',''),(560,'1','285','1',1,'Retail Sale Id 566',2001.60,0.00,0.00,2.78,291.90,'2022-10-26 08:15:55','',''),(561,'1','285','1',1,'Retail Sale Id 567',1440.00,0.00,0.00,2.00,210.00,'2022-10-26 08:19:52','',''),(562,'1','285','1',1,'Retail Sale Id 568',9000.00,0.00,0.00,12.50,1312.50,'2022-10-26 08:21:27','',''),(563,'1','285','1',1,'Retail Sale Id 569',16841.25,0.00,0.00,24.95,1497.00,'2022-10-26 08:23:06','',''),(564,'1','285','1',1,'Retail Sale Id 570',22320.00,0.00,0.00,31.00,3255.00,'2022-10-26 08:25:45','',''),(565,'1','285','1',1,'Retail Sale Id 571',2160.00,0.00,0.00,3.00,315.00,'2022-10-26 08:31:14','',''),(566,'1','285','1',1,'Retail Sale Id 572',2880.00,0.00,0.00,4.00,420.00,'2022-10-26 08:34:21','',''),(567,'1','285','1',1,'Retail Sale Id 573',41512.50,0.00,0.00,61.50,3690.00,'2022-10-26 08:35:44','',''),(568,'1','285','1',1,'Retail Sale Id 574',33750.00,0.00,0.00,50.00,3000.00,'2022-10-26 08:38:51','',''),(569,'1','285','1',1,'Retail Sale Id 575',33750.00,0.00,0.00,50.00,3000.00,'2022-10-26 08:41:53','',''),(570,'1','285','1',1,'Retail Sale Id 576',1440.00,0.00,0.00,2.00,210.00,'2022-10-26 08:42:56','',''),(571,'1','285','1',1,'Retail Sale Id 577',4003.20,0.00,0.00,5.56,583.80,'2022-10-26 08:45:18','',''),(572,'1','285','1',1,'Retail Sale Id 579',799.20,0.00,0.00,1.11,116.55,'2022-10-26 08:47:24','',''),(573,'1','285','1',1,'Retail Sale Id 580',7920.00,0.00,0.00,11.00,1155.00,'2022-10-26 08:49:00','',''),(574,'1','285','1',1,'Retail Sale Id 581',40500.00,0.00,0.00,60.00,3600.00,'2022-10-26 08:50:55','',''),(575,'1','285','1',1,'Retail Sale Id 582',66555.00,0.00,0.00,98.60,5916.00,'2022-10-26 08:57:53','',''),(576,'1','285','1',1,'Retail Sale Id 583',20925.00,0.00,0.00,31.00,1860.00,'2022-10-26 09:02:14','',''),(577,'1','285','1',1,'Retail Sale Id 584',5997.60,0.00,0.00,8.33,874.65,'2022-10-26 09:05:25','',''),(578,'1','285','1',1,'Retail Sale Id 585',1497.60,0.00,0.00,2.08,218.40,'2022-10-26 09:07:12','',''),(579,'1','285','1',1,'Retail Sale Id 586',18000.00,0.00,0.00,25.00,2625.00,'2022-10-26 09:11:42','',''),(580,'1','285','1',1,'Retail Sale Id 587',9000.00,0.00,0.00,12.50,1312.50,'2022-10-26 09:19:41','',''),(581,'1','285','1',1,'Retail Sale Id 588',18000.00,0.00,0.00,25.00,2625.00,'2022-10-26 09:20:35','',''),(582,'1','285','1',1,'Retail Sale Id 589',999.00,0.00,0.00,1.48,88.80,'2022-10-26 09:29:48','',''),(583,'1','285','1',1,'Retail Sale Id 590',720.00,0.00,0.00,1.00,105.00,'2022-10-26 09:30:37','',''),(584,'1','285','1',1,'Retail Sale Id 591',2498.40,0.00,0.00,3.47,364.35,'2022-10-26 09:37:35','',''),(585,'1','285','1',1,'Retail Sale Id 592',1440.00,0.00,0.00,2.00,210.00,'2022-10-26 09:41:53','',''),(586,'1','285','1',1,'Retail Sale Id 593',31725.00,0.00,0.00,47.00,2820.00,'2022-10-26 09:45:05','',''),(587,'1','285','1',1,'Retail Sale Id 594',7920.00,0.00,0.00,11.00,1155.00,'2022-10-26 09:48:07','',''),(588,'1','285','1',1,'Retail Sale Id 596',1000.80,0.00,0.00,1.39,145.95,'2022-10-26 09:55:08','',''),(589,'1','285','1',1,'Retail Sale Id 597',1497.60,0.00,0.00,2.08,218.40,'2022-10-26 09:58:58','',''),(590,'1','285','1',1,'Retail Sale Id 598',2160.00,0.00,0.00,3.00,315.00,'2022-10-26 10:00:18','',''),(591,'1','285','1',1,'Retail Sale Id 599',1497.60,0.00,0.00,2.08,218.40,'2022-10-26 10:07:04','',''),(592,'1','285','1',1,'Retail Sale Id 600',43186.50,0.00,0.00,63.98,3838.80,'2022-10-26 10:09:33','',''),(593,'1','285','1',1,'Retail Sale Id 601',40500.00,0.00,0.00,60.00,3600.00,'2022-10-26 10:18:21','',''),(594,'1','285','1',1,'Retail Sale Id 602',70200.00,0.00,0.00,104.00,6240.00,'2022-10-26 10:30:20','',''),(595,'1','285','1',1,'Retail Sale Id 603',41175.00,0.00,0.00,61.00,3660.00,'2022-10-26 10:37:57','',''),(596,'1','285','1',1,'Retail Sale Id 604',128513.25,0.00,0.00,190.39,11423.40,'2022-10-26 10:43:14','',''),(597,'1','285','1',1,'Return of Retail Sale Id 570',0.00,22320.00,31.00,0.00,-3255.00,'2022-10-26 11:00:59','',''),(598,'1','285','1',1,'Return of Retail Sale Id 588',0.00,18000.00,25.00,0.00,-2625.00,'2022-10-26 11:01:28','',''),(599,'1','285','1',1,'Return of Retail Sale Id 594',0.00,7920.00,11.00,0.00,-1155.00,'2022-10-26 11:01:54','',''),(600,'1','285','1',1,'Return of Retail Sale Id 586',0.00,18000.00,25.00,0.00,-2625.00,'2022-10-26 11:02:20','',''),(601,'1','285','1',1,'Retail Sale Id 605',1396.80,0.00,0.00,1.94,203.70,'2022-10-26 11:03:49','',''),(602,'1','285','1',1,'Retail Sale Id 606',41289.75,0.00,0.00,61.17,3670.20,'2022-10-26 11:05:46','',''),(603,'1','285','1',1,'Retail Sale Id 607',1900.80,0.00,0.00,2.64,277.20,'2022-10-26 11:14:36','',''),(604,'1','285','1',1,'Retail Sale Id 608',3600.00,0.00,0.00,5.00,525.00,'2022-10-26 11:18:52','',''),(605,'1','285','1',1,'Retail Sale Id 609',1497.60,0.00,0.00,2.08,218.40,'2022-10-26 11:24:29','',''),(606,'1','285','1',1,'Retail Sale Id 611',6501.60,0.00,0.00,9.03,948.15,'2022-10-26 11:29:55','',''),(607,'1','285','1',1,'Retail Sale Id 612',5400.00,0.00,0.00,7.50,787.50,'2022-10-26 11:35:24','',''),(608,'1','285','1',1,'Retail Sale Id 613',1396.80,0.00,0.00,1.94,203.70,'2022-10-26 11:46:46','',''),(609,'1','285','1',1,'Retail Sale Id 614',67500.00,0.00,0.00,100.00,6000.00,'2022-10-26 11:51:02','',''),(610,'1','285','1',1,'Retail Sale Id 615',16733.25,0.00,0.00,24.79,1487.40,'2022-10-26 11:59:51','',''),(611,'1','285','1',1,'Retail Sale Id 616',2203.20,0.00,0.00,3.06,321.30,'2022-10-26 12:02:06','',''),(612,'1','285','1',1,'Retail Sale Id 617',51259.50,0.00,0.00,75.94,4556.40,'2022-10-26 12:03:46','',''),(613,'1','285','1',1,'Retail Sale Id 618',2203.20,0.00,0.00,3.06,321.30,'2022-10-26 12:05:18','',''),(614,'1','285','1',1,'Return of Retail Sale Id 612',0.00,5400.00,7.50,0.00,-787.50,'2022-10-26 12:06:12','',''),(615,'1','285','1',1,'Return of Retail Sale Id 587',0.00,9000.00,12.50,0.00,-1312.50,'2022-10-26 12:06:47','',''),(616,'1','285','1',1,'Return of Retail Sale Id 572',0.00,2880.00,4.00,0.00,-420.00,'2022-10-26 12:07:46','',''),(617,'1','285','1',1,'Return of Retail Sale Id 577',0.00,4003.20,5.56,0.00,-583.80,'2022-10-26 12:08:26','',''),(618,'1','285','1',1,'Retail Sale Id 619',47250.00,0.00,0.00,70.00,4200.00,'2022-10-26 12:09:53','',''),(619,'1','285','1',1,'Retail Sale Id 620',34830.00,0.00,0.00,51.60,3096.00,'2022-10-26 12:11:36','',''),(620,'1','285','1',1,'Retail Sale Id 621',720.00,0.00,0.00,1.00,105.00,'2022-10-26 12:20:05','',''),(621,'1','285','1',1,'Retail Sale Id 622',4500.00,0.00,0.00,6.25,656.25,'2022-10-26 12:45:56','',''),(622,'1','285','1',1,'Retail Sale Id 623',8640.00,0.00,0.00,12.00,1260.00,'2022-10-26 12:51:54','',''),(623,'1','285','1',1,'Retail Sale Id 624',1497.60,0.00,0.00,2.08,218.40,'2022-10-26 13:31:26','',''),(624,'1','285','1',1,'Retail Sale Id 625',8640.00,0.00,0.00,12.00,1260.00,'2022-10-26 13:34:17','',''),(625,'1','285','1',1,'Retail Sale Id 626',13695.75,0.00,0.00,20.29,1217.40,'2022-10-26 14:15:14','',''),(626,'1','285','1',1,'Retail Sale Id 627',1000.80,0.00,0.00,1.39,145.95,'2022-10-26 14:36:52','',''),(627,'1','285','1',1,'Retail Sale Id 628',13680.00,0.00,0.00,19.00,1995.00,'2022-10-26 14:40:06','',''),(628,'1','285','1',1,'Retail Sale Id 629',5040.00,0.00,0.00,7.00,735.00,'2022-10-26 14:43:47','',''),(629,'1','285','1',1,'Retail Sale Id 629',12528.00,0.00,0.00,17.40,1827.00,'2022-10-26 14:43:47','',''),(630,'1','285','1',1,'Return of Retail Sale Id 628',0.00,13680.00,19.00,0.00,-1995.00,'2022-10-26 14:46:50','',''),(631,'1','285','1',1,'Retail Sale Id 630',2001.60,0.00,0.00,2.78,291.90,'2022-10-26 15:22:15','',''),(632,'1','285','1',1,'Retail Sale Id 631',748.80,0.00,0.00,1.04,109.20,'2022-10-26 15:32:52','',''),(633,'1','285','1',1,'Retail Sale Id 632',1440.00,0.00,0.00,2.00,210.00,'2022-10-26 15:34:12','',''),(634,'1','285','1',1,'Retail Sale Id 633',720.00,0.00,0.00,1.00,105.00,'2022-10-26 15:55:42','',''),(635,'1','285','1',1,'Retail Sale Id 634',5760.00,0.00,0.00,8.00,840.00,'2022-10-26 15:57:49','',''),(636,'1','285','1',1,'Retail Sale Id 635',799.20,0.00,0.00,1.11,116.55,'2022-10-26 16:06:12','',''),(637,'1','285','1',1,'Retail Sale Id 636',1497.60,0.00,0.00,2.08,218.40,'2022-10-26 16:07:42','',''),(638,'1','285','1',1,'Retail Sale Id 637',9000.00,0.00,0.00,12.50,1312.50,'2022-10-26 16:29:01','',''),(639,'1','285','1',1,'Retail Sale Id 639',720.00,0.00,0.00,1.00,105.00,'2022-10-26 16:32:08','',''),(640,'1','285','1',1,'Retail Sale Id 640',2880.00,0.00,0.00,4.00,420.00,'2022-10-26 16:37:52','',''),(641,'1','285','1',1,'Retail Sale Id 642',27675.00,0.00,0.00,41.00,2460.00,'2022-10-26 16:40:49','',''),(642,'1','285','1',1,'Retail Sale Id 643',1000.80,0.00,0.00,1.39,145.95,'2022-10-26 16:42:18','',''),(643,'1','285','1',1,'Retail Sale Id 645',23625.00,0.00,0.00,35.00,2100.00,'2022-10-26 16:46:26','',''),(644,'1','285','1',1,'Return of Retail Sale Id 640',0.00,2880.00,4.00,0.00,-420.00,'2022-10-26 17:34:10','',''),(645,'1','285','1',1,'Retail Sale Id 646',2383.20,0.00,0.00,3.31,347.55,'2022-10-26 17:35:03','',''),(646,'1','285','1',1,'Return of Retail Sale Id 645',0.00,23625.00,35.00,0.00,-2100.00,'2022-10-26 17:36:40','',''),(647,'1','285','1',1,'Retail Sale Id 647',23679.00,0.00,0.00,35.08,2104.80,'2022-10-26 17:37:29','',''),(648,'1','285','1',1,'Retail Sale Id 648',14.40,0.00,0.00,0.02,2.10,'2022-10-26 18:16:04','',''),(649,'1','285','1',1,'Retail Sale Id 649',41296.50,0.00,0.00,61.18,3670.80,'2022-10-27 07:05:38','',''),(650,'1','285','1',1,'Retail Sale Id 650',2160.00,0.00,0.00,3.00,315.00,'2022-10-27 07:06:23','',''),(651,'1','285','1',1,'Retail Sale Id 651',1440.00,0.00,0.00,2.00,210.00,'2022-10-27 07:07:29','',''),(652,'1','285','1',1,'Retail Sale Id 652',23625.00,0.00,0.00,35.00,2100.00,'2022-10-27 07:09:36','',''),(653,'1','285','1',1,'Retail Sale Id 653',799.20,0.00,0.00,1.11,116.55,'2022-10-27 07:14:47','',''),(654,'1','285','1',1,'Retail Sale Id 654',83983.50,0.00,0.00,124.42,7465.20,'2022-10-27 07:20:53','',''),(655,'1','285','1',1,'Retail Sale Id 655',1440.00,0.00,0.00,2.00,210.00,'2022-10-27 07:23:40','',''),(656,'1','285','1',1,'Retail Sale Id 656',2880.00,0.00,0.00,4.00,420.00,'2022-10-27 07:29:20','',''),(657,'1','285','1',1,'Retail Sale Id 657',2001.60,0.00,0.00,2.78,291.90,'2022-10-27 07:30:22','',''),(658,'1','285','1',1,'Retail Sale Id 658',1497.60,0.00,0.00,2.08,218.40,'2022-10-27 07:31:47','',''),(659,'1','285','1',1,'Retail Sale Id 659',1000.80,0.00,0.00,1.39,145.95,'2022-10-27 07:40:14','',''),(660,'1','285','1',1,'Retail Sale Id 660',2498.40,0.00,0.00,3.47,364.35,'2022-10-27 07:45:02','',''),(661,'1','285','1',1,'Retail Sale Id 661',41040.00,0.00,0.00,60.80,3648.00,'2022-10-27 07:46:52','',''),(662,'1','285','1',1,'Retail Sale Id 662',41640.75,0.00,0.00,61.69,3701.40,'2022-10-27 08:01:56','',''),(663,'1','285','1',1,'Retail Sale Id 663',91658.25,0.00,0.00,135.79,8147.40,'2022-10-27 08:03:34','',''),(664,'1','285','1',1,'Retail Sale Id 664',1000.80,0.00,0.00,1.39,145.95,'2022-10-27 08:04:49','',''),(665,'1','285','1',1,'Retail Sale Id 665',33750.00,0.00,0.00,50.00,3000.00,'2022-10-27 08:07:43','',''),(666,'1','285','1',1,'Retail Sale Id 666',33750.00,0.00,0.00,50.00,3000.00,'2022-10-27 08:09:06','',''),(667,'1','285','1',1,'Retail Sale Id 667',11947.50,0.00,0.00,17.70,1062.00,'2022-10-27 08:13:01','',''),(668,'1','285','1',1,'Retail Sale Id 668',4298.40,0.00,0.00,5.97,626.85,'2022-10-27 08:18:48','',''),(669,'1','285','1',1,'Retail Sale Id 669',720.00,0.00,0.00,1.00,105.00,'2022-10-27 08:20:38','',''),(670,'1','285','1',1,'Retail Sale Id 670',2880.00,0.00,0.00,4.00,420.00,'2022-10-27 08:23:01','',''),(671,'1','285','1',1,'Retail Sale Id 672',2203.20,0.00,0.00,3.06,321.30,'2022-10-27 08:33:01','',''),(672,'1','285','1',1,'Retail Sale Id 673',1447.20,0.00,0.00,2.01,211.05,'2022-10-27 08:34:19','',''),(673,'1','285','1',1,'Retail Sale Id 674',9450.00,0.00,0.00,14.00,840.00,'2022-10-27 08:44:16','',''),(674,'1','285','1',1,'Retail Sale Id 675',2203.20,0.00,0.00,3.06,321.30,'2022-10-27 08:51:44','',''),(675,'1','285','1',1,'Retail Sale Id 676',41175.00,0.00,0.00,61.00,3660.00,'2022-10-27 09:06:13','',''),(676,'1','285','1',1,'Retail Sale Id 677',799.20,0.00,0.00,1.11,116.55,'2022-10-27 09:23:23','',''),(677,'1','285','1',1,'Retail Sale Id 678',44563.50,0.00,0.00,66.02,3961.20,'2022-10-27 09:37:47','',''),(678,'1','285','1',1,'Retail Sale Id 679',1497.60,0.00,0.00,2.08,218.40,'2022-10-27 09:42:04','',''),(679,'1','285','1',1,'Retail Sale Id 680',799.20,0.00,0.00,1.11,116.55,'2022-10-27 09:43:17','',''),(680,'1','285','1',1,'Retail Sale Id 681',1497.60,0.00,0.00,2.08,218.40,'2022-10-27 09:44:26','',''),(681,'1','285','1',1,'Retail Sale Id 682',748.80,0.00,0.00,1.04,109.20,'2022-10-27 09:46:00','',''),(682,'1','285','1',1,'Retail Sale Id 683',41910.75,0.00,0.00,62.09,3725.40,'2022-10-27 09:55:03','',''),(683,'1','285','1',1,'Retail Sale Id 684',1000.80,0.00,0.00,1.39,145.95,'2022-10-27 09:56:24','',''),(684,'1','285','1',1,'Retail Sale Id 685',2880.00,0.00,0.00,4.00,420.00,'2022-10-27 10:00:12','',''),(685,'1','285','1',1,'Retail Sale Id 686',40500.00,0.00,0.00,60.00,3600.00,'2022-10-27 10:02:13','',''),(686,'1','285','1',1,'Retail Sale Id 687',2160.00,0.00,0.00,3.00,315.00,'2022-10-27 10:04:44','',''),(687,'1','285','1',1,'Retail Sale Id 688',33750.00,0.00,0.00,50.00,3000.00,'2022-10-27 10:09:04','',''),(688,'1','285','1',1,'Retail Sale Id 689',2880.00,0.00,0.00,4.00,420.00,'2022-10-27 10:21:55','',''),(689,'1','285','1',1,'Retail Sale Id 690',799.20,0.00,0.00,1.11,116.55,'2022-10-27 10:28:20','',''),(690,'1','285','1',1,'Retail Sale Id 691',1000.80,0.00,0.00,1.39,145.95,'2022-10-27 10:38:46','',''),(691,'1','285','1',1,'Retail Sale Id 692',10125.00,0.00,0.00,15.00,900.00,'2022-10-27 10:44:31','',''),(692,'1','285','1',1,'Retail Sale Id 693',1440.00,0.00,0.00,2.00,210.00,'2022-10-27 10:50:20','',''),(693,'1','285','1',1,'Retail Sale Id 695',5500.80,0.00,0.00,7.64,802.20,'2022-10-27 10:52:16','',''),(694,'1','285','1',1,'Retail Sale Id 696',1699.20,0.00,0.00,2.36,247.80,'2022-10-27 10:55:16','',''),(695,'1','285','1',1,'Retail Sale Id 697',4320.00,0.00,0.00,6.00,630.00,'2022-10-27 11:21:35','',''),(696,'1','285','1',1,'Retail Sale Id 698',4003.20,0.00,0.00,5.56,583.80,'2022-10-27 11:50:01','',''),(697,'1','285','1',1,'Retail Sale Id 699',1000.80,0.00,0.00,1.39,145.95,'2022-10-27 12:06:28','',''),(698,'1','285','1',1,'Retail Sale Id 700',33750.00,0.00,0.00,50.00,3000.00,'2022-10-27 12:07:20','',''),(699,'1','285','1',1,'Retail Sale Id 701',2203.20,0.00,0.00,3.06,321.30,'2022-10-27 12:20:03','',''),(700,'1','285','1',1,'Retail Sale Id 702',3196.80,0.00,0.00,4.44,466.20,'2022-10-27 12:28:37','',''),(701,'1','285','1',1,'Retail Sale Id 703',45866.25,0.00,0.00,67.95,4077.00,'2022-10-27 12:32:28','',''),(702,'1','285','1',1,'Retail Sale Id 705',1440.00,0.00,0.00,2.00,210.00,'2022-10-27 12:37:03','',''),(703,'1','285','1',1,'Retail Sale Id 706',51300.00,0.00,0.00,76.00,4560.00,'2022-10-27 12:54:05','',''),(704,'1','285','1',1,'Retail Sale Id 707',1440.00,0.00,0.00,2.00,210.00,'2022-10-27 13:14:05','',''),(705,'1','285','1',1,'Retail Sale Id 708',41168.25,0.00,0.00,60.99,3659.40,'2022-10-27 13:58:23','',''),(706,'1','285','1',1,'Retail Sale Id 709',2880.00,0.00,0.00,4.00,420.00,'2022-10-27 14:10:07','',''),(707,'1','285','1',1,'Retail Sale Id 710',2880.00,0.00,0.00,4.00,420.00,'2022-10-27 14:30:40','',''),(708,'1','285','1',1,'Retail Sale Id 711',2203.20,0.00,0.00,3.06,321.30,'2022-10-27 14:38:06','',''),(709,'1','285','1',1,'Retail Sale Id 712',2880.00,0.00,0.00,4.00,420.00,'2022-10-27 14:58:39','',''),(710,'1','285','1',1,'Retail Sale Id 713',5997.60,0.00,0.00,8.33,874.65,'2022-10-27 15:04:35','',''),(711,'1','285','1',1,'Retail Sale Id 714',7200.00,0.00,0.00,10.00,1050.00,'2022-10-27 15:05:21','',''),(712,'1','285','1',1,'Retail Sale Id 716',1497.60,0.00,0.00,2.08,218.40,'2022-10-27 15:40:44','',''),(713,'1','285','1',1,'Retail Sale Id 717',9450.00,0.00,0.00,14.00,840.00,'2022-10-27 15:42:01','',''),(714,'1','285','1',1,'Retail Sale Id 718',25312.50,0.00,0.00,37.50,2250.00,'2022-10-27 15:58:05','',''),(715,'1','285','1',1,'Retail Sale Id 719',10080.00,0.00,0.00,14.00,1470.00,'2022-10-27 16:15:06','',''),(716,'1','285','1',1,'Retail Sale Id 721',47250.00,0.00,0.00,70.00,4200.00,'2022-10-27 16:25:31','',''),(717,'1','285','1',1,'Retail Sale Id 722',2203.20,0.00,0.00,3.06,321.30,'2022-10-27 16:27:01','',''),(718,'1','285','1',1,'Retail Sale Id 723',7948.80,0.00,0.00,11.04,1159.20,'2022-10-27 16:31:59','',''),(719,'1','285','1',1,'Retail Sale Id 724',2901.60,0.00,0.00,4.03,423.15,'2022-10-27 16:40:50','',''),(720,'1','285','1',1,'Retail Sale Id 725',1497.60,0.00,0.00,2.08,218.40,'2022-10-27 16:44:01','',''),(721,'1','285','1',1,'Retail Sale Id 726',4320.00,0.00,0.00,6.00,630.00,'2022-10-27 16:45:54','',''),(722,'1','285','1',1,'Retail Sale Id 727',4996.80,0.00,0.00,6.94,728.70,'2022-10-27 16:51:40','',''),(723,'1','285','1',1,'Retail Sale Id 728',55350.00,0.00,0.00,82.00,4920.00,'2022-10-27 16:54:43','',''),(724,'1','285','1',1,'Retail Sale Id 729',13803.75,0.00,0.00,20.45,1227.00,'2022-10-27 16:59:47','',''),(725,'1','285','1',1,'Retail Sale Id 730',40250.25,0.00,0.00,59.63,3577.80,'2022-10-27 17:04:35','',''),(726,'1','285','1',1,'Retail Sale Id 731',41411.25,0.00,0.00,61.35,3681.00,'2022-10-27 17:19:21','',''),(727,'1','285','1',1,'Return of Retail Sale Id 727',0.00,4996.80,6.94,0.00,-728.70,'2022-10-27 17:25:44','',''),(728,'1','285','1',1,'Retail Sale Id 732',4384.80,0.00,0.00,6.09,639.45,'2022-10-27 17:26:47','',''),(729,'1','285','1',1,'Retail Sale Id 733',2160.00,0.00,0.00,3.00,315.00,'2022-10-27 18:42:17','',''),(730,'1','285','1',1,'Return of Retail Sale Id 731',0.00,41411.25,61.35,0.00,-3681.00,'2022-10-27 19:00:12','',''),(731,'1','285','1',1,'Retail Sale Id 734',39663.00,0.00,0.00,58.76,3525.60,'2022-10-27 19:02:16','',''),(732,'1','285','1',1,'Retail Sale Id 735',2880.00,0.00,0.00,4.00,420.00,'2022-10-28 07:16:05','',''),(733,'1','285','1',1,'Retail Sale Id 736',799.20,0.00,0.00,1.11,116.55,'2022-10-28 07:21:51','',''),(734,'1','285','1',1,'Retail Sale Id 737',1497.60,0.00,0.00,2.08,218.40,'2022-10-28 07:23:10','',''),(735,'1','285','1',1,'Retail Sale Id 738',5040.00,0.00,0.00,7.00,735.00,'2022-10-28 07:25:47','',''),(736,'1','285','1',1,'Retail Sale Id 739',1440.00,0.00,0.00,2.00,210.00,'2022-10-28 07:31:58','',''),(737,'1','285','1',1,'Retail Sale Id 740',77625.00,0.00,0.00,115.00,6900.00,'2022-10-28 07:34:44','',''),(738,'1','285','1',1,'Retail Sale Id 741',21998.25,0.00,0.00,32.59,1955.40,'2022-10-28 07:39:53','',''),(739,'1','285','1',1,'Retail Sale Id 742',720.00,0.00,0.00,1.00,105.00,'2022-10-28 07:42:16','',''),(740,'1','285','1',1,'Retail Sale Id 743',1497.60,0.00,0.00,2.08,218.40,'2022-10-28 07:44:44','',''),(741,'1','285','1',1,'Retail Sale Id 744',720.00,0.00,0.00,1.00,105.00,'2022-10-28 08:05:58','',''),(742,'1','285','1',1,'Retail Sale Id 746',3600.00,0.00,0.00,5.00,525.00,'2022-10-28 08:07:48','',''),(743,'1','285','1',1,'Retail Sale Id 747',43854.75,0.00,0.00,64.97,3898.20,'2022-10-28 08:09:59','',''),(744,'1','285','1',1,'Retail Sale Id 748',720.00,0.00,0.00,1.00,105.00,'2022-10-28 08:14:10','',''),(745,'1','285','1',1,'Retail Sale Id 749',720.00,0.00,0.00,1.00,105.00,'2022-10-28 08:16:00','',''),(746,'1','285','1',1,'Retail Sale Id 751',2880.00,0.00,0.00,4.00,420.00,'2022-10-28 08:17:27','',''),(747,'1','285','1',1,'Retail Sale Id 752',3002.40,0.00,0.00,4.17,437.85,'2022-10-28 08:24:48','',''),(748,'1','285','1',1,'Retail Sale Id 753',57921.75,0.00,0.00,85.81,5148.60,'2022-10-28 08:29:27','',''),(749,'1','285','1',1,'Retail Sale Id 754',11913.75,0.00,0.00,17.65,1059.00,'2022-10-28 08:39:50','',''),(750,'1','285','1',1,'Retail Sale Id 755',1497.60,0.00,0.00,2.08,218.40,'2022-10-28 08:51:08','',''),(751,'1','285','1',1,'Retail Sale Id 756',33750.00,0.00,0.00,50.00,3000.00,'2022-10-28 08:57:31','',''),(752,'1','285','1',1,'Retail Sale Id 758',41661.00,0.00,0.00,61.72,3703.20,'2022-10-28 09:02:05','',''),(753,'1','285','1',1,'Retail Sale Id 760',116390.25,0.00,0.00,172.43,10345.80,'2022-10-28 09:03:52','',''),(754,'1','285','1',1,'Retail Sale Id 761',1000.80,0.00,0.00,1.39,145.95,'2022-10-28 09:08:12','',''),(755,'1','285','1',1,'Retail Sale Id 762',33750.00,0.00,0.00,50.00,3000.00,'2022-10-28 09:13:20','',''),(756,'1','285','1',1,'Retail Sale Id 763',41357.25,0.00,0.00,61.27,3676.20,'2022-10-28 09:22:41','',''),(757,'1','285','1',1,'Retail Sale Id 764',2880.00,0.00,0.00,4.00,420.00,'2022-10-28 09:30:24','',''),(758,'1','285','1',1,'Retail Sale Id 765',720.00,0.00,0.00,1.00,105.00,'2022-10-28 09:31:59','',''),(759,'1','285','1',1,'Retail Sale Id 766',2880.00,0.00,0.00,4.00,420.00,'2022-10-28 09:47:45','',''),(760,'1','285','1',1,'Retail Sale Id 768',1440.00,0.00,0.00,2.00,210.00,'2022-10-28 10:03:47','',''),(761,'1','285','1',1,'Retail Sale Id 769',83517.75,0.00,0.00,123.73,7423.80,'2022-10-28 10:08:16','',''),(762,'1','285','1',1,'Retail Sale Id 770',41445.00,0.00,0.00,61.40,3684.00,'2022-10-28 10:20:28','',''),(763,'1','285','1',1,'Retail Sale Id 771',81918.00,0.00,0.00,121.36,7281.60,'2022-10-28 10:35:31','',''),(764,'1','285','1',1,'Retail Sale Id 773',83092.50,0.00,0.00,123.10,7386.00,'2022-10-28 10:44:43','',''),(765,'1','285','1',1,'Return of Retail Sale Id 769',0.00,83517.75,123.73,0.00,-7423.80,'2022-10-28 10:51:20','',''),(766,'1','285','1',1,'Retail Sale Id 774',40500.00,0.00,0.00,60.00,3600.00,'2022-10-28 10:56:58','',''),(767,'1','285','1',1,'Retail Sale Id 775',16227.00,0.00,0.00,24.04,1442.40,'2022-10-28 11:03:13','',''),(768,'1','285','1',1,'Retail Sale Id 776',74985.75,0.00,0.00,111.09,6665.40,'2022-10-28 11:05:24','',''),(769,'1','285','1',1,'Retail Sale Id 777',720.00,0.00,0.00,1.00,105.00,'2022-10-28 11:08:25','',''),(770,'1','285','1',1,'Retail Sale Id 778',1000.80,0.00,0.00,1.39,145.95,'2022-10-28 11:21:23','',''),(771,'1','285','1',1,'Retail Sale Id 780',2203.20,0.00,0.00,3.06,321.30,'2022-10-28 11:42:26','',''),(772,'1','285','1',1,'Retail Sale Id 781',720.00,0.00,0.00,1.00,105.00,'2022-10-28 11:51:29','',''),(773,'1','285','1',1,'Return of Retail Sale Id 781',0.00,720.00,1.00,0.00,-105.00,'2022-10-28 11:51:59','',''),(774,'1','285','1',1,'Retail Sale Id 782',799.20,0.00,0.00,1.11,116.55,'2022-10-28 11:53:17','',''),(775,'1','285','1',1,'Retail Sale Id 783',1497.60,0.00,0.00,2.08,218.40,'2022-10-28 11:55:21','',''),(776,'1','285','1',1,'Retail Sale Id 784',27000.00,0.00,0.00,40.00,2400.00,'2022-10-28 12:00:24','',''),(777,'1','285','1',1,'Retail Sale Id 785',1497.60,0.00,0.00,2.08,218.40,'2022-10-28 12:02:52','',''),(778,'1','285','1',1,'Retail Sale Id 786',40500.00,0.00,0.00,60.00,3600.00,'2022-10-28 12:24:37','',''),(779,'1','285','1',1,'Retail Sale Id 787',81000.00,0.00,0.00,120.00,7200.00,'2022-10-28 12:27:41','',''),(780,'1','285','1',1,'Retail Sale Id 790',19899.00,0.00,0.00,29.48,1768.80,'2022-10-28 12:31:55','',''),(781,'1','285','1',1,'Retail Sale Id 791',720.00,0.00,0.00,1.00,105.00,'2022-10-28 12:43:52','',''),(782,'1','285','1',1,'Retail Sale Id 793',3600.00,0.00,0.00,5.00,525.00,'2022-10-28 12:48:31','',''),(783,'1','285','1',1,'Retail Sale Id 794',41134.50,0.00,0.00,60.94,3656.40,'2022-10-28 15:28:41','',''),(784,'1','285','1',1,'Retail Sale Id 795',34715.25,0.00,0.00,51.43,3085.80,'2022-10-28 15:30:17','',''),(785,'1','285','1',1,'Retail Sale Id 796',40837.50,0.00,0.00,60.50,3630.00,'2022-10-28 15:34:40','',''),(786,'1','285','1',1,'Retail Sale Id 797',720.00,0.00,0.00,1.00,105.00,'2022-10-28 15:35:33','',''),(787,'1','285','1',1,'Retail Sale Id 798',14850.00,0.00,0.00,22.00,1320.00,'2022-10-28 15:36:56','',''),(788,'1','285','1',1,'Retail Sale Id 799',16200.00,0.00,0.00,24.00,1440.00,'2022-10-28 15:39:16','',''),(789,'1','285','1',1,'Retail Sale Id 800',28350.00,0.00,0.00,42.00,2520.00,'2022-10-28 15:40:28','',''),(790,'1','285','1',1,'Retail Sale Id 801',9000.00,0.00,0.00,12.50,1312.50,'2022-10-28 15:57:58','',''),(791,'1','285','1',1,'Retail Sale Id 802',4320.00,0.00,0.00,6.00,630.00,'2022-10-28 16:04:24','',''),(792,'1','285','1',1,'Retail Sale Id 803',2160.00,0.00,0.00,3.00,315.00,'2022-10-28 16:21:48','',''),(793,'1','285','1',1,'Retail Sale Id 804',3600.00,0.00,0.00,5.00,525.00,'2022-10-28 16:24:00','',''),(794,'1','285','1',1,'Retail Sale Id 805',41418.00,0.00,0.00,61.36,3681.60,'2022-10-28 16:35:41','',''),(795,'1','285','1',1,'Retail Sale Id 806',1497.60,0.00,0.00,2.08,218.40,'2022-10-28 16:39:34','',''),(796,'1','285','1',1,'Retail Sale Id 807',22707.00,0.00,0.00,33.64,2018.40,'2022-10-28 16:41:25','',''),(797,'1','285','1',1,'Retail Sale Id 808',40500.00,0.00,0.00,60.00,3600.00,'2022-10-28 16:44:05','',''),(798,'1','285','1',1,'Retail Sale Id 809',799.20,0.00,0.00,1.11,116.55,'2022-10-28 16:45:13','',''),(799,'1','285','1',1,'Retail Sale Id 810',799.20,0.00,0.00,1.11,116.55,'2022-10-28 16:47:04','',''),(800,'1','285','1',1,'Retail Sale Id 811',62484.75,0.00,0.00,92.57,5554.20,'2022-10-28 16:50:19','',''),(801,'1','285','1',1,'Retail Sale Id 812',2880.00,0.00,0.00,4.00,420.00,'2022-10-28 16:52:35','',''),(802,'1','285','1',1,'Retail Sale Id 813',799.20,0.00,0.00,1.11,116.55,'2022-10-28 16:54:03','',''),(803,'1','285','1',1,'Retail Sale Id 814',10125.00,0.00,0.00,15.00,900.00,'2022-10-28 16:55:32','',''),(804,'1','285','1',1,'Retail Sale Id 815',2800.80,0.00,0.00,3.89,408.45,'2022-10-28 16:57:00','',''),(805,'1','285','1',1,'Retail Sale Id 816',2541.60,0.00,0.00,3.53,370.65,'2022-10-28 17:15:30','',''),(806,'1','285','1',1,'Retail Sale Id 817',7.20,0.00,0.00,0.01,1.05,'2022-10-28 18:54:53','',''),(807,'1','285','1',1,'Retail Sale Id 818',1950.75,0.00,0.00,2.89,173.40,'2022-10-28 18:58:04','',''),(808,'1','285','1',1,'Retail Sale Id 819',20250.00,0.00,0.00,30.00,1800.00,'2022-10-29 10:14:45','',''),(809,'1','285','1',1,'Retail Sale Id 820',41283.00,0.00,0.00,61.16,3669.60,'2022-10-29 10:17:00','',''),(810,'1','285','1',1,'Retail Sale Id 821',43267.50,0.00,0.00,64.10,3846.00,'2022-10-29 10:18:14','',''),(811,'1','285','1',1,'Retail Sale Id 822',40500.00,0.00,0.00,60.00,3600.00,'2022-10-29 10:19:55','',''),(812,'1','285','1',1,'Retail Sale Id 823',27000.00,0.00,0.00,40.00,2400.00,'2022-10-29 10:21:42','',''),(813,'1','285','1',1,'Retail Sale Id 825',455928.30,0.00,0.00,680.49,37426.95,'2022-10-29 10:31:35','',''),(814,'1','285','1',1,'Retail Sale Id 826',3600.00,0.00,0.00,5.00,525.00,'2022-10-29 10:39:20','',''),(815,'1','285','1',1,'Retail Sale Id 827',40500.00,0.00,0.00,60.00,3600.00,'2022-10-29 10:43:35','',''),(816,'1','285','1',1,'Retail Sale Id 828',30375.00,0.00,0.00,45.00,2700.00,'2022-10-29 10:50:49','',''),(817,'1','285','1',1,'Retail Sale Id 829',1497.60,0.00,0.00,2.08,218.40,'2022-10-29 10:52:50','',''),(818,'1','285','1',1,'Retail Sale Id 831',2203.20,0.00,0.00,3.06,321.30,'2022-10-29 10:54:21','',''),(819,'1','285','1',1,'Retail Sale Id 832',2203.20,0.00,0.00,3.06,321.30,'2022-10-29 10:56:34','',''),(820,'1','285','1',1,'Retail Sale Id 833',9841.50,0.00,0.00,14.58,874.80,'2022-10-29 11:05:46','',''),(821,'1','285','1',1,'Retail Sale Id 834',2203.20,0.00,0.00,3.06,321.30,'2022-10-29 11:08:30','',''),(822,'1','285','1',1,'Retail Sale Id 835',41715.00,0.00,0.00,61.80,3708.00,'2022-10-29 11:30:55','',''),(823,'1','285','1',1,'Retail Sale Id 836',206786.25,0.00,0.00,306.35,18381.00,'2022-10-29 11:32:10','',''),(824,'1','285','1',1,'Retail Sale Id 837',41863.50,0.00,0.00,62.02,3721.20,'2022-10-29 11:52:09','',''),(825,'1','285','1',1,'Retail Sale Id 839',56261.25,0.00,0.00,83.35,5001.00,'2022-10-29 11:58:54','',''),(826,'1','285','1',1,'Retail Sale Id 840',1562.40,0.00,0.00,2.17,227.85,'2022-10-29 12:03:02','',''),(827,'1','285','1',1,'Retail Sale Id 841',21728.25,0.00,0.00,32.19,1931.40,'2022-10-29 12:49:28','',''),(828,'1','285','1',1,'Retail Sale Id 842',1440.00,0.00,0.00,2.00,210.00,'2022-10-29 12:53:21','',''),(829,'1','285','1',1,'Retail Sale Id 843',3636.00,0.00,0.00,5.05,530.25,'2022-10-29 12:56:13','',''),(830,'1','285','1',1,'Retail Sale Id 844',1468.80,0.00,0.00,2.04,214.20,'2022-10-29 12:56:51','',''),(831,'1','285','1',1,'Retail Sale Id 845',5796.00,0.00,0.00,8.05,845.25,'2022-10-29 12:57:35','',''),(832,'1','285','1',1,'Retail Sale Id 846',45640.80,0.00,0.00,63.39,6655.95,'2022-10-29 12:58:37','',''),(833,'1','285','1',1,'Return of Retail Sale Id 846',0.00,45640.80,63.39,0.00,-6655.95,'2022-10-29 12:59:25','',''),(834,'1','285','1',1,'Retail Sale Id 847',4600.80,0.00,0.00,6.39,670.95,'2022-10-29 13:00:28','',''),(835,'1','285','1',1,'Retail Sale Id 848',4399.20,0.00,0.00,6.11,641.55,'2022-10-29 13:02:46','',''),(836,'1','285','1',1,'Retail Sale Id 850',3600.00,0.00,0.00,5.00,525.00,'2022-10-29 13:03:47','',''),(837,'1','285','1',1,'Retail Sale Id 851',2995.20,0.00,0.00,4.16,436.80,'2022-10-29 13:04:43','',''),(838,'1','285','1',1,'Retail Sale Id 852',2959.20,0.00,0.00,4.11,431.55,'2022-10-29 13:05:22','',''),(839,'1','285','1',1,'Retail Sale Id 853',2196.00,0.00,0.00,3.05,320.25,'2022-10-29 13:06:20','',''),(840,'1','285','1',1,'Retail Sale Id 854',2880.00,0.00,0.00,4.00,420.00,'2022-10-29 13:07:14','',''),(841,'1','285','1',1,'Retail Sale Id 855',2196.00,0.00,0.00,3.05,320.25,'2022-10-29 13:08:17','',''),(842,'1','285','1',1,'Retail Sale Id 856',4320.00,0.00,0.00,6.00,630.00,'2022-10-29 13:09:01','',''),(843,'1','285','1',1,'Retail Sale Id 857',41782.50,0.00,0.00,61.90,3714.00,'2022-10-29 13:10:40','',''),(844,'1','285','1',1,'Retail Sale Id 858',17676.00,0.00,0.00,24.55,2577.75,'2022-10-29 13:21:55','',''),(845,'1','285','1',1,'Return of Retail Sale Id 858',0.00,17676.00,24.55,0.00,-2577.75,'2022-10-29 13:24:30','',''),(846,'1','285','1',1,'Retail Sale Id 859',16571.25,0.00,0.00,24.55,1473.00,'2022-10-29 13:25:22','',''),(847,'1','285','1',1,'Retail Sale Id 860',20250.00,0.00,0.00,30.00,1800.00,'2022-10-29 13:26:58','',''),(848,'1','285','1',1,'Retail Sale Id 861',2700.00,0.00,0.00,4.00,240.00,'2022-10-29 13:34:41','',''),(849,'1','285','1',1,'Retail Sale Id 862',2160.00,0.00,0.00,3.00,315.00,'2022-10-29 13:44:26','',''),(850,'1','285','1',1,'Retail Sale Id 863',5803.20,0.00,0.00,8.06,846.30,'2022-10-29 13:54:40','',''),(851,'1','285','1',1,'Retail Sale Id 864',3600.00,0.00,0.00,5.00,525.00,'2022-10-29 13:55:54','',''),(852,'1','285','1',1,'Retail Sale Id 865',799.20,0.00,0.00,1.11,116.55,'2022-10-29 13:57:29','',''),(853,'1','285','1',1,'Retail Sale Id 866',1497.60,0.00,0.00,2.08,218.40,'2022-10-29 13:59:34','',''),(854,'1','285','1',1,'Retail Sale Id 867',2203.20,0.00,0.00,3.06,321.30,'2022-10-29 14:13:21','',''),(855,'1','285','1',1,'Retail Sale Id 868',720.00,0.00,0.00,1.00,105.00,'2022-10-29 14:15:01','',''),(856,'1','285','1',1,'Retail Sale Id 869',5500.80,0.00,0.00,7.64,802.20,'2022-10-29 14:30:56','',''),(857,'1','285','1',1,'Retail Sale Id 870',1497.60,0.00,0.00,2.08,218.40,'2022-10-29 14:32:18','',''),(858,'1','285','1',1,'Retail Sale Id 871',748.80,0.00,0.00,1.04,109.20,'2022-10-29 14:49:56','',''),(859,'1','285','1',1,'Retail Sale Id 872',5040.00,0.00,0.00,7.00,735.00,'2022-10-29 14:51:42','',''),(860,'1','285','1',1,'Retail Sale Id 873',2901.60,0.00,0.00,4.03,423.15,'2022-10-29 14:53:24','',''),(861,'1','285','1',1,'Retail Sale Id 874',2498.40,0.00,0.00,3.47,364.35,'2022-10-29 14:59:28','',''),(862,'1','285','1',1,'Retail Sale Id 875',1497.60,0.00,0.00,2.08,218.40,'2022-10-29 15:05:45','',''),(863,'1','285','1',1,'Retail Sale Id 876',1497.60,0.00,0.00,2.08,218.40,'2022-10-29 15:10:00','',''),(864,'1','285','1',1,'Retail Sale Id 877',2880.00,0.00,0.00,4.00,420.00,'2022-10-29 15:24:47','',''),(865,'1','285','1',1,'Retail Sale Id 878',748.80,0.00,0.00,1.04,109.20,'2022-10-29 15:31:16','',''),(866,'1','285','1',1,'Retail Sale Id 880',1000.80,0.00,0.00,1.39,145.95,'2022-10-29 15:32:23','',''),(867,'1','285','1',1,'Retail Sale Id 881',748.80,0.00,0.00,1.04,109.20,'2022-10-29 15:40:49','',''),(868,'1','285','1',1,'Retail Sale Id 882',1497.60,0.00,0.00,2.08,218.40,'2022-10-29 15:44:25','',''),(869,'1','285','1',1,'Retail Sale Id 883',11886.75,0.00,0.00,17.61,1056.60,'2022-10-29 15:51:07','',''),(870,'1','285','1',1,'Retail Sale Id 884',32400.00,0.00,0.00,48.00,2880.00,'2022-10-29 15:54:39','',''),(871,'1','285','1',1,'Retail Sale Id 885',9000.00,0.00,0.00,12.50,1312.50,'2022-10-29 15:57:57','',''),(872,'1','285','1',1,'Retail Sale Id 886',799.20,0.00,0.00,1.11,116.55,'2022-10-29 15:59:34','',''),(873,'1','285','1',1,'Retail Sale Id 887',1497.60,0.00,0.00,2.08,218.40,'2022-10-29 16:00:49','',''),(874,'1','285','1',1,'Retail Sale Id 888',799.20,0.00,0.00,1.11,116.55,'2022-10-29 16:05:55','',''),(875,'1','285','1',1,'Retail Sale Id 889',1396.80,0.00,0.00,1.94,203.70,'2022-10-29 16:08:42','',''),(876,'1','285','1',1,'Retail Sale Id 890',40709.25,0.00,0.00,60.31,3618.60,'2022-10-29 16:17:03','',''),(877,'1','285','1',1,'Retail Sale Id 891',1000.80,0.00,0.00,1.39,145.95,'2022-10-29 16:25:09','',''),(878,'1','285','1',1,'Retail Sale Id 892',40182.75,0.00,0.00,59.53,3571.80,'2022-10-29 16:30:49','',''),(879,'1','285','1',1,'Return of Retail Sale Id 891',0.00,1000.80,1.39,0.00,-145.95,'2022-10-29 17:53:32','',''),(880,'1','285','1',1,'Return of Retail Sale Id 888',0.00,799.20,1.11,0.00,-116.55,'2022-10-29 17:54:39','',''),(881,'1','285','1',1,'Retail Sale Id 893',367.20,0.00,0.00,0.51,53.55,'2022-10-29 17:55:58','',''),(882,'1','285','1',1,'Retail Sale Id 894',1876.50,0.00,0.00,2.78,166.80,'2022-10-29 17:58:53','',''),(883,'1','285','1',1,'Retail Sale Id 895',1440.00,0.00,0.00,2.00,210.00,'2022-10-30 07:32:59','',''),(884,'1','285','1',1,'Retail Sale Id 896',168750.00,0.00,0.00,250.00,15000.00,'2022-10-30 07:37:42','',''),(885,'1','285','1',1,'Retail Sale Id 897',2160.00,0.00,0.00,3.00,315.00,'2022-10-30 07:45:03','',''),(886,'1','285','1',1,'Retail Sale Id 898',3600.00,0.00,0.00,5.00,525.00,'2022-10-30 07:46:08','',''),(887,'1','285','1',1,'Retail Sale Id 899',41688.00,0.00,0.00,61.76,3705.60,'2022-10-30 07:50:49','',''),(888,'1','285','1',1,'Retail Sale Id 900',41661.00,0.00,0.00,61.72,3703.20,'2022-10-30 07:52:04','',''),(889,'1','285','1',1,'Retail Sale Id 901',720.00,0.00,0.00,1.00,105.00,'2022-10-30 07:53:21','',''),(890,'1','285','1',1,'Retail Sale Id 902',2203.20,0.00,0.00,3.06,321.30,'2022-10-30 08:00:41','',''),(891,'1','285','1',1,'Retail Sale Id 903',1000.80,0.00,0.00,1.39,145.95,'2022-10-30 08:01:26','',''),(892,'1','285','1',1,'Retail Sale Id 904',748.80,0.00,0.00,1.04,109.20,'2022-10-30 08:02:06','',''),(893,'1','285','1',1,'Retail Sale Id 905',54000.00,0.00,0.00,80.00,4800.00,'2022-10-30 08:23:13','',''),(894,'1','285','1',1,'Retail Sale Id 906',51327.00,0.00,0.00,76.04,4562.40,'2022-10-30 08:32:39','',''),(895,'1','285','1',1,'Retail Sale Id 907',2203.20,0.00,0.00,3.06,321.30,'2022-10-30 08:36:59','',''),(896,'1','285','1',1,'Retail Sale Id 908',1440.00,0.00,0.00,2.00,210.00,'2022-10-30 08:45:07','',''),(897,'1','285','1',1,'Retail Sale Id 909',1000.80,0.00,0.00,1.39,145.95,'2022-10-30 08:58:51','',''),(898,'1','285','1',1,'Retail Sale Id 911',2160.00,0.00,0.00,3.00,315.00,'2022-10-30 09:10:29','',''),(899,'1','285','1',1,'Retail Sale Id 912',1440.00,0.00,0.00,2.00,210.00,'2022-10-30 09:12:12','',''),(900,'1','285','1',1,'Retail Sale Id 913',45717.75,0.00,0.00,67.73,4063.80,'2022-10-30 09:37:59','',''),(901,'1','285','1',1,'Retail Sale Id 914',45650.25,0.00,0.00,67.63,4057.80,'2022-10-30 09:40:58','',''),(902,'1','285','1',1,'Retail Sale Id 915',24300.00,0.00,0.00,36.00,2160.00,'2022-10-30 09:43:46','',''),(903,'1','285','1',1,'Retail Sale Id 916',2203.20,0.00,0.00,3.06,321.30,'2022-10-30 09:44:46','',''),(904,'1','285','1',1,'Retail Sale Id 917',23625.00,0.00,0.00,35.00,2100.00,'2022-10-30 09:45:30','',''),(905,'1','285','1',1,'Retail Sale Id 918',3002.40,0.00,0.00,4.17,437.85,'2022-10-30 10:12:38','',''),(906,'1','285','1',1,'Retail Sale Id 919',1497.60,0.00,0.00,2.08,218.40,'2022-10-30 10:13:27','',''),(907,'1','285','1',1,'Retail Sale Id 920',799.20,0.00,0.00,1.11,116.55,'2022-10-30 10:23:18','',''),(908,'1','285','1',1,'Retail Sale Id 921',799.20,0.00,0.00,1.11,116.55,'2022-10-30 10:24:19','',''),(909,'1','285','1',1,'Retail Sale Id 922',41377.50,0.00,0.00,61.30,3678.00,'2022-10-30 10:34:59','',''),(910,'1','285','1',1,'Retail Sale Id 923',2203.20,0.00,0.00,3.06,321.30,'2022-10-30 10:36:09','',''),(911,'1','285','1',1,'Retail Sale Id 924',799.20,0.00,0.00,1.11,116.55,'2022-10-30 10:38:43','',''),(912,'1','285','1',1,'Retail Sale Id 925',799.20,0.00,0.00,1.11,116.55,'2022-10-30 10:59:33','',''),(913,'1','285','1',1,'Retail Sale Id 926',2203.20,0.00,0.00,3.06,321.30,'2022-10-30 11:06:30','',''),(914,'1','285','1',1,'Retail Sale Id 927',720.00,0.00,0.00,1.00,105.00,'2022-10-30 11:09:19','',''),(915,'1','285','1',1,'Retail Sale Id 928',2203.20,0.00,0.00,3.06,321.30,'2022-10-30 11:14:51','',''),(916,'1','285','1',1,'Retail Sale Id 929',2001.60,0.00,0.00,2.78,291.90,'2022-10-30 11:15:40','',''),(917,'1','285','1',1,'Retail Sale Id 930',1440.00,0.00,0.00,2.00,210.00,'2022-10-30 11:17:58','',''),(918,'1','285','1',1,'Retail Sale Id 931',61006.50,0.00,0.00,90.38,5422.80,'2022-10-30 11:40:23','',''),(919,'1','285','1',1,'Retail Sale Id 932',2001.60,0.00,0.00,2.78,291.90,'2022-10-30 11:54:51','',''),(920,'1','285','1',1,'Retail Sale Id 933',1440.00,0.00,0.00,2.00,210.00,'2022-10-30 12:14:46','',''),(921,'1','285','1',1,'Retail Sale Id 934',10037.25,0.00,0.00,14.87,892.20,'2022-10-30 12:21:44','',''),(922,'1','285','1',1,'Retail Sale Id 935',1000.80,0.00,0.00,1.39,145.95,'2022-10-30 12:30:59','',''),(923,'1','285','1',1,'Retail Sale Id 936',2102.40,0.00,0.00,2.92,306.60,'2022-10-30 12:31:52','',''),(924,'1','285','1',1,'Retail Sale Id 937',1440.00,0.00,0.00,2.00,210.00,'2022-10-30 13:28:19','',''),(925,'1','285','1',1,'Retail Sale Id 938',2001.60,0.00,0.00,2.78,291.90,'2022-10-30 13:29:14','',''),(926,'1','285','1',1,'Retail Sale Id 939',3002.40,0.00,0.00,4.17,437.85,'2022-10-30 13:33:57','',''),(927,'1','285','1',1,'Retail Sale Id 940',1000.80,0.00,0.00,1.39,145.95,'2022-10-30 13:40:45','',''),(928,'1','285','1',1,'Return of Retail Sale Id 937',0.00,1440.00,2.00,0.00,-210.00,'2022-10-30 13:42:01','',''),(929,'1','285','1',1,'Retail Sale Id 941',14850.00,0.00,0.00,22.00,1320.00,'2022-10-30 13:43:55','',''),(930,'1','285','1',1,'Retail Sale Id 942',9000.00,0.00,0.00,12.50,1312.50,'2022-10-30 13:44:36','',''),(931,'1','285','1',1,'Retail Sale Id 943',47250.00,0.00,0.00,70.00,4200.00,'2022-10-30 13:45:09','',''),(932,'1','285','1',1,'Return of Retail Sale Id 940',0.00,1000.80,1.39,0.00,-145.95,'2022-10-30 13:51:57','',''),(933,'1','285','1',1,'Return of Retail Sale Id 943',0.00,47250.00,70.00,0.00,-4200.00,'2022-10-30 13:52:23','',''),(934,'1','285','1',1,'Return of Retail Sale Id 941',0.00,14850.00,22.00,0.00,-1320.00,'2022-10-30 13:56:21','',''),(935,'1','285','1',1,'Retail Sale Id 944',11475.00,0.00,0.00,17.00,1020.00,'2022-10-30 13:56:59','',''),(936,'1','285','1',1,'Retail Sale Id 945',3600.00,0.00,0.00,5.00,525.00,'2022-10-30 13:57:23','',''),(937,'1','285','1',1,'Return of Retail Sale Id 945',0.00,3600.00,5.00,0.00,-525.00,'2022-10-30 14:22:59','',''),(938,'1','285','1',1,'Retail Sale Id 946',2145.60,0.00,0.00,2.98,312.90,'2022-10-30 14:23:51','',''),(939,'1','285','1',1,'Return of Retail Sale Id 944',0.00,11475.00,17.00,0.00,-1020.00,'2022-10-30 14:25:08','',''),(940,'1','285','1',1,'Retail Sale Id 947',12872.25,0.00,0.00,19.07,1144.20,'2022-10-30 14:26:12','',''),(941,'1','285','1',1,'Distributed to AA RANO NIGERIA LTD for sales id:1',682293.30,0.00,0.00,1109.42,0.00,'2022-10-30 14:50:59','',''),(942,'1','285',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,11277000.00,17900.00,0.00,0.00,'2022-10-30 15:08:11','',''),(943,'1','285',NULL,1,'Reception corrector for bridging 2',0.00,0.00,0.00,17900.00,0.00,'2022-10-30 15:11:00','',''),(944,'1','285','1',1,'Received from bridging 2',0.00,0.00,17900.00,0.00,0.00,'2022-10-30 15:11:00','',''),(945,'1','285','1',1,'Retail Sale Id 948',2203.20,0.00,0.00,3.06,275.40,'2022-10-30 15:22:26','',''),(946,'1','285','1',1,'Retail Sale Id 949',3002.40,0.00,0.00,4.17,375.30,'2022-10-30 15:24:14','',''),(947,'1','285','1',1,'Retail Sale Id 950',3002.40,0.00,0.00,4.17,375.30,'2022-10-30 15:25:28','',''),(948,'1','285','1',1,'Retail Sale Id 952',2498.40,0.00,0.00,3.47,312.30,'2022-10-30 15:32:27','',''),(949,'1','285','1',1,'Retail Sale Id 953',47250.00,0.00,0.00,70.00,3150.00,'2022-10-30 15:47:37','',''),(950,'1','285','1',1,'Retail Sale Id 954',43875.00,0.00,0.00,65.00,2925.00,'2022-10-30 16:53:46','',''),(951,'1','285','1',1,'Retail Sale Id 955',99900.00,0.00,0.00,148.00,6660.00,'2022-10-30 16:57:34','',''),(952,'1','285','1',1,'Return of Retail Sale Id 954',0.00,43875.00,65.00,0.00,-2925.00,'2022-10-30 18:48:25','',''),(953,'1','285','1',1,'Retail Sale Id 956',43632.00,0.00,0.00,64.64,2908.80,'2022-10-30 18:49:36','',''),(954,'1','285','1',1,'Retail Sale Id 957',1497.60,0.00,0.00,2.08,187.20,'2022-10-31 07:40:59','',''),(955,'1','285','1',1,'Retail Sale Id 958',41971.50,0.00,0.00,62.18,2798.10,'2022-10-31 07:47:40','',''),(956,'1','285','1',1,'Retail Sale Id 959',42518.25,0.00,0.00,62.99,2834.55,'2022-10-31 07:54:04','',''),(957,'1','285','1',1,'Retail Sale Id 960',41971.50,0.00,0.00,62.18,2798.10,'2022-10-31 07:56:01','',''),(958,'1','285','1',1,'Retail Sale Id 961',1497.60,0.00,0.00,2.08,187.20,'2022-10-31 07:57:07','',''),(959,'1','285','1',1,'Retail Sale Id 962',5191.20,0.00,0.00,7.21,648.90,'2022-10-31 08:00:51','',''),(960,'1','285','1',1,'Retail Sale Id 963',3988.80,0.00,0.00,5.54,498.60,'2022-10-31 08:02:20','',''),(961,'1','285','1',1,'Retail Sale Id 964',4989.60,0.00,0.00,6.93,623.70,'2022-10-31 08:03:25','',''),(962,'1','285','1',1,'Retail Sale Id 965',5234.40,0.00,0.00,7.27,654.30,'2022-10-31 08:05:12','',''),(963,'1','285','1',1,'Retail Sale Id 966',37125.00,0.00,0.00,55.00,2475.00,'2022-10-31 08:07:50','',''),(964,'1','285','1',1,'Retail Sale Id 967',5760.00,0.00,0.00,8.00,720.00,'2022-10-31 08:09:47','',''),(965,'1','285','1',1,'Retail Sale Id 968',2001.60,0.00,0.00,2.78,250.20,'2022-10-31 08:13:10','',''),(966,'1','285','1',1,'Retail Sale Id 969',1000.80,0.00,0.00,1.39,125.10,'2022-10-31 08:14:26','',''),(967,'1','285','1',1,'Retail Sale Id 970',27000.00,0.00,0.00,40.00,1800.00,'2022-10-31 08:20:08','',''),(968,'1','285','1',1,'Retail Sale Id 971',3600.00,0.00,0.00,5.00,450.00,'2022-10-31 08:23:00','',''),(969,'1','285','1',1,'Retail Sale Id 972',41843.25,0.00,0.00,61.99,2789.55,'2022-10-31 08:25:12','',''),(970,'1','285','1',1,'Retail Sale Id 973',42457.50,0.00,0.00,62.90,2830.50,'2022-10-31 08:26:52','',''),(971,'1','285','1',1,'Retail Sale Id 974',20844.00,0.00,0.00,30.88,1389.60,'2022-10-31 08:32:07','',''),(972,'1','285','1',1,'Retail Sale Id 975',4500.00,0.00,0.00,6.25,562.50,'2022-10-31 08:33:46','',''),(973,'1','285','1',1,'Retail Sale Id 976',2880.00,0.00,0.00,4.00,360.00,'2022-10-31 08:35:39','',''),(974,'1','285','1',1,'Retail Sale Id 977',40500.00,0.00,0.00,60.00,2700.00,'2022-10-31 08:37:17','',''),(975,'1','285','1',1,'Retail Sale Id 978',5803.20,0.00,0.00,8.06,725.40,'2022-10-31 08:40:58','',''),(976,'1','285','1',1,'Retail Sale Id 979',799.20,0.00,0.00,1.11,99.90,'2022-10-31 08:42:59','',''),(977,'1','285','1',1,'Retail Sale Id 980',2800.80,0.00,0.00,3.89,350.10,'2022-10-31 08:46:24','',''),(978,'1','285','1',1,'Retail Sale Id 981',2001.60,0.00,0.00,2.78,250.20,'2022-10-31 08:48:43','',''),(979,'1','285','1',1,'Retail Sale Id 982',4348.80,0.00,0.00,6.04,543.60,'2022-10-31 08:50:06','',''),(980,'1','285','1',1,'Retail Sale Id 983',2880.00,0.00,0.00,4.00,360.00,'2022-10-31 08:52:37','',''),(981,'1','285','1',1,'Retail Sale Id 984',41586.75,0.00,0.00,61.61,2772.45,'2022-10-31 08:56:30','',''),(982,'1','285','1',1,'Retail Sale Id 985',40500.00,0.00,0.00,60.00,2700.00,'2022-10-31 09:03:52','',''),(983,'1','285','1',1,'Retail Sale Id 986',799.20,0.00,0.00,1.11,99.90,'2022-10-31 09:10:27','',''),(984,'1','285','1',1,'Retail Sale Id 987',41323.50,0.00,0.00,61.22,2754.90,'2022-10-31 09:11:11','',''),(985,'1','285','1',1,'Retail Sale Id 988',4298.40,0.00,0.00,5.97,537.30,'2022-10-31 09:15:36','',''),(986,'1','285','1',1,'Retail Sale Id 989',67500.00,0.00,0.00,100.00,4500.00,'2022-10-31 09:16:28','',''),(987,'1','285','1',1,'Retail Sale Id 990',2203.20,0.00,0.00,3.06,275.40,'2022-10-31 09:17:18','',''),(988,'1','285','1',1,'Retail Sale Id 991',4996.80,0.00,0.00,6.94,624.60,'2022-10-31 09:19:18','',''),(989,'1','285','1',1,'Retail Sale Id 992',30746.25,0.00,0.00,45.55,2049.75,'2022-10-31 09:20:25','',''),(990,'1','285','1',1,'Retail Sale Id 993',1440.00,0.00,0.00,2.00,180.00,'2022-10-31 09:24:48','',''),(991,'1','285','1',1,'Retail Sale Id 994',799.20,0.00,0.00,1.11,99.90,'2022-10-31 09:26:22','',''),(992,'1','285','1',1,'Retail Sale Id 995',41350.50,0.00,0.00,61.26,2756.70,'2022-10-31 09:27:31','',''),(993,'1','285','1',1,'Retail Sale Id 996',3600.00,0.00,0.00,5.00,450.00,'2022-10-31 09:28:33','',''),(994,'1','285','1',1,'Retail Sale Id 997',9000.00,0.00,0.00,12.50,1125.00,'2022-10-31 09:31:19','',''),(995,'1','285','1',1,'Retail Sale Id 998',25650.00,0.00,0.00,38.00,1710.00,'2022-10-31 09:33:00','',''),(996,'1','285','1',1,'Retail Sale Id 999',2498.40,0.00,0.00,3.47,312.30,'2022-10-31 09:34:11','',''),(997,'1','285','1',1,'Retail Sale Id 1000',4320.00,0.00,0.00,6.00,540.00,'2022-10-31 09:36:16','',''),(998,'1','285','1',1,'Retail Sale Id 1001',2203.20,0.00,0.00,3.06,275.40,'2022-10-31 09:40:23','',''),(999,'1','285','1',1,'Retail Sale Id 1002',56700.00,0.00,0.00,84.00,3780.00,'2022-10-31 09:45:08','',''),(1000,'1','285','1',1,'Retail Sale Id 1003',30375.00,0.00,0.00,45.00,2025.00,'2022-10-31 09:48:14','',''),(1001,'1','285','1',1,'Retail Sale Id 1004',1497.60,0.00,0.00,2.08,187.20,'2022-10-31 09:51:24','',''),(1002,'1','285','1',1,'Retail Sale Id 1005',1497.60,0.00,0.00,2.08,187.20,'2022-10-31 09:52:14','',''),(1003,'1','285','1',1,'Retail Sale Id 1006',9000.00,0.00,0.00,12.50,1125.00,'2022-10-31 09:52:55','',''),(1004,'1','285','1',1,'Retail Sale Id 1007',9693.00,0.00,0.00,14.36,646.20,'2022-10-31 09:57:04','',''),(1005,'1','285','1',1,'Retail Sale Id 1008',87756.75,0.00,0.00,130.01,5850.45,'2022-10-31 10:02:59','',''),(1006,'1','285','1',1,'Retail Sale Id 1009',748.80,0.00,0.00,1.04,93.60,'2022-10-31 10:06:08','',''),(1007,'1','285','1',1,'Retail Sale Id 1010',1000.80,0.00,0.00,1.39,125.10,'2022-10-31 10:11:59','',''),(1008,'1','285','1',1,'Retail Sale Id 1011',3600.00,0.00,0.00,5.00,450.00,'2022-10-31 10:13:24','',''),(1009,'1','285','1',1,'Retail Sale Id 1012',1497.60,0.00,0.00,2.08,187.20,'2022-10-31 10:14:43','',''),(1010,'1','285','1',1,'Retail Sale Id 1013',41161.50,0.00,0.00,60.98,2744.10,'2022-10-31 10:17:05','',''),(1011,'1','285','1',1,'Retail Sale Id 1014',41148.00,0.00,0.00,60.96,2743.20,'2022-10-31 10:19:15','',''),(1012,'1','285','1',1,'Retail Sale Id 1015',1497.60,0.00,0.00,2.08,187.20,'2022-10-31 10:20:44','',''),(1013,'1','285','1',1,'Retail Sale Id 1016',40500.00,0.00,0.00,60.00,2700.00,'2022-10-31 10:24:58','',''),(1014,'1','285','1',1,'Retail Sale Id 1017',1497.60,0.00,0.00,2.08,187.20,'2022-10-31 10:42:38','',''),(1015,'1','285','1',1,'Retail Sale Id 1018',1497.60,0.00,0.00,2.08,187.20,'2022-10-31 10:45:53','',''),(1016,'1','285','1',1,'Retail Sale Id 1019',40844.25,0.00,0.00,60.51,2722.95,'2022-10-31 10:46:56','',''),(1017,'1','285','1',1,'Retail Sale Id 1020',3002.40,0.00,0.00,4.17,375.30,'2022-10-31 10:52:30','',''),(1018,'1','285','1',1,'Retail Sale Id 1021',87534.00,0.00,0.00,129.68,5835.60,'2022-10-31 10:54:05','',''),(1019,'1','285','1',1,'Retail Sale Id 1022',5760.00,0.00,0.00,8.00,720.00,'2022-10-31 11:01:14','',''),(1020,'1','285','1',1,'Retail Sale Id 1023',2001.60,0.00,0.00,2.78,250.20,'2022-10-31 11:09:34','',''),(1021,'1','285','1',1,'Retail Sale Id 1025',2203.20,0.00,0.00,3.06,275.40,'2022-10-31 11:37:21','',''),(1022,'1','285','1',1,'Retail Sale Id 1026',33750.00,0.00,0.00,50.00,2250.00,'2022-10-31 11:39:44','',''),(1023,'1','285','1',1,'Retail Sale Id 1027',49275.00,0.00,0.00,73.00,3285.00,'2022-10-31 11:43:27','',''),(1024,'1','285','1',1,'Retail Sale Id 1028',9000.00,0.00,0.00,12.50,1125.00,'2022-10-31 11:46:30','',''),(1025,'1','285','1',1,'Retail Sale Id 1029',2800.80,0.00,0.00,3.89,350.10,'2022-10-31 11:52:40','',''),(1026,'1','285','1',1,'Retail Sale Id 1030',3600.00,0.00,0.00,5.00,450.00,'2022-10-31 11:53:59','',''),(1027,'1','285','1',1,'Retail Sale Id 1031',2880.00,0.00,0.00,4.00,360.00,'2022-10-31 12:11:59','',''),(1028,'1','285','1',1,'Retail Sale Id 1032',720.00,0.00,0.00,1.00,90.00,'2022-10-31 12:13:02','',''),(1029,'1','285','1',1,'Retail Sale Id 1033',1497.60,0.00,0.00,2.08,187.20,'2022-10-31 12:16:53','',''),(1030,'1','285','1',1,'Retail Sale Id 1034',3600.00,0.00,0.00,5.00,450.00,'2022-10-31 12:31:28','',''),(1031,'1','285','1',1,'Retail Sale Id 1035',206550.00,0.00,0.00,306.00,13770.00,'2022-10-31 12:37:05','',''),(1032,'1','285','1',1,'Retail Sale Id 1036',1440.00,0.00,0.00,2.00,180.00,'2022-10-31 12:50:42','',''),(1033,'1','285','1',1,'Retail Sale Id 1037',7920.00,0.00,0.00,11.00,990.00,'2022-10-31 12:52:31','',''),(1034,'1','285','1',1,'Retail Sale Id 1038',1497.60,0.00,0.00,2.08,187.20,'2022-10-31 13:01:55','',''),(1035,'1','285','1',1,'Retail Sale Id 1039',67500.00,0.00,0.00,100.00,4500.00,'2022-10-31 13:03:38','',''),(1036,'1','285','1',1,'Retail Sale Id 1040',1497.60,0.00,0.00,2.08,187.20,'2022-10-31 13:04:57','',''),(1037,'1','285','1',1,'Retail Sale Id 1041',1440.00,0.00,0.00,2.00,180.00,'2022-10-31 13:10:19','',''),(1038,'1','285','1',1,'Retail Sale Id 1042',34310.25,0.00,0.00,50.83,2287.35,'2022-10-31 13:17:15','',''),(1039,'1','285','1',1,'Retail Sale Id 1043',1497.60,0.00,0.00,2.08,187.20,'2022-10-31 13:18:55','',''),(1040,'1','285','1',1,'Retail Sale Id 1044',2880.00,0.00,0.00,4.00,360.00,'2022-10-31 13:21:02','',''),(1041,'1','285','1',1,'Retail Sale Id 1045',1440.00,0.00,0.00,2.00,180.00,'2022-10-31 13:27:05','',''),(1042,'1','285','1',1,'Retail Sale Id 1046',1497.60,0.00,0.00,2.08,187.20,'2022-10-31 13:28:10','',''),(1043,'1','285','1',1,'Retail Sale Id 1047',81654.75,0.00,0.00,120.97,5443.65,'2022-10-31 13:31:21','',''),(1044,'1','285','1',1,'Retail Sale Id 1048',1440.00,0.00,0.00,2.00,180.00,'2022-10-31 13:43:30','',''),(1045,'1','285','1',1,'Retail Sale Id 1049',5601.60,0.00,0.00,7.78,700.20,'2022-10-31 13:55:50','',''),(1046,'1','285','1',1,'Retail Sale Id 1050',4348.80,0.00,0.00,6.04,543.60,'2022-10-31 14:18:05','',''),(1047,'1','285','1',1,'Retail Sale Id 1051',84969.00,0.00,0.00,125.88,5664.60,'2022-10-31 14:21:06','',''),(1048,'1','285','1',1,'Retail Sale Id 1052',1440.00,0.00,0.00,2.00,180.00,'2022-10-31 14:21:59','',''),(1049,'1','285','1',1,'Return of Retail Sale Id 991',0.00,4996.80,6.94,0.00,-624.60,'2022-10-31 14:25:55','',''),(1050,'1','285','1',1,'Retail Sale Id 1053',2203.20,0.00,0.00,3.06,275.40,'2022-10-31 14:26:56','',''),(1051,'1','285','1',1,'Return of Retail Sale Id 1000',0.00,4320.00,6.00,0.00,-540.00,'2022-10-31 14:27:43','',''),(1052,'1','285','1',1,'Return of Retail Sale Id 1053',0.00,2203.20,3.06,0.00,-275.40,'2022-10-31 14:28:45','',''),(1053,'1','285','1',1,'Retail Sale Id 1054',2203.20,0.00,0.00,3.06,275.40,'2022-10-31 14:29:09','',''),(1054,'1','285','1',1,'Retail Sale Id 1055',3600.00,0.00,0.00,5.00,450.00,'2022-10-31 14:31:51','',''),(1055,'1','285','1',1,'Retail Sale Id 1056',5760.00,0.00,0.00,8.00,720.00,'2022-10-31 14:36:51','',''),(1056,'1','285','1',1,'Retail Sale Id 1057',799.20,0.00,0.00,1.11,99.90,'2022-10-31 14:40:30','',''),(1057,'1','285','1',1,'Retail Sale Id 1058',1440.00,0.00,0.00,2.00,180.00,'2022-10-31 14:43:35','',''),(1058,'1','285','1',1,'Retail Sale Id 1059',1440.00,0.00,0.00,2.00,180.00,'2022-10-31 14:44:58','',''),(1059,'1','285','1',1,'Retail Sale Id 1060',1497.60,0.00,0.00,2.08,187.20,'2022-10-31 14:49:07','',''),(1060,'1','285','1',1,'Retail Sale Id 1061',39825.00,0.00,0.00,59.00,2655.00,'2022-10-31 14:52:06','',''),(1061,'1','285','1',1,'Retail Sale Id 1062',2498.40,0.00,0.00,3.47,312.30,'2022-10-31 15:04:32','',''),(1062,'1','285','1',1,'Retail Sale Id 1063',1447.20,0.00,0.00,2.01,180.90,'2022-10-31 15:18:34','',''),(1063,'1','285','1',1,'Retail Sale Id 1064',2001.60,0.00,0.00,2.78,250.20,'2022-10-31 15:27:17','',''),(1064,'1','285','1',1,'Retail Sale Id 1065',1000.80,0.00,0.00,1.39,125.10,'2022-10-31 15:30:31','',''),(1065,'1','285','1',1,'Retail Sale Id 1066',2160.00,0.00,0.00,3.00,270.00,'2022-10-31 15:38:16','',''),(1066,'1','285','1',1,'Retail Sale Id 1067',2203.20,0.00,0.00,3.06,275.40,'2022-10-31 15:43:44','',''),(1067,'1','285','1',1,'Retail Sale Id 1068',799.20,0.00,0.00,1.11,99.90,'2022-10-31 15:44:56','',''),(1068,'1','285','1',1,'Retail Sale Id 1069',22842.00,0.00,0.00,33.84,1522.80,'2022-10-31 15:46:41','',''),(1069,'1','285','1',1,'Retail Sale Id 1070',1497.60,0.00,0.00,2.08,187.20,'2022-10-31 15:49:00','',''),(1070,'1','285','1',1,'Retail Sale Id 1072',9000.00,0.00,0.00,12.50,1125.00,'2022-10-31 15:50:49','',''),(1071,'1','285','1',1,'Retail Sale Id 1073',45393.75,0.00,0.00,67.25,3026.25,'2022-10-31 15:52:14','',''),(1072,'1','285','1',1,'Retail Sale Id 1074',799.20,0.00,0.00,1.11,99.90,'2022-10-31 16:00:12','',''),(1073,'1','285','1',1,'Retail Sale Id 1075',799.20,0.00,0.00,1.11,99.90,'2022-10-31 16:01:15','',''),(1074,'1','285','1',1,'Retail Sale Id 1076',1497.60,0.00,0.00,2.08,187.20,'2022-10-31 16:04:05','',''),(1075,'1','285','1',1,'Retail Sale Id 1077',1497.60,0.00,0.00,2.08,187.20,'2022-10-31 16:05:31','',''),(1076,'1','285','1',1,'Retail Sale Id 1078',2203.20,0.00,0.00,3.06,275.40,'2022-10-31 16:07:28','',''),(1077,'1','285','1',1,'Retail Sale Id 1079',1497.60,0.00,0.00,2.08,187.20,'2022-10-31 16:09:34','',''),(1078,'1','285','1',1,'Retail Sale Id 1081',52994.25,0.00,0.00,78.51,3532.95,'2022-10-31 16:16:44','',''),(1079,'1','285','1',1,'Retail Sale Id 1082',2498.40,0.00,0.00,3.47,312.30,'2022-10-31 16:19:19','',''),(1080,'1','285','1',1,'Retail Sale Id 1083',748.80,0.00,0.00,1.04,93.60,'2022-10-31 16:20:39','',''),(1081,'1','285','1',1,'Retail Sale Id 1084',1497.60,0.00,0.00,2.08,187.20,'2022-10-31 16:35:12','',''),(1082,'1','285','1',1,'Retail Sale Id 1085',3600.00,0.00,0.00,5.00,450.00,'2022-10-31 16:36:12','',''),(1083,'1','285','1',1,'Retail Sale Id 1086',8437.50,0.00,0.00,12.50,562.50,'2022-10-31 16:38:19','',''),(1084,'1','285','1',1,'Retail Sale Id 1087',5760.00,0.00,0.00,8.00,720.00,'2022-10-31 16:39:41','',''),(1085,'1','285','1',1,'Retail Sale Id 1088',2498.40,0.00,0.00,3.47,312.30,'2022-10-31 16:43:44','',''),(1086,'1','285','1',1,'Retail Sale Id 1089',5040.00,0.00,0.00,7.00,630.00,'2022-10-31 16:45:59','',''),(1087,'1','285','1',1,'Retail Sale Id 1090',748.80,0.00,0.00,1.04,93.60,'2022-10-31 16:48:10','',''),(1088,'1','285','1',1,'Retail Sale Id 1091',1440.00,0.00,0.00,2.00,180.00,'2022-10-31 16:49:28','',''),(1089,'1','285','1',1,'Retail Sale Id 1092',85725.00,0.00,0.00,127.00,5715.00,'2022-10-31 16:51:26','',''),(1090,'1','285','1',1,'Retail Sale Id 1093',799.20,0.00,0.00,1.11,99.90,'2022-10-31 16:52:53','',''),(1091,'1','285','1',1,'Return of Retail Sale Id 1086',0.00,8437.50,12.50,0.00,-562.50,'2022-10-31 17:00:27','',''),(1092,'1','285','1',1,'Retail Sale Id 1094',18279.00,0.00,0.00,27.08,1218.60,'2022-10-31 17:01:35','',''),(1093,'1','285','1',1,'Retail Sale Id 1095',82741.50,0.00,0.00,122.58,5516.10,'2022-10-31 17:03:23','',''),(1094,'1','285','1',1,'Retail Sale Id 1096',41850.00,0.00,0.00,62.00,2790.00,'2022-10-31 17:05:27','',''),(1095,'1','285','1',1,'Retail Sale Id 1097',1497.60,0.00,0.00,2.08,187.20,'2022-10-31 17:07:16','',''),(1096,'1','285','1',1,'Retail Sale Id 1098',799.20,0.00,0.00,1.11,99.90,'2022-10-31 17:08:20','',''),(1097,'1','285','1',1,'Retail Sale Id 1099',9000.00,0.00,0.00,12.50,1125.00,'2022-10-31 17:14:43','',''),(1098,'1','285','1',1,'Retail Sale Id 1100',40871.25,0.00,0.00,60.55,2724.75,'2022-10-31 17:16:49','',''),(1099,'1','285','1',1,'Return of Retail Sale Id 1099',0.00,9000.00,12.50,0.00,-1125.00,'2022-10-31 17:22:42','',''),(1100,'1','285','1',1,'Retail Sale Id 1101',8437.50,0.00,0.00,12.50,562.50,'2022-10-31 17:23:20','',''),(1101,'1','285','1',1,'Return of Retail Sale Id 972',0.00,41843.25,61.99,0.00,-2789.55,'2022-10-31 17:51:10','',''),(1102,'1','285','1',1,'Retail Sale Id 1102',5904.00,0.00,0.00,8.20,738.00,'2022-10-31 22:40:53','',''),(1103,'1','285','1',1,'Return of Retail Sale Id 1101',0.00,8437.50,12.50,0.00,-562.50,'2022-10-31 22:44:34','',''),(1104,'1','285','1',1,'Retail Sale Id 1103',2814.75,0.00,0.00,4.17,187.65,'2022-10-31 22:45:41','',''),(1105,'1','285','1',1,'Retail Sale Id 1104',41654.25,0.00,0.00,61.71,2776.95,'2022-11-01 07:50:04','',''),(1106,'1','285','1',1,'Retail Sale Id 1105',40500.00,0.00,0.00,60.00,2700.00,'2022-11-01 07:54:47','',''),(1107,'1','285','1',1,'Retail Sale Id 1106',62214.75,0.00,0.00,92.17,4147.65,'2022-11-01 08:08:22','',''),(1108,'1','285','1',1,'Retail Sale Id 1107',67500.00,0.00,0.00,100.00,4500.00,'2022-11-01 08:11:05','',''),(1109,'1','285','1',1,'Retail Sale Id 1108',47250.00,0.00,0.00,70.00,3150.00,'2022-11-01 08:13:18','',''),(1110,'1','285','1',1,'Retail Sale Id 1109',40500.00,0.00,0.00,60.00,2700.00,'2022-11-01 08:13:53','',''),(1111,'1','285','1',1,'Retail Sale Id 1110',1440.00,0.00,0.00,2.00,180.00,'2022-11-01 08:20:18','',''),(1112,'1','285','1',1,'Retail Sale Id 1111',1440.00,0.00,0.00,2.00,180.00,'2022-11-01 08:21:59','',''),(1113,'1','285','1',1,'Retail Sale Id 1112',37125.00,0.00,0.00,55.00,2475.00,'2022-11-01 08:22:59','',''),(1114,'1','285','1',1,'Retail Sale Id 1113',799.20,0.00,0.00,1.11,99.90,'2022-11-01 08:24:28','',''),(1115,'1','285','1',1,'Retail Sale Id 1114',1497.60,0.00,0.00,2.08,187.20,'2022-11-01 08:32:02','',''),(1116,'1','285','1',1,'Retail Sale Id 1115',1000.80,0.00,0.00,1.39,125.10,'2022-11-01 08:38:21','',''),(1117,'1','285','1',1,'Retail Sale Id 1116',2001.60,0.00,0.00,2.78,250.20,'2022-11-01 08:40:10','',''),(1118,'1','285','1',1,'Retail Sale Id 1117',81000.00,0.00,0.00,120.00,5400.00,'2022-11-01 08:46:45','',''),(1119,'1','285','1',1,'Retail Sale Id 1118',40500.00,0.00,0.00,60.00,2700.00,'2022-11-01 08:54:00','',''),(1120,'1','285','1',1,'Retail Sale Id 1119',2498.40,0.00,0.00,3.47,312.30,'2022-11-01 08:55:31','',''),(1121,'1','285','1',1,'Retail Sale Id 1120',13500.00,0.00,0.00,20.00,900.00,'2022-11-01 08:59:46','',''),(1122,'1','285','1',1,'Retail Sale Id 1121',1497.60,0.00,0.00,2.08,187.20,'2022-11-01 09:06:54','',''),(1123,'1','285','1',1,'Retail Sale Id 1122',1497.60,0.00,0.00,2.08,187.20,'2022-11-01 09:08:48','',''),(1124,'1','285','1',1,'Retail Sale Id 1123',33750.00,0.00,0.00,50.00,2250.00,'2022-11-01 09:10:07','',''),(1125,'1','285','1',1,'Retail Sale Id 1124',4399.20,0.00,0.00,6.11,549.90,'2022-11-01 09:11:50','',''),(1126,'1','285','1',1,'Retail Sale Id 1125',3600.00,0.00,0.00,5.00,450.00,'2022-11-01 09:17:56','',''),(1127,'1','285','1',1,'Retail Sale Id 1127',4348.80,0.00,0.00,6.04,543.60,'2022-11-01 09:22:29','',''),(1128,'1','285','1',1,'Retail Sale Id 1128',3600.00,0.00,0.00,5.00,450.00,'2022-11-01 09:27:04','',''),(1129,'1','285','1',1,'Retail Sale Id 1129',44057.25,0.00,0.00,65.27,2937.15,'2022-11-01 09:29:15','',''),(1130,'1','285','1',1,'Retail Sale Id 1130',2160.00,0.00,0.00,3.00,270.00,'2022-11-01 09:34:13','',''),(1131,'1','285','1',1,'Return of Retail Sale Id 1120',0.00,13500.00,20.00,0.00,-900.00,'2022-11-01 09:39:38','',''),(1132,'1','285','1',1,'Retail Sale Id 1131',8775.00,0.00,0.00,13.00,585.00,'2022-11-01 09:40:42','',''),(1133,'1','285','1',1,'Retail Sale Id 1132',5040.00,0.00,0.00,7.00,630.00,'2022-11-01 09:42:02','',''),(1134,'1','285','1',1,'Retail Sale Id 1133',1497.60,0.00,0.00,2.08,187.20,'2022-11-01 09:54:29','',''),(1135,'1','285','1',1,'Retail Sale Id 1134',2880.00,0.00,0.00,4.00,360.00,'2022-11-01 09:59:38','',''),(1136,'1','285','1',1,'Retail Sale Id 1135',115998.75,0.00,0.00,171.85,7733.25,'2022-11-01 10:02:50','',''),(1137,'1','285','1',1,'Retail Sale Id 1136',5040.00,0.00,0.00,7.00,630.00,'2022-11-01 10:03:54','',''),(1138,'1','285','1',1,'Retail Sale Id 1137',1497.60,0.00,0.00,2.08,187.20,'2022-11-01 10:13:58','',''),(1139,'1','285','1',1,'Retail Sale Id 1138',2880.00,0.00,0.00,4.00,360.00,'2022-11-01 10:14:57','',''),(1140,'1','285','1',1,'Retail Sale Id 1139',2001.60,0.00,0.00,2.78,250.20,'2022-11-01 10:31:20','',''),(1141,'1','285','1',1,'Retail Sale Id 1140',41175.00,0.00,0.00,61.00,2745.00,'2022-11-01 10:34:15','',''),(1142,'1','285','1',1,'Retail Sale Id 1141',27000.00,0.00,0.00,40.00,1800.00,'2022-11-01 10:36:54','',''),(1143,'1','285','1',1,'Retail Sale Id 1142',799.20,0.00,0.00,1.11,99.90,'2022-11-01 10:42:00','',''),(1144,'1','285','1',1,'Retail Sale Id 1143',2203.20,0.00,0.00,3.06,275.40,'2022-11-01 10:43:04','',''),(1145,'1','285','1',1,'Retail Sale Id 1144',2160.00,0.00,0.00,3.00,270.00,'2022-11-01 10:44:23','',''),(1146,'1','285','1',1,'Retail Sale Id 1145',42835.50,0.00,0.00,63.46,2855.70,'2022-11-01 10:46:08','',''),(1147,'1','285','1',1,'Retail Sale Id 1146',1497.60,0.00,0.00,2.08,187.20,'2022-11-01 10:49:33','',''),(1148,'1','285','1',1,'Retail Sale Id 1147',47209.50,0.00,0.00,69.94,3147.30,'2022-11-01 10:51:42','',''),(1149,'1','285','1',1,'Retail Sale Id 1148',44131.50,0.00,0.00,65.38,2942.10,'2022-11-01 10:54:23','',''),(1150,'1','285','1',1,'Retail Sale Id 1149',1440.00,0.00,0.00,2.00,180.00,'2022-11-01 10:56:56','',''),(1151,'1','285','1',1,'Retail Sale Id 1150',5040.00,0.00,0.00,7.00,630.00,'2022-11-01 10:58:41','',''),(1152,'1','285','1',1,'Retail Sale Id 1151',2880.00,0.00,0.00,4.00,360.00,'2022-11-01 11:25:29','',''),(1153,'1','285','1',1,'Retail Sale Id 1152',5040.00,0.00,0.00,7.00,630.00,'2022-11-01 11:26:34','',''),(1154,'1','285','1',1,'Retail Sale Id 1153',9000.00,0.00,0.00,12.50,1125.00,'2022-11-01 11:27:45','',''),(1155,'1','285','1',1,'Retail Sale Id 1154',1447.20,0.00,0.00,2.01,180.90,'2022-11-01 11:37:36','',''),(1156,'1','285','1',1,'Retail Sale Id 1155',4320.00,0.00,0.00,6.00,540.00,'2022-11-01 11:39:40','',''),(1157,'1','285','1',1,'Retail Sale Id 1156',720.00,0.00,0.00,1.00,90.00,'2022-11-01 11:42:30','',''),(1158,'1','285','1',1,'Retail Sale Id 1157',82505.25,0.00,0.00,122.23,5500.35,'2022-11-01 11:44:35','',''),(1159,'1','285','1',1,'Retail Sale Id 1158',720.00,0.00,0.00,1.00,90.00,'2022-11-01 12:37:11','',''),(1160,'1','285','1',1,'Retail Sale Id 1159',1440.00,0.00,0.00,2.00,180.00,'2022-11-01 12:38:38','',''),(1161,'1','285','1',1,'Retail Sale Id 1160',1497.60,0.00,0.00,2.08,187.20,'2022-11-01 12:40:52','',''),(1162,'1','285','1',1,'Retail Sale Id 1161',2203.20,0.00,0.00,3.06,275.40,'2022-11-01 12:43:20','',''),(1163,'1','285','1',1,'Retail Sale Id 1162',39825.00,0.00,0.00,59.00,2655.00,'2022-11-01 12:48:15','',''),(1164,'1','285','1',1,'Return of Retail Sale Id 1162',0.00,39825.00,59.00,0.00,-2655.00,'2022-11-01 13:02:33','',''),(1165,'1','285','1',1,'Retail Sale Id 1163',39561.75,0.00,0.00,58.61,2637.45,'2022-11-01 13:03:15','',''),(1166,'1','285','1',1,'Retail Sale Id 1164',1440.00,0.00,0.00,2.00,180.00,'2022-11-01 13:04:19','',''),(1167,'1','285','1',1,'Retail Sale Id 1165',2880.00,0.00,0.00,4.00,360.00,'2022-11-01 13:06:32','',''),(1168,'1','285','1',1,'Retail Sale Id 1166',2880.00,0.00,0.00,4.00,360.00,'2022-11-01 13:34:12','',''),(1169,'1','285','1',1,'Retail Sale Id 1167',8437.50,0.00,0.00,12.50,562.50,'2022-11-01 13:46:05','',''),(1170,'1','285','1',1,'Retail Sale Id 1168',2160.00,0.00,0.00,3.00,270.00,'2022-11-01 13:49:54','',''),(1171,'1','285','1',1,'Retail Sale Id 1169',2203.20,0.00,0.00,3.06,275.40,'2022-11-01 13:51:46','',''),(1172,'1','285','1',1,'Retail Sale Id 1170',1497.60,0.00,0.00,2.08,187.20,'2022-11-01 13:58:37','',''),(1173,'1','285','1',1,'Retail Sale Id 1171',1497.60,0.00,0.00,2.08,187.20,'2022-11-01 13:59:40','',''),(1174,'1','285','1',1,'Retail Sale Id 1173',1440.00,0.00,0.00,2.00,180.00,'2022-11-01 14:12:04','',''),(1175,'1','285','1',1,'Retail Sale Id 1174',4320.00,0.00,0.00,6.00,540.00,'2022-11-01 14:18:09','',''),(1176,'1','285','1',1,'Retail Sale Id 1175',799.20,0.00,0.00,1.11,99.90,'2022-11-01 14:21:03','',''),(1177,'1','285','1',1,'Retail Sale Id 1176',799.20,0.00,0.00,1.11,99.90,'2022-11-01 14:22:02','',''),(1178,'1','285','1',1,'Retail Sale Id 1178',2203.20,0.00,0.00,3.06,275.40,'2022-11-01 14:23:59','',''),(1179,'1','285','1',1,'Retail Sale Id 1179',65893.50,0.00,0.00,97.62,4392.90,'2022-11-01 14:32:44','',''),(1180,'1','285','1',1,'Retail Sale Id 1180',33750.00,0.00,0.00,50.00,2250.00,'2022-11-01 14:34:47','',''),(1181,'1','285','1',1,'Retail Sale Id 1181',1497.60,0.00,0.00,2.08,187.20,'2022-11-01 14:36:07','',''),(1182,'1','285','1',1,'Retail Sale Id 1182',1440.00,0.00,0.00,2.00,180.00,'2022-11-01 14:39:42','',''),(1183,'1','285','1',1,'Retail Sale Id 1183',2880.00,0.00,0.00,4.00,360.00,'2022-11-01 14:47:14','',''),(1184,'1','285','1',1,'Retail Sale Id 1184',2203.20,0.00,0.00,3.06,275.40,'2022-11-01 14:50:28','',''),(1185,'1','285','1',1,'Retail Sale Id 1185',1000.80,0.00,0.00,1.39,125.10,'2022-11-01 15:00:21','',''),(1186,'1','285','1',1,'Retail Sale Id 1186',720.00,0.00,0.00,1.00,90.00,'2022-11-01 15:04:47','',''),(1187,'1','285','1',1,'Retail Sale Id 1187',3600.00,0.00,0.00,5.00,450.00,'2022-11-01 15:13:05','',''),(1188,'1','285','1',1,'Retail Sale Id 1188',32116.50,0.00,0.00,47.58,2141.10,'2022-11-01 15:17:43','',''),(1189,'1','285','1',1,'Retail Sale Id 1189',1497.60,0.00,0.00,2.08,187.20,'2022-11-01 15:19:28','',''),(1190,'1','285','1',1,'Return of Retail Sale Id 1153',0.00,9000.00,12.50,0.00,-1125.00,'2022-11-01 15:20:27','',''),(1191,'1','285','1',1,'Retail Sale Id 1190',1440.00,0.00,0.00,2.00,180.00,'2022-11-01 15:21:23','',''),(1192,'1','285','1',1,'Retail Sale Id 1191',1440.00,0.00,0.00,2.00,180.00,'2022-11-01 15:30:22','',''),(1193,'1','285','1',1,'Retail Sale Id 1192',5040.00,0.00,0.00,7.00,630.00,'2022-11-01 15:37:47','',''),(1194,'1','285','1',1,'Retail Sale Id 1193',30375.00,0.00,0.00,45.00,2025.00,'2022-11-01 15:41:34','',''),(1195,'1','285','1',1,'Retail Sale Id 1194',3600.00,0.00,0.00,5.00,450.00,'2022-11-01 15:42:43','',''),(1196,'1','285','1',1,'Retail Sale Id 1195',799.20,0.00,0.00,1.11,99.90,'2022-11-01 15:46:37','',''),(1197,'1','285','1',1,'Retail Sale Id 1196',748.80,0.00,0.00,1.04,93.60,'2022-11-01 15:48:16','',''),(1198,'1','285','1',1,'Retail Sale Id 1197',40749.75,0.00,0.00,60.37,2716.65,'2022-11-01 15:52:30','',''),(1199,'1','285','1',1,'Retail Sale Id 1198',799.20,0.00,0.00,1.11,99.90,'2022-11-01 15:53:10','',''),(1200,'1','285','1',1,'Retail Sale Id 1199',1447.20,0.00,0.00,2.01,180.90,'2022-11-01 15:55:54','',''),(1201,'1','285','1',1,'Retail Sale Id 1200',3600.00,0.00,0.00,5.00,450.00,'2022-11-01 15:57:02','',''),(1202,'1','285','1',1,'Retail Sale Id 1201',3600.00,0.00,0.00,5.00,450.00,'2022-11-01 16:12:15','',''),(1203,'1','285','1',1,'Retail Sale Id 1203',2880.00,0.00,0.00,4.00,360.00,'2022-11-01 16:23:27','',''),(1204,'1','285','1',1,'Retail Sale Id 1204',14175.00,0.00,0.00,21.00,945.00,'2022-11-01 16:24:31','',''),(1205,'1','285','1',1,'Retail Sale Id 1205',24975.00,0.00,0.00,37.00,1665.00,'2022-11-01 16:26:04','',''),(1206,'1','285','1',1,'Retail Sale Id 1206',11520.00,0.00,0.00,16.00,1440.00,'2022-11-01 16:27:32','',''),(1207,'1','285','1',1,'Retail Sale Id 1207',135000.00,0.00,0.00,200.00,9000.00,'2022-11-01 16:29:35','',''),(1208,'1','285','1',1,'Retail Sale Id 1208',23625.00,0.00,0.00,35.00,1575.00,'2022-11-01 16:32:18','',''),(1209,'1','285','1',1,'Retail Sale Id 1209',2880.00,0.00,0.00,4.00,360.00,'2022-11-01 16:47:02','',''),(1210,'1','285','1',1,'Retail Sale Id 1211',1497.60,0.00,0.00,2.08,187.20,'2022-11-01 16:48:35','',''),(1211,'1','285','1',1,'Retail Sale Id 1212',1497.60,0.00,0.00,2.08,187.20,'2022-11-01 16:49:38','',''),(1212,'1','285','1',1,'Retail Sale Id 1213',3600.00,0.00,0.00,5.00,450.00,'2022-11-01 16:56:37','',''),(1213,'1','285','1',1,'Retail Sale Id 1214',10022.40,0.00,0.00,13.92,1252.80,'2022-11-01 17:09:06','',''),(1214,'1','285','1',1,'Retail Sale Id 1215',21.60,0.00,0.00,0.03,2.70,'2022-11-01 18:48:21','',''),(1215,'1','285','1',1,'Retail Sale Id 1216',20776.50,0.00,0.00,30.78,1385.10,'2022-11-01 18:55:56','',''),(1216,'1','285','1',1,'Retail Sale Id 1217',41296.50,0.00,0.00,61.18,2753.10,'2022-11-02 07:39:54','',''),(1217,'1','285','1',1,'Retail Sale Id 1218',82262.25,0.00,0.00,121.87,5484.15,'2022-11-02 07:40:54','',''),(1218,'1','285','1',1,'Retail Sale Id 1219',83713.50,0.00,0.00,124.02,5580.90,'2022-11-02 07:43:55','',''),(1219,'1','285','1',1,'Retail Sale Id 1220',23625.00,0.00,0.00,35.00,1575.00,'2022-11-02 07:58:33','',''),(1220,'1','285','1',1,'Retail Sale Id 1221',41789.25,0.00,0.00,61.91,2785.95,'2022-11-02 08:33:22','',''),(1221,'1','285','1',1,'Retail Sale Id 1222',46055.25,0.00,0.00,68.23,3070.35,'2022-11-02 08:34:00','',''),(1222,'1','285','1',1,'Retail Sale Id 1223',41809.50,0.00,0.00,61.94,2787.30,'2022-11-02 08:50:44','',''),(1223,'1','285','1',1,'Retail Sale Id 1227',40169.25,0.00,0.00,59.51,2677.95,'2022-11-02 08:55:36','',''),(1224,'1','285','1',1,'Retail Sale Id 1228',22909.50,0.00,0.00,33.94,1527.30,'2022-11-02 08:57:54','',''),(1225,'1','285','1',1,'Retail Sale Id 1229',9936.00,0.00,0.00,14.72,662.40,'2022-11-02 09:00:03','',''),(1226,'1','285','1',1,'Retail Sale Id 1230',2160.00,0.00,0.00,3.00,270.00,'2022-11-02 09:02:42','',''),(1227,'1','285','1',1,'Retail Sale Id 1231',3600.00,0.00,0.00,5.00,450.00,'2022-11-02 09:08:07','',''),(1228,'1','285','1',1,'Retail Sale Id 1232',5040.00,0.00,0.00,7.00,630.00,'2022-11-02 09:12:44','',''),(1229,'1','285','1',1,'Retail Sale Id 1233',1440.00,0.00,0.00,2.00,180.00,'2022-11-02 09:14:48','',''),(1230,'1','285','1',1,'Retail Sale Id 1234',2880.00,0.00,0.00,4.00,360.00,'2022-11-02 09:20:27','',''),(1231,'1','285','1',1,'Retail Sale Id 1235',97470.00,0.00,0.00,144.40,6498.00,'2022-11-02 09:22:04','',''),(1232,'1','285','1',1,'Retail Sale Id 1236',799.20,0.00,0.00,1.11,99.90,'2022-11-02 09:23:34','',''),(1233,'1','285','1',1,'Retail Sale Id 1237',42140.25,0.00,0.00,62.43,2809.35,'2022-11-02 09:34:44','',''),(1234,'1','285','1',1,'Retail Sale Id 1238',33750.00,0.00,0.00,50.00,2250.00,'2022-11-02 09:41:35','',''),(1235,'1','285','1',1,'Retail Sale Id 1239',2160.00,0.00,0.00,3.00,270.00,'2022-11-02 09:58:49','',''),(1236,'1','285','1',1,'Retail Sale Id 1240',3002.40,0.00,0.00,4.17,375.30,'2022-11-02 10:01:06','',''),(1237,'1','285','1',1,'Retail Sale Id 1241',2880.00,0.00,0.00,4.00,360.00,'2022-11-02 10:05:42','',''),(1238,'1','285','1',1,'Retail Sale Id 1242',37800.00,0.00,0.00,56.00,2520.00,'2022-11-02 10:19:34','',''),(1239,'1','285','1',1,'Retail Sale Id 1243',720.00,0.00,0.00,1.00,90.00,'2022-11-02 10:20:38','',''),(1240,'1','285','1',1,'Retail Sale Id 1244',720.00,0.00,0.00,1.00,90.00,'2022-11-02 10:22:34','',''),(1241,'1','285','1',1,'Retail Sale Id 1246',5040.00,0.00,0.00,7.00,630.00,'2022-11-02 10:24:15','',''),(1242,'1','285','1',1,'Return of Retail Sale Id 1244',0.00,720.00,1.00,0.00,-90.00,'2022-11-02 10:29:08','',''),(1243,'1','285','1',1,'Retail Sale Id 1247',38907.00,0.00,0.00,57.64,2593.80,'2022-11-02 10:32:35','',''),(1244,'1','285','1',1,'Retail Sale Id 1248',4989.60,0.00,0.00,6.93,623.70,'2022-11-02 10:33:27','',''),(1245,'1','285','1',1,'Retail Sale Id 1249',10131.75,0.00,0.00,15.01,675.45,'2022-11-02 10:55:33','',''),(1246,'1','285','1',1,'Retail Sale Id 1250',2203.20,0.00,0.00,3.06,275.40,'2022-11-02 10:59:32','',''),(1247,'1','285','1',1,'Retail Sale Id 1252',5582.25,0.00,0.00,8.27,372.15,'2022-11-02 11:08:51','',''),(1248,'1','285','1',1,'Retail Sale Id 1253',2880.00,0.00,0.00,4.00,360.00,'2022-11-02 11:25:07','',''),(1249,'1','285','1',1,'Retail Sale Id 1254',720.00,0.00,0.00,1.00,90.00,'2022-11-02 11:32:09','',''),(1250,'1','285','1',1,'Retail Sale Id 1255',2880.00,0.00,0.00,4.00,360.00,'2022-11-02 11:34:07','',''),(1251,'1','285','1',1,'Retail Sale Id 1256',1440.00,0.00,0.00,2.00,180.00,'2022-11-02 11:57:47','',''),(1252,'1','285','1',1,'Retail Sale Id 1257',490725.00,0.00,0.00,727.00,32715.00,'2022-11-02 12:08:18','',''),(1253,'1','285','1',1,'Retail Sale Id 1258',49072.50,0.00,0.00,72.70,3271.50,'2022-11-02 12:14:06','',''),(1254,'1','285','1',1,'Return of Retail Sale Id 1257',0.00,490725.00,727.00,0.00,-32715.00,'2022-11-02 12:14:59','',''),(1255,'1','285','1',1,'Retail Sale Id 1259',28910.25,0.00,0.00,42.83,1927.35,'2022-11-02 12:17:48','',''),(1256,'1','285','1',1,'Retail Sale Id 1260',2880.00,0.00,0.00,4.00,360.00,'2022-11-02 12:19:54','',''),(1257,'1','285','1',1,'Retail Sale Id 1261',14904.00,0.00,0.00,20.70,1863.00,'2022-11-02 12:21:08','',''),(1258,'1','285','1',1,'Retail Sale Id 1262',2498.40,0.00,0.00,3.47,312.30,'2022-11-02 12:24:21','',''),(1259,'1','285','1',1,'Retail Sale Id 1263',1447.20,0.00,0.00,2.01,180.90,'2022-11-02 12:27:05','',''),(1260,'1','285','1',1,'Retail Sale Id 1264',1497.60,0.00,0.00,2.08,187.20,'2022-11-02 12:34:06','',''),(1261,'1','285','1',1,'Retail Sale Id 1265',16200.00,0.00,0.00,24.00,1080.00,'2022-11-02 12:48:29','',''),(1262,'1','285','1',1,'Retail Sale Id 1266',799.20,0.00,0.00,1.11,99.90,'2022-11-02 12:49:50','',''),(1263,'1','285','1',1,'Retail Sale Id 1267',799.20,0.00,0.00,1.11,99.90,'2022-11-02 12:58:41','',''),(1264,'1','285','1',1,'Retail Sale Id 1268',1396.80,0.00,0.00,1.94,174.60,'2022-11-02 13:07:23','',''),(1265,'1','285','1',1,'Retail Sale Id 1269',720.00,0.00,0.00,1.00,90.00,'2022-11-02 13:19:05','',''),(1266,'1','285','1',1,'Retail Sale Id 1270',4320.00,0.00,0.00,6.00,540.00,'2022-11-02 13:20:28','',''),(1267,'1','285','1',1,'Retail Sale Id 1271',1497.60,0.00,0.00,2.08,187.20,'2022-11-02 13:24:22','',''),(1268,'1','285','1',1,'Retail Sale Id 1272',64017.00,0.00,0.00,94.84,4267.80,'2022-11-02 13:33:10','',''),(1269,'1','285','1',1,'Retail Sale Id 1273',3600.00,0.00,0.00,5.00,450.00,'2022-11-02 13:39:45','',''),(1270,'1','285','1',1,'Retail Sale Id 1274',2880.00,0.00,0.00,4.00,360.00,'2022-11-02 13:42:08','',''),(1271,'1','285','1',1,'Retail Sale Id 1275',2160.00,0.00,0.00,3.00,270.00,'2022-11-02 13:49:03','',''),(1272,'1','285','1',1,'Retail Sale Id 1276',2001.60,0.00,0.00,2.78,250.20,'2022-11-02 14:17:25','',''),(1273,'1','285','1',1,'Retail Sale Id 1277',249905.25,0.00,0.00,370.23,16660.35,'2022-11-02 14:32:47','',''),(1274,'1','285','1',1,'Retail Sale Id 1278',1000.80,0.00,0.00,1.39,125.10,'2022-11-02 14:34:17','',''),(1275,'1','285','1',1,'Retail Sale Id 1279',60750.00,0.00,0.00,90.00,4050.00,'2022-11-02 14:38:53','',''),(1276,'1','285','1',1,'Retail Sale Id 1280',1497.60,0.00,0.00,2.08,187.20,'2022-11-02 14:54:14','',''),(1277,'1','285','1',1,'Retail Sale Id 1281',4320.00,0.00,0.00,6.00,540.00,'2022-11-02 15:02:43','',''),(1278,'1','285','1',1,'Retail Sale Id 1282',4320.00,0.00,0.00,6.00,540.00,'2022-11-02 15:15:08','',''),(1279,'1','285','1',1,'Retail Sale Id 1283',720.00,0.00,0.00,1.00,90.00,'2022-11-02 15:16:57','',''),(1280,'1','285','1',1,'Retail Sale Id 1284',41107.50,0.00,0.00,60.90,2740.50,'2022-11-02 15:21:04','',''),(1281,'1','285','1',1,'Retail Sale Id 1285',1440.00,0.00,0.00,2.00,180.00,'2022-11-02 15:23:48','',''),(1282,'1','285','1',1,'Retail Sale Id 1286',1497.60,0.00,0.00,2.08,187.20,'2022-11-02 15:25:18','',''),(1283,'1','285','1',1,'Retail Sale Id 1287',1000.80,0.00,0.00,1.39,125.10,'2022-11-02 15:26:39','',''),(1284,'1','285','1',1,'Retail Sale Id 1288',2203.20,0.00,0.00,3.06,275.40,'2022-11-02 15:27:46','',''),(1285,'1','285','1',1,'Retail Sale Id 1289',120291.75,0.00,0.00,178.21,8019.45,'2022-11-02 15:38:41','',''),(1286,'1','285','1',1,'Retail Sale Id 1290',9749.88,0.00,0.00,14.84,400.68,'2022-11-02 15:48:19','',''),(1287,'1','285','1',1,'Retail Sale Id 1291',4320.00,0.00,0.00,6.00,540.00,'2022-11-02 15:51:17','',''),(1288,'1','285','1',1,'Retail Sale Id 1292',2203.20,0.00,0.00,3.06,275.40,'2022-11-02 15:56:01','',''),(1289,'1','285','1',1,'Retail Sale Id 1293',799.20,0.00,0.00,1.11,99.90,'2022-11-02 16:01:32','',''),(1290,'1','285','1',1,'Retail Sale Id 1294',2203.20,0.00,0.00,3.06,275.40,'2022-11-02 16:09:44','',''),(1291,'1','285','1',1,'Retail Sale Id 1295',16544.25,0.00,0.00,24.51,1102.95,'2022-11-02 16:11:28','',''),(1292,'1','285','1',1,'Retail Sale Id 1297',3600.00,0.00,0.00,5.00,450.00,'2022-11-02 16:13:14','',''),(1293,'1','285','1',1,'Retail Sale Id 1298',2160.00,0.00,0.00,3.00,270.00,'2022-11-02 16:17:17','',''),(1294,'1','285','1',1,'Retail Sale Id 1299',1440.00,0.00,0.00,2.00,180.00,'2022-11-02 16:18:47','',''),(1295,'1','285','1',1,'Retail Sale Id 1301',38299.50,0.00,0.00,56.74,2553.30,'2022-11-02 16:28:18','',''),(1296,'1','285','1',1,'Retail Sale Id 1302',5040.00,0.00,0.00,7.00,630.00,'2022-11-02 16:33:41','',''),(1297,'1','285','1',1,'Retail Sale Id 1303',1497.60,0.00,0.00,2.08,187.20,'2022-11-02 16:36:08','',''),(1298,'1','285','1',1,'Retail Sale Id 1304',720.00,0.00,0.00,1.00,90.00,'2022-11-02 16:40:30','',''),(1299,'1','285','1',1,'Retail Sale Id 1305',1000.80,0.00,0.00,1.39,125.10,'2022-11-02 16:48:24','',''),(1300,'1','285','1',1,'Retail Sale Id 1306',9000.00,0.00,0.00,12.50,1125.00,'2022-11-02 16:49:14','',''),(1301,'1','285','1',1,'Retail Sale Id 1307',6998.40,0.00,0.00,9.72,874.80,'2022-11-02 16:50:02','',''),(1302,'1','285','1',1,'Retail Sale Id 1308',40500.00,0.00,0.00,60.00,2700.00,'2022-11-02 16:53:19','',''),(1303,'1','285','1',1,'Retail Sale Id 1309',1000.80,0.00,0.00,1.39,125.10,'2022-11-02 16:55:36','',''),(1304,'1','285','1',1,'Retail Sale Id 1310',720.00,0.00,0.00,1.00,90.00,'2022-11-02 16:58:00','',''),(1305,'1','285','1',1,'Retail Sale Id 1314',2001.60,0.00,0.00,2.78,250.20,'2022-11-02 16:59:41','',''),(1306,'1','285','1',1,'Retail Sale Id 1316',11137.50,0.00,0.00,16.50,742.50,'2022-11-02 17:00:22','',''),(1307,'1','285','1',1,'Return of Retail Sale Id 1316',0.00,11137.50,16.50,0.00,-742.50,'2022-11-02 19:56:31','',''),(1308,'1','285','1',1,'Retail Sale Id 1317',2862.00,0.00,0.00,4.24,190.80,'2022-11-02 19:58:02','',''),(1309,'1','285','1',1,'Retail Sale Id 1318',7063.20,0.00,0.00,9.81,882.90,'2022-11-02 19:59:45','',''),(1310,'1','285','1',1,'Retail Sale Id 1319',3600.00,0.00,0.00,5.00,450.00,'2022-11-03 08:00:05','',''),(1311,'1','285','1',1,'Retail Sale Id 1321',43915.50,0.00,0.00,65.06,2927.70,'2022-11-03 08:04:47','',''),(1312,'1','285','1',1,'Retail Sale Id 1322',1497.60,0.00,0.00,2.08,187.20,'2022-11-03 08:09:19','',''),(1313,'1','285','1',1,'Retail Sale Id 1323',13500.00,0.00,0.00,20.00,900.00,'2022-11-03 08:11:08','',''),(1314,'1','285','1',1,'Retail Sale Id 1324',5040.00,0.00,0.00,7.00,630.00,'2022-11-03 08:13:12','',''),(1315,'1','285','1',1,'Retail Sale Id 1325',3988.80,0.00,0.00,5.54,498.60,'2022-11-03 08:14:29','',''),(1316,'1','285','1',1,'Retail Sale Id 1326',3988.80,0.00,0.00,5.54,498.60,'2022-11-03 08:15:18','',''),(1317,'1','285','1',1,'Retail Sale Id 1327',40500.00,0.00,0.00,60.00,2700.00,'2022-11-03 08:16:16','',''),(1318,'1','285','1',1,'Retail Sale Id 1328',41964.75,0.00,0.00,62.17,2797.65,'2022-11-03 08:17:14','',''),(1319,'1','285','1',1,'Retail Sale Id 1329',45225.00,0.00,0.00,67.00,3015.00,'2022-11-03 08:18:11','',''),(1320,'1','285','1',1,'Retail Sale Id 1330',41735.25,0.00,0.00,61.83,2782.35,'2022-11-03 08:19:29','',''),(1321,'1','285','1',1,'Retail Sale Id 1331',2203.20,0.00,0.00,3.06,275.40,'2022-11-03 08:20:31','',''),(1322,'1','285','1',1,'Retail Sale Id 1332',4500.00,0.00,0.00,6.25,562.50,'2022-11-03 08:23:58','',''),(1323,'1','285','1',1,'Retail Sale Id 1333',2203.20,0.00,0.00,3.06,275.40,'2022-11-03 08:25:36','',''),(1324,'1','285','1',1,'Return of Retail Sale Id 1323',0.00,13500.00,20.00,0.00,-900.00,'2022-11-03 08:28:42','',''),(1325,'1','285','1',1,'Retail Sale Id 1334',16200.00,0.00,0.00,24.00,1080.00,'2022-11-03 08:29:28','',''),(1326,'1','285','1',1,'Retail Sale Id 1335',1440.00,0.00,0.00,2.00,180.00,'2022-11-03 08:32:05','',''),(1327,'1','285','1',1,'Retail Sale Id 1336',5702.40,0.00,0.00,7.92,712.80,'2022-11-03 08:33:20','',''),(1328,'1','285','1',1,'Retail Sale Id 1337',34499.25,0.00,0.00,51.11,2299.95,'2022-11-03 08:51:51','',''),(1329,'1','285','1',1,'Retail Sale Id 1338',1000.80,0.00,0.00,1.39,125.10,'2022-11-03 09:07:06','',''),(1330,'1','285','1',1,'Retail Sale Id 1339',46062.00,0.00,0.00,68.24,3070.80,'2022-11-03 09:12:13','',''),(1331,'1','285','1',1,'Retail Sale Id 1340',40500.00,0.00,0.00,60.00,2700.00,'2022-11-03 09:18:12','',''),(1332,'1','285','1',1,'Retail Sale Id 1341',720.00,0.00,0.00,1.00,90.00,'2022-11-03 09:21:31','',''),(1333,'1','285','1',1,'Return of Retail Sale Id 1340',0.00,40500.00,60.00,0.00,-2700.00,'2022-11-03 09:28:42','',''),(1334,'1','285','1',1,'Retail Sale Id 1342',41161.50,0.00,0.00,60.98,2744.10,'2022-11-03 09:29:28','',''),(1335,'1','285','1',1,'Retail Sale Id 1343',9828.00,0.00,0.00,14.56,655.20,'2022-11-03 09:32:02','',''),(1336,'1','285','1',1,'Retail Sale Id 1345',2203.20,0.00,0.00,3.06,275.40,'2022-11-03 09:35:58','',''),(1337,'1','285','1',1,'Retail Sale Id 1346',41141.25,0.00,0.00,60.95,2742.75,'2022-11-03 09:57:43','',''),(1338,'1','285','1',1,'Retail Sale Id 1347',7200.00,0.00,0.00,10.00,900.00,'2022-11-03 10:00:48','',''),(1339,'1','285','1',1,'Retail Sale Id 1348',1000.80,0.00,0.00,1.39,125.10,'2022-11-03 10:05:39','',''),(1340,'1','285','1',1,'Retail Sale Id 1349',1497.60,0.00,0.00,2.08,187.20,'2022-11-03 10:17:35','',''),(1341,'1','285','1',1,'Retail Sale Id 1350',2001.60,0.00,0.00,2.78,250.20,'2022-11-03 10:18:47','',''),(1342,'1','285','1',1,'Retail Sale Id 1351',51435.00,0.00,0.00,76.20,3429.00,'2022-11-03 10:26:35','',''),(1343,'1','285','1',1,'Retail Sale Id 1352',2203.20,0.00,0.00,3.06,275.40,'2022-11-03 10:30:05','',''),(1344,'1','285','1',1,'Retail Sale Id 1353',3600.00,0.00,0.00,5.00,450.00,'2022-11-03 10:31:56','',''),(1345,'1','285','1',1,'Retail Sale Id 1354',5040.00,0.00,0.00,7.00,630.00,'2022-11-03 10:33:47','',''),(1346,'1','285','1',1,'Retail Sale Id 1355',7200.00,0.00,0.00,10.00,900.00,'2022-11-03 11:15:45','',''),(1347,'1','285','1',1,'Retail Sale Id 1356',7200.00,0.00,0.00,10.00,900.00,'2022-11-03 11:16:36','',''),(1348,'1','285','1',1,'Retail Sale Id 1357',3398.40,0.00,0.00,4.72,424.80,'2022-11-03 11:24:26','',''),(1349,'1','285','1',1,'Retail Sale Id 1358',40500.00,0.00,0.00,60.00,2700.00,'2022-11-03 11:33:09','',''),(1350,'1','285','1',1,'Retail Sale Id 1359',2001.60,0.00,0.00,2.78,250.20,'2022-11-03 11:34:19','',''),(1351,'1','285','1',1,'Retail Sale Id 1360',2160.00,0.00,0.00,3.00,270.00,'2022-11-03 11:35:31','',''),(1352,'1','285','1',1,'Retail Sale Id 1361',40500.00,0.00,0.00,60.00,2700.00,'2022-11-03 11:39:30','',''),(1353,'1','285','1',1,'Retail Sale Id 1362',37800.00,0.00,0.00,56.00,2520.00,'2022-11-03 11:41:20','',''),(1354,'1','285','1',1,'Retail Sale Id 1363',1440.00,0.00,0.00,2.00,180.00,'2022-11-03 11:47:02','',''),(1355,'1','285','1',1,'Retail Sale Id 1364',1497.60,0.00,0.00,2.08,187.20,'2022-11-03 11:54:32','',''),(1356,'1','285','1',1,'Retail Sale Id 1365',799.20,0.00,0.00,1.11,99.90,'2022-11-03 11:55:32','',''),(1357,'1','285','1',1,'Retail Sale Id 1367',46190.25,0.00,0.00,68.43,3079.35,'2022-11-03 11:59:47','',''),(1358,'1','285','1',1,'Retail Sale Id 1368',2880.00,0.00,0.00,4.00,360.00,'2022-11-03 12:11:18','',''),(1359,'1','285','1',1,'Retail Sale Id 1369',1440.00,0.00,0.00,2.00,180.00,'2022-11-03 12:17:00','',''),(1360,'1','285','1',1,'Retail Sale Id 1370',2102.40,0.00,0.00,2.92,262.80,'2022-11-03 12:18:15','',''),(1361,'1','285','1',1,'Retail Sale Id 1371',2203.20,0.00,0.00,3.06,275.40,'2022-11-03 12:20:42','',''),(1362,'1','285','1',1,'Retail Sale Id 1372',15525.00,0.00,0.00,23.00,1035.00,'2022-11-03 12:26:07','',''),(1363,'1','285','1',1,'Retail Sale Id 1373',5040.00,0.00,0.00,7.00,630.00,'2022-11-03 12:28:10','',''),(1364,'1','285','1',1,'Retail Sale Id 1374',2001.60,0.00,0.00,2.78,250.20,'2022-11-03 12:37:42','',''),(1365,'1','285','1',1,'Retail Sale Id 1375',3002.40,0.00,0.00,4.17,375.30,'2022-11-03 12:39:26','',''),(1366,'1','285','1',1,'Retail Sale Id 1376',138807.00,0.00,0.00,205.64,9253.80,'2022-11-03 12:44:35','',''),(1367,'1','285','1',1,'Retail Sale Id 1377',40317.75,0.00,0.00,59.73,2687.85,'2022-11-03 12:49:09','',''),(1368,'1','285','1',1,'Retail Sale Id 1378',40500.00,0.00,0.00,60.00,2700.00,'2022-11-03 13:19:12','',''),(1369,'1','285','1',1,'Retail Sale Id 1379',41843.25,0.00,0.00,61.99,2789.55,'2022-11-03 13:30:21','',''),(1370,'1','285','1',1,'Retail Sale Id 1380',41661.00,0.00,0.00,61.72,2777.40,'2022-11-03 13:50:37','',''),(1371,'1','285','1',1,'Retail Sale Id 1381',42714.00,0.00,0.00,63.28,2847.60,'2022-11-03 13:52:41','',''),(1372,'1','285','1',1,'Retail Sale Id 1382',22774.50,0.00,0.00,33.74,1518.30,'2022-11-03 13:53:31','',''),(1373,'1','285','1',1,'Retail Sale Id 1383',2880.00,0.00,0.00,4.00,360.00,'2022-11-03 14:00:49','',''),(1374,'1','285','1',1,'Retail Sale Id 1384',2160.00,0.00,0.00,3.00,270.00,'2022-11-03 14:09:46','',''),(1375,'1','285','1',1,'Retail Sale Id 1385',799.20,0.00,0.00,1.11,99.90,'2022-11-03 14:17:12','',''),(1376,'1','285','1',1,'Retail Sale Id 1386',88182.00,0.00,0.00,130.64,5878.80,'2022-11-03 14:36:44','',''),(1377,'1','285','1',1,'Retail Sale Id 1387',351344.25,0.00,0.00,520.51,23422.95,'2022-11-03 14:40:17','',''),(1378,'1','285','1',1,'Retail Sale Id 1388',799.20,0.00,0.00,1.11,99.90,'2022-11-03 14:41:51','',''),(1379,'1','285','1',1,'Retail Sale Id 1389',202500.00,0.00,0.00,300.00,13500.00,'2022-11-03 14:44:25','',''),(1380,'1','285','1',1,'Retail Sale Id 1390',41478.75,0.00,0.00,61.45,2765.25,'2022-11-03 14:46:27','',''),(1381,'1','285','1',1,'Retail Sale Id 1391',799.20,0.00,0.00,1.11,99.90,'2022-11-03 14:48:16','',''),(1382,'1','285','1',1,'Retail Sale Id 1392',1447.20,0.00,0.00,2.01,180.90,'2022-11-03 14:49:14','',''),(1383,'1','285','1',1,'Retail Sale Id 1393',9639.00,0.00,0.00,14.28,642.60,'2022-11-03 14:51:24','',''),(1384,'1','285','1',1,'Retail Sale Id 1394',1440.00,0.00,0.00,2.00,180.00,'2022-11-03 14:56:05','',''),(1385,'1','285','1',1,'Retail Sale Id 1395',3600.00,0.00,0.00,5.00,450.00,'2022-11-03 15:03:35','',''),(1386,'1','285','1',1,'Retail Sale Id 1396',2880.00,0.00,0.00,4.00,360.00,'2022-11-03 15:10:16','',''),(1387,'1','285','1',1,'Retail Sale Id 1397',2880.00,0.00,0.00,4.00,360.00,'2022-11-03 15:16:57','',''),(1388,'1','285','1',1,'Retail Sale Id 1398',37806.75,0.00,0.00,56.01,2520.45,'2022-11-03 15:22:20','',''),(1389,'1','285','1',1,'Retail Sale Id 1399',5040.00,0.00,0.00,7.00,630.00,'2022-11-03 15:25:27','',''),(1390,'1','285','1',1,'Retail Sale Id 1400',799.20,0.00,0.00,1.11,99.90,'2022-11-03 15:26:58','',''),(1391,'1','285','1',1,'Retail Sale Id 1401',1497.60,0.00,0.00,2.08,187.20,'2022-11-03 15:27:57','',''),(1392,'1','285','1',1,'Return of Retail Sale Id 1397',0.00,2880.00,4.00,0.00,-360.00,'2022-11-03 15:29:01','',''),(1393,'1','285','1',1,'Retail Sale Id 1402',2700.00,0.00,0.00,3.75,337.50,'2022-11-03 15:30:05','',''),(1394,'1','285','1',1,'Retail Sale Id 1403',3600.00,0.00,0.00,5.00,450.00,'2022-11-03 15:37:34','',''),(1395,'1','285','1',1,'Retail Sale Id 1404',19271.25,0.00,0.00,28.55,1284.75,'2022-11-03 15:43:04','',''),(1396,'1','285','1',1,'Retail Sale Id 1405',9360.00,0.00,0.00,13.00,1170.00,'2022-11-03 15:46:51','',''),(1397,'1','285','1',1,'Retail Sale Id 1406',799.20,0.00,0.00,1.11,99.90,'2022-11-03 15:51:25','',''),(1398,'1','285','1',1,'Retail Sale Id 1407',40500.00,0.00,0.00,60.00,2700.00,'2022-11-03 15:53:03','',''),(1399,'1','285','1',1,'Retail Sale Id 1409',720.00,0.00,0.00,1.00,90.00,'2022-11-03 15:54:32','',''),(1400,'1','285','1',1,'Retail Sale Id 1410',1497.60,0.00,0.00,2.08,187.20,'2022-11-03 15:59:19','',''),(1401,'1','285','1',1,'Retail Sale Id 1411',2203.20,0.00,0.00,3.06,275.40,'2022-11-03 16:04:25','',''),(1402,'1','285','1',1,'Retail Sale Id 1412',5040.00,0.00,0.00,7.00,630.00,'2022-11-03 16:05:44','',''),(1403,'1','285','1',1,'Retail Sale Id 1413',4399.20,0.00,0.00,6.11,549.90,'2022-11-03 16:08:39','',''),(1404,'1','285','1',1,'Retail Sale Id 1414',9000.00,0.00,0.00,12.50,1125.00,'2022-11-03 16:09:53','',''),(1405,'1','285','1',1,'Retail Sale Id 1415',11947.50,0.00,0.00,17.70,796.50,'2022-11-03 16:11:45','',''),(1406,'1','285','1',1,'Retail Sale Id 1416',3600.00,0.00,0.00,5.00,450.00,'2022-11-03 16:15:59','',''),(1407,'1','285','1',1,'Retail Sale Id 1417',1000.80,0.00,0.00,1.39,125.10,'2022-11-03 16:17:07','',''),(1408,'1','285','1',1,'Retail Sale Id 1418',2203.20,0.00,0.00,3.06,275.40,'2022-11-03 16:24:59','',''),(1409,'1','285','1',1,'Retail Sale Id 1419',38475.00,0.00,0.00,57.00,2565.00,'2022-11-03 16:26:36','',''),(1410,'1','285','1',1,'Retail Sale Id 1420',2160.00,0.00,0.00,3.00,270.00,'2022-11-03 16:28:57','',''),(1411,'1','285','1',1,'Retail Sale Id 1421',1497.60,0.00,0.00,2.08,187.20,'2022-11-03 16:30:43','',''),(1412,'1','285','1',1,'Retail Sale Id 1422',3600.00,0.00,0.00,5.00,450.00,'2022-11-03 16:32:57','',''),(1413,'1','285','1',1,'Retail Sale Id 1423',34364.25,0.00,0.00,50.91,2290.95,'2022-11-03 16:36:03','',''),(1414,'1','285','1',1,'Retail Sale Id 1424',45960.75,0.00,0.00,68.09,3064.05,'2022-11-03 16:41:18','',''),(1415,'1','285','1',1,'Retail Sale Id 1425',40358.25,0.00,0.00,59.79,2690.55,'2022-11-03 16:43:57','',''),(1416,'1','285','1',1,'Retail Sale Id 1426',9648.00,0.00,0.00,13.40,1206.00,'2022-11-03 16:55:01','',''),(1417,'1','285','1',1,'Return of Retail Sale Id 1425',0.00,40358.25,59.79,0.00,-2690.55,'2022-11-03 16:57:23','',''),(1418,'1','285','1',1,'Retail Sale Id 1428',40358.25,0.00,0.00,59.79,2690.55,'2022-11-03 17:03:14','',''),(1419,'1','285','1',1,'Return of Retail Sale Id 1417',0.00,1000.80,1.39,0.00,-125.10,'2022-11-03 18:37:02','',''),(1420,'1','285','1',1,'Retail Sale Id 1430',986.40,0.00,0.00,1.37,123.30,'2022-11-03 18:38:35','',''),(1421,'1','285','1',1,'Retail Sale Id 1431',33750.00,0.00,0.00,50.00,2250.00,'2022-11-04 07:58:47','',''),(1422,'1','285','1',1,'Retail Sale Id 1432',10158.75,0.00,0.00,15.05,677.25,'2022-11-04 08:06:37','',''),(1423,'1','285','1',1,'Retail Sale Id 1433',41573.25,0.00,0.00,61.59,2771.55,'2022-11-04 08:08:09','',''),(1424,'1','285','1',1,'Retail Sale Id 1434',42275.25,0.00,0.00,62.63,2818.35,'2022-11-04 08:16:40','',''),(1425,'1','285','1',1,'Retail Sale Id 1435',39150.00,0.00,0.00,58.00,2610.00,'2022-11-04 08:21:08','',''),(1426,'1','285','1',1,'Retail Sale Id 1436',23625.00,0.00,0.00,35.00,1575.00,'2022-11-04 08:27:05','',''),(1427,'1','285','1',1,'Retail Sale Id 1437',44752.50,0.00,0.00,66.30,2983.50,'2022-11-04 08:28:37','',''),(1428,'1','285','1',1,'Retail Sale Id 1438',85029.75,0.00,0.00,125.97,5668.65,'2022-11-04 08:29:41','',''),(1429,'1','285','1',1,'Retail Sale Id 1439',53237.25,0.00,0.00,78.87,3549.15,'2022-11-04 08:54:00','',''),(1430,'1','285','1',1,'Retail Sale Id 1440',16598.25,0.00,0.00,24.59,1106.55,'2022-11-04 09:03:14','',''),(1431,'1','285','1',1,'Retail Sale Id 1441',207542.25,0.00,0.00,307.47,13836.15,'2022-11-04 10:08:26','',''),(1432,'1','285','1',1,'Retail Sale Id 1442',1497.60,0.00,0.00,2.08,187.20,'2022-11-04 10:12:54','',''),(1433,'1','285','1',1,'Retail Sale Id 1443',3103.20,0.00,0.00,4.31,387.90,'2022-11-04 10:14:09','',''),(1434,'1','285','1',1,'Retail Sale Id 1444',2880.00,0.00,0.00,4.00,360.00,'2022-11-04 10:16:28','',''),(1435,'1','285','1',1,'Retail Sale Id 1445',2160.00,0.00,0.00,3.00,270.00,'2022-11-04 10:17:11','',''),(1436,'1','285','1',1,'Retail Sale Id 1446',1440.00,0.00,0.00,2.00,180.00,'2022-11-04 10:19:55','',''),(1437,'1','285','1',1,'Retail Sale Id 1447',2160.00,0.00,0.00,3.00,270.00,'2022-11-04 10:21:04','',''),(1438,'1','285','1',1,'Retail Sale Id 1448',2203.20,0.00,0.00,3.06,275.40,'2022-11-04 10:22:01','',''),(1439,'1','285','1',1,'Retail Sale Id 1449',2160.00,0.00,0.00,3.00,270.00,'2022-11-04 10:24:55','',''),(1440,'1','285','1',1,'Retail Sale Id 1450',31880.25,0.00,0.00,47.23,2125.35,'2022-11-04 10:26:13','',''),(1441,'1','285','1',1,'Retail Sale Id 1451',7920.00,0.00,0.00,11.00,990.00,'2022-11-04 10:27:33','',''),(1442,'1','285','1',1,'Retail Sale Id 1452',1440.00,0.00,0.00,2.00,180.00,'2022-11-04 10:29:41','',''),(1443,'1','285','1',1,'Retail Sale Id 1453',3600.00,0.00,0.00,5.00,450.00,'2022-11-04 10:30:27','',''),(1444,'1','285','1',1,'Retail Sale Id 1454',2196.00,0.00,0.00,3.05,274.50,'2022-11-04 10:31:45','',''),(1445,'1','285','1',1,'Retail Sale Id 1455',2880.00,0.00,0.00,4.00,360.00,'2022-11-04 10:32:51','',''),(1446,'1','285','1',1,'Retail Sale Id 1456',7927.20,0.00,0.00,11.01,990.90,'2022-11-04 10:33:58','',''),(1447,'1','285','1',1,'Retail Sale Id 1457',2196.00,0.00,0.00,3.05,274.50,'2022-11-04 10:34:57','',''),(1448,'1','285','1',1,'Retail Sale Id 1458',2167.20,0.00,0.00,3.01,270.90,'2022-11-04 10:36:09','',''),(1449,'1','285','1',1,'Retail Sale Id 1459',40911.75,0.00,0.00,60.61,2727.45,'2022-11-04 10:40:04','',''),(1450,'1','285','1',1,'Retail Sale Id 1460',97584.75,0.00,0.00,144.57,6505.65,'2022-11-04 10:44:21','',''),(1451,'1','285','1',1,'Retail Sale Id 1461',45495.00,0.00,0.00,67.40,3033.00,'2022-11-04 10:48:14','',''),(1452,'1','285','1',1,'Retail Sale Id 1462',9450.00,0.00,0.00,14.00,630.00,'2022-11-04 10:49:19','',''),(1453,'1','285','1',1,'Retail Sale Id 1463',162000.00,0.00,0.00,240.00,10800.00,'2022-11-04 10:50:14','',''),(1454,'1','285','1',1,'Retail Sale Id 1464',67500.00,0.00,0.00,100.00,4500.00,'2022-11-04 10:57:19','',''),(1455,'1','285','1',1,'Retail Sale Id 1465',43875.00,0.00,0.00,65.00,2925.00,'2022-11-04 11:04:04','',''),(1456,'1','285','1',1,'Retail Sale Id 1466',3600.00,0.00,0.00,5.00,450.00,'2022-11-04 11:05:48','',''),(1457,'1','285','1',1,'Retail Sale Id 1467',40500.00,0.00,0.00,60.00,2700.00,'2022-11-04 11:07:36','',''),(1458,'1','285','1',1,'Retail Sale Id 1468',3600.00,0.00,0.00,5.00,450.00,'2022-11-04 11:11:37','',''),(1459,'1','285','1',1,'Retail Sale Id 1469',5040.00,0.00,0.00,7.00,630.00,'2022-11-04 11:14:59','',''),(1460,'1','285','1',1,'Retail Sale Id 1470',2160.00,0.00,0.00,3.00,270.00,'2022-11-04 11:16:34','',''),(1461,'1','285','1',1,'Retail Sale Id 1471',1497.60,0.00,0.00,2.08,187.20,'2022-11-04 11:17:50','',''),(1462,'1','285','1',1,'Retail Sale Id 1472',1396.80,0.00,0.00,1.94,174.60,'2022-11-04 11:19:38','',''),(1463,'1','285','1',1,'Retail Sale Id 1473',27000.00,0.00,0.00,40.00,1800.00,'2022-11-04 11:25:50','',''),(1464,'1','285','1',1,'Retail Sale Id 1474',39831.75,0.00,0.00,59.01,2655.45,'2022-11-04 11:41:57','',''),(1465,'1','285','1',1,'Retail Sale Id 1475',2001.60,0.00,0.00,2.78,250.20,'2022-11-04 12:04:52','',''),(1466,'1','285','1',1,'Retail Sale Id 1476',9360.00,0.00,0.00,13.00,1170.00,'2022-11-04 12:06:47','',''),(1467,'1','285','1',1,'Retail Sale Id 1477',720.00,0.00,0.00,1.00,90.00,'2022-11-04 12:33:16','',''),(1468,'1','285','1',1,'Retail Sale Id 1478',720.00,0.00,0.00,1.00,90.00,'2022-11-04 12:53:15','',''),(1469,'1','285','1',1,'Retail Sale Id 1479',5040.00,0.00,0.00,7.00,630.00,'2022-11-04 13:11:26','',''),(1470,'1','285','1',1,'Retail Sale Id 1480',4003.20,0.00,0.00,5.56,500.40,'2022-11-04 13:13:03','',''),(1471,'1','285','1',1,'Retail Sale Id 1481',40668.75,0.00,0.00,60.25,2711.25,'2022-11-04 13:26:57','',''),(1472,'1','285','1',1,'Retail Sale Id 1482',41121.00,0.00,0.00,60.92,2741.40,'2022-11-04 13:39:08','',''),(1473,'1','285','1',1,'Retail Sale Id 1483',41229.00,0.00,0.00,61.08,2748.60,'2022-11-04 13:49:20','',''),(1474,'1','285','1',1,'Retail Sale Id 1484',2880.00,0.00,0.00,4.00,360.00,'2022-11-04 15:00:13','',''),(1475,'1','285','1',1,'Retail Sale Id 1485',53662.50,0.00,0.00,79.50,3577.50,'2022-11-04 15:05:23','',''),(1476,'1','285','1',1,'Retail Sale Id 1487',16875.00,0.00,0.00,25.00,1125.00,'2022-11-04 15:16:13','',''),(1477,'1','285','1',1,'Retail Sale Id 1488',2001.60,0.00,0.00,2.78,250.20,'2022-11-04 15:20:08','',''),(1478,'1','285','1',1,'Retail Sale Id 1489',2001.60,0.00,0.00,2.78,250.20,'2022-11-04 15:23:56','',''),(1479,'1','285','1',1,'Retail Sale Id 1490',2001.60,0.00,0.00,2.78,250.20,'2022-11-04 15:38:37','',''),(1480,'1','285','1',1,'Retail Sale Id 1491',1440.00,0.00,0.00,2.00,180.00,'2022-11-04 15:40:55','',''),(1481,'1','285','1',1,'Retail Sale Id 1492',2160.00,0.00,0.00,3.00,270.00,'2022-11-04 15:42:50','',''),(1482,'1','285','1',1,'Retail Sale Id 1493',12240.00,0.00,0.00,17.00,1530.00,'2022-11-04 15:44:16','',''),(1483,'1','285','1',1,'Retail Sale Id 1494',4320.00,0.00,0.00,6.00,540.00,'2022-11-04 15:45:56','',''),(1484,'1','285','1',1,'Retail Sale Id 1495',83187.00,0.00,0.00,123.24,5545.80,'2022-11-04 15:50:52','',''),(1485,'1','285','1',1,'Retail Sale Id 1497',1447.20,0.00,0.00,2.01,180.90,'2022-11-04 15:53:15','',''),(1486,'1','285','1',1,'Retail Sale Id 1498',748.80,0.00,0.00,1.04,93.60,'2022-11-04 15:55:10','',''),(1487,'1','285','1',1,'Retail Sale Id 1499',3600.00,0.00,0.00,5.00,450.00,'2022-11-04 15:59:45','',''),(1488,'1','285','1',1,'Retail Sale Id 1500',4320.00,0.00,0.00,6.00,540.00,'2022-11-04 16:14:25','',''),(1489,'1','285','1',1,'Retail Sale Id 1501',2001.60,0.00,0.00,2.78,250.20,'2022-11-04 16:21:04','',''),(1490,'1','285','1',1,'Retail Sale Id 1502',7546.50,0.00,0.00,11.18,503.10,'2022-11-04 16:26:09','',''),(1491,'1','285','1',1,'Retail Sale Id 1504',720.00,0.00,0.00,1.00,90.00,'2022-11-04 16:29:21','',''),(1492,'1','285','1',1,'Return of Retail Sale Id 1476',0.00,9360.00,13.00,0.00,-1170.00,'2022-11-04 16:30:34','',''),(1493,'1','285','1',1,'Retail Sale Id 1505',1447.20,0.00,0.00,2.01,180.90,'2022-11-04 16:37:00','',''),(1494,'1','285','1',1,'Retail Sale Id 1506',3600.00,0.00,0.00,5.00,450.00,'2022-11-04 16:39:27','',''),(1495,'1','285','1',1,'Retail Sale Id 1507',33736.50,0.00,0.00,49.98,2249.10,'2022-11-04 16:43:26','',''),(1496,'1','285','1',1,'Retail Sale Id 1508',2203.20,0.00,0.00,3.06,275.40,'2022-11-04 16:47:24','',''),(1497,'1','285','1',1,'Retail Sale Id 1509',40500.00,0.00,0.00,60.00,2700.00,'2022-11-04 16:49:12','',''),(1498,'1','285','1',1,'Retail Sale Id 1510',11520.00,0.00,0.00,16.00,1440.00,'2022-11-04 16:53:55','',''),(1499,'1','285','1',1,'Retail Sale Id 1511',3600.00,0.00,0.00,5.00,450.00,'2022-11-04 16:58:31','',''),(1500,'1','285','1',1,'Retail Sale Id 1512',2203.20,0.00,0.00,3.06,275.40,'2022-11-04 17:00:00','',''),(1501,'1','285','1',1,'Retail Sale Id 1513',799.20,0.00,0.00,1.11,99.90,'2022-11-04 17:03:01','',''),(1502,'1','285','1',1,'Retail Sale Id 1515',7200.00,0.00,0.00,10.00,900.00,'2022-11-04 17:04:46','',''),(1503,'1','285','1',1,'Retail Sale Id 1516',305005.50,0.00,0.00,451.86,20333.70,'2022-11-04 17:16:49','',''),(1504,'1','285','1',1,'Retail Sale Id 1517',43368.75,0.00,0.00,64.25,2891.25,'2022-11-04 17:22:43','',''),(1505,'1','285','1',1,'Return of Retail Sale Id 1494',0.00,4320.00,6.00,0.00,-540.00,'2022-11-04 17:41:21','',''),(1506,'1','285','1',1,'Return of Retail Sale Id 1515',0.00,7200.00,10.00,0.00,-900.00,'2022-11-04 17:42:52','',''),(1507,'1','285','1',1,'Retail Sale Id 1519',7236.00,0.00,0.00,10.05,904.50,'2022-11-04 17:44:04','',''),(1508,'1','285','1',1,'Return of Retail Sale Id 1495',0.00,83187.00,123.24,0.00,-5545.80,'2022-11-04 17:59:22','',''),(1509,'1','285','1',1,'Retail Sale Id 1520',136863.00,0.00,0.00,202.76,9124.20,'2022-11-04 19:12:05','',''),(1510,'1','285','1',1,'Return of Retail Sale Id 1513',0.00,799.20,1.11,0.00,-99.90,'2022-11-04 19:13:14','',''),(1511,'1','285','1',1,'Retail Sale Id 1521',792.00,0.00,0.00,1.10,99.00,'2022-11-04 19:14:25','',''),(1512,'1','285','1',1,'Retail Sale Id 1522',1440.00,0.00,0.00,2.00,180.00,'2022-11-05 08:26:42','',''),(1513,'1','285','1',1,'Retail Sale Id 1523',2203.20,0.00,0.00,3.06,275.40,'2022-11-05 08:27:32','',''),(1514,'1','285','1',1,'Retail Sale Id 1524',39312.00,0.00,0.00,58.24,2620.80,'2022-11-05 08:31:13','',''),(1515,'1','285','1',1,'Retail Sale Id 1525',3002.40,0.00,0.00,4.17,375.30,'2022-11-05 08:31:55','',''),(1516,'1','285','1',1,'Retail Sale Id 1526',24975.00,0.00,0.00,37.00,1665.00,'2022-11-05 08:32:44','',''),(1517,'1','285','1',1,'Retail Sale Id 1527',110727.00,0.00,0.00,164.04,7381.80,'2022-11-05 08:33:20','',''),(1518,'1','285','1',1,'Retail Sale Id 1528',47250.00,0.00,0.00,70.00,3150.00,'2022-11-05 08:33:48','',''),(1519,'1','285','1',1,'Retail Sale Id 1529',33750.00,0.00,0.00,50.00,2250.00,'2022-11-05 08:34:20','',''),(1520,'1','285','1',1,'Retail Sale Id 1530',799.20,0.00,0.00,1.11,99.90,'2022-11-05 08:35:12','',''),(1521,'1','285','1',1,'Retail Sale Id 1531',45744.75,0.00,0.00,67.77,3049.65,'2022-11-05 08:35:51','',''),(1522,'1','285','1',1,'Retail Sale Id 1533',27000.00,0.00,0.00,40.00,1800.00,'2022-11-05 08:36:22','',''),(1523,'1','285','1',1,'Retail Sale Id 1534',2001.60,0.00,0.00,2.78,250.20,'2022-11-05 08:37:29','',''),(1524,'1','285','1',1,'Retail Sale Id 1535',1000.80,0.00,0.00,1.39,125.10,'2022-11-05 08:37:58','',''),(1525,'1','285','1',1,'Retail Sale Id 1536',7200.00,0.00,0.00,10.00,900.00,'2022-11-05 08:38:29','',''),(1526,'1','285','1',1,'Retail Sale Id 1537',799.20,0.00,0.00,1.11,99.90,'2022-11-05 08:38:56','',''),(1527,'1','285','1',1,'Retail Sale Id 1538',720.00,0.00,0.00,1.00,90.00,'2022-11-05 08:39:28','',''),(1528,'1','285','1',1,'Retail Sale Id 1539',1000.80,0.00,0.00,1.39,125.10,'2022-11-05 08:39:53','',''),(1529,'1','285','1',1,'Retail Sale Id 1540',799.20,0.00,0.00,1.11,99.90,'2022-11-05 08:40:35','',''),(1530,'1','285','1',1,'Retail Sale Id 1541',33750.00,0.00,0.00,50.00,2250.00,'2022-11-05 08:41:15','',''),(1531,'1','285','1',1,'Retail Sale Id 1542',36000.00,0.00,0.00,50.00,4500.00,'2022-11-05 08:43:22','',''),(1532,'1','285','1',1,'Return of Retail Sale Id 1542',0.00,36000.00,50.00,0.00,-4500.00,'2022-11-05 08:45:37','',''),(1533,'1','285','1',1,'Retail Sale Id 1543',39001.50,0.00,0.00,57.78,2600.10,'2022-11-05 08:46:50','',''),(1534,'1','285','1',1,'Retail Sale Id 1544',2001.60,0.00,0.00,2.78,250.20,'2022-11-05 08:49:00','',''),(1535,'1','285','1',1,'Retail Sale Id 1545',2160.00,0.00,0.00,3.00,270.00,'2022-11-05 08:49:50','',''),(1536,'1','285','1',1,'Retail Sale Id 1546',2001.60,0.00,0.00,2.78,250.20,'2022-11-05 08:50:43','',''),(1537,'1','285','1',1,'Retail Sale Id 1547',27000.00,0.00,0.00,40.00,1800.00,'2022-11-05 08:51:51','',''),(1538,'1','285','1',1,'Retail Sale Id 1548',2880.00,0.00,0.00,4.00,360.00,'2022-11-05 08:57:06','',''),(1539,'1','285','1',1,'Retail Sale Id 1549',720.00,0.00,0.00,1.00,90.00,'2022-11-05 08:58:29','',''),(1540,'1','285','1',1,'Retail Sale Id 1550',1447.20,0.00,0.00,2.01,180.90,'2022-11-05 09:01:25','',''),(1541,'1','285','1',1,'Retail Sale Id 1551',2001.60,0.00,0.00,2.78,250.20,'2022-11-05 09:08:46','',''),(1542,'1','285','1',1,'Retail Sale Id 1552',1000.80,0.00,0.00,1.39,125.10,'2022-11-05 09:13:05','',''),(1543,'1','285','1',1,'Retail Sale Id 1553',4320.00,0.00,0.00,6.00,540.00,'2022-11-05 09:15:07','',''),(1544,'1','285','1',1,'Retail Sale Id 1554',720.00,0.00,0.00,1.00,90.00,'2022-11-05 09:16:29','',''),(1545,'1','285','1',1,'Retail Sale Id 1555',1497.60,0.00,0.00,2.08,187.20,'2022-11-05 09:19:45','',''),(1546,'1','285','1',1,'Retail Sale Id 1556',799.20,0.00,0.00,1.11,99.90,'2022-11-05 09:28:51','',''),(1547,'1','285','1',1,'Retail Sale Id 1557',41465.25,0.00,0.00,61.43,2764.35,'2022-11-05 09:31:13','',''),(1548,'1','285','1',1,'Retail Sale Id 1558',1440.00,0.00,0.00,2.00,180.00,'2022-11-05 09:34:28','',''),(1549,'1','285','1',1,'Retail Sale Id 1559',799.20,0.00,0.00,1.11,99.90,'2022-11-05 09:37:15','',''),(1550,'1','285','1',1,'Retail Sale Id 1560',2160.00,0.00,0.00,3.00,270.00,'2022-11-05 09:44:12','',''),(1551,'1','285','1',1,'Retail Sale Id 1561',799.20,0.00,0.00,1.11,99.90,'2022-11-05 09:45:05','',''),(1552,'1','285','1',1,'Retail Sale Id 1562',799.20,0.00,0.00,1.11,99.90,'2022-11-05 09:46:04','',''),(1553,'1','285','1',1,'Retail Sale Id 1563',1000.80,0.00,0.00,1.39,125.10,'2022-11-05 09:46:49','',''),(1554,'1','285','1',1,'Retail Sale Id 1564',1699.20,0.00,0.00,2.36,212.40,'2022-11-05 09:47:45','',''),(1555,'1','285','1',1,'Retail Sale Id 1565',799.20,0.00,0.00,1.11,99.90,'2022-11-05 09:49:13','',''),(1556,'1','285','1',1,'Retail Sale Id 1566',2203.20,0.00,0.00,3.06,275.40,'2022-11-05 09:49:42','',''),(1557,'1','285','1',1,'Retail Sale Id 1567',799.20,0.00,0.00,1.11,99.90,'2022-11-05 09:51:22','',''),(1558,'1','285','1',1,'Retail Sale Id 1568',37388.25,0.00,0.00,55.39,2492.55,'2022-11-05 09:52:26','',''),(1559,'1','285','1',1,'Retail Sale Id 1569',2880.00,0.00,0.00,4.00,360.00,'2022-11-05 10:00:04','',''),(1560,'1','285','1',1,'Retail Sale Id 1570',2001.60,0.00,0.00,2.78,250.20,'2022-11-05 10:06:14','',''),(1561,'1','285','1',1,'Retail Sale Id 1571',2880.00,0.00,0.00,4.00,360.00,'2022-11-05 10:07:19','',''),(1562,'1','285','1',1,'Retail Sale Id 1572',494032.50,0.00,0.00,731.90,32935.50,'2022-11-05 10:15:43','',''),(1563,'1','285','1',1,'Retail Sale Id 1573',2160.00,0.00,0.00,3.00,270.00,'2022-11-05 10:20:10','',''),(1564,'1','285','1',1,'Retail Sale Id 1574',10000.80,0.00,0.00,13.89,1250.10,'2022-11-05 10:24:02','',''),(1565,'1','285','1',1,'Retail Sale Id 1575',1497.60,0.00,0.00,2.08,187.20,'2022-11-05 10:29:11','',''),(1566,'1','285','1',1,'Retail Sale Id 1576',2001.60,0.00,0.00,2.78,250.20,'2022-11-05 10:33:31','',''),(1567,'1','285','1',1,'Retail Sale Id 1577',43875.00,0.00,0.00,65.00,2925.00,'2022-11-05 10:40:19','',''),(1568,'1','285','1',1,'Retail Sale Id 1578',4003.20,0.00,0.00,5.56,500.40,'2022-11-05 10:47:16','',''),(1569,'1','285','1',1,'Retail Sale Id 1579',3002.40,0.00,0.00,4.17,375.30,'2022-11-05 10:48:34','',''),(1570,'1','285','1',1,'Retail Sale Id 1580',1440.00,0.00,0.00,2.00,180.00,'2022-11-05 11:05:09','',''),(1571,'1','285','1',1,'Retail Sale Id 1581',2160.00,0.00,0.00,3.00,270.00,'2022-11-05 11:06:54','',''),(1572,'1','285','1',1,'Retail Sale Id 1582',2160.00,0.00,0.00,3.00,270.00,'2022-11-05 11:09:29','',''),(1573,'1','285','1',1,'Retail Sale Id 1583',1497.60,0.00,0.00,2.08,187.20,'2022-11-05 11:18:02','',''),(1574,'1','285','1',1,'Retail Sale Id 1584',42052.50,0.00,0.00,62.30,2803.50,'2022-11-05 11:39:11','',''),(1575,'1','285','1',1,'Retail Sale Id 1585',3002.40,0.00,0.00,4.17,375.30,'2022-11-05 11:42:18','',''),(1576,'1','285','1',1,'Retail Sale Id 1586',16875.00,0.00,0.00,25.00,1125.00,'2022-11-05 11:52:52','',''),(1577,'1','285','1',1,'Retail Sale Id 1587',1440.00,0.00,0.00,2.00,180.00,'2022-11-05 11:54:21','',''),(1578,'1','285','1',1,'Retail Sale Id 1588',2001.60,0.00,0.00,2.78,250.20,'2022-11-05 11:55:52','',''),(1579,'1','285','1',1,'Retail Sale Id 1589',1000.80,0.00,0.00,1.39,125.10,'2022-11-05 12:00:06','',''),(1580,'1','285','1',1,'Retail Sale Id 1590',34283.25,0.00,0.00,50.79,2285.55,'2022-11-05 12:11:59','',''),(1581,'1','285','1',1,'Retail Sale Id 1591',41175.00,0.00,0.00,61.00,2745.00,'2022-11-05 12:27:31','',''),(1582,'1','285','1',1,'Retail Sale Id 1592',81654.75,0.00,0.00,120.97,5443.65,'2022-11-05 12:40:37','',''),(1583,'1','285','1',1,'Retail Sale Id 1593',30375.00,0.00,0.00,45.00,2025.00,'2022-11-05 12:46:09','',''),(1584,'1','285','1',1,'Retail Sale Id 1594',3600.00,0.00,0.00,5.00,450.00,'2022-11-05 12:51:26','',''),(1585,'1','285','1',1,'Retail Sale Id 1595',2880.00,0.00,0.00,4.00,360.00,'2022-11-05 12:56:18','',''),(1586,'1','285','1',1,'Retail Sale Id 1596',4320.00,0.00,0.00,6.00,540.00,'2022-11-05 12:57:57','',''),(1587,'1','285','1',1,'Retail Sale Id 1597',2001.60,0.00,0.00,2.78,250.20,'2022-11-05 12:58:52','',''),(1588,'1','285','1',1,'Retail Sale Id 1598',1000.80,0.00,0.00,1.39,125.10,'2022-11-05 12:59:33','',''),(1589,'1','285','1',1,'Retail Sale Id 1600',3708.00,0.00,0.00,5.15,463.50,'2022-11-05 13:07:33','',''),(1590,'1','285','1',1,'Retail Sale Id 1601',2664.00,0.00,0.00,3.70,333.00,'2022-11-05 13:08:20','',''),(1591,'1','285','1',1,'Retail Sale Id 1602',36450.00,0.00,0.00,54.00,2430.00,'2022-11-05 13:10:29','',''),(1592,'1','285','1',1,'Retail Sale Id 1603',1497.60,0.00,0.00,2.08,187.20,'2022-11-05 13:13:26','',''),(1593,'1','285','1',1,'Retail Sale Id 1604',40938.75,0.00,0.00,60.65,2729.25,'2022-11-05 13:24:54','',''),(1594,'1','285','1',1,'Retail Sale Id 1605',3600.00,0.00,0.00,5.00,450.00,'2022-11-05 13:34:26','',''),(1595,'1','285','1',1,'Retail Sale Id 1606',32730.75,0.00,0.00,48.49,2182.05,'2022-11-05 13:37:20','',''),(1596,'1','285','1',1,'Retail Sale Id 1607',3600.00,0.00,0.00,5.00,450.00,'2022-11-05 13:40:18','',''),(1597,'1','285','1',1,'Retail Sale Id 1608',1497.60,0.00,0.00,2.08,187.20,'2022-11-05 13:42:43','',''),(1598,'1','285','1',1,'Retail Sale Id 1609',1497.60,0.00,0.00,2.08,187.20,'2022-11-05 13:43:45','',''),(1599,'1','285','1',1,'Retail Sale Id 1610',45900.00,0.00,0.00,68.00,3060.00,'2022-11-05 13:56:17','',''),(1600,'1','285','1',1,'Retail Sale Id 1611',2160.00,0.00,0.00,3.00,270.00,'2022-11-05 14:06:44','',''),(1601,'1','285','1',1,'Retail Sale Id 1612',799.20,0.00,0.00,1.11,99.90,'2022-11-05 14:10:20','',''),(1602,'1','285','1',1,'Retail Sale Id 1613',2160.00,0.00,0.00,3.00,270.00,'2022-11-05 14:18:43','',''),(1603,'1','285','1',1,'Retail Sale Id 1614',2203.20,0.00,0.00,3.06,275.40,'2022-11-05 14:20:52','',''),(1604,'1','285','1',1,'Retail Sale Id 1615',1440.00,0.00,0.00,2.00,180.00,'2022-11-05 14:22:59','',''),(1605,'1','285','1',1,'Retail Sale Id 1616',1497.60,0.00,0.00,2.08,187.20,'2022-11-05 14:28:17','',''),(1606,'1','285','1',1,'Retail Sale Id 1617',2880.00,0.00,0.00,4.00,360.00,'2022-11-05 14:30:11','',''),(1607,'1','285','1',1,'Retail Sale Id 1618',1000.80,0.00,0.00,1.39,125.10,'2022-11-05 14:31:04','',''),(1608,'1','285','1',1,'Retail Sale Id 1619',799.20,0.00,0.00,1.11,99.90,'2022-11-05 14:32:00','',''),(1609,'1','285','1',1,'Retail Sale Id 1620',2203.20,0.00,0.00,3.06,275.40,'2022-11-05 14:35:51','',''),(1610,'1','285','1',1,'Retail Sale Id 1621',1440.00,0.00,0.00,2.00,180.00,'2022-11-05 14:37:12','',''),(1611,'1','285','1',1,'Retail Sale Id 1622',16584.75,0.00,0.00,24.57,1105.65,'2022-11-05 14:42:38','',''),(1612,'1','285','1',1,'Retail Sale Id 1623',2880.00,0.00,0.00,4.00,360.00,'2022-11-05 14:43:43','',''),(1613,'1','285','1',1,'Retail Sale Id 1624',9000.00,0.00,0.00,12.50,1125.00,'2022-11-05 14:50:16','',''),(1614,'1','285','1',1,'Retail Sale Id 1625',3600.00,0.00,0.00,5.00,450.00,'2022-11-05 14:54:00','',''),(1615,'1','285','1',1,'Retail Sale Id 1626',1447.20,0.00,0.00,2.01,180.90,'2022-11-05 15:01:16','',''),(1616,'1','285','1',1,'Retail Sale Id 1627',6480.00,0.00,0.00,9.00,810.00,'2022-11-05 15:06:51','',''),(1617,'1','285','1',1,'Retail Sale Id 1628',2160.00,0.00,0.00,3.00,270.00,'2022-11-05 15:08:31','',''),(1618,'1','285','1',1,'Retail Sale Id 1629',2203.20,0.00,0.00,3.06,275.40,'2022-11-05 15:09:49','',''),(1619,'1','285','1',1,'Retail Sale Id 1630',720.00,0.00,0.00,1.00,90.00,'2022-11-05 15:17:32','',''),(1620,'1','285','1',1,'Retail Sale Id 1631',2880.00,0.00,0.00,4.00,360.00,'2022-11-05 15:20:45','',''),(1621,'1','285','1',1,'Retail Sale Id 1632',5040.00,0.00,0.00,7.00,630.00,'2022-11-05 15:21:44','',''),(1622,'1','285','1',1,'Retail Sale Id 1633',799.20,0.00,0.00,1.11,99.90,'2022-11-05 15:27:26','',''),(1623,'1','285','1',1,'Retail Sale Id 1634',1497.60,0.00,0.00,2.08,187.20,'2022-11-05 15:31:20','',''),(1624,'1','285','1',1,'Retail Sale Id 1635',82248.75,0.00,0.00,121.85,5483.25,'2022-11-05 15:34:18','',''),(1625,'1','285','1',1,'Retail Sale Id 1636',2880.00,0.00,0.00,4.00,360.00,'2022-11-05 15:37:49','',''),(1626,'1','285','1',1,'Retail Sale Id 1637',11542.50,0.00,0.00,17.10,769.50,'2022-11-05 15:39:29','',''),(1627,'1','285','1',1,'Retail Sale Id 1638',5760.00,0.00,0.00,8.00,720.00,'2022-11-05 15:41:26','',''),(1628,'1','285','1',1,'Retail Sale Id 1639',1497.60,0.00,0.00,2.08,187.20,'2022-11-05 15:43:20','',''),(1629,'1','285','1',1,'Retail Sale Id 1640',799.20,0.00,0.00,1.11,99.90,'2022-11-05 15:44:36','',''),(1630,'1','285','1',1,'Retail Sale Id 1642',1440.00,0.00,0.00,2.00,180.00,'2022-11-05 15:45:31','',''),(1631,'1','285','1',1,'Retail Sale Id 1643',1440.00,0.00,0.00,2.00,180.00,'2022-11-05 15:46:16','',''),(1632,'1','285','1',1,'Retail Sale Id 1644',172800.00,0.00,0.00,256.00,11520.00,'2022-11-05 15:48:45','',''),(1633,'1','285','1',1,'Retail Sale Id 1645',2203.20,0.00,0.00,3.06,275.40,'2022-11-05 15:58:08','',''),(1634,'1','285','1',1,'Retail Sale Id 1646',3636.00,0.00,0.00,5.05,454.50,'2022-11-05 16:03:55','',''),(1635,'1','285','1',1,'Retail Sale Id 1647',18751.50,0.00,0.00,27.78,1250.10,'2022-11-05 16:10:43','',''),(1636,'1','285','1',1,'Retail Sale Id 1648',3621.60,0.00,0.00,5.03,452.70,'2022-11-05 17:29:17','',''),(1637,'1','285','1',1,'Return of Retail Sale Id 1637',0.00,11542.50,17.10,0.00,-769.50,'2022-11-05 17:33:37','',''),(1638,'1','285','1',1,'Retail Sale Id 1649',8532.00,0.00,0.00,12.64,568.80,'2022-11-05 17:34:56','',''),(1639,'1','285','1',1,'Return of Retail Sale Id 1649',0.00,8532.00,12.64,0.00,-568.80,'2022-11-05 17:37:34','',''),(1640,'1','285','1',1,'Retail Sale Id 1650',8133.75,0.00,0.00,12.05,542.25,'2022-11-05 17:38:44','',''),(1641,'1','285','1',1,'Distributed to AA RANO NIGERIA LTD for sales id:2',243765.90,0.00,0.00,386.93,0.00,'2022-11-05 18:20:22','',''),(1642,'1','285',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,12675000.00,19500.00,0.00,0.00,'2022-11-06 20:36:21','',''),(1643,'1','285',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,19500.00,0.00,'2022-11-06 20:40:44','',''),(1644,'1','285','1',1,'Received from bridging 3',0.00,0.00,19500.00,0.00,0.00,'2022-11-06 20:40:44','',''),(1645,'1','285','1',1,'Retail Sale Id 1651',41779.50,0.00,0.00,60.55,2422.00,'2022-11-07 07:29:36','',''),(1646,'1','285','1',1,'Retail Sale Id 1653',42724.80,0.00,0.00,61.92,2476.80,'2022-11-07 07:31:30','',''),(1647,'1','285','1',1,'Retail Sale Id 1654',42400.50,0.00,0.00,61.45,2458.00,'2022-11-07 07:32:46','',''),(1648,'1','285','1',1,'Retail Sale Id 1656',46920.00,0.00,0.00,68.00,2720.00,'2022-11-07 07:34:17','',''),(1649,'1','285','1',1,'Retail Sale Id 1657',20748.30,0.00,0.00,30.07,1202.80,'2022-11-07 07:39:56','',''),(1650,'1','285','1',1,'Retail Sale Id 1658',1500.00,0.00,0.00,2.00,200.00,'2022-11-07 07:41:02','',''),(1651,'1','285','1',1,'Retail Sale Id 1659',3000.00,0.00,0.00,4.00,400.00,'2022-11-07 07:48:14','',''),(1652,'1','285','1',1,'Retail Sale Id 1660',750.00,0.00,0.00,1.00,100.00,'2022-11-07 07:54:21','',''),(1653,'1','285','1',1,'Retail Sale Id 1661',750.00,0.00,0.00,1.00,100.00,'2022-11-07 07:55:44','',''),(1654,'1','285','1',1,'Retail Sale Id 1662',750.00,0.00,0.00,1.00,100.00,'2022-11-07 07:57:43','',''),(1655,'1','285','1',1,'Retail Sale Id 1663',1500.00,0.00,0.00,2.00,200.00,'2022-11-07 08:02:16','',''),(1656,'1','285','1',1,'Retail Sale Id 1664',61989.60,0.00,0.00,89.84,3593.60,'2022-11-07 08:11:04','',''),(1657,'1','285','1',1,'Retail Sale Id 1665',2250.00,0.00,0.00,3.00,300.00,'2022-11-07 08:11:57','',''),(1658,'1','285','1',1,'Retail Sale Id 1666',3000.00,0.00,0.00,4.00,400.00,'2022-11-07 08:13:33','',''),(1659,'1','285','1',1,'Retail Sale Id 1667',46312.50,0.00,0.00,61.75,6175.00,'2022-11-07 08:18:59','',''),(1660,'1','285','1',1,'Return of Retail Sale Id 1667',0.00,46312.50,61.75,0.00,-6175.00,'2022-11-07 08:21:08','',''),(1661,'1','285','1',1,'Retail Sale Id 1668',42607.50,0.00,0.00,61.75,2470.00,'2022-11-07 08:22:11','',''),(1662,'1','285','1',1,'Retail Sale Id 1669',1500.00,0.00,0.00,2.00,200.00,'2022-11-07 08:25:36','',''),(1663,'1','285','1',1,'Retail Sale Id 1670',42731.70,0.00,0.00,61.93,2477.20,'2022-11-07 08:27:29','',''),(1664,'1','285','1',1,'Retail Sale Id 1671',2002.50,0.00,0.00,2.67,267.00,'2022-11-07 08:29:13','',''),(1665,'1','285','1',1,'Retail Sale Id 1672',1500.00,0.00,0.00,2.00,200.00,'2022-11-07 08:30:37','',''),(1666,'1','285','1',1,'Retail Sale Id 1673',41400.00,0.00,0.00,60.00,2400.00,'2022-11-07 08:46:05','',''),(1667,'1','285','1',1,'Retail Sale Id 1674',802.50,0.00,0.00,1.07,107.00,'2022-11-07 08:47:50','',''),(1668,'1','285','1',1,'Retail Sale Id 1675',802.50,0.00,0.00,1.07,107.00,'2022-11-07 08:48:40','',''),(1669,'1','285','1',1,'Retail Sale Id 1676',39330.00,0.00,0.00,57.00,2280.00,'2022-11-07 08:50:38','',''),(1670,'1','285','1',1,'Retail Sale Id 1677',44173.80,0.00,0.00,64.02,2560.80,'2022-11-07 08:54:08','',''),(1671,'1','285','1',1,'Retail Sale Id 1678',17015.40,0.00,0.00,24.66,986.40,'2022-11-07 08:56:22','',''),(1672,'1','285','1',1,'Retail Sale Id 1679',3000.00,0.00,0.00,4.00,400.00,'2022-11-07 08:57:59','',''),(1673,'1','285','1',1,'Retail Sale Id 1680',2497.50,0.00,0.00,3.33,333.00,'2022-11-07 09:00:46','',''),(1674,'1','285','1',1,'Retail Sale Id 1681',42780.00,0.00,0.00,62.00,2480.00,'2022-11-07 09:02:37','',''),(1675,'1','285','1',1,'Retail Sale Id 1682',41400.00,0.00,0.00,60.00,2400.00,'2022-11-07 09:09:45','',''),(1676,'1','285','1',1,'Retail Sale Id 1683',42400.50,0.00,0.00,61.45,2458.00,'2022-11-07 09:12:32','',''),(1677,'1','285','1',1,'Retail Sale Id 1684',12254.40,0.00,0.00,17.76,710.40,'2022-11-07 09:16:18','',''),(1678,'1','285','1',1,'Retail Sale Id 1685',1500.00,0.00,0.00,2.00,200.00,'2022-11-07 09:17:22','',''),(1679,'1','285','1',1,'Retail Sale Id 1686',33810.00,0.00,0.00,49.00,1960.00,'2022-11-07 09:24:23','',''),(1680,'1','285','1',1,'Retail Sale Id 1687',37950.00,0.00,0.00,55.00,2200.00,'2022-11-07 09:26:34','',''),(1681,'1','285','1',1,'Retail Sale Id 1688',2002.50,0.00,0.00,2.67,267.00,'2022-11-07 09:30:20','',''),(1682,'1','285','1',1,'Retail Sale Id 1689',802.50,0.00,0.00,1.07,107.00,'2022-11-07 09:55:25','',''),(1683,'1','285','1',1,'Retail Sale Id 1690',750.00,0.00,0.00,1.00,100.00,'2022-11-07 10:07:06','',''),(1684,'1','285','1',1,'Retail Sale Id 1691',2250.00,0.00,0.00,3.00,300.00,'2022-11-07 10:09:42','',''),(1685,'1','285','1',1,'Retail Sale Id 1693',1500.00,0.00,0.00,2.00,200.00,'2022-11-07 10:27:41','',''),(1686,'1','285','1',1,'Retail Sale Id 1694',997.50,0.00,0.00,1.33,133.00,'2022-11-07 10:34:43','',''),(1687,'1','285','1',1,'Retail Sale Id 1695',34500.00,0.00,0.00,50.00,2000.00,'2022-11-07 10:46:21','',''),(1688,'1','285','1',1,'Retail Sale Id 1696',997.50,0.00,0.00,1.33,133.00,'2022-11-07 10:50:41','',''),(1689,'1','285','1',1,'Retail Sale Id 1697',10018.80,0.00,0.00,14.52,580.80,'2022-11-07 10:53:02','',''),(1690,'1','285','1',1,'Retail Sale Id 1698',3750.00,0.00,0.00,5.00,500.00,'2022-11-07 10:56:01','',''),(1691,'1','285','1',1,'Retail Sale Id 1699',2002.50,0.00,0.00,2.67,267.00,'2022-11-07 10:58:20','',''),(1692,'1','285','1',1,'Retail Sale Id 1700',2100.00,0.00,0.00,2.80,280.00,'2022-11-07 11:09:27','',''),(1693,'1','285','1',1,'Retail Sale Id 1701',2002.50,0.00,0.00,2.67,267.00,'2022-11-07 11:20:20','',''),(1694,'1','285','1',1,'Retail Sale Id 1702',997.50,0.00,0.00,1.33,133.00,'2022-11-07 11:24:54','',''),(1695,'1','285','1',1,'Retail Sale Id 1703',1500.00,0.00,0.00,2.00,200.00,'2022-11-07 11:43:41','',''),(1696,'1','285','1',1,'Retail Sale Id 1704',802.50,0.00,0.00,1.07,107.00,'2022-11-07 11:49:55','',''),(1697,'1','285','1',1,'Retail Sale Id 1705',4500.00,0.00,0.00,6.00,600.00,'2022-11-07 11:57:33','',''),(1698,'1','285','1',1,'Retail Sale Id 1706',1500.00,0.00,0.00,2.00,200.00,'2022-11-07 12:04:43','',''),(1699,'1','285','1',1,'Retail Sale Id 1707',2497.50,0.00,0.00,3.33,333.00,'2022-11-07 12:07:38','',''),(1700,'1','285','1',1,'Retail Sale Id 1708',55200.00,0.00,0.00,80.00,3200.00,'2022-11-07 12:23:12','',''),(1701,'1','285','1',1,'Retail Sale Id 1709',42538.50,0.00,0.00,61.65,2466.00,'2022-11-07 12:27:16','',''),(1702,'1','285','1',1,'Retail Sale Id 1710',41075.70,0.00,0.00,59.53,2381.20,'2022-11-07 12:28:06','',''),(1703,'1','285','1',1,'Retail Sale Id 1711',997.50,0.00,0.00,1.33,133.00,'2022-11-07 12:32:37','',''),(1704,'1','285','1',1,'Retail Sale Id 1712',3750.00,0.00,0.00,5.00,500.00,'2022-11-07 12:51:30','',''),(1705,'1','285','1',1,'Retail Sale Id 1713',750.00,0.00,0.00,1.00,100.00,'2022-11-07 12:54:38','',''),(1706,'1','285','1',1,'Retail Sale Id 1714',62541.60,0.00,0.00,90.64,3625.60,'2022-11-07 13:22:33','',''),(1707,'1','285','1',1,'Retail Sale Id 1715',42780.00,0.00,0.00,62.00,2480.00,'2022-11-07 13:27:45','',''),(1708,'1','285','1',1,'Retail Sale Id 1716',138000.00,0.00,0.00,200.00,8000.00,'2022-11-07 13:37:17','',''),(1709,'1','285','1',1,'Retail Sale Id 1717',10205.10,0.00,0.00,14.79,591.60,'2022-11-07 13:45:16','',''),(1710,'1','285','1',1,'Retail Sale Id 1718',1500.00,0.00,0.00,2.00,200.00,'2022-11-07 14:29:19','',''),(1711,'1','285','1',1,'Retail Sale Id 1719',750.00,0.00,0.00,1.00,100.00,'2022-11-07 14:32:17','',''),(1712,'1','285','1',1,'Retail Sale Id 1720',1500.00,0.00,0.00,2.00,200.00,'2022-11-07 14:33:27','',''),(1713,'1','285','1',1,'Retail Sale Id 1721',3000.00,0.00,0.00,4.00,400.00,'2022-11-07 14:41:24','',''),(1714,'1','285','1',1,'Retail Sale Id 1722',802.50,0.00,0.00,1.07,107.00,'2022-11-07 14:44:15','',''),(1715,'1','285','1',1,'Retail Sale Id 1723',750.00,0.00,0.00,1.00,100.00,'2022-11-07 14:45:13','',''),(1716,'1','285','1',1,'Retail Sale Id 1724',2250.00,0.00,0.00,3.00,300.00,'2022-11-07 14:54:34','',''),(1717,'1','285','1',1,'Retail Sale Id 1725',1500.00,0.00,0.00,2.00,200.00,'2022-11-07 14:55:45','',''),(1718,'1','285','1',1,'Retail Sale Id 1726',1500.00,0.00,0.00,2.00,200.00,'2022-11-07 14:56:47','',''),(1719,'1','285','1',1,'Retail Sale Id 1728',4500.00,0.00,0.00,6.00,600.00,'2022-11-07 15:00:40','',''),(1720,'1','285','1',1,'Retail Sale Id 1729',3750.00,0.00,0.00,5.00,500.00,'2022-11-07 15:10:44','',''),(1721,'1','285','1',1,'Retail Sale Id 1730',1500.00,0.00,0.00,2.00,200.00,'2022-11-07 15:12:07','',''),(1722,'1','285','1',1,'Retail Sale Id 1731',1500.00,0.00,0.00,2.00,200.00,'2022-11-07 15:23:13','',''),(1723,'1','285','1',1,'Retail Sale Id 1732',3000.00,0.00,0.00,4.00,400.00,'2022-11-07 15:28:08','',''),(1724,'1','285','1',1,'Retail Sale Id 1733',3000.00,0.00,0.00,4.00,400.00,'2022-11-07 15:32:47','',''),(1725,'1','285','1',1,'Retail Sale Id 1734',2250.00,0.00,0.00,3.00,300.00,'2022-11-07 15:38:38','',''),(1726,'1','285','1',1,'Retail Sale Id 1735',1500.00,0.00,0.00,2.00,200.00,'2022-11-07 15:43:01','',''),(1727,'1','285','1',1,'Retail Sale Id 1736',5250.00,0.00,0.00,7.00,700.00,'2022-11-07 15:48:38','',''),(1728,'1','285','1',1,'Retail Sale Id 1737',3000.00,0.00,0.00,4.00,400.00,'2022-11-07 15:50:03','',''),(1729,'1','285','1',1,'Retail Sale Id 1738',4140.00,0.00,0.00,6.00,240.00,'2022-11-07 15:51:47','',''),(1730,'1','285','1',1,'Retail Sale Id 1739',750.00,0.00,0.00,1.00,100.00,'2022-11-07 15:52:58','',''),(1731,'1','285','1',1,'Retail Sale Id 1740',2497.50,0.00,0.00,3.33,333.00,'2022-11-07 15:59:40','',''),(1732,'1','285','1',1,'Retail Sale Id 1741',12026.70,0.00,0.00,17.43,697.20,'2022-11-07 16:10:52','',''),(1733,'1','285','1',1,'Retail Sale Id 1742',41337.90,0.00,0.00,59.91,2396.40,'2022-11-07 16:16:18','',''),(1734,'1','285','1',1,'Retail Sale Id 1743',1500.00,0.00,0.00,2.00,200.00,'2022-11-07 16:19:10','',''),(1735,'1','285','1',1,'Retail Sale Id 1744',42828.30,0.00,0.00,62.07,2482.80,'2022-11-07 16:21:43','',''),(1736,'1','285','1',1,'Retail Sale Id 1745',41400.00,0.00,0.00,60.00,2400.00,'2022-11-07 16:31:12','',''),(1737,'1','285','1',1,'Retail Sale Id 1746',8250.00,0.00,0.00,11.00,1100.00,'2022-11-07 16:37:53','',''),(1738,'1','285','1',1,'Return of Retail Sale Id 1744',0.00,42828.30,62.07,0.00,-2482.80,'2022-11-07 16:38:47','',''),(1739,'1','285','1',1,'Retail Sale Id 1747',44160.00,0.00,0.00,64.00,2560.00,'2022-11-07 16:39:18','',''),(1740,'1','285','1',1,'Retail Sale Id 1748',2250.00,0.00,0.00,3.00,300.00,'2022-11-07 16:44:53','',''),(1741,'1','285','1',1,'Retail Sale Id 1749',5250.00,0.00,0.00,7.00,700.00,'2022-11-07 16:46:18','',''),(1742,'1','285','1',1,'Retail Sale Id 1750',1500.00,0.00,0.00,2.00,200.00,'2022-11-07 17:01:46','',''),(1743,'1','285','1',1,'Retail Sale Id 1751',750.00,0.00,0.00,1.00,100.00,'2022-11-07 17:08:00','',''),(1744,'1','285','1',1,'Retail Sale Id 1752',802.50,0.00,0.00,1.07,107.00,'2022-11-07 17:10:13','',''),(1745,'1','285','1',1,'Retail Sale Id 1753',44346.30,0.00,0.00,64.27,2570.80,'2022-11-07 17:12:52','',''),(1746,'1','285','1',1,'Retail Sale Id 1754',41814.00,0.00,0.00,60.60,2424.00,'2022-11-07 17:13:55','',''),(1747,'1','285','1',1,'Return of Retail Sale Id 1749',0.00,5250.00,7.00,0.00,-700.00,'2022-11-07 18:24:03','',''),(1748,'1','285','1',1,'Retail Sale Id 1755',5250.00,0.00,0.00,7.00,700.00,'2022-11-07 18:29:22','',''),(1749,'1','285','1',1,'Return of Retail Sale Id 1676',0.00,39330.00,57.00,0.00,-2280.00,'2022-11-07 18:50:02','',''),(1750,'1','285','1',1,'Retail Sale Id 1756',38867.70,0.00,0.00,56.33,2253.20,'2022-11-07 18:52:45','',''),(1751,'1','285','1',1,'Retail Sale Id 1757',750.00,0.00,0.00,1.00,100.00,'2022-11-07 18:53:56','',''),(1752,'1','285','1',1,'Retail Sale Id 1758',42421.20,0.00,0.00,61.48,2459.20,'2022-11-08 07:35:17','',''),(1753,'1','285','1',1,'Retail Sale Id 1759',24150.00,0.00,0.00,35.00,1400.00,'2022-11-08 07:41:14','',''),(1754,'1','285','1',1,'Retail Sale Id 1760',42483.30,0.00,0.00,61.57,2462.80,'2022-11-08 07:43:23','',''),(1755,'1','285','1',1,'Retail Sale Id 1761',750.00,0.00,0.00,1.00,100.00,'2022-11-08 07:44:54','',''),(1756,'1','285','1',1,'Retail Sale Id 1762',997.50,0.00,0.00,1.33,133.00,'2022-11-08 07:46:05','',''),(1757,'1','285','1',1,'Retail Sale Id 1763',1500.00,0.00,0.00,2.00,200.00,'2022-11-08 07:47:06','',''),(1758,'1','285','1',1,'Retail Sale Id 1764',2250.00,0.00,0.00,3.00,300.00,'2022-11-08 07:48:06','',''),(1759,'1','285','1',1,'Retail Sale Id 1765',1500.00,0.00,0.00,2.00,200.00,'2022-11-08 07:52:13','',''),(1760,'1','285','1',1,'Retail Sale Id 1766',5250.00,0.00,0.00,7.00,700.00,'2022-11-08 08:03:01','',''),(1761,'1','285','1',1,'Retail Sale Id 1767',41400.00,0.00,0.00,60.00,2400.00,'2022-11-08 08:05:19','',''),(1762,'1','285','1',1,'Retail Sale Id 1768',1500.00,0.00,0.00,2.00,200.00,'2022-11-08 08:06:19','',''),(1763,'1','285','1',1,'Retail Sale Id 1769',42241.80,0.00,0.00,61.22,2448.80,'2022-11-08 08:07:42','',''),(1764,'1','285','1',1,'Retail Sale Id 1770',42759.30,0.00,0.00,61.97,2478.80,'2022-11-08 08:11:15','',''),(1765,'1','285','1',1,'Retail Sale Id 1771',5250.00,0.00,0.00,7.00,700.00,'2022-11-08 08:12:45','',''),(1766,'1','285','1',1,'Retail Sale Id 1772',2250.00,0.00,0.00,3.00,300.00,'2022-11-08 08:13:58','',''),(1767,'1','285','1',1,'Retail Sale Id 1773',2250.00,0.00,0.00,3.00,300.00,'2022-11-08 08:15:05','',''),(1768,'1','285','1',1,'Retail Sale Id 1774',1500.00,0.00,0.00,2.00,200.00,'2022-11-08 08:19:31','',''),(1769,'1','285','1',1,'Retail Sale Id 1775',146535.30,0.00,0.00,212.37,8494.80,'2022-11-08 08:21:39','',''),(1770,'1','285','1',1,'Retail Sale Id 1776',3000.00,0.00,0.00,4.00,400.00,'2022-11-08 08:22:27','',''),(1771,'1','285','1',1,'Retail Sale Id 1777',750.00,0.00,0.00,1.00,100.00,'2022-11-08 08:23:49','',''),(1772,'1','285','1',1,'Retail Sale Id 1778',33120.00,0.00,0.00,48.00,1920.00,'2022-11-08 08:26:29','',''),(1773,'1','285','1',1,'Retail Sale Id 1779',41441.40,0.00,0.00,60.06,2402.40,'2022-11-08 08:28:01','',''),(1774,'1','285','1',1,'Retail Sale Id 1780',750.00,0.00,0.00,1.00,100.00,'2022-11-08 08:28:53','',''),(1775,'1','285','1',1,'Retail Sale Id 1781',6000.00,0.00,0.00,8.00,800.00,'2022-11-08 08:30:34','',''),(1776,'1','285','1',1,'Retail Sale Id 1782',41400.00,0.00,0.00,60.00,2400.00,'2022-11-08 08:31:59','',''),(1777,'1','285','1',1,'Retail Sale Id 1783',4500.00,0.00,0.00,6.00,600.00,'2022-11-08 08:32:50','',''),(1778,'1','285','1',1,'Retail Sale Id 1785',2250.00,0.00,0.00,3.00,300.00,'2022-11-08 08:34:42','',''),(1779,'1','285','1',1,'Retail Sale Id 1786',34148.10,0.00,0.00,49.49,1979.60,'2022-11-08 08:37:05','',''),(1780,'1','285','1',1,'Retail Sale Id 1787',4500.00,0.00,0.00,6.00,600.00,'2022-11-08 08:38:09','',''),(1781,'1','285','1',1,'Retail Sale Id 1788',750.00,0.00,0.00,1.00,100.00,'2022-11-08 08:39:39','',''),(1782,'1','285','1',1,'Retail Sale Id 1789',52502.10,0.00,0.00,76.09,3043.60,'2022-11-08 08:42:03','',''),(1783,'1','285','1',1,'Retail Sale Id 1790',750.00,0.00,0.00,1.00,100.00,'2022-11-08 08:43:37','',''),(1784,'1','285','1',1,'Retail Sale Id 1791',12495.90,0.00,0.00,18.11,724.40,'2022-11-08 09:00:44','',''),(1785,'1','285','1',1,'Retail Sale Id 1792',48300.00,0.00,0.00,70.00,2800.00,'2022-11-08 09:07:57','',''),(1786,'1','285','1',1,'Retail Sale Id 1793',3000.00,0.00,0.00,4.00,400.00,'2022-11-08 09:08:49','',''),(1787,'1','285','1',1,'Retail Sale Id 1794',2857.50,0.00,0.00,3.81,381.00,'2022-11-08 09:16:36','',''),(1788,'1','285','1',1,'Retail Sale Id 1795',1500.00,0.00,0.00,2.00,200.00,'2022-11-08 09:17:18','',''),(1789,'1','285','1',1,'Retail Sale Id 1796',4500.00,0.00,0.00,6.00,600.00,'2022-11-08 09:20:58','',''),(1790,'1','285','1',1,'Retail Sale Id 1797',3750.00,0.00,0.00,5.00,500.00,'2022-11-08 09:21:57','',''),(1791,'1','285','1',1,'Retail Sale Id 1798',1500.00,0.00,0.00,2.00,200.00,'2022-11-08 09:23:21','',''),(1792,'1','285','1',1,'Retail Sale Id 1799',41400.00,0.00,0.00,60.00,2400.00,'2022-11-08 09:24:34','',''),(1793,'1','285','1',1,'Retail Sale Id 1800',34500.00,0.00,0.00,50.00,2000.00,'2022-11-08 09:27:07','',''),(1794,'1','285','1',1,'Retail Sale Id 1801',55200.00,0.00,0.00,80.00,3200.00,'2022-11-08 09:36:42','',''),(1795,'1','285','1',1,'Retail Sale Id 1802',41400.00,0.00,0.00,60.00,2400.00,'2022-11-08 09:39:38','',''),(1796,'1','285','1',1,'Retail Sale Id 1803',2760.00,0.00,0.00,4.00,160.00,'2022-11-08 09:42:39','',''),(1797,'1','285','1',1,'Retail Sale Id 1804',2497.50,0.00,0.00,3.33,333.00,'2022-11-08 09:45:25','',''),(1798,'1','285','1',1,'Retail Sale Id 1805',41607.00,0.00,0.00,60.30,2412.00,'2022-11-08 09:58:53','',''),(1799,'1','285','1',1,'Retail Sale Id 1806',9750.00,0.00,0.00,13.00,1300.00,'2022-11-08 10:12:38','',''),(1800,'1','285','1',1,'Retail Sale Id 1807',750.00,0.00,0.00,1.00,100.00,'2022-11-08 10:24:11','',''),(1801,'1','285','1',1,'Retail Sale Id 1808',1000.50,0.00,0.00,1.45,58.00,'2022-11-08 10:28:39','',''),(1802,'1','285','1',1,'Retail Sale Id 1809',43249.20,0.00,0.00,62.68,2507.20,'2022-11-08 10:42:35','',''),(1803,'1','285','1',1,'Retail Sale Id 1810',1500.00,0.00,0.00,2.00,200.00,'2022-11-08 11:27:27','',''),(1804,'1','285','1',1,'Retail Sale Id 1811',43007.70,0.00,0.00,62.33,2493.20,'2022-11-08 11:31:19','',''),(1805,'1','285','1',1,'Retail Sale Id 1812',3750.00,0.00,0.00,5.00,500.00,'2022-11-08 11:36:58','',''),(1806,'1','285','1',1,'Retail Sale Id 1813',802.50,0.00,0.00,1.07,107.00,'2022-11-08 11:39:21','',''),(1807,'1','285','1',1,'Retail Sale Id 1814',54944.70,0.00,0.00,79.63,3185.20,'2022-11-08 11:47:10','',''),(1808,'1','285','1',1,'Retail Sale Id 1815',1500.00,0.00,0.00,2.00,200.00,'2022-11-08 11:49:15','',''),(1809,'1','285','1',1,'Retail Sale Id 1816',41400.00,0.00,0.00,60.00,2400.00,'2022-11-08 12:09:39','',''),(1810,'1','285','1',1,'Retail Sale Id 1817',89582.70,0.00,0.00,129.83,5193.20,'2022-11-08 12:16:16','',''),(1811,'1','285','1',1,'Retail Sale Id 1818',5250.00,0.00,0.00,7.00,700.00,'2022-11-08 12:18:37','',''),(1812,'1','285','1',1,'Retail Sale Id 1819',2250.00,0.00,0.00,3.00,300.00,'2022-11-08 12:20:20','',''),(1813,'1','285','1',1,'Retail Sale Id 1820',41469.00,0.00,0.00,60.10,2404.00,'2022-11-08 12:22:24','',''),(1814,'1','285','1',1,'Retail Sale Id 1822',4500.00,0.00,0.00,6.00,600.00,'2022-11-08 12:33:53','',''),(1815,'1','285','1',1,'Retail Sale Id 1823',3000.00,0.00,0.00,4.00,400.00,'2022-11-08 13:08:34','',''),(1816,'1','285','1',1,'Retail Sale Id 1824',41068.80,0.00,0.00,59.52,2380.80,'2022-11-08 13:23:17','',''),(1817,'1','285','1',1,'Retail Sale Id 1825',802.50,0.00,0.00,1.07,107.00,'2022-11-08 13:28:24','',''),(1818,'1','285','1',1,'Retail Sale Id 1826',1500.00,0.00,0.00,2.00,200.00,'2022-11-08 13:33:51','',''),(1819,'1','285','1',1,'Retail Sale Id 1827',1500.00,0.00,0.00,2.00,200.00,'2022-11-08 14:03:26','',''),(1820,'1','285','1',1,'Retail Sale Id 1828',45540.00,0.00,0.00,66.00,2640.00,'2022-11-08 14:05:44','',''),(1821,'1','285','1',1,'Retail Sale Id 1829',802.50,0.00,0.00,1.07,107.00,'2022-11-08 14:33:28','',''),(1822,'1','285','1',1,'Retail Sale Id 1830',802.50,0.00,0.00,1.07,107.00,'2022-11-08 14:35:09','',''),(1823,'1','285','1',1,'Retail Sale Id 1831',24150.00,0.00,0.00,35.00,1400.00,'2022-11-08 14:42:33','',''),(1824,'1','285','1',1,'Retail Sale Id 1832',4500.00,0.00,0.00,6.00,600.00,'2022-11-08 14:43:06','',''),(1825,'1','285','1',1,'Retail Sale Id 1833',2250.00,0.00,0.00,3.00,300.00,'2022-11-08 14:55:06','',''),(1826,'1','285','1',1,'Retail Sale Id 1834',802.50,0.00,0.00,1.07,107.00,'2022-11-08 14:57:27','',''),(1827,'1','285','1',1,'Retail Sale Id 1835',5002.50,0.00,0.00,6.67,667.00,'2022-11-08 15:01:20','',''),(1828,'1','285','1',1,'Retail Sale Id 1836',2250.00,0.00,0.00,3.00,300.00,'2022-11-08 15:04:37','',''),(1829,'1','285','1',1,'Retail Sale Id 1837',1500.00,0.00,0.00,2.00,200.00,'2022-11-08 15:14:03','',''),(1830,'1','285','1',1,'Retail Sale Id 1838',1500.00,0.00,0.00,2.00,200.00,'2022-11-08 15:25:08','',''),(1831,'1','285','1',1,'Retail Sale Id 1839',1500.00,0.00,0.00,2.00,200.00,'2022-11-08 15:26:32','',''),(1832,'1','285','1',1,'Retail Sale Id 1840',8250.00,0.00,0.00,11.00,1100.00,'2022-11-08 15:28:41','',''),(1833,'1','285','1',1,'Retail Sale Id 1841',802.50,0.00,0.00,1.07,107.00,'2022-11-08 15:30:47','',''),(1834,'1','285','1',1,'Retail Sale Id 1842',2002.50,0.00,0.00,2.67,267.00,'2022-11-08 15:36:49','',''),(1835,'1','285','1',1,'Retail Sale Id 1843',1500.00,0.00,0.00,2.00,200.00,'2022-11-08 15:38:03','',''),(1836,'1','285','1',1,'Retail Sale Id 1845',750.00,0.00,0.00,1.00,100.00,'2022-11-08 15:41:02','',''),(1837,'1','285','1',1,'Retail Sale Id 1846',1500.00,0.00,0.00,2.00,200.00,'2022-11-08 15:48:28','',''),(1838,'1','285','1',1,'Retail Sale Id 1847',2250.00,0.00,0.00,3.00,300.00,'2022-11-08 15:50:57','',''),(1839,'1','285','1',1,'Retail Sale Id 1848',2250.00,0.00,0.00,3.00,300.00,'2022-11-08 15:58:06','',''),(1840,'1','285','1',1,'Retail Sale Id 1849',1500.00,0.00,0.00,2.00,200.00,'2022-11-08 15:59:30','',''),(1841,'1','285','1',1,'Return of Retail Sale Id 1849',0.00,1500.00,2.00,0.00,-200.00,'2022-11-08 16:00:18','',''),(1842,'1','285','1',1,'Retail Sale Id 1850',10205.10,0.00,0.00,14.79,591.60,'2022-11-08 16:01:55','',''),(1843,'1','285','1',1,'Retail Sale Id 1851',3000.00,0.00,0.00,4.00,400.00,'2022-11-08 16:04:48','',''),(1844,'1','285','1',1,'Retail Sale Id 1852',2250.00,0.00,0.00,3.00,300.00,'2022-11-08 16:10:39','',''),(1845,'1','285','1',1,'Retail Sale Id 1853',3000.00,0.00,0.00,4.00,400.00,'2022-11-08 16:15:14','',''),(1846,'1','285','1',1,'Retail Sale Id 1854',2250.00,0.00,0.00,3.00,300.00,'2022-11-08 16:16:08','',''),(1847,'1','285','1',1,'Retail Sale Id 1855',5250.00,0.00,0.00,7.00,700.00,'2022-11-08 16:27:44','',''),(1848,'1','285','1',1,'Retail Sale Id 1856',750.00,0.00,0.00,1.00,100.00,'2022-11-08 16:30:00','',''),(1849,'1','285','1',1,'Retail Sale Id 1857',1500.00,0.00,0.00,2.00,200.00,'2022-11-08 16:31:04','',''),(1850,'1','285','1',1,'Retail Sale Id 1858',750.00,0.00,0.00,1.00,100.00,'2022-11-08 16:35:16','',''),(1851,'1','285','1',1,'Retail Sale Id 1859',750.00,0.00,0.00,1.00,100.00,'2022-11-08 16:36:40','',''),(1852,'1','285','1',1,'Retail Sale Id 1860',2250.00,0.00,0.00,3.00,300.00,'2022-11-08 16:39:28','',''),(1853,'1','285','1',1,'Retail Sale Id 1861',2250.00,0.00,0.00,3.00,300.00,'2022-11-08 16:47:28','',''),(1854,'1','285','1',1,'Retail Sale Id 1862',37950.00,0.00,0.00,55.00,2200.00,'2022-11-08 16:51:56','',''),(1855,'1','285','1',1,'Retail Sale Id 1863',1500.00,0.00,0.00,2.00,200.00,'2022-11-08 17:01:21','',''),(1856,'1','285','1',1,'Retail Sale Id 1864',82800.00,0.00,0.00,120.00,4800.00,'2022-11-08 17:02:57','',''),(1857,'1','285','1',1,'Retail Sale Id 1865',31050.00,0.00,0.00,45.00,1800.00,'2022-11-08 17:06:09','',''),(1858,'1','285','1',1,'Retail Sale Id 1866',750.00,0.00,0.00,1.00,100.00,'2022-11-08 17:07:16','',''),(1859,'1','285','1',1,'Return of Retail Sale Id 1866',0.00,750.00,1.00,0.00,-100.00,'2022-11-08 18:47:27','',''),(1860,'1','285','1',1,'Retail Sale Id 1867',592.50,0.00,0.00,0.79,79.00,'2022-11-08 18:48:58','',''),(1861,'1','285','1',1,'Return of Retail Sale Id 1865',0.00,31050.00,45.00,0.00,-1800.00,'2022-11-08 18:53:06','',''),(1862,'1','285','1',1,'Retail Sale Id 1868',31422.60,0.00,0.00,45.54,1821.60,'2022-11-08 18:54:24','',''),(1863,'1','285','1',1,'Retail Sale Id 1869',22080.00,0.00,0.00,32.00,1280.00,'2022-11-09 07:32:12','',''),(1864,'1','285','1',1,'Retail Sale Id 1870',51977.70,0.00,0.00,75.33,3013.20,'2022-11-09 07:32:57','',''),(1865,'1','285','1',1,'Retail Sale Id 1871',10267.20,0.00,0.00,14.88,595.20,'2022-11-09 07:34:11','',''),(1866,'1','285','1',1,'Retail Sale Id 1872',88658.10,0.00,0.00,128.49,5139.60,'2022-11-09 07:37:28','',''),(1867,'1','285','1',1,'Retail Sale Id 1873',10467.30,0.00,0.00,15.17,606.80,'2022-11-09 07:40:32','',''),(1868,'1','285','1',1,'Retail Sale Id 1874',1500.00,0.00,0.00,2.00,200.00,'2022-11-09 08:00:40','',''),(1869,'1','285','1',1,'Retail Sale Id 1875',1500.00,0.00,0.00,2.00,200.00,'2022-11-09 08:12:52','',''),(1870,'1','285','1',1,'Retail Sale Id 1876',1500.00,0.00,0.00,2.00,200.00,'2022-11-09 08:13:48','',''),(1871,'1','285','1',1,'Retail Sale Id 1877',750.00,0.00,0.00,1.00,100.00,'2022-11-09 08:14:52','',''),(1872,'1','285','1',1,'Retail Sale Id 1878',2002.50,0.00,0.00,2.67,267.00,'2022-11-09 08:15:49','',''),(1873,'1','285','1',1,'Retail Sale Id 1879',34500.00,0.00,0.00,50.00,2000.00,'2022-11-09 08:19:58','',''),(1874,'1','285','1',1,'Retail Sale Id 1880',2002.50,0.00,0.00,2.67,267.00,'2022-11-09 08:20:40','',''),(1875,'1','285','1',1,'Retail Sale Id 1881',750.00,0.00,0.00,1.00,100.00,'2022-11-09 08:22:55','',''),(1876,'1','285','1',1,'Retail Sale Id 1882',1500.00,0.00,0.00,2.00,200.00,'2022-11-09 08:36:16','',''),(1877,'1','285','1',1,'Retail Sale Id 1883',997.50,0.00,0.00,1.33,133.00,'2022-11-09 08:37:04','',''),(1878,'1','285','1',1,'Retail Sale Id 1884',802.50,0.00,0.00,1.07,107.00,'2022-11-09 08:38:01','',''),(1879,'1','285','1',1,'Retail Sale Id 1885',750.00,0.00,0.00,1.00,100.00,'2022-11-09 08:48:46','',''),(1880,'1','285','1',1,'Retail Sale Id 1886',1500.00,0.00,0.00,2.00,200.00,'2022-11-09 08:49:38','',''),(1881,'1','285','1',1,'Retail Sale Id 1887',37950.00,0.00,0.00,55.00,2200.00,'2022-11-09 08:59:13','',''),(1882,'1','285','1',1,'Retail Sale Id 1888',34500.00,0.00,0.00,50.00,2000.00,'2022-11-09 09:06:55','',''),(1883,'1','285','1',1,'Retail Sale Id 1889',9873.90,0.00,0.00,14.31,572.40,'2022-11-09 09:09:01','',''),(1884,'1','285','1',1,'Retail Sale Id 1890',103500.00,0.00,0.00,150.00,6000.00,'2022-11-09 09:15:45','',''),(1885,'1','285','1',1,'Retail Sale Id 1891',2002.50,0.00,0.00,2.67,267.00,'2022-11-09 09:20:09','',''),(1886,'1','285','1',1,'Retail Sale Id 1892',802.50,0.00,0.00,1.07,107.00,'2022-11-09 09:21:35','',''),(1887,'1','285','1',1,'Retail Sale Id 1893',27600.00,0.00,0.00,40.00,1600.00,'2022-11-09 09:30:05','',''),(1888,'1','285','1',1,'Retail Sale Id 1894',44622.30,0.00,0.00,64.67,2586.80,'2022-11-09 09:33:19','',''),(1889,'1','285','1',1,'Retail Sale Id 1895',1500.00,0.00,0.00,2.00,200.00,'2022-11-09 09:50:56','',''),(1890,'1','285','1',1,'Retail Sale Id 1897',5497.50,0.00,0.00,7.33,733.00,'2022-11-09 09:55:41','',''),(1891,'1','285','1',1,'Retail Sale Id 1898',41400.00,0.00,0.00,60.00,2400.00,'2022-11-09 10:03:40','',''),(1892,'1','285','1',1,'Retail Sale Id 1899',41393.10,0.00,0.00,59.99,2399.60,'2022-11-09 10:07:11','',''),(1893,'1','285','1',1,'Retail Sale Id 1900',3000.00,0.00,0.00,4.00,400.00,'2022-11-09 10:25:22','',''),(1894,'1','285','1',1,'Retail Sale Id 1901',1500.00,0.00,0.00,2.00,200.00,'2022-11-09 10:27:27','',''),(1895,'1','285','1',1,'Retail Sale Id 1903',3000.00,0.00,0.00,4.00,400.00,'2022-11-09 10:28:29','',''),(1896,'1','285','1',1,'Retail Sale Id 1904',1500.00,0.00,0.00,2.00,200.00,'2022-11-09 10:37:36','',''),(1897,'1','285','1',1,'Retail Sale Id 1905',802.50,0.00,0.00,1.07,107.00,'2022-11-09 10:44:36','',''),(1898,'1','285','1',1,'Retail Sale Id 1906',1500.00,0.00,0.00,2.00,200.00,'2022-11-09 10:55:06','',''),(1899,'1','285','1',1,'Retail Sale Id 1907',10115.40,0.00,0.00,14.66,586.40,'2022-11-09 11:13:43','',''),(1900,'1','285','1',1,'Retail Sale Id 1908',1500.00,0.00,0.00,2.00,200.00,'2022-11-09 11:23:16','',''),(1901,'1','285','1',1,'Retail Sale Id 1909',27600.00,0.00,0.00,40.00,1600.00,'2022-11-09 11:35:15','',''),(1902,'1','285','1',1,'Retail Sale Id 1910',2250.00,0.00,0.00,3.00,300.00,'2022-11-09 11:38:19','',''),(1903,'1','285','1',1,'Retail Sale Id 1911',2002.50,0.00,0.00,2.67,267.00,'2022-11-09 11:43:59','',''),(1904,'1','285','1',1,'Retail Sale Id 1913',3000.00,0.00,0.00,4.00,400.00,'2022-11-09 11:55:50','',''),(1905,'1','285','1',1,'Retail Sale Id 1914',1500.00,0.00,0.00,2.00,200.00,'2022-11-09 12:22:42','',''),(1906,'1','285','1',1,'Retail Sale Id 1915',20700.00,0.00,0.00,30.00,1200.00,'2022-11-09 12:25:19','',''),(1907,'1','285','1',1,'Retail Sale Id 1916',27600.00,0.00,0.00,40.00,1600.00,'2022-11-09 12:33:25','',''),(1908,'1','285','1',1,'Retail Sale Id 1917',3000.00,0.00,0.00,4.00,400.00,'2022-11-09 12:36:49','',''),(1909,'1','285','1',1,'Retail Sale Id 1918',2250.00,0.00,0.00,3.00,300.00,'2022-11-09 12:38:10','',''),(1910,'1','285','1',1,'Retail Sale Id 1919',24150.00,0.00,0.00,35.00,1400.00,'2022-11-09 12:56:12','',''),(1911,'1','285','1',1,'Retail Sale Id 1920',1500.00,0.00,0.00,2.00,200.00,'2022-11-09 13:03:43','',''),(1912,'1','285','1',1,'Retail Sale Id 1921',5250.00,0.00,0.00,7.00,700.00,'2022-11-09 13:30:44','',''),(1913,'1','285','1',1,'Retail Sale Id 1922',3750.00,0.00,0.00,5.00,500.00,'2022-11-09 13:33:15','',''),(1914,'1','285','1',1,'Retail Sale Id 1923',997.50,0.00,0.00,1.33,133.00,'2022-11-09 13:34:13','',''),(1915,'1','285','1',1,'Retail Sale Id 1924',2250.00,0.00,0.00,3.00,300.00,'2022-11-09 13:42:49','',''),(1916,'1','285','1',1,'Retail Sale Id 1925',5602.50,0.00,0.00,7.47,747.00,'2022-11-09 13:53:57','',''),(1917,'1','285','1',1,'Retail Sale Id 1926',900.00,0.00,0.00,1.20,120.00,'2022-11-09 14:01:06','',''),(1918,'1','285','1',1,'Retail Sale Id 1928',1402.50,0.00,0.00,1.87,187.00,'2022-11-09 14:09:13','',''),(1919,'1','285','1',1,'Retail Sale Id 1929',1500.00,0.00,0.00,2.00,200.00,'2022-11-09 14:13:03','',''),(1920,'1','285','1',1,'Retail Sale Id 1930',57594.30,0.00,0.00,83.47,3338.80,'2022-11-09 14:17:25','',''),(1921,'1','285','1',1,'Retail Sale Id 1931',41393.10,0.00,0.00,59.99,2399.60,'2022-11-09 14:36:24','',''),(1922,'1','285','1',1,'Retail Sale Id 1932',1500.00,0.00,0.00,2.00,200.00,'2022-11-09 14:40:45','',''),(1923,'1','285','1',1,'Retail Sale Id 1933',1500.00,0.00,0.00,2.00,200.00,'2022-11-09 14:49:28','',''),(1924,'1','285','1',1,'Retail Sale Id 1934',750.00,0.00,0.00,1.00,100.00,'2022-11-09 14:59:43','',''),(1925,'1','285','1',1,'Retail Sale Id 1935',3000.00,0.00,0.00,4.00,400.00,'2022-11-09 15:13:26','',''),(1926,'1','285','1',1,'Retail Sale Id 1936',3750.00,0.00,0.00,5.00,500.00,'2022-11-09 15:29:00','',''),(1927,'1','285','1',1,'Retail Sale Id 1937',2250.00,0.00,0.00,3.00,300.00,'2022-11-09 15:32:11','',''),(1928,'1','285','1',1,'Retail Sale Id 1938',1500.00,0.00,0.00,2.00,200.00,'2022-11-09 15:34:45','',''),(1929,'1','285','1',1,'Retail Sale Id 1939',2197.50,0.00,0.00,2.93,293.00,'2022-11-09 15:36:17','',''),(1930,'1','285','1',1,'Return of Retail Sale Id 1921',0.00,5250.00,7.00,0.00,-700.00,'2022-11-09 15:39:47','',''),(1931,'1','285','1',1,'Retail Sale Id 1940',1500.00,0.00,0.00,2.00,200.00,'2022-11-09 15:45:34','',''),(1932,'1','285','1',1,'Retail Sale Id 1941',37950.00,0.00,0.00,55.00,2200.00,'2022-11-09 15:54:09','',''),(1933,'1','285','1',1,'Retail Sale Id 1942',2250.00,0.00,0.00,3.00,300.00,'2022-11-09 15:57:20','',''),(1934,'1','285','1',1,'Retail Sale Id 1943',750.00,0.00,0.00,1.00,100.00,'2022-11-09 15:59:21','',''),(1935,'1','285','1',1,'Retail Sale Id 1944',52771.20,0.00,0.00,76.48,3059.20,'2022-11-09 16:03:50','',''),(1936,'1','285','1',1,'Retail Sale Id 1945',750.00,0.00,0.00,1.00,100.00,'2022-11-09 16:04:50','',''),(1937,'1','285','1',1,'Retail Sale Id 1946',750.00,0.00,0.00,1.00,100.00,'2022-11-09 16:07:27','',''),(1938,'1','285','1',1,'Retail Sale Id 1947',41006.70,0.00,0.00,59.43,2377.20,'2022-11-09 16:10:10','',''),(1939,'1','285','1',1,'Retail Sale Id 1948',3750.00,0.00,0.00,5.00,500.00,'2022-11-09 16:11:22','',''),(1940,'1','285','1',1,'Return of Retail Sale Id 1923',0.00,997.50,1.33,0.00,-133.00,'2022-11-09 16:12:11','',''),(1941,'1','285','1',1,'Return of Retail Sale Id 1922',0.00,3750.00,5.00,0.00,-500.00,'2022-11-09 16:14:26','',''),(1942,'1','285','1',1,'Retail Sale Id 1949',3000.00,0.00,0.00,4.00,400.00,'2022-11-09 16:16:27','',''),(1943,'1','285','1',1,'Retail Sale Id 1950',2250.00,0.00,0.00,3.00,300.00,'2022-11-09 16:23:39','',''),(1944,'1','285','1',1,'Retail Sale Id 1951',997.50,0.00,0.00,1.33,133.00,'2022-11-09 16:30:52','',''),(1945,'1','285','1',1,'Retail Sale Id 1952',10087.80,0.00,0.00,14.62,584.80,'2022-11-09 16:38:43','',''),(1946,'1','285','1',1,'Retail Sale Id 1953',33465.00,0.00,0.00,48.50,1940.00,'2022-11-09 16:41:39','',''),(1947,'1','285','1',1,'Retail Sale Id 1954',3000.00,0.00,0.00,4.00,400.00,'2022-11-09 16:43:14','',''),(1948,'1','285','1',1,'Retail Sale Id 1957',2250.00,0.00,0.00,3.00,300.00,'2022-11-09 16:50:22','',''),(1949,'1','285','1',1,'Retail Sale Id 1958',900.00,0.00,0.00,1.20,120.00,'2022-11-09 16:57:50','',''),(1950,'1','285','1',1,'Retail Sale Id 1959',1500.00,0.00,0.00,2.00,200.00,'2022-11-09 16:58:36','',''),(1951,'1','285','1',1,'Retail Sale Id 1961',3000.00,0.00,0.00,4.00,400.00,'2022-11-09 17:03:46','',''),(1952,'1','285','1',1,'Retail Sale Id 1962',1500.00,0.00,0.00,2.00,200.00,'2022-11-09 17:05:15','',''),(1953,'1','285','1',1,'Retail Sale Id 1963',1342.50,0.00,0.00,1.79,179.00,'2022-11-09 17:15:02','',''),(1954,'1','285','1',1,'Retail Sale Id 1964',3615.60,0.00,0.00,5.24,209.60,'2022-11-09 17:25:28','',''),(1955,'1','285','1',1,'Return of Retail Sale Id 1958',0.00,900.00,1.20,0.00,-120.00,'2022-11-09 19:02:13','',''),(1956,'1','285','1',1,'Retail Sale Id 1965',885.00,0.00,0.00,1.18,118.00,'2022-11-09 19:03:44','',''),(1957,'1','285','1',1,'Retail Sale Id 1966',1500.00,0.00,0.00,2.00,200.00,'2022-11-10 07:36:22','',''),(1958,'1','285','1',1,'Retail Sale Id 1967',3000.00,0.00,0.00,4.00,400.00,'2022-11-10 07:41:09','',''),(1959,'1','285','1',1,'Retail Sale Id 1968',2497.50,0.00,0.00,3.33,333.00,'2022-11-10 07:42:19','',''),(1960,'1','285','1',1,'Retail Sale Id 1969',2497.50,0.00,0.00,3.33,333.00,'2022-11-10 07:43:16','',''),(1961,'1','285','1',1,'Retail Sale Id 1970',2250.00,0.00,0.00,3.00,300.00,'2022-11-10 07:44:04','',''),(1962,'1','285','1',1,'Retail Sale Id 1971',802.50,0.00,0.00,1.07,107.00,'2022-11-10 07:58:15','',''),(1963,'1','285','1',1,'Retail Sale Id 1972',2250.00,0.00,0.00,3.00,300.00,'2022-11-10 08:02:11','',''),(1964,'1','285','1',1,'Retail Sale Id 1973',802.50,0.00,0.00,1.07,107.00,'2022-11-10 08:05:15','',''),(1965,'1','285','1',1,'Retail Sale Id 1974',4500.00,0.00,0.00,6.00,600.00,'2022-11-10 08:07:07','',''),(1966,'1','285','1',1,'Retail Sale Id 1975',997.50,0.00,0.00,1.33,133.00,'2022-11-10 08:18:00','',''),(1967,'1','285','1',1,'Retail Sale Id 1976',750.00,0.00,0.00,1.00,100.00,'2022-11-10 08:21:53','',''),(1968,'1','285','1',1,'Retail Sale Id 1977',1500.00,0.00,0.00,2.00,200.00,'2022-11-10 08:27:35','',''),(1969,'1','285','1',1,'Retail Sale Id 1978',750.00,0.00,0.00,1.00,100.00,'2022-11-10 08:39:25','',''),(1970,'1','285','1',1,'Retail Sale Id 1979',3000.00,0.00,0.00,4.00,400.00,'2022-11-10 08:45:00','',''),(1971,'1','285','1',1,'Retail Sale Id 1980',1500.00,0.00,0.00,2.00,200.00,'2022-11-10 08:45:55','',''),(1972,'1','285','1',1,'Retail Sale Id 1981',1500.00,0.00,0.00,2.00,200.00,'2022-11-10 08:51:10','',''),(1973,'1','285','1',1,'Retail Sale Id 1982',63176.40,0.00,0.00,91.56,3662.40,'2022-11-10 08:57:20','',''),(1974,'1','285','1',1,'Retail Sale Id 1983',1500.00,0.00,0.00,2.00,200.00,'2022-11-10 09:01:14','',''),(1975,'1','285','1',1,'Retail Sale Id 1984',29925.30,0.00,0.00,43.37,1734.80,'2022-11-10 09:03:14','',''),(1976,'1','285','1',1,'Retail Sale Id 1985',2250.00,0.00,0.00,3.00,300.00,'2022-11-10 09:06:26','',''),(1977,'1','285','1',1,'Retail Sale Id 1986',6000.00,0.00,0.00,8.00,800.00,'2022-11-10 09:10:52','',''),(1978,'1','285','1',1,'Retail Sale Id 1987',11730.00,0.00,0.00,17.00,680.00,'2022-11-10 09:14:07','',''),(1979,'1','285','1',1,'Retail Sale Id 1988',12199.20,0.00,0.00,17.68,707.20,'2022-11-10 09:17:29','',''),(1980,'1','285','1',1,'Retail Sale Id 1989',1500.00,0.00,0.00,2.00,200.00,'2022-11-10 09:19:34','',''),(1981,'1','285','1',1,'Retail Sale Id 1990',49114.20,0.00,0.00,71.18,2847.20,'2022-11-10 09:32:35','',''),(1982,'1','285','1',1,'Retail Sale Id 1991',10025.70,0.00,0.00,14.53,581.20,'2022-11-10 09:35:33','',''),(1983,'1','285','1',1,'Retail Sale Id 1992',2250.00,0.00,0.00,3.00,300.00,'2022-11-10 09:51:50','',''),(1984,'1','285','1',1,'Retail Sale Id 1993',31050.00,0.00,0.00,45.00,1800.00,'2022-11-10 09:53:27','',''),(1985,'1','285','1',1,'Retail Sale Id 1994',44850.00,0.00,0.00,65.00,2600.00,'2022-11-10 09:58:01','',''),(1986,'1','285','1',1,'Retail Sale Id 1995',750.00,0.00,0.00,1.00,100.00,'2022-11-10 09:58:52','',''),(1987,'1','285','1',1,'Retail Sale Id 1996',1500.00,0.00,0.00,2.00,200.00,'2022-11-10 10:02:08','',''),(1988,'1','285','1',1,'Retail Sale Id 1997',1500.00,0.00,0.00,2.00,200.00,'2022-11-10 10:02:47','',''),(1989,'1','285','1',1,'Retail Sale Id 1998',2250.00,0.00,0.00,3.00,300.00,'2022-11-10 10:12:36','',''),(1990,'1','285','1',1,'Retail Sale Id 1999',750.00,0.00,0.00,1.00,100.00,'2022-11-10 10:22:02','',''),(1991,'1','285','1',1,'Retail Sale Id 2000',1500.00,0.00,0.00,2.00,200.00,'2022-11-10 10:23:07','',''),(1992,'1','285','1',1,'Retail Sale Id 2001',1500.00,0.00,0.00,2.00,200.00,'2022-11-10 10:42:42','',''),(1993,'1','285','1',1,'Retail Sale Id 2002',2250.00,0.00,0.00,3.00,300.00,'2022-11-10 10:45:34','',''),(1994,'1','285','1',1,'Retail Sale Id 2003',3000.00,0.00,0.00,4.00,400.00,'2022-11-10 10:46:13','',''),(1995,'1','285','1',1,'Retail Sale Id 2004',1500.00,0.00,0.00,2.00,200.00,'2022-11-10 10:48:27','',''),(1996,'1','285','1',1,'Retail Sale Id 2005',2070.00,0.00,0.00,3.00,120.00,'2022-11-10 11:12:54','',''),(1997,'1','285','1',1,'Retail Sale Id 2006',6000.00,0.00,0.00,8.00,800.00,'2022-11-10 11:26:43','',''),(1998,'1','285','1',1,'Retail Sale Id 2007',2250.00,0.00,0.00,3.00,300.00,'2022-11-10 11:31:02','',''),(1999,'1','285','1',1,'Retail Sale Id 2008',5250.00,0.00,0.00,7.00,700.00,'2022-11-10 11:33:04','',''),(2000,'1','285','1',1,'Retail Sale Id 2009',3000.00,0.00,0.00,4.00,400.00,'2022-11-10 11:43:12','',''),(2001,'1','285','1',1,'Retail Sale Id 2010',41400.00,0.00,0.00,60.00,2400.00,'2022-11-10 11:45:55','',''),(2002,'1','285','1',1,'Retail Sale Id 2011',1500.00,0.00,0.00,2.00,200.00,'2022-11-10 12:01:53','',''),(2003,'1','285','1',1,'Retail Sale Id 2012',2250.00,0.00,0.00,3.00,300.00,'2022-11-10 13:02:24','',''),(2004,'1','285','1',1,'Retail Sale Id 2013',2250.00,0.00,0.00,3.00,300.00,'2022-11-10 13:09:06','',''),(2005,'1','285','1',1,'Retail Sale Id 2014',750.00,0.00,0.00,1.00,100.00,'2022-11-10 13:31:04','',''),(2006,'1','285','1',1,'Retail Sale Id 2016',42331.50,0.00,0.00,61.35,2454.00,'2022-11-10 13:58:57','',''),(2007,'1','285','1',1,'Retail Sale Id 2017',1500.00,0.00,0.00,2.00,200.00,'2022-11-10 14:01:00','',''),(2008,'1','285','1',1,'Retail Sale Id 2019',51860.40,0.00,0.00,75.16,3006.40,'2022-11-10 14:01:39','',''),(2009,'1','285','1',1,'Retail Sale Id 2020',1500.00,0.00,0.00,2.00,200.00,'2022-11-10 14:02:17','',''),(2010,'1','285','1',1,'Retail Sale Id 2021',6255.00,0.00,0.00,8.34,834.00,'2022-11-10 14:03:25','',''),(2011,'1','285','1',1,'Retail Sale Id 2022',20700.00,0.00,0.00,30.00,1200.00,'2022-11-10 14:33:16','',''),(2012,'1','285','1',1,'Retail Sale Id 2023',33244.20,0.00,0.00,48.18,1927.20,'2022-11-10 14:37:23','',''),(2013,'1','285','1',1,'Return of Retail Sale Id 2023',0.00,33244.20,48.18,0.00,-1927.20,'2022-11-10 14:41:34','',''),(2014,'1','285','1',1,'Retail Sale Id 2024',32554.20,0.00,0.00,47.18,1887.20,'2022-11-10 14:42:09','',''),(2015,'1','285','1',1,'Retail Sale Id 2025',1500.00,0.00,0.00,2.00,200.00,'2022-11-10 14:43:19','',''),(2016,'1','285','1',1,'Retail Sale Id 2026',3750.00,0.00,0.00,5.00,500.00,'2022-11-10 14:47:44','',''),(2017,'1','285','1',1,'Retail Sale Id 2027',2250.00,0.00,0.00,3.00,300.00,'2022-11-10 14:55:27','',''),(2018,'1','285','1',1,'Retail Sale Id 2028',5625.00,0.00,0.00,7.50,750.00,'2022-11-10 15:22:00','',''),(2019,'1','285','1',1,'Retail Sale Id 2029',34589.70,0.00,0.00,50.13,2005.20,'2022-11-10 15:25:04','',''),(2020,'1','285','1',1,'Retail Sale Id 2030',3750.00,0.00,0.00,5.00,500.00,'2022-11-10 15:27:39','',''),(2021,'1','285','1',1,'Retail Sale Id 2031',1500.00,0.00,0.00,2.00,200.00,'2022-11-10 15:29:01','',''),(2022,'1','285','1',1,'Retail Sale Id 2032',750.00,0.00,0.00,1.00,100.00,'2022-11-10 15:45:40','',''),(2023,'1','285','1',1,'Retail Sale Id 2033',1500.00,0.00,0.00,2.00,200.00,'2022-11-10 15:46:26','',''),(2024,'1','285','1',1,'Retail Sale Id 2034',3750.00,0.00,0.00,5.00,500.00,'2022-11-10 15:47:16','',''),(2025,'1','285','1',1,'Retail Sale Id 2035',3997.50,0.00,0.00,5.33,533.00,'2022-11-10 15:53:37','',''),(2026,'1','285','1',1,'Retail Sale Id 2036',997.50,0.00,0.00,1.33,133.00,'2022-11-10 16:01:27','',''),(2027,'1','285','1',1,'Retail Sale Id 2037',802.50,0.00,0.00,1.07,107.00,'2022-11-10 16:09:21','',''),(2028,'1','285','1',1,'Retail Sale Id 2038',900.00,0.00,0.00,1.20,120.00,'2022-11-10 16:12:42','',''),(2029,'1','285','1',1,'Retail Sale Id 2039',6000.00,0.00,0.00,8.00,800.00,'2022-11-10 16:21:12','',''),(2030,'1','285','1',1,'Retail Sale Id 2040',37591.20,0.00,0.00,54.48,2179.20,'2022-11-10 16:27:07','',''),(2031,'1','285','1',1,'Return of Retail Sale Id 2021',0.00,6255.00,8.34,0.00,-834.00,'2022-11-10 16:33:57','',''),(2032,'1','285','1',1,'Return of Retail Sale Id 2008',0.00,5250.00,7.00,0.00,-700.00,'2022-11-10 16:34:31','',''),(2033,'1','285','1',1,'Return of Retail Sale Id 2037',0.00,802.50,1.07,0.00,-107.00,'2022-11-10 17:36:13','',''),(2034,'1','285','1',1,'Retail Sale Id 2041',1057.50,0.00,0.00,1.41,141.00,'2022-11-10 17:41:45','',''),(2035,'1','285','1',1,'Return of Retail Sale Id 2022',0.00,20700.00,30.00,0.00,-1200.00,'2022-11-10 17:44:29','',''),(2036,'1','285','1',1,'Retail Sale Id 2042',20444.70,0.00,0.00,29.63,1185.20,'2022-11-10 17:45:35','',''),(2037,'1','285','1',1,'Retail Sale Id 2043',37032.30,0.00,0.00,53.67,2146.80,'2022-11-11 07:48:35','',''),(2038,'1','285','1',1,'Retail Sale Id 2045',41400.00,0.00,0.00,60.00,2400.00,'2022-11-11 07:52:10','',''),(2039,'1','285','1',1,'Retail Sale Id 2046',42897.30,0.00,0.00,62.17,2486.80,'2022-11-11 07:53:08','',''),(2040,'1','285','1',1,'Retail Sale Id 2044',15228.30,0.00,0.00,22.07,882.80,'2022-11-11 07:55:29','',''),(2041,'1','285','1',1,'Retail Sale Id 2047',3450.00,0.00,0.00,5.00,200.00,'2022-11-11 08:37:30','',''),(2042,'1','285','1',1,'Retail Sale Id 2048',34500.00,0.00,0.00,50.00,2000.00,'2022-11-11 08:53:24','',''),(2043,'1','285','1',1,'Retail Sale Id 2049',17077.50,0.00,0.00,24.75,990.00,'2022-11-11 08:55:04','',''),(2044,'1','285','1',1,'Retail Sale Id 2050',34500.00,0.00,0.00,50.00,2000.00,'2022-11-11 09:24:52','',''),(2045,'1','285','1',1,'Retail Sale Id 2051',2497.50,0.00,0.00,3.33,333.00,'2022-11-11 09:33:51','',''),(2046,'1','285','1',1,'Retail Sale Id 2052',2497.50,0.00,0.00,3.33,333.00,'2022-11-11 09:35:24','',''),(2047,'1','285','1',1,'Retail Sale Id 2053',3502.50,0.00,0.00,4.67,467.00,'2022-11-11 09:36:27','',''),(2048,'1','285','1',1,'Retail Sale Id 2054',3000.00,0.00,0.00,4.00,400.00,'2022-11-11 09:37:33','',''),(2049,'1','285','1',1,'Retail Sale Id 2055',2497.50,0.00,0.00,3.33,333.00,'2022-11-11 09:39:52','',''),(2050,'1','285','1',1,'Retail Sale Id 2056',10253.40,0.00,0.00,14.86,594.40,'2022-11-11 09:41:15','',''),(2051,'1','285','1',1,'Retail Sale Id 2057',51787.50,0.00,0.00,69.05,6905.00,'2022-11-11 09:48:04','',''),(2052,'1','285','1',1,'Retail Sale Id 2058',33120.00,0.00,0.00,48.00,1920.00,'2022-11-11 09:51:56','',''),(2053,'1','285','1',1,'Retail Sale Id 2059',44387.70,0.00,0.00,64.33,2573.20,'2022-11-11 10:13:31','',''),(2054,'1','285','1',1,'Retail Sale Id 2060',35072.70,0.00,0.00,50.83,2033.20,'2022-11-11 13:14:01','',''),(2055,'1','285','1',1,'Retail Sale Id 2061',93150.00,0.00,0.00,135.00,5400.00,'2022-11-11 14:26:42','',''),(2056,'1','285','1',1,'Retail Sale Id 2062',16691.10,0.00,0.00,24.19,967.60,'2022-11-11 14:43:36','',''),(2057,'1','285','1',1,'Retail Sale Id 2063',42862.80,0.00,0.00,62.12,2484.80,'2022-11-11 14:57:11','',''),(2058,'1','285','1',1,'Retail Sale Id 2064',12068.10,0.00,0.00,17.49,699.60,'2022-11-11 15:57:56','',''),(2059,'1','285','1',1,'Retail Sale Id 2065',32471.40,0.00,0.00,47.06,1882.40,'2022-11-11 15:59:24','',''),(2060,'1','285','1',1,'Retail Sale Id 2066',12164.70,0.00,0.00,17.63,705.20,'2022-11-11 16:07:36','',''),(2061,'1','285','1',1,'Retail Sale Id 2067',41889.90,0.00,0.00,60.71,2428.40,'2022-11-11 16:26:15','',''),(2062,'1','285','1',1,'Retail Sale Id 2068',27600.00,0.00,0.00,40.00,1600.00,'2022-11-11 16:29:02','',''),(2063,'1','285','1',1,'Retail Sale Id 2069',12185.40,0.00,0.00,17.66,706.40,'2022-11-11 16:47:11','',''),(2064,'1','285','1',1,'Retail Sale Id 2070',84235.20,0.00,0.00,122.08,4883.20,'2022-11-11 17:03:34','',''),(2065,'1','285','1',1,'Retail Sale Id 2071',72360.00,0.00,0.00,96.48,9648.00,'2022-11-11 17:55:30','',''),(2066,'1','285','1',1,'Retail Sale Id 2072',20679.30,0.00,0.00,29.97,1198.80,'2022-11-11 18:01:09','',''),(2067,'1','285','1',1,'Retail Sale Id 2073',41952.00,0.00,0.00,60.80,2432.00,'2022-11-12 07:24:15','',''),(2068,'1','285','1',1,'Retail Sale Id 2074',16974.00,0.00,0.00,24.60,984.00,'2022-11-12 07:35:20','',''),(2069,'1','285','1',1,'Retail Sale Id 2075',48990.00,0.00,0.00,71.00,2840.00,'2022-11-12 08:03:19','',''),(2070,'1','285','1',1,'Retail Sale Id 2076',54585.90,0.00,0.00,79.11,3164.40,'2022-11-12 09:21:57','',''),(2071,'1','285','1',1,'Retail Sale Id 2077',37950.00,0.00,0.00,55.00,2200.00,'2022-11-12 09:23:21','',''),(2072,'1','285','1',1,'Retail Sale Id 2078',44401.50,0.00,0.00,64.35,2574.00,'2022-11-12 09:40:03','',''),(2073,'1','285','1',1,'Retail Sale Id 2079',39330.00,0.00,0.00,52.44,5244.00,'2022-11-12 09:59:34','',''),(2074,'1','285','1',1,'Retail Sale Id 2080',55959.00,0.00,0.00,81.10,3244.00,'2022-11-12 10:07:59','',''),(2075,'1','285','1',1,'Retail Sale Id 2081',42331.50,0.00,0.00,61.35,2454.00,'2022-11-12 10:09:03','',''),(2076,'1','285','1',1,'Retail Sale Id 2082',43601.10,0.00,0.00,63.19,2527.60,'2022-11-12 12:09:56','',''),(2077,'1','285','1',1,'Retail Sale Id 2083',6900.00,0.00,0.00,10.00,400.00,'2022-11-12 12:24:56','',''),(2078,'1','285','1',1,'Retail Sale Id 2084',57960.00,0.00,0.00,84.00,3360.00,'2022-11-12 13:05:22','',''),(2079,'1','285','1',1,'Retail Sale Id 2085',16801.50,0.00,0.00,24.35,974.00,'2022-11-12 13:08:58','',''),(2080,'1','285','1',1,'Retail Sale Id 2086',45891.90,0.00,0.00,66.51,2660.40,'2022-11-12 13:41:34','',''),(2081,'1','285','1',1,'Retail Sale Id 2087',22914.90,0.00,0.00,33.21,1328.40,'2022-11-12 13:45:09','',''),(2082,'1','285','1',1,'Retail Sale Id 2089',41917.50,0.00,0.00,60.75,2430.00,'2022-11-12 14:49:09','',''),(2083,'1','285','1',1,'Retail Sale Id 2090',51922.50,0.00,0.00,75.25,3010.00,'2022-11-12 14:58:45','',''),(2084,'1','285','1',1,'Retail Sale Id 2091',41648.40,0.00,0.00,60.36,2414.40,'2022-11-12 15:02:37','',''),(2085,'1','285','1',1,'Retail Sale Id 2092',11971.50,0.00,0.00,17.35,694.00,'2022-11-12 16:11:52','',''),(2086,'1','285','1',1,'Retail Sale Id 2093',27738.00,0.00,0.00,40.20,1608.00,'2022-11-12 16:15:24','',''),(2087,'1','285','1',1,'Retail Sale Id 2095',12006.00,0.00,0.00,17.40,696.00,'2022-11-12 16:20:35','',''),(2088,'1','285','1',1,'Retail Sale Id 2096',10232.70,0.00,0.00,14.83,593.20,'2022-11-12 16:23:35','',''),(2089,'1','285','1',1,'Retail Sale Id 2097',30705.00,0.00,0.00,44.50,1780.00,'2022-11-12 16:25:59','',''),(2090,'1','285','1',1,'Retail Sale Id 2098',17250.00,0.00,0.00,25.00,1000.00,'2022-11-12 16:28:17','',''),(2091,'1','285','1',1,'Retail Sale Id 2099',41406.90,0.00,0.00,60.01,2400.40,'2022-11-12 16:41:24','',''),(2092,'1','285','1',1,'Retail Sale Id 2100',41400.00,0.00,0.00,60.00,2400.00,'2022-11-12 16:46:30','',''),(2093,'1','285','1',1,'Retail Sale Id 2101',51777.60,0.00,0.00,75.04,3001.60,'2022-11-12 16:54:44','',''),(2094,'1','285','1',1,'Return of Retail Sale Id 2083',0.00,6900.00,10.00,0.00,-400.00,'2022-11-12 17:26:44','',''),(2095,'1','285','1',1,'Return of Retail Sale Id 2098',0.00,17250.00,25.00,0.00,-1000.00,'2022-11-12 19:13:22','',''),(2096,'1','285','1',1,'Retail Sale Id 2102',17256.90,0.00,0.00,25.01,1000.40,'2022-11-12 19:14:40','',''),(2097,'1','285','1',1,'Retail Sale Id 2103',55410.00,0.00,0.00,73.88,7388.00,'2022-11-12 19:20:04','',''),(2098,'1','285','1',1,'Retail Sale Id 2104',40020.00,0.00,0.00,58.00,2320.00,'2022-11-13 07:45:25','',''),(2099,'1','285','1',1,'Retail Sale Id 2105',16953.30,0.00,0.00,24.57,982.80,'2022-11-13 07:46:35','',''),(2100,'1','285','1',1,'Retail Sale Id 2106',42842.10,0.00,0.00,62.09,2483.60,'2022-11-13 07:48:05','',''),(2101,'1','285','1',1,'Retail Sale Id 2107',31050.00,0.00,0.00,45.00,1800.00,'2022-11-13 07:49:12','',''),(2102,'1','285','1',1,'Retail Sale Id 2108',28497.00,0.00,0.00,41.30,1652.00,'2022-11-13 07:51:54','',''),(2103,'1','285','1',1,'Retail Sale Id 2109',16767.00,0.00,0.00,24.30,972.00,'2022-11-13 07:58:38','',''),(2104,'1','285','1',1,'Retail Sale Id 2110',16884.30,0.00,0.00,24.47,978.80,'2022-11-13 08:07:51','',''),(2105,'1','285','1',1,'Retail Sale Id 2111',23018.40,0.00,0.00,33.36,1334.40,'2022-11-13 08:26:05','',''),(2106,'1','285','1',1,'Retail Sale Id 2113',47835.00,0.00,0.00,63.78,6378.00,'2022-11-13 08:53:52','',''),(2107,'1','285','1',1,'Retail Sale Id 2114',41400.00,0.00,0.00,60.00,2400.00,'2022-11-13 09:58:12','',''),(2108,'1','285','1',1,'Retail Sale Id 2115',7747.50,0.00,0.00,10.33,1033.00,'2022-11-13 10:23:28','',''),(2109,'1','285','1',1,'Retail Sale Id 2116',85504.80,0.00,0.00,123.92,4956.80,'2022-11-13 10:25:14','',''),(2110,'1','285','1',1,'Retail Sale Id 2117',1500.00,0.00,0.00,2.00,200.00,'2022-11-13 10:26:42','',''),(2111,'1','285','1',1,'Retail Sale Id 2118',41400.00,0.00,0.00,60.00,2400.00,'2022-11-13 10:35:10','',''),(2112,'1','285','1',1,'Retail Sale Id 2119',11250.00,0.00,0.00,15.00,1500.00,'2022-11-13 12:27:11','',''),(2113,'1','285','1',1,'Retail Sale Id 2120',34500.00,0.00,0.00,50.00,2000.00,'2022-11-13 12:45:57','',''),(2114,'1','285','1',1,'Retail Sale Id 2121',4500.00,0.00,0.00,6.00,600.00,'2022-11-13 12:49:54','',''),(2115,'1','285','1',1,'Retail Sale Id 2124',1500.00,0.00,0.00,2.00,200.00,'2022-11-13 12:51:20','',''),(2116,'1','285','1',1,'Retail Sale Id 2125',34500.00,0.00,0.00,50.00,2000.00,'2022-11-13 13:24:00','',''),(2117,'1','285','1',1,'Retail Sale Id 2126',802.50,0.00,0.00,1.07,107.00,'2022-11-13 13:29:21','',''),(2118,'1','285','1',1,'Retail Sale Id 2128',3000.00,0.00,0.00,4.00,400.00,'2022-11-13 13:50:17','',''),(2119,'1','285','1',1,'Retail Sale Id 2129',3000.00,0.00,0.00,4.00,400.00,'2022-11-13 13:52:44','',''),(2120,'1','285','1',1,'Retail Sale Id 2130',4500.00,0.00,0.00,6.00,600.00,'2022-11-13 13:58:27','',''),(2121,'1','285','1',1,'Retail Sale Id 2131',750.00,0.00,0.00,1.00,100.00,'2022-11-13 14:02:20','',''),(2122,'1','285','1',1,'Retail Sale Id 2132',997.50,0.00,0.00,1.33,133.00,'2022-11-13 14:09:54','',''),(2123,'1','285','1',1,'Retail Sale Id 2133',10439.70,0.00,0.00,15.13,605.20,'2022-11-13 14:10:33','',''),(2124,'1','285','1',1,'Retail Sale Id 2134',1500.00,0.00,0.00,2.00,200.00,'2022-11-13 14:14:16','',''),(2125,'1','285','1',1,'Retail Sale Id 2135',49238.40,0.00,0.00,71.36,2854.40,'2022-11-13 14:34:29','',''),(2126,'1','285','1',1,'Retail Sale Id 2137',1500.00,0.00,0.00,2.00,200.00,'2022-11-13 14:48:32','',''),(2127,'1','285','1',1,'Retail Sale Id 2138',1500.00,0.00,0.00,2.00,200.00,'2022-11-13 14:59:54','',''),(2128,'1','285','1',1,'Retail Sale Id 2139',39557.70,0.00,0.00,57.33,2293.20,'2022-11-13 15:10:48','',''),(2129,'1','285','1',1,'Retail Sale Id 2140',1500.00,0.00,0.00,2.00,200.00,'2022-11-13 15:15:26','',''),(2130,'1','285','1',1,'Retail Sale Id 2141',1500.00,0.00,0.00,2.00,200.00,'2022-11-13 15:20:08','',''),(2131,'1','285','1',1,'Retail Sale Id 2142',802.50,0.00,0.00,1.07,107.00,'2022-11-13 15:22:46','',''),(2132,'1','285','1',1,'Retail Sale Id 2143',3502.50,0.00,0.00,4.67,467.00,'2022-11-13 15:28:29','',''),(2133,'1','285','1',1,'Retail Sale Id 2145',8250.00,0.00,0.00,11.00,1100.00,'2022-11-13 15:36:48','',''),(2134,'1','285','1',1,'Retail Sale Id 2146',1500.00,0.00,0.00,2.00,200.00,'2022-11-13 15:40:01','',''),(2135,'1','285','1',1,'Retail Sale Id 2148',1125.00,0.00,0.00,1.50,150.00,'2022-11-13 15:59:56','',''),(2136,'1','285','1',1,'Retail Sale Id 2149',1500.00,0.00,0.00,2.00,200.00,'2022-11-13 16:00:48','',''),(2137,'1','285','1',1,'Retail Sale Id 2150',3000.00,0.00,0.00,4.00,400.00,'2022-11-13 16:01:17','',''),(2138,'1','285','1',1,'Retail Sale Id 2151',14807.40,0.00,0.00,21.46,858.40,'2022-11-13 16:02:06','',''),(2139,'1','285','1',1,'Retail Sale Id 2153',750.00,0.00,0.00,1.00,100.00,'2022-11-13 16:03:08','',''),(2140,'1','285','1',1,'Retail Sale Id 2155',750.00,0.00,0.00,1.00,100.00,'2022-11-13 16:04:06','',''),(2141,'1','285','1',1,'Retail Sale Id 2156',997.50,0.00,0.00,1.33,133.00,'2022-11-13 16:11:14','',''),(2142,'1','285','1',1,'Retail Sale Id 2157',750.00,0.00,0.00,1.00,100.00,'2022-11-13 16:16:42','',''),(2143,'1','285','1',1,'Retail Sale Id 2159',7717.50,0.00,0.00,10.29,1029.00,'2022-11-13 16:25:38','',''),(2144,'1','285','1',1,'Retail Sale Id 2161',41641.50,0.00,0.00,60.35,2414.00,'2022-11-13 16:39:59','',''),(2145,'1','285','1',1,'Return of Retail Sale Id 2151',0.00,14807.40,21.46,0.00,-858.40,'2022-11-13 17:38:46','',''),(2146,'1','285','1',1,'Retail Sale Id 2162',9190.80,0.00,0.00,13.32,532.80,'2022-11-13 17:39:37','',''),(2147,'1','285','1',1,'Retail Sale Id 2163',750.00,0.00,0.00,1.00,100.00,'2022-11-14 07:28:04','',''),(2148,'1','285','1',1,'Retail Sale Id 2164',997.50,0.00,0.00,1.33,133.00,'2022-11-14 07:29:18','',''),(2149,'1','285','1',1,'Retail Sale Id 2165',59077.80,0.00,0.00,85.62,3424.80,'2022-11-14 07:46:11','',''),(2150,'1','285','1',1,'Retail Sale Id 2166',750.00,0.00,0.00,1.00,100.00,'2022-11-14 07:47:35','',''),(2151,'1','285','1',1,'Retail Sale Id 2167',3000.00,0.00,0.00,4.00,400.00,'2022-11-14 07:51:09','',''),(2152,'1','285','1',1,'Retail Sale Id 2168',2250.00,0.00,0.00,3.00,300.00,'2022-11-14 07:52:26','',''),(2153,'1','285','1',1,'Retail Sale Id 2169',1500.00,0.00,0.00,2.00,200.00,'2022-11-14 08:00:00','',''),(2154,'1','285','1',1,'Retail Sale Id 2170',1500.00,0.00,0.00,2.00,200.00,'2022-11-14 08:03:16','',''),(2155,'1','285','1',1,'Retail Sale Id 2171',1500.00,0.00,0.00,2.00,200.00,'2022-11-14 08:06:03','',''),(2156,'1','285','1',1,'Retail Sale Id 2172',750.00,0.00,0.00,1.00,100.00,'2022-11-14 08:08:06','',''),(2157,'1','285','1',1,'Retail Sale Id 2173',40710.00,0.00,0.00,59.00,2360.00,'2022-11-14 08:16:26','',''),(2158,'1','285','1',1,'Retail Sale Id 2174',1500.00,0.00,0.00,2.00,200.00,'2022-11-14 08:17:02','',''),(2159,'1','285','1',1,'Retail Sale Id 2175',38640.00,0.00,0.00,56.00,2240.00,'2022-11-14 08:19:09','',''),(2160,'1','285','1',1,'Retail Sale Id 2176',46982.10,0.00,0.00,68.09,2723.60,'2022-11-14 08:20:44','',''),(2161,'1','285','1',1,'Retail Sale Id 2177',1500.00,0.00,0.00,2.00,200.00,'2022-11-14 08:26:02','',''),(2162,'1','285','1',1,'Retail Sale Id 2178',750.00,0.00,0.00,1.00,100.00,'2022-11-14 08:30:02','',''),(2163,'1','285','1',1,'Retail Sale Id 2179',3000.00,0.00,0.00,4.00,400.00,'2022-11-14 08:30:52','',''),(2164,'1','285','1',1,'Retail Sale Id 2180',1500.00,0.00,0.00,2.00,200.00,'2022-11-14 08:37:44','',''),(2165,'1','285','1',1,'Retail Sale Id 2181',38640.00,0.00,0.00,56.00,2240.00,'2022-11-14 08:41:28','',''),(2166,'1','285','1',1,'Retail Sale Id 2182',3000.00,0.00,0.00,4.00,400.00,'2022-11-14 08:47:20','',''),(2167,'1','285','1',1,'Retail Sale Id 2183',46250.70,0.00,0.00,67.03,2681.20,'2022-11-14 08:53:56','',''),(2168,'1','285','1',1,'Retail Sale Id 2184',43580.40,0.00,0.00,63.16,2526.40,'2022-11-14 08:55:41','',''),(2169,'1','285','1',1,'Retail Sale Id 2185',2250.00,0.00,0.00,3.00,300.00,'2022-11-14 08:57:37','',''),(2170,'1','285','1',1,'Retail Sale Id 2186',1500.00,0.00,0.00,2.00,200.00,'2022-11-14 08:59:38','',''),(2171,'1','285','1',1,'Retail Sale Id 2187',997.50,0.00,0.00,1.33,133.00,'2022-11-14 09:07:59','',''),(2172,'1','285','1',1,'Retail Sale Id 2188',3000.00,0.00,0.00,4.00,400.00,'2022-11-14 09:17:17','',''),(2173,'1','285','1',1,'Retail Sale Id 2189',750.00,0.00,0.00,1.00,100.00,'2022-11-14 09:18:28','',''),(2174,'1','285','1',1,'Retail Sale Id 2190',1800.00,0.00,0.00,2.40,240.00,'2022-11-14 09:19:20','',''),(2175,'1','285','1',1,'Retail Sale Id 2191',24150.00,0.00,0.00,35.00,1400.00,'2022-11-14 09:25:26','',''),(2176,'1','285','1',1,'Retail Sale Id 2192',112500.00,0.00,0.00,150.00,15000.00,'2022-11-14 09:35:35','',''),(2177,'1','285','1',1,'Return of Retail Sale Id 2192',0.00,112500.00,150.00,0.00,-15000.00,'2022-11-14 09:36:18','',''),(2178,'1','285','1',1,'Retail Sale Id 2194',103500.00,0.00,0.00,150.00,6000.00,'2022-11-14 09:36:56','',''),(2179,'1','285','1',1,'Retail Sale Id 2195',750.00,0.00,0.00,1.00,100.00,'2022-11-14 09:37:57','',''),(2180,'1','285','1',1,'Retail Sale Id 2196',2002.50,0.00,0.00,2.67,267.00,'2022-11-14 09:44:19','',''),(2181,'1','285','1',1,'Retail Sale Id 2197',1500.00,0.00,0.00,2.00,200.00,'2022-11-14 09:47:14','',''),(2182,'1','285','1',1,'Retail Sale Id 2198',1500.00,0.00,0.00,2.00,200.00,'2022-11-14 10:03:58','',''),(2183,'1','285','1',1,'Retail Sale Id 2199',90120.90,0.00,0.00,130.61,5224.40,'2022-11-14 10:08:30','',''),(2184,'1','285','1',1,'Retail Sale Id 2201',1500.00,0.00,0.00,2.00,200.00,'2022-11-14 10:10:17','',''),(2185,'1','285','1',1,'Retail Sale Id 2202',67164.60,0.00,0.00,97.34,3893.60,'2022-11-14 10:11:24','',''),(2186,'1','285','1',1,'Retail Sale Id 2203',84180.00,0.00,0.00,122.00,4880.00,'2022-11-14 10:15:45','',''),(2187,'1','285','1',1,'Retail Sale Id 2204',750.00,0.00,0.00,1.00,100.00,'2022-11-14 10:29:38','',''),(2188,'1','285','1',1,'Retail Sale Id 2205',2250.00,0.00,0.00,3.00,300.00,'2022-11-14 10:40:03','',''),(2189,'1','285','1',1,'Retail Sale Id 2206',1500.00,0.00,0.00,2.00,200.00,'2022-11-14 10:46:17','',''),(2190,'1','285','1',1,'Retail Sale Id 2207',3000.00,0.00,0.00,4.00,400.00,'2022-11-14 10:47:07','',''),(2191,'1','285','1',1,'Retail Sale Id 2208',3000.00,0.00,0.00,4.00,400.00,'2022-11-14 10:47:56','',''),(2192,'1','285','1',1,'Retail Sale Id 2209',4500.00,0.00,0.00,6.00,600.00,'2022-11-14 11:04:34','',''),(2193,'1','285','1',1,'Retail Sale Id 2210',997.50,0.00,0.00,1.33,133.00,'2022-11-14 11:24:42','',''),(2194,'1','285','1',1,'Retail Sale Id 2211',2002.50,0.00,0.00,2.67,267.00,'2022-11-14 11:29:17','',''),(2195,'1','285','1',1,'Retail Sale Id 2212',1500.00,0.00,0.00,2.00,200.00,'2022-11-14 11:30:42','',''),(2196,'1','285','1',1,'Retail Sale Id 2213',802.50,0.00,0.00,1.07,107.00,'2022-11-14 11:35:22','',''),(2197,'1','285','1',1,'Retail Sale Id 2214',802.50,0.00,0.00,1.07,107.00,'2022-11-14 11:40:03','',''),(2198,'1','285','1',1,'Retail Sale Id 2215',750.00,0.00,0.00,1.00,100.00,'2022-11-14 11:52:44','',''),(2199,'1','285','1',1,'Retail Sale Id 2216',2250.00,0.00,0.00,3.00,300.00,'2022-11-14 12:08:09','',''),(2200,'1','285','1',1,'Retail Sale Id 2217',1500.00,0.00,0.00,2.00,200.00,'2022-11-14 12:23:45','',''),(2201,'1','285','1',1,'Retail Sale Id 2218',22542.30,0.00,0.00,32.67,1306.80,'2022-11-14 12:31:11','',''),(2202,'1','285','1',1,'Retail Sale Id 2219',997.50,0.00,0.00,1.33,133.00,'2022-11-14 12:32:50','',''),(2203,'1','285','1',1,'Retail Sale Id 2220',997.50,0.00,0.00,1.33,133.00,'2022-11-14 12:44:02','',''),(2204,'1','285','1',1,'Retail Sale Id 2221',3000.00,0.00,0.00,4.00,400.00,'2022-11-14 12:48:56','',''),(2205,'1','285','1',1,'Retail Sale Id 2222',2250.00,0.00,0.00,3.00,300.00,'2022-11-14 12:54:50','',''),(2206,'1','285','1',1,'Retail Sale Id 2223',750.00,0.00,0.00,1.00,100.00,'2022-11-14 13:06:07','',''),(2207,'1','285','1',1,'Retail Sale Id 2224',6997.50,0.00,0.00,9.33,933.00,'2022-11-14 13:09:40','',''),(2208,'1','285','1',1,'Retail Sale Id 2225',2250.00,0.00,0.00,3.00,300.00,'2022-11-14 13:11:33','',''),(2209,'1','285','1',1,'Retail Sale Id 2226',9756.60,0.00,0.00,14.14,565.60,'2022-11-14 13:13:12','',''),(2210,'1','285','1',1,'Retail Sale Id 2227',3750.00,0.00,0.00,5.00,500.00,'2022-11-14 13:22:05','',''),(2211,'1','285','1',1,'Retail Sale Id 2228',5250.00,0.00,0.00,7.00,700.00,'2022-11-14 13:47:53','',''),(2212,'1','285','1',1,'Retail Sale Id 2229',3750.00,0.00,0.00,5.00,500.00,'2022-11-14 13:50:52','',''),(2213,'1','285','1',1,'Retail Sale Id 2230',3750.00,0.00,0.00,5.00,500.00,'2022-11-14 14:07:01','',''),(2214,'1','285','1',1,'Retail Sale Id 2231',1500.00,0.00,0.00,2.00,200.00,'2022-11-14 14:08:11','',''),(2215,'1','285','1',1,'Retail Sale Id 2232',41400.00,0.00,0.00,60.00,2400.00,'2022-11-14 14:15:35','',''),(2216,'1','285','1',1,'Retail Sale Id 2233',3000.00,0.00,0.00,4.00,400.00,'2022-11-14 14:19:12','',''),(2217,'1','285','1',1,'Retail Sale Id 2234',4500.00,0.00,0.00,6.00,600.00,'2022-11-14 14:29:09','',''),(2218,'1','285','1',1,'Retail Sale Id 2235',802.50,0.00,0.00,1.07,107.00,'2022-11-14 14:42:33','',''),(2219,'1','285','1',1,'Retail Sale Id 2236',41213.70,0.00,0.00,59.73,2389.20,'2022-11-14 14:51:03','',''),(2220,'1','285','1',1,'Retail Sale Id 2237',8250.00,0.00,0.00,11.00,1100.00,'2022-11-14 14:52:31','',''),(2221,'1','285','1',1,'Retail Sale Id 2238',41572.50,0.00,0.00,60.25,2410.00,'2022-11-14 14:54:29','',''),(2222,'1','285','1',1,'Retail Sale Id 2239',2250.00,0.00,0.00,3.00,300.00,'2022-11-14 14:55:33','',''),(2223,'1','285','1',1,'Retail Sale Id 2240',2250.00,0.00,0.00,3.00,300.00,'2022-11-14 14:56:34','',''),(2224,'1','285','1',1,'Retail Sale Id 2241',2250.00,0.00,0.00,3.00,300.00,'2022-11-14 14:57:14','',''),(2225,'1','285','1',1,'Retail Sale Id 2242',2250.00,0.00,0.00,3.00,300.00,'2022-11-14 14:58:01','',''),(2226,'1','285','1',1,'Retail Sale Id 2243',9375.00,0.00,0.00,12.50,1250.00,'2022-11-14 14:59:02','',''),(2227,'1','285','1',1,'Retail Sale Id 2245',4581.60,0.00,0.00,6.64,265.60,'2022-11-14 15:07:22','',''),(2228,'1','285','1',1,'Retail Sale Id 2246',2250.00,0.00,0.00,3.00,300.00,'2022-11-14 15:10:42','',''),(2229,'1','285','1',1,'Retail Sale Id 2247',3000.00,0.00,0.00,4.00,400.00,'2022-11-14 15:14:53','',''),(2230,'1','285','1',1,'Retail Sale Id 2248',2250.00,0.00,0.00,3.00,300.00,'2022-11-14 15:27:15','',''),(2231,'1','285','1',1,'Retail Sale Id 2249',1500.00,0.00,0.00,2.00,200.00,'2022-11-14 15:34:27','',''),(2232,'1','285','1',1,'Retail Sale Id 2250',5250.00,0.00,0.00,7.00,700.00,'2022-11-14 15:44:15','',''),(2233,'1','285','1',1,'Retail Sale Id 2251',3000.00,0.00,0.00,4.00,400.00,'2022-11-14 15:45:16','',''),(2234,'1','285','1',1,'Retail Sale Id 2252',9000.00,0.00,0.00,12.00,1200.00,'2022-11-14 15:49:30','',''),(2235,'1','285','1',1,'Retail Sale Id 2253',2250.00,0.00,0.00,3.00,300.00,'2022-11-14 15:53:56','',''),(2236,'1','285','1',1,'Retail Sale Id 2254',11895.60,0.00,0.00,17.24,689.60,'2022-11-14 16:09:29','',''),(2237,'1','285','1',1,'Retail Sale Id 2255',802.50,0.00,0.00,1.07,107.00,'2022-11-14 16:11:28','',''),(2238,'1','285','1',1,'Retail Sale Id 2256',41117.10,0.00,0.00,59.59,2383.60,'2022-11-14 16:13:12','',''),(2239,'1','285','1',1,'Retail Sale Id 2257',3000.00,0.00,0.00,4.00,400.00,'2022-11-14 16:18:42','',''),(2240,'1','285','1',1,'Retail Sale Id 2258',50025.00,0.00,0.00,72.50,2900.00,'2022-11-14 16:20:29','',''),(2241,'1','285','1',1,'Retail Sale Id 2259',41544.90,0.00,0.00,60.21,2408.40,'2022-11-14 16:27:36','',''),(2242,'1','285','1',1,'Retail Sale Id 2260',750.00,0.00,0.00,1.00,100.00,'2022-11-14 16:28:23','',''),(2243,'1','285','1',1,'Retail Sale Id 2261',1500.00,0.00,0.00,2.00,200.00,'2022-11-14 16:32:01','',''),(2244,'1','285','1',1,'Retail Sale Id 2262',7.50,0.00,0.00,0.01,1.00,'2022-11-14 17:55:51','',''),(2245,'1','285','1',1,'Return of Retail Sale Id 2254',0.00,11895.60,17.24,0.00,-689.60,'2022-11-14 17:57:10','',''),(2246,'1','285','1',1,'Retail Sale Id 2263',11895.60,0.00,0.00,17.24,689.60,'2022-11-14 18:01:52','',''),(2247,'1','285','1',1,'Retail Sale Id 2264',42310.80,0.00,0.00,61.32,2452.80,'2022-11-15 07:44:23','',''),(2248,'1','285','1',1,'Retail Sale Id 2265',24150.00,0.00,0.00,35.00,1400.00,'2022-11-15 07:44:58','',''),(2249,'1','285','1',1,'Retail Sale Id 2267',2250.00,0.00,0.00,3.00,300.00,'2022-11-15 07:45:27','',''),(2250,'1','285','1',1,'Retail Sale Id 2268',2100.00,0.00,0.00,2.80,280.00,'2022-11-15 07:46:32','',''),(2251,'1','285','1',1,'Retail Sale Id 2270',802.50,0.00,0.00,1.07,107.00,'2022-11-15 07:46:59','',''),(2252,'1','285','1',1,'Retail Sale Id 2272',997.50,0.00,0.00,1.33,133.00,'2022-11-15 07:47:30','',''),(2253,'1','285','1',1,'Retail Sale Id 2273',1500.00,0.00,0.00,2.00,200.00,'2022-11-15 07:48:10','',''),(2254,'1','285','1',1,'Retail Sale Id 2274',2250.00,0.00,0.00,3.00,300.00,'2022-11-15 07:49:15','',''),(2255,'1','285','1',1,'Retail Sale Id 2276',1500.00,0.00,0.00,2.00,200.00,'2022-11-15 07:49:44','',''),(2256,'1','285','1',1,'Retail Sale Id 2278',5250.00,0.00,0.00,7.00,700.00,'2022-11-15 07:58:17','',''),(2257,'1','285','1',1,'Retail Sale Id 2279',13800.00,0.00,0.00,20.00,800.00,'2022-11-15 08:01:37','',''),(2258,'1','285','1',1,'Retail Sale Id 2280',39744.00,0.00,0.00,57.60,2304.00,'2022-11-15 08:06:21','',''),(2259,'1','285','1',1,'Retail Sale Id 2281',1500.00,0.00,0.00,2.00,200.00,'2022-11-15 08:09:37','',''),(2260,'1','285','1',1,'Retail Sale Id 2282',2002.50,0.00,0.00,2.67,267.00,'2022-11-15 08:10:34','',''),(2261,'1','285','1',1,'Retail Sale Id 2283',43649.40,0.00,0.00,63.26,2530.40,'2022-11-15 08:12:59','',''),(2262,'1','285','1',1,'Retail Sale Id 2284',802.50,0.00,0.00,1.07,107.00,'2022-11-15 08:16:52','',''),(2263,'1','285','1',1,'Retail Sale Id 2285',802.50,0.00,0.00,1.07,107.00,'2022-11-15 08:25:27','',''),(2264,'1','285','1',1,'Retail Sale Id 2286',27600.00,0.00,0.00,40.00,1600.00,'2022-11-15 08:26:57','',''),(2265,'1','285','1',1,'Retail Sale Id 2287',1500.00,0.00,0.00,2.00,200.00,'2022-11-15 08:27:41','',''),(2266,'1','285','1',1,'Retail Sale Id 2288',1500.00,0.00,0.00,2.00,200.00,'2022-11-15 08:29:10','',''),(2267,'1','285','1',1,'Retail Sale Id 2289',2250.00,0.00,0.00,3.00,300.00,'2022-11-15 08:30:05','',''),(2268,'1','285','1',1,'Retail Sale Id 2290',2250.00,0.00,0.00,3.00,300.00,'2022-11-15 08:31:14','',''),(2269,'1','285','1',1,'Retail Sale Id 2291',16773.90,0.00,0.00,24.31,972.40,'2022-11-15 08:37:40','',''),(2270,'1','285','1',1,'Retail Sale Id 2292',997.50,0.00,0.00,1.33,133.00,'2022-11-15 08:38:37','',''),(2271,'1','285','1',1,'Retail Sale Id 2293',1500.00,0.00,0.00,2.00,200.00,'2022-11-15 08:40:15','',''),(2272,'1','285','1',1,'Retail Sale Id 2294',12426.90,0.00,0.00,18.01,720.40,'2022-11-15 08:59:58','',''),(2273,'1','285','1',1,'Retail Sale Id 2295',34500.00,0.00,0.00,50.00,2000.00,'2022-11-15 09:06:35','',''),(2274,'1','285','1',1,'Retail Sale Id 2296',8250.00,0.00,0.00,11.00,1100.00,'2022-11-15 09:07:40','',''),(2275,'1','285','1',1,'Retail Sale Id 2297',46933.80,0.00,0.00,68.02,2720.80,'2022-11-15 09:10:21','',''),(2276,'1','285','1',1,'Retail Sale Id 2300',1500.00,0.00,0.00,2.00,200.00,'2022-11-15 09:13:24','',''),(2277,'1','285','1',1,'Retail Sale Id 2301',2250.00,0.00,0.00,3.00,300.00,'2022-11-15 09:18:57','',''),(2278,'1','285','1',1,'Retail Sale Id 2302',3000.00,0.00,0.00,4.00,400.00,'2022-11-15 09:28:10','',''),(2279,'1','285','1',1,'Retail Sale Id 2303',126649.50,0.00,0.00,183.55,7342.00,'2022-11-15 09:30:15','',''),(2280,'1','285','1',1,'Retail Sale Id 2304',61913.70,0.00,0.00,89.73,3589.20,'2022-11-15 09:32:24','',''),(2281,'1','285','1',1,'Retail Sale Id 2305',21390.00,0.00,0.00,31.00,1240.00,'2022-11-15 09:35:30','',''),(2282,'1','285','1',1,'Retail Sale Id 2306',2250.00,0.00,0.00,3.00,300.00,'2022-11-15 09:38:06','',''),(2283,'1','285','1',1,'Retail Sale Id 2307',1380.00,0.00,0.00,2.00,80.00,'2022-11-15 09:48:54','',''),(2284,'1','285','1',1,'Retail Sale Id 2308',802.50,0.00,0.00,1.07,107.00,'2022-11-15 10:00:47','',''),(2285,'1','285','1',1,'Retail Sale Id 2309',802.50,0.00,0.00,1.07,107.00,'2022-11-15 10:02:12','',''),(2286,'1','285','1',1,'Retail Sale Id 2310',3000.00,0.00,0.00,4.00,400.00,'2022-11-15 10:11:17','',''),(2287,'1','285','1',1,'Retail Sale Id 2311',1500.00,0.00,0.00,2.00,200.00,'2022-11-15 10:13:58','',''),(2288,'1','285','1',1,'Retail Sale Id 2312',1500.00,0.00,0.00,2.00,200.00,'2022-11-15 10:15:48','',''),(2289,'1','285','1',1,'Retail Sale Id 2313',750.00,0.00,0.00,1.00,100.00,'2022-11-15 10:44:31','',''),(2290,'1','285','1',1,'Retail Sale Id 2314',1500.00,0.00,0.00,2.00,200.00,'2022-11-15 10:52:22','',''),(2291,'1','285','1',1,'Retail Sale Id 2315',1500.00,0.00,0.00,2.00,200.00,'2022-11-15 10:55:00','',''),(2292,'1','285','1',1,'Retail Sale Id 2316',41400.00,0.00,0.00,60.00,2400.00,'2022-11-15 11:11:00','',''),(2293,'1','285','1',1,'Retail Sale Id 2318',41248.20,0.00,0.00,59.78,2391.20,'2022-11-15 11:20:28','',''),(2294,'1','285','1',1,'Return of Retail Sale Id 2316',0.00,41400.00,60.00,0.00,-2400.00,'2022-11-15 11:25:46','',''),(2295,'1','285','1',1,'Retail Sale Id 2319',2302.50,0.00,0.00,3.07,307.00,'2022-11-15 11:33:23','',''),(2296,'1','285','1',1,'Retail Sale Id 2320',2250.00,0.00,0.00,3.00,300.00,'2022-11-15 11:40:00','',''),(2297,'1','285','1',1,'Retail Sale Id 2321',5002.50,0.00,0.00,6.67,667.00,'2022-11-15 11:45:40','',''),(2298,'1','285','1',1,'Retail Sale Id 2322',1500.00,0.00,0.00,2.00,200.00,'2022-11-15 11:48:01','',''),(2299,'1','285','1',1,'Retail Sale Id 2323',997.50,0.00,0.00,1.33,133.00,'2022-11-15 11:49:01','',''),(2300,'1','285','1',1,'Retail Sale Id 2324',20106.60,0.00,0.00,29.14,1165.60,'2022-11-15 11:53:59','',''),(2301,'1','285','1',1,'Retail Sale Id 2325',1500.00,0.00,0.00,2.00,200.00,'2022-11-15 12:17:35','',''),(2302,'1','285','1',1,'Retail Sale Id 2326',750.00,0.00,0.00,1.00,100.00,'2022-11-15 12:22:10','',''),(2303,'1','285','1',1,'Retail Sale Id 2327',32430.00,0.00,0.00,47.00,1880.00,'2022-11-15 12:39:12','',''),(2304,'1','285','1',1,'Retail Sale Id 2328',750.00,0.00,0.00,1.00,100.00,'2022-11-15 12:41:41','',''),(2305,'1','285','1',1,'Retail Sale Id 2329',1500.00,0.00,0.00,2.00,200.00,'2022-11-15 12:57:34','',''),(2306,'1','285','1',1,'Retail Sale Id 2330',4500.00,0.00,0.00,6.00,600.00,'2022-11-15 13:01:21','',''),(2307,'1','285','1',1,'Retail Sale Id 2331',750.00,0.00,0.00,1.00,100.00,'2022-11-15 13:34:51','',''),(2308,'1','285','1',1,'Retail Sale Id 2332',41400.00,0.00,0.00,60.00,2400.00,'2022-11-15 13:36:12','',''),(2309,'1','285','1',1,'Retail Sale Id 2333',1500.00,0.00,0.00,2.00,200.00,'2022-11-15 13:55:59','',''),(2310,'1','285','1',1,'Retail Sale Id 2334',2250.00,0.00,0.00,3.00,300.00,'2022-11-15 14:13:21','',''),(2311,'1','285','1',1,'Retail Sale Id 2335',3750.00,0.00,0.00,5.00,500.00,'2022-11-15 14:16:27','',''),(2312,'1','285','1',1,'Retail Sale Id 2336',802.50,0.00,0.00,1.07,107.00,'2022-11-15 14:18:03','',''),(2313,'1','285','1',1,'Retail Sale Id 2337',750.00,0.00,0.00,1.00,100.00,'2022-11-15 14:44:39','',''),(2314,'1','285','1',1,'Retail Sale Id 2338',2250.00,0.00,0.00,3.00,300.00,'2022-11-15 14:54:14','',''),(2315,'1','285','1',1,'Retail Sale Id 2339',35880.00,0.00,0.00,52.00,2080.00,'2022-11-15 15:24:55','',''),(2316,'1','285','1',1,'Retail Sale Id 2340',28697.10,0.00,0.00,41.59,1663.60,'2022-11-15 15:29:48','',''),(2317,'1','285','1',1,'Retail Sale Id 2341',40737.60,0.00,0.00,59.04,2361.60,'2022-11-15 15:34:00','',''),(2318,'1','285','1',1,'Retail Sale Id 2342',41400.00,0.00,0.00,60.00,2400.00,'2022-11-15 15:38:25','',''),(2319,'1','285','1',1,'Retail Sale Id 2343',750.00,0.00,0.00,1.00,100.00,'2022-11-15 15:48:07','',''),(2320,'1','285','1',1,'Retail Sale Id 2344',1500.00,0.00,0.00,2.00,200.00,'2022-11-15 15:55:18','',''),(2321,'1','285','1',1,'Retail Sale Id 2345',750.00,0.00,0.00,1.00,100.00,'2022-11-15 15:56:38','',''),(2322,'1','285','1',1,'Retail Sale Id 2346',802.50,0.00,0.00,1.07,107.00,'2022-11-15 15:57:26','',''),(2323,'1','285','1',1,'Retail Sale Id 2348',997.50,0.00,0.00,1.33,133.00,'2022-11-15 16:02:20','',''),(2324,'1','285','1',1,'Retail Sale Id 2350',9000.00,0.00,0.00,12.00,1200.00,'2022-11-15 16:18:00','',''),(2325,'1','285','1',1,'Retail Sale Id 2351',2250.00,0.00,0.00,3.00,300.00,'2022-11-15 16:21:04','',''),(2326,'1','285','1',1,'Retail Sale Id 2352',3000.00,0.00,0.00,4.00,400.00,'2022-11-15 16:26:00','',''),(2327,'1','285','1',1,'Retail Sale Id 2353',7500.00,0.00,0.00,10.00,1000.00,'2022-11-15 16:43:47','',''),(2328,'1','285','1',1,'Retail Sale Id 2354',9000.00,0.00,0.00,12.00,1200.00,'2022-11-15 16:45:07','',''),(2329,'1','285','1',1,'Retail Sale Id 2355',1500.00,0.00,0.00,2.00,200.00,'2022-11-15 16:48:39','',''),(2330,'1','285','1',1,'Retail Sale Id 2356',5250.00,0.00,0.00,7.00,700.00,'2022-11-15 16:50:44','',''),(2331,'1','285','1',1,'Retail Sale Id 2357',1500.00,0.00,0.00,2.00,200.00,'2022-11-15 16:52:34','',''),(2332,'1','285','1',1,'Retail Sale Id 2358',16442.70,0.00,0.00,23.83,953.20,'2022-11-15 16:57:55','',''),(2333,'1','285','1',1,'Retail Sale Id 2359',6000.00,0.00,0.00,8.00,800.00,'2022-11-15 17:02:04','',''),(2334,'1','285','1',1,'Retail Sale Id 2360',6000.00,0.00,0.00,8.00,800.00,'2022-11-15 17:02:51','',''),(2335,'1','285','1',1,'Retail Sale Id 2362',2250.00,0.00,0.00,3.00,300.00,'2022-11-15 17:04:06','',''),(2336,'1','285','1',1,'Retail Sale Id 2363',3997.50,0.00,0.00,5.33,533.00,'2022-11-15 17:09:03','',''),(2337,'1','285','1',1,'Retail Sale Id 2364',1950.00,0.00,0.00,2.60,260.00,'2022-11-15 18:34:37','',''),(2338,'1','285','1',1,'Retail Sale Id 2365',1483.50,0.00,0.00,2.15,86.00,'2022-11-15 18:37:58','',''),(2339,'1','285','1',1,'Return of Retail Sale Id 2365',0.00,1483.50,2.15,0.00,-86.00,'2022-11-15 18:43:13','',''),(2340,'1','285','1',1,'Retail Sale Id 2366',1380.00,0.00,0.00,2.00,80.00,'2022-11-15 18:44:14','',''),(2341,'1','285','1',1,'Retail Sale Id 2367',1200.00,0.00,0.00,1.60,160.00,'2022-11-16 07:13:04','',''),(2342,'1','285','1',1,'Retail Sale Id 2368',42490.20,0.00,0.00,61.58,2463.20,'2022-11-16 07:15:57','',''),(2343,'1','285','1',1,'Retail Sale Id 2369',1500.00,0.00,0.00,2.00,200.00,'2022-11-16 07:29:57','',''),(2344,'1','285','1',1,'Retail Sale Id 2370',2250.00,0.00,0.00,3.00,300.00,'2022-11-16 07:32:51','',''),(2345,'1','285','1',1,'Retail Sale Id 2371',47051.10,0.00,0.00,68.19,2727.60,'2022-11-16 07:34:21','',''),(2346,'1','285','1',1,'Retail Sale Id 2372',997.50,0.00,0.00,1.33,133.00,'2022-11-16 07:35:44','',''),(2347,'1','285','1',1,'Retail Sale Id 2373',42124.50,0.00,0.00,61.05,2442.00,'2022-11-16 07:37:02','',''),(2348,'1','285','1',1,'Retail Sale Id 2374',2002.50,0.00,0.00,2.67,267.00,'2022-11-16 07:41:12','',''),(2349,'1','285','1',1,'Retail Sale Id 2375',2250.00,0.00,0.00,3.00,300.00,'2022-11-16 07:44:12','',''),(2350,'1','285','1',1,'Retail Sale Id 2376',34500.00,0.00,0.00,50.00,2000.00,'2022-11-16 07:54:43','',''),(2351,'1','285','1',1,'Retail Sale Id 2377',3000.00,0.00,0.00,4.00,400.00,'2022-11-16 08:00:34','',''),(2352,'1','285','1',1,'Retail Sale Id 2378',750.00,0.00,0.00,1.00,100.00,'2022-11-16 08:07:41','',''),(2353,'1','285','1',1,'Retail Sale Id 2379',3000.00,0.00,0.00,4.00,400.00,'2022-11-16 08:28:14','',''),(2354,'1','285','1',1,'Retail Sale Id 2380',1500.00,0.00,0.00,2.00,200.00,'2022-11-16 08:40:37','',''),(2355,'1','285','1',1,'Retail Sale Id 2381',9929.10,0.00,0.00,14.39,575.60,'2022-11-16 08:44:46','',''),(2356,'1','285','1',1,'Retail Sale Id 2382',1500.00,0.00,0.00,2.00,200.00,'2022-11-16 08:52:43','',''),(2357,'1','285','1',1,'Retail Sale Id 2383',2002.50,0.00,0.00,2.67,267.00,'2022-11-16 08:56:04','',''),(2358,'1','285','1',1,'Retail Sale Id 2384',1500.00,0.00,0.00,2.00,200.00,'2022-11-16 09:15:28','',''),(2359,'1','285','1',1,'Retail Sale Id 2385',34500.00,0.00,0.00,50.00,2000.00,'2022-11-16 09:22:01','',''),(2360,'1','285','1',1,'Retail Sale Id 2386',3000.00,0.00,0.00,4.00,400.00,'2022-11-16 09:29:59','',''),(2361,'1','285','1',1,'Retail Sale Id 2387',1500.00,0.00,0.00,2.00,200.00,'2022-11-16 09:31:04','',''),(2362,'1','285','1',1,'Retail Sale Id 2388',3000.00,0.00,0.00,4.00,400.00,'2022-11-16 09:32:32','',''),(2363,'1','285','1',1,'Retail Sale Id 2389',1500.00,0.00,0.00,2.00,200.00,'2022-11-16 09:33:23','',''),(2364,'1','285','1',1,'Retail Sale Id 2390',3750.00,0.00,0.00,5.00,500.00,'2022-11-16 09:37:05','',''),(2365,'1','285','1',1,'Retail Sale Id 2391',3000.00,0.00,0.00,4.00,400.00,'2022-11-16 09:38:20','',''),(2366,'1','285','1',1,'Retail Sale Id 2392',3802.50,0.00,0.00,5.07,507.00,'2022-11-16 09:52:38','',''),(2367,'1','285','1',1,'Retail Sale Id 2393',43635.60,0.00,0.00,63.24,2529.60,'2022-11-16 10:01:37','',''),(2368,'1','285','1',1,'Retail Sale Id 2394',1500.00,0.00,0.00,2.00,200.00,'2022-11-16 10:04:04','',''),(2369,'1','285','1',1,'Retail Sale Id 2395',2250.00,0.00,0.00,3.00,300.00,'2022-11-16 10:21:19','',''),(2370,'1','285','1',1,'Retail Sale Id 2396',1500.00,0.00,0.00,2.00,200.00,'2022-11-16 10:45:50','',''),(2371,'1','285','1',1,'Retail Sale Id 2397',3750.00,0.00,0.00,5.00,500.00,'2022-11-16 10:49:03','',''),(2372,'1','285','1',1,'Retail Sale Id 2398',1500.00,0.00,0.00,2.00,200.00,'2022-11-16 10:50:26','',''),(2373,'1','285','1',1,'Retail Sale Id 2399',1500.00,0.00,0.00,2.00,200.00,'2022-11-16 10:51:31','',''),(2374,'1','285','1',1,'Retail Sale Id 2400',2250.00,0.00,0.00,3.00,300.00,'2022-11-16 10:52:31','',''),(2375,'1','285','1',1,'Retail Sale Id 2401',750.00,0.00,0.00,1.00,100.00,'2022-11-16 10:56:15','',''),(2376,'1','285','1',1,'Retail Sale Id 2402',41400.00,0.00,0.00,60.00,2400.00,'2022-11-16 11:06:30','',''),(2377,'1','285','1',1,'Retail Sale Id 2403',1500.00,0.00,0.00,2.00,200.00,'2022-11-16 11:11:28','',''),(2378,'1','285','1',1,'Retail Sale Id 2404',1500.00,0.00,0.00,2.00,200.00,'2022-11-16 11:17:17','',''),(2379,'1','285','1',1,'Retail Sale Id 2405',2250.00,0.00,0.00,3.00,300.00,'2022-11-16 11:38:07','',''),(2380,'1','285','1',1,'Retail Sale Id 2406',3000.00,0.00,0.00,4.00,400.00,'2022-11-16 11:38:46','',''),(2381,'1','285','1',1,'Retail Sale Id 2407',1500.00,0.00,0.00,2.00,200.00,'2022-11-16 11:40:30','',''),(2382,'1','285','1',1,'Retail Sale Id 2408',10612.20,0.00,0.00,15.38,615.20,'2022-11-16 11:46:21','',''),(2383,'1','285','1',1,'Retail Sale Id 2409',5250.00,0.00,0.00,7.00,700.00,'2022-11-16 11:49:53','',''),(2384,'1','285','1',1,'Retail Sale Id 2410',46575.00,0.00,0.00,67.50,2700.00,'2022-11-16 12:01:22','',''),(2385,'1','285','1',1,'Retail Sale Id 2411',997.50,0.00,0.00,1.33,133.00,'2022-11-16 12:08:31','',''),(2386,'1','285','1',1,'Retail Sale Id 2412',1500.00,0.00,0.00,2.00,200.00,'2022-11-16 12:15:57','',''),(2387,'1','285','1',1,'Retail Sale Id 2413',2250.00,0.00,0.00,3.00,300.00,'2022-11-16 12:32:10','',''),(2388,'1','285','1',1,'Retail Sale Id 2414',2250.00,0.00,0.00,3.00,300.00,'2022-11-16 12:39:45','',''),(2389,'1','285','1',1,'Retail Sale Id 2415',5250.00,0.00,0.00,7.00,700.00,'2022-11-16 12:55:21','',''),(2390,'1','285','1',1,'Retail Sale Id 2416',802.50,0.00,0.00,1.07,107.00,'2022-11-16 13:05:03','',''),(2391,'1','285','1',1,'Retail Sale Id 2417',1500.00,0.00,0.00,2.00,200.00,'2022-11-16 13:06:54','',''),(2392,'1','285','1',1,'Retail Sale Id 2418',750.00,0.00,0.00,1.00,100.00,'2022-11-16 13:11:28','',''),(2393,'1','285','1',1,'Retail Sale Id 2419',41958.90,0.00,0.00,60.81,2432.40,'2022-11-16 13:18:20','',''),(2394,'1','285','1',1,'Retail Sale Id 2420',2250.00,0.00,0.00,3.00,300.00,'2022-11-16 13:40:00','',''),(2395,'1','285','1',1,'Retail Sale Id 2421',11736.90,0.00,0.00,17.01,680.40,'2022-11-16 15:44:47','',''),(2396,'1','285','1',1,'Retail Sale Id 2422',42090.00,0.00,0.00,61.00,2440.00,'2022-11-16 15:47:09','',''),(2397,'1','285','1',1,'Retail Sale Id 2423',750.00,0.00,0.00,1.00,100.00,'2022-11-16 15:53:04','',''),(2398,'1','285','1',1,'Retail Sale Id 2424',3000.00,0.00,0.00,4.00,400.00,'2022-11-16 15:53:56','',''),(2399,'1','285','1',1,'Retail Sale Id 2425',1995.00,0.00,0.00,2.66,266.00,'2022-11-16 15:54:49','',''),(2400,'1','285','1',1,'Retail Sale Id 2426',3000.00,0.00,0.00,4.00,400.00,'2022-11-16 15:55:41','',''),(2401,'1','285','1',1,'Retail Sale Id 2427',1500.00,0.00,0.00,2.00,200.00,'2022-11-16 15:56:34','',''),(2402,'1','285','1',1,'Retail Sale Id 2428',1500.00,0.00,0.00,2.00,200.00,'2022-11-16 15:57:13','',''),(2403,'1','285','1',1,'Retail Sale Id 2429',750.00,0.00,0.00,1.00,100.00,'2022-11-16 15:57:54','',''),(2404,'1','285','1',1,'Retail Sale Id 2430',4500.00,0.00,0.00,6.00,600.00,'2022-11-16 15:58:35','',''),(2405,'1','285','1',1,'Retail Sale Id 2431',3000.00,0.00,0.00,4.00,400.00,'2022-11-16 15:59:14','',''),(2406,'1','285','1',1,'Retail Sale Id 2432',3750.00,0.00,0.00,5.00,500.00,'2022-11-16 15:59:55','',''),(2407,'1','285','1',1,'Retail Sale Id 2433',1500.00,0.00,0.00,2.00,200.00,'2022-11-16 16:16:46','',''),(2408,'1','285','1',1,'Retail Sale Id 2434',2250.00,0.00,0.00,3.00,300.00,'2022-11-16 16:20:05','',''),(2409,'1','285','1',1,'Retail Sale Id 2435',11943.90,0.00,0.00,17.31,692.40,'2022-11-16 16:21:44','',''),(2410,'1','285','1',1,'Retail Sale Id 2436',52212.30,0.00,0.00,75.67,3026.80,'2022-11-16 16:26:51','',''),(2411,'1','285','1',1,'Return of Retail Sale Id 2395',0.00,2250.00,3.00,0.00,-300.00,'2022-11-16 16:28:39','',''),(2412,'1','285','1',1,'Retail Sale Id 2437',1500.00,0.00,0.00,2.00,200.00,'2022-11-16 16:34:39','',''),(2413,'1','285','1',1,'Return of Retail Sale Id 2415',0.00,5250.00,7.00,0.00,-700.00,'2022-11-16 16:43:18','',''),(2414,'1','285','1',1,'Return of Retail Sale Id 2429',0.00,750.00,1.00,0.00,-100.00,'2022-11-16 16:43:56','',''),(2415,'1','285','1',1,'Retail Sale Id 2438',56573.10,0.00,0.00,81.99,3279.60,'2022-11-16 16:53:48','',''),(2416,'1','285','1',1,'Retail Sale Id 2439',750.00,0.00,0.00,1.00,100.00,'2022-11-16 17:49:31','',''),(2417,'1','285','1',1,'Return of Retail Sale Id 2439',0.00,750.00,1.00,0.00,-100.00,'2022-11-16 17:50:28','',''),(2418,'1','285','1',1,'Retail Sale Id 2440',75.00,0.00,0.00,0.10,10.00,'2022-11-16 17:51:31','',''),(2419,'1','285','1',1,'Return of Retail Sale Id 2435',0.00,11943.90,17.31,0.00,-692.40,'2022-11-16 17:54:00','',''),(2420,'1','285','1',1,'Retail Sale Id 2441',11895.60,0.00,0.00,17.24,689.60,'2022-11-16 17:55:33','',''),(2421,'1','285','1',1,'Retail Sale Id 2442',3000.00,0.00,0.00,4.00,400.00,'2022-11-19 08:58:54','',''),(2422,'1','285','1',1,'Retail Sale Id 2443',750.00,0.00,0.00,1.00,100.00,'2022-11-19 08:59:44','',''),(2423,'1','285','1',1,'Retail Sale Id 2444',27600.00,0.00,0.00,40.00,1600.00,'2022-11-19 09:00:50','',''),(2424,'1','285','1',1,'Retail Sale Id 2445',23059.80,0.00,0.00,33.42,1336.80,'2022-11-19 09:01:20','',''),(2425,'1','285','1',1,'Retail Sale Id 2446',33120.00,0.00,0.00,48.00,1920.00,'2022-11-19 09:01:45','',''),(2426,'1','285','1',1,'Retail Sale Id 2447',34500.00,0.00,0.00,50.00,2000.00,'2022-11-19 09:02:14','',''),(2427,'1','285','1',1,'Retail Sale Id 2448',2250.00,0.00,0.00,3.00,300.00,'2022-11-19 09:02:52','',''),(2428,'1','285','1',1,'Retail Sale Id 2449',1500.00,0.00,0.00,2.00,200.00,'2022-11-19 09:03:58','',''),(2429,'1','285','1',1,'Retail Sale Id 2450',3000.00,0.00,0.00,4.00,400.00,'2022-11-19 09:05:25','',''),(2430,'1','285','1',1,'Retail Sale Id 2451',5250.00,0.00,0.00,7.00,700.00,'2022-11-19 09:06:13','',''),(2431,'1','285','1',1,'Retail Sale Id 2452',1500.00,0.00,0.00,2.00,200.00,'2022-11-19 09:07:34','',''),(2432,'1','285','1',1,'Retail Sale Id 2453',1500.00,0.00,0.00,2.00,200.00,'2022-11-19 09:10:55','',''),(2433,'1','285','1',1,'Retail Sale Id 2454',2250.00,0.00,0.00,3.00,300.00,'2022-11-19 09:11:54','',''),(2434,'1','285','1',1,'Retail Sale Id 2455',49852.50,0.00,0.00,72.25,2890.00,'2022-11-19 09:16:07','',''),(2435,'1','285','1',1,'Retail Sale Id 2456',5625.00,0.00,0.00,7.50,750.00,'2022-11-19 09:21:33','',''),(2436,'1','285','1',1,'Retail Sale Id 2457',997.50,0.00,0.00,1.33,133.00,'2022-11-19 09:31:10','',''),(2437,'1','285','1',1,'Retail Sale Id 2458',1500.00,0.00,0.00,2.00,200.00,'2022-11-19 09:31:56','',''),(2438,'1','285','1',1,'Retail Sale Id 2459',750.00,0.00,0.00,1.00,100.00,'2022-11-19 09:32:53','',''),(2439,'1','285','1',1,'Retail Sale Id 2460',5025.00,0.00,0.00,6.70,670.00,'2022-11-19 09:34:30','',''),(2440,'1','285','1',1,'Retail Sale Id 2461',750.00,0.00,0.00,1.00,100.00,'2022-11-19 09:36:21','',''),(2441,'1','285','1',1,'Retail Sale Id 2462',1500.00,0.00,0.00,2.00,200.00,'2022-11-19 09:37:16','',''),(2442,'1','285','1',1,'Retail Sale Id 2463',750.00,0.00,0.00,1.00,100.00,'2022-11-19 09:38:41','',''),(2443,'1','285','1',1,'Retail Sale Id 2464',2250.00,0.00,0.00,3.00,300.00,'2022-11-19 09:39:25','',''),(2444,'1','285','1',1,'Retail Sale Id 2465',802.50,0.00,0.00,1.07,107.00,'2022-11-19 09:40:22','',''),(2445,'1','285','1',1,'Retail Sale Id 2466',1500.00,0.00,0.00,2.00,200.00,'2022-11-19 09:41:31','',''),(2446,'1','285','1',1,'Retail Sale Id 2467',802.50,0.00,0.00,1.07,107.00,'2022-11-19 09:42:21','',''),(2447,'1','285','1',1,'Retail Sale Id 2468',1500.00,0.00,0.00,2.00,200.00,'2022-11-19 09:43:17','',''),(2448,'1','285','1',1,'Retail Sale Id 2469',3000.00,0.00,0.00,4.00,400.00,'2022-11-19 09:44:01','',''),(2449,'1','285','1',1,'Retail Sale Id 2470',1500.00,0.00,0.00,2.00,200.00,'2022-11-19 09:44:40','',''),(2450,'1','285','1',1,'Retail Sale Id 2471',1500.00,0.00,0.00,2.00,200.00,'2022-11-19 09:45:19','',''),(2451,'1','285','1',1,'Retail Sale Id 2472',1995.00,0.00,0.00,2.66,266.00,'2022-11-19 09:46:29','',''),(2452,'1','285','1',1,'Retail Sale Id 2473',997.50,0.00,0.00,1.33,133.00,'2022-11-19 09:47:25','',''),(2453,'1','285','1',1,'Retail Sale Id 2474',1500.00,0.00,0.00,2.00,200.00,'2022-11-19 09:48:46','',''),(2454,'1','285','1',1,'Retail Sale Id 2475',1500.00,0.00,0.00,2.00,200.00,'2022-11-19 09:49:38','',''),(2455,'1','285','1',1,'Retail Sale Id 2476',750.00,0.00,0.00,1.00,100.00,'2022-11-19 09:50:30','',''),(2456,'1','285','1',1,'Retail Sale Id 2477',750.00,0.00,0.00,1.00,100.00,'2022-11-19 09:51:11','',''),(2457,'1','285','1',1,'Retail Sale Id 2478',1500.00,0.00,0.00,2.00,200.00,'2022-11-19 09:51:56','',''),(2458,'1','285','1',1,'Retail Sale Id 2479',2250.00,0.00,0.00,3.00,300.00,'2022-11-19 09:52:41','',''),(2459,'1','285','1',1,'Retail Sale Id 2480',1500.00,0.00,0.00,2.00,200.00,'2022-11-19 09:54:11','',''),(2460,'1','285','1',1,'Return of Retail Sale Id 2460',0.00,5025.00,6.70,0.00,-670.00,'2022-11-19 10:04:59','',''),(2461,'1','285','1',1,'Retail Sale Id 2481',2250.00,0.00,0.00,3.00,300.00,'2022-11-19 10:08:25','',''),(2462,'1','285','1',1,'Retail Sale Id 2482',3000.00,0.00,0.00,4.00,400.00,'2022-11-19 10:11:16','',''),(2463,'1','285','1',1,'Retail Sale Id 2483',1500.00,0.00,0.00,2.00,200.00,'2022-11-19 10:15:17','',''),(2464,'1','285','1',1,'Retail Sale Id 2484',41965.80,0.00,0.00,60.82,2432.80,'2022-11-19 10:29:05','',''),(2465,'1','285','1',1,'Retail Sale Id 2485',2002.50,0.00,0.00,2.67,267.00,'2022-11-19 10:35:43','',''),(2466,'1','285','1',1,'Retail Sale Id 2486',1500.00,0.00,0.00,2.00,200.00,'2022-11-19 10:44:02','',''),(2467,'1','285','1',1,'Retail Sale Id 2487',34500.00,0.00,0.00,50.00,2000.00,'2022-11-19 10:51:49','',''),(2468,'1','285','1',1,'Retail Sale Id 2488',41400.00,0.00,0.00,60.00,2400.00,'2022-11-19 11:14:56','',''),(2469,'1','285','1',1,'Retail Sale Id 2489',750.00,0.00,0.00,1.00,100.00,'2022-11-19 11:19:36','',''),(2470,'1','285','1',1,'Retail Sale Id 2490',3000.00,0.00,0.00,4.00,400.00,'2022-11-19 11:20:18','',''),(2471,'1','285','1',1,'Retail Sale Id 2491',2250.00,0.00,0.00,3.00,300.00,'2022-11-19 11:29:49','',''),(2472,'1','285','1',1,'Retail Sale Id 2492',2002.50,0.00,0.00,2.67,267.00,'2022-11-19 11:38:23','',''),(2473,'1','285','1',1,'Retail Sale Id 2493',997.50,0.00,0.00,1.33,133.00,'2022-11-19 11:39:32','',''),(2474,'1','285','1',1,'Retail Sale Id 2494',750.00,0.00,0.00,1.00,100.00,'2022-11-19 11:47:13','',''),(2475,'1','285','1',1,'Retail Sale Id 2495',16746.30,0.00,0.00,24.27,970.80,'2022-11-19 12:05:02','',''),(2476,'1','285','1',1,'Retail Sale Id 2496',40710.00,0.00,0.00,59.00,2360.00,'2022-11-19 12:06:31','',''),(2477,'1','285','1',1,'Retail Sale Id 2497',997.50,0.00,0.00,1.33,133.00,'2022-11-19 12:19:13','',''),(2478,'1','285','1',1,'Retail Sale Id 2498',1500.00,0.00,0.00,2.00,200.00,'2022-11-19 12:20:56','',''),(2479,'1','285','1',1,'Retail Sale Id 2499',1500.00,0.00,0.00,2.00,200.00,'2022-11-19 12:26:04','',''),(2480,'1','285','1',1,'Retail Sale Id 2500',1500.00,0.00,0.00,2.00,200.00,'2022-11-19 12:27:07','',''),(2481,'1','285','1',1,'Retail Sale Id 2501',1500.00,0.00,0.00,2.00,200.00,'2022-11-19 12:35:28','',''),(2482,'1','285','1',1,'Retail Sale Id 2502',1500.00,0.00,0.00,2.00,200.00,'2022-11-19 12:51:29','',''),(2483,'1','285','1',1,'Retail Sale Id 2503',1500.00,0.00,0.00,2.00,200.00,'2022-11-19 12:52:14','',''),(2484,'1','285','1',1,'Retail Sale Id 2504',2250.00,0.00,0.00,3.00,300.00,'2022-11-19 12:55:13','',''),(2485,'1','285','1',1,'Retail Sale Id 2505',802.50,0.00,0.00,1.07,107.00,'2022-11-19 13:26:30','',''),(2486,'1','285','1',1,'Retail Sale Id 2506',40827.30,0.00,0.00,59.17,2366.80,'2022-11-19 13:36:38','',''),(2487,'1','285','1',1,'Retail Sale Id 2507',3000.00,0.00,0.00,4.00,400.00,'2022-11-19 13:44:48','',''),(2488,'1','285','1',1,'Retail Sale Id 2508',750.00,0.00,0.00,1.00,100.00,'2022-11-19 13:55:03','',''),(2489,'1','285','1',1,'Retail Sale Id 2509',750.00,0.00,0.00,1.00,100.00,'2022-11-19 14:03:25','',''),(2490,'1','285','1',1,'Retail Sale Id 2510',2250.00,0.00,0.00,3.00,300.00,'2022-11-19 14:04:26','',''),(2491,'1','285','1',1,'Retail Sale Id 2511',35880.00,0.00,0.00,52.00,2080.00,'2022-11-19 14:15:14','',''),(2492,'1','285','1',1,'Retail Sale Id 2512',2250.00,0.00,0.00,3.00,300.00,'2022-11-19 14:59:44','',''),(2493,'1','285','1',1,'Retail Sale Id 2513',1500.00,0.00,0.00,2.00,200.00,'2022-11-19 15:16:33','',''),(2494,'1','285','1',1,'Retail Sale Id 2514',1447.50,0.00,0.00,1.93,193.00,'2022-11-19 15:18:25','',''),(2495,'1','285','1',1,'Retail Sale Id 2515',44884.50,0.00,0.00,65.05,2602.00,'2022-11-19 15:25:24','',''),(2496,'1','285','1',1,'Retail Sale Id 2516',3000.00,0.00,0.00,4.00,400.00,'2022-11-19 15:31:51','',''),(2497,'1','285','1',1,'Retail Sale Id 2517',43739.10,0.00,0.00,63.39,2535.60,'2022-11-19 15:37:48','',''),(2498,'1','285','1',1,'Retail Sale Id 2518',42842.10,0.00,0.00,62.09,2483.60,'2022-11-19 15:41:38','',''),(2499,'1','285','1',1,'Retail Sale Id 2519',750.00,0.00,0.00,1.00,100.00,'2022-11-19 15:49:29','',''),(2500,'1','285','1',1,'Retail Sale Id 2520',40951.50,0.00,0.00,59.35,2374.00,'2022-11-19 16:06:12','',''),(2501,'1','285','1',1,'Retail Sale Id 2521',41400.00,0.00,0.00,60.00,2400.00,'2022-11-19 16:10:40','',''),(2502,'1','285','1',1,'Retail Sale Id 2522',802.50,0.00,0.00,1.07,107.00,'2022-11-19 16:20:11','',''),(2503,'1','285','1',1,'Retail Sale Id 2523',1500.00,0.00,0.00,2.00,200.00,'2022-11-19 16:22:46','',''),(2504,'1','285','1',1,'Retail Sale Id 2524',3000.00,0.00,0.00,4.00,400.00,'2022-11-19 16:23:52','',''),(2505,'1','285','1',1,'Retail Sale Id 2525',750.00,0.00,0.00,1.00,100.00,'2022-11-19 16:28:01','',''),(2506,'1','285','1',1,'Retail Sale Id 2526',1500.00,0.00,0.00,2.00,200.00,'2022-11-19 16:29:43','',''),(2507,'1','285','1',1,'Retail Sale Id 2527',1500.00,0.00,0.00,2.00,200.00,'2022-11-19 16:32:45','',''),(2508,'1','285','1',1,'Retail Sale Id 2528',20700.00,0.00,0.00,30.00,1200.00,'2022-11-19 16:34:08','',''),(2509,'1','285','1',1,'Retail Sale Id 2529',1500.00,0.00,0.00,2.00,200.00,'2022-11-19 16:35:05','',''),(2510,'1','285','1',1,'Retail Sale Id 2530',39123.00,0.00,0.00,56.70,2268.00,'2022-11-19 16:36:30','',''),(2511,'1','285','1',1,'Retail Sale Id 2531',1380.00,0.00,0.00,2.00,80.00,'2022-11-19 16:40:44','',''),(2512,'1','285','1',1,'Retail Sale Id 2532',22080.00,0.00,0.00,32.00,1280.00,'2022-11-19 16:42:43','',''),(2513,'1','285','1',1,'Retail Sale Id 2533',2250.00,0.00,0.00,3.00,300.00,'2022-11-19 16:47:22','',''),(2514,'1','285','1',1,'Retail Sale Id 2534',2250.00,0.00,0.00,3.00,300.00,'2022-11-19 16:49:44','',''),(2515,'1','285','1',1,'Retail Sale Id 2535',11909.40,0.00,0.00,17.26,690.40,'2022-11-19 16:52:09','',''),(2516,'1','285','1',1,'Retail Sale Id 2536',4492.50,0.00,0.00,5.99,599.00,'2022-11-19 16:59:42','',''),(2517,'1','285','1',1,'Return of Retail Sale Id 2499',0.00,1500.00,2.00,0.00,-200.00,'2022-11-19 17:06:55','',''),(2518,'1','285','1',1,'Return of Retail Sale Id 2531',0.00,1380.00,2.00,0.00,-80.00,'2022-11-19 17:10:25','',''),(2519,'1','285','1',1,'Retail Sale Id 2537',855.60,0.00,0.00,1.24,49.60,'2022-11-19 17:11:35','',''),(2520,'1','285','1',1,'Return of Retail Sale Id 2482',0.00,3000.00,4.00,0.00,-400.00,'2022-11-19 17:12:48','',''),(2521,'1','285','1',1,'Retail Sale Id 2538',46457.60,0.00,0.00,68.32,2049.60,'2022-11-20 07:38:47','',''),(2522,'1','285','1',1,'Retail Sale Id 2539',3997.50,0.00,0.00,5.33,533.00,'2022-11-20 07:39:44','',''),(2523,'1','285','1',1,'Retail Sale Id 2540',1500.00,0.00,0.00,2.00,200.00,'2022-11-20 07:40:19','',''),(2524,'1','285','1',1,'Retail Sale Id 2541',900.00,0.00,0.00,1.20,120.00,'2022-11-20 07:41:13','',''),(2525,'1','285','1',1,'Retail Sale Id 2542',3750.00,0.00,0.00,5.00,500.00,'2022-11-20 07:42:38','',''),(2526,'1','285','1',1,'Retail Sale Id 2543',42030.80,0.00,0.00,61.81,1854.30,'2022-11-20 07:43:24','',''),(2527,'1','285','1',1,'Retail Sale Id 2544',4500.00,0.00,0.00,6.00,600.00,'2022-11-20 07:44:48','',''),(2528,'1','285','1',1,'Retail Sale Id 2545',6000.00,0.00,0.00,8.00,800.00,'2022-11-20 07:47:17','',''),(2529,'1','285','1',1,'Retail Sale Id 2546',802.50,0.00,0.00,1.07,107.00,'2022-11-20 07:47:57','',''),(2530,'1','285','1',1,'Retail Sale Id 2547',27200.00,0.00,0.00,40.00,1200.00,'2022-11-20 07:49:34','',''),(2531,'1','285','1',1,'Retail Sale Id 2548',3000.00,0.00,0.00,4.00,400.00,'2022-11-20 07:52:29','',''),(2532,'1','285','1',1,'Retail Sale Id 2549',1500.00,0.00,0.00,2.00,200.00,'2022-11-20 07:57:06','',''),(2533,'1','285','1',1,'Retail Sale Id 2550',16707.60,0.00,0.00,24.57,737.10,'2022-11-20 07:59:51','',''),(2534,'1','285','1',1,'Retail Sale Id 2551',802.50,0.00,0.00,1.07,107.00,'2022-11-20 08:00:58','',''),(2535,'1','285','1',1,'Retail Sale Id 2552',1500.00,0.00,0.00,2.00,200.00,'2022-11-20 08:01:28','',''),(2536,'1','285','1',1,'Retail Sale Id 2554',750.00,0.00,0.00,1.00,100.00,'2022-11-20 08:15:19','',''),(2537,'1','285','1',1,'Retail Sale Id 2555',1500.00,0.00,0.00,2.00,200.00,'2022-11-20 08:15:55','',''),(2538,'1','285','1',1,'Retail Sale Id 2556',40269.60,0.00,0.00,59.22,1776.60,'2022-11-20 08:22:27','',''),(2539,'1','285','1',1,'Retail Sale Id 2557',802.50,0.00,0.00,1.07,107.00,'2022-11-20 08:33:35','',''),(2540,'1','285','1',1,'Retail Sale Id 2558',27200.00,0.00,0.00,40.00,1200.00,'2022-11-20 08:35:33','',''),(2541,'1','285','1',1,'Retail Sale Id 2559',1500.00,0.00,0.00,2.00,200.00,'2022-11-20 08:37:16','',''),(2542,'1','285','1',1,'Retail Sale Id 2560',1500.00,0.00,0.00,2.00,200.00,'2022-11-20 08:41:27','',''),(2543,'1','285','1',1,'Retail Sale Id 2561',34000.00,0.00,0.00,50.00,1500.00,'2022-11-20 08:53:31','',''),(2544,'1','285','1',1,'Retail Sale Id 2562',750.00,0.00,0.00,1.00,100.00,'2022-11-20 09:21:45','',''),(2545,'1','285','1',1,'Retail Sale Id 2563',802.50,0.00,0.00,1.07,107.00,'2022-11-20 09:28:17','',''),(2546,'1','285','1',1,'Retail Sale Id 2564',1500.00,0.00,0.00,2.00,200.00,'2022-11-20 09:31:27','',''),(2547,'1','285','1',1,'Retail Sale Id 2565',2250.00,0.00,0.00,3.00,300.00,'2022-11-20 09:32:15','',''),(2548,'1','285','1',1,'Retail Sale Id 2566',802.50,0.00,0.00,1.07,107.00,'2022-11-20 09:39:08','',''),(2549,'1','285','1',1,'Retail Sale Id 2567',4500.00,0.00,0.00,6.00,600.00,'2022-11-20 09:40:45','',''),(2550,'1','285','1',1,'Retail Sale Id 2568',997.50,0.00,0.00,1.33,133.00,'2022-11-20 09:41:31','',''),(2551,'1','285','1',1,'Retail Sale Id 2569',2250.00,0.00,0.00,3.00,300.00,'2022-11-20 10:02:19','',''),(2552,'1','285','1',1,'Retail Sale Id 2570',750.00,0.00,0.00,1.00,100.00,'2022-11-20 10:17:36','',''),(2553,'1','285','1',1,'Retail Sale Id 2571',802.50,0.00,0.00,1.07,107.00,'2022-11-20 10:18:44','',''),(2554,'1','285','1',1,'Retail Sale Id 2572',600000.00,0.00,0.00,800.00,80000.00,'2022-11-20 10:25:42','',''),(2555,'1','285','1',1,'Return of Retail Sale Id 2572',0.00,600000.00,800.00,0.00,-80000.00,'2022-11-20 10:29:32','',''),(2556,'1','285','1',1,'Retail Sale Id 2573',802.50,0.00,0.00,1.07,107.00,'2022-11-20 10:30:19','',''),(2557,'1','285','1',1,'Retail Sale Id 2574',997.50,0.00,0.00,1.33,133.00,'2022-11-20 10:33:52','',''),(2558,'1','285','1',1,'Retail Sale Id 2575',997.50,0.00,0.00,1.33,133.00,'2022-11-20 10:34:44','',''),(2559,'1','285','1',1,'Retail Sale Id 2576',2250.00,0.00,0.00,3.00,300.00,'2022-11-20 10:35:20','',''),(2560,'1','285','1',1,'Retail Sale Id 2577',3000.00,0.00,0.00,4.00,400.00,'2022-11-20 10:42:37','',''),(2561,'1','285','1',1,'Retail Sale Id 2578',997.50,0.00,0.00,1.33,133.00,'2022-11-20 10:46:45','',''),(2562,'1','285','1',1,'Retail Sale Id 2579',1500.00,0.00,0.00,2.00,200.00,'2022-11-20 11:00:29','',''),(2563,'1','285','1',1,'Retail Sale Id 2580',45675.60,0.00,0.00,67.17,2015.10,'2022-11-20 11:07:46','',''),(2564,'1','285','1',1,'Retail Sale Id 2581',2002.50,0.00,0.00,2.67,267.00,'2022-11-20 11:23:16','',''),(2565,'1','285','1',1,'Retail Sale Id 2582',2250.00,0.00,0.00,3.00,300.00,'2022-11-20 11:56:41','',''),(2566,'1','285','1',1,'Retail Sale Id 2583',1500.00,0.00,0.00,2.00,200.00,'2022-11-20 11:57:40','',''),(2567,'1','285','1',1,'Retail Sale Id 2584',41255.60,0.00,0.00,60.67,1820.10,'2022-11-20 12:11:42','',''),(2568,'1','285','1',1,'Retail Sale Id 2585',2250.00,0.00,0.00,3.00,300.00,'2022-11-20 12:49:10','',''),(2569,'1','285','1',1,'Retail Sale Id 2586',750.00,0.00,0.00,1.00,100.00,'2022-11-20 12:51:22','',''),(2570,'1','285','1',1,'Retail Sale Id 2587',1500.00,0.00,0.00,2.00,200.00,'2022-11-20 13:26:14','',''),(2571,'1','285','1',1,'Retail Sale Id 2588',750.00,0.00,0.00,1.00,100.00,'2022-11-20 13:45:37','',''),(2572,'1','285','1',1,'Retail Sale Id 2589',11811.60,0.00,0.00,17.37,521.10,'2022-11-20 14:18:54','',''),(2573,'1','285','1',1,'Retail Sale Id 2590',997.50,0.00,0.00,1.33,133.00,'2022-11-20 14:19:42','',''),(2574,'1','285','1',1,'Retail Sale Id 2592',2250.00,0.00,0.00,3.00,300.00,'2022-11-20 14:23:38','',''),(2575,'1','285','1',1,'Retail Sale Id 2593',1500.00,0.00,0.00,2.00,200.00,'2022-11-20 14:39:05','',''),(2576,'1','285','1',1,'Retail Sale Id 2594',40800.00,0.00,0.00,60.00,1800.00,'2022-11-20 14:40:04','',''),(2577,'1','285','1',1,'Retail Sale Id 2595',1500.00,0.00,0.00,2.00,200.00,'2022-11-20 14:44:14','',''),(2578,'1','285','1',1,'Return of Retail Sale Id 2594',0.00,40800.00,60.00,0.00,-1800.00,'2022-11-20 14:49:41','',''),(2579,'1','285','1',1,'Retail Sale Id 2596',40392.00,0.00,0.00,59.40,1782.00,'2022-11-20 14:50:23','',''),(2580,'1','285','1',1,'Retail Sale Id 2597',1500.00,0.00,0.00,2.00,200.00,'2022-11-20 14:51:35','',''),(2581,'1','285','1',1,'Retail Sale Id 2598',3000.00,0.00,0.00,4.00,400.00,'2022-11-20 14:52:28','',''),(2582,'1','285','1',1,'Retail Sale Id 2599',997.50,0.00,0.00,1.33,133.00,'2022-11-20 15:02:19','',''),(2583,'1','285','1',1,'Retail Sale Id 2600',65932.80,0.00,0.00,96.96,2908.80,'2022-11-20 15:04:16','',''),(2584,'1','285','1',1,'Retail Sale Id 2601',1500.00,0.00,0.00,2.00,200.00,'2022-11-20 15:07:37','',''),(2585,'1','285','1',1,'Retail Sale Id 2602',3000.00,0.00,0.00,4.00,400.00,'2022-11-20 15:11:07','',''),(2586,'1','285','1',1,'Retail Sale Id 2603',1800.00,0.00,0.00,2.40,240.00,'2022-11-20 15:16:51','',''),(2587,'1','285','1',1,'Retail Sale Id 2604',1500.00,0.00,0.00,2.00,200.00,'2022-11-20 15:22:05','',''),(2588,'1','285','1',1,'Retail Sale Id 2605',1500.00,0.00,0.00,2.00,200.00,'2022-11-20 15:30:22','',''),(2589,'1','285','1',1,'Retail Sale Id 2606',1500.00,0.00,0.00,2.00,200.00,'2022-11-20 15:33:48','',''),(2590,'1','285','1',1,'Retail Sale Id 2607',1500.00,0.00,0.00,2.00,200.00,'2022-11-20 15:36:29','',''),(2591,'1','285','1',1,'Retail Sale Id 2608',802.50,0.00,0.00,1.07,107.00,'2022-11-20 15:39:10','',''),(2592,'1','285','1',1,'Retail Sale Id 2609',39780.00,0.00,0.00,58.50,1755.00,'2022-11-20 15:56:23','',''),(2593,'1','285','1',1,'Retail Sale Id 2610',997.50,0.00,0.00,1.33,133.00,'2022-11-20 16:00:39','',''),(2594,'1','285','1',1,'Retail Sale Id 2612',18322.50,0.00,0.00,24.43,2443.00,'2022-11-20 16:02:32','',''),(2595,'1','285','1',1,'Return of Retail Sale Id 2612',0.00,18322.50,24.43,0.00,-2443.00,'2022-11-20 16:03:41','',''),(2596,'1','285','1',1,'Retail Sale Id 2613',16612.40,0.00,0.00,24.43,732.90,'2022-11-20 16:04:16','',''),(2597,'1','285','1',1,'Retail Sale Id 2614',23800.00,0.00,0.00,35.00,1050.00,'2022-11-20 16:16:35','',''),(2598,'1','285','1',1,'Retail Sale Id 2615',4500.00,0.00,0.00,6.00,600.00,'2022-11-20 16:21:56','',''),(2599,'1','285','1',1,'Retail Sale Id 2616',1500.00,0.00,0.00,2.00,200.00,'2022-11-20 16:57:48','',''),(2600,'1','285','1',1,'Retail Sale Id 2617',2250.00,0.00,0.00,3.00,300.00,'2022-11-20 17:02:44','',''),(2601,'1','285','1',1,'Retail Sale Id 2618',5250.00,0.00,0.00,7.00,700.00,'2022-11-20 17:12:57','',''),(2602,'1','285','1',1,'Return of Retail Sale Id 2547',0.00,27200.00,40.00,0.00,-1200.00,'2022-11-20 17:36:35','',''),(2603,'1','285','1',1,'Retail Sale Id 2619',27200.00,0.00,0.00,40.00,1200.00,'2022-11-20 17:37:14','',''),(2604,'1','285','1',1,'Retail Sale Id 2620',757.50,0.00,0.00,1.01,101.00,'2022-11-20 18:34:36','',''),(2605,'1','285','1',1,'Return of Retail Sale Id 2613',0.00,16612.40,24.43,0.00,-732.90,'2022-11-20 18:37:43','',''),(2606,'1','285','1',1,'Retail Sale Id 2621',15986.80,0.00,0.00,23.51,705.30,'2022-11-20 18:38:47','',''),(2607,'1','285','1',1,'Retail Sale Id 2622',750.00,0.00,0.00,1.00,100.00,'2022-11-21 07:36:52','',''),(2608,'1','285','1',1,'Retail Sale Id 2623',2797.50,0.00,0.00,3.73,373.00,'2022-11-21 07:37:57','',''),(2609,'1','285','1',1,'Retail Sale Id 2624',997.50,0.00,0.00,1.33,133.00,'2022-11-21 07:38:42','',''),(2610,'1','285','1',1,'Retail Sale Id 2625',57548.40,0.00,0.00,84.63,2538.90,'2022-11-21 07:39:49','',''),(2611,'1','285','1',1,'Retail Sale Id 2626',1402.50,0.00,0.00,1.87,187.00,'2022-11-21 07:43:03','',''),(2612,'1','285','1',1,'Retail Sale Id 2627',41337.20,0.00,0.00,60.79,1823.70,'2022-11-21 07:50:00','',''),(2613,'1','285','1',1,'Retail Sale Id 2628',997.50,0.00,0.00,1.33,133.00,'2022-11-21 07:53:32','',''),(2614,'1','285','1',1,'Retail Sale Id 2630',43118.80,0.00,0.00,63.41,1902.30,'2022-11-21 08:00:53','',''),(2615,'1','285','1',1,'Retail Sale Id 2632',1500.00,0.00,0.00,2.00,200.00,'2022-11-21 08:01:32','',''),(2616,'1','285','1',1,'Retail Sale Id 2633',997.50,0.00,0.00,1.33,133.00,'2022-11-21 08:04:47','',''),(2617,'1','285','1',1,'Retail Sale Id 2634',111139.20,0.00,0.00,163.44,4903.20,'2022-11-21 08:07:45','',''),(2618,'1','285','1',1,'Retail Sale Id 2635',2002.50,0.00,0.00,2.67,267.00,'2022-11-21 08:16:01','',''),(2619,'1','285','1',1,'Retail Sale Id 2636',1500.00,0.00,0.00,2.00,200.00,'2022-11-21 08:16:56','',''),(2620,'1','285','1',1,'Retail Sale Id 2637',51435.20,0.00,0.00,75.64,2269.20,'2022-11-21 08:25:44','',''),(2621,'1','285','1',1,'Retail Sale Id 2638',3000.00,0.00,0.00,4.00,400.00,'2022-11-21 08:28:23','',''),(2622,'1','285','1',1,'Retail Sale Id 2639',3750.00,0.00,0.00,5.00,500.00,'2022-11-21 08:29:07','',''),(2623,'1','285','1',1,'Retail Sale Id 2640',750.00,0.00,0.00,1.00,100.00,'2022-11-21 08:34:47','',''),(2624,'1','285','1',1,'Retail Sale Id 2641',2497.50,0.00,0.00,3.33,333.00,'2022-11-21 08:35:37','',''),(2625,'1','285','1',1,'Retail Sale Id 2642',40800.00,0.00,0.00,60.00,1800.00,'2022-11-21 08:36:34','',''),(2626,'1','285','1',1,'Retail Sale Id 2643',11954.40,0.00,0.00,17.58,527.40,'2022-11-21 08:39:27','',''),(2627,'1','285','1',1,'Retail Sale Id 2644',2250.00,0.00,0.00,3.00,300.00,'2022-11-21 08:40:53','',''),(2628,'1','285','1',1,'Retail Sale Id 2645',1500.00,0.00,0.00,2.00,200.00,'2022-11-21 08:42:13','',''),(2629,'1','285','1',1,'Retail Sale Id 2646',40942.80,0.00,0.00,60.21,1806.30,'2022-11-21 08:46:42','',''),(2630,'1','285','1',1,'Return of Retail Sale Id 2646',0.00,40942.80,60.21,0.00,-1806.30,'2022-11-21 08:49:38','',''),(2631,'1','285','1',1,'Retail Sale Id 2647',41350.80,0.00,0.00,60.81,1824.30,'2022-11-21 08:50:16','',''),(2632,'1','285','1',1,'Retail Sale Id 2648',2250.00,0.00,0.00,3.00,300.00,'2022-11-21 08:54:01','',''),(2633,'1','285','1',1,'Retail Sale Id 2649',40902.00,0.00,0.00,60.15,1804.50,'2022-11-21 09:14:36','',''),(2634,'1','285','1',1,'Retail Sale Id 2650',997.50,0.00,0.00,1.33,133.00,'2022-11-21 09:24:13','',''),(2635,'1','285','1',1,'Retail Sale Id 2651',1500.00,0.00,0.00,2.00,200.00,'2022-11-21 09:44:44','',''),(2636,'1','285','1',1,'Retail Sale Id 2652',41840.40,0.00,0.00,61.53,1845.90,'2022-11-21 09:50:14','',''),(2637,'1','285','1',1,'Retail Sale Id 2653',2250.00,0.00,0.00,3.00,300.00,'2022-11-21 09:54:13','',''),(2638,'1','285','1',1,'Retail Sale Id 2654',1500.00,0.00,0.00,2.00,200.00,'2022-11-21 09:59:14','',''),(2639,'1','285','1',1,'Retail Sale Id 2655',750.00,0.00,0.00,1.00,100.00,'2022-11-21 10:21:24','',''),(2640,'1','285','1',1,'Retail Sale Id 2656',4500.00,0.00,0.00,6.00,600.00,'2022-11-21 10:31:30','',''),(2641,'1','285','1',1,'Retail Sale Id 2657',3000.00,0.00,0.00,4.00,400.00,'2022-11-21 10:45:26','',''),(2642,'1','285','1',1,'Retail Sale Id 2658',2250.00,0.00,0.00,3.00,300.00,'2022-11-21 11:01:23','',''),(2643,'1','285','1',1,'Retail Sale Id 2659',45934.00,0.00,0.00,67.55,2026.50,'2022-11-21 11:10:35','',''),(2644,'1','285','1',1,'Retail Sale Id 2660',34000.00,0.00,0.00,50.00,1500.00,'2022-11-21 11:12:26','',''),(2645,'1','285','1',1,'Retail Sale Id 2661',802.50,0.00,0.00,1.07,107.00,'2022-11-21 11:14:00','',''),(2646,'1','285','1',1,'Retail Sale Id 2662',13600.00,0.00,0.00,20.00,600.00,'2022-11-21 11:18:37','',''),(2647,'1','285','1',1,'Retail Sale Id 2663',3750.00,0.00,0.00,5.00,500.00,'2022-11-21 11:25:09','',''),(2648,'1','285','1',1,'Retail Sale Id 2664',750.00,0.00,0.00,1.00,100.00,'2022-11-21 11:58:20','',''),(2649,'1','285','1',1,'Retail Sale Id 2665',5700.00,0.00,0.00,7.60,760.00,'2022-11-21 12:10:37','',''),(2650,'1','285','1',1,'Retail Sale Id 2666',3000.00,0.00,0.00,4.00,400.00,'2022-11-21 12:13:01','',''),(2651,'1','285','1',1,'Retail Sale Id 2667',4500.00,0.00,0.00,6.00,600.00,'2022-11-21 12:29:13','',''),(2652,'1','285','1',1,'Retail Sale Id 2668',1500.00,0.00,0.00,2.00,200.00,'2022-11-21 12:38:17','',''),(2653,'1','285','1',1,'Retail Sale Id 2669',750.00,0.00,0.00,1.00,100.00,'2022-11-21 12:48:54','',''),(2654,'1','285','1',1,'Retail Sale Id 2670',1500.00,0.00,0.00,2.00,200.00,'2022-11-21 12:54:11','',''),(2655,'1','285','1',1,'Retail Sale Id 2671',1500.00,0.00,0.00,2.00,200.00,'2022-11-21 12:57:49','',''),(2656,'1','285','1',1,'Retail Sale Id 2672',2250.00,0.00,0.00,3.00,300.00,'2022-11-21 13:04:47','',''),(2657,'1','285','1',1,'Retail Sale Id 2673',1897.50,0.00,0.00,2.53,253.00,'2022-11-21 13:11:35','',''),(2658,'1','285','1',1,'Retail Sale Id 2674',3000.00,0.00,0.00,4.00,400.00,'2022-11-21 13:24:42','',''),(2659,'1','285','1',1,'Retail Sale Id 2675',997.50,0.00,0.00,1.33,133.00,'2022-11-21 13:26:10','',''),(2660,'1','285','1',1,'Retail Sale Id 2677',1500.00,0.00,0.00,2.00,200.00,'2022-11-21 13:27:03','',''),(2661,'1','285','1',1,'Retail Sale Id 2678',3000.00,0.00,0.00,4.00,400.00,'2022-11-21 13:28:53','',''),(2662,'1','285','1',1,'Retail Sale Id 2679',3000.00,0.00,0.00,4.00,400.00,'2022-11-21 13:29:30','',''),(2663,'1','285','1',1,'Retail Sale Id 2681',51000.00,0.00,0.00,75.00,2250.00,'2022-11-21 13:31:53','',''),(2664,'1','285','1',1,'Retail Sale Id 2682',2250.00,0.00,0.00,3.00,300.00,'2022-11-21 13:33:10','',''),(2665,'1','285','1',1,'Retail Sale Id 2684',1500.00,0.00,0.00,2.00,200.00,'2022-11-21 13:33:49','',''),(2666,'1','285','1',1,'Retail Sale Id 2685',1500.00,0.00,0.00,2.00,200.00,'2022-11-21 13:44:29','',''),(2667,'1','285','1',1,'Retail Sale Id 2686',802.50,0.00,0.00,1.07,107.00,'2022-11-21 13:51:01','',''),(2668,'1','285','1',1,'Retail Sale Id 2687',3000.00,0.00,0.00,4.00,400.00,'2022-11-21 14:40:01','',''),(2669,'1','285','1',1,'Retail Sale Id 2688',997.50,0.00,0.00,1.33,133.00,'2022-11-21 14:40:36','',''),(2670,'1','285','1',1,'Retail Sale Id 2690',34000.00,0.00,0.00,50.00,1500.00,'2022-11-21 14:41:10','',''),(2671,'1','285','1',1,'Retail Sale Id 2691',1500.00,0.00,0.00,2.00,200.00,'2022-11-21 14:42:51','',''),(2672,'1','285','1',1,'Retail Sale Id 2692',2700.00,0.00,0.00,3.60,360.00,'2022-11-21 14:45:34','',''),(2673,'1','285','1',1,'Retail Sale Id 2693',1500.00,0.00,0.00,2.00,200.00,'2022-11-21 15:02:44','',''),(2674,'1','285','1',1,'Retail Sale Id 2694',2250.00,0.00,0.00,3.00,300.00,'2022-11-21 15:03:46','',''),(2675,'1','285','1',1,'Retail Sale Id 2695',1500.00,0.00,0.00,2.00,200.00,'2022-11-21 15:09:34','',''),(2676,'1','285','1',1,'Retail Sale Id 2696',750.00,0.00,0.00,1.00,100.00,'2022-11-21 15:13:32','',''),(2677,'1','285','1',1,'Retail Sale Id 2697',2002.50,0.00,0.00,2.67,267.00,'2022-11-21 15:14:12','',''),(2678,'1','285','1',1,'Retail Sale Id 2698',3000.00,0.00,0.00,4.00,400.00,'2022-11-21 15:15:45','',''),(2679,'1','285','1',1,'Retail Sale Id 2699',1500.00,0.00,0.00,2.00,200.00,'2022-11-21 15:17:07','',''),(2680,'1','285','1',1,'Retail Sale Id 2700',2250.00,0.00,0.00,3.00,300.00,'2022-11-21 15:20:45','',''),(2681,'1','285','1',1,'Retail Sale Id 2701',2002.50,0.00,0.00,2.67,267.00,'2022-11-21 15:21:55','',''),(2682,'1','285','1',1,'Retail Sale Id 2702',1500.00,0.00,0.00,2.00,200.00,'2022-11-21 15:30:51','',''),(2683,'1','285','1',1,'Retail Sale Id 2703',5250.00,0.00,0.00,7.00,700.00,'2022-11-21 15:31:37','',''),(2684,'1','285','1',1,'Retail Sale Id 2704',3000.00,0.00,0.00,4.00,400.00,'2022-11-21 15:36:14','',''),(2685,'1','285','1',1,'Retail Sale Id 2705',2002.50,0.00,0.00,2.67,267.00,'2022-11-21 15:38:21','',''),(2686,'1','285','1',1,'Retail Sale Id 2706',1500.00,0.00,0.00,2.00,200.00,'2022-11-21 15:40:55','',''),(2687,'1','285','1',1,'Retail Sale Id 2707',81872.00,0.00,0.00,120.40,3612.00,'2022-11-21 15:45:37','',''),(2688,'1','285','1',1,'Retail Sale Id 2708',1500.00,0.00,0.00,2.00,200.00,'2022-11-21 15:49:37','',''),(2689,'1','285','1',1,'Retail Sale Id 2709',1500.00,0.00,0.00,2.00,200.00,'2022-11-21 15:52:48','',''),(2690,'1','285','1',1,'Retail Sale Id 2710',10500.00,0.00,0.00,14.00,1400.00,'2022-11-21 15:58:30','',''),(2691,'1','285','1',1,'Retail Sale Id 2711',3502.50,0.00,0.00,4.67,467.00,'2022-11-21 16:04:55','',''),(2692,'1','285','1',1,'Retail Sale Id 2713',3000.00,0.00,0.00,4.00,400.00,'2022-11-21 16:12:02','',''),(2693,'1','285','1',1,'Retail Sale Id 2714',27200.00,0.00,0.00,40.00,1200.00,'2022-11-21 16:13:09','',''),(2694,'1','285','1',1,'Retail Sale Id 2715',1500.00,0.00,0.00,2.00,200.00,'2022-11-21 16:22:55','',''),(2695,'1','285','1',1,'Retail Sale Id 2716',30600.00,0.00,0.00,45.00,1350.00,'2022-11-21 16:24:32','',''),(2696,'1','285','1',1,'Retail Sale Id 2717',4500.00,0.00,0.00,6.00,600.00,'2022-11-21 16:28:23','',''),(2697,'1','285','1',1,'Retail Sale Id 2718',2497.50,0.00,0.00,3.33,333.00,'2022-11-21 16:33:25','',''),(2698,'1','285','1',1,'Retail Sale Id 2719',6800.00,0.00,0.00,10.00,300.00,'2022-11-21 16:34:52','',''),(2699,'1','285','1',1,'Retail Sale Id 2720',5250.00,0.00,0.00,7.00,700.00,'2022-11-21 16:35:53','',''),(2700,'1','285','1',1,'Retail Sale Id 2721',2250.00,0.00,0.00,3.00,300.00,'2022-11-21 16:37:39','',''),(2701,'1','285','1',1,'Retail Sale Id 2722',28560.00,0.00,0.00,42.00,1260.00,'2022-11-21 16:40:39','',''),(2702,'1','285','1',1,'Retail Sale Id 2723',997.50,0.00,0.00,1.33,133.00,'2022-11-21 16:43:56','',''),(2703,'1','285','1',1,'Retail Sale Id 2724',1500.00,0.00,0.00,2.00,200.00,'2022-11-21 16:51:38','',''),(2704,'1','285','1',1,'Retail Sale Id 2725',4500.00,0.00,0.00,6.00,600.00,'2022-11-21 16:55:04','',''),(2705,'1','285','1',1,'Retail Sale Id 2726',2250.00,0.00,0.00,3.00,300.00,'2022-11-21 17:00:46','',''),(2706,'1','285','1',1,'Retail Sale Id 2727',680.00,0.00,0.00,1.00,30.00,'2022-11-21 18:01:27','',''),(2707,'1','285','1',1,'Retail Sale Id 2728',41214.80,0.00,0.00,60.61,1818.30,'2022-11-22 07:44:50','',''),(2708,'1','285','1',1,'Retail Sale Id 2730',750.00,0.00,0.00,1.00,100.00,'2022-11-22 07:45:27','',''),(2709,'1','285','1',1,'Retail Sale Id 2731',1500.00,0.00,0.00,2.00,200.00,'2022-11-22 07:45:54','',''),(2710,'1','285','1',1,'Retail Sale Id 2732',1500.00,0.00,0.00,2.00,200.00,'2022-11-22 07:46:20','',''),(2711,'1','285','1',1,'Retail Sale Id 2733',3000.00,0.00,0.00,4.00,400.00,'2022-11-22 07:48:19','',''),(2712,'1','285','1',1,'Retail Sale Id 2734',40800.00,0.00,0.00,60.00,1800.00,'2022-11-22 08:04:43','',''),(2713,'1','285','1',1,'Retail Sale Id 2735',1500.00,0.00,0.00,2.00,200.00,'2022-11-22 08:05:44','',''),(2714,'1','285','1',1,'Retail Sale Id 2736',27200.00,0.00,0.00,40.00,1200.00,'2022-11-22 08:07:46','',''),(2715,'1','285','1',1,'Retail Sale Id 2737',1500.00,0.00,0.00,2.00,200.00,'2022-11-22 08:08:53','',''),(2716,'1','285','1',1,'Retail Sale Id 2738',33632.80,0.00,0.00,49.46,1483.80,'2022-11-22 08:14:55','',''),(2717,'1','285','1',1,'Retail Sale Id 2739',1500.00,0.00,0.00,2.00,200.00,'2022-11-22 08:15:47','',''),(2718,'1','285','1',1,'Retail Sale Id 2740',2250.00,0.00,0.00,3.00,300.00,'2022-11-22 08:16:33','',''),(2719,'1','285','1',1,'Retail Sale Id 2741',27200.00,0.00,0.00,40.00,1200.00,'2022-11-22 08:18:06','',''),(2720,'1','285','1',1,'Retail Sale Id 2742',47600.00,0.00,0.00,70.00,2100.00,'2022-11-22 08:41:16','',''),(2721,'1','285','1',1,'Retail Sale Id 2743',40120.00,0.00,0.00,59.00,1770.00,'2022-11-22 08:50:10','',''),(2722,'1','285','1',1,'Return of Retail Sale Id 2742',0.00,47600.00,70.00,0.00,-2100.00,'2022-11-22 08:52:05','',''),(2723,'1','285','1',1,'Retail Sale Id 2744',48246.00,0.00,0.00,70.95,2128.50,'2022-11-22 08:52:43','',''),(2724,'1','285','1',1,'Retail Sale Id 2745',3750.00,0.00,0.00,5.00,500.00,'2022-11-22 08:53:30','',''),(2725,'1','285','1',1,'Retail Sale Id 2746',20481.60,0.00,0.00,30.12,903.60,'2022-11-22 08:55:18','',''),(2726,'1','285','1',1,'Retail Sale Id 2747',3000.00,0.00,0.00,4.00,400.00,'2022-11-22 08:59:40','',''),(2727,'1','285','1',1,'Retail Sale Id 2748',1500.00,0.00,0.00,2.00,200.00,'2022-11-22 09:01:52','',''),(2728,'1','285','1',1,'Retail Sale Id 2749',2250.00,0.00,0.00,3.00,300.00,'2022-11-22 09:06:05','',''),(2729,'1','285','1',1,'Retail Sale Id 2750',750.00,0.00,0.00,1.00,100.00,'2022-11-22 09:18:10','',''),(2730,'1','285','1',1,'Retail Sale Id 2751',2497.50,0.00,0.00,3.33,333.00,'2022-11-22 09:25:22','',''),(2731,'1','285','1',1,'Retail Sale Id 2752',34000.00,0.00,0.00,50.00,1500.00,'2022-11-22 09:26:26','',''),(2732,'1','285','1',1,'Retail Sale Id 2753',48069.20,0.00,0.00,70.69,2120.70,'2022-11-22 09:35:37','',''),(2733,'1','285','1',1,'Retail Sale Id 2754',1500.00,0.00,0.00,2.00,200.00,'2022-11-22 09:42:31','',''),(2734,'1','285','1',1,'Retail Sale Id 2755',64600.00,0.00,0.00,95.00,2850.00,'2022-11-22 09:43:39','',''),(2735,'1','285','1',1,'Return of Retail Sale Id 2755',0.00,64600.00,95.00,0.00,-2850.00,'2022-11-22 09:44:21','',''),(2736,'1','285','1',1,'Retail Sale Id 2756',40120.00,0.00,0.00,59.00,1770.00,'2022-11-22 09:45:13','',''),(2737,'1','285','1',1,'Retail Sale Id 2757',1500.00,0.00,0.00,2.00,200.00,'2022-11-22 09:56:36','',''),(2738,'1','285','1',1,'Retail Sale Id 2758',29770.40,0.00,0.00,43.78,1313.40,'2022-11-22 10:05:39','',''),(2739,'1','285','1',1,'Retail Sale Id 2759',1500.00,0.00,0.00,2.00,200.00,'2022-11-22 10:15:23','',''),(2740,'1','285','1',1,'Retail Sale Id 2760',2250.00,0.00,0.00,3.00,300.00,'2022-11-22 10:29:17','',''),(2741,'1','285','1',1,'Retail Sale Id 2761',3750.00,0.00,0.00,5.00,500.00,'2022-11-22 10:40:22','',''),(2742,'1','285','1',1,'Retail Sale Id 2762',5250.00,0.00,0.00,7.00,700.00,'2022-11-22 10:42:37','',''),(2743,'1','285','1',1,'Retail Sale Id 2763',42044.40,0.00,0.00,61.83,1854.90,'2022-11-22 10:46:51','',''),(2744,'1','285','1',1,'Retail Sale Id 2764',2250.00,0.00,0.00,3.00,300.00,'2022-11-22 10:53:08','',''),(2745,'1','285','1',1,'Retail Sale Id 2765',1500.00,0.00,0.00,2.00,200.00,'2022-11-22 11:16:33','',''),(2746,'1','285','1',1,'Retail Sale Id 2766',1500.00,0.00,0.00,2.00,200.00,'2022-11-22 11:32:13','',''),(2747,'1','285','1',1,'Retail Sale Id 2767',2250.00,0.00,0.00,3.00,300.00,'2022-11-22 11:34:35','',''),(2748,'1','285','1',1,'Retail Sale Id 2768',1500.00,0.00,0.00,2.00,200.00,'2022-11-22 11:42:58','',''),(2749,'1','285','1',1,'Retail Sale Id 2769',1500.00,0.00,0.00,2.00,200.00,'2022-11-22 12:00:26','',''),(2750,'1','285','1',1,'Retail Sale Id 2770',1500.00,0.00,0.00,2.00,200.00,'2022-11-22 12:28:26','',''),(2751,'1','285','1',1,'Retail Sale Id 2771',30600.00,0.00,0.00,45.00,1350.00,'2022-11-22 12:52:20','',''),(2752,'1','285','1',1,'Retail Sale Id 2772',750.00,0.00,0.00,1.00,100.00,'2022-11-22 12:55:23','',''),(2753,'1','285','1',1,'Retail Sale Id 2773',41337.20,0.00,0.00,60.79,1823.70,'2022-11-22 13:28:56','',''),(2754,'1','285','1',1,'Retail Sale Id 2774',10500.00,0.00,0.00,14.00,1400.00,'2022-11-22 13:47:52','',''),(2755,'1','285','1',1,'Retail Sale Id 2775',997.50,0.00,0.00,1.33,133.00,'2022-11-22 13:51:33','',''),(2756,'1','285','1',1,'Retail Sale Id 2776',34000.00,0.00,0.00,50.00,1500.00,'2022-11-22 14:06:27','',''),(2757,'1','285','1',1,'Retail Sale Id 2777',2250.00,0.00,0.00,3.00,300.00,'2022-11-22 14:13:23','',''),(2758,'1','285','1',1,'Retail Sale Id 2778',1500.00,0.00,0.00,2.00,200.00,'2022-11-22 14:36:15','',''),(2759,'1','285','1',1,'Retail Sale Id 2779',997.50,0.00,0.00,1.33,133.00,'2022-11-22 14:44:19','',''),(2760,'1','285','1',1,'Retail Sale Id 2781',750.00,0.00,0.00,1.00,100.00,'2022-11-22 14:58:04','',''),(2761,'1','285','1',1,'Retail Sale Id 2782',4500.00,0.00,0.00,6.00,600.00,'2022-11-22 15:01:30','',''),(2762,'1','285','1',1,'Retail Sale Id 2783',2250.00,0.00,0.00,3.00,300.00,'2022-11-22 15:03:25','',''),(2763,'1','285','1',1,'Retail Sale Id 2784',27880.00,0.00,0.00,41.00,1230.00,'2022-11-22 15:21:29','',''),(2764,'1','285','1',1,'Retail Sale Id 2785',1500.00,0.00,0.00,2.00,200.00,'2022-11-22 15:23:20','',''),(2765,'1','285','1',1,'Retail Sale Id 2786',1500.00,0.00,0.00,2.00,200.00,'2022-11-22 15:27:31','',''),(2766,'1','285','1',1,'Retail Sale Id 2787',997.50,0.00,0.00,1.33,133.00,'2022-11-22 15:28:34','',''),(2767,'1','285','1',1,'Retail Sale Id 2788',3000.00,0.00,0.00,4.00,400.00,'2022-11-22 15:29:42','',''),(2768,'1','285','1',1,'Retail Sale Id 2789',4500.00,0.00,0.00,6.00,600.00,'2022-11-22 15:33:42','',''),(2769,'1','285','1',1,'Retail Sale Id 2790',997.50,0.00,0.00,1.33,133.00,'2022-11-22 16:02:53','',''),(2770,'1','285','1',1,'Return of Retail Sale Id 2761',0.00,3750.00,5.00,0.00,-500.00,'2022-11-22 16:13:32','',''),(2771,'1','285','1',1,'Return of Retail Sale Id 2790',0.00,997.50,1.33,0.00,-133.00,'2022-11-22 17:45:03','',''),(2772,'1','285','1',1,'Retail Sale Id 2791',990.00,0.00,0.00,1.32,132.00,'2022-11-22 17:45:36','',''),(2773,'1','285','1',1,'Return of Retail Sale Id 2784',0.00,27880.00,41.00,0.00,-1230.00,'2022-11-22 17:47:59','',''),(2774,'1','285','1',1,'Retail Sale Id 2792',28226.80,0.00,0.00,41.51,1245.30,'2022-11-22 17:48:46','',''),(2775,'1','285','1',1,'Distributed to AA RANO NIGERIA LTD for sales id:3',145021.50,0.00,0.00,223.11,0.00,'2022-11-22 18:55:26','',''),(2776,'1','285',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9088000.00,14200.00,0.00,0.00,'2022-11-22 19:18:18','',''),(2777,'1','285',NULL,1,'Reception corrector for bridging 4',0.00,0.00,0.00,14200.00,0.00,'2022-11-22 19:22:26','',''),(2778,'1','285','1',1,'Received from bridging 4',0.00,0.00,14200.00,0.00,0.00,'2022-11-22 19:22:26','',''),(2779,'1','285','1',1,'Retail Sale Id 2793',22801.50,0.00,0.00,33.78,1182.30,'2022-11-23 07:28:25','',''),(2780,'1','285','1',1,'Retail Sale Id 2794',20250.00,0.00,0.00,30.00,1050.00,'2022-11-23 07:29:55','',''),(2781,'1','285','1',1,'Retail Sale Id 2795',2250.00,0.00,0.00,3.00,330.00,'2022-11-23 07:30:27','',''),(2782,'1','285','1',1,'Retail Sale Id 2796',997.50,0.00,0.00,1.33,146.30,'2022-11-23 07:31:33','',''),(2783,'1','285','1',1,'Retail Sale Id 2797',750.00,0.00,0.00,1.00,110.00,'2022-11-23 07:33:09','',''),(2784,'1','285','1',1,'Retail Sale Id 2798',997.50,0.00,0.00,1.33,146.30,'2022-11-23 07:33:47','',''),(2785,'1','285','1',1,'Retail Sale Id 2799',2002.50,0.00,0.00,2.67,267.00,'2022-11-23 07:46:38','',''),(2786,'1','285','1',1,'Retail Sale Id 2800',1500.00,0.00,0.00,2.00,200.00,'2022-11-23 07:47:25','',''),(2787,'1','285','1',1,'Retail Sale Id 2801',41073.75,0.00,0.00,60.85,1521.25,'2022-11-23 07:48:37','',''),(2788,'1','285','1',1,'Retail Sale Id 2802',2250.00,0.00,0.00,3.00,300.00,'2022-11-23 07:51:02','',''),(2789,'1','285','1',1,'Retail Sale Id 2803',750.00,0.00,0.00,1.00,100.00,'2022-11-23 07:58:37','',''),(2790,'1','285','1',1,'Retail Sale Id 2804',750.00,0.00,0.00,1.00,100.00,'2022-11-23 07:59:37','',''),(2791,'1','285','1',1,'Retail Sale Id 2805',1500.00,0.00,0.00,2.00,200.00,'2022-11-23 08:02:14','',''),(2792,'1','285','1',1,'Retail Sale Id 2806',29700.00,0.00,0.00,44.00,1100.00,'2022-11-23 08:03:24','',''),(2793,'1','285','1',1,'Retail Sale Id 2807',1500.00,0.00,0.00,2.00,200.00,'2022-11-23 08:10:11','',''),(2794,'1','285','1',1,'Retail Sale Id 2808',997.50,0.00,0.00,1.33,133.00,'2022-11-23 08:15:41','',''),(2795,'1','285','1',1,'Retail Sale Id 2809',39150.00,0.00,0.00,58.00,1450.00,'2022-11-23 08:20:01','',''),(2796,'1','285','1',1,'Retail Sale Id 2810',4500.00,0.00,0.00,6.00,600.00,'2022-11-23 08:26:59','',''),(2797,'1','285','1',1,'Retail Sale Id 2811',38637.00,0.00,0.00,57.24,1431.00,'2022-11-23 08:28:08','',''),(2798,'1','285','1',1,'Retail Sale Id 2812',3000.00,0.00,0.00,4.00,400.00,'2022-11-23 08:30:29','',''),(2799,'1','285','1',1,'Retail Sale Id 2814',1500.00,0.00,0.00,2.00,200.00,'2022-11-23 08:32:56','',''),(2800,'1','285','1',1,'Retail Sale Id 2815',16598.25,0.00,0.00,24.59,614.75,'2022-11-23 08:34:26','',''),(2801,'1','285','1',1,'Retail Sale Id 2816',750.00,0.00,0.00,1.00,100.00,'2022-11-23 08:40:22','',''),(2802,'1','285','1',1,'Retail Sale Id 2817',1500.00,0.00,0.00,2.00,200.00,'2022-11-23 08:54:21','',''),(2803,'1','285','1',1,'Retail Sale Id 2818',44874.00,0.00,0.00,66.48,1662.00,'2022-11-23 08:56:15','',''),(2804,'1','285','1',1,'Retail Sale Id 2819',62012.25,0.00,0.00,91.87,2296.75,'2022-11-23 09:01:16','',''),(2805,'1','285','1',1,'Retail Sale Id 2820',12271.50,0.00,0.00,18.18,454.50,'2022-11-23 09:07:51','',''),(2806,'1','285','1',1,'Retail Sale Id 2822',41667.75,0.00,0.00,61.73,1543.25,'2022-11-23 09:09:01','',''),(2807,'1','285','1',1,'Retail Sale Id 2823',2497.50,0.00,0.00,3.33,333.00,'2022-11-23 09:10:05','',''),(2808,'1','285','1',1,'Retail Sale Id 2824',2250.00,0.00,0.00,3.00,300.00,'2022-11-23 09:10:54','',''),(2809,'1','285','1',1,'Retail Sale Id 2825',3750.00,0.00,0.00,5.00,500.00,'2022-11-23 09:13:27','',''),(2810,'1','285','1',1,'Retail Sale Id 2826',997.50,0.00,0.00,1.33,133.00,'2022-11-23 09:31:20','',''),(2811,'1','285','1',1,'Retail Sale Id 2827',750.00,0.00,0.00,1.00,100.00,'2022-11-23 09:36:03','',''),(2812,'1','285','1',1,'Retail Sale Id 2828',997.50,0.00,0.00,1.33,133.00,'2022-11-23 09:42:16','',''),(2813,'1','285','1',1,'Retail Sale Id 2829',40500.00,0.00,0.00,60.00,1500.00,'2022-11-23 09:43:38','',''),(2814,'1','285','1',1,'Retail Sale Id 2830',997.50,0.00,0.00,1.33,133.00,'2022-11-23 10:37:05','',''),(2815,'1','285','1',1,'Retail Sale Id 2831',43915.50,0.00,0.00,65.06,1626.50,'2022-11-23 10:49:24','',''),(2816,'1','285','1',1,'Retail Sale Id 2832',1500.00,0.00,0.00,2.00,200.00,'2022-11-23 11:16:03','',''),(2817,'1','285','1',1,'Retail Sale Id 2833',35100.00,0.00,0.00,52.00,1300.00,'2022-11-23 11:23:37','',''),(2818,'1','285','1',1,'Retail Sale Id 2834',3000.00,0.00,0.00,4.00,400.00,'2022-11-23 11:32:31','',''),(2819,'1','285','1',1,'Retail Sale Id 2835',1500.00,0.00,0.00,2.00,200.00,'2022-11-23 11:54:25','',''),(2820,'1','285','1',1,'Retail Sale Id 2836',802.50,0.00,0.00,1.07,107.00,'2022-11-23 12:10:21','',''),(2821,'1','285','1',1,'Retail Sale Id 2837',2250.00,0.00,0.00,3.00,300.00,'2022-11-23 12:17:55','',''),(2822,'1','285','1',1,'Retail Sale Id 2838',41829.75,0.00,0.00,61.97,1549.25,'2022-11-23 12:29:52','',''),(2823,'1','285','1',1,'Retail Sale Id 2839',3000.00,0.00,0.00,4.00,400.00,'2022-11-23 12:44:21','',''),(2824,'1','285','1',1,'Retail Sale Id 2840',1500.00,0.00,0.00,2.00,200.00,'2022-11-23 12:48:03','',''),(2825,'1','285','1',1,'Retail Sale Id 2841',1500.00,0.00,0.00,2.00,200.00,'2022-11-23 12:51:31','',''),(2826,'1','285','1',1,'Retail Sale Id 2842',2250.00,0.00,0.00,3.00,300.00,'2022-11-23 13:07:14','',''),(2827,'1','285','1',1,'Retail Sale Id 2843',997.50,0.00,0.00,1.33,133.00,'2022-11-23 13:23:08','',''),(2828,'1','285','1',1,'Retail Sale Id 2844',3750.00,0.00,0.00,5.00,500.00,'2022-11-23 13:32:25','',''),(2829,'1','285','1',1,'Retail Sale Id 2845',40851.00,0.00,0.00,60.52,1513.00,'2022-11-23 13:37:22','',''),(2830,'1','285','1',1,'Retail Sale Id 2846',1500.00,0.00,0.00,2.00,200.00,'2022-11-23 13:45:46','',''),(2831,'1','285','1',1,'Retail Sale Id 2847',1500.00,0.00,0.00,2.00,200.00,'2022-11-23 13:47:54','',''),(2832,'1','285','1',1,'Retail Sale Id 2848',3000.00,0.00,0.00,4.00,400.00,'2022-11-23 13:51:09','',''),(2833,'1','285','1',1,'Retail Sale Id 2849',750.00,0.00,0.00,1.00,100.00,'2022-11-23 14:16:29','',''),(2834,'1','285','1',1,'Retail Sale Id 2850',3000.00,0.00,0.00,4.00,400.00,'2022-11-23 14:23:27','',''),(2835,'1','285','1',1,'Retail Sale Id 2851',997.50,0.00,0.00,1.33,133.00,'2022-11-23 14:24:30','',''),(2836,'1','285','1',1,'Retail Sale Id 2852',802.50,0.00,0.00,1.07,107.00,'2022-11-23 14:53:36','',''),(2837,'1','285','1',1,'Retail Sale Id 2853',750.00,0.00,0.00,1.00,100.00,'2022-11-23 15:07:06','',''),(2838,'1','285','1',1,'Retail Sale Id 2854',32076.00,0.00,0.00,47.52,1188.00,'2022-11-23 15:16:35','',''),(2839,'1','285','1',1,'Retail Sale Id 2855',2250.00,0.00,0.00,3.00,300.00,'2022-11-23 15:23:18','',''),(2840,'1','285','1',1,'Retail Sale Id 2856',111132.00,0.00,0.00,164.64,4116.00,'2022-11-23 15:38:47','',''),(2841,'1','285','1',1,'Retail Sale Id 2857',27000.00,0.00,0.00,40.00,1000.00,'2022-11-23 15:40:05','',''),(2842,'1','285','1',1,'Retail Sale Id 2858',45603.00,0.00,0.00,67.56,1689.00,'2022-11-23 15:42:31','',''),(2843,'1','285','1',1,'Retail Sale Id 2859',1500.00,0.00,0.00,2.00,200.00,'2022-11-23 15:47:02','',''),(2844,'1','285','1',1,'Retail Sale Id 2860',2250.00,0.00,0.00,3.00,300.00,'2022-11-23 15:47:53','',''),(2845,'1','285','1',1,'Retail Sale Id 2861',750.00,0.00,0.00,1.00,100.00,'2022-11-23 15:53:14','',''),(2846,'1','285','1',1,'Retail Sale Id 2862',2250.00,0.00,0.00,3.00,300.00,'2022-11-23 16:07:10','',''),(2847,'1','285','1',1,'Retail Sale Id 2863',5250.00,0.00,0.00,7.00,700.00,'2022-11-23 16:23:40','',''),(2848,'1','285','1',1,'Retail Sale Id 2865',32062.50,0.00,0.00,47.50,1187.50,'2022-11-23 16:30:21','',''),(2849,'1','285','1',1,'Retail Sale Id 2866',1500.00,0.00,0.00,2.00,200.00,'2022-11-23 16:33:45','',''),(2850,'1','285','1',1,'Retail Sale Id 2867',1500.00,0.00,0.00,2.00,200.00,'2022-11-23 16:34:54','',''),(2851,'1','285','1',1,'Retail Sale Id 2868',33750.00,0.00,0.00,50.00,1250.00,'2022-11-23 16:44:14','',''),(2852,'1','285','1',1,'Retail Sale Id 2869',1500.00,0.00,0.00,2.00,200.00,'2022-11-23 16:45:31','',''),(2853,'1','285','1',1,'Retail Sale Id 2871',9000.00,0.00,0.00,12.00,1200.00,'2022-11-23 16:47:23','',''),(2854,'1','285','1',1,'Retail Sale Id 2872',40857.75,0.00,0.00,60.53,1513.25,'2022-11-23 16:55:29','',''),(2855,'1','285','1',1,'Retail Sale Id 2873',3750.00,0.00,0.00,5.00,500.00,'2022-11-23 16:59:29','',''),(2856,'1','285','1',1,'Retail Sale Id 2876',3000.00,0.00,0.00,4.00,400.00,'2022-11-23 17:00:19','',''),(2857,'1','285','1',1,'Retail Sale Id 2877',1500.00,0.00,0.00,2.00,200.00,'2022-11-23 17:01:00','',''),(2858,'1','285','1',1,'Retail Sale Id 2878',60554.25,0.00,0.00,89.71,2242.75,'2022-11-24 07:25:26','',''),(2859,'1','285','1',1,'Retail Sale Id 2879',2250.00,0.00,0.00,3.00,300.00,'2022-11-24 07:27:49','',''),(2860,'1','285','1',1,'Retail Sale Id 2880',20250.00,0.00,0.00,30.00,750.00,'2022-11-24 07:29:22','',''),(2861,'1','285','1',1,'Retail Sale Id 2881',47283.75,0.00,0.00,70.05,1751.25,'2022-11-24 07:32:56','',''),(2862,'1','285','1',1,'Retail Sale Id 2882',27000.00,0.00,0.00,40.00,1000.00,'2022-11-24 07:38:21','',''),(2863,'1','285','1',1,'Retail Sale Id 2883',3000.00,0.00,0.00,4.00,400.00,'2022-11-24 07:52:29','',''),(2864,'1','285','1',1,'Retail Sale Id 2884',16713.00,0.00,0.00,24.76,619.00,'2022-11-24 07:56:06','',''),(2865,'1','285','1',1,'Retail Sale Id 2885',2302.50,0.00,0.00,3.07,307.00,'2022-11-24 08:00:31','',''),(2866,'1','285','1',1,'Retail Sale Id 2886',2002.50,0.00,0.00,2.67,267.00,'2022-11-24 08:04:47','',''),(2867,'1','285','1',1,'Retail Sale Id 2887',41539.50,0.00,0.00,61.54,1538.50,'2022-11-24 08:12:26','',''),(2868,'1','285','1',1,'Retail Sale Id 2888',2250.00,0.00,0.00,3.00,300.00,'2022-11-24 08:21:00','',''),(2869,'1','285','1',1,'Retail Sale Id 2889',40500.00,0.00,0.00,60.00,1500.00,'2022-11-24 08:23:00','',''),(2870,'1','285','1',1,'Retail Sale Id 2890',46055.25,0.00,0.00,68.23,1705.75,'2022-11-24 08:28:37','',''),(2871,'1','285','1',1,'Retail Sale Id 2891',3000.00,0.00,0.00,4.00,400.00,'2022-11-24 08:42:50','',''),(2872,'1','285','1',1,'Retail Sale Id 2892',6000.00,0.00,0.00,8.00,800.00,'2022-11-24 08:43:58','',''),(2873,'1','285','1',1,'Retail Sale Id 2893',997.50,0.00,0.00,1.33,133.00,'2022-11-24 08:59:02','',''),(2874,'1','285','1',1,'Retail Sale Id 2894',750.00,0.00,0.00,1.00,100.00,'2022-11-24 09:19:45','',''),(2875,'1','285','1',1,'Retail Sale Id 2895',750.00,0.00,0.00,1.00,100.00,'2022-11-24 09:57:30','',''),(2876,'1','285','1',1,'Retail Sale Id 2896',27000.00,0.00,0.00,40.00,1000.00,'2022-11-24 10:10:42','',''),(2877,'1','285','1',1,'Retail Sale Id 2897',4500.00,0.00,0.00,6.00,600.00,'2022-11-24 10:12:46','',''),(2878,'1','285','1',1,'Retail Sale Id 2898',3000.00,0.00,0.00,4.00,400.00,'2022-11-24 10:14:43','',''),(2879,'1','285','1',1,'Retail Sale Id 2899',3000.00,0.00,0.00,4.00,400.00,'2022-11-24 10:25:03','',''),(2880,'1','285','1',1,'Retail Sale Id 2900',1500.00,0.00,0.00,2.00,200.00,'2022-11-24 10:26:31','',''),(2881,'1','285','1',1,'Retail Sale Id 2901',1500.00,0.00,0.00,2.00,200.00,'2022-11-24 10:27:16','',''),(2882,'1','285','1',1,'Retail Sale Id 2902',750.00,0.00,0.00,1.00,100.00,'2022-11-24 10:33:50','',''),(2883,'1','285','1',1,'Retail Sale Id 2903',750.00,0.00,0.00,1.00,100.00,'2022-11-24 10:58:44','',''),(2884,'1','285','1',1,'Retail Sale Id 2904',33750.00,0.00,0.00,50.00,1250.00,'2022-11-24 11:02:05','',''),(2885,'1','285','1',1,'Retail Sale Id 2905',3750.00,0.00,0.00,5.00,500.00,'2022-11-24 11:02:46','',''),(2886,'1','285','1',1,'Retail Sale Id 2906',4500.00,0.00,0.00,6.00,600.00,'2022-11-24 11:29:03','',''),(2887,'1','285','1',1,'Retail Sale Id 2909',750.00,0.00,0.00,1.00,100.00,'2022-11-24 11:50:20','',''),(2888,'1','285','1',1,'Retail Sale Id 2910',5250.00,0.00,0.00,7.00,700.00,'2022-11-24 12:08:18','',''),(2889,'1','285','1',1,'Retail Sale Id 2911',997.50,0.00,0.00,1.33,133.00,'2022-11-24 12:09:32','',''),(2890,'1','285','1',1,'Retail Sale Id 2912',5250.00,0.00,0.00,7.00,700.00,'2022-11-24 12:29:53','',''),(2891,'1','285','1',1,'Retail Sale Id 2913',750.00,0.00,0.00,1.00,100.00,'2022-11-24 13:03:19','',''),(2892,'1','285','1',1,'Retail Sale Id 2914',3000.00,0.00,0.00,4.00,400.00,'2022-11-24 13:04:29','',''),(2893,'1','285','1',1,'Retail Sale Id 2915',27000.00,0.00,0.00,40.00,1000.00,'2022-11-24 13:06:05','',''),(2894,'1','285','1',1,'Retail Sale Id 2916',3502.50,0.00,0.00,4.67,467.00,'2022-11-24 13:16:08','',''),(2895,'1','285','1',1,'Retail Sale Id 2917',1500.00,0.00,0.00,2.00,200.00,'2022-11-24 13:55:02','',''),(2896,'1','285','1',1,'Retail Sale Id 2918',3000.00,0.00,0.00,4.00,400.00,'2022-11-24 14:01:12','',''),(2897,'1','285','1',1,'Retail Sale Id 2919',3000.00,0.00,0.00,4.00,400.00,'2022-11-24 14:14:56','',''),(2898,'1','285','1',1,'Retail Sale Id 2920',2250.00,0.00,0.00,3.00,300.00,'2022-11-24 14:32:49','',''),(2899,'1','285','1',1,'Retail Sale Id 2921',88890.75,0.00,0.00,131.69,3292.25,'2022-11-24 14:56:09','',''),(2900,'1','285','1',1,'Retail Sale Id 2922',2250.00,0.00,0.00,3.00,300.00,'2022-11-24 15:14:11','',''),(2901,'1','285','1',1,'Retail Sale Id 2923',43746.75,0.00,0.00,64.81,1620.25,'2022-11-24 15:17:17','',''),(2902,'1','285','1',1,'Retail Sale Id 2924',12015.00,0.00,0.00,17.80,445.00,'2022-11-24 15:20:55','',''),(2903,'1','285','1',1,'Retail Sale Id 2925',20250.00,0.00,0.00,30.00,750.00,'2022-11-24 15:24:37','',''),(2904,'1','285','1',1,'Retail Sale Id 2926',997.50,0.00,0.00,1.33,133.00,'2022-11-24 15:28:05','',''),(2905,'1','285','1',1,'Retail Sale Id 2927',750.00,0.00,0.00,1.00,100.00,'2022-11-24 15:29:36','',''),(2906,'1','285','1',1,'Retail Sale Id 2928',55687.50,0.00,0.00,82.50,2062.50,'2022-11-24 15:34:15','',''),(2907,'1','285','1',1,'Retail Sale Id 2929',750.00,0.00,0.00,1.00,100.00,'2022-11-24 15:36:38','',''),(2908,'1','285','1',1,'Retail Sale Id 2930',3750.00,0.00,0.00,5.00,500.00,'2022-11-24 15:39:13','',''),(2909,'1','285','1',1,'Retail Sale Id 2931',2250.00,0.00,0.00,3.00,300.00,'2022-11-24 15:40:14','',''),(2910,'1','285','1',1,'Retail Sale Id 2932',2250.00,0.00,0.00,3.00,300.00,'2022-11-24 15:43:12','',''),(2911,'1','285','1',1,'Retail Sale Id 2933',997.50,0.00,0.00,1.33,133.00,'2022-11-24 15:50:10','',''),(2912,'1','285','1',1,'Retail Sale Id 2934',1500.00,0.00,0.00,2.00,200.00,'2022-11-24 15:52:26','',''),(2913,'1','285','1',1,'Retail Sale Id 2935',4500.00,0.00,0.00,6.00,600.00,'2022-11-24 15:55:31','',''),(2914,'1','285','1',1,'Retail Sale Id 2936',3750.00,0.00,0.00,5.00,500.00,'2022-11-24 15:59:19','',''),(2915,'1','285','1',1,'Retail Sale Id 2937',2250.00,0.00,0.00,3.00,300.00,'2022-11-24 16:12:10','',''),(2916,'1','285','1',1,'Retail Sale Id 2938',4500.00,0.00,0.00,6.00,600.00,'2022-11-24 16:17:26','',''),(2917,'1','285','1',1,'Retail Sale Id 2939',4297.50,0.00,0.00,5.73,573.00,'2022-11-24 16:21:40','',''),(2918,'1','285','1',1,'Return of Retail Sale Id 2938',0.00,4500.00,6.00,0.00,-600.00,'2022-11-24 16:23:33','',''),(2919,'1','285','1',1,'Retail Sale Id 2940',2250.00,0.00,0.00,3.00,300.00,'2022-11-24 16:24:26','',''),(2920,'1','285','1',1,'Retail Sale Id 2942',1500.00,0.00,0.00,2.00,200.00,'2022-11-24 16:30:05','',''),(2921,'1','285','1',1,'Retail Sale Id 2943',750.00,0.00,0.00,1.00,100.00,'2022-11-24 16:30:49','',''),(2922,'1','285','1',1,'Retail Sale Id 2944',41478.75,0.00,0.00,61.45,1536.25,'2022-11-24 16:33:05','',''),(2923,'1','285','1',1,'Retail Sale Id 2945',1500.00,0.00,0.00,2.00,200.00,'2022-11-24 16:40:25','',''),(2924,'1','285','1',1,'Retail Sale Id 2946',750.00,0.00,0.00,1.00,100.00,'2022-11-24 16:41:15','',''),(2925,'1','285','1',1,'Retail Sale Id 2947',750.00,0.00,0.00,1.00,100.00,'2022-11-24 16:46:12','',''),(2926,'1','285','1',1,'Retail Sale Id 2948',750.00,0.00,0.00,1.00,100.00,'2022-11-24 16:48:32','',''),(2927,'1','285','1',1,'Retail Sale Id 2949',6000.00,0.00,0.00,8.00,800.00,'2022-11-24 16:49:41','',''),(2928,'1','285','1',1,'Retail Sale Id 2950',802.50,0.00,0.00,1.07,107.00,'2022-11-24 16:59:15','',''),(2929,'1','285','1',1,'Retail Sale Id 2951',3000.00,0.00,0.00,4.00,400.00,'2022-11-24 16:59:48','',''),(2930,'1','285','1',1,'Return of Retail Sale Id 2949',0.00,6000.00,8.00,0.00,-800.00,'2022-11-24 17:01:11','',''),(2931,'1','285','1',1,'Retail Sale Id 2952',3000.00,0.00,0.00,4.00,400.00,'2022-11-24 17:02:05','',''),(2932,'1','285','1',1,'Retail Sale Id 2954',3000.00,0.00,0.00,4.00,400.00,'2022-11-24 17:02:42','',''),(2933,'1','285','1',1,'Retail Sale Id 2955',2002.50,0.00,0.00,2.67,267.00,'2022-11-24 17:07:33','',''),(2934,'1','285','1',1,'Retail Sale Id 2956',5400.00,0.00,0.00,8.00,200.00,'2022-11-24 17:08:13','',''),(2935,'1','285','1',1,'Retail Sale Id 2957',2250.00,0.00,0.00,3.00,300.00,'2022-11-25 07:26:27','',''),(2936,'1','285','1',1,'Retail Sale Id 2958',750.00,0.00,0.00,1.00,100.00,'2022-11-25 07:28:15','',''),(2937,'1','285','1',1,'Retail Sale Id 2959',2002.50,0.00,0.00,2.67,267.00,'2022-11-25 07:30:03','',''),(2938,'1','285','1',1,'Retail Sale Id 2960',41175.00,0.00,0.00,61.00,1525.00,'2022-11-25 07:31:59','',''),(2939,'1','285','1',1,'Retail Sale Id 2961',750.00,0.00,0.00,1.00,100.00,'2022-11-25 07:33:05','',''),(2940,'1','285','1',1,'Retail Sale Id 2962',2250.00,0.00,0.00,3.00,300.00,'2022-11-25 07:52:31','',''),(2941,'1','285','1',1,'Retail Sale Id 2963',2250.00,0.00,0.00,3.00,300.00,'2022-11-25 08:01:53','',''),(2942,'1','285','1',1,'Retail Sale Id 2964',750.00,0.00,0.00,1.00,100.00,'2022-11-25 08:10:16','',''),(2943,'1','285','1',1,'Retail Sale Id 2965',1500.00,0.00,0.00,2.00,200.00,'2022-11-25 08:21:39','',''),(2944,'1','285','1',1,'Retail Sale Id 2966',42187.50,0.00,0.00,62.50,1562.50,'2022-11-25 08:23:38','',''),(2945,'1','285','1',1,'Retail Sale Id 2967',1500.00,0.00,0.00,2.00,200.00,'2022-11-25 08:26:40','',''),(2946,'1','285','1',1,'Retail Sale Id 2968',3750.00,0.00,0.00,5.00,500.00,'2022-11-25 08:27:42','',''),(2947,'1','285','1',1,'Retail Sale Id 2969',40500.00,0.00,0.00,60.00,1500.00,'2022-11-25 08:30:38','',''),(2948,'1','285','1',1,'Retail Sale Id 2970',1500.00,0.00,0.00,2.00,200.00,'2022-11-25 08:45:52','',''),(2949,'1','285','1',1,'Retail Sale Id 2971',997.50,0.00,0.00,1.33,133.00,'2022-11-25 08:52:37','',''),(2950,'1','285','1',1,'Retail Sale Id 2972',16834.50,0.00,0.00,24.94,623.50,'2022-11-25 09:10:24','',''),(2951,'1','285','1',1,'Retail Sale Id 2973',2760.00,0.00,0.00,3.68,368.00,'2022-11-25 09:17:08','',''),(2952,'1','285','1',1,'Retail Sale Id 2974',18900.00,0.00,0.00,28.00,700.00,'2022-11-25 09:21:44','',''),(2953,'1','285','1',1,'Retail Sale Id 2975',3000.00,0.00,0.00,4.00,400.00,'2022-11-25 09:23:49','',''),(2954,'1','285','1',1,'Retail Sale Id 2976',1500.00,0.00,0.00,2.00,200.00,'2022-11-25 09:27:12','',''),(2955,'1','285','1',1,'Retail Sale Id 2977',2250.00,0.00,0.00,3.00,300.00,'2022-11-25 09:31:04','',''),(2956,'1','285','1',1,'Retail Sale Id 2978',3000.00,0.00,0.00,4.00,400.00,'2022-11-25 09:33:18','',''),(2957,'1','285','1',1,'Retail Sale Id 2979',3000.00,0.00,0.00,4.00,400.00,'2022-11-25 09:34:06','',''),(2958,'1','285','1',1,'Retail Sale Id 2980',997.50,0.00,0.00,1.33,133.00,'2022-11-25 09:44:24','',''),(2959,'1','285','1',1,'Retail Sale Id 2981',24300.00,0.00,0.00,36.00,900.00,'2022-11-25 09:59:15','',''),(2960,'1','285','1',1,'Retail Sale Id 2982',1500.00,0.00,0.00,2.00,200.00,'2022-11-25 10:10:00','',''),(2961,'1','285','1',1,'Retail Sale Id 2983',1500.00,0.00,0.00,2.00,200.00,'2022-11-25 10:19:32','',''),(2962,'1','285','1',1,'Retail Sale Id 2984',4500.00,0.00,0.00,6.00,600.00,'2022-11-25 10:20:17','',''),(2963,'1','285','1',1,'Retail Sale Id 2985',1500.00,0.00,0.00,2.00,200.00,'2022-11-25 10:27:04','',''),(2964,'1','285','1',1,'Retail Sale Id 2986',750.00,0.00,0.00,1.00,100.00,'2022-11-25 10:36:57','',''),(2965,'1','285','1',1,'Retail Sale Id 2987',750.00,0.00,0.00,1.00,100.00,'2022-11-25 10:48:57','',''),(2966,'1','285','1',1,'Retail Sale Id 2988',750.00,0.00,0.00,1.00,100.00,'2022-11-25 10:50:05','',''),(2967,'1','285','1',1,'Retail Sale Id 2989',3750.00,0.00,0.00,5.00,500.00,'2022-11-25 10:57:47','',''),(2968,'1','285','1',1,'Retail Sale Id 2990',3000.00,0.00,0.00,4.00,400.00,'2022-11-25 11:00:08','',''),(2969,'1','285','1',1,'Retail Sale Id 2991',802.50,0.00,0.00,1.07,107.00,'2022-11-25 11:05:51','',''),(2970,'1','285','1',1,'Retail Sale Id 2992',1500.00,0.00,0.00,2.00,200.00,'2022-11-25 11:10:09','',''),(2971,'1','285','1',1,'Retail Sale Id 2993',3000.00,0.00,0.00,4.00,400.00,'2022-11-25 11:19:11','',''),(2972,'1','285','1',1,'Retail Sale Id 2994',23625.00,0.00,0.00,35.00,875.00,'2022-11-25 11:26:11','',''),(2973,'1','285','1',1,'Retail Sale Id 2995',2002.50,0.00,0.00,2.67,267.00,'2022-11-25 11:39:40','',''),(2974,'1','285','1',1,'Retail Sale Id 2996',66298.50,0.00,0.00,98.22,2455.50,'2022-11-25 11:41:53','',''),(2975,'1','285','1',1,'Retail Sale Id 2997',750.00,0.00,0.00,1.00,100.00,'2022-11-25 11:59:54','',''),(2976,'1','285','1',1,'Retail Sale Id 2998',41397.75,0.00,0.00,61.33,1533.25,'2022-11-25 12:05:31','',''),(2977,'1','285','1',1,'Retail Sale Id 2999',750.00,0.00,0.00,1.00,100.00,'2022-11-25 12:34:07','',''),(2978,'1','285','1',1,'Retail Sale Id 3000',41640.75,0.00,0.00,61.69,1542.25,'2022-11-25 12:50:07','',''),(2979,'1','285','1',1,'Retail Sale Id 3001',1500.00,0.00,0.00,2.00,200.00,'2022-11-25 13:36:11','',''),(2980,'1','285','1',1,'Retail Sale Id 3002',750.00,0.00,0.00,1.00,100.00,'2022-11-25 13:40:36','',''),(2981,'1','285','1',1,'Retail Sale Id 3003',2250.00,0.00,0.00,3.00,300.00,'2022-11-25 13:45:06','',''),(2982,'1','285','1',1,'Retail Sale Id 3004',5250.00,0.00,0.00,7.00,700.00,'2022-11-25 13:45:56','',''),(2983,'1','285','1',1,'Retail Sale Id 3005',2250.00,0.00,0.00,3.00,300.00,'2022-11-25 13:49:13','',''),(2984,'1','285','1',1,'Retail Sale Id 3007',2302.50,0.00,0.00,3.07,307.00,'2022-11-25 14:04:33','',''),(2985,'1','285','1',1,'Retail Sale Id 3008',2002.50,0.00,0.00,2.67,267.00,'2022-11-25 14:07:24','',''),(2986,'1','285','1',1,'Retail Sale Id 3009',3750.00,0.00,0.00,5.00,500.00,'2022-11-25 14:26:57','',''),(2987,'1','285','1',1,'Retail Sale Id 3010',1500.00,0.00,0.00,2.00,200.00,'2022-11-25 14:33:58','',''),(2988,'1','285','1',1,'Retail Sale Id 3011',802.50,0.00,0.00,1.07,107.00,'2022-11-25 14:35:51','',''),(2989,'1','285','1',1,'Retail Sale Id 3012',2250.00,0.00,0.00,3.00,300.00,'2022-11-25 14:39:23','',''),(2990,'1','285','1',1,'Retail Sale Id 3013',2250.00,0.00,0.00,3.00,300.00,'2022-11-25 14:48:00','',''),(2991,'1','285','1',1,'Retail Sale Id 3015',1500.00,0.00,0.00,2.00,200.00,'2022-11-25 14:51:16','',''),(2992,'1','285','1',1,'Retail Sale Id 3016',2002.50,0.00,0.00,2.67,267.00,'2022-11-25 14:56:52','',''),(2993,'1','285','1',1,'Retail Sale Id 3017',3000.00,0.00,0.00,4.00,400.00,'2022-11-25 15:30:07','',''),(2994,'1','285','1',1,'Retail Sale Id 3018',2002.50,0.00,0.00,2.67,267.00,'2022-11-25 15:31:19','',''),(2995,'1','285','1',1,'Retail Sale Id 3019',3000.00,0.00,0.00,4.00,400.00,'2022-11-25 15:41:56','',''),(2996,'1','285','1',1,'Retail Sale Id 3020',1500.00,0.00,0.00,2.00,200.00,'2022-11-25 15:43:45','',''),(2997,'1','285','1',1,'Retail Sale Id 3021',2250.00,0.00,0.00,3.00,300.00,'2022-11-25 15:47:58','',''),(2998,'1','285','1',1,'Retail Sale Id 3022',5002.50,0.00,0.00,6.67,667.00,'2022-11-25 15:53:39','',''),(2999,'1','285','1',1,'Retail Sale Id 3023',750.00,0.00,0.00,1.00,100.00,'2022-11-25 15:58:00','',''),(3000,'1','285','1',1,'Retail Sale Id 3024',1500.00,0.00,0.00,2.00,200.00,'2022-11-25 16:02:40','',''),(3001,'1','285','1',1,'Retail Sale Id 3025',3997.50,0.00,0.00,5.33,533.00,'2022-11-25 16:03:38','',''),(3002,'1','285','1',1,'Retail Sale Id 3026',8250.00,0.00,0.00,11.00,1100.00,'2022-11-25 16:08:38','',''),(3003,'1','285','1',1,'Retail Sale Id 3027',3000.00,0.00,0.00,4.00,400.00,'2022-11-25 16:22:02','',''),(3004,'1','285','1',1,'Retail Sale Id 3028',802.50,0.00,0.00,1.07,107.00,'2022-11-25 16:29:51','',''),(3005,'1','285','1',1,'Retail Sale Id 3029',1500.00,0.00,0.00,2.00,200.00,'2022-11-25 16:31:05','',''),(3006,'1','285','1',1,'Retail Sale Id 3031',51752.25,0.00,0.00,76.67,1916.75,'2022-11-25 16:41:50','',''),(3007,'1','285','1',1,'Retail Sale Id 3032',40500.00,0.00,0.00,60.00,1500.00,'2022-11-25 16:50:09','',''),(3008,'1','285','1',1,'Retail Sale Id 3034',750.00,0.00,0.00,1.00,100.00,'2022-11-25 17:02:26','',''),(3009,'1','285','1',1,'Retail Sale Id 3035',12435.00,0.00,0.00,16.58,1658.00,'2022-11-25 18:46:02','',''),(3010,'1','285','1',1,'Retail Sale Id 3036',750.00,0.00,0.00,1.00,100.00,'2022-11-26 10:20:09','',''),(3011,'1','285','1',1,'Retail Sale Id 3037',3750.00,0.00,0.00,5.00,500.00,'2022-11-26 10:20:53','',''),(3012,'1','285','1',1,'Retail Sale Id 3038',3000.00,0.00,0.00,4.00,400.00,'2022-11-26 10:21:37','',''),(3013,'1','285','1',1,'Retail Sale Id 3039',1500.00,0.00,0.00,2.00,200.00,'2022-11-26 10:22:20','',''),(3014,'1','285','1',1,'Retail Sale Id 3040',2250.00,0.00,0.00,3.00,300.00,'2022-11-26 10:23:02','',''),(3015,'1','285','1',1,'Retail Sale Id 3041',3000.00,0.00,0.00,4.00,400.00,'2022-11-26 10:23:45','',''),(3016,'1','285','1',1,'Retail Sale Id 3042',6000.00,0.00,0.00,8.00,800.00,'2022-11-26 10:24:56','',''),(3017,'1','285','1',1,'Retail Sale Id 3043',750.00,0.00,0.00,1.00,100.00,'2022-11-26 10:25:57','',''),(3018,'1','285','1',1,'Retail Sale Id 3044',750.00,0.00,0.00,1.00,100.00,'2022-11-26 10:26:34','',''),(3019,'1','285','1',1,'Retail Sale Id 3045',2497.50,0.00,0.00,3.33,333.00,'2022-11-26 10:27:23','',''),(3020,'1','285','1',1,'Retail Sale Id 3046',2002.50,0.00,0.00,2.67,267.00,'2022-11-26 10:28:23','',''),(3021,'1','285','1',1,'Retail Sale Id 3047',802.50,0.00,0.00,1.07,107.00,'2022-11-26 10:29:08','',''),(3022,'1','285','1',1,'Retail Sale Id 3048',3000.00,0.00,0.00,4.00,400.00,'2022-11-26 10:29:47','',''),(3023,'1','285','1',1,'Retail Sale Id 3049',802.50,0.00,0.00,1.07,107.00,'2022-11-26 10:30:34','',''),(3024,'1','285','1',1,'Retail Sale Id 3050',802.50,0.00,0.00,1.07,107.00,'2022-11-26 10:31:15','',''),(3025,'1','285','1',1,'Retail Sale Id 3051',2632.50,0.00,0.00,3.51,351.00,'2022-11-26 10:32:31','',''),(3026,'1','285','1',1,'Retail Sale Id 3052',2250.00,0.00,0.00,3.00,300.00,'2022-11-26 10:33:12','',''),(3027,'1','285','1',1,'Retail Sale Id 3053',1995.00,0.00,0.00,2.66,266.00,'2022-11-26 10:34:16','',''),(3028,'1','285','1',1,'Retail Sale Id 3054',19905.75,0.00,0.00,29.49,737.25,'2022-11-26 10:35:51','',''),(3029,'1','285','1',1,'Retail Sale Id 3055',1297.50,0.00,0.00,1.73,173.00,'2022-11-26 10:39:32','',''),(3030,'1','285','1',1,'Retail Sale Id 3056',750.00,0.00,0.00,1.00,100.00,'2022-11-26 10:40:30','',''),(3031,'1','285','1',1,'Retail Sale Id 3057',1500.00,0.00,0.00,2.00,200.00,'2022-11-26 10:41:32','',''),(3032,'1','285','1',1,'Retail Sale Id 3058',750.00,0.00,0.00,1.00,100.00,'2022-11-26 10:42:09','',''),(3033,'1','285','1',1,'Retail Sale Id 3059',1500.00,0.00,0.00,2.00,200.00,'2022-11-26 10:42:50','',''),(3034,'1','285','1',1,'Retail Sale Id 3060',750.00,0.00,0.00,1.00,100.00,'2022-11-26 10:43:31','',''),(3035,'1','285','1',1,'Retail Sale Id 3061',802.50,0.00,0.00,1.07,107.00,'2022-11-26 10:45:07','',''),(3036,'1','285','1',1,'Retail Sale Id 3062',2197.50,0.00,0.00,2.93,293.00,'2022-11-26 10:46:21','',''),(3037,'1','285','1',1,'Retail Sale Id 3063',41850.00,0.00,0.00,62.00,1550.00,'2022-11-26 10:48:01','',''),(3038,'1','285','1',1,'Retail Sale Id 3064',41802.75,0.00,0.00,61.93,1548.25,'2022-11-26 10:48:55','',''),(3039,'1','285','1',1,'Retail Sale Id 3065',39150.00,0.00,0.00,58.00,1450.00,'2022-11-26 10:49:45','',''),(3040,'1','285','1',1,'Retail Sale Id 3066',12048.75,0.00,0.00,17.85,446.25,'2022-11-26 10:50:36','',''),(3041,'1','285','1',1,'Retail Sale Id 3067',40500.00,0.00,0.00,60.00,1500.00,'2022-11-26 10:52:37','',''),(3042,'1','285','1',1,'Retail Sale Id 3068',32400.00,0.00,0.00,48.00,1200.00,'2022-11-26 10:55:05','',''),(3043,'1','285','1',1,'Retail Sale Id 3069',41816.25,0.00,0.00,61.95,1548.75,'2022-11-26 10:56:05','',''),(3044,'1','285','1',1,'Retail Sale Id 3070',19237.50,0.00,0.00,28.50,712.50,'2022-11-26 10:56:56','',''),(3045,'1','285','1',1,'Retail Sale Id 3071',15375.00,0.00,0.00,20.50,2050.00,'2022-11-26 11:00:29','',''),(3046,'1','285','1',1,'Retail Sale Id 3072',1500.00,0.00,0.00,2.00,200.00,'2022-11-26 11:19:44','',''),(3047,'1','285','1',1,'Retail Sale Id 3073',38265.75,0.00,0.00,56.69,1417.25,'2022-11-26 11:24:13','',''),(3048,'1','285','1',1,'Retail Sale Id 3074',802.50,0.00,0.00,1.07,107.00,'2022-11-26 11:26:52','',''),(3049,'1','285','1',1,'Retail Sale Id 3075',3750.00,0.00,0.00,5.00,500.00,'2022-11-26 11:32:10','',''),(3050,'1','285','1',1,'Retail Sale Id 3076',3802.50,0.00,0.00,5.07,507.00,'2022-11-26 11:34:07','',''),(3051,'1','285','1',1,'Retail Sale Id 3077',2250.00,0.00,0.00,3.00,300.00,'2022-11-26 11:38:21','',''),(3052,'1','285','1',1,'Retail Sale Id 3078',3750.00,0.00,0.00,5.00,500.00,'2022-11-26 11:58:13','',''),(3053,'1','285','1',1,'Retail Sale Id 3080',750.00,0.00,0.00,1.00,100.00,'2022-11-26 11:59:30','',''),(3054,'1','285','1',1,'Retail Sale Id 3081',2250.00,0.00,0.00,3.00,300.00,'2022-11-26 12:03:21','',''),(3055,'1','285','1',1,'Retail Sale Id 3082',997.50,0.00,0.00,1.33,133.00,'2022-11-26 12:04:11','',''),(3056,'1','285','1',1,'Retail Sale Id 3083',1500.00,0.00,0.00,2.00,200.00,'2022-11-26 12:11:30','',''),(3057,'1','285','1',1,'Retail Sale Id 3084',3750.00,0.00,0.00,5.00,500.00,'2022-11-26 12:15:11','',''),(3058,'1','285','1',1,'Retail Sale Id 3085',997.50,0.00,0.00,1.33,133.00,'2022-11-26 12:25:08','',''),(3059,'1','285','1',1,'Retail Sale Id 3086',997.50,0.00,0.00,1.33,133.00,'2022-11-26 12:46:54','',''),(3060,'1','285','1',1,'Retail Sale Id 3087',1297.50,0.00,0.00,1.73,173.00,'2022-11-26 13:24:36','',''),(3061,'1','285','1',1,'Retail Sale Id 3088',997.50,0.00,0.00,1.33,133.00,'2022-11-26 13:28:54','',''),(3062,'1','285','1',1,'Retail Sale Id 3089',3000.00,0.00,0.00,4.00,400.00,'2022-11-26 13:29:57','',''),(3063,'1','285','1',1,'Retail Sale Id 3090',11832.75,0.00,0.00,17.53,438.25,'2022-11-26 13:35:00','',''),(3064,'1','285','1',1,'Retail Sale Id 3091',43875.00,0.00,0.00,65.00,1625.00,'2022-11-26 13:43:51','',''),(3065,'1','285','1',1,'Retail Sale Id 3092',750.00,0.00,0.00,1.00,100.00,'2022-11-26 14:18:24','',''),(3066,'1','285','1',1,'Retail Sale Id 3093',750.00,0.00,0.00,1.00,100.00,'2022-11-26 14:25:12','',''),(3067,'1','285','1',1,'Retail Sale Id 3094',802.50,0.00,0.00,1.07,107.00,'2022-11-26 14:29:25','',''),(3068,'1','285','1',1,'Retail Sale Id 3095',2250.00,0.00,0.00,3.00,300.00,'2022-11-26 14:31:19','',''),(3069,'1','285','1',1,'Retail Sale Id 3096',750.00,0.00,0.00,1.00,100.00,'2022-11-26 14:37:04','',''),(3070,'1','285','1',1,'Retail Sale Id 3097',2250.00,0.00,0.00,3.00,300.00,'2022-11-26 14:37:55','',''),(3071,'1','285','1',1,'Retail Sale Id 3098',81972.00,0.00,0.00,121.44,3036.00,'2022-11-26 14:39:49','',''),(3072,'1','285','1',1,'Retail Sale Id 3099',24300.00,0.00,0.00,36.00,900.00,'2022-11-26 14:41:01','',''),(3073,'1','285','1',1,'Retail Sale Id 3100',1500.00,0.00,0.00,2.00,200.00,'2022-11-26 14:46:40','',''),(3074,'1','285','1',1,'Retail Sale Id 3101',30091.50,0.00,0.00,44.58,1114.50,'2022-11-26 16:12:44','',''),(3075,'1','285','1',1,'Retail Sale Id 3102',3000.00,0.00,0.00,4.00,400.00,'2022-11-26 16:22:06','',''),(3076,'1','285','1',1,'Retail Sale Id 3103',4500.00,0.00,0.00,6.00,600.00,'2022-11-26 16:23:41','',''),(3077,'1','285','1',1,'Retail Sale Id 3104',2250.00,0.00,0.00,3.00,300.00,'2022-11-26 16:25:13','',''),(3078,'1','285','1',1,'Retail Sale Id 3106',1500.00,0.00,0.00,2.00,200.00,'2022-11-26 16:49:04','',''),(3079,'1','285','1',1,'Retail Sale Id 3107',750.00,0.00,0.00,1.00,100.00,'2022-11-26 16:56:07','',''),(3080,'1','285','1',1,'Retail Sale Id 3108',1500.00,0.00,0.00,2.00,200.00,'2022-11-26 17:04:07','',''),(3081,'1','285','1',1,'Retail Sale Id 3109',7681.50,0.00,0.00,11.38,284.50,'2022-11-26 17:05:59','',''),(3082,'1','285','1',1,'Retail Sale Id 3110',2625.00,0.00,0.00,3.50,350.00,'2022-11-26 17:24:27','',''),(3083,'1','285','1',1,'Retail Sale Id 3111',1500.00,0.00,0.00,2.00,200.00,'2022-11-27 07:18:11','',''),(3084,'1','285','1',1,'Retail Sale Id 3112',5250.00,0.00,0.00,7.00,700.00,'2022-11-27 07:19:05','',''),(3085,'1','285','1',1,'Retail Sale Id 3113',1500.00,0.00,0.00,2.00,200.00,'2022-11-27 07:20:38','',''),(3086,'1','285','1',1,'Retail Sale Id 3114',1500.00,0.00,0.00,2.00,200.00,'2022-11-27 07:21:20','',''),(3087,'1','285','1',1,'Retail Sale Id 3115',1500.00,0.00,0.00,2.00,200.00,'2022-11-27 07:28:32','',''),(3088,'1','285','1',1,'Retail Sale Id 3116',1402.50,0.00,0.00,1.87,187.00,'2022-11-27 07:30:47','',''),(3089,'1','285','1',1,'Return of Retail Sale Id 3115',0.00,1500.00,2.00,0.00,-200.00,'2022-11-27 07:33:10','',''),(3090,'1','285','1',1,'Retail Sale Id 3117',1500.00,0.00,0.00,2.00,200.00,'2022-11-27 07:33:51','',''),(3091,'1','285','1',1,'Retail Sale Id 3119',2497.50,0.00,0.00,3.33,333.00,'2022-11-27 07:36:56','',''),(3092,'1','285','1',1,'Retail Sale Id 3120',3000.00,0.00,0.00,4.00,400.00,'2022-11-27 07:37:51','',''),(3093,'1','285','1',1,'Retail Sale Id 3121',2250.00,0.00,0.00,3.00,300.00,'2022-11-27 07:41:35','',''),(3094,'1','285','1',1,'Retail Sale Id 3123',750.00,0.00,0.00,1.00,100.00,'2022-11-27 07:42:14','',''),(3095,'1','285','1',1,'Retail Sale Id 3125',750.00,0.00,0.00,1.00,100.00,'2022-11-27 07:45:48','',''),(3096,'1','285','1',1,'Retail Sale Id 3126',3000.00,0.00,0.00,4.00,400.00,'2022-11-27 07:46:38','',''),(3097,'1','285','1',1,'Retail Sale Id 3127',1500.00,0.00,0.00,2.00,200.00,'2022-11-27 07:48:15','',''),(3098,'1','285','1',1,'Retail Sale Id 3128',802.50,0.00,0.00,1.07,107.00,'2022-11-27 07:49:50','',''),(3099,'1','285','1',1,'Retail Sale Id 3129',3000.00,0.00,0.00,4.00,400.00,'2022-11-27 07:50:46','',''),(3100,'1','285','1',1,'Retail Sale Id 3130',2250.00,0.00,0.00,3.00,300.00,'2022-11-27 07:51:38','',''),(3101,'1','285','1',1,'Retail Sale Id 3131',750.00,0.00,0.00,1.00,100.00,'2022-11-27 07:52:55','',''),(3102,'1','285','1',1,'Retail Sale Id 3132',33750.00,0.00,0.00,50.00,1250.00,'2022-11-27 07:53:57','',''),(3103,'1','285','1',1,'Retail Sale Id 3133',750.00,0.00,0.00,1.00,100.00,'2022-11-27 07:59:06','',''),(3104,'1','285','1',1,'Retail Sale Id 3134',3000.00,0.00,0.00,4.00,400.00,'2022-11-27 08:04:54','',''),(3105,'1','285','1',1,'Retail Sale Id 3135',12062.25,0.00,0.00,17.87,446.75,'2022-11-27 08:18:29','',''),(3106,'1','285','1',1,'Retail Sale Id 3136',1500.00,0.00,0.00,2.00,200.00,'2022-11-27 08:23:09','',''),(3107,'1','285','1',1,'Retail Sale Id 3137',750.00,0.00,0.00,1.00,100.00,'2022-11-27 08:24:33','',''),(3108,'1','285','1',1,'Retail Sale Id 3138',997.50,0.00,0.00,1.33,133.00,'2022-11-27 08:25:27','',''),(3109,'1','285','1',1,'Retail Sale Id 3139',16875.00,0.00,0.00,25.00,625.00,'2022-11-27 08:30:23','',''),(3110,'1','285','1',1,'Retail Sale Id 3140',750.00,0.00,0.00,1.00,100.00,'2022-11-27 08:31:54','',''),(3111,'1','285','1',1,'Retail Sale Id 3141',33743.25,0.00,0.00,49.99,1249.75,'2022-11-27 08:36:49','',''),(3112,'1','285','1',1,'Retail Sale Id 3142',1500.00,0.00,0.00,2.00,200.00,'2022-11-27 08:44:21','',''),(3113,'1','285','1',1,'Retail Sale Id 3143',750.00,0.00,0.00,1.00,100.00,'2022-11-27 08:47:56','',''),(3114,'1','285','1',1,'Retail Sale Id 3144',2002.50,0.00,0.00,2.67,267.00,'2022-11-27 08:48:59','',''),(3115,'1','285','1',1,'Retail Sale Id 3145',40830.75,0.00,0.00,60.49,1512.25,'2022-11-27 08:59:05','',''),(3116,'1','285','1',1,'Retail Sale Id 3146',2250.00,0.00,0.00,3.00,300.00,'2022-11-27 09:02:05','',''),(3117,'1','285','1',1,'Retail Sale Id 3147',2100.00,0.00,0.00,2.80,280.00,'2022-11-27 09:03:10','',''),(3118,'1','285','1',1,'Retail Sale Id 3148',2250.00,0.00,0.00,3.00,300.00,'2022-11-27 09:08:12','',''),(3119,'1','285','1',1,'Retail Sale Id 3149',1500.00,0.00,0.00,2.00,200.00,'2022-11-27 09:09:00','',''),(3120,'1','285','1',1,'Retail Sale Id 3150',750.00,0.00,0.00,1.00,100.00,'2022-11-27 09:29:51','',''),(3121,'1','285','1',1,'Retail Sale Id 3152',750.00,0.00,0.00,1.00,100.00,'2022-11-27 09:30:41','',''),(3122,'1','285','1',1,'Retail Sale Id 3153',1500.00,0.00,0.00,2.00,200.00,'2022-11-27 09:36:20','',''),(3123,'1','285','1',1,'Retail Sale Id 3154',41586.75,0.00,0.00,61.61,1540.25,'2022-11-27 09:38:41','',''),(3124,'1','285','1',1,'Retail Sale Id 3155',1500.00,0.00,0.00,2.00,200.00,'2022-11-27 10:00:27','',''),(3125,'1','285','1',1,'Retail Sale Id 3156',1500.00,0.00,0.00,2.00,200.00,'2022-11-27 10:11:53','',''),(3126,'1','285','1',1,'Retail Sale Id 3157',1500.00,0.00,0.00,2.00,200.00,'2022-11-27 10:18:30','',''),(3127,'1','285','1',1,'Retail Sale Id 3158',750.00,0.00,0.00,1.00,100.00,'2022-11-27 10:19:17','',''),(3128,'1','285','1',1,'Retail Sale Id 3159',3000.00,0.00,0.00,4.00,400.00,'2022-11-27 10:21:43','',''),(3129,'1','285','1',1,'Retail Sale Id 3160',997.50,0.00,0.00,1.33,133.00,'2022-11-27 10:53:22','',''),(3130,'1','285','1',1,'Retail Sale Id 3161',2250.00,0.00,0.00,3.00,300.00,'2022-11-27 10:57:18','',''),(3131,'1','285','1',1,'Retail Sale Id 3162',46251.00,0.00,0.00,68.52,1713.00,'2022-11-27 11:02:59','',''),(3132,'1','285','1',1,'Retail Sale Id 3163',802.50,0.00,0.00,1.07,107.00,'2022-11-27 11:05:24','',''),(3133,'1','285','1',1,'Retail Sale Id 3164',750.00,0.00,0.00,1.00,100.00,'2022-11-27 11:43:05','',''),(3134,'1','285','1',1,'Retail Sale Id 3165',1500.00,0.00,0.00,2.00,200.00,'2022-11-27 11:56:05','',''),(3135,'1','285','1',1,'Retail Sale Id 3166',1500.00,0.00,0.00,2.00,200.00,'2022-11-27 12:02:13','',''),(3136,'1','285','1',1,'Retail Sale Id 3167',41357.25,0.00,0.00,61.27,1531.75,'2022-11-27 12:31:15','',''),(3137,'1','285','1',1,'Retail Sale Id 3168',3000.00,0.00,0.00,4.00,400.00,'2022-11-27 12:34:56','',''),(3138,'1','285','1',1,'Retail Sale Id 3169',2250.00,0.00,0.00,3.00,300.00,'2022-11-27 12:43:02','',''),(3139,'1','285','1',1,'Retail Sale Id 3170',1500.00,0.00,0.00,2.00,200.00,'2022-11-27 13:28:25','',''),(3140,'1','285','1',1,'Retail Sale Id 3171',750.00,0.00,0.00,1.00,100.00,'2022-11-27 13:29:44','',''),(3141,'1','285','1',1,'Retail Sale Id 3172',3000.00,0.00,0.00,4.00,400.00,'2022-11-27 13:37:48','',''),(3142,'1','285','1',1,'Retail Sale Id 3173',2002.50,0.00,0.00,2.67,267.00,'2022-11-27 13:38:39','',''),(3143,'1','285','1',1,'Retail Sale Id 3174',1500.00,0.00,0.00,2.00,200.00,'2022-11-27 13:39:27','',''),(3144,'1','285','1',1,'Retail Sale Id 3175',997.50,0.00,0.00,1.33,133.00,'2022-11-27 13:51:11','',''),(3145,'1','285','1',1,'Retail Sale Id 3176',3000.00,0.00,0.00,4.00,400.00,'2022-11-27 14:00:37','',''),(3146,'1','285','1',1,'Retail Sale Id 3177',1500.00,0.00,0.00,2.00,200.00,'2022-11-27 14:10:06','',''),(3147,'1','285','1',1,'Retail Sale Id 3178',16686.00,0.00,0.00,24.72,618.00,'2022-11-27 14:16:35','',''),(3148,'1','285','1',1,'Retail Sale Id 3179',997.50,0.00,0.00,1.33,133.00,'2022-11-27 14:31:39','',''),(3149,'1','285','1',1,'Retail Sale Id 3180',3000.00,0.00,0.00,4.00,400.00,'2022-11-27 14:32:42','',''),(3150,'1','285','1',1,'Retail Sale Id 3181',2002.50,0.00,0.00,2.67,267.00,'2022-11-27 15:11:16','',''),(3151,'1','285','1',1,'Retail Sale Id 3182',2250.00,0.00,0.00,3.00,300.00,'2022-11-27 15:40:52','',''),(3152,'1','285','1',1,'Retail Sale Id 3183',12055.50,0.00,0.00,17.86,446.50,'2022-11-27 15:43:16','',''),(3153,'1','285','1',1,'Retail Sale Id 3184',750.00,0.00,0.00,1.00,100.00,'2022-11-27 15:47:37','',''),(3154,'1','285','1',1,'Retail Sale Id 3185',36450.00,0.00,0.00,54.00,1350.00,'2022-11-27 15:51:44','',''),(3155,'1','285','1',1,'Retail Sale Id 3186',8100.00,0.00,0.00,12.00,300.00,'2022-11-27 16:10:02','',''),(3156,'1','285','1',1,'Retail Sale Id 3187',1500.00,0.00,0.00,2.00,200.00,'2022-11-27 16:11:26','',''),(3157,'1','285','1',1,'Retail Sale Id 3188',1500.00,0.00,0.00,2.00,200.00,'2022-11-27 16:14:45','',''),(3158,'1','285','1',1,'Retail Sale Id 3189',40500.00,0.00,0.00,60.00,1500.00,'2022-11-27 16:17:08','',''),(3159,'1','285','1',1,'Retail Sale Id 3190',802.50,0.00,0.00,1.07,107.00,'2022-11-27 16:18:53','',''),(3160,'1','285','1',1,'Retail Sale Id 3191',32325.75,0.00,0.00,47.89,1197.25,'2022-11-27 16:22:06','',''),(3161,'1','285','1',1,'Retail Sale Id 3192',2250.00,0.00,0.00,3.00,300.00,'2022-11-27 16:37:55','',''),(3162,'1','285','1',1,'Retail Sale Id 3193',9750.00,0.00,0.00,13.00,1300.00,'2022-11-27 16:41:34','',''),(3163,'1','285','1',1,'Retail Sale Id 3194',3000.00,0.00,0.00,4.00,400.00,'2022-11-27 16:43:52','',''),(3164,'1','285','1',1,'Retail Sale Id 3195',750.00,0.00,0.00,1.00,100.00,'2022-11-27 16:50:35','',''),(3165,'1','285','1',1,'Retail Sale Id 3196',3750.00,0.00,0.00,5.00,500.00,'2022-11-27 17:50:27','',''),(3166,'1','285','1',1,'Return of Retail Sale Id 3186',0.00,8100.00,12.00,0.00,-300.00,'2022-11-27 17:55:44','',''),(3167,'1','285','1',1,'Retail Sale Id 3197',4725.00,0.00,0.00,7.00,175.00,'2022-11-27 17:56:42','',''),(3168,'1','285','1',1,'Retail Sale Id 3198',12116.25,0.00,0.00,17.95,448.75,'2022-11-28 07:25:51','',''),(3169,'1','285','1',1,'Retail Sale Id 3199',2002.50,0.00,0.00,2.67,267.00,'2022-11-28 07:26:51','',''),(3170,'1','285','1',1,'Retail Sale Id 3200',802.50,0.00,0.00,1.07,107.00,'2022-11-28 07:28:08','',''),(3171,'1','285','1',1,'Retail Sale Id 3201',2302.50,0.00,0.00,3.07,307.00,'2022-11-28 07:29:20','',''),(3172,'1','285','1',1,'Retail Sale Id 3202',11927.25,0.00,0.00,17.67,441.75,'2022-11-28 07:32:04','',''),(3173,'1','285','1',1,'Retail Sale Id 3203',2497.50,0.00,0.00,3.33,333.00,'2022-11-28 07:34:47','',''),(3174,'1','285','1',1,'Retail Sale Id 3204',3000.00,0.00,0.00,4.00,400.00,'2022-11-28 07:35:41','',''),(3175,'1','285','1',1,'Retail Sale Id 3205',3000.00,0.00,0.00,4.00,400.00,'2022-11-28 07:38:21','',''),(3176,'1','285','1',1,'Retail Sale Id 3206',1297.50,0.00,0.00,1.73,173.00,'2022-11-28 07:39:12','',''),(3177,'1','285','1',1,'Retail Sale Id 3207',45056.25,0.00,0.00,66.75,1668.75,'2022-11-28 07:40:52','',''),(3178,'1','285','1',1,'Retail Sale Id 3208',1500.00,0.00,0.00,2.00,200.00,'2022-11-28 07:48:11','',''),(3179,'1','285','1',1,'Retail Sale Id 3209',3000.00,0.00,0.00,4.00,400.00,'2022-11-28 07:56:10','',''),(3180,'1','285','1',1,'Retail Sale Id 3210',1500.00,0.00,0.00,2.00,200.00,'2022-11-28 07:56:58','',''),(3181,'1','285','1',1,'Retail Sale Id 3211',2497.50,0.00,0.00,3.33,333.00,'2022-11-28 07:58:15','',''),(3182,'1','285','1',1,'Retail Sale Id 3212',997.50,0.00,0.00,1.33,133.00,'2022-11-28 08:14:52','',''),(3183,'1','285','1',1,'Retail Sale Id 3213',6000.00,0.00,0.00,8.00,800.00,'2022-11-28 08:24:34','',''),(3184,'1','285','1',1,'Retail Sale Id 3214',997.50,0.00,0.00,1.33,133.00,'2022-11-28 08:29:36','',''),(3185,'1','285','1',1,'Retail Sale Id 3215',2250.00,0.00,0.00,3.00,300.00,'2022-11-28 08:30:42','',''),(3186,'1','285','1',1,'Retail Sale Id 3216',52386.75,0.00,0.00,77.61,1940.25,'2022-11-28 08:37:00','',''),(3187,'1','285','1',1,'Retail Sale Id 3217',89309.25,0.00,0.00,132.31,3307.75,'2022-11-28 08:39:56','',''),(3188,'1','285','1',1,'Retail Sale Id 3218',43267.50,0.00,0.00,64.10,1602.50,'2022-11-28 08:43:48','',''),(3189,'1','285','1',1,'Retail Sale Id 3219',1500.00,0.00,0.00,2.00,200.00,'2022-11-28 08:44:51','',''),(3190,'1','285','1',1,'Retail Sale Id 3221',40500.00,0.00,0.00,60.00,1500.00,'2022-11-28 08:48:10','',''),(3191,'1','285','1',1,'Retail Sale Id 3223',2002.50,0.00,0.00,2.67,267.00,'2022-11-28 08:53:21','',''),(3192,'1','285','1',1,'Retail Sale Id 3224',51300.00,0.00,0.00,76.00,1900.00,'2022-11-28 08:56:00','',''),(3193,'1','285','1',1,'Retail Sale Id 3225',2250.00,0.00,0.00,3.00,300.00,'2022-11-28 08:59:51','',''),(3194,'1','285','1',1,'Retail Sale Id 3222',41161.50,0.00,0.00,60.98,1524.50,'2022-11-28 09:03:14','',''),(3195,'1','285','1',1,'Retail Sale Id 3226',1500.00,0.00,0.00,2.00,200.00,'2022-11-28 09:04:25','',''),(3196,'1','285','1',1,'Retail Sale Id 3227',1500.00,0.00,0.00,2.00,200.00,'2022-11-28 09:09:53','',''),(3197,'1','285','1',1,'Retail Sale Id 3228',802.50,0.00,0.00,1.07,107.00,'2022-11-28 09:21:01','',''),(3198,'1','285','1',1,'Retail Sale Id 3229',14850.00,0.00,0.00,22.00,550.00,'2022-11-28 09:27:55','',''),(3199,'1','285','1',1,'Retail Sale Id 3230',750.00,0.00,0.00,1.00,100.00,'2022-11-28 09:30:54','',''),(3200,'1','285','1',1,'Retail Sale Id 3231',10500.00,0.00,0.00,14.00,1400.00,'2022-11-28 09:35:42','',''),(3201,'1','285','1',1,'Retail Sale Id 3232',1500.00,0.00,0.00,2.00,200.00,'2022-11-28 09:39:51','',''),(3202,'1','285','1',1,'Retail Sale Id 3233',1500.00,0.00,0.00,2.00,200.00,'2022-11-28 09:41:27','',''),(3203,'1','285','1',1,'Retail Sale Id 3234',1500.00,0.00,0.00,2.00,200.00,'2022-11-28 09:42:33','',''),(3204,'1','285','1',1,'Retail Sale Id 3235',3000.00,0.00,0.00,4.00,400.00,'2022-11-28 09:43:36','',''),(3205,'1','285','1',1,'Retail Sale Id 3236',45346.50,0.00,0.00,67.18,1679.50,'2022-11-28 09:58:29','',''),(3206,'1','285','1',1,'Retail Sale Id 3237',1500.00,0.00,0.00,2.00,200.00,'2022-11-28 10:05:07','',''),(3207,'1','285','1',1,'Retail Sale Id 3238',5250.00,0.00,0.00,7.00,700.00,'2022-11-28 10:07:48','',''),(3208,'1','285','1',1,'Retail Sale Id 3239',45204.75,0.00,0.00,66.97,1674.25,'2022-11-28 10:20:00','',''),(3209,'1','285','1',1,'Retail Sale Id 3241',2497.50,0.00,0.00,3.33,333.00,'2022-11-28 10:26:50','',''),(3210,'1','285','1',1,'Retail Sale Id 3242',750.00,0.00,0.00,1.00,100.00,'2022-11-28 10:35:05','',''),(3211,'1','285','1',1,'Retail Sale Id 3243',2250.00,0.00,0.00,3.00,300.00,'2022-11-28 10:38:47','',''),(3212,'1','285','1',1,'Retail Sale Id 3244',4500.00,0.00,0.00,6.00,600.00,'2022-11-28 10:39:30','',''),(3213,'1','285','1',1,'Retail Sale Id 3245',22275.00,0.00,0.00,33.00,825.00,'2022-11-28 10:43:45','',''),(3214,'1','285','1',1,'Retail Sale Id 3246',750.00,0.00,0.00,1.00,100.00,'2022-11-28 10:49:36','',''),(3215,'1','285','1',1,'Retail Sale Id 3247',1500.00,0.00,0.00,2.00,200.00,'2022-11-28 11:06:09','',''),(3216,'1','285','1',1,'Retail Sale Id 3248',1500.00,0.00,0.00,2.00,200.00,'2022-11-28 11:07:59','',''),(3217,'1','285','1',1,'Retail Sale Id 3249',1500.00,0.00,0.00,2.00,200.00,'2022-11-28 11:34:03','',''),(3218,'1','285','1',1,'Retail Sale Id 3250',41681.25,0.00,0.00,61.75,1543.75,'2022-11-28 11:36:41','',''),(3219,'1','285','1',1,'Retail Sale Id 3251',1500.00,0.00,0.00,2.00,200.00,'2022-11-28 12:06:26','',''),(3220,'1','285','1',1,'Retail Sale Id 3252',1500.00,0.00,0.00,2.00,200.00,'2022-11-28 12:09:10','',''),(3221,'1','285','1',1,'Retail Sale Id 3253',27000.00,0.00,0.00,40.00,1000.00,'2022-11-28 12:21:25','',''),(3222,'1','285','1',1,'Retail Sale Id 3254',34852.50,0.00,0.00,46.47,4647.00,'2022-11-28 17:53:34','',''),(3223,'1','285','1',1,'Retail Sale Id 3255',131874.75,0.00,0.00,195.37,4884.25,'2022-11-28 17:55:55','',''),(3224,'1','285','1',1,'Retail Sale Id 3256',40500.00,0.00,0.00,60.00,1500.00,'2022-11-29 07:07:52','',''),(3225,'1','285','1',1,'Retail Sale Id 3257',4500.00,0.00,0.00,6.00,600.00,'2022-11-29 07:11:07','',''),(3226,'1','285','1',1,'Retail Sale Id 3258',12028.50,0.00,0.00,17.82,445.50,'2022-11-29 07:12:49','',''),(3227,'1','285','1',1,'Retail Sale Id 3259',16301.25,0.00,0.00,24.15,603.75,'2022-11-29 07:16:05','',''),(3228,'1','285','1',1,'Retail Sale Id 3260',750.00,0.00,0.00,1.00,100.00,'2022-11-29 07:19:18','',''),(3229,'1','285','1',1,'Retail Sale Id 3261',2002.50,0.00,0.00,2.67,267.00,'2022-11-29 07:20:55','',''),(3230,'1','285','1',1,'Retail Sale Id 3262',997.50,0.00,0.00,1.33,133.00,'2022-11-29 07:22:05','',''),(3231,'1','285','1',1,'Retail Sale Id 3263',1500.00,0.00,0.00,2.00,200.00,'2022-11-29 07:23:13','',''),(3232,'1','285','1',1,'Retail Sale Id 3264',750.00,0.00,0.00,1.00,100.00,'2022-11-29 07:24:06','',''),(3233,'1','285','1',1,'Retail Sale Id 3265',2002.50,0.00,0.00,2.67,267.00,'2022-11-29 07:25:08','',''),(3234,'1','285','1',1,'Retail Sale Id 3266',3000.00,0.00,0.00,4.00,400.00,'2022-11-29 07:25:54','',''),(3235,'1','285','1',1,'Retail Sale Id 3267',2250.00,0.00,0.00,3.00,300.00,'2022-11-29 07:34:42','',''),(3236,'1','285','1',1,'Retail Sale Id 3268',750.00,0.00,0.00,1.00,100.00,'2022-11-29 07:36:53','',''),(3237,'1','285','1',1,'Retail Sale Id 3269',2002.50,0.00,0.00,2.67,267.00,'2022-11-29 07:38:24','',''),(3238,'1','285','1',1,'Retail Sale Id 3270',750.00,0.00,0.00,1.00,100.00,'2022-11-29 07:39:26','',''),(3239,'1','285','1',1,'Retail Sale Id 3271',40500.00,0.00,0.00,60.00,1500.00,'2022-11-29 08:01:18','',''),(3240,'1','285','1',1,'Retail Sale Id 3272',92198.25,0.00,0.00,136.59,3414.75,'2022-11-29 08:06:31','',''),(3241,'1','285','1',1,'Retail Sale Id 3273',27000.00,0.00,0.00,40.00,1000.00,'2022-11-29 08:10:56','',''),(3242,'1','285','1',1,'Retail Sale Id 3274',1500.00,0.00,0.00,2.00,200.00,'2022-11-29 08:13:00','',''),(3243,'1','285','1',1,'Return of Retail Sale Id 3271',0.00,40500.00,60.00,0.00,-1500.00,'2022-11-29 08:14:03','',''),(3244,'1','285','1',1,'Retail Sale Id 3275',41701.50,0.00,0.00,61.78,1544.50,'2022-11-29 08:14:57','',''),(3245,'1','285','1',1,'Retail Sale Id 3276',2002.50,0.00,0.00,2.67,267.00,'2022-11-29 08:15:59','',''),(3246,'1','285','1',1,'Retail Sale Id 3277',750.00,0.00,0.00,1.00,100.00,'2022-11-29 08:21:50','',''),(3247,'1','285','1',1,'Retail Sale Id 3278',32960.25,0.00,0.00,48.83,1220.75,'2022-11-29 08:43:36','',''),(3248,'1','285','1',1,'Retail Sale Id 3279',4500.00,0.00,0.00,6.00,600.00,'2022-11-29 08:55:04','',''),(3249,'1','285','1',1,'Retail Sale Id 3280',41222.25,0.00,0.00,61.07,1526.75,'2022-11-29 09:00:41','',''),(3250,'1','285','1',1,'Retail Sale Id 3281',1500.00,0.00,0.00,2.00,200.00,'2022-11-29 09:04:46','',''),(3251,'1','285','1',1,'Retail Sale Id 3282',8437.50,0.00,0.00,12.50,312.50,'2022-11-29 09:05:53','',''),(3252,'1','285','1',1,'Retail Sale Id 3283',750.00,0.00,0.00,1.00,100.00,'2022-11-29 09:07:20','',''),(3253,'1','285','1',1,'Retail Sale Id 3284',33750.00,0.00,0.00,50.00,1250.00,'2022-11-29 09:18:36','',''),(3254,'1','285','1',1,'Retail Sale Id 3285',802.50,0.00,0.00,1.07,107.00,'2022-11-29 09:27:29','',''),(3255,'1','285','1',1,'Retail Sale Id 3286',116289.00,0.00,0.00,172.28,4307.00,'2022-11-29 09:32:01','',''),(3256,'1','285','1',1,'Retail Sale Id 3287',1500.00,0.00,0.00,2.00,200.00,'2022-11-29 09:34:29','',''),(3257,'1','285','1',1,'Retail Sale Id 3288',16200.00,0.00,0.00,24.00,600.00,'2022-11-29 09:52:26','',''),(3258,'1','285','1',1,'Retail Sale Id 3289',1500.00,0.00,0.00,2.00,200.00,'2022-11-29 10:52:09','',''),(3259,'1','285','1',1,'Retail Sale Id 3290',2250.00,0.00,0.00,3.00,300.00,'2022-11-29 10:53:56','',''),(3260,'1','285','1',1,'Retail Sale Id 3291',3000.00,0.00,0.00,4.00,400.00,'2022-11-29 10:55:14','',''),(3261,'1','285','1',1,'Retail Sale Id 3292',40500.00,0.00,0.00,60.00,1500.00,'2022-11-29 10:56:33','',''),(3262,'1','285','1',1,'Retail Sale Id 3293',3000.00,0.00,0.00,4.00,400.00,'2022-11-29 10:57:19','',''),(3263,'1','285','1',1,'Retail Sale Id 3294',3750.00,0.00,0.00,5.00,500.00,'2022-11-29 11:05:53','',''),(3264,'1','285','1',1,'Retail Sale Id 3295',1500.00,0.00,0.00,2.00,200.00,'2022-11-29 11:16:26','',''),(3265,'1','285','1',1,'Retail Sale Id 3296',16382.25,0.00,0.00,24.27,606.75,'2022-11-29 11:19:23','',''),(3266,'1','285','1',1,'Retail Sale Id 3297',1500.00,0.00,0.00,2.00,200.00,'2022-11-29 11:46:22','',''),(3267,'1','285','1',1,'Retail Sale Id 3298',1500.00,0.00,0.00,2.00,200.00,'2022-11-29 11:47:42','',''),(3268,'1','285','1',1,'Retail Sale Id 3299',30010.50,0.00,0.00,44.46,1111.50,'2022-11-29 11:49:24','',''),(3269,'1','285','1',1,'Retail Sale Id 3300',1500.00,0.00,0.00,2.00,200.00,'2022-11-29 11:51:38','',''),(3270,'1','285','1',1,'Retail Sale Id 3301',3000.00,0.00,0.00,4.00,400.00,'2022-11-29 11:54:52','',''),(3271,'1','285','1',1,'Retail Sale Id 3302',2250.00,0.00,0.00,3.00,300.00,'2022-11-29 12:08:29','',''),(3272,'1','285','1',1,'Retail Sale Id 3303',750.00,0.00,0.00,1.00,100.00,'2022-11-29 12:09:46','',''),(3273,'1','285','1',1,'Retail Sale Id 3304',60750.00,0.00,0.00,90.00,2250.00,'2022-11-29 12:11:22','',''),(3274,'1','285','1',1,'Retail Sale Id 3305',10500.00,0.00,0.00,14.00,1400.00,'2022-11-29 12:14:40','',''),(3275,'1','285','1',1,'Retail Sale Id 3306',1500.00,0.00,0.00,2.00,200.00,'2022-11-29 12:15:54','',''),(3276,'1','285','1',1,'Retail Sale Id 3307',1500.00,0.00,0.00,2.00,200.00,'2022-11-29 12:27:56','',''),(3277,'1','285','1',1,'Retail Sale Id 3308',5250.00,0.00,0.00,7.00,700.00,'2022-11-29 12:44:13','',''),(3278,'1','285','1',1,'Retail Sale Id 3309',2250.00,0.00,0.00,3.00,300.00,'2022-11-29 12:48:25','',''),(3279,'1','285','1',1,'Retail Sale Id 3310',2250.00,0.00,0.00,3.00,300.00,'2022-11-29 12:49:26','',''),(3280,'1','285','1',1,'Retail Sale Id 3311',40601.25,0.00,0.00,60.15,1503.75,'2022-11-29 12:55:49','',''),(3281,'1','285','1',1,'Retail Sale Id 3312',1500.00,0.00,0.00,2.00,200.00,'2022-11-29 12:57:19','',''),(3282,'1','285','1',1,'Retail Sale Id 3313',750.00,0.00,0.00,1.00,100.00,'2022-11-29 12:59:10','',''),(3283,'1','285','1',1,'Retail Sale Id 3314',10010.25,0.00,0.00,14.83,370.75,'2022-11-29 13:00:20','',''),(3284,'1','285','1',1,'Retail Sale Id 3315',16510.50,0.00,0.00,24.46,611.50,'2022-11-29 13:01:43','',''),(3285,'1','285','1',1,'Retail Sale Id 3316',1500.00,0.00,0.00,2.00,200.00,'2022-11-29 13:06:19','',''),(3286,'1','285','1',1,'Retail Sale Id 3317',6000.00,0.00,0.00,8.00,800.00,'2022-11-29 13:13:09','',''),(3287,'1','285','1',1,'Retail Sale Id 3318',3000.00,0.00,0.00,4.00,400.00,'2022-11-29 13:16:07','',''),(3288,'1','285','1',1,'Retail Sale Id 3320',9375.00,0.00,0.00,12.50,1250.00,'2022-11-29 13:18:14','',''),(3289,'1','285','1',1,'Retail Sale Id 3321',4500.00,0.00,0.00,6.00,600.00,'2022-11-29 13:19:08','',''),(3290,'1','285','1',1,'Retail Sale Id 3322',3750.00,0.00,0.00,5.00,500.00,'2022-11-29 13:31:17','',''),(3291,'1','285','1',1,'Retail Sale Id 3324',43429.50,0.00,0.00,64.34,1608.50,'2022-11-29 13:35:52','',''),(3292,'1','285','1',1,'Retail Sale Id 3325',1500.00,0.00,0.00,2.00,200.00,'2022-11-29 13:45:06','',''),(3293,'1','285','1',1,'Retail Sale Id 3326',5250.00,0.00,0.00,7.00,700.00,'2022-11-29 14:13:44','',''),(3294,'1','285','1',1,'Retail Sale Id 3327',33750.00,0.00,0.00,50.00,1250.00,'2022-11-29 14:16:02','',''),(3295,'1','285','1',1,'Retail Sale Id 3328',7425.00,0.00,0.00,11.00,275.00,'2022-11-29 14:23:44','',''),(3296,'1','285','1',1,'Retail Sale Id 3329',7500.00,0.00,0.00,10.00,1000.00,'2022-11-29 14:34:22','',''),(3297,'1','285','1',1,'Retail Sale Id 3330',3000.00,0.00,0.00,4.00,400.00,'2022-11-29 14:36:13','',''),(3298,'1','285','1',1,'Retail Sale Id 3331',1500.00,0.00,0.00,2.00,200.00,'2022-11-29 14:41:41','',''),(3299,'1','285','1',1,'Retail Sale Id 3332',1500.00,0.00,0.00,2.00,200.00,'2022-11-29 14:43:01','',''),(3300,'1','285','1',1,'Retail Sale Id 3333',40614.75,0.00,0.00,60.17,1504.25,'2022-11-29 14:50:31','',''),(3301,'1','285','1',1,'Retail Sale Id 3334',997.50,0.00,0.00,1.33,133.00,'2022-11-29 14:56:23','',''),(3302,'1','285','1',1,'Retail Sale Id 3335',1500.00,0.00,0.00,2.00,200.00,'2022-11-29 14:58:41','',''),(3303,'1','285','1',1,'Retail Sale Id 3336',1500.00,0.00,0.00,2.00,200.00,'2022-11-29 15:17:16','',''),(3304,'1','285','1',1,'Retail Sale Id 3337',1500.00,0.00,0.00,2.00,200.00,'2022-11-29 15:27:19','',''),(3305,'1','285','1',1,'Retail Sale Id 3338',750.00,0.00,0.00,1.00,100.00,'2022-11-29 15:31:21','',''),(3306,'1','285','1',1,'Retail Sale Id 3339',1500.00,0.00,0.00,2.00,200.00,'2022-11-29 15:37:54','',''),(3307,'1','285','1',1,'Retail Sale Id 3340',2250.00,0.00,0.00,3.00,300.00,'2022-11-29 15:39:48','',''),(3308,'1','285','1',1,'Retail Sale Id 3341',1500.00,0.00,0.00,2.00,200.00,'2022-11-29 15:42:45','',''),(3309,'1','285','1',1,'Retail Sale Id 3342',43193.25,0.00,0.00,63.99,1599.75,'2022-11-29 15:51:29','',''),(3310,'1','285','1',1,'Retail Sale Id 3343',5250.00,0.00,0.00,7.00,700.00,'2022-11-29 16:05:28','',''),(3311,'1','285','1',1,'Retail Sale Id 3344',30375.00,0.00,0.00,45.00,1125.00,'2022-11-29 16:09:25','',''),(3312,'1','285','1',1,'Retail Sale Id 3345',6750.00,0.00,0.00,9.00,900.00,'2022-11-29 16:12:47','',''),(3313,'1','285','1',1,'Retail Sale Id 3346',1500.00,0.00,0.00,2.00,200.00,'2022-11-29 16:13:51','',''),(3314,'1','285','1',1,'Retail Sale Id 3347',1500.00,0.00,0.00,2.00,200.00,'2022-11-29 16:15:21','',''),(3315,'1','285','1',1,'Retail Sale Id 3348',750.00,0.00,0.00,1.00,100.00,'2022-11-29 16:20:55','',''),(3316,'1','285','1',1,'Retail Sale Id 3349',41850.00,0.00,0.00,62.00,1550.00,'2022-11-29 16:25:33','',''),(3317,'1','285','1',1,'Retail Sale Id 3350',750.00,0.00,0.00,1.00,100.00,'2022-11-29 16:30:50','',''),(3318,'1','285','1',1,'Retail Sale Id 3351',1500.00,0.00,0.00,2.00,200.00,'2022-11-29 16:32:18','',''),(3319,'1','285','1',1,'Retail Sale Id 3352',20250.00,0.00,0.00,30.00,750.00,'2022-11-29 16:33:54','',''),(3320,'1','285','1',1,'Retail Sale Id 3353',22376.25,0.00,0.00,33.15,828.75,'2022-11-29 16:36:07','',''),(3321,'1','285','1',1,'Retail Sale Id 3354',750.00,0.00,0.00,1.00,100.00,'2022-11-29 16:45:27','',''),(3322,'1','285','1',1,'Retail Sale Id 3355',1500.00,0.00,0.00,2.00,200.00,'2022-11-29 16:51:42','',''),(3323,'1','285','1',1,'Retail Sale Id 3356',1500.00,0.00,0.00,2.00,200.00,'2022-11-29 16:54:37','',''),(3324,'1','285','1',1,'Retail Sale Id 3357',40500.00,0.00,0.00,60.00,1500.00,'2022-11-29 16:55:58','',''),(3325,'1','285','1',1,'Retail Sale Id 3358',1500.00,0.00,0.00,2.00,200.00,'2022-11-29 16:59:34','',''),(3326,'1','285','1',1,'Retail Sale Id 3359',2002.50,0.00,0.00,2.67,267.00,'2022-11-29 17:07:52','',''),(3327,'1','285','1',1,'Retail Sale Id 3360',3750.00,0.00,0.00,5.00,500.00,'2022-11-29 17:09:13','',''),(3328,'1','285','1',1,'Return of Retail Sale Id 3358',0.00,1500.00,2.00,0.00,-200.00,'2022-11-29 18:13:46','',''),(3329,'1','285','1',1,'Retail Sale Id 3361',1132.50,0.00,0.00,1.51,151.00,'2022-11-29 18:15:09','',''),(3330,'1','285','1',1,'Return of Retail Sale Id 3353',0.00,22376.25,33.15,0.00,-828.75,'2022-11-29 18:17:37','',''),(3331,'1','285','1',1,'Retail Sale Id 3362',21735.00,0.00,0.00,32.20,805.00,'2022-11-29 18:19:09','',''),(3332,'1','285','1',1,'Retail Sale Id 3363',2250.00,0.00,0.00,3.00,300.00,'2022-11-30 07:21:11','',''),(3333,'1','285','1',1,'Retail Sale Id 3364',3000.00,0.00,0.00,4.00,400.00,'2022-11-30 07:21:56','',''),(3334,'1','285','1',1,'Retail Sale Id 3365',1500.00,0.00,0.00,2.00,200.00,'2022-11-30 07:23:01','',''),(3335,'1','285','1',1,'Retail Sale Id 3366',2250.00,0.00,0.00,3.00,300.00,'2022-11-30 07:26:01','',''),(3336,'1','285','1',1,'Retail Sale Id 3367',21600.00,0.00,0.00,32.00,800.00,'2022-11-30 07:34:11','',''),(3337,'1','285','1',1,'Retail Sale Id 3368',750.00,0.00,0.00,1.00,100.00,'2022-11-30 07:39:21','',''),(3338,'1','285','1',1,'Retail Sale Id 3369',1500.00,0.00,0.00,2.00,200.00,'2022-11-30 07:43:21','',''),(3339,'1','285','1',1,'Retail Sale Id 3370',9000.00,0.00,0.00,12.00,1200.00,'2022-11-30 07:49:38','',''),(3340,'1','285','1',1,'Retail Sale Id 3371',2250.00,0.00,0.00,3.00,300.00,'2022-11-30 07:53:20','',''),(3341,'1','285','1',1,'Retail Sale Id 3372',997.50,0.00,0.00,1.33,133.00,'2022-11-30 07:54:45','',''),(3342,'1','285','1',1,'Retail Sale Id 3373',32400.00,0.00,0.00,48.00,1200.00,'2022-11-30 08:08:23','',''),(3343,'1','285','1',1,'Retail Sale Id 3374',2002.50,0.00,0.00,2.67,267.00,'2022-11-30 08:09:35','',''),(3344,'1','285','1',1,'Retail Sale Id 3375',3000.00,0.00,0.00,4.00,400.00,'2022-11-30 08:19:46','',''),(3345,'1','285','1',1,'Retail Sale Id 3376',1500.00,0.00,0.00,2.00,200.00,'2022-11-30 08:27:02','',''),(3346,'1','285','1',1,'Retail Sale Id 3378',33750.00,0.00,0.00,50.00,1250.00,'2022-11-30 08:33:52','',''),(3347,'1','285','1',1,'Retail Sale Id 3379',1500.00,0.00,0.00,2.00,200.00,'2022-11-30 08:35:58','',''),(3348,'1','285','1',1,'Retail Sale Id 3380',33750.00,0.00,0.00,50.00,1250.00,'2022-11-30 08:38:48','',''),(3349,'1','285','1',1,'Retail Sale Id 3381',82370.25,0.00,0.00,122.03,3050.75,'2022-11-30 08:42:40','',''),(3350,'1','285','1',1,'Retail Sale Id 3384',11934.00,0.00,0.00,17.68,442.00,'2022-11-30 08:43:40','',''),(3351,'1','285','1',1,'Retail Sale Id 3385',1500.00,0.00,0.00,2.00,200.00,'2022-11-30 08:45:20','',''),(3352,'1','285','1',1,'Retail Sale Id 3386',997.50,0.00,0.00,1.33,133.00,'2022-11-30 08:51:55','',''),(3353,'1','285','1',1,'Retail Sale Id 3387',40500.00,0.00,0.00,60.00,1500.00,'2022-11-30 08:58:11','',''),(3354,'1','285','1',1,'Retail Sale Id 3388',750.00,0.00,0.00,1.00,100.00,'2022-11-30 09:01:45','',''),(3355,'1','285','1',1,'Retail Sale Id 3389',750.00,0.00,0.00,1.00,100.00,'2022-11-30 09:02:22','',''),(3356,'1','285','1',1,'Retail Sale Id 3390',997.50,0.00,0.00,1.33,133.00,'2022-11-30 09:08:04','',''),(3357,'1','285','1',1,'Retail Sale Id 3391',10125.00,0.00,0.00,15.00,375.00,'2022-11-30 09:11:36','',''),(3358,'1','285','1',1,'Retail Sale Id 3392',3000.00,0.00,0.00,4.00,400.00,'2022-11-30 09:24:02','',''),(3359,'1','285','1',1,'Retail Sale Id 3394',43017.75,0.00,0.00,63.73,1593.25,'2022-11-30 09:24:53','',''),(3360,'1','285','1',1,'Retail Sale Id 3395',2002.50,0.00,0.00,2.67,267.00,'2022-11-30 09:26:47','',''),(3361,'1','285','1',1,'Retail Sale Id 3396',1500.00,0.00,0.00,2.00,200.00,'2022-11-30 09:31:54','',''),(3362,'1','285','1',1,'Retail Sale Id 3398',4050.00,0.00,0.00,6.00,150.00,'2022-11-30 09:45:29','',''),(3363,'1','285','1',1,'Retail Sale Id 3399',41944.50,0.00,0.00,62.14,1553.50,'2022-11-30 10:14:07','',''),(3364,'1','285','1',1,'Retail Sale Id 3400',1500.00,0.00,0.00,2.00,200.00,'2022-11-30 10:18:39','',''),(3365,'1','285','1',1,'Retail Sale Id 3401',3000.00,0.00,0.00,4.00,400.00,'2022-11-30 10:33:58','',''),(3366,'1','285','1',1,'Retail Sale Id 3402',2250.00,0.00,0.00,3.00,300.00,'2022-11-30 10:51:28','',''),(3367,'1','285','1',1,'Retail Sale Id 3403',1500.00,0.00,0.00,2.00,200.00,'2022-11-30 10:52:12','',''),(3368,'1','285','1',1,'Retail Sale Id 3404',3750.00,0.00,0.00,5.00,500.00,'2022-11-30 10:54:44','',''),(3369,'1','285','1',1,'Retail Sale Id 3405',4050.00,0.00,0.00,6.00,150.00,'2022-11-30 11:15:05','',''),(3370,'1','285','1',1,'Retail Sale Id 3406',997.50,0.00,0.00,1.33,133.00,'2022-11-30 11:15:56','',''),(3371,'1','285','1',1,'Retail Sale Id 3407',1297.50,0.00,0.00,1.73,173.00,'2022-11-30 11:17:26','',''),(3372,'1','285','1',1,'Retail Sale Id 3408',23625.00,0.00,0.00,35.00,875.00,'2022-11-30 11:34:15','',''),(3373,'1','285','1',1,'Retail Sale Id 3409',1500.00,0.00,0.00,2.00,200.00,'2022-11-30 11:53:02','',''),(3374,'1','285','1',1,'Retail Sale Id 3410',2250.00,0.00,0.00,3.00,300.00,'2022-11-30 12:38:46','',''),(3375,'1','285','1',1,'Retail Sale Id 3411',3000.00,0.00,0.00,4.00,400.00,'2022-11-30 12:40:14','',''),(3376,'1','285','1',1,'Retail Sale Id 3412',66717.00,0.00,0.00,98.84,2471.00,'2022-11-30 12:45:17','',''),(3377,'1','285','1',1,'Retail Sale Id 3413',40513.50,0.00,0.00,60.02,1500.50,'2022-11-30 13:08:20','',''),(3378,'1','285','1',1,'Retail Sale Id 3414',40938.75,0.00,0.00,60.65,1516.25,'2022-11-30 13:38:47','',''),(3379,'1','285','1',1,'Retail Sale Id 3415',1500.00,0.00,0.00,2.00,200.00,'2022-11-30 13:39:20','',''),(3380,'1','285','1',1,'Retail Sale Id 3416',3997.50,0.00,0.00,5.33,533.00,'2022-11-30 13:51:29','',''),(3381,'1','285','1',1,'Retail Sale Id 3418',10500.00,0.00,0.00,14.00,1400.00,'2022-11-30 14:25:59','',''),(3382,'1','285','1',1,'Retail Sale Id 3419',802.50,0.00,0.00,1.07,107.00,'2022-11-30 15:06:30','',''),(3383,'1','285','1',1,'Retail Sale Id 3420',3000.00,0.00,0.00,4.00,400.00,'2022-11-30 15:09:56','',''),(3384,'1','285','1',1,'Retail Sale Id 3421',2250.00,0.00,0.00,3.00,300.00,'2022-11-30 15:22:45','',''),(3385,'1','285','1',1,'Retail Sale Id 3422',41080.50,0.00,0.00,60.86,1521.50,'2022-11-30 15:34:14','',''),(3386,'1','285','1',1,'Retail Sale Id 3423',20250.00,0.00,0.00,30.00,750.00,'2022-11-30 15:55:30','',''),(3387,'1','285','1',1,'Retail Sale Id 3424',3750.00,0.00,0.00,5.00,500.00,'2022-11-30 16:05:03','',''),(3388,'1','285','1',1,'Retail Sale Id 3425',58050.00,0.00,0.00,86.00,2150.00,'2022-11-30 16:06:10','',''),(3389,'1','285','1',1,'Retail Sale Id 3426',750.00,0.00,0.00,1.00,100.00,'2022-11-30 16:17:55','',''),(3390,'1','285','1',1,'Retail Sale Id 3427',3750.00,0.00,0.00,5.00,500.00,'2022-11-30 16:20:07','',''),(3391,'1','285','1',1,'Retail Sale Id 3429',19669.50,0.00,0.00,29.14,728.50,'2022-11-30 16:28:36','',''),(3392,'1','285','1',1,'Retail Sale Id 3430',1500.00,0.00,0.00,2.00,200.00,'2022-11-30 16:33:25','',''),(3393,'1','285','1',1,'Retail Sale Id 3431',10500.00,0.00,0.00,14.00,1400.00,'2022-11-30 16:56:10','',''),(3394,'1','285','1',1,'Retail Sale Id 3433',16463.25,0.00,0.00,24.39,609.75,'2022-11-30 16:59:41','',''),(3395,'1','285','1',1,'Retail Sale Id 3435',750.00,0.00,0.00,1.00,100.00,'2022-11-30 17:00:47','',''),(3396,'1','285','1',1,'Retail Sale Id 3436',712.50,0.00,0.00,0.95,95.00,'2022-11-30 18:06:48','',''),(3397,'1','285','1',1,'Return of Retail Sale Id 3433',0.00,16463.25,24.39,0.00,-609.75,'2022-11-30 18:10:14','',''),(3398,'1','285','1',1,'Retail Sale Id 3437',16429.50,0.00,0.00,24.34,608.50,'2022-11-30 18:11:34','',''),(3399,'1','285','1',1,'Retail Sale Id 3438',41499.80,0.00,0.00,61.94,2477.60,'2022-12-01 07:40:36','',''),(3400,'1','285','1',1,'Retail Sale Id 3439',41097.80,0.00,0.00,61.34,2453.60,'2022-12-01 07:43:51','',''),(3401,'1','285','1',1,'Retail Sale Id 3440',41151.40,0.00,0.00,61.42,2456.80,'2022-12-01 07:45:20','',''),(3402,'1','285','1',1,'Retail Sale Id 3441',750.00,0.00,0.00,1.00,120.00,'2022-12-01 07:47:37','',''),(3403,'1','285','1',1,'Retail Sale Id 3442',1500.00,0.00,0.00,2.00,240.00,'2022-12-01 07:48:35','',''),(3404,'1','285','1',1,'Retail Sale Id 3443',37520.00,0.00,0.00,56.00,2240.00,'2022-12-01 07:53:25','',''),(3405,'1','285','1',1,'Retail Sale Id 3444',3000.00,0.00,0.00,4.00,480.00,'2022-12-01 08:09:07','',''),(3406,'1','285','1',1,'Retail Sale Id 3445',2250.00,0.00,0.00,3.00,360.00,'2022-12-01 08:10:04','',''),(3407,'1','285','1',1,'Retail Sale Id 3446',34170.00,0.00,0.00,51.00,2040.00,'2022-12-01 08:24:07','',''),(3408,'1','285','1',1,'Retail Sale Id 3447',16569.10,0.00,0.00,24.73,989.20,'2022-12-01 08:35:01','',''),(3409,'1','285','1',1,'Retail Sale Id 3448',3000.00,0.00,0.00,4.00,480.00,'2022-12-01 08:41:29','',''),(3410,'1','285','1',1,'Retail Sale Id 3449',997.50,0.00,0.00,1.33,159.60,'2022-12-01 08:47:17','',''),(3411,'1','285','1',1,'Retail Sale Id 3450',1500.00,0.00,0.00,2.00,240.00,'2022-12-01 08:52:13','',''),(3412,'1','285','1',1,'Retail Sale Id 3451',2250.00,0.00,0.00,3.00,360.00,'2022-12-01 08:57:07','',''),(3413,'1','285','1',1,'Retail Sale Id 3452',750.00,0.00,0.00,1.00,120.00,'2022-12-01 09:01:46','',''),(3414,'1','285','1',1,'Retail Sale Id 3453',3000.00,0.00,0.00,4.00,480.00,'2022-12-01 09:13:02','',''),(3415,'1','285','1',1,'Retail Sale Id 3455',802.50,0.00,0.00,1.07,128.40,'2022-12-01 09:14:43','',''),(3416,'1','285','1',1,'Retail Sale Id 3456',2250.00,0.00,0.00,3.00,360.00,'2022-12-01 09:15:53','',''),(3417,'1','285','1',1,'Retail Sale Id 3457',2625.00,0.00,0.00,3.50,420.00,'2022-12-01 09:27:34','',''),(3418,'1','285','1',1,'Retail Sale Id 3458',1500.00,0.00,0.00,2.00,240.00,'2022-12-01 09:29:54','',''),(3419,'1','285','1',1,'Retail Sale Id 3459',2250.00,0.00,0.00,3.00,360.00,'2022-12-01 09:30:46','',''),(3420,'1','285','1',1,'Retail Sale Id 3460',42866.60,0.00,0.00,63.98,2559.20,'2022-12-01 10:16:23','',''),(3421,'1','285','1',1,'Retail Sale Id 3461',2250.00,0.00,0.00,3.00,360.00,'2022-12-01 10:21:20','',''),(3422,'1','285','1',1,'Retail Sale Id 3462',34840.00,0.00,0.00,52.00,2080.00,'2022-12-01 10:44:11','',''),(3423,'1','285','1',1,'Retail Sale Id 3463',1500.00,0.00,0.00,2.00,240.00,'2022-12-01 10:59:44','',''),(3424,'1','285','1',1,'Retail Sale Id 3464',1500.00,0.00,0.00,2.00,240.00,'2022-12-01 11:10:48','',''),(3425,'1','285','1',1,'Retail Sale Id 3465',3000.00,0.00,0.00,4.00,480.00,'2022-12-01 11:15:50','',''),(3426,'1','285','1',1,'Retail Sale Id 3466',40762.80,0.00,0.00,60.84,2433.60,'2022-12-01 11:22:22','',''),(3427,'1','285','1',1,'Retail Sale Id 3467',2250.00,0.00,0.00,3.00,360.00,'2022-12-01 11:54:50','',''),(3428,'1','285','1',1,'Retail Sale Id 3468',1500.00,0.00,0.00,2.00,240.00,'2022-12-01 11:56:58','',''),(3429,'1','285','1',1,'Retail Sale Id 3469',2250.00,0.00,0.00,3.00,360.00,'2022-12-01 11:57:53','',''),(3430,'1','285','1',1,'Retail Sale Id 3470',3000.00,0.00,0.00,4.00,480.00,'2022-12-01 12:08:42','',''),(3431,'1','285','1',1,'Retail Sale Id 3472',802.50,0.00,0.00,1.07,128.40,'2022-12-01 12:13:22','',''),(3432,'1','285','1',1,'Retail Sale Id 3473',19684.60,0.00,0.00,29.38,1175.20,'2022-12-01 12:22:35','',''),(3433,'1','285','1',1,'Retail Sale Id 3474',2250.00,0.00,0.00,3.00,360.00,'2022-12-01 12:34:34','',''),(3434,'1','285','1',1,'Retail Sale Id 3475',3000.00,0.00,0.00,4.00,480.00,'2022-12-01 12:42:05','',''),(3435,'1','285','1',1,'Retail Sale Id 3476',2250.00,0.00,0.00,3.00,360.00,'2022-12-01 12:46:08','',''),(3436,'1','285','1',1,'Retail Sale Id 3477',33500.00,0.00,0.00,50.00,2000.00,'2022-12-01 12:49:25','',''),(3437,'1','285','1',1,'Retail Sale Id 3478',2250.00,0.00,0.00,3.00,360.00,'2022-12-01 12:52:09','',''),(3438,'1','285','1',1,'Retail Sale Id 3479',1500.00,0.00,0.00,2.00,240.00,'2022-12-01 12:58:32','',''),(3439,'1','285','1',1,'Retail Sale Id 3480',2250.00,0.00,0.00,3.00,360.00,'2022-12-01 12:59:39','',''),(3440,'1','285','1',1,'Retail Sale Id 3481',750.00,0.00,0.00,1.00,120.00,'2022-12-01 13:00:54','',''),(3441,'1','285','1',1,'Retail Sale Id 3482',2302.50,0.00,0.00,3.07,368.40,'2022-12-01 13:05:59','',''),(3442,'1','285','1',1,'Retail Sale Id 3483',2302.50,0.00,0.00,3.07,368.40,'2022-12-01 13:07:47','',''),(3443,'1','285','1',1,'Retail Sale Id 3484',2250.00,0.00,0.00,3.00,360.00,'2022-12-01 13:46:13','',''),(3444,'1','285','1',1,'Retail Sale Id 3485',750.00,0.00,0.00,1.00,120.00,'2022-12-01 13:57:05','',''),(3445,'1','285','1',1,'Retail Sale Id 3486',4500.00,0.00,0.00,6.00,720.00,'2022-12-01 14:04:05','',''),(3446,'1','285','1',1,'Retail Sale Id 3487',1500.00,0.00,0.00,2.00,240.00,'2022-12-01 14:05:30','',''),(3447,'1','285','1',1,'Retail Sale Id 3488',2497.50,0.00,0.00,3.33,399.60,'2022-12-01 14:24:25','',''),(3448,'1','285','1',1,'Retail Sale Id 3489',1500.00,0.00,0.00,2.00,240.00,'2022-12-01 14:25:28','',''),(3449,'1','285','1',1,'Retail Sale Id 3490',2497.50,0.00,0.00,3.33,399.60,'2022-12-01 14:31:18','',''),(3450,'1','285','1',1,'Retail Sale Id 3491',42498.10,0.00,0.00,63.43,2537.20,'2022-12-01 14:36:53','',''),(3451,'1','285','1',1,'Retail Sale Id 3492',1500.00,0.00,0.00,2.00,240.00,'2022-12-01 14:45:30','',''),(3452,'1','285','1',1,'Retail Sale Id 3493',2250.00,0.00,0.00,3.00,360.00,'2022-12-01 14:50:15','',''),(3453,'1','285','1',1,'Retail Sale Id 3495',40870.00,0.00,0.00,61.00,2440.00,'2022-12-01 14:58:35','',''),(3454,'1','285','1',1,'Retail Sale Id 3496',3750.00,0.00,0.00,5.00,600.00,'2022-12-01 14:59:57','',''),(3455,'1','285','1',1,'Retail Sale Id 3497',3000.00,0.00,0.00,4.00,480.00,'2022-12-01 15:03:58','',''),(3456,'1','285','1',1,'Retail Sale Id 3498',3750.00,0.00,0.00,5.00,600.00,'2022-12-01 15:35:48','',''),(3457,'1','285','1',1,'Retail Sale Id 3499',1500.00,0.00,0.00,2.00,240.00,'2022-12-01 15:37:29','',''),(3458,'1','285','1',1,'Retail Sale Id 3500',1500.00,0.00,0.00,2.00,240.00,'2022-12-01 15:43:39','',''),(3459,'1','285','1',1,'Retail Sale Id 3501',3000.00,0.00,0.00,4.00,480.00,'2022-12-01 15:52:41','',''),(3460,'1','285','1',1,'Retail Sale Id 3502',750.00,0.00,0.00,1.00,120.00,'2022-12-01 15:55:10','',''),(3461,'1','285','1',1,'Retail Sale Id 3503',1500.00,0.00,0.00,2.00,240.00,'2022-12-01 15:56:15','',''),(3462,'1','285','1',1,'Retail Sale Id 3504',2250.00,0.00,0.00,3.00,360.00,'2022-12-01 15:57:20','',''),(3463,'1','285','1',1,'Retail Sale Id 3505',2250.00,0.00,0.00,3.00,360.00,'2022-12-01 16:07:24','',''),(3464,'1','285','1',1,'Retail Sale Id 3506',4500.00,0.00,0.00,6.00,720.00,'2022-12-01 16:12:39','',''),(3465,'1','285','1',1,'Retail Sale Id 3507',5250.00,0.00,0.00,7.00,840.00,'2022-12-01 16:17:12','',''),(3466,'1','285','1',1,'Retail Sale Id 3508',9000.00,0.00,0.00,12.00,1440.00,'2022-12-01 16:21:12','',''),(3467,'1','285','1',1,'Retail Sale Id 3509',3000.00,0.00,0.00,4.00,480.00,'2022-12-01 16:22:30','',''),(3468,'1','285','1',1,'Retail Sale Id 3510',1500.00,0.00,0.00,2.00,240.00,'2022-12-01 16:23:41','',''),(3469,'1','285','1',1,'Retail Sale Id 3511',8250.00,0.00,0.00,11.00,1320.00,'2022-12-01 16:25:00','',''),(3470,'1','285','1',1,'Retail Sale Id 3512',49245.00,0.00,0.00,73.50,2940.00,'2022-12-01 16:26:10','',''),(3471,'1','285','1',1,'Retail Sale Id 3513',26800.00,0.00,0.00,40.00,1600.00,'2022-12-01 16:28:26','',''),(3472,'1','285','1',1,'Retail Sale Id 3514',38538.40,0.00,0.00,57.52,2300.80,'2022-12-01 16:32:05','',''),(3473,'1','285','1',1,'Retail Sale Id 3515',6000.00,0.00,0.00,8.00,960.00,'2022-12-01 16:40:13','',''),(3474,'1','285','1',1,'Retail Sale Id 3516',1500.00,0.00,0.00,2.00,240.00,'2022-12-01 16:46:15','',''),(3475,'1','285','1',1,'Retail Sale Id 3517',750.00,0.00,0.00,1.00,120.00,'2022-12-01 16:49:22','',''),(3476,'1','285','1',1,'Retail Sale Id 3518',2250.00,0.00,0.00,3.00,360.00,'2022-12-01 16:53:07','',''),(3477,'1','285','1',1,'Retail Sale Id 3519',1507.50,0.00,0.00,2.01,241.20,'2022-12-01 17:25:18','',''),(3478,'1','285','1',1,'Return of Retail Sale Id 3513',0.00,26800.00,40.00,0.00,-1600.00,'2022-12-01 18:21:48','',''),(3479,'1','285','1',1,'Retail Sale Id 3520',26277.40,0.00,0.00,39.22,1568.80,'2022-12-01 18:23:03','',''),(3480,'1','285','1',1,'Retail Sale Id 3521',997.50,0.00,0.00,1.33,159.60,'2022-12-02 07:14:58','',''),(3481,'1','285','1',1,'Retail Sale Id 3522',7500.00,0.00,0.00,10.00,1200.00,'2022-12-02 07:18:10','',''),(3482,'1','285','1',1,'Retail Sale Id 3523',750.00,0.00,0.00,1.00,120.00,'2022-12-02 07:20:30','',''),(3483,'1','285','1',1,'Retail Sale Id 3524',997.50,0.00,0.00,1.33,159.60,'2022-12-02 07:21:24','',''),(3484,'1','285','1',1,'Retail Sale Id 3525',1500.00,0.00,0.00,2.00,240.00,'2022-12-02 07:22:40','',''),(3485,'1','285','1',1,'Retail Sale Id 3526',750.00,0.00,0.00,1.00,120.00,'2022-12-02 07:24:02','',''),(3486,'1','285','1',1,'Retail Sale Id 3527',40200.00,0.00,0.00,60.00,2400.00,'2022-12-02 07:26:14','',''),(3487,'1','285','1',1,'Retail Sale Id 3528',74370.00,0.00,0.00,111.00,4440.00,'2022-12-02 07:35:26','',''),(3488,'1','285','1',1,'Retail Sale Id 3529',750.00,0.00,0.00,1.00,120.00,'2022-12-02 07:53:57','',''),(3489,'1','285','1',1,'Retail Sale Id 3530',1500.00,0.00,0.00,2.00,240.00,'2022-12-02 08:04:51','',''),(3490,'1','285','1',1,'Retail Sale Id 3531',1500.00,0.00,0.00,2.00,240.00,'2022-12-02 08:05:39','',''),(3491,'1','285','1',1,'Retail Sale Id 3532',1500.00,0.00,0.00,2.00,240.00,'2022-12-02 08:09:24','',''),(3492,'1','285','1',1,'Retail Sale Id 3533',40200.00,0.00,0.00,60.00,2400.00,'2022-12-02 08:15:00','',''),(3493,'1','285','1',1,'Retail Sale Id 3535',2002.50,0.00,0.00,2.67,320.40,'2022-12-02 08:27:39','',''),(3494,'1','285','1',1,'Retail Sale Id 3536',40200.00,0.00,0.00,60.00,2400.00,'2022-12-02 08:33:07','',''),(3495,'1','285','1',1,'Retail Sale Id 3537',1500.00,0.00,0.00,2.00,240.00,'2022-12-02 08:34:57','',''),(3496,'1','285','1',1,'Retail Sale Id 3538',16736.60,0.00,0.00,24.98,999.20,'2022-12-02 08:39:51','',''),(3497,'1','285','1',1,'Retail Sale Id 3539',7500.00,0.00,0.00,10.00,1200.00,'2022-12-02 08:42:11','',''),(3498,'1','285','1',1,'Retail Sale Id 3540',41238.50,0.00,0.00,61.55,2462.00,'2022-12-02 08:50:39','',''),(3499,'1','285','1',1,'Retail Sale Id 3541',3000.00,0.00,0.00,4.00,480.00,'2022-12-02 09:06:59','',''),(3500,'1','285','1',1,'Retail Sale Id 3542',3000.00,0.00,0.00,4.00,480.00,'2022-12-02 09:30:28','',''),(3501,'1','285','1',1,'Retail Sale Id 3543',1500.00,0.00,0.00,2.00,240.00,'2022-12-02 09:40:07','',''),(3502,'1','285','1',1,'Retail Sale Id 3544',33500.00,0.00,0.00,50.00,2000.00,'2022-12-02 09:41:20','',''),(3503,'1','285','1',1,'Retail Sale Id 3545',3000.00,0.00,0.00,4.00,480.00,'2022-12-02 09:43:44','',''),(3504,'1','285','1',1,'Retail Sale Id 3546',83703.10,0.00,0.00,124.93,4997.20,'2022-12-02 09:49:39','',''),(3505,'1','285','1',1,'Retail Sale Id 3547',2250.00,0.00,0.00,3.00,360.00,'2022-12-02 09:56:39','',''),(3506,'1','285','1',1,'Retail Sale Id 3548',2250.00,0.00,0.00,3.00,360.00,'2022-12-02 09:58:17','',''),(3507,'1','285','1',1,'Retail Sale Id 3549',3000.00,0.00,0.00,4.00,480.00,'2022-12-02 10:01:55','',''),(3508,'1','285','1',1,'Retail Sale Id 3550',23450.00,0.00,0.00,35.00,1400.00,'2022-12-02 10:07:02','',''),(3509,'1','285','1',1,'Retail Sale Id 3551',997.50,0.00,0.00,1.33,159.60,'2022-12-02 10:08:09','',''),(3510,'1','285','1',1,'Retail Sale Id 3552',750.00,0.00,0.00,1.00,120.00,'2022-12-02 10:09:13','',''),(3511,'1','285','1',1,'Retail Sale Id 3553',40200.00,0.00,0.00,60.00,2400.00,'2022-12-02 10:22:05','',''),(3512,'1','285','1',1,'Retail Sale Id 3554',41553.40,0.00,0.00,62.02,2480.80,'2022-12-02 10:31:25','',''),(3513,'1','285','1',1,'Retail Sale Id 3555',88788.40,0.00,0.00,132.52,5300.80,'2022-12-02 11:06:29','',''),(3514,'1','285','1',1,'Retail Sale Id 3557',2325.00,0.00,0.00,3.10,372.00,'2022-12-02 11:15:03','',''),(3515,'1','285','1',1,'Retail Sale Id 3558',750.00,0.00,0.00,1.00,120.00,'2022-12-02 11:18:40','',''),(3516,'1','285','1',1,'Retail Sale Id 3559',41607.00,0.00,0.00,62.10,2484.00,'2022-12-02 11:50:11','',''),(3517,'1','285','1',1,'Retail Sale Id 3560',2002.50,0.00,0.00,2.67,320.40,'2022-12-02 11:54:23','',''),(3518,'1','285','1',1,'Retail Sale Id 3561',750.00,0.00,0.00,1.00,120.00,'2022-12-02 12:10:32','',''),(3519,'1','285','1',1,'Retail Sale Id 3562',1500.00,0.00,0.00,2.00,240.00,'2022-12-02 12:41:43','',''),(3520,'1','285','1',1,'Retail Sale Id 3563',750.00,0.00,0.00,1.00,120.00,'2022-12-02 12:46:53','',''),(3521,'1','285','1',1,'Retail Sale Id 3564',1500.00,0.00,0.00,2.00,240.00,'2022-12-02 12:54:55','',''),(3522,'1','285','1',1,'Retail Sale Id 3565',3000.00,0.00,0.00,4.00,480.00,'2022-12-02 12:58:01','',''),(3523,'1','285','1',1,'Retail Sale Id 3566',1500.00,0.00,0.00,2.00,240.00,'2022-12-02 12:59:06','',''),(3524,'1','285','1',1,'Retail Sale Id 3567',2002.50,0.00,0.00,2.67,320.40,'2022-12-02 13:03:16','',''),(3525,'1','285','1',1,'Retail Sale Id 3568',2497.50,0.00,0.00,3.33,399.60,'2022-12-02 13:06:03','',''),(3526,'1','285','1',1,'Retail Sale Id 3569',1500.00,0.00,0.00,2.00,240.00,'2022-12-02 13:26:36','',''),(3527,'1','285','1',1,'Retail Sale Id 3570',1500.00,0.00,0.00,2.00,240.00,'2022-12-02 13:27:34','',''),(3528,'1','285','1',1,'Retail Sale Id 3571',26800.00,0.00,0.00,40.00,1600.00,'2022-12-02 14:05:36','',''),(3529,'1','285','1',1,'Retail Sale Id 3572',20006.20,0.00,0.00,29.86,1194.40,'2022-12-02 14:16:46','',''),(3530,'1','285','1',1,'Retail Sale Id 3573',3750.00,0.00,0.00,5.00,600.00,'2022-12-02 14:30:01','',''),(3531,'1','285','1',1,'Retail Sale Id 3574',997.50,0.00,0.00,1.33,159.60,'2022-12-02 14:31:34','',''),(3532,'1','285','1',1,'Retail Sale Id 3575',1500.00,0.00,0.00,2.00,240.00,'2022-12-02 14:32:41','',''),(3533,'1','285','1',1,'Retail Sale Id 3576',1500.00,0.00,0.00,2.00,240.00,'2022-12-02 14:49:21','',''),(3534,'1','285','1',1,'Retail Sale Id 3577',5250.00,0.00,0.00,7.00,840.00,'2022-12-02 14:55:03','',''),(3535,'1','285','1',1,'Retail Sale Id 3578',1500.00,0.00,0.00,2.00,240.00,'2022-12-02 14:55:58','',''),(3536,'1','285','1',1,'Retail Sale Id 3579',2497.50,0.00,0.00,3.33,399.60,'2022-12-02 14:57:18','',''),(3537,'1','285','1',1,'Retail Sale Id 3580',41225.10,0.00,0.00,61.53,2461.20,'2022-12-02 14:58:50','',''),(3538,'1','285','1',1,'Retail Sale Id 3581',4500.00,0.00,0.00,6.00,720.00,'2022-12-02 15:07:38','',''),(3539,'1','285','1',1,'Retail Sale Id 3582',1500.00,0.00,0.00,2.00,240.00,'2022-12-02 15:08:30','',''),(3540,'1','285','1',1,'Retail Sale Id 3583',2497.50,0.00,0.00,3.33,399.60,'2022-12-02 15:09:24','',''),(3541,'1','285','1',1,'Retail Sale Id 3584',997.50,0.00,0.00,1.33,159.60,'2022-12-02 15:30:52','',''),(3542,'1','285','1',1,'Retail Sale Id 3585',2250.00,0.00,0.00,3.00,360.00,'2022-12-02 15:38:12','',''),(3543,'1','285','1',1,'Return of Retail Sale Id 3585',0.00,2250.00,3.00,0.00,-360.00,'2022-12-02 15:46:53','',''),(3544,'1','285','1',1,'Retail Sale Id 3586',1462.50,0.00,0.00,1.95,234.00,'2022-12-02 15:47:52','',''),(3545,'1','285','1',1,'Retail Sale Id 3587',1500.00,0.00,0.00,2.00,240.00,'2022-12-02 15:49:01','',''),(3546,'1','285','1',1,'Retail Sale Id 3588',2002.50,0.00,0.00,2.67,320.40,'2022-12-02 15:53:00','',''),(3547,'1','285','1',1,'Retail Sale Id 3589',2250.00,0.00,0.00,3.00,360.00,'2022-12-02 15:59:22','',''),(3548,'1','285','1',1,'Retail Sale Id 3590',1500.00,0.00,0.00,2.00,240.00,'2022-12-02 16:00:28','',''),(3549,'1','285','1',1,'Retail Sale Id 3591',2250.00,0.00,0.00,3.00,360.00,'2022-12-02 16:07:01','',''),(3550,'1','285','1',1,'Retail Sale Id 3592',4500.00,0.00,0.00,6.00,720.00,'2022-12-02 16:08:21','',''),(3551,'1','285','1',1,'Retail Sale Id 3593',1500.00,0.00,0.00,2.00,240.00,'2022-12-02 16:16:13','',''),(3552,'1','285','1',1,'Retail Sale Id 3594',750.00,0.00,0.00,1.00,120.00,'2022-12-02 16:17:14','',''),(3553,'1','285','1',1,'Retail Sale Id 3595',4500.00,0.00,0.00,6.00,720.00,'2022-12-02 16:20:25','',''),(3554,'1','285','1',1,'Retail Sale Id 3596',41138.00,0.00,0.00,61.40,2456.00,'2022-12-02 16:22:00','',''),(3555,'1','285','1',1,'Retail Sale Id 3597',32387.80,0.00,0.00,48.34,1933.60,'2022-12-02 16:24:09','',''),(3556,'1','285','1',1,'Retail Sale Id 3598',11812.10,0.00,0.00,17.63,705.20,'2022-12-02 16:25:44','',''),(3557,'1','285','1',1,'Retail Sale Id 3599',9375.00,0.00,0.00,12.50,1500.00,'2022-12-02 16:34:11','',''),(3558,'1','285','1',1,'Retail Sale Id 3600',3750.00,0.00,0.00,5.00,600.00,'2022-12-02 16:36:14','',''),(3559,'1','285','1',1,'Retail Sale Id 3601',5250.00,0.00,0.00,7.00,840.00,'2022-12-02 16:38:47','',''),(3560,'1','285','1',1,'Retail Sale Id 3602',3000.00,0.00,0.00,4.00,480.00,'2022-12-02 16:44:59','',''),(3561,'1','285','1',1,'Retail Sale Id 3603',3000.00,0.00,0.00,4.00,480.00,'2022-12-02 16:47:19','',''),(3562,'1','285','1',1,'Retail Sale Id 3604',2002.50,0.00,0.00,2.67,320.40,'2022-12-02 16:48:47','',''),(3563,'1','285','1',1,'Retail Sale Id 3605',58363.70,0.00,0.00,87.11,3484.40,'2022-12-02 16:50:54','',''),(3564,'1','285','1',1,'Retail Sale Id 3606',3750.00,0.00,0.00,5.00,600.00,'2022-12-02 16:55:24','',''),(3565,'1','285','1',1,'Retail Sale Id 3607',547.50,0.00,0.00,0.73,87.60,'2022-12-02 18:14:15','',''),(3566,'1','285','1',1,'Return of Retail Sale Id 3598',0.00,11812.10,17.63,0.00,-705.20,'2022-12-02 18:18:07','',''),(3567,'1','285','1',1,'Retail Sale Id 3608',11122.00,0.00,0.00,16.60,664.00,'2022-12-02 18:19:27','',''),(3568,'1','285','1',1,'Retail Sale Id 3610',3000.00,0.00,0.00,4.00,480.00,'2022-12-03 08:51:41','',''),(3569,'1','285','1',1,'Retail Sale Id 3611',3750.00,0.00,0.00,5.00,600.00,'2022-12-03 08:57:11','',''),(3570,'1','285','1',1,'Retail Sale Id 3609',42122.90,0.00,0.00,62.87,2514.80,'2022-12-03 08:57:33','',''),(3571,'1','285','1',1,'Retail Sale Id 3612',3000.00,0.00,0.00,4.00,480.00,'2022-12-03 08:58:28','',''),(3572,'1','285','1',1,'Retail Sale Id 3613',33500.00,0.00,0.00,50.00,2000.00,'2022-12-03 09:01:00','',''),(3573,'1','285','1',1,'Retail Sale Id 3614',82778.50,0.00,0.00,123.55,4942.00,'2022-12-03 09:02:08','',''),(3574,'1','285','1',1,'Retail Sale Id 3616',26800.00,0.00,0.00,40.00,1600.00,'2022-12-03 09:02:59','',''),(3575,'1','285','1',1,'Retail Sale Id 3617',33500.00,0.00,0.00,50.00,2000.00,'2022-12-03 09:03:47','',''),(3576,'1','285','1',1,'Retail Sale Id 3618',66544.40,0.00,0.00,99.32,3972.80,'2022-12-03 09:06:45','',''),(3577,'1','285','1',1,'Retail Sale Id 3619',2250.00,0.00,0.00,3.00,360.00,'2022-12-03 09:11:27','',''),(3578,'1','285','1',1,'Retail Sale Id 3620',3000.00,0.00,0.00,4.00,480.00,'2022-12-03 09:15:00','',''),(3579,'1','285','1',1,'Retail Sale Id 3621',750.00,0.00,0.00,1.00,120.00,'2022-12-03 09:25:52','',''),(3580,'1','285','1',1,'Retail Sale Id 3622',3997.50,0.00,0.00,5.33,639.60,'2022-12-03 09:32:49','',''),(3581,'1','285','1',1,'Retail Sale Id 3623',30150.00,0.00,0.00,45.00,1800.00,'2022-12-03 09:34:57','',''),(3582,'1','285','1',1,'Retail Sale Id 3624',1500.00,0.00,0.00,2.00,240.00,'2022-12-03 09:50:33','',''),(3583,'1','285','1',1,'Retail Sale Id 3626',2002.50,0.00,0.00,2.67,320.40,'2022-12-03 09:51:10','',''),(3584,'1','285','1',1,'Retail Sale Id 3627',750.00,0.00,0.00,1.00,120.00,'2022-12-03 09:51:43','',''),(3585,'1','285','1',1,'Retail Sale Id 3628',3750.00,0.00,0.00,5.00,600.00,'2022-12-03 09:52:30','',''),(3586,'1','285','1',1,'Retail Sale Id 3629',997.50,0.00,0.00,1.33,159.60,'2022-12-03 09:53:31','',''),(3587,'1','285','1',1,'Retail Sale Id 3631',750.00,0.00,0.00,1.00,120.00,'2022-12-03 09:54:24','',''),(3588,'1','285','1',1,'Retail Sale Id 3632',1500.00,0.00,0.00,2.00,240.00,'2022-12-03 09:54:57','',''),(3589,'1','285','1',1,'Retail Sale Id 3633',1500.00,0.00,0.00,2.00,240.00,'2022-12-03 09:55:47','',''),(3590,'1','285','1',1,'Retail Sale Id 3634',28140.00,0.00,0.00,42.00,1680.00,'2022-12-03 09:57:14','',''),(3591,'1','285','1',1,'Retail Sale Id 3635',3000.00,0.00,0.00,4.00,480.00,'2022-12-03 09:59:02','',''),(3592,'1','285','1',1,'Retail Sale Id 3636',1500.00,0.00,0.00,2.00,240.00,'2022-12-03 10:03:29','',''),(3593,'1','285','1',1,'Retail Sale Id 3637',3000.00,0.00,0.00,4.00,480.00,'2022-12-03 10:04:19','',''),(3594,'1','285','1',1,'Retail Sale Id 3638',2250.00,0.00,0.00,3.00,360.00,'2022-12-03 10:05:06','',''),(3595,'1','285','1',1,'Retail Sale Id 3639',1500.00,0.00,0.00,2.00,240.00,'2022-12-03 10:05:59','',''),(3596,'1','285','1',1,'Retail Sale Id 3640',750.00,0.00,0.00,1.00,120.00,'2022-12-03 10:06:55','',''),(3597,'1','285','1',1,'Retail Sale Id 3641',5107.50,0.00,0.00,6.81,817.20,'2022-12-03 10:09:13','',''),(3598,'1','285','1',1,'Retail Sale Id 3642',997.50,0.00,0.00,1.33,159.60,'2022-12-03 10:10:34','',''),(3599,'1','285','1',1,'Retail Sale Id 3643',3000.00,0.00,0.00,4.00,480.00,'2022-12-03 10:11:31','',''),(3600,'1','285','1',1,'Retail Sale Id 3644',1500.00,0.00,0.00,2.00,240.00,'2022-12-03 10:12:28','',''),(3601,'1','285','1',1,'Retail Sale Id 3645',1500.00,0.00,0.00,2.00,240.00,'2022-12-03 10:13:44','',''),(3602,'1','285','1',1,'Retail Sale Id 3646',750.00,0.00,0.00,1.00,120.00,'2022-12-03 10:14:52','',''),(3603,'1','285','1',1,'Return of Retail Sale Id 3641',0.00,5107.50,6.81,0.00,-817.20,'2022-12-03 10:17:28','',''),(3604,'1','285','1',1,'Retail Sale Id 3647',42210.00,0.00,0.00,63.00,2520.00,'2022-12-03 10:19:22','',''),(3605,'1','285','1',1,'Retail Sale Id 3648',2250.00,0.00,0.00,3.00,360.00,'2022-12-03 10:39:56','',''),(3606,'1','285','1',1,'Retail Sale Id 3649',1500.00,0.00,0.00,2.00,240.00,'2022-12-03 10:43:37','',''),(3607,'1','285','1',1,'Retail Sale Id 3650',2497.50,0.00,0.00,3.33,399.60,'2022-12-03 10:59:30','',''),(3608,'1','285','1',1,'Retail Sale Id 3651',750.00,0.00,0.00,1.00,120.00,'2022-12-03 11:28:26','',''),(3609,'1','285','1',1,'Retail Sale Id 3652',2250.00,0.00,0.00,3.00,360.00,'2022-12-03 11:29:44','',''),(3610,'1','285','1',1,'Retail Sale Id 3653',3000.00,0.00,0.00,4.00,480.00,'2022-12-03 11:31:25','',''),(3611,'1','285','1',1,'Retail Sale Id 3654',34840.00,0.00,0.00,52.00,2080.00,'2022-12-03 11:35:20','',''),(3612,'1','285','1',1,'Retail Sale Id 3655',11798.70,0.00,0.00,17.61,704.40,'2022-12-03 11:43:32','',''),(3613,'1','285','1',1,'Retail Sale Id 3656',3000.00,0.00,0.00,4.00,480.00,'2022-12-03 11:46:41','',''),(3614,'1','285','1',1,'Retail Sale Id 3657',2250.00,0.00,0.00,3.00,360.00,'2022-12-03 12:01:06','',''),(3615,'1','285','1',1,'Retail Sale Id 3658',50531.40,0.00,0.00,75.42,3016.80,'2022-12-03 12:06:48','',''),(3616,'1','285','1',1,'Retail Sale Id 3659',750.00,0.00,0.00,1.00,120.00,'2022-12-03 12:14:47','',''),(3617,'1','285','1',1,'Retail Sale Id 3660',1500.00,0.00,0.00,2.00,240.00,'2022-12-03 12:17:32','',''),(3618,'1','285','1',1,'Retail Sale Id 3661',4500.00,0.00,0.00,6.00,720.00,'2022-12-03 12:18:22','',''),(3619,'1','285','1',1,'Retail Sale Id 3662',750.00,0.00,0.00,1.00,120.00,'2022-12-03 12:34:20','',''),(3620,'1','285','1',1,'Retail Sale Id 3663',38860.00,0.00,0.00,58.00,2320.00,'2022-12-03 13:03:48','',''),(3621,'1','285','1',1,'Retail Sale Id 3664',750.00,0.00,0.00,1.00,120.00,'2022-12-03 13:24:15','',''),(3622,'1','285','1',1,'Retail Sale Id 3665',3000.00,0.00,0.00,4.00,480.00,'2022-12-03 13:25:30','',''),(3623,'1','285','1',1,'Retail Sale Id 3666',134000.00,0.00,0.00,200.00,8000.00,'2022-12-03 13:37:34','',''),(3624,'1','285','1',1,'Retail Sale Id 3667',2250.00,0.00,0.00,3.00,360.00,'2022-12-03 13:47:54','',''),(3625,'1','285','1',1,'Retail Sale Id 3668',5250.00,0.00,0.00,7.00,840.00,'2022-12-03 13:49:06','',''),(3626,'1','285','1',1,'Retail Sale Id 3669',2250.00,0.00,0.00,3.00,360.00,'2022-12-03 13:52:45','',''),(3627,'1','285','1',1,'Retail Sale Id 3670',802.50,0.00,0.00,1.07,128.40,'2022-12-03 13:54:04','',''),(3628,'1','285','1',1,'Retail Sale Id 3671',56950.00,0.00,0.00,85.00,3400.00,'2022-12-03 13:57:22','',''),(3629,'1','285','1',1,'Retail Sale Id 3672',1500.00,0.00,0.00,2.00,240.00,'2022-12-03 14:00:17','',''),(3630,'1','285','1',1,'Retail Sale Id 3673',1500.00,0.00,0.00,2.00,240.00,'2022-12-03 14:15:18','',''),(3631,'1','285','1',1,'Retail Sale Id 3674',2250.00,0.00,0.00,3.00,360.00,'2022-12-03 14:35:58','',''),(3632,'1','285','1',1,'Retail Sale Id 3675',750.00,0.00,0.00,1.00,120.00,'2022-12-03 14:37:01','',''),(3633,'1','285','1',1,'Retail Sale Id 3676',103300.60,0.00,0.00,154.18,6167.20,'2022-12-03 14:42:46','',''),(3634,'1','285','1',1,'Retail Sale Id 3677',3750.00,0.00,0.00,5.00,600.00,'2022-12-03 14:56:18','',''),(3635,'1','285','1',1,'Retail Sale Id 3678',750.00,0.00,0.00,1.00,120.00,'2022-12-03 14:57:11','',''),(3636,'1','285','1',1,'Retail Sale Id 3679',5602.50,0.00,0.00,7.47,896.40,'2022-12-03 15:00:32','',''),(3637,'1','285','1',1,'Retail Sale Id 3680',80775.20,0.00,0.00,120.56,4822.40,'2022-12-03 15:28:43','',''),(3638,'1','285','1',1,'Retail Sale Id 3681',2250.00,0.00,0.00,3.00,360.00,'2022-12-03 15:29:41','',''),(3639,'1','285','1',1,'Retail Sale Id 3682',3000.00,0.00,0.00,4.00,480.00,'2022-12-03 15:31:07','',''),(3640,'1','285','1',1,'Retail Sale Id 3683',997.50,0.00,0.00,1.33,159.60,'2022-12-03 15:32:19','',''),(3641,'1','285','1',1,'Retail Sale Id 3684',1500.00,0.00,0.00,2.00,240.00,'2022-12-03 15:43:48','',''),(3642,'1','285','1',1,'Retail Sale Id 3685',26800.00,0.00,0.00,40.00,1600.00,'2022-12-03 15:58:00','',''),(3643,'1','285','1',1,'Retail Sale Id 3686',1500.00,0.00,0.00,2.00,240.00,'2022-12-03 15:59:38','',''),(3644,'1','285','1',1,'Return of Retail Sale Id 3668',0.00,5250.00,7.00,0.00,-840.00,'2022-12-03 16:00:38','',''),(3645,'1','285','1',1,'Retail Sale Id 3687',62310.00,0.00,0.00,93.00,3720.00,'2022-12-03 16:02:06','',''),(3646,'1','285','1',1,'Retail Sale Id 3688',4500.00,0.00,0.00,6.00,720.00,'2022-12-03 16:05:23','',''),(3647,'1','285','1',1,'Retail Sale Id 3689',87823.60,0.00,0.00,131.08,5243.20,'2022-12-03 16:08:12','',''),(3648,'1','285','1',1,'Retail Sale Id 3690',2250.00,0.00,0.00,3.00,360.00,'2022-12-03 16:08:56','',''),(3649,'1','285','1',1,'Retail Sale Id 3691',6000.00,0.00,0.00,8.00,960.00,'2022-12-03 16:10:18','',''),(3650,'1','285','1',1,'Retail Sale Id 3692',750.00,0.00,0.00,1.00,120.00,'2022-12-03 16:11:23','',''),(3651,'1','285','1',1,'Retail Sale Id 3693',3000.00,0.00,0.00,4.00,480.00,'2022-12-03 16:24:38','',''),(3652,'1','285','1',1,'Retail Sale Id 3694',2002.50,0.00,0.00,2.67,320.40,'2022-12-03 16:25:30','',''),(3653,'1','285','1',1,'Retail Sale Id 3696',2250.00,0.00,0.00,3.00,360.00,'2022-12-03 16:29:35','',''),(3654,'1','285','1',1,'Retail Sale Id 3697',4500.00,0.00,0.00,6.00,720.00,'2022-12-03 16:31:02','',''),(3655,'1','285','1',1,'Retail Sale Id 3698',1500.00,0.00,0.00,2.00,240.00,'2022-12-03 16:35:17','',''),(3656,'1','285','1',1,'Retail Sale Id 3699',22384.70,0.00,0.00,33.41,1336.40,'2022-12-03 16:38:53','',''),(3657,'1','285','1',1,'Retail Sale Id 3700',1500.00,0.00,0.00,2.00,240.00,'2022-12-03 16:40:48','',''),(3658,'1','285','1',1,'Retail Sale Id 3701',335000.00,0.00,0.00,500.00,20000.00,'2022-12-03 16:42:20','',''),(3659,'1','285','1',1,'Retail Sale Id 3702',16415.00,0.00,0.00,24.50,980.00,'2022-12-03 16:43:21','',''),(3660,'1','285','1',1,'Retail Sale Id 3703',750.00,0.00,0.00,1.00,120.00,'2022-12-03 16:44:08','',''),(3661,'1','285','1',1,'Retail Sale Id 3704',1500.00,0.00,0.00,2.00,240.00,'2022-12-03 16:46:00','',''),(3662,'1','285','1',1,'Return of Retail Sale Id 3701',0.00,335000.00,500.00,0.00,-20000.00,'2022-12-03 16:51:43','',''),(3663,'1','285','1',1,'Retail Sale Id 3705',148458.60,0.00,0.00,221.58,8863.20,'2022-12-03 16:54:28','',''),(3664,'1','285','1',1,'Return of Retail Sale Id 3683',0.00,997.50,1.33,0.00,-159.60,'2022-12-03 17:01:37','',''),(3665,'1','285','1',1,'Return of Retail Sale Id 3671',0.00,56950.00,85.00,0.00,-3400.00,'2022-12-03 17:52:50','',''),(3666,'1','285','1',1,'Retail Sale Id 3706',13326.30,0.00,0.00,19.89,795.60,'2022-12-03 17:53:30','',''),(3667,'1','285','1',1,'Return of Retail Sale Id 3706',0.00,13326.30,19.89,0.00,-795.60,'2022-12-03 17:55:39','',''),(3668,'1','285','1',1,'Return of Retail Sale Id 3687',0.00,62310.00,93.00,0.00,-3720.00,'2022-12-03 17:56:38','',''),(3669,'1','285','1',1,'Retail Sale Id 3707',162883.70,0.00,0.00,243.11,9724.40,'2022-12-03 17:58:28','',''),(3670,'1','285','1',1,'Retail Sale Id 3708',1972.50,0.00,0.00,2.63,315.60,'2022-12-03 19:11:03','',''),(3671,'1','285','1',1,'Return of Retail Sale Id 3702',0.00,16415.00,24.50,0.00,-980.00,'2022-12-03 19:13:47','',''),(3672,'1','285','1',1,'Retail Sale Id 3709',11899.20,0.00,0.00,17.76,710.40,'2022-12-03 19:15:03','',''),(3673,'1','285','1',1,'Distributed to AA RANO NIGERIA LTD for sales id:4',157707.90,0.00,0.00,250.33,0.00,'2022-12-03 19:36:10','',''),(3674,'1','285',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,12348000.00,19600.00,0.00,0.00,'2022-12-03 19:40:19','',''),(3675,'1','285',NULL,1,'Reception corrector for bridging 5',0.00,0.00,0.00,19600.00,0.00,'2022-12-03 19:42:48','',''),(3676,'1','285','1',1,'Received from bridging 5',0.00,0.00,19600.00,0.00,0.00,'2022-12-03 19:42:48','',''),(3677,'1','285','1',1,'Retail Sale Id 3710',170012.50,0.00,0.00,253.75,10150.00,'2022-12-04 06:29:19','',''),(3678,'1','285','1',1,'Retail Sale Id 3711',29480.00,0.00,0.00,44.00,1760.00,'2022-12-04 07:25:21','',''),(3679,'1','285','1',1,'Return of Retail Sale Id 3711',0.00,29480.00,44.00,0.00,-1760.00,'2022-12-04 07:28:01','',''),(3680,'1','285','1',1,'Retail Sale Id 3712',29928.90,0.00,0.00,44.67,1786.80,'2022-12-04 07:29:18','',''),(3681,'1','285','1',1,'Retail Sale Id 3713',3571.10,0.00,0.00,5.33,213.20,'2022-12-04 07:32:26','',''),(3682,'1','285','1',1,'Retail Sale Id 3715',46444.40,0.00,0.00,69.32,2772.80,'2022-12-04 07:34:58','',''),(3683,'1','285','1',1,'Retail Sale Id 3716',3000.00,0.00,0.00,4.00,480.00,'2022-12-04 07:37:32','',''),(3684,'1','285','1',1,'Retail Sale Id 3717',3750.00,0.00,0.00,5.00,600.00,'2022-12-04 07:41:42','',''),(3685,'1','285','1',1,'Retail Sale Id 3718',802.50,0.00,0.00,1.07,128.40,'2022-12-04 07:43:26','',''),(3686,'1','285','1',1,'Retail Sale Id 3719',4500.00,0.00,0.00,6.00,720.00,'2022-12-04 07:49:12','',''),(3687,'1','285','1',1,'Retail Sale Id 3720',3000.00,0.00,0.00,4.00,480.00,'2022-12-04 07:50:47','',''),(3688,'1','285','1',1,'Retail Sale Id 3721',9375.00,0.00,0.00,12.50,1500.00,'2022-12-04 07:52:20','',''),(3689,'1','285','1',1,'Retail Sale Id 3722',750.00,0.00,0.00,1.00,120.00,'2022-12-04 07:53:16','',''),(3690,'1','285','1',1,'Retail Sale Id 3723',1500.00,0.00,0.00,2.00,240.00,'2022-12-04 07:54:18','',''),(3691,'1','285','1',1,'Retail Sale Id 3724',1500.00,0.00,0.00,2.00,240.00,'2022-12-04 07:59:33','',''),(3692,'1','285','1',1,'Retail Sale Id 3725',2250.00,0.00,0.00,3.00,360.00,'2022-12-04 08:02:33','',''),(3693,'1','285','1',1,'Retail Sale Id 3726',1500.00,0.00,0.00,2.00,240.00,'2022-12-04 08:04:15','',''),(3694,'1','285','1',1,'Retail Sale Id 3727',33500.00,0.00,0.00,50.00,2000.00,'2022-12-04 08:09:04','',''),(3695,'1','285','1',1,'Retail Sale Id 3728',2250.00,0.00,0.00,3.00,360.00,'2022-12-04 08:12:09','',''),(3696,'1','285','1',1,'Retail Sale Id 3730',3000.00,0.00,0.00,4.00,480.00,'2022-12-04 08:20:57','',''),(3697,'1','285','1',1,'Retail Sale Id 3731',2250.00,0.00,0.00,3.00,360.00,'2022-12-04 08:21:55','',''),(3698,'1','285','1',1,'Retail Sale Id 3732',2250.00,0.00,0.00,3.00,360.00,'2022-12-04 08:23:40','',''),(3699,'1','285','1',1,'Retail Sale Id 3733',997.50,0.00,0.00,1.33,159.60,'2022-12-04 08:25:47','',''),(3700,'1','285','1',1,'Retail Sale Id 3734',1500.00,0.00,0.00,2.00,240.00,'2022-12-04 08:28:51','',''),(3701,'1','285','1',1,'Retail Sale Id 3735',1500.00,0.00,0.00,2.00,240.00,'2022-12-04 08:36:05','',''),(3702,'1','285','1',1,'Retail Sale Id 3736',3750.00,0.00,0.00,5.00,600.00,'2022-12-04 08:40:02','',''),(3703,'1','285','1',1,'Retail Sale Id 3737',3000.00,0.00,0.00,4.00,480.00,'2022-12-04 08:48:06','',''),(3704,'1','285','1',1,'Retail Sale Id 3739',802.50,0.00,0.00,1.07,128.40,'2022-12-04 08:52:21','',''),(3705,'1','285','1',1,'Retail Sale Id 3740',2497.50,0.00,0.00,3.33,399.60,'2022-12-04 09:17:39','',''),(3706,'1','285','1',1,'Retail Sale Id 3741',1500.00,0.00,0.00,2.00,240.00,'2022-12-04 09:24:59','',''),(3707,'1','285','1',1,'Retail Sale Id 3742',4500.00,0.00,0.00,6.00,720.00,'2022-12-04 09:37:34','',''),(3708,'1','285','1',1,'Retail Sale Id 3743',25996.00,0.00,0.00,38.80,1552.00,'2022-12-04 09:42:44','',''),(3709,'1','285','1',1,'Retail Sale Id 3744',1500.00,0.00,0.00,2.00,240.00,'2022-12-04 10:07:21','',''),(3710,'1','285','1',1,'Retail Sale Id 3745',2250.00,0.00,0.00,3.00,360.00,'2022-12-04 10:12:29','',''),(3711,'1','285','1',1,'Retail Sale Id 3746',34840.00,0.00,0.00,52.00,2080.00,'2022-12-04 11:29:22','',''),(3712,'1','285','1',1,'Retail Sale Id 3747',42210.00,0.00,0.00,63.00,2520.00,'2022-12-04 11:30:22','',''),(3713,'1','285','1',1,'Retail Sale Id 3748',802.50,0.00,0.00,1.07,128.40,'2022-12-04 11:31:01','',''),(3714,'1','285','1',1,'Retail Sale Id 3749',2250.00,0.00,0.00,3.00,360.00,'2022-12-04 11:31:36','',''),(3715,'1','285','1',1,'Retail Sale Id 3750',1500.00,0.00,0.00,2.00,240.00,'2022-12-04 11:32:10','',''),(3716,'1','285','1',1,'Retail Sale Id 3751',1500.00,0.00,0.00,2.00,240.00,'2022-12-04 11:57:52','',''),(3717,'1','285','1',1,'Retail Sale Id 3752',997.50,0.00,0.00,1.33,159.60,'2022-12-04 11:58:29','',''),(3718,'1','285','1',1,'Retail Sale Id 3753',802.50,0.00,0.00,1.07,128.40,'2022-12-04 12:03:21','',''),(3719,'1','285','1',1,'Retail Sale Id 3754',2002.50,0.00,0.00,2.67,320.40,'2022-12-04 12:05:50','',''),(3720,'1','285','1',1,'Retail Sale Id 3755',6000.00,0.00,0.00,8.00,960.00,'2022-12-04 12:18:20','',''),(3721,'1','285','1',1,'Retail Sale Id 3756',997.50,0.00,0.00,1.33,159.60,'2022-12-04 12:21:11','',''),(3722,'1','285','1',1,'Retail Sale Id 3757',802.50,0.00,0.00,1.07,128.40,'2022-12-04 12:22:55','',''),(3723,'1','285','1',1,'Retail Sale Id 3758',2250.00,0.00,0.00,3.00,360.00,'2022-12-04 12:35:30','',''),(3724,'1','285','1',1,'Retail Sale Id 3759',997.50,0.00,0.00,1.33,159.60,'2022-12-04 12:37:12','',''),(3725,'1','285','1',1,'Retail Sale Id 3760',750.00,0.00,0.00,1.00,120.00,'2022-12-04 12:55:11','',''),(3726,'1','285','1',1,'Retail Sale Id 3761',750.00,0.00,0.00,1.00,120.00,'2022-12-04 13:05:50','',''),(3727,'1','285','1',1,'Retail Sale Id 3762',40200.00,0.00,0.00,60.00,2400.00,'2022-12-04 13:26:57','',''),(3728,'1','285','1',1,'Retail Sale Id 3763',1500.00,0.00,0.00,2.00,240.00,'2022-12-04 13:30:26','',''),(3729,'1','285','1',1,'Return of Retail Sale Id 3762',0.00,40200.00,60.00,0.00,-2400.00,'2022-12-04 13:41:04','',''),(3730,'1','285','1',1,'Retail Sale Id 3764',40019.10,0.00,0.00,59.73,2389.20,'2022-12-04 13:42:30','',''),(3731,'1','285','1',1,'Retail Sale Id 3765',3000.00,0.00,0.00,4.00,480.00,'2022-12-04 13:55:42','',''),(3732,'1','285','1',1,'Retail Sale Id 3766',3000.00,0.00,0.00,4.00,480.00,'2022-12-04 13:56:55','',''),(3733,'1','285','1',1,'Retail Sale Id 3767',997.50,0.00,0.00,1.33,159.60,'2022-12-04 14:05:14','',''),(3734,'1','285','1',1,'Retail Sale Id 3768',2250.00,0.00,0.00,3.00,360.00,'2022-12-04 14:06:05','',''),(3735,'1','285','1',1,'Retail Sale Id 3769',2002.50,0.00,0.00,2.67,320.40,'2022-12-04 14:06:53','',''),(3736,'1','285','1',1,'Retail Sale Id 3770',1500.00,0.00,0.00,2.00,240.00,'2022-12-04 14:08:03','',''),(3737,'1','285','1',1,'Retail Sale Id 3771',750.00,0.00,0.00,1.00,120.00,'2022-12-04 14:09:29','',''),(3738,'1','285','1',1,'Retail Sale Id 3772',997.50,0.00,0.00,1.33,159.60,'2022-12-04 14:10:41','',''),(3739,'1','285','1',1,'Retail Sale Id 3773',3502.50,0.00,0.00,4.67,560.40,'2022-12-04 14:15:31','',''),(3740,'1','285','1',1,'Retail Sale Id 3774',1500.00,0.00,0.00,2.00,240.00,'2022-12-04 14:40:17','',''),(3741,'1','285','1',1,'Retail Sale Id 3775',1500.00,0.00,0.00,2.00,240.00,'2022-12-04 14:41:13','',''),(3742,'1','285','1',1,'Retail Sale Id 3776',802.50,0.00,0.00,1.07,128.40,'2022-12-04 14:42:10','',''),(3743,'1','285','1',1,'Retail Sale Id 3777',6700.00,0.00,0.00,10.00,400.00,'2022-12-04 14:44:48','',''),(3744,'1','285','1',1,'Retail Sale Id 3778',5250.00,0.00,0.00,7.00,840.00,'2022-12-04 15:02:44','',''),(3745,'1','285','1',1,'Retail Sale Id 3779',1500.00,0.00,0.00,2.00,240.00,'2022-12-04 15:08:58','',''),(3746,'1','285','1',1,'Retail Sale Id 3780',1500.00,0.00,0.00,2.00,240.00,'2022-12-04 15:09:54','',''),(3747,'1','285','1',1,'Retail Sale Id 3781',2002.50,0.00,0.00,2.67,320.40,'2022-12-04 15:16:41','',''),(3748,'1','285','1',1,'Retail Sale Id 3782',1500.00,0.00,0.00,2.00,240.00,'2022-12-04 15:24:27','',''),(3749,'1','285','1',1,'Retail Sale Id 3783',1500.00,0.00,0.00,2.00,240.00,'2022-12-04 15:28:11','',''),(3750,'1','285','1',1,'Retail Sale Id 3784',3000.00,0.00,0.00,4.00,480.00,'2022-12-04 15:36:28','',''),(3751,'1','285','1',1,'Retail Sale Id 3785',40200.00,0.00,0.00,60.00,2400.00,'2022-12-04 15:39:16','',''),(3752,'1','285','1',1,'Retail Sale Id 3786',46900.00,0.00,0.00,70.00,2800.00,'2022-12-04 15:43:01','',''),(3753,'1','285','1',1,'Retail Sale Id 3787',750.00,0.00,0.00,1.00,120.00,'2022-12-04 16:03:42','',''),(3754,'1','285','1',1,'Retail Sale Id 3788',1500.00,0.00,0.00,2.00,240.00,'2022-12-04 16:07:26','',''),(3755,'1','285','1',1,'Retail Sale Id 3789',15872.30,0.00,0.00,23.69,947.60,'2022-12-04 16:13:13','',''),(3756,'1','285','1',1,'Retail Sale Id 3790',750.00,0.00,0.00,1.00,120.00,'2022-12-04 16:15:04','',''),(3757,'1','285','1',1,'Retail Sale Id 3791',44086.00,0.00,0.00,65.80,2632.00,'2022-12-04 16:29:13','',''),(3758,'1','285','1',1,'Retail Sale Id 3792',2250.00,0.00,0.00,3.00,360.00,'2022-12-04 16:31:51','',''),(3759,'1','285','1',1,'Retail Sale Id 3793',1500.00,0.00,0.00,2.00,240.00,'2022-12-04 16:53:09','',''),(3760,'1','285','1',1,'Retail Sale Id 3794',2002.50,0.00,0.00,2.67,320.40,'2022-12-04 16:55:20','',''),(3761,'1','285','1',1,'Retail Sale Id 3795',15363.10,0.00,0.00,22.93,917.20,'2022-12-04 16:56:13','',''),(3762,'1','285','1',1,'Retail Sale Id 3796',750.00,0.00,0.00,1.00,120.00,'2022-12-04 16:56:55','',''),(3763,'1','285','1',1,'Retail Sale Id 3797',4500.00,0.00,0.00,6.00,720.00,'2022-12-04 16:57:50','',''),(3764,'1','285','1',1,'Retail Sale Id 3798',1500.00,0.00,0.00,2.00,240.00,'2022-12-04 17:01:47','',''),(3765,'1','285','1',1,'Return of Retail Sale Id 3795',0.00,15363.10,22.93,0.00,-917.20,'2022-12-04 18:04:59','',''),(3766,'1','285','1',1,'Retail Sale Id 3799',8629.60,0.00,0.00,12.88,515.20,'2022-12-04 18:05:51','',''),(3767,'1','285','1',1,'Retail Sale Id 3800',7470.00,0.00,0.00,9.96,1195.20,'2022-12-04 18:08:44','',''),(3768,'1','285','1',1,'Return of Retail Sale Id 3800',0.00,7470.00,9.96,0.00,-1195.20,'2022-12-04 18:19:04','',''),(3769,'1','285','1',1,'Retail Sale Id 3801',6700.00,0.00,0.00,10.00,400.00,'2022-12-04 18:50:14','',''),(3770,'1','285','1',1,'Retail Sale Id 3802',997.50,0.00,0.00,1.33,159.60,'2022-12-05 07:07:38','',''),(3771,'1','285','1',1,'Retail Sale Id 3803',16649.50,0.00,0.00,24.85,994.00,'2022-12-05 07:23:35','',''),(3772,'1','285','1',1,'Retail Sale Id 3804',1500.00,0.00,0.00,2.00,240.00,'2022-12-05 07:25:03','',''),(3773,'1','285','1',1,'Retail Sale Id 3805',21440.00,0.00,0.00,32.00,1280.00,'2022-12-05 07:32:49','',''),(3774,'1','285','1',1,'Retail Sale Id 3806',26800.00,0.00,0.00,40.00,1600.00,'2022-12-05 07:35:18','',''),(3775,'1','285','1',1,'Retail Sale Id 3807',30150.00,0.00,0.00,45.00,1800.00,'2022-12-05 07:43:53','',''),(3776,'1','285','1',1,'Retail Sale Id 3808',50926.70,0.00,0.00,76.01,3040.40,'2022-12-05 07:56:54','',''),(3777,'1','285','1',1,'Retail Sale Id 3809',3000.00,0.00,0.00,4.00,480.00,'2022-12-05 08:10:05','',''),(3778,'1','285','1',1,'Retail Sale Id 3810',40200.00,0.00,0.00,60.00,2400.00,'2022-12-05 08:18:16','',''),(3779,'1','285','1',1,'Retail Sale Id 3811',997.50,0.00,0.00,1.33,159.60,'2022-12-05 08:21:38','',''),(3780,'1','285','1',1,'Retail Sale Id 3812',10331.40,0.00,0.00,15.42,616.80,'2022-12-05 08:23:02','',''),(3781,'1','285','1',1,'Retail Sale Id 3813',41466.30,0.00,0.00,61.89,2475.60,'2022-12-05 08:24:54','',''),(3782,'1','285','1',1,'Retail Sale Id 3814',2002.50,0.00,0.00,2.67,320.40,'2022-12-05 08:32:55','',''),(3783,'1','285','1',1,'Retail Sale Id 3816',41144.70,0.00,0.00,61.41,2456.40,'2022-12-05 08:39:28','',''),(3784,'1','285','1',1,'Retail Sale Id 3817',1500.00,0.00,0.00,2.00,240.00,'2022-12-05 08:43:22','',''),(3785,'1','285','1',1,'Retail Sale Id 3818',1500.00,0.00,0.00,2.00,240.00,'2022-12-05 08:44:06','',''),(3786,'1','285','1',1,'Retail Sale Id 3819',3000.00,0.00,0.00,4.00,480.00,'2022-12-05 08:48:16','',''),(3787,'1','285','1',1,'Retail Sale Id 3820',33500.00,0.00,0.00,50.00,2000.00,'2022-12-05 08:51:56','',''),(3788,'1','285','1',1,'Retail Sale Id 3821',1500.00,0.00,0.00,2.00,240.00,'2022-12-05 08:53:59','',''),(3789,'1','285','1',1,'Retail Sale Id 3822',9795.40,0.00,0.00,14.62,584.80,'2022-12-05 08:57:25','',''),(3790,'1','285','1',1,'Retail Sale Id 3823',23450.00,0.00,0.00,35.00,1400.00,'2022-12-05 09:02:09','',''),(3791,'1','285','1',1,'Retail Sale Id 3824',2250.00,0.00,0.00,3.00,360.00,'2022-12-05 09:11:34','',''),(3792,'1','285','1',1,'Retail Sale Id 3826',750.00,0.00,0.00,1.00,120.00,'2022-12-05 09:22:18','',''),(3793,'1','285','1',1,'Retail Sale Id 3827',2002.50,0.00,0.00,2.67,320.40,'2022-12-05 09:34:08','',''),(3794,'1','285','1',1,'Retail Sale Id 3828',16214.00,0.00,0.00,24.20,968.00,'2022-12-05 09:42:24','',''),(3795,'1','285','1',1,'Retail Sale Id 3829',7370.00,0.00,0.00,11.00,440.00,'2022-12-05 09:51:24','',''),(3796,'1','285','1',1,'Retail Sale Id 3830',1500.00,0.00,0.00,2.00,240.00,'2022-12-05 09:57:28','',''),(3797,'1','285','1',1,'Retail Sale Id 3831',1500.00,0.00,0.00,2.00,240.00,'2022-12-05 09:58:20','',''),(3798,'1','285','1',1,'Retail Sale Id 3832',9000.00,0.00,0.00,12.00,1440.00,'2022-12-05 10:06:14','',''),(3799,'1','285','1',1,'Retail Sale Id 3833',49807.80,0.00,0.00,74.34,2973.60,'2022-12-05 10:09:35','',''),(3800,'1','285','1',1,'Retail Sale Id 3834',1500.00,0.00,0.00,2.00,240.00,'2022-12-05 10:14:32','',''),(3801,'1','285','1',1,'Retail Sale Id 3835',750.00,0.00,0.00,1.00,120.00,'2022-12-05 10:22:25','',''),(3802,'1','285','1',1,'Retail Sale Id 3836',1500.00,0.00,0.00,2.00,240.00,'2022-12-05 10:23:30','',''),(3803,'1','285','1',1,'Retail Sale Id 3837',3750.00,0.00,0.00,5.00,600.00,'2022-12-05 10:24:47','',''),(3804,'1','285','1',1,'Retail Sale Id 3838',750.00,0.00,0.00,1.00,120.00,'2022-12-05 10:35:50','',''),(3805,'1','285','1',1,'Retail Sale Id 3839',167500.00,0.00,0.00,250.00,10000.00,'2022-12-05 10:38:11','',''),(3806,'1','285','1',1,'Retail Sale Id 3840',750.00,0.00,0.00,1.00,120.00,'2022-12-05 10:40:27','',''),(3807,'1','285','1',1,'Retail Sale Id 3841',2250.00,0.00,0.00,3.00,360.00,'2022-12-05 11:00:33','',''),(3808,'1','285','1',1,'Retail Sale Id 3842',17250.00,0.00,0.00,23.00,2760.00,'2022-12-05 11:03:11','',''),(3809,'1','285','1',1,'Retail Sale Id 3843',2250.00,0.00,0.00,3.00,360.00,'2022-12-05 11:10:27','',''),(3810,'1','285','1',1,'Return of Retail Sale Id 3842',0.00,17250.00,23.00,0.00,-2760.00,'2022-12-05 11:20:41','',''),(3811,'1','285','1',1,'Retail Sale Id 3844',15410.00,0.00,0.00,23.00,920.00,'2022-12-05 11:21:09','',''),(3812,'1','285','1',1,'Retail Sale Id 3845',3000.00,0.00,0.00,4.00,480.00,'2022-12-05 11:23:18','',''),(3813,'1','285','1',1,'Retail Sale Id 3846',10500.00,0.00,0.00,14.00,1680.00,'2022-12-05 11:24:20','',''),(3814,'1','285','1',1,'Retail Sale Id 3847',12750.00,0.00,0.00,17.00,2040.00,'2022-12-05 11:28:53','',''),(3815,'1','285','1',1,'Retail Sale Id 3848',1500.00,0.00,0.00,2.00,240.00,'2022-12-05 11:33:45','',''),(3816,'1','285','1',1,'Retail Sale Id 3850',49245.00,0.00,0.00,73.50,2940.00,'2022-12-05 11:44:29','',''),(3817,'1','285','1',1,'Retail Sale Id 3851',1500.00,0.00,0.00,2.00,240.00,'2022-12-05 11:46:24','',''),(3818,'1','285','1',1,'Retail Sale Id 3853',1500.00,0.00,0.00,2.00,240.00,'2022-12-05 12:02:32','',''),(3819,'1','285','1',1,'Retail Sale Id 3854',80400.00,0.00,0.00,120.00,4800.00,'2022-12-05 12:13:09','',''),(3820,'1','285','1',1,'Retail Sale Id 3855',3000.00,0.00,0.00,4.00,480.00,'2022-12-05 12:17:36','',''),(3821,'1','285','1',1,'Retail Sale Id 3856',7500.00,0.00,0.00,10.00,1200.00,'2022-12-05 12:28:50','',''),(3822,'1','285','1',1,'Retail Sale Id 3857',1500.00,0.00,0.00,2.00,240.00,'2022-12-05 12:40:25','',''),(3823,'1','285','1',1,'Retail Sale Id 3858',9750.00,0.00,0.00,13.00,1560.00,'2022-12-05 12:42:27','',''),(3824,'1','285','1',1,'Retail Sale Id 3859',4500.00,0.00,0.00,6.00,720.00,'2022-12-05 13:00:00','',''),(3825,'1','285','1',1,'Retail Sale Id 3860',997.50,0.00,0.00,1.33,159.60,'2022-12-05 13:00:54','',''),(3826,'1','285','1',1,'Retail Sale Id 3861',2250.00,0.00,0.00,3.00,360.00,'2022-12-05 13:02:19','',''),(3827,'1','285','1',1,'Retail Sale Id 3862',2250.00,0.00,0.00,3.00,360.00,'2022-12-05 13:09:22','',''),(3828,'1','285','1',1,'Retail Sale Id 3863',2002.50,0.00,0.00,2.67,320.40,'2022-12-05 13:10:52','',''),(3829,'1','285','1',1,'Retail Sale Id 3864',3750.00,0.00,0.00,5.00,600.00,'2022-12-05 13:12:01','',''),(3830,'1','285','1',1,'Retail Sale Id 3865',1500.00,0.00,0.00,2.00,240.00,'2022-12-05 13:13:00','',''),(3831,'1','285','1',1,'Retail Sale Id 3866',9375.00,0.00,0.00,12.50,1500.00,'2022-12-05 13:13:53','',''),(3832,'1','285','1',1,'Retail Sale Id 3867',2250.00,0.00,0.00,3.00,360.00,'2022-12-05 13:15:21','',''),(3833,'1','285','1',1,'Retail Sale Id 3868',1500.00,0.00,0.00,2.00,240.00,'2022-12-05 13:16:29','',''),(3834,'1','285','1',1,'Retail Sale Id 3869',3750.00,0.00,0.00,5.00,600.00,'2022-12-05 13:26:02','',''),(3835,'1','285','1',1,'Retail Sale Id 3870',97042.80,0.00,0.00,144.84,5793.60,'2022-12-05 13:30:45','',''),(3836,'1','285','1',1,'Retail Sale Id 3871',3000.00,0.00,0.00,4.00,480.00,'2022-12-05 13:31:51','',''),(3837,'1','285','1',1,'Retail Sale Id 3872',13400.00,0.00,0.00,20.00,800.00,'2022-12-05 13:56:07','',''),(3838,'1','285','1',1,'Retail Sale Id 3873',1500.00,0.00,0.00,2.00,240.00,'2022-12-05 14:03:08','',''),(3839,'1','285','1',1,'Retail Sale Id 3874',1500.00,0.00,0.00,2.00,240.00,'2022-12-05 14:09:22','',''),(3840,'1','285','1',1,'Retail Sale Id 3875',9654.70,0.00,0.00,14.41,576.40,'2022-12-05 14:10:59','',''),(3841,'1','285','1',1,'Retail Sale Id 3876',5250.00,0.00,0.00,7.00,840.00,'2022-12-05 14:12:58','',''),(3842,'1','285','1',1,'Retail Sale Id 3877',750.00,0.00,0.00,1.00,120.00,'2022-12-05 14:35:49','',''),(3843,'1','285','1',1,'Retail Sale Id 3878',19711.40,0.00,0.00,29.42,1176.80,'2022-12-05 14:43:50','',''),(3844,'1','285','1',1,'Retail Sale Id 3879',2497.50,0.00,0.00,3.33,399.60,'2022-12-05 14:47:17','',''),(3845,'1','285','1',1,'Retail Sale Id 3880',997.50,0.00,0.00,1.33,159.60,'2022-12-05 14:52:23','',''),(3846,'1','285','1',1,'Retail Sale Id 3881',1500.00,0.00,0.00,2.00,240.00,'2022-12-05 14:59:54','',''),(3847,'1','285','1',1,'Retail Sale Id 3882',997.50,0.00,0.00,1.33,159.60,'2022-12-05 15:15:00','',''),(3848,'1','285','1',1,'Retail Sale Id 3883',10500.00,0.00,0.00,14.00,1680.00,'2022-12-05 15:19:14','',''),(3849,'1','285','1',1,'Retail Sale Id 3884',25125.00,0.00,0.00,37.50,1500.00,'2022-12-05 15:20:30','',''),(3850,'1','285','1',1,'Retail Sale Id 3885',2250.00,0.00,0.00,3.00,360.00,'2022-12-05 15:22:36','',''),(3851,'1','285','1',1,'Retail Sale Id 3886',3750.00,0.00,0.00,5.00,600.00,'2022-12-05 15:26:09','',''),(3852,'1','285','1',1,'Retail Sale Id 3887',40253.60,0.00,0.00,60.08,2403.20,'2022-12-05 15:30:36','',''),(3853,'1','285','1',1,'Retail Sale Id 3889',6000.00,0.00,0.00,8.00,960.00,'2022-12-05 15:33:39','',''),(3854,'1','285','1',1,'Retail Sale Id 3890',60300.00,0.00,0.00,90.00,3600.00,'2022-12-05 15:35:46','',''),(3855,'1','285','1',1,'Retail Sale Id 3891',2250.00,0.00,0.00,3.00,360.00,'2022-12-05 15:38:21','',''),(3856,'1','285','1',1,'Retail Sale Id 3892',19430.00,0.00,0.00,29.00,1160.00,'2022-12-05 15:41:26','',''),(3857,'1','285','1',1,'Retail Sale Id 3893',1500.00,0.00,0.00,2.00,240.00,'2022-12-05 15:47:35','',''),(3858,'1','285','1',1,'Retail Sale Id 3894',3000.00,0.00,0.00,4.00,480.00,'2022-12-05 15:48:44','',''),(3859,'1','285','1',1,'Retail Sale Id 3895',7370.00,0.00,0.00,11.00,440.00,'2022-12-05 15:50:24','',''),(3860,'1','285','1',1,'Retail Sale Id 3896',7500.00,0.00,0.00,10.00,1200.00,'2022-12-05 15:55:01','',''),(3861,'1','285','1',1,'Retail Sale Id 3897',9375.00,0.00,0.00,12.50,1500.00,'2022-12-05 15:57:48','',''),(3862,'1','285','1',1,'Retail Sale Id 3901',2250.00,0.00,0.00,3.00,360.00,'2022-12-05 16:17:06','',''),(3863,'1','285','1',1,'Retail Sale Id 3902',3000.00,0.00,0.00,4.00,480.00,'2022-12-05 16:21:44','',''),(3864,'1','285','1',1,'Retail Sale Id 3903',2250.00,0.00,0.00,3.00,360.00,'2022-12-05 16:22:48','',''),(3865,'1','285','1',1,'Return of Retail Sale Id 3817',0.00,1500.00,2.00,0.00,-240.00,'2022-12-05 16:24:15','',''),(3866,'1','285','1',1,'Retail Sale Id 3905',9375.00,0.00,0.00,12.50,1500.00,'2022-12-05 16:25:17','',''),(3867,'1','285','1',1,'Return of Retail Sale Id 3871',0.00,3000.00,4.00,0.00,-480.00,'2022-12-05 16:26:24','',''),(3868,'1','285','1',1,'Retail Sale Id 3906',1500.00,0.00,0.00,2.00,240.00,'2022-12-05 16:26:50','',''),(3869,'1','285','1',1,'Retail Sale Id 3907',8710.00,0.00,0.00,13.00,520.00,'2022-12-05 16:36:12','',''),(3870,'1','285','1',1,'Return of Retail Sale Id 3897',0.00,9375.00,12.50,0.00,-1500.00,'2022-12-05 16:37:26','',''),(3871,'1','285','1',1,'Return of Retail Sale Id 3896',0.00,7500.00,10.00,0.00,-1200.00,'2022-12-05 16:37:57','',''),(3872,'1','285','1',1,'Retail Sale Id 3908',15075.00,0.00,0.00,22.50,900.00,'2022-12-05 16:38:51','',''),(3873,'1','285','1',1,'Retail Sale Id 3909',4500.00,0.00,0.00,6.00,720.00,'2022-12-05 16:41:48','',''),(3874,'1','285','1',1,'Retail Sale Id 3910',30150.00,0.00,0.00,45.00,1800.00,'2022-12-05 16:43:23','',''),(3875,'1','285','1',1,'Retail Sale Id 3911',2250.00,0.00,0.00,3.00,360.00,'2022-12-05 16:44:49','',''),(3876,'1','285','1',1,'Retail Sale Id 3912',40414.40,0.00,0.00,60.32,2412.80,'2022-12-05 16:51:52','',''),(3877,'1','285','1',1,'Retail Sale Id 3913',750.00,0.00,0.00,1.00,120.00,'2022-12-05 16:54:55','',''),(3878,'1','285','1',1,'Retail Sale Id 3914',16875.00,0.00,0.00,22.50,2700.00,'2022-12-05 17:01:48','',''),(3879,'1','285','1',1,'Return of Retail Sale Id 3908',0.00,15075.00,22.50,0.00,-900.00,'2022-12-05 17:02:26','',''),(3880,'1','285','1',1,'Return of Retail Sale Id 3889',0.00,6000.00,8.00,0.00,-960.00,'2022-12-05 19:26:08','',''),(3881,'1','285','1',1,'Retail Sale Id 3915',1867.50,0.00,0.00,2.49,298.80,'2022-12-05 19:28:58','',''),(3882,'1','285','1',1,'Retail Sale Id 3916',1762.10,0.00,0.00,2.63,105.20,'2022-12-05 19:39:24','',''),(3883,'1','285','1',1,'Retail Sale Id 3917',2250.00,0.00,0.00,3.00,360.00,'2022-12-06 07:03:43','',''),(3884,'1','285','1',1,'Retail Sale Id 3918',1500.00,0.00,0.00,2.00,240.00,'2022-12-06 07:19:39','',''),(3885,'1','285','1',1,'Retail Sale Id 3919',39329.00,0.00,0.00,58.70,2348.00,'2022-12-06 07:28:52','',''),(3886,'1','285','1',1,'Retail Sale Id 3920',41841.50,0.00,0.00,62.45,2498.00,'2022-12-06 07:33:26','',''),(3887,'1','285','1',1,'Retail Sale Id 3921',2002.50,0.00,0.00,2.67,320.40,'2022-12-06 07:34:35','',''),(3888,'1','285','1',1,'Retail Sale Id 3922',1500.00,0.00,0.00,2.00,240.00,'2022-12-06 07:36:28','',''),(3889,'1','285','1',1,'Retail Sale Id 3923',13400.00,0.00,0.00,20.00,800.00,'2022-12-06 07:38:32','',''),(3890,'1','285','1',1,'Retail Sale Id 3924',14070.00,0.00,0.00,21.00,840.00,'2022-12-06 07:40:53','',''),(3891,'1','285','1',1,'Retail Sale Id 3925',2250.00,0.00,0.00,3.00,360.00,'2022-12-06 07:42:26','',''),(3892,'1','285','1',1,'Retail Sale Id 3926',1500.00,0.00,0.00,2.00,240.00,'2022-12-06 07:43:34','',''),(3893,'1','285','1',1,'Retail Sale Id 3927',2250.00,0.00,0.00,3.00,360.00,'2022-12-06 07:48:55','',''),(3894,'1','285','1',1,'Retail Sale Id 3928',1500.00,0.00,0.00,2.00,240.00,'2022-12-06 08:03:44','',''),(3895,'1','285','1',1,'Retail Sale Id 3929',2250.00,0.00,0.00,3.00,360.00,'2022-12-06 08:05:33','',''),(3896,'1','285','1',1,'Retail Sale Id 3930',28810.00,0.00,0.00,43.00,1720.00,'2022-12-06 08:06:59','',''),(3897,'1','285','1',1,'Retail Sale Id 3931',2002.50,0.00,0.00,2.67,320.40,'2022-12-06 08:12:54','',''),(3898,'1','285','1',1,'Retail Sale Id 3932',1500.00,0.00,0.00,2.00,240.00,'2022-12-06 08:14:29','',''),(3899,'1','285','1',1,'Retail Sale Id 3933',32930.50,0.00,0.00,49.15,1966.00,'2022-12-06 08:18:38','',''),(3900,'1','285','1',1,'Retail Sale Id 3934',2250.00,0.00,0.00,3.00,360.00,'2022-12-06 08:22:18','',''),(3901,'1','285','1',1,'Retail Sale Id 3935',40200.00,0.00,0.00,60.00,2400.00,'2022-12-06 08:29:49','',''),(3902,'1','285','1',1,'Retail Sale Id 3936',750.00,0.00,0.00,1.00,120.00,'2022-12-06 08:31:24','',''),(3903,'1','285','1',1,'Retail Sale Id 3937',1500.00,0.00,0.00,2.00,240.00,'2022-12-06 08:36:23','',''),(3904,'1','285','1',1,'Retail Sale Id 3938',16515.50,0.00,0.00,24.65,986.00,'2022-12-06 08:46:35','',''),(3905,'1','285','1',1,'Retail Sale Id 3940',2002.50,0.00,0.00,2.67,320.40,'2022-12-06 09:19:59','',''),(3906,'1','285','1',1,'Retail Sale Id 3941',33500.00,0.00,0.00,50.00,2000.00,'2022-12-06 09:27:58','',''),(3907,'1','285','1',1,'Retail Sale Id 3942',20100.00,0.00,0.00,30.00,1200.00,'2022-12-06 09:31:26','',''),(3908,'1','285','1',1,'Retail Sale Id 3943',750.00,0.00,0.00,1.00,120.00,'2022-12-06 09:42:04','',''),(3909,'1','285','1',1,'Retail Sale Id 3944',80031.50,0.00,0.00,119.45,4778.00,'2022-12-06 09:48:49','',''),(3910,'1','285','1',1,'Retail Sale Id 3945',167500.00,0.00,0.00,250.00,10000.00,'2022-12-06 09:55:17','',''),(3911,'1','285','1',1,'Retail Sale Id 3946',94161.80,0.00,0.00,140.54,5621.60,'2022-12-06 09:58:55','',''),(3912,'1','285','1',1,'Retail Sale Id 3947',50732.40,0.00,0.00,75.72,3028.80,'2022-12-06 10:02:12','',''),(3913,'1','285','1',1,'Retail Sale Id 3948',2250.00,0.00,0.00,3.00,360.00,'2022-12-06 10:04:14','',''),(3914,'1','285','1',1,'Retail Sale Id 3950',41332.30,0.00,0.00,61.69,2467.60,'2022-12-06 10:06:58','',''),(3915,'1','285','1',1,'Retail Sale Id 3951',750.00,0.00,0.00,1.00,120.00,'2022-12-06 10:07:43','',''),(3916,'1','285','1',1,'Retail Sale Id 3952',3000.00,0.00,0.00,4.00,480.00,'2022-12-06 10:08:26','',''),(3917,'1','285','1',1,'Retail Sale Id 3953',33500.00,0.00,0.00,50.00,2000.00,'2022-12-06 10:09:34','',''),(3918,'1','285','1',1,'Retail Sale Id 3954',997.50,0.00,0.00,1.33,159.60,'2022-12-06 10:10:25','',''),(3919,'1','285','1',1,'Retail Sale Id 3955',4500.00,0.00,0.00,6.00,720.00,'2022-12-06 10:19:59','',''),(3920,'1','285','1',1,'Retail Sale Id 3956',1500.00,0.00,0.00,2.00,240.00,'2022-12-06 10:21:16','',''),(3921,'1','285','1',1,'Retail Sale Id 3957',802.50,0.00,0.00,1.07,128.40,'2022-12-06 10:26:00','',''),(3922,'1','285','1',1,'Retail Sale Id 3958',3000.00,0.00,0.00,4.00,480.00,'2022-12-06 10:36:16','',''),(3923,'1','285','1',1,'Retail Sale Id 3959',750.00,0.00,0.00,1.00,120.00,'2022-12-06 11:02:32','',''),(3924,'1','285','1',1,'Retail Sale Id 3960',2250.00,0.00,0.00,3.00,360.00,'2022-12-06 11:13:52','',''),(3925,'1','285','1',1,'Retail Sale Id 3961',4500.00,0.00,0.00,6.00,720.00,'2022-12-06 11:16:50','',''),(3926,'1','285','1',1,'Retail Sale Id 3962',2250.00,0.00,0.00,3.00,360.00,'2022-12-06 11:18:48','',''),(3927,'1','285','1',1,'Retail Sale Id 3963',997.50,0.00,0.00,1.33,159.60,'2022-12-06 11:41:29','',''),(3928,'1','285','1',1,'Retail Sale Id 3964',750.00,0.00,0.00,1.00,120.00,'2022-12-06 11:47:59','',''),(3929,'1','285','1',1,'Retail Sale Id 3965',2250.00,0.00,0.00,3.00,360.00,'2022-12-06 11:50:55','',''),(3930,'1','285','1',1,'Retail Sale Id 3966',45037.40,0.00,0.00,67.22,2688.80,'2022-12-06 12:47:53','',''),(3931,'1','285','1',1,'Retail Sale Id 3967',246251.80,0.00,0.00,367.54,14701.60,'2022-12-06 12:58:49','',''),(3932,'1','285','1',1,'Retail Sale Id 3968',1500.00,0.00,0.00,2.00,240.00,'2022-12-06 13:05:27','',''),(3933,'1','285','1',1,'Retail Sale Id 3969',3750.00,0.00,0.00,5.00,600.00,'2022-12-06 13:17:55','',''),(3934,'1','285','1',1,'Retail Sale Id 3970',2250.00,0.00,0.00,3.00,360.00,'2022-12-06 13:20:19','',''),(3935,'1','285','1',1,'Retail Sale Id 3971',3000.00,0.00,0.00,4.00,480.00,'2022-12-06 13:48:43','',''),(3936,'1','285','1',1,'Retail Sale Id 3972',3997.50,0.00,0.00,5.33,639.60,'2022-12-06 13:51:50','',''),(3937,'1','285','1',1,'Retail Sale Id 3973',997.50,0.00,0.00,1.33,159.60,'2022-12-06 13:53:06','',''),(3938,'1','285','1',1,'Retail Sale Id 3974',7500.00,0.00,0.00,10.00,1200.00,'2022-12-06 14:02:03','',''),(3939,'1','285','1',1,'Retail Sale Id 3975',2250.00,0.00,0.00,3.00,360.00,'2022-12-06 14:04:03','',''),(3940,'1','285','1',1,'Retail Sale Id 3976',3000.00,0.00,0.00,4.00,480.00,'2022-12-06 14:06:29','',''),(3941,'1','285','1',1,'Retail Sale Id 3979',490520.40,0.00,0.00,732.12,29284.80,'2022-12-06 14:24:44','',''),(3942,'1','285','1',1,'Retail Sale Id 3980',30150.00,0.00,0.00,45.00,1800.00,'2022-12-06 14:26:50','',''),(3943,'1','285','1',1,'Retail Sale Id 3981',1500.00,0.00,0.00,2.00,240.00,'2022-12-06 14:49:46','',''),(3944,'1','285','1',1,'Retail Sale Id 3982',2250.00,0.00,0.00,3.00,360.00,'2022-12-06 15:03:50','',''),(3945,'1','285','1',1,'Retail Sale Id 3984',6000.00,0.00,0.00,8.00,960.00,'2022-12-06 15:07:11','',''),(3946,'1','285','1',1,'Retail Sale Id 3985',1500.00,0.00,0.00,2.00,240.00,'2022-12-06 15:14:22','',''),(3947,'1','285','1',1,'Retail Sale Id 3986',750.00,0.00,0.00,1.00,120.00,'2022-12-06 15:25:02','',''),(3948,'1','285','1',1,'Retail Sale Id 3989',4020.00,0.00,0.00,6.00,240.00,'2022-12-06 15:36:57','',''),(3949,'1','285','1',1,'Retail Sale Id 3990',1500.00,0.00,0.00,2.00,240.00,'2022-12-06 15:40:44','',''),(3950,'1','285','1',1,'Retail Sale Id 3991',49747.50,0.00,0.00,74.25,2970.00,'2022-12-06 15:59:26','',''),(3951,'1','285','1',1,'Retail Sale Id 3992',1500.00,0.00,0.00,2.00,240.00,'2022-12-06 16:04:10','',''),(3952,'1','285','1',1,'Retail Sale Id 3995',1500.00,0.00,0.00,2.00,240.00,'2022-12-06 16:06:17','',''),(3953,'1','285','1',1,'Retail Sale Id 3997',33500.00,0.00,0.00,50.00,2000.00,'2022-12-06 16:08:38','',''),(3954,'1','285','1',1,'Retail Sale Id 3998',1500.00,0.00,0.00,2.00,240.00,'2022-12-06 16:10:20','',''),(3955,'1','285','1',1,'Retail Sale Id 3999',2250.00,0.00,0.00,3.00,360.00,'2022-12-06 16:12:30','',''),(3956,'1','285','1',1,'Retail Sale Id 4000',57928.20,0.00,0.00,86.46,3458.40,'2022-12-06 16:41:41','',''),(3957,'1','285','1',1,'Retail Sale Id 4001',3000.00,0.00,0.00,4.00,480.00,'2022-12-06 16:47:27','',''),(3958,'1','285','1',1,'Retail Sale Id 4002',1500.00,0.00,0.00,2.00,240.00,'2022-12-06 16:51:25','',''),(3959,'1','285','1',1,'Retail Sale Id 4003',5250.00,0.00,0.00,7.00,840.00,'2022-12-06 16:58:10','',''),(3960,'1','285','1',1,'Retail Sale Id 4004',3750.00,0.00,0.00,5.00,600.00,'2022-12-06 16:58:47','',''),(3961,'1','285','1',1,'Retail Sale Id 4005',1500.00,0.00,0.00,2.00,240.00,'2022-12-06 16:59:15','',''),(3962,'1','285','1',1,'Return of Retail Sale Id 3976',0.00,3000.00,4.00,0.00,-480.00,'2022-12-06 17:14:55','',''),(3963,'1','285','1',1,'Return of Retail Sale Id 3929',0.00,2250.00,3.00,0.00,-360.00,'2022-12-06 17:16:07','',''),(3964,'1','285','1',1,'Retail Sale Id 4006',40200.00,0.00,0.00,60.00,2400.00,'2022-12-07 07:22:11','',''),(3965,'1','285','1',1,'Retail Sale Id 4007',8250.00,0.00,0.00,11.00,1320.00,'2022-12-07 07:23:31','',''),(3966,'1','285','1',1,'Retail Sale Id 4008',40200.00,0.00,0.00,60.00,2400.00,'2022-12-07 07:26:20','',''),(3967,'1','285','1',1,'Retail Sale Id 4009',1500.00,0.00,0.00,2.00,240.00,'2022-12-07 07:30:38','',''),(3968,'1','285','1',1,'Retail Sale Id 4010',41144.70,0.00,0.00,61.41,2456.40,'2022-12-07 07:36:48','',''),(3969,'1','285','1',1,'Retail Sale Id 4011',85492.00,0.00,0.00,127.60,5104.00,'2022-12-07 07:49:19','',''),(3970,'1','285','1',1,'Retail Sale Id 4012',33500.00,0.00,0.00,50.00,2000.00,'2022-12-07 07:54:45','',''),(3971,'1','285','1',1,'Retail Sale Id 4013',5250.00,0.00,0.00,7.00,840.00,'2022-12-07 07:56:44','',''),(3972,'1','285','1',1,'Retail Sale Id 4014',16368.10,0.00,0.00,24.43,977.20,'2022-12-07 08:03:36','',''),(3973,'1','285','1',1,'Return of Retail Sale Id 4014',0.00,16368.10,24.43,0.00,-977.20,'2022-12-07 08:05:21','',''),(3974,'1','285','1',1,'Retail Sale Id 4015',32495.00,0.00,0.00,48.50,1940.00,'2022-12-07 08:07:43','',''),(3975,'1','285','1',1,'Retail Sale Id 4016',6000.00,0.00,0.00,8.00,960.00,'2022-12-07 08:12:44','',''),(3976,'1','285','1',1,'Retail Sale Id 4017',36850.00,0.00,0.00,55.00,2200.00,'2022-12-07 08:15:37','',''),(3977,'1','285','1',1,'Retail Sale Id 4018',2250.00,0.00,0.00,3.00,360.00,'2022-12-07 08:24:20','',''),(3978,'1','285','1',1,'Retail Sale Id 4019',2250.00,0.00,0.00,3.00,360.00,'2022-12-07 08:32:39','',''),(3979,'1','285','1',1,'Retail Sale Id 4020',40200.00,0.00,0.00,60.00,2400.00,'2022-12-07 08:37:10','',''),(3980,'1','285','1',1,'Retail Sale Id 4022',1500.00,0.00,0.00,2.00,240.00,'2022-12-07 08:39:17','',''),(3981,'1','285','1',1,'Retail Sale Id 4023',1500.00,0.00,0.00,2.00,240.00,'2022-12-07 08:44:15','',''),(3982,'1','285','1',1,'Retail Sale Id 4024',3000.00,0.00,0.00,4.00,480.00,'2022-12-07 08:50:44','',''),(3983,'1','285','1',1,'Retail Sale Id 4025',14740.00,0.00,0.00,22.00,880.00,'2022-12-07 09:00:31','',''),(3984,'1','285','1',1,'Retail Sale Id 4027',16595.90,0.00,0.00,24.77,990.80,'2022-12-07 09:05:07','',''),(3985,'1','285','1',1,'Retail Sale Id 4028',802.50,0.00,0.00,1.07,128.40,'2022-12-07 09:07:58','',''),(3986,'1','285','1',1,'Retail Sale Id 4029',3000.00,0.00,0.00,4.00,480.00,'2022-12-07 09:40:35','',''),(3987,'1','285','1',1,'Retail Sale Id 4030',28140.00,0.00,0.00,42.00,1680.00,'2022-12-07 09:43:03','',''),(3988,'1','285','1',1,'Retail Sale Id 4031',8040.00,0.00,0.00,12.00,480.00,'2022-12-07 09:48:20','',''),(3989,'1','285','1',1,'Retail Sale Id 4032',2002.50,0.00,0.00,2.67,320.40,'2022-12-07 09:49:57','',''),(3990,'1','285','1',1,'Retail Sale Id 4033',3000.00,0.00,0.00,4.00,480.00,'2022-12-07 09:51:09','',''),(3991,'1','285','1',1,'Retail Sale Id 4034',26800.00,0.00,0.00,40.00,1600.00,'2022-12-07 09:53:25','',''),(3992,'1','285','1',1,'Retail Sale Id 4035',997.50,0.00,0.00,1.33,159.60,'2022-12-07 10:09:39','',''),(3993,'1','285','1',1,'Retail Sale Id 4036',1500.00,0.00,0.00,2.00,240.00,'2022-12-07 10:11:52','',''),(3994,'1','285','1',1,'Retail Sale Id 4037',1500.00,0.00,0.00,2.00,240.00,'2022-12-07 10:12:59','',''),(3995,'1','285','1',1,'Retail Sale Id 4038',5250.00,0.00,0.00,7.00,840.00,'2022-12-07 10:26:42','',''),(3996,'1','285','1',1,'Retail Sale Id 4039',36180.00,0.00,0.00,54.00,2160.00,'2022-12-07 10:30:53','',''),(3997,'1','285','1',1,'Retail Sale Id 4040',1500.00,0.00,0.00,2.00,240.00,'2022-12-07 10:42:24','',''),(3998,'1','285','1',1,'Retail Sale Id 4041',1500.00,0.00,0.00,2.00,240.00,'2022-12-07 10:48:24','',''),(3999,'1','285','1',1,'Retail Sale Id 4042',802.50,0.00,0.00,1.07,128.40,'2022-12-07 10:49:18','',''),(4000,'1','285','1',1,'Retail Sale Id 4043',750.00,0.00,0.00,1.00,120.00,'2022-12-07 10:53:45','',''),(4001,'1','285','1',1,'Retail Sale Id 4044',26987.60,0.00,0.00,40.28,1611.20,'2022-12-07 10:59:23','',''),(4002,'1','285','1',1,'Retail Sale Id 4045',335000.00,0.00,0.00,500.00,20000.00,'2022-12-07 11:02:16','',''),(4003,'1','285','1',1,'Retail Sale Id 4046',3000.00,0.00,0.00,4.00,480.00,'2022-12-07 11:07:35','',''),(4004,'1','285','1',1,'Retail Sale Id 4047',1500.00,0.00,0.00,2.00,240.00,'2022-12-07 11:08:37','',''),(4005,'1','285','1',1,'Return of Retail Sale Id 4046',0.00,3000.00,4.00,0.00,-480.00,'2022-12-07 11:19:15','',''),(4006,'1','285','1',1,'Retail Sale Id 4048',2790.00,0.00,0.00,3.72,446.40,'2022-12-07 11:20:12','',''),(4007,'1','285','1',1,'Retail Sale Id 4049',1500.00,0.00,0.00,2.00,240.00,'2022-12-07 11:36:44','',''),(4008,'1','285','1',1,'Retail Sale Id 4050',3750.00,0.00,0.00,5.00,600.00,'2022-12-07 11:38:03','',''),(4009,'1','285','1',1,'Retail Sale Id 4051',18760.00,0.00,0.00,28.00,1120.00,'2022-12-07 11:52:54','',''),(4010,'1','285','1',1,'Retail Sale Id 4052',3997.50,0.00,0.00,5.33,639.60,'2022-12-07 11:55:45','',''),(4011,'1','285','1',1,'Retail Sale Id 4053',29480.00,0.00,0.00,44.00,1760.00,'2022-12-07 12:02:40','',''),(4012,'1','285','1',1,'Retail Sale Id 4054',997.50,0.00,0.00,1.33,159.60,'2022-12-07 12:07:39','',''),(4013,'1','285','1',1,'Retail Sale Id 4055',1500.00,0.00,0.00,2.00,240.00,'2022-12-07 12:14:40','',''),(4014,'1','285','1',1,'Retail Sale Id 4056',802.50,0.00,0.00,1.07,128.40,'2022-12-07 12:19:24','',''),(4015,'1','285','1',1,'Retail Sale Id 4057',37185.00,0.00,0.00,55.50,2220.00,'2022-12-07 12:27:46','',''),(4016,'1','285','1',1,'Retail Sale Id 4059',3000.00,0.00,0.00,4.00,480.00,'2022-12-07 12:46:37','',''),(4017,'1','285','1',1,'Retail Sale Id 4060',2250.00,0.00,0.00,3.00,360.00,'2022-12-07 13:02:52','',''),(4018,'1','285','1',1,'Retail Sale Id 4061',2250.00,0.00,0.00,3.00,360.00,'2022-12-07 13:04:19','',''),(4019,'1','285','1',1,'Retail Sale Id 4062',997.50,0.00,0.00,1.33,159.60,'2022-12-07 13:05:32','',''),(4020,'1','285','1',1,'Retail Sale Id 4063',40896.80,0.00,0.00,61.04,2441.60,'2022-12-07 13:06:31','',''),(4021,'1','285','1',1,'Retail Sale Id 4064',2250.00,0.00,0.00,3.00,360.00,'2022-12-07 13:50:40','',''),(4022,'1','285','1',1,'Retail Sale Id 4065',1500.00,0.00,0.00,2.00,240.00,'2022-12-07 13:54:43','',''),(4023,'1','285','1',1,'Retail Sale Id 4066',1500.00,0.00,0.00,2.00,240.00,'2022-12-07 14:07:03','',''),(4024,'1','285','1',1,'Retail Sale Id 4067',9000.00,0.00,0.00,12.00,1440.00,'2022-12-07 14:11:24','',''),(4025,'1','285','1',1,'Retail Sale Id 4068',1500.00,0.00,0.00,2.00,240.00,'2022-12-07 14:16:21','',''),(4026,'1','285','1',1,'Retail Sale Id 4069',750.00,0.00,0.00,1.00,120.00,'2022-12-07 14:17:24','',''),(4027,'1','285','1',1,'Retail Sale Id 4070',9916.00,0.00,0.00,14.80,592.00,'2022-12-07 14:44:54','',''),(4028,'1','285','1',1,'Retail Sale Id 4071',1500.00,0.00,0.00,2.00,240.00,'2022-12-07 15:10:40','',''),(4029,'1','285','1',1,'Retail Sale Id 4072',41540.00,0.00,0.00,62.00,2480.00,'2022-12-07 15:18:56','',''),(4030,'1','285','1',1,'Retail Sale Id 4073',1500.00,0.00,0.00,2.00,240.00,'2022-12-07 15:21:13','',''),(4031,'1','285','1',1,'Retail Sale Id 4074',3997.50,0.00,0.00,5.33,639.60,'2022-12-07 15:24:30','',''),(4032,'1','285','1',1,'Retail Sale Id 4075',4500.00,0.00,0.00,6.00,720.00,'2022-12-07 15:31:41','',''),(4033,'1','285','1',1,'Retail Sale Id 4076',40836.50,0.00,0.00,60.95,2438.00,'2022-12-07 15:51:16','',''),(4034,'1','285','1',1,'Retail Sale Id 4077',40809.70,0.00,0.00,60.91,2436.40,'2022-12-07 15:55:10','',''),(4035,'1','285','1',1,'Retail Sale Id 4078',3000.00,0.00,0.00,4.00,480.00,'2022-12-07 15:56:23','',''),(4036,'1','285','1',1,'Retail Sale Id 4079',3000.00,0.00,0.00,4.00,480.00,'2022-12-07 16:01:26','',''),(4037,'1','285','1',1,'Retail Sale Id 4080',4500.00,0.00,0.00,6.00,720.00,'2022-12-07 16:18:52','',''),(4038,'1','285','1',1,'Retail Sale Id 4081',77532.40,0.00,0.00,115.72,4628.80,'2022-12-07 16:22:05','',''),(4039,'1','285','1',1,'Return of Retail Sale Id 4067',0.00,9000.00,12.00,0.00,-1440.00,'2022-12-07 16:23:27','',''),(4040,'1','285','1',1,'Retail Sale Id 4082',750.00,0.00,0.00,1.00,120.00,'2022-12-07 16:24:41','',''),(4041,'1','285','1',1,'Retail Sale Id 4083',3000.00,0.00,0.00,4.00,480.00,'2022-12-07 16:28:10','',''),(4042,'1','285','1',1,'Retail Sale Id 4084',8250.00,0.00,0.00,11.00,1320.00,'2022-12-07 16:33:16','',''),(4043,'1','285','1',1,'Retail Sale Id 4085',1500.00,0.00,0.00,2.00,240.00,'2022-12-07 16:34:27','',''),(4044,'1','285','1',1,'Retail Sale Id 4086',3750.00,0.00,0.00,5.00,600.00,'2022-12-07 16:36:54','',''),(4045,'1','285','1',1,'Retail Sale Id 4087',802.50,0.00,0.00,1.07,128.40,'2022-12-07 16:46:22','',''),(4046,'1','285','1',1,'Retail Sale Id 4088',4500.00,0.00,0.00,6.00,720.00,'2022-12-07 16:48:48','',''),(4047,'1','285','1',1,'Retail Sale Id 4089',802.50,0.00,0.00,1.07,128.40,'2022-12-07 16:51:04','',''),(4048,'1','285','1',1,'Retail Sale Id 4090',802.50,0.00,0.00,1.07,128.40,'2022-12-07 16:53:46','',''),(4049,'1','285','1',1,'Retail Sale Id 4091',1500.00,0.00,0.00,2.00,240.00,'2022-12-07 16:57:42','',''),(4050,'1','285','1',1,'Retail Sale Id 4092',22780.00,0.00,0.00,34.00,1360.00,'2022-12-07 16:59:06','',''),(4051,'1','285','1',1,'Retail Sale Id 4093',95810.00,0.00,0.00,143.00,5720.00,'2022-12-07 17:00:28','',''),(4052,'1','285','1',1,'Retail Sale Id 4094',4500.00,0.00,0.00,6.00,720.00,'2022-12-08 07:16:56','',''),(4053,'1','285','1',1,'Retail Sale Id 4095',49070.80,0.00,0.00,73.24,2929.60,'2022-12-08 07:20:45','',''),(4054,'1','285','1',1,'Retail Sale Id 4096',1500.00,0.00,0.00,2.00,240.00,'2022-12-08 07:24:47','',''),(4055,'1','285','1',1,'Retail Sale Id 4097',6000.00,0.00,0.00,8.00,960.00,'2022-12-08 07:26:12','',''),(4056,'1','285','1',1,'Retail Sale Id 4098',750.00,0.00,0.00,1.00,120.00,'2022-12-08 07:27:10','',''),(4057,'1','285','1',1,'Retail Sale Id 4099',2250.00,0.00,0.00,3.00,360.00,'2022-12-08 07:28:32','',''),(4058,'1','285','1',1,'Retail Sale Id 4100',1500.00,0.00,0.00,2.00,240.00,'2022-12-08 07:29:31','',''),(4059,'1','285','1',1,'Retail Sale Id 4101',1500.00,0.00,0.00,2.00,240.00,'2022-12-08 07:30:14','',''),(4060,'1','285','1',1,'Retail Sale Id 4102',13400.00,0.00,0.00,20.00,800.00,'2022-12-08 07:31:14','',''),(4061,'1','285','1',1,'Retail Sale Id 4103',3000.00,0.00,0.00,4.00,480.00,'2022-12-08 07:41:10','',''),(4062,'1','285','1',1,'Retail Sale Id 4104',6000.00,0.00,0.00,8.00,960.00,'2022-12-08 07:50:06','',''),(4063,'1','285','1',1,'Retail Sale Id 4105',3000.00,0.00,0.00,4.00,480.00,'2022-12-08 08:08:48','',''),(4064,'1','285','1',1,'Retail Sale Id 4106',5250.00,0.00,0.00,7.00,840.00,'2022-12-08 08:13:45','',''),(4065,'1','285','1',1,'Retail Sale Id 4107',2250.00,0.00,0.00,3.00,360.00,'2022-12-08 08:19:32','',''),(4066,'1','285','1',1,'Retail Sale Id 4108',2002.50,0.00,0.00,2.67,320.40,'2022-12-08 08:20:42','',''),(4067,'1','285','1',1,'Retail Sale Id 4109',3000.00,0.00,0.00,4.00,480.00,'2022-12-08 08:21:17','',''),(4068,'1','285','1',1,'Retail Sale Id 4110',3000.00,0.00,0.00,4.00,480.00,'2022-12-08 08:37:48','',''),(4069,'1','285','1',1,'Retail Sale Id 4111',1500.00,0.00,0.00,2.00,240.00,'2022-12-08 08:38:49','',''),(4070,'1','285','1',1,'Retail Sale Id 4112',2250.00,0.00,0.00,3.00,360.00,'2022-12-08 08:40:51','',''),(4071,'1','285','1',1,'Retail Sale Id 4113',3000.00,0.00,0.00,4.00,480.00,'2022-12-08 08:42:01','',''),(4072,'1','285','1',1,'Retail Sale Id 4114',7500.00,0.00,0.00,10.00,1200.00,'2022-12-08 08:48:33','',''),(4073,'1','285','1',1,'Retail Sale Id 4115',41312.20,0.00,0.00,61.66,2466.40,'2022-12-08 08:59:29','',''),(4074,'1','285','1',1,'Retail Sale Id 4116',1500.00,0.00,0.00,2.00,240.00,'2022-12-08 09:23:48','',''),(4075,'1','285','1',1,'Retail Sale Id 4117',1500.00,0.00,0.00,2.00,240.00,'2022-12-08 09:30:44','',''),(4076,'1','285','1',1,'Retail Sale Id 4118',7370.00,0.00,0.00,11.00,440.00,'2022-12-08 09:34:47','',''),(4077,'1','285','1',1,'Retail Sale Id 4119',2250.00,0.00,0.00,3.00,360.00,'2022-12-08 09:42:04','',''),(4078,'1','285','1',1,'Retail Sale Id 4120',3000.00,0.00,0.00,4.00,480.00,'2022-12-08 09:52:29','',''),(4079,'1','285','1',1,'Retail Sale Id 4121',1500.00,0.00,0.00,2.00,240.00,'2022-12-08 10:08:10','',''),(4080,'1','285','1',1,'Return of Retail Sale Id 4114',0.00,7500.00,10.00,0.00,-1200.00,'2022-12-08 10:09:07','',''),(4081,'1','285','1',1,'Retail Sale Id 4122',2250.00,0.00,0.00,3.00,360.00,'2022-12-08 10:26:18','',''),(4082,'1','285','1',1,'Retail Sale Id 4123',39530.00,0.00,0.00,59.00,2360.00,'2022-12-08 10:47:34','',''),(4083,'1','285','1',1,'Retail Sale Id 4124',1500.00,0.00,0.00,2.00,240.00,'2022-12-08 10:52:25','',''),(4084,'1','285','1',1,'Retail Sale Id 4125',1500.00,0.00,0.00,2.00,240.00,'2022-12-08 10:54:19','',''),(4085,'1','285','1',1,'Retail Sale Id 4126',900.00,0.00,0.00,1.20,144.00,'2022-12-08 10:55:05','',''),(4086,'1','285','1',1,'Retail Sale Id 4127',997.50,0.00,0.00,1.33,159.60,'2022-12-08 11:02:41','',''),(4087,'1','285','1',1,'Retail Sale Id 4128',30150.00,0.00,0.00,45.00,1800.00,'2022-12-08 11:06:39','',''),(4088,'1','285','1',1,'Retail Sale Id 4129',750.00,0.00,0.00,1.00,120.00,'2022-12-08 11:25:48','',''),(4089,'1','285','1',1,'Retail Sale Id 4130',1500.00,0.00,0.00,2.00,240.00,'2022-12-08 12:05:37','',''),(4090,'1','285','1',1,'Retail Sale Id 4131',201000.00,0.00,0.00,300.00,12000.00,'2022-12-08 12:21:02','',''),(4091,'1','285','1',1,'Retail Sale Id 4132',750.00,0.00,0.00,1.00,120.00,'2022-12-08 12:22:08','',''),(4092,'1','285','1',1,'Retail Sale Id 4133',2250.00,0.00,0.00,3.00,360.00,'2022-12-08 12:30:08','',''),(4093,'1','285','1',1,'Retail Sale Id 4134',2250.00,0.00,0.00,3.00,360.00,'2022-12-08 12:31:08','',''),(4094,'1','285','1',1,'Retail Sale Id 4135',1500.00,0.00,0.00,2.00,240.00,'2022-12-08 12:31:51','',''),(4095,'1','285','1',1,'Retail Sale Id 4136',40937.00,0.00,0.00,61.10,2444.00,'2022-12-08 12:53:00','',''),(4096,'1','285','1',1,'Retail Sale Id 4138',750.00,0.00,0.00,1.00,120.00,'2022-12-08 13:04:06','',''),(4097,'1','285','1',1,'Retail Sale Id 4139',1500.00,0.00,0.00,2.00,240.00,'2022-12-08 13:04:49','',''),(4098,'1','285','1',1,'Retail Sale Id 4140',750.00,0.00,0.00,1.00,120.00,'2022-12-08 13:11:02','',''),(4099,'1','285','1',1,'Retail Sale Id 4141',3000.00,0.00,0.00,4.00,480.00,'2022-12-08 13:16:46','',''),(4100,'1','285','1',1,'Retail Sale Id 4142',11845.60,0.00,0.00,17.68,707.20,'2022-12-08 13:18:49','',''),(4101,'1','285','1',1,'Retail Sale Id 4143',802.50,0.00,0.00,1.07,128.40,'2022-12-08 13:33:57','',''),(4102,'1','285','1',1,'Retail Sale Id 4144',41064.30,0.00,0.00,61.29,2451.60,'2022-12-08 13:56:17','',''),(4103,'1','285','1',1,'Retail Sale Id 4145',3750.00,0.00,0.00,5.00,600.00,'2022-12-08 13:59:33','',''),(4104,'1','285','1',1,'Retail Sale Id 4146',750.00,0.00,0.00,1.00,120.00,'2022-12-08 14:27:43','',''),(4105,'1','285','1',1,'Retail Sale Id 4148',750.00,0.00,0.00,1.00,120.00,'2022-12-08 14:31:33','',''),(4106,'1','285','1',1,'Retail Sale Id 4149',47074.20,0.00,0.00,70.26,2810.40,'2022-12-08 14:34:03','',''),(4107,'1','285','1',1,'Retail Sale Id 4150',2250.00,0.00,0.00,3.00,360.00,'2022-12-08 14:38:14','',''),(4108,'1','285','1',1,'Retail Sale Id 4152',2002.50,0.00,0.00,2.67,320.40,'2022-12-08 14:48:03','',''),(4109,'1','285','1',1,'Retail Sale Id 4153',997.50,0.00,0.00,1.33,159.60,'2022-12-08 14:49:07','',''),(4110,'1','285','1',1,'Retail Sale Id 4154',2250.00,0.00,0.00,3.00,360.00,'2022-12-08 14:50:00','',''),(4111,'1','285','1',1,'Retail Sale Id 4155',10009.80,0.00,0.00,14.94,597.60,'2022-12-08 15:00:54','',''),(4112,'1','285','1',1,'Retail Sale Id 4156',16301.10,0.00,0.00,24.33,973.20,'2022-12-08 15:14:04','',''),(4113,'1','285','1',1,'Retail Sale Id 4157',6000.00,0.00,0.00,8.00,960.00,'2022-12-08 15:18:52','',''),(4114,'1','285','1',1,'Retail Sale Id 4158',1500.00,0.00,0.00,2.00,240.00,'2022-12-08 15:20:14','',''),(4115,'1','285','1',1,'Return of Retail Sale Id 4157',0.00,6000.00,8.00,0.00,-960.00,'2022-12-08 15:28:02','',''),(4116,'1','285','1',1,'Retail Sale Id 4159',5655.00,0.00,0.00,7.54,904.80,'2022-12-08 15:31:01','',''),(4117,'1','285','1',1,'Retail Sale Id 4160',750.00,0.00,0.00,1.00,120.00,'2022-12-08 15:38:45','',''),(4118,'1','285','1',1,'Retail Sale Id 4161',40200.00,0.00,0.00,60.00,2400.00,'2022-12-08 15:48:33','',''),(4119,'1','285','1',1,'Retail Sale Id 4162',3750.00,0.00,0.00,5.00,600.00,'2022-12-08 15:51:08','',''),(4120,'1','285','1',1,'Retail Sale Id 4163',1500.00,0.00,0.00,2.00,240.00,'2022-12-08 15:52:32','',''),(4121,'1','285','1',1,'Retail Sale Id 4164',1500.00,0.00,0.00,2.00,240.00,'2022-12-08 15:53:24','',''),(4122,'1','285','1',1,'Retail Sale Id 4165',2250.00,0.00,0.00,3.00,360.00,'2022-12-08 15:57:17','',''),(4123,'1','285','1',1,'Retail Sale Id 4166',42364.10,0.00,0.00,63.23,2529.20,'2022-12-08 16:05:26','',''),(4124,'1','285','1',1,'Retail Sale Id 4167',23450.00,0.00,0.00,35.00,1400.00,'2022-12-08 16:14:04','',''),(4125,'1','285','1',1,'Retail Sale Id 4168',997.50,0.00,0.00,1.33,159.60,'2022-12-08 16:18:05','',''),(4126,'1','285','1',1,'Retail Sale Id 4169',33500.00,0.00,0.00,50.00,2000.00,'2022-12-08 16:25:36','',''),(4127,'1','285','1',1,'Retail Sale Id 4170',56950.00,0.00,0.00,85.00,3400.00,'2022-12-08 16:26:43','',''),(4128,'1','285','1',1,'Retail Sale Id 4171',2250.00,0.00,0.00,3.00,360.00,'2022-12-08 16:28:36','',''),(4129,'1','285','1',1,'Retail Sale Id 4172',997.50,0.00,0.00,1.33,159.60,'2022-12-08 16:42:17','',''),(4130,'1','285','1',1,'Retail Sale Id 4173',802.50,0.00,0.00,1.07,128.40,'2022-12-08 16:43:17','',''),(4131,'1','285','1',1,'Retail Sale Id 4174',26800.00,0.00,0.00,40.00,1600.00,'2022-12-08 16:54:38','',''),(4132,'1','285','1',1,'Retail Sale Id 4175',750.00,0.00,0.00,1.00,120.00,'2022-12-08 17:00:11','',''),(4133,'1','285','1',1,'Retail Sale Id 4176',2250.00,0.00,0.00,3.00,360.00,'2022-12-08 17:06:41','',''),(4134,'1','285','1',1,'Retail Sale Id 4177',802.50,0.00,0.00,1.07,128.40,'2022-12-08 17:12:57','',''),(4135,'1','285','1',1,'Retail Sale Id 4178',1500.00,0.00,0.00,2.00,240.00,'2022-12-08 17:14:38','',''),(4136,'1','285','1',1,'Retail Sale Id 4180',591697.05,0.00,0.00,889.77,31141.95,'2022-12-08 17:59:08','',''),(4137,'1','285','1',1,'Return of Retail Sale Id 4149',0.00,47074.20,70.26,0.00,-2810.40,'2022-12-08 18:49:42','',''),(4138,'1','285','1',1,'Return of Retail Sale Id 4174',0.00,26800.00,40.00,0.00,-1600.00,'2022-12-08 18:50:48','',''),(4139,'1','285','1',1,'Retail Sale Id 4181',9560.90,0.00,0.00,14.27,570.80,'2022-12-08 18:53:26','',''),(4140,'1','285','1',1,'Return of Retail Sale Id 4180',0.00,591697.05,889.77,0.00,-31141.95,'2022-12-08 18:56:33','',''),(4141,'1','285','1',1,'Retail Sale Id 4182',527857.05,0.00,0.00,793.77,27781.95,'2022-12-08 19:02:53','',''),(4142,'1','285','1',1,'Retail Sale Id 4183',64320.00,0.00,0.00,96.00,3840.00,'2022-12-08 19:05:28','',''),(4143,'1','285','1',1,'Retail Sale Id 4184',2250.00,0.00,0.00,3.00,360.00,'2022-12-09 07:02:36','',''),(4144,'1','285','1',1,'Retail Sale Id 4185',2197.50,0.00,0.00,2.93,351.60,'2022-12-09 07:06:18','',''),(4145,'1','285','1',1,'Retail Sale Id 4186',3000.00,0.00,0.00,4.00,480.00,'2022-12-09 07:07:32','',''),(4146,'1','285','1',1,'Retail Sale Id 4187',2250.00,0.00,0.00,3.00,360.00,'2022-12-09 07:22:48','',''),(4147,'1','285','1',1,'Retail Sale Id 4188',17420.00,0.00,0.00,26.00,1040.00,'2022-12-09 07:26:29','',''),(4148,'1','285','1',1,'Retail Sale Id 4189',2250.00,0.00,0.00,3.00,360.00,'2022-12-09 07:35:00','',''),(4149,'1','285','1',1,'Retail Sale Id 4190',10103.60,0.00,0.00,15.08,603.20,'2022-12-09 07:37:32','',''),(4150,'1','285','1',1,'Retail Sale Id 4191',1500.00,0.00,0.00,2.00,240.00,'2022-12-09 07:39:13','',''),(4151,'1','285','1',1,'Retail Sale Id 4192',5002.50,0.00,0.00,6.67,800.40,'2022-12-09 07:40:33','',''),(4152,'1','285','1',1,'Retail Sale Id 4193',3000.00,0.00,0.00,4.00,480.00,'2022-12-09 07:43:30','',''),(4153,'1','285','1',1,'Retail Sale Id 4194',22659.40,0.00,0.00,33.82,1352.80,'2022-12-09 07:44:45','',''),(4154,'1','285','1',1,'Retail Sale Id 4195',1500.00,0.00,0.00,2.00,240.00,'2022-12-09 07:47:40','',''),(4155,'1','285','1',1,'Retail Sale Id 4196',33500.00,0.00,0.00,50.00,2000.00,'2022-12-09 07:49:34','',''),(4156,'1','285','1',1,'Retail Sale Id 4197',40200.00,0.00,0.00,60.00,2400.00,'2022-12-09 07:53:10','',''),(4157,'1','285','1',1,'Retail Sale Id 4198',16495.40,0.00,0.00,24.62,984.80,'2022-12-09 08:01:21','',''),(4158,'1','285','1',1,'Retail Sale Id 4199',23450.00,0.00,0.00,35.00,1400.00,'2022-12-09 08:05:03','',''),(4159,'1','285','1',1,'Retail Sale Id 4200',3750.00,0.00,0.00,5.00,600.00,'2022-12-09 08:11:16','',''),(4160,'1','285','1',1,'Retail Sale Id 4201',750.00,0.00,0.00,1.00,120.00,'2022-12-09 08:13:09','',''),(4161,'1','285','1',1,'Retail Sale Id 4202',3350.00,0.00,0.00,5.00,200.00,'2022-12-09 08:14:37','',''),(4162,'1','285','1',1,'Retail Sale Id 4203',10157.20,0.00,0.00,15.16,606.40,'2022-12-09 08:26:51','',''),(4163,'1','285','1',1,'Retail Sale Id 4204',39597.00,0.00,0.00,59.10,2364.00,'2022-12-09 08:29:26','',''),(4164,'1','285','1',1,'Retail Sale Id 4205',3750.00,0.00,0.00,5.00,600.00,'2022-12-09 08:30:22','',''),(4165,'1','285','1',1,'Retail Sale Id 4206',41426.10,0.00,0.00,61.83,2473.20,'2022-12-09 08:34:03','',''),(4166,'1','285','1',1,'Retail Sale Id 4207',82222.40,0.00,0.00,122.72,4908.80,'2022-12-09 08:40:07','',''),(4167,'1','285','1',1,'Retail Sale Id 4208',4500.00,0.00,0.00,6.00,720.00,'2022-12-09 08:42:17','',''),(4168,'1','285','1',1,'Retail Sale Id 4209',4500.00,0.00,0.00,6.00,720.00,'2022-12-09 08:59:09','',''),(4169,'1','285','1',1,'Retail Sale Id 4210',3997.50,0.00,0.00,5.33,639.60,'2022-12-09 09:03:51','',''),(4170,'1','285','1',1,'Retail Sale Id 4211',2250.00,0.00,0.00,3.00,360.00,'2022-12-09 09:05:27','',''),(4171,'1','285','1',1,'Retail Sale Id 4212',3750.00,0.00,0.00,5.00,600.00,'2022-12-09 09:11:29','',''),(4172,'1','285','1',1,'Retail Sale Id 4213',1500.00,0.00,0.00,2.00,240.00,'2022-12-09 09:12:22','',''),(4173,'1','285','1',1,'Retail Sale Id 4214',3000.00,0.00,0.00,4.00,480.00,'2022-12-09 09:17:26','',''),(4174,'1','285','1',1,'Retail Sale Id 4215',802.50,0.00,0.00,1.07,128.40,'2022-12-09 09:18:52','',''),(4175,'1','285','1',1,'Retail Sale Id 4216',2002.50,0.00,0.00,2.67,320.40,'2022-12-09 09:21:49','',''),(4176,'1','285','1',1,'Retail Sale Id 4217',1500.00,0.00,0.00,2.00,240.00,'2022-12-09 09:32:09','',''),(4177,'1','285','1',1,'Retail Sale Id 4218',6000.00,0.00,0.00,8.00,960.00,'2022-12-09 09:35:09','',''),(4178,'1','285','1',1,'Retail Sale Id 4219',6000.00,0.00,0.00,8.00,960.00,'2022-12-09 09:37:48','',''),(4179,'1','285','1',1,'Retail Sale Id 4220',2250.00,0.00,0.00,3.00,360.00,'2022-12-09 09:40:53','',''),(4180,'1','285','1',1,'Retail Sale Id 4221',3000.00,0.00,0.00,4.00,480.00,'2022-12-09 09:41:31','',''),(4181,'1','285','1',1,'Retail Sale Id 4222',1500.00,0.00,0.00,2.00,240.00,'2022-12-09 09:44:01','',''),(4182,'1','285','1',1,'Retail Sale Id 4223',5535.00,0.00,0.00,7.38,885.60,'2022-12-09 09:45:25','',''),(4183,'1','285','1',1,'Return of Retail Sale Id 4218',0.00,6000.00,8.00,0.00,-960.00,'2022-12-09 09:46:32','',''),(4184,'1','285','1',1,'Retail Sale Id 4225',76109.25,0.00,0.00,114.45,4005.75,'2022-12-09 09:50:21','',''),(4185,'1','285','1',1,'Retail Sale Id 4226',44300.40,0.00,0.00,66.12,2644.80,'2022-12-09 09:54:01','',''),(4186,'1','285','1',1,'Retail Sale Id 4227',750.00,0.00,0.00,1.00,120.00,'2022-12-09 09:56:41','',''),(4187,'1','285','1',1,'Retail Sale Id 4228',802.50,0.00,0.00,1.07,128.40,'2022-12-09 09:58:23','',''),(4188,'1','285','1',1,'Retail Sale Id 4229',33158.30,0.00,0.00,49.49,1979.60,'2022-12-09 10:03:15','',''),(4189,'1','285','1',1,'Retail Sale Id 4230',2250.00,0.00,0.00,3.00,360.00,'2022-12-09 10:17:01','',''),(4190,'1','285','1',1,'Retail Sale Id 4231',3000.00,0.00,0.00,4.00,480.00,'2022-12-09 10:33:43','',''),(4191,'1','285','1',1,'Retail Sale Id 4232',12106.90,0.00,0.00,18.07,722.80,'2022-12-09 10:35:54','',''),(4192,'1','285','1',1,'Retail Sale Id 4233',41741.00,0.00,0.00,62.30,2492.00,'2022-12-09 10:40:39','',''),(4193,'1','285','1',1,'Retail Sale Id 4234',65800.70,0.00,0.00,98.21,3928.40,'2022-12-09 10:45:02','',''),(4194,'1','285','1',1,'Retail Sale Id 4235',997.50,0.00,0.00,1.33,159.60,'2022-12-09 10:58:27','',''),(4195,'1','285','1',1,'Retail Sale Id 4236',1500.00,0.00,0.00,2.00,240.00,'2022-12-09 11:08:41','',''),(4196,'1','285','1',1,'Retail Sale Id 4237',3750.00,0.00,0.00,5.00,600.00,'2022-12-09 11:17:18','',''),(4197,'1','285','1',1,'Retail Sale Id 4238',67000.00,0.00,0.00,100.00,4000.00,'2022-12-09 11:19:29','',''),(4198,'1','285','1',1,'Retail Sale Id 4239',3000.00,0.00,0.00,4.00,480.00,'2022-12-09 11:21:30','',''),(4199,'1','285','1',1,'Retail Sale Id 4240',2680.00,0.00,0.00,4.00,160.00,'2022-12-09 11:25:08','',''),(4200,'1','285','1',1,'Retail Sale Id 4241',2250.00,0.00,0.00,3.00,360.00,'2022-12-09 11:26:08','',''),(4201,'1','285','1',1,'Retail Sale Id 4242',750.00,0.00,0.00,1.00,120.00,'2022-12-09 11:27:48','',''),(4202,'1','285','1',1,'Retail Sale Id 4243',2250.00,0.00,0.00,3.00,360.00,'2022-12-09 11:29:13','',''),(4203,'1','285','1',1,'Retail Sale Id 4244',2250.00,0.00,0.00,3.00,360.00,'2022-12-09 11:31:27','',''),(4204,'1','285','1',1,'Retail Sale Id 4245',2250.00,0.00,0.00,3.00,360.00,'2022-12-09 11:32:26','',''),(4205,'1','285','1',1,'Retail Sale Id 4246',997.50,0.00,0.00,1.33,159.60,'2022-12-09 11:40:55','',''),(4206,'1','285','1',1,'Retail Sale Id 4247',9895.90,0.00,0.00,14.77,590.80,'2022-12-09 11:49:45','',''),(4207,'1','285','1',1,'Retail Sale Id 4248',750.00,0.00,0.00,1.00,120.00,'2022-12-09 12:39:09','',''),(4208,'1','285','1',1,'Retail Sale Id 4249',750.00,0.00,0.00,1.00,120.00,'2022-12-09 12:46:14','',''),(4209,'1','285','1',1,'Retail Sale Id 4250',1500.00,0.00,0.00,2.00,240.00,'2022-12-09 13:11:48','',''),(4210,'1','285','1',1,'Retail Sale Id 4251',2250.00,0.00,0.00,3.00,360.00,'2022-12-09 13:12:47','',''),(4211,'1','285','1',1,'Retail Sale Id 4252',3750.00,0.00,0.00,5.00,600.00,'2022-12-09 13:47:58','',''),(4212,'1','285','1',1,'Retail Sale Id 4253',802.50,0.00,0.00,1.07,128.40,'2022-12-09 15:16:11','',''),(4213,'1','285','1',1,'Retail Sale Id 4254',750.00,0.00,0.00,1.00,120.00,'2022-12-09 15:42:00','',''),(4214,'1','285','1',1,'Retail Sale Id 4255',20100.00,0.00,0.00,30.00,1200.00,'2022-12-09 16:05:13','',''),(4215,'1','285','1',1,'Retail Sale Id 4256',1500.00,0.00,0.00,2.00,240.00,'2022-12-09 16:09:43','',''),(4216,'1','285','1',1,'Retail Sale Id 4257',2250.00,0.00,0.00,3.00,360.00,'2022-12-09 16:12:05','',''),(4217,'1','285','1',1,'Retail Sale Id 4258',3000.00,0.00,0.00,4.00,480.00,'2022-12-09 16:13:45','',''),(4218,'1','285','1',1,'Retail Sale Id 4259',750.00,0.00,0.00,1.00,120.00,'2022-12-09 16:14:50','',''),(4219,'1','285','1',1,'Retail Sale Id 4260',29480.00,0.00,0.00,44.00,1760.00,'2022-12-09 16:16:09','',''),(4220,'1','285','1',1,'Retail Sale Id 4261',1500.00,0.00,0.00,2.00,240.00,'2022-12-09 16:26:08','',''),(4221,'1','285','1',1,'Retail Sale Id 4262',2002.50,0.00,0.00,2.67,320.40,'2022-12-09 16:27:31','',''),(4222,'1','285','1',1,'Retail Sale Id 4263',2250.00,0.00,0.00,3.00,360.00,'2022-12-09 16:37:21','',''),(4223,'1','285','1',1,'Retail Sale Id 4264',64387.00,0.00,0.00,96.10,3844.00,'2022-12-09 16:42:58','',''),(4224,'1','285','1',1,'Retail Sale Id 4265',7500.00,0.00,0.00,10.00,1200.00,'2022-12-09 16:45:00','',''),(4225,'1','285','1',1,'Return of Retail Sale Id 4244',0.00,2250.00,3.00,0.00,-360.00,'2022-12-09 16:54:25','',''),(4226,'1','285','1',1,'Return of Retail Sale Id 4200',0.00,3750.00,5.00,0.00,-600.00,'2022-12-09 16:54:58','',''),(4227,'1','285','1',1,'Return of Retail Sale Id 4231',0.00,3000.00,4.00,0.00,-480.00,'2022-12-09 16:57:08','',''),(4228,'1','285','1',1,'Retail Sale Id 4266',6000.00,0.00,0.00,8.00,960.00,'2022-12-09 17:07:52','',''),(4229,'1','285','1',1,'Retail Sale Id 4267',2250.00,0.00,0.00,3.00,360.00,'2022-12-09 17:08:18','',''),(4230,'1','285','1',1,'Retail Sale Id 4268',7500.00,0.00,0.00,10.00,1200.00,'2022-12-09 17:09:17','',''),(4231,'1','285','1',1,'Return of Retail Sale Id 4248',0.00,750.00,1.00,0.00,-120.00,'2022-12-09 17:09:59','',''),(4232,'1','285','1',1,'Return of Retail Sale Id 4255',0.00,20100.00,30.00,0.00,-1200.00,'2022-12-09 19:16:06','',''),(4233,'1','285','1',1,'Retail Sale Id 4269',18331.20,0.00,0.00,27.36,1094.40,'2022-12-09 19:17:35','',''),(4234,'1','285','1',1,'Retail Sale Id 4271',390.00,0.00,0.00,0.52,62.40,'2022-12-09 19:19:43','',''),(4235,'1','285','1',1,'Retail Sale Id 4272',6997.50,0.00,0.00,9.33,1119.60,'2022-12-10 07:00:27','',''),(4236,'1','285','1',1,'Retail Sale Id 4273',750.00,0.00,0.00,1.00,120.00,'2022-12-10 07:10:52','',''),(4237,'1','285','1',1,'Retail Sale Id 4274',3750.00,0.00,0.00,5.00,600.00,'2022-12-10 07:23:52','',''),(4238,'1','285','1',1,'Retail Sale Id 4275',31490.00,0.00,0.00,47.00,1880.00,'2022-12-10 07:31:18','',''),(4239,'1','285','1',1,'Retail Sale Id 4276',2250.00,0.00,0.00,3.00,360.00,'2022-12-10 07:32:06','',''),(4240,'1','285','1',1,'Retail Sale Id 4277',750.00,0.00,0.00,1.00,120.00,'2022-12-10 07:37:28','',''),(4241,'1','285','1',1,'Retail Sale Id 4278',750.00,0.00,0.00,1.00,120.00,'2022-12-10 07:45:43','',''),(4242,'1','285','1',1,'Retail Sale Id 4279',16649.50,0.00,0.00,24.85,994.00,'2022-12-10 07:47:43','',''),(4243,'1','285','1',1,'Retail Sale Id 4280',13400.00,0.00,0.00,20.00,800.00,'2022-12-10 07:56:52','',''),(4244,'1','285','1',1,'Retail Sale Id 4281',26800.00,0.00,0.00,40.00,1600.00,'2022-12-10 08:10:14','',''),(4245,'1','285','1',1,'Retail Sale Id 4282',2002.50,0.00,0.00,2.67,320.40,'2022-12-10 08:12:54','',''),(4246,'1','285','1',1,'Retail Sale Id 4283',1500.00,0.00,0.00,2.00,240.00,'2022-12-10 08:13:53','',''),(4247,'1','285','1',1,'Retail Sale Id 4284',2002.50,0.00,0.00,2.67,320.40,'2022-12-10 08:15:11','',''),(4248,'1','285','1',1,'Retail Sale Id 4285',1500.00,0.00,0.00,2.00,240.00,'2022-12-10 08:16:03','',''),(4249,'1','285','1',1,'Retail Sale Id 4286',750.00,0.00,0.00,1.00,120.00,'2022-12-10 08:17:51','',''),(4250,'1','285','1',1,'Retail Sale Id 4287',1500.00,0.00,0.00,2.00,240.00,'2022-12-10 08:18:39','',''),(4251,'1','285','1',1,'Retail Sale Id 4288',750.00,0.00,0.00,1.00,120.00,'2022-12-10 08:20:21','',''),(4252,'1','285','1',1,'Retail Sale Id 4289',1500.00,0.00,0.00,2.00,240.00,'2022-12-10 08:23:35','',''),(4253,'1','285','1',1,'Retail Sale Id 4290',2250.00,0.00,0.00,3.00,360.00,'2022-12-10 08:28:48','',''),(4254,'1','285','1',1,'Retail Sale Id 4291',2250.00,0.00,0.00,3.00,360.00,'2022-12-10 08:35:22','',''),(4255,'1','285','1',1,'Retail Sale Id 4292',1500.00,0.00,0.00,2.00,240.00,'2022-12-10 08:36:28','',''),(4256,'1','285','1',1,'Retail Sale Id 4293',2250.00,0.00,0.00,3.00,360.00,'2022-12-10 08:41:26','',''),(4257,'1','285','1',1,'Retail Sale Id 4294',750.00,0.00,0.00,1.00,120.00,'2022-12-10 08:50:35','',''),(4258,'1','285','1',1,'Retail Sale Id 4296',750.00,0.00,0.00,1.00,120.00,'2022-12-10 08:53:57','',''),(4259,'1','285','1',1,'Retail Sale Id 4297',2250.00,0.00,0.00,3.00,360.00,'2022-12-10 09:01:31','',''),(4260,'1','285','1',1,'Retail Sale Id 4298',2250.00,0.00,0.00,3.00,360.00,'2022-12-10 09:04:29','',''),(4261,'1','285','1',1,'Retail Sale Id 4299',2302.50,0.00,0.00,3.07,368.40,'2022-12-10 09:05:34','',''),(4262,'1','285','1',1,'Retail Sale Id 4302',750.00,0.00,0.00,1.00,120.00,'2022-12-10 09:08:10','',''),(4263,'1','285','1',1,'Retail Sale Id 4303',802.50,0.00,0.00,1.07,128.40,'2022-12-10 09:14:15','',''),(4264,'1','285','1',1,'Retail Sale Id 4304',802.50,0.00,0.00,1.07,128.40,'2022-12-10 09:15:13','',''),(4265,'1','285','1',1,'Retail Sale Id 4305',750.00,0.00,0.00,1.00,120.00,'2022-12-10 09:16:17','',''),(4266,'1','285','1',1,'Retail Sale Id 4306',1500.00,0.00,0.00,2.00,240.00,'2022-12-10 09:36:01','',''),(4267,'1','285','1',1,'Retail Sale Id 4307',2002.50,0.00,0.00,2.67,320.40,'2022-12-10 09:37:02','',''),(4268,'1','285','1',1,'Retail Sale Id 4308',802.50,0.00,0.00,1.07,128.40,'2022-12-10 09:38:44','',''),(4269,'1','285','1',1,'Retail Sale Id 4309',750.00,0.00,0.00,1.00,120.00,'2022-12-10 09:47:55','',''),(4270,'1','285','1',1,'Retail Sale Id 4310',5752.50,0.00,0.00,7.67,920.40,'2022-12-10 09:52:30','',''),(4271,'1','285','1',1,'Retail Sale Id 4311',750.00,0.00,0.00,1.00,120.00,'2022-12-10 09:54:33','',''),(4272,'1','285','1',1,'Retail Sale Id 4312',11778.60,0.00,0.00,17.58,703.20,'2022-12-10 10:03:02','',''),(4273,'1','285','1',1,'Retail Sale Id 4313',30150.00,0.00,0.00,45.00,1800.00,'2022-12-10 10:05:38','',''),(4274,'1','285','1',1,'Retail Sale Id 4314',3997.50,0.00,0.00,5.33,639.60,'2022-12-10 10:06:51','',''),(4275,'1','285','1',1,'Retail Sale Id 4315',750.00,0.00,0.00,1.00,120.00,'2022-12-10 10:11:08','',''),(4276,'1','285','1',1,'Retail Sale Id 4316',41540.00,0.00,0.00,62.00,2480.00,'2022-12-10 10:17:09','',''),(4277,'1','285','1',1,'Retail Sale Id 4317',3000.00,0.00,0.00,4.00,480.00,'2022-12-10 10:22:16','',''),(4278,'1','285','1',1,'Retail Sale Id 4318',2250.00,0.00,0.00,3.00,360.00,'2022-12-10 10:24:46','',''),(4279,'1','285','1',1,'Retail Sale Id 4319',1500.00,0.00,0.00,2.00,240.00,'2022-12-10 10:25:39','',''),(4280,'1','285','1',1,'Retail Sale Id 4320',3000.00,0.00,0.00,4.00,480.00,'2022-12-10 10:26:28','',''),(4281,'1','285','1',1,'Retail Sale Id 4321',1500.00,0.00,0.00,2.00,240.00,'2022-12-10 10:27:25','',''),(4282,'1','285','1',1,'Retail Sale Id 4322',6000.00,0.00,0.00,8.00,960.00,'2022-12-10 10:30:32','',''),(4283,'1','285','1',1,'Retail Sale Id 4323',2250.00,0.00,0.00,3.00,360.00,'2022-12-10 10:33:33','',''),(4284,'1','285','1',1,'Retail Sale Id 4324',2250.00,0.00,0.00,3.00,360.00,'2022-12-10 10:35:20','',''),(4285,'1','285','1',1,'Retail Sale Id 4325',1500.00,0.00,0.00,2.00,240.00,'2022-12-10 10:36:10','',''),(4286,'1','285','1',1,'Retail Sale Id 4326',9788.70,0.00,0.00,14.61,584.40,'2022-12-10 10:39:52','',''),(4287,'1','285','1',1,'Retail Sale Id 4327',3000.00,0.00,0.00,4.00,480.00,'2022-12-10 10:46:35','',''),(4288,'1','285','1',1,'Retail Sale Id 4328',750.00,0.00,0.00,1.00,120.00,'2022-12-10 10:47:42','',''),(4289,'1','285','1',1,'Retail Sale Id 4329',40642.20,0.00,0.00,60.66,2426.40,'2022-12-10 11:02:00','',''),(4290,'1','285','1',1,'Retail Sale Id 4330',9375.00,0.00,0.00,12.50,1500.00,'2022-12-10 11:06:10','',''),(4291,'1','285','1',1,'Retail Sale Id 4331',41339.00,0.00,0.00,61.70,2468.00,'2022-12-10 11:13:12','',''),(4292,'1','285','1',1,'Retail Sale Id 4332',26800.00,0.00,0.00,40.00,1600.00,'2022-12-10 11:27:10','',''),(4293,'1','285','1',1,'Retail Sale Id 4333',3997.50,0.00,0.00,5.33,639.60,'2022-12-10 11:29:29','',''),(4294,'1','285','1',1,'Retail Sale Id 4334',3000.00,0.00,0.00,4.00,480.00,'2022-12-10 11:36:11','',''),(4295,'1','285','1',1,'Retail Sale Id 4335',1500.00,0.00,0.00,2.00,240.00,'2022-12-10 11:37:45','',''),(4296,'1','285','1',1,'Retail Sale Id 4336',3997.50,0.00,0.00,5.33,639.60,'2022-12-10 11:50:24','',''),(4297,'1','285','1',1,'Retail Sale Id 4337',4500.00,0.00,0.00,6.00,720.00,'2022-12-10 12:01:47','',''),(4298,'1','285','1',1,'Retail Sale Id 4338',3000.00,0.00,0.00,4.00,480.00,'2022-12-10 12:09:53','',''),(4299,'1','285','1',1,'Retail Sale Id 4339',1500.00,0.00,0.00,2.00,240.00,'2022-12-10 12:15:15','',''),(4300,'1','285','1',1,'Retail Sale Id 4340',997.50,0.00,0.00,1.33,159.60,'2022-12-10 12:18:14','',''),(4301,'1','285','1',1,'Retail Sale Id 4341',2250.00,0.00,0.00,3.00,360.00,'2022-12-10 12:23:03','',''),(4302,'1','285','1',1,'Retail Sale Id 4342',1500.00,0.00,0.00,2.00,240.00,'2022-12-10 12:33:32','',''),(4303,'1','285','1',1,'Retail Sale Id 4343',3750.00,0.00,0.00,5.00,600.00,'2022-12-10 12:38:23','',''),(4304,'1','285','1',1,'Retail Sale Id 4344',1500.00,0.00,0.00,2.00,240.00,'2022-12-10 12:40:49','',''),(4305,'1','285','1',1,'Retail Sale Id 4345',2250.00,0.00,0.00,3.00,360.00,'2022-12-10 12:48:06','',''),(4306,'1','285','1',1,'Retail Sale Id 4346',3000.00,0.00,0.00,4.00,480.00,'2022-12-10 12:53:20','',''),(4307,'1','285','1',1,'Retail Sale Id 4347',7500.00,0.00,0.00,10.00,1200.00,'2022-12-10 12:54:39','',''),(4308,'1','285','1',1,'Retail Sale Id 4348',750.00,0.00,0.00,1.00,120.00,'2022-12-10 13:00:48','',''),(4309,'1','285','1',1,'Retail Sale Id 4349',40642.20,0.00,0.00,60.66,2426.40,'2022-12-10 13:04:23','',''),(4310,'1','285','1',1,'Retail Sale Id 4350',9375.00,0.00,0.00,12.50,1500.00,'2022-12-10 13:06:30','',''),(4311,'1','285','1',1,'Retail Sale Id 4351',40394.30,0.00,0.00,60.29,2411.60,'2022-12-10 13:08:41','',''),(4312,'1','285','1',1,'Retail Sale Id 4352',2250.00,0.00,0.00,3.00,360.00,'2022-12-10 13:11:00','',''),(4313,'1','285','1',1,'Return of Retail Sale Id 4351',0.00,40394.30,60.29,0.00,-2411.60,'2022-12-10 13:12:43','',''),(4314,'1','285','1',1,'Retail Sale Id 4353',41064.30,0.00,0.00,61.29,2451.60,'2022-12-10 13:14:03','',''),(4315,'1','285','1',1,'Retail Sale Id 4354',2002.50,0.00,0.00,2.67,320.40,'2022-12-10 13:32:35','',''),(4316,'1','285','1',1,'Retail Sale Id 4355',997.50,0.00,0.00,1.33,159.60,'2022-12-10 13:40:42','',''),(4317,'1','285','1',1,'Retail Sale Id 4356',997.50,0.00,0.00,1.33,159.60,'2022-12-10 13:45:40','',''),(4318,'1','285','1',1,'Return of Retail Sale Id 4350',0.00,9375.00,12.50,0.00,-1500.00,'2022-12-10 14:20:48','',''),(4319,'1','285','1',1,'Return of Retail Sale Id 4322',0.00,6000.00,8.00,0.00,-960.00,'2022-12-10 14:33:18','',''),(4320,'1','285','1',1,'Retail Sale Id 4357',50551.50,0.00,0.00,75.45,3018.00,'2022-12-10 14:43:02','',''),(4321,'1','285','1',1,'Retail Sale Id 4358',12060.00,0.00,0.00,18.00,720.00,'2022-12-10 14:53:27','',''),(4322,'1','285','1',1,'Retail Sale Id 4359',1500.00,0.00,0.00,2.00,240.00,'2022-12-10 14:55:24','',''),(4323,'1','285','1',1,'Retail Sale Id 4360',2250.00,0.00,0.00,3.00,360.00,'2022-12-10 14:59:29','',''),(4324,'1','285','1',1,'Retail Sale Id 4362',33500.00,0.00,0.00,50.00,2000.00,'2022-12-10 15:00:35','',''),(4325,'1','285','1',1,'Retail Sale Id 4363',750.00,0.00,0.00,1.00,120.00,'2022-12-10 15:07:15','',''),(4326,'1','285','1',1,'Retail Sale Id 4364',2250.00,0.00,0.00,3.00,360.00,'2022-12-10 15:14:59','',''),(4327,'1','285','1',1,'Retail Sale Id 4365',750.00,0.00,0.00,1.00,120.00,'2022-12-10 15:17:20','',''),(4328,'1','285','1',1,'Retail Sale Id 4366',1500.00,0.00,0.00,2.00,240.00,'2022-12-10 15:18:07','',''),(4329,'1','285','1',1,'Retail Sale Id 4367',997.50,0.00,0.00,1.33,159.60,'2022-12-10 15:18:47','',''),(4330,'1','285','1',1,'Retail Sale Id 4368',2250.00,0.00,0.00,3.00,360.00,'2022-12-10 15:29:00','',''),(4331,'1','285','1',1,'Retail Sale Id 4369',1500.00,0.00,0.00,2.00,240.00,'2022-12-10 15:36:47','',''),(4332,'1','285','1',1,'Retail Sale Id 4370',40695.80,0.00,0.00,60.74,2429.60,'2022-12-10 15:38:03','',''),(4333,'1','285','1',1,'Retail Sale Id 4371',2250.00,0.00,0.00,3.00,360.00,'2022-12-10 15:39:51','',''),(4334,'1','285','1',1,'Retail Sale Id 4372',750.00,0.00,0.00,1.00,120.00,'2022-12-10 15:42:21','',''),(4335,'1','285','1',1,'Retail Sale Id 4373',997.50,0.00,0.00,1.33,159.60,'2022-12-10 15:43:23','',''),(4336,'1','285','1',1,'Retail Sale Id 4376',750.00,0.00,0.00,1.00,120.00,'2022-12-10 15:44:17','',''),(4337,'1','285','1',1,'Retail Sale Id 4377',2250.00,0.00,0.00,3.00,360.00,'2022-12-10 15:45:05','',''),(4338,'1','285','1',1,'Retail Sale Id 4378',1500.00,0.00,0.00,2.00,240.00,'2022-12-10 15:45:53','',''),(4339,'1','285','1',1,'Retail Sale Id 4379',2250.00,0.00,0.00,3.00,360.00,'2022-12-10 15:47:07','',''),(4340,'1','285','1',1,'Retail Sale Id 4380',8040.00,0.00,0.00,12.00,480.00,'2022-12-10 15:50:01','',''),(4341,'1','285','1',1,'Retail Sale Id 4381',1500.00,0.00,0.00,2.00,240.00,'2022-12-10 15:58:59','',''),(4342,'1','285','1',1,'Retail Sale Id 4382',3000.00,0.00,0.00,4.00,480.00,'2022-12-10 16:04:22','',''),(4343,'1','285','1',1,'Retail Sale Id 4383',3000.00,0.00,0.00,4.00,480.00,'2022-12-10 16:05:14','',''),(4344,'1','285','1',1,'Retail Sale Id 4384',70457.20,0.00,0.00,105.16,4206.40,'2022-12-10 16:26:49','',''),(4345,'1','285','1',1,'Retail Sale Id 4385',3000.00,0.00,0.00,4.00,480.00,'2022-12-10 16:28:00','',''),(4346,'1','285','1',1,'Retail Sale Id 4386',5002.50,0.00,0.00,6.67,800.40,'2022-12-10 16:29:00','',''),(4347,'1','285','1',1,'Retail Sale Id 4387',4500.00,0.00,0.00,6.00,720.00,'2022-12-10 16:30:06','',''),(4348,'1','285','1',1,'Retail Sale Id 4388',3000.00,0.00,0.00,4.00,480.00,'2022-12-10 16:32:33','',''),(4349,'1','285','1',1,'Retail Sale Id 4389',1500.00,0.00,0.00,2.00,240.00,'2022-12-10 16:33:21','',''),(4350,'1','285','1',1,'Retail Sale Id 4391',9375.00,0.00,0.00,12.50,1500.00,'2022-12-10 16:34:07','',''),(4351,'1','285','1',1,'Retail Sale Id 4392',2002.50,0.00,0.00,2.67,320.40,'2022-12-10 16:36:32','',''),(4352,'1','285','1',1,'Retail Sale Id 4393',41540.00,0.00,0.00,62.00,2480.00,'2022-12-10 16:37:37','',''),(4353,'1','285','1',1,'Retail Sale Id 4394',1500.00,0.00,0.00,2.00,240.00,'2022-12-10 16:39:12','',''),(4354,'1','285','1',1,'Retail Sale Id 4396',2197.50,0.00,0.00,2.93,351.60,'2022-12-10 16:40:55','',''),(4355,'1','285','1',1,'Retail Sale Id 4397',40648.90,0.00,0.00,60.67,2426.80,'2022-12-10 16:47:21','',''),(4356,'1','285','1',1,'Retail Sale Id 4398',6030.00,0.00,0.00,9.00,360.00,'2022-12-10 16:51:27','',''),(4357,'1','285','1',1,'Retail Sale Id 4399',2925.00,0.00,0.00,3.90,468.00,'2022-12-10 16:54:33','',''),(4358,'1','285','1',1,'Return of Retail Sale Id 4398',0.00,6030.00,9.00,0.00,-360.00,'2022-12-10 17:00:12','',''),(4359,'1','285','1',1,'Retail Sale Id 4400',3175.80,0.00,0.00,4.74,189.60,'2022-12-10 17:01:11','',''),(4360,'1','285','1',1,'Retail Sale Id 4401',157.50,0.00,0.00,0.21,25.20,'2022-12-10 17:51:40','',''),(4361,'1','285','1',1,'Return of Retail Sale Id 4401',0.00,157.50,0.21,0.00,-25.20,'2022-12-10 17:52:55','',''),(4362,'1','285','1',1,'Retail Sale Id 4402',67.50,0.00,0.00,0.09,10.80,'2022-12-10 17:54:31','',''),(4363,'1','285','1',1,'Retail Sale Id 4403',1500.00,0.00,0.00,2.00,240.00,'2022-12-11 07:10:30','',''),(4364,'1','285','1',1,'Retail Sale Id 4404',2250.00,0.00,0.00,3.00,360.00,'2022-12-11 07:12:08','',''),(4365,'1','285','1',1,'Retail Sale Id 4405',16683.00,0.00,0.00,24.90,996.00,'2022-12-11 07:16:26','',''),(4366,'1','285','1',1,'Retail Sale Id 4406',16729.90,0.00,0.00,24.97,998.80,'2022-12-11 07:20:01','',''),(4367,'1','285','1',1,'Retail Sale Id 4407',4500.00,0.00,0.00,6.00,720.00,'2022-12-11 07:38:25','',''),(4368,'1','285','1',1,'Retail Sale Id 4408',3750.00,0.00,0.00,5.00,600.00,'2022-12-11 07:40:27','',''),(4369,'1','285','1',1,'Retail Sale Id 4409',750.00,0.00,0.00,1.00,120.00,'2022-12-11 07:45:52','',''),(4370,'1','285','1',1,'Retail Sale Id 4410',3000.00,0.00,0.00,4.00,480.00,'2022-12-11 07:56:27','',''),(4371,'1','285','1',1,'Retail Sale Id 4411',1500.00,0.00,0.00,2.00,240.00,'2022-12-11 08:00:54','',''),(4372,'1','285','1',1,'Retail Sale Id 4412',997.50,0.00,0.00,1.33,159.60,'2022-12-11 08:05:28','',''),(4373,'1','285','1',1,'Retail Sale Id 4413',997.50,0.00,0.00,1.33,159.60,'2022-12-11 08:09:34','',''),(4374,'1','285','1',1,'Retail Sale Id 4414',1500.00,0.00,0.00,2.00,240.00,'2022-12-11 08:15:35','',''),(4375,'1','285','1',1,'Retail Sale Id 4415',2250.00,0.00,0.00,3.00,360.00,'2022-12-11 08:17:02','',''),(4376,'1','285','1',1,'Retail Sale Id 4416',3000.00,0.00,0.00,4.00,480.00,'2022-12-11 08:20:24','',''),(4377,'1','285','1',1,'Retail Sale Id 4418',3750.00,0.00,0.00,5.00,600.00,'2022-12-11 08:23:11','',''),(4378,'1','285','1',1,'Retail Sale Id 4419',30150.00,0.00,0.00,45.00,1800.00,'2022-12-11 08:26:38','',''),(4379,'1','285','1',1,'Retail Sale Id 4420',2497.50,0.00,0.00,3.33,399.60,'2022-12-11 08:27:28','',''),(4380,'1','285','1',1,'Retail Sale Id 4421',997.50,0.00,0.00,1.33,159.60,'2022-12-11 08:28:23','',''),(4381,'1','285','1',1,'Retail Sale Id 4422',3997.50,0.00,0.00,5.33,639.60,'2022-12-11 08:31:40','',''),(4382,'1','285','1',1,'Retail Sale Id 4423',3000.00,0.00,0.00,4.00,480.00,'2022-12-11 08:33:17','',''),(4383,'1','285','1',1,'Retail Sale Id 4424',1500.00,0.00,0.00,2.00,240.00,'2022-12-11 08:41:35','',''),(4384,'1','285','1',1,'Retail Sale Id 4425',802.50,0.00,0.00,1.07,128.40,'2022-12-11 08:42:34','',''),(4385,'1','285','1',1,'Retail Sale Id 4426',802.50,0.00,0.00,1.07,128.40,'2022-12-11 08:45:18','',''),(4386,'1','285','1',1,'Retail Sale Id 4427',1500.00,0.00,0.00,2.00,240.00,'2022-12-11 08:46:45','',''),(4387,'1','285','1',1,'Retail Sale Id 4428',2250.00,0.00,0.00,3.00,360.00,'2022-12-11 08:52:53','',''),(4388,'1','285','1',1,'Retail Sale Id 4429',1500.00,0.00,0.00,2.00,240.00,'2022-12-11 08:54:24','',''),(4389,'1','285','1',1,'Retail Sale Id 4430',4500.00,0.00,0.00,6.00,720.00,'2022-12-11 09:02:43','',''),(4390,'1','285','1',1,'Retail Sale Id 4431',1500.00,0.00,0.00,2.00,240.00,'2022-12-11 09:03:31','',''),(4391,'1','285','1',1,'Retail Sale Id 4432',23450.00,0.00,0.00,35.00,1400.00,'2022-12-11 09:10:27','',''),(4392,'1','285','1',1,'Retail Sale Id 4433',13232.50,0.00,0.00,19.75,790.00,'2022-12-11 09:16:53','',''),(4393,'1','285','1',1,'Retail Sale Id 4434',1200.00,0.00,0.00,1.60,192.00,'2022-12-11 09:20:14','',''),(4394,'1','285','1',1,'Retail Sale Id 4435',10029.90,0.00,0.00,14.97,598.80,'2022-12-11 14:35:45','',''),(4395,'1','285','1',1,'Retail Sale Id 4436',32850.10,0.00,0.00,49.03,1961.20,'2022-12-11 14:36:37','',''),(4396,'1','285','1',1,'Retail Sale Id 4437',750.00,0.00,0.00,1.00,120.00,'2022-12-11 14:37:20','',''),(4397,'1','285','1',1,'Retail Sale Id 4438',16408.30,0.00,0.00,24.49,979.60,'2022-12-11 14:38:40','',''),(4398,'1','285','1',1,'Retail Sale Id 4439',36180.00,0.00,0.00,54.00,2160.00,'2022-12-11 14:39:17','',''),(4399,'1','285','1',1,'Retail Sale Id 4440',40997.30,0.00,0.00,61.19,2447.60,'2022-12-11 14:39:56','',''),(4400,'1','285','1',1,'Retail Sale Id 4441',54732.30,0.00,0.00,81.69,3267.60,'2022-12-11 14:41:05','',''),(4401,'1','285','1',1,'Retail Sale Id 4442',46900.00,0.00,0.00,70.00,2800.00,'2022-12-11 14:41:48','',''),(4402,'1','285','1',1,'Retail Sale Id 4443',9375.00,0.00,0.00,12.50,1500.00,'2022-12-11 14:43:10','',''),(4403,'1','285','1',1,'Retail Sale Id 4444',2250.00,0.00,0.00,3.00,360.00,'2022-12-11 14:57:03','',''),(4404,'1','285','1',1,'Retail Sale Id 4445',1500.00,0.00,0.00,2.00,240.00,'2022-12-11 14:58:10','',''),(4405,'1','285','1',1,'Retail Sale Id 4446',1500.00,0.00,0.00,2.00,240.00,'2022-12-11 14:59:18','',''),(4406,'1','285','1',1,'Retail Sale Id 4447',750.00,0.00,0.00,1.00,120.00,'2022-12-11 15:01:54','',''),(4407,'1','285','1',1,'Retail Sale Id 4448',1500.00,0.00,0.00,2.00,240.00,'2022-12-11 15:08:48','',''),(4408,'1','285','1',1,'Retail Sale Id 4449',1500.00,0.00,0.00,2.00,240.00,'2022-12-11 15:12:06','',''),(4409,'1','285','1',1,'Retail Sale Id 4450',997.50,0.00,0.00,1.33,159.60,'2022-12-11 15:13:38','',''),(4410,'1','285','1',1,'Retail Sale Id 4451',5250.00,0.00,0.00,7.00,840.00,'2022-12-11 15:15:51','',''),(4411,'1','285','1',1,'Retail Sale Id 4452',750.00,0.00,0.00,1.00,120.00,'2022-12-11 15:21:26','',''),(4412,'1','285','1',1,'Retail Sale Id 4453',2250.00,0.00,0.00,3.00,360.00,'2022-12-11 15:27:47','',''),(4413,'1','285','1',1,'Retail Sale Id 4454',997.50,0.00,0.00,1.33,159.60,'2022-12-11 15:36:28','',''),(4414,'1','285','1',1,'Retail Sale Id 4455',3997.50,0.00,0.00,5.33,639.60,'2022-12-11 15:40:35','',''),(4415,'1','285','1',1,'Retail Sale Id 4456',1500.00,0.00,0.00,2.00,240.00,'2022-12-11 15:58:07','',''),(4416,'1','285','1',1,'Retail Sale Id 4457',1500.00,0.00,0.00,2.00,240.00,'2022-12-11 16:01:09','',''),(4417,'1','285','1',1,'Retail Sale Id 4459',1500.00,0.00,0.00,2.00,240.00,'2022-12-11 16:07:28','',''),(4418,'1','285','1',1,'Retail Sale Id 4460',52434.20,0.00,0.00,78.26,3130.40,'2022-12-11 16:11:23','',''),(4419,'1','285','1',1,'Retail Sale Id 4461',34840.00,0.00,0.00,52.00,2080.00,'2022-12-11 16:20:45','',''),(4420,'1','285','1',1,'Retail Sale Id 4462',3997.50,0.00,0.00,5.33,639.60,'2022-12-11 16:24:44','',''),(4421,'1','285','1',1,'Retail Sale Id 4463',2002.50,0.00,0.00,2.67,320.40,'2022-12-11 16:27:54','',''),(4422,'1','285','1',1,'Retail Sale Id 4464',1500.00,0.00,0.00,2.00,240.00,'2022-12-11 16:33:39','',''),(4423,'1','285','1',1,'Retail Sale Id 4465',11678.10,0.00,0.00,17.43,697.20,'2022-12-11 16:45:37','',''),(4424,'1','285','1',1,'Retail Sale Id 4466',4237.50,0.00,0.00,5.65,678.00,'2022-12-11 17:05:32','',''),(4425,'1','285','1',1,'Retail Sale Id 4467',2497.50,0.00,0.00,3.33,399.60,'2022-12-12 07:00:18','',''),(4426,'1','285','1',1,'Retail Sale Id 4468',997.50,0.00,0.00,1.33,159.60,'2022-12-12 07:01:12','',''),(4427,'1','285','1',1,'Retail Sale Id 4469',3750.00,0.00,0.00,5.00,600.00,'2022-12-12 07:01:57','',''),(4428,'1','285','1',1,'Retail Sale Id 4470',1500.00,0.00,0.00,2.00,240.00,'2022-12-12 07:24:37','',''),(4429,'1','285','1',1,'Retail Sale Id 4471',750.00,0.00,0.00,1.00,120.00,'2022-12-12 07:25:29','',''),(4430,'1','285','1',1,'Retail Sale Id 4472',802.50,0.00,0.00,1.07,128.40,'2022-12-12 07:26:30','',''),(4431,'1','285','1',1,'Retail Sale Id 4473',4500.00,0.00,0.00,6.00,720.00,'2022-12-12 07:27:20','',''),(4432,'1','285','1',1,'Retail Sale Id 4474',1500.00,0.00,0.00,2.00,240.00,'2022-12-12 07:28:20','',''),(4433,'1','285','1',1,'Retail Sale Id 4475',1597.50,0.00,0.00,2.13,255.60,'2022-12-12 07:30:44','',''),(4434,'1','285','1',1,'Retail Sale Id 4476',1500.00,0.00,0.00,2.00,240.00,'2022-12-12 07:31:36','',''),(4435,'1','285','1',1,'Retail Sale Id 4477',4500.00,0.00,0.00,6.00,720.00,'2022-12-12 07:32:29','',''),(4436,'1','285','1',1,'Retail Sale Id 4478',40200.00,0.00,0.00,60.00,2400.00,'2022-12-12 07:35:00','',''),(4437,'1','285','1',1,'Retail Sale Id 4479',750.00,0.00,0.00,1.00,120.00,'2022-12-12 07:36:59','',''),(4438,'1','285','1',1,'Retail Sale Id 4480',2002.50,0.00,0.00,2.67,320.40,'2022-12-12 07:38:07','',''),(4439,'1','285','1',1,'Retail Sale Id 4481',2250.00,0.00,0.00,3.00,360.00,'2022-12-12 07:40:48','',''),(4440,'1','285','1',1,'Retail Sale Id 4482',3000.00,0.00,0.00,4.00,480.00,'2022-12-12 07:46:57','',''),(4441,'1','285','1',1,'Retail Sale Id 4483',4500.00,0.00,0.00,6.00,720.00,'2022-12-12 07:52:15','',''),(4442,'1','285','1',1,'Retail Sale Id 4484',1500.00,0.00,0.00,2.00,240.00,'2022-12-12 07:57:38','',''),(4443,'1','285','1',1,'Retail Sale Id 4485',5250.00,0.00,0.00,7.00,840.00,'2022-12-12 08:00:29','',''),(4444,'1','285','1',1,'Retail Sale Id 4486',3000.00,0.00,0.00,4.00,480.00,'2022-12-12 08:02:00','',''),(4445,'1','285','1',1,'Retail Sale Id 4487',997.50,0.00,0.00,1.33,159.60,'2022-12-12 08:10:46','',''),(4446,'1','285','1',1,'Retail Sale Id 4488',1500.00,0.00,0.00,2.00,240.00,'2022-12-12 08:11:45','',''),(4447,'1','285','1',1,'Retail Sale Id 4489',750.00,0.00,0.00,1.00,120.00,'2022-12-12 08:14:15','',''),(4448,'1','285','1',1,'Retail Sale Id 4490',41473.00,0.00,0.00,61.90,2476.00,'2022-12-12 08:15:37','',''),(4449,'1','285','1',1,'Retail Sale Id 4491',13400.00,0.00,0.00,20.00,800.00,'2022-12-12 08:19:28','',''),(4450,'1','285','1',1,'Retail Sale Id 4492',2250.00,0.00,0.00,3.00,360.00,'2022-12-12 08:20:33','',''),(4451,'1','285','1',1,'Retail Sale Id 4493',3000.00,0.00,0.00,4.00,480.00,'2022-12-12 08:21:42','',''),(4452,'1','285','1',1,'Retail Sale Id 4494',3000.00,0.00,0.00,4.00,480.00,'2022-12-12 08:22:30','',''),(4453,'1','285','1',1,'Retail Sale Id 4495',1500.00,0.00,0.00,2.00,240.00,'2022-12-12 08:23:17','',''),(4454,'1','285','1',1,'Retail Sale Id 4496',750.00,0.00,0.00,1.00,120.00,'2022-12-12 08:24:03','',''),(4455,'1','285','1',1,'Retail Sale Id 4497',30150.00,0.00,0.00,45.00,1800.00,'2022-12-12 08:25:48','',''),(4456,'1','285','1',1,'Retail Sale Id 4498',6000.00,0.00,0.00,8.00,960.00,'2022-12-12 08:29:05','',''),(4457,'1','285','1',1,'Retail Sale Id 4499',2250.00,0.00,0.00,3.00,360.00,'2022-12-12 08:39:03','',''),(4458,'1','285','1',1,'Retail Sale Id 4500',2250.00,0.00,0.00,3.00,360.00,'2022-12-12 08:43:37','',''),(4459,'1','285','1',1,'Retail Sale Id 4501',3000.00,0.00,0.00,4.00,480.00,'2022-12-12 08:47:02','',''),(4460,'1','285','1',1,'Retail Sale Id 4502',1500.00,0.00,0.00,2.00,240.00,'2022-12-12 08:49:15','',''),(4461,'1','285','1',1,'Retail Sale Id 4503',88379.70,0.00,0.00,131.91,5276.40,'2022-12-12 08:55:27','',''),(4462,'1','285','1',1,'Retail Sale Id 4504',16475.30,0.00,0.00,24.59,983.60,'2022-12-12 09:07:36','',''),(4463,'1','285','1',1,'Retail Sale Id 4505',7370.00,0.00,0.00,11.00,440.00,'2022-12-12 09:12:06','',''),(4464,'1','285','1',1,'Retail Sale Id 4506',110027.40,0.00,0.00,164.22,6568.80,'2022-12-12 09:14:46','',''),(4465,'1','285','1',1,'Retail Sale Id 4507',40200.00,0.00,0.00,60.00,2400.00,'2022-12-12 09:18:59','',''),(4466,'1','285','1',1,'Retail Sale Id 4508',24790.00,0.00,0.00,37.00,1480.00,'2022-12-12 09:26:41','',''),(4467,'1','285','1',1,'Retail Sale Id 4509',207083.60,0.00,0.00,309.08,12363.20,'2022-12-12 09:34:05','',''),(4468,'1','285','1',1,'Retail Sale Id 4510',90450.00,0.00,0.00,135.00,5400.00,'2022-12-12 09:35:09','',''),(4469,'1','285','1',1,'Retail Sale Id 4511',2250.00,0.00,0.00,3.00,360.00,'2022-12-12 09:51:46','',''),(4470,'1','285','1',1,'Retail Sale Id 4512',2250.00,0.00,0.00,3.00,360.00,'2022-12-12 09:53:16','',''),(4471,'1','285','1',1,'Retail Sale Id 4513',33500.00,0.00,0.00,50.00,2000.00,'2022-12-12 09:57:28','',''),(4472,'1','285','1',1,'Retail Sale Id 4514',3000.00,0.00,0.00,4.00,480.00,'2022-12-12 10:05:50','',''),(4473,'1','285','1',1,'Retail Sale Id 4515',33500.00,0.00,0.00,50.00,2000.00,'2022-12-12 10:06:51','',''),(4474,'1','285','1',1,'Retail Sale Id 4517',67000.00,0.00,0.00,100.00,4000.00,'2022-12-12 10:07:44','',''),(4475,'1','285','1',1,'Retail Sale Id 4519',75000.00,0.00,0.00,100.00,12000.00,'2022-12-12 10:09:46','',''),(4476,'1','285','1',1,'Retail Sale Id 4520',1500.00,0.00,0.00,2.00,240.00,'2022-12-12 10:10:41','',''),(4477,'1','285','1',1,'Return of Retail Sale Id 4519',0.00,75000.00,100.00,0.00,-12000.00,'2022-12-12 10:11:13','',''),(4478,'1','285','1',1,'Retail Sale Id 4521',39831.50,0.00,0.00,59.45,2378.00,'2022-12-12 10:11:57','',''),(4479,'1','285','1',1,'Retail Sale Id 4522',3000.00,0.00,0.00,4.00,480.00,'2022-12-12 10:19:18','',''),(4480,'1','285','1',1,'Retail Sale Id 4523',3750.00,0.00,0.00,5.00,600.00,'2022-12-12 10:20:47','',''),(4481,'1','285','1',1,'Retail Sale Id 4524',2250.00,0.00,0.00,3.00,360.00,'2022-12-12 10:30:01','',''),(4482,'1','285','1',1,'Retail Sale Id 4525',1500.00,0.00,0.00,2.00,240.00,'2022-12-12 10:35:52','',''),(4483,'1','285','1',1,'Retail Sale Id 4526',4500.00,0.00,0.00,6.00,720.00,'2022-12-12 10:37:25','',''),(4484,'1','285','1',1,'Retail Sale Id 4527',30150.00,0.00,0.00,45.00,1800.00,'2022-12-12 10:41:22','',''),(4485,'1','285','1',1,'Retail Sale Id 4528',750.00,0.00,0.00,1.00,120.00,'2022-12-12 10:48:12','',''),(4486,'1','285','1',1,'Retail Sale Id 4529',42035.80,0.00,0.00,62.74,2509.60,'2022-12-12 10:59:48','',''),(4487,'1','285','1',1,'Retail Sale Id 4530',41124.60,0.00,0.00,61.38,2455.20,'2022-12-12 11:05:46','',''),(4488,'1','285','1',1,'Retail Sale Id 4531',2002.50,0.00,0.00,2.67,320.40,'2022-12-12 11:08:48','',''),(4489,'1','285','1',1,'Retail Sale Id 4532',750.00,0.00,0.00,1.00,120.00,'2022-12-12 11:23:32','',''),(4490,'1','285','1',1,'Retail Sale Id 4533',23450.00,0.00,0.00,35.00,1400.00,'2022-12-12 11:25:55','',''),(4491,'1','285','1',1,'Retail Sale Id 4534',997.50,0.00,0.00,1.33,159.60,'2022-12-12 11:27:03','',''),(4492,'1','285','1',1,'Retail Sale Id 4535',997.50,0.00,0.00,1.33,159.60,'2022-12-12 11:46:17','',''),(4493,'1','285','1',1,'Retail Sale Id 4536',36850.00,0.00,0.00,55.00,2200.00,'2022-12-12 11:59:22','',''),(4494,'1','285','1',1,'Retail Sale Id 4537',29480.00,0.00,0.00,44.00,1760.00,'2022-12-12 12:19:50','',''),(4495,'1','285','1',1,'Retail Sale Id 4538',1500.00,0.00,0.00,2.00,240.00,'2022-12-12 12:22:49','',''),(4496,'1','285','1',1,'Retail Sale Id 4539',2002.50,0.00,0.00,2.67,320.40,'2022-12-12 12:24:36','',''),(4497,'1','285','1',1,'Retail Sale Id 4540',2250.00,0.00,0.00,3.00,360.00,'2022-12-12 12:40:52','',''),(4498,'1','285','1',1,'Retail Sale Id 4541',2002.50,0.00,0.00,2.67,320.40,'2022-12-12 12:41:51','',''),(4499,'1','285','1',1,'Retail Sale Id 4542',1500.00,0.00,0.00,2.00,240.00,'2022-12-12 13:16:23','',''),(4500,'1','285','1',1,'Retail Sale Id 4543',1500.00,0.00,0.00,2.00,240.00,'2022-12-12 13:20:50','',''),(4501,'1','285','1',1,'Retail Sale Id 4544',750.00,0.00,0.00,1.00,120.00,'2022-12-12 13:25:08','',''),(4502,'1','285','1',1,'Retail Sale Id 4545',1500.00,0.00,0.00,2.00,240.00,'2022-12-12 13:26:08','',''),(4503,'1','285','1',1,'Retail Sale Id 4546',2250.00,0.00,0.00,3.00,360.00,'2022-12-12 13:27:04','',''),(4504,'1','285','1',1,'Retail Sale Id 4547',802.50,0.00,0.00,1.07,128.40,'2022-12-12 13:33:39','',''),(4505,'1','285','1',1,'Retail Sale Id 4548',5497.50,0.00,0.00,7.33,879.60,'2022-12-12 13:34:55','',''),(4506,'1','285','1',1,'Retail Sale Id 4549',1500.00,0.00,0.00,2.00,240.00,'2022-12-12 13:35:42','',''),(4507,'1','285','1',1,'Retail Sale Id 4550',3000.00,0.00,0.00,4.00,480.00,'2022-12-12 13:36:39','',''),(4508,'1','285','1',1,'Retail Sale Id 4551',4500.00,0.00,0.00,6.00,720.00,'2022-12-12 13:37:27','',''),(4509,'1','285','1',1,'Retail Sale Id 4552',1500.00,0.00,0.00,2.00,240.00,'2022-12-12 13:38:10','',''),(4510,'1','285','1',1,'Retail Sale Id 4553',9842.30,0.00,0.00,14.69,587.60,'2022-12-12 13:45:54','',''),(4511,'1','285','1',1,'Retail Sale Id 4554',61975.00,0.00,0.00,92.50,3700.00,'2022-12-12 13:49:22','',''),(4512,'1','285','1',1,'Retail Sale Id 4555',750.00,0.00,0.00,1.00,120.00,'2022-12-12 13:50:45','',''),(4513,'1','285','1',1,'Retail Sale Id 4556',2002.50,0.00,0.00,2.67,320.40,'2022-12-12 13:55:23','',''),(4514,'1','285','1',1,'Retail Sale Id 4557',1500.00,0.00,0.00,2.00,240.00,'2022-12-12 13:56:16','',''),(4515,'1','285','1',1,'Retail Sale Id 4558',33500.00,0.00,0.00,50.00,2000.00,'2022-12-12 13:59:43','',''),(4516,'1','285','1',1,'Retail Sale Id 4559',750.00,0.00,0.00,1.00,120.00,'2022-12-12 14:02:37','',''),(4517,'1','285','1',1,'Retail Sale Id 4560',3000.00,0.00,0.00,4.00,480.00,'2022-12-12 14:03:59','',''),(4518,'1','285','1',1,'Retail Sale Id 4561',2730.00,0.00,0.00,3.64,436.80,'2022-12-12 14:08:52','',''),(4519,'1','285','1',1,'Retail Sale Id 4562',1500.00,0.00,0.00,2.00,240.00,'2022-12-12 14:12:06','',''),(4520,'1','285','1',1,'Retail Sale Id 4563',32086.30,0.00,0.00,47.89,1915.60,'2022-12-12 14:43:47','',''),(4521,'1','285','1',1,'Retail Sale Id 4564',1500.00,0.00,0.00,2.00,240.00,'2022-12-12 14:54:56','',''),(4522,'1','285','1',1,'Retail Sale Id 4565',2002.50,0.00,0.00,2.67,320.40,'2022-12-12 14:59:49','',''),(4523,'1','285','1',1,'Retail Sale Id 4566',750.00,0.00,0.00,1.00,120.00,'2022-12-12 15:01:47','',''),(4524,'1','285','1',1,'Retail Sale Id 4567',2250.00,0.00,0.00,3.00,360.00,'2022-12-12 15:07:29','',''),(4525,'1','285','1',1,'Retail Sale Id 4568',1500.00,0.00,0.00,2.00,240.00,'2022-12-12 15:43:13','',''),(4526,'1','285','1',1,'Retail Sale Id 4569',2550.00,0.00,0.00,3.40,408.00,'2022-12-12 15:50:57','',''),(4527,'1','285','1',1,'Retail Sale Id 4570',750.00,0.00,0.00,1.00,120.00,'2022-12-12 15:51:57','',''),(4528,'1','285','1',1,'Retail Sale Id 4571',17085.00,0.00,0.00,25.50,1020.00,'2022-12-12 15:53:03','',''),(4529,'1','285','1',1,'Retail Sale Id 4572',3750.00,0.00,0.00,5.00,600.00,'2022-12-12 15:54:21','',''),(4530,'1','285','1',1,'Retail Sale Id 4573',3697.50,0.00,0.00,4.93,591.60,'2022-12-12 16:04:22','',''),(4531,'1','285','1',1,'Retail Sale Id 4574',9000.00,0.00,0.00,12.00,1440.00,'2022-12-12 16:15:07','',''),(4532,'1','285','1',1,'Retail Sale Id 4575',750.00,0.00,0.00,1.00,120.00,'2022-12-12 16:17:01','',''),(4533,'1','285','1',1,'Retail Sale Id 4576',2250.00,0.00,0.00,3.00,360.00,'2022-12-12 16:23:39','',''),(4534,'1','285','1',1,'Retail Sale Id 4577',11678.10,0.00,0.00,17.43,697.20,'2022-12-12 16:35:12','',''),(4535,'1','285','1',1,'Retail Sale Id 4578',33500.00,0.00,0.00,50.00,2000.00,'2022-12-12 16:44:01','',''),(4536,'1','285','1',1,'Retail Sale Id 4579',3750.00,0.00,0.00,5.00,600.00,'2022-12-12 16:44:52','',''),(4537,'1','285','1',1,'Retail Sale Id 4580',997.50,0.00,0.00,1.33,159.60,'2022-12-12 16:48:06','',''),(4538,'1','285','1',1,'Retail Sale Id 4581',3000.00,0.00,0.00,4.00,480.00,'2022-12-12 16:54:07','',''),(4539,'1','285','1',1,'Retail Sale Id 4582',750.00,0.00,0.00,1.00,120.00,'2022-12-12 16:59:37','',''),(4540,'1','285','1',1,'Retail Sale Id 4583',126857.80,0.00,0.00,189.34,7573.60,'2022-12-12 17:00:26','',''),(4541,'1','285','1',1,'Retail Sale Id 4584',2250.00,0.00,0.00,3.00,360.00,'2022-12-12 17:01:14','',''),(4542,'1','285','1',1,'Retail Sale Id 4585',3000.00,0.00,0.00,4.00,480.00,'2022-12-12 17:02:14','',''),(4543,'1','285','1',1,'Retail Sale Id 4586',6750.00,0.00,0.00,9.00,1080.00,'2022-12-12 17:03:36','',''),(4544,'1','285','1',1,'Retail Sale Id 4587',2497.50,0.00,0.00,3.33,399.60,'2022-12-12 17:04:47','',''),(4545,'1','285','1',1,'Retail Sale Id 4588',2002.50,0.00,0.00,2.67,320.40,'2022-12-12 17:05:36','',''),(4546,'1','285','1',1,'Retail Sale Id 4589',4320.00,0.00,0.00,5.76,691.20,'2022-12-12 17:31:18','',''),(4547,'1','285','1',1,'Retail Sale Id 4590',790.60,0.00,0.00,1.18,47.20,'2022-12-12 19:22:03','',''),(4548,'1','285','1',1,'Retail Sale Id 4591',1500.00,0.00,0.00,2.00,240.00,'2022-12-13 07:03:21','',''),(4549,'1','285','1',1,'Retail Sale Id 4592',3000.00,0.00,0.00,4.00,480.00,'2022-12-13 07:06:59','',''),(4550,'1','285','1',1,'Retail Sale Id 4593',3997.50,0.00,0.00,5.33,639.60,'2022-12-13 07:08:18','',''),(4551,'1','285','1',1,'Retail Sale Id 4594',10197.40,0.00,0.00,15.22,608.80,'2022-12-13 07:09:38','',''),(4552,'1','285','1',1,'Retail Sale Id 4595',3000.00,0.00,0.00,4.00,480.00,'2022-12-13 07:10:14','',''),(4553,'1','285','1',1,'Retail Sale Id 4596',26800.00,0.00,0.00,40.00,1600.00,'2022-12-13 07:11:05','',''),(4554,'1','285','1',1,'Return of Retail Sale Id 4593',0.00,3997.50,5.33,0.00,-639.60,'2022-12-13 07:12:30','',''),(4555,'1','285','1',1,'Retail Sale Id 4597',3000.00,0.00,0.00,4.00,480.00,'2022-12-13 07:20:30','',''),(4556,'1','285','1',1,'Retail Sale Id 4598',40742.70,0.00,0.00,60.81,2432.40,'2022-12-13 07:29:03','',''),(4557,'1','285','1',1,'Retail Sale Id 4599',4500.00,0.00,0.00,6.00,720.00,'2022-12-13 07:31:51','',''),(4558,'1','285','1',1,'Retail Sale Id 4600',41392.60,0.00,0.00,61.78,2471.20,'2022-12-13 07:36:05','',''),(4559,'1','285','1',1,'Retail Sale Id 4601',20100.00,0.00,0.00,30.00,1200.00,'2022-12-13 07:40:26','',''),(4560,'1','285','1',1,'Retail Sale Id 4602',2250.00,0.00,0.00,3.00,360.00,'2022-12-13 07:41:12','',''),(4561,'1','285','1',1,'Retail Sale Id 4603',31959.00,0.00,0.00,47.70,1908.00,'2022-12-13 07:49:04','',''),(4562,'1','285','1',1,'Retail Sale Id 4604',2250.00,0.00,0.00,3.00,360.00,'2022-12-13 07:52:21','',''),(4563,'1','285','1',1,'Retail Sale Id 4605',750.00,0.00,0.00,1.00,120.00,'2022-12-13 07:53:49','',''),(4564,'1','285','1',1,'Retail Sale Id 4606',2250.00,0.00,0.00,3.00,360.00,'2022-12-13 07:54:42','',''),(4565,'1','285','1',1,'Retail Sale Id 4607',41459.60,0.00,0.00,61.88,2475.20,'2022-12-13 07:55:59','',''),(4566,'1','285','1',1,'Retail Sale Id 4608',3000.00,0.00,0.00,4.00,480.00,'2022-12-13 07:56:37','',''),(4567,'1','285','1',1,'Retail Sale Id 4609',2002.50,0.00,0.00,2.67,320.40,'2022-12-13 07:58:04','',''),(4568,'1','285','1',1,'Retail Sale Id 4610',0.00,0.00,0.00,0.00,0.00,'2022-12-13 07:58:49','',''),(4569,'1','285','1',1,'Retail Sale Id 4611',1500.00,0.00,0.00,2.00,240.00,'2022-12-13 08:02:09','',''),(4570,'1','285','1',1,'Return of Retail Sale Id 4610',0.00,0.00,0.00,0.00,0.00,'2022-12-13 08:03:15','',''),(4571,'1','285','1',1,'Retail Sale Id 4612',1500.00,0.00,0.00,2.00,240.00,'2022-12-13 08:06:27','',''),(4572,'1','285','1',1,'Retail Sale Id 4613',750.00,0.00,0.00,1.00,120.00,'2022-12-13 08:07:59','',''),(4573,'1','285','1',1,'Retail Sale Id 4614',3000.00,0.00,0.00,4.00,480.00,'2022-12-13 08:14:43','',''),(4574,'1','285','1',1,'Retail Sale Id 4615',2002.50,0.00,0.00,2.67,320.40,'2022-12-13 08:19:33','',''),(4575,'1','285','1',1,'Retail Sale Id 4616',38190.00,0.00,0.00,57.00,2280.00,'2022-12-13 08:24:22','',''),(4576,'1','285','1',1,'Retail Sale Id 4617',16709.80,0.00,0.00,24.94,997.60,'2022-12-13 08:25:33','',''),(4577,'1','285','1',1,'Retail Sale Id 4618',40682.40,0.00,0.00,60.72,2428.80,'2022-12-13 08:27:54','',''),(4578,'1','285','1',1,'Retail Sale Id 4619',3000.00,0.00,0.00,4.00,480.00,'2022-12-13 08:33:25','',''),(4579,'1','285','1',1,'Retail Sale Id 4620',16750.00,0.00,0.00,25.00,1000.00,'2022-12-13 08:37:27','',''),(4580,'1','285','1',1,'Retail Sale Id 4621',1500.00,0.00,0.00,2.00,240.00,'2022-12-13 08:39:15','',''),(4581,'1','285','1',1,'Retail Sale Id 4622',750.00,0.00,0.00,1.00,120.00,'2022-12-13 08:53:42','',''),(4582,'1','285','1',1,'Retail Sale Id 4623',3000.00,0.00,0.00,4.00,480.00,'2022-12-13 08:59:34','',''),(4583,'1','285','1',1,'Retail Sale Id 4624',40253.60,0.00,0.00,60.08,2403.20,'2022-12-13 09:04:43','',''),(4584,'1','285','1',1,'Retail Sale Id 4625',41774.50,0.00,0.00,62.35,2494.00,'2022-12-13 09:05:57','',''),(4585,'1','285','1',1,'Retail Sale Id 4626',2002.50,0.00,0.00,2.67,320.40,'2022-12-13 09:06:56','',''),(4586,'1','285','1',1,'Retail Sale Id 4627',997.50,0.00,0.00,1.33,159.60,'2022-12-13 09:08:11','',''),(4587,'1','285','1',1,'Retail Sale Id 4628',750.00,0.00,0.00,1.00,120.00,'2022-12-13 09:10:40','',''),(4588,'1','285','1',1,'Retail Sale Id 4629',9375.00,0.00,0.00,12.50,1500.00,'2022-12-13 09:18:14','',''),(4589,'1','285','1',1,'Retail Sale Id 4630',4500.00,0.00,0.00,6.00,720.00,'2022-12-13 09:23:58','',''),(4590,'1','285','1',1,'Retail Sale Id 4631',2250.00,0.00,0.00,3.00,360.00,'2022-12-13 09:24:45','',''),(4591,'1','285','1',1,'Retail Sale Id 4632',1500.00,0.00,0.00,2.00,240.00,'2022-12-13 09:27:49','',''),(4592,'1','285','1',1,'Retail Sale Id 4633',750.00,0.00,0.00,1.00,120.00,'2022-12-13 09:55:03','',''),(4593,'1','285','1',1,'Retail Sale Id 4634',40394.30,0.00,0.00,60.29,2411.60,'2022-12-13 10:06:02','',''),(4594,'1','285','1',1,'Retail Sale Id 4635',16716.50,0.00,0.00,24.95,998.00,'2022-12-13 10:10:45','',''),(4595,'1','285','1',1,'Retail Sale Id 4636',40468.00,0.00,0.00,60.40,2416.00,'2022-12-13 10:11:45','',''),(4596,'1','285','1',1,'Retail Sale Id 4637',40782.90,0.00,0.00,60.87,2434.80,'2022-12-13 10:23:26','',''),(4597,'1','285','1',1,'Retail Sale Id 4638',1500.00,0.00,0.00,2.00,240.00,'2022-12-13 10:27:10','',''),(4598,'1','285','1',1,'Retail Sale Id 4639',997.50,0.00,0.00,1.33,159.60,'2022-12-13 10:48:28','',''),(4599,'1','285','1',1,'Retail Sale Id 4640',2002.50,0.00,0.00,2.67,320.40,'2022-12-13 10:55:43','',''),(4600,'1','285','1',1,'Retail Sale Id 4641',1500.00,0.00,0.00,2.00,240.00,'2022-12-13 10:58:30','',''),(4601,'1','285','1',1,'Retail Sale Id 4642',56440.80,0.00,0.00,84.24,3369.60,'2022-12-13 11:13:50','',''),(4602,'1','285','1',1,'Retail Sale Id 4643',1500.00,0.00,0.00,2.00,240.00,'2022-12-13 11:14:58','',''),(4603,'1','285','1',1,'Retail Sale Id 4644',40930.30,0.00,0.00,61.09,2443.60,'2022-12-13 11:18:08','',''),(4604,'1','285','1',1,'Retail Sale Id 4645',41004.00,0.00,0.00,61.20,2448.00,'2022-12-13 11:24:08','',''),(4605,'1','285','1',1,'Retail Sale Id 4646',1500.00,0.00,0.00,2.00,240.00,'2022-12-13 11:40:17','',''),(4606,'1','285','1',1,'Retail Sale Id 4647',29480.00,0.00,0.00,44.00,1760.00,'2022-12-13 12:05:19','',''),(4607,'1','285','1',1,'Retail Sale Id 4648',997.50,0.00,0.00,1.33,159.60,'2022-12-13 12:16:08','',''),(4608,'1','285','1',1,'Retail Sale Id 4649',2002.50,0.00,0.00,2.67,320.40,'2022-12-13 12:31:26','',''),(4609,'1','285','1',1,'Retail Sale Id 4650',1500.00,0.00,0.00,2.00,240.00,'2022-12-13 12:41:37','',''),(4610,'1','285','1',1,'Retail Sale Id 4651',802.50,0.00,0.00,1.07,128.40,'2022-12-13 12:49:04','',''),(4611,'1','285','1',1,'Retail Sale Id 4652',750.00,0.00,0.00,1.00,120.00,'2022-12-13 13:05:52','',''),(4612,'1','285','1',1,'Retail Sale Id 4653',33500.00,0.00,0.00,50.00,2000.00,'2022-12-13 13:17:32','',''),(4613,'1','285','1',1,'Retail Sale Id 4654',997.50,0.00,0.00,1.33,159.60,'2022-12-13 13:21:06','',''),(4614,'1','285','1',1,'Retail Sale Id 4655',1500.00,0.00,0.00,2.00,240.00,'2022-12-13 13:24:08','',''),(4615,'1','285','1',1,'Retail Sale Id 4656',40555.10,0.00,0.00,60.53,2421.20,'2022-12-13 13:46:08','',''),(4616,'1','285','1',1,'Retail Sale Id 4657',60300.00,0.00,0.00,90.00,3600.00,'2022-12-13 13:51:44','',''),(4617,'1','285','1',1,'Retail Sale Id 4658',750.00,0.00,0.00,1.00,120.00,'2022-12-13 13:57:44','',''),(4618,'1','285','1',1,'Retail Sale Id 4659',1500.00,0.00,0.00,2.00,240.00,'2022-12-13 13:58:29','',''),(4619,'1','285','1',1,'Retail Sale Id 4660',1500.00,0.00,0.00,2.00,240.00,'2022-12-13 14:02:51','',''),(4620,'1','285','1',1,'Retail Sale Id 4661',2497.50,0.00,0.00,3.33,399.60,'2022-12-13 14:06:14','',''),(4621,'1','285','1',1,'Retail Sale Id 4662',2002.50,0.00,0.00,2.67,320.40,'2022-12-13 14:09:34','',''),(4622,'1','285','1',1,'Retail Sale Id 4663',2250.00,0.00,0.00,3.00,360.00,'2022-12-13 14:11:07','',''),(4623,'1','285','1',1,'Retail Sale Id 4664',5250.00,0.00,0.00,7.00,840.00,'2022-12-13 14:14:38','',''),(4624,'1','285','1',1,'Retail Sale Id 4665',1500.00,0.00,0.00,2.00,240.00,'2022-12-13 14:21:01','',''),(4625,'1','285','1',1,'Retail Sale Id 4666',4500.00,0.00,0.00,6.00,720.00,'2022-12-13 14:32:24','',''),(4626,'1','285','1',1,'Retail Sale Id 4667',1500.00,0.00,0.00,2.00,240.00,'2022-12-13 14:33:56','',''),(4627,'1','285','1',1,'Retail Sale Id 4668',40186.60,0.00,0.00,59.98,2399.20,'2022-12-13 14:48:36','',''),(4628,'1','285','1',1,'Retail Sale Id 4669',1500.00,0.00,0.00,2.00,240.00,'2022-12-13 14:51:56','',''),(4629,'1','285','1',1,'Retail Sale Id 4670',3000.00,0.00,0.00,4.00,480.00,'2022-12-13 14:54:05','',''),(4630,'1','285','1',1,'Retail Sale Id 4671',952.50,0.00,0.00,1.27,152.40,'2022-12-13 14:55:23','',''),(4631,'1','285','1',1,'Retail Sale Id 4672',47677.20,0.00,0.00,71.16,2846.40,'2022-12-13 15:19:28','',''),(4632,'1','285','1',1,'Retail Sale Id 4673',2497.50,0.00,0.00,3.33,399.60,'2022-12-13 15:32:47','',''),(4633,'1','285','1',1,'Retail Sale Id 4674',40890.10,0.00,0.00,61.03,2441.20,'2022-12-13 15:38:50','',''),(4634,'1','285','1',1,'Retail Sale Id 4675',1500.00,0.00,0.00,2.00,240.00,'2022-12-13 15:41:00','',''),(4635,'1','285','1',1,'Retail Sale Id 4676',36850.00,0.00,0.00,55.00,2200.00,'2022-12-13 15:46:44','',''),(4636,'1','285','1',1,'Retail Sale Id 4677',750.00,0.00,0.00,1.00,120.00,'2022-12-13 15:51:54','',''),(4637,'1','285','1',1,'Retail Sale Id 4678',1800.00,0.00,0.00,2.40,288.00,'2022-12-13 16:02:50','',''),(4638,'1','285','1',1,'Retail Sale Id 4679',750.00,0.00,0.00,1.00,120.00,'2022-12-13 16:08:12','',''),(4639,'1','285','1',1,'Retail Sale Id 4680',38009.10,0.00,0.00,56.73,2269.20,'2022-12-13 16:13:21','',''),(4640,'1','285','1',1,'Retail Sale Id 4681',1500.00,0.00,0.00,2.00,240.00,'2022-12-13 16:17:17','',''),(4641,'1','285','1',1,'Retail Sale Id 4682',1500.00,0.00,0.00,2.00,240.00,'2022-12-13 16:20:42','',''),(4642,'1','285','1',1,'Retail Sale Id 4683',64487.50,0.00,0.00,96.25,3850.00,'2022-12-13 16:22:08','',''),(4643,'1','285','1',1,'Retail Sale Id 4684',43911.80,0.00,0.00,65.54,2621.60,'2022-12-13 16:31:49','',''),(4644,'1','285','1',1,'Retail Sale Id 4685',2250.00,0.00,0.00,3.00,360.00,'2022-12-13 16:36:22','',''),(4645,'1','285','1',1,'Retail Sale Id 4686',5250.00,0.00,0.00,7.00,840.00,'2022-12-13 16:39:40','',''),(4646,'1','285','1',1,'Retail Sale Id 4687',20100.00,0.00,0.00,30.00,1200.00,'2022-12-13 16:42:25','',''),(4647,'1','285','1',1,'Retail Sale Id 4689',3750.00,0.00,0.00,5.00,600.00,'2022-12-13 16:44:12','',''),(4648,'1','285','1',1,'Retail Sale Id 4690',997.50,0.00,0.00,1.33,159.60,'2022-12-13 16:47:03','',''),(4649,'1','285','1',1,'Retail Sale Id 4692',750.00,0.00,0.00,1.00,120.00,'2022-12-13 16:50:04','',''),(4650,'1','285','1',1,'Retail Sale Id 4693',9862.40,0.00,0.00,14.72,588.80,'2022-12-13 16:55:36','',''),(4651,'1','285','1',1,'Retail Sale Id 4694',40568.50,0.00,0.00,60.55,2422.00,'2022-12-13 16:57:34','',''),(4652,'1','285','1',1,'Retail Sale Id 4695',1965.00,0.00,0.00,2.62,314.40,'2022-12-13 17:10:27','',''),(4653,'1','285','1',1,'Retail Sale Id 4696',3323.20,0.00,0.00,4.96,198.40,'2022-12-13 17:11:42','',''),(4654,'1','285','1',1,'Retail Sale Id 4697',750.00,0.00,0.00,1.00,120.00,'2022-12-14 07:02:43','',''),(4655,'1','285','1',1,'Retail Sale Id 4698',7500.00,0.00,0.00,10.00,1200.00,'2022-12-14 07:03:35','',''),(4656,'1','285','1',1,'Retail Sale Id 4699',1402.50,0.00,0.00,1.87,224.40,'2022-12-14 07:05:48','',''),(4657,'1','285','1',1,'Retail Sale Id 4700',12998.00,0.00,0.00,19.40,776.00,'2022-12-14 07:10:02','',''),(4658,'1','285','1',1,'Retail Sale Id 4701',16642.80,0.00,0.00,24.84,993.60,'2022-12-14 07:11:35','',''),(4659,'1','285','1',1,'Retail Sale Id 4702',13400.00,0.00,0.00,20.00,800.00,'2022-12-14 07:15:19','',''),(4660,'1','285','1',1,'Retail Sale Id 4703',25460.00,0.00,0.00,38.00,1520.00,'2022-12-14 07:18:17','',''),(4661,'1','285','1',1,'Retail Sale Id 4704',9000.00,0.00,0.00,12.00,1440.00,'2022-12-14 07:24:30','',''),(4662,'1','285','1',1,'Retail Sale Id 4705',900.00,0.00,0.00,1.20,144.00,'2022-12-14 07:27:26','',''),(4663,'1','285','1',1,'Retail Sale Id 4706',997.50,0.00,0.00,1.33,159.60,'2022-12-14 07:28:21','',''),(4664,'1','285','1',1,'Retail Sale Id 4707',80400.00,0.00,0.00,120.00,4800.00,'2022-12-14 07:41:18','',''),(4665,'1','285','1',1,'Retail Sale Id 4708',3000.00,0.00,0.00,4.00,480.00,'2022-12-14 07:42:04','',''),(4666,'1','285','1',1,'Retail Sale Id 4709',1500.00,0.00,0.00,2.00,240.00,'2022-12-14 07:42:47','',''),(4667,'1','285','1',1,'Retail Sale Id 4710',2302.50,0.00,0.00,3.07,368.40,'2022-12-14 07:47:46','',''),(4668,'1','285','1',1,'Retail Sale Id 4711',3000.00,0.00,0.00,4.00,480.00,'2022-12-14 07:49:40','',''),(4669,'1','285','1',1,'Retail Sale Id 4712',33500.00,0.00,0.00,50.00,2000.00,'2022-12-14 07:59:07','',''),(4670,'1','285','1',1,'Retail Sale Id 4713',2197.50,0.00,0.00,2.93,351.60,'2022-12-14 08:00:16','',''),(4671,'1','285','1',1,'Retail Sale Id 4714',750.00,0.00,0.00,1.00,120.00,'2022-12-14 08:04:11','',''),(4672,'1','285','1',1,'Retail Sale Id 4715',4500.00,0.00,0.00,6.00,720.00,'2022-12-14 08:05:00','',''),(4673,'1','285','1',1,'Retail Sale Id 4716',802.50,0.00,0.00,1.07,128.40,'2022-12-14 08:05:51','',''),(4674,'1','285','1',1,'Retail Sale Id 4718',3000.00,0.00,0.00,4.00,480.00,'2022-12-14 08:07:32','',''),(4675,'1','285','1',1,'Retail Sale Id 4719',21440.00,0.00,0.00,32.00,1280.00,'2022-12-14 08:11:14','',''),(4676,'1','285','1',1,'Retail Sale Id 4720',5250.00,0.00,0.00,7.00,840.00,'2022-12-14 08:14:47','',''),(4677,'1','285','1',1,'Retail Sale Id 4721',1500.00,0.00,0.00,2.00,240.00,'2022-12-14 08:17:00','',''),(4678,'1','285','1',1,'Retail Sale Id 4722',997.50,0.00,0.00,1.33,159.60,'2022-12-14 08:22:02','',''),(4679,'1','285','1',1,'Retail Sale Id 4723',2250.00,0.00,0.00,3.00,360.00,'2022-12-14 08:29:09','',''),(4680,'1','285','1',1,'Retail Sale Id 4724',3750.00,0.00,0.00,5.00,600.00,'2022-12-14 08:46:39','',''),(4681,'1','285','1',1,'Retail Sale Id 4725',198581.30,0.00,0.00,296.39,11855.60,'2022-12-14 09:04:46','',''),(4682,'1','285','1',1,'Retail Sale Id 4726',2197.50,0.00,0.00,2.93,351.60,'2022-12-14 09:07:25','',''),(4683,'1','285','1',1,'Retail Sale Id 4727',2250.00,0.00,0.00,3.00,360.00,'2022-12-14 09:08:56','',''),(4684,'1','285','1',1,'Retail Sale Id 4728',5250.00,0.00,0.00,7.00,840.00,'2022-12-14 09:21:26','',''),(4685,'1','285','1',1,'Retail Sale Id 4729',8250.00,0.00,0.00,11.00,1320.00,'2022-12-14 09:24:10','',''),(4686,'1','285','1',1,'Retail Sale Id 4730',802.50,0.00,0.00,1.07,128.40,'2022-12-14 09:25:27','',''),(4687,'1','285','1',1,'Retail Sale Id 4731',40200.00,0.00,0.00,60.00,2400.00,'2022-12-14 09:31:03','',''),(4688,'1','285','1',1,'Retail Sale Id 4732',1500.00,0.00,0.00,2.00,240.00,'2022-12-14 09:32:19','',''),(4689,'1','285','1',1,'Retail Sale Id 4733',9375.00,0.00,0.00,12.50,1500.00,'2022-12-14 09:33:16','',''),(4690,'1','285','1',1,'Retail Sale Id 4734',41499.80,0.00,0.00,61.94,2477.60,'2022-12-14 09:37:47','',''),(4691,'1','285','1',1,'Retail Sale Id 4735',33500.00,0.00,0.00,50.00,2000.00,'2022-12-14 09:41:17','',''),(4692,'1','285','1',1,'Retail Sale Id 4736',750.00,0.00,0.00,1.00,120.00,'2022-12-14 09:43:11','',''),(4693,'1','285','1',1,'Retail Sale Id 4737',81699.80,0.00,0.00,121.94,4877.60,'2022-12-14 09:45:58','',''),(4694,'1','285','1',1,'Retail Sale Id 4738',12730.00,0.00,0.00,19.00,760.00,'2022-12-14 09:53:45','',''),(4695,'1','285','1',1,'Retail Sale Id 4739',41540.00,0.00,0.00,62.00,2480.00,'2022-12-14 09:58:33','',''),(4696,'1','285','1',1,'Retail Sale Id 4740',41151.40,0.00,0.00,61.42,2456.80,'2022-12-14 10:09:08','',''),(4697,'1','285','1',1,'Retail Sale Id 4741',802.50,0.00,0.00,1.07,128.40,'2022-12-14 10:11:42','',''),(4698,'1','285','1',1,'Retail Sale Id 4742',1500.00,0.00,0.00,2.00,240.00,'2022-12-14 10:13:14','',''),(4699,'1','285','1',1,'Retail Sale Id 4743',40200.00,0.00,0.00,60.00,2400.00,'2022-12-14 10:17:53','',''),(4700,'1','285','1',1,'Retail Sale Id 4744',33500.00,0.00,0.00,50.00,2000.00,'2022-12-14 10:32:33','',''),(4701,'1','285','1',1,'Retail Sale Id 4745',5250.00,0.00,0.00,7.00,840.00,'2022-12-14 10:49:56','',''),(4702,'1','285','1',1,'Retail Sale Id 4746',40595.30,0.00,0.00,60.59,2423.60,'2022-12-14 10:55:22','',''),(4703,'1','285','1',1,'Retail Sale Id 4747',2002.50,0.00,0.00,2.67,320.40,'2022-12-14 11:04:31','',''),(4704,'1','285','1',1,'Retail Sale Id 4748',65539.40,0.00,0.00,97.82,3912.80,'2022-12-14 11:21:57','',''),(4705,'1','285','1',1,'Retail Sale Id 4749',10720.00,0.00,0.00,16.00,640.00,'2022-12-14 12:29:45','',''),(4706,'1','285','1',1,'Retail Sale Id 4750',40883.40,0.00,0.00,61.02,2440.80,'2022-12-14 12:33:57','',''),(4707,'1','285','1',1,'Return of Retail Sale Id 4750',0.00,40883.40,61.02,0.00,-2440.80,'2022-12-14 12:42:56','',''),(4708,'1','285','1',1,'Return of Retail Sale Id 4747',0.00,2002.50,2.67,0.00,-320.40,'2022-12-14 13:09:03','',''),(4709,'1','285','1',1,'Retail Sale Id 4751',2010.00,0.00,0.00,2.68,321.60,'2022-12-14 13:09:41','',''),(4710,'1','285','1',1,'Distributed to AA RANO NIGERIA LTD for sales id:5',201940.20,0.00,0.00,320.54,0.00,'2022-12-14 13:16:45','',''),(4711,'1','285',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,11214000.00,17800.00,0.00,0.00,'2022-12-14 13:27:58','',''),(4712,'1','285',NULL,1,'Reception corrector for bridging 6',0.00,0.00,0.00,17800.00,0.00,'2022-12-14 13:36:49','',''),(4713,'1','285','1',1,'Received from bridging 6',0.00,0.00,17800.00,0.00,0.00,'2022-12-14 13:36:49','',''),(4714,'1','285','1',1,'Retail Sale Id 4752',40883.40,0.00,0.00,61.02,2440.80,'2022-12-14 13:42:57','',''),(4715,'1','285','1',1,'Retail Sale Id 4753',40602.00,0.00,0.00,60.60,2424.00,'2022-12-14 13:45:04','',''),(4716,'1','285','1',1,'Retail Sale Id 4754',38994.00,0.00,0.00,58.20,2328.00,'2022-12-14 13:46:47','',''),(4717,'1','285','1',1,'Retail Sale Id 4755',750.00,0.00,0.00,1.00,120.00,'2022-12-14 13:50:21','',''),(4718,'1','285','1',1,'Retail Sale Id 4756',1500.00,0.00,0.00,2.00,240.00,'2022-12-14 13:51:08','',''),(4719,'1','285','1',1,'Retail Sale Id 4757',802.50,0.00,0.00,1.07,128.40,'2022-12-14 13:57:13','',''),(4720,'1','285','1',1,'Retail Sale Id 4758',40200.00,0.00,0.00,60.00,2400.00,'2022-12-14 14:32:36','',''),(4721,'1','285','1',1,'Retail Sale Id 4759',997.50,0.00,0.00,1.33,159.60,'2022-12-14 14:35:25','',''),(4722,'1','285','1',1,'Retail Sale Id 4760',1500.00,0.00,0.00,2.00,240.00,'2022-12-14 14:36:41','',''),(4723,'1','285','1',1,'Retail Sale Id 4761',3000.00,0.00,0.00,4.00,480.00,'2022-12-14 14:53:51','',''),(4724,'1','285','1',1,'Retail Sale Id 4762',2002.50,0.00,0.00,2.67,320.40,'2022-12-14 14:58:15','',''),(4725,'1','285','1',1,'Retail Sale Id 4763',2250.00,0.00,0.00,3.00,360.00,'2022-12-14 15:08:11','',''),(4726,'1','285','1',1,'Retail Sale Id 4764',1297.50,0.00,0.00,1.73,207.60,'2022-12-14 15:14:50','',''),(4727,'1','285','1',1,'Retail Sale Id 4765',997.50,0.00,0.00,1.33,159.60,'2022-12-14 15:22:46','',''),(4728,'1','285','1',1,'Retail Sale Id 4766',1500.00,0.00,0.00,2.00,240.00,'2022-12-14 15:37:07','',''),(4729,'1','285','1',1,'Retail Sale Id 4767',1500.00,0.00,0.00,2.00,240.00,'2022-12-14 15:39:44','',''),(4730,'1','285','1',1,'Retail Sale Id 4768',2250.00,0.00,0.00,3.00,360.00,'2022-12-14 15:51:15','',''),(4731,'1','285','1',1,'Retail Sale Id 4769',1500.00,0.00,0.00,2.00,240.00,'2022-12-14 15:55:18','',''),(4732,'1','285','1',1,'Retail Sale Id 4770',19500.00,0.00,0.00,26.00,3120.00,'2022-12-14 15:56:54','',''),(4733,'1','285','1',1,'Retail Sale Id 4771',2250.00,0.00,0.00,3.00,360.00,'2022-12-14 16:04:53','',''),(4734,'1','285','1',1,'Return of Retail Sale Id 4770',0.00,19500.00,26.00,0.00,-3120.00,'2022-12-14 16:06:29','',''),(4735,'1','285','1',1,'Retail Sale Id 4772',17420.00,0.00,0.00,26.00,1040.00,'2022-12-14 16:07:15','',''),(4736,'1','285','1',1,'Retail Sale Id 4773',1500.00,0.00,0.00,2.00,240.00,'2022-12-14 16:08:02','',''),(4737,'1','285','1',1,'Retail Sale Id 4774',49580.00,0.00,0.00,74.00,2960.00,'2022-12-14 16:10:35','',''),(4738,'1','285','1',1,'Retail Sale Id 4776',16321.20,0.00,0.00,24.36,974.40,'2022-12-14 16:13:14','',''),(4739,'1','285','1',1,'Retail Sale Id 4777',1500.00,0.00,0.00,2.00,240.00,'2022-12-14 16:24:43','',''),(4740,'1','285','1',1,'Retail Sale Id 4778',11678.10,0.00,0.00,17.43,697.20,'2022-12-14 16:26:59','',''),(4741,'1','285','1',1,'Retail Sale Id 4779',1500.00,0.00,0.00,2.00,240.00,'2022-12-14 16:31:15','',''),(4742,'1','285','1',1,'Retail Sale Id 4780',4500.00,0.00,0.00,6.00,720.00,'2022-12-14 16:34:59','',''),(4743,'1','285','1',1,'Retail Sale Id 4781',3750.00,0.00,0.00,5.00,600.00,'2022-12-14 16:38:05','',''),(4744,'1','285','1',1,'Retail Sale Id 4782',750.00,0.00,0.00,1.00,120.00,'2022-12-14 16:38:47','',''),(4745,'1','285','1',1,'Retail Sale Id 4783',40200.00,0.00,0.00,60.00,2400.00,'2022-12-14 16:39:40','',''),(4746,'1','285','1',1,'Retail Sale Id 4784',3000.00,0.00,0.00,4.00,480.00,'2022-12-14 16:47:20','',''),(4747,'1','285','1',1,'Retail Sale Id 4785',2497.50,0.00,0.00,3.33,399.60,'2022-12-14 16:52:59','',''),(4748,'1','285','1',1,'Retail Sale Id 4786',32119.80,0.00,0.00,47.94,1917.60,'2022-12-14 16:54:43','',''),(4749,'1','285','1',1,'Retail Sale Id 4787',6000.00,0.00,0.00,8.00,960.00,'2022-12-14 16:55:27','',''),(4750,'1','285','1',1,'Retail Sale Id 4788',1500.00,0.00,0.00,2.00,240.00,'2022-12-14 16:57:42','',''),(4751,'1','285','1',1,'Retail Sale Id 4789',10500.00,0.00,0.00,14.00,1680.00,'2022-12-14 17:02:21','',''),(4752,'1','285','1',1,'Retail Sale Id 4790',40843.20,0.00,0.00,60.96,2438.40,'2022-12-14 17:06:09','',''),(4753,'1','285','1',1,'Retail Sale Id 4791',997.50,0.00,0.00,1.33,159.60,'2022-12-15 07:13:03','',''),(4754,'1','285','1',1,'Retail Sale Id 4792',45479.60,0.00,0.00,67.88,2715.20,'2022-12-15 07:14:45','',''),(4755,'1','285','1',1,'Retail Sale Id 4793',1500.00,0.00,0.00,2.00,240.00,'2022-12-15 07:16:03','',''),(4756,'1','285','1',1,'Retail Sale Id 4794',6000.00,0.00,0.00,8.00,960.00,'2022-12-15 07:26:51','',''),(4757,'1','285','1',1,'Retail Sale Id 4795',1500.00,0.00,0.00,2.00,240.00,'2022-12-15 07:33:55','',''),(4758,'1','285','1',1,'Retail Sale Id 4796',2302.50,0.00,0.00,3.07,368.40,'2022-12-15 07:35:34','',''),(4759,'1','285','1',1,'Retail Sale Id 4797',750.00,0.00,0.00,1.00,120.00,'2022-12-15 07:36:49','',''),(4760,'1','285','1',1,'Retail Sale Id 4798',1500.00,0.00,0.00,2.00,240.00,'2022-12-15 07:37:38','',''),(4761,'1','285','1',1,'Retail Sale Id 4799',3000.00,0.00,0.00,4.00,480.00,'2022-12-15 07:40:33','',''),(4762,'1','285','1',1,'Retail Sale Id 4800',997.50,0.00,0.00,1.33,159.60,'2022-12-15 07:51:07','',''),(4763,'1','285','1',1,'Retail Sale Id 4801',997.50,0.00,0.00,1.33,159.60,'2022-12-15 07:51:48','',''),(4764,'1','285','1',1,'Retail Sale Id 4802',22646.00,0.00,0.00,33.80,1352.00,'2022-12-15 07:56:25','',''),(4765,'1','285','1',1,'Retail Sale Id 4803',40870.00,0.00,0.00,61.00,2440.00,'2022-12-15 08:04:54','',''),(4766,'1','285','1',1,'Retail Sale Id 4804',3000.00,0.00,0.00,4.00,480.00,'2022-12-15 08:08:47','',''),(4767,'1','285','1',1,'Retail Sale Id 4805',40200.00,0.00,0.00,60.00,2400.00,'2022-12-15 08:09:45','',''),(4768,'1','285','1',1,'Retail Sale Id 4806',750.00,0.00,0.00,1.00,120.00,'2022-12-15 08:11:30','',''),(4769,'1','285','1',1,'Retail Sale Id 4807',2250.00,0.00,0.00,3.00,360.00,'2022-12-15 08:12:36','',''),(4770,'1','285','1',1,'Retail Sale Id 4808',802.50,0.00,0.00,1.07,128.40,'2022-12-15 08:14:28','',''),(4771,'1','285','1',1,'Retail Sale Id 4809',997.50,0.00,0.00,1.33,159.60,'2022-12-15 08:15:39','',''),(4772,'1','285','1',1,'Retail Sale Id 4810',41372.50,0.00,0.00,61.75,2470.00,'2022-12-15 08:17:50','',''),(4773,'1','285','1',1,'Retail Sale Id 4811',750.00,0.00,0.00,1.00,120.00,'2022-12-15 08:19:49','',''),(4774,'1','285','1',1,'Retail Sale Id 4812',997.50,0.00,0.00,1.33,159.60,'2022-12-15 08:20:43','',''),(4775,'1','285','1',1,'Retail Sale Id 4813',2250.00,0.00,0.00,3.00,360.00,'2022-12-15 08:26:04','',''),(4776,'1','285','1',1,'Retail Sale Id 4814',1500.00,0.00,0.00,2.00,240.00,'2022-12-15 08:29:10','',''),(4777,'1','285','1',1,'Retail Sale Id 4815',2250.00,0.00,0.00,3.00,360.00,'2022-12-15 08:36:05','',''),(4778,'1','285','1',1,'Retail Sale Id 4816',17701.40,0.00,0.00,26.42,1056.80,'2022-12-15 08:44:32','',''),(4779,'1','285','1',1,'Retail Sale Id 4817',1500.00,0.00,0.00,2.00,240.00,'2022-12-15 08:45:52','',''),(4780,'1','285','1',1,'Retail Sale Id 4819',33500.00,0.00,0.00,50.00,2000.00,'2022-12-15 08:47:00','',''),(4781,'1','285','1',1,'Retail Sale Id 4821',1500.00,0.00,0.00,2.00,240.00,'2022-12-15 08:48:05','',''),(4782,'1','285','1',1,'Retail Sale Id 4822',41077.70,0.00,0.00,61.31,2452.40,'2022-12-15 08:49:16','',''),(4783,'1','285','1',1,'Retail Sale Id 4823',11222.50,0.00,0.00,16.75,670.00,'2022-12-15 08:50:44','',''),(4784,'1','285','1',1,'Retail Sale Id 4824',5250.00,0.00,0.00,7.00,840.00,'2022-12-15 08:56:02','',''),(4785,'1','285','1',1,'Retail Sale Id 4825',7500.00,0.00,0.00,10.00,1200.00,'2022-12-15 08:57:56','',''),(4786,'1','285','1',1,'Retail Sale Id 4826',49513.00,0.00,0.00,73.90,2956.00,'2022-12-15 09:23:48','',''),(4787,'1','285','1',1,'Retail Sale Id 4827',3750.00,0.00,0.00,5.00,600.00,'2022-12-15 09:27:39','',''),(4788,'1','285','1',1,'Retail Sale Id 4828',3000.00,0.00,0.00,4.00,480.00,'2022-12-15 09:31:20','',''),(4789,'1','285','1',1,'Retail Sale Id 4829',2497.50,0.00,0.00,3.33,399.60,'2022-12-15 09:55:13','',''),(4790,'1','285','1',1,'Retail Sale Id 4830',25460.00,0.00,0.00,38.00,1520.00,'2022-12-15 09:56:17','',''),(4791,'1','285','1',1,'Retail Sale Id 4831',1500.00,0.00,0.00,2.00,240.00,'2022-12-15 09:58:25','',''),(4792,'1','285','1',1,'Retail Sale Id 4832',750.00,0.00,0.00,1.00,120.00,'2022-12-15 10:07:23','',''),(4793,'1','285','1',1,'Retail Sale Id 4833',2002.50,0.00,0.00,2.67,320.40,'2022-12-15 10:34:42','',''),(4794,'1','285','1',1,'Retail Sale Id 4835',750.00,0.00,0.00,1.00,120.00,'2022-12-15 11:21:32','',''),(4795,'1','285','1',1,'Retail Sale Id 4836',2250.00,0.00,0.00,3.00,360.00,'2022-12-15 12:24:42','',''),(4796,'1','285','1',1,'Retail Sale Id 4837',42511.50,0.00,0.00,63.45,2538.00,'2022-12-15 12:26:14','',''),(4797,'1','285','1',1,'Retail Sale Id 4838',32347.60,0.00,0.00,48.28,1931.20,'2022-12-15 12:35:40','',''),(4798,'1','285','1',1,'Retail Sale Id 4839',1500.00,0.00,0.00,2.00,240.00,'2022-12-15 12:56:01','',''),(4799,'1','285','1',1,'Retail Sale Id 4840',802.50,0.00,0.00,1.07,128.40,'2022-12-15 12:57:55','',''),(4800,'1','285','1',1,'Retail Sale Id 4841',1500.00,0.00,0.00,2.00,240.00,'2022-12-15 13:10:59','',''),(4801,'1','285','1',1,'Retail Sale Id 4842',2250.00,0.00,0.00,3.00,360.00,'2022-12-15 13:23:52','',''),(4802,'1','285','1',1,'Retail Sale Id 4843',1500.00,0.00,0.00,2.00,240.00,'2022-12-15 13:25:17','',''),(4803,'1','285','1',1,'Retail Sale Id 4844',1500.00,0.00,0.00,2.00,240.00,'2022-12-15 13:27:19','',''),(4804,'1','285','1',1,'Retail Sale Id 4845',1500.00,0.00,0.00,2.00,240.00,'2022-12-15 13:28:23','',''),(4805,'1','285','1',1,'Retail Sale Id 4846',997.50,0.00,0.00,1.33,159.60,'2022-12-15 13:41:59','',''),(4806,'1','285','1',1,'Retail Sale Id 4847',3000.00,0.00,0.00,4.00,480.00,'2022-12-15 13:48:21','',''),(4807,'1','285','1',1,'Retail Sale Id 4848',802.50,0.00,0.00,1.07,128.40,'2022-12-15 13:51:29','',''),(4808,'1','285','1',1,'Retail Sale Id 4849',3000.00,0.00,0.00,4.00,480.00,'2022-12-15 13:52:36','',''),(4809,'1','285','1',1,'Retail Sale Id 4850',3750.00,0.00,0.00,5.00,600.00,'2022-12-15 13:54:01','',''),(4810,'1','285','1',1,'Retail Sale Id 4851',997.50,0.00,0.00,1.33,159.60,'2022-12-15 14:06:22','',''),(4811,'1','285','1',1,'Retail Sale Id 4852',750.00,0.00,0.00,1.00,120.00,'2022-12-15 14:35:25','',''),(4812,'1','285','1',1,'Retail Sale Id 4853',1500.00,0.00,0.00,2.00,240.00,'2022-12-15 14:47:06','',''),(4813,'1','285','1',1,'Retail Sale Id 4854',40849.90,0.00,0.00,60.97,2438.80,'2022-12-15 14:51:32','',''),(4814,'1','285','1',1,'Retail Sale Id 4855',1500.00,0.00,0.00,2.00,240.00,'2022-12-15 14:52:58','',''),(4815,'1','285','1',1,'Retail Sale Id 4856',1500.00,0.00,0.00,2.00,240.00,'2022-12-15 14:59:57','',''),(4816,'1','285','1',1,'Retail Sale Id 4857',44836.40,0.00,0.00,66.92,2676.80,'2022-12-15 15:23:05','',''),(4817,'1','285','1',1,'Retail Sale Id 4858',1500.00,0.00,0.00,2.00,240.00,'2022-12-15 15:42:11','',''),(4818,'1','285','1',1,'Retail Sale Id 4859',37995.70,0.00,0.00,56.71,2268.40,'2022-12-15 15:43:42','',''),(4819,'1','285','1',1,'Retail Sale Id 4860',11684.80,0.00,0.00,17.44,697.60,'2022-12-15 15:47:21','',''),(4820,'1','285','1',1,'Retail Sale Id 4861',78189.00,0.00,0.00,116.70,4668.00,'2022-12-15 16:30:00','',''),(4821,'1','285','1',1,'Retail Sale Id 4862',1500.00,0.00,0.00,2.00,240.00,'2022-12-15 16:31:27','',''),(4822,'1','285','1',1,'Retail Sale Id 4863',997.50,0.00,0.00,1.33,159.60,'2022-12-15 16:35:18','',''),(4823,'1','285','1',1,'Retail Sale Id 4864',6000.00,0.00,0.00,8.00,960.00,'2022-12-15 16:37:45','',''),(4824,'1','285','1',1,'Retail Sale Id 4865',3000.00,0.00,0.00,4.00,480.00,'2022-12-15 16:44:16','',''),(4825,'1','285','1',1,'Retail Sale Id 4866',2152.50,0.00,0.00,2.87,344.40,'2022-12-15 16:48:47','',''),(4826,'1','285','1',1,'Retail Sale Id 4867',9375.00,0.00,0.00,12.50,1500.00,'2022-12-15 16:49:50','',''),(4827,'1','285','1',1,'Retail Sale Id 4868',16636.10,0.00,0.00,24.83,993.20,'2022-12-16 07:30:49','',''),(4828,'1','285','1',1,'Retail Sale Id 4869',40983.90,0.00,0.00,61.17,2446.80,'2022-12-16 07:32:16','',''),(4829,'1','285','1',1,'Retail Sale Id 4870',10500.00,0.00,0.00,14.00,1680.00,'2022-12-16 07:35:09','',''),(4830,'1','285','1',1,'Retail Sale Id 4871',13400.00,0.00,0.00,20.00,800.00,'2022-12-16 07:44:35','',''),(4831,'1','285','1',1,'Retail Sale Id 4872',750.00,0.00,0.00,1.00,120.00,'2022-12-16 07:49:21','',''),(4832,'1','285','1',1,'Retail Sale Id 4873',750.00,0.00,0.00,1.00,120.00,'2022-12-16 07:56:35','',''),(4833,'1','285','1',1,'Retail Sale Id 4874',33500.00,0.00,0.00,50.00,2000.00,'2022-12-16 08:06:03','',''),(4834,'1','285','1',1,'Retail Sale Id 4875',3750.00,0.00,0.00,5.00,600.00,'2022-12-16 08:08:33','',''),(4835,'1','285','1',1,'Retail Sale Id 4876',4500.00,0.00,0.00,6.00,720.00,'2022-12-16 08:13:23','',''),(4836,'1','285','1',1,'Retail Sale Id 4877',40843.20,0.00,0.00,60.96,2438.40,'2022-12-16 08:22:30','',''),(4837,'1','285','1',1,'Retail Sale Id 4878',5250.00,0.00,0.00,7.00,840.00,'2022-12-16 08:33:14','',''),(4838,'1','285','1',1,'Retail Sale Id 4879',1500.00,0.00,0.00,2.00,240.00,'2022-12-16 08:36:40','',''),(4839,'1','285','1',1,'Retail Sale Id 4880',2250.00,0.00,0.00,3.00,360.00,'2022-12-16 08:41:00','',''),(4840,'1','285','1',1,'Retail Sale Id 4881',1500.00,0.00,0.00,2.00,240.00,'2022-12-16 08:42:35','',''),(4841,'1','285','1',1,'Retail Sale Id 4882',2250.00,0.00,0.00,3.00,360.00,'2022-12-16 08:46:18','',''),(4842,'1','285','1',1,'Retail Sale Id 4883',1500.00,0.00,0.00,2.00,240.00,'2022-12-16 08:48:30','',''),(4843,'1','285','1',1,'Retail Sale Id 4884',1500.00,0.00,0.00,2.00,240.00,'2022-12-16 08:50:23','',''),(4844,'1','285','1',1,'Retail Sale Id 4885',2002.50,0.00,0.00,2.67,320.40,'2022-12-16 09:17:51','',''),(4845,'1','285','1',1,'Retail Sale Id 4886',2250.00,0.00,0.00,3.00,360.00,'2022-12-16 09:38:49','',''),(4846,'1','285','1',1,'Retail Sale Id 4887',3000.00,0.00,0.00,4.00,480.00,'2022-12-16 09:44:00','',''),(4847,'1','285','1',1,'Retail Sale Id 4888',2250.00,0.00,0.00,3.00,360.00,'2022-12-16 09:44:41','',''),(4848,'1','285','1',1,'Retail Sale Id 4889',87736.50,0.00,0.00,130.95,5238.00,'2022-12-16 09:52:05','',''),(4849,'1','285','1',1,'Retail Sale Id 4890',1500.00,0.00,0.00,2.00,240.00,'2022-12-16 09:58:22','',''),(4850,'1','285','1',1,'Retail Sale Id 4891',1500.00,0.00,0.00,2.00,240.00,'2022-12-16 10:00:36','',''),(4851,'1','285','1',1,'Retail Sale Id 4892',1500.00,0.00,0.00,2.00,240.00,'2022-12-16 10:01:18','',''),(4852,'1','285','1',1,'Retail Sale Id 4893',1500.00,0.00,0.00,2.00,240.00,'2022-12-16 10:31:15','',''),(4853,'1','285','1',1,'Retail Sale Id 4894',750.00,0.00,0.00,1.00,120.00,'2022-12-16 10:33:19','',''),(4854,'1','285','1',1,'Retail Sale Id 4895',486959.55,0.00,0.00,732.27,25629.45,'2022-12-16 10:35:04','',''),(4855,'1','285','1',1,'Retail Sale Id 4896',1500.00,0.00,0.00,2.00,240.00,'2022-12-16 10:43:38','',''),(4856,'1','285','1',1,'Retail Sale Id 4897',4500.00,0.00,0.00,6.00,720.00,'2022-12-16 10:44:50','',''),(4857,'1','285','1',1,'Retail Sale Id 4898',2250.00,0.00,0.00,3.00,360.00,'2022-12-16 10:53:42','',''),(4858,'1','285','1',1,'Retail Sale Id 4899',2250.00,0.00,0.00,3.00,360.00,'2022-12-16 10:58:46','',''),(4859,'1','285','1',1,'Retail Sale Id 4900',1500.00,0.00,0.00,2.00,240.00,'2022-12-16 11:00:21','',''),(4860,'1','285','1',1,'Retail Sale Id 4901',750.00,0.00,0.00,1.00,120.00,'2022-12-16 11:01:20','',''),(4861,'1','285','1',1,'Retail Sale Id 4902',750.00,0.00,0.00,1.00,120.00,'2022-12-16 11:12:47','',''),(4862,'1','285','1',1,'Retail Sale Id 4903',32434.70,0.00,0.00,48.41,1936.40,'2022-12-16 11:20:50','',''),(4863,'1','285','1',1,'Retail Sale Id 4904',24254.00,0.00,0.00,36.20,1448.00,'2022-12-16 11:26:52','',''),(4864,'1','285','1',1,'Return of Retail Sale Id 4904',0.00,24254.00,36.20,0.00,-1448.00,'2022-12-16 11:33:40','',''),(4865,'1','285','1',1,'Retail Sale Id 4905',24260.70,0.00,0.00,36.21,1448.40,'2022-12-16 11:34:45','',''),(4866,'1','285','1',1,'Retail Sale Id 4906',1500.00,0.00,0.00,2.00,240.00,'2022-12-16 11:37:31','',''),(4867,'1','285','1',1,'Retail Sale Id 4907',45003.90,0.00,0.00,67.17,2686.80,'2022-12-16 11:48:09','',''),(4868,'1','285','1',1,'Retail Sale Id 4908',3000.00,0.00,0.00,4.00,480.00,'2022-12-16 11:58:38','',''),(4869,'1','285','1',1,'Retail Sale Id 4909',40648.90,0.00,0.00,60.67,2426.80,'2022-12-16 12:00:36','',''),(4870,'1','285','1',1,'Return of Retail Sale Id 4907',0.00,45003.90,67.17,0.00,-2686.80,'2022-12-16 12:06:01','',''),(4871,'1','285','1',1,'Retail Sale Id 4910',45191.50,0.00,0.00,67.45,2698.00,'2022-12-16 12:06:54','',''),(4872,'1','285','1',1,'Retail Sale Id 4911',3000.00,0.00,0.00,4.00,480.00,'2022-12-16 12:09:00','',''),(4873,'1','285','1',1,'Retail Sale Id 4912',3000.00,0.00,0.00,4.00,480.00,'2022-12-16 12:19:23','',''),(4874,'1','285','1',1,'Retail Sale Id 4913',3000.00,0.00,0.00,4.00,480.00,'2022-12-16 12:33:18','',''),(4875,'1','285','1',1,'Retail Sale Id 4914',2602.50,0.00,0.00,3.47,416.40,'2022-12-16 12:38:51','',''),(4876,'1','285','1',1,'Retail Sale Id 4915',1500.00,0.00,0.00,2.00,240.00,'2022-12-16 12:43:05','',''),(4877,'1','285','1',1,'Retail Sale Id 4916',1500.00,0.00,0.00,2.00,240.00,'2022-12-16 12:53:12','',''),(4878,'1','285','1',1,'Retail Sale Id 4917',750.00,0.00,0.00,1.00,120.00,'2022-12-16 13:12:22','',''),(4879,'1','285','1',1,'Retail Sale Id 4918',2250.00,0.00,0.00,3.00,360.00,'2022-12-16 13:37:57','',''),(4880,'1','285','1',1,'Retail Sale Id 4919',2250.00,0.00,0.00,3.00,360.00,'2022-12-16 13:46:30','',''),(4881,'1','285','1',1,'Retail Sale Id 4920',9375.00,0.00,0.00,12.50,1500.00,'2022-12-16 13:59:34','',''),(4882,'1','285','1',1,'Retail Sale Id 4921',2002.50,0.00,0.00,2.67,320.40,'2022-12-16 14:11:07','',''),(4883,'1','285','1',1,'Retail Sale Id 4922',1500.00,0.00,0.00,2.00,240.00,'2022-12-16 14:17:17','',''),(4884,'1','285','1',1,'Retail Sale Id 4923',2002.50,0.00,0.00,2.67,320.40,'2022-12-16 14:18:06','',''),(4885,'1','285','1',1,'Retail Sale Id 4924',2250.00,0.00,0.00,3.00,360.00,'2022-12-16 14:35:16','',''),(4886,'1','285','1',1,'Retail Sale Id 4925',750.00,0.00,0.00,1.00,120.00,'2022-12-16 14:42:56','',''),(4887,'1','285','1',1,'Retail Sale Id 4926',41540.00,0.00,0.00,62.00,2480.00,'2022-12-16 15:02:18','',''),(4888,'1','285','1',1,'Retail Sale Id 4927',2250.00,0.00,0.00,3.00,360.00,'2022-12-16 15:11:37','',''),(4889,'1','285','1',1,'Retail Sale Id 4928',5250.00,0.00,0.00,7.00,840.00,'2022-12-16 15:15:02','',''),(4890,'1','285','1',1,'Retail Sale Id 4929',1500.00,0.00,0.00,2.00,240.00,'2022-12-16 15:25:11','',''),(4891,'1','285','1',1,'Retail Sale Id 4930',1500.00,0.00,0.00,2.00,240.00,'2022-12-16 15:29:41','',''),(4892,'1','285','1',1,'Retail Sale Id 4931',2250.00,0.00,0.00,3.00,360.00,'2022-12-16 15:34:50','',''),(4893,'1','285','1',1,'Retail Sale Id 4932',26800.00,0.00,0.00,40.00,1600.00,'2022-12-16 15:48:25','',''),(4894,'1','285','1',1,'Retail Sale Id 4934',7500.00,0.00,0.00,10.00,1200.00,'2022-12-16 15:56:03','',''),(4895,'1','285','1',1,'Retail Sale Id 4935',3000.00,0.00,0.00,4.00,480.00,'2022-12-16 16:08:29','',''),(4896,'1','285','1',1,'Retail Sale Id 4936',36850.00,0.00,0.00,55.00,2200.00,'2022-12-16 16:12:10','',''),(4897,'1','285','1',1,'Retail Sale Id 4937',3750.00,0.00,0.00,5.00,600.00,'2022-12-16 16:17:56','',''),(4898,'1','285','1',1,'Retail Sale Id 4938',4500.00,0.00,0.00,6.00,720.00,'2022-12-16 16:19:35','',''),(4899,'1','285','1',1,'Retail Sale Id 4939',11390.00,0.00,0.00,17.00,680.00,'2022-12-16 16:22:17','',''),(4900,'1','285','1',1,'Retail Sale Id 4940',10500.00,0.00,0.00,14.00,1680.00,'2022-12-16 16:24:05','',''),(4901,'1','285','1',1,'Retail Sale Id 4941',1500.00,0.00,0.00,2.00,240.00,'2022-12-16 16:28:40','',''),(4902,'1','285','1',1,'Retail Sale Id 4942',2499.10,0.00,0.00,3.73,149.20,'2022-12-16 16:29:45','',''),(4903,'1','285','1',1,'Retail Sale Id 4943',1500.00,0.00,0.00,2.00,240.00,'2022-12-16 16:34:35','',''),(4904,'1','285','1',1,'Retail Sale Id 4944',40602.00,0.00,0.00,60.60,2424.00,'2022-12-16 16:39:52','',''),(4905,'1','285','1',1,'Retail Sale Id 4945',997.50,0.00,0.00,1.33,159.60,'2022-12-16 16:41:48','',''),(4906,'1','285','1',1,'Retail Sale Id 4946',1500.00,0.00,0.00,2.00,240.00,'2022-12-16 16:42:34','',''),(4907,'1','285','1',1,'Retail Sale Id 4948',802.50,0.00,0.00,1.07,128.40,'2022-12-16 16:43:55','',''),(4908,'1','285','1',1,'Retail Sale Id 4949',2250.00,0.00,0.00,3.00,360.00,'2022-12-16 16:48:03','',''),(4909,'1','285','1',1,'Retail Sale Id 4950',750.00,0.00,0.00,1.00,120.00,'2022-12-16 16:54:21','',''),(4910,'1','285','1',1,'Retail Sale Id 4951',5250.00,0.00,0.00,7.00,840.00,'2022-12-16 16:55:55','',''),(4911,'1','285','1',1,'Retail Sale Id 4952',25902.20,0.00,0.00,38.66,1546.40,'2022-12-16 16:59:27','',''),(4912,'1','285','1',1,'Retail Sale Id 4953',5002.50,0.00,0.00,6.67,800.40,'2022-12-16 17:01:56','',''),(4913,'1','285','1',1,'Retail Sale Id 4954',1500.00,0.00,0.00,2.00,240.00,'2022-12-16 17:06:22','',''),(4914,'1','285','1',1,'Retail Sale Id 4955',1695.10,0.00,0.00,2.53,101.20,'2022-12-16 19:17:21','',''),(4915,'1','285','1',1,'Return of Retail Sale Id 4950',0.00,750.00,1.00,0.00,-120.00,'2022-12-16 19:18:30','',''),(4916,'1','285','1',1,'Retail Sale Id 4956',375.00,0.00,0.00,0.50,60.00,'2022-12-16 19:19:53','',''),(4917,'1','285','1',1,'Retail Sale Id 4957',48286.90,0.00,0.00,72.07,2882.80,'2022-12-17 07:16:32','',''),(4918,'1','285','1',1,'Retail Sale Id 4958',997.50,0.00,0.00,1.33,159.60,'2022-12-17 07:17:27','',''),(4919,'1','285','1',1,'Retail Sale Id 4960',15410.00,0.00,0.00,23.00,920.00,'2022-12-17 07:23:18','',''),(4920,'1','285','1',1,'Retail Sale Id 4961',2250.00,0.00,0.00,3.00,360.00,'2022-12-17 07:24:25','',''),(4921,'1','285','1',1,'Retail Sale Id 4962',41412.70,0.00,0.00,61.81,2472.40,'2022-12-17 07:25:10','',''),(4922,'1','285','1',1,'Retail Sale Id 4963',3000.00,0.00,0.00,4.00,480.00,'2022-12-17 07:29:21','',''),(4923,'1','285','1',1,'Retail Sale Id 4964',802.50,0.00,0.00,1.07,128.40,'2022-12-17 07:33:46','',''),(4924,'1','285','1',1,'Retail Sale Id 4965',1500.00,0.00,0.00,2.00,240.00,'2022-12-17 07:34:40','',''),(4925,'1','285','1',1,'Retail Sale Id 4966',1500.00,0.00,0.00,2.00,240.00,'2022-12-17 07:36:06','',''),(4926,'1','285','1',1,'Retail Sale Id 4967',3000.00,0.00,0.00,4.00,480.00,'2022-12-17 07:38:50','',''),(4927,'1','285','1',1,'Retail Sale Id 4968',32588.80,0.00,0.00,48.64,1945.60,'2022-12-17 07:46:46','',''),(4928,'1','285','1',1,'Retail Sale Id 4969',45211.60,0.00,0.00,67.48,2699.20,'2022-12-17 07:50:11','',''),(4929,'1','285','1',1,'Retail Sale Id 4970',40200.00,0.00,0.00,60.00,2400.00,'2022-12-17 08:00:11','',''),(4930,'1','285','1',1,'Retail Sale Id 4971',750.00,0.00,0.00,1.00,120.00,'2022-12-17 08:01:15','',''),(4931,'1','285','1',1,'Retail Sale Id 4973',22500.00,0.00,0.00,30.00,3600.00,'2022-12-17 08:04:41','',''),(4932,'1','285','1',1,'Retail Sale Id 4974',40200.00,0.00,0.00,60.00,2400.00,'2022-12-17 08:09:41','',''),(4933,'1','285','1',1,'Retail Sale Id 4975',40870.00,0.00,0.00,61.00,2440.00,'2022-12-17 08:13:50','',''),(4934,'1','285','1',1,'Retail Sale Id 4976',750.00,0.00,0.00,1.00,120.00,'2022-12-17 08:20:53','',''),(4935,'1','285','1',1,'Retail Sale Id 4977',997.50,0.00,0.00,1.33,159.60,'2022-12-17 08:22:26','',''),(4936,'1','285','1',1,'Retail Sale Id 4978',2002.50,0.00,0.00,2.67,320.40,'2022-12-17 08:29:47','',''),(4937,'1','285','1',1,'Retail Sale Id 4979',3000.00,0.00,0.00,4.00,480.00,'2022-12-17 08:33:43','',''),(4938,'1','285','1',1,'Retail Sale Id 4981',2497.50,0.00,0.00,3.33,399.60,'2022-12-17 08:35:04','',''),(4939,'1','285','1',1,'Retail Sale Id 4982',1500.00,0.00,0.00,2.00,240.00,'2022-12-17 08:45:36','',''),(4940,'1','285','1',1,'Retail Sale Id 4983',41540.00,0.00,0.00,62.00,2480.00,'2022-12-17 08:49:16','',''),(4941,'1','285','1',1,'Retail Sale Id 4984',997.50,0.00,0.00,1.33,159.60,'2022-12-17 08:57:14','',''),(4942,'1','285','1',1,'Retail Sale Id 4985',6750.00,0.00,0.00,9.00,1080.00,'2022-12-17 09:06:17','',''),(4943,'1','285','1',1,'Retail Sale Id 4986',2250.00,0.00,0.00,3.00,360.00,'2022-12-17 09:08:28','',''),(4944,'1','285','1',1,'Retail Sale Id 4987',3000.00,0.00,0.00,4.00,480.00,'2022-12-17 09:22:02','',''),(4945,'1','285','1',1,'Retail Sale Id 4988',3000.00,0.00,0.00,4.00,480.00,'2022-12-17 09:34:57','',''),(4946,'1','285','1',1,'Retail Sale Id 4989',802.50,0.00,0.00,1.07,128.40,'2022-12-17 09:38:45','',''),(4947,'1','285','1',1,'Retail Sale Id 4990',802.50,0.00,0.00,1.07,128.40,'2022-12-17 09:49:40','',''),(4948,'1','285','1',1,'Retail Sale Id 4991',14740.00,0.00,0.00,22.00,880.00,'2022-12-17 10:01:26','',''),(4949,'1','285','1',1,'Retail Sale Id 4992',38994.00,0.00,0.00,58.20,2328.00,'2022-12-17 10:04:06','',''),(4950,'1','285','1',1,'Return of Retail Sale Id 4992',0.00,38994.00,58.20,0.00,-2328.00,'2022-12-17 10:12:01','',''),(4951,'1','285','1',1,'Retail Sale Id 4993',5494.00,0.00,0.00,8.20,328.00,'2022-12-17 10:14:03','',''),(4952,'1','285','1',1,'Retail Sale Id 4994',4500.00,0.00,0.00,6.00,720.00,'2022-12-17 10:16:09','',''),(4953,'1','285','1',1,'Retail Sale Id 4995',4500.00,0.00,0.00,6.00,720.00,'2022-12-17 10:25:41','',''),(4954,'1','285','1',1,'Retail Sale Id 4996',997.50,0.00,0.00,1.33,159.60,'2022-12-17 10:30:01','',''),(4955,'1','285','1',1,'Retail Sale Id 4997',4500.00,0.00,0.00,6.00,720.00,'2022-12-17 10:35:20','',''),(4956,'1','285','1',1,'Retail Sale Id 4998',40200.00,0.00,0.00,60.00,2400.00,'2022-12-17 10:44:36','',''),(4957,'1','285','1',1,'Retail Sale Id 4999',41292.10,0.00,0.00,61.63,2465.20,'2022-12-17 10:46:47','',''),(4958,'1','285','1',1,'Retail Sale Id 5000',3997.50,0.00,0.00,5.33,639.60,'2022-12-17 10:50:16','',''),(4959,'1','285','1',1,'Retail Sale Id 5001',16542.30,0.00,0.00,24.69,987.60,'2022-12-17 10:51:36','',''),(4960,'1','285','1',1,'Return of Retail Sale Id 5001',0.00,16542.30,24.69,0.00,-987.60,'2022-12-17 10:53:25','',''),(4961,'1','285','1',1,'Retail Sale Id 5002',16475.30,0.00,0.00,24.59,983.60,'2022-12-17 10:54:14','',''),(4962,'1','285','1',1,'Retail Sale Id 5003',802.50,0.00,0.00,1.07,128.40,'2022-12-17 10:55:46','',''),(4963,'1','285','1',1,'Retail Sale Id 5005',2302.50,0.00,0.00,3.07,368.40,'2022-12-17 11:06:06','',''),(4964,'1','285','1',1,'Retail Sale Id 5006',1500.00,0.00,0.00,2.00,240.00,'2022-12-17 11:07:26','',''),(4965,'1','285','1',1,'Retail Sale Id 5007',750.00,0.00,0.00,1.00,120.00,'2022-12-17 11:08:43','',''),(4966,'1','285','1',1,'Retail Sale Id 5008',3750.00,0.00,0.00,5.00,600.00,'2022-12-17 11:25:14','',''),(4967,'1','285','1',1,'Retail Sale Id 5009',3000.00,0.00,0.00,4.00,480.00,'2022-12-17 11:26:18','',''),(4968,'1','285','1',1,'Retail Sale Id 5010',1500.00,0.00,0.00,2.00,240.00,'2022-12-17 11:33:15','',''),(4969,'1','285','1',1,'Retail Sale Id 5011',4500.00,0.00,0.00,6.00,720.00,'2022-12-17 11:51:55','',''),(4970,'1','285','1',1,'Retail Sale Id 5012',2497.50,0.00,0.00,3.33,399.60,'2022-12-17 11:56:32','',''),(4971,'1','285','1',1,'Retail Sale Id 5013',750.00,0.00,0.00,1.00,120.00,'2022-12-17 11:59:45','',''),(4972,'1','285','1',1,'Retail Sale Id 5014',6000.00,0.00,0.00,8.00,960.00,'2022-12-17 12:03:52','',''),(4973,'1','285','1',1,'Retail Sale Id 5015',997.50,0.00,0.00,1.33,159.60,'2022-12-17 12:05:53','',''),(4974,'1','285','1',1,'Retail Sale Id 5016',5250.00,0.00,0.00,7.00,840.00,'2022-12-17 12:14:23','',''),(4975,'1','285','1',1,'Retail Sale Id 5017',2250.00,0.00,0.00,3.00,360.00,'2022-12-17 12:21:25','',''),(4976,'1','285','1',1,'Retail Sale Id 5018',2250.00,0.00,0.00,3.00,360.00,'2022-12-17 12:53:51','',''),(4977,'1','285','1',1,'Retail Sale Id 5019',3000.00,0.00,0.00,4.00,480.00,'2022-12-17 13:00:45','',''),(4978,'1','285','1',1,'Retail Sale Id 5020',11390.00,0.00,0.00,17.00,680.00,'2022-12-17 13:03:03','',''),(4979,'1','285','1',1,'Retail Sale Id 5021',3000.00,0.00,0.00,4.00,480.00,'2022-12-17 13:05:18','',''),(4980,'1','285','1',1,'Retail Sale Id 5022',2302.50,0.00,0.00,3.07,368.40,'2022-12-17 13:10:17','',''),(4981,'1','285','1',1,'Retail Sale Id 5023',2302.50,0.00,0.00,3.07,368.40,'2022-12-17 13:11:32','',''),(4982,'1','285','1',1,'Retail Sale Id 5024',802.50,0.00,0.00,1.07,128.40,'2022-12-17 13:14:38','',''),(4983,'1','285','1',1,'Retail Sale Id 5025',802.50,0.00,0.00,1.07,128.40,'2022-12-17 13:15:39','',''),(4984,'1','285','1',1,'Retail Sale Id 5026',1500.00,0.00,0.00,2.00,240.00,'2022-12-17 13:16:34','',''),(4985,'1','285','1',1,'Retail Sale Id 5027',3750.00,0.00,0.00,5.00,600.00,'2022-12-17 13:19:33','',''),(4986,'1','285','1',1,'Retail Sale Id 5028',3000.00,0.00,0.00,4.00,480.00,'2022-12-17 13:21:28','',''),(4987,'1','285','1',1,'Retail Sale Id 5029',6000.00,0.00,0.00,8.00,960.00,'2022-12-17 13:22:38','',''),(4988,'1','285','1',1,'Retail Sale Id 5030',7500.00,0.00,0.00,10.00,1200.00,'2022-12-17 13:29:02','',''),(4989,'1','285','1',1,'Retail Sale Id 5031',41365.80,0.00,0.00,61.74,2469.60,'2022-12-17 13:38:34','',''),(4990,'1','285','1',1,'Retail Sale Id 5032',2250.00,0.00,0.00,3.00,360.00,'2022-12-17 13:42:17','',''),(4991,'1','285','1',1,'Retail Sale Id 5033',750.00,0.00,0.00,1.00,120.00,'2022-12-17 13:43:14','',''),(4992,'1','285','1',1,'Retail Sale Id 5034',40200.00,0.00,0.00,60.00,2400.00,'2022-12-17 13:49:19','',''),(4993,'1','285','1',1,'Retail Sale Id 5035',2002.50,0.00,0.00,2.67,320.40,'2022-12-17 13:56:59','',''),(4994,'1','285','1',1,'Retail Sale Id 5036',12240.90,0.00,0.00,18.27,730.80,'2022-12-17 14:06:38','',''),(4995,'1','285','1',1,'Retail Sale Id 5037',7500.00,0.00,0.00,10.00,1200.00,'2022-12-17 14:10:52','',''),(4996,'1','285','1',1,'Retail Sale Id 5039',3000.00,0.00,0.00,4.00,480.00,'2022-12-17 14:20:41','',''),(4997,'1','285','1',1,'Retail Sale Id 5040',1500.00,0.00,0.00,2.00,240.00,'2022-12-17 14:24:31','',''),(4998,'1','285','1',1,'Retail Sale Id 5041',3000.00,0.00,0.00,4.00,480.00,'2022-12-17 14:33:39','',''),(4999,'1','285','1',1,'Retail Sale Id 5042',1500.00,0.00,0.00,2.00,240.00,'2022-12-17 14:53:08','',''),(5000,'1','285','1',1,'Retail Sale Id 5043',1500.00,0.00,0.00,2.00,240.00,'2022-12-17 14:54:37','',''),(5001,'1','285','1',1,'Retail Sale Id 5044',802.50,0.00,0.00,1.07,128.40,'2022-12-17 15:05:50','',''),(5002,'1','285','1',1,'Retail Sale Id 5045',997.50,0.00,0.00,1.33,159.60,'2022-12-17 15:12:01','',''),(5003,'1','285','1',1,'Retail Sale Id 5046',8250.00,0.00,0.00,11.00,1320.00,'2022-12-17 15:12:59','',''),(5004,'1','285','1',1,'Retail Sale Id 5047',1500.00,0.00,0.00,2.00,240.00,'2022-12-17 15:14:05','',''),(5005,'1','285','1',1,'Retail Sale Id 5048',802.50,0.00,0.00,1.07,128.40,'2022-12-17 15:17:40','',''),(5006,'1','285','1',1,'Retail Sale Id 5049',3000.00,0.00,0.00,4.00,480.00,'2022-12-17 15:19:36','',''),(5007,'1','285','1',1,'Retail Sale Id 5050',1500.00,0.00,0.00,2.00,240.00,'2022-12-17 15:20:40','',''),(5008,'1','285','1',1,'Retail Sale Id 5051',1500.00,0.00,0.00,2.00,240.00,'2022-12-17 15:23:02','',''),(5009,'1','285','1',1,'Retail Sale Id 5052',35523.40,0.00,0.00,53.02,2120.80,'2022-12-17 15:30:15','',''),(5010,'1','285','1',1,'Retail Sale Id 5053',1500.00,0.00,0.00,2.00,240.00,'2022-12-17 15:35:19','',''),(5011,'1','285','1',1,'Retail Sale Id 5054',4500.00,0.00,0.00,6.00,720.00,'2022-12-17 15:49:01','',''),(5012,'1','285','1',1,'Retail Sale Id 5055',2250.00,0.00,0.00,3.00,360.00,'2022-12-17 15:50:50','',''),(5013,'1','285','1',1,'Retail Sale Id 5056',1500.00,0.00,0.00,2.00,240.00,'2022-12-17 15:51:55','',''),(5014,'1','285','1',1,'Retail Sale Id 5057',997.50,0.00,0.00,1.33,159.60,'2022-12-17 15:52:38','',''),(5015,'1','285','1',1,'Retail Sale Id 5058',5250.00,0.00,0.00,7.00,840.00,'2022-12-17 15:53:35','',''),(5016,'1','285','1',1,'Retail Sale Id 5059',3000.00,0.00,0.00,4.00,480.00,'2022-12-17 16:15:57','',''),(5017,'1','285','1',1,'Retail Sale Id 5060',77050.00,0.00,0.00,115.00,4600.00,'2022-12-17 16:17:07','',''),(5018,'1','285','1',1,'Retail Sale Id 5061',2250.00,0.00,0.00,3.00,360.00,'2022-12-17 16:18:06','',''),(5019,'1','285','1',1,'Retail Sale Id 5062',2250.00,0.00,0.00,3.00,360.00,'2022-12-17 16:18:51','',''),(5020,'1','285','1',1,'Retail Sale Id 5063',5250.00,0.00,0.00,7.00,840.00,'2022-12-17 16:27:57','',''),(5021,'1','285','1',1,'Retail Sale Id 5064',750.00,0.00,0.00,1.00,120.00,'2022-12-17 16:29:43','',''),(5022,'1','285','1',1,'Retail Sale Id 5065',2250.00,0.00,0.00,3.00,360.00,'2022-12-17 16:31:00','',''),(5023,'1','285','1',1,'Retail Sale Id 5066',3000.00,0.00,0.00,4.00,480.00,'2022-12-17 16:34:02','',''),(5024,'1','285','1',1,'Retail Sale Id 5067',39992.30,0.00,0.00,59.69,2387.60,'2022-12-17 16:36:59','',''),(5025,'1','285','1',1,'Retail Sale Id 5068',5250.00,0.00,0.00,7.00,840.00,'2022-12-17 16:39:04','',''),(5026,'1','285','1',1,'Retail Sale Id 5069',2250.00,0.00,0.00,3.00,360.00,'2022-12-17 16:48:43','',''),(5027,'1','285','1',1,'Retail Sale Id 5070',33500.00,0.00,0.00,50.00,2000.00,'2022-12-17 16:52:28','',''),(5028,'1','285','1',1,'Retail Sale Id 5071',2002.50,0.00,0.00,2.67,320.40,'2022-12-17 16:55:46','',''),(5029,'1','285','1',1,'Retail Sale Id 5072',41439.50,0.00,0.00,61.85,2474.00,'2022-12-18 07:09:27','',''),(5030,'1','285','1',1,'Retail Sale Id 5073',3750.00,0.00,0.00,5.00,600.00,'2022-12-18 07:11:16','',''),(5031,'1','285','1',1,'Retail Sale Id 5074',48307.00,0.00,0.00,72.10,2884.00,'2022-12-18 07:12:20','',''),(5032,'1','285','1',1,'Retail Sale Id 5075',1500.00,0.00,0.00,2.00,240.00,'2022-12-18 07:15:13','',''),(5033,'1','285','1',1,'Retail Sale Id 5076',4500.00,0.00,0.00,6.00,720.00,'2022-12-18 07:24:34','',''),(5034,'1','285','1',1,'Retail Sale Id 5077',16636.10,0.00,0.00,24.83,993.20,'2022-12-18 07:25:45','',''),(5035,'1','285','1',1,'Retail Sale Id 5078',997.50,0.00,0.00,1.33,159.60,'2022-12-18 07:27:03','',''),(5036,'1','285','1',1,'Retail Sale Id 5079',2250.00,0.00,0.00,3.00,360.00,'2022-12-18 07:27:59','',''),(5037,'1','285','1',1,'Retail Sale Id 5080',750.00,0.00,0.00,1.00,120.00,'2022-12-18 07:38:38','',''),(5038,'1','285','1',1,'Retail Sale Id 5081',2250.00,0.00,0.00,3.00,360.00,'2022-12-18 07:47:45','',''),(5039,'1','285','1',1,'Retail Sale Id 5082',1500.00,0.00,0.00,2.00,240.00,'2022-12-18 08:06:34','',''),(5040,'1','285','1',1,'Retail Sale Id 5083',1500.00,0.00,0.00,2.00,240.00,'2022-12-18 08:07:16','',''),(5041,'1','285','1',1,'Retail Sale Id 5084',11959.50,0.00,0.00,17.85,714.00,'2022-12-18 08:11:11','',''),(5042,'1','285','1',1,'Retail Sale Id 5085',1500.00,0.00,0.00,2.00,240.00,'2022-12-18 08:16:57','',''),(5043,'1','285','1',1,'Retail Sale Id 5086',1500.00,0.00,0.00,2.00,240.00,'2022-12-18 08:17:42','',''),(5044,'1','285','1',1,'Retail Sale Id 5087',2250.00,0.00,0.00,3.00,360.00,'2022-12-18 08:27:48','',''),(5045,'1','285','1',1,'Retail Sale Id 5088',802.50,0.00,0.00,1.07,128.40,'2022-12-18 08:28:53','',''),(5046,'1','285','1',1,'Retail Sale Id 5089',2250.00,0.00,0.00,3.00,360.00,'2022-12-18 08:30:14','',''),(5047,'1','285','1',1,'Retail Sale Id 5090',2250.00,0.00,0.00,3.00,360.00,'2022-12-18 08:34:35','',''),(5048,'1','285','1',1,'Retail Sale Id 5091',2002.50,0.00,0.00,2.67,320.40,'2022-12-18 08:35:36','',''),(5049,'1','285','1',1,'Retail Sale Id 5092',41412.70,0.00,0.00,61.81,2472.40,'2022-12-18 08:37:57','',''),(5050,'1','285','1',1,'Retail Sale Id 5093',1500.00,0.00,0.00,2.00,240.00,'2022-12-18 08:49:39','',''),(5051,'1','285','1',1,'Retail Sale Id 5094',750.00,0.00,0.00,1.00,120.00,'2022-12-18 08:57:55','',''),(5052,'1','285','1',1,'Retail Sale Id 5095',802.50,0.00,0.00,1.07,128.40,'2022-12-18 09:02:55','',''),(5053,'1','285','1',1,'Retail Sale Id 5096',750.00,0.00,0.00,1.00,120.00,'2022-12-18 09:18:14','',''),(5054,'1','285','1',1,'Retail Sale Id 5097',1500.00,0.00,0.00,2.00,240.00,'2022-12-18 09:21:09','',''),(5055,'1','285','1',1,'Retail Sale Id 5098',18090.00,0.00,0.00,27.00,1080.00,'2022-12-18 09:42:37','',''),(5056,'1','285','1',1,'Retail Sale Id 5099',40200.00,0.00,0.00,60.00,2400.00,'2022-12-18 09:48:25','',''),(5057,'1','285','1',1,'Retail Sale Id 5100',2625.00,0.00,0.00,3.50,420.00,'2022-12-18 09:49:01','',''),(5058,'1','285','1',1,'Retail Sale Id 5101',1500.00,0.00,0.00,2.00,240.00,'2022-12-18 09:51:08','',''),(5059,'1','285','1',1,'Retail Sale Id 5102',1500.00,0.00,0.00,2.00,240.00,'2022-12-18 10:01:13','',''),(5060,'1','285','1',1,'Retail Sale Id 5103',997.50,0.00,0.00,1.33,159.60,'2022-12-18 10:02:51','',''),(5061,'1','285','1',1,'Retail Sale Id 5104',1500.00,0.00,0.00,2.00,240.00,'2022-12-18 10:03:51','',''),(5062,'1','285','1',1,'Retail Sale Id 5105',750.00,0.00,0.00,1.00,120.00,'2022-12-18 10:21:07','',''),(5063,'1','285','1',1,'Retail Sale Id 5106',750.00,0.00,0.00,1.00,120.00,'2022-12-18 10:28:27','',''),(5064,'1','285','1',1,'Retail Sale Id 5107',4500.00,0.00,0.00,6.00,720.00,'2022-12-18 10:45:22','',''),(5065,'1','285','1',1,'Retail Sale Id 5108',15750.00,0.00,0.00,21.00,2520.00,'2022-12-18 10:57:17','',''),(5066,'1','285','1',1,'Retail Sale Id 5109',13500.00,0.00,0.00,18.00,2160.00,'2022-12-18 11:11:07','',''),(5067,'1','285','1',1,'Return of Retail Sale Id 5108',0.00,15750.00,21.00,0.00,-2520.00,'2022-12-18 11:11:46','',''),(5068,'1','285','1',1,'Retail Sale Id 5110',750.00,0.00,0.00,1.00,120.00,'2022-12-18 11:20:39','',''),(5069,'1','285','1',1,'Retail Sale Id 5111',9375.00,0.00,0.00,12.50,1500.00,'2022-12-18 11:56:41','',''),(5070,'1','285','1',1,'Retail Sale Id 5112',46900.00,0.00,0.00,70.00,2800.00,'2022-12-18 11:57:42','',''),(5071,'1','285','1',1,'Retail Sale Id 5113',1500.00,0.00,0.00,2.00,240.00,'2022-12-18 11:59:31','',''),(5072,'1','285','1',1,'Return of Retail Sale Id 5076',0.00,4500.00,6.00,0.00,-720.00,'2022-12-18 12:05:48','',''),(5073,'1','285','1',1,'Retail Sale Id 5114',1500.00,0.00,0.00,2.00,240.00,'2022-12-18 12:19:12','',''),(5074,'1','285','1',1,'Retail Sale Id 5115',1500.00,0.00,0.00,2.00,240.00,'2022-12-18 12:23:20','',''),(5075,'1','285','1',1,'Retail Sale Id 5116',1500.00,0.00,0.00,2.00,240.00,'2022-12-18 12:31:15','',''),(5076,'1','285','1',1,'Retail Sale Id 5117',997.50,0.00,0.00,1.33,159.60,'2022-12-18 12:32:36','',''),(5077,'1','285','1',1,'Retail Sale Id 5118',53285.10,0.00,0.00,79.53,3181.20,'2022-12-18 13:01:12','',''),(5078,'1','285','1',1,'Retail Sale Id 5119',1500.00,0.00,0.00,2.00,240.00,'2022-12-18 13:19:13','',''),(5079,'1','285','1',1,'Retail Sale Id 5120',1500.00,0.00,0.00,2.00,240.00,'2022-12-18 13:26:53','',''),(5080,'1','285','1',1,'Retail Sale Id 5121',3750.00,0.00,0.00,5.00,600.00,'2022-12-18 13:49:37','',''),(5081,'1','285','1',1,'Retail Sale Id 5122',1500.00,0.00,0.00,2.00,240.00,'2022-12-18 13:50:54','',''),(5082,'1','285','1',1,'Retail Sale Id 5123',2002.50,0.00,0.00,2.67,320.40,'2022-12-18 13:51:59','',''),(5083,'1','285','1',1,'Retail Sale Id 5124',12033.20,0.00,0.00,17.96,718.40,'2022-12-18 13:53:00','',''),(5084,'1','285','1',1,'Retail Sale Id 5125',1500.00,0.00,0.00,2.00,240.00,'2022-12-18 13:59:14','',''),(5085,'1','285','1',1,'Retail Sale Id 5126',1500.00,0.00,0.00,2.00,240.00,'2022-12-18 14:30:46','',''),(5086,'1','285','1',1,'Retail Sale Id 5127',1500.00,0.00,0.00,2.00,240.00,'2022-12-18 14:31:43','',''),(5087,'1','285','1',1,'Retail Sale Id 5128',802.50,0.00,0.00,1.07,128.40,'2022-12-18 14:48:09','',''),(5088,'1','285','1',1,'Retail Sale Id 5129',750.00,0.00,0.00,1.00,120.00,'2022-12-18 15:06:38','',''),(5089,'1','285','1',1,'Retail Sale Id 5130',74014.90,0.00,0.00,110.47,4418.80,'2022-12-18 15:10:18','',''),(5090,'1','285','1',1,'Retail Sale Id 5131',1500.00,0.00,0.00,2.00,240.00,'2022-12-18 15:18:11','',''),(5091,'1','285','1',1,'Retail Sale Id 5132',997.50,0.00,0.00,1.33,159.60,'2022-12-18 15:18:59','',''),(5092,'1','285','1',1,'Retail Sale Id 5133',1340.00,0.00,0.00,2.00,80.00,'2022-12-18 15:25:47','',''),(5093,'1','285','1',1,'Retail Sale Id 5134',54249.90,0.00,0.00,80.97,3238.80,'2022-12-18 15:27:43','',''),(5094,'1','285','1',1,'Retail Sale Id 5135',1500.00,0.00,0.00,2.00,240.00,'2022-12-18 15:53:17','',''),(5095,'1','285','1',1,'Retail Sale Id 5136',1500.00,0.00,0.00,2.00,240.00,'2022-12-18 15:55:19','',''),(5096,'1','285','1',1,'Retail Sale Id 5137',2250.00,0.00,0.00,3.00,360.00,'2022-12-18 16:04:38','',''),(5097,'1','285','1',1,'Retail Sale Id 5138',1500.00,0.00,0.00,2.00,240.00,'2022-12-18 16:08:30','',''),(5098,'1','285','1',1,'Retail Sale Id 5139',1500.00,0.00,0.00,2.00,240.00,'2022-12-18 16:09:41','',''),(5099,'1','285','1',1,'Retail Sale Id 5140',34840.00,0.00,0.00,52.00,2080.00,'2022-12-18 16:26:37','',''),(5100,'1','285','1',1,'Retail Sale Id 5141',3000.00,0.00,0.00,4.00,480.00,'2022-12-18 16:27:18','',''),(5101,'1','285','1',1,'Retail Sale Id 5142',34558.60,0.00,0.00,51.58,2063.20,'2022-12-18 16:38:31','',''),(5102,'1','285','1',1,'Return of Retail Sale Id 5140',0.00,34840.00,52.00,0.00,-2080.00,'2022-12-18 16:40:04','',''),(5103,'1','285','1',1,'Retail Sale Id 5143',9750.00,0.00,0.00,13.00,1560.00,'2022-12-18 16:40:34','',''),(5104,'1','285','1',1,'Return of Retail Sale Id 5143',0.00,9750.00,13.00,0.00,-1560.00,'2022-12-18 16:43:08','',''),(5105,'1','285','1',1,'Retail Sale Id 5144',25058.00,0.00,0.00,37.40,1496.00,'2022-12-18 16:46:52','',''),(5106,'1','285','1',1,'Retail Sale Id 5145',16361.40,0.00,0.00,24.42,976.80,'2022-12-18 16:49:41','',''),(5107,'1','285','1',1,'Retail Sale Id 5146',39530.00,0.00,0.00,59.00,2360.00,'2022-12-18 17:02:10','',''),(5108,'1','285','1',1,'Retail Sale Id 5147',4500.00,0.00,0.00,6.00,720.00,'2022-12-18 17:03:34','',''),(5109,'1','285','1',1,'Retail Sale Id 5148',1500.00,0.00,0.00,2.00,240.00,'2022-12-18 17:04:19','',''),(5110,'1','285','1',1,'Retail Sale Id 5149',1500.00,0.00,0.00,2.00,240.00,'2022-12-18 17:08:38','',''),(5111,'1','285','1',1,'Return of Retail Sale Id 5121',0.00,3750.00,5.00,0.00,-600.00,'2022-12-18 17:30:53','',''),(5112,'1','285','1',1,'Retail Sale Id 5150',780.00,0.00,0.00,1.04,124.80,'2022-12-18 17:31:27','',''),(5113,'1','285','1',1,'Retail Sale Id 5151',997.50,0.00,0.00,1.33,159.60,'2022-12-19 07:07:57','',''),(5114,'1','285','1',1,'Retail Sale Id 5152',3000.00,0.00,0.00,4.00,480.00,'2022-12-19 07:08:54','',''),(5115,'1','285','1',1,'Retail Sale Id 5153',11002.50,0.00,0.00,14.67,1760.40,'2022-12-19 07:11:03','',''),(5116,'1','285','1',1,'Retail Sale Id 5154',4500.00,0.00,0.00,6.00,720.00,'2022-12-19 07:11:52','',''),(5117,'1','285','1',1,'Retail Sale Id 5155',2250.00,0.00,0.00,3.00,360.00,'2022-12-19 07:15:29','',''),(5118,'1','285','1',1,'Retail Sale Id 5156',997.50,0.00,0.00,1.33,159.60,'2022-12-19 07:17:49','',''),(5119,'1','285','1',1,'Retail Sale Id 5157',3000.00,0.00,0.00,4.00,480.00,'2022-12-19 07:19:40','',''),(5120,'1','285','1',1,'Retail Sale Id 5158',1500.00,0.00,0.00,2.00,240.00,'2022-12-19 07:20:30','',''),(5121,'1','285','1',1,'Retail Sale Id 5159',2497.50,0.00,0.00,3.33,399.60,'2022-12-19 07:21:21','',''),(5122,'1','285','1',1,'Retail Sale Id 5160',1500.00,0.00,0.00,2.00,240.00,'2022-12-19 07:22:21','',''),(5123,'1','285','1',1,'Retail Sale Id 5161',1500.00,0.00,0.00,2.00,240.00,'2022-12-19 07:28:45','',''),(5124,'1','285','1',1,'Retail Sale Id 5162',2250.00,0.00,0.00,3.00,360.00,'2022-12-19 07:29:47','',''),(5125,'1','285','1',1,'Retail Sale Id 5163',2250.00,0.00,0.00,3.00,360.00,'2022-12-19 07:30:55','',''),(5126,'1','285','1',1,'Retail Sale Id 5164',40200.00,0.00,0.00,60.00,2400.00,'2022-12-19 07:33:22','',''),(5127,'1','285','1',1,'Retail Sale Id 5165',2250.00,0.00,0.00,3.00,360.00,'2022-12-19 07:35:47','',''),(5128,'1','285','1',1,'Retail Sale Id 5166',2250.00,0.00,0.00,3.00,360.00,'2022-12-19 07:39:48','',''),(5129,'1','285','1',1,'Retail Sale Id 5167',4500.00,0.00,0.00,6.00,720.00,'2022-12-19 07:40:36','',''),(5130,'1','285','1',1,'Retail Sale Id 5168',32521.80,0.00,0.00,48.54,1941.60,'2022-12-19 07:42:31','',''),(5131,'1','285','1',1,'Retail Sale Id 5169',750.00,0.00,0.00,1.00,120.00,'2022-12-19 07:46:51','',''),(5132,'1','285','1',1,'Retail Sale Id 5170',2250.00,0.00,0.00,3.00,360.00,'2022-12-19 08:00:00','',''),(5133,'1','285','1',1,'Retail Sale Id 5171',40200.00,0.00,0.00,60.00,2400.00,'2022-12-19 08:02:20','',''),(5134,'1','285','1',1,'Retail Sale Id 5172',33500.00,0.00,0.00,50.00,2000.00,'2022-12-19 08:08:19','',''),(5135,'1','285','1',1,'Retail Sale Id 5173',1500.00,0.00,0.00,2.00,240.00,'2022-12-19 08:10:58','',''),(5136,'1','285','1',1,'Retail Sale Id 5174',1500.00,0.00,0.00,2.00,240.00,'2022-12-19 08:11:41','',''),(5137,'1','285','1',1,'Retail Sale Id 5175',4500.00,0.00,0.00,6.00,720.00,'2022-12-19 08:13:34','',''),(5138,'1','285','1',1,'Retail Sale Id 5176',3000.00,0.00,0.00,4.00,480.00,'2022-12-19 08:14:21','',''),(5139,'1','285','1',1,'Retail Sale Id 5177',750.00,0.00,0.00,1.00,120.00,'2022-12-19 08:16:37','',''),(5140,'1','285','1',1,'Retail Sale Id 5178',750.00,0.00,0.00,1.00,120.00,'2022-12-19 08:18:13','',''),(5141,'1','285','1',1,'Retail Sale Id 5179',45439.40,0.00,0.00,67.82,2712.80,'2022-12-19 08:19:12','',''),(5142,'1','285','1',1,'Retail Sale Id 5180',40990.60,0.00,0.00,61.18,2447.20,'2022-12-19 08:24:23','',''),(5143,'1','285','1',1,'Retail Sale Id 5181',2250.00,0.00,0.00,3.00,360.00,'2022-12-19 08:25:44','',''),(5144,'1','285','1',1,'Retail Sale Id 5182',81914.20,0.00,0.00,122.26,4890.40,'2022-12-19 08:27:42','',''),(5145,'1','285','1',1,'Return of Retail Sale Id 5179',0.00,45439.40,67.82,0.00,-2712.80,'2022-12-19 08:30:01','',''),(5146,'1','285','1',1,'Retail Sale Id 5183',45446.10,0.00,0.00,67.83,2713.20,'2022-12-19 08:30:51','',''),(5147,'1','285','1',1,'Retail Sale Id 5184',750.00,0.00,0.00,1.00,120.00,'2022-12-19 08:32:01','',''),(5148,'1','285','1',1,'Retail Sale Id 5185',1500.00,0.00,0.00,2.00,240.00,'2022-12-19 08:32:58','',''),(5149,'1','285','1',1,'Retail Sale Id 5186',19430.00,0.00,0.00,29.00,1160.00,'2022-12-19 08:34:28','',''),(5150,'1','285','1',1,'Retail Sale Id 5187',41144.70,0.00,0.00,61.41,2456.40,'2022-12-19 08:36:42','',''),(5151,'1','285','1',1,'Retail Sale Id 5188',23450.00,0.00,0.00,35.00,1400.00,'2022-12-19 08:39:10','',''),(5152,'1','285','1',1,'Retail Sale Id 5189',60963.30,0.00,0.00,90.99,3639.60,'2022-12-19 08:40:56','',''),(5153,'1','285','1',1,'Retail Sale Id 5190',2197.50,0.00,0.00,2.93,351.60,'2022-12-19 08:46:17','',''),(5154,'1','285','1',1,'Retail Sale Id 5191',1500.00,0.00,0.00,2.00,240.00,'2022-12-19 08:47:12','',''),(5155,'1','285','1',1,'Retail Sale Id 5192',40119.60,0.00,0.00,59.88,2395.20,'2022-12-19 08:51:52','',''),(5156,'1','285','1',1,'Retail Sale Id 5193',41540.00,0.00,0.00,62.00,2480.00,'2022-12-19 08:56:44','',''),(5157,'1','285','1',1,'Retail Sale Id 5194',750.00,0.00,0.00,1.00,120.00,'2022-12-19 09:02:00','',''),(5158,'1','285','1',1,'Retail Sale Id 5195',29078.00,0.00,0.00,43.40,1736.00,'2022-12-19 09:09:00','',''),(5159,'1','285','1',1,'Retail Sale Id 5196',41332.30,0.00,0.00,61.69,2467.60,'2022-12-19 09:16:08','',''),(5160,'1','285','1',1,'Retail Sale Id 5197',11584.30,0.00,0.00,17.29,691.60,'2022-12-19 09:19:46','',''),(5161,'1','285','1',1,'Retail Sale Id 5198',2250.00,0.00,0.00,3.00,360.00,'2022-12-19 09:22:07','',''),(5162,'1','285','1',1,'Retail Sale Id 5199',1500.00,0.00,0.00,2.00,240.00,'2022-12-19 09:25:05','',''),(5163,'1','285','1',1,'Retail Sale Id 5200',57224.70,0.00,0.00,85.41,3416.40,'2022-12-19 09:39:29','',''),(5164,'1','285','1',1,'Retail Sale Id 5201',1500.00,0.00,0.00,2.00,240.00,'2022-12-19 09:46:50','',''),(5165,'1','285','1',1,'Retail Sale Id 5202',40963.80,0.00,0.00,61.14,2445.60,'2022-12-19 09:51:15','',''),(5166,'1','285','1',1,'Retail Sale Id 5203',1500.00,0.00,0.00,2.00,240.00,'2022-12-19 09:54:00','',''),(5167,'1','285','1',1,'Retail Sale Id 5204',2002.50,0.00,0.00,2.67,320.40,'2022-12-19 09:59:58','',''),(5168,'1','285','1',1,'Retail Sale Id 5205',40669.00,0.00,0.00,60.70,2428.00,'2022-12-19 10:01:07','',''),(5169,'1','285','1',1,'Retail Sale Id 5206',87609.20,0.00,0.00,130.76,5230.40,'2022-12-19 10:05:50','',''),(5170,'1','285','1',1,'Retail Sale Id 5207',10720.00,0.00,0.00,16.00,640.00,'2022-12-19 10:17:12','',''),(5171,'1','285','1',1,'Retail Sale Id 5208',997.50,0.00,0.00,1.33,159.60,'2022-12-19 10:19:49','',''),(5172,'1','285','1',1,'Retail Sale Id 5209',1500.00,0.00,0.00,2.00,240.00,'2022-12-19 10:20:39','',''),(5173,'1','285','1',1,'Retail Sale Id 5210',90450.00,0.00,0.00,135.00,5400.00,'2022-12-19 10:29:05','',''),(5174,'1','285','1',1,'Retail Sale Id 5211',41540.00,0.00,0.00,62.00,2480.00,'2022-12-19 10:31:48','',''),(5175,'1','285','1',1,'Retail Sale Id 5212',2002.50,0.00,0.00,2.67,320.40,'2022-12-19 10:55:18','',''),(5176,'1','285','1',1,'Retail Sale Id 5213',2002.50,0.00,0.00,2.67,320.40,'2022-12-19 10:56:15','',''),(5177,'1','285','1',1,'Retail Sale Id 5214',27470.00,0.00,0.00,41.00,1640.00,'2022-12-19 11:15:17','',''),(5178,'1','285','1',1,'Return of Retail Sale Id 5214',0.00,27470.00,41.00,0.00,-1640.00,'2022-12-19 11:17:18','',''),(5179,'1','285','1',1,'Retail Sale Id 5215',40870.00,0.00,0.00,61.00,2440.00,'2022-12-19 11:18:08','',''),(5180,'1','285','1',1,'Retail Sale Id 5216',45593.50,0.00,0.00,68.05,2722.00,'2022-12-19 11:22:52','',''),(5181,'1','285','1',1,'Retail Sale Id 5217',997.50,0.00,0.00,1.33,159.60,'2022-12-19 11:27:59','',''),(5182,'1','285','1',1,'Return of Retail Sale Id 5215',0.00,40870.00,61.00,0.00,-2440.00,'2022-12-19 11:30:26','',''),(5183,'1','285','1',1,'Retail Sale Id 5218',41084.40,0.00,0.00,61.32,2452.80,'2022-12-19 11:31:27','',''),(5184,'1','285','1',1,'Retail Sale Id 5219',2250.00,0.00,0.00,3.00,360.00,'2022-12-19 11:40:44','',''),(5185,'1','285','1',1,'Retail Sale Id 5221',2497.50,0.00,0.00,3.33,399.60,'2022-12-19 11:43:13','',''),(5186,'1','285','1',1,'Retail Sale Id 5222',2497.50,0.00,0.00,3.33,399.60,'2022-12-19 11:44:12','',''),(5187,'1','285','1',1,'Retail Sale Id 5223',26800.00,0.00,0.00,40.00,1600.00,'2022-12-19 11:45:58','',''),(5188,'1','285','1',1,'Retail Sale Id 5224',2872.50,0.00,0.00,3.83,459.60,'2022-12-19 11:53:36','',''),(5189,'1','285','1',1,'Return of Retail Sale Id 5222',0.00,2497.50,3.33,0.00,-399.60,'2022-12-19 11:54:07','',''),(5190,'1','285','1',1,'Retail Sale Id 5225',1500.00,0.00,0.00,2.00,240.00,'2022-12-19 12:19:45','',''),(5191,'1','285','1',1,'Retail Sale Id 5226',2002.50,0.00,0.00,2.67,320.40,'2022-12-19 12:20:30','',''),(5192,'1','285','1',1,'Retail Sale Id 5227',3000.00,0.00,0.00,4.00,480.00,'2022-12-19 12:34:21','',''),(5193,'1','285','1',1,'Retail Sale Id 5228',44816.30,0.00,0.00,66.89,2675.60,'2022-12-19 12:38:06','',''),(5194,'1','285','1',1,'Retail Sale Id 5229',1402.50,0.00,0.00,1.87,224.40,'2022-12-19 12:41:11','',''),(5195,'1','285','1',1,'Retail Sale Id 5230',40200.00,0.00,0.00,60.00,2400.00,'2022-12-19 12:43:18','',''),(5196,'1','285','1',1,'Retail Sale Id 5231',750.00,0.00,0.00,1.00,120.00,'2022-12-19 13:08:01','',''),(5197,'1','285','1',1,'Retail Sale Id 5232',750.00,0.00,0.00,1.00,120.00,'2022-12-19 13:08:52','',''),(5198,'1','285','1',1,'Retail Sale Id 5233',35690.90,0.00,0.00,53.27,2130.80,'2022-12-19 13:10:51','',''),(5199,'1','285','1',1,'Retail Sale Id 5234',4500.00,0.00,0.00,6.00,720.00,'2022-12-19 13:11:53','',''),(5200,'1','285','1',1,'Retail Sale Id 5235',1500.00,0.00,0.00,2.00,240.00,'2022-12-19 13:27:59','',''),(5201,'1','285','1',1,'Retail Sale Id 5236',22110.00,0.00,0.00,33.00,1320.00,'2022-12-19 13:32:01','',''),(5202,'1','285','1',1,'Retail Sale Id 5237',47650.40,0.00,0.00,71.12,2844.80,'2022-12-19 13:35:22','',''),(5203,'1','285','1',1,'Retail Sale Id 5238',3000.00,0.00,0.00,4.00,480.00,'2022-12-19 13:39:11','',''),(5204,'1','285','1',1,'Retail Sale Id 5239',1500.00,0.00,0.00,2.00,240.00,'2022-12-19 13:55:22','',''),(5205,'1','285','1',1,'Retail Sale Id 5240',2250.00,0.00,0.00,3.00,360.00,'2022-12-19 13:59:04','',''),(5206,'1','285','1',1,'Retail Sale Id 5242',52930.00,0.00,0.00,79.00,3160.00,'2022-12-19 14:10:52','',''),(5207,'1','285','1',1,'Retail Sale Id 5243',3997.50,0.00,0.00,5.33,639.60,'2022-12-19 14:11:54','',''),(5208,'1','285','1',1,'Retail Sale Id 5244',750.00,0.00,0.00,1.00,120.00,'2022-12-19 14:18:21','',''),(5209,'1','285','1',1,'Retail Sale Id 5245',1500.00,0.00,0.00,2.00,240.00,'2022-12-19 14:23:25','',''),(5210,'1','285','1',1,'Retail Sale Id 5246',33500.00,0.00,0.00,50.00,2000.00,'2022-12-19 14:31:38','',''),(5211,'1','285','1',1,'Retail Sale Id 5247',1500.00,0.00,0.00,2.00,240.00,'2022-12-19 14:46:26','',''),(5212,'1','285','1',1,'Retail Sale Id 5248',997.50,0.00,0.00,1.33,159.60,'2022-12-19 14:47:18','',''),(5213,'1','285','1',1,'Retail Sale Id 5249',33500.00,0.00,0.00,50.00,2000.00,'2022-12-19 14:55:21','',''),(5214,'1','285','1',1,'Retail Sale Id 5250',750.00,0.00,0.00,1.00,120.00,'2022-12-19 15:43:10','',''),(5215,'1','285','1',1,'Retail Sale Id 5251',16247.50,0.00,0.00,24.25,970.00,'2022-12-19 16:01:06','',''),(5216,'1','285','1',1,'Retail Sale Id 5252',750.00,0.00,0.00,1.00,120.00,'2022-12-19 16:12:22','',''),(5217,'1','285','1',1,'Retail Sale Id 5253',750.00,0.00,0.00,1.00,120.00,'2022-12-19 16:13:31','',''),(5218,'1','285','1',1,'Retail Sale Id 5254',802.50,0.00,0.00,1.07,128.40,'2022-12-19 16:14:20','',''),(5219,'1','285','1',1,'Retail Sale Id 5255',26800.00,0.00,0.00,40.00,1600.00,'2022-12-19 16:15:15','',''),(5220,'1','285','1',1,'Retail Sale Id 5256',1500.00,0.00,0.00,2.00,240.00,'2022-12-19 16:29:40','',''),(5221,'1','285','1',1,'Retail Sale Id 5257',16019.70,0.00,0.00,23.91,956.40,'2022-12-19 16:30:47','',''),(5222,'1','285','1',1,'Retail Sale Id 5258',1500.00,0.00,0.00,2.00,240.00,'2022-12-19 16:39:05','',''),(5223,'1','285','1',1,'Retail Sale Id 5259',750.00,0.00,0.00,1.00,120.00,'2022-12-19 16:46:52','',''),(5224,'1','285','1',1,'Retail Sale Id 5260',193187.80,0.00,0.00,288.34,11533.60,'2022-12-19 16:49:33','',''),(5225,'1','285','1',1,'Retail Sale Id 5261',1500.00,0.00,0.00,2.00,240.00,'2022-12-19 16:50:23','',''),(5226,'1','285','1',1,'Retail Sale Id 5262',997.50,0.00,0.00,1.33,159.60,'2022-12-19 16:51:15','',''),(5227,'1','285','1',1,'Retail Sale Id 5263',6000.00,0.00,0.00,8.00,960.00,'2022-12-19 16:52:21','',''),(5228,'1','285','1',1,'Retail Sale Id 5264',191746.10,0.00,0.00,288.34,10091.90,'2022-12-19 16:53:40','',''),(5229,'1','285','1',1,'Retail Sale Id 5265',750.00,0.00,0.00,1.00,120.00,'2022-12-19 16:54:27','',''),(5230,'1','285','1',1,'Return of Retail Sale Id 5260',0.00,193187.80,288.34,0.00,-11533.60,'2022-12-19 16:56:04','',''),(5231,'1','285','1',1,'Retail Sale Id 5266',292600.00,0.00,0.00,440.00,15400.00,'2022-12-19 16:57:44','',''),(5232,'1','285','1',1,'Retail Sale Id 5267',997.50,0.00,0.00,1.33,159.60,'2022-12-19 16:58:52','',''),(5233,'1','285','1',1,'Retail Sale Id 5268',4500.00,0.00,0.00,6.00,720.00,'2022-12-19 16:59:46','',''),(5234,'1','285','1',1,'Retail Sale Id 5269',997.50,0.00,0.00,1.33,159.60,'2022-12-19 17:00:33','',''),(5235,'1','285','1',1,'Retail Sale Id 5270',3000.00,0.00,0.00,4.00,480.00,'2022-12-19 17:01:18','',''),(5236,'1','285','1',1,'Retail Sale Id 5271',3000.00,0.00,0.00,4.00,480.00,'2022-12-19 17:02:02','',''),(5237,'1','285','1',1,'Retail Sale Id 5273',1500.00,0.00,0.00,2.00,240.00,'2022-12-19 17:03:21','',''),(5238,'1','285','1',1,'Retail Sale Id 5274',1500.00,0.00,0.00,2.00,240.00,'2022-12-19 17:04:10','',''),(5239,'1','285','1',1,'Retail Sale Id 5275',5250.00,0.00,0.00,7.00,840.00,'2022-12-19 17:06:05','',''),(5240,'1','285','1',1,'Retail Sale Id 5276',13300.00,0.00,0.00,20.00,700.00,'2022-12-19 17:07:09','',''),(5241,'1','285','1',1,'Retail Sale Id 5277',2250.00,0.00,0.00,3.00,360.00,'2022-12-19 17:07:48','',''),(5242,'1','285','1',1,'Retail Sale Id 5278',750.00,0.00,0.00,1.00,120.00,'2022-12-19 17:09:07','',''),(5243,'1','285','1',1,'Retail Sale Id 5279',3000.00,0.00,0.00,4.00,480.00,'2022-12-19 17:10:58','',''),(5244,'1','285','1',1,'Retail Sale Id 5280',1500.00,0.00,0.00,2.00,240.00,'2022-12-19 17:11:45','',''),(5245,'1','285','1',1,'Retail Sale Id 5281',1500.00,0.00,0.00,2.00,240.00,'2022-12-19 17:12:24','',''),(5246,'1','285','1',1,'Return of Retail Sale Id 5276',0.00,13300.00,20.00,0.00,-700.00,'2022-12-19 17:14:55','',''),(5247,'1','285','1',1,'Retail Sale Id 5282',55027.10,0.00,0.00,82.13,3285.20,'2022-12-19 17:27:28','',''),(5248,'1','285','1',1,'Retail Sale Id 5283',2250.00,0.00,0.00,3.00,360.00,'2022-12-20 07:16:06','',''),(5249,'1','285','1',1,'Retail Sale Id 5284',1500.00,0.00,0.00,2.00,240.00,'2022-12-20 07:17:04','',''),(5250,'1','285','1',1,'Retail Sale Id 5285',40200.00,0.00,0.00,60.00,2400.00,'2022-12-20 07:21:35','',''),(5251,'1','285','1',1,'Retail Sale Id 5286',2250.00,0.00,0.00,3.00,360.00,'2022-12-20 07:24:14','',''),(5252,'1','285','1',1,'Retail Sale Id 5287',49928.40,0.00,0.00,74.52,2980.80,'2022-12-20 07:26:33','',''),(5253,'1','285','1',1,'Retail Sale Id 5288',1500.00,0.00,0.00,2.00,240.00,'2022-12-20 07:29:38','',''),(5254,'1','285','1',1,'Retail Sale Id 5289',41540.00,0.00,0.00,62.00,2480.00,'2022-12-20 07:31:39','',''),(5255,'1','285','1',1,'Retail Sale Id 5290',2250.00,0.00,0.00,3.00,360.00,'2022-12-20 07:32:34','',''),(5256,'1','285','1',1,'Retail Sale Id 5291',8250.00,0.00,0.00,11.00,1320.00,'2022-12-20 07:35:14','',''),(5257,'1','285','1',1,'Retail Sale Id 5292',1500.00,0.00,0.00,2.00,240.00,'2022-12-20 07:36:26','',''),(5258,'1','285','1',1,'Retail Sale Id 5293',750.00,0.00,0.00,1.00,120.00,'2022-12-20 07:37:19','',''),(5259,'1','285','1',1,'Retail Sale Id 5294',2250.00,0.00,0.00,3.00,360.00,'2022-12-20 07:38:10','',''),(5260,'1','285','1',1,'Retail Sale Id 5295',41727.60,0.00,0.00,62.28,2491.20,'2022-12-20 07:40:28','',''),(5261,'1','285','1',1,'Retail Sale Id 5296',2002.50,0.00,0.00,2.67,320.40,'2022-12-20 07:43:14','',''),(5262,'1','285','1',1,'Retail Sale Id 5297',5250.00,0.00,0.00,7.00,840.00,'2022-12-20 07:54:21','',''),(5263,'1','285','1',1,'Retail Sale Id 5298',5250.00,0.00,0.00,7.00,840.00,'2022-12-20 08:03:24','',''),(5264,'1','285','1',1,'Retail Sale Id 5299',11865.70,0.00,0.00,17.71,708.40,'2022-12-20 08:05:10','',''),(5265,'1','285','1',1,'Retail Sale Id 5300',1500.00,0.00,0.00,2.00,240.00,'2022-12-20 08:07:08','',''),(5266,'1','285','1',1,'Retail Sale Id 5301',41339.00,0.00,0.00,61.70,2468.00,'2022-12-20 08:08:28','',''),(5267,'1','285','1',1,'Retail Sale Id 5302',9000.00,0.00,0.00,12.00,1440.00,'2022-12-20 08:11:51','',''),(5268,'1','285','1',1,'Retail Sale Id 5303',3750.00,0.00,0.00,5.00,600.00,'2022-12-20 08:13:23','',''),(5269,'1','285','1',1,'Retail Sale Id 5304',1500.00,0.00,0.00,2.00,240.00,'2022-12-20 08:17:51','',''),(5270,'1','285','1',1,'Retail Sale Id 5305',997.50,0.00,0.00,1.33,159.60,'2022-12-20 08:18:48','',''),(5271,'1','285','1',1,'Retail Sale Id 5306',2002.50,0.00,0.00,2.67,320.40,'2022-12-20 08:26:34','',''),(5272,'1','285','1',1,'Retail Sale Id 5307',9000.00,0.00,0.00,12.00,1440.00,'2022-12-20 08:28:01','',''),(5273,'1','285','1',1,'Retail Sale Id 5308',2002.50,0.00,0.00,2.67,320.40,'2022-12-20 08:29:07','',''),(5274,'1','285','1',1,'Retail Sale Id 5309',5250.00,0.00,0.00,7.00,840.00,'2022-12-20 08:30:07','',''),(5275,'1','285','1',1,'Retail Sale Id 5310',3750.00,0.00,0.00,5.00,600.00,'2022-12-20 08:33:28','',''),(5276,'1','285','1',1,'Retail Sale Id 5311',3000.00,0.00,0.00,4.00,480.00,'2022-12-20 08:36:02','',''),(5277,'1','285','1',1,'Retail Sale Id 5312',1500.00,0.00,0.00,2.00,240.00,'2022-12-20 08:42:06','',''),(5278,'1','285','1',1,'Retail Sale Id 5313',3750.00,0.00,0.00,5.00,600.00,'2022-12-20 08:42:55','',''),(5279,'1','285','1',1,'Retail Sale Id 5314',9983.00,0.00,0.00,14.90,596.00,'2022-12-20 08:44:13','',''),(5280,'1','285','1',1,'Retail Sale Id 5315',4500.00,0.00,0.00,6.00,720.00,'2022-12-20 08:45:51','',''),(5281,'1','285','1',1,'Retail Sale Id 5316',3750.00,0.00,0.00,5.00,600.00,'2022-12-20 08:49:53','',''),(5282,'1','285','1',1,'Retail Sale Id 5317',802.50,0.00,0.00,1.07,128.40,'2022-12-20 08:56:47','',''),(5283,'1','285','1',1,'Retail Sale Id 5318',3750.00,0.00,0.00,5.00,600.00,'2022-12-20 08:57:40','',''),(5284,'1','285','1',1,'Retail Sale Id 5319',13400.00,0.00,0.00,20.00,800.00,'2022-12-20 09:06:35','',''),(5285,'1','285','1',1,'Retail Sale Id 5320',41292.10,0.00,0.00,61.63,2465.20,'2022-12-20 09:08:35','',''),(5286,'1','285','1',1,'Retail Sale Id 5321',43818.00,0.00,0.00,65.40,2616.00,'2022-12-20 09:13:08','',''),(5287,'1','285','1',1,'Retail Sale Id 5322',41647.20,0.00,0.00,62.16,2486.40,'2022-12-20 09:17:05','',''),(5288,'1','285','1',1,'Retail Sale Id 5323',102228.60,0.00,0.00,152.58,6103.20,'2022-12-20 09:21:15','',''),(5289,'1','285','1',1,'Retail Sale Id 5324',9000.00,0.00,0.00,12.00,1440.00,'2022-12-20 09:25:27','',''),(5290,'1','285','1',1,'Retail Sale Id 5325',40729.30,0.00,0.00,60.79,2431.60,'2022-12-20 09:26:43','',''),(5291,'1','285','1',1,'Retail Sale Id 5326',2250.00,0.00,0.00,3.00,360.00,'2022-12-20 09:29:25','',''),(5292,'1','285','1',1,'Retail Sale Id 5327',36984.00,0.00,0.00,55.20,2208.00,'2022-12-20 09:31:19','',''),(5293,'1','285','1',1,'Retail Sale Id 5328',40789.60,0.00,0.00,60.88,2435.20,'2022-12-20 09:33:44','',''),(5294,'1','285','1',1,'Retail Sale Id 5329',4500.00,0.00,0.00,6.00,720.00,'2022-12-20 09:38:05','',''),(5295,'1','285','1',1,'Retail Sale Id 5330',5250.00,0.00,0.00,7.00,840.00,'2022-12-20 09:45:16','',''),(5296,'1','285','1',1,'Return of Retail Sale Id 5330',0.00,5250.00,7.00,0.00,-840.00,'2022-12-20 09:45:59','',''),(5297,'1','285','1',1,'Retail Sale Id 5331',5197.50,0.00,0.00,6.93,831.60,'2022-12-20 09:47:03','',''),(5298,'1','285','1',1,'Retail Sale Id 5332',1500.00,0.00,0.00,2.00,240.00,'2022-12-20 09:49:52','',''),(5299,'1','285','1',1,'Retail Sale Id 5333',6000.00,0.00,0.00,8.00,960.00,'2022-12-20 09:52:46','',''),(5300,'1','285','1',1,'Retail Sale Id 5334',9936.10,0.00,0.00,14.83,593.20,'2022-12-20 09:54:49','',''),(5301,'1','285','1',1,'Retail Sale Id 5335',16508.80,0.00,0.00,24.64,985.60,'2022-12-20 09:58:10','',''),(5302,'1','285','1',1,'Retail Sale Id 5336',802.50,0.00,0.00,1.07,128.40,'2022-12-20 10:03:29','',''),(5303,'1','285','1',1,'Retail Sale Id 5337',5250.00,0.00,0.00,7.00,840.00,'2022-12-20 10:06:31','',''),(5304,'1','285','1',1,'Retail Sale Id 5338',3750.00,0.00,0.00,5.00,600.00,'2022-12-20 10:09:51','',''),(5305,'1','285','1',1,'Retail Sale Id 5339',40997.30,0.00,0.00,61.19,2447.60,'2022-12-20 10:22:58','',''),(5306,'1','285','1',1,'Retail Sale Id 5340',3750.00,0.00,0.00,5.00,600.00,'2022-12-20 10:33:08','',''),(5307,'1','285','1',1,'Retail Sale Id 5341',1500.00,0.00,0.00,2.00,240.00,'2022-12-20 10:36:42','',''),(5308,'1','285','1',1,'Retail Sale Id 5342',7500.00,0.00,0.00,10.00,1200.00,'2022-12-20 10:48:55','',''),(5309,'1','285','1',1,'Retail Sale Id 5343',750.00,0.00,0.00,1.00,120.00,'2022-12-20 10:50:47','',''),(5310,'1','285','1',1,'Retail Sale Id 5344',2002.50,0.00,0.00,2.67,320.40,'2022-12-20 10:52:55','',''),(5311,'1','285','1',1,'Retail Sale Id 5345',5250.00,0.00,0.00,7.00,840.00,'2022-12-20 10:53:48','',''),(5312,'1','285','1',1,'Retail Sale Id 5346',1500.00,0.00,0.00,2.00,240.00,'2022-12-20 11:00:41','',''),(5313,'1','285','1',1,'Retail Sale Id 5347',1500.00,0.00,0.00,2.00,240.00,'2022-12-20 11:36:32','',''),(5314,'1','285','1',1,'Retail Sale Id 5348',42880.00,0.00,0.00,64.00,2560.00,'2022-12-20 11:58:43','',''),(5315,'1','285','1',1,'Retail Sale Id 5349',1500.00,0.00,0.00,2.00,240.00,'2022-12-20 12:20:16','',''),(5316,'1','285','1',1,'Retail Sale Id 5350',1500.00,0.00,0.00,2.00,240.00,'2022-12-20 12:39:54','',''),(5317,'1','285','1',1,'Retail Sale Id 5351',40890.10,0.00,0.00,61.03,2441.20,'2022-12-20 12:51:05','',''),(5318,'1','285','1',1,'Retail Sale Id 5352',2497.50,0.00,0.00,3.33,399.60,'2022-12-20 13:21:57','',''),(5319,'1','285','1',1,'Retail Sale Id 5353',9889.20,0.00,0.00,14.76,590.40,'2022-12-20 13:27:32','',''),(5320,'1','285','1',1,'Retail Sale Id 5354',1500.00,0.00,0.00,2.00,240.00,'2022-12-20 13:49:32','',''),(5321,'1','285','1',1,'Retail Sale Id 5355',25460.00,0.00,0.00,38.00,1520.00,'2022-12-20 14:04:10','',''),(5322,'1','285','1',1,'Retail Sale Id 5356',40200.00,0.00,0.00,60.00,2400.00,'2022-12-20 14:46:29','',''),(5323,'1','285','1',1,'Retail Sale Id 5357',65251.30,0.00,0.00,97.39,3895.60,'2022-12-20 15:02:34','',''),(5324,'1','285','1',1,'Retail Sale Id 5358',2002.50,0.00,0.00,2.67,320.40,'2022-12-20 15:35:39','',''),(5325,'1','285','1',1,'Retail Sale Id 5359',11664.70,0.00,0.00,17.41,696.40,'2022-12-20 15:52:58','',''),(5326,'1','285','1',1,'Retail Sale Id 5360',3000.00,0.00,0.00,4.00,480.00,'2022-12-20 16:30:19','',''),(5327,'1','285','1',1,'Retail Sale Id 5361',56199.60,0.00,0.00,83.88,3355.20,'2022-12-20 16:33:21','',''),(5328,'1','285','1',1,'Retail Sale Id 5362',1500.00,0.00,0.00,2.00,240.00,'2022-12-20 16:36:30','',''),(5329,'1','285','1',1,'Retail Sale Id 5363',40588.60,0.00,0.00,60.58,2423.20,'2022-12-20 16:43:02','',''),(5330,'1','285','1',1,'Retail Sale Id 5364',5602.50,0.00,0.00,7.47,896.40,'2022-12-20 16:49:55','',''),(5331,'1','285','1',1,'Retail Sale Id 5365',3000.00,0.00,0.00,4.00,480.00,'2022-12-20 16:52:45','',''),(5332,'1','285','1',1,'Retail Sale Id 5366',2250.00,0.00,0.00,3.00,360.00,'2022-12-20 16:55:40','',''),(5333,'1','285','1',1,'Retail Sale Id 5367',22110.00,0.00,0.00,33.00,1320.00,'2022-12-20 17:01:14','',''),(5334,'1','285','1',1,'Retail Sale Id 5368',1500.00,0.00,0.00,2.00,240.00,'2022-12-20 17:02:14','',''),(5335,'1','285','1',1,'Retail Sale Id 5369',3000.00,0.00,0.00,4.00,480.00,'2022-12-20 17:05:16','',''),(5336,'1','285','1',1,'Retail Sale Id 5370',1500.00,0.00,0.00,2.00,240.00,'2022-12-21 07:02:12','',''),(5337,'1','285','1',1,'Retail Sale Id 5371',40200.00,0.00,0.00,60.00,2400.00,'2022-12-21 07:04:42','',''),(5338,'1','285','1',1,'Retail Sale Id 5372',750.00,0.00,0.00,1.00,120.00,'2022-12-21 07:09:42','',''),(5339,'1','285','1',1,'Retail Sale Id 5373',43034.10,0.00,0.00,64.23,2569.20,'2022-12-21 07:12:12','',''),(5340,'1','285','1',1,'Retail Sale Id 5374',802.50,0.00,0.00,1.07,128.40,'2022-12-21 07:14:59','',''),(5341,'1','285','1',1,'Retail Sale Id 5375',1500.00,0.00,0.00,2.00,240.00,'2022-12-21 07:21:55','',''),(5342,'1','285','1',1,'Retail Sale Id 5376',2250.00,0.00,0.00,3.00,360.00,'2022-12-21 07:23:09','',''),(5343,'1','285','1',1,'Retail Sale Id 5377',802.50,0.00,0.00,1.07,128.40,'2022-12-21 07:24:01','',''),(5344,'1','285','1',1,'Retail Sale Id 5378',997.50,0.00,0.00,1.33,159.60,'2022-12-21 07:31:29','',''),(5345,'1','285','1',1,'Retail Sale Id 5379',2302.50,0.00,0.00,3.07,368.40,'2022-12-21 07:50:28','',''),(5346,'1','285','1',1,'Retail Sale Id 5380',1500.00,0.00,0.00,2.00,240.00,'2022-12-21 07:51:24','',''),(5347,'1','285','1',1,'Retail Sale Id 5381',2302.50,0.00,0.00,3.07,368.40,'2022-12-21 07:55:14','',''),(5348,'1','285','1',1,'Retail Sale Id 5382',802.50,0.00,0.00,1.07,128.40,'2022-12-21 07:58:47','',''),(5349,'1','285','1',1,'Retail Sale Id 5383',40870.00,0.00,0.00,61.00,2440.00,'2022-12-21 08:00:05','',''),(5350,'1','285','1',1,'Retail Sale Id 5384',40200.00,0.00,0.00,60.00,2400.00,'2022-12-21 08:05:49','',''),(5351,'1','285','1',1,'Retail Sale Id 5385',3750.00,0.00,0.00,5.00,600.00,'2022-12-21 08:08:29','',''),(5352,'1','285','1',1,'Retail Sale Id 5386',4500.00,0.00,0.00,6.00,720.00,'2022-12-21 08:09:32','',''),(5353,'1','285','1',1,'Retail Sale Id 5387',4500.00,0.00,0.00,6.00,720.00,'2022-12-21 08:10:41','',''),(5354,'1','285','1',1,'Return of Retail Sale Id 5384',0.00,40200.00,60.00,0.00,-2400.00,'2022-12-21 08:15:20','',''),(5355,'1','285','1',1,'Retail Sale Id 5388',39603.70,0.00,0.00,59.11,2364.40,'2022-12-21 08:16:14','',''),(5356,'1','285','1',1,'Retail Sale Id 5389',2250.00,0.00,0.00,3.00,360.00,'2022-12-21 08:18:13','',''),(5357,'1','285','1',1,'Retail Sale Id 5390',1500.00,0.00,0.00,2.00,240.00,'2022-12-21 08:20:04','',''),(5358,'1','285','1',1,'Retail Sale Id 5392',4875.00,0.00,0.00,6.50,780.00,'2022-12-21 08:44:06','',''),(5359,'1','285','1',1,'Retail Sale Id 5393',5250.00,0.00,0.00,7.00,840.00,'2022-12-21 08:44:46','',''),(5360,'1','285','1',1,'Retail Sale Id 5394',750.00,0.00,0.00,1.00,120.00,'2022-12-21 08:45:32','',''),(5361,'1','285','1',1,'Retail Sale Id 5395',29480.00,0.00,0.00,44.00,1760.00,'2022-12-21 08:46:25','',''),(5362,'1','285','1',1,'Retail Sale Id 5396',2250.00,0.00,0.00,3.00,360.00,'2022-12-21 08:47:57','',''),(5363,'1','285','1',1,'Retail Sale Id 5397',2250.00,0.00,0.00,3.00,360.00,'2022-12-21 08:49:00','',''),(5364,'1','285','1',1,'Retail Sale Id 5398',3750.00,0.00,0.00,5.00,600.00,'2022-12-21 08:50:01','',''),(5365,'1','285','1',1,'Retail Sale Id 5399',7500.00,0.00,0.00,10.00,1200.00,'2022-12-21 08:50:59','',''),(5366,'1','285','1',1,'Retail Sale Id 5400',2250.00,0.00,0.00,3.00,360.00,'2022-12-21 08:55:18','',''),(5367,'1','285','1',1,'Retail Sale Id 5401',2497.50,0.00,0.00,3.33,399.60,'2022-12-21 08:58:46','',''),(5368,'1','285','1',1,'Retail Sale Id 5402',2250.00,0.00,0.00,3.00,360.00,'2022-12-21 08:59:42','',''),(5369,'1','285','1',1,'Retail Sale Id 5403',3000.00,0.00,0.00,4.00,480.00,'2022-12-21 09:00:55','',''),(5370,'1','285','1',1,'Retail Sale Id 5404',82416.70,0.00,0.00,123.01,4920.40,'2022-12-21 09:07:36','',''),(5371,'1','285','1',1,'Retail Sale Id 5405',10029.90,0.00,0.00,14.97,598.80,'2022-12-21 09:10:46','',''),(5372,'1','285','1',1,'Retail Sale Id 5406',3000.00,0.00,0.00,4.00,480.00,'2022-12-21 09:12:27','',''),(5373,'1','285','1',1,'Retail Sale Id 5407',1500.00,0.00,0.00,2.00,240.00,'2022-12-21 09:13:21','',''),(5374,'1','285','1',1,'Retail Sale Id 5408',1500.00,0.00,0.00,2.00,240.00,'2022-12-21 09:14:11','',''),(5375,'1','285','1',1,'Retail Sale Id 5409',802.50,0.00,0.00,1.07,128.40,'2022-12-21 09:15:39','',''),(5376,'1','285','1',1,'Retail Sale Id 5410',1500.00,0.00,0.00,2.00,240.00,'2022-12-21 09:17:12','',''),(5377,'1','285','1',1,'Retail Sale Id 5411',11926.00,0.00,0.00,17.80,712.00,'2022-12-21 09:23:03','',''),(5378,'1','285','1',1,'Retail Sale Id 5412',15034.80,0.00,0.00,22.44,897.60,'2022-12-21 09:24:25','',''),(5379,'1','285','1',1,'Retail Sale Id 5413',3000.00,0.00,0.00,4.00,480.00,'2022-12-21 09:32:56','',''),(5380,'1','285','1',1,'Retail Sale Id 5414',750.00,0.00,0.00,1.00,120.00,'2022-12-21 09:33:59','',''),(5381,'1','285','1',1,'Retail Sale Id 5415',5360.00,0.00,0.00,8.00,320.00,'2022-12-21 09:49:20','',''),(5382,'1','285','1',1,'Retail Sale Id 5416',29124.90,0.00,0.00,43.47,1738.80,'2022-12-21 09:53:18','',''),(5383,'1','285','1',1,'Retail Sale Id 5417',3000.00,0.00,0.00,4.00,480.00,'2022-12-21 09:57:32','',''),(5384,'1','285','1',1,'Retail Sale Id 5418',1500.00,0.00,0.00,2.00,240.00,'2022-12-21 10:06:05','',''),(5385,'1','285','1',1,'Retail Sale Id 5419',802.50,0.00,0.00,1.07,128.40,'2022-12-21 10:15:35','',''),(5386,'1','285','1',1,'Retail Sale Id 5420',2250.00,0.00,0.00,3.00,360.00,'2022-12-21 10:19:19','',''),(5387,'1','285','1',1,'Retail Sale Id 5421',997.50,0.00,0.00,1.33,159.60,'2022-12-21 10:23:33','',''),(5388,'1','285','1',1,'Retail Sale Id 5422',41432.80,0.00,0.00,61.84,2473.60,'2022-12-21 10:26:15','',''),(5389,'1','285','1',1,'Retail Sale Id 5423',41117.90,0.00,0.00,61.37,2454.80,'2022-12-21 10:30:19','',''),(5390,'1','285','1',1,'Retail Sale Id 5424',997.50,0.00,0.00,1.33,159.60,'2022-12-21 10:32:29','',''),(5391,'1','285','1',1,'Retail Sale Id 5425',41131.30,0.00,0.00,61.39,2455.60,'2022-12-21 10:33:57','',''),(5392,'1','285','1',1,'Retail Sale Id 5426',1500.00,0.00,0.00,2.00,240.00,'2022-12-21 10:46:37','',''),(5393,'1','285','1',1,'Retail Sale Id 5427',4500.00,0.00,0.00,6.00,720.00,'2022-12-21 10:47:51','',''),(5394,'1','285','1',1,'Retail Sale Id 5428',1500.00,0.00,0.00,2.00,240.00,'2022-12-21 10:53:52','',''),(5395,'1','285','1',1,'Retail Sale Id 5429',2250.00,0.00,0.00,3.00,360.00,'2022-12-21 10:54:55','',''),(5396,'1','285','1',1,'Retail Sale Id 5430',3000.00,0.00,0.00,4.00,480.00,'2022-12-21 10:59:33','',''),(5397,'1','285','1',1,'Retail Sale Id 5431',47905.00,0.00,0.00,71.50,2860.00,'2022-12-21 11:04:48','',''),(5398,'1','285','1',1,'Retail Sale Id 5432',1500.00,0.00,0.00,2.00,240.00,'2022-12-21 11:06:52','',''),(5399,'1','285','1',1,'Retail Sale Id 5433',802.50,0.00,0.00,1.07,128.40,'2022-12-21 11:09:48','',''),(5400,'1','285','1',1,'Retail Sale Id 5434',9997.50,0.00,0.00,13.33,1599.60,'2022-12-21 11:19:28','',''),(5401,'1','285','1',1,'Retail Sale Id 5435',2497.50,0.00,0.00,3.33,399.60,'2022-12-21 11:41:41','',''),(5402,'1','285','1',1,'Retail Sale Id 5436',4500.00,0.00,0.00,6.00,720.00,'2022-12-21 11:44:12','',''),(5403,'1','285','1',1,'Retail Sale Id 5437',1500.00,0.00,0.00,2.00,240.00,'2022-12-21 11:52:36','',''),(5404,'1','285','1',1,'Retail Sale Id 5438',2302.50,0.00,0.00,3.07,368.40,'2022-12-21 12:03:30','',''),(5405,'1','285','1',1,'Retail Sale Id 5439',4500.00,0.00,0.00,6.00,720.00,'2022-12-21 12:04:29','',''),(5406,'1','285','1',1,'Retail Sale Id 5440',750.00,0.00,0.00,1.00,120.00,'2022-12-21 12:07:39','',''),(5407,'1','285','1',1,'Retail Sale Id 5441',8250.00,0.00,0.00,11.00,1320.00,'2022-12-21 12:11:31','',''),(5408,'1','285','1',1,'Retail Sale Id 5442',1500.00,0.00,0.00,2.00,240.00,'2022-12-21 12:14:40','',''),(5409,'1','285','1',1,'Retail Sale Id 5443',7500.00,0.00,0.00,10.00,1200.00,'2022-12-21 12:18:56','',''),(5410,'1','285','1',1,'Retail Sale Id 5444',1500.00,0.00,0.00,2.00,240.00,'2022-12-21 12:20:08','',''),(5411,'1','285','1',1,'Retail Sale Id 5445',16381.50,0.00,0.00,24.45,978.00,'2022-12-21 12:26:02','',''),(5412,'1','285','1',1,'Retail Sale Id 5446',40200.00,0.00,0.00,60.00,2400.00,'2022-12-21 13:03:02','',''),(5413,'1','285','1',1,'Retail Sale Id 5447',997.50,0.00,0.00,1.33,159.60,'2022-12-21 13:08:30','',''),(5414,'1','285','1',1,'Retail Sale Id 5448',1500.00,0.00,0.00,2.00,240.00,'2022-12-21 13:19:00','',''),(5415,'1','285','1',1,'Retail Sale Id 5449',750.00,0.00,0.00,1.00,120.00,'2022-12-21 13:21:01','',''),(5416,'1','285','1',1,'Retail Sale Id 5450',7500.00,0.00,0.00,10.00,1200.00,'2022-12-21 13:26:15','',''),(5417,'1','285','1',1,'Retail Sale Id 5451',40200.00,0.00,0.00,60.00,2400.00,'2022-12-21 13:34:08','',''),(5418,'1','285','1',1,'Retail Sale Id 5452',1500.00,0.00,0.00,2.00,240.00,'2022-12-21 13:34:54','',''),(5419,'1','285','1',1,'Retail Sale Id 5453',2302.50,0.00,0.00,3.07,368.40,'2022-12-21 13:52:37','',''),(5420,'1','285','1',1,'Retail Sale Id 5454',1500.00,0.00,0.00,2.00,240.00,'2022-12-21 14:11:02','',''),(5421,'1','285','1',1,'Retail Sale Id 5455',3000.00,0.00,0.00,4.00,480.00,'2022-12-21 14:12:40','',''),(5422,'1','285','1',1,'Retail Sale Id 5456',4500.00,0.00,0.00,6.00,720.00,'2022-12-21 14:18:20','',''),(5423,'1','285','1',1,'Retail Sale Id 5457',10875.00,0.00,0.00,14.50,1740.00,'2022-12-21 14:30:23','',''),(5424,'1','285','1',1,'Retail Sale Id 5458',4500.00,0.00,0.00,6.00,720.00,'2022-12-21 14:34:50','',''),(5425,'1','285','1',1,'Retail Sale Id 5459',2250.00,0.00,0.00,3.00,360.00,'2022-12-21 14:55:24','',''),(5426,'1','285','1',1,'Retail Sale Id 5460',1500.00,0.00,0.00,2.00,240.00,'2022-12-21 15:01:51','',''),(5427,'1','285','1',1,'Retail Sale Id 5461',750.00,0.00,0.00,1.00,120.00,'2022-12-21 15:04:22','',''),(5428,'1','285','1',1,'Retail Sale Id 5462',8250.00,0.00,0.00,11.00,1320.00,'2022-12-21 15:17:15','',''),(5429,'1','285','1',1,'Retail Sale Id 5463',750.00,0.00,0.00,1.00,120.00,'2022-12-21 15:32:50','',''),(5430,'1','285','1',1,'Retail Sale Id 5464',1500.00,0.00,0.00,2.00,240.00,'2022-12-21 15:40:15','',''),(5431,'1','285','1',1,'Retail Sale Id 5465',3000.00,0.00,0.00,4.00,480.00,'2022-12-21 15:59:04','',''),(5432,'1','285','1',1,'Retail Sale Id 5466',802.50,0.00,0.00,1.07,128.40,'2022-12-21 16:05:31','',''),(5433,'1','285','1',1,'Return of Retail Sale Id 5465',0.00,3000.00,4.00,0.00,-480.00,'2022-12-21 16:08:20','',''),(5434,'1','285','1',1,'Retail Sale Id 5467',2775.00,0.00,0.00,3.70,444.00,'2022-12-21 16:09:13','',''),(5435,'1','285','1',1,'Retail Sale Id 5468',5002.50,0.00,0.00,6.67,800.40,'2022-12-21 16:10:42','',''),(5436,'1','285','1',1,'Retail Sale Id 5469',12750.00,0.00,0.00,17.00,2040.00,'2022-12-21 16:14:10','',''),(5437,'1','285','1',1,'Retail Sale Id 5470',802.50,0.00,0.00,1.07,128.40,'2022-12-21 16:16:03','',''),(5438,'1','285','1',1,'Retail Sale Id 5471',1500.00,0.00,0.00,2.00,240.00,'2022-12-21 16:17:26','',''),(5439,'1','285','1',1,'Retail Sale Id 5472',23450.00,0.00,0.00,35.00,1400.00,'2022-12-21 16:18:56','',''),(5440,'1','285','1',1,'Retail Sale Id 5473',997.50,0.00,0.00,1.33,159.60,'2022-12-21 16:24:45','',''),(5441,'1','285','1',1,'Retail Sale Id 5474',22110.00,0.00,0.00,33.00,1320.00,'2022-12-21 16:28:16','',''),(5442,'1','285','1',1,'Retail Sale Id 5475',2400.00,0.00,0.00,3.20,384.00,'2022-12-21 16:33:30','',''),(5443,'1','285','1',1,'Retail Sale Id 5476',9000.00,0.00,0.00,12.00,1440.00,'2022-12-21 16:41:26','',''),(5444,'1','285','1',1,'Retail Sale Id 5477',1500.00,0.00,0.00,2.00,240.00,'2022-12-21 16:44:55','',''),(5445,'1','285','1',1,'Retail Sale Id 5478',2002.50,0.00,0.00,2.67,320.40,'2022-12-21 16:46:30','',''),(5446,'1','285','1',1,'Retail Sale Id 5479',3000.00,0.00,0.00,4.00,480.00,'2022-12-21 16:47:24','',''),(5447,'1','285','1',1,'Retail Sale Id 5480',750.00,0.00,0.00,1.00,120.00,'2022-12-21 16:53:05','',''),(5448,'1','285','1',1,'Retail Sale Id 5481',750.00,0.00,0.00,1.00,120.00,'2022-12-21 16:54:01','',''),(5449,'1','285','1',1,'Retail Sale Id 5482',3000.00,0.00,0.00,4.00,480.00,'2022-12-22 06:56:32','',''),(5450,'1','285','1',1,'Retail Sale Id 5483',33500.00,0.00,0.00,50.00,2000.00,'2022-12-22 07:09:47','',''),(5451,'1','285','1',1,'Retail Sale Id 5484',41379.20,0.00,0.00,61.76,2470.40,'2022-12-22 07:12:39','',''),(5452,'1','285','1',1,'Retail Sale Id 5485',1500.00,0.00,0.00,2.00,240.00,'2022-12-22 07:15:10','',''),(5453,'1','285','1',1,'Retail Sale Id 5486',1500.00,0.00,0.00,2.00,240.00,'2022-12-22 07:20:23','',''),(5454,'1','285','1',1,'Retail Sale Id 5487',19430.00,0.00,0.00,29.00,1160.00,'2022-12-22 07:27:21','',''),(5455,'1','285','1',1,'Retail Sale Id 5488',1500.00,0.00,0.00,2.00,240.00,'2022-12-22 07:29:03','',''),(5456,'1','285','1',1,'Retail Sale Id 5489',3000.00,0.00,0.00,4.00,480.00,'2022-12-22 07:32:32','',''),(5457,'1','285','1',1,'Retail Sale Id 5490',2302.50,0.00,0.00,3.07,368.40,'2022-12-22 07:36:31','',''),(5458,'1','285','1',1,'Retail Sale Id 5491',13400.00,0.00,0.00,20.00,800.00,'2022-12-22 07:39:40','',''),(5459,'1','285','1',1,'Retail Sale Id 5492',2250.00,0.00,0.00,3.00,360.00,'2022-12-22 07:41:45','',''),(5460,'1','285','1',1,'Retail Sale Id 5493',1500.00,0.00,0.00,2.00,240.00,'2022-12-22 07:42:34','',''),(5461,'1','285','1',1,'Retail Sale Id 5494',1500.00,0.00,0.00,2.00,240.00,'2022-12-22 07:51:16','',''),(5462,'1','285','1',1,'Retail Sale Id 5495',1500.00,0.00,0.00,2.00,240.00,'2022-12-22 07:57:26','',''),(5463,'1','285','1',1,'Retail Sale Id 5496',802.50,0.00,0.00,1.07,128.40,'2022-12-22 08:02:06','',''),(5464,'1','285','1',1,'Retail Sale Id 5497',16415.00,0.00,0.00,24.50,980.00,'2022-12-22 08:08:15','',''),(5465,'1','285','1',1,'Retail Sale Id 5498',1500.00,0.00,0.00,2.00,240.00,'2022-12-22 08:20:42','',''),(5466,'1','285','1',1,'Retail Sale Id 5499',41258.60,0.00,0.00,61.58,2463.20,'2022-12-22 08:26:22','',''),(5467,'1','285','1',1,'Retail Sale Id 5500',1500.00,0.00,0.00,2.00,240.00,'2022-12-22 08:34:25','',''),(5468,'1','285','1',1,'Retail Sale Id 5502',1500.00,0.00,0.00,2.00,240.00,'2022-12-22 08:47:04','',''),(5469,'1','285','1',1,'Retail Sale Id 5503',750.00,0.00,0.00,1.00,120.00,'2022-12-22 08:48:40','',''),(5470,'1','285','1',1,'Retail Sale Id 5504',23450.00,0.00,0.00,35.00,1400.00,'2022-12-22 09:01:27','',''),(5471,'1','285','1',1,'Retail Sale Id 5505',2250.00,0.00,0.00,3.00,360.00,'2022-12-22 09:07:35','',''),(5472,'1','285','1',1,'Retail Sale Id 5506',2625.00,0.00,0.00,3.50,420.00,'2022-12-22 09:13:36','',''),(5473,'1','285','1',1,'Retail Sale Id 5507',27845.20,0.00,0.00,41.56,1662.40,'2022-12-22 09:17:20','',''),(5474,'1','285','1',1,'Retail Sale Id 5508',750.00,0.00,0.00,1.00,120.00,'2022-12-22 09:22:17','',''),(5475,'1','285','1',1,'Retail Sale Id 5509',2250.00,0.00,0.00,3.00,360.00,'2022-12-22 09:31:50','',''),(5476,'1','285','1',1,'Retail Sale Id 5510',44608.60,0.00,0.00,66.58,2663.20,'2022-12-22 09:37:56','',''),(5477,'1','285','1',1,'Retail Sale Id 5511',4500.00,0.00,0.00,6.00,720.00,'2022-12-22 09:42:01','',''),(5478,'1','285','1',1,'Retail Sale Id 5512',5002.50,0.00,0.00,6.67,800.40,'2022-12-22 09:44:33','',''),(5479,'1','285','1',1,'Retail Sale Id 5513',45077.60,0.00,0.00,67.28,2691.20,'2022-12-22 09:46:12','',''),(5480,'1','285','1',1,'Retail Sale Id 5514',2250.00,0.00,0.00,3.00,360.00,'2022-12-22 09:47:34','',''),(5481,'1','285','1',1,'Retail Sale Id 5515',2250.00,0.00,0.00,3.00,360.00,'2022-12-22 09:49:37','',''),(5482,'1','285','1',1,'Retail Sale Id 5516',16080.00,0.00,0.00,24.00,960.00,'2022-12-22 09:52:25','',''),(5483,'1','285','1',1,'Retail Sale Id 5517',997.50,0.00,0.00,1.33,159.60,'2022-12-22 09:54:33','',''),(5484,'1','285','1',1,'Retail Sale Id 5518',23450.00,0.00,0.00,35.00,1400.00,'2022-12-22 09:56:06','',''),(5485,'1','285','1',1,'Retail Sale Id 5519',29928.90,0.00,0.00,44.67,1786.80,'2022-12-22 10:10:41','',''),(5486,'1','285','1',1,'Retail Sale Id 5521',2002.50,0.00,0.00,2.67,320.40,'2022-12-22 10:53:29','',''),(5487,'1','285','1',1,'Retail Sale Id 5522',33500.00,0.00,0.00,50.00,2000.00,'2022-12-22 11:06:31','',''),(5488,'1','285','1',1,'Retail Sale Id 5523',9942.80,0.00,0.00,14.84,593.60,'2022-12-22 11:26:43','',''),(5489,'1','285','1',1,'Retail Sale Id 5524',2002.50,0.00,0.00,2.67,320.40,'2022-12-22 11:34:21','',''),(5490,'1','285','1',1,'Retail Sale Id 5525',750.00,0.00,0.00,1.00,120.00,'2022-12-22 11:43:21','',''),(5491,'1','285','1',1,'Retail Sale Id 5526',750.00,0.00,0.00,1.00,120.00,'2022-12-22 11:45:23','',''),(5492,'1','285','1',1,'Retail Sale Id 5527',59368.70,0.00,0.00,88.61,3544.40,'2022-12-22 11:47:28','',''),(5493,'1','285','1',1,'Retail Sale Id 5528',802.50,0.00,0.00,1.07,128.40,'2022-12-22 11:50:53','',''),(5494,'1','285','1',1,'Retail Sale Id 5529',48983.70,0.00,0.00,73.11,2924.40,'2022-12-22 12:10:53','',''),(5495,'1','285','1',1,'Retail Sale Id 5530',3000.00,0.00,0.00,4.00,480.00,'2022-12-22 12:18:20','',''),(5496,'1','285','1',1,'Retail Sale Id 5531',1500.00,0.00,0.00,2.00,240.00,'2022-12-22 12:19:29','',''),(5497,'1','285','1',1,'Retail Sale Id 5532',750.00,0.00,0.00,1.00,120.00,'2022-12-22 12:22:23','',''),(5498,'1','285','1',1,'Retail Sale Id 5533',3750.00,0.00,0.00,5.00,600.00,'2022-12-22 12:24:56','',''),(5499,'1','285','1',1,'Retail Sale Id 5534',802.50,0.00,0.00,1.07,128.40,'2022-12-22 12:31:41','',''),(5500,'1','285','1',1,'Retail Sale Id 5535',2250.00,0.00,0.00,3.00,360.00,'2022-12-22 12:33:59','',''),(5501,'1','285','1',1,'Retail Sale Id 5536',670.00,0.00,0.00,1.00,40.00,'2022-12-22 12:44:57','',''),(5502,'1','285','1',1,'Retail Sale Id 5537',2250.00,0.00,0.00,3.00,360.00,'2022-12-22 12:53:03','',''),(5503,'1','285','1',1,'Retail Sale Id 5538',1500.00,0.00,0.00,2.00,240.00,'2022-12-22 12:54:46','',''),(5504,'1','285','1',1,'Retail Sale Id 5539',2002.50,0.00,0.00,2.67,320.40,'2022-12-22 13:09:16','',''),(5505,'1','285','1',1,'Retail Sale Id 5540',3000.00,0.00,0.00,4.00,480.00,'2022-12-22 13:31:03','',''),(5506,'1','285','1',1,'Retail Sale Id 5541',40447.90,0.00,0.00,60.37,2414.80,'2022-12-22 13:49:14','',''),(5507,'1','285','1',1,'Retail Sale Id 5542',4500.00,0.00,0.00,6.00,720.00,'2022-12-22 13:53:36','',''),(5508,'1','285','1',1,'Retail Sale Id 5543',2497.50,0.00,0.00,3.33,399.60,'2022-12-22 14:04:30','',''),(5509,'1','285','1',1,'Retail Sale Id 5544',5250.00,0.00,0.00,7.00,840.00,'2022-12-22 14:07:31','',''),(5510,'1','285','1',1,'Retail Sale Id 5545',33500.00,0.00,0.00,50.00,2000.00,'2022-12-22 14:09:04','',''),(5511,'1','285','1',1,'Retail Sale Id 5546',40427.80,0.00,0.00,60.34,2413.60,'2022-12-22 14:12:29','',''),(5512,'1','285','1',1,'Retail Sale Id 5547',40421.10,0.00,0.00,60.33,2413.20,'2022-12-22 14:18:06','',''),(5513,'1','285','1',1,'Retail Sale Id 5548',1500.00,0.00,0.00,2.00,240.00,'2022-12-22 14:21:03','',''),(5514,'1','285','1',1,'Retail Sale Id 5549',3000.00,0.00,0.00,4.00,480.00,'2022-12-22 14:22:05','',''),(5515,'1','285','1',1,'Retail Sale Id 5550',65660.00,0.00,0.00,98.00,3920.00,'2022-12-22 14:26:15','',''),(5516,'1','285','1',1,'Retail Sale Id 5551',6000.00,0.00,0.00,8.00,960.00,'2022-12-22 14:35:26','',''),(5517,'1','285','1',1,'Retail Sale Id 5552',1500.00,0.00,0.00,2.00,240.00,'2022-12-22 14:37:36','',''),(5518,'1','285','1',1,'Retail Sale Id 5553',1597.50,0.00,0.00,2.13,255.60,'2022-12-22 14:38:22','',''),(5519,'1','285','1',1,'Retail Sale Id 5554',3000.00,0.00,0.00,4.00,480.00,'2022-12-22 14:39:20','',''),(5520,'1','285','1',1,'Retail Sale Id 5555',1500.00,0.00,0.00,2.00,240.00,'2022-12-22 14:43:11','',''),(5521,'1','285','1',1,'Return of Retail Sale Id 5554',0.00,3000.00,4.00,0.00,-480.00,'2022-12-22 14:54:10','',''),(5522,'1','285','1',1,'Retail Sale Id 5556',1792.50,0.00,0.00,2.39,286.80,'2022-12-22 14:54:54','',''),(5523,'1','285','1',1,'Retail Sale Id 5557',4500.00,0.00,0.00,6.00,720.00,'2022-12-22 15:08:47','',''),(5524,'1','285','1',1,'Retail Sale Id 5558',802.50,0.00,0.00,1.07,128.40,'2022-12-22 15:36:31','',''),(5525,'1','285','1',1,'Retail Sale Id 5559',40709.20,0.00,0.00,60.76,2430.40,'2022-12-22 15:45:18','',''),(5526,'1','285','1',1,'Retail Sale Id 5560',6000.00,0.00,0.00,8.00,960.00,'2022-12-22 15:53:25','',''),(5527,'1','285','1',1,'Retail Sale Id 5561',3000.00,0.00,0.00,4.00,480.00,'2022-12-22 16:00:27','',''),(5528,'1','285','1',1,'Retail Sale Id 5562',12495.50,0.00,0.00,18.65,746.00,'2022-12-22 16:19:28','',''),(5529,'1','285','1',1,'Retail Sale Id 5563',750.00,0.00,0.00,1.00,120.00,'2022-12-22 16:35:34','',''),(5530,'1','285','1',1,'Retail Sale Id 5564',7500.00,0.00,0.00,10.00,1200.00,'2022-12-22 16:39:09','',''),(5531,'1','285','1',1,'Retail Sale Id 5565',33500.00,0.00,0.00,50.00,2000.00,'2022-12-22 17:01:50','',''),(5532,'1','285','1',1,'Return of Retail Sale Id 5563',0.00,750.00,1.00,0.00,-120.00,'2022-12-22 18:08:43','',''),(5533,'1','285','1',1,'Retail Sale Id 5566',405.00,0.00,0.00,0.54,64.80,'2022-12-22 18:10:24','',''),(5534,'1','285','1',1,'Return of Retail Sale Id 5562',0.00,12495.50,18.65,0.00,-746.00,'2022-12-22 18:12:49','',''),(5535,'1','285','1',1,'Retail Sale Id 5567',12073.40,0.00,0.00,18.02,720.80,'2022-12-22 18:13:57','',''),(5536,'1','285','1',1,'Retail Sale Id 5568',5497.50,0.00,0.00,7.33,879.60,'2022-12-23 07:00:05','',''),(5537,'1','285','1',1,'Retail Sale Id 5569',997.50,0.00,0.00,1.33,159.60,'2022-12-23 07:01:18','',''),(5538,'1','285','1',1,'Retail Sale Id 5570',997.50,0.00,0.00,1.33,159.60,'2022-12-23 07:02:10','',''),(5539,'1','285','1',1,'Retail Sale Id 5571',4500.00,0.00,0.00,6.00,720.00,'2022-12-23 07:12:05','',''),(5540,'1','285','1',1,'Retail Sale Id 5572',8250.00,0.00,0.00,11.00,1320.00,'2022-12-23 07:13:18','',''),(5541,'1','285','1',1,'Retail Sale Id 5573',2250.00,0.00,0.00,3.00,360.00,'2022-12-23 07:15:11','',''),(5542,'1','285','1',1,'Retail Sale Id 5574',40870.00,0.00,0.00,61.00,2440.00,'2022-12-23 07:42:14','',''),(5543,'1','285','1',1,'Retail Sale Id 5575',2250.00,0.00,0.00,3.00,360.00,'2022-12-23 07:45:19','',''),(5544,'1','285','1',1,'Retail Sale Id 5576',2250.00,0.00,0.00,3.00,360.00,'2022-12-23 07:46:07','',''),(5545,'1','285','1',1,'Retail Sale Id 5577',54940.00,0.00,0.00,82.00,3280.00,'2022-12-23 07:47:50','',''),(5546,'1','285','1',1,'Retail Sale Id 5578',16750.00,0.00,0.00,25.00,1000.00,'2022-12-23 07:52:03','',''),(5547,'1','285','1',1,'Retail Sale Id 5579',2250.00,0.00,0.00,3.00,360.00,'2022-12-23 07:54:07','',''),(5548,'1','285','1',1,'Retail Sale Id 5580',40200.00,0.00,0.00,60.00,2400.00,'2022-12-23 07:56:18','',''),(5549,'1','285','1',1,'Retail Sale Id 5582',412300.00,0.00,0.00,620.00,21700.00,'2022-12-23 08:03:26','',''),(5550,'1','285','1',1,'Retail Sale Id 5583',3750.00,0.00,0.00,5.00,600.00,'2022-12-23 08:08:38','',''),(5551,'1','285','1',1,'Retail Sale Id 5584',4500.00,0.00,0.00,6.00,720.00,'2022-12-23 10:22:12','',''),(5552,'1','285','1',1,'Retail Sale Id 5585',1500.00,0.00,0.00,2.00,240.00,'2022-12-23 10:22:58','',''),(5553,'1','285','1',1,'Retail Sale Id 5586',6330.00,0.00,0.00,8.44,1012.80,'2022-12-23 10:24:36','',''),(5554,'1','285','1',1,'Retail Sale Id 5587',2250.00,0.00,0.00,3.00,360.00,'2022-12-23 10:25:17','',''),(5555,'1','285','1',1,'Retail Sale Id 5588',9495.00,0.00,0.00,12.66,1519.20,'2022-12-23 10:26:19','',''),(5556,'1','285','1',1,'Retail Sale Id 5589',6997.50,0.00,0.00,9.33,1119.60,'2022-12-23 10:30:08','',''),(5557,'1','285','1',1,'Retail Sale Id 5590',2250.00,0.00,0.00,3.00,360.00,'2022-12-23 10:31:03','',''),(5558,'1','285','1',1,'Retail Sale Id 5591',3000.00,0.00,0.00,4.00,480.00,'2022-12-23 10:32:13','',''),(5559,'1','285','1',1,'Retail Sale Id 5592',5250.00,0.00,0.00,7.00,840.00,'2022-12-23 10:35:46','',''),(5560,'1','285','1',1,'Retail Sale Id 5593',3000.00,0.00,0.00,4.00,480.00,'2022-12-23 10:38:05','',''),(5561,'1','285','1',1,'Retail Sale Id 5594',750.00,0.00,0.00,1.00,120.00,'2022-12-23 10:39:12','',''),(5562,'1','285','1',1,'Retail Sale Id 5595',2250.00,0.00,0.00,3.00,360.00,'2022-12-23 10:39:58','',''),(5563,'1','285','1',1,'Retail Sale Id 5596',3000.00,0.00,0.00,4.00,480.00,'2022-12-23 10:40:41','',''),(5564,'1','285','1',1,'Retail Sale Id 5597',1147.50,0.00,0.00,1.53,183.60,'2022-12-23 10:41:29','',''),(5565,'1','285','1',1,'Retail Sale Id 5598',1500.00,0.00,0.00,2.00,240.00,'2022-12-23 10:42:13','',''),(5566,'1','285','1',1,'Retail Sale Id 5599',3000.00,0.00,0.00,4.00,480.00,'2022-12-23 10:42:51','',''),(5567,'1','285','1',1,'Retail Sale Id 5600',3000.00,0.00,0.00,4.00,480.00,'2022-12-23 10:43:39','',''),(5568,'1','285','1',1,'Retail Sale Id 5601',8250.00,0.00,0.00,11.00,1320.00,'2022-12-23 10:44:18','',''),(5569,'1','285','1',1,'Retail Sale Id 5602',41694.10,0.00,0.00,62.23,2489.20,'2022-12-23 10:45:45','',''),(5570,'1','285','1',1,'Retail Sale Id 5603',1200.00,0.00,0.00,1.60,192.00,'2022-12-23 10:47:09','',''),(5571,'1','285','1',1,'Retail Sale Id 5604',1500.00,0.00,0.00,2.00,240.00,'2022-12-23 10:48:39','',''),(5572,'1','285','1',1,'Retail Sale Id 5605',750.00,0.00,0.00,1.00,120.00,'2022-12-23 10:49:22','',''),(5573,'1','285','1',1,'Retail Sale Id 5606',750.00,0.00,0.00,1.00,120.00,'2022-12-23 10:52:55','',''),(5574,'1','285','1',1,'Retail Sale Id 5607',4500.00,0.00,0.00,6.00,720.00,'2022-12-23 10:54:01','',''),(5575,'1','285','1',1,'Retail Sale Id 5608',6000.00,0.00,0.00,8.00,960.00,'2022-12-23 10:54:55','',''),(5576,'1','285','1',1,'Retail Sale Id 5609',20770.00,0.00,0.00,31.00,1240.00,'2022-12-23 10:56:14','',''),(5577,'1','285','1',1,'Retail Sale Id 5610',40200.00,0.00,0.00,60.00,2400.00,'2022-12-23 10:57:09','',''),(5578,'1','285','1',1,'Retail Sale Id 5611',997.50,0.00,0.00,1.33,159.60,'2022-12-23 10:57:53','',''),(5579,'1','285','1',1,'Retail Sale Id 5612',11986.30,0.00,0.00,17.89,715.60,'2022-12-23 10:58:58','',''),(5580,'1','285','1',1,'Retail Sale Id 5613',1500.00,0.00,0.00,2.00,240.00,'2022-12-23 10:59:38','',''),(5581,'1','285','1',1,'Retail Sale Id 5614',44769.40,0.00,0.00,66.82,2672.80,'2022-12-23 11:00:37','',''),(5582,'1','285','1',1,'Retail Sale Id 5615',10003.10,0.00,0.00,14.93,597.20,'2022-12-23 11:01:35','',''),(5583,'1','285','1',1,'Retail Sale Id 5616',48240.00,0.00,0.00,72.00,2880.00,'2022-12-23 11:02:22','',''),(5584,'1','285','1',1,'Retail Sale Id 5617',16750.00,0.00,0.00,25.00,1000.00,'2022-12-23 11:03:10','',''),(5585,'1','285','1',1,'Retail Sale Id 5619',1402.50,0.00,0.00,1.87,224.40,'2022-12-23 11:06:27','',''),(5586,'1','285','1',1,'Retail Sale Id 5620',3000.00,0.00,0.00,4.00,480.00,'2022-12-23 11:15:33','',''),(5587,'1','285','1',1,'Retail Sale Id 5621',1500.00,0.00,0.00,2.00,240.00,'2022-12-23 11:16:15','',''),(5588,'1','285','1',1,'Retail Sale Id 5622',8911.00,0.00,0.00,13.30,532.00,'2022-12-23 11:17:08','',''),(5589,'1','285','1',1,'Retail Sale Id 5623',44220.00,0.00,0.00,66.00,2640.00,'2022-12-23 11:18:06','',''),(5590,'1','285','1',1,'Retail Sale Id 5624',4500.00,0.00,0.00,6.00,720.00,'2022-12-23 11:19:32','',''),(5591,'1','285','1',1,'Retail Sale Id 5625',40742.70,0.00,0.00,60.81,2432.40,'2022-12-23 11:24:00','',''),(5592,'1','285','1',1,'Retail Sale Id 5626',207700.00,0.00,0.00,310.00,12400.00,'2022-12-23 11:26:13','',''),(5593,'1','285','1',1,'Retail Sale Id 5627',1500.00,0.00,0.00,2.00,240.00,'2022-12-23 11:34:13','',''),(5594,'1','285','1',1,'Retail Sale Id 5628',1500.00,0.00,0.00,2.00,240.00,'2022-12-23 11:35:13','',''),(5595,'1','285','1',1,'Retail Sale Id 5629',4500.00,0.00,0.00,6.00,720.00,'2022-12-23 11:44:40','',''),(5596,'1','285','1',1,'Retail Sale Id 5630',3000.00,0.00,0.00,4.00,480.00,'2022-12-23 11:51:28','',''),(5597,'1','285','1',1,'Retail Sale Id 5631',40896.80,0.00,0.00,61.04,2441.60,'2022-12-23 11:55:36','',''),(5598,'1','285','1',1,'Retail Sale Id 5632',1500.00,0.00,0.00,2.00,240.00,'2022-12-23 12:00:53','',''),(5599,'1','285','1',1,'Retail Sale Id 5633',6000.00,0.00,0.00,8.00,960.00,'2022-12-23 12:02:44','',''),(5600,'1','285','1',1,'Retail Sale Id 5634',2250.00,0.00,0.00,3.00,360.00,'2022-12-23 12:03:49','',''),(5601,'1','285','1',1,'Retail Sale Id 5635',387535.40,0.00,0.00,582.76,20396.60,'2022-12-23 12:07:55','',''),(5602,'1','285','1',1,'Retail Sale Id 5636',3750.00,0.00,0.00,5.00,600.00,'2022-12-23 12:21:36','',''),(5603,'1','285','1',1,'Retail Sale Id 5637',1500.00,0.00,0.00,2.00,240.00,'2022-12-23 12:23:58','',''),(5604,'1','285','1',1,'Retail Sale Id 5638',10612.80,0.00,0.00,15.84,633.60,'2022-12-23 12:25:17','',''),(5605,'1','285','1',1,'Retail Sale Id 5639',9997.50,0.00,0.00,13.33,1599.60,'2022-12-23 12:29:07','',''),(5606,'1','285','1',1,'Retail Sale Id 5640',3000.00,0.00,0.00,4.00,480.00,'2022-12-23 12:30:30','',''),(5607,'1','285','1',1,'Retail Sale Id 5641',40200.00,0.00,0.00,60.00,2400.00,'2022-12-23 12:31:25','',''),(5608,'1','285','1',1,'Retail Sale Id 5642',1500.00,0.00,0.00,2.00,240.00,'2022-12-23 12:35:38','',''),(5609,'1','285','1',1,'Retail Sale Id 5643',10003.10,0.00,0.00,14.93,597.20,'2022-12-23 13:02:52','',''),(5610,'1','285','1',1,'Retail Sale Id 5644',1500.00,0.00,0.00,2.00,240.00,'2022-12-23 13:04:30','',''),(5611,'1','285','1',1,'Retail Sale Id 5645',9375.00,0.00,0.00,12.50,1500.00,'2022-12-23 13:09:28','',''),(5612,'1','285','1',1,'Retail Sale Id 5646',4875.00,0.00,0.00,6.50,780.00,'2022-12-23 13:28:05','',''),(5613,'1','285','1',1,'Retail Sale Id 5647',44722.50,0.00,0.00,66.75,2670.00,'2022-12-23 13:30:14','',''),(5614,'1','285','1',1,'Retail Sale Id 5648',40669.00,0.00,0.00,60.70,2428.00,'2022-12-23 13:36:10','',''),(5615,'1','285','1',1,'Retail Sale Id 5649',2250.00,0.00,0.00,3.00,360.00,'2022-12-23 13:40:33','',''),(5616,'1','285','1',1,'Retail Sale Id 5650',1500.00,0.00,0.00,2.00,240.00,'2022-12-23 14:07:14','',''),(5617,'1','285','1',1,'Retail Sale Id 5651',3750.00,0.00,0.00,5.00,600.00,'2022-12-23 14:09:34','',''),(5618,'1','285','1',1,'Retail Sale Id 5652',3000.00,0.00,0.00,4.00,480.00,'2022-12-23 14:24:08','',''),(5619,'1','285','1',1,'Retail Sale Id 5654',2250.00,0.00,0.00,3.00,360.00,'2022-12-23 14:40:31','',''),(5620,'1','285','1',1,'Retail Sale Id 5653',9000.00,0.00,0.00,12.00,1440.00,'2022-12-23 14:44:50','',''),(5621,'1','285','1',1,'Retail Sale Id 5655',40662.30,0.00,0.00,60.69,2427.60,'2022-12-23 14:46:21','',''),(5622,'1','285','1',1,'Retail Sale Id 5656',41037.50,0.00,0.00,61.25,2450.00,'2022-12-23 15:02:24','',''),(5623,'1','285','1',1,'Retail Sale Id 5657',7500.00,0.00,0.00,10.00,1200.00,'2022-12-23 15:14:49','',''),(5624,'1','285','1',1,'Retail Sale Id 5658',40200.00,0.00,0.00,60.00,2400.00,'2022-12-23 15:17:47','',''),(5625,'1','285','1',1,'Return of Retail Sale Id 5658',0.00,40200.00,60.00,0.00,-2400.00,'2022-12-23 15:23:26','',''),(5626,'1','285','1',1,'Retail Sale Id 5659',39952.10,0.00,0.00,59.63,2385.20,'2022-12-23 15:24:16','',''),(5627,'1','285','1',1,'Retail Sale Id 5660',7500.00,0.00,0.00,10.00,1200.00,'2022-12-23 15:27:37','',''),(5628,'1','285','1',1,'Retail Sale Id 5661',32099.70,0.00,0.00,47.91,1916.40,'2022-12-23 15:29:49','',''),(5629,'1','285','1',1,'Retail Sale Id 5662',3000.00,0.00,0.00,4.00,480.00,'2022-12-23 15:37:42','',''),(5630,'1','285','1',1,'Retail Sale Id 5663',2250.00,0.00,0.00,3.00,360.00,'2022-12-23 15:38:49','',''),(5631,'1','285','1',1,'Retail Sale Id 5664',2250.00,0.00,0.00,3.00,360.00,'2022-12-23 15:39:52','',''),(5632,'1','285','1',1,'Retail Sale Id 5665',2250.00,0.00,0.00,3.00,360.00,'2022-12-23 15:56:16','',''),(5633,'1','285','1',1,'Retail Sale Id 5666',2002.50,0.00,0.00,2.67,320.40,'2022-12-23 15:57:29','',''),(5634,'1','285','1',1,'Retail Sale Id 5667',750.00,0.00,0.00,1.00,120.00,'2022-12-23 16:03:44','',''),(5635,'1','285','1',1,'Retail Sale Id 5668',3000.00,0.00,0.00,4.00,480.00,'2022-12-23 16:08:33','',''),(5636,'1','285','1',1,'Retail Sale Id 5669',2250.00,0.00,0.00,3.00,360.00,'2022-12-23 16:12:59','',''),(5637,'1','285','1',1,'Return of Retail Sale Id 5668',0.00,3000.00,4.00,0.00,-480.00,'2022-12-23 16:14:33','',''),(5638,'1','285','1',1,'Retail Sale Id 5670',2392.50,0.00,0.00,3.19,382.80,'2022-12-23 16:15:28','',''),(5639,'1','285','1',1,'Retail Sale Id 5671',802.50,0.00,0.00,1.07,128.40,'2022-12-23 16:20:35','',''),(5640,'1','285','1',1,'Retail Sale Id 5672',42210.00,0.00,0.00,63.00,2520.00,'2022-12-23 16:21:38','',''),(5641,'1','285','1',1,'Retail Sale Id 5673',1500.00,0.00,0.00,2.00,240.00,'2022-12-23 16:23:51','',''),(5642,'1','285','1',1,'Retail Sale Id 5674',802.50,0.00,0.00,1.07,128.40,'2022-12-23 16:25:04','',''),(5643,'1','285','1',1,'Retail Sale Id 5675',1500.00,0.00,0.00,2.00,240.00,'2022-12-23 16:26:13','',''),(5644,'1','285','1',1,'Retail Sale Id 5676',1500.00,0.00,0.00,2.00,240.00,'2022-12-23 16:27:22','',''),(5645,'1','285','1',1,'Retail Sale Id 5677',1500.00,0.00,0.00,2.00,240.00,'2022-12-23 16:30:15','',''),(5646,'1','285','1',1,'Retail Sale Id 5678',11758.50,0.00,0.00,17.55,702.00,'2022-12-23 16:31:52','',''),(5647,'1','285','1',1,'Retail Sale Id 5679',5250.00,0.00,0.00,7.00,840.00,'2022-12-23 16:35:45','',''),(5648,'1','285','1',1,'Retail Sale Id 5680',1500.00,0.00,0.00,2.00,240.00,'2022-12-23 16:37:23','',''),(5649,'1','285','1',1,'Retail Sale Id 5681',5250.00,0.00,0.00,7.00,840.00,'2022-12-23 16:38:41','',''),(5650,'1','285','1',1,'Retail Sale Id 5682',3750.00,0.00,0.00,5.00,600.00,'2022-12-23 16:41:45','',''),(5651,'1','285','1',1,'Retail Sale Id 5683',3000.00,0.00,0.00,4.00,480.00,'2022-12-23 16:42:46','',''),(5652,'1','285','1',1,'Retail Sale Id 5684',1500.00,0.00,0.00,2.00,240.00,'2022-12-23 16:47:02','',''),(5653,'1','285','1',1,'Retail Sale Id 5685',7500.00,0.00,0.00,10.00,1200.00,'2022-12-23 16:48:00','',''),(5654,'1','285','1',1,'Retail Sale Id 5686',10500.00,0.00,0.00,14.00,1680.00,'2022-12-23 16:50:54','',''),(5655,'1','285','1',1,'Retail Sale Id 5687',5250.00,0.00,0.00,7.00,840.00,'2022-12-23 16:53:27','',''),(5656,'1','285','1',1,'Retail Sale Id 5688',28140.00,0.00,0.00,42.00,1680.00,'2022-12-23 16:54:59','',''),(5657,'1','285','1',1,'Retail Sale Id 5689',3750.00,0.00,0.00,5.00,600.00,'2022-12-23 16:58:34','',''),(5658,'1','285','1',1,'Retail Sale Id 5690',2992.50,0.00,0.00,3.99,478.80,'2022-12-23 19:04:22','',''),(5659,'1','285','1',1,'Retail Sale Id 5691',89572.30,0.00,0.00,133.69,5347.60,'2022-12-23 19:07:12','',''),(5660,'1','285','1',1,'Retail Sale Id 5692',281400.00,0.00,0.00,420.00,16800.00,'2022-12-24 06:29:38','',''),(5661,'1','285','1',1,'Retail Sale Id 5693',40870.00,0.00,0.00,61.00,2440.00,'2022-12-24 06:31:38','',''),(5662,'1','285','1',1,'Retail Sale Id 5694',3000.00,0.00,0.00,4.00,480.00,'2022-12-24 07:03:20','',''),(5663,'1','285','1',1,'Retail Sale Id 5695',3000.00,0.00,0.00,4.00,480.00,'2022-12-24 07:14:39','',''),(5664,'1','285','1',1,'Retail Sale Id 5696',1500.00,0.00,0.00,2.00,240.00,'2022-12-24 07:15:26','',''),(5665,'1','285','1',1,'Retail Sale Id 5697',2002.50,0.00,0.00,2.67,320.40,'2022-12-24 07:23:15','',''),(5666,'1','285','1',1,'Retail Sale Id 5698',1500.00,0.00,0.00,2.00,240.00,'2022-12-24 07:24:17','',''),(5667,'1','285','1',1,'Retail Sale Id 5699',5250.00,0.00,0.00,7.00,840.00,'2022-12-24 07:28:52','',''),(5668,'1','285','1',1,'Retail Sale Id 5700',13400.00,0.00,0.00,20.00,800.00,'2022-12-24 07:32:08','',''),(5669,'1','285','1',1,'Retail Sale Id 5701',9750.00,0.00,0.00,13.00,1560.00,'2022-12-24 07:39:48','',''),(5670,'1','285','1',1,'Retail Sale Id 5702',802.50,0.00,0.00,1.07,128.40,'2022-12-24 07:50:04','',''),(5671,'1','285','1',1,'Retail Sale Id 5703',6000.00,0.00,0.00,8.00,960.00,'2022-12-24 07:55:19','',''),(5672,'1','285','1',1,'Retail Sale Id 5704',4500.00,0.00,0.00,6.00,720.00,'2022-12-24 07:57:38','',''),(5673,'1','285','1',1,'Return of Retail Sale Id 5703',0.00,6000.00,8.00,0.00,-960.00,'2022-12-24 08:02:58','',''),(5674,'1','285','1',1,'Retail Sale Id 5705',5715.00,0.00,0.00,7.62,914.40,'2022-12-24 08:03:46','',''),(5675,'1','285','1',1,'Retail Sale Id 5706',9000.00,0.00,0.00,12.00,1440.00,'2022-12-24 08:06:52','',''),(5676,'1','285','1',1,'Retail Sale Id 5707',2250.00,0.00,0.00,3.00,360.00,'2022-12-24 08:10:55','',''),(5677,'1','285','1',1,'Return of Retail Sale Id 5707',0.00,2250.00,3.00,0.00,-360.00,'2022-12-24 08:58:41','',''),(5678,'1','285','1',1,'Distributed to AA RANO NIGERIA LTD for sales id:6',47313.00,0.00,0.00,75.10,0.00,'2022-12-24 09:12:45','',''),(5679,'1','285',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,11108790.00,17633.00,0.00,0.00,'2022-12-24 10:00:44','',''),(5680,'1','285',NULL,1,'Reception corrector for bridging 8',0.00,0.00,0.00,17633.00,0.00,'2022-12-24 10:03:18','',''),(5681,'1','285','1',1,'Received from bridging 8',0.00,0.00,17633.00,0.00,0.00,'2022-12-24 10:03:18','',''),(5682,'1','285','1',1,'Retail Sale Id 5708',123749.00,0.00,0.00,184.70,7388.00,'2022-12-24 10:22:21','',''),(5683,'1','285','1',1,'Retail Sale Id 5709',121243.20,0.00,0.00,180.96,7238.40,'2022-12-24 10:23:57','',''),(5684,'1','285','1',1,'Retail Sale Id 5710',90436.60,0.00,0.00,134.98,5399.20,'2022-12-24 10:24:58','',''),(5685,'1','285','1',1,'Retail Sale Id 5711',41318.90,0.00,0.00,61.67,2466.80,'2022-12-24 10:27:10','',''),(5686,'1','285','1',1,'Retail Sale Id 5712',81927.60,0.00,0.00,122.28,4891.20,'2022-12-24 10:30:23','',''),(5687,'1','285','1',1,'Retail Sale Id 5713',16743.30,0.00,0.00,24.99,999.60,'2022-12-24 10:32:46','',''),(5688,'1','285','1',1,'Retail Sale Id 5714',1500.00,0.00,0.00,2.00,240.00,'2022-12-24 10:34:09','',''),(5689,'1','285','1',1,'Retail Sale Id 5715',33500.00,0.00,0.00,50.00,2000.00,'2022-12-24 10:35:20','',''),(5690,'1','285','1',1,'Retail Sale Id 5716',20100.00,0.00,0.00,30.00,1200.00,'2022-12-24 10:36:41','',''),(5691,'1','285','1',1,'Retail Sale Id 5717',750.00,0.00,0.00,1.00,120.00,'2022-12-24 10:38:15','',''),(5692,'1','285','1',1,'Retail Sale Id 5718',18000.00,0.00,0.00,24.00,2880.00,'2022-12-24 10:39:14','',''),(5693,'1','285','1',1,'Retail Sale Id 5719',97552.00,0.00,0.00,145.60,5824.00,'2022-12-24 10:41:01','',''),(5694,'1','285','1',1,'Retail Sale Id 5720',1500.00,0.00,0.00,2.00,240.00,'2022-12-24 10:44:53','',''),(5695,'1','285','1',1,'Retail Sale Id 5721',1500.00,0.00,0.00,2.00,240.00,'2022-12-24 10:45:38','',''),(5696,'1','285','1',1,'Retail Sale Id 5722',1500.00,0.00,0.00,2.00,240.00,'2022-12-24 10:46:21','',''),(5697,'1','285','1',1,'Retail Sale Id 5723',33600.50,0.00,0.00,50.15,2006.00,'2022-12-24 10:47:21','',''),(5698,'1','285','1',1,'Retail Sale Id 5724',3000.00,0.00,0.00,4.00,480.00,'2022-12-24 10:49:12','',''),(5699,'1','285','1',1,'Retail Sale Id 5725',5250.00,0.00,0.00,7.00,840.00,'2022-12-24 10:50:05','',''),(5700,'1','285','1',1,'Retail Sale Id 5726',1500.00,0.00,0.00,2.00,240.00,'2022-12-24 10:50:58','',''),(5701,'1','285','1',1,'Retail Sale Id 5727',127628.30,0.00,0.00,190.49,7619.60,'2022-12-24 10:52:16','',''),(5702,'1','285','1',1,'Retail Sale Id 5728',2250.00,0.00,0.00,3.00,360.00,'2022-12-24 10:53:05','',''),(5703,'1','285','1',1,'Retail Sale Id 5729',3000.00,0.00,0.00,4.00,480.00,'2022-12-24 10:53:54','',''),(5704,'1','285','1',1,'Retail Sale Id 5730',2002.50,0.00,0.00,2.67,320.40,'2022-12-24 10:54:49','',''),(5705,'1','285','1',1,'Retail Sale Id 5731',3750.00,0.00,0.00,5.00,600.00,'2022-12-24 10:55:31','',''),(5706,'1','285','1',1,'Retail Sale Id 5732',82477.00,0.00,0.00,123.10,4924.00,'2022-12-24 10:57:26','',''),(5707,'1','285','1',1,'Return of Retail Sale Id 5732',0.00,82477.00,123.10,0.00,-4924.00,'2022-12-24 10:59:22','',''),(5708,'1','285','1',1,'Retail Sale Id 5733',81861.50,0.00,0.00,123.10,4308.50,'2022-12-24 11:00:19','',''),(5709,'1','285','1',1,'Retail Sale Id 5734',5250.00,0.00,0.00,7.00,840.00,'2022-12-24 11:05:26','',''),(5710,'1','285','1',1,'Retail Sale Id 5735',9728.40,0.00,0.00,14.52,580.80,'2022-12-24 11:07:14','',''),(5711,'1','285','1',1,'Retail Sale Id 5736',6000.00,0.00,0.00,8.00,960.00,'2022-12-24 11:08:46','',''),(5712,'1','285','1',1,'Retail Sale Id 5737',3000.00,0.00,0.00,4.00,480.00,'2022-12-24 11:10:05','',''),(5713,'1','285','1',1,'Retail Sale Id 5739',446600.70,0.00,0.00,671.58,23505.30,'2022-12-24 11:21:19','',''),(5714,'1','285','1',1,'Retail Sale Id 5740',2002.50,0.00,0.00,2.67,320.40,'2022-12-24 11:32:20','',''),(5715,'1','285','1',1,'Retail Sale Id 5741',49265.10,0.00,0.00,73.53,2941.20,'2022-12-24 11:33:27','',''),(5716,'1','285','1',1,'Retail Sale Id 5742',872772.60,0.00,0.00,1312.44,45935.40,'2022-12-24 11:41:40','',''),(5717,'1','285','1',1,'Retail Sale Id 5743',3750.00,0.00,0.00,5.00,600.00,'2022-12-24 11:55:28','',''),(5718,'1','285','1',1,'Retail Sale Id 5744',3750.00,0.00,0.00,5.00,600.00,'2022-12-24 11:56:38','',''),(5719,'1','285','1',1,'Retail Sale Id 5745',997.50,0.00,0.00,1.33,159.60,'2022-12-24 11:58:10','',''),(5720,'1','285','1',1,'Retail Sale Id 5746',82142.00,0.00,0.00,122.60,4904.00,'2022-12-24 12:02:09','',''),(5721,'1','285','1',1,'Retail Sale Id 5747',71502.40,0.00,0.00,106.72,4268.80,'2022-12-24 12:04:52','',''),(5722,'1','285','1',1,'Retail Sale Id 5748',81418.40,0.00,0.00,121.52,4860.80,'2022-12-24 12:09:11','',''),(5723,'1','285','1',1,'Retail Sale Id 5749',3802.50,0.00,0.00,5.07,608.40,'2022-12-24 12:14:53','',''),(5724,'1','285','1',1,'Retail Sale Id 5750',1500.00,0.00,0.00,2.00,240.00,'2022-12-24 12:16:05','',''),(5725,'1','285','1',1,'Retail Sale Id 5751',4500.00,0.00,0.00,6.00,720.00,'2022-12-24 12:18:22','',''),(5726,'1','285','1',1,'Retail Sale Id 5752',40200.00,0.00,0.00,60.00,2400.00,'2022-12-24 12:21:15','',''),(5727,'1','285','1',1,'Retail Sale Id 5753',9375.00,0.00,0.00,12.50,1500.00,'2022-12-24 12:25:53','',''),(5728,'1','285','1',1,'Retail Sale Id 5754',997.50,0.00,0.00,1.33,159.60,'2022-12-24 12:27:12','',''),(5729,'1','285','1',1,'Retail Sale Id 5755',1500.00,0.00,0.00,2.00,240.00,'2022-12-24 12:28:23','',''),(5730,'1','285','1',1,'Retail Sale Id 5756',75100.30,0.00,0.00,112.09,4483.60,'2022-12-24 12:39:15','',''),(5731,'1','285','1',1,'Retail Sale Id 5757',10720.00,0.00,0.00,16.00,640.00,'2022-12-24 12:50:29','',''),(5732,'1','285','1',1,'Retail Sale Id 5758',1500.00,0.00,0.00,2.00,240.00,'2022-12-24 12:51:20','',''),(5733,'1','285','1',1,'Retail Sale Id 5759',802.50,0.00,0.00,1.07,128.40,'2022-12-24 12:52:11','',''),(5734,'1','285','1',1,'Retail Sale Id 5760',2250.00,0.00,0.00,3.00,360.00,'2022-12-24 12:53:33','',''),(5735,'1','285','1',1,'Retail Sale Id 5761',2250.00,0.00,0.00,3.00,360.00,'2022-12-24 12:56:10','',''),(5736,'1','285','1',1,'Retail Sale Id 5762',4500.00,0.00,0.00,6.00,720.00,'2022-12-24 12:57:14','',''),(5737,'1','285','1',1,'Retail Sale Id 5763',1500.00,0.00,0.00,2.00,240.00,'2022-12-24 12:59:17','',''),(5738,'1','285','1',1,'Retail Sale Id 5764',1500.00,0.00,0.00,2.00,240.00,'2022-12-24 13:00:09','',''),(5739,'1','285','1',1,'Retail Sale Id 5765',40200.00,0.00,0.00,60.00,2400.00,'2022-12-24 13:01:20','',''),(5740,'1','285','1',1,'Retail Sale Id 5766',33500.00,0.00,0.00,50.00,2000.00,'2022-12-24 13:04:12','',''),(5741,'1','285','1',1,'Retail Sale Id 5767',1597.50,0.00,0.00,2.13,255.60,'2022-12-24 13:07:29','',''),(5742,'1','285','1',1,'Retail Sale Id 5768',7500.00,0.00,0.00,10.00,1200.00,'2022-12-24 13:11:32','',''),(5743,'1','285','1',1,'Retail Sale Id 5769',20100.00,0.00,0.00,30.00,1200.00,'2022-12-24 13:13:24','',''),(5744,'1','285','1',1,'Retail Sale Id 5770',161309.20,0.00,0.00,240.76,9630.40,'2022-12-24 13:32:23','',''),(5745,'1','285','1',1,'Retail Sale Id 5771',3000.00,0.00,0.00,4.00,480.00,'2022-12-24 13:34:43','',''),(5746,'1','285','1',1,'Retail Sale Id 5772',1500.00,0.00,0.00,2.00,240.00,'2022-12-24 13:35:43','',''),(5747,'1','285','1',1,'Retail Sale Id 5773',44983.80,0.00,0.00,67.14,2685.60,'2022-12-24 13:39:02','',''),(5748,'1','285','1',1,'Retail Sale Id 5774',2250.00,0.00,0.00,3.00,360.00,'2022-12-24 13:41:18','',''),(5749,'1','285','1',1,'Retail Sale Id 5775',1500.00,0.00,0.00,2.00,240.00,'2022-12-24 13:45:20','',''),(5750,'1','285','1',1,'Retail Sale Id 5776',3000.00,0.00,0.00,4.00,480.00,'2022-12-24 13:50:44','',''),(5751,'1','285','1',1,'Retail Sale Id 5777',21748.20,0.00,0.00,32.46,1298.40,'2022-12-24 13:52:16','',''),(5752,'1','285','1',1,'Retail Sale Id 5778',3802.50,0.00,0.00,5.07,608.40,'2022-12-24 14:03:02','',''),(5753,'1','285','1',1,'Retail Sale Id 5779',6000.00,0.00,0.00,8.00,960.00,'2022-12-24 14:06:36','',''),(5754,'1','285','1',1,'Retail Sale Id 5780',44890.00,0.00,0.00,67.00,2680.00,'2022-12-24 14:09:19','',''),(5755,'1','285','1',1,'Retail Sale Id 5781',11617.80,0.00,0.00,17.34,693.60,'2022-12-24 14:13:28','',''),(5756,'1','285','1',1,'Retail Sale Id 5782',2002.50,0.00,0.00,2.67,320.40,'2022-12-24 14:15:03','',''),(5757,'1','285','1',1,'Return of Retail Sale Id 5779',0.00,6000.00,8.00,0.00,-960.00,'2022-12-24 14:16:13','',''),(5758,'1','285','1',1,'Retail Sale Id 5783',5625.00,0.00,0.00,7.50,900.00,'2022-12-24 14:17:47','',''),(5759,'1','285','1',1,'Retail Sale Id 5784',1500.00,0.00,0.00,2.00,240.00,'2022-12-24 14:19:21','',''),(5760,'1','285','1',1,'Retail Sale Id 5785',11250.00,0.00,0.00,15.00,1800.00,'2022-12-24 14:21:03','',''),(5761,'1','285','1',1,'Retail Sale Id 5786',1500.00,0.00,0.00,2.00,240.00,'2022-12-24 14:22:07','',''),(5762,'1','285','1',1,'Retail Sale Id 5787',4500.00,0.00,0.00,6.00,720.00,'2022-12-24 14:23:09','',''),(5763,'1','285','1',1,'Retail Sale Id 5788',3000.00,0.00,0.00,4.00,480.00,'2022-12-24 14:28:20','',''),(5764,'1','285','1',1,'Retail Sale Id 5789',3000.00,0.00,0.00,4.00,480.00,'2022-12-24 14:29:33','',''),(5765,'1','285','1',1,'Retail Sale Id 5790',2250.00,0.00,0.00,3.00,360.00,'2022-12-24 14:30:29','',''),(5766,'1','285','1',1,'Retail Sale Id 5791',750.00,0.00,0.00,1.00,120.00,'2022-12-24 14:31:48','',''),(5767,'1','285','1',1,'Retail Sale Id 5792',40769.50,0.00,0.00,60.85,2434.00,'2022-12-24 14:46:10','',''),(5768,'1','285','1',1,'Retail Sale Id 5793',241200.00,0.00,0.00,360.00,14400.00,'2022-12-24 14:51:38','',''),(5769,'1','285','1',1,'Retail Sale Id 5794',3000.00,0.00,0.00,4.00,480.00,'2022-12-24 14:57:00','',''),(5770,'1','285','1',1,'Retail Sale Id 5795',1500.00,0.00,0.00,2.00,240.00,'2022-12-24 15:04:43','',''),(5771,'1','285','1',1,'Retail Sale Id 5796',2250.00,0.00,0.00,3.00,360.00,'2022-12-24 15:05:39','',''),(5772,'1','285','1',1,'Retail Sale Id 5797',168009.20,0.00,0.00,250.76,10030.40,'2022-12-24 15:07:41','',''),(5773,'1','285','1',1,'Retail Sale Id 5798',4500.00,0.00,0.00,6.00,720.00,'2022-12-24 15:09:02','',''),(5774,'1','285','1',1,'Return of Retail Sale Id 5770',0.00,161309.20,240.76,0.00,-9630.40,'2022-12-24 15:16:11','',''),(5775,'1','285','1',1,'Retail Sale Id 5799',4500.00,0.00,0.00,6.00,720.00,'2022-12-24 15:17:11','',''),(5776,'1','285','1',1,'Retail Sale Id 5800',4500.00,0.00,0.00,6.00,720.00,'2022-12-24 15:18:16','',''),(5777,'1','285','1',1,'Retail Sale Id 5801',750.00,0.00,0.00,1.00,120.00,'2022-12-24 15:19:14','',''),(5778,'1','285','1',1,'Retail Sale Id 5802',750.00,0.00,0.00,1.00,120.00,'2022-12-24 15:20:01','',''),(5779,'1','285','1',1,'Retail Sale Id 5803',602676.20,0.00,0.00,906.28,31719.80,'2022-12-24 15:25:24','',''),(5780,'1','285','1',1,'Retail Sale Id 5804',40675.70,0.00,0.00,60.71,2428.40,'2022-12-24 15:30:12','',''),(5781,'1','285','1',1,'Retail Sale Id 5805',3000.00,0.00,0.00,4.00,480.00,'2022-12-24 15:33:09','',''),(5782,'1','285','1',1,'Retail Sale Id 5806',23235.60,0.00,0.00,34.68,1387.20,'2022-12-24 15:38:01','',''),(5783,'1','285','1',1,'Retail Sale Id 5807',33466.50,0.00,0.00,49.95,1998.00,'2022-12-24 15:41:46','',''),(5784,'1','285','1',1,'Retail Sale Id 5808',750.00,0.00,0.00,1.00,120.00,'2022-12-24 15:49:32','',''),(5785,'1','285','1',1,'Retail Sale Id 5809',2902.50,0.00,0.00,3.87,464.40,'2022-12-24 15:50:28','',''),(5786,'1','285','1',1,'Retail Sale Id 5810',9822.20,0.00,0.00,14.66,586.40,'2022-12-24 15:51:37','',''),(5787,'1','285','1',1,'Retail Sale Id 5811',1500.00,0.00,0.00,2.00,240.00,'2022-12-24 15:52:33','',''),(5788,'1','285','1',1,'Retail Sale Id 5812',19677.90,0.00,0.00,29.37,1174.80,'2022-12-24 15:53:43','',''),(5789,'1','285','1',1,'Retail Sale Id 5813',3000.00,0.00,0.00,4.00,480.00,'2022-12-24 15:55:30','',''),(5790,'1','285','1',1,'Retail Sale Id 5814',4500.00,0.00,0.00,6.00,720.00,'2022-12-24 15:56:23','',''),(5791,'1','285','1',1,'Retail Sale Id 5815',33500.00,0.00,0.00,50.00,2000.00,'2022-12-24 15:57:42','',''),(5792,'1','285','1',1,'Retail Sale Id 5816',1500.00,0.00,0.00,2.00,240.00,'2022-12-24 15:58:58','',''),(5793,'1','285','1',1,'Retail Sale Id 5817',3000.00,0.00,0.00,4.00,480.00,'2022-12-24 15:59:41','',''),(5794,'1','285','1',1,'Retail Sale Id 5818',1500.00,0.00,0.00,2.00,240.00,'2022-12-24 16:00:41','',''),(5795,'1','285','1',1,'Retail Sale Id 5819',4500.00,0.00,0.00,6.00,720.00,'2022-12-24 16:01:28','',''),(5796,'1','285','1',1,'Retail Sale Id 5820',1500.00,0.00,0.00,2.00,240.00,'2022-12-24 16:02:24','',''),(5797,'1','285','1',1,'Retail Sale Id 5821',750.00,0.00,0.00,1.00,120.00,'2022-12-24 16:03:35','',''),(5798,'1','285','1',1,'Retail Sale Id 5822',6000.00,0.00,0.00,8.00,960.00,'2022-12-24 16:04:39','',''),(5799,'1','285','1',1,'Retail Sale Id 5823',1500.00,0.00,0.00,2.00,240.00,'2022-12-24 16:05:33','',''),(5800,'1','285','1',1,'Retail Sale Id 5824',1500.00,0.00,0.00,2.00,240.00,'2022-12-24 16:07:59','',''),(5801,'1','285','1',1,'Retail Sale Id 5825',207480.00,0.00,0.00,312.00,10920.00,'2022-12-24 16:12:15','',''),(5802,'1','285','1',1,'Retail Sale Id 5826',1500.00,0.00,0.00,2.00,240.00,'2022-12-24 16:14:31','',''),(5803,'1','285','1',1,'Retail Sale Id 5827',750.00,0.00,0.00,1.00,120.00,'2022-12-24 16:15:22','',''),(5804,'1','285','1',1,'Retail Sale Id 5828',4500.00,0.00,0.00,6.00,720.00,'2022-12-24 16:17:05','',''),(5805,'1','285','1',1,'Retail Sale Id 5829',50638.60,0.00,0.00,75.58,3023.20,'2022-12-24 16:19:13','',''),(5806,'1','285','1',1,'Retail Sale Id 5830',1500.00,0.00,0.00,2.00,240.00,'2022-12-24 16:22:35','',''),(5807,'1','285','1',1,'Retail Sale Id 5831',997.50,0.00,0.00,1.33,159.60,'2022-12-24 16:24:51','',''),(5808,'1','285','1',1,'Retail Sale Id 5832',3000.00,0.00,0.00,4.00,480.00,'2022-12-24 16:25:38','',''),(5809,'1','285','1',1,'Retail Sale Id 5833',3000.00,0.00,0.00,4.00,480.00,'2022-12-24 16:26:21','',''),(5810,'1','285','1',1,'Retail Sale Id 5834',2250.00,0.00,0.00,3.00,360.00,'2022-12-24 16:29:40','',''),(5811,'1','285','1',1,'Retail Sale Id 5835',5250.00,0.00,0.00,7.00,840.00,'2022-12-24 16:33:26','',''),(5812,'1','285','1',1,'Retail Sale Id 5836',1500.00,0.00,0.00,2.00,240.00,'2022-12-24 16:34:50','',''),(5813,'1','285','1',1,'Retail Sale Id 5837',280388.30,0.00,0.00,418.49,16739.60,'2022-12-24 16:39:16','',''),(5814,'1','285','1',1,'Retail Sale Id 5838',3000.00,0.00,0.00,4.00,480.00,'2022-12-24 16:41:13','',''),(5815,'1','285','1',1,'Return of Retail Sale Id 5837',0.00,280388.30,418.49,0.00,-16739.60,'2022-12-24 16:42:18','',''),(5816,'1','285','1',1,'Retail Sale Id 5839',278295.85,0.00,0.00,418.49,14647.15,'2022-12-24 16:43:15','',''),(5817,'1','285','1',1,'Retail Sale Id 5840',82081.70,0.00,0.00,122.51,4900.40,'2022-12-24 17:06:24','',''),(5818,'1','285','1',1,'Retail Sale Id 5841',408968.00,0.00,0.00,610.40,24416.00,'2022-12-24 17:21:56','',''),(5819,'1','285','1',1,'Retail Sale Id 5842',3000.00,0.00,0.00,4.00,480.00,'2022-12-24 17:49:10','',''),(5820,'1','285','1',1,'Return of Retail Sale Id 5842',0.00,3000.00,4.00,0.00,-480.00,'2022-12-24 17:55:14','',''),(5821,'1','285','1',1,'Retail Sale Id 5843',2680.00,0.00,0.00,4.00,160.00,'2022-12-24 17:55:55','',''),(5822,'1','285','1',1,'Retail Sale Id 5844',98392.50,0.00,0.00,131.19,15742.80,'2022-12-24 19:20:00','',''),(5823,'1','285','1',1,'Retail Sale Id 5845',679627.90,0.00,0.00,1014.37,40574.80,'2022-12-24 19:27:47','',''),(5824,'1','285','1',1,'Retail Sale Id 5846',13400.00,0.00,0.00,20.00,800.00,'2022-12-24 19:34:42','',''),(5825,'1','285','1',1,'Retail Sale Id 5847',2250.00,0.00,0.00,3.00,360.00,'2022-12-25 07:08:31','',''),(5826,'1','285','1',1,'Retail Sale Id 5848',2002.50,0.00,0.00,2.67,320.40,'2022-12-25 07:09:29','',''),(5827,'1','285','1',1,'Retail Sale Id 5849',750.00,0.00,0.00,1.00,120.00,'2022-12-25 07:10:30','',''),(5828,'1','285','1',1,'Retail Sale Id 5850',2002.50,0.00,0.00,2.67,320.40,'2022-12-25 07:11:33','',''),(5829,'1','285','1',1,'Retail Sale Id 5851',750.00,0.00,0.00,1.00,120.00,'2022-12-25 07:12:48','',''),(5830,'1','285','1',1,'Retail Sale Id 5852',802.50,0.00,0.00,1.07,128.40,'2022-12-25 07:14:57','',''),(5831,'1','285','1',1,'Retail Sale Id 5853',2250.00,0.00,0.00,3.00,360.00,'2022-12-25 07:16:35','',''),(5832,'1','285','1',1,'Retail Sale Id 5854',750.00,0.00,0.00,1.00,120.00,'2022-12-25 07:17:36','',''),(5833,'1','285','1',1,'Retail Sale Id 5855',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 07:19:07','',''),(5834,'1','285','1',1,'Retail Sale Id 5856',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 07:19:58','',''),(5835,'1','285','1',1,'Retail Sale Id 5857',40488.10,0.00,0.00,60.43,2417.20,'2022-12-25 07:22:01','',''),(5836,'1','285','1',1,'Retail Sale Id 5858',41493.10,0.00,0.00,61.93,2477.20,'2022-12-25 07:24:17','',''),(5837,'1','285','1',1,'Retail Sale Id 5859',3000.00,0.00,0.00,4.00,480.00,'2022-12-25 07:27:00','',''),(5838,'1','285','1',1,'Retail Sale Id 5860',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 07:28:05','',''),(5839,'1','285','1',1,'Retail Sale Id 5861',2250.00,0.00,0.00,3.00,360.00,'2022-12-25 07:28:49','',''),(5840,'1','285','1',1,'Retail Sale Id 5862',32769.70,0.00,0.00,48.91,1956.40,'2022-12-25 07:31:26','',''),(5841,'1','285','1',1,'Retail Sale Id 5863',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 07:32:49','',''),(5842,'1','285','1',1,'Retail Sale Id 5864',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 07:33:41','',''),(5843,'1','285','1',1,'Retail Sale Id 5865',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 07:34:26','',''),(5844,'1','285','1',1,'Retail Sale Id 5866',6000.00,0.00,0.00,8.00,960.00,'2022-12-25 07:35:13','',''),(5845,'1','285','1',1,'Retail Sale Id 5867',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 07:36:37','',''),(5846,'1','285','1',1,'Retail Sale Id 5868',83348.00,0.00,0.00,124.40,4976.00,'2022-12-25 07:38:02','',''),(5847,'1','285','1',1,'Retail Sale Id 5869',41285.40,0.00,0.00,61.62,2464.80,'2022-12-25 07:42:35','',''),(5848,'1','285','1',1,'Retail Sale Id 5870',16415.00,0.00,0.00,24.50,980.00,'2022-12-25 07:45:55','',''),(5849,'1','285','1',1,'Retail Sale Id 5871',750.00,0.00,0.00,1.00,120.00,'2022-12-25 07:47:26','',''),(5850,'1','285','1',1,'Retail Sale Id 5872',2250.00,0.00,0.00,3.00,360.00,'2022-12-25 07:48:19','',''),(5851,'1','285','1',1,'Retail Sale Id 5873',750.00,0.00,0.00,1.00,120.00,'2022-12-25 07:49:25','',''),(5852,'1','285','1',1,'Retail Sale Id 5874',4500.00,0.00,0.00,6.00,720.00,'2022-12-25 07:50:31','',''),(5853,'1','285','1',1,'Retail Sale Id 5875',50363.90,0.00,0.00,75.17,3006.80,'2022-12-25 07:52:16','',''),(5854,'1','285','1',1,'Retail Sale Id 5876',3000.00,0.00,0.00,4.00,480.00,'2022-12-25 07:54:11','',''),(5855,'1','285','1',1,'Retail Sale Id 5877',3000.00,0.00,0.00,4.00,480.00,'2022-12-25 07:56:17','',''),(5856,'1','285','1',1,'Retail Sale Id 5878',41499.80,0.00,0.00,61.94,2477.60,'2022-12-25 07:58:36','',''),(5857,'1','285','1',1,'Retail Sale Id 5879',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 08:00:13','',''),(5858,'1','285','1',1,'Retail Sale Id 5880',46900.00,0.00,0.00,70.00,2800.00,'2022-12-25 08:01:26','',''),(5859,'1','285','1',1,'Retail Sale Id 5881',802.50,0.00,0.00,1.07,128.40,'2022-12-25 08:03:35','',''),(5860,'1','285','1',1,'Retail Sale Id 5882',997.50,0.00,0.00,1.33,159.60,'2022-12-25 08:04:42','',''),(5861,'1','285','1',1,'Retail Sale Id 5883',38129.70,0.00,0.00,56.91,2276.40,'2022-12-25 08:05:55','',''),(5862,'1','285','1',1,'Retail Sale Id 5884',40200.00,0.00,0.00,60.00,2400.00,'2022-12-25 08:08:13','',''),(5863,'1','285','1',1,'Retail Sale Id 5885',3000.00,0.00,0.00,4.00,480.00,'2022-12-25 08:10:40','',''),(5864,'1','285','1',1,'Retail Sale Id 5886',2002.50,0.00,0.00,2.67,320.40,'2022-12-25 08:11:58','',''),(5865,'1','285','1',1,'Retail Sale Id 5887',750.00,0.00,0.00,1.00,120.00,'2022-12-25 08:14:11','',''),(5866,'1','285','1',1,'Retail Sale Id 5888',397.50,0.00,0.00,0.53,63.60,'2022-12-25 08:14:56','',''),(5867,'1','285','1',1,'Retail Sale Id 5889',3000.00,0.00,0.00,4.00,480.00,'2022-12-25 08:15:59','',''),(5868,'1','285','1',1,'Retail Sale Id 5890',6000.00,0.00,0.00,8.00,960.00,'2022-12-25 08:17:40','',''),(5869,'1','285','1',1,'Retail Sale Id 5891',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 08:18:36','',''),(5870,'1','285','1',1,'Retail Sale Id 5892',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 08:19:57','',''),(5871,'1','285','1',1,'Retail Sale Id 5893',2250.00,0.00,0.00,3.00,360.00,'2022-12-25 08:20:51','',''),(5872,'1','285','1',1,'Retail Sale Id 5894',750.00,0.00,0.00,1.00,120.00,'2022-12-25 08:21:56','',''),(5873,'1','285','1',1,'Retail Sale Id 5895',40200.00,0.00,0.00,60.00,2400.00,'2022-12-25 08:23:36','',''),(5874,'1','285','1',1,'Retail Sale Id 5896',3000.00,0.00,0.00,4.00,480.00,'2022-12-25 08:25:58','',''),(5875,'1','285','1',1,'Retail Sale Id 5897',2250.00,0.00,0.00,3.00,360.00,'2022-12-25 08:27:34','',''),(5876,'1','285','1',1,'Retail Sale Id 5898',802.50,0.00,0.00,1.07,128.40,'2022-12-25 08:28:25','',''),(5877,'1','285','1',1,'Retail Sale Id 5899',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 08:29:20','',''),(5878,'1','285','1',1,'Retail Sale Id 5900',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 08:32:34','',''),(5879,'1','285','1',1,'Retail Sale Id 5901',2250.00,0.00,0.00,3.00,360.00,'2022-12-25 08:33:30','',''),(5880,'1','285','1',1,'Retail Sale Id 5902',750.00,0.00,0.00,1.00,120.00,'2022-12-25 08:36:16','',''),(5881,'1','285','1',1,'Retail Sale Id 5903',9000.00,0.00,0.00,12.00,1440.00,'2022-12-25 08:37:19','',''),(5882,'1','285','1',1,'Retail Sale Id 5904',321600.00,0.00,0.00,480.00,19200.00,'2022-12-25 08:40:16','',''),(5883,'1','285','1',1,'Retail Sale Id 5905',5250.00,0.00,0.00,7.00,840.00,'2022-12-25 08:42:56','',''),(5884,'1','285','1',1,'Retail Sale Id 5906',2497.50,0.00,0.00,3.33,399.60,'2022-12-25 08:44:39','',''),(5885,'1','285','1',1,'Retail Sale Id 5907',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 08:45:34','',''),(5886,'1','285','1',1,'Retail Sale Id 5908',3000.00,0.00,0.00,4.00,480.00,'2022-12-25 08:46:25','',''),(5887,'1','285','1',1,'Retail Sale Id 5909',104640.60,0.00,0.00,156.18,6247.20,'2022-12-25 08:48:43','',''),(5888,'1','285','1',1,'Retail Sale Id 5910',2250.00,0.00,0.00,3.00,360.00,'2022-12-25 08:51:43','',''),(5889,'1','285','1',1,'Retail Sale Id 5911',48414.20,0.00,0.00,72.26,2890.40,'2022-12-25 08:54:00','',''),(5890,'1','285','1',1,'Retail Sale Id 5912',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 08:57:00','',''),(5891,'1','285','1',1,'Retail Sale Id 5913',2250.00,0.00,0.00,3.00,360.00,'2022-12-25 08:57:55','',''),(5892,'1','285','1',1,'Retail Sale Id 5914',202708.50,0.00,0.00,302.55,12102.00,'2022-12-25 08:59:49','',''),(5893,'1','285','1',1,'Retail Sale Id 5915',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 09:06:06','',''),(5894,'1','285','1',1,'Retail Sale Id 5916',1200.00,0.00,0.00,1.60,192.00,'2022-12-25 09:07:07','',''),(5895,'1','285','1',1,'Retail Sale Id 5917',2250.00,0.00,0.00,3.00,360.00,'2022-12-25 09:08:08','',''),(5896,'1','285','1',1,'Retail Sale Id 5918',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 09:09:41','',''),(5897,'1','285','1',1,'Retail Sale Id 5920',2250.00,0.00,0.00,3.00,360.00,'2022-12-25 09:11:22','',''),(5898,'1','285','1',1,'Retail Sale Id 5921',750.00,0.00,0.00,1.00,120.00,'2022-12-25 09:12:22','',''),(5899,'1','285','1',1,'Retail Sale Id 5922',10110.30,0.00,0.00,15.09,603.60,'2022-12-25 09:13:46','',''),(5900,'1','285','1',1,'Retail Sale Id 5923',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 09:14:56','',''),(5901,'1','285','1',1,'Retail Sale Id 5924',46900.00,0.00,0.00,70.00,2800.00,'2022-12-25 09:20:38','',''),(5902,'1','285','1',1,'Retail Sale Id 5925',241200.00,0.00,0.00,360.00,14400.00,'2022-12-25 09:25:03','',''),(5903,'1','285','1',1,'Retail Sale Id 5926',2302.50,0.00,0.00,3.07,368.40,'2022-12-25 09:27:00','',''),(5904,'1','285','1',1,'Retail Sale Id 5927',33051.10,0.00,0.00,49.33,1973.20,'2022-12-25 09:28:52','',''),(5905,'1','285','1',1,'Retail Sale Id 5928',750.00,0.00,0.00,1.00,120.00,'2022-12-25 09:30:23','',''),(5906,'1','285','1',1,'Retail Sale Id 5929',3000.00,0.00,0.00,4.00,480.00,'2022-12-25 09:36:44','',''),(5907,'1','285','1',1,'Retail Sale Id 5930',997.50,0.00,0.00,1.33,159.60,'2022-12-25 09:38:38','',''),(5908,'1','285','1',1,'Retail Sale Id 5931',3000.00,0.00,0.00,4.00,480.00,'2022-12-25 09:40:35','',''),(5909,'1','285','1',1,'Retail Sale Id 5932',750.00,0.00,0.00,1.00,120.00,'2022-12-25 09:48:44','',''),(5910,'1','285','1',1,'Retail Sale Id 5933',997.50,0.00,0.00,1.33,159.60,'2022-12-25 09:49:48','',''),(5911,'1','285','1',1,'Retail Sale Id 5935',34840.00,0.00,0.00,52.00,2080.00,'2022-12-25 09:55:34','',''),(5912,'1','285','1',1,'Retail Sale Id 5936',40535.00,0.00,0.00,60.50,2420.00,'2022-12-25 09:58:41','',''),(5913,'1','285','1',1,'Retail Sale Id 5937',11001.40,0.00,0.00,16.42,656.80,'2022-12-25 10:01:35','',''),(5914,'1','285','1',1,'Retail Sale Id 5939',2302.50,0.00,0.00,3.07,368.40,'2022-12-25 10:03:58','',''),(5915,'1','285','1',1,'Retail Sale Id 5940',802.50,0.00,0.00,1.07,128.40,'2022-12-25 10:08:18','',''),(5916,'1','285','1',1,'Retail Sale Id 5941',53794.30,0.00,0.00,80.29,3211.60,'2022-12-25 10:10:38','',''),(5917,'1','285','1',1,'Retail Sale Id 5942',13567.50,0.00,0.00,20.25,810.00,'2022-12-25 10:18:22','',''),(5918,'1','285','1',1,'Retail Sale Id 5943',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 10:20:05','',''),(5919,'1','285','1',1,'Retail Sale Id 5944',2250.00,0.00,0.00,3.00,360.00,'2022-12-25 10:21:14','',''),(5920,'1','285','1',1,'Retail Sale Id 5945',39530.00,0.00,0.00,59.00,2360.00,'2022-12-25 10:25:05','',''),(5921,'1','285','1',1,'Retail Sale Id 5946',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 10:29:33','',''),(5922,'1','285','1',1,'Retail Sale Id 5947',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 10:30:44','',''),(5923,'1','285','1',1,'Retail Sale Id 5948',46900.00,0.00,0.00,70.00,2800.00,'2022-12-25 10:34:26','',''),(5924,'1','285','1',1,'Retail Sale Id 5949',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 10:48:35','',''),(5925,'1','285','1',1,'Retail Sale Id 5950',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 10:59:27','',''),(5926,'1','285','1',1,'Retail Sale Id 5951',6000.00,0.00,0.00,8.00,960.00,'2022-12-25 11:04:19','',''),(5927,'1','285','1',1,'Retail Sale Id 5952',997.50,0.00,0.00,1.33,159.60,'2022-12-25 11:05:13','',''),(5928,'1','285','1',1,'Retail Sale Id 5953',2302.50,0.00,0.00,3.07,368.40,'2022-12-25 11:07:05','',''),(5929,'1','285','1',1,'Retail Sale Id 5954',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 11:07:53','',''),(5930,'1','285','1',1,'Retail Sale Id 5955',802.50,0.00,0.00,1.07,128.40,'2022-12-25 11:08:47','',''),(5931,'1','285','1',1,'Retail Sale Id 5956',3750.00,0.00,0.00,5.00,600.00,'2022-12-25 11:10:18','',''),(5932,'1','285','1',1,'Retail Sale Id 5957',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 11:11:58','',''),(5933,'1','285','1',1,'Retail Sale Id 5958',802.50,0.00,0.00,1.07,128.40,'2022-12-25 11:13:03','',''),(5934,'1','285','1',1,'Retail Sale Id 5959',1200.00,0.00,0.00,1.60,192.00,'2022-12-25 11:16:16','',''),(5935,'1','285','1',1,'Retail Sale Id 5960',3000.00,0.00,0.00,4.00,480.00,'2022-12-25 11:17:20','',''),(5936,'1','285','1',1,'Retail Sale Id 5961',5250.00,0.00,0.00,7.00,840.00,'2022-12-25 11:23:37','',''),(5937,'1','285','1',1,'Retail Sale Id 5962',3750.00,0.00,0.00,5.00,600.00,'2022-12-25 11:33:41','',''),(5938,'1','285','1',1,'Retail Sale Id 5963',24120.00,0.00,0.00,36.00,1440.00,'2022-12-25 11:35:16','',''),(5939,'1','285','1',1,'Retail Sale Id 5964',3000.00,0.00,0.00,4.00,480.00,'2022-12-25 11:42:13','',''),(5940,'1','285','1',1,'Retail Sale Id 5965',6000.00,0.00,0.00,8.00,960.00,'2022-12-25 11:49:33','',''),(5941,'1','285','1',1,'Retail Sale Id 5966',353880.60,0.00,0.00,528.18,21127.20,'2022-12-25 11:52:55','',''),(5942,'1','285','1',1,'Return of Retail Sale Id 5966',0.00,353880.60,528.18,0.00,-21127.20,'2022-12-25 11:53:54','',''),(5943,'1','285','1',1,'Retail Sale Id 5967',353847.10,0.00,0.00,528.13,21125.20,'2022-12-25 11:54:57','',''),(5944,'1','285','1',1,'Retail Sale Id 5968',5767.50,0.00,0.00,7.69,922.80,'2022-12-25 11:56:51','',''),(5945,'1','285','1',1,'Retail Sale Id 5969',2302.50,0.00,0.00,3.07,368.40,'2022-12-25 12:04:19','',''),(5946,'1','285','1',1,'Retail Sale Id 5970',802.50,0.00,0.00,1.07,128.40,'2022-12-25 12:05:45','',''),(5947,'1','285','1',1,'Return of Retail Sale Id 5967',0.00,353847.10,528.13,0.00,-21125.20,'2022-12-25 12:07:11','',''),(5948,'1','285','1',1,'Retail Sale Id 5971',351206.45,0.00,0.00,528.13,18484.55,'2022-12-25 12:08:25','',''),(5949,'1','285','1',1,'Retail Sale Id 5972',46900.00,0.00,0.00,70.00,2800.00,'2022-12-25 12:11:03','',''),(5950,'1','285','1',1,'Retail Sale Id 5973',2250.00,0.00,0.00,3.00,360.00,'2022-12-25 12:13:59','',''),(5951,'1','285','1',1,'Retail Sale Id 5974',3000.00,0.00,0.00,4.00,480.00,'2022-12-25 12:14:57','',''),(5952,'1','285','1',1,'Retail Sale Id 5975',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 12:15:51','',''),(5953,'1','285','1',1,'Retail Sale Id 5976',4500.00,0.00,0.00,6.00,720.00,'2022-12-25 12:31:47','',''),(5954,'1','285','1',1,'Retail Sale Id 5977',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 12:32:55','',''),(5955,'1','285','1',1,'Retail Sale Id 5978',30150.00,0.00,0.00,45.00,1800.00,'2022-12-25 12:34:01','',''),(5956,'1','285','1',1,'Retail Sale Id 5979',802.50,0.00,0.00,1.07,128.40,'2022-12-25 12:43:26','',''),(5957,'1','285','1',1,'Retail Sale Id 5980',802.50,0.00,0.00,1.07,128.40,'2022-12-25 12:44:46','',''),(5958,'1','285','1',1,'Retail Sale Id 5981',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 12:47:05','',''),(5959,'1','285','1',1,'Retail Sale Id 5982',2250.00,0.00,0.00,3.00,360.00,'2022-12-25 13:08:17','',''),(5960,'1','285','1',1,'Retail Sale Id 5983',3000.00,0.00,0.00,4.00,480.00,'2022-12-25 13:09:04','',''),(5961,'1','285','1',1,'Retail Sale Id 5984',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 13:15:04','',''),(5962,'1','285','1',1,'Retail Sale Id 5985',74530.80,0.00,0.00,111.24,4449.60,'2022-12-25 13:16:45','',''),(5963,'1','285','1',1,'Retail Sale Id 5986',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 13:25:21','',''),(5964,'1','285','1',1,'Retail Sale Id 5987',2250.00,0.00,0.00,3.00,360.00,'2022-12-25 13:26:27','',''),(5965,'1','285','1',1,'Retail Sale Id 5988',3000.00,0.00,0.00,4.00,480.00,'2022-12-25 13:29:43','',''),(5966,'1','285','1',1,'Retail Sale Id 5989',3000.00,0.00,0.00,4.00,480.00,'2022-12-25 13:32:23','',''),(5967,'1','285','1',1,'Retail Sale Id 5990',32830.00,0.00,0.00,49.00,1960.00,'2022-12-25 13:42:52','',''),(5968,'1','285','1',1,'Retail Sale Id 5991',3000.00,0.00,0.00,4.00,480.00,'2022-12-25 13:43:49','',''),(5969,'1','285','1',1,'Retail Sale Id 5992',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 13:48:01','',''),(5970,'1','285','1',1,'Retail Sale Id 5993',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 13:48:50','',''),(5971,'1','285','1',1,'Retail Sale Id 5994',4500.00,0.00,0.00,6.00,720.00,'2022-12-25 13:49:35','',''),(5972,'1','285','1',1,'Retail Sale Id 5995',4500.00,0.00,0.00,6.00,720.00,'2022-12-25 13:50:53','',''),(5973,'1','285','1',1,'Retail Sale Id 5996',9375.00,0.00,0.00,12.50,1500.00,'2022-12-25 13:51:46','',''),(5974,'1','285','1',1,'Retail Sale Id 5997',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 14:27:09','',''),(5975,'1','285','1',1,'Retail Sale Id 5998',2250.00,0.00,0.00,3.00,360.00,'2022-12-25 14:28:47','',''),(5976,'1','285','1',1,'Retail Sale Id 5999',16750.00,0.00,0.00,25.00,1000.00,'2022-12-25 14:31:40','',''),(5977,'1','285','1',1,'Retail Sale Id 6000',40387.60,0.00,0.00,60.28,2411.20,'2022-12-25 14:35:28','',''),(5978,'1','285','1',1,'Retail Sale Id 6001',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 14:37:10','',''),(5979,'1','285','1',1,'Retail Sale Id 6002',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 14:38:18','',''),(5980,'1','285','1',1,'Retail Sale Id 6003',997.50,0.00,0.00,1.33,159.60,'2022-12-25 14:39:07','',''),(5981,'1','285','1',1,'Retail Sale Id 6004',2002.50,0.00,0.00,2.67,320.40,'2022-12-25 14:39:59','',''),(5982,'1','285','1',1,'Retail Sale Id 6005',997.50,0.00,0.00,1.33,159.60,'2022-12-25 14:40:50','',''),(5983,'1','285','1',1,'Retail Sale Id 6006',802.50,0.00,0.00,1.07,128.40,'2022-12-25 14:41:59','',''),(5984,'1','285','1',1,'Retail Sale Id 6007',266000.00,0.00,0.00,400.00,14000.00,'2022-12-25 14:43:25','',''),(5985,'1','285','1',1,'Retail Sale Id 6008',3750.00,0.00,0.00,5.00,600.00,'2022-12-25 14:45:07','',''),(5986,'1','285','1',1,'Retail Sale Id 6009',80400.00,0.00,0.00,120.00,4800.00,'2022-12-25 14:47:00','',''),(5987,'1','285','1',1,'Retail Sale Id 6010',1297.50,0.00,0.00,1.73,207.60,'2022-12-25 14:51:52','',''),(5988,'1','285','1',1,'Retail Sale Id 6011',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 14:52:46','',''),(5989,'1','285','1',1,'Retail Sale Id 6012',9000.00,0.00,0.00,12.00,1440.00,'2022-12-25 14:54:00','',''),(5990,'1','285','1',1,'Retail Sale Id 6013',750.00,0.00,0.00,1.00,120.00,'2022-12-25 14:55:46','',''),(5991,'1','285','1',1,'Retail Sale Id 6014',16394.90,0.00,0.00,24.47,978.80,'2022-12-25 14:57:42','',''),(5992,'1','285','1',1,'Retail Sale Id 6015',31456.50,0.00,0.00,46.95,1878.00,'2022-12-25 14:58:41','',''),(5993,'1','285','1',1,'Retail Sale Id 6016',3000.00,0.00,0.00,4.00,480.00,'2022-12-25 15:05:59','',''),(5994,'1','285','1',1,'Retail Sale Id 6017',3750.00,0.00,0.00,5.00,600.00,'2022-12-25 15:14:57','',''),(5995,'1','285','1',1,'Retail Sale Id 6018',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 15:15:42','',''),(5996,'1','285','1',1,'Retail Sale Id 6019',3000.00,0.00,0.00,4.00,480.00,'2022-12-25 15:16:48','',''),(5997,'1','285','1',1,'Retail Sale Id 6020',2002.50,0.00,0.00,2.67,320.40,'2022-12-25 15:17:35','',''),(5998,'1','285','1',1,'Retail Sale Id 6021',40870.00,0.00,0.00,61.00,2440.00,'2022-12-25 15:31:50','',''),(5999,'1','285','1',1,'Retail Sale Id 6022',38860.00,0.00,0.00,58.00,2320.00,'2022-12-25 15:35:23','',''),(6000,'1','285','1',1,'Retail Sale Id 6023',13453.60,0.00,0.00,20.08,803.20,'2022-12-25 15:37:04','',''),(6001,'1','285','1',1,'Retail Sale Id 6024',3000.00,0.00,0.00,4.00,480.00,'2022-12-25 15:42:38','',''),(6002,'1','285','1',1,'Retail Sale Id 6025',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 15:43:43','',''),(6003,'1','285','1',1,'Retail Sale Id 6026',40669.00,0.00,0.00,60.70,2428.00,'2022-12-25 15:49:22','',''),(6004,'1','285','1',1,'Return of Retail Sale Id 6024',0.00,3000.00,4.00,0.00,-480.00,'2022-12-25 15:52:36','',''),(6005,'1','285','1',1,'Retail Sale Id 6027',2482.50,0.00,0.00,3.31,397.20,'2022-12-25 15:53:25','',''),(6006,'1','285','1',1,'Retail Sale Id 6028',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 15:54:32','',''),(6007,'1','285','1',1,'Retail Sale Id 6029',11644.60,0.00,0.00,17.38,695.20,'2022-12-25 15:59:41','',''),(6008,'1','285','1',1,'Retail Sale Id 6030',1500.00,0.00,0.00,2.00,240.00,'2022-12-25 16:01:18','',''),(6009,'1','285','1',1,'Retail Sale Id 6031',19718.10,0.00,0.00,29.43,1177.20,'2022-12-25 16:04:42','',''),(6010,'1','285','1',1,'Return of Retail Sale Id 6027',0.00,2482.50,3.31,0.00,-397.20,'2022-12-25 18:10:44','',''),(6011,'1','285','1',1,'Return of Retail Sale Id 6030',0.00,1500.00,2.00,0.00,-240.00,'2022-12-25 18:11:45','',''),(6012,'1','285','1',1,'Retail Sale Id 6032',712.50,0.00,0.00,0.95,114.00,'2022-12-25 18:13:15','',''),(6013,'1','285','1',1,'Return of Retail Sale Id 6029',0.00,11644.60,17.38,0.00,-695.20,'2022-12-25 18:23:55','',''),(6014,'1','285','1',1,'Retail Sale Id 6033',8415.20,0.00,0.00,12.56,502.40,'2022-12-25 18:26:50','',''),(6015,'1','285','1',1,'Retail Sale Id 6034',750.00,0.00,0.00,1.00,120.00,'2022-12-26 07:19:08','',''),(6016,'1','285','1',1,'Retail Sale Id 6035',1500.00,0.00,0.00,2.00,240.00,'2022-12-26 07:21:25','',''),(6017,'1','285','1',1,'Retail Sale Id 6036',26800.00,0.00,0.00,40.00,1600.00,'2022-12-26 07:27:09','',''),(6018,'1','285','1',1,'Retail Sale Id 6037',2250.00,0.00,0.00,3.00,360.00,'2022-12-26 07:27:52','',''),(6019,'1','285','1',1,'Retail Sale Id 6038',1500.00,0.00,0.00,2.00,240.00,'2022-12-26 07:29:13','',''),(6020,'1','285','1',1,'Retail Sale Id 6039',16750.00,0.00,0.00,25.00,1000.00,'2022-12-26 07:30:34','',''),(6021,'1','285','1',1,'Retail Sale Id 6040',16528.90,0.00,0.00,24.67,986.80,'2022-12-26 07:34:46','',''),(6022,'1','285','1',1,'Retail Sale Id 6041',121779.20,0.00,0.00,181.76,7270.40,'2022-12-26 07:36:52','',''),(6023,'1','285','1',1,'Return of Retail Sale Id 6039',0.00,16750.00,25.00,0.00,-1000.00,'2022-12-26 07:38:19','',''),(6024,'1','285','1',1,'Retail Sale Id 6042',16803.60,0.00,0.00,25.08,1003.20,'2022-12-26 07:39:02','',''),(6025,'1','285','1',1,'Retail Sale Id 6043',2302.50,0.00,0.00,3.07,368.40,'2022-12-26 07:40:13','',''),(6026,'1','285','1',1,'Retail Sale Id 6044',1500.00,0.00,0.00,2.00,240.00,'2022-12-26 07:41:09','',''),(6027,'1','285','1',1,'Retail Sale Id 6045',45640.40,0.00,0.00,68.12,2724.80,'2022-12-26 07:43:37','',''),(6028,'1','285','1',1,'Retail Sale Id 6047',38504.90,0.00,0.00,57.47,2298.80,'2022-12-26 07:47:52','',''),(6029,'1','285','1',1,'Retail Sale Id 6048',1500.00,0.00,0.00,2.00,240.00,'2022-12-26 07:50:02','',''),(6030,'1','285','1',1,'Retail Sale Id 6049',3750.00,0.00,0.00,5.00,600.00,'2022-12-26 07:50:48','',''),(6031,'1','285','1',1,'Retail Sale Id 6050',997.50,0.00,0.00,1.33,159.60,'2022-12-26 07:55:00','',''),(6032,'1','285','1',1,'Retail Sale Id 6051',2250.00,0.00,0.00,3.00,360.00,'2022-12-26 07:56:01','',''),(6033,'1','285','1',1,'Retail Sale Id 6052',18090.00,0.00,0.00,27.00,1080.00,'2022-12-26 07:59:57','',''),(6034,'1','285','1',1,'Retail Sale Id 6053',802.50,0.00,0.00,1.07,128.40,'2022-12-26 08:01:47','',''),(6035,'1','285','1',1,'Retail Sale Id 6054',750.00,0.00,0.00,1.00,120.00,'2022-12-26 08:06:10','',''),(6036,'1','285','1',1,'Retail Sale Id 6055',750.00,0.00,0.00,1.00,120.00,'2022-12-26 08:07:11','',''),(6037,'1','285','1',1,'Retail Sale Id 6056',1500.00,0.00,0.00,2.00,240.00,'2022-12-26 08:09:18','',''),(6038,'1','285','1',1,'Retail Sale Id 6057',40535.00,0.00,0.00,60.50,2420.00,'2022-12-26 08:20:30','',''),(6039,'1','285','1',1,'Retail Sale Id 6058',2250.00,0.00,0.00,3.00,360.00,'2022-12-26 08:23:03','',''),(6040,'1','285','1',1,'Retail Sale Id 6059',2250.00,0.00,0.00,3.00,360.00,'2022-12-26 08:25:04','',''),(6041,'1','285','1',1,'Retail Sale Id 6060',1500.00,0.00,0.00,2.00,240.00,'2022-12-26 08:26:15','',''),(6042,'1','285','1',1,'Retail Sale Id 6061',3000.00,0.00,0.00,4.00,480.00,'2022-12-26 08:30:42','',''),(6043,'1','285','1',1,'Retail Sale Id 6062',1500.00,0.00,0.00,2.00,240.00,'2022-12-26 08:32:35','',''),(6044,'1','285','1',1,'Retail Sale Id 6063',41171.50,0.00,0.00,61.45,2458.00,'2022-12-26 08:33:36','',''),(6045,'1','285','1',1,'Retail Sale Id 6064',45794.50,0.00,0.00,68.35,2734.00,'2022-12-26 08:39:51','',''),(6046,'1','285','1',1,'Retail Sale Id 6065',41057.60,0.00,0.00,61.28,2451.20,'2022-12-26 08:42:33','',''),(6047,'1','285','1',1,'Retail Sale Id 6066',130469.10,0.00,0.00,194.73,7789.20,'2022-12-26 08:46:07','',''),(6048,'1','285','1',1,'Retail Sale Id 6067',12207.40,0.00,0.00,18.22,728.80,'2022-12-26 08:47:40','',''),(6049,'1','285','1',1,'Retail Sale Id 6068',750.00,0.00,0.00,1.00,120.00,'2022-12-26 08:49:12','',''),(6050,'1','285','1',1,'Retail Sale Id 6069',41426.10,0.00,0.00,61.83,2473.20,'2022-12-26 08:51:32','',''),(6051,'1','285','1',1,'Retail Sale Id 6070',1500.00,0.00,0.00,2.00,240.00,'2022-12-26 08:54:51','',''),(6052,'1','285','1',1,'Retail Sale Id 6071',41426.10,0.00,0.00,61.83,2473.20,'2022-12-26 08:55:55','',''),(6053,'1','285','1',1,'Retail Sale Id 6072',4500.00,0.00,0.00,6.00,720.00,'2022-12-26 08:59:14','',''),(6054,'1','285','1',1,'Retail Sale Id 6073',2250.00,0.00,0.00,3.00,360.00,'2022-12-26 09:01:09','',''),(6055,'1','285','1',1,'Retail Sale Id 6074',1500.00,0.00,0.00,2.00,240.00,'2022-12-26 09:02:42','',''),(6056,'1','285','1',1,'Retail Sale Id 6075',2250.00,0.00,0.00,3.00,360.00,'2022-12-26 09:03:38','',''),(6057,'1','285','1',1,'Return of Retail Sale Id 6069',0.00,41426.10,61.83,0.00,-2473.20,'2022-12-26 09:04:41','',''),(6058,'1','285','1',1,'Retail Sale Id 6076',40870.00,0.00,0.00,61.00,2440.00,'2022-12-26 09:05:28','',''),(6059,'1','285','1',1,'Retail Sale Id 6077',43670.60,0.00,0.00,65.18,2607.20,'2022-12-26 09:08:14','',''),(6060,'1','285','1',1,'Retail Sale Id 6078',2250.00,0.00,0.00,3.00,360.00,'2022-12-26 09:16:12','',''),(6061,'1','285','1',1,'Retail Sale Id 6079',32160.00,0.00,0.00,48.00,1920.00,'2022-12-26 09:17:15','',''),(6062,'1','285','1',1,'Retail Sale Id 6080',3350.00,0.00,0.00,5.00,200.00,'2022-12-26 09:19:29','',''),(6063,'1','285','1',1,'Retail Sale Id 6081',41526.60,0.00,0.00,61.98,2479.20,'2022-12-26 09:21:03','',''),(6064,'1','285','1',1,'Retail Sale Id 6082',40200.00,0.00,0.00,60.00,2400.00,'2022-12-26 09:28:49','',''),(6065,'1','285','1',1,'Retail Sale Id 6083',10612.80,0.00,0.00,15.84,633.60,'2022-12-26 09:34:47','',''),(6066,'1','285','1',1,'Retail Sale Id 6084',1500.00,0.00,0.00,2.00,240.00,'2022-12-26 09:36:38','',''),(6067,'1','285','1',1,'Retail Sale Id 6085',3000.00,0.00,0.00,4.00,480.00,'2022-12-26 09:37:57','',''),(6068,'1','285','1',1,'Retail Sale Id 6086',2797.50,0.00,0.00,3.73,447.60,'2022-12-26 09:39:34','',''),(6069,'1','285','1',1,'Retail Sale Id 6087',40086.10,0.00,0.00,59.83,2393.20,'2022-12-26 09:40:49','',''),(6070,'1','285','1',1,'Retail Sale Id 6088',10500.00,0.00,0.00,14.00,1680.00,'2022-12-26 09:42:58','',''),(6071,'1','285','1',1,'Retail Sale Id 6089',41600.30,0.00,0.00,62.09,2483.60,'2022-12-26 09:44:59','',''),(6072,'1','285','1',1,'Retail Sale Id 6090',48179.70,0.00,0.00,71.91,2876.40,'2022-12-26 09:47:30','',''),(6073,'1','285','1',1,'Retail Sale Id 6091',1500.00,0.00,0.00,2.00,240.00,'2022-12-26 09:49:41','',''),(6074,'1','285','1',1,'Retail Sale Id 6092',2002.50,0.00,0.00,2.67,320.40,'2022-12-26 09:50:27','',''),(6075,'1','285','1',1,'Retail Sale Id 6093',2002.50,0.00,0.00,2.67,320.40,'2022-12-26 09:51:19','',''),(6076,'1','285','1',1,'Retail Sale Id 6094',41084.40,0.00,0.00,61.32,2452.80,'2022-12-26 09:52:30','',''),(6077,'1','285','1',1,'Retail Sale Id 6095',5250.00,0.00,0.00,7.00,840.00,'2022-12-26 09:56:06','',''),(6078,'1','285','1',1,'Retail Sale Id 6096',83575.80,0.00,0.00,124.74,4989.60,'2022-12-26 09:58:09','',''),(6079,'1','285','1',1,'Retail Sale Id 6097',3000.00,0.00,0.00,4.00,480.00,'2022-12-26 10:00:27','',''),(6080,'1','285','1',1,'Retail Sale Id 6098',6000.00,0.00,0.00,8.00,960.00,'2022-12-26 10:01:11','',''),(6081,'1','285','1',1,'Retail Sale Id 6099',42638.80,0.00,0.00,63.64,2545.60,'2022-12-26 10:02:47','',''),(6082,'1','285','1',1,'Retail Sale Id 6100',9976.30,0.00,0.00,14.89,595.60,'2022-12-26 10:05:32','',''),(6083,'1','285','1',1,'Retail Sale Id 6101',3000.00,0.00,0.00,4.00,480.00,'2022-12-26 10:07:36','',''),(6084,'1','285','1',1,'Retail Sale Id 6102',2302.50,0.00,0.00,3.07,368.40,'2022-12-26 10:09:12','',''),(6085,'1','285','1',1,'Retail Sale Id 6103',2002.50,0.00,0.00,2.67,320.40,'2022-12-26 10:10:10','',''),(6086,'1','285','1',1,'Retail Sale Id 6104',4500.00,0.00,0.00,6.00,720.00,'2022-12-26 10:11:41','',''),(6087,'1','285','1',1,'Retail Sale Id 6105',49653.70,0.00,0.00,74.11,2964.40,'2022-12-26 10:13:19','',''),(6088,'1','285','1',1,'Retail Sale Id 6106',51811.10,0.00,0.00,77.33,3093.20,'2022-12-26 10:15:39','',''),(6089,'1','285','1',1,'Retail Sale Id 6107',1500.00,0.00,0.00,2.00,240.00,'2022-12-26 10:18:01','',''),(6090,'1','285','1',1,'Retail Sale Id 6108',16549.00,0.00,0.00,24.70,988.00,'2022-12-26 10:18:54','',''),(6091,'1','285','1',1,'Retail Sale Id 6109',11587.50,0.00,0.00,15.45,1854.00,'2022-12-26 10:20:17','',''),(6092,'1','285','1',1,'Retail Sale Id 6110',3000.00,0.00,0.00,4.00,480.00,'2022-12-26 10:21:41','',''),(6093,'1','285','1',1,'Retail Sale Id 6111',98818.30,0.00,0.00,147.49,5899.60,'2022-12-26 10:23:31','',''),(6094,'1','285','1',1,'Retail Sale Id 6112',997.50,0.00,0.00,1.33,159.60,'2022-12-26 10:28:41','',''),(6095,'1','285','1',1,'Retail Sale Id 6113',16723.20,0.00,0.00,24.96,998.40,'2022-12-26 10:29:56','',''),(6096,'1','285','1',1,'Retail Sale Id 6114',4500.00,0.00,0.00,6.00,720.00,'2022-12-26 10:33:52','',''),(6097,'1','285','1',1,'Retail Sale Id 6115',1500.00,0.00,0.00,2.00,240.00,'2022-12-26 10:37:14','',''),(6098,'1','285','1',1,'Retail Sale Id 6116',41057.60,0.00,0.00,61.28,2451.20,'2022-12-26 10:38:22','',''),(6099,'1','285','1',1,'Retail Sale Id 6117',1500.00,0.00,0.00,2.00,240.00,'2022-12-26 10:41:35','',''),(6100,'1','285','1',1,'Retail Sale Id 6118',124338.60,0.00,0.00,185.58,7423.20,'2022-12-26 10:44:56','',''),(6101,'1','285','1',1,'Retail Sale Id 6119',2250.00,0.00,0.00,3.00,360.00,'2022-12-26 10:46:26','',''),(6102,'1','285','1',1,'Retail Sale Id 6120',3750.00,0.00,0.00,5.00,600.00,'2022-12-26 10:47:49','',''),(6103,'1','285','1',1,'Retail Sale Id 6121',40535.00,0.00,0.00,60.50,2420.00,'2022-12-26 10:51:12','',''),(6104,'1','285','1',1,'Retail Sale Id 6122',997.50,0.00,0.00,1.33,159.60,'2022-12-26 11:02:30','',''),(6105,'1','285','1',1,'Retail Sale Id 6123',40200.00,0.00,0.00,60.00,2400.00,'2022-12-26 11:07:43','',''),(6106,'1','285','1',1,'Retail Sale Id 6124',1500.00,0.00,0.00,2.00,240.00,'2022-12-26 11:09:22','',''),(6107,'1','285','1',1,'Retail Sale Id 6125',2002.50,0.00,0.00,2.67,320.40,'2022-12-26 11:10:13','',''),(6108,'1','285','1',1,'Retail Sale Id 6126',80400.00,0.00,0.00,120.00,4800.00,'2022-12-26 11:42:11','',''),(6109,'1','285','1',1,'Retail Sale Id 6127',324950.00,0.00,0.00,485.00,19400.00,'2022-12-26 11:46:26','',''),(6110,'1','285','1',1,'Retail Sale Id 6128',13400.00,0.00,0.00,20.00,800.00,'2022-12-26 11:56:24','',''),(6111,'1','285','1',1,'Retail Sale Id 6129',18043.10,0.00,0.00,26.93,1077.20,'2022-12-26 12:00:31','',''),(6112,'1','285','1',1,'Return of Retail Sale Id 6127',0.00,324950.00,485.00,0.00,-19400.00,'2022-12-26 12:04:51','',''),(6113,'1','285','1',1,'Retail Sale Id 6130',322525.00,0.00,0.00,485.00,16975.00,'2022-12-26 12:07:33','',''),(6114,'1','285','1',1,'Retail Sale Id 6131',2002.50,0.00,0.00,2.67,320.40,'2022-12-26 12:10:23','',''),(6115,'1','285','1',1,'Retail Sale Id 6132',1500.00,0.00,0.00,2.00,240.00,'2022-12-26 12:11:54','',''),(6116,'1','285','1',1,'Retail Sale Id 6133',670.00,0.00,0.00,1.00,40.00,'2022-12-26 12:13:40','',''),(6117,'1','285','1',1,'Retail Sale Id 6134',65686.80,0.00,0.00,98.04,3921.60,'2022-12-26 12:16:59','',''),(6118,'1','285','1',1,'Distributed to AA RANO NIGERIA LTD for sales id:7',239299.20,0.00,0.00,379.84,0.00,'2022-12-26 15:20:50','',''),(6119,'1','285',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,12978000.00,20600.00,0.00,0.00,'2022-12-27 06:31:44','',''),(6120,'1','285',NULL,1,'Reception corrector for bridging 9',0.00,0.00,0.00,20600.00,0.00,'2022-12-27 06:34:22','',''),(6121,'1','285','1',1,'Received from bridging 9',0.00,0.00,20600.00,0.00,0.00,'2022-12-27 06:34:22','',''),(6122,'1','285','1',1,'Retail Sale Id 6135',1500.00,0.00,0.00,2.00,240.00,'2022-12-27 07:39:11','',''),(6123,'1','285','1',1,'Retail Sale Id 6136',802.50,0.00,0.00,1.07,128.40,'2022-12-27 07:40:31','',''),(6124,'1','285','1',1,'Retail Sale Id 6137',9997.50,0.00,0.00,13.33,1599.60,'2022-12-27 07:42:36','',''),(6125,'1','285','1',1,'Retail Sale Id 6138',9997.50,0.00,0.00,13.33,1599.60,'2022-12-27 07:43:24','',''),(6126,'1','285','1',1,'Retail Sale Id 6139',13400.00,0.00,0.00,20.00,800.00,'2022-12-27 07:45:32','',''),(6127,'1','285','1',1,'Retail Sale Id 6140',2002.50,0.00,0.00,2.67,320.40,'2022-12-27 07:46:48','',''),(6128,'1','285','1',1,'Retail Sale Id 6141',2250.00,0.00,0.00,3.00,360.00,'2022-12-27 07:47:54','',''),(6129,'1','285','1',1,'Retail Sale Id 6142',32468.20,0.00,0.00,48.46,1938.40,'2022-12-27 07:49:37','',''),(6130,'1','285','1',1,'Retail Sale Id 6143',44474.60,0.00,0.00,66.38,2655.20,'2022-12-27 07:54:19','',''),(6131,'1','285','1',1,'Retail Sale Id 6144',20361.30,0.00,0.00,30.39,1215.60,'2022-12-27 07:56:37','',''),(6132,'1','285','1',1,'Retail Sale Id 6145',75241.00,0.00,0.00,112.30,4492.00,'2022-12-27 08:00:55','',''),(6133,'1','285','1',1,'Retail Sale Id 6146',3000.00,0.00,0.00,4.00,480.00,'2022-12-27 08:04:44','',''),(6134,'1','285','1',1,'Retail Sale Id 6147',2002.50,0.00,0.00,2.67,320.40,'2022-12-27 08:06:24','',''),(6135,'1','285','1',1,'Retail Sale Id 6148',1500.00,0.00,0.00,2.00,240.00,'2022-12-27 08:07:22','',''),(6136,'1','285','1',1,'Retail Sale Id 6149',1500.00,0.00,0.00,2.00,240.00,'2022-12-27 08:08:10','',''),(6137,'1','285','1',1,'Retail Sale Id 6150',2250.00,0.00,0.00,3.00,360.00,'2022-12-27 08:08:56','',''),(6138,'1','285','1',1,'Retail Sale Id 6151',750.00,0.00,0.00,1.00,120.00,'2022-12-27 08:14:10','',''),(6139,'1','285','1',1,'Retail Sale Id 6152',3000.00,0.00,0.00,4.00,480.00,'2022-12-27 08:15:00','',''),(6140,'1','285','1',1,'Retail Sale Id 6153',1200.00,0.00,0.00,1.60,192.00,'2022-12-27 08:19:23','',''),(6141,'1','285','1',1,'Retail Sale Id 6154',46900.00,0.00,0.00,70.00,2800.00,'2022-12-27 08:21:21','',''),(6142,'1','285','1',1,'Retail Sale Id 6155',4500.00,0.00,0.00,6.00,720.00,'2022-12-27 08:22:22','',''),(6143,'1','285','1',1,'Retail Sale Id 6156',2002.50,0.00,0.00,2.67,320.40,'2022-12-27 08:25:06','',''),(6144,'1','285','1',1,'Retail Sale Id 6157',56052.20,0.00,0.00,83.66,3346.40,'2022-12-27 08:26:39','',''),(6145,'1','285','1',1,'Retail Sale Id 6158',41298.80,0.00,0.00,61.64,2465.60,'2022-12-27 08:31:31','',''),(6146,'1','285','1',1,'Retail Sale Id 6159',23450.00,0.00,0.00,35.00,1400.00,'2022-12-27 08:33:31','',''),(6147,'1','285','1',1,'Retail Sale Id 6160',43516.50,0.00,0.00,64.95,2598.00,'2022-12-27 08:35:43','',''),(6148,'1','285','1',1,'Retail Sale Id 6161',802.50,0.00,0.00,1.07,128.40,'2022-12-27 08:38:35','',''),(6149,'1','285','1',1,'Retail Sale Id 6162',33500.00,0.00,0.00,50.00,2000.00,'2022-12-27 08:42:31','',''),(6150,'1','285','1',1,'Retail Sale Id 6163',2250.00,0.00,0.00,3.00,360.00,'2022-12-27 08:44:43','',''),(6151,'1','285','1',1,'Retail Sale Id 6164',81795.00,0.00,0.00,123.00,4305.00,'2022-12-27 08:46:29','',''),(6152,'1','285','1',1,'Retail Sale Id 6165',41365.80,0.00,0.00,61.74,2469.60,'2022-12-27 08:49:59','',''),(6153,'1','285','1',1,'Retail Sale Id 6166',3000.00,0.00,0.00,4.00,480.00,'2022-12-27 08:52:03','',''),(6154,'1','285','1',1,'Retail Sale Id 6167',2250.00,0.00,0.00,3.00,360.00,'2022-12-27 08:52:55','',''),(6155,'1','285','1',1,'Retail Sale Id 6168',1500.00,0.00,0.00,2.00,240.00,'2022-12-27 08:54:41','',''),(6156,'1','285','1',1,'Retail Sale Id 6169',750.00,0.00,0.00,1.00,120.00,'2022-12-27 08:55:26','',''),(6157,'1','285','1',1,'Retail Sale Id 6170',1500.00,0.00,0.00,2.00,240.00,'2022-12-27 09:01:00','',''),(6158,'1','285','1',1,'Retail Sale Id 6171',1500.00,0.00,0.00,2.00,240.00,'2022-12-27 09:01:47','',''),(6159,'1','285','1',1,'Retail Sale Id 6172',40200.00,0.00,0.00,60.00,2400.00,'2022-12-27 09:02:55','',''),(6160,'1','285','1',1,'Retail Sale Id 6173',40709.20,0.00,0.00,60.76,2430.40,'2022-12-27 09:05:05','',''),(6161,'1','285','1',1,'Retail Sale Id 6174',24790.00,0.00,0.00,37.00,1480.00,'2022-12-27 09:08:18','',''),(6162,'1','285','1',1,'Retail Sale Id 6175',3750.00,0.00,0.00,5.00,600.00,'2022-12-27 09:10:07','',''),(6163,'1','285','1',1,'Retail Sale Id 6176',41359.10,0.00,0.00,61.73,2469.20,'2022-12-27 09:13:10','',''),(6164,'1','285','1',1,'Retail Sale Id 6177',40307.20,0.00,0.00,60.16,2406.40,'2022-12-27 09:16:04','',''),(6165,'1','285','1',1,'Retail Sale Id 6178',40200.00,0.00,0.00,60.00,2400.00,'2022-12-27 09:20:18','',''),(6166,'1','285','1',1,'Retail Sale Id 6179',2250.00,0.00,0.00,3.00,360.00,'2022-12-27 09:32:07','',''),(6167,'1','285','1',1,'Retail Sale Id 6180',1500.00,0.00,0.00,2.00,240.00,'2022-12-27 09:33:29','',''),(6168,'1','285','1',1,'Retail Sale Id 6181',40200.00,0.00,0.00,60.00,2400.00,'2022-12-27 09:34:29','',''),(6169,'1','285','1',1,'Retail Sale Id 6182',1500.00,0.00,0.00,2.00,240.00,'2022-12-27 09:36:30','',''),(6170,'1','285','1',1,'Retail Sale Id 6183',1500.00,0.00,0.00,2.00,240.00,'2022-12-27 09:38:21','',''),(6171,'1','285','1',1,'Retail Sale Id 6184',750.00,0.00,0.00,1.00,120.00,'2022-12-27 09:39:11','',''),(6172,'1','285','1',1,'Retail Sale Id 6185',18760.00,0.00,0.00,28.00,1120.00,'2022-12-27 09:40:32','',''),(6173,'1','285','1',1,'Retail Sale Id 6186',40548.40,0.00,0.00,60.52,2420.80,'2022-12-27 09:46:29','',''),(6174,'1','285','1',1,'Retail Sale Id 6187',9750.00,0.00,0.00,13.00,1560.00,'2022-12-27 09:49:34','',''),(6175,'1','285','1',1,'Retail Sale Id 6188',28702.80,0.00,0.00,42.84,1713.60,'2022-12-27 09:51:18','',''),(6176,'1','285','1',1,'Retail Sale Id 6189',62397.10,0.00,0.00,93.13,3725.20,'2022-12-27 09:55:05','',''),(6177,'1','285','1',1,'Retail Sale Id 6190',3502.50,0.00,0.00,4.67,560.40,'2022-12-27 09:58:38','',''),(6178,'1','285','1',1,'Retail Sale Id 6191',1500.00,0.00,0.00,2.00,240.00,'2022-12-27 10:00:00','',''),(6179,'1','285','1',1,'Retail Sale Id 6192',3000.00,0.00,0.00,4.00,480.00,'2022-12-27 10:03:27','',''),(6180,'1','285','1',1,'Retail Sale Id 6193',5002.50,0.00,0.00,6.67,800.40,'2022-12-27 10:09:34','',''),(6181,'1','285','1',1,'Retail Sale Id 6194',3750.00,0.00,0.00,5.00,600.00,'2022-12-27 10:12:32','',''),(6182,'1','285','1',1,'Retail Sale Id 6195',40200.00,0.00,0.00,60.00,2400.00,'2022-12-27 10:15:39','',''),(6183,'1','285','1',1,'Retail Sale Id 6196',2250.00,0.00,0.00,3.00,360.00,'2022-12-27 10:16:47','',''),(6184,'1','285','1',1,'Retail Sale Id 6197',1500.00,0.00,0.00,2.00,240.00,'2022-12-27 10:17:32','',''),(6185,'1','285','1',1,'Retail Sale Id 6198',1500.00,0.00,0.00,2.00,240.00,'2022-12-27 10:18:19','',''),(6186,'1','285','1',1,'Retail Sale Id 6199',1500.00,0.00,0.00,2.00,240.00,'2022-12-27 10:22:00','',''),(6187,'1','285','1',1,'Retail Sale Id 6200',830.80,0.00,0.00,1.24,49.60,'2022-12-27 10:28:30','',''),(6188,'1','285','1',1,'Retail Sale Id 6202',57626.70,0.00,0.00,86.01,3440.40,'2022-12-27 10:32:00','',''),(6189,'1','285','1',1,'Retail Sale Id 6203',2197.50,0.00,0.00,2.93,351.60,'2022-12-27 10:35:14','',''),(6190,'1','285','1',1,'Retail Sale Id 6204',2002.50,0.00,0.00,2.67,320.40,'2022-12-27 10:36:05','',''),(6191,'1','285','1',1,'Retail Sale Id 6205',46900.00,0.00,0.00,70.00,2800.00,'2022-12-27 10:47:27','',''),(6192,'1','285','1',1,'Retail Sale Id 6206',41325.60,0.00,0.00,61.68,2467.20,'2022-12-27 10:49:59','',''),(6193,'1','285','1',1,'Retail Sale Id 6207',2400.00,0.00,0.00,3.20,384.00,'2022-12-27 10:53:01','',''),(6194,'1','285','1',1,'Retail Sale Id 6208',750.00,0.00,0.00,1.00,120.00,'2022-12-27 10:54:00','',''),(6195,'1','285','1',1,'Retail Sale Id 6209',33500.00,0.00,0.00,50.00,2000.00,'2022-12-27 10:55:46','',''),(6196,'1','285','1',1,'Retail Sale Id 6210',2250.00,0.00,0.00,3.00,360.00,'2022-12-27 11:08:34','',''),(6197,'1','285','1',1,'Retail Sale Id 6211',3000.00,0.00,0.00,4.00,480.00,'2022-12-27 11:11:39','',''),(6198,'1','285','1',1,'Retail Sale Id 6212',1500.00,0.00,0.00,2.00,240.00,'2022-12-27 11:15:26','',''),(6199,'1','285','1',1,'Retail Sale Id 6213',40407.70,0.00,0.00,60.31,2412.40,'2022-12-27 11:24:48','',''),(6200,'1','285','1',1,'Retail Sale Id 6214',3000.00,0.00,0.00,4.00,480.00,'2022-12-27 11:36:54','',''),(6201,'1','285','1',1,'Retail Sale Id 6215',3000.00,0.00,0.00,4.00,480.00,'2022-12-27 11:41:32','',''),(6202,'1','285','1',1,'Retail Sale Id 6216',15000.00,0.00,0.00,20.00,2400.00,'2022-12-27 11:49:51','',''),(6203,'1','285','1',1,'Retail Sale Id 6217',40856.60,0.00,0.00,60.98,2439.20,'2022-12-27 11:51:42','',''),(6204,'1','285','1',1,'Retail Sale Id 6218',2302.50,0.00,0.00,3.07,368.40,'2022-12-27 11:54:59','',''),(6205,'1','285','1',1,'Retail Sale Id 6219',1500.00,0.00,0.00,2.00,240.00,'2022-12-27 11:55:49','',''),(6206,'1','285','1',1,'Retail Sale Id 6220',2002.50,0.00,0.00,2.67,320.40,'2022-12-27 11:56:32','',''),(6207,'1','285','1',1,'Retail Sale Id 6221',900.00,0.00,0.00,1.20,144.00,'2022-12-27 11:57:15','',''),(6208,'1','285','1',1,'Retail Sale Id 6222',3000.00,0.00,0.00,4.00,480.00,'2022-12-27 11:58:39','',''),(6209,'1','285','1',1,'Retail Sale Id 6223',802.50,0.00,0.00,1.07,128.40,'2022-12-27 12:04:14','',''),(6210,'1','285','1',1,'Retail Sale Id 6224',1500.00,0.00,0.00,2.00,240.00,'2022-12-27 12:05:55','',''),(6211,'1','285','1',1,'Retail Sale Id 6225',2302.50,0.00,0.00,3.07,368.40,'2022-12-27 12:09:12','',''),(6212,'1','285','1',1,'Retail Sale Id 6226',3000.00,0.00,0.00,4.00,480.00,'2022-12-27 12:12:43','',''),(6213,'1','285','1',1,'Retail Sale Id 6227',40883.40,0.00,0.00,61.02,2440.80,'2022-12-27 12:37:27','',''),(6214,'1','285','1',1,'Retail Sale Id 6228',41131.30,0.00,0.00,61.39,2455.60,'2022-12-27 12:44:43','',''),(6215,'1','285','1',1,'Retail Sale Id 6229',40615.40,0.00,0.00,60.62,2424.80,'2022-12-27 12:53:10','',''),(6216,'1','285','1',1,'Retail Sale Id 6230',802.50,0.00,0.00,1.07,128.40,'2022-12-27 12:58:11','',''),(6217,'1','285','1',1,'Retail Sale Id 6231',1500.00,0.00,0.00,2.00,240.00,'2022-12-27 12:59:29','',''),(6218,'1','285','1',1,'Retail Sale Id 6232',40200.00,0.00,0.00,60.00,2400.00,'2022-12-27 13:08:32','',''),(6219,'1','285','1',1,'Retail Sale Id 6233',750.00,0.00,0.00,1.00,120.00,'2022-12-27 13:12:03','',''),(6220,'1','285','1',1,'Retail Sale Id 6235',40200.00,0.00,0.00,60.00,2400.00,'2022-12-27 13:15:45','',''),(6221,'1','285','1',1,'Retail Sale Id 6236',49124.40,0.00,0.00,73.32,2932.80,'2022-12-27 13:17:11','',''),(6222,'1','285','1',1,'Retail Sale Id 6237',6000.00,0.00,0.00,8.00,960.00,'2022-12-27 14:11:28','',''),(6223,'1','285','1',1,'Retail Sale Id 6239',34123.10,0.00,0.00,50.93,2037.20,'2022-12-27 14:33:13','',''),(6224,'1','285','1',1,'Retail Sale Id 6240',1500.00,0.00,0.00,2.00,240.00,'2022-12-27 14:35:29','',''),(6225,'1','285','1',1,'Retail Sale Id 6241',2250.00,0.00,0.00,3.00,360.00,'2022-12-27 14:36:21','',''),(6226,'1','285','1',1,'Retail Sale Id 6242',11684.80,0.00,0.00,17.44,697.60,'2022-12-27 14:38:31','',''),(6227,'1','285','1',1,'Retail Sale Id 6243',1500.00,0.00,0.00,2.00,240.00,'2022-12-27 14:40:54','',''),(6228,'1','285','1',1,'Retail Sale Id 6244',1500.00,0.00,0.00,2.00,240.00,'2022-12-27 14:52:02','',''),(6229,'1','285','1',1,'Retail Sale Id 6245',23302.60,0.00,0.00,34.78,1391.20,'2022-12-27 14:55:31','',''),(6230,'1','285','1',1,'Retail Sale Id 6246',2002.50,0.00,0.00,2.67,320.40,'2022-12-27 15:02:39','',''),(6231,'1','285','1',1,'Retail Sale Id 6247',1500.00,0.00,0.00,2.00,240.00,'2022-12-27 15:19:48','',''),(6232,'1','285','1',1,'Retail Sale Id 6248',3750.00,0.00,0.00,5.00,600.00,'2022-12-27 15:22:19','',''),(6233,'1','285','1',1,'Retail Sale Id 6249',1500.00,0.00,0.00,2.00,240.00,'2022-12-27 15:31:45','',''),(6234,'1','285','1',1,'Retail Sale Id 6250',1500.00,0.00,0.00,2.00,240.00,'2022-12-27 15:38:42','',''),(6235,'1','285','1',1,'Retail Sale Id 6251',1500.00,0.00,0.00,2.00,240.00,'2022-12-27 15:55:18','',''),(6236,'1','285','1',1,'Retail Sale Id 6252',3000.00,0.00,0.00,4.00,480.00,'2022-12-27 16:03:40','',''),(6237,'1','285','1',1,'Retail Sale Id 6253',1500.00,0.00,0.00,2.00,240.00,'2022-12-27 16:09:59','',''),(6238,'1','285','1',1,'Retail Sale Id 6254',5302.50,0.00,0.00,7.07,848.40,'2022-12-27 16:11:40','',''),(6239,'1','285','1',1,'Retail Sale Id 6255',4500.00,0.00,0.00,6.00,720.00,'2022-12-27 16:24:48','',''),(6240,'1','285','1',1,'Retail Sale Id 6256',1500.00,0.00,0.00,2.00,240.00,'2022-12-27 16:31:50','',''),(6241,'1','285','1',1,'Retail Sale Id 6257',2302.50,0.00,0.00,3.07,368.40,'2022-12-27 16:32:53','',''),(6242,'1','285','1',1,'Retail Sale Id 6258',2002.50,0.00,0.00,2.67,320.40,'2022-12-27 16:36:01','',''),(6243,'1','285','1',1,'Retail Sale Id 6259',2250.00,0.00,0.00,3.00,360.00,'2022-12-27 16:40:39','',''),(6244,'1','285','1',1,'Retail Sale Id 6260',1500.00,0.00,0.00,2.00,240.00,'2022-12-27 16:42:17','',''),(6245,'1','285','1',1,'Retail Sale Id 6261',997.50,0.00,0.00,1.33,159.60,'2022-12-27 16:48:53','',''),(6246,'1','285','1',1,'Retail Sale Id 6262',4500.00,0.00,0.00,6.00,720.00,'2022-12-27 16:49:50','',''),(6247,'1','285','1',1,'Retail Sale Id 6263',64896.20,0.00,0.00,96.86,3874.40,'2022-12-27 16:51:34','',''),(6248,'1','285','1',1,'Return of Retail Sale Id 6261',0.00,997.50,1.33,0.00,-159.60,'2022-12-27 17:44:43','',''),(6249,'1','285','1',1,'Retail Sale Id 6264',630.00,0.00,0.00,0.84,100.80,'2022-12-27 17:46:50','',''),(6250,'1','285','1',1,'Retail Sale Id 6265',2002.50,0.00,0.00,2.67,320.40,'2022-12-28 07:00:44','',''),(6251,'1','285','1',1,'Retail Sale Id 6266',1500.00,0.00,0.00,2.00,240.00,'2022-12-28 07:22:11','',''),(6252,'1','285','1',1,'Retail Sale Id 6267',1500.00,0.00,0.00,2.00,240.00,'2022-12-28 07:28:35','',''),(6253,'1','285','1',1,'Retail Sale Id 6268',3502.50,0.00,0.00,4.67,560.40,'2022-12-28 07:44:24','',''),(6254,'1','285','1',1,'Retail Sale Id 6269',1500.00,0.00,0.00,2.00,240.00,'2022-12-28 07:45:30','',''),(6255,'1','285','1',1,'Retail Sale Id 6270',1500.00,0.00,0.00,2.00,240.00,'2022-12-28 07:46:23','',''),(6256,'1','285','1',1,'Retail Sale Id 6271',3000.00,0.00,0.00,4.00,480.00,'2022-12-28 07:49:25','',''),(6257,'1','285','1',1,'Retail Sale Id 6272',1500.00,0.00,0.00,2.00,240.00,'2022-12-28 07:50:53','',''),(6258,'1','285','1',1,'Retail Sale Id 6273',2250.00,0.00,0.00,3.00,360.00,'2022-12-28 07:52:52','',''),(6259,'1','285','1',1,'Retail Sale Id 6274',45633.70,0.00,0.00,68.11,2724.40,'2022-12-28 08:04:24','',''),(6260,'1','285','1',1,'Retail Sale Id 6275',7500.00,0.00,0.00,10.00,1200.00,'2022-12-28 08:07:33','',''),(6261,'1','285','1',1,'Retail Sale Id 6276',750.00,0.00,0.00,1.00,120.00,'2022-12-28 08:14:04','',''),(6262,'1','285','1',1,'Retail Sale Id 6277',40200.00,0.00,0.00,60.00,2400.00,'2022-12-28 08:15:34','',''),(6263,'1','285','1',1,'Retail Sale Id 6278',2002.50,0.00,0.00,2.67,320.40,'2022-12-28 08:17:06','',''),(6264,'1','285','1',1,'Retail Sale Id 6279',33500.00,0.00,0.00,50.00,2000.00,'2022-12-28 08:22:30','',''),(6265,'1','285','1',1,'Retail Sale Id 6280',2250.00,0.00,0.00,3.00,360.00,'2022-12-28 08:23:55','',''),(6266,'1','285','1',1,'Retail Sale Id 6281',3000.00,0.00,0.00,4.00,480.00,'2022-12-28 08:25:28','',''),(6267,'1','285','1',1,'Retail Sale Id 6282',26800.00,0.00,0.00,40.00,1600.00,'2022-12-28 08:26:33','',''),(6268,'1','285','1',1,'Retail Sale Id 6283',41895.10,0.00,0.00,62.53,2501.20,'2022-12-28 08:41:46','',''),(6269,'1','285','1',1,'Retail Sale Id 6284',802.50,0.00,0.00,1.07,128.40,'2022-12-28 08:54:31','',''),(6270,'1','285','1',1,'Retail Sale Id 6285',49660.40,0.00,0.00,74.12,2964.80,'2022-12-28 08:56:34','',''),(6271,'1','285','1',1,'Retail Sale Id 6286',32903.70,0.00,0.00,49.11,1964.40,'2022-12-28 09:11:12','',''),(6272,'1','285','1',1,'Retail Sale Id 6287',25131.70,0.00,0.00,37.51,1500.40,'2022-12-28 09:20:23','',''),(6273,'1','285','1',1,'Retail Sale Id 6288',41024.10,0.00,0.00,61.23,2449.20,'2022-12-28 09:28:29','',''),(6274,'1','285','1',1,'Retail Sale Id 6289',11825.50,0.00,0.00,17.65,706.00,'2022-12-28 09:53:45','',''),(6275,'1','285','1',1,'Retail Sale Id 6290',1500.00,0.00,0.00,2.00,240.00,'2022-12-28 09:56:09','',''),(6276,'1','285','1',1,'Retail Sale Id 6291',802.50,0.00,0.00,1.07,128.40,'2022-12-28 09:57:06','',''),(6277,'1','285','1',1,'Retail Sale Id 6292',41024.10,0.00,0.00,61.23,2449.20,'2022-12-28 10:08:31','',''),(6278,'1','285','1',1,'Retail Sale Id 6293',3750.00,0.00,0.00,5.00,600.00,'2022-12-28 10:13:51','',''),(6279,'1','285','1',1,'Retail Sale Id 6294',1500.00,0.00,0.00,2.00,240.00,'2022-12-28 10:25:52','',''),(6280,'1','285','1',1,'Retail Sale Id 6295',3502.50,0.00,0.00,4.67,560.40,'2022-12-28 10:27:12','',''),(6281,'1','285','1',1,'Retail Sale Id 6296',1500.00,0.00,0.00,2.00,240.00,'2022-12-28 10:28:17','',''),(6282,'1','285','1',1,'Retail Sale Id 6297',40736.00,0.00,0.00,60.80,2432.00,'2022-12-28 10:29:21','',''),(6283,'1','285','1',1,'Retail Sale Id 6298',15410.00,0.00,0.00,23.00,920.00,'2022-12-28 10:34:48','',''),(6284,'1','285','1',1,'Retail Sale Id 6299',40200.00,0.00,0.00,60.00,2400.00,'2022-12-28 10:36:30','',''),(6285,'1','285','1',1,'Retail Sale Id 6300',41345.70,0.00,0.00,61.71,2468.40,'2022-12-28 10:39:11','',''),(6286,'1','285','1',1,'Retail Sale Id 6301',54765.80,0.00,0.00,81.74,3269.60,'2022-12-28 10:41:41','',''),(6287,'1','285','1',1,'Retail Sale Id 6302',2250.00,0.00,0.00,3.00,360.00,'2022-12-28 10:42:23','',''),(6288,'1','285','1',1,'Retail Sale Id 6303',1500.00,0.00,0.00,2.00,240.00,'2022-12-28 10:54:57','',''),(6289,'1','285','1',1,'Retail Sale Id 6304',40823.10,0.00,0.00,60.93,2437.20,'2022-12-28 10:58:09','',''),(6290,'1','285','1',1,'Retail Sale Id 6305',750.00,0.00,0.00,1.00,120.00,'2022-12-28 11:01:45','',''),(6291,'1','285','1',1,'Retail Sale Id 6306',1500.00,0.00,0.00,2.00,240.00,'2022-12-28 11:05:45','',''),(6292,'1','285','1',1,'Retail Sale Id 6307',22110.00,0.00,0.00,33.00,1320.00,'2022-12-28 11:07:06','',''),(6293,'1','285','1',1,'Retail Sale Id 6308',1500.00,0.00,0.00,2.00,240.00,'2022-12-28 11:12:56','',''),(6294,'1','285','1',1,'Retail Sale Id 6309',57144.30,0.00,0.00,85.29,3411.60,'2022-12-28 11:14:04','',''),(6295,'1','285','1',1,'Retail Sale Id 6310',4500.00,0.00,0.00,6.00,720.00,'2022-12-28 11:30:58','',''),(6296,'1','285','1',1,'Retail Sale Id 6311',1500.00,0.00,0.00,2.00,240.00,'2022-12-28 11:33:30','',''),(6297,'1','285','1',1,'Retail Sale Id 6312',997.50,0.00,0.00,1.33,159.60,'2022-12-28 11:36:38','',''),(6298,'1','285','1',1,'Retail Sale Id 6313',3000.00,0.00,0.00,4.00,480.00,'2022-12-28 11:39:28','',''),(6299,'1','285','1',1,'Retail Sale Id 6314',22110.00,0.00,0.00,33.00,1320.00,'2022-12-28 11:56:22','',''),(6300,'1','285','1',1,'Retail Sale Id 6315',1500.00,0.00,0.00,2.00,240.00,'2022-12-28 12:01:29','',''),(6301,'1','285','1',1,'Retail Sale Id 6316',8250.00,0.00,0.00,11.00,1320.00,'2022-12-28 12:02:16','',''),(6302,'1','285','1',1,'Retail Sale Id 6317',2250.00,0.00,0.00,3.00,360.00,'2022-12-28 12:04:27','',''),(6303,'1','285','1',1,'Retail Sale Id 6318',2250.00,0.00,0.00,3.00,360.00,'2022-12-28 12:06:40','',''),(6304,'1','285','1',1,'Retail Sale Id 6319',750.00,0.00,0.00,1.00,120.00,'2022-12-28 12:07:31','',''),(6305,'1','285','1',1,'Retail Sale Id 6320',40870.00,0.00,0.00,61.00,2440.00,'2022-12-28 12:12:03','',''),(6306,'1','285','1',1,'Retail Sale Id 6321',802.50,0.00,0.00,1.07,128.40,'2022-12-28 12:14:26','',''),(6307,'1','285','1',1,'Retail Sale Id 6322',1500.00,0.00,0.00,2.00,240.00,'2022-12-28 12:15:13','',''),(6308,'1','285','1',1,'Retail Sale Id 6323',2250.00,0.00,0.00,3.00,360.00,'2022-12-28 12:16:10','',''),(6309,'1','285','1',1,'Retail Sale Id 6324',40200.00,0.00,0.00,60.00,2400.00,'2022-12-28 12:17:25','',''),(6310,'1','285','1',1,'Retail Sale Id 6325',47563.30,0.00,0.00,70.99,2839.60,'2022-12-28 12:22:59','',''),(6311,'1','285','1',1,'Retail Sale Id 6326',2680.00,0.00,0.00,4.00,160.00,'2022-12-28 12:28:10','',''),(6312,'1','285','1',1,'Retail Sale Id 6327',39530.00,0.00,0.00,59.00,2360.00,'2022-12-28 12:31:09','',''),(6313,'1','285','1',1,'Retail Sale Id 6328',750.00,0.00,0.00,1.00,120.00,'2022-12-28 12:35:17','',''),(6314,'1','285','1',1,'Retail Sale Id 6330',11477.10,0.00,0.00,17.13,685.20,'2022-12-28 12:37:27','',''),(6315,'1','285','1',1,'Retail Sale Id 6331',41010.70,0.00,0.00,61.21,2448.40,'2022-12-28 12:41:30','',''),(6316,'1','285','1',1,'Retail Sale Id 6332',4500.00,0.00,0.00,6.00,720.00,'2022-12-28 12:43:55','',''),(6317,'1','285','1',1,'Retail Sale Id 6333',108935.30,0.00,0.00,162.59,6503.60,'2022-12-28 12:48:01','',''),(6318,'1','285','1',1,'Retail Sale Id 6334',802.50,0.00,0.00,1.07,128.40,'2022-12-28 12:57:45','',''),(6319,'1','285','1',1,'Retail Sale Id 6335',8250.00,0.00,0.00,11.00,1320.00,'2022-12-28 13:16:58','',''),(6320,'1','285','1',1,'Retail Sale Id 6336',3000.00,0.00,0.00,4.00,480.00,'2022-12-28 13:27:32','',''),(6321,'1','285','1',1,'Retail Sale Id 6337',997.50,0.00,0.00,1.33,159.60,'2022-12-28 13:29:34','',''),(6322,'1','285','1',1,'Retail Sale Id 6338',1500.00,0.00,0.00,2.00,240.00,'2022-12-28 13:34:21','',''),(6323,'1','285','1',1,'Retail Sale Id 6339',9375.00,0.00,0.00,12.50,1500.00,'2022-12-28 13:58:47','',''),(6324,'1','285','1',1,'Retail Sale Id 6340',40937.00,0.00,0.00,61.10,2444.00,'2022-12-28 14:31:39','',''),(6325,'1','285','1',1,'Retail Sale Id 6341',4500.00,0.00,0.00,6.00,720.00,'2022-12-28 14:57:40','',''),(6326,'1','285','1',1,'Retail Sale Id 6342',2250.00,0.00,0.00,3.00,360.00,'2022-12-28 15:01:06','',''),(6327,'1','285','1',1,'Retail Sale Id 6343',1500.00,0.00,0.00,2.00,240.00,'2022-12-28 15:04:17','',''),(6328,'1','285','1',1,'Retail Sale Id 6344',9366.60,0.00,0.00,13.98,559.20,'2022-12-28 15:05:58','',''),(6329,'1','285','1',1,'Retail Sale Id 6345',750.00,0.00,0.00,1.00,120.00,'2022-12-28 15:24:35','',''),(6330,'1','285','1',1,'Retail Sale Id 6346',1200.00,0.00,0.00,1.60,192.00,'2022-12-28 15:25:38','',''),(6331,'1','285','1',1,'Retail Sale Id 6347',6750.00,0.00,0.00,9.00,1080.00,'2022-12-28 15:30:28','',''),(6332,'1','285','1',1,'Retail Sale Id 6348',3000.00,0.00,0.00,4.00,480.00,'2022-12-28 15:31:39','',''),(6333,'1','285','1',1,'Retail Sale Id 6349',4500.00,0.00,0.00,6.00,720.00,'2022-12-28 15:33:45','',''),(6334,'1','285','1',1,'Retail Sale Id 6350',2250.00,0.00,0.00,3.00,360.00,'2022-12-28 15:39:09','',''),(6335,'1','285','1',1,'Retail Sale Id 6351',2497.50,0.00,0.00,3.33,399.60,'2022-12-28 15:43:48','',''),(6336,'1','285','1',1,'Retail Sale Id 6352',1500.00,0.00,0.00,2.00,240.00,'2022-12-28 15:47:30','',''),(6337,'1','285','1',1,'Retail Sale Id 6353',2250.00,0.00,0.00,3.00,360.00,'2022-12-28 15:48:42','',''),(6338,'1','285','1',1,'Return of Retail Sale Id 6349',0.00,4500.00,6.00,0.00,-720.00,'2022-12-28 15:58:06','',''),(6339,'1','285','1',1,'Retail Sale Id 6354',1500.00,0.00,0.00,2.00,240.00,'2022-12-28 16:00:32','',''),(6340,'1','285','1',1,'Retail Sale Id 6355',2250.00,0.00,0.00,3.00,360.00,'2022-12-28 16:12:15','',''),(6341,'1','285','1',1,'Retail Sale Id 6356',1500.00,0.00,0.00,2.00,240.00,'2022-12-28 16:16:32','',''),(6342,'1','285','1',1,'Retail Sale Id 6357',1500.00,0.00,0.00,2.00,240.00,'2022-12-28 16:24:52','',''),(6343,'1','285','1',1,'Retail Sale Id 6358',2250.00,0.00,0.00,3.00,360.00,'2022-12-28 16:27:54','',''),(6344,'1','285','1',1,'Retail Sale Id 6359',3000.00,0.00,0.00,4.00,480.00,'2022-12-28 16:28:54','',''),(6345,'1','285','1',1,'Retail Sale Id 6360',4500.00,0.00,0.00,6.00,720.00,'2022-12-28 16:29:50','',''),(6346,'1','285','1',1,'Return of Retail Sale Id 6358',0.00,2250.00,3.00,0.00,-360.00,'2022-12-28 16:31:47','',''),(6347,'1','285','1',1,'Retail Sale Id 6361',33500.00,0.00,0.00,50.00,2000.00,'2022-12-28 16:32:54','',''),(6348,'1','285','1',1,'Retail Sale Id 6362',1500.00,0.00,0.00,2.00,240.00,'2022-12-28 16:34:58','',''),(6349,'1','285','1',1,'Retail Sale Id 6363',750.00,0.00,0.00,1.00,120.00,'2022-12-28 16:38:51','',''),(6350,'1','285','1',1,'Retail Sale Id 6364',43148.00,0.00,0.00,64.40,2576.00,'2022-12-28 16:42:03','',''),(6351,'1','285','1',1,'Retail Sale Id 6365',1500.00,0.00,0.00,2.00,240.00,'2022-12-28 16:45:03','',''),(6352,'1','285','1',1,'Retail Sale Id 6366',5250.00,0.00,0.00,7.00,840.00,'2022-12-28 16:46:23','',''),(6353,'1','285','1',1,'Retail Sale Id 6367',3000.00,0.00,0.00,4.00,480.00,'2022-12-28 16:49:58','',''),(6354,'1','285','1',1,'Retail Sale Id 6368',1500.00,0.00,0.00,2.00,240.00,'2022-12-28 16:51:31','',''),(6355,'1','285','1',1,'Retail Sale Id 6369',34324.10,0.00,0.00,51.23,2049.20,'2022-12-28 16:55:25','',''),(6356,'1','285','1',1,'Retail Sale Id 6370',3000.00,0.00,0.00,4.00,480.00,'2022-12-28 16:59:19','',''),(6357,'1','285','1',1,'Retail Sale Id 6371',3000.00,0.00,0.00,4.00,480.00,'2022-12-28 17:17:47','',''),(6358,'1','285','1',1,'Retail Sale Id 6372',1500.00,0.00,0.00,2.00,240.00,'2022-12-28 17:18:46','',''),(6359,'1','285','1',1,'Retail Sale Id 6373',3750.00,0.00,0.00,5.00,600.00,'2022-12-28 17:19:50','',''),(6360,'1','285','1',1,'Retail Sale Id 6374',9750.00,0.00,0.00,13.00,1560.00,'2022-12-28 17:22:28','',''),(6361,'1','285','1',1,'Retail Sale Id 6375',422414.65,0.00,0.00,635.21,22232.35,'2022-12-28 17:33:03','',''),(6362,'1','285','1',1,'Retail Sale Id 6376',110735.80,0.00,0.00,166.52,5828.20,'2022-12-28 17:35:08','',''),(6363,'1','285','1',1,'Retail Sale Id 6377',2212.50,0.00,0.00,2.95,354.00,'2022-12-28 19:05:58','',''),(6364,'1','285','1',1,'Retail Sale Id 6378',5118.80,0.00,0.00,7.64,305.60,'2022-12-28 19:11:04','',''),(6365,'1','285','1',1,'Retail Sale Id 6379',1500.00,0.00,0.00,2.00,240.00,'2022-12-29 07:14:06','',''),(6366,'1','285','1',1,'Retail Sale Id 6380',41767.80,0.00,0.00,62.34,2493.60,'2022-12-29 07:16:13','',''),(6367,'1','285','1',1,'Retail Sale Id 6381',40689.10,0.00,0.00,60.73,2429.20,'2022-12-29 07:22:13','',''),(6368,'1','285','1',1,'Retail Sale Id 6382',2197.50,0.00,0.00,2.93,351.60,'2022-12-29 07:25:03','',''),(6369,'1','285','1',1,'Retail Sale Id 6383',14740.00,0.00,0.00,22.00,880.00,'2022-12-29 07:26:29','',''),(6370,'1','285','1',1,'Retail Sale Id 6384',49667.10,0.00,0.00,74.13,2965.20,'2022-12-29 07:28:21','',''),(6371,'1','285','1',1,'Retail Sale Id 6385',118234.90,0.00,0.00,176.47,7058.80,'2022-12-29 07:32:44','',''),(6372,'1','285','1',1,'Retail Sale Id 6386',3000.00,0.00,0.00,4.00,480.00,'2022-12-29 07:35:34','',''),(6373,'1','285','1',1,'Retail Sale Id 6387',10036.60,0.00,0.00,14.98,599.20,'2022-12-29 07:40:38','',''),(6374,'1','285','1',1,'Retail Sale Id 6388',3000.00,0.00,0.00,4.00,480.00,'2022-12-29 07:44:33','',''),(6375,'1','285','1',1,'Retail Sale Id 6389',2250.00,0.00,0.00,3.00,360.00,'2022-12-29 07:50:04','',''),(6376,'1','285','1',1,'Retail Sale Id 6390',1500.00,0.00,0.00,2.00,240.00,'2022-12-29 07:50:55','',''),(6377,'1','285','1',1,'Retail Sale Id 6391',802.50,0.00,0.00,1.07,128.40,'2022-12-29 07:51:54','',''),(6378,'1','285','1',1,'Retail Sale Id 6392',1500.00,0.00,0.00,2.00,240.00,'2022-12-29 07:52:43','',''),(6379,'1','285','1',1,'Retail Sale Id 6393',997.50,0.00,0.00,1.33,159.60,'2022-12-29 07:57:36','',''),(6380,'1','285','1',1,'Retail Sale Id 6395',5002.50,0.00,0.00,6.67,800.40,'2022-12-29 07:59:20','',''),(6381,'1','285','1',1,'Retail Sale Id 6396',33500.00,0.00,0.00,50.00,2000.00,'2022-12-29 08:00:25','',''),(6382,'1','285','1',1,'Retail Sale Id 6397',40749.40,0.00,0.00,60.82,2432.80,'2022-12-29 08:02:28','',''),(6383,'1','285','1',1,'Retail Sale Id 6398',802.50,0.00,0.00,1.07,128.40,'2022-12-29 08:03:25','',''),(6384,'1','285','1',1,'Retail Sale Id 6399',40200.00,0.00,0.00,60.00,2400.00,'2022-12-29 08:05:59','',''),(6385,'1','285','1',1,'Retail Sale Id 6400',41908.50,0.00,0.00,62.55,2502.00,'2022-12-29 08:12:42','',''),(6386,'1','285','1',1,'Retail Sale Id 6401',1500.00,0.00,0.00,2.00,240.00,'2022-12-29 08:18:54','',''),(6387,'1','285','1',1,'Retail Sale Id 6402',997.50,0.00,0.00,1.33,159.60,'2022-12-29 08:19:33','',''),(6388,'1','285','1',1,'Retail Sale Id 6403',3000.00,0.00,0.00,4.00,480.00,'2022-12-29 08:20:19','',''),(6389,'1','285','1',1,'Retail Sale Id 6404',41506.50,0.00,0.00,61.95,2478.00,'2022-12-29 08:21:48','',''),(6390,'1','285','1',1,'Retail Sale Id 6405',1500.00,0.00,0.00,2.00,240.00,'2022-12-29 08:25:12','',''),(6391,'1','285','1',1,'Retail Sale Id 6406',1500.00,0.00,0.00,2.00,240.00,'2022-12-29 08:30:51','',''),(6392,'1','285','1',1,'Retail Sale Id 6407',1500.00,0.00,0.00,2.00,240.00,'2022-12-29 08:35:43','',''),(6393,'1','285','1',1,'Retail Sale Id 6408',39530.00,0.00,0.00,59.00,2360.00,'2022-12-29 08:47:24','',''),(6394,'1','285','1',1,'Retail Sale Id 6409',2002.50,0.00,0.00,2.67,320.40,'2022-12-29 08:48:41','',''),(6395,'1','285','1',1,'Retail Sale Id 6410',53600.00,0.00,0.00,80.00,3200.00,'2022-12-29 08:51:59','',''),(6396,'1','285','1',1,'Retail Sale Id 6411',1500.00,0.00,0.00,2.00,240.00,'2022-12-29 08:54:15','',''),(6397,'1','285','1',1,'Retail Sale Id 6412',131902.90,0.00,0.00,196.87,7874.80,'2022-12-29 08:57:16','',''),(6398,'1','285','1',1,'Retail Sale Id 6413',1500.00,0.00,0.00,2.00,240.00,'2022-12-29 09:02:10','',''),(6399,'1','285','1',1,'Retail Sale Id 6414',2250.00,0.00,0.00,3.00,360.00,'2022-12-29 09:03:03','',''),(6400,'1','285','1',1,'Retail Sale Id 6415',2250.00,0.00,0.00,3.00,360.00,'2022-12-29 09:09:37','',''),(6401,'1','285','1',1,'Retail Sale Id 6416',997.50,0.00,0.00,1.33,159.60,'2022-12-29 09:19:13','',''),(6402,'1','285','1',1,'Retail Sale Id 6417',39637.20,0.00,0.00,59.16,2366.40,'2022-12-29 09:35:55','',''),(6403,'1','285','1',1,'Retail Sale Id 6418',15925.90,0.00,0.00,23.77,950.80,'2022-12-29 09:41:07','',''),(6404,'1','285','1',1,'Retail Sale Id 6419',31920.00,0.00,0.00,48.00,1680.00,'2022-12-29 09:47:11','',''),(6405,'1','285','1',1,'Retail Sale Id 6420',21888.90,0.00,0.00,32.67,1306.80,'2022-12-29 09:52:34','',''),(6406,'1','285','1',1,'Return of Retail Sale Id 6420',0.00,21888.90,32.67,0.00,-1306.80,'2022-12-29 09:56:15','',''),(6407,'1','285','1',1,'Retail Sale Id 6421',22558.90,0.00,0.00,33.67,1346.80,'2022-12-29 09:57:10','',''),(6408,'1','285','1',1,'Retail Sale Id 6422',1500.00,0.00,0.00,2.00,240.00,'2022-12-29 09:58:52','',''),(6409,'1','285','1',1,'Retail Sale Id 6423',266000.00,0.00,0.00,400.00,14000.00,'2022-12-29 10:07:19','',''),(6410,'1','285','1',1,'Retail Sale Id 6424',1500.00,0.00,0.00,2.00,240.00,'2022-12-29 10:11:27','',''),(6411,'1','285','1',1,'Retail Sale Id 6425',15410.00,0.00,0.00,23.00,920.00,'2022-12-29 10:21:46','',''),(6412,'1','285','1',1,'Retail Sale Id 6426',4500.00,0.00,0.00,6.00,720.00,'2022-12-29 10:24:12','',''),(6413,'1','285','1',1,'Retail Sale Id 6427',802.50,0.00,0.00,1.07,128.40,'2022-12-29 10:27:18','',''),(6414,'1','285','1',1,'Retail Sale Id 6428',997.50,0.00,0.00,1.33,159.60,'2022-12-29 10:33:49','',''),(6415,'1','285','1',1,'Retail Sale Id 6429',68353.40,0.00,0.00,102.02,4080.80,'2022-12-29 10:37:06','',''),(6416,'1','285','1',1,'Retail Sale Id 6430',33285.60,0.00,0.00,49.68,1987.20,'2022-12-29 10:42:05','',''),(6417,'1','285','1',1,'Retail Sale Id 6432',376110.70,0.00,0.00,565.58,19795.30,'2022-12-29 10:59:38','',''),(6418,'1','285','1',1,'Retail Sale Id 6433',202654.90,0.00,0.00,302.47,12098.80,'2022-12-29 11:31:51','',''),(6419,'1','285','1',1,'Retail Sale Id 6434',53600.00,0.00,0.00,80.00,3200.00,'2022-12-29 11:38:31','',''),(6420,'1','285','1',1,'Retail Sale Id 6435',527671.90,0.00,0.00,787.57,31502.80,'2022-12-29 11:42:08','',''),(6421,'1','285','1',1,'Return of Retail Sale Id 6435',0.00,527671.90,787.57,0.00,-31502.80,'2022-12-29 11:42:33','',''),(6422,'1','285','1',1,'Retail Sale Id 6436',523734.05,0.00,0.00,787.57,27564.95,'2022-12-29 11:43:20','',''),(6423,'1','285','1',1,'Retail Sale Id 6437',279300.00,0.00,0.00,420.00,14700.00,'2022-12-29 11:46:20','',''),(6424,'1','285','1',1,'Retail Sale Id 6438',26800.00,0.00,0.00,40.00,1600.00,'2022-12-29 11:52:41','',''),(6425,'1','285','1',1,'Retail Sale Id 6439',997.50,0.00,0.00,1.33,159.60,'2022-12-29 12:30:41','',''),(6426,'1','285','1',1,'Retail Sale Id 6440',2250.00,0.00,0.00,3.00,360.00,'2022-12-29 12:35:28','',''),(6427,'1','285','1',1,'Retail Sale Id 6441',997.50,0.00,0.00,1.33,159.60,'2022-12-29 12:51:26','',''),(6428,'1','285','1',1,'Retail Sale Id 6442',1500.00,0.00,0.00,2.00,240.00,'2022-12-29 13:02:22','',''),(6429,'1','285','1',1,'Retail Sale Id 6443',2002.50,0.00,0.00,2.67,320.40,'2022-12-29 13:20:36','',''),(6430,'1','285','1',1,'Retail Sale Id 6444',802.50,0.00,0.00,1.07,128.40,'2022-12-29 13:22:49','',''),(6431,'1','285','1',1,'Retail Sale Id 6445',6000.00,0.00,0.00,8.00,960.00,'2022-12-29 13:23:50','',''),(6432,'1','285','1',1,'Retail Sale Id 6446',40729.30,0.00,0.00,60.79,2431.60,'2022-12-29 13:37:43','',''),(6433,'1','285','1',1,'Retail Sale Id 6447',3000.00,0.00,0.00,4.00,480.00,'2022-12-29 13:57:32','',''),(6434,'1','285','1',1,'Retail Sale Id 6448',1500.00,0.00,0.00,2.00,240.00,'2022-12-29 14:09:54','',''),(6435,'1','285','1',1,'Retail Sale Id 6449',35677.50,0.00,0.00,53.25,2130.00,'2022-12-29 14:14:27','',''),(6436,'1','285','1',1,'Return of Retail Sale Id 6449',0.00,35677.50,53.25,0.00,-2130.00,'2022-12-29 14:27:27','',''),(6437,'1','285','1',1,'Retail Sale Id 6450',38578.60,0.00,0.00,57.58,2303.20,'2022-12-29 14:28:18','',''),(6438,'1','285','1',1,'Retail Sale Id 6451',9502.50,0.00,0.00,12.67,1520.40,'2022-12-29 14:36:42','',''),(6439,'1','285','1',1,'Retail Sale Id 6452',997.50,0.00,0.00,1.33,159.60,'2022-12-29 14:42:03','',''),(6440,'1','285','1',1,'Retail Sale Id 6453',2002.50,0.00,0.00,2.67,320.40,'2022-12-29 14:50:32','',''),(6441,'1','285','1',1,'Retail Sale Id 6454',6000.00,0.00,0.00,8.00,960.00,'2022-12-29 15:00:29','',''),(6442,'1','285','1',1,'Retail Sale Id 6455',1500.00,0.00,0.00,2.00,240.00,'2022-12-29 15:05:25','',''),(6443,'1','285','1',1,'Retail Sale Id 6456',1500.00,0.00,0.00,2.00,240.00,'2022-12-29 15:10:14','',''),(6444,'1','285','1',1,'Retail Sale Id 6457',2250.00,0.00,0.00,3.00,360.00,'2022-12-29 15:16:07','',''),(6445,'1','285','1',1,'Retail Sale Id 6458',3997.50,0.00,0.00,5.33,639.60,'2022-12-29 15:18:16','',''),(6446,'1','285','1',1,'Retail Sale Id 6459',1500.00,0.00,0.00,2.00,240.00,'2022-12-29 15:25:19','',''),(6447,'1','285','1',1,'Retail Sale Id 6460',11202.40,0.00,0.00,16.72,668.80,'2022-12-29 15:33:26','',''),(6448,'1','285','1',1,'Retail Sale Id 6461',11658.00,0.00,0.00,17.40,696.00,'2022-12-29 15:40:36','',''),(6449,'1','285','1',1,'Retail Sale Id 6462',750.00,0.00,0.00,1.00,120.00,'2022-12-29 15:42:26','',''),(6450,'1','285','1',1,'Retail Sale Id 6463',40119.60,0.00,0.00,59.88,2395.20,'2022-12-29 15:43:39','',''),(6451,'1','285','1',1,'Retail Sale Id 6464',997.50,0.00,0.00,1.33,159.60,'2022-12-29 15:46:50','',''),(6452,'1','285','1',1,'Retail Sale Id 6465',3000.00,0.00,0.00,4.00,480.00,'2022-12-29 15:47:33','',''),(6453,'1','285','1',1,'Retail Sale Id 6466',1500.00,0.00,0.00,2.00,240.00,'2022-12-29 15:57:30','',''),(6454,'1','285','1',1,'Retail Sale Id 6467',166250.00,0.00,0.00,250.00,8750.00,'2022-12-29 15:59:03','',''),(6455,'1','285','1',1,'Retail Sale Id 6468',1500.00,0.00,0.00,2.00,240.00,'2022-12-29 16:01:56','',''),(6456,'1','285','1',1,'Retail Sale Id 6469',86450.00,0.00,0.00,130.00,4550.00,'2022-12-29 16:09:24','',''),(6457,'1','285','1',1,'Retail Sale Id 6470',750.00,0.00,0.00,1.00,120.00,'2022-12-29 16:11:17','',''),(6458,'1','285','1',1,'Retail Sale Id 6471',16220.70,0.00,0.00,24.21,968.40,'2022-12-29 16:15:41','',''),(6459,'1','285','1',1,'Retail Sale Id 6472',3000.00,0.00,0.00,4.00,480.00,'2022-12-29 16:23:08','',''),(6460,'1','285','1',1,'Retail Sale Id 6473',4500.00,0.00,0.00,6.00,720.00,'2022-12-29 16:26:54','',''),(6461,'1','285','1',1,'Retail Sale Id 6474',19651.10,0.00,0.00,29.33,1173.20,'2022-12-29 16:31:23','',''),(6462,'1','285','1',1,'Retail Sale Id 6475',3750.00,0.00,0.00,5.00,600.00,'2022-12-29 16:35:50','',''),(6463,'1','285','1',1,'Retail Sale Id 6476',500552.15,0.00,0.00,752.71,26344.85,'2022-12-29 16:40:49','',''),(6464,'1','285','1',1,'Retail Sale Id 6477',10500.00,0.00,0.00,14.00,1680.00,'2022-12-29 16:43:28','',''),(6465,'1','285','1',1,'Retail Sale Id 6478',10500.00,0.00,0.00,14.00,1680.00,'2022-12-29 16:44:29','',''),(6466,'1','285','1',1,'Retail Sale Id 6479',3000.00,0.00,0.00,4.00,480.00,'2022-12-29 16:46:02','',''),(6467,'1','285','1',1,'Retail Sale Id 6480',1500.00,0.00,0.00,2.00,240.00,'2022-12-29 16:47:08','',''),(6468,'1','285','1',1,'Retail Sale Id 6481',3000.00,0.00,0.00,4.00,480.00,'2022-12-29 16:53:40','',''),(6469,'1','285','1',1,'Retail Sale Id 6482',1500.00,0.00,0.00,2.00,240.00,'2022-12-29 16:57:28','',''),(6470,'1','285','1',1,'Retail Sale Id 6484',750.00,0.00,0.00,1.00,120.00,'2022-12-29 17:01:39','',''),(6471,'1','285','1',1,'Retail Sale Id 6485',750.00,0.00,0.00,1.00,120.00,'2022-12-29 17:02:26','',''),(6472,'1','285','1',1,'Retail Sale Id 6486',41225.10,0.00,0.00,61.53,2461.20,'2022-12-29 17:03:17','',''),(6473,'1','285','1',1,'Retail Sale Id 6487',3000.00,0.00,0.00,4.00,480.00,'2022-12-29 17:05:21','',''),(6474,'1','285','1',1,'Retail Sale Id 6488',750.00,0.00,0.00,1.00,120.00,'2022-12-29 17:07:16','',''),(6475,'1','285','1',1,'Retail Sale Id 6489',750.00,0.00,0.00,1.00,120.00,'2022-12-29 17:08:36','',''),(6476,'1','285','1',1,'Retail Sale Id 6490',9375.00,0.00,0.00,12.50,1500.00,'2022-12-29 17:10:06','',''),(6477,'1','285','1',1,'Retail Sale Id 6491',3000.00,0.00,0.00,4.00,480.00,'2022-12-29 17:12:23','',''),(6478,'1','285','1',1,'Retail Sale Id 6492',3000.00,0.00,0.00,4.00,480.00,'2022-12-30 06:58:24','',''),(6479,'1','285','1',1,'Retail Sale Id 6493',1500.00,0.00,0.00,2.00,240.00,'2022-12-30 07:00:33','',''),(6480,'1','285','1',1,'Retail Sale Id 6494',294182.70,0.00,0.00,442.38,15483.30,'2022-12-30 07:03:26','',''),(6481,'1','285','1',1,'Retail Sale Id 6495',3000.00,0.00,0.00,4.00,480.00,'2022-12-30 07:10:21','',''),(6482,'1','285','1',1,'Retail Sale Id 6496',1500.00,0.00,0.00,2.00,240.00,'2022-12-30 07:16:24','',''),(6483,'1','285','1',1,'Retail Sale Id 6497',44668.90,0.00,0.00,66.67,2666.80,'2022-12-30 07:18:25','',''),(6484,'1','285','1',1,'Retail Sale Id 6498',1500.00,0.00,0.00,2.00,240.00,'2022-12-30 07:19:28','',''),(6485,'1','285','1',1,'Retail Sale Id 6499',997.50,0.00,0.00,1.33,159.60,'2022-12-30 07:25:10','',''),(6486,'1','285','1',1,'Return of Retail Sale Id 6497',0.00,44668.90,66.67,0.00,-2666.80,'2022-12-30 07:28:51','',''),(6487,'1','285','1',1,'Retail Sale Id 6500',46008.90,0.00,0.00,68.67,2746.80,'2022-12-30 07:30:02','',''),(6488,'1','285','1',1,'Retail Sale Id 6501',997.50,0.00,0.00,1.33,159.60,'2022-12-30 07:33:22','',''),(6489,'1','285','1',1,'Retail Sale Id 6502',20100.00,0.00,0.00,30.00,1200.00,'2022-12-30 07:36:19','',''),(6490,'1','285','1',1,'Retail Sale Id 6503',41741.00,0.00,0.00,62.30,2492.00,'2022-12-30 07:38:33','',''),(6491,'1','285','1',1,'Retail Sale Id 6504',40796.30,0.00,0.00,60.89,2435.60,'2022-12-30 07:48:03','',''),(6492,'1','285','1',1,'Retail Sale Id 6505',2002.50,0.00,0.00,2.67,320.40,'2022-12-30 07:51:14','',''),(6493,'1','285','1',1,'Retail Sale Id 6506',9000.00,0.00,0.00,12.00,1440.00,'2022-12-30 08:01:48','',''),(6494,'1','285','1',1,'Retail Sale Id 6507',9000.00,0.00,0.00,12.00,1440.00,'2022-12-30 08:02:28','',''),(6495,'1','285','1',1,'Retail Sale Id 6508',6000.00,0.00,0.00,8.00,960.00,'2022-12-30 08:04:05','',''),(6496,'1','285','1',1,'Retail Sale Id 6509',81599.30,0.00,0.00,121.79,4871.60,'2022-12-30 08:05:54','',''),(6497,'1','285','1',1,'Retail Sale Id 6510',40977.20,0.00,0.00,61.16,2446.40,'2022-12-30 08:08:01','',''),(6498,'1','285','1',1,'Retail Sale Id 6511',1500.00,0.00,0.00,2.00,240.00,'2022-12-30 08:15:11','',''),(6499,'1','285','1',1,'Retail Sale Id 6512',1500.00,0.00,0.00,2.00,240.00,'2022-12-30 08:17:10','',''),(6500,'1','285','1',1,'Retail Sale Id 6513',3750.00,0.00,0.00,5.00,600.00,'2022-12-30 08:19:11','',''),(6501,'1','285','1',1,'Retail Sale Id 6514',14250.00,0.00,0.00,19.00,2280.00,'2022-12-30 08:21:04','',''),(6502,'1','285','1',1,'Retail Sale Id 6515',9862.40,0.00,0.00,14.72,588.80,'2022-12-30 08:22:30','',''),(6503,'1','285','1',1,'Retail Sale Id 6516',2250.00,0.00,0.00,3.00,360.00,'2022-12-30 08:24:06','',''),(6504,'1','285','1',1,'Retail Sale Id 6517',41024.10,0.00,0.00,61.23,2449.20,'2022-12-30 08:25:15','',''),(6505,'1','285','1',1,'Retail Sale Id 6518',40200.00,0.00,0.00,60.00,2400.00,'2022-12-30 08:28:22','',''),(6506,'1','285','1',1,'Retail Sale Id 6519',1500.00,0.00,0.00,2.00,240.00,'2022-12-30 08:30:17','',''),(6507,'1','285','1',1,'Retail Sale Id 6520',1500.00,0.00,0.00,2.00,240.00,'2022-12-30 08:31:00','',''),(6508,'1','285','1',1,'Retail Sale Id 6521',40200.00,0.00,0.00,60.00,2400.00,'2022-12-30 08:32:41','',''),(6509,'1','285','1',1,'Retail Sale Id 6522',285291.65,0.00,0.00,429.01,15015.35,'2022-12-30 08:35:03','',''),(6510,'1','285','1',1,'Retail Sale Id 6523',3000.00,0.00,0.00,4.00,480.00,'2022-12-30 08:37:08','',''),(6511,'1','285','1',1,'Retail Sale Id 6524',39530.00,0.00,0.00,59.00,2360.00,'2022-12-30 08:38:08','',''),(6512,'1','285','1',1,'Retail Sale Id 6525',40200.00,0.00,0.00,60.00,2400.00,'2022-12-30 08:40:16','',''),(6513,'1','285','1',1,'Retail Sale Id 6526',5250.00,0.00,0.00,7.00,840.00,'2022-12-30 08:41:49','',''),(6514,'1','285','1',1,'Retail Sale Id 6527',3000.00,0.00,0.00,4.00,480.00,'2022-12-30 08:44:57','',''),(6515,'1','285','1',1,'Retail Sale Id 6528',46900.00,0.00,0.00,70.00,2800.00,'2022-12-30 08:46:09','',''),(6516,'1','285','1',1,'Retail Sale Id 6529',25460.00,0.00,0.00,38.00,1520.00,'2022-12-30 08:50:35','',''),(6517,'1','285','1',1,'Retail Sale Id 6530',22994.40,0.00,0.00,34.32,1372.80,'2022-12-30 08:52:25','',''),(6518,'1','285','1',1,'Retail Sale Id 6531',39900.00,0.00,0.00,60.00,2100.00,'2022-12-30 08:54:46','',''),(6519,'1','285','1',1,'Retail Sale Id 6532',3000.00,0.00,0.00,4.00,480.00,'2022-12-30 08:55:30','',''),(6520,'1','285','1',1,'Retail Sale Id 6533',1500.00,0.00,0.00,2.00,240.00,'2022-12-30 08:56:11','',''),(6521,'1','285','1',1,'Retail Sale Id 6534',3000.00,0.00,0.00,4.00,480.00,'2022-12-30 08:56:56','',''),(6522,'1','285','1',1,'Retail Sale Id 6535',2250.00,0.00,0.00,3.00,360.00,'2022-12-30 08:57:56','',''),(6523,'1','285','1',1,'Retail Sale Id 6536',1500.00,0.00,0.00,2.00,240.00,'2022-12-30 08:59:23','',''),(6524,'1','285','1',1,'Retail Sale Id 6537',750.00,0.00,0.00,1.00,120.00,'2022-12-30 09:00:23','',''),(6525,'1','285','1',1,'Retail Sale Id 6538',70859.20,0.00,0.00,105.76,4230.40,'2022-12-30 09:14:24','',''),(6526,'1','285','1',1,'Retail Sale Id 6539',14740.00,0.00,0.00,22.00,880.00,'2022-12-30 09:19:32','',''),(6527,'1','285','1',1,'Retail Sale Id 6540',1500.00,0.00,0.00,2.00,240.00,'2022-12-30 09:20:56','',''),(6528,'1','285','1',1,'Retail Sale Id 6541',10500.00,0.00,0.00,14.00,1680.00,'2022-12-30 09:28:20','',''),(6529,'1','285','1',1,'Retail Sale Id 6542',491203.80,0.00,0.00,733.14,29325.60,'2022-12-30 09:40:03','',''),(6530,'1','285','1',1,'Return of Retail Sale Id 6542',0.00,491203.80,733.14,0.00,-29325.60,'2022-12-30 09:42:17','',''),(6531,'1','285','1',1,'Retail Sale Id 6543',487538.10,0.00,0.00,733.14,25659.90,'2022-12-30 09:43:18','',''),(6532,'1','285','1',1,'Retail Sale Id 6544',2745.00,0.00,0.00,3.66,439.20,'2022-12-30 09:49:09','',''),(6533,'1','285','1',1,'Retail Sale Id 6545',10500.00,0.00,0.00,14.00,1680.00,'2022-12-30 09:57:49','',''),(6534,'1','285','1',1,'Retail Sale Id 6546',3000.00,0.00,0.00,4.00,480.00,'2022-12-30 10:01:46','',''),(6535,'1','285','1',1,'Retail Sale Id 6547',2250.00,0.00,0.00,3.00,360.00,'2022-12-30 10:06:34','',''),(6536,'1','285','1',1,'Retail Sale Id 6548',235163.95,0.00,0.00,353.63,12377.05,'2022-12-30 10:08:26','',''),(6537,'1','285','1',1,'Retail Sale Id 6549',27470.00,0.00,0.00,41.00,1640.00,'2022-12-30 10:10:40','',''),(6538,'1','285','1',1,'Retail Sale Id 6550',2002.50,0.00,0.00,2.67,320.40,'2022-12-30 10:13:14','',''),(6539,'1','285','1',1,'Return of Retail Sale Id 6549',0.00,27470.00,41.00,0.00,-1640.00,'2022-12-30 10:17:30','',''),(6540,'1','285','1',1,'Retail Sale Id 6551',27630.80,0.00,0.00,41.24,1649.60,'2022-12-30 10:18:10','',''),(6541,'1','285','1',1,'Retail Sale Id 6552',26800.00,0.00,0.00,40.00,1600.00,'2022-12-30 10:19:48','',''),(6542,'1','285','1',1,'Retail Sale Id 6553',3750.00,0.00,0.00,5.00,600.00,'2022-12-30 10:21:04','',''),(6543,'1','285','1',1,'Retail Sale Id 6554',26974.20,0.00,0.00,40.26,1610.40,'2022-12-30 10:26:47','',''),(6544,'1','285','1',1,'Retail Sale Id 6555',41245.20,0.00,0.00,61.56,2462.40,'2022-12-30 10:28:10','',''),(6545,'1','285','1',1,'Retail Sale Id 6556',997.50,0.00,0.00,1.33,159.60,'2022-12-30 10:33:53','',''),(6546,'1','285','1',1,'Retail Sale Id 6557',1500.00,0.00,0.00,2.00,240.00,'2022-12-30 10:34:42','',''),(6547,'1','285','1',1,'Retail Sale Id 6558',750.00,0.00,0.00,1.00,120.00,'2022-12-30 10:42:26','',''),(6548,'1','285','1',1,'Retail Sale Id 6559',44876.60,0.00,0.00,66.98,2679.20,'2022-12-30 10:47:35','',''),(6549,'1','285','1',1,'Retail Sale Id 6560',1500.00,0.00,0.00,2.00,240.00,'2022-12-30 10:52:14','',''),(6550,'1','285','1',1,'Retail Sale Id 6561',750.00,0.00,0.00,1.00,120.00,'2022-12-30 10:55:32','',''),(6551,'1','285','1',1,'Retail Sale Id 6562',5250.00,0.00,0.00,7.00,840.00,'2022-12-30 10:57:56','',''),(6552,'1','285','1',1,'Retail Sale Id 6563',1500.00,0.00,0.00,2.00,240.00,'2022-12-30 11:08:38','',''),(6553,'1','285','1',1,'Retail Sale Id 6564',3750.00,0.00,0.00,5.00,600.00,'2022-12-30 11:18:52','',''),(6554,'1','285','1',1,'Retail Sale Id 6565',2250.00,0.00,0.00,3.00,360.00,'2022-12-30 11:19:33','',''),(6555,'1','285','1',1,'Retail Sale Id 6566',40501.50,0.00,0.00,60.45,2418.00,'2022-12-30 11:21:07','',''),(6556,'1','285','1',1,'Retail Sale Id 6567',1500.00,0.00,0.00,2.00,240.00,'2022-12-30 11:30:08','',''),(6557,'1','285','1',1,'Retail Sale Id 6568',4500.00,0.00,0.00,6.00,720.00,'2022-12-30 11:35:39','',''),(6558,'1','285','1',1,'Retail Sale Id 6569',3000.00,0.00,0.00,4.00,480.00,'2022-12-30 11:37:24','',''),(6559,'1','285','1',1,'Retail Sale Id 6570',75710.00,0.00,0.00,113.00,4520.00,'2022-12-30 11:40:31','',''),(6560,'1','285','1',1,'Return of Retail Sale Id 6569',0.00,3000.00,4.00,0.00,-480.00,'2022-12-30 11:44:44','',''),(6561,'1','285','1',1,'Retail Sale Id 6571',2550.00,0.00,0.00,3.40,408.00,'2022-12-30 11:45:29','',''),(6562,'1','285','1',1,'Retail Sale Id 6572',3000.00,0.00,0.00,4.00,480.00,'2022-12-30 11:46:50','',''),(6563,'1','285','1',1,'Retail Sale Id 6573',33500.00,0.00,0.00,50.00,2000.00,'2022-12-30 11:50:07','',''),(6564,'1','285','1',1,'Retail Sale Id 6574',3000.00,0.00,0.00,4.00,480.00,'2022-12-30 11:55:16','',''),(6565,'1','285','1',1,'Retail Sale Id 6575',32247.10,0.00,0.00,48.13,1925.20,'2022-12-30 12:04:39','',''),(6566,'1','285','1',1,'Retail Sale Id 6576',802.50,0.00,0.00,1.07,128.40,'2022-12-30 12:15:26','',''),(6567,'1','285','1',1,'Retail Sale Id 6577',1500.00,0.00,0.00,2.00,240.00,'2022-12-30 12:16:35','',''),(6568,'1','285','1',1,'Retail Sale Id 6578',1500.00,0.00,0.00,2.00,240.00,'2022-12-30 12:32:32','',''),(6569,'1','285','1',1,'Retail Sale Id 6580',6000.00,0.00,0.00,8.00,960.00,'2022-12-30 12:36:30','',''),(6570,'1','285','1',1,'Retail Sale Id 6581',2497.50,0.00,0.00,3.33,399.60,'2022-12-30 12:40:22','',''),(6571,'1','285','1',1,'Retail Sale Id 6582',42035.80,0.00,0.00,62.74,2509.60,'2022-12-30 12:48:05','',''),(6572,'1','285','1',1,'Retail Sale Id 6583',1500.00,0.00,0.00,2.00,240.00,'2022-12-30 12:53:29','',''),(6573,'1','285','1',1,'Retail Sale Id 6584',3000.00,0.00,0.00,4.00,480.00,'2022-12-30 13:00:54','',''),(6574,'1','285','1',1,'Retail Sale Id 6585',3997.50,0.00,0.00,5.33,639.60,'2022-12-30 13:02:12','',''),(6575,'1','285','1',1,'Retail Sale Id 6586',1500.00,0.00,0.00,2.00,240.00,'2022-12-30 13:05:34','',''),(6576,'1','285','1',1,'Retail Sale Id 6588',2302.50,0.00,0.00,3.07,368.40,'2022-12-30 13:15:55','',''),(6577,'1','285','1',1,'Retail Sale Id 6589',1402.50,0.00,0.00,1.87,224.40,'2022-12-30 13:17:25','',''),(6578,'1','285','1',1,'Retail Sale Id 6590',6000.00,0.00,0.00,8.00,960.00,'2022-12-30 13:21:25','',''),(6579,'1','285','1',1,'Retail Sale Id 6591',35322.40,0.00,0.00,52.72,2108.80,'2022-12-30 13:34:03','',''),(6580,'1','285','1',1,'Retail Sale Id 6592',38190.00,0.00,0.00,57.00,2280.00,'2022-12-30 13:50:30','',''),(6581,'1','285','1',1,'Retail Sale Id 6593',1500.00,0.00,0.00,2.00,240.00,'2022-12-30 13:54:12','',''),(6582,'1','285','1',1,'Retail Sale Id 6594',204370.10,0.00,0.00,305.03,12201.20,'2022-12-30 14:10:38','',''),(6583,'1','285','1',1,'Retail Sale Id 6595',44782.80,0.00,0.00,66.84,2673.60,'2022-12-30 14:18:15','',''),(6584,'1','285','1',1,'Retail Sale Id 6596',1500.00,0.00,0.00,2.00,240.00,'2022-12-30 14:19:27','',''),(6585,'1','285','1',1,'Retail Sale Id 6597',39784.60,0.00,0.00,59.38,2375.20,'2022-12-30 14:52:57','',''),(6586,'1','285','1',1,'Retail Sale Id 6598',40447.90,0.00,0.00,60.37,2414.80,'2022-12-30 15:13:16','',''),(6587,'1','285','1',1,'Retail Sale Id 6599',60300.00,0.00,0.00,90.00,3600.00,'2022-12-30 15:19:21','',''),(6588,'1','285','1',1,'Retail Sale Id 6600',40200.00,0.00,0.00,60.00,2400.00,'2022-12-30 16:09:56','',''),(6589,'1','285','1',1,'Retail Sale Id 6601',41660.60,0.00,0.00,62.18,2487.20,'2022-12-30 16:49:24','',''),(6590,'1','285','1',1,'Retail Sale Id 6602',30150.00,0.00,0.00,45.00,1800.00,'2022-12-30 16:50:34','',''),(6591,'1','285','1',1,'Retail Sale Id 6603',2010.00,0.00,0.00,3.00,120.00,'2022-12-30 16:54:20','',''),(6592,'1','285','1',1,'Retail Sale Id 6604',4500.00,0.00,0.00,6.00,720.00,'2022-12-30 17:06:26','',''),(6593,'1','285','1',1,'Retail Sale Id 6605',1782.20,0.00,0.00,2.66,106.40,'2022-12-30 17:23:54','',''),(6594,'1','285','1',1,'Retail Sale Id 6606',4500.00,0.00,0.00,6.00,720.00,'2022-12-30 17:27:17','',''),(6595,'1','285','1',1,'Retail Sale Id 6607',2250.00,0.00,0.00,3.00,360.00,'2022-12-30 17:28:39','',''),(6596,'1','285','1',1,'Retail Sale Id 6608',1500.00,0.00,0.00,2.00,240.00,'2022-12-30 17:29:31','',''),(6597,'1','285','1',1,'Retail Sale Id 6609',2250.00,0.00,0.00,3.00,360.00,'2022-12-30 17:33:51','',''),(6598,'1','285','1',1,'Retail Sale Id 6610',200849.95,0.00,0.00,302.03,10571.05,'2022-12-30 17:37:33','',''),(6599,'1','285','1',1,'Retail Sale Id 6611',176947.00,0.00,0.00,264.10,10564.00,'2022-12-30 17:44:36','',''),(6600,'1','285','1',1,'Retail Sale Id 6612',332500.00,0.00,0.00,500.00,17500.00,'2022-12-30 17:53:59','',''),(6601,'1','285','1',1,'Return of Retail Sale Id 6529',0.00,25460.00,38.00,0.00,-1520.00,'2022-12-30 19:19:56','',''),(6602,'1','285','1',1,'Retail Sale Id 6613',25212.10,0.00,0.00,37.63,1505.20,'2022-12-30 19:23:54','',''),(6603,'1','285','1',1,'Return of Retail Sale Id 6608',0.00,1500.00,2.00,0.00,-240.00,'2022-12-30 19:25:10','',''),(6604,'1','285','1',1,'Retail Sale Id 6614',997.50,0.00,0.00,1.33,159.60,'2022-12-30 19:26:19','',''),(6605,'1','285','1',1,'Retail Sale Id 6615',41687.40,0.00,0.00,62.22,2488.80,'2022-12-31 07:16:56','',''),(6606,'1','285','1',1,'Retail Sale Id 6616',997.50,0.00,0.00,1.33,159.60,'2022-12-31 07:19:40','',''),(6607,'1','285','1',1,'Retail Sale Id 6617',2002.50,0.00,0.00,2.67,320.40,'2022-12-31 07:20:35','',''),(6608,'1','285','1',1,'Retail Sale Id 6618',997.50,0.00,0.00,1.33,159.60,'2022-12-31 07:37:33','',''),(6609,'1','285','1',1,'Retail Sale Id 6619',40200.00,0.00,0.00,60.00,2400.00,'2022-12-31 07:38:41','',''),(6610,'1','285','1',1,'Retail Sale Id 6620',997.50,0.00,0.00,1.33,159.60,'2022-12-31 07:44:38','',''),(6611,'1','285','1',1,'Retail Sale Id 6621',2002.50,0.00,0.00,2.67,320.40,'2022-12-31 07:53:02','',''),(6612,'1','285','1',1,'Retail Sale Id 6622',41640.50,0.00,0.00,62.15,2486.00,'2022-12-31 07:54:09','',''),(6613,'1','285','1',1,'Retail Sale Id 6623',997.50,0.00,0.00,1.33,159.60,'2022-12-31 07:58:27','',''),(6614,'1','285','1',1,'Retail Sale Id 6624',82316.20,0.00,0.00,122.86,4914.40,'2022-12-31 08:01:35','',''),(6615,'1','285','1',1,'Retail Sale Id 6625',1500.00,0.00,0.00,2.00,240.00,'2022-12-31 08:03:05','',''),(6616,'1','285','1',1,'Retail Sale Id 6626',2002.50,0.00,0.00,2.67,320.40,'2022-12-31 08:04:38','',''),(6617,'1','285','1',1,'Retail Sale Id 6627',2400.00,0.00,0.00,3.20,384.00,'2022-12-31 08:07:10','',''),(6618,'1','285','1',1,'Retail Sale Id 6628',1500.00,0.00,0.00,2.00,240.00,'2022-12-31 08:09:42','',''),(6619,'1','285','1',1,'Retail Sale Id 6629',6000.00,0.00,0.00,8.00,960.00,'2022-12-31 08:21:38','',''),(6620,'1','285','1',1,'Retail Sale Id 6630',997.50,0.00,0.00,1.33,159.60,'2022-12-31 08:25:10','',''),(6621,'1','285','1',1,'Retail Sale Id 6631',41218.40,0.00,0.00,61.52,2460.80,'2022-12-31 08:26:58','',''),(6622,'1','285','1',1,'Retail Sale Id 6632',49580.00,0.00,0.00,74.00,2960.00,'2022-12-31 08:29:51','',''),(6623,'1','285','1',1,'Retail Sale Id 6633',20100.00,0.00,0.00,30.00,1200.00,'2022-12-31 08:32:24','',''),(6624,'1','285','1',1,'Retail Sale Id 6634',2497.50,0.00,0.00,3.33,399.60,'2022-12-31 08:34:40','',''),(6625,'1','285','1',1,'Retail Sale Id 6635',3000.00,0.00,0.00,4.00,480.00,'2022-12-31 08:36:34','',''),(6626,'1','285','1',1,'Retail Sale Id 6636',3000.00,0.00,0.00,4.00,480.00,'2022-12-31 08:40:27','',''),(6627,'1','285','1',1,'Retail Sale Id 6637',3997.50,0.00,0.00,5.33,639.60,'2022-12-31 08:41:33','',''),(6628,'1','285','1',1,'Retail Sale Id 6638',1500.00,0.00,0.00,2.00,240.00,'2022-12-31 08:48:03','',''),(6629,'1','285','1',1,'Retail Sale Id 6639',2302.50,0.00,0.00,3.07,368.40,'2022-12-31 08:49:36','',''),(6630,'1','285','1',1,'Retail Sale Id 6640',1500.00,0.00,0.00,2.00,240.00,'2022-12-31 08:50:21','',''),(6631,'1','285','1',1,'Retail Sale Id 6641',4500.00,0.00,0.00,6.00,720.00,'2022-12-31 08:51:13','',''),(6632,'1','285','1',1,'Retail Sale Id 6642',28140.00,0.00,0.00,42.00,1680.00,'2022-12-31 08:54:29','',''),(6633,'1','285','1',1,'Retail Sale Id 6643',1500.00,0.00,0.00,2.00,240.00,'2022-12-31 08:59:35','',''),(6634,'1','285','1',1,'Retail Sale Id 6644',1500.00,0.00,0.00,2.00,240.00,'2022-12-31 09:02:11','',''),(6635,'1','285','1',1,'Retail Sale Id 6645',10572.60,0.00,0.00,15.78,631.20,'2022-12-31 09:04:06','',''),(6636,'1','285','1',1,'Retail Sale Id 6646',4500.00,0.00,0.00,6.00,720.00,'2022-12-31 09:08:00','',''),(6637,'1','285','1',1,'Retail Sale Id 6647',7500.00,0.00,0.00,10.00,1200.00,'2022-12-31 09:08:50','',''),(6638,'1','285','1',1,'Retail Sale Id 6648',5002.50,0.00,0.00,6.67,800.40,'2022-12-31 09:12:22','',''),(6639,'1','285','1',1,'Retail Sale Id 6648',9502.50,0.00,0.00,12.67,1520.40,'2022-12-31 09:12:22','',''),(6640,'1','285','1',1,'Retail Sale Id 6649',1500.00,0.00,0.00,2.00,240.00,'2022-12-31 09:14:30','',''),(6641,'1','285','1',1,'Retail Sale Id 6651',1500.00,0.00,0.00,2.00,240.00,'2022-12-31 09:16:50','',''),(6642,'1','285','1',1,'Retail Sale Id 6652',997.50,0.00,0.00,1.33,159.60,'2022-12-31 09:17:43','',''),(6643,'1','285','1',1,'Retail Sale Id 6653',997.50,0.00,0.00,1.33,159.60,'2022-12-31 09:18:35','',''),(6644,'1','285','1',1,'Retail Sale Id 6654',3000.00,0.00,0.00,4.00,480.00,'2022-12-31 09:21:36','',''),(6645,'1','285','1',1,'Retail Sale Id 6655',45613.60,0.00,0.00,68.08,2723.20,'2022-12-31 09:25:24','',''),(6646,'1','285','1',1,'Retail Sale Id 6656',40200.00,0.00,0.00,60.00,2400.00,'2022-12-31 09:28:50','',''),(6647,'1','285','1',1,'Retail Sale Id 6657',41714.20,0.00,0.00,62.26,2490.40,'2022-12-31 09:30:17','',''),(6648,'1','285','1',1,'Retail Sale Id 6658',1500.00,0.00,0.00,2.00,240.00,'2022-12-31 09:33:07','',''),(6649,'1','285','1',1,'Retail Sale Id 6659',5250.00,0.00,0.00,7.00,840.00,'2022-12-31 09:33:58','',''),(6650,'1','285','1',1,'Retail Sale Id 6660',3000.00,0.00,0.00,4.00,480.00,'2022-12-31 09:35:14','',''),(6651,'1','285','1',1,'Retail Sale Id 6661',40816.40,0.00,0.00,60.92,2436.80,'2022-12-31 09:37:35','',''),(6652,'1','285','1',1,'Return of Retail Sale Id 6659',0.00,5250.00,7.00,0.00,-840.00,'2022-12-31 09:41:14','',''),(6653,'1','285','1',1,'Retail Sale Id 6662',4725.00,0.00,0.00,6.30,756.00,'2022-12-31 09:43:03','',''),(6654,'1','285','1',1,'Retail Sale Id 6663',2002.50,0.00,0.00,2.67,320.40,'2022-12-31 09:49:10','',''),(6655,'1','285','1',1,'Retail Sale Id 6664',7500.00,0.00,0.00,10.00,1200.00,'2022-12-31 09:50:21','',''),(6656,'1','285','1',1,'Retail Sale Id 6666',46404.20,0.00,0.00,69.26,2770.40,'2022-12-31 09:53:22','',''),(6657,'1','285','1',1,'Retail Sale Id 6667',1500.00,0.00,0.00,2.00,240.00,'2022-12-31 09:58:16','',''),(6658,'1','285','1',1,'Retail Sale Id 6669',1500.00,0.00,0.00,2.00,240.00,'2022-12-31 10:02:43','',''),(6659,'1','285','1',1,'Retail Sale Id 6670',750.00,0.00,0.00,1.00,120.00,'2022-12-31 10:03:34','',''),(6660,'1','285','1',1,'Retail Sale Id 6671',1500.00,0.00,0.00,2.00,240.00,'2022-12-31 10:05:17','',''),(6661,'1','285','1',1,'Retail Sale Id 6672',698216.75,0.00,0.00,1049.95,36748.25,'2022-12-31 10:07:50','',''),(6662,'1','285','1',1,'Retail Sale Id 6673',4500.00,0.00,0.00,6.00,720.00,'2022-12-31 10:08:32','',''),(6663,'1','285','1',1,'Retail Sale Id 6674',2250.00,0.00,0.00,3.00,360.00,'2022-12-31 10:09:30','',''),(6664,'1','285','1',1,'Retail Sale Id 6675',3000.00,0.00,0.00,4.00,480.00,'2022-12-31 10:10:27','',''),(6665,'1','285','1',1,'Retail Sale Id 6676',16140.30,0.00,0.00,24.09,963.60,'2022-12-31 10:16:49','',''),(6666,'1','285','1',1,'Retail Sale Id 6677',166329.80,0.00,0.00,250.12,8754.20,'2022-12-31 10:21:47','',''),(6667,'1','285','1',1,'Retail Sale Id 6678',41178.20,0.00,0.00,61.46,2458.40,'2022-12-31 10:23:42','',''),(6668,'1','285','1',1,'Retail Sale Id 6679',4500.00,0.00,0.00,6.00,720.00,'2022-12-31 10:26:11','',''),(6669,'1','285','1',1,'Retail Sale Id 6680',49392.40,0.00,0.00,73.72,2948.80,'2022-12-31 10:27:23','',''),(6670,'1','285','1',1,'Retail Sale Id 6681',13400.00,0.00,0.00,20.00,800.00,'2022-12-31 10:31:20','',''),(6671,'1','285','1',1,'Retail Sale Id 6682',6000.00,0.00,0.00,8.00,960.00,'2022-12-31 10:33:18','',''),(6672,'1','285','1',1,'Retail Sale Id 6683',40729.30,0.00,0.00,60.79,2431.60,'2022-12-31 10:37:46','',''),(6673,'1','285','1',1,'Retail Sale Id 6684',3000.00,0.00,0.00,4.00,480.00,'2022-12-31 10:41:29','',''),(6674,'1','285','1',1,'Retail Sale Id 6685',2250.00,0.00,0.00,3.00,360.00,'2022-12-31 10:46:40','',''),(6675,'1','285','1',1,'Retail Sale Id 6686',114433.20,0.00,0.00,172.08,6022.80,'2022-12-31 10:59:00','',''),(6676,'1','285','1',1,'Retail Sale Id 6687',163363.90,0.00,0.00,245.66,8598.10,'2022-12-31 11:03:07','',''),(6677,'1','285','1',1,'Retail Sale Id 6688',32651.50,0.00,0.00,49.10,1718.50,'2022-12-31 11:12:46','',''),(6678,'1','285','1',1,'Retail Sale Id 6689',36240.30,0.00,0.00,54.09,2163.60,'2022-12-31 11:26:08','',''),(6679,'1','285','1',1,'Retail Sale Id 6690',8080.20,0.00,0.00,12.06,482.40,'2022-12-31 11:29:05','',''),(6680,'1','285','1',1,'Return of Retail Sale Id 6670',0.00,750.00,1.00,0.00,-120.00,'2022-12-31 13:39:44','',''),(6681,'1','285','1',1,'Retail Sale Id 6691',472.50,0.00,0.00,0.63,75.60,'2022-12-31 13:42:07','',''),(6682,'1','285','1',1,'Distributed to AA RANO NIGERIA LTD for sales id:8',246827.70,0.00,0.00,391.79,0.00,'2022-12-31 13:47:06','',''),(6683,'1','285',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,12789000.00,20300.00,0.00,0.00,'2022-12-31 13:50:48','',''),(6684,'1','285',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,20300.00,0.00,'2022-12-31 13:52:56','',''),(6685,'1','285','1',1,'Received from bridging 10',0.00,0.00,20300.00,0.00,0.00,'2022-12-31 13:52:56','',''),(6686,'1','285','1',1,'Retail Sale Id 6692',40434.50,0.00,0.00,60.35,2414.00,'2022-12-31 14:00:33','',''),(6687,'1','285','1',1,'Retail Sale Id 6693',32910.40,0.00,0.00,49.12,1964.80,'2022-12-31 14:02:39','',''),(6688,'1','285','1',1,'Retail Sale Id 6694',1500.00,0.00,0.00,2.00,240.00,'2022-12-31 14:04:23','',''),(6689,'1','285','1',1,'Retail Sale Id 6695',3750.00,0.00,0.00,5.00,600.00,'2022-12-31 14:05:38','',''),(6690,'1','285','1',1,'Retail Sale Id 6696',750.00,0.00,0.00,1.00,120.00,'2022-12-31 14:06:48','',''),(6691,'1','285','1',1,'Retail Sale Id 6697',19610.90,0.00,0.00,29.27,1170.80,'2022-12-31 14:07:58','',''),(6692,'1','285','1',1,'Retail Sale Id 6698',4500.00,0.00,0.00,6.00,720.00,'2022-12-31 14:10:08','',''),(6693,'1','285','1',1,'Retail Sale Id 6699',997.50,0.00,0.00,1.33,159.60,'2022-12-31 14:11:00','',''),(6694,'1','285','1',1,'Retail Sale Id 6700',4500.00,0.00,0.00,6.00,720.00,'2022-12-31 14:11:44','',''),(6695,'1','285','1',1,'Retail Sale Id 6701',2250.00,0.00,0.00,3.00,360.00,'2022-12-31 14:12:54','',''),(6696,'1','285','1',1,'Retail Sale Id 6702',3000.00,0.00,0.00,4.00,480.00,'2022-12-31 14:13:51','',''),(6697,'1','285','1',1,'Retail Sale Id 6703',3000.00,0.00,0.00,4.00,480.00,'2022-12-31 14:16:38','',''),(6698,'1','285','1',1,'Retail Sale Id 6704',3750.00,0.00,0.00,5.00,600.00,'2022-12-31 14:17:35','',''),(6699,'1','285','1',1,'Retail Sale Id 6705',3750.00,0.00,0.00,5.00,600.00,'2022-12-31 14:20:25','',''),(6700,'1','285','1',1,'Retail Sale Id 6706',41540.00,0.00,0.00,62.00,2480.00,'2022-12-31 14:21:59','',''),(6701,'1','285','1',1,'Retail Sale Id 6707',81224.10,0.00,0.00,121.23,4849.20,'2022-12-31 14:25:25','',''),(6702,'1','285','1',1,'Retail Sale Id 6708',40488.10,0.00,0.00,60.43,2417.20,'2022-12-31 14:28:16','',''),(6703,'1','285','1',1,'Retail Sale Id 6709',1500.00,0.00,0.00,2.00,240.00,'2022-12-31 14:30:07','',''),(6704,'1','285','1',1,'Retail Sale Id 6710',3000.00,0.00,0.00,4.00,480.00,'2022-12-31 14:31:08','',''),(6705,'1','285','1',1,'Retail Sale Id 6711',82356.40,0.00,0.00,122.92,4916.80,'2022-12-31 14:33:50','',''),(6706,'1','285','1',1,'Retail Sale Id 6712',5250.00,0.00,0.00,7.00,840.00,'2022-12-31 14:53:45','',''),(6707,'1','285','1',1,'Retail Sale Id 6713',7500.00,0.00,0.00,10.00,1200.00,'2022-12-31 14:54:39','',''),(6708,'1','285','1',1,'Retail Sale Id 6714',4500.00,0.00,0.00,6.00,720.00,'2022-12-31 14:56:51','',''),(6709,'1','285','1',1,'Retail Sale Id 6715',2497.50,0.00,0.00,3.33,399.60,'2022-12-31 14:57:48','',''),(6710,'1','285','1',1,'Retail Sale Id 6716',13232.50,0.00,0.00,19.75,790.00,'2022-12-31 15:01:57','',''),(6711,'1','285','1',1,'Retail Sale Id 6717',997.50,0.00,0.00,1.33,159.60,'2022-12-31 15:04:00','',''),(6712,'1','285','1',1,'Retail Sale Id 6718',31938.90,0.00,0.00,47.67,1906.80,'2022-12-31 15:07:59','',''),(6713,'1','285','1',1,'Retail Sale Id 6719',3495.00,0.00,0.00,4.66,559.20,'2022-12-31 15:27:35','',''),(6714,'1','285','1',1,'Retail Sale Id 6720',7500.00,0.00,0.00,10.00,1200.00,'2022-12-31 15:28:22','',''),(6715,'1','285','1',1,'Retail Sale Id 6721',1500.00,0.00,0.00,2.00,240.00,'2022-12-31 15:28:56','',''),(6716,'1','285','1',1,'Retail Sale Id 6722',2250.00,0.00,0.00,3.00,360.00,'2022-12-31 15:29:31','',''),(6717,'1','285','1',1,'Retail Sale Id 6723',6000.00,0.00,0.00,8.00,960.00,'2022-12-31 15:30:23','',''),(6718,'1','285','1',1,'Retail Sale Id 6724',2910.00,0.00,0.00,3.88,465.60,'2022-12-31 15:31:01','',''),(6719,'1','285','1',1,'Retail Sale Id 6725',7500.00,0.00,0.00,10.00,1200.00,'2022-12-31 15:31:51','',''),(6720,'1','285','1',1,'Retail Sale Id 6726',750.00,0.00,0.00,1.00,120.00,'2022-12-31 15:32:30','',''),(6721,'1','285','1',1,'Retail Sale Id 6727',3795.00,0.00,0.00,5.06,607.20,'2022-12-31 15:33:11','',''),(6722,'1','285','1',1,'Retail Sale Id 6728',750.00,0.00,0.00,1.00,120.00,'2022-12-31 15:34:26','',''),(6723,'1','285','1',1,'Retail Sale Id 6729',5250.00,0.00,0.00,7.00,840.00,'2022-12-31 15:35:40','',''),(6724,'1','285','1',1,'Retail Sale Id 6730',5400.00,0.00,0.00,7.20,864.00,'2022-12-31 15:38:19','',''),(6725,'1','285','1',1,'Retail Sale Id 6731',11624.50,0.00,0.00,17.35,694.00,'2022-12-31 15:40:06','',''),(6726,'1','285','1',1,'Retail Sale Id 6732',2002.50,0.00,0.00,2.67,320.40,'2022-12-31 15:41:23','',''),(6727,'1','285','1',1,'Retail Sale Id 6733',3000.00,0.00,0.00,4.00,480.00,'2022-12-31 15:42:36','',''),(6728,'1','285','1',1,'Retail Sale Id 6734',14867.30,0.00,0.00,22.19,887.60,'2022-12-31 15:44:02','',''),(6729,'1','285','1',1,'Retail Sale Id 6735',1500.00,0.00,0.00,2.00,240.00,'2022-12-31 15:46:42','',''),(6730,'1','285','1',1,'Retail Sale Id 6736',40454.60,0.00,0.00,60.38,2415.20,'2022-12-31 15:47:43','',''),(6731,'1','285','1',1,'Retail Sale Id 6737',997.50,0.00,0.00,1.33,159.60,'2022-12-31 15:48:48','',''),(6732,'1','285','1',1,'Retail Sale Id 6738',41540.00,0.00,0.00,62.00,2480.00,'2022-12-31 15:52:57','',''),(6733,'1','285','1',1,'Retail Sale Id 6739',46256.80,0.00,0.00,69.04,2761.60,'2022-12-31 15:56:17','',''),(6734,'1','285','1',1,'Retail Sale Id 6740',20100.00,0.00,0.00,30.00,1200.00,'2022-12-31 16:00:44','',''),(6735,'1','285','1',1,'Retail Sale Id 6741',750.00,0.00,0.00,1.00,120.00,'2022-12-31 16:01:46','',''),(6736,'1','285','1',1,'Retail Sale Id 6742',40588.60,0.00,0.00,60.58,2423.20,'2022-12-31 16:02:57','',''),(6737,'1','285','1',1,'Retail Sale Id 6743',1500.00,0.00,0.00,2.00,240.00,'2022-12-31 16:05:44','',''),(6738,'1','285','1',1,'Retail Sale Id 6744',2497.50,0.00,0.00,3.33,399.60,'2022-12-31 16:07:05','',''),(6739,'1','285','1',1,'Retail Sale Id 6745',3000.00,0.00,0.00,4.00,480.00,'2022-12-31 16:08:52','',''),(6740,'1','285','1',1,'Retail Sale Id 6746',4500.00,0.00,0.00,6.00,720.00,'2022-12-31 16:09:40','',''),(6741,'1','285','1',1,'Retail Sale Id 6747',375884.60,0.00,0.00,565.24,19783.40,'2022-12-31 16:10:59','',''),(6742,'1','285','1',1,'Retail Sale Id 6748',9750.00,0.00,0.00,13.00,1560.00,'2022-12-31 16:12:54','',''),(6743,'1','285','1',1,'Retail Sale Id 6749',9000.00,0.00,0.00,12.00,1440.00,'2022-12-31 16:14:47','',''),(6744,'1','285','1',1,'Retail Sale Id 6750',2002.50,0.00,0.00,2.67,320.40,'2022-12-31 16:15:43','',''),(6745,'1','285','1',1,'Retail Sale Id 6751',997.50,0.00,0.00,1.33,159.60,'2022-12-31 16:16:31','',''),(6746,'1','285','1',1,'Retail Sale Id 6752',1500.00,0.00,0.00,2.00,240.00,'2022-12-31 16:17:13','',''),(6747,'1','285','1',1,'Retail Sale Id 6753',40200.00,0.00,0.00,60.00,2400.00,'2022-12-31 16:18:30','',''),(6748,'1','285','1',1,'Retail Sale Id 6754',997.50,0.00,0.00,1.33,159.60,'2022-12-31 16:20:50','',''),(6749,'1','285','1',1,'Retail Sale Id 6755',1500.00,0.00,0.00,2.00,240.00,'2022-12-31 16:21:34','',''),(6750,'1','285','1',1,'Retail Sale Id 6756',1500.00,0.00,0.00,2.00,240.00,'2022-12-31 16:22:18','',''),(6751,'1','285','1',1,'Retail Sale Id 6757',2250.00,0.00,0.00,3.00,360.00,'2022-12-31 16:23:34','',''),(6752,'1','285','1',1,'Retail Sale Id 6758',3000.00,0.00,0.00,4.00,480.00,'2022-12-31 16:24:28','',''),(6753,'1','285','1',1,'Retail Sale Id 6759',3000.00,0.00,0.00,4.00,480.00,'2022-12-31 16:25:03','',''),(6754,'1','285','1',1,'Retail Sale Id 6760',3000.00,0.00,0.00,4.00,480.00,'2022-12-31 16:26:08','',''),(6755,'1','285','1',1,'Retail Sale Id 6761',802.50,0.00,0.00,1.07,128.40,'2022-12-31 16:27:37','',''),(6756,'1','285','1',1,'Retail Sale Id 6762',728028.70,0.00,0.00,1094.78,38317.30,'2022-12-31 16:28:45','',''),(6757,'1','285','1',1,'Retail Sale Id 6763',750.00,0.00,0.00,1.00,120.00,'2022-12-31 16:29:59','',''),(6758,'1','285','1',1,'Retail Sale Id 6764',202060.25,0.00,0.00,303.85,10634.75,'2022-12-31 16:41:20','',''),(6759,'1','285','1',1,'Retail Sale Id 6765',44601.55,0.00,0.00,67.07,2347.45,'2022-12-31 16:43:20','',''),(6760,'1','285','1',1,'Retail Sale Id 6766',62202.80,0.00,0.00,92.84,3713.60,'2022-12-31 16:47:44','',''),(6761,'1','285','1',1,'Retail Sale Id 6767',3000.00,0.00,0.00,4.00,480.00,'2022-12-31 16:49:36','',''),(6762,'1','285','1',1,'Retail Sale Id 6768',3000.00,0.00,0.00,4.00,480.00,'2022-12-31 16:50:21','',''),(6763,'1','285','1',1,'Retail Sale Id 6769',997.50,0.00,0.00,1.33,159.60,'2022-12-31 16:51:15','',''),(6764,'1','285','1',1,'Retail Sale Id 6770',2250.00,0.00,0.00,3.00,360.00,'2022-12-31 16:52:11','',''),(6765,'1','285','1',1,'Retail Sale Id 6771',1500.00,0.00,0.00,2.00,240.00,'2022-12-31 16:52:58','',''),(6766,'1','285','1',1,'Retail Sale Id 6772',3750.00,0.00,0.00,5.00,600.00,'2022-12-31 16:54:44','',''),(6767,'1','285','1',1,'Retail Sale Id 6773',750.00,0.00,0.00,1.00,120.00,'2022-12-31 16:55:36','',''),(6768,'1','285','1',1,'Retail Sale Id 6774',3000.00,0.00,0.00,4.00,480.00,'2022-12-31 17:02:32','',''),(6769,'1','285','1',1,'Retail Sale Id 6775',997.50,0.00,0.00,1.33,159.60,'2022-12-31 17:03:31','',''),(6770,'1','285','1',1,'Retail Sale Id 6776',199500.00,0.00,0.00,300.00,10500.00,'2022-12-31 17:12:10','',''),(6771,'1','285','1',1,'Return of Retail Sale Id 6773',0.00,750.00,1.00,0.00,-120.00,'2022-12-31 18:09:21','',''),(6772,'1','285','1',1,'Return of Retail Sale Id 6753',0.00,40200.00,60.00,0.00,-2400.00,'2022-12-31 19:12:07','',''),(6773,'1','285','1',1,'Retail Sale Id 6777',38893.50,0.00,0.00,58.05,2322.00,'2022-12-31 19:13:59','',''),(6774,'1','285','1',1,'Retail Sale Id 6778',157.50,0.00,0.00,0.21,25.20,'2022-12-31 19:15:20','',''),(6775,'1','285','1',1,'Retail Sale Id 6779',3750.00,0.00,0.00,5.00,600.00,'2023-01-01 07:37:17','',''),(6776,'1','285','1',1,'Retail Sale Id 6780',50008.80,0.00,0.00,74.64,2985.60,'2023-01-01 07:38:58','',''),(6777,'1','285','1',1,'Retail Sale Id 6781',2250.00,0.00,0.00,3.00,360.00,'2023-01-01 07:41:12','',''),(6778,'1','285','1',1,'Retail Sale Id 6782',1500.00,0.00,0.00,2.00,240.00,'2023-01-01 07:42:11','',''),(6779,'1','285','1',1,'Retail Sale Id 6784',16790.20,0.00,0.00,25.06,1002.40,'2023-01-01 08:16:14','',''),(6780,'1','285','1',1,'Retail Sale Id 6785',22432.50,0.00,0.00,29.91,3589.20,'2023-01-01 08:17:59','',''),(6781,'1','285','1',1,'Retail Sale Id 6786',750.00,0.00,0.00,1.00,120.00,'2023-01-01 08:20:18','',''),(6782,'1','285','1',1,'Retail Sale Id 6787',997.50,0.00,0.00,1.33,159.60,'2023-01-01 08:21:22','',''),(6783,'1','285','1',1,'Retail Sale Id 6788',3000.00,0.00,0.00,4.00,480.00,'2023-01-01 08:22:17','',''),(6784,'1','285','1',1,'Retail Sale Id 6789',28140.00,0.00,0.00,42.00,1680.00,'2023-01-01 08:24:42','',''),(6785,'1','285','1',1,'Retail Sale Id 6790',85076.60,0.00,0.00,126.98,5079.20,'2023-01-01 08:30:47','',''),(6786,'1','285','1',1,'Retail Sale Id 6791',40200.00,0.00,0.00,60.00,2400.00,'2023-01-01 08:32:37','',''),(6787,'1','285','1',1,'Retail Sale Id 6792',9750.00,0.00,0.00,13.00,1560.00,'2023-01-01 08:35:53','',''),(6788,'1','285','1',1,'Retail Sale Id 6793',13507.20,0.00,0.00,20.16,806.40,'2023-01-01 08:38:28','',''),(6789,'1','285','1',1,'Retail Sale Id 6794',750.00,0.00,0.00,1.00,120.00,'2023-01-01 08:44:23','',''),(6790,'1','285','1',1,'Retail Sale Id 6795',3000.00,0.00,0.00,4.00,480.00,'2023-01-01 08:46:34','',''),(6791,'1','285','1',1,'Retail Sale Id 6796',7500.00,0.00,0.00,10.00,1200.00,'2023-01-01 08:47:54','',''),(6792,'1','285','1',1,'Retail Sale Id 6797',13747.50,0.00,0.00,18.33,2199.60,'2023-01-01 08:50:06','',''),(6793,'1','285','1',1,'Retail Sale Id 6798',40776.20,0.00,0.00,60.86,2434.40,'2023-01-01 08:54:00','',''),(6794,'1','285','1',1,'Retail Sale Id 6799',3000.00,0.00,0.00,4.00,480.00,'2023-01-01 08:55:38','',''),(6795,'1','285','1',1,'Retail Sale Id 6801',1500.00,0.00,0.00,2.00,240.00,'2023-01-01 08:58:27','',''),(6796,'1','285','1',1,'Retail Sale Id 6802',2250.00,0.00,0.00,3.00,360.00,'2023-01-01 08:59:08','',''),(6797,'1','285','1',1,'Retail Sale Id 6803',997.50,0.00,0.00,1.33,159.60,'2023-01-01 09:01:40','',''),(6798,'1','285','1',1,'Retail Sale Id 6804',16669.60,0.00,0.00,24.88,995.20,'2023-01-01 09:03:23','',''),(6799,'1','285','1',1,'Retail Sale Id 6805',40642.20,0.00,0.00,60.66,2426.40,'2023-01-01 09:05:31','',''),(6800,'1','285','1',1,'Retail Sale Id 6806',750.00,0.00,0.00,1.00,120.00,'2023-01-01 09:07:28','',''),(6801,'1','285','1',1,'Retail Sale Id 6807',2250.00,0.00,0.00,3.00,360.00,'2023-01-01 09:08:51','',''),(6802,'1','285','1',1,'Retail Sale Id 6808',12649.60,0.00,0.00,18.88,755.20,'2023-01-01 09:10:47','',''),(6803,'1','285','1',1,'Retail Sale Id 6809',41560.10,0.00,0.00,62.03,2481.20,'2023-01-01 09:15:36','',''),(6804,'1','285','1',1,'Retail Sale Id 6810',13205.70,0.00,0.00,19.71,788.40,'2023-01-01 09:18:30','',''),(6805,'1','285','1',1,'Retail Sale Id 6811',997.50,0.00,0.00,1.33,159.60,'2023-01-01 09:21:14','',''),(6806,'1','285','1',1,'Retail Sale Id 6812',2002.50,0.00,0.00,2.67,320.40,'2023-01-01 09:22:26','',''),(6807,'1','285','1',1,'Retail Sale Id 6813',16542.30,0.00,0.00,24.69,987.60,'2023-01-01 09:23:43','',''),(6808,'1','285','1',1,'Retail Sale Id 6814',997.50,0.00,0.00,1.33,159.60,'2023-01-01 09:26:12','',''),(6809,'1','285','1',1,'Retail Sale Id 6815',41392.60,0.00,0.00,61.78,2471.20,'2023-01-01 09:27:22','',''),(6810,'1','285','1',1,'Retail Sale Id 6816',9969.60,0.00,0.00,14.88,595.20,'2023-01-01 09:29:04','',''),(6811,'1','285','1',1,'Retail Sale Id 6817',997.50,0.00,0.00,1.33,159.60,'2023-01-01 09:31:16','',''),(6812,'1','285','1',1,'Retail Sale Id 6818',41385.90,0.00,0.00,61.77,2470.80,'2023-01-01 09:42:22','',''),(6813,'1','285','1',1,'Retail Sale Id 6819',44534.90,0.00,0.00,66.47,2658.80,'2023-01-01 09:43:31','',''),(6814,'1','285','1',1,'Retail Sale Id 6820',42906.80,0.00,0.00,64.04,2561.60,'2023-01-01 09:46:33','',''),(6815,'1','285','1',1,'Retail Sale Id 6821',2250.00,0.00,0.00,3.00,360.00,'2023-01-01 09:51:29','',''),(6816,'1','285','1',1,'Retail Sale Id 6822',1500.00,0.00,0.00,2.00,240.00,'2023-01-01 09:53:19','',''),(6817,'1','285','1',1,'Retail Sale Id 6823',1500.00,0.00,0.00,2.00,240.00,'2023-01-01 10:06:51','',''),(6818,'1','285','1',1,'Retail Sale Id 6824',4500.00,0.00,0.00,6.00,720.00,'2023-01-01 10:08:37','',''),(6819,'1','285','1',1,'Retail Sale Id 6825',997.50,0.00,0.00,1.33,159.60,'2023-01-01 10:09:32','',''),(6820,'1','285','1',1,'Retail Sale Id 6826',3750.00,0.00,0.00,5.00,600.00,'2023-01-01 10:11:04','',''),(6821,'1','285','1',1,'Retail Sale Id 6827',1500.00,0.00,0.00,2.00,240.00,'2023-01-01 10:12:05','',''),(6822,'1','285','1',1,'Retail Sale Id 6828',1500.00,0.00,0.00,2.00,240.00,'2023-01-01 10:13:46','',''),(6823,'1','285','1',1,'Retail Sale Id 6829',750.00,0.00,0.00,1.00,120.00,'2023-01-01 10:16:33','',''),(6824,'1','285','1',1,'Retail Sale Id 6830',2002.50,0.00,0.00,2.67,320.40,'2023-01-01 10:19:41','',''),(6825,'1','285','1',1,'Retail Sale Id 6831',2497.50,0.00,0.00,3.33,399.60,'2023-01-01 10:21:27','',''),(6826,'1','285','1',1,'Retail Sale Id 6832',1200.00,0.00,0.00,1.60,192.00,'2023-01-01 10:30:12','',''),(6827,'1','285','1',1,'Retail Sale Id 6833',1500.00,0.00,0.00,2.00,240.00,'2023-01-01 10:34:31','',''),(6828,'1','285','1',1,'Retail Sale Id 6834',3397.50,0.00,0.00,4.53,543.60,'2023-01-01 10:39:13','',''),(6829,'1','285','1',1,'Retail Sale Id 6835',11664.70,0.00,0.00,17.41,696.40,'2023-01-01 10:49:30','',''),(6830,'1','285','1',1,'Retail Sale Id 6836',40200.00,0.00,0.00,60.00,2400.00,'2023-01-01 10:54:09','',''),(6831,'1','285','1',1,'Retail Sale Id 6837',1500.00,0.00,0.00,2.00,240.00,'2023-01-01 10:57:23','',''),(6832,'1','285','1',1,'Retail Sale Id 6838',1500.00,0.00,0.00,2.00,240.00,'2023-01-01 10:58:43','',''),(6833,'1','285','1',1,'Retail Sale Id 6839',750.00,0.00,0.00,1.00,120.00,'2023-01-01 10:59:29','',''),(6834,'1','285','1',1,'Retail Sale Id 6840',3000.00,0.00,0.00,4.00,480.00,'2023-01-01 11:03:51','',''),(6835,'1','285','1',1,'Retail Sale Id 6841',1500.00,0.00,0.00,2.00,240.00,'2023-01-01 11:10:32','',''),(6836,'1','285','1',1,'Retail Sale Id 6842',997.50,0.00,0.00,1.33,159.60,'2023-01-01 11:24:13','',''),(6837,'1','285','1',1,'Retail Sale Id 6843',6000.00,0.00,0.00,8.00,960.00,'2023-01-01 11:28:07','',''),(6838,'1','285','1',1,'Retail Sale Id 6844',5250.00,0.00,0.00,7.00,840.00,'2023-01-01 11:33:39','',''),(6839,'1','285','1',1,'Retail Sale Id 6845',3000.00,0.00,0.00,4.00,480.00,'2023-01-01 11:34:21','',''),(6840,'1','285','1',1,'Retail Sale Id 6846',750.00,0.00,0.00,1.00,120.00,'2023-01-01 11:35:51','',''),(6841,'1','285','1',1,'Retail Sale Id 6847',1500.00,0.00,0.00,2.00,240.00,'2023-01-01 11:36:39','',''),(6842,'1','285','1',1,'Retail Sale Id 6848',1500.00,0.00,0.00,2.00,240.00,'2023-01-01 12:03:51','',''),(6843,'1','285','1',1,'Retail Sale Id 6849',1500.00,0.00,0.00,2.00,240.00,'2023-01-01 12:05:25','',''),(6844,'1','285','1',1,'Retail Sale Id 6850',5250.00,0.00,0.00,7.00,840.00,'2023-01-01 12:37:04','',''),(6845,'1','285','1',1,'Retail Sale Id 6851',2002.50,0.00,0.00,2.67,320.40,'2023-01-01 12:53:34','',''),(6846,'1','285','1',1,'Retail Sale Id 6852',1500.00,0.00,0.00,2.00,240.00,'2023-01-01 12:54:41','',''),(6847,'1','285','1',1,'Retail Sale Id 6853',750.00,0.00,0.00,1.00,120.00,'2023-01-01 12:56:57','',''),(6848,'1','285','1',1,'Retail Sale Id 6854',4500.00,0.00,0.00,6.00,720.00,'2023-01-01 12:59:41','',''),(6849,'1','285','1',1,'Retail Sale Id 6855',750.00,0.00,0.00,1.00,120.00,'2023-01-01 13:14:53','',''),(6850,'1','285','1',1,'Retail Sale Id 6856',1500.00,0.00,0.00,2.00,240.00,'2023-01-01 13:16:29','',''),(6851,'1','285','1',1,'Retail Sale Id 6857',2100.00,0.00,0.00,2.80,336.00,'2023-01-01 13:26:03','',''),(6852,'1','285','1',1,'Retail Sale Id 6858',750.00,0.00,0.00,1.00,120.00,'2023-01-01 13:28:32','',''),(6853,'1','285','1',1,'Retail Sale Id 6859',17232.40,0.00,0.00,25.72,1028.80,'2023-01-01 13:31:38','',''),(6854,'1','285','1',1,'Retail Sale Id 6860',2002.50,0.00,0.00,2.67,320.40,'2023-01-01 13:35:06','',''),(6855,'1','285','1',1,'Retail Sale Id 6861',1500.00,0.00,0.00,2.00,240.00,'2023-01-01 13:40:32','',''),(6856,'1','285','1',1,'Retail Sale Id 6862',2197.50,0.00,0.00,2.93,351.60,'2023-01-01 13:44:59','',''),(6857,'1','285','1',1,'Retail Sale Id 6863',3000.00,0.00,0.00,4.00,480.00,'2023-01-01 13:45:55','',''),(6858,'1','285','1',1,'Retail Sale Id 6865',1500.00,0.00,0.00,2.00,240.00,'2023-01-01 13:47:14','',''),(6859,'1','285','1',1,'Retail Sale Id 6866',2782.50,0.00,0.00,3.71,445.20,'2023-01-01 13:51:07','',''),(6860,'1','285','1',1,'Retail Sale Id 6867',108834.80,0.00,0.00,162.44,6497.60,'2023-01-01 14:00:40','',''),(6861,'1','285','1',1,'Retail Sale Id 6868',40870.00,0.00,0.00,61.00,2440.00,'2023-01-01 14:02:44','',''),(6862,'1','285','1',1,'Retail Sale Id 6869',750.00,0.00,0.00,1.00,120.00,'2023-01-01 14:03:46','',''),(6863,'1','285','1',1,'Retail Sale Id 6870',5250.00,0.00,0.00,7.00,840.00,'2023-01-01 14:06:32','',''),(6864,'1','285','1',1,'Retail Sale Id 6871',2250.00,0.00,0.00,3.00,360.00,'2023-01-01 14:10:50','',''),(6865,'1','285','1',1,'Retail Sale Id 6872',9375.00,0.00,0.00,12.50,1500.00,'2023-01-01 14:18:01','',''),(6866,'1','285','1',1,'Retail Sale Id 6873',1500.00,0.00,0.00,2.00,240.00,'2023-01-01 14:18:57','',''),(6867,'1','285','1',1,'Retail Sale Id 6874',750.00,0.00,0.00,1.00,120.00,'2023-01-01 14:24:37','',''),(6868,'1','285','1',1,'Retail Sale Id 6875',3750.00,0.00,0.00,5.00,600.00,'2023-01-01 14:34:05','',''),(6869,'1','285','1',1,'Retail Sale Id 6876',1500.00,0.00,0.00,2.00,240.00,'2023-01-01 14:36:11','',''),(6870,'1','285','1',1,'Retail Sale Id 6877',750.00,0.00,0.00,1.00,120.00,'2023-01-01 14:37:44','',''),(6871,'1','285','1',1,'Retail Sale Id 6878',750.00,0.00,0.00,1.00,120.00,'2023-01-01 14:38:53','',''),(6872,'1','285','1',1,'Retail Sale Id 6879',750.00,0.00,0.00,1.00,120.00,'2023-01-01 14:46:29','',''),(6873,'1','285','1',1,'Retail Sale Id 6880',40320.60,0.00,0.00,60.18,2407.20,'2023-01-01 14:51:44','',''),(6874,'1','285','1',1,'Retail Sale Id 6881',3000.00,0.00,0.00,4.00,480.00,'2023-01-01 14:53:10','',''),(6875,'1','285','1',1,'Retail Sale Id 6882',2302.50,0.00,0.00,3.07,368.40,'2023-01-01 14:54:40','',''),(6876,'1','285','1',1,'Retail Sale Id 6883',26800.00,0.00,0.00,40.00,1600.00,'2023-01-01 14:55:58','',''),(6877,'1','285','1',1,'Retail Sale Id 6884',12060.00,0.00,0.00,18.00,720.00,'2023-01-01 14:58:50','',''),(6878,'1','285','1',1,'Retail Sale Id 6885',3000.00,0.00,0.00,4.00,480.00,'2023-01-01 15:10:06','',''),(6879,'1','285','1',1,'Retail Sale Id 6886',1050.00,0.00,0.00,1.40,168.00,'2023-01-01 15:16:13','',''),(6880,'1','285','1',1,'Retail Sale Id 6887',802.50,0.00,0.00,1.07,128.40,'2023-01-01 15:29:11','',''),(6881,'1','285','1',1,'Retail Sale Id 6888',997.50,0.00,0.00,1.33,159.60,'2023-01-01 15:30:00','',''),(6882,'1','285','1',1,'Retail Sale Id 6889',997.50,0.00,0.00,1.33,159.60,'2023-01-01 15:35:59','',''),(6883,'1','285','1',1,'Retail Sale Id 6890',750.00,0.00,0.00,1.00,120.00,'2023-01-01 15:54:06','',''),(6884,'1','285','1',1,'Retail Sale Id 6891',3997.50,0.00,0.00,5.33,639.60,'2023-01-01 15:55:19','',''),(6885,'1','285','1',1,'Retail Sale Id 6892',997.50,0.00,0.00,1.33,159.60,'2023-01-01 16:00:25','',''),(6886,'1','285','1',1,'Retail Sale Id 6893',750.00,0.00,0.00,1.00,120.00,'2023-01-01 16:12:42','',''),(6887,'1','285','1',1,'Retail Sale Id 6894',997.50,0.00,0.00,1.33,159.60,'2023-01-01 16:14:29','',''),(6888,'1','285','1',1,'Retail Sale Id 6895',36434.60,0.00,0.00,54.38,2175.20,'2023-01-01 16:17:17','',''),(6889,'1','285','1',1,'Retail Sale Id 6896',2250.00,0.00,0.00,3.00,360.00,'2023-01-01 16:19:22','',''),(6890,'1','285','1',1,'Return of Retail Sale Id 6884',0.00,12060.00,18.00,0.00,-720.00,'2023-01-01 18:16:30','',''),(6891,'1','285','1',1,'Retail Sale Id 6897',11497.20,0.00,0.00,17.16,686.40,'2023-01-01 18:17:32','',''),(6892,'1','285','1',1,'Retail Sale Id 6898',38860.00,0.00,0.00,58.00,2320.00,'2023-01-02 06:37:59','',''),(6893,'1','285','1',1,'Retail Sale Id 6899',23450.00,0.00,0.00,35.00,1400.00,'2023-01-02 06:39:12','',''),(6894,'1','285','1',1,'Retail Sale Id 6900',28140.00,0.00,0.00,42.00,1680.00,'2023-01-02 06:40:37','',''),(6895,'1','285','1',1,'Retail Sale Id 6901',16227.40,0.00,0.00,24.22,968.80,'2023-01-02 06:41:47','',''),(6896,'1','285','1',1,'Retail Sale Id 6902',11250.00,0.00,0.00,15.00,1800.00,'2023-01-02 06:42:38','',''),(6897,'1','285','1',1,'Retail Sale Id 6903',6750.00,0.00,0.00,9.00,1080.00,'2023-01-02 07:20:12','',''),(6898,'1','285','1',1,'Retail Sale Id 6904',2250.00,0.00,0.00,3.00,360.00,'2023-01-02 07:22:02','',''),(6899,'1','285','1',1,'Retail Sale Id 6905',5299.70,0.00,0.00,7.91,316.40,'2023-01-02 07:28:24','',''),(6900,'1','285','1',1,'Retail Sale Id 6906',1500.00,0.00,0.00,2.00,240.00,'2023-01-02 07:36:20','',''),(6901,'1','285','1',1,'Retail Sale Id 6907',40200.00,0.00,0.00,60.00,2400.00,'2023-01-02 07:39:02','',''),(6902,'1','285','1',1,'Retail Sale Id 6908',750.00,0.00,0.00,1.00,120.00,'2023-01-02 07:39:56','',''),(6903,'1','285','1',1,'Retail Sale Id 6909',3000.00,0.00,0.00,4.00,480.00,'2023-01-02 07:45:18','',''),(6904,'1','285','1',1,'Retail Sale Id 6910',10096.90,0.00,0.00,15.07,602.80,'2023-01-02 07:46:20','',''),(6905,'1','285','1',1,'Retail Sale Id 6911',2497.50,0.00,0.00,3.33,399.60,'2023-01-02 07:48:20','',''),(6906,'1','285','1',1,'Retail Sale Id 6912',44340.60,0.00,0.00,66.18,2647.20,'2023-01-02 07:49:30','',''),(6907,'1','285','1',1,'Retail Sale Id 6913',3750.00,0.00,0.00,5.00,600.00,'2023-01-02 07:52:45','',''),(6908,'1','285','1',1,'Retail Sale Id 6914',3350.00,0.00,0.00,5.00,200.00,'2023-01-02 07:56:45','',''),(6909,'1','285','1',1,'Retail Sale Id 6915',40273.70,0.00,0.00,60.11,2404.40,'2023-01-02 07:57:50','',''),(6910,'1','285','1',1,'Retail Sale Id 6916',40608.70,0.00,0.00,60.61,2424.40,'2023-01-02 08:02:11','',''),(6911,'1','285','1',1,'Retail Sale Id 6917',1500.00,0.00,0.00,2.00,240.00,'2023-01-02 08:02:56','',''),(6912,'1','285','1',1,'Retail Sale Id 6918',25212.10,0.00,0.00,37.63,1505.20,'2023-01-02 08:05:27','',''),(6913,'1','285','1',1,'Retail Sale Id 6919',43550.00,0.00,0.00,65.00,2600.00,'2023-01-02 08:09:28','',''),(6914,'1','285','1',1,'Retail Sale Id 6920',47013.90,0.00,0.00,70.17,2806.80,'2023-01-02 08:17:16','',''),(6915,'1','285','1',1,'Retail Sale Id 6921',2700.00,0.00,0.00,3.60,432.00,'2023-01-02 08:21:54','',''),(6916,'1','285','1',1,'Retail Sale Id 6922',900.00,0.00,0.00,1.20,144.00,'2023-01-02 08:24:19','',''),(6917,'1','285','1',1,'Retail Sale Id 6923',3000.00,0.00,0.00,4.00,480.00,'2023-01-02 08:25:46','',''),(6918,'1','285','1',1,'Retail Sale Id 6924',3997.50,0.00,0.00,5.33,639.60,'2023-01-02 08:37:24','',''),(6919,'1','285','1',1,'Retail Sale Id 6925',3000.00,0.00,0.00,4.00,480.00,'2023-01-02 08:38:16','',''),(6920,'1','285','1',1,'Retail Sale Id 6926',2002.50,0.00,0.00,2.67,320.40,'2023-01-02 08:39:04','',''),(6921,'1','285','1',1,'Retail Sale Id 6927',4500.00,0.00,0.00,6.00,720.00,'2023-01-02 08:42:45','',''),(6922,'1','285','1',1,'Retail Sale Id 6928',2302.50,0.00,0.00,3.07,368.40,'2023-01-02 08:44:10','',''),(6923,'1','285','1',1,'Retail Sale Id 6929',41627.10,0.00,0.00,62.13,2485.20,'2023-01-02 08:46:18','',''),(6924,'1','285','1',1,'Retail Sale Id 6931',1500.00,0.00,0.00,2.00,240.00,'2023-01-02 08:48:30','',''),(6925,'1','285','1',1,'Retail Sale Id 6932',2250.00,0.00,0.00,3.00,360.00,'2023-01-02 08:49:28','',''),(6926,'1','285','1',1,'Retail Sale Id 6933',3000.00,0.00,0.00,4.00,480.00,'2023-01-02 08:55:40','',''),(6927,'1','285','1',1,'Retail Sale Id 6934',1500.00,0.00,0.00,2.00,240.00,'2023-01-02 09:00:12','',''),(6928,'1','285','1',1,'Retail Sale Id 6935',1500.00,0.00,0.00,2.00,240.00,'2023-01-02 09:01:29','',''),(6929,'1','285','1',1,'Retail Sale Id 6936',6000.00,0.00,0.00,8.00,960.00,'2023-01-02 09:04:13','',''),(6930,'1','285','1',1,'Retail Sale Id 6937',9375.00,0.00,0.00,12.50,1500.00,'2023-01-02 09:13:33','',''),(6931,'1','285','1',1,'Retail Sale Id 6938',33500.00,0.00,0.00,50.00,2000.00,'2023-01-02 09:17:16','',''),(6932,'1','285','1',1,'Retail Sale Id 6939',750.00,0.00,0.00,1.00,120.00,'2023-01-02 09:18:34','',''),(6933,'1','285','1',1,'Retail Sale Id 6940',1500.00,0.00,0.00,2.00,240.00,'2023-01-02 09:19:16','',''),(6934,'1','285','1',1,'Retail Sale Id 6941',2250.00,0.00,0.00,3.00,360.00,'2023-01-02 09:21:28','',''),(6935,'1','285','1',1,'Retail Sale Id 6942',33500.00,0.00,0.00,50.00,2000.00,'2023-01-02 09:22:25','',''),(6936,'1','285','1',1,'Retail Sale Id 6943',2002.50,0.00,0.00,2.67,320.40,'2023-01-02 09:23:43','',''),(6937,'1','285','1',1,'Retail Sale Id 6944',26800.00,0.00,0.00,40.00,1600.00,'2023-01-02 09:26:43','',''),(6938,'1','285','1',1,'Retail Sale Id 6945',7500.00,0.00,0.00,10.00,1200.00,'2023-01-02 09:28:48','',''),(6939,'1','285','1',1,'Retail Sale Id 6946',6000.00,0.00,0.00,8.00,960.00,'2023-01-02 09:29:34','',''),(6940,'1','285','1',1,'Retail Sale Id 6947',1500.00,0.00,0.00,2.00,240.00,'2023-01-02 09:33:19','',''),(6941,'1','285','1',1,'Retail Sale Id 6948',46900.00,0.00,0.00,70.00,2800.00,'2023-01-02 09:35:44','',''),(6942,'1','285','1',1,'Retail Sale Id 6949',2002.50,0.00,0.00,2.67,320.40,'2023-01-02 09:37:35','',''),(6943,'1','285','1',1,'Retail Sale Id 6950',4500.00,0.00,0.00,6.00,720.00,'2023-01-02 09:38:28','',''),(6944,'1','285','1',1,'Retail Sale Id 6951',10076.80,0.00,0.00,15.04,601.60,'2023-01-02 09:39:43','',''),(6945,'1','285','1',1,'Retail Sale Id 6952',3000.00,0.00,0.00,4.00,480.00,'2023-01-02 09:51:58','',''),(6946,'1','285','1',1,'Retail Sale Id 6953',41540.00,0.00,0.00,62.00,2480.00,'2023-01-02 09:55:41','',''),(6947,'1','285','1',1,'Retail Sale Id 6954',50920.00,0.00,0.00,76.00,3040.00,'2023-01-02 09:58:42','',''),(6948,'1','285','1',1,'Retail Sale Id 6955',1500.00,0.00,0.00,2.00,240.00,'2023-01-02 10:00:14','',''),(6949,'1','285','1',1,'Retail Sale Id 6956',41265.30,0.00,0.00,61.59,2463.60,'2023-01-02 10:01:18','',''),(6950,'1','285','1',1,'Retail Sale Id 6957',1500.00,0.00,0.00,2.00,240.00,'2023-01-02 10:09:10','',''),(6951,'1','285','1',1,'Retail Sale Id 6958',13400.00,0.00,0.00,20.00,800.00,'2023-01-02 10:15:21','',''),(6952,'1','285','1',1,'Retail Sale Id 6959',750.00,0.00,0.00,1.00,120.00,'2023-01-02 10:18:49','',''),(6953,'1','285','1',1,'Retail Sale Id 6960',65016.80,0.00,0.00,97.04,3881.60,'2023-01-02 10:21:01','',''),(6954,'1','285','1',1,'Retail Sale Id 6961',997.50,0.00,0.00,1.33,159.60,'2023-01-02 10:25:17','',''),(6955,'1','285','1',1,'Retail Sale Id 6962',88017.90,0.00,0.00,131.37,5254.80,'2023-01-02 10:26:58','',''),(6956,'1','285','1',1,'Retail Sale Id 6963',1500.00,0.00,0.00,2.00,240.00,'2023-01-02 10:38:55','',''),(6957,'1','285','1',1,'Retail Sale Id 6964',7500.00,0.00,0.00,10.00,1200.00,'2023-01-02 10:40:31','',''),(6958,'1','285','1',1,'Retail Sale Id 6965',40823.10,0.00,0.00,60.93,2437.20,'2023-01-02 10:51:00','',''),(6959,'1','285','1',1,'Retail Sale Id 6966',1500.00,0.00,0.00,2.00,240.00,'2023-01-02 10:51:38','',''),(6960,'1','285','1',1,'Retail Sale Id 6967',45560.00,0.00,0.00,68.00,2720.00,'2023-01-02 10:55:21','',''),(6961,'1','285','1',1,'Retail Sale Id 6968',6000.00,0.00,0.00,8.00,960.00,'2023-01-02 10:57:30','',''),(6962,'1','285','1',1,'Retail Sale Id 6969',40200.00,0.00,0.00,60.00,2400.00,'2023-01-02 10:59:17','',''),(6963,'1','285','1',1,'Retail Sale Id 6970',79736.70,0.00,0.00,119.01,4760.40,'2023-01-02 11:02:17','',''),(6964,'1','285','1',1,'Retail Sale Id 6971',2250.00,0.00,0.00,3.00,360.00,'2023-01-02 11:07:09','',''),(6965,'1','285','1',1,'Retail Sale Id 6972',60300.00,0.00,0.00,90.00,3600.00,'2023-01-02 11:11:20','',''),(6966,'1','285','1',1,'Retail Sale Id 6973',11771.90,0.00,0.00,17.57,702.80,'2023-01-02 11:16:23','',''),(6967,'1','285','1',1,'Return of Retail Sale Id 6967',0.00,45560.00,68.00,0.00,-2720.00,'2023-01-02 11:19:02','',''),(6968,'1','285','1',1,'Retail Sale Id 6974',45171.40,0.00,0.00,67.42,2696.80,'2023-01-02 11:19:51','',''),(6969,'1','285','1',1,'Retail Sale Id 6975',1500.00,0.00,0.00,2.00,240.00,'2023-01-02 11:22:30','',''),(6970,'1','285','1',1,'Retail Sale Id 6976',750.00,0.00,0.00,1.00,120.00,'2023-01-02 11:23:20','',''),(6971,'1','285','1',1,'Retail Sale Id 6977',33500.00,0.00,0.00,50.00,2000.00,'2023-01-02 11:24:39','',''),(6972,'1','285','1',1,'Retail Sale Id 6978',5250.00,0.00,0.00,7.00,840.00,'2023-01-02 11:27:01','',''),(6973,'1','285','1',1,'Retail Sale Id 6979',399000.00,0.00,0.00,600.00,21000.00,'2023-01-02 11:30:38','',''),(6974,'1','285','1',1,'Retail Sale Id 6980',750.00,0.00,0.00,1.00,120.00,'2023-01-02 11:42:56','',''),(6975,'1','285','1',1,'Retail Sale Id 6981',802.50,0.00,0.00,1.07,128.40,'2023-01-02 11:44:20','',''),(6976,'1','285','1',1,'Retail Sale Id 6982',40200.00,0.00,0.00,60.00,2400.00,'2023-01-02 11:52:55','',''),(6977,'1','285','1',1,'Retail Sale Id 6983',11430.20,0.00,0.00,17.06,682.40,'2023-01-02 11:54:57','',''),(6978,'1','285','1',1,'Retail Sale Id 6984',2010.00,0.00,0.00,3.00,120.00,'2023-01-02 11:56:12','',''),(6979,'1','285','1',1,'Retail Sale Id 6985',3750.00,0.00,0.00,5.00,600.00,'2023-01-02 11:59:13','',''),(6980,'1','285','1',1,'Return of Retail Sale Id 6953',0.00,41540.00,62.00,0.00,-2480.00,'2023-01-02 12:00:47','',''),(6981,'1','285','1',1,'Retail Sale Id 6986',34572.00,0.00,0.00,51.60,2064.00,'2023-01-02 12:01:32','',''),(6982,'1','285','1',1,'Retail Sale Id 6987',9654.70,0.00,0.00,14.41,576.40,'2023-01-02 12:05:39','',''),(6983,'1','285','1',1,'Retail Sale Id 6988',1983.20,0.00,0.00,2.96,118.40,'2023-01-02 12:19:06','',''),(6984,'1','285','1',1,'Return of Retail Sale Id 6988',0.00,1983.20,2.96,0.00,-118.40,'2023-01-02 12:19:28','',''),(6985,'1','285','1',1,'Retail Sale Id 6989',1968.40,0.00,0.00,2.96,103.60,'2023-01-02 12:20:22','',''),(6986,'1','285','1',1,'Retail Sale Id 6990',997.50,0.00,0.00,1.33,159.60,'2023-01-02 12:27:10','',''),(6987,'1','285','1',1,'Retail Sale Id 6991',1500.00,0.00,0.00,2.00,240.00,'2023-01-02 12:28:06','',''),(6988,'1','285','1',1,'Retail Sale Id 6992',1500.00,0.00,0.00,2.00,240.00,'2023-01-02 12:34:15','',''),(6989,'1','285','1',1,'Return of Retail Sale Id 6977',0.00,33500.00,50.00,0.00,-2000.00,'2023-01-02 12:45:18','',''),(6990,'1','285','1',1,'Retail Sale Id 6993',40320.60,0.00,0.00,60.18,2407.20,'2023-01-02 12:46:07','',''),(6991,'1','285','1',1,'Retail Sale Id 6994',1800.00,0.00,0.00,2.40,288.00,'2023-01-02 12:49:38','',''),(6992,'1','285','1',1,'Retail Sale Id 6996',802.50,0.00,0.00,1.07,128.40,'2023-01-02 13:07:53','',''),(6993,'1','285','1',1,'Retail Sale Id 6998',2250.00,0.00,0.00,3.00,360.00,'2023-01-02 13:12:48','',''),(6994,'1','285','1',1,'Retail Sale Id 6999',750.00,0.00,0.00,1.00,120.00,'2023-01-02 13:31:46','',''),(6995,'1','285','1',1,'Retail Sale Id 7000',5250.00,0.00,0.00,7.00,840.00,'2023-01-02 13:41:43','',''),(6996,'1','285','1',1,'Retail Sale Id 7001',1500.00,0.00,0.00,2.00,240.00,'2023-01-02 13:49:08','',''),(6997,'1','285','1',1,'Retail Sale Id 7002',36923.70,0.00,0.00,55.11,2204.40,'2023-01-02 13:52:59','',''),(6998,'1','285','1',1,'Retail Sale Id 7003',2302.50,0.00,0.00,3.07,368.40,'2023-01-02 13:57:02','',''),(6999,'1','285','1',1,'Retail Sale Id 7004',7500.00,0.00,0.00,10.00,1200.00,'2023-01-02 14:01:32','',''),(7000,'1','285','1',1,'Retail Sale Id 7005',3000.00,0.00,0.00,4.00,480.00,'2023-01-02 14:03:02','',''),(7001,'1','285','1',1,'Retail Sale Id 7006',40374.20,0.00,0.00,60.26,2410.40,'2023-01-02 14:04:06','',''),(7002,'1','285','1',1,'Retail Sale Id 7007',750.00,0.00,0.00,1.00,120.00,'2023-01-02 14:06:54','',''),(7003,'1','285','1',1,'Retail Sale Id 7008',6000.00,0.00,0.00,8.00,960.00,'2023-01-02 14:07:57','',''),(7004,'1','285','1',1,'Retail Sale Id 7009',3000.00,0.00,0.00,4.00,480.00,'2023-01-02 14:14:49','',''),(7005,'1','285','1',1,'Retail Sale Id 7010',3000.00,0.00,0.00,4.00,480.00,'2023-01-02 14:25:20','',''),(7006,'1','285','1',1,'Retail Sale Id 7011',3000.00,0.00,0.00,4.00,480.00,'2023-01-02 14:42:24','',''),(7007,'1','285','1',1,'Retail Sale Id 7012',5250.00,0.00,0.00,7.00,840.00,'2023-01-02 14:45:02','',''),(7008,'1','285','1',1,'Retail Sale Id 7013',17775.10,0.00,0.00,26.53,1061.20,'2023-01-02 14:47:01','',''),(7009,'1','285','1',1,'Retail Sale Id 7014',31429.70,0.00,0.00,46.91,1876.40,'2023-01-02 14:56:18','',''),(7010,'1','285','1',1,'Retail Sale Id 7015',5250.00,0.00,0.00,7.00,840.00,'2023-01-02 15:06:58','',''),(7011,'1','285','1',1,'Retail Sale Id 7016',3750.00,0.00,0.00,5.00,600.00,'2023-01-02 15:10:10','',''),(7012,'1','285','1',1,'Retail Sale Id 7017',40695.80,0.00,0.00,60.74,2429.60,'2023-01-02 15:15:47','',''),(7013,'1','285','1',1,'Retail Sale Id 7018',802.50,0.00,0.00,1.07,128.40,'2023-01-02 15:17:12','',''),(7014,'1','285','1',1,'Retail Sale Id 7019',2302.50,0.00,0.00,3.07,368.40,'2023-01-02 15:18:23','',''),(7015,'1','285','1',1,'Retail Sale Id 7020',802.50,0.00,0.00,1.07,128.40,'2023-01-02 15:23:39','',''),(7016,'1','285','1',1,'Retail Sale Id 7021',1500.00,0.00,0.00,2.00,240.00,'2023-01-02 15:25:34','',''),(7017,'1','285','1',1,'Retail Sale Id 7022',4020.00,0.00,0.00,6.00,240.00,'2023-01-02 15:26:37','',''),(7018,'1','285','1',1,'Retail Sale Id 7023',47214.90,0.00,0.00,70.47,2818.80,'2023-01-02 15:28:54','',''),(7019,'1','285','1',1,'Retail Sale Id 7024',3000.00,0.00,0.00,4.00,480.00,'2023-01-02 15:29:43','',''),(7020,'1','285','1',1,'Retail Sale Id 7025',9869.10,0.00,0.00,14.73,589.20,'2023-01-02 15:32:27','',''),(7021,'1','285','1',1,'Retail Sale Id 7026',3000.00,0.00,0.00,4.00,480.00,'2023-01-02 15:36:26','',''),(7022,'1','285','1',1,'Retail Sale Id 7027',1500.00,0.00,0.00,2.00,240.00,'2023-01-02 15:37:37','',''),(7023,'1','285','1',1,'Retail Sale Id 7028',997.50,0.00,0.00,1.33,159.60,'2023-01-02 15:38:23','',''),(7024,'1','285','1',1,'Retail Sale Id 7029',802.50,0.00,0.00,1.07,128.40,'2023-01-02 15:39:24','',''),(7025,'1','285','1',1,'Retail Sale Id 7030',1500.00,0.00,0.00,2.00,240.00,'2023-01-02 15:40:18','',''),(7026,'1','285','1',1,'Retail Sale Id 7031',3000.00,0.00,0.00,4.00,480.00,'2023-01-02 15:43:29','',''),(7027,'1','285','1',1,'Retail Sale Id 7032',38102.90,0.00,0.00,56.87,2274.80,'2023-01-02 15:49:34','',''),(7028,'1','285','1',1,'Retail Sale Id 7034',242139.80,0.00,0.00,364.12,12744.20,'2023-01-02 15:56:00','',''),(7029,'1','285','1',1,'Retail Sale Id 7035',281893.50,0.00,0.00,423.90,14836.50,'2023-01-02 16:03:12','',''),(7030,'1','285','1',1,'Retail Sale Id 7036',22144.50,0.00,0.00,33.30,1165.50,'2023-01-02 16:11:15','',''),(7031,'1','285','1',1,'Retail Sale Id 7037',13172.20,0.00,0.00,19.66,786.40,'2023-01-02 16:14:57','',''),(7032,'1','285','1',1,'Retail Sale Id 7038',1402.50,0.00,0.00,1.87,224.40,'2023-01-02 16:16:56','',''),(7033,'1','285','1',1,'Retail Sale Id 7039',1500.00,0.00,0.00,2.00,240.00,'2023-01-02 16:21:16','',''),(7034,'1','285','1',1,'Retail Sale Id 7040',2302.50,0.00,0.00,3.07,368.40,'2023-01-02 16:25:10','',''),(7035,'1','285','1',1,'Retail Sale Id 7041',5250.00,0.00,0.00,7.00,840.00,'2023-01-02 16:26:35','',''),(7036,'1','285','1',1,'Retail Sale Id 7042',9000.00,0.00,0.00,12.00,1440.00,'2023-01-02 16:34:51','',''),(7037,'1','285','1',1,'Retail Sale Id 7043',40005.70,0.00,0.00,59.71,2388.40,'2023-01-02 16:46:17','',''),(7038,'1','285','1',1,'Retail Sale Id 7044',3000.00,0.00,0.00,4.00,480.00,'2023-01-02 16:52:47','',''),(7039,'1','285','1',1,'Retail Sale Id 7045',997.50,0.00,0.00,1.33,159.60,'2023-01-02 16:54:02','',''),(7040,'1','285','1',1,'Retail Sale Id 7046',3802.50,0.00,0.00,5.07,608.40,'2023-01-02 16:55:17','',''),(7041,'1','285','1',1,'Retail Sale Id 7047',3000.00,0.00,0.00,4.00,480.00,'2023-01-02 17:01:29','',''),(7042,'1','285','1',1,'Retail Sale Id 7048',1500.00,0.00,0.00,2.00,240.00,'2023-01-02 17:03:54','',''),(7043,'1','285','1',1,'Retail Sale Id 7049',802.50,0.00,0.00,1.07,128.40,'2023-01-02 17:04:39','',''),(7044,'1','285','1',1,'Retail Sale Id 7050',8250.00,0.00,0.00,11.00,1320.00,'2023-01-02 17:05:42','',''),(7045,'1','285','1',1,'Retail Sale Id 7051',3000.00,0.00,0.00,4.00,480.00,'2023-01-02 17:07:20','',''),(7046,'1','285','1',1,'Retail Sale Id 7052',695071.30,0.00,0.00,1045.22,36582.70,'2023-01-02 17:13:01','',''),(7047,'1','285','1',1,'Retail Sale Id 7053',40762.80,0.00,0.00,60.84,2433.60,'2023-01-02 17:19:13','',''),(7048,'1','285','1',1,'Retail Sale Id 7054',1366.80,0.00,0.00,2.04,81.60,'2023-01-02 18:33:13','',''),(7049,'1','285','1',1,'Retail Sale Id 7055',1500.00,0.00,0.00,2.00,240.00,'2023-01-03 07:11:02','',''),(7050,'1','285','1',1,'Retail Sale Id 7056',48447.70,0.00,0.00,72.31,2892.40,'2023-01-03 07:16:15','',''),(7051,'1','285','1',1,'Retail Sale Id 7057',41265.30,0.00,0.00,61.59,2463.60,'2023-01-03 07:27:40','',''),(7052,'1','285','1',1,'Retail Sale Id 7058',2302.50,0.00,0.00,3.07,368.40,'2023-01-03 07:30:11','',''),(7053,'1','285','1',1,'Retail Sale Id 7059',1500.00,0.00,0.00,2.00,240.00,'2023-01-03 07:32:28','',''),(7054,'1','285','1',1,'Retail Sale Id 7060',28140.00,0.00,0.00,42.00,1680.00,'2023-01-03 07:36:25','',''),(7055,'1','285','1',1,'Retail Sale Id 7061',802.50,0.00,0.00,1.07,128.40,'2023-01-03 07:38:13','',''),(7056,'1','285','1',1,'Retail Sale Id 7062',750.00,0.00,0.00,1.00,120.00,'2023-01-03 07:39:26','',''),(7057,'1','285','1',1,'Retail Sale Id 7063',32227.00,0.00,0.00,48.10,1924.00,'2023-01-03 07:45:51','',''),(7058,'1','285','1',1,'Retail Sale Id 7064',26800.00,0.00,0.00,40.00,1600.00,'2023-01-03 07:48:08','',''),(7059,'1','285','1',1,'Retail Sale Id 7065',997.50,0.00,0.00,1.33,159.60,'2023-01-03 07:54:58','',''),(7060,'1','285','1',1,'Retail Sale Id 7066',750.00,0.00,0.00,1.00,120.00,'2023-01-03 07:59:20','',''),(7061,'1','285','1',1,'Retail Sale Id 7067',3000.00,0.00,0.00,4.00,480.00,'2023-01-03 08:07:22','',''),(7062,'1','285','1',1,'Retail Sale Id 7068',88547.20,0.00,0.00,132.16,5286.40,'2023-01-03 08:09:23','',''),(7063,'1','285','1',1,'Retail Sale Id 7069',2250.00,0.00,0.00,3.00,360.00,'2023-01-03 08:18:35','',''),(7064,'1','285','1',1,'Retail Sale Id 7070',16575.80,0.00,0.00,24.74,989.60,'2023-01-03 08:26:09','',''),(7065,'1','285','1',1,'Retail Sale Id 7071',1500.00,0.00,0.00,2.00,240.00,'2023-01-03 08:35:18','',''),(7066,'1','285','1',1,'Retail Sale Id 7072',66571.20,0.00,0.00,99.36,3974.40,'2023-01-03 08:44:16','',''),(7067,'1','285','1',1,'Retail Sale Id 7073',750.00,0.00,0.00,1.00,120.00,'2023-01-03 08:46:24','',''),(7068,'1','285','1',1,'Retail Sale Id 7074',9375.00,0.00,0.00,12.50,1500.00,'2023-01-03 08:48:16','',''),(7069,'1','285','1',1,'Retail Sale Id 7075',3997.50,0.00,0.00,5.33,639.60,'2023-01-03 08:50:22','',''),(7070,'1','285','1',1,'Retail Sale Id 7076',33500.00,0.00,0.00,50.00,2000.00,'2023-01-03 08:52:32','',''),(7071,'1','285','1',1,'Retail Sale Id 7077',1500.00,0.00,0.00,2.00,240.00,'2023-01-03 08:58:59','',''),(7072,'1','285','1',1,'Retail Sale Id 7078',3000.00,0.00,0.00,4.00,480.00,'2023-01-03 09:02:17','',''),(7073,'1','285','1',1,'Retail Sale Id 7079',40548.40,0.00,0.00,60.52,2420.80,'2023-01-03 09:03:10','',''),(7074,'1','285','1',1,'Retail Sale Id 7080',2250.00,0.00,0.00,3.00,360.00,'2023-01-03 09:06:50','',''),(7075,'1','285','1',1,'Retail Sale Id 7081',3000.00,0.00,0.00,4.00,480.00,'2023-01-03 09:07:43','',''),(7076,'1','285','1',1,'Retail Sale Id 7082',2250.00,0.00,0.00,3.00,360.00,'2023-01-03 09:08:57','',''),(7077,'1','285','1',1,'Retail Sale Id 7083',1500.00,0.00,0.00,2.00,240.00,'2023-01-03 09:11:48','',''),(7078,'1','285','1',1,'Retail Sale Id 7084',3000.00,0.00,0.00,4.00,480.00,'2023-01-03 09:13:07','',''),(7079,'1','285','1',1,'Retail Sale Id 7085',323522.50,0.00,0.00,486.50,17027.50,'2023-01-03 09:16:49','',''),(7080,'1','285','1',1,'Retail Sale Id 7086',5002.50,0.00,0.00,6.67,800.40,'2023-01-03 09:18:51','',''),(7081,'1','285','1',1,'Retail Sale Id 7087',997.50,0.00,0.00,1.33,159.60,'2023-01-03 09:20:45','',''),(7082,'1','285','1',1,'Retail Sale Id 7088',1500.00,0.00,0.00,2.00,240.00,'2023-01-03 09:27:09','',''),(7083,'1','285','1',1,'Retail Sale Id 7089',997.50,0.00,0.00,1.33,159.60,'2023-01-03 09:32:05','',''),(7084,'1','285','1',1,'Retail Sale Id 7090',2250.00,0.00,0.00,3.00,360.00,'2023-01-03 09:42:18','',''),(7085,'1','285','1',1,'Retail Sale Id 7091',2250.00,0.00,0.00,3.00,360.00,'2023-01-03 09:43:33','',''),(7086,'1','285','1',1,'Retail Sale Id 7092',802.50,0.00,0.00,1.07,128.40,'2023-01-03 09:46:32','',''),(7087,'1','285','1',1,'Retail Sale Id 7093',2250.00,0.00,0.00,3.00,360.00,'2023-01-03 09:49:14','',''),(7088,'1','285','1',1,'Retail Sale Id 7094',997.50,0.00,0.00,1.33,159.60,'2023-01-03 09:52:59','',''),(7089,'1','285','1',1,'Retail Sale Id 7095',40849.90,0.00,0.00,60.97,2438.80,'2023-01-03 09:54:02','',''),(7090,'1','285','1',1,'Retail Sale Id 7096',2002.50,0.00,0.00,2.67,320.40,'2023-01-03 09:56:21','',''),(7091,'1','285','1',1,'Retail Sale Id 7097',7500.00,0.00,0.00,10.00,1200.00,'2023-01-03 09:59:09','',''),(7092,'1','285','1',1,'Retail Sale Id 7098',5250.00,0.00,0.00,7.00,840.00,'2023-01-03 10:08:46','',''),(7093,'1','285','1',1,'Retail Sale Id 7100',1702.50,0.00,0.00,2.27,272.40,'2023-01-03 10:23:19','',''),(7094,'1','285','1',1,'Retail Sale Id 7101',3000.00,0.00,0.00,4.00,480.00,'2023-01-03 10:24:16','',''),(7095,'1','285','1',1,'Retail Sale Id 7102',40565.00,0.00,0.00,61.00,2135.00,'2023-01-03 10:33:35','',''),(7096,'1','285','1',1,'Retail Sale Id 7103',1500.00,0.00,0.00,2.00,240.00,'2023-01-03 10:35:01','',''),(7097,'1','285','1',1,'Retail Sale Id 7104',365364.30,0.00,0.00,549.42,19229.70,'2023-01-03 10:41:23','',''),(7098,'1','285','1',1,'Retail Sale Id 7105',997.50,0.00,0.00,1.33,159.60,'2023-01-03 10:48:59','',''),(7099,'1','285','1',1,'Retail Sale Id 7106',2250.00,0.00,0.00,3.00,360.00,'2023-01-03 10:50:54','',''),(7100,'1','285','1',1,'Retail Sale Id 7107',750.00,0.00,0.00,1.00,120.00,'2023-01-03 10:55:19','',''),(7101,'1','285','1',1,'Retail Sale Id 7108',40870.00,0.00,0.00,61.00,2440.00,'2023-01-03 11:01:47','',''),(7102,'1','285','1',1,'Retail Sale Id 7109',2302.50,0.00,0.00,3.07,368.40,'2023-01-03 11:05:34','',''),(7103,'1','285','1',1,'Retail Sale Id 7110',40943.70,0.00,0.00,61.11,2444.40,'2023-01-03 11:06:36','',''),(7104,'1','285','1',1,'Retail Sale Id 7111',1500.00,0.00,0.00,2.00,240.00,'2023-01-03 11:08:28','',''),(7105,'1','285','1',1,'Retail Sale Id 7112',23610.80,0.00,0.00,35.24,1409.60,'2023-01-03 11:09:45','',''),(7106,'1','285','1',1,'Retail Sale Id 7113',3000.00,0.00,0.00,4.00,480.00,'2023-01-03 11:22:00','',''),(7107,'1','285','1',1,'Retail Sale Id 7114',186200.00,0.00,0.00,280.00,9800.00,'2023-01-03 11:38:18','',''),(7108,'1','285','1',1,'Retail Sale Id 7115',41540.00,0.00,0.00,62.00,2480.00,'2023-01-03 11:54:08','',''),(7109,'1','285','1',1,'Retail Sale Id 7116',209195.70,0.00,0.00,314.58,11010.30,'2023-01-03 11:58:16','',''),(7110,'1','285','1',1,'Retail Sale Id 7117',26800.00,0.00,0.00,40.00,1600.00,'2023-01-03 12:01:53','',''),(7111,'1','285','1',1,'Retail Sale Id 7118',11731.70,0.00,0.00,17.51,700.40,'2023-01-03 12:12:10','',''),(7112,'1','285','1',1,'Retail Sale Id 7119',4655.00,0.00,0.00,7.00,245.00,'2023-01-03 12:25:36','',''),(7113,'1','285','1',1,'Retail Sale Id 7120',40300.50,0.00,0.00,60.15,2406.00,'2023-01-03 12:28:18','',''),(7114,'1','285','1',1,'Retail Sale Id 7121',36387.70,0.00,0.00,54.31,2172.40,'2023-01-03 12:29:20','',''),(7115,'1','285','1',1,'Retail Sale Id 7122',40200.00,0.00,0.00,60.00,2400.00,'2023-01-03 12:43:00','',''),(7116,'1','285','1',1,'Retail Sale Id 7123',199500.00,0.00,0.00,300.00,10500.00,'2023-01-03 13:24:36','',''),(7117,'1','285','1',1,'Retail Sale Id 7124',29480.00,0.00,0.00,44.00,1760.00,'2023-01-03 13:42:27','',''),(7118,'1','285','1',1,'Retail Sale Id 7125',80735.00,0.00,0.00,120.50,4820.00,'2023-01-03 14:15:27','',''),(7119,'1','285','1',1,'Retail Sale Id 7126',67000.00,0.00,0.00,100.00,4000.00,'2023-01-03 14:25:18','',''),(7120,'1','285','1',1,'Retail Sale Id 7127',4500.00,0.00,0.00,6.00,720.00,'2023-01-03 14:36:53','',''),(7121,'1','285','1',1,'Retail Sale Id 7128',65177.60,0.00,0.00,97.28,3891.20,'2023-01-03 14:38:30','',''),(7122,'1','285','1',1,'Retail Sale Id 7129',2250.00,0.00,0.00,3.00,360.00,'2023-01-03 14:44:50','',''),(7123,'1','285','1',1,'Retail Sale Id 7130',3000.00,0.00,0.00,4.00,480.00,'2023-01-03 15:15:53','',''),(7124,'1','285','1',1,'Retail Sale Id 7131',802.50,0.00,0.00,1.07,128.40,'2023-01-03 15:19:02','',''),(7125,'1','285','1',1,'Retail Sale Id 7132',665000.00,0.00,0.00,1000.00,35000.00,'2023-01-03 15:25:14','',''),(7126,'1','285','1',1,'Retail Sale Id 7133',38263.70,0.00,0.00,57.11,2284.40,'2023-01-03 15:26:50','',''),(7127,'1','285','1',1,'Retail Sale Id 7134',2250.00,0.00,0.00,3.00,360.00,'2023-01-03 15:31:39','',''),(7128,'1','285','1',1,'Retail Sale Id 7135',3000.00,0.00,0.00,4.00,480.00,'2023-01-03 15:35:04','',''),(7129,'1','285','1',1,'Retail Sale Id 7136',5002.50,0.00,0.00,6.67,800.40,'2023-01-03 15:35:55','',''),(7130,'1','285','1',1,'Retail Sale Id 7137',1500.00,0.00,0.00,2.00,240.00,'2023-01-03 15:39:12','',''),(7131,'1','285','1',1,'Retail Sale Id 7138',2002.50,0.00,0.00,2.67,320.40,'2023-01-03 15:39:57','',''),(7132,'1','285','1',1,'Retail Sale Id 7139',802.50,0.00,0.00,1.07,128.40,'2023-01-03 15:41:12','',''),(7133,'1','285','1',1,'Retail Sale Id 7140',997.50,0.00,0.00,1.33,159.60,'2023-01-03 15:42:04','',''),(7134,'1','285','1',1,'Retail Sale Id 7141',5002.50,0.00,0.00,6.67,800.40,'2023-01-03 15:47:27','',''),(7135,'1','285','1',1,'Retail Sale Id 7142',3000.00,0.00,0.00,4.00,480.00,'2023-01-03 15:50:27','',''),(7136,'1','285','1',1,'Retail Sale Id 7143',3000.00,0.00,0.00,4.00,480.00,'2023-01-03 16:06:32','',''),(7137,'1','285','1',1,'Retail Sale Id 7144',1500.00,0.00,0.00,2.00,240.00,'2023-01-03 16:08:25','',''),(7138,'1','285','1',1,'Retail Sale Id 7145',40481.40,0.00,0.00,60.42,2416.80,'2023-01-03 16:10:27','',''),(7139,'1','285','1',1,'Retail Sale Id 7146',35510.00,0.00,0.00,53.00,2120.00,'2023-01-03 16:14:28','',''),(7140,'1','285','1',1,'Retail Sale Id 7147',750.00,0.00,0.00,1.00,120.00,'2023-01-03 16:18:56','',''),(7141,'1','285','1',1,'Retail Sale Id 7148',3000.00,0.00,0.00,4.00,480.00,'2023-01-03 16:23:01','',''),(7142,'1','285','1',1,'Retail Sale Id 7149',750.00,0.00,0.00,1.00,120.00,'2023-01-03 16:24:40','',''),(7143,'1','285','1',1,'Retail Sale Id 7150',1500.00,0.00,0.00,2.00,240.00,'2023-01-03 16:32:56','',''),(7144,'1','285','1',1,'Retail Sale Id 7151',46370.70,0.00,0.00,69.21,2768.40,'2023-01-03 16:43:27','',''),(7145,'1','285','1',1,'Retail Sale Id 7152',5250.00,0.00,0.00,7.00,840.00,'2023-01-03 16:48:10','',''),(7146,'1','285','1',1,'Retail Sale Id 7153',3000.00,0.00,0.00,4.00,480.00,'2023-01-03 16:53:18','',''),(7147,'1','285','1',1,'Retail Sale Id 7154',2250.00,0.00,0.00,3.00,360.00,'2023-01-03 16:54:52','',''),(7148,'1','285','1',1,'Retail Sale Id 7155',4500.00,0.00,0.00,6.00,720.00,'2023-01-03 16:55:36','',''),(7149,'1','285','1',1,'Retail Sale Id 7156',3750.00,0.00,0.00,5.00,600.00,'2023-01-03 16:57:11','',''),(7150,'1','285','1',1,'Retail Sale Id 7157',3000.00,0.00,0.00,4.00,480.00,'2023-01-03 17:00:19','',''),(7151,'1','285','1',1,'Retail Sale Id 7158',1500.00,0.00,0.00,2.00,240.00,'2023-01-03 17:01:56','',''),(7152,'1','285','1',1,'Retail Sale Id 7159',1500.00,0.00,0.00,2.00,240.00,'2023-01-03 17:07:20','',''),(7153,'1','285','1',1,'Return of Retail Sale Id 7149',0.00,750.00,1.00,0.00,-120.00,'2023-01-03 19:18:52','',''),(7154,'1','285','1',1,'Retail Sale Id 7160',615.00,0.00,0.00,0.82,98.40,'2023-01-03 19:20:15','',''),(7155,'1','285','1',1,'Retail Sale Id 7161',48387.40,0.00,0.00,72.22,2888.80,'2023-01-04 07:21:05','',''),(7156,'1','285','1',1,'Retail Sale Id 7163',3997.50,0.00,0.00,5.33,639.60,'2023-01-04 07:24:52','',''),(7157,'1','285','1',1,'Retail Sale Id 7164',42042.50,0.00,0.00,62.75,2510.00,'2023-01-04 07:26:29','',''),(7158,'1','285','1',1,'Retail Sale Id 7165',5250.00,0.00,0.00,7.00,840.00,'2023-01-04 07:28:31','',''),(7159,'1','285','1',1,'Retail Sale Id 7166',1500.00,0.00,0.00,2.00,240.00,'2023-01-04 07:38:12','',''),(7160,'1','285','1',1,'Retail Sale Id 7167',1500.00,0.00,0.00,2.00,240.00,'2023-01-04 07:39:49','',''),(7161,'1','285','1',1,'Retail Sale Id 7168',750.00,0.00,0.00,1.00,120.00,'2023-01-04 07:43:52','',''),(7162,'1','285','1',1,'Retail Sale Id 7169',5250.00,0.00,0.00,7.00,840.00,'2023-01-04 07:45:06','',''),(7163,'1','285','1',1,'Retail Sale Id 7170',1500.00,0.00,0.00,2.00,240.00,'2023-01-04 07:46:05','',''),(7164,'1','285','1',1,'Retail Sale Id 7171',997.50,0.00,0.00,1.33,159.60,'2023-01-04 07:46:56','',''),(7165,'1','285','1',1,'Retail Sale Id 7172',24790.00,0.00,0.00,37.00,1480.00,'2023-01-04 07:49:58','',''),(7166,'1','285','1',1,'Retail Sale Id 7173',2250.00,0.00,0.00,3.00,360.00,'2023-01-04 07:51:40','',''),(7167,'1','285','1',1,'Retail Sale Id 7174',5002.50,0.00,0.00,6.67,800.40,'2023-01-04 07:55:58','',''),(7168,'1','285','1',1,'Retail Sale Id 7175',96794.90,0.00,0.00,144.47,5778.80,'2023-01-04 07:58:37','',''),(7169,'1','285','1',1,'Retail Sale Id 7176',2250.00,0.00,0.00,3.00,360.00,'2023-01-04 08:01:53','',''),(7170,'1','285','1',1,'Retail Sale Id 7177',750.00,0.00,0.00,1.00,120.00,'2023-01-04 08:02:36','',''),(7171,'1','285','1',1,'Retail Sale Id 7178',8250.00,0.00,0.00,11.00,1320.00,'2023-01-04 08:03:26','',''),(7172,'1','285','1',1,'Retail Sale Id 7179',2250.00,0.00,0.00,3.00,360.00,'2023-01-04 08:04:13','',''),(7173,'1','285','1',1,'Retail Sale Id 7180',40200.00,0.00,0.00,60.00,2400.00,'2023-01-04 08:06:09','',''),(7174,'1','285','1',1,'Retail Sale Id 7181',41285.40,0.00,0.00,61.62,2464.80,'2023-01-04 08:08:53','',''),(7175,'1','285','1',1,'Retail Sale Id 7182',40200.00,0.00,0.00,60.00,2400.00,'2023-01-04 08:11:06','',''),(7176,'1','285','1',1,'Retail Sale Id 7183',2250.00,0.00,0.00,3.00,360.00,'2023-01-04 08:12:44','',''),(7177,'1','285','1',1,'Retail Sale Id 7184',997.50,0.00,0.00,1.33,159.60,'2023-01-04 08:13:35','',''),(7178,'1','285','1',1,'Retail Sale Id 7185',3000.00,0.00,0.00,4.00,480.00,'2023-01-04 08:14:26','',''),(7179,'1','285','1',1,'Retail Sale Id 7187',26800.00,0.00,0.00,40.00,1600.00,'2023-01-04 08:15:53','',''),(7180,'1','285','1',1,'Retail Sale Id 7188',1500.00,0.00,0.00,2.00,240.00,'2023-01-04 08:26:04','',''),(7181,'1','285','1',1,'Retail Sale Id 7189',750.00,0.00,0.00,1.00,120.00,'2023-01-04 08:33:54','',''),(7182,'1','285','1',1,'Retail Sale Id 7190',3000.00,0.00,0.00,4.00,480.00,'2023-01-04 08:34:51','',''),(7183,'1','285','1',1,'Retail Sale Id 7191',110777.80,0.00,0.00,165.34,6613.60,'2023-01-04 08:43:00','',''),(7184,'1','285','1',1,'Retail Sale Id 7192',16857.20,0.00,0.00,25.16,1006.40,'2023-01-04 08:47:20','',''),(7185,'1','285','1',1,'Retail Sale Id 7193',22110.00,0.00,0.00,33.00,1320.00,'2023-01-04 08:50:31','',''),(7186,'1','285','1',1,'Retail Sale Id 7194',33500.00,0.00,0.00,50.00,2000.00,'2023-01-04 08:52:09','',''),(7187,'1','285','1',1,'Retail Sale Id 7195',31918.80,0.00,0.00,47.64,1905.60,'2023-01-04 08:54:22','',''),(7188,'1','285','1',1,'Retail Sale Id 7196',1500.00,0.00,0.00,2.00,240.00,'2023-01-04 08:55:55','',''),(7189,'1','285','1',1,'Retail Sale Id 7197',1500.00,0.00,0.00,2.00,240.00,'2023-01-04 08:56:35','',''),(7190,'1','285','1',1,'Retail Sale Id 7198',997.50,0.00,0.00,1.33,159.60,'2023-01-04 08:57:16','',''),(7191,'1','285','1',1,'Retail Sale Id 7199',2250.00,0.00,0.00,3.00,360.00,'2023-01-04 08:57:59','',''),(7192,'1','285','1',1,'Retail Sale Id 7200',2250.00,0.00,0.00,3.00,360.00,'2023-01-04 08:58:41','',''),(7193,'1','285','1',1,'Retail Sale Id 7201',3000.00,0.00,0.00,4.00,480.00,'2023-01-04 08:59:24','',''),(7194,'1','285','1',1,'Retail Sale Id 7202',83863.90,0.00,0.00,125.17,5006.80,'2023-01-04 09:01:30','',''),(7195,'1','285','1',1,'Retail Sale Id 7203',45318.80,0.00,0.00,67.64,2705.60,'2023-01-04 09:14:18','',''),(7196,'1','285','1',1,'Retail Sale Id 7204',42993.90,0.00,0.00,64.17,2566.80,'2023-01-04 09:17:38','',''),(7197,'1','285','1',1,'Retail Sale Id 7205',26800.00,0.00,0.00,40.00,1600.00,'2023-01-04 09:19:14','',''),(7198,'1','285','1',1,'Retail Sale Id 7206',2250.00,0.00,0.00,3.00,360.00,'2023-01-04 09:20:31','',''),(7199,'1','285','1',1,'Retail Sale Id 7207',3997.50,0.00,0.00,5.33,639.60,'2023-01-04 09:23:00','',''),(7200,'1','285','1',1,'Retail Sale Id 7208',12750.00,0.00,0.00,17.00,2040.00,'2023-01-04 09:25:26','',''),(7201,'1','285','1',1,'Retail Sale Id 7209',2250.00,0.00,0.00,3.00,360.00,'2023-01-04 09:26:05','',''),(7202,'1','285','1',1,'Retail Sale Id 7210',3000.00,0.00,0.00,4.00,480.00,'2023-01-04 09:29:50','',''),(7203,'1','285','1',1,'Retail Sale Id 7211',28140.00,0.00,0.00,42.00,1680.00,'2023-01-04 09:31:05','',''),(7204,'1','285','1',1,'Retail Sale Id 7212',750.00,0.00,0.00,1.00,120.00,'2023-01-04 09:32:31','',''),(7205,'1','285','1',1,'Retail Sale Id 7213',1500.00,0.00,0.00,2.00,240.00,'2023-01-04 09:35:36','',''),(7206,'1','285','1',1,'Retail Sale Id 7214',16522.20,0.00,0.00,24.66,986.40,'2023-01-04 09:38:16','',''),(7207,'1','285','1',1,'Retail Sale Id 7215',27034.50,0.00,0.00,40.35,1614.00,'2023-01-04 09:42:08','',''),(7208,'1','285','1',1,'Retail Sale Id 7216',11771.90,0.00,0.00,17.57,702.80,'2023-01-04 09:47:11','',''),(7209,'1','285','1',1,'Retail Sale Id 7217',36180.00,0.00,0.00,54.00,2160.00,'2023-01-04 09:49:58','',''),(7210,'1','285','1',1,'Retail Sale Id 7218',12890.80,0.00,0.00,19.24,769.60,'2023-01-04 09:53:13','',''),(7211,'1','285','1',1,'Retail Sale Id 7219',14625.00,0.00,0.00,19.50,2340.00,'2023-01-04 09:54:29','',''),(7212,'1','285','1',1,'Retail Sale Id 7220',17882.30,0.00,0.00,26.69,1067.60,'2023-01-04 09:59:13','',''),(7213,'1','285','1',1,'Return of Retail Sale Id 7209',0.00,2250.00,3.00,0.00,-360.00,'2023-01-04 10:01:50','',''),(7214,'1','285','1',1,'Retail Sale Id 7221',2542.50,0.00,0.00,3.39,406.80,'2023-01-04 10:02:32','',''),(7215,'1','285','1',1,'Retail Sale Id 7222',60300.00,0.00,0.00,90.00,3600.00,'2023-01-04 10:05:45','',''),(7216,'1','285','1',1,'Retail Sale Id 7223',3000.00,0.00,0.00,4.00,480.00,'2023-01-04 10:08:27','',''),(7217,'1','285','1',1,'Retail Sale Id 7224',1500.00,0.00,0.00,2.00,240.00,'2023-01-04 10:11:25','',''),(7218,'1','285','1',1,'Retail Sale Id 7225',35965.60,0.00,0.00,53.68,2147.20,'2023-01-04 10:17:02','',''),(7219,'1','285','1',1,'Retail Sale Id 7226',42230.10,0.00,0.00,63.03,2521.20,'2023-01-04 10:20:12','',''),(7220,'1','285','1',1,'Retail Sale Id 7227',41406.00,0.00,0.00,61.80,2472.00,'2023-01-04 10:22:34','',''),(7221,'1','285','1',1,'Retail Sale Id 7228',2250.00,0.00,0.00,3.00,360.00,'2023-01-04 10:24:25','',''),(7222,'1','285','1',1,'Retail Sale Id 7229',1500.00,0.00,0.00,2.00,240.00,'2023-01-04 10:25:25','',''),(7223,'1','285','1',1,'Retail Sale Id 7230',1500.00,0.00,0.00,2.00,240.00,'2023-01-04 10:26:09','',''),(7224,'1','285','1',1,'Retail Sale Id 7231',2250.00,0.00,0.00,3.00,360.00,'2023-01-04 10:26:55','',''),(7225,'1','285','1',1,'Retail Sale Id 7232',40200.00,0.00,0.00,60.00,2400.00,'2023-01-04 10:41:19','',''),(7226,'1','285','1',1,'Retail Sale Id 7233',81994.60,0.00,0.00,122.38,4895.20,'2023-01-04 10:44:52','',''),(7227,'1','285','1',1,'Retail Sale Id 7234',41613.70,0.00,0.00,62.11,2484.40,'2023-01-04 10:51:40','',''),(7228,'1','285','1',1,'Retail Sale Id 7235',1500.00,0.00,0.00,2.00,240.00,'2023-01-04 10:53:42','',''),(7229,'1','285','1',1,'Retail Sale Id 7236',79800.00,0.00,0.00,120.00,4200.00,'2023-01-04 10:57:34','',''),(7230,'1','285','1',1,'Retail Sale Id 7237',9000.00,0.00,0.00,12.00,1440.00,'2023-01-04 11:06:29','',''),(7231,'1','285','1',1,'Retail Sale Id 7238',9000.00,0.00,0.00,12.00,1440.00,'2023-01-04 11:07:22','',''),(7232,'1','285','1',1,'Retail Sale Id 7239',1500.00,0.00,0.00,2.00,240.00,'2023-01-04 11:09:15','',''),(7233,'1','285','1',1,'Retail Sale Id 7240',4500.00,0.00,0.00,6.00,720.00,'2023-01-04 11:10:38','',''),(7234,'1','285','1',1,'Retail Sale Id 7241',10083.50,0.00,0.00,15.05,602.00,'2023-01-04 11:23:19','',''),(7235,'1','285','1',1,'Retail Sale Id 7242',3000.00,0.00,0.00,4.00,480.00,'2023-01-04 11:25:27','',''),(7236,'1','285','1',1,'Retail Sale Id 7243',1500.00,0.00,0.00,2.00,240.00,'2023-01-04 11:29:02','',''),(7237,'1','285','1',1,'Retail Sale Id 7244',3750.00,0.00,0.00,5.00,600.00,'2023-01-04 11:31:48','',''),(7238,'1','285','1',1,'Retail Sale Id 7245',1500.00,0.00,0.00,2.00,240.00,'2023-01-04 11:32:54','',''),(7239,'1','285','1',1,'Retail Sale Id 7246',2497.50,0.00,0.00,3.33,399.60,'2023-01-04 11:37:15','',''),(7240,'1','285','1',1,'Retail Sale Id 7247',2250.00,0.00,0.00,3.00,360.00,'2023-01-04 11:47:34','',''),(7241,'1','285','1',1,'Retail Sale Id 7248',750.00,0.00,0.00,1.00,120.00,'2023-01-04 11:48:55','',''),(7242,'1','285','1',1,'Retail Sale Id 7249',3750.00,0.00,0.00,5.00,600.00,'2023-01-04 11:49:43','',''),(7243,'1','285','1',1,'Retail Sale Id 7250',750.00,0.00,0.00,1.00,120.00,'2023-01-04 12:00:37','',''),(7244,'1','285','1',1,'Retail Sale Id 7251',1500.00,0.00,0.00,2.00,240.00,'2023-01-04 12:01:21','',''),(7245,'1','285','1',1,'Retail Sale Id 7252',2002.50,0.00,0.00,2.67,320.40,'2023-01-04 12:02:16','',''),(7246,'1','285','1',1,'Retail Sale Id 7253',11423.50,0.00,0.00,17.05,682.00,'2023-01-04 12:09:41','',''),(7247,'1','285','1',1,'Retail Sale Id 7254',3000.00,0.00,0.00,4.00,480.00,'2023-01-04 12:11:36','',''),(7248,'1','285','1',1,'Retail Sale Id 7255',9375.00,0.00,0.00,12.50,1500.00,'2023-01-04 12:13:26','',''),(7249,'1','285','1',1,'Retail Sale Id 7256',11751.80,0.00,0.00,17.54,701.60,'2023-01-04 12:14:55','',''),(7250,'1','285','1',1,'Retail Sale Id 7257',203224.00,0.00,0.00,305.60,10696.00,'2023-01-04 12:22:17','',''),(7251,'1','285','1',1,'Retail Sale Id 7258',3953.00,0.00,0.00,5.90,236.00,'2023-01-04 12:27:36','',''),(7252,'1','285','1',1,'Retail Sale Id 7259',2250.00,0.00,0.00,3.00,360.00,'2023-01-04 12:29:10','',''),(7253,'1','285','1',1,'Retail Sale Id 7260',3000.00,0.00,0.00,4.00,480.00,'2023-01-04 12:30:09','',''),(7254,'1','285','1',1,'Retail Sale Id 7261',1500.00,0.00,0.00,2.00,240.00,'2023-01-04 12:45:18','',''),(7255,'1','285','1',1,'Retail Sale Id 7262',1500.00,0.00,0.00,2.00,240.00,'2023-01-04 12:53:23','',''),(7256,'1','285','1',1,'Retail Sale Id 7263',552455.40,0.00,0.00,830.76,29076.60,'2023-01-04 12:55:53','',''),(7257,'1','285','1',1,'Retail Sale Id 7264',159600.00,0.00,0.00,240.00,8400.00,'2023-01-04 13:04:46','',''),(7258,'1','285','1',1,'Retail Sale Id 7265',3000.00,0.00,0.00,4.00,480.00,'2023-01-04 13:07:02','',''),(7259,'1','285','1',1,'Retail Sale Id 7266',4500.00,0.00,0.00,6.00,720.00,'2023-01-04 13:07:52','',''),(7260,'1','285','1',1,'Retail Sale Id 7267',1500.00,0.00,0.00,2.00,240.00,'2023-01-04 13:09:08','',''),(7261,'1','285','1',1,'Retail Sale Id 7268',1500.00,0.00,0.00,2.00,240.00,'2023-01-04 13:14:38','',''),(7262,'1','285','1',1,'Retail Sale Id 7269',2002.50,0.00,0.00,2.67,320.40,'2023-01-04 13:16:20','',''),(7263,'1','285','1',1,'Retail Sale Id 7270',40200.00,0.00,0.00,60.00,2400.00,'2023-01-04 13:21:38','',''),(7264,'1','285','1',1,'Retail Sale Id 7271',78523.20,0.00,0.00,118.08,4132.80,'2023-01-04 13:39:56','',''),(7265,'1','285','1',1,'Retail Sale Id 7272',9000.00,0.00,0.00,12.00,1440.00,'2023-01-04 13:48:05','',''),(7266,'1','285','1',1,'Retail Sale Id 7273',802.50,0.00,0.00,1.07,128.40,'2023-01-04 14:16:00','',''),(7267,'1','285','1',1,'Retail Sale Id 7274',1500.00,0.00,0.00,2.00,240.00,'2023-01-04 14:16:57','',''),(7268,'1','285','1',1,'Retail Sale Id 7275',4500.00,0.00,0.00,6.00,720.00,'2023-01-04 14:34:26','',''),(7269,'1','285','1',1,'Retail Sale Id 7276',3000.00,0.00,0.00,4.00,480.00,'2023-01-04 14:43:33','',''),(7270,'1','285','1',1,'Retail Sale Id 7277',4500.00,0.00,0.00,6.00,720.00,'2023-01-04 14:44:25','',''),(7271,'1','285','1',1,'Retail Sale Id 7278',6000.00,0.00,0.00,8.00,960.00,'2023-01-04 14:45:47','',''),(7272,'1','285','1',1,'Retail Sale Id 7279',1500.00,0.00,0.00,2.00,240.00,'2023-01-04 14:46:45','',''),(7273,'1','285','1',1,'Return of Retail Sale Id 7277',0.00,4500.00,6.00,0.00,-720.00,'2023-01-04 14:47:42','',''),(7274,'1','285','1',1,'Retail Sale Id 7280',32655.80,0.00,0.00,48.74,1949.60,'2023-01-04 14:56:20','',''),(7275,'1','285','1',1,'Retail Sale Id 7281',1500.00,0.00,0.00,2.00,240.00,'2023-01-04 14:58:56','',''),(7276,'1','285','1',1,'Retail Sale Id 7282',1500.00,0.00,0.00,2.00,240.00,'2023-01-04 15:15:04','',''),(7277,'1','285','1',1,'Retail Sale Id 7283',4500.00,0.00,0.00,6.00,720.00,'2023-01-04 15:25:48','',''),(7278,'1','285','1',1,'Return of Retail Sale Id 7280',0.00,32655.80,48.74,0.00,-1949.60,'2023-01-04 17:01:30','',''),(7279,'1','285','1',1,'Retail Sale Id 7284',32776.40,0.00,0.00,48.92,1956.80,'2023-01-04 17:02:38','',''),(7280,'1','285','1',1,'Distributed to AA RANO NIGERIA LTD for sales id:9',489604.50,0.00,0.00,777.15,0.00,'2023-01-04 17:36:37','',''),(7281,'1','285',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,12600000.00,20000.00,0.00,0.00,'2023-01-05 06:54:43','',''),(7282,'1','285',NULL,1,'Reception corrector for bridging 11',0.00,0.00,0.00,20000.00,0.00,'2023-01-05 06:56:40','',''),(7283,'1','285','1',1,'Received from bridging 11',0.00,0.00,20000.00,0.00,0.00,'2023-01-05 06:56:40','',''),(7284,'1','285','1',1,'Retail Sale Id 7285',2250.00,0.00,0.00,3.00,360.00,'2023-01-05 07:18:34','',''),(7285,'1','285','1',1,'Retail Sale Id 7286',2302.50,0.00,0.00,3.07,368.40,'2023-01-05 07:22:02','',''),(7286,'1','285','1',1,'Retail Sale Id 7287',11450.30,0.00,0.00,17.09,683.60,'2023-01-05 07:23:23','',''),(7287,'1','285','1',1,'Retail Sale Id 7288',41821.40,0.00,0.00,62.42,2496.80,'2023-01-05 07:27:40','',''),(7288,'1','285','1',1,'Retail Sale Id 7289',997.50,0.00,0.00,1.33,159.60,'2023-01-05 07:36:46','',''),(7289,'1','285','1',1,'Retail Sale Id 7290',6997.50,0.00,0.00,9.33,1119.60,'2023-01-05 07:39:10','',''),(7290,'1','285','1',1,'Retail Sale Id 7291',3000.00,0.00,0.00,4.00,480.00,'2023-01-05 07:39:49','',''),(7291,'1','285','1',1,'Retail Sale Id 7292',1500.00,0.00,0.00,2.00,240.00,'2023-01-05 07:41:31','',''),(7292,'1','285','1',1,'Retail Sale Id 7293',1500.00,0.00,0.00,2.00,240.00,'2023-01-05 07:52:27','',''),(7293,'1','285','1',1,'Retail Sale Id 7294',2002.50,0.00,0.00,2.67,320.40,'2023-01-05 07:54:17','',''),(7294,'1','285','1',1,'Retail Sale Id 7295',1500.00,0.00,0.00,2.00,240.00,'2023-01-05 07:58:53','',''),(7295,'1','285','1',1,'Retail Sale Id 7296',1500.00,0.00,0.00,2.00,240.00,'2023-01-05 08:00:08','',''),(7296,'1','285','1',1,'Retail Sale Id 7297',3750.00,0.00,0.00,5.00,600.00,'2023-01-05 08:02:26','',''),(7297,'1','285','1',1,'Retail Sale Id 7298',997.50,0.00,0.00,1.33,159.60,'2023-01-05 08:03:25','',''),(7298,'1','285','1',1,'Retail Sale Id 7299',41674.00,0.00,0.00,62.20,2488.00,'2023-01-05 08:04:20','',''),(7299,'1','285','1',1,'Retail Sale Id 7300',750.00,0.00,0.00,1.00,120.00,'2023-01-05 08:07:31','',''),(7300,'1','285','1',1,'Retail Sale Id 7301',3750.00,0.00,0.00,5.00,600.00,'2023-01-05 08:08:27','',''),(7301,'1','285','1',1,'Retail Sale Id 7302',24120.00,0.00,0.00,36.00,1440.00,'2023-01-05 08:10:34','',''),(7302,'1','285','1',1,'Retail Sale Id 7303',5497.50,0.00,0.00,7.33,879.60,'2023-01-05 08:12:28','',''),(7303,'1','285','1',1,'Retail Sale Id 7304',53432.50,0.00,0.00,79.75,3190.00,'2023-01-05 08:13:53','',''),(7304,'1','285','1',1,'Retail Sale Id 7305',2002.50,0.00,0.00,2.67,320.40,'2023-01-05 08:16:34','',''),(7305,'1','285','1',1,'Retail Sale Id 7306',802.50,0.00,0.00,1.07,128.40,'2023-01-05 08:17:16','',''),(7306,'1','285','1',1,'Retail Sale Id 7307',42799.60,0.00,0.00,63.88,2555.20,'2023-01-05 08:24:34','',''),(7307,'1','285','1',1,'Retail Sale Id 7308',46900.00,0.00,0.00,70.00,2800.00,'2023-01-05 08:29:39','',''),(7308,'1','285','1',1,'Retail Sale Id 7309',19952.60,0.00,0.00,29.78,1191.20,'2023-01-05 08:33:13','',''),(7309,'1','285','1',1,'Retail Sale Id 7310',2002.50,0.00,0.00,2.67,320.40,'2023-01-05 08:34:51','',''),(7310,'1','285','1',1,'Retail Sale Id 7311',997.50,0.00,0.00,1.33,159.60,'2023-01-05 08:35:55','',''),(7311,'1','285','1',1,'Retail Sale Id 7312',23450.00,0.00,0.00,35.00,1400.00,'2023-01-05 08:40:36','',''),(7312,'1','285','1',1,'Return of Retail Sale Id 7312',0.00,23450.00,35.00,0.00,-1400.00,'2023-01-05 08:41:36','',''),(7313,'1','285','1',1,'Retail Sale Id 7313',26130.00,0.00,0.00,39.00,1560.00,'2023-01-05 08:42:47','',''),(7314,'1','285','1',1,'Retail Sale Id 7314',71629.70,0.00,0.00,106.91,4276.40,'2023-01-05 08:56:52','',''),(7315,'1','285','1',1,'Return of Retail Sale Id 7314',0.00,71629.70,106.91,0.00,-4276.40,'2023-01-05 08:58:16','',''),(7316,'1','285','1',1,'Retail Sale Id 7315',73639.70,0.00,0.00,109.91,4396.40,'2023-01-05 08:59:18','',''),(7317,'1','285','1',1,'Retail Sale Id 7316',2250.00,0.00,0.00,3.00,360.00,'2023-01-05 09:01:58','',''),(7318,'1','285','1',1,'Retail Sale Id 7317',3000.00,0.00,0.00,4.00,480.00,'2023-01-05 09:03:20','',''),(7319,'1','285','1',1,'Retail Sale Id 7318',3000.00,0.00,0.00,4.00,480.00,'2023-01-05 09:04:55','',''),(7320,'1','285','1',1,'Retail Sale Id 7319',359100.00,0.00,0.00,540.00,18900.00,'2023-01-05 09:07:51','',''),(7321,'1','285','1',1,'Retail Sale Id 7320',750.00,0.00,0.00,1.00,120.00,'2023-01-05 09:14:25','',''),(7322,'1','285','1',1,'Retail Sale Id 7321',1500.00,0.00,0.00,2.00,240.00,'2023-01-05 09:16:03','',''),(7323,'1','285','1',1,'Retail Sale Id 7322',90240.50,0.00,0.00,135.70,4749.50,'2023-01-05 09:24:40','',''),(7324,'1','285','1',1,'Retail Sale Id 7323',40200.00,0.00,0.00,60.00,2400.00,'2023-01-05 09:28:38','',''),(7325,'1','285','1',1,'Retail Sale Id 7324',1500.00,0.00,0.00,2.00,240.00,'2023-01-05 09:30:18','',''),(7326,'1','285','1',1,'Retail Sale Id 7325',40200.00,0.00,0.00,60.00,2400.00,'2023-01-05 09:32:25','',''),(7327,'1','285','1',1,'Retail Sale Id 7326',41124.60,0.00,0.00,61.38,2455.20,'2023-01-05 09:43:19','',''),(7328,'1','285','1',1,'Retail Sale Id 7327',1500.00,0.00,0.00,2.00,240.00,'2023-01-05 09:46:43','',''),(7329,'1','285','1',1,'Retail Sale Id 7328',40776.20,0.00,0.00,60.86,2434.40,'2023-01-05 09:51:56','',''),(7330,'1','285','1',1,'Retail Sale Id 7329',750.00,0.00,0.00,1.00,120.00,'2023-01-05 09:54:10','',''),(7331,'1','285','1',1,'Retail Sale Id 7330',100500.00,0.00,0.00,150.00,6000.00,'2023-01-05 10:01:36','',''),(7332,'1','285','1',1,'Retail Sale Id 7331',20770.00,0.00,0.00,31.00,1240.00,'2023-01-05 10:07:46','',''),(7333,'1','285','1',1,'Retail Sale Id 7332',645050.00,0.00,0.00,970.00,33950.00,'2023-01-05 10:21:27','',''),(7334,'1','285','1',1,'Retail Sale Id 7333',802.50,0.00,0.00,1.07,128.40,'2023-01-05 10:26:47','',''),(7335,'1','285','1',1,'Retail Sale Id 7334',41050.90,0.00,0.00,61.27,2450.80,'2023-01-05 10:29:44','',''),(7336,'1','285','1',1,'Retail Sale Id 7335',41158.10,0.00,0.00,61.43,2457.20,'2023-01-05 10:51:03','',''),(7337,'1','285','1',1,'Retail Sale Id 7336',1500.00,0.00,0.00,2.00,240.00,'2023-01-05 10:52:24','',''),(7338,'1','285','1',1,'Retail Sale Id 7337',45606.90,0.00,0.00,68.07,2722.80,'2023-01-05 10:54:10','',''),(7339,'1','285','1',1,'Retail Sale Id 7338',750.00,0.00,0.00,1.00,120.00,'2023-01-05 10:56:34','',''),(7340,'1','285','1',1,'Retail Sale Id 7339',802.50,0.00,0.00,1.07,128.40,'2023-01-05 11:02:05','',''),(7341,'1','285','1',1,'Retail Sale Id 7340',2002.50,0.00,0.00,2.67,320.40,'2023-01-05 11:03:00','',''),(7342,'1','285','1',1,'Retail Sale Id 7341',30150.00,0.00,0.00,45.00,1800.00,'2023-01-05 11:05:20','',''),(7343,'1','285','1',1,'Retail Sale Id 7342',2250.00,0.00,0.00,3.00,360.00,'2023-01-05 11:07:47','',''),(7344,'1','285','1',1,'Retail Sale Id 7343',1500.00,0.00,0.00,2.00,240.00,'2023-01-05 11:08:47','',''),(7345,'1','285','1',1,'Retail Sale Id 7344',177555.00,0.00,0.00,267.00,9345.00,'2023-01-05 11:16:47','',''),(7346,'1','285','1',1,'Retail Sale Id 7345',4275.00,0.00,0.00,5.70,684.00,'2023-01-05 11:20:36','',''),(7347,'1','285','1',1,'Retail Sale Id 7346',5422.50,0.00,0.00,7.23,867.60,'2023-01-05 11:21:24','',''),(7348,'1','285','1',1,'Retail Sale Id 7347',10096.90,0.00,0.00,15.07,602.80,'2023-01-05 11:23:54','',''),(7349,'1','285','1',1,'Retail Sale Id 7348',1500.00,0.00,0.00,2.00,240.00,'2023-01-05 11:25:03','',''),(7350,'1','285','1',1,'Retail Sale Id 7349',40200.00,0.00,0.00,60.00,2400.00,'2023-01-05 11:41:46','',''),(7351,'1','285','1',1,'Retail Sale Id 7350',20100.00,0.00,0.00,30.00,1200.00,'2023-01-05 11:56:44','',''),(7352,'1','285','1',1,'Retail Sale Id 7351',53921.60,0.00,0.00,80.48,3219.20,'2023-01-05 12:05:51','',''),(7353,'1','285','1',1,'Retail Sale Id 7352',85096.70,0.00,0.00,127.01,5080.40,'2023-01-05 12:42:50','',''),(7354,'1','285','1',1,'Retail Sale Id 7353',6000.00,0.00,0.00,8.00,960.00,'2023-01-05 12:47:57','',''),(7355,'1','285','1',1,'Retail Sale Id 7354',98195.20,0.00,0.00,146.56,5862.40,'2023-01-05 12:51:12','',''),(7356,'1','285',