-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_281
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_281`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_281` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_281`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,7000,'',0,'20','1','281','SALES','','2022-08-18 11:31:25',5,0.00,0.00,'','178','2022-08-18 11:31:25','178',0,0),(2,500,'',0,'6.1','1','281','CASH','','2022-08-18 11:31:43',5,0.00,0.00,'','178','2022-08-18 11:31:43','178',0,0),(3,8000,'',0,'24','1','281','SALARIES','','2022-08-18 11:32:09',5,0.00,0.00,'','178','2022-08-18 11:32:09','178',0,0),(4,8001,'',0,'24','1','281','PURCHASES','','2022-08-18 11:33:23',5,0.00,0.00,'','178','2022-08-18 11:33:23','178',0,0),(5,1500,'',0,'5','1','281','INVENTORY VALUE ADJUSTMENT','','2022-08-18 11:33:43',5,0.00,0.00,'','178','2022-08-18 11:33:43','178',0,0),(6,8002,'',0,'24','1','281','AGO CONSUMPTION','','2022-08-18 11:34:06',5,0.00,0.00,'','178','2022-08-18 11:34:06','178',0,0),(7,2500,'',0,'2','1','281','RETAIL OPERATING EXPENSES','','2022-08-18 11:34:49',5,0.00,0.00,'','178','2022-08-18 11:34:49','178',0,0),(8,2501,'',0,'2','1','281','UBA SHAGAMU ACC','','2022-08-18 15:11:23',5,0.00,0.00,'','634','2022-08-18 15:11:23','634',0,0),(9,2502,'',0,'2','1','281','GT POS','','2022-08-18 15:11:41',5,0.00,0.00,'','634','2022-08-18 15:11:41','634',0,0),(10,2503,'',0,'2','1','281','ECO POS','','2022-08-18 15:11:51',5,0.00,0.00,'','634','2022-08-18 15:11:51','634',0,0),(11,2504,'',0,'2','1','281','KEYSTONE POS','','2022-08-18 15:12:04',5,0.00,0.00,'','634','2022-08-18 15:12:04','634',0,0),(12,2505,'',0,'2','1','281','SURPLUS KEYSTONE','','2022-08-18 15:12:15',5,0.00,0.00,'','634','2022-08-18 15:12:15','634',0,0),(13,2506,'',0,'2','1','281','FIDELITY POS','','2022-08-18 15:12:28',5,0.00,0.00,'','634','2022-08-18 15:12:28','634',0,0),(14,2507,'',0,'2','1','281','UBA POS','','2022-08-18 15:12:38',5,0.00,0.00,'','634','2022-08-18 15:12:38','634',0,0),(15,2508,'',0,'2','1','281','ZEN TRANSFER ACC','','2022-08-18 15:12:48',5,0.00,0.00,'','634','2022-08-18 15:12:48','634',0,0),(16,8003,'',0,'24','1','281','IMPRESS','','2022-08-18 15:13:36',5,0.00,0.00,'','634','2022-08-18 15:13:36','634',0,0),(17,8004,'',0,'24','1','281','PUMP AND GENERATOR REPAIRS','','2022-08-18 15:14:23',5,0.00,0.00,'','634','2022-08-18 15:14:23','634',0,0),(18,8005,'',0,'24','1','281','STATIONARIES','','2022-08-18 15:14:48',5,0.00,0.00,'','634','2022-08-18 15:14:48','634',0,0),(19,8006,'',0,'24','1','281','ELECTRICITY AND WATER BILLS','','2022-08-18 15:15:03',5,0.00,0.00,'','634','2022-08-18 15:15:03','634',0,0),(20,8007,'',0,'24','1','281','STATION MAINTENANCE','','2022-08-18 15:15:14',5,0.00,0.00,'','634','2022-08-18 15:15:14','634',0,0),(21,8008,'',0,'24','1','281','FUELING OF OFFICIAL CAR','','2022-08-18 15:15:38',5,0.00,0.00,'','634','2022-08-18 15:15:38','634',0,0),(22,8009,'',0,'24','1','281','COMPUTER SUBSCRIPTION','','2022-08-18 15:15:52',5,0.00,0.00,'','634','2022-08-18 15:15:52','634',0,0),(23,8010,'',0,'24','1','281','DISCOUNT','','2022-08-18 15:16:00',5,0.00,0.00,'','634','2022-08-18 15:16:00','634',0,0),(24,8011,'',0,'24','1','281','PUBLIC RELATIONS','','2022-08-18 15:17:39',5,0.00,0.00,'','634','2022-08-18 15:17:39','634',0,0),(25,8012,'',0,'24','1','281','CLEANING AND SANITARY','','2022-08-18 15:17:57',5,0.00,0.00,'','634','2022-08-18 15:17:57','634',0,0),(26,8013,'',0,'24','1','281','OTHER OPERATING EXPENSES','','2022-08-18 15:18:17',5,0.00,0.00,'','634','2022-08-18 15:18:17','634',0,0),(27,8014,'',0,'24','1','281','FINE, FEES & DUES','','2022-08-18 15:18:35',5,0.00,0.00,'','634','2022-08-18 15:18:35','634',0,0),(28,8015,'',0,'24','1','281','TRANSPORT FARE','','2022-08-18 15:18:48',5,0.00,0.00,'','634','2022-08-18 15:18:48','634',0,0),(29,8016,'',0,'24','1','281','WEIGHT AND MEASURE','','2022-08-18 15:19:01',5,0.00,0.00,'','634','2022-08-18 15:19:01','634',0,0),(30,8017,'',0,'24','1','281','MEDICAL EXPENSES','','2022-08-18 15:19:19',5,0.00,0.00,'','634','2022-08-18 15:19:19','634',0,0),(31,2509,'',0,'2','1','281','ZENITH BANK 1011060801','','2022-12-20 11:51:07',5,0.00,0.00,'','634','2022-12-20 11:51:07','634',0,0),(32,2510,'',0,'2','1','281','MONIEPOINT POS','','2023-03-16 11:12:20',5,0.00,0.00,'','634','2023-03-16 11:12:20','634',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (1,'1','281','0000-00-00','2022-11-21 10:48:26',10,'634','','0000-00-00 00:00:00','634','2022-11-21 10:51:01'),(2,'1','281','0000-00-00','2022-12-24 13:57:30',10,'634','','0000-00-00 00:00:00','634','2022-12-24 14:11:02'),(3,'1','281','0000-00-00','2022-12-24 14:04:57',10,'634','','0000-00-00 00:00:00','634','2022-12-24 14:11:02'),(4,'1','281','0000-00-00','2022-12-24 14:09:53',10,'634','','0000-00-00 00:00:00','634','2022-12-24 14:11:02'),(5,'1','281','0000-00-00','2023-02-06 16:36:08',10,'634','','0000-00-00 00:00:00','634','2023-02-06 16:38:56');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (1,'1','281','1','2','customer',0.00,'CREDIT SALES ON 19TH MORNING',1000000.00,'2022-11-19'),(2,'1','281','1','1','20',1000000.00,'CREDIT SALES ON 19TH MORNING',0.00,'2022-11-19'),(3,'1','281','2','5','customer',0.00,'Credit Sales for 3,000 Litres of Diesel from shift 253 on 2022-12-16 07:50:12',2640000.00,'2022-12-16'),(4,'1','281','2','2','6.1',2640000.00,'Credit Sales for 3,000 Litres of Diesel from shift 253 on 2022-12-16 07:50:12',0.00,'2022-12-16'),(5,'1','281','3','5','customer',0.00,'Credit Sales for 10,467.29 Litres of Petrol from shift 260 on 2022-12-20 13:51:32',1936448.65,'2022-12-20'),(6,'1','281','3','2','6.1',1936448.65,'Credit Sales for 10,467.29 Litres of Petrol from shift 260 on 2022-12-20 13:51:32',0.00,'2022-12-20'),(7,'1','281','4','5','customer',0.00,'Credit Sales for 13930.28 Litres of Petrol from shift 261 on 2022-12-21 13:51:32',2577101.80,'2022-12-21'),(8,'1','281','4','2','6.1',2577101.80,'Credit Sales for 13930.28 Litres of Petrol from shift 261 on 2022-12-21 13:51:32',0.00,'2022-12-21'),(9,'1','281','5','12','customer',0.00,'MISSING ENTRY OF PMS',301538.00,'2023-02-02'),(10,'1','281','5','1','20',301538.00,'MISSING ENTRY OF PMS',0.00,'2023-02-02');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','1','281','RICKMEN HEALTHCARE LTD','MR. ALIYU IBRAHIM','08060440024','aliyuibrahim83@yahoo.com','KADUNA ','KADUNA STATE','PLOT 2 OAD C COMMAND JUNCTION','Nigeria',205000.00,0.00,0.00,'0000-00-00','2022-08-30 14:45:45',5,'634','2022-11-01 14:30:23','634'),(2,'','1','281','BRASS CONSTRUCTION LTD','ENG. ANAS','0808575976','brassconst@gmail.com','KADUNA ','KADUNA STATE','Kaduna State','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-30 11:46:31',5,'634','2022-10-06 09:03:44','634'),(3,'','1','281','NIZAM PETROLEUM LTD','Manager','08065506293','adamabdulsarki@gmail.com','Kaduna ','Kaduna','Kaduna','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-01 06:30:57',5,'634','2022-10-15 10:26:46','634'),(4,'','1','281','CROC CITY SHUTTLE LTD','MRS OTATADE TAGWOI','08149604664','croccityshuttle64@gmail.com','KADUNA ','KADUNA STATE','GF 06 Mallis Plaza, Patrick Idewo road','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-07 15:29:50',5,'634','2022-11-19 15:22:15','634'),(5,'','1','281','SETRACO NIGERIA LIMITED','ENGR. MUSTAPHA JAAFAR','07064048067','adamabdulsarki@gmail.com','KADUNA','KADUNA','KADUNA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-19 17:21:09',5,'634','2022-12-19 17:21:09','634'),(6,'','1','281','DRIVER SHORTAGE','AA RANO TRANSPORT','08030000000','info@aaranonigeria.com','KANO','KANO','KANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-27 11:27:11',5,'634','2022-12-27 11:27:11','634'),(7,'','1','281','CHIKEM NIG VENTURES','CHARLES AKEM','08035850373','charlesjunwa@gmail.com','KADUNA','KADUNA STATE','BARNAWA KADUNA ','Nigeria',100.00,0.00,0.00,'0000-00-00','2023-01-23 12:13:56',5,'634','2023-01-23 12:13:56','634'),(8,'','1','281','OCP AFRICA','ABIGAIL SHEKWODUZA','09139368917','a.shekwoduza@ocpafrica.com','KADUNA ','KADUNA STATE','ABUJA-KADUNA HIGHWAY','Nigeria',100.00,0.00,0.00,'0000-00-00','2023-01-23 12:15:23',5,'634','2023-01-23 12:15:23','634'),(9,'','1','281','WORLDWIDE GLORY MODEL SCH','GLORIA GODWIN OKPE','08035734081','glorymodelschools@gmail.com','KADUNA ','KADUNA STATE','KUARAN GBAGYI ROAD, MAHUTA','Nigeria',100.00,0.00,0.00,'0000-00-00','2023-01-23 12:16:42',5,'634','2023-01-23 12:16:42','634'),(10,'','1','281','FOCUS ACADEMY K/WEST','SHERIFAT BOLA','08029027343','sherifatbola@gmail.com','KADUNA ','KADUNA STATE','KADUNA','Nigeria',100.00,0.00,0.00,'0000-00-00','2023-01-23 12:17:53',5,'634','2023-01-23 12:17:53','634'),(11,'','1','281','TOMATO JOS FARMING & PROCESSIN','ART CARDOSO','09027444553','art@tomatojos.net','KADUNA ','KADUNA STATE','KANGIMI VILLAGE, IGABI LGA KADUNA','Nigeria',100.00,0.00,0.00,'0000-00-00','2023-01-23 12:19:08',5,'634','2023-01-23 12:19:08','634'),(12,'','1','281','COL. HUSSAINI RABIU TORO','SSGT ABDULLAHI MOHAMMED','08063124969','hrtoro49@gmail.com','KADUNA','KADUNA STATE','HQ SECTOR 4 OPWP KADUNA-ABUJA HIGHWAY','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-26 15:48:47',5,'634','2023-01-26 15:48:47','634'),(13,'','1','281','NIGERIA POLICE FORCE (ELECTION','YUSUF C USMAN','08071785115','dopstransport@gmail.com','KADUNA STATE','KADUNA STATE','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-20 15:05:32',5,'634','2023-02-20 15:05:32','634'),(14,'','1','281','KADWEL INTERNATIONAL SCHOOLS','MR. GENESIS IYAJI','07037719388','kadwelinternationalschools@gma','KADUNA','KADUNA STATE','BARNAWA GRA','Nigeria',300000.00,0.00,0.00,'0000-00-00','2023-02-21 14:07:21',5,'634','2023-03-11 08:59:47','634'),(15,'','1','281','KADUNA LINE','AUGUSTINE','07013935407','augustine.ogar@kdsg.gov.ng','KADUNA STATE','KADUNA STATE','KADUNA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-28 16:45:49',5,'634','2023-03-01 07:15:31','634');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','281',1,'2',11664.39,13300.00,'2022-08-24','For Shift to close','2022-08-24 15:03:38','559','559',2022,'559','2022-08-24 15:03:38',5),('1','281',2,'2',13300.00,14000.00,'2022-08-24','','2022-08-24 16:17:44','634','634',2022,'634','2022-08-24 16:17:44',5),('1','281',3,'1',2351.89,7000.00,'2022-08-24','','2022-08-24 16:32:17','634','634',2022,'634','2022-08-24 16:32:17',5),('1','281',4,'1',11888.09,17000.00,'2022-08-29','','2022-08-29 14:17:59','634','634',2022,'634','2022-08-29 14:17:59',5),('1','281',5,'1',17000.00,17000.00,'2022-08-29','','2022-08-29 14:18:06','634','634',2022,'634','2022-08-29 14:18:06',5),('1','281',6,'1',17000.00,17000.00,'2022-08-29','','2022-08-29 14:18:14','634','634',2022,'634','2022-08-29 14:18:14',5),('1','281',7,'1',17000.00,17000.00,'2022-08-29','','2022-08-29 14:18:15','634','634',2022,'634','2022-08-29 14:18:15',5),('1','281',8,'2',27306.23,30000.00,'2022-08-29','','2022-08-29 14:19:42','634','634',2022,'634','2022-08-29 14:19:42',5),('1','281',9,'1',3322.13,15099.00,'2022-09-10','','2022-09-10 14:58:01','634','634',2022,'634','2022-09-10 14:58:01',5),('1','281',10,'3',1352.69,2000.00,'2022-09-16','','2022-09-16 17:21:53','634','634',2022,'634','2022-09-16 17:21:53',5),('1','281',11,'3',316.70,1000.00,'2022-09-17','','2022-09-17 08:23:35','634','634',2022,'634','2022-09-17 08:23:35',5),('1','281',12,'3',2735.93,3200.00,'2022-10-06','For Shift to close','2022-10-06 14:46:26','559','559',2022,'559','2022-10-06 14:46:26',5),('1','281',13,'3',3465.90,3900.00,'2022-10-19','For Shift to close','2022-10-19 14:10:40','559','559',2022,'559','2022-10-19 14:10:40',5),('1','281',14,'1',38386.09,42000.00,'2022-10-27','','2022-10-27 15:14:01','634','634',2022,'634','2022-10-27 15:14:01',5),('1','281',15,'2',31333.17,42000.00,'2022-10-27','','2022-10-27 15:14:16','634','634',2022,'634','2022-10-27 15:14:16',5),('1','281',16,'3',990.91,3000.00,'2022-11-11','','2022-11-11 09:48:56','634','634',2022,'634','2022-11-11 09:48:56',5),('1','281',17,'3',563.56,2000.00,'2023-01-27','','2023-01-27 15:39:10','634','634',2023,'634','2023-01-27 15:39:10',5),('1','281',18,'3',832.13,2500.00,'2023-01-27','For Shift to close','2023-01-28 10:31:08','559','559',2023,'559','2023-01-28 10:31:08',5),('1','281',19,'1',38181.33,2000.00,'2023-01-28','','2023-01-28 13:15:41','634','634',2023,'634','2023-01-28 13:15:41',5),('1','281',20,'2',14950.99,1500.00,'2023-01-28','','2023-01-28 13:15:58','634','634',2023,'634','2023-01-28 13:15:58',5),('1','281',21,'1',2000.00,600.00,'2023-01-28','','2023-01-28 13:17:00','634','634',2023,'634','2023-01-28 13:17:00',5),('1','281',22,'2',1500.00,300.00,'2023-01-28','','2023-01-28 13:17:13','634','634',2023,'634','2023-01-28 13:17:13',5),('1','281',23,'3',1525.80,300.00,'2023-01-28','','2023-01-28 13:17:50','634','634',2023,'634','2023-01-28 13:17:50',5),('1','281',24,'3',4597.93,4990.00,'2023-02-02','','2023-02-02 09:30:04','634','634',2023,'634','2023-02-02 09:30:04',5),('1','281',25,'1',17300.00,8500.00,'2023-02-03','','2023-02-03 09:53:00','634','634',2023,'634','2023-02-03 09:53:00',5),('1','281',26,'2',300.00,8700.00,'2023-02-03','','2023-02-03 09:53:19','634','634',2023,'634','2023-02-03 09:53:19',5),('1','281',27,'2',8700.00,4500.00,'2023-02-03','','2023-02-03 10:50:44','634','634',2023,'634','2023-02-03 10:50:44',5),('1','281',28,'1',8500.00,12700.00,'2023-02-03','','2023-02-03 10:51:08','634','634',2023,'634','2023-02-03 10:51:08',5),('1','281',29,'2',21670.56,22300.00,'2023-02-06','','2023-02-06 08:49:23','634','634',2023,'634','2023-02-06 08:49:23',5),('1','281',30,'1',1911.66,3000.00,'2023-02-06','','2023-02-06 09:18:55','634','634',2023,'634','2023-02-06 09:18:55',5),('1','281',31,'2',22300.00,25000.00,'2023-02-06','','2023-02-06 09:19:09','634','634',2023,'634','2023-02-06 09:19:09',5),('1','281',32,'1',3000.00,6000.00,'2023-02-06','','2023-02-06 10:57:41','634','634',2023,'634','2023-02-06 10:57:41',5),('1','281',33,'1',6000.00,8500.00,'2023-02-06','','2023-02-06 11:02:28','634','634',2023,'634','2023-02-06 11:02:28',5),('1','281',34,'2',20535.07,40000.00,'2023-02-22','','2023-02-22 08:47:19','634','634',2023,'634','2023-02-22 08:47:19',5),('1','281',35,'2',33221.99,41000.00,'2023-02-25','','2023-02-25 15:16:38','634','634',2023,'634','2023-02-25 15:16:38',5),('1','281',36,'1',45537.40,4950.00,'2023-02-25','','2023-02-25 15:31:10','634','634',2023,'634','2023-02-25 15:31:10',5),('1','281',37,'1',4950.00,49500.00,'2023-02-25','','2023-02-25 15:31:27','634','634',2023,'634','2023-02-25 15:31:27',5),('1','281',38,'2',41000.00,49500.00,'2023-02-25','','2023-02-25 15:31:46','634','634',2023,'634','2023-02-25 15:31:46',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','281','1',1,'5','PUMP 1',463076.99,'DISPENSING PMS','',NULL,NULL,'',5,'2022-08-18 11:24:27','178'),('1','281','1',2,'5','PUMP 2',626439.54,'DISPENSING PMS','',NULL,NULL,'',5,'2022-08-18 11:24:49','178'),('1','281','1',3,'5','PUMP 5',359262.78,'DISPENSING PMS','',NULL,NULL,'',5,'2022-08-18 11:25:10','178'),('1','281','1',4,'5','PUMP 6',523770.64,'DISPENSING PMS','',NULL,NULL,'',5,'2022-08-18 11:25:31','178'),('1','281','1',5,'5','PUMP 9',486662.22,'DISPENSING PMS','',NULL,NULL,'',5,'2022-08-18 11:25:52','178'),('1','281','1',6,'5','PUMP 10',618922.43,'DISPENSING PMS','',NULL,NULL,'',5,'2022-08-18 11:26:14','178'),('1','281','2',7,'5','PUMP 3',154769.74,'DISPENSING PMS','',NULL,NULL,'',5,'2022-08-18 11:27:07','178'),('1','281','2',8,'5','PUMP 4',653371.31,'DISPENSING PMS','',NULL,NULL,'',5,'2022-08-18 11:27:30','178'),('1','281','2',9,'5','PUMP 7',443999.46,'DISPENSING PMS','',NULL,NULL,'',5,'2022-08-18 11:27:52','178'),('1','281','2',10,'5','PUMP 8',543805.83,'DISPENSING PMS','',NULL,NULL,'',5,'2022-08-18 11:28:19','178'),('1','281','2',11,'5','PUMP 11',450540.32,'DISPENSING PMS','',NULL,NULL,'',5,'2022-08-18 11:28:46','178'),('1','281','2',12,'5','PUMP 12',576898.66,'DISPENSING PMS','',NULL,NULL,'',5,'2022-08-18 11:29:11','178'),('1','281','3',13,'5','AGO PUMP 1',335752.12,'DISPENSING AGO','',NULL,NULL,'',5,'2022-08-18 11:30:08','178'),('1','281','3',14,'5','AGO PUMP 2',83691.61,'DISPENSING AGO','',NULL,NULL,'',5,'2022-08-18 11:30:32','178');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=386 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','281',1,'Morning/Afternoon','2022-07-31','2022-08-19 16:57:30','2022-08-20 16:57:30','943',5484003.10,5484003.10,'943','2022-08-19 17:09:36','634','2022-08-19 17:17:30',10,0),('1','281',2,'Morning/Afternoon','2022-08-01','2022-08-19 17:27:22','2022-08-20 17:27:22','943',11714022.40,11714022.40,'943','2022-08-19 17:47:34','634','2022-08-19 18:08:09',10,0),('1','281',3,'Morning/Afternoon','2022-08-03','2022-08-20 10:21:36','2022-08-21 10:21:36','943',9238389.40,9238389.40,'943','2022-08-20 11:05:25','634','2022-08-20 11:15:15',10,0),('1','281',4,'Morning/Afternoon','2022-08-04','2022-08-20 11:19:39','2022-08-21 11:19:39','943',8304394.70,8304394.70,'943','2022-08-20 11:33:51','634','2022-08-20 11:35:39',10,0),('1','281',5,'Morning/Afternoon','2022-08-05','2022-08-20 12:08:46','2022-08-21 12:08:46','943',8374711.35,8374711.35,'943','2022-08-20 12:16:12','634','2022-08-20 12:18:05',10,0),('1','281',6,'Morning/Afternoon','2022-08-06','2022-08-20 12:39:48','2022-08-21 12:39:48','943',9144054.20,9144054.20,'943','2022-08-20 12:54:46','634','2022-08-20 13:32:08',10,0),('1','281',7,'Morning/Afternoon','2022-08-07','2022-08-20 13:50:40','2022-08-21 13:50:40','943',8766064.05,8766064.05,'943','2022-08-20 13:57:16','634','2022-08-20 14:01:51',10,0),('1','281',8,'Morning/Afternoon','2022-08-08','2022-08-20 14:21:01','2022-08-21 14:21:01','943',2456335.65,2456335.65,'943','2022-08-20 14:31:31','634','2022-08-20 14:33:44',10,0),('1','281',9,'Morning/Afternoon','2022-08-09','2022-08-20 14:40:11','2022-08-21 14:40:11','943',9230517.65,9230517.65,'943','2022-08-20 14:45:17','634','2022-08-20 14:57:52',10,0),('1','281',10,'Morning/Afternoon','2022-08-10','2022-08-20 14:59:03','2022-08-21 14:59:03','943',7535569.80,7535569.80,'943','2022-08-20 15:17:45','634','2022-08-20 15:34:55',10,0),('1','281',11,'Morning/Afternoon','2022-08-11','2022-08-20 15:37:10','2022-08-21 15:37:10','943',360806.40,360806.40,'943','2022-08-20 15:39:07','634','2022-08-20 16:12:18',10,0),('1','281',12,'Morning/Afternoon','2022-08-12','2022-08-20 16:34:35','2022-08-21 16:34:35','943',8761325.25,8761325.25,'943','2022-08-20 16:41:47','634','2022-08-20 17:15:36',10,0),('1','281',13,'Morning/Afternoon','2022-08-13','2022-08-21 06:30:06','2022-08-22 06:30:06','943',8916760.60,8916760.60,'943','2022-08-21 06:38:41','559','2022-08-21 09:19:03',10,0),('1','281',14,'Morning/Afternoon','2022-08-14','2022-08-21 09:36:08','2022-08-22 09:36:08','943',5629038.15,5629038.15,'943','2022-08-21 09:43:15','559','2022-08-21 09:43:53',10,0),('1','281',15,'Morning/Afternoon','2022-08-15','2022-08-21 10:01:18','2022-08-22 10:01:18','943',236592.90,236592.90,'943','2022-08-21 10:03:33','559','2022-08-21 10:04:41',10,0),('1','281',16,'Morning/Afternoon','2022-08-16','2022-08-21 10:11:16','2022-08-22 10:11:16','943',8595566.30,8595566.30,'943','2022-08-21 10:16:09','559','2022-08-21 10:18:35',10,0),('1','281',17,'Morning/Afternoon','2022-08-17','2022-08-21 10:37:12','2022-08-22 10:37:12','943',4630388.50,4630388.50,'943','2022-08-21 10:41:50','559','2022-08-21 10:42:50',10,0),('1','281',18,'Morning/Afternoon','2022-08-18','2022-08-21 10:55:18','2022-08-22 10:55:18','943',0.00,0.00,'943','2022-08-21 11:09:53','559','2022-08-21 11:10:33',10,0),('1','281',19,'Morning/Afternoon','2022-08-18','2022-08-21 11:19:18','2022-08-22 11:19:18','943',10298721.80,10298721.80,'943','2022-08-21 11:26:06','559','2022-08-21 11:26:50',10,0),('1','281',20,'Morning/Afternoon','2022-08-19','2022-08-21 11:51:03','2022-08-22 11:51:03','943',9224432.60,9224432.60,'943','2022-08-21 11:57:34','559','2022-08-21 11:58:36',10,0),('1','281',21,'Morning/Afternoon','2022-08-20','2022-08-21 12:17:25','2022-08-22 12:17:25','943',8489176.90,8489176.90,'943','2022-08-21 12:32:47','559','2022-08-21 12:34:38',10,0),('1','281',22,'Morning/Afternoon','2022-08-21','2022-08-21 15:21:27','2022-08-22 15:21:27','943',8330492.25,8330492.25,'943','2022-08-22 06:08:20','559','2022-08-22 07:51:13',10,0),('1','281',23,'Morning shift','2022-08-22','2022-08-22 08:12:23','2022-08-23 08:12:23','943',4597251.70,4597251.70,'943','2022-08-22 14:57:04','559','2022-08-22 15:00:56',10,0),('1','281',24,'Afternoon shift','2022-08-22','2022-08-22 22:11:51','2022-08-23 22:11:51','943',4353756.00,4353756.00,'943','2022-08-23 06:30:06','559','2022-08-23 07:19:41',10,0),('1','281',25,'Morning shift','2022-08-23','2022-08-23 11:43:33','2022-08-24 11:43:33','943',4803859.50,4803859.50,'943','2022-08-23 18:17:26','559','2022-08-23 18:21:49',10,0),('1','281',26,'Afternoon shift','2022-08-23','2022-08-23 18:28:08','2022-08-24 18:28:08','943',4258845.25,4258845.25,'943','2022-08-24 07:18:28','559','2022-08-24 08:14:01',10,0),('1','281',27,'Morning shift','2022-08-24','2022-08-24 11:55:41','2022-08-25 11:55:41','943',2500609.30,2500609.30,'943','2022-08-24 16:32:22','559','2022-08-24 16:43:36',10,0),('1','281',28,'Afternoon shift','2022-08-24','2022-08-24 18:12:32','2022-08-25 18:12:32','943',2126612.80,2126612.80,'943','2022-08-25 05:59:36','559','2022-08-25 08:01:28',10,0),('1','281',29,'Morning shift','2022-08-25','2022-08-25 12:09:45','2022-08-26 12:09:45','943',4321816.20,4321816.20,'943','2022-08-25 14:29:36','559','2022-08-25 14:57:11',10,0),('1','281',30,'Afternoon shift','2022-08-25','2022-08-25 19:56:04','2022-08-26 19:56:04','943',4279898.00,4279898.00,'943','2022-08-26 06:43:03','559','2022-08-26 07:35:51',10,0),('1','281',31,'Morning shift','2022-08-26','2022-08-26 14:51:17','2022-08-27 14:51:17','943',4541531.30,4541531.30,'943','2022-08-26 14:58:38','559','2022-08-26 16:22:59',10,0),('1','281',32,'Afternoon shift','2022-08-26','2022-08-26 18:40:58','2022-08-27 18:40:58','943',3503958.40,3503958.40,'943','2022-08-27 06:01:09','559','2022-08-27 07:44:53',10,0),('1','281',33,'Morning shift','2022-08-27','2022-08-27 09:31:02','2022-08-28 09:31:02','943',4227570.15,4227570.15,'943','2022-08-27 15:05:00','559','2022-08-27 15:17:30',10,0),('1','281',34,'Afternoon shift','2022-08-27','2022-08-27 20:20:56','2022-08-28 20:20:56','943',4472696.15,4472696.15,'943','2022-08-27 22:44:26','559','2022-08-28 07:41:07',10,0),('1','281',35,'Morning shift','2022-08-28','2022-08-28 15:32:15','2022-08-29 15:32:15','943',3503237.00,3503237.00,'943','2022-08-28 15:38:14','559','2022-08-28 18:27:45',10,0),('1','281',36,'Afternoon shift','2022-08-28','2022-08-28 19:53:48','2022-08-29 19:53:48','943',4003441.50,4003441.50,'943','2022-08-28 20:11:28','559','2022-08-29 07:48:47',10,0),('1','281',37,'Morning shift','2022-08-29','2022-08-29 08:24:17','2022-08-30 08:24:17','943',4677440.30,4677440.30,'943','2022-08-29 14:27:57','559','2022-08-29 14:30:58',10,0),('1','281',38,'Afternoon shift','2022-08-29','2022-08-29 17:14:34','2022-08-30 17:14:34','943',2400723.55,2400723.55,'943','2022-08-29 20:40:20','559','2022-08-30 07:24:59',10,0),('1','281',39,'Morning shift','2022-08-30','2022-08-30 07:51:07','2022-08-31 07:51:07','943',4521625.30,4521625.30,'943','2022-08-30 14:54:06','559','2022-08-30 15:15:56',10,0),('1','281',40,'Afternoon shift','2022-08-30','2022-08-30 17:48:36','2022-08-31 17:48:36','943',3477306.20,3477306.20,'943','2022-08-30 20:42:02','559','2022-08-31 07:33:20',10,0),('1','281',41,'Morning shift','2022-08-31','2022-08-31 07:53:38','2022-09-01 07:53:38','943',5564750.75,5564750.75,'943','2022-08-31 15:20:57','559','2022-08-31 19:52:18',10,0),('1','281',42,'Afternoon shift','2022-08-31','2022-08-31 19:59:16','2022-09-01 19:59:16','943',3305547.10,3305547.10,'943','2022-09-01 06:45:23','559','2022-09-01 07:34:27',10,0),('1','281',43,'Morning shift','2022-09-01','2022-09-01 11:33:54','2022-09-02 11:33:54','943',5647024.35,5647024.35,'943','2022-09-01 14:58:44','559','2022-09-01 15:46:49',10,0),('1','281',44,'Afternoon shift','2022-09-01','2022-09-01 18:52:20','2022-09-02 18:52:20','943',3805383.95,3805383.95,'943','2022-09-02 05:52:02','559','2022-09-02 07:38:43',10,0),('1','281',45,'Morning shift','2022-09-02','2022-09-02 09:32:14','2022-09-03 09:32:14','943',6414424.35,6414424.35,'943','2022-09-02 14:46:28','559','2022-09-02 15:11:29',10,0),('1','281',46,'Afternoon shift','2022-09-02','2022-09-02 17:26:56','2022-09-03 17:26:56','943',4148840.65,4148840.65,'943','2022-09-03 07:32:02','559','2022-09-03 07:59:24',10,0),('1','281',47,'Morning shift','2022-09-03','2022-09-03 08:33:51','2022-09-04 08:33:51','943',4171927.05,4171927.05,'943','2022-09-03 14:52:19','559','2022-09-03 17:12:01',10,0),('1','281',48,'Afternoon shift','2022-09-03','2022-09-03 19:03:18','2022-09-04 19:03:18','943',4665340.95,4665340.95,'943','2022-09-04 07:30:33','559','2022-09-04 07:32:52',10,0),('1','281',49,'Morning shift','2022-09-04','2022-09-04 10:36:58','2022-09-05 10:36:58','943',4409571.10,4409571.10,'943','2022-09-04 14:20:37','559','2022-09-04 15:04:43',10,0),('1','281',50,'Afternoon shift','2022-09-04','2022-09-04 18:23:03','2022-09-05 18:23:03','943',4494901.65,4494901.65,'943','2022-09-05 06:24:39','559','2022-09-05 08:06:58',10,0),('1','281',51,'Morning shift','2022-09-05','2022-09-05 15:23:45','2022-09-06 15:23:45','943',4811017.25,4811017.25,'943','2022-09-05 15:36:33','559','2022-09-05 15:48:26',10,0),('1','281',52,'Afternoon shift','2022-09-05','2022-09-05 18:07:36','2022-09-06 18:07:36','943',5714008.25,5714008.25,'943','2022-09-05 23:02:31','559','2022-09-06 08:12:19',10,0),('1','281',53,'Morning shift','2022-09-06','2022-09-06 10:03:50','2022-09-07 10:03:50','943',4745320.55,4745320.55,'943','2022-09-06 14:47:21','559','2022-09-06 14:59:28',10,0),('1','281',54,'Morning shift','2022-09-06','2022-09-06 16:35:47','2022-09-07 16:35:47','943',6067073.00,6067073.00,'943','2022-09-07 05:53:00','559','2022-09-07 06:12:26',10,0),('1','281',55,'Morning shift','2022-09-07','2022-09-07 09:54:53','2022-09-08 09:54:53','943',4386559.80,4386559.80,'943','2022-09-07 15:25:33','559','2022-09-07 17:45:01',10,0),('1','281',56,'Afternoon shift','2022-09-07','2022-09-07 20:13:16','2022-09-08 20:13:16','943',4850110.90,4850110.90,'943','2022-09-08 08:05:26','559','2022-09-08 08:21:41',10,0),('1','281',57,'Morning shift','2022-09-08','2022-09-08 14:22:32','2022-09-09 14:22:32','943',4201644.45,4201644.45,'943','2022-09-08 14:51:35','559','2022-09-08 14:53:05',10,0),('1','281',58,'Afternoon shift','2022-09-08','2022-09-08 19:37:49','2022-09-09 19:37:49','943',4227444.15,4227444.15,'943','2022-09-09 06:35:41','559','2022-09-09 08:19:44',10,0),('1','281',59,'Morning shift','2022-09-09','2022-09-09 09:11:31','2022-09-10 09:11:31','943',4804384.85,4804384.85,'943','2022-09-09 15:23:59','559','2022-09-09 19:21:41',10,0),('1','281',60,'Afternoon shift','2022-09-09','2022-09-09 20:00:49','2022-09-10 20:00:49','943',5517078.80,5517078.80,'943','2022-09-10 06:49:48','559','2022-09-10 07:48:57',10,0),('1','281',61,'Morning shift','2022-09-10','2022-09-10 11:59:44','2022-09-11 11:59:44','943',4335494.90,4335494.90,'943','2022-09-10 15:49:28','559','2022-09-10 18:29:32',10,0),('1','281',62,'Afternoon shift','2022-09-10','2022-09-10 19:49:19','2022-09-11 19:49:19','943',3714377.40,3714377.40,'943','2022-09-10 22:30:41','559','2022-09-11 07:51:00',10,0),('1','281',63,'Morning shift','2022-09-11','2022-09-11 11:19:28','2022-09-12 11:19:28','943',4844473.35,4844473.35,'943','2022-09-11 14:52:19','559','2022-09-11 14:54:15',10,0),('1','281',64,'Afternoon shift','2022-09-11','2022-09-11 18:24:43','2022-09-12 18:24:43','943',3575445.75,3575445.75,'943','2022-09-11 19:46:09','559','2022-09-11 20:49:07',10,0),('1','281',65,'Morning shift','2022-09-12','2022-09-12 14:15:25','2022-09-13 14:15:25','943',1776853.55,1776853.55,'943','2022-09-12 14:22:41','559','2022-09-12 15:09:13',10,0),('1','281',66,'Afternoon shift','2022-09-12','2022-09-12 16:26:43','2022-09-13 16:26:43','943',1862385.75,1862385.75,'943','2022-09-12 23:35:36','559','2022-09-13 08:13:40',10,0),('1','281',67,'Morning shift','2022-09-13','2022-09-13 10:08:58','2022-09-14 10:08:58','943',5149101.30,5149101.30,'943','2022-09-13 14:33:40','559','2022-09-13 15:25:56',10,0),('1','281',68,'Afternoon shift','2022-09-13','2022-09-13 17:10:37','2022-09-14 17:10:37','943',5602906.75,5602906.75,'943','2022-09-13 21:19:43','559','2022-09-14 08:07:30',10,0),('1','281',69,'Morning shift','2022-09-14','2022-09-14 08:18:10','2022-09-15 08:18:10','943',6118499.25,6118499.25,'943','2022-09-14 14:10:58','559','2022-09-14 15:05:26',10,0),('1','281',70,'Afternoon shift','2022-09-14','2022-09-14 19:21:35','2022-09-15 19:21:35','943',5466230.35,5466230.35,'943','2022-09-14 21:20:16','559','2022-09-15 08:22:48',10,0),('1','281',71,'Morning shift','2022-09-15','2022-09-15 09:00:57','2022-09-16 09:00:57','943',4155173.70,4155173.70,'943','2022-09-15 14:00:52','559','2022-09-15 15:22:45',10,0),('1','281',72,'Afternoon shift','2022-09-15','2022-09-15 18:26:47','2022-09-16 18:26:47','943',4302270.45,4302270.45,'943','2022-09-15 21:20:00','559','2022-09-15 21:26:13',10,0),('1','281',73,'Morning shift','2022-09-16','2022-09-16 09:48:59','2022-09-17 09:48:59','943',5746036.35,5746036.35,'943','2022-09-16 17:29:48','559','2022-09-16 17:34:49',10,0),('1','281',74,'Afternoon shift','2022-09-16','2022-09-16 23:22:05','2022-09-17 23:22:05','943',4482606.85,4482606.85,'943','2022-09-17 08:25:07','559','2022-09-17 08:29:58',10,0),('1','281',75,'Morning shift','2022-09-17','2022-09-17 08:30:53','2022-09-18 08:30:53','943',4198519.60,4198519.60,'943','2022-09-17 14:11:15','559','2022-09-17 14:21:55',10,0),('1','281',76,'Afternoon ','2022-09-17','2022-09-17 23:38:09','2022-09-18 23:38:09','943',5788221.50,5788221.50,'943','2022-09-17 23:46:12','559','2022-09-18 07:47:25',10,0),('1','281',77,'Morning shift','2022-09-18','2022-09-18 10:33:57','2022-09-19 10:33:57','943',3669908.85,3669908.85,'943','2022-09-18 14:31:27','559','2022-09-18 14:39:26',10,0),('1','281',78,'Afternoon shift','2022-09-18','2022-09-18 18:36:29','2022-09-19 18:36:29','943',3008053.80,3008053.80,'943','2022-09-18 23:06:01','559','2022-09-19 07:47:49',10,0),('1','281',79,'Morning shift','2022-09-19','2022-09-19 09:42:52','2022-09-20 09:42:52','943',4964772.80,4964772.80,'943','2022-09-19 14:07:51','559','2022-09-19 14:54:09',10,0),('1','281',80,'Afternoon shift','2022-09-19','2022-09-19 20:13:22','2022-09-20 20:13:22','943',3415788.95,3415788.95,'943','2022-09-19 23:15:52','559','2022-09-20 07:40:32',10,0),('1','281',81,'Morning shift','2022-09-20','2022-09-20 09:45:12','2022-09-21 09:45:12','943',4350586.75,4350586.75,'943','2022-09-20 14:36:32','559','2022-09-20 15:11:51',10,0),('1','281',82,'Afternoon shift','2022-09-20','2022-09-20 17:29:06','2022-09-21 17:29:06','943',3999558.70,3999558.70,'943','2022-09-20 23:21:09','559','2022-09-21 07:52:44',10,0),('1','281',83,'Morning shift','2022-09-21','2022-09-21 12:05:49','2022-09-22 12:05:49','943',4048910.15,4048910.15,'943','2022-09-21 13:55:55','559','2022-09-21 14:51:40',10,0),('1','281',84,'Afternoon shift','2022-09-21','2022-09-21 15:13:38','2022-09-22 15:13:38','943',4740767.70,4740767.70,'943','2022-09-21 21:26:03','559','2022-09-22 07:55:08',10,0),('1','281',85,'Morning shift','2022-09-22','2022-09-22 10:54:02','2022-09-23 10:54:02','943',4245834.90,4245834.90,'943','2022-09-22 14:01:07','559','2022-09-22 14:52:21',10,0),('1','281',86,'Afternoon shift','2022-09-22','2022-09-22 18:21:13','2022-09-23 18:21:13','943',4633411.40,4633411.40,'943','2022-09-23 06:32:26','559','2022-09-23 07:56:07',10,0),('1','281',87,'Morning shift','2022-09-23','2022-09-23 11:23:38','2022-09-24 11:23:38','943',4439647.60,4439647.60,'943','2022-09-23 14:22:04','559','2022-09-23 16:15:56',10,0),('1','281',88,'Afternoon shift','2022-09-23','2022-09-23 21:17:40','2022-09-24 21:17:40','943',5242132.35,5242132.35,'943','2022-09-23 21:25:31','559','2022-09-24 08:02:10',10,0),('1','281',89,'Morning shift','2022-09-24','2022-09-24 08:05:17','2022-09-25 08:05:17','943',5030942.60,5030942.60,'943','2022-09-24 13:34:44','559','2022-09-24 14:37:34',10,0),('1','281',90,'Afternoon shift','2022-09-24','2022-09-24 21:14:14','2022-09-25 21:14:14','943',3595567.90,3595567.90,'943','2022-09-24 21:26:17','559','2022-09-25 08:26:36',10,0),('1','281',91,'Morning shift','2022-09-25','2022-09-25 09:04:56','2022-09-26 09:04:56','943',3273368.00,3273368.00,'943','2022-09-25 14:14:10','559','2022-09-25 15:11:42',10,0),('1','281',92,'Afternoon shift','2022-09-25','2022-09-25 18:55:50','2022-09-26 18:55:50','943',3464256.35,3464256.35,'943','2022-09-25 20:06:18','559','2022-09-26 07:52:12',10,0),('1','281',93,'Morning shift','2022-09-26','2022-09-26 13:27:54','2022-09-27 13:27:54','943',4473705.45,4473705.45,'943','2022-09-26 13:37:53','559','2022-09-26 13:48:10',10,0),('1','281',94,'Afternoon shift','2022-09-26','2022-09-26 13:54:13','2022-09-27 13:54:13','943',4064783.55,4064783.55,'943','2022-09-26 21:19:38','559','2022-09-27 07:31:01',10,0),('1','281',95,'Morning shift','2022-09-27','2022-09-27 09:15:14','2022-09-28 09:15:14','943',6171143.70,6171143.70,'943','2022-09-27 14:06:02','559','2022-09-27 14:23:37',10,0),('1','281',96,'Morning shift 2','2022-09-27','2022-09-27 15:04:22','2022-09-28 15:04:22','943',96557.05,96557.05,'943','2022-09-27 15:06:12','559','2022-09-27 15:08:40',10,0),('1','281',97,'Afternoon shift','2022-09-27','2022-09-27 15:26:00','2022-09-28 15:26:00','943',6417980.95,6417980.95,'943','2022-09-27 22:55:31','559','2022-09-28 08:15:35',10,0),('1','281',98,'Morning shift','2022-09-28','2022-09-28 09:30:34','2022-09-29 09:30:34','943',4181776.15,4181776.15,'943','2022-09-28 14:10:47','559','2022-09-28 14:43:47',10,0),('1','281',99,'AFTERNOON  SHIFT','2022-09-28','2022-09-28 14:53:02','2022-09-29 14:53:02','943',3606112.00,3606112.00,'943','2022-09-29 08:48:58','559','2022-09-29 11:25:35',10,0),('1','281',100,'Morning ','2022-09-29','2022-09-29 14:15:21','2022-09-30 14:15:21','943',119945.00,119945.00,'943','2022-09-29 14:16:31','559','2022-09-29 14:21:13',10,0),('1','281',101,'Morning ','2022-09-29','2022-09-29 14:34:02','2022-09-30 14:34:02','943',5152539.55,5152539.55,'943','2022-09-29 14:43:20','559','2022-09-29 14:48:32',10,0),('1','281',102,'Afternoon shift','2022-09-29','2022-09-29 23:21:51','2022-09-30 23:21:51','943',4404901.30,4404901.30,'943','2022-09-29 23:40:01','559','2022-09-30 07:43:40',10,0),('1','281',103,'Morning shift','2022-09-30','2022-09-30 08:40:18','2022-10-01 08:40:18','943',4953607.05,4953607.05,'943','2022-09-30 14:54:38','559','2022-09-30 14:57:57',10,0),('1','281',104,'Afternoon shift','2022-09-30','2022-09-30 23:22:28','2022-10-01 23:22:28','943',5173840.15,5173840.15,'943','2022-10-01 08:20:52','559','2022-10-01 08:22:59',10,0),('1','281',105,'Morning shift','2022-10-01','2022-10-01 13:34:17','2022-10-02 13:34:17','943',5482282.45,5482282.45,'943','2022-10-01 17:50:55','559','2022-10-01 17:53:07',10,0),('1','281',106,'Afternoon shift','2022-10-01','2022-10-01 20:47:01','2022-10-02 20:47:01','943',2478645.85,2478645.85,'943','2022-10-02 08:37:32','559','2022-10-02 15:08:18',10,0),('1','281',107,'Morning ','2022-10-02','2022-10-02 15:46:53','2022-10-03 15:46:53','943',4046842.40,4046842.40,'943','2022-10-02 15:59:30','559','2022-10-02 21:45:12',10,0),('1','281',108,'Afternoon shift','2022-10-02','2022-10-02 22:16:15','2022-10-03 22:16:15','943',5517266.35,5517266.35,'943','2022-10-03 10:40:12','559','2022-10-03 11:07:15',10,0),('1','281',109,'Morning shift','2022-10-03','2022-10-03 13:58:55','2022-10-04 13:58:55','943',168884.30,168884.30,'943','2022-10-03 14:01:17','559','2022-10-03 15:26:51',10,0),('1','281',110,'Afternoon shift','2022-10-04','2022-10-04 06:50:37','2022-10-05 06:50:37','943',1319403.50,1319403.50,'943','2022-10-04 06:54:16','559','2022-10-04 07:51:41',10,0),('1','281',111,'Morning shift','2022-10-04','2022-10-04 11:44:57','2022-10-05 11:44:57','943',5312680.75,5312680.75,'943','2022-10-04 14:53:23','559','2022-10-04 15:14:20',10,0),('1','281',112,'AFTERNOON  SHIFT','2022-10-04','2022-10-04 15:47:59','2022-10-05 15:47:59','943',6638531.95,6638531.95,'943','2022-10-04 21:44:38','559','2022-10-05 07:47:05',10,0),('1','281',113,'Morning shift','2022-10-05','2022-10-05 08:24:58','2022-10-06 08:24:58','943',5664781.10,5664781.10,'943','2022-10-05 13:26:54','559','2022-10-05 15:17:52',10,0),('1','281',114,'Afternoon shift','2022-10-05','2022-10-05 19:33:09','2022-10-06 19:33:09','943',6082236.05,6082236.05,'943','2022-10-06 09:11:12','559','2022-10-06 09:13:07',10,0),('1','281',115,'Morning shift','2022-10-06','2022-10-06 14:24:13','2022-10-07 14:24:13','943',8389334.20,8389334.20,'943','2022-10-06 14:51:48','559','2022-10-06 15:05:42',10,0),('1','281',116,'AFTERNOON  SHIFT','2022-10-06','2022-10-06 19:35:35','2022-10-07 19:35:35','943',5190804.00,5190804.00,'943','2022-10-06 20:48:15','559','2022-10-07 07:53:26',10,0),('1','281',117,'Morning shift','2022-10-07','2022-10-07 15:05:05','2022-10-08 15:05:05','943',5759453.30,5759453.30,'943','2022-10-07 15:30:13','559','2022-10-07 15:34:19',10,0),('1','281',118,'Afternoon shift','2022-10-07','2022-10-07 21:45:54','2022-10-08 21:45:54','943',3273885.80,3273885.80,'943','2022-10-07 21:51:56','559','2022-10-08 07:55:09',10,0),('1','281',119,'Morning shift','2022-10-08','2022-10-08 08:46:10','2022-10-09 08:46:10','943',2798297.05,2798297.05,'943','2022-10-08 13:56:00','559','2022-10-08 15:33:32',10,0),('1','281',120,'AFTERNOON  SHIFT','2022-10-08','2022-10-08 17:29:56','2022-10-09 17:29:56','943',3108949.05,3108949.05,'943','2022-10-08 19:23:07','559','2022-10-09 09:31:07',10,0),('1','281',121,'MORNING SHIFT','2022-10-09','2022-10-09 11:51:29','2022-10-10 11:51:29','943',3923809.30,3923809.30,'943','2022-10-09 14:26:20','559','2022-10-09 16:20:28',10,0),('1','281',122,'Afternoon shift','2022-10-09','2022-10-09 17:53:33','2022-10-10 17:53:33','943',2496147.65,2496147.65,'943','2022-10-09 18:01:12','559','2022-10-10 08:03:29',10,0),('1','281',123,'Morning shift','2022-10-10','2022-10-10 08:49:01','2022-10-11 08:49:01','943',2120597.65,2120597.65,'943','2022-10-10 13:55:02','559','2022-10-10 15:07:16',10,0),('1','281',124,'Afternoon shift','2022-10-10','2022-10-10 16:01:47','2022-10-11 16:01:47','943',1985153.60,1985153.60,'943','2022-10-11 08:33:32','559','2022-10-11 09:55:14',10,0),('1','281',125,'Morning shift','2022-10-11','2022-10-11 14:47:12','2022-10-12 14:47:12','943',2784980.75,2784980.75,'943','2022-10-11 14:53:42','559','2022-10-11 15:03:02',10,0),('1','281',126,'AFTERNOON  SHIFT','2022-10-11','2022-10-11 17:21:25','2022-10-12 17:21:25','943',3862472.55,3862472.55,'943','2022-10-11 19:44:38','559','2022-10-11 20:03:47',10,0),('1','281',127,'Morning/Afternoon','2022-10-12','2022-10-12 07:46:39','2022-10-13 07:46:39','943',3945687.40,3945687.40,'943','2022-10-12 14:11:27','559','2022-10-12 15:02:48',10,0),('1','281',128,'AFTERNOON  SHIFT','2022-10-12','2022-10-12 15:10:55','2022-10-13 15:10:55','943',313758.70,313758.70,'943','2022-10-12 19:08:42','559','2022-10-12 19:16:32',10,0),('1','281',129,'Afternoon shift 2','2022-10-12','2022-10-12 19:22:22','2022-10-13 19:22:22','943',4240600.40,4240600.40,'943','2022-10-13 08:36:06','559','2022-10-13 08:46:39',10,0),('1','281',130,'Morning shift','2022-10-13','2022-10-13 09:22:11','2022-10-14 09:22:11','943',5177875.65,5177875.65,'943','2022-10-13 17:23:55','559','2022-10-13 19:12:47',10,0),('1','281',131,'Afternoon shift','2022-10-13','2022-10-14 08:09:12','2022-10-15 08:09:12','943',3707755.30,3707755.30,'943','2022-10-14 08:16:27','559','2022-10-14 08:17:42',10,0),('1','281',132,'Morning shift','2022-10-14','2022-10-14 14:45:53','2022-10-15 14:45:53','943',4225550.70,4225550.70,'943','2022-10-14 15:04:31','559','2022-10-14 15:08:40',10,0),('1','281',133,'Afternoon shift','2022-10-14','2022-10-15 04:35:38','2022-10-16 04:35:38','943',4399689.10,4399689.10,'943','2022-10-15 10:36:21','559','2022-10-15 12:10:16',10,0),('1','281',134,'Morning shift','2022-10-15','2022-10-15 14:00:16','2022-10-16 14:00:16','943',6207662.55,6207662.55,'943','2022-10-15 14:19:11','559','2022-10-15 14:36:04',10,0),('1','281',135,'AFTERNOON  SHIFT','2022-10-15','2022-10-15 15:22:27','2022-10-16 15:22:27','943',6906391.90,6906391.90,'943','2022-10-16 08:50:55','559','2022-10-16 10:42:05',10,0),('1','281',136,'Morning shift','2022-10-16','2022-10-16 12:44:39','2022-10-17 12:44:39','943',2725966.60,2725966.60,'943','2022-10-16 13:09:04','559','2022-10-16 15:22:29',10,0),('1','281',137,'AFTERNOON  SHIFT','2022-10-16','2022-10-16 16:46:21','2022-10-17 16:46:21','943',3309455.20,3309455.20,'943','2022-10-16 21:27:50','559','2022-10-17 08:00:50',10,0),('1','281',138,'Morning shift','2022-10-17','2022-10-17 09:29:54','2022-10-18 09:29:54','943',2440152.50,2440152.50,'943','2022-10-17 15:25:11','559','2022-10-17 20:27:37',10,0),('1','281',139,'AFTERNOON  SHIFT','2022-10-17','2022-10-17 22:07:19','2022-10-18 22:07:19','943',200561.20,200561.20,'943','2022-10-17 22:10:06','559','2022-10-18 07:50:10',10,0),('1','281',140,'MORNING SHIFT','2022-10-18','2022-10-18 09:14:22','2022-10-19 09:14:22','943',5152152.25,5152152.25,'943','2022-10-18 13:37:09','559','2022-10-18 15:42:53',10,0),('1','281',141,'Afternoon shift','2022-10-18','2022-10-18 16:18:30','2022-10-19 16:18:30','943',8107973.65,8107973.65,'943','2022-10-18 21:37:59','559','2022-10-19 07:48:43',10,0),('1','281',142,'Morning shift','2022-10-19','2022-10-19 11:13:56','2022-10-20 11:13:56','943',6508129.00,6508129.00,'943','2022-10-19 14:17:33','559','2022-10-19 15:29:03',10,0),('1','281',143,'Afternoon shift','2022-10-19','2022-10-19 16:26:59','2022-10-20 16:26:59','943',3839371.60,3839371.60,'943','2022-10-19 19:42:16','559','2022-10-20 07:54:21',10,0),('1','281',144,'Morning shift','2022-10-20','2022-10-20 10:53:15','2022-10-21 10:53:15','943',3653670.45,3653670.45,'943','2022-10-20 13:53:41','559','2022-10-20 14:32:50',10,0),('1','281',145,'AFTERNOON  SHIFT','2022-10-20','2022-10-20 20:08:18','2022-10-21 20:08:18','943',3891183.60,3891183.60,'943','2022-10-20 20:14:59','559','2022-10-21 07:22:03',10,0),('1','281',146,'MORNING SHIFT','2022-10-21','2022-10-21 15:02:01','2022-10-22 15:02:01','943',4807994.70,4807994.70,'943','2022-10-21 15:09:09','559','2022-10-21 15:10:40',10,0),('1','281',147,'Afternoon shift','2022-10-22','2022-10-22 09:27:16','2022-10-23 09:27:16','943',3739509.80,3739509.80,'943','2022-10-22 09:40:02','559','2022-10-22 10:14:45',10,0),('1','281',148,'Morning shift','2022-10-22','2022-10-22 11:19:59','2022-10-23 11:19:59','943',4392367.00,4392367.00,'943','2022-10-22 14:31:49','559','2022-10-22 15:08:24',10,0),('1','281',149,'Afternoon shift','2022-10-22','2022-10-23 09:46:35','2022-10-24 09:46:35','943',3162388.70,3162388.70,'943','2022-10-23 09:59:03','559','2022-10-23 11:34:41',10,0),('1','281',150,'MORNING SHIFT','2022-10-23','2022-10-23 14:30:05','2022-10-24 14:30:05','943',3215981.50,3215981.50,'943','2022-10-23 15:06:02','559','2022-10-23 19:56:56',10,0),('1','281',151,'Afternoon shift','2022-10-23','2022-10-23 20:00:29','2022-10-24 20:00:29','943',323924.10,323924.10,'943','2022-10-23 20:07:19','559','2022-10-24 06:38:14',10,0),('1','281',152,'Morning shift','2022-10-24','2022-10-24 13:18:58','2022-10-25 13:18:58','943',4231469.75,4231469.75,'943','2022-10-24 14:47:57','559','2022-10-24 15:33:41',10,0),('1','281',153,'AFTERNOON  SHIFT','2022-10-24','2022-10-24 16:23:52','2022-10-25 16:23:52','943',3323778.80,3323778.80,'943','2022-10-24 22:54:58','559','2022-10-25 07:45:23',10,0),('1','281',154,'Morning shift','2022-10-25','2022-10-25 08:48:36','2022-10-26 08:48:36','943',7794010.95,7794010.95,'943','2022-10-25 14:29:59','559','2022-10-25 17:24:51',10,0),('1','281',155,'AFTERNOON  SHIFT','2022-10-25','2022-10-26 05:32:15','2022-10-27 05:32:15','943',2952679.90,2952679.90,'943','2022-10-26 05:44:56','559','2022-10-26 08:08:07',10,0),('1','281',156,'Afternoon shift','2022-10-25','2022-10-26 08:10:06','2022-10-27 08:10:06','943',0.00,0.00,'943','2022-10-26 08:24:50','559','2022-10-26 08:30:44',10,0),('1','281',157,'Morning shift','2022-10-26','2022-10-26 09:19:32','2022-10-27 09:19:32','943',5883830.15,5883830.15,'943','2022-10-26 14:05:30','559','2022-10-26 15:10:03',10,0),('1','281',158,'AFTERNOON  SHIFT','2022-10-26','2022-10-26 15:20:53','2022-10-27 15:20:53','943',3692435.65,3692435.65,'943','2022-10-26 23:21:29','559','2022-10-27 07:34:16',10,0),('1','281',159,'Morning shift','2022-10-27','2022-10-27 08:32:11','2022-10-28 08:32:11','943',5125818.00,5125818.00,'943','2022-10-27 15:39:16','559','2022-10-27 15:46:44',10,0),('1','281',160,'Afternoon shift','2022-10-27','2022-10-27 22:23:14','2022-10-28 22:23:14','943',3176272.10,3176272.10,'943','2022-10-27 22:35:52','559','2022-10-28 07:49:16',10,0),('1','281',161,'MORNING SHIFT','2022-10-28','2022-10-28 10:42:18','2022-10-29 10:42:18','943',4987953.20,4987953.20,'943','2022-10-28 14:48:52','559','2022-10-28 16:20:22',10,0),('1','281',162,'Afternoon shift','2022-10-28','2022-10-28 20:16:05','2022-10-29 20:16:05','943',210795.10,210795.10,'943','2022-10-28 20:45:58','559','2022-10-29 07:59:03',10,0),('1','281',163,'Morning shift','2022-10-29','2022-10-29 11:06:39','2022-10-30 11:06:39','943',3530392.15,3530392.15,'943','2022-10-29 14:57:56','559','2022-10-29 15:03:00',10,0),('1','281',164,'Afternoon shift','2022-10-29','2022-10-29 21:52:44','2022-10-30 21:52:44','943',160430.70,160430.70,'943','2022-10-29 22:01:55','559','2022-10-30 08:10:16',10,0),('1','281',165,'Morning shift','2022-10-30','2022-10-30 09:17:17','2022-10-31 09:17:17','943',3739930.80,3739930.80,'943','2022-10-30 15:43:03','559','2022-10-30 16:06:34',10,0),('1','281',166,'Afternoon ','2022-10-30','2022-10-30 20:12:22','2022-10-31 20:12:22','943',1230317.30,1230317.30,'943','2022-10-30 20:14:01','559','2022-10-31 07:48:56',10,0),('1','281',167,'Morning shift','2022-10-31','2022-10-31 09:01:09','2022-11-01 09:01:09','943',4814508.75,4814508.75,'943','2022-10-31 14:29:50','559','2022-10-31 15:18:16',10,0),('1','281',168,'Afternoon shift','2022-10-31','2022-10-31 21:23:37','2022-11-01 21:23:37','943',5164973.00,5164973.00,'943','2022-10-31 21:29:59','559','2022-11-01 07:55:18',10,0),('1','281',169,'Morning shift','2022-11-01','2022-11-01 09:52:35','2022-11-02 09:52:35','943',5198933.95,5198933.95,'943','2022-11-01 14:31:09','559','2022-11-01 15:12:21',10,0),('1','281',170,'Afternoon  shift','2022-11-01','2022-11-01 16:40:33','2022-11-02 16:40:33','943',2343820.40,2343820.40,'943','2022-11-01 21:51:02','559','2022-11-02 08:04:58',10,0),('1','281',171,'Morning shift','2022-11-02','2022-11-02 09:29:23','2022-11-03 09:29:23','943',474585.70,474585.70,'943','2022-11-02 15:11:10','559','2022-11-02 21:39:15',10,0),('1','281',172,'Afternoon ','2022-11-02','2022-11-02 21:42:40','2022-11-03 21:42:40','943',397238.00,397238.00,'943','2022-11-02 21:44:51','559','2022-11-03 07:57:49',10,0),('1','281',173,'Morning shift','2022-11-03','2022-11-03 09:52:05','2022-11-04 09:52:05','943',633339.80,633339.80,'943','2022-11-03 14:42:55','559','2022-11-03 21:33:32',10,0),('1','281',174,'Afternoon ','2022-11-03','2022-11-03 21:58:54','2022-11-04 21:58:54','943',151250.90,151250.90,'943','2022-11-03 22:03:55','559','2022-11-04 07:37:50',10,0),('1','281',175,'Morning shift','2022-11-04','2022-11-04 10:46:05','2022-11-05 10:46:05','943',400392.00,400392.00,'943','2022-11-04 21:50:19','559','2022-11-04 21:54:33',10,0),('1','281',176,'Afternoon shift','2022-11-04','2022-11-04 22:01:19','2022-11-05 22:01:19','943',2769876.00,2769876.00,'943','2022-11-04 22:19:17','559','2022-11-05 09:09:58',10,0),('1','281',177,'Morning shift','2022-11-05','2022-11-05 15:19:26','2022-11-06 15:19:26','943',4733226.15,4733226.15,'943','2022-11-05 15:26:51','559','2022-11-05 16:37:46',10,0),('1','281',178,'Afternoon shift','2022-11-05','2022-11-05 22:27:09','2022-11-06 22:27:09','943',5607862.65,5607862.65,'943','2022-11-05 22:33:07','559','2022-11-06 08:20:35',10,0),('1','281',179,'Morning shift','2022-11-06','2022-11-06 10:32:03','2022-11-07 10:32:03','943',5048420.20,5048420.20,'943','2022-11-06 16:10:27','559','2022-11-06 16:34:24',10,0),('1','281',180,'Afternoon ','2022-11-06','2022-11-06 21:46:23','2022-11-07 21:46:23','943',1240001.70,1240001.70,'943','2022-11-06 21:51:39','559','2022-11-07 08:35:10',10,0),('1','281',181,'Morning shift','2022-11-07','2022-11-07 14:21:45','2022-11-08 14:21:45','943',4947261.20,4947261.20,'943','2022-11-07 14:37:30','559','2022-11-07 15:24:30',10,0),('1','281',182,'Afternoon ','2022-11-07','2022-11-07 21:10:33','2022-11-08 21:10:33','943',2065891.95,2065891.95,'943','2022-11-07 21:22:27','559','2022-11-08 07:48:57',10,0),('1','281',183,'Morning shift','2022-11-08','2022-11-08 09:37:33','2022-11-09 09:37:33','943',3799341.20,3799341.20,'943','2022-11-08 13:48:12','559','2022-11-08 15:04:22',10,0),('1','281',184,'Afternoon shift','2022-11-08','2022-11-08 21:18:41','2022-11-09 21:18:41','943',1731620.70,1731620.70,'943','2022-11-09 09:08:20','559','2022-11-09 11:12:43',10,0),('1','281',185,'MORNING SHIFT','2022-11-09','2022-11-09 11:14:16','2022-11-10 11:14:16','943',172706.40,172706.40,'943','2022-11-09 14:46:30','559','2022-11-09 16:20:48',10,0),('1','281',186,'Afternoon ','2022-11-09','2022-11-09 21:20:19','2022-11-10 21:20:19','943',503087.90,503087.90,'943','2022-11-09 21:22:27','559','2022-11-10 07:45:16',10,0),('1','281',187,'Morning shift','2022-11-10','2022-11-10 10:02:04','2022-11-11 10:02:04','943',404890.60,404890.60,'943','2022-11-10 13:30:51','559','2022-11-10 16:24:24',10,0),('1','281',188,'Afternoon shift','2022-11-10','2022-11-10 17:50:17','2022-11-11 17:50:17','943',1386569.40,1386569.40,'943','2022-11-11 09:51:46','559','2022-11-11 12:13:08',10,0),('1','281',189,'Morning shift','2022-11-11','2022-11-11 20:45:48','2022-11-12 20:45:48','943',32946.60,32946.60,'943','2022-11-11 20:48:32','559','2022-11-12 07:25:51',10,0),('1','281',190,'Morning shift','2022-11-12','2022-11-12 14:41:05','2022-11-13 14:41:05','943',4673410.80,4673410.80,'943','2022-11-12 15:38:01','559','2022-11-12 17:10:32',10,0),('1','281',191,'Afternoon ','2022-11-12','2022-11-12 17:20:52','2022-11-13 17:20:52','943',1439233.40,1439233.40,'943','2022-11-12 17:26:35','559','2022-11-13 07:25:35',10,0),('1','281',192,'Morning/Afternoon','2022-11-13','2022-11-13 17:29:25','2022-11-14 17:29:25','943',6381079.20,6381079.20,'943','2022-11-13 17:33:09','559','2022-11-13 17:56:05',10,0),('1','281',193,'Morning shift','2022-11-14','2022-11-14 16:38:59','2022-11-15 16:38:59','943',4886318.05,4886318.05,'943','2022-11-14 16:46:03','559','2022-11-14 16:49:35',10,0),('1','281',194,'Afternoon ','2022-11-14','2022-11-14 21:17:54','2022-11-15 21:17:54','943',2399007.25,2399007.25,'943','2022-11-14 21:33:56','559','2022-11-15 07:48:59',10,0),('1','281',195,'Morning shift','2022-11-15','2022-11-15 14:40:32','2022-11-16 14:40:32','943',6029782.35,6029782.35,'943','2022-11-15 15:23:08','559','2022-11-15 16:57:46',10,0),('1','281',196,'Afternoon shift','2022-11-15','2022-11-15 17:01:05','2022-11-16 17:01:05','943',2614716.65,2614716.65,'943','2022-11-15 20:25:31','559','2022-11-16 08:07:35',10,0),('1','281',197,'Morning shift','2022-11-16','2022-11-16 15:09:06','2022-11-17 15:09:06','943',5324501.60,5324501.60,'943','2022-11-16 15:13:36','559','2022-11-16 16:12:18',10,0),('1','281',198,'Afternoon ','2022-11-16','2022-11-16 21:56:15','2022-11-17 21:56:15','943',670550.60,670550.60,'943','2022-11-16 21:59:02','559','2022-11-17 07:56:37',10,0),('1','281',199,'Morning ','2022-11-17','2022-11-17 14:49:25','2022-11-18 14:49:25','943',7152957.75,7152957.75,'943','2022-11-17 14:54:46','559','2022-11-17 14:58:38',10,0),('1','281',200,'Afternoon ','2022-11-17','2022-11-17 21:56:32','2022-11-18 21:56:32','943',1291797.40,1291797.40,'943','2022-11-17 21:57:53','559','2022-11-18 08:01:14',10,0),('1','281',201,'Morning ','2022-11-18','2022-11-18 15:19:10','2022-11-19 15:19:10','943',7024156.70,7024156.70,'943','2022-11-18 15:25:21','559','2022-11-18 16:25:43',10,0),('1','281',202,'Afternoon ','2022-11-18','2022-11-18 20:22:49','2022-11-19 20:22:49','943',3143112.45,3143112.45,'943','2022-11-18 20:33:40','559','2022-11-19 08:13:02',10,0),('1','281',203,'MORNING SHIFT','2022-11-19','2022-11-19 10:57:24','2022-11-20 10:57:24','943',8155537.95,8155537.95,'943','2022-11-19 15:23:16','559','2022-11-19 16:09:11',10,0),('1','281',204,'Afternoon ','2022-11-19','2022-11-19 21:26:05','2022-11-20 21:26:05','943',410159.20,410159.20,'943','2022-11-19 21:27:31','559','2022-11-20 08:26:34',10,0),('1','281',205,'Morning shift','2022-11-20','2022-11-20 18:56:05','2022-11-21 18:56:05','943',2501039.20,2501039.20,'943','2022-11-20 19:14:54','559','2022-11-20 19:30:54',10,0),('1','281',206,'Afternoon ','2022-11-20','2022-11-20 20:41:48','2022-11-21 20:41:48','943',228342.40,228342.40,'943','2022-11-20 20:44:01','559','2022-11-21 06:19:56',10,0),('1','281',207,'Morning shift','2022-11-21','2022-11-21 09:04:56','2022-11-22 09:04:56','943',222508.00,222508.00,'943','2022-11-21 20:58:38','559','2022-11-21 21:01:58',10,0),('1','281',208,'Afternoon ','2022-11-21','2022-11-21 21:04:41','2022-11-22 21:04:41','943',1970584.00,1970584.00,'943','2022-11-21 21:06:46','559','2022-11-22 07:57:16',10,0),('1','281',209,'Morning/Afternoon ','2022-11-22','2022-11-22 19:20:19','2022-11-23 19:20:19','943',7685986.30,7685986.30,'943','2022-11-22 19:28:27','559','2022-11-23 06:30:59',10,0),('1','281',210,'Morning shift','2022-11-23','2022-11-23 17:03:18','2022-11-24 17:03:18','943',7547026.00,7547026.00,'943','2022-11-23 17:59:19','559','2022-11-23 20:42:43',10,0),('1','281',211,'Afternoon ','2022-11-23','2022-11-23 20:46:15','2022-11-24 20:46:15','943',761675.20,761675.20,'943','2022-11-23 20:47:34','559','2022-11-24 07:48:28',10,0),('1','281',212,'Morning shift','2022-11-24','2022-11-24 16:54:35','2022-11-25 16:54:35','943',6209868.90,6209868.90,'943','2022-11-24 16:58:13','559','2022-11-25 06:29:30',10,0),('1','281',213,'Afternoon ','2022-11-24','2022-11-25 06:44:06','2022-11-26 06:44:06','943',4196913.60,4196913.60,'943','2022-11-25 06:45:23','559','2022-11-25 08:21:18',10,0),('1','281',214,'Morning ','2022-11-25','2022-11-25 20:07:13','2022-11-26 20:07:13','943',6397788.40,6397788.40,'943','2022-11-25 20:14:39','559','2022-11-25 20:36:07',10,0),('1','281',215,'Afternoon ','2022-11-25','2022-11-25 20:53:30','2022-11-26 20:53:30','943',3280552.00,3280552.00,'943','2022-11-25 20:54:49','559','2022-11-26 07:45:55',10,0),('1','281',216,'MORNING SHIFT','2022-11-26','2022-11-26 09:06:29','2022-11-27 09:06:29','943',3922257.75,3922257.75,'943','2022-11-26 15:35:03','559','2022-11-26 15:44:28',10,0),('1','281',217,'Afternoon ','2022-11-26','2022-11-26 21:30:47','2022-11-27 21:30:47','943',3538325.95,3538325.95,'943','2022-11-26 21:36:29','559','2022-11-27 07:46:42',10,0),('1','281',218,'MORNING SHIFT','2022-11-27','2022-11-27 09:15:01','2022-11-28 09:15:01','943',6476466.10,6476466.10,'943','2022-11-27 17:10:54','559','2022-11-27 20:17:43',10,0),('1','281',219,'Afternoon ','2022-11-27','2022-11-27 21:30:28','2022-11-28 21:30:28','943',243469.50,243469.50,'943','2022-11-27 21:31:39','559','2022-11-28 08:31:52',10,0),('1','281',220,'Morning shift','2022-11-28','2022-11-28 09:05:33','2022-11-29 09:05:33','943',408795.60,408795.60,'943','2022-11-28 19:41:02','559','2022-11-28 20:30:11',10,0),('1','281',221,'Afternoon ','2022-11-28','2022-11-28 22:35:20','2022-11-29 22:35:20','943',493176.90,493176.90,'943','2022-11-28 22:36:28','559','2022-11-29 08:02:29',10,0),('1','281',222,'Morning shift','2022-11-29','2022-11-29 13:45:03','2022-11-30 13:45:03','943',462335.40,462335.40,'943','2022-11-29 13:46:12','559','2022-11-29 17:00:02',10,0),('1','281',223,'Afternoon ','2022-11-29','2022-11-29 21:15:26','2022-11-30 21:15:26','943',353513.60,353513.60,'943','2022-11-29 21:16:27','559','2022-11-30 07:42:51',10,0),('1','281',224,'Morning shift','2022-11-30','2022-11-30 08:35:45','2022-12-01 08:35:45','943',6619503.80,6619503.80,'943','2022-11-30 17:29:27','559','2022-11-30 21:28:27',10,0),('1','281',225,'Afternoon ','2022-11-30','2022-11-30 22:13:06','2022-12-01 22:13:06','943',515942.00,515942.00,'943','2022-11-30 22:15:17','559','2022-12-01 07:27:41',10,0),('1','281',226,'Morning ','2022-12-01','2022-12-01 15:13:06','2022-12-02 15:13:06','943',351535.70,351535.70,'943','2022-12-01 15:14:49','559','2022-12-01 16:27:33',10,0),('1','281',227,'MORNING SHIFT','2022-12-02','2022-12-02 14:55:00','2022-12-03 14:55:00','943',7142128.30,7142128.30,'943','2022-12-02 16:38:15','559','2022-12-02 21:25:52',10,0),('1','281',228,'Afternoon ','2022-12-02','2022-12-02 21:56:25','2022-12-03 21:56:25','943',366308.80,366308.80,'943','2022-12-02 21:59:08','559','2022-12-03 08:22:09',10,0),('1','281',229,'Morning shift','2022-12-03','2022-12-03 09:24:01','2022-12-04 09:24:01','943',3796295.80,3796295.80,'943','2022-12-03 14:39:09','559','2022-12-03 15:37:23',10,0),('1','281',230,'Afternoon shift','2022-12-04','2022-12-04 09:12:39','2022-12-05 09:12:39','943',2448309.60,2448309.60,'943','2022-12-04 09:15:20','559','2022-12-04 09:23:29',10,0),('1','281',231,'Morning shift','2022-12-04','2022-12-04 09:25:44','2022-12-05 09:25:44','943',0.00,0.00,'943','2022-12-05 09:49:08','559','2022-12-05 10:25:06',10,0),('1','281',232,'Morning shift','2022-12-04','2022-12-05 10:30:17','2022-12-06 10:30:17','943',3679272.20,3679272.20,'943','2022-12-05 10:34:56','559','2022-12-05 10:40:19',10,0),('1','281',233,'Afternoon shift','2022-12-04','2022-12-05 10:40:54','2022-12-06 10:40:54','943',287946.00,287946.00,'943','2022-12-05 10:41:57','559','2022-12-05 10:44:19',10,0),('1','281',234,'Morning shift','2022-12-05','2022-12-05 10:51:55','2022-12-06 10:51:55','943',303219.00,303219.00,'943','2022-12-05 15:34:49','559','2022-12-06 06:18:48',10,0),('1','281',235,'Afternoon ','2022-12-05','2022-12-06 07:29:53','2022-12-07 07:29:53','943',656478.00,656478.00,'943','2022-12-06 07:30:51','559','2022-12-06 07:41:51',10,0),('1','281',236,'Morning shift','2022-12-06','2022-12-06 08:47:30','2022-12-07 08:47:30','943',6648644.95,6648644.95,'943','2022-12-06 16:58:08','559','2022-12-06 17:23:38',10,0),('1','281',237,'Afternoon ','2022-12-06','2022-12-06 22:19:48','2022-12-07 22:19:48','943',1206157.60,1206157.60,'943','2022-12-06 22:22:01','559','2022-12-07 07:52:24',10,0),('1','281',238,'Morning shift','2022-12-07','2022-12-07 11:58:23','2022-12-08 11:58:23','943',3303126.70,3303126.70,'943','2022-12-07 17:29:36','559','2022-12-07 18:34:32',10,0),('1','281',239,'Afternoon ','2022-12-07','2022-12-07 21:55:48','2022-12-08 21:55:48','943',1032773.80,1032773.80,'943','2022-12-07 21:56:42','559','2022-12-08 08:47:07',10,0),('1','281',240,'Morning/Afternoon ','2022-12-08','2022-12-08 16:06:50','2022-12-09 16:06:50','943',3189074.70,3189074.70,'943','2022-12-08 20:22:56','559','2022-12-08 20:26:02',10,0),('1','281',241,'MORNING SHIFT','2022-12-09','2022-12-09 16:54:11','2022-12-10 16:54:11','943',3919010.75,3919010.75,'943','2022-12-09 17:03:03','559','2022-12-09 20:33:23',10,0),('1','281',242,'Afternoon ','2022-12-09','2022-12-09 20:36:16','2022-12-10 20:36:16','943',560735.60,560735.60,'943','2022-12-09 20:37:49','559','2022-12-10 08:27:14',10,0),('1','281',243,'MORNING SHIFT','2022-12-10','2022-12-10 20:00:43','2022-12-11 20:00:43','943',3070436.25,3070436.25,'943','2022-12-10 20:06:26','559','2022-12-11 08:03:07',10,0),('1','281',244,'Morning shift','2022-12-11','2022-12-11 15:29:13','2022-12-12 15:29:13','943',3817743.50,3817743.50,'943','2022-12-11 15:35:34','559','2022-12-11 20:35:11',10,0),('1','281',245,'Afternoon ','2022-12-11','2022-12-11 20:36:36','2022-12-12 20:36:36','943',90886.80,90886.80,'943','2022-12-11 20:37:42','559','2022-12-12 08:28:04',10,0),('1','281',246,'Morning shift','2022-12-12','2022-12-12 15:05:22','2022-12-13 15:05:22','943',469270.30,469270.30,'943','2022-12-12 15:11:08','559','2022-12-12 20:16:05',10,0),('1','281',247,'Afternoon ','2022-12-12','2022-12-12 20:18:10','2022-12-13 20:18:10','943',605564.90,605564.90,'943','2022-12-12 20:20:15','559','2022-12-13 08:36:33',10,0),('1','281',248,'Morning/Afternoon','2022-12-13','2022-12-13 12:19:52','2022-12-14 12:19:52','943',402057.50,402057.50,'943','2022-12-13 19:47:50','559','2022-12-14 07:58:30',10,0),('1','281',249,'MORNING SHIFT','2022-12-14','2022-12-14 11:51:41','2022-12-15 11:51:41','943',7064858.30,7064858.30,'943','2022-12-14 15:38:14','559','2022-12-14 15:49:47',10,0),('1','281',250,'AFTERNOON  SHIFT','2022-12-14','2022-12-14 16:09:23','2022-12-15 16:09:23','943',2828044.25,2828044.25,'943','2022-12-14 18:53:46','559','2022-12-14 19:00:44',10,0),('1','281',251,'MORNING SHIFT','2022-12-15','2022-12-15 10:02:18','2022-12-16 10:02:18','943',6713429.95,6713429.95,'943','2022-12-15 14:20:03','559','2022-12-15 15:46:36',10,0),('1','281',252,'AFTERNOON  SHIFT','2022-12-15','2022-12-15 17:33:19','2022-12-16 17:33:19','943',952080.80,952080.80,'943','2022-12-15 20:30:33','559','2022-12-15 20:37:01',10,0),('1','281',253,'MORNING SHIFT','2022-12-16','2022-12-16 09:56:16','2022-12-17 09:56:16','943',3557867.75,3557867.75,'943','2022-12-16 19:28:31','559','2022-12-16 21:18:53',10,0),('1','281',254,'Morning shift','2022-12-17','2022-12-17 12:28:48','2022-12-18 12:28:48','943',5457934.25,5457934.25,'943','2022-12-17 14:58:46','559','2022-12-17 19:54:58',10,0),('1','281',255,'Afternoon ','2022-12-17','2022-12-17 19:58:13','2022-12-18 19:58:13','943',183541.60,183541.60,'943','2022-12-17 19:59:34','559','2022-12-18 08:11:16',10,0),('1','281',256,'Morning shift','2022-12-18','2022-12-18 09:36:38','2022-12-19 09:36:38','943',3432880.45,3432880.45,'943','2022-12-18 20:56:03','559','2022-12-18 21:03:20',10,0),('1','281',257,'Afternoon ','2022-12-18','2022-12-19 06:16:24','2022-12-20 06:16:24','943',91810.40,91810.40,'943','2022-12-19 06:18:41','559','2022-12-19 08:11:35',10,0),('1','281',258,'Morning shift','2022-12-19','2022-12-19 11:34:22','2022-12-20 11:34:22','943',5446709.25,5446709.25,'943','2022-12-19 14:34:09','559','2022-12-19 15:03:45',10,0),('1','281',259,'Afternoon ','2022-12-19','2022-12-19 21:53:47','2022-12-20 21:53:47','943',633417.85,633417.85,'943','2022-12-19 21:55:43','559','2022-12-20 08:16:41',10,0),('1','281',260,'Morning shift','2022-12-20','2022-12-20 10:03:51','2022-12-21 10:03:51','943',13454781.85,13454781.85,'943','2022-12-21 07:46:09','559','2022-12-21 07:50:12',10,0),('1','281',261,'Morning ','2022-12-21','2022-12-21 17:42:23','2022-12-22 17:42:23','943',4941788.60,4941788.60,'943','2022-12-21 18:53:48','559','2022-12-21 19:10:18',10,0),('1','281',262,'Afternoon  shift','2022-12-21','2022-12-21 20:49:02','2022-12-22 20:49:02','943',389294.40,389294.40,'943','2022-12-21 20:50:12','559','2022-12-22 06:38:03',10,0),('1','281',263,'Morning shift','2022-12-22','2022-12-22 13:31:10','2022-12-23 13:31:10','943',3359724.65,3359724.65,'943','2022-12-22 13:37:21','559','2022-12-22 19:01:48',10,0),('1','281',264,'Afternoon ','2022-12-22','2022-12-22 23:13:46','2022-12-23 23:13:46','943',821732.00,821732.00,'943','2022-12-22 23:16:23','559','2022-12-23 08:02:24',10,0),('1','281',265,'Morning shift','2022-12-23','2022-12-23 10:15:52','2022-12-24 10:15:52','943',6885068.15,6885068.15,'943','2022-12-23 15:42:50','559','2022-12-23 17:30:25',10,0),('1','281',266,'Afternoon ','2022-12-23','2022-12-23 20:39:03','2022-12-24 20:39:03','943',3252594.40,3252594.40,'943','2022-12-23 20:40:07','559','2022-12-24 08:42:22',10,0),('1','281',267,'Morning shift','2022-12-24','2022-12-24 17:33:57','2022-12-25 17:33:57','943',7569964.65,7569964.65,'943','2022-12-24 17:47:16','559','2022-12-24 17:57:42',10,0),('1','281',268,'Afternoon shift','2022-12-24','2022-12-24 18:50:07','2022-12-25 18:50:07','943',460856.00,460856.00,'943','2022-12-24 18:51:12','559','2022-12-25 06:51:02',10,0),('1','281',269,'Morning shift','2022-12-25','2022-12-25 17:02:58','2022-12-26 17:02:58','943',3642886.65,3642886.65,'943','2022-12-25 17:09:47','559','2022-12-25 19:05:11',10,0),('1','281',270,'Afternoon ','2022-12-25','2022-12-25 20:56:08','2022-12-26 20:56:08','943',161004.80,161004.80,'943','2022-12-25 20:58:16','559','2022-12-26 08:13:02',10,0),('1','281',271,'Morning ','2022-12-26','2022-12-26 14:57:11','2022-12-27 14:57:11','943',573786.40,573786.40,'943','2022-12-26 14:58:44','559','2022-12-26 20:52:06',10,0),('1','281',272,'Afternoon shift','2022-12-26','2022-12-27 07:41:19','2022-12-28 07:41:19','943',249365.60,249365.60,'943','2022-12-27 07:42:04','559','2022-12-27 07:48:29',10,0),('1','281',273,'Morning shift','2022-12-27','2022-12-27 08:15:52','2022-12-28 08:15:52','943',4821889.50,4821889.50,'943','2022-12-27 15:56:54','559','2022-12-27 19:22:32',10,0),('1','281',274,'Afternoon ','2022-12-27','2022-12-27 21:24:12','2022-12-28 21:24:12','943',244147.20,244147.20,'943','2022-12-27 21:25:25','559','2022-12-28 07:39:41',10,0),('1','281',275,'Morning shift','2022-12-28','2022-12-28 14:14:56','2022-12-29 14:14:56','943',4175214.70,4175214.70,'943','2022-12-28 14:20:34','559','2022-12-28 15:14:36',10,0),('1','281',276,'Afternoon shift','2022-12-24','2022-12-29 08:45:12','2022-12-30 08:45:12','943',0.00,0.00,'943','2022-12-29 08:52:42','559','2022-12-29 09:01:50',10,0),('1','281',277,'Afternoon shift','2022-12-28','2022-12-29 09:02:45','2022-12-30 09:02:45','943',1685604.80,1685604.80,'943','2022-12-29 09:07:16','559','2022-12-29 09:11:30',10,0),('1','281',278,'Morning shift','2022-12-29','2022-12-29 10:11:28','2022-12-30 10:11:28','943',7364884.45,7364884.45,'943','2022-12-29 16:59:04','559','2022-12-29 20:45:37',10,0),('1','281',279,'AFTERNOON','2022-12-29','2022-12-29 22:44:38','2022-12-30 22:44:38','943',746424.80,746424.80,'943','2022-12-29 22:46:19','559','2022-12-30 07:47:23',10,0),('1','281',280,'Morning shift','2022-12-30','2022-12-30 12:32:43','2022-12-31 12:32:43','943',9359131.60,9359131.60,'943','2022-12-30 16:55:08','559','2022-12-30 21:12:38',10,0),('1','281',281,'AFTERNOON','2022-12-30','2022-12-30 21:19:12','2022-12-31 21:19:12','943',691495.20,691495.20,'943','2022-12-30 21:25:47','559','2022-12-31 08:55:33',10,0),('1','281',282,'Morning shift','2022-12-31','2022-12-31 10:34:51','2023-01-01 10:34:51','943',5009971.15,5009971.15,'943','2022-12-31 16:53:03','559','2022-12-31 17:02:57',10,0),('1','281',283,'Morning shift','2022-12-31','2022-12-31 19:07:56','2023-01-01 19:07:56','943',351929.60,351929.60,'943','2022-12-31 19:09:07','559','2022-12-31 21:13:45',10,0),('1','281',284,'Morning shift','2023-01-01','2023-01-01 13:51:03','2023-01-02 13:51:03','943',160723.20,160723.20,'943','2023-01-01 13:52:31','559','2023-01-01 21:42:47',10,0),('1','281',285,'AFTERNOON','2023-01-01','2023-01-01 21:43:55','2023-01-02 21:43:55','943',519156.00,519156.00,'943','2023-01-01 21:47:25','559','2023-01-02 08:31:38',10,0),('1','281',286,'Morning shift','2023-01-02','2023-01-02 13:17:02','2023-01-03 13:17:02','943',10415107.60,10415107.60,'943','2023-01-02 15:26:26','559','2023-01-02 16:08:41',10,0),('1','281',287,'AFTERNOON','2023-01-02','2023-01-02 21:00:26','2023-01-03 21:00:26','943',229979.20,229979.20,'943','2023-01-02 21:03:13','559','2023-01-03 07:33:32',10,0),('1','281',288,'MORNING SHIFT','2023-01-03','2023-01-03 16:42:00','2023-01-04 16:42:00','943',5363353.95,5363353.95,'943','2023-01-03 16:49:27','559','2023-01-03 17:00:05',10,0),('1','281',289,'Afternoon shift','2023-01-03','2023-01-03 17:02:43','2023-01-04 17:02:43','943',230903.20,230903.20,'943','2023-01-03 21:18:44','559','2023-01-04 08:05:12',10,0),('1','281',290,'Morning/Afternoon','2023-01-04','2023-01-04 12:00:38','2023-01-05 12:00:38','943',1425459.20,1425459.20,'943','2023-01-04 21:16:42','559','2023-01-05 07:59:41',10,0),('1','281',291,'Morning shift','2023-01-05','2023-01-05 12:41:49','2023-01-06 12:41:49','943',7076300.40,7076300.40,'943','2023-01-05 14:34:28','559','2023-01-05 20:35:06',10,0),('1','281',292,'AFTERNOON','2023-01-05','2023-01-05 20:38:02','2023-01-06 20:38:02','943',562716.00,562716.00,'943','2023-01-05 20:40:36','559','2023-01-05 21:08:51',10,0),('1','281',293,'Morning shift','2023-01-06','2023-01-06 19:20:06','2023-01-07 19:20:06','943',490740.80,490740.80,'943','2023-01-06 19:21:01','559','2023-01-06 20:01:41',10,0),('1','281',294,'Afternoon ','2023-01-06','2023-01-06 20:50:00','2023-01-07 20:50:00','943',335464.80,335464.80,'943','2023-01-06 20:51:05','559','2023-01-07 08:43:21',10,0),('1','281',295,'MORNING SHIFT','2023-01-07','2023-01-07 12:35:16','2023-01-08 12:35:16','943',4644094.80,4644094.80,'943','2023-01-07 15:39:47','559','2023-01-07 15:56:32',10,0),('1','281',296,'Afternoon ','2023-01-07','2023-01-07 17:18:03','2023-01-08 17:18:03','943',342997.60,342997.60,'943','2023-01-07 22:06:44','559','2023-01-08 01:09:46',10,0),('1','281',297,'Morning shift','2023-01-08','2023-01-08 08:23:54','2023-01-09 08:23:54','943',3642443.30,3642443.30,'943','2023-01-08 16:04:03','559','2023-01-08 21:28:10',10,0),('1','281',298,'Afternoon ','2023-01-08','2023-01-08 21:28:50','2023-01-09 21:28:50','943',2973660.80,2973660.80,'943','2023-01-08 21:30:07','559','2023-01-08 21:42:20',10,0),('1','281',299,'Morning/Afternoon','2023-01-09','2023-01-09 15:19:16','2023-01-10 15:19:16','943',979378.40,979378.40,'943','2023-01-09 20:30:17','559','2023-01-10 08:43:13',10,0),('1','281',300,'Morning shift','2023-01-10','2023-01-10 12:00:11','2023-01-11 12:00:11','943',7120327.95,7120327.95,'943','2023-01-10 16:26:43','559','2023-01-10 20:00:17',10,0),('1','281',301,'AFTERNOON','2023-01-10','2023-01-10 20:09:04','2023-01-11 20:09:04','943',339284.00,339284.00,'943','2023-01-10 20:10:52','559','2023-01-11 09:59:45',10,0),('1','281',302,'Morning ','2023-01-11','2023-01-11 19:38:38','2023-01-12 19:38:38','943',891642.40,891642.40,'943','2023-01-11 20:30:38','559','2023-01-11 20:41:31',10,0),('1','281',303,'Afternoon ','2023-01-11','2023-01-11 20:44:23','2023-01-12 20:44:23','943',484985.60,484985.60,'943','2023-01-11 20:45:39','559','2023-01-12 10:48:54',10,0),('1','281',304,'Morning shift','2023-01-12','2023-01-12 14:29:03','2023-01-13 14:29:03','943',290928.00,290928.00,'943','2023-01-12 14:30:37','559','2023-01-12 15:13:46',10,0),('1','281',305,'Afternoon ','2023-01-12','2023-01-12 20:45:55','2023-01-13 20:45:55','943',1014912.80,1014912.80,'943','2023-01-12 21:43:42','559','2023-01-13 14:23:10',10,0),('1','281',306,'Morning ','2023-01-13','2023-01-13 22:41:25','2023-01-14 22:41:25','943',4830969.50,4830969.50,'943','2023-01-13 22:49:52','559','2023-01-14 08:53:07',10,0),('1','281',307,'Afternoon ','2023-01-13','2023-01-14 10:01:26','2023-01-15 10:01:26','943',260972.80,260972.80,'943','2023-01-14 10:03:05','559','2023-01-14 10:06:11',10,0),('1','281',308,'Morning shift','2023-01-14','2023-01-14 11:19:14','2023-01-15 11:19:14','943',2306198.40,2306198.40,'943','2023-01-14 17:06:57','559','2023-01-14 20:30:39',10,0),('1','281',309,'Afternoon ','2023-01-14','2023-01-14 21:22:33','2023-01-15 21:22:33','943',600186.40,600186.40,'943','2023-01-14 21:39:40','559','2023-01-15 09:02:03',10,0),('1','281',310,'Morning ','2023-01-15','2023-01-15 10:00:24','2023-01-16 10:00:24','943',7892905.85,7892905.85,'943','2023-01-15 17:25:16','559','2023-01-15 20:49:46',10,0),('1','281',311,'AFTERNOON','2023-01-15','2023-01-15 21:11:24','2023-01-16 21:11:24','943',124502.40,124502.40,'943','2023-01-15 21:23:53','559','2023-01-16 09:45:19',10,0),('1','281',312,'Morning ','2023-01-16','2023-01-16 18:06:40','2023-01-17 18:06:40','943',387736.80,387736.80,'943','2023-01-16 18:07:54','559','2023-01-16 20:08:43',10,0),('1','281',313,'Afternoon ','2023-01-16','2023-01-16 21:17:23','2023-01-17 21:17:23','943',870909.60,870909.60,'943','2023-01-16 21:20:22','559','2023-01-17 09:37:02',10,0),('1','281',314,'Morning shift','2023-01-17','2023-01-17 15:01:04','2023-01-18 15:01:04','943',4468802.20,4468802.20,'943','2023-01-17 16:40:06','559','2023-01-17 18:21:20',10,0),('1','281',315,'Afternoon ','2023-01-17','2023-01-17 23:04:13','2023-01-18 23:04:13','943',3134216.80,3134216.80,'943','2023-01-17 23:07:21','559','2023-01-18 09:23:15',10,0),('1','281',316,'Morning/Afternoon','2023-01-18','2023-01-18 15:36:32','2023-01-19 15:36:32','943',1879226.10,1879226.10,'943','2023-01-18 19:55:00','559','2023-01-19 09:36:56',10,0),('1','281',317,'Morning shift','2023-01-19','2023-01-19 14:45:27','2023-01-20 14:45:27','943',523853.10,523853.10,'943','2023-01-19 14:47:58','559','2023-01-19 16:57:59',10,0),('1','281',318,'Afternoon shift','2023-01-19','2023-01-19 17:42:30','2023-01-20 17:42:30','943',1184270.10,1184270.10,'943','2023-01-19 19:30:37','559','2023-01-19 21:45:54',10,0),('1','281',319,'Morning/Afternoon','2023-01-20','2023-01-20 13:52:45','2023-01-21 13:52:45','943',3832576.20,3832576.20,'943','2023-01-20 19:18:56','559','2023-01-21 09:06:17',10,0),('1','281',320,'Morning/Afternoon ','2023-01-21','2023-01-21 16:40:40','2023-01-22 16:40:40','943',910411.50,910411.50,'943','2023-01-21 21:36:13','559','2023-01-21 23:26:56',10,0),('1','281',321,'MORNING SHIFT','2023-01-22','2023-01-22 10:30:40','2023-01-23 10:30:40','943',3758694.80,3758694.80,'943','2023-01-22 14:25:07','559','2023-01-22 14:39:01',10,0),('1','281',322,'Afternoon  shift','2023-01-22','2023-01-22 18:10:38','2023-01-23 18:10:38','943',756847.80,756847.80,'943','2023-01-22 21:50:55','559','2023-01-23 09:39:32',10,0),('1','281',323,'Morning ','2023-01-23','2023-01-23 17:01:31','2023-01-24 17:01:31','943',4662115.20,4662115.20,'943','2023-01-23 17:08:57','559','2023-01-23 20:30:18',10,0),('1','281',324,'Afternoon ','2023-01-23','2023-01-23 21:46:38','2023-01-24 21:46:38','943',3063643.00,3063643.00,'943','2023-01-23 22:00:19','559','2023-01-24 09:13:36',10,0),('1','281',325,'Morning ','2023-01-24','2023-01-24 15:36:48','2023-01-25 15:36:48','943',4404530.00,4404530.00,'943','2023-01-24 15:44:14','559','2023-01-24 20:52:40',10,0),('1','281',326,'Afternoon ','2023-01-24','2023-01-24 21:16:35','2023-01-25 21:16:35','943',553781.10,553781.10,'943','2023-01-24 21:18:31','559','2023-01-24 22:52:56',10,0),('1','281',327,'Morning/Afternoon','2023-01-25','2023-01-25 20:07:02','2023-01-26 20:07:02','943',998751.30,998751.30,'943','2023-01-25 20:08:23','559','2023-01-25 22:21:05',10,0),('1','281',328,'Morning ','2023-01-26','2023-01-26 14:47:19','2023-01-27 14:47:19','943',5902800.10,5902800.10,'943','2023-01-26 17:57:33','559','2023-01-26 18:08:07',10,0),('1','281',329,'Afternoon ','2023-01-26','2023-01-26 21:58:32','2023-01-27 21:58:32','943',562068.10,562068.10,'943','2023-01-26 22:03:29','559','2023-01-26 22:30:48',10,0),('1','281',330,'MORNING SHIFT','2023-01-27','2023-01-27 10:14:45','2023-01-28 10:14:45','943',4283913.70,4283913.70,'943','2023-01-27 15:48:44','559','2023-01-27 17:31:42',10,0),('1','281',331,'Afternoon ','2023-01-27','2023-01-27 20:43:00','2023-01-28 20:43:00','943',828070.00,828070.00,'943','2023-01-28 11:21:16','559','2023-01-28 12:24:17',10,0),('1','281',332,'Morning/Afternoon','2023-01-29','2023-01-29 20:25:34','2023-01-30 20:25:34','943',227043.50,227043.50,'943','2023-01-29 21:19:31','559','2023-01-29 21:34:01',10,0),('1','281',333,'Morning/Afternoon','2023-01-30','2023-01-30 11:08:16','2023-01-31 11:08:16','943',4046153.00,4046153.00,'943','2023-01-30 19:26:10','559','2023-01-31 09:37:48',10,0),('1','281',334,'Morning/Afternoon ','2023-01-31','2023-01-31 17:45:41','2023-02-01 17:45:41','943',3718563.00,3718563.00,'943','2023-01-31 19:07:23','559','2023-01-31 21:47:43',10,0),('1','281',335,'Morning/Afternoon ','2023-02-01','2023-02-01 20:01:53','2023-02-02 20:01:53','943',3941492.50,3941492.50,'943','2023-02-02 09:53:27','559','2023-02-02 10:04:15',10,0),('1','281',336,'Morning/Afternoon','2023-02-02','2023-02-02 16:40:12','2023-02-03 16:40:12','943',3439209.40,3439209.40,'943','2023-02-03 11:09:45','559','2023-02-03 11:46:34',10,0),('1','281',337,'Morning/Afternoon ','2023-02-03','2023-02-03 20:27:48','2023-02-04 20:27:48','943',57002.00,57002.00,'943','2023-02-03 20:29:39','559','2023-02-03 21:09:02',10,0),('1','281',338,'Morning/Afternoon','2023-02-05','2023-02-05 16:41:05','2023-02-06 16:41:05','943',5275175.50,5275175.50,'943','2023-02-06 11:07:46','559','2023-02-06 11:31:04',10,0),('1','281',339,'Morning/Afternoon','2023-02-06','2023-02-06 16:59:10','2023-02-07 16:59:10','943',3364568.50,3364568.50,'943','2023-02-07 07:55:15','559','2023-02-07 08:16:21',10,0),('1','281',340,'Morning/Afternoon','2023-02-07','2023-02-07 15:30:52','2023-02-08 15:30:52','943',1382499.00,1382499.00,'943','2023-02-08 07:31:28','559','2023-02-08 10:05:52',10,0),('1','281',341,'Morning/Afternoon ','2023-02-08','2023-02-08 20:02:07','2023-02-09 20:02:07','943',984138.50,984138.50,'943','2023-02-08 20:03:37','559','2023-02-09 09:15:43',10,0),('1','281',342,'Morning/Afternoon','2023-02-09','2023-02-09 18:08:06','2023-02-10 18:08:06','943',2857062.50,2857062.50,'943','2023-02-09 21:41:58','559','2023-02-09 21:53:39',10,0),('1','281',343,'Morning/Afternoon ','2023-02-10','2023-02-10 22:03:08','2023-02-11 22:03:08','943',6222334.20,6222334.20,'943','2023-02-11 14:55:39','559','2023-02-11 18:32:13',10,0),('1','281',344,'Morning/Afternoon','2023-02-11','2023-02-11 21:20:44','2023-02-12 21:20:44','943',2922223.50,2922223.50,'943','2023-02-11 21:21:47','559','2023-02-11 22:10:13',10,0),('1','281',345,'Morning/Afternoon','2023-02-12','2023-02-12 20:55:23','2023-02-13 20:55:23','943',4534575.20,4534575.20,'943','2023-02-12 21:13:13','559','2023-02-13 00:52:13',10,0),('1','281',346,'Morning/Afternoon','2023-02-13','2023-02-13 17:01:56','2023-02-14 17:01:56','943',3821088.10,3821088.10,'943','2023-02-13 20:42:26','559','2023-02-14 07:06:31',10,0),('1','281',347,'MORNING/AFTERNOON','2023-02-14','2023-02-14 20:44:57','2023-02-15 20:44:57','943',6338999.80,6338999.80,'943','2023-02-14 21:36:43','559','2023-02-15 10:13:18',10,0),('1','281',348,'Morning/Afternoon','2023-02-15','2023-02-15 21:03:42','2023-02-16 21:03:42','943',8577569.10,8577569.10,'943','2023-02-15 22:11:15','634','2023-02-16 10:59:20',10,0),('1','281',349,'Morning/Afternoon','2023-02-16','2023-02-17 07:31:44','2023-02-18 07:31:44','943',7517365.80,7517365.80,'943','2023-02-17 07:56:24','559','2023-02-17 08:38:26',10,0),('1','281',350,'MORNING/AFTERNOON','2023-02-17','2023-02-17 22:26:18','2023-02-18 22:26:18','943',7652986.40,7652986.40,'943','2023-02-17 23:19:26','559','2023-02-18 09:41:52',10,0),('1','281',351,'MORNING/AFTERNOON','2023-02-18','2023-02-18 22:48:46','2023-02-19 22:48:46','943',9259481.50,9259481.50,'943','2023-02-19 07:02:52','559','2023-02-19 09:22:17',10,0),('1','281',352,'Morning/Afternoon','2023-02-19','2023-02-19 15:33:29','2023-02-20 15:33:29','943',3667704.10,3667704.10,'943','2023-02-19 22:11:02','559','2023-02-20 08:01:30',10,0),('1','281',353,'Morning/Afternoon','2023-02-20','2023-02-20 16:53:57','2023-02-21 16:53:57','943',5755113.80,5755113.80,'943','2023-02-20 19:48:53','559','2023-02-21 06:15:33',10,0),('1','281',354,'Morning shift','2023-02-21','2023-02-21 22:09:23','2023-02-22 22:09:23','943',11927680.10,11927680.10,'943','2023-02-22 09:47:53','634','2023-02-22 10:06:38',10,0),('1','281',355,'Morning/Afternoon ','2023-02-22','2023-02-22 23:35:22','2023-02-23 23:35:22','943',9230688.50,9230688.50,'943','2023-02-23 09:13:28','559','2023-02-23 19:20:15',10,0),('1','281',356,'Morning/Afternoon','2023-02-23','2023-02-23 19:43:52','2023-02-24 19:43:52','943',13739755.90,13739755.90,'943','2023-02-24 11:20:38','559','2023-02-24 11:24:33',10,0),('1','281',357,'Morning/Afternoon','2023-02-24','2023-02-24 11:39:42','2023-02-25 11:39:42','943',0.00,0.00,'943','2023-02-25 12:34:00','634','2023-02-25 13:46:18',10,0),('1','281',358,'Morning/Afternoon','2023-02-24','2023-02-25 13:48:50','2023-02-26 13:48:50','943',10745246.50,10745246.50,'634','2023-02-25 15:43:12','559','2023-02-25 21:26:48',10,0),('1','281',359,'Morning/Afternoon 2','2023-02-26','2023-02-26 08:31:27','2023-02-27 08:31:27','943',0.00,0.00,'943','2023-02-27 09:20:27','559','2023-02-27 09:22:48',10,0),('1','281',360,'Morning/Afternoon  2','2023-02-24','2023-02-27 09:25:33','2023-02-28 09:25:33','943',913000.00,913000.00,'943','2023-02-27 09:27:13','559','2023-02-27 09:30:27',10,0),('1','281',361,'Morning/Afternoon','2023-02-26','2023-02-27 10:08:29','2023-02-28 10:08:29','943',0.00,0.00,'634','2023-02-27 10:55:22','634','2023-02-27 10:55:31',10,0),('1','281',362,'Morning/Afternoon  2','2023-02-26','2023-02-27 11:13:27','2023-02-28 11:13:27','943',10143464.60,10143464.60,'943','2023-02-27 11:26:56','559','2023-02-27 11:37:51',10,0),('1','281',363,'Morning/Afternoon','2023-02-27','2023-02-27 21:58:54','2023-02-28 21:58:54','943',4425031.40,4425031.40,'943','2023-02-27 22:06:46','559','2023-02-27 22:40:22',10,0),('1','281',364,'MORNING/AFTERNOON','2023-02-28','2023-03-01 00:04:54','2023-03-02 00:04:54','943',9644909.90,9644909.90,'943','2023-03-01 07:23:19','559','2023-03-01 08:57:39',10,0),('1','281',365,'MORNING/AFTERNOON','2023-03-01','2023-03-02 04:02:29','2023-03-03 04:02:29','943',3542645.10,3542645.10,'943','2023-03-02 04:18:47','559','2023-03-02 08:12:03',10,0),('1','281',366,'MORNING/AFTERNOON','2023-03-02','2023-03-02 22:30:19','2023-03-03 22:30:19','943',7137801.60,7137801.60,'943','2023-03-03 10:23:48','559','2023-03-03 21:37:08',10,0),('1','281',367,'MORNING/AFTERNOON','2023-03-03','2023-03-03 21:50:05','2023-03-04 21:50:05','943',924362.70,924362.70,'943','2023-03-03 21:50:56','559','2023-03-04 13:44:05',10,0),('1','281',368,'Morning/Afternoon ','2023-03-04','2023-03-04 22:17:51','2023-03-05 22:17:51','943',1449943.60,1449943.60,'943','2023-03-04 22:21:50','559','2023-03-05 11:01:12',10,0),('1','281',369,'Morning/Afternoon ','2023-03-05','2023-03-05 21:05:18','2023-03-06 21:05:18','943',259823.20,259823.20,'943','2023-03-05 21:06:26','559','2023-03-06 09:46:33',10,0),('1','281',370,'MORNING/AFTERNOON','2023-03-06','2023-03-06 20:47:14','2023-03-07 20:47:14','943',2032852.60,2032852.60,'943','2023-03-06 20:51:09','559','2023-03-07 08:41:30',10,0),('1','281',371,'MORNING/AFTERNOON','2023-03-07','2023-03-07 22:29:41','2023-03-08 22:29:41','943',10376914.60,10376914.60,'943','2023-03-07 22:39:47','559','2023-03-08 10:40:40',10,0),('1','281',372,'Morning/Afternoon','2023-03-08','2023-03-08 21:26:43','2023-03-09 21:26:43','943',1002630.70,1002630.70,'943','2023-03-09 06:49:12','559','2023-03-09 16:20:50',10,0),('1','281',373,'MORNING/AFTERNOON','2023-03-09','2023-03-09 22:57:37','2023-03-10 22:57:37','943',6454544.10,6454544.10,'943','2023-03-10 08:28:06','559','2023-03-10 10:55:02',10,0),('1','281',374,'Morning/Afternoon','2023-03-10','2023-03-10 18:07:24','2023-03-11 18:07:24','943',0.00,0.00,'634','2023-03-11 08:20:48','634','2023-03-11 08:21:08',10,0),('1','281',375,'Morning/Afternoon  2','2023-03-10','2023-03-11 08:47:07','2023-03-12 08:47:07','943',8317390.00,8317390.00,'943','2023-03-11 09:15:56','559','2023-03-12 06:21:30',10,0),('1','281',376,'Morning/Afternoon','2023-03-11','2023-03-12 07:46:11','2023-03-13 07:46:11','943',8314237.30,8314237.30,'943','2023-03-12 08:09:06','559','2023-03-12 18:31:22',10,0),('1','281',377,'MORNING/AFTERNOON','2023-03-12','2023-03-12 23:04:43','2023-03-13 23:04:43','943',5812645.70,5812645.70,'943','2023-03-13 07:24:10','559','2023-03-13 08:18:03',10,0),('1','281',378,'Morning/Afternoon','2023-03-13','2023-03-13 20:43:05','2023-03-14 20:43:05','943',610178.40,610178.40,'943','2023-03-13 22:38:44','559','2023-03-14 11:52:29',10,0),('1','281',379,'MORNING/AFTERNOON','2023-03-14','2023-03-14 22:00:19','2023-03-15 22:00:19','943',7844954.10,7844954.10,'943','2023-03-14 22:20:35','559','2023-03-15 04:45:58',10,0),('1','281',380,'Morning/Afternoon','2023-03-15','2023-03-15 10:45:37','2023-03-16 10:45:37','943',3874133.00,3874133.00,'943','2023-03-15 23:36:50','634','2023-03-16 11:07:26',10,0),('1','281',381,'Morning/Afternoon','2023-03-16','2023-03-16 20:15:18','2023-03-17 20:15:18','943',9202913.90,9202913.90,'943','2023-03-16 20:31:15','559','2023-03-16 23:29:37',10,0),('1','281',382,'Morning/Afternoon','2023-03-17','2023-03-17 23:19:07','2023-03-18 23:19:07','943',0.00,0.00,'943','2023-03-18 13:31:50','559','2023-03-18 13:35:23',10,0),('1','281',383,'Morning/Afternoon  2','2023-03-17','2023-03-18 13:40:10','2023-03-19 13:40:10','943',14729766.60,14729766.60,'943','2023-03-19 08:20:22','559','2023-03-19 12:34:34',10,0),('1','281',384,'MORNING/AFTERNOON','2023-03-19','2023-03-19 22:22:33','2023-03-20 22:22:33','943',15039675.70,15039675.70,'943','2023-03-19 22:57:34','559','2023-03-20 08:18:25',10,0),('1','281',385,'MORNING/AFTERNOON','2023-03-20','2023-03-20 22:28:31','2023-03-21 22:28:31','943',1781128.40,1781128.40,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=5391 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','281','1','1',1,'1','1',70.58,70.65,0.07,12.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','1',2,'2','1',99.53,5152.12,5052.59,934729.15,0.00,0.00,0.00,0.00,0.00),('1','281','1','1',3,'3','1',115.10,3113.79,2998.69,554757.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','1',4,'4','1',109.14,2686.62,2577.48,476833.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','1',5,'5','1',100.29,4641.81,4541.52,840181.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','1',6,'6','1',85.88,910.04,824.16,152469.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','1',7,'7','1',57.15,356.78,299.63,55431.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','1',8,'8','1',50.61,3671.20,3620.59,669809.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','1',9,'9','1',81.32,4834.09,4752.77,879262.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','1',10,'10','1',176.89,610.59,433.70,80234.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','1',11,'11','1',39.66,4581.35,4541.69,840212.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','1',12,'12','1',103.67,104.04,0.37,68.45,0.00,0.00,0.00,0.00,0.00),('1','281','3','1',13,'13','2',61.00,61.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','1',14,'14','2',92.00,92.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','2',15,'1','1',70.65,6182.87,6091.73,1126970.05,0.00,0.00,20.49,0.00,0.00),('1','281','1','2',16,'2','1',5152.12,10975.44,5802.83,1073523.55,0.00,0.00,20.49,0.00,0.00),('1','281','1','2',17,'3','1',3113.79,8610.94,5497.15,1016972.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','2',18,'4','1',2686.62,7153.79,4467.17,826426.45,0.00,0.00,0.00,0.00,0.00),('1','281','1','2',19,'5','1',4641.81,10095.81,5454.00,1008990.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','2',20,'6','1',910.04,5899.93,4989.89,923129.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','2',21,'7','1',356.78,356.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','2',22,'8','1',3671.20,11815.02,8143.82,1506606.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','2',23,'9','1',4834.09,12079.67,7245.58,1340432.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','2',24,'10','1',610.59,4888.83,4278.24,791474.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','2',25,'11','1',4581.35,11658.80,7077.45,1309328.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','2',26,'12','1',104.04,4375.22,4271.18,790168.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','2',27,'13','2',61.00,61.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','2',28,'14','2',92.00,92.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','3',29,'1','1',6182.87,8991.96,2789.09,515981.65,0.00,0.00,20.00,0.00,0.00),('1','281','1','3',30,'2','1',10975.44,13769.90,2794.46,516975.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','3',31,'3','1',8610.94,14495.57,5884.63,1088656.55,0.00,0.00,0.00,0.00,0.00),('1','281','1','3',32,'4','1',7153.79,13143.43,5989.64,1108083.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','3',33,'5','1',10095.81,13290.06,3194.25,590936.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','3',34,'6','1',5899.93,8444.10,2544.17,470671.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','3',35,'7','1',356.78,361.65,4.87,900.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','3',36,'8','1',11815.02,20821.25,9006.23,1666152.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','3',37,'9','1',12079.67,15230.06,3150.39,582822.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','3',38,'10','1',4888.83,7466.70,2577.87,476905.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','3',39,'11','1',11658.80,18704.66,7045.86,1303484.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','3',40,'12','1',4375.22,9331.00,4955.78,916819.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','3',41,'13','2',61.00,61.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','3',42,'14','2',92.00,92.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','4',43,'1','1',8991.96,13345.90,4353.94,805478.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','4',44,'2','1',13769.90,17982.52,4212.62,779334.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','4',45,'3','1',14495.57,17853.44,3357.87,621205.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','4',46,'4','1',13143.43,16346.57,3203.14,592580.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','4',47,'5','1',13290.06,17861.72,4571.66,845757.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','4',48,'6','1',8444.10,11547.48,3103.38,574125.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','4',49,'7','1',361.65,361.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','4',50,'8','1',20821.25,27063.01,6241.76,1154725.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','4',51,'9','1',15230.06,20337.06,5107.00,944795.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','4',52,'10','1',7466.70,10037.22,2570.52,475546.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','4',53,'11','1',18704.66,23971.44,5266.78,974354.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','4',54,'12','1',9331.00,12230.95,2899.95,536490.75,0.00,0.00,0.00,0.00,0.00),('1','281','3','4',55,'13','2',61.00,61.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','4',56,'14','2',92.00,92.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','5',57,'1','1',13345.90,18937.23,5553.71,1027436.35,0.00,0.00,37.62,0.00,0.00),('1','281','1','5',58,'2','1',17982.52,23098.00,5115.48,946363.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','5',59,'3','1',17853.44,20978.79,3125.35,578189.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','5',60,'4','1',16346.57,19209.76,2863.19,529690.15,0.00,0.00,0.00,0.00,0.00),('1','281','1','5',61,'5','1',17861.72,23398.92,5537.20,1024382.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','5',62,'6','1',11547.48,15755.05,4207.57,778400.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','5',63,'7','1',361.65,399.27,37.62,6959.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','5',64,'8','1',27063.01,29790.61,2727.60,504606.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','5',65,'9','1',20337.06,25663.40,5326.34,985372.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','5',66,'10','1',10037.22,14233.15,4176.13,772584.05,0.00,0.00,19.80,0.00,0.00),('1','281','2','5',67,'11','1',23971.44,28299.22,4327.78,800639.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','5',68,'12','1',12230.95,14501.69,2270.74,420086.90,0.00,0.00,0.00,0.00,0.00),('1','281','3','5',69,'13','2',61.00,61.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','5',70,'14','2',92.00,92.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','6',71,'1','1',18937.23,22829.95,3882.72,718303.20,0.00,0.00,10.00,0.00,0.00),('1','281','1','6',72,'2','1',23098.00,26336.03,3238.03,599035.55,0.00,0.00,0.00,0.00,0.00),('1','281','1','6',73,'3','1',20978.79,27276.57,6297.78,1165089.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','6',74,'4','1',19209.76,24981.11,5771.35,1067699.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','6',75,'5','1',23398.92,23398.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','6',76,'6','1',15755.05,18341.92,2586.87,478570.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','6',77,'7','1',399.27,399.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','6',78,'8','1',29790.61,38053.18,8262.57,1528575.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','6',79,'9','1',25663.40,29253.25,3589.85,664122.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','6',80,'10','1',14233.15,16938.94,2705.79,500571.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','6',81,'11','1',28299.22,35530.18,7230.96,1337727.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','6',82,'12','1',14501.69,20363.09,5861.40,1084359.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','6',83,'13','2',61.00,61.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','6',84,'14','2',92.00,92.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','7',85,'1','1',22829.95,28093.00,5263.05,973664.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','7',86,'2','1',26336.03,30890.67,4554.64,842608.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','7',87,'3','1',27276.57,30671.44,3394.87,628050.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','7',88,'4','1',24981.11,28600.58,3619.47,669601.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','7',89,'5','1',23398.92,27642.08,4243.16,784984.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','7',90,'6','1',18341.92,22160.52,3818.60,706441.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','7',91,'7','1',399.27,399.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','7',92,'8','1',38053.18,44738.23,6685.05,1236734.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','7',93,'9','1',29253.25,32268.87,3015.62,557889.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','7',94,'10','1',16938.94,22653.57,5714.63,1057206.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','7',95,'11','1',35530.18,39847.93,4317.75,798783.75,0.00,0.00,0.00,0.00,0.00),('1','281','2','7',96,'12','1',20363.09,23120.38,2757.29,510098.65,0.00,0.00,0.00,0.00,0.00),('1','281','3','7',97,'13','2',61.00,61.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','7',98,'14','2',92.00,92.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','8',99,'1','1',28093.00,30708.22,2615.22,483815.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','8',100,'2','1',30890.67,32878.80,1988.13,367804.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','8',101,'3','1',30671.44,30671.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','8',102,'4','1',28600.58,28600.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','8',103,'5','1',27642.08,30098.72,2456.64,454478.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','8',104,'6','1',22160.52,24312.14,2151.62,398049.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','8',105,'7','1',399.27,399.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','8',106,'8','1',44738.23,44738.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','8',107,'9','1',32268.87,33860.27,1591.40,294409.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','8',108,'10','1',22653.57,25128.05,2474.48,457778.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','8',109,'11','1',39847.93,39847.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','8',110,'12','1',23120.38,23120.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','8',111,'13','2',61.00,61.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','8',112,'14','2',92.00,92.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','9',113,'1','1',30708.22,35811.98,5103.76,944195.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','9',114,'2','1',32878.80,32878.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','9',115,'3','1',30671.44,38102.78,7431.34,1374797.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','9',116,'4','1',28600.58,34115.63,5515.05,1020284.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','9',117,'5','1',30098.72,35012.14,4913.42,908982.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','9',118,'6','1',24312.14,24312.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','9',119,'7','1',399.27,399.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','9',120,'8','1',44738.23,53576.55,8838.32,1635089.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','9',121,'9','1',33860.27,36474.39,2614.12,483612.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','9',122,'10','1',25128.05,29333.19,4205.14,777950.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','9',123,'11','1',39847.93,45631.98,5784.05,1070049.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','9',124,'12','1',23120.38,28609.87,5489.49,1015555.65,0.00,0.00,0.00,0.00,0.00),('1','281','3','9',125,'13','2',61.00,61.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','9',126,'14','2',92.00,92.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','10',127,'1','1',35811.98,39901.36,4089.38,756535.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','10',128,'2','1',32878.80,37150.25,4271.45,790218.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','10',129,'3','1',38102.78,41729.41,3626.63,670926.55,0.00,0.00,0.00,0.00,0.00),('1','281','1','10',130,'4','1',34115.63,37306.77,3191.14,590360.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','10',131,'5','1',35012.14,35012.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','10',132,'6','1',24312.14,29489.54,5177.40,957819.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','10',133,'7','1',399.27,399.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','10',134,'8','1',53576.55,58085.56,4509.01,834166.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','10',135,'9','1',36474.39,38747.59,2273.20,420542.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','10',136,'10','1',29333.19,33483.46,4150.27,767799.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','10',137,'11','1',45631.98,50217.92,4585.94,848398.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','10',138,'12','1',28609.87,31889.11,3279.24,606659.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','10',139,'13','2',61.00,329.67,268.67,217622.70,0.00,0.00,0.00,0.00,0.00),('1','281','3','10',140,'14','2',92.00,184.00,92.00,74520.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','11',141,'1','1',39901.36,39901.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','11',142,'2','1',37150.25,37150.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','11',143,'3','1',41729.41,41729.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','11',144,'4','1',37306.77,37306.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','11',145,'5','1',35012.14,35012.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','11',146,'6','1',29489.54,29489.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','11',147,'7','1',399.27,399.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','11',148,'8','1',58085.56,58085.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','11',149,'9','1',38747.59,38747.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','11',150,'10','1',33483.46,33483.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','11',151,'11','1',50217.92,50217.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','11',152,'12','1',31889.11,31889.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','11',153,'13','2',329.67,612.86,283.19,229383.90,0.00,0.00,0.00,0.00,0.00),('1','281','3','11',154,'14','2',184.00,346.25,162.25,131422.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','12',155,'1','1',39901.36,43086.09,3184.73,589175.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','12',156,'2','1',37150.25,40289.64,3139.39,580787.15,0.00,0.00,0.00,0.00,0.00),('1','281','1','12',157,'3','1',41729.41,47316.62,5587.21,1033633.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','12',158,'4','1',37306.77,42571.52,5264.75,973978.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','12',159,'5','1',35012.14,37978.51,2966.37,548778.45,0.00,0.00,0.00,0.00,0.00),('1','281','1','12',160,'6','1',29489.54,31468.37,1978.83,366083.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','12',161,'7','1',399.27,399.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','12',162,'8','1',58085.56,66074.79,7989.23,1478007.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','12',163,'9','1',38747.59,39146.94,399.35,73879.75,0.00,0.00,0.00,0.00,0.00),('1','281','2','12',164,'10','1',33483.46,37015.40,3531.94,653408.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','12',165,'11','1',50217.92,56270.65,6052.73,1119755.05,0.00,0.00,0.00,0.00,0.00),('1','281','2','12',166,'12','1',31889.11,36883.65,4994.54,923989.90,0.00,0.00,0.00,0.00,0.00),('1','281','3','12',167,'13','2',612.86,862.35,249.49,202086.90,0.00,0.00,0.00,0.00,0.00),('1','281','3','12',168,'14','2',346.25,615.09,268.84,217760.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','13',169,'1','1',43086.09,46322.82,3236.73,598795.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','13',170,'2','1',40289.64,42631.55,2341.91,433253.35,0.00,0.00,0.00,0.00,0.00),('1','281','1','13',171,'3','1',47316.62,52515.40,5198.78,961774.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','13',172,'4','1',42571.52,47545.63,4974.11,920210.35,0.00,0.00,0.00,0.00,0.00),('1','281','1','13',173,'5','1',37978.51,40343.17,2364.66,437462.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','13',174,'6','1',31468.37,33818.62,2350.25,434796.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','13',175,'7','1',399.27,405.83,6.56,1213.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','13',176,'8','1',66074.79,73846.96,7772.17,1437851.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','13',177,'9','1',39146.94,40895.81,1748.87,323540.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','13',178,'10','1',37015.40,39950.36,2934.96,542967.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','13',179,'11','1',56270.65,63453.36,7182.71,1328801.35,0.00,0.00,0.00,0.00,0.00),('1','281','2','13',180,'12','1',36883.65,41807.18,4923.53,910853.05,0.00,0.00,0.00,0.00,0.00),('1','281','3','13',181,'13','2',862.35,1536.65,674.30,546183.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','13',182,'14','2',615.09,663.31,48.22,39058.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','14',183,'1','1',46322.82,51524.04,5201.22,962225.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','14',184,'2','1',42631.55,47977.41,5345.86,988984.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','14',185,'3','1',52515.40,52515.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','14',186,'4','1',47545.63,47545.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','14',187,'5','1',40343.17,44925.87,4582.70,847799.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','14',188,'6','1',33818.62,38438.77,4620.15,854727.75,0.00,0.00,0.00,0.00,0.00),('1','281','2','14',189,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','14',190,'8','1',73846.96,73846.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','14',191,'9','1',40895.81,46375.11,5479.30,1013670.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','14',192,'10','1',39950.36,44897.92,4947.56,915298.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','14',193,'11','1',63453.36,63453.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','14',194,'12','1',41807.18,41807.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','14',195,'13','2',1536.65,1593.85,57.20,46332.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','14',196,'14','2',663.31,663.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','15',197,'1','1',51524.04,51524.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','15',198,'2','1',47977.41,47977.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','15',199,'3','1',52515.40,52515.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','15',200,'4','1',47545.63,47545.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','15',201,'5','1',44925.87,44925.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','15',202,'6','1',38438.77,38438.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','15',203,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','15',204,'8','1',73846.96,73846.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','15',205,'9','1',46375.11,46375.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','15',206,'10','1',44897.92,44897.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','15',207,'11','1',63453.36,63453.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','15',208,'12','1',41807.18,41807.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','15',209,'13','2',1593.85,1885.94,292.09,236592.90,0.00,0.00,0.00,0.00,0.00),('1','281','3','15',210,'14','2',663.31,663.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','16',211,'1','1',51524.04,55896.60,4372.56,808923.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','16',212,'2','1',47977.41,53957.03,5979.62,1106229.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','16',213,'3','1',52515.40,54834.09,2318.69,428957.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','16',214,'4','1',47545.63,50218.13,2672.50,494412.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','16',215,'5','1',44925.87,50514.08,5588.21,1033818.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','16',216,'6','1',38438.77,42800.69,4361.92,806955.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','16',217,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','16',218,'8','1',73846.96,78192.18,4345.22,803865.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','16',219,'9','1',46375.11,53688.53,7313.42,1352982.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','16',220,'10','1',44897.92,47036.18,2138.26,395578.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','16',221,'11','1',63453.36,66792.23,3338.87,617690.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','16',222,'12','1',41807.18,44294.25,2487.07,460107.95,0.00,0.00,0.00,0.00,0.00),('1','281','3','16',223,'13','2',1885.94,2142.98,257.04,208202.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','16',224,'14','2',663.31,759.41,96.10,77841.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','17',225,'1','1',55896.60,58231.82,2335.22,432015.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','17',226,'2','1',53957.03,56327.80,2370.77,438592.45,0.00,0.00,0.00,0.00,0.00),('1','281','1','17',227,'3','1',54834.09,57055.97,2221.88,411047.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','17',228,'4','1',50218.13,51963.70,1745.57,322930.45,0.00,0.00,0.00,0.00,0.00),('1','281','1','17',229,'5','1',50514.08,52420.23,1906.15,352637.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','17',230,'6','1',42800.69,44703.59,1902.90,352036.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','17',231,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','17',232,'8','1',78192.18,81657.31,3465.13,641049.05,0.00,0.00,0.00,0.00,0.00),('1','281','2','17',233,'9','1',53688.53,56190.04,2501.51,462779.35,0.00,0.00,0.00,0.00,0.00),('1','281','2','17',234,'10','1',47036.18,48696.85,1660.67,307223.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','17',235,'11','1',66792.23,69172.80,2380.57,440405.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','17',236,'12','1',44294.25,45989.60,1695.35,313639.75,0.00,0.00,0.00,0.00,0.00),('1','281','3','17',237,'13','2',2142.98,2335.61,192.63,156030.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','17',238,'14','2',759.41,759.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','18',239,'1','1',58231.82,58231.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','18',240,'2','1',56327.80,56327.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','18',241,'3','1',57055.97,57055.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','18',242,'4','1',51963.70,51963.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','18',243,'5','1',52420.23,52420.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','18',244,'6','1',44703.59,44703.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','18',245,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','18',246,'8','1',81657.31,81657.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','18',247,'9','1',56190.04,56190.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','18',248,'10','1',48696.85,48696.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','18',249,'11','1',69172.80,69172.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','18',250,'12','1',45989.60,45989.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','18',251,'13','2',2335.61,2335.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','18',252,'14','2',759.41,759.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','19',253,'1','1',58231.82,62029.75,3797.93,702617.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','19',254,'2','1',56327.80,60071.06,3743.26,692503.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','19',255,'3','1',57055.97,61099.92,4043.95,748130.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','19',256,'4','1',51963.70,55696.34,3732.64,690538.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','19',257,'5','1',52420.23,55997.66,3577.43,661824.55,0.00,0.00,0.00,0.00,0.00),('1','281','1','19',258,'6','1',44703.59,48369.16,3665.57,678130.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','19',259,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','19',260,'8','1',81657.31,88215.69,6558.38,1213300.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','19',261,'9','1',56190.04,60516.21,4326.17,800341.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','19',262,'10','1',48696.85,51511.72,2814.87,520750.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','19',263,'11','1',69172.80,73265.50,4092.70,757149.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','19',264,'12','1',45989.60,50070.18,4080.58,754907.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','19',265,'13','2',2335.61,3859.28,1523.67,1218936.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','19',266,'14','2',759.41,1833.90,1074.49,859592.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','20',267,'1','1',62029.75,65181.11,3151.36,583001.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','20',268,'2','1',60071.06,64179.44,4108.38,760050.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','20',269,'3','1',61099.92,65641.07,4541.15,840112.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','20',270,'4','1',55696.34,59916.63,4220.29,780753.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','20',271,'5','1',55997.66,59732.55,3734.89,690954.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','20',272,'6','1',48369.16,52035.59,3666.43,678289.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','20',273,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','20',274,'8','1',88215.69,95196.59,6980.90,1291466.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','20',275,'9','1',60516.21,64373.70,3857.49,713635.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','20',276,'10','1',51511.72,54322.67,2810.95,520025.75,0.00,0.00,0.00,0.00,0.00),('1','281','2','20',277,'11','1',73265.50,79134.08,5868.58,1085687.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','20',278,'12','1',50070.18,54598.52,4528.34,837742.90,0.00,0.00,0.00,0.00,0.00),('1','281','3','20',279,'13','2',3859.28,4273.28,414.00,331200.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','20',280,'14','2',1833.90,1973.29,139.39,111512.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','21',281,'1','1',65181.11,70671.56,5490.45,1015733.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','21',282,'2','1',64179.44,68709.42,4529.98,838046.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','21',283,'3','1',65641.07,67473.95,1832.88,339082.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','21',284,'4','1',59916.63,61980.83,2064.20,381877.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','21',285,'5','1',59732.55,64672.42,4939.87,913875.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','21',286,'6','1',52035.59,55966.91,3931.32,727294.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','21',287,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','21',288,'8','1',95196.59,98789.01,3592.42,664597.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','21',289,'9','1',64373.70,69996.01,5622.31,1040127.35,0.00,0.00,0.00,0.00,0.00),('1','281','2','21',290,'10','1',54322.67,59944.52,5621.85,1040042.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','21',291,'11','1',79134.08,81246.17,2112.09,390736.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','21',292,'12','1',54598.52,56402.69,1804.17,333771.45,0.00,0.00,0.00,0.00,0.00),('1','281','3','21',293,'13','2',4273.28,5106.84,833.56,666848.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','21',294,'14','2',1973.29,2144.72,171.43,137144.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','22',295,'1','1',70671.56,74337.51,3665.95,678200.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','22',296,'2','1',68709.42,71821.87,3112.45,575803.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','22',297,'3','1',67473.95,70386.10,2912.15,538747.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','22',298,'4','1',61980.83,64971.71,2990.88,553312.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','22',299,'5','1',64672.42,67696.83,3024.41,559515.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','22',300,'6','1',55966.91,59176.72,3209.81,593814.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','22',301,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','22',302,'8','1',98789.01,104372.74,5583.73,1032990.05,0.00,0.00,0.00,0.00,0.00),('1','281','2','22',303,'9','1',69996.01,74400.99,4404.98,814921.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','22',304,'10','1',59944.52,63252.31,3307.79,611941.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','22',305,'11','1',81246.17,85644.66,4398.49,813720.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','22',306,'12','1',56402.69,59630.30,3227.61,597107.85,0.00,0.00,0.00,0.00,0.00),('1','281','3','22',307,'13','2',5106.84,5673.84,567.00,453600.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','22',308,'14','2',2144.72,2778.24,633.52,506816.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','23',309,'1','1',74337.51,76463.57,2126.06,393321.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','23',310,'2','1',71821.87,74018.68,2196.81,406409.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','23',311,'3','1',70386.10,71436.71,1050.61,194362.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','23',312,'4','1',64971.71,66970.28,1998.57,369735.45,0.00,0.00,0.00,0.00,0.00),('1','281','1','23',313,'5','1',67696.83,69412.53,1715.70,317404.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','23',314,'6','1',59176.72,60687.08,1510.36,279416.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','23',315,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','23',316,'8','1',104372.74,108138.28,3765.54,696624.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','23',317,'9','1',74400.99,76696.42,2295.43,424654.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','23',318,'10','1',63252.31,65092.53,1840.22,340440.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','23',319,'11','1',85644.66,88681.58,3036.92,561830.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','23',320,'12','1',59630.30,61623.70,1993.40,368779.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','23',321,'13','2',5673.84,5919.14,245.30,196240.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','23',322,'14','2',2778.24,2838.28,60.04,48032.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','24',323,'1','1',76463.57,78590.66,2127.09,393511.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','24',324,'2','1',74018.68,76455.12,2436.44,450741.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','24',325,'3','1',71436.71,73141.10,1704.39,315312.15,0.00,0.00,0.00,0.00,0.00),('1','281','1','24',326,'4','1',66970.28,68963.12,1992.84,368675.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','24',327,'5','1',69412.53,71739.37,2326.84,430465.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','24',328,'6','1',60687.08,61903.08,1216.00,224960.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','24',329,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','24',330,'8','1',108138.28,111259.83,3121.55,577486.75,0.00,0.00,0.00,0.00,0.00),('1','281','2','24',331,'9','1',76696.42,76862.64,166.22,30750.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','24',332,'10','1',65092.53,68232.94,3140.41,580975.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','24',333,'11','1',88681.58,89183.02,501.44,92766.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','24',334,'12','1',61623.70,64440.08,2816.38,521030.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','24',335,'13','2',5919.14,6377.99,458.85,367080.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','24',336,'14','2',2838.28,2838.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','25',337,'1','1',78590.66,81193.99,2603.33,481616.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','25',338,'2','1',76455.12,78693.12,2238.00,414030.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','25',339,'3','1',73141.10,74756.47,1615.37,298843.45,0.00,0.00,0.00,0.00,0.00),('1','281','1','25',340,'4','1',68963.12,70968.74,2005.62,371039.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','25',341,'5','1',71739.37,73944.19,2204.82,407891.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','25',342,'6','1',61903.08,63917.29,2014.21,372628.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','25',343,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','25',344,'8','1',111259.83,114369.64,3109.81,575314.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','25',345,'9','1',76862.64,79242.30,2379.66,440237.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','25',346,'10','1',68232.94,69869.64,1636.70,302789.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','25',347,'11','1',89183.02,91938.75,2755.73,509810.05,0.00,0.00,0.00,0.00,0.00),('1','281','2','25',348,'12','1',64440.08,66813.93,2373.85,439162.25,0.00,0.00,0.00,0.00,0.00),('1','281','3','25',349,'13','2',6377.99,6616.11,238.12,190496.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','25',350,'14','2',2838.28,2838.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','26',351,'1','1',81193.99,82399.54,1205.55,223026.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','26',352,'2','1',78693.12,79770.54,1077.42,199322.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','26',353,'3','1',74756.47,75895.14,1138.67,210653.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','26',354,'4','1',70968.74,73466.27,2497.53,462043.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','26',355,'5','1',73944.19,73944.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','26',356,'6','1',63917.29,65041.55,1124.26,207988.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','26',357,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','26',358,'8','1',114369.64,117151.27,2781.63,514601.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','26',359,'9','1',79242.30,80127.85,885.55,163826.75,0.00,0.00,0.00,0.00,0.00),('1','281','2','26',360,'10','1',69869.64,71144.23,1274.59,235799.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','26',361,'11','1',91938.75,92744.06,805.31,148982.35,0.00,0.00,0.00,0.00,0.00),('1','281','2','26',362,'12','1',66813.93,69611.47,2797.54,517544.90,0.00,0.00,0.00,0.00,0.00),('1','281','3','26',363,'13','2',6616.11,8334.93,1718.82,1375056.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','26',364,'14','2',2838.28,2838.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','27',365,'1','1',82399.54,82399.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','27',366,'2','1',79770.54,79770.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','27',367,'3','1',75895.14,78512.12,2616.98,484141.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','27',368,'4','1',73466.27,76415.01,2948.74,545516.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','27',369,'5','1',73944.19,73944.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','27',370,'6','1',65041.55,65041.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','27',371,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','27',372,'8','1',117151.27,120083.14,2931.87,542395.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','27',373,'9','1',80127.85,80127.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','27',374,'10','1',71144.23,71144.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','27',375,'11','1',92744.06,95406.78,2662.72,492603.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','27',376,'12','1',69611.47,71507.34,1895.87,350735.95,0.00,0.00,0.00,0.00,0.00),('1','281','3','27',377,'13','2',8334.93,8441.45,106.52,85216.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','27',378,'14','2',2838.28,2838.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','28',379,'1','1',82399.54,83066.30,666.76,123350.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','28',380,'2','1',79770.54,80979.03,1208.49,223570.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','28',381,'3','1',78512.12,78512.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','28',382,'4','1',76415.01,77140.62,725.61,134237.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','28',383,'5','1',73944.19,74532.15,587.96,108772.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','28',384,'6','1',65041.55,66624.41,1582.86,292829.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','28',385,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','28',386,'8','1',120083.14,120791.87,708.73,131115.05,0.00,0.00,0.00,0.00,0.00),('1','281','2','28',387,'9','1',80127.85,80875.81,747.96,138372.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','28',388,'10','1',71144.23,72413.40,1269.17,234796.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','28',389,'11','1',95406.78,95971.32,564.54,104439.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','28',390,'12','1',71507.34,71507.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','28',391,'13','2',8441.45,9169.72,728.27,582616.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','28',392,'14','2',2838.28,2903.92,65.64,52512.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','29',393,'1','1',83066.30,84984.21,1917.91,354813.35,0.00,0.00,0.00,0.00,0.00),('1','281','1','29',394,'2','1',80979.03,82663.04,1684.01,311541.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','29',395,'3','1',78512.12,81077.95,2565.83,474678.55,0.00,0.00,0.00,0.00,0.00),('1','281','1','29',396,'4','1',77140.62,79369.18,2228.56,412283.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','29',397,'5','1',74532.15,75506.78,974.63,180306.55,0.00,0.00,0.00,0.00,0.00),('1','281','1','29',398,'6','1',66624.41,68376.18,1751.77,324077.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','29',399,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','29',400,'8','1',120791.87,124478.46,3686.59,682019.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','29',401,'9','1',80875.81,83033.61,2157.80,399193.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','29',402,'10','1',72413.40,73971.61,1558.21,288268.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','29',403,'11','1',95971.32,98716.24,2744.92,507810.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','29',404,'12','1',71507.34,73589.63,2082.29,385223.65,0.00,0.00,0.00,0.00,0.00),('1','281','3','29',405,'13','2',9169.72,9171.72,2.00,1600.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','29',406,'14','2',2903.92,2903.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','30',407,'1','1',84984.21,84984.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','30',408,'2','1',82663.04,83057.05,394.01,72891.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','30',409,'3','1',81077.95,84318.90,3240.95,599575.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','30',410,'4','1',79369.18,82560.12,3190.94,590323.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','30',411,'5','1',75506.78,75732.34,225.56,41728.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','30',412,'6','1',68376.18,68614.07,237.89,44009.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','30',413,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','30',414,'8','1',124478.46,129223.11,4744.65,877760.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','30',415,'9','1',83033.61,83103.93,70.32,13009.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','30',416,'10','1',73971.61,74227.50,255.89,47339.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','30',417,'11','1',98716.24,102031.01,3314.77,613232.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','30',418,'12','1',73589.63,76391.85,2802.22,518410.70,0.00,0.00,0.00,0.00,0.00),('1','281','3','30',419,'13','2',9171.72,10121.74,950.02,760016.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','30',420,'14','2',2903.92,3030.92,127.00,101600.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','31',421,'1','1',84984.21,87494.90,2510.69,464477.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','31',422,'2','1',83057.05,85375.64,2318.59,428939.15,0.00,0.00,0.00,0.00,0.00),('1','281','1','31',423,'3','1',84318.90,86512.85,2193.95,405880.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','31',424,'4','1',82560.12,84281.58,1721.46,318470.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','31',425,'5','1',75732.34,76205.10,472.76,87460.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','31',426,'6','1',68614.07,71680.72,3066.65,567330.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','31',427,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','31',428,'8','1',129223.11,132099.65,2876.54,532159.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','31',429,'9','1',83103.93,85658.01,2554.08,472504.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','31',430,'10','1',74227.50,76079.94,1852.44,342701.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','31',431,'11','1',102031.01,104057.42,2026.41,374885.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','31',432,'12','1',76391.85,78672.46,2280.61,421912.85,0.00,0.00,0.00,0.00,0.00),('1','281','3','31',433,'13','2',10121.74,10277.75,156.01,124808.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','31',434,'14','2',3030.92,3030.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','32',435,'1','1',87494.90,89195.66,1700.76,314640.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','32',436,'2','1',85375.64,87527.05,2151.41,398010.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','32',437,'3','1',86512.85,87609.48,1096.63,202876.55,0.00,0.00,0.00,0.00,0.00),('1','281','1','32',438,'4','1',84281.58,85915.89,1634.31,302347.35,0.00,0.00,0.00,0.00,0.00),('1','281','1','32',439,'5','1',76205.10,77885.86,1680.76,310940.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','32',440,'6','1',71680.72,73558.75,1878.03,347435.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','32',441,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','32',442,'8','1',132099.65,133857.13,1757.48,325133.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','32',443,'9','1',85658.01,87283.94,1625.93,300797.05,0.00,0.00,0.00,0.00,0.00),('1','281','2','32',444,'10','1',76079.94,78434.65,2354.71,435621.35,0.00,0.00,0.00,0.00,0.00),('1','281','2','32',445,'11','1',104057.42,105993.31,1935.89,358139.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','32',446,'12','1',78672.46,79501.99,829.53,153463.05,0.00,0.00,0.00,0.00,0.00),('1','281','3','32',447,'13','2',10277.75,10345.92,68.17,54536.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','32',448,'14','2',3030.92,3030.94,0.02,16.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','33',449,'1','1',89195.66,91345.40,2149.74,397701.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','33',450,'2','1',87527.05,89524.01,1996.96,369437.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','33',451,'3','1',87609.48,87661.44,51.96,9612.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','33',452,'4','1',85915.89,88350.64,2434.75,450428.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','33',453,'5','1',77885.86,80095.44,2209.58,408772.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','33',454,'6','1',73558.75,75146.64,1587.89,293759.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','33',455,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','33',456,'8','1',133857.13,137067.98,3210.85,594007.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','33',457,'9','1',87283.94,89449.80,2165.86,400684.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','33',458,'10','1',78434.65,80531.31,2096.66,387882.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','33',459,'11','1',105993.31,108302.85,2309.54,427264.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','33',460,'12','1',79501.99,81474.59,1972.60,364931.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','33',461,'13','2',10345.92,10499.78,153.86,123088.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','33',462,'14','2',3030.94,3030.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','34',463,'1','1',91345.40,93434.95,2089.55,386566.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','34',464,'2','1',89524.01,91536.77,2012.76,372360.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','34',465,'3','1',87661.44,88446.93,785.49,145315.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','34',466,'4','1',88350.64,90702.79,2352.15,435147.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','34',467,'5','1',80095.44,80095.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','34',468,'6','1',75146.64,77980.12,2833.48,524193.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','34',469,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','34',470,'8','1',137067.98,140593.48,3525.50,652217.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','34',471,'9','1',89449.80,91218.52,1768.72,327213.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','34',472,'10','1',80531.31,82383.68,1852.37,342688.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','34',473,'11','1',108302.85,110380.91,2078.06,384441.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','34',474,'12','1',81474.59,83333.70,1859.11,343935.35,0.00,0.00,0.00,0.00,0.00),('1','281','3','34',475,'13','2',10499.78,11198.05,698.27,558616.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','34',476,'14','2',3030.94,3030.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','35',477,'1','1',93434.95,95224.43,1789.48,331053.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','35',478,'2','1',91536.77,93247.81,1711.04,316542.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','35',479,'3','1',88446.93,89733.02,1286.09,237926.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','35',480,'4','1',90702.79,91675.11,972.32,179879.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','35',481,'5','1',80095.44,81725.54,1630.10,301568.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','35',482,'6','1',77980.12,79355.40,1375.28,254426.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','35',483,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','35',484,'8','1',140593.48,143669.38,3075.90,569041.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','35',485,'9','1',91218.52,93023.41,1804.89,333904.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','35',486,'10','1',82383.68,83908.11,1524.43,282019.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','35',487,'11','1',110380.91,112559.20,2178.29,402983.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','35',488,'12','1',83333.70,84906.08,1572.38,290890.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','35',489,'13','2',11198.05,11201.80,3.75,3000.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','35',490,'14','2',3030.94,3030.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','36',491,'1','1',95224.43,97671.46,2447.03,452700.55,0.00,0.00,0.00,0.00,0.00),('1','281','1','36',492,'2','1',93247.81,95559.62,2311.81,427684.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','36',493,'3','1',89733.02,89733.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','36',494,'4','1',91675.11,94136.43,2461.32,455344.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','36',495,'5','1',81725.54,83495.62,1770.08,327464.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','36',496,'6','1',79355.40,81532.99,2177.59,402854.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','36',497,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','36',498,'8','1',143669.38,146341.24,2671.86,494294.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','36',499,'9','1',93023.41,93720.33,696.92,128930.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','36',500,'10','1',83908.11,86687.37,2779.26,514163.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','36',501,'11','1',112559.20,112559.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','36',502,'12','1',84906.08,87664.51,2758.43,510309.55,0.00,0.00,0.00,0.00,0.00),('1','281','3','36',503,'13','2',11201.80,11563.92,362.12,289696.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','36',504,'14','2',3030.94,3030.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','37',505,'1','1',97671.46,99483.32,1811.86,335194.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','37',506,'2','1',95559.62,97307.85,1748.23,323422.55,0.00,0.00,0.00,0.00,0.00),('1','281','1','37',507,'3','1',89733.02,91142.30,1409.28,260716.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','37',508,'4','1',94136.43,97926.11,3789.68,701090.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','37',509,'5','1',83495.62,85355.58,1859.96,344092.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','37',510,'6','1',81532.99,83086.15,1553.16,287334.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','37',511,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','37',512,'8','1',146341.24,150767.45,4426.21,818848.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','37',513,'9','1',93720.33,95679.09,1958.76,362370.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','37',514,'10','1',86687.37,87923.39,1236.02,228663.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','37',515,'11','1',112559.20,114062.71,1503.51,278149.35,0.00,0.00,0.00,0.00,0.00),('1','281','2','37',516,'12','1',87664.51,90827.82,3163.31,585212.35,0.00,0.00,0.00,0.00,0.00),('1','281','3','37',517,'13','2',11563.92,11754.35,190.43,152344.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','37',518,'14','2',3030.94,3030.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','38',519,'1','1',99483.32,99698.49,215.17,39806.45,0.00,0.00,0.00,0.00,0.00),('1','281','1','38',520,'2','1',97307.85,97424.89,117.04,21652.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','38',521,'3','1',91142.30,93299.99,2157.69,399172.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','38',522,'4','1',97926.11,99912.78,1986.67,367533.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','38',523,'5','1',85355.58,85355.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','38',524,'6','1',83086.15,83319.91,233.76,43245.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','38',525,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','38',526,'8','1',150767.45,153812.70,3045.25,563371.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','38',527,'9','1',95679.09,95784.50,105.41,19500.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','38',528,'10','1',87923.39,88158.02,234.63,43406.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','38',529,'11','1',114062.71,116055.14,1992.43,368599.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','38',530,'12','1',90827.82,92502.60,1674.78,309834.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','38',531,'13','2',11754.35,12035.08,280.73,224584.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','38',532,'14','2',3030.94,3030.96,0.02,16.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','39',533,'1','1',99698.49,99698.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','39',534,'2','1',97424.89,101492.00,4067.11,752415.35,0.00,0.00,0.00,0.00,0.00),('1','281','1','39',535,'3','1',93299.99,95300.15,2000.16,370029.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','39',536,'4','1',99912.78,102191.21,2278.43,421509.55,0.00,0.00,0.00,0.00,0.00),('1','281','1','39',537,'5','1',85355.58,85569.62,214.04,39597.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','39',538,'6','1',83319.91,86973.14,3653.23,675847.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','39',539,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','39',540,'8','1',153812.70,157200.42,3387.72,626728.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','39',541,'9','1',95784.50,96084.47,299.97,55494.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','39',542,'10','1',88158.02,91631.23,3473.21,642543.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','39',543,'11','1',116055.14,118433.41,2378.27,439979.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','39',544,'12','1',92502.60,95083.44,2580.84,477455.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','39',545,'13','2',12035.08,12060.11,25.03,20024.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','39',546,'14','2',3030.96,3030.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','40',547,'1','1',99698.49,102981.62,3283.13,607379.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','40',548,'2','1',101492.00,104500.08,3008.08,556494.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','40',549,'3','1',95300.15,95300.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','40',550,'4','1',102191.21,102191.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','40',551,'5','1',85569.62,88823.80,3254.18,602023.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','40',552,'6','1',86973.14,89843.91,2870.77,531092.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','40',553,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','40',554,'8','1',157200.42,157200.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','40',555,'9','1',96084.47,98795.55,2711.08,501549.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','40',556,'10','1',91631.23,94719.31,3088.08,571294.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','40',557,'11','1',118433.41,118433.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','40',558,'12','1',95083.44,95083.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','40',559,'13','2',12060.11,12080.14,20.03,16024.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','40',560,'14','2',3030.96,3145.27,114.31,91448.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','41',561,'1','1',102981.62,105638.39,2656.77,491502.45,0.00,0.00,0.00,0.00,0.00),('1','281','1','41',562,'2','1',104500.08,107290.90,2790.82,516301.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','41',563,'3','1',95300.15,95300.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','41',564,'4','1',102191.21,105375.91,3184.70,589169.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','41',565,'5','1',88823.80,90591.58,1767.78,327039.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','41',566,'6','1',89843.91,92313.38,2469.47,456851.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','41',567,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','41',568,'8','1',157200.42,161021.19,3820.77,706842.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','41',569,'9','1',98795.55,101279.04,2483.49,459445.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','41',570,'10','1',94719.31,97374.25,2634.94,487463.90,0.00,0.00,20.00,0.00,0.00),('1','281','2','41',571,'11','1',118433.41,118433.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','41',572,'12','1',95083.44,99092.25,4008.81,741629.85,0.00,0.00,0.00,0.00,0.00),('1','281','3','41',573,'13','2',12080.14,13065.77,985.63,788504.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','41',574,'14','2',3145.27,3145.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','42',575,'1','1',105638.39,106791.23,1152.84,213275.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','42',576,'2','1',107290.90,107964.09,673.19,124540.15,0.00,0.00,0.00,0.00,0.00),('1','281','1','42',577,'3','1',95300.15,97430.51,2130.36,394116.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','42',578,'4','1',105375.91,107615.48,2239.57,414320.45,0.00,0.00,0.00,0.00,0.00),('1','281','1','42',579,'5','1',90591.58,91046.94,455.36,84241.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','42',580,'6','1',92313.38,93511.01,1197.63,221561.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','42',581,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','42',582,'8','1',161021.19,164341.25,3320.06,614211.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','42',583,'9','1',101279.04,102280.98,1001.94,185358.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','42',584,'10','1',97374.25,97969.43,595.18,110108.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','42',585,'11','1',118433.41,120530.54,2097.13,387969.05,0.00,0.00,0.00,0.00,0.00),('1','281','2','42',586,'12','1',99092.25,101152.25,2060.00,381100.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','42',587,'13','2',13065.77,13266.57,200.80,160640.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','42',588,'14','2',3145.27,3162.90,17.63,14104.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','43',589,'1','1',106791.23,109315.78,2524.55,467041.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','43',590,'2','1',107964.09,110689.80,2725.71,504256.35,0.00,0.00,0.00,0.00,0.00),('1','281','1','43',591,'3','1',97430.51,97430.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','43',592,'4','1',107615.48,110526.57,2911.09,538551.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','43',593,'5','1',91046.94,94831.52,3784.58,700147.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','43',594,'6','1',93511.01,97667.25,4156.24,768904.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','43',595,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','43',596,'8','1',164341.25,167899.32,3558.07,658242.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','43',597,'9','1',102280.98,104885.28,2604.30,481795.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','43',598,'10','1',97969.43,100382.76,2413.33,446466.05,0.00,0.00,0.00,0.00,0.00),('1','281','2','43',599,'11','1',120530.54,123813.80,3283.26,607403.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','43',600,'12','1',101152.25,103430.43,2278.18,421463.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','43',601,'13','2',13266.57,13266.60,0.03,24.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','43',602,'14','2',3162.90,3228.81,65.91,52728.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','44',603,'1','1',109315.78,110955.41,1639.63,303331.55,0.00,0.00,0.00,0.00,0.00),('1','281','1','44',604,'2','1',110689.80,112323.67,1633.87,302265.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','44',605,'3','1',97430.51,99544.62,2114.11,391110.35,0.00,0.00,0.00,0.00,0.00),('1','281','1','44',606,'4','1',110526.57,112066.98,1540.41,284975.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','44',607,'5','1',94831.52,96175.48,1343.96,248632.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','44',608,'6','1',97667.25,99250.49,1583.24,292899.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','44',609,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','44',610,'8','1',167899.32,171320.55,3421.23,632927.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','44',611,'9','1',104885.28,106715.04,1829.76,338505.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','44',612,'10','1',100382.76,101871.43,1488.67,275403.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','44',613,'11','1',123813.80,125357.43,1543.63,285571.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','44',614,'12','1',103430.43,105690.19,2259.76,418055.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','44',615,'13','2',13266.60,13306.23,39.63,31704.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','44',616,'14','2',3228.81,3228.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','45',617,'1','1',110955.41,114084.96,3129.55,578966.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','45',618,'2','1',112323.67,115602.30,3278.63,606546.55,0.00,0.00,0.00,0.00,0.00),('1','281','1','45',619,'3','1',99544.62,99544.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','45',620,'4','1',112066.98,115753.10,3686.12,681932.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','45',621,'5','1',96175.48,98537.05,2361.57,436890.45,0.00,0.00,0.00,0.00,0.00),('1','281','1','45',622,'6','1',99250.49,101704.52,2454.03,453995.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','45',623,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','45',624,'8','1',171320.55,175221.81,3901.26,721733.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','45',625,'9','1',106715.04,106780.71,65.67,12148.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','45',626,'10','1',101871.43,105366.41,3494.98,646571.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','45',627,'11','1',125357.43,125357.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','45',628,'12','1',105690.19,109357.69,3667.50,678487.50,0.00,0.00,0.00,0.00,0.00),('1','281','3','45',629,'13','2',13306.23,15011.26,1705.03,1364024.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','45',630,'14','2',3228.81,3520.22,291.41,233128.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','46',631,'1','1',114084.96,116427.40,2342.44,433351.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','46',632,'2','1',115602.30,117936.62,2334.32,431849.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','46',633,'3','1',99544.62,101056.13,1511.51,279629.35,0.00,0.00,0.00,0.00,0.00),('1','281','1','46',634,'4','1',115753.10,117031.44,1278.34,236492.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','46',635,'5','1',98537.05,100597.12,2060.07,381112.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','46',636,'6','1',101704.52,104241.17,2536.65,469280.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','46',637,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','46',638,'8','1',175221.81,177616.62,2394.81,443039.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','46',639,'9','1',106780.71,109463.41,2682.70,496299.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','46',640,'10','1',105366.41,106595.77,1229.36,227431.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','46',641,'11','1',125357.43,127157.46,1800.03,333005.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','46',642,'12','1',109357.69,110669.15,1311.46,242620.10,0.00,0.00,0.00,0.00,0.00),('1','281','3','46',643,'13','2',15011.26,15229.67,218.41,174728.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','46',644,'14','2',3520.22,3520.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','47',645,'1','1',116427.40,116519.80,92.40,17094.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','47',646,'2','1',117936.62,118793.56,856.94,158533.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','47',647,'3','1',101056.13,104468.69,3412.56,631323.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','47',648,'4','1',117031.44,120532.51,3501.07,647697.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','47',649,'5','1',100597.12,100597.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','47',650,'6','1',104241.17,105040.55,799.38,147885.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','47',651,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','47',652,'8','1',177616.62,182788.97,5172.35,956884.75,0.00,0.00,0.00,0.00,0.00),('1','281','2','47',653,'9','1',109463.41,109463.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','47',654,'10','1',106595.77,107230.23,634.46,117375.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','47',655,'11','1',127157.46,131033.10,3875.64,716993.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','47',656,'12','1',110669.15,114009.88,3340.73,618035.05,0.00,0.00,0.00,0.00,0.00),('1','281','3','47',657,'13','2',15229.67,15429.80,200.13,160104.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','47',658,'14','2',3520.22,3520.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','48',659,'1','1',116519.80,118688.15,2168.35,401144.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','48',660,'2','1',118793.56,121689.29,2895.73,535710.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','48',661,'3','1',104468.69,105092.38,623.69,115382.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','48',662,'4','1',120532.51,122635.71,2103.20,389092.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','48',663,'5','1',100597.12,102613.61,2016.49,373050.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','48',664,'6','1',105040.55,107111.07,2070.52,383046.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','48',665,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','48',666,'8','1',182788.97,185476.46,2687.49,497185.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','48',667,'9','1',109463.41,111363.17,1899.76,351455.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','48',668,'10','1',107230.23,109561.13,2330.90,431216.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','48',669,'11','1',131033.10,133317.57,2284.47,422626.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','48',670,'12','1',114009.88,115943.75,1933.87,357765.95,0.00,0.00,0.00,0.00,0.00),('1','281','3','48',671,'13','2',15429.80,15939.38,509.58,407664.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','48',672,'14','2',3520.22,3520.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','49',673,'1','1',118688.15,120934.53,2246.38,415580.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','49',674,'2','1',121689.29,124057.23,2367.94,438068.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','49',675,'3','1',105092.38,105140.57,48.19,8915.15,0.00,0.00,0.00,0.00,0.00),('1','281','1','49',676,'4','1',122635.71,125064.86,2429.15,449392.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','49',677,'5','1',102613.61,102613.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','49',678,'6','1',107111.07,109526.96,2415.89,446939.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','49',679,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','49',680,'8','1',185476.46,189050.12,3573.66,661127.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','49',681,'9','1',111363.17,111363.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','49',682,'10','1',109561.13,112922.94,3361.81,621934.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','49',683,'11','1',133317.57,133317.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','49',684,'12','1',115943.75,119025.59,3081.84,570140.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','49',685,'13','2',15939.38,16908.10,968.72,774976.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','49',686,'14','2',3520.22,3548.34,28.12,22496.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','50',687,'1','1',120934.53,122876.95,1942.42,359347.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','50',688,'2','1',124057.23,126855.05,2797.82,517596.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','50',689,'3','1',105140.57,106665.15,1524.58,282047.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','50',690,'4','1',125064.86,126739.82,1674.96,309867.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','50',691,'5','1',102613.61,104532.77,1919.16,355044.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','50',692,'6','1',109526.96,111054.38,1527.42,282572.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','50',693,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','50',694,'8','1',189050.12,192349.36,3299.24,610359.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','50',695,'9','1',111363.17,113649.93,2286.76,423050.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','50',696,'10','1',112922.94,114190.62,1267.68,234520.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','50',697,'11','1',133317.57,135479.87,2162.30,400025.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','50',698,'12','1',119025.59,120949.94,1924.35,356004.75,0.00,0.00,0.00,0.00,0.00),('1','281','3','50',699,'13','2',16908.10,17363.68,455.58,364464.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','50',700,'14','2',3548.34,3548.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','51',701,'1','1',122876.95,125744.30,2867.35,530459.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','51',702,'2','1',126855.05,129364.69,2509.64,464283.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','51',703,'3','1',106665.15,108137.08,1471.93,272307.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','51',704,'4','1',126739.82,129244.94,2505.12,463447.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','51',705,'5','1',104532.77,106451.51,1918.74,354966.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','51',706,'6','1',111054.38,113448.43,2394.05,442899.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','51',707,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','51',708,'8','1',192349.36,194899.31,2549.95,471740.75,0.00,0.00,0.00,0.00,0.00),('1','281','2','51',709,'9','1',113649.93,115742.73,2092.80,387168.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','51',710,'10','1',114190.62,116066.83,1876.21,347098.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','51',711,'11','1',135479.87,137834.35,2354.48,435578.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','51',712,'12','1',120949.94,123352.12,2402.18,444403.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','51',713,'13','2',17363.68,17569.78,206.10,164880.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','51',714,'14','2',3548.34,3588.07,39.73,31784.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','52',715,'1','1',125744.30,127477.31,1723.01,318756.85,0.00,0.00,10.00,0.00,0.00),('1','281','1','52',716,'2','1',129364.69,132626.24,3251.55,601536.75,0.00,0.00,10.00,0.00,0.00),('1','281','1','52',717,'3','1',108137.08,108877.90,730.82,135201.70,0.00,0.00,10.00,0.00,0.00),('1','281','1','52',718,'4','1',129244.94,132426.14,3171.20,586672.00,0.00,0.00,10.00,0.00,0.00),('1','281','1','52',719,'5','1',106451.51,108516.00,2054.49,380080.65,0.00,0.00,10.00,0.00,0.00),('1','281','1','52',720,'6','1',113448.43,117420.60,3962.17,733001.45,0.00,0.00,10.00,0.00,0.00),('1','281','2','52',721,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','52',722,'8','1',194899.31,198319.55,3408.96,630657.60,0.00,0.00,11.28,0.00,0.00),('1','281','2','52',723,'9','1',115742.73,118243.28,2480.55,458901.75,0.00,0.00,20.00,0.00,0.00),('1','281','2','52',724,'10','1',116066.83,118147.62,2070.79,383096.15,0.00,0.00,10.00,0.00,0.00),('1','281','2','52',725,'11','1',137834.35,139237.56,1393.21,257743.85,0.00,0.00,10.00,0.00,0.00),('1','281','2','52',726,'12','1',123352.12,125490.42,2128.30,393735.50,0.00,0.00,10.00,0.00,0.00),('1','281','3','52',727,'13','2',17569.78,17599.81,30.03,24024.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','52',728,'14','2',3588.07,4601.32,1013.25,810600.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','53',729,'1','1',127477.31,130105.32,2628.01,486181.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','53',730,'2','1',132626.24,134767.40,2141.16,396114.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','53',731,'3','1',108877.90,108877.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','53',732,'4','1',132426.14,135720.35,3294.21,609428.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','53',733,'5','1',108516.00,110957.55,2441.55,451686.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','53',734,'6','1',117420.60,119785.63,2365.03,437530.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','53',735,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','53',736,'8','1',198319.55,201713.33,3393.78,627849.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','53',737,'9','1',118243.28,120436.06,2192.78,405664.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','53',738,'10','1',118147.62,119906.50,1758.88,325392.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','53',739,'11','1',139237.56,142157.62,2920.06,540211.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','53',740,'12','1',125490.42,127693.99,2203.57,407660.45,0.00,0.00,0.00,0.00,0.00),('1','281','3','53',741,'13','2',17599.81,17671.81,72.00,57600.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','53',742,'14','2',4601.32,4601.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','54',743,'1','1',130105.32,132619.33,2504.01,463241.85,0.00,0.00,10.00,0.00,0.00),('1','281','1','54',744,'2','1',134767.40,136844.58,2077.18,384278.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','54',745,'3','1',108877.90,108877.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','54',746,'4','1',135720.35,138135.39,2415.04,446782.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','54',747,'5','1',110957.55,112714.02,1756.47,324946.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','54',748,'6','1',119785.63,122034.36,2248.73,416015.05,0.00,0.00,0.00,0.00,0.00),('1','281','2','54',749,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','54',750,'8','1',201713.33,205663.36,3950.03,730755.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','54',751,'9','1',120436.06,120436.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','54',752,'10','1',119906.50,122546.49,2639.99,488398.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','54',753,'11','1',142157.62,144283.80,2126.18,393343.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','54',754,'12','1',127693.99,129898.96,2204.97,407919.45,0.00,0.00,0.00,0.00,0.00),('1','281','3','54',755,'13','2',17671.81,19121.28,1449.47,1159576.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','54',756,'14','2',4601.32,5666.09,1064.77,851816.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','55',757,'1','1',132619.33,134644.98,2025.65,374745.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','55',758,'2','1',136844.58,138580.10,1735.52,321071.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','55',759,'3','1',108877.90,109610.43,732.53,135518.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','55',760,'4','1',138135.39,140754.41,2619.02,484518.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','55',761,'5','1',112714.02,114423.94,1709.92,316335.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','55',762,'6','1',122034.36,123983.09,1948.73,360515.05,0.00,0.00,0.00,0.00,0.00),('1','281','2','55',763,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','55',764,'8','1',205663.36,209052.80,3389.44,627046.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','55',765,'9','1',120436.06,122163.33,1727.27,319544.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','55',766,'10','1',122546.49,124611.34,2064.85,381997.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','55',767,'11','1',144283.80,147109.49,2825.69,522752.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','55',768,'12','1',129898.96,132313.42,2414.46,446675.10,0.00,0.00,0.00,0.00,0.00),('1','281','3','55',769,'13','2',19121.28,19241.08,119.80,95840.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','55',770,'14','2',5666.09,5666.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','56',771,'1','1',134644.98,135424.49,769.51,142359.35,0.00,0.00,10.00,0.00,0.00),('1','281','1','56',772,'2','1',138580.10,140594.16,2004.06,370751.10,0.00,0.00,10.00,0.00,0.00),('1','281','1','56',773,'3','1',109610.43,111219.36,1608.93,297652.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','56',774,'4','1',140754.41,142620.17,1865.76,345165.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','56',775,'5','1',114423.94,115293.30,859.36,158981.60,0.00,0.00,10.00,0.00,0.00),('1','281','1','56',776,'6','1',123983.09,125690.41,1697.32,314004.20,0.00,0.00,10.00,0.00,0.00),('1','281','2','56',777,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','56',778,'8','1',209052.80,211619.59,2566.79,474856.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','56',779,'9','1',122163.33,123643.97,1470.64,272068.40,0.00,0.00,10.00,0.00,0.00),('1','281','2','56',780,'10','1',124611.34,126515.06,1883.72,348488.20,0.00,0.00,20.00,0.00,0.00),('1','281','2','56',781,'11','1',147109.49,149425.46,2305.97,426604.45,0.00,0.00,10.00,0.00,0.00),('1','281','2','56',782,'12','1',132313.42,134107.30,1793.88,331867.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','56',783,'13','2',19241.08,20929.09,1688.01,1350408.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','56',784,'14','2',5666.09,5687.22,21.13,16904.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','57',785,'1','1',135424.49,136539.39,1114.90,206256.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','57',786,'2','1',140594.16,141836.37,1242.21,229808.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','57',787,'3','1',111219.36,113199.78,1980.42,366377.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','57',788,'4','1',142620.17,145520.34,2900.17,536531.45,0.00,0.00,0.00,0.00,0.00),('1','281','1','57',789,'5','1',115293.30,116520.31,1227.01,226996.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','57',790,'6','1',125690.41,126582.15,891.74,164971.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','57',791,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','57',792,'8','1',211619.59,216585.33,4965.74,918661.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','57',793,'9','1',123643.97,124884.90,1240.93,229572.05,0.00,0.00,0.00,0.00,0.00),('1','281','2','57',794,'10','1',126515.06,127357.29,842.23,155812.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','57',795,'11','1',149425.46,152939.32,3513.86,650064.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','57',796,'12','1',134107.30,136527.66,2420.36,447766.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','57',797,'13','2',20929.09,21015.12,86.03,68824.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','57',798,'14','2',5687.22,5687.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','58',799,'1','1',136539.39,139108.93,2569.54,475364.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','58',800,'2','1',141836.37,145716.74,3880.37,717868.45,0.00,0.00,0.00,0.00,0.00),('1','281','1','58',801,'3','1',113199.78,115232.76,2032.98,376101.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','58',802,'4','1',145520.34,147522.49,2002.15,370397.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','58',803,'5','1',116520.31,117245.17,724.86,134099.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','58',804,'6','1',126582.15,127040.94,458.79,84876.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','58',805,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','58',806,'8','1',216585.33,219442.51,2857.18,528578.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','58',807,'9','1',124884.90,125899.34,1014.44,187671.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','58',808,'10','1',127357.29,128097.04,739.75,136853.75,0.00,0.00,0.00,0.00,0.00),('1','281','2','58',809,'11','1',152939.32,155899.64,2960.32,547659.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','58',810,'12','1',136527.66,138763.67,2236.01,413661.85,0.00,0.00,0.00,0.00,0.00),('1','281','3','58',811,'13','2',21015.12,21333.01,317.89,254312.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','58',812,'14','2',5687.22,5687.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','59',813,'1','1',139108.93,140995.44,1886.51,349004.35,0.00,0.00,0.00,0.00,0.00),('1','281','1','59',814,'2','1',145716.74,148171.61,2454.87,454150.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','59',815,'3','1',115232.76,116986.34,1753.58,324412.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','59',816,'4','1',147522.49,149721.99,2199.50,406907.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','59',817,'5','1',117245.17,117245.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','59',818,'6','1',127040.94,129953.48,2912.54,538819.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','59',819,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','59',820,'8','1',219442.51,222202.75,2760.24,510644.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','59',821,'9','1',125899.34,127959.31,2059.97,381094.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','59',822,'10','1',128097.04,129915.63,1818.59,336439.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','59',823,'11','1',155899.64,158305.11,2405.47,445011.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','59',824,'12','1',138763.67,140700.21,1936.54,358259.90,0.00,0.00,0.00,0.00,0.00),('1','281','3','59',825,'13','2',21333.01,22207.56,874.55,699640.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','59',826,'14','2',5687.22,5687.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','60',827,'1','1',140995.44,142346.45,1351.01,249936.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','60',828,'2','1',148171.61,151257.81,3086.20,570947.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','60',829,'3','1',116986.34,118464.48,1478.14,273455.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','60',830,'4','1',149721.99,151337.00,1615.01,298776.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','60',831,'5','1',117245.17,119634.43,2389.26,442013.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','60',832,'6','1',129953.48,131176.84,1223.36,226321.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','60',833,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','60',834,'8','1',222202.75,225013.89,2811.14,520060.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','60',835,'9','1',127959.31,129173.45,1214.14,224615.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','60',836,'10','1',129915.63,132350.95,2435.32,450534.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','60',837,'11','1',158305.11,159998.93,1693.82,313356.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','60',838,'12','1',140700.21,142236.49,1536.28,284211.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','60',839,'13','2',22207.56,24264.87,2057.31,1645848.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','60',840,'14','2',5687.22,5708.47,21.25,17000.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','61',841,'1','1',142346.45,142346.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','61',842,'2','1',151257.81,151411.85,154.04,28497.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','61',843,'3','1',118464.48,122127.24,3662.76,677610.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','61',844,'4','1',151337.00,154956.52,3619.52,669611.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','61',845,'5','1',119634.43,119634.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','61',846,'6','1',131176.84,131428.42,251.58,46542.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','61',847,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','61',848,'8','1',225013.89,230049.89,5036.00,931660.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','61',849,'9','1',129173.45,129173.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','61',850,'10','1',132350.95,132631.67,280.72,51933.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','61',851,'11','1',159998.93,164115.80,4116.87,761620.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','61',852,'12','1',142236.49,145724.94,3488.45,645363.25,0.00,0.00,0.00,0.00,0.00),('1','281','3','61',853,'13','2',24264.87,24916.32,651.45,521160.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','61',854,'14','2',5708.47,5710.34,1.87,1496.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','62',855,'1','1',142346.45,142346.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','62',856,'2','1',151411.85,152053.97,622.12,115092.20,0.00,0.00,20.00,0.00,0.00),('1','281','1','62',857,'3','1',122127.24,125241.79,3114.55,576191.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','62',858,'4','1',154956.52,157750.96,2794.44,516971.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','62',859,'5','1',119634.43,120158.90,524.47,97026.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','62',860,'6','1',131428.42,131641.12,212.70,39349.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','62',861,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','62',862,'8','1',230049.89,234379.14,4329.25,800911.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','62',863,'9','1',129173.45,129357.14,183.69,33982.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','62',864,'10','1',132631.67,133055.23,423.56,78358.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','62',865,'11','1',164115.80,167635.80,3520.00,651200.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','62',866,'12','1',145724.94,148303.00,2578.06,476941.10,0.00,0.00,0.00,0.00,0.00),('1','281','3','62',867,'13','2',24916.32,25306.76,390.44,312352.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','62',868,'14','2',5710.34,5730.34,20.00,16000.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','63',869,'1','1',142346.45,144667.04,2320.59,429309.15,0.00,0.00,0.00,0.00,0.00),('1','281','1','63',870,'2','1',152053.97,154252.61,2198.64,406748.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','63',871,'3','1',125241.79,125241.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','63',872,'4','1',157750.96,160781.23,3030.27,560599.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','63',873,'5','1',120158.90,121775.02,1616.12,298982.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','63',874,'6','1',131641.12,133679.69,2038.57,377135.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','63',875,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','63',876,'8','1',234379.14,237442.29,3063.15,566682.75,0.00,0.00,0.00,0.00,0.00),('1','281','2','63',877,'9','1',129357.14,131982.17,2625.03,485630.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','63',878,'10','1',133055.23,133055.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','63',879,'11','1',167635.80,168638.13,1002.33,185431.05,0.00,0.00,0.00,0.00,0.00),('1','281','2','63',880,'12','1',148303.00,150895.07,2592.07,479532.95,0.00,0.00,0.00,0.00,0.00),('1','281','3','63',881,'13','2',25306.76,26624.36,1317.60,1040904.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','63',882,'14','2',5730.34,5747.45,17.11,13516.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','64',883,'1','1',144667.04,144667.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','64',884,'2','1',154252.61,157943.23,3690.62,682764.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','64',885,'3','1',125241.79,125241.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','64',886,'4','1',160781.23,163304.60,2523.37,466823.45,0.00,0.00,0.00,0.00,0.00),('1','281','1','64',887,'5','1',121775.02,123484.87,1709.85,316322.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','64',888,'6','1',133679.69,135798.07,2118.38,391900.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','64',889,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','64',890,'8','1',237442.29,240233.70,2791.41,516410.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','64',891,'9','1',131982.17,133663.05,1680.88,310962.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','64',892,'10','1',133055.23,134932.55,1877.32,347304.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','64',893,'11','1',168638.13,168638.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','64',894,'12','1',150895.07,153109.75,2214.68,409715.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','64',895,'13','2',26624.36,26793.02,168.66,133241.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','64',896,'14','2',5747.45,5747.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','65',897,'1','1',144667.04,145713.17,1046.13,193534.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','65',898,'2','1',157943.23,159207.63,1264.40,233914.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','65',899,'3','1',125241.79,125412.19,170.40,31524.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','65',900,'4','1',163304.60,163579.25,274.65,50810.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','65',901,'5','1',123484.87,124659.56,1174.69,217317.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','65',902,'6','1',135798.07,137059.12,1261.05,233294.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','65',903,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','65',904,'8','1',240233.70,240761.06,527.36,97561.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','65',905,'9','1',133663.05,134639.29,976.24,180604.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','65',906,'10','1',134932.55,136188.94,1256.39,232432.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','65',907,'11','1',168638.13,168994.73,356.60,65971.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','65',908,'12','1',153109.75,153482.41,372.66,68942.10,0.00,0.00,0.00,0.00,0.00),('1','281','3','65',909,'13','2',26793.02,27009.41,216.39,170948.10,0.00,0.00,0.00,0.00,0.00),('1','281','3','65',910,'14','2',5747.45,5747.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','66',911,'1','1',145713.17,145713.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','66',912,'2','1',159207.63,159207.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','66',913,'3','1',125412.19,126913.12,1500.93,277672.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','66',914,'4','1',163579.25,165534.88,1955.63,361791.55,0.00,0.00,0.00,0.00,0.00),('1','281','1','66',915,'5','1',124659.56,124659.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','66',916,'6','1',137059.12,137059.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','66',917,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','66',918,'8','1',240761.06,242644.67,1883.61,348467.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','66',919,'9','1',134639.29,134639.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','66',920,'10','1',136188.94,136188.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','66',921,'11','1',168994.73,170730.27,1735.54,321074.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','66',922,'12','1',153482.41,155113.79,1621.38,299955.30,0.00,0.00,10.00,0.00,0.00),('1','281','3','66',923,'13','2',27009.41,27237.75,228.34,180388.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','66',924,'14','2',5747.45,5839.90,92.45,73035.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','67',925,'1','1',145713.17,148750.19,3037.02,561848.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','67',926,'2','1',159207.63,162301.49,3093.86,572364.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','67',927,'3','1',126913.12,126913.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','67',928,'4','1',165534.88,168601.26,3066.38,567280.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','67',929,'5','1',124659.56,124659.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','67',930,'6','1',137059.12,140116.05,3056.93,565532.05,0.00,0.00,0.00,0.00,0.00),('1','281','2','67',931,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','67',932,'8','1',242644.67,246128.97,3484.30,644595.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','67',933,'9','1',134639.29,134639.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','67',934,'10','1',136188.94,140147.66,3958.72,732363.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','67',935,'11','1',170730.27,174328.28,3598.01,665631.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','67',936,'12','1',155113.79,155113.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','67',937,'13','2',27237.75,28237.75,1000.00,790000.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','67',938,'14','2',5839.90,5902.54,62.64,49485.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','68',939,'1','1',148750.19,150691.19,1941.00,359085.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','68',940,'2','1',162301.49,164325.31,2023.82,374406.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','68',941,'3','1',126913.12,128306.61,1393.49,257795.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','68',942,'4','1',168601.26,170708.66,2107.40,389869.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','68',943,'5','1',124659.56,124659.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','68',944,'6','1',140116.05,142344.84,2228.79,412326.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','68',945,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','68',946,'8','1',246128.97,249013.12,2884.15,533567.75,0.00,0.00,0.00,0.00,0.00),('1','281','2','68',947,'9','1',134639.29,136790.66,2151.37,398003.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','68',948,'10','1',140147.66,142056.17,1908.51,353074.35,0.00,0.00,0.00,0.00,0.00),('1','281','2','68',949,'11','1',174328.28,175515.49,1187.21,219633.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','68',950,'12','1',155113.79,157316.16,2202.37,407438.45,0.00,0.00,0.00,0.00,0.00),('1','281','3','68',951,'13','2',28237.75,30635.11,2397.36,1893914.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','68',952,'14','2',5902.54,5907.34,4.80,3792.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','69',953,'1','1',150691.19,153158.90,2467.71,456526.35,0.00,0.00,0.00,0.00,0.00),('1','281','1','69',954,'2','1',164325.31,167778.18,3452.87,638780.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','69',955,'3','1',128306.61,128306.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','69',956,'4','1',170708.66,173825.75,3117.09,576661.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','69',957,'5','1',124659.56,124659.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','69',958,'6','1',142344.84,146289.36,3944.52,729736.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','69',959,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','69',960,'8','1',249013.12,252341.07,3327.95,615670.75,0.00,0.00,0.00,0.00,0.00),('1','281','2','69',961,'9','1',136790.66,136790.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','69',962,'10','1',142056.17,145584.15,3527.98,652676.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','69',963,'11','1',175515.49,175515.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','69',964,'12','1',157316.16,160933.25,3617.09,669161.65,0.00,0.00,0.00,0.00,0.00),('1','281','3','69',965,'13','2',30635.11,32785.26,2150.15,1698618.50,0.00,0.00,0.00,0.00,0.00),('1','281','3','69',966,'14','2',5907.34,6009.45,102.11,80666.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','70',967,'1','1',153158.90,155815.67,2656.77,491502.45,0.00,0.00,0.00,0.00,0.00),('1','281','1','70',968,'2','1',167778.18,170015.49,2217.31,410202.35,0.00,0.00,20.00,0.00,0.00),('1','281','1','70',969,'3','1',128306.61,128306.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','70',970,'4','1',173825.75,175565.20,1739.45,321798.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','70',971,'5','1',124659.56,125493.91,834.35,154354.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','70',972,'6','1',146289.36,148428.90,2139.54,395814.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','70',973,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','70',974,'8','1',252341.07,254363.52,2022.45,374153.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','70',975,'9','1',136790.66,137865.09,1074.43,198769.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','70',976,'10','1',145584.15,148464.38,2880.23,532842.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','70',977,'11','1',175515.49,176769.34,1253.85,231962.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','70',978,'12','1',160933.25,162122.04,1188.79,219926.15,0.00,0.00,0.00,0.00,0.00),('1','281','3','70',979,'13','2',32785.26,35392.73,2607.47,2059901.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','70',980,'14','2',6009.45,6104.39,94.94,75002.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','71',981,'1','1',155815.67,157007.20,1191.53,220433.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','71',982,'2','1',170015.49,171471.88,1456.39,269432.15,0.00,0.00,0.00,0.00,0.00),('1','281','1','71',983,'3','1',128306.61,130563.43,2256.82,417511.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','71',984,'4','1',175565.20,178497.76,2932.56,542523.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','71',985,'5','1',125493.91,125493.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','71',986,'6','1',148428.90,149909.27,1480.37,273868.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','71',987,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','71',988,'8','1',254363.52,258292.87,3929.35,726929.75,0.00,0.00,0.00,0.00,0.00),('1','281','2','71',989,'9','1',137865.09,137865.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','71',990,'10','1',148464.38,150519.55,2055.17,380206.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','71',991,'11','1',176769.34,179779.31,3009.97,556844.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','71',992,'12','1',162122.04,165049.28,2927.24,541539.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','71',993,'13','2',35392.73,35678.66,285.93,225884.70,0.00,0.00,0.00,0.00,0.00),('1','281','3','71',994,'14','2',6104.39,6104.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','72',995,'1','1',157007.20,158896.02,1888.82,349431.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','72',996,'2','1',171471.88,173575.40,2103.52,389151.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','72',997,'3','1',130563.43,131172.22,608.79,112626.15,0.00,0.00,0.00,0.00,0.00),('1','281','1','72',998,'4','1',178497.76,181017.63,2519.87,466175.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','72',999,'5','1',125493.91,126425.63,931.72,172368.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','72',1000,'6','1',149909.27,152292.09,2382.82,440821.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','72',1001,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','72',1002,'8','1',258292.87,261580.29,3287.42,608172.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','72',1003,'9','1',137865.09,139976.04,2110.95,390525.75,0.00,0.00,0.00,0.00,0.00),('1','281','2','72',1004,'10','1',150519.55,152215.17,1695.62,313689.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','72',1005,'11','1',179779.31,181222.98,1443.67,267078.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','72',1006,'12','1',165049.28,167976.81,2927.53,541593.05,0.00,0.00,0.00,0.00,0.00),('1','281','3','72',1007,'13','2',35678.66,35925.88,247.22,195303.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','72',1008,'14','2',6104.39,6174.43,70.04,55331.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','73',1009,'1','1',158896.02,161512.88,2616.86,484119.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','73',1010,'2','1',173575.40,176108.67,2533.27,468654.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','73',1011,'3','1',131172.22,133145.44,1973.22,365045.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','73',1012,'4','1',181017.63,183187.83,2170.20,401487.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','73',1013,'5','1',126425.63,126425.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','73',1014,'6','1',152292.09,155719.32,3427.23,634037.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','73',1015,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','73',1016,'8','1',261580.29,264956.39,3376.10,624578.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','73',1017,'9','1',139976.04,139976.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','73',1018,'10','1',152215.17,155048.00,2832.83,524073.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','73',1019,'11','1',181222.98,183886.92,2663.94,492828.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','73',1020,'12','1',167976.81,170254.67,2277.86,421404.10,0.00,0.00,0.00,0.00,0.00),('1','281','3','73',1021,'13','2',35925.88,37556.64,1630.76,1288300.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','73',1022,'14','2',6174.43,6226.97,52.54,41506.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','74',1023,'1','1',161512.88,163226.53,1713.65,317025.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','74',1024,'2','1',176108.67,180918.65,4809.98,889846.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','74',1025,'3','1',133145.44,133944.54,799.10,147833.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','74',1026,'4','1',183187.83,183820.87,633.04,117112.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','74',1027,'5','1',126425.63,128531.90,2106.27,389659.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','74',1028,'6','1',155719.32,158823.71,3104.39,574312.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','74',1029,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','74',1030,'8','1',264956.39,266327.89,1371.50,253727.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','74',1031,'9','1',139976.04,142873.94,2897.90,536111.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','74',1032,'10','1',155048.00,158185.05,3137.05,580354.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','74',1033,'11','1',183886.92,184431.94,545.02,100828.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','74',1034,'12','1',170254.67,171445.84,1191.17,220366.45,0.00,0.00,0.00,0.00,0.00),('1','281','3','74',1035,'13','2',37556.64,37556.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','74',1036,'14','2',6226.97,6676.88,449.91,355428.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','75',1037,'1','1',163226.53,165615.34,2388.81,441929.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','75',1038,'2','1',180918.65,183205.31,2286.66,423032.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','75',1039,'3','1',133944.54,133944.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','75',1040,'4','1',183820.87,186300.10,2379.23,440157.55,0.00,0.00,100.00,0.00,0.00),('1','281','1','75',1041,'5','1',128531.90,130901.78,2369.88,438427.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','75',1042,'6','1',158823.71,161198.88,2375.17,439406.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','75',1043,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','75',1044,'8','1',266327.89,269270.40,2942.51,544364.35,0.00,0.00,0.00,0.00,0.00),('1','281','2','75',1045,'9','1',142873.94,143181.89,307.95,56970.75,0.00,0.00,0.00,0.00,0.00),('1','281','2','75',1046,'10','1',158185.05,161320.51,3135.46,580060.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','75',1047,'11','1',184431.94,186300.76,1868.82,345731.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','75',1048,'12','1',171445.84,173225.89,1780.05,329309.25,0.00,0.00,0.00,0.00,0.00),('1','281','3','75',1049,'13','2',37556.64,37758.07,201.43,159129.70,0.00,0.00,0.00,0.00,0.00),('1','281','3','75',1050,'14','2',6676.88,6676.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','76',1051,'1','1',165615.34,166039.55,424.21,78478.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','76',1052,'2','1',183205.31,184087.98,882.67,163293.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','76',1053,'3','1',133944.54,136266.63,2322.09,429586.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','76',1054,'4','1',186300.10,189907.43,3607.33,667356.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','76',1055,'5','1',130901.78,131674.28,772.50,142912.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','76',1056,'6','1',161198.88,161827.11,628.23,116222.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','76',1057,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','76',1058,'8','1',269270.40,273577.34,4306.94,796783.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','76',1059,'9','1',143181.89,143904.95,723.06,133766.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','76',1060,'10','1',161320.51,161942.44,621.93,115057.05,0.00,0.00,0.00,0.00,0.00),('1','281','2','76',1061,'11','1',186300.76,189257.20,2956.44,546941.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','76',1062,'12','1',173225.89,176047.27,2821.38,521955.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','76',1063,'13','2',37758.07,40302.20,2544.13,2009862.70,0.00,0.00,0.00,0.00,0.00),('1','281','3','76',1064,'14','2',6676.88,6760.43,83.55,66004.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','77',1065,'1','1',166039.55,167684.44,1644.89,304304.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','77',1066,'2','1',184087.98,186498.09,2410.11,445870.35,0.00,0.00,0.00,0.00,0.00),('1','281','1','77',1067,'3','1',136266.63,136825.28,558.65,103350.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','77',1068,'4','1',189907.43,192159.51,2252.08,416634.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','77',1069,'5','1',131674.28,132779.02,1104.74,204376.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','77',1070,'6','1',161827.11,163499.53,1672.42,309397.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','77',1071,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','77',1072,'8','1',273577.34,276454.52,2877.18,532278.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','77',1073,'9','1',143904.95,145096.87,1191.92,220505.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','77',1074,'10','1',161942.44,164310.00,2367.56,437998.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','77',1075,'11','1',189257.20,190252.96,995.76,184215.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','77',1076,'12','1',176047.27,178208.35,2161.08,399799.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','77',1077,'13','2',40302.20,40387.23,85.03,67173.70,0.00,0.00,0.00,0.00,0.00),('1','281','3','77',1078,'14','2',6760.43,6816.13,55.70,44003.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','78',1079,'1','1',167684.44,168433.57,749.13,138589.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','78',1080,'2','1',186498.09,189004.64,2506.55,463711.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','78',1081,'3','1',136825.28,138069.69,1244.41,230215.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','78',1082,'4','1',192159.51,194246.46,2086.95,386085.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','78',1083,'5','1',132779.02,135128.64,2349.62,434679.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','78',1084,'6','1',163499.53,163499.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','78',1085,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','78',1086,'8','1',276454.52,279245.10,2790.58,516257.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','78',1087,'9','1',145096.87,145096.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','78',1088,'10','1',164310.00,166611.74,2301.74,425821.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','78',1089,'11','1',190252.96,190252.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','78',1090,'12','1',178208.35,180245.25,2036.90,376826.50,0.00,0.00,0.00,0.00,0.00),('1','281','3','78',1091,'13','2',40387.23,40432.63,45.40,35866.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','78',1092,'14','2',6816.13,6816.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','79',1093,'1','1',168433.57,171789.92,3356.35,620924.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','79',1094,'2','1',189004.64,192600.01,3595.37,665143.45,0.00,0.00,0.00,0.00,0.00),('1','281','1','79',1095,'3','1',138069.69,138069.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','79',1096,'4','1',194246.46,194718.48,472.02,87323.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','79',1097,'5','1',135128.64,138050.62,2921.98,540566.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','79',1098,'6','1',163499.53,166696.14,3196.61,591372.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','79',1099,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','79',1100,'8','1',279245.10,279774.32,529.22,97905.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','79',1101,'9','1',145096.87,148287.36,3190.49,590240.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','79',1102,'10','1',166611.74,170153.06,3541.32,655144.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','79',1103,'11','1',190252.96,190948.50,695.54,128674.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','79',1104,'12','1',180245.25,180245.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','79',1105,'13','2',40432.63,41564.05,1131.42,893821.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','79',1106,'14','2',6816.13,6934.68,118.55,93654.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','80',1107,'1','1',171789.92,173765.40,1975.48,365463.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','80',1108,'2','1',192600.01,194820.25,2220.24,410744.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','80',1109,'3','1',138069.69,138069.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','80',1110,'4','1',194718.48,194718.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','80',1111,'5','1',138050.62,140004.56,1953.94,361478.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','80',1112,'6','1',166696.14,168871.48,2175.34,402437.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','80',1113,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','80',1114,'8','1',279774.32,279774.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','80',1115,'9','1',148287.36,148287.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','80',1116,'10','1',170153.06,172827.01,2673.95,494680.75,0.00,0.00,0.00,0.00,0.00),('1','281','2','80',1117,'11','1',190948.50,190948.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','80',1118,'12','1',180245.25,180245.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','80',1119,'13','2',41564.05,43171.26,1607.21,1269695.90,0.00,0.00,0.00,0.00,0.00),('1','281','3','80',1120,'14','2',6934.68,7075.55,140.87,111287.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','81',1121,'1','1',173765.40,175905.05,2139.65,395835.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','81',1122,'2','1',194820.25,197162.31,2342.06,433281.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','81',1123,'3','1',138069.69,138069.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','81',1124,'4','1',194718.48,197240.94,2522.46,466655.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','81',1125,'5','1',140004.56,142069.06,2064.50,381932.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','81',1126,'6','1',168871.48,170768.48,1897.00,350945.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','81',1127,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','81',1128,'8','1',279774.32,283468.14,3693.82,683356.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','81',1129,'9','1',148287.36,150861.98,2574.62,476304.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','81',1130,'10','1',172827.01,174754.91,1927.90,356661.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','81',1131,'11','1',190948.50,190948.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','81',1132,'12','1',180245.25,183126.81,2881.56,533088.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','81',1133,'13','2',43171.26,43516.23,344.97,272526.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','81',1134,'14','2',7075.55,7075.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','82',1135,'1','1',175905.05,177826.95,1921.90,355551.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','82',1136,'2','1',197162.31,199224.39,2062.08,381484.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','82',1137,'3','1',138069.69,138372.79,303.10,56073.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','82',1138,'4','1',197240.94,198986.28,1745.34,322887.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','82',1139,'5','1',142069.06,143162.57,1093.51,202299.35,0.00,0.00,0.00,0.00,0.00),('1','281','1','82',1140,'6','1',170768.48,173161.18,2392.70,442649.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','82',1141,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','82',1142,'8','1',283468.14,287375.94,3907.80,722943.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','82',1143,'9','1',150861.98,152146.92,1284.94,237713.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','82',1144,'10','1',174754.91,177146.46,2391.55,442436.75,0.00,0.00,0.00,0.00,0.00),('1','281','2','82',1145,'11','1',190948.50,191459.42,510.92,94520.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','82',1146,'12','1',183126.81,184878.87,1752.06,324131.10,0.00,0.00,0.00,0.00,0.00),('1','281','3','82',1147,'13','2',43516.23,44037.57,521.34,411858.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','82',1148,'14','2',7075.55,7081.89,6.34,5008.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','83',1149,'1','1',177826.95,179762.58,1935.63,358091.55,0.00,0.00,0.00,0.00,0.00),('1','281','1','83',1150,'2','1',199224.39,201702.47,2478.08,458444.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','83',1151,'3','1',138372.79,140122.78,1749.99,323748.15,0.00,0.00,0.00,0.00,0.00),('1','281','1','83',1152,'4','1',198986.28,201082.87,2096.59,387869.15,0.00,0.00,0.00,0.00,0.00),('1','281','1','83',1153,'5','1',143162.57,143162.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','83',1154,'6','1',173161.18,175749.85,2588.67,478903.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','83',1155,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','83',1156,'8','1',287375.94,290291.57,2915.63,539391.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','83',1157,'9','1',152146.92,152146.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','83',1158,'10','1',177146.46,179791.99,2645.53,489423.05,0.00,0.00,0.00,0.00,0.00),('1','281','2','83',1159,'11','1',191459.42,193896.98,2437.56,450948.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','83',1160,'12','1',184878.87,187040.12,2161.25,399831.25,0.00,0.00,0.00,0.00,0.00),('1','281','3','83',1161,'13','2',44037.57,44067.62,30.05,23739.50,0.00,0.00,0.00,0.00,0.00),('1','281','3','83',1162,'14','2',7081.89,7257.23,175.34,138518.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','84',1163,'1','1',179762.58,180292.48,529.90,98031.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','84',1164,'2','1',201702.47,205148.69,3446.22,637550.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','84',1165,'3','1',140122.78,140512.54,389.76,72105.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','84',1166,'4','1',201082.87,203473.03,2390.16,442179.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','84',1167,'5','1',143162.57,143774.96,612.39,113292.15,0.00,0.00,0.00,0.00,0.00),('1','281','1','84',1168,'6','1',175749.85,178028.34,2278.49,421520.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','84',1169,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','84',1170,'8','1',290291.57,292952.61,2661.04,492292.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','84',1171,'9','1',152146.92,153707.56,1560.64,288718.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','84',1172,'10','1',179791.99,181466.72,1674.73,309825.05,0.00,0.00,0.00,0.00,0.00),('1','281','2','84',1173,'11','1',193896.98,194513.04,616.06,113971.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','84',1174,'12','1',187040.12,189547.37,2507.25,463841.25,0.00,0.00,0.00,0.00,0.00),('1','281','3','84',1175,'13','2',44067.62,45697.29,1629.67,1287439.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','84',1176,'14','2',7257.23,7257.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','85',1177,'1','1',180292.48,181117.89,825.41,152700.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','85',1178,'2','1',205148.69,208305.92,3157.23,584087.55,0.00,0.00,0.00,0.00,0.00),('1','281','1','85',1179,'3','1',140512.54,141905.42,1392.88,257682.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','85',1180,'4','1',203473.03,205234.50,1761.47,325871.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','85',1181,'5','1',143774.96,144602.79,827.83,153148.55,0.00,0.00,0.00,0.00,0.00),('1','281','1','85',1182,'6','1',178028.34,180411.13,2382.79,440816.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','85',1183,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','85',1184,'8','1',292952.61,295577.95,2625.34,485687.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','85',1185,'9','1',153707.56,154713.64,1006.08,186124.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','85',1186,'10','1',181466.72,184190.08,2723.36,503821.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','85',1187,'11','1',194513.04,196788.20,2275.16,420904.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','85',1188,'12','1',189547.37,191102.58,1555.21,287713.85,0.00,0.00,0.00,0.00,0.00),('1','281','3','85',1189,'13','2',45697.29,46263.46,566.17,447274.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','85',1190,'14','2',7257.23,7257.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','86',1191,'1','1',181117.89,181117.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','86',1192,'2','1',208305.92,210355.77,2049.85,379222.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','86',1193,'3','1',141905.42,142763.75,858.33,158791.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','86',1194,'4','1',205234.50,208335.75,3101.25,573731.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','86',1195,'5','1',144602.79,144602.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','86',1196,'6','1',180411.13,182559.70,2148.57,397485.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','86',1197,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','86',1198,'8','1',295577.95,298960.48,3382.53,625768.05,0.00,0.00,0.00,0.00,0.00),('1','281','2','86',1199,'9','1',154713.64,154713.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','86',1200,'10','1',184190.08,186084.60,1894.52,350486.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','86',1201,'11','1',196788.20,198879.65,2091.45,386918.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','86',1202,'12','1',191102.58,194049.90,2947.32,545254.20,0.00,0.00,0.00,0.00,0.00),('1','281','3','86',1203,'13','2',46263.46,47732.37,1468.91,1160438.90,0.00,0.00,0.00,0.00,0.00),('1','281','3','86',1204,'14','2',7257.23,7327.25,70.02,55315.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','87',1205,'1','1',181117.89,183345.76,2227.87,412155.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','87',1206,'2','1',210355.77,212399.78,2044.01,378141.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','87',1207,'3','1',142763.75,144468.17,1704.42,315317.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','87',1208,'4','1',208335.75,209978.16,1642.41,303845.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','87',1209,'5','1',144602.79,146689.54,2086.75,386048.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','87',1210,'6','1',182559.70,184302.73,1743.03,322460.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','87',1211,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','87',1212,'8','1',298960.48,302188.06,3227.58,597102.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','87',1213,'9','1',154713.64,156774.48,2060.84,381255.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','87',1214,'10','1',186084.60,187888.16,1803.56,333658.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','87',1215,'11','1',198879.65,200726.12,1846.47,341596.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','87',1216,'12','1',194049.90,196284.32,2234.42,413367.70,0.00,0.00,0.00,0.00,0.00),('1','281','3','87',1217,'13','2',47732.37,47736.17,3.80,3002.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','87',1218,'14','2',7327.25,7645.85,318.60,251694.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','88',1219,'1','1',183345.76,184104.47,758.71,140361.35,0.00,0.00,0.00,0.00,0.00),('1','281','1','88',1220,'2','1',212399.78,214005.69,1605.91,297093.35,0.00,0.00,0.00,0.00,0.00),('1','281','1','88',1221,'3','1',144468.17,145920.56,1452.39,268692.15,0.00,0.00,0.00,0.00,0.00),('1','281','1','88',1222,'4','1',209978.16,212658.35,2680.19,495835.15,0.00,0.00,0.00,0.00,0.00),('1','281','1','88',1223,'5','1',146689.54,147646.08,956.54,176959.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','88',1224,'6','1',184302.73,185368.05,1065.32,197084.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','88',1225,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','88',1226,'8','1',302188.06,305757.14,3569.08,660279.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','88',1227,'9','1',156774.48,158198.06,1423.58,263362.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','88',1228,'10','1',187888.16,188813.78,925.62,171239.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','88',1229,'11','1',200726.12,202501.73,1775.61,328487.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','88',1230,'12','1',196284.32,198981.88,2697.56,499048.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','88',1231,'13','2',47736.17,48923.37,1187.20,937888.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','88',1232,'14','2',7645.85,8665.85,1020.00,805800.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','89',1233,'1','1',184104.47,185618.48,1514.01,280091.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','89',1234,'2','1',214005.69,215345.18,1339.49,247805.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','89',1235,'3','1',145920.56,148332.82,2412.26,446268.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','89',1236,'4','1',212658.35,215219.54,2561.19,473820.15,0.00,0.00,0.00,0.00,0.00),('1','281','1','89',1237,'5','1',147646.08,148733.87,1087.79,201241.15,0.00,0.00,0.00,0.00,0.00),('1','281','1','89',1238,'6','1',185368.05,187134.96,1766.91,326878.35,0.00,0.00,0.00,0.00,0.00),('1','281','2','89',1239,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','89',1240,'8','1',305757.14,308871.20,3114.06,576101.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','89',1241,'9','1',158198.06,159997.28,1799.22,332855.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','89',1242,'10','1',188813.78,190246.30,1432.52,265016.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','89',1243,'11','1',202501.73,204982.30,2480.57,458905.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','89',1244,'12','1',198981.88,201009.78,2027.90,375161.50,0.00,0.00,0.00,0.00,0.00),('1','281','3','89',1245,'13','2',48923.37,50181.01,1257.64,993535.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','89',1246,'14','2',8665.85,8733.27,67.42,53261.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','90',1247,'1','1',185618.48,185618.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','90',1248,'2','1',215345.18,217052.58,1707.40,315869.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','90',1249,'3','1',148332.82,150521.84,2189.02,404968.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','90',1250,'4','1',215219.54,218373.00,3153.46,583390.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','90',1251,'5','1',148733.87,148733.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','90',1252,'6','1',187134.96,188362.94,1227.98,227176.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','90',1253,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','90',1254,'8','1',308871.20,313351.26,4480.06,828811.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','90',1255,'9','1',159997.28,159997.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','90',1256,'10','1',190246.30,191337.00,1090.70,201779.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','90',1257,'11','1',204982.30,206432.92,1450.62,268364.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','90',1258,'12','1',201009.78,203906.34,2896.56,535863.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','90',1259,'13','2',50181.01,50466.26,285.25,225347.50,0.00,0.00,0.00,0.00,0.00),('1','281','3','90',1260,'14','2',8733.27,8738.33,5.06,3997.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','91',1261,'1','1',185618.48,188479.48,2861.00,529285.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','91',1262,'2','1',217052.58,219578.12,2525.54,467224.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','91',1263,'3','1',150521.84,150753.25,231.41,42810.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','91',1264,'4','1',218373.00,218373.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','91',1265,'5','1',148733.87,151515.73,2781.86,514644.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','91',1266,'6','1',188362.94,191322.72,2959.78,547559.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','91',1267,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','91',1268,'8','1',313351.26,313763.88,412.62,76334.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','91',1269,'9','1',159997.28,162759.92,2762.64,511088.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','91',1270,'10','1',191337.00,194281.45,2944.45,544723.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','91',1271,'11','1',206432.92,206432.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','91',1272,'12','1',203906.34,203906.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','91',1273,'13','2',50466.26,50516.51,50.25,39697.50,0.00,0.00,0.00,0.00,0.00),('1','281','3','91',1274,'14','2',8738.33,8738.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','92',1275,'1','1',188479.48,188479.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','92',1276,'2','1',219578.12,221497.84,1919.72,355148.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','92',1277,'3','1',150753.25,153277.99,2524.74,467076.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','92',1278,'4','1',218373.00,221626.91,3253.91,601973.35,0.00,0.00,0.00,0.00,0.00),('1','281','1','92',1279,'5','1',151515.73,151515.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','92',1280,'6','1',191322.72,192664.11,1341.39,248157.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','92',1281,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','92',1282,'8','1',313763.88,316746.75,2982.87,551830.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','92',1283,'9','1',162759.92,162759.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','92',1284,'10','1',194281.45,195755.70,1474.25,272736.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','92',1285,'11','1',206432.92,209397.42,2964.50,548432.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','92',1286,'12','1',203906.34,206170.67,2264.33,418901.05,0.00,0.00,0.00,0.00,0.00),('1','281','3','92',1287,'13','2',50516.51,50526.51,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','281','3','92',1288,'14','2',8738.33,8778.33,0.00,0.00,0.00,0.00,40.00,0.00,0.00),('1','281','1','93',1289,'1','1',188479.48,191151.06,2671.58,494242.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','93',1290,'2','1',221497.84,223807.43,2309.59,427274.15,0.00,0.00,0.00,0.00,0.00),('1','281','1','93',1291,'3','1',153277.99,154436.73,1158.74,214366.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','93',1292,'4','1',221626.91,223903.74,2276.83,421213.55,0.00,0.00,0.00,0.00,0.00),('1','281','1','93',1293,'5','1',151515.73,151515.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','93',1294,'6','1',192664.11,195898.71,3234.60,598401.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','93',1295,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','93',1296,'8','1',316746.75,320174.87,3428.12,634202.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','93',1297,'9','1',162759.92,164804.52,2044.60,378251.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','93',1298,'10','1',195755.70,197848.15,2092.45,387103.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','93',1299,'11','1',209397.42,212291.81,2894.39,535462.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','93',1300,'12','1',206170.67,207734.44,1563.77,289297.45,0.00,0.00,0.00,0.00,0.00),('1','281','3','93',1301,'13','2',50526.51,50645.36,118.85,93891.50,0.00,0.00,0.00,0.00,0.00),('1','281','3','93',1302,'14','2',8778.33,8778.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','94',1303,'1','1',191151.06,191151.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','94',1304,'2','1',223807.43,225121.93,1314.50,243182.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','94',1305,'3','1',154436.73,155587.78,1151.05,212944.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','94',1306,'4','1',223903.74,225121.67,1217.93,225317.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','94',1307,'5','1',151515.73,153598.91,2083.18,385388.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','94',1308,'6','1',195898.71,197911.55,2012.84,372375.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','94',1309,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','94',1310,'8','1',320174.87,322113.20,1938.33,358591.05,0.00,0.00,0.00,0.00,0.00),('1','281','2','94',1311,'9','1',164804.52,164804.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','94',1312,'10','1',197848.15,198984.29,1136.14,210185.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','94',1313,'11','1',212291.81,213657.88,1366.07,252722.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','94',1314,'12','1',207734.44,209047.63,1313.19,242940.15,0.00,0.00,0.00,0.00,0.00),('1','281','3','94',1315,'13','2',50645.36,52522.47,1877.11,1501688.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','94',1316,'14','2',8778.33,8852.64,74.31,59448.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','95',1317,'1','1',191151.06,193720.82,2569.76,475405.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','95',1318,'2','1',225121.93,227192.70,2070.77,383092.45,0.00,0.00,0.00,0.00,0.00),('1','281','1','95',1319,'3','1',155587.78,157529.70,1941.92,359255.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','95',1320,'4','1',225121.67,227192.70,2071.03,383140.55,0.00,0.00,0.00,0.00,0.00),('1','281','1','95',1321,'5','1',153598.91,153598.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','95',1322,'6','1',197911.55,200756.23,2844.68,526265.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','95',1323,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','95',1324,'8','1',322113.20,324981.26,2868.06,530591.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','95',1325,'9','1',164804.52,164804.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','95',1326,'10','1',198984.29,201737.00,2752.71,509251.35,0.00,0.00,0.00,0.00,0.00),('1','281','2','95',1327,'11','1',213657.88,216279.26,2621.38,484955.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','95',1328,'12','1',209047.63,211458.54,2410.91,446018.35,0.00,0.00,0.00,0.00,0.00),('1','281','3','95',1329,'13','2',52522.47,54916.09,2393.62,1914896.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','95',1330,'14','2',8852.64,9050.48,197.84,158272.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','96',1331,'1','1',193720.82,193720.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','96',1332,'2','1',227192.70,227714.63,521.93,96557.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','96',1333,'3','1',157529.70,157529.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','96',1334,'4','1',227192.70,227192.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','96',1335,'5','1',153598.91,153598.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','96',1336,'6','1',200756.23,200756.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','96',1337,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','96',1338,'8','1',324981.26,324981.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','96',1339,'9','1',164804.52,164804.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','96',1340,'10','1',201737.00,201737.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','96',1341,'11','1',216279.26,216279.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','96',1342,'12','1',211458.54,211458.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','96',1343,'13','2',54916.09,54916.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','96',1344,'14','2',9050.48,9050.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','97',1345,'1','1',193720.82,196426.69,2705.87,500585.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','97',1346,'2','1',227714.63,230323.29,2588.66,478902.10,0.00,0.00,20.00,0.00,0.00),('1','281','1','97',1347,'3','1',157529.70,157529.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','97',1348,'4','1',227192.70,228164.40,971.70,179764.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','97',1349,'5','1',153598.91,155379.93,1781.02,329488.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','97',1350,'6','1',200756.23,203538.88,2782.65,514790.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','97',1351,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','97',1352,'8','1',324981.26,326528.18,1546.92,286180.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','97',1353,'9','1',164804.52,165827.96,1023.44,189336.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','97',1354,'10','1',201737.00,204826.63,3089.63,571581.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','97',1355,'11','1',216279.26,216848.58,569.32,105324.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','97',1356,'12','1',211458.54,212626.60,1168.06,216091.10,0.00,0.00,0.00,0.00,0.00),('1','281','3','97',1357,'13','2',54916.09,56881.94,1965.85,1572680.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','97',1358,'14','2',9050.48,10892.05,1841.57,1473256.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','98',1359,'1','1',196426.69,198596.08,2169.39,401337.15,0.00,0.00,0.00,0.00,0.00),('1','281','1','98',1360,'2','1',230323.29,232451.56,2128.27,393729.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','98',1361,'3','1',157529.70,157529.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','98',1362,'4','1',228164.40,230450.14,2285.74,422861.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','98',1363,'5','1',155379.93,157325.06,1945.13,359849.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','98',1364,'6','1',203538.88,205754.85,2215.97,409954.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','98',1365,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','98',1366,'8','1',326528.18,329754.42,3226.24,596854.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','98',1367,'9','1',165827.96,168148.16,2320.20,429237.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','98',1368,'10','1',204826.63,206726.65,1900.02,351503.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','98',1369,'11','1',216848.58,216848.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','98',1370,'12','1',212626.60,215522.43,2895.83,535728.55,0.00,0.00,0.00,0.00,0.00),('1','281','3','98',1371,'13','2',56881.94,57232.84,350.90,280720.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','98',1372,'14','2',10892.05,10892.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','99',1373,'1','1',198596.08,198768.79,172.71,31951.35,0.00,0.00,0.00,0.00,0.00),('1','281','1','99',1374,'2','1',232451.56,232549.41,97.85,18102.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','99',1375,'3','1',157529.70,160572.83,3043.13,562979.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','99',1376,'4','1',230450.14,234274.01,3823.87,707415.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','99',1377,'5','1',157325.06,157325.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','99',1378,'6','1',205754.85,205895.06,140.21,25938.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','99',1379,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','99',1380,'8','1',329754.42,334351.03,4596.61,850372.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','99',1381,'9','1',168148.16,168148.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','99',1382,'10','1',206726.65,206964.50,237.85,44002.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','99',1383,'11','1',216848.58,220510.18,3661.60,677396.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','99',1384,'12','1',215522.43,218512.42,2989.99,553148.15,0.00,0.00,0.00,0.00,0.00),('1','281','3','99',1385,'13','2',57232.84,57400.30,167.46,134805.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','99',1386,'14','2',10892.05,10892.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','100',1387,'1','1',198768.79,198768.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','100',1388,'2','1',232549.41,232549.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','100',1389,'3','1',160572.83,160572.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','100',1390,'4','1',234274.01,234274.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','100',1391,'5','1',157325.06,157325.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','100',1392,'6','1',205895.06,205895.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','100',1393,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','100',1394,'8','1',334351.03,334351.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','100',1395,'9','1',168148.16,168148.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','100',1396,'10','1',206964.50,206964.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','100',1397,'11','1',220510.18,220510.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','100',1398,'12','1',218512.42,218512.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','100',1399,'13','2',57400.30,57549.30,149.00,119945.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','100',1400,'14','2',10892.05,10892.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','101',1401,'1','1',198768.79,201342.09,2573.30,476060.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','101',1402,'2','1',232549.41,235693.36,3143.95,581630.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','101',1403,'3','1',160572.83,162056.75,1483.92,274525.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','101',1404,'4','1',234274.01,235908.26,1634.25,302336.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','101',1405,'5','1',157325.06,158164.09,839.03,155220.55,0.00,0.00,0.00,0.00,0.00),('1','281','1','101',1406,'6','1',205895.06,209138.67,3243.61,600067.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','101',1407,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','101',1408,'8','1',334351.03,337505.93,3154.90,583656.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','101',1409,'9','1',168148.16,171061.88,2913.72,539038.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','101',1410,'10','1',206964.50,207713.09,748.59,138489.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','101',1411,'11','1',220510.18,222693.35,2183.17,403886.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','101',1412,'12','1',218512.42,220425.04,1912.62,353834.70,0.00,0.00,0.00,0.00,0.00),('1','281','3','101',1413,'13','2',57549.30,58461.93,912.63,743793.45,0.00,0.00,0.00,0.00,0.00),('1','281','3','101',1414,'14','2',10892.05,10892.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','102',1415,'1','1',201342.09,203063.63,1721.54,318484.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','102',1416,'2','1',235693.36,237765.41,2072.05,383329.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','102',1417,'3','1',162056.75,162056.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','102',1418,'4','1',235908.26,238071.63,2163.37,400223.45,0.00,0.00,0.00,0.00,0.00),('1','281','1','102',1419,'5','1',158164.09,158555.61,391.52,72431.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','102',1420,'6','1',209138.67,211580.21,2441.54,451684.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','102',1421,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','102',1422,'8','1',337505.93,340733.40,3227.47,597081.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','102',1423,'9','1',171061.88,173044.56,1982.68,366795.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','102',1424,'10','1',207713.09,209448.19,1735.10,320993.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','102',1425,'11','1',222693.35,224842.25,2148.90,397546.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','102',1426,'12','1',220425.04,220425.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','102',1427,'13','2',58461.93,59712.41,1250.48,1019141.20,0.00,0.00,0.00,0.00,0.00),('1','281','3','102',1428,'14','2',10892.05,10986.76,94.71,77188.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','103',1429,'1','1',203063.63,205515.92,2452.29,453673.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','103',1430,'2','1',237765.41,240431.88,2666.47,493296.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','103',1431,'3','1',162056.75,162056.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','103',1432,'4','1',238071.63,241117.87,3046.24,563554.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','103',1433,'5','1',158555.61,158555.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','103',1434,'6','1',211580.21,215141.81,3561.60,658896.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','103',1435,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','103',1436,'8','1',340733.40,343968.89,3235.49,598565.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','103',1437,'9','1',173044.56,173044.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','103',1438,'10','1',209448.19,213242.63,3794.44,701971.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','103',1439,'11','1',224842.25,227953.13,3110.88,575512.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','103',1440,'12','1',220425.04,222618.04,2193.00,405705.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','103',1441,'13','2',59712.41,60314.18,601.77,490442.55,0.00,0.00,0.00,0.00,0.00),('1','281','3','103',1442,'14','2',10986.76,11001.47,14.71,11988.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','104',1443,'1','1',205515.92,205515.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','104',1444,'2','1',240431.88,243121.43,2689.55,497566.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','104',1445,'3','1',162056.75,162056.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','104',1446,'4','1',241117.87,243061.79,1943.92,359625.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','104',1447,'5','1',158555.61,158555.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','104',1448,'6','1',215141.81,218338.40,3196.59,591369.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','104',1449,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','104',1450,'8','1',343968.89,347415.17,3446.28,637561.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','104',1451,'9','1',173044.56,175373.11,2328.55,430781.75,0.00,0.00,0.00,0.00,0.00),('1','281','2','104',1452,'10','1',213242.63,215066.33,1823.70,337384.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','104',1453,'11','1',227953.13,227953.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','104',1454,'12','1',222618.04,225130.42,2512.38,464790.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','104',1455,'13','2',60314.18,61879.83,1565.65,1276004.75,0.00,0.00,0.00,0.00,0.00),('1','281','3','104',1456,'14','2',11001.47,11711.60,710.13,578755.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','105',1457,'1','1',205515.92,207552.35,2036.43,376739.55,0.00,0.00,0.00,0.00,0.00),('1','281','1','105',1458,'2','1',243121.43,245267.05,2145.62,396939.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','105',1459,'3','1',162056.75,162056.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','105',1460,'4','1',243061.79,247191.10,4129.31,763922.35,0.00,0.00,0.00,0.00,0.00),('1','281','1','105',1461,'5','1',158555.61,158555.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','105',1462,'6','1',218338.40,221544.67,3206.27,593159.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','105',1463,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','105',1464,'8','1',347415.17,350549.80,3134.63,579906.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','105',1465,'9','1',175373.11,177826.90,2453.79,453951.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','105',1466,'10','1',215066.33,217159.95,2093.62,387319.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','105',1467,'11','1',227953.13,230092.41,2139.28,395766.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','105',1468,'12','1',225130.42,227279.36,2148.94,397553.90,0.00,0.00,0.00,0.00,0.00),('1','281','3','105',1469,'13','2',61879.83,63274.95,1395.12,1137022.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','105',1470,'14','2',11711.60,11711.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','106',1471,'1','1',207552.35,208019.69,467.34,86457.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','106',1472,'2','1',245267.05,246350.47,1083.42,200432.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','106',1473,'3','1',162056.75,162626.03,569.28,105316.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','106',1474,'4','1',247191.10,248323.39,1132.29,209473.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','106',1475,'5','1',158555.61,159390.65,835.04,154482.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','106',1476,'6','1',221544.67,222070.68,526.01,97311.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','106',1477,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','106',1478,'8','1',350549.80,351376.21,826.41,152885.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','106',1479,'9','1',177826.90,178621.94,795.04,147082.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','106',1480,'10','1',217159.95,218093.26,933.31,172662.35,0.00,0.00,0.00,0.00,0.00),('1','281','2','106',1481,'11','1',230092.41,231271.51,1179.10,218133.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','106',1482,'12','1',227279.36,229239.99,1960.63,362716.55,0.00,0.00,0.00,0.00,0.00),('1','281','3','106',1483,'13','2',63274.95,63976.41,701.46,571689.90,0.00,0.00,0.00,0.00,0.00),('1','281','3','106',1484,'14','2',11711.60,11711.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','107',1485,'1','1',208019.69,209844.73,1825.04,337632.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','107',1486,'2','1',246350.47,248337.02,1986.55,367511.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','107',1487,'3','1',162626.03,162626.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','107',1488,'4','1',248323.39,250387.78,2064.39,381912.15,0.00,0.00,0.00,0.00,0.00),('1','281','1','107',1489,'5','1',159390.65,161364.20,1973.55,365106.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','107',1490,'6','1',222070.68,224238.94,2168.26,401128.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','107',1491,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','107',1492,'8','1',351376.21,354039.94,2663.73,492790.05,0.00,0.00,0.00,0.00,0.00),('1','281','2','107',1493,'9','1',178621.94,178621.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','107',1494,'10','1',218093.26,219904.94,1811.68,335160.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','107',1495,'11','1',231271.51,233376.70,2105.19,389460.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','107',1496,'12','1',229239.99,230858.88,1618.89,299494.65,0.00,0.00,0.00,0.00,0.00),('1','281','3','107',1497,'13','2',63976.41,64806.65,830.24,676645.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','107',1498,'14','2',11711.60,11711.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','108',1499,'1','1',209844.73,209844.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','108',1500,'2','1',248337.02,248337.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','108',1501,'3','1',162626.03,165376.50,2750.47,508836.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','108',1502,'4','1',250387.78,253996.35,3608.57,667585.45,0.00,0.00,0.00,0.00,0.00),('1','281','1','108',1503,'5','1',161364.20,161364.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','108',1504,'6','1',224238.94,224238.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','108',1505,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','108',1506,'8','1',354039.94,357746.96,3707.02,685798.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','108',1507,'9','1',178621.94,178621.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','108',1508,'10','1',219904.94,219904.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','108',1509,'11','1',233376.70,238306.39,4929.69,911992.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','108',1510,'12','1',230858.88,235171.59,4312.71,797851.35,0.00,0.00,0.00,0.00,0.00),('1','281','3','108',1511,'13','2',64806.65,66289.00,1482.35,1208115.25,0.00,0.00,0.00,0.00,0.00),('1','281','3','108',1512,'14','2',11711.60,12616.00,904.40,737086.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','109',1513,'1','1',209844.73,209844.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','109',1514,'2','1',248337.02,248337.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','109',1515,'3','1',165376.50,165376.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','109',1516,'4','1',253996.35,253996.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','109',1517,'5','1',161364.20,161364.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','109',1518,'6','1',224238.94,224238.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','109',1519,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','109',1520,'8','1',357746.96,357746.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','109',1521,'9','1',178621.94,178621.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','109',1522,'10','1',219904.94,219904.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','109',1523,'11','1',238306.39,238306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','109',1524,'12','1',235171.59,235171.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','109',1525,'13','2',66289.00,66461.48,172.48,140571.20,0.00,0.00,0.00,0.00,0.00),('1','281','3','109',1526,'14','2',12616.00,12650.74,34.74,28313.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','110',1527,'1','1',209844.73,209844.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','110',1528,'2','1',248337.02,248337.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','110',1529,'3','1',165376.50,165376.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','110',1530,'4','1',253996.35,253996.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','110',1531,'5','1',161364.20,161364.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','110',1532,'6','1',224238.94,224238.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','110',1533,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','110',1534,'8','1',357746.96,357746.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','110',1535,'9','1',178621.94,178621.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','110',1536,'10','1',219904.94,219904.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','110',1537,'11','1',238306.39,238306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','110',1538,'12','1',235171.59,235171.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','110',1539,'13','2',66461.48,67743.79,1282.31,1045082.65,0.00,0.00,0.00,0.00,0.00),('1','281','3','110',1540,'14','2',12650.74,12987.33,336.59,274320.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','111',1541,'1','1',209844.73,212741.53,2896.80,535908.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','111',1542,'2','1',248337.02,250814.27,2477.25,458291.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','111',1543,'3','1',165376.50,167921.63,2545.13,470849.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','111',1544,'4','1',253996.35,256848.64,2852.29,527673.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','111',1545,'5','1',161364.20,161364.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','111',1546,'6','1',224238.94,227613.36,3374.42,624267.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','111',1547,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','111',1548,'8','1',357746.96,361743.40,3996.44,739341.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','111',1549,'9','1',178621.94,178621.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','111',1550,'10','1',219904.94,223752.20,3847.26,711743.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','111',1551,'11','1',238306.39,241432.60,3126.21,578348.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','111',1552,'12','1',235171.59,237642.38,2470.79,457096.15,0.00,0.00,0.00,0.00,0.00),('1','281','3','111',1553,'13','2',67743.79,68000.43,256.64,209161.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','111',1554,'14','2',12987.33,12987.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','112',1555,'1','1',212741.53,216084.84,3343.31,618512.35,0.00,0.00,0.00,0.00,0.00),('1','281','1','112',1556,'2','1',250814.27,254588.17,3773.90,698171.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','112',1557,'3','1',167921.63,168411.61,489.98,90646.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','112',1558,'4','1',256848.64,258046.65,1198.01,221631.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','112',1559,'5','1',161364.20,164683.80,3319.60,614126.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','112',1560,'6','1',227613.36,231635.36,4022.00,744070.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','112',1561,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','112',1562,'8','1',361743.40,363297.97,1554.57,287595.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','112',1563,'9','1',178621.94,182332.52,3710.58,686457.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','112',1564,'10','1',223752.20,227669.42,3917.22,724685.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','112',1565,'11','1',241432.60,242231.98,799.38,147885.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','112',1566,'12','1',237642.38,238681.78,1039.40,192289.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','112',1567,'13','2',68000.43,69978.91,1978.48,1612461.20,0.00,0.00,0.00,0.00,0.00),('1','281','3','112',1568,'14','2',12987.33,12987.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','113',1569,'1','1',216084.84,218949.96,2865.12,530047.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','113',1570,'2','1',254588.17,257469.46,2881.29,533038.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','113',1571,'3','1',168411.61,170894.88,2483.27,459404.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','113',1572,'4','1',258046.65,260306.28,2259.63,418031.55,0.00,0.00,0.00,0.00,0.00),('1','281','1','113',1573,'5','1',164683.80,164683.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','113',1574,'6','1',231635.36,234940.74,3305.38,611495.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','113',1575,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','113',1576,'8','1',363297.97,367131.16,3833.19,709140.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','113',1577,'9','1',182332.52,182795.77,463.25,85701.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','113',1578,'10','1',227669.42,230910.70,3241.28,599636.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','113',1579,'11','1',242231.98,245109.18,2877.20,532282.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','113',1580,'12','1',238681.78,241814.37,3132.59,579529.15,0.00,0.00,0.00,0.00,0.00),('1','281','3','113',1581,'13','2',69978.91,70723.05,744.14,606474.10,0.00,0.00,0.00,0.00,0.00),('1','281','3','113',1582,'14','2',12987.33,12987.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','114',1583,'1','1',218949.96,221279.11,2329.15,430892.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','114',1584,'2','1',257469.46,259967.36,2497.90,462111.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','114',1585,'3','1',170894.88,172009.81,1114.93,206262.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','114',1586,'4','1',260306.28,262912.01,2605.73,482060.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','114',1587,'5','1',164683.80,167068.47,2384.67,441163.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','114',1588,'6','1',234940.74,237651.33,2710.59,501459.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','114',1589,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','114',1590,'8','1',367131.16,370189.87,3058.71,565861.35,0.00,0.00,0.00,0.00,0.00),('1','281','2','114',1591,'9','1',182795.77,184506.86,1711.09,316551.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','114',1592,'10','1',230910.70,233657.22,2746.52,508106.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','114',1593,'11','1',245109.18,246022.05,912.87,168880.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','114',1594,'12','1',241814.37,244304.84,2490.47,460736.95,0.00,0.00,0.00,0.00,0.00),('1','281','3','114',1595,'13','2',70723.05,72610.35,1887.30,1538149.50,0.00,0.00,0.00,0.00,0.00),('1','281','3','114',1596,'14','2',12987.33,12987.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','115',1597,'1','1',221279.11,224821.67,3542.56,655373.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','115',1598,'2','1',259967.36,263872.12,3904.76,722380.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','115',1599,'3','1',172009.81,173777.89,1768.08,327094.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','115',1600,'4','1',262912.01,264644.70,1732.69,320547.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','115',1601,'5','1',167068.47,168159.22,1090.75,201788.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','115',1602,'6','1',237651.33,242347.50,4696.17,868791.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','115',1603,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','115',1604,'8','1',370189.87,373701.90,3512.03,649725.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','115',1605,'9','1',184506.86,187762.90,3256.04,602367.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','115',1606,'10','1',233657.22,236989.06,3331.84,616390.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','115',1607,'11','1',246022.05,249083.99,3061.94,566458.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','115',1608,'12','1',244304.84,246197.04,1892.20,350057.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','115',1609,'13','2',72610.35,74288.09,1677.74,1367358.10,0.00,0.00,0.00,0.00,0.00),('1','281','3','115',1610,'14','2',12987.33,14387.33,1400.00,1141000.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','116',1611,'1','1',224821.67,227622.22,2800.55,518101.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','116',1612,'2','1',263872.12,267247.84,3375.72,624508.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','116',1613,'3','1',173777.89,175046.74,1268.85,234737.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','116',1614,'4','1',264644.70,266459.30,1814.60,335701.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','116',1615,'5','1',168159.22,171352.89,3193.67,590828.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','116',1616,'6','1',242347.50,245297.79,2950.29,545803.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','116',1617,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','116',1618,'8','1',373701.90,376089.73,2387.83,441748.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','116',1619,'9','1',187762.90,190991.27,3228.37,597248.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','116',1620,'10','1',236989.06,239839.53,2850.47,527336.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','116',1621,'11','1',249083.99,250733.43,1649.44,305146.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','116',1622,'12','1',246197.04,248735.65,2538.61,469642.85,0.00,0.00,0.00,0.00,0.00),('1','281','3','116',1623,'13','2',74288.09,74288.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','116',1624,'14','2',14387.33,14387.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','117',1625,'1','1',227622.22,229909.29,2287.07,423107.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','117',1626,'2','1',267247.84,270395.35,3147.51,582289.35,0.00,0.00,0.00,0.00,0.00),('1','281','1','117',1627,'3','1',175046.74,177649.57,2602.83,481523.55,0.00,0.00,0.00,0.00,0.00),('1','281','1','117',1628,'4','1',266459.30,269368.36,2909.06,538176.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','117',1629,'5','1',171352.89,173747.24,2394.35,442954.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','117',1630,'6','1',245297.79,247885.78,2587.99,478778.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','117',1631,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','117',1632,'8','1',376089.73,380265.52,4175.79,772521.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','117',1633,'9','1',190991.27,193912.99,2921.72,540518.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','117',1634,'10','1',239839.53,241772.59,1933.06,357616.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','117',1635,'11','1',250733.43,254158.82,3425.39,633697.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','117',1636,'12','1',248735.65,251483.06,2747.41,508270.85,0.00,0.00,0.00,0.00,0.00),('1','281','3','117',1637,'13','2',74288.09,74288.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','117',1638,'14','2',14387.33,14387.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','118',1639,'1','1',229909.29,230608.57,699.28,129366.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','118',1640,'2','1',270395.35,270960.28,564.93,104512.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','118',1641,'3','1',177649.57,180090.39,2440.82,451551.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','118',1642,'4','1',269368.36,271991.40,2623.04,485262.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','118',1643,'5','1',173747.24,173747.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','118',1644,'6','1',247885.78,248718.24,832.46,154005.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','118',1645,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','118',1646,'8','1',380265.52,384320.52,4055.00,750175.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','118',1647,'9','1',193912.99,194388.08,475.09,87891.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','118',1648,'10','1',241772.59,242269.86,497.27,91994.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','118',1649,'11','1',254158.82,256899.38,2740.56,507003.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','118',1650,'12','1',251483.06,254251.29,2768.23,512122.55,0.00,0.00,0.00,0.00,0.00),('1','281','3','118',1651,'13','2',74288.09,74288.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','118',1652,'14','2',14387.33,14387.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','119',1653,'1','1',230608.57,230608.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','119',1654,'2','1',270960.28,274278.60,3318.32,613889.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','119',1655,'3','1',180090.39,180090.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','119',1656,'4','1',271991.40,272433.98,442.58,81877.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','119',1657,'5','1',173747.24,173747.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','119',1658,'6','1',248718.24,252003.59,3285.35,607789.75,0.00,0.00,0.00,0.00,0.00),('1','281','2','119',1659,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','119',1660,'8','1',384320.52,384715.60,395.08,73089.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','119',1661,'9','1',194388.08,196322.52,1934.44,357871.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','119',1662,'10','1',242269.86,244595.34,2325.48,430213.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','119',1663,'11','1',256899.38,256899.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','119',1664,'12','1',254251.29,257675.97,3424.68,633565.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','119',1665,'13','2',74288.09,74288.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','119',1666,'14','2',14387.33,14387.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','120',1667,'1','1',230608.57,230811.46,202.89,37534.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','120',1668,'2','1',274278.60,277518.64,3240.04,599407.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','120',1669,'3','1',180090.39,181391.15,1300.76,240640.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','120',1670,'4','1',272433.98,273786.07,1352.09,250136.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','120',1671,'5','1',173747.24,173920.43,173.19,32040.15,0.00,0.00,0.00,0.00,0.00),('1','281','1','120',1672,'6','1',252003.59,254008.48,2004.89,370904.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','120',1673,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','120',1674,'8','1',384715.60,386575.03,1859.43,343994.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','120',1675,'9','1',196322.52,196557.01,234.49,43380.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','120',1676,'10','1',244595.34,247917.64,3322.30,614625.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','120',1677,'11','1',256899.38,258425.20,1525.82,282276.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','120',1678,'12','1',257675.97,259265.20,1589.23,294007.55,0.00,0.00,0.00,0.00,0.00),('1','281','3','120',1679,'13','2',74288.09,74288.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','120',1680,'14','2',14387.33,14387.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','121',1681,'1','1',230811.46,230811.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','121',1682,'2','1',277518.64,282853.63,5334.99,986973.15,0.00,0.00,0.00,0.00,0.00),('1','281','1','121',1683,'3','1',181391.15,181391.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','121',1684,'4','1',273786.07,273786.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','121',1685,'5','1',173920.43,173920.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','121',1686,'6','1',254008.48,259749.39,5740.91,1062068.35,0.00,0.00,0.00,0.00,0.00),('1','281','2','121',1687,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','121',1688,'8','1',386575.03,391366.71,4791.68,886460.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','121',1689,'9','1',196557.01,196557.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','121',1690,'10','1',247917.64,247917.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','121',1691,'11','1',258425.20,258425.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','121',1692,'12','1',259265.20,264607.40,5342.20,988307.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','121',1693,'13','2',74288.09,74288.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','121',1694,'14','2',14387.33,14387.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','122',1695,'1','1',230811.46,230811.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','122',1696,'2','1',282853.63,285521.66,2668.03,493585.55,0.00,0.00,0.00,0.00,0.00),('1','281','1','122',1697,'3','1',181391.15,181391.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','122',1698,'4','1',273786.07,274293.83,507.76,93935.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','122',1699,'5','1',173920.43,173920.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','122',1700,'6','1',259749.39,262864.19,3114.80,576238.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','122',1701,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','122',1702,'8','1',391366.71,394694.34,3327.63,615611.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','122',1703,'9','1',196557.01,196557.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','122',1704,'10','1',247917.64,247917.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','122',1705,'11','1',258425.20,258425.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','122',1706,'12','1',264607.40,268481.87,3874.47,716776.95,0.00,0.00,0.00,0.00,0.00),('1','281','3','122',1707,'13','2',74288.09,74288.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','122',1708,'14','2',14387.33,14387.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','123',1709,'1','1',230811.46,230811.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','123',1710,'2','1',285521.66,285521.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','123',1711,'3','1',181391.15,183634.37,2243.22,414995.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','123',1712,'4','1',274293.83,277300.15,3006.32,556169.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','123',1713,'5','1',173920.43,173920.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','123',1714,'6','1',262864.19,262864.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','123',1715,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','123',1716,'8','1',394694.34,397508.62,2814.28,520641.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','123',1717,'9','1',196557.01,196557.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','123',1718,'10','1',247917.64,247917.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','123',1719,'11','1',258425.20,258425.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','123',1720,'12','1',268481.87,271880.74,3398.87,628790.95,0.00,0.00,0.00,0.00,0.00),('1','281','3','123',1721,'13','2',74288.09,74288.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','123',1722,'14','2',14387.33,14387.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','124',1723,'1','1',230811.46,230811.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','124',1724,'2','1',285521.66,285521.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','124',1725,'3','1',183634.37,185518.98,1884.61,348652.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','124',1726,'4','1',277300.15,279723.41,2423.26,448303.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','124',1727,'5','1',173920.43,173920.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','124',1728,'6','1',262864.19,262864.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','124',1729,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','124',1730,'8','1',397508.62,399966.02,2457.40,454619.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','124',1731,'9','1',196557.01,196557.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','124',1732,'10','1',247917.64,247917.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','124',1733,'11','1',258425.20,259918.08,1492.88,276182.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','124',1734,'12','1',271880.74,274353.15,2472.41,457395.85,0.00,0.00,0.00,0.00,0.00),('1','281','3','124',1735,'13','2',74288.09,74288.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','124',1736,'14','2',14387.33,14387.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','125',1737,'1','1',230811.46,230811.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','125',1738,'2','1',285521.66,290322.76,4801.10,888203.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','125',1739,'3','1',185518.98,185518.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','125',1740,'4','1',279723.41,279723.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','125',1741,'5','1',173920.43,174275.19,354.76,65630.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','125',1742,'6','1',262864.19,267763.23,4899.04,906322.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','125',1743,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','125',1744,'8','1',399966.02,399966.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','125',1745,'9','1',196557.01,197010.31,453.30,83860.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','125',1746,'10','1',247917.64,252463.39,4545.75,840963.75,0.00,0.00,0.00,0.00,0.00),('1','281','2','125',1747,'11','1',259918.08,259918.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','125',1748,'12','1',274353.15,274353.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','125',1749,'13','2',74288.09,74288.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','125',1750,'14','2',14387.33,14387.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','126',1751,'1','1',230811.46,234060.77,3249.31,601122.35,0.00,0.00,0.00,0.00,0.00),('1','281','1','126',1752,'2','1',290322.76,294457.12,4134.36,764856.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','126',1753,'3','1',185518.98,185518.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','126',1754,'4','1',279723.41,279723.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','126',1755,'5','1',174275.19,174275.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','126',1756,'6','1',267763.23,273371.93,5608.70,1037609.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','126',1757,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','126',1758,'8','1',399966.02,399966.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','126',1759,'9','1',197010.31,200496.13,3485.82,644876.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','126',1760,'10','1',252463.39,256863.43,4400.04,814007.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','126',1761,'11','1',259918.08,259918.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','126',1762,'12','1',274353.15,274353.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','126',1763,'13','2',74288.09,74288.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','126',1764,'14','2',14387.33,14387.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','127',1765,'1','1',234060.77,234060.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','127',1766,'2','1',294457.12,295887.53,1430.41,264625.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','127',1767,'3','1',185518.98,187874.11,2355.13,435699.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','127',1768,'4','1',279723.41,283600.63,3877.22,717285.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','127',1769,'5','1',174275.19,174275.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','127',1770,'6','1',273371.93,274823.85,1451.92,268605.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','127',1771,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','127',1772,'8','1',399966.02,404284.20,4308.18,797013.30,0.00,0.00,10.00,0.00,0.00),('1','281','2','127',1773,'9','1',200496.13,200496.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','127',1774,'10','1',256863.43,258214.34,1350.91,249918.35,0.00,0.00,0.00,0.00,0.00),('1','281','2','127',1775,'11','1',259918.08,262423.75,2505.67,463548.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','127',1776,'12','1',274353.15,278401.75,4048.60,748991.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','127',1777,'13','2',74288.09,74288.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','127',1778,'14','2',14387.33,14387.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','128',1779,'1','1',234060.77,234060.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','128',1780,'2','1',295887.53,295887.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','128',1781,'3','1',187874.11,187874.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','128',1782,'4','1',283600.63,283600.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','128',1783,'5','1',174275.19,174275.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','128',1784,'6','1',274823.85,274823.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','128',1785,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','128',1786,'8','1',404284.20,404284.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','128',1787,'9','1',200496.13,200496.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','128',1788,'10','1',258214.34,258214.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','128',1789,'11','1',262423.75,262423.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','128',1790,'12','1',278401.75,278401.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','128',1791,'13','2',74288.09,74673.07,384.98,313758.70,0.00,0.00,0.00,0.00,0.00),('1','281','3','128',1792,'14','2',14387.33,14387.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','129',1793,'1','1',234060.77,234060.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','129',1794,'2','1',295887.53,295887.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','129',1795,'3','1',187874.11,192351.46,4477.35,828309.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','129',1796,'4','1',283600.63,288236.26,4635.63,857591.55,0.00,0.00,0.00,0.00,0.00),('1','281','1','129',1797,'5','1',174275.19,174275.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','129',1798,'6','1',274823.85,274823.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','129',1799,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','129',1800,'8','1',404284.20,409053.61,4769.41,882340.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','129',1801,'9','1',200496.13,200496.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','129',1802,'10','1',258214.34,258214.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','129',1803,'11','1',262423.75,266811.40,4387.65,811715.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','129',1804,'12','1',278401.75,283008.83,4607.08,852309.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','129',1805,'13','2',74673.07,74683.11,10.04,8333.20,0.00,0.00,0.00,0.00,0.00),('1','281','3','129',1806,'14','2',14387.33,14387.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','130',1807,'1','1',234060.77,237274.47,3213.70,594534.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','130',1808,'2','1',295887.53,298465.98,2578.45,477013.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','130',1809,'3','1',192351.46,192351.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','130',1810,'4','1',288236.26,288236.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','130',1811,'5','1',174275.19,176748.09,2472.90,457486.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','130',1812,'6','1',274823.85,281098.44,6274.59,1160799.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','130',1813,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','130',1814,'8','1',409053.61,409053.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','130',1815,'9','1',200496.13,204085.84,3589.71,664096.35,0.00,0.00,0.00,0.00,0.00),('1','281','2','130',1816,'10','1',258214.34,261631.72,3417.38,632215.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','130',1817,'11','1',266811.40,266811.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','130',1818,'12','1',283008.83,283008.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','130',1819,'13','2',74683.11,76069.54,1386.43,1150736.90,0.00,0.00,0.00,0.00,0.00),('1','281','3','130',1820,'14','2',14387.33,14436.72,49.39,40993.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','131',1821,'1','1',237274.47,240311.33,3036.86,561819.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','131',1822,'2','1',298465.98,301163.51,2697.53,499043.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','131',1823,'3','1',192351.46,192351.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','131',1824,'4','1',288236.26,288236.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','131',1825,'5','1',176748.09,179946.52,3198.43,591709.55,0.00,0.00,0.00,0.00,0.00),('1','281','1','131',1826,'6','1',281098.44,284284.70,3186.26,589458.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','131',1827,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','131',1828,'8','1',409053.61,409053.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','131',1829,'9','1',204085.84,206677.92,2592.08,479534.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','131',1830,'10','1',261631.72,265158.24,3526.52,652406.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','131',1831,'11','1',266811.40,266811.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','131',1832,'12','1',283008.83,283008.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','131',1833,'13','2',76069.54,76471.69,402.15,333784.50,0.00,0.00,0.00,0.00,0.00),('1','281','3','131',1834,'14','2',14436.72,14436.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','132',1835,'1','1',240311.33,240311.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','132',1836,'2','1',301163.51,301163.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','132',1837,'3','1',192351.46,196307.13,3955.67,731798.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','132',1838,'4','1',288236.26,291298.75,3062.49,566560.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','132',1839,'5','1',179946.52,179946.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','132',1840,'6','1',284284.70,284284.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','132',1841,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','132',1842,'8','1',409053.61,413444.01,4390.40,812224.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','132',1843,'9','1',206677.92,206677.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','132',1844,'10','1',265158.24,265158.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','132',1845,'11','1',266811.40,271168.41,4357.01,806046.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','132',1846,'12','1',283008.83,287180.60,4171.77,771777.45,0.00,0.00,0.00,0.00,0.00),('1','281','3','132',1847,'13','2',76471.69,76736.98,265.29,220190.70,0.00,0.00,0.00,0.00,0.00),('1','281','3','132',1848,'14','2',14436.72,14818.59,381.87,316952.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','133',1849,'1','1',240311.33,240311.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','133',1850,'2','1',301163.51,301163.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','133',1851,'3','1',196307.13,200426.74,4119.61,762127.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','133',1852,'4','1',291298.75,295896.14,4597.39,850517.15,0.00,0.00,0.00,0.00,0.00),('1','281','1','133',1853,'5','1',179946.52,179946.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','133',1854,'6','1',284284.70,284284.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','133',1855,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','133',1856,'8','1',413444.01,418097.98,4653.97,860984.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','133',1857,'9','1',206677.92,206677.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','133',1858,'10','1',265158.24,265158.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','133',1859,'11','1',271168.41,275025.18,3856.77,713502.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','133',1860,'12','1',287180.60,290510.70,3320.10,614218.50,0.00,0.00,10.00,0.00,0.00),('1','281','3','133',1861,'13','2',76736.98,77457.87,720.89,598338.70,0.00,0.00,0.00,0.00,0.00),('1','281','3','133',1862,'14','2',14818.59,14818.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','134',1863,'1','1',240311.33,241423.08,1111.75,205673.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','134',1864,'2','1',301163.51,305789.52,4626.01,855811.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','134',1865,'3','1',200426.74,201289.25,862.51,159564.35,0.00,0.00,0.00,0.00,0.00),('1','281','1','134',1866,'4','1',295896.14,296700.48,804.34,148802.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','134',1867,'5','1',179946.52,180920.83,974.31,180247.35,0.00,0.00,0.00,0.00,0.00),('1','281','1','134',1868,'6','1',284284.70,288742.63,4457.93,824717.05,0.00,0.00,0.00,0.00,0.00),('1','281','2','134',1869,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','134',1870,'8','1',418097.98,423473.17,5375.19,994410.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','134',1871,'9','1',206677.92,207574.90,896.98,165941.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','134',1872,'10','1',265158.24,265977.09,818.85,151487.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','134',1873,'11','1',275025.18,277574.45,2549.27,471614.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','134',1874,'12','1',290510.70,295093.81,4583.11,847875.35,0.00,0.00,0.00,0.00,0.00),('1','281','3','134',1875,'13','2',77457.87,78746.24,1288.37,1069347.10,0.00,0.00,0.00,0.00,0.00),('1','281','3','134',1876,'14','2',14818.59,14977.83,159.24,132169.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','135',1877,'1','1',241423.08,241423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','135',1878,'2','1',305789.52,310721.34,4931.82,912386.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','135',1879,'3','1',201289.25,201289.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','135',1880,'4','1',296700.48,296700.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','135',1881,'5','1',180920.83,180920.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','135',1882,'6','1',288742.63,293699.45,4956.82,917011.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','135',1883,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','135',1884,'8','1',423473.17,423917.28,444.11,82160.35,0.00,0.00,0.00,0.00,0.00),('1','281','2','135',1885,'9','1',207574.90,211067.16,3492.26,646068.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','135',1886,'10','1',265977.09,269521.40,3544.31,655697.35,0.00,0.00,0.00,0.00,0.00),('1','281','2','135',1887,'11','1',277574.45,277574.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','135',1888,'12','1',295093.81,295497.59,403.78,74699.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','135',1889,'13','2',78746.24,82935.60,4189.36,3477168.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','135',1890,'14','2',14977.83,15147.95,170.12,141199.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','136',1891,'1','1',241423.08,241423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','136',1892,'2','1',310721.34,314479.00,3757.66,695167.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','136',1893,'3','1',201289.25,201289.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','136',1894,'4','1',296700.48,296700.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','136',1895,'5','1',180920.83,180920.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','136',1896,'6','1',293699.45,297515.43,3815.98,705956.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','136',1897,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','136',1898,'8','1',423917.28,427447.52,3530.24,653094.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','136',1899,'9','1',211067.16,211067.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','136',1900,'10','1',269521.40,269521.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','136',1901,'11','1',277574.45,277574.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','136',1902,'12','1',295497.59,299075.41,3577.82,661896.70,0.00,0.00,0.00,0.00,0.00),('1','281','3','136',1903,'13','2',82935.60,82937.82,2.22,1842.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','136',1904,'14','2',15147.95,15157.60,9.65,8009.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','137',1905,'1','1',241423.08,241423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','137',1906,'2','1',314479.00,318228.74,3749.74,693701.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','137',1907,'3','1',201289.25,201289.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','137',1908,'4','1',296700.48,296700.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','137',1909,'5','1',180920.83,180920.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','137',1910,'6','1',297515.43,301245.45,3730.02,690053.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','137',1911,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','137',1912,'8','1',427447.52,432332.77,4885.25,903771.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','137',1913,'9','1',211067.16,211067.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','137',1914,'10','1',269521.40,269521.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','137',1915,'11','1',277574.45,277574.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','137',1916,'12','1',299075.41,303989.14,4913.73,909040.05,0.00,0.00,0.00,0.00,0.00),('1','281','3','137',1917,'13','2',82937.82,83008.77,70.95,58888.50,0.00,0.00,0.00,0.00,0.00),('1','281','3','137',1918,'14','2',15157.60,15222.66,65.06,53999.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','138',1919,'1','1',241423.08,241423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','138',1920,'2','1',318228.74,318228.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','138',1921,'3','1',201289.25,202435.57,1146.32,212069.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','138',1922,'4','1',296700.48,299774.63,3074.15,568717.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','138',1923,'5','1',180920.83,180920.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','138',1924,'6','1',301245.45,301245.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','138',1925,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','138',1926,'8','1',432332.77,435517.54,3184.77,589182.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','138',1927,'9','1',211067.16,211067.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','138',1928,'10','1',269521.40,269521.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','138',1929,'11','1',277574.45,279796.68,2222.23,411112.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','138',1930,'12','1',303989.14,307131.21,3142.07,581282.95,0.00,0.00,0.00,0.00,0.00),('1','281','3','138',1931,'13','2',83008.77,83102.49,93.72,77787.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','138',1932,'14','2',15222.66,15222.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','139',1933,'1','1',241423.08,241423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','139',1934,'2','1',318228.74,318228.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','139',1935,'3','1',202435.57,202435.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','139',1936,'4','1',299774.63,299774.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','139',1937,'5','1',180920.83,180920.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','139',1938,'6','1',301245.45,301245.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','139',1939,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','139',1940,'8','1',435517.54,435517.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','139',1941,'9','1',211067.16,211067.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','139',1942,'10','1',269521.40,269521.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','139',1943,'11','1',279796.68,279796.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','139',1944,'12','1',307131.21,307131.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','139',1945,'13','2',83102.49,83343.11,240.62,199714.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','139',1946,'14','2',15222.66,15223.68,1.02,846.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','140',1947,'1','1',241423.08,241423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','140',1948,'2','1',318228.74,322130.06,3901.32,721744.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','140',1949,'3','1',202435.57,202435.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','140',1950,'4','1',299774.63,300918.08,1143.45,211538.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','140',1951,'5','1',180920.83,180920.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','140',1952,'6','1',301245.45,305104.13,3858.68,713855.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','140',1953,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','140',1954,'8','1',435517.54,439059.18,3541.64,655203.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','140',1955,'9','1',211067.16,211067.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','140',1956,'10','1',269521.40,269521.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','140',1957,'11','1',279796.68,282502.17,2705.49,500515.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','140',1958,'12','1',307131.21,309917.12,2785.91,515393.35,0.00,0.00,0.00,0.00,0.00),('1','281','3','140',1959,'13','2',83343.11,85541.77,2198.66,1824887.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','140',1960,'14','2',15223.68,15234.54,10.86,9013.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','141',1961,'1','1',241423.08,241423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','141',1962,'2','1',322130.06,326993.56,4863.50,899747.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','141',1963,'3','1',202435.57,202435.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','141',1964,'4','1',300918.08,301869.97,951.89,176099.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','141',1965,'5','1',180920.83,185846.05,4925.22,911165.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','141',1966,'6','1',305104.13,308640.39,3536.26,654208.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','141',1967,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','141',1968,'8','1',439059.18,440273.36,1214.18,224623.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','141',1969,'9','1',211067.16,213682.98,2615.82,483926.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','141',1970,'10','1',269521.40,272524.65,3003.25,555601.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','141',1971,'11','1',282502.17,283270.15,767.98,142076.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','141',1972,'12','1',309917.12,311427.85,1510.73,279485.05,0.00,0.00,0.00,0.00,0.00),('1','281','3','141',1973,'13','2',85541.77,90013.32,4471.55,3711386.50,0.00,0.00,0.00,0.00,0.00),('1','281','3','141',1974,'14','2',15234.54,15318.46,83.92,69653.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','142',1975,'1','1',241423.08,241423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','142',1976,'2','1',326993.56,329716.78,2723.22,503795.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','142',1977,'3','1',202435.57,202435.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','142',1978,'4','1',301869.97,302984.86,1114.89,206254.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','142',1979,'5','1',185846.05,188197.77,2351.72,435068.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','142',1980,'6','1',308640.39,311040.11,2399.72,443948.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','142',1981,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','142',1982,'8','1',440273.36,443956.79,3683.43,681434.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','142',1983,'9','1',213682.98,213682.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','142',1984,'10','1',272524.65,273705.96,1181.31,218542.35,0.00,0.00,0.00,0.00,0.00),('1','281','2','142',1985,'11','1',283270.15,284137.91,867.76,160535.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','142',1986,'12','1',311427.85,315354.76,3926.91,726478.35,0.00,0.00,0.00,0.00,0.00),('1','281','3','142',1987,'13','2',90013.32,93480.44,3467.12,2877709.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','142',1988,'14','2',15318.46,15624.92,306.46,254361.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','143',1989,'1','1',241423.08,241423.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','143',1990,'2','1',329716.78,329716.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','143',1991,'3','1',202435.57,206001.57,3566.00,659710.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','143',1992,'4','1',302984.86,307082.36,4097.50,758037.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','143',1993,'5','1',188197.77,188197.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','143',1994,'6','1',311040.11,311040.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','143',1995,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','143',1996,'8','1',443956.79,448778.85,4822.06,892081.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','143',1997,'9','1',213682.98,213682.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','143',1998,'10','1',273705.96,273705.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','143',1999,'11','1',284137.91,288278.79,4140.88,766062.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','143',2000,'12','1',315354.76,319481.68,4126.92,763480.20,0.00,0.00,0.00,0.00,0.00),('1','281','3','143',2001,'13','2',93480.44,93480.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','143',2002,'14','2',15624.92,15624.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','144',2003,'1','1',241423.08,244720.78,3297.70,610074.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','144',2004,'2','1',329716.78,332851.29,3134.51,579884.35,0.00,0.00,0.00,0.00,0.00),('1','281','1','144',2005,'3','1',206001.57,206001.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','144',2006,'4','1',307082.36,307082.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','144',2007,'5','1',188197.77,191877.12,3679.35,680679.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','144',2008,'6','1',311040.11,314277.73,3237.62,598959.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','144',2009,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','144',2010,'8','1',448778.85,448778.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','144',2011,'9','1',213682.98,217101.51,3418.53,632428.05,0.00,0.00,0.00,0.00,0.00),('1','281','2','144',2012,'10','1',273705.96,276687.82,2981.86,551644.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','144',2013,'11','1',288278.79,288278.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','144',2014,'12','1',319481.68,319481.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','144',2015,'13','2',93480.44,93480.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','144',2016,'14','2',15624.92,15624.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','145',2017,'1','1',244720.78,247875.45,3154.67,583613.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','145',2018,'2','1',332851.29,335902.49,3051.20,564472.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','145',2019,'3','1',206001.57,206001.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','145',2020,'4','1',307082.36,307082.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','145',2021,'5','1',191877.12,195530.16,3653.04,675812.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','145',2022,'6','1',314277.73,317429.99,3152.26,583168.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','145',2023,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','145',2024,'8','1',448778.85,448778.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','145',2025,'9','1',217101.51,220772.52,3671.01,679136.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','145',2026,'10','1',276687.82,280054.64,3366.82,622861.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','145',2027,'11','1',288278.79,288278.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','145',2028,'12','1',319481.68,319481.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','145',2029,'13','2',93480.44,93699.86,219.42,182118.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','145',2030,'14','2',15624.92,15624.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','146',2031,'1','1',247875.45,250206.11,2330.66,431172.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','146',2032,'2','1',335902.49,337018.66,1116.17,206491.45,0.00,0.00,0.00,0.00,0.00),('1','281','1','146',2033,'3','1',206001.57,207831.75,1830.18,338583.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','146',2034,'4','1',307082.36,308267.24,1184.88,219202.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','146',2035,'5','1',195530.16,195530.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','146',2036,'6','1',317429.99,321353.94,3923.95,725930.75,0.00,0.00,0.00,0.00,0.00),('1','281','2','146',2037,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','146',2038,'8','1',448778.85,452015.97,3237.12,598867.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','146',2039,'9','1',220772.52,222589.73,1817.21,336183.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','146',2040,'10','1',280054.64,281600.84,1546.20,286047.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','146',2041,'11','1',288278.79,290012.06,1733.27,320654.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','146',2042,'12','1',319481.68,320904.86,1423.18,263288.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','146',2043,'13','2',93699.86,94967.66,1267.80,1052274.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','146',2044,'14','2',15624.92,15660.22,35.30,29299.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','147',2045,'1','1',250206.11,250206.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','147',2046,'2','1',337018.66,341240.54,4221.88,781047.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','147',2047,'3','1',207831.75,207831.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','147',2048,'4','1',308267.24,310684.66,2417.42,447222.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','147',2049,'5','1',195530.16,195983.73,453.57,83910.45,0.00,0.00,0.00,0.00,0.00),('1','281','1','147',2050,'6','1',321353.94,324592.37,3238.43,599109.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','147',2051,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','147',2052,'8','1',452015.97,454804.01,2788.04,515787.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','147',2053,'9','1',222589.73,222589.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','147',2054,'10','1',281600.84,284860.06,3259.22,602955.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','147',2055,'11','1',290012.06,290012.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','147',2056,'12','1',320904.86,323243.04,2338.18,432563.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','147',2057,'13','2',94967.66,95270.57,302.91,251415.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','147',2058,'14','2',15660.22,15690.94,30.72,25497.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','148',2059,'1','1',250206.11,252901.15,2695.04,498582.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','148',2060,'2','1',341240.54,344012.72,2772.18,512853.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','148',2061,'3','1',207831.75,207831.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','148',2062,'4','1',310684.66,310684.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','148',2063,'5','1',195983.73,199043.15,3059.42,565992.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','148',2064,'6','1',324592.37,328117.21,3524.84,652095.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','148',2065,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','148',2066,'8','1',454804.01,454804.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','148',2067,'9','1',222589.73,225783.76,3194.03,590895.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','148',2068,'10','1',284860.06,288222.47,3362.41,622045.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','148',2069,'11','1',290012.06,290012.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','148',2070,'12','1',323243.04,323243.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','148',2071,'13','2',95270.57,96415.03,1144.46,949901.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','148',2072,'14','2',15690.94,15690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','149',2073,'1','1',252901.15,254492.58,1591.43,294414.55,0.00,0.00,0.00,0.00,0.00),('1','281','1','149',2074,'2','1',344012.72,345632.42,1619.70,299644.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','149',2075,'3','1',207831.75,207831.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','149',2076,'4','1',310684.66,310684.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','149',2077,'5','1',199043.15,200639.46,1596.31,295317.35,0.00,0.00,0.00,0.00,0.00),('1','281','1','149',2078,'6','1',328117.21,329836.47,1719.26,318063.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','149',2079,'7','1',405.83,405.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','149',2080,'8','1',454804.01,454804.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','149',2081,'9','1',225783.76,228304.21,2520.45,466283.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','149',2082,'10','1',288222.47,289746.50,1524.03,281945.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','149',2083,'11','1',290012.06,290012.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','149',2084,'12','1',323243.04,323243.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','149',2085,'13','2',96415.03,97868.91,1453.88,1206720.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','149',2086,'14','2',15690.94,15690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','150',2087,'1','1',254492.58,254492.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','150',2088,'2','1',345632.42,345632.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','150',2089,'3','1',207831.75,210138.30,2306.55,426711.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','150',2090,'4','1',310684.66,314006.33,3321.67,614508.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','150',2091,'5','1',200639.46,200639.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','150',2092,'6','1',329836.47,329836.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','150',2093,'7','1',405.83,2123.68,1717.85,317802.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','150',2094,'8','1',454804.01,457793.93,2989.92,553135.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','150',2095,'9','1',228304.21,228304.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','150',2096,'10','1',289746.50,289746.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','150',2097,'11','1',290012.06,293086.87,3074.81,568839.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','150',2098,'12','1',323243.04,326382.20,3139.16,580744.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','150',2099,'13','2',97868.91,97991.61,122.70,101841.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','150',2100,'14','2',15690.94,15754.07,63.13,52397.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','151',2101,'1','1',254492.58,254492.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','151',2102,'2','1',345632.42,345632.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','151',2103,'3','1',210138.30,210138.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','151',2104,'4','1',314006.33,314006.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','151',2105,'5','1',200639.46,200639.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','151',2106,'6','1',329836.47,329836.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','151',2107,'7','1',2123.68,2123.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','151',2108,'8','1',457793.93,457793.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','151',2109,'9','1',228304.21,228304.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','151',2110,'10','1',289746.50,289746.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','151',2111,'11','1',293086.87,293086.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','151',2112,'12','1',326382.20,326382.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','151',2113,'13','2',97991.61,98293.80,302.19,250817.70,0.00,0.00,0.00,0.00,0.00),('1','281','3','151',2114,'14','2',15754.07,15842.15,88.08,73106.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','152',2115,'1','1',254492.58,257895.74,3403.16,629584.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','152',2116,'2','1',345632.42,348840.99,3208.57,593585.45,0.00,0.00,0.00,0.00,0.00),('1','281','1','152',2117,'3','1',210138.30,210138.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','152',2118,'4','1',314006.33,314006.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','152',2119,'5','1',200639.46,205105.36,4465.90,826191.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','152',2120,'6','1',329836.47,333150.73,3314.26,613138.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','152',2121,'7','1',2123.68,2123.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','152',2122,'8','1',457793.93,457793.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','152',2123,'9','1',228304.21,231959.15,3654.94,676163.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','152',2124,'10','1',289746.50,293028.50,3282.00,607170.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','152',2125,'11','1',293086.87,293086.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','152',2126,'12','1',326382.20,326382.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','152',2127,'13','2',98293.80,98541.72,247.92,205773.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','152',2128,'14','2',15842.15,15938.37,96.22,79862.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','153',2129,'1','1',257895.74,259909.99,2014.25,372636.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','153',2130,'2','1',348840.99,350844.01,2003.02,370558.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','153',2131,'3','1',210138.30,210138.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','153',2132,'4','1',314006.33,314006.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','153',2133,'5','1',205105.36,206961.00,1855.64,343293.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','153',2134,'6','1',333150.73,335053.11,1902.38,351940.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','153',2135,'7','1',2123.68,2123.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','153',2136,'8','1',457793.93,457793.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','153',2137,'9','1',231959.15,233972.47,2013.32,372464.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','153',2138,'10','1',293028.50,294754.47,1725.97,319304.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','153',2139,'11','1',293086.87,293086.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','153',2140,'12','1',326382.20,326382.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','153',2141,'13','2',98541.72,99978.32,1436.60,1192378.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','153',2142,'14','2',15938.37,15939.82,1.45,1203.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','154',2143,'1','1',259909.99,263407.79,3497.80,647093.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','154',2144,'2','1',350844.01,354297.15,3453.14,638830.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','154',2145,'3','1',210138.30,210138.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','154',2146,'4','1',314006.33,314006.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','154',2147,'5','1',206961.00,211021.64,4060.64,751218.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','154',2148,'6','1',335053.11,342248.07,7194.96,1331067.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','154',2149,'7','1',2123.68,2123.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','154',2150,'8','1',457793.93,457793.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','154',2151,'9','1',233972.47,237236.54,3264.07,603852.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','154',2152,'10','1',294754.47,298824.91,4070.44,753031.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','154',2153,'11','1',293086.87,293086.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','154',2154,'12','1',326382.20,326382.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','154',2155,'13','2',99978.32,103621.99,3643.67,3024246.10,0.00,0.00,0.00,0.00,0.00),('1','281','3','154',2156,'14','2',15939.82,15993.64,53.82,44670.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','155',2157,'1','1',263407.79,265331.10,1923.31,355812.35,0.00,0.00,0.00,0.00,0.00),('1','281','1','155',2158,'2','1',354297.15,356671.82,2374.67,439313.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','155',2159,'3','1',210138.30,210437.08,298.78,55274.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','155',2160,'4','1',314006.33,314006.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','155',2161,'5','1',211021.64,212792.71,1771.07,327647.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','155',2162,'6','1',342248.07,345730.50,3482.43,644249.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','155',2163,'7','1',2123.68,2123.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','155',2164,'8','1',457793.93,457793.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','155',2165,'9','1',237236.54,239443.68,2207.14,408320.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','155',2166,'10','1',298824.91,301264.45,2439.54,451314.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','155',2167,'11','1',293086.87,293086.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','155',2168,'12','1',326382.20,326382.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','155',2169,'13','2',103621.99,103893.10,271.11,225021.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','155',2170,'14','2',15993.64,16048.73,55.09,45724.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','156',2171,'1','1',265331.10,265331.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','156',2172,'2','1',356671.82,356671.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','156',2173,'3','1',210437.08,210437.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','156',2174,'4','1',314006.33,314006.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','156',2175,'5','1',212792.71,212792.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','156',2176,'6','1',345730.50,345730.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','156',2177,'7','1',2123.68,2123.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','156',2178,'8','1',457793.93,457793.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','156',2179,'9','1',239443.68,239443.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','156',2180,'10','1',301264.45,301264.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','156',2181,'11','1',293086.87,293086.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','156',2182,'12','1',326382.20,326382.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','156',2183,'13','2',103893.10,103893.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','156',2184,'14','2',16048.73,16048.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','157',2185,'1','1',265331.10,265331.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','157',2186,'2','1',356671.82,361344.41,4672.59,864429.15,0.00,0.00,0.00,0.00,0.00),('1','281','1','157',2187,'3','1',210437.08,210437.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','157',2188,'4','1',314006.33,317977.85,3971.52,734731.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','157',2189,'5','1',212792.71,212792.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','157',2190,'6','1',345730.50,351164.18,5433.68,1005230.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','157',2191,'7','1',2123.68,2123.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','157',2192,'8','1',457793.93,462247.73,4453.80,823953.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','157',2193,'9','1',239443.68,239443.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','157',2194,'10','1',301264.45,305536.22,4271.77,790277.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','157',2195,'11','1',293086.87,293086.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','157',2196,'12','1',326382.20,330706.21,4324.01,799941.85,0.00,0.00,0.00,0.00,0.00),('1','281','3','157',2197,'13','2',103893.10,104848.91,955.81,793322.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','157',2198,'14','2',16048.73,16135.41,86.68,71944.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','158',2199,'1','1',265331.10,265331.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','158',2200,'2','1',361344.41,365567.06,4222.65,781190.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','158',2201,'3','1',210437.08,210437.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','158',2202,'4','1',317977.85,320356.26,2378.41,440005.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','158',2203,'5','1',212792.71,212792.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','158',2204,'6','1',351164.18,354905.71,3741.53,692183.05,0.00,0.00,0.00,0.00,0.00),('1','281','2','158',2205,'7','1',2123.68,2123.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','158',2206,'8','1',462247.73,464623.29,2375.56,439478.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','158',2207,'9','1',239443.68,239443.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','158',2208,'10','1',305536.22,309503.42,3967.20,733932.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','158',2209,'11','1',293086.87,293086.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','158',2210,'12','1',330706.21,333115.65,2409.44,445746.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','158',2211,'13','2',104848.91,105021.08,172.17,142901.10,0.00,0.00,0.00,0.00,0.00),('1','281','3','158',2212,'14','2',16135.41,16155.89,20.48,16998.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','159',2213,'1','1',265331.10,265331.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','159',2214,'2','1',365567.06,369757.68,4190.62,775264.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','159',2215,'3','1',210437.08,210437.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','159',2216,'4','1',320356.26,323650.45,3294.19,609425.15,0.00,0.00,0.00,0.00,0.00),('1','281','1','159',2217,'5','1',212792.71,212792.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','159',2218,'6','1',354905.71,359071.50,4165.79,770671.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','159',2219,'7','1',2123.68,2123.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','159',2220,'8','1',464623.29,468581.82,3958.53,732328.05,0.00,0.00,0.00,0.00,0.00),('1','281','2','159',2221,'9','1',239443.68,239443.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','159',2222,'10','1',309503.42,313345.40,3841.98,710766.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','159',2223,'11','1',293086.87,293086.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','159',2224,'12','1',333115.65,337140.10,4024.45,744523.25,0.00,0.00,0.00,0.00,0.00),('1','281','3','159',2225,'13','2',105021.08,105862.59,841.51,698453.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','159',2226,'14','2',16155.89,16257.56,101.67,84386.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','160',2227,'1','1',265331.10,265331.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','160',2228,'2','1',369757.68,371561.14,1803.46,333640.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','160',2229,'3','1',210437.08,210617.36,180.28,33351.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','160',2230,'4','1',323650.45,325573.09,1922.64,355688.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','160',2231,'5','1',212792.71,212792.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','160',2232,'6','1',359071.50,361034.85,1963.35,363219.75,0.00,0.00,0.00,0.00,0.00),('1','281','2','160',2233,'7','1',2123.68,2123.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','160',2234,'8','1',468581.82,470429.18,1847.36,341761.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','160',2235,'9','1',239443.68,239443.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','160',2236,'10','1',313345.40,315167.89,1822.49,337160.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','160',2237,'11','1',293086.87,293086.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','160',2238,'12','1',337140.10,339035.38,1895.28,350626.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','160',2239,'13','2',105862.59,107140.69,1278.10,1060823.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','160',2240,'14','2',16257.56,16257.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','161',2241,'1','1',265331.10,265331.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','161',2242,'2','1',371561.14,371561.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','161',2243,'3','1',210617.36,212175.61,1558.25,288276.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','161',2244,'4','1',325573.09,329451.72,3878.63,717546.55,0.00,0.00,0.00,0.00,0.00),('1','281','1','161',2245,'5','1',212792.71,212792.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','161',2246,'6','1',361034.85,361034.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','161',2247,'7','1',2123.68,2123.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','161',2248,'8','1',470429.18,474458.95,4029.77,745507.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','161',2249,'9','1',239443.68,239443.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','161',2250,'10','1',315167.89,315167.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','161',2251,'11','1',293086.87,296182.25,3095.38,572645.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','161',2252,'12','1',339035.38,342598.51,3563.13,659179.05,0.00,0.00,0.00,0.00,0.00),('1','281','3','161',2253,'13','2',107140.69,109399.73,2259.04,1875003.20,0.00,0.00,0.00,0.00,0.00),('1','281','3','161',2254,'14','2',16257.56,16413.94,156.38,129795.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','162',2255,'1','1',265331.10,265331.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','162',2256,'2','1',371561.14,371561.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','162',2257,'3','1',212175.61,212175.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','162',2258,'4','1',329451.72,329451.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','162',2259,'5','1',212792.71,212792.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','162',2260,'6','1',361034.85,361034.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','162',2261,'7','1',2123.68,2123.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','162',2262,'8','1',474458.95,474458.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','162',2263,'9','1',239443.68,239443.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','162',2264,'10','1',315167.89,315167.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','162',2265,'11','1',296182.25,296182.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','162',2266,'12','1',342598.51,342598.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','162',2267,'13','2',109399.73,109603.65,203.92,169253.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','162',2268,'14','2',16413.94,16463.99,50.05,41541.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','163',2269,'1','1',265331.10,265331.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','163',2270,'2','1',371561.14,371561.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','163',2271,'3','1',212175.61,214634.98,2459.37,454983.45,0.00,0.00,0.00,0.00,0.00),('1','281','1','163',2272,'4','1',329451.72,332981.81,3530.09,653066.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','163',2273,'5','1',212792.71,212792.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','163',2274,'6','1',361034.85,361034.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','163',2275,'7','1',2123.68,2123.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','163',2276,'8','1',474458.95,478226.96,3768.01,697081.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','163',2277,'9','1',239443.68,239443.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','163',2278,'10','1',315167.89,315167.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','163',2279,'11','1',296182.25,300581.89,4399.64,813933.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','163',2280,'12','1',342598.51,345893.09,3294.58,609497.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','163',2281,'13','2',109603.65,109882.66,279.01,231578.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','163',2282,'14','2',16463.99,16548.63,84.64,70251.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','164',2283,'1','1',265331.10,265331.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','164',2284,'2','1',371561.14,371561.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','164',2285,'3','1',214634.98,214634.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','164',2286,'4','1',332981.81,332981.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','164',2287,'5','1',212792.71,212792.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','164',2288,'6','1',361034.85,361034.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','164',2289,'7','1',2123.68,2123.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','164',2290,'8','1',478226.96,478226.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','164',2291,'9','1',239443.68,239443.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','164',2292,'10','1',315167.89,315167.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','164',2293,'11','1',300581.89,300581.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','164',2294,'12','1',345893.09,345893.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','164',2295,'13','2',109882.66,110035.47,152.81,126832.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','164',2296,'14','2',16548.63,16589.11,40.48,33598.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','165',2297,'1','1',265331.10,265331.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','165',2298,'2','1',371561.14,371561.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','165',2299,'3','1',214634.98,218125.59,3490.61,645762.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','165',2300,'4','1',332981.81,336731.12,3749.31,693622.35,0.00,0.00,0.00,0.00,0.00),('1','281','1','165',2301,'5','1',212792.71,212792.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','165',2302,'6','1',361034.85,361034.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','165',2303,'7','1',2123.68,2123.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','165',2304,'8','1',478226.96,482685.18,4458.22,824770.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','165',2305,'9','1',239443.68,239443.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','165',2306,'10','1',315167.89,315167.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','165',2307,'11','1',300581.89,303933.11,3351.22,619975.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','165',2308,'12','1',345893.09,350910.89,5017.80,928293.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','165',2309,'13','2',110035.47,110040.29,4.82,4000.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','165',2310,'14','2',16589.11,16617.43,28.32,23505.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','166',2311,'1','1',265331.10,265331.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','166',2312,'2','1',371561.14,371561.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','166',2313,'3','1',218125.59,218125.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','166',2314,'4','1',336731.12,336731.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','166',2315,'5','1',212792.71,212792.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','166',2316,'6','1',361034.85,361034.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','166',2317,'7','1',2123.68,2123.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','166',2318,'8','1',482685.18,482685.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','166',2319,'9','1',239443.68,239443.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','166',2320,'10','1',315167.89,315167.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','166',2321,'11','1',303933.11,303933.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','166',2322,'12','1',350910.89,350910.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','166',2323,'13','2',110040.29,111480.90,1440.61,1195706.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','166',2324,'14','2',16617.43,16659.13,41.70,34611.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','167',2325,'1','1',265331.10,268707.45,3376.35,624624.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','167',2326,'2','1',371561.14,375085.69,3524.55,652041.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','167',2327,'3','1',218125.59,218125.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','167',2328,'4','1',336731.12,336733.87,2.75,508.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','167',2329,'5','1',212792.71,216183.06,3390.35,627214.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','167',2330,'6','1',361034.85,365363.57,4328.72,800813.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','167',2331,'7','1',2123.68,2123.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','167',2332,'8','1',482685.18,482685.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','167',2333,'9','1',239443.68,242958.08,3514.40,650164.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','167',2334,'10','1',315167.89,318603.56,3435.67,635598.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','167',2335,'11','1',303933.11,303933.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','167',2336,'12','1',350910.89,350910.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','167',2337,'13','2',111480.90,112374.30,893.40,741522.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','167',2338,'14','2',16659.13,16757.95,98.82,82020.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','168',2339,'1','1',268707.45,271635.75,2928.30,541735.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','168',2340,'2','1',375085.69,377814.18,2728.49,504770.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','168',2341,'3','1',218125.59,218125.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','168',2342,'4','1',336733.87,336733.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','168',2343,'5','1',216183.06,218846.08,2663.02,492658.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','168',2344,'6','1',365363.57,369467.00,4103.43,759134.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','168',2345,'7','1',2123.68,2123.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','168',2346,'8','1',482685.18,482685.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','168',2347,'9','1',242958.08,245769.23,2811.15,520062.75,0.00,0.00,0.00,0.00,0.00),('1','281','2','168',2348,'10','1',318603.56,321831.91,3228.35,597244.75,0.00,0.00,0.00,0.00,0.00),('1','281','2','168',2349,'11','1',303933.11,303933.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','168',2350,'12','1',350910.89,350910.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','168',2351,'13','2',112374.30,113958.10,1583.80,1314554.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','168',2352,'14','2',16757.95,17281.82,523.87,434812.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','169',2353,'1','1',271635.75,271635.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','169',2354,'2','1',377814.18,377814.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','169',2355,'3','1',218125.59,222254.14,4128.55,763781.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','169',2356,'4','1',336733.87,340624.00,3890.13,719674.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','169',2357,'5','1',218846.08,218846.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','169',2358,'6','1',369467.00,369467.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','169',2359,'7','1',2123.68,2123.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','169',2360,'8','1',482685.18,487140.66,4455.48,824263.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','169',2361,'9','1',245769.23,245769.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','169',2362,'10','1',321831.91,321831.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','169',2363,'11','1',303933.11,307571.98,3638.87,673190.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','169',2364,'12','1',350910.89,354791.33,3880.44,717881.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','169',2365,'13','2',113958.10,115765.50,1807.40,1500142.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','169',2366,'14','2',17281.82,17281.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','170',2367,'1','1',271635.75,271635.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','170',2368,'2','1',377814.18,377814.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','170',2369,'3','1',222254.14,222254.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','170',2370,'4','1',340624.00,340624.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','170',2371,'5','1',218846.08,218846.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','170',2372,'6','1',369467.00,369467.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','170',2373,'7','1',2123.68,2123.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','170',2374,'8','1',487140.66,487140.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','170',2375,'9','1',245769.23,245769.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','170',2376,'10','1',321831.91,321831.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','170',2377,'11','1',307571.98,307571.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','170',2378,'12','1',354791.33,354791.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','170',2379,'13','2',115765.50,118128.11,2362.61,1960966.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','170',2380,'14','2',17281.82,17743.09,461.27,382854.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','171',2381,'1','1',271635.75,271635.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','171',2382,'2','1',377814.18,377814.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','171',2383,'3','1',222254.14,222254.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','171',2384,'4','1',340624.00,340624.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','171',2385,'5','1',218846.08,218846.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','171',2386,'6','1',369467.00,369467.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','171',2387,'7','1',2123.68,2123.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','171',2388,'8','1',487140.66,487140.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','171',2389,'9','1',245769.23,245769.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','171',2390,'10','1',321831.91,321831.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','171',2391,'11','1',307571.98,307571.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','171',2392,'12','1',354791.33,354791.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','171',2393,'13','2',118128.11,118599.90,471.79,391585.70,0.00,0.00,0.00,0.00,0.00),('1','281','3','171',2394,'14','2',17743.09,17843.09,100.00,83000.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','172',2395,'1','1',271635.75,271635.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','172',2396,'2','1',377814.18,377814.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','172',2397,'3','1',222254.14,222254.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','172',2398,'4','1',340624.00,340624.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','172',2399,'5','1',218846.08,218846.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','172',2400,'6','1',369467.00,369467.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','172',2401,'7','1',2123.68,2123.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','172',2402,'8','1',487140.66,487140.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','172',2403,'9','1',245769.23,245769.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','172',2404,'10','1',321831.91,321831.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','172',2405,'11','1',307571.98,307571.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','172',2406,'12','1',354791.33,354791.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','172',2407,'13','2',118599.90,118861.77,261.87,217352.10,0.00,0.00,0.00,0.00,0.00),('1','281','3','172',2408,'14','2',17843.09,18059.82,216.73,179885.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','173',2409,'1','1',271635.75,271635.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','173',2410,'2','1',377814.18,377814.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','173',2411,'3','1',222254.14,222254.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','173',2412,'4','1',340624.00,340624.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','173',2413,'5','1',218846.08,218846.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','173',2414,'6','1',369467.00,369467.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','173',2415,'7','1',2123.68,2123.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','173',2416,'8','1',487140.66,487140.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','173',2417,'9','1',245769.23,245769.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','173',2418,'10','1',321831.91,321831.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','173',2419,'11','1',307571.98,307571.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','173',2420,'12','1',354791.33,354791.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','173',2421,'13','2',118861.77,119594.94,733.17,608531.10,0.00,0.00,0.00,0.00,0.00),('1','281','3','173',2422,'14','2',18059.82,18089.71,29.89,24808.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','174',2423,'1','1',271635.75,271635.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','174',2424,'2','1',377814.18,377814.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','174',2425,'3','1',222254.14,222254.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','174',2426,'4','1',340624.00,340624.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','174',2427,'5','1',218846.08,218846.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','174',2428,'6','1',369467.00,369467.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','174',2429,'7','1',2123.68,2123.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','174',2430,'8','1',487140.66,487140.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','174',2431,'9','1',245769.23,245769.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','174',2432,'10','1',321831.91,321831.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','174',2433,'11','1',307571.98,307571.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','174',2434,'12','1',354791.33,354791.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','174',2435,'13','2',119594.94,119678.00,83.06,68939.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','174',2436,'14','2',18089.71,18188.88,99.17,82311.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','175',2437,'1','1',271635.75,271635.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','175',2438,'2','1',377814.18,377814.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','175',2439,'3','1',222254.14,222254.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','175',2440,'4','1',340624.00,340624.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','175',2441,'5','1',218846.08,218846.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','175',2442,'6','1',369467.00,369467.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','175',2443,'7','1',2123.68,2123.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','175',2444,'8','1',487140.66,487140.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','175',2445,'9','1',245769.23,245769.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','175',2446,'10','1',321831.91,321831.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','175',2447,'11','1',307571.98,307571.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','175',2448,'12','1',354791.33,354791.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','175',2449,'13','2',119678.00,119942.56,264.56,219584.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','175',2450,'14','2',18188.88,18406.72,217.84,180807.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','176',2451,'1','1',271635.75,271635.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','176',2452,'2','1',377814.18,377814.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','176',2453,'3','1',222254.14,222254.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','176',2454,'4','1',340624.00,340624.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','176',2455,'5','1',218846.08,218846.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','176',2456,'6','1',369467.00,369467.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','176',2457,'7','1',2123.68,2123.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','176',2458,'8','1',487140.66,487140.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','176',2459,'9','1',245769.23,245769.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','176',2460,'10','1',321831.91,321831.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','176',2461,'11','1',307571.98,307571.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','176',2462,'12','1',354791.33,354791.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','176',2463,'13','2',119942.56,122945.22,3002.66,2492207.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','176',2464,'14','2',18406.72,18741.26,334.54,277668.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','177',2465,'1','1',271635.75,271635.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','177',2466,'2','1',377814.18,381198.01,3383.83,626008.55,0.00,0.00,0.00,0.00,0.00),('1','281','1','177',2467,'3','1',222254.14,222254.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','177',2468,'4','1',340624.00,344278.33,3654.33,676051.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','177',2469,'5','1',218846.08,218846.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','177',2470,'6','1',369467.00,369467.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','177',2471,'7','1',2123.68,4080.56,1938.78,358674.30,0.00,0.00,18.10,0.00,0.00),('1','281','2','177',2472,'8','1',487140.66,488221.36,1080.70,199929.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','177',2473,'9','1',245769.23,245769.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','177',2474,'10','1',321831.91,325087.91,3256.00,602360.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','177',2475,'11','1',307571.98,307571.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','177',2476,'12','1',354791.33,357974.60,3183.27,588904.95,0.00,0.00,0.00,0.00,0.00),('1','281','3','177',2477,'13','2',122945.22,124834.13,1888.91,1567795.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','177',2478,'14','2',18741.26,18878.01,136.75,113502.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','178',2479,'1','1',271635.75,271635.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','178',2480,'2','1',381198.01,384647.34,3449.33,638126.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','178',2481,'3','1',222254.14,223442.08,1187.94,219768.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','178',2482,'4','1',344278.33,346675.08,2396.75,443398.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','178',2483,'5','1',218846.08,218846.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','178',2484,'6','1',369467.00,376512.34,7045.34,1303387.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','178',2485,'7','1',4080.56,6321.34,2240.78,414544.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','178',2486,'8','1',488221.36,489630.94,1409.58,260772.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','178',2487,'9','1',245769.23,245769.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','178',2488,'10','1',325087.91,325860.66,772.75,142958.75,0.00,0.00,0.00,0.00,0.00),('1','281','2','178',2489,'11','1',307571.98,309229.08,1657.10,306563.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','178',2490,'12','1',357974.60,360605.04,2630.44,486631.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','178',2491,'13','2',124834.13,125819.48,985.35,817840.50,0.00,0.00,0.00,0.00,0.00),('1','281','3','178',2492,'14','2',18878.01,19569.42,691.41,573870.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','179',2493,'1','1',271635.75,271635.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','179',2494,'2','1',384647.34,387626.32,2978.98,551111.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','179',2495,'3','1',223442.08,223442.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','179',2496,'4','1',346675.08,349514.43,2839.35,525279.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','179',2497,'5','1',218846.08,218846.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','179',2498,'6','1',376512.34,380674.08,4161.74,769921.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','179',2499,'7','1',6321.34,9725.21,3403.87,629715.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','179',2500,'8','1',489630.94,490741.57,1110.63,205466.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','179',2501,'9','1',245769.23,245769.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','179',2502,'10','1',325860.66,328491.67,2631.01,486736.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','179',2503,'11','1',309229.08,310471.36,1242.28,229821.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','179',2504,'12','1',360605.04,364332.74,3727.70,689624.50,0.00,0.00,0.00,0.00,0.00),('1','281','3','179',2505,'13','2',125819.48,126856.51,1037.03,860734.90,0.00,0.00,0.00,0.00,0.00),('1','281','3','179',2506,'14','2',19569.42,19689.91,120.49,100006.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','180',2507,'1','1',271635.75,271635.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','180',2508,'2','1',387626.32,388287.85,661.53,122383.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','180',2509,'3','1',223442.08,223534.68,92.60,17131.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','180',2510,'4','1',349514.43,350647.95,1133.52,209701.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','180',2511,'5','1',218846.08,218846.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','180',2512,'6','1',380674.08,381078.08,404.00,74740.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','180',2513,'7','1',9725.21,9725.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','180',2514,'8','1',490741.57,491957.30,1215.73,224910.05,0.00,0.00,0.00,0.00,0.00),('1','281','2','180',2515,'9','1',245769.23,245769.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','180',2516,'10','1',328491.67,328965.83,474.16,87719.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','180',2517,'11','1',310471.36,310471.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','180',2518,'12','1',364332.74,365602.04,1269.30,234820.50,0.00,0.00,0.00,0.00,0.00),('1','281','3','180',2519,'13','2',126856.51,127103.21,246.70,204761.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','180',2520,'14','2',19689.91,19766.82,76.91,63835.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','181',2521,'1','1',271635.75,271635.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','181',2522,'2','1',388287.85,392549.57,4261.72,788418.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','181',2523,'3','1',223534.68,223534.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','181',2524,'4','1',350647.95,354639.32,3991.37,738403.45,0.00,0.00,0.00,0.00,0.00),('1','281','1','181',2525,'5','1',218846.08,218846.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','181',2526,'6','1',381078.08,385217.48,4139.40,765789.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','181',2527,'7','1',9725.21,13584.41,3859.20,713952.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','181',2528,'8','1',491957.30,491957.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','181',2529,'9','1',245769.23,245769.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','181',2530,'10','1',328965.83,332867.13,3901.30,721740.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','181',2531,'11','1',310471.36,310664.05,192.69,35647.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','181',2532,'12','1',365602.04,369218.62,3616.58,669067.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','181',2533,'13','2',127103.21,127571.97,468.76,389070.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','181',2534,'14','2',19766.82,19917.63,150.81,125172.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','182',2535,'1','1',271635.75,271635.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','182',2536,'2','1',392549.57,394023.67,1474.10,272708.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','182',2537,'3','1',223534.68,223534.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','182',2538,'4','1',354639.32,355241.86,602.54,111469.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','182',2539,'5','1',218846.08,218846.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','182',2540,'6','1',385217.48,386717.46,1499.98,277496.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','182',2541,'7','1',13584.41,13584.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','182',2542,'8','1',491957.30,492495.73,538.43,99609.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','182',2543,'9','1',245769.23,245769.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','182',2544,'10','1',332867.13,334040.38,1173.25,217051.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','182',2545,'11','1',310664.05,310664.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','182',2546,'12','1',369218.62,369615.49,396.87,73420.95,0.00,0.00,0.00,0.00,0.00),('1','281','3','182',2547,'13','2',127571.97,128405.41,833.44,691755.20,0.00,0.00,0.00,0.00,0.00),('1','281','3','182',2548,'14','2',19917.63,20306.04,388.41,322380.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','183',2549,'1','1',271635.75,271635.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','183',2550,'2','1',394023.67,394023.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','183',2551,'3','1',223534.68,226346.82,2812.14,520245.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','183',2552,'4','1',355241.86,357849.19,2607.33,482356.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','183',2553,'5','1',218846.08,218846.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','183',2554,'6','1',386717.46,386717.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','183',2555,'7','1',13584.41,16256.04,2671.63,494251.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','183',2556,'8','1',492495.73,495197.32,2701.59,499794.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','183',2557,'9','1',245769.23,245769.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','183',2558,'10','1',334040.38,334040.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','183',2559,'11','1',310664.05,313350.87,2686.82,497061.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','183',2560,'12','1',369615.49,373123.70,3508.21,649018.85,0.00,0.00,0.00,0.00,0.00),('1','281','3','183',2561,'13','2',128405.41,129125.43,720.02,597616.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','183',2562,'14','2',20306.04,20377.12,71.08,58996.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','184',2563,'1','1',271635.75,271635.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','184',2564,'2','1',394023.67,394023.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','184',2565,'3','1',226346.82,226346.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','184',2566,'4','1',357849.19,357849.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','184',2567,'5','1',218846.08,218846.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','184',2568,'6','1',386717.46,386717.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','184',2569,'7','1',16256.04,16256.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','184',2570,'8','1',495197.32,495197.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','184',2571,'9','1',245769.23,245769.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','184',2572,'10','1',334040.38,334040.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','184',2573,'11','1',313350.87,313350.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','184',2574,'12','1',373123.70,373123.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','184',2575,'13','2',129125.43,130894.18,1768.75,1468062.50,0.00,0.00,0.00,0.00,0.00),('1','281','3','184',2576,'14','2',20377.12,20694.66,317.54,263558.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','185',2577,'1','1',271635.75,271635.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','185',2578,'2','1',394023.67,394023.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','185',2579,'3','1',226346.82,226346.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','185',2580,'4','1',357849.19,357849.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','185',2581,'5','1',218846.08,218846.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','185',2582,'6','1',386717.46,386717.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','185',2583,'7','1',16256.04,16256.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','185',2584,'8','1',495197.32,495197.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','185',2585,'9','1',245769.23,245769.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','185',2586,'10','1',334040.38,334040.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','185',2587,'11','1',313350.87,313350.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','185',2588,'12','1',373123.70,373123.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','185',2589,'13','2',130894.18,130989.85,95.67,79406.10,0.00,0.00,0.00,0.00,0.00),('1','281','3','185',2590,'14','2',20694.66,20807.07,112.41,93300.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','186',2591,'1','1',271635.75,271635.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','186',2592,'2','1',394023.67,394023.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','186',2593,'3','1',226346.82,226346.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','186',2594,'4','1',357849.19,357849.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','186',2595,'5','1',218846.08,218846.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','186',2596,'6','1',386717.46,386717.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','186',2597,'7','1',16256.04,16256.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','186',2598,'8','1',495197.32,495197.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','186',2599,'9','1',245769.23,245769.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','186',2600,'10','1',334040.38,334040.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','186',2601,'11','1',313350.87,313350.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','186',2602,'12','1',373123.70,373123.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','186',2603,'13','2',130989.85,131518.64,528.79,438895.70,0.00,0.00,0.00,0.00,0.00),('1','281','3','186',2604,'14','2',20807.07,20884.41,77.34,64192.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','187',2605,'1','1',271635.75,271635.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','187',2606,'2','1',394023.67,394023.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','187',2607,'3','1',226346.82,226346.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','187',2608,'4','1',357849.19,357849.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','187',2609,'5','1',218846.08,218846.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','187',2610,'6','1',386717.46,386717.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','187',2611,'7','1',16256.04,16256.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','187',2612,'8','1',495197.32,495197.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','187',2613,'9','1',245769.23,245769.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','187',2614,'10','1',334040.38,334040.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','187',2615,'11','1',313350.87,313350.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','187',2616,'12','1',373123.70,373123.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','187',2617,'13','2',131518.64,131846.95,328.31,272497.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','187',2618,'14','2',20884.41,21043.92,159.51,132393.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','188',2619,'1','1',271635.75,271635.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','188',2620,'2','1',394023.67,394023.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','188',2621,'3','1',226346.82,226346.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','188',2622,'4','1',357849.19,357849.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','188',2623,'5','1',218846.08,218846.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','188',2624,'6','1',386717.46,386717.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','188',2625,'7','1',16256.04,16256.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','188',2626,'8','1',495197.32,495197.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','188',2627,'9','1',245769.23,245769.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','188',2628,'10','1',334040.38,334040.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','188',2629,'11','1',313350.87,313350.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','188',2630,'12','1',373123.70,373123.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','188',2631,'13','2',131846.95,132682.84,835.89,718865.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','188',2632,'14','2',21043.92,21820.32,776.40,667704.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','189',2633,'1','1',271635.75,271635.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','189',2634,'2','1',394023.67,394023.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','189',2635,'3','1',226346.82,226346.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','189',2636,'4','1',357849.19,357849.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','189',2637,'5','1',218846.08,218846.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','189',2638,'6','1',386717.46,386717.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','189',2639,'7','1',16256.04,16256.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','189',2640,'8','1',495197.32,495197.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','189',2641,'9','1',245769.23,245769.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','189',2642,'10','1',334040.38,334040.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','189',2643,'11','1',313350.87,313350.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','189',2644,'12','1',373123.70,373123.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','189',2645,'13','2',132682.84,132721.15,38.31,32946.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','189',2646,'14','2',21820.32,21820.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','190',2647,'1','1',271635.75,275998.03,4362.28,807021.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','190',2648,'2','1',394023.67,397665.82,3642.15,673797.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','190',2649,'3','1',226346.82,226346.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','190',2650,'4','1',357849.19,357849.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','190',2651,'5','1',218846.08,223029.78,4183.70,773984.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','190',2652,'6','1',386717.46,390869.84,4152.38,768190.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','190',2653,'7','1',16256.04,16256.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','190',2654,'8','1',495197.32,495197.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','190',2655,'9','1',245769.23,250713.75,4944.52,914736.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','190',2656,'10','1',334040.38,338017.03,3976.65,735680.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','190',2657,'11','1',313350.87,313350.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','190',2658,'12','1',373123.70,373123.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','190',2659,'13','2',132721.15,132721.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','190',2660,'14','2',21820.32,21820.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','191',2661,'1','1',275998.03,277386.49,1388.46,256865.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','191',2662,'2','1',397665.82,398927.24,1261.42,233362.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','191',2663,'3','1',226346.82,226346.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','191',2664,'4','1',357849.19,357849.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','191',2665,'5','1',223029.78,224370.35,1340.57,248005.45,0.00,0.00,0.00,0.00,0.00),('1','281','1','191',2666,'6','1',390869.84,392088.14,1218.30,225385.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','191',2667,'7','1',16256.04,16256.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','191',2668,'8','1',495197.32,495197.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','191',2669,'9','1',250713.75,252044.51,1330.76,246190.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','191',2670,'10','1',338017.03,339257.16,1240.13,229424.05,0.00,0.00,0.00,0.00,0.00),('1','281','2','191',2671,'11','1',313350.87,313350.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','191',2672,'12','1',373123.70,373123.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','191',2673,'13','2',132721.15,132721.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','191',2674,'14','2',21820.32,21820.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','192',2675,'1','1',277386.49,277672.98,286.49,53000.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','192',2676,'2','1',398927.24,404881.95,5954.71,1101621.35,0.00,0.00,0.00,0.00,0.00),('1','281','1','192',2677,'3','1',226346.82,226346.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','192',2678,'4','1',357849.19,363106.03,5256.84,972515.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','192',2679,'5','1',224370.35,224370.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','192',2680,'6','1',392088.14,398543.52,6455.38,1194245.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','192',2681,'7','1',16256.04,16256.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','192',2682,'8','1',495197.32,500564.62,5367.30,992950.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','192',2683,'9','1',252044.51,252044.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','192',2684,'10','1',339257.16,344717.38,5460.22,1010140.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','192',2685,'11','1',313350.87,314212.24,861.37,159353.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','192',2686,'12','1',373123.70,377973.71,4850.01,897251.85,0.00,0.00,0.00,0.00,0.00),('1','281','3','192',2687,'13','2',132721.15,132721.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','192',2688,'14','2',21820.32,21820.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','193',2689,'1','1',277672.98,277672.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','193',2690,'2','1',404881.95,409792.67,4910.72,908483.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','193',2691,'3','1',226346.82,226346.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','193',2692,'4','1',363106.03,366980.37,3874.34,716752.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','193',2693,'5','1',224370.35,224370.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','193',2694,'6','1',398543.52,403334.50,4790.98,886331.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','193',2695,'7','1',16256.04,16256.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','193',2696,'8','1',500564.62,504704.44,4139.82,765866.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','193',2697,'9','1',252044.51,252044.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','193',2698,'10','1',344717.38,348884.66,4167.28,770946.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','193',2699,'11','1',314212.24,314212.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','193',2700,'12','1',377973.71,382503.10,4529.39,837937.15,0.00,0.00,0.00,0.00,0.00),('1','281','3','193',2701,'13','2',132721.15,132721.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','193',2702,'14','2',21820.32,21820.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','194',2703,'1','1',277672.98,279636.66,1963.68,363280.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','194',2704,'2','1',409792.67,410398.29,605.62,112039.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','194',2705,'3','1',226346.82,226346.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','194',2706,'4','1',366980.37,366980.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','194',2707,'5','1',224370.35,226396.92,2026.57,374915.45,0.00,0.00,0.00,0.00,0.00),('1','281','1','194',2708,'6','1',403334.50,404028.64,694.14,128415.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','194',2709,'7','1',16256.04,16256.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','194',2710,'8','1',504704.44,504704.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','194',2711,'9','1',252044.51,253908.88,1864.37,344908.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','194',2712,'10','1',348884.66,349839.77,955.11,176695.35,0.00,0.00,0.00,0.00,0.00),('1','281','2','194',2713,'11','1',314212.24,314212.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','194',2714,'12','1',382503.10,382503.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','194',2715,'13','2',132721.15,133101.77,380.62,327333.20,0.00,0.00,0.00,0.00,0.00),('1','281','3','194',2716,'14','2',21820.32,22484.76,664.44,571418.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','195',2717,'1','1',279636.66,279636.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','195',2718,'2','1',410398.29,414795.15,4396.86,813419.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','195',2719,'3','1',226346.82,226346.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','195',2720,'4','1',366980.37,371553.91,4573.54,846104.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','195',2721,'5','1',226396.92,226396.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','195',2722,'6','1',404028.64,408872.73,4844.09,896156.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','195',2723,'7','1',16256.04,16256.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','195',2724,'8','1',504704.44,509296.97,4592.53,849618.05,0.00,0.00,0.00,0.00,0.00),('1','281','2','195',2725,'9','1',253908.88,253908.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','195',2726,'10','1',349839.77,349839.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','195',2727,'11','1',314212.24,314212.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','195',2728,'12','1',382503.10,386732.74,4209.05,778674.25,0.00,0.00,20.59,0.00,0.00),('1','281','3','195',2729,'13','2',133101.77,135098.39,1996.62,1717093.20,0.00,0.00,0.00,0.00,0.00),('1','281','3','195',2730,'14','2',22484.76,22634.43,149.67,128716.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','196',2731,'1','1',279636.66,279636.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','196',2732,'2','1',414795.15,414795.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','196',2733,'3','1',226346.82,227238.12,891.30,164890.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','196',2734,'4','1',371553.91,373109.60,1555.69,287802.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','196',2735,'5','1',226396.92,226396.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','196',2736,'6','1',408872.73,408872.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','196',2737,'7','1',16256.04,17068.10,812.06,150231.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','196',2738,'8','1',509296.97,510741.79,1444.82,267291.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','196',2739,'9','1',253908.88,253908.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','196',2740,'10','1',349839.77,349839.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','196',2741,'11','1',314212.24,315388.00,1175.76,217515.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','196',2742,'12','1',386732.74,388158.36,1425.62,263739.70,0.00,0.00,0.00,0.00,0.00),('1','281','3','196',2743,'13','2',135098.39,136292.32,1193.93,1026779.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','196',2744,'14','2',22634.43,22909.39,274.96,236465.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','197',2745,'1','1',279636.66,280098.67,462.01,85471.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','197',2746,'2','1',414795.15,420352.20,5557.05,1028054.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','197',2747,'3','1',227238.12,227238.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','197',2748,'4','1',373109.60,373109.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','197',2749,'5','1',226396.92,233529.77,7132.85,1319577.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','197',2750,'6','1',408872.73,413256.10,4383.37,810923.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','197',2751,'7','1',17068.10,17068.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','197',2752,'8','1',510741.79,515200.25,4458.46,824815.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','197',2753,'9','1',253908.88,254420.13,511.25,94581.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','197',2754,'10','1',349839.77,350380.85,541.08,100099.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','197',2755,'11','1',315388.00,315388.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','197',2756,'12','1',388158.36,392561.17,4402.81,814519.85,0.00,0.00,0.00,0.00,0.00),('1','281','3','197',2757,'13','2',136292.32,136510.85,218.53,187935.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','197',2758,'14','2',22909.39,22977.44,68.05,58523.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','198',2759,'1','1',280098.67,280098.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','198',2760,'2','1',420352.20,420352.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','198',2761,'3','1',227238.12,227238.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','198',2762,'4','1',373109.60,373109.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','198',2763,'5','1',233529.77,233529.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','198',2764,'6','1',413256.10,413256.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','198',2765,'7','1',17068.10,17068.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','198',2766,'8','1',515200.25,515200.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','198',2767,'9','1',254420.13,254420.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','198',2768,'10','1',350380.85,350380.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','198',2769,'11','1',315388.00,315388.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','198',2770,'12','1',392561.17,392561.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','198',2771,'13','2',136510.85,136855.02,344.17,295986.20,0.00,0.00,0.00,0.00,0.00),('1','281','3','198',2772,'14','2',22977.44,23412.98,435.54,374564.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','199',2773,'1','1',280098.67,284383.91,4285.24,792769.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','199',2774,'2','1',420352.20,424428.12,4075.92,754045.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','199',2775,'3','1',227238.12,227238.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','199',2776,'4','1',373109.60,373109.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','199',2777,'5','1',233529.77,237813.78,4284.01,792541.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','199',2778,'6','1',413256.10,417967.77,4711.67,871658.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','199',2779,'7','1',17068.10,17068.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','199',2780,'8','1',515200.25,515200.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','199',2781,'9','1',254420.13,258919.71,4499.58,832422.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','199',2782,'10','1',350380.85,354784.38,4403.53,814653.05,0.00,0.00,0.00,0.00,0.00),('1','281','2','199',2783,'11','1',315388.00,315388.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','199',2784,'12','1',392561.17,392561.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','199',2785,'13','2',136855.02,138228.10,1373.08,1180848.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','199',2786,'14','2',23412.98,24708.35,1295.37,1114018.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','200',2787,'1','1',284383.91,284383.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','200',2788,'2','1',424428.12,424428.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','200',2789,'3','1',227238.12,227238.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','200',2790,'4','1',373109.60,373109.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','200',2791,'5','1',237813.78,237813.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','200',2792,'6','1',417967.77,417967.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','200',2793,'7','1',17068.10,17068.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','200',2794,'8','1',515200.25,515200.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','200',2795,'9','1',258919.71,258919.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','200',2796,'10','1',354784.38,354784.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','200',2797,'11','1',315388.00,315388.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','200',2798,'12','1',392561.17,392561.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','200',2799,'13','2',138228.10,139465.48,1237.38,1064146.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','200',2800,'14','2',24708.35,24973.06,264.71,227650.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','201',2801,'1','1',284383.91,284383.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','201',2802,'2','1',424428.12,428658.18,4230.06,782561.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','201',2803,'3','1',227238.12,227238.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','201',2804,'4','1',373109.60,377038.71,3929.11,726885.35,0.00,0.00,0.00,0.00,0.00),('1','281','1','201',2805,'5','1',237813.78,237813.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','201',2806,'6','1',417967.77,422759.03,4791.26,886383.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','201',2807,'7','1',17068.10,17068.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','201',2808,'8','1',515200.25,519445.27,4245.02,785328.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','201',2809,'9','1',258919.71,258919.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','201',2810,'10','1',354784.38,358753.55,3969.17,734296.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','201',2811,'11','1',315388.00,315577.60,189.60,35076.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','201',2812,'12','1',392561.17,396987.77,4426.60,818921.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','201',2813,'13','2',139465.48,141611.30,2145.82,1845405.20,0.00,0.00,0.00,0.00,0.00),('1','281','3','201',2814,'14','2',24973.06,25448.99,475.93,409299.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','202',2815,'1','1',284383.91,284383.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','202',2816,'2','1',428658.18,429461.11,802.93,148542.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','202',2817,'3','1',227238.12,227238.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','202',2818,'4','1',377038.71,379675.53,2636.82,487811.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','202',2819,'5','1',237813.78,237813.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','202',2820,'6','1',422759.03,423654.44,895.41,165650.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','202',2821,'7','1',17068.10,17068.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','202',2822,'8','1',519445.27,522249.42,2804.15,518767.75,0.00,0.00,0.00,0.00,0.00),('1','281','2','202',2823,'9','1',258919.71,258919.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','202',2824,'10','1',358753.55,359434.47,680.92,125970.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','202',2825,'11','1',315577.60,315577.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','202',2826,'12','1',396987.77,399635.19,2647.42,489772.70,0.00,0.00,0.00,0.00,0.00),('1','281','3','202',2827,'13','2',141611.30,142653.79,1042.49,896541.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','202',2828,'14','2',25448.99,25809.52,360.53,310055.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','203',2829,'1','1',284383.91,289769.21,5385.30,996280.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','203',2830,'2','1',429461.11,434364.13,4903.02,907058.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','203',2831,'3','1',227238.12,227238.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','203',2832,'4','1',379675.53,379675.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','203',2833,'5','1',237813.78,242745.52,4931.74,912371.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','203',2834,'6','1',423654.44,428584.11,4929.67,911988.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','203',2835,'7','1',17068.10,17068.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','203',2836,'8','1',522249.42,522249.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','203',2837,'9','1',258919.71,264383.39,5463.68,1010780.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','203',2838,'10','1',359434.47,363834.61,4400.14,814025.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','203',2839,'11','1',315577.60,315577.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','203',2840,'12','1',399635.19,399635.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','203',2841,'13','2',142653.79,145153.17,2499.38,2199454.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','203',2842,'14','2',25809.52,26268.13,458.61,403576.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','204',2843,'1','1',289769.21,289769.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','204',2844,'2','1',434364.13,434364.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','204',2845,'3','1',227238.12,227238.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','204',2846,'4','1',379675.53,379675.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','204',2847,'5','1',242745.52,242745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','204',2848,'6','1',428584.11,428584.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','204',2849,'7','1',17068.10,17068.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','204',2850,'8','1',522249.42,522249.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','204',2851,'9','1',264383.39,264383.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','204',2852,'10','1',363834.61,363834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','204',2853,'11','1',315577.60,315577.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','204',2854,'12','1',399635.19,399635.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','204',2855,'13','2',145153.17,145527.41,374.24,329331.20,0.00,0.00,0.00,0.00,0.00),('1','281','3','204',2856,'14','2',26268.13,26359.98,91.85,80828.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','205',2857,'1','1',289769.21,289769.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','205',2858,'2','1',434364.13,434364.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','205',2859,'3','1',227238.12,227238.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','205',2860,'4','1',379675.53,379675.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','205',2861,'5','1',242745.52,242745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','205',2862,'6','1',428584.11,428584.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','205',2863,'7','1',17068.10,17068.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','205',2864,'8','1',522249.42,522249.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','205',2865,'9','1',264383.39,264383.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','205',2866,'10','1',363834.61,363834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','205',2867,'11','1',315577.60,315577.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','205',2868,'12','1',399635.19,399635.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','205',2869,'13','2',145527.41,148223.93,2696.52,2372937.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','205',2870,'14','2',26359.98,26505.55,145.57,128101.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','206',2871,'1','1',289769.21,289769.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','206',2872,'2','1',434364.13,434364.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','206',2873,'3','1',227238.12,227238.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','206',2874,'4','1',379675.53,379675.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','206',2875,'5','1',242745.52,242745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','206',2876,'6','1',428584.11,428584.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','206',2877,'7','1',17068.10,17068.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','206',2878,'8','1',522249.42,522249.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','206',2879,'9','1',264383.39,264383.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','206',2880,'10','1',363834.61,363834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','206',2881,'11','1',315577.60,315577.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','206',2882,'12','1',399635.19,399635.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','206',2883,'13','2',148223.93,148360.68,136.75,120340.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','206',2884,'14','2',26505.55,26628.28,122.73,108002.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','207',2885,'1','1',289769.21,289769.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','207',2886,'2','1',434364.13,434364.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','207',2887,'3','1',227238.12,227238.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','207',2888,'4','1',379675.53,379675.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','207',2889,'5','1',242745.52,242745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','207',2890,'6','1',428584.11,428584.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','207',2891,'7','1',17068.10,17068.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','207',2892,'8','1',522249.42,522249.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','207',2893,'9','1',264383.39,264383.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','207',2894,'10','1',363834.61,363834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','207',2895,'11','1',315577.60,315577.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','207',2896,'12','1',399635.19,399635.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','207',2897,'13','2',148360.68,148468.65,107.97,95013.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','207',2898,'14','2',26628.28,26773.16,144.88,127494.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','208',2899,'1','1',289769.21,289769.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','208',2900,'2','1',434364.13,434364.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','208',2901,'3','1',227238.12,227238.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','208',2902,'4','1',379675.53,379675.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','208',2903,'5','1',242745.52,242745.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','208',2904,'6','1',428584.11,428584.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','208',2905,'7','1',17068.10,17068.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','208',2906,'8','1',522249.42,522249.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','208',2907,'9','1',264383.39,264383.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','208',2908,'10','1',363834.61,363834.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','208',2909,'11','1',315577.60,315577.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','208',2910,'12','1',399635.19,399635.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','208',2911,'13','2',148468.65,150443.41,1974.76,1737788.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','208',2912,'14','2',26773.16,27037.70,264.54,232795.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','209',2913,'1','1',289769.21,289931.81,162.60,30081.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','209',2914,'2','1',434364.13,442289.25,7925.12,1466147.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','209',2915,'3','1',227238.12,227238.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','209',2916,'4','1',379675.53,379675.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','209',2917,'5','1',242745.52,247121.77,4376.25,809606.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','209',2918,'6','1',428584.11,437082.47,8498.36,1572196.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','209',2919,'7','1',17068.10,17068.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','209',2920,'8','1',522249.42,522249.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','209',2921,'9','1',264383.39,270628.14,6244.75,1155278.75,0.00,0.00,0.00,0.00,0.00),('1','281','2','209',2922,'10','1',363834.61,370380.50,6545.89,1210989.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','209',2923,'11','1',315577.60,315577.65,0.05,9.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','209',2924,'12','1',399635.19,399635.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','209',2925,'13','2',150443.41,151778.97,1335.56,1175292.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','209',2926,'14','2',27037.70,27340.41,302.71,266384.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','210',2927,'1','1',289931.81,289931.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','210',2928,'2','1',442289.25,444356.47,2067.22,382435.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','210',2929,'3','1',227238.12,229911.65,2673.53,494603.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','210',2930,'4','1',379675.53,384312.60,4637.07,857857.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','210',2931,'5','1',247121.77,247121.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','210',2932,'6','1',437082.47,439245.09,2162.62,400084.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','210',2933,'7','1',17068.10,19992.68,2924.58,541047.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','210',2934,'8','1',522249.42,527086.44,4837.02,894848.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','210',2935,'9','1',270628.14,270628.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','210',2936,'10','1',370380.50,372335.13,1954.63,361606.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','210',2937,'11','1',315577.65,318219.46,2641.81,488734.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','210',2938,'12','1',399635.19,404443.67,4808.48,889568.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','210',2939,'13','2',151778.97,154035.90,2256.93,1986098.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','210',2940,'14','2',27340.41,27624.66,284.25,250140.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','211',2941,'1','1',289931.81,289931.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','211',2942,'2','1',444356.47,444356.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','211',2943,'3','1',229911.65,229911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','211',2944,'4','1',384312.60,384312.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','211',2945,'5','1',247121.77,247121.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','211',2946,'6','1',439245.09,439245.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','211',2947,'7','1',19992.68,19992.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','211',2948,'8','1',527086.44,527086.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','211',2949,'9','1',270628.14,270628.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','211',2950,'10','1',372335.13,372335.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','211',2951,'11','1',318219.46,318219.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','211',2952,'12','1',404443.67,404443.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','211',2953,'13','2',154035.90,154446.57,410.67,361389.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','211',2954,'14','2',27624.66,28079.53,454.87,400285.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','212',2955,'1','1',289931.81,290593.33,661.52,122381.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','212',2956,'2','1',444356.47,448364.61,4008.14,741505.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','212',2957,'3','1',229911.65,229911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','212',2958,'4','1',384312.60,386645.16,2332.56,431523.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','212',2959,'5','1',247121.77,248462.15,1340.38,247970.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','212',2960,'6','1',439245.09,443610.06,4364.97,807519.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','212',2961,'7','1',19992.68,19992.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','212',2962,'8','1',527086.44,529394.66,2308.22,427020.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','212',2963,'9','1',270628.14,271172.08,543.94,100628.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','212',2964,'10','1',372335.13,376376.09,4040.96,747577.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','212',2965,'11','1',318219.46,318219.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','212',2966,'12','1',404443.67,406968.84,2525.17,467156.45,0.00,0.00,0.00,0.00,0.00),('1','281','3','212',2967,'13','2',154446.57,155423.93,977.36,860076.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','212',2968,'14','2',28079.53,29507.38,1427.85,1256508.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','213',2969,'1','1',290593.33,290593.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','213',2970,'2','1',448364.61,448364.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','213',2971,'3','1',229911.65,229911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','213',2972,'4','1',386645.16,386645.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','213',2973,'5','1',248462.15,248462.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','213',2974,'6','1',443610.06,443610.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','213',2975,'7','1',19992.68,19992.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','213',2976,'8','1',529394.66,529394.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','213',2977,'9','1',271172.08,271172.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','213',2978,'10','1',376376.09,376376.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','213',2979,'11','1',318219.46,318219.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','213',2980,'12','1',406968.84,406968.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','213',2981,'13','2',155423.93,158903.96,3480.03,3062426.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','213',2982,'14','2',29507.38,30796.57,1289.19,1134487.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','214',2983,'1','1',290593.33,294920.25,4326.92,800480.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','214',2984,'2','1',448364.61,452439.19,4074.58,753797.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','214',2985,'3','1',229911.65,229911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','214',2986,'4','1',386645.16,386645.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','214',2987,'5','1',248462.15,256941.84,8479.69,1568742.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','214',2988,'6','1',443610.06,447989.55,4379.49,810205.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','214',2989,'7','1',19992.68,19992.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','214',2990,'8','1',529394.66,529394.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','214',2991,'9','1',271172.08,275515.35,4343.27,803504.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','214',2992,'10','1',376376.09,380738.30,4362.21,807008.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','214',2993,'11','1',318219.46,318219.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','214',2994,'12','1',406968.84,406968.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','214',2995,'13','2',158903.96,159357.62,453.66,399220.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','214',2996,'14','2',30796.57,31313.42,516.85,454828.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','215',2997,'1','1',294920.25,294920.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','215',2998,'2','1',452439.19,452439.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','215',2999,'3','1',229911.65,229911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','215',3000,'4','1',386645.16,386645.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','215',3001,'5','1',256941.84,256941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','215',3002,'6','1',447989.55,447989.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','215',3003,'7','1',19992.68,19992.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','215',3004,'8','1',529394.66,529394.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','215',3005,'9','1',275515.35,275515.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','215',3006,'10','1',380738.30,380738.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','215',3007,'11','1',318219.46,318219.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','215',3008,'12','1',406968.84,406968.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','215',3009,'13','2',159357.62,161659.73,2302.11,2025856.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','215',3010,'14','2',31313.42,32739.21,1425.79,1254695.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','216',3011,'1','1',294920.25,297977.92,3057.67,565668.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','216',3012,'2','1',452439.19,455624.73,3185.54,589324.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','216',3013,'3','1',229911.65,229911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','216',3014,'4','1',386645.16,386645.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','216',3015,'5','1',256941.84,260061.66,3119.82,577166.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','216',3016,'6','1',447989.55,451079.78,3090.23,571692.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','216',3017,'7','1',19992.68,19992.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','216',3018,'8','1',529394.66,529394.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','216',3019,'9','1',275515.35,278349.12,2833.77,524247.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','216',3020,'10','1',380738.30,383758.62,3020.32,558759.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','216',3021,'11','1',318219.46,318219.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','216',3022,'12','1',406968.84,406968.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','216',3023,'13','2',161659.73,162162.01,502.28,436983.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','216',3024,'14','2',32739.21,32852.33,113.12,98414.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','217',3025,'1','1',297977.92,300740.57,2762.65,511090.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','217',3026,'2','1',455624.73,458452.69,2827.96,523172.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','217',3027,'3','1',229911.65,229911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','217',3028,'4','1',386645.16,386645.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','217',3029,'5','1',260061.66,262534.90,2473.24,457549.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','217',3030,'6','1',451079.78,453579.80,2500.02,462503.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','217',3031,'7','1',19992.68,19992.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','217',3032,'8','1',529394.66,529394.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','217',3033,'9','1',278349.12,280840.02,2490.90,460816.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','217',3034,'10','1',383758.62,386313.02,2554.40,472564.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','217',3035,'11','1',318219.46,318219.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','217',3036,'12','1',406968.84,406968.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','217',3037,'13','2',162162.01,162794.89,632.88,550605.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','217',3038,'14','2',32852.33,32967.30,114.97,100023.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','218',3039,'1','1',300740.57,300740.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','218',3040,'2','1',458452.69,458452.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','218',3041,'3','1',229911.65,234590.14,4678.49,865520.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','218',3042,'4','1',386645.16,391531.50,4886.34,903972.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','218',3043,'5','1',262534.90,262534.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','218',3044,'6','1',453579.80,453579.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','218',3045,'7','1',19992.68,24806.23,4813.55,890506.75,0.00,0.00,0.00,0.00,0.00),('1','281','2','218',3046,'8','1',529394.66,533828.07,4433.41,820180.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','218',3047,'9','1',280840.02,280840.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','218',3048,'10','1',386313.02,386313.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','218',3049,'11','1',318219.46,323583.53,5364.07,992352.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','218',3050,'12','1',406968.84,411545.84,4577.00,846745.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','218',3051,'13','2',162794.89,164012.23,1217.34,1059085.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','218',3052,'14','2',32967.30,33080.06,112.76,98101.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','219',3053,'1','1',300740.57,300740.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','219',3054,'2','1',458452.69,458452.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','219',3055,'3','1',234590.14,234590.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','219',3056,'4','1',391531.50,391531.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','219',3057,'5','1',262534.90,262534.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','219',3058,'6','1',453579.80,453579.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','219',3059,'7','1',24806.23,24806.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','219',3060,'8','1',533828.07,533828.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','219',3061,'9','1',280840.02,280840.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','219',3062,'10','1',386313.02,386313.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','219',3063,'11','1',323583.53,323583.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','219',3064,'12','1',411545.84,411545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','219',3065,'13','2',164012.23,164185.74,173.51,150953.70,0.00,0.00,0.00,0.00,0.00),('1','281','3','219',3066,'14','2',33080.06,33186.40,106.34,92515.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','220',3067,'1','1',300740.57,300740.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','220',3068,'2','1',458452.69,458452.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','220',3069,'3','1',234590.14,234590.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','220',3070,'4','1',391531.50,391531.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','220',3071,'5','1',262534.90,262534.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','220',3072,'6','1',453579.80,453579.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','220',3073,'7','1',24806.23,24806.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','220',3074,'8','1',533828.07,533828.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','220',3075,'9','1',280840.02,280840.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','220',3076,'10','1',386313.02,386313.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','220',3077,'11','1',323583.53,323583.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','220',3078,'12','1',411545.84,411545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','220',3079,'13','2',164185.74,164428.39,242.65,211105.50,0.00,0.00,0.00,0.00,0.00),('1','281','3','220',3080,'14','2',33186.40,33413.63,227.23,197690.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','221',3081,'1','1',300740.57,300740.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','221',3082,'2','1',458452.69,458452.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','221',3083,'3','1',234590.14,234590.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','221',3084,'4','1',391531.50,391531.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','221',3085,'5','1',262534.90,262534.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','221',3086,'6','1',453579.80,453579.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','221',3087,'7','1',24806.23,24806.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','221',3088,'8','1',533828.07,533828.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','221',3089,'9','1',280840.02,280840.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','221',3090,'10','1',386313.02,386313.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','221',3091,'11','1',323583.53,323583.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','221',3092,'12','1',411545.84,411545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','221',3093,'13','2',164428.39,164864.49,436.10,379407.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','221',3094,'14','2',33413.63,33544.40,130.77,113769.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','222',3095,'1','1',300740.57,300740.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','222',3096,'2','1',458452.69,458452.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','222',3097,'3','1',234590.14,234590.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','222',3098,'4','1',391531.50,391531.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','222',3099,'5','1',262534.90,262534.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','222',3100,'6','1',453579.80,453579.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','222',3101,'7','1',24806.23,24806.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','222',3102,'8','1',533828.07,533828.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','222',3103,'9','1',280840.02,280840.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','222',3104,'10','1',386313.02,386313.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','222',3105,'11','1',323583.53,323583.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','222',3106,'12','1',411545.84,411545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','222',3107,'13','2',164864.49,165225.64,361.15,314200.50,0.00,0.00,0.00,0.00,0.00),('1','281','3','222',3108,'14','2',33544.40,33714.67,170.27,148134.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','223',3109,'1','1',300740.57,300740.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','223',3110,'2','1',458452.69,458452.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','223',3111,'3','1',234590.14,234590.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','223',3112,'4','1',391531.50,391531.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','223',3113,'5','1',262534.90,262534.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','223',3114,'6','1',453579.80,453579.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','223',3115,'7','1',24806.23,24806.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','223',3116,'8','1',533828.07,533828.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','223',3117,'9','1',280840.02,280840.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','223',3118,'10','1',386313.02,386313.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','223',3119,'11','1',323583.53,323583.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','223',3120,'12','1',411545.84,411545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','223',3121,'13','2',165225.64,165477.47,251.83,221610.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','223',3122,'14','2',33714.67,33864.56,149.89,131903.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','224',3123,'1','1',300740.57,305325.35,4584.78,848184.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','224',3124,'2','1',458452.69,463332.18,4879.49,902705.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','224',3125,'3','1',234590.14,234590.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','224',3126,'4','1',391531.50,391531.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','224',3127,'5','1',262534.90,267449.24,4914.34,909152.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','224',3128,'6','1',453579.80,458741.79,5161.99,954968.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','224',3129,'7','1',24806.23,24806.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','224',3130,'8','1',533828.07,533828.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','224',3131,'9','1',280840.02,286017.11,5177.09,957761.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','224',3132,'10','1',386313.02,391174.81,4861.79,899431.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','224',3133,'11','1',323583.53,323583.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','224',3134,'12','1',411545.84,411545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','224',3135,'13','2',165477.47,166550.62,1073.15,944372.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','224',3136,'14','2',33864.56,34095.16,230.60,202928.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','225',3137,'1','1',305325.35,305663.83,338.48,62618.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','225',3138,'2','1',463332.18,463332.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','225',3139,'3','1',234590.14,234590.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','225',3140,'4','1',391531.50,391531.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','225',3141,'5','1',267449.24,267449.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','225',3142,'6','1',458741.79,458741.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','225',3143,'7','1',24806.23,24806.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','225',3144,'8','1',533828.07,533828.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','225',3145,'9','1',286017.11,286017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','225',3146,'10','1',391174.81,391174.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','225',3147,'11','1',323583.53,323583.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','225',3148,'12','1',411545.84,411545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','225',3149,'13','2',166550.62,166954.83,404.21,355704.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','225',3150,'14','2',34095.16,34206.09,110.93,97618.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','226',3151,'1','1',305663.83,305867.05,203.22,37595.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','226',3152,'2','1',463332.18,463332.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','226',3153,'3','1',234590.14,234590.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','226',3154,'4','1',391531.50,391531.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','226',3155,'5','1',267449.24,267449.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','226',3156,'6','1',458741.79,458741.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','226',3157,'7','1',24806.23,24806.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','226',3158,'8','1',533828.07,533828.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','226',3159,'9','1',286017.11,286017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','226',3160,'10','1',391174.81,391174.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','226',3161,'11','1',323583.53,323583.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','226',3162,'12','1',411545.84,411545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','226',3163,'13','2',166954.83,167197.58,242.75,213620.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','226',3164,'14','2',34206.09,34320.09,114.00,100320.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','227',3165,'1','1',305867.05,310145.21,4278.16,791459.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','227',3166,'2','1',463332.18,467664.62,4332.44,801501.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','227',3167,'3','1',234590.14,234590.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','227',3168,'4','1',391531.50,391531.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','227',3169,'5','1',267449.24,276777.09,9327.85,1725652.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','227',3170,'6','1',458741.79,462919.06,4177.27,772794.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','227',3171,'7','1',24806.23,24806.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','227',3172,'8','1',533828.07,533828.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','227',3173,'9','1',286017.11,290135.06,4117.95,761820.75,0.00,0.00,0.00,0.00,0.00),('1','281','2','227',3174,'10','1',391174.81,394869.44,3694.63,683506.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','227',3175,'11','1',323583.53,323583.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','227',3176,'12','1',411545.84,411545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','227',3177,'13','2',167197.58,168860.14,1662.56,1463052.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','227',3178,'14','2',34320.09,34481.84,161.75,142340.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','228',3179,'1','1',310145.21,310145.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','228',3180,'2','1',467664.62,467664.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','228',3181,'3','1',234590.14,234590.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','228',3182,'4','1',391531.50,391531.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','228',3183,'5','1',276777.09,276777.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','228',3184,'6','1',462919.06,462919.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','228',3185,'7','1',24806.23,24806.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','228',3186,'8','1',533828.07,533828.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','228',3187,'9','1',290135.06,290135.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','228',3188,'10','1',394869.44,394869.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','228',3189,'11','1',323583.53,323583.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','228',3190,'12','1',411545.84,411545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','228',3191,'13','2',168860.14,169109.25,249.11,219216.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','228',3192,'14','2',34481.84,34648.99,167.15,147092.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','229',3193,'1','1',310145.21,310145.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','229',3194,'2','1',467664.62,467664.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','229',3195,'3','1',234590.14,237157.87,2567.73,475030.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','229',3196,'4','1',391531.50,394340.48,2808.98,519661.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','229',3197,'5','1',276777.09,276777.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','229',3198,'6','1',462919.06,462919.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','229',3199,'7','1',24806.23,27837.85,3031.62,560849.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','229',3200,'8','1',533828.07,536260.23,2432.16,449949.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','229',3201,'9','1',290135.06,290135.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','229',3202,'10','1',394869.44,394869.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','229',3203,'11','1',323583.53,326240.36,2656.83,491513.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','229',3204,'12','1',411545.84,416006.24,4460.40,825174.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','229',3205,'13','2',169109.25,169475.18,365.93,322018.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','229',3206,'14','2',34648.99,34821.83,172.84,152099.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','230',3207,'1','1',310145.21,310145.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','230',3208,'2','1',467664.62,467664.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','230',3209,'3','1',237157.87,237157.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','230',3210,'4','1',394340.48,394340.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','230',3211,'5','1',276777.09,276777.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','230',3212,'6','1',462919.06,462919.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','230',3213,'7','1',27837.85,27837.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','230',3214,'8','1',536260.23,536260.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','230',3215,'9','1',290135.06,290135.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','230',3216,'10','1',394869.44,394869.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','230',3217,'11','1',326240.36,326240.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','230',3218,'12','1',416006.24,416006.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','230',3219,'13','2',169475.18,172188.96,2713.78,2388126.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','230',3220,'14','2',34821.83,34890.22,68.39,60183.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','231',3221,'1','1',310145.21,310145.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','231',3222,'2','1',467664.62,467664.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','231',3223,'3','1',237157.87,237157.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','231',3224,'4','1',394340.48,394340.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','231',3225,'5','1',276777.09,276777.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','231',3226,'6','1',462919.06,462919.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','231',3227,'7','1',27837.85,27837.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','231',3228,'8','1',536260.23,536260.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','231',3229,'9','1',290135.06,290135.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','231',3230,'10','1',394869.44,394869.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','231',3231,'11','1',326240.36,326240.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','231',3232,'12','1',416006.24,416006.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','231',3233,'13','2',172188.96,172188.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','231',3234,'14','2',34890.22,34890.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','232',3235,'1','1',310145.21,310145.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','232',3236,'2','1',467664.62,467664.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','232',3237,'3','1',237157.87,240953.74,3795.87,702235.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','232',3238,'4','1',394340.48,398228.56,3888.08,719294.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','232',3239,'5','1',276777.09,276777.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','232',3240,'6','1',462919.06,462919.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','232',3241,'7','1',27837.85,30184.83,2346.98,434191.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','232',3242,'8','1',536260.23,538162.06,1901.83,351838.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','232',3243,'9','1',290135.06,290135.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','232',3244,'10','1',394869.44,394869.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','232',3245,'11','1',326240.36,329921.45,3681.09,681001.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','232',3246,'12','1',416006.24,420141.31,4135.07,764987.95,0.00,0.00,0.00,0.00,0.00),('1','281','3','232',3247,'13','2',172188.96,172204.20,15.24,13716.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','232',3248,'14','2',34890.22,34903.56,13.34,12006.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','233',3249,'1','1',310145.21,310145.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','233',3250,'2','1',467664.62,467664.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','233',3251,'3','1',240953.74,240953.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','233',3252,'4','1',398228.56,398228.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','233',3253,'5','1',276777.09,276777.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','233',3254,'6','1',462919.06,462919.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','233',3255,'7','1',30184.83,30184.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','233',3256,'8','1',538162.06,538162.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','233',3257,'9','1',290135.06,290135.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','233',3258,'10','1',394869.44,394869.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','233',3259,'11','1',329921.45,329921.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','233',3260,'12','1',420141.31,420141.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','233',3261,'13','2',172204.20,172518.47,314.27,282843.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','233',3262,'14','2',34903.56,34909.23,5.67,5103.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','234',3263,'1','1',310145.21,310145.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','234',3264,'2','1',467664.62,467664.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','234',3265,'3','1',240953.74,240953.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','234',3266,'4','1',398228.56,398228.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','234',3267,'5','1',276777.09,276777.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','234',3268,'6','1',462919.06,462919.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','234',3269,'7','1',30184.83,30184.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','234',3270,'8','1',538162.06,538162.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','234',3271,'9','1',290135.06,290135.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','234',3272,'10','1',394869.44,394869.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','234',3273,'11','1',329921.45,329921.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','234',3274,'12','1',420141.31,420141.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','234',3275,'13','2',172518.47,172695.14,176.67,159003.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','234',3276,'14','2',34909.23,35069.47,160.24,144216.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','235',3277,'1','1',310145.21,310145.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','235',3278,'2','1',467664.62,467664.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','235',3279,'3','1',240953.74,240953.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','235',3280,'4','1',398228.56,398228.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','235',3281,'5','1',276777.09,276777.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','235',3282,'6','1',462919.06,462919.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','235',3283,'7','1',30184.83,30184.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','235',3284,'8','1',538162.06,538162.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','235',3285,'9','1',290135.06,290135.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','235',3286,'10','1',394869.44,394869.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','235',3287,'11','1',329921.45,329921.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','235',3288,'12','1',420141.31,420141.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','235',3289,'13','2',172695.14,173424.56,729.42,656478.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','235',3290,'14','2',35069.47,35069.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','236',3291,'1','1',310145.21,315302.29,5157.08,954059.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','236',3292,'2','1',467664.62,472953.25,5288.63,978396.55,0.00,0.00,0.00,0.00,0.00),('1','281','1','236',3293,'3','1',240953.74,240953.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','236',3294,'4','1',398228.56,398228.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','236',3295,'5','1',276777.09,282781.06,6003.97,1110734.45,0.00,0.00,0.00,0.00,0.00),('1','281','1','236',3296,'6','1',462919.06,468143.70,5224.64,966558.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','236',3297,'7','1',30184.83,30184.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','236',3298,'8','1',538162.06,538162.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','236',3299,'9','1',290135.06,295825.05,5689.99,1052648.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','236',3300,'10','1',394869.44,400499.00,5629.56,1041468.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','236',3301,'11','1',329921.45,329921.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','236',3302,'12','1',420141.31,420141.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','236',3303,'13','2',173424.56,173969.87,545.31,490779.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','236',3304,'14','2',35069.47,35129.47,60.00,54000.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','237',3305,'1','1',315302.29,315302.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','237',3306,'2','1',472953.25,473735.01,781.76,144625.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','237',3307,'3','1',240953.74,240953.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','237',3308,'4','1',398228.56,398228.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','237',3309,'5','1',282781.06,282781.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','237',3310,'6','1',468143.70,468143.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','237',3311,'7','1',30184.83,30184.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','237',3312,'8','1',538162.06,538162.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','237',3313,'9','1',295825.05,295825.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','237',3314,'10','1',400499.00,400499.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','237',3315,'11','1',329921.45,329921.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','237',3316,'12','1',420141.31,420141.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','237',3317,'13','2',173969.87,174969.87,1000.00,900000.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','237',3318,'14','2',35129.47,35308.95,179.48,161532.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','238',3319,'1','1',315302.29,317969.96,2667.67,493518.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','238',3320,'2','1',473735.01,476181.48,2446.47,452596.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','238',3321,'3','1',240953.74,240953.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','238',3322,'4','1',398228.56,398228.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','238',3323,'5','1',282781.06,285342.29,2561.23,473827.55,0.00,0.00,0.00,0.00,0.00),('1','281','1','238',3324,'6','1',468143.70,470925.00,2781.30,514540.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','238',3325,'7','1',30184.83,30184.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','238',3326,'8','1',538162.06,538162.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','238',3327,'9','1',295825.05,298295.45,2470.40,457024.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','238',3328,'10','1',400499.00,403134.51,2635.51,487569.35,0.00,0.00,0.00,0.00,0.00),('1','281','2','238',3329,'11','1',329921.45,329921.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','238',3330,'12','1',420141.31,420141.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','238',3331,'13','2',174969.87,175446.33,476.46,424049.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','238',3332,'14','2',35308.95,35308.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','239',3333,'1','1',317969.96,317969.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','239',3334,'2','1',476181.48,476181.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','239',3335,'3','1',240953.74,240953.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','239',3336,'4','1',398228.56,398228.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','239',3337,'5','1',285342.29,285342.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','239',3338,'6','1',470925.00,470925.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','239',3339,'7','1',30184.83,30184.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','239',3340,'8','1',538162.06,538162.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','239',3341,'9','1',298295.45,298295.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','239',3342,'10','1',403134.51,403134.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','239',3343,'11','1',329921.45,329921.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','239',3344,'12','1',420141.31,420141.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','239',3345,'13','2',175446.33,176606.75,1160.42,1032773.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','239',3346,'14','2',35308.95,35308.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','240',3347,'1','1',317969.96,317969.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','240',3348,'2','1',476181.48,476181.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','240',3349,'3','1',240953.74,240953.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','240',3350,'4','1',398228.56,398228.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','240',3351,'5','1',285342.29,285342.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','240',3352,'6','1',470925.00,470925.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','240',3353,'7','1',30184.83,30184.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','240',3354,'8','1',538162.06,538162.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','240',3355,'9','1',298295.45,298295.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','240',3356,'10','1',403134.51,403134.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','240',3357,'11','1',329921.45,329921.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','240',3358,'12','1',420141.31,420141.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','240',3359,'13','2',176606.75,179178.74,2571.99,2289071.10,0.00,0.00,0.00,0.00,0.00),('1','281','3','240',3360,'14','2',35308.95,36320.19,1011.24,900003.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','241',3361,'1','1',317969.96,317969.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','241',3362,'2','1',476181.48,476181.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','241',3363,'3','1',240953.74,243549.44,2595.70,480204.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','241',3364,'4','1',398228.56,401047.01,2818.45,521413.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','241',3365,'5','1',285342.29,285342.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','241',3366,'6','1',470925.00,470925.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','241',3367,'7','1',30184.83,32919.49,2734.66,505912.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','241',3368,'8','1',538162.06,541049.99,2887.93,534267.05,0.00,0.00,0.00,0.00,0.00),('1','281','2','241',3369,'9','1',298295.45,298295.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','241',3370,'10','1',403134.51,403134.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','241',3371,'11','1',329921.45,332542.10,2620.65,484820.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','241',3372,'12','1',420141.31,425775.67,5634.36,1042356.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','241',3373,'13','2',179178.74,179452.98,274.24,244073.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','241',3374,'14','2',36320.19,36439.25,119.06,105963.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','242',3375,'1','1',317969.96,317969.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','242',3376,'2','1',476181.48,476181.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','242',3377,'3','1',243549.44,243549.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','242',3378,'4','1',401047.01,401047.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','242',3379,'5','1',285342.29,285342.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','242',3380,'6','1',470925.00,470925.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','242',3381,'7','1',32919.49,32919.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','242',3382,'8','1',541049.99,541049.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','242',3383,'9','1',298295.45,298295.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','242',3384,'10','1',403134.51,403134.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','242',3385,'11','1',332542.10,332542.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','242',3386,'12','1',425775.67,425775.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','242',3387,'13','2',179452.98,180083.02,630.04,560735.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','242',3388,'14','2',36439.25,36439.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','243',3389,'1','1',317969.96,317969.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','243',3390,'2','1',476181.48,476181.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','243',3391,'3','1',243549.44,243549.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','243',3392,'4','1',401047.01,401708.20,661.19,122320.15,0.00,0.00,0.00,0.00,0.00),('1','281','1','243',3393,'5','1',285342.29,285342.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','243',3394,'6','1',470925.00,470925.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','243',3395,'7','1',32919.49,32919.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','243',3396,'8','1',541049.99,541049.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','243',3397,'9','1',298295.45,298295.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','243',3398,'10','1',403134.51,403134.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','243',3399,'11','1',332542.10,332542.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','243',3400,'12','1',425775.67,425775.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','243',3401,'13','2',180083.02,182895.63,2812.61,2503222.90,0.00,0.00,0.00,0.00,0.00),('1','281','3','243',3402,'14','2',36439.25,36939.13,499.88,444893.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','244',3403,'1','1',317969.96,321194.08,3224.12,596462.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','244',3404,'2','1',476181.48,479640.99,3459.51,640009.35,0.00,0.00,0.00,0.00,0.00),('1','281','1','244',3405,'3','1',243549.44,243549.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','244',3406,'4','1',401708.20,401708.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','244',3407,'5','1',285342.29,288690.66,3348.37,619448.45,0.00,0.00,0.00,0.00,0.00),('1','281','1','244',3408,'6','1',470925.00,474501.04,3576.04,661567.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','244',3409,'7','1',32919.49,32919.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','244',3410,'8','1',541049.99,541049.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','244',3411,'9','1',298295.45,301131.95,2836.50,524752.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','244',3412,'10','1',403134.51,406680.57,3546.06,656021.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','244',3413,'11','1',332542.10,332542.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','244',3414,'12','1',425775.67,425775.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','244',3415,'13','2',182895.63,183029.88,134.25,119482.50,0.00,0.00,0.00,0.00,0.00),('1','281','3','244',3416,'14','2',36939.13,36939.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','245',3417,'1','1',321194.08,321194.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','245',3418,'2','1',479640.99,479640.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','245',3419,'3','1',243549.44,243549.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','245',3420,'4','1',401708.20,401708.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','245',3421,'5','1',288690.66,288690.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','245',3422,'6','1',474501.04,474501.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','245',3423,'7','1',32919.49,32919.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','245',3424,'8','1',541049.99,541049.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','245',3425,'9','1',301131.95,301131.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','245',3426,'10','1',406680.57,406680.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','245',3427,'11','1',332542.10,332542.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','245',3428,'12','1',425775.67,425775.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','245',3429,'13','2',183029.88,183132.00,102.12,90886.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','245',3430,'14','2',36939.13,36939.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','246',3431,'1','1',321194.08,321194.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','246',3432,'2','1',479640.99,479640.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','246',3433,'3','1',243549.44,243549.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','246',3434,'4','1',401708.20,401708.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','246',3435,'5','1',288690.66,288690.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','246',3436,'6','1',474501.04,474501.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','246',3437,'7','1',32919.49,32919.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','246',3438,'8','1',541049.99,541049.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','246',3439,'9','1',301131.95,301131.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','246',3440,'10','1',406680.57,406680.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','246',3441,'11','1',332542.10,332542.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','246',3442,'12','1',425775.67,425775.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','246',3443,'13','2',183132.00,183659.27,527.27,469270.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','246',3444,'14','2',36939.13,36939.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','247',3445,'1','1',321194.08,321194.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','247',3446,'2','1',479640.99,479640.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','247',3447,'3','1',243549.44,243549.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','247',3448,'4','1',401708.20,401708.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','247',3449,'5','1',288690.66,288690.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','247',3450,'6','1',474501.04,474501.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','247',3451,'7','1',32919.49,32919.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','247',3452,'8','1',541049.99,541049.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','247',3453,'9','1',301131.95,301131.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','247',3454,'10','1',406680.57,406680.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','247',3455,'11','1',332542.10,332542.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','247',3456,'12','1',425775.67,425775.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','247',3457,'13','2',183659.27,184290.36,631.09,561670.10,0.00,0.00,0.00,0.00,0.00),('1','281','3','247',3458,'14','2',36939.13,36988.45,49.32,43894.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','248',3459,'1','1',321194.08,321194.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','248',3460,'2','1',479640.99,479640.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','248',3461,'3','1',243549.44,243549.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','248',3462,'4','1',401708.20,401708.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','248',3463,'5','1',288690.66,288690.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','248',3464,'6','1',474501.04,474501.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','248',3465,'7','1',32919.49,32919.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','248',3466,'8','1',541049.99,541049.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','248',3467,'9','1',301131.95,301131.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','248',3468,'10','1',406680.57,406680.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','248',3469,'11','1',332542.10,332542.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','248',3470,'12','1',425775.67,425775.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','248',3471,'13','2',184290.36,184520.29,229.93,204637.70,0.00,0.00,0.00,0.00,0.00),('1','281','3','248',3472,'14','2',36988.45,37210.27,221.82,197419.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','249',3473,'1','1',321194.08,325465.16,4271.08,790149.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','249',3474,'2','1',479640.99,484091.35,4450.36,823316.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','249',3475,'3','1',243549.44,243971.12,421.68,78010.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','249',3476,'4','1',401708.20,402260.34,552.14,102145.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','249',3477,'5','1',288690.66,298878.89,10188.23,1884822.55,0.00,0.00,0.00,0.00,0.00),('1','281','1','249',3478,'6','1',474501.04,479251.56,4750.52,878846.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','249',3479,'7','1',32919.49,33478.89,559.40,103489.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','249',3480,'8','1',541049.99,541388.01,338.02,62533.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','249',3481,'9','1',301131.95,306143.83,5011.88,927197.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','249',3482,'10','1',406680.57,410821.22,4140.65,766020.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','249',3483,'11','1',332542.10,333129.19,587.09,108611.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','249',3484,'12','1',425775.67,426576.96,801.29,148238.65,0.00,0.00,0.00,0.00,0.00),('1','281','3','249',3485,'13','2',184520.29,184868.36,348.07,309782.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','249',3486,'14','2',37210.27,37302.06,91.79,81693.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','250',3487,'1','1',325465.16,325465.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','250',3488,'2','1',484091.35,484091.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','250',3489,'3','1',243971.12,246157.70,2186.58,404517.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','250',3490,'4','1',402260.34,404539.78,2279.44,421696.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','250',3491,'5','1',298878.89,298878.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','250',3492,'6','1',479251.56,479251.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','250',3493,'7','1',33478.89,35764.08,2285.19,422760.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','250',3494,'8','1',541388.01,543724.30,2336.29,432213.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','250',3495,'9','1',306143.83,306143.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','250',3496,'10','1',410821.22,410821.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','250',3497,'11','1',333129.19,335447.25,2318.06,428841.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','250',3498,'12','1',426576.96,428782.13,2205.17,407956.45,0.00,0.00,0.00,0.00,0.00),('1','281','3','250',3499,'13','2',184868.36,185219.22,350.86,308756.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','250',3500,'14','2',37302.06,37303.54,1.48,1302.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','251',3501,'1','1',325465.16,329290.30,3825.14,707650.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','251',3502,'2','1',484091.35,487695.97,3604.62,666854.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','251',3503,'3','1',246157.70,246157.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','251',3504,'4','1',404539.78,404539.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','251',3505,'5','1',298878.89,302771.82,3892.93,720192.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','251',3506,'6','1',479251.56,482879.32,3627.76,671135.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','251',3507,'7','1',35764.08,35764.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','251',3508,'8','1',543724.30,543724.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','251',3509,'9','1',306143.83,309787.77,3643.94,674128.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','251',3510,'10','1',410821.22,414737.98,3916.76,724600.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','251',3511,'11','1',335447.25,335447.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','251',3512,'12','1',428782.13,428782.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','251',3513,'13','2',185219.22,187887.17,2667.95,2347796.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','251',3514,'14','2',37303.54,37532.03,228.49,201071.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','252',3515,'1','1',329290.30,329290.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','252',3516,'2','1',487695.97,487695.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','252',3517,'3','1',246157.70,246157.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','252',3518,'4','1',404539.78,404539.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','252',3519,'5','1',302771.82,302771.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','252',3520,'6','1',482879.32,482879.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','252',3521,'7','1',35764.08,35764.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','252',3522,'8','1',543724.30,543724.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','252',3523,'9','1',309787.77,309787.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','252',3524,'10','1',414737.98,414737.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','252',3525,'11','1',335447.25,335447.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','252',3526,'12','1',428782.13,428782.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','252',3527,'13','2',187887.17,188773.39,886.22,779873.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','252',3528,'14','2',37532.03,37727.72,195.69,172207.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','253',3529,'1','1',329290.30,329290.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','253',3530,'2','1',487695.97,487695.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','253',3531,'3','1',246157.70,246157.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','253',3532,'4','1',404539.78,404539.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','253',3533,'5','1',302771.82,303593.89,822.07,152082.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','253',3534,'6','1',482879.32,482879.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','253',3535,'7','1',35764.08,35764.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','253',3536,'8','1',543724.30,543724.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','253',3537,'9','1',309787.77,309787.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','253',3538,'10','1',414737.98,414737.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','253',3539,'11','1',335447.25,335447.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','253',3540,'12','1',428782.13,428782.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','253',3541,'13','2',188773.39,191064.19,2290.80,2015904.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','253',3542,'14','2',37727.72,39307.13,1579.41,1389880.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','254',3543,'1','1',329290.30,329290.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','254',3544,'2','1',487695.97,487695.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','254',3545,'3','1',246157.70,249243.40,3085.70,570854.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','254',3546,'4','1',404539.78,408259.62,3719.84,688170.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','254',3547,'5','1',303593.89,304267.91,674.02,124693.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','254',3548,'6','1',482879.32,482879.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','254',3549,'7','1',35764.08,39256.01,3491.93,646007.05,0.00,0.00,0.00,0.00,0.00),('1','281','2','254',3550,'8','1',543724.30,547083.97,3359.67,621538.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','254',3551,'9','1',309787.77,309787.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','254',3552,'10','1',414737.98,414737.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','254',3553,'11','1',335447.25,339050.60,3603.35,666619.75,0.00,0.00,0.00,0.00,0.00),('1','281','2','254',3554,'12','1',428782.13,434445.31,5663.18,1047688.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','254',3555,'13','2',191064.19,192184.91,1120.72,986233.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','254',3556,'14','2',39307.13,39427.73,120.60,106128.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','255',3557,'1','1',329290.30,329290.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','255',3558,'2','1',487695.97,487695.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','255',3559,'3','1',249243.40,249243.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','255',3560,'4','1',408259.62,408259.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','255',3561,'5','1',304267.91,304267.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','255',3562,'6','1',482879.32,482879.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','255',3563,'7','1',39256.01,39256.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','255',3564,'8','1',547083.97,547083.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','255',3565,'9','1',309787.77,309787.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','255',3566,'10','1',414737.98,414737.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','255',3567,'11','1',339050.60,339050.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','255',3568,'12','1',434445.31,434445.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','255',3569,'13','2',192184.91,192314.05,129.14,113643.20,0.00,0.00,0.00,0.00,0.00),('1','281','3','255',3570,'14','2',39427.73,39507.16,79.43,69898.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','256',3571,'1','1',329290.30,331998.47,2708.17,501011.45,0.00,0.00,0.00,0.00,0.00),('1','281','1','256',3572,'2','1',487695.97,490505.23,2809.26,519713.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','256',3573,'3','1',249243.40,249243.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','256',3574,'4','1',408259.62,408259.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','256',3575,'5','1',304267.91,307046.45,2778.54,514029.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','256',3576,'6','1',482879.32,485728.95,2849.63,527181.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','256',3577,'7','1',39256.01,39256.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','256',3578,'8','1',547083.97,547083.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','256',3579,'9','1',309787.77,312644.12,2856.35,528424.75,0.00,0.00,0.00,0.00,0.00),('1','281','2','256',3580,'10','1',414737.98,417621.52,2883.54,533454.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','256',3581,'11','1',339050.60,339050.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','256',3582,'12','1',434445.31,434445.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','256',3583,'13','2',192314.05,192619.30,305.25,268620.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','256',3584,'14','2',39507.16,39553.12,45.96,40444.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','257',3585,'1','1',331998.47,331998.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','257',3586,'2','1',490505.23,490505.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','257',3587,'3','1',249243.40,249243.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','257',3588,'4','1',408259.62,408259.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','257',3589,'5','1',307046.45,307046.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','257',3590,'6','1',485728.95,485728.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','257',3591,'7','1',39256.01,39256.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','257',3592,'8','1',547083.97,547083.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','257',3593,'9','1',312644.12,312644.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','257',3594,'10','1',417621.52,417621.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','257',3595,'11','1',339050.60,339050.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','257',3596,'12','1',434445.31,434445.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','257',3597,'13','2',192619.30,192689.75,70.45,61996.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','257',3598,'14','2',39553.12,39587.00,33.88,29814.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','258',3599,'1','1',331998.47,331998.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','258',3600,'2','1',490505.23,490505.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','258',3601,'3','1',249243.40,251901.70,2658.30,491785.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','258',3602,'4','1',408259.62,411139.52,2879.90,532781.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','258',3603,'5','1',307046.45,307046.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','258',3604,'6','1',485728.95,485728.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','258',3605,'7','1',39256.01,41726.10,2470.09,456966.65,0.00,0.00,0.00,0.00,0.00),('1','281','2','258',3606,'8','1',547083.97,549656.35,2572.38,475890.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','258',3607,'9','1',312644.12,312644.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','258',3608,'10','1',417621.52,417621.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','258',3609,'11','1',339050.60,341533.59,2482.99,459353.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','258',3610,'12','1',434445.31,437050.18,2604.87,481900.95,0.00,0.00,0.00,0.00,0.00),('1','281','3','258',3611,'13','2',192689.75,193421.65,731.90,644072.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','258',3612,'14','2',39587.00,41750.59,2163.59,1903959.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','259',3613,'1','1',331998.47,331998.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','259',3614,'2','1',490505.23,490505.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','259',3615,'3','1',251901.70,252387.35,485.65,89845.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','259',3616,'4','1',411139.52,411720.92,581.40,107559.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','259',3617,'5','1',307046.45,307046.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','259',3618,'6','1',485728.95,485728.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','259',3619,'7','1',41726.10,41726.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','259',3620,'8','1',549656.35,549656.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','259',3621,'9','1',312644.12,312644.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','259',3622,'10','1',417621.52,417621.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','259',3623,'11','1',341533.59,341533.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','259',3624,'12','1',437050.18,437050.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','259',3625,'13','2',193421.65,193786.87,365.22,321393.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','259',3626,'14','2',41750.59,41880.84,130.25,114620.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','260',3627,'1','1',331998.47,334661.35,2662.88,492632.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','260',3628,'2','1',490505.23,493352.34,2847.11,526715.35,0.00,0.00,0.00,0.00,0.00),('1','281','1','260',3629,'3','1',252387.35,252387.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','260',3630,'4','1',411720.92,411720.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','260',3631,'5','1',307046.45,310009.02,2962.57,548075.45,0.00,0.00,0.00,0.00,0.00),('1','281','1','260',3632,'6','1',485728.95,488350.87,2621.92,485055.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','260',3633,'7','1',41726.10,41726.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','260',3634,'8','1',549656.35,549656.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','260',3635,'9','1',312644.12,315356.51,2712.39,501792.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','260',3636,'10','1',417621.52,420277.38,2655.86,491334.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','260',3637,'11','1',341533.59,341533.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','260',3638,'12','1',437050.18,437050.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','260',3639,'13','2',193786.87,199162.98,5376.11,4730976.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','260',3640,'14','2',41880.84,48333.34,6452.50,5678200.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','261',3641,'1','1',334661.35,339224.20,4562.85,844127.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','261',3642,'2','1',493352.34,497451.28,4098.94,758303.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','261',3643,'3','1',252387.35,252387.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','261',3644,'4','1',411720.92,411720.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','261',3645,'5','1',310009.02,313534.73,3525.71,652256.35,0.00,0.00,0.00,0.00,0.00),('1','281','1','261',3646,'6','1',488350.87,492278.44,3927.57,726600.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','261',3647,'7','1',41726.10,41726.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','261',3648,'8','1',549656.35,549656.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','261',3649,'9','1',315356.51,319576.24,4219.73,780650.05,0.00,0.00,0.00,0.00,0.00),('1','281','2','261',3650,'10','1',420277.38,424869.74,4592.36,849586.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','261',3651,'11','1',341533.59,341533.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','261',3652,'12','1',437050.18,437050.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','261',3653,'13','2',199162.98,199406.51,243.53,214306.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','261',3654,'14','2',48333.34,48465.11,131.77,115957.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','262',3655,'1','1',339224.20,339224.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','262',3656,'2','1',497451.28,497451.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','262',3657,'3','1',252387.35,252387.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','262',3658,'4','1',411720.92,411720.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','262',3659,'5','1',313534.73,313534.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','262',3660,'6','1',492278.44,492278.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','262',3661,'7','1',41726.10,41726.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','262',3662,'8','1',549656.35,549656.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','262',3663,'9','1',319576.24,319576.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','262',3664,'10','1',424869.74,424869.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','262',3665,'11','1',341533.59,341533.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','262',3666,'12','1',437050.18,437050.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','262',3667,'13','2',199406.51,199678.90,272.39,239703.20,0.00,0.00,0.00,0.00,0.00),('1','281','3','262',3668,'14','2',48465.11,48635.10,169.99,149591.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','263',3669,'1','1',339224.20,339514.25,290.05,53659.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','263',3670,'2','1',497451.28,501028.26,3576.98,661741.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','263',3671,'3','1',252387.35,252387.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','263',3672,'4','1',411720.92,412187.28,466.36,86276.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','263',3673,'5','1',313534.73,318154.45,4619.72,854648.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','263',3674,'6','1',492278.44,495045.48,2767.04,511902.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','263',3675,'7','1',41726.10,41726.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','263',3676,'8','1',549656.35,549656.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','263',3677,'9','1',319576.24,319905.99,329.75,61003.75,0.00,0.00,0.00,0.00,0.00),('1','281','2','263',3678,'10','1',424869.74,428170.65,3300.91,610668.35,0.00,0.00,0.00,0.00,0.00),('1','281','2','263',3679,'11','1',341533.59,341533.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','263',3680,'12','1',437050.18,437050.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','263',3681,'13','2',199678.90,199953.01,274.11,241216.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','263',3682,'14','2',48635.10,48951.70,316.60,278608.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','264',3683,'1','1',339514.25,339514.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','264',3684,'2','1',501028.26,501028.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','264',3685,'3','1',252387.35,252823.67,436.32,80719.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','264',3686,'4','1',412187.28,412187.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','264',3687,'5','1',318154.45,318154.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','264',3688,'6','1',495045.48,495045.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','264',3689,'7','1',41726.10,41726.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','264',3690,'8','1',549656.35,549656.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','264',3691,'9','1',319905.99,319905.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','264',3692,'10','1',428170.65,428170.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','264',3693,'11','1',341533.59,341533.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','264',3694,'12','1',437050.18,437050.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','264',3695,'13','2',199953.01,200401.54,448.53,394706.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','264',3696,'14','2',48951.70,49345.23,393.53,346306.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','265',3697,'1','1',339514.25,344116.32,4602.07,851382.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','265',3698,'2','1',501028.26,505666.70,4638.44,858111.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','265',3699,'3','1',252823.67,252823.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','265',3700,'4','1',412187.28,412187.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','265',3701,'5','1',318154.45,324237.42,6082.97,1125349.45,0.00,0.00,0.00,0.00,0.00),('1','281','1','265',3702,'6','1',495045.48,499585.88,4540.40,839974.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','265',3703,'7','1',41726.10,41726.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','265',3704,'8','1',549656.35,549656.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','265',3705,'9','1',319905.99,324926.46,5020.47,928786.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','265',3706,'10','1',428170.65,432783.81,4613.16,853434.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','265',3707,'11','1',341533.59,341533.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','265',3708,'12','1',437050.18,437050.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','265',3709,'13','2',200401.54,201946.71,1545.17,1359749.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','265',3710,'14','2',49345.23,49422.82,77.59,68279.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','266',3711,'1','1',344116.32,344116.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','266',3712,'2','1',505666.70,505666.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','266',3713,'3','1',252823.67,252823.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','266',3714,'4','1',412187.28,412187.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','266',3715,'5','1',324237.42,324237.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','266',3716,'6','1',499585.88,499585.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','266',3717,'7','1',41726.10,41726.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','266',3718,'8','1',549656.35,549656.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','266',3719,'9','1',324926.46,324926.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','266',3720,'10','1',432783.81,432783.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','266',3721,'11','1',341533.59,341533.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','266',3722,'12','1',437050.18,437050.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','266',3723,'13','2',201946.71,205350.47,3403.76,2995308.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','266',3724,'14','2',49422.82,49715.19,292.37,257285.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','267',3725,'1','1',344116.32,349528.03,5401.71,999316.35,0.00,0.00,10.00,0.00,0.00),('1','281','1','267',3726,'2','1',505666.70,511433.22,5766.52,1066806.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','267',3727,'3','1',252823.67,252823.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','267',3728,'4','1',412187.28,412187.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','267',3729,'5','1',324237.42,331986.10,7748.68,1433505.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','267',3730,'6','1',499585.88,505209.10,5613.12,1038427.20,0.00,0.00,10.10,0.00,0.00),('1','281','2','267',3731,'7','1',41726.10,41726.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','267',3732,'8','1',549656.35,549656.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','267',3733,'9','1',324926.46,330573.85,5647.39,1044767.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','267',3734,'10','1',432783.81,438026.64,5242.83,969923.55,0.00,0.00,0.00,0.00,0.00),('1','281','2','267',3735,'11','1',341533.59,341533.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','267',3736,'12','1',437050.18,437050.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','267',3737,'13','2',205350.47,206139.47,789.00,694320.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','267',3738,'14','2',49715.19,50082.12,366.93,322898.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','268',3739,'1','1',349528.03,349528.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','268',3740,'2','1',511433.22,511433.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','268',3741,'3','1',252823.67,252823.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','268',3742,'4','1',412187.28,412187.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','268',3743,'5','1',331986.10,331986.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','268',3744,'6','1',505209.10,505209.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','268',3745,'7','1',41726.10,41726.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','268',3746,'8','1',549656.35,549656.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','268',3747,'9','1',330573.85,330573.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','268',3748,'10','1',438026.64,438026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','268',3749,'11','1',341533.59,341533.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','268',3750,'12','1',437050.18,437050.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','268',3751,'13','2',206139.47,206637.49,498.02,438257.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','268',3752,'14','2',50082.12,50107.80,25.68,22598.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','269',3753,'1','1',349528.03,349528.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','269',3754,'2','1',511433.22,511433.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','269',3755,'3','1',252823.67,255368.87,2545.20,470862.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','269',3756,'4','1',412187.28,414621.09,2433.81,450254.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','269',3757,'5','1',331986.10,331986.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','269',3758,'6','1',505209.10,505209.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','269',3759,'7','1',41726.10,43843.51,2117.41,391720.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','269',3760,'8','1',549656.35,551832.79,2176.44,402641.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','269',3761,'9','1',330573.85,330573.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','269',3762,'10','1',438026.64,438026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','269',3763,'11','1',341533.59,344030.38,2496.79,461906.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','269',3764,'12','1',437050.18,439231.26,2181.08,403499.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','269',3765,'13','2',206637.49,207844.31,1206.82,1062001.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','269',3766,'14','2',50107.80,50107.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','270',3767,'1','1',349528.03,349528.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','270',3768,'2','1',511433.22,511433.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','270',3769,'3','1',255368.87,255368.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','270',3770,'4','1',414621.09,414621.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','270',3771,'5','1',331986.10,331986.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','270',3772,'6','1',505209.10,505209.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','270',3773,'7','1',43843.51,43843.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','270',3774,'8','1',551832.79,551832.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','270',3775,'9','1',330573.85,330573.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','270',3776,'10','1',438026.64,438026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','270',3777,'11','1',344030.38,344030.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','270',3778,'12','1',439231.26,439231.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','270',3779,'13','2',207844.31,207878.40,34.09,29999.20,0.00,0.00,0.00,0.00,0.00),('1','281','3','270',3780,'14','2',50107.80,50256.67,148.87,131005.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','271',3781,'1','1',349528.03,349528.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','271',3782,'2','1',511433.22,511433.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','271',3783,'3','1',255368.87,255368.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','271',3784,'4','1',414621.09,414621.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','271',3785,'5','1',331986.10,331986.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','271',3786,'6','1',505209.10,505209.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','271',3787,'7','1',43843.51,43843.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','271',3788,'8','1',551832.79,551832.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','271',3789,'9','1',330573.85,330573.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','271',3790,'10','1',438026.64,438026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','271',3791,'11','1',344030.38,344030.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','271',3792,'12','1',439231.26,439231.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','271',3793,'13','2',207878.40,208530.43,652.03,573786.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','271',3794,'14','2',50256.67,50256.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','272',3795,'1','1',349528.03,349528.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','272',3796,'2','1',511433.22,511433.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','272',3797,'3','1',255368.87,255368.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','272',3798,'4','1',414621.09,414621.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','272',3799,'5','1',331986.10,331986.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','272',3800,'6','1',505209.10,505209.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','272',3801,'7','1',43843.51,43843.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','272',3802,'8','1',551832.79,551832.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','272',3803,'9','1',330573.85,330573.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','272',3804,'10','1',438026.64,438026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','272',3805,'11','1',344030.38,344030.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','272',3806,'12','1',439231.26,439231.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','272',3807,'13','2',208530.43,208813.80,283.37,249365.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','272',3808,'14','2',50256.67,50256.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','273',3809,'1','1',349528.03,353191.88,3663.85,677812.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','273',3810,'2','1',511433.22,515608.51,4175.29,772428.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','273',3811,'3','1',255368.87,255368.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','273',3812,'4','1',414621.09,414621.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','273',3813,'5','1',331986.10,338308.03,6321.93,1169557.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','273',3814,'6','1',505209.10,508860.85,3651.75,675573.75,0.00,0.00,0.00,0.00,0.00),('1','281','2','273',3815,'7','1',43843.51,43843.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','273',3816,'8','1',551832.79,551832.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','273',3817,'9','1',330573.85,334479.01,3905.16,722454.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','273',3818,'10','1',438026.64,441700.56,3673.92,679675.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','273',3819,'11','1',344030.38,344030.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','273',3820,'12','1',439231.26,439231.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','273',3821,'13','2',208813.80,208955.15,141.35,124388.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','273',3822,'14','2',50256.67,50256.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','274',3823,'1','1',353191.88,353191.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','274',3824,'2','1',515608.51,515608.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','274',3825,'3','1',255368.87,255368.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','274',3826,'4','1',414621.09,414621.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','274',3827,'5','1',338308.03,338308.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','274',3828,'6','1',508860.85,508860.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','274',3829,'7','1',43843.51,43843.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','274',3830,'8','1',551832.79,551832.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','274',3831,'9','1',334479.01,334479.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','274',3832,'10','1',441700.56,441700.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','274',3833,'11','1',344030.38,344030.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','274',3834,'12','1',439231.26,439231.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','274',3835,'13','2',208955.15,209232.59,277.44,244147.20,0.00,0.00,0.00,0.00,0.00),('1','281','3','274',3836,'14','2',50256.67,50256.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','275',3837,'1','1',353191.88,353191.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','275',3838,'2','1',515608.51,515608.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','275',3839,'3','1',255368.87,258731.45,3362.58,622077.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','275',3840,'4','1',414621.09,417933.76,3312.67,612843.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','275',3841,'5','1',338308.03,338308.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','275',3842,'6','1',508860.85,508860.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','275',3843,'7','1',43843.51,47194.71,3351.20,619972.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','275',3844,'8','1',551832.79,554775.90,2943.11,544475.35,0.00,0.00,0.00,0.00,0.00),('1','281','2','275',3845,'9','1',334479.01,334479.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','275',3846,'10','1',441700.56,441700.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','275',3847,'11','1',344030.38,347710.19,3679.81,680764.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','275',3848,'12','1',439231.26,442529.55,3298.29,610183.65,0.00,0.00,0.00,0.00,0.00),('1','281','3','275',3849,'13','2',209232.59,209703.81,471.22,414673.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','275',3850,'14','2',50256.67,50336.47,79.80,70224.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','276',3851,'1','1',353191.88,353191.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','276',3852,'2','1',515608.51,515608.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','276',3853,'3','1',258731.45,258731.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','276',3854,'4','1',417933.76,417933.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','276',3855,'5','1',338308.03,338308.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','276',3856,'6','1',508860.85,508860.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','276',3857,'7','1',47194.71,47194.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','276',3858,'8','1',554775.90,554775.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','276',3859,'9','1',334479.01,334479.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','276',3860,'10','1',441700.56,441700.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','276',3861,'11','1',347710.19,347710.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','276',3862,'12','1',442529.55,442529.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','276',3863,'13','2',209703.81,209703.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','276',3864,'14','2',50336.47,50336.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','277',3865,'1','1',353191.88,353191.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','277',3866,'2','1',515608.51,515608.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','277',3867,'3','1',258731.45,258731.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','277',3868,'4','1',417933.76,417933.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','277',3869,'5','1',338308.03,338308.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','277',3870,'6','1',508860.85,508860.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','277',3871,'7','1',47194.71,47194.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','277',3872,'8','1',554775.90,554775.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','277',3873,'9','1',334479.01,334479.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','277',3874,'10','1',441700.56,441700.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','277',3875,'11','1',347710.19,347710.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','277',3876,'12','1',442529.55,442529.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','277',3877,'13','2',209703.81,211479.23,1775.42,1562369.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','277',3878,'14','2',50336.47,50476.51,140.04,123235.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','278',3879,'1','1',353191.88,357822.46,4630.58,856657.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','278',3880,'2','1',515608.51,520193.09,4584.58,848147.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','278',3881,'3','1',258731.45,258731.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','278',3882,'4','1',417933.76,417933.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','278',3883,'5','1',338308.03,344148.58,5840.55,1080501.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','278',3884,'6','1',508860.85,513627.72,4766.87,881870.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','278',3885,'7','1',47194.71,47194.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','278',3886,'8','1',554775.90,554775.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','278',3887,'9','1',334479.01,339630.77,5151.76,953075.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','278',3888,'10','1',441700.56,446471.87,4771.31,882692.35,0.00,0.00,0.00,0.00,0.00),('1','281','2','278',3889,'11','1',347710.19,347710.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','278',3890,'12','1',442529.55,442529.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','278',3891,'13','2',211479.23,213512.22,2032.99,1789031.20,0.00,0.00,0.00,0.00,0.00),('1','281','3','278',3892,'14','2',50476.51,50559.36,82.85,72908.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','279',3893,'1','1',357822.46,357822.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','279',3894,'2','1',520193.09,520193.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','279',3895,'3','1',258731.45,258731.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','279',3896,'4','1',417933.76,417933.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','279',3897,'5','1',344148.58,344148.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','279',3898,'6','1',513627.72,513627.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','279',3899,'7','1',47194.71,47194.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','279',3900,'8','1',554775.90,554775.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','279',3901,'9','1',339630.77,339630.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','279',3902,'10','1',446471.87,446471.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','279',3903,'11','1',347710.19,347710.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','279',3904,'12','1',442529.55,442529.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','279',3905,'13','2',213512.22,214325.20,812.98,715422.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','279',3906,'14','2',50559.36,50594.59,35.23,31002.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','280',3907,'1','1',357822.46,364167.16,6344.70,1173769.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','280',3908,'2','1',520193.09,526618.28,6425.19,1188660.15,0.00,0.00,0.00,0.00,0.00),('1','281','1','280',3909,'3','1',258731.45,258731.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','280',3910,'4','1',417933.76,417933.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','280',3911,'5','1',344148.58,351190.17,7041.59,1302694.15,0.00,0.00,0.00,0.00,0.00),('1','281','1','280',3912,'6','1',513627.72,520564.14,6936.42,1283237.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','280',3913,'7','1',47194.71,47194.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','280',3914,'8','1',554775.90,554775.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','280',3915,'9','1',339630.77,346270.09,6639.32,1228274.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','280',3916,'10','1',446471.87,452825.53,6353.66,1175427.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','280',3917,'11','1',347710.19,347710.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','280',3918,'12','1',442529.55,442529.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','280',3919,'13','2',214325.20,216333.08,2007.88,1766934.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','280',3920,'14','2',50594.59,50867.47,272.88,240134.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','281',3921,'1','1',364167.16,364167.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','281',3922,'2','1',526618.28,526618.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','281',3923,'3','1',258731.45,258731.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','281',3924,'4','1',417933.76,417933.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','281',3925,'5','1',351190.17,351190.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','281',3926,'6','1',520564.14,520564.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','281',3927,'7','1',47194.71,47194.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','281',3928,'8','1',554775.90,554775.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','281',3929,'9','1',346270.09,346270.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','281',3930,'10','1',452825.53,452825.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','281',3931,'11','1',347710.19,347710.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','281',3932,'12','1',442529.55,442529.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','281',3933,'13','2',216333.08,216980.10,647.02,569377.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','281',3934,'14','2',50867.47,51006.24,138.77,122117.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','282',3935,'1','1',364167.16,368163.06,3995.90,739241.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','282',3936,'2','1',526618.28,530145.79,3527.51,652589.35,0.00,0.00,0.00,0.00,0.00),('1','281','1','282',3937,'3','1',258731.45,258731.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','282',3938,'4','1',417933.76,417933.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','282',3939,'5','1',351190.17,358180.92,6990.75,1293288.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','282',3940,'6','1',520564.14,524306.21,3742.07,692282.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','282',3941,'7','1',47194.71,47194.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','282',3942,'8','1',554775.90,554775.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','282',3943,'9','1',346270.09,350348.34,4078.25,754476.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','282',3944,'10','1',452825.53,456341.64,3516.11,650480.35,0.00,0.00,0.00,0.00,0.00),('1','281','2','282',3945,'11','1',347710.19,347710.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','282',3946,'12','1',442529.55,442529.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','282',3947,'13','2',216980.10,217238.75,258.65,227612.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','282',3948,'14','2',51006.24,51006.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','283',3949,'1','1',368163.06,368163.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','283',3950,'2','1',530145.79,530145.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','283',3951,'3','1',258731.45,258731.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','283',3952,'4','1',417933.76,417933.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','283',3953,'5','1',358180.92,358180.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','283',3954,'6','1',524306.21,524306.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','283',3955,'7','1',47194.71,47194.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','283',3956,'8','1',554775.90,554775.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','283',3957,'9','1',350348.34,350348.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','283',3958,'10','1',456341.64,456341.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','283',3959,'11','1',347710.19,347710.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','283',3960,'12','1',442529.55,442529.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','283',3961,'13','2',217238.75,217523.30,284.55,250404.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','283',3962,'14','2',51006.24,51121.61,115.37,101525.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','284',3963,'1','1',368163.06,368163.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','284',3964,'2','1',530145.79,530145.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','284',3965,'3','1',258731.45,258731.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','284',3966,'4','1',417933.76,417933.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','284',3967,'5','1',358180.92,358180.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','284',3968,'6','1',524306.21,524306.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','284',3969,'7','1',47194.71,47194.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','284',3970,'8','1',554775.90,554775.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','284',3971,'9','1',350348.34,350348.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','284',3972,'10','1',456341.64,456341.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','284',3973,'11','1',347710.19,347710.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','284',3974,'12','1',442529.55,442529.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','284',3975,'13','2',217523.30,217705.94,182.64,160723.20,0.00,0.00,0.00,0.00,0.00),('1','281','3','284',3976,'14','2',51121.61,51121.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','285',3977,'1','1',368163.06,368163.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','285',3978,'2','1',530145.79,530145.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','285',3979,'3','1',258731.45,258731.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','285',3980,'4','1',417933.76,417933.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','285',3981,'5','1',358180.92,358180.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','285',3982,'6','1',524306.21,524306.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','285',3983,'7','1',47194.71,47194.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','285',3984,'8','1',554775.90,554775.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','285',3985,'9','1',350348.34,350348.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','285',3986,'10','1',456341.64,456341.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','285',3987,'11','1',347710.19,347710.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','285',3988,'12','1',442529.55,442529.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','285',3989,'13','2',217705.94,218270.89,564.95,497156.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','285',3990,'14','2',51121.61,51146.61,25.00,22000.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','286',3991,'1','1',368163.06,368163.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','286',3992,'2','1',530145.79,530145.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','286',3993,'3','1',258731.45,263455.03,4723.58,873862.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','286',3994,'4','1',417933.76,422883.37,4949.61,915677.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','286',3995,'5','1',358180.92,358180.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','286',3996,'6','1',524306.21,524869.19,562.98,104151.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','286',3997,'7','1',47194.71,52231.32,5036.61,931772.85,0.00,0.00,0.00,0.00,0.00),('1','281','2','286',3998,'8','1',554775.90,559563.87,4787.97,885774.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','286',3999,'9','1',350348.34,350348.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','286',4000,'10','1',456341.64,456341.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','286',4001,'11','1',347710.19,352702.11,4991.92,923505.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','286',4002,'12','1',442529.55,447720.48,5190.93,960322.05,0.00,0.00,0.00,0.00,0.00),('1','281','3','286',4003,'13','2',218270.89,223731.54,5460.65,4805372.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','286',4004,'14','2',51146.61,51163.28,16.67,14669.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','287',4005,'1','1',368163.06,368163.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','287',4006,'2','1',530145.79,530145.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','287',4007,'3','1',263455.03,263455.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','287',4008,'4','1',422883.37,422883.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','287',4009,'5','1',358180.92,358180.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','287',4010,'6','1',524869.19,524869.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','287',4011,'7','1',52231.32,52231.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','287',4012,'8','1',559563.87,559563.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','287',4013,'9','1',350348.34,350348.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','287',4014,'10','1',456341.64,456341.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','287',4015,'11','1',352702.11,352702.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','287',4016,'12','1',447720.48,447720.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','287',4017,'13','2',223731.54,223883.78,152.24,133971.20,0.00,0.00,0.00,0.00,0.00),('1','281','3','287',4018,'14','2',51163.28,51272.38,109.10,96008.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','288',4019,'1','1',368163.06,368163.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','288',4020,'2','1',530145.79,530145.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','288',4021,'3','1',263455.03,265930.72,2475.69,458002.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','288',4022,'4','1',422883.37,425404.29,2520.92,466370.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','288',4023,'5','1',358180.92,358396.12,215.20,39812.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','288',4024,'6','1',524869.19,524869.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','288',4025,'7','1',52231.32,55010.84,2779.52,514211.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','288',4026,'8','1',559563.87,562113.51,2549.64,471683.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','288',4027,'9','1',350348.34,350348.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','288',4028,'10','1',456341.64,456341.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','288',4029,'11','1',352702.11,355513.67,2811.56,520138.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','288',4030,'12','1',447720.48,450574.46,2853.98,527986.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','288',4031,'13','2',223883.78,226571.45,2687.67,2365149.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','288',4032,'14','2',51272.38,51272.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','289',4033,'1','1',368163.06,368163.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','289',4034,'2','1',530145.79,530145.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','289',4035,'3','1',265930.72,265930.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','289',4036,'4','1',425404.29,425404.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','289',4037,'5','1',358396.12,358396.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','289',4038,'6','1',524869.19,524869.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','289',4039,'7','1',55010.84,55010.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','289',4040,'8','1',562113.51,562113.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','289',4041,'9','1',350348.34,350348.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','289',4042,'10','1',456341.64,456341.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','289',4043,'11','1',355513.67,355513.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','289',4044,'12','1',450574.46,450574.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','289',4045,'13','2',226571.45,226610.13,38.68,34038.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','289',4046,'14','2',51272.38,51496.09,223.71,196864.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','290',4047,'1','1',368163.06,368163.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','290',4048,'2','1',530145.79,530145.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','290',4049,'3','1',265930.72,265930.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','290',4050,'4','1',425404.29,425404.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','290',4051,'5','1',358396.12,358396.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','290',4052,'6','1',524869.19,524869.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','290',4053,'7','1',55010.84,55010.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','290',4054,'8','1',562113.51,562113.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','290',4055,'9','1',350348.34,350348.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','290',4056,'10','1',456341.64,456341.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','290',4057,'11','1',355513.67,355513.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','290',4058,'12','1',450574.46,450574.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','290',4059,'13','2',226610.13,228118.16,1508.03,1327066.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','290',4060,'14','2',51496.09,51607.90,111.81,98392.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','291',4061,'1','1',368163.06,372456.80,4293.74,794341.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','291',4062,'2','1',530145.79,534238.64,4092.85,757177.25,0.00,0.00,0.00,0.00,0.00),('1','281','1','291',4063,'3','1',265930.72,265930.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','291',4064,'4','1',425404.29,425404.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','291',4065,'5','1',358396.12,367411.64,9015.52,1667871.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','291',4066,'6','1',524869.19,528774.55,3905.36,722491.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','291',4067,'7','1',55010.84,55010.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','291',4068,'8','1',562113.51,562113.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','291',4069,'9','1',350348.34,354549.94,4201.60,777296.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','291',4070,'10','1',456341.64,460700.01,4358.37,806298.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','291',4071,'11','1',355513.67,355513.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','291',4072,'12','1',450574.46,450574.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','291',4073,'13','2',228118.16,229615.25,1497.09,1317439.20,0.00,0.00,0.00,0.00,0.00),('1','281','3','291',4074,'14','2',51607.90,51873.11,265.21,233384.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','292',4075,'1','1',372456.80,372456.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','292',4076,'2','1',534238.64,534238.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','292',4077,'3','1',265930.72,265930.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','292',4078,'4','1',425404.29,425404.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','292',4079,'5','1',367411.64,367411.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','292',4080,'6','1',528774.55,528774.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','292',4081,'7','1',55010.84,55010.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','292',4082,'8','1',562113.51,562113.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','292',4083,'9','1',354549.94,354549.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','292',4084,'10','1',460700.01,460700.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','292',4085,'11','1',355513.67,355513.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','292',4086,'12','1',450574.46,450574.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','292',4087,'13','2',229615.25,229920.03,304.78,268206.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','292',4088,'14','2',51873.11,52207.78,334.67,294509.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','293',4089,'1','1',372456.80,372456.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','293',4090,'2','1',534238.64,534238.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','293',4091,'3','1',265930.72,265930.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','293',4092,'4','1',425404.29,425404.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','293',4093,'5','1',367411.64,367411.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','293',4094,'6','1',528774.55,528774.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','293',4095,'7','1',55010.84,55010.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','293',4096,'8','1',562113.51,562113.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','293',4097,'9','1',354549.94,354549.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','293',4098,'10','1',460700.01,460700.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','293',4099,'11','1',355513.67,355513.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','293',4100,'12','1',450574.46,450574.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','293',4101,'13','2',229920.03,230477.69,557.66,490740.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','293',4102,'14','2',52207.78,52207.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','294',4103,'1','1',372456.80,372456.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','294',4104,'2','1',534238.64,534238.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','294',4105,'3','1',265930.72,265930.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','294',4106,'4','1',425404.29,425404.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','294',4107,'5','1',367411.64,367411.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','294',4108,'6','1',528774.55,528774.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','294',4109,'7','1',55010.84,55010.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','294',4110,'8','1',562113.51,562113.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','294',4111,'9','1',354549.94,354549.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','294',4112,'10','1',460700.01,460700.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','294',4113,'11','1',355513.67,355513.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','294',4114,'12','1',450574.46,450574.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','294',4115,'13','2',230477.69,230858.90,381.21,335464.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','294',4116,'14','2',52207.78,52207.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','295',4117,'1','1',372456.80,375610.55,3153.75,583443.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','295',4118,'2','1',534238.64,537345.71,3107.07,574807.95,0.00,0.00,0.00,0.00,0.00),('1','281','1','295',4119,'3','1',265930.72,265930.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','295',4120,'4','1',425404.29,425404.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','295',4121,'5','1',367411.64,371290.81,3879.17,717646.45,0.00,0.00,0.00,0.00,0.00),('1','281','1','295',4122,'6','1',528774.55,532054.19,3279.64,606733.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','295',4123,'7','1',55010.84,55010.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','295',4124,'8','1',562113.51,562113.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','295',4125,'9','1',354549.94,357742.01,3192.07,590532.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','295',4126,'10','1',460700.01,463953.67,3253.66,601927.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','295',4127,'11','1',355513.67,355513.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','295',4128,'12','1',450574.46,450574.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','295',4129,'13','2',230858.90,231819.21,960.31,845072.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','295',4130,'14','2',52207.78,52348.61,140.83,123930.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','296',4131,'1','1',375610.55,375610.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','296',4132,'2','1',537345.71,537345.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','296',4133,'3','1',265930.72,265930.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','296',4134,'4','1',425404.29,425404.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','296',4135,'5','1',371290.81,371290.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','296',4136,'6','1',532054.19,532054.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','296',4137,'7','1',55010.84,55010.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','296',4138,'8','1',562113.51,562113.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','296',4139,'9','1',357742.01,357742.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','296',4140,'10','1',463953.67,463953.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','296',4141,'11','1',355513.67,355513.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','296',4142,'12','1',450574.46,450574.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','296',4143,'13','2',231819.21,232208.98,389.77,342997.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','296',4144,'14','2',52348.61,52348.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','297',4145,'1','1',375610.55,378865.94,3255.39,602247.15,0.00,0.00,0.00,0.00,0.00),('1','281','1','297',4146,'2','1',537345.71,540237.67,2891.96,535012.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','297',4147,'3','1',265930.72,265930.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','297',4148,'4','1',425404.29,425404.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','297',4149,'5','1',371290.81,374393.40,3102.59,573979.15,0.00,0.00,0.00,0.00,0.00),('1','281','1','297',4150,'6','1',532054.19,535305.50,3251.31,601492.35,0.00,0.00,0.00,0.00,0.00),('1','281','2','297',4151,'7','1',55010.84,55010.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','297',4152,'8','1',562113.51,562113.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','297',4153,'9','1',357742.01,360953.03,3211.02,594038.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','297',4154,'10','1',463953.67,466838.94,2885.27,533774.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','297',4155,'11','1',355513.67,355513.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','297',4156,'12','1',450574.46,450574.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','297',4157,'13','2',232208.98,232438.41,229.43,201898.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','297',4158,'14','2',52348.61,52348.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','298',4159,'1','1',378865.94,378865.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','298',4160,'2','1',540237.67,540237.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','298',4161,'3','1',265930.72,265930.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','298',4162,'4','1',425404.29,425404.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','298',4163,'5','1',374393.40,374393.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','298',4164,'6','1',535305.50,535305.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','298',4165,'7','1',55010.84,55010.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','298',4166,'8','1',562113.51,562113.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','298',4167,'9','1',360953.03,360953.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','298',4168,'10','1',466838.94,466838.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','298',4169,'11','1',355513.67,355513.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','298',4170,'12','1',450574.46,450574.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','298',4171,'13','2',232438.41,234065.51,1627.10,1431848.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','298',4172,'14','2',52348.61,54100.67,1752.06,1541812.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','299',4173,'1','1',378865.94,378865.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','299',4174,'2','1',540237.67,540237.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','299',4175,'3','1',265930.72,265930.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','299',4176,'4','1',425404.29,425404.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','299',4177,'5','1',374393.40,374393.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','299',4178,'6','1',535305.50,535305.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','299',4179,'7','1',55010.84,55010.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','299',4180,'8','1',562113.51,562113.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','299',4181,'9','1',360953.03,360953.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','299',4182,'10','1',466838.94,466838.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','299',4183,'11','1',355513.67,355513.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','299',4184,'12','1',450574.46,450574.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','299',4185,'13','2',234065.51,235178.44,1112.93,979378.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','299',4186,'14','2',54100.67,54100.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','300',4187,'1','1',378865.94,383041.00,4175.06,772386.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','300',4188,'2','1',540237.67,544681.76,4444.09,822156.65,0.00,0.00,0.00,0.00,0.00),('1','281','1','300',4189,'3','1',265930.72,265930.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','300',4190,'4','1',425404.29,425404.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','300',4191,'5','1',374393.40,382978.55,8585.15,1588252.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','300',4192,'6','1',535305.50,539209.15,3903.65,722175.25,0.00,0.00,0.00,0.00,0.00),('1','281','2','300',4193,'7','1',55010.84,55010.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','300',4194,'8','1',562113.51,562113.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','300',4195,'9','1',360953.03,365673.00,4719.97,873194.45,0.00,0.00,0.00,0.00,0.00),('1','281','2','300',4196,'10','1',466838.94,470921.61,4082.67,755293.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','300',4197,'11','1',355513.67,355513.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','300',4198,'12','1',450574.46,450574.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','300',4199,'13','2',235178.44,236746.75,1568.31,1380112.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','300',4200,'14','2',54100.67,54335.62,234.95,206756.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','301',4201,'1','1',383041.00,383041.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','301',4202,'2','1',544681.76,544681.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','301',4203,'3','1',265930.72,265930.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','301',4204,'4','1',425404.29,425404.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','301',4205,'5','1',382978.55,382978.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','301',4206,'6','1',539209.15,539209.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','301',4207,'7','1',55010.84,55010.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','301',4208,'8','1',562113.51,562113.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','301',4209,'9','1',365673.00,365673.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','301',4210,'10','1',470921.61,470921.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','301',4211,'11','1',355513.67,355513.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','301',4212,'12','1',450574.46,450574.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','301',4213,'13','2',236746.75,236833.59,86.84,76419.20,0.00,0.00,0.00,0.00,0.00),('1','281','3','301',4214,'14','2',54335.62,54634.33,298.71,262864.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','302',4215,'1','1',383041.00,383041.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','302',4216,'2','1',544681.76,544681.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','302',4217,'3','1',265930.72,265930.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','302',4218,'4','1',425404.29,425404.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','302',4219,'5','1',382978.55,382978.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','302',4220,'6','1',539209.15,539209.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','302',4221,'7','1',55010.84,55010.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','302',4222,'8','1',562113.51,562113.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','302',4223,'9','1',365673.00,365673.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','302',4224,'10','1',470921.61,470921.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','302',4225,'11','1',355513.67,355513.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','302',4226,'12','1',450574.46,450574.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','302',4227,'13','2',236833.59,237670.12,836.53,736146.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','302',4228,'14','2',54634.33,54811.03,176.70,155496.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','303',4229,'1','1',383041.00,383041.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','303',4230,'2','1',544681.76,544681.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','303',4231,'3','1',265930.72,265930.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','303',4232,'4','1',425404.29,425404.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','303',4233,'5','1',382978.55,382978.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','303',4234,'6','1',539209.15,539209.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','303',4235,'7','1',55010.84,55010.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','303',4236,'8','1',562113.51,562113.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','303',4237,'9','1',365673.00,365673.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','303',4238,'10','1',470921.61,470921.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','303',4239,'11','1',355513.67,355513.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','303',4240,'12','1',450574.46,450574.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','303',4241,'13','2',237670.12,237888.29,218.17,191989.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','303',4242,'14','2',54811.03,55143.98,332.95,292996.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','304',4243,'1','1',383041.00,383041.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','304',4244,'2','1',544681.76,544681.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','304',4245,'3','1',265930.72,265930.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','304',4246,'4','1',425404.29,425404.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','304',4247,'5','1',382978.55,382978.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','304',4248,'6','1',539209.15,539209.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','304',4249,'7','1',55010.84,55010.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','304',4250,'8','1',562113.51,562113.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','304',4251,'9','1',365673.00,365673.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','304',4252,'10','1',470921.61,470921.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','304',4253,'11','1',355513.67,355513.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','304',4254,'12','1',450574.46,450574.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','304',4255,'13','2',237888.29,238212.34,324.05,285164.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','304',4256,'14','2',55143.98,55150.53,6.55,5764.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','305',4257,'1','1',383041.00,383041.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','305',4258,'2','1',544681.76,544681.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','305',4259,'3','1',265930.72,265930.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','305',4260,'4','1',425404.29,425404.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','305',4261,'5','1',382978.55,382978.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','305',4262,'6','1',539209.15,539209.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','305',4263,'7','1',55010.84,55010.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','305',4264,'8','1',562113.51,562113.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','305',4265,'9','1',365673.00,365673.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','305',4266,'10','1',470921.61,470921.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','305',4267,'11','1',355513.67,355513.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','305',4268,'12','1',450574.46,450574.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','305',4269,'13','2',238212.34,239099.96,887.62,781105.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','305',4270,'14','2',55150.53,55416.22,265.69,233807.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','306',4271,'1','1',383041.00,383041.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','306',4272,'2','1',544681.76,544681.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','306',4273,'3','1',265930.72,267163.69,1232.97,228099.45,0.00,0.00,0.00,0.00,0.00),('1','281','1','306',4274,'4','1',425404.29,429044.44,3640.15,673427.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','306',4275,'5','1',382978.55,382978.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','306',4276,'6','1',539209.15,539209.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','306',4277,'7','1',55010.84,56468.95,1458.11,269750.35,0.00,0.00,0.00,0.00,0.00),('1','281','2','306',4278,'8','1',562113.51,565623.31,3509.80,649313.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','306',4279,'9','1',365673.00,365673.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','306',4280,'10','1',470921.61,470921.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','306',4281,'11','1',355513.67,358015.78,2502.11,462890.35,0.00,0.00,0.00,0.00,0.00),('1','281','2','306',4282,'12','1',450574.46,454538.90,3964.44,733421.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','306',4283,'13','2',239099.96,240957.83,1857.87,1634925.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','306',4284,'14','2',55416.22,55619.79,203.57,179141.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','307',4285,'1','1',383041.00,383041.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','307',4286,'2','1',544681.76,544681.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','307',4287,'3','1',267163.69,267163.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','307',4288,'4','1',429044.44,429044.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','307',4289,'5','1',382978.55,382978.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','307',4290,'6','1',539209.15,539209.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','307',4291,'7','1',56468.95,56468.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','307',4292,'8','1',565623.31,565623.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','307',4293,'9','1',365673.00,365673.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','307',4294,'10','1',470921.61,470921.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','307',4295,'11','1',358015.78,358015.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','307',4296,'12','1',454538.90,454538.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','307',4297,'13','2',240957.83,241254.39,296.56,260972.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','307',4298,'14','2',55619.79,55619.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','308',4299,'1','1',383041.00,383041.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','308',4300,'2','1',544681.76,544681.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','308',4301,'3','1',267163.69,267163.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','308',4302,'4','1',429044.44,429044.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','308',4303,'5','1',382978.55,382978.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','308',4304,'6','1',539209.15,539209.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','308',4305,'7','1',56468.95,56468.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','308',4306,'8','1',565623.31,565623.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','308',4307,'9','1',365673.00,365673.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','308',4308,'10','1',470921.61,470921.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','308',4309,'11','1',358015.78,358015.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','308',4310,'12','1',454538.90,454538.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','308',4311,'13','2',241254.39,243699.54,2445.15,2151732.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','308',4312,'14','2',55619.79,55795.32,175.53,154466.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','309',4313,'1','1',383041.00,383041.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','309',4314,'2','1',544681.76,544681.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','309',4315,'3','1',267163.69,267163.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','309',4316,'4','1',429044.44,429044.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','309',4317,'5','1',382978.55,382978.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','309',4318,'6','1',539209.15,539209.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','309',4319,'7','1',56468.95,56468.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','309',4320,'8','1',565623.31,565623.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','309',4321,'9','1',365673.00,365673.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','309',4322,'10','1',470921.61,470921.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','309',4323,'11','1',358015.78,358015.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','309',4324,'12','1',454538.90,454538.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','309',4325,'13','2',243699.54,244092.71,393.17,345989.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','309',4326,'14','2',55795.32,56084.18,288.86,254196.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','310',4327,'1','1',383041.00,388304.90,5263.90,973821.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','310',4328,'2','1',544681.76,549529.37,4847.61,896807.85,0.00,0.00,0.00,0.00,0.00),('1','281','1','310',4329,'3','1',267163.69,267163.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','310',4330,'4','1',429044.44,429044.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','310',4331,'5','1',382978.55,390907.88,7929.33,1466926.05,0.00,0.00,0.00,0.00,0.00),('1','281','1','310',4332,'6','1',539209.15,544350.41,5141.26,951133.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','310',4333,'7','1',56468.95,56468.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','310',4334,'8','1',565623.31,565623.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','310',4335,'9','1',365673.00,370527.99,4854.99,898173.15,0.00,0.00,0.00,0.00,0.00),('1','281','2','310',4336,'10','1',470921.61,475607.73,4686.12,866932.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','310',4337,'11','1',358015.78,358015.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','310',4338,'12','1',454538.90,454538.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','310',4339,'13','2',244092.71,246075.42,1982.71,1744784.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','310',4340,'14','2',56084.18,56191.37,107.19,94327.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','311',4341,'1','1',388304.90,388304.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','311',4342,'2','1',549529.37,549529.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','311',4343,'3','1',267163.69,267163.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','311',4344,'4','1',429044.44,429044.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','311',4345,'5','1',390907.88,390907.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','311',4346,'6','1',544350.41,544350.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','311',4347,'7','1',56468.95,56468.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','311',4348,'8','1',565623.31,565623.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','311',4349,'9','1',370527.99,370527.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','311',4350,'10','1',475607.73,475607.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','311',4351,'11','1',358015.78,358015.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','311',4352,'12','1',454538.90,454538.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','311',4353,'13','2',246075.42,246203.97,128.55,113124.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','311',4354,'14','2',56191.37,56204.30,12.93,11378.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','312',4355,'1','1',388304.90,388304.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','312',4356,'2','1',549529.37,549529.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','312',4357,'3','1',267163.69,267163.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','312',4358,'4','1',429044.44,429044.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','312',4359,'5','1',390907.88,390907.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','312',4360,'6','1',544350.41,544350.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','312',4361,'7','1',56468.95,56468.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','312',4362,'8','1',565623.31,565623.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','312',4363,'9','1',370527.99,370527.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','312',4364,'10','1',475607.73,475607.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','312',4365,'11','1',358015.78,358015.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','312',4366,'12','1',454538.90,454538.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','312',4367,'13','2',246203.97,246593.61,389.64,342883.20,0.00,0.00,0.00,0.00,0.00),('1','281','3','312',4368,'14','2',56204.30,56255.27,50.97,44853.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','313',4369,'1','1',388304.90,388304.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','313',4370,'2','1',549529.37,549529.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','313',4371,'3','1',267163.69,267163.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','313',4372,'4','1',429044.44,429044.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','313',4373,'5','1',390907.88,390907.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','313',4374,'6','1',544350.41,544350.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','313',4375,'7','1',56468.95,56468.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','313',4376,'8','1',565623.31,565623.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','313',4377,'9','1',370527.99,370527.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','313',4378,'10','1',475607.73,475607.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','313',4379,'11','1',358015.78,358015.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','313',4380,'12','1',454538.90,454538.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','313',4381,'13','2',246593.61,247583.28,989.67,870909.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','313',4382,'14','2',56255.27,56255.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','314',4383,'1','1',388304.90,388304.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','314',4384,'2','1',549529.37,549529.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','314',4385,'3','1',267163.69,270014.87,2851.18,527468.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','314',4386,'4','1',429044.44,431985.59,2941.15,544112.75,0.00,0.00,0.00,0.00,0.00),('1','281','1','314',4387,'5','1',390907.88,390907.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','314',4388,'6','1',544350.41,544350.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','314',4389,'7','1',56468.95,59289.02,2820.07,521712.95,0.00,0.00,0.00,0.00,0.00),('1','281','2','314',4390,'8','1',565623.31,568274.97,2651.66,490557.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','314',4391,'9','1',370527.99,370527.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','314',4392,'10','1',475607.73,475607.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','314',4393,'11','1',358015.78,361093.94,3078.16,569459.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','314',4394,'12','1',454538.90,459934.72,5395.82,998226.70,0.00,0.00,0.00,0.00,0.00),('1','281','3','314',4395,'13','2',247583.28,248237.58,654.30,575784.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','314',4396,'14','2',56255.27,56529.68,274.41,241480.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','315',4397,'1','1',388304.90,388304.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','315',4398,'2','1',549529.37,549529.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','315',4399,'3','1',270014.87,270014.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','315',4400,'4','1',431985.59,431985.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','315',4401,'5','1',390907.88,390907.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','315',4402,'6','1',544350.41,544350.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','315',4403,'7','1',59289.02,59289.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','315',4404,'8','1',568274.97,568274.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','315',4405,'9','1',370527.99,370527.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','315',4406,'10','1',475607.73,475607.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','315',4407,'11','1',361093.94,361093.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','315',4408,'12','1',459934.72,459934.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','315',4409,'13','2',248237.58,250590.31,2352.73,2070402.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','315',4410,'14','2',56529.68,57738.56,1208.88,1063814.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','316',4411,'1','1',388304.90,388304.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','316',4412,'2','1',549529.37,549529.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','316',4413,'3','1',270014.87,270014.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','316',4414,'4','1',431985.59,431985.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','316',4415,'5','1',390907.88,390907.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','316',4416,'6','1',544350.41,544350.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','316',4417,'7','1',59289.02,59289.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','316',4418,'8','1',568274.97,568274.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','316',4419,'9','1',370527.99,370527.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','316',4420,'10','1',475607.73,475607.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','316',4421,'11','1',361093.94,361093.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','316',4422,'12','1',459934.72,459934.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','316',4423,'13','2',250590.31,252276.97,1686.66,1467394.20,0.00,0.00,0.00,0.00,0.00),('1','281','3','316',4424,'14','2',57738.56,58211.93,473.37,411831.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','317',4425,'1','1',388304.90,388304.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','317',4426,'2','1',549529.37,549529.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','317',4427,'3','1',270014.87,270014.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','317',4428,'4','1',431985.59,431985.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','317',4429,'5','1',390907.88,390907.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','317',4430,'6','1',544350.41,544350.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','317',4431,'7','1',59289.02,59289.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','317',4432,'8','1',568274.97,568274.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','317',4433,'9','1',370527.99,370527.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','317',4434,'10','1',475607.73,475607.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','317',4435,'11','1',361093.94,361093.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','317',4436,'12','1',459934.72,459934.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','317',4437,'13','2',252276.97,252841.84,564.87,491436.90,0.00,0.00,0.00,0.00,0.00),('1','281','3','317',4438,'14','2',58211.93,58249.19,37.26,32416.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','318',4439,'1','1',388304.90,388304.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','318',4440,'2','1',549529.37,549529.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','318',4441,'3','1',270014.87,270014.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','318',4442,'4','1',431985.59,431985.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','318',4443,'5','1',390907.88,390907.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','318',4444,'6','1',544350.41,544350.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','318',4445,'7','1',59289.02,59289.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','318',4446,'8','1',568274.97,568274.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','318',4447,'9','1',370527.99,370527.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','318',4448,'10','1',475607.73,475607.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','318',4449,'11','1',361093.94,361093.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','318',4450,'12','1',459934.72,459934.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','318',4451,'13','2',252841.84,254112.43,1270.59,1105413.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','318',4452,'14','2',58249.19,58339.83,90.64,78856.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','319',4453,'1','1',388304.90,388304.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','319',4454,'2','1',549529.37,549529.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','319',4455,'3','1',270014.87,270014.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','319',4456,'4','1',431985.59,431985.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','319',4457,'5','1',390907.88,390907.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','319',4458,'6','1',544350.41,544350.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','319',4459,'7','1',59289.02,59289.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','319',4460,'8','1',568274.97,568274.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','319',4461,'9','1',370527.99,370527.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','319',4462,'10','1',475607.73,475607.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','319',4463,'11','1',361093.94,361093.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','319',4464,'12','1',459934.72,459934.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','319',4465,'13','2',254112.43,256712.30,2599.87,2261886.90,0.00,0.00,0.00,0.00,0.00),('1','281','3','319',4466,'14','2',58339.83,60145.22,1805.39,1570689.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','320',4467,'1','1',388304.90,388304.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','320',4468,'2','1',549529.37,549529.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','320',4469,'3','1',270014.87,270014.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','320',4470,'4','1',431985.59,431985.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','320',4471,'5','1',390907.88,390907.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','320',4472,'6','1',544350.41,544350.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','320',4473,'7','1',59289.02,59289.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','320',4474,'8','1',568274.97,568274.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','320',4475,'9','1',370527.99,370527.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','320',4476,'10','1',475607.73,475607.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','320',4477,'11','1',361093.94,361093.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','320',4478,'12','1',459934.72,459934.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','320',4479,'13','2',256712.30,257436.42,724.12,629984.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','320',4480,'14','2',60145.22,60467.55,322.33,280427.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','321',4481,'1','1',388304.90,390451.89,2146.99,472337.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','321',4482,'2','1',549529.37,551400.23,1870.86,411589.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','321',4483,'3','1',270014.87,270014.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','321',4484,'4','1',431985.59,431985.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','321',4485,'5','1',390907.88,395669.41,4761.53,1047536.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','321',4486,'6','1',544350.41,546368.36,2017.95,443949.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','321',4487,'7','1',59289.02,59289.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','321',4488,'8','1',568274.97,568274.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','321',4489,'9','1',370527.99,372608.67,2080.68,457749.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','321',4490,'10','1',475607.73,477671.57,2063.84,454044.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','321',4491,'11','1',361093.94,361093.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','321',4492,'12','1',459934.72,459934.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','321',4493,'13','2',257436.42,257978.36,541.94,471487.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','321',4494,'14','2',60467.55,60467.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','322',4495,'1','1',390451.89,390451.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','322',4496,'2','1',551400.23,551400.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','322',4497,'3','1',270014.87,270014.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','322',4498,'4','1',431985.59,431985.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','322',4499,'5','1',395669.41,395669.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','322',4500,'6','1',546368.36,546368.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','322',4501,'7','1',59289.02,59289.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','322',4502,'8','1',568274.97,568274.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','322',4503,'9','1',372608.67,372608.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','322',4504,'10','1',477671.57,477671.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','322',4505,'11','1',361093.94,361093.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','322',4506,'12','1',459934.72,459934.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','322',4507,'13','2',257978.36,258816.11,837.75,728842.50,0.00,0.00,0.00,0.00,0.00),('1','281','3','322',4508,'14','2',60467.55,60499.74,32.19,28005.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','323',4509,'1','1',390451.89,390451.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','323',4510,'2','1',551400.23,551400.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','323',4511,'3','1',270014.87,272863.18,2848.31,626628.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','323',4512,'4','1',431985.59,435601.62,3616.03,795526.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','323',4513,'5','1',395669.41,395669.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','323',4514,'6','1',546368.36,546368.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','323',4515,'7','1',59289.02,62502.25,3172.16,697875.20,0.00,0.00,41.07,0.00,0.00),('1','281','2','323',4516,'8','1',568274.97,571212.77,2937.80,646316.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','323',4517,'9','1',372608.67,372608.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','323',4518,'10','1',477671.57,477671.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','323',4519,'11','1',361093.94,364108.28,3014.34,663154.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','323',4520,'12','1',459934.72,463423.65,3488.93,767564.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','323',4521,'13','2',258816.11,259350.65,534.54,465049.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','323',4522,'14','2',60499.74,60499.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','324',4523,'1','1',390451.89,390451.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','324',4524,'2','1',551400.23,551400.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','324',4525,'3','1',272863.18,273014.29,151.11,33244.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','324',4526,'4','1',435601.62,436134.76,533.14,117290.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','324',4527,'5','1',395669.41,395669.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','324',4528,'6','1',546368.36,546368.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','324',4529,'7','1',62502.25,62502.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','324',4530,'8','1',571212.77,571212.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','324',4531,'9','1',372608.67,372608.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','324',4532,'10','1',477671.57,477671.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','324',4533,'11','1',364108.28,364108.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','324',4534,'12','1',463423.65,463423.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','324',4535,'13','2',259350.65,261583.75,2233.10,1942797.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','324',4536,'14','2',60499.74,61615.04,1115.30,970311.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','325',4537,'1','1',390451.89,392948.64,2496.75,549285.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','325',4538,'2','1',551400.23,554082.59,2682.36,590119.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','325',4539,'3','1',273014.29,273014.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','325',4540,'4','1',436134.76,436134.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','325',4541,'5','1',395669.41,398724.26,3054.85,672067.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','325',4542,'6','1',546368.36,549238.16,2869.80,631356.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','325',4543,'7','1',62502.25,62502.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','325',4544,'8','1',571212.77,571212.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','325',4545,'9','1',372608.67,375322.78,2714.11,597104.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','325',4546,'10','1',477671.57,480788.48,3116.91,685720.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','325',4547,'11','1',364108.28,364108.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','325',4548,'12','1',463423.65,463423.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','325',4549,'13','2',261583.75,262329.07,745.32,648428.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','325',4550,'14','2',61615.04,61650.04,35.00,30450.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','326',4551,'1','1',392948.64,392948.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','326',4552,'2','1',554082.59,554082.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','326',4553,'3','1',273014.29,273014.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','326',4554,'4','1',436134.76,436134.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','326',4555,'5','1',398724.26,398724.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','326',4556,'6','1',549238.16,549238.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','326',4557,'7','1',62502.25,62502.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','326',4558,'8','1',571212.77,571212.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','326',4559,'9','1',375322.78,375322.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','326',4560,'10','1',480788.48,480788.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','326',4561,'11','1',364108.28,364108.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','326',4562,'12','1',463423.65,463423.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','326',4563,'13','2',262329.07,262798.83,469.76,408691.20,0.00,0.00,0.00,0.00,0.00),('1','281','3','326',4564,'14','2',61650.04,61816.81,166.77,145089.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','327',4565,'1','1',392948.64,392948.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','327',4566,'2','1',554082.59,554082.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','327',4567,'3','1',273014.29,273014.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','327',4568,'4','1',436134.76,436134.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','327',4569,'5','1',398724.26,398724.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','327',4570,'6','1',549238.16,549238.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','327',4571,'7','1',62502.25,62502.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','327',4572,'8','1',571212.77,571212.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','327',4573,'9','1',375322.78,375322.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','327',4574,'10','1',480788.48,480788.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','327',4575,'11','1',364108.28,364108.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','327',4576,'12','1',463423.65,463423.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','327',4577,'13','2',262798.83,263922.80,1123.97,977853.90,0.00,0.00,0.00,0.00,0.00),('1','281','3','327',4578,'14','2',61816.81,61840.83,24.02,20897.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','328',4579,'1','1',392948.64,395776.73,2828.09,622179.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','328',4580,'2','1',554082.59,556944.63,2862.04,629648.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','328',4581,'3','1',273014.29,273014.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','328',4582,'4','1',436134.76,436134.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','328',4583,'5','1',398724.26,404293.98,5569.72,1225338.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','328',4584,'6','1',549238.16,551725.83,2487.67,547287.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','328',4585,'7','1',62502.25,62502.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','328',4586,'8','1',571212.77,571212.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','328',4587,'9','1',375322.78,378082.87,2760.09,607219.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','328',4588,'10','1',480788.48,483451.39,2662.91,585840.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','328',4589,'11','1',364108.28,364108.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','328',4590,'12','1',463423.65,463423.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','328',4591,'13','2',263922.80,265820.14,1897.34,1650685.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','328',4592,'14','2',61840.83,61880.60,39.77,34599.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','329',4593,'1','1',395776.73,395776.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','329',4594,'2','1',556944.63,557417.14,472.51,103952.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','329',4595,'3','1',273014.29,273014.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','329',4596,'4','1',436134.76,436134.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','329',4597,'5','1',404293.98,404293.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','329',4598,'6','1',551725.83,551725.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','329',4599,'7','1',62502.25,62502.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','329',4600,'8','1',571212.77,571212.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','329',4601,'9','1',378082.87,378082.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','329',4602,'10','1',483451.39,483451.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','329',4603,'11','1',364108.28,364108.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','329',4604,'12','1',463423.65,463423.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','329',4605,'13','2',265820.14,266346.71,526.57,458115.90,0.00,0.00,0.00,0.00,0.00),('1','281','3','329',4606,'14','2',61880.60,61880.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','330',4607,'1','1',395776.73,395776.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','330',4608,'2','1',557417.14,557417.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','330',4609,'3','1',273014.29,275430.33,2416.04,531528.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','330',4610,'4','1',436134.76,438634.68,2499.92,549982.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','330',4611,'5','1',404293.98,404293.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','330',4612,'6','1',551725.83,551725.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','330',4613,'7','1',62502.25,65005.69,2503.44,550756.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','330',4614,'8','1',571212.77,573556.15,2343.38,515543.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','330',4615,'9','1',378082.87,378082.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','330',4616,'10','1',483451.39,483451.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','330',4617,'11','1',364108.28,366683.18,2574.90,566478.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','330',4618,'12','1',463423.65,466046.08,2622.43,576934.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','330',4619,'13','2',266346.71,267294.18,947.47,805349.50,0.00,0.00,0.00,0.00,0.00),('1','281','3','330',4620,'14','2',61880.60,62101.00,220.40,187340.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','331',4621,'1','1',395776.73,395776.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','331',4622,'2','1',557417.14,557417.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','331',4623,'3','1',275430.33,275430.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','331',4624,'4','1',438634.68,438634.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','331',4625,'5','1',404293.98,404293.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','331',4626,'6','1',551725.83,551725.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','331',4627,'7','1',65005.69,65005.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','331',4628,'8','1',573556.15,573556.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','331',4629,'9','1',378082.87,378082.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','331',4630,'10','1',483451.39,483451.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','331',4631,'11','1',366683.18,366683.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','331',4632,'12','1',466046.08,466046.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','331',4633,'13','2',267294.18,268222.85,928.67,789369.50,0.00,0.00,0.00,0.00,0.00),('1','281','3','331',4634,'14','2',62101.00,62146.53,45.53,38700.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','332',4635,'1','1',395776.73,395776.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','332',4636,'2','1',557417.14,557417.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','332',4637,'3','1',275430.33,275430.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','332',4638,'4','1',438634.68,438634.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','332',4639,'5','1',404293.98,404293.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','332',4640,'6','1',551725.83,551725.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','332',4641,'7','1',65005.69,65005.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','332',4642,'8','1',573556.15,573556.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','332',4643,'9','1',378082.87,378082.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','332',4644,'10','1',483451.39,483451.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','332',4645,'11','1',366683.18,366683.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','332',4646,'12','1',466046.08,466046.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','332',4647,'13','2',268222.85,268489.96,267.11,227043.50,0.00,0.00,0.00,0.00,0.00),('1','281','3','332',4648,'14','2',62146.53,62146.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','333',4649,'1','1',395776.73,395776.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','333',4650,'2','1',557417.14,557417.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','333',4651,'3','1',275430.33,275430.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','333',4652,'4','1',438634.68,438634.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','333',4653,'5','1',404293.98,404293.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','333',4654,'6','1',551725.83,551725.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','333',4655,'7','1',65005.69,65005.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','333',4656,'8','1',573556.15,573556.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','333',4657,'9','1',378082.87,378082.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','333',4658,'10','1',483451.39,483451.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','333',4659,'11','1',366683.18,366683.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','333',4660,'12','1',466046.08,466046.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','333',4661,'13','2',268489.96,270947.12,2457.16,2088586.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','333',4662,'14','2',62146.53,64449.55,2303.02,1957567.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','334',4663,'1','1',395776.73,395776.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','334',4664,'2','1',557417.14,557417.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','334',4665,'3','1',275430.33,275430.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','334',4666,'4','1',438634.68,438634.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','334',4667,'5','1',404293.98,404293.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','334',4668,'6','1',551725.83,551725.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','334',4669,'7','1',65005.69,65005.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','334',4670,'8','1',573556.15,573556.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','334',4671,'9','1',378082.87,378082.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','334',4672,'10','1',483451.39,483451.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','334',4673,'11','1',366683.18,366683.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','334',4674,'12','1',466046.08,466046.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','334',4675,'13','2',270947.12,273996.45,3049.33,2591930.50,0.00,0.00,0.00,0.00,0.00),('1','281','3','334',4676,'14','2',64449.55,65775.00,1325.45,1126632.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','335',4677,'1','1',395776.73,395776.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','335',4678,'2','1',557417.14,557417.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','335',4679,'3','1',275430.33,275430.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','335',4680,'4','1',438634.68,438634.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','335',4681,'5','1',404293.98,404293.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','335',4682,'6','1',551725.83,551725.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','335',4683,'7','1',65005.69,65005.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','335',4684,'8','1',573556.15,573556.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','335',4685,'9','1',378082.87,378082.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','335',4686,'10','1',483451.39,483451.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','335',4687,'11','1',366683.18,366683.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','335',4688,'12','1',466046.08,466046.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','335',4689,'13','2',273996.45,277840.85,3844.40,3267740.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','335',4690,'14','2',65775.00,66567.65,792.65,673752.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','336',4691,'1','1',395776.73,397723.99,1934.35,425557.00,0.00,0.00,12.91,0.00,0.00),('1','281','1','336',4692,'2','1',557417.14,560158.10,2728.05,600171.00,0.00,0.00,12.91,0.00,0.00),('1','281','1','336',4693,'3','1',275430.33,275430.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','336',4694,'4','1',438634.68,438634.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','336',4695,'5','1',404293.98,409485.33,5178.44,1139256.80,0.00,0.00,12.91,0.00,0.00),('1','281','1','336',4696,'6','1',551725.83,553701.23,1962.49,431747.80,0.00,0.00,12.91,0.00,0.00),('1','281','2','336',4697,'7','1',65005.69,65005.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','336',4698,'8','1',573556.15,573556.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','336',4699,'9','1',378082.87,379999.71,1903.93,418864.60,0.00,0.00,12.91,0.00,0.00),('1','281','2','336',4700,'10','1',483451.39,485389.81,1925.51,423612.20,0.00,0.00,12.91,0.00,0.00),('1','281','2','336',4701,'11','1',366683.18,366683.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','336',4702,'12','1',466046.08,466046.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','336',4703,'13','2',277840.85,277840.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','336',4704,'14','2',66567.65,66567.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','337',4705,'1','1',397723.99,397723.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','337',4706,'2','1',560158.10,560443.11,285.01,57002.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','337',4707,'3','1',275430.33,275430.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','337',4708,'4','1',438634.68,438634.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','337',4709,'5','1',409485.33,409485.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','337',4710,'6','1',553701.23,553701.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','337',4711,'7','1',65005.69,65005.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','337',4712,'8','1',573556.15,573556.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','337',4713,'9','1',379999.71,379999.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','337',4714,'10','1',485389.81,485389.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','337',4715,'11','1',366683.18,366683.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','337',4716,'12','1',466046.08,466046.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','337',4717,'13','2',277840.85,277840.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','337',4718,'14','2',66567.65,66567.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','338',4719,'1','1',397723.99,397723.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','338',4720,'2','1',560443.11,561117.32,669.21,133842.00,0.00,0.00,5.00,0.00,0.00),('1','281','1','338',4721,'3','1',275430.33,278799.40,3369.07,673814.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','338',4722,'4','1',438634.68,441763.29,3128.61,625722.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','338',4723,'5','1',409485.33,409485.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','338',4724,'6','1',553701.23,553701.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','338',4725,'7','1',65005.69,67886.57,2880.88,576176.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','338',4726,'8','1',573556.15,576668.50,3112.35,622470.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','338',4727,'9','1',379999.71,379999.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','338',4728,'10','1',485389.81,485389.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','338',4729,'11','1',366683.18,369088.28,2405.10,481020.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','338',4730,'12','1',466046.08,473335.06,7288.98,1457796.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','338',4731,'13','2',277840.85,278669.48,828.63,704335.50,0.00,0.00,0.00,0.00,0.00),('1','281','3','338',4732,'14','2',66567.65,66567.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','339',4733,'1','1',397723.99,397723.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','339',4734,'2','1',561117.32,561117.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','339',4735,'3','1',278799.40,278799.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','339',4736,'4','1',441763.29,441763.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','339',4737,'5','1',409485.33,409532.93,46.52,9304.00,0.00,0.00,1.08,0.00,0.00),('1','281','1','339',4738,'6','1',553701.23,553817.43,102.17,20434.00,0.00,0.00,14.03,0.00,0.00),('1','281','2','339',4739,'7','1',67886.57,67886.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','339',4740,'8','1',576668.50,576668.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','339',4741,'9','1',379999.71,379999.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','339',4742,'10','1',485389.81,485389.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','339',4743,'11','1',369088.28,369088.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','339',4744,'12','1',473335.06,473335.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','339',4745,'13','2',278669.48,281377.69,2708.21,2301978.50,0.00,0.00,0.00,0.00,0.00),('1','281','3','339',4746,'14','2',66567.65,67782.77,1215.12,1032852.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','340',4747,'1','1',397723.99,397723.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','340',4748,'2','1',561117.32,561217.32,100.00,20000.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','340',4749,'3','1',278799.40,278799.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','340',4750,'4','1',441763.29,441763.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','340',4751,'5','1',409532.93,409532.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','340',4752,'6','1',553817.43,553817.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','340',4753,'7','1',67886.57,67886.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','340',4754,'8','1',576668.50,576668.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','340',4755,'9','1',379999.71,379999.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','340',4756,'10','1',485389.81,485389.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','340',4757,'11','1',369088.28,369088.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','340',4758,'12','1',473335.06,473335.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','340',4759,'13','2',281377.69,282829.81,1452.12,1234302.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','340',4760,'14','2',67782.77,67933.59,150.82,128197.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','341',4761,'1','1',397723.99,397723.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','341',4762,'2','1',561217.32,561217.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','341',4763,'3','1',278799.40,278799.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','341',4764,'4','1',441763.29,441763.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','341',4765,'5','1',409532.93,409532.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','341',4766,'6','1',553817.43,553817.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','341',4767,'7','1',67886.57,67886.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','341',4768,'8','1',576668.50,576668.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','341',4769,'9','1',379999.71,379999.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','341',4770,'10','1',485389.81,485389.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','341',4771,'11','1',369088.28,369088.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','341',4772,'12','1',473335.06,473335.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','341',4773,'13','2',282829.81,283955.63,1125.82,956947.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','341',4774,'14','2',67933.59,67965.58,31.99,27191.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','342',4775,'1','1',397723.99,397723.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','342',4776,'2','1',561217.32,561217.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','342',4777,'3','1',278799.40,278799.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','342',4778,'4','1',441763.29,441763.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','342',4779,'5','1',409532.93,409532.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','342',4780,'6','1',553817.43,553817.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','342',4781,'7','1',67886.57,67886.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','342',4782,'8','1',576668.50,576668.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','342',4783,'9','1',379999.71,379999.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','342',4784,'10','1',485389.81,485389.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','342',4785,'11','1',369088.28,369088.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','342',4786,'12','1',473335.06,473335.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','342',4787,'13','2',283955.63,286036.85,2081.22,1769037.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','342',4788,'14','2',67965.58,69245.61,1280.03,1088025.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','343',4789,'1','1',397723.99,400036.72,2312.73,485673.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','343',4790,'2','1',561217.32,563789.69,2572.37,540197.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','343',4791,'3','1',278799.40,278799.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','343',4792,'4','1',441763.29,441763.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','343',4793,'5','1',409532.93,417071.22,7538.29,1583040.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','343',4794,'6','1',553817.43,556559.83,2742.40,575904.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','343',4795,'7','1',67886.57,67886.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','343',4796,'8','1',576668.50,576668.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','343',4797,'9','1',379999.71,382765.50,2765.79,580815.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','343',4798,'10','1',485389.81,488113.00,2723.19,571869.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','343',4799,'11','1',369088.28,369088.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','343',4800,'12','1',473335.06,473335.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','343',4801,'13','2',286036.85,287944.40,1907.55,1621417.50,0.00,0.00,0.00,0.00,0.00),('1','281','3','343',4802,'14','2',69245.61,69555.51,309.90,263415.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','344',4803,'1','1',400036.72,400036.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','344',4804,'2','1',563789.69,563789.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','344',4805,'3','1',278799.40,278799.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','344',4806,'4','1',441763.29,441763.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','344',4807,'5','1',417071.22,417071.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','344',4808,'6','1',556559.83,556559.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','344',4809,'7','1',67886.57,67886.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','344',4810,'8','1',576668.50,576668.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','344',4811,'9','1',382765.50,382765.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','344',4812,'10','1',488113.00,488113.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','344',4813,'11','1',369088.28,369088.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','344',4814,'12','1',473335.06,473335.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','344',4815,'13','2',287944.40,291211.72,3267.32,2777222.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','344',4816,'14','2',69555.51,69726.10,170.59,145001.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','345',4817,'1','1',400036.72,400036.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','345',4818,'2','1',563789.69,563789.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','345',4819,'3','1',278799.40,282693.18,3893.78,817693.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','345',4820,'4','1',441763.29,444847.79,3084.50,647745.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','345',4821,'5','1',417071.22,417071.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','345',4822,'6','1',556559.83,556559.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','345',4823,'7','1',67886.57,70570.17,2683.60,563556.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','345',4824,'8','1',576668.50,579265.21,2596.71,545309.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','345',4825,'9','1',382765.50,382765.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','345',4826,'10','1',488113.00,488113.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','345',4827,'11','1',369088.28,371732.75,2644.47,555338.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','345',4828,'12','1',473335.06,479099.12,5764.06,1210452.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','345',4829,'13','2',291211.72,291440.52,228.80,194480.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','345',4830,'14','2',69726.10,69726.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','346',4831,'1','1',400036.72,402801.09,2764.37,580517.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','346',4832,'2','1',563789.69,566391.56,2601.87,546392.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','346',4833,'3','1',282693.18,282693.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','346',4834,'4','1',444847.79,444847.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','346',4835,'5','1',417071.22,420282.61,3211.39,674391.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','346',4836,'6','1',556559.83,559687.70,3127.87,656852.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','346',4837,'7','1',70570.17,70570.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','346',4838,'8','1',579265.21,579265.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','346',4839,'9','1',382765.50,385266.65,2501.15,525241.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','346',4840,'10','1',488113.00,490877.36,2764.36,580515.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','346',4841,'11','1',371732.75,371732.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','346',4842,'12','1',479099.12,479099.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','346',4843,'13','2',291440.52,291738.08,297.56,252926.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','346',4844,'14','2',69726.10,69731.10,5.00,4250.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','347',4845,'1','1',402801.09,405181.96,2380.87,499982.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','347',4846,'2','1',566391.56,568971.19,2579.63,541722.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','347',4847,'3','1',282693.18,282693.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','347',4848,'4','1',444847.79,444847.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','347',4849,'5','1',420282.61,423248.97,2966.36,622935.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','347',4850,'6','1',559687.70,562137.93,2450.23,514548.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','347',4851,'7','1',70570.17,70570.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','347',4852,'8','1',579265.21,579265.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','347',4853,'9','1',385266.65,387461.11,2194.46,460836.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','347',4854,'10','1',490877.36,493517.64,2640.28,554458.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','347',4855,'11','1',371732.75,371732.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','347',4856,'12','1',479099.12,479099.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','347',4857,'13','2',291738.08,294652.03,2913.95,2476857.50,0.00,0.00,0.00,0.00,0.00),('1','281','3','347',4858,'14','2',69731.10,70516.58,785.48,667658.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','348',4859,'1','1',405181.96,410035.15,4853.19,1019169.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','348',4860,'2','1',568971.19,573240.96,4269.77,896651.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','348',4861,'3','1',282693.18,282693.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','348',4862,'4','1',444847.79,444847.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','348',4863,'5','1',423248.97,427579.43,4330.46,909396.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','348',4864,'6','1',562137.93,566677.74,4539.81,953360.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','348',4865,'7','1',70570.17,70570.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','348',4866,'8','1',579265.21,579265.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','348',4867,'9','1',387461.11,392358.73,4897.62,1028500.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','348',4868,'10','1',493517.64,498502.45,4984.81,1046810.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','348',4869,'11','1',371732.75,371732.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','348',4870,'12','1',479099.12,479099.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','348',4871,'13','2',294652.03,296044.91,1392.88,1183948.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','348',4872,'14','2',70516.58,72328.03,1811.45,1539732.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','349',4873,'1','1',410035.15,410035.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','349',4874,'2','1',573240.96,573240.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','349',4875,'3','1',282693.18,288129.08,5435.90,1141539.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','349',4876,'4','1',444847.79,450329.74,5481.95,1151209.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','349',4877,'5','1',427579.43,428335.86,756.43,158850.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','349',4878,'6','1',566677.74,567671.69,993.95,208729.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','349',4879,'7','1',70570.17,75183.65,4613.48,968830.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','349',4880,'8','1',579265.21,583438.55,4173.34,876401.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','349',4881,'9','1',392358.73,392358.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','349',4882,'10','1',498502.45,498502.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','349',4883,'11','1',371732.75,376509.44,4776.69,1003104.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','349',4884,'12','1',479099.12,484688.91,5589.79,1173855.90,0.00,0.00,0.00,0.00,0.00),('1','281','3','349',4885,'13','2',296044.91,296930.91,886.00,753100.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','349',4886,'14','2',72328.03,72424.20,96.17,81744.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','350',4887,'1','1',410035.15,410035.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','350',4888,'2','1',573240.96,573240.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','350',4889,'3','1',288129.08,293417.56,5288.48,1110580.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','350',4890,'4','1',450329.74,455956.57,5626.83,1181634.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','350',4891,'5','1',428335.86,428436.84,100.98,21205.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','350',4892,'6','1',567671.69,567671.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','350',4893,'7','1',75183.65,80693.64,5509.99,1157097.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','350',4894,'8','1',583438.55,587880.03,4441.48,932710.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','350',4895,'9','1',392358.73,392358.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','350',4896,'10','1',498502.45,498502.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','350',4897,'11','1',376509.44,382038.16,5528.72,1161031.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','350',4898,'12','1',484688.91,491501.92,6813.01,1430732.10,0.00,0.00,0.00,0.00,0.00),('1','281','3','350',4899,'13','2',296930.91,297346.85,415.94,353549.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','350',4900,'14','2',72424.20,72782.37,358.17,304444.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','351',4901,'1','1',410035.15,410035.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','351',4902,'2','1',573240.96,573240.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','351',4903,'3','1',293417.56,299098.59,5681.03,1193016.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','351',4904,'4','1',455956.57,461294.60,5338.03,1120986.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','351',4905,'5','1',428436.84,428436.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','351',4906,'6','1',567671.69,567671.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','351',4907,'7','1',80693.64,86443.66,5750.02,1207504.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','351',4908,'8','1',587880.03,592447.52,4567.49,959172.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','351',4909,'9','1',392358.73,392358.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','351',4910,'10','1',498502.45,498502.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','351',4911,'11','1',382038.16,387384.61,5346.45,1122754.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','351',4912,'12','1',491501.92,496897.00,5395.08,1132966.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','351',4913,'13','2',297346.85,299302.93,1956.08,1662668.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','351',4914,'14','2',72782.37,73794.62,1012.25,860412.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','352',4915,'1','1',410035.15,410035.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','352',4916,'2','1',573240.96,573240.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','352',4917,'3','1',299098.59,301892.84,2794.25,586792.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','352',4918,'4','1',461294.60,464166.36,2871.76,603069.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','352',4919,'5','1',428436.84,428436.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','352',4920,'6','1',567671.69,567770.75,99.06,20802.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','352',4921,'7','1',86443.66,89219.64,2775.98,582955.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','352',4922,'8','1',592447.52,595409.46,2961.94,622007.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','352',4923,'9','1',392358.73,392358.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','352',4924,'10','1',498502.45,498502.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','352',4925,'11','1',387384.61,389966.45,2581.84,542186.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','352',4926,'12','1',496897.00,499505.83,2608.83,547854.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','352',4927,'13','2',299302.93,299453.92,150.99,128341.50,0.00,0.00,0.00,0.00,0.00),('1','281','3','352',4928,'14','2',73794.62,73834.26,39.64,33694.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','353',4929,'1','1',410035.15,412858.02,2822.87,592802.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','353',4930,'2','1',573240.96,575567.35,2326.39,488541.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','353',4931,'3','1',301892.84,301892.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','353',4932,'4','1',464166.36,464166.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','353',4933,'5','1',428436.84,431802.50,3365.66,706788.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','353',4934,'6','1',567770.75,570796.67,3025.92,635443.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','353',4935,'7','1',89219.64,89219.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','353',4936,'8','1',595409.46,595409.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','353',4937,'9','1',392358.73,395413.52,3054.79,641505.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','353',4938,'10','1',498502.45,500874.65,2372.20,498162.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','353',4939,'11','1',389966.45,389966.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','353',4940,'12','1',499505.83,499505.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','353',4941,'13','2',299453.92,301656.30,2202.38,1872023.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','353',4942,'14','2',73834.26,74210.55,376.29,319846.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','354',4943,'1','1',412858.02,418207.49,5349.47,1123388.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','354',4944,'2','1',575567.35,580460.94,4893.59,1027653.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','354',4945,'3','1',301892.84,304249.85,2357.01,494972.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','354',4946,'4','1',464166.36,466754.63,2588.27,543536.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','354',4947,'5','1',431802.50,435612.21,3809.71,800039.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','354',4948,'6','1',570796.67,576513.79,5717.12,1200595.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','354',4949,'7','1',89219.64,93313.47,4093.83,859704.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','354',4950,'8','1',595409.46,598011.19,2601.73,546363.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','354',4951,'9','1',395413.52,401176.67,5763.15,1210261.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','354',4952,'10','1',500874.65,504782.80,3908.15,820711.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','354',4953,'11','1',389966.45,393683.37,3716.92,780553.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','354',4954,'12','1',499505.83,503961.89,4456.06,935772.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','354',4955,'13','2',301656.30,303515.27,1858.97,1580124.50,0.00,0.00,0.00,0.00,0.00),('1','281','3','354',4956,'14','2',74210.55,74215.26,4.71,4003.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','355',4957,'1','1',418207.49,419964.05,1756.56,368877.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','355',4958,'2','1',580460.94,582845.79,2384.85,500818.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','355',4959,'3','1',304249.85,308307.09,4057.24,852020.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','355',4960,'4','1',466754.63,471145.43,4390.80,922068.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','355',4961,'5','1',435612.21,436947.21,1335.00,280350.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','355',4962,'6','1',576513.79,578244.72,1730.93,363495.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','355',4963,'7','1',93313.47,98566.53,5253.06,1103142.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','355',4964,'8','1',598011.19,601000.45,2989.26,627744.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','355',4965,'9','1',401176.67,402951.20,1774.53,372651.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','355',4966,'10','1',504782.80,506055.93,1273.13,267357.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','355',4967,'11','1',393683.37,398719.41,5036.04,1057568.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','355',4968,'12','1',503961.89,511420.99,7459.10,1566411.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','355',4969,'13','2',303515.27,304568.21,1052.94,894999.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','355',4970,'14','2',74215.26,74277.83,62.57,53184.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','356',4971,'1','1',419964.05,425734.72,5770.67,1211840.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','356',4972,'2','1',582845.79,588288.62,5442.83,1142994.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','356',4973,'3','1',308307.09,310585.59,2278.50,478485.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','356',4974,'4','1',471145.43,473529.67,2384.24,500690.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','356',4975,'5','1',436947.21,442420.28,5473.07,1149344.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','356',4976,'6','1',578244.72,583398.50,5153.78,1082293.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','356',4977,'7','1',98566.53,101781.86,3215.33,675219.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','356',4978,'8','1',601000.45,604738.89,3738.44,785072.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','356',4979,'9','1',402951.20,409046.20,6095.00,1279950.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','356',4980,'10','1',506055.93,511035.28,4979.35,1045663.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','356',4981,'11','1',398719.41,401461.63,2742.22,575866.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','356',4982,'12','1',511420.99,514503.70,3082.71,647369.10,0.00,0.00,0.00,0.00,0.00),('1','281','3','356',4983,'13','2',304568.21,306313.17,1744.96,1483216.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','356',4984,'14','2',74277.83,76256.36,1978.53,1681750.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','357',4985,'1','1',425734.72,425734.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','357',4986,'2','1',588288.62,588288.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','357',4987,'3','1',310585.59,310585.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','357',4988,'4','1',473529.67,473529.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','357',4989,'5','1',442420.28,442420.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','357',4990,'6','1',583398.50,583398.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','357',4991,'7','1',101781.86,101781.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','357',4992,'8','1',604738.89,604738.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','357',4993,'9','1',409046.20,409046.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','357',4994,'10','1',511035.28,511035.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','357',4995,'11','1',401461.63,401461.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','357',4996,'12','1',514503.70,514503.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','357',4997,'13','2',306313.17,306313.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','357',4998,'14','2',76256.36,76256.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','358',4999,'1','1',425734.72,431996.10,6261.38,1314889.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','358',5000,'2','1',588288.62,593344.61,5055.99,1061757.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','358',5001,'3','1',310585.59,313223.33,2637.74,553925.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','358',5002,'4','1',473529.67,475665.67,2136.00,448560.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','358',5003,'5','1',442420.28,448736.10,6315.82,1326322.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','358',5004,'6','1',583398.50,588297.18,4898.68,1028722.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','358',5005,'7','1',101781.86,105570.56,3788.70,795627.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','358',5006,'8','1',604738.89,608070.75,3331.86,699690.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','358',5007,'9','1',409046.20,415245.86,6199.66,1301928.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','358',5008,'10','1',511035.28,515565.41,4530.13,951327.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','358',5009,'11','1',401461.63,404152.71,2691.08,565126.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','358',5010,'12','1',514503.70,516137.98,1634.28,343198.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','358',5011,'13','2',306313.17,306739.88,426.71,354169.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','358',5012,'14','2',76256.36,76256.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','359',5013,'1','1',431996.10,431996.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','359',5014,'2','1',593344.61,593344.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','359',5015,'3','1',313223.33,313223.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','359',5016,'4','1',475665.67,475665.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','359',5017,'5','1',448736.10,448736.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','359',5018,'6','1',588297.18,588297.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','359',5019,'7','1',105570.56,105570.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','359',5020,'8','1',608070.75,608070.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','359',5021,'9','1',415245.86,415245.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','359',5022,'10','1',515565.41,515565.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','359',5023,'11','1',404152.71,404152.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','359',5024,'12','1',516137.98,516137.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','359',5025,'13','2',306739.88,306739.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','359',5026,'14','2',76256.36,76256.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','360',5027,'1','1',431996.10,431996.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','360',5028,'2','1',593344.61,593344.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','360',5029,'3','1',313223.33,313223.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','360',5030,'4','1',475665.67,475665.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','360',5031,'5','1',448736.10,448736.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','360',5032,'6','1',588297.18,588297.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','360',5033,'7','1',105570.56,105570.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','360',5034,'8','1',608070.75,608070.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','360',5035,'9','1',415245.86,415245.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','360',5036,'10','1',515565.41,515565.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','360',5037,'11','1',404152.71,404152.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','360',5038,'12','1',516137.98,516137.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','360',5039,'13','2',306739.88,307839.88,1100.00,913000.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','360',5040,'14','2',76256.36,76256.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','361',5041,'1','1',431996.10,431996.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','361',5042,'2','1',593344.61,593344.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','361',5043,'3','1',313223.33,313223.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','361',5044,'4','1',475665.67,475665.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','361',5045,'5','1',448736.10,448736.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','361',5046,'6','1',588297.18,588297.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','361',5047,'7','1',105570.56,105570.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','361',5048,'8','1',608070.75,608070.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','361',5049,'9','1',415245.86,415245.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','361',5050,'10','1',515565.41,515565.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','361',5051,'11','1',404152.71,404152.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','361',5052,'12','1',516137.98,516137.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','361',5053,'13','2',307839.88,307839.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','361',5054,'14','2',76256.36,76256.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','362',5055,'1','1',431996.10,435391.99,3395.89,713136.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','362',5056,'2','1',593344.61,598963.25,5618.64,1179914.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','362',5057,'3','1',313223.33,316028.90,2805.57,589169.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','362',5058,'4','1',475665.67,478304.62,2638.95,554179.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','362',5059,'5','1',448736.10,454735.76,5999.66,1259928.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','362',5060,'6','1',588297.18,591697.08,3399.90,713979.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','362',5061,'7','1',105570.56,109330.71,3760.15,789631.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','362',5062,'8','1',608070.75,611840.62,3769.87,791672.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','362',5063,'9','1',415245.86,417643.97,2398.11,503603.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','362',5064,'10','1',515565.41,520009.55,4444.14,933269.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','362',5065,'11','1',404152.71,407620.78,3468.07,728294.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','362',5066,'12','1',516137.98,519498.63,3360.65,705736.50,0.00,0.00,0.00,0.00,0.00),('1','281','3','362',5067,'13','2',307839.88,308650.67,810.79,672955.70,0.00,0.00,0.00,0.00,0.00),('1','281','3','362',5068,'14','2',76256.36,76265.99,9.63,7992.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','363',5069,'1','1',435391.99,437819.58,2427.59,509793.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','363',5070,'2','1',598963.25,601441.07,2477.82,520342.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','363',5071,'3','1',316028.90,316028.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','363',5072,'4','1',478304.62,478304.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','363',5073,'5','1',454735.76,457606.13,2870.37,602777.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','363',5074,'6','1',591697.08,594714.01,3016.93,633555.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','363',5075,'7','1',109330.71,109330.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','363',5076,'8','1',611840.62,611840.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','363',5077,'9','1',417643.97,420576.99,2933.02,615934.20,0.00,0.00,0.00,0.00,0.00),('1','281','2','363',5078,'10','1',520009.55,521408.29,1398.74,293735.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','363',5079,'11','1',407620.78,407620.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','363',5080,'12','1',519498.63,519498.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','363',5081,'13','2',308650.67,310155.36,1504.69,1248892.70,0.00,0.00,0.00,0.00,0.00),('1','281','3','363',5082,'14','2',76265.99,76265.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','364',5083,'1','1',437819.58,440244.56,2424.98,509245.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','364',5084,'2','1',601441.07,604443.63,3002.56,630537.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','364',5085,'3','1',316028.90,320898.67,4869.77,1022651.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','364',5086,'4','1',478304.62,482551.05,4246.43,891750.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','364',5087,'5','1',457606.13,460086.79,2480.66,520938.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','364',5088,'6','1',594714.01,597112.69,2398.68,503722.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','364',5089,'7','1',109330.71,114506.28,5175.57,1086869.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','364',5090,'8','1',611840.62,616719.33,4878.71,1024529.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','364',5091,'9','1',420576.99,423112.89,2535.90,532539.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','364',5092,'10','1',521408.29,523101.87,1693.58,355651.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','364',5093,'11','1',407620.78,412553.43,4932.65,1035856.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','364',5094,'12','1',519498.63,524052.63,4554.00,956340.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','364',5095,'13','2',310155.36,310811.84,656.48,544878.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','364',5096,'14','2',76265.99,76301.41,35.42,29398.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','365',5097,'1','1',440244.56,440794.90,550.34,115571.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','365',5098,'2','1',604443.63,604949.59,505.96,106251.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','365',5099,'3','1',320898.67,321499.29,600.62,126130.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','365',5100,'4','1',482551.05,483235.87,684.82,143812.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','365',5101,'5','1',460086.79,460421.32,334.53,70251.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','365',5102,'6','1',597112.69,597608.13,495.44,104042.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','365',5103,'7','1',114506.28,115321.69,815.41,171236.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','365',5104,'8','1',616719.33,617345.56,626.23,131508.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','365',5105,'9','1',423112.89,423535.14,422.25,88672.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','365',5106,'10','1',523101.87,523401.27,299.40,62874.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','365',5107,'11','1',412553.43,413193.97,640.54,134513.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','365',5108,'12','1',524052.63,524751.82,699.19,146829.90,0.00,0.00,0.00,0.00,0.00),('1','281','3','365',5109,'13','2',310811.84,311391.30,579.46,480951.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','365',5110,'14','2',76301.41,78301.41,2000.00,1660000.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','366',5111,'1','1',440794.90,440794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','366',5112,'2','1',604949.59,604949.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','366',5113,'3','1',321499.29,325935.81,4436.52,931669.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','366',5114,'4','1',483235.87,487694.18,4458.31,936245.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','366',5115,'5','1',460421.32,460421.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','366',5116,'6','1',597608.13,597608.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','366',5117,'7','1',115321.69,120417.89,5096.20,1070202.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','366',5118,'8','1',617345.56,621806.89,4461.33,936879.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','366',5119,'9','1',423535.14,423535.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','366',5120,'10','1',523401.27,523401.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','366',5121,'11','1',413193.97,418085.71,4891.74,1027265.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','366',5122,'12','1',524751.82,534466.11,9714.29,2040000.90,0.00,0.00,0.00,0.00,0.00),('1','281','3','366',5123,'13','2',311391.30,311626.89,235.59,195539.70,0.00,0.00,0.00,0.00,0.00),('1','281','3','366',5124,'14','2',78301.41,78301.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','367',5125,'1','1',440794.90,440794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','367',5126,'2','1',604949.59,604949.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','367',5127,'3','1',325935.81,325935.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','367',5128,'4','1',487694.18,487694.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','367',5129,'5','1',460421.32,460421.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','367',5130,'6','1',597608.13,597608.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','367',5131,'7','1',120417.89,120417.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','367',5132,'8','1',621806.89,621806.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','367',5133,'9','1',423535.14,423535.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','367',5134,'10','1',523401.27,523401.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','367',5135,'11','1',418085.71,418085.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','367',5136,'12','1',534466.11,534466.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','367',5137,'13','2',311626.89,312740.58,1113.69,924362.70,0.00,0.00,0.00,0.00,0.00),('1','281','3','367',5138,'14','2',78301.41,78301.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','368',5139,'1','1',440794.90,440794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','368',5140,'2','1',604949.59,604949.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','368',5141,'3','1',325935.81,325935.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','368',5142,'4','1',487694.18,487694.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','368',5143,'5','1',460421.32,460421.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','368',5144,'6','1',597608.13,597608.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','368',5145,'7','1',120417.89,120417.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','368',5146,'8','1',621806.89,621806.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','368',5147,'9','1',423535.14,423535.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','368',5148,'10','1',523401.27,523401.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','368',5149,'11','1',418085.71,418085.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','368',5150,'12','1',534466.11,534466.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','368',5151,'13','2',312740.58,314294.45,1553.87,1289712.10,0.00,0.00,0.00,0.00,0.00),('1','281','3','368',5152,'14','2',78301.41,78494.46,193.05,160231.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','369',5153,'1','1',440794.90,440794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','369',5154,'2','1',604949.59,604949.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','369',5155,'3','1',325935.81,325935.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','369',5156,'4','1',487694.18,487694.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','369',5157,'5','1',460421.32,460421.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','369',5158,'6','1',597608.13,597608.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','369',5159,'7','1',120417.89,120417.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','369',5160,'8','1',621806.89,621806.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','369',5161,'9','1',423535.14,423535.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','369',5162,'10','1',523401.27,523401.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','369',5163,'11','1',418085.71,418085.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','369',5164,'12','1',534466.11,534466.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','369',5165,'13','2',314294.45,314488.89,194.44,161385.20,0.00,0.00,0.00,0.00,0.00),('1','281','3','369',5166,'14','2',78494.46,78613.06,118.60,98438.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','370',5167,'1','1',440794.90,440794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','370',5168,'2','1',604949.59,604949.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','370',5169,'3','1',325935.81,325935.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','370',5170,'4','1',487694.18,487694.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','370',5171,'5','1',460421.32,460421.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','370',5172,'6','1',597608.13,597608.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','370',5173,'7','1',120417.89,120417.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','370',5174,'8','1',621806.89,621806.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','370',5175,'9','1',423535.14,423535.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','370',5176,'10','1',523401.27,523401.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','370',5177,'11','1',418085.71,418085.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','370',5178,'12','1',534466.11,534466.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','370',5179,'13','2',314488.89,315453.68,964.79,800775.70,0.00,0.00,0.00,0.00,0.00),('1','281','3','370',5180,'14','2',78613.06,80097.49,1484.43,1232076.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','371',5181,'1','1',440794.90,442610.51,1815.61,381278.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','371',5182,'2','1',604949.59,606763.80,1814.21,380984.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','371',5183,'3','1',325935.81,330214.09,4278.28,898438.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','371',5184,'4','1',487694.18,492228.69,4534.51,952247.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','371',5185,'5','1',460421.32,466677.37,6256.05,1313770.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','371',5186,'6','1',597608.13,599218.54,1610.41,338186.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','371',5187,'7','1',120417.89,124712.20,4294.31,901805.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','371',5188,'8','1',621806.89,626116.49,4309.60,905016.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','371',5189,'9','1',423535.14,425458.07,1922.93,403815.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','371',5190,'10','1',523401.27,524918.58,1517.31,318635.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','371',5191,'11','1',418085.71,422215.77,4130.06,867312.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','371',5192,'12','1',534466.11,542297.94,7831.83,1644684.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','371',5193,'13','2',315453.68,316734.88,1281.20,1063396.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','371',5194,'14','2',80097.49,80106.34,8.85,7345.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','372',5195,'1','1',442610.51,442610.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','372',5196,'2','1',606763.80,606763.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','372',5197,'3','1',330214.09,330214.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','372',5198,'4','1',492228.69,492495.55,266.86,56040.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','372',5199,'5','1',466677.37,466677.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','372',5200,'6','1',599218.54,599218.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','372',5201,'7','1',124712.20,124712.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','372',5202,'8','1',626116.49,626116.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','372',5203,'9','1',425458.07,425458.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','372',5204,'10','1',524918.58,524918.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','372',5205,'11','1',422215.77,422215.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','372',5206,'12','1',542297.94,542297.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','372',5207,'13','2',316734.88,317875.35,1140.47,946590.10,0.00,0.00,0.00,0.00,0.00),('1','281','3','372',5208,'14','2',80106.34,80106.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','373',5209,'1','1',442610.51,445271.10,2660.59,558723.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','373',5210,'2','1',606763.80,609236.20,2472.40,519204.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','373',5211,'3','1',330214.09,330611.09,397.00,83370.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','373',5212,'4','1',492495.55,493140.31,644.76,135399.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','373',5213,'5','1',466677.37,468938.26,2260.89,474786.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','373',5214,'6','1',599218.54,602277.40,3058.86,642360.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','373',5215,'7','1',124712.20,124712.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','373',5216,'8','1',626116.49,626116.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','373',5217,'9','1',425458.07,428312.83,2854.76,599499.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','373',5218,'10','1',524918.58,527406.42,2487.84,522446.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','373',5219,'11','1',422215.77,422215.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','373',5220,'12','1',542297.94,542297.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','373',5221,'13','2',317875.35,321281.90,3406.55,2827436.50,0.00,0.00,0.00,0.00,0.00),('1','281','3','373',5222,'14','2',80106.34,80216.36,110.02,91316.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','374',5223,'1','1',445271.10,445271.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','374',5224,'2','1',609236.20,609236.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','374',5225,'3','1',330611.09,330611.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','374',5226,'4','1',493140.31,493140.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','374',5227,'5','1',468938.26,468938.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','374',5228,'6','1',602277.40,602277.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','374',5229,'7','1',124712.20,124712.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','374',5230,'8','1',626116.49,626116.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','374',5231,'9','1',428312.83,428312.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','374',5232,'10','1',527406.42,527406.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','374',5233,'11','1',422215.77,422215.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','374',5234,'12','1',542297.94,542297.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','374',5235,'13','2',321281.90,321281.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','374',5236,'14','2',80216.36,80216.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','375',5237,'1','1',445271.10,445271.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','375',5238,'2','1',609236.20,609236.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','375',5239,'3','1',330611.09,336727.44,6116.35,1284433.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','375',5240,'4','1',493140.31,500163.19,7022.88,1474804.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','375',5241,'5','1',468938.26,468938.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','375',5242,'6','1',602277.40,602277.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','375',5243,'7','1',124712.20,131260.50,6548.30,1375143.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','375',5244,'8','1',626116.49,632200.87,6084.38,1277719.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','375',5245,'9','1',428312.83,428312.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','375',5246,'10','1',527406.42,527406.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','375',5247,'11','1',422215.77,428357.84,6142.07,1289834.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','375',5248,'12','1',542297.94,549035.17,6737.23,1414818.30,0.00,0.00,0.00,0.00,0.00),('1','281','3','375',5249,'13','2',321281.90,321523.63,241.73,200635.90,0.00,0.00,0.00,0.00,0.00),('1','281','3','375',5250,'14','2',80216.36,80216.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','376',5251,'1','1',445271.10,450807.00,5535.90,1162539.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','376',5252,'2','1',609236.20,614479.81,5243.61,1101158.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','376',5253,'3','1',336727.44,336727.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','376',5254,'4','1',500163.19,500163.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','376',5255,'5','1',468938.26,475106.84,6168.58,1295401.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','376',5256,'6','1',602277.40,607550.77,5273.37,1107407.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','376',5257,'7','1',131260.50,131260.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','376',5258,'8','1',632200.87,632200.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','376',5259,'9','1',428312.83,433552.12,5239.29,1100250.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','376',5260,'10','1',527406.42,533052.23,5645.81,1185620.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','376',5261,'11','1',428357.84,428357.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','376',5262,'12','1',549035.17,549495.76,460.59,96723.90,0.00,0.00,0.00,0.00,0.00),('1','281','3','376',5263,'13','2',321523.63,322127.91,604.28,501552.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','376',5264,'14','2',80216.36,81136.34,919.98,763583.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','377',5265,'1','1',450807.00,450807.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','377',5266,'2','1',614479.81,614479.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','377',5267,'3','1',336727.44,340834.01,4106.57,862379.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','377',5268,'4','1',500163.19,504554.02,4390.83,922074.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','377',5269,'5','1',475106.84,475106.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','377',5270,'6','1',607550.77,607550.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','377',5271,'7','1',131260.50,135416.04,4155.54,872663.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','377',5272,'8','1',632200.87,635857.83,3656.96,767961.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','377',5273,'9','1',433552.12,433552.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','377',5274,'10','1',533052.23,533052.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','377',5275,'11','1',428357.84,432915.91,4558.07,957194.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','377',5276,'12','1',549495.76,553805.87,4310.11,905123.10,0.00,0.00,0.00,0.00,0.00),('1','281','3','377',5277,'13','2',322127.91,322760.74,632.83,525248.90,0.00,0.00,0.00,0.00,0.00),('1','281','3','377',5278,'14','2',81136.34,81136.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','378',5279,'1','1',450807.00,450807.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','378',5280,'2','1',614479.81,614479.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','378',5281,'3','1',340834.01,340834.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','378',5282,'4','1',504554.02,504554.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','378',5283,'5','1',475106.84,475106.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','378',5284,'6','1',607550.77,607550.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','378',5285,'7','1',135416.04,135416.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','378',5286,'8','1',635857.83,635857.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','378',5287,'9','1',433552.12,433552.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','378',5288,'10','1',533052.23,533052.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','378',5289,'11','1',432915.91,432915.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','378',5290,'12','1',553805.87,553805.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','378',5291,'13','2',322760.74,323491.43,730.69,599165.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','378',5292,'14','2',81136.34,81149.77,13.43,11012.60,0.00,0.00,0.00,0.00,0.00),('1','281','1','379',5293,'1','1',450807.00,455462.10,4655.10,977571.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','379',5294,'2','1',614479.81,619093.26,4613.45,968824.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','379',5295,'3','1',340834.01,341197.90,363.89,76416.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','379',5296,'4','1',504554.02,505056.69,502.67,105560.70,0.00,0.00,0.00,0.00,0.00),('1','281','1','379',5297,'5','1',475106.84,480803.79,5696.95,1196359.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','379',5298,'6','1',607550.77,612571.70,5020.93,1054395.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','379',5299,'7','1',135416.04,135416.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','379',5300,'8','1',635857.83,635857.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','379',5301,'9','1',433552.12,438730.57,5178.45,1087474.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','379',5302,'10','1',533052.23,537900.30,4848.07,1018094.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','379',5303,'11','1',432915.91,432915.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','379',5304,'12','1',553805.87,553805.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','379',5305,'13','2',323491.43,324828.24,1336.81,1096184.20,0.00,0.00,0.00,0.00,0.00),('1','281','3','379',5306,'14','2',81149.77,81471.81,322.04,264072.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','380',5307,'1','1',455462.10,455462.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','380',5308,'2','1',619093.26,619093.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','380',5309,'3','1',341197.90,343692.50,2494.60,523866.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','380',5310,'4','1',505056.69,507727.43,2670.74,560855.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','380',5311,'5','1',480803.79,480803.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','380',5312,'6','1',612571.70,612571.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','380',5313,'7','1',135416.04,137871.48,2455.44,515642.40,0.00,0.00,0.00,0.00,0.00),('1','281','2','380',5314,'8','1',635857.83,637959.70,2101.87,441392.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','380',5315,'9','1',438730.57,438730.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','380',5316,'10','1',537900.30,537900.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','380',5317,'11','1',432915.91,435338.87,2422.96,508821.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','380',5318,'12','1',553805.87,556474.78,2668.91,560471.10,0.00,0.00,0.00,0.00,0.00),('1','281','3','380',5319,'13','2',324828.24,325475.03,646.79,530367.80,0.00,0.00,0.00,0.00,0.00),('1','281','3','380',5320,'14','2',81471.81,81755.61,283.80,232716.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','381',5321,'1','1',455462.10,455462.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','381',5322,'2','1',619093.26,619093.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','381',5323,'3','1',343692.50,349025.90,5333.40,1120014.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','381',5324,'4','1',507727.43,513963.75,6236.32,1309627.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','381',5325,'5','1',480803.79,480803.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','381',5326,'6','1',612571.70,612571.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','381',5327,'7','1',137871.48,143683.84,5812.36,1220595.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','381',5328,'8','1',637959.70,643345.83,5386.13,1131087.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','381',5329,'9','1',438730.57,438730.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','381',5330,'10','1',537900.30,537900.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','381',5331,'11','1',435338.87,441330.67,5991.80,1258278.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','381',5332,'12','1',556474.78,567117.94,10643.16,2235063.60,0.00,0.00,0.00,0.00,0.00),('1','281','3','381',5333,'13','2',325475.03,325977.19,502.16,411771.20,0.00,0.00,0.00,0.00,0.00),('1','281','3','381',5334,'14','2',81755.61,82385.46,629.85,516477.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','382',5335,'1','1',455462.10,455462.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','382',5336,'2','1',619093.26,619093.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','382',5337,'3','1',349025.90,349025.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','382',5338,'4','1',513963.75,513963.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','382',5339,'5','1',480803.79,480803.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','382',5340,'6','1',612571.70,612571.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','382',5341,'7','1',143683.84,143683.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','382',5342,'8','1',643345.83,643345.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','382',5343,'9','1',438730.57,438730.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','382',5344,'10','1',537900.30,537900.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','382',5345,'11','1',441330.67,441330.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','382',5346,'12','1',567117.94,567117.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','382',5347,'13','2',325977.19,325977.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','382',5348,'14','2',82385.46,82385.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','383',5349,'1','1',455462.10,458821.91,3359.81,705560.10,0.00,0.00,0.00,0.00,0.00),('1','281','1','383',5350,'2','1',619093.26,621864.05,2770.79,581865.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','383',5351,'3','1',349025.90,354861.74,5835.84,1225526.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','383',5352,'4','1',513963.75,519558.30,5594.55,1174855.50,0.00,0.00,0.00,0.00,0.00),('1','281','1','383',5353,'5','1',480803.79,483287.72,2483.93,521625.30,0.00,0.00,0.00,0.00,0.00),('1','281','1','383',5354,'6','1',612571.70,615352.18,2780.48,583900.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','383',5355,'7','1',143683.84,149722.15,6038.31,1268045.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','383',5356,'8','1',643345.83,648374.54,5028.71,1056029.10,0.00,0.00,0.00,0.00,0.00),('1','281','2','383',5357,'9','1',438730.57,441098.53,2367.96,497271.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','383',5358,'10','1',537900.30,540140.38,2240.08,470416.80,0.00,0.00,0.00,0.00,0.00),('1','281','2','383',5359,'11','1',441330.67,446882.83,5552.16,1165953.60,0.00,0.00,0.00,0.00,0.00),('1','281','2','383',5360,'12','1',567117.94,573013.16,5895.22,1237996.20,0.00,0.00,0.00,0.00,0.00),('1','281','3','383',5361,'13','2',325977.19,330138.66,4161.47,3412405.40,0.00,0.00,0.00,0.00,0.00),('1','281','3','383',5362,'14','2',82385.46,83395.60,1010.14,828314.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','384',5363,'1','1',458821.91,463076.99,4255.08,893566.80,0.00,0.00,0.00,0.00,0.00),('1','281','1','384',5364,'2','1',621864.05,626439.54,4575.49,960852.90,0.00,0.00,0.00,0.00,0.00),('1','281','1','384',5365,'3','1',354861.74,359262.78,4401.04,924218.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','384',5366,'4','1',519558.30,523770.64,4212.34,884591.40,0.00,0.00,0.00,0.00,0.00),('1','281','1','384',5367,'5','1',483287.72,486662.22,3374.50,708645.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','384',5368,'6','1',615352.18,618922.43,3570.25,749752.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','384',5369,'7','1',149722.15,154769.74,5047.59,1059993.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','384',5370,'8','1',648374.54,653371.31,4996.77,1049321.70,0.00,0.00,0.00,0.00,0.00),('1','281','2','384',5371,'9','1',441098.53,443999.46,2900.93,609195.30,0.00,0.00,0.00,0.00,0.00),('1','281','2','384',5372,'10','1',540140.38,543805.83,3665.45,769744.50,0.00,0.00,0.00,0.00,0.00),('1','281','2','384',5373,'11','1',446882.83,450540.32,3657.49,768072.90,0.00,0.00,0.00,0.00,0.00),('1','281','2','384',5374,'12','1',573013.16,576898.66,3885.50,815955.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','384',5375,'13','2',330138.66,335752.12,5613.46,4603037.20,0.00,0.00,0.00,0.00,0.00),('1','281','3','384',5376,'14','2',83395.60,83691.61,296.01,242728.20,0.00,0.00,0.00,0.00,0.00),('1','281','1','385',5377,'1','1',463076.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','385',5378,'2','1',626439.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','385',5379,'3','1',359262.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','385',5380,'4','1',523770.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','385',5381,'5','1',486662.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','1','385',5382,'6','1',618922.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','385',5383,'7','1',154769.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','385',5384,'8','1',653371.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','385',5385,'9','1',443999.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','385',5386,'10','1',543805.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','385',5387,'11','1',450540.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','2','385',5388,'12','1',576898.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','385',5389,'13','2',335752.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','281','3','385',5390,'14','2',83691.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=771 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','281','1','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,1),('1','281','1','1',185.00,185.00,29643.26,0.00,0.00,0.00,0.00,2),('1','281','2','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,3),('1','281','2','1',185.00,185.00,63319.04,0.00,0.00,0.00,0.00,4),('1','281','3','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,5),('1','281','3','1',185.00,185.00,49937.24,0.00,0.00,0.00,0.00,6),('1','281','4','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,7),('1','281','4','1',185.00,185.00,44888.62,0.00,0.00,0.00,0.00,8),('1','281','5','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,9),('1','281','5','1',185.00,185.00,45268.71,0.00,0.00,0.00,0.00,10),('1','281','6','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,11),('1','281','6','1',185.00,185.00,49427.32,0.00,0.00,0.00,0.00,12),('1','281','7','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,13),('1','281','7','1',185.00,185.00,47384.13,0.00,0.00,0.00,0.00,14),('1','281','8','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,15),('1','281','8','1',185.00,185.00,13277.49,0.00,0.00,0.00,0.00,16),('1','281','9','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,17),('1','281','9','1',185.00,185.00,49894.69,0.00,0.00,0.00,0.00,18),('1','281','10','2',810.00,810.00,360.67,0.00,0.00,0.00,0.00,19),('1','281','10','1',185.00,185.00,39153.66,0.00,0.00,0.00,0.00,20),('1','281','11','2',810.00,810.00,445.44,0.00,0.00,0.00,0.00,21),('1','281','11','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,22),('1','281','12','2',810.00,810.00,518.33,0.00,0.00,0.00,0.00,23),('1','281','12','1',185.00,185.00,45089.07,0.00,0.00,0.00,0.00,24),('1','281','13','2',810.00,810.00,722.52,0.00,0.00,0.00,0.00,25),('1','281','13','1',185.00,185.00,45035.24,0.00,0.00,0.00,0.00,26),('1','281','14','2',810.00,810.00,57.20,0.00,0.00,0.00,0.00,27),('1','281','14','1',185.00,185.00,30176.79,0.00,0.00,0.00,0.00,28),('1','281','15','2',810.00,810.00,292.09,0.00,0.00,0.00,0.00,29),('1','281','15','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,30),('1','281','16','2',810.00,810.00,353.14,0.00,0.00,0.00,0.00,31),('1','281','16','1',185.00,185.00,44916.34,0.00,0.00,0.00,0.00,32),('1','281','17','2',810.00,810.00,192.63,0.00,0.00,0.00,0.00,33),('1','281','17','1',185.00,185.00,24185.72,0.00,0.00,0.00,0.00,34),('1','281','18','2',810.00,810.00,0.00,0.00,0.00,0.00,0.00,35),('1','281','18','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,36),('1','281','19','2',800.00,800.00,2598.16,0.00,0.00,0.00,0.00,37),('1','281','19','1',185.00,185.00,44433.48,0.00,0.00,0.00,0.00,38),('1','281','20','2',800.00,800.00,553.39,0.00,0.00,0.00,0.00,39),('1','281','20','1',185.00,185.00,47468.76,0.00,0.00,0.00,0.00,40),('1','281','21','2',800.00,800.00,1004.99,0.00,0.00,0.00,0.00,41),('1','281','21','1',185.00,185.00,41541.54,0.00,0.00,0.00,0.00,42),('1','281','22','2',800.00,800.00,1200.52,0.00,0.00,0.00,0.00,43),('1','281','22','1',185.00,185.00,39838.25,0.00,0.00,0.00,0.00,44),('1','281','23','2',800.00,800.00,305.34,0.00,0.00,0.00,0.00,45),('1','281','23','1',185.00,185.00,23529.62,0.00,0.00,0.00,0.00,46),('1','281','24','2',800.00,800.00,458.85,0.00,0.00,0.00,0.00,47),('1','281','24','1',185.00,185.00,21549.60,0.00,0.00,0.00,0.00,48),('1','281','25','2',800.00,800.00,238.12,0.00,0.00,0.00,0.00,49),('1','281','25','1',185.00,185.00,24937.10,0.00,0.00,0.00,0.00,50),('1','281','26','2',800.00,800.00,1718.82,0.00,0.00,0.00,0.00,51),('1','281','26','1',185.00,185.00,15588.05,0.00,0.00,0.00,0.00,52),('1','281','27','2',800.00,800.00,106.52,0.00,0.00,0.00,0.00,53),('1','281','27','1',185.00,185.00,13056.18,0.00,0.00,0.00,0.00,54),('1','281','28','2',800.00,800.00,793.91,0.00,0.00,0.00,0.00,55),('1','281','28','1',185.00,185.00,8062.08,0.00,0.00,0.00,0.00,56),('1','281','29','2',800.00,800.00,2.00,0.00,0.00,0.00,0.00,57),('1','281','29','1',185.00,185.00,23352.52,0.00,0.00,0.00,0.00,58),('1','281','30','2',800.00,800.00,1077.02,0.00,0.00,0.00,0.00,59),('1','281','30','1',185.00,185.00,18477.20,0.00,0.00,0.00,0.00,60),('1','281','31','2',800.00,800.00,156.01,0.00,0.00,0.00,0.00,61),('1','281','31','1',185.00,185.00,23874.18,0.00,0.00,0.00,0.00,62),('1','281','32','2',800.00,800.00,68.19,0.00,0.00,0.00,0.00,63),('1','281','32','1',185.00,185.00,18645.44,0.00,0.00,0.00,0.00,64),('1','281','33','2',800.00,800.00,153.86,0.00,0.00,0.00,0.00,65),('1','281','33','1',185.00,185.00,22186.39,0.00,0.00,0.00,0.00,66),('1','281','34','2',800.00,800.00,698.27,0.00,0.00,0.00,0.00,67),('1','281','34','1',185.00,185.00,21157.19,0.00,0.00,0.00,0.00,68),('1','281','35','2',800.00,800.00,3.75,0.00,0.00,0.00,0.00,69),('1','281','35','1',185.00,185.00,18920.20,0.00,0.00,0.00,0.00,70),('1','281','36','2',800.00,800.00,362.12,0.00,0.00,0.00,0.00,71),('1','281','36','1',185.00,185.00,20074.30,0.00,0.00,0.00,0.00,72),('1','281','37','2',800.00,800.00,190.43,0.00,0.00,0.00,0.00,73),('1','281','37','1',185.00,185.00,24459.98,0.00,0.00,0.00,0.00,74),('1','281','38','2',800.00,800.00,280.75,0.00,0.00,0.00,0.00,75),('1','281','38','1',185.00,185.00,11762.83,0.00,0.00,0.00,0.00,76),('1','281','39','2',800.00,800.00,25.03,0.00,0.00,0.00,0.00,77),('1','281','39','1',185.00,185.00,24332.98,0.00,0.00,0.00,0.00,78),('1','281','40','2',800.00,800.00,134.34,0.00,0.00,0.00,0.00,79),('1','281','40','1',185.00,185.00,18215.32,0.00,0.00,0.00,0.00,80),('1','281','41','2',800.00,800.00,985.63,0.00,0.00,0.00,0.00,81),('1','281','41','1',185.00,185.00,25817.55,0.00,0.00,0.00,0.00,82),('1','281','42','2',800.00,800.00,218.43,0.00,0.00,0.00,0.00,83),('1','281','42','1',185.00,185.00,16923.26,0.00,0.00,0.00,0.00,84),('1','281','43','2',800.00,800.00,65.94,0.00,0.00,0.00,0.00,85),('1','281','43','1',185.00,185.00,30239.31,0.00,0.00,0.00,0.00,86),('1','281','44','2',800.00,800.00,39.63,0.00,0.00,0.00,0.00,87),('1','281','44','1',185.00,185.00,20398.27,0.00,0.00,0.00,0.00,88),('1','281','45','2',800.00,800.00,1996.44,0.00,0.00,0.00,0.00,89),('1','281','45','1',185.00,185.00,26039.31,0.00,0.00,0.00,0.00,90),('1','281','46','2',800.00,800.00,218.41,0.00,0.00,0.00,0.00,91),('1','281','46','1',185.00,185.00,21481.69,0.00,0.00,0.00,0.00,92),('1','281','47','2',800.00,800.00,200.13,0.00,0.00,0.00,0.00,93),('1','281','47','1',185.00,185.00,21685.53,0.00,0.00,0.00,0.00,94),('1','281','48','2',800.00,800.00,509.58,0.00,0.00,0.00,0.00,95),('1','281','48','1',185.00,185.00,23014.47,0.00,0.00,0.00,0.00,96),('1','281','49','2',800.00,800.00,996.84,0.00,0.00,0.00,0.00,97),('1','281','49','1',185.00,185.00,19524.86,0.00,0.00,0.00,0.00,98),('1','281','50','2',800.00,800.00,455.58,0.00,0.00,0.00,0.00,99),('1','281','50','1',185.00,185.00,22326.69,0.00,0.00,0.00,0.00,100),('1','281','51','2',800.00,800.00,245.83,0.00,0.00,0.00,0.00,101),('1','281','51','1',185.00,185.00,24942.45,0.00,0.00,0.00,0.00,102),('1','281','52','2',800.00,800.00,1043.28,0.00,0.00,0.00,0.00,103),('1','281','52','1',185.00,185.00,26375.05,0.00,0.00,0.00,0.00,104),('1','281','53','2',800.00,800.00,72.00,0.00,0.00,0.00,0.00,105),('1','281','53','1',185.00,185.00,25339.03,0.00,0.00,0.00,0.00,106),('1','281','54','2',800.00,800.00,2514.24,0.00,0.00,0.00,0.00,107),('1','281','54','1',185.00,185.00,21922.60,0.00,0.00,0.00,0.00,108),('1','281','55','2',800.00,800.00,119.80,0.00,0.00,0.00,0.00,109),('1','281','55','1',185.00,185.00,23193.08,0.00,0.00,0.00,0.00,110),('1','281','56','2',800.00,800.00,1709.14,0.00,0.00,0.00,0.00,111),('1','281','56','1',185.00,185.00,18825.94,0.00,0.00,0.00,0.00,112),('1','281','57','2',800.00,800.00,86.03,0.00,0.00,0.00,0.00,113),('1','281','57','1',185.00,185.00,22339.57,0.00,0.00,0.00,0.00,114),('1','281','58','2',800.00,800.00,317.89,0.00,0.00,0.00,0.00,115),('1','281','58','1',185.00,185.00,21476.39,0.00,0.00,0.00,0.00,116),('1','281','59','2',800.00,800.00,874.55,0.00,0.00,0.00,0.00,117),('1','281','59','1',185.00,185.00,22187.81,0.00,0.00,0.00,0.00,118),('1','281','60','2',800.00,800.00,2078.56,0.00,0.00,0.00,0.00,119),('1','281','60','1',185.00,185.00,20833.68,0.00,0.00,0.00,0.00,120),('1','281','61','2',800.00,800.00,653.32,0.00,0.00,0.00,0.00,121),('1','281','61','1',185.00,185.00,20609.94,0.00,0.00,0.00,0.00,122),('1','281','62','2',800.00,800.00,410.44,0.00,0.00,0.00,0.00,123),('1','281','62','1',185.00,185.00,18302.84,0.00,0.00,0.00,0.00,124),('1','281','63','2',790.00,790.00,1334.71,0.00,0.00,0.00,0.00,125),('1','281','63','1',185.00,185.00,20486.77,0.00,0.00,0.00,0.00,126),('1','281','64','2',790.00,790.00,168.66,0.00,0.00,0.00,0.00,127),('1','281','64','1',185.00,185.00,18606.51,0.00,0.00,0.00,0.00,128),('1','281','65','2',790.00,790.00,216.39,0.00,0.00,0.00,0.00,129),('1','281','65','1',185.00,185.00,8680.57,0.00,0.00,0.00,0.00,130),('1','281','66','2',790.00,790.00,320.79,0.00,0.00,0.00,0.00,131),('1','281','66','1',185.00,185.00,8697.09,0.00,0.00,0.00,0.00,132),('1','281','67','2',790.00,790.00,1062.64,0.00,0.00,0.00,0.00,133),('1','281','67','1',185.00,185.00,23295.22,0.00,0.00,0.00,0.00,134),('1','281','68','2',790.00,790.00,2402.16,0.00,0.00,0.00,0.00,135),('1','281','68','1',185.00,185.00,20028.11,0.00,0.00,0.00,0.00,136),('1','281','69','2',790.00,790.00,2252.26,0.00,0.00,0.00,0.00,137),('1','281','69','1',185.00,185.00,23455.21,0.00,0.00,0.00,0.00,138),('1','281','70','2',790.00,790.00,2702.41,0.00,0.00,0.00,0.00,139),('1','281','70','1',185.00,185.00,18007.17,0.00,0.00,0.00,0.00,140),('1','281','71','2',790.00,790.00,285.93,0.00,0.00,0.00,0.00,141),('1','281','71','1',185.00,185.00,21239.40,0.00,0.00,0.00,0.00,142),('1','281','72','2',790.00,790.00,317.26,0.00,0.00,0.00,0.00,143),('1','281','72','1',185.00,185.00,21900.73,0.00,0.00,0.00,0.00,144),('1','281','73','2',790.00,790.00,1683.30,0.00,0.00,0.00,0.00,145),('1','281','73','1',185.00,185.00,23871.51,0.00,0.00,0.00,0.00,146),('1','281','74','2',790.00,790.00,449.91,0.00,0.00,0.00,0.00,147),('1','281','74','1',185.00,185.00,22309.07,0.00,0.00,0.00,0.00,148),('1','281','75','2',790.00,790.00,201.43,0.00,0.00,0.00,0.00,149),('1','281','75','1',185.00,185.00,21834.54,0.00,0.00,0.00,0.00,150),('1','281','76','2',790.00,790.00,2627.68,0.00,0.00,0.00,0.00,151),('1','281','76','1',185.00,185.00,20066.78,0.00,0.00,0.00,0.00,152),('1','281','77','2',790.00,790.00,140.73,0.00,0.00,0.00,0.00,153),('1','281','77','1',185.00,185.00,19236.39,0.00,0.00,0.00,0.00,154),('1','281','78','2',790.00,790.00,45.40,0.00,0.00,0.00,0.00,155),('1','281','78','1',185.00,185.00,16065.88,0.00,0.00,0.00,0.00,156),('1','281','79','2',790.00,790.00,1249.97,0.00,0.00,0.00,0.00,157),('1','281','79','1',185.00,185.00,21498.90,0.00,0.00,0.00,0.00,158),('1','281','80','2',790.00,790.00,1748.08,0.00,0.00,0.00,0.00,159),('1','281','80','1',185.00,185.00,10998.95,0.00,0.00,0.00,0.00,160),('1','281','81','2',790.00,790.00,344.97,0.00,0.00,0.00,0.00,161),('1','281','81','1',185.00,185.00,22043.57,0.00,0.00,0.00,0.00,162),('1','281','82','2',790.00,790.00,527.68,0.00,0.00,0.00,0.00,163),('1','281','82','1',185.00,185.00,19365.90,0.00,0.00,0.00,0.00,164),('1','281','83','2',790.00,790.00,205.39,0.00,0.00,0.00,0.00,165),('1','281','83','1',185.00,185.00,21008.93,0.00,0.00,0.00,0.00,166),('1','281','84','2',790.00,790.00,1629.67,0.00,0.00,0.00,0.00,167),('1','281','84','1',185.00,185.00,18666.64,0.00,0.00,0.00,0.00,168),('1','281','85','2',790.00,790.00,566.17,0.00,0.00,0.00,0.00,169),('1','281','85','1',185.00,185.00,20532.76,0.00,0.00,0.00,0.00,170),('1','281','86','2',790.00,790.00,1538.93,0.00,0.00,0.00,0.00,171),('1','281','86','1',185.00,185.00,18473.82,0.00,0.00,0.00,0.00,172),('1','281','87','2',790.00,790.00,322.40,0.00,0.00,0.00,0.00,173),('1','281','87','1',185.00,185.00,22621.36,0.00,0.00,0.00,0.00,174),('1','281','88','2',790.00,790.00,2207.20,0.00,0.00,0.00,0.00,175),('1','281','88','1',185.00,185.00,18910.51,0.00,0.00,0.00,0.00,176),('1','281','89','2',790.00,790.00,1325.06,0.00,0.00,0.00,0.00,177),('1','281','89','1',185.00,185.00,21535.92,0.00,0.00,0.00,0.00,178),('1','281','90','2',790.00,790.00,290.31,0.00,0.00,0.00,0.00,179),('1','281','90','1',185.00,185.00,18195.80,0.00,0.00,0.00,0.00,180),('1','281','91','2',790.00,790.00,50.25,0.00,0.00,0.00,0.00,181),('1','281','91','1',185.00,185.00,17479.30,0.00,0.00,0.00,0.00,182),('1','281','92','2',790.00,790.00,0.00,0.00,0.00,0.00,0.00,183),('1','281','92','1',185.00,185.00,18725.71,0.00,0.00,0.00,0.00,184),('1','281','93','2',790.00,790.00,118.85,0.00,0.00,0.00,0.00,185),('1','281','93','1',185.00,185.00,23674.67,0.00,0.00,0.00,0.00,186),('1','281','94','2',800.00,800.00,1951.42,0.00,0.00,0.00,0.00,187),('1','281','94','1',185.00,185.00,13533.23,0.00,0.00,0.00,0.00,188),('1','281','95','2',800.00,800.00,2591.46,0.00,0.00,0.00,0.00,189),('1','281','95','1',185.00,185.00,22151.22,0.00,0.00,0.00,0.00,190),('1','281','96','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,191),('1','281','96','1',185.00,185.00,521.93,0.00,0.00,0.00,0.00,192),('1','281','97','2',800.00,800.00,3807.42,0.00,0.00,0.00,0.00,193),('1','281','97','1',185.00,185.00,18227.27,0.00,0.00,0.00,0.00,194),('1','281','98','2',800.00,800.00,350.90,0.00,0.00,0.00,0.00,195),('1','281','98','1',185.00,185.00,21086.79,0.00,0.00,0.00,0.00,196),('1','281','99','2',805.00,805.00,167.46,0.00,0.00,0.00,0.00,197),('1','281','99','1',185.00,185.00,18763.82,0.00,0.00,0.00,0.00,198),('1','281','100','2',805.00,805.00,149.00,0.00,0.00,0.00,0.00,199),('1','281','100','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,200),('1','281','101','2',815.00,815.00,912.63,0.00,0.00,0.00,0.00,201),('1','281','101','1',185.00,185.00,23831.06,0.00,0.00,0.00,0.00,202),('1','281','102','2',815.00,815.00,1345.19,0.00,0.00,0.00,0.00,203),('1','281','102','1',185.00,185.00,17884.17,0.00,0.00,0.00,0.00,204),('1','281','103','2',815.00,815.00,616.48,0.00,0.00,0.00,0.00,205),('1','281','103','1',185.00,185.00,24060.41,0.00,0.00,0.00,0.00,206),('1','281','104','2',815.00,815.00,2275.78,0.00,0.00,0.00,0.00,207),('1','281','104','1',185.00,185.00,17940.97,0.00,0.00,0.00,0.00,208),('1','281','105','2',815.00,815.00,1395.12,0.00,0.00,0.00,0.00,209),('1','281','105','1',185.00,185.00,23487.89,0.00,0.00,0.00,0.00,210),('1','281','106','2',815.00,815.00,701.46,0.00,0.00,0.00,0.00,211),('1','281','106','1',185.00,185.00,10307.87,0.00,0.00,0.00,0.00,212),('1','281','107','2',815.00,815.00,830.24,0.00,0.00,0.00,0.00,213),('1','281','107','1',185.00,185.00,18217.28,0.00,0.00,0.00,0.00,214),('1','281','108','2',815.00,815.00,2386.75,0.00,0.00,0.00,0.00,215),('1','281','108','1',185.00,185.00,19308.46,0.00,0.00,0.00,0.00,216),('1','281','109','2',815.00,815.00,207.22,0.00,0.00,0.00,0.00,217),('1','281','109','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,218),('1','281','110','2',815.00,815.00,1618.90,0.00,0.00,0.00,0.00,219),('1','281','110','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,220),('1','281','111','2',815.00,815.00,256.64,0.00,0.00,0.00,0.00,221),('1','281','111','1',185.00,185.00,27586.59,0.00,0.00,0.00,0.00,222),('1','281','112','2',815.00,815.00,1978.48,0.00,0.00,0.00,0.00,223),('1','281','112','1',185.00,185.00,27167.95,0.00,0.00,0.00,0.00,224),('1','281','113','2',815.00,815.00,744.14,0.00,0.00,0.00,0.00,225),('1','281','113','1',185.00,185.00,27342.20,0.00,0.00,0.00,0.00,226),('1','281','114','2',815.00,815.00,1887.30,0.00,0.00,0.00,0.00,227),('1','281','114','1',185.00,185.00,24562.63,0.00,0.00,0.00,0.00,228),('1','281','115','2',815.00,815.00,3077.74,0.00,0.00,0.00,0.00,229),('1','281','115','1',185.00,185.00,31789.06,0.00,0.00,0.00,0.00,230),('1','281','116','2',815.00,815.00,0.00,0.00,0.00,0.00,0.00,231),('1','281','116','1',185.00,185.00,28058.40,0.00,0.00,0.00,0.00,232),('1','281','117','2',815.00,815.00,0.00,0.00,0.00,0.00,0.00,233),('1','281','117','1',185.00,185.00,31132.18,0.00,0.00,0.00,0.00,234),('1','281','118','2',815.00,815.00,0.00,0.00,0.00,0.00,0.00,235),('1','281','118','1',185.00,185.00,17696.68,0.00,0.00,0.00,0.00,236),('1','281','119','2',815.00,815.00,0.00,0.00,0.00,0.00,0.00,237),('1','281','119','1',185.00,185.00,15125.93,0.00,0.00,0.00,0.00,238),('1','281','120','2',815.00,815.00,0.00,0.00,0.00,0.00,0.00,239),('1','281','120','1',185.00,185.00,16805.13,0.00,0.00,0.00,0.00,240),('1','281','121','2',815.00,815.00,0.00,0.00,0.00,0.00,0.00,241),('1','281','121','1',185.00,185.00,21209.78,0.00,0.00,0.00,0.00,242),('1','281','122','2',815.00,815.00,0.00,0.00,0.00,0.00,0.00,243),('1','281','122','1',185.00,185.00,13492.69,0.00,0.00,0.00,0.00,244),('1','281','123','2',815.00,815.00,0.00,0.00,0.00,0.00,0.00,245),('1','281','123','1',185.00,185.00,11462.69,0.00,0.00,0.00,0.00,246),('1','281','124','2',815.00,815.00,0.00,0.00,0.00,0.00,0.00,247),('1','281','124','1',185.00,185.00,10730.56,0.00,0.00,0.00,0.00,248),('1','281','125','2',815.00,815.00,0.00,0.00,0.00,0.00,0.00,249),('1','281','125','1',185.00,185.00,15053.95,0.00,0.00,0.00,0.00,250),('1','281','126','2',815.00,815.00,0.00,0.00,0.00,0.00,0.00,251),('1','281','126','1',185.00,185.00,20878.23,0.00,0.00,0.00,0.00,252),('1','281','127','2',815.00,815.00,0.00,0.00,0.00,0.00,0.00,253),('1','281','127','1',185.00,185.00,21328.04,0.00,0.00,0.00,0.00,254),('1','281','128','2',815.00,815.00,384.98,0.00,0.00,0.00,0.00,255),('1','281','128','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,256),('1','281','129','2',830.00,830.00,10.04,0.00,0.00,0.00,0.00,257),('1','281','129','1',185.00,185.00,22877.12,0.00,0.00,0.00,0.00,258),('1','281','130','2',830.00,830.00,1435.82,0.00,0.00,0.00,0.00,259),('1','281','130','1',185.00,185.00,21546.73,0.00,0.00,0.00,0.00,260),('1','281','131','2',830.00,830.00,402.15,0.00,0.00,0.00,0.00,261),('1','281','131','1',185.00,185.00,18237.68,0.00,0.00,0.00,0.00,262),('1','281','132','2',830.00,830.00,647.16,0.00,0.00,0.00,0.00,263),('1','281','132','1',185.00,185.00,19937.34,0.00,0.00,0.00,0.00,264),('1','281','133','2',830.00,830.00,720.89,0.00,0.00,0.00,0.00,265),('1','281','133','1',185.00,185.00,20547.84,0.00,0.00,0.00,0.00,266),('1','281','134','2',830.00,830.00,1447.61,0.00,0.00,0.00,0.00,267),('1','281','134','1',185.00,185.00,27060.25,0.00,0.00,0.00,0.00,268),('1','281','135','2',830.00,830.00,4359.48,0.00,0.00,0.00,0.00,269),('1','281','135','1',185.00,185.00,17773.10,0.00,0.00,0.00,0.00,270),('1','281','136','2',830.00,830.00,11.87,0.00,0.00,0.00,0.00,271),('1','281','136','1',185.00,185.00,14681.70,0.00,0.00,0.00,0.00,272),('1','281','137','2',830.00,830.00,136.01,0.00,0.00,0.00,0.00,273),('1','281','137','1',185.00,185.00,17278.74,0.00,0.00,0.00,0.00,274),('1','281','138','2',830.00,830.00,93.72,0.00,0.00,0.00,0.00,275),('1','281','138','1',185.00,185.00,12769.54,0.00,0.00,0.00,0.00,276),('1','281','139','2',830.00,830.00,241.64,0.00,0.00,0.00,0.00,277),('1','281','139','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,278),('1','281','140','2',830.00,830.00,2209.52,0.00,0.00,0.00,0.00,279),('1','281','140','1',185.00,185.00,17936.49,0.00,0.00,0.00,0.00,280),('1','281','141','2',830.00,830.00,4555.47,0.00,0.00,0.00,0.00,281),('1','281','141','1',185.00,185.00,23388.83,0.00,0.00,0.00,0.00,282),('1','281','142','2',830.00,830.00,3773.58,0.00,0.00,0.00,0.00,283),('1','281','142','1',185.00,185.00,18248.96,0.00,0.00,0.00,0.00,284),('1','281','143','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,285),('1','281','143','1',185.00,185.00,20753.36,0.00,0.00,0.00,0.00,286),('1','281','144','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,287),('1','281','144','1',185.00,185.00,19749.57,0.00,0.00,0.00,0.00,288),('1','281','145','2',830.00,830.00,219.42,0.00,0.00,0.00,0.00,289),('1','281','145','1',185.00,185.00,20049.00,0.00,0.00,0.00,0.00,290),('1','281','146','2',830.00,830.00,1303.10,0.00,0.00,0.00,0.00,291),('1','281','146','1',185.00,185.00,20142.82,0.00,0.00,0.00,0.00,292),('1','281','147','2',830.00,830.00,333.63,0.00,0.00,0.00,0.00,293),('1','281','147','1',185.00,185.00,18716.74,0.00,0.00,0.00,0.00,294),('1','281','148','2',830.00,830.00,1144.46,0.00,0.00,0.00,0.00,295),('1','281','148','1',185.00,185.00,18607.92,0.00,0.00,0.00,0.00,296),('1','281','149','2',830.00,830.00,1453.88,0.00,0.00,0.00,0.00,297),('1','281','149','1',185.00,185.00,10571.18,0.00,0.00,0.00,0.00,298),('1','281','150','2',830.00,830.00,185.83,0.00,0.00,0.00,0.00,299),('1','281','150','1',185.00,185.00,16549.96,0.00,0.00,0.00,0.00,300),('1','281','151','2',830.00,830.00,390.27,0.00,0.00,0.00,0.00,301),('1','281','151','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,302),('1','281','152','2',830.00,830.00,344.14,0.00,0.00,0.00,0.00,303),('1','281','152','1',185.00,185.00,21328.83,0.00,0.00,0.00,0.00,304),('1','281','153','2',830.00,830.00,1438.05,0.00,0.00,0.00,0.00,305),('1','281','153','1',185.00,185.00,11514.58,0.00,0.00,0.00,0.00,306),('1','281','154','2',830.00,830.00,3697.49,0.00,0.00,0.00,0.00,307),('1','281','154','1',185.00,185.00,25541.05,0.00,0.00,0.00,0.00,308),('1','281','155','2',830.00,830.00,326.20,0.00,0.00,0.00,0.00,309),('1','281','155','1',185.00,185.00,14496.94,0.00,0.00,0.00,0.00,310),('1','281','156','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,311),('1','281','156','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,312),('1','281','157','2',830.00,830.00,1042.49,0.00,0.00,0.00,0.00,313),('1','281','157','1',185.00,185.00,27127.37,0.00,0.00,0.00,0.00,314),('1','281','158','2',830.00,830.00,192.65,0.00,0.00,0.00,0.00,315),('1','281','158','1',185.00,185.00,19094.79,0.00,0.00,0.00,0.00,316),('1','281','159','2',830.00,830.00,943.18,0.00,0.00,0.00,0.00,317),('1','281','159','1',185.00,185.00,23475.56,0.00,0.00,0.00,0.00,318),('1','281','160','2',830.00,830.00,1278.10,0.00,0.00,0.00,0.00,319),('1','281','160','1',185.00,185.00,11434.86,0.00,0.00,0.00,0.00,320),('1','281','161','2',830.00,830.00,2415.42,0.00,0.00,0.00,0.00,321),('1','281','161','1',185.00,185.00,16125.16,0.00,0.00,0.00,0.00,322),('1','281','162','2',830.00,830.00,253.97,0.00,0.00,0.00,0.00,323),('1','281','162','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,324),('1','281','163','2',830.00,830.00,363.65,0.00,0.00,0.00,0.00,325),('1','281','163','1',185.00,185.00,17451.69,0.00,0.00,0.00,0.00,326),('1','281','164','2',830.00,830.00,193.29,0.00,0.00,0.00,0.00,327),('1','281','164','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,328),('1','281','165','2',830.00,830.00,33.14,0.00,0.00,0.00,0.00,329),('1','281','165','1',185.00,185.00,20067.16,0.00,0.00,0.00,0.00,330),('1','281','166','2',830.00,830.00,1482.31,0.00,0.00,0.00,0.00,331),('1','281','166','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,332),('1','281','167','2',830.00,830.00,992.22,0.00,0.00,0.00,0.00,333),('1','281','167','1',185.00,185.00,21572.79,0.00,0.00,0.00,0.00,334),('1','281','168','2',830.00,830.00,2107.67,0.00,0.00,0.00,0.00,335),('1','281','168','1',185.00,185.00,18462.74,0.00,0.00,0.00,0.00,336),('1','281','169','2',830.00,830.00,1807.40,0.00,0.00,0.00,0.00,337),('1','281','169','1',185.00,185.00,19993.47,0.00,0.00,0.00,0.00,338),('1','281','170','2',830.00,830.00,2823.88,0.00,0.00,0.00,0.00,339),('1','281','170','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,340),('1','281','171','2',830.00,830.00,571.79,0.00,0.00,0.00,0.00,341),('1','281','171','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,342),('1','281','172','2',830.00,830.00,478.60,0.00,0.00,0.00,0.00,343),('1','281','172','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,344),('1','281','173','2',830.00,830.00,763.06,0.00,0.00,0.00,0.00,345),('1','281','173','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,346),('1','281','174','2',830.00,830.00,182.23,0.00,0.00,0.00,0.00,347),('1','281','174','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,348),('1','281','175','2',830.00,830.00,482.40,0.00,0.00,0.00,0.00,349),('1','281','175','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,350),('1','281','176','2',830.00,830.00,3337.20,0.00,0.00,0.00,0.00,351),('1','281','176','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,352),('1','281','177','2',830.00,830.00,2025.66,0.00,0.00,0.00,0.00,353),('1','281','177','1',185.00,185.00,16496.91,0.00,0.00,0.00,0.00,354),('1','281','178','2',830.00,830.00,1676.76,0.00,0.00,0.00,0.00,355),('1','281','178','1',185.00,185.00,22790.01,0.00,0.00,0.00,0.00,356),('1','281','179','2',830.00,830.00,1157.52,0.00,0.00,0.00,0.00,357),('1','281','179','1',185.00,185.00,22095.56,0.00,0.00,0.00,0.00,358),('1','281','180','2',830.00,830.00,323.61,0.00,0.00,0.00,0.00,359),('1','281','180','1',185.00,185.00,5250.84,0.00,0.00,0.00,0.00,360),('1','281','181','2',830.00,830.00,619.57,0.00,0.00,0.00,0.00,361),('1','281','181','1',185.00,185.00,23962.26,0.00,0.00,0.00,0.00,362),('1','281','182','2',830.00,830.00,1221.85,0.00,0.00,0.00,0.00,363),('1','281','182','1',185.00,185.00,5685.17,0.00,0.00,0.00,0.00,364),('1','281','183','2',830.00,830.00,791.10,0.00,0.00,0.00,0.00,365),('1','281','183','1',185.00,185.00,16987.72,0.00,0.00,0.00,0.00,366),('1','281','184','2',830.00,830.00,2086.29,0.00,0.00,0.00,0.00,367),('1','281','184','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,368),('1','281','185','2',830.00,830.00,208.08,0.00,0.00,0.00,0.00,369),('1','281','185','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,370),('1','281','186','2',830.00,830.00,606.13,0.00,0.00,0.00,0.00,371),('1','281','186','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,372),('1','281','187','2',830.00,830.00,487.82,0.00,0.00,0.00,0.00,373),('1','281','187','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,374),('1','281','188','2',860.00,860.00,1612.29,0.00,0.00,0.00,0.00,375),('1','281','188','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,376),('1','281','189','2',860.00,860.00,38.31,0.00,0.00,0.00,0.00,377),('1','281','189','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,378),('1','281','190','2',860.00,860.00,0.00,0.00,0.00,0.00,0.00,379),('1','281','190','1',185.00,185.00,25261.68,0.00,0.00,0.00,0.00,380),('1','281','191','2',860.00,860.00,0.00,0.00,0.00,0.00,0.00,381),('1','281','191','1',185.00,185.00,7779.64,0.00,0.00,0.00,0.00,382),('1','281','192','2',860.00,860.00,0.00,0.00,0.00,0.00,0.00,383),('1','281','192','1',185.00,185.00,34492.32,0.00,0.00,0.00,0.00,384),('1','281','193','2',860.00,860.00,0.00,0.00,0.00,0.00,0.00,385),('1','281','193','1',185.00,185.00,26412.53,0.00,0.00,0.00,0.00,386),('1','281','194','2',860.00,860.00,1045.06,0.00,0.00,0.00,0.00,387),('1','281','194','1',185.00,185.00,8109.49,0.00,0.00,0.00,0.00,388),('1','281','195','2',860.00,860.00,2146.29,0.00,0.00,0.00,0.00,389),('1','281','195','1',185.00,185.00,22616.07,0.00,0.00,0.00,0.00,390),('1','281','196','2',860.00,860.00,1468.89,0.00,0.00,0.00,0.00,391),('1','281','196','1',185.00,185.00,7305.25,0.00,0.00,0.00,0.00,392),('1','281','197','2',860.00,860.00,286.58,0.00,0.00,0.00,0.00,393),('1','281','197','1',185.00,185.00,27448.88,0.00,0.00,0.00,0.00,394),('1','281','198','2',860.00,860.00,779.71,0.00,0.00,0.00,0.00,395),('1','281','198','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,396),('1','281','199','2',860.00,860.00,2668.45,0.00,0.00,0.00,0.00,397),('1','281','199','1',185.00,185.00,26259.95,0.00,0.00,0.00,0.00,398),('1','281','200','2',860.00,860.00,1502.09,0.00,0.00,0.00,0.00,399),('1','281','200','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,400),('1','281','201','2',860.00,860.00,2621.75,0.00,0.00,0.00,0.00,401),('1','281','201','1',185.00,185.00,25780.82,0.00,0.00,0.00,0.00,402),('1','281','202','2',860.00,860.00,1403.02,0.00,0.00,0.00,0.00,403),('1','281','202','1',185.00,185.00,10467.65,0.00,0.00,0.00,0.00,404),('1','281','203','2',880.00,880.00,2957.99,0.00,0.00,0.00,0.00,405),('1','281','203','1',185.00,185.00,30013.55,0.00,0.00,0.00,0.00,406),('1','281','204','2',880.00,880.00,466.09,0.00,0.00,0.00,0.00,407),('1','281','204','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,408),('1','281','205','2',880.00,880.00,2842.09,0.00,0.00,0.00,0.00,409),('1','281','205','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,410),('1','281','206','2',880.00,880.00,259.48,0.00,0.00,0.00,0.00,411),('1','281','206','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,412),('1','281','207','2',880.00,880.00,252.85,0.00,0.00,0.00,0.00,413),('1','281','207','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,414),('1','281','208','2',880.00,880.00,2239.30,0.00,0.00,0.00,0.00,415),('1','281','208','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,416),('1','281','209','2',880.00,880.00,1638.27,0.00,0.00,0.00,0.00,417),('1','281','209','1',185.00,185.00,33753.02,0.00,0.00,0.00,0.00,418),('1','281','210','2',880.00,880.00,2541.18,0.00,0.00,0.00,0.00,419),('1','281','210','1',185.00,185.00,28706.96,0.00,0.00,0.00,0.00,420),('1','281','211','2',880.00,880.00,865.54,0.00,0.00,0.00,0.00,421),('1','281','211','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,422),('1','281','212','2',880.00,880.00,2405.21,0.00,0.00,0.00,0.00,423),('1','281','212','1',185.00,185.00,22125.86,0.00,0.00,0.00,0.00,424),('1','281','213','2',880.00,880.00,4769.22,0.00,0.00,0.00,0.00,425),('1','281','213','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,426),('1','281','214','2',880.00,880.00,970.51,0.00,0.00,0.00,0.00,427),('1','281','214','1',185.00,185.00,29966.16,0.00,0.00,0.00,0.00,428),('1','281','215','2',880.00,880.00,3727.90,0.00,0.00,0.00,0.00,429),('1','281','215','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,430),('1','281','216','2',870.00,870.00,615.40,0.00,0.00,0.00,0.00,431),('1','281','216','1',185.00,185.00,18307.35,0.00,0.00,0.00,0.00,432),('1','281','217','2',870.00,870.00,747.85,0.00,0.00,0.00,0.00,433),('1','281','217','1',185.00,185.00,15609.17,0.00,0.00,0.00,0.00,434),('1','281','218','2',870.00,870.00,1330.10,0.00,0.00,0.00,0.00,435),('1','281','218','1',185.00,185.00,28752.86,0.00,0.00,0.00,0.00,436),('1','281','219','2',870.00,870.00,279.85,0.00,0.00,0.00,0.00,437),('1','281','219','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,438),('1','281','220','2',870.00,870.00,469.88,0.00,0.00,0.00,0.00,439),('1','281','220','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,440),('1','281','221','2',870.00,870.00,566.87,0.00,0.00,0.00,0.00,441),('1','281','221','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,442),('1','281','222','2',870.00,870.00,531.42,0.00,0.00,0.00,0.00,443),('1','281','222','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,444),('1','281','223','2',880.00,880.00,401.72,0.00,0.00,0.00,0.00,445),('1','281','223','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,446),('1','281','224','2',880.00,880.00,1303.75,0.00,0.00,0.00,0.00,447),('1','281','224','1',185.00,185.00,29579.48,0.00,0.00,0.00,0.00,448),('1','281','225','2',880.00,880.00,515.14,0.00,0.00,0.00,0.00,449),('1','281','225','1',185.00,185.00,338.48,0.00,0.00,0.00,0.00,450),('1','281','226','2',880.00,880.00,356.75,0.00,0.00,0.00,0.00,451),('1','281','226','1',185.00,185.00,203.22,0.00,0.00,0.00,0.00,452),('1','281','227','2',880.00,880.00,1824.31,0.00,0.00,0.00,0.00,453),('1','281','227','1',185.00,185.00,29928.30,0.00,0.00,0.00,0.00,454),('1','281','228','2',880.00,880.00,416.26,0.00,0.00,0.00,0.00,455),('1','281','228','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,456),('1','281','229','2',880.00,880.00,538.77,0.00,0.00,0.00,0.00,457),('1','281','229','1',185.00,185.00,17957.72,0.00,0.00,0.00,0.00,458),('1','281','230','2',880.00,880.00,2782.17,0.00,0.00,0.00,0.00,459),('1','281','230','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,460),('1','281','231','2',900.00,900.00,0.00,0.00,0.00,0.00,0.00,461),('1','281','231','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,462),('1','281','232','2',900.00,900.00,28.58,0.00,0.00,0.00,0.00,463),('1','281','232','1',185.00,185.00,19748.92,0.00,0.00,0.00,0.00,464),('1','281','233','2',900.00,900.00,319.94,0.00,0.00,0.00,0.00,465),('1','281','233','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,466),('1','281','234','2',900.00,900.00,336.91,0.00,0.00,0.00,0.00,467),('1','281','234','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,468),('1','281','235','2',900.00,900.00,729.42,0.00,0.00,0.00,0.00,469),('1','281','235','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,470),('1','281','236','2',900.00,900.00,605.31,0.00,0.00,0.00,0.00,471),('1','281','236','1',185.00,185.00,32993.87,0.00,0.00,0.00,0.00,472),('1','281','237','2',900.00,900.00,1179.48,0.00,0.00,0.00,0.00,473),('1','281','237','1',185.00,185.00,781.76,0.00,0.00,0.00,0.00,474),('1','281','238','1',185.00,185.00,15562.58,0.00,0.00,0.00,0.00,475),('1','281','238','2',890.00,890.00,476.46,0.00,0.00,0.00,0.00,476),('1','281','239','2',890.00,890.00,1160.42,0.00,0.00,0.00,0.00,477),('1','281','239','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,478),('1','281','240','2',890.00,890.00,3583.23,0.00,0.00,0.00,0.00,479),('1','281','240','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,480),('1','281','241','2',890.00,890.00,393.30,0.00,0.00,0.00,0.00,481),('1','281','241','1',185.00,185.00,19291.75,0.00,0.00,0.00,0.00,482),('1','281','242','2',890.00,890.00,630.04,0.00,0.00,0.00,0.00,483),('1','281','242','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,484),('1','281','243','2',890.00,890.00,3312.49,0.00,0.00,0.00,0.00,485),('1','281','243','1',185.00,185.00,661.19,0.00,0.00,0.00,0.00,486),('1','281','244','2',890.00,890.00,134.25,0.00,0.00,0.00,0.00,487),('1','281','244','1',185.00,185.00,19990.60,0.00,0.00,0.00,0.00,488),('1','281','245','2',890.00,890.00,102.12,0.00,0.00,0.00,0.00,489),('1','281','245','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,490),('1','281','246','2',890.00,890.00,527.27,0.00,0.00,0.00,0.00,491),('1','281','246','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,492),('1','281','247','2',890.00,890.00,680.41,0.00,0.00,0.00,0.00,493),('1','281','247','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,494),('1','281','248','2',890.00,890.00,451.75,0.00,0.00,0.00,0.00,495),('1','281','248','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,496),('1','281','249','2',890.00,890.00,439.86,0.00,0.00,0.00,0.00,497),('1','281','249','1',185.00,185.00,36072.34,0.00,0.00,0.00,0.00,498),('1','281','250','2',880.00,880.00,352.34,0.00,0.00,0.00,0.00,499),('1','281','250','1',185.00,185.00,13610.73,0.00,0.00,0.00,0.00,500),('1','281','251','2',880.00,880.00,2896.44,0.00,0.00,0.00,0.00,501),('1','281','251','1',185.00,185.00,22511.15,0.00,0.00,0.00,0.00,502),('1','281','252','2',880.00,880.00,1081.91,0.00,0.00,0.00,0.00,503),('1','281','252','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,504),('1','281','253','2',880.00,880.00,3870.21,0.00,0.00,0.00,0.00,505),('1','281','253','1',185.00,185.00,822.07,0.00,0.00,0.00,0.00,506),('1','281','254','2',880.00,880.00,1241.32,0.00,0.00,0.00,0.00,507),('1','281','254','1',185.00,185.00,23597.69,0.00,0.00,0.00,0.00,508),('1','281','255','2',880.00,880.00,208.57,0.00,0.00,0.00,0.00,509),('1','281','255','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,510),('1','281','256','2',880.00,880.00,351.21,0.00,0.00,0.00,0.00,511),('1','281','256','1',185.00,185.00,16885.49,0.00,0.00,0.00,0.00,512),('1','281','257','2',880.00,880.00,104.33,0.00,0.00,0.00,0.00,513),('1','281','257','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,514),('1','281','258','2',880.00,880.00,2895.49,0.00,0.00,0.00,0.00,515),('1','281','258','1',185.00,185.00,15668.53,0.00,0.00,0.00,0.00,516),('1','281','259','2',880.00,880.00,495.47,0.00,0.00,0.00,0.00,517),('1','281','259','1',185.00,185.00,1067.05,0.00,0.00,0.00,0.00,518),('1','281','260','2',880.00,880.00,11828.61,0.00,0.00,0.00,0.00,519),('1','281','260','1',185.00,185.00,16462.73,0.00,0.00,0.00,0.00,520),('1','281','261','2',880.00,880.00,375.30,0.00,0.00,0.00,0.00,521),('1','281','261','1',185.00,185.00,24927.16,0.00,0.00,0.00,0.00,522),('1','281','262','2',880.00,880.00,442.38,0.00,0.00,0.00,0.00,523),('1','281','262','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,524),('1','281','263','2',880.00,880.00,590.71,0.00,0.00,0.00,0.00,525),('1','281','263','1',185.00,185.00,15350.81,0.00,0.00,0.00,0.00,526),('1','281','264','2',880.00,880.00,842.06,0.00,0.00,0.00,0.00,527),('1','281','264','1',185.00,185.00,436.32,0.00,0.00,0.00,0.00,528),('1','281','265','2',880.00,880.00,1622.76,0.00,0.00,0.00,0.00,529),('1','281','265','1',185.00,185.00,29497.51,0.00,0.00,0.00,0.00,530),('1','281','266','2',880.00,880.00,3696.13,0.00,0.00,0.00,0.00,531),('1','281','266','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,532),('1','281','267','2',880.00,880.00,1155.93,0.00,0.00,0.00,0.00,533),('1','281','267','1',185.00,185.00,35420.25,0.00,0.00,0.00,0.00,534),('1','281','268','2',880.00,880.00,523.70,0.00,0.00,0.00,0.00,535),('1','281','268','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,536),('1','281','269','2',880.00,880.00,1206.82,0.00,0.00,0.00,0.00,537),('1','281','269','1',185.00,185.00,13950.73,0.00,0.00,0.00,0.00,538),('1','281','270','2',880.00,880.00,182.96,0.00,0.00,0.00,0.00,539),('1','281','270','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,540),('1','281','271','2',880.00,880.00,652.03,0.00,0.00,0.00,0.00,541),('1','281','271','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,542),('1','281','272','2',880.00,880.00,283.37,0.00,0.00,0.00,0.00,543),('1','281','272','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,544),('1','281','273','2',880.00,880.00,141.35,0.00,0.00,0.00,0.00,545),('1','281','273','1',185.00,185.00,25391.90,0.00,0.00,0.00,0.00,546),('1','281','274','2',880.00,880.00,277.44,0.00,0.00,0.00,0.00,547),('1','281','274','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,548),('1','281','275','2',880.00,880.00,551.02,0.00,0.00,0.00,0.00,549),('1','281','275','1',185.00,185.00,19947.66,0.00,0.00,0.00,0.00,550),('1','281','276','2',880.00,880.00,0.00,0.00,0.00,0.00,0.00,551),('1','281','276','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,552),('1','281','277','2',880.00,880.00,1915.46,0.00,0.00,0.00,0.00,553),('1','281','277','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,554),('1','281','278','2',880.00,880.00,2115.84,0.00,0.00,0.00,0.00,555),('1','281','278','1',185.00,185.00,29745.65,0.00,0.00,0.00,0.00,556),('1','281','279','2',880.00,880.00,848.21,0.00,0.00,0.00,0.00,557),('1','281','279','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,558),('1','281','280','2',880.00,880.00,2280.76,0.00,0.00,0.00,0.00,559),('1','281','280','1',185.00,185.00,39740.88,0.00,0.00,0.00,0.00,560),('1','281','281','2',880.00,880.00,785.79,0.00,0.00,0.00,0.00,561),('1','281','281','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,562),('1','281','282','2',880.00,880.00,258.65,0.00,0.00,0.00,0.00,563),('1','281','282','1',185.00,185.00,25850.59,0.00,0.00,0.00,0.00,564),('1','281','283','2',880.00,880.00,399.92,0.00,0.00,0.00,0.00,565),('1','281','283','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,566),('1','281','284','2',880.00,880.00,182.64,0.00,0.00,0.00,0.00,567),('1','281','284','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,568),('1','281','285','2',880.00,880.00,589.95,0.00,0.00,0.00,0.00,569),('1','281','285','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,570),('1','281','286','2',880.00,880.00,5477.32,0.00,0.00,0.00,0.00,571),('1','281','286','1',185.00,185.00,30243.60,0.00,0.00,0.00,0.00,572),('1','281','287','2',880.00,880.00,261.34,0.00,0.00,0.00,0.00,573),('1','281','287','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,574),('1','281','288','2',880.00,880.00,2687.67,0.00,0.00,0.00,0.00,575),('1','281','288','1',185.00,185.00,16206.51,0.00,0.00,0.00,0.00,576),('1','281','289','2',880.00,880.00,262.39,0.00,0.00,0.00,0.00,577),('1','281','289','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,578),('1','281','290','2',880.00,880.00,1619.84,0.00,0.00,0.00,0.00,579),('1','281','290','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,580),('1','281','291','2',880.00,880.00,1762.30,0.00,0.00,0.00,0.00,581),('1','281','291','1',185.00,185.00,29867.44,0.00,0.00,0.00,0.00,582),('1','281','292','2',880.00,880.00,639.45,0.00,0.00,0.00,0.00,583),('1','281','292','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,584),('1','281','293','2',880.00,880.00,557.66,0.00,0.00,0.00,0.00,585),('1','281','293','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,586),('1','281','294','2',880.00,880.00,381.21,0.00,0.00,0.00,0.00,587),('1','281','294','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,588),('1','281','295','2',880.00,880.00,1101.14,0.00,0.00,0.00,0.00,589),('1','281','295','1',185.00,185.00,19865.36,0.00,0.00,0.00,0.00,590),('1','281','296','2',880.00,880.00,389.77,0.00,0.00,0.00,0.00,591),('1','281','296','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,592),('1','281','297','2',880.00,880.00,229.43,0.00,0.00,0.00,0.00,593),('1','281','297','1',185.00,185.00,18597.54,0.00,0.00,0.00,0.00,594),('1','281','298','2',880.00,880.00,3379.16,0.00,0.00,0.00,0.00,595),('1','281','298','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,596),('1','281','299','2',880.00,880.00,1112.93,0.00,0.00,0.00,0.00,597),('1','281','299','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,598),('1','281','300','2',880.00,880.00,1803.26,0.00,0.00,0.00,0.00,599),('1','281','300','1',185.00,185.00,29910.59,0.00,0.00,0.00,0.00,600),('1','281','301','2',880.00,880.00,385.55,0.00,0.00,0.00,0.00,601),('1','281','301','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,602),('1','281','302','2',880.00,880.00,1013.23,0.00,0.00,0.00,0.00,603),('1','281','302','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,604),('1','281','303','2',880.00,880.00,551.12,0.00,0.00,0.00,0.00,605),('1','281','303','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,606),('1','281','304','2',880.00,880.00,330.60,0.00,0.00,0.00,0.00,607),('1','281','304','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,608),('1','281','305','2',880.00,880.00,1153.31,0.00,0.00,0.00,0.00,609),('1','281','305','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,610),('1','281','306','2',880.00,880.00,2061.44,0.00,0.00,0.00,0.00,611),('1','281','306','1',185.00,185.00,16307.58,0.00,0.00,0.00,0.00,612),('1','281','307','2',880.00,880.00,296.56,0.00,0.00,0.00,0.00,613),('1','281','307','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,614),('1','281','308','2',880.00,880.00,2620.68,0.00,0.00,0.00,0.00,615),('1','281','308','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,616),('1','281','309','2',880.00,880.00,682.03,0.00,0.00,0.00,0.00,617),('1','281','309','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,618),('1','281','310','2',880.00,880.00,2089.90,0.00,0.00,0.00,0.00,619),('1','281','310','1',185.00,185.00,32723.21,0.00,0.00,0.00,0.00,620),('1','281','311','2',880.00,880.00,141.48,0.00,0.00,0.00,0.00,621),('1','281','311','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,622),('1','281','312','2',880.00,880.00,440.61,0.00,0.00,0.00,0.00,623),('1','281','312','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,624),('1','281','313','2',880.00,880.00,989.67,0.00,0.00,0.00,0.00,625),('1','281','313','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,626),('1','281','314','2',880.00,880.00,928.71,0.00,0.00,0.00,0.00,627),('1','281','314','1',185.00,185.00,19738.04,0.00,0.00,0.00,0.00,628),('1','281','315','2',880.00,880.00,3561.61,0.00,0.00,0.00,0.00,629),('1','281','315','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,630),('1','281','316','2',870.00,870.00,2160.03,0.00,0.00,0.00,0.00,631),('1','281','316','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,632),('1','281','317','2',870.00,870.00,602.13,0.00,0.00,0.00,0.00,633),('1','281','317','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,634),('1','281','318','2',870.00,870.00,1361.23,0.00,0.00,0.00,0.00,635),('1','281','318','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,636),('1','281','319','2',870.00,870.00,4405.26,0.00,0.00,0.00,0.00,637),('1','281','319','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,638),('1','281','320','2',870.00,870.00,1046.45,0.00,0.00,0.00,0.00,639),('1','281','320','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,640),('1','281','321','2',870.00,870.00,541.94,0.00,0.00,0.00,0.00,641),('1','281','321','1',220.00,220.00,14941.85,0.00,0.00,0.00,0.00,642),('1','281','322','2',870.00,870.00,869.94,0.00,0.00,0.00,0.00,643),('1','281','322','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,644),('1','281','323','2',870.00,870.00,534.54,0.00,0.00,0.00,0.00,645),('1','281','323','1',220.00,220.00,19077.57,0.00,0.00,0.00,0.00,646),('1','281','324','2',870.00,870.00,3348.40,0.00,0.00,0.00,0.00,647),('1','281','324','1',220.00,220.00,684.25,0.00,0.00,0.00,0.00,648),('1','281','325','2',870.00,870.00,780.32,0.00,0.00,0.00,0.00,649),('1','281','325','1',220.00,220.00,16934.78,0.00,0.00,0.00,0.00,650),('1','281','326','2',870.00,870.00,636.53,0.00,0.00,0.00,0.00,651),('1','281','326','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,652),('1','281','327','2',870.00,870.00,1147.99,0.00,0.00,0.00,0.00,653),('1','281','327','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,654),('1','281','328','2',870.00,870.00,1937.11,0.00,0.00,0.00,0.00,655),('1','281','328','1',220.00,220.00,19170.52,0.00,0.00,0.00,0.00,656),('1','281','329','2',870.00,870.00,526.57,0.00,0.00,0.00,0.00,657),('1','281','329','1',220.00,220.00,472.51,0.00,0.00,0.00,0.00,658),('1','281','330','2',850.00,850.00,1167.87,0.00,0.00,0.00,0.00,659),('1','281','330','1',220.00,220.00,14960.11,0.00,0.00,0.00,0.00,660),('1','281','331','2',850.00,850.00,974.20,0.00,0.00,0.00,0.00,661),('1','281','331','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,662),('1','281','332','2',850.00,850.00,267.11,0.00,0.00,0.00,0.00,663),('1','281','332','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,664),('1','281','333','2',850.00,850.00,4760.18,0.00,0.00,0.00,0.00,665),('1','281','333','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,666),('1','281','334','2',850.00,850.00,4374.78,0.00,0.00,0.00,0.00,667),('1','281','334','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,668),('1','281','335','2',850.00,850.00,4637.05,0.00,0.00,0.00,0.00,669),('1','281','335','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,670),('1','281','336','2',850.00,850.00,0.00,0.00,0.00,0.00,0.00,671),('1','281','336','1',220.00,220.00,15632.77,0.00,0.00,0.00,0.00,672),('1','281','337','2',850.00,850.00,0.00,0.00,0.00,0.00,0.00,673),('1','281','337','1',200.00,200.00,285.01,0.00,0.00,0.00,0.00,674),('1','281','338','2',850.00,850.00,828.63,0.00,0.00,0.00,0.00,675),('1','281','338','1',200.00,200.00,22854.20,0.00,0.00,0.00,0.00,676),('1','281','339','2',850.00,850.00,3923.33,0.00,0.00,0.00,0.00,677),('1','281','339','1',200.00,200.00,148.69,0.00,0.00,0.00,0.00,678),('1','281','340','2',850.00,850.00,1602.94,0.00,0.00,0.00,0.00,679),('1','281','340','1',200.00,200.00,100.00,0.00,0.00,0.00,0.00,680),('1','281','341','2',850.00,850.00,1157.81,0.00,0.00,0.00,0.00,681),('1','281','341','1',200.00,200.00,0.00,0.00,0.00,0.00,0.00,682),('1','281','342','2',850.00,850.00,3361.25,0.00,0.00,0.00,0.00,683),('1','281','342','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,684),('1','281','343','2',850.00,850.00,2217.45,0.00,0.00,0.00,0.00,685),('1','281','343','1',210.00,210.00,20654.77,0.00,0.00,0.00,0.00,686),('1','281','344','2',850.00,850.00,3437.91,0.00,0.00,0.00,0.00,687),('1','281','344','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,688),('1','281','345','2',850.00,850.00,228.80,0.00,0.00,0.00,0.00,689),('1','281','345','1',210.00,210.00,20667.12,0.00,0.00,0.00,0.00,690),('1','281','346','2',850.00,850.00,302.56,0.00,0.00,0.00,0.00,691),('1','281','346','1',210.00,210.00,16971.01,0.00,0.00,0.00,0.00,692),('1','281','347','2',850.00,850.00,3699.43,0.00,0.00,0.00,0.00,693),('1','281','347','1',210.00,210.00,15211.83,0.00,0.00,0.00,0.00,694),('1','281','348','2',850.00,850.00,3204.33,0.00,0.00,0.00,0.00,695),('1','281','348','1',210.00,210.00,27875.66,0.00,0.00,0.00,0.00,696),('1','281','349','2',850.00,850.00,982.17,0.00,0.00,0.00,0.00,697),('1','281','349','1',210.00,210.00,31821.53,0.00,0.00,0.00,0.00,698),('1','281','350','2',850.00,850.00,774.11,0.00,0.00,0.00,0.00,699),('1','281','350','1',210.00,210.00,33309.49,0.00,0.00,0.00,0.00,700),('1','281','351','2',850.00,850.00,2968.33,0.00,0.00,0.00,0.00,701),('1','281','351','1',210.00,210.00,32078.10,0.00,0.00,0.00,0.00,702),('1','281','352','2',850.00,850.00,190.63,0.00,0.00,0.00,0.00,703),('1','281','352','1',210.00,210.00,16693.66,0.00,0.00,0.00,0.00,704),('1','281','353','2',850.00,850.00,2578.67,0.00,0.00,0.00,0.00,705),('1','281','353','1',210.00,210.00,16967.83,0.00,0.00,0.00,0.00,706),('1','281','354','2',850.00,850.00,1863.68,0.00,0.00,0.00,0.00,707),('1','281','354','1',210.00,210.00,49255.01,0.00,0.00,0.00,0.00,708),('1','281','355','2',850.00,850.00,1115.51,0.00,0.00,0.00,0.00,709),('1','281','355','1',210.00,210.00,39440.50,0.00,0.00,0.00,0.00,710),('1','281','356','2',850.00,850.00,3723.49,0.00,0.00,0.00,0.00,711),('1','281','356','1',210.00,210.00,50356.14,0.00,0.00,0.00,0.00,712),('1','281','357','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,713),('1','281','357','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,714),('1','281','358','2',830.00,830.00,426.71,0.00,0.00,0.00,0.00,715),('1','281','358','1',210.00,210.00,49481.32,0.00,0.00,0.00,0.00,716),('1','281','359','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,717),('1','281','359','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,718),('1','281','360','2',830.00,830.00,1100.00,0.00,0.00,0.00,0.00,719),('1','281','360','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,720),('1','281','361','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,721),('1','281','361','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,722),('1','281','362','2',830.00,830.00,820.42,0.00,0.00,0.00,0.00,723),('1','281','362','1',210.00,210.00,45059.60,0.00,0.00,0.00,0.00,724),('1','281','363','2',830.00,830.00,1504.69,0.00,0.00,0.00,0.00,725),('1','281','363','1',210.00,210.00,15124.47,0.00,0.00,0.00,0.00,726),('1','281','364','2',830.00,830.00,691.90,0.00,0.00,0.00,0.00,727),('1','281','364','1',210.00,210.00,43193.49,0.00,0.00,0.00,0.00,728),('1','281','365','2',830.00,830.00,2579.46,0.00,0.00,0.00,0.00,729),('1','281','365','1',210.00,210.00,6674.73,0.00,0.00,0.00,0.00,730),('1','281','366','2',830.00,830.00,235.59,0.00,0.00,0.00,0.00,731),('1','281','366','1',210.00,210.00,33058.39,0.00,0.00,0.00,0.00,732),('1','281','367','2',830.00,830.00,1113.69,0.00,0.00,0.00,0.00,733),('1','281','367','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,734),('1','281','368','2',830.00,830.00,1746.92,0.00,0.00,0.00,0.00,735),('1','281','368','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,736),('1','281','369','2',830.00,830.00,313.04,0.00,0.00,0.00,0.00,737),('1','281','369','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,738),('1','281','370','2',830.00,830.00,2449.22,0.00,0.00,0.00,0.00,739),('1','281','370','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,740),('1','281','371','2',830.00,830.00,1290.05,0.00,0.00,0.00,0.00,741),('1','281','371','1',210.00,210.00,44315.11,0.00,0.00,0.00,0.00,742),('1','281','372','2',830.00,830.00,1140.47,0.00,0.00,0.00,0.00,743),('1','281','372','1',210.00,210.00,266.86,0.00,0.00,0.00,0.00,744),('1','281','373','2',830.00,830.00,3516.57,0.00,0.00,0.00,0.00,745),('1','281','373','1',210.00,210.00,16837.10,0.00,0.00,0.00,0.00,746),('1','281','374','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,747),('1','281','374','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,748),('1','281','375','2',830.00,830.00,241.73,0.00,0.00,0.00,0.00,749),('1','281','375','1',210.00,210.00,38651.21,0.00,0.00,0.00,0.00,750),('1','281','376','2',830.00,830.00,1524.26,0.00,0.00,0.00,0.00,751),('1','281','376','1',210.00,210.00,33567.15,0.00,0.00,0.00,0.00,752),('1','281','377','2',830.00,830.00,632.83,0.00,0.00,0.00,0.00,753),('1','281','377','1',210.00,210.00,25178.08,0.00,0.00,0.00,0.00,754),('1','281','378','2',820.00,820.00,744.12,0.00,0.00,0.00,0.00,755),('1','281','378','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,756),('1','281','379','2',820.00,820.00,1658.85,0.00,0.00,0.00,0.00,757),('1','281','379','1',210.00,210.00,30879.51,0.00,0.00,0.00,0.00,758),('1','281','380','2',820.00,820.00,930.59,0.00,0.00,0.00,0.00,759),('1','281','380','1',210.00,210.00,14814.52,0.00,0.00,0.00,0.00,760),('1','281','381','2',820.00,820.00,1132.01,0.00,0.00,0.00,0.00,761),('1','281','381','1',210.00,210.00,39403.17,0.00,0.00,0.00,0.00,762),('1','281','382','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,763),('1','281','382','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,764),('1','281','383','2',820.00,820.00,5171.61,0.00,0.00,0.00,0.00,765),('1','281','383','1',210.00,210.00,49947.84,0.00,0.00,0.00,0.00,766),('1','281','384','2',820.00,820.00,5909.47,0.00,0.00,0.00,0.00,767),('1','281','384','1',210.00,210.00,48542.43,0.00,0.00,0.00,0.00,768),('1','281','385','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,769),('1','281','385','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,770);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB AUTO_INCREMENT=155 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
INSERT INTO `depots_shifts_stocklevels` VALUES (1,'1','281','1','2022-08-19 17:01:50','943','1',185.00,48800.00,9028000.00),(2,'1','281','22','2022-08-22 05:58:42','943','2',800.00,6800.00,5440000.00),(3,'1','281','22','2022-08-22 05:59:22','943','1',185.00,49400.00,9139000.00),(4,'1','281','24','2022-08-22 22:13:02','943','1',185.00,53600.00,9916000.00),(5,'1','281','24','2022-08-22 22:13:35','943','2',800.00,6050.00,4840000.00),(6,'1','281','26','2022-08-23 22:39:22','943','1',185.00,13350.00,2469750.00),(7,'1','281','26','2022-08-23 22:40:12','943','2',800.00,4200.00,3360000.00),(8,'1','281','28','2022-08-24 22:42:20','943','1',185.00,40850.00,7557250.00),(9,'1','281','28','2022-08-24 22:43:28','943','2',800.00,17450.00,13960000.00),(10,'1','281','30','2022-08-25 21:04:55','943','1',185.00,43800.00,8103000.00),(11,'1','281','30','2022-08-25 21:05:33','943','2',800.00,16400.00,13120000.00),(12,'1','281','32','2022-08-26 20:07:04','943','1',185.00,66400.00,12284000.00),(13,'1','281','32','2022-08-26 20:07:56','943','2',800.00,16200.00,12960000.00),(14,'1','281','34','2022-08-27 20:39:08','943','1',185.00,68250.00,12626250.00),(15,'1','281','34','2022-08-27 20:39:36','943','2',800.00,15400.00,12320000.00),(16,'1','281','36','2022-08-28 19:56:35','943','1',185.00,29950.00,5540750.00),(17,'1','281','36','2022-08-28 19:57:04','943','2',800.00,15050.00,12040000.00),(18,'1','281','38','2022-08-29 20:19:42','943','1',185.00,43000.00,7955000.00),(19,'1','281','38','2022-08-29 20:20:59','943','2',800.00,14700.00,11760000.00),(20,'1','281','41','2022-08-31 07:54:15','943','1',185.00,50700.00,9379500.00),(21,'1','281','41','2022-08-31 07:54:38','943','2',800.00,14500.00,11600000.00),(22,'1','281','42','2022-08-31 20:44:36','943','1',185.00,52800.00,9768000.00),(23,'1','281','42','2022-08-31 20:45:08','943','2',800.00,13300.00,10640000.00),(24,'1','281','44','2022-09-01 22:57:24','943','1',185.00,47450.00,8778250.00),(25,'1','281','44','2022-09-01 22:57:51','943','2',800.00,13200.00,10560000.00),(26,'1','281','47','2022-09-03 11:06:46','943','1',185.00,59350.00,10979750.00),(27,'1','281','47','2022-09-03 11:07:19','943','2',800.00,11000.00,8800000.00),(28,'1','281','48','2022-09-03 23:22:45','943','1',185.00,76850.00,14217250.00),(29,'1','281','48','2022-09-03 23:23:27','943','2',800.00,10400.00,8320000.00),(30,'1','281','50','2022-09-04 20:47:35','943','1',185.00,36350.00,6724750.00),(31,'1','281','50','2022-09-04 20:48:28','943','2',800.00,9000.00,7200000.00),(32,'1','281','53','2022-09-06 10:12:56','943','1',185.00,73900.00,13671500.00),(33,'1','281','53','2022-09-06 10:13:33','943','2',800.00,7700.00,6160000.00),(34,'1','281','54','2022-09-06 21:13:27','943','1',185.00,27550.00,5096750.00),(35,'1','281','54','2022-09-06 21:13:56','943','2',800.00,5200.00,4160000.00),(36,'1','281','56','2022-09-08 07:52:00','943','1',185.00,34450.00,6373250.00),(37,'1','281','56','2022-09-08 07:52:30','943','2',800.00,3450.00,2760000.00),(38,'1','281','58','2022-09-08 21:43:30','943','1',185.00,40300.00,7455500.00),(39,'1','281','58','2022-09-08 21:44:45','943','2',800.00,16800.00,13440000.00),(40,'1','281','60','2022-09-09 21:20:09','943','1',185.00,37150.00,6872750.00),(41,'1','281','60','2022-09-09 21:20:46','943','2',800.00,14000.00,11200000.00),(42,'1','281','62','2022-09-10 22:13:53','943','1',185.00,47600.00,8806000.00),(43,'1','281','62','2022-09-10 22:15:29','943','2',800.00,13000.00,10400000.00),(44,'1','281','64','2022-09-11 19:32:25','943','1',185.00,9000.00,1665000.00),(45,'1','281','64','2022-09-11 19:33:20','943','2',790.00,11550.00,9124500.00),(46,'1','281','66','2022-09-12 23:19:48','943','1',185.00,61100.00,11303500.00),(47,'1','281','66','2022-09-12 23:20:33','943','2',790.00,11000.00,8690000.00),(48,'1','281','69','2022-09-14 09:04:42','943','1',185.00,67450.00,12478250.00),(49,'1','281','69','2022-09-14 09:05:05','943','2',790.00,7700.00,6083000.00),(50,'1','281','70','2022-09-14 21:13:15','943','1',185.00,43250.00,8001250.00),(51,'1','281','70','2022-09-14 21:14:10','943','2',790.00,2900.00,2291000.00),(52,'1','281','72','2022-09-15 21:06:41','943','1',185.00,60250.00,11146250.00),(53,'1','281','72','2022-09-15 21:07:07','943','2',790.00,2300.00,1817000.00),(54,'1','281','73','2022-09-16 15:20:27','943','1',185.00,60250.00,11146250.00),(55,'1','281','73','2022-09-16 15:28:54','943','2',790.00,2300.00,1817000.00),(56,'1','281','74','2022-09-16 23:48:07','943','1',185.00,44050.00,8149250.00),(57,'1','281','74','2022-09-17 00:18:34','943','2',790.00,14900.00,11771000.00),(58,'1','281','75','2022-09-17 09:29:46','943','1',185.00,45050.00,8334250.00),(59,'1','281','75','2022-09-17 09:30:21','943','2',790.00,14900.00,11771000.00),(60,'1','281','77','2022-09-18 10:35:23','943','1',185.00,62100.00,11488500.00),(61,'1','281','77','2022-09-18 10:35:56','943','2',790.00,12100.00,9559000.00),(62,'1','281','79','2022-09-19 09:43:51','943','1',185.00,27200.00,5032000.00),(63,'1','281','79','2022-09-19 09:44:50','943','2',790.00,11950.00,9440500.00),(64,'1','281','80','2022-09-19 23:07:13','943','1',185.00,54050.00,9999250.00),(65,'1','281','80','2022-09-19 23:07:42','943','2',790.00,9300.00,7347000.00),(66,'1','281','82','2022-09-20 23:11:34','943','1',185.00,45800.00,8473000.00),(67,'1','281','82','2022-09-20 23:12:08','943','2',790.00,8500.00,6715000.00),(68,'1','281','85','2022-09-22 10:54:39','943','1',185.00,23400.00,4329000.00),(69,'1','281','85','2022-09-22 10:55:09','943','2',790.00,6700.00,5293000.00),(70,'1','281','86','2022-09-22 21:22:03','943','1',185.00,48900.00,9046500.00),(71,'1','281','86','2022-09-22 21:22:39','943','2',790.00,4450.00,3515500.00),(72,'1','281','88','2022-09-23 21:18:01','943','1',185.00,34350.00,6354750.00),(73,'1','281','88','2022-09-23 21:18:19','943','2',790.00,2250.00,1777500.00),(74,'1','281','90','2022-09-24 21:19:06','943','1',185.00,17150.00,3172750.00),(75,'1','281','90','2022-09-24 21:19:44','943','2',790.00,450.00,355500.00),(76,'1','281','92','2022-09-25 19:45:35','943','1',185.00,28750.00,5318750.00),(77,'1','281','92','2022-09-25 19:46:16','943','2',790.00,350.00,276500.00),(78,'1','281','94','2022-09-26 21:12:14','943','2',800.00,11650.00,9320000.00),(79,'1','281','94','2022-09-26 21:12:42','943','1',185.00,51150.00,9462750.00),(80,'1','281','99','2022-09-28 21:08:10','943','1',185.00,50900.00,9416500.00),(81,'1','281','99','2022-09-28 21:09:27','943','2',805.00,20100.00,16180500.00),(82,'1','281','103','2022-09-30 08:42:51','943','1',185.00,71250.00,13181250.00),(83,'1','281','103','2022-09-30 08:44:26','943','2',815.00,17650.00,14384750.00),(84,'1','281','104','2022-09-30 23:23:16','943','2',815.00,15050.00,12265750.00),(85,'1','281','104','2022-09-30 23:24:00','943','1',185.00,29100.00,5383500.00),(86,'1','281','106','2022-10-02 07:25:44','943','1',185.00,37700.00,6974500.00),(87,'1','281','106','2022-10-02 07:27:04','943','2',815.00,27050.00,22045750.00),(88,'1','281','108','2022-10-02 22:17:21','943','2',815.00,9900.00,8068500.00),(89,'1','281','108','2022-10-02 22:17:54','943','1',185.00,400.00,74000.00),(90,'1','281','113','2022-10-05 08:27:16','943','1',185.00,45100.00,8343500.00),(91,'1','281','113','2022-10-05 08:27:49','943','2',815.00,6000.00,4890000.00),(92,'1','281','114','2022-10-05 20:56:50','943','1',185.00,43450.00,8038250.00),(93,'1','281','114','2022-10-05 20:57:21','943','2',815.00,3200.00,2608000.00),(94,'1','281','119','2022-10-08 08:48:01','943','1',185.00,49400.00,9139000.00),(95,'1','281','119','2022-10-08 08:48:29','943','2',815.00,250.00,203750.00),(96,'1','281','121','2022-10-09 13:15:57','943','1',185.00,57100.00,10563500.00),(97,'1','281','121','2022-10-09 13:16:42','943','2',815.00,250.00,203750.00),(98,'1','281','123','2022-10-10 08:55:16','943','1',185.00,22650.00,4190250.00),(99,'1','281','123','2022-10-10 08:56:38','943','2',815.00,250.00,203750.00),(100,'1','281','129','2022-10-13 08:29:37','943','1',185.00,40250.00,7446250.00),(101,'1','281','129','2022-10-13 08:30:20','943','2',830.00,19600.00,16268000.00),(102,'1','281','138','2022-10-17 09:30:32','943','1',185.00,13150.00,2432750.00),(103,'1','281','138','2022-10-17 09:30:57','943','2',830.00,10950.00,9088500.00),(104,'1','281','148','2022-10-22 11:21:02','943','2',830.00,13650.00,11329500.00),(105,'1','281','148','2022-10-22 11:21:31','943','1',185.00,29400.00,5439000.00),(106,'1','281','154','2022-10-25 08:54:46','943','2',830.00,23650.00,19629500.00),(107,'1','281','154','2022-10-25 08:55:31','943','1',185.00,60400.00,11174000.00),(108,'1','281','157','2022-10-26 09:20:13','943','2',830.00,19850.00,16475500.00),(109,'1','281','157','2022-10-26 09:21:15','943','1',185.00,64300.00,11895500.00),(110,'1','281','159','2022-10-27 08:35:07','943','1',185.00,35350.00,6539750.00),(111,'1','281','159','2022-10-27 08:35:31','943','2',830.00,18650.00,15479500.00),(112,'1','281','163','2022-10-29 11:10:25','943','2',830.00,14000.00,11620000.00),(113,'1','281','163','2022-10-29 11:10:51','943','1',185.00,17900.00,3311500.00),(114,'1','281','165','2022-10-30 09:18:12','943','1',185.00,20400.00,3774000.00),(115,'1','281','165','2022-10-30 09:18:40','943','2',830.00,13450.00,11163500.00),(116,'1','281','167','2022-10-31 09:02:23','943','2',830.00,11900.00,9877000.00),(117,'1','281','167','2022-10-31 09:04:28','943','1',185.00,40400.00,7474000.00),(118,'1','281','171','2022-11-02 09:30:06','943','2',830.00,4250.00,3527500.00),(119,'1','281','171','2022-11-02 09:30:29','943','1',185.00,400.00,74000.00),(120,'1','281','173','2022-11-03 09:52:47','943','2',830.00,3200.00,2656000.00),(121,'1','281','173','2022-11-03 09:53:28','943','1',185.00,400.00,74000.00),(122,'1','281','181','2022-11-07 14:22:39','943','2',830.00,12900.00,10707000.00),(123,'1','281','181','2022-11-07 14:23:14','943','1',185.00,50200.00,9287000.00),(124,'1','281','181','2022-11-07 14:24:41','943','2',830.00,9300.00,7719000.00),(125,'1','281','181','2022-11-07 14:25:29','943','1',185.00,41350.00,7649750.00),(126,'1','281','181','2022-11-07 14:27:01','943','2',830.00,7550.00,6266500.00),(127,'1','281','181','2022-11-07 14:27:46','943','1',185.00,30100.00,5568500.00),(128,'1','281','183','2022-11-08 09:38:29','943','2',830.00,5850.00,4855500.00),(129,'1','281','183','2022-11-08 09:38:52','943','1',185.00,17000.00,3145000.00),(130,'1','281','187','2022-11-10 10:02:47','943','2',830.00,2350.00,1950500.00),(131,'1','281','187','2022-11-10 10:03:23','943','1',185.00,400.00,74000.00),(132,'1','281','198','2022-11-16 21:57:15','943','2',860.00,11750.00,10105000.00),(133,'1','281','198','2022-11-16 21:57:48','943','1',185.00,47400.00,8769000.00),(134,'1','281','202','2022-11-18 20:23:41','943','2',860.00,3650.00,3139000.00),(135,'1','281','202','2022-11-18 20:24:53','943','1',185.00,30300.00,5605500.00),(136,'1','281','216','2022-11-26 09:27:43','943','1',185.00,34400.00,6364000.00),(137,'1','281','216','2022-11-26 09:28:14','943','2',870.00,7350.00,6394500.00),(138,'1','281','220','2022-11-28 10:30:07','943','2',870.00,4500.00,3915000.00),(139,'1','281','220','2022-11-28 10:30:31','943','1',185.00,400.00,74000.00),(140,'1','281','224','2022-11-30 08:38:21','943','1',185.00,30450.00,5633250.00),(141,'1','281','224','2022-11-30 08:38:39','943','2',880.00,2350.00,2068000.00),(142,'1','281','229','2022-12-03 09:26:18','943','1',185.00,18350.00,3394750.00),(143,'1','281','229','2022-12-03 09:27:15','943','2',880.00,15100.00,13288000.00),(144,'1','281','236','2022-12-06 08:50:04','943','2',900.00,10500.00,9450000.00),(145,'1','281','254','2022-12-17 12:29:53','943','2',880.00,18450.00,16236000.00),(146,'1','281','254','2022-12-17 12:30:32','943','1',185.00,24150.00,4467750.00),(147,'1','281','256','2022-12-18 09:38:26','943','2',880.00,17100.00,15048000.00),(148,'1','281','256','2022-12-18 09:38:50','943','1',185.00,17300.00,3200500.00),(149,'1','281','260','2022-12-20 10:07:02','943','2',880.00,13350.00,11748000.00),(150,'1','281','260','2022-12-20 10:08:39','943','1',185.00,17750.00,3283750.00),(151,'1','281','273','2022-12-27 08:16:56','943','2',880.00,20050.00,17644000.00),(152,'1','281','273','2022-12-27 08:17:23','943','1',185.00,25800.00,4773000.00),(153,'1','281','297','2023-01-08 08:24:30','943','2',880.00,10250.00,9020000.00),(154,'1','281','297','2023-01-08 08:24:52','943','1',185.00,18950.00,3505750.00);
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',1,'281','PMS TANKS','CONTAINING PMS'),('1',2,'281','AGO TANKS','');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','281','1',1,0,'1','PMS TANK 1',60000.00,0.00,NULL,'CONTAING PMS','178','2022-08-18 11:23:07','2022-12-14 15:41:01','634',5,0),('1','281','1',2,0,'1','PMS TANK 2',60000.00,0.00,NULL,'CONTAING PMS','178','2022-08-18 11:26:46','2022-12-14 15:41:25','634',5,0),('1','281','2',3,0,'2','AGO TANK 1',43000.00,0.00,NULL,'CONTAING AGO','178','2022-08-18 11:29:42','2022-08-18 11:29:42','178',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','281',3,33917.72,'2023-03-20 22:28:31'),(2,'1','281',2,28933.24,'2023-03-20 22:28:31'),(3,'1','281',1,21367.78,'2023-03-20 22:28:31');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=4305 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9028000.00,48800.00,0.00,0.00,'2022-08-19 11:03:58','',''),(2,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-08-19 11:04:20','',''),(3,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9250000.00,50000.00,0.00,0.00,'2022-08-19 11:04:38','',''),(4,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-08-19 11:04:52','',''),(5,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-08-19 11:05:08','',''),(6,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9250000.00,50000.00,0.00,0.00,'2022-08-19 11:05:42','',''),(7,'1','281',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,12150000.00,15000.00,0.00,0.00,'2022-08-19 11:06:31','',''),(8,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,11100000.00,60000.00,0.00,0.00,'2022-08-19 11:06:51','',''),(9,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9250000.00,50000.00,0.00,0.00,'2022-08-19 11:07:10','',''),(10,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,7400000.00,40000.00,0.00,0.00,'2022-08-19 11:08:27','',''),(11,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-08-19 11:08:47','',''),(12,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-08-19 11:09:08','',''),(13,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,5550000.00,30000.00,0.00,0.00,'2022-08-19 11:09:25','',''),(14,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-08-19 11:10:07','',''),(15,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,7400000.00,40000.00,0.00,0.00,'2022-08-19 11:10:26','',''),(16,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-08-19 11:10:35','',''),(17,'1','281',NULL,1,'Reception corrector for bridging 1',0.00,0.00,0.00,34800.00,0.00,'2022-08-19 16:49:54','',''),(18,'1','281','1',1,'Received from bridging 1',0.00,0.00,34800.00,0.00,0.00,'2022-08-19 16:49:54','',''),(19,'1','281',NULL,1,'Reception corrector for bridging 2',0.00,0.00,0.00,14000.00,0.00,'2022-08-19 16:50:27','',''),(20,'1','281','2',1,'Received from bridging 2',0.00,0.00,14000.00,0.00,0.00,'2022-08-19 16:50:27','',''),(21,'1','281','1',1,'Sale Id shift 1',0.00,0.00,0.00,0.07,0.00,'2022-08-19 17:17:30','',''),(22,'1','281','1',1,'Sale Id shift 1',0.00,0.00,0.00,5052.59,0.00,'2022-08-19 17:17:30','',''),(23,'1','281','1',1,'Sale Id shift 1',0.00,0.00,0.00,2998.69,0.00,'2022-08-19 17:17:30','',''),(24,'1','281','1',1,'Sale Id shift 1',0.00,0.00,0.00,2577.48,0.00,'2022-08-19 17:17:30','',''),(25,'1','281','1',1,'Sale Id shift 1',0.00,0.00,0.00,4541.52,0.00,'2022-08-19 17:17:30','',''),(26,'1','281','1',1,'Sale Id shift 1',0.00,0.00,0.00,824.16,0.00,'2022-08-19 17:17:30','',''),(27,'1','281','2',1,'Sale Id shift 1',0.00,0.00,0.00,299.63,0.00,'2022-08-19 17:17:30','',''),(28,'1','281','2',1,'Sale Id shift 1',0.00,0.00,0.00,3620.59,0.00,'2022-08-19 17:17:30','',''),(29,'1','281','2',1,'Sale Id shift 1',0.00,0.00,0.00,4752.77,0.00,'2022-08-19 17:17:30','',''),(30,'1','281','2',1,'Sale Id shift 1',0.00,0.00,0.00,433.70,0.00,'2022-08-19 17:17:30','',''),(31,'1','281','2',1,'Sale Id shift 1',0.00,0.00,0.00,4541.69,0.00,'2022-08-19 17:17:30','',''),(32,'1','281','2',1,'Sale Id shift 1',0.00,0.00,0.00,0.37,0.00,'2022-08-19 17:17:30','',''),(33,'1','281',NULL,1,'Sale Id shift 1',5484003.10,0.00,0.00,0.00,0.00,'2022-08-19 17:17:30','',''),(34,'1','281',NULL,1,'Reception corrector for bridging 4',0.00,0.00,0.00,15000.00,0.00,'2022-08-19 17:32:56','',''),(35,'1','281','2',1,'Received from bridging 4',0.00,0.00,15000.00,0.00,0.00,'2022-08-19 17:32:56','',''),(36,'1','281',NULL,1,'Reception corrector for bridging 6',0.00,0.00,0.00,27000.00,0.00,'2022-08-19 17:41:42','',''),(37,'1','281','2',1,'Received from bridging 6',0.00,0.00,27000.00,0.00,0.00,'2022-08-19 17:41:42','',''),(38,'1','281',NULL,1,'Reception corrector for bridging 5',0.00,0.00,0.00,23000.00,0.00,'2022-08-19 17:42:08','',''),(39,'1','281','1',1,'Received from bridging 5',0.00,0.00,23000.00,0.00,0.00,'2022-08-19 17:42:08','',''),(40,'1','281','1',1,'Sale Id shift 2',0.00,0.00,0.00,6091.73,0.00,'2022-08-19 18:08:09','',''),(41,'1','281','1',1,'Sale Id shift 2',0.00,0.00,0.00,5802.83,0.00,'2022-08-19 18:08:09','',''),(42,'1','281','1',1,'Sale Id shift 2',0.00,0.00,0.00,5497.15,0.00,'2022-08-19 18:08:09','',''),(43,'1','281','1',1,'Sale Id shift 2',0.00,0.00,0.00,4467.17,0.00,'2022-08-19 18:08:09','',''),(44,'1','281','1',1,'Sale Id shift 2',0.00,0.00,0.00,5454.00,0.00,'2022-08-19 18:08:09','',''),(45,'1','281','1',1,'Sale Id shift 2',0.00,0.00,0.00,4989.89,0.00,'2022-08-19 18:08:09','',''),(46,'1','281','2',1,'Sale Id shift 2',0.00,0.00,0.00,8143.82,0.00,'2022-08-19 18:08:09','',''),(47,'1','281','2',1,'Sale Id shift 2',0.00,0.00,0.00,7245.58,0.00,'2022-08-19 18:08:09','',''),(48,'1','281','2',1,'Sale Id shift 2',0.00,0.00,0.00,4278.24,0.00,'2022-08-19 18:08:09','',''),(49,'1','281','2',1,'Sale Id shift 2',0.00,0.00,0.00,7077.45,0.00,'2022-08-19 18:08:09','',''),(50,'1','281','2',1,'Sale Id shift 2',0.00,0.00,0.00,4271.18,0.00,'2022-08-19 18:08:09','',''),(51,'1','281',NULL,1,'Sale Id shift 2',11714022.40,0.00,0.00,0.00,0.00,'2022-08-19 18:08:09','',''),(52,'1','281',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,30000.00,0.00,'2022-08-19 20:08:55','',''),(53,'1','281','1',1,'Received from bridging 3',0.00,0.00,30000.00,0.00,0.00,'2022-08-19 20:08:55','',''),(54,'1','281',NULL,1,'Reception corrector for bridging 7',0.00,0.00,0.00,8000.00,0.00,'2022-08-19 20:16:05','',''),(55,'1','281','1',1,'Received from bridging 7',0.00,0.00,8000.00,0.00,0.00,'2022-08-19 20:16:05','',''),(56,'1','281',NULL,1,'Reception corrector for bridging 8',0.00,0.00,0.00,32000.00,0.00,'2022-08-19 20:17:15','',''),(57,'1','281','2',1,'Received from bridging 8',0.00,0.00,32000.00,0.00,0.00,'2022-08-19 20:17:15','',''),(58,'1','281','1',1,'Sale Id shift 3',0.00,0.00,0.00,2789.09,0.00,'2022-08-20 11:15:15','',''),(59,'1','281','2',1,'Sale Id shift 3',0.00,0.00,0.00,2577.87,0.00,'2022-08-20 11:15:15','',''),(60,'1','281','2',1,'Sale Id shift 3',0.00,0.00,0.00,7045.86,0.00,'2022-08-20 11:15:15','',''),(61,'1','281','2',1,'Sale Id shift 3',0.00,0.00,0.00,4955.78,0.00,'2022-08-20 11:15:15','',''),(62,'1','281','1',1,'Sale Id shift 3',0.00,0.00,0.00,2794.46,0.00,'2022-08-20 11:15:15','',''),(63,'1','281','1',1,'Sale Id shift 3',0.00,0.00,0.00,5884.63,0.00,'2022-08-20 11:15:15','',''),(64,'1','281','1',1,'Sale Id shift 3',0.00,0.00,0.00,5989.64,0.00,'2022-08-20 11:15:15','',''),(65,'1','281','1',1,'Sale Id shift 3',0.00,0.00,0.00,3194.25,0.00,'2022-08-20 11:15:15','',''),(66,'1','281','1',1,'Sale Id shift 3',0.00,0.00,0.00,2544.17,0.00,'2022-08-20 11:15:15','',''),(67,'1','281','2',1,'Sale Id shift 3',0.00,0.00,0.00,4.87,0.00,'2022-08-20 11:15:15','',''),(68,'1','281','2',1,'Sale Id shift 3',0.00,0.00,0.00,9006.23,0.00,'2022-08-20 11:15:15','',''),(69,'1','281','2',1,'Sale Id shift 3',0.00,0.00,0.00,3150.39,0.00,'2022-08-20 11:15:15','',''),(70,'1','281',NULL,1,'Sale Id shift 3',9238389.40,0.00,0.00,0.00,0.00,'2022-08-20 11:15:15','',''),(71,'1','281',NULL,1,'Reception corrector for bridging 9',0.00,0.00,0.00,5000.00,0.00,'2022-08-20 11:30:31','',''),(72,'1','281','1',1,'Received from bridging 9',0.00,0.00,5000.00,0.00,0.00,'2022-08-20 11:30:31','',''),(73,'1','281',NULL,1,'Reception corrector for bridging 11',0.00,0.00,0.00,30000.00,0.00,'2022-08-20 11:32:48','',''),(74,'1','281','2',1,'Received from bridging 11',0.00,0.00,30000.00,0.00,0.00,'2022-08-20 11:32:48','',''),(75,'1','281',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,15000.00,0.00,'2022-08-20 11:33:17','',''),(76,'1','281','1',1,'Received from bridging 10',0.00,0.00,15000.00,0.00,0.00,'2022-08-20 11:33:17','',''),(77,'1','281','1',1,'Sale Id shift 4',0.00,0.00,0.00,4353.94,0.00,'2022-08-20 11:35:39','',''),(78,'1','281','2',1,'Sale Id shift 4',0.00,0.00,0.00,2570.52,0.00,'2022-08-20 11:35:39','',''),(79,'1','281','2',1,'Sale Id shift 4',0.00,0.00,0.00,5266.78,0.00,'2022-08-20 11:35:39','',''),(80,'1','281','2',1,'Sale Id shift 4',0.00,0.00,0.00,2899.95,0.00,'2022-08-20 11:35:39','',''),(81,'1','281','1',1,'Sale Id shift 4',0.00,0.00,0.00,4212.62,0.00,'2022-08-20 11:35:39','',''),(82,'1','281','1',1,'Sale Id shift 4',0.00,0.00,0.00,3357.87,0.00,'2022-08-20 11:35:39','',''),(83,'1','281','1',1,'Sale Id shift 4',0.00,0.00,0.00,3203.14,0.00,'2022-08-20 11:35:39','',''),(84,'1','281','1',1,'Sale Id shift 4',0.00,0.00,0.00,4571.66,0.00,'2022-08-20 11:35:39','',''),(85,'1','281','1',1,'Sale Id shift 4',0.00,0.00,0.00,3103.38,0.00,'2022-08-20 11:35:39','',''),(86,'1','281','2',1,'Sale Id shift 4',0.00,0.00,0.00,6241.76,0.00,'2022-08-20 11:35:39','',''),(87,'1','281','2',1,'Sale Id shift 4',0.00,0.00,0.00,5107.00,0.00,'2022-08-20 11:35:39','',''),(88,'1','281',NULL,1,'Sale Id shift 4',8304394.70,0.00,0.00,0.00,0.00,'2022-08-20 11:35:39','',''),(89,'1','281',NULL,1,'Reception corrector for bridging 13',0.00,0.00,0.00,23000.00,0.00,'2022-08-20 12:04:37','',''),(90,'1','281','2',1,'Received from bridging 13',0.00,0.00,23000.00,0.00,0.00,'2022-08-20 12:04:37','',''),(91,'1','281',NULL,1,'Reception corrector for bridging 12',0.00,0.00,0.00,26000.00,0.00,'2022-08-20 12:04:56','',''),(92,'1','281','1',1,'Received from bridging 12',0.00,0.00,26000.00,0.00,0.00,'2022-08-20 12:04:56','',''),(93,'1','281','1',1,'Sale Id shift 5',0.00,0.00,0.00,5553.71,0.00,'2022-08-20 12:18:05','',''),(94,'1','281','2',1,'Sale Id shift 5',0.00,0.00,0.00,4176.13,0.00,'2022-08-20 12:18:05','',''),(95,'1','281','2',1,'Sale Id shift 5',0.00,0.00,0.00,4327.78,0.00,'2022-08-20 12:18:05','',''),(96,'1','281','2',1,'Sale Id shift 5',0.00,0.00,0.00,2270.74,0.00,'2022-08-20 12:18:05','',''),(97,'1','281','1',1,'Sale Id shift 5',0.00,0.00,0.00,5115.48,0.00,'2022-08-20 12:18:05','',''),(98,'1','281','1',1,'Sale Id shift 5',0.00,0.00,0.00,3125.35,0.00,'2022-08-20 12:18:05','',''),(99,'1','281','1',1,'Sale Id shift 5',0.00,0.00,0.00,2863.19,0.00,'2022-08-20 12:18:05','',''),(100,'1','281','1',1,'Sale Id shift 5',0.00,0.00,0.00,5537.20,0.00,'2022-08-20 12:18:05','',''),(101,'1','281','1',1,'Sale Id shift 5',0.00,0.00,0.00,4207.57,0.00,'2022-08-20 12:18:05','',''),(102,'1','281','2',1,'Sale Id shift 5',0.00,0.00,0.00,37.62,0.00,'2022-08-20 12:18:05','',''),(103,'1','281','2',1,'Sale Id shift 5',0.00,0.00,0.00,2727.60,0.00,'2022-08-20 12:18:05','',''),(104,'1','281','2',1,'Sale Id shift 5',0.00,0.00,0.00,5326.34,0.00,'2022-08-20 12:18:05','',''),(105,'1','281',NULL,1,'Sale Id shift 5',8374711.35,0.00,0.00,0.00,0.00,'2022-08-20 12:18:05','',''),(106,'1','281',NULL,1,'Reception corrector for bridging 14',0.00,0.00,0.00,1000.00,0.00,'2022-08-20 12:44:06','',''),(107,'1','281','1',1,'Received from bridging 14',0.00,0.00,1000.00,0.00,0.00,'2022-08-20 12:44:06','',''),(108,'1','281',NULL,2,'Reception corrector for bridging 15',0.00,0.00,0.00,15000.00,0.00,'2022-08-20 12:45:54','',''),(109,'1','281','3',2,'Received from bridging 15',0.00,0.00,15000.00,0.00,0.00,'2022-08-20 12:45:54','',''),(110,'1','281',NULL,1,'Reception corrector for bridging 16',0.00,0.00,0.00,25000.00,0.00,'2022-08-20 12:48:12','',''),(111,'1','281','1',1,'Received from bridging 16',0.00,0.00,25000.00,0.00,0.00,'2022-08-20 12:48:12','',''),(112,'1','281',NULL,1,'Reception corrector for bridging 17',0.00,0.00,0.00,19000.00,0.00,'2022-08-20 12:48:41','',''),(113,'1','281','2',1,'Received from bridging 17',0.00,0.00,19000.00,0.00,0.00,'2022-08-20 12:48:41','',''),(114,'1','281','1',1,'Sale Id shift 6',0.00,0.00,0.00,3882.72,0.00,'2022-08-20 13:32:08','',''),(115,'1','281','2',1,'Sale Id shift 6',0.00,0.00,0.00,2705.79,0.00,'2022-08-20 13:32:08','',''),(116,'1','281','2',1,'Sale Id shift 6',0.00,0.00,0.00,7230.96,0.00,'2022-08-20 13:32:08','',''),(117,'1','281','2',1,'Sale Id shift 6',0.00,0.00,0.00,5861.40,0.00,'2022-08-20 13:32:08','',''),(118,'1','281','1',1,'Sale Id shift 6',0.00,0.00,0.00,3238.03,0.00,'2022-08-20 13:32:08','',''),(119,'1','281','1',1,'Sale Id shift 6',0.00,0.00,0.00,6297.78,0.00,'2022-08-20 13:32:08','',''),(120,'1','281','1',1,'Sale Id shift 6',0.00,0.00,0.00,5771.35,0.00,'2022-08-20 13:32:08','',''),(121,'1','281','1',1,'Sale Id shift 6',0.00,0.00,0.00,2586.87,0.00,'2022-08-20 13:32:08','',''),(122,'1','281','2',1,'Sale Id shift 6',0.00,0.00,0.00,8262.57,0.00,'2022-08-20 13:32:08','',''),(123,'1','281','2',1,'Sale Id shift 6',0.00,0.00,0.00,3589.85,0.00,'2022-08-20 13:32:08','',''),(124,'1','281',NULL,1,'Sale Id shift 6',9144054.20,0.00,0.00,0.00,0.00,'2022-08-20 13:32:08','',''),(125,'1','281',NULL,1,'Reception corrector for bridging 18',0.00,0.00,0.00,16000.00,0.00,'2022-08-20 13:43:48','',''),(126,'1','281','1',1,'Received from bridging 18',0.00,0.00,16000.00,0.00,0.00,'2022-08-20 13:43:48','',''),(127,'1','281',NULL,1,'Reception corrector for bridging 19',0.00,0.00,0.00,6000.00,0.00,'2022-08-20 13:45:50','',''),(128,'1','281','1',1,'Received from bridging 19',0.00,0.00,6000.00,0.00,0.00,'2022-08-20 13:45:50','',''),(129,'1','281',NULL,1,'Reception corrector for bridging 20',0.00,0.00,0.00,28000.00,0.00,'2022-08-20 13:46:07','',''),(130,'1','281','2',1,'Received from bridging 20',0.00,0.00,28000.00,0.00,0.00,'2022-08-20 13:46:07','',''),(131,'1','281','1',1,'Sale Id shift 7',0.00,0.00,0.00,5263.05,0.00,'2022-08-20 14:01:51','',''),(132,'1','281','2',1,'Sale Id shift 7',0.00,0.00,0.00,5714.63,0.00,'2022-08-20 14:01:51','',''),(133,'1','281','2',1,'Sale Id shift 7',0.00,0.00,0.00,4317.75,0.00,'2022-08-20 14:01:51','',''),(134,'1','281','2',1,'Sale Id shift 7',0.00,0.00,0.00,2757.29,0.00,'2022-08-20 14:01:51','',''),(135,'1','281','1',1,'Sale Id shift 7',0.00,0.00,0.00,4554.64,0.00,'2022-08-20 14:01:51','',''),(136,'1','281','1',1,'Sale Id shift 7',0.00,0.00,0.00,3394.87,0.00,'2022-08-20 14:01:51','',''),(137,'1','281','1',1,'Sale Id shift 7',0.00,0.00,0.00,3619.47,0.00,'2022-08-20 14:01:51','',''),(138,'1','281','1',1,'Sale Id shift 7',0.00,0.00,0.00,4243.16,0.00,'2022-08-20 14:01:51','',''),(139,'1','281','1',1,'Sale Id shift 7',0.00,0.00,0.00,3818.60,0.00,'2022-08-20 14:01:51','',''),(140,'1','281','2',1,'Sale Id shift 7',0.00,0.00,0.00,6685.05,0.00,'2022-08-20 14:01:51','',''),(141,'1','281','2',1,'Sale Id shift 7',0.00,0.00,0.00,3015.62,0.00,'2022-08-20 14:01:51','',''),(142,'1','281',NULL,1,'Sale Id shift 7',8766064.05,0.00,0.00,0.00,0.00,'2022-08-20 14:01:51','',''),(143,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9287000.00,50200.00,0.00,0.00,'2022-08-20 14:03:46','',''),(144,'1','281',NULL,1,'Reception corrector for bridging 21',0.00,0.00,0.00,16000.00,0.00,'2022-08-20 14:14:02','',''),(145,'1','281','1',1,'Received from bridging 21',0.00,0.00,16000.00,0.00,0.00,'2022-08-20 14:14:02','',''),(146,'1','281',NULL,1,'Reception corrector for bridging 23',0.00,0.00,0.00,22000.00,0.00,'2022-08-20 14:15:25','',''),(147,'1','281','2',1,'Received from bridging 23',0.00,0.00,22000.00,0.00,0.00,'2022-08-20 14:15:25','',''),(148,'1','281',NULL,1,'Reception corrector for bridging 22',0.00,0.00,0.00,9000.00,0.00,'2022-08-20 14:15:42','',''),(149,'1','281','1',1,'Received from bridging 22',0.00,0.00,9000.00,0.00,0.00,'2022-08-20 14:15:42','',''),(150,'1','281','1',1,'Sale Id shift 8',0.00,0.00,0.00,2615.22,0.00,'2022-08-20 14:33:44','',''),(151,'1','281','2',1,'Sale Id shift 8',0.00,0.00,0.00,2474.48,0.00,'2022-08-20 14:33:44','',''),(152,'1','281','1',1,'Sale Id shift 8',0.00,0.00,0.00,1988.13,0.00,'2022-08-20 14:33:44','',''),(153,'1','281','1',1,'Sale Id shift 8',0.00,0.00,0.00,2456.64,0.00,'2022-08-20 14:33:44','',''),(154,'1','281','1',1,'Sale Id shift 8',0.00,0.00,0.00,2151.62,0.00,'2022-08-20 14:33:44','',''),(155,'1','281','2',1,'Sale Id shift 8',0.00,0.00,0.00,1591.40,0.00,'2022-08-20 14:33:44','',''),(156,'1','281',NULL,1,'Sale Id shift 8',2456335.65,0.00,0.00,0.00,0.00,'2022-08-20 14:33:44','',''),(157,'1','281',NULL,1,'Reception corrector for bridging 24',0.00,0.00,0.00,9000.00,0.00,'2022-08-20 14:39:17','',''),(158,'1','281','1',1,'Received from bridging 24',0.00,0.00,9000.00,0.00,0.00,'2022-08-20 14:39:17','',''),(159,'1','281','1',1,'Sale Id shift 9',0.00,0.00,0.00,5103.76,0.00,'2022-08-20 14:57:52','',''),(160,'1','281','2',1,'Sale Id shift 9',0.00,0.00,0.00,4205.14,0.00,'2022-08-20 14:57:52','',''),(161,'1','281','2',1,'Sale Id shift 9',0.00,0.00,0.00,5784.05,0.00,'2022-08-20 14:57:52','',''),(162,'1','281','2',1,'Sale Id shift 9',0.00,0.00,0.00,5489.49,0.00,'2022-08-20 14:57:52','',''),(163,'1','281','1',1,'Sale Id shift 9',0.00,0.00,0.00,7431.34,0.00,'2022-08-20 14:57:52','',''),(164,'1','281','1',1,'Sale Id shift 9',0.00,0.00,0.00,5515.05,0.00,'2022-08-20 14:57:52','',''),(165,'1','281','1',1,'Sale Id shift 9',0.00,0.00,0.00,4913.42,0.00,'2022-08-20 14:57:52','',''),(166,'1','281','2',1,'Sale Id shift 9',0.00,0.00,0.00,8838.32,0.00,'2022-08-20 14:57:52','',''),(167,'1','281','2',1,'Sale Id shift 9',0.00,0.00,0.00,2614.12,0.00,'2022-08-20 14:57:52','',''),(168,'1','281',NULL,1,'Sale Id shift 9',9230517.65,0.00,0.00,0.00,0.00,'2022-08-20 14:57:52','',''),(169,'1','281',NULL,1,'Reception corrector for bridging 26',0.00,0.00,0.00,25000.00,0.00,'2022-08-20 15:17:00','',''),(170,'1','281','2',1,'Received from bridging 26',0.00,0.00,25000.00,0.00,0.00,'2022-08-20 15:17:00','',''),(171,'1','281',NULL,1,'Reception corrector for bridging 25',0.00,0.00,0.00,20000.00,0.00,'2022-08-20 15:17:17','',''),(172,'1','281','1',1,'Received from bridging 25',0.00,0.00,20000.00,0.00,0.00,'2022-08-20 15:17:17','',''),(173,'1','281','1',1,'Sale Id shift 10',0.00,0.00,0.00,4089.38,0.00,'2022-08-20 15:34:55','',''),(174,'1','281','2',1,'Sale Id shift 10',0.00,0.00,0.00,4150.27,0.00,'2022-08-20 15:34:55','',''),(175,'1','281','2',1,'Sale Id shift 10',0.00,0.00,0.00,4585.94,0.00,'2022-08-20 15:34:55','',''),(176,'1','281','2',1,'Sale Id shift 10',0.00,0.00,0.00,3279.24,0.00,'2022-08-20 15:34:55','',''),(177,'1','281','3',2,'Sale Id shift 10',0.00,0.00,0.00,268.67,0.00,'2022-08-20 15:34:55','',''),(178,'1','281','3',2,'Sale Id shift 10',0.00,0.00,0.00,92.00,0.00,'2022-08-20 15:34:55','',''),(179,'1','281','1',1,'Sale Id shift 10',0.00,0.00,0.00,4271.45,0.00,'2022-08-20 15:34:55','',''),(180,'1','281','1',1,'Sale Id shift 10',0.00,0.00,0.00,3626.63,0.00,'2022-08-20 15:34:55','',''),(181,'1','281','1',1,'Sale Id shift 10',0.00,0.00,0.00,3191.14,0.00,'2022-08-20 15:34:55','',''),(182,'1','281','1',1,'Sale Id shift 10',0.00,0.00,0.00,5177.40,0.00,'2022-08-20 15:34:55','',''),(183,'1','281','2',1,'Sale Id shift 10',0.00,0.00,0.00,4509.01,0.00,'2022-08-20 15:34:55','',''),(184,'1','281','2',1,'Sale Id shift 10',0.00,0.00,0.00,2273.20,0.00,'2022-08-20 15:34:55','',''),(185,'1','281',NULL,2,'Sale Id shift 10',292142.70,0.00,0.00,0.00,0.00,'2022-08-20 15:34:55','',''),(186,'1','281',NULL,1,'Sale Id shift 10',7243427.10,0.00,0.00,0.00,0.00,'2022-08-20 15:34:55','',''),(187,'1','281',NULL,1,'Reception corrector for bridging 27',0.00,0.00,0.00,20000.00,0.00,'2022-08-20 15:36:19','',''),(188,'1','281','1',1,'Received from bridging 27',0.00,0.00,20000.00,0.00,0.00,'2022-08-20 15:36:19','',''),(189,'1','281',NULL,1,'Reception corrector for bridging 28',0.00,0.00,0.00,25000.00,0.00,'2022-08-20 15:36:38','',''),(190,'1','281','2',1,'Received from bridging 28',0.00,0.00,25000.00,0.00,0.00,'2022-08-20 15:36:38','',''),(191,'1','281','3',2,'Sale Id shift 11',0.00,0.00,0.00,283.19,0.00,'2022-08-20 16:12:18','',''),(192,'1','281','3',2,'Sale Id shift 11',0.00,0.00,0.00,162.25,0.00,'2022-08-20 16:12:18','',''),(193,'1','281',NULL,2,'Sale Id shift 11',360806.40,0.00,0.00,0.00,0.00,'2022-08-20 16:12:18','',''),(194,'1','281','1',1,'Sale Id shift 12',0.00,0.00,0.00,3184.73,0.00,'2022-08-20 17:15:36','',''),(195,'1','281','2',1,'Sale Id shift 12',0.00,0.00,0.00,3531.94,0.00,'2022-08-20 17:15:36','',''),(196,'1','281','2',1,'Sale Id shift 12',0.00,0.00,0.00,6052.73,0.00,'2022-08-20 17:15:36','',''),(197,'1','281','2',1,'Sale Id shift 12',0.00,0.00,0.00,4994.54,0.00,'2022-08-20 17:15:36','',''),(198,'1','281','3',2,'Sale Id shift 12',0.00,0.00,0.00,249.49,0.00,'2022-08-20 17:15:36','',''),(199,'1','281','3',2,'Sale Id shift 12',0.00,0.00,0.00,268.84,0.00,'2022-08-20 17:15:36','',''),(200,'1','281','1',1,'Sale Id shift 12',0.00,0.00,0.00,3139.39,0.00,'2022-08-20 17:15:36','',''),(201,'1','281','1',1,'Sale Id shift 12',0.00,0.00,0.00,5587.21,0.00,'2022-08-20 17:15:36','',''),(202,'1','281','1',1,'Sale Id shift 12',0.00,0.00,0.00,5264.75,0.00,'2022-08-20 17:15:36','',''),(203,'1','281','1',1,'Sale Id shift 12',0.00,0.00,0.00,2966.37,0.00,'2022-08-20 17:15:36','',''),(204,'1','281','1',1,'Sale Id shift 12',0.00,0.00,0.00,1978.83,0.00,'2022-08-20 17:15:36','',''),(205,'1','281','2',1,'Sale Id shift 12',0.00,0.00,0.00,7989.23,0.00,'2022-08-20 17:15:36','',''),(206,'1','281','2',1,'Sale Id shift 12',0.00,0.00,0.00,399.35,0.00,'2022-08-20 17:15:36','',''),(207,'1','281',NULL,2,'Sale Id shift 12',419847.30,0.00,0.00,0.00,0.00,'2022-08-20 17:15:36','',''),(208,'1','281',NULL,1,'Sale Id shift 12',8341477.95,0.00,0.00,0.00,0.00,'2022-08-20 17:15:36','',''),(209,'1','281',NULL,1,'Reception corrector for bridging 29',0.00,0.00,0.00,15000.00,0.00,'2022-08-20 19:10:49','',''),(210,'1','281','1',1,'Received from bridging 29',0.00,0.00,15000.00,0.00,0.00,'2022-08-20 19:10:49','',''),(211,'1','281',NULL,1,'Reception corrector for bridging 30',0.00,0.00,0.00,15000.00,0.00,'2022-08-20 19:11:07','',''),(212,'1','281','2',1,'Received from bridging 30',0.00,0.00,15000.00,0.00,0.00,'2022-08-20 19:11:07','',''),(213,'1','281',NULL,1,'Reception corrector for bridging 31',0.00,0.00,0.00,11000.00,0.00,'2022-08-20 19:13:12','',''),(214,'1','281','1',1,'Received from bridging 31',0.00,0.00,11000.00,0.00,0.00,'2022-08-20 19:13:12','',''),(215,'1','281',NULL,1,'Reception corrector for bridging 32',0.00,0.00,0.00,8000.00,0.00,'2022-08-20 19:13:28','',''),(216,'1','281','2',1,'Received from bridging 32',0.00,0.00,8000.00,0.00,0.00,'2022-08-20 19:13:28','',''),(217,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3052500.00,16500.00,0.00,0.00,'2022-08-21 07:28:46','',''),(218,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-08-21 07:29:13','',''),(219,'1','281','1',1,'Sale Id shift 13',0.00,0.00,0.00,3236.73,0.00,'2022-08-21 09:19:03','',''),(220,'1','281','2',1,'Sale Id shift 13',0.00,0.00,0.00,2934.96,0.00,'2022-08-21 09:19:03','',''),(221,'1','281','2',1,'Sale Id shift 13',0.00,0.00,0.00,7182.71,0.00,'2022-08-21 09:19:03','',''),(222,'1','281','2',1,'Sale Id shift 13',0.00,0.00,0.00,4923.53,0.00,'2022-08-21 09:19:03','',''),(223,'1','281','3',2,'Sale Id shift 13',0.00,0.00,0.00,674.30,0.00,'2022-08-21 09:19:03','',''),(224,'1','281','3',2,'Sale Id shift 13',0.00,0.00,0.00,48.22,0.00,'2022-08-21 09:19:03','',''),(225,'1','281','1',1,'Sale Id shift 13',0.00,0.00,0.00,2341.91,0.00,'2022-08-21 09:19:03','',''),(226,'1','281','1',1,'Sale Id shift 13',0.00,0.00,0.00,5198.78,0.00,'2022-08-21 09:19:03','',''),(227,'1','281','1',1,'Sale Id shift 13',0.00,0.00,0.00,4974.11,0.00,'2022-08-21 09:19:03','',''),(228,'1','281','1',1,'Sale Id shift 13',0.00,0.00,0.00,2364.66,0.00,'2022-08-21 09:19:03','',''),(229,'1','281','1',1,'Sale Id shift 13',0.00,0.00,0.00,2350.25,0.00,'2022-08-21 09:19:03','',''),(230,'1','281','2',1,'Sale Id shift 13',0.00,0.00,0.00,6.56,0.00,'2022-08-21 09:19:03','',''),(231,'1','281','2',1,'Sale Id shift 13',0.00,0.00,0.00,7772.17,0.00,'2022-08-21 09:19:03','',''),(232,'1','281','2',1,'Sale Id shift 13',0.00,0.00,0.00,1748.87,0.00,'2022-08-21 09:19:03','',''),(233,'1','281',NULL,2,'Sale Id shift 13',585241.20,0.00,0.00,0.00,0.00,'2022-08-21 09:19:03','',''),(234,'1','281',NULL,1,'Sale Id shift 13',8331519.40,0.00,0.00,0.00,0.00,'2022-08-21 09:19:03','',''),(235,'1','281',NULL,1,'Reception corrector for bridging 33',0.00,0.00,0.00,20000.00,0.00,'2022-08-21 09:30:38','',''),(236,'1','281','1',1,'Received from bridging 33',0.00,0.00,20000.00,0.00,0.00,'2022-08-21 09:30:38','',''),(237,'1','281',NULL,1,'Reception corrector for bridging 34',0.00,0.00,0.00,6000.00,0.00,'2022-08-21 09:31:09','',''),(238,'1','281','2',1,'Received from bridging 34',0.00,0.00,6000.00,0.00,0.00,'2022-08-21 09:31:09','',''),(239,'1','281',NULL,1,'Reception corrector for bridging 35',0.00,0.00,0.00,680.00,0.00,'2022-08-21 09:33:29','',''),(240,'1','281','1',1,'Received from bridging 35',0.00,0.00,680.00,0.00,0.00,'2022-08-21 09:33:29','',''),(241,'1','281',NULL,1,'Reception corrector for bridging 36',0.00,0.00,0.00,18820.00,0.00,'2022-08-21 09:33:47','',''),(242,'1','281','2',1,'Received from bridging 36',0.00,0.00,18820.00,0.00,0.00,'2022-08-21 09:33:47','',''),(243,'1','281','1',1,'Sale Id shift 14',0.00,0.00,0.00,5201.22,0.00,'2022-08-21 09:43:53','',''),(244,'1','281','2',1,'Sale Id shift 14',0.00,0.00,0.00,4947.56,0.00,'2022-08-21 09:43:53','',''),(245,'1','281','3',2,'Sale Id shift 14',0.00,0.00,0.00,57.20,0.00,'2022-08-21 09:43:53','',''),(246,'1','281','1',1,'Sale Id shift 14',0.00,0.00,0.00,5345.86,0.00,'2022-08-21 09:43:53','',''),(247,'1','281','1',1,'Sale Id shift 14',0.00,0.00,0.00,4582.70,0.00,'2022-08-21 09:43:53','',''),(248,'1','281','1',1,'Sale Id shift 14',0.00,0.00,0.00,4620.15,0.00,'2022-08-21 09:43:53','',''),(249,'1','281','2',1,'Sale Id shift 14',0.00,0.00,0.00,5479.30,0.00,'2022-08-21 09:43:53','',''),(250,'1','281',NULL,2,'Sale Id shift 14',46332.00,0.00,0.00,0.00,0.00,'2022-08-21 09:43:53','',''),(251,'1','281',NULL,1,'Sale Id shift 14',5582706.15,0.00,0.00,0.00,0.00,'2022-08-21 09:43:53','',''),(252,'1','281','3',2,'Sale Id shift 15',0.00,0.00,0.00,292.09,0.00,'2022-08-21 10:04:41','',''),(253,'1','281',NULL,2,'Sale Id shift 15',236592.90,0.00,0.00,0.00,0.00,'2022-08-21 10:04:41','',''),(254,'1','281','1',1,'Sale Id shift 16',0.00,0.00,0.00,4372.56,0.00,'2022-08-21 10:18:35','',''),(255,'1','281','2',1,'Sale Id shift 16',0.00,0.00,0.00,2138.26,0.00,'2022-08-21 10:18:35','',''),(256,'1','281','2',1,'Sale Id shift 16',0.00,0.00,0.00,3338.87,0.00,'2022-08-21 10:18:35','',''),(257,'1','281','2',1,'Sale Id shift 16',0.00,0.00,0.00,2487.07,0.00,'2022-08-21 10:18:35','',''),(258,'1','281','3',2,'Sale Id shift 16',0.00,0.00,0.00,257.04,0.00,'2022-08-21 10:18:35','',''),(259,'1','281','3',2,'Sale Id shift 16',0.00,0.00,0.00,96.10,0.00,'2022-08-21 10:18:35','',''),(260,'1','281','1',1,'Sale Id shift 16',0.00,0.00,0.00,5979.62,0.00,'2022-08-21 10:18:35','',''),(261,'1','281','1',1,'Sale Id shift 16',0.00,0.00,0.00,2318.69,0.00,'2022-08-21 10:18:35','',''),(262,'1','281','1',1,'Sale Id shift 16',0.00,0.00,0.00,2672.50,0.00,'2022-08-21 10:18:35','',''),(263,'1','281','1',1,'Sale Id shift 16',0.00,0.00,0.00,5588.21,0.00,'2022-08-21 10:18:35','',''),(264,'1','281','1',1,'Sale Id shift 16',0.00,0.00,0.00,4361.92,0.00,'2022-08-21 10:18:35','',''),(265,'1','281','2',1,'Sale Id shift 16',0.00,0.00,0.00,4345.22,0.00,'2022-08-21 10:18:35','',''),(266,'1','281','2',1,'Sale Id shift 16',0.00,0.00,0.00,7313.42,0.00,'2022-08-21 10:18:35','',''),(267,'1','281',NULL,2,'Sale Id shift 16',286043.40,0.00,0.00,0.00,0.00,'2022-08-21 10:18:35','',''),(268,'1','281',NULL,1,'Sale Id shift 16',8309522.90,0.00,0.00,0.00,0.00,'2022-08-21 10:18:35','',''),(269,'1','281',NULL,1,'Reception corrector for bridging 37',0.00,0.00,0.00,20500.00,0.00,'2022-08-21 10:34:55','',''),(270,'1','281','2',1,'Received from bridging 37',0.00,0.00,20500.00,0.00,0.00,'2022-08-21 10:34:55','',''),(271,'1','281',NULL,1,'Reception corrector for bridging 38',0.00,0.00,0.00,45000.00,0.00,'2022-08-21 10:36:26','',''),(272,'1','281','1',1,'Received from bridging 38',0.00,0.00,45000.00,0.00,0.00,'2022-08-21 10:36:26','',''),(273,'1','281','1',1,'Sale Id shift 17',0.00,0.00,0.00,2335.22,0.00,'2022-08-21 10:42:50','',''),(274,'1','281','2',1,'Sale Id shift 17',0.00,0.00,0.00,1660.67,0.00,'2022-08-21 10:42:50','',''),(275,'1','281','2',1,'Sale Id shift 17',0.00,0.00,0.00,2380.57,0.00,'2022-08-21 10:42:50','',''),(276,'1','281','2',1,'Sale Id shift 17',0.00,0.00,0.00,1695.35,0.00,'2022-08-21 10:42:50','',''),(277,'1','281','3',2,'Sale Id shift 17',0.00,0.00,0.00,192.63,0.00,'2022-08-21 10:42:50','',''),(278,'1','281','1',1,'Sale Id shift 17',0.00,0.00,0.00,2370.77,0.00,'2022-08-21 10:42:50','',''),(279,'1','281','1',1,'Sale Id shift 17',0.00,0.00,0.00,2221.88,0.00,'2022-08-21 10:42:50','',''),(280,'1','281','1',1,'Sale Id shift 17',0.00,0.00,0.00,1745.57,0.00,'2022-08-21 10:42:50','',''),(281,'1','281','1',1,'Sale Id shift 17',0.00,0.00,0.00,1906.15,0.00,'2022-08-21 10:42:50','',''),(282,'1','281','1',1,'Sale Id shift 17',0.00,0.00,0.00,1902.90,0.00,'2022-08-21 10:42:50','',''),(283,'1','281','2',1,'Sale Id shift 17',0.00,0.00,0.00,3465.13,0.00,'2022-08-21 10:42:50','',''),(284,'1','281','2',1,'Sale Id shift 17',0.00,0.00,0.00,2501.51,0.00,'2022-08-21 10:42:50','',''),(285,'1','281',NULL,2,'Sale Id shift 17',156030.30,0.00,0.00,0.00,0.00,'2022-08-21 10:42:50','',''),(286,'1','281',NULL,1,'Sale Id shift 17',4474358.20,0.00,0.00,0.00,0.00,'2022-08-21 10:42:50','',''),(287,'1','281',NULL,1,'Reception corrector for bridging 40',0.00,0.00,0.00,12500.00,0.00,'2022-08-21 10:54:00','',''),(288,'1','281','1',1,'Received from bridging 40',0.00,0.00,12500.00,0.00,0.00,'2022-08-21 10:54:00','',''),(289,'1','281',NULL,1,'Reception corrector for bridging 41',0.00,0.00,0.00,21000.00,0.00,'2022-08-21 10:54:16','',''),(290,'1','281','2',1,'Received from bridging 41',0.00,0.00,21000.00,0.00,0.00,'2022-08-21 10:54:16','',''),(291,'1','281','1',1,'Sale Id shift 19',0.00,0.00,0.00,3797.93,0.00,'2022-08-21 11:26:50','',''),(292,'1','281','2',1,'Sale Id shift 19',0.00,0.00,0.00,2814.87,0.00,'2022-08-21 11:26:50','',''),(293,'1','281','2',1,'Sale Id shift 19',0.00,0.00,0.00,4092.70,0.00,'2022-08-21 11:26:50','',''),(294,'1','281','2',1,'Sale Id shift 19',0.00,0.00,0.00,4080.58,0.00,'2022-08-21 11:26:50','',''),(295,'1','281','3',2,'Sale Id shift 19',0.00,0.00,0.00,1523.67,0.00,'2022-08-21 11:26:50','',''),(296,'1','281','3',2,'Sale Id shift 19',0.00,0.00,0.00,1074.49,0.00,'2022-08-21 11:26:50','',''),(297,'1','281','1',1,'Sale Id shift 19',0.00,0.00,0.00,3743.26,0.00,'2022-08-21 11:26:50','',''),(298,'1','281','1',1,'Sale Id shift 19',0.00,0.00,0.00,4043.95,0.00,'2022-08-21 11:26:50','',''),(299,'1','281','1',1,'Sale Id shift 19',0.00,0.00,0.00,3732.64,0.00,'2022-08-21 11:26:50','',''),(300,'1','281','1',1,'Sale Id shift 19',0.00,0.00,0.00,3577.43,0.00,'2022-08-21 11:26:50','',''),(301,'1','281','1',1,'Sale Id shift 19',0.00,0.00,0.00,3665.57,0.00,'2022-08-21 11:26:50','',''),(302,'1','281','2',1,'Sale Id shift 19',0.00,0.00,0.00,6558.38,0.00,'2022-08-21 11:26:50','',''),(303,'1','281','2',1,'Sale Id shift 19',0.00,0.00,0.00,4326.17,0.00,'2022-08-21 11:26:50','',''),(304,'1','281',NULL,2,'Sale Id shift 19',2078528.00,0.00,0.00,0.00,0.00,'2022-08-21 11:26:50','',''),(305,'1','281',NULL,1,'Sale Id shift 19',8220193.80,0.00,0.00,0.00,0.00,'2022-08-21 11:26:50','',''),(306,'1','281',NULL,1,'Reception corrector for bridging 42',0.00,0.00,0.00,16700.00,0.00,'2022-08-21 11:47:42','',''),(307,'1','281','1',1,'Received from bridging 42',0.00,0.00,16700.00,0.00,0.00,'2022-08-21 11:47:42','',''),(308,'1','281',NULL,1,'Reception corrector for bridging 43',0.00,0.00,0.00,16500.00,0.00,'2022-08-21 11:48:57','',''),(309,'1','281','2',1,'Received from bridging 43',0.00,0.00,16500.00,0.00,0.00,'2022-08-21 11:48:57','',''),(310,'1','281','1',1,'Sale Id shift 20',0.00,0.00,0.00,3151.36,0.00,'2022-08-21 11:58:36','',''),(311,'1','281','2',1,'Sale Id shift 20',0.00,0.00,0.00,2810.95,0.00,'2022-08-21 11:58:36','',''),(312,'1','281','2',1,'Sale Id shift 20',0.00,0.00,0.00,5868.58,0.00,'2022-08-21 11:58:36','',''),(313,'1','281','2',1,'Sale Id shift 20',0.00,0.00,0.00,4528.34,0.00,'2022-08-21 11:58:36','',''),(314,'1','281','3',2,'Sale Id shift 20',0.00,0.00,0.00,414.00,0.00,'2022-08-21 11:58:36','',''),(315,'1','281','3',2,'Sale Id shift 20',0.00,0.00,0.00,139.39,0.00,'2022-08-21 11:58:36','',''),(316,'1','281','1',1,'Sale Id shift 20',0.00,0.00,0.00,4108.38,0.00,'2022-08-21 11:58:36','',''),(317,'1','281','1',1,'Sale Id shift 20',0.00,0.00,0.00,4541.15,0.00,'2022-08-21 11:58:36','',''),(318,'1','281','1',1,'Sale Id shift 20',0.00,0.00,0.00,4220.29,0.00,'2022-08-21 11:58:36','',''),(319,'1','281','1',1,'Sale Id shift 20',0.00,0.00,0.00,3734.89,0.00,'2022-08-21 11:58:36','',''),(320,'1','281','1',1,'Sale Id shift 20',0.00,0.00,0.00,3666.43,0.00,'2022-08-21 11:58:36','',''),(321,'1','281','2',1,'Sale Id shift 20',0.00,0.00,0.00,6980.90,0.00,'2022-08-21 11:58:36','',''),(322,'1','281','2',1,'Sale Id shift 20',0.00,0.00,0.00,3857.49,0.00,'2022-08-21 11:58:36','',''),(323,'1','281',NULL,2,'Sale Id shift 20',442712.00,0.00,0.00,0.00,0.00,'2022-08-21 11:58:36','',''),(324,'1','281',NULL,1,'Sale Id shift 20',8781720.60,0.00,0.00,0.00,0.00,'2022-08-21 11:58:36','',''),(325,'1','281',NULL,1,'Reception corrector for bridging 44',0.00,0.00,0.00,22500.00,0.00,'2022-08-21 12:32:13','',''),(326,'1','281','1',1,'Received from bridging 44',0.00,0.00,22500.00,0.00,0.00,'2022-08-21 12:32:13','',''),(327,'1','281',NULL,1,'Reception corrector for bridging 45',0.00,0.00,0.00,22500.00,0.00,'2022-08-21 12:32:29','',''),(328,'1','281','2',1,'Received from bridging 45',0.00,0.00,22500.00,0.00,0.00,'2022-08-21 12:32:29','',''),(329,'1','281','1',1,'Sale Id shift 21',0.00,0.00,0.00,5490.45,0.00,'2022-08-21 12:34:38','',''),(330,'1','281','2',1,'Sale Id shift 21',0.00,0.00,0.00,5621.85,0.00,'2022-08-21 12:34:38','',''),(331,'1','281','2',1,'Sale Id shift 21',0.00,0.00,0.00,2112.09,0.00,'2022-08-21 12:34:38','',''),(332,'1','281','2',1,'Sale Id shift 21',0.00,0.00,0.00,1804.17,0.00,'2022-08-21 12:34:38','',''),(333,'1','281','3',2,'Sale Id shift 21',0.00,0.00,0.00,833.56,0.00,'2022-08-21 12:34:38','',''),(334,'1','281','3',2,'Sale Id shift 21',0.00,0.00,0.00,171.43,0.00,'2022-08-21 12:34:38','',''),(335,'1','281','1',1,'Sale Id shift 21',0.00,0.00,0.00,4529.98,0.00,'2022-08-21 12:34:38','',''),(336,'1','281','1',1,'Sale Id shift 21',0.00,0.00,0.00,1832.88,0.00,'2022-08-21 12:34:38','',''),(337,'1','281','1',1,'Sale Id shift 21',0.00,0.00,0.00,2064.20,0.00,'2022-08-21 12:34:38','',''),(338,'1','281','1',1,'Sale Id shift 21',0.00,0.00,0.00,4939.87,0.00,'2022-08-21 12:34:38','',''),(339,'1','281','1',1,'Sale Id shift 21',0.00,0.00,0.00,3931.32,0.00,'2022-08-21 12:34:38','',''),(340,'1','281','2',1,'Sale Id shift 21',0.00,0.00,0.00,3592.42,0.00,'2022-08-21 12:34:38','',''),(341,'1','281','2',1,'Sale Id shift 21',0.00,0.00,0.00,5622.31,0.00,'2022-08-21 12:34:38','',''),(342,'1','281',NULL,2,'Sale Id shift 21',803992.00,0.00,0.00,0.00,0.00,'2022-08-21 12:34:38','',''),(343,'1','281',NULL,1,'Sale Id shift 21',7685184.90,0.00,0.00,0.00,0.00,'2022-08-21 12:34:38','',''),(344,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9250000.00,50000.00,0.00,0.00,'2022-08-21 14:53:08','',''),(345,'1','281',NULL,1,'Reception corrector for bridging 46',0.00,0.00,0.00,25000.00,0.00,'2022-08-21 15:15:14','',''),(346,'1','281','1',1,'Received from bridging 46',0.00,0.00,25000.00,0.00,0.00,'2022-08-21 15:15:14','',''),(347,'1','281',NULL,1,'Reception corrector for bridging 47',0.00,0.00,0.00,25000.00,0.00,'2022-08-21 15:15:36','',''),(348,'1','281','2',1,'Received from bridging 47',0.00,0.00,25000.00,0.00,0.00,'2022-08-21 15:15:36','',''),(349,'1','281','1',1,'Sale Id shift 22',0.00,0.00,0.00,3665.95,0.00,'2022-08-22 07:51:13','',''),(350,'1','281','2',1,'Sale Id shift 22',0.00,0.00,0.00,3307.79,0.00,'2022-08-22 07:51:13','',''),(351,'1','281','2',1,'Sale Id shift 22',0.00,0.00,0.00,4398.49,0.00,'2022-08-22 07:51:13','',''),(352,'1','281','2',1,'Sale Id shift 22',0.00,0.00,0.00,3227.61,0.00,'2022-08-22 07:51:13','',''),(353,'1','281','3',2,'Sale Id shift 22',0.00,0.00,0.00,567.00,0.00,'2022-08-22 07:51:13','',''),(354,'1','281','3',2,'Sale Id shift 22',0.00,0.00,0.00,633.52,0.00,'2022-08-22 07:51:13','',''),(355,'1','281','1',1,'Sale Id shift 22',0.00,0.00,0.00,3112.45,0.00,'2022-08-22 07:51:13','',''),(356,'1','281','1',1,'Sale Id shift 22',0.00,0.00,0.00,2912.15,0.00,'2022-08-22 07:51:13','',''),(357,'1','281','1',1,'Sale Id shift 22',0.00,0.00,0.00,2990.88,0.00,'2022-08-22 07:51:13','',''),(358,'1','281','1',1,'Sale Id shift 22',0.00,0.00,0.00,3024.41,0.00,'2022-08-22 07:51:13','',''),(359,'1','281','1',1,'Sale Id shift 22',0.00,0.00,0.00,3209.81,0.00,'2022-08-22 07:51:13','',''),(360,'1','281','2',1,'Sale Id shift 22',0.00,0.00,0.00,5583.73,0.00,'2022-08-22 07:51:13','',''),(361,'1','281','2',1,'Sale Id shift 22',0.00,0.00,0.00,4404.98,0.00,'2022-08-22 07:51:13','',''),(362,'1','281',NULL,2,'Sale Id shift 22',960416.00,0.00,0.00,0.00,0.00,'2022-08-22 07:51:13','',''),(363,'1','281',NULL,1,'Sale Id shift 22',7370076.25,0.00,0.00,0.00,0.00,'2022-08-22 07:51:13','',''),(364,'1','281','1',1,'Sale Id shift 23',0.00,0.00,0.00,2126.06,0.00,'2022-08-22 15:00:56','',''),(365,'1','281','2',1,'Sale Id shift 23',0.00,0.00,0.00,1840.22,0.00,'2022-08-22 15:00:56','',''),(366,'1','281','2',1,'Sale Id shift 23',0.00,0.00,0.00,3036.92,0.00,'2022-08-22 15:00:56','',''),(367,'1','281','2',1,'Sale Id shift 23',0.00,0.00,0.00,1993.40,0.00,'2022-08-22 15:00:56','',''),(368,'1','281','3',2,'Sale Id shift 23',0.00,0.00,0.00,245.30,0.00,'2022-08-22 15:00:56','',''),(369,'1','281','3',2,'Sale Id shift 23',0.00,0.00,0.00,60.04,0.00,'2022-08-22 15:00:56','',''),(370,'1','281','1',1,'Sale Id shift 23',0.00,0.00,0.00,2196.81,0.00,'2022-08-22 15:00:56','',''),(371,'1','281','1',1,'Sale Id shift 23',0.00,0.00,0.00,1050.61,0.00,'2022-08-22 15:00:56','',''),(372,'1','281','1',1,'Sale Id shift 23',0.00,0.00,0.00,1998.57,0.00,'2022-08-22 15:00:56','',''),(373,'1','281','1',1,'Sale Id shift 23',0.00,0.00,0.00,1715.70,0.00,'2022-08-22 15:00:56','',''),(374,'1','281','1',1,'Sale Id shift 23',0.00,0.00,0.00,1510.36,0.00,'2022-08-22 15:00:56','',''),(375,'1','281','2',1,'Sale Id shift 23',0.00,0.00,0.00,3765.54,0.00,'2022-08-22 15:00:56','',''),(376,'1','281','2',1,'Sale Id shift 23',0.00,0.00,0.00,2295.43,0.00,'2022-08-22 15:00:56','',''),(377,'1','281',NULL,2,'Sale Id shift 23',244272.00,0.00,0.00,0.00,0.00,'2022-08-22 15:00:56','',''),(378,'1','281',NULL,1,'Sale Id shift 23',4352979.70,0.00,0.00,0.00,0.00,'2022-08-22 15:00:56','',''),(379,'1','281','1',1,'Sale Id shift 24',0.00,0.00,0.00,2127.09,0.00,'2022-08-23 07:19:41','',''),(380,'1','281','2',1,'Sale Id shift 24',0.00,0.00,0.00,3140.41,0.00,'2022-08-23 07:19:41','',''),(381,'1','281','2',1,'Sale Id shift 24',0.00,0.00,0.00,501.44,0.00,'2022-08-23 07:19:41','',''),(382,'1','281','2',1,'Sale Id shift 24',0.00,0.00,0.00,2816.38,0.00,'2022-08-23 07:19:41','',''),(383,'1','281','3',2,'Sale Id shift 24',0.00,0.00,0.00,458.85,0.00,'2022-08-23 07:19:41','',''),(384,'1','281','1',1,'Sale Id shift 24',0.00,0.00,0.00,2436.44,0.00,'2022-08-23 07:19:41','',''),(385,'1','281','1',1,'Sale Id shift 24',0.00,0.00,0.00,1704.39,0.00,'2022-08-23 07:19:41','',''),(386,'1','281','1',1,'Sale Id shift 24',0.00,0.00,0.00,1992.84,0.00,'2022-08-23 07:19:41','',''),(387,'1','281','1',1,'Sale Id shift 24',0.00,0.00,0.00,2326.84,0.00,'2022-08-23 07:19:41','',''),(388,'1','281','1',1,'Sale Id shift 24',0.00,0.00,0.00,1216.00,0.00,'2022-08-23 07:19:41','',''),(389,'1','281','2',1,'Sale Id shift 24',0.00,0.00,0.00,3121.55,0.00,'2022-08-23 07:19:41','',''),(390,'1','281','2',1,'Sale Id shift 24',0.00,0.00,0.00,166.22,0.00,'2022-08-23 07:19:41','',''),(391,'1','281',NULL,2,'Sale Id shift 24',367080.00,0.00,0.00,0.00,0.00,'2022-08-23 07:19:41','',''),(392,'1','281',NULL,1,'Sale Id shift 24',3986676.00,0.00,0.00,0.00,0.00,'2022-08-23 07:19:41','',''),(393,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9065000.00,49000.00,0.00,0.00,'2022-08-23 15:13:00','',''),(394,'1','281',NULL,1,'Reception corrector for bridging 48',0.00,0.00,0.00,20000.00,0.00,'2022-08-23 17:44:08','',''),(395,'1','281','1',1,'Received from bridging 48',0.00,0.00,20000.00,0.00,0.00,'2022-08-23 17:44:08','',''),(396,'1','281',NULL,1,'Reception corrector for bridging 49',0.00,0.00,0.00,29000.00,0.00,'2022-08-23 17:44:39','',''),(397,'1','281','2',1,'Received from bridging 49',0.00,0.00,29000.00,0.00,0.00,'2022-08-23 17:44:39','',''),(398,'1','281','1',1,'Sale Id shift 25',0.00,0.00,0.00,2603.33,0.00,'2022-08-23 18:21:49','',''),(399,'1','281','2',1,'Sale Id shift 25',0.00,0.00,0.00,1636.70,0.00,'2022-08-23 18:21:49','',''),(400,'1','281','2',1,'Sale Id shift 25',0.00,0.00,0.00,2755.73,0.00,'2022-08-23 18:21:49','',''),(401,'1','281','2',1,'Sale Id shift 25',0.00,0.00,0.00,2373.85,0.00,'2022-08-23 18:21:49','',''),(402,'1','281','3',2,'Sale Id shift 25',0.00,0.00,0.00,238.12,0.00,'2022-08-23 18:21:49','',''),(403,'1','281','1',1,'Sale Id shift 25',0.00,0.00,0.00,2238.00,0.00,'2022-08-23 18:21:49','',''),(404,'1','281','1',1,'Sale Id shift 25',0.00,0.00,0.00,1615.37,0.00,'2022-08-23 18:21:49','',''),(405,'1','281','1',1,'Sale Id shift 25',0.00,0.00,0.00,2005.62,0.00,'2022-08-23 18:21:49','',''),(406,'1','281','1',1,'Sale Id shift 25',0.00,0.00,0.00,2204.82,0.00,'2022-08-23 18:21:49','',''),(407,'1','281','1',1,'Sale Id shift 25',0.00,0.00,0.00,2014.21,0.00,'2022-08-23 18:21:49','',''),(408,'1','281','2',1,'Sale Id shift 25',0.00,0.00,0.00,3109.81,0.00,'2022-08-23 18:21:49','',''),(409,'1','281','2',1,'Sale Id shift 25',0.00,0.00,0.00,2379.66,0.00,'2022-08-23 18:21:49','',''),(410,'1','281',NULL,2,'Sale Id shift 25',190496.00,0.00,0.00,0.00,0.00,'2022-08-23 18:21:49','',''),(411,'1','281',NULL,1,'Sale Id shift 25',4613363.50,0.00,0.00,0.00,0.00,'2022-08-23 18:21:49','',''),(412,'1','281','1',1,'Sale Id shift 26',0.00,0.00,0.00,1205.55,0.00,'2022-08-24 08:14:01','',''),(413,'1','281','2',1,'Sale Id shift 26',0.00,0.00,0.00,1274.59,0.00,'2022-08-24 08:14:01','',''),(414,'1','281','2',1,'Sale Id shift 26',0.00,0.00,0.00,805.31,0.00,'2022-08-24 08:14:01','',''),(415,'1','281','2',1,'Sale Id shift 26',0.00,0.00,0.00,2797.54,0.00,'2022-08-24 08:14:01','',''),(416,'1','281','3',2,'Sale Id shift 26',0.00,0.00,0.00,1718.82,0.00,'2022-08-24 08:14:01','',''),(417,'1','281','1',1,'Sale Id shift 26',0.00,0.00,0.00,1077.42,0.00,'2022-08-24 08:14:01','',''),(418,'1','281','1',1,'Sale Id shift 26',0.00,0.00,0.00,1138.67,0.00,'2022-08-24 08:14:01','',''),(419,'1','281','1',1,'Sale Id shift 26',0.00,0.00,0.00,2497.53,0.00,'2022-08-24 08:14:01','',''),(420,'1','281','1',1,'Sale Id shift 26',0.00,0.00,0.00,1124.26,0.00,'2022-08-24 08:14:01','',''),(421,'1','281','2',1,'Sale Id shift 26',0.00,0.00,0.00,2781.63,0.00,'2022-08-24 08:14:01','',''),(422,'1','281','2',1,'Sale Id shift 26',0.00,0.00,0.00,885.55,0.00,'2022-08-24 08:14:01','',''),(423,'1','281',NULL,2,'Sale Id shift 26',1375056.00,0.00,0.00,0.00,0.00,'2022-08-24 08:14:01','',''),(424,'1','281',NULL,1,'Sale Id shift 26',2883789.25,0.00,0.00,0.00,0.00,'2022-08-24 08:14:01','',''),(425,'1','281','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,11664.39,0.00,'2022-08-24 15:03:38','',''),(426,'1','281','2',0,'Inventory adjustment from tank dipping to 13300',0.00,0.00,13300.00,0.00,0.00,'2022-08-24 15:03:38','',''),(427,'1','281','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,13300.00,0.00,'2022-08-24 16:17:44','',''),(428,'1','281','2',0,'Inventory adjustment from tank dipping to 14000',0.00,0.00,14000.00,0.00,0.00,'2022-08-24 16:17:44','',''),(429,'1','281','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,2351.89,0.00,'2022-08-24 16:32:17','',''),(430,'1','281','1',0,'Inventory adjustment from tank dipping to 7000',0.00,0.00,7000.00,0.00,0.00,'2022-08-24 16:32:17','',''),(431,'1','281','2',1,'Sale Id shift 27',0.00,0.00,0.00,2662.72,0.00,'2022-08-24 16:43:36','',''),(432,'1','281','2',1,'Sale Id shift 27',0.00,0.00,0.00,1895.87,0.00,'2022-08-24 16:43:36','',''),(433,'1','281','3',2,'Sale Id shift 27',0.00,0.00,0.00,106.52,0.00,'2022-08-24 16:43:36','',''),(434,'1','281','1',1,'Sale Id shift 27',0.00,0.00,0.00,2616.98,0.00,'2022-08-24 16:43:36','',''),(435,'1','281','1',1,'Sale Id shift 27',0.00,0.00,0.00,2948.74,0.00,'2022-08-24 16:43:36','',''),(436,'1','281','2',1,'Sale Id shift 27',0.00,0.00,0.00,2931.87,0.00,'2022-08-24 16:43:36','',''),(437,'1','281',NULL,2,'Sale Id shift 27',85216.00,0.00,0.00,0.00,0.00,'2022-08-24 16:43:36','',''),(438,'1','281',NULL,1,'Sale Id shift 27',2415393.30,0.00,0.00,0.00,0.00,'2022-08-24 16:43:36','',''),(439,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9250000.00,50000.00,0.00,0.00,'2022-08-24 20:58:32','',''),(440,'1','281',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,11440000.00,14300.00,0.00,0.00,'2022-08-24 20:58:54','',''),(441,'1','281',NULL,1,'Reception corrector for bridging 50',0.00,0.00,0.00,16500.00,0.00,'2022-08-24 21:03:09','',''),(442,'1','281','1',1,'Received from bridging 50',0.00,0.00,16500.00,0.00,0.00,'2022-08-24 21:03:09','',''),(443,'1','281',NULL,1,'Reception corrector for bridging 51',0.00,0.00,0.00,33500.00,0.00,'2022-08-24 21:03:41','',''),(444,'1','281','2',1,'Received from bridging 51',0.00,0.00,33500.00,0.00,0.00,'2022-08-24 21:03:41','',''),(445,'1','281',NULL,2,'Reception corrector for bridging 52',0.00,0.00,0.00,14300.00,0.00,'2022-08-24 21:06:20','',''),(446,'1','281','3',2,'Received from bridging 52',0.00,0.00,14300.00,0.00,0.00,'2022-08-24 21:06:20','',''),(447,'1','281','1',1,'Sale Id shift 28',0.00,0.00,0.00,666.76,0.00,'2022-08-25 08:01:28','',''),(448,'1','281','2',1,'Sale Id shift 28',0.00,0.00,0.00,1269.17,0.00,'2022-08-25 08:01:28','',''),(449,'1','281','2',1,'Sale Id shift 28',0.00,0.00,0.00,564.54,0.00,'2022-08-25 08:01:28','',''),(450,'1','281','3',2,'Sale Id shift 28',0.00,0.00,0.00,728.27,0.00,'2022-08-25 08:01:28','',''),(451,'1','281','3',2,'Sale Id shift 28',0.00,0.00,0.00,65.64,0.00,'2022-08-25 08:01:28','',''),(452,'1','281','1',1,'Sale Id shift 28',0.00,0.00,0.00,1208.49,0.00,'2022-08-25 08:01:28','',''),(453,'1','281','1',1,'Sale Id shift 28',0.00,0.00,0.00,725.61,0.00,'2022-08-25 08:01:28','',''),(454,'1','281','1',1,'Sale Id shift 28',0.00,0.00,0.00,587.96,0.00,'2022-08-25 08:01:28','',''),(455,'1','281','1',1,'Sale Id shift 28',0.00,0.00,0.00,1582.86,0.00,'2022-08-25 08:01:28','',''),(456,'1','281','2',1,'Sale Id shift 28',0.00,0.00,0.00,708.73,0.00,'2022-08-25 08:01:28','',''),(457,'1','281','2',1,'Sale Id shift 28',0.00,0.00,0.00,747.96,0.00,'2022-08-25 08:01:28','',''),(458,'1','281',NULL,2,'Sale Id shift 28',635128.00,0.00,0.00,0.00,0.00,'2022-08-25 08:01:28','',''),(459,'1','281',NULL,1,'Sale Id shift 28',1491484.80,0.00,0.00,0.00,0.00,'2022-08-25 08:01:28','',''),(460,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,185000.00,1000.00,0.00,0.00,'2022-08-25 12:04:59','',''),(461,'1','281',NULL,1,'Reception corrector for bridging 53',0.00,0.00,0.00,1000.00,0.00,'2022-08-25 12:08:04','',''),(462,'1','281','2',1,'Received from bridging 53',0.00,0.00,1000.00,0.00,0.00,'2022-08-25 12:08:04','',''),(463,'1','281','1',1,'Sale Id shift 29',0.00,0.00,0.00,1917.91,0.00,'2022-08-25 14:57:11','',''),(464,'1','281','2',1,'Sale Id shift 29',0.00,0.00,0.00,1558.21,0.00,'2022-08-25 14:57:11','',''),(465,'1','281','2',1,'Sale Id shift 29',0.00,0.00,0.00,2744.92,0.00,'2022-08-25 14:57:11','',''),(466,'1','281','2',1,'Sale Id shift 29',0.00,0.00,0.00,2082.29,0.00,'2022-08-25 14:57:11','',''),(467,'1','281','3',2,'Sale Id shift 29',0.00,0.00,0.00,2.00,0.00,'2022-08-25 14:57:11','',''),(468,'1','281','1',1,'Sale Id shift 29',0.00,0.00,0.00,1684.01,0.00,'2022-08-25 14:57:11','',''),(469,'1','281','1',1,'Sale Id shift 29',0.00,0.00,0.00,2565.83,0.00,'2022-08-25 14:57:11','',''),(470,'1','281','1',1,'Sale Id shift 29',0.00,0.00,0.00,2228.56,0.00,'2022-08-25 14:57:11','',''),(471,'1','281','1',1,'Sale Id shift 29',0.00,0.00,0.00,974.63,0.00,'2022-08-25 14:57:11','',''),(472,'1','281','1',1,'Sale Id shift 29',0.00,0.00,0.00,1751.77,0.00,'2022-08-25 14:57:11','',''),(473,'1','281','2',1,'Sale Id shift 29',0.00,0.00,0.00,3686.59,0.00,'2022-08-25 14:57:11','',''),(474,'1','281','2',1,'Sale Id shift 29',0.00,0.00,0.00,2157.80,0.00,'2022-08-25 14:57:11','',''),(475,'1','281',NULL,2,'Sale Id shift 29',1600.00,0.00,0.00,0.00,0.00,'2022-08-25 14:57:11','',''),(476,'1','281',NULL,1,'Sale Id shift 29',4320216.20,0.00,0.00,0.00,0.00,'2022-08-25 14:57:11','',''),(477,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-08-25 20:38:55','',''),(478,'1','281',NULL,1,'Reception corrector for bridging 54',0.00,0.00,0.00,30000.00,0.00,'2022-08-25 21:02:16','',''),(479,'1','281','1',1,'Received from bridging 54',0.00,0.00,30000.00,0.00,0.00,'2022-08-25 21:02:16','',''),(480,'1','281',NULL,1,'Reception corrector for bridging 55',0.00,0.00,0.00,15000.00,0.00,'2022-08-25 21:03:06','',''),(481,'1','281','2',1,'Received from bridging 55',0.00,0.00,15000.00,0.00,0.00,'2022-08-25 21:03:06','',''),(482,'1','281','2',1,'Sale Id shift 30',0.00,0.00,0.00,255.89,0.00,'2022-08-26 07:35:51','',''),(483,'1','281','2',1,'Sale Id shift 30',0.00,0.00,0.00,3314.77,0.00,'2022-08-26 07:35:51','',''),(484,'1','281','2',1,'Sale Id shift 30',0.00,0.00,0.00,2802.22,0.00,'2022-08-26 07:35:51','',''),(485,'1','281','3',2,'Sale Id shift 30',0.00,0.00,0.00,950.02,0.00,'2022-08-26 07:35:51','',''),(486,'1','281','3',2,'Sale Id shift 30',0.00,0.00,0.00,127.00,0.00,'2022-08-26 07:35:51','',''),(487,'1','281','1',1,'Sale Id shift 30',0.00,0.00,0.00,394.01,0.00,'2022-08-26 07:35:51','',''),(488,'1','281','1',1,'Sale Id shift 30',0.00,0.00,0.00,3240.95,0.00,'2022-08-26 07:35:51','',''),(489,'1','281','1',1,'Sale Id shift 30',0.00,0.00,0.00,3190.94,0.00,'2022-08-26 07:35:51','',''),(490,'1','281','1',1,'Sale Id shift 30',0.00,0.00,0.00,225.56,0.00,'2022-08-26 07:35:51','',''),(491,'1','281','1',1,'Sale Id shift 30',0.00,0.00,0.00,237.89,0.00,'2022-08-26 07:35:51','',''),(492,'1','281','2',1,'Sale Id shift 30',0.00,0.00,0.00,4744.65,0.00,'2022-08-26 07:35:51','',''),(493,'1','281','2',1,'Sale Id shift 30',0.00,0.00,0.00,70.32,0.00,'2022-08-26 07:35:51','',''),(494,'1','281',NULL,2,'Sale Id shift 30',861616.00,0.00,0.00,0.00,0.00,'2022-08-26 07:35:51','',''),(495,'1','281',NULL,1,'Sale Id shift 30',3418282.00,0.00,0.00,0.00,0.00,'2022-08-26 07:35:51','',''),(496,'1','281','1',1,'Sale Id shift 31',0.00,0.00,0.00,2510.69,0.00,'2022-08-26 16:22:59','',''),(497,'1','281','2',1,'Sale Id shift 31',0.00,0.00,0.00,1852.44,0.00,'2022-08-26 16:22:59','',''),(498,'1','281','2',1,'Sale Id shift 31',0.00,0.00,0.00,2026.41,0.00,'2022-08-26 16:22:59','',''),(499,'1','281','2',1,'Sale Id shift 31',0.00,0.00,0.00,2280.61,0.00,'2022-08-26 16:22:59','',''),(500,'1','281','3',2,'Sale Id shift 31',0.00,0.00,0.00,156.01,0.00,'2022-08-26 16:22:59','',''),(501,'1','281','1',1,'Sale Id shift 31',0.00,0.00,0.00,2318.59,0.00,'2022-08-26 16:22:59','',''),(502,'1','281','1',1,'Sale Id shift 31',0.00,0.00,0.00,2193.95,0.00,'2022-08-26 16:22:59','',''),(503,'1','281','1',1,'Sale Id shift 31',0.00,0.00,0.00,1721.46,0.00,'2022-08-26 16:22:59','',''),(504,'1','281','1',1,'Sale Id shift 31',0.00,0.00,0.00,472.76,0.00,'2022-08-26 16:22:59','',''),(505,'1','281','1',1,'Sale Id shift 31',0.00,0.00,0.00,3066.65,0.00,'2022-08-26 16:22:59','',''),(506,'1','281','2',1,'Sale Id shift 31',0.00,0.00,0.00,2876.54,0.00,'2022-08-26 16:22:59','',''),(507,'1','281','2',1,'Sale Id shift 31',0.00,0.00,0.00,2554.08,0.00,'2022-08-26 16:22:59','',''),(508,'1','281',NULL,2,'Sale Id shift 31',124808.00,0.00,0.00,0.00,0.00,'2022-08-26 16:22:59','',''),(509,'1','281',NULL,1,'Sale Id shift 31',4416723.30,0.00,0.00,0.00,0.00,'2022-08-26 16:22:59','',''),(510,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3700000.00,20000.00,0.00,0.00,'2022-08-26 19:41:29','',''),(511,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-08-26 19:41:46','',''),(512,'1','281',NULL,1,'Reception corrector for bridging 56',0.00,0.00,0.00,20000.00,0.00,'2022-08-26 19:57:44','',''),(513,'1','281','1',1,'Received from bridging 56',0.00,0.00,20000.00,0.00,0.00,'2022-08-26 19:57:44','',''),(514,'1','281','1',1,'Sale Id shift 32',0.00,0.00,0.00,1700.76,0.00,'2022-08-27 07:44:53','',''),(515,'1','281','2',1,'Sale Id shift 32',0.00,0.00,0.00,2354.71,0.00,'2022-08-27 07:44:53','',''),(516,'1','281','2',1,'Sale Id shift 32',0.00,0.00,0.00,1935.89,0.00,'2022-08-27 07:44:53','',''),(517,'1','281','2',1,'Sale Id shift 32',0.00,0.00,0.00,829.53,0.00,'2022-08-27 07:44:53','',''),(518,'1','281','3',2,'Sale Id shift 32',0.00,0.00,0.00,68.17,0.00,'2022-08-27 07:44:53','',''),(519,'1','281','3',2,'Sale Id shift 32',0.00,0.00,0.00,0.02,0.00,'2022-08-27 07:44:53','',''),(520,'1','281','1',1,'Sale Id shift 32',0.00,0.00,0.00,2151.41,0.00,'2022-08-27 07:44:53','',''),(521,'1','281','1',1,'Sale Id shift 32',0.00,0.00,0.00,1096.63,0.00,'2022-08-27 07:44:53','',''),(522,'1','281','1',1,'Sale Id shift 32',0.00,0.00,0.00,1634.31,0.00,'2022-08-27 07:44:53','',''),(523,'1','281','1',1,'Sale Id shift 32',0.00,0.00,0.00,1680.76,0.00,'2022-08-27 07:44:53','',''),(524,'1','281','1',1,'Sale Id shift 32',0.00,0.00,0.00,1878.03,0.00,'2022-08-27 07:44:53','',''),(525,'1','281','2',1,'Sale Id shift 32',0.00,0.00,0.00,1757.48,0.00,'2022-08-27 07:44:53','',''),(526,'1','281','2',1,'Sale Id shift 32',0.00,0.00,0.00,1625.93,0.00,'2022-08-27 07:44:53','',''),(527,'1','281',NULL,2,'Sale Id shift 32',54552.00,0.00,0.00,0.00,0.00,'2022-08-27 07:44:53','',''),(528,'1','281',NULL,1,'Sale Id shift 32',3449406.40,0.00,0.00,0.00,0.00,'2022-08-27 07:44:53','',''),(529,'1','281',NULL,1,'Reception corrector for bridging 57',0.00,0.00,0.00,30000.00,0.00,'2022-08-27 09:29:56','',''),(530,'1','281','2',1,'Received from bridging 57',0.00,0.00,30000.00,0.00,0.00,'2022-08-27 09:29:56','',''),(531,'1','281','1',1,'Sale Id shift 33',0.00,0.00,0.00,2149.74,0.00,'2022-08-27 15:17:30','',''),(532,'1','281','2',1,'Sale Id shift 33',0.00,0.00,0.00,2096.66,0.00,'2022-08-27 15:17:30','',''),(533,'1','281','2',1,'Sale Id shift 33',0.00,0.00,0.00,2309.54,0.00,'2022-08-27 15:17:30','',''),(534,'1','281','2',1,'Sale Id shift 33',0.00,0.00,0.00,1972.60,0.00,'2022-08-27 15:17:30','',''),(535,'1','281','3',2,'Sale Id shift 33',0.00,0.00,0.00,153.86,0.00,'2022-08-27 15:17:30','',''),(536,'1','281','1',1,'Sale Id shift 33',0.00,0.00,0.00,1996.96,0.00,'2022-08-27 15:17:30','',''),(537,'1','281','1',1,'Sale Id shift 33',0.00,0.00,0.00,51.96,0.00,'2022-08-27 15:17:30','',''),(538,'1','281','1',1,'Sale Id shift 33',0.00,0.00,0.00,2434.75,0.00,'2022-08-27 15:17:30','',''),(539,'1','281','1',1,'Sale Id shift 33',0.00,0.00,0.00,2209.58,0.00,'2022-08-27 15:17:30','',''),(540,'1','281','1',1,'Sale Id shift 33',0.00,0.00,0.00,1587.89,0.00,'2022-08-27 15:17:30','',''),(541,'1','281','2',1,'Sale Id shift 33',0.00,0.00,0.00,3210.85,0.00,'2022-08-27 15:17:30','',''),(542,'1','281','2',1,'Sale Id shift 33',0.00,0.00,0.00,2165.86,0.00,'2022-08-27 15:17:30','',''),(543,'1','281',NULL,2,'Sale Id shift 33',123088.00,0.00,0.00,0.00,0.00,'2022-08-27 15:17:30','',''),(544,'1','281',NULL,1,'Sale Id shift 33',4104482.15,0.00,0.00,0.00,0.00,'2022-08-27 15:17:30','',''),(545,'1','281',NULL,1,'Reception corrector for bridging 58',0.00,0.00,0.00,15000.00,0.00,'2022-08-27 20:29:56','',''),(546,'1','281','2',1,'Received from bridging 58',0.00,0.00,15000.00,0.00,0.00,'2022-08-27 20:29:56','',''),(547,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-08-27 20:43:17','',''),(548,'1','281',NULL,1,'Reception corrector for bridging 59',0.00,0.00,0.00,30000.00,0.00,'2022-08-27 20:46:08','',''),(549,'1','281','1',1,'Received from bridging 59',0.00,0.00,30000.00,0.00,0.00,'2022-08-27 20:46:08','',''),(550,'1','281','1',1,'Sale Id shift 34',0.00,0.00,0.00,2089.55,0.00,'2022-08-28 07:41:07','',''),(551,'1','281','2',1,'Sale Id shift 34',0.00,0.00,0.00,1852.37,0.00,'2022-08-28 07:41:07','',''),(552,'1','281','2',1,'Sale Id shift 34',0.00,0.00,0.00,2078.06,0.00,'2022-08-28 07:41:07','',''),(553,'1','281','2',1,'Sale Id shift 34',0.00,0.00,0.00,1859.11,0.00,'2022-08-28 07:41:07','',''),(554,'1','281','3',2,'Sale Id shift 34',0.00,0.00,0.00,698.27,0.00,'2022-08-28 07:41:07','',''),(555,'1','281','1',1,'Sale Id shift 34',0.00,0.00,0.00,2012.76,0.00,'2022-08-28 07:41:07','',''),(556,'1','281','1',1,'Sale Id shift 34',0.00,0.00,0.00,785.49,0.00,'2022-08-28 07:41:07','',''),(557,'1','281','1',1,'Sale Id shift 34',0.00,0.00,0.00,2352.15,0.00,'2022-08-28 07:41:07','',''),(558,'1','281','1',1,'Sale Id shift 34',0.00,0.00,0.00,2833.48,0.00,'2022-08-28 07:41:07','',''),(559,'1','281','2',1,'Sale Id shift 34',0.00,0.00,0.00,3525.50,0.00,'2022-08-28 07:41:07','',''),(560,'1','281','2',1,'Sale Id shift 34',0.00,0.00,0.00,1768.72,0.00,'2022-08-28 07:41:07','',''),(561,'1','281',NULL,2,'Sale Id shift 34',558616.00,0.00,0.00,0.00,0.00,'2022-08-28 07:41:07','',''),(562,'1','281',NULL,1,'Sale Id shift 34',3914080.15,0.00,0.00,0.00,0.00,'2022-08-28 07:41:07','',''),(563,'1','281','1',1,'Sale Id shift 35',0.00,0.00,0.00,1789.48,0.00,'2022-08-28 18:27:45','',''),(564,'1','281','2',1,'Sale Id shift 35',0.00,0.00,0.00,1524.43,0.00,'2022-08-28 18:27:45','',''),(565,'1','281','2',1,'Sale Id shift 35',0.00,0.00,0.00,2178.29,0.00,'2022-08-28 18:27:45','',''),(566,'1','281','2',1,'Sale Id shift 35',0.00,0.00,0.00,1572.38,0.00,'2022-08-28 18:27:45','',''),(567,'1','281','3',2,'Sale Id shift 35',0.00,0.00,0.00,3.75,0.00,'2022-08-28 18:27:45','',''),(568,'1','281','1',1,'Sale Id shift 35',0.00,0.00,0.00,1711.04,0.00,'2022-08-28 18:27:45','',''),(569,'1','281','1',1,'Sale Id shift 35',0.00,0.00,0.00,1286.09,0.00,'2022-08-28 18:27:45','',''),(570,'1','281','1',1,'Sale Id shift 35',0.00,0.00,0.00,972.32,0.00,'2022-08-28 18:27:45','',''),(571,'1','281','1',1,'Sale Id shift 35',0.00,0.00,0.00,1630.10,0.00,'2022-08-28 18:27:45','',''),(572,'1','281','1',1,'Sale Id shift 35',0.00,0.00,0.00,1375.28,0.00,'2022-08-28 18:27:45','',''),(573,'1','281','2',1,'Sale Id shift 35',0.00,0.00,0.00,3075.90,0.00,'2022-08-28 18:27:45','',''),(574,'1','281','2',1,'Sale Id shift 35',0.00,0.00,0.00,1804.89,0.00,'2022-08-28 18:27:45','',''),(575,'1','281',NULL,2,'Sale Id shift 35',3000.00,0.00,0.00,0.00,0.00,'2022-08-28 18:27:45','',''),(576,'1','281',NULL,1,'Sale Id shift 35',3500237.00,0.00,0.00,0.00,0.00,'2022-08-28 18:27:45','',''),(577,'1','281','1',1,'Sale Id shift 36',0.00,0.00,0.00,2447.03,0.00,'2022-08-29 07:48:47','',''),(578,'1','281','2',1,'Sale Id shift 36',0.00,0.00,0.00,2779.26,0.00,'2022-08-29 07:48:47','',''),(579,'1','281','2',1,'Sale Id shift 36',0.00,0.00,0.00,2758.43,0.00,'2022-08-29 07:48:47','',''),(580,'1','281','3',2,'Sale Id shift 36',0.00,0.00,0.00,362.12,0.00,'2022-08-29 07:48:47','',''),(581,'1','281','1',1,'Sale Id shift 36',0.00,0.00,0.00,2311.81,0.00,'2022-08-29 07:48:47','',''),(582,'1','281','1',1,'Sale Id shift 36',0.00,0.00,0.00,2461.32,0.00,'2022-08-29 07:48:47','',''),(583,'1','281','1',1,'Sale Id shift 36',0.00,0.00,0.00,1770.08,0.00,'2022-08-29 07:48:47','',''),(584,'1','281','1',1,'Sale Id shift 36',0.00,0.00,0.00,2177.59,0.00,'2022-08-29 07:48:47','',''),(585,'1','281','2',1,'Sale Id shift 36',0.00,0.00,0.00,2671.86,0.00,'2022-08-29 07:48:47','',''),(586,'1','281','2',1,'Sale Id shift 36',0.00,0.00,0.00,696.92,0.00,'2022-08-29 07:48:47','',''),(587,'1','281',NULL,2,'Sale Id shift 36',289696.00,0.00,0.00,0.00,0.00,'2022-08-29 07:48:47','',''),(588,'1','281',NULL,1,'Sale Id shift 36',3713745.50,0.00,0.00,0.00,0.00,'2022-08-29 07:48:47','',''),(589,'1','281',NULL,1,'Reception corrector for bridging 60',0.00,0.00,0.00,15000.00,0.00,'2022-08-29 08:23:37','',''),(590,'1','281','2',1,'Received from bridging 60',0.00,0.00,15000.00,0.00,0.00,'2022-08-29 08:23:37','',''),(591,'1','281','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,11888.09,0.00,'2022-08-29 14:17:59','',''),(592,'1','281','1',0,'Inventory adjustment from tank dipping to 17000',0.00,0.00,17000.00,0.00,0.00,'2022-08-29 14:17:59','',''),(593,'1','281','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,17000.00,0.00,'2022-08-29 14:18:06','',''),(594,'1','281','1',0,'Inventory adjustment from tank dipping to 17000',0.00,0.00,17000.00,0.00,0.00,'2022-08-29 14:18:06','',''),(595,'1','281','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,17000.00,0.00,'2022-08-29 14:18:14','',''),(596,'1','281','1',0,'Inventory adjustment from tank dipping to 17000',0.00,0.00,17000.00,0.00,0.00,'2022-08-29 14:18:14','',''),(597,'1','281','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,17000.00,0.00,'2022-08-29 14:18:15','',''),(598,'1','281','1',0,'Inventory adjustment from tank dipping to 17000',0.00,0.00,17000.00,0.00,0.00,'2022-08-29 14:18:15','',''),(599,'1','281','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,27306.23,0.00,'2022-08-29 14:19:42','',''),(600,'1','281','2',0,'Inventory adjustment from tank dipping to 30000',0.00,0.00,30000.00,0.00,0.00,'2022-08-29 14:19:42','',''),(601,'1','281','1',1,'Sale Id shift 37',0.00,0.00,0.00,1811.86,0.00,'2022-08-29 14:30:58','',''),(602,'1','281','2',1,'Sale Id shift 37',0.00,0.00,0.00,1236.02,0.00,'2022-08-29 14:30:58','',''),(603,'1','281','2',1,'Sale Id shift 37',0.00,0.00,0.00,1503.51,0.00,'2022-08-29 14:30:58','',''),(604,'1','281','2',1,'Sale Id shift 37',0.00,0.00,0.00,3163.31,0.00,'2022-08-29 14:30:58','',''),(605,'1','281','3',2,'Sale Id shift 37',0.00,0.00,0.00,190.43,0.00,'2022-08-29 14:30:58','',''),(606,'1','281','1',1,'Sale Id shift 37',0.00,0.00,0.00,1748.23,0.00,'2022-08-29 14:30:58','',''),(607,'1','281','1',1,'Sale Id shift 37',0.00,0.00,0.00,1409.28,0.00,'2022-08-29 14:30:58','',''),(608,'1','281','1',1,'Sale Id shift 37',0.00,0.00,0.00,3789.68,0.00,'2022-08-29 14:30:58','',''),(609,'1','281','1',1,'Sale Id shift 37',0.00,0.00,0.00,1859.96,0.00,'2022-08-29 14:30:58','',''),(610,'1','281','1',1,'Sale Id shift 37',0.00,0.00,0.00,1553.16,0.00,'2022-08-29 14:30:58','',''),(611,'1','281','2',1,'Sale Id shift 37',0.00,0.00,0.00,4426.21,0.00,'2022-08-29 14:30:58','',''),(612,'1','281','2',1,'Sale Id shift 37',0.00,0.00,0.00,1958.76,0.00,'2022-08-29 14:30:58','',''),(613,'1','281',NULL,2,'Sale Id shift 37',152344.00,0.00,0.00,0.00,0.00,'2022-08-29 14:30:58','',''),(614,'1','281',NULL,1,'Sale Id shift 37',4525096.30,0.00,0.00,0.00,0.00,'2022-08-29 14:30:58','',''),(615,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9083500.00,49100.00,0.00,0.00,'2022-08-29 20:10:38','',''),(616,'1','281',NULL,1,'Reception corrector for bridging 61',0.00,0.00,0.00,31100.00,0.00,'2022-08-29 20:15:07','',''),(617,'1','281','1',1,'Received from bridging 61',0.00,0.00,31100.00,0.00,0.00,'2022-08-29 20:15:07','',''),(618,'1','281',NULL,1,'Reception corrector for bridging 62',0.00,0.00,0.00,18000.00,0.00,'2022-08-29 20:15:41','',''),(619,'1','281','2',1,'Received from bridging 62',0.00,0.00,18000.00,0.00,0.00,'2022-08-29 20:15:41','',''),(620,'1','281','1',1,'Sale Id shift 38',0.00,0.00,0.00,215.17,0.00,'2022-08-30 07:24:59','',''),(621,'1','281','2',1,'Sale Id shift 38',0.00,0.00,0.00,234.63,0.00,'2022-08-30 07:24:59','',''),(622,'1','281','2',1,'Sale Id shift 38',0.00,0.00,0.00,1992.43,0.00,'2022-08-30 07:24:59','',''),(623,'1','281','2',1,'Sale Id shift 38',0.00,0.00,0.00,1674.78,0.00,'2022-08-30 07:24:59','',''),(624,'1','281','3',2,'Sale Id shift 38',0.00,0.00,0.00,280.73,0.00,'2022-08-30 07:24:59','',''),(625,'1','281','3',2,'Sale Id shift 38',0.00,0.00,0.00,0.02,0.00,'2022-08-30 07:24:59','',''),(626,'1','281','1',1,'Sale Id shift 38',0.00,0.00,0.00,117.04,0.00,'2022-08-30 07:24:59','',''),(627,'1','281','1',1,'Sale Id shift 38',0.00,0.00,0.00,2157.69,0.00,'2022-08-30 07:24:59','',''),(628,'1','281','1',1,'Sale Id shift 38',0.00,0.00,0.00,1986.67,0.00,'2022-08-30 07:24:59','',''),(629,'1','281','1',1,'Sale Id shift 38',0.00,0.00,0.00,233.76,0.00,'2022-08-30 07:24:59','',''),(630,'1','281','2',1,'Sale Id shift 38',0.00,0.00,0.00,3045.25,0.00,'2022-08-30 07:24:59','',''),(631,'1','281','2',1,'Sale Id shift 38',0.00,0.00,0.00,105.41,0.00,'2022-08-30 07:24:59','',''),(632,'1','281',NULL,2,'Sale Id shift 38',224600.00,0.00,0.00,0.00,0.00,'2022-08-30 07:24:59','',''),(633,'1','281',NULL,1,'Sale Id shift 38',2176123.55,0.00,0.00,0.00,0.00,'2022-08-30 07:24:59','',''),(634,'1','281','2',1,'Sale Id shift 39',0.00,0.00,0.00,3473.21,0.00,'2022-08-30 15:15:56','',''),(635,'1','281','2',1,'Sale Id shift 39',0.00,0.00,0.00,2378.27,0.00,'2022-08-30 15:15:56','',''),(636,'1','281','2',1,'Sale Id shift 39',0.00,0.00,0.00,2580.84,0.00,'2022-08-30 15:15:56','',''),(637,'1','281','3',2,'Sale Id shift 39',0.00,0.00,0.00,25.03,0.00,'2022-08-30 15:15:56','',''),(638,'1','281','1',1,'Sale Id shift 39',0.00,0.00,0.00,4067.11,0.00,'2022-08-30 15:15:56','',''),(639,'1','281','1',1,'Sale Id shift 39',0.00,0.00,0.00,2000.16,0.00,'2022-08-30 15:15:56','',''),(640,'1','281','1',1,'Sale Id shift 39',0.00,0.00,0.00,2278.43,0.00,'2022-08-30 15:15:56','',''),(641,'1','281','1',1,'Sale Id shift 39',0.00,0.00,0.00,214.04,0.00,'2022-08-30 15:15:56','',''),(642,'1','281','1',1,'Sale Id shift 39',0.00,0.00,0.00,3653.23,0.00,'2022-08-30 15:15:56','',''),(643,'1','281','2',1,'Sale Id shift 39',0.00,0.00,0.00,3387.72,0.00,'2022-08-30 15:15:56','',''),(644,'1','281','2',1,'Sale Id shift 39',0.00,0.00,0.00,299.97,0.00,'2022-08-30 15:15:56','',''),(645,'1','281',NULL,2,'Sale Id shift 39',20024.00,0.00,0.00,0.00,0.00,'2022-08-30 15:15:56','',''),(646,'1','281',NULL,1,'Sale Id shift 39',4501601.30,0.00,0.00,0.00,0.00,'2022-08-30 15:15:56','',''),(647,'1','281','1',1,'Sale Id shift 40',0.00,0.00,0.00,3283.13,0.00,'2022-08-31 07:33:20','',''),(648,'1','281','2',1,'Sale Id shift 40',0.00,0.00,0.00,3088.08,0.00,'2022-08-31 07:33:20','',''),(649,'1','281','3',2,'Sale Id shift 40',0.00,0.00,0.00,20.03,0.00,'2022-08-31 07:33:20','',''),(650,'1','281','3',2,'Sale Id shift 40',0.00,0.00,0.00,114.31,0.00,'2022-08-31 07:33:20','',''),(651,'1','281','1',1,'Sale Id shift 40',0.00,0.00,0.00,3008.08,0.00,'2022-08-31 07:33:20','',''),(652,'1','281','1',1,'Sale Id shift 40',0.00,0.00,0.00,3254.18,0.00,'2022-08-31 07:33:20','',''),(653,'1','281','1',1,'Sale Id shift 40',0.00,0.00,0.00,2870.77,0.00,'2022-08-31 07:33:20','',''),(654,'1','281','2',1,'Sale Id shift 40',0.00,0.00,0.00,2711.08,0.00,'2022-08-31 07:33:20','',''),(655,'1','281',NULL,2,'Sale Id shift 40',107472.00,0.00,0.00,0.00,0.00,'2022-08-31 07:33:20','',''),(656,'1','281',NULL,1,'Sale Id shift 40',3369834.20,0.00,0.00,0.00,0.00,'2022-08-31 07:33:20','',''),(657,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,166500.00,900.00,0.00,0.00,'2022-08-31 07:34:39','',''),(658,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9250000.00,50000.00,0.00,0.00,'2022-08-31 07:35:28','',''),(659,'1','281',NULL,1,'Reception corrector for bridging 63',0.00,0.00,0.00,900.00,0.00,'2022-08-31 07:49:26','',''),(660,'1','281','1',1,'Received from bridging 63',0.00,0.00,900.00,0.00,0.00,'2022-08-31 07:49:26','',''),(661,'1','281',NULL,1,'Reception corrector for bridging 64',0.00,0.00,0.00,17000.00,0.00,'2022-08-31 07:51:03','',''),(662,'1','281','1',1,'Received from bridging 64',0.00,0.00,17000.00,0.00,0.00,'2022-08-31 07:51:03','',''),(663,'1','281',NULL,1,'Reception corrector for bridging 65',0.00,0.00,0.00,33000.00,0.00,'2022-08-31 07:52:05','',''),(664,'1','281','2',1,'Received from bridging 65',0.00,0.00,33000.00,0.00,0.00,'2022-08-31 07:52:05','',''),(665,'1','281','1',1,'Sale Id shift 41',0.00,0.00,0.00,2656.77,0.00,'2022-08-31 19:52:18','',''),(666,'1','281','2',1,'Sale Id shift 41',0.00,0.00,0.00,2634.94,0.00,'2022-08-31 19:52:18','',''),(667,'1','281','2',1,'Sale Id shift 41',0.00,0.00,0.00,4008.81,0.00,'2022-08-31 19:52:18','',''),(668,'1','281','3',2,'Sale Id shift 41',0.00,0.00,0.00,985.63,0.00,'2022-08-31 19:52:18','',''),(669,'1','281','1',1,'Sale Id shift 41',0.00,0.00,0.00,2790.82,0.00,'2022-08-31 19:52:18','',''),(670,'1','281','1',1,'Sale Id shift 41',0.00,0.00,0.00,3184.70,0.00,'2022-08-31 19:52:18','',''),(671,'1','281','1',1,'Sale Id shift 41',0.00,0.00,0.00,1767.78,0.00,'2022-08-31 19:52:18','',''),(672,'1','281','1',1,'Sale Id shift 41',0.00,0.00,0.00,2469.47,0.00,'2022-08-31 19:52:18','',''),(673,'1','281','2',1,'Sale Id shift 41',0.00,0.00,0.00,3820.77,0.00,'2022-08-31 19:52:18','',''),(674,'1','281','2',1,'Sale Id shift 41',0.00,0.00,0.00,2483.49,0.00,'2022-08-31 19:52:18','',''),(675,'1','281',NULL,2,'Sale Id shift 41',788504.00,0.00,0.00,0.00,0.00,'2022-08-31 19:52:18','',''),(676,'1','281',NULL,1,'Sale Id shift 41',4776246.75,0.00,0.00,0.00,0.00,'2022-08-31 19:52:18','',''),(677,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8288000.00,44800.00,0.00,0.00,'2022-09-01 06:06:21','',''),(678,'1','281','1',1,'Sale Id shift 42',0.00,0.00,0.00,1152.84,0.00,'2022-09-01 07:34:27','',''),(679,'1','281','2',1,'Sale Id shift 42',0.00,0.00,0.00,595.18,0.00,'2022-09-01 07:34:27','',''),(680,'1','281','2',1,'Sale Id shift 42',0.00,0.00,0.00,2097.13,0.00,'2022-09-01 07:34:27','',''),(681,'1','281','2',1,'Sale Id shift 42',0.00,0.00,0.00,2060.00,0.00,'2022-09-01 07:34:27','',''),(682,'1','281','3',2,'Sale Id shift 42',0.00,0.00,0.00,200.80,0.00,'2022-09-01 07:34:27','',''),(683,'1','281','3',2,'Sale Id shift 42',0.00,0.00,0.00,17.63,0.00,'2022-09-01 07:34:27','',''),(684,'1','281','1',1,'Sale Id shift 42',0.00,0.00,0.00,673.19,0.00,'2022-09-01 07:34:27','',''),(685,'1','281','1',1,'Sale Id shift 42',0.00,0.00,0.00,2130.36,0.00,'2022-09-01 07:34:27','',''),(686,'1','281','1',1,'Sale Id shift 42',0.00,0.00,0.00,2239.57,0.00,'2022-09-01 07:34:27','',''),(687,'1','281','1',1,'Sale Id shift 42',0.00,0.00,0.00,455.36,0.00,'2022-09-01 07:34:27','',''),(688,'1','281','1',1,'Sale Id shift 42',0.00,0.00,0.00,1197.63,0.00,'2022-09-01 07:34:27','',''),(689,'1','281','2',1,'Sale Id shift 42',0.00,0.00,0.00,3320.06,0.00,'2022-09-01 07:34:27','',''),(690,'1','281','2',1,'Sale Id shift 42',0.00,0.00,0.00,1001.94,0.00,'2022-09-01 07:34:27','',''),(691,'1','281',NULL,2,'Sale Id shift 42',174744.00,0.00,0.00,0.00,0.00,'2022-09-01 07:34:27','',''),(692,'1','281',NULL,1,'Sale Id shift 42',3130803.10,0.00,0.00,0.00,0.00,'2022-09-01 07:34:27','',''),(693,'1','281',NULL,1,'Reception corrector for bridging 66',0.00,0.00,0.00,30000.00,0.00,'2022-09-01 07:55:13','',''),(694,'1','281','1',1,'Received from bridging 66',0.00,0.00,30000.00,0.00,0.00,'2022-09-01 07:55:13','',''),(695,'1','281',NULL,1,'Reception corrector for bridging 67',0.00,0.00,0.00,14800.00,0.00,'2022-09-01 07:55:45','',''),(696,'1','281','2',1,'Received from bridging 67',0.00,0.00,14800.00,0.00,0.00,'2022-09-01 07:55:45','',''),(697,'1','281','1',1,'Sale Id shift 43',0.00,0.00,0.00,2524.55,0.00,'2022-09-01 15:46:49','',''),(698,'1','281','2',1,'Sale Id shift 43',0.00,0.00,0.00,2413.33,0.00,'2022-09-01 15:46:49','',''),(699,'1','281','2',1,'Sale Id shift 43',0.00,0.00,0.00,3283.26,0.00,'2022-09-01 15:46:49','',''),(700,'1','281','2',1,'Sale Id shift 43',0.00,0.00,0.00,2278.18,0.00,'2022-09-01 15:46:49','',''),(701,'1','281','3',2,'Sale Id shift 43',0.00,0.00,0.00,0.03,0.00,'2022-09-01 15:46:49','',''),(702,'1','281','3',2,'Sale Id shift 43',0.00,0.00,0.00,65.91,0.00,'2022-09-01 15:46:49','',''),(703,'1','281','1',1,'Sale Id shift 43',0.00,0.00,0.00,2725.71,0.00,'2022-09-01 15:46:49','',''),(704,'1','281','1',1,'Sale Id shift 43',0.00,0.00,0.00,2911.09,0.00,'2022-09-01 15:46:49','',''),(705,'1','281','1',1,'Sale Id shift 43',0.00,0.00,0.00,3784.58,0.00,'2022-09-01 15:46:49','',''),(706,'1','281','1',1,'Sale Id shift 43',0.00,0.00,0.00,4156.24,0.00,'2022-09-01 15:46:49','',''),(707,'1','281','2',1,'Sale Id shift 43',0.00,0.00,0.00,3558.07,0.00,'2022-09-01 15:46:49','',''),(708,'1','281','2',1,'Sale Id shift 43',0.00,0.00,0.00,2604.30,0.00,'2022-09-01 15:46:49','',''),(709,'1','281',NULL,2,'Sale Id shift 43',52752.00,0.00,0.00,0.00,0.00,'2022-09-01 15:46:49','',''),(710,'1','281',NULL,1,'Sale Id shift 43',5594272.35,0.00,0.00,0.00,0.00,'2022-09-01 15:46:49','',''),(711,'1','281','1',1,'Sale Id shift 44',0.00,0.00,0.00,1639.63,0.00,'2022-09-02 07:38:43','',''),(712,'1','281','2',1,'Sale Id shift 44',0.00,0.00,0.00,1488.67,0.00,'2022-09-02 07:38:43','',''),(713,'1','281','2',1,'Sale Id shift 44',0.00,0.00,0.00,1543.63,0.00,'2022-09-02 07:38:43','',''),(714,'1','281','2',1,'Sale Id shift 44',0.00,0.00,0.00,2259.76,0.00,'2022-09-02 07:38:43','',''),(715,'1','281','3',2,'Sale Id shift 44',0.00,0.00,0.00,39.63,0.00,'2022-09-02 07:38:43','',''),(716,'1','281','1',1,'Sale Id shift 44',0.00,0.00,0.00,1633.87,0.00,'2022-09-02 07:38:43','',''),(717,'1','281','1',1,'Sale Id shift 44',0.00,0.00,0.00,2114.11,0.00,'2022-09-02 07:38:43','',''),(718,'1','281','1',1,'Sale Id shift 44',0.00,0.00,0.00,1540.41,0.00,'2022-09-02 07:38:43','',''),(719,'1','281','1',1,'Sale Id shift 44',0.00,0.00,0.00,1343.96,0.00,'2022-09-02 07:38:43','',''),(720,'1','281','1',1,'Sale Id shift 44',0.00,0.00,0.00,1583.24,0.00,'2022-09-02 07:38:43','',''),(721,'1','281','2',1,'Sale Id shift 44',0.00,0.00,0.00,3421.23,0.00,'2022-09-02 07:38:43','',''),(722,'1','281','2',1,'Sale Id shift 44',0.00,0.00,0.00,1829.76,0.00,'2022-09-02 07:38:43','',''),(723,'1','281',NULL,2,'Sale Id shift 44',31704.00,0.00,0.00,0.00,0.00,'2022-09-02 07:38:43','',''),(724,'1','281',NULL,1,'Sale Id shift 44',3773679.95,0.00,0.00,0.00,0.00,'2022-09-02 07:38:43','',''),(725,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-09-02 07:39:04','',''),(726,'1','281',NULL,1,'Reception corrector for bridging 68',0.00,0.00,0.00,30000.00,0.00,'2022-09-02 09:17:32','',''),(727,'1','281','1',1,'Received from bridging 68',0.00,0.00,30000.00,0.00,0.00,'2022-09-02 09:17:32','',''),(728,'1','281',NULL,1,'Reception corrector for bridging 69',0.00,0.00,0.00,15000.00,0.00,'2022-09-02 09:17:55','',''),(729,'1','281','2',1,'Received from bridging 69',0.00,0.00,15000.00,0.00,0.00,'2022-09-02 09:17:55','',''),(730,'1','281','1',1,'Sale Id shift 45',0.00,0.00,0.00,3129.55,0.00,'2022-09-02 15:11:29','',''),(731,'1','281','2',1,'Sale Id shift 45',0.00,0.00,0.00,3494.98,0.00,'2022-09-02 15:11:29','',''),(732,'1','281','2',1,'Sale Id shift 45',0.00,0.00,0.00,3667.50,0.00,'2022-09-02 15:11:29','',''),(733,'1','281','3',2,'Sale Id shift 45',0.00,0.00,0.00,1705.03,0.00,'2022-09-02 15:11:29','',''),(734,'1','281','3',2,'Sale Id shift 45',0.00,0.00,0.00,291.41,0.00,'2022-09-02 15:11:29','',''),(735,'1','281','1',1,'Sale Id shift 45',0.00,0.00,0.00,3278.63,0.00,'2022-09-02 15:11:29','',''),(736,'1','281','1',1,'Sale Id shift 45',0.00,0.00,0.00,3686.12,0.00,'2022-09-02 15:11:29','',''),(737,'1','281','1',1,'Sale Id shift 45',0.00,0.00,0.00,2361.57,0.00,'2022-09-02 15:11:29','',''),(738,'1','281','1',1,'Sale Id shift 45',0.00,0.00,0.00,2454.03,0.00,'2022-09-02 15:11:29','',''),(739,'1','281','2',1,'Sale Id shift 45',0.00,0.00,0.00,3901.26,0.00,'2022-09-02 15:11:29','',''),(740,'1','281','2',1,'Sale Id shift 45',0.00,0.00,0.00,65.67,0.00,'2022-09-02 15:11:29','',''),(741,'1','281',NULL,2,'Sale Id shift 45',1597152.00,0.00,0.00,0.00,0.00,'2022-09-02 15:11:29','',''),(742,'1','281',NULL,1,'Sale Id shift 45',4817272.35,0.00,0.00,0.00,0.00,'2022-09-02 15:11:29','',''),(743,'1','281','1',1,'Sale Id shift 46',0.00,0.00,0.00,2342.44,0.00,'2022-09-03 07:59:24','',''),(744,'1','281','2',1,'Sale Id shift 46',0.00,0.00,0.00,1229.36,0.00,'2022-09-03 07:59:24','',''),(745,'1','281','2',1,'Sale Id shift 46',0.00,0.00,0.00,1800.03,0.00,'2022-09-03 07:59:24','',''),(746,'1','281','2',1,'Sale Id shift 46',0.00,0.00,0.00,1311.46,0.00,'2022-09-03 07:59:24','',''),(747,'1','281','3',2,'Sale Id shift 46',0.00,0.00,0.00,218.41,0.00,'2022-09-03 07:59:24','',''),(748,'1','281','1',1,'Sale Id shift 46',0.00,0.00,0.00,2334.32,0.00,'2022-09-03 07:59:24','',''),(749,'1','281','1',1,'Sale Id shift 46',0.00,0.00,0.00,1511.51,0.00,'2022-09-03 07:59:24','',''),(750,'1','281','1',1,'Sale Id shift 46',0.00,0.00,0.00,1278.34,0.00,'2022-09-03 07:59:24','',''),(751,'1','281','1',1,'Sale Id shift 46',0.00,0.00,0.00,2060.07,0.00,'2022-09-03 07:59:24','',''),(752,'1','281','1',1,'Sale Id shift 46',0.00,0.00,0.00,2536.65,0.00,'2022-09-03 07:59:24','',''),(753,'1','281','2',1,'Sale Id shift 46',0.00,0.00,0.00,2394.81,0.00,'2022-09-03 07:59:24','',''),(754,'1','281','2',1,'Sale Id shift 46',0.00,0.00,0.00,2682.70,0.00,'2022-09-03 07:59:24','',''),(755,'1','281',NULL,2,'Sale Id shift 46',174728.00,0.00,0.00,0.00,0.00,'2022-09-03 07:59:24','',''),(756,'1','281',NULL,1,'Sale Id shift 46',3974112.65,0.00,0.00,0.00,0.00,'2022-09-03 07:59:24','',''),(757,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,2775000.00,15000.00,0.00,0.00,'2022-09-03 12:36:54','',''),(758,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,10924250.00,59050.00,0.00,0.00,'2022-09-03 12:37:45','',''),(759,'1','281',NULL,1,'Reception corrector for bridging 70',0.00,0.00,0.00,14550.00,0.00,'2022-09-03 13:38:35','',''),(760,'1','281','1',1,'Received from bridging 70',0.00,0.00,14550.00,0.00,0.00,'2022-09-03 13:38:35','',''),(761,'1','281',NULL,1,'Reception corrector for bridging 71',0.00,0.00,0.00,40000.00,0.00,'2022-09-03 13:38:59','',''),(762,'1','281','2',1,'Received from bridging 71',0.00,0.00,40000.00,0.00,0.00,'2022-09-03 13:38:59','',''),(763,'1','281',NULL,1,'Reception corrector for bridging 72',0.00,0.00,0.00,15000.00,0.00,'2022-09-03 13:40:51','',''),(764,'1','281','1',1,'Received from bridging 72',0.00,0.00,15000.00,0.00,0.00,'2022-09-03 13:40:51','',''),(765,'1','281','1',1,'Sale Id shift 47',0.00,0.00,0.00,92.40,0.00,'2022-09-03 17:12:01','',''),(766,'1','281','2',1,'Sale Id shift 47',0.00,0.00,0.00,634.46,0.00,'2022-09-03 17:12:01','',''),(767,'1','281','2',1,'Sale Id shift 47',0.00,0.00,0.00,3875.64,0.00,'2022-09-03 17:12:01','',''),(768,'1','281','2',1,'Sale Id shift 47',0.00,0.00,0.00,3340.73,0.00,'2022-09-03 17:12:01','',''),(769,'1','281','3',2,'Sale Id shift 47',0.00,0.00,0.00,200.13,0.00,'2022-09-03 17:12:01','',''),(770,'1','281','1',1,'Sale Id shift 47',0.00,0.00,0.00,856.94,0.00,'2022-09-03 17:12:01','',''),(771,'1','281','1',1,'Sale Id shift 47',0.00,0.00,0.00,3412.56,0.00,'2022-09-03 17:12:01','',''),(772,'1','281','1',1,'Sale Id shift 47',0.00,0.00,0.00,3501.07,0.00,'2022-09-03 17:12:01','',''),(773,'1','281','1',1,'Sale Id shift 47',0.00,0.00,0.00,799.38,0.00,'2022-09-03 17:12:01','',''),(774,'1','281','2',1,'Sale Id shift 47',0.00,0.00,0.00,5172.35,0.00,'2022-09-03 17:12:01','',''),(775,'1','281',NULL,2,'Sale Id shift 47',160104.00,0.00,0.00,0.00,0.00,'2022-09-03 17:12:01','',''),(776,'1','281',NULL,1,'Sale Id shift 47',4011823.05,0.00,0.00,0.00,0.00,'2022-09-03 17:12:01','',''),(777,'1','281',NULL,1,'Reception corrector for bridging 73',0.00,0.00,0.00,4500.00,0.00,'2022-09-03 19:00:13','',''),(778,'1','281','2',1,'Received from bridging 73',0.00,0.00,4500.00,0.00,0.00,'2022-09-03 19:00:13','',''),(779,'1','281','1',1,'Sale Id shift 48',0.00,0.00,0.00,2168.35,0.00,'2022-09-04 07:32:52','',''),(780,'1','281','2',1,'Sale Id shift 48',0.00,0.00,0.00,2330.90,0.00,'2022-09-04 07:32:52','',''),(781,'1','281','2',1,'Sale Id shift 48',0.00,0.00,0.00,2284.47,0.00,'2022-09-04 07:32:52','',''),(782,'1','281','2',1,'Sale Id shift 48',0.00,0.00,0.00,1933.87,0.00,'2022-09-04 07:32:52','',''),(783,'1','281','3',2,'Sale Id shift 48',0.00,0.00,0.00,509.58,0.00,'2022-09-04 07:32:52','',''),(784,'1','281','1',1,'Sale Id shift 48',0.00,0.00,0.00,2895.73,0.00,'2022-09-04 07:32:52','',''),(785,'1','281','1',1,'Sale Id shift 48',0.00,0.00,0.00,623.69,0.00,'2022-09-04 07:32:52','',''),(786,'1','281','1',1,'Sale Id shift 48',0.00,0.00,0.00,2103.20,0.00,'2022-09-04 07:32:52','',''),(787,'1','281','1',1,'Sale Id shift 48',0.00,0.00,0.00,2016.49,0.00,'2022-09-04 07:32:52','',''),(788,'1','281','1',1,'Sale Id shift 48',0.00,0.00,0.00,2070.52,0.00,'2022-09-04 07:32:52','',''),(789,'1','281','2',1,'Sale Id shift 48',0.00,0.00,0.00,2687.49,0.00,'2022-09-04 07:32:52','',''),(790,'1','281','2',1,'Sale Id shift 48',0.00,0.00,0.00,1899.76,0.00,'2022-09-04 07:32:52','',''),(791,'1','281',NULL,2,'Sale Id shift 48',407664.00,0.00,0.00,0.00,0.00,'2022-09-04 07:32:52','',''),(792,'1','281',NULL,1,'Sale Id shift 48',4257676.95,0.00,0.00,0.00,0.00,'2022-09-04 07:32:52','',''),(793,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8880000.00,48000.00,0.00,0.00,'2022-09-04 08:55:15','',''),(794,'1','281',NULL,1,'Reception corrector for bridging 75',0.00,0.00,0.00,20000.00,0.00,'2022-09-04 09:06:46','',''),(795,'1','281','2',1,'Received from bridging 75',0.00,0.00,20000.00,0.00,0.00,'2022-09-04 09:06:46','',''),(796,'1','281',NULL,1,'Reception corrector for bridging 76',0.00,0.00,0.00,24000.00,0.00,'2022-09-04 10:34:22','',''),(797,'1','281','1',1,'Received from bridging 76',0.00,0.00,24000.00,0.00,0.00,'2022-09-04 10:34:22','',''),(798,'1','281','1',1,'Sale Id shift 49',0.00,0.00,0.00,2246.38,0.00,'2022-09-04 15:04:43','',''),(799,'1','281','2',1,'Sale Id shift 49',0.00,0.00,0.00,3361.81,0.00,'2022-09-04 15:04:43','',''),(800,'1','281','2',1,'Sale Id shift 49',0.00,0.00,0.00,3081.84,0.00,'2022-09-04 15:04:43','',''),(801,'1','281','3',2,'Sale Id shift 49',0.00,0.00,0.00,968.72,0.00,'2022-09-04 15:04:43','',''),(802,'1','281','3',2,'Sale Id shift 49',0.00,0.00,0.00,28.12,0.00,'2022-09-04 15:04:43','',''),(803,'1','281','1',1,'Sale Id shift 49',0.00,0.00,0.00,2367.94,0.00,'2022-09-04 15:04:43','',''),(804,'1','281','1',1,'Sale Id shift 49',0.00,0.00,0.00,48.19,0.00,'2022-09-04 15:04:43','',''),(805,'1','281','1',1,'Sale Id shift 49',0.00,0.00,0.00,2429.15,0.00,'2022-09-04 15:04:43','',''),(806,'1','281','1',1,'Sale Id shift 49',0.00,0.00,0.00,2415.89,0.00,'2022-09-04 15:04:43','',''),(807,'1','281','2',1,'Sale Id shift 49',0.00,0.00,0.00,3573.66,0.00,'2022-09-04 15:04:43','',''),(808,'1','281',NULL,2,'Sale Id shift 49',797472.00,0.00,0.00,0.00,0.00,'2022-09-04 15:04:43','',''),(809,'1','281',NULL,1,'Sale Id shift 49',3612099.10,0.00,0.00,0.00,0.00,'2022-09-04 15:04:43','',''),(810,'1','281',NULL,1,'Reception corrector for bridging 77',0.00,0.00,0.00,4000.00,0.00,'2022-09-04 18:33:53','',''),(811,'1','281','2',1,'Received from bridging 77',0.00,0.00,4000.00,0.00,0.00,'2022-09-04 18:33:53','',''),(812,'1','281','1',1,'Sale Id shift 50',0.00,0.00,0.00,1942.42,0.00,'2022-09-05 08:06:58','',''),(813,'1','281','2',1,'Sale Id shift 50',0.00,0.00,0.00,1267.68,0.00,'2022-09-05 08:06:58','',''),(814,'1','281','2',1,'Sale Id shift 50',0.00,0.00,0.00,2162.30,0.00,'2022-09-05 08:06:58','',''),(815,'1','281','2',1,'Sale Id shift 50',0.00,0.00,0.00,1924.35,0.00,'2022-09-05 08:06:58','',''),(816,'1','281','3',2,'Sale Id shift 50',0.00,0.00,0.00,455.58,0.00,'2022-09-05 08:06:58','',''),(817,'1','281','1',1,'Sale Id shift 50',0.00,0.00,0.00,2797.82,0.00,'2022-09-05 08:06:58','',''),(818,'1','281','1',1,'Sale Id shift 50',0.00,0.00,0.00,1524.58,0.00,'2022-09-05 08:06:58','',''),(819,'1','281','1',1,'Sale Id shift 50',0.00,0.00,0.00,1674.96,0.00,'2022-09-05 08:06:58','',''),(820,'1','281','1',1,'Sale Id shift 50',0.00,0.00,0.00,1919.16,0.00,'2022-09-05 08:06:58','',''),(821,'1','281','1',1,'Sale Id shift 50',0.00,0.00,0.00,1527.42,0.00,'2022-09-05 08:06:58','',''),(822,'1','281','2',1,'Sale Id shift 50',0.00,0.00,0.00,3299.24,0.00,'2022-09-05 08:06:58','',''),(823,'1','281','2',1,'Sale Id shift 50',0.00,0.00,0.00,2286.76,0.00,'2022-09-05 08:06:58','',''),(824,'1','281',NULL,2,'Sale Id shift 50',364464.00,0.00,0.00,0.00,0.00,'2022-09-05 08:06:58','',''),(825,'1','281',NULL,1,'Sale Id shift 50',4130437.65,0.00,0.00,0.00,0.00,'2022-09-05 08:06:58','',''),(826,'1','281','1',1,'Sale Id shift 51',0.00,0.00,0.00,2867.35,0.00,'2022-09-05 15:48:26','',''),(827,'1','281','2',1,'Sale Id shift 51',0.00,0.00,0.00,1876.21,0.00,'2022-09-05 15:48:26','',''),(828,'1','281','2',1,'Sale Id shift 51',0.00,0.00,0.00,2354.48,0.00,'2022-09-05 15:48:26','',''),(829,'1','281','2',1,'Sale Id shift 51',0.00,0.00,0.00,2402.18,0.00,'2022-09-05 15:48:26','',''),(830,'1','281','3',2,'Sale Id shift 51',0.00,0.00,0.00,206.10,0.00,'2022-09-05 15:48:26','',''),(831,'1','281','3',2,'Sale Id shift 51',0.00,0.00,0.00,39.73,0.00,'2022-09-05 15:48:26','',''),(832,'1','281','1',1,'Sale Id shift 51',0.00,0.00,0.00,2509.64,0.00,'2022-09-05 15:48:26','',''),(833,'1','281','1',1,'Sale Id shift 51',0.00,0.00,0.00,1471.93,0.00,'2022-09-05 15:48:26','',''),(834,'1','281','1',1,'Sale Id shift 51',0.00,0.00,0.00,2505.12,0.00,'2022-09-05 15:48:26','',''),(835,'1','281','1',1,'Sale Id shift 51',0.00,0.00,0.00,1918.74,0.00,'2022-09-05 15:48:26','',''),(836,'1','281','1',1,'Sale Id shift 51',0.00,0.00,0.00,2394.05,0.00,'2022-09-05 15:48:26','',''),(837,'1','281','2',1,'Sale Id shift 51',0.00,0.00,0.00,2549.95,0.00,'2022-09-05 15:48:26','',''),(838,'1','281','2',1,'Sale Id shift 51',0.00,0.00,0.00,2092.80,0.00,'2022-09-05 15:48:26','',''),(839,'1','281',NULL,2,'Sale Id shift 51',196664.00,0.00,0.00,0.00,0.00,'2022-09-05 15:48:26','',''),(840,'1','281',NULL,1,'Sale Id shift 51',4614353.25,0.00,0.00,0.00,0.00,'2022-09-05 15:48:26','',''),(841,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-09-05 18:11:16','',''),(842,'1','281',NULL,1,'Reception corrector for bridging 78',0.00,0.00,0.00,30000.00,0.00,'2022-09-05 18:32:02','',''),(843,'1','281','1',1,'Received from bridging 78',0.00,0.00,30000.00,0.00,0.00,'2022-09-05 18:32:02','',''),(844,'1','281',NULL,1,'Reception corrector for bridging 79',0.00,0.00,0.00,15000.00,0.00,'2022-09-05 18:32:24','',''),(845,'1','281','2',1,'Received from bridging 79',0.00,0.00,15000.00,0.00,0.00,'2022-09-05 18:32:24','',''),(846,'1','281','1',1,'Sale Id shift 52',0.00,0.00,0.00,1723.01,0.00,'2022-09-06 08:12:19','',''),(847,'1','281','2',1,'Sale Id shift 52',0.00,0.00,0.00,2070.79,0.00,'2022-09-06 08:12:19','',''),(848,'1','281','2',1,'Sale Id shift 52',0.00,0.00,0.00,1393.21,0.00,'2022-09-06 08:12:19','',''),(849,'1','281','2',1,'Sale Id shift 52',0.00,0.00,0.00,2128.30,0.00,'2022-09-06 08:12:19','',''),(850,'1','281','3',2,'Sale Id shift 52',0.00,0.00,0.00,30.03,0.00,'2022-09-06 08:12:19','',''),(851,'1','281','3',2,'Sale Id shift 52',0.00,0.00,0.00,1013.25,0.00,'2022-09-06 08:12:19','',''),(852,'1','281','1',1,'Sale Id shift 52',0.00,0.00,0.00,3251.55,0.00,'2022-09-06 08:12:19','',''),(853,'1','281','1',1,'Sale Id shift 52',0.00,0.00,0.00,730.82,0.00,'2022-09-06 08:12:19','',''),(854,'1','281','1',1,'Sale Id shift 52',0.00,0.00,0.00,3171.20,0.00,'2022-09-06 08:12:19','',''),(855,'1','281','1',1,'Sale Id shift 52',0.00,0.00,0.00,2054.49,0.00,'2022-09-06 08:12:19','',''),(856,'1','281','1',1,'Sale Id shift 52',0.00,0.00,0.00,3962.17,0.00,'2022-09-06 08:12:19','',''),(857,'1','281','2',1,'Sale Id shift 52',0.00,0.00,0.00,3408.96,0.00,'2022-09-06 08:12:19','',''),(858,'1','281','2',1,'Sale Id shift 52',0.00,0.00,0.00,2480.55,0.00,'2022-09-06 08:12:19','',''),(859,'1','281',NULL,2,'Sale Id shift 52',834624.00,0.00,0.00,0.00,0.00,'2022-09-06 08:12:19','',''),(860,'1','281',NULL,1,'Sale Id shift 52',4879384.25,0.00,0.00,0.00,0.00,'2022-09-06 08:12:19','',''),(861,'1','281','1',1,'Sale Id shift 53',0.00,0.00,0.00,2628.01,0.00,'2022-09-06 14:59:28','',''),(862,'1','281','2',1,'Sale Id shift 53',0.00,0.00,0.00,1758.88,0.00,'2022-09-06 14:59:28','',''),(863,'1','281','2',1,'Sale Id shift 53',0.00,0.00,0.00,2920.06,0.00,'2022-09-06 14:59:28','',''),(864,'1','281','2',1,'Sale Id shift 53',0.00,0.00,0.00,2203.57,0.00,'2022-09-06 14:59:28','',''),(865,'1','281','3',2,'Sale Id shift 53',0.00,0.00,0.00,72.00,0.00,'2022-09-06 14:59:28','',''),(866,'1','281','1',1,'Sale Id shift 53',0.00,0.00,0.00,2141.16,0.00,'2022-09-06 14:59:28','',''),(867,'1','281','1',1,'Sale Id shift 53',0.00,0.00,0.00,3294.21,0.00,'2022-09-06 14:59:28','',''),(868,'1','281','1',1,'Sale Id shift 53',0.00,0.00,0.00,2441.55,0.00,'2022-09-06 14:59:28','',''),(869,'1','281','1',1,'Sale Id shift 53',0.00,0.00,0.00,2365.03,0.00,'2022-09-06 14:59:28','',''),(870,'1','281','2',1,'Sale Id shift 53',0.00,0.00,0.00,3393.78,0.00,'2022-09-06 14:59:28','',''),(871,'1','281','2',1,'Sale Id shift 53',0.00,0.00,0.00,2192.78,0.00,'2022-09-06 14:59:28','',''),(872,'1','281',NULL,2,'Sale Id shift 53',57600.00,0.00,0.00,0.00,0.00,'2022-09-06 14:59:28','',''),(873,'1','281',NULL,1,'Sale Id shift 53',4687720.55,0.00,0.00,0.00,0.00,'2022-09-06 14:59:28','',''),(874,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-09-06 19:30:32','',''),(875,'1','281',NULL,1,'Reception corrector for bridging 80',0.00,0.00,0.00,15000.00,0.00,'2022-09-06 19:37:54','',''),(876,'1','281','1',1,'Received from bridging 80',0.00,0.00,15000.00,0.00,0.00,'2022-09-06 19:37:54','',''),(877,'1','281',NULL,1,'Reception corrector for bridging 81',0.00,0.00,0.00,30000.00,0.00,'2022-09-06 19:38:19','',''),(878,'1','281','2',1,'Received from bridging 81',0.00,0.00,30000.00,0.00,0.00,'2022-09-06 19:38:19','',''),(879,'1','281','1',1,'Sale Id shift 54',0.00,0.00,0.00,2504.01,0.00,'2022-09-07 06:12:26','',''),(880,'1','281','2',1,'Sale Id shift 54',0.00,0.00,0.00,2639.99,0.00,'2022-09-07 06:12:26','',''),(881,'1','281','2',1,'Sale Id shift 54',0.00,0.00,0.00,2126.18,0.00,'2022-09-07 06:12:26','',''),(882,'1','281','2',1,'Sale Id shift 54',0.00,0.00,0.00,2204.97,0.00,'2022-09-07 06:12:26','',''),(883,'1','281','3',2,'Sale Id shift 54',0.00,0.00,0.00,1449.47,0.00,'2022-09-07 06:12:26','',''),(884,'1','281','3',2,'Sale Id shift 54',0.00,0.00,0.00,1064.77,0.00,'2022-09-07 06:12:26','',''),(885,'1','281','1',1,'Sale Id shift 54',0.00,0.00,0.00,2077.18,0.00,'2022-09-07 06:12:26','',''),(886,'1','281','1',1,'Sale Id shift 54',0.00,0.00,0.00,2415.04,0.00,'2022-09-07 06:12:26','',''),(887,'1','281','1',1,'Sale Id shift 54',0.00,0.00,0.00,1756.47,0.00,'2022-09-07 06:12:26','',''),(888,'1','281','1',1,'Sale Id shift 54',0.00,0.00,0.00,2248.73,0.00,'2022-09-07 06:12:26','',''),(889,'1','281','2',1,'Sale Id shift 54',0.00,0.00,0.00,3950.03,0.00,'2022-09-07 06:12:26','',''),(890,'1','281',NULL,2,'Sale Id shift 54',2011392.00,0.00,0.00,0.00,0.00,'2022-09-07 06:12:26','',''),(891,'1','281',NULL,1,'Sale Id shift 54',4055681.00,0.00,0.00,0.00,0.00,'2022-09-07 06:12:26','',''),(892,'1','281','1',1,'Sale Id shift 55',0.00,0.00,0.00,2025.65,0.00,'2022-09-07 17:45:01','',''),(893,'1','281','2',1,'Sale Id shift 55',0.00,0.00,0.00,2064.85,0.00,'2022-09-07 17:45:01','',''),(894,'1','281','2',1,'Sale Id shift 55',0.00,0.00,0.00,2825.69,0.00,'2022-09-07 17:45:01','',''),(895,'1','281','2',1,'Sale Id shift 55',0.00,0.00,0.00,2414.46,0.00,'2022-09-07 17:45:01','',''),(896,'1','281','3',2,'Sale Id shift 55',0.00,0.00,0.00,119.80,0.00,'2022-09-07 17:45:01','',''),(897,'1','281','1',1,'Sale Id shift 55',0.00,0.00,0.00,1735.52,0.00,'2022-09-07 17:45:01','',''),(898,'1','281','1',1,'Sale Id shift 55',0.00,0.00,0.00,732.53,0.00,'2022-09-07 17:45:01','',''),(899,'1','281','1',1,'Sale Id shift 55',0.00,0.00,0.00,2619.02,0.00,'2022-09-07 17:45:01','',''),(900,'1','281','1',1,'Sale Id shift 55',0.00,0.00,0.00,1709.92,0.00,'2022-09-07 17:45:01','',''),(901,'1','281','1',1,'Sale Id shift 55',0.00,0.00,0.00,1948.73,0.00,'2022-09-07 17:45:01','',''),(902,'1','281','2',1,'Sale Id shift 55',0.00,0.00,0.00,3389.44,0.00,'2022-09-07 17:45:01','',''),(903,'1','281','2',1,'Sale Id shift 55',0.00,0.00,0.00,1727.27,0.00,'2022-09-07 17:45:01','',''),(904,'1','281',NULL,2,'Sale Id shift 55',95840.00,0.00,0.00,0.00,0.00,'2022-09-07 17:45:01','',''),(905,'1','281',NULL,1,'Sale Id shift 55',4290719.80,0.00,0.00,0.00,0.00,'2022-09-07 17:45:01','',''),(906,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9250000.00,50000.00,0.00,0.00,'2022-09-08 07:11:58','',''),(907,'1','281',NULL,1,'Reception corrector for bridging 82',0.00,0.00,0.00,17750.00,0.00,'2022-09-08 07:55:53','',''),(908,'1','281','1',1,'Received from bridging 82',0.00,0.00,17750.00,0.00,0.00,'2022-09-08 07:55:53','',''),(909,'1','281','1',1,'Sale Id shift 56',0.00,0.00,0.00,769.51,0.00,'2022-09-08 08:21:41','',''),(910,'1','281','2',1,'Sale Id shift 56',0.00,0.00,0.00,1883.72,0.00,'2022-09-08 08:21:41','',''),(911,'1','281','2',1,'Sale Id shift 56',0.00,0.00,0.00,2305.97,0.00,'2022-09-08 08:21:41','',''),(912,'1','281','2',1,'Sale Id shift 56',0.00,0.00,0.00,1793.88,0.00,'2022-09-08 08:21:41','',''),(913,'1','281','3',2,'Sale Id shift 56',0.00,0.00,0.00,1688.01,0.00,'2022-09-08 08:21:41','',''),(914,'1','281','3',2,'Sale Id shift 56',0.00,0.00,0.00,21.13,0.00,'2022-09-08 08:21:41','',''),(915,'1','281','1',1,'Sale Id shift 56',0.00,0.00,0.00,2004.06,0.00,'2022-09-08 08:21:41','',''),(916,'1','281','1',1,'Sale Id shift 56',0.00,0.00,0.00,1608.93,0.00,'2022-09-08 08:21:41','',''),(917,'1','281','1',1,'Sale Id shift 56',0.00,0.00,0.00,1865.76,0.00,'2022-09-08 08:21:41','',''),(918,'1','281','1',1,'Sale Id shift 56',0.00,0.00,0.00,859.36,0.00,'2022-09-08 08:21:41','',''),(919,'1','281','1',1,'Sale Id shift 56',0.00,0.00,0.00,1697.32,0.00,'2022-09-08 08:21:41','',''),(920,'1','281','2',1,'Sale Id shift 56',0.00,0.00,0.00,2566.79,0.00,'2022-09-08 08:21:41','',''),(921,'1','281','2',1,'Sale Id shift 56',0.00,0.00,0.00,1470.64,0.00,'2022-09-08 08:21:41','',''),(922,'1','281',NULL,2,'Sale Id shift 56',1367312.00,0.00,0.00,0.00,0.00,'2022-09-08 08:21:41','',''),(923,'1','281',NULL,1,'Sale Id shift 56',3482798.90,0.00,0.00,0.00,0.00,'2022-09-08 08:21:41','',''),(924,'1','281',NULL,1,'Reception corrector for bridging 83',0.00,0.00,0.00,32250.00,0.00,'2022-09-08 14:45:43','',''),(925,'1','281','2',1,'Received from bridging 83',0.00,0.00,32250.00,0.00,0.00,'2022-09-08 14:45:43','',''),(926,'1','281','1',1,'Sale Id shift 57',0.00,0.00,0.00,1114.90,0.00,'2022-09-08 14:53:05','',''),(927,'1','281','2',1,'Sale Id shift 57',0.00,0.00,0.00,842.23,0.00,'2022-09-08 14:53:05','',''),(928,'1','281','2',1,'Sale Id shift 57',0.00,0.00,0.00,3513.86,0.00,'2022-09-08 14:53:05','',''),(929,'1','281','2',1,'Sale Id shift 57',0.00,0.00,0.00,2420.36,0.00,'2022-09-08 14:53:05','',''),(930,'1','281','3',2,'Sale Id shift 57',0.00,0.00,0.00,86.03,0.00,'2022-09-08 14:53:05','',''),(931,'1','281','1',1,'Sale Id shift 57',0.00,0.00,0.00,1242.21,0.00,'2022-09-08 14:53:05','',''),(932,'1','281','1',1,'Sale Id shift 57',0.00,0.00,0.00,1980.42,0.00,'2022-09-08 14:53:05','',''),(933,'1','281','1',1,'Sale Id shift 57',0.00,0.00,0.00,2900.17,0.00,'2022-09-08 14:53:05','',''),(934,'1','281','1',1,'Sale Id shift 57',0.00,0.00,0.00,1227.01,0.00,'2022-09-08 14:53:05','',''),(935,'1','281','1',1,'Sale Id shift 57',0.00,0.00,0.00,891.74,0.00,'2022-09-08 14:53:05','',''),(936,'1','281','2',1,'Sale Id shift 57',0.00,0.00,0.00,4965.74,0.00,'2022-09-08 14:53:05','',''),(937,'1','281','2',1,'Sale Id shift 57',0.00,0.00,0.00,1240.93,0.00,'2022-09-08 14:53:05','',''),(938,'1','281',NULL,2,'Sale Id shift 57',68824.00,0.00,0.00,0.00,0.00,'2022-09-08 14:53:05','',''),(939,'1','281',NULL,1,'Sale Id shift 57',4132820.45,0.00,0.00,0.00,0.00,'2022-09-08 14:53:05','',''),(940,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9250000.00,50000.00,0.00,0.00,'2022-09-08 21:55:32','',''),(941,'1','281',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,11200000.00,14000.00,0.00,0.00,'2022-09-08 21:56:06','',''),(942,'1','281',NULL,2,'Reception corrector for bridging 84',0.00,0.00,0.00,14000.00,0.00,'2022-09-09 06:26:48','',''),(943,'1','281','3',2,'Received from bridging 84',0.00,0.00,14000.00,0.00,0.00,'2022-09-09 06:26:48','',''),(944,'1','281',NULL,1,'Reception corrector for bridging 85',0.00,0.00,0.00,33000.00,0.00,'2022-09-09 06:28:43','',''),(945,'1','281','1',1,'Received from bridging 85',0.00,0.00,33000.00,0.00,0.00,'2022-09-09 06:28:43','',''),(946,'1','281',NULL,1,'Reception corrector for bridging 86',0.00,0.00,0.00,17000.00,0.00,'2022-09-09 06:29:11','',''),(947,'1','281','2',1,'Received from bridging 86',0.00,0.00,17000.00,0.00,0.00,'2022-09-09 06:29:11','',''),(948,'1','281','1',1,'Sale Id shift 58',0.00,0.00,0.00,2569.54,0.00,'2022-09-09 08:19:44','',''),(949,'1','281','2',1,'Sale Id shift 58',0.00,0.00,0.00,739.75,0.00,'2022-09-09 08:19:44','',''),(950,'1','281','2',1,'Sale Id shift 58',0.00,0.00,0.00,2960.32,0.00,'2022-09-09 08:19:44','',''),(951,'1','281','2',1,'Sale Id shift 58',0.00,0.00,0.00,2236.01,0.00,'2022-09-09 08:19:44','',''),(952,'1','281','3',2,'Sale Id shift 58',0.00,0.00,0.00,317.89,0.00,'2022-09-09 08:19:44','',''),(953,'1','281','1',1,'Sale Id shift 58',0.00,0.00,0.00,3880.37,0.00,'2022-09-09 08:19:44','',''),(954,'1','281','1',1,'Sale Id shift 58',0.00,0.00,0.00,2032.98,0.00,'2022-09-09 08:19:44','',''),(955,'1','281','1',1,'Sale Id shift 58',0.00,0.00,0.00,2002.15,0.00,'2022-09-09 08:19:44','',''),(956,'1','281','1',1,'Sale Id shift 58',0.00,0.00,0.00,724.86,0.00,'2022-09-09 08:19:44','',''),(957,'1','281','1',1,'Sale Id shift 58',0.00,0.00,0.00,458.79,0.00,'2022-09-09 08:19:44','',''),(958,'1','281','2',1,'Sale Id shift 58',0.00,0.00,0.00,2857.18,0.00,'2022-09-09 08:19:44','',''),(959,'1','281','2',1,'Sale Id shift 58',0.00,0.00,0.00,1014.44,0.00,'2022-09-09 08:19:44','',''),(960,'1','281',NULL,2,'Sale Id shift 58',254312.00,0.00,0.00,0.00,0.00,'2022-09-09 08:19:44','',''),(961,'1','281',NULL,1,'Sale Id shift 58',3973132.15,0.00,0.00,0.00,0.00,'2022-09-09 08:19:44','',''),(962,'1','281','1',1,'Sale Id shift 59',0.00,0.00,0.00,1886.51,0.00,'2022-09-09 19:21:41','',''),(963,'1','281','2',1,'Sale Id shift 59',0.00,0.00,0.00,1818.59,0.00,'2022-09-09 19:21:41','',''),(964,'1','281','2',1,'Sale Id shift 59',0.00,0.00,0.00,2405.47,0.00,'2022-09-09 19:21:41','',''),(965,'1','281','2',1,'Sale Id shift 59',0.00,0.00,0.00,1936.54,0.00,'2022-09-09 19:21:41','',''),(966,'1','281','3',2,'Sale Id shift 59',0.00,0.00,0.00,874.55,0.00,'2022-09-09 19:21:41','',''),(967,'1','281','1',1,'Sale Id shift 59',0.00,0.00,0.00,2454.87,0.00,'2022-09-09 19:21:41','',''),(968,'1','281','1',1,'Sale Id shift 59',0.00,0.00,0.00,1753.58,0.00,'2022-09-09 19:21:41','',''),(969,'1','281','1',1,'Sale Id shift 59',0.00,0.00,0.00,2199.50,0.00,'2022-09-09 19:21:41','',''),(970,'1','281','1',1,'Sale Id shift 59',0.00,0.00,0.00,2912.54,0.00,'2022-09-09 19:21:41','',''),(971,'1','281','2',1,'Sale Id shift 59',0.00,0.00,0.00,2760.24,0.00,'2022-09-09 19:21:41','',''),(972,'1','281','2',1,'Sale Id shift 59',0.00,0.00,0.00,2059.97,0.00,'2022-09-09 19:21:41','',''),(973,'1','281',NULL,2,'Sale Id shift 59',699640.00,0.00,0.00,0.00,0.00,'2022-09-09 19:21:41','',''),(974,'1','281',NULL,1,'Sale Id shift 59',4104744.85,0.00,0.00,0.00,0.00,'2022-09-09 19:21:41','',''),(975,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,7261250.00,39250.00,0.00,0.00,'2022-09-09 19:24:16','',''),(976,'1','281','1',1,'Sale Id shift 60',0.00,0.00,0.00,1351.01,0.00,'2022-09-10 07:48:57','',''),(977,'1','281','2',1,'Sale Id shift 60',0.00,0.00,0.00,2435.32,0.00,'2022-09-10 07:48:57','',''),(978,'1','281','2',1,'Sale Id shift 60',0.00,0.00,0.00,1693.82,0.00,'2022-09-10 07:48:57','',''),(979,'1','281','2',1,'Sale Id shift 60',0.00,0.00,0.00,1536.28,0.00,'2022-09-10 07:48:57','',''),(980,'1','281','3',2,'Sale Id shift 60',0.00,0.00,0.00,2057.31,0.00,'2022-09-10 07:48:57','',''),(981,'1','281','3',2,'Sale Id shift 60',0.00,0.00,0.00,21.25,0.00,'2022-09-10 07:48:57','',''),(982,'1','281','1',1,'Sale Id shift 60',0.00,0.00,0.00,3086.20,0.00,'2022-09-10 07:48:57','',''),(983,'1','281','1',1,'Sale Id shift 60',0.00,0.00,0.00,1478.14,0.00,'2022-09-10 07:48:57','',''),(984,'1','281','1',1,'Sale Id shift 60',0.00,0.00,0.00,1615.01,0.00,'2022-09-10 07:48:57','',''),(985,'1','281','1',1,'Sale Id shift 60',0.00,0.00,0.00,2389.26,0.00,'2022-09-10 07:48:57','',''),(986,'1','281','1',1,'Sale Id shift 60',0.00,0.00,0.00,1223.36,0.00,'2022-09-10 07:48:57','',''),(987,'1','281','2',1,'Sale Id shift 60',0.00,0.00,0.00,2811.14,0.00,'2022-09-10 07:48:57','',''),(988,'1','281','2',1,'Sale Id shift 60',0.00,0.00,0.00,1214.14,0.00,'2022-09-10 07:48:57','',''),(989,'1','281',NULL,2,'Sale Id shift 60',1662848.00,0.00,0.00,0.00,0.00,'2022-09-10 07:48:57','',''),(990,'1','281',NULL,1,'Sale Id shift 60',3854230.80,0.00,0.00,0.00,0.00,'2022-09-10 07:48:57','',''),(991,'1','281',NULL,1,'Reception corrector for bridging 87',0.00,0.00,0.00,35000.00,0.00,'2022-09-10 14:22:34','',''),(992,'1','281','2',1,'Received from bridging 87',0.00,0.00,35000.00,0.00,0.00,'2022-09-10 14:22:34','',''),(993,'1','281','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,3322.13,0.00,'2022-09-10 14:58:01','',''),(994,'1','281','1',0,'Inventory adjustment from tank dipping to 15099',0.00,0.00,15099.00,0.00,0.00,'2022-09-10 14:58:01','',''),(995,'1','281','2',1,'Sale Id shift 61',0.00,0.00,0.00,280.72,0.00,'2022-09-10 18:29:32','',''),(996,'1','281','2',1,'Sale Id shift 61',0.00,0.00,0.00,4116.87,0.00,'2022-09-10 18:29:32','',''),(997,'1','281','2',1,'Sale Id shift 61',0.00,0.00,0.00,3488.45,0.00,'2022-09-10 18:29:32','',''),(998,'1','281','3',2,'Sale Id shift 61',0.00,0.00,0.00,651.45,0.00,'2022-09-10 18:29:32','',''),(999,'1','281','3',2,'Sale Id shift 61',0.00,0.00,0.00,1.87,0.00,'2022-09-10 18:29:32','',''),(1000,'1','281','1',1,'Sale Id shift 61',0.00,0.00,0.00,154.04,0.00,'2022-09-10 18:29:32','',''),(1001,'1','281','1',1,'Sale Id shift 61',0.00,0.00,0.00,3662.76,0.00,'2022-09-10 18:29:32','',''),(1002,'1','281','1',1,'Sale Id shift 61',0.00,0.00,0.00,3619.52,0.00,'2022-09-10 18:29:32','',''),(1003,'1','281','1',1,'Sale Id shift 61',0.00,0.00,0.00,251.58,0.00,'2022-09-10 18:29:32','',''),(1004,'1','281','2',1,'Sale Id shift 61',0.00,0.00,0.00,5036.00,0.00,'2022-09-10 18:29:32','',''),(1005,'1','281',NULL,2,'Sale Id shift 61',522656.00,0.00,0.00,0.00,0.00,'2022-09-10 18:29:32','',''),(1006,'1','281',NULL,1,'Sale Id shift 61',3812838.90,0.00,0.00,0.00,0.00,'2022-09-10 18:29:32','',''),(1007,'1','281',NULL,1,'Reception corrector for bridging 88',0.00,0.00,0.00,4250.00,0.00,'2022-09-10 19:51:06','',''),(1008,'1','281','2',1,'Received from bridging 88',0.00,0.00,4250.00,0.00,0.00,'2022-09-10 19:51:06','',''),(1009,'1','281','2',1,'Sale Id shift 62',0.00,0.00,0.00,423.56,0.00,'2022-09-11 07:51:00','',''),(1010,'1','281','2',1,'Sale Id shift 62',0.00,0.00,0.00,3520.00,0.00,'2022-09-11 07:51:00','',''),(1011,'1','281','2',1,'Sale Id shift 62',0.00,0.00,0.00,2578.06,0.00,'2022-09-11 07:51:00','',''),(1012,'1','281','3',2,'Sale Id shift 62',0.00,0.00,0.00,390.44,0.00,'2022-09-11 07:51:00','',''),(1013,'1','281','3',2,'Sale Id shift 62',0.00,0.00,0.00,20.00,0.00,'2022-09-11 07:51:00','',''),(1014,'1','281','1',1,'Sale Id shift 62',0.00,0.00,0.00,622.12,0.00,'2022-09-11 07:51:00','',''),(1015,'1','281','1',1,'Sale Id shift 62',0.00,0.00,0.00,3114.55,0.00,'2022-09-11 07:51:00','',''),(1016,'1','281','1',1,'Sale Id shift 62',0.00,0.00,0.00,2794.44,0.00,'2022-09-11 07:51:00','',''),(1017,'1','281','1',1,'Sale Id shift 62',0.00,0.00,0.00,524.47,0.00,'2022-09-11 07:51:00','',''),(1018,'1','281','1',1,'Sale Id shift 62',0.00,0.00,0.00,212.70,0.00,'2022-09-11 07:51:00','',''),(1019,'1','281','2',1,'Sale Id shift 62',0.00,0.00,0.00,4329.25,0.00,'2022-09-11 07:51:00','',''),(1020,'1','281','2',1,'Sale Id shift 62',0.00,0.00,0.00,183.69,0.00,'2022-09-11 07:51:00','',''),(1021,'1','281',NULL,2,'Sale Id shift 62',328352.00,0.00,0.00,0.00,0.00,'2022-09-11 07:51:00','',''),(1022,'1','281',NULL,1,'Sale Id shift 62',3386025.40,0.00,0.00,0.00,0.00,'2022-09-11 07:51:00','',''),(1023,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9250000.00,50000.00,0.00,0.00,'2022-09-11 10:41:31','',''),(1024,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,138750.00,750.00,0.00,0.00,'2022-09-11 10:42:31','',''),(1025,'1','281',NULL,1,'Reception corrector for bridging 89',0.00,0.00,0.00,750.00,0.00,'2022-09-11 11:04:04','',''),(1026,'1','281','2',1,'Received from bridging 89',0.00,0.00,750.00,0.00,0.00,'2022-09-11 11:04:04','',''),(1027,'1','281',NULL,1,'Reception corrector for bridging 90',0.00,0.00,0.00,31000.00,0.00,'2022-09-11 11:06:20','',''),(1028,'1','281','1',1,'Received from bridging 90',0.00,0.00,31000.00,0.00,0.00,'2022-09-11 11:06:20','',''),(1029,'1','281',NULL,1,'Reception corrector for bridging 91',0.00,0.00,0.00,19000.00,0.00,'2022-09-11 11:06:43','',''),(1030,'1','281','2',1,'Received from bridging 91',0.00,0.00,19000.00,0.00,0.00,'2022-09-11 11:06:43','',''),(1031,'1','281','1',1,'Sale Id shift 63',0.00,0.00,0.00,2320.59,0.00,'2022-09-11 14:54:15','',''),(1032,'1','281','2',1,'Sale Id shift 63',0.00,0.00,0.00,1002.33,0.00,'2022-09-11 14:54:15','',''),(1033,'1','281','2',1,'Sale Id shift 63',0.00,0.00,0.00,2592.07,0.00,'2022-09-11 14:54:15','',''),(1034,'1','281','3',2,'Sale Id shift 63',0.00,0.00,0.00,1317.60,0.00,'2022-09-11 14:54:15','',''),(1035,'1','281','3',2,'Sale Id shift 63',0.00,0.00,0.00,17.11,0.00,'2022-09-11 14:54:15','',''),(1036,'1','281','1',1,'Sale Id shift 63',0.00,0.00,0.00,2198.64,0.00,'2022-09-11 14:54:15','',''),(1037,'1','281','1',1,'Sale Id shift 63',0.00,0.00,0.00,3030.27,0.00,'2022-09-11 14:54:15','',''),(1038,'1','281','1',1,'Sale Id shift 63',0.00,0.00,0.00,1616.12,0.00,'2022-09-11 14:54:15','',''),(1039,'1','281','1',1,'Sale Id shift 63',0.00,0.00,0.00,2038.57,0.00,'2022-09-11 14:54:15','',''),(1040,'1','281','2',1,'Sale Id shift 63',0.00,0.00,0.00,3063.15,0.00,'2022-09-11 14:54:15','',''),(1041,'1','281','2',1,'Sale Id shift 63',0.00,0.00,0.00,2625.03,0.00,'2022-09-11 14:54:15','',''),(1042,'1','281',NULL,2,'Sale Id shift 63',1054420.90,0.00,0.00,0.00,0.00,'2022-09-11 14:54:15','',''),(1043,'1','281',NULL,1,'Sale Id shift 63',3790052.45,0.00,0.00,0.00,0.00,'2022-09-11 14:54:15','',''),(1044,'1','281','2',1,'Sale Id shift 64',0.00,0.00,0.00,1877.32,0.00,'2022-09-11 20:49:07','',''),(1045,'1','281','2',1,'Sale Id shift 64',0.00,0.00,0.00,2214.68,0.00,'2022-09-11 20:49:07','',''),(1046,'1','281','3',2,'Sale Id shift 64',0.00,0.00,0.00,168.66,0.00,'2022-09-11 20:49:07','',''),(1047,'1','281','1',1,'Sale Id shift 64',0.00,0.00,0.00,3690.62,0.00,'2022-09-11 20:49:07','',''),(1048,'1','281','1',1,'Sale Id shift 64',0.00,0.00,0.00,2523.37,0.00,'2022-09-11 20:49:07','',''),(1049,'1','281','1',1,'Sale Id shift 64',0.00,0.00,0.00,1709.85,0.00,'2022-09-11 20:49:07','',''),(1050,'1','281','1',1,'Sale Id shift 64',0.00,0.00,0.00,2118.38,0.00,'2022-09-11 20:49:07','',''),(1051,'1','281','2',1,'Sale Id shift 64',0.00,0.00,0.00,2791.41,0.00,'2022-09-11 20:49:07','',''),(1052,'1','281','2',1,'Sale Id shift 64',0.00,0.00,0.00,1680.88,0.00,'2022-09-11 20:49:07','',''),(1053,'1','281',NULL,2,'Sale Id shift 64',133241.40,0.00,0.00,0.00,0.00,'2022-09-11 20:49:07','',''),(1054,'1','281',NULL,1,'Sale Id shift 64',3442204.35,0.00,0.00,0.00,0.00,'2022-09-11 20:49:07','',''),(1055,'1','281','1',1,'Sale Id shift 65',0.00,0.00,0.00,1046.13,0.00,'2022-09-12 15:09:13','',''),(1056,'1','281','2',1,'Sale Id shift 65',0.00,0.00,0.00,1256.39,0.00,'2022-09-12 15:09:13','',''),(1057,'1','281','2',1,'Sale Id shift 65',0.00,0.00,0.00,356.60,0.00,'2022-09-12 15:09:13','',''),(1058,'1','281','2',1,'Sale Id shift 65',0.00,0.00,0.00,372.66,0.00,'2022-09-12 15:09:13','',''),(1059,'1','281','3',2,'Sale Id shift 65',0.00,0.00,0.00,216.39,0.00,'2022-09-12 15:09:13','',''),(1060,'1','281','1',1,'Sale Id shift 65',0.00,0.00,0.00,1264.40,0.00,'2022-09-12 15:09:13','',''),(1061,'1','281','1',1,'Sale Id shift 65',0.00,0.00,0.00,170.40,0.00,'2022-09-12 15:09:13','',''),(1062,'1','281','1',1,'Sale Id shift 65',0.00,0.00,0.00,274.65,0.00,'2022-09-12 15:09:13','',''),(1063,'1','281','1',1,'Sale Id shift 65',0.00,0.00,0.00,1174.69,0.00,'2022-09-12 15:09:13','',''),(1064,'1','281','1',1,'Sale Id shift 65',0.00,0.00,0.00,1261.05,0.00,'2022-09-12 15:09:13','',''),(1065,'1','281','2',1,'Sale Id shift 65',0.00,0.00,0.00,527.36,0.00,'2022-09-12 15:09:13','',''),(1066,'1','281','2',1,'Sale Id shift 65',0.00,0.00,0.00,976.24,0.00,'2022-09-12 15:09:13','',''),(1067,'1','281',NULL,2,'Sale Id shift 65',170948.10,0.00,0.00,0.00,0.00,'2022-09-12 15:09:13','',''),(1068,'1','281',NULL,1,'Sale Id shift 65',1605905.45,0.00,0.00,0.00,0.00,'2022-09-12 15:09:13','',''),(1069,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,6845000.00,37000.00,0.00,0.00,'2022-09-12 18:18:54','',''),(1070,'1','281','2',1,'Sale Id shift 66',0.00,0.00,0.00,1735.54,0.00,'2022-09-13 08:13:40','',''),(1071,'1','281','2',1,'Sale Id shift 66',0.00,0.00,0.00,1621.38,0.00,'2022-09-13 08:13:40','',''),(1072,'1','281','3',2,'Sale Id shift 66',0.00,0.00,0.00,228.34,0.00,'2022-09-13 08:13:40','',''),(1073,'1','281','3',2,'Sale Id shift 66',0.00,0.00,0.00,92.45,0.00,'2022-09-13 08:13:40','',''),(1074,'1','281','1',1,'Sale Id shift 66',0.00,0.00,0.00,1500.93,0.00,'2022-09-13 08:13:40','',''),(1075,'1','281','1',1,'Sale Id shift 66',0.00,0.00,0.00,1955.63,0.00,'2022-09-13 08:13:40','',''),(1076,'1','281','2',1,'Sale Id shift 66',0.00,0.00,0.00,1883.61,0.00,'2022-09-13 08:13:40','',''),(1077,'1','281',NULL,2,'Sale Id shift 66',253424.10,0.00,0.00,0.00,0.00,'2022-09-13 08:13:40','',''),(1078,'1','281',NULL,1,'Sale Id shift 66',1608961.65,0.00,0.00,0.00,0.00,'2022-09-13 08:13:40','',''),(1079,'1','281',NULL,1,'Reception corrector for bridging 92',0.00,0.00,0.00,25000.00,0.00,'2022-09-13 10:07:03','',''),(1080,'1','281','1',1,'Received from bridging 92',0.00,0.00,25000.00,0.00,0.00,'2022-09-13 10:07:03','',''),(1081,'1','281',NULL,1,'Reception corrector for bridging 93',0.00,0.00,0.00,12000.00,0.00,'2022-09-13 10:07:49','',''),(1082,'1','281','2',1,'Received from bridging 93',0.00,0.00,12000.00,0.00,0.00,'2022-09-13 10:07:49','',''),(1083,'1','281','1',1,'Sale Id shift 67',0.00,0.00,0.00,3037.02,0.00,'2022-09-13 15:25:56','',''),(1084,'1','281','2',1,'Sale Id shift 67',0.00,0.00,0.00,3958.72,0.00,'2022-09-13 15:25:56','',''),(1085,'1','281','2',1,'Sale Id shift 67',0.00,0.00,0.00,3598.01,0.00,'2022-09-13 15:25:56','',''),(1086,'1','281','3',2,'Sale Id shift 67',0.00,0.00,0.00,1000.00,0.00,'2022-09-13 15:25:56','',''),(1087,'1','281','3',2,'Sale Id shift 67',0.00,0.00,0.00,62.64,0.00,'2022-09-13 15:25:56','',''),(1088,'1','281','1',1,'Sale Id shift 67',0.00,0.00,0.00,3093.86,0.00,'2022-09-13 15:25:56','',''),(1089,'1','281','1',1,'Sale Id shift 67',0.00,0.00,0.00,3066.38,0.00,'2022-09-13 15:25:56','',''),(1090,'1','281','1',1,'Sale Id shift 67',0.00,0.00,0.00,3056.93,0.00,'2022-09-13 15:25:56','',''),(1091,'1','281','2',1,'Sale Id shift 67',0.00,0.00,0.00,3484.30,0.00,'2022-09-13 15:25:56','',''),(1092,'1','281',NULL,2,'Sale Id shift 67',839485.60,0.00,0.00,0.00,0.00,'2022-09-13 15:25:56','',''),(1093,'1','281',NULL,1,'Sale Id shift 67',4309615.70,0.00,0.00,0.00,0.00,'2022-09-13 15:25:56','',''),(1094,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9250000.00,50000.00,0.00,0.00,'2022-09-13 19:42:32','',''),(1095,'1','281',NULL,1,'Reception corrector for bridging 94',0.00,0.00,0.00,32500.00,0.00,'2022-09-13 19:50:35','',''),(1096,'1','281','1',1,'Received from bridging 94',0.00,0.00,32500.00,0.00,0.00,'2022-09-13 19:50:35','',''),(1097,'1','281',NULL,1,'Reception corrector for bridging 95',0.00,0.00,0.00,17500.00,0.00,'2022-09-13 19:50:55','',''),(1098,'1','281','2',1,'Received from bridging 95',0.00,0.00,17500.00,0.00,0.00,'2022-09-13 19:50:55','',''),(1099,'1','281','1',1,'Sale Id shift 68',0.00,0.00,0.00,1941.00,0.00,'2022-09-14 08:07:30','',''),(1100,'1','281','2',1,'Sale Id shift 68',0.00,0.00,0.00,1908.51,0.00,'2022-09-14 08:07:30','',''),(1101,'1','281','2',1,'Sale Id shift 68',0.00,0.00,0.00,1187.21,0.00,'2022-09-14 08:07:30','',''),(1102,'1','281','2',1,'Sale Id shift 68',0.00,0.00,0.00,2202.37,0.00,'2022-09-14 08:07:30','',''),(1103,'1','281','3',2,'Sale Id shift 68',0.00,0.00,0.00,2397.36,0.00,'2022-09-14 08:07:30','',''),(1104,'1','281','3',2,'Sale Id shift 68',0.00,0.00,0.00,4.80,0.00,'2022-09-14 08:07:30','',''),(1105,'1','281','1',1,'Sale Id shift 68',0.00,0.00,0.00,2023.82,0.00,'2022-09-14 08:07:30','',''),(1106,'1','281','1',1,'Sale Id shift 68',0.00,0.00,0.00,1393.49,0.00,'2022-09-14 08:07:30','',''),(1107,'1','281','1',1,'Sale Id shift 68',0.00,0.00,0.00,2107.40,0.00,'2022-09-14 08:07:30','',''),(1108,'1','281','1',1,'Sale Id shift 68',0.00,0.00,0.00,2228.79,0.00,'2022-09-14 08:07:30','',''),(1109,'1','281','2',1,'Sale Id shift 68',0.00,0.00,0.00,2884.15,0.00,'2022-09-14 08:07:30','',''),(1110,'1','281','2',1,'Sale Id shift 68',0.00,0.00,0.00,2151.37,0.00,'2022-09-14 08:07:30','',''),(1111,'1','281',NULL,2,'Sale Id shift 68',1897706.40,0.00,0.00,0.00,0.00,'2022-09-14 08:07:30','',''),(1112,'1','281',NULL,1,'Sale Id shift 68',3705200.35,0.00,0.00,0.00,0.00,'2022-09-14 08:07:30','',''),(1113,'1','281','1',1,'Sale Id shift 69',0.00,0.00,0.00,2467.71,0.00,'2022-09-14 15:05:26','',''),(1114,'1','281','2',1,'Sale Id shift 69',0.00,0.00,0.00,3527.98,0.00,'2022-09-14 15:05:26','',''),(1115,'1','281','2',1,'Sale Id shift 69',0.00,0.00,0.00,3617.09,0.00,'2022-09-14 15:05:26','',''),(1116,'1','281','3',2,'Sale Id shift 69',0.00,0.00,0.00,2150.15,0.00,'2022-09-14 15:05:26','',''),(1117,'1','281','3',2,'Sale Id shift 69',0.00,0.00,0.00,102.11,0.00,'2022-09-14 15:05:26','',''),(1118,'1','281','1',1,'Sale Id shift 69',0.00,0.00,0.00,3452.87,0.00,'2022-09-14 15:05:26','',''),(1119,'1','281','1',1,'Sale Id shift 69',0.00,0.00,0.00,3117.09,0.00,'2022-09-14 15:05:26','',''),(1120,'1','281','1',1,'Sale Id shift 69',0.00,0.00,0.00,3944.52,0.00,'2022-09-14 15:05:26','',''),(1121,'1','281','2',1,'Sale Id shift 69',0.00,0.00,0.00,3327.95,0.00,'2022-09-14 15:05:26','',''),(1122,'1','281',NULL,2,'Sale Id shift 69',1779285.40,0.00,0.00,0.00,0.00,'2022-09-14 15:05:26','',''),(1123,'1','281',NULL,1,'Sale Id shift 69',4339213.85,0.00,0.00,0.00,0.00,'2022-09-14 15:05:26','',''),(1124,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9250000.00,50000.00,0.00,0.00,'2022-09-14 20:23:55','',''),(1125,'1','281',NULL,1,'Reception corrector for bridging 96',0.00,0.00,0.00,20000.00,0.00,'2022-09-14 20:38:47','',''),(1126,'1','281','1',1,'Received from bridging 96',0.00,0.00,20000.00,0.00,0.00,'2022-09-14 20:38:47','',''),(1127,'1','281',NULL,1,'Reception corrector for bridging 97',0.00,0.00,0.00,30000.00,0.00,'2022-09-14 20:39:37','',''),(1128,'1','281','2',1,'Received from bridging 97',0.00,0.00,30000.00,0.00,0.00,'2022-09-14 20:39:37','',''),(1129,'1','281','1',1,'Sale Id shift 70',0.00,0.00,0.00,2656.77,0.00,'2022-09-15 08:22:48','',''),(1130,'1','281','2',1,'Sale Id shift 70',0.00,0.00,0.00,2880.23,0.00,'2022-09-15 08:22:48','',''),(1131,'1','281','2',1,'Sale Id shift 70',0.00,0.00,0.00,1253.85,0.00,'2022-09-15 08:22:48','',''),(1132,'1','281','2',1,'Sale Id shift 70',0.00,0.00,0.00,1188.79,0.00,'2022-09-15 08:22:48','',''),(1133,'1','281','3',2,'Sale Id shift 70',0.00,0.00,0.00,2607.47,0.00,'2022-09-15 08:22:48','',''),(1134,'1','281','3',2,'Sale Id shift 70',0.00,0.00,0.00,94.94,0.00,'2022-09-15 08:22:48','',''),(1135,'1','281','1',1,'Sale Id shift 70',0.00,0.00,0.00,2217.31,0.00,'2022-09-15 08:22:48','',''),(1136,'1','281','1',1,'Sale Id shift 70',0.00,0.00,0.00,1739.45,0.00,'2022-09-15 08:22:48','',''),(1137,'1','281','1',1,'Sale Id shift 70',0.00,0.00,0.00,834.35,0.00,'2022-09-15 08:22:48','',''),(1138,'1','281','1',1,'Sale Id shift 70',0.00,0.00,0.00,2139.54,0.00,'2022-09-15 08:22:48','',''),(1139,'1','281','2',1,'Sale Id shift 70',0.00,0.00,0.00,2022.45,0.00,'2022-09-15 08:22:48','',''),(1140,'1','281','2',1,'Sale Id shift 70',0.00,0.00,0.00,1074.43,0.00,'2022-09-15 08:22:48','',''),(1141,'1','281',NULL,2,'Sale Id shift 70',2134903.90,0.00,0.00,0.00,0.00,'2022-09-15 08:22:48','',''),(1142,'1','281',NULL,1,'Sale Id shift 70',3331326.45,0.00,0.00,0.00,0.00,'2022-09-15 08:22:48','',''),(1143,'1','281','1',1,'Sale Id shift 71',0.00,0.00,0.00,1191.53,0.00,'2022-09-15 15:22:45','',''),(1144,'1','281','2',1,'Sale Id shift 71',0.00,0.00,0.00,2055.17,0.00,'2022-09-15 15:22:45','',''),(1145,'1','281','2',1,'Sale Id shift 71',0.00,0.00,0.00,3009.97,0.00,'2022-09-15 15:22:45','',''),(1146,'1','281','2',1,'Sale Id shift 71',0.00,0.00,0.00,2927.24,0.00,'2022-09-15 15:22:45','',''),(1147,'1','281','3',2,'Sale Id shift 71',0.00,0.00,0.00,285.93,0.00,'2022-09-15 15:22:45','',''),(1148,'1','281','1',1,'Sale Id shift 71',0.00,0.00,0.00,1456.39,0.00,'2022-09-15 15:22:45','',''),(1149,'1','281','1',1,'Sale Id shift 71',0.00,0.00,0.00,2256.82,0.00,'2022-09-15 15:22:45','',''),(1150,'1','281','1',1,'Sale Id shift 71',0.00,0.00,0.00,2932.56,0.00,'2022-09-15 15:22:45','',''),(1151,'1','281','1',1,'Sale Id shift 71',0.00,0.00,0.00,1480.37,0.00,'2022-09-15 15:22:45','',''),(1152,'1','281','2',1,'Sale Id shift 71',0.00,0.00,0.00,3929.35,0.00,'2022-09-15 15:22:45','',''),(1153,'1','281',NULL,2,'Sale Id shift 71',225884.70,0.00,0.00,0.00,0.00,'2022-09-15 15:22:45','',''),(1154,'1','281',NULL,1,'Sale Id shift 71',3929289.00,0.00,0.00,0.00,0.00,'2022-09-15 15:22:45','',''),(1155,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,11100000.00,60000.00,0.00,0.00,'2022-09-15 21:24:51','',''),(1156,'1','281','1',1,'Sale Id shift 72',0.00,0.00,0.00,1888.82,0.00,'2022-09-15 21:26:13','',''),(1157,'1','281','2',1,'Sale Id shift 72',0.00,0.00,0.00,1695.62,0.00,'2022-09-15 21:26:13','',''),(1158,'1','281','2',1,'Sale Id shift 72',0.00,0.00,0.00,1443.67,0.00,'2022-09-15 21:26:13','',''),(1159,'1','281','2',1,'Sale Id shift 72',0.00,0.00,0.00,2927.53,0.00,'2022-09-15 21:26:13','',''),(1160,'1','281','3',2,'Sale Id shift 72',0.00,0.00,0.00,247.22,0.00,'2022-09-15 21:26:13','',''),(1161,'1','281','3',2,'Sale Id shift 72',0.00,0.00,0.00,70.04,0.00,'2022-09-15 21:26:13','',''),(1162,'1','281','1',1,'Sale Id shift 72',0.00,0.00,0.00,2103.52,0.00,'2022-09-15 21:26:13','',''),(1163,'1','281','1',1,'Sale Id shift 72',0.00,0.00,0.00,608.79,0.00,'2022-09-15 21:26:13','',''),(1164,'1','281','1',1,'Sale Id shift 72',0.00,0.00,0.00,2519.87,0.00,'2022-09-15 21:26:13','',''),(1165,'1','281','1',1,'Sale Id shift 72',0.00,0.00,0.00,931.72,0.00,'2022-09-15 21:26:13','',''),(1166,'1','281','1',1,'Sale Id shift 72',0.00,0.00,0.00,2382.82,0.00,'2022-09-15 21:26:13','',''),(1167,'1','281','2',1,'Sale Id shift 72',0.00,0.00,0.00,3287.42,0.00,'2022-09-15 21:26:13','',''),(1168,'1','281','2',1,'Sale Id shift 72',0.00,0.00,0.00,2110.95,0.00,'2022-09-15 21:26:13','',''),(1169,'1','281',NULL,2,'Sale Id shift 72',250635.40,0.00,0.00,0.00,0.00,'2022-09-15 21:26:13','',''),(1170,'1','281',NULL,1,'Sale Id shift 72',4051635.05,0.00,0.00,0.00,0.00,'2022-09-15 21:26:13','',''),(1171,'1','281',NULL,1,'Reception corrector for bridging 99',0.00,0.00,0.00,22000.00,0.00,'2022-09-16 16:54:09','',''),(1172,'1','281','2',1,'Received from bridging 99',0.00,0.00,22000.00,0.00,0.00,'2022-09-16 16:54:09','',''),(1173,'1','281',NULL,1,'Reception corrector for bridging 98',0.00,0.00,0.00,23000.00,0.00,'2022-09-16 16:54:54','',''),(1174,'1','281','1',1,'Received from bridging 98',0.00,0.00,23000.00,0.00,0.00,'2022-09-16 16:54:54','',''),(1175,'1','281','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,1352.69,0.00,'2022-09-16 17:21:53','',''),(1176,'1','281','3',0,'Inventory adjustment from tank dipping to 2000',0.00,0.00,2000.00,0.00,0.00,'2022-09-16 17:21:53','',''),(1177,'1','281','1',1,'Sale Id shift 73',0.00,0.00,0.00,2616.86,0.00,'2022-09-16 17:34:49','',''),(1178,'1','281','2',1,'Sale Id shift 73',0.00,0.00,0.00,2832.83,0.00,'2022-09-16 17:34:49','',''),(1179,'1','281','2',1,'Sale Id shift 73',0.00,0.00,0.00,2663.94,0.00,'2022-09-16 17:34:49','',''),(1180,'1','281','2',1,'Sale Id shift 73',0.00,0.00,0.00,2277.86,0.00,'2022-09-16 17:34:49','',''),(1181,'1','281','3',2,'Sale Id shift 73',0.00,0.00,0.00,1630.76,0.00,'2022-09-16 17:34:49','',''),(1182,'1','281','3',2,'Sale Id shift 73',0.00,0.00,0.00,52.54,0.00,'2022-09-16 17:34:49','',''),(1183,'1','281','1',1,'Sale Id shift 73',0.00,0.00,0.00,2533.27,0.00,'2022-09-16 17:34:49','',''),(1184,'1','281','1',1,'Sale Id shift 73',0.00,0.00,0.00,1973.22,0.00,'2022-09-16 17:34:49','',''),(1185,'1','281','1',1,'Sale Id shift 73',0.00,0.00,0.00,2170.20,0.00,'2022-09-16 17:34:49','',''),(1186,'1','281','1',1,'Sale Id shift 73',0.00,0.00,0.00,3427.23,0.00,'2022-09-16 17:34:49','',''),(1187,'1','281','2',1,'Sale Id shift 73',0.00,0.00,0.00,3376.10,0.00,'2022-09-16 17:34:49','',''),(1188,'1','281',NULL,2,'Sale Id shift 73',1329807.00,0.00,0.00,0.00,0.00,'2022-09-16 17:34:49','',''),(1189,'1','281',NULL,1,'Sale Id shift 73',4416229.35,0.00,0.00,0.00,0.00,'2022-09-16 17:34:49','',''),(1190,'1','281',NULL,1,'Reception corrector for bridging 101',0.00,0.00,0.00,7000.00,0.00,'2022-09-17 08:03:46','',''),(1191,'1','281','2',1,'Received from bridging 101',0.00,0.00,7000.00,0.00,0.00,'2022-09-17 08:03:46','',''),(1192,'1','281',NULL,1,'Reception corrector for bridging 100',0.00,0.00,0.00,8000.00,0.00,'2022-09-17 08:05:08','',''),(1193,'1','281','1',1,'Received from bridging 100',0.00,0.00,8000.00,0.00,0.00,'2022-09-17 08:05:08','',''),(1194,'1','281','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,316.70,0.00,'2022-09-17 08:23:35','',''),(1195,'1','281','3',0,'Inventory adjustment from tank dipping to 1000',0.00,0.00,1000.00,0.00,0.00,'2022-09-17 08:23:35','',''),(1196,'1','281','1',1,'Sale Id shift 74',0.00,0.00,0.00,1713.65,0.00,'2022-09-17 08:29:58','',''),(1197,'1','281','2',1,'Sale Id shift 74',0.00,0.00,0.00,3137.05,0.00,'2022-09-17 08:29:58','',''),(1198,'1','281','2',1,'Sale Id shift 74',0.00,0.00,0.00,545.02,0.00,'2022-09-17 08:29:58','',''),(1199,'1','281','2',1,'Sale Id shift 74',0.00,0.00,0.00,1191.17,0.00,'2022-09-17 08:29:58','',''),(1200,'1','281','3',2,'Sale Id shift 74',0.00,0.00,0.00,449.91,0.00,'2022-09-17 08:29:58','',''),(1201,'1','281','1',1,'Sale Id shift 74',0.00,0.00,0.00,4809.98,0.00,'2022-09-17 08:29:58','',''),(1202,'1','281','1',1,'Sale Id shift 74',0.00,0.00,0.00,799.10,0.00,'2022-09-17 08:29:58','',''),(1203,'1','281','1',1,'Sale Id shift 74',0.00,0.00,0.00,633.04,0.00,'2022-09-17 08:29:58','',''),(1204,'1','281','1',1,'Sale Id shift 74',0.00,0.00,0.00,2106.27,0.00,'2022-09-17 08:29:58','',''),(1205,'1','281','1',1,'Sale Id shift 74',0.00,0.00,0.00,3104.39,0.00,'2022-09-17 08:29:58','',''),(1206,'1','281','2',1,'Sale Id shift 74',0.00,0.00,0.00,1371.50,0.00,'2022-09-17 08:29:58','',''),(1207,'1','281','2',1,'Sale Id shift 74',0.00,0.00,0.00,2897.90,0.00,'2022-09-17 08:29:58','',''),(1208,'1','281',NULL,2,'Sale Id shift 74',355428.90,0.00,0.00,0.00,0.00,'2022-09-17 08:29:58','',''),(1209,'1','281',NULL,1,'Sale Id shift 74',4127177.95,0.00,0.00,0.00,0.00,'2022-09-17 08:29:58','',''),(1210,'1','281',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,11850000.00,15000.00,0.00,0.00,'2022-09-17 08:31:24','',''),(1211,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-09-17 08:32:44','',''),(1212,'1','281',NULL,1,'Returned purchase #53 to AA RANO NIGERIA LTD',8325000.00,0.00,0.00,45000.00,0.00,'2022-09-17 08:34:00','',''),(1213,'1','281',NULL,2,'Reception corrector for bridging 102',0.00,0.00,0.00,15000.00,0.00,'2022-09-17 08:52:59','',''),(1214,'1','281','3',2,'Received from bridging 102',0.00,0.00,15000.00,0.00,0.00,'2022-09-17 08:52:59','',''),(1215,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-09-17 09:18:29','',''),(1216,'1','281',NULL,1,'Reception corrector for bridging 104',0.00,0.00,0.00,16000.00,0.00,'2022-09-17 09:23:28','',''),(1217,'1','281','2',1,'Received from bridging 104',0.00,0.00,16000.00,0.00,0.00,'2022-09-17 09:23:28','',''),(1218,'1','281',NULL,1,'Reception corrector for bridging 103',0.00,0.00,0.00,14000.00,0.00,'2022-09-17 09:24:01','',''),(1219,'1','281','1',1,'Received from bridging 103',0.00,0.00,14000.00,0.00,0.00,'2022-09-17 09:24:01','',''),(1220,'1','281','1',1,'Sale Id shift 75',0.00,0.00,0.00,2388.81,0.00,'2022-09-17 14:21:55','',''),(1221,'1','281','2',1,'Sale Id shift 75',0.00,0.00,0.00,3135.46,0.00,'2022-09-17 14:21:55','',''),(1222,'1','281','2',1,'Sale Id shift 75',0.00,0.00,0.00,1868.82,0.00,'2022-09-17 14:21:55','',''),(1223,'1','281','2',1,'Sale Id shift 75',0.00,0.00,0.00,1780.05,0.00,'2022-09-17 14:21:55','',''),(1224,'1','281','3',2,'Sale Id shift 75',0.00,0.00,0.00,201.43,0.00,'2022-09-17 14:21:55','',''),(1225,'1','281','1',1,'Sale Id shift 75',0.00,0.00,0.00,2286.66,0.00,'2022-09-17 14:21:55','',''),(1226,'1','281','1',1,'Sale Id shift 75',0.00,0.00,0.00,2379.23,0.00,'2022-09-17 14:21:55','',''),(1227,'1','281','1',1,'Sale Id shift 75',0.00,0.00,0.00,2369.88,0.00,'2022-09-17 14:21:55','',''),(1228,'1','281','1',1,'Sale Id shift 75',0.00,0.00,0.00,2375.17,0.00,'2022-09-17 14:21:55','',''),(1229,'1','281','2',1,'Sale Id shift 75',0.00,0.00,0.00,2942.51,0.00,'2022-09-17 14:21:55','',''),(1230,'1','281','2',1,'Sale Id shift 75',0.00,0.00,0.00,307.95,0.00,'2022-09-17 14:21:55','',''),(1231,'1','281',NULL,2,'Sale Id shift 75',159129.70,0.00,0.00,0.00,0.00,'2022-09-17 14:21:55','',''),(1232,'1','281',NULL,1,'Sale Id shift 75',4039389.90,0.00,0.00,0.00,0.00,'2022-09-17 14:21:55','',''),(1233,'1','281',NULL,1,'Reception corrector for bridging 106',0.00,0.00,0.00,7000.00,0.00,'2022-09-17 20:44:51','',''),(1234,'1','281','2',1,'Received from bridging 106',0.00,0.00,7000.00,0.00,0.00,'2022-09-17 20:44:51','',''),(1235,'1','281',NULL,1,'Reception corrector for bridging 105',0.00,0.00,0.00,8000.00,0.00,'2022-09-17 20:45:15','',''),(1236,'1','281','1',1,'Received from bridging 105',0.00,0.00,8000.00,0.00,0.00,'2022-09-17 20:45:15','',''),(1237,'1','281','1',1,'Sale Id shift 76',0.00,0.00,0.00,424.21,0.00,'2022-09-18 07:47:25','',''),(1238,'1','281','2',1,'Sale Id shift 76',0.00,0.00,0.00,621.93,0.00,'2022-09-18 07:47:25','',''),(1239,'1','281','2',1,'Sale Id shift 76',0.00,0.00,0.00,2956.44,0.00,'2022-09-18 07:47:25','',''),(1240,'1','281','2',1,'Sale Id shift 76',0.00,0.00,0.00,2821.38,0.00,'2022-09-18 07:47:25','',''),(1241,'1','281','3',2,'Sale Id shift 76',0.00,0.00,0.00,2544.13,0.00,'2022-09-18 07:47:25','',''),(1242,'1','281','3',2,'Sale Id shift 76',0.00,0.00,0.00,83.55,0.00,'2022-09-18 07:47:25','',''),(1243,'1','281','1',1,'Sale Id shift 76',0.00,0.00,0.00,882.67,0.00,'2022-09-18 07:47:25','',''),(1244,'1','281','1',1,'Sale Id shift 76',0.00,0.00,0.00,2322.09,0.00,'2022-09-18 07:47:25','',''),(1245,'1','281','1',1,'Sale Id shift 76',0.00,0.00,0.00,3607.33,0.00,'2022-09-18 07:47:25','',''),(1246,'1','281','1',1,'Sale Id shift 76',0.00,0.00,0.00,772.50,0.00,'2022-09-18 07:47:25','',''),(1247,'1','281','1',1,'Sale Id shift 76',0.00,0.00,0.00,628.23,0.00,'2022-09-18 07:47:25','',''),(1248,'1','281','2',1,'Sale Id shift 76',0.00,0.00,0.00,4306.94,0.00,'2022-09-18 07:47:25','',''),(1249,'1','281','2',1,'Sale Id shift 76',0.00,0.00,0.00,723.06,0.00,'2022-09-18 07:47:25','',''),(1250,'1','281',NULL,2,'Sale Id shift 76',2075867.20,0.00,0.00,0.00,0.00,'2022-09-18 07:47:25','',''),(1251,'1','281',NULL,1,'Sale Id shift 76',3712354.30,0.00,0.00,0.00,0.00,'2022-09-18 07:47:25','',''),(1252,'1','281','1',1,'Sale Id shift 77',0.00,0.00,0.00,1644.89,0.00,'2022-09-18 14:39:26','',''),(1253,'1','281','2',1,'Sale Id shift 77',0.00,0.00,0.00,2367.56,0.00,'2022-09-18 14:39:26','',''),(1254,'1','281','2',1,'Sale Id shift 77',0.00,0.00,0.00,995.76,0.00,'2022-09-18 14:39:26','',''),(1255,'1','281','2',1,'Sale Id shift 77',0.00,0.00,0.00,2161.08,0.00,'2022-09-18 14:39:26','',''),(1256,'1','281','3',2,'Sale Id shift 77',0.00,0.00,0.00,85.03,0.00,'2022-09-18 14:39:26','',''),(1257,'1','281','3',2,'Sale Id shift 77',0.00,0.00,0.00,55.70,0.00,'2022-09-18 14:39:26','',''),(1258,'1','281','1',1,'Sale Id shift 77',0.00,0.00,0.00,2410.11,0.00,'2022-09-18 14:39:26','',''),(1259,'1','281','1',1,'Sale Id shift 77',0.00,0.00,0.00,558.65,0.00,'2022-09-18 14:39:26','',''),(1260,'1','281','1',1,'Sale Id shift 77',0.00,0.00,0.00,2252.08,0.00,'2022-09-18 14:39:26','',''),(1261,'1','281','1',1,'Sale Id shift 77',0.00,0.00,0.00,1104.74,0.00,'2022-09-18 14:39:26','',''),(1262,'1','281','1',1,'Sale Id shift 77',0.00,0.00,0.00,1672.42,0.00,'2022-09-18 14:39:26','',''),(1263,'1','281','2',1,'Sale Id shift 77',0.00,0.00,0.00,2877.18,0.00,'2022-09-18 14:39:26','',''),(1264,'1','281','2',1,'Sale Id shift 77',0.00,0.00,0.00,1191.92,0.00,'2022-09-18 14:39:26','',''),(1265,'1','281',NULL,2,'Sale Id shift 77',111176.70,0.00,0.00,0.00,0.00,'2022-09-18 14:39:26','',''),(1266,'1','281',NULL,1,'Sale Id shift 77',3558732.15,0.00,0.00,0.00,0.00,'2022-09-18 14:39:26','',''),(1267,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-09-18 14:41:45','',''),(1268,'1','281',NULL,1,'Reception corrector for bridging 108',0.00,0.00,0.00,22000.00,0.00,'2022-09-18 14:45:39','',''),(1269,'1','281','2',1,'Received from bridging 108',0.00,0.00,22000.00,0.00,0.00,'2022-09-18 14:45:39','',''),(1270,'1','281',NULL,1,'Reception corrector for bridging 107',0.00,0.00,0.00,23000.00,0.00,'2022-09-18 14:46:09','',''),(1271,'1','281','1',1,'Received from bridging 107',0.00,0.00,23000.00,0.00,0.00,'2022-09-18 14:46:09','',''),(1272,'1','281','1',1,'Sale Id shift 78',0.00,0.00,0.00,749.13,0.00,'2022-09-19 07:47:49','',''),(1273,'1','281','2',1,'Sale Id shift 78',0.00,0.00,0.00,2301.74,0.00,'2022-09-19 07:47:49','',''),(1274,'1','281','2',1,'Sale Id shift 78',0.00,0.00,0.00,2036.90,0.00,'2022-09-19 07:47:49','',''),(1275,'1','281','3',2,'Sale Id shift 78',0.00,0.00,0.00,45.40,0.00,'2022-09-19 07:47:49','',''),(1276,'1','281','1',1,'Sale Id shift 78',0.00,0.00,0.00,2506.55,0.00,'2022-09-19 07:47:49','',''),(1277,'1','281','1',1,'Sale Id shift 78',0.00,0.00,0.00,1244.41,0.00,'2022-09-19 07:47:49','',''),(1278,'1','281','1',1,'Sale Id shift 78',0.00,0.00,0.00,2086.95,0.00,'2022-09-19 07:47:49','',''),(1279,'1','281','1',1,'Sale Id shift 78',0.00,0.00,0.00,2349.62,0.00,'2022-09-19 07:47:49','',''),(1280,'1','281','2',1,'Sale Id shift 78',0.00,0.00,0.00,2790.58,0.00,'2022-09-19 07:47:49','',''),(1281,'1','281',NULL,2,'Sale Id shift 78',35866.00,0.00,0.00,0.00,0.00,'2022-09-19 07:47:49','',''),(1282,'1','281',NULL,1,'Sale Id shift 78',2972187.80,0.00,0.00,0.00,0.00,'2022-09-19 07:47:49','',''),(1283,'1','281','1',1,'Sale Id shift 79',0.00,0.00,0.00,3356.35,0.00,'2022-09-19 14:54:09','',''),(1284,'1','281','2',1,'Sale Id shift 79',0.00,0.00,0.00,3541.32,0.00,'2022-09-19 14:54:09','',''),(1285,'1','281','2',1,'Sale Id shift 79',0.00,0.00,0.00,695.54,0.00,'2022-09-19 14:54:09','',''),(1286,'1','281','3',2,'Sale Id shift 79',0.00,0.00,0.00,1131.42,0.00,'2022-09-19 14:54:09','',''),(1287,'1','281','3',2,'Sale Id shift 79',0.00,0.00,0.00,118.55,0.00,'2022-09-19 14:54:09','',''),(1288,'1','281','1',1,'Sale Id shift 79',0.00,0.00,0.00,3595.37,0.00,'2022-09-19 14:54:09','',''),(1289,'1','281','1',1,'Sale Id shift 79',0.00,0.00,0.00,472.02,0.00,'2022-09-19 14:54:09','',''),(1290,'1','281','1',1,'Sale Id shift 79',0.00,0.00,0.00,2921.98,0.00,'2022-09-19 14:54:09','',''),(1291,'1','281','1',1,'Sale Id shift 79',0.00,0.00,0.00,3196.61,0.00,'2022-09-19 14:54:09','',''),(1292,'1','281','2',1,'Sale Id shift 79',0.00,0.00,0.00,529.22,0.00,'2022-09-19 14:54:09','',''),(1293,'1','281','2',1,'Sale Id shift 79',0.00,0.00,0.00,3190.49,0.00,'2022-09-19 14:54:09','',''),(1294,'1','281',NULL,2,'Sale Id shift 79',987476.30,0.00,0.00,0.00,0.00,'2022-09-19 14:54:09','',''),(1295,'1','281',NULL,1,'Sale Id shift 79',3977296.50,0.00,0.00,0.00,0.00,'2022-09-19 14:54:09','',''),(1296,'1','281','1',1,'Sale Id shift 80',0.00,0.00,0.00,1975.48,0.00,'2022-09-20 07:40:32','',''),(1297,'1','281','2',1,'Sale Id shift 80',0.00,0.00,0.00,2673.95,0.00,'2022-09-20 07:40:32','',''),(1298,'1','281','3',2,'Sale Id shift 80',0.00,0.00,0.00,1607.21,0.00,'2022-09-20 07:40:32','',''),(1299,'1','281','3',2,'Sale Id shift 80',0.00,0.00,0.00,140.87,0.00,'2022-09-20 07:40:32','',''),(1300,'1','281','1',1,'Sale Id shift 80',0.00,0.00,0.00,2220.24,0.00,'2022-09-20 07:40:32','',''),(1301,'1','281','1',1,'Sale Id shift 80',0.00,0.00,0.00,1953.94,0.00,'2022-09-20 07:40:32','',''),(1302,'1','281','1',1,'Sale Id shift 80',0.00,0.00,0.00,2175.34,0.00,'2022-09-20 07:40:32','',''),(1303,'1','281',NULL,2,'Sale Id shift 80',1380983.20,0.00,0.00,0.00,0.00,'2022-09-20 07:40:32','',''),(1304,'1','281',NULL,1,'Sale Id shift 80',2034805.75,0.00,0.00,0.00,0.00,'2022-09-20 07:40:32','',''),(1305,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,11100000.00,60000.00,0.00,0.00,'2022-09-20 14:13:08','',''),(1306,'1','281',NULL,1,'Reception corrector for bridging 110',0.00,0.00,0.00,15000.00,0.00,'2022-09-20 14:30:07','',''),(1307,'1','281','2',1,'Received from bridging 110',0.00,0.00,15000.00,0.00,0.00,'2022-09-20 14:30:07','',''),(1308,'1','281',NULL,1,'Reception corrector for bridging 109',0.00,0.00,0.00,30000.00,0.00,'2022-09-20 14:30:42','',''),(1309,'1','281','1',1,'Received from bridging 109',0.00,0.00,30000.00,0.00,0.00,'2022-09-20 14:30:42','',''),(1310,'1','281','1',1,'Sale Id shift 81',0.00,0.00,0.00,2139.65,0.00,'2022-09-20 15:11:51','',''),(1311,'1','281','2',1,'Sale Id shift 81',0.00,0.00,0.00,1927.90,0.00,'2022-09-20 15:11:51','',''),(1312,'1','281','2',1,'Sale Id shift 81',0.00,0.00,0.00,2881.56,0.00,'2022-09-20 15:11:51','',''),(1313,'1','281','3',2,'Sale Id shift 81',0.00,0.00,0.00,344.97,0.00,'2022-09-20 15:11:51','',''),(1314,'1','281','1',1,'Sale Id shift 81',0.00,0.00,0.00,2342.06,0.00,'2022-09-20 15:11:51','',''),(1315,'1','281','1',1,'Sale Id shift 81',0.00,0.00,0.00,2522.46,0.00,'2022-09-20 15:11:51','',''),(1316,'1','281','1',1,'Sale Id shift 81',0.00,0.00,0.00,2064.50,0.00,'2022-09-20 15:11:51','',''),(1317,'1','281','1',1,'Sale Id shift 81',0.00,0.00,0.00,1897.00,0.00,'2022-09-20 15:11:51','',''),(1318,'1','281','2',1,'Sale Id shift 81',0.00,0.00,0.00,3693.82,0.00,'2022-09-20 15:11:51','',''),(1319,'1','281','2',1,'Sale Id shift 81',0.00,0.00,0.00,2574.62,0.00,'2022-09-20 15:11:51','',''),(1320,'1','281',NULL,2,'Sale Id shift 81',272526.30,0.00,0.00,0.00,0.00,'2022-09-20 15:11:51','',''),(1321,'1','281',NULL,1,'Sale Id shift 81',4078060.45,0.00,0.00,0.00,0.00,'2022-09-20 15:11:51','',''),(1322,'1','281',NULL,1,'Reception corrector for bridging 112',0.00,0.00,0.00,7000.00,0.00,'2022-09-20 17:31:42','',''),(1323,'1','281','2',1,'Received from bridging 112',0.00,0.00,7000.00,0.00,0.00,'2022-09-20 17:31:42','',''),(1324,'1','281',NULL,1,'Reception corrector for bridging 111',0.00,0.00,0.00,8000.00,0.00,'2022-09-20 17:32:06','',''),(1325,'1','281','1',1,'Received from bridging 111',0.00,0.00,8000.00,0.00,0.00,'2022-09-20 17:32:06','',''),(1326,'1','281','1',1,'Sale Id shift 82',0.00,0.00,0.00,1921.90,0.00,'2022-09-21 07:52:44','',''),(1327,'1','281','2',1,'Sale Id shift 82',0.00,0.00,0.00,2391.55,0.00,'2022-09-21 07:52:44','',''),(1328,'1','281','2',1,'Sale Id shift 82',0.00,0.00,0.00,510.92,0.00,'2022-09-21 07:52:44','',''),(1329,'1','281','2',1,'Sale Id shift 82',0.00,0.00,0.00,1752.06,0.00,'2022-09-21 07:52:44','',''),(1330,'1','281','3',2,'Sale Id shift 82',0.00,0.00,0.00,521.34,0.00,'2022-09-21 07:52:44','',''),(1331,'1','281','3',2,'Sale Id shift 82',0.00,0.00,0.00,6.34,0.00,'2022-09-21 07:52:44','',''),(1332,'1','281','1',1,'Sale Id shift 82',0.00,0.00,0.00,2062.08,0.00,'2022-09-21 07:52:44','',''),(1333,'1','281','1',1,'Sale Id shift 82',0.00,0.00,0.00,303.10,0.00,'2022-09-21 07:52:44','',''),(1334,'1','281','1',1,'Sale Id shift 82',0.00,0.00,0.00,1745.34,0.00,'2022-09-21 07:52:44','',''),(1335,'1','281','1',1,'Sale Id shift 82',0.00,0.00,0.00,1093.51,0.00,'2022-09-21 07:52:44','',''),(1336,'1','281','1',1,'Sale Id shift 82',0.00,0.00,0.00,2392.70,0.00,'2022-09-21 07:52:44','',''),(1337,'1','281','2',1,'Sale Id shift 82',0.00,0.00,0.00,3907.80,0.00,'2022-09-21 07:52:44','',''),(1338,'1','281','2',1,'Sale Id shift 82',0.00,0.00,0.00,1284.94,0.00,'2022-09-21 07:52:44','',''),(1339,'1','281',NULL,2,'Sale Id shift 82',416867.20,0.00,0.00,0.00,0.00,'2022-09-21 07:52:44','',''),(1340,'1','281',NULL,1,'Sale Id shift 82',3582691.50,0.00,0.00,0.00,0.00,'2022-09-21 07:52:44','',''),(1341,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,6105000.00,33000.00,0.00,0.00,'2022-09-21 10:46:31','',''),(1342,'1','281',NULL,1,'Reception corrector for bridging 113',0.00,0.00,0.00,16500.00,0.00,'2022-09-21 12:03:31','',''),(1343,'1','281','1',1,'Received from bridging 113',0.00,0.00,16500.00,0.00,0.00,'2022-09-21 12:03:31','',''),(1344,'1','281',NULL,1,'Reception corrector for bridging 114',0.00,0.00,0.00,16500.00,0.00,'2022-09-21 12:03:56','',''),(1345,'1','281','2',1,'Received from bridging 114',0.00,0.00,16500.00,0.00,0.00,'2022-09-21 12:03:56','',''),(1346,'1','281','1',1,'Sale Id shift 83',0.00,0.00,0.00,1935.63,0.00,'2022-09-21 14:51:40','',''),(1347,'1','281','2',1,'Sale Id shift 83',0.00,0.00,0.00,2645.53,0.00,'2022-09-21 14:51:40','',''),(1348,'1','281','2',1,'Sale Id shift 83',0.00,0.00,0.00,2437.56,0.00,'2022-09-21 14:51:40','',''),(1349,'1','281','2',1,'Sale Id shift 83',0.00,0.00,0.00,2161.25,0.00,'2022-09-21 14:51:40','',''),(1350,'1','281','3',2,'Sale Id shift 83',0.00,0.00,0.00,30.05,0.00,'2022-09-21 14:51:40','',''),(1351,'1','281','3',2,'Sale Id shift 83',0.00,0.00,0.00,175.34,0.00,'2022-09-21 14:51:40','',''),(1352,'1','281','1',1,'Sale Id shift 83',0.00,0.00,0.00,2478.08,0.00,'2022-09-21 14:51:40','',''),(1353,'1','281','1',1,'Sale Id shift 83',0.00,0.00,0.00,1749.99,0.00,'2022-09-21 14:51:40','',''),(1354,'1','281','1',1,'Sale Id shift 83',0.00,0.00,0.00,2096.59,0.00,'2022-09-21 14:51:40','',''),(1355,'1','281','1',1,'Sale Id shift 83',0.00,0.00,0.00,2588.67,0.00,'2022-09-21 14:51:40','',''),(1356,'1','281','2',1,'Sale Id shift 83',0.00,0.00,0.00,2915.63,0.00,'2022-09-21 14:51:40','',''),(1357,'1','281',NULL,2,'Sale Id shift 83',162258.10,0.00,0.00,0.00,0.00,'2022-09-21 14:51:40','',''),(1358,'1','281',NULL,1,'Sale Id shift 83',3886652.05,0.00,0.00,0.00,0.00,'2022-09-21 14:51:40','',''),(1359,'1','281','1',1,'Sale Id shift 84',0.00,0.00,0.00,529.90,0.00,'2022-09-22 07:55:08','',''),(1360,'1','281','2',1,'Sale Id shift 84',0.00,0.00,0.00,1674.73,0.00,'2022-09-22 07:55:08','',''),(1361,'1','281','2',1,'Sale Id shift 84',0.00,0.00,0.00,616.06,0.00,'2022-09-22 07:55:08','',''),(1362,'1','281','2',1,'Sale Id shift 84',0.00,0.00,0.00,2507.25,0.00,'2022-09-22 07:55:08','',''),(1363,'1','281','3',2,'Sale Id shift 84',0.00,0.00,0.00,1629.67,0.00,'2022-09-22 07:55:08','',''),(1364,'1','281','1',1,'Sale Id shift 84',0.00,0.00,0.00,3446.22,0.00,'2022-09-22 07:55:08','',''),(1365,'1','281','1',1,'Sale Id shift 84',0.00,0.00,0.00,389.76,0.00,'2022-09-22 07:55:08','',''),(1366,'1','281','1',1,'Sale Id shift 84',0.00,0.00,0.00,2390.16,0.00,'2022-09-22 07:55:08','',''),(1367,'1','281','1',1,'Sale Id shift 84',0.00,0.00,0.00,612.39,0.00,'2022-09-22 07:55:08','',''),(1368,'1','281','1',1,'Sale Id shift 84',0.00,0.00,0.00,2278.49,0.00,'2022-09-22 07:55:08','',''),(1369,'1','281','2',1,'Sale Id shift 84',0.00,0.00,0.00,2661.04,0.00,'2022-09-22 07:55:08','',''),(1370,'1','281','2',1,'Sale Id shift 84',0.00,0.00,0.00,1560.64,0.00,'2022-09-22 07:55:08','',''),(1371,'1','281',NULL,2,'Sale Id shift 84',1287439.30,0.00,0.00,0.00,0.00,'2022-09-22 07:55:08','',''),(1372,'1','281',NULL,1,'Sale Id shift 84',3453328.40,0.00,0.00,0.00,0.00,'2022-09-22 07:55:08','',''),(1373,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3145000.00,17000.00,0.00,0.00,'2022-09-22 07:55:32','',''),(1374,'1','281',NULL,1,'Reception corrector for bridging 115',0.00,0.00,0.00,10000.00,0.00,'2022-09-22 10:53:08','',''),(1375,'1','281','1',1,'Received from bridging 115',0.00,0.00,10000.00,0.00,0.00,'2022-09-22 10:53:08','',''),(1376,'1','281',NULL,1,'Reception corrector for bridging 116',0.00,0.00,0.00,7000.00,0.00,'2022-09-22 10:53:31','',''),(1377,'1','281','2',1,'Received from bridging 116',0.00,0.00,7000.00,0.00,0.00,'2022-09-22 10:53:31','',''),(1378,'1','281','1',1,'Sale Id shift 85',0.00,0.00,0.00,825.41,0.00,'2022-09-22 14:52:21','',''),(1379,'1','281','2',1,'Sale Id shift 85',0.00,0.00,0.00,2723.36,0.00,'2022-09-22 14:52:21','',''),(1380,'1','281','2',1,'Sale Id shift 85',0.00,0.00,0.00,2275.16,0.00,'2022-09-22 14:52:21','',''),(1381,'1','281','2',1,'Sale Id shift 85',0.00,0.00,0.00,1555.21,0.00,'2022-09-22 14:52:21','',''),(1382,'1','281','3',2,'Sale Id shift 85',0.00,0.00,0.00,566.17,0.00,'2022-09-22 14:52:21','',''),(1383,'1','281','1',1,'Sale Id shift 85',0.00,0.00,0.00,3157.23,0.00,'2022-09-22 14:52:21','',''),(1384,'1','281','1',1,'Sale Id shift 85',0.00,0.00,0.00,1392.88,0.00,'2022-09-22 14:52:21','',''),(1385,'1','281','1',1,'Sale Id shift 85',0.00,0.00,0.00,1761.47,0.00,'2022-09-22 14:52:21','',''),(1386,'1','281','1',1,'Sale Id shift 85',0.00,0.00,0.00,827.83,0.00,'2022-09-22 14:52:21','',''),(1387,'1','281','1',1,'Sale Id shift 85',0.00,0.00,0.00,2382.79,0.00,'2022-09-22 14:52:21','',''),(1388,'1','281','2',1,'Sale Id shift 85',0.00,0.00,0.00,2625.34,0.00,'2022-09-22 14:52:21','',''),(1389,'1','281','2',1,'Sale Id shift 85',0.00,0.00,0.00,1006.08,0.00,'2022-09-22 14:52:21','',''),(1390,'1','281',NULL,2,'Sale Id shift 85',447274.30,0.00,0.00,0.00,0.00,'2022-09-22 14:52:21','',''),(1391,'1','281',NULL,1,'Sale Id shift 85',3798560.60,0.00,0.00,0.00,0.00,'2022-09-22 14:52:21','',''),(1392,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9250000.00,50000.00,0.00,0.00,'2022-09-22 19:39:52','',''),(1393,'1','281',NULL,1,'Reception corrector for bridging 117',0.00,0.00,0.00,25000.00,0.00,'2022-09-22 19:54:54','',''),(1394,'1','281','1',1,'Received from bridging 117',0.00,0.00,25000.00,0.00,0.00,'2022-09-22 19:54:54','',''),(1395,'1','281',NULL,1,'Reception corrector for bridging 118',0.00,0.00,0.00,25000.00,0.00,'2022-09-22 19:55:12','',''),(1396,'1','281','2',1,'Received from bridging 118',0.00,0.00,25000.00,0.00,0.00,'2022-09-22 19:55:12','',''),(1397,'1','281','2',1,'Sale Id shift 86',0.00,0.00,0.00,1894.52,0.00,'2022-09-23 07:56:07','',''),(1398,'1','281','2',1,'Sale Id shift 86',0.00,0.00,0.00,2091.45,0.00,'2022-09-23 07:56:07','',''),(1399,'1','281','2',1,'Sale Id shift 86',0.00,0.00,0.00,2947.32,0.00,'2022-09-23 07:56:07','',''),(1400,'1','281','3',2,'Sale Id shift 86',0.00,0.00,0.00,1468.91,0.00,'2022-09-23 07:56:07','',''),(1401,'1','281','3',2,'Sale Id shift 86',0.00,0.00,0.00,70.02,0.00,'2022-09-23 07:56:07','',''),(1402,'1','281','1',1,'Sale Id shift 86',0.00,0.00,0.00,2049.85,0.00,'2022-09-23 07:56:07','',''),(1403,'1','281','1',1,'Sale Id shift 86',0.00,0.00,0.00,858.33,0.00,'2022-09-23 07:56:07','',''),(1404,'1','281','1',1,'Sale Id shift 86',0.00,0.00,0.00,3101.25,0.00,'2022-09-23 07:56:07','',''),(1405,'1','281','1',1,'Sale Id shift 86',0.00,0.00,0.00,2148.57,0.00,'2022-09-23 07:56:07','',''),(1406,'1','281','2',1,'Sale Id shift 86',0.00,0.00,0.00,3382.53,0.00,'2022-09-23 07:56:07','',''),(1407,'1','281',NULL,2,'Sale Id shift 86',1215754.70,0.00,0.00,0.00,0.00,'2022-09-23 07:56:07','',''),(1408,'1','281',NULL,1,'Sale Id shift 86',3417656.70,0.00,0.00,0.00,0.00,'2022-09-23 07:56:07','',''),(1409,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,2775000.00,15000.00,0.00,0.00,'2022-09-23 07:56:39','',''),(1410,'1','281',NULL,1,'Reception corrector for bridging 119',0.00,0.00,0.00,10000.00,0.00,'2022-09-23 11:21:42','',''),(1411,'1','281','1',1,'Received from bridging 119',0.00,0.00,10000.00,0.00,0.00,'2022-09-23 11:21:42','',''),(1412,'1','281',NULL,1,'Reception corrector for bridging 120',0.00,0.00,0.00,5000.00,0.00,'2022-09-23 11:22:35','',''),(1413,'1','281','2',1,'Received from bridging 120',0.00,0.00,5000.00,0.00,0.00,'2022-09-23 11:22:35','',''),(1414,'1','281','1',1,'Sale Id shift 87',0.00,0.00,0.00,2227.87,0.00,'2022-09-23 16:15:56','',''),(1415,'1','281','2',1,'Sale Id shift 87',0.00,0.00,0.00,1803.56,0.00,'2022-09-23 16:15:57','',''),(1416,'1','281','2',1,'Sale Id shift 87',0.00,0.00,0.00,1846.47,0.00,'2022-09-23 16:15:57','',''),(1417,'1','281','2',1,'Sale Id shift 87',0.00,0.00,0.00,2234.42,0.00,'2022-09-23 16:15:57','',''),(1418,'1','281','3',2,'Sale Id shift 87',0.00,0.00,0.00,3.80,0.00,'2022-09-23 16:15:57','',''),(1419,'1','281','3',2,'Sale Id shift 87',0.00,0.00,0.00,318.60,0.00,'2022-09-23 16:15:57','',''),(1420,'1','281','1',1,'Sale Id shift 87',0.00,0.00,0.00,2044.01,0.00,'2022-09-23 16:15:57','',''),(1421,'1','281','1',1,'Sale Id shift 87',0.00,0.00,0.00,1704.42,0.00,'2022-09-23 16:15:57','',''),(1422,'1','281','1',1,'Sale Id shift 87',0.00,0.00,0.00,1642.41,0.00,'2022-09-23 16:15:57','',''),(1423,'1','281','1',1,'Sale Id shift 87',0.00,0.00,0.00,2086.75,0.00,'2022-09-23 16:15:57','',''),(1424,'1','281','1',1,'Sale Id shift 87',0.00,0.00,0.00,1743.03,0.00,'2022-09-23 16:15:57','',''),(1425,'1','281','2',1,'Sale Id shift 87',0.00,0.00,0.00,3227.58,0.00,'2022-09-23 16:15:57','',''),(1426,'1','281','2',1,'Sale Id shift 87',0.00,0.00,0.00,2060.84,0.00,'2022-09-23 16:15:57','',''),(1427,'1','281',NULL,2,'Sale Id shift 87',254696.00,0.00,0.00,0.00,0.00,'2022-09-23 16:15:57','',''),(1428,'1','281',NULL,1,'Sale Id shift 87',4184951.60,0.00,0.00,0.00,0.00,'2022-09-23 16:15:57','',''),(1429,'1','281','1',1,'Sale Id shift 88',0.00,0.00,0.00,758.71,0.00,'2022-09-24 08:02:10','',''),(1430,'1','281','2',1,'Sale Id shift 88',0.00,0.00,0.00,925.62,0.00,'2022-09-24 08:02:10','',''),(1431,'1','281','2',1,'Sale Id shift 88',0.00,0.00,0.00,1775.61,0.00,'2022-09-24 08:02:10','',''),(1432,'1','281','2',1,'Sale Id shift 88',0.00,0.00,0.00,2697.56,0.00,'2022-09-24 08:02:10','',''),(1433,'1','281','3',2,'Sale Id shift 88',0.00,0.00,0.00,1187.20,0.00,'2022-09-24 08:02:10','',''),(1434,'1','281','3',2,'Sale Id shift 88',0.00,0.00,0.00,1020.00,0.00,'2022-09-24 08:02:10','',''),(1435,'1','281','1',1,'Sale Id shift 88',0.00,0.00,0.00,1605.91,0.00,'2022-09-24 08:02:10','',''),(1436,'1','281','1',1,'Sale Id shift 88',0.00,0.00,0.00,1452.39,0.00,'2022-09-24 08:02:10','',''),(1437,'1','281','1',1,'Sale Id shift 88',0.00,0.00,0.00,2680.19,0.00,'2022-09-24 08:02:10','',''),(1438,'1','281','1',1,'Sale Id shift 88',0.00,0.00,0.00,956.54,0.00,'2022-09-24 08:02:10','',''),(1439,'1','281','1',1,'Sale Id shift 88',0.00,0.00,0.00,1065.32,0.00,'2022-09-24 08:02:10','',''),(1440,'1','281','2',1,'Sale Id shift 88',0.00,0.00,0.00,3569.08,0.00,'2022-09-24 08:02:10','',''),(1441,'1','281','2',1,'Sale Id shift 88',0.00,0.00,0.00,1423.58,0.00,'2022-09-24 08:02:10','',''),(1442,'1','281',NULL,2,'Sale Id shift 88',1743688.00,0.00,0.00,0.00,0.00,'2022-09-24 08:02:10','',''),(1443,'1','281',NULL,1,'Sale Id shift 88',3498444.35,0.00,0.00,0.00,0.00,'2022-09-24 08:02:10','',''),(1444,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9250000.00,50000.00,0.00,0.00,'2022-09-24 12:40:27','',''),(1445,'1','281',NULL,1,'Reception corrector for bridging 121',0.00,0.00,0.00,23000.00,0.00,'2022-09-24 13:26:55','',''),(1446,'1','281','1',1,'Received from bridging 121',0.00,0.00,23000.00,0.00,0.00,'2022-09-24 13:26:55','',''),(1447,'1','281',NULL,1,'Reception corrector for bridging 122',0.00,0.00,0.00,27000.00,0.00,'2022-09-24 13:27:16','',''),(1448,'1','281','2',1,'Received from bridging 122',0.00,0.00,27000.00,0.00,0.00,'2022-09-24 13:27:16','',''),(1449,'1','281','1',1,'Sale Id shift 89',0.00,0.00,0.00,1514.01,0.00,'2022-09-24 14:37:34','',''),(1450,'1','281','2',1,'Sale Id shift 89',0.00,0.00,0.00,1432.52,0.00,'2022-09-24 14:37:34','',''),(1451,'1','281','2',1,'Sale Id shift 89',0.00,0.00,0.00,2480.57,0.00,'2022-09-24 14:37:34','',''),(1452,'1','281','2',1,'Sale Id shift 89',0.00,0.00,0.00,2027.90,0.00,'2022-09-24 14:37:34','',''),(1453,'1','281','3',2,'Sale Id shift 89',0.00,0.00,0.00,1257.64,0.00,'2022-09-24 14:37:34','',''),(1454,'1','281','3',2,'Sale Id shift 89',0.00,0.00,0.00,67.42,0.00,'2022-09-24 14:37:34','',''),(1455,'1','281','1',1,'Sale Id shift 89',0.00,0.00,0.00,1339.49,0.00,'2022-09-24 14:37:34','',''),(1456,'1','281','1',1,'Sale Id shift 89',0.00,0.00,0.00,2412.26,0.00,'2022-09-24 14:37:34','',''),(1457,'1','281','1',1,'Sale Id shift 89',0.00,0.00,0.00,2561.19,0.00,'2022-09-24 14:37:34','',''),(1458,'1','281','1',1,'Sale Id shift 89',0.00,0.00,0.00,1087.79,0.00,'2022-09-24 14:37:34','',''),(1459,'1','281','1',1,'Sale Id shift 89',0.00,0.00,0.00,1766.91,0.00,'2022-09-24 14:37:34','',''),(1460,'1','281','2',1,'Sale Id shift 89',0.00,0.00,0.00,3114.06,0.00,'2022-09-24 14:37:34','',''),(1461,'1','281','2',1,'Sale Id shift 89',0.00,0.00,0.00,1799.22,0.00,'2022-09-24 14:37:34','',''),(1462,'1','281',NULL,2,'Sale Id shift 89',1046797.40,0.00,0.00,0.00,0.00,'2022-09-24 14:37:34','',''),(1463,'1','281',NULL,1,'Sale Id shift 89',3984145.20,0.00,0.00,0.00,0.00,'2022-09-24 14:37:34','',''),(1464,'1','281','2',1,'Sale Id shift 90',0.00,0.00,0.00,1090.70,0.00,'2022-09-25 08:26:36','',''),(1465,'1','281','2',1,'Sale Id shift 90',0.00,0.00,0.00,1450.62,0.00,'2022-09-25 08:26:36','',''),(1466,'1','281','2',1,'Sale Id shift 90',0.00,0.00,0.00,2896.56,0.00,'2022-09-25 08:26:36','',''),(1467,'1','281','3',2,'Sale Id shift 90',0.00,0.00,0.00,285.25,0.00,'2022-09-25 08:26:36','',''),(1468,'1','281','3',2,'Sale Id shift 90',0.00,0.00,0.00,5.06,0.00,'2022-09-25 08:26:36','',''),(1469,'1','281','1',1,'Sale Id shift 90',0.00,0.00,0.00,1707.40,0.00,'2022-09-25 08:26:36','',''),(1470,'1','281','1',1,'Sale Id shift 90',0.00,0.00,0.00,2189.02,0.00,'2022-09-25 08:26:36','',''),(1471,'1','281','1',1,'Sale Id shift 90',0.00,0.00,0.00,3153.46,0.00,'2022-09-25 08:26:36','',''),(1472,'1','281','1',1,'Sale Id shift 90',0.00,0.00,0.00,1227.98,0.00,'2022-09-25 08:26:36','',''),(1473,'1','281','2',1,'Sale Id shift 90',0.00,0.00,0.00,4480.06,0.00,'2022-09-25 08:26:36','',''),(1474,'1','281',NULL,2,'Sale Id shift 90',229344.90,0.00,0.00,0.00,0.00,'2022-09-25 08:26:36','',''),(1475,'1','281',NULL,1,'Sale Id shift 90',3366223.00,0.00,0.00,0.00,0.00,'2022-09-25 08:26:36','',''),(1476,'1','281','1',1,'Sale Id shift 91',0.00,0.00,0.00,2861.00,0.00,'2022-09-25 15:11:42','',''),(1477,'1','281','2',1,'Sale Id shift 91',0.00,0.00,0.00,2944.45,0.00,'2022-09-25 15:11:42','',''),(1478,'1','281','3',2,'Sale Id shift 91',0.00,0.00,0.00,50.25,0.00,'2022-09-25 15:11:42','',''),(1479,'1','281','1',1,'Sale Id shift 91',0.00,0.00,0.00,2525.54,0.00,'2022-09-25 15:11:42','',''),(1480,'1','281','1',1,'Sale Id shift 91',0.00,0.00,0.00,231.41,0.00,'2022-09-25 15:11:42','',''),(1481,'1','281','1',1,'Sale Id shift 91',0.00,0.00,0.00,2781.86,0.00,'2022-09-25 15:11:42','',''),(1482,'1','281','1',1,'Sale Id shift 91',0.00,0.00,0.00,2959.78,0.00,'2022-09-25 15:11:42','',''),(1483,'1','281','2',1,'Sale Id shift 91',0.00,0.00,0.00,412.62,0.00,'2022-09-25 15:11:42','',''),(1484,'1','281','2',1,'Sale Id shift 91',0.00,0.00,0.00,2762.64,0.00,'2022-09-25 15:11:42','',''),(1485,'1','281',NULL,2,'Sale Id shift 91',39697.50,0.00,0.00,0.00,0.00,'2022-09-25 15:11:42','',''),(1486,'1','281',NULL,1,'Sale Id shift 91',3233670.50,0.00,0.00,0.00,0.00,'2022-09-25 15:11:42','',''),(1487,'1','281','2',1,'Sale Id shift 92',0.00,0.00,0.00,1474.25,0.00,'2022-09-26 07:52:12','',''),(1488,'1','281','2',1,'Sale Id shift 92',0.00,0.00,0.00,2964.50,0.00,'2022-09-26 07:52:12','',''),(1489,'1','281','2',1,'Sale Id shift 92',0.00,0.00,0.00,2264.33,0.00,'2022-09-26 07:52:12','',''),(1490,'1','281','1',1,'Sale Id shift 92',0.00,0.00,0.00,1919.72,0.00,'2022-09-26 07:52:12','',''),(1491,'1','281','1',1,'Sale Id shift 92',0.00,0.00,0.00,2524.74,0.00,'2022-09-26 07:52:12','',''),(1492,'1','281','1',1,'Sale Id shift 92',0.00,0.00,0.00,3253.91,0.00,'2022-09-26 07:52:12','',''),(1493,'1','281','1',1,'Sale Id shift 92',0.00,0.00,0.00,1341.39,0.00,'2022-09-26 07:52:12','',''),(1494,'1','281','2',1,'Sale Id shift 92',0.00,0.00,0.00,2982.87,0.00,'2022-09-26 07:52:12','',''),(1495,'1','281',NULL,1,'Sale Id shift 92',3464256.35,0.00,0.00,0.00,0.00,'2022-09-26 07:52:12','',''),(1496,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9250000.00,50000.00,0.00,0.00,'2022-09-26 07:56:26','',''),(1497,'1','281',NULL,1,'Reception corrector for bridging 123',0.00,0.00,0.00,23000.00,0.00,'2022-09-26 10:01:13','',''),(1498,'1','281','1',1,'Received from bridging 123',0.00,0.00,23000.00,0.00,0.00,'2022-09-26 10:01:13','',''),(1499,'1','281',NULL,1,'Reception corrector for bridging 124',0.00,0.00,0.00,27000.00,0.00,'2022-09-26 10:01:35','',''),(1500,'1','281','2',1,'Received from bridging 124',0.00,0.00,27000.00,0.00,0.00,'2022-09-26 10:01:35','',''),(1501,'1','281','1',1,'Sale Id shift 93',0.00,0.00,0.00,2671.58,0.00,'2022-09-26 13:48:11','',''),(1502,'1','281','2',1,'Sale Id shift 93',0.00,0.00,0.00,2092.45,0.00,'2022-09-26 13:48:11','',''),(1503,'1','281','2',1,'Sale Id shift 93',0.00,0.00,0.00,2894.39,0.00,'2022-09-26 13:48:11','',''),(1504,'1','281','2',1,'Sale Id shift 93',0.00,0.00,0.00,1563.77,0.00,'2022-09-26 13:48:11','',''),(1505,'1','281','3',2,'Sale Id shift 93',0.00,0.00,0.00,118.85,0.00,'2022-09-26 13:48:11','',''),(1506,'1','281','1',1,'Sale Id shift 93',0.00,0.00,0.00,2309.59,0.00,'2022-09-26 13:48:11','',''),(1507,'1','281','1',1,'Sale Id shift 93',0.00,0.00,0.00,1158.74,0.00,'2022-09-26 13:48:11','',''),(1508,'1','281','1',1,'Sale Id shift 93',0.00,0.00,0.00,2276.83,0.00,'2022-09-26 13:48:11','',''),(1509,'1','281','1',1,'Sale Id shift 93',0.00,0.00,0.00,3234.60,0.00,'2022-09-26 13:48:11','',''),(1510,'1','281','2',1,'Sale Id shift 93',0.00,0.00,0.00,3428.12,0.00,'2022-09-26 13:48:11','',''),(1511,'1','281','2',1,'Sale Id shift 93',0.00,0.00,0.00,2044.60,0.00,'2022-09-26 13:48:11','',''),(1512,'1','281',NULL,2,'Sale Id shift 93',93891.50,0.00,0.00,0.00,0.00,'2022-09-26 13:48:11','',''),(1513,'1','281',NULL,1,'Sale Id shift 93',4379813.95,0.00,0.00,0.00,0.00,'2022-09-26 13:48:11','',''),(1514,'1','281',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,10800000.00,13500.00,0.00,0.00,'2022-09-26 19:38:15','',''),(1515,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,11100000.00,60000.00,0.00,0.00,'2022-09-26 19:38:32','',''),(1516,'1','281',NULL,2,'Reception corrector for bridging 125',0.00,0.00,0.00,13500.00,0.00,'2022-09-26 20:51:14','',''),(1517,'1','281','3',2,'Received from bridging 125',0.00,0.00,13500.00,0.00,0.00,'2022-09-26 20:51:14','',''),(1518,'1','281','2',1,'Sale Id shift 94',0.00,0.00,0.00,1136.14,0.00,'2022-09-27 07:31:01','',''),(1519,'1','281','2',1,'Sale Id shift 94',0.00,0.00,0.00,1366.07,0.00,'2022-09-27 07:31:01','',''),(1520,'1','281','2',1,'Sale Id shift 94',0.00,0.00,0.00,1313.19,0.00,'2022-09-27 07:31:01','',''),(1521,'1','281','3',2,'Sale Id shift 94',0.00,0.00,0.00,1877.11,0.00,'2022-09-27 07:31:01','',''),(1522,'1','281','3',2,'Sale Id shift 94',0.00,0.00,0.00,74.31,0.00,'2022-09-27 07:31:01','',''),(1523,'1','281','1',1,'Sale Id shift 94',0.00,0.00,0.00,1314.50,0.00,'2022-09-27 07:31:01','',''),(1524,'1','281','1',1,'Sale Id shift 94',0.00,0.00,0.00,1151.05,0.00,'2022-09-27 07:31:01','',''),(1525,'1','281','1',1,'Sale Id shift 94',0.00,0.00,0.00,1217.93,0.00,'2022-09-27 07:31:01','',''),(1526,'1','281','1',1,'Sale Id shift 94',0.00,0.00,0.00,2083.18,0.00,'2022-09-27 07:31:01','',''),(1527,'1','281','1',1,'Sale Id shift 94',0.00,0.00,0.00,2012.84,0.00,'2022-09-27 07:31:01','',''),(1528,'1','281','2',1,'Sale Id shift 94',0.00,0.00,0.00,1938.33,0.00,'2022-09-27 07:31:01','',''),(1529,'1','281',NULL,2,'Sale Id shift 94',1561136.00,0.00,0.00,0.00,0.00,'2022-09-27 07:31:01','',''),(1530,'1','281',NULL,1,'Sale Id shift 94',2503647.55,0.00,0.00,0.00,0.00,'2022-09-27 07:31:01','',''),(1531,'1','281',NULL,1,'Reception corrector for bridging 126',0.00,0.00,0.00,37000.00,0.00,'2022-09-27 09:11:02','',''),(1532,'1','281','1',1,'Received from bridging 126',0.00,0.00,37000.00,0.00,0.00,'2022-09-27 09:11:02','',''),(1533,'1','281',NULL,1,'Reception corrector for bridging 127',0.00,0.00,0.00,23000.00,0.00,'2022-09-27 09:11:25','',''),(1534,'1','281','2',1,'Received from bridging 127',0.00,0.00,23000.00,0.00,0.00,'2022-09-27 09:11:25','',''),(1535,'1','281','1',1,'Sale Id shift 95',0.00,0.00,0.00,2569.76,0.00,'2022-09-27 14:23:37','',''),(1536,'1','281','2',1,'Sale Id shift 95',0.00,0.00,0.00,2752.71,0.00,'2022-09-27 14:23:37','',''),(1537,'1','281','2',1,'Sale Id shift 95',0.00,0.00,0.00,2621.38,0.00,'2022-09-27 14:23:37','',''),(1538,'1','281','2',1,'Sale Id shift 95',0.00,0.00,0.00,2410.91,0.00,'2022-09-27 14:23:37','',''),(1539,'1','281','3',2,'Sale Id shift 95',0.00,0.00,0.00,2393.62,0.00,'2022-09-27 14:23:37','',''),(1540,'1','281','3',2,'Sale Id shift 95',0.00,0.00,0.00,197.84,0.00,'2022-09-27 14:23:37','',''),(1541,'1','281','1',1,'Sale Id shift 95',0.00,0.00,0.00,2070.77,0.00,'2022-09-27 14:23:37','',''),(1542,'1','281','1',1,'Sale Id shift 95',0.00,0.00,0.00,1941.92,0.00,'2022-09-27 14:23:37','',''),(1543,'1','281','1',1,'Sale Id shift 95',0.00,0.00,0.00,2071.03,0.00,'2022-09-27 14:23:37','',''),(1544,'1','281','1',1,'Sale Id shift 95',0.00,0.00,0.00,2844.68,0.00,'2022-09-27 14:23:37','',''),(1545,'1','281','2',1,'Sale Id shift 95',0.00,0.00,0.00,2868.06,0.00,'2022-09-27 14:23:37','',''),(1546,'1','281',NULL,2,'Sale Id shift 95',2073168.00,0.00,0.00,0.00,0.00,'2022-09-27 14:23:37','',''),(1547,'1','281',NULL,1,'Sale Id shift 95',4097975.70,0.00,0.00,0.00,0.00,'2022-09-27 14:23:37','',''),(1548,'1','281','1',1,'Sale Id shift 96',0.00,0.00,0.00,521.93,0.00,'2022-09-27 15:08:40','',''),(1549,'1','281',NULL,1,'Sale Id shift 96',96557.05,0.00,0.00,0.00,0.00,'2022-09-27 15:08:40','',''),(1550,'1','281','1',1,'Sale Id shift 97',0.00,0.00,0.00,2705.87,0.00,'2022-09-28 08:15:35','',''),(1551,'1','281','2',1,'Sale Id shift 97',0.00,0.00,0.00,3089.63,0.00,'2022-09-28 08:15:35','',''),(1552,'1','281','2',1,'Sale Id shift 97',0.00,0.00,0.00,569.32,0.00,'2022-09-28 08:15:35','',''),(1553,'1','281','2',1,'Sale Id shift 97',0.00,0.00,0.00,1168.06,0.00,'2022-09-28 08:15:35','',''),(1554,'1','281','3',2,'Sale Id shift 97',0.00,0.00,0.00,1965.85,0.00,'2022-09-28 08:15:35','',''),(1555,'1','281','3',2,'Sale Id shift 97',0.00,0.00,0.00,1841.57,0.00,'2022-09-28 08:15:35','',''),(1556,'1','281','1',1,'Sale Id shift 97',0.00,0.00,0.00,2588.66,0.00,'2022-09-28 08:15:35','',''),(1557,'1','281','1',1,'Sale Id shift 97',0.00,0.00,0.00,971.70,0.00,'2022-09-28 08:15:35','',''),(1558,'1','281','1',1,'Sale Id shift 97',0.00,0.00,0.00,1781.02,0.00,'2022-09-28 08:15:35','',''),(1559,'1','281','1',1,'Sale Id shift 97',0.00,0.00,0.00,2782.65,0.00,'2022-09-28 08:15:35','',''),(1560,'1','281','2',1,'Sale Id shift 97',0.00,0.00,0.00,1546.92,0.00,'2022-09-28 08:15:35','',''),(1561,'1','281','2',1,'Sale Id shift 97',0.00,0.00,0.00,1023.44,0.00,'2022-09-28 08:15:35','',''),(1562,'1','281',NULL,2,'Sale Id shift 97',3045936.00,0.00,0.00,0.00,0.00,'2022-09-28 08:15:35','',''),(1563,'1','281',NULL,1,'Sale Id shift 97',3372044.95,0.00,0.00,0.00,0.00,'2022-09-28 08:15:35','',''),(1564,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,7400000.00,40000.00,0.00,0.00,'2022-09-28 08:15:54','',''),(1565,'1','281',NULL,1,'Reception corrector for bridging 128',0.00,0.00,0.00,20000.00,0.00,'2022-09-28 08:33:39','',''),(1566,'1','281','1',1,'Received from bridging 128',0.00,0.00,20000.00,0.00,0.00,'2022-09-28 08:33:39','',''),(1567,'1','281',NULL,1,'Reception corrector for bridging 129',0.00,0.00,0.00,20000.00,0.00,'2022-09-28 08:34:05','',''),(1568,'1','281','2',1,'Received from bridging 129',0.00,0.00,20000.00,0.00,0.00,'2022-09-28 08:34:05','',''),(1569,'1','281',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,12000000.00,15000.00,0.00,0.00,'2022-09-28 08:46:07','',''),(1570,'1','281',NULL,2,'Reception corrector for bridging 130',0.00,0.00,0.00,15000.00,0.00,'2022-09-28 09:29:41','',''),(1571,'1','281','3',2,'Received from bridging 130',0.00,0.00,15000.00,0.00,0.00,'2022-09-28 09:29:41','',''),(1572,'1','281','1',1,'Sale Id shift 98',0.00,0.00,0.00,2169.39,0.00,'2022-09-28 14:43:47','',''),(1573,'1','281','2',1,'Sale Id shift 98',0.00,0.00,0.00,1900.02,0.00,'2022-09-28 14:43:47','',''),(1574,'1','281','2',1,'Sale Id shift 98',0.00,0.00,0.00,2895.83,0.00,'2022-09-28 14:43:47','',''),(1575,'1','281','3',2,'Sale Id shift 98',0.00,0.00,0.00,350.90,0.00,'2022-09-28 14:43:47','',''),(1576,'1','281','1',1,'Sale Id shift 98',0.00,0.00,0.00,2128.27,0.00,'2022-09-28 14:43:47','',''),(1577,'1','281','1',1,'Sale Id shift 98',0.00,0.00,0.00,2285.74,0.00,'2022-09-28 14:43:47','',''),(1578,'1','281','1',1,'Sale Id shift 98',0.00,0.00,0.00,1945.13,0.00,'2022-09-28 14:43:47','',''),(1579,'1','281','1',1,'Sale Id shift 98',0.00,0.00,0.00,2215.97,0.00,'2022-09-28 14:43:47','',''),(1580,'1','281','2',1,'Sale Id shift 98',0.00,0.00,0.00,3226.24,0.00,'2022-09-28 14:43:47','',''),(1581,'1','281','2',1,'Sale Id shift 98',0.00,0.00,0.00,2320.20,0.00,'2022-09-28 14:43:47','',''),(1582,'1','281',NULL,2,'Sale Id shift 98',280720.00,0.00,0.00,0.00,0.00,'2022-09-28 14:43:47','',''),(1583,'1','281',NULL,1,'Sale Id shift 98',3901056.15,0.00,0.00,0.00,0.00,'2022-09-28 14:43:47','',''),(1584,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,7400000.00,40000.00,0.00,0.00,'2022-09-29 07:52:53','',''),(1585,'1','281','1',1,'Sale Id shift 99',0.00,0.00,0.00,172.71,0.00,'2022-09-29 11:25:35','',''),(1586,'1','281','2',1,'Sale Id shift 99',0.00,0.00,0.00,237.85,0.00,'2022-09-29 11:25:35','',''),(1587,'1','281','2',1,'Sale Id shift 99',0.00,0.00,0.00,3661.60,0.00,'2022-09-29 11:25:35','',''),(1588,'1','281','2',1,'Sale Id shift 99',0.00,0.00,0.00,2989.99,0.00,'2022-09-29 11:25:35','',''),(1589,'1','281','3',2,'Sale Id shift 99',0.00,0.00,0.00,167.46,0.00,'2022-09-29 11:25:35','',''),(1590,'1','281','1',1,'Sale Id shift 99',0.00,0.00,0.00,97.85,0.00,'2022-09-29 11:25:35','',''),(1591,'1','281','1',1,'Sale Id shift 99',0.00,0.00,0.00,3043.13,0.00,'2022-09-29 11:25:35','',''),(1592,'1','281','1',1,'Sale Id shift 99',0.00,0.00,0.00,3823.87,0.00,'2022-09-29 11:25:35','',''),(1593,'1','281','1',1,'Sale Id shift 99',0.00,0.00,0.00,140.21,0.00,'2022-09-29 11:25:35','',''),(1594,'1','281','2',1,'Sale Id shift 99',0.00,0.00,0.00,4596.61,0.00,'2022-09-29 11:25:35','',''),(1595,'1','281',NULL,2,'Sale Id shift 99',134805.30,0.00,0.00,0.00,0.00,'2022-09-29 11:25:35','',''),(1596,'1','281',NULL,1,'Sale Id shift 99',3471306.70,0.00,0.00,0.00,0.00,'2022-09-29 11:25:35','',''),(1597,'1','281','3',2,'Sale Id shift 100',0.00,0.00,0.00,149.00,0.00,'2022-09-29 14:21:13','',''),(1598,'1','281',NULL,2,'Sale Id shift 100',119945.00,0.00,0.00,0.00,0.00,'2022-09-29 14:21:13','',''),(1599,'1','281','1',1,'Sale Id shift 101',0.00,0.00,0.00,2573.30,0.00,'2022-09-29 14:48:32','',''),(1600,'1','281','2',1,'Sale Id shift 101',0.00,0.00,0.00,748.59,0.00,'2022-09-29 14:48:32','',''),(1601,'1','281','2',1,'Sale Id shift 101',0.00,0.00,0.00,2183.17,0.00,'2022-09-29 14:48:32','',''),(1602,'1','281','2',1,'Sale Id shift 101',0.00,0.00,0.00,1912.62,0.00,'2022-09-29 14:48:32','',''),(1603,'1','281','3',2,'Sale Id shift 101',0.00,0.00,0.00,912.63,0.00,'2022-09-29 14:48:32','',''),(1604,'1','281','1',1,'Sale Id shift 101',0.00,0.00,0.00,3143.95,0.00,'2022-09-29 14:48:32','',''),(1605,'1','281','1',1,'Sale Id shift 101',0.00,0.00,0.00,1483.92,0.00,'2022-09-29 14:48:32','',''),(1606,'1','281','1',1,'Sale Id shift 101',0.00,0.00,0.00,1634.25,0.00,'2022-09-29 14:48:32','',''),(1607,'1','281','1',1,'Sale Id shift 101',0.00,0.00,0.00,839.03,0.00,'2022-09-29 14:48:32','',''),(1608,'1','281','1',1,'Sale Id shift 101',0.00,0.00,0.00,3243.61,0.00,'2022-09-29 14:48:32','',''),(1609,'1','281','2',1,'Sale Id shift 101',0.00,0.00,0.00,3154.90,0.00,'2022-09-29 14:48:32','',''),(1610,'1','281','2',1,'Sale Id shift 101',0.00,0.00,0.00,2913.72,0.00,'2022-09-29 14:48:32','',''),(1611,'1','281',NULL,2,'Sale Id shift 101',743793.45,0.00,0.00,0.00,0.00,'2022-09-29 14:48:32','',''),(1612,'1','281',NULL,1,'Sale Id shift 101',4408746.10,0.00,0.00,0.00,0.00,'2022-09-29 14:48:32','',''),(1613,'1','281',NULL,1,'Reception corrector for bridging 132',0.00,0.00,0.00,20000.00,0.00,'2022-09-29 23:33:26','',''),(1614,'1','281','2',1,'Received from bridging 132',0.00,0.00,20000.00,0.00,0.00,'2022-09-29 23:33:26','',''),(1615,'1','281',NULL,1,'Reception corrector for bridging 131',0.00,0.00,0.00,20000.00,0.00,'2022-09-29 23:33:47','',''),(1616,'1','281','1',1,'Received from bridging 131',0.00,0.00,20000.00,0.00,0.00,'2022-09-29 23:33:47','',''),(1617,'1','281','1',1,'Sale Id shift 102',0.00,0.00,0.00,1721.54,0.00,'2022-09-30 07:43:41','',''),(1618,'1','281','2',1,'Sale Id shift 102',0.00,0.00,0.00,1735.10,0.00,'2022-09-30 07:43:41','',''),(1619,'1','281','2',1,'Sale Id shift 102',0.00,0.00,0.00,2148.90,0.00,'2022-09-30 07:43:41','',''),(1620,'1','281','3',2,'Sale Id shift 102',0.00,0.00,0.00,1250.48,0.00,'2022-09-30 07:43:41','',''),(1621,'1','281','3',2,'Sale Id shift 102',0.00,0.00,0.00,94.71,0.00,'2022-09-30 07:43:41','',''),(1622,'1','281','1',1,'Sale Id shift 102',0.00,0.00,0.00,2072.05,0.00,'2022-09-30 07:43:41','',''),(1623,'1','281','1',1,'Sale Id shift 102',0.00,0.00,0.00,2163.37,0.00,'2022-09-30 07:43:41','',''),(1624,'1','281','1',1,'Sale Id shift 102',0.00,0.00,0.00,391.52,0.00,'2022-09-30 07:43:41','',''),(1625,'1','281','1',1,'Sale Id shift 102',0.00,0.00,0.00,2441.54,0.00,'2022-09-30 07:43:41','',''),(1626,'1','281','2',1,'Sale Id shift 102',0.00,0.00,0.00,3227.47,0.00,'2022-09-30 07:43:41','',''),(1627,'1','281','2',1,'Sale Id shift 102',0.00,0.00,0.00,1982.68,0.00,'2022-09-30 07:43:41','',''),(1628,'1','281',NULL,2,'Sale Id shift 102',1096329.85,0.00,0.00,0.00,0.00,'2022-09-30 07:43:41','',''),(1629,'1','281',NULL,1,'Sale Id shift 102',3308571.45,0.00,0.00,0.00,0.00,'2022-09-30 07:43:41','',''),(1630,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,6105000.00,33000.00,0.00,0.00,'2022-09-30 09:10:45','',''),(1631,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,5550000.00,30000.00,0.00,0.00,'2022-09-30 14:53:03','',''),(1632,'1','281','1',1,'Sale Id shift 103',0.00,0.00,0.00,2452.29,0.00,'2022-09-30 14:57:57','',''),(1633,'1','281','2',1,'Sale Id shift 103',0.00,0.00,0.00,3794.44,0.00,'2022-09-30 14:57:57','',''),(1634,'1','281','2',1,'Sale Id shift 103',0.00,0.00,0.00,3110.88,0.00,'2022-09-30 14:57:57','',''),(1635,'1','281','2',1,'Sale Id shift 103',0.00,0.00,0.00,2193.00,0.00,'2022-09-30 14:57:57','',''),(1636,'1','281','3',2,'Sale Id shift 103',0.00,0.00,0.00,601.77,0.00,'2022-09-30 14:57:57','',''),(1637,'1','281','3',2,'Sale Id shift 103',0.00,0.00,0.00,14.71,0.00,'2022-09-30 14:57:57','',''),(1638,'1','281','1',1,'Sale Id shift 103',0.00,0.00,0.00,2666.47,0.00,'2022-09-30 14:57:57','',''),(1639,'1','281','1',1,'Sale Id shift 103',0.00,0.00,0.00,3046.24,0.00,'2022-09-30 14:57:57','',''),(1640,'1','281','1',1,'Sale Id shift 103',0.00,0.00,0.00,3561.60,0.00,'2022-09-30 14:57:57','',''),(1641,'1','281','2',1,'Sale Id shift 103',0.00,0.00,0.00,3235.49,0.00,'2022-09-30 14:57:57','',''),(1642,'1','281',NULL,2,'Sale Id shift 103',502431.20,0.00,0.00,0.00,0.00,'2022-09-30 14:57:57','',''),(1643,'1','281',NULL,1,'Sale Id shift 103',4451175.85,0.00,0.00,0.00,0.00,'2022-09-30 14:57:57','',''),(1644,'1','281',NULL,1,'Reception corrector for bridging 134',0.00,0.00,0.00,15000.00,0.00,'2022-09-30 23:34:17','',''),(1645,'1','281','2',1,'Received from bridging 134',0.00,0.00,15000.00,0.00,0.00,'2022-09-30 23:34:17','',''),(1646,'1','281',NULL,1,'Reception corrector for bridging 133',0.00,0.00,0.00,15000.00,0.00,'2022-09-30 23:34:43','',''),(1647,'1','281','1',1,'Received from bridging 133',0.00,0.00,15000.00,0.00,0.00,'2022-09-30 23:34:43','',''),(1648,'1','281','2',1,'Sale Id shift 104',0.00,0.00,0.00,1823.70,0.00,'2022-10-01 08:22:59','',''),(1649,'1','281','2',1,'Sale Id shift 104',0.00,0.00,0.00,2512.38,0.00,'2022-10-01 08:22:59','',''),(1650,'1','281','3',2,'Sale Id shift 104',0.00,0.00,0.00,1565.65,0.00,'2022-10-01 08:22:59','',''),(1651,'1','281','3',2,'Sale Id shift 104',0.00,0.00,0.00,710.13,0.00,'2022-10-01 08:22:59','',''),(1652,'1','281','1',1,'Sale Id shift 104',0.00,0.00,0.00,2689.55,0.00,'2022-10-01 08:22:59','',''),(1653,'1','281','1',1,'Sale Id shift 104',0.00,0.00,0.00,1943.92,0.00,'2022-10-01 08:22:59','',''),(1654,'1','281','1',1,'Sale Id shift 104',0.00,0.00,0.00,3196.59,0.00,'2022-10-01 08:22:59','',''),(1655,'1','281','2',1,'Sale Id shift 104',0.00,0.00,0.00,3446.28,0.00,'2022-10-01 08:22:59','',''),(1656,'1','281','2',1,'Sale Id shift 104',0.00,0.00,0.00,2328.55,0.00,'2022-10-01 08:22:59','',''),(1657,'1','281',NULL,2,'Sale Id shift 104',1854760.70,0.00,0.00,0.00,0.00,'2022-10-01 08:22:59','',''),(1658,'1','281',NULL,1,'Sale Id shift 104',3319079.45,0.00,0.00,0.00,0.00,'2022-10-01 08:22:59','',''),(1659,'1','281',NULL,1,'Reception corrector for bridging 136',0.00,0.00,0.00,18000.00,0.00,'2022-10-01 13:36:09','',''),(1660,'1','281','2',1,'Received from bridging 136',0.00,0.00,18000.00,0.00,0.00,'2022-10-01 13:36:09','',''),(1661,'1','281',NULL,1,'Reception corrector for bridging 135',0.00,0.00,0.00,15000.00,0.00,'2022-10-01 13:36:29','',''),(1662,'1','281','1',1,'Received from bridging 135',0.00,0.00,15000.00,0.00,0.00,'2022-10-01 13:36:29','',''),(1663,'1','281','1',1,'Sale Id shift 105',0.00,0.00,0.00,2036.43,0.00,'2022-10-01 17:53:07','',''),(1664,'1','281','2',1,'Sale Id shift 105',0.00,0.00,0.00,2093.62,0.00,'2022-10-01 17:53:07','',''),(1665,'1','281','2',1,'Sale Id shift 105',0.00,0.00,0.00,2139.28,0.00,'2022-10-01 17:53:07','',''),(1666,'1','281','2',1,'Sale Id shift 105',0.00,0.00,0.00,2148.94,0.00,'2022-10-01 17:53:07','',''),(1667,'1','281','3',2,'Sale Id shift 105',0.00,0.00,0.00,1395.12,0.00,'2022-10-01 17:53:07','',''),(1668,'1','281','1',1,'Sale Id shift 105',0.00,0.00,0.00,2145.62,0.00,'2022-10-01 17:53:07','',''),(1669,'1','281','1',1,'Sale Id shift 105',0.00,0.00,0.00,4129.31,0.00,'2022-10-01 17:53:07','',''),(1670,'1','281','1',1,'Sale Id shift 105',0.00,0.00,0.00,3206.27,0.00,'2022-10-01 17:53:07','',''),(1671,'1','281','2',1,'Sale Id shift 105',0.00,0.00,0.00,3134.63,0.00,'2022-10-01 17:53:07','',''),(1672,'1','281','2',1,'Sale Id shift 105',0.00,0.00,0.00,2453.79,0.00,'2022-10-01 17:53:07','',''),(1673,'1','281',NULL,2,'Sale Id shift 105',1137022.80,0.00,0.00,0.00,0.00,'2022-10-01 17:53:07','',''),(1674,'1','281',NULL,1,'Sale Id shift 105',4345259.65,0.00,0.00,0.00,0.00,'2022-10-01 17:53:07','',''),(1675,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,7770000.00,42000.00,0.00,0.00,'2022-10-02 10:15:47','',''),(1676,'1','281',NULL,1,'Returned purchase #70 to AA RANO NIGERIA LTD',7770000.00,0.00,0.00,42000.00,0.00,'2022-10-02 10:16:19','',''),(1677,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,7751500.00,41900.00,0.00,0.00,'2022-10-02 10:40:42','',''),(1678,'1','281',NULL,1,'Reception corrector for bridging 138',0.00,0.00,0.00,16900.00,0.00,'2022-10-02 10:56:24','',''),(1679,'1','281','2',1,'Received from bridging 138',0.00,0.00,16900.00,0.00,0.00,'2022-10-02 10:56:24','',''),(1680,'1','281','1',1,'Sale Id shift 106',0.00,0.00,0.00,467.34,0.00,'2022-10-02 15:08:18','',''),(1681,'1','281','2',1,'Sale Id shift 106',0.00,0.00,0.00,933.31,0.00,'2022-10-02 15:08:18','',''),(1682,'1','281','2',1,'Sale Id shift 106',0.00,0.00,0.00,1179.10,0.00,'2022-10-02 15:08:18','',''),(1683,'1','281','2',1,'Sale Id shift 106',0.00,0.00,0.00,1960.63,0.00,'2022-10-02 15:08:18','',''),(1684,'1','281','3',2,'Sale Id shift 106',0.00,0.00,0.00,701.46,0.00,'2022-10-02 15:08:18','',''),(1685,'1','281','1',1,'Sale Id shift 106',0.00,0.00,0.00,1083.42,0.00,'2022-10-02 15:08:18','',''),(1686,'1','281','1',1,'Sale Id shift 106',0.00,0.00,0.00,569.28,0.00,'2022-10-02 15:08:18','',''),(1687,'1','281','1',1,'Sale Id shift 106',0.00,0.00,0.00,1132.29,0.00,'2022-10-02 15:08:18','',''),(1688,'1','281','1',1,'Sale Id shift 106',0.00,0.00,0.00,835.04,0.00,'2022-10-02 15:08:18','',''),(1689,'1','281','1',1,'Sale Id shift 106',0.00,0.00,0.00,526.01,0.00,'2022-10-02 15:08:18','',''),(1690,'1','281','2',1,'Sale Id shift 106',0.00,0.00,0.00,826.41,0.00,'2022-10-02 15:08:18','',''),(1691,'1','281','2',1,'Sale Id shift 106',0.00,0.00,0.00,795.04,0.00,'2022-10-02 15:08:18','',''),(1692,'1','281',NULL,2,'Sale Id shift 106',571689.90,0.00,0.00,0.00,0.00,'2022-10-02 15:08:18','',''),(1693,'1','281',NULL,1,'Sale Id shift 106',1906955.95,0.00,0.00,0.00,0.00,'2022-10-02 15:08:18','',''),(1694,'1','281',NULL,1,'Reception corrector for bridging 137',0.00,0.00,0.00,25000.00,0.00,'2022-10-02 19:14:27','',''),(1695,'1','281','1',1,'Received from bridging 137',0.00,0.00,25000.00,0.00,0.00,'2022-10-02 19:14:27','',''),(1696,'1','281','1',1,'Sale Id shift 107',0.00,0.00,0.00,1825.04,0.00,'2022-10-02 21:45:12','',''),(1697,'1','281','2',1,'Sale Id shift 107',0.00,0.00,0.00,1811.68,0.00,'2022-10-02 21:45:12','',''),(1698,'1','281','2',1,'Sale Id shift 107',0.00,0.00,0.00,2105.19,0.00,'2022-10-02 21:45:12','',''),(1699,'1','281','2',1,'Sale Id shift 107',0.00,0.00,0.00,1618.89,0.00,'2022-10-02 21:45:12','',''),(1700,'1','281','3',2,'Sale Id shift 107',0.00,0.00,0.00,830.24,0.00,'2022-10-02 21:45:12','',''),(1701,'1','281','1',1,'Sale Id shift 107',0.00,0.00,0.00,1986.55,0.00,'2022-10-02 21:45:12','',''),(1702,'1','281','1',1,'Sale Id shift 107',0.00,0.00,0.00,2064.39,0.00,'2022-10-02 21:45:12','',''),(1703,'1','281','1',1,'Sale Id shift 107',0.00,0.00,0.00,1973.55,0.00,'2022-10-02 21:45:12','',''),(1704,'1','281','1',1,'Sale Id shift 107',0.00,0.00,0.00,2168.26,0.00,'2022-10-02 21:45:12','',''),(1705,'1','281','2',1,'Sale Id shift 107',0.00,0.00,0.00,2663.73,0.00,'2022-10-02 21:45:12','',''),(1706,'1','281',NULL,2,'Sale Id shift 107',676645.60,0.00,0.00,0.00,0.00,'2022-10-02 21:45:12','',''),(1707,'1','281',NULL,1,'Sale Id shift 107',3370196.80,0.00,0.00,0.00,0.00,'2022-10-02 21:45:12','',''),(1708,'1','281','2',1,'Sale Id shift 108',0.00,0.00,0.00,4929.69,0.00,'2022-10-03 11:07:15','',''),(1709,'1','281','2',1,'Sale Id shift 108',0.00,0.00,0.00,4312.71,0.00,'2022-10-03 11:07:15','',''),(1710,'1','281','3',2,'Sale Id shift 108',0.00,0.00,0.00,1482.35,0.00,'2022-10-03 11:07:15','',''),(1711,'1','281','3',2,'Sale Id shift 108',0.00,0.00,0.00,904.40,0.00,'2022-10-03 11:07:15','',''),(1712,'1','281','1',1,'Sale Id shift 108',0.00,0.00,0.00,2750.47,0.00,'2022-10-03 11:07:15','',''),(1713,'1','281','1',1,'Sale Id shift 108',0.00,0.00,0.00,3608.57,0.00,'2022-10-03 11:07:15','',''),(1714,'1','281','2',1,'Sale Id shift 108',0.00,0.00,0.00,3707.02,0.00,'2022-10-03 11:07:15','',''),(1715,'1','281',NULL,2,'Sale Id shift 108',1945201.25,0.00,0.00,0.00,0.00,'2022-10-03 11:07:15','',''),(1716,'1','281',NULL,1,'Sale Id shift 108',3572065.10,0.00,0.00,0.00,0.00,'2022-10-03 11:07:15','',''),(1717,'1','281','3',2,'Sale Id shift 109',0.00,0.00,0.00,172.48,0.00,'2022-10-03 15:26:51','',''),(1718,'1','281','3',2,'Sale Id shift 109',0.00,0.00,0.00,34.74,0.00,'2022-10-03 15:26:51','',''),(1719,'1','281',NULL,2,'Sale Id shift 109',168884.30,0.00,0.00,0.00,0.00,'2022-10-03 15:26:51','',''),(1720,'1','281','3',2,'Sale Id shift 110',0.00,0.00,0.00,1282.31,0.00,'2022-10-04 07:51:41','',''),(1721,'1','281','3',2,'Sale Id shift 110',0.00,0.00,0.00,336.59,0.00,'2022-10-04 07:51:41','',''),(1722,'1','281',NULL,2,'Sale Id shift 110',1319403.50,0.00,0.00,0.00,0.00,'2022-10-04 07:51:41','',''),(1723,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9250000.00,50000.00,0.00,0.00,'2022-10-04 07:57:12','',''),(1724,'1','281',NULL,1,'Reception corrector for bridging 139',0.00,0.00,0.00,19000.00,0.00,'2022-10-04 11:24:26','',''),(1725,'1','281','1',1,'Received from bridging 139',0.00,0.00,19000.00,0.00,0.00,'2022-10-04 11:24:26','',''),(1726,'1','281',NULL,1,'Reception corrector for bridging 140',0.00,0.00,0.00,31000.00,0.00,'2022-10-04 11:24:47','',''),(1727,'1','281','2',1,'Received from bridging 140',0.00,0.00,31000.00,0.00,0.00,'2022-10-04 11:24:47','',''),(1728,'1','281','1',1,'Sale Id shift 111',0.00,0.00,0.00,2896.80,0.00,'2022-10-04 15:14:20','',''),(1729,'1','281','2',1,'Sale Id shift 111',0.00,0.00,0.00,3847.26,0.00,'2022-10-04 15:14:20','',''),(1730,'1','281','2',1,'Sale Id shift 111',0.00,0.00,0.00,3126.21,0.00,'2022-10-04 15:14:20','',''),(1731,'1','281','2',1,'Sale Id shift 111',0.00,0.00,0.00,2470.79,0.00,'2022-10-04 15:14:20','',''),(1732,'1','281','3',2,'Sale Id shift 111',0.00,0.00,0.00,256.64,0.00,'2022-10-04 15:14:20','',''),(1733,'1','281','1',1,'Sale Id shift 111',0.00,0.00,0.00,2477.25,0.00,'2022-10-04 15:14:20','',''),(1734,'1','281','1',1,'Sale Id shift 111',0.00,0.00,0.00,2545.13,0.00,'2022-10-04 15:14:20','',''),(1735,'1','281','1',1,'Sale Id shift 111',0.00,0.00,0.00,2852.29,0.00,'2022-10-04 15:14:20','',''),(1736,'1','281','1',1,'Sale Id shift 111',0.00,0.00,0.00,3374.42,0.00,'2022-10-04 15:14:20','',''),(1737,'1','281','2',1,'Sale Id shift 111',0.00,0.00,0.00,3996.44,0.00,'2022-10-04 15:14:20','',''),(1738,'1','281',NULL,2,'Sale Id shift 111',209161.60,0.00,0.00,0.00,0.00,'2022-10-04 15:14:20','',''),(1739,'1','281',NULL,1,'Sale Id shift 111',5103519.15,0.00,0.00,0.00,0.00,'2022-10-04 15:14:20','',''),(1740,'1','281','1',1,'Sale Id shift 112',0.00,0.00,0.00,3343.31,0.00,'2022-10-05 07:47:05','',''),(1741,'1','281','2',1,'Sale Id shift 112',0.00,0.00,0.00,3917.22,0.00,'2022-10-05 07:47:05','',''),(1742,'1','281','2',1,'Sale Id shift 112',0.00,0.00,0.00,799.38,0.00,'2022-10-05 07:47:05','',''),(1743,'1','281','2',1,'Sale Id shift 112',0.00,0.00,0.00,1039.40,0.00,'2022-10-05 07:47:05','',''),(1744,'1','281','3',2,'Sale Id shift 112',0.00,0.00,0.00,1978.48,0.00,'2022-10-05 07:47:05','',''),(1745,'1','281','1',1,'Sale Id shift 112',0.00,0.00,0.00,3773.90,0.00,'2022-10-05 07:47:05','',''),(1746,'1','281','1',1,'Sale Id shift 112',0.00,0.00,0.00,489.98,0.00,'2022-10-05 07:47:05','',''),(1747,'1','281','1',1,'Sale Id shift 112',0.00,0.00,0.00,1198.01,0.00,'2022-10-05 07:47:05','',''),(1748,'1','281','1',1,'Sale Id shift 112',0.00,0.00,0.00,3319.60,0.00,'2022-10-05 07:47:05','',''),(1749,'1','281','1',1,'Sale Id shift 112',0.00,0.00,0.00,4022.00,0.00,'2022-10-05 07:47:05','',''),(1750,'1','281','2',1,'Sale Id shift 112',0.00,0.00,0.00,1554.57,0.00,'2022-10-05 07:47:05','',''),(1751,'1','281','2',1,'Sale Id shift 112',0.00,0.00,0.00,3710.58,0.00,'2022-10-05 07:47:05','',''),(1752,'1','281',NULL,2,'Sale Id shift 112',1612461.20,0.00,0.00,0.00,0.00,'2022-10-05 07:47:05','',''),(1753,'1','281',NULL,1,'Sale Id shift 112',5026070.75,0.00,0.00,0.00,0.00,'2022-10-05 07:47:05','',''),(1754,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9250000.00,50000.00,0.00,0.00,'2022-10-05 07:47:28','',''),(1755,'1','281',NULL,1,'Reception corrector for bridging 141',0.00,0.00,0.00,23000.00,0.00,'2022-10-05 11:15:13','',''),(1756,'1','281','1',1,'Received from bridging 141',0.00,0.00,23000.00,0.00,0.00,'2022-10-05 11:15:13','',''),(1757,'1','281',NULL,1,'Reception corrector for bridging 142',0.00,0.00,0.00,27000.00,0.00,'2022-10-05 11:15:38','',''),(1758,'1','281','2',1,'Received from bridging 142',0.00,0.00,27000.00,0.00,0.00,'2022-10-05 11:15:38','',''),(1759,'1','281','1',1,'Sale Id shift 113',0.00,0.00,0.00,2865.12,0.00,'2022-10-05 15:17:52','',''),(1760,'1','281','2',1,'Sale Id shift 113',0.00,0.00,0.00,3241.28,0.00,'2022-10-05 15:17:52','',''),(1761,'1','281','2',1,'Sale Id shift 113',0.00,0.00,0.00,2877.20,0.00,'2022-10-05 15:17:52','',''),(1762,'1','281','2',1,'Sale Id shift 113',0.00,0.00,0.00,3132.59,0.00,'2022-10-05 15:17:52','',''),(1763,'1','281','3',2,'Sale Id shift 113',0.00,0.00,0.00,744.14,0.00,'2022-10-05 15:17:52','',''),(1764,'1','281','1',1,'Sale Id shift 113',0.00,0.00,0.00,2881.29,0.00,'2022-10-05 15:17:52','',''),(1765,'1','281','1',1,'Sale Id shift 113',0.00,0.00,0.00,2483.27,0.00,'2022-10-05 15:17:52','',''),(1766,'1','281','1',1,'Sale Id shift 113',0.00,0.00,0.00,2259.63,0.00,'2022-10-05 15:17:52','',''),(1767,'1','281','1',1,'Sale Id shift 113',0.00,0.00,0.00,3305.38,0.00,'2022-10-05 15:17:52','',''),(1768,'1','281','2',1,'Sale Id shift 113',0.00,0.00,0.00,3833.19,0.00,'2022-10-05 15:17:52','',''),(1769,'1','281','2',1,'Sale Id shift 113',0.00,0.00,0.00,463.25,0.00,'2022-10-05 15:17:52','',''),(1770,'1','281',NULL,2,'Sale Id shift 113',606474.10,0.00,0.00,0.00,0.00,'2022-10-05 15:17:52','',''),(1771,'1','281',NULL,1,'Sale Id shift 113',5058307.00,0.00,0.00,0.00,0.00,'2022-10-05 15:17:52','',''),(1772,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9250000.00,50000.00,0.00,0.00,'2022-10-06 07:50:17','',''),(1773,'1','281','1',1,'Sale Id shift 114',0.00,0.00,0.00,2329.15,0.00,'2022-10-06 09:13:07','',''),(1774,'1','281','2',1,'Sale Id shift 114',0.00,0.00,0.00,2746.52,0.00,'2022-10-06 09:13:07','',''),(1775,'1','281','2',1,'Sale Id shift 114',0.00,0.00,0.00,912.87,0.00,'2022-10-06 09:13:07','',''),(1776,'1','281','2',1,'Sale Id shift 114',0.00,0.00,0.00,2490.47,0.00,'2022-10-06 09:13:07','',''),(1777,'1','281','3',2,'Sale Id shift 114',0.00,0.00,0.00,1887.30,0.00,'2022-10-06 09:13:07','',''),(1778,'1','281','1',1,'Sale Id shift 114',0.00,0.00,0.00,2497.90,0.00,'2022-10-06 09:13:07','',''),(1779,'1','281','1',1,'Sale Id shift 114',0.00,0.00,0.00,1114.93,0.00,'2022-10-06 09:13:07','',''),(1780,'1','281','1',1,'Sale Id shift 114',0.00,0.00,0.00,2605.73,0.00,'2022-10-06 09:13:07','',''),(1781,'1','281','1',1,'Sale Id shift 114',0.00,0.00,0.00,2384.67,0.00,'2022-10-06 09:13:07','',''),(1782,'1','281','1',1,'Sale Id shift 114',0.00,0.00,0.00,2710.59,0.00,'2022-10-06 09:13:07','',''),(1783,'1','281','2',1,'Sale Id shift 114',0.00,0.00,0.00,3058.71,0.00,'2022-10-06 09:13:07','',''),(1784,'1','281','2',1,'Sale Id shift 114',0.00,0.00,0.00,1711.09,0.00,'2022-10-06 09:13:07','',''),(1785,'1','281',NULL,2,'Sale Id shift 114',1538149.50,0.00,0.00,0.00,0.00,'2022-10-06 09:13:07','',''),(1786,'1','281',NULL,1,'Sale Id shift 114',4544086.55,0.00,0.00,0.00,0.00,'2022-10-06 09:13:07','',''),(1787,'1','281',NULL,1,'Reception corrector for bridging 143',0.00,0.00,0.00,25000.00,0.00,'2022-10-06 14:38:21','',''),(1788,'1','281','1',1,'Received from bridging 143',0.00,0.00,25000.00,0.00,0.00,'2022-10-06 14:38:21','',''),(1789,'1','281',NULL,1,'Reception corrector for bridging 144',0.00,0.00,0.00,25000.00,0.00,'2022-10-06 14:39:00','',''),(1790,'1','281','2',1,'Received from bridging 144',0.00,0.00,25000.00,0.00,0.00,'2022-10-06 14:39:00','',''),(1791,'1','281','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,2735.93,0.00,'2022-10-06 14:46:26','',''),(1792,'1','281','3',0,'Inventory adjustment from tank dipping to 3200',0.00,0.00,3200.00,0.00,0.00,'2022-10-06 14:46:26','',''),(1793,'1','281','1',1,'Sale Id shift 115',0.00,0.00,0.00,3542.56,0.00,'2022-10-06 15:05:42','',''),(1794,'1','281','2',1,'Sale Id shift 115',0.00,0.00,0.00,3331.84,0.00,'2022-10-06 15:05:42','',''),(1795,'1','281','2',1,'Sale Id shift 115',0.00,0.00,0.00,3061.94,0.00,'2022-10-06 15:05:42','',''),(1796,'1','281','2',1,'Sale Id shift 115',0.00,0.00,0.00,1892.20,0.00,'2022-10-06 15:05:42','',''),(1797,'1','281','3',2,'Sale Id shift 115',0.00,0.00,0.00,1677.74,0.00,'2022-10-06 15:05:42','',''),(1798,'1','281','3',2,'Sale Id shift 115',0.00,0.00,0.00,1400.00,0.00,'2022-10-06 15:05:42','',''),(1799,'1','281','1',1,'Sale Id shift 115',0.00,0.00,0.00,3904.76,0.00,'2022-10-06 15:05:42','',''),(1800,'1','281','1',1,'Sale Id shift 115',0.00,0.00,0.00,1768.08,0.00,'2022-10-06 15:05:42','',''),(1801,'1','281','1',1,'Sale Id shift 115',0.00,0.00,0.00,1732.69,0.00,'2022-10-06 15:05:42','',''),(1802,'1','281','1',1,'Sale Id shift 115',0.00,0.00,0.00,1090.75,0.00,'2022-10-06 15:05:42','',''),(1803,'1','281','1',1,'Sale Id shift 115',0.00,0.00,0.00,4696.17,0.00,'2022-10-06 15:05:42','',''),(1804,'1','281','2',1,'Sale Id shift 115',0.00,0.00,0.00,3512.03,0.00,'2022-10-06 15:05:42','',''),(1805,'1','281','2',1,'Sale Id shift 115',0.00,0.00,0.00,3256.04,0.00,'2022-10-06 15:05:42','',''),(1806,'1','281',NULL,2,'Sale Id shift 115',2508358.10,0.00,0.00,0.00,0.00,'2022-10-06 15:05:42','',''),(1807,'1','281',NULL,1,'Sale Id shift 115',5880976.10,0.00,0.00,0.00,0.00,'2022-10-06 15:05:42','',''),(1808,'1','281','1',1,'Sale Id shift 116',0.00,0.00,0.00,2800.55,0.00,'2022-10-07 07:53:26','',''),(1809,'1','281','2',1,'Sale Id shift 116',0.00,0.00,0.00,2850.47,0.00,'2022-10-07 07:53:26','',''),(1810,'1','281','2',1,'Sale Id shift 116',0.00,0.00,0.00,1649.44,0.00,'2022-10-07 07:53:26','',''),(1811,'1','281','2',1,'Sale Id shift 116',0.00,0.00,0.00,2538.61,0.00,'2022-10-07 07:53:26','',''),(1812,'1','281','1',1,'Sale Id shift 116',0.00,0.00,0.00,3375.72,0.00,'2022-10-07 07:53:26','',''),(1813,'1','281','1',1,'Sale Id shift 116',0.00,0.00,0.00,1268.85,0.00,'2022-10-07 07:53:26','',''),(1814,'1','281','1',1,'Sale Id shift 116',0.00,0.00,0.00,1814.60,0.00,'2022-10-07 07:53:26','',''),(1815,'1','281','1',1,'Sale Id shift 116',0.00,0.00,0.00,3193.67,0.00,'2022-10-07 07:53:26','',''),(1816,'1','281','1',1,'Sale Id shift 116',0.00,0.00,0.00,2950.29,0.00,'2022-10-07 07:53:26','',''),(1817,'1','281','2',1,'Sale Id shift 116',0.00,0.00,0.00,2387.83,0.00,'2022-10-07 07:53:26','',''),(1818,'1','281','2',1,'Sale Id shift 116',0.00,0.00,0.00,3228.37,0.00,'2022-10-07 07:53:26','',''),(1819,'1','281',NULL,1,'Sale Id shift 116',5190804.00,0.00,0.00,0.00,0.00,'2022-10-07 07:53:26','',''),(1820,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,6290000.00,34000.00,0.00,0.00,'2022-10-07 07:53:55','',''),(1821,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3792500.00,20500.00,0.00,0.00,'2022-10-07 07:54:10','',''),(1822,'1','281',NULL,1,'Reception corrector for bridging 145',0.00,0.00,0.00,17000.00,0.00,'2022-10-07 15:18:35','',''),(1823,'1','281','1',1,'Received from bridging 145',0.00,0.00,17000.00,0.00,0.00,'2022-10-07 15:18:35','',''),(1824,'1','281',NULL,1,'Reception corrector for bridging 146',0.00,0.00,0.00,17000.00,0.00,'2022-10-07 15:19:20','',''),(1825,'1','281','2',1,'Received from bridging 146',0.00,0.00,17000.00,0.00,0.00,'2022-10-07 15:19:20','',''),(1826,'1','281',NULL,1,'Reception corrector for bridging 148',0.00,0.00,0.00,10500.00,0.00,'2022-10-07 15:23:17','',''),(1827,'1','281','2',1,'Received from bridging 148',0.00,0.00,10500.00,0.00,0.00,'2022-10-07 15:23:17','',''),(1828,'1','281',NULL,1,'Reception corrector for bridging 147',0.00,0.00,0.00,10000.00,0.00,'2022-10-07 15:23:17','',''),(1829,'1','281','1',1,'Received from bridging 147',0.00,0.00,10000.00,0.00,0.00,'2022-10-07 15:23:17','',''),(1830,'1','281','1',1,'Sale Id shift 117',0.00,0.00,0.00,2287.07,0.00,'2022-10-07 15:34:19','',''),(1831,'1','281','2',1,'Sale Id shift 117',0.00,0.00,0.00,1933.06,0.00,'2022-10-07 15:34:19','',''),(1832,'1','281','2',1,'Sale Id shift 117',0.00,0.00,0.00,3425.39,0.00,'2022-10-07 15:34:19','',''),(1833,'1','281','2',1,'Sale Id shift 117',0.00,0.00,0.00,2747.41,0.00,'2022-10-07 15:34:19','',''),(1834,'1','281','1',1,'Sale Id shift 117',0.00,0.00,0.00,3147.51,0.00,'2022-10-07 15:34:19','',''),(1835,'1','281','1',1,'Sale Id shift 117',0.00,0.00,0.00,2602.83,0.00,'2022-10-07 15:34:19','',''),(1836,'1','281','1',1,'Sale Id shift 117',0.00,0.00,0.00,2909.06,0.00,'2022-10-07 15:34:19','',''),(1837,'1','281','1',1,'Sale Id shift 117',0.00,0.00,0.00,2394.35,0.00,'2022-10-07 15:34:19','',''),(1838,'1','281','1',1,'Sale Id shift 117',0.00,0.00,0.00,2587.99,0.00,'2022-10-07 15:34:19','',''),(1839,'1','281','2',1,'Sale Id shift 117',0.00,0.00,0.00,4175.79,0.00,'2022-10-07 15:34:19','',''),(1840,'1','281','2',1,'Sale Id shift 117',0.00,0.00,0.00,2921.72,0.00,'2022-10-07 15:34:19','',''),(1841,'1','281',NULL,1,'Sale Id shift 117',5759453.30,0.00,0.00,0.00,0.00,'2022-10-07 15:34:19','',''),(1842,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,11100000.00,60000.00,0.00,0.00,'2022-10-07 19:17:43','',''),(1843,'1','281','1',1,'Sale Id shift 118',0.00,0.00,0.00,699.28,0.00,'2022-10-08 07:55:09','',''),(1844,'1','281','2',1,'Sale Id shift 118',0.00,0.00,0.00,497.27,0.00,'2022-10-08 07:55:09','',''),(1845,'1','281','2',1,'Sale Id shift 118',0.00,0.00,0.00,2740.56,0.00,'2022-10-08 07:55:09','',''),(1846,'1','281','2',1,'Sale Id shift 118',0.00,0.00,0.00,2768.23,0.00,'2022-10-08 07:55:09','',''),(1847,'1','281','1',1,'Sale Id shift 118',0.00,0.00,0.00,564.93,0.00,'2022-10-08 07:55:09','',''),(1848,'1','281','1',1,'Sale Id shift 118',0.00,0.00,0.00,2440.82,0.00,'2022-10-08 07:55:09','',''),(1849,'1','281','1',1,'Sale Id shift 118',0.00,0.00,0.00,2623.04,0.00,'2022-10-08 07:55:09','',''),(1850,'1','281','1',1,'Sale Id shift 118',0.00,0.00,0.00,832.46,0.00,'2022-10-08 07:55:09','',''),(1851,'1','281','2',1,'Sale Id shift 118',0.00,0.00,0.00,4055.00,0.00,'2022-10-08 07:55:09','',''),(1852,'1','281','2',1,'Sale Id shift 118',0.00,0.00,0.00,475.09,0.00,'2022-10-08 07:55:09','',''),(1853,'1','281',NULL,1,'Sale Id shift 118',3273885.80,0.00,0.00,0.00,0.00,'2022-10-08 07:55:09','',''),(1854,'1','281','2',1,'Sale Id shift 119',0.00,0.00,0.00,2325.48,0.00,'2022-10-08 15:33:32','',''),(1855,'1','281','2',1,'Sale Id shift 119',0.00,0.00,0.00,3424.68,0.00,'2022-10-08 15:33:32','',''),(1856,'1','281','1',1,'Sale Id shift 119',0.00,0.00,0.00,3318.32,0.00,'2022-10-08 15:33:32','',''),(1857,'1','281','1',1,'Sale Id shift 119',0.00,0.00,0.00,442.58,0.00,'2022-10-08 15:33:32','',''),(1858,'1','281','1',1,'Sale Id shift 119',0.00,0.00,0.00,3285.35,0.00,'2022-10-08 15:33:32','',''),(1859,'1','281','2',1,'Sale Id shift 119',0.00,0.00,0.00,395.08,0.00,'2022-10-08 15:33:32','',''),(1860,'1','281','2',1,'Sale Id shift 119',0.00,0.00,0.00,1934.44,0.00,'2022-10-08 15:33:32','',''),(1861,'1','281',NULL,1,'Sale Id shift 119',2798297.05,0.00,0.00,0.00,0.00,'2022-10-08 15:33:32','',''),(1862,'1','281',NULL,1,'Reception corrector for bridging 150',0.00,0.00,0.00,35000.00,0.00,'2022-10-08 17:27:55','',''),(1863,'1','281','1',1,'Received from bridging 150',0.00,0.00,35000.00,0.00,0.00,'2022-10-08 17:27:55','',''),(1864,'1','281',NULL,1,'Reception corrector for bridging 151',0.00,0.00,0.00,25000.00,0.00,'2022-10-08 17:28:12','',''),(1865,'1','281','2',1,'Received from bridging 151',0.00,0.00,25000.00,0.00,0.00,'2022-10-08 17:28:12','',''),(1866,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,7400000.00,40000.00,0.00,0.00,'2022-10-09 09:30:27','',''),(1867,'1','281','1',1,'Sale Id shift 120',0.00,0.00,0.00,202.89,0.00,'2022-10-09 09:31:07','',''),(1868,'1','281','2',1,'Sale Id shift 120',0.00,0.00,0.00,3322.30,0.00,'2022-10-09 09:31:07','',''),(1869,'1','281','2',1,'Sale Id shift 120',0.00,0.00,0.00,1525.82,0.00,'2022-10-09 09:31:07','',''),(1870,'1','281','2',1,'Sale Id shift 120',0.00,0.00,0.00,1589.23,0.00,'2022-10-09 09:31:07','',''),(1871,'1','281','1',1,'Sale Id shift 120',0.00,0.00,0.00,3240.04,0.00,'2022-10-09 09:31:07','',''),(1872,'1','281','1',1,'Sale Id shift 120',0.00,0.00,0.00,1300.76,0.00,'2022-10-09 09:31:07','',''),(1873,'1','281','1',1,'Sale Id shift 120',0.00,0.00,0.00,1352.09,0.00,'2022-10-09 09:31:07','',''),(1874,'1','281','1',1,'Sale Id shift 120',0.00,0.00,0.00,173.19,0.00,'2022-10-09 09:31:07','',''),(1875,'1','281','1',1,'Sale Id shift 120',0.00,0.00,0.00,2004.89,0.00,'2022-10-09 09:31:07','',''),(1876,'1','281','2',1,'Sale Id shift 120',0.00,0.00,0.00,1859.43,0.00,'2022-10-09 09:31:07','',''),(1877,'1','281','2',1,'Sale Id shift 120',0.00,0.00,0.00,234.49,0.00,'2022-10-09 09:31:07','',''),(1878,'1','281',NULL,1,'Sale Id shift 120',3108949.05,0.00,0.00,0.00,0.00,'2022-10-09 09:31:07','',''),(1879,'1','281','2',1,'Sale Id shift 121',0.00,0.00,0.00,5342.20,0.00,'2022-10-09 16:20:28','',''),(1880,'1','281','1',1,'Sale Id shift 121',0.00,0.00,0.00,5334.99,0.00,'2022-10-09 16:20:28','',''),(1881,'1','281','1',1,'Sale Id shift 121',0.00,0.00,0.00,5740.91,0.00,'2022-10-09 16:20:28','',''),(1882,'1','281','2',1,'Sale Id shift 121',0.00,0.00,0.00,4791.68,0.00,'2022-10-09 16:20:28','',''),(1883,'1','281',NULL,1,'Sale Id shift 121',3923809.30,0.00,0.00,0.00,0.00,'2022-10-09 16:20:28','',''),(1884,'1','281','2',1,'Sale Id shift 122',0.00,0.00,0.00,3874.47,0.00,'2022-10-10 08:03:29','',''),(1885,'1','281','1',1,'Sale Id shift 122',0.00,0.00,0.00,2668.03,0.00,'2022-10-10 08:03:29','',''),(1886,'1','281','1',1,'Sale Id shift 122',0.00,0.00,0.00,507.76,0.00,'2022-10-10 08:03:29','',''),(1887,'1','281','1',1,'Sale Id shift 122',0.00,0.00,0.00,3114.80,0.00,'2022-10-10 08:03:29','',''),(1888,'1','281','2',1,'Sale Id shift 122',0.00,0.00,0.00,3327.63,0.00,'2022-10-10 08:03:29','',''),(1889,'1','281',NULL,1,'Sale Id shift 122',2496147.65,0.00,0.00,0.00,0.00,'2022-10-10 08:03:29','',''),(1890,'1','281',NULL,1,'Reception corrector for bridging 152',0.00,0.00,0.00,15000.00,0.00,'2022-10-10 09:05:13','',''),(1891,'1','281','1',1,'Received from bridging 152',0.00,0.00,15000.00,0.00,0.00,'2022-10-10 09:05:13','',''),(1892,'1','281',NULL,1,'Reception corrector for bridging 153',0.00,0.00,0.00,25000.00,0.00,'2022-10-10 09:05:35','',''),(1893,'1','281','2',1,'Received from bridging 153',0.00,0.00,25000.00,0.00,0.00,'2022-10-10 09:05:35','',''),(1894,'1','281','2',1,'Sale Id shift 123',0.00,0.00,0.00,3398.87,0.00,'2022-10-10 15:07:16','',''),(1895,'1','281','1',1,'Sale Id shift 123',0.00,0.00,0.00,2243.22,0.00,'2022-10-10 15:07:16','',''),(1896,'1','281','1',1,'Sale Id shift 123',0.00,0.00,0.00,3006.32,0.00,'2022-10-10 15:07:16','',''),(1897,'1','281','2',1,'Sale Id shift 123',0.00,0.00,0.00,2814.28,0.00,'2022-10-10 15:07:16','',''),(1898,'1','281',NULL,1,'Sale Id shift 123',2120597.65,0.00,0.00,0.00,0.00,'2022-10-10 15:07:16','',''),(1899,'1','281','2',1,'Sale Id shift 124',0.00,0.00,0.00,1492.88,0.00,'2022-10-11 09:55:14','',''),(1900,'1','281','2',1,'Sale Id shift 124',0.00,0.00,0.00,2472.41,0.00,'2022-10-11 09:55:14','',''),(1901,'1','281','1',1,'Sale Id shift 124',0.00,0.00,0.00,1884.61,0.00,'2022-10-11 09:55:14','',''),(1902,'1','281','1',1,'Sale Id shift 124',0.00,0.00,0.00,2423.26,0.00,'2022-10-11 09:55:14','',''),(1903,'1','281','2',1,'Sale Id shift 124',0.00,0.00,0.00,2457.40,0.00,'2022-10-11 09:55:14','',''),(1904,'1','281',NULL,1,'Sale Id shift 124',1985153.60,0.00,0.00,0.00,0.00,'2022-10-11 09:55:14','',''),(1905,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,7400000.00,40000.00,0.00,0.00,'2022-10-11 09:55:39','',''),(1906,'1','281','2',1,'Sale Id shift 125',0.00,0.00,0.00,4545.75,0.00,'2022-10-11 15:03:02','',''),(1907,'1','281','1',1,'Sale Id shift 125',0.00,0.00,0.00,4801.10,0.00,'2022-10-11 15:03:02','',''),(1908,'1','281','1',1,'Sale Id shift 125',0.00,0.00,0.00,354.76,0.00,'2022-10-11 15:03:02','',''),(1909,'1','281','1',1,'Sale Id shift 125',0.00,0.00,0.00,4899.04,0.00,'2022-10-11 15:03:02','',''),(1910,'1','281','2',1,'Sale Id shift 125',0.00,0.00,0.00,453.30,0.00,'2022-10-11 15:03:02','',''),(1911,'1','281',NULL,1,'Sale Id shift 125',2784980.75,0.00,0.00,0.00,0.00,'2022-10-11 15:03:02','',''),(1912,'1','281',NULL,1,'Reception corrector for bridging 154',0.00,0.00,0.00,25000.00,0.00,'2022-10-11 17:19:53','',''),(1913,'1','281','1',1,'Received from bridging 154',0.00,0.00,25000.00,0.00,0.00,'2022-10-11 17:19:53','',''),(1914,'1','281',NULL,1,'Reception corrector for bridging 155',0.00,0.00,0.00,15000.00,0.00,'2022-10-11 17:20:22','',''),(1915,'1','281','2',1,'Received from bridging 155',0.00,0.00,15000.00,0.00,0.00,'2022-10-11 17:20:22','',''),(1916,'1','281','1',1,'Sale Id shift 126',0.00,0.00,0.00,3249.31,0.00,'2022-10-11 20:03:47','',''),(1917,'1','281','2',1,'Sale Id shift 126',0.00,0.00,0.00,4400.04,0.00,'2022-10-11 20:03:47','',''),(1918,'1','281','1',1,'Sale Id shift 126',0.00,0.00,0.00,4134.36,0.00,'2022-10-11 20:03:47','',''),(1919,'1','281','1',1,'Sale Id shift 126',0.00,0.00,0.00,5608.70,0.00,'2022-10-11 20:03:47','',''),(1920,'1','281','2',1,'Sale Id shift 126',0.00,0.00,0.00,3485.82,0.00,'2022-10-11 20:03:47','',''),(1921,'1','281',NULL,1,'Sale Id shift 126',3862472.55,0.00,0.00,0.00,0.00,'2022-10-11 20:03:47','',''),(1922,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,7400000.00,40000.00,0.00,0.00,'2022-10-12 07:59:02','',''),(1923,'1','281',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,16300000.00,20000.00,0.00,0.00,'2022-10-12 12:34:16','',''),(1924,'1','281',NULL,1,'Reception corrector for bridging 156',0.00,0.00,0.00,20000.00,0.00,'2022-10-12 12:38:56','',''),(1925,'1','281','1',1,'Received from bridging 156',0.00,0.00,20000.00,0.00,0.00,'2022-10-12 12:38:56','',''),(1926,'1','281',NULL,1,'Reception corrector for bridging 157',0.00,0.00,0.00,20000.00,0.00,'2022-10-12 12:39:16','',''),(1927,'1','281','2',1,'Received from bridging 157',0.00,0.00,20000.00,0.00,0.00,'2022-10-12 12:39:16','',''),(1928,'1','281',NULL,2,'Reception corrector for bridging 158',0.00,0.00,0.00,20000.00,0.00,'2022-10-12 12:40:45','',''),(1929,'1','281','3',2,'Received from bridging 158',0.00,0.00,20000.00,0.00,0.00,'2022-10-12 12:40:45','',''),(1930,'1','281','2',1,'Sale Id shift 127',0.00,0.00,0.00,1350.91,0.00,'2022-10-12 15:02:48','',''),(1931,'1','281','2',1,'Sale Id shift 127',0.00,0.00,0.00,2505.67,0.00,'2022-10-12 15:02:48','',''),(1932,'1','281','2',1,'Sale Id shift 127',0.00,0.00,0.00,4048.60,0.00,'2022-10-12 15:02:48','',''),(1933,'1','281','1',1,'Sale Id shift 127',0.00,0.00,0.00,1430.41,0.00,'2022-10-12 15:02:48','',''),(1934,'1','281','1',1,'Sale Id shift 127',0.00,0.00,0.00,2355.13,0.00,'2022-10-12 15:02:48','',''),(1935,'1','281','1',1,'Sale Id shift 127',0.00,0.00,0.00,3877.22,0.00,'2022-10-12 15:02:48','',''),(1936,'1','281','1',1,'Sale Id shift 127',0.00,0.00,0.00,1451.92,0.00,'2022-10-12 15:02:48','',''),(1937,'1','281','2',1,'Sale Id shift 127',0.00,0.00,0.00,4308.18,0.00,'2022-10-12 15:02:48','',''),(1938,'1','281',NULL,1,'Sale Id shift 127',3945687.40,0.00,0.00,0.00,0.00,'2022-10-12 15:02:48','',''),(1939,'1','281','3',2,'Sale Id shift 128',0.00,0.00,0.00,384.98,0.00,'2022-10-12 19:16:32','',''),(1940,'1','281',NULL,2,'Sale Id shift 128',313758.70,0.00,0.00,0.00,0.00,'2022-10-12 19:16:32','',''),(1941,'1','281','2',1,'Sale Id shift 129',0.00,0.00,0.00,4387.65,0.00,'2022-10-13 08:46:39','',''),(1942,'1','281','2',1,'Sale Id shift 129',0.00,0.00,0.00,4607.08,0.00,'2022-10-13 08:46:39','',''),(1943,'1','281','3',2,'Sale Id shift 129',0.00,0.00,0.00,10.04,0.00,'2022-10-13 08:46:39','',''),(1944,'1','281','1',1,'Sale Id shift 129',0.00,0.00,0.00,4477.35,0.00,'2022-10-13 08:46:39','',''),(1945,'1','281','1',1,'Sale Id shift 129',0.00,0.00,0.00,4635.63,0.00,'2022-10-13 08:46:39','',''),(1946,'1','281','2',1,'Sale Id shift 129',0.00,0.00,0.00,4769.41,0.00,'2022-10-13 08:46:39','',''),(1947,'1','281',NULL,2,'Sale Id shift 129',8333.20,0.00,0.00,0.00,0.00,'2022-10-13 08:46:39','',''),(1948,'1','281',NULL,1,'Sale Id shift 129',4232267.20,0.00,0.00,0.00,0.00,'2022-10-13 08:46:39','',''),(1949,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,7400000.00,40000.00,0.00,0.00,'2022-10-13 12:13:44','',''),(1950,'1','281',NULL,1,'Reception corrector for bridging 160',0.00,0.00,0.00,20000.00,0.00,'2022-10-13 14:15:29','',''),(1951,'1','281','2',1,'Received from bridging 160',0.00,0.00,20000.00,0.00,0.00,'2022-10-13 14:15:29','',''),(1952,'1','281',NULL,1,'Reception corrector for bridging 159',0.00,0.00,0.00,20000.00,0.00,'2022-10-13 14:15:43','',''),(1953,'1','281','1',1,'Received from bridging 159',0.00,0.00,20000.00,0.00,0.00,'2022-10-13 14:15:43','',''),(1954,'1','281','1',1,'Sale Id shift 130',0.00,0.00,0.00,3213.70,0.00,'2022-10-13 19:12:47','',''),(1955,'1','281','2',1,'Sale Id shift 130',0.00,0.00,0.00,3417.38,0.00,'2022-10-13 19:12:47','',''),(1956,'1','281','3',2,'Sale Id shift 130',0.00,0.00,0.00,1386.43,0.00,'2022-10-13 19:12:47','',''),(1957,'1','281','3',2,'Sale Id shift 130',0.00,0.00,0.00,49.39,0.00,'2022-10-13 19:12:47','',''),(1958,'1','281','1',1,'Sale Id shift 130',0.00,0.00,0.00,2578.45,0.00,'2022-10-13 19:12:47','',''),(1959,'1','281','1',1,'Sale Id shift 130',0.00,0.00,0.00,2472.90,0.00,'2022-10-13 19:12:47','',''),(1960,'1','281','1',1,'Sale Id shift 130',0.00,0.00,0.00,6274.59,0.00,'2022-10-13 19:12:47','',''),(1961,'1','281','2',1,'Sale Id shift 130',0.00,0.00,0.00,3589.71,0.00,'2022-10-13 19:12:47','',''),(1962,'1','281',NULL,2,'Sale Id shift 130',1191730.60,0.00,0.00,0.00,0.00,'2022-10-13 19:12:47','',''),(1963,'1','281',NULL,1,'Sale Id shift 130',3986145.05,0.00,0.00,0.00,0.00,'2022-10-13 19:12:47','',''),(1964,'1','281','1',1,'Sale Id shift 131',0.00,0.00,0.00,3036.86,0.00,'2022-10-14 08:17:42','',''),(1965,'1','281','2',1,'Sale Id shift 131',0.00,0.00,0.00,3526.52,0.00,'2022-10-14 08:17:42','',''),(1966,'1','281','3',2,'Sale Id shift 131',0.00,0.00,0.00,402.15,0.00,'2022-10-14 08:17:42','',''),(1967,'1','281','1',1,'Sale Id shift 131',0.00,0.00,0.00,2697.53,0.00,'2022-10-14 08:17:42','',''),(1968,'1','281','1',1,'Sale Id shift 131',0.00,0.00,0.00,3198.43,0.00,'2022-10-14 08:17:42','',''),(1969,'1','281','1',1,'Sale Id shift 131',0.00,0.00,0.00,3186.26,0.00,'2022-10-14 08:17:42','',''),(1970,'1','281','2',1,'Sale Id shift 131',0.00,0.00,0.00,2592.08,0.00,'2022-10-14 08:17:42','',''),(1971,'1','281',NULL,2,'Sale Id shift 131',333784.50,0.00,0.00,0.00,0.00,'2022-10-14 08:17:42','',''),(1972,'1','281',NULL,1,'Sale Id shift 131',3373970.80,0.00,0.00,0.00,0.00,'2022-10-14 08:17:42','',''),(1973,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,7455500.00,40300.00,0.00,0.00,'2022-10-14 10:23:06','',''),(1974,'1','281',NULL,1,'Reception corrector for bridging 162',0.00,0.00,0.00,20000.00,0.00,'2022-10-14 10:55:38','',''),(1975,'1','281','2',1,'Received from bridging 162',0.00,0.00,20000.00,0.00,0.00,'2022-10-14 10:55:38','',''),(1976,'1','281',NULL,1,'Reception corrector for bridging 161',0.00,0.00,0.00,20300.00,0.00,'2022-10-14 10:56:02','',''),(1977,'1','281','1',1,'Received from bridging 161',0.00,0.00,20300.00,0.00,0.00,'2022-10-14 10:56:02','',''),(1978,'1','281','2',1,'Sale Id shift 132',0.00,0.00,0.00,4357.01,0.00,'2022-10-14 15:08:40','',''),(1979,'1','281','2',1,'Sale Id shift 132',0.00,0.00,0.00,4171.77,0.00,'2022-10-14 15:08:40','',''),(1980,'1','281','3',2,'Sale Id shift 132',0.00,0.00,0.00,265.29,0.00,'2022-10-14 15:08:40','',''),(1981,'1','281','3',2,'Sale Id shift 132',0.00,0.00,0.00,381.87,0.00,'2022-10-14 15:08:40','',''),(1982,'1','281','1',1,'Sale Id shift 132',0.00,0.00,0.00,3955.67,0.00,'2022-10-14 15:08:40','',''),(1983,'1','281','1',1,'Sale Id shift 132',0.00,0.00,0.00,3062.49,0.00,'2022-10-14 15:08:40','',''),(1984,'1','281','2',1,'Sale Id shift 132',0.00,0.00,0.00,4390.40,0.00,'2022-10-14 15:08:40','',''),(1985,'1','281',NULL,2,'Sale Id shift 132',537142.80,0.00,0.00,0.00,0.00,'2022-10-14 15:08:40','',''),(1986,'1','281',NULL,1,'Sale Id shift 132',3688407.90,0.00,0.00,0.00,0.00,'2022-10-14 15:08:40','',''),(1987,'1','281','2',1,'Sale Id shift 133',0.00,0.00,0.00,3856.77,0.00,'2022-10-15 12:10:16','',''),(1988,'1','281','2',1,'Sale Id shift 133',0.00,0.00,0.00,3320.10,0.00,'2022-10-15 12:10:16','',''),(1989,'1','281','3',2,'Sale Id shift 133',0.00,0.00,0.00,720.89,0.00,'2022-10-15 12:10:16','',''),(1990,'1','281','1',1,'Sale Id shift 133',0.00,0.00,0.00,4119.61,0.00,'2022-10-15 12:10:16','',''),(1991,'1','281','1',1,'Sale Id shift 133',0.00,0.00,0.00,4597.39,0.00,'2022-10-15 12:10:16','',''),(1992,'1','281','2',1,'Sale Id shift 133',0.00,0.00,0.00,4653.97,0.00,'2022-10-15 12:10:16','',''),(1993,'1','281',NULL,2,'Sale Id shift 133',598338.70,0.00,0.00,0.00,0.00,'2022-10-15 12:10:16','',''),(1994,'1','281',NULL,1,'Sale Id shift 133',3801350.40,0.00,0.00,0.00,0.00,'2022-10-15 12:10:16','',''),(1995,'1','281','1',1,'Sale Id shift 134',0.00,0.00,0.00,1111.75,0.00,'2022-10-15 14:36:04','',''),(1996,'1','281','2',1,'Sale Id shift 134',0.00,0.00,0.00,818.85,0.00,'2022-10-15 14:36:04','',''),(1997,'1','281','2',1,'Sale Id shift 134',0.00,0.00,0.00,2549.27,0.00,'2022-10-15 14:36:04','',''),(1998,'1','281','2',1,'Sale Id shift 134',0.00,0.00,0.00,4583.11,0.00,'2022-10-15 14:36:04','',''),(1999,'1','281','3',2,'Sale Id shift 134',0.00,0.00,0.00,1288.37,0.00,'2022-10-15 14:36:04','',''),(2000,'1','281','3',2,'Sale Id shift 134',0.00,0.00,0.00,159.24,0.00,'2022-10-15 14:36:04','',''),(2001,'1','281','1',1,'Sale Id shift 134',0.00,0.00,0.00,4626.01,0.00,'2022-10-15 14:36:04','',''),(2002,'1','281','1',1,'Sale Id shift 134',0.00,0.00,0.00,862.51,0.00,'2022-10-15 14:36:04','',''),(2003,'1','281','1',1,'Sale Id shift 134',0.00,0.00,0.00,804.34,0.00,'2022-10-15 14:36:04','',''),(2004,'1','281','1',1,'Sale Id shift 134',0.00,0.00,0.00,974.31,0.00,'2022-10-15 14:36:04','',''),(2005,'1','281','1',1,'Sale Id shift 134',0.00,0.00,0.00,4457.93,0.00,'2022-10-15 14:36:04','',''),(2006,'1','281','2',1,'Sale Id shift 134',0.00,0.00,0.00,5375.19,0.00,'2022-10-15 14:36:04','',''),(2007,'1','281','2',1,'Sale Id shift 134',0.00,0.00,0.00,896.98,0.00,'2022-10-15 14:36:04','',''),(2008,'1','281',NULL,2,'Sale Id shift 134',1201516.30,0.00,0.00,0.00,0.00,'2022-10-15 14:36:04','',''),(2009,'1','281',NULL,1,'Sale Id shift 134',5006146.25,0.00,0.00,0.00,0.00,'2022-10-15 14:36:04','',''),(2010,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-10-15 14:37:08','',''),(2011,'1','281',NULL,1,'Reception corrector for bridging 163',0.00,0.00,0.00,20000.00,0.00,'2022-10-15 15:30:18','',''),(2012,'1','281','1',1,'Received from bridging 163',0.00,0.00,20000.00,0.00,0.00,'2022-10-15 15:30:18','',''),(2013,'1','281',NULL,1,'Reception corrector for bridging 164',0.00,0.00,0.00,25000.00,0.00,'2022-10-15 15:30:38','',''),(2014,'1','281','2',1,'Received from bridging 164',0.00,0.00,25000.00,0.00,0.00,'2022-10-15 15:30:38','',''),(2015,'1','281','2',1,'Sale Id shift 135',0.00,0.00,0.00,3544.31,0.00,'2022-10-16 10:42:05','',''),(2016,'1','281','2',1,'Sale Id shift 135',0.00,0.00,0.00,403.78,0.00,'2022-10-16 10:42:05','',''),(2017,'1','281','3',2,'Sale Id shift 135',0.00,0.00,0.00,4189.36,0.00,'2022-10-16 10:42:05','',''),(2018,'1','281','3',2,'Sale Id shift 135',0.00,0.00,0.00,170.12,0.00,'2022-10-16 10:42:05','',''),(2019,'1','281','1',1,'Sale Id shift 135',0.00,0.00,0.00,4931.82,0.00,'2022-10-16 10:42:05','',''),(2020,'1','281','1',1,'Sale Id shift 135',0.00,0.00,0.00,4956.82,0.00,'2022-10-16 10:42:05','',''),(2021,'1','281','2',1,'Sale Id shift 135',0.00,0.00,0.00,444.11,0.00,'2022-10-16 10:42:05','',''),(2022,'1','281','2',1,'Sale Id shift 135',0.00,0.00,0.00,3492.26,0.00,'2022-10-16 10:42:05','',''),(2023,'1','281',NULL,2,'Sale Id shift 135',3618368.40,0.00,0.00,0.00,0.00,'2022-10-16 10:42:05','',''),(2024,'1','281',NULL,1,'Sale Id shift 135',3288023.50,0.00,0.00,0.00,0.00,'2022-10-16 10:42:05','',''),(2025,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8232500.00,44500.00,0.00,0.00,'2022-10-16 10:43:17','',''),(2026,'1','281',NULL,1,'Reception corrector for bridging 165',0.00,0.00,0.00,25000.00,0.00,'2022-10-16 14:24:28','',''),(2027,'1','281','1',1,'Received from bridging 165',0.00,0.00,25000.00,0.00,0.00,'2022-10-16 14:24:28','',''),(2028,'1','281',NULL,1,'Reception corrector for bridging 166',0.00,0.00,0.00,19500.00,0.00,'2022-10-16 14:25:00','',''),(2029,'1','281','2',1,'Received from bridging 166',0.00,0.00,19500.00,0.00,0.00,'2022-10-16 14:25:00','',''),(2030,'1','281','2',1,'Sale Id shift 136',0.00,0.00,0.00,3577.82,0.00,'2022-10-16 15:22:29','',''),(2031,'1','281','3',2,'Sale Id shift 136',0.00,0.00,0.00,2.22,0.00,'2022-10-16 15:22:29','',''),(2032,'1','281','3',2,'Sale Id shift 136',0.00,0.00,0.00,9.65,0.00,'2022-10-16 15:22:29','',''),(2033,'1','281','1',1,'Sale Id shift 136',0.00,0.00,0.00,3757.66,0.00,'2022-10-16 15:22:29','',''),(2034,'1','281','1',1,'Sale Id shift 136',0.00,0.00,0.00,3815.98,0.00,'2022-10-16 15:22:29','',''),(2035,'1','281','2',1,'Sale Id shift 136',0.00,0.00,0.00,3530.24,0.00,'2022-10-16 15:22:29','',''),(2036,'1','281',NULL,2,'Sale Id shift 136',9852.10,0.00,0.00,0.00,0.00,'2022-10-16 15:22:29','',''),(2037,'1','281',NULL,1,'Sale Id shift 136',2716114.50,0.00,0.00,0.00,0.00,'2022-10-16 15:22:29','',''),(2038,'1','281','2',1,'Sale Id shift 137',0.00,0.00,0.00,4913.73,0.00,'2022-10-17 08:00:50','',''),(2039,'1','281','3',2,'Sale Id shift 137',0.00,0.00,0.00,70.95,0.00,'2022-10-17 08:00:50','',''),(2040,'1','281','3',2,'Sale Id shift 137',0.00,0.00,0.00,65.06,0.00,'2022-10-17 08:00:50','',''),(2041,'1','281','1',1,'Sale Id shift 137',0.00,0.00,0.00,3749.74,0.00,'2022-10-17 08:00:50','',''),(2042,'1','281','1',1,'Sale Id shift 137',0.00,0.00,0.00,3730.02,0.00,'2022-10-17 08:00:50','',''),(2043,'1','281','2',1,'Sale Id shift 137',0.00,0.00,0.00,4885.25,0.00,'2022-10-17 08:00:50','',''),(2044,'1','281',NULL,2,'Sale Id shift 137',112888.30,0.00,0.00,0.00,0.00,'2022-10-17 08:00:50','',''),(2045,'1','281',NULL,1,'Sale Id shift 137',3196566.90,0.00,0.00,0.00,0.00,'2022-10-17 08:00:50','',''),(2046,'1','281','2',1,'Sale Id shift 138',0.00,0.00,0.00,2222.23,0.00,'2022-10-17 20:27:37','',''),(2047,'1','281','2',1,'Sale Id shift 138',0.00,0.00,0.00,3142.07,0.00,'2022-10-17 20:27:37','',''),(2048,'1','281','3',2,'Sale Id shift 138',0.00,0.00,0.00,93.72,0.00,'2022-10-17 20:27:37','',''),(2049,'1','281','1',1,'Sale Id shift 138',0.00,0.00,0.00,1146.32,0.00,'2022-10-17 20:27:37','',''),(2050,'1','281','1',1,'Sale Id shift 138',0.00,0.00,0.00,3074.15,0.00,'2022-10-17 20:27:37','',''),(2051,'1','281','2',1,'Sale Id shift 138',0.00,0.00,0.00,3184.77,0.00,'2022-10-17 20:27:37','',''),(2052,'1','281',NULL,2,'Sale Id shift 138',77787.60,0.00,0.00,0.00,0.00,'2022-10-17 20:27:37','',''),(2053,'1','281',NULL,1,'Sale Id shift 138',2362364.90,0.00,0.00,0.00,0.00,'2022-10-17 20:27:37','',''),(2054,'1','281','3',2,'Sale Id shift 139',0.00,0.00,0.00,240.62,0.00,'2022-10-18 07:50:10','',''),(2055,'1','281','3',2,'Sale Id shift 139',0.00,0.00,0.00,1.02,0.00,'2022-10-18 07:50:10','',''),(2056,'1','281',NULL,2,'Sale Id shift 139',200561.20,0.00,0.00,0.00,0.00,'2022-10-18 07:50:10','',''),(2057,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9250000.00,50000.00,0.00,0.00,'2022-10-18 07:51:01','',''),(2058,'1','281',NULL,1,'Reception corrector for bridging 167',0.00,0.00,0.00,17000.00,0.00,'2022-10-18 09:17:57','',''),(2059,'1','281','1',1,'Received from bridging 167',0.00,0.00,17000.00,0.00,0.00,'2022-10-18 09:17:57','',''),(2060,'1','281',NULL,1,'Reception corrector for bridging 168',0.00,0.00,0.00,33000.00,0.00,'2022-10-18 09:18:17','',''),(2061,'1','281','2',1,'Received from bridging 168',0.00,0.00,33000.00,0.00,0.00,'2022-10-18 09:18:17','',''),(2062,'1','281','2',1,'Sale Id shift 140',0.00,0.00,0.00,2705.49,0.00,'2022-10-18 15:42:53','',''),(2063,'1','281','2',1,'Sale Id shift 140',0.00,0.00,0.00,2785.91,0.00,'2022-10-18 15:42:53','',''),(2064,'1','281','3',2,'Sale Id shift 140',0.00,0.00,0.00,2198.66,0.00,'2022-10-18 15:42:53','',''),(2065,'1','281','3',2,'Sale Id shift 140',0.00,0.00,0.00,10.86,0.00,'2022-10-18 15:42:53','',''),(2066,'1','281','1',1,'Sale Id shift 140',0.00,0.00,0.00,3901.32,0.00,'2022-10-18 15:42:53','',''),(2067,'1','281','1',1,'Sale Id shift 140',0.00,0.00,0.00,1143.45,0.00,'2022-10-18 15:42:53','',''),(2068,'1','281','1',1,'Sale Id shift 140',0.00,0.00,0.00,3858.68,0.00,'2022-10-18 15:42:53','',''),(2069,'1','281','2',1,'Sale Id shift 140',0.00,0.00,0.00,3541.64,0.00,'2022-10-18 15:42:53','',''),(2070,'1','281',NULL,2,'Sale Id shift 140',1833901.60,0.00,0.00,0.00,0.00,'2022-10-18 15:42:53','',''),(2071,'1','281',NULL,1,'Sale Id shift 140',3318250.65,0.00,0.00,0.00,0.00,'2022-10-18 15:42:53','',''),(2072,'1','281','2',1,'Sale Id shift 141',0.00,0.00,0.00,3003.25,0.00,'2022-10-19 07:48:43','',''),(2073,'1','281','2',1,'Sale Id shift 141',0.00,0.00,0.00,767.98,0.00,'2022-10-19 07:48:43','',''),(2074,'1','281','2',1,'Sale Id shift 141',0.00,0.00,0.00,1510.73,0.00,'2022-10-19 07:48:43','',''),(2075,'1','281','3',2,'Sale Id shift 141',0.00,0.00,0.00,4471.55,0.00,'2022-10-19 07:48:43','',''),(2076,'1','281','3',2,'Sale Id shift 141',0.00,0.00,0.00,83.92,0.00,'2022-10-19 07:48:43','',''),(2077,'1','281','1',1,'Sale Id shift 141',0.00,0.00,0.00,4863.50,0.00,'2022-10-19 07:48:43','',''),(2078,'1','281','1',1,'Sale Id shift 141',0.00,0.00,0.00,951.89,0.00,'2022-10-19 07:48:43','',''),(2079,'1','281','1',1,'Sale Id shift 141',0.00,0.00,0.00,4925.22,0.00,'2022-10-19 07:48:43','',''),(2080,'1','281','1',1,'Sale Id shift 141',0.00,0.00,0.00,3536.26,0.00,'2022-10-19 07:48:43','',''),(2081,'1','281','2',1,'Sale Id shift 141',0.00,0.00,0.00,1214.18,0.00,'2022-10-19 07:48:43','',''),(2082,'1','281','2',1,'Sale Id shift 141',0.00,0.00,0.00,2615.82,0.00,'2022-10-19 07:48:43','',''),(2083,'1','281',NULL,2,'Sale Id shift 141',3781040.10,0.00,0.00,0.00,0.00,'2022-10-19 07:48:43','',''),(2084,'1','281',NULL,1,'Sale Id shift 141',4326933.55,0.00,0.00,0.00,0.00,'2022-10-19 07:48:43','',''),(2085,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,5587000.00,30200.00,0.00,0.00,'2022-10-19 07:49:15','',''),(2086,'1','281',NULL,1,'Reception corrector for bridging 169',0.00,0.00,0.00,20000.00,0.00,'2022-10-19 07:55:25','',''),(2087,'1','281','1',1,'Received from bridging 169',0.00,0.00,20000.00,0.00,0.00,'2022-10-19 07:55:25','',''),(2088,'1','281',NULL,1,'Reception corrector for bridging 170',0.00,0.00,0.00,10200.00,0.00,'2022-10-19 07:55:53','',''),(2089,'1','281','2',1,'Received from bridging 170',0.00,0.00,10200.00,0.00,0.00,'2022-10-19 07:55:53','',''),(2090,'1','281','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,3465.90,0.00,'2022-10-19 14:10:40','',''),(2091,'1','281','3',0,'Inventory adjustment from tank dipping to 3900',0.00,0.00,3900.00,0.00,0.00,'2022-10-19 14:10:40','',''),(2092,'1','281','2',1,'Sale Id shift 142',0.00,0.00,0.00,1181.31,0.00,'2022-10-19 15:29:03','',''),(2093,'1','281','2',1,'Sale Id shift 142',0.00,0.00,0.00,867.76,0.00,'2022-10-19 15:29:03','',''),(2094,'1','281','2',1,'Sale Id shift 142',0.00,0.00,0.00,3926.91,0.00,'2022-10-19 15:29:03','',''),(2095,'1','281','3',2,'Sale Id shift 142',0.00,0.00,0.00,3467.12,0.00,'2022-10-19 15:29:03','',''),(2096,'1','281','3',2,'Sale Id shift 142',0.00,0.00,0.00,306.46,0.00,'2022-10-19 15:29:03','',''),(2097,'1','281','1',1,'Sale Id shift 142',0.00,0.00,0.00,2723.22,0.00,'2022-10-19 15:29:03','',''),(2098,'1','281','1',1,'Sale Id shift 142',0.00,0.00,0.00,1114.89,0.00,'2022-10-19 15:29:03','',''),(2099,'1','281','1',1,'Sale Id shift 142',0.00,0.00,0.00,2351.72,0.00,'2022-10-19 15:29:03','',''),(2100,'1','281','1',1,'Sale Id shift 142',0.00,0.00,0.00,2399.72,0.00,'2022-10-19 15:29:03','',''),(2101,'1','281','2',1,'Sale Id shift 142',0.00,0.00,0.00,3683.43,0.00,'2022-10-19 15:29:03','',''),(2102,'1','281',NULL,2,'Sale Id shift 142',3132071.40,0.00,0.00,0.00,0.00,'2022-10-19 15:29:03','',''),(2103,'1','281',NULL,1,'Sale Id shift 142',3376057.60,0.00,0.00,0.00,0.00,'2022-10-19 15:29:03','',''),(2104,'1','281','2',1,'Sale Id shift 143',0.00,0.00,0.00,4140.88,0.00,'2022-10-20 07:54:21','',''),(2105,'1','281','2',1,'Sale Id shift 143',0.00,0.00,0.00,4126.92,0.00,'2022-10-20 07:54:21','',''),(2106,'1','281','1',1,'Sale Id shift 143',0.00,0.00,0.00,3566.00,0.00,'2022-10-20 07:54:21','',''),(2107,'1','281','1',1,'Sale Id shift 143',0.00,0.00,0.00,4097.50,0.00,'2022-10-20 07:54:21','',''),(2108,'1','281','2',1,'Sale Id shift 143',0.00,0.00,0.00,4822.06,0.00,'2022-10-20 07:54:21','',''),(2109,'1','281',NULL,1,'Sale Id shift 143',3839371.60,0.00,0.00,0.00,0.00,'2022-10-20 07:54:21','',''),(2110,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8140000.00,44000.00,0.00,0.00,'2022-10-20 07:54:45','',''),(2111,'1','281',NULL,1,'Reception corrector for bridging 171',0.00,0.00,0.00,14000.00,0.00,'2022-10-20 08:27:29','',''),(2112,'1','281','1',1,'Received from bridging 171',0.00,0.00,14000.00,0.00,0.00,'2022-10-20 08:27:29','',''),(2113,'1','281',NULL,1,'Reception corrector for bridging 172',0.00,0.00,0.00,30000.00,0.00,'2022-10-20 08:28:27','',''),(2114,'1','281','2',1,'Received from bridging 172',0.00,0.00,30000.00,0.00,0.00,'2022-10-20 08:28:27','',''),(2115,'1','281','1',1,'Sale Id shift 144',0.00,0.00,0.00,3297.70,0.00,'2022-10-20 14:32:50','',''),(2116,'1','281','2',1,'Sale Id shift 144',0.00,0.00,0.00,2981.86,0.00,'2022-10-20 14:32:50','',''),(2117,'1','281','1',1,'Sale Id shift 144',0.00,0.00,0.00,3134.51,0.00,'2022-10-20 14:32:50','',''),(2118,'1','281','1',1,'Sale Id shift 144',0.00,0.00,0.00,3679.35,0.00,'2022-10-20 14:32:50','',''),(2119,'1','281','1',1,'Sale Id shift 144',0.00,0.00,0.00,3237.62,0.00,'2022-10-20 14:32:50','',''),(2120,'1','281','2',1,'Sale Id shift 144',0.00,0.00,0.00,3418.53,0.00,'2022-10-20 14:32:50','',''),(2121,'1','281',NULL,1,'Sale Id shift 144',3653670.45,0.00,0.00,0.00,0.00,'2022-10-20 14:32:50','',''),(2122,'1','281',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,12574500.00,15150.00,0.00,0.00,'2022-10-20 16:09:23','',''),(2123,'1','281',NULL,2,'Reception corrector for bridging 173',0.00,0.00,0.00,15150.00,0.00,'2022-10-20 17:46:16','',''),(2124,'1','281','3',2,'Received from bridging 173',0.00,0.00,15150.00,0.00,0.00,'2022-10-20 17:46:16','',''),(2125,'1','281','1',1,'Sale Id shift 145',0.00,0.00,0.00,3154.67,0.00,'2022-10-21 07:22:03','',''),(2126,'1','281','2',1,'Sale Id shift 145',0.00,0.00,0.00,3366.82,0.00,'2022-10-21 07:22:03','',''),(2127,'1','281','3',2,'Sale Id shift 145',0.00,0.00,0.00,219.42,0.00,'2022-10-21 07:22:03','',''),(2128,'1','281','1',1,'Sale Id shift 145',0.00,0.00,0.00,3051.20,0.00,'2022-10-21 07:22:03','',''),(2129,'1','281','1',1,'Sale Id shift 145',0.00,0.00,0.00,3653.04,0.00,'2022-10-21 07:22:03','',''),(2130,'1','281','1',1,'Sale Id shift 145',0.00,0.00,0.00,3152.26,0.00,'2022-10-21 07:22:03','',''),(2131,'1','281','2',1,'Sale Id shift 145',0.00,0.00,0.00,3671.01,0.00,'2022-10-21 07:22:03','',''),(2132,'1','281',NULL,2,'Sale Id shift 145',182118.60,0.00,0.00,0.00,0.00,'2022-10-21 07:22:03','',''),(2133,'1','281',NULL,1,'Sale Id shift 145',3709065.00,0.00,0.00,0.00,0.00,'2022-10-21 07:22:03','',''),(2134,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3145000.00,17000.00,0.00,0.00,'2022-10-21 07:23:12','',''),(2135,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3330000.00,18000.00,0.00,0.00,'2022-10-21 09:26:23','',''),(2136,'1','281',NULL,1,'Reception corrector for bridging 174',0.00,0.00,0.00,17000.00,0.00,'2022-10-21 14:50:33','',''),(2137,'1','281','1',1,'Received from bridging 174',0.00,0.00,17000.00,0.00,0.00,'2022-10-21 14:50:33','',''),(2138,'1','281',NULL,1,'Reception corrector for bridging 175',0.00,0.00,0.00,4000.00,0.00,'2022-10-21 14:58:37','',''),(2139,'1','281','1',1,'Received from bridging 175',0.00,0.00,4000.00,0.00,0.00,'2022-10-21 14:58:37','',''),(2140,'1','281',NULL,1,'Reception corrector for bridging 176',0.00,0.00,0.00,14000.00,0.00,'2022-10-21 14:59:02','',''),(2141,'1','281','2',1,'Received from bridging 176',0.00,0.00,14000.00,0.00,0.00,'2022-10-21 14:59:02','',''),(2142,'1','281','1',1,'Sale Id shift 146',0.00,0.00,0.00,2330.66,0.00,'2022-10-21 15:10:40','',''),(2143,'1','281','2',1,'Sale Id shift 146',0.00,0.00,0.00,1546.20,0.00,'2022-10-21 15:10:40','',''),(2144,'1','281','2',1,'Sale Id shift 146',0.00,0.00,0.00,1733.27,0.00,'2022-10-21 15:10:40','',''),(2145,'1','281','2',1,'Sale Id shift 146',0.00,0.00,0.00,1423.18,0.00,'2022-10-21 15:10:40','',''),(2146,'1','281','3',2,'Sale Id shift 146',0.00,0.00,0.00,1267.80,0.00,'2022-10-21 15:10:40','',''),(2147,'1','281','3',2,'Sale Id shift 146',0.00,0.00,0.00,35.30,0.00,'2022-10-21 15:10:40','',''),(2148,'1','281','1',1,'Sale Id shift 146',0.00,0.00,0.00,1116.17,0.00,'2022-10-21 15:10:40','',''),(2149,'1','281','1',1,'Sale Id shift 146',0.00,0.00,0.00,1830.18,0.00,'2022-10-21 15:10:40','',''),(2150,'1','281','1',1,'Sale Id shift 146',0.00,0.00,0.00,1184.88,0.00,'2022-10-21 15:10:40','',''),(2151,'1','281','1',1,'Sale Id shift 146',0.00,0.00,0.00,3923.95,0.00,'2022-10-21 15:10:40','',''),(2152,'1','281','2',1,'Sale Id shift 146',0.00,0.00,0.00,3237.12,0.00,'2022-10-21 15:10:40','',''),(2153,'1','281','2',1,'Sale Id shift 146',0.00,0.00,0.00,1817.21,0.00,'2022-10-21 15:10:40','',''),(2154,'1','281',NULL,2,'Sale Id shift 146',1081573.00,0.00,0.00,0.00,0.00,'2022-10-21 15:10:40','',''),(2155,'1','281',NULL,1,'Sale Id shift 146',3726421.70,0.00,0.00,0.00,0.00,'2022-10-21 15:10:40','',''),(2156,'1','281','2',1,'Sale Id shift 147',0.00,0.00,0.00,3259.22,0.00,'2022-10-22 10:14:45','',''),(2157,'1','281','2',1,'Sale Id shift 147',0.00,0.00,0.00,2338.18,0.00,'2022-10-22 10:14:45','',''),(2158,'1','281','3',2,'Sale Id shift 147',0.00,0.00,0.00,302.91,0.00,'2022-10-22 10:14:45','',''),(2159,'1','281','3',2,'Sale Id shift 147',0.00,0.00,0.00,30.72,0.00,'2022-10-22 10:14:45','',''),(2160,'1','281','1',1,'Sale Id shift 147',0.00,0.00,0.00,4221.88,0.00,'2022-10-22 10:14:45','',''),(2161,'1','281','1',1,'Sale Id shift 147',0.00,0.00,0.00,2417.42,0.00,'2022-10-22 10:14:45','',''),(2162,'1','281','1',1,'Sale Id shift 147',0.00,0.00,0.00,453.57,0.00,'2022-10-22 10:14:45','',''),(2163,'1','281','1',1,'Sale Id shift 147',0.00,0.00,0.00,3238.43,0.00,'2022-10-22 10:14:45','',''),(2164,'1','281','2',1,'Sale Id shift 147',0.00,0.00,0.00,2788.04,0.00,'2022-10-22 10:14:45','',''),(2165,'1','281',NULL,2,'Sale Id shift 147',276912.90,0.00,0.00,0.00,0.00,'2022-10-22 10:14:45','',''),(2166,'1','281',NULL,1,'Sale Id shift 147',3462596.90,0.00,0.00,0.00,0.00,'2022-10-22 10:14:45','',''),(2167,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,5365000.00,29000.00,0.00,0.00,'2022-10-22 14:24:32','',''),(2168,'1','281',NULL,1,'Reception corrector for bridging 178',0.00,0.00,0.00,14000.00,0.00,'2022-10-22 14:27:13','',''),(2169,'1','281','2',1,'Received from bridging 178',0.00,0.00,14000.00,0.00,0.00,'2022-10-22 14:27:13','',''),(2170,'1','281',NULL,1,'Reception corrector for bridging 177',0.00,0.00,0.00,15000.00,0.00,'2022-10-22 14:27:43','',''),(2171,'1','281','1',1,'Received from bridging 177',0.00,0.00,15000.00,0.00,0.00,'2022-10-22 14:27:43','',''),(2172,'1','281','1',1,'Sale Id shift 148',0.00,0.00,0.00,2695.04,0.00,'2022-10-22 15:08:24','',''),(2173,'1','281','2',1,'Sale Id shift 148',0.00,0.00,0.00,3362.41,0.00,'2022-10-22 15:08:24','',''),(2174,'1','281','3',2,'Sale Id shift 148',0.00,0.00,0.00,1144.46,0.00,'2022-10-22 15:08:24','',''),(2175,'1','281','1',1,'Sale Id shift 148',0.00,0.00,0.00,2772.18,0.00,'2022-10-22 15:08:24','',''),(2176,'1','281','1',1,'Sale Id shift 148',0.00,0.00,0.00,3059.42,0.00,'2022-10-22 15:08:24','',''),(2177,'1','281','1',1,'Sale Id shift 148',0.00,0.00,0.00,3524.84,0.00,'2022-10-22 15:08:24','',''),(2178,'1','281','2',1,'Sale Id shift 148',0.00,0.00,0.00,3194.03,0.00,'2022-10-22 15:08:24','',''),(2179,'1','281',NULL,2,'Sale Id shift 148',949901.80,0.00,0.00,0.00,0.00,'2022-10-22 15:08:24','',''),(2180,'1','281',NULL,1,'Sale Id shift 148',3442465.20,0.00,0.00,0.00,0.00,'2022-10-22 15:08:24','',''),(2181,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9250000.00,50000.00,0.00,0.00,'2022-10-23 07:40:22','',''),(2182,'1','281','1',1,'Sale Id shift 149',0.00,0.00,0.00,1591.43,0.00,'2022-10-23 11:34:41','',''),(2183,'1','281','2',1,'Sale Id shift 149',0.00,0.00,0.00,1524.03,0.00,'2022-10-23 11:34:41','',''),(2184,'1','281','3',2,'Sale Id shift 149',0.00,0.00,0.00,1453.88,0.00,'2022-10-23 11:34:41','',''),(2185,'1','281','1',1,'Sale Id shift 149',0.00,0.00,0.00,1619.70,0.00,'2022-10-23 11:34:41','',''),(2186,'1','281','1',1,'Sale Id shift 149',0.00,0.00,0.00,1596.31,0.00,'2022-10-23 11:34:41','',''),(2187,'1','281','1',1,'Sale Id shift 149',0.00,0.00,0.00,1719.26,0.00,'2022-10-23 11:34:41','',''),(2188,'1','281','2',1,'Sale Id shift 149',0.00,0.00,0.00,2520.45,0.00,'2022-10-23 11:34:41','',''),(2189,'1','281',NULL,2,'Sale Id shift 149',1206720.40,0.00,0.00,0.00,0.00,'2022-10-23 11:34:41','',''),(2190,'1','281',NULL,1,'Sale Id shift 149',1955668.30,0.00,0.00,0.00,0.00,'2022-10-23 11:34:41','',''),(2191,'1','281',NULL,1,'Reception corrector for bridging 179',0.00,0.00,0.00,35000.00,0.00,'2022-10-23 14:33:31','',''),(2192,'1','281','1',1,'Received from bridging 179',0.00,0.00,35000.00,0.00,0.00,'2022-10-23 14:33:31','',''),(2193,'1','281',NULL,1,'Reception corrector for bridging 180',0.00,0.00,0.00,15000.00,0.00,'2022-10-23 14:34:03','',''),(2194,'1','281','2',1,'Received from bridging 180',0.00,0.00,15000.00,0.00,0.00,'2022-10-23 14:34:03','',''),(2195,'1','281',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,12450000.00,15000.00,0.00,0.00,'2022-10-23 19:55:13','',''),(2196,'1','281','2',1,'Sale Id shift 150',0.00,0.00,0.00,3074.81,0.00,'2022-10-23 19:56:56','',''),(2197,'1','281','2',1,'Sale Id shift 150',0.00,0.00,0.00,3139.16,0.00,'2022-10-23 19:56:56','',''),(2198,'1','281','3',2,'Sale Id shift 150',0.00,0.00,0.00,122.70,0.00,'2022-10-23 19:56:56','',''),(2199,'1','281','3',2,'Sale Id shift 150',0.00,0.00,0.00,63.13,0.00,'2022-10-23 19:56:56','',''),(2200,'1','281','1',1,'Sale Id shift 150',0.00,0.00,0.00,2306.55,0.00,'2022-10-23 19:56:56','',''),(2201,'1','281','1',1,'Sale Id shift 150',0.00,0.00,0.00,3321.67,0.00,'2022-10-23 19:56:56','',''),(2202,'1','281','2',1,'Sale Id shift 150',0.00,0.00,0.00,1717.85,0.00,'2022-10-23 19:56:56','',''),(2203,'1','281','2',1,'Sale Id shift 150',0.00,0.00,0.00,2989.92,0.00,'2022-10-23 19:56:56','',''),(2204,'1','281',NULL,2,'Sale Id shift 150',154238.90,0.00,0.00,0.00,0.00,'2022-10-23 19:56:56','',''),(2205,'1','281',NULL,1,'Sale Id shift 150',3061742.60,0.00,0.00,0.00,0.00,'2022-10-23 19:56:56','',''),(2206,'1','281',NULL,2,'Reception corrector for bridging 181',0.00,0.00,0.00,15000.00,0.00,'2022-10-23 19:59:38','',''),(2207,'1','281','3',2,'Received from bridging 181',0.00,0.00,15000.00,0.00,0.00,'2022-10-23 19:59:38','',''),(2208,'1','281','3',2,'Sale Id shift 151',0.00,0.00,0.00,302.19,0.00,'2022-10-24 06:38:14','',''),(2209,'1','281','3',2,'Sale Id shift 151',0.00,0.00,0.00,88.08,0.00,'2022-10-24 06:38:14','',''),(2210,'1','281',NULL,2,'Sale Id shift 151',323924.10,0.00,0.00,0.00,0.00,'2022-10-24 06:38:14','',''),(2211,'1','281','1',1,'Sale Id shift 152',0.00,0.00,0.00,3403.16,0.00,'2022-10-24 15:33:41','',''),(2212,'1','281','2',1,'Sale Id shift 152',0.00,0.00,0.00,3282.00,0.00,'2022-10-24 15:33:41','',''),(2213,'1','281','3',2,'Sale Id shift 152',0.00,0.00,0.00,247.92,0.00,'2022-10-24 15:33:41','',''),(2214,'1','281','3',2,'Sale Id shift 152',0.00,0.00,0.00,96.22,0.00,'2022-10-24 15:33:41','',''),(2215,'1','281','1',1,'Sale Id shift 152',0.00,0.00,0.00,3208.57,0.00,'2022-10-24 15:33:41','',''),(2216,'1','281','1',1,'Sale Id shift 152',0.00,0.00,0.00,4465.90,0.00,'2022-10-24 15:33:41','',''),(2217,'1','281','1',1,'Sale Id shift 152',0.00,0.00,0.00,3314.26,0.00,'2022-10-24 15:33:41','',''),(2218,'1','281','2',1,'Sale Id shift 152',0.00,0.00,0.00,3654.94,0.00,'2022-10-24 15:33:41','',''),(2219,'1','281',NULL,2,'Sale Id shift 152',285636.20,0.00,0.00,0.00,0.00,'2022-10-24 15:33:41','',''),(2220,'1','281',NULL,1,'Sale Id shift 152',3945833.55,0.00,0.00,0.00,0.00,'2022-10-24 15:33:41','',''),(2221,'1','281','1',1,'Sale Id shift 153',0.00,0.00,0.00,2014.25,0.00,'2022-10-25 07:45:23','',''),(2222,'1','281','2',1,'Sale Id shift 153',0.00,0.00,0.00,1725.97,0.00,'2022-10-25 07:45:23','',''),(2223,'1','281','3',2,'Sale Id shift 153',0.00,0.00,0.00,1436.60,0.00,'2022-10-25 07:45:23','',''),(2224,'1','281','3',2,'Sale Id shift 153',0.00,0.00,0.00,1.45,0.00,'2022-10-25 07:45:23','',''),(2225,'1','281','1',1,'Sale Id shift 153',0.00,0.00,0.00,2003.02,0.00,'2022-10-25 07:45:23','',''),(2226,'1','281','1',1,'Sale Id shift 153',0.00,0.00,0.00,1855.64,0.00,'2022-10-25 07:45:23','',''),(2227,'1','281','1',1,'Sale Id shift 153',0.00,0.00,0.00,1902.38,0.00,'2022-10-25 07:45:23','',''),(2228,'1','281','2',1,'Sale Id shift 153',0.00,0.00,0.00,2013.32,0.00,'2022-10-25 07:45:23','',''),(2229,'1','281',NULL,2,'Sale Id shift 153',1193581.50,0.00,0.00,0.00,0.00,'2022-10-25 07:45:23','',''),(2230,'1','281',NULL,1,'Sale Id shift 153',2130197.30,0.00,0.00,0.00,0.00,'2022-10-25 07:45:23','',''),(2231,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,11100000.00,60000.00,0.00,0.00,'2022-10-25 13:05:41','',''),(2232,'1','281',NULL,1,'Reception corrector for bridging 183',0.00,0.00,0.00,20000.00,0.00,'2022-10-25 14:21:50','',''),(2233,'1','281','2',1,'Received from bridging 183',0.00,0.00,20000.00,0.00,0.00,'2022-10-25 14:21:50','',''),(2234,'1','281',NULL,1,'Reception corrector for bridging 182',0.00,0.00,0.00,30000.00,0.00,'2022-10-25 14:22:15','',''),(2235,'1','281','1',1,'Received from bridging 182',0.00,0.00,30000.00,0.00,0.00,'2022-10-25 14:22:15','',''),(2236,'1','281','1',1,'Sale Id shift 154',0.00,0.00,0.00,3497.80,0.00,'2022-10-25 17:24:51','',''),(2237,'1','281','2',1,'Sale Id shift 154',0.00,0.00,0.00,4070.44,0.00,'2022-10-25 17:24:51','',''),(2238,'1','281','3',2,'Sale Id shift 154',0.00,0.00,0.00,3643.67,0.00,'2022-10-25 17:24:51','',''),(2239,'1','281','3',2,'Sale Id shift 154',0.00,0.00,0.00,53.82,0.00,'2022-10-25 17:24:51','',''),(2240,'1','281','1',1,'Sale Id shift 154',0.00,0.00,0.00,3453.14,0.00,'2022-10-25 17:24:51','',''),(2241,'1','281','1',1,'Sale Id shift 154',0.00,0.00,0.00,4060.64,0.00,'2022-10-25 17:24:51','',''),(2242,'1','281','1',1,'Sale Id shift 154',0.00,0.00,0.00,7194.96,0.00,'2022-10-25 17:24:51','',''),(2243,'1','281','2',1,'Sale Id shift 154',0.00,0.00,0.00,3264.07,0.00,'2022-10-25 17:24:51','',''),(2244,'1','281',NULL,2,'Sale Id shift 154',3068916.70,0.00,0.00,0.00,0.00,'2022-10-25 17:24:51','',''),(2245,'1','281',NULL,1,'Sale Id shift 154',4725094.25,0.00,0.00,0.00,0.00,'2022-10-25 17:24:51','',''),(2246,'1','281',NULL,1,'Reception corrector for bridging 184',0.00,0.00,0.00,10000.00,0.00,'2022-10-26 05:55:38','',''),(2247,'1','281','1',1,'Received from bridging 184',0.00,0.00,10000.00,0.00,0.00,'2022-10-26 05:55:38','',''),(2248,'1','281','1',1,'Sale Id shift 155',0.00,0.00,0.00,1923.31,0.00,'2022-10-26 08:08:07','',''),(2249,'1','281','2',1,'Sale Id shift 155',0.00,0.00,0.00,2439.54,0.00,'2022-10-26 08:08:07','',''),(2250,'1','281','3',2,'Sale Id shift 155',0.00,0.00,0.00,271.11,0.00,'2022-10-26 08:08:07','',''),(2251,'1','281','3',2,'Sale Id shift 155',0.00,0.00,0.00,55.09,0.00,'2022-10-26 08:08:07','',''),(2252,'1','281','1',1,'Sale Id shift 155',0.00,0.00,0.00,2374.67,0.00,'2022-10-26 08:08:07','',''),(2253,'1','281','1',1,'Sale Id shift 155',0.00,0.00,0.00,298.78,0.00,'2022-10-26 08:08:07','',''),(2254,'1','281','1',1,'Sale Id shift 155',0.00,0.00,0.00,1771.07,0.00,'2022-10-26 08:08:07','',''),(2255,'1','281','1',1,'Sale Id shift 155',0.00,0.00,0.00,3482.43,0.00,'2022-10-26 08:08:07','',''),(2256,'1','281','2',1,'Sale Id shift 155',0.00,0.00,0.00,2207.14,0.00,'2022-10-26 08:08:07','',''),(2257,'1','281',NULL,2,'Sale Id shift 155',270746.00,0.00,0.00,0.00,0.00,'2022-10-26 08:08:07','',''),(2258,'1','281',NULL,1,'Sale Id shift 155',2681933.90,0.00,0.00,0.00,0.00,'2022-10-26 08:08:07','',''),(2259,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,8140000.00,44000.00,0.00,0.00,'2022-10-26 08:08:32','',''),(2260,'1','281','2',1,'Sale Id shift 157',0.00,0.00,0.00,4271.77,0.00,'2022-10-26 15:10:03','',''),(2261,'1','281','2',1,'Sale Id shift 157',0.00,0.00,0.00,4324.01,0.00,'2022-10-26 15:10:03','',''),(2262,'1','281','3',2,'Sale Id shift 157',0.00,0.00,0.00,955.81,0.00,'2022-10-26 15:10:03','',''),(2263,'1','281','3',2,'Sale Id shift 157',0.00,0.00,0.00,86.68,0.00,'2022-10-26 15:10:03','',''),(2264,'1','281','1',1,'Sale Id shift 157',0.00,0.00,0.00,4672.59,0.00,'2022-10-26 15:10:03','',''),(2265,'1','281','1',1,'Sale Id shift 157',0.00,0.00,0.00,3971.52,0.00,'2022-10-26 15:10:03','',''),(2266,'1','281','1',1,'Sale Id shift 157',0.00,0.00,0.00,5433.68,0.00,'2022-10-26 15:10:03','',''),(2267,'1','281','2',1,'Sale Id shift 157',0.00,0.00,0.00,4453.80,0.00,'2022-10-26 15:10:03','',''),(2268,'1','281',NULL,2,'Sale Id shift 157',865266.70,0.00,0.00,0.00,0.00,'2022-10-26 15:10:03','',''),(2269,'1','281',NULL,1,'Sale Id shift 157',5018563.45,0.00,0.00,0.00,0.00,'2022-10-26 15:10:03','',''),(2270,'1','281',NULL,1,'Reception corrector for bridging 185',0.00,0.00,0.00,27000.00,0.00,'2022-10-26 15:17:24','',''),(2271,'1','281','1',1,'Received from bridging 185',0.00,0.00,27000.00,0.00,0.00,'2022-10-26 15:17:24','',''),(2272,'1','281',NULL,1,'Reception corrector for bridging 186',0.00,0.00,0.00,17000.00,0.00,'2022-10-26 15:18:00','',''),(2273,'1','281','2',1,'Received from bridging 186',0.00,0.00,17000.00,0.00,0.00,'2022-10-26 15:18:00','',''),(2274,'1','281','2',1,'Sale Id shift 158',0.00,0.00,0.00,3967.20,0.00,'2022-10-27 07:34:16','',''),(2275,'1','281','2',1,'Sale Id shift 158',0.00,0.00,0.00,2409.44,0.00,'2022-10-27 07:34:16','',''),(2276,'1','281','3',2,'Sale Id shift 158',0.00,0.00,0.00,172.17,0.00,'2022-10-27 07:34:16','',''),(2277,'1','281','3',2,'Sale Id shift 158',0.00,0.00,0.00,20.48,0.00,'2022-10-27 07:34:16','',''),(2278,'1','281','1',1,'Sale Id shift 158',0.00,0.00,0.00,4222.65,0.00,'2022-10-27 07:34:16','',''),(2279,'1','281','1',1,'Sale Id shift 158',0.00,0.00,0.00,2378.41,0.00,'2022-10-27 07:34:16','',''),(2280,'1','281','1',1,'Sale Id shift 158',0.00,0.00,0.00,3741.53,0.00,'2022-10-27 07:34:16','',''),(2281,'1','281','2',1,'Sale Id shift 158',0.00,0.00,0.00,2375.56,0.00,'2022-10-27 07:34:16','',''),(2282,'1','281',NULL,2,'Sale Id shift 158',159899.50,0.00,0.00,0.00,0.00,'2022-10-27 07:34:16','',''),(2283,'1','281',NULL,1,'Sale Id shift 158',3532536.15,0.00,0.00,0.00,0.00,'2022-10-27 07:34:16','',''),(2284,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3154250.00,17050.00,0.00,0.00,'2022-10-27 09:32:22','',''),(2285,'1','281',NULL,1,'Reception corrector for bridging 187',0.00,0.00,0.00,13000.00,0.00,'2022-10-27 14:38:02','',''),(2286,'1','281','1',1,'Received from bridging 187',0.00,0.00,13000.00,0.00,0.00,'2022-10-27 14:38:02','',''),(2287,'1','281',NULL,1,'Reception corrector for bridging 188',0.00,0.00,0.00,4050.00,0.00,'2022-10-27 14:38:23','',''),(2288,'1','281','2',1,'Received from bridging 188',0.00,0.00,4050.00,0.00,0.00,'2022-10-27 14:38:23','',''),(2289,'1','281','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,38386.09,0.00,'2022-10-27 15:14:01','',''),(2290,'1','281','1',0,'Inventory adjustment from tank dipping to 42000',0.00,0.00,42000.00,0.00,0.00,'2022-10-27 15:14:01','',''),(2291,'1','281','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,31333.17,0.00,'2022-10-27 15:14:16','',''),(2292,'1','281','2',0,'Inventory adjustment from tank dipping to 42000',0.00,0.00,42000.00,0.00,0.00,'2022-10-27 15:14:16','',''),(2293,'1','281','2',1,'Sale Id shift 159',0.00,0.00,0.00,3841.98,0.00,'2022-10-27 15:46:44','',''),(2294,'1','281','2',1,'Sale Id shift 159',0.00,0.00,0.00,4024.45,0.00,'2022-10-27 15:46:44','',''),(2295,'1','281','3',2,'Sale Id shift 159',0.00,0.00,0.00,841.51,0.00,'2022-10-27 15:46:44','',''),(2296,'1','281','3',2,'Sale Id shift 159',0.00,0.00,0.00,101.67,0.00,'2022-10-27 15:46:44','',''),(2297,'1','281','1',1,'Sale Id shift 159',0.00,0.00,0.00,4190.62,0.00,'2022-10-27 15:46:44','',''),(2298,'1','281','1',1,'Sale Id shift 159',0.00,0.00,0.00,3294.19,0.00,'2022-10-27 15:46:44','',''),(2299,'1','281','1',1,'Sale Id shift 159',0.00,0.00,0.00,4165.79,0.00,'2022-10-27 15:46:44','',''),(2300,'1','281','2',1,'Sale Id shift 159',0.00,0.00,0.00,3958.53,0.00,'2022-10-27 15:46:44','',''),(2301,'1','281',NULL,2,'Sale Id shift 159',782839.40,0.00,0.00,0.00,0.00,'2022-10-27 15:46:44','',''),(2302,'1','281',NULL,1,'Sale Id shift 159',4342978.60,0.00,0.00,0.00,0.00,'2022-10-27 15:46:44','',''),(2303,'1','281','2',1,'Sale Id shift 160',0.00,0.00,0.00,1822.49,0.00,'2022-10-28 07:49:16','',''),(2304,'1','281','2',1,'Sale Id shift 160',0.00,0.00,0.00,1895.28,0.00,'2022-10-28 07:49:16','',''),(2305,'1','281','3',2,'Sale Id shift 160',0.00,0.00,0.00,1278.10,0.00,'2022-10-28 07:49:16','',''),(2306,'1','281','1',1,'Sale Id shift 160',0.00,0.00,0.00,1803.46,0.00,'2022-10-28 07:49:16','',''),(2307,'1','281','1',1,'Sale Id shift 160',0.00,0.00,0.00,180.28,0.00,'2022-10-28 07:49:16','',''),(2308,'1','281','1',1,'Sale Id shift 160',0.00,0.00,0.00,1922.64,0.00,'2022-10-28 07:49:16','',''),(2309,'1','281','1',1,'Sale Id shift 160',0.00,0.00,0.00,1963.35,0.00,'2022-10-28 07:49:16','',''),(2310,'1','281','2',1,'Sale Id shift 160',0.00,0.00,0.00,1847.36,0.00,'2022-10-28 07:49:16','',''),(2311,'1','281',NULL,2,'Sale Id shift 160',1060823.00,0.00,0.00,0.00,0.00,'2022-10-28 07:49:16','',''),(2312,'1','281',NULL,1,'Sale Id shift 160',2115449.10,0.00,0.00,0.00,0.00,'2022-10-28 07:49:16','',''),(2313,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,2960000.00,16000.00,0.00,0.00,'2022-10-28 11:07:10','',''),(2314,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,92500.00,500.00,0.00,0.00,'2022-10-28 11:11:19','',''),(2315,'1','281',NULL,1,'Reception corrector for bridging 189',0.00,0.00,0.00,500.00,0.00,'2022-10-28 11:55:13','',''),(2316,'1','281','1',1,'Received from bridging 189',0.00,0.00,500.00,0.00,0.00,'2022-10-28 11:55:13','',''),(2317,'1','281',NULL,1,'Reception corrector for bridging 190',0.00,0.00,0.00,8000.00,0.00,'2022-10-28 11:58:01','',''),(2318,'1','281','1',1,'Received from bridging 190',0.00,0.00,8000.00,0.00,0.00,'2022-10-28 11:58:01','',''),(2319,'1','281',NULL,1,'Reception corrector for bridging 191',0.00,0.00,0.00,8000.00,0.00,'2022-10-28 11:58:32','',''),(2320,'1','281','2',1,'Received from bridging 191',0.00,0.00,8000.00,0.00,0.00,'2022-10-28 11:58:32','',''),(2321,'1','281','2',1,'Sale Id shift 161',0.00,0.00,0.00,3095.38,0.00,'2022-10-28 16:20:22','',''),(2322,'1','281','2',1,'Sale Id shift 161',0.00,0.00,0.00,3563.13,0.00,'2022-10-28 16:20:22','',''),(2323,'1','281','3',2,'Sale Id shift 161',0.00,0.00,0.00,2259.04,0.00,'2022-10-28 16:20:22','',''),(2324,'1','281','3',2,'Sale Id shift 161',0.00,0.00,0.00,156.38,0.00,'2022-10-28 16:20:22','',''),(2325,'1','281','1',1,'Sale Id shift 161',0.00,0.00,0.00,1558.25,0.00,'2022-10-28 16:20:22','',''),(2326,'1','281','1',1,'Sale Id shift 161',0.00,0.00,0.00,3878.63,0.00,'2022-10-28 16:20:22','',''),(2327,'1','281','2',1,'Sale Id shift 161',0.00,0.00,0.00,4029.77,0.00,'2022-10-28 16:20:22','',''),(2328,'1','281',NULL,2,'Sale Id shift 161',2004798.60,0.00,0.00,0.00,0.00,'2022-10-28 16:20:22','',''),(2329,'1','281',NULL,1,'Sale Id shift 161',2983154.60,0.00,0.00,0.00,0.00,'2022-10-28 16:20:22','',''),(2330,'1','281','3',2,'Sale Id shift 162',0.00,0.00,0.00,203.92,0.00,'2022-10-29 07:59:03','',''),(2331,'1','281','3',2,'Sale Id shift 162',0.00,0.00,0.00,50.05,0.00,'2022-10-29 07:59:03','',''),(2332,'1','281',NULL,2,'Sale Id shift 162',210795.10,0.00,0.00,0.00,0.00,'2022-10-29 07:59:03','',''),(2333,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3237500.00,17500.00,0.00,0.00,'2022-10-29 12:42:11','',''),(2334,'1','281',NULL,1,'Reception corrector for bridging 192',0.00,0.00,0.00,17500.00,0.00,'2022-10-29 12:45:06','',''),(2335,'1','281','1',1,'Received from bridging 192',0.00,0.00,17500.00,0.00,0.00,'2022-10-29 12:45:06','',''),(2336,'1','281','2',1,'Sale Id shift 163',0.00,0.00,0.00,4399.64,0.00,'2022-10-29 15:03:00','',''),(2337,'1','281','2',1,'Sale Id shift 163',0.00,0.00,0.00,3294.58,0.00,'2022-10-29 15:03:00','',''),(2338,'1','281','3',2,'Sale Id shift 163',0.00,0.00,0.00,279.01,0.00,'2022-10-29 15:03:00','',''),(2339,'1','281','3',2,'Sale Id shift 163',0.00,0.00,0.00,84.64,0.00,'2022-10-29 15:03:00','',''),(2340,'1','281','1',1,'Sale Id shift 163',0.00,0.00,0.00,2459.37,0.00,'2022-10-29 15:03:00','',''),(2341,'1','281','1',1,'Sale Id shift 163',0.00,0.00,0.00,3530.09,0.00,'2022-10-29 15:03:00','',''),(2342,'1','281','2',1,'Sale Id shift 163',0.00,0.00,0.00,3768.01,0.00,'2022-10-29 15:03:00','',''),(2343,'1','281',NULL,2,'Sale Id shift 163',301829.50,0.00,0.00,0.00,0.00,'2022-10-29 15:03:00','',''),(2344,'1','281',NULL,1,'Sale Id shift 163',3228562.65,0.00,0.00,0.00,0.00,'2022-10-29 15:03:00','',''),(2345,'1','281','3',2,'Sale Id shift 164',0.00,0.00,0.00,152.81,0.00,'2022-10-30 08:10:16','',''),(2346,'1','281','3',2,'Sale Id shift 164',0.00,0.00,0.00,40.48,0.00,'2022-10-30 08:10:16','',''),(2347,'1','281',NULL,2,'Sale Id shift 164',160430.70,0.00,0.00,0.00,0.00,'2022-10-30 08:10:16','',''),(2348,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3700000.00,20000.00,0.00,0.00,'2022-10-30 10:47:02','',''),(2349,'1','281',NULL,1,'Reception corrector for bridging 195',0.00,0.00,0.00,20000.00,0.00,'2022-10-30 14:43:35','',''),(2350,'1','281','2',1,'Received from bridging 195',0.00,0.00,20000.00,0.00,0.00,'2022-10-30 14:43:35','',''),(2351,'1','281','2',1,'Sale Id shift 165',0.00,0.00,0.00,3351.22,0.00,'2022-10-30 16:06:34','',''),(2352,'1','281','2',1,'Sale Id shift 165',0.00,0.00,0.00,5017.80,0.00,'2022-10-30 16:06:34','',''),(2353,'1','281','3',2,'Sale Id shift 165',0.00,0.00,0.00,4.82,0.00,'2022-10-30 16:06:34','',''),(2354,'1','281','3',2,'Sale Id shift 165',0.00,0.00,0.00,28.32,0.00,'2022-10-30 16:06:34','',''),(2355,'1','281','1',1,'Sale Id shift 165',0.00,0.00,0.00,3490.61,0.00,'2022-10-30 16:06:34','',''),(2356,'1','281','1',1,'Sale Id shift 165',0.00,0.00,0.00,3749.31,0.00,'2022-10-30 16:06:34','',''),(2357,'1','281','2',1,'Sale Id shift 165',0.00,0.00,0.00,4458.22,0.00,'2022-10-30 16:06:34','',''),(2358,'1','281',NULL,2,'Sale Id shift 165',27506.20,0.00,0.00,0.00,0.00,'2022-10-30 16:06:34','',''),(2359,'1','281',NULL,1,'Sale Id shift 165',3712424.60,0.00,0.00,0.00,0.00,'2022-10-30 16:06:34','',''),(2360,'1','281','3',2,'Sale Id shift 166',0.00,0.00,0.00,1440.61,0.00,'2022-10-31 07:48:56','',''),(2361,'1','281','3',2,'Sale Id shift 166',0.00,0.00,0.00,41.70,0.00,'2022-10-31 07:48:56','',''),(2362,'1','281',NULL,2,'Sale Id shift 166',1230317.30,0.00,0.00,0.00,0.00,'2022-10-31 07:48:56','',''),(2363,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,7400000.00,40000.00,0.00,0.00,'2022-10-31 07:49:20','',''),(2364,'1','281',NULL,1,'Reception corrector for bridging 196',0.00,0.00,0.00,15000.00,0.00,'2022-10-31 10:57:25','',''),(2365,'1','281','1',1,'Received from bridging 196',0.00,0.00,15000.00,0.00,0.00,'2022-10-31 10:57:25','',''),(2366,'1','281',NULL,1,'Reception corrector for bridging 197',0.00,0.00,0.00,25000.00,0.00,'2022-10-31 10:57:45','',''),(2367,'1','281','2',1,'Received from bridging 197',0.00,0.00,25000.00,0.00,0.00,'2022-10-31 10:57:45','',''),(2368,'1','281','1',1,'Sale Id shift 167',0.00,0.00,0.00,3376.35,0.00,'2022-10-31 15:18:16','',''),(2369,'1','281','2',1,'Sale Id shift 167',0.00,0.00,0.00,3435.67,0.00,'2022-10-31 15:18:16','',''),(2370,'1','281','3',2,'Sale Id shift 167',0.00,0.00,0.00,893.40,0.00,'2022-10-31 15:18:16','',''),(2371,'1','281','3',2,'Sale Id shift 167',0.00,0.00,0.00,98.82,0.00,'2022-10-31 15:18:16','',''),(2372,'1','281','1',1,'Sale Id shift 167',0.00,0.00,0.00,3524.55,0.00,'2022-10-31 15:18:16','',''),(2373,'1','281','1',1,'Sale Id shift 167',0.00,0.00,0.00,2.75,0.00,'2022-10-31 15:18:16','',''),(2374,'1','281','1',1,'Sale Id shift 167',0.00,0.00,0.00,3390.35,0.00,'2022-10-31 15:18:16','',''),(2375,'1','281','1',1,'Sale Id shift 167',0.00,0.00,0.00,4328.72,0.00,'2022-10-31 15:18:16','',''),(2376,'1','281','2',1,'Sale Id shift 167',0.00,0.00,0.00,3514.40,0.00,'2022-10-31 15:18:16','',''),(2377,'1','281',NULL,2,'Sale Id shift 167',823542.60,0.00,0.00,0.00,0.00,'2022-10-31 15:18:16','',''),(2378,'1','281',NULL,1,'Sale Id shift 167',3990966.15,0.00,0.00,0.00,0.00,'2022-10-31 15:18:16','',''),(2379,'1','281','1',1,'Sale Id shift 168',0.00,0.00,0.00,2928.30,0.00,'2022-11-01 07:55:18','',''),(2380,'1','281','2',1,'Sale Id shift 168',0.00,0.00,0.00,3228.35,0.00,'2022-11-01 07:55:18','',''),(2381,'1','281','3',2,'Sale Id shift 168',0.00,0.00,0.00,1583.80,0.00,'2022-11-01 07:55:18','',''),(2382,'1','281','3',2,'Sale Id shift 168',0.00,0.00,0.00,523.87,0.00,'2022-11-01 07:55:18','',''),(2383,'1','281','1',1,'Sale Id shift 168',0.00,0.00,0.00,2728.49,0.00,'2022-11-01 07:55:18','',''),(2384,'1','281','1',1,'Sale Id shift 168',0.00,0.00,0.00,2663.02,0.00,'2022-11-01 07:55:18','',''),(2385,'1','281','1',1,'Sale Id shift 168',0.00,0.00,0.00,4103.43,0.00,'2022-11-01 07:55:18','',''),(2386,'1','281','2',1,'Sale Id shift 168',0.00,0.00,0.00,2811.15,0.00,'2022-11-01 07:55:18','',''),(2387,'1','281',NULL,2,'Sale Id shift 168',1749366.10,0.00,0.00,0.00,0.00,'2022-11-01 07:55:18','',''),(2388,'1','281',NULL,1,'Sale Id shift 168',3415606.90,0.00,0.00,0.00,0.00,'2022-11-01 07:55:18','',''),(2389,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3700000.00,20000.00,0.00,0.00,'2022-11-01 07:56:42','',''),(2390,'1','281','2',1,'Sale Id shift 169',0.00,0.00,0.00,3638.87,0.00,'2022-11-01 15:12:21','',''),(2391,'1','281','2',1,'Sale Id shift 169',0.00,0.00,0.00,3880.44,0.00,'2022-11-01 15:12:21','',''),(2392,'1','281','3',2,'Sale Id shift 169',0.00,0.00,0.00,1807.40,0.00,'2022-11-01 15:12:21','',''),(2393,'1','281','1',1,'Sale Id shift 169',0.00,0.00,0.00,4128.55,0.00,'2022-11-01 15:12:21','',''),(2394,'1','281','1',1,'Sale Id shift 169',0.00,0.00,0.00,3890.13,0.00,'2022-11-01 15:12:21','',''),(2395,'1','281','2',1,'Sale Id shift 169',0.00,0.00,0.00,4455.48,0.00,'2022-11-01 15:12:21','',''),(2396,'1','281',NULL,2,'Sale Id shift 169',1500142.00,0.00,0.00,0.00,0.00,'2022-11-01 15:12:21','',''),(2397,'1','281',NULL,1,'Sale Id shift 169',3698791.95,0.00,0.00,0.00,0.00,'2022-11-01 15:12:21','',''),(2398,'1','281',NULL,1,'Reception corrector for bridging 199',0.00,0.00,0.00,10000.00,0.00,'2022-11-01 16:36:44','',''),(2399,'1','281','2',1,'Received from bridging 199',0.00,0.00,10000.00,0.00,0.00,'2022-11-01 16:36:44','',''),(2400,'1','281',NULL,1,'Reception corrector for bridging 198',0.00,0.00,0.00,10000.00,0.00,'2022-11-01 16:37:15','',''),(2401,'1','281','1',1,'Received from bridging 198',0.00,0.00,10000.00,0.00,0.00,'2022-11-01 16:37:15','',''),(2402,'1','281','3',2,'Sale Id shift 170',0.00,0.00,0.00,2362.61,0.00,'2022-11-02 08:04:58','',''),(2403,'1','281','3',2,'Sale Id shift 170',0.00,0.00,0.00,461.27,0.00,'2022-11-02 08:04:58','',''),(2404,'1','281',NULL,2,'Sale Id shift 170',2343820.40,0.00,0.00,0.00,0.00,'2022-11-02 08:04:58','',''),(2405,'1','281','3',2,'Sale Id shift 171',0.00,0.00,0.00,471.79,0.00,'2022-11-02 21:39:15','',''),(2406,'1','281','3',2,'Sale Id shift 171',0.00,0.00,0.00,100.00,0.00,'2022-11-02 21:39:15','',''),(2407,'1','281',NULL,2,'Sale Id shift 171',474585.70,0.00,0.00,0.00,0.00,'2022-11-02 21:39:15','',''),(2408,'1','281','3',2,'Sale Id shift 172',0.00,0.00,0.00,261.87,0.00,'2022-11-03 07:57:49','',''),(2409,'1','281','3',2,'Sale Id shift 172',0.00,0.00,0.00,216.73,0.00,'2022-11-03 07:57:49','',''),(2410,'1','281',NULL,2,'Sale Id shift 172',397238.00,0.00,0.00,0.00,0.00,'2022-11-03 07:57:49','',''),(2411,'1','281','3',2,'Sale Id shift 173',0.00,0.00,0.00,733.17,0.00,'2022-11-03 21:33:32','',''),(2412,'1','281','3',2,'Sale Id shift 173',0.00,0.00,0.00,29.89,0.00,'2022-11-03 21:33:32','',''),(2413,'1','281',NULL,2,'Sale Id shift 173',633339.80,0.00,0.00,0.00,0.00,'2022-11-03 21:33:32','',''),(2414,'1','281','3',2,'Sale Id shift 174',0.00,0.00,0.00,83.06,0.00,'2022-11-04 07:37:50','',''),(2415,'1','281','3',2,'Sale Id shift 174',0.00,0.00,0.00,99.17,0.00,'2022-11-04 07:37:50','',''),(2416,'1','281',NULL,2,'Sale Id shift 174',151250.90,0.00,0.00,0.00,0.00,'2022-11-04 07:37:50','',''),(2417,'1','281','3',2,'Sale Id shift 175',0.00,0.00,0.00,264.56,0.00,'2022-11-04 21:54:33','',''),(2418,'1','281','3',2,'Sale Id shift 175',0.00,0.00,0.00,217.84,0.00,'2022-11-04 21:54:33','',''),(2419,'1','281',NULL,2,'Sale Id shift 175',400392.00,0.00,0.00,0.00,0.00,'2022-11-04 21:54:33','',''),(2420,'1','281',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,12035000.00,14500.00,0.00,0.00,'2022-11-04 22:12:03','',''),(2421,'1','281',NULL,2,'Reception corrector for bridging 200',0.00,0.00,0.00,14500.00,0.00,'2022-11-04 22:16:03','',''),(2422,'1','281','3',2,'Received from bridging 200',0.00,0.00,14500.00,0.00,0.00,'2022-11-04 22:16:03','',''),(2423,'1','281','3',2,'Sale Id shift 176',0.00,0.00,0.00,3002.66,0.00,'2022-11-05 09:09:58','',''),(2424,'1','281','3',2,'Sale Id shift 176',0.00,0.00,0.00,334.54,0.00,'2022-11-05 09:09:58','',''),(2425,'1','281',NULL,2,'Sale Id shift 176',2769876.00,0.00,0.00,0.00,0.00,'2022-11-05 09:09:58','',''),(2426,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9250000.00,50000.00,0.00,0.00,'2022-11-05 11:55:57','',''),(2427,'1','281',NULL,1,'Reception corrector for bridging 201',0.00,0.00,0.00,20000.00,0.00,'2022-11-05 15:18:15','',''),(2428,'1','281','1',1,'Received from bridging 201',0.00,0.00,20000.00,0.00,0.00,'2022-11-05 15:18:15','',''),(2429,'1','281',NULL,1,'Reception corrector for bridging 202',0.00,0.00,0.00,15000.00,0.00,'2022-11-05 15:18:46','',''),(2430,'1','281','2',1,'Received from bridging 202',0.00,0.00,15000.00,0.00,0.00,'2022-11-05 15:18:46','',''),(2431,'1','281','2',1,'Sale Id shift 177',0.00,0.00,0.00,3256.00,0.00,'2022-11-05 16:37:46','',''),(2432,'1','281','2',1,'Sale Id shift 177',0.00,0.00,0.00,3183.27,0.00,'2022-11-05 16:37:46','',''),(2433,'1','281','3',2,'Sale Id shift 177',0.00,0.00,0.00,1888.91,0.00,'2022-11-05 16:37:46','',''),(2434,'1','281','3',2,'Sale Id shift 177',0.00,0.00,0.00,136.75,0.00,'2022-11-05 16:37:46','',''),(2435,'1','281','1',1,'Sale Id shift 177',0.00,0.00,0.00,3383.83,0.00,'2022-11-05 16:37:46','',''),(2436,'1','281','1',1,'Sale Id shift 177',0.00,0.00,0.00,3654.33,0.00,'2022-11-05 16:37:46','',''),(2437,'1','281','2',1,'Sale Id shift 177',0.00,0.00,0.00,1938.78,0.00,'2022-11-05 16:37:46','',''),(2438,'1','281','2',1,'Sale Id shift 177',0.00,0.00,0.00,1080.70,0.00,'2022-11-05 16:37:46','',''),(2439,'1','281',NULL,2,'Sale Id shift 177',1681297.80,0.00,0.00,0.00,0.00,'2022-11-05 16:37:46','',''),(2440,'1','281',NULL,1,'Sale Id shift 177',3051928.35,0.00,0.00,0.00,0.00,'2022-11-05 16:37:46','',''),(2441,'1','281',NULL,1,'Reception corrector for bridging 204',0.00,0.00,0.00,7000.00,0.00,'2022-11-05 22:49:09','',''),(2442,'1','281','2',1,'Received from bridging 204',0.00,0.00,7000.00,0.00,0.00,'2022-11-05 22:49:09','',''),(2443,'1','281',NULL,1,'Reception corrector for bridging 203',0.00,0.00,0.00,8000.00,0.00,'2022-11-05 22:49:31','',''),(2444,'1','281','1',1,'Received from bridging 203',0.00,0.00,8000.00,0.00,0.00,'2022-11-05 22:49:31','',''),(2445,'1','281','2',1,'Sale Id shift 178',0.00,0.00,0.00,772.75,0.00,'2022-11-06 08:20:35','',''),(2446,'1','281','2',1,'Sale Id shift 178',0.00,0.00,0.00,1657.10,0.00,'2022-11-06 08:20:35','',''),(2447,'1','281','2',1,'Sale Id shift 178',0.00,0.00,0.00,2630.44,0.00,'2022-11-06 08:20:35','',''),(2448,'1','281','3',2,'Sale Id shift 178',0.00,0.00,0.00,985.35,0.00,'2022-11-06 08:20:35','',''),(2449,'1','281','3',2,'Sale Id shift 178',0.00,0.00,0.00,691.41,0.00,'2022-11-06 08:20:35','',''),(2450,'1','281','1',1,'Sale Id shift 178',0.00,0.00,0.00,3449.33,0.00,'2022-11-06 08:20:35','',''),(2451,'1','281','1',1,'Sale Id shift 178',0.00,0.00,0.00,1187.94,0.00,'2022-11-06 08:20:35','',''),(2452,'1','281','1',1,'Sale Id shift 178',0.00,0.00,0.00,2396.75,0.00,'2022-11-06 08:20:35','',''),(2453,'1','281','1',1,'Sale Id shift 178',0.00,0.00,0.00,7045.34,0.00,'2022-11-06 08:20:35','',''),(2454,'1','281','2',1,'Sale Id shift 178',0.00,0.00,0.00,2240.78,0.00,'2022-11-06 08:20:35','',''),(2455,'1','281','2',1,'Sale Id shift 178',0.00,0.00,0.00,1409.58,0.00,'2022-11-06 08:20:35','',''),(2456,'1','281',NULL,2,'Sale Id shift 178',1391710.80,0.00,0.00,0.00,0.00,'2022-11-06 08:20:35','',''),(2457,'1','281',NULL,1,'Sale Id shift 178',4216151.85,0.00,0.00,0.00,0.00,'2022-11-06 08:20:35','',''),(2458,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,5550000.00,30000.00,0.00,0.00,'2022-11-06 08:20:52','',''),(2459,'1','281',NULL,1,'Reception corrector for bridging 205',0.00,0.00,0.00,17000.00,0.00,'2022-11-06 09:59:40','',''),(2460,'1','281','1',1,'Received from bridging 205',0.00,0.00,17000.00,0.00,0.00,'2022-11-06 09:59:40','',''),(2461,'1','281',NULL,1,'Reception corrector for bridging 206',0.00,0.00,0.00,13000.00,0.00,'2022-11-06 10:00:54','',''),(2462,'1','281','2',1,'Received from bridging 206',0.00,0.00,13000.00,0.00,0.00,'2022-11-06 10:00:54','',''),(2463,'1','281','2',1,'Sale Id shift 179',0.00,0.00,0.00,2631.01,0.00,'2022-11-06 16:34:24','',''),(2464,'1','281','2',1,'Sale Id shift 179',0.00,0.00,0.00,1242.28,0.00,'2022-11-06 16:34:24','',''),(2465,'1','281','2',1,'Sale Id shift 179',0.00,0.00,0.00,3727.70,0.00,'2022-11-06 16:34:24','',''),(2466,'1','281','3',2,'Sale Id shift 179',0.00,0.00,0.00,1037.03,0.00,'2022-11-06 16:34:24','',''),(2467,'1','281','3',2,'Sale Id shift 179',0.00,0.00,0.00,120.49,0.00,'2022-11-06 16:34:24','',''),(2468,'1','281','1',1,'Sale Id shift 179',0.00,0.00,0.00,2978.98,0.00,'2022-11-06 16:34:24','',''),(2469,'1','281','1',1,'Sale Id shift 179',0.00,0.00,0.00,2839.35,0.00,'2022-11-06 16:34:24','',''),(2470,'1','281','1',1,'Sale Id shift 179',0.00,0.00,0.00,4161.74,0.00,'2022-11-06 16:34:24','',''),(2471,'1','281','2',1,'Sale Id shift 179',0.00,0.00,0.00,3403.87,0.00,'2022-11-06 16:34:24','',''),(2472,'1','281','2',1,'Sale Id shift 179',0.00,0.00,0.00,1110.63,0.00,'2022-11-06 16:34:24','',''),(2473,'1','281',NULL,2,'Sale Id shift 179',960741.60,0.00,0.00,0.00,0.00,'2022-11-06 16:34:24','',''),(2474,'1','281',NULL,1,'Sale Id shift 179',4087678.60,0.00,0.00,0.00,0.00,'2022-11-06 16:34:24','',''),(2475,'1','281','2',1,'Sale Id shift 180',0.00,0.00,0.00,474.16,0.00,'2022-11-07 08:35:10','',''),(2476,'1','281','2',1,'Sale Id shift 180',0.00,0.00,0.00,1269.30,0.00,'2022-11-07 08:35:10','',''),(2477,'1','281','3',2,'Sale Id shift 180',0.00,0.00,0.00,246.70,0.00,'2022-11-07 08:35:10','',''),(2478,'1','281','3',2,'Sale Id shift 180',0.00,0.00,0.00,76.91,0.00,'2022-11-07 08:35:10','',''),(2479,'1','281','1',1,'Sale Id shift 180',0.00,0.00,0.00,661.53,0.00,'2022-11-07 08:35:10','',''),(2480,'1','281','1',1,'Sale Id shift 180',0.00,0.00,0.00,92.60,0.00,'2022-11-07 08:35:10','',''),(2481,'1','281','1',1,'Sale Id shift 180',0.00,0.00,0.00,1133.52,0.00,'2022-11-07 08:35:10','',''),(2482,'1','281','1',1,'Sale Id shift 180',0.00,0.00,0.00,404.00,0.00,'2022-11-07 08:35:10','',''),(2483,'1','281','2',1,'Sale Id shift 180',0.00,0.00,0.00,1215.73,0.00,'2022-11-07 08:35:10','',''),(2484,'1','281',NULL,2,'Sale Id shift 180',268596.30,0.00,0.00,0.00,0.00,'2022-11-07 08:35:10','',''),(2485,'1','281',NULL,1,'Sale Id shift 180',971405.40,0.00,0.00,0.00,0.00,'2022-11-07 08:35:10','',''),(2486,'1','281','2',1,'Sale Id shift 181',0.00,0.00,0.00,3901.30,0.00,'2022-11-07 15:24:30','',''),(2487,'1','281','2',1,'Sale Id shift 181',0.00,0.00,0.00,192.69,0.00,'2022-11-07 15:24:30','',''),(2488,'1','281','2',1,'Sale Id shift 181',0.00,0.00,0.00,3616.58,0.00,'2022-11-07 15:24:30','',''),(2489,'1','281','3',2,'Sale Id shift 181',0.00,0.00,0.00,468.76,0.00,'2022-11-07 15:24:30','',''),(2490,'1','281','3',2,'Sale Id shift 181',0.00,0.00,0.00,150.81,0.00,'2022-11-07 15:24:30','',''),(2491,'1','281','1',1,'Sale Id shift 181',0.00,0.00,0.00,4261.72,0.00,'2022-11-07 15:24:30','',''),(2492,'1','281','1',1,'Sale Id shift 181',0.00,0.00,0.00,3991.37,0.00,'2022-11-07 15:24:30','',''),(2493,'1','281','1',1,'Sale Id shift 181',0.00,0.00,0.00,4139.40,0.00,'2022-11-07 15:24:30','',''),(2494,'1','281','2',1,'Sale Id shift 181',0.00,0.00,0.00,3859.20,0.00,'2022-11-07 15:24:30','',''),(2495,'1','281',NULL,2,'Sale Id shift 181',514243.10,0.00,0.00,0.00,0.00,'2022-11-07 15:24:30','',''),(2496,'1','281',NULL,1,'Sale Id shift 181',4433018.10,0.00,0.00,0.00,0.00,'2022-11-07 15:24:30','',''),(2497,'1','281','2',1,'Sale Id shift 182',0.00,0.00,0.00,1173.25,0.00,'2022-11-08 07:48:57','',''),(2498,'1','281','2',1,'Sale Id shift 182',0.00,0.00,0.00,396.87,0.00,'2022-11-08 07:48:57','',''),(2499,'1','281','3',2,'Sale Id shift 182',0.00,0.00,0.00,833.44,0.00,'2022-11-08 07:48:57','',''),(2500,'1','281','3',2,'Sale Id shift 182',0.00,0.00,0.00,388.41,0.00,'2022-11-08 07:48:57','',''),(2501,'1','281','1',1,'Sale Id shift 182',0.00,0.00,0.00,1474.10,0.00,'2022-11-08 07:48:57','',''),(2502,'1','281','1',1,'Sale Id shift 182',0.00,0.00,0.00,602.54,0.00,'2022-11-08 07:48:57','',''),(2503,'1','281','1',1,'Sale Id shift 182',0.00,0.00,0.00,1499.98,0.00,'2022-11-08 07:48:57','',''),(2504,'1','281','2',1,'Sale Id shift 182',0.00,0.00,0.00,538.43,0.00,'2022-11-08 07:48:57','',''),(2505,'1','281',NULL,2,'Sale Id shift 182',1014135.50,0.00,0.00,0.00,0.00,'2022-11-08 07:48:57','',''),(2506,'1','281',NULL,1,'Sale Id shift 182',1051756.45,0.00,0.00,0.00,0.00,'2022-11-08 07:48:57','',''),(2507,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3034000.00,16400.00,0.00,0.00,'2022-11-08 07:49:35','',''),(2508,'1','281','2',1,'Sale Id shift 183',0.00,0.00,0.00,2686.82,0.00,'2022-11-08 15:04:22','',''),(2509,'1','281','2',1,'Sale Id shift 183',0.00,0.00,0.00,3508.21,0.00,'2022-11-08 15:04:22','',''),(2510,'1','281','3',2,'Sale Id shift 183',0.00,0.00,0.00,720.02,0.00,'2022-11-08 15:04:22','',''),(2511,'1','281','3',2,'Sale Id shift 183',0.00,0.00,0.00,71.08,0.00,'2022-11-08 15:04:22','',''),(2512,'1','281','1',1,'Sale Id shift 183',0.00,0.00,0.00,2812.14,0.00,'2022-11-08 15:04:22','',''),(2513,'1','281','1',1,'Sale Id shift 183',0.00,0.00,0.00,2607.33,0.00,'2022-11-08 15:04:22','',''),(2514,'1','281','2',1,'Sale Id shift 183',0.00,0.00,0.00,2671.63,0.00,'2022-11-08 15:04:22','',''),(2515,'1','281','2',1,'Sale Id shift 183',0.00,0.00,0.00,2701.59,0.00,'2022-11-08 15:04:22','',''),(2516,'1','281',NULL,2,'Sale Id shift 183',656613.00,0.00,0.00,0.00,0.00,'2022-11-08 15:04:22','',''),(2517,'1','281',NULL,1,'Sale Id shift 183',3142728.20,0.00,0.00,0.00,0.00,'2022-11-08 15:04:22','',''),(2518,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3145000.00,17000.00,0.00,0.00,'2022-11-08 15:04:55','',''),(2519,'1','281',NULL,1,'Reception corrector for bridging 208',0.00,0.00,0.00,6400.00,0.00,'2022-11-09 11:05:37','',''),(2520,'1','281','2',1,'Received from bridging 208',0.00,0.00,6400.00,0.00,0.00,'2022-11-09 11:05:37','',''),(2521,'1','281',NULL,1,'Reception corrector for bridging 207',0.00,0.00,0.00,10000.00,0.00,'2022-11-09 11:06:59','',''),(2522,'1','281','1',1,'Received from bridging 207',0.00,0.00,10000.00,0.00,0.00,'2022-11-09 11:06:59','',''),(2523,'1','281',NULL,1,'Reception corrector for bridging 210',0.00,0.00,0.00,17000.00,0.00,'2022-11-09 11:09:24','',''),(2524,'1','281','2',1,'Received from bridging 210',0.00,0.00,17000.00,0.00,0.00,'2022-11-09 11:09:24','',''),(2525,'1','281','3',2,'Sale Id shift 184',0.00,0.00,0.00,1768.75,0.00,'2022-11-09 11:12:43','',''),(2526,'1','281','3',2,'Sale Id shift 184',0.00,0.00,0.00,317.54,0.00,'2022-11-09 11:12:43','',''),(2527,'1','281',NULL,2,'Sale Id shift 184',1731620.70,0.00,0.00,0.00,0.00,'2022-11-09 11:12:43','',''),(2528,'1','281','3',2,'Sale Id shift 185',0.00,0.00,0.00,95.67,0.00,'2022-11-09 16:20:48','',''),(2529,'1','281','3',2,'Sale Id shift 185',0.00,0.00,0.00,112.41,0.00,'2022-11-09 16:20:48','',''),(2530,'1','281',NULL,2,'Sale Id shift 185',172706.40,0.00,0.00,0.00,0.00,'2022-11-09 16:20:48','',''),(2531,'1','281','3',2,'Sale Id shift 186',0.00,0.00,0.00,528.79,0.00,'2022-11-10 07:45:16','',''),(2532,'1','281','3',2,'Sale Id shift 186',0.00,0.00,0.00,77.34,0.00,'2022-11-10 07:45:16','',''),(2533,'1','281',NULL,2,'Sale Id shift 186',503087.90,0.00,0.00,0.00,0.00,'2022-11-10 07:45:16','',''),(2534,'1','281','3',2,'Sale Id shift 187',0.00,0.00,0.00,328.31,0.00,'2022-11-10 16:24:24','',''),(2535,'1','281','3',2,'Sale Id shift 187',0.00,0.00,0.00,159.51,0.00,'2022-11-10 16:24:24','',''),(2536,'1','281',NULL,2,'Sale Id shift 187',404890.60,0.00,0.00,0.00,0.00,'2022-11-10 16:24:24','',''),(2537,'1','281','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,990.91,0.00,'2022-11-11 09:48:56','',''),(2538,'1','281','3',0,'Inventory adjustment from tank dipping to 3000',0.00,0.00,3000.00,0.00,0.00,'2022-11-11 09:48:56','',''),(2539,'1','281','3',2,'Sale Id shift 188',0.00,0.00,0.00,835.89,0.00,'2022-11-11 12:13:08','',''),(2540,'1','281','3',2,'Sale Id shift 188',0.00,0.00,0.00,776.40,0.00,'2022-11-11 12:13:08','',''),(2541,'1','281',NULL,2,'Sale Id shift 188',1386569.40,0.00,0.00,0.00,0.00,'2022-11-11 12:13:08','',''),(2542,'1','281','3',2,'Sale Id shift 189',0.00,0.00,0.00,38.31,0.00,'2022-11-12 07:25:51','',''),(2543,'1','281',NULL,2,'Sale Id shift 189',32946.60,0.00,0.00,0.00,0.00,'2022-11-12 07:25:51','',''),(2544,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9102000.00,49200.00,0.00,0.00,'2022-11-12 15:04:30','',''),(2545,'1','281',NULL,1,'Reception corrector for bridging 212',0.00,0.00,0.00,19200.00,0.00,'2022-11-12 15:13:05','',''),(2546,'1','281','2',1,'Received from bridging 212',0.00,0.00,19200.00,0.00,0.00,'2022-11-12 15:13:05','',''),(2547,'1','281',NULL,1,'Reception corrector for bridging 211',0.00,0.00,0.00,25000.00,0.00,'2022-11-12 15:14:40','',''),(2548,'1','281','1',1,'Received from bridging 211',0.00,0.00,25000.00,0.00,0.00,'2022-11-12 15:14:40','',''),(2549,'1','281','1',1,'Sale Id shift 190',0.00,0.00,0.00,4362.28,0.00,'2022-11-12 17:10:32','',''),(2550,'1','281','2',1,'Sale Id shift 190',0.00,0.00,0.00,3976.65,0.00,'2022-11-12 17:10:32','',''),(2551,'1','281','1',1,'Sale Id shift 190',0.00,0.00,0.00,3642.15,0.00,'2022-11-12 17:10:32','',''),(2552,'1','281','1',1,'Sale Id shift 190',0.00,0.00,0.00,4183.70,0.00,'2022-11-12 17:10:32','',''),(2553,'1','281','1',1,'Sale Id shift 190',0.00,0.00,0.00,4152.38,0.00,'2022-11-12 17:10:32','',''),(2554,'1','281','2',1,'Sale Id shift 190',0.00,0.00,0.00,4944.52,0.00,'2022-11-12 17:10:32','',''),(2555,'1','281',NULL,1,'Sale Id shift 190',4673410.80,0.00,0.00,0.00,0.00,'2022-11-12 17:10:32','',''),(2556,'1','281',NULL,1,'Reception corrector for bridging 213',0.00,0.00,0.00,5000.00,0.00,'2022-11-12 19:14:04','',''),(2557,'1','281','1',1,'Received from bridging 213',0.00,0.00,5000.00,0.00,0.00,'2022-11-12 19:14:04','',''),(2558,'1','281','1',1,'Sale Id shift 191',0.00,0.00,0.00,1388.46,0.00,'2022-11-13 07:25:35','',''),(2559,'1','281','2',1,'Sale Id shift 191',0.00,0.00,0.00,1240.13,0.00,'2022-11-13 07:25:35','',''),(2560,'1','281','1',1,'Sale Id shift 191',0.00,0.00,0.00,1261.42,0.00,'2022-11-13 07:25:35','',''),(2561,'1','281','1',1,'Sale Id shift 191',0.00,0.00,0.00,1340.57,0.00,'2022-11-13 07:25:35','',''),(2562,'1','281','1',1,'Sale Id shift 191',0.00,0.00,0.00,1218.30,0.00,'2022-11-13 07:25:35','',''),(2563,'1','281','2',1,'Sale Id shift 191',0.00,0.00,0.00,1330.76,0.00,'2022-11-13 07:25:35','',''),(2564,'1','281',NULL,1,'Sale Id shift 191',1439233.40,0.00,0.00,0.00,0.00,'2022-11-13 07:25:35','',''),(2565,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,7400000.00,40000.00,0.00,0.00,'2022-11-13 07:26:01','',''),(2566,'1','281','1',1,'Sale Id shift 192',0.00,0.00,0.00,286.49,0.00,'2022-11-13 17:56:05','',''),(2567,'1','281','2',1,'Sale Id shift 192',0.00,0.00,0.00,5460.22,0.00,'2022-11-13 17:56:05','',''),(2568,'1','281','2',1,'Sale Id shift 192',0.00,0.00,0.00,861.37,0.00,'2022-11-13 17:56:05','',''),(2569,'1','281','2',1,'Sale Id shift 192',0.00,0.00,0.00,4850.01,0.00,'2022-11-13 17:56:05','',''),(2570,'1','281','1',1,'Sale Id shift 192',0.00,0.00,0.00,5954.71,0.00,'2022-11-13 17:56:05','',''),(2571,'1','281','1',1,'Sale Id shift 192',0.00,0.00,0.00,5256.84,0.00,'2022-11-13 17:56:05','',''),(2572,'1','281','1',1,'Sale Id shift 192',0.00,0.00,0.00,6455.38,0.00,'2022-11-13 17:56:05','',''),(2573,'1','281','2',1,'Sale Id shift 192',0.00,0.00,0.00,5367.30,0.00,'2022-11-13 17:56:05','',''),(2574,'1','281',NULL,1,'Sale Id shift 192',6381079.20,0.00,0.00,0.00,0.00,'2022-11-13 17:56:05','',''),(2575,'1','281',NULL,1,'Reception corrector for bridging 215',0.00,0.00,0.00,20000.00,0.00,'2022-11-14 16:26:24','',''),(2576,'1','281','2',1,'Received from bridging 215',0.00,0.00,20000.00,0.00,0.00,'2022-11-14 16:26:24','',''),(2577,'1','281',NULL,1,'Reception corrector for bridging 214',0.00,0.00,0.00,20000.00,0.00,'2022-11-14 16:26:50','',''),(2578,'1','281','1',1,'Received from bridging 214',0.00,0.00,20000.00,0.00,0.00,'2022-11-14 16:26:50','',''),(2579,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,6197500.00,33500.00,0.00,0.00,'2022-11-14 16:39:35','',''),(2580,'1','281',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,14620000.00,17000.00,0.00,0.00,'2022-11-14 16:39:52','',''),(2581,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,5550000.00,30000.00,0.00,0.00,'2022-11-14 16:40:07','',''),(2582,'1','281','2',1,'Sale Id shift 193',0.00,0.00,0.00,4167.28,0.00,'2022-11-14 16:49:35','',''),(2583,'1','281','2',1,'Sale Id shift 193',0.00,0.00,0.00,4529.39,0.00,'2022-11-14 16:49:35','',''),(2584,'1','281','1',1,'Sale Id shift 193',0.00,0.00,0.00,4910.72,0.00,'2022-11-14 16:49:35','',''),(2585,'1','281','1',1,'Sale Id shift 193',0.00,0.00,0.00,3874.34,0.00,'2022-11-14 16:49:35','',''),(2586,'1','281','1',1,'Sale Id shift 193',0.00,0.00,0.00,4790.98,0.00,'2022-11-14 16:49:35','',''),(2587,'1','281','2',1,'Sale Id shift 193',0.00,0.00,0.00,4139.82,0.00,'2022-11-14 16:49:35','',''),(2588,'1','281',NULL,1,'Sale Id shift 193',4886318.05,0.00,0.00,0.00,0.00,'2022-11-14 16:49:35','',''),(2589,'1','281','1',1,'Sale Id shift 194',0.00,0.00,0.00,1963.68,0.00,'2022-11-15 07:48:59','',''),(2590,'1','281','2',1,'Sale Id shift 194',0.00,0.00,0.00,955.11,0.00,'2022-11-15 07:48:59','',''),(2591,'1','281','3',2,'Sale Id shift 194',0.00,0.00,0.00,380.62,0.00,'2022-11-15 07:48:59','',''),(2592,'1','281','3',2,'Sale Id shift 194',0.00,0.00,0.00,664.44,0.00,'2022-11-15 07:48:59','',''),(2593,'1','281','1',1,'Sale Id shift 194',0.00,0.00,0.00,605.62,0.00,'2022-11-15 07:48:59','',''),(2594,'1','281','1',1,'Sale Id shift 194',0.00,0.00,0.00,2026.57,0.00,'2022-11-15 07:48:59','',''),(2595,'1','281','1',1,'Sale Id shift 194',0.00,0.00,0.00,694.14,0.00,'2022-11-15 07:48:59','',''),(2596,'1','281','2',1,'Sale Id shift 194',0.00,0.00,0.00,1864.37,0.00,'2022-11-15 07:48:59','',''),(2597,'1','281',NULL,2,'Sale Id shift 194',898751.60,0.00,0.00,0.00,0.00,'2022-11-15 07:48:59','',''),(2598,'1','281',NULL,1,'Sale Id shift 194',1500255.65,0.00,0.00,0.00,0.00,'2022-11-15 07:48:59','',''),(2599,'1','281',NULL,1,'Reception corrector for bridging 217',0.00,0.00,0.00,15500.00,0.00,'2022-11-15 15:05:55','',''),(2600,'1','281','2',1,'Received from bridging 217',0.00,0.00,15500.00,0.00,0.00,'2022-11-15 15:05:55','',''),(2601,'1','281',NULL,1,'Reception corrector for bridging 216',0.00,0.00,0.00,18000.00,0.00,'2022-11-15 15:06:13','',''),(2602,'1','281','1',1,'Received from bridging 216',0.00,0.00,18000.00,0.00,0.00,'2022-11-15 15:06:13','',''),(2603,'1','281',NULL,1,'Reception corrector for bridging 219',0.00,0.00,0.00,5000.00,0.00,'2022-11-15 15:07:37','',''),(2604,'1','281','2',1,'Received from bridging 219',0.00,0.00,5000.00,0.00,0.00,'2022-11-15 15:07:37','',''),(2605,'1','281',NULL,1,'Reception corrector for bridging 218',0.00,0.00,0.00,15000.00,0.00,'2022-11-15 15:07:56','',''),(2606,'1','281','1',1,'Received from bridging 218',0.00,0.00,15000.00,0.00,0.00,'2022-11-15 15:07:56','',''),(2607,'1','281',NULL,2,'Reception corrector for bridging 220',0.00,0.00,0.00,17000.00,0.00,'2022-11-15 15:09:15','',''),(2608,'1','281','3',2,'Received from bridging 220',0.00,0.00,17000.00,0.00,0.00,'2022-11-15 15:09:15','',''),(2609,'1','281','2',1,'Sale Id shift 195',0.00,0.00,0.00,4209.05,0.00,'2022-11-15 16:57:46','',''),(2610,'1','281','3',2,'Sale Id shift 195',0.00,0.00,0.00,1996.62,0.00,'2022-11-15 16:57:46','',''),(2611,'1','281','3',2,'Sale Id shift 195',0.00,0.00,0.00,149.67,0.00,'2022-11-15 16:57:46','',''),(2612,'1','281','1',1,'Sale Id shift 195',0.00,0.00,0.00,4396.86,0.00,'2022-11-15 16:57:46','',''),(2613,'1','281','1',1,'Sale Id shift 195',0.00,0.00,0.00,4573.54,0.00,'2022-11-15 16:57:46','',''),(2614,'1','281','1',1,'Sale Id shift 195',0.00,0.00,0.00,4844.09,0.00,'2022-11-15 16:57:46','',''),(2615,'1','281','2',1,'Sale Id shift 195',0.00,0.00,0.00,4592.53,0.00,'2022-11-15 16:57:46','',''),(2616,'1','281',NULL,2,'Sale Id shift 195',1845809.40,0.00,0.00,0.00,0.00,'2022-11-15 16:57:46','',''),(2617,'1','281',NULL,1,'Sale Id shift 195',4183972.95,0.00,0.00,0.00,0.00,'2022-11-15 16:57:46','',''),(2618,'1','281',NULL,1,'Reception corrector for bridging 221',0.00,0.00,0.00,5000.00,0.00,'2022-11-15 19:54:26','',''),(2619,'1','281','1',1,'Received from bridging 221',0.00,0.00,5000.00,0.00,0.00,'2022-11-15 19:54:26','',''),(2620,'1','281',NULL,1,'Reception corrector for bridging 222',0.00,0.00,0.00,5000.00,0.00,'2022-11-15 19:54:58','',''),(2621,'1','281','2',1,'Received from bridging 222',0.00,0.00,5000.00,0.00,0.00,'2022-11-15 19:54:58','',''),(2622,'1','281','2',1,'Sale Id shift 196',0.00,0.00,0.00,1175.76,0.00,'2022-11-16 08:07:35','',''),(2623,'1','281','2',1,'Sale Id shift 196',0.00,0.00,0.00,1425.62,0.00,'2022-11-16 08:07:35','',''),(2624,'1','281','3',2,'Sale Id shift 196',0.00,0.00,0.00,1193.93,0.00,'2022-11-16 08:07:35','',''),(2625,'1','281','3',2,'Sale Id shift 196',0.00,0.00,0.00,274.96,0.00,'2022-11-16 08:07:35','',''),(2626,'1','281','1',1,'Sale Id shift 196',0.00,0.00,0.00,891.30,0.00,'2022-11-16 08:07:35','',''),(2627,'1','281','1',1,'Sale Id shift 196',0.00,0.00,0.00,1555.69,0.00,'2022-11-16 08:07:35','',''),(2628,'1','281','2',1,'Sale Id shift 196',0.00,0.00,0.00,812.06,0.00,'2022-11-16 08:07:35','',''),(2629,'1','281','2',1,'Sale Id shift 196',0.00,0.00,0.00,1444.82,0.00,'2022-11-16 08:07:35','',''),(2630,'1','281',NULL,2,'Sale Id shift 196',1263245.40,0.00,0.00,0.00,0.00,'2022-11-16 08:07:35','',''),(2631,'1','281',NULL,1,'Sale Id shift 196',1351471.25,0.00,0.00,0.00,0.00,'2022-11-16 08:07:35','',''),(2632,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,5550000.00,30000.00,0.00,0.00,'2022-11-16 08:08:07','',''),(2633,'1','281','1',1,'Sale Id shift 197',0.00,0.00,0.00,462.01,0.00,'2022-11-16 16:12:18','',''),(2634,'1','281','2',1,'Sale Id shift 197',0.00,0.00,0.00,541.08,0.00,'2022-11-16 16:12:18','',''),(2635,'1','281','2',1,'Sale Id shift 197',0.00,0.00,0.00,4402.81,0.00,'2022-11-16 16:12:18','',''),(2636,'1','281','3',2,'Sale Id shift 197',0.00,0.00,0.00,218.53,0.00,'2022-11-16 16:12:18','',''),(2637,'1','281','3',2,'Sale Id shift 197',0.00,0.00,0.00,68.05,0.00,'2022-11-16 16:12:18','',''),(2638,'1','281','1',1,'Sale Id shift 197',0.00,0.00,0.00,5557.05,0.00,'2022-11-16 16:12:18','',''),(2639,'1','281','1',1,'Sale Id shift 197',0.00,0.00,0.00,7132.85,0.00,'2022-11-16 16:12:18','',''),(2640,'1','281','1',1,'Sale Id shift 197',0.00,0.00,0.00,4383.37,0.00,'2022-11-16 16:12:18','',''),(2641,'1','281','2',1,'Sale Id shift 197',0.00,0.00,0.00,4458.46,0.00,'2022-11-16 16:12:18','',''),(2642,'1','281','2',1,'Sale Id shift 197',0.00,0.00,0.00,511.25,0.00,'2022-11-16 16:12:18','',''),(2643,'1','281',NULL,2,'Sale Id shift 197',246458.80,0.00,0.00,0.00,0.00,'2022-11-16 16:12:18','',''),(2644,'1','281',NULL,1,'Sale Id shift 197',5078042.80,0.00,0.00,0.00,0.00,'2022-11-16 16:12:18','',''),(2645,'1','281',NULL,1,'Reception corrector for bridging 223',0.00,0.00,0.00,15000.00,0.00,'2022-11-16 16:22:51','',''),(2646,'1','281','1',1,'Received from bridging 223',0.00,0.00,15000.00,0.00,0.00,'2022-11-16 16:22:51','',''),(2647,'1','281',NULL,1,'Reception corrector for bridging 224',0.00,0.00,0.00,15000.00,0.00,'2022-11-16 16:23:09','',''),(2648,'1','281','2',1,'Received from bridging 224',0.00,0.00,15000.00,0.00,0.00,'2022-11-16 16:23:09','',''),(2649,'1','281','3',2,'Sale Id shift 198',0.00,0.00,0.00,344.17,0.00,'2022-11-17 07:56:37','',''),(2650,'1','281','3',2,'Sale Id shift 198',0.00,0.00,0.00,435.54,0.00,'2022-11-17 07:56:37','',''),(2651,'1','281',NULL,2,'Sale Id shift 198',670550.60,0.00,0.00,0.00,0.00,'2022-11-17 07:56:37','',''),(2652,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,4440000.00,24000.00,0.00,0.00,'2022-11-17 07:57:00','',''),(2653,'1','281','1',1,'Sale Id shift 199',0.00,0.00,0.00,4285.24,0.00,'2022-11-17 14:58:38','',''),(2654,'1','281','2',1,'Sale Id shift 199',0.00,0.00,0.00,4403.53,0.00,'2022-11-17 14:58:38','',''),(2655,'1','281','3',2,'Sale Id shift 199',0.00,0.00,0.00,1373.08,0.00,'2022-11-17 14:58:38','',''),(2656,'1','281','3',2,'Sale Id shift 199',0.00,0.00,0.00,1295.37,0.00,'2022-11-17 14:58:38','',''),(2657,'1','281','1',1,'Sale Id shift 199',0.00,0.00,0.00,4075.92,0.00,'2022-11-17 14:58:38','',''),(2658,'1','281','1',1,'Sale Id shift 199',0.00,0.00,0.00,4284.01,0.00,'2022-11-17 14:58:38','',''),(2659,'1','281','1',1,'Sale Id shift 199',0.00,0.00,0.00,4711.67,0.00,'2022-11-17 14:58:38','',''),(2660,'1','281','2',1,'Sale Id shift 199',0.00,0.00,0.00,4499.58,0.00,'2022-11-17 14:58:38','',''),(2661,'1','281',NULL,2,'Sale Id shift 199',2294867.00,0.00,0.00,0.00,0.00,'2022-11-17 14:58:38','',''),(2662,'1','281',NULL,1,'Sale Id shift 199',4858090.75,0.00,0.00,0.00,0.00,'2022-11-17 14:58:38','',''),(2663,'1','281','3',2,'Sale Id shift 200',0.00,0.00,0.00,1237.38,0.00,'2022-11-18 08:01:14','',''),(2664,'1','281','3',2,'Sale Id shift 200',0.00,0.00,0.00,264.71,0.00,'2022-11-18 08:01:14','',''),(2665,'1','281',NULL,2,'Sale Id shift 200',1291797.40,0.00,0.00,0.00,0.00,'2022-11-18 08:01:14','',''),(2666,'1','281',NULL,1,'Reception corrector for bridging 225',0.00,0.00,0.00,14000.00,0.00,'2022-11-18 09:47:43','',''),(2667,'1','281','1',1,'Received from bridging 225',0.00,0.00,14000.00,0.00,0.00,'2022-11-18 09:47:43','',''),(2668,'1','281',NULL,1,'Reception corrector for bridging 226',0.00,0.00,0.00,10000.00,0.00,'2022-11-18 09:48:00','',''),(2669,'1','281','2',1,'Received from bridging 226',0.00,0.00,10000.00,0.00,0.00,'2022-11-18 09:48:00','',''),(2670,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,2867500.00,15500.00,0.00,0.00,'2022-11-18 15:04:04','',''),(2671,'1','281','2',1,'Sale Id shift 201',0.00,0.00,0.00,3969.17,0.00,'2022-11-18 16:25:43','',''),(2672,'1','281','2',1,'Sale Id shift 201',0.00,0.00,0.00,189.60,0.00,'2022-11-18 16:25:43','',''),(2673,'1','281','2',1,'Sale Id shift 201',0.00,0.00,0.00,4426.60,0.00,'2022-11-18 16:25:43','',''),(2674,'1','281','3',2,'Sale Id shift 201',0.00,0.00,0.00,2145.82,0.00,'2022-11-18 16:25:43','',''),(2675,'1','281','3',2,'Sale Id shift 201',0.00,0.00,0.00,475.93,0.00,'2022-11-18 16:25:43','',''),(2676,'1','281','1',1,'Sale Id shift 201',0.00,0.00,0.00,4230.06,0.00,'2022-11-18 16:25:43','',''),(2677,'1','281','1',1,'Sale Id shift 201',0.00,0.00,0.00,3929.11,0.00,'2022-11-18 16:25:43','',''),(2678,'1','281','1',1,'Sale Id shift 201',0.00,0.00,0.00,4791.26,0.00,'2022-11-18 16:25:43','',''),(2679,'1','281','2',1,'Sale Id shift 201',0.00,0.00,0.00,4245.02,0.00,'2022-11-18 16:25:43','',''),(2680,'1','281',NULL,2,'Sale Id shift 201',2254705.00,0.00,0.00,0.00,0.00,'2022-11-18 16:25:43','',''),(2681,'1','281',NULL,1,'Sale Id shift 201',4769451.70,0.00,0.00,0.00,0.00,'2022-11-18 16:25:43','',''),(2682,'1','281',NULL,1,'Reception corrector for bridging 230',0.00,0.00,0.00,7500.00,0.00,'2022-11-18 20:36:50','',''),(2683,'1','281','2',1,'Received from bridging 230',0.00,0.00,7500.00,0.00,0.00,'2022-11-18 20:36:50','',''),(2684,'1','281',NULL,1,'Reception corrector for bridging 229',0.00,0.00,0.00,8000.00,0.00,'2022-11-18 20:37:14','',''),(2685,'1','281','1',1,'Received from bridging 229',0.00,0.00,8000.00,0.00,0.00,'2022-11-18 20:37:14','',''),(2686,'1','281','2',1,'Sale Id shift 202',0.00,0.00,0.00,680.92,0.00,'2022-11-19 08:13:02','',''),(2687,'1','281','2',1,'Sale Id shift 202',0.00,0.00,0.00,2647.42,0.00,'2022-11-19 08:13:02','',''),(2688,'1','281','3',2,'Sale Id shift 202',0.00,0.00,0.00,1042.49,0.00,'2022-11-19 08:13:02','',''),(2689,'1','281','3',2,'Sale Id shift 202',0.00,0.00,0.00,360.53,0.00,'2022-11-19 08:13:02','',''),(2690,'1','281','1',1,'Sale Id shift 202',0.00,0.00,0.00,802.93,0.00,'2022-11-19 08:13:02','',''),(2691,'1','281','1',1,'Sale Id shift 202',0.00,0.00,0.00,2636.82,0.00,'2022-11-19 08:13:02','',''),(2692,'1','281','1',1,'Sale Id shift 202',0.00,0.00,0.00,895.41,0.00,'2022-11-19 08:13:02','',''),(2693,'1','281','2',1,'Sale Id shift 202',0.00,0.00,0.00,2804.15,0.00,'2022-11-19 08:13:02','',''),(2694,'1','281',NULL,2,'Sale Id shift 202',1206597.20,0.00,0.00,0.00,0.00,'2022-11-19 08:13:02','',''),(2695,'1','281',NULL,1,'Sale Id shift 202',1936515.25,0.00,0.00,0.00,0.00,'2022-11-19 08:13:02','',''),(2696,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,5550000.00,30000.00,0.00,0.00,'2022-11-19 13:14:24','',''),(2697,'1','281',NULL,1,'Reception corrector for bridging 231',0.00,0.00,0.00,17000.00,0.00,'2022-11-19 15:36:56','',''),(2698,'1','281','1',1,'Received from bridging 231',0.00,0.00,17000.00,0.00,0.00,'2022-11-19 15:36:56','',''),(2699,'1','281',NULL,1,'Reception corrector for bridging 232',0.00,0.00,0.00,13000.00,0.00,'2022-11-19 15:37:15','',''),(2700,'1','281','2',1,'Received from bridging 232',0.00,0.00,13000.00,0.00,0.00,'2022-11-19 15:37:15','',''),(2701,'1','281','1',1,'Sale Id shift 203',0.00,0.00,0.00,5385.30,0.00,'2022-11-19 16:09:11','',''),(2702,'1','281','2',1,'Sale Id shift 203',0.00,0.00,0.00,4400.14,0.00,'2022-11-19 16:09:11','',''),(2703,'1','281','3',2,'Sale Id shift 203',0.00,0.00,0.00,2499.38,0.00,'2022-11-19 16:09:11','',''),(2704,'1','281','3',2,'Sale Id shift 203',0.00,0.00,0.00,458.61,0.00,'2022-11-19 16:09:11','',''),(2705,'1','281','1',1,'Sale Id shift 203',0.00,0.00,0.00,4903.02,0.00,'2022-11-19 16:09:11','',''),(2706,'1','281','1',1,'Sale Id shift 203',0.00,0.00,0.00,4931.74,0.00,'2022-11-19 16:09:11','',''),(2707,'1','281','1',1,'Sale Id shift 203',0.00,0.00,0.00,4929.67,0.00,'2022-11-19 16:09:11','',''),(2708,'1','281','2',1,'Sale Id shift 203',0.00,0.00,0.00,5463.68,0.00,'2022-11-19 16:09:11','',''),(2709,'1','281',NULL,2,'Sale Id shift 203',2603031.20,0.00,0.00,0.00,0.00,'2022-11-19 16:09:11','',''),(2710,'1','281',NULL,1,'Sale Id shift 203',5552506.75,0.00,0.00,0.00,0.00,'2022-11-19 16:09:11','',''),(2711,'1','281','3',2,'Sale Id shift 204',0.00,0.00,0.00,374.24,0.00,'2022-11-20 08:26:34','',''),(2712,'1','281','3',2,'Sale Id shift 204',0.00,0.00,0.00,91.85,0.00,'2022-11-20 08:26:34','',''),(2713,'1','281',NULL,2,'Sale Id shift 204',410159.20,0.00,0.00,0.00,0.00,'2022-11-20 08:26:34','',''),(2714,'1','281',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,13992000.00,15900.00,0.00,0.00,'2022-11-20 19:09:43','',''),(2715,'1','281',NULL,2,'Reception corrector for bridging 233',0.00,0.00,0.00,15900.00,0.00,'2022-11-20 19:13:10','',''),(2716,'1','281','3',2,'Received from bridging 233',0.00,0.00,15900.00,0.00,0.00,'2022-11-20 19:13:10','',''),(2717,'1','281','3',2,'Sale Id shift 205',0.00,0.00,0.00,2696.52,0.00,'2022-11-20 19:30:54','',''),(2718,'1','281','3',2,'Sale Id shift 205',0.00,0.00,0.00,145.57,0.00,'2022-11-20 19:30:54','',''),(2719,'1','281',NULL,2,'Sale Id shift 205',2501039.20,0.00,0.00,0.00,0.00,'2022-11-20 19:30:54','',''),(2720,'1','281','3',2,'Sale Id shift 206',0.00,0.00,0.00,136.75,0.00,'2022-11-21 06:19:56','',''),(2721,'1','281','3',2,'Sale Id shift 206',0.00,0.00,0.00,122.73,0.00,'2022-11-21 06:19:56','',''),(2722,'1','281',NULL,2,'Sale Id shift 206',228342.40,0.00,0.00,0.00,0.00,'2022-11-21 06:19:56','',''),(2723,'1','281','3',2,'Sale Id shift 207',0.00,0.00,0.00,107.97,0.00,'2022-11-21 21:01:58','',''),(2724,'1','281','3',2,'Sale Id shift 207',0.00,0.00,0.00,144.88,0.00,'2022-11-21 21:01:58','',''),(2725,'1','281',NULL,2,'Sale Id shift 207',222508.00,0.00,0.00,0.00,0.00,'2022-11-21 21:01:58','',''),(2726,'1','281',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,11440000.00,13000.00,0.00,0.00,'2022-11-21 21:02:32','',''),(2727,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,7400000.00,40000.00,0.00,0.00,'2022-11-21 21:05:03','',''),(2728,'1','281',NULL,1,'Reception corrector for bridging 235',0.00,0.00,0.00,15000.00,0.00,'2022-11-21 21:11:41','',''),(2729,'1','281','2',1,'Received from bridging 235',0.00,0.00,15000.00,0.00,0.00,'2022-11-21 21:11:41','',''),(2730,'1','281',NULL,1,'Reception corrector for bridging 234',0.00,0.00,0.00,25000.00,0.00,'2022-11-21 21:12:08','',''),(2731,'1','281','1',1,'Received from bridging 234',0.00,0.00,25000.00,0.00,0.00,'2022-11-21 21:12:08','',''),(2732,'1','281',NULL,2,'Reception corrector for bridging 236',0.00,0.00,0.00,13000.00,0.00,'2022-11-21 21:13:27','',''),(2733,'1','281','3',2,'Received from bridging 236',0.00,0.00,13000.00,0.00,0.00,'2022-11-21 21:13:27','',''),(2734,'1','281','3',2,'Sale Id shift 208',0.00,0.00,0.00,1974.76,0.00,'2022-11-22 07:57:16','',''),(2735,'1','281','3',2,'Sale Id shift 208',0.00,0.00,0.00,264.54,0.00,'2022-11-22 07:57:16','',''),(2736,'1','281',NULL,2,'Sale Id shift 208',1970584.00,0.00,0.00,0.00,0.00,'2022-11-22 07:57:16','',''),(2737,'1','281','1',1,'Sale Id shift 209',0.00,0.00,0.00,162.60,0.00,'2022-11-23 06:30:59','',''),(2738,'1','281','2',1,'Sale Id shift 209',0.00,0.00,0.00,6545.89,0.00,'2022-11-23 06:30:59','',''),(2739,'1','281','2',1,'Sale Id shift 209',0.00,0.00,0.00,0.05,0.00,'2022-11-23 06:30:59','',''),(2740,'1','281','3',2,'Sale Id shift 209',0.00,0.00,0.00,1335.56,0.00,'2022-11-23 06:30:59','',''),(2741,'1','281','3',2,'Sale Id shift 209',0.00,0.00,0.00,302.71,0.00,'2022-11-23 06:30:59','',''),(2742,'1','281','1',1,'Sale Id shift 209',0.00,0.00,0.00,7925.12,0.00,'2022-11-23 06:30:59','',''),(2743,'1','281','1',1,'Sale Id shift 209',0.00,0.00,0.00,4376.25,0.00,'2022-11-23 06:30:59','',''),(2744,'1','281','1',1,'Sale Id shift 209',0.00,0.00,0.00,8498.36,0.00,'2022-11-23 06:30:59','',''),(2745,'1','281','2',1,'Sale Id shift 209',0.00,0.00,0.00,6244.75,0.00,'2022-11-23 06:30:59','',''),(2746,'1','281',NULL,2,'Sale Id shift 209',1441677.60,0.00,0.00,0.00,0.00,'2022-11-23 06:30:59','',''),(2747,'1','281',NULL,1,'Sale Id shift 209',6244308.70,0.00,0.00,0.00,0.00,'2022-11-23 06:30:59','',''),(2748,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,5550000.00,30000.00,0.00,0.00,'2022-11-23 09:44:59','',''),(2749,'1','281',NULL,1,'Returned purchase #121 to AA RANO NIGERIA LTD',5550000.00,0.00,0.00,30000.00,0.00,'2022-11-23 09:45:31','',''),(2750,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,5485250.00,29650.00,0.00,0.00,'2022-11-23 16:18:16','',''),(2751,'1','281',NULL,1,'Reception corrector for bridging 238',0.00,0.00,0.00,9650.00,0.00,'2022-11-23 17:48:19','',''),(2752,'1','281','2',1,'Received from bridging 238',0.00,0.00,9650.00,0.00,0.00,'2022-11-23 17:48:19','',''),(2753,'1','281',NULL,1,'Reception corrector for bridging 237',0.00,0.00,0.00,20000.00,0.00,'2022-11-23 17:49:38','',''),(2754,'1','281','1',1,'Received from bridging 237',0.00,0.00,20000.00,0.00,0.00,'2022-11-23 17:49:38','',''),(2755,'1','281','2',1,'Sale Id shift 210',0.00,0.00,0.00,1954.63,0.00,'2022-11-23 20:42:43','',''),(2756,'1','281','2',1,'Sale Id shift 210',0.00,0.00,0.00,2641.81,0.00,'2022-11-23 20:42:43','',''),(2757,'1','281','2',1,'Sale Id shift 210',0.00,0.00,0.00,4808.48,0.00,'2022-11-23 20:42:43','',''),(2758,'1','281','3',2,'Sale Id shift 210',0.00,0.00,0.00,2256.93,0.00,'2022-11-23 20:42:43','',''),(2759,'1','281','3',2,'Sale Id shift 210',0.00,0.00,0.00,284.25,0.00,'2022-11-23 20:42:43','',''),(2760,'1','281','1',1,'Sale Id shift 210',0.00,0.00,0.00,2067.22,0.00,'2022-11-23 20:42:43','',''),(2761,'1','281','1',1,'Sale Id shift 210',0.00,0.00,0.00,2673.53,0.00,'2022-11-23 20:42:43','',''),(2762,'1','281','1',1,'Sale Id shift 210',0.00,0.00,0.00,4637.07,0.00,'2022-11-23 20:42:43','',''),(2763,'1','281','1',1,'Sale Id shift 210',0.00,0.00,0.00,2162.62,0.00,'2022-11-23 20:42:43','',''),(2764,'1','281','2',1,'Sale Id shift 210',0.00,0.00,0.00,2924.58,0.00,'2022-11-23 20:42:43','',''),(2765,'1','281','2',1,'Sale Id shift 210',0.00,0.00,0.00,4837.02,0.00,'2022-11-23 20:42:43','',''),(2766,'1','281',NULL,2,'Sale Id shift 210',2236238.40,0.00,0.00,0.00,0.00,'2022-11-23 20:42:43','',''),(2767,'1','281',NULL,1,'Sale Id shift 210',5310787.60,0.00,0.00,0.00,0.00,'2022-11-23 20:42:43','',''),(2768,'1','281','3',2,'Sale Id shift 211',0.00,0.00,0.00,410.67,0.00,'2022-11-24 07:48:28','',''),(2769,'1','281','3',2,'Sale Id shift 211',0.00,0.00,0.00,454.87,0.00,'2022-11-24 07:48:28','',''),(2770,'1','281',NULL,2,'Sale Id shift 211',761675.20,0.00,0.00,0.00,0.00,'2022-11-24 07:48:28','',''),(2771,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,37000.00,200.00,0.00,0.00,'2022-11-24 07:50:20','',''),(2772,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,2775000.00,15000.00,0.00,0.00,'2022-11-25 06:28:14','',''),(2773,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,64750.00,350.00,0.00,0.00,'2022-11-25 06:28:32','',''),(2774,'1','281','1',1,'Sale Id shift 212',0.00,0.00,0.00,661.52,0.00,'2022-11-25 06:29:30','',''),(2775,'1','281','2',1,'Sale Id shift 212',0.00,0.00,0.00,4040.96,0.00,'2022-11-25 06:29:30','',''),(2776,'1','281','2',1,'Sale Id shift 212',0.00,0.00,0.00,2525.17,0.00,'2022-11-25 06:29:30','',''),(2777,'1','281','3',2,'Sale Id shift 212',0.00,0.00,0.00,977.36,0.00,'2022-11-25 06:29:30','',''),(2778,'1','281','3',2,'Sale Id shift 212',0.00,0.00,0.00,1427.85,0.00,'2022-11-25 06:29:30','',''),(2779,'1','281','1',1,'Sale Id shift 212',0.00,0.00,0.00,4008.14,0.00,'2022-11-25 06:29:30','',''),(2780,'1','281','1',1,'Sale Id shift 212',0.00,0.00,0.00,2332.56,0.00,'2022-11-25 06:29:30','',''),(2781,'1','281','1',1,'Sale Id shift 212',0.00,0.00,0.00,1340.38,0.00,'2022-11-25 06:29:30','',''),(2782,'1','281','1',1,'Sale Id shift 212',0.00,0.00,0.00,4364.97,0.00,'2022-11-25 06:29:30','',''),(2783,'1','281','2',1,'Sale Id shift 212',0.00,0.00,0.00,2308.22,0.00,'2022-11-25 06:29:30','',''),(2784,'1','281','2',1,'Sale Id shift 212',0.00,0.00,0.00,543.94,0.00,'2022-11-25 06:29:30','',''),(2785,'1','281',NULL,2,'Sale Id shift 212',2116584.80,0.00,0.00,0.00,0.00,'2022-11-25 06:29:30','',''),(2786,'1','281',NULL,1,'Sale Id shift 212',4093284.10,0.00,0.00,0.00,0.00,'2022-11-25 06:29:30','',''),(2787,'1','281',NULL,1,'Reception corrector for bridging 239',0.00,0.00,0.00,350.00,0.00,'2022-11-25 06:38:58','',''),(2788,'1','281','1',1,'Received from bridging 239',0.00,0.00,350.00,0.00,0.00,'2022-11-25 06:38:58','',''),(2789,'1','281',NULL,1,'Reception corrector for bridging 240',0.00,0.00,0.00,15000.00,0.00,'2022-11-25 06:41:01','',''),(2790,'1','281','1',1,'Received from bridging 240',0.00,0.00,15000.00,0.00,0.00,'2022-11-25 06:41:01','',''),(2791,'1','281',NULL,1,'Reception corrector for bridging 241',0.00,0.00,0.00,200.00,0.00,'2022-11-25 06:43:15','',''),(2792,'1','281','2',1,'Received from bridging 241',0.00,0.00,200.00,0.00,0.00,'2022-11-25 06:43:15','',''),(2793,'1','281','3',2,'Sale Id shift 213',0.00,0.00,0.00,3480.03,0.00,'2022-11-25 08:21:18','',''),(2794,'1','281','3',2,'Sale Id shift 213',0.00,0.00,0.00,1289.19,0.00,'2022-11-25 08:21:18','',''),(2795,'1','281',NULL,2,'Sale Id shift 213',4196913.60,0.00,0.00,0.00,0.00,'2022-11-25 08:21:18','',''),(2796,'1','281','1',1,'Sale Id shift 214',0.00,0.00,0.00,4326.92,0.00,'2022-11-25 20:36:08','',''),(2797,'1','281','2',1,'Sale Id shift 214',0.00,0.00,0.00,4362.21,0.00,'2022-11-25 20:36:08','',''),(2798,'1','281','3',2,'Sale Id shift 214',0.00,0.00,0.00,453.66,0.00,'2022-11-25 20:36:08','',''),(2799,'1','281','3',2,'Sale Id shift 214',0.00,0.00,0.00,516.85,0.00,'2022-11-25 20:36:08','',''),(2800,'1','281','1',1,'Sale Id shift 214',0.00,0.00,0.00,4074.58,0.00,'2022-11-25 20:36:08','',''),(2801,'1','281','1',1,'Sale Id shift 214',0.00,0.00,0.00,8479.69,0.00,'2022-11-25 20:36:08','',''),(2802,'1','281','1',1,'Sale Id shift 214',0.00,0.00,0.00,4379.49,0.00,'2022-11-25 20:36:08','',''),(2803,'1','281','2',1,'Sale Id shift 214',0.00,0.00,0.00,4343.27,0.00,'2022-11-25 20:36:08','',''),(2804,'1','281',NULL,2,'Sale Id shift 214',854048.80,0.00,0.00,0.00,0.00,'2022-11-25 20:36:08','',''),(2805,'1','281',NULL,1,'Sale Id shift 214',5543739.60,0.00,0.00,0.00,0.00,'2022-11-25 20:36:08','',''),(2806,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,6290000.00,34000.00,0.00,0.00,'2022-11-25 20:47:45','',''),(2807,'1','281',NULL,1,'Reception corrector for bridging 242',0.00,0.00,0.00,17000.00,0.00,'2022-11-25 21:34:40','',''),(2808,'1','281','1',1,'Received from bridging 242',0.00,0.00,17000.00,0.00,0.00,'2022-11-25 21:34:40','',''),(2809,'1','281',NULL,1,'Reception corrector for bridging 243',0.00,0.00,0.00,17000.00,0.00,'2022-11-25 21:35:09','',''),(2810,'1','281','2',1,'Received from bridging 243',0.00,0.00,17000.00,0.00,0.00,'2022-11-25 21:35:09','',''),(2811,'1','281','3',2,'Sale Id shift 215',0.00,0.00,0.00,2302.11,0.00,'2022-11-26 07:45:55','',''),(2812,'1','281','3',2,'Sale Id shift 215',0.00,0.00,0.00,1425.79,0.00,'2022-11-26 07:45:55','',''),(2813,'1','281',NULL,2,'Sale Id shift 215',3280552.00,0.00,0.00,0.00,0.00,'2022-11-26 07:45:55','',''),(2814,'1','281','1',1,'Sale Id shift 216',0.00,0.00,0.00,3057.67,0.00,'2022-11-26 15:44:28','',''),(2815,'1','281','2',1,'Sale Id shift 216',0.00,0.00,0.00,3020.32,0.00,'2022-11-26 15:44:28','',''),(2816,'1','281','3',2,'Sale Id shift 216',0.00,0.00,0.00,502.28,0.00,'2022-11-26 15:44:28','',''),(2817,'1','281','3',2,'Sale Id shift 216',0.00,0.00,0.00,113.12,0.00,'2022-11-26 15:44:28','',''),(2818,'1','281','1',1,'Sale Id shift 216',0.00,0.00,0.00,3185.54,0.00,'2022-11-26 15:44:28','',''),(2819,'1','281','1',1,'Sale Id shift 216',0.00,0.00,0.00,3119.82,0.00,'2022-11-26 15:44:28','',''),(2820,'1','281','1',1,'Sale Id shift 216',0.00,0.00,0.00,3090.23,0.00,'2022-11-26 15:44:28','',''),(2821,'1','281','2',1,'Sale Id shift 216',0.00,0.00,0.00,2833.77,0.00,'2022-11-26 15:44:28','',''),(2822,'1','281',NULL,2,'Sale Id shift 216',535398.00,0.00,0.00,0.00,0.00,'2022-11-26 15:44:28','',''),(2823,'1','281',NULL,1,'Sale Id shift 216',3386859.75,0.00,0.00,0.00,0.00,'2022-11-26 15:44:28','',''),(2824,'1','281','1',1,'Sale Id shift 217',0.00,0.00,0.00,2762.65,0.00,'2022-11-27 07:46:42','',''),(2825,'1','281','2',1,'Sale Id shift 217',0.00,0.00,0.00,2554.40,0.00,'2022-11-27 07:46:42','',''),(2826,'1','281','3',2,'Sale Id shift 217',0.00,0.00,0.00,632.88,0.00,'2022-11-27 07:46:42','',''),(2827,'1','281','3',2,'Sale Id shift 217',0.00,0.00,0.00,114.97,0.00,'2022-11-27 07:46:42','',''),(2828,'1','281','1',1,'Sale Id shift 217',0.00,0.00,0.00,2827.96,0.00,'2022-11-27 07:46:42','',''),(2829,'1','281','1',1,'Sale Id shift 217',0.00,0.00,0.00,2473.24,0.00,'2022-11-27 07:46:42','',''),(2830,'1','281','1',1,'Sale Id shift 217',0.00,0.00,0.00,2500.02,0.00,'2022-11-27 07:46:42','',''),(2831,'1','281','2',1,'Sale Id shift 217',0.00,0.00,0.00,2490.90,0.00,'2022-11-27 07:46:42','',''),(2832,'1','281',NULL,2,'Sale Id shift 217',650629.50,0.00,0.00,0.00,0.00,'2022-11-27 07:46:42','',''),(2833,'1','281',NULL,1,'Sale Id shift 217',2887696.45,0.00,0.00,0.00,0.00,'2022-11-27 07:46:42','',''),(2834,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,5365000.00,29000.00,0.00,0.00,'2022-11-27 10:45:15','',''),(2835,'1','281',NULL,1,'Reception corrector for bridging 244',0.00,0.00,0.00,20000.00,0.00,'2022-11-27 10:49:04','',''),(2836,'1','281','1',1,'Received from bridging 244',0.00,0.00,20000.00,0.00,0.00,'2022-11-27 10:49:04','',''),(2837,'1','281',NULL,1,'Reception corrector for bridging 245',0.00,0.00,0.00,9000.00,0.00,'2022-11-27 10:50:14','',''),(2838,'1','281','2',1,'Received from bridging 245',0.00,0.00,9000.00,0.00,0.00,'2022-11-27 10:50:14','',''),(2839,'1','281','2',1,'Sale Id shift 218',0.00,0.00,0.00,5364.07,0.00,'2022-11-27 20:17:43','',''),(2840,'1','281','2',1,'Sale Id shift 218',0.00,0.00,0.00,4577.00,0.00,'2022-11-27 20:17:43','',''),(2841,'1','281','3',2,'Sale Id shift 218',0.00,0.00,0.00,1217.34,0.00,'2022-11-27 20:17:43','',''),(2842,'1','281','3',2,'Sale Id shift 218',0.00,0.00,0.00,112.76,0.00,'2022-11-27 20:17:43','',''),(2843,'1','281','1',1,'Sale Id shift 218',0.00,0.00,0.00,4678.49,0.00,'2022-11-27 20:17:43','',''),(2844,'1','281','1',1,'Sale Id shift 218',0.00,0.00,0.00,4886.34,0.00,'2022-11-27 20:17:43','',''),(2845,'1','281','2',1,'Sale Id shift 218',0.00,0.00,0.00,4813.55,0.00,'2022-11-27 20:17:43','',''),(2846,'1','281','2',1,'Sale Id shift 218',0.00,0.00,0.00,4433.41,0.00,'2022-11-27 20:17:43','',''),(2847,'1','281',NULL,2,'Sale Id shift 218',1157187.00,0.00,0.00,0.00,0.00,'2022-11-27 20:17:43','',''),(2848,'1','281',NULL,1,'Sale Id shift 218',5319279.10,0.00,0.00,0.00,0.00,'2022-11-27 20:17:43','',''),(2849,'1','281','3',2,'Sale Id shift 219',0.00,0.00,0.00,173.51,0.00,'2022-11-28 08:31:52','',''),(2850,'1','281','3',2,'Sale Id shift 219',0.00,0.00,0.00,106.34,0.00,'2022-11-28 08:31:52','',''),(2851,'1','281',NULL,2,'Sale Id shift 219',243469.50,0.00,0.00,0.00,0.00,'2022-11-28 08:31:52','',''),(2852,'1','281','3',2,'Sale Id shift 220',0.00,0.00,0.00,242.65,0.00,'2022-11-28 20:30:11','',''),(2853,'1','281','3',2,'Sale Id shift 220',0.00,0.00,0.00,227.23,0.00,'2022-11-28 20:30:11','',''),(2854,'1','281',NULL,2,'Sale Id shift 220',408795.60,0.00,0.00,0.00,0.00,'2022-11-28 20:30:11','',''),(2855,'1','281','3',2,'Sale Id shift 221',0.00,0.00,0.00,436.10,0.00,'2022-11-29 08:02:29','',''),(2856,'1','281','3',2,'Sale Id shift 221',0.00,0.00,0.00,130.77,0.00,'2022-11-29 08:02:29','',''),(2857,'1','281',NULL,2,'Sale Id shift 221',493176.90,0.00,0.00,0.00,0.00,'2022-11-29 08:02:29','',''),(2858,'1','281','3',2,'Sale Id shift 222',0.00,0.00,0.00,361.15,0.00,'2022-11-29 17:00:02','',''),(2859,'1','281','3',2,'Sale Id shift 222',0.00,0.00,0.00,170.27,0.00,'2022-11-29 17:00:02','',''),(2860,'1','281',NULL,2,'Sale Id shift 222',462335.40,0.00,0.00,0.00,0.00,'2022-11-29 17:00:02','',''),(2861,'1','281','3',2,'Sale Id shift 223',0.00,0.00,0.00,251.83,0.00,'2022-11-30 07:42:51','',''),(2862,'1','281','3',2,'Sale Id shift 223',0.00,0.00,0.00,149.89,0.00,'2022-11-30 07:42:51','',''),(2863,'1','281',NULL,2,'Sale Id shift 223',353513.60,0.00,0.00,0.00,0.00,'2022-11-30 07:42:51','',''),(2864,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,5550000.00,30000.00,0.00,0.00,'2022-11-30 07:43:07','',''),(2865,'1','281',NULL,1,'Reception corrector for bridging 247',0.00,0.00,0.00,10000.00,0.00,'2022-11-30 17:25:15','',''),(2866,'1','281','2',1,'Received from bridging 247',0.00,0.00,10000.00,0.00,0.00,'2022-11-30 17:25:16','',''),(2867,'1','281',NULL,1,'Reception corrector for bridging 246',0.00,0.00,0.00,20000.00,0.00,'2022-11-30 17:25:33','',''),(2868,'1','281','1',1,'Received from bridging 246',0.00,0.00,20000.00,0.00,0.00,'2022-11-30 17:25:33','',''),(2869,'1','281','1',1,'Sale Id shift 224',0.00,0.00,0.00,4584.78,0.00,'2022-11-30 21:28:28','',''),(2870,'1','281','2',1,'Sale Id shift 224',0.00,0.00,0.00,4861.79,0.00,'2022-11-30 21:28:28','',''),(2871,'1','281','3',2,'Sale Id shift 224',0.00,0.00,0.00,1073.15,0.00,'2022-11-30 21:28:28','',''),(2872,'1','281','3',2,'Sale Id shift 224',0.00,0.00,0.00,230.60,0.00,'2022-11-30 21:28:28','',''),(2873,'1','281','1',1,'Sale Id shift 224',0.00,0.00,0.00,4879.49,0.00,'2022-11-30 21:28:28','',''),(2874,'1','281','1',1,'Sale Id shift 224',0.00,0.00,0.00,4914.34,0.00,'2022-11-30 21:28:28','',''),(2875,'1','281','1',1,'Sale Id shift 224',0.00,0.00,0.00,5161.99,0.00,'2022-11-30 21:28:28','',''),(2876,'1','281','2',1,'Sale Id shift 224',0.00,0.00,0.00,5177.09,0.00,'2022-11-30 21:28:28','',''),(2877,'1','281',NULL,2,'Sale Id shift 224',1147300.00,0.00,0.00,0.00,0.00,'2022-11-30 21:28:28','',''),(2878,'1','281',NULL,1,'Sale Id shift 224',5472203.80,0.00,0.00,0.00,0.00,'2022-11-30 21:28:28','',''),(2879,'1','281','1',1,'Sale Id shift 225',0.00,0.00,0.00,338.48,0.00,'2022-12-01 07:27:41','',''),(2880,'1','281','3',2,'Sale Id shift 225',0.00,0.00,0.00,404.21,0.00,'2022-12-01 07:27:41','',''),(2881,'1','281','3',2,'Sale Id shift 225',0.00,0.00,0.00,110.93,0.00,'2022-12-01 07:27:41','',''),(2882,'1','281',NULL,2,'Sale Id shift 225',453323.20,0.00,0.00,0.00,0.00,'2022-12-01 07:27:41','',''),(2883,'1','281',NULL,1,'Sale Id shift 225',62618.80,0.00,0.00,0.00,0.00,'2022-12-01 07:27:41','',''),(2884,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,5550000.00,30000.00,0.00,0.00,'2022-12-01 11:39:03','',''),(2885,'1','281',NULL,1,'Reception corrector for bridging 248',0.00,0.00,0.00,15000.00,0.00,'2022-12-01 11:44:41','',''),(2886,'1','281','1',1,'Received from bridging 248',0.00,0.00,15000.00,0.00,0.00,'2022-12-01 11:44:41','',''),(2887,'1','281',NULL,1,'Reception corrector for bridging 249',0.00,0.00,0.00,15000.00,0.00,'2022-12-01 11:45:07','',''),(2888,'1','281','2',1,'Received from bridging 249',0.00,0.00,15000.00,0.00,0.00,'2022-12-01 11:45:07','',''),(2889,'1','281','1',1,'Sale Id shift 226',0.00,0.00,0.00,203.22,0.00,'2022-12-01 16:27:33','',''),(2890,'1','281','3',2,'Sale Id shift 226',0.00,0.00,0.00,242.75,0.00,'2022-12-01 16:27:33','',''),(2891,'1','281','3',2,'Sale Id shift 226',0.00,0.00,0.00,114.00,0.00,'2022-12-01 16:27:33','',''),(2892,'1','281',NULL,2,'Sale Id shift 226',313940.00,0.00,0.00,0.00,0.00,'2022-12-01 16:27:33','',''),(2893,'1','281',NULL,1,'Sale Id shift 226',37595.70,0.00,0.00,0.00,0.00,'2022-12-01 16:27:33','',''),(2894,'1','281',NULL,2,'Purchased from AA RANO NIGERIA LTD',0.00,14960000.00,17000.00,0.00,0.00,'2022-12-02 07:52:08','',''),(2895,'1','281',NULL,2,'Reception corrector for bridging 250',0.00,0.00,0.00,17000.00,0.00,'2022-12-02 08:08:16','',''),(2896,'1','281','3',2,'Received from bridging 250',0.00,0.00,17000.00,0.00,0.00,'2022-12-02 08:08:16','',''),(2897,'1','281',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,5550000.00,30000.00,0.00,0.00,'2022-12-02 08:28:02','',''),(2898,'1','281',NULL,1,'Reception corrector for bridging 251',0.00,0.00,0.00,10000.00,0.00,'20