-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_277
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_277`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_277` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_277`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,500,'',0,'6.1','1','277','CASH','','2022-07-17 12:32:46',5,0.00,0.00,'','479','2022-07-17 12:32:46','479',0,0),(2,7000,'',0,'20','1','277','SALES','','2022-07-17 12:32:59',5,0.00,0.00,'','479','2022-07-17 12:32:59','479',0,0),(3,4000,'',0,'22','1','277','PURCHASES','','2022-07-17 12:33:12',5,0.00,0.00,'','479','2022-07-17 12:33:12','479',0,0),(4,8000,'',0,'24','1','277','PURCHASES','','2022-07-17 12:33:43',5,0.00,0.00,'','479','2022-07-17 12:33:43','479',0,0),(5,8001,'',0,'24','1','277','SALARIES & WAGES','','2022-07-17 12:34:07',5,0.00,0.00,'','479','2022-07-17 12:34:07','479',0,0),(6,2500,'',0,'2','1','277','ZNB-:POS 1015965368','','2022-07-17 12:38:20',5,0.00,0.00,'','479','2022-07-17 12:38:20','479',0,0),(7,2501,'',0,'2','1','277','FID POS COLLECTION-5620141491','','2022-07-17 12:39:09',5,0.00,0.00,'','479','2022-07-17 12:39:09','479',0,0),(8,2502,'',0,'2','1','277','DANKANO-EBILLS:ZNB1014717618','','2022-07-17 12:39:27',5,0.00,0.00,'','479','2022-07-17 12:39:27','479',0,0),(9,2503,'',0,'2','1','277','E-BILLS  IBAL 1015372548','','2022-07-17 12:39:44',5,0.00,0.00,'','479','2022-07-17 12:39:44','479',0,0),(10,2504,'',0,'2','1','277','TAJJ BANK CITY GATE:0001875361','','2022-07-17 12:39:58',5,0.00,0.00,'','479','2022-07-17 12:39:58','479',0,0),(11,2505,'',0,'2','1','277','UBA LPG COLL ACCT:-1020811140','UBA LPG COLLECTION ACCOUNT','2023-02-09 16:56:48',5,0.00,0.00,'','792','2023-02-09 16:56:48','792',0,0),(12,2506,'',0,'2','1','277','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:05:14',5,0.00,0.00,'','792','2023-02-20 14:05:14','792',0,0),(13,2507,'',0,'2','1','277','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:16:54',5,0.00,0.00,'2023-03-17','792','2023-03-17 12:22:31','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','1','277','EJIKE GAS','EJIKE','08137699682','ejikefranko@yahoo.com','Gwagwalada','Abuja','Big Sheda Garage Kwali Area Council Abuja','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-25 17:18:34',5,'911','2022-07-25 17:18:34','911'),(2,'','1','277','PETER GAS','Peter','08169622003','petergas@gmail.com','GWAGWALADA','Abuja','Opposite Specialist  (University Of Abuja) ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-26 09:30:58',5,'911','2022-07-26 09:30:58','911'),(3,'','1','277','SUNY GAS','Sunday ','08062497287','sunygas@gmail.com','Gwagwalada','Abuja','Gwagwalada Market','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-29 13:42:49',5,'911','2022-07-29 13:42:49','911'),(4,'','1','277','NNMANDI ENTERPRISES','NNMANDI EZE VINCENT','09065858751','nnmandienterprises@gmail.com','Kwali','Abuja','Wako, Kwali FCT','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-30 18:49:22',5,'911','2022-07-30 18:49:22','911'),(5,'','1','277','Operational lost','Bulk sales','07066026467','adamadamsalisu@gmail.com','Kano','Kano','Asokoro','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-31 19:57:34',5,'911','2022-07-31 19:57:34','911'),(6,'','1','277','ABDUL GAS','Abdul','08105355989','abdul01@gmail.com','Gwagwalada','Abuja','Gwako II','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-01 10:47:41',5,'911','2022-08-01 10:47:41','911'),(7,'','1','277','OK GAS','Nweke  OKWUGILI','08036487238','nweke@gmail.com','Gwagwalada','Abuja','No 1 Sharp Corner Road G/Gafa','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-02 10:32:02',5,'911','2022-08-02 10:32:02','911'),(8,'','1','277','John Gas','Johon ','07042939626','johon@gmail.com','Gwagwalada','Abuja','Gwako','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-03 10:16:36',5,'911','2022-08-03 10:16:36','911'),(9,'','1','277','MUSA GAS','MUSA','08053884316','musa@gmail.com','Gwagwalada','Abuja','Dabi Gwali','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-03 18:54:39',5,'911','2022-08-03 18:54:39','911'),(10,'','1','277','ADADA GAS','Adada','07065751612','adada@gmail.com','Gwagwalada','Abuja','Gwagwalada','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-04 07:24:37',5,'911','2022-08-04 07:24:37','911'),(11,'','1','277','Ibrahim GAS','Ibrahim Bala','0811666433','ibrahim@gmail.com','Gwagwalada','Abuja','Gwagwalada','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-04 11:43:41',5,'911','2022-08-04 11:43:41','911'),(12,'','1','277','EJIMA GAS','EJIMA','09037904308','ejima@gmail.com','Gwagwalada','Abuja','Gwagwalada','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-07 13:02:54',5,'911','2022-08-07 13:02:54','911'),(13,'','1','277','O and G GAS','Chijioke ','08037120629','chijioke@gmail.com','Gwagwalada','Abuja','Gwagwalada Abuja','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-16 13:52:02',5,'911','2022-08-16 13:52:02','911'),(14,'','1','277','HOLUWASUMMER GAS','YEMI','08086811334','yemi@gmail.com','Kwali','Abuja','SATELLITE QUATERS KWALI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-16 14:37:05',5,'911','2022-08-16 14:37:05','911'),(15,'','1','277','Zion Gas And Resouces','ZION','09161187173','zion@gmail.com','Gwagwalada','Abuja','Gwako 2 Car Wash Junction Behind Eddy Garden Gwako','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-30 11:54:48',5,'911','2022-08-30 11:54:48','911'),(16,'','1','277','Tobias gas','Tobias gas','08169331334','tobias@gmail.com','Gwagwalada','Abuja','Dabi Kwali Area','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-06 09:23:02',5,'911','2022-09-06 09:23:02','911'),(17,'','1','277','Vincent','VINCENT GAS ','08060959492','vincent@gmail.com','Gwagwalada','Abuja','Student Villa','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-28 09:45:23',5,'911','2022-11-28 09:45:23','911'),(18,'','1','277','A A JOHN GAS','A A John','07033789930','chukuku@gmail.com','Gwagwalada','Abuja','Chukuku','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-02 13:40:57',5,'911','2022-12-02 13:40:57','911'),(19,'','1','277','A A JOHN GASS','A A John','07033789930','chukuku@gmail.com','Gwagwalada','Abuja','Chukuku','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-02 13:41:33',5,'911','2022-12-02 13:41:33','911'),(20,'','1','277','Ibrahim Abubakar Gas','Ibrahim Abubakar','09038605796','ibrahim@gmail.com','Gwagwalada','Abuja','Doma','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-10 14:04:17',5,'911','2022-12-10 14:04:17','911'),(21,'','1','277','VICTOR GAS','VICTOR','0904777235','chukuku@gmail.com','Gwagwalada','Abuja','Chukuku','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-30 14:14:35',5,'911','2022-12-30 14:14:35','911'),(22,'','1','277','OLUWAFEMI GAS','OLUWAFEMI','08147903368','mcjeffson07@gmail.com','Kwali','Abuja','Bako beside Airtel mass Kwali Area Council FCT Abuja','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-02 15:12:50',5,'911','2023-01-02 15:12:50','911'),(23,'','1','277','JOHNNY EZIKE & CO Gas','Darlington Ezike A Gas','08068459702','johnny@gmail.com','Gwagwalada','Abuja','Wako Outside  by Welder yard','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-09 15:34:50',5,'911','2023-01-09 15:34:50','911'),(24,'','1','277','Darling Gas','Darling Gas','08094359254','darling@gmail.com','Gwagwalada','Abuja','Gwako','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-22 09:51:09',5,'911','2023-01-22 09:51:09','911'),(25,'','1','277','Sunnah Gas','Sunnah Gas','08052836869','abusumaiya33@yahoo.com','Abaji','Abuja','Abaji','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-03 08:38:26',5,'911','2023-02-03 08:38:26','911'),(26,'','1','277','Usman She\'idu Gas','Usman Gas','08109994313','usman01@gmail.com','Gwagwalada','Abuja','Chukwukwu','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-03 08:40:52',5,'911','2023-02-03 08:40:52','911');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','277','1',1,'5','LPG NOZZLE 1',182337.84,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','277','1',2,'5','LPG NOZZLE 2',24402.70,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=271 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','277',1,'DAILY SHIFT','2022-07-17','2022-07-17 13:11:43','2022-07-18 13:11:43','911',0.00,0.00,'911','2022-07-17 20:11:22','911','2022-07-17 20:11:53',10,0),('1','277',2,'DAILY SHIFT94094','2022-07-18','2022-07-18 06:25:20','2022-07-19 06:25:20','911',0.00,0.00,'911','2022-07-18 23:04:14','911','2022-07-18 23:05:34',10,0),('1','277',3,'DAILY SHIFT','2022-07-19','2022-07-19 06:50:30','2022-07-20 06:50:30','911',0.00,0.00,'911','2022-07-19 22:13:55','911','2022-07-19 22:15:00',10,0),('1','277',4,'DAILY SHIFT','2022-07-20','2022-07-20 06:49:54','2022-07-21 06:49:54','911',0.00,0.00,'911','2022-07-20 22:54:45','911','2022-07-20 22:55:14',10,0),('1','277',5,'DAILY SHIFT','2022-07-21','2022-07-21 06:56:41','2022-07-22 06:56:41','911',0.00,0.00,'911','2022-07-21 20:04:17','911','2022-07-21 20:05:01',10,0),('1','277',6,'DAILY SHIFT','2022-07-22','2022-07-22 06:37:08','2022-07-23 06:37:08','911',0.00,0.00,'911','2022-07-22 21:44:01','911','2022-07-22 21:44:46',10,0),('1','277',7,'DAILY SHIFT','2022-07-23','2022-07-23 06:47:48','2022-07-24 06:47:48','911',0.00,0.00,'911','2022-07-23 22:57:38','911','2022-07-23 22:58:05',10,0),('1','277',8,'DAILY SHIFT','2022-07-24','2022-07-24 05:52:27','2022-07-25 05:52:27','911',0.00,0.00,'911','2022-07-24 22:14:36','911','2022-07-24 22:15:48',10,0),('1','277',9,'DAILY SHIFT','2022-07-25','2022-07-25 06:16:08','2022-07-26 06:16:08','911',0.00,0.00,'911','2022-07-25 23:53:01','911','2022-07-25 23:53:21',10,0),('1','277',10,'DAILY SHIFT','2022-07-26','2022-07-26 05:50:25','2022-07-27 05:50:25','911',0.00,0.00,'911','2022-07-26 21:29:20','911','2022-07-26 21:29:51',10,0),('1','277',11,'DAILY SHIFT','2022-07-27','2022-07-27 06:04:06','2022-07-28 06:04:06','911',0.00,0.00,'911','2022-07-27 23:11:58','911','2022-07-27 23:12:37',10,0),('1','277',12,'DAILY SHIFT','2022-07-28','2022-07-28 05:56:29','2022-07-29 05:56:29','911',0.00,0.00,'911','2022-07-28 20:17:12','911','2022-07-28 20:17:38',10,0),('1','277',13,'DAILY SHIFT','2022-07-29','2022-07-29 05:41:25','2022-07-30 05:41:25','911',0.00,0.00,'911','2022-07-29 23:15:04','911','2022-07-29 23:15:47',10,0),('1','277',14,'DAILY SHIFT','2022-07-30','2022-07-30 06:24:55','2022-07-31 06:24:55','911',0.00,0.00,'911','2022-07-30 21:04:27','911','2022-07-30 21:05:55',10,0),('1','277',15,'DAILY SHIFT','2022-07-31','2022-07-31 06:04:07','2022-08-01 06:04:07','911',0.00,0.00,'911','2022-07-31 20:02:22','911','2022-07-31 20:05:40',10,0),('1','277',16,'Operational lost','2022-07-31','2022-07-31 20:22:45','2022-08-01 20:22:45','911',0.00,0.00,'911','2022-07-31 20:28:03','911','2022-07-31 20:28:21',10,0),('1','277',17,'DAILY SHIFT','2022-08-01','2022-08-01 06:57:10','2022-08-02 06:57:10','911',0.00,0.00,'911','2022-08-01 22:33:41','911','2022-08-01 22:34:14',10,0),('1','277',18,'DAILY SHIFT','2022-08-02','2022-08-02 06:17:24','2022-08-03 06:17:24','911',0.00,0.00,'911','2022-08-02 20:42:13','911','2022-08-02 20:42:42',10,0),('1','277',19,'DAILY SHIFT','2022-08-03','2022-08-03 06:04:05','2022-08-04 06:04:05','911',0.00,0.00,'911','2022-08-03 21:20:13','911','2022-08-03 21:20:43',10,0),('1','277',20,'DAILY SHIFT','2022-08-04','2022-08-04 06:09:15','2022-08-05 06:09:15','911',0.00,0.00,'911','2022-08-04 22:06:28','911','2022-08-04 22:07:01',10,0),('1','277',21,'DAILY SHIFT','2022-08-05','2022-08-05 06:32:48','2022-08-06 06:32:48','911',0.00,0.00,'911','2022-08-05 21:29:04','911','2022-08-05 21:29:27',10,0),('1','277',22,'DAILY SHIFT','2022-08-06','2022-08-06 06:21:44','2022-08-07 06:21:44','911',0.00,0.00,'911','2022-08-06 19:53:55','911','2022-08-06 19:54:30',10,0),('1','277',23,'DAILY SHIFT','2022-08-07','2022-08-07 05:59:10','2022-08-08 05:59:10','911',0.00,0.00,'911','2022-08-07 20:56:21','911','2022-08-07 20:57:10',10,0),('1','277',24,'DAILY SHIFT','2022-08-08','2022-08-08 05:47:07','2022-08-09 05:47:07','911',0.00,0.00,'911','2022-08-08 19:56:07','911','2022-08-08 19:57:09',10,0),('1','277',25,'DAILY SHIFT','2022-08-09','2022-08-09 06:12:28','2022-08-10 06:12:28','911',0.00,0.00,'911','2022-08-09 20:38:23','911','2022-08-09 20:38:44',10,0),('1','277',26,'DAILY SHIFT','2022-08-10','2022-08-10 06:19:42','2022-08-11 06:19:42','911',0.00,0.00,'911','2022-08-10 19:40:53','911','2022-08-10 19:41:19',10,0),('1','277',27,'DAILY SHIFT','2022-08-11','2022-08-11 06:15:34','2022-08-12 06:15:34','911',0.00,0.00,'911','2022-08-11 20:20:31','911','2022-08-11 20:20:52',10,0),('1','277',28,'DAILY SHIFT','2022-08-12','2022-08-12 06:17:45','2022-08-13 06:17:45','911',0.00,0.00,'911','2022-08-12 20:15:12','911','2022-08-12 20:15:42',10,0),('1','277',29,'DAILY SHIFT','2022-08-13','2022-08-13 06:29:58','2022-08-14 06:29:58','911',0.00,0.00,'911','2022-08-13 21:00:39','911','2022-08-13 21:01:04',10,0),('1','277',30,'DAILY SHIFT','2022-08-14','2022-08-14 06:21:18','2022-08-15 06:21:18','911',0.00,0.00,'911','2022-08-14 20:24:03','911','2022-08-14 20:24:23',10,0),('1','277',31,'DAILY SHIFT','2022-08-15','2022-08-15 06:48:49','2022-08-16 06:48:49','911',0.00,0.00,'911','2022-08-15 21:03:37','911','2022-08-15 21:04:21',10,0),('1','277',32,'DAILY SHIFT','2022-08-16','2022-08-16 06:18:11','2022-08-17 06:18:11','911',0.00,0.00,'911','2022-08-16 19:57:54','911','2022-08-16 19:58:19',10,0),('1','277',33,'DAILY SHIFT','2022-08-17','2022-08-17 06:00:41','2022-08-18 06:00:41','911',0.00,0.00,'911','2022-08-17 21:29:39','911','2022-08-17 21:30:05',10,0),('1','277',34,'DAILY SHIFT','2022-08-18','2022-08-18 06:22:42','2022-08-19 06:22:42','911',0.00,0.00,'911','2022-08-18 20:15:43','911','2022-08-18 20:16:06',10,0),('1','277',35,'DAILY SHIFT','2022-08-19','2022-08-19 06:10:48','2022-08-20 06:10:48','911',0.00,0.00,'911','2022-08-19 21:41:49','911','2022-08-19 21:42:09',10,0),('1','277',36,'DAILY SHIFT','2022-08-20','2022-08-20 06:40:57','2022-08-21 06:40:57','911',0.00,0.00,'911','2022-08-20 20:19:22','911','2022-08-20 20:19:44',10,0),('1','277',37,'DAILY SHIFT','2022-08-21','2022-08-21 06:14:28','2022-08-22 06:14:28','911',0.00,0.00,'911','2022-08-22 06:05:40','911','2022-08-22 06:05:57',10,0),('1','277',38,'DAILY SHIFT','2022-08-22','2022-08-22 06:06:36','2022-08-23 06:06:36','911',0.00,0.00,'911','2022-08-22 20:53:42','911','2022-08-22 20:54:03',10,0),('1','277',39,'DAILY SHIFT','2022-08-23','2022-08-23 06:16:23','2022-08-24 06:16:23','911',0.00,0.00,'911','2022-08-23 20:03:54','911','2022-08-23 20:04:12',10,0),('1','277',40,'DAILY SHIFT','2022-08-24','2022-08-24 06:11:31','2022-08-25 06:11:31','911',0.00,0.00,'911','2022-08-24 21:20:01','911','2022-08-24 21:20:22',10,0),('1','277',41,'DAILY SHIFT','2022-08-25','2022-08-25 06:57:12','2022-08-26 06:57:12','911',0.00,0.00,'911','2022-08-25 20:27:22','911','2022-08-25 20:27:40',10,0),('1','277',42,'DAILY SHIFT','2022-08-26','2022-08-26 06:16:03','2022-08-27 06:16:03','911',0.00,0.00,'911','2022-08-26 20:25:47','911','2022-08-26 20:26:52',10,0),('1','277',43,'DAILY SHIFT','2022-08-27','2022-08-27 06:22:39','2022-08-28 06:22:39','911',0.00,0.00,'911','2022-08-27 21:07:13','911','2022-08-27 21:07:36',10,0),('1','277',44,'DAILY SHIFT','2022-08-28','2022-08-28 11:31:17','2022-08-29 11:31:17','911',0.00,0.00,'911','2022-08-28 20:23:25','911','2022-08-28 20:23:48',10,0),('1','277',45,'DAILY SHIFT','2022-08-29','2022-08-29 06:05:54','2022-08-30 06:05:54','911',0.00,0.00,'911','2022-08-29 20:00:35','911','2022-08-29 20:01:20',10,0),('1','277',46,'DAILY SHIFT','2022-08-30','2022-08-30 06:19:08','2022-08-31 06:19:08','911',0.00,0.00,'911','2022-08-30 19:55:11','911','2022-08-30 19:55:27',10,0),('1','277',47,'DAILY SHIFT','2022-08-31','2022-08-31 06:23:26','2022-09-01 06:23:26','911',0.00,0.00,'911','2022-08-31 19:44:07','911','2022-08-31 19:44:25',10,0),('1','277',48,'DAILY SHIFT','2022-09-01','2022-09-01 06:12:07','2022-09-02 06:12:07','911',0.00,0.00,'911','2022-09-02 06:33:40','911','2022-09-02 06:34:02',10,0),('1','277',49,'DAILY SHIFT','2022-09-02','2022-09-02 06:34:37','2022-09-03 06:34:37','911',0.00,0.00,'911','2022-09-02 19:40:20','911','2022-09-02 19:40:41',10,0),('1','277',50,'DAILY SHIFT','2022-09-03','2022-09-03 06:00:09','2022-09-04 06:00:09','911',0.00,0.00,'911','2022-09-03 10:23:22','911','2022-09-03 10:23:46',10,0),('1','277',51,'DAILY SHIFT NEW STOCK','2022-09-03','2022-09-03 11:36:51','2022-09-04 11:36:51','911',0.00,0.00,'911','2022-09-03 20:08:37','911','2022-09-03 20:08:58',10,0),('1','277',52,'DAILY SHIFT','2022-09-04','2022-09-04 06:19:35','2022-09-05 06:19:35','911',0.00,0.00,'911','2022-09-04 20:07:25','911','2022-09-04 20:08:06',10,0),('1','277',53,'DAILY SHIFT','2022-09-05','2022-09-05 06:11:25','2022-09-06 06:11:25','911',0.00,0.00,'911','2022-09-05 20:03:38','911','2022-09-05 20:03:56',10,0),('1','277',54,'DAILY SHIFT','2022-09-06','2022-09-06 06:13:05','2022-09-07 06:13:05','911',0.00,0.00,'911','2022-09-07 06:16:24','911','2022-09-07 06:16:40',10,0),('1','277',55,'DAILY SHIFT','2022-09-07','2022-09-07 06:17:06','2022-09-08 06:17:06','911',0.00,0.00,'911','2022-09-07 19:46:02','911','2022-09-07 19:46:22',10,0),('1','277',56,'DAILY SHIFT','2022-09-08','2022-09-08 05:54:34','2022-09-09 05:54:34','911',0.00,0.00,'911','2022-09-08 20:48:48','911','2022-09-08 20:49:12',10,0),('1','277',57,'DAILY SHIFT NEW STOCK','2022-09-09','2022-09-09 10:04:44','2022-09-10 10:04:44','911',0.00,0.00,'911','2022-09-09 21:26:04','911','2022-09-09 21:26:25',10,0),('1','277',58,'DAILY SHIFT','2022-09-10','2022-09-10 06:26:08','2022-09-11 06:26:08','911',0.00,0.00,'911','2022-09-10 19:55:29','911','2022-09-10 19:56:20',10,0),('1','277',59,'DAILY SHIFT','2022-09-11','2022-09-11 06:09:45','2022-09-12 06:09:45','911',0.00,0.00,'911','2022-09-11 20:46:39','911','2022-09-11 20:47:29',10,0),('1','277',60,'DAILY SHIFT','2022-09-12','2022-09-12 06:22:44','2022-09-13 06:22:44','911',0.00,0.00,'911','2022-09-12 17:15:27','911','2022-09-12 17:16:42',10,0),('1','277',61,'DAILY SHIFT NEW STOCK','2022-09-13','2022-09-13 14:59:01','2022-09-14 14:59:01','911',0.00,0.00,'911','2022-09-13 19:41:41','911','2022-09-13 19:42:04',10,0),('1','277',62,'DAILY SHIFT','2022-09-14','2022-09-14 06:16:54','2022-09-15 06:16:54','911',0.00,0.00,'911','2022-09-14 19:42:46','911','2022-09-14 19:45:00',10,0),('1','277',63,'DAILY SHIFT','2022-09-15','2022-09-15 06:20:29','2022-09-16 06:20:29','911',0.00,0.00,'911','2022-09-15 19:42:19','911','2022-09-15 19:42:50',10,0),('1','277',64,'DAILY SHIFT','2022-09-16','2022-09-16 06:26:40','2022-09-17 06:26:40','911',0.00,0.00,'911','2022-09-16 20:45:50','911','2022-09-16 20:47:34',10,0),('1','277',65,'DAILY SHIFT','2022-09-17','2022-09-17 06:23:28','2022-09-18 06:23:28','911',0.00,0.00,'911','2022-09-18 00:19:29','911','2022-09-18 00:19:59',10,0),('1','277',66,'DAILY SHIFT','2022-09-18','2022-09-18 06:27:15','2022-09-19 06:27:15','911',0.00,0.00,'911','2022-09-18 20:03:39','911','2022-09-18 20:04:24',10,0),('1','277',67,'DAILY SHIFT','2022-09-19','2022-09-19 06:10:10','2022-09-20 06:10:10','911',0.00,0.00,'911','2022-09-19 14:07:29','911','2022-09-19 14:07:52',10,0),('1','277',68,'OPERATIONAL LOSS','2022-09-19','2022-09-19 16:19:28','2022-09-20 16:19:28','911',0.00,0.00,'911','2022-09-19 16:23:26','911','2022-09-19 16:23:39',10,0),('1','277',69,'DAILY SHIFT NEW STOCK','2022-09-20','2022-09-20 08:35:56','2022-09-21 08:35:56','911',0.00,0.00,'911','2022-09-20 19:57:53','911','2022-09-20 19:58:10',10,0),('1','277',70,'DAILY SHIFT','2022-09-21','2022-09-21 06:19:13','2022-09-22 06:19:13','911',0.00,0.00,'911','2022-09-21 19:33:42','911','2022-09-21 19:34:08',10,0),('1','277',71,'DAILY SHIFT','2022-09-22','2022-09-22 06:14:55','2022-09-23 06:14:55','911',0.00,0.00,'911','2022-09-22 19:26:08','911','2022-09-22 19:26:25',10,0),('1','277',72,'DAILY SHIFT','2022-09-23','2022-09-23 06:37:10','2022-09-24 06:37:10','911',0.00,0.00,'911','2022-09-23 19:25:31','911','2022-09-23 19:25:59',10,0),('1','277',73,'DAILY SHIFT','2022-09-24','2022-09-24 11:30:55','2022-09-25 11:30:55','911',0.00,0.00,'911','2022-09-24 19:17:41','911','2022-09-24 19:18:01',10,0),('1','277',74,'DAILY SHIFT','2022-09-25','2022-09-25 06:19:54','2022-09-26 06:19:54','911',0.00,0.00,'911','2022-09-25 19:47:26','911','2022-09-25 19:48:59',10,0),('1','277',75,'DAILY SHIFT','2022-09-26','2022-09-26 06:18:07','2022-09-27 06:18:07','911',0.00,0.00,'911','2022-09-26 16:55:28','911','2022-09-26 16:55:50',10,0),('1','277',76,'OPERATIONAL LOSS','2022-09-26','2022-09-26 22:02:37','2022-09-27 22:02:37','911',0.00,0.00,'911','2022-09-26 22:46:21','911','2022-09-26 22:46:56',10,0),('1','277',77,'DAILY SHIFT NEW STOCK','2022-09-27','2022-09-27 06:36:23','2022-09-28 06:36:23','911',0.00,0.00,'911','2022-09-27 20:00:00','911','2022-09-27 20:00:24',10,0),('1','277',78,'DAILY SHIFT','2022-09-28','2022-09-28 06:20:58','2022-09-29 06:20:58','911',0.00,0.00,'911','2022-09-28 19:31:05','911','2022-09-28 19:31:27',10,0),('1','277',79,'DAILY SHIFT','2022-09-29','2022-09-29 06:26:41','2022-09-30 06:26:41','911',0.00,0.00,'911','2022-09-29 19:24:49','911','2022-09-29 19:25:12',10,0),('1','277',80,'DAILY SHIFT','2022-09-30','2022-09-30 06:24:29','2022-10-01 06:24:29','911',0.00,0.00,'911','2022-09-30 19:32:57','911','2022-09-30 19:33:16',10,0),('1','277',81,'DAILY SHIFT','2022-10-01','2022-10-01 06:10:02','2022-10-02 06:10:02','911',0.00,0.00,'911','2022-10-01 20:37:58','911','2022-10-01 20:38:20',10,0),('1','277',82,'DAILY SHIFT','2022-10-01','2022-10-01 20:47:52','2022-10-02 20:47:52','911',0.00,0.00,'911','2022-10-01 21:25:24','911','2022-10-01 21:25:46',10,0),('1','277',83,'DAILY SHIFT NEW STOCK','2022-10-02','2022-10-02 14:29:31','2022-10-03 14:29:31','911',0.00,0.00,'911','2022-10-02 19:34:52','911','2022-10-02 19:35:22',10,0),('1','277',84,'DAILY SHIFT','2022-10-03','2022-10-03 06:18:23','2022-10-04 06:18:23','911',0.00,0.00,'911','2022-10-03 19:38:57','911','2022-10-03 19:39:13',10,0),('1','277',85,'DAILY SHIFT','2022-10-04','2022-10-04 06:13:42','2022-10-05 06:13:42','911',0.00,0.00,'911','2022-10-04 19:54:51','911','2022-10-04 19:55:23',10,0),('1','277',86,'DAILY SHIFT','2022-10-05','2022-10-05 06:16:49','2022-10-06 06:16:49','911',0.00,0.00,'911','2022-10-05 19:00:36','911','2022-10-05 19:00:58',10,0),('1','277',87,'DAILY SHIFT','2022-10-06','2022-10-06 07:09:39','2022-10-07 07:09:39','911',0.00,0.00,'911','2022-10-06 19:28:19','911','2022-10-06 19:28:42',10,0),('1','277',88,'DAILY SHIFT','2022-10-07','2022-10-07 06:28:38','2022-10-08 06:28:38','911',0.00,0.00,'911','2022-10-07 18:50:17','911','2022-10-07 18:50:37',10,0),('1','277',89,'DAILY SHIFT','2022-10-07','2022-10-07 19:05:01','2022-10-08 19:05:01','911',0.00,0.00,'911','2022-10-07 19:17:23','911','2022-10-07 19:17:43',10,0),('1','277',90,'DAILY SHIFT NEW STOCK','2022-10-11','2022-10-11 06:09:44','2022-10-12 06:09:44','911',0.00,0.00,'911','2022-10-11 19:14:48','911','2022-10-11 19:15:10',10,0),('1','277',91,'DAILY SHIFT','2022-10-12','2022-10-12 06:10:01','2022-10-13 06:10:01','911',0.00,0.00,'911','2022-10-12 19:18:45','911','2022-10-12 19:19:06',10,0),('1','277',92,'DAILY SHIFT','2022-10-13','2022-10-13 06:22:02','2022-10-14 06:22:02','911',0.00,0.00,'911','2022-10-13 19:19:54','911','2022-10-13 19:20:21',10,0),('1','277',93,'DAILY SHIFT','2022-10-14','2022-10-14 06:10:24','2022-10-15 06:10:24','911',0.00,0.00,'911','2022-10-14 18:56:29','911','2022-10-14 18:56:46',10,0),('1','277',94,'DAILY SHIFT','2022-10-15','2022-10-15 06:19:01','2022-10-16 06:19:01','911',0.00,0.00,'911','2022-10-15 19:49:52','911','2022-10-15 19:50:12',10,0),('1','277',95,'DAILY SHIFT NEW STOCK','2022-10-16','2022-10-16 11:09:18','2022-10-17 11:09:18','911',0.00,0.00,'911','2022-10-16 19:02:53','911','2022-10-16 19:03:26',10,0),('1','277',96,'DAILY SHIFT','2022-10-17','2022-10-17 06:26:55','2022-10-18 06:26:55','911',0.00,0.00,'911','2022-10-17 19:10:23','911','2022-10-17 19:10:44',10,0),('1','277',97,'DAILY SHIFT','2022-10-18','2022-10-18 06:23:31','2022-10-19 06:23:31','911',0.00,0.00,'911','2022-10-18 19:06:31','911','2022-10-18 19:06:58',10,0),('1','277',98,'DAILY SHIFT','2022-10-19','2022-10-19 06:43:25','2022-10-20 06:43:25','911',0.00,0.00,'911','2022-10-19 19:03:05','911','2022-10-19 19:03:25',10,0),('1','277',99,'DAILY SHIFT','2022-10-20','2022-10-20 06:11:44','2022-10-21 06:11:44','911',0.00,0.00,'911','2022-10-20 19:01:07','911','2022-10-20 19:01:55',10,0),('1','277',100,'DAILY SHIFT','2022-10-21','2022-10-21 06:10:57','2022-10-22 06:10:57','911',0.00,0.00,'911','2022-10-22 14:45:43','911','2022-10-22 14:46:07',10,0),('1','277',101,'DAILY SHIFT NEW STOCK','2022-10-22','2022-10-22 14:46:51','2022-10-23 14:46:51','911',0.00,0.00,'911','2022-10-22 19:08:41','911','2022-10-22 19:09:02',10,0),('1','277',102,'DAILY SHIFT','2022-10-23','2022-10-23 06:24:20','2022-10-24 06:24:20','911',0.00,0.00,'911','2022-10-23 19:02:02','911','2022-10-23 19:02:22',10,0),('1','277',103,'DAILY SHIFT','2022-10-24','2022-10-24 06:16:32','2022-10-25 06:16:32','911',0.00,0.00,'911','2022-10-24 18:52:36','911','2022-10-24 18:52:57',10,0),('1','277',104,'DAILY SHIFT','2022-10-25','2022-10-25 06:26:21','2022-10-26 06:26:21','911',0.00,0.00,'911','2022-10-25 18:53:56','911','2022-10-25 18:54:18',10,0),('1','277',105,'DAILY SHIFT','2022-10-26','2022-10-26 06:04:18','2022-10-27 06:04:18','911',0.00,0.00,'911','2022-10-26 19:12:09','911','2022-10-26 19:12:33',10,0),('1','277',106,'DAILY SHIFT','2022-10-27','2022-10-27 06:15:41','2022-10-28 06:15:41','911',0.00,0.00,'911','2022-10-27 19:00:00','911','2022-10-27 19:00:35',10,0),('1','277',107,'DAILY SHIFT','2022-10-28','2022-10-28 06:18:43','2022-10-29 06:18:43','911',0.00,0.00,'911','2022-10-28 18:39:11','911','2022-10-28 18:39:29',10,0),('1','277',108,'DAILY SHIFT NEW STOCK','2022-10-29','2022-10-29 06:14:01','2022-10-30 06:14:01','911',0.00,0.00,'911','2022-10-29 19:33:41','911','2022-10-29 19:34:08',10,0),('1','277',109,'DAILY SHIFT','2022-10-30','2022-10-30 06:26:30','2022-10-31 06:26:30','911',0.00,0.00,'911','2022-10-30 18:49:39','911','2022-10-30 18:50:11',10,0),('1','277',110,'DAILY SHIFT','2022-10-31','2022-10-31 06:33:03','2022-11-01 06:33:03','911',0.00,0.00,'911','2022-10-31 19:04:27','911','2022-10-31 19:04:51',10,0),('1','277',111,'DAILY SHIFT','2022-11-01','2022-11-01 06:22:24','2022-11-02 06:22:24','911',0.00,0.00,'911','2022-11-01 18:48:53','911','2022-11-01 18:49:18',10,0),('1','277',112,'DAILY SHIFT','2022-11-02','2022-11-02 06:33:28','2022-11-03 06:33:28','911',0.00,0.00,'911','2022-11-02 19:00:50','911','2022-11-02 19:01:19',10,0),('1','277',113,'DAILY SHIFT','2022-11-03','2022-11-03 06:36:57','2022-11-04 06:36:57','911',0.00,0.00,'911','2022-11-03 10:06:19','911','2022-11-03 10:06:49',10,0),('1','277',114,'DAILY SHIFT','2022-11-03','2022-11-03 12:29:53','2022-11-04 12:29:53','911',0.00,0.00,'911','2022-11-03 12:36:35','911','2022-11-03 12:36:57',10,0),('1','277',115,'DAILY SHIFT NEW STOCK','2022-11-05','2022-11-05 08:05:03','2022-11-06 08:05:03','911',0.00,0.00,'911','2022-11-05 19:17:26','911','2022-11-05 19:17:53',10,0),('1','277',116,'DAILY SHIFT','2022-11-06','2022-11-06 07:55:11','2022-11-07 07:55:11','911',0.00,0.00,'911','2022-11-06 19:03:13','911','2022-11-06 19:03:36',10,0),('1','277',117,'DAILY SHIFT','2022-11-07','2022-11-07 06:31:18','2022-11-08 06:31:18','911',0.00,0.00,'911','2022-11-07 19:05:35','911','2022-11-07 19:05:57',10,0),('1','277',118,'DAILY SHIFT','2022-11-08','2022-11-08 06:07:30','2022-11-09 06:07:30','911',0.00,0.00,'911','2022-11-08 19:13:54','911','2022-11-08 19:14:14',10,0),('1','277',119,'DAILY SHIFT','2022-11-09','2022-11-09 06:06:38','2022-11-10 06:06:38','911',0.00,0.00,'911','2022-11-09 15:00:44','911','2022-11-09 15:01:02',10,0),('1','277',120,'DAILY SHIFT NEW STOCK','2022-11-10','2022-11-10 06:05:48','2022-11-11 06:05:48','911',0.00,0.00,'911','2022-11-10 22:00:24','911','2022-11-10 22:00:47',10,0),('1','277',121,'DAILY  SHIFT','2022-11-11','2022-11-11 06:16:10','2022-11-12 06:16:10','911',0.00,0.00,'911','2022-11-11 18:51:39','911','2022-11-11 18:52:00',10,0),('1','277',122,'DAILY  SHIFT','2022-11-12','2022-11-12 06:14:35','2022-11-13 06:14:35','911',0.00,0.00,'911','2022-11-12 19:52:15','911','2022-11-12 19:52:41',10,0),('1','277',123,'DAILY  SHIFT','2022-11-13','2022-11-13 06:06:32','2022-11-14 06:06:32','911',0.00,0.00,'911','2022-11-13 23:55:19','911','2022-11-13 23:55:46',10,0),('1','277',124,'DAILY  SHIFT','2022-11-14','2022-11-14 06:06:27','2022-11-15 06:06:27','911',0.00,0.00,'911','2022-11-14 20:55:34','911','2022-11-14 20:55:58',10,0),('1','277',125,'DAILY  SHIFT','2022-11-15','2022-11-15 06:11:39','2022-11-16 06:11:39','911',0.00,0.00,'911','2022-11-15 20:24:04','911','2022-11-15 20:24:24',10,0),('1','277',126,'DAILY  SHIFT','2022-11-16','2022-11-16 06:11:52','2022-11-17 06:11:52','911',0.00,0.00,'911','2022-11-16 19:00:48','911','2022-11-16 19:01:10',10,0),('1','277',127,'DAILY  SHIFT','2022-11-17','2022-11-17 06:10:03','2022-11-18 06:10:03','911',0.00,0.00,'911','2022-11-17 12:30:49','911','2022-11-17 12:31:12',10,0),('1','277',128,'Oparational losses','2022-11-17','2022-11-17 13:01:20','2022-11-18 13:01:20','911',0.00,0.00,'911','2022-11-17 13:21:49','911','2022-11-17 13:22:12',10,0),('1','277',129,'DAILY  SHIFT NEW TRUCK','2022-11-17','2022-11-17 13:45:31','2022-11-18 13:45:31','911',0.00,0.00,'911','2022-11-17 19:16:37','911','2022-11-17 19:16:57',10,0),('1','277',130,'DAILY  SHIFT','2022-11-18','2022-11-18 06:06:00','2022-11-19 06:06:00','911',0.00,0.00,'911','2022-11-18 19:18:29','911','2022-11-18 19:18:53',10,0),('1','277',131,'DAILY  SHIFT','2022-11-19','2022-11-19 06:11:04','2022-11-20 06:11:04','911',0.00,0.00,'911','2022-11-19 19:04:25','911','2022-11-19 19:04:46',10,0),('1','277',132,'DAILY  SHIFT','2022-11-20','2022-11-20 06:12:23','2022-11-21 06:12:23','911',0.00,0.00,'911','2022-11-20 20:50:58','911','2022-11-20 20:51:54',10,0),('1','277',133,'DAILY  SHIFT','2022-11-21','2022-11-21 06:21:39','2022-11-22 06:21:39','911',0.00,0.00,'911','2022-11-21 19:45:54','911','2022-11-21 19:46:18',10,0),('1','277',134,'DAILY  SHIFT','2022-11-22','2022-11-22 06:49:14','2022-11-23 06:49:14','911',0.00,0.00,'911','2022-11-22 19:41:13','911','2022-11-22 19:41:33',10,0),('1','277',135,'Oparational losses','2022-11-22','2022-11-22 19:43:40','2022-11-23 19:43:40','911',0.00,0.00,'911','2022-11-22 19:48:11','911','2022-11-22 19:48:32',10,0),('1','277',136,'DAILY  SHIFT NEW TRUCK','2022-11-23','2022-11-23 06:56:46','2022-11-24 06:56:46','911',0.00,0.00,'911','2022-11-23 19:27:59','911','2022-11-23 19:28:23',10,0),('1','277',137,'DAILY  SHIFT','2022-11-24','2022-11-24 06:23:49','2022-11-25 06:23:49','911',0.00,0.00,'911','2022-11-24 19:14:45','911','2022-11-24 19:15:07',10,0),('1','277',138,'DAILY  SHIFT','2022-11-25','2022-11-25 06:19:03','2022-11-26 06:19:03','911',0.00,0.00,'911','2022-11-25 19:14:13','911','2022-11-25 19:14:43',10,0),('1','277',139,'DAILY  SHIFT','2022-11-26','2022-11-26 06:27:21','2022-11-27 06:27:21','911',0.00,0.00,'911','2022-11-26 18:56:19','911','2022-11-26 18:56:42',10,0),('1','277',140,'DAILY  SHIFT','2022-11-27','2022-11-27 06:43:47','2022-11-28 06:43:47','911',0.00,0.00,'911','2022-11-27 19:01:47','911','2022-11-27 19:02:11',10,0),('1','277',141,'DAILY  SHIFT','2022-11-28','2022-11-28 06:26:35','2022-11-29 06:26:35','911',0.00,0.00,'911','2022-11-28 16:13:38','911','2022-11-28 16:13:56',10,0),('1','277',142,'Oparational losses','2022-11-28','2022-11-28 16:14:40','2022-11-29 16:14:40','911',0.00,0.00,'911','2022-11-28 16:21:10','911','2022-11-28 16:21:27',10,0),('1','277',143,'DAILY  SHIFT NEW TRUCK','2022-11-29','2022-11-29 06:36:46','2022-11-30 06:36:46','911',0.00,0.00,'911','2022-11-29 19:34:17','911','2022-11-29 19:34:36',10,0),('1','277',144,'DAILY  SHIFT','2022-11-30','2022-11-30 06:56:05','2022-12-01 06:56:05','911',0.00,0.00,'911','2022-11-30 19:18:51','911','2022-11-30 19:19:15',10,0),('1','277',145,'DAILY  SHIFT','2022-12-01','2022-12-01 06:32:15','2022-12-02 06:32:15','911',0.00,0.00,'911','2022-12-01 19:23:52','911','2022-12-01 19:24:13',10,0),('1','277',146,'DAILY  SHIFT','2022-12-02','2022-12-02 06:26:50','2022-12-03 06:26:50','911',0.00,0.00,'911','2022-12-02 19:02:19','911','2022-12-02 19:02:40',10,0),('1','277',147,'DAILY  SHIFT','2022-12-03','2022-12-03 07:06:27','2022-12-04 07:06:27','911',0.00,0.00,'911','2022-12-03 15:22:39','911','2022-12-03 15:23:06',10,0),('1','277',148,'DAILY  SHIFT NEW TRUCK','2022-12-04','2022-12-04 06:42:31','2022-12-05 06:42:31','911',0.00,0.00,'911','2022-12-04 19:10:10','911','2022-12-04 19:10:34',10,0),('1','277',149,'DAILY  SHIFT','2022-12-05','2022-12-05 06:47:58','2022-12-06 06:47:58','911',0.00,0.00,'911','2022-12-05 19:10:31','911','2022-12-05 19:10:52',10,0),('1','277',150,'DAILY  SHIFT','2022-12-06','2022-12-06 06:37:42','2022-12-07 06:37:42','911',0.00,0.00,'911','2022-12-06 19:19:02','911','2022-12-06 19:19:28',10,0),('1','277',151,'DAILY  SHIFT10','2022-12-07','2022-12-07 06:34:57','2022-12-08 06:34:57','911',0.00,0.00,'911','2022-12-07 19:35:28','911','2022-12-07 19:35:51',10,0),('1','277',152,'DAILY  SHIFT','2022-12-08','2022-12-08 06:27:30','2022-12-09 06:27:30','911',0.00,0.00,'911','2022-12-08 18:48:54','911','2022-12-08 18:49:16',10,0),('1','277',153,'DAILY  SHIFT','2022-12-09','2022-12-09 06:37:28','2022-12-10 06:37:28','911',0.00,0.00,'911','2022-12-09 09:24:51','911','2022-12-09 09:26:16',10,0),('1','277',154,'DAILY  SHIFT','2022-12-09','2022-12-09 09:27:05','2022-12-10 09:27:05','911',0.00,0.00,'911','2022-12-09 18:54:57','911','2022-12-09 18:55:25',10,0),('1','277',155,'Oparational losses','2022-12-09','2022-12-09 19:04:04','2022-12-10 19:04:04','911',0.00,0.00,'911','2022-12-09 19:10:04','911','2022-12-09 19:10:28',10,0),('1','277',156,'DAILY  SHIFT NEW TRUCK','2022-12-10','2022-12-10 06:17:08','2022-12-11 06:17:08','911',0.00,0.00,'911','2022-12-10 18:51:15','911','2022-12-10 18:51:37',10,0),('1','277',157,'DAILY  SHIFT','2022-12-11','2022-12-11 06:33:29','2022-12-12 06:33:29','911',0.00,0.00,'911','2022-12-11 18:58:39','911','2022-12-11 18:59:08',10,0),('1','277',158,'DAILY  SHIFT','2022-12-12','2022-12-12 06:21:04','2022-12-13 06:21:04','911',0.00,0.00,'911','2022-12-12 18:56:28','911','2022-12-12 18:56:51',10,0),('1','277',159,'DAILY  SHIFT','2022-12-13','2022-12-13 07:19:13','2022-12-14 07:19:13','911',0.00,0.00,'911','2022-12-13 18:46:00','911','2022-12-13 18:48:10',10,0),('1','277',160,'DAILY  SHIFT','2022-12-14','2022-12-14 06:25:50','2022-12-15 06:25:50','911',0.00,0.00,'911','2022-12-14 19:06:26','911','2022-12-14 19:06:50',10,0),('1','277',161,'DAILY  SHIFT','2022-12-15','2022-12-15 06:57:26','2022-12-16 06:57:26','911',0.00,0.00,'911','2022-12-15 15:13:44','911','2022-12-15 15:14:04',10,0),('1','277',162,'Oparational losses','2022-12-15','2022-12-15 15:16:13','2022-12-16 15:16:13','911',0.00,0.00,'911','2022-12-15 15:25:16','911','2022-12-15 15:25:33',10,0),('1','277',163,'DAILY  SHIFT NEW TRUCK','2022-12-15','2022-12-15 16:01:58','2022-12-16 16:01:58','911',0.00,0.00,'911','2022-12-15 18:56:11','911','2022-12-15 18:56:34',10,0),('1','277',164,'DAILY  SHIFT','2022-12-16','2022-12-16 06:45:34','2022-12-17 06:45:34','911',0.00,0.00,'911','2022-12-16 19:16:35','911','2022-12-16 19:16:56',10,0),('1','277',165,'DAILY  SHIFT','2022-12-17','2022-12-17 06:58:33','2022-12-18 06:58:33','911',0.00,0.00,'911','2022-12-17 18:52:08','911','2022-12-17 18:53:03',10,0),('1','277',166,'DAILY  SHIFT','2022-12-18','2022-12-18 06:43:06','2022-12-19 06:43:06','911',0.00,0.00,'911','2022-12-18 19:28:33','911','2022-12-18 19:28:56',10,0),('1','277',167,'DAILY  SHIFT','2022-12-19','2022-12-19 07:01:45','2022-12-20 07:01:45','911',0.00,0.00,'911','2022-12-19 18:52:51','911','2022-12-19 18:53:14',10,0),('1','277',168,'DAILY  SHIFT','2022-12-20','2022-12-20 06:37:39','2022-12-21 06:37:39','911',0.00,0.00,'911','2022-12-20 12:09:26','911','2022-12-20 12:09:45',10,0),('1','277',169,'Oparational losses','2022-12-20','2022-12-20 12:29:58','2022-12-21 12:29:58','911',0.00,0.00,'911','2022-12-20 20:59:45','911','2022-12-20 21:00:04',10,0),('1','277',170,'DAILY  SHIFT','2022-12-21','2022-12-21 06:48:09','2022-12-22 06:48:09','911',0.00,0.00,'911','2022-12-21 19:56:53','911','2022-12-21 19:57:12',10,0),('1','277',171,'DAILY  SHIFT','2022-12-22','2022-12-22 07:02:27','2022-12-23 07:02:27','911',0.00,0.00,'911','2022-12-22 19:49:23','911','2022-12-22 19:49:43',10,0),('1','277',172,'DAILY  SHIFT','2022-12-23','2022-12-23 06:56:07','2022-12-24 06:56:07','911',0.00,0.00,'911','2022-12-23 11:13:48','911','2022-12-23 11:14:09',10,0),('1','277',173,'Oparational losses','2022-12-23','2022-12-23 11:14:34','2022-12-24 11:14:34','911',0.00,0.00,'911','2022-12-23 11:30:53','911','2022-12-23 11:31:09',10,0),('1','277',174,'DAILY  SHIFT NEW TRUCK','2022-12-23','2022-12-23 12:35:44','2022-12-24 12:35:44','911',0.00,0.00,'911','2022-12-23 19:57:22','911','2022-12-23 19:57:46',10,0),('1','277',175,'DAILY  SHIFT','2022-12-24','2022-12-24 06:56:15','2022-12-25 06:56:15','911',0.00,0.00,'911','2022-12-24 20:14:36','911','2022-12-24 20:15:00',10,0),('1','277',176,'DAILY  SHIFT','2022-12-25','2022-12-25 06:56:13','2022-12-26 06:56:13','911',0.00,0.00,'911','2022-12-25 22:01:55','911','2022-12-26 15:30:48',10,0),('1','277',177,'DAILY  SHIFT','2022-12-26','2022-12-26 15:31:26','2022-12-27 15:31:26','911',0.00,0.00,'911','2022-12-26 19:01:09','911','2022-12-26 19:01:39',10,0),('1','277',178,'DAILY  SHIFT','2022-12-27','2022-12-27 06:51:09','2022-12-28 06:51:09','911',0.00,0.00,'911','2022-12-27 15:13:34','911','2022-12-27 15:13:51',10,0),('1','277',179,'DAILY  SHIFT NEW TRUCK','2022-12-27','2022-12-27 15:24:56','2022-12-28 15:24:56','911',0.00,0.00,'911','2022-12-27 19:38:47','911','2022-12-27 19:39:16',10,0),('1','277',180,'DAILY  SHIFT','2022-12-28','2022-12-28 07:00:26','2022-12-29 07:00:26','911',0.00,0.00,'911','2022-12-28 19:09:54','911','2022-12-28 19:10:16',10,0),('1','277',181,'DAILY  SHIFT','2022-12-29','2022-12-29 07:02:39','2022-12-30 07:02:39','911',0.00,0.00,'911','2022-12-29 19:08:49','911','2022-12-29 19:15:32',10,0),('1','277',182,'DAILY  SHIFT','2022-12-30','2022-12-30 06:54:48','2022-12-31 06:54:48','911',0.00,0.00,'911','2022-12-30 21:27:19','911','2022-12-30 21:27:40',10,0),('1','277',183,'DAILY  SHIFT','2022-12-31','2022-12-31 06:27:25','2023-01-01 06:27:25','911',0.00,0.00,'911','2023-01-01 06:32:45','911','2023-01-01 06:34:26',10,0),('1','277',184,'DAILY  SHIFT','2023-01-01','2023-01-01 06:35:25','2023-01-02 06:35:25','911',0.00,0.00,'911','2023-01-01 19:23:24','911','2023-01-01 19:23:48',10,0),('1','277',185,'DAILY  SHIFT NEW TRUCK','2023-01-02','2023-01-02 06:30:27','2023-01-03 06:30:27','911',0.00,0.00,'911','2023-01-02 20:44:37','911','2023-01-02 20:45:02',10,0),('1','277',186,'DAILY  SHIFT','2023-01-03','2023-01-03 06:21:10','2023-01-04 06:21:10','911',0.00,0.00,'911','2023-01-03 21:42:19','911','2023-01-03 21:42:42',10,0),('1','277',187,'DAILY  SHIFT','2023-01-04','2023-01-04 06:20:31','2023-01-05 06:20:31','911',0.00,0.00,'911','2023-01-04 20:52:17','911','2023-01-04 20:52:45',10,0),('1','277',188,'DAILY  SHIFT','2023-01-05','2023-01-05 06:29:07','2023-01-06 06:29:07','911',0.00,0.00,'911','2023-01-05 19:49:32','911','2023-01-05 19:49:55',10,0),('1','277',189,'DAILY  SHIFT','2023-01-05','2023-01-05 20:05:25','2023-01-06 20:05:25','911',0.00,0.00,'911','2023-01-05 20:43:50','911','2023-01-05 20:44:14',10,0),('1','277',190,'DAILY  SHIFT','2023-01-06','2023-01-06 06:56:45','2023-01-07 06:56:45','911',0.00,0.00,'911','2023-01-06 19:24:03','911','2023-01-06 19:24:30',10,0),('1','277',191,'DAILY  SHIFT','2023-01-07','2023-01-07 06:43:32','2023-01-08 06:43:32','911',0.00,0.00,'911','2023-01-07 20:18:33','911','2023-01-07 20:19:19',10,0),('1','277',192,'DAILY  SHIFT','2023-01-08','2023-01-08 07:50:03','2023-01-09 07:50:03','911',0.00,0.00,'911','2023-01-08 08:29:52','911','2023-01-08 08:30:14',10,0),('1','277',193,'DAILY  SHIFT NEW TRUCK','2023-01-08','2023-01-08 08:48:18','2023-01-09 08:48:18','911',0.00,0.00,'911','2023-01-08 20:31:55','911','2023-01-08 20:32:20',10,0),('1','277',194,'DAILY  SHIFT','2023-01-09','2023-01-09 12:44:12','2023-01-10 12:44:12','911',0.00,0.00,'911','2023-01-09 19:29:59','911','2023-01-09 19:30:47',10,0),('1','277',195,'DAILY  SHIFT','2023-01-10','2023-01-10 06:44:26','2023-01-11 06:44:26','911',0.00,0.00,'911','2023-01-10 20:26:28','911','2023-01-10 20:26:50',10,0),('1','277',196,'DAILY  SHIFT','2023-01-11','2023-01-11 07:14:49','2023-01-12 07:14:49','911',0.00,0.00,'911','2023-01-11 18:33:17','911','2023-01-11 18:33:36',10,0),('1','277',197,'DAILY  SHIFT','2023-01-12','2023-01-12 06:48:17','2023-01-13 06:48:17','911',0.00,0.00,'911','2023-01-12 19:02:37','911','2023-01-12 19:02:58',10,0),('1','277',198,'DAILY  SHIFT','2023-01-13','2023-01-13 06:43:59','2023-01-14 06:43:59','911',0.00,0.00,'911','2023-01-13 16:42:31','911','2023-01-13 16:42:53',10,0),('1','277',199,'DAILY  SHIFT NEW TRUCK','2023-01-14','2023-01-14 07:07:03','2023-01-15 07:07:03','911',0.00,0.00,'911','2023-01-14 20:07:34','911','2023-01-14 20:08:11',10,0),('1','277',200,'DAILY  SHIFT','2023-01-15','2023-01-15 06:53:47','2023-01-16 06:53:47','911',0.00,0.00,'911','2023-01-15 19:41:42','911','2023-01-15 19:42:07',10,0),('1','277',201,'DAILY  SHIFT','2023-01-16','2023-01-16 07:13:00','2023-01-17 07:13:00','911',0.00,0.00,'911','2023-01-16 18:40:34','911','2023-01-16 18:40:56',10,0),('1','277',202,'DAILY  SHIFT','2023-01-17','2023-01-17 07:28:52','2023-01-18 07:28:52','911',0.00,0.00,'911','2023-01-17 18:40:31','911','2023-01-17 18:40:53',10,0),('1','277',203,'DAILY  SHIFT','2023-01-18','2023-01-18 07:18:10','2023-01-19 07:18:10','911',0.00,0.00,'911','2023-01-18 19:56:52','911','2023-01-18 19:57:17',10,0),('1','277',204,'DAILY  SHIFT NEW TRUCK','2023-01-19','2023-01-19 07:15:58','2023-01-20 07:15:58','911',0.00,0.00,'911','2023-01-19 19:07:16','911','2023-01-19 19:07:41',10,0),('1','277',205,'DAILY  SHIFT','2023-01-20','2023-01-20 07:00:57','2023-01-21 07:00:57','911',0.00,0.00,'911','2023-01-20 20:02:28','911','2023-01-20 20:03:10',10,0),('1','277',206,'DAILY  SHIFT','2023-01-21','2023-01-21 16:29:44','2023-01-22 16:29:44','911',0.00,0.00,'911','2023-01-21 19:24:15','911','2023-01-21 19:24:51',10,0),('1','277',207,'DAILY  SHIFT','2023-01-22','2023-01-22 07:06:46','2023-01-23 07:06:46','911',0.00,0.00,'911','2023-01-22 19:14:08','911','2023-01-22 19:14:38',10,0),('1','277',208,'DAILY  SHIFT','2023-01-23','2023-01-23 06:54:35','2023-01-24 06:54:35','911',0.00,0.00,'911','2023-01-23 19:22:02','911','2023-01-23 19:22:25',10,0),('1','277',209,'DAILY  SHIFT','2023-01-24','2023-01-24 07:11:08','2023-01-25 07:11:08','911',0.00,0.00,'911','2023-01-24 18:53:52','911','2023-01-24 18:54:23',10,0),('1','277',210,'DAILY  SHIFT','2023-01-25','2023-01-25 07:12:50','2023-01-26 07:12:50','911',0.00,0.00,'911','2023-01-25 22:26:46','911','2023-01-25 22:27:04',10,0),('1','277',211,'DAILY  SHIFT NEW TRUCK','2023-01-26','2023-01-26 07:11:02','2023-01-27 07:11:02','911',0.00,0.00,'911','2023-01-26 19:30:18','911','2023-01-26 19:30:45',10,0),('1','277',212,'DAILY  SHIFT','2023-01-27','2023-01-27 07:21:53','2023-01-28 07:21:53','911',0.00,0.00,'911','2023-01-27 19:24:45','911','2023-01-27 19:25:09',10,0),('1','277',213,'DAILY  SHIFT','2023-01-28','2023-01-28 06:59:40','2023-01-29 06:59:40','911',0.00,0.00,'911','2023-01-28 19:47:14','911','2023-01-28 19:47:37',10,0),('1','277',214,'DAILY  SHIFT','2023-01-29','2023-01-29 07:04:07','2023-01-30 07:04:07','911',0.00,0.00,'911','2023-01-29 19:32:22','911','2023-01-29 19:33:47',10,0),('1','277',215,'DAILY  SHIFT','2023-01-30','2023-01-30 07:45:47','2023-01-31 07:45:47','911',0.00,0.00,'911','2023-01-30 19:50:56','911','2023-01-30 19:51:15',10,0),('1','277',216,'DAILY  SHIFT','2023-01-31','2023-01-31 06:53:06','2023-02-01 06:53:06','911',0.00,0.00,'911','2023-01-31 19:50:40','911','2023-01-31 21:00:04',10,0),('1','277',217,'DAILY  SHIFT','2023-02-01','2023-02-01 07:16:56','2023-02-02 07:16:56','911',0.00,0.00,'911','2023-02-01 22:50:43','911','2023-02-01 22:51:38',10,0),('1','277',218,'DAILY  SHIFT','2023-02-02','2023-02-02 07:14:12','2023-02-03 07:14:12','911',0.00,0.00,'911','2023-02-02 19:51:26','911','2023-02-02 19:51:48',10,0),('1','277',219,'DAILY  SHIFT','2023-02-03','2023-02-03 07:01:03','2023-02-04 07:01:03','911',0.00,0.00,'911','2023-02-03 19:19:16','911','2023-02-03 19:19:40',10,0),('1','277',220,'DAILY  SHIFT','2023-02-04','2023-02-04 06:45:06','2023-02-05 06:45:06','911',0.00,0.00,'911','2023-02-04 21:44:38','911','2023-02-04 21:46:47',10,0),('1','277',221,'DAILY  SHIFT','2023-02-05','2023-02-05 06:50:34','2023-02-06 06:50:34','911',0.00,0.00,'911','2023-02-05 20:13:52','911','2023-02-05 20:14:16',10,0),('1','277',222,'DAILY  SHIFT NEW TRUCK','2023-02-07','2023-02-07 07:03:32','2023-02-08 07:03:32','911',0.00,0.00,'911','2023-02-07 20:25:25','911','2023-02-07 20:25:51',10,0),('1','277',223,'DAILY  SHIFT','2023-02-08','2023-02-08 07:15:08','2023-02-09 07:15:08','911',0.00,0.00,'911','2023-02-08 20:52:50','911','2023-02-08 20:53:14',10,0),('1','277',224,'DAILY  SHIFT','2023-02-09','2023-02-09 07:21:20','2023-02-10 07:21:20','911',0.00,0.00,'911','2023-02-09 20:27:00','911','2023-02-09 20:27:20',10,0),('1','277',225,'DAILY  SHIFT','2023-02-10','2023-02-10 07:07:42','2023-02-11 07:07:42','911',0.00,0.00,'911','2023-02-10 21:08:04','911','2023-02-10 21:08:27',10,0),('1','277',226,'DAILY  SHIFT','2023-02-11','2023-02-11 07:05:14','2023-02-12 07:05:14','911',0.00,0.00,'911','2023-02-11 19:41:11','911','2023-02-11 19:41:41',10,0),('1','277',227,'DAILY  SHIFT','2023-02-12','2023-02-12 06:57:35','2023-02-13 06:57:35','911',0.00,0.00,'911','2023-02-12 14:39:20','911','2023-02-12 14:39:48',10,0),('1','277',228,'DAILY  SHIFT NEW TRUCK','2023-02-12','2023-02-12 16:11:16','2023-02-13 16:11:16','911',0.00,0.00,'911','2023-02-12 21:09:06','911','2023-02-12 21:09:31',10,0),('1','277',229,'DAILY  SHIFT','2023-02-13','2023-02-13 06:54:59','2023-02-14 06:54:59','911',0.00,0.00,'911','2023-02-13 20:49:34','911','2023-02-13 20:49:56',10,0),('1','277',230,'DAILY  SHIFT','2023-02-14','2023-02-14 07:06:38','2023-02-15 07:06:38','911',0.00,0.00,'911','2023-02-14 21:25:48','911','2023-02-14 21:26:11',10,0),('1','277',231,'DAILY  SHIFT','2023-02-15','2023-02-15 07:09:41','2023-02-16 07:09:41','911',0.00,0.00,'911','2023-02-15 20:56:44','911','2023-02-15 20:57:05',10,0),('1','277',232,'DAILY  SHIFT','2023-02-16','2023-02-16 06:52:34','2023-02-17 06:52:34','911',0.00,0.00,'911','2023-02-16 20:35:46','911','2023-02-16 20:36:06',10,0),('1','277',233,'DAILY  SHIFT','2023-02-17','2023-02-17 07:34:14','2023-02-18 07:34:14','911',0.00,0.00,'911','2023-02-17 19:26:53','911','2023-02-17 19:27:21',10,0),('1','277',234,'DAILY  SHIFT','2023-02-18','2023-02-18 06:59:24','2023-02-19 06:59:24','911',0.00,0.00,'911','2023-02-18 21:53:29','911','2023-02-18 21:54:05',10,0),('1','277',235,'DAILY  SHIFT','2023-02-19','2023-02-19 07:11:24','2023-02-20 07:11:24','911',0.00,0.00,'911','2023-02-19 21:40:41','911','2023-02-19 21:41:14',10,0),('1','277',236,'DAILY  SHIFT','2023-02-20','2023-02-20 07:07:19','2023-02-21 07:07:19','911',0.00,0.00,'911','2023-02-20 22:50:37','911','2023-02-20 22:50:59',10,0),('1','277',237,'DAILY  SHIFT','2023-02-21','2023-02-21 07:00:10','2023-02-22 07:00:10','911',0.00,0.00,'911','2023-02-21 19:34:58','911','2023-02-21 19:35:17',10,0),('1','277',238,'DAILY  SHIFT','2023-02-22','2023-02-22 07:11:15','2023-02-23 07:11:15','911',0.00,0.00,'911','2023-02-22 20:16:48','911','2023-02-22 20:17:08',10,0),('1','277',239,'DAILY  SHIFT','2023-02-23','2023-02-23 06:56:59','2023-02-24 06:56:59','911',0.00,0.00,'911','2023-02-23 19:52:08','911','2023-02-23 19:52:34',10,0),('1','277',240,'DAILY  SHIFT','2023-02-24','2023-02-24 07:11:09','2023-02-25 07:11:09','911',0.00,0.00,'911','2023-02-24 16:01:56','911','2023-02-24 16:03:46',10,0),('1','277',241,'DAILY  SHIFT NEW TRUCK','2023-02-24','2023-02-24 16:08:20','2023-02-25 16:08:20','911',0.00,0.00,'911','2023-02-26 07:26:35','911','2023-02-26 07:26:55',10,0),('1','277',242,'DAILY  SHIFT','2023-02-26','2023-02-26 07:27:16','2023-02-27 07:27:16','911',0.00,0.00,'911','2023-02-26 19:27:18','911','2023-02-26 19:27:39',10,0),('1','277',243,'DAILY  SHIFT','2023-02-27','2023-02-27 07:12:24','2023-02-28 07:12:24','911',0.00,0.00,'911','2023-02-27 19:13:17','911','2023-02-27 19:13:37',10,0),('1','277',244,'DAILY  SHIFT','2023-02-28','2023-02-28 07:09:31','2023-03-01 07:09:31','911',0.00,0.00,'911','2023-02-28 19:36:15','911','2023-02-28 19:36:35',10,0),('1','277',245,'DAILY  SHIFT','2023-03-01','2023-03-01 07:20:07','2023-03-02 07:20:07','911',0.00,0.00,'911','2023-03-01 11:35:09','911','2023-03-01 11:35:25',10,0),('1','277',246,'DAILY  SHIFT NEW TRUCK','2023-03-01','2023-03-01 11:39:17','2023-03-02 11:39:17','911',0.00,0.00,'911','2023-03-01 20:33:07','911','2023-03-01 20:33:29',10,0),('1','277',247,'DAILY  SHIFT','2023-03-02','2023-03-02 07:15:44','2023-03-03 07:15:44','911',0.00,0.00,'911','2023-03-02 20:38:38','911','2023-03-02 20:38:58',10,0),('1','277',248,'DAILY  SHIFT','2023-03-03','2023-03-03 07:34:40','2023-03-04 07:34:40','911',0.00,0.00,'911','2023-03-03 19:49:33','911','2023-03-03 19:49:56',10,0),('1','277',249,'DAILY  SHIFT','2023-03-04','2023-03-04 07:28:34','2023-03-05 07:28:34','911',0.00,0.00,'911','2023-03-04 19:31:28','911','2023-03-04 19:31:49',10,0),('1','277',250,'DAILY  SHIFT','2023-03-05','2023-03-05 07:13:25','2023-03-06 07:13:25','911',0.00,0.00,'911','2023-03-05 20:02:00','911','2023-03-05 20:02:33',10,0),('1','277',251,'DAILY  SHIFT NEW TRUCK','2023-03-06','2023-03-06 07:30:51','2023-03-07 07:30:51','911',0.00,0.00,'911','2023-03-06 19:20:07','911','2023-03-06 19:20:25',10,0),('1','277',252,'DAILY  SHIFT','2023-03-07','2023-03-07 07:23:50','2023-03-08 07:23:50','911',0.00,0.00,'911','2023-03-07 19:40:12','911','2023-03-07 19:40:32',10,0),('1','277',253,'DAILY  SHIFT','2023-03-08','2023-03-08 07:21:14','2023-03-09 07:21:14','911',0.00,0.00,'911','2023-03-08 08:18:40','911','2023-03-08 08:21:12',10,0),('1','277',254,'DAILY  SHIFT','2023-03-08','2023-03-08 08:24:26','2023-03-09 08:24:26','911',0.00,0.00,'911','2023-03-08 12:02:42','911','2023-03-08 12:03:05',10,0),('1','277',255,'DAILY  SHIFT','2023-03-08','2023-03-08 12:04:59','2023-03-09 12:04:59','911',0.00,0.00,'911','2023-03-08 19:42:27','911','2023-03-08 19:42:52',10,0),('1','277',256,'DAILY  SHIFT','2023-03-09','2023-03-09 07:18:30','2023-03-10 07:18:30','911',0.00,0.00,'911','2023-03-09 19:17:58','911','2023-03-09 19:18:20',10,0),('1','277',257,'DAILY  SHIFT','2023-03-10','2023-03-10 06:58:40','2023-03-11 06:58:40','911',0.00,0.00,'911','2023-03-10 16:42:40','911','2023-03-10 16:43:07',10,0),('1','277',258,'DAILY  SHIFT NEW TRUCK','2023-03-10','2023-03-10 16:46:58','2023-03-11 16:46:58','911',0.00,0.00,'911','2023-03-10 20:06:40','911','2023-03-10 20:06:58',10,0),('1','277',259,'DAILY  SHIFT','2023-03-11','2023-03-11 07:12:35','2023-03-12 07:12:35','911',0.00,0.00,'911','2023-03-11 19:29:04','911','2023-03-11 19:29:24',10,0),('1','277',260,'DAILY  SHIFT','2023-03-12','2023-03-12 07:15:57','2023-03-13 07:15:57','911',0.00,0.00,'911','2023-03-12 19:41:11','911','2023-03-12 19:41:29',10,0),('1','277',261,'DAILY  SHIFT','2023-03-13','2023-03-13 07:10:42','2023-03-14 07:10:42','911',0.00,0.00,'911','2023-03-13 20:21:45','911','2023-03-13 20:22:05',10,0),('1','277',262,'DAILY  SHIFT','2023-03-14','2023-03-14 07:16:26','2023-03-15 07:16:26','911',0.00,0.00,'911','2023-03-14 19:44:40','911','2023-03-14 19:45:01',10,0),('1','277',263,'DAILY  SHIFT','2023-03-15','2023-03-15 07:19:17','2023-03-16 07:19:17','911',0.00,0.00,'911','2023-03-15 19:25:19','911','2023-03-15 19:25:40',10,0),('1','277',264,'DAILY  SHIFT','2023-03-16','2023-03-16 08:22:26','2023-03-17 08:22:26','911',0.00,0.00,'911','2023-03-16 11:16:34','911','2023-03-16 11:16:54',10,0),('1','277',265,'DAILY  SHIFT NEW TRUCK','2023-03-16','2023-03-16 11:32:55','2023-03-17 11:32:55','911',0.00,0.00,'911','2023-03-16 20:00:33','911','2023-03-16 20:00:57',10,0),('1','277',266,'DAILY  SHIFT','2023-03-17','2023-03-17 07:34:57','2023-03-18 07:34:57','911',0.00,0.00,'911','2023-03-17 19:46:40','911','2023-03-17 19:47:11',10,0),('1','277',267,'DAILY  SHIFT','2023-03-18','2023-03-18 07:21:04','2023-03-19 07:21:04','911',0.00,0.00,'911','2023-03-18 15:31:37','911','2023-03-18 15:32:04',10,0),('1','277',268,'DAILY  SHIFT','2023-03-18','2023-03-18 15:32:45','2023-03-19 15:32:45','911',0.00,0.00,'911','2023-03-18 19:19:11','911','2023-03-18 19:19:51',10,0),('1','277',269,'DAILY  SHIFT','2023-03-19','2023-03-19 07:13:13','2023-03-20 07:13:13','911',0.00,0.00,'911','2023-03-19 19:29:43','911','2023-03-19 19:30:00',10,0),('1','277',270,'DAILY  SHIFT','2023-03-20','2023-03-20 07:06:13','2023-03-21 07:06:13','911',0.00,0.00,'911','2023-03-20 19:28:45','911','2023-03-20 19:29:02',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=541 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','277','1','1',1,'1','1',0.00,340.56,0.00,0.00,340.56,253376.64,0.00,0.00,0.00),('1','277','1','1',2,'2','1',0.00,31.39,0.00,0.00,31.39,23354.16,0.00,0.00,0.00),('1','277','1','2',3,'1','1',340.56,426.64,0.00,0.00,86.08,64043.52,0.00,0.00,0.00),('1','277','1','2',4,'2','1',31.39,100.40,0.00,0.00,69.01,51343.44,0.00,0.00,0.00),('1','277','1','3',5,'1','1',426.64,502.48,0.00,0.00,75.84,56424.96,0.00,0.00,0.00),('1','277','1','3',6,'2','1',100.40,231.04,0.00,0.00,130.64,97196.16,0.00,0.00,0.00),('1','277','1','4',7,'1','1',502.48,631.06,0.00,0.00,128.58,95663.52,0.00,0.00,0.00),('1','277','1','4',8,'2','1',231.04,338.89,0.00,0.00,107.85,80240.40,0.00,0.00,0.00),('1','277','1','5',9,'1','1',631.06,753.71,0.00,0.00,122.65,91251.60,0.00,0.00,0.00),('1','277','1','5',10,'2','1',338.89,464.25,0.00,0.00,125.36,93267.84,0.00,0.00,0.00),('1','277','1','6',11,'1','1',753.71,867.12,0.00,0.00,113.41,84377.04,0.00,0.00,0.00),('1','277','1','6',12,'2','1',464.25,574.47,0.00,0.00,110.22,82003.68,0.00,0.00,0.00),('1','277','1','7',13,'1','1',867.12,1088.12,0.00,0.00,221.00,164424.00,0.00,0.00,0.00),('1','277','1','7',14,'2','1',574.47,744.07,0.00,0.00,169.60,126182.40,0.00,0.00,0.00),('1','277','1','8',15,'1','1',1088.12,1307.79,0.00,0.00,219.67,163434.48,0.00,0.00,0.00),('1','277','1','8',16,'2','1',744.07,872.91,0.00,0.00,128.84,95856.96,0.00,0.00,0.00),('1','277','1','9',17,'1','1',1307.79,1498.20,0.00,0.00,190.41,141665.04,0.00,0.00,0.00),('1','277','1','9',18,'2','1',872.91,1017.95,0.00,0.00,145.04,105459.76,0.00,0.00,0.00),('1','277','1','10',19,'1','1',1498.20,1811.73,0.00,0.00,313.53,233266.32,0.00,0.00,0.00),('1','277','1','10',20,'2','1',1017.95,1067.95,0.00,0.00,50.00,34750.00,0.00,0.00,0.00),('1','277','1','11',21,'1','1',1811.73,2098.83,0.00,0.00,287.10,213602.40,0.00,0.00,0.00),('1','277','1','11',22,'2','1',1067.95,1117.95,0.00,0.00,50.00,35000.39,0.00,0.00,0.00),('1','277','1','12',23,'1','1',2098.83,2548.41,0.00,0.00,449.58,334487.52,0.00,0.00,0.00),('1','277','1','12',24,'2','1',1117.95,1117.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','13',25,'1','1',2548.41,2857.05,0.00,0.00,308.64,224689.92,0.00,0.00,0.00),('1','277','1','13',26,'2','1',1117.95,1517.95,0.00,0.00,400.00,278000.00,0.00,0.00,0.00),('1','277','1','14',27,'1','1',2857.05,3211.66,0.00,0.00,354.61,258156.08,0.00,0.00,0.00),('1','277','1','14',28,'2','1',1517.95,1517.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','15',29,'1','1',3211.66,3875.13,0.00,0.00,663.47,483006.16,0.00,0.00,0.00),('1','277','1','15',30,'2','1',1517.95,1517.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','16',31,'1','1',3875.13,3875.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','16',32,'2','1',1517.95,1517.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','17',33,'1','1',3875.13,4353.84,0.00,0.00,478.71,348500.88,0.00,0.00,0.00),('1','277','1','17',34,'2','1',1517.95,2683.89,0.00,0.00,1165.94,810328.30,0.00,0.00,0.00),('1','277','1','18',35,'1','1',4353.84,4740.20,0.00,0.00,386.36,281270.08,0.00,0.00,0.00),('1','277','1','18',36,'2','1',2683.89,2831.39,0.00,0.00,147.50,102512.50,0.00,0.00,0.00),('1','277','1','19',37,'1','1',4740.20,5273.92,0.00,0.00,533.72,388548.16,0.00,0.00,0.00),('1','277','1','19',38,'2','1',2831.39,3623.39,0.00,0.00,792.00,550440.00,0.00,0.00,0.00),('1','277','1','20',39,'1','1',5273.92,5591.95,0.00,0.00,318.03,231525.84,0.00,0.00,0.00),('1','277','1','20',40,'2','1',3623.39,4003.39,0.00,0.00,380.00,264100.00,0.00,0.00,0.00),('1','277','1','21',41,'1','1',5591.95,6048.87,0.00,0.00,456.92,332637.76,0.00,0.00,0.00),('1','277','1','21',42,'2','1',4003.39,4103.39,0.00,0.00,100.00,69500.00,0.00,0.00,0.00),('1','277','1','22',43,'1','1',6048.87,6629.58,0.00,0.00,580.71,422756.88,0.00,0.00,0.00),('1','277','1','22',44,'2','1',4103.39,4294.39,0.00,0.00,191.00,132745.00,0.00,0.00,0.00),('1','277','1','23',45,'1','1',6629.58,7244.20,0.00,0.00,614.62,447443.36,0.00,0.00,0.00),('1','277','1','23',46,'2','1',4294.39,4494.39,0.00,0.00,200.00,139000.00,0.00,0.00,0.00),('1','277','1','24',47,'1','1',7244.20,7681.46,0.00,0.00,437.26,332317.60,0.00,0.00,0.00),('1','277','1','24',48,'2','1',4494.39,4558.39,0.00,0.00,64.00,45440.00,0.00,0.00,0.00),('1','277','1','25',49,'1','1',7681.46,8139.87,0.00,0.00,458.41,336500.40,0.00,0.00,0.00),('1','277','1','25',50,'2','1',4558.39,4558.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','26',51,'1','1',8139.87,8609.74,0.00,0.00,469.87,342065.36,0.00,0.00,0.00),('1','277','1','26',52,'2','1',4558.39,4586.39,0.00,0.00,28.00,19880.00,0.00,0.00,0.00),('1','277','1','27',53,'1','1',8609.74,9172.37,0.00,0.00,562.63,409594.64,0.00,0.00,0.00),('1','277','1','27',54,'2','1',4586.39,4635.39,0.00,0.00,49.00,34790.00,0.00,0.00,0.00),('1','277','1','28',55,'1','1',9172.37,9707.38,0.00,0.00,535.01,389487.28,0.00,0.00,0.00),('1','277','1','28',56,'2','1',4635.39,4635.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','29',57,'1','1',9707.38,10242.56,0.00,0.00,535.18,389611.04,0.00,0.00,0.00),('1','277','1','29',58,'2','1',4635.39,4735.39,0.00,0.00,100.00,71000.00,0.00,0.00,0.00),('1','277','1','30',59,'1','1',10242.56,10951.54,0.00,0.00,708.98,516137.44,0.00,0.00,0.00),('1','277','1','30',60,'2','1',4735.39,4843.39,0.00,0.00,108.00,76680.00,0.00,0.00,0.00),('1','277','1','31',61,'1','1',10951.54,11604.02,0.00,0.00,652.48,475005.44,0.00,0.00,0.00),('1','277','1','31',62,'2','1',4843.39,4910.39,0.00,0.00,67.00,47570.00,0.00,0.00,0.00),('1','277','1','32',63,'1','1',11604.02,12252.23,0.00,0.00,648.21,471896.88,0.00,0.00,0.00),('1','277','1','32',64,'2','1',4910.39,4998.39,0.00,0.00,88.00,62480.00,0.00,0.00,0.00),('1','277','1','33',65,'1','1',12252.23,12795.62,0.00,0.00,543.39,395587.92,0.00,0.00,0.00),('1','277','1','33',66,'2','1',4998.39,4998.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','34',67,'1','1',12795.62,13140.15,0.00,0.00,344.53,250817.84,0.00,0.00,0.00),('1','277','1','34',68,'2','1',4998.39,5018.39,0.00,0.00,20.00,14200.00,0.00,0.00,0.00),('1','277','1','35',69,'1','1',13140.15,13589.94,0.00,0.00,449.79,327447.12,0.00,0.00,0.00),('1','277','1','35',70,'2','1',5018.39,5040.69,0.00,0.00,22.30,15833.00,0.00,0.00,0.00),('1','277','1','36',71,'1','1',13589.94,14253.49,0.00,0.00,663.55,483064.40,0.00,0.00,0.00),('1','277','1','36',72,'2','1',5040.69,5040.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','37',73,'1','1',14253.49,14838.73,0.00,0.00,585.24,426054.72,0.00,0.00,0.00),('1','277','1','37',74,'2','1',5040.69,5150.69,0.00,0.00,110.00,78100.00,0.00,0.00,0.00),('1','277','1','38',75,'1','1',14838.73,15381.84,0.00,0.00,543.11,395384.08,0.00,0.00,0.00),('1','277','1','38',76,'2','1',5150.69,5220.69,0.00,0.00,70.00,49700.00,0.00,0.00,0.00),('1','277','1','39',77,'1','1',15381.84,15956.14,0.00,0.00,574.30,418090.40,0.00,0.00,0.00),('1','277','1','39',78,'2','1',5220.69,5280.69,0.00,0.00,60.00,42600.00,0.00,0.00,0.00),('1','277','1','40',79,'1','1',15956.14,16568.81,0.00,0.00,612.67,446023.76,0.00,0.00,0.00),('1','277','1','40',80,'2','1',5280.69,5584.69,0.00,0.00,304.00,215889.32,0.00,0.00,0.00),('1','277','1','41',81,'1','1',16568.81,17169.00,0.00,0.00,600.19,436938.32,0.00,0.00,0.00),('1','277','1','41',82,'2','1',5584.69,5624.69,0.00,0.00,40.00,28400.00,0.00,0.00,0.00),('1','277','1','42',83,'1','1',17169.00,17707.79,0.00,0.00,538.79,392239.12,0.00,0.00,0.00),('1','277','1','42',84,'2','1',5624.69,5696.69,0.00,0.00,72.00,51120.00,0.00,0.00,0.00),('1','277','1','43',85,'1','1',17707.79,17928.17,0.00,0.00,220.38,160436.64,0.00,0.00,0.00),('1','277','1','43',86,'2','1',5696.69,5696.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','44',87,'1','1',17928.17,18642.67,0.00,0.00,714.50,520156.00,0.00,0.00,0.00),('1','277','1','44',88,'2','1',5696.69,5746.69,0.00,0.00,50.00,35500.00,0.00,0.00,0.00),('1','277','1','45',89,'1','1',18642.67,19487.34,0.00,0.00,844.67,614919.76,0.00,0.00,0.00),('1','277','1','45',90,'2','1',5746.69,5746.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','46',91,'1','1',19487.34,20246.20,0.00,0.00,758.86,552450.08,0.00,0.00,0.00),('1','277','1','46',92,'2','1',5746.69,5942.69,0.00,0.00,196.00,139160.00,0.00,0.00,0.00),('1','277','1','47',93,'1','1',20246.20,20995.15,0.00,0.00,748.95,545235.60,0.00,0.00,0.00),('1','277','1','47',94,'2','1',5942.69,6015.59,0.00,0.00,72.90,51759.00,0.00,0.00,0.00),('1','277','1','48',95,'1','1',20995.15,21807.13,0.00,0.00,811.98,591121.44,0.00,0.00,0.00),('1','277','1','48',96,'2','1',6015.59,6015.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','49',97,'1','1',21807.13,22693.11,0.00,0.00,885.98,644993.44,0.00,0.00,0.00),('1','277','1','49',98,'2','1',6015.59,6042.29,0.00,0.00,26.70,18957.00,0.00,0.00,0.00),('1','277','1','50',99,'1','1',22693.11,22884.69,0.00,0.00,191.58,139470.24,0.00,0.00,0.00),('1','277','1','50',100,'2','1',6042.29,6042.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','51',101,'1','1',22884.69,23588.57,0.00,0.00,703.88,512424.64,0.00,0.00,0.00),('1','277','1','51',102,'2','1',6042.29,6066.29,0.00,0.00,24.00,17040.00,0.00,0.00,0.00),('1','277','1','52',103,'1','1',23588.57,24385.10,0.00,0.00,796.53,581145.84,0.00,0.00,0.00),('1','277','1','52',104,'2','1',6066.29,6126.29,0.00,0.00,60.00,42600.00,0.00,0.00,0.00),('1','277','1','53',105,'1','1',24385.10,25085.06,0.00,0.00,699.96,509570.88,0.00,0.00,0.00),('1','277','1','53',106,'2','1',6126.29,6358.89,0.00,0.00,232.60,165146.00,0.00,0.00,0.00),('1','277','1','54',107,'1','1',25085.06,25790.08,0.00,0.00,705.02,513254.56,0.00,0.00,0.00),('1','277','1','54',108,'2','1',6358.89,6427.47,0.00,0.00,68.58,48006.00,0.00,0.00,0.00),('1','277','1','55',109,'1','1',25790.08,26479.76,0.00,0.00,689.68,502087.04,0.00,0.00,0.00),('1','277','1','55',110,'2','1',6427.47,6597.47,0.00,0.00,170.00,119000.00,0.00,0.00,0.00),('1','277','1','56',111,'1','1',26479.76,27058.62,0.00,0.00,578.86,421410.08,0.00,0.00,0.00),('1','277','1','56',112,'2','1',6597.47,6825.17,0.00,0.00,227.70,159390.00,0.00,0.00,0.00),('1','277','1','57',113,'1','1',27058.62,27607.12,0.00,0.00,548.50,399308.00,0.00,0.00,0.00),('1','277','1','57',114,'2','1',6825.17,6825.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','58',115,'1','1',27607.12,28577.28,0.00,0.00,970.16,706276.48,0.00,0.00,0.00),('1','277','1','58',116,'2','1',6825.17,6825.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','59',117,'1','1',28577.28,29758.53,0.00,0.00,1181.25,859950.00,0.00,0.00,0.00),('1','277','1','59',118,'2','1',6825.17,6825.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','60',119,'1','1',29758.53,30239.62,0.00,0.00,481.09,350233.52,0.00,0.00,0.00),('1','277','1','60',120,'2','1',6825.17,6825.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','61',121,'1','1',30239.62,30750.34,0.00,0.00,510.72,371804.16,0.00,0.00,0.00),('1','277','1','61',122,'2','1',6825.17,6825.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','62',123,'1','1',30750.34,31640.50,0.00,0.00,890.16,648036.48,0.00,0.00,0.00),('1','277','1','62',124,'2','1',6825.17,6825.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','63',125,'1','1',31640.50,32322.21,0.00,0.00,681.71,496284.88,0.00,0.00,0.00),('1','277','1','63',126,'2','1',6825.17,6825.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','64',127,'1','1',32322.21,33140.41,0.00,0.00,818.20,595649.60,0.00,0.00,0.00),('1','277','1','64',128,'2','1',6825.17,6825.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','65',129,'1','1',33140.41,34169.24,0.00,0.00,1028.83,748988.24,0.00,0.00,0.00),('1','277','1','65',130,'2','1',6825.17,6825.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','66',131,'1','1',34169.24,35408.88,0.00,0.00,1239.64,902457.92,0.00,0.00,0.00),('1','277','1','66',132,'2','1',6825.17,6825.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','67',133,'1','1',35408.88,35715.38,0.00,0.00,306.50,223132.00,0.00,0.00,0.00),('1','277','1','67',134,'2','1',6825.17,6825.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','68',135,'1','1',35715.38,35715.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','68',136,'2','1',6825.17,6825.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','69',137,'1','1',35715.38,36564.78,0.00,0.00,849.40,618363.20,0.00,0.00,0.00),('1','277','1','69',138,'2','1',6825.17,6825.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','70',139,'1','1',36564.78,37629.40,0.00,0.00,1064.62,775043.36,0.00,0.00,0.00),('1','277','1','70',140,'2','1',6825.17,6825.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','71',141,'1','1',37629.40,38313.14,0.00,0.00,683.74,497762.72,0.00,0.00,0.00),('1','277','1','71',142,'2','1',6825.17,6825.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','72',143,'1','1',38313.14,39008.16,0.00,0.00,695.02,505974.56,0.00,0.00,0.00),('1','277','1','72',144,'2','1',6825.17,6825.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','73',145,'1','1',39008.16,39632.62,0.00,0.00,624.46,454606.88,0.00,0.00,0.00),('1','277','1','73',146,'2','1',6825.17,6825.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','74',147,'1','1',39632.62,40395.17,0.00,0.00,762.55,555136.40,0.00,0.00,0.00),('1','277','1','74',148,'2','1',6825.17,6825.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','75',149,'1','1',40395.17,40812.25,0.00,0.00,417.08,303634.24,0.00,0.00,0.00),('1','277','1','75',150,'2','1',6825.17,6825.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','76',151,'1','1',40812.25,40812.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','76',152,'2','1',6825.17,6825.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','77',153,'1','1',40812.25,41690.91,0.00,0.00,878.66,639664.48,0.00,0.00,0.00),('1','277','1','77',154,'2','1',6825.17,7053.17,0.00,0.00,228.00,159600.00,0.00,0.00,0.00),('1','277','1','78',155,'1','1',41690.91,42477.62,0.00,0.00,786.71,572724.88,0.00,0.00,0.00),('1','277','1','78',156,'2','1',7053.17,7103.17,0.00,0.00,50.00,35000.00,0.00,0.00,0.00),('1','277','1','79',157,'1','1',42477.62,43375.57,0.00,0.00,897.95,653707.60,0.00,0.00,0.00),('1','277','1','79',158,'2','1',7103.17,7317.59,0.00,0.00,214.42,150094.00,0.00,0.00,0.00),('1','277','1','80',159,'1','1',43375.57,44299.15,0.00,0.00,923.58,672366.24,0.00,0.00,0.00),('1','277','1','80',160,'2','1',7317.59,7551.94,0.00,0.00,234.35,164045.00,0.00,0.00,0.00),('1','277','1','81',161,'1','1',44299.15,45426.97,0.00,0.00,1127.82,821052.96,0.00,0.00,0.00),('1','277','1','81',162,'2','1',7551.94,7654.94,0.00,0.00,103.00,72128.84,0.00,0.00,0.00),('1','277','1','82',163,'1','1',45426.97,45426.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','82',164,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','83',165,'1','1',45426.97,45970.71,0.00,0.00,543.74,395842.72,0.00,0.00,0.00),('1','277','1','83',166,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','84',167,'1','1',45970.71,47026.52,0.00,0.00,1055.81,768629.68,0.00,0.00,0.00),('1','277','1','84',168,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','85',169,'1','1',47026.52,47854.18,0.00,0.00,827.66,602536.48,0.00,0.00,0.00),('1','277','1','85',170,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','86',171,'1','1',47854.18,48679.79,0.00,0.00,825.61,601044.08,0.00,0.00,0.00),('1','277','1','86',172,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','87',173,'1','1',48679.79,49803.08,0.00,0.00,1123.29,817755.12,0.00,0.00,0.00),('1','277','1','87',174,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','88',175,'1','1',49803.08,50925.59,0.00,0.00,1122.51,817187.28,0.00,0.00,0.00),('1','277','1','88',176,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','89',177,'1','1',50925.59,50925.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','89',178,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','90',179,'1','1',50925.59,51870.70,0.00,0.00,945.11,722064.04,0.00,0.00,0.00),('1','277','1','90',180,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','91',181,'1','1',51870.70,52802.04,0.00,0.00,931.34,696642.32,0.00,0.00,0.00),('1','277','1','91',182,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','92',183,'1','1',52802.04,53771.75,0.00,0.00,969.71,725343.08,0.00,0.00,0.00),('1','277','1','92',184,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','93',185,'1','1',53771.75,54502.69,0.00,0.00,730.94,546743.12,0.00,0.00,0.00),('1','277','1','93',186,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','94',187,'1','1',54502.69,55596.82,0.00,0.00,1094.13,818409.24,0.00,0.00,0.00),('1','277','1','94',188,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','95',189,'1','1',55596.82,56350.40,0.00,0.00,753.58,563677.84,0.00,0.00,0.00),('1','277','1','95',190,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','96',191,'1','1',56350.40,57001.80,0.00,0.00,651.40,487247.20,0.00,0.00,0.00),('1','277','1','96',192,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','97',193,'1','1',57001.80,58193.97,0.00,0.00,1192.17,891743.16,0.00,0.00,0.00),('1','277','1','97',194,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','98',195,'1','1',58193.97,59117.18,0.00,0.00,923.21,701639.60,0.00,0.00,0.00),('1','277','1','98',196,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','99',197,'1','1',59117.18,60021.94,0.00,0.00,904.76,687617.60,0.00,0.00,0.00),('1','277','1','99',198,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','100',199,'1','1',60021.94,60850.95,0.00,0.00,829.01,630047.60,0.00,0.00,0.00),('1','277','1','100',200,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','101',201,'1','1',60850.95,61251.11,0.00,0.00,400.16,304121.60,0.00,0.00,0.00),('1','277','1','101',202,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','102',203,'1','1',61251.11,62332.69,0.00,0.00,1081.58,822000.80,0.00,0.00,0.00),('1','277','1','102',204,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','103',205,'1','1',62332.69,63231.67,0.00,0.00,898.98,683224.80,0.00,0.00,0.00),('1','277','1','103',206,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','104',207,'1','1',63231.67,64026.84,0.00,0.00,795.17,604329.20,0.00,0.00,0.00),('1','277','1','104',208,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','105',209,'1','1',64026.84,64785.81,0.00,0.00,758.97,607176.00,0.00,0.00,0.00),('1','277','1','105',210,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','106',211,'1','1',64785.81,65609.24,0.00,0.00,823.43,658744.00,0.00,0.00,0.00),('1','277','1','106',212,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','107',213,'1','1',65609.24,65969.81,0.00,0.00,360.57,288456.00,0.00,0.00,0.00),('1','277','1','107',214,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','108',215,'1','1',65969.81,67059.20,0.00,0.00,1089.39,827936.40,0.00,0.00,0.00),('1','277','1','108',216,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','109',217,'1','1',67059.20,68049.01,0.00,0.00,989.81,752255.60,0.00,0.00,0.00),('1','277','1','109',218,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','110',219,'1','1',68049.01,68952.17,0.00,0.00,903.16,686401.60,0.00,0.00,0.00),('1','277','1','110',220,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','111',221,'1','1',68952.17,69847.94,0.00,0.00,895.77,680785.20,0.00,0.00,0.00),('1','277','1','111',222,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','112',223,'1','1',69847.94,70807.29,0.00,0.00,959.35,729106.00,0.00,0.00,0.00),('1','277','1','112',224,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','113',225,'1','1',70807.29,70979.85,0.00,0.00,172.56,131145.60,0.00,0.00,0.00),('1','277','1','113',226,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','114',227,'1','1',70979.85,70979.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','114',228,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','115',229,'1','1',70979.85,72241.24,0.00,0.00,1261.39,958656.40,0.00,0.00,0.00),('1','277','1','115',230,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','116',231,'1','1',72241.24,73314.69,0.00,0.00,1073.45,815822.00,0.00,0.00,0.00),('1','277','1','116',232,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','117',233,'1','1',73314.69,74087.71,0.00,0.00,773.02,587495.20,0.00,0.00,0.00),('1','277','1','117',234,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','118',235,'1','1',74087.71,74867.07,0.00,0.00,779.36,592313.60,0.00,0.00,0.00),('1','277','1','118',236,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','119',237,'1','1',74867.07,75294.40,0.00,0.00,427.33,324770.80,0.00,0.00,0.00),('1','277','1','119',238,'2','1',7654.94,7654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','120',239,'1','1',75294.40,76028.83,0.00,0.00,734.43,558166.80,0.00,0.00,0.00),('1','277','1','120',240,'2','1',7654.94,7656.26,0.00,0.00,1.32,1003.20,0.00,0.00,0.00),('1','277','1','121',241,'1','1',76028.83,76677.19,0.00,0.00,648.36,492753.60,0.00,0.00,0.00),('1','277','1','121',242,'2','1',7656.26,7656.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','122',243,'1','1',76677.19,77476.85,0.00,0.00,799.66,607741.60,0.00,0.00,0.00),('1','277','1','122',244,'2','1',7656.26,7659.55,0.00,0.00,3.29,2500.40,0.00,0.00,0.00),('1','277','1','123',245,'1','1',77476.85,78235.77,0.00,0.00,758.92,576779.20,0.00,0.00,0.00),('1','277','1','123',246,'2','1',7659.55,7659.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','124',247,'1','1',78235.77,78780.11,0.00,0.00,544.34,413698.40,0.00,0.00,0.00),('1','277','1','124',248,'2','1',7659.55,7659.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','125',249,'1','1',78780.11,79527.88,0.00,0.00,747.77,568305.20,0.00,0.00,0.00),('1','277','1','125',250,'2','1',7659.55,7659.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','126',251,'1','1',79527.88,79938.74,0.00,0.00,410.86,312253.60,0.00,0.00,0.00),('1','277','1','126',252,'2','1',7659.55,7659.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','127',253,'1','1',79938.74,80223.79,0.00,0.00,285.05,216638.00,0.00,0.00,0.00),('1','277','1','127',254,'2','1',7659.55,7659.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','128',255,'1','1',80223.79,80223.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','128',256,'2','1',7659.55,7659.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','129',257,'1','1',80223.79,80784.47,0.00,0.00,560.68,426116.80,0.00,0.00,0.00),('1','277','1','129',258,'2','1',7659.55,7659.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','130',259,'1','1',80784.47,81471.50,0.00,0.00,687.03,522142.80,0.00,0.00,0.00),('1','277','1','130',260,'2','1',7659.55,7659.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','131',261,'1','1',81471.50,82507.91,0.00,0.00,1036.41,787671.60,0.00,0.00,0.00),('1','277','1','131',262,'2','1',7659.55,7718.55,0.00,0.00,59.00,42185.00,0.00,0.00,0.00),('1','277','1','132',263,'1','1',82507.91,83447.13,0.00,0.00,939.22,713807.20,0.00,0.00,0.00),('1','277','1','132',264,'2','1',7718.55,7808.55,0.00,0.00,90.00,64350.00,0.00,0.00,0.00),('1','277','1','133',265,'1','1',83447.13,84367.21,0.00,0.00,920.08,699260.80,0.00,0.00,0.00),('1','277','1','133',266,'2','1',7808.55,7808.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','134',267,'1','1',84367.21,85096.50,0.00,0.00,729.29,554260.40,0.00,0.00,0.00),('1','277','1','134',268,'2','1',7808.55,7808.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','135',269,'1','1',85096.50,85096.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','135',270,'2','1',7808.55,7808.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','136',271,'1','1',85096.50,85986.95,0.00,0.00,890.45,676742.00,0.00,0.00,0.00),('1','277','1','136',272,'2','1',7808.55,7922.55,0.00,0.00,114.00,81510.00,0.00,0.00,0.00),('1','277','1','137',273,'1','1',85986.95,86979.49,0.00,0.00,992.54,754330.40,0.00,0.00,0.00),('1','277','1','137',274,'2','1',7922.55,7944.55,0.00,0.00,22.00,15730.00,0.00,0.00,0.00),('1','277','1','138',275,'1','1',86979.49,87686.67,0.00,0.00,707.18,537456.80,0.00,0.00,0.00),('1','277','1','138',276,'2','1',7944.55,7944.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','139',277,'1','1',87686.67,88725.21,0.00,0.00,1038.54,789290.40,0.00,0.00,0.00),('1','277','1','139',278,'2','1',7944.55,8198.05,0.00,0.00,253.50,179985.00,0.00,0.00,0.00),('1','277','1','140',279,'1','1',88725.21,89707.80,0.00,0.00,982.59,746768.40,0.00,0.00,0.00),('1','277','1','140',280,'2','1',8198.05,8219.75,0.00,0.00,21.70,15407.00,0.00,0.00,0.00),('1','277','1','141',281,'1','1',89707.80,90168.34,0.00,0.00,460.54,350010.40,0.00,0.00,0.00),('1','277','1','141',282,'2','1',8219.75,8279.75,0.00,0.00,60.00,42600.00,0.00,0.00,0.00),('1','277','1','142',283,'1','1',90168.34,90168.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','142',284,'2','1',8279.75,8279.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','143',285,'1','1',90168.34,91325.11,0.00,0.00,1156.77,879145.20,0.00,0.00,0.00),('1','277','1','143',286,'2','1',8279.75,8279.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','144',287,'1','1',91325.11,92317.00,0.00,0.00,991.89,753836.40,0.00,0.00,0.00),('1','277','1','144',288,'2','1',8279.75,8374.75,0.00,0.00,95.00,66500.00,0.00,0.00,0.00),('1','277','1','145',289,'1','1',92317.00,93246.55,0.00,0.00,929.55,706458.00,0.00,0.00,0.00),('1','277','1','145',290,'2','1',8374.75,8524.75,0.00,0.00,150.00,105000.00,0.00,0.00,0.00),('1','277','1','146',291,'1','1',93246.55,94223.39,0.00,0.00,976.84,742398.40,0.00,0.00,0.00),('1','277','1','146',292,'2','1',8524.75,8733.75,0.00,0.00,209.00,146300.00,0.00,0.00,0.00),('1','277','1','147',293,'1','1',94223.39,94906.11,0.00,0.00,682.72,518867.20,0.00,0.00,0.00),('1','277','1','147',294,'2','1',8733.75,8733.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','148',295,'1','1',94906.11,95839.89,0.00,0.00,933.78,709672.80,0.00,0.00,0.00),('1','277','1','148',296,'2','1',8733.75,8733.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','149',297,'1','1',95839.89,96738.56,0.00,0.00,898.67,682989.20,0.00,0.00,0.00),('1','277','1','149',298,'2','1',8733.75,8833.75,0.00,0.00,100.00,70000.00,0.00,0.00,0.00),('1','277','1','150',299,'1','1',96738.56,97506.23,0.00,0.00,767.67,583429.20,0.00,0.00,0.00),('1','277','1','150',300,'2','1',8833.75,8833.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','151',301,'1','1',97506.23,98323.02,0.00,0.00,816.79,620760.40,0.00,0.00,0.00),('1','277','1','151',302,'2','1',8833.75,8851.75,0.00,0.00,18.00,12600.00,0.00,0.00,0.00),('1','277','1','152',303,'1','1',98323.02,99253.58,0.00,0.00,930.56,707225.60,0.00,0.00,0.00),('1','277','1','152',304,'2','1',8851.75,8951.75,0.00,0.00,100.00,70000.00,0.00,0.00,0.00),('1','277','1','153',305,'1','1',99253.58,99411.33,0.00,0.00,157.75,119890.00,0.00,0.00,0.00),('1','277','1','153',306,'2','1',8951.75,8951.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','154',307,'1','1',99411.33,100002.30,0.00,0.00,590.97,434953.92,0.00,0.00,0.00),('1','277','1','154',308,'2','1',8951.75,8951.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','155',309,'1','1',100002.30,100002.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','155',310,'2','1',8951.75,8951.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','156',311,'1','1',100002.30,100918.14,0.00,0.00,915.84,674058.24,0.00,0.00,0.00),('1','277','1','156',312,'2','1',8951.75,9049.75,0.00,0.00,98.00,68600.00,0.00,0.00,0.00),('1','277','1','157',313,'1','1',100918.14,101916.87,0.00,0.00,998.73,735065.28,0.00,0.00,0.00),('1','277','1','157',314,'2','1',9049.75,9049.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','158',315,'1','1',101916.87,102799.22,0.00,0.00,882.35,649409.60,0.00,0.00,0.00),('1','277','1','158',316,'2','1',9049.75,9143.75,0.00,0.00,94.00,65800.00,0.00,0.00,0.00),('1','277','1','159',317,'1','1',102799.22,103531.81,0.00,0.00,732.59,539186.24,0.00,0.00,0.00),('1','277','1','159',318,'2','1',9143.75,9293.75,0.00,0.00,150.00,105000.00,0.00,0.00,0.00),('1','277','1','160',319,'1','1',103531.81,104402.22,0.00,0.00,870.41,640621.76,0.00,0.00,0.00),('1','277','1','160',320,'2','1',9293.75,9312.95,0.00,0.00,19.20,13440.00,0.00,0.00,0.00),('1','277','1','161',321,'1','1',104402.22,104775.60,0.00,0.00,373.38,274807.68,0.00,0.00,0.00),('1','277','1','161',322,'2','1',9312.95,9362.95,0.00,0.00,50.00,35000.00,0.00,0.00,0.00),('1','277','1','162',323,'1','1',104775.60,104775.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','162',324,'2','1',9362.95,9362.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','163',325,'1','1',104775.60,105041.64,0.00,0.00,266.04,195805.44,0.00,0.00,0.00),('1','277','1','163',326,'2','1',9362.95,9362.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','164',327,'1','1',105041.64,105830.37,0.00,0.00,788.73,580505.28,0.00,0.00,0.00),('1','277','1','164',328,'2','1',9362.95,9407.95,0.00,0.00,45.00,31500.00,0.00,0.00,0.00),('1','277','1','165',329,'1','1',105830.37,106699.05,0.00,0.00,868.68,639348.48,0.00,0.00,0.00),('1','277','1','165',330,'2','1',9407.95,9407.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','166',331,'1','1',106699.05,107770.91,0.00,0.00,1071.86,788888.96,0.00,0.00,0.00),('1','277','1','166',332,'2','1',9407.95,9455.95,0.00,0.00,48.00,33600.00,0.00,0.00,0.00),('1','277','1','167',333,'1','1',107770.91,108949.69,0.00,0.00,1178.78,867582.08,0.00,0.00,0.00),('1','277','1','167',334,'2','1',9455.95,9735.95,0.00,0.00,280.00,196000.00,0.00,0.00,0.00),('1','277','1','168',335,'1','1',108949.69,109271.85,0.00,0.00,322.16,237109.76,0.00,0.00,0.00),('1','277','1','168',336,'2','1',9735.95,9875.95,0.00,0.00,140.00,98000.00,0.00,0.00,0.00),('1','277','1','169',337,'1','1',109271.85,109889.44,0.00,0.00,617.59,454546.24,0.00,0.00,0.00),('1','277','1','169',338,'2','1',9875.95,10335.95,0.00,0.00,460.00,322000.00,0.00,0.00,0.00),('1','277','1','170',339,'1','1',109889.44,111147.70,0.00,0.00,1258.26,926079.36,0.00,0.00,0.00),('1','277','1','170',340,'2','1',10335.95,10695.95,0.00,0.00,360.00,252000.00,0.00,0.00,0.00),('1','277','1','171',341,'1','1',111147.70,112285.68,0.00,0.00,1137.98,837553.28,0.00,0.00,0.00),('1','277','1','171',342,'2','1',10695.95,11337.52,0.00,0.00,641.57,449099.00,0.00,0.00,0.00),('1','277','1','172',343,'1','1',112285.68,112765.48,0.00,0.00,479.80,353132.80,0.00,0.00,0.00),('1','277','1','172',344,'2','1',11337.52,11392.52,0.00,0.00,55.00,38500.00,0.00,0.00,0.00),('1','277','1','173',345,'1','1',112765.48,112765.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','173',346,'2','1',11392.52,11392.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','174',347,'1','1',112765.48,113727.00,0.00,0.00,961.52,707678.72,0.00,0.00,0.00),('1','277','1','174',348,'2','1',11392.52,11547.52,0.00,0.00,155.00,108500.00,0.00,0.00,0.00),('1','277','1','175',349,'1','1',113727.00,115471.54,0.00,0.00,1744.54,1283981.44,0.00,0.00,0.00),('1','277','1','175',350,'2','1',11547.52,12435.52,0.00,0.00,888.00,621600.00,0.00,0.00,0.00),('1','277','1','176',351,'1','1',115471.54,115880.35,0.00,0.00,408.81,300884.16,0.00,0.00,0.00),('1','277','1','176',352,'2','1',12435.52,12535.52,0.00,0.00,100.00,70000.00,0.00,0.00,0.00),('1','277','1','177',353,'1','1',115880.35,116380.64,0.00,0.00,500.29,368213.44,0.00,0.00,0.00),('1','277','1','177',354,'2','1',12535.52,12535.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','178',355,'1','1',116380.64,116910.07,0.00,0.00,529.43,389660.48,0.00,0.00,0.00),('1','277','1','178',356,'2','1',12535.52,12640.52,0.00,0.00,105.00,73500.00,0.00,0.00,0.00),('1','277','1','179',357,'1','1',116910.07,117345.19,0.00,0.00,435.12,320248.32,0.00,0.00,0.00),('1','277','1','179',358,'2','1',12640.52,12700.52,0.00,0.00,60.00,42000.00,0.00,0.00,0.00),('1','277','1','180',359,'1','1',117345.19,118205.09,0.00,0.00,859.90,632886.40,0.00,0.00,0.00),('1','277','1','180',360,'2','1',12700.52,12748.52,0.00,0.00,48.00,33600.00,0.00,0.00,0.00),('1','277','1','181',361,'1','1',118205.09,119129.98,0.00,0.00,924.89,680719.04,0.00,0.00,0.00),('1','277','1','181',362,'2','1',12748.52,12748.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','182',363,'1','1',119129.98,119979.61,0.00,0.00,849.63,625327.68,0.00,0.00,0.00),('1','277','1','182',364,'2','1',12748.52,12889.94,0.00,0.00,141.42,98994.00,0.00,0.00,0.00),('1','277','1','183',365,'1','1',119979.61,121069.10,0.00,0.00,1089.49,801864.64,0.00,0.00,0.00),('1','277','1','183',366,'2','1',12889.94,13047.94,0.00,0.00,158.00,110600.00,0.00,0.00,0.00),('1','277','1','184',367,'1','1',121069.10,121854.36,0.00,0.00,785.26,577951.36,0.00,0.00,0.00),('1','277','1','184',368,'2','1',13047.94,13047.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','185',369,'1','1',121854.36,122717.29,0.00,0.00,862.93,635116.48,0.00,0.00,0.00),('1','277','1','185',370,'2','1',13047.94,13312.94,0.00,0.00,265.00,185500.00,0.00,0.00,0.00),('1','277','1','186',371,'1','1',122717.29,123466.93,0.00,0.00,749.64,551735.04,0.00,0.00,0.00),('1','277','1','186',372,'2','1',13312.94,13478.52,0.00,0.00,165.58,115906.00,0.00,0.00,0.00),('1','277','1','187',373,'1','1',123466.93,123877.10,0.00,0.00,410.17,301885.12,0.00,0.00,0.00),('1','277','1','187',374,'2','1',13478.52,13478.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','188',375,'1','1',123877.10,124448.85,0.00,0.00,571.75,420808.00,0.00,0.00,0.00),('1','277','1','188',376,'2','1',13478.52,13583.88,0.00,0.00,105.36,73752.00,0.00,0.00,0.00),('1','277','1','189',377,'1','1',124448.85,124774.26,0.00,0.00,325.41,239501.76,0.00,0.00,0.00),('1','277','1','189',378,'2','1',13583.88,13583.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','190',379,'1','1',124774.26,125794.17,0.00,0.00,1019.91,750653.76,0.00,0.00,0.00),('1','277','1','190',380,'2','1',13583.88,13631.88,0.00,0.00,48.00,33120.00,0.00,0.00,0.00),('1','277','1','191',381,'1','1',125794.17,126821.52,0.00,0.00,1027.35,756129.60,0.00,0.00,0.00),('1','277','1','191',382,'2','1',13631.88,13631.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','192',383,'1','1',126821.52,126850.45,0.00,0.00,28.93,21292.48,0.00,0.00,0.00),('1','277','1','192',384,'2','1',13631.88,13631.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','193',385,'1','1',126850.45,127731.48,0.00,0.00,881.03,648438.08,0.00,0.00,0.00),('1','277','1','193',386,'2','1',13631.88,13681.88,0.00,0.00,50.00,34500.00,0.00,0.00,0.00),('1','277','1','194',387,'1','1',127731.48,128524.88,0.00,0.00,793.40,583942.40,0.00,0.00,0.00),('1','277','1','194',388,'2','1',13681.88,13739.88,0.00,0.00,58.00,40020.00,0.00,0.00,0.00),('1','277','1','195',389,'1','1',128524.88,129340.27,0.00,0.00,815.39,600127.04,0.00,0.00,0.00),('1','277','1','195',390,'2','1',13739.88,13789.88,0.00,0.00,50.00,34500.00,0.00,0.00,0.00),('1','277','1','196',391,'1','1',129340.27,130164.66,0.00,0.00,824.39,606751.04,0.00,0.00,0.00),('1','277','1','196',392,'2','1',13789.88,13844.88,0.00,0.00,55.00,37950.00,0.00,0.00,0.00),('1','277','1','197',393,'1','1',130164.66,131102.88,0.00,0.00,938.22,690529.92,0.00,0.00,0.00),('1','277','1','197',394,'2','1',13844.88,13994.88,0.00,0.00,150.00,103500.00,0.00,0.00,0.00),('1','277','1','198',395,'1','1',131102.88,131721.58,0.00,0.00,618.70,455363.20,0.00,0.00,0.00),('1','277','1','198',396,'2','1',13994.88,13994.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','199',397,'1','1',131721.58,133065.46,0.00,0.00,1343.88,989095.68,0.00,0.00,0.00),('1','277','1','199',398,'2','1',13994.88,14434.88,0.00,0.00,440.00,303600.00,0.00,0.00,0.00),('1','277','1','200',399,'1','1',133065.46,134090.68,0.00,0.00,1025.22,754561.92,0.00,0.00,0.00),('1','277','1','200',400,'2','1',14434.88,14484.88,0.00,0.00,50.00,34500.00,0.00,0.00,0.00),('1','277','1','201',401,'1','1',134090.68,134643.23,0.00,0.00,552.55,406676.80,0.00,0.00,0.00),('1','277','1','201',402,'2','1',14484.88,14644.88,0.00,0.00,160.00,110400.00,0.00,0.00,0.00),('1','277','1','202',403,'1','1',134643.23,135319.06,0.00,0.00,675.83,497410.88,0.00,0.00,0.00),('1','277','1','202',404,'2','1',14644.88,14644.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','203',405,'1','1',135319.06,136137.51,0.00,0.00,818.45,602379.20,0.00,0.00,0.00),('1','277','1','203',406,'2','1',14644.88,14694.88,0.00,0.00,50.00,34500.00,0.00,0.00,0.00),('1','277','1','204',407,'1','1',136137.51,136851.83,0.00,0.00,714.32,525739.52,0.00,0.00,0.00),('1','277','1','204',408,'2','1',14694.88,14794.88,0.00,0.00,100.00,69000.00,0.00,0.00,0.00),('1','277','1','205',409,'1','1',136851.83,137069.39,0.00,0.00,217.56,160124.16,0.00,0.00,0.00),('1','277','1','205',410,'2','1',14794.88,14964.88,0.00,0.00,170.00,117300.00,0.00,0.00,0.00),('1','277','1','206',411,'1','1',137069.39,137386.32,0.00,0.00,316.93,233260.48,0.00,0.00,0.00),('1','277','1','206',412,'2','1',14964.88,15029.88,0.00,0.00,65.00,44200.00,0.00,0.00,0.00),('1','277','1','207',413,'1','1',137386.32,138225.95,0.00,0.00,839.63,617967.68,0.00,0.00,0.00),('1','277','1','207',414,'2','1',15029.88,15237.88,0.00,0.00,208.00,141440.00,0.00,0.00,0.00),('1','277','1','208',415,'1','1',138225.95,138908.39,0.00,0.00,682.44,502275.84,0.00,0.00,0.00),('1','277','1','208',416,'2','1',15237.88,15620.88,0.00,0.00,383.00,260440.00,0.00,0.00,0.00),('1','277','1','209',417,'1','1',138908.39,139499.30,0.00,0.00,590.91,434909.76,0.00,0.00,0.00),('1','277','1','209',418,'2','1',15620.88,15830.88,0.00,0.00,210.00,142800.00,0.00,0.00,0.00),('1','277','1','210',419,'1','1',139499.30,140146.21,0.00,0.00,646.91,476125.76,0.00,0.00,0.00),('1','277','1','210',420,'2','1',15830.88,16130.88,0.00,0.00,300.00,204000.00,0.00,0.00,0.00),('1','277','1','211',421,'1','1',140146.21,140739.92,0.00,0.00,593.71,436970.56,0.00,0.00,0.00),('1','277','1','211',422,'2','1',16130.88,16280.88,0.00,0.00,150.00,102000.00,0.00,0.00,0.00),('1','277','1','212',423,'1','1',140739.92,141494.71,0.00,0.00,754.79,555525.44,0.00,0.00,0.00),('1','277','1','212',424,'2','1',16280.88,16733.88,0.00,0.00,453.00,308040.00,0.00,0.00,0.00),('1','277','1','213',425,'1','1',141494.71,142321.52,0.00,0.00,826.81,608532.16,0.00,0.00,0.00),('1','277','1','213',426,'2','1',16733.88,17053.88,0.00,0.00,320.00,217600.00,0.00,0.00,0.00),('1','277','1','214',427,'1','1',142321.52,143122.86,0.00,0.00,801.34,589786.24,0.00,0.00,0.00),('1','277','1','214',428,'2','1',17053.88,17208.88,0.00,0.00,155.00,105400.00,0.00,0.00,0.00),('1','277','1','215',429,'1','1',143122.86,143878.04,0.00,0.00,755.18,555812.48,0.00,0.00,0.00),('1','277','1','215',430,'2','1',17208.88,17258.88,0.00,0.00,50.00,34000.00,0.00,0.00,0.00),('1','277','1','216',431,'1','1',143878.04,144512.75,0.00,0.00,634.71,471410.56,0.00,0.00,0.00),('1','277','1','216',432,'2','1',17258.88,17358.88,0.00,0.00,100.00,68000.00,0.00,0.00,0.00),('1','277','1','217',433,'1','1',144512.75,145121.60,0.00,0.00,608.85,448113.60,0.00,0.00,0.00),('1','277','1','217',434,'2','1',17358.88,17860.88,0.00,0.00,502.00,341360.00,0.00,0.00,0.00),('1','277','1','218',435,'1','1',145121.60,146024.77,0.00,0.00,903.17,664733.12,0.00,0.00,0.00),('1','277','1','218',436,'2','1',17860.88,17860.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','219',437,'1','1',146024.77,146850.48,0.00,0.00,825.71,607722.56,0.00,0.00,0.00),('1','277','1','219',438,'2','1',17860.88,17910.88,0.00,0.00,50.00,34000.00,0.00,0.00,0.00),('1','277','1','220',439,'1','1',146850.48,147886.23,0.00,0.00,1035.75,762312.00,0.00,0.00,0.00),('1','277','1','220',440,'2','1',17910.88,18154.99,0.00,0.00,244.11,165994.80,0.00,0.00,0.00),('1','277','1','221',441,'1','1',147886.23,148766.40,0.00,0.00,880.17,647805.12,0.00,0.00,0.00),('1','277','1','221',442,'2','1',18154.99,18204.99,0.00,0.00,50.00,34000.00,0.00,0.00,0.00),('1','277','1','222',443,'1','1',148766.40,149624.85,0.00,0.00,858.45,631819.20,0.00,0.00,0.00),('1','277','1','222',444,'2','1',18204.99,18304.99,0.00,0.00,100.00,68000.00,0.00,0.00,0.00),('1','277','1','223',445,'1','1',149624.85,150498.72,0.00,0.00,873.87,643168.32,0.00,0.00,0.00),('1','277','1','223',446,'2','1',18304.99,18354.99,0.00,0.00,50.00,34000.00,0.00,0.00,0.00),('1','277','1','224',447,'1','1',150498.72,151180.92,0.00,0.00,682.20,502099.20,0.00,0.00,0.00),('1','277','1','224',448,'2','1',18354.99,18354.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','225',449,'1','1',151180.92,152005.38,0.00,0.00,824.46,606802.56,0.00,0.00,0.00),('1','277','1','225',450,'2','1',18354.99,18729.99,0.00,0.00,375.00,253125.00,0.00,0.00,0.00),('1','277','1','226',451,'1','1',152005.38,153021.30,0.00,0.00,1015.92,747717.12,0.00,0.00,0.00),('1','277','1','226',452,'2','1',18729.99,18729.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','227',453,'1','1',153021.30,153441.40,0.00,0.00,420.10,309193.60,0.00,0.00,0.00),('1','277','1','227',454,'2','1',18729.99,18729.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','228',455,'1','1',153441.40,153834.23,0.00,0.00,392.83,289122.88,0.00,0.00,0.00),('1','277','1','228',456,'2','1',18729.99,18768.50,0.00,0.00,38.51,25994.25,0.00,0.00,0.00),('1','277','1','229',457,'1','1',153834.23,154652.08,0.00,0.00,817.85,601937.60,0.00,0.00,0.00),('1','277','1','229',458,'2','1',18768.50,18768.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','230',459,'1','1',154652.08,155246.02,0.00,0.00,593.94,437139.84,0.00,0.00,0.00),('1','277','1','230',460,'2','1',18768.50,18868.50,0.00,0.00,100.00,67500.00,0.00,0.00,0.00),('1','277','1','231',461,'1','1',155246.02,156012.06,0.00,0.00,766.04,563805.44,0.00,0.00,0.00),('1','277','1','231',462,'2','1',18868.50,18918.50,0.00,0.00,50.00,33750.00,0.00,0.00,0.00),('1','277','1','232',463,'1','1',156012.06,156690.23,0.00,0.00,678.17,499133.12,0.00,0.00,0.00),('1','277','1','232',464,'2','1',18918.50,18977.50,0.00,0.00,59.00,39825.00,0.00,0.00,0.00),('1','277','1','233',465,'1','1',156690.23,157331.71,0.00,0.00,641.48,472129.28,0.00,0.00,0.00),('1','277','1','233',466,'2','1',18977.50,19027.50,0.00,0.00,50.00,33750.00,0.00,0.00,0.00),('1','277','1','234',467,'1','1',157331.71,158246.87,0.00,0.00,915.16,673557.76,0.00,0.00,0.00),('1','277','1','234',468,'2','1',19027.50,19027.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','235',469,'1','1',158246.87,159137.07,0.00,0.00,890.20,655187.20,0.00,0.00,0.00),('1','277','1','235',470,'2','1',19027.50,19027.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','236',471,'1','1',159137.07,159881.21,0.00,0.00,744.14,547687.04,0.00,0.00,0.00),('1','277','1','236',472,'2','1',19027.50,19077.50,0.00,0.00,50.00,33750.00,0.00,0.00,0.00),('1','277','1','237',473,'1','1',159881.21,160602.93,0.00,0.00,721.72,531185.92,0.00,0.00,0.00),('1','277','1','237',474,'2','1',19077.50,19140.00,0.00,0.00,62.50,42187.50,0.00,0.00,0.00),('1','277','1','238',475,'1','1',160602.93,161315.90,0.00,0.00,712.97,524745.92,0.00,0.00,0.00),('1','277','1','238',476,'2','1',19140.00,19140.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','239',477,'1','1',161315.90,162091.81,0.00,0.00,775.91,571069.76,0.00,0.00,0.00),('1','277','1','239',478,'2','1',19140.00,19656.00,0.00,0.00,516.00,348300.00,0.00,0.00,0.00),('1','277','1','240',479,'1','1',162091.81,162718.37,0.00,0.00,626.56,461148.16,0.00,0.00,0.00),('1','277','1','240',480,'2','1',19656.00,19656.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','241',481,'1','1',162718.37,163106.89,0.00,0.00,388.52,285950.72,0.00,0.00,0.00),('1','277','1','241',482,'2','1',19656.00,19706.00,0.00,0.00,50.00,33750.00,0.00,0.00,0.00),('1','277','1','242',483,'1','1',163106.89,164149.57,0.00,0.00,1042.68,767412.48,0.00,0.00,0.00),('1','277','1','242',484,'2','1',19706.00,19921.00,0.00,0.00,215.00,145125.00,0.00,0.00,0.00),('1','277','1','243',485,'1','1',164149.57,165149.52,0.00,0.00,999.95,735963.20,0.00,0.00,0.00),('1','277','1','243',486,'2','1',19921.00,20628.00,0.00,0.00,707.00,477225.00,0.00,0.00,0.00),('1','277','1','244',487,'1','1',165149.52,166171.88,0.00,0.00,1022.36,752456.96,0.00,0.00,0.00),('1','277','1','244',488,'2','1',20628.00,20840.00,0.00,0.00,212.00,143100.00,0.00,0.00,0.00),('1','277','1','245',489,'1','1',166171.88,166534.37,0.00,0.00,362.49,266792.64,0.00,0.00,0.00),('1','277','1','245',490,'2','1',20840.00,20840.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','246',491,'1','1',166534.37,167210.32,0.00,0.00,675.95,497499.20,0.00,0.00,0.00),('1','277','1','246',492,'2','1',20840.00,20890.00,0.00,0.00,50.00,33750.00,0.00,0.00,0.00),('1','277','1','247',493,'1','1',167210.32,167928.63,0.00,0.00,718.31,528676.16,0.00,0.00,0.00),('1','277','1','247',494,'2','1',20890.00,21050.00,0.00,0.00,160.00,108000.00,0.00,0.00,0.00),('1','277','1','248',495,'1','1',167928.63,168612.82,0.00,0.00,684.19,503563.84,0.00,0.00,0.00),('1','277','1','248',496,'2','1',21050.00,21050.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','249',497,'1','1',168612.82,169659.45,0.00,0.00,1046.63,770319.68,0.00,0.00,0.00),('1','277','1','249',498,'2','1',21050.00,21319.00,0.00,0.00,269.00,181575.00,0.00,0.00,0.00),('1','277','1','250',499,'1','1',169659.45,170814.10,0.00,0.00,1154.65,849822.40,0.00,0.00,0.00),('1','277','1','250',500,'2','1',21319.00,21424.00,0.00,0.00,105.00,70875.00,0.00,0.00,0.00),('1','277','1','251',501,'1','1',170814.10,171521.01,0.00,0.00,706.91,520285.76,0.00,0.00,0.00),('1','277','1','251',502,'2','1',21424.00,21679.00,0.00,0.00,255.00,172125.00,0.00,0.00,0.00),('1','277','1','252',503,'1','1',171521.01,172183.51,0.00,0.00,662.50,487600.00,0.00,0.00,0.00),('1','277','1','252',504,'2','1',21679.00,21988.40,0.00,0.00,309.40,208845.00,0.00,0.00,0.00),('1','277','1','253',505,'1','1',172183.51,172252.62,0.00,0.00,69.11,50864.96,0.00,0.00,0.00),('1','277','1','253',506,'2','1',21988.40,21988.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','254',507,'1','1',172252.62,172507.90,0.00,0.00,255.28,178696.00,0.00,0.00,0.00),('1','277','1','254',508,'2','1',21988.40,22400.90,0.00,0.00,412.50,268125.00,0.00,0.00,0.00),('1','277','1','255',509,'1','1',172507.90,173080.04,0.00,0.00,572.14,400498.00,0.00,0.00,0.00),('1','277','1','255',510,'2','1',22400.90,22550.90,0.00,0.00,150.00,98700.00,0.00,0.00,0.00),('1','277','1','256',511,'1','1',173080.04,174038.98,0.00,0.00,958.94,671258.00,0.00,0.00,0.00),('1','277','1','256',512,'2','1',22550.90,22750.90,0.00,0.00,200.00,131600.00,0.00,0.00,0.00),('1','277','1','257',513,'1','1',174038.98,174448.31,0.00,0.00,409.33,286531.00,0.00,0.00,0.00),('1','277','1','257',514,'2','1',22750.90,23150.90,0.00,0.00,400.00,263200.00,0.00,0.00,0.00),('1','277','1','258',515,'1','1',174448.31,174578.67,0.00,0.00,130.36,91252.00,0.00,0.00,0.00),('1','277','1','258',516,'2','1',23150.90,23150.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','259',517,'1','1',174578.67,175634.19,0.00,0.00,1055.52,738864.00,0.00,0.00,0.00),('1','277','1','259',518,'2','1',23150.90,23495.90,0.00,0.00,345.00,227010.00,0.00,0.00,0.00),('1','277','1','260',519,'1','1',175634.19,176686.90,0.00,0.00,1052.71,736897.00,0.00,0.00,0.00),('1','277','1','260',520,'2','1',23495.90,23575.90,0.00,0.00,80.00,52640.00,0.00,0.00,0.00),('1','277','1','261',521,'1','1',176686.90,177375.48,0.00,0.00,688.58,482006.00,0.00,0.00,0.00),('1','277','1','261',522,'2','1',23575.90,23910.90,0.00,0.00,335.00,220430.00,0.00,0.00,0.00),('1','277','1','262',523,'1','1',177375.48,177979.90,0.00,0.00,604.42,423094.00,0.00,0.00,0.00),('1','277','1','262',524,'2','1',23910.90,24054.97,0.00,0.00,144.07,94798.06,0.00,0.00,0.00),('1','277','1','263',525,'1','1',177979.90,178780.52,0.00,0.00,800.62,560434.00,0.00,0.00,0.00),('1','277','1','263',526,'2','1',24054.97,24154.97,0.00,0.00,100.00,65800.00,0.00,0.00,0.00),('1','277','1','264',527,'1','1',178780.52,178893.53,0.00,0.00,113.01,79107.00,0.00,0.00,0.00),('1','277','1','264',528,'2','1',24154.97,24154.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','265',529,'1','1',178893.53,179550.89,0.00,0.00,657.36,460152.00,0.00,0.00,0.00),('1','277','1','265',530,'2','1',24154.97,24199.97,0.00,0.00,45.00,29610.00,0.00,0.00,0.00),('1','277','1','266',531,'1','1',179550.89,180123.47,0.00,0.00,572.58,400806.00,0.00,0.00,0.00),('1','277','1','266',532,'2','1',24199.97,24302.70,0.00,0.00,102.73,67596.34,0.00,0.00,0.00),('1','277','1','267',533,'1','1',180123.47,180437.69,0.00,0.00,314.22,219954.00,0.00,0.00,0.00),('1','277','1','267',534,'2','1',24302.70,24302.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','277','1','268',535,'1','1',180437.69,180812.19,0.00,0.00,374.50,262150.00,0.00,0.00,0.00),('1','277','1','268',536,'2','1',24302.70,24352.70,0.00,0.00,50.00,32500.00,0.00,0.00,0.00),('1','277','1','269',537,'1','1',180812.19,181577.64,0.00,0.00,765.45,535815.00,0.00,0.00,0.00),('1','277','1','269',538,'2','1',24352.70,24402.70,0.00,0.00,50.00,32500.00,0.00,0.00,0.00),('1','277','1','270',539,'1','1',181577.64,182337.84,0.00,0.00,760.20,532140.00,0.00,0.00,0.00),('1','277','1','270',540,'2','1',24402.70,24402.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=271 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','277','1','1',682.00,744.00,0.00,371.95,253669.90,276730.80,23060.90,1),('1','277','2','1',682.00,744.00,0.00,155.09,105771.38,115386.96,9615.58,2),('1','277','3','1',682.00,744.00,0.00,206.48,140819.36,153621.12,12801.76,3),('1','277','4','1',682.00,744.00,0.00,236.43,161245.26,175903.92,14658.66,4),('1','277','5','1',682.00,744.00,0.00,248.01,169142.82,184519.44,15376.62,5),('1','277','6','1',682.00,744.00,0.00,223.63,152515.66,166380.72,13865.06,6),('1','277','7','1',682.00,744.00,0.00,390.60,266389.20,290606.40,24217.20,7),('1','277','8','1',682.00,744.00,0.00,348.51,237683.82,259291.44,21607.62,8),('1','277','9','1',682.00,744.00,0.00,335.45,228776.90,247124.80,18347.90,9),('1','277','10','1',682.00,744.00,0.00,363.53,247927.46,268016.32,20088.86,10),('1','277','11','1',682.00,744.00,0.00,337.10,229902.20,248602.79,18700.59,11),('1','277','12','1',682.00,744.00,0.00,449.58,306613.56,334487.52,27873.96,12),('1','277','13','1',682.00,744.00,0.00,708.64,483292.48,502689.92,19397.44,13),('1','277','14','1',682.00,728.00,0.00,354.61,241844.02,258156.08,16312.06,14),('1','277','15','1',682.00,728.00,0.00,663.47,452486.54,483006.16,30519.62,15),('1','277','16','1',682.00,728.00,0.00,0.00,0.00,0.00,0.00,16),('1','277','17','1',665.00,728.00,0.00,1644.65,1093692.25,1158829.18,65136.93,17),('1','277','18','1',665.00,728.00,0.00,533.86,355016.90,383782.58,28765.68,18),('1','277','19','1',665.00,728.00,0.00,1325.72,881603.80,938988.16,57384.36,19),('1','277','20','1',665.00,728.00,0.00,698.03,464193.25,495625.84,31432.59,20),('1','277','21','1',675.00,728.00,0.00,556.92,375921.00,402137.76,26216.76,21),('1','277','22','1',675.00,728.00,0.00,771.71,520904.25,555501.88,34597.63,22),('1','277','23','1',675.00,728.00,0.00,814.62,549868.50,586443.36,36574.86,23),('1','277','24','1',675.00,728.00,0.00,501.26,383463.90,377757.60,-5706.30,24),('1','277','25','1',765.00,760.00,0.00,458.41,350683.65,336500.40,-14183.25,25),('1','277','26','1',765.00,728.00,0.00,497.87,380870.55,361945.36,-18925.19,26),('1','277','27','1',765.00,728.00,0.00,611.63,467896.95,444384.64,-23512.31,27),('1','277','28','1',765.00,728.00,0.00,535.01,409282.65,389487.28,-19795.37,28),('1','277','29','1',765.00,728.00,0.00,635.18,485912.70,460611.04,-25301.66,29),('1','277','30','1',765.00,728.00,0.00,816.98,624989.70,592817.44,-32172.26,30),('1','277','31','1',765.00,728.00,0.00,719.48,550402.20,522575.44,-27826.76,31),('1','277','32','1',765.00,728.00,0.00,736.21,563200.65,534376.88,-28823.77,32),('1','277','33','1',765.00,728.00,0.00,543.39,415693.35,395587.92,-20105.43,33),('1','277','34','1',765.00,728.00,0.00,364.53,278865.45,265017.84,-13847.61,34),('1','277','35','1',765.00,728.00,0.00,472.09,361148.85,343280.12,-17868.73,35),('1','277','36','1',765.00,728.00,0.00,663.55,447896.25,483064.40,35168.15,36),('1','277','37','1',675.00,728.00,0.00,695.24,469287.00,504154.72,34867.72,37),('1','277','38','1',675.00,728.00,0.00,613.11,413849.25,445084.08,31234.83,38),('1','277','39','1',675.00,728.00,0.00,634.30,428152.50,460690.40,32537.90,39),('1','277','40','1',675.00,728.00,0.00,916.67,618752.25,661913.08,43160.83,40),('1','277','41','1',675.00,728.00,0.00,640.19,432128.25,465338.32,33210.07,41),('1','277','42','1',675.00,728.00,0.00,610.79,412283.25,443359.12,31075.87,42),('1','277','43','1',675.00,728.00,0.00,220.38,148756.50,160436.64,11680.14,43),('1','277','44','1',675.00,728.00,0.00,764.50,516037.50,555656.00,39618.50,44),('1','277','45','1',675.00,728.00,0.00,844.67,570152.25,614919.76,44767.51,45),('1','277','46','1',675.00,728.00,0.00,954.86,644530.50,691610.08,47079.58,46),('1','277','47','1',675.00,728.00,0.00,821.85,554748.75,596994.60,42245.85,47),('1','277','48','1',675.00,728.00,0.00,811.98,548086.50,591121.44,43034.94,48),('1','277','49','1',675.00,728.00,0.00,912.68,616059.00,663950.44,47891.44,49),('1','277','50','1',675.00,728.00,0.00,191.58,129316.50,139470.24,10153.74,50),('1','277','51','1',675.00,728.00,0.00,727.88,491319.00,529464.64,38145.64,51),('1','277','52','1',675.00,728.00,0.00,856.53,578157.75,623745.84,45588.09,52),('1','277','53','1',675.00,728.00,0.00,932.56,629478.00,674716.88,45238.88,53),('1','277','54','1',675.00,728.00,0.00,773.60,522180.00,561260.56,39080.56,54),('1','277','55','1',675.00,728.00,0.00,859.68,580284.00,621087.04,40803.04,55),('1','277','56','1',675.00,728.00,0.00,806.56,544428.00,580800.08,36372.08,56),('1','277','57','1',675.00,728.00,0.00,548.50,370237.50,399308.00,29070.50,57),('1','277','58','1',675.00,728.00,0.00,970.16,654858.00,706276.48,51418.48,58),('1','277','59','1',675.00,728.00,0.00,1181.25,797343.75,859950.00,62606.25,59),('1','277','60','1',675.00,728.00,0.00,481.09,324735.75,350233.52,25497.77,60),('1','277','61','1',675.00,728.00,0.00,510.72,344736.00,371804.16,27068.16,61),('1','277','62','1',675.00,728.00,0.00,890.16,600858.00,648036.48,47178.48,62),('1','277','63','1',675.00,728.00,0.00,681.71,460154.25,496284.88,36130.63,63),('1','277','64','1',675.00,728.00,0.00,818.20,552285.00,595649.60,43364.60,64),('1','277','65','1',675.00,728.00,0.00,1028.83,694460.25,748988.24,54527.99,65),('1','277','66','1',675.00,728.00,0.00,1239.64,836757.00,902457.92,65700.92,66),('1','277','67','1',675.00,728.00,0.00,306.50,206887.50,223132.00,16244.50,67),('1','277','68','1',675.00,728.00,0.00,0.00,0.00,0.00,0.00,68),('1','277','69','1',675.00,728.00,0.00,849.40,573345.00,618363.20,45018.20,69),('1','277','70','1',675.00,728.00,0.00,1064.62,718618.50,775043.36,56424.86,70),('1','277','71','1',675.00,728.00,0.00,683.74,461524.50,497762.72,36238.22,71),('1','277','72','1',675.00,728.00,0.00,695.02,469138.50,505974.56,36836.06,72),('1','277','73','1',675.00,728.00,0.00,624.46,421510.50,454606.88,33096.38,73),('1','277','74','1',675.00,728.00,0.00,762.55,514721.25,555136.40,40415.15,74),('1','277','75','1',675.00,728.00,0.00,417.08,281529.00,303634.24,22105.24,75),('1','277','76','1',675.00,728.00,0.00,0.00,0.00,0.00,0.00,76),('1','277','77','1',660.00,728.00,0.00,1106.66,730395.60,799264.48,68868.88,77),('1','277','78','1',660.00,728.00,0.00,836.71,552228.60,607724.88,55496.28,78),('1','277','79','1',660.00,728.00,0.00,1112.37,734164.20,803801.60,69637.40,79),('1','277','80','1',660.00,728.00,0.00,1157.93,764233.80,836411.24,72177.44,80),('1','277','81','1',660.00,728.00,0.00,1230.82,812341.20,893181.80,80840.60,81),('1','277','82','1',660.00,728.00,0.00,0.00,0.00,0.00,0.00,82),('1','277','83','1',660.00,728.00,0.00,543.74,358868.40,395842.72,36974.32,83),('1','277','84','1',660.00,728.00,0.00,1055.81,696834.60,768629.68,71795.08,84),('1','277','85','1',660.00,728.00,0.00,827.66,546255.60,602536.48,56280.88,85),('1','277','86','1',660.00,728.00,0.00,825.61,544902.60,601044.08,56141.48,86),('1','277','87','1',660.00,728.00,0.00,1123.29,741371.40,817755.12,76383.72,87),('1','277','88','1',660.00,728.00,0.00,1122.51,740856.60,817187.28,76330.68,88),('1','277','89','1',660.00,728.00,0.00,0.00,0.00,0.00,0.00,89),('1','277','90','1',660.00,764.00,0.00,945.11,623772.60,722064.04,98291.44,90),('1','277','91','1',660.00,748.00,0.00,931.34,614684.40,696642.32,81957.92,91),('1','277','92','1',660.00,748.00,0.00,969.71,640008.60,725343.08,85334.48,92),('1','277','93','1',660.00,748.00,0.00,730.94,482420.40,546743.12,64322.72,93),('1','277','94','1',660.00,748.00,0.00,1094.13,722125.80,818409.24,96283.44,94),('1','277','95','1',660.00,748.00,0.00,753.58,497362.80,563677.84,66315.04,95),('1','277','96','1',660.00,748.00,0.00,651.40,429924.00,487247.20,57323.20,96),('1','277','97','1',660.00,748.00,0.00,1192.17,786832.20,891743.16,104910.96,97),('1','277','98','1',660.00,760.00,0.00,923.21,609318.60,701639.60,92321.00,98),('1','277','99','1',660.00,760.00,0.00,904.76,597141.60,687617.60,90476.00,99),('1','277','100','1',660.00,760.00,0.00,829.01,547146.60,630047.60,82901.00,100),('1','277','101','1',660.00,760.00,0.00,400.16,264105.60,304121.60,40016.00,101),('1','277','102','1',660.00,760.00,0.00,1081.58,713842.80,822000.80,108158.00,102),('1','277','103','1',660.00,760.00,0.00,898.98,593326.80,683224.80,89898.00,103),('1','277','104','1',660.00,760.00,0.00,795.17,524812.20,604329.20,79517.00,104),('1','277','105','1',660.00,800.00,0.00,758.97,500920.20,607176.00,106255.80,105),('1','277','106','1',660.00,800.00,0.00,823.43,543463.80,658744.00,115280.20,106),('1','277','107','1',660.00,800.00,0.00,360.57,237976.20,288456.00,50479.80,107),('1','277','108','1',660.00,800.00,0.00,1089.39,718997.40,827936.40,108939.00,108),('1','277','109','1',660.00,760.00,0.00,989.81,653274.60,752255.60,98981.00,109),('1','277','110','1',660.00,760.00,0.00,903.16,596085.60,686401.60,90316.00,110),('1','277','111','1',660.00,760.00,0.00,895.77,591208.20,680785.20,89577.00,111),('1','277','112','1',660.00,760.00,0.00,959.35,633171.00,729106.00,95935.00,112),('1','277','113','1',660.00,760.00,0.00,172.56,113889.60,131145.60,17256.00,113),('1','277','114','1',660.00,760.00,0.00,0.00,0.00,0.00,0.00,114),('1','277','115','1',660.00,760.00,0.00,1261.39,832517.40,958656.40,126139.00,115),('1','277','116','1',660.00,760.00,0.00,1073.45,708477.00,815822.00,107345.00,116),('1','277','117','1',660.00,760.00,0.00,773.02,510193.20,587495.20,77302.00,117),('1','277','118','1',660.00,760.00,0.00,779.36,514377.60,592313.60,77936.00,118),('1','277','119','1',660.00,760.00,0.00,427.33,282037.80,324770.80,42733.00,119),('1','277','120','1',685.00,760.00,0.00,735.75,503988.75,559170.00,55181.25,120),('1','277','121','1',685.00,760.00,0.00,648.36,444126.60,492753.60,48627.00,121),('1','277','122','1',685.00,760.00,0.00,802.95,550020.75,610242.00,60221.25,122),('1','277','123','1',685.00,760.00,0.00,758.92,519860.20,576779.20,56919.00,123),('1','277','124','1',685.00,760.00,0.00,544.34,372872.90,413698.40,40825.50,124),('1','277','125','1',685.00,760.00,0.00,747.77,512222.45,568305.20,56082.75,125),('1','277','126','1',685.00,760.00,0.00,410.86,281439.10,312253.60,30814.50,126),('1','277','127','1',685.00,760.00,0.00,285.05,195259.25,216638.00,21378.75,127),('1','277','128','1',685.00,760.00,0.00,0.00,0.00,0.00,0.00,128),('1','277','129','1',685.00,760.00,0.00,560.68,384065.80,426116.80,42051.00,129),('1','277','130','1',685.00,760.00,0.00,687.03,470615.55,522142.80,51527.25,130),('1','277','131','1',685.00,760.00,0.00,1095.41,859896.85,829856.60,-30040.25,131),('1','277','132','1',785.00,760.00,0.00,1029.22,807937.70,778157.20,-29780.50,132),('1','277','133','1',785.00,760.00,0.00,920.08,722262.80,699260.80,-23002.00,133),('1','277','134','1',785.00,760.00,0.00,729.29,572492.65,554260.40,-18232.25,134),('1','277','135','1',785.00,760.00,0.00,0.00,0.00,0.00,0.00,135),('1','277','136','1',675.00,760.00,0.00,1004.45,678003.75,758252.00,80248.25,136),('1','277','137','1',675.00,760.00,0.00,1014.54,684814.50,770060.40,85245.90,137),('1','277','138','1',675.00,760.00,0.00,707.18,477346.50,537456.80,60110.30,138),('1','277','139','1',675.00,760.00,0.00,1292.04,872127.00,969275.40,97148.40,139),('1','277','140','1',675.00,760.00,0.00,1004.29,677895.75,762175.40,84279.65,140),('1','277','141','1',675.00,760.00,0.00,520.54,351364.50,392610.40,41245.90,141),('1','277','142','1',675.00,760.00,0.00,0.00,0.00,0.00,0.00,142),('1','277','143','1',675.00,760.00,0.00,1156.77,780819.75,879145.20,98325.45,143),('1','277','144','1',675.00,760.00,0.00,1086.89,733650.75,820336.40,86685.65,144),('1','277','145','1',675.00,760.00,0.00,1079.55,728696.25,811458.00,82761.75,145),('1','277','146','1',675.00,760.00,0.00,1185.84,800442.00,888698.40,88256.40,146),('1','277','147','1',675.00,760.00,0.00,682.72,460836.00,518867.20,58031.20,147),('1','277','148','1',660.00,760.00,0.00,933.78,616294.80,709672.80,93378.00,148),('1','277','149','1',660.00,760.00,0.00,998.67,659122.20,752989.20,93867.00,149),('1','277','150','1',660.00,760.00,0.00,767.67,506662.20,583429.20,76767.00,150),('1','277','151','1',660.00,760.00,0.00,834.79,550961.40,633360.40,82399.00,151),('1','277','152','1',660.00,760.00,0.00,1030.56,680169.60,777225.60,97056.00,152),('1','277','153','1',660.00,760.00,0.00,157.75,104115.00,119890.00,15775.00,153),('1','277','154','1',660.00,760.00,0.00,590.97,390040.20,434953.92,44913.72,154),('1','277','155','1',660.00,736.00,0.00,0.00,0.00,0.00,0.00,155),('1','277','156','1',660.00,736.00,0.00,1013.84,669134.40,742658.24,73523.84,156),('1','277','157','1',660.00,736.00,0.00,998.73,659161.80,735065.28,75903.48,157),('1','277','158','1',660.00,736.00,0.00,976.35,644391.00,715209.60,70818.60,158),('1','277','159','1',660.00,736.00,0.00,882.59,582509.40,644186.24,61676.84,159),('1','277','160','1',660.00,736.00,0.00,889.61,587142.60,654061.76,66919.16,160),('1','277','161','1',660.00,736.00,0.00,423.38,279430.80,309807.68,30376.88,161),('1','277','162','1',660.00,736.00,0.00,0.00,0.00,0.00,0.00,162),('1','277','163','1',660.00,736.00,0.00,266.04,173990.16,195805.44,21815.28,163),('1','277','164','1',654.00,736.00,0.00,833.73,545259.42,612005.28,66745.86,164),('1','277','165','1',654.00,736.00,0.00,868.68,568116.72,639348.48,71231.76,165),('1','277','166','1',654.00,736.00,0.00,1119.86,732388.44,822488.96,90100.52,166),('1','277','167','1',654.00,736.00,0.00,1458.78,954042.12,1063582.08,109539.96,167),('1','277','168','1',654.00,736.00,0.00,462.16,302252.64,335109.76,32857.12,168),('1','277','169','1',654.00,736.00,0.00,1077.59,704743.86,776546.24,71802.38,169),('1','277','170','1',654.00,736.00,0.00,1618.26,1058342.04,1178079.36,119737.32,170),('1','277','171','1',654.00,736.00,0.00,1779.55,1163825.70,1286652.28,122826.58,171),('1','277','172','1',654.00,736.00,0.00,534.80,349759.20,391632.80,41873.60,172),('1','277','173','1',654.00,736.00,0.00,0.00,0.00,0.00,0.00,173),('1','277','174','1',654.00,736.00,0.00,1116.52,730204.08,816178.72,85974.64,174),('1','277','175','1',654.00,736.00,0.00,2632.54,1721681.16,1905581.44,183900.28,175),('1','277','176','1',654.00,736.00,0.00,508.81,332761.74,370884.16,38122.42,176),('1','277','177','1',654.00,736.00,0.00,500.29,327189.66,368213.44,41023.78,177),('1','277','178','1',654.00,736.00,0.00,634.43,414917.22,463160.48,48243.26,178),('1','277','179','1',654.00,736.00,0.00,495.12,323808.48,362248.32,38439.84,179),('1','277','180','1',654.00,736.00,0.00,907.90,593766.60,666486.40,72719.80,180),('1','277','181','1',654.00,736.00,0.00,924.89,604878.06,680719.04,75840.98,181),('1','277','182','1',654.00,736.00,0.00,991.05,648146.70,724321.68,76174.98,182),('1','277','183','1',654.00,736.00,0.00,1247.49,815858.46,912464.64,96606.18,183),('1','277','184','1',654.00,736.00,0.00,785.26,513560.04,577951.36,64391.32,184),('1','277','185','1',654.00,736.00,0.00,1127.93,737666.22,820616.48,82950.26,185),('1','277','186','1',654.00,736.00,0.00,915.22,598553.88,667641.04,69087.16,186),('1','277','187','1',654.00,736.00,0.00,410.17,268251.18,301885.12,33633.94,187),('1','277','188','1',654.00,736.00,0.00,677.11,442829.94,494560.00,51730.06,188),('1','277','189','1',654.00,736.00,0.00,325.41,212818.14,239501.76,26683.62,189),('1','277','190','1',654.00,736.00,0.00,1067.91,698413.14,783773.76,85360.62,190),('1','277','191','1',654.00,736.00,0.00,1027.35,671886.90,756129.60,84242.70,191),('1','277','192','1',654.00,736.00,0.00,28.93,18920.22,21292.48,2372.26,192),('1','277','193','1',654.00,736.00,0.00,931.03,608893.62,682938.08,74044.46,193),('1','277','194','1',654.00,736.00,0.00,851.40,556815.60,623962.40,67146.80,194),('1','277','195','1',654.00,736.00,0.00,865.39,565965.06,634627.04,68661.98,195),('1','277','196','1',654.00,736.00,0.00,879.39,575121.06,644701.04,69579.98,196),('1','277','197','1',654.00,736.00,0.00,1088.22,711695.88,794029.92,82334.04,197),('1','277','198','1',654.00,736.00,0.00,618.70,404629.80,455363.20,50733.40,198),('1','277','199','1',654.00,736.00,0.00,1783.88,1166657.52,1292695.68,126038.16,199),('1','277','200','1',654.00,736.00,0.00,1075.22,703193.88,789061.92,85868.04,200),('1','277','201','1',654.00,736.00,0.00,712.55,466007.70,517076.80,51069.10,201),('1','277','202','1',654.00,736.00,0.00,675.83,441992.82,497410.88,55418.06,202),('1','277','203','1',654.00,736.00,0.00,868.45,567966.30,636879.20,68912.90,203),('1','277','204','1',654.00,736.00,0.00,814.32,532565.28,594739.52,62174.24,204),('1','277','205','1',654.00,736.00,0.00,387.56,253464.24,277424.16,23959.92,205),('1','277','206','1',654.00,736.00,0.00,381.93,249782.22,277460.48,27678.26,206),('1','277','207','1',654.00,736.00,0.00,1047.63,685150.02,759407.68,74257.66,207),('1','277','208','1',654.00,736.00,0.00,1065.44,696797.76,762715.84,65918.08,208),('1','277','209','1',654.00,736.00,0.00,800.91,523795.14,577709.76,53914.62,209),('1','277','210','1',654.00,736.00,0.00,946.91,619279.14,680125.76,60846.62,210),('1','277','211','1',654.00,736.00,0.00,743.71,468537.30,538970.56,70433.26,211),('1','277','212','1',630.00,736.00,0.00,1207.79,760907.70,863565.44,102657.74,212),('1','277','213','1',630.00,736.00,0.00,1146.81,722490.30,826132.16,103641.86,213),('1','277','214','1',630.00,736.00,0.00,956.34,602494.20,695186.24,92692.04,214),('1','277','215','1',630.00,736.00,0.00,805.18,507263.40,589812.48,82549.08,215),('1','277','216','1',630.00,736.00,0.00,734.71,462867.30,539410.56,76543.26,216),('1','277','217','1',630.00,736.00,0.00,1110.85,699835.50,789473.60,89638.10,217),('1','277','218','1',630.00,736.00,0.00,903.17,568997.10,664733.12,95736.02,218),('1','277','219','1',630.00,736.00,0.00,875.71,551697.30,641722.56,90025.26,219),('1','277','220','1',630.00,736.00,0.00,1279.86,806311.80,928306.80,121995.00,220),('1','277','221','1',630.00,736.00,0.00,930.17,586007.10,681805.12,95798.02,221),('1','277','222','1',630.00,736.00,0.00,958.45,603823.50,699819.20,95995.70,222),('1','277','223','1',630.00,736.00,0.00,923.87,582038.10,677168.32,95130.22,223),('1','277','224','1',630.00,736.00,0.00,682.20,429786.00,502099.20,72313.20,224),('1','277','225','1',630.00,736.00,0.00,1199.46,755659.80,859927.56,104267.76,225),('1','277','226','1',630.00,736.00,0.00,1015.92,640029.60,747717.12,107687.52,226),('1','277','227','1',630.00,736.00,0.00,420.10,264663.00,309193.60,44530.60,227),('1','277','228','1',630.00,736.00,0.00,431.34,271744.20,315117.13,43372.93,228),('1','277','229','1',630.00,736.00,0.00,817.85,515245.50,601937.60,86692.10,229),('1','277','230','1',630.00,736.00,0.00,693.94,437182.20,504639.84,67457.64,230),('1','277','231','1',630.00,736.00,0.00,816.04,514105.20,597555.44,83450.24,231),('1','277','232','1',630.00,736.00,0.00,737.17,464417.10,538958.12,74541.02,232),('1','277','233','1',630.00,736.00,0.00,691.48,435632.40,505879.28,70246.88,233),('1','277','234','1',630.00,736.00,0.00,915.16,576550.80,673557.76,97006.96,234),('1','277','235','1',630.00,736.00,0.00,890.20,560826.00,655187.20,94361.20,235),('1','277','236','1',630.00,736.00,0.00,794.14,500308.20,581437.04,81128.84,236),('1','277','237','1',630.00,736.00,0.00,784.22,494058.60,573373.42,79314.82,237),('1','277','238','1',630.00,736.00,0.00,712.97,449171.10,524745.92,75574.82,238),('1','277','239','1',630.00,736.00,0.00,1291.91,813903.30,919369.76,105466.46,239),('1','277','240','1',630.00,736.00,0.00,626.56,394732.80,461148.16,66415.36,240),('1','277','241','1',630.00,736.00,0.00,438.52,276267.60,319700.72,43433.12,241),('1','277','242','1',630.00,736.00,0.00,1257.68,792338.40,912537.48,120199.08,242),('1','277','243','1',630.00,736.00,0.00,1706.95,1075378.50,1213188.20,137809.70,243),('1','277','244','1',630.00,736.00,0.00,1234.36,777646.80,895556.96,117910.16,244),('1','277','245','1',630.00,736.00,0.00,362.49,228368.70,266792.64,38423.94,245),('1','277','246','1',630.00,736.00,0.00,725.95,457348.50,531249.20,73900.70,246),('1','277','247','1',630.00,736.00,0.00,878.31,553335.30,636676.16,83340.86,247),('1','277','248','1',630.00,736.00,0.00,684.19,431039.70,503563.84,72524.14,248),('1','277','249','1',630.00,736.00,0.00,1315.63,828846.90,951894.68,123047.78,249),('1','277','250','1',630.00,736.00,0.00,1259.65,793579.50,920697.40,127117.90,250),('1','277','251','1',630.00,736.00,0.00,961.91,606003.30,692410.76,86407.46,251),('1','277','252','1',630.00,736.00,0.00,971.90,612297.00,696445.00,84148.00,252),('1','277','253','1',630.00,736.00,0.00,69.11,43539.30,50864.96,7325.66,253),('1','277','254','1',630.00,700.00,0.00,667.78,420701.40,446821.00,26119.60,254),('1','277','255','1',630.00,700.00,0.00,722.14,454948.20,499198.00,44249.80,255),('1','277','256','1',630.00,700.00,0.00,1158.94,730132.20,802858.00,72725.80,256),('1','277','257','1',630.00,700.00,0.00,809.33,509877.90,549731.00,39853.10,257),('1','277','258','1',624.00,700.00,0.00,130.36,81344.64,91252.00,9907.36,258),('1','277','259','1',624.00,700.00,0.00,1400.52,873924.48,965874.00,91949.52,259),('1','277','260','1',624.00,700.00,0.00,1132.71,706811.04,789537.00,82725.96,260),('1','277','261','1',624.00,700.00,0.00,1023.58,638713.92,702436.00,63722.08,261),('1','277','262','1',624.00,700.00,0.00,748.49,467057.76,517892.06,50834.30,262),('1','277','263','1',624.00,700.00,0.00,900.62,561986.88,626234.00,64247.12,263),('1','277','264','1',624.00,700.00,0.00,113.01,70518.24,79107.00,8588.76,264),('1','277','265','1',624.00,700.00,0.00,702.36,438272.64,489762.00,51489.36,265),('1','277','266','1',624.00,700.00,0.00,675.31,421393.44,468402.34,47008.90,266),('1','277','267','1',624.00,700.00,0.00,314.22,196073.28,219954.00,23880.72,267),('1','277','268','1',624.00,700.00,0.00,424.50,264888.00,294650.00,29762.00,268),('1','277','269','1',624.00,700.00,0.00,815.45,508840.80,568315.00,59474.20,269),('1','277','270','1',624.00,700.00,0.00,760.20,474364.80,532140.00,57775.20,270);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',1,'277','PRODUCT TANK','Tank Containing LPG Product.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','277','1',1,1,'1','LPG TANK ',7000.00,0.00,NULL,'TANK CONTAINING LPG PRODUCT','479','2022-07-17 12:22:36','2022-07-17 12:22:36','479',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','277',1,1517.96,'2023-03-20 19:22:51');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=37567 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'1','277',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3737360.00,5480.00,0.00,0.00,'2022-07-17 13:07:37','',''),(2,'1','277',NULL,1,'Reception corrector for bridging 1',0.00,0.00,0.00,5480.00,0.00,'2022-07-17 13:10:26','',''),(3,'1','277','1',1,'Received from bridging 1',0.00,0.00,5480.00,0.00,0.00,'2022-07-17 13:10:26','',''),(4,'1','277','1',1,'Retail Sale Id 1',498.48,0.00,0.00,0.67,41.54,'2022-07-17 13:26:02','',''),(5,'1','277','1',1,'Retail Sale Id 2',751.44,0.00,0.00,1.01,62.62,'2022-07-17 13:27:28','',''),(6,'1','277','1',1,'Retail Sale Id 3',2998.32,0.00,0.00,4.03,249.86,'2022-07-17 13:32:04','',''),(7,'1','277','1',1,'Retail Sale Id 4',996.96,0.00,0.00,1.34,83.08,'2022-07-17 13:36:02','',''),(8,'1','277','1',1,'Retail Sale Id 5',2998.32,0.00,0.00,4.03,249.86,'2022-07-17 13:39:48','',''),(9,'1','277','1',1,'Retail Sale Id 6',1502.88,0.00,0.00,2.02,125.24,'2022-07-17 13:44:03','',''),(10,'1','277','1',1,'Retail Sale Id 7',2001.36,0.00,0.00,2.69,166.78,'2022-07-17 13:45:07','',''),(11,'1','277','1',1,'Retail Sale Id 8',2998.32,0.00,0.00,4.03,249.86,'2022-07-17 14:00:51','',''),(12,'1','277','1',1,'Retail Sale Id 9',4597.92,0.00,0.00,6.18,383.16,'2022-07-17 14:03:26','',''),(13,'1','277','1',1,'Retail Sale Id 10',4501.20,0.00,0.00,6.05,375.10,'2022-07-17 14:08:44','',''),(14,'1','277','1',1,'Retail Sale Id 11',751.44,0.00,0.00,1.01,62.62,'2022-07-17 14:13:54','',''),(15,'1','277','1',1,'Retail Sale Id 12',4501.20,0.00,0.00,6.05,375.10,'2022-07-17 14:22:18','',''),(16,'1','277','1',1,'Retail Sale Id 14',3801.84,0.00,0.00,5.11,316.82,'2022-07-17 14:31:21','',''),(17,'1','277','1',1,'Retail Sale Id 15',1502.88,0.00,0.00,2.02,125.24,'2022-07-17 14:37:33','',''),(18,'1','277','1',1,'Retail Sale Id 16',3801.84,0.00,0.00,5.11,316.82,'2022-07-17 14:42:44','',''),(19,'1','277','1',1,'Retail Sale Id 17',751.44,0.00,0.00,1.01,62.62,'2022-07-17 14:45:35','',''),(20,'1','277','1',1,'Retail Sale Id 18',3697.68,0.00,0.00,4.97,308.14,'2022-07-17 14:47:11','',''),(21,'1','277','1',1,'Retail Sale Id 19',996.96,0.00,0.00,1.34,83.08,'2022-07-17 15:13:17','',''),(22,'1','277','1',1,'Retail Sale Id 20',4501.20,0.00,0.00,6.05,375.10,'2022-07-17 15:50:23','',''),(23,'1','277','1',1,'Retail Sale Id 21',3801.84,0.00,0.00,5.11,316.82,'2022-07-17 15:55:57','',''),(24,'1','277','1',1,'Retail Sale Id 22',2998.32,0.00,0.00,4.03,249.86,'2022-07-17 15:58:06','',''),(25,'1','277','1',1,'Retail Sale Id 23',2001.36,0.00,0.00,2.69,166.78,'2022-07-17 16:01:56','',''),(26,'1','277','1',1,'Retail Sale Id 24',4999.68,0.00,0.00,6.72,416.64,'2022-07-17 16:03:55','',''),(27,'1','277','1',1,'Retail Sale Id 25',4999.68,0.00,0.00,6.72,416.64,'2022-07-17 16:23:15','',''),(28,'1','277','1',1,'Retail Sale Id 26',4501.20,0.00,0.00,6.05,375.10,'2022-07-17 16:37:55','',''),(29,'1','277','1',1,'Retail Sale Id 27',2298.96,0.00,0.00,3.09,191.58,'2022-07-17 16:45:43','',''),(30,'1','277','1',1,'Retail Sale Id 28',900.24,0.00,0.00,1.21,75.02,'2022-07-17 16:47:27','',''),(31,'1','277','1',1,'Retail Sale Id 29',1502.88,0.00,0.00,2.02,125.24,'2022-07-17 17:44:16','',''),(32,'1','277','1',1,'Retail Sale Id 30',2001.36,0.00,0.00,2.69,166.78,'2022-07-17 17:47:54','',''),(33,'1','277','1',1,'Retail Sale Id 31',3720.00,0.00,0.00,5.00,310.00,'2022-07-17 17:49:33','',''),(34,'1','277','1',1,'Retail Sale Id 32',1502.88,0.00,0.00,2.02,125.24,'2022-07-17 18:05:31','',''),(35,'1','277','1',1,'Retail Sale Id 33',2998.32,0.00,0.00,4.03,249.86,'2022-07-17 18:06:43','',''),(36,'1','277','1',1,'Retail Sale Id 34',4464.00,0.00,0.00,6.00,372.00,'2022-07-17 18:08:54','',''),(37,'1','277','1',1,'Retail Sale Id 35',4002.72,0.00,0.00,5.38,333.56,'2022-07-17 18:28:16','',''),(38,'1','277','1',1,'Retail Sale Id 36',9300.00,0.00,0.00,12.50,775.00,'2022-07-17 18:30:25','',''),(39,'1','277','1',1,'Retail Sale Id 37',4501.20,0.00,0.00,6.05,375.10,'2022-07-17 18:48:07','',''),(40,'1','277','1',1,'Retail Sale Id 38',3496.80,0.00,0.00,4.70,291.40,'2022-07-17 18:49:36','',''),(41,'1','277','1',1,'Retail Sale Id 39',2232.00,0.00,0.00,3.00,186.00,'2022-07-17 18:50:33','',''),(42,'1','277','1',1,'Retail Sale Id 40',9300.00,0.00,0.00,12.50,775.00,'2022-07-17 18:51:31','',''),(43,'1','277','1',1,'Retail Sale Id 41',2298.96,0.00,0.00,3.09,191.58,'2022-07-17 19:10:00','',''),(44,'1','277','1',1,'Retail Sale Id 42',2998.32,0.00,0.00,4.03,249.86,'2022-07-17 19:11:44','',''),(45,'1','277','1',1,'Retail Sale Id 43',147758.40,0.00,0.00,198.60,12313.20,'2022-07-17 20:10:48','',''),(46,'1','277','1',1,'Retail Sale Id 44',4501.20,0.00,0.00,6.05,375.10,'2022-07-18 07:44:07','',''),(47,'1','277','1',1,'Retail Sale Id 45',2001.36,0.00,0.00,2.69,166.78,'2022-07-18 07:52:16','',''),(48,'1','277','1',1,'Retail Sale Id 46',2499.84,0.00,0.00,3.36,208.32,'2022-07-18 07:57:10','',''),(49,'1','277','1',1,'Retail Sale Id 47',2998.32,0.00,0.00,4.03,249.86,'2022-07-18 07:58:14','',''),(50,'1','277','1',1,'Retail Sale Id 48',1502.88,0.00,0.00,2.02,125.24,'2022-07-18 08:29:01','',''),(51,'1','277','1',1,'Retail Sale Id 49',699.36,0.00,0.00,0.94,58.28,'2022-07-18 09:06:37','',''),(52,'1','277','1',1,'Retail Sale Id 50',803.52,0.00,0.00,1.08,66.96,'2022-07-18 09:19:01','',''),(53,'1','277','1',1,'Retail Sale Id 51',2998.32,0.00,0.00,4.03,249.86,'2022-07-18 09:36:12','',''),(54,'1','277','1',1,'Retail Sale Id 52',3697.68,0.00,0.00,4.97,308.14,'2022-07-18 13:58:06','',''),(55,'1','277','1',1,'Retail Sale Id 53',2261.76,0.00,0.00,3.04,188.48,'2022-07-18 14:05:12','',''),(56,'1','277','1',1,'Retail Sale Id 54',19849.92,0.00,0.00,26.68,1654.16,'2022-07-18 14:06:48','',''),(57,'1','277','1',1,'Retail Sale Id 55',2998.32,0.00,0.00,4.03,249.86,'2022-07-18 14:48:12','',''),(58,'1','277','1',1,'Retail Sale Id 56',8198.88,0.00,0.00,11.02,683.24,'2022-07-18 16:26:34','',''),(59,'1','277','1',1,'Retail Sale Id 57',4999.68,0.00,0.00,6.72,416.64,'2022-07-18 16:34:09','',''),(60,'1','277','1',1,'Retail Sale Id 58',4501.20,0.00,0.00,6.05,375.10,'2022-07-18 16:39:36','',''),(61,'1','277','1',1,'Retail Sale Id 59',1502.88,0.00,0.00,2.02,125.24,'2022-07-18 16:40:31','',''),(62,'1','277','1',1,'Retail Sale Id 60',5498.16,0.00,0.00,7.39,458.18,'2022-07-18 16:41:31','',''),(63,'1','277','1',1,'Retail Sale Id 61',3496.80,0.00,0.00,4.70,291.40,'2022-07-18 16:42:23','',''),(64,'1','277','1',1,'Retail Sale Id 62',0.00,0.00,0.00,0.00,0.00,'2022-07-18 16:44:52','',''),(65,'1','277','1',1,'Retail Sale Id 63',2998.32,0.00,0.00,4.03,249.86,'2022-07-18 17:25:06','',''),(66,'1','277','1',1,'Retail Sale Id 64',4501.20,0.00,0.00,6.05,375.10,'2022-07-18 17:27:52','',''),(67,'1','277','1',1,'Retail Sale Id 65',2246.88,0.00,0.00,3.02,187.24,'2022-07-18 17:41:13','',''),(68,'1','277','1',1,'Retail Sale Id 66',2001.36,0.00,0.00,2.69,166.78,'2022-07-18 17:42:59','',''),(69,'1','277','1',1,'Retail Sale Id 67',1502.88,0.00,0.00,2.02,125.24,'2022-07-18 17:44:47','',''),(70,'1','277','1',1,'Retail Sale Id 69',2998.32,0.00,0.00,4.03,249.86,'2022-07-18 17:50:10','',''),(71,'1','277','1',1,'Retail Sale Id 71',2998.32,0.00,0.00,4.03,249.86,'2022-07-18 17:55:00','',''),(72,'1','277','1',1,'Retail Sale Id 72',2246.88,0.00,0.00,3.02,187.24,'2022-07-18 17:57:28','',''),(73,'1','277','1',1,'Retail Sale Id 73',2998.32,0.00,0.00,4.03,249.86,'2022-07-18 18:23:35','',''),(74,'1','277','1',1,'Retail Sale Id 74',2001.36,0.00,0.00,2.69,166.78,'2022-07-18 18:28:55','',''),(75,'1','277','1',1,'Retail Sale Id 75',1502.88,0.00,0.00,2.02,125.24,'2022-07-18 18:42:33','',''),(76,'1','277','1',1,'Retail Sale Id 76',2001.36,0.00,0.00,2.69,166.78,'2022-07-18 18:43:49','',''),(77,'1','277','1',1,'Retail Sale Id 78',2246.88,0.00,0.00,3.02,187.24,'2022-07-18 19:12:22','',''),(78,'1','277','1',1,'Return of Retail Sale Id 76',0.00,2001.36,2.69,0.00,-166.78,'2022-07-18 22:46:11','',''),(79,'1','277','1',1,'Return of Retail Sale Id 71',0.00,2998.32,4.03,0.00,-249.86,'2022-07-18 22:47:12','',''),(80,'1','277','1',1,'Retail Sale Id 79',2990.88,0.00,0.00,4.02,249.24,'2022-07-18 22:54:02','',''),(81,'1','277','1',1,'Retail Sale Id 79',10140.72,0.00,0.00,13.63,845.06,'2022-07-18 22:54:02','',''),(82,'1','277','1',1,'Retail Sale Id 80',1502.88,0.00,0.00,2.02,125.24,'2022-07-19 07:02:21','',''),(83,'1','277','1',1,'Retail Sale Id 81',2797.44,0.00,0.00,3.76,233.12,'2022-07-19 07:03:58','',''),(84,'1','277','1',1,'Retail Sale Id 82',2246.88,0.00,0.00,3.02,187.24,'2022-07-19 08:05:39','',''),(85,'1','277','1',1,'Retail Sale Id 83',2998.32,0.00,0.00,4.03,249.86,'2022-07-19 08:16:53','',''),(86,'1','277','1',1,'Retail Sale Id 84',9300.00,0.00,0.00,12.50,775.00,'2022-07-19 08:35:48','',''),(87,'1','277','1',1,'Retail Sale Id 85',2246.88,0.00,0.00,3.02,187.24,'2022-07-19 08:41:04','',''),(88,'1','277','1',1,'Retail Sale Id 86',699.36,0.00,0.00,0.94,58.28,'2022-07-19 09:15:34','',''),(89,'1','277','1',1,'Retail Sale Id 87',4999.68,0.00,0.00,6.72,416.64,'2022-07-19 09:58:45','',''),(90,'1','277','1',1,'Retail Sale Id 88',2298.96,0.00,0.00,3.09,191.58,'2022-07-19 10:05:10','',''),(91,'1','277','1',1,'Retail Sale Id 89',4501.20,0.00,0.00,6.05,375.10,'2022-07-19 11:13:43','',''),(92,'1','277','1',1,'Retail Sale Id 90',2001.36,0.00,0.00,2.69,166.78,'2022-07-19 11:23:51','',''),(93,'1','277','1',1,'Retail Sale Id 91',2998.32,0.00,0.00,4.03,249.86,'2022-07-19 11:27:40','',''),(94,'1','277','1',1,'Retail Sale Id 92',11539.44,0.00,0.00,15.51,961.62,'2022-07-19 11:43:54','',''),(95,'1','277','1',1,'Retail Sale Id 94',4999.68,0.00,0.00,6.72,416.64,'2022-07-19 12:54:58','',''),(96,'1','277','1',1,'Retail Sale Id 95',4501.20,0.00,0.00,6.05,375.10,'2022-07-19 13:06:37','',''),(97,'1','277','1',1,'Retail Sale Id 96',1502.88,0.00,0.00,2.02,125.24,'2022-07-19 13:09:32','',''),(98,'1','277','1',1,'Retail Sale Id 97',1502.88,0.00,0.00,2.02,125.24,'2022-07-19 13:22:14','',''),(99,'1','277','1',1,'Retail Sale Id 98',1502.88,0.00,0.00,2.02,125.24,'2022-07-19 13:29:05','',''),(100,'1','277','1',1,'Retail Sale Id 99',4501.20,0.00,0.00,6.05,375.10,'2022-07-19 14:36:19','',''),(101,'1','277','1',1,'Retail Sale Id 100',2998.32,0.00,0.00,4.03,249.86,'2022-07-19 14:47:07','',''),(102,'1','277','1',1,'Retail Sale Id 102',3861.36,0.00,0.00,5.19,321.78,'2022-07-19 15:04:24','',''),(103,'1','277','1',1,'Retail Sale Id 102',7440.00,0.00,0.00,10.00,620.00,'2022-07-19 15:04:24','',''),(104,'1','277','1',1,'Retail Sale Id 103',1502.88,0.00,0.00,2.02,125.24,'2022-07-19 15:20:24','',''),(105,'1','277','1',1,'Retail Sale Id 103',1502.88,0.00,0.00,2.02,125.24,'2022-07-19 15:20:24','',''),(106,'1','277','1',1,'Retail Sale Id 104',2001.36,0.00,0.00,2.69,166.78,'2022-07-19 15:24:00','',''),(107,'1','277','1',1,'Retail Sale Id 105',2998.32,0.00,0.00,4.03,249.86,'2022-07-19 15:38:33','',''),(108,'1','277','1',1,'Retail Sale Id 106',1502.88,0.00,0.00,2.02,125.24,'2022-07-19 15:46:01','',''),(109,'1','277','1',1,'Retail Sale Id 107',1502.88,0.00,0.00,2.02,125.24,'2022-07-19 15:47:04','',''),(110,'1','277','1',1,'Retail Sale Id 108',2298.96,0.00,0.00,3.09,191.58,'2022-07-19 16:25:37','',''),(111,'1','277','1',1,'Retail Sale Id 109',9300.00,0.00,0.00,12.50,775.00,'2022-07-19 16:43:48','',''),(112,'1','277','1',1,'Retail Sale Id 110',2246.88,0.00,0.00,3.02,187.24,'2022-07-19 16:44:57','',''),(113,'1','277','1',1,'Retail Sale Id 111',2998.32,0.00,0.00,4.03,249.86,'2022-07-19 16:45:48','',''),(114,'1','277','1',1,'Retail Sale Id 112',2998.32,0.00,0.00,4.03,249.86,'2022-07-19 17:01:26','',''),(115,'1','277','1',1,'Retail Sale Id 113',1502.88,0.00,0.00,2.02,125.24,'2022-07-19 17:28:39','',''),(116,'1','277','1',1,'Retail Sale Id 114',3801.84,0.00,0.00,5.11,316.82,'2022-07-19 17:44:23','',''),(117,'1','277','1',1,'Retail Sale Id 115',744.00,0.00,0.00,1.00,62.00,'2022-07-19 17:52:42','',''),(118,'1','277','1',1,'Retail Sale Id 116',2246.88,0.00,0.00,3.02,187.24,'2022-07-19 17:56:21','',''),(119,'1','277','1',1,'Retail Sale Id 117',1502.88,0.00,0.00,2.02,125.24,'2022-07-19 17:57:06','',''),(120,'1','277','1',1,'Retail Sale Id 118',1502.88,0.00,0.00,2.02,125.24,'2022-07-19 18:09:57','',''),(121,'1','277','1',1,'Retail Sale Id 119',2246.88,0.00,0.00,3.02,187.24,'2022-07-19 18:16:21','',''),(122,'1','277','1',1,'Retail Sale Id 120',1502.88,0.00,0.00,2.02,125.24,'2022-07-19 18:17:47','',''),(123,'1','277','1',1,'Retail Sale Id 121',7499.52,0.00,0.00,10.08,624.96,'2022-07-19 18:19:15','',''),(124,'1','277','1',1,'Retail Sale Id 122',2998.32,0.00,0.00,4.03,249.86,'2022-07-19 18:21:30','',''),(125,'1','277','1',1,'Retail Sale Id 123',9300.00,0.00,0.00,12.50,775.00,'2022-07-19 18:23:24','',''),(126,'1','277','1',1,'Retail Sale Id 124',2246.88,0.00,0.00,3.02,187.24,'2022-07-19 18:41:07','',''),(127,'1','277','1',1,'Retail Sale Id 125',2998.32,0.00,0.00,4.03,249.86,'2022-07-19 19:00:35','',''),(128,'1','277','1',1,'Return of Retail Sale Id 122',0.00,2998.32,4.03,0.00,-249.86,'2022-07-19 22:00:51','',''),(129,'1','277','1',1,'Retail Sale Id 126',2730.48,0.00,0.00,3.67,227.54,'2022-07-19 22:02:57','',''),(130,'1','277','1',1,'Retail Sale Id 127',2499.84,0.00,0.00,3.36,208.32,'2022-07-20 08:08:29','',''),(131,'1','277','1',1,'Retail Sale Id 128',2499.84,0.00,0.00,3.36,208.32,'2022-07-20 08:09:18','',''),(132,'1','277','1',1,'Retail Sale Id 129',4501.20,0.00,0.00,6.05,375.10,'2022-07-20 08:33:01','',''),(133,'1','277','1',1,'Retail Sale Id 130',1502.88,0.00,0.00,2.02,125.24,'2022-07-20 08:35:43','',''),(134,'1','277','1',1,'Retail Sale Id 131',2246.88,0.00,0.00,3.02,187.24,'2022-07-20 08:39:08','',''),(135,'1','277','1',1,'Return of Retail Sale Id 131',0.00,2246.88,3.02,0.00,-187.24,'2022-07-20 08:41:15','',''),(136,'1','277','1',1,'Retail Sale Id 132',2202.24,0.00,0.00,2.96,183.52,'2022-07-20 08:42:00','',''),(137,'1','277','1',1,'Retail Sale Id 133',2298.96,0.00,0.00,3.09,191.58,'2022-07-20 09:06:40','',''),(138,'1','277','1',1,'Retail Sale Id 134',2499.84,0.00,0.00,3.36,208.32,'2022-07-20 09:23:08','',''),(139,'1','277','1',1,'Retail Sale Id 135',3697.68,0.00,0.00,4.97,308.14,'2022-07-20 09:28:19','',''),(140,'1','277','1',1,'Retail Sale Id 136',803.52,0.00,0.00,1.08,66.96,'2022-07-20 09:36:32','',''),(141,'1','277','1',1,'Retail Sale Id 137',1502.88,0.00,0.00,2.02,125.24,'2022-07-20 10:25:57','',''),(142,'1','277','1',1,'Retail Sale Id 138',9300.00,0.00,0.00,12.50,775.00,'2022-07-20 10:42:02','',''),(143,'1','277','1',1,'Retail Sale Id 139',2298.96,0.00,0.00,3.09,191.58,'2022-07-20 10:47:02','',''),(144,'1','277','1',1,'Retail Sale Id 140',803.52,0.00,0.00,1.08,66.96,'2022-07-20 10:52:21','',''),(145,'1','277','1',1,'Retail Sale Id 141',1197.84,0.00,0.00,1.61,99.82,'2022-07-20 11:14:40','',''),(146,'1','277','1',1,'Retail Sale Id 142',1502.88,0.00,0.00,2.02,125.24,'2022-07-20 12:03:45','',''),(147,'1','277','1',1,'Retail Sale Id 143',1502.88,0.00,0.00,2.02,125.24,'2022-07-20 13:02:02','',''),(148,'1','277','1',1,'Retail Sale Id 144',1502.88,0.00,0.00,2.02,125.24,'2022-07-20 13:40:55','',''),(149,'1','277','1',1,'Retail Sale Id 145',2246.88,0.00,0.00,3.02,187.24,'2022-07-20 13:48:24','',''),(150,'1','277','1',1,'Retail Sale Id 146',1502.88,0.00,0.00,2.02,125.24,'2022-07-20 13:51:00','',''),(151,'1','277','1',1,'Retail Sale Id 147',1502.88,0.00,0.00,2.02,125.24,'2022-07-20 13:56:08','',''),(152,'1','277','1',1,'Retail Sale Id 148',2001.36,0.00,0.00,2.69,166.78,'2022-07-20 14:53:06','',''),(153,'1','277','1',1,'Retail Sale Id 149',4501.20,0.00,0.00,6.05,375.10,'2022-07-20 14:53:49','',''),(154,'1','277','1',1,'Retail Sale Id 150',803.52,0.00,0.00,1.08,66.96,'2022-07-20 14:54:42','',''),(155,'1','277','1',1,'Retail Sale Id 151',9300.00,0.00,0.00,12.50,775.00,'2022-07-20 15:05:46','',''),(156,'1','277','1',1,'Retail Sale Id 152',4501.20,0.00,0.00,6.05,375.10,'2022-07-20 15:38:24','',''),(157,'1','277','1',1,'Retail Sale Id 153',4501.20,0.00,0.00,6.05,375.10,'2022-07-20 15:53:42','',''),(158,'1','277','1',1,'Retail Sale Id 154',3697.68,0.00,0.00,4.97,308.14,'2022-07-20 16:38:57','',''),(159,'1','277','1',1,'Retail Sale Id 155',803.52,0.00,0.00,1.08,66.96,'2022-07-20 16:42:36','',''),(160,'1','277','1',1,'Retail Sale Id 156',4501.20,0.00,0.00,6.05,375.10,'2022-07-20 16:48:01','',''),(161,'1','277','1',1,'Retail Sale Id 157',3720.00,0.00,0.00,5.00,310.00,'2022-07-20 16:53:06','',''),(162,'1','277','1',1,'Return of Retail Sale Id 157',0.00,3720.00,5.00,0.00,-310.00,'2022-07-20 16:53:51','',''),(163,'1','277','1',1,'Retail Sale Id 159',3496.80,0.00,0.00,4.70,291.40,'2022-07-20 16:54:21','',''),(164,'1','277','1',1,'Retail Sale Id 160',2499.84,0.00,0.00,3.36,208.32,'2022-07-20 16:59:36','',''),(165,'1','277','1',1,'Retail Sale Id 161',2001.36,0.00,0.00,2.69,166.78,'2022-07-20 17:08:15','',''),(166,'1','277','1',1,'Retail Sale Id 162',2246.88,0.00,0.00,3.02,187.24,'2022-07-20 17:12:09','',''),(167,'1','277','1',1,'Retail Sale Id 163',1502.88,0.00,0.00,2.02,125.24,'2022-07-20 17:13:38','',''),(168,'1','277','1',1,'Retail Sale Id 164',803.52,0.00,0.00,1.08,66.96,'2022-07-20 17:30:58','',''),(169,'1','277','1',1,'Retail Sale Id 165',744.00,0.00,0.00,1.00,62.00,'2022-07-20 17:32:28','',''),(170,'1','277','1',1,'Retail Sale Id 166',1502.88,0.00,0.00,2.02,125.24,'2022-07-20 17:33:57','',''),(171,'1','277','1',1,'Retail Sale Id 167',3801.84,0.00,0.00,5.11,316.82,'2022-07-20 17:38:33','',''),(172,'1','277','1',1,'Retail Sale Id 168',2246.88,0.00,0.00,3.02,187.24,'2022-07-20 17:39:17','',''),(173,'1','277','1',1,'Retail Sale Id 169',996.96,0.00,0.00,1.34,83.08,'2022-07-20 17:40:56','',''),(174,'1','277','1',1,'Retail Sale Id 170',2998.32,0.00,0.00,4.03,249.86,'2022-07-20 17:51:35','',''),(175,'1','277','1',1,'Retail Sale Id 171',9300.00,0.00,0.00,12.50,775.00,'2022-07-20 17:53:03','',''),(176,'1','277','1',1,'Retail Sale Id 172',7440.00,0.00,0.00,10.00,620.00,'2022-07-20 17:54:57','',''),(177,'1','277','1',1,'Retail Sale Id 173',2998.32,0.00,0.00,4.03,249.86,'2022-07-20 18:11:40','',''),(178,'1','277','1',1,'Retail Sale Id 174',803.52,0.00,0.00,1.08,66.96,'2022-07-20 18:28:47','',''),(179,'1','277','1',1,'Retail Sale Id 175',7440.00,0.00,0.00,10.00,620.00,'2022-07-20 18:31:45','',''),(180,'1','277','1',1,'Retail Sale Id 175',9300.00,0.00,0.00,12.50,775.00,'2022-07-20 18:31:45','',''),(181,'1','277','1',1,'Retail Sale Id 176',7499.52,0.00,0.00,10.08,624.96,'2022-07-20 18:34:35','',''),(182,'1','277','1',1,'Retail Sale Id 177',9300.00,0.00,0.00,12.50,775.00,'2022-07-20 18:36:16','',''),(183,'1','277','1',1,'Retail Sale Id 178',2246.88,0.00,0.00,3.02,187.24,'2022-07-20 18:37:39','',''),(184,'1','277','1',1,'Retail Sale Id 179',4501.20,0.00,0.00,6.05,375.10,'2022-07-20 18:38:53','',''),(185,'1','277','1',1,'Retail Sale Id 180',2998.32,0.00,0.00,4.03,249.86,'2022-07-20 18:47:09','',''),(186,'1','277','1',1,'Retail Sale Id 181',2998.32,0.00,0.00,4.03,249.86,'2022-07-20 18:52:46','',''),(187,'1','277','1',1,'Retail Sale Id 182',2998.32,0.00,0.00,4.03,249.86,'2022-07-20 18:53:57','',''),(188,'1','277','1',1,'Return of Retail Sale Id 175',0.00,7440.00,10.00,0.00,-620.00,'2022-07-20 20:48:18','',''),(189,'1','277','1',1,'Return of Retail Sale Id 175',0.00,9300.00,12.50,0.00,-775.00,'2022-07-20 20:48:18','',''),(190,'1','277','1',1,'Retail Sale Id 184',3801.84,0.00,0.00,5.11,316.82,'2022-07-20 20:50:53','',''),(191,'1','277','1',1,'Retail Sale Id 184',17431.92,0.00,0.00,23.43,1452.66,'2022-07-20 20:50:53','',''),(192,'1','277','1',1,'Return of Retail Sale Id 184',0.00,3801.84,5.11,0.00,-316.82,'2022-07-20 20:59:50','',''),(193,'1','277','1',1,'Return of Retail Sale Id 184',0.00,17431.92,23.43,0.00,-1452.66,'2022-07-20 20:59:50','',''),(194,'1','277','1',1,'Retail Sale Id 185',16740.00,0.00,0.00,22.50,1395.00,'2022-07-20 21:02:10','',''),(195,'1','277','1',1,'Retail Sale Id 186',3057.84,0.00,0.00,4.11,254.82,'2022-07-20 22:44:28','',''),(196,'1','277','1',1,'Return of Retail Sale Id 179',0.00,4501.20,6.05,0.00,-375.10,'2022-07-20 22:45:54','',''),(197,'1','277','1',1,'Retail Sale Id 187',699.36,0.00,0.00,0.94,58.28,'2022-07-20 22:48:54','',''),(198,'1','277','1',1,'Retail Sale Id 188',2001.36,0.00,0.00,2.69,166.78,'2022-07-21 07:48:38','',''),(199,'1','277','1',1,'Retail Sale Id 189',2246.88,0.00,0.00,3.02,187.24,'2022-07-21 08:02:57','',''),(200,'1','277','1',1,'Retail Sale Id 190',7440.00,0.00,0.00,10.00,620.00,'2022-07-21 08:11:45','',''),(201,'1','277','1',1,'Retail Sale Id 191',2246.88,0.00,0.00,3.02,187.24,'2022-07-21 08:17:32','',''),(202,'1','277','1',1,'Retail Sale Id 192',2246.88,0.00,0.00,3.02,187.24,'2022-07-21 08:27:40','',''),(203,'1','277','1',1,'Retail Sale Id 193',1502.88,0.00,0.00,2.02,125.24,'2022-07-21 08:34:27','',''),(204,'1','277','1',1,'Retail Sale Id 194',3720.00,0.00,0.00,5.00,310.00,'2022-07-21 08:49:51','',''),(205,'1','277','1',1,'Retail Sale Id 195',751.44,0.00,0.00,1.01,62.62,'2022-07-21 08:54:42','',''),(206,'1','277','1',1,'Retail Sale Id 196',4501.20,0.00,0.00,6.05,375.10,'2022-07-21 09:04:29','',''),(207,'1','277','1',1,'Retail Sale Id 197',1502.88,0.00,0.00,2.02,125.24,'2022-07-21 09:36:53','',''),(208,'1','277','1',1,'Retail Sale Id 198',2499.84,0.00,0.00,3.36,208.32,'2022-07-21 09:42:24','',''),(209,'1','277','1',1,'Retail Sale Id 199',996.96,0.00,0.00,1.34,83.08,'2022-07-21 10:12:38','',''),(210,'1','277','1',1,'Retail Sale Id 200',1502.88,0.00,0.00,2.02,125.24,'2022-07-21 10:30:10','',''),(211,'1','277','1',1,'Retail Sale Id 201',4501.20,0.00,0.00,6.05,375.10,'2022-07-21 10:40:23','',''),(212,'1','277','1',1,'Retail Sale Id 202',2001.36,0.00,0.00,2.69,166.78,'2022-07-21 10:45:08','',''),(213,'1','277','1',1,'Retail Sale Id 203',4501.20,0.00,0.00,6.05,375.10,'2022-07-21 10:52:09','',''),(214,'1','277','1',1,'Retail Sale Id 204',1502.88,0.00,0.00,2.02,125.24,'2022-07-21 10:53:19','',''),(215,'1','277','1',1,'Retail Sale Id 205',1502.88,0.00,0.00,2.02,125.24,'2022-07-21 11:23:53','',''),(216,'1','277','1',1,'Retail Sale Id 206',1502.88,0.00,0.00,2.02,125.24,'2022-07-21 11:54:00','',''),(217,'1','277','1',1,'Retail Sale Id 207',3749.76,0.00,0.00,5.04,312.48,'2022-07-21 11:55:01','',''),(218,'1','277','1',1,'Retail Sale Id 208',2246.88,0.00,0.00,3.02,187.24,'2022-07-21 12:06:54','',''),(219,'1','277','1',1,'Retail Sale Id 208',9300.00,0.00,0.00,12.50,775.00,'2022-07-21 12:06:54','',''),(220,'1','277','1',1,'Retail Sale Id 209',2998.32,0.00,0.00,4.03,249.86,'2022-07-21 12:54:00','',''),(221,'1','277','1',1,'Retail Sale Id 210',4501.20,0.00,0.00,6.05,375.10,'2022-07-21 13:00:03','',''),(222,'1','277','1',1,'Retail Sale Id 211',1502.88,0.00,0.00,2.02,125.24,'2022-07-21 13:23:40','',''),(223,'1','277','1',1,'Retail Sale Id 212',1502.88,0.00,0.00,2.02,125.24,'2022-07-21 13:32:37','',''),(224,'1','277','1',1,'Retail Sale Id 213',498.48,0.00,0.00,0.67,41.54,'2022-07-21 13:42:25','',''),(225,'1','277','1',1,'Retail Sale Id 214',1502.88,0.00,0.00,2.02,125.24,'2022-07-21 13:43:07','',''),(226,'1','277','1',1,'Retail Sale Id 215',1502.88,0.00,0.00,2.02,125.24,'2022-07-21 13:49:34','',''),(227,'1','277','1',1,'Retail Sale Id 216',2246.88,0.00,0.00,3.02,187.24,'2022-07-21 13:57:50','',''),(228,'1','277','1',1,'Retail Sale Id 217',4501.20,0.00,0.00,6.05,375.10,'2022-07-21 14:19:51','',''),(229,'1','277','1',1,'Retail Sale Id 218',2246.88,0.00,0.00,3.02,187.24,'2022-07-21 14:25:30','',''),(230,'1','277','1',1,'Retail Sale Id 219',4501.20,0.00,0.00,6.05,375.10,'2022-07-21 14:29:43','',''),(231,'1','277','1',1,'Retail Sale Id 220',7499.52,0.00,0.00,10.08,624.96,'2022-07-21 16:18:39','',''),(232,'1','277','1',1,'Retail Sale Id 221',9300.00,0.00,0.00,12.50,775.00,'2022-07-21 16:31:31','',''),(233,'1','277','1',1,'Retail Sale Id 222',4999.68,0.00,0.00,6.72,416.64,'2022-07-21 16:34:39','',''),(234,'1','277','1',1,'Retail Sale Id 223',3720.00,0.00,0.00,5.00,310.00,'2022-07-21 16:36:02','',''),(235,'1','277','1',1,'Retail Sale Id 224',3720.00,0.00,0.00,5.00,310.00,'2022-07-21 16:55:53','',''),(236,'1','277','1',1,'Retail Sale Id 224',9300.00,0.00,0.00,12.50,775.00,'2022-07-21 16:55:53','',''),(237,'1','277','1',1,'Retail Sale Id 225',1502.88,0.00,0.00,2.02,125.24,'2022-07-21 17:00:30','',''),(238,'1','277','1',1,'Retail Sale Id 226',9300.00,0.00,0.00,12.50,775.00,'2022-07-21 17:01:27','',''),(239,'1','277','1',1,'Return of Retail Sale Id 226',0.00,9300.00,12.50,0.00,-775.00,'2022-07-21 17:02:21','',''),(240,'1','277','1',1,'Retail Sale Id 227',4999.68,0.00,0.00,6.72,416.64,'2022-07-21 17:02:57','',''),(241,'1','277','1',1,'Retail Sale Id 228',9300.00,0.00,0.00,12.50,775.00,'2022-07-21 17:06:43','',''),(242,'1','277','1',1,'Retail Sale Id 229',996.96,0.00,0.00,1.34,83.08,'2022-07-21 17:23:10','',''),(243,'1','277','1',1,'Retail Sale Id 230',498.48,0.00,0.00,0.67,41.54,'2022-07-21 17:26:59','',''),(244,'1','277','1',1,'Retail Sale Id 231',4501.20,0.00,0.00,6.05,375.10,'2022-07-21 17:30:54','',''),(245,'1','277','1',1,'Retail Sale Id 232',4501.20,0.00,0.00,6.05,375.10,'2022-07-21 17:35:25','',''),(246,'1','277','1',1,'Retail Sale Id 233',2246.88,0.00,0.00,3.02,187.24,'2022-07-21 17:37:28','',''),(247,'1','277','1',1,'Retail Sale Id 234',2246.88,0.00,0.00,3.02,187.24,'2022-07-21 17:38:54','',''),(248,'1','277','1',1,'Retail Sale Id 235',3720.00,0.00,0.00,5.00,310.00,'2022-07-21 17:40:47','',''),(249,'1','277','1',1,'Retail Sale Id 236',2998.32,0.00,0.00,4.03,249.86,'2022-07-21 17:51:05','',''),(250,'1','277','1',1,'Retail Sale Id 238',4002.72,0.00,0.00,5.38,333.56,'2022-07-21 17:52:49','',''),(251,'1','277','1',1,'Retail Sale Id 239',2246.88,0.00,0.00,3.02,187.24,'2022-07-21 17:53:59','',''),(252,'1','277','1',1,'Retail Sale Id 240',3697.68,0.00,0.00,4.97,308.14,'2022-07-21 18:01:00','',''),(253,'1','277','1',1,'Retail Sale Id 241',996.96,0.00,0.00,1.34,83.08,'2022-07-21 18:14:28','',''),(254,'1','277','1',1,'Retail Sale Id 242',3801.84,0.00,0.00,5.11,316.82,'2022-07-21 18:32:51','',''),(255,'1','277','1',1,'Retail Sale Id 243',2246.88,0.00,0.00,3.02,187.24,'2022-07-21 18:35:22','',''),(256,'1','277','1',1,'Retail Sale Id 244',3801.84,0.00,0.00,5.11,316.82,'2022-07-22 08:38:02','',''),(257,'1','277','1',1,'Retail Sale Id 245',2998.32,0.00,0.00,4.03,249.86,'2022-07-22 08:39:46','',''),(258,'1','277','1',1,'Retail Sale Id 246',9300.00,0.00,0.00,12.50,775.00,'2022-07-22 08:53:57','',''),(259,'1','277','1',1,'Retail Sale Id 247',2998.32,0.00,0.00,4.03,249.86,'2022-07-22 09:05:55','',''),(260,'1','277','1',1,'Retail Sale Id 248',996.96,0.00,0.00,1.34,83.08,'2022-07-22 09:10:40','',''),(261,'1','277','1',1,'Retail Sale Id 249',297.60,0.00,0.00,0.40,24.80,'2022-07-22 09:14:41','',''),(262,'1','277','1',1,'Retail Sale Id 250',2998.32,0.00,0.00,4.03,249.86,'2022-07-22 09:46:54','',''),(263,'1','277','1',1,'Retail Sale Id 251',9300.00,0.00,0.00,12.50,775.00,'2022-07-22 09:52:14','',''),(264,'1','277','1',1,'Retail Sale Id 252',4501.20,0.00,0.00,6.05,375.10,'2022-07-22 10:00:43','',''),(265,'1','277','1',1,'Retail Sale Id 253',996.96,0.00,0.00,1.34,83.08,'2022-07-22 10:09:08','',''),(266,'1','277','1',1,'Retail Sale Id 254',9300.00,0.00,0.00,12.50,775.00,'2022-07-22 10:26:02','',''),(267,'1','277','1',1,'Retail Sale Id 255',4501.20,0.00,0.00,6.05,375.10,'2022-07-22 10:40:49','',''),(268,'1','277','1',1,'Retail Sale Id 257',3801.84,0.00,0.00,5.11,316.82,'2022-07-22 11:04:54','',''),(269,'1','277','1',1,'Retail Sale Id 258',1502.88,0.00,0.00,2.02,125.24,'2022-07-22 11:19:02','',''),(270,'1','277','1',1,'Retail Sale Id 259',2499.84,0.00,0.00,3.36,208.32,'2022-07-22 11:34:13','',''),(271,'1','277','1',1,'Retail Sale Id 260',996.96,0.00,0.00,1.34,83.08,'2022-07-22 11:37:57','',''),(272,'1','277','1',1,'Retail Sale Id 262',2998.32,0.00,0.00,4.03,249.86,'2022-07-22 12:04:57','',''),(273,'1','277','1',1,'Retail Sale Id 263',803.52,0.00,0.00,1.08,66.96,'2022-07-22 12:06:32','',''),(274,'1','277','1',1,'Retail Sale Id 264',996.96,0.00,0.00,1.34,83.08,'2022-07-22 12:12:16','',''),(275,'1','277','1',1,'Retail Sale Id 265',2246.88,0.00,0.00,3.02,187.24,'2022-07-22 12:25:36','',''),(276,'1','277','1',1,'Retail Sale Id 266',1502.88,0.00,0.00,2.02,125.24,'2022-07-22 12:37:30','',''),(277,'1','277','1',1,'Retail Sale Id 267',996.96,0.00,0.00,1.34,83.08,'2022-07-22 12:40:36','',''),(278,'1','277','1',1,'Retail Sale Id 268',2246.88,0.00,0.00,3.02,187.24,'2022-07-22 12:48:33','',''),(279,'1','277','1',1,'Retail Sale Id 269',996.96,0.00,0.00,1.34,83.08,'2022-07-22 13:19:44','',''),(280,'1','277','1',1,'Retail Sale Id 269',1502.88,0.00,0.00,2.02,125.24,'2022-07-22 13:19:44','',''),(281,'1','277','1',1,'Retail Sale Id 270',2998.32,0.00,0.00,4.03,249.86,'2022-07-22 13:28:11','',''),(282,'1','277','1',1,'Retail Sale Id 271',2998.32,0.00,0.00,4.03,249.86,'2022-07-22 13:54:30','',''),(283,'1','277','1',1,'Retail Sale Id 272',4501.20,0.00,0.00,6.05,375.10,'2022-07-22 14:24:21','',''),(284,'1','277','1',1,'Retail Sale Id 273',2499.84,0.00,0.00,3.36,208.32,'2022-07-22 15:42:22','',''),(285,'1','277','1',1,'Retail Sale Id 274',2001.36,0.00,0.00,2.69,166.78,'2022-07-22 15:56:50','',''),(286,'1','277','1',1,'Retail Sale Id 275',5996.64,0.00,0.00,8.06,499.72,'2022-07-22 15:57:46','',''),(287,'1','277','1',1,'Retail Sale Id 277',803.52,0.00,0.00,1.08,66.96,'2022-07-22 16:24:07','',''),(288,'1','277','1',1,'Retail Sale Id 278',1502.88,0.00,0.00,2.02,125.24,'2022-07-22 16:24:46','',''),(289,'1','277','1',1,'Retail Sale Id 279',2998.32,0.00,0.00,4.03,249.86,'2022-07-22 16:28:01','',''),(290,'1','277','1',1,'Retail Sale Id 280',3720.00,0.00,0.00,5.00,310.00,'2022-07-22 16:38:47','',''),(291,'1','277','1',1,'Retail Sale Id 281',1502.88,0.00,0.00,2.02,125.24,'2022-07-22 16:58:12','',''),(292,'1','277','1',1,'Retail Sale Id 282',4501.20,0.00,0.00,6.05,375.10,'2022-07-22 17:05:22','',''),(293,'1','277','1',1,'Retail Sale Id 283',2001.36,0.00,0.00,2.69,166.78,'2022-07-22 17:06:26','',''),(294,'1','277','1',1,'Retail Sale Id 284',4501.20,0.00,0.00,6.05,375.10,'2022-07-22 17:34:50','',''),(295,'1','277','1',1,'Retail Sale Id 286',2001.36,0.00,0.00,2.69,166.78,'2022-07-22 17:36:05','',''),(296,'1','277','1',1,'Retail Sale Id 287',4501.20,0.00,0.00,6.05,375.10,'2022-07-22 17:48:15','',''),(297,'1','277','1',1,'Retail Sale Id 288',3801.84,0.00,0.00,5.11,316.82,'2022-07-22 17:49:33','',''),(298,'1','277','1',1,'Retail Sale Id 288',4501.20,0.00,0.00,6.05,375.10,'2022-07-22 17:49:33','',''),(299,'1','277','1',1,'Retail Sale Id 289',1502.88,0.00,0.00,2.02,125.24,'2022-07-22 17:55:08','',''),(300,'1','277','1',1,'Retail Sale Id 290',1502.88,0.00,0.00,2.02,125.24,'2022-07-22 17:55:57','',''),(301,'1','277','1',1,'Retail Sale Id 291',1502.88,0.00,0.00,2.02,125.24,'2022-07-22 17:57:20','',''),(302,'1','277','1',1,'Retail Sale Id 292',6502.56,0.00,0.00,8.74,541.88,'2022-07-22 18:05:06','',''),(303,'1','277','1',1,'Retail Sale Id 293',1502.88,0.00,0.00,2.02,125.24,'2022-07-22 18:07:19','',''),(304,'1','277','1',1,'Retail Sale Id 294',11948.64,0.00,0.00,16.06,995.72,'2022-07-22 18:08:22','',''),(305,'1','277','1',1,'Retail Sale Id 295',2998.32,0.00,0.00,4.03,249.86,'2022-07-22 18:09:15','',''),(306,'1','277','1',1,'Retail Sale Id 296',1502.88,0.00,0.00,2.02,125.24,'2022-07-22 18:27:28','',''),(307,'1','277','1',1,'Retail Sale Id 297',498.48,0.00,0.00,0.67,41.54,'2022-07-22 18:41:33','',''),(308,'1','277','1',1,'Retail Sale Id 298',4501.20,0.00,0.00,6.05,375.10,'2022-07-22 18:52:16','',''),(309,'1','277','1',1,'Return of Retail Sale Id 292',0.00,6502.56,8.74,0.00,-541.88,'2022-07-22 21:15:05','',''),(310,'1','277','1',1,'Return of Retail Sale Id 289',0.00,1502.88,2.02,0.00,-125.24,'2022-07-22 21:15:42','',''),(311,'1','277','1',1,'Retail Sale Id 299',505.92,0.00,0.00,0.68,42.16,'2022-07-22 21:23:31','',''),(312,'1','277','1',1,'Retail Sale Id 299',7499.52,0.00,0.00,10.08,624.96,'2022-07-22 21:23:31','',''),(313,'1','277','1',1,'Retail Sale Id 300',9300.00,0.00,0.00,12.50,775.00,'2022-07-23 06:56:40','',''),(314,'1','277','1',1,'Retail Sale Id 301',4501.20,0.00,0.00,6.05,375.10,'2022-07-23 07:09:33','',''),(315,'1','277','1',1,'Retail Sale Id 302',751.44,0.00,0.00,1.01,62.62,'2022-07-23 08:14:17','',''),(316,'1','277','1',1,'Retail Sale Id 303',4501.20,0.00,0.00,6.05,375.10,'2022-07-23 08:20:35','',''),(317,'1','277','1',1,'Retail Sale Id 304',2998.32,0.00,0.00,4.03,249.86,'2022-07-23 08:23:57','',''),(318,'1','277','1',1,'Retail Sale Id 305',1502.88,0.00,0.00,2.02,125.24,'2022-07-23 08:24:45','',''),(319,'1','277','1',1,'Retail Sale Id 306',2246.88,0.00,0.00,3.02,187.24,'2022-07-23 08:26:19','',''),(320,'1','277','1',1,'Retail Sale Id 307',4501.20,0.00,0.00,6.05,375.10,'2022-07-23 08:28:28','',''),(321,'1','277','1',1,'Retail Sale Id 308',4002.72,0.00,0.00,5.38,333.56,'2022-07-23 09:00:56','',''),(322,'1','277','1',1,'Retail Sale Id 309',2998.32,0.00,0.00,4.03,249.86,'2022-07-23 09:03:32','',''),(323,'1','277','1',1,'Retail Sale Id 310',2998.32,0.00,0.00,4.03,249.86,'2022-07-23 09:05:07','',''),(324,'1','277','1',1,'Retail Sale Id 311',2001.36,0.00,0.00,2.69,166.78,'2022-07-23 09:05:38','',''),(325,'1','277','1',1,'Retail Sale Id 312',996.96,0.00,0.00,1.34,83.08,'2022-07-23 09:24:19','',''),(326,'1','277','1',1,'Retail Sale Id 313',498.48,0.00,0.00,0.67,41.54,'2022-07-23 09:25:42','',''),(327,'1','277','1',1,'Retail Sale Id 314',2403.12,0.00,0.00,3.23,200.26,'2022-07-23 09:39:10','',''),(328,'1','277','1',1,'Retail Sale Id 315',2001.36,0.00,0.00,2.69,166.78,'2022-07-23 09:51:42','',''),(329,'1','277','1',1,'Retail Sale Id 316',6502.56,0.00,0.00,8.74,541.88,'2022-07-23 09:58:14','',''),(330,'1','277','1',1,'Retail Sale Id 317',2998.32,0.00,0.00,4.03,249.86,'2022-07-23 10:16:39','',''),(331,'1','277','1',1,'Retail Sale Id 318',2998.32,0.00,0.00,4.03,249.86,'2022-07-23 10:25:42','',''),(332,'1','277','1',1,'Retail Sale Id 319',751.44,0.00,0.00,1.01,62.62,'2022-07-23 10:26:33','',''),(333,'1','277','1',1,'Retail Sale Id 320',4501.20,0.00,0.00,6.05,375.10,'2022-07-23 10:43:40','',''),(334,'1','277','1',1,'Retail Sale Id 321',4501.20,0.00,0.00,6.05,375.10,'2022-07-23 10:50:55','',''),(335,'1','277','1',1,'Retail Sale Id 322',2246.88,0.00,0.00,3.02,187.24,'2022-07-23 10:54:38','',''),(336,'1','277','1',1,'Retail Sale Id 323',4501.20,0.00,0.00,6.05,375.10,'2022-07-23 10:55:47','',''),(337,'1','277','1',1,'Retail Sale Id 324',2246.88,0.00,0.00,3.02,187.24,'2022-07-23 10:58:14','',''),(338,'1','277','1',1,'Retail Sale Id 325',1502.88,0.00,0.00,2.02,125.24,'2022-07-23 11:12:01','',''),(339,'1','277','1',1,'Retail Sale Id 326',1502.88,0.00,0.00,2.02,125.24,'2022-07-23 11:15:45','',''),(340,'1','277','1',1,'Retail Sale Id 326',2246.88,0.00,0.00,3.02,187.24,'2022-07-23 11:15:45','',''),(341,'1','277','1',1,'Retail Sale Id 327',8928.00,0.00,0.00,12.00,744.00,'2022-07-23 11:18:39','',''),(342,'1','277','1',1,'Retail Sale Id 328',5200.56,0.00,0.00,6.99,433.38,'2022-07-23 11:20:20','',''),(343,'1','277','1',1,'Retail Sale Id 329',9300.00,0.00,0.00,12.50,775.00,'2022-07-23 11:29:54','',''),(344,'1','277','1',1,'Retail Sale Id 330',2998.32,0.00,0.00,4.03,249.86,'2022-07-23 11:50:09','',''),(345,'1','277','1',1,'Retail Sale Id 331',2246.88,0.00,0.00,3.02,187.24,'2022-07-23 12:10:53','',''),(346,'1','277','1',1,'Retail Sale Id 331',4501.20,0.00,0.00,6.05,375.10,'2022-07-23 12:10:53','',''),(347,'1','277','1',1,'Retail Sale Id 332',2998.32,0.00,0.00,4.03,249.86,'2022-07-23 12:27:20','',''),(348,'1','277','1',1,'Retail Sale Id 333',3801.84,0.00,0.00,5.11,316.82,'2022-07-23 13:37:39','',''),(349,'1','277','1',1,'Retail Sale Id 334',2998.32,0.00,0.00,4.03,249.86,'2022-07-23 13:58:32','',''),(350,'1','277','1',1,'Retail Sale Id 335',7499.52,0.00,0.00,10.08,624.96,'2022-07-23 14:29:33','',''),(351,'1','277','1',1,'Retail Sale Id 337',4501.20,0.00,0.00,6.05,375.10,'2022-07-23 14:42:54','',''),(352,'1','277','1',1,'Retail Sale Id 338',996.96,0.00,0.00,1.34,83.08,'2022-07-23 14:51:59','',''),(353,'1','277','1',1,'Retail Sale Id 339',1502.88,0.00,0.00,2.02,125.24,'2022-07-23 15:15:39','',''),(354,'1','277','1',1,'Retail Sale Id 340',2246.88,0.00,0.00,3.02,187.24,'2022-07-23 15:23:47','',''),(355,'1','277','1',1,'Retail Sale Id 341',9300.00,0.00,0.00,12.50,775.00,'2022-07-23 15:38:18','',''),(356,'1','277','1',1,'Retail Sale Id 342',1502.88,0.00,0.00,2.02,125.24,'2022-07-23 15:40:07','',''),(357,'1','277','1',1,'Retail Sale Id 344',2998.32,0.00,0.00,4.03,249.86,'2022-07-23 15:47:16','',''),(358,'1','277','1',1,'Retail Sale Id 345',498.48,0.00,0.00,0.67,41.54,'2022-07-23 15:48:24','',''),(359,'1','277','1',1,'Retail Sale Id 346',996.96,0.00,0.00,1.34,83.08,'2022-07-23 15:50:35','',''),(360,'1','277','1',1,'Retail Sale Id 347',2298.96,0.00,0.00,3.09,191.58,'2022-07-23 15:53:33','',''),(361,'1','277','1',1,'Retail Sale Id 348',9300.00,0.00,0.00,12.50,775.00,'2022-07-23 16:00:37','',''),(362,'1','277','1',1,'Retail Sale Id 349',744.00,0.00,0.00,1.00,62.00,'2022-07-23 16:18:03','',''),(363,'1','277','1',1,'Retail Sale Id 350',1502.88,0.00,0.00,2.02,125.24,'2022-07-23 16:18:57','',''),(364,'1','277','1',1,'Retail Sale Id 351',2998.32,0.00,0.00,4.03,249.86,'2022-07-23 16:20:12','',''),(365,'1','277','1',1,'Retail Sale Id 352',7440.00,0.00,0.00,10.00,620.00,'2022-07-23 16:28:49','',''),(366,'1','277','1',1,'Retail Sale Id 353',9300.00,0.00,0.00,12.50,775.00,'2022-07-23 16:33:27','',''),(367,'1','277','1',1,'Retail Sale Id 354',4501.20,0.00,0.00,6.05,375.10,'2022-07-23 16:37:49','',''),(368,'1','277','1',1,'Retail Sale Id 355',4501.20,0.00,0.00,6.05,375.10,'2022-07-23 16:50:53','',''),(369,'1','277','1',1,'Retail Sale Id 356',1302.00,0.00,0.00,1.75,108.50,'2022-07-23 16:52:32','',''),(370,'1','277','1',1,'Retail Sale Id 357',4002.72,0.00,0.00,5.38,333.56,'2022-07-23 16:58:20','',''),(371,'1','277','1',1,'Retail Sale Id 358',498.48,0.00,0.00,0.67,41.54,'2022-07-23 17:11:38','',''),(372,'1','277','1',1,'Retail Sale Id 359',2998.32,0.00,0.00,4.03,249.86,'2022-07-23 17:14:34','',''),(373,'1','277','1',1,'Retail Sale Id 360',2246.88,0.00,0.00,3.02,187.24,'2022-07-23 17:28:17','',''),(374,'1','277','1',1,'Retail Sale Id 361',1502.88,0.00,0.00,2.02,125.24,'2022-07-23 17:30:19','',''),(375,'1','277','1',1,'Retail Sale Id 362',2499.84,0.00,0.00,3.36,208.32,'2022-07-23 17:45:35','',''),(376,'1','277','1',1,'Retail Sale Id 363',10996.32,0.00,0.00,14.78,916.36,'2022-07-23 18:06:08','',''),(377,'1','277','1',1,'Retail Sale Id 364',4002.72,0.00,0.00,5.38,333.56,'2022-07-23 18:13:05','',''),(378,'1','277','1',1,'Retail Sale Id 365',4501.20,0.00,0.00,6.05,375.10,'2022-07-23 18:18:45','',''),(379,'1','277','1',1,'Retail Sale Id 366',7499.52,0.00,0.00,10.08,624.96,'2022-07-23 18:22:59','',''),(380,'1','277','1',1,'Retail Sale Id 367',4002.72,0.00,0.00,5.38,333.56,'2022-07-23 18:24:23','',''),(381,'1','277','1',1,'Retail Sale Id 368',498.48,0.00,0.00,0.67,41.54,'2022-07-23 18:25:21','',''),(382,'1','277','1',1,'Retail Sale Id 369',2998.32,0.00,0.00,4.03,249.86,'2022-07-23 18:36:26','',''),(383,'1','277','1',1,'Retail Sale Id 370',2998.32,0.00,0.00,4.03,249.86,'2022-07-23 18:38:32','',''),(384,'1','277','1',1,'Retail Sale Id 371',498.48,0.00,0.00,0.67,41.54,'2022-07-23 18:39:57','',''),(385,'1','277','1',1,'Retail Sale Id 372',1502.88,0.00,0.00,2.02,125.24,'2022-07-23 18:44:46','',''),(386,'1','277','1',1,'Retail Sale Id 373',2998.32,0.00,0.00,4.03,249.86,'2022-07-23 18:45:30','',''),(387,'1','277','1',1,'Retail Sale Id 374',2001.36,0.00,0.00,2.69,166.78,'2022-07-23 18:50:55','',''),(388,'1','277','1',1,'Retail Sale Id 375',7499.52,0.00,0.00,10.08,624.96,'2022-07-23 19:11:48','',''),(389,'1','277','1',1,'Retail Sale Id 376',498.48,0.00,0.00,0.67,41.54,'2022-07-23 19:14:54','',''),(390,'1','277','1',1,'Retail Sale Id 377',4002.72,0.00,0.00,5.38,333.56,'2022-07-23 19:18:30','',''),(391,'1','277','1',1,'Retail Sale Id 378',4501.20,0.00,0.00,6.05,375.10,'2022-07-23 19:25:20','',''),(392,'1','277','1',1,'Retail Sale Id 379',9300.00,0.00,0.00,12.50,775.00,'2022-07-23 19:32:25','',''),(393,'1','277','1',1,'Retail Sale Id 380',2998.32,0.00,0.00,4.03,249.86,'2022-07-23 19:33:24','',''),(394,'1','277','1',1,'Return of Retail Sale Id 374',0.00,2001.36,2.69,0.00,-166.78,'2022-07-23 22:40:07','',''),(395,'1','277','1',1,'Return of Retail Sale Id 371',0.00,498.48,0.67,0.00,-41.54,'2022-07-23 22:40:40','',''),(396,'1','277','1',1,'Return of Retail Sale Id 375',0.00,7499.52,10.08,0.00,-624.96,'2022-07-23 22:41:21','',''),(397,'1','277','1',1,'Return of Retail Sale Id 354',0.00,4501.20,6.05,0.00,-375.10,'2022-07-23 22:43:14','',''),(398,'1','277','1',1,'Return of Retail Sale Id 361',0.00,1502.88,2.02,0.00,-125.24,'2022-07-23 22:45:29','',''),(399,'1','277','1',1,'Retail Sale Id 381',5446.08,0.00,0.00,7.32,453.84,'2022-07-23 22:51:05','',''),(400,'1','277','1',1,'Retail Sale Id 381',10505.28,0.00,0.00,14.12,875.44,'2022-07-23 22:51:05','',''),(401,'1','277','1',1,'Retail Sale Id 382',803.52,0.00,0.00,1.08,66.96,'2022-07-24 07:17:01','',''),(402,'1','277','1',1,'Retail Sale Id 384',2202.24,0.00,0.00,2.96,183.52,'2022-07-24 07:25:18','',''),(403,'1','277','1',1,'Retail Sale Id 385',1502.88,0.00,0.00,2.02,125.24,'2022-07-24 07:41:00','',''),(404,'1','277','1',1,'Retail Sale Id 386',2246.88,0.00,0.00,3.02,187.24,'2022-07-24 08:11:19','',''),(405,'1','277','1',1,'Retail Sale Id 387',2001.36,0.00,0.00,2.69,166.78,'2022-07-24 08:12:27','',''),(406,'1','277','1',1,'Retail Sale Id 388',2499.84,0.00,0.00,3.36,208.32,'2022-07-24 08:30:17','',''),(407,'1','277','1',1,'Retail Sale Id 389',5996.64,0.00,0.00,8.06,499.72,'2022-07-24 08:49:19','',''),(408,'1','277','1',1,'Retail Sale Id 390',5996.64,0.00,0.00,8.06,499.72,'2022-07-24 08:53:23','',''),(409,'1','277','1',1,'Retail Sale Id 391',1502.88,0.00,0.00,2.02,125.24,'2022-07-24 09:03:44','',''),(410,'1','277','1',1,'Retail Sale Id 392',996.96,0.00,0.00,1.34,83.08,'2022-07-24 09:15:26','',''),(411,'1','277','1',1,'Retail Sale Id 392',996.96,0.00,0.00,1.34,83.08,'2022-07-24 09:15:26','',''),(412,'1','277','1',1,'Retail Sale Id 393',2246.88,0.00,0.00,3.02,187.24,'2022-07-24 09:27:00','',''),(413,'1','277','1',1,'Retail Sale Id 394',3801.84,0.00,0.00,5.11,316.82,'2022-07-24 09:31:41','',''),(414,'1','277','1',1,'Retail Sale Id 395',4501.20,0.00,0.00,6.05,375.10,'2022-07-24 09:41:38','',''),(415,'1','277','1',1,'Retail Sale Id 396',996.96,0.00,0.00,1.34,83.08,'2022-07-24 09:50:54','',''),(416,'1','277','1',1,'Retail Sale Id 397',4501.20,0.00,0.00,6.05,375.10,'2022-07-24 09:53:41','',''),(417,'1','277','1',1,'Retail Sale Id 398',803.52,0.00,0.00,1.08,66.96,'2022-07-24 09:55:17','',''),(418,'1','277','1',1,'Retail Sale Id 399',996.96,0.00,0.00,1.34,83.08,'2022-07-24 09:57:18','',''),(419,'1','277','1',1,'Retail Sale Id 400',3801.84,0.00,0.00,5.11,316.82,'2022-07-24 10:08:30','',''),(420,'1','277','1',1,'Retail Sale Id 401',1502.88,0.00,0.00,2.02,125.24,'2022-07-24 10:12:55','',''),(421,'1','277','1',1,'Retail Sale Id 402',2246.88,0.00,0.00,3.02,187.24,'2022-07-24 10:20:21','',''),(422,'1','277','1',1,'Retail Sale Id 403',1502.88,0.00,0.00,2.02,125.24,'2022-07-24 10:28:00','',''),(423,'1','277','1',1,'Retail Sale Id 404',4999.68,0.00,0.00,6.72,416.64,'2022-07-24 10:32:27','',''),(424,'1','277','1',1,'Retail Sale Id 405',1502.88,0.00,0.00,2.02,125.24,'2022-07-24 10:45:56','',''),(425,'1','277','1',1,'Retail Sale Id 406',3801.84,0.00,0.00,5.11,316.82,'2022-07-24 10:55:25','',''),(426,'1','277','1',1,'Retail Sale Id 408',2499.84,0.00,0.00,3.36,208.32,'2022-07-24 11:28:17','',''),(427,'1','277','1',1,'Retail Sale Id 409',9300.00,0.00,0.00,12.50,775.00,'2022-07-24 11:29:07','',''),(428,'1','277','1',1,'Retail Sale Id 410',2998.32,0.00,0.00,4.03,249.86,'2022-07-24 11:49:30','',''),(429,'1','277','1',1,'Retail Sale Id 411',7440.00,0.00,0.00,10.00,620.00,'2022-07-24 11:50:15','',''),(430,'1','277','1',1,'Retail Sale Id 412',4501.20,0.00,0.00,6.05,375.10,'2022-07-24 11:52:07','',''),(431,'1','277','1',1,'Retail Sale Id 413',1502.88,0.00,0.00,2.02,125.24,'2022-07-24 12:21:21','',''),(432,'1','277','1',1,'Retail Sale Id 414',3801.84,0.00,0.00,5.11,316.82,'2022-07-24 12:33:34','',''),(433,'1','277','1',1,'Retail Sale Id 415',3801.84,0.00,0.00,5.11,316.82,'2022-07-24 12:34:42','',''),(434,'1','277','1',1,'Retail Sale Id 416',2998.32,0.00,0.00,4.03,249.86,'2022-07-24 12:37:00','',''),(435,'1','277','1',1,'Retail Sale Id 417',2246.88,0.00,0.00,3.02,187.24,'2022-07-24 12:38:19','',''),(436,'1','277','1',1,'Retail Sale Id 418',3801.84,0.00,0.00,5.11,316.82,'2022-07-24 12:45:14','',''),(437,'1','277','1',1,'Retail Sale Id 419',996.96,0.00,0.00,1.34,83.08,'2022-07-24 12:46:49','',''),(438,'1','277','1',1,'Retail Sale Id 420',9300.00,0.00,0.00,12.50,775.00,'2022-07-24 12:53:12','',''),(439,'1','277','1',1,'Retail Sale Id 421',2998.32,0.00,0.00,4.03,249.86,'2022-07-24 12:57:00','',''),(440,'1','277','1',1,'Retail Sale Id 422',1502.88,0.00,0.00,2.02,125.24,'2022-07-24 13:07:50','',''),(441,'1','277','1',1,'Retail Sale Id 423',3496.80,0.00,0.00,4.70,291.40,'2022-07-24 13:26:27','',''),(442,'1','277','1',1,'Retail Sale Id 424',1502.88,0.00,0.00,2.02,125.24,'2022-07-24 13:45:04','',''),(443,'1','277','1',1,'Retail Sale Id 425',2001.36,0.00,0.00,2.69,166.78,'2022-07-24 13:50:22','',''),(444,'1','277','1',1,'Retail Sale Id 426',1502.88,0.00,0.00,2.02,125.24,'2022-07-24 13:58:54','',''),(445,'1','277','1',1,'Retail Sale Id 427',1502.88,0.00,0.00,2.02,125.24,'2022-07-24 14:02:20','',''),(446,'1','277','1',1,'Retail Sale Id 428',4501.20,0.00,0.00,6.05,375.10,'2022-07-24 14:05:10','',''),(447,'1','277','1',1,'Retail Sale Id 429',297.60,0.00,0.00,0.40,24.80,'2022-07-24 14:34:56','',''),(448,'1','277','1',1,'Retail Sale Id 430',3720.00,0.00,0.00,5.00,310.00,'2022-07-24 14:43:52','',''),(449,'1','277','1',1,'Retail Sale Id 431',2001.36,0.00,0.00,2.69,166.78,'2022-07-24 14:54:03','',''),(450,'1','277','1',1,'Retail Sale Id 432',4300.32,0.00,0.00,5.78,358.36,'2022-07-24 14:57:58','',''),(451,'1','277','1',1,'Retail Sale Id 433',1502.88,0.00,0.00,2.02,125.24,'2022-07-24 15:12:05','',''),(452,'1','277','1',1,'Retail Sale Id 434',751.44,0.00,0.00,1.01,62.62,'2022-07-24 15:15:41','',''),(453,'1','277','1',1,'Retail Sale Id 435',2001.36,0.00,0.00,2.69,166.78,'2022-07-24 15:16:25','',''),(454,'1','277','1',1,'Retail Sale Id 436',996.96,0.00,0.00,1.34,83.08,'2022-07-24 15:22:54','',''),(455,'1','277','1',1,'Retail Sale Id 437',9300.00,0.00,0.00,12.50,775.00,'2022-07-24 15:23:56','',''),(456,'1','277','1',1,'Retail Sale Id 438',2998.32,0.00,0.00,4.03,249.86,'2022-07-24 15:27:04','',''),(457,'1','277','1',1,'Retail Sale Id 439',803.52,0.00,0.00,1.08,66.96,'2022-07-24 15:31:24','',''),(458,'1','277','1',1,'Retail Sale Id 440',3720.00,0.00,0.00,5.00,310.00,'2022-07-24 15:42:55','',''),(459,'1','277','1',1,'Retail Sale Id 442',2001.36,0.00,0.00,2.69,166.78,'2022-07-24 15:56:04','',''),(460,'1','277','1',1,'Retail Sale Id 443',9300.00,0.00,0.00,12.50,775.00,'2022-07-24 15:57:50','',''),(461,'1','277','1',1,'Retail Sale Id 444',2001.36,0.00,0.00,2.69,166.78,'2022-07-24 15:59:08','',''),(462,'1','277','1',1,'Retail Sale Id 445',2998.32,0.00,0.00,4.03,249.86,'2022-07-24 16:04:20','',''),(463,'1','277','1',1,'Retail Sale Id 446',498.48,0.00,0.00,0.67,41.54,'2022-07-24 16:05:36','',''),(464,'1','277','1',1,'Retail Sale Id 447',699.36,0.00,0.00,0.94,58.28,'2022-07-24 16:34:55','',''),(465,'1','277','1',1,'Retail Sale Id 448',1197.84,0.00,0.00,1.61,99.82,'2022-07-24 16:40:11','',''),(466,'1','277','1',1,'Retail Sale Id 449',2246.88,0.00,0.00,3.02,187.24,'2022-07-24 16:44:27','',''),(467,'1','277','1',1,'Retail Sale Id 450',2246.88,0.00,0.00,3.02,187.24,'2022-07-24 16:52:31','',''),(468,'1','277','1',1,'Retail Sale Id 451',2499.84,0.00,0.00,3.36,208.32,'2022-07-24 16:59:23','',''),(469,'1','277','1',1,'Retail Sale Id 452',5498.16,0.00,0.00,7.39,458.18,'2022-07-24 17:11:27','',''),(470,'1','277','1',1,'Retail Sale Id 453',2998.32,0.00,0.00,4.03,249.86,'2022-07-24 17:12:43','',''),(471,'1','277','1',1,'Retail Sale Id 454',1502.88,0.00,0.00,2.02,125.24,'2022-07-24 17:13:21','',''),(472,'1','277','1',1,'Retail Sale Id 455',2001.36,0.00,0.00,2.69,166.78,'2022-07-24 17:15:36','',''),(473,'1','277','1',1,'Retail Sale Id 456',2246.88,0.00,0.00,3.02,187.24,'2022-07-24 17:28:34','',''),(474,'1','277','1',1,'Retail Sale Id 457',3801.84,0.00,0.00,5.11,316.82,'2022-07-24 17:29:58','',''),(475,'1','277','1',1,'Retail Sale Id 458',4501.20,0.00,0.00,6.05,375.10,'2022-07-24 17:31:42','',''),(476,'1','277','1',1,'Retail Sale Id 459',3720.00,0.00,0.00,5.00,310.00,'2022-07-24 17:45:52','',''),(477,'1','277','1',1,'Retail Sale Id 459',3727.44,0.00,0.00,5.01,310.62,'2022-07-24 17:45:52','',''),(478,'1','277','1',1,'Retail Sale Id 460',1502.88,0.00,0.00,2.02,125.24,'2022-07-24 17:46:37','',''),(479,'1','277','1',1,'Retail Sale Id 461',1502.88,0.00,0.00,2.02,125.24,'2022-07-24 17:50:31','',''),(480,'1','277','1',1,'Retail Sale Id 462',4501.20,0.00,0.00,6.05,375.10,'2022-07-24 17:54:33','',''),(481,'1','277','1',1,'Retail Sale Id 463',2998.32,0.00,0.00,4.03,249.86,'2022-07-24 17:59:37','',''),(482,'1','277','1',1,'Retail Sale Id 464',1502.88,0.00,0.00,2.02,125.24,'2022-07-24 18:04:48','',''),(483,'1','277','1',1,'Retail Sale Id 465',1502.88,0.00,0.00,2.02,125.24,'2022-07-24 18:29:57','',''),(484,'1','277','1',1,'Retail Sale Id 466',2232.00,0.00,0.00,3.00,186.00,'2022-07-24 18:37:22','',''),(485,'1','277','1',1,'Retail Sale Id 467',2976.00,0.00,0.00,4.00,248.00,'2022-07-24 18:40:32','',''),(486,'1','277','1',1,'Return of Retail Sale Id 466',0.00,2232.00,3.00,0.00,-186.00,'2022-07-24 18:41:47','',''),(487,'1','277','1',1,'Retail Sale Id 468',1502.88,0.00,0.00,2.02,125.24,'2022-07-24 18:49:56','',''),(488,'1','277','1',1,'Retail Sale Id 469',4999.68,0.00,0.00,6.72,416.64,'2022-07-24 18:52:04','',''),(489,'1','277','1',1,'Retail Sale Id 470',9300.00,0.00,0.00,12.50,775.00,'2022-07-24 19:08:58','',''),(490,'1','277','1',1,'Retail Sale Id 472',766.32,0.00,0.00,1.03,63.86,'2022-07-24 22:13:42','',''),(491,'1','277','1',1,'Retail Sale Id 473',4464.00,0.00,0.00,6.00,372.00,'2022-07-25 07:20:46','',''),(492,'1','277','1',1,'Retail Sale Id 474',2298.96,0.00,0.00,3.09,191.58,'2022-07-25 07:53:59','',''),(493,'1','277','1',1,'Retail Sale Id 475',4501.20,0.00,0.00,6.05,375.10,'2022-07-25 08:00:57','',''),(494,'1','277','1',1,'Retail Sale Id 476',1502.88,0.00,0.00,2.02,125.24,'2022-07-25 08:24:20','',''),(495,'1','277','1',1,'Retail Sale Id 477',1502.88,0.00,0.00,2.02,125.24,'2022-07-25 08:27:04','',''),(496,'1','277','1',1,'Retail Sale Id 478',1502.88,0.00,0.00,2.02,125.24,'2022-07-25 08:28:01','',''),(497,'1','277','1',1,'Retail Sale Id 479',4501.20,0.00,0.00,6.05,375.10,'2022-07-25 08:48:29','',''),(498,'1','277','1',1,'Retail Sale Id 480',1502.88,0.00,0.00,2.02,125.24,'2022-07-25 09:02:24','',''),(499,'1','277','1',1,'Retail Sale Id 481',3801.84,0.00,0.00,5.11,316.82,'2022-07-25 09:03:56','',''),(500,'1','277','1',1,'Retail Sale Id 482',1502.88,0.00,0.00,2.02,125.24,'2022-07-25 09:05:03','',''),(501,'1','277','1',1,'Retail Sale Id 483',1502.88,0.00,0.00,2.02,125.24,'2022-07-25 09:06:21','',''),(502,'1','277','1',1,'Retail Sale Id 484',7440.00,0.00,0.00,10.00,620.00,'2022-07-25 10:25:25','',''),(503,'1','277','1',1,'Retail Sale Id 486',751.44,0.00,0.00,1.01,62.62,'2022-07-25 10:35:29','',''),(504,'1','277','1',1,'Retail Sale Id 487',9300.00,0.00,0.00,12.50,775.00,'2022-07-25 10:45:24','',''),(505,'1','277','1',1,'Retail Sale Id 488',2001.36,0.00,0.00,2.69,166.78,'2022-07-25 10:49:14','',''),(506,'1','277','1',1,'Retail Sale Id 489',2998.32,0.00,0.00,4.03,249.86,'2022-07-25 10:57:15','',''),(507,'1','277','1',1,'Retail Sale Id 490',2246.88,0.00,0.00,3.02,187.24,'2022-07-25 10:58:44','',''),(508,'1','277','1',1,'Retail Sale Id 491',9300.00,0.00,0.00,12.50,775.00,'2022-07-25 11:00:09','',''),(509,'1','277','1',1,'Retail Sale Id 492',2499.84,0.00,0.00,3.36,208.32,'2022-07-25 11:48:17','',''),(510,'1','277','1',1,'Retail Sale Id 493',1502.88,0.00,0.00,2.02,125.24,'2022-07-25 12:17:10','',''),(511,'1','277','1',1,'Retail Sale Id 494',2246.88,0.00,0.00,3.02,187.24,'2022-07-25 12:26:24','',''),(512,'1','277','1',1,'Retail Sale Id 495',3697.68,0.00,0.00,4.97,308.14,'2022-07-25 12:34:44','',''),(513,'1','277','1',1,'Retail Sale Id 496',3496.80,0.00,0.00,4.70,291.40,'2022-07-25 12:35:32','',''),(514,'1','277','1',1,'Retail Sale Id 497',2998.32,0.00,0.00,4.03,249.86,'2022-07-25 13:10:43','',''),(515,'1','277','1',1,'Retail Sale Id 498',803.52,0.00,0.00,1.08,66.96,'2022-07-25 13:21:38','',''),(516,'1','277','1',1,'Retail Sale Id 500',498.48,0.00,0.00,0.67,41.54,'2022-07-25 13:33:49','',''),(517,'1','277','1',1,'Retail Sale Id 501',2246.88,0.00,0.00,3.02,187.24,'2022-07-25 13:35:12','',''),(518,'1','277','1',1,'Retail Sale Id 502',9300.00,0.00,0.00,12.50,775.00,'2022-07-25 15:53:06','',''),(519,'1','277','1',1,'Retail Sale Id 503',803.52,0.00,0.00,1.08,66.96,'2022-07-25 16:02:35','',''),(520,'1','277','1',1,'Retail Sale Id 504',2246.88,0.00,0.00,3.02,187.24,'2022-07-25 16:05:57','',''),(521,'1','277','1',1,'Retail Sale Id 506',2246.88,0.00,0.00,3.02,187.24,'2022-07-25 16:16:18','',''),(522,'1','277','1',1,'Retail Sale Id 507',2246.88,0.00,0.00,3.02,187.24,'2022-07-25 16:30:31','',''),(523,'1','277','1',1,'Retail Sale Id 508',3697.68,0.00,0.00,4.97,308.14,'2022-07-25 16:31:56','',''),(524,'1','277','1',1,'Retail Sale Id 509',3801.84,0.00,0.00,5.11,316.82,'2022-07-25 16:59:03','',''),(525,'1','277','1',1,'Retail Sale Id 510',2001.36,0.00,0.00,2.69,166.78,'2022-07-25 17:19:01','',''),(526,'1','277','1',1,'Retail Sale Id 511',996.96,0.00,0.00,1.34,83.08,'2022-07-25 17:19:44','',''),(527,'1','277','1',1,'Retail Sale Id 512',1502.88,0.00,0.00,2.02,125.24,'2022-07-25 17:20:21','',''),(528,'1','277','1',1,'Retail Sale Id 513',34750.00,0.00,0.00,50.00,650.00,'2022-07-25 17:25:10','',''),(529,'1','277','1',1,'Retail Sale Id 514',1696.32,0.00,0.00,2.28,141.36,'2022-07-25 17:33:38','',''),(530,'1','277','1',1,'Retail Sale Id 515',2998.32,0.00,0.00,4.03,249.86,'2022-07-25 17:37:01','',''),(531,'1','277','1',1,'Retail Sale Id 516',1502.88,0.00,0.00,2.02,125.24,'2022-07-25 17:45:53','',''),(532,'1','277','1',1,'Retail Sale Id 517',2246.88,0.00,0.00,3.02,187.24,'2022-07-25 17:58:17','',''),(533,'1','277','1',1,'Retail Sale Id 518',4501.20,0.00,0.00,6.05,375.10,'2022-07-25 17:58:58','',''),(534,'1','277','1',1,'Retail Sale Id 519',1502.88,0.00,0.00,2.02,125.24,'2022-07-25 18:04:36','',''),(535,'1','277','1',1,'Retail Sale Id 520',4002.72,0.00,0.00,5.38,333.56,'2022-07-25 18:18:17','',''),(536,'1','277','1',1,'Retail Sale Id 521',1502.88,0.00,0.00,2.02,125.24,'2022-07-25 18:25:47','',''),(537,'1','277','1',1,'Retail Sale Id 522',4002.72,0.00,0.00,5.38,333.56,'2022-07-25 18:28:17','',''),(538,'1','277','1',1,'Retail Sale Id 523',4501.20,0.00,0.00,6.05,375.10,'2022-07-25 18:37:33','',''),(539,'1','277','1',1,'Retail Sale Id 524',1450.80,0.00,0.00,1.95,120.90,'2022-07-25 18:49:40','',''),(540,'1','277','1',1,'Retail Sale Id 525',2998.32,0.00,0.00,4.03,249.86,'2022-07-25 18:53:39','',''),(541,'1','277','1',1,'Retail Sale Id 526',2001.36,0.00,0.00,2.69,166.78,'2022-07-25 18:54:38','',''),(542,'1','277','1',1,'Retail Sale Id 527',2998.32,0.00,0.00,4.03,249.86,'2022-07-25 18:56:12','',''),(543,'1','277','1',1,'Retail Sale Id 528',2001.36,0.00,0.00,2.69,166.78,'2022-07-25 19:07:59','',''),(544,'1','277','1',1,'Retail Sale Id 529',3801.84,0.00,0.00,5.11,316.82,'2022-07-25 19:10:00','',''),(545,'1','277','1',1,'Retail Sale Id 530',2001.36,0.00,0.00,2.69,166.78,'2022-07-25 19:11:36','',''),(546,'1','277','1',1,'Retail Sale Id 531',9300.00,0.00,0.00,12.50,775.00,'2022-07-25 19:25:10','',''),(547,'1','277','1',1,'Retail Sale Id 532',2998.32,0.00,0.00,4.03,249.86,'2022-07-25 19:27:13','',''),(548,'1','277','1',1,'Retail Sale Id 533',699.36,0.00,0.00,0.94,58.28,'2022-07-25 19:36:59','',''),(549,'1','277','1',1,'Retail Sale Id 534',13399.44,0.00,0.00,18.01,1116.62,'2022-07-25 19:52:58','',''),(550,'1','277','1',1,'Retail Sale Id 535',28800.24,0.00,0.00,38.71,2400.02,'2022-07-25 19:54:36','',''),(551,'1','277','1',1,'Return of Retail Sale Id 527',0.00,2998.32,4.03,0.00,-249.86,'2022-07-25 22:48:08','',''),(552,'1','277','1',1,'Return of Retail Sale Id 529',0.00,3801.84,5.11,0.00,-316.82,'2022-07-25 22:49:10','',''),(553,'1','277','1',1,'Return of Retail Sale Id 517',0.00,2246.88,3.02,0.00,-187.24,'2022-07-25 22:49:58','',''),(554,'1','277','1',1,'Retail Sale Id 536',252.96,0.00,0.00,0.34,21.08,'2022-07-25 23:04:11','',''),(555,'1','277','1',1,'Return of Retail Sale Id 531',0.00,9300.00,12.50,0.00,-775.00,'2022-07-25 23:26:40','',''),(556,'1','277','1',1,'Retail Sale Id 537',8794.08,0.00,0.00,11.82,732.84,'2022-07-25 23:28:41','',''),(557,'1','277','1',1,'Retail Sale Id 538',9307.44,0.00,0.00,12.51,775.62,'2022-07-25 23:30:06','',''),(558,'1','277','1',1,'Retail Sale Id 539',1502.88,0.00,0.00,2.02,125.24,'2022-07-26 06:17:11','',''),(559,'1','277','1',1,'Retail Sale Id 541',1502.88,0.00,0.00,2.02,125.24,'2022-07-26 06:32:26','',''),(560,'1','277','1',1,'Retail Sale Id 541',1502.88,0.00,0.00,2.02,125.24,'2022-07-26 06:32:26','',''),(561,'1','277','1',1,'Retail Sale Id 544',1502.88,0.00,0.00,2.02,125.24,'2022-07-26 07:09:12','',''),(562,'1','277','1',1,'Retail Sale Id 545',4501.20,0.00,0.00,6.05,375.10,'2022-07-26 07:10:09','',''),(563,'1','277','1',1,'Retail Sale Id 546',4501.20,0.00,0.00,6.05,375.10,'2022-07-26 07:30:26','',''),(564,'1','277','1',1,'Retail Sale Id 547',2001.36,0.00,0.00,2.69,166.78,'2022-07-26 07:31:09','',''),(565,'1','277','1',1,'Retail Sale Id 548',2246.88,0.00,0.00,3.02,187.24,'2022-07-26 07:38:56','',''),(566,'1','277','1',1,'Retail Sale Id 549',2998.32,0.00,0.00,4.03,249.86,'2022-07-26 07:56:25','',''),(567,'1','277','1',1,'Retail Sale Id 550',1502.88,0.00,0.00,2.02,125.24,'2022-07-26 08:13:55','',''),(568,'1','277','1',1,'Retail Sale Id 551',996.96,0.00,0.00,1.34,83.08,'2022-07-26 08:22:59','',''),(569,'1','277','1',1,'Retail Sale Id 552',2998.32,0.00,0.00,4.03,249.86,'2022-07-26 08:26:59','',''),(570,'1','277','1',1,'Retail Sale Id 553',2246.88,0.00,0.00,3.02,187.24,'2022-07-26 08:37:01','',''),(571,'1','277','1',1,'Retail Sale Id 554',2246.88,0.00,0.00,3.02,187.24,'2022-07-26 08:39:41','',''),(572,'1','277','1',1,'Return of Retail Sale Id 553',0.00,2246.88,3.02,0.00,-187.24,'2022-07-26 08:41:03','',''),(573,'1','277','1',1,'Retail Sale Id 555',1502.88,0.00,0.00,2.02,125.24,'2022-07-26 08:45:43','',''),(574,'1','277','1',1,'Retail Sale Id 556',2998.32,0.00,0.00,4.03,249.86,'2022-07-26 08:47:30','',''),(575,'1','277','1',1,'Retail Sale Id 557',996.96,0.00,0.00,1.34,83.08,'2022-07-26 08:50:44','',''),(576,'1','277','1',1,'Retail Sale Id 558',4002.72,0.00,0.00,5.38,333.56,'2022-07-26 08:58:30','',''),(577,'1','277','1',1,'Retail Sale Id 559',2001.36,0.00,0.00,2.69,166.78,'2022-07-26 08:59:15','',''),(578,'1','277','1',1,'Retail Sale Id 560',3801.84,0.00,0.00,5.11,316.82,'2022-07-26 09:01:05','',''),(579,'1','277','1',1,'Retail Sale Id 561',996.96,0.00,0.00,1.34,83.08,'2022-07-26 09:13:37','',''),(580,'1','277','1',1,'Retail Sale Id 562',4501.20,0.00,0.00,6.05,375.10,'2022-07-26 09:16:38','',''),(581,'1','277','1',1,'Retail Sale Id 563',5996.64,0.00,0.00,8.06,499.72,'2022-07-26 09:25:11','',''),(582,'1','277','1',1,'Retail Sale Id 564',34750.00,0.00,0.00,50.00,650.00,'2022-07-26 09:31:45','',''),(583,'1','277','1',1,'Retail Sale Id 565',2001.36,0.00,0.00,2.69,166.78,'2022-07-26 09:40:10','',''),(584,'1','277','1',1,'Retail Sale Id 566',1502.88,0.00,0.00,2.02,125.24,'2022-07-26 09:41:29','',''),(585,'1','277','1',1,'Retail Sale Id 567',9300.00,0.00,0.00,12.50,775.00,'2022-07-26 10:27:07','',''),(586,'1','277','1',1,'Retail Sale Id 568',996.96,0.00,0.00,1.34,83.08,'2022-07-26 10:33:12','',''),(587,'1','277','1',1,'Retail Sale Id 569',4501.20,0.00,0.00,6.05,375.10,'2022-07-26 11:36:01','',''),(588,'1','277','1',1,'Retail Sale Id 570',2246.88,0.00,0.00,3.02,187.24,'2022-07-26 11:36:43','',''),(589,'1','277','1',1,'Retail Sale Id 571',751.44,0.00,0.00,1.01,62.62,'2022-07-26 11:39:58','',''),(590,'1','277','1',1,'Retail Sale Id 572',996.96,0.00,0.00,1.34,83.08,'2022-07-26 11:49:52','',''),(591,'1','277','1',1,'Retail Sale Id 573',3801.84,0.00,0.00,5.11,316.82,'2022-07-26 11:57:15','',''),(592,'1','277','1',1,'Retail Sale Id 574',2202.24,0.00,0.00,2.96,183.52,'2022-07-26 12:31:17','',''),(593,'1','277','1',1,'Retail Sale Id 576',2246.88,0.00,0.00,3.02,187.24,'2022-07-26 12:48:27','',''),(594,'1','277','1',1,'Retail Sale Id 577',2001.36,0.00,0.00,2.69,166.78,'2022-07-26 12:56:51','',''),(595,'1','277','1',1,'Retail Sale Id 578',9300.00,0.00,0.00,12.50,775.00,'2022-07-26 13:03:43','',''),(596,'1','277','1',1,'Retail Sale Id 579',996.96,0.00,0.00,1.34,83.08,'2022-07-26 13:29:57','',''),(597,'1','277','1',1,'Retail Sale Id 580',3720.00,0.00,0.00,5.00,310.00,'2022-07-26 13:45:14','',''),(598,'1','277','1',1,'Retail Sale Id 581',736.56,0.00,0.00,0.99,61.38,'2022-07-26 13:47:53','',''),(599,'1','277','1',1,'Retail Sale Id 582',3720.00,0.00,0.00,5.00,310.00,'2022-07-26 14:09:49','',''),(600,'1','277','1',1,'Retail Sale Id 583',1502.88,0.00,0.00,2.02,125.24,'2022-07-26 14:23:47','',''),(601,'1','277','1',1,'Return of Retail Sale Id 581',0.00,736.56,0.99,0.00,-61.38,'2022-07-26 14:26:27','',''),(602,'1','277','1',1,'Retail Sale Id 584',2001.36,0.00,0.00,2.69,166.78,'2022-07-26 14:28:54','',''),(603,'1','277','1',1,'Retail Sale Id 586',2246.88,0.00,0.00,3.02,187.24,'2022-07-26 14:45:31','',''),(604,'1','277','1',1,'Retail Sale Id 587',7998.00,0.00,0.00,10.75,666.50,'2022-07-26 14:47:30','',''),(605,'1','277','1',1,'Retail Sale Id 588',1502.88,0.00,0.00,2.02,125.24,'2022-07-26 14:58:46','',''),(606,'1','277','1',1,'Retail Sale Id 589',4501.20,0.00,0.00,6.05,375.10,'2022-07-26 15:02:32','',''),(607,'1','277','1',1,'Retail Sale Id 590',803.52,0.00,0.00,1.08,66.96,'2022-07-26 15:11:09','',''),(608,'1','277','1',1,'Retail Sale Id 591',2998.32,0.00,0.00,4.03,249.86,'2022-07-26 15:17:45','',''),(609,'1','277','1',1,'Retail Sale Id 593',7440.00,0.00,0.00,10.00,620.00,'2022-07-26 15:21:57','',''),(610,'1','277','1',1,'Retail Sale Id 594',1502.88,0.00,0.00,2.02,125.24,'2022-07-26 15:35:45','',''),(611,'1','277','1',1,'Retail Sale Id 595',2001.36,0.00,0.00,2.69,166.78,'2022-07-26 15:41:03','',''),(612,'1','277','1',1,'Retail Sale Id 596',3801.84,0.00,0.00,5.11,316.82,'2022-07-26 15:57:47','',''),(613,'1','277','1',1,'Retail Sale Id 597',2998.32,0.00,0.00,4.03,249.86,'2022-07-26 16:08:54','',''),(614,'1','277','1',1,'Retail Sale Id 598',9300.00,0.00,0.00,12.50,775.00,'2022-07-26 16:19:14','',''),(615,'1','277','1',1,'Retail Sale Id 599',2246.88,0.00,0.00,3.02,187.24,'2022-07-26 16:24:42','',''),(616,'1','277','1',1,'Retail Sale Id 600',3720.00,0.00,0.00,5.00,310.00,'2022-07-26 16:27:44','',''),(617,'1','277','1',1,'Retail Sale Id 601',2001.36,0.00,0.00,2.69,166.78,'2022-07-26 16:46:55','',''),(618,'1','277','1',1,'Retail Sale Id 602',1502.88,0.00,0.00,2.02,125.24,'2022-07-26 16:51:22','',''),(619,'1','277','1',1,'Retail Sale Id 603',751.44,0.00,0.00,1.01,62.62,'2022-07-26 16:54:22','',''),(620,'1','277','1',1,'Retail Sale Id 604',4999.68,0.00,0.00,6.72,416.64,'2022-07-26 17:02:14','',''),(621,'1','277','1',1,'Retail Sale Id 605',2998.32,0.00,0.00,4.03,249.86,'2022-07-26 17:04:12','',''),(622,'1','277','1',1,'Retail Sale Id 606',2246.88,0.00,0.00,3.02,187.24,'2022-07-26 17:06:21','',''),(623,'1','277','1',1,'Retail Sale Id 607',2246.88,0.00,0.00,3.02,187.24,'2022-07-26 17:08:24','',''),(624,'1','277','1',1,'Retail Sale Id 608',3496.80,0.00,0.00,4.70,291.40,'2022-07-26 17:10:20','',''),(625,'1','277','1',1,'Retail Sale Id 609',2998.32,0.00,0.00,4.03,249.86,'2022-07-26 17:20:32','',''),(626,'1','277','1',1,'Retail Sale Id 610',1502.88,0.00,0.00,2.02,125.24,'2022-07-26 17:21:36','',''),(627,'1','277','1',1,'Retail Sale Id 611',2298.96,0.00,0.00,3.09,191.58,'2022-07-26 17:26:40','',''),(628,'1','277','1',1,'Retail Sale Id 612',2246.88,0.00,0.00,3.02,187.24,'2022-07-26 17:28:11','',''),(629,'1','277','1',1,'Retail Sale Id 613',2246.88,0.00,0.00,3.02,187.24,'2022-07-26 17:29:10','',''),(630,'1','277','1',1,'Retail Sale Id 614',9300.00,0.00,0.00,12.50,775.00,'2022-07-26 17:46:50','',''),(631,'1','277','1',1,'Retail Sale Id 615',498.48,0.00,0.00,0.67,41.54,'2022-07-26 17:50:03','',''),(632,'1','277','1',1,'Retail Sale Id 616',2001.36,0.00,0.00,2.69,166.78,'2022-07-26 17:52:36','',''),(633,'1','277','1',1,'Retail Sale Id 617',2298.96,0.00,0.00,3.09,191.58,'2022-07-26 17:59:56','',''),(634,'1','277','1',1,'Retail Sale Id 618',4501.20,0.00,0.00,6.05,375.10,'2022-07-26 18:03:29','',''),(635,'1','277','1',1,'Retail Sale Id 619',401.76,0.00,0.00,0.54,33.48,'2022-07-26 18:07:14','',''),(636,'1','277','1',1,'Retail Sale Id 620',803.52,0.00,0.00,1.08,66.96,'2022-07-26 18:08:18','',''),(637,'1','277','1',1,'Retail Sale Id 621',2246.88,0.00,0.00,3.02,187.24,'2022-07-26 18:10:12','',''),(638,'1','277','1',1,'Retail Sale Id 622',2998.32,0.00,0.00,4.03,249.86,'2022-07-26 18:19:53','',''),(639,'1','277','1',1,'Retail Sale Id 623',3801.84,0.00,0.00,5.11,316.82,'2022-07-26 18:22:58','',''),(640,'1','277','1',1,'Return of Retail Sale Id 623',0.00,3801.84,5.11,0.00,-316.82,'2022-07-26 19:39:00','',''),(641,'1','277','1',1,'Retail Sale Id 624',751.44,0.00,0.00,1.01,62.62,'2022-07-26 19:44:32','',''),(642,'1','277','1',1,'Retail Sale Id 624',996.96,0.00,0.00,1.34,83.08,'2022-07-26 19:44:32','',''),(643,'1','277','1',1,'Retail Sale Id 624',2700.72,0.00,0.00,3.63,225.06,'2022-07-26 19:44:32','',''),(644,'1','277','1',1,'Retail Sale Id 624',2998.32,0.00,0.00,4.03,249.86,'2022-07-26 19:44:32','',''),(645,'1','277','1',1,'Retail Sale Id 624',4999.68,0.00,0.00,6.72,416.64,'2022-07-26 19:44:32','',''),(646,'1','277','1',1,'Return of Retail Sale Id 582',0.00,3720.00,5.00,0.00,-310.00,'2022-07-26 20:32:23','',''),(647,'1','277','1',1,'Retail Sale Id 625',3720.00,0.00,0.00,5.00,310.00,'2022-07-26 20:33:34','',''),(648,'1','277','1',1,'Retail Sale Id 626',572.88,0.00,0.00,0.77,47.74,'2022-07-26 20:36:57','',''),(649,'1','277','1',1,'Retail Sale Id 627',996.96,0.00,0.00,1.34,83.08,'2022-07-27 06:05:10','',''),(650,'1','277','1',1,'Retail Sale Id 628',2298.96,0.00,0.00,3.09,191.58,'2022-07-27 07:31:50','',''),(651,'1','277','1',1,'Retail Sale Id 629',1502.88,0.00,0.00,2.02,125.24,'2022-07-27 07:39:32','',''),(652,'1','277','1',1,'Retail Sale Id 630',3801.84,0.00,0.00,5.11,316.82,'2022-07-27 07:41:14','',''),(653,'1','277','1',1,'Retail Sale Id 631',2998.32,0.00,0.00,4.03,249.86,'2022-07-27 08:14:10','',''),(654,'1','277','1',1,'Retail Sale Id 632',2298.96,0.00,0.00,3.09,191.58,'2022-07-27 08:23:38','',''),(655,'1','277','1',1,'Retail Sale Id 633',9300.00,0.00,0.00,12.50,775.00,'2022-07-27 08:25:58','',''),(656,'1','277','1',1,'Retail Sale Id 634',3801.84,0.00,0.00,5.11,316.82,'2022-07-27 08:43:07','',''),(657,'1','277','1',1,'Retail Sale Id 635',996.96,0.00,0.00,1.34,83.08,'2022-07-27 08:44:26','',''),(658,'1','277','1',1,'Retail Sale Id 637',1502.88,0.00,0.00,2.02,125.24,'2022-07-27 09:00:20','',''),(659,'1','277','1',1,'Retail Sale Id 638',1502.88,0.00,0.00,2.02,125.24,'2022-07-27 09:01:31','',''),(660,'1','277','1',1,'Retail Sale Id 639',2998.32,0.00,0.00,4.03,249.86,'2022-07-27 09:02:13','',''),(661,'1','277','1',1,'Retail Sale Id 640',996.96,0.00,0.00,1.34,83.08,'2022-07-27 09:04:23','',''),(662,'1','277','1',1,'Retail Sale Id 641',2499.84,0.00,0.00,3.36,208.32,'2022-07-27 09:09:05','',''),(663,'1','277','1',1,'Retail Sale Id 643',2797.44,0.00,0.00,3.76,233.12,'2022-07-27 09:12:44','',''),(664,'1','277','1',1,'Retail Sale Id 645',2298.96,0.00,0.00,3.09,191.58,'2022-07-27 09:40:43','',''),(665,'1','277','1',1,'Retail Sale Id 647',1502.88,0.00,0.00,2.02,125.24,'2022-07-27 09:47:42','',''),(666,'1','277','1',1,'Retail Sale Id 648',2998.32,0.00,0.00,4.03,249.86,'2022-07-27 10:01:20','',''),(667,'1','277','1',1,'Retail Sale Id 649',2001.36,0.00,0.00,2.69,166.78,'2022-07-27 10:48:33','',''),(668,'1','277','1',1,'Retail Sale Id 650',9300.00,0.00,0.00,12.50,775.00,'2022-07-27 11:05:16','',''),(669,'1','277','1',1,'Retail Sale Id 651',2001.36,0.00,0.00,2.69,166.78,'2022-07-27 11:19:11','',''),(670,'1','277','1',1,'Retail Sale Id 652',4002.72,0.00,0.00,5.38,333.56,'2022-07-27 11:44:24','',''),(671,'1','277','1',1,'Retail Sale Id 653',3496.80,0.00,0.00,4.70,291.40,'2022-07-27 12:03:19','',''),(672,'1','277','1',1,'Retail Sale Id 654',1502.88,0.00,0.00,2.02,125.24,'2022-07-27 12:11:34','',''),(673,'1','277','1',1,'Retail Sale Id 655',4501.20,0.00,0.00,6.05,375.10,'2022-07-27 12:16:01','',''),(674,'1','277','1',1,'Retail Sale Id 656',34750.00,0.00,0.00,50.00,650.00,'2022-07-27 12:23:24','',''),(675,'1','277','1',1,'Retail Sale Id 657',2998.32,0.00,0.00,4.03,249.86,'2022-07-27 12:27:24','',''),(676,'1','277','1',1,'Retail Sale Id 658',4501.20,0.00,0.00,6.05,375.10,'2022-07-27 12:29:37','',''),(677,'1','277','1',1,'Retail Sale Id 659',2499.84,0.00,0.00,3.36,208.32,'2022-07-27 12:37:55','',''),(678,'1','277','1',1,'Retail Sale Id 660',3801.84,0.00,0.00,5.11,316.82,'2022-07-27 12:51:32','',''),(679,'1','277','1',1,'Retail Sale Id 661',2246.88,0.00,0.00,3.02,187.24,'2022-07-27 12:52:43','',''),(680,'1','277','1',1,'Retail Sale Id 662',2246.88,0.00,0.00,3.02,187.24,'2022-07-27 13:17:57','',''),(681,'1','277','1',1,'Retail Sale Id 663',4501.20,0.00,0.00,6.05,375.10,'2022-07-27 14:10:45','',''),(682,'1','277','1',1,'Retail Sale Id 664',1502.88,0.00,0.00,2.02,125.24,'2022-07-27 14:11:35','',''),(683,'1','277','1',1,'Retail Sale Id 665',2998.32,0.00,0.00,4.03,249.86,'2022-07-27 14:23:53','',''),(684,'1','277','1',1,'Retail Sale Id 666',2001.36,0.00,0.00,2.69,166.78,'2022-07-27 14:28:39','',''),(685,'1','277','1',1,'Retail Sale Id 667',2246.88,0.00,0.00,3.02,187.24,'2022-07-27 14:50:33','',''),(686,'1','277','1',1,'Retail Sale Id 668',4002.72,0.00,0.00,5.38,333.56,'2022-07-27 14:57:56','',''),(687,'1','277','1',1,'Retail Sale Id 670',4501.20,0.00,0.00,6.05,375.10,'2022-07-27 14:59:14','',''),(688,'1','277','1',1,'Retail Sale Id 671',2998.32,0.00,0.00,4.03,249.86,'2022-07-27 15:12:56','',''),(689,'1','277','1',1,'Retail Sale Id 672',2246.88,0.00,0.00,3.02,187.24,'2022-07-27 15:33:10','',''),(690,'1','277','1',1,'Retail Sale Id 673',4501.20,0.00,0.00,6.05,375.10,'2022-07-27 16:11:06','',''),(691,'1','277','1',1,'Retail Sale Id 674',9300.00,0.00,0.00,12.50,775.00,'2022-07-27 16:33:35','',''),(692,'1','277','1',1,'Retail Sale Id 675',3720.00,0.00,0.00,5.00,310.00,'2022-07-27 16:38:56','',''),(693,'1','277','1',1,'Retail Sale Id 676',2246.88,0.00,0.00,3.02,187.24,'2022-07-27 16:59:17','',''),(694,'1','277','1',1,'Retail Sale Id 677',4501.20,0.00,0.00,6.05,375.10,'2022-07-27 17:10:02','',''),(695,'1','277','1',1,'Retail Sale Id 678',4999.68,0.00,0.00,6.72,416.64,'2022-07-27 17:16:24','',''),(696,'1','277','1',1,'Retail Sale Id 679',2998.32,0.00,0.00,4.03,249.86,'2022-07-27 17:17:16','',''),(697,'1','277','1',1,'Retail Sale Id 680',1502.88,0.00,0.00,2.02,125.24,'2022-07-27 17:37:13','',''),(698,'1','277','1',1,'Retail Sale Id 681',4999.68,0.00,0.00,6.72,416.64,'2022-07-27 17:53:26','',''),(699,'1','277','1',1,'Retail Sale Id 682',1502.88,0.00,0.00,2.02,125.24,'2022-07-27 17:55:37','',''),(700,'1','277','1',1,'Retail Sale Id 683',996.96,0.00,0.00,1.34,83.08,'2022-07-27 18:04:41','',''),(701,'1','277','1',1,'Retail Sale Id 684',2998.32,0.00,0.00,4.03,249.86,'2022-07-27 18:23:51','',''),(702,'1','277','1',1,'Retail Sale Id 685',2998.32,0.00,0.00,4.03,249.86,'2022-07-27 18:25:31','',''),(703,'1','277','1',1,'Retail Sale Id 686',2246.88,0.00,0.00,3.02,187.24,'2022-07-27 18:29:42','',''),(704,'1','277','1',1,'Retail Sale Id 687',1502.88,0.00,0.00,2.02,125.24,'2022-07-27 18:30:21','',''),(705,'1','277','1',1,'Retail Sale Id 688',2246.88,0.00,0.00,3.02,187.24,'2022-07-27 18:40:08','',''),(706,'1','277','1',1,'Retail Sale Id 689',3801.84,0.00,0.00,5.11,316.82,'2022-07-27 18:41:33','',''),(707,'1','277','1',1,'Retail Sale Id 690',1502.88,0.00,0.00,2.02,125.24,'2022-07-27 18:42:22','',''),(708,'1','277','1',1,'Retail Sale Id 691',2001.36,0.00,0.00,2.69,166.78,'2022-07-27 18:43:34','',''),(709,'1','277','1',1,'Retail Sale Id 692',4002.72,0.00,0.00,5.38,333.56,'2022-07-27 18:45:15','',''),(710,'1','277','1',1,'Retail Sale Id 692',4002.72,0.00,0.00,5.38,333.56,'2022-07-27 18:45:15','',''),(711,'1','277','1',1,'Retail Sale Id 693',4501.20,0.00,0.00,6.05,375.10,'2022-07-27 18:59:38','',''),(712,'1','277','1',1,'Retail Sale Id 694',996.96,0.00,0.00,1.34,83.08,'2022-07-27 19:02:15','',''),(713,'1','277','1',1,'Retail Sale Id 695',4999.68,0.00,0.00,6.72,416.64,'2022-07-27 19:16:07','',''),(714,'1','277','1',1,'Retail Sale Id 696',9300.00,0.00,0.00,12.50,775.00,'2022-07-27 19:17:30','',''),(715,'1','277','1',1,'Retail Sale Id 697',3801.84,0.00,0.00,5.11,316.82,'2022-07-27 19:19:18','',''),(716,'1','277','1',1,'Retail Sale Id 698',297.60,0.00,0.00,0.40,24.80,'2022-07-27 19:20:06','',''),(717,'1','277','1',1,'Retail Sale Id 699',2298.96,0.00,0.00,3.09,191.58,'2022-07-27 19:25:36','',''),(718,'1','277','1',1,'Return of Retail Sale Id 697',0.00,3801.84,5.11,0.00,-316.82,'2022-07-27 20:22:58','',''),(719,'1','277','1',1,'Retail Sale Id 700',3801.84,0.00,0.00,5.11,316.82,'2022-07-27 20:36:27','',''),(720,'1','277','1',1,'Retail Sale Id 701',3437.28,0.00,0.00,4.62,286.44,'2022-07-27 20:39:02','',''),(721,'1','277','1',1,'Return of Retail Sale Id 656',0.00,34750.00,50.00,0.00,-650.00,'2022-07-27 22:03:49','',''),(722,'1','277','1',1,'Retail Sale Id 702',31275.00,0.00,0.00,45.00,585.00,'2022-07-27 22:25:33','',''),(723,'1','277','1',1,'Return of Retail Sale Id 702',0.00,31275.00,45.00,0.00,-585.00,'2022-07-27 23:01:40','',''),(724,'1','277','1',1,'Retail Sale Id 703',31351.45,0.00,0.00,45.11,586.43,'2022-07-27 23:03:28','',''),(725,'1','277','1',1,'Return of Retail Sale Id 703',0.00,31351.45,45.11,0.00,-586.43,'2022-07-27 23:04:50','',''),(726,'1','277','1',1,'Retail Sale Id 704',31198.55,0.00,0.00,44.89,583.57,'2022-07-27 23:07:07','',''),(727,'1','277','1',1,'Retail Sale Id 705',2998.32,0.00,0.00,4.03,249.86,'2022-07-28 07:36:30','',''),(728,'1','277','1',1,'Retail Sale Id 706',699.36,0.00,0.00,0.94,58.28,'2022-07-28 08:25:59','',''),(729,'1','277','1',1,'Retail Sale Id 707',9300.00,0.00,0.00,12.50,775.00,'2022-07-28 08:36:06','',''),(730,'1','277','1',1,'Retail Sale Id 708',996.96,0.00,0.00,1.34,83.08,'2022-07-28 09:03:23','',''),(731,'1','277','1',1,'Retail Sale Id 709',996.96,0.00,0.00,1.34,83.08,'2022-07-28 09:05:16','',''),(732,'1','277','1',1,'Retail Sale Id 710',1197.84,0.00,0.00,1.61,99.82,'2022-07-28 09:05:56','',''),(733,'1','277','1',1,'Retail Sale Id 711',2298.96,0.00,0.00,3.09,191.58,'2022-07-28 09:06:56','',''),(734,'1','277','1',1,'Retail Sale Id 712',996.96,0.00,0.00,1.34,83.08,'2022-07-28 09:16:53','',''),(735,'1','277','1',1,'Retail Sale Id 713',9300.00,0.00,0.00,12.50,775.00,'2022-07-28 09:19:43','',''),(736,'1','277','1',1,'Retail Sale Id 714',9300.00,0.00,0.00,12.50,775.00,'2022-07-28 09:20:26','',''),(737,'1','277','1',1,'Retail Sale Id 715',4501.20,0.00,0.00,6.05,375.10,'2022-07-28 09:27:04','',''),(738,'1','277','1',1,'Retail Sale Id 716',9300.00,0.00,0.00,12.50,775.00,'2022-07-28 09:31:01','',''),(739,'1','277','1',1,'Retail Sale Id 717',2998.32,0.00,0.00,4.03,249.86,'2022-07-28 09:36:46','',''),(740,'1','277','1',1,'Retail Sale Id 718',3801.84,0.00,0.00,5.11,316.82,'2022-07-28 09:45:55','',''),(741,'1','277','1',1,'Retail Sale Id 719',1502.88,0.00,0.00,2.02,125.24,'2022-07-28 09:48:35','',''),(742,'1','277','1',1,'Retail Sale Id 720',2246.88,0.00,0.00,3.02,187.24,'2022-07-28 10:02:32','',''),(743,'1','277','1',1,'Retail Sale Id 721',3801.84,0.00,0.00,5.11,316.82,'2022-07-28 10:06:21','',''),(744,'1','277','1',1,'Retail Sale Id 722',1502.88,0.00,0.00,2.02,125.24,'2022-07-28 10:08:28','',''),(745,'1','277','1',1,'Retail Sale Id 723',996.96,0.00,0.00,1.34,83.08,'2022-07-28 10:11:17','',''),(746,'1','277','1',1,'Retail Sale Id 724',4501.20,0.00,0.00,6.05,375.10,'2022-07-28 10:15:56','',''),(747,'1','277','1',1,'Retail Sale Id 725',4501.20,0.00,0.00,6.05,375.10,'2022-07-28 10:17:44','',''),(748,'1','277','1',1,'Retail Sale Id 726',996.96,0.00,0.00,1.34,83.08,'2022-07-28 10:41:03','',''),(749,'1','277','1',1,'Retail Sale Id 727',2001.36,0.00,0.00,2.69,166.78,'2022-07-28 10:46:56','',''),(750,'1','277','1',1,'Retail Sale Id 728',498.48,0.00,0.00,0.67,41.54,'2022-07-28 10:54:50','',''),(751,'1','277','1',1,'Retail Sale Id 729',2246.88,0.00,0.00,3.02,187.24,'2022-07-28 10:55:53','',''),(752,'1','277','1',1,'Retail Sale Id 730',3496.80,0.00,0.00,4.70,291.40,'2022-07-28 10:57:23','',''),(753,'1','277','1',1,'Retail Sale Id 731',2246.88,0.00,0.00,3.02,187.24,'2022-07-28 11:00:44','',''),(754,'1','277','1',1,'Return of Retail Sale Id 731',0.00,2246.88,3.02,0.00,-187.24,'2022-07-28 11:11:11','',''),(755,'1','277','1',1,'Retail Sale Id 732',1644.24,0.00,0.00,2.21,137.02,'2022-07-28 11:11:47','',''),(756,'1','277','1',1,'Retail Sale Id 733',2246.88,0.00,0.00,3.02,187.24,'2022-07-28 11:23:51','',''),(757,'1','277','1',1,'Retail Sale Id 734',996.96,0.00,0.00,1.34,83.08,'2022-07-28 11:24:43','',''),(758,'1','277','1',1,'Retail Sale Id 735',2499.84,0.00,0.00,3.36,208.32,'2022-07-28 11:39:36','',''),(759,'1','277','1',1,'Retail Sale Id 736',803.52,0.00,0.00,1.08,66.96,'2022-07-28 11:41:14','',''),(760,'1','277','1',1,'Retail Sale Id 737',2246.88,0.00,0.00,3.02,187.24,'2022-07-28 11:42:09','',''),(761,'1','277','1',1,'Retail Sale Id 738',751.44,0.00,0.00,1.01,62.62,'2022-07-28 12:21:09','',''),(762,'1','277','1',1,'Retail Sale Id 739',1502.88,0.00,0.00,2.02,125.24,'2022-07-28 12:28:49','',''),(763,'1','277','1',1,'Retail Sale Id 740',5996.64,0.00,0.00,8.06,499.72,'2022-07-28 12:30:44','',''),(764,'1','277','1',1,'Retail Sale Id 741',9300.00,0.00,0.00,12.50,775.00,'2022-07-28 12:46:40','',''),(765,'1','277','1',1,'Retail Sale Id 742',1502.88,0.00,0.00,2.02,125.24,'2022-07-28 12:50:45','',''),(766,'1','277','1',1,'Retail Sale Id 743',2998.32,0.00,0.00,4.03,249.86,'2022-07-28 12:51:49','',''),(767,'1','277','1',1,'Retail Sale Id 744',3801.84,0.00,0.00,5.11,316.82,'2022-07-28 12:54:44','',''),(768,'1','277','1',1,'Retail Sale Id 745',996.96,0.00,0.00,1.34,83.08,'2022-07-28 12:55:44','',''),(769,'1','277','1',1,'Retail Sale Id 746',4501.20,0.00,0.00,6.05,375.10,'2022-07-28 13:03:05','',''),(770,'1','277','1',1,'Retail Sale Id 747',2246.88,0.00,0.00,3.02,187.24,'2022-07-28 13:09:05','',''),(771,'1','277','1',1,'Retail Sale Id 748',4002.72,0.00,0.00,5.38,333.56,'2022-07-28 13:13:04','',''),(772,'1','277','1',1,'Retail Sale Id 749',2246.88,0.00,0.00,3.02,187.24,'2022-07-28 13:22:21','',''),(773,'1','277','1',1,'Retail Sale Id 751',7499.52,0.00,0.00,10.08,624.96,'2022-07-28 13:27:47','',''),(774,'1','277','1',1,'Retail Sale Id 752',4501.20,0.00,0.00,6.05,375.10,'2022-07-28 13:36:25','',''),(775,'1','277','1',1,'Retail Sale Id 753',6502.56,0.00,0.00,8.74,541.88,'2022-07-28 13:37:10','',''),(776,'1','277','1',1,'Retail Sale Id 754',2998.32,0.00,0.00,4.03,249.86,'2022-07-28 13:40:06','',''),(777,'1','277','1',1,'Retail Sale Id 755',996.96,0.00,0.00,1.34,83.08,'2022-07-28 13:51:19','',''),(778,'1','277','1',1,'Retail Sale Id 756',2403.12,0.00,0.00,3.23,200.26,'2022-07-28 14:04:42','',''),(779,'1','277','1',1,'Retail Sale Id 757',9300.00,0.00,0.00,12.50,775.00,'2022-07-28 14:12:28','',''),(780,'1','277','1',1,'Retail Sale Id 758',3801.84,0.00,0.00,5.11,316.82,'2022-07-28 14:23:26','',''),(781,'1','277','1',1,'Retail Sale Id 759',4501.20,0.00,0.00,6.05,375.10,'2022-07-28 14:24:41','',''),(782,'1','277','1',1,'Retail Sale Id 760',9300.00,0.00,0.00,12.50,775.00,'2022-07-28 14:26:38','',''),(783,'1','277','1',1,'Retail Sale Id 761',2246.88,0.00,0.00,3.02,187.24,'2022-07-28 14:37:22','',''),(784,'1','277','1',1,'Retail Sale Id 762',1502.88,0.00,0.00,2.02,125.24,'2022-07-28 14:46:50','',''),(785,'1','277','1',1,'Retail Sale Id 763',4002.72,0.00,0.00,5.38,333.56,'2022-07-28 15:10:03','',''),(786,'1','277','1',1,'Retail Sale Id 764',803.52,0.00,0.00,1.08,66.96,'2022-07-28 15:13:50','',''),(787,'1','277','1',1,'Retail Sale Id 765',2001.36,0.00,0.00,2.69,166.78,'2022-07-28 15:29:51','',''),(788,'1','277','1',1,'Retail Sale Id 766',996.96,0.00,0.00,1.34,83.08,'2022-07-28 15:42:00','',''),(789,'1','277','1',1,'Retail Sale Id 767',2998.32,0.00,0.00,4.03,249.86,'2022-07-28 15:53:32','',''),(790,'1','277','1',1,'Retail Sale Id 768',2246.88,0.00,0.00,3.02,187.24,'2022-07-28 16:01:03','',''),(791,'1','277','1',1,'Retail Sale Id 769',2499.84,0.00,0.00,3.36,208.32,'2022-07-28 16:12:08','',''),(792,'1','277','1',1,'Retail Sale Id 770',4002.72,0.00,0.00,5.38,333.56,'2022-07-28 16:18:35','',''),(793,'1','277','1',1,'Retail Sale Id 771',996.96,0.00,0.00,1.34,83.08,'2022-07-28 16:19:49','',''),(794,'1','277','1',1,'Retail Sale Id 772',2998.32,0.00,0.00,4.03,249.86,'2022-07-28 16:21:09','',''),(795,'1','277','1',1,'Retail Sale Id 773',2246.88,0.00,0.00,3.02,187.24,'2022-07-28 16:24:41','',''),(796,'1','277','1',1,'Retail Sale Id 774',736.56,0.00,0.00,0.99,61.38,'2022-07-28 16:28:14','',''),(797,'1','277','1',1,'Retail Sale Id 775',9300.00,0.00,0.00,12.50,775.00,'2022-07-28 16:36:28','',''),(798,'1','277','1',1,'Retail Sale Id 776',1502.88,0.00,0.00,2.02,125.24,'2022-07-28 16:40:16','',''),(799,'1','277','1',1,'Retail Sale Id 777',2998.32,0.00,0.00,4.03,249.86,'2022-07-28 16:46:06','',''),(800,'1','277','1',1,'Retail Sale Id 778',996.96,0.00,0.00,1.34,83.08,'2022-07-28 16:51:17','',''),(801,'1','277','1',1,'Retail Sale Id 779',10996.32,0.00,0.00,14.78,916.36,'2022-07-28 16:54:34','',''),(802,'1','277','1',1,'Retail Sale Id 780',2246.88,0.00,0.00,3.02,187.24,'2022-07-28 16:55:59','',''),(803,'1','277','1',1,'Retail Sale Id 781',2246.88,0.00,0.00,3.02,187.24,'2022-07-28 17:01:23','',''),(804,'1','277','1',1,'Retail Sale Id 782',2998.32,0.00,0.00,4.03,249.86,'2022-07-28 17:02:04','',''),(805,'1','277','1',1,'Retail Sale Id 783',2998.32,0.00,0.00,4.03,249.86,'2022-07-28 17:06:18','',''),(806,'1','277','1',1,'Retail Sale Id 784',2499.84,0.00,0.00,3.36,208.32,'2022-07-28 17:20:37','',''),(807,'1','277','1',1,'Retail Sale Id 785',1502.88,0.00,0.00,2.02,125.24,'2022-07-28 17:27:52','',''),(808,'1','277','1',1,'Retail Sale Id 786',1502.88,0.00,0.00,2.02,125.24,'2022-07-28 17:53:28','',''),(809,'1','277','1',1,'Retail Sale Id 787',2246.88,0.00,0.00,3.02,187.24,'2022-07-28 17:54:18','',''),(810,'1','277','1',1,'Retail Sale Id 788',4501.20,0.00,0.00,6.05,375.10,'2022-07-28 17:55:45','',''),(811,'1','277','1',1,'Retail Sale Id 789',2246.88,0.00,0.00,3.02,187.24,'2022-07-28 17:56:53','',''),(812,'1','277','1',1,'Retail Sale Id 790',699.36,0.00,0.00,0.94,58.28,'2022-07-28 17:58:04','',''),(813,'1','277','1',1,'Retail Sale Id 791',2998.32,0.00,0.00,4.03,249.86,'2022-07-28 18:07:18','',''),(814,'1','277','1',1,'Retail Sale Id 792',2998.32,0.00,0.00,4.03,249.86,'2022-07-28 18:08:18','',''),(815,'1','277','1',1,'Retail Sale Id 793',4002.72,0.00,0.00,5.38,333.56,'2022-07-28 18:12:01','',''),(816,'1','277','1',1,'Retail Sale Id 794',1502.88,0.00,0.00,2.02,125.24,'2022-07-28 18:15:15','',''),(817,'1','277','1',1,'Retail Sale Id 796',2499.84,0.00,0.00,3.36,208.32,'2022-07-28 18:21:19','',''),(818,'1','277','1',1,'Retail Sale Id 798',2001.36,0.00,0.00,2.69,166.78,'2022-07-28 18:23:54','',''),(819,'1','277','1',1,'Retail Sale Id 799',4501.20,0.00,0.00,6.05,375.10,'2022-07-28 18:30:14','',''),(820,'1','277','1',1,'Retail Sale Id 800',3720.00,0.00,0.00,5.00,310.00,'2022-07-28 18:39:54','',''),(821,'1','277','1',1,'Retail Sale Id 800',3720.00,0.00,0.00,5.00,310.00,'2022-07-28 18:39:54','',''),(822,'1','277','1',1,'Retail Sale Id 801',4902.96,0.00,0.00,6.59,408.58,'2022-07-28 18:45:58','',''),(823,'1','277','1',1,'Retail Sale Id 802',498.48,0.00,0.00,0.67,41.54,'2022-07-28 18:54:12','',''),(824,'1','277','1',1,'Retail Sale Id 803',4501.20,0.00,0.00,6.05,375.10,'2022-07-28 18:55:56','',''),(825,'1','277','1',1,'Retail Sale Id 804',4501.20,0.00,0.00,6.05,375.10,'2022-07-28 18:57:47','',''),(826,'1','277','1',1,'Retail Sale Id 805',4501.20,0.00,0.00,6.05,375.10,'2022-07-28 18:58:42','',''),(827,'1','277','1',1,'Retail Sale Id 806',5996.64,0.00,0.00,8.06,499.72,'2022-07-28 19:00:13','',''),(828,'1','277','1',1,'Retail Sale Id 807',4300.32,0.00,0.00,5.78,358.36,'2022-07-28 19:01:10','',''),(829,'1','277','1',1,'Retail Sale Id 808',751.44,0.00,0.00,1.01,62.62,'2022-07-28 19:02:48','',''),(830,'1','277','1',1,'Retail Sale Id 809',751.44,0.00,0.00,1.01,62.62,'2022-07-28 19:11:42','',''),(831,'1','277','1',1,'Retail Sale Id 810',4999.68,0.00,0.00,6.72,416.64,'2022-07-28 19:30:02','',''),(832,'1','277','1',1,'Retail Sale Id 811',698.88,0.00,0.00,0.96,44.16,'2022-07-29 06:58:10','',''),(833,'1','277','1',1,'Retail Sale Id 813',2999.36,0.00,0.00,4.12,189.52,'2022-07-29 07:40:08','',''),(834,'1','277','1',1,'Retail Sale Id 814',749.84,0.00,0.00,1.03,47.38,'2022-07-29 07:41:00','',''),(835,'1','277','1',1,'Retail Sale Id 815',2497.04,0.00,0.00,3.43,157.78,'2022-07-29 07:41:58','',''),(836,'1','277','1',1,'Retail Sale Id 816',1499.68,0.00,0.00,2.06,94.76,'2022-07-29 07:42:50','',''),(837,'1','277','1',1,'Retail Sale Id 817',1463.28,0.00,0.00,2.01,92.46,'2022-07-29 07:46:47','',''),(838,'1','277','1',1,'Retail Sale Id 818',5001.36,0.00,0.00,6.87,316.02,'2022-07-29 08:07:23','',''),(839,'1','277','1',1,'Retail Sale Id 819',1499.68,0.00,0.00,2.06,94.76,'2022-07-29 08:08:46','',''),(840,'1','277','1',1,'Retail Sale Id 820',1798.16,0.00,0.00,2.47,113.62,'2022-07-29 08:21:52','',''),(841,'1','277','1',1,'Retail Sale Id 821',2548.00,0.00,0.00,3.50,161.00,'2022-07-29 08:30:43','',''),(842,'1','277','1',1,'Retail Sale Id 822',2198.56,0.00,0.00,3.02,138.92,'2022-07-29 08:35:22','',''),(843,'1','277','1',1,'Retail Sale Id 823',4797.52,0.00,0.00,6.59,303.14,'2022-07-29 08:36:32','',''),(844,'1','277','1',1,'Retail Sale Id 824',2497.04,0.00,0.00,3.43,157.78,'2022-07-29 08:38:30','',''),(845,'1','277','1',1,'Retail Sale Id 825',502.32,0.00,0.00,0.69,31.74,'2022-07-29 08:41:09','',''),(846,'1','277','1',1,'Retail Sale Id 826',2497.04,0.00,0.00,3.43,157.78,'2022-07-29 08:45:43','',''),(847,'1','277','1',1,'Retail Sale Id 827',2198.56,0.00,0.00,3.02,138.92,'2022-07-29 09:13:55','',''),(848,'1','277','1',1,'Retail Sale Id 828',3698.24,0.00,0.00,5.08,233.68,'2022-07-29 09:15:27','',''),(849,'1','277','1',1,'Retail Sale Id 829',2999.36,0.00,0.00,4.12,189.52,'2022-07-29 09:19:44','',''),(850,'1','277','1',1,'Retail Sale Id 830',2191.28,0.00,0.00,3.01,138.46,'2022-07-29 10:27:59','',''),(851,'1','277','1',1,'Retail Sale Id 831',4499.04,0.00,0.00,6.18,284.28,'2022-07-29 10:29:58','',''),(852,'1','277','1',1,'Retail Sale Id 832',9100.00,0.00,0.00,12.50,575.00,'2022-07-29 10:30:59','',''),(853,'1','277','1',1,'Retail Sale Id 833',8000.72,0.00,0.00,10.99,505.54,'2022-07-29 10:32:41','',''),(854,'1','277','1',1,'Retail Sale Id 834',2999.36,0.00,0.00,4.12,189.52,'2022-07-29 10:36:18','',''),(855,'1','277','1',1,'Retail Sale Id 835',3647.28,0.00,0.00,5.01,230.46,'2022-07-29 10:54:47','',''),(856,'1','277','1',1,'Retail Sale Id 836',997.36,0.00,0.00,1.37,63.02,'2022-07-29 10:55:35','',''),(857,'1','277','1',1,'Retail Sale Id 837',1499.68,0.00,0.00,2.06,94.76,'2022-07-29 11:01:27','',''),(858,'1','277','1',1,'Retail Sale Id 838',997.36,0.00,0.00,1.37,63.02,'2022-07-29 11:17:04','',''),(859,'1','277','1',1,'Retail Sale Id 839',1499.68,0.00,0.00,2.06,94.76,'2022-07-29 11:17:54','',''),(860,'1','277','1',1,'Retail Sale Id 840',1499.68,0.00,0.00,2.06,94.76,'2022-07-29 11:22:17','',''),(861,'1','277','1',1,'Retail Sale Id 841',3603.60,0.00,0.00,4.95,227.70,'2022-07-29 11:37:06','',''),(862,'1','277','1',1,'Retail Sale Id 842',2198.56,0.00,0.00,3.02,138.92,'2022-07-29 11:39:52','',''),(863,'1','277','1',1,'Retail Sale Id 843',2198.56,0.00,0.00,3.02,138.92,'2022-07-29 12:15:04','',''),(864,'1','277','1',1,'Retail Sale Id 844',1499.68,0.00,0.00,2.06,94.76,'2022-07-29 12:36:05','',''),(865,'1','277','1',1,'Retail Sale Id 845',2198.56,0.00,0.00,3.02,138.92,'2022-07-29 12:37:37','',''),(866,'1','277','1',1,'Retail Sale Id 846',4368.00,0.00,0.00,6.00,276.00,'2022-07-29 13:00:02','',''),(867,'1','277','1',1,'Retail Sale Id 847',9100.00,0.00,0.00,12.50,575.00,'2022-07-29 13:09:57','',''),(868,'1','277','1',1,'Retail Sale Id 848',243250.00,0.00,0.00,350.00,4550.00,'2022-07-29 13:43:47','',''),(869,'1','277','1',1,'Retail Sale Id 849',9100.00,0.00,0.00,12.50,575.00,'2022-07-29 13:45:38','',''),(870,'1','277','1',1,'Retail Sale Id 850',7301.84,0.00,0.00,10.03,461.38,'2022-07-29 14:00:52','',''),(871,'1','277','1',1,'Retail Sale Id 852',502.32,0.00,0.00,0.69,31.74,'2022-07-29 14:52:38','',''),(872,'1','277','1',1,'Retail Sale Id 853',1499.68,0.00,0.00,2.06,94.76,'2022-07-29 14:53:27','',''),(873,'1','277','1',1,'Retail Sale Id 854',2198.56,0.00,0.00,3.02,138.92,'2022-07-29 14:54:33','',''),(874,'1','277','1',1,'Retail Sale Id 855',4397.12,0.00,0.00,6.04,277.84,'2022-07-29 14:55:42','',''),(875,'1','277','1',1,'Retail Sale Id 856',2999.36,0.00,0.00,4.12,189.52,'2022-07-29 15:08:17','',''),(876,'1','277','1',1,'Retail Sale Id 857',2999.36,0.00,0.00,4.12,189.52,'2022-07-29 15:13:03','',''),(877,'1','277','1',1,'Retail Sale Id 858',800.80,0.00,0.00,1.10,50.60,'2022-07-29 15:23:05','',''),(878,'1','277','1',1,'Retail Sale Id 859',3996.72,0.00,0.00,5.49,252.54,'2022-07-29 15:24:44','',''),(879,'1','277','1',1,'Retail Sale Id 860',6566.56,0.00,0.00,9.02,414.92,'2022-07-29 15:27:06','',''),(880,'1','277','1',1,'Retail Sale Id 861',2919.28,0.00,0.00,4.01,184.46,'2022-07-29 15:31:43','',''),(881,'1','277','1',1,'Retail Sale Id 862',1499.68,0.00,0.00,2.06,94.76,'2022-07-29 15:33:34','',''),(882,'1','277','1',1,'Retail Sale Id 863',2198.56,0.00,0.00,3.02,138.92,'2022-07-29 15:46:27','',''),(883,'1','277','1',1,'Retail Sale Id 864',34750.00,0.00,0.00,50.00,650.00,'2022-07-29 16:01:05','',''),(884,'1','277','1',1,'Retail Sale Id 865',2002.00,0.00,0.00,2.75,126.50,'2022-07-29 16:19:48','',''),(885,'1','277','1',1,'Retail Sale Id 866',1303.12,0.00,0.00,1.79,82.34,'2022-07-29 16:20:52','',''),(886,'1','277','1',1,'Retail Sale Id 867',1499.68,0.00,0.00,2.06,94.76,'2022-07-29 16:22:51','',''),(887,'1','277','1',1,'Retail Sale Id 868',800.80,0.00,0.00,1.10,50.60,'2022-07-29 16:23:45','',''),(888,'1','277','1',1,'Retail Sale Id 869',698.88,0.00,0.00,0.96,44.16,'2022-07-29 17:04:44','',''),(889,'1','277','1',1,'Retail Sale Id 870',14560.00,0.00,0.00,20.00,920.00,'2022-07-29 17:07:05','',''),(890,'1','277','1',1,'Retail Sale Id 871',2198.56,0.00,0.00,3.02,138.92,'2022-07-29 17:13:20','',''),(891,'1','277','1',1,'Retail Sale Id 872',2999.36,0.00,0.00,4.12,189.52,'2022-07-29 17:22:57','',''),(892,'1','277','1',1,'Retail Sale Id 873',2198.56,0.00,0.00,3.02,138.92,'2022-07-29 17:23:44','',''),(893,'1','277','1',1,'Retail Sale Id 874',2497.04,0.00,0.00,3.43,157.78,'2022-07-29 17:24:52','',''),(894,'1','277','1',1,'Retail Sale Id 875',2198.56,0.00,0.00,3.02,138.92,'2022-07-29 17:25:53','',''),(895,'1','277','1',1,'Retail Sale Id 876',2198.56,0.00,0.00,3.02,138.92,'2022-07-29 17:32:50','',''),(896,'1','277','1',1,'Retail Sale Id 877',997.36,0.00,0.00,1.37,63.02,'2022-07-29 17:38:30','',''),(897,'1','277','1',1,'Retail Sale Id 878',5998.72,0.00,0.00,8.24,379.04,'2022-07-29 17:42:28','',''),(898,'1','277','1',1,'Retail Sale Id 879',502.32,0.00,0.00,0.69,31.74,'2022-07-29 17:43:23','',''),(899,'1','277','1',1,'Retail Sale Id 880',5998.72,0.00,0.00,8.24,379.04,'2022-07-29 17:56:20','',''),(900,'1','277','1',1,'Retail Sale Id 881',2198.56,0.00,0.00,3.02,138.92,'2022-07-29 17:58:21','',''),(901,'1','277','1',1,'Retail Sale Id 882',4397.12,0.00,0.00,6.04,277.84,'2022-07-29 18:05:47','',''),(902,'1','277','1',1,'Retail Sale Id 883',2999.36,0.00,0.00,4.12,189.52,'2022-07-29 18:07:20','',''),(903,'1','277','1',1,'Retail Sale Id 884',1499.68,0.00,0.00,2.06,94.76,'2022-07-29 18:09:42','',''),(904,'1','277','1',1,'Retail Sale Id 885',2198.56,0.00,0.00,3.02,138.92,'2022-07-29 18:10:37','',''),(905,'1','277','1',1,'Retail Sale Id 886',1499.68,0.00,0.00,2.06,94.76,'2022-07-29 18:13:10','',''),(906,'1','277','1',1,'Retail Sale Id 887',1499.68,0.00,0.00,2.06,94.76,'2022-07-29 18:14:36','',''),(907,'1','277','1',1,'Retail Sale Id 888',2198.56,0.00,0.00,3.02,138.92,'2022-07-29 18:24:02','',''),(908,'1','277','1',1,'Retail Sale Id 889',997.36,0.00,0.00,1.37,63.02,'2022-07-29 18:38:43','',''),(909,'1','277','1',1,'Retail Sale Id 891',800.80,0.00,0.00,1.10,50.60,'2022-07-29 18:39:55','',''),(910,'1','277','1',1,'Retail Sale Id 892',997.36,0.00,0.00,1.37,63.02,'2022-07-29 18:41:10','',''),(911,'1','277','1',1,'Retail Sale Id 893',502.32,0.00,0.00,0.69,31.74,'2022-07-29 18:47:15','',''),(912,'1','277','1',1,'Return of Retail Sale Id 880',0.00,5998.72,8.24,0.00,-379.04,'2022-07-29 19:42:15','',''),(913,'1','277','1',1,'Retail Sale Id 894',4972.24,0.00,0.00,6.83,314.18,'2022-07-29 19:44:06','',''),(914,'1','277','1',1,'Retail Sale Id 895',2052.96,0.00,0.00,2.82,129.72,'2022-07-29 19:46:35','',''),(915,'1','277','1',1,'Retail Sale Id 896',9100.00,0.00,0.00,12.50,575.00,'2022-07-30 06:48:01','',''),(916,'1','277','1',1,'Retail Sale Id 897',997.36,0.00,0.00,1.37,63.02,'2022-07-30 06:49:09','',''),(917,'1','277','1',1,'Retail Sale Id 898',4499.04,0.00,0.00,6.18,284.28,'2022-07-30 14:11:33','',''),(918,'1','277','1',1,'Retail Sale Id 899',3603.60,0.00,0.00,4.95,227.70,'2022-07-30 14:58:47','',''),(919,'1','277','1',1,'Retail Sale Id 900',2999.36,0.00,0.00,4.12,189.52,'2022-07-30 15:00:37','',''),(920,'1','277','1',1,'Retail Sale Id 901',1499.68,0.00,0.00,2.06,94.76,'2022-07-30 15:07:14','',''),(921,'1','277','1',1,'Retail Sale Id 903',1499.68,0.00,0.00,2.06,94.76,'2022-07-30 15:16:53','',''),(922,'1','277','1',1,'Retail Sale Id 904',2249.52,0.00,0.00,3.09,142.14,'2022-07-30 15:19:03','',''),(923,'1','277','1',1,'Retail Sale Id 905',2999.36,0.00,0.00,4.12,189.52,'2022-07-30 15:20:10','',''),(924,'1','277','1',1,'Retail Sale Id 906',3647.28,0.00,0.00,5.01,230.46,'2022-07-30 15:22:09','',''),(925,'1','277','1',1,'Retail Sale Id 907',2002.00,0.00,0.00,2.75,126.50,'2022-07-30 15:23:05','',''),(926,'1','277','1',1,'Retail Sale Id 908',2999.36,0.00,0.00,4.12,189.52,'2022-07-30 15:23:52','',''),(927,'1','277','1',1,'Retail Sale Id 909',2198.56,0.00,0.00,3.02,138.92,'2022-07-30 15:25:11','',''),(928,'1','277','1',1,'Retail Sale Id 910',4397.12,0.00,0.00,6.04,277.84,'2022-07-30 15:27:36','',''),(929,'1','277','1',1,'Retail Sale Id 912',4397.12,0.00,0.00,6.04,277.84,'2022-07-30 15:32:59','',''),(930,'1','277','1',1,'Retail Sale Id 912',9100.00,0.00,0.00,12.50,575.00,'2022-07-30 15:32:59','',''),(931,'1','277','1',1,'Retail Sale Id 913',4397.12,0.00,0.00,6.04,277.84,'2022-07-30 15:34:59','',''),(932,'1','277','1',1,'Retail Sale Id 914',9100.00,0.00,0.00,12.50,575.00,'2022-07-30 15:36:36','',''),(933,'1','277','1',1,'Retail Sale Id 916',1201.20,0.00,0.00,1.65,75.90,'2022-07-30 15:37:44','',''),(934,'1','277','1',1,'Retail Sale Id 918',997.36,0.00,0.00,1.37,63.02,'2022-07-30 15:38:46','',''),(935,'1','277','1',1,'Retail Sale Id 919',1499.68,0.00,0.00,2.06,94.76,'2022-07-30 15:41:03','',''),(936,'1','277','1',1,'Retail Sale Id 920',3297.84,0.00,0.00,4.53,208.38,'2022-07-30 15:42:41','',''),(937,'1','277','1',1,'Retail Sale Id 921',749.84,0.00,0.00,1.03,47.38,'2022-07-30 15:44:31','',''),(938,'1','277','1',1,'Retail Sale Id 922',7301.84,0.00,0.00,10.03,461.38,'2022-07-30 15:47:28','',''),(939,'1','277','1',1,'Retail Sale Id 923',2999.36,0.00,0.00,4.12,189.52,'2022-07-30 15:51:20','',''),(940,'1','277','1',1,'Retail Sale Id 924',5103.28,0.00,0.00,7.01,322.46,'2022-07-30 15:52:44','',''),(941,'1','277','1',1,'Retail Sale Id 925',9100.00,0.00,0.00,12.50,575.00,'2022-07-30 15:59:03','',''),(942,'1','277','1',1,'Retail Sale Id 926',1499.68,0.00,0.00,2.06,94.76,'2022-07-30 16:00:11','',''),(943,'1','277','1',1,'Retail Sale Id 927',5496.40,0.00,0.00,7.55,347.30,'2022-07-30 16:01:03','',''),(944,'1','277','1',1,'Retail Sale Id 928',2999.36,0.00,0.00,4.12,189.52,'2022-07-30 16:04:19','',''),(945,'1','277','1',1,'Retail Sale Id 929',4397.12,0.00,0.00,6.04,277.84,'2022-07-30 16:08:03','',''),(946,'1','277','1',1,'Retail Sale Id 930',4499.04,0.00,0.00,6.18,284.28,'2022-07-30 16:20:49','',''),(947,'1','277','1',1,'Retail Sale Id 932',2002.00,0.00,0.00,2.75,126.50,'2022-07-30 16:33:57','',''),(948,'1','277','1',1,'Retail Sale Id 933',4499.04,0.00,0.00,6.18,284.28,'2022-07-30 16:38:48','',''),(949,'1','277','1',1,'Retail Sale Id 934',3800.16,0.00,0.00,5.22,240.12,'2022-07-30 16:45:11','',''),(950,'1','277','1',1,'Retail Sale Id 935',2999.36,0.00,0.00,4.12,189.52,'2022-07-30 16:55:14','',''),(951,'1','277','1',1,'Retail Sale Id 937',4499.04,0.00,0.00,6.18,284.28,'2022-07-30 16:56:44','',''),(952,'1','277','1',1,'Retail Sale Id 938',3698.24,0.00,0.00,5.08,233.68,'2022-07-30 16:58:36','',''),(953,'1','277','1',1,'Retail Sale Id 939',4302.48,0.00,0.00,5.91,271.86,'2022-07-30 17:02:18','',''),(954,'1','277','1',1,'Retail Sale Id 940',4397.12,0.00,0.00,6.04,277.84,'2022-07-30 17:03:59','',''),(955,'1','277','1',1,'Retail Sale Id 941',5103.28,0.00,0.00,7.01,322.46,'2022-07-30 17:13:31','',''),(956,'1','277','1',1,'Retail Sale Id 942',7301.84,0.00,0.00,10.03,461.38,'2022-07-30 17:15:25','',''),(957,'1','277','1',1,'Retail Sale Id 943',6501.04,0.00,0.00,8.93,410.78,'2022-07-30 17:16:38','',''),(958,'1','277','1',1,'Retail Sale Id 944',1499.68,0.00,0.00,2.06,94.76,'2022-07-30 17:17:25','',''),(959,'1','277','1',1,'Retail Sale Id 945',2198.56,0.00,0.00,3.02,138.92,'2022-07-30 17:18:27','',''),(960,'1','277','1',1,'Retail Sale Id 946',2999.36,0.00,0.00,4.12,189.52,'2022-07-30 17:19:32','',''),(961,'1','277','1',1,'Retail Sale Id 947',4302.48,0.00,0.00,5.91,271.86,'2022-07-30 17:23:34','',''),(962,'1','277','1',1,'Retail Sale Id 948',997.36,0.00,0.00,1.37,63.02,'2022-07-30 17:28:28','',''),(963,'1','277','1',1,'Retail Sale Id 949',9100.00,0.00,0.00,12.50,575.00,'2022-07-30 17:33:01','',''),(964,'1','277','1',1,'Retail Sale Id 951',749.84,0.00,0.00,1.03,47.38,'2022-07-30 17:34:29','',''),(965,'1','277','1',1,'Retail Sale Id 952',10898.16,0.00,0.00,14.97,688.62,'2022-07-30 17:57:00','',''),(966,'1','277','1',1,'Retail Sale Id 954',1499.68,0.00,0.00,2.06,94.76,'2022-07-30 17:58:14','',''),(967,'1','277','1',1,'Retail Sale Id 955',9100.00,0.00,0.00,12.50,575.00,'2022-07-30 18:02:11','',''),(968,'1','277','1',1,'Retail Sale Id 956',3501.68,0.00,0.00,4.81,221.26,'2022-07-30 18:07:35','',''),(969,'1','277','1',1,'Retail Sale Id 957',2002.00,0.00,0.00,2.75,126.50,'2022-07-30 18:09:19','',''),(970,'1','277','1',1,'Retail Sale Id 958',1499.68,0.00,0.00,2.06,94.76,'2022-07-30 18:17:36','',''),(971,'1','277','1',1,'Retail Sale Id 960',3501.68,0.00,0.00,4.81,221.26,'2022-07-30 18:28:18','',''),(972,'1','277','1',1,'Retail Sale Id 961',2198.56,0.00,0.00,3.02,138.92,'2022-07-30 18:29:55','',''),(973,'1','277','1',1,'Retail Sale Id 962',1499.68,0.00,0.00,2.06,94.76,'2022-07-30 18:31:30','',''),(974,'1','277','1',1,'Retail Sale Id 963',4397.12,0.00,0.00,6.04,277.84,'2022-07-30 18:36:49','',''),(975,'1','277','1',1,'Retail Sale Id 964',2198.56,0.00,0.00,3.02,138.92,'2022-07-30 18:43:26','',''),(976,'1','277','1',1,'Retail Sale Id 965',1456.00,0.00,0.00,2.00,92.00,'2022-07-30 18:52:31','',''),(977,'1','277','1',1,'Retail Sale Id 966',3640.00,0.00,0.00,5.00,230.00,'2022-07-30 18:59:39','',''),(978,'1','277','1',1,'Retail Sale Id 967',2198.56,0.00,0.00,3.02,138.92,'2022-07-30 19:05:15','',''),(979,'1','277','1',1,'Retail Sale Id 968',800.80,0.00,0.00,1.10,50.60,'2022-07-30 19:17:11','',''),(980,'1','277','1',1,'Retail Sale Id 969',4368.00,0.00,0.00,6.00,276.00,'2022-07-30 19:18:20','',''),(981,'1','277','1',1,'Retail Sale Id 970',2497.04,0.00,0.00,3.43,157.78,'2022-07-30 19:20:31','',''),(982,'1','277','1',1,'Retail Sale Id 971',800.80,0.00,0.00,1.10,50.60,'2022-07-30 19:25:47','',''),(983,'1','277','1',1,'Retail Sale Id 973',6501.04,0.00,0.00,8.93,410.78,'2022-07-30 19:58:32','',''),(984,'1','277','1',1,'Return of Retail Sale Id 973',0.00,6501.04,8.93,0.00,-410.78,'2022-07-30 20:16:10','',''),(985,'1','277','1',1,'Retail Sale Id 974',6319.04,0.00,0.00,8.68,399.28,'2022-07-30 20:18:47','',''),(986,'1','277','1',1,'Retail Sale Id 975',9100.00,0.00,0.00,12.50,575.00,'2022-07-31 06:43:30','',''),(987,'1','277','1',1,'Retail Sale Id 976',4397.12,0.00,0.00,6.04,277.84,'2022-07-31 06:59:11','',''),(988,'1','277','1',1,'Retail Sale Id 977',749.84,0.00,0.00,1.03,47.38,'2022-07-31 07:00:10','',''),(989,'1','277','1',1,'Retail Sale Id 978',1499.68,0.00,0.00,2.06,94.76,'2022-07-31 07:01:01','',''),(990,'1','277','1',1,'Retail Sale Id 979',39297.44,0.00,0.00,53.98,2483.08,'2022-07-31 07:18:36','',''),(991,'1','277','1',1,'Retail Sale Id 980',1499.68,0.00,0.00,2.06,94.76,'2022-07-31 07:23:08','',''),(992,'1','277','1',1,'Retail Sale Id 981',1499.68,0.00,0.00,2.06,94.76,'2022-07-31 07:32:39','',''),(993,'1','277','1',1,'Retail Sale Id 982',1499.68,0.00,0.00,2.06,94.76,'2022-07-31 07:33:20','',''),(994,'1','277','1',1,'Retail Sale Id 983',3996.72,0.00,0.00,5.49,252.54,'2022-07-31 07:48:21','',''),(995,'1','277','1',1,'Retail Sale Id 984',7280.00,0.00,0.00,10.00,460.00,'2022-07-31 07:53:24','',''),(996,'1','277','1',1,'Retail Sale Id 986',3640.00,0.00,0.00,5.00,230.00,'2022-07-31 07:57:00','',''),(997,'1','277','1',1,'Retail Sale Id 987',7280.00,0.00,0.00,10.00,460.00,'2022-07-31 08:05:03','',''),(998,'1','277','1',1,'Retail Sale Id 988',698.88,0.00,0.00,0.96,44.16,'2022-07-31 08:06:01','',''),(999,'1','277','1',1,'Retail Sale Id 989',2497.04,0.00,0.00,3.43,157.78,'2022-07-31 08:06:49','',''),(1000,'1','277','1',1,'Retail Sale Id 990',2002.00,0.00,0.00,2.75,126.50,'2022-07-31 08:13:00','',''),(1001,'1','277','1',1,'Retail Sale Id 991',1463.28,0.00,0.00,2.01,92.46,'2022-07-31 08:25:55','',''),(1002,'1','277','1',1,'Retail Sale Id 992',1499.68,0.00,0.00,2.06,94.76,'2022-07-31 08:38:32','',''),(1003,'1','277','1',1,'Retail Sale Id 993',2497.04,0.00,0.00,3.43,157.78,'2022-07-31 08:39:26','',''),(1004,'1','277','1',1,'Retail Sale Id 994',4397.12,0.00,0.00,6.04,277.84,'2022-07-31 08:42:44','',''),(1005,'1','277','1',1,'Retail Sale Id 995',1499.68,0.00,0.00,2.06,94.76,'2022-07-31 09:00:55','',''),(1006,'1','277','1',1,'Retail Sale Id 996',9100.00,0.00,0.00,12.50,575.00,'2022-07-31 09:34:31','',''),(1007,'1','277','1',1,'Retail Sale Id 997',1463.28,0.00,0.00,2.01,92.46,'2022-07-31 09:35:10','',''),(1008,'1','277','1',1,'Retail Sale Id 998',3640.00,0.00,0.00,5.00,230.00,'2022-07-31 09:36:17','',''),(1009,'1','277','1',1,'Retail Sale Id 999',3800.16,0.00,0.00,5.22,240.12,'2022-07-31 09:51:31','',''),(1010,'1','277','1',1,'Retail Sale Id 1000',800.80,0.00,0.00,1.10,50.60,'2022-07-31 09:53:01','',''),(1011,'1','277','1',1,'Retail Sale Id 1001',2912.00,0.00,0.00,4.00,184.00,'2022-07-31 09:54:51','',''),(1012,'1','277','1',1,'Retail Sale Id 1002',2999.36,0.00,0.00,4.12,189.52,'2022-07-31 10:03:57','',''),(1013,'1','277','1',1,'Retail Sale Id 1003',1499.68,0.00,0.00,2.06,94.76,'2022-07-31 10:06:42','',''),(1014,'1','277','1',1,'Retail Sale Id 1004',3996.72,0.00,0.00,5.49,252.54,'2022-07-31 10:10:34','',''),(1015,'1','277','1',1,'Retail Sale Id 1005',2999.36,0.00,0.00,4.12,189.52,'2022-07-31 10:11:38','',''),(1016,'1','277','1',1,'Retail Sale Id 1006',997.36,0.00,0.00,1.37,63.02,'2022-07-31 10:14:25','',''),(1017,'1','277','1',1,'Retail Sale Id 1007',997.36,0.00,0.00,1.37,63.02,'2022-07-31 10:16:31','',''),(1018,'1','277','1',1,'Retail Sale Id 1008',2912.00,0.00,0.00,4.00,184.00,'2022-07-31 10:17:29','',''),(1019,'1','277','1',1,'Retail Sale Id 1009',2002.00,0.00,0.00,2.75,126.50,'2022-07-31 10:18:16','',''),(1020,'1','277','1',1,'Retail Sale Id 1010',3800.16,0.00,0.00,5.22,240.12,'2022-07-31 10:19:49','',''),(1021,'1','277','1',1,'Retail Sale Id 1011',3698.24,0.00,0.00,5.08,233.68,'2022-07-31 10:27:47','',''),(1022,'1','277','1',1,'Retail Sale Id 1012',1463.28,0.00,0.00,2.01,92.46,'2022-07-31 10:36:16','',''),(1023,'1','277','1',1,'Retail Sale Id 1013',997.36,0.00,0.00,1.37,63.02,'2022-07-31 10:50:25','',''),(1024,'1','277','1',1,'Retail Sale Id 1014',1463.28,0.00,0.00,2.01,92.46,'2022-07-31 10:51:46','',''),(1025,'1','277','1',1,'Retail Sale Id 1015',4397.12,0.00,0.00,6.04,277.84,'2022-07-31 10:58:32','',''),(1026,'1','277','1',1,'Retail Sale Id 1016',9100.00,0.00,0.00,12.50,575.00,'2022-07-31 10:59:25','',''),(1027,'1','277','1',1,'Retail Sale Id 1017',7301.84,0.00,0.00,10.03,461.38,'2022-07-31 11:02:22','',''),(1028,'1','277','1',1,'Retail Sale Id 1018',3640.00,0.00,0.00,5.00,230.00,'2022-07-31 11:38:13','',''),(1029,'1','277','1',1,'Retail Sale Id 1019',2002.00,0.00,0.00,2.75,126.50,'2022-07-31 11:54:25','',''),(1030,'1','277','1',1,'Retail Sale Id 1020',12601.68,0.00,0.00,17.31,796.26,'2022-07-31 11:55:16','',''),(1031,'1','277','1',1,'Retail Sale Id 1021',12499.76,0.00,0.00,17.17,789.82,'2022-07-31 11:56:21','',''),(1032,'1','277','1',1,'Retail Sale Id 1022',9100.00,0.00,0.00,12.50,575.00,'2022-07-31 11:57:39','',''),(1033,'1','277','1',1,'Retail Sale Id 1024',2999.36,0.00,0.00,4.12,189.52,'2022-07-31 11:59:24','',''),(1034,'1','277','1',1,'Retail Sale Id 1025',2999.36,0.00,0.00,4.12,189.52,'2022-07-31 12:00:51','',''),(1035,'1','277','1',1,'Retail Sale Id 1026',1463.28,0.00,0.00,2.01,92.46,'2022-07-31 12:07:20','',''),(1036,'1','277','1',1,'Retail Sale Id 1027',3800.16,0.00,0.00,5.22,240.12,'2022-07-31 12:10:13','',''),(1037,'1','277','1',1,'Retail Sale Id 1028',1499.68,0.00,0.00,2.06,94.76,'2022-07-31 12:16:40','',''),(1038,'1','277','1',1,'Retail Sale Id 1029',3640.00,0.00,0.00,5.00,230.00,'2022-07-31 12:17:37','',''),(1039,'1','277','1',1,'Retail Sale Id 1030',4397.12,0.00,0.00,6.04,277.84,'2022-07-31 12:28:03','',''),(1040,'1','277','1',1,'Retail Sale Id 1031',2191.28,0.00,0.00,3.01,138.46,'2022-07-31 12:35:42','',''),(1041,'1','277','1',1,'Retail Sale Id 1032',1798.16,0.00,0.00,2.47,113.62,'2022-07-31 12:36:58','',''),(1042,'1','277','1',1,'Retail Sale Id 1033',997.36,0.00,0.00,1.37,63.02,'2022-07-31 12:39:51','',''),(1043,'1','277','1',1,'Retail Sale Id 1034',3640.00,0.00,0.00,5.00,230.00,'2022-07-31 12:54:35','',''),(1044,'1','277','1',1,'Retail Sale Id 1035',2999.36,0.00,0.00,4.12,189.52,'2022-07-31 12:56:15','',''),(1045,'1','277','1',1,'Retail Sale Id 1036',3996.72,0.00,0.00,5.49,252.54,'2022-07-31 13:04:15','',''),(1046,'1','277','1',1,'Retail Sale Id 1037',2999.36,0.00,0.00,4.12,189.52,'2022-07-31 13:05:16','',''),(1047,'1','277','1',1,'Retail Sale Id 1038',1099.28,0.00,0.00,1.51,69.46,'2022-07-31 13:12:09','',''),(1048,'1','277','1',1,'Retail Sale Id 1039',4368.00,0.00,0.00,6.00,276.00,'2022-07-31 13:13:50','',''),(1049,'1','277','1',1,'Retail Sale Id 1040',3501.68,0.00,0.00,4.81,221.26,'2022-07-31 13:15:55','',''),(1050,'1','277','1',1,'Retail Sale Id 1041',1463.28,0.00,0.00,2.01,92.46,'2022-07-31 13:17:58','',''),(1051,'1','277','1',1,'Retail Sale Id 1042',749.84,0.00,0.00,1.03,47.38,'2022-07-31 13:37:45','',''),(1052,'1','277','1',1,'Retail Sale Id 1043',997.36,0.00,0.00,1.37,63.02,'2022-07-31 13:38:19','',''),(1053,'1','277','1',1,'Retail Sale Id 1044',3698.24,0.00,0.00,5.08,233.68,'2022-07-31 13:40:02','',''),(1054,'1','277','1',1,'Retail Sale Id 1045',8998.08,0.00,0.00,12.36,568.56,'2022-07-31 13:42:07','',''),(1055,'1','277','1',1,'Retail Sale Id 1047',4397.12,0.00,0.00,6.04,277.84,'2022-07-31 13:44:46','',''),(1056,'1','277','1',1,'Retail Sale Id 1048',3501.68,0.00,0.00,4.81,221.26,'2022-07-31 14:04:53','',''),(1057,'1','277','1',1,'Retail Sale Id 1049',4397.12,0.00,0.00,6.04,277.84,'2022-07-31 14:09:12','',''),(1058,'1','277','1',1,'Retail Sale Id 1050',1303.12,0.00,0.00,1.79,82.34,'2022-07-31 14:21:42','',''),(1059,'1','277','1',1,'Retail Sale Id 1051',4499.04,0.00,0.00,6.18,284.28,'2022-07-31 14:24:00','',''),(1060,'1','277','1',1,'Retail Sale Id 1052',3640.00,0.00,0.00,5.00,230.00,'2022-07-31 14:26:30','',''),(1061,'1','277','1',1,'Retail Sale Id 1053',2191.28,0.00,0.00,3.01,138.46,'2022-07-31 14:29:30','',''),(1062,'1','277','1',1,'Retail Sale Id 1054',502.32,0.00,0.00,0.69,31.74,'2022-07-31 14:41:03','',''),(1063,'1','277','1',1,'Retail Sale Id 1055',2096.64,0.00,0.00,2.88,132.48,'2022-07-31 14:47:23','',''),(1064,'1','277','1',1,'Retail Sale Id 1056',4499.04,0.00,0.00,6.18,284.28,'2022-07-31 14:49:49','',''),(1065,'1','277','1',1,'Retail Sale Id 1057',9100.00,0.00,0.00,12.50,575.00,'2022-07-31 15:03:53','',''),(1066,'1','277','1',1,'Retail Sale Id 1058',8000.72,0.00,0.00,10.99,505.54,'2022-07-31 15:11:12','',''),(1067,'1','277','1',1,'Retail Sale Id 1060',4397.12,0.00,0.00,6.04,277.84,'2022-07-31 15:14:47','',''),(1068,'1','277','1',1,'Retail Sale Id 1061',5998.72,0.00,0.00,8.24,379.04,'2022-07-31 15:18:18','',''),(1069,'1','277','1',1,'Retail Sale Id 1062',13599.04,0.00,0.00,18.68,859.28,'2022-07-31 15:26:48','',''),(1070,'1','277','1',1,'Retail Sale Id 1063',2002.00,0.00,0.00,2.75,126.50,'2022-07-31 15:38:06','',''),(1071,'1','277','1',1,'Retail Sale Id 1064',3640.00,0.00,0.00,5.00,230.00,'2022-07-31 15:39:13','',''),(1072,'1','277','1',1,'Retail Sale Id 1066',3698.24,0.00,0.00,5.08,233.68,'2022-07-31 15:42:37','',''),(1073,'1','277','1',1,'Retail Sale Id 1067',2198.56,0.00,0.00,3.02,138.92,'2022-07-31 15:53:15','',''),(1074,'1','277','1',1,'Retail Sale Id 1068',9100.00,0.00,0.00,12.50,575.00,'2022-07-31 15:56:56','',''),(1075,'1','277','1',1,'Retail Sale Id 1069',800.80,0.00,0.00,1.10,50.60,'2022-07-31 15:57:38','',''),(1076,'1','277','1',1,'Retail Sale Id 1070',4397.12,0.00,0.00,6.04,277.84,'2022-07-31 16:10:35','',''),(1077,'1','277','1',1,'Retail Sale Id 1071',3698.24,0.00,0.00,5.08,233.68,'2022-07-31 16:46:00','',''),(1078,'1','277','1',1,'Retail Sale Id 1072',9100.00,0.00,0.00,12.50,575.00,'2022-07-31 16:48:09','',''),(1079,'1','277','1',1,'Retail Sale Id 1073',2002.00,0.00,0.00,2.75,126.50,'2022-07-31 16:49:46','',''),(1080,'1','277','1',1,'Retail Sale Id 1075',3640.00,0.00,0.00,5.00,230.00,'2022-07-31 16:55:47','',''),(1081,'1','277','1',1,'Retail Sale Id 1077',2198.56,0.00,0.00,3.02,138.92,'2022-07-31 16:57:55','',''),(1082,'1','277','1',1,'Retail Sale Id 1079',2999.36,0.00,0.00,4.12,189.52,'2022-07-31 17:01:13','',''),(1083,'1','277','1',1,'Retail Sale Id 1080',9100.00,0.00,0.00,12.50,575.00,'2022-07-31 17:02:21','',''),(1084,'1','277','1',1,'Retail Sale Id 1081',1499.68,0.00,0.00,2.06,94.76,'2022-07-31 17:03:39','',''),(1085,'1','277','1',1,'Retail Sale Id 1082',502.32,0.00,0.00,0.69,31.74,'2022-07-31 17:07:58','',''),(1086,'1','277','1',1,'Retail Sale Id 1083',2999.36,0.00,0.00,4.12,189.52,'2022-07-31 17:12:10','',''),(1087,'1','277','1',1,'Retail Sale Id 1084',4397.12,0.00,0.00,6.04,277.84,'2022-07-31 17:13:16','',''),(1088,'1','277','1',1,'Retail Sale Id 1085',14560.00,0.00,0.00,20.00,920.00,'2022-07-31 17:25:56','',''),(1089,'1','277','1',1,'Retail Sale Id 1086',3996.72,0.00,0.00,5.49,252.54,'2022-07-31 17:28:40','',''),(1090,'1','277','1',1,'Retail Sale Id 1087',1499.68,0.00,0.00,2.06,94.76,'2022-07-31 17:35:52','',''),(1091,'1','277','1',1,'Retail Sale Id 1088',4368.00,0.00,0.00,6.00,276.00,'2022-07-31 17:44:35','',''),(1092,'1','277','1',1,'Retail Sale Id 1090',9100.00,0.00,0.00,12.50,575.00,'2022-07-31 17:49:53','',''),(1093,'1','277','1',1,'Return of Retail Sale Id 1000',0.00,800.80,1.10,0.00,-50.60,'2022-07-31 17:52:57','',''),(1094,'1','277','1',1,'Retail Sale Id 1091',800.80,0.00,0.00,1.10,50.60,'2022-07-31 17:55:18','',''),(1095,'1','277','1',1,'Retail Sale Id 1092',1499.68,0.00,0.00,2.06,94.76,'2022-07-31 17:59:46','',''),(1096,'1','277','1',1,'Retail Sale Id 1093',2002.00,0.00,0.00,2.75,126.50,'2022-07-31 18:00:28','',''),(1097,'1','277','1',1,'Retail Sale Id 1094',2002.00,0.00,0.00,2.75,126.50,'2022-07-31 18:03:07','',''),(1098,'1','277','1',1,'Retail Sale Id 1095',1499.68,0.00,0.00,2.06,94.76,'2022-07-31 18:03:59','',''),(1099,'1','277','1',1,'Retail Sale Id 1096',2198.56,0.00,0.00,3.02,138.92,'2022-07-31 18:07:59','',''),(1100,'1','277','1',1,'Retail Sale Id 1097',2198.56,0.00,0.00,3.02,138.92,'2022-07-31 18:10:53','',''),(1101,'1','277','1',1,'Retail Sale Id 1100',800.80,0.00,0.00,1.10,50.60,'2022-07-31 18:26:14','',''),(1102,'1','277','1',1,'Retail Sale Id 1101',4397.12,0.00,0.00,6.04,277.84,'2022-07-31 18:30:51','',''),(1103,'1','277','1',1,'Retail Sale Id 1102',5001.36,0.00,0.00,6.87,316.02,'2022-07-31 18:36:40','',''),(1104,'1','277','1',1,'Retail Sale Id 1104',2198.56,0.00,0.00,3.02,138.92,'2022-07-31 18:39:59','',''),(1105,'1','277','1',1,'Retail Sale Id 1105',4397.12,0.00,0.00,6.04,277.84,'2022-07-31 18:43:07','',''),(1106,'1','277','1',1,'Retail Sale Id 1106',698.88,0.00,0.00,0.96,44.16,'2022-07-31 18:46:27','',''),(1107,'1','277','1',1,'Retail Sale Id 1109',2999.36,0.00,0.00,4.12,189.52,'2022-07-31 18:53:15','',''),(1108,'1','277','1',1,'Retail Sale Id 1110',2497.04,0.00,0.00,3.43,157.78,'2022-07-31 18:57:38','',''),(1109,'1','277','1',1,'Return of Retail Sale Id 1033',0.00,997.36,1.37,0.00,-63.02,'2022-07-31 19:21:55','',''),(1110,'1','277','1',1,'Return of Retail Sale Id 1106',0.00,698.88,0.96,0.00,-44.16,'2022-07-31 19:26:36','',''),(1111,'1','277','1',1,'Retail Sale Id 1111',1914.64,0.00,0.00,2.63,120.98,'2022-07-31 19:59:54','',''),(1112,'1','277','1',1,'Distributed to Operational lost for sales id:1',59279.44,0.00,0.00,86.92,0.00,'2022-07-31 20:26:57','',''),(1113,'1','277',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,1330000.00,2000.00,0.00,0.00,'2022-08-01 06:49:08','',''),(1114,'1','277',NULL,1,'Reception corrector for bridging 2',0.00,0.00,0.00,2000.00,0.00,'2022-08-01 06:51:40','',''),(1115,'1','277','1',1,'Received from bridging 2',0.00,0.00,2000.00,0.00,0.00,'2022-08-01 06:51:40','',''),(1116,'1','277','1',1,'Retail Sale Id 1112',2198.56,0.00,0.00,3.02,190.26,'2022-08-01 07:01:04','',''),(1117,'1','277','1',1,'Retail Sale Id 1113',2198.56,0.00,0.00,3.02,190.26,'2022-08-01 07:11:06','',''),(1118,'1','277','1',1,'Retail Sale Id 1114',728.00,0.00,0.00,1.00,63.00,'2022-08-01 07:14:35','',''),(1119,'1','277','1',1,'Retail Sale Id 1115',1499.68,0.00,0.00,2.06,129.78,'2022-08-01 07:17:53','',''),(1120,'1','277','1',1,'Retail Sale Id 1116',2198.56,0.00,0.00,3.02,190.26,'2022-08-01 07:56:12','',''),(1121,'1','277','1',1,'Retail Sale Id 1118',1900.08,0.00,0.00,2.61,164.43,'2022-08-01 08:02:03','',''),(1122,'1','277','1',1,'Retail Sale Id 1120',2999.36,0.00,0.00,4.12,259.56,'2022-08-01 08:05:08','',''),(1123,'1','277','1',1,'Retail Sale Id 1121',2002.00,0.00,0.00,2.75,173.25,'2022-08-01 08:06:30','',''),(1124,'1','277','1',1,'Retail Sale Id 1123',800.80,0.00,0.00,1.10,69.30,'2022-08-01 08:08:25','',''),(1125,'1','277','1',1,'Retail Sale Id 1124',5998.72,0.00,0.00,8.24,519.12,'2022-08-01 08:12:17','',''),(1126,'1','277','1',1,'Retail Sale Id 1125',2999.36,0.00,0.00,4.12,259.56,'2022-08-01 08:38:31','',''),(1127,'1','277','1',1,'Retail Sale Id 1126',9100.00,0.00,0.00,12.50,787.50,'2022-08-01 08:47:16','',''),(1128,'1','277','1',1,'Retail Sale Id 1127',2191.28,0.00,0.00,3.01,189.63,'2022-08-01 08:53:39','',''),(1129,'1','277','1',1,'Retail Sale Id 1128',2002.00,0.00,0.00,2.75,173.25,'2022-08-01 08:56:29','',''),(1130,'1','277','1',1,'Retail Sale Id 1129',9100.00,0.00,0.00,12.50,787.50,'2022-08-01 09:00:48','',''),(1131,'1','277','1',1,'Retail Sale Id 1130',1499.68,0.00,0.00,2.06,129.78,'2022-08-01 09:02:04','',''),(1132,'1','277','1',1,'Retail Sale Id 1131',800.80,0.00,0.00,1.10,69.30,'2022-08-01 09:02:56','',''),(1133,'1','277','1',1,'Retail Sale Id 1132',9100.00,0.00,0.00,12.50,787.50,'2022-08-01 09:04:34','',''),(1134,'1','277','1',1,'Retail Sale Id 1133',997.36,0.00,0.00,1.37,86.31,'2022-08-01 09:05:21','',''),(1135,'1','277','1',1,'Retail Sale Id 1134',24325.00,0.00,0.00,35.00,1050.00,'2022-08-01 09:10:30','',''),(1136,'1','277','1',1,'Retail Sale Id 1135',2999.36,0.00,0.00,4.12,259.56,'2022-08-01 09:11:43','',''),(1137,'1','277','1',1,'Retail Sale Id 1136',2002.00,0.00,0.00,2.75,173.25,'2022-08-01 09:17:40','',''),(1138,'1','277','1',1,'Retail Sale Id 1139',2198.56,0.00,0.00,3.02,190.26,'2022-08-01 09:26:41','',''),(1139,'1','277','1',1,'Retail Sale Id 1140',2002.00,0.00,0.00,2.75,173.25,'2022-08-01 09:27:53','',''),(1140,'1','277',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,1396500.00,2100.00,0.00,0.00,'2022-08-01 09:40:56','',''),(1141,'1','277','1',1,'Retail Sale Id 1142',2002.00,0.00,0.00,2.75,173.25,'2022-08-01 09:50:34','',''),(1142,'1','277',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,2100.00,0.00,'2022-08-01 09:51:22','',''),(1143,'1','277','1',1,'Received from bridging 3',0.00,0.00,2100.00,0.00,0.00,'2022-08-01 09:51:22','',''),(1144,'1','277','1',1,'Retail Sale Id 1143',4368.00,0.00,0.00,6.00,378.00,'2022-08-01 09:52:15','',''),(1145,'1','277','1',1,'Retail Sale Id 1144',4397.12,0.00,0.00,6.04,380.52,'2022-08-01 09:55:08','',''),(1146,'1','277','1',1,'Retail Sale Id 1145',2002.00,0.00,0.00,2.75,173.25,'2022-08-01 09:58:47','',''),(1147,'1','277','1',1,'Retail Sale Id 1146',4397.12,0.00,0.00,6.04,380.52,'2022-08-01 10:14:59','',''),(1148,'1','277','1',1,'Retail Sale Id 1148',2198.56,0.00,0.00,3.02,190.26,'2022-08-01 10:16:16','',''),(1149,'1','277','1',1,'Retail Sale Id 1149',2002.00,0.00,0.00,2.75,173.25,'2022-08-01 10:28:39','',''),(1150,'1','277','1',1,'Retail Sale Id 1150',243250.00,0.00,0.00,350.00,10500.00,'2022-08-01 10:36:41','',''),(1151,'1','277','1',1,'Retail Sale Id 1151',4302.48,0.00,0.00,5.91,372.33,'2022-08-01 10:45:04','',''),(1152,'1','277','1',1,'Retail Sale Id 1152',243250.00,0.00,0.00,350.00,10500.00,'2022-08-01 10:51:39','',''),(1153,'1','277','1',1,'Retail Sale Id 1153',2198.56,0.00,0.00,3.02,190.26,'2022-08-01 11:01:15','',''),(1154,'1','277','1',1,'Retail Sale Id 1154',2198.56,0.00,0.00,3.02,190.26,'2022-08-01 11:16:51','',''),(1155,'1','277','1',1,'Retail Sale Id 1155',800.80,0.00,0.00,1.10,69.30,'2022-08-01 11:26:29','',''),(1156,'1','277','1',1,'Retail Sale Id 1156',1499.68,0.00,0.00,2.06,129.78,'2022-08-01 11:43:15','',''),(1157,'1','277','1',1,'Retail Sale Id 1157',2198.56,0.00,0.00,3.02,190.26,'2022-08-01 11:47:28','',''),(1158,'1','277','1',1,'Retail Sale Id 1158',9100.00,0.00,0.00,12.50,787.50,'2022-08-01 11:57:48','',''),(1159,'1','277','1',1,'Retail Sale Id 1159',997.36,0.00,0.00,1.37,86.31,'2022-08-01 12:00:57','',''),(1160,'1','277','1',1,'Retail Sale Id 1160',2497.04,0.00,0.00,3.43,216.09,'2022-08-01 12:02:31','',''),(1161,'1','277','1',1,'Retail Sale Id 1162',2198.56,0.00,0.00,3.02,190.26,'2022-08-01 12:07:41','',''),(1162,'1','277','1',1,'Retail Sale Id 1163',3996.72,0.00,0.00,5.49,345.87,'2022-08-01 12:09:58','',''),(1163,'1','277','1',1,'Retail Sale Id 1164',1499.68,0.00,0.00,2.06,129.78,'2022-08-01 12:10:45','',''),(1164,'1','277','1',1,'Retail Sale Id 1165',3647.28,0.00,0.00,5.01,315.63,'2022-08-01 12:23:31','',''),(1165,'1','277','1',1,'Retail Sale Id 1166',502.32,0.00,0.00,0.69,43.47,'2022-08-01 12:26:48','',''),(1166,'1','277','1',1,'Retail Sale Id 1167',104250.00,0.00,0.00,150.00,4500.00,'2022-08-01 12:29:11','',''),(1167,'1','277','1',1,'Retail Sale Id 1168',10920.00,0.00,0.00,15.00,945.00,'2022-08-01 13:01:47','',''),(1168,'1','277','1',1,'Retail Sale Id 1169',2002.00,0.00,0.00,2.75,173.25,'2022-08-01 13:28:20','',''),(1169,'1','277','1',1,'Retail Sale Id 1170',9100.00,0.00,0.00,12.50,787.50,'2022-08-01 13:59:05','',''),(1170,'1','277','1',1,'Retail Sale Id 1171',24325.00,0.00,0.00,35.00,1050.00,'2022-08-01 14:09:04','',''),(1171,'1','277','1',1,'Retail Sale Id 1172',69500.00,0.00,0.00,100.00,3000.00,'2022-08-01 14:12:20','',''),(1172,'1','277','1',1,'Retail Sale Id 1173',3698.24,0.00,0.00,5.08,320.04,'2022-08-01 14:24:31','',''),(1173,'1','277','1',1,'Retail Sale Id 1174',3800.16,0.00,0.00,5.22,328.86,'2022-08-01 14:35:24','',''),(1174,'1','277','1',1,'Retail Sale Id 1175',4397.12,0.00,0.00,6.04,380.52,'2022-08-01 14:36:50','',''),(1175,'1','277','1',1,'Retail Sale Id 1176',2999.36,0.00,0.00,4.12,259.56,'2022-08-01 14:49:21','',''),(1176,'1','277','1',1,'Retail Sale Id 1177',2300.48,0.00,0.00,3.16,199.08,'2022-08-01 14:51:06','',''),(1177,'1','277','1',1,'Retail Sale Id 1178',2999.36,0.00,0.00,4.12,259.56,'2022-08-01 15:04:49','',''),(1178,'1','277','1',1,'Retail Sale Id 1179',3800.16,0.00,0.00,5.22,328.86,'2022-08-01 15:15:48','',''),(1179,'1','277','1',1,'Retail Sale Id 1180',2249.52,0.00,0.00,3.09,194.67,'2022-08-01 15:32:32','',''),(1180,'1','277','1',1,'Retail Sale Id 1181',1099.28,0.00,0.00,1.51,95.13,'2022-08-01 15:52:47','',''),(1181,'1','277','1',1,'Retail Sale Id 1182',2198.56,0.00,0.00,3.02,190.26,'2022-08-01 15:56:08','',''),(1182,'1','277','1',1,'Retail Sale Id 1183',997.36,0.00,0.00,1.37,86.31,'2022-08-01 16:00:50','',''),(1183,'1','277','1',1,'Retail Sale Id 1184',9100.00,0.00,0.00,12.50,787.50,'2022-08-01 16:01:57','',''),(1184,'1','277','1',1,'Retail Sale Id 1185',9100.00,0.00,0.00,12.50,787.50,'2022-08-01 16:13:46','',''),(1185,'1','277','1',1,'Retail Sale Id 1186',3647.28,0.00,0.00,5.01,315.63,'2022-08-01 16:15:06','',''),(1186,'1','277','1',1,'Retail Sale Id 1187',8401.12,0.00,0.00,11.54,727.02,'2022-08-01 16:20:26','',''),(1187,'1','277','1',1,'Retail Sale Id 1188',2002.00,0.00,0.00,2.75,173.25,'2022-08-01 16:28:37','',''),(1188,'1','277','1',1,'Retail Sale Id 1190',9100.00,0.00,0.00,12.50,787.50,'2022-08-01 16:30:16','',''),(1189,'1','277','1',1,'Retail Sale Id 1191',1499.68,0.00,0.00,2.06,129.78,'2022-08-01 16:31:28','',''),(1190,'1','277','1',1,'Retail Sale Id 1192',3800.16,0.00,0.00,5.22,328.86,'2022-08-01 16:34:38','',''),(1191,'1','277','1',1,'Retail Sale Id 1194',4368.00,0.00,0.00,6.00,378.00,'2022-08-01 16:40:51','',''),(1192,'1','277','1',1,'Retail Sale Id 1195',1499.68,0.00,0.00,2.06,129.78,'2022-08-01 16:42:35','',''),(1193,'1','277','1',1,'Retail Sale Id 1196',9100.00,0.00,0.00,12.50,787.50,'2022-08-01 16:45:29','',''),(1194,'1','277','1',1,'Retail Sale Id 1196',9100.00,0.00,0.00,12.50,787.50,'2022-08-01 16:45:29','',''),(1195,'1','277','1',1,'Retail Sale Id 1197',4397.12,0.00,0.00,6.04,380.52,'2022-08-01 16:47:08','',''),(1196,'1','277','1',1,'Retail Sale Id 1198',4397.12,0.00,0.00,6.04,380.52,'2022-08-01 16:51:36','',''),(1197,'1','277','1',1,'Retail Sale Id 1199',1499.68,0.00,0.00,2.06,129.78,'2022-08-01 17:08:35','',''),(1198,'1','277','1',1,'Retail Sale Id 1200',2198.56,0.00,0.00,3.02,190.26,'2022-08-01 17:09:39','',''),(1199,'1','277','1',1,'Retail Sale Id 1201',2497.04,0.00,0.00,3.43,216.09,'2022-08-01 17:10:31','',''),(1200,'1','277','1',1,'Retail Sale Id 1202',800.80,0.00,0.00,1.10,69.30,'2022-08-01 17:11:26','',''),(1201,'1','277','1',1,'Retail Sale Id 1203',4899.44,0.00,0.00,6.73,423.99,'2022-08-01 17:12:40','',''),(1202,'1','277','1',1,'Retail Sale Id 1204',502.32,0.00,0.00,0.69,43.47,'2022-08-01 17:13:35','',''),(1203,'1','277','1',1,'Retail Sale Id 1205',1499.68,0.00,0.00,2.06,129.78,'2022-08-01 17:17:58','',''),(1204,'1','277','1',1,'Retail Sale Id 1206',4397.12,0.00,0.00,6.04,380.52,'2022-08-01 17:19:23','',''),(1205,'1','277','1',1,'Retail Sale Id 1207',4397.12,0.00,0.00,6.04,380.52,'2022-08-01 17:24:15','',''),(1206,'1','277','1',1,'Retail Sale Id 1208',2198.56,0.00,0.00,3.02,190.26,'2022-08-01 17:25:20','',''),(1207,'1','277','1',1,'Retail Sale Id 1209',997.36,0.00,0.00,1.37,86.31,'2022-08-01 17:33:49','',''),(1208,'1','277','1',1,'Retail Sale Id 1210',1303.12,0.00,0.00,1.79,112.77,'2022-08-01 17:35:06','',''),(1209,'1','277','1',1,'Retail Sale Id 1211',22935.00,0.00,0.00,33.00,990.00,'2022-08-01 17:47:25','',''),(1210,'1','277','1',1,'Retail Sale Id 1212',2919.28,0.00,0.00,4.01,252.63,'2022-08-01 17:50:19','',''),(1211,'1','277','1',1,'Retail Sale Id 1213',2802.80,0.00,0.00,3.85,242.55,'2022-08-01 17:52:12','',''),(1212,'1','277','1',1,'Retail Sale Id 1214',78493.30,0.00,0.00,112.94,3388.20,'2022-08-01 18:00:30','',''),(1213,'1','277','1',1,'Retail Sale Id 1216',4397.12,0.00,0.00,6.04,380.52,'2022-08-01 18:02:53','',''),(1214,'1','277','1',1,'Retail Sale Id 1217',997.36,0.00,0.00,1.37,86.31,'2022-08-01 18:04:08','',''),(1215,'1','277','1',1,'Retail Sale Id 1218',698.88,0.00,0.00,0.96,60.48,'2022-08-01 18:06:10','',''),(1216,'1','277','1',1,'Retail Sale Id 1219',7280.00,0.00,0.00,10.00,630.00,'2022-08-01 18:08:36','',''),(1217,'1','277','1',1,'Retail Sale Id 1220',2198.56,0.00,0.00,3.02,190.26,'2022-08-01 18:10:21','',''),(1218,'1','277','1',1,'Retail Sale Id 1221',2184.00,0.00,0.00,3.00,189.00,'2022-08-01 18:12:44','',''),(1219,'1','277','1',1,'Retail Sale Id 1222',4397.12,0.00,0.00,6.04,380.52,'2022-08-01 18:15:21','',''),(1220,'1','277','1',1,'Retail Sale Id 1222',4397.12,0.00,0.00,6.04,380.52,'2022-08-01 18:15:21','',''),(1221,'1','277','1',1,'Retail Sale Id 1223',1499.68,0.00,0.00,2.06,129.78,'2022-08-01 18:16:30','',''),(1222,'1','277','1',1,'Retail Sale Id 1224',2002.00,0.00,0.00,2.75,173.25,'2022-08-01 18:17:29','',''),(1223,'1','277','1',1,'Retail Sale Id 1225',1499.68,0.00,0.00,2.06,129.78,'2022-08-01 18:23:48','',''),(1224,'1','277','1',1,'Retail Sale Id 1226',3203.20,0.00,0.00,4.40,277.20,'2022-08-01 18:24:45','',''),(1225,'1','277','1',1,'Retail Sale Id 1227',997.36,0.00,0.00,1.37,86.31,'2022-08-01 18:29:36','',''),(1226,'1','277','1',1,'Retail Sale Id 1228',4397.12,0.00,0.00,6.04,380.52,'2022-08-01 18:31:09','',''),(1227,'1','277','1',1,'Retail Sale Id 1229',1499.68,0.00,0.00,2.06,129.78,'2022-08-01 18:31:55','',''),(1228,'1','277','1',1,'Retail Sale Id 1230',502.32,0.00,0.00,0.69,43.47,'2022-08-01 18:34:41','',''),(1229,'1','277','1',1,'Retail Sale Id 1231',5001.36,0.00,0.00,6.87,432.81,'2022-08-01 18:39:54','',''),(1230,'1','277','1',1,'Retail Sale Id 1232',2002.00,0.00,0.00,2.75,173.25,'2022-08-01 18:51:22','',''),(1231,'1','277','1',1,'Retail Sale Id 1233',2999.36,0.00,0.00,4.12,259.56,'2022-08-01 18:54:38','',''),(1232,'1','277','1',1,'Retail Sale Id 1234',2999.36,0.00,0.00,4.12,259.56,'2022-08-01 19:27:44','',''),(1233,'1','277','1',1,'Return of Retail Sale Id 1233',0.00,2999.36,4.12,0.00,-259.56,'2022-08-01 22:11:12','',''),(1234,'1','277','1',1,'Retail Sale Id 1235',2839.20,0.00,0.00,3.90,245.70,'2022-08-01 22:13:17','',''),(1235,'1','277','1',1,'Retail Sale Id 1236',2999.36,0.00,0.00,4.12,259.56,'2022-08-02 07:17:15','',''),(1236,'1','277','1',1,'Retail Sale Id 1237',2198.56,0.00,0.00,3.02,190.26,'2022-08-02 07:19:47','',''),(1237,'1','277','1',1,'Retail Sale Id 1239',4397.12,0.00,0.00,6.04,380.52,'2022-08-02 07:23:22','',''),(1238,'1','277','1',1,'Retail Sale Id 1240',2999.36,0.00,0.00,4.12,259.56,'2022-08-02 07:30:15','',''),(1239,'1','277','1',1,'Retail Sale Id 1241',2002.00,0.00,0.00,2.75,173.25,'2022-08-02 07:33:22','',''),(1240,'1','277','1',1,'Retail Sale Id 1242',1499.68,0.00,0.00,2.06,129.78,'2022-08-02 07:41:01','',''),(1241,'1','277','1',1,'Retail Sale Id 1243',34750.00,0.00,0.00,50.00,1500.00,'2022-08-02 14:04:47','',''),(1242,'1','277','1',1,'Retail Sale Id 1244',2002.00,0.00,0.00,2.75,173.25,'2022-08-02 14:07:41','',''),(1243,'1','277','1',1,'Retail Sale Id 1245',34750.00,0.00,0.00,50.00,1500.00,'2022-08-02 14:50:26','',''),(1244,'1','277','1',1,'Retail Sale Id 1246',2999.36,0.00,0.00,4.12,259.56,'2022-08-02 14:54:46','',''),(1245,'1','277','1',1,'Retail Sale Id 1247',24325.00,0.00,0.00,35.00,1050.00,'2022-08-02 15:00:20','',''),(1246,'1','277','1',1,'Retail Sale Id 1248',4499.04,0.00,0.00,6.18,389.34,'2022-08-02 15:03:31','',''),(1247,'1','277','1',1,'Return of Retail Sale Id 1247',0.00,24325.00,35.00,0.00,-1050.00,'2022-08-02 15:13:46','',''),(1248,'1','277','1',1,'Retail Sale Id 1252',33012.50,0.00,0.00,47.50,1425.00,'2022-08-02 15:16:25','',''),(1249,'1','277','1',1,'Retail Sale Id 1253',997.36,0.00,0.00,1.37,86.31,'2022-08-02 15:23:33','',''),(1250,'1','277','1',1,'Retail Sale Id 1254',29702.40,0.00,0.00,40.80,2570.40,'2022-08-02 15:25:50','',''),(1251,'1','277','1',1,'Retail Sale Id 1255',4397.12,0.00,0.00,6.04,380.52,'2022-08-02 15:28:38','',''),(1252,'1','277','1',1,'Retail Sale Id 1256',2002.00,0.00,0.00,2.75,173.25,'2022-08-02 15:29:37','',''),(1253,'1','277','1',1,'Retail Sale Id 1257',25552.80,0.00,0.00,35.10,2211.30,'2022-08-02 15:32:43','',''),(1254,'1','277','1',1,'Retail Sale Id 1258',4368.00,0.00,0.00,6.00,378.00,'2022-08-02 15:34:26','',''),(1255,'1','277','1',1,'Retail Sale Id 1259',3996.72,0.00,0.00,5.49,345.87,'2022-08-02 15:36:05','',''),(1256,'1','277','1',1,'Retail Sale Id 1260',7753.20,0.00,0.00,10.65,670.95,'2022-08-02 15:38:21','',''),(1257,'1','277','1',1,'Retail Sale Id 1261',3800.16,0.00,0.00,5.22,328.86,'2022-08-02 15:41:00','',''),(1258,'1','277','1',1,'Retail Sale Id 1266',2198.56,0.00,0.00,3.02,190.26,'2022-08-02 15:56:22','',''),(1259,'1','277','1',1,'Retail Sale Id 1267',3996.72,0.00,0.00,5.49,345.87,'2022-08-02 15:59:29','',''),(1260,'1','277','1',1,'Retail Sale Id 1268',9100.00,0.00,0.00,12.50,787.50,'2022-08-02 16:00:19','',''),(1261,'1','277','1',1,'Retail Sale Id 1269',3698.24,0.00,0.00,5.08,320.04,'2022-08-02 16:10:57','',''),(1262,'1','277','1',1,'Retail Sale Id 1270',3698.24,0.00,0.00,5.08,320.04,'2022-08-02 16:13:09','',''),(1263,'1','277','1',1,'Retail Sale Id 1271',2919.28,0.00,0.00,4.01,252.63,'2022-08-02 16:14:44','',''),(1264,'1','277','1',1,'Retail Sale Id 1272',3501.68,0.00,0.00,4.81,303.03,'2022-08-02 16:17:19','',''),(1265,'1','277','1',1,'Retail Sale Id 1273',2999.36,0.00,0.00,4.12,259.56,'2022-08-02 16:18:18','',''),(1266,'1','277','1',1,'Retail Sale Id 1274',4368.00,0.00,0.00,6.00,378.00,'2022-08-02 16:22:47','',''),(1267,'1','277','1',1,'Retail Sale Id 1275',1499.68,0.00,0.00,2.06,129.78,'2022-08-02 16:41:22','',''),(1268,'1','277','1',1,'Retail Sale Id 1276',2198.56,0.00,0.00,3.02,190.26,'2022-08-02 16:58:53','',''),(1269,'1','277','1',1,'Retail Sale Id 1277',749.84,0.00,0.00,1.03,64.89,'2022-08-02 17:03:37','',''),(1270,'1','277','1',1,'Retail Sale Id 1278',997.36,0.00,0.00,1.37,86.31,'2022-08-02 17:28:34','',''),(1271,'1','277','1',1,'Retail Sale Id 1279',2999.36,0.00,0.00,4.12,259.56,'2022-08-02 17:31:16','',''),(1272,'1','277','1',1,'Retail Sale Id 1280',18098.08,0.00,0.00,24.86,1566.18,'2022-08-02 17:37:48','',''),(1273,'1','277','1',1,'Retail Sale Id 1281',2300.48,0.00,0.00,3.16,199.08,'2022-08-02 17:40:57','',''),(1274,'1','277','1',1,'Retail Sale Id 1282',1499.68,0.00,0.00,2.06,129.78,'2022-08-02 17:46:26','',''),(1275,'1','277','1',1,'Retail Sale Id 1283',800.80,0.00,0.00,1.10,69.30,'2022-08-02 17:49:25','',''),(1276,'1','277','1',1,'Retail Sale Id 1284',2999.36,0.00,0.00,4.12,259.56,'2022-08-02 17:52:58','',''),(1277,'1','277','1',1,'Retail Sale Id 1286',8998.08,0.00,0.00,12.36,778.68,'2022-08-02 17:57:19','',''),(1278,'1','277','1',1,'Retail Sale Id 1287',1499.68,0.00,0.00,2.06,129.78,'2022-08-02 17:59:15','',''),(1279,'1','277','1',1,'Retail Sale Id 1288',16962.40,0.00,0.00,23.30,1467.90,'2022-08-02 18:01:31','',''),(1280,'1','277','1',1,'Retail Sale Id 1289',4368.00,0.00,0.00,6.00,378.00,'2022-08-02 18:03:52','',''),(1281,'1','277','1',1,'Retail Sale Id 1290',8299.20,0.00,0.00,11.40,718.20,'2022-08-02 18:05:27','',''),(1282,'1','277','1',1,'Retail Sale Id 1292',3996.72,0.00,0.00,5.49,345.87,'2022-08-02 18:13:52','',''),(1283,'1','277','1',1,'Retail Sale Id 1293',3640.00,0.00,0.00,5.00,315.00,'2022-08-02 18:17:19','',''),(1284,'1','277','1',1,'Retail Sale Id 1294',4397.12,0.00,0.00,6.04,380.52,'2022-08-02 18:21:01','',''),(1285,'1','277','1',1,'Retail Sale Id 1295',33313.28,0.00,0.00,45.76,2882.88,'2022-08-02 18:28:57','',''),(1286,'1','277','1',1,'Retail Sale Id 1296',1499.68,0.00,0.00,2.06,129.78,'2022-08-02 18:37:41','',''),(1287,'1','277','1',1,'Retail Sale Id 1297',800.80,0.00,0.00,1.10,69.30,'2022-08-02 18:46:05','',''),(1288,'1','277','1',1,'Retail Sale Id 1299',3501.68,0.00,0.00,4.81,303.03,'2022-08-02 18:54:03','',''),(1289,'1','277','1',1,'Retail Sale Id 1300',1499.68,0.00,0.00,2.06,129.78,'2022-08-02 18:56:07','',''),(1290,'1','277','1',1,'Retail Sale Id 1301',5103.28,0.00,0.00,7.01,441.63,'2022-08-02 18:58:20','',''),(1291,'1','277','1',1,'Retail Sale Id 1302',2999.36,0.00,0.00,4.12,259.56,'2022-08-02 19:00:20','',''),(1292,'1','277','1',1,'Retail Sale Id 1303',2198.56,0.00,0.00,3.02,190.26,'2022-08-02 19:03:07','',''),(1293,'1','277','1',1,'Retail Sale Id 1304',1499.68,0.00,0.00,2.06,129.78,'2022-08-02 19:10:40','',''),(1294,'1','277','1',1,'Return of Retail Sale Id 1302',0.00,2999.36,4.12,0.00,-259.56,'2022-08-02 20:10:12','',''),(1295,'1','277','1',1,'Retail Sale Id 1305',2096.64,0.00,0.00,2.88,181.44,'2022-08-02 20:14:39','',''),(1296,'1','277','1',1,'Return of Retail Sale Id 1284',0.00,2999.36,4.12,0.00,-259.56,'2022-08-02 20:20:14','',''),(1297,'1','277','1',1,'Retail Sale Id 1307',1011.92,0.00,0.00,1.39,87.57,'2022-08-02 20:23:11','',''),(1298,'1','277','1',1,'Retail Sale Id 1308',793.52,0.00,0.00,1.09,68.67,'2022-08-02 20:25:30','',''),(1299,'1','277','1',1,'Retail Sale Id 1309',4499.04,0.00,0.00,6.18,389.34,'2022-08-03 07:05:59','',''),(1300,'1','277','1',1,'Retail Sale Id 1310',1499.68,0.00,0.00,2.06,129.78,'2022-08-03 07:14:34','',''),(1301,'1','277','1',1,'Retail Sale Id 1311',9100.00,0.00,0.00,12.50,787.50,'2022-08-03 07:16:35','',''),(1302,'1','277','1',1,'Retail Sale Id 1313',2999.36,0.00,0.00,4.12,259.56,'2022-08-03 07:39:47','',''),(1303,'1','277','1',1,'Retail Sale Id 1314',1499.68,0.00,0.00,2.06,129.78,'2022-08-03 07:56:35','',''),(1304,'1','277','1',1,'Retail Sale Id 1315',5001.36,0.00,0.00,6.87,432.81,'2022-08-03 08:03:30','',''),(1305,'1','277','1',1,'Retail Sale Id 1316',2002.00,0.00,0.00,2.75,173.25,'2022-08-03 08:05:09','',''),(1306,'1','277','1',1,'Retail Sale Id 1317',4397.12,0.00,0.00,6.04,380.52,'2022-08-03 08:10:54','',''),(1307,'1','277','1',1,'Retail Sale Id 1318',4499.04,0.00,0.00,6.18,389.34,'2022-08-03 08:14:36','',''),(1308,'1','277','1',1,'Retail Sale Id 1319',3996.72,0.00,0.00,5.49,345.87,'2022-08-03 08:16:22','',''),(1309,'1','277','1',1,'Retail Sale Id 1320',2999.36,0.00,0.00,4.12,259.56,'2022-08-03 08:17:28','',''),(1310,'1','277','1',1,'Retail Sale Id 1321',1703.52,0.00,0.00,2.34,147.42,'2022-08-03 08:18:14','',''),(1311,'1','277','1',1,'Retail Sale Id 1322',3698.24,0.00,0.00,5.08,320.04,'2022-08-03 08:28:26','',''),(1312,'1','277','1',1,'Retail Sale Id 1323',9100.00,0.00,0.00,12.50,787.50,'2022-08-03 08:31:59','',''),(1313,'1','277','1',1,'Retail Sale Id 1324',800.80,0.00,0.00,1.10,69.30,'2022-08-03 08:48:16','',''),(1314,'1','277','1',1,'Retail Sale Id 1325',9100.00,0.00,0.00,12.50,787.50,'2022-08-03 08:54:23','',''),(1315,'1','277','1',1,'Retail Sale Id 1326',9100.00,0.00,0.00,12.50,787.50,'2022-08-03 09:05:16','',''),(1316,'1','277','1',1,'Retail Sale Id 1327',2002.00,0.00,0.00,2.75,173.25,'2022-08-03 09:07:16','',''),(1317,'1','277','1',1,'Retail Sale Id 1328',5001.36,0.00,0.00,6.87,432.81,'2022-08-03 09:10:17','',''),(1318,'1','277','1',1,'Retail Sale Id 1329',2497.04,0.00,0.00,3.43,216.09,'2022-08-03 09:11:20','',''),(1319,'1','277','1',1,'Retail Sale Id 1330',3996.72,0.00,0.00,5.49,345.87,'2022-08-03 09:24:05','',''),(1320,'1','277','1',1,'Retail Sale Id 1331',4397.12,0.00,0.00,6.04,380.52,'2022-08-03 09:33:14','',''),(1321,'1','277','1',1,'Retail Sale Id 1332',3501.68,0.00,0.00,4.81,303.03,'2022-08-03 09:34:37','',''),(1322,'1','277','1',1,'Retail Sale Id 1333',2002.00,0.00,0.00,2.75,173.25,'2022-08-03 09:36:03','',''),(1323,'1','277','1',1,'Retail Sale Id 1334',5001.36,0.00,0.00,6.87,432.81,'2022-08-03 09:37:08','',''),(1324,'1','277','1',1,'Retail Sale Id 1335',2198.56,0.00,0.00,3.02,190.26,'2022-08-03 09:38:46','',''),(1325,'1','277','1',1,'Retail Sale Id 1336',9100.00,0.00,0.00,12.50,787.50,'2022-08-03 09:52:10','',''),(1326,'1','277','1',1,'Retail Sale Id 1337',997.36,0.00,0.00,1.37,86.31,'2022-08-03 10:03:41','',''),(1327,'1','277','1',1,'Retail Sale Id 1338',2999.36,0.00,0.00,4.12,259.56,'2022-08-03 10:11:14','',''),(1328,'1','277','1',1,'Retail Sale Id 1339',2002.00,0.00,0.00,2.75,173.25,'2022-08-03 10:14:33','',''),(1329,'1','277','1',1,'Retail Sale Id 1340',34750.00,0.00,0.00,50.00,1500.00,'2022-08-03 10:17:33','',''),(1330,'1','277','1',1,'Retail Sale Id 1341',4397.12,0.00,0.00,6.04,380.52,'2022-08-03 10:18:30','',''),(1331,'1','277','1',1,'Retail Sale Id 1342',749.84,0.00,0.00,1.03,64.89,'2022-08-03 10:19:29','',''),(1332,'1','277','1',1,'Retail Sale Id 1343',997.36,0.00,0.00,1.37,86.31,'2022-08-03 10:24:32','',''),(1333,'1','277','1',1,'Retail Sale Id 1344',728.00,0.00,0.00,1.00,63.00,'2022-08-03 10:34:07','',''),(1334,'1','277','1',1,'Retail Sale Id 1345',4397.12,0.00,0.00,6.04,380.52,'2022-08-03 10:35:05','',''),(1335,'1','277','1',1,'Retail Sale Id 1346',4368.00,0.00,0.00,6.00,378.00,'2022-08-03 10:41:20','',''),(1336,'1','277','1',1,'Retail Sale Id 1347',1499.68,0.00,0.00,2.06,129.78,'2022-08-03 10:43:45','',''),(1337,'1','277','1',1,'Retail Sale Id 1348',2999.36,0.00,0.00,4.12,259.56,'2022-08-03 10:46:43','',''),(1338,'1','277','1',1,'Retail Sale Id 1349',27800.00,0.00,0.00,40.00,1200.00,'2022-08-03 10:54:56','',''),(1339,'1','277','1',1,'Retail Sale Id 1350',5998.72,0.00,0.00,8.24,519.12,'2022-08-03 11:01:00','',''),(1340,'1','277','1',1,'Retail Sale Id 1351',997.36,0.00,0.00,1.37,86.31,'2022-08-03 11:08:26','',''),(1341,'1','277','1',1,'Retail Sale Id 1352',1747.20,0.00,0.00,2.40,151.20,'2022-08-03 11:32:33','',''),(1342,'1','277','1',1,'Retail Sale Id 1353',3647.28,0.00,0.00,5.01,315.63,'2022-08-03 11:44:27','',''),(1343,'1','277','1',1,'Retail Sale Id 1354',19998.16,0.00,0.00,27.47,1730.61,'2022-08-03 11:52:08','',''),(1344,'1','277','1',1,'Retail Sale Id 1355',1499.68,0.00,0.00,2.06,129.78,'2022-08-03 11:59:06','',''),(1345,'1','277','1',1,'Retail Sale Id 1356',2002.00,0.00,0.00,2.75,173.25,'2022-08-03 12:23:55','',''),(1346,'1','277','1',1,'Retail Sale Id 1357',749.84,0.00,0.00,1.03,64.89,'2022-08-03 12:26:16','',''),(1347,'1','277','1',1,'Retail Sale Id 1358',4397.12,0.00,0.00,6.04,380.52,'2022-08-03 12:50:16','',''),(1348,'1','277','1',1,'Retail Sale Id 1359',9100.00,0.00,0.00,12.50,787.50,'2022-08-03 12:58:17','',''),(1349,'1','277','1',1,'Retail Sale Id 1360',997.36,0.00,0.00,1.37,86.31,'2022-08-03 13:01:38','',''),(1350,'1','277','1',1,'Retail Sale Id 1361',3996.72,0.00,0.00,5.49,345.87,'2022-08-03 13:07:39','',''),(1351,'1','277','1',1,'Retail Sale Id 1362',2999.36,0.00,0.00,4.12,259.56,'2022-08-03 13:12:29','',''),(1352,'1','277','1',1,'Retail Sale Id 1363',5998.72,0.00,0.00,8.24,519.12,'2022-08-03 13:18:45','',''),(1353,'1','277','1',1,'Retail Sale Id 1364',3501.68,0.00,0.00,4.81,303.03,'2022-08-03 13:22:41','',''),(1354,'1','277','1',1,'Retail Sale Id 1365',278000.00,0.00,0.00,400.00,12000.00,'2022-08-03 13:54:54','',''),(1355,'1','277','1',1,'Retail Sale Id 1366',9100.00,0.00,0.00,12.50,787.50,'2022-08-03 14:06:22','',''),(1356,'1','277','1',1,'Retail Sale Id 1367',171665.00,0.00,0.00,247.00,7410.00,'2022-08-03 14:31:28','',''),(1357,'1','277','1',1,'Retail Sale Id 1368',2198.56,0.00,0.00,3.02,190.26,'2022-08-03 14:37:11','',''),(1358,'1','277','1',1,'Retail Sale Id 1369',2999.36,0.00,0.00,4.12,259.56,'2022-08-03 14:43:18','',''),(1359,'1','277','1',1,'Retail Sale Id 1370',1798.16,0.00,0.00,2.47,155.61,'2022-08-03 14:52:43','',''),(1360,'1','277','1',1,'Retail Sale Id 1371',4397.12,0.00,0.00,6.04,380.52,'2022-08-03 14:55:40','',''),(1361,'1','277','1',1,'Retail Sale Id 1372',502.32,0.00,0.00,0.69,43.47,'2022-08-03 15:06:08','',''),(1362,'1','277','1',1,'Retail Sale Id 1373',1499.68,0.00,0.00,2.06,129.78,'2022-08-03 15:21:08','',''),(1363,'1','277','1',1,'Retail Sale Id 1374',749.84,0.00,0.00,1.03,64.89,'2022-08-03 15:32:34','',''),(1364,'1','277','1',1,'Retail Sale Id 1376',3698.24,0.00,0.00,5.08,320.04,'2022-08-03 15:47:46','',''),(1365,'1','277','1',1,'Retail Sale Id 1377',4397.12,0.00,0.00,6.04,380.52,'2022-08-03 15:57:53','',''),(1366,'1','277','1',1,'Retail Sale Id 1378',2002.00,0.00,0.00,2.75,173.25,'2022-08-03 16:17:11','',''),(1367,'1','277','1',1,'Retail Sale Id 1379',1499.68,0.00,0.00,2.06,129.78,'2022-08-03 16:23:49','',''),(1368,'1','277','1',1,'Retail Sale Id 1380',1499.68,0.00,0.00,2.06,129.78,'2022-08-03 16:37:53','',''),(1369,'1','277','1',1,'Retail Sale Id 1381',3800.16,0.00,0.00,5.22,328.86,'2022-08-03 16:40:11','',''),(1370,'1','277','1',1,'Retail Sale Id 1382',1426.88,0.00,0.00,1.96,123.48,'2022-08-03 16:44:50','',''),(1371,'1','277','1',1,'Retail Sale Id 1383',9100.00,0.00,0.00,12.50,787.50,'2022-08-03 16:46:35','',''),(1372,'1','277','1',1,'Retail Sale Id 1384',4397.12,0.00,0.00,6.04,380.52,'2022-08-03 16:52:15','',''),(1373,'1','277','1',1,'Retail Sale Id 1385',2999.36,0.00,0.00,4.12,259.56,'2022-08-03 16:53:13','',''),(1374,'1','277','1',1,'Retail Sale Id 1386',2802.80,0.00,0.00,3.85,242.55,'2022-08-03 16:54:06','',''),(1375,'1','277','1',1,'Retail Sale Id 1387',9100.00,0.00,0.00,12.50,787.50,'2022-08-03 17:03:01','',''),(1376,'1','277','1',1,'Retail Sale Id 1388',800.80,0.00,0.00,1.10,69.30,'2022-08-03 17:04:57','',''),(1377,'1','277','1',1,'Retail Sale Id 1390',9100.00,0.00,0.00,12.50,787.50,'2022-08-03 17:11:16','',''),(1378,'1','277','1',1,'Retail Sale Id 1391',2002.00,0.00,0.00,2.75,173.25,'2022-08-03 17:12:02','',''),(1379,'1','277','1',1,'Retail Sale Id 1392',4397.12,0.00,0.00,6.04,380.52,'2022-08-03 17:14:52','',''),(1380,'1','277','1',1,'Retail Sale Id 1393',5496.40,0.00,0.00,7.55,475.65,'2022-08-03 17:16:28','',''),(1381,'1','277','1',1,'Retail Sale Id 1394',9100.00,0.00,0.00,12.50,787.50,'2022-08-03 17:27:37','',''),(1382,'1','277','1',1,'Retail Sale Id 1395',5103.28,0.00,0.00,7.01,441.63,'2022-08-03 17:31:47','',''),(1383,'1','277','1',1,'Retail Sale Id 1396',1499.68,0.00,0.00,2.06,129.78,'2022-08-03 17:34:14','',''),(1384,'1','277','1',1,'Retail Sale Id 1397',9100.00,0.00,0.00,12.50,787.50,'2022-08-03 17:37:25','',''),(1385,'1','277','1',1,'Retail Sale Id 1399',2999.36,0.00,0.00,4.12,259.56,'2022-08-03 17:40:27','',''),(1386,'1','277','1',1,'Retail Sale Id 1400',13336.96,0.00,0.00,18.32,1154.16,'2022-08-03 17:43:34','',''),(1387,'1','277','1',1,'Retail Sale Id 1401',1499.68,0.00,0.00,2.06,129.78,'2022-08-03 17:44:46','',''),(1388,'1','277','1',1,'Retail Sale Id 1402',3501.68,0.00,0.00,4.81,303.03,'2022-08-03 17:49:29','',''),(1389,'1','277','1',1,'Retail Sale Id 1403',3501.68,0.00,0.00,4.81,303.03,'2022-08-03 17:57:48','',''),(1390,'1','277','1',1,'Retail Sale Id 1404',800.80,0.00,0.00,1.10,69.30,'2022-08-03 18:07:22','',''),(1391,'1','277','1',1,'Retail Sale Id 1405',997.36,0.00,0.00,1.37,86.31,'2022-08-03 18:15:43','',''),(1392,'1','277','1',1,'Retail Sale Id 1406',1499.68,0.00,0.00,2.06,129.78,'2022-08-03 18:16:59','',''),(1393,'1','277','1',1,'Retail Sale Id 1407',2002.00,0.00,0.00,2.75,173.25,'2022-08-03 18:19:44','',''),(1394,'1','277','1',1,'Retail Sale Id 1408',3640.00,0.00,0.00,5.00,315.00,'2022-08-03 18:27:05','',''),(1395,'1','277','1',1,'Retail Sale Id 1409',997.36,0.00,0.00,1.37,86.31,'2022-08-03 18:27:50','',''),(1396,'1','277','1',1,'Retail Sale Id 1410',11000.08,0.00,0.00,15.11,951.93,'2022-08-03 18:29:53','',''),(1397,'1','277','1',1,'Retail Sale Id 1411',3996.72,0.00,0.00,5.49,345.87,'2022-08-03 18:32:18','',''),(1398,'1','277','1',1,'Retail Sale Id 1412',5103.28,0.00,0.00,7.01,441.63,'2022-08-03 18:36:49','',''),(1399,'1','277','1',1,'Retail Sale Id 1413',38225.00,0.00,0.00,55.00,1650.00,'2022-08-03 18:57:23','',''),(1400,'1','277','1',1,'Retail Sale Id 1414',749.84,0.00,0.00,1.03,64.89,'2022-08-03 18:58:08','',''),(1401,'1','277','1',1,'Retail Sale Id 1415',2999.36,0.00,0.00,4.12,259.56,'2022-08-03 19:11:35','',''),(1402,'1','277','1',1,'Retail Sale Id 1416',1499.68,0.00,0.00,2.06,129.78,'2022-08-03 19:20:56','',''),(1403,'1','277','1',1,'Retail Sale Id 1417',2395.12,0.00,0.00,3.29,207.27,'2022-08-03 20:02:14','',''),(1404,'1','277','1',1,'Retail Sale Id 1418',2999.36,0.00,0.00,4.12,259.56,'2022-08-04 06:36:07','',''),(1405,'1','277','1',1,'Retail Sale Id 1419',997.36,0.00,0.00,1.37,86.31,'2022-08-04 07:23:11','',''),(1406,'1','277','1',1,'Retail Sale Id 1420',34750.00,0.00,0.00,50.00,1500.00,'2022-08-04 07:25:29','',''),(1407,'1','277','1',1,'Retail Sale Id 1421',1499.68,0.00,0.00,2.06,129.78,'2022-08-04 07:42:39','',''),(1408,'1','277','1',1,'Retail Sale Id 1422',2002.00,0.00,0.00,2.75,173.25,'2022-08-04 07:47:06','',''),(1409,'1','277','1',1,'Retail Sale Id 1423',2002.00,0.00,0.00,2.75,173.25,'2022-08-04 07:49:12','',''),(1410,'1','277','1',1,'Retail Sale Id 1424',5001.36,0.00,0.00,6.87,432.81,'2022-08-04 08:11:54','',''),(1411,'1','277','1',1,'Retail Sale Id 1425',2198.56,0.00,0.00,3.02,190.26,'2022-08-04 08:21:27','',''),(1412,'1','277','1',1,'Retail Sale Id 1426',3996.72,0.00,0.00,5.49,345.87,'2022-08-04 08:35:02','',''),(1413,'1','277','1',1,'Retail Sale Id 1427',1499.68,0.00,0.00,2.06,129.78,'2022-08-04 08:46:05','',''),(1414,'1','277','1',1,'Retail Sale Id 1428',9100.00,0.00,0.00,12.50,787.50,'2022-08-04 08:52:10','',''),(1415,'1','277','1',1,'Retail Sale Id 1429',1499.68,0.00,0.00,2.06,129.78,'2022-08-04 09:02:29','',''),(1416,'1','277','1',1,'Retail Sale Id 1430',20850.00,0.00,0.00,30.00,900.00,'2022-08-04 09:54:25','',''),(1417,'1','277','1',1,'Retail Sale Id 1431',3501.68,0.00,0.00,4.81,303.03,'2022-08-04 10:45:02','',''),(1418,'1','277','1',1,'Retail Sale Id 1432',34750.00,0.00,0.00,50.00,1500.00,'2022-08-04 10:58:16','',''),(1419,'1','277','1',1,'Retail Sale Id 1433',3996.72,0.00,0.00,5.49,345.87,'2022-08-04 11:10:04','',''),(1420,'1','277','1',1,'Retail Sale Id 1434',3996.72,0.00,0.00,5.49,345.87,'2022-08-04 11:25:17','',''),(1421,'1','277','1',1,'Retail Sale Id 1435',2002.00,0.00,0.00,2.75,173.25,'2022-08-04 11:32:00','',''),(1422,'1','277','1',1,'Retail Sale Id 1436',13489.84,0.00,0.00,18.53,1167.39,'2022-08-04 11:33:26','',''),(1423,'1','277','1',1,'Retail Sale Id 1437',19102.72,0.00,0.00,26.24,1653.12,'2022-08-04 11:34:30','',''),(1424,'1','277','1',1,'Retail Sale Id 1438',2198.56,0.00,0.00,3.02,190.26,'2022-08-04 11:36:41','',''),(1425,'1','277','1',1,'Retail Sale Id 1439',1303.12,0.00,0.00,1.79,112.77,'2022-08-04 11:39:12','',''),(1426,'1','277','1',1,'Retail Sale Id 1440',4397.12,0.00,0.00,6.04,380.52,'2022-08-04 11:40:04','',''),(1427,'1','277','1',1,'Retail Sale Id 1441',69500.00,0.00,0.00,100.00,3000.00,'2022-08-04 11:47:40','',''),(1428,'1','277','1',1,'Retail Sale Id 1442',8998.08,0.00,0.00,12.36,778.68,'2022-08-04 11:49:46','',''),(1429,'1','277','1',1,'Retail Sale Id 1443',2919.28,0.00,0.00,4.01,252.63,'2022-08-04 11:54:55','',''),(1430,'1','277','1',1,'Retail Sale Id 1444',2497.04,0.00,0.00,3.43,216.09,'2022-08-04 12:01:16','',''),(1431,'1','277','1',1,'Retail Sale Id 1445',2198.56,0.00,0.00,3.02,190.26,'2022-08-04 12:14:57','',''),(1432,'1','277','1',1,'Retail Sale Id 1446',3996.72,0.00,0.00,5.49,345.87,'2022-08-04 12:28:47','',''),(1433,'1','277','1',1,'Retail Sale Id 1447',2999.36,0.00,0.00,4.12,259.56,'2022-08-04 12:32:10','',''),(1434,'1','277','1',1,'Retail Sale Id 1448',23798.32,0.00,0.00,32.69,2059.47,'2022-08-04 14:14:23','',''),(1435,'1','277','1',1,'Retail Sale Id 1449',104250.00,0.00,0.00,150.00,4500.00,'2022-08-04 14:15:47','',''),(1436,'1','277','1',1,'Retail Sale Id 1450',1499.68,0.00,0.00,2.06,129.78,'2022-08-04 14:18:43','',''),(1437,'1','277','1',1,'Retail Sale Id 1451',2999.36,0.00,0.00,4.12,259.56,'2022-08-04 14:43:00','',''),(1438,'1','277','1',1,'Retail Sale Id 1452',9100.00,0.00,0.00,12.50,787.50,'2022-08-04 14:54:22','',''),(1439,'1','277','1',1,'Retail Sale Id 1453',502.32,0.00,0.00,0.69,43.47,'2022-08-04 15:02:24','',''),(1440,'1','277','1',1,'Retail Sale Id 1454',997.36,0.00,0.00,1.37,86.31,'2022-08-04 15:09:00','',''),(1441,'1','277','1',1,'Retail Sale Id 1455',1499.68,0.00,0.00,2.06,129.78,'2022-08-04 15:38:21','',''),(1442,'1','277','1',1,'Retail Sale Id 1456',2300.48,0.00,0.00,3.16,199.08,'2022-08-04 16:05:36','',''),(1443,'1','277','1',1,'Retail Sale Id 1459',2198.56,0.00,0.00,3.02,190.26,'2022-08-04 16:10:41','',''),(1444,'1','277','1',1,'Retail Sale Id 1460',1499.68,0.00,0.00,2.06,129.78,'2022-08-04 16:14:16','',''),(1445,'1','277',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,68049.45,102.33,0.00,0.00,'2022-08-04 19:55:28','',''),(1446,'1','277',NULL,1,'Reception corrector for bridging 4',0.00,0.00,0.00,102.33,0.00,'2022-08-04 20:27:09','',''),(1447,'1','277','1',1,'Received from bridging 4',0.00,0.00,102.33,0.00,0.00,'2022-08-04 20:27:09','',''),(1448,'1','277','1',1,'Retail Sale Id 1461',74496.24,0.00,0.00,102.33,6446.79,'2022-08-04 20:29:08','',''),(1449,'1','277',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,1350000.00,2000.00,0.00,0.00,'2022-08-04 21:57:58','',''),(1450,'1','277','1',1,'Retail Sale Id 1463',240.24,0.00,0.00,0.33,17.49,'2022-08-04 21:58:46','',''),(1451,'1','277',NULL,1,'Reception corrector for bridging 5',0.00,0.00,0.00,2000.00,0.00,'2022-08-04 21:59:42','',''),(1452,'1','277','1',1,'Received from bridging 5',0.00,0.00,2000.00,0.00,0.00,'2022-08-04 21:59:42','',''),(1453,'1','277','1',1,'Retail Sale Id 1464',2002.00,0.00,0.00,2.75,145.75,'2022-08-05 06:45:32','',''),(1454,'1','277','1',1,'Retail Sale Id 1465',1499.68,0.00,0.00,2.06,109.18,'2022-08-05 07:11:30','',''),(1455,'1','277','1',1,'Retail Sale Id 1466',4499.04,0.00,0.00,6.18,327.54,'2022-08-05 07:24:28','',''),(1456,'1','277','1',1,'Retail Sale Id 1467',9100.00,0.00,0.00,12.50,662.50,'2022-08-05 07:26:01','',''),(1457,'1','277','1',1,'Retail Sale Id 1468',1499.68,0.00,0.00,2.06,109.18,'2022-08-05 07:28:10','',''),(1458,'1','277','1',1,'Retail Sale Id 1469',2147.60,0.00,0.00,2.95,156.35,'2022-08-05 07:43:09','',''),(1459,'1','277','1',1,'Retail Sale Id 1470',1499.68,0.00,0.00,2.06,109.18,'2022-08-05 07:43:50','',''),(1460,'1','277','1',1,'Retail Sale Id 1471',4397.12,0.00,0.00,6.04,320.12,'2022-08-05 07:44:47','',''),(1461,'1','277','1',1,'Retail Sale Id 1472',2198.56,0.00,0.00,3.02,160.06,'2022-08-05 08:10:35','',''),(1462,'1','277','1',1,'Retail Sale Id 1473',1499.68,0.00,0.00,2.06,109.18,'2022-08-05 08:11:20','',''),(1463,'1','277','1',1,'Retail Sale Id 1474',2999.36,0.00,0.00,4.12,218.36,'2022-08-05 08:18:30','',''),(1464,'1','277','1',1,'Retail Sale Id 1475',2002.00,0.00,0.00,2.75,145.75,'2022-08-05 08:21:46','',''),(1465,'1','277','1',1,'Retail Sale Id 1476',2198.56,0.00,0.00,3.02,160.06,'2022-08-05 08:25:23','',''),(1466,'1','277','1',1,'Retail Sale Id 1477',3698.24,0.00,0.00,5.08,269.24,'2022-08-05 08:29:01','',''),(1467,'1','277','1',1,'Retail Sale Id 1478',3996.72,0.00,0.00,5.49,290.97,'2022-08-05 08:34:48','',''),(1468,'1','277','1',1,'Retail Sale Id 1480',3640.00,0.00,0.00,5.00,265.00,'2022-08-05 08:47:47','',''),(1469,'1','277','1',1,'Retail Sale Id 1481',3698.24,0.00,0.00,5.08,269.24,'2022-08-05 09:03:56','',''),(1470,'1','277','1',1,'Retail Sale Id 1482',2198.56,0.00,0.00,3.02,160.06,'2022-08-05 09:06:52','',''),(1471,'1','277','1',1,'Retail Sale Id 1483',9100.00,0.00,0.00,12.50,662.50,'2022-08-05 09:17:54','',''),(1472,'1','277','1',1,'Retail Sale Id 1484',2002.00,0.00,0.00,2.75,145.75,'2022-08-05 09:29:58','',''),(1473,'1','277','1',1,'Retail Sale Id 1485',698.88,0.00,0.00,0.96,50.88,'2022-08-05 09:55:05','',''),(1474,'1','277','1',1,'Retail Sale Id 1486',2198.56,0.00,0.00,3.02,160.06,'2022-08-05 09:55:47','',''),(1475,'1','277','1',1,'Retail Sale Id 1487',2002.00,0.00,0.00,2.75,145.75,'2022-08-05 09:59:01','',''),(1476,'1','277','1',1,'Retail Sale Id 1488',2002.00,0.00,0.00,2.75,145.75,'2022-08-05 10:02:22','',''),(1477,'1','277','1',1,'Retail Sale Id 1489',2999.36,0.00,0.00,4.12,218.36,'2022-08-05 10:03:09','',''),(1478,'1','277','1',1,'Retail Sale Id 1490',2002.00,0.00,0.00,2.75,145.75,'2022-08-05 10:10:30','',''),(1479,'1','277','1',1,'Retail Sale Id 1491',9100.00,0.00,0.00,12.50,662.50,'2022-08-05 10:27:48','',''),(1480,'1','277','1',1,'Retail Sale Id 1492',3603.60,0.00,0.00,4.95,262.35,'2022-08-05 10:55:11','',''),(1481,'1','277','1',1,'Retail Sale Id 1493',997.36,0.00,0.00,1.37,72.61,'2022-08-05 11:08:48','',''),(1482,'1','277','1',1,'Retail Sale Id 1494',2198.56,0.00,0.00,3.02,160.06,'2022-08-05 11:17:28','',''),(1483,'1','277','1',1,'Retail Sale Id 1495',9100.00,0.00,0.00,12.50,662.50,'2022-08-05 11:34:19','',''),(1484,'1','277','1',1,'Retail Sale Id 1496',2002.00,0.00,0.00,2.75,145.75,'2022-08-05 11:48:48','',''),(1485,'1','277','1',1,'Retail Sale Id 1497',6501.04,0.00,0.00,8.93,473.29,'2022-08-05 11:58:55','',''),(1486,'1','277','1',1,'Retail Sale Id 1498',800.80,0.00,0.00,1.10,58.30,'2022-08-05 12:00:51','',''),(1487,'1','277','1',1,'Retail Sale Id 1499',3698.24,0.00,0.00,5.08,269.24,'2022-08-05 12:18:15','',''),(1488,'1','277','1',1,'Retail Sale Id 1500',2919.28,0.00,0.00,4.01,212.53,'2022-08-05 13:32:28','',''),(1489,'1','277','1',1,'Retail Sale Id 1501',2999.36,0.00,0.00,4.12,218.36,'2022-08-05 13:37:54','',''),(1490,'1','277','1',1,'Return of Retail Sale Id 1466',0.00,4499.04,6.18,0.00,-327.54,'2022-08-05 13:40:37','',''),(1491,'1','277','1',1,'Retail Sale Id 1502',9100.00,0.00,0.00,12.50,662.50,'2022-08-05 13:49:20','',''),(1492,'1','277','1',1,'Retail Sale Id 1503',2198.56,0.00,0.00,3.02,160.06,'2022-08-05 14:13:03','',''),(1493,'1','277','1',1,'Retail Sale Id 1504',2198.56,0.00,0.00,3.02,160.06,'2022-08-05 14:14:19','',''),(1494,'1','277','1',1,'Retail Sale Id 1504',2300.48,0.00,0.00,3.16,167.48,'2022-08-05 14:14:19','',''),(1495,'1','277','1',1,'Retail Sale Id 1505',2999.36,0.00,0.00,4.12,218.36,'2022-08-05 14:29:10','',''),(1496,'1','277','1',1,'Retail Sale Id 1506',1499.68,0.00,0.00,2.06,109.18,'2022-08-05 14:36:37','',''),(1497,'1','277','1',1,'Retail Sale Id 1507',3640.00,0.00,0.00,5.00,265.00,'2022-08-05 14:39:49','',''),(1498,'1','277','1',1,'Retail Sale Id 1508',800.80,0.00,0.00,1.10,58.30,'2022-08-05 14:54:30','',''),(1499,'1','277','1',1,'Retail Sale Id 1509',4397.12,0.00,0.00,6.04,320.12,'2022-08-05 14:55:26','',''),(1500,'1','277','1',1,'Retail Sale Id 1510',4397.12,0.00,0.00,6.04,320.12,'2022-08-05 15:03:39','',''),(1501,'1','277','1',1,'Retail Sale Id 1511',997.36,0.00,0.00,1.37,72.61,'2022-08-05 15:04:44','',''),(1502,'1','277','1',1,'Retail Sale Id 1512',2198.56,0.00,0.00,3.02,160.06,'2022-08-05 15:15:36','',''),(1503,'1','277','1',1,'Retail Sale Id 1513',4397.12,0.00,0.00,6.04,320.12,'2022-08-05 15:21:02','',''),(1504,'1','277','1',1,'Retail Sale Id 1515',3698.24,0.00,0.00,5.08,269.24,'2022-08-05 15:24:44','',''),(1505,'1','277','1',1,'Retail Sale Id 1516',1499.68,0.00,0.00,2.06,109.18,'2022-08-05 15:27:14','',''),(1506,'1','277','1',1,'Retail Sale Id 1517',2497.04,0.00,0.00,3.43,181.79,'2022-08-05 15:35:52','',''),(1507,'1','277','1',1,'Retail Sale Id 1518',21497.84,0.00,0.00,29.53,1565.09,'2022-08-05 15:36:59','',''),(1508,'1','277','1',1,'Retail Sale Id 1519',9100.00,0.00,0.00,12.50,662.50,'2022-08-05 15:44:26','',''),(1509,'1','277','1',1,'Retail Sale Id 1520',34750.00,0.00,0.00,50.00,1000.00,'2022-08-05 15:56:57','',''),(1510,'1','277','1',1,'Retail Sale Id 1521',34750.00,0.00,0.00,50.00,1000.00,'2022-08-05 16:01:30','',''),(1511,'1','277','1',1,'Retail Sale Id 1522',5197.92,0.00,0.00,7.14,378.42,'2022-08-05 16:08:57','',''),(1512,'1','277','1',1,'Retail Sale Id 1523',2198.56,0.00,0.00,3.02,160.06,'2022-08-05 16:14:13','',''),(1513,'1','277','1',1,'Retail Sale Id 1524',9100.00,0.00,0.00,12.50,662.50,'2022-08-05 16:15:17','',''),(1514,'1','277','1',1,'Retail Sale Id 1525',7280.00,0.00,0.00,10.00,530.00,'2022-08-05 16:22:09','',''),(1515,'1','277','1',1,'Retail Sale Id 1526',5896.80,0.00,0.00,8.10,429.30,'2022-08-05 16:24:01','',''),(1516,'1','277','1',1,'Retail Sale Id 1527',2002.00,0.00,0.00,2.75,145.75,'2022-08-05 16:24:49','',''),(1517,'1','277',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,2166750.00,3210.00,0.00,0.00,'2022-08-05 16:25:15','',''),(1518,'1','277','1',1,'Retail Sale Id 1528',4397.12,0.00,0.00,6.04,320.12,'2022-08-05 16:26:05','',''),(1519,'1','277',NULL,1,'Reception corrector for bridging 6',0.00,0.00,0.00,3210.00,0.00,'2022-08-05 16:26:10','',''),(1520,'1','277','1',1,'Received from bridging 6',0.00,0.00,3210.00,0.00,0.00,'2022-08-05 16:26:10','',''),(1521,'1','277','1',1,'Retail Sale Id 1529',997.36,0.00,0.00,1.37,72.61,'2022-08-05 16:36:42','',''),(1522,'1','277','1',1,'Retail Sale Id 1530',2999.36,0.00,0.00,4.12,218.36,'2022-08-05 16:39:48','',''),(1523,'1','277','1',1,'Retail Sale Id 1531',1499.68,0.00,0.00,2.06,109.18,'2022-08-05 16:41:52','',''),(1524,'1','277','1',1,'Retail Sale Id 1532',3640.00,0.00,0.00,5.00,265.00,'2022-08-05 16:56:14','',''),(1525,'1','277','1',1,'Retail Sale Id 1533',2191.28,0.00,0.00,3.01,159.53,'2022-08-05 17:04:02','',''),(1526,'1','277','1',1,'Retail Sale Id 1534',4397.12,0.00,0.00,6.04,320.12,'2022-08-05 17:10:59','',''),(1527,'1','277','1',1,'Retail Sale Id 1535',7301.84,0.00,0.00,10.03,531.59,'2022-08-05 17:27:20','',''),(1528,'1','277','1',1,'Retail Sale Id 1536',9100.00,0.00,0.00,12.50,662.50,'2022-08-05 17:34:55','',''),(1529,'1','277','1',1,'Retail Sale Id 1537',5831.28,0.00,0.00,8.01,424.53,'2022-08-05 17:37:51','',''),(1530,'1','277','1',1,'Retail Sale Id 1538',1499.68,0.00,0.00,2.06,109.18,'2022-08-05 17:48:47','',''),(1531,'1','277','1',1,'Retail Sale Id 1539',3640.00,0.00,0.00,5.00,265.00,'2022-08-05 17:52:11','',''),(1532,'1','277','1',1,'Retail Sale Id 1540',9100.00,0.00,0.00,12.50,662.50,'2022-08-05 17:58:58','',''),(1533,'1','277','1',1,'Retail Sale Id 1541',2198.56,0.00,0.00,3.02,160.06,'2022-08-05 18:04:46','',''),(1534,'1','277','1',1,'Retail Sale Id 1542',2198.56,0.00,0.00,3.02,160.06,'2022-08-05 18:10:35','',''),(1535,'1','277','1',1,'Retail Sale Id 1543',1456.00,0.00,0.00,2.00,106.00,'2022-08-05 18:12:48','',''),(1536,'1','277','1',1,'Retail Sale Id 1544',2198.56,0.00,0.00,3.02,160.06,'2022-08-05 18:13:35','',''),(1537,'1','277','1',1,'Retail Sale Id 1545',997.36,0.00,0.00,1.37,72.61,'2022-08-05 18:14:22','',''),(1538,'1','277','1',1,'Retail Sale Id 1546',997.36,0.00,0.00,1.37,72.61,'2022-08-05 18:15:07','',''),(1539,'1','277','1',1,'Retail Sale Id 1547',7280.00,0.00,0.00,10.00,530.00,'2022-08-05 18:27:29','',''),(1540,'1','277','1',1,'Retail Sale Id 1548',749.84,0.00,0.00,1.03,54.59,'2022-08-05 18:41:25','',''),(1541,'1','277','1',1,'Retail Sale Id 1549',2198.56,0.00,0.00,3.02,160.06,'2022-08-05 18:53:55','',''),(1542,'1','277','1',1,'Retail Sale Id 1550',3720.08,0.00,0.00,5.11,270.83,'2022-08-05 18:55:14','',''),(1543,'1','277','1',1,'Retail Sale Id 1551',2191.28,0.00,0.00,3.01,159.53,'2022-08-05 18:58:18','',''),(1544,'1','277','1',1,'Retail Sale Id 1552',10920.00,0.00,0.00,15.00,795.00,'2022-08-05 19:02:45','',''),(1545,'1','277','1',1,'Retail Sale Id 1553',3640.00,0.00,0.00,5.00,265.00,'2022-08-05 19:07:50','',''),(1546,'1','277','1',1,'Retail Sale Id 1556',7003.36,0.00,0.00,9.62,509.86,'2022-08-05 20:34:19','',''),(1547,'1','277','1',1,'Retail Sale Id 1557',2999.36,0.00,0.00,4.12,218.36,'2022-08-06 06:46:51','',''),(1548,'1','277','1',1,'Retail Sale Id 1558',9100.00,0.00,0.00,12.50,662.50,'2022-08-06 07:06:46','',''),(1549,'1','277','1',1,'Retail Sale Id 1559',749.84,0.00,0.00,1.03,54.59,'2022-08-06 07:14:37','',''),(1550,'1','277','1',1,'Retail Sale Id 1560',749.84,0.00,0.00,1.03,54.59,'2022-08-06 07:38:53','',''),(1551,'1','277','1',1,'Retail Sale Id 1561',9100.00,0.00,0.00,12.50,662.50,'2022-08-06 07:41:39','',''),(1552,'1','277','1',1,'Retail Sale Id 1562',2198.56,0.00,0.00,3.02,160.06,'2022-08-06 07:49:04','',''),(1553,'1','277','1',1,'Retail Sale Id 1563',4397.12,0.00,0.00,6.04,320.12,'2022-08-06 07:50:15','',''),(1554,'1','277','1',1,'Retail Sale Id 1564',1397.76,0.00,0.00,1.92,101.76,'2022-08-06 07:53:06','',''),(1555,'1','277','1',1,'Retail Sale Id 1565',3996.72,0.00,0.00,5.49,290.97,'2022-08-06 07:55:14','',''),(1556,'1','277','1',1,'Retail Sale Id 1566',502.32,0.00,0.00,0.69,36.57,'2022-08-06 07:57:17','',''),(1557,'1','277','1',1,'Retail Sale Id 1567',3996.72,0.00,0.00,5.49,290.97,'2022-08-06 08:08:25','',''),(1558,'1','277','1',1,'Retail Sale Id 1568',2096.64,0.00,0.00,2.88,152.64,'2022-08-06 08:19:37','',''),(1559,'1','277','1',1,'Retail Sale Id 1569',2198.56,0.00,0.00,3.02,160.06,'2022-08-06 08:23:54','',''),(1560,'1','277','1',1,'Retail Sale Id 1570',22240.00,0.00,0.00,32.00,640.00,'2022-08-06 08:41:21','',''),(1561,'1','277','1',1,'Retail Sale Id 1571',800.80,0.00,0.00,1.10,58.30,'2022-08-06 08:49:17','',''),(1562,'1','277','1',1,'Retail Sale Id 1572',9100.00,0.00,0.00,12.50,662.50,'2022-08-06 08:53:51','',''),(1563,'1','277','1',1,'Retail Sale Id 1573',997.36,0.00,0.00,1.37,72.61,'2022-08-06 08:55:03','',''),(1564,'1','277','1',1,'Retail Sale Id 1574',2497.04,0.00,0.00,3.43,181.79,'2022-08-06 08:59:35','',''),(1565,'1','277','1',1,'Retail Sale Id 1575',728.00,0.00,0.00,1.00,53.00,'2022-08-06 09:07:56','',''),(1566,'1','277','1',1,'Retail Sale Id 1575',728.00,0.00,0.00,1.00,53.00,'2022-08-06 09:07:56','',''),(1567,'1','277','1',1,'Retail Sale Id 1576',9100.00,0.00,0.00,12.50,662.50,'2022-08-06 09:08:57','',''),(1568,'1','277','1',1,'Retail Sale Id 1577',1499.68,0.00,0.00,2.06,109.18,'2022-08-06 09:15:04','',''),(1569,'1','277','1',1,'Retail Sale Id 1578',997.36,0.00,0.00,1.37,72.61,'2022-08-06 09:15:47','',''),(1570,'1','277','1',1,'Retail Sale Id 1579',3640.00,0.00,0.00,5.00,265.00,'2022-08-06 09:20:51','',''),(1571,'1','277','1',1,'Retail Sale Id 1580',3640.00,0.00,0.00,5.00,265.00,'2022-08-06 09:35:28','',''),(1572,'1','277','1',1,'Retail Sale Id 1580',9100.00,0.00,0.00,12.50,662.50,'2022-08-06 09:35:28','',''),(1573,'1','277','1',1,'Retail Sale Id 1581',1499.68,0.00,0.00,2.06,109.18,'2022-08-06 09:37:41','',''),(1574,'1','277','1',1,'Retail Sale Id 1582',749.84,0.00,0.00,1.03,54.59,'2022-08-06 09:41:41','',''),(1575,'1','277','1',1,'Retail Sale Id 1583',749.84,0.00,0.00,1.03,54.59,'2022-08-06 09:45:11','',''),(1576,'1','277','1',1,'Retail Sale Id 1584',2999.36,0.00,0.00,4.12,218.36,'2022-08-06 09:49:56','',''),(1577,'1','277','1',1,'Retail Sale Id 1585',3501.68,0.00,0.00,4.81,254.93,'2022-08-06 09:52:39','',''),(1578,'1','277','1',1,'Retail Sale Id 1586',3647.28,0.00,0.00,5.01,265.53,'2022-08-06 10:09:11','',''),(1579,'1','277','1',1,'Retail Sale Id 1587',4302.48,0.00,0.00,5.91,313.23,'2022-08-06 10:16:16','',''),(1580,'1','277','1',1,'Retail Sale Id 1588',502.32,0.00,0.00,0.69,36.57,'2022-08-06 10:17:10','',''),(1581,'1','277','1',1,'Retail Sale Id 1589',9100.00,0.00,0.00,12.50,662.50,'2022-08-06 10:32:31','',''),(1582,'1','277','1',1,'Retail Sale Id 1590',4397.12,0.00,0.00,6.04,320.12,'2022-08-06 10:38:44','',''),(1583,'1','277','1',1,'Retail Sale Id 1591',7280.00,0.00,0.00,10.00,530.00,'2022-08-06 10:41:14','',''),(1584,'1','277','1',1,'Retail Sale Id 1592',2002.00,0.00,0.00,2.75,145.75,'2022-08-06 10:45:09','',''),(1585,'1','277','1',1,'Retail Sale Id 1593',69500.00,0.00,0.00,100.00,2000.00,'2022-08-06 10:55:43','',''),(1586,'1','277','1',1,'Retail Sale Id 1594',1499.68,0.00,0.00,2.06,109.18,'2022-08-06 11:03:26','',''),(1587,'1','277','1',1,'Retail Sale Id 1595',3640.00,0.00,0.00,5.00,265.00,'2022-08-06 11:07:02','',''),(1588,'1','277','1',1,'Retail Sale Id 1596',1499.68,0.00,0.00,2.06,109.18,'2022-08-06 11:12:12','',''),(1589,'1','277','1',1,'Retail Sale Id 1597',2198.56,0.00,0.00,3.02,160.06,'2022-08-06 11:16:08','',''),(1590,'1','277','1',1,'Retail Sale Id 1598',1499.68,0.00,0.00,2.06,109.18,'2022-08-06 11:21:49','',''),(1591,'1','277','1',1,'Retail Sale Id 1599',2198.56,0.00,0.00,3.02,160.06,'2022-08-06 11:31:03','',''),(1592,'1','277','1',1,'Retail Sale Id 1600',2198.56,0.00,0.00,3.02,160.06,'2022-08-06 11:34:02','',''),(1593,'1','277','1',1,'Retail Sale Id 1601',2999.36,0.00,0.00,4.12,218.36,'2022-08-06 11:42:06','',''),(1594,'1','277','1',1,'Retail Sale Id 1602',40040.00,0.00,0.00,55.00,2915.00,'2022-08-06 11:48:13','',''),(1595,'1','277','1',1,'Retail Sale Id 1603',4302.48,0.00,0.00,5.91,313.23,'2022-08-06 11:49:49','',''),(1596,'1','277','1',1,'Retail Sale Id 1604',14996.80,0.00,0.00,20.60,1091.80,'2022-08-06 11:52:33','',''),(1597,'1','277','1',1,'Retail Sale Id 1605',997.36,0.00,0.00,1.37,72.61,'2022-08-06 12:01:10','',''),(1598,'1','277','1',1,'Retail Sale Id 1606',2497.04,0.00,0.00,3.43,181.79,'2022-08-06 12:04:21','',''),(1599,'1','277','1',1,'Retail Sale Id 1608',2897.44,0.00,0.00,3.98,210.94,'2022-08-06 12:32:31','',''),(1600,'1','277','1',1,'Retail Sale Id 1609',749.84,0.00,0.00,1.03,54.59,'2022-08-06 13:03:17','',''),(1601,'1','277','1',1,'Retail Sale Id 1610',41005.00,0.00,0.00,59.00,1180.00,'2022-08-06 13:22:01','',''),(1602,'1','277','1',1,'Retail Sale Id 1611',2999.36,0.00,0.00,4.12,218.36,'2022-08-06 13:23:47','',''),(1603,'1','277','1',1,'Retail Sale Id 1612',9100.00,0.00,0.00,12.50,662.50,'2022-08-06 13:27:20','',''),(1604,'1','277','1',1,'Retail Sale Id 1613',1499.68,0.00,0.00,2.06,109.18,'2022-08-06 13:28:20','',''),(1605,'1','277','1',1,'Retail Sale Id 1614',9100.00,0.00,0.00,12.50,662.50,'2022-08-06 13:29:16','',''),(1606,'1','277','1',1,'Retail Sale Id 1615',2198.56,0.00,0.00,3.02,160.06,'2022-08-06 13:30:35','',''),(1607,'1','277','1',1,'Retail Sale Id 1616',58247.28,0.00,0.00,80.01,4240.53,'2022-08-06 13:33:30','',''),(1608,'1','277','1',1,'Retail Sale Id 1617',2198.56,0.00,0.00,3.02,160.06,'2022-08-06 13:45:19','',''),(1609,'1','277','1',1,'Retail Sale Id 1618',3698.24,0.00,0.00,5.08,269.24,'2022-08-06 13:47:45','',''),(1610,'1','277','1',1,'Retail Sale Id 1619',5853.12,0.00,0.00,8.04,426.12,'2022-08-06 13:50:54','',''),(1611,'1','277','1',1,'Return of Retail Sale Id 1616',0.00,58247.28,80.01,0.00,-4240.53,'2022-08-06 13:53:16','',''),(1612,'1','277','1',1,'Retail Sale Id 1620',997.36,0.00,0.00,1.37,72.61,'2022-08-06 14:04:08','',''),(1613,'1','277','1',1,'Retail Sale Id 1621',502.32,0.00,0.00,0.69,36.57,'2022-08-06 14:16:18','',''),(1614,'1','277','1',1,'Retail Sale Id 1622',5001.36,0.00,0.00,6.87,364.11,'2022-08-06 14:20:57','',''),(1615,'1','277','1',1,'Retail Sale Id 1623',1499.68,0.00,0.00,2.06,109.18,'2022-08-06 14:21:49','',''),(1616,'1','277','1',1,'Retail Sale Id 1624',2999.36,0.00,0.00,4.12,218.36,'2022-08-06 14:33:20','',''),(1617,'1','277','1',1,'Retail Sale Id 1624',9100.00,0.00,0.00,12.50,662.50,'2022-08-06 14:33:20','',''),(1618,'1','277','1',1,'Retail Sale Id 1625',9100.00,0.00,0.00,12.50,662.50,'2022-08-06 14:34:55','',''),(1619,'1','277','1',1,'Retail Sale Id 1626',4397.12,0.00,0.00,6.04,320.12,'2022-08-06 14:38:31','',''),(1620,'1','277','1',1,'Retail Sale Id 1627',800.80,0.00,0.00,1.10,58.30,'2022-08-06 14:47:42','',''),(1621,'1','277','1',1,'Retail Sale Id 1628',2999.36,0.00,0.00,4.12,218.36,'2022-08-06 14:57:27','',''),(1622,'1','277','1',1,'Retail Sale Id 1629',1201.20,0.00,0.00,1.65,87.45,'2022-08-06 15:06:36','',''),(1623,'1','277','1',1,'Retail Sale Id 1630',997.36,0.00,0.00,1.37,72.61,'2022-08-06 15:15:39','',''),(1624,'1','277','1',1,'Retail Sale Id 1631',3640.00,0.00,0.00,5.00,265.00,'2022-08-06 15:46:13','',''),(1625,'1','277','1',1,'Retail Sale Id 1632',5001.36,0.00,0.00,6.87,364.11,'2022-08-06 15:47:21','',''),(1626,'1','277','1',1,'Retail Sale Id 1633',2497.04,0.00,0.00,3.43,181.79,'2022-08-06 15:48:21','',''),(1627,'1','277','1',1,'Retail Sale Id 1634',3698.24,0.00,0.00,5.08,269.24,'2022-08-06 16:02:58','',''),(1628,'1','277','1',1,'Retail Sale Id 1635',2198.56,0.00,0.00,3.02,160.06,'2022-08-06 16:11:02','',''),(1629,'1','277','1',1,'Retail Sale Id 1636',2002.00,0.00,0.00,2.75,145.75,'2022-08-06 16:26:03','',''),(1630,'1','277','1',1,'Retail Sale Id 1637',3996.72,0.00,0.00,5.49,290.97,'2022-08-06 16:26:45','',''),(1631,'1','277','1',1,'Retail Sale Id 1638',997.36,0.00,0.00,1.37,72.61,'2022-08-06 16:35:32','',''),(1632,'1','277','1',1,'Retail Sale Id 1639',7003.36,0.00,0.00,9.62,509.86,'2022-08-06 16:41:30','',''),(1633,'1','277','1',1,'Retail Sale Id 1640',2999.36,0.00,0.00,4.12,218.36,'2022-08-06 16:45:11','',''),(1634,'1','277','1',1,'Retail Sale Id 1641',1303.12,0.00,0.00,1.79,94.87,'2022-08-06 16:47:53','',''),(1635,'1','277','1',1,'Retail Sale Id 1642',7280.00,0.00,0.00,10.00,530.00,'2022-08-06 16:49:42','',''),(1636,'1','277','1',1,'Retail Sale Id 1643',2198.56,0.00,0.00,3.02,160.06,'2022-08-06 16:53:56','',''),(1637,'1','277','1',1,'Retail Sale Id 1644',4368.00,0.00,0.00,6.00,318.00,'2022-08-06 17:06:27','',''),(1638,'1','277','1',1,'Retail Sale Id 1645',4368.00,0.00,0.00,6.00,318.00,'2022-08-06 17:08:32','',''),(1639,'1','277','1',1,'Retail Sale Id 1646',1499.68,0.00,0.00,2.06,109.18,'2022-08-06 17:23:32','',''),(1640,'1','277','1',1,'Retail Sale Id 1647',997.36,0.00,0.00,1.37,72.61,'2022-08-06 17:24:15','',''),(1641,'1','277','1',1,'Retail Sale Id 1648',1499.68,0.00,0.00,2.06,109.18,'2022-08-06 17:25:00','',''),(1642,'1','277','1',1,'Retail Sale Id 1649',2198.56,0.00,0.00,3.02,160.06,'2022-08-06 17:30:24','',''),(1643,'1','277','1',1,'Retail Sale Id 1650',2999.36,0.00,0.00,4.12,218.36,'2022-08-06 17:32:51','',''),(1644,'1','277','1',1,'Retail Sale Id 1651',1499.68,0.00,0.00,2.06,109.18,'2022-08-06 17:35:37','',''),(1645,'1','277','1',1,'Retail Sale Id 1651',2497.04,0.00,0.00,3.43,181.79,'2022-08-06 17:35:37','',''),(1646,'1','277','1',1,'Retail Sale Id 1653',2198.56,0.00,0.00,3.02,160.06,'2022-08-06 17:38:23','',''),(1647,'1','277','1',1,'Retail Sale Id 1654',2002.00,0.00,0.00,2.75,145.75,'2022-08-06 17:39:34','',''),(1648,'1','277','1',1,'Retail Sale Id 1655',2999.36,0.00,0.00,4.12,218.36,'2022-08-06 17:41:45','',''),(1649,'1','277','1',1,'Retail Sale Id 1656',2300.48,0.00,0.00,3.16,167.48,'2022-08-06 17:42:55','',''),(1650,'1','277','1',1,'Retail Sale Id 1657',8736.00,0.00,0.00,12.00,636.00,'2022-08-06 17:45:08','',''),(1651,'1','277','1',1,'Retail Sale Id 1658',2002.00,0.00,0.00,2.75,145.75,'2022-08-06 17:48:33','',''),(1652,'1','277','1',1,'Retail Sale Id 1659',997.36,0.00,0.00,1.37,72.61,'2022-08-06 17:49:54','',''),(1653,'1','277','1',1,'Retail Sale Id 1660',1499.68,0.00,0.00,2.06,109.18,'2022-08-06 17:51:26','',''),(1654,'1','277','1',1,'Retail Sale Id 1661',997.36,0.00,0.00,1.37,72.61,'2022-08-06 17:54:33','',''),(1655,'1','277','1',1,'Retail Sale Id 1662',3996.72,0.00,0.00,5.49,290.97,'2022-08-06 18:05:35','',''),(1656,'1','277','1',1,'Retail Sale Id 1663',1499.68,0.00,0.00,2.06,109.18,'2022-08-06 18:06:21','',''),(1657,'1','277','1',1,'Retail Sale Id 1664',997.36,0.00,0.00,1.37,72.61,'2022-08-06 18:31:55','',''),(1658,'1','277','1',1,'Retail Sale Id 1668',3698.24,0.00,0.00,5.08,269.24,'2022-08-06 18:37:48','',''),(1659,'1','277','1',1,'Retail Sale Id 1669',2198.56,0.00,0.00,3.02,160.06,'2022-08-06 18:39:16','',''),(1660,'1','277','1',1,'Retail Sale Id 1670',3996.72,0.00,0.00,5.49,290.97,'2022-08-06 18:44:33','',''),(1661,'1','277','1',1,'Retail Sale Id 1671',997.36,0.00,0.00,1.37,72.61,'2022-08-06 18:47:25','',''),(1662,'1','277','1',1,'Retail Sale Id 1672',2191.28,0.00,0.00,3.01,159.53,'2022-08-06 18:48:22','',''),(1663,'1','277','1',1,'Retail Sale Id 1673',5103.28,0.00,0.00,7.01,371.53,'2022-08-06 18:49:16','',''),(1664,'1','277','1',1,'Retail Sale Id 1674',2002.00,0.00,0.00,2.75,145.75,'2022-08-06 18:52:29','',''),(1665,'1','277','1',1,'Retail Sale Id 1675',2198.56,0.00,0.00,3.02,160.06,'2022-08-06 18:54:11','',''),(1666,'1','277','1',1,'Retail Sale Id 1676',2999.36,0.00,0.00,4.12,218.36,'2022-08-06 18:57:40','',''),(1667,'1','277','1',1,'Retail Sale Id 1677',2198.56,0.00,0.00,3.02,160.06,'2022-08-06 18:58:50','',''),(1668,'1','277','1',1,'Retail Sale Id 1678',2999.36,0.00,0.00,4.12,218.36,'2022-08-06 19:04:22','',''),(1669,'1','277','1',1,'Retail Sale Id 1678',2999.36,0.00,0.00,4.12,218.36,'2022-08-06 19:04:22','',''),(1670,'1','277','1',1,'Retail Sale Id 1679',502.32,0.00,0.00,0.69,36.57,'2022-08-06 19:19:33','',''),(1671,'1','277','1',1,'Retail Sale Id 1680',2198.56,0.00,0.00,3.02,160.06,'2022-08-06 19:20:15','',''),(1672,'1','277','1',1,'Return of Retail Sale Id 1661',0.00,997.36,1.37,0.00,-72.61,'2022-08-06 19:24:15','',''),(1673,'1','277','1',1,'Retail Sale Id 1681',2002.00,0.00,0.00,2.75,145.75,'2022-08-06 19:26:04','',''),(1674,'1','277','1',1,'Retail Sale Id 1682',997.36,0.00,0.00,1.37,72.61,'2022-08-06 19:52:12','',''),(1675,'1','277','1',1,'Retail Sale Id 1683',3501.68,0.00,0.00,4.81,254.93,'2022-08-07 06:59:00','',''),(1676,'1','277','1',1,'Retail Sale Id 1684',2198.56,0.00,0.00,3.02,160.06,'2022-08-07 07:03:59','',''),(1677,'1','277','1',1,'Retail Sale Id 1685',2999.36,0.00,0.00,4.12,218.36,'2022-08-07 07:29:05','',''),(1678,'1','277','1',1,'Retail Sale Id 1686',2497.04,0.00,0.00,3.43,181.79,'2022-08-07 07:37:21','',''),(1679,'1','277','1',1,'Retail Sale Id 1687',997.36,0.00,0.00,1.37,72.61,'2022-08-07 07:39:40','',''),(1680,'1','277','1',1,'Retail Sale Id 1688',2198.56,0.00,0.00,3.02,160.06,'2022-08-07 07:44:33','',''),(1681,'1','277','1',1,'Retail Sale Id 1689',800.80,0.00,0.00,1.10,58.30,'2022-08-07 07:47:20','',''),(1682,'1','277','1',1,'Retail Sale Id 1690',800.80,0.00,0.00,1.10,58.30,'2022-08-07 07:49:48','',''),(1683,'1','277','1',1,'Retail Sale Id 1691',3698.24,0.00,0.00,5.08,269.24,'2022-08-07 08:07:19','',''),(1684,'1','277','1',1,'Retail Sale Id 1692',2999.36,0.00,0.00,4.12,218.36,'2022-08-07 08:12:08','',''),(1685,'1','277','1',1,'Retail Sale Id 1693',1499.68,0.00,0.00,2.06,109.18,'2022-08-07 08:12:57','',''),(1686,'1','277','1',1,'Retail Sale Id 1694',1499.68,0.00,0.00,2.06,109.18,'2022-08-07 08:22:28','',''),(1687,'1','277','1',1,'Retail Sale Id 1695',4368.00,0.00,0.00,6.00,318.00,'2022-08-07 08:29:11','',''),(1688,'1','277','1',1,'Retail Sale Id 1696',1499.68,0.00,0.00,2.06,109.18,'2022-08-07 08:30:33','',''),(1689,'1','277','1',1,'Retail Sale Id 1697',997.36,0.00,0.00,1.37,72.61,'2022-08-07 08:31:19','',''),(1690,'1','277','1',1,'Retail Sale Id 1698',2497.04,0.00,0.00,3.43,181.79,'2022-08-07 08:46:06','',''),(1691,'1','277','1',1,'Retail Sale Id 1699',9100.00,0.00,0.00,12.50,662.50,'2022-08-07 08:47:38','',''),(1692,'1','277','1',1,'Retail Sale Id 1700',4397.12,0.00,0.00,6.04,320.12,'2022-08-07 08:49:50','',''),(1693,'1','277','1',1,'Retail Sale Id 1701',1499.68,0.00,0.00,2.06,109.18,'2022-08-07 08:52:23','',''),(1694,'1','277','1',1,'Retail Sale Id 1702',2497.04,0.00,0.00,3.43,181.79,'2022-08-07 08:55:41','',''),(1695,'1','277','1',1,'Retail Sale Id 1703',2999.36,0.00,0.00,4.12,218.36,'2022-08-07 08:56:29','',''),(1696,'1','277','1',1,'Retail Sale Id 1704',2191.28,0.00,0.00,3.01,159.53,'2022-08-07 09:03:19','',''),(1697,'1','277','1',1,'Retail Sale Id 1705',1499.68,0.00,0.00,2.06,109.18,'2022-08-07 09:06:20','',''),(1698,'1','277','1',1,'Retail Sale Id 1706',997.36,0.00,0.00,1.37,72.61,'2022-08-07 09:14:17','',''),(1699,'1','277','1',1,'Retail Sale Id 1707',1499.68,0.00,0.00,2.06,109.18,'2022-08-07 09:15:52','',''),(1700,'1','277','1',1,'Retail Sale Id 1708',1499.68,0.00,0.00,2.06,109.18,'2022-08-07 09:19:47','',''),(1701,'1','277','1',1,'Retail Sale Id 1709',1499.68,0.00,0.00,2.06,109.18,'2022-08-07 09:20:31','',''),(1702,'1','277','1',1,'Retail Sale Id 1710',5001.36,0.00,0.00,6.87,364.11,'2022-08-07 09:26:44','',''),(1703,'1','277','1',1,'Retail Sale Id 1711',2198.56,0.00,0.00,3.02,160.06,'2022-08-07 09:33:44','',''),(1704,'1','277','1',1,'Retail Sale Id 1712',1499.68,0.00,0.00,2.06,109.18,'2022-08-07 09:34:57','',''),(1705,'1','277','1',1,'Retail Sale Id 1713',9100.00,0.00,0.00,12.50,662.50,'2022-08-07 09:36:58','',''),(1706,'1','277','1',1,'Retail Sale Id 1714',5001.36,0.00,0.00,6.87,364.11,'2022-08-07 09:47:55','',''),(1707,'1','277','1',1,'Retail Sale Id 1715',2198.56,0.00,0.00,3.02,160.06,'2022-08-07 09:55:35','',''),(1708,'1','277','1',1,'Retail Sale Id 1716',7498.40,0.00,0.00,10.30,545.90,'2022-08-07 10:13:21','',''),(1709,'1','277','1',1,'Retail Sale Id 1717',9100.00,0.00,0.00,12.50,662.50,'2022-08-07 10:18:42','',''),(1710,'1','277','1',1,'Retail Sale Id 1718',34750.00,0.00,0.00,50.00,1000.00,'2022-08-07 10:22:22','',''),(1711,'1','277','1',1,'Retail Sale Id 1719',3996.72,0.00,0.00,5.49,290.97,'2022-08-07 10:48:47','',''),(1712,'1','277','1',1,'Retail Sale Id 1720',3640.00,0.00,0.00,5.00,265.00,'2022-08-07 10:57:20','',''),(1713,'1','277','1',1,'Retail Sale Id 1721',2002.00,0.00,0.00,2.75,145.75,'2022-08-07 10:58:03','',''),(1714,'1','277','1',1,'Retail Sale Id 1722',2999.36,0.00,0.00,4.12,218.36,'2022-08-07 11:05:23','',''),(1715,'1','277','1',1,'Retail Sale Id 1723',800.80,0.00,0.00,1.10,58.30,'2022-08-07 11:06:16','',''),(1716,'1','277','1',1,'Retail Sale Id 1724',1499.68,0.00,0.00,2.06,109.18,'2022-08-07 11:20:02','',''),(1717,'1','277','1',1,'Retail Sale Id 1725',2198.56,0.00,0.00,3.02,160.06,'2022-08-07 11:22:08','',''),(1718,'1','277','1',1,'Retail Sale Id 1726',2999.36,0.00,0.00,4.12,218.36,'2022-08-07 11:23:00','',''),(1719,'1','277','1',1,'Retail Sale Id 1728',3501.68,0.00,0.00,4.81,254.93,'2022-08-07 11:26:03','',''),(1720,'1','277','1',1,'Retail Sale Id 1729',16380.00,0.00,0.00,22.50,1192.50,'2022-08-07 11:38:40','',''),(1721,'1','277','1',1,'Retail Sale Id 1730',1499.68,0.00,0.00,2.06,109.18,'2022-08-07 11:42:53','',''),(1722,'1','277','1',1,'Retail Sale Id 1731',6501.04,0.00,0.00,8.93,473.29,'2022-08-07 11:49:01','',''),(1723,'1','277','1',1,'Retail Sale Id 1732',9100.00,0.00,0.00,12.50,662.50,'2022-08-07 12:00:33','',''),(1724,'1','277','1',1,'Retail Sale Id 1733',2198.56,0.00,0.00,3.02,160.06,'2022-08-07 12:06:44','',''),(1725,'1','277','1',1,'Retail Sale Id 1734',2198.56,0.00,0.00,3.02,160.06,'2022-08-07 12:11:11','',''),(1726,'1','277','1',1,'Retail Sale Id 1735',2002.00,0.00,0.00,2.75,145.75,'2022-08-07 12:15:52','',''),(1727,'1','277','1',1,'Retail Sale Id 1736',1499.68,0.00,0.00,2.06,109.18,'2022-08-07 12:24:44','',''),(1728,'1','277','1',1,'Retail Sale Id 1737',3749.20,0.00,0.00,5.15,272.95,'2022-08-07 12:28:11','',''),(1729,'1','277','1',1,'Retail Sale Id 1738',4368.00,0.00,0.00,6.00,318.00,'2022-08-07 12:29:35','',''),(1730,'1','277','1',1,'Retail Sale Id 1740',8801.52,0.00,0.00,12.09,640.77,'2022-08-07 12:31:43','',''),(1731,'1','277','1',1,'Retail Sale Id 1741',2999.36,0.00,0.00,4.12,218.36,'2022-08-07 12:32:41','',''),(1732,'1','277','1',1,'Retail Sale Id 1742',4302.48,0.00,0.00,5.91,313.23,'2022-08-07 12:33:46','',''),(1733,'1','277','1',1,'Retail Sale Id 1743',997.36,0.00,0.00,1.37,72.61,'2022-08-07 12:34:25','',''),(1734,'1','277','1',1,'Retail Sale Id 1744',2999.36,0.00,0.00,4.12,218.36,'2022-08-07 12:35:06','',''),(1735,'1','277','1',1,'Retail Sale Id 1745',104250.00,0.00,0.00,150.00,3000.00,'2022-08-07 12:40:16','',''),(1736,'1','277','1',1,'Retail Sale Id 1746',3698.24,0.00,0.00,5.08,269.24,'2022-08-07 12:41:33','',''),(1737,'1','277','1',1,'Retail Sale Id 1747',997.36,0.00,0.00,1.37,72.61,'2022-08-07 12:47:05','',''),(1738,'1','277','1',1,'Retail Sale Id 1748',3647.28,0.00,0.00,5.01,265.53,'2022-08-07 12:50:11','',''),(1739,'1','277','1',1,'Retail Sale Id 1749',2999.36,0.00,0.00,4.12,218.36,'2022-08-07 12:51:06','',''),(1740,'1','277','1',1,'Retail Sale Id 1750',2002.00,0.00,0.00,2.75,145.75,'2022-08-07 12:59:39','',''),(1741,'1','277','1',1,'Retail Sale Id 1751',2948.40,0.00,0.00,4.05,214.65,'2022-08-07 13:04:07','',''),(1742,'1','277','1',1,'Retail Sale Id 1752',3749.20,0.00,0.00,5.15,272.95,'2022-08-07 13:09:51','',''),(1743,'1','277','1',1,'Retail Sale Id 1753',997.36,0.00,0.00,1.37,72.61,'2022-08-07 13:12:52','',''),(1744,'1','277','1',1,'Retail Sale Id 1754',9100.00,0.00,0.00,12.50,662.50,'2022-08-07 13:15:23','',''),(1745,'1','277','1',1,'Retail Sale Id 1755',800.80,0.00,0.00,1.10,58.30,'2022-08-07 13:16:44','',''),(1746,'1','277','1',1,'Retail Sale Id 1756',3698.24,0.00,0.00,5.08,269.24,'2022-08-07 13:18:40','',''),(1747,'1','277','1',1,'Retail Sale Id 1757',1499.68,0.00,0.00,2.06,109.18,'2022-08-07 13:19:26','',''),(1748,'1','277','1',1,'Retail Sale Id 1758',8503.04,0.00,0.00,11.68,619.04,'2022-08-07 13:28:15','',''),(1749,'1','277','1',1,'Retail Sale Id 1759',3698.24,0.00,0.00,5.08,269.24,'2022-08-07 13:29:42','',''),(1750,'1','277','1',1,'Retail Sale Id 1760',9100.00,0.00,0.00,12.50,662.50,'2022-08-07 13:32:53','',''),(1751,'1','277','1',1,'Retail Sale Id 1761',9100.00,0.00,0.00,12.50,662.50,'2022-08-07 13:42:51','',''),(1752,'1','277','1',1,'Retail Sale Id 1762',4397.12,0.00,0.00,6.04,320.12,'2022-08-07 13:51:52','',''),(1753,'1','277','1',1,'Retail Sale Id 1763',2198.56,0.00,0.00,3.02,160.06,'2022-08-07 13:53:40','',''),(1754,'1','277','1',1,'Retail Sale Id 1764',7003.36,0.00,0.00,9.62,509.86,'2022-08-07 13:54:40','',''),(1755,'1','277','1',1,'Retail Sale Id 1765',2198.56,0.00,0.00,3.02,160.06,'2022-08-07 14:01:42','',''),(1756,'1','277','1',1,'Retail Sale Id 1766',2198.56,0.00,0.00,3.02,160.06,'2022-08-07 14:02:42','',''),(1757,'1','277','1',1,'Retail Sale Id 1767',2002.00,0.00,0.00,2.75,145.75,'2022-08-07 14:07:02','',''),(1758,'1','277','1',1,'Retail Sale Id 1768',749.84,0.00,0.00,1.03,54.59,'2022-08-07 14:10:52','',''),(1759,'1','277','1',1,'Retail Sale Id 1769',2999.36,0.00,0.00,4.12,218.36,'2022-08-07 14:14:48','',''),(1760,'1','277','1',1,'Retail Sale Id 1771',2919.28,0.00,0.00,4.01,212.53,'2022-08-07 14:26:30','',''),(1761,'1','277','1',1,'Retail Sale Id 1773',3698.24,0.00,0.00,5.08,269.24,'2022-08-07 14:28:24','',''),(1762,'1','277','1',1,'Retail Sale Id 1774',9100.00,0.00,0.00,12.50,662.50,'2022-08-07 14:32:12','',''),(1763,'1','277','1',1,'Retail Sale Id 1775',1499.68,0.00,0.00,2.06,109.18,'2022-08-07 14:34:39','',''),(1764,'1','277','1',1,'Retail Sale Id 1776',3996.72,0.00,0.00,5.49,290.97,'2022-08-07 14:38:08','',''),(1765,'1','277','1',1,'Retail Sale Id 1777',9100.00,0.00,0.00,12.50,662.50,'2022-08-07 14:48:56','',''),(1766,'1','277','1',1,'Retail Sale Id 1778',7280.00,0.00,0.00,10.00,530.00,'2022-08-07 14:49:40','',''),(1767,'1','277','1',1,'Retail Sale Id 1779',997.36,0.00,0.00,1.37,72.61,'2022-08-07 14:50:20','',''),(1768,'1','277','1',1,'Retail Sale Id 1780',2002.00,0.00,0.00,2.75,145.75,'2022-08-07 14:55:31','',''),(1769,'1','277','1',1,'Retail Sale Id 1781',5001.36,0.00,0.00,6.87,364.11,'2022-08-07 14:59:05','',''),(1770,'1','277','1',1,'Retail Sale Id 1782',1499.68,0.00,0.00,2.06,109.18,'2022-08-07 15:13:19','',''),(1771,'1','277','1',1,'Retail Sale Id 1783',1201.20,0.00,0.00,1.65,87.45,'2022-08-07 15:20:44','',''),(1772,'1','277','1',1,'Retail Sale Id 1784',5998.72,0.00,0.00,8.24,436.72,'2022-08-07 15:23:27','',''),(1773,'1','277','1',1,'Retail Sale Id 1785',2198.56,0.00,0.00,3.02,160.06,'2022-08-07 15:30:25','',''),(1774,'1','277','1',1,'Retail Sale Id 1786',4368.00,0.00,0.00,6.00,318.00,'2022-08-07 15:32:04','',''),(1775,'1','277','1',1,'Retail Sale Id 1787',5001.36,0.00,0.00,6.87,364.11,'2022-08-07 15:44:24','',''),(1776,'1','277','1',1,'Retail Sale Id 1788',997.36,0.00,0.00,1.37,72.61,'2022-08-07 15:49:31','',''),(1777,'1','277','1',1,'Retail Sale Id 1789',2198.56,0.00,0.00,3.02,160.06,'2022-08-07 16:16:58','',''),(1778,'1','277','1',1,'Retail Sale Id 1790',800.80,0.00,0.00,1.10,58.30,'2022-08-07 16:18:27','',''),(1779,'1','277','1',1,'Retail Sale Id 1791',2198.56,0.00,0.00,3.02,160.06,'2022-08-07 16:23:07','',''),(1780,'1','277','1',1,'Retail Sale Id 1792',997.36,0.00,0.00,1.37,72.61,'2022-08-07 16:33:58','',''),(1781,'1','277','1',1,'Retail Sale Id 1793',4397.12,0.00,0.00,6.04,320.12,'2022-08-07 16:36:43','',''),(1782,'1','277','1',1,'Retail Sale Id 1794',5001.36,0.00,0.00,6.87,364.11,'2022-08-07 16:39:16','',''),(1783,'1','277','1',1,'Retail Sale Id 1795',2096.64,0.00,0.00,2.88,152.64,'2022-08-07 16:40:19','',''),(1784,'1','277','1',1,'Retail Sale Id 1796',2999.36,0.00,0.00,4.12,218.36,'2022-08-07 16:57:02','',''),(1785,'1','277','1',1,'Retail Sale Id 1797',3640.00,0.00,0.00,5.00,265.00,'2022-08-07 17:00:12','',''),(1786,'1','277','1',1,'Retail Sale Id 1797',4368.00,0.00,0.00,6.00,318.00,'2022-08-07 17:00:12','',''),(1787,'1','277','1',1,'Retail Sale Id 1798',2198.56,0.00,0.00,3.02,160.06,'2022-08-07 17:04:54','',''),(1788,'1','277','1',1,'Retail Sale Id 1799',1499.68,0.00,0.00,2.06,109.18,'2022-08-07 17:12:30','',''),(1789,'1','277','1',1,'Retail Sale Id 1800',800.80,0.00,0.00,1.10,58.30,'2022-08-07 17:16:34','',''),(1790,'1','277','1',1,'Retail Sale Id 1802',2999.36,0.00,0.00,4.12,218.36,'2022-08-07 17:17:23','',''),(1791,'1','277','1',1,'Retail Sale Id 1803',2999.36,0.00,0.00,4.12,218.36,'2022-08-07 17:21:06','',''),(1792,'1','277','1',1,'Retail Sale Id 1804',1499.68,0.00,0.00,2.06,109.18,'2022-08-07 17:21:46','',''),(1793,'1','277','1',1,'Retail Sale Id 1805',9100.00,0.00,0.00,12.50,662.50,'2022-08-07 17:23:48','',''),(1794,'1','277','1',1,'Retail Sale Id 1807',4302.48,0.00,0.00,5.91,313.23,'2022-08-07 17:36:28','',''),(1795,'1','277','1',1,'Retail Sale Id 1808',4397.12,0.00,0.00,6.04,320.12,'2022-08-07 17:45:16','',''),(1796,'1','277','1',1,'Retail Sale Id 1809',2198.56,0.00,0.00,3.02,160.06,'2022-08-07 17:50:13','',''),(1797,'1','277','1',1,'Retail Sale Id 1810',4397.12,0.00,0.00,6.04,320.12,'2022-08-07 17:52:09','',''),(1798,'1','277','1',1,'Retail Sale Id 1811',1499.68,0.00,0.00,2.06,109.18,'2022-08-07 18:05:45','',''),(1799,'1','277','1',1,'Retail Sale Id 1812',2999.36,0.00,0.00,4.12,218.36,'2022-08-07 18:06:42','',''),(1800,'1','277','1',1,'Retail Sale Id 1813',2002.00,0.00,0.00,2.75,145.75,'2022-08-07 18:09:04','',''),(1801,'1','277','1',1,'Retail Sale Id 1814',1499.68,0.00,0.00,2.06,109.18,'2022-08-07 18:12:30','',''),(1802,'1','277','1',1,'Retail Sale Id 1815',2198.56,0.00,0.00,3.02,160.06,'2022-08-07 18:13:52','',''),(1803,'1','277','1',1,'Retail Sale Id 1816',800.80,0.00,0.00,1.10,58.30,'2022-08-07 18:24:59','',''),(1804,'1','277','1',1,'Retail Sale Id 1817',4499.04,0.00,0.00,6.18,327.54,'2022-08-07 18:40:22','',''),(1805,'1','277','1',1,'Retail Sale Id 1818',2002.00,0.00,0.00,2.75,145.75,'2022-08-07 18:46:48','',''),(1806,'1','277','1',1,'Retail Sale Id 1819',2198.56,0.00,0.00,3.02,160.06,'2022-08-07 18:48:52','',''),(1807,'1','277','1',1,'Retail Sale Id 1820',3698.24,0.00,0.00,5.08,269.24,'2022-08-07 18:50:10','',''),(1808,'1','277','1',1,'Retail Sale Id 1821',2198.56,0.00,0.00,3.02,160.06,'2022-08-07 18:57:11','',''),(1809,'1','277','1',1,'Retail Sale Id 1822',43.68,0.00,0.00,0.06,3.18,'2022-08-07 19:32:10','',''),(1810,'1','277','1',1,'Retail Sale Id 1823',1998.80,0.00,0.00,2.63,-13.15,'2022-08-08 07:50:10','',''),(1811,'1','277','1',1,'Retail Sale Id 1824',2500.40,0.00,0.00,3.29,-16.45,'2022-08-08 07:51:02','',''),(1812,'1','277','1',1,'Retail Sale Id 1825',3800.00,0.00,0.00,5.00,-25.00,'2022-08-08 07:59:43','',''),(1813,'1','277','1',1,'Retail Sale Id 1826',10001.60,0.00,0.00,13.16,-65.80,'2022-08-08 08:14:21','',''),(1814,'1','277','1',1,'Retail Sale Id 1828',3002.00,0.00,0.00,3.95,-19.75,'2022-08-08 08:18:08','',''),(1815,'1','277','1',1,'Retail Sale Id 1829',1998.80,0.00,0.00,2.63,-13.15,'2022-08-08 08:22:54','',''),(1816,'1','277','1',1,'Retail Sale Id 1830',4560.00,0.00,0.00,6.00,-30.00,'2022-08-08 08:51:04','',''),(1817,'1','277','1',1,'Retail Sale Id 1831',3800.00,0.00,0.00,5.00,-25.00,'2022-08-08 08:52:17','',''),(1818,'1','277','1',1,'Retail Sale Id 1832',3002.00,0.00,0.00,3.95,-19.75,'2022-08-08 08:56:21','',''),(1819,'1','277','1',1,'Retail Sale Id 1833',1497.20,0.00,0.00,1.97,-9.85,'2022-08-08 08:56:58','',''),(1820,'1','277','1',1,'Retail Sale Id 1834',1003.20,0.00,0.00,1.32,-6.60,'2022-08-08 08:57:44','',''),(1821,'1','277','1',1,'Retail Sale Id 1835',3040.00,0.00,0.00,4.00,-20.00,'2022-08-08 08:58:52','',''),(1822,'1','277','1',1,'Retail Sale Id 1836',3047.60,0.00,0.00,4.01,-20.05,'2022-08-08 09:00:25','',''),(1823,'1','277','1',1,'Retail Sale Id 1837',2302.80,0.00,0.00,3.03,-15.15,'2022-08-08 09:28:25','',''),(1824,'1','277','1',1,'Retail Sale Id 1838',1497.20,0.00,0.00,1.97,-9.85,'2022-08-08 09:33:09','',''),(1825,'1','277','1',1,'Retail Sale Id 1839',5350.40,0.00,0.00,7.04,-35.20,'2022-08-08 09:46:04','',''),(1826,'1','277','1',1,'Retail Sale Id 1840',501.60,0.00,0.00,0.66,-3.30,'2022-08-08 09:51:32','',''),(1827,'1','277','1',1,'Retail Sale Id 1841',2302.80,0.00,0.00,3.03,-15.15,'2022-08-08 09:52:25','',''),(1828,'1','277','1',1,'Retail Sale Id 1842',4552.40,0.00,0.00,5.99,-29.95,'2022-08-08 09:56:59','',''),(1829,'1','277','1',1,'Retail Sale Id 1843',1003.20,0.00,0.00,1.32,-6.60,'2022-08-08 10:01:08','',''),(1830,'1','277','1',1,'Retail Sale Id 1844',1998.80,0.00,0.00,2.63,-13.15,'2022-08-08 10:47:36','',''),(1831,'1','277','1',1,'Retail Sale Id 1845',3002.00,0.00,0.00,3.95,-19.75,'2022-08-08 10:50:52','',''),(1832,'1','277','1',1,'Retail Sale Id 1846',752.40,0.00,0.00,0.99,-4.95,'2022-08-08 11:01:53','',''),(1833,'1','277','1',1,'Retail Sale Id 1847',798.00,0.00,0.00,1.05,-5.25,'2022-08-08 11:03:17','',''),(1834,'1','277','1',1,'Retail Sale Id 1848',9500.00,0.00,0.00,12.50,-62.50,'2022-08-08 11:46:13','',''),(1835,'1','277','1',1,'Retail Sale Id 1849',1998.80,0.00,0.00,2.63,-13.15,'2022-08-08 11:47:05','',''),(1836,'1','277','1',1,'Retail Sale Id 1850',3800.00,0.00,0.00,5.00,-25.00,'2022-08-08 11:54:49','',''),(1837,'1','277','1',1,'Retail Sale Id 1851',2500.40,0.00,0.00,3.29,-16.45,'2022-08-08 11:59:56','',''),(1838,'1','277','1',1,'Retail Sale Id 1854',9500.00,0.00,0.00,12.50,-62.50,'2022-08-08 12:42:33','',''),(1839,'1','277','1',1,'Retail Sale Id 1856',3800.00,0.00,0.00,5.00,-25.00,'2022-08-08 12:46:52','',''),(1840,'1','277','1',1,'Retail Sale Id 1857',1003.20,0.00,0.00,1.32,-6.60,'2022-08-08 12:53:04','',''),(1841,'1','277','1',1,'Retail Sale Id 1858',10556.40,0.00,0.00,13.89,-69.45,'2022-08-08 12:54:22','',''),(1842,'1','277','1',1,'Retail Sale Id 1859',9500.00,0.00,0.00,12.50,-62.50,'2022-08-08 13:00:16','',''),(1843,'1','277','1',1,'Retail Sale Id 1860',3002.00,0.00,0.00,3.95,-19.75,'2022-08-08 13:01:23','',''),(1844,'1','277','1',1,'Retail Sale Id 1861',4499.20,0.00,0.00,5.92,-29.60,'2022-08-08 13:03:55','',''),(1845,'1','277','1',1,'Retail Sale Id 1863',1998.80,0.00,0.00,2.63,-13.15,'2022-08-08 13:32:48','',''),(1846,'1','277','1',1,'Retail Sale Id 1864',2401.60,0.00,0.00,3.16,-15.80,'2022-08-08 13:39:15','',''),(1847,'1','277','1',1,'Retail Sale Id 1865',1497.20,0.00,0.00,1.97,-9.85,'2022-08-08 13:40:21','',''),(1848,'1','277','1',1,'Retail Sale Id 1866',501.60,0.00,0.00,0.66,-3.30,'2022-08-08 13:45:17','',''),(1849,'1','277','1',1,'Retail Sale Id 1867',3800.00,0.00,0.00,5.00,-25.00,'2022-08-08 14:22:11','',''),(1850,'1','277','1',1,'Retail Sale Id 1868',1998.80,0.00,0.00,2.63,-13.15,'2022-08-08 14:26:35','',''),(1851,'1','277','1',1,'Retail Sale Id 1869',4560.00,0.00,0.00,6.00,-30.00,'2022-08-08 14:36:25','',''),(1852,'1','277','1',1,'Retail Sale Id 1870',9500.00,0.00,0.00,12.50,-62.50,'2022-08-08 14:59:30','',''),(1853,'1','277','1',1,'Retail Sale Id 1871',2280.00,0.00,0.00,3.00,-15.00,'2022-08-08 15:01:58','',''),(1854,'1','277','1',1,'Retail Sale Id 1874',3800.00,0.00,0.00,5.00,-25.00,'2022-08-08 15:14:03','',''),(1855,'1','277','1',1,'Retail Sale Id 1875',3002.00,0.00,0.00,3.95,-19.75,'2022-08-08 15:16:15','',''),(1856,'1','277','1',1,'Retail Sale Id 1876',501.60,0.00,0.00,0.66,-3.30,'2022-08-08 15:29:17','',''),(1857,'1','277','1',1,'Retail Sale Id 1877',31240.00,0.00,0.00,44.00,-2420.00,'2022-08-08 15:35:58','',''),(1858,'1','277','1',1,'Retail Sale Id 1878',3002.00,0.00,0.00,3.95,-19.75,'2022-08-08 15:40:19','',''),(1859,'1','277','1',1,'Retail Sale Id 1879',4552.40,0.00,0.00,5.99,-29.95,'2022-08-08 15:42:16','',''),(1860,'1','277','1',1,'Retail Sale Id 1880',1497.20,0.00,0.00,1.97,-9.85,'2022-08-08 15:49:58','',''),(1861,'1','277','1',1,'Retail Sale Id 1881',1003.20,0.00,0.00,1.32,-6.60,'2022-08-08 15:56:18','',''),(1862,'1','277','1',1,'Retail Sale Id 1882',760.00,0.00,0.00,1.00,-5.00,'2022-08-08 15:59:25','',''),(1863,'1','277','1',1,'Retail Sale Id 1882',4598.00,0.00,0.00,6.05,-30.25,'2022-08-08 15:59:25','',''),(1864,'1','277','1',1,'Retail Sale Id 1883',4598.00,0.00,0.00,6.05,-30.25,'2022-08-08 16:00:18','',''),(1865,'1','277','1',1,'Retail Sale Id 1883',9500.00,0.00,0.00,12.50,-62.50,'2022-08-08 16:00:18','',''),(1866,'1','277','1',1,'Return of Retail Sale Id 1882',0.00,760.00,1.00,0.00,5.00,'2022-08-08 16:01:08','',''),(1867,'1','277','1',1,'Return of Retail Sale Id 1882',0.00,4598.00,6.05,0.00,30.25,'2022-08-08 16:01:08','',''),(1868,'1','277','1',1,'Retail Sale Id 1884',9500.00,0.00,0.00,12.50,-62.50,'2022-08-08 16:06:04','',''),(1869,'1','277','1',1,'Retail Sale Id 1885',9500.00,0.00,0.00,12.50,-62.50,'2022-08-08 16:08:54','',''),(1870,'1','277','1',1,'Retail Sale Id 1886',14873.20,0.00,0.00,19.57,-97.85,'2022-08-08 16:27:21','',''),(1871,'1','277','1',1,'Retail Sale Id 1887',4560.00,0.00,0.00,6.00,-30.00,'2022-08-08 16:30:07','',''),(1872,'1','277','1',1,'Retail Sale Id 1888',2249.60,0.00,0.00,2.96,-14.80,'2022-08-08 16:30:54','',''),(1873,'1','277','1',1,'Retail Sale Id 1889',1003.20,0.00,0.00,1.32,-6.60,'2022-08-08 16:31:46','',''),(1874,'1','277','1',1,'Retail Sale Id 1890',1998.80,0.00,0.00,2.63,-13.15,'2022-08-08 16:34:20','',''),(1875,'1','277','1',1,'Retail Sale Id 1891',798.00,0.00,0.00,1.05,-5.25,'2022-08-08 16:41:37','',''),(1876,'1','277','1',1,'Retail Sale Id 1892',4552.40,0.00,0.00,5.99,-29.95,'2022-08-08 16:47:16','',''),(1877,'1','277','1',1,'Retail Sale Id 1893',2196.40,0.00,0.00,2.89,-14.45,'2022-08-08 16:48:49','',''),(1878,'1','277','1',1,'Retail Sale Id 1894',3997.60,0.00,0.00,5.26,-26.30,'2022-08-08 16:59:27','',''),(1879,'1','277','1',1,'Retail Sale Id 1895',2500.40,0.00,0.00,3.29,-16.45,'2022-08-08 17:09:12','',''),(1880,'1','277','1',1,'Retail Sale Id 1896',2500.40,0.00,0.00,3.29,-16.45,'2022-08-08 17:12:24','',''),(1881,'1','277','1',1,'Retail Sale Id 1897',5000.80,0.00,0.00,6.58,-32.90,'2022-08-08 17:14:12','',''),(1882,'1','277','1',1,'Retail Sale Id 1898',3800.00,0.00,0.00,5.00,-25.00,'2022-08-08 17:20:55','',''),(1883,'1','277','1',1,'Retail Sale Id 1899',9500.00,0.00,0.00,12.50,-62.50,'2022-08-08 17:27:21','',''),(1884,'1','277','1',1,'Retail Sale Id 1900',1497.20,0.00,0.00,1.97,-9.85,'2022-08-08 17:29:20','',''),(1885,'1','277','1',1,'Retail Sale Id 1901',3800.00,0.00,0.00,5.00,-25.00,'2022-08-08 17:30:38','',''),(1886,'1','277','1',1,'Retail Sale Id 1902',2500.40,0.00,0.00,3.29,-16.45,'2022-08-08 17:48:46','',''),(1887,'1','277','1',1,'Retail Sale Id 1903',5000.80,0.00,0.00,6.58,-32.90,'2022-08-08 17:51:37','',''),(1888,'1','277','1',1,'Retail Sale Id 1904',7600.00,0.00,0.00,10.00,-50.00,'2022-08-08 18:03:30','',''),(1889,'1','277','1',1,'Retail Sale Id 1905',1497.20,0.00,0.00,1.97,-9.85,'2022-08-08 18:04:50','',''),(1890,'1','277','1',1,'Retail Sale Id 1906',3040.00,0.00,0.00,4.00,-20.00,'2022-08-08 18:10:12','',''),(1891,'1','277','1',1,'Retail Sale Id 1907',3047.60,0.00,0.00,4.01,-20.05,'2022-08-08 18:11:16','',''),(1892,'1','277','1',1,'Retail Sale Id 1908',752.40,0.00,0.00,0.99,-4.95,'2022-08-08 18:13:10','',''),(1893,'1','277','1',1,'Retail Sale Id 1909',3800.00,0.00,0.00,5.00,-25.00,'2022-08-08 18:13:55','',''),(1894,'1','277','1',1,'Retail Sale Id 1910',3002.00,0.00,0.00,3.95,-19.75,'2022-08-08 18:15:09','',''),(1895,'1','277','1',1,'Retail Sale Id 1911',3047.60,0.00,0.00,4.01,-20.05,'2022-08-08 18:18:42','',''),(1896,'1','277','1',1,'Retail Sale Id 1912',501.60,0.00,0.00,0.66,-3.30,'2022-08-08 18:22:47','',''),(1897,'1','277','1',1,'Retail Sale Id 1913',3800.00,0.00,0.00,5.00,-25.00,'2022-08-08 18:25:06','',''),(1898,'1','277','1',1,'Retail Sale Id 1914',1497.20,0.00,0.00,1.97,-9.85,'2022-08-08 18:26:39','',''),(1899,'1','277','1',1,'Retail Sale Id 1915',4552.40,0.00,0.00,5.99,-29.95,'2022-08-08 18:28:09','',''),(1900,'1','277','1',1,'Retail Sale Id 1916',2302.80,0.00,0.00,3.03,-15.15,'2022-08-08 18:35:21','',''),(1901,'1','277','1',1,'Retail Sale Id 1917',2302.80,0.00,0.00,3.03,-15.15,'2022-08-08 18:44:29','',''),(1902,'1','277','1',1,'Retail Sale Id 1918',501.60,0.00,0.00,0.66,-3.30,'2022-08-08 18:46:05','',''),(1903,'1','277','1',1,'Retail Sale Id 1919',9500.00,0.00,0.00,12.50,-62.50,'2022-08-08 18:50:12','',''),(1904,'1','277','1',1,'Retail Sale Id 1920',699.20,0.00,0.00,0.92,-4.60,'2022-08-08 18:53:52','',''),(1905,'1','277','1',1,'Retail Sale Id 1921',1497.20,0.00,0.00,1.97,-9.85,'2022-08-08 19:25:30','',''),(1906,'1','277','1',1,'Retail Sale Id 1922',14200.00,0.00,0.00,20.00,-1100.00,'2022-08-08 19:26:54','',''),(1907,'1','277','1',1,'Retail Sale Id 1923',1079.20,0.00,0.00,1.42,-7.10,'2022-08-08 19:46:27','',''),(1908,'1','277','1',1,'Retail Sale Id 1924',2302.80,0.00,0.00,3.03,-15.15,'2022-08-09 07:00:08','',''),(1909,'1','277','1',1,'Retail Sale Id 1925',1998.80,0.00,0.00,2.63,-13.15,'2022-08-09 07:09:05','',''),(1910,'1','277','1',1,'Retail Sale Id 1926',3002.00,0.00,0.00,3.95,-19.75,'2022-08-09 07:15:12','',''),(1911,'1','277','1',1,'Retail Sale Id 1927',1497.20,0.00,0.00,1.97,-9.85,'2022-08-09 07:52:54','',''),(1912,'1','277','1',1,'Retail Sale Id 1928',3002.00,0.00,0.00,3.95,-19.75,'2022-08-09 08:02:10','',''),(1913,'1','277','1',1,'Retail Sale Id 1929',798.00,0.00,0.00,1.05,-5.25,'2022-08-09 08:03:12','',''),(1914,'1','277','1',1,'Retail Sale Id 1930',2302.80,0.00,0.00,3.03,-15.15,'2022-08-09 08:07:37','',''),(1915,'1','277','1',1,'Retail Sale Id 1931',9500.00,0.00,0.00,12.50,-62.50,'2022-08-09 08:14:16','',''),(1916,'1','277','1',1,'Retail Sale Id 1932',1003.20,0.00,0.00,1.32,-6.60,'2022-08-09 08:18:45','',''),(1917,'1','277','1',1,'Retail Sale Id 1933',1003.20,0.00,0.00,1.32,-6.60,'2022-08-09 08:26:23','',''),(1918,'1','277','1',1,'Retail Sale Id 1934',3701.20,0.00,0.00,4.87,-24.35,'2022-08-09 08:43:47','',''),(1919,'1','277','1',1,'Retail Sale Id 1935',2302.80,0.00,0.00,3.03,-15.15,'2022-08-09 08:45:02','',''),(1920,'1','277','1',1,'Retail Sale Id 1936',1550.40,0.00,0.00,2.04,-10.20,'2022-08-09 09:01:52','',''),(1921,'1','277','1',1,'Retail Sale Id 1937',2302.80,0.00,0.00,3.03,-15.15,'2022-08-09 09:03:57','',''),(1922,'1','277','1',1,'Retail Sale Id 1938',4552.40,0.00,0.00,5.99,-29.95,'2022-08-09 09:12:09','',''),(1923,'1','277','1',1,'Retail Sale Id 1939',4552.40,0.00,0.00,5.99,-29.95,'2022-08-09 09:15:02','',''),(1924,'1','277','1',1,'Retail Sale Id 1940',1998.80,0.00,0.00,2.63,-13.15,'2022-08-09 09:29:42','',''),(1925,'1','277','1',1,'Retail Sale Id 1941',3800.00,0.00,0.00,5.00,-25.00,'2022-08-09 09:32:23','',''),(1926,'1','277','1',1,'Retail Sale Id 1942',9500.00,0.00,0.00,12.50,-62.50,'2022-08-09 09:36:25','',''),(1927,'1','277','1',1,'Retail Sale Id 1943',3002.00,0.00,0.00,3.95,-19.75,'2022-08-09 09:38:07','',''),(1928,'1','277','1',1,'Retail Sale Id 1944',2302.80,0.00,0.00,3.03,-15.15,'2022-08-09 09:38:56','',''),(1929,'1','277','1',1,'Retail Sale Id 1945',4397.12,0.00,0.00,6.04,-223.48,'2022-08-09 10:07:48','',''),(1930,'1','277','1',1,'Retail Sale Id 1946',2198.56,0.00,0.00,3.02,-111.74,'2022-08-09 10:09:04','',''),(1931,'1','277','1',1,'Retail Sale Id 1947',749.84,0.00,0.00,1.03,-38.11,'2022-08-09 10:27:29','',''),(1932,'1','277','1',1,'Retail Sale Id 1948',3698.24,0.00,0.00,5.08,-187.96,'2022-08-09 10:38:29','',''),(1933,'1','277','1',1,'Retail Sale Id 1949',2002.00,0.00,0.00,2.75,-101.75,'2022-08-09 10:39:08','',''),(1934,'1','277','1',1,'Retail Sale Id 1950',9100.00,0.00,0.00,12.50,-462.50,'2022-08-09 10:55:28','',''),(1935,'1','277','1',1,'Retail Sale Id 1951',2198.56,0.00,0.00,3.02,-111.74,'2022-08-09 11:00:30','',''),(1936,'1','277','1',1,'Retail Sale Id 1952',749.84,0.00,0.00,1.03,-38.11,'2022-08-09 11:20:02','',''),(1937,'1','277','1',1,'Retail Sale Id 1953',14560.00,0.00,0.00,20.00,-740.00,'2022-08-09 11:31:23','',''),(1938,'1','277','1',1,'Retail Sale Id 1954',2198.56,0.00,0.00,3.02,-111.74,'2022-08-09 11:34:49','',''),(1939,'1','277','1',1,'Retail Sale Id 1955',2198.56,0.00,0.00,3.02,-111.74,'2022-08-09 11:46:55','',''),(1940,'1','277','1',1,'Retail Sale Id 1958',4368.00,0.00,0.00,6.00,-222.00,'2022-08-09 12:08:07','',''),(1941,'1','277','1',1,'Retail Sale Id 1959',9100.00,0.00,0.00,12.50,-462.50,'2022-08-09 12:11:06','',''),(1942,'1','277','1',1,'Retail Sale Id 1960',2999.36,0.00,0.00,4.12,-152.44,'2022-08-09 12:13:44','',''),(1943,'1','277','1',1,'Retail Sale Id 1961',9100.00,0.00,0.00,12.50,-462.50,'2022-08-09 12:16:03','',''),(1944,'1','277','1',1,'Retail Sale Id 1962',2002.00,0.00,0.00,2.75,-101.75,'2022-08-09 12:18:35','',''),(1945,'1','277','1',1,'Retail Sale Id 1963',7280.00,0.00,0.00,10.00,-370.00,'2022-08-09 12:19:45','',''),(1946,'1','277','1',1,'Retail Sale Id 1964',3996.72,0.00,0.00,5.49,-203.13,'2022-08-09 12:45:10','',''),(1947,'1','277','1',1,'Retail Sale Id 1965',3996.72,0.00,0.00,5.49,-203.13,'2022-08-09 12:52:43','',''),(1948,'1','277','1',1,'Retail Sale Id 1966',1499.68,0.00,0.00,2.06,-76.22,'2022-08-09 12:53:59','',''),(1949,'1','277','1',1,'Retail Sale Id 1967',2198.56,0.00,0.00,3.02,-111.74,'2022-08-09 12:55:26','',''),(1950,'1','277','1',1,'Retail Sale Id 1968',9100.00,0.00,0.00,12.50,-462.50,'2022-08-09 13:00:55','',''),(1951,'1','277','1',1,'Retail Sale Id 1969',5001.36,0.00,0.00,6.87,-254.19,'2022-08-09 13:18:03','',''),(1952,'1','277','1',1,'Retail Sale Id 1970',9100.00,0.00,0.00,12.50,-462.50,'2022-08-09 13:22:04','',''),(1953,'1','277','1',1,'Retail Sale Id 1970',9100.00,0.00,0.00,12.50,-462.50,'2022-08-09 13:22:04','',''),(1954,'1','277','1',1,'Retail Sale Id 1971',9100.00,0.00,0.00,12.50,-462.50,'2022-08-09 13:33:57','',''),(1955,'1','277','1',1,'Retail Sale Id 1972',4397.12,0.00,0.00,6.04,-223.48,'2022-08-09 13:42:39','',''),(1956,'1','277','1',1,'Retail Sale Id 1973',35500.00,0.00,0.00,50.00,-2750.00,'2022-08-09 13:52:49','',''),(1957,'1','277','1',1,'Return of Retail Sale Id 1973',0.00,35500.00,50.00,0.00,2750.00,'2022-08-09 13:54:28','',''),(1958,'1','277','1',1,'Retail Sale Id 1974',2198.56,0.00,0.00,3.02,-111.74,'2022-08-09 14:07:56','',''),(1959,'1','277','1',1,'Retail Sale Id 1975',2002.00,0.00,0.00,2.75,-101.75,'2022-08-09 14:22:46','',''),(1960,'1','277','1',1,'Retail Sale Id 1976',502.32,0.00,0.00,0.69,-25.53,'2022-08-09 14:56:01','',''),(1961,'1','277','1',1,'Return of Retail Sale Id 1976',0.00,502.32,0.69,0.00,25.53,'2022-08-09 14:57:42','',''),(1962,'1','277','1',1,'Retail Sale Id 1977',698.88,0.00,0.00,0.96,-35.52,'2022-08-09 14:58:12','',''),(1963,'1','277','1',1,'Retail Sale Id 1978',3501.68,0.00,0.00,4.81,-177.97,'2022-08-09 15:05:50','',''),(1964,'1','277','1',1,'Retail Sale Id 1980',1499.68,0.00,0.00,2.06,-76.22,'2022-08-09 15:21:07','',''),(1965,'1','277','1',1,'Retail Sale Id 1981',800.80,0.00,0.00,1.10,-40.70,'2022-08-09 15:39:45','',''),(1966,'1','277','1',1,'Retail Sale Id 1982',9100.00,0.00,0.00,12.50,-462.50,'2022-08-09 15:53:47','',''),(1967,'1','277','1',1,'Retail Sale Id 1983',4302.48,0.00,0.00,5.91,-218.67,'2022-08-09 15:55:21','',''),(1968,'1','277','1',1,'Retail Sale Id 1984',1499.68,0.00,0.00,2.06,-76.22,'2022-08-09 16:13:30','',''),(1969,'1','277','1',1,'Retail Sale Id 1985',1499.68,0.00,0.00,2.06,-76.22,'2022-08-09 16:30:34','',''),(1970,'1','277','1',1,'Retail Sale Id 1986',2999.36,0.00,0.00,4.12,-152.44,'2022-08-09 16:33:23','',''),(1971,'1','277','1',1,'Retail Sale Id 1987',3996.72,0.00,0.00,5.49,-203.13,'2022-08-09 16:36:33','',''),(1972,'1','277','1',1,'Retail Sale Id 1988',9100.00,0.00,0.00,12.50,-462.50,'2022-08-09 16:38:46','',''),(1973,'1','277','1',1,'Retail Sale Id 1989',1499.68,0.00,0.00,2.06,-76.22,'2022-08-09 16:42:44','',''),(1974,'1','277','1',1,'Retail Sale Id 1990',9100.00,0.00,0.00,12.50,-462.50,'2022-08-09 16:46:31','',''),(1975,'1','277','1',1,'Retail Sale Id 1991',19998.16,0.00,0.00,27.47,-1016.39,'2022-08-09 16:53:32','',''),(1976,'1','277','1',1,'Retail Sale Id 1992',2002.00,0.00,0.00,2.75,-101.75,'2022-08-09 16:55:26','',''),(1977,'1','277','1',1,'Retail Sale Id 1993',2497.04,0.00,0.00,3.43,-126.91,'2022-08-09 17:02:37','',''),(1978,'1','277','1',1,'Retail Sale Id 1994',2999.36,0.00,0.00,4.12,-152.44,'2022-08-09 17:11:55','',''),(1979,'1','277','1',1,'Retail Sale Id 1996',997.36,0.00,0.00,1.37,-50.69,'2022-08-09 17:17:34','',''),(1980,'1','277','1',1,'Retail Sale Id 1997',8903.44,0.00,0.00,12.23,-452.51,'2022-08-09 17:23:34','',''),(1981,'1','277','1',1,'Retail Sale Id 1998',997.36,0.00,0.00,1.37,-50.69,'2022-08-09 17:35:06','',''),(1982,'1','277','1',1,'Retail Sale Id 1999',2300.48,0.00,0.00,3.16,-116.92,'2022-08-09 17:39:50','',''),(1983,'1','277','1',1,'Retail Sale Id 2001',2002.00,0.00,0.00,2.75,-101.75,'2022-08-09 17:50:12','',''),(1984,'1','277','1',1,'Retail Sale Id 2003',1499.68,0.00,0.00,2.06,-76.22,'2022-08-09 17:58:17','',''),(1985,'1','277','1',1,'Retail Sale Id 2005',997.36,0.00,0.00,1.37,-50.69,'2022-08-09 17:59:03','',''),(1986,'1','277','1',1,'Retail Sale Id 2006',2198.56,0.00,0.00,3.02,-111.74,'2022-08-09 18:03:59','',''),(1987,'1','277','1',1,'Retail Sale Id 2007',800.80,0.00,0.00,1.10,-40.70,'2022-08-09 18:07:05','',''),(1988,'1','277','1',1,'Retail Sale Id 2008',997.36,0.00,0.00,1.37,-50.69,'2022-08-09 18:17:55','',''),(1989,'1','277','1',1,'Retail Sale Id 2009',997.36,0.00,0.00,1.37,-50.69,'2022-08-09 18:18:52','',''),(1990,'1','277','1',1,'Retail Sale Id 2010',2198.56,0.00,0.00,3.02,-111.74,'2022-08-09 18:21:59','',''),(1991,'1','277','1',1,'Retail Sale Id 2011',2198.56,0.00,0.00,3.02,-111.74,'2022-08-09 18:36:46','',''),(1992,'1','277','1',1,'Retail Sale Id 2012',2002.00,0.00,0.00,2.75,-101.75,'2022-08-09 18:38:30','',''),(1993,'1','277','1',1,'Retail Sale Id 2013',3800.16,0.00,0.00,5.22,-193.14,'2022-08-09 18:44:58','',''),(1994,'1','277','1',1,'Retail Sale Id 2014',4397.12,0.00,0.00,6.04,-223.48,'2022-08-09 18:47:38','',''),(1995,'1','277','1',1,'Retail Sale Id 2015',2198.56,0.00,0.00,3.02,-111.74,'2022-08-09 19:01:03','',''),(1996,'1','277','1',1,'Retail Sale Id 2016',2002.00,0.00,0.00,2.75,-101.75,'2022-08-09 19:08:43','',''),(1997,'1','277','1',1,'Retail Sale Id 2017',9100.00,0.00,0.00,12.50,-462.50,'2022-08-09 19:13:45','',''),(1998,'1','277','1',1,'Retail Sale Id 2018',997.36,0.00,0.00,1.37,-50.69,'2022-08-09 19:16:48','',''),(1999,'1','277','1',1,'Retail Sale Id 2019',749.84,0.00,0.00,1.03,-38.11,'2022-08-09 19:17:49','',''),(2000,'1','277','1',1,'Return of Retail Sale Id 2018',0.00,997.36,1.37,0.00,50.69,'2022-08-09 19:18:37','',''),(2001,'1','277','1',1,'Retail Sale Id 2020',1499.68,0.00,0.00,2.06,-76.22,'2022-08-09 19:21:34','',''),(2002,'1','277','1',1,'Retail Sale Id 2021',3996.72,0.00,0.00,5.49,-203.13,'2022-08-10 07:08:20','',''),(2003,'1','277','1',1,'Retail Sale Id 2022',800.80,0.00,0.00,1.10,-40.70,'2022-08-10 07:21:13','',''),(2004,'1','277','1',1,'Retail Sale Id 2023',800.80,0.00,0.00,1.10,-40.70,'2022-08-10 07:23:59','',''),(2005,'1','277','1',1,'Retail Sale Id 2024',4397.12,0.00,0.00,6.04,-223.48,'2022-08-10 07:29:19','',''),(2006,'1','277','1',1,'Retail Sale Id 2025',800.80,0.00,0.00,1.10,-40.70,'2022-08-10 07:32:30','',''),(2007,'1','277','1',1,'Retail Sale Id 2026',997.36,0.00,0.00,1.37,-50.69,'2022-08-10 08:32:43','',''),(2008,'1','277','1',1,'Retail Sale Id 2027',2198.56,0.00,0.00,3.02,-111.74,'2022-08-10 08:36:12','',''),(2009,'1','277','1',1,'Retail Sale Id 2028',3640.00,0.00,0.00,5.00,-185.00,'2022-08-10 08:37:47','',''),(2010,'1','277','1',1,'Retail Sale Id 2029',2999.36,0.00,0.00,4.12,-152.44,'2022-08-10 08:38:37','',''),(2011,'1','277','1',1,'Retail Sale Id 2030',1499.68,0.00,0.00,2.06,-76.22,'2022-08-10 08:48:59','',''),(2012,'1','277','1',1,'Retail Sale Id 2031',800.80,0.00,0.00,1.10,-40.70,'2022-08-10 08:50:01','',''),(2013,'1','277','1',1,'Retail Sale Id 2032',2999.36,0.00,0.00,4.12,-152.44,'2022-08-10 08:55:44','',''),(2014,'1','277','1',1,'Retail Sale Id 2033',800.80,0.00,0.00,1.10,-40.70,'2022-08-10 08:56:41','',''),(2015,'1','277','1',1,'Retail Sale Id 2034',1456.00,0.00,0.00,2.00,-74.00,'2022-08-10 08:58:51','',''),(2016,'1','277','1',1,'Retail Sale Id 2035',3996.72,0.00,0.00,5.49,-203.13,'2022-08-10 09:00:18','',''),(2017,'1','277','1',1,'Retail Sale Id 2036',4368.00,0.00,0.00,6.00,-222.00,'2022-08-10 09:09:12','',''),(2018,'1','277','1',1,'Retail Sale Id 2037',502.32,0.00,0.00,0.69,-25.53,'2022-08-10 09:11:34','',''),(2019,'1','277','1',1,'Retail Sale Id 2038',8102.64,0.00,0.00,11.13,-411.81,'2022-08-10 09:37:08','',''),(2020,'1','277','1',1,'Retail Sale Id 2039',2198.56,0.00,0.00,3.02,-111.74,'2022-08-10 09:52:15','',''),(2021,'1','277','1',1,'Retail Sale Id 2040',4397.12,0.00,0.00,6.04,-223.48,'2022-08-10 09:57:47','',''),(2022,'1','277','1',1,'Retail Sale Id 2041',5802.16,0.00,0.00,7.97,-294.89,'2022-08-10 10:02:42','',''),(2023,'1','277','1',1,'Retail Sale Id 2042',2497.04,0.00,0.00,3.43,-126.91,'2022-08-10 10:16:20','',''),(2024,'1','277','1',1,'Retail Sale Id 2043',2198.56,0.00,0.00,3.02,-111.74,'2022-08-10 10:30:11','',''),(2025,'1','277','1',1,'Retail Sale Id 2044',2184.00,0.00,0.00,3.00,-111.00,'2022-08-10 10:52:14','',''),(2026,'1','277','1',1,'Retail Sale Id 2045',4397.12,0.00,0.00,6.04,-223.48,'2022-08-10 10:56:51','',''),(2027,'1','277','1',1,'Retail Sale Id 2046',8000.72,0.00,0.00,10.99,-406.63,'2022-08-10 11:14:55','',''),(2028,'1','277','1',1,'Retail Sale Id 2047',4397.12,0.00,0.00,6.04,-223.48,'2022-08-10 11:17:48','',''),(2029,'1','277','1',1,'Retail Sale Id 2048',4397.12,0.00,0.00,6.04,-223.48,'2022-08-10 11:18:33','',''),(2030,'1','277','1',1,'Retail Sale Id 2049',1499.68,0.00,0.00,2.06,-76.22,'2022-08-10 11:19:36','',''),(2031,'1','277','1',1,'Retail Sale Id 2050',1499.68,0.00,0.00,2.06,-76.22,'2022-08-10 11:21:12','',''),(2032,'1','277','1',1,'Retail Sale Id 2051',800.80,0.00,0.00,1.10,-40.70,'2022-08-10 11:24:26','',''),(2033,'1','277','1',1,'Retail Sale Id 2052',1499.68,0.00,0.00,2.06,-76.22,'2022-08-10 11:27:13','',''),(2034,'1','277','1',1,'Retail Sale Id 2054',1397.76,0.00,0.00,1.92,-71.04,'2022-08-10 11:37:49','',''),(2035,'1','277','1',1,'Retail Sale Id 2055',4397.12,0.00,0.00,6.04,-223.48,'2022-08-10 11:40:17','',''),(2036,'1','277','1',1,'Retail Sale Id 2056',9100.00,0.00,0.00,12.50,-462.50,'2022-08-10 11:42:51','',''),(2037,'1','277','1',1,'Retail Sale Id 2057',1499.68,0.00,0.00,2.06,-76.22,'2022-08-10 11:44:51','',''),(2038,'1','277','1',1,'Return of Retail Sale Id 2055',0.00,4397.12,6.04,0.00,223.48,'2022-08-10 11:52:50','',''),(2039,'1','277','1',1,'Retail Sale Id 2058',3705.52,0.00,0.00,5.09,-188.33,'2022-08-10 11:53:55','',''),(2040,'1','277','1',1,'Retail Sale Id 2059',4105.92,0.00,0.00,5.64,-208.68,'2022-08-10 12:00:32','',''),(2041,'1','277','1',1,'Return of Retail Sale Id 2058',0.00,3705.52,5.09,0.00,188.33,'2022-08-10 12:01:13','',''),(2042,'1','277','1',1,'Retail Sale Id 2060',2999.36,0.00,0.00,4.12,-152.44,'2022-08-10 12:09:48','',''),(2043,'1','277','1',1,'Retail Sale Id 2061',2999.36,0.00,0.00,4.12,-152.44,'2022-08-10 12:13:08','',''),(2044,'1','277','1',1,'Retail Sale Id 2062',2002.00,0.00,0.00,2.75,-101.75,'2022-08-10 12:15:58','',''),(2045,'1','277','1',1,'Retail Sale Id 2063',3640.00,0.00,0.00,5.00,-185.00,'2022-08-10 12:17:26','',''),(2046,'1','277','1',1,'Retail Sale Id 2064',2002.00,0.00,0.00,2.75,-101.75,'2022-08-10 12:18:06','',''),(2047,'1','277','1',1,'Retail Sale Id 2065',502.32,0.00,0.00,0.69,-25.53,'2022-08-10 12:35:29','',''),(2048,'1','277','1',1,'Retail Sale Id 2066',1201.20,0.00,0.00,1.65,-61.05,'2022-08-10 16:57:38','',''),(2049,'1','277','1',1,'Retail Sale Id 2067',749.84,0.00,0.00,1.03,-38.11,'2022-08-10 16:58:24','',''),(2050,'1','277','1',1,'Retail Sale Id 2068',2198.56,0.00,0.00,3.02,-111.74,'2022-08-10 17:00:32','',''),(2051,'1','277','1',1,'Retail Sale Id 2069',5103.28,0.00,0.00,7.01,-259.37,'2022-08-10 17:01:52','',''),(2052,'1','277','1',1,'Retail Sale Id 2070',13417.04,0.00,0.00,18.43,-681.91,'2022-08-10 17:07:42','',''),(2053,'1','277','1',1,'Retail Sale Id 2071',9100.00,0.00,0.00,12.50,-462.50,'2022-08-10 17:08:22','',''),(2054,'1','277','1',1,'Retail Sale Id 2076',8736.00,0.00,0.00,12.00,-444.00,'2022-08-10 17:10:37','',''),(2055,'1','277','1',1,'Retail Sale Id 2077',2002.00,0.00,0.00,2.75,-101.75,'2022-08-10 17:11:56','',''),(2056,'1','277','1',1,'Retail Sale Id 2078',2198.56,0.00,0.00,3.02,-111.74,'2022-08-10 17:12:41','',''),(2057,'1','277','1',1,'Retail Sale Id 2079',749.84,0.00,0.00,1.03,-38.11,'2022-08-10 17:13:42','',''),(2058,'1','277','1',1,'Retail Sale Id 2080',9100.00,0.00,0.00,12.50,-462.50,'2022-08-10 17:15:08','',''),(2059,'1','277','1',1,'Retail Sale Id 2081',5001.36,0.00,0.00,6.87,-254.19,'2022-08-10 17:17:27','',''),(2060,'1','277','1',1,'Retail Sale Id 2082',2198.56,0.00,0.00,3.02,-111.74,'2022-08-10 17:18:19','',''),(2061,'1','277','1',1,'Retail Sale Id 2083',2002.00,0.00,0.00,2.75,-101.75,'2022-08-10 17:19:02','',''),(2062,'1','277','1',1,'Retail Sale Id 2084',8801.52,0.00,0.00,12.09,-447.33,'2022-08-10 17:20:09','',''),(2063,'1','277','1',1,'Retail Sale Id 2085',19000.80,0.00,0.00,26.10,-965.70,'2022-08-10 17:21:28','',''),(2064,'1','277','1',1,'Retail Sale Id 2086',37018.80,0.00,0.00,50.85,-1881.45,'2022-08-10 17:22:57','',''),(2065,'1','277','1',1,'Retail Sale Id 2088',6901.44,0.00,0.00,9.48,-350.76,'2022-08-10 17:25:38','',''),(2066,'1','277','1',1,'Retail Sale Id 2089',18200.00,0.00,0.00,25.00,-925.00,'2022-08-10 17:26:36','',''),(2067,'1','277','1',1,'Retail Sale Id 2090',12638.08,0.00,0.00,17.36,-642.32,'2022-08-10 17:31:02','',''),(2068,'1','277','1',1,'Retail Sale Id 2091',19699.68,0.00,0.00,27.06,-1001.22,'2022-08-10 17:50:29','',''),(2069,'1','277','1',1,'Retail Sale Id 2092',4397.12,0.00,0.00,6.04,-223.48,'2022-08-10 17:51:59','',''),(2070,'1','277','1',1,'Retail Sale Id 2093',2184.00,0.00,0.00,3.00,-111.00,'2022-08-10 17:52:36','',''),(2071,'1','277','1',1,'Retail Sale Id 2094',997.36,0.00,0.00,1.37,-50.69,'2022-08-10 17:55:32','',''),(2072,'1','277','1',1,'Retail Sale Id 2095',2198.56,0.00,0.00,3.02,-111.74,'2022-08-10 17:56:14','',''),(2073,'1','277','1',1,'Retail Sale Id 2096',997.36,0.00,0.00,1.37,-50.69,'2022-08-10 18:05:14','',''),(2074,'1','277','1',1,'Retail Sale Id 2097',2002.00,0.00,0.00,2.75,-101.75,'2022-08-10 18:22:06','',''),(2075,'1','277','1',1,'Retail Sale Id 2098',2002.00,0.00,0.00,2.75,-101.75,'2022-08-10 18:22:49','',''),(2076,'1','277','1',1,'Retail Sale Id 2099',3640.00,0.00,0.00,5.00,-185.00,'2022-08-10 18:23:45','',''),(2077,'1','277','1',1,'Retail Sale Id 2100',19880.00,0.00,0.00,28.00,-1540.00,'2022-08-10 18:27:00','',''),(2078,'1','277','1',1,'Retail Sale Id 2101',997.36,0.00,0.00,1.37,-50.69,'2022-08-10 18:27:49','',''),(2079,'1','277','1',1,'Retail Sale Id 2102',1499.68,0.00,0.00,2.06,-76.22,'2022-08-10 18:28:32','',''),(2080,'1','277','1',1,'Retail Sale Id 2103',4397.12,0.00,0.00,6.04,-223.48,'2022-08-10 18:33:10','',''),(2081,'1','277','1',1,'Retail Sale Id 2104',997.36,0.00,0.00,1.37,-50.69,'2022-08-10 18:41:10','',''),(2082,'1','277','1',1,'Retail Sale Id 2105',997.36,0.00,0.00,1.37,-50.69,'2022-08-10 18:41:52','',''),(2083,'1','277','1',1,'Retail Sale Id 2106',2198.56,0.00,0.00,3.02,-111.74,'2022-08-10 18:56:00','',''),(2084,'1','277','1',1,'Retail Sale Id 2107',997.36,0.00,0.00,1.37,-50.69,'2022-08-10 19:12:22','',''),(2085,'1','277','1',1,'Retail Sale Id 2108',4397.12,0.00,0.00,6.04,-223.48,'2022-08-10 19:13:07','',''),(2086,'1','277','1',1,'Return of Retail Sale Id 2101',0.00,997.36,1.37,0.00,50.69,'2022-08-10 19:38:12','',''),(2087,'1','277','1',1,'Retail Sale Id 2109',968.24,0.00,0.00,1.33,-49.21,'2022-08-10 19:39:49','',''),(2088,'1','277','1',1,'Retail Sale Id 2110',698.88,0.00,0.00,0.96,-35.52,'2022-08-11 06:49:02','',''),(2089,'1','277','1',1,'Retail Sale Id 2111',1499.68,0.00,0.00,2.06,-76.22,'2022-08-11 07:20:41','',''),(2090,'1','277','1',1,'Retail Sale Id 2112',2002.00,0.00,0.00,2.75,-101.75,'2022-08-11 07:22:00','',''),(2091,'1','277','1',1,'Retail Sale Id 2113',800.80,0.00,0.00,1.10,-40.70,'2022-08-11 07:33:12','',''),(2092,'1','277','1',1,'Retail Sale Id 2114',2198.56,0.00,0.00,3.02,-111.74,'2022-08-11 07:35:48','',''),(2093,'1','277','1',1,'Retail Sale Id 2115',2999.36,0.00,0.00,4.12,-152.44,'2022-08-11 07:38:05','',''),(2094,'1','277','1',1,'Retail Sale Id 2116',2999.36,0.00,0.00,4.12,-152.44,'2022-08-11 07:47:37','',''),(2095,'1','277','1',1,'Retail Sale Id 2118',2184.00,0.00,0.00,3.00,-111.00,'2022-08-11 07:55:38','',''),(2096,'1','277','1',1,'Retail Sale Id 2118',4368.00,0.00,0.00,6.00,-222.00,'2022-08-11 07:55:38','',''),(2097,'1','277','1',1,'Retail Sale Id 2118',7280.00,0.00,0.00,10.00,-370.00,'2022-08-11 07:55:38','',''),(2098,'1','277','1',1,'Retail Sale Id 2119',4368.00,0.00,0.00,6.00,-222.00,'2022-08-11 08:11:43','',''),(2099,'1','277','1',1,'Retail Sale Id 2120',2999.36,0.00,0.00,4.12,-152.44,'2022-08-11 08:39:04','',''),(2100,'1','277','1',1,'Retail Sale Id 2121',4353.44,0.00,0.00,5.98,-221.26,'2022-08-11 08:41:17','',''),(2101,'1','277','1',1,'Retail Sale Id 2122',2198.56,0.00,0.00,3.02,-111.74,'2022-08-11 08:48:18','',''),(2102,'1','277','1',1,'Retail Sale Id 2123',800.80,0.00,0.00,1.10,-40.70,'2022-08-11 08:56:33','',''),(2103,'1','277','1',1,'Retail Sale Id 2124',2249.52,0.00,0.00,3.09,-114.33,'2022-08-11 09:02:09','',''),(2104,'1','277','1',1,'Retail Sale Id 2125',2198.56,0.00,0.00,3.02,-111.74,'2022-08-11 09:09:46','',''),(2105,'1','277','1',1,'Retail Sale Id 2126',2002.00,0.00,0.00,2.75,-101.75,'2022-08-11 09:11:43','',''),(2106,'1','277','1',1,'Retail Sale Id 2127',2002.00,0.00,0.00,2.75,-101.75,'2022-08-11 09:17:13','',''),(2107,'1','277','1',1,'Retail Sale Id 2128',18200.00,0.00,0.00,25.00,-925.00,'2022-08-11 09:22:58','',''),(2108,'1','277','1',1,'Retail Sale Id 2129',4397.12,0.00,0.00,6.04,-223.48,'2022-08-11 09:34:00','',''),(2109,'1','277','1',1,'Retail Sale Id 2130',7280.00,0.00,0.00,10.00,-370.00,'2022-08-11 09:52:38','',''),(2110,'1','277','1',1,'Retail Sale Id 2131',2497.04,0.00,0.00,3.43,-126.91,'2022-08-11 09:53:26','',''),(2111,'1','277','1',1,'Retail Sale Id 2132',997.36,0.00,0.00,1.37,-50.69,'2022-08-11 10:01:09','',''),(2112,'1','277','1',1,'Retail Sale Id 2133',1201.20,0.00,0.00,1.65,-61.05,'2022-08-11 10:07:15','',''),(2113,'1','277','1',1,'Retail Sale Id 2134',4397.12,0.00,0.00,6.04,-223.48,'2022-08-11 10:11:48','',''),(2114,'1','277','1',1,'Retail Sale Id 2135',1499.68,0.00,0.00,2.06,-76.22,'2022-08-11 10:17:35','',''),(2115,'1','277','1',1,'Retail Sale Id 2136',9966.32,0.00,0.00,13.69,-506.53,'2022-08-11 10:52:35','',''),(2116,'1','277','1',1,'Retail Sale Id 2137',2002.00,0.00,0.00,2.75,-101.75,'2022-08-11 12:12:22','',''),(2117,'1','277','1',1,'Retail Sale Id 2138',3996.72,0.00,0.00,5.49,-203.13,'2022-08-11 12:13:23','',''),(2118,'1','277','1',1,'Retail Sale Id 2139',3618.16,0.00,0.00,4.97,-183.89,'2022-08-11 12:21:16','',''),(2119,'1','277','1',1,'Retail Sale Id 2140',9100.00,0.00,0.00,12.50,-462.50,'2022-08-11 12:41:33','',''),(2120,'1','277','1',1,'Retail Sale Id 2141',1499.68,0.00,0.00,2.06,-76.22,'2022-08-11 12:49:56','',''),(2121,'1','277','1',1,'Retail Sale Id 2142',2198.56,0.00,0.00,3.02,-111.74,'2022-08-11 13:04:08','',''),(2122,'1','277','1',1,'Retail Sale Id 2143',2198.56,0.00,0.00,3.02,-111.74,'2022-08-11 13:08:07','',''),(2123,'1','277','1',1,'Retail Sale Id 2144',2002.00,0.00,0.00,2.75,-101.75,'2022-08-11 13:12:05','',''),(2124,'1','277','1',1,'Retail Sale Id 2145',2999.36,0.00,0.00,4.12,-152.44,'2022-08-11 13:23:54','',''),(2125,'1','277','1',1,'Retail Sale Id 2146',2096.64,0.00,0.00,2.88,-106.56,'2022-08-11 13:38:58','',''),(2126,'1','277','1',1,'Retail Sale Id 2147',2198.56,0.00,0.00,3.02,-111.74,'2022-08-11 13:41:35','',''),(2127,'1','277','1',1,'Retail Sale Id 2148',997.36,0.00,0.00,1.37,-50.69,'2022-08-11 13:47:15','',''),(2128,'1','277','1',1,'Retail Sale Id 2149',34790.00,0.00,0.00,49.00,-2695.00,'2022-08-11 13:51:11','',''),(2129,'1','277','1',1,'Retail Sale Id 2150',2002.00,0.00,0.00,2.75,-101.75,'2022-08-11 13:55:06','',''),(2130,'1','277','1',1,'Retail Sale Id 2151',2198.56,0.00,0.00,3.02,-111.74,'2022-08-11 13:59:31','',''),(2131,'1','277','1',1,'Retail Sale Id 2152',2999.36,0.00,0.00,4.12,-152.44,'2022-08-11 14:02:17','',''),(2132,'1','277','1',1,'Retail Sale Id 2153',7003.36,0.00,0.00,9.62,-355.94,'2022-08-11 14:03:06','',''),(2133,'1','277','1',1,'Retail Sale Id 2154',3996.72,0.00,0.00,5.49,-203.13,'2022-08-11 14:04:03','',''),(2134,'1','277','1',1,'Retail Sale Id 2155',2198.56,0.00,0.00,3.02,-111.74,'2022-08-11 14:05:17','',''),(2135,'1','277','1',1,'Retail Sale Id 2156',7301.84,0.00,0.00,10.03,-371.11,'2022-08-11 14:11:21','',''),(2136,'1','277','1',1,'Retail Sale Id 2158',4499.04,0.00,0.00,6.18,-228.66,'2022-08-11 14:26:24','',''),(2137,'1','277','1',1,'Retail Sale Id 2159',4368.00,0.00,0.00,6.00,-222.00,'2022-08-11 14:40:49','',''),(2138,'1','277','1',1,'Retail Sale Id 2160',4397.12,0.00,0.00,6.04,-223.48,'2022-08-11 14:47:50','',''),(2139,'1','277','1',1,'Retail Sale Id 2161',2002.00,0.00,0.00,2.75,-101.75,'2022-08-11 15:08:20','',''),(2140,'1','277','1',1,'Retail Sale Id 2162',4397.12,0.00,0.00,6.04,-223.48,'2022-08-11 15:09:03','',''),(2141,'1','277','1',1,'Retail Sale Id 2163',1499.68,0.00,0.00,2.06,-76.22,'2022-08-11 15:10:54','',''),(2142,'1','277','1',1,'Retail Sale Id 2164',11000.08,0.00,0.00,15.11,-559.07,'2022-08-11 15:13:33','',''),(2143,'1','277','1',1,'Retail Sale Id 2165',4397.12,0.00,0.00,6.04,-223.48,'2022-08-11 15:22:33','',''),(2144,'1','277','1',1,'Retail Sale Id 2166',2002.00,0.00,0.00,2.75,-101.75,'2022-08-11 15:28:24','',''),(2145,'1','277','1',1,'Retail Sale Id 2167',9100.00,0.00,0.00,12.50,-462.50,'2022-08-11 15:29:42','',''),(2146,'1','277','1',1,'Retail Sale Id 2168',2497.04,0.00,0.00,3.43,-126.91,'2022-08-11 15:31:32','',''),(2147,'1','277','1',1,'Retail Sale Id 2169',2802.80,0.00,0.00,3.85,-142.45,'2022-08-11 15:35:29','',''),(2148,'1','277','1',1,'Retail Sale Id 2170',24002.16,0.00,0.00,32.97,-1219.89,'2022-08-11 15:46:53','',''),(2149,'1','277','1',1,'Retail Sale Id 2171',9100.00,0.00,0.00,12.50,-462.50,'2022-08-11 15:47:37','',''),(2150,'1','277','1',1,'Retail Sale Id 2172',2897.44,0.00,0.00,3.98,-147.26,'2022-08-11 15:55:07','',''),(2151,'1','277','1',1,'Retail Sale Id 2173',6501.04,0.00,0.00,8.93,-330.41,'2022-08-11 15:56:45','',''),(2152,'1','277','1',1,'Retail Sale Id 2174',1201.20,0.00,0.00,1.65,-61.05,'2022-08-11 16:09:32','',''),(2153,'1','277','1',1,'Retail Sale Id 2175',2300.48,0.00,0.00,3.16,-116.92,'2022-08-11 16:11:17','',''),(2154,'1','277','1',1,'Retail Sale Id 2176',2497.04,0.00,0.00,3.43,-126.91,'2022-08-11 16:22:25','',''),(2155,'1','277','1',1,'Retail Sale Id 2177',3640.00,0.00,0.00,5.00,-185.00,'2022-08-11 16:24:59','',''),(2156,'1','277','1',1,'Retail Sale Id 2178',3698.24,0.00,0.00,5.08,-187.96,'2022-08-11 16:34:58','',''),(2157,'1','277','1',1,'Retail Sale Id 2179',9100.00,0.00,0.00,12.50,-462.50,'2022-08-11 16:36:30','',''),(2158,'1','277','1',1,'Retail Sale Id 2180',9100.00,0.00,0.00,12.50,-462.50,'2022-08-11 16:37:14','',''),(2159,'1','277','1',1,'Retail Sale Id 2181',3902.08,0.00,0.00,5.36,-198.32,'2022-08-11 16:38:20','',''),(2160,'1','277','1',1,'Retail Sale Id 2182',1201.20,0.00,0.00,1.65,-61.05,'2022-08-11 16:39:07','',''),(2161,'1','277','1',1,'Retail Sale Id 2183',2198.56,0.00,0.00,3.02,-111.74,'2022-08-11 16:39:46','',''),(2162,'1','277','1',1,'Retail Sale Id 2184',5001.36,0.00,0.00,6.87,-254.19,'2022-08-11 16:40:42','',''),(2163,'1','277','1',1,'Retail Sale Id 2185',2198.56,0.00,0.00,3.02,-111.74,'2022-08-11 16:41:49','',''),(2164,'1','277','1',1,'Retail Sale Id 2186',2198.56,0.00,0.00,3.02,-111.74,'2022-08-11 16:42:58','',''),(2165,'1','277','1',1,'Retail Sale Id 2187',1499.68,0.00,0.00,2.06,-76.22,'2022-08-11 16:43:45','',''),(2166,'1','277','1',1,'Retail Sale Id 2188',4397.12,0.00,0.00,6.04,-223.48,'2022-08-11 16:45:02','',''),(2167,'1','277','1',1,'Retail Sale Id 2189',2198.56,0.00,0.00,3.02,-111.74,'2022-08-11 16:46:10','',''),(2168,'1','277','1',1,'Retail Sale Id 2190',749.84,0.00,0.00,1.03,-38.11,'2022-08-11 17:02:13','',''),(2169,'1','277','1',1,'Retail Sale Id 2191',4397.12,0.00,0.00,6.04,-223.48,'2022-08-11 17:05:09','',''),(2170,'1','277','1',1,'Retail Sale Id 2192',2999.36,0.00,0.00,4.12,-152.44,'2022-08-11 17:06:48','',''),(2171,'1','277','1',1,'Retail Sale Id 2193',2198.56,0.00,0.00,3.02,-111.74,'2022-08-11 17:10:35','',''),(2172,'1','277','1',1,'Retail Sale Id 2194',2999.36,0.00,0.00,4.12,-152.44,'2022-08-11 17:13:15','',''),(2173,'1','277','1',1,'Retail Sale Id 2195',3640.00,0.00,0.00,5.00,-185.00,'2022-08-11 17:14:02','',''),(2174,'1','277','1',1,'Retail Sale Id 2196',1499.68,0.00,0.00,2.06,-76.22,'2022-08-11 17:16:38','',''),(2175,'1','277','1',1,'Retail Sale Id 2197',9100.00,0.00,0.00,12.50,-462.50,'2022-08-11 17:17:35','',''),(2176,'1','277','1',1,'Retail Sale Id 2198',4397.12,0.00,0.00,6.04,-223.48,'2022-08-11 17:19:10','',''),(2177,'1','277','1',1,'Retail Sale Id 2199',5103.28,0.00,0.00,7.01,-259.37,'2022-08-11 17:20:23','',''),(2178,'1','277','1',1,'Retail Sale Id 2200',2002.00,0.00,0.00,2.75,-101.75,'2022-08-11 17:22:35','',''),(2179,'1','277','1',1,'Retail Sale Id 2201',1499.68,0.00,0.00,2.06,-76.22,'2022-08-11 17:29:04','',''),(2180,'1','277','1',1,'Retail Sale Id 2202',2999.36,0.00,0.00,4.12,-152.44,'2022-08-11 17:29:50','',''),(2181,'1','277','1',1,'Retail Sale Id 2203',2198.56,0.00,0.00,3.02,-111.74,'2022-08-11 17:30:34','',''),(2182,'1','277','1',1,'Retail Sale Id 2204',2002.00,0.00,0.00,2.75,-101.75,'2022-08-11 17:45:12','',''),(2183,'1','277','1',1,'Retail Sale Id 2205',2198.56,0.00,0.00,3.02,-111.74,'2022-08-11 17:49:29','',''),(2184,'1','277','1',1,'Retail Sale Id 2206',997.36,0.00,0.00,1.37,-50.69,'2022-08-11 17:50:18','',''),(2185,'1','277','1',1,'Retail Sale Id 2207',1499.68,0.00,0.00,2.06,-76.22,'2022-08-11 17:51:00','',''),(2186,'1','277','1',1,'Retail Sale Id 2209',800.80,0.00,0.00,1.10,-40.70,'2022-08-11 17:56:48','',''),(2187,'1','277','1',1,'Retail Sale Id 2210',2497.04,0.00,0.00,3.43,-126.91,'2022-08-11 18:06:50','',''),(2188,'1','277','1',1,'Retail Sale Id 2211',1798.16,0.00,0.00,2.47,-91.39,'2022-08-11 18:09:38','',''),(2189,'1','277','1',1,'Retail Sale Id 2213',9100.00,0.00,0.00,12.50,-462.50,'2022-08-11 18:15:45','',''),(2190,'1','277','1',1,'Retail Sale Id 2214',2198.56,0.00,0.00,3.02,-111.74,'2022-08-11 18:18:28','',''),(2191,'1','277','1',1,'Retail Sale Id 2215',2497.04,0.00,0.00,3.43,-126.91,'2022-08-11 18:19:22','',''),(2192,'1','277','1',1,'Retail Sale Id 2216',2497.04,0.00,0.00,3.43,-126.91,'2022-08-11 18:32:19','',''),(2193,'1','277','1',1,'Retail Sale Id 2217',2198.56,0.00,0.00,3.02,-111.74,'2022-08-11 18:37:05','',''),(2194,'1','277','1',1,'Retail Sale Id 2218',4368.00,0.00,0.00,6.00,-222.00,'2022-08-11 18:39:13','',''),(2195,'1','277','1',1,'Retail Sale Id 2219',1499.68,0.00,0.00,2.06,-76.22,'2022-08-11 18:41:36','',''),(2196,'1','277','1',1,'Retail Sale Id 2220',2198.56,0.00,0.00,3.02,-111.74,'2022-08-11 18:43:05','',''),(2197,'1','277','1',1,'Retail Sale Id 2223',1499.68,0.00,0.00,2.06,-76.22,'2022-08-11 18:45:15','',''),(2198,'1','277','1',1,'Retail Sale Id 2224',2002.00,0.00,0.00,2.75,-101.75,'2022-08-11 18:47:02','',''),(2199,'1','277','1',1,'Retail Sale Id 2225',997.36,0.00,0.00,1.37,-50.69,'2022-08-11 18:49:22','',''),(2200,'1','277','1',1,'Retail Sale Id 2226',902.72,0.00,0.00,1.24,-45.88,'2022-08-11 18:51:52','',''),(2201,'1','277','1',1,'Retail Sale Id 2227',502.32,0.00,0.00,0.69,-25.53,'2022-08-11 18:52:59','',''),(2202,'1','277','1',1,'Retail Sale Id 2228',997.36,0.00,0.00,1.37,-50.69,'2022-08-11 19:11:24','',''),(2203,'1','277','1',1,'Retail Sale Id 2229',749.84,0.00,0.00,1.03,-38.11,'2022-08-11 19:12:11','',''),(2204,'1','277','1',1,'Retail Sale Id 2230',2002.00,0.00,0.00,2.75,-101.75,'2022-08-11 19:14:35','',''),(2205,'1','277','1',1,'Retail Sale Id 2231',749.84,0.00,0.00,1.03,-38.11,'2022-08-11 19:15:25','',''),(2206,'1','277','1',1,'Return of Retail Sale Id 2209',0.00,800.80,1.10,0.00,40.70,'2022-08-11 19:34:02','',''),(2207,'1','277','1',1,'Retail Sale Id 2232',815.36,0.00,0.00,1.12,-41.44,'2022-08-11 20:03:23','',''),(2208,'1','277','1',1,'Return of Retail Sale Id 2231',0.00,749.84,1.03,0.00,38.11,'2022-08-11 20:07:00','',''),(2209,'1','277','1',1,'Retail Sale Id 2233',698.88,0.00,0.00,0.96,-35.52,'2022-08-11 20:07:58','',''),(2210,'1','277','1',1,'Retail Sale Id 2234',50.96,0.00,0.00,0.07,-2.59,'2022-08-11 20:09:59','',''),(2211,'1','277','1',1,'Retail Sale Id 2235',9100.00,0.00,0.00,12.50,-462.50,'2022-08-12 06:44:44','',''),(2212,'1','277','1',1,'Retail Sale Id 2236',2497.04,0.00,0.00,3.43,-126.91,'2022-08-12 07:09:13','',''),(2213,'1','277','1',1,'Retail Sale Id 2237',2999.36,0.00,0.00,4.12,-152.44,'2022-08-12 07:26:20','',''),(2214,'1','277','1',1,'Retail Sale Id 2238',2198.56,0.00,0.00,3.02,-111.74,'2022-08-12 07:31:51','',''),(2215,'1','277','1',1,'Retail Sale Id 2239',728.00,0.00,0.00,1.00,-37.00,'2022-08-12 07:38:23','',''),(2216,'1','277','1',1,'Retail Sale Id 2240',2002.00,0.00,0.00,2.75,-101.75,'2022-08-12 07:50:51','',''),(2217,'1','277','1',1,'Retail Sale Id 2241',9100.00,0.00,0.00,12.50,-462.50,'2022-08-12 07:54:33','',''),(2218,'1','277','1',1,'Retail Sale Id 2242',4397.12,0.00,0.00,6.04,-223.48,'2022-08-12 07:55:21','',''),(2219,'1','277','1',1,'Retail Sale Id 2243',2198.56,0.00,0.00,3.02,-111.74,'2022-08-12 08:19:26','',''),(2220,'1','277','1',1,'Retail Sale Id 2244',2999.36,0.00,0.00,4.12,-152.44,'2022-08-12 08:24:45','',''),(2221,'1','277','1',1,'Retail Sale Id 2245',2198.56,0.00,0.00,3.02,-111.74,'2022-08-12 08:28:45','',''),(2222,'1','277','1',1,'Retail Sale Id 2246',502.32,0.00,0.00,0.69,-25.53,'2022-08-12 08:31:29','',''),(2223,'1','277','1',1,'Retail Sale Id 2247',5001.36,0.00,0.00,6.87,-254.19,'2022-08-12 08:54:14','',''),(2224,'1','277','1',1,'Retail Sale Id 2248',2999.36,0.00,0.00,4.12,-152.44,'2022-08-12 08:57:18','',''),(2225,'1','277','1',1,'Retail Sale Id 2249',4368.00,0.00,0.00,6.00,-222.00,'2022-08-12 08:59:43','',''),(2226,'1','277','1',1,'Retail Sale Id 2250',2999.36,0.00,0.00,4.12,-152.44,'2022-08-12 09:01:45','',''),(2227,'1','277','1',1,'Retail Sale Id 2251',502.32,0.00,0.00,0.69,-25.53,'2022-08-12 09:04:10','',''),(2228,'1','277','1',1,'Retail Sale Id 2252',2002.00,0.00,0.00,2.75,-101.75,'2022-08-12 09:06:58','',''),(2229,'1','277','1',1,'Retail Sale Id 2254',1703.52,0.00,0.00,2.34,-86.58,'2022-08-12 09:08:44','',''),(2230,'1','277','1',1,'Retail Sale Id 2255',1499.68,0.00,0.00,2.06,-76.22,'2022-08-12 09:15:30','',''),(2231,'1','277','1',1,'Retail Sale Id 2256',4397.12,0.00,0.00,6.04,-223.48,'2022-08-12 09:23:21','',''),(2232,'1','277','1',1,'Retail Sale Id 2257',997.36,0.00,0.00,1.37,-50.69,'2022-08-12 09:24:03','',''),(2233,'1','277','1',1,'Retail Sale Id 2258',3996.72,0.00,0.00,5.49,-203.13,'2022-08-12 09:26:54','',''),(2234,'1','277','1',1,'Retail Sale Id 2260',1397.76,0.00,0.00,1.92,-71.04,'2022-08-12 09:32:24','',''),(2235,'1','277','1',1,'Retail Sale Id 2261',1499.68,0.00,0.00,2.06,-76.22,'2022-08-12 10:41:41','',''),(2236,'1','277','1',1,'Retail Sale Id 2262',8000.72,0.00,0.00,10.99,-406.63,'2022-08-12 10:49:35','',''),(2237,'1','277','1',1,'Retail Sale Id 2263',7280.00,0.00,0.00,10.00,-370.00,'2022-08-12 10:52:25','',''),(2238,'1','277','1',1,'Retail Sale Id 2264',4397.12,0.00,0.00,6.04,-223.48,'2022-08-12 10:53:58','',''),(2239,'1','277','1',1,'Retail Sale Id 2265',2002.00,0.00,0.00,2.75,-101.75,'2022-08-12 10:54:45','',''),(2240,'1','277','1',1,'Retail Sale Id 2266',2198.56,0.00,0.00,3.02,-111.74,'2022-08-12 11:09:26','',''),(2241,'1','277','1',1,'Retail Sale Id 2267',5001.36,0.00,0.00,6.87,-254.19,'2022-08-12 12:46:20','',''),(2242,'1','277','1',1,'Retail Sale Id 2268',2999.36,0.00,0.00,4.12,-152.44,'2022-08-12 12:51:47','',''),(2243,'1','277','1',1,'Retail Sale Id 2269',2999.36,0.00,0.00,4.12,-152.44,'2022-08-12 13:05:00','',''),(2244,'1','277','1',1,'Retail Sale Id 2270',2999.36,0.00,0.00,4.12,-152.44,'2022-08-12 13:09:59','',''),(2245,'1','277','1',1,'Retail Sale Id 2271',3996.72,0.00,0.00,5.49,-203.13,'2022-08-12 13:12:59','',''),(2246,'1','277','1',1,'Retail Sale Id 2272',2198.56,0.00,0.00,3.02,-111.74,'2022-08-12 13:48:27','',''),(2247,'1','277','1',1,'Retail Sale Id 2273',2002.00,0.00,0.00,2.75,-101.75,'2022-08-12 13:49:15','',''),(2248,'1','277','1',1,'Retail Sale Id 2274',2198.56,0.00,0.00,3.02,-111.74,'2022-08-12 14:09:44','',''),(2249,'1','277','1',1,'Retail Sale Id 2275',10002.72,0.00,0.00,13.74,-508.38,'2022-08-12 14:17:36','',''),(2250,'1','277','1',1,'Retail Sale Id 2276',9100.00,0.00,0.00,12.50,-462.50,'2022-08-12 14:18:16','',''),(2251,'1','277','1',1,'Retail Sale Id 2277',2999.36,0.00,0.00,4.12,-152.44,'2022-08-12 14:19:10','',''),(2252,'1','277','1',1,'Retail Sale Id 2278',1601.60,0.00,0.00,2.20,-81.40,'2022-08-12 14:19:53','',''),(2253,'1','277','1',1,'Retail Sale Id 2279',997.36,0.00,0.00,1.37,-50.69,'2022-08-12 14:27:20','',''),(2254,'1','277','1',1,'Retail Sale Id 2280',2999.36,0.00,0.00,4.12,-152.44,'2022-08-12 14:28:17','',''),(2255,'1','277','1',1,'Retail Sale Id 2281',2249.52,0.00,0.00,3.09,-114.33,'2022-08-12 14:46:50','',''),(2256,'1','277','1',1,'Retail Sale Id 2282',997.36,0.00,0.00,1.37,-50.69,'2022-08-12 14:48:02','',''),(2257,'1','277','1',1,'Retail Sale Id 2283',1900.08,0.00,0.00,2.61,-96.57,'2022-08-12 14:51:19','',''),(2258,'1','277','1',1,'Retail Sale Id 2284',4397.12,0.00,0.00,6.04,-223.48,'2022-08-12 14:52:32','',''),(2259,'1','277','1',1,'Retail Sale Id 2285',2999.36,0.00,0.00,4.12,-152.44,'2022-08-12 15:01:10','',''),(2260,'1','277','1',1,'Retail Sale Id 2286',2002.00,0.00,0.00,2.75,-101.75,'2022-08-12 15:18:57','',''),(2261,'1','277','1',1,'Retail Sale Id 2287',4397.12,0.00,0.00,6.04,-223.48,'2022-08-12 15:30:34','',''),(2262,'1','277','1',1,'Retail Sale Id 2288',2002.00,0.00,0.00,2.75,-101.75,'2022-08-12 15:44:03','',''),(2263,'1','277','1',1,'Retail Sale Id 2289',2002.00,0.00,0.00,2.75,-101.75,'2022-08-12 15:45:35','',''),(2264,'1','277','1',1,'Retail Sale Id 2290',1201.20,0.00,0.00,1.65,-61.05,'2022-08-12 15:46:24','',''),(2265,'1','277','1',1,'Retail Sale Id 2291',4397.12,0.00,0.00,6.04,-223.48,'2022-08-12 15:54:26','',''),(2266,'1','277','1',1,'Retail Sale Id 2292',5001.36,0.00,0.00,6.87,-254.19,'2022-08-12 15:55:26','',''),(2267,'1','277','1',1,'Retail Sale Id 2293',3640.00,0.00,0.00,5.00,-185.00,'2022-08-12 16:01:23','',''),(2268,'1','277','1',1,'Retail Sale Id 2294',2198.56,0.00,0.00,3.02,-111.74,'2022-08-12 16:05:11','',''),(2269,'1','277','1',1,'Retail Sale Id 2295',2999.36,0.00,0.00,4.12,-152.44,'2022-08-12 16:06:42','',''),(2270,'1','277','1',1,'Retail Sale Id 2296',3640.00,0.00,0.00,5.00,-185.00,'2022-08-12 16:20:15','',''),(2271,'1','277','1',1,'Retail Sale Id 2296',4418.96,0.00,0.00,6.07,-224.59,'2022-08-12 16:20:15','',''),(2272,'1','277','1',1,'Return of Retail Sale Id 2296',0.00,3640.00,5.00,0.00,185.00,'2022-08-12 16:39:52','',''),(2273,'1','277','1',1,'Return of Retail Sale Id 2296',0.00,4418.96,6.07,0.00,224.59,'2022-08-12 16:39:52','',''),(2274,'1','277','1',1,'Retail Sale Id 2297',1397.76,0.00,0.00,1.92,-71.04,'2022-08-12 16:42:24','',''),(2275,'1','277','1',1,'Retail Sale Id 2298',4397.12,0.00,0.00,6.04,-223.48,'2022-08-12 16:45:26','',''),(2276,'1','277','1',1,'Retail Sale Id 2299',1499.68,0.00,0.00,2.06,-76.22,'2022-08-12 16:46:55','',''),(2277,'1','277','1',1,'Retail Sale Id 2300',997.36,0.00,0.00,1.37,-50.69,'2022-08-12 16:47:46','',''),(2278,'1','277','1',1,'Retail Sale Id 2301',18833.36,0.00,0.00,25.87,-957.19,'2022-08-12 16:49:13','',''),(2279,'1','277','1',1,'Retail Sale Id 2302',27001.52,0.00,0.00,37.09,-1372.33,'2022-08-12 16:50:46','',''),(2280,'1','277','1',1,'Retail Sale Id 2303',22764.56,0.00,0.00,31.27,-1156.99,'2022-08-12 16:51:44','',''),(2281,'1','277','1',1,'Retail Sale Id 2304',749.84,0.00,0.00,1.03,-38.11,'2022-08-12 16:53:18','',''),(2282,'1','277','1',1,'Retail Sale Id 2305',2999.36,0.00,0.00,4.12,-152.44,'2022-08-12 16:54:49','',''),(2283,'1','277','1',1,'Retail Sale Id 2306',2198.56,0.00,0.00,3.02,-111.74,'2022-08-12 16:55:37','',''),(2284,'1','277','1',1,'Retail Sale Id 2307',1499.68,0.00,0.00,2.06,-76.22,'2022-08-12 16:57:03','',''),(2285,'1','277','1',1,'Retail Sale Id 2308',749.84,0.00,0.00,1.03,-38.11,'2022-08-12 16:59:25','',''),(2286,'1','277','1',1,'Retail Sale Id 2309',698.88,0.00,0.00,0.96,-35.52,'2022-08-12 17:02:51','',''),(2287,'1','277','1',1,'Retail Sale Id 2310',2198.56,0.00,0.00,3.02,-111.74,'2022-08-12 17:08:13','',''),(2288,'1','277','1',1,'Retail Sale Id 2311',3698.24,0.00,0.00,5.08,-187.96,'2022-08-12 17:09:15','',''),(2289,'1','277','1',1,'Retail Sale Id 2312',502.32,0.00,0.00,0.69,-25.53,'2022-08-12 17:10:10','',''),(2290,'1','277','1',1,'Retail Sale Id 2313',1499.68,0.00,0.00,2.06,-76.22,'2022-08-12 17:12:22','',''),(2291,'1','277','1',1,'Retail Sale Id 2314',2198.56,0.00,0.00,3.02,-111.74,'2022-08-12 17:15:47','',''),(2292,'1','277','1',1,'Retail Sale Id 2315',9100.00,0.00,0.00,12.50,-462.50,'2022-08-12 17:20:46','',''),(2293,'1','277','1',1,'Retail Sale Id 2316',5824.00,0.00,0.00,8.00,-296.00,'2022-08-12 17:24:37','',''),(2294,'1','277','1',1,'Retail Sale Id 2317',1499.68,0.00,0.00,2.06,-76.22,'2022-08-12 17:25:50','',''),(2295,'1','277','1',1,'Retail Sale Id 2318',2198.56,0.00,0.00,3.02,-111.74,'2022-08-12 17:27:19','',''),(2296,'1','277','1',1,'Retail Sale Id 2319',2002.00,0.00,0.00,2.75,-101.75,'2022-08-12 18:02:28','',''),(2297,'1','277','1',1,'Retail Sale Id 2320',2198.56,0.00,0.00,3.02,-111.74,'2022-08-12 18:08:39','',''),(2298,'1','277','1',1,'Retail Sale Id 2321',2002.00,0.00,0.00,2.75,-101.75,'2022-08-12 18:15:25','',''),(2299,'1','277','1',1,'Retail Sale Id 2322',829.92,0.00,0.00,1.14,-42.18,'2022-08-12 18:17:45','',''),(2300,'1','277','1',1,'Retail Sale Id 2323',4397.12,0.00,0.00,6.04,-223.48,'2022-08-12 18:27:13','',''),(2301,'1','277','1',1,'Retail Sale Id 2324',2198.56,0.00,0.00,3.02,-111.74,'2022-08-12 18:28:13','',''),(2302,'1','277','1',1,'Retail Sale Id 2325',997.36,0.00,0.00,1.37,-50.69,'2022-08-12 18:28:49','',''),(2303,'1','277','1',1,'Retail Sale Id 2326',749.84,0.00,0.00,1.03,-38.11,'2022-08-12 18:30:04','',''),(2304,'1','277','1',1,'Retail Sale Id 2327',2002.00,0.00,0.00,2.75,-101.75,'2022-08-12 18:34:33','',''),(2305,'1','277','1',1,'Retail Sale Id 2328',2198.56,0.00,0.00,3.02,-111.74,'2022-08-12 18:35:20','',''),(2306,'1','277','1',1,'Retail Sale Id 2329',3996.72,0.00,0.00,5.49,-203.13,'2022-08-12 18:37:15','',''),(2307,'1','277','1',1,'Retail Sale Id 2330',8998.08,0.00,0.00,12.36,-457.32,'2022-08-12 18:38:14','',''),(2308,'1','277','1',1,'Retail Sale Id 2331',2198.56,0.00,0.00,3.02,-111.74,'2022-08-12 18:38:58','',''),(2309,'1','277','1',1,'Retail Sale Id 2332',2002.00,0.00,0.00,2.75,-101.75,'2022-08-12 18:40:37','',''),(2310,'1','277','1',1,'Retail Sale Id 2333',3640.00,0.00,0.00,5.00,-185.00,'2022-08-12 18:41:54','',''),(2311,'1','277','1',1,'Retail Sale Id 2334',28253.68,0.00,0.00,38.81,-1435.97,'2022-08-12 18:44:16','',''),(2312,'1','277','1',1,'Retail Sale Id 2335',997.36,0.00,0.00,1.37,-50.69,'2022-08-12 18:48:32','',''),(2313,'1','277','1',1,'Retail Sale Id 2336',1499.68,0.00,0.00,2.06,-76.22,'2022-08-12 19:01:20','',''),(2314,'1','277','1',1,'Retail Sale Id 2337',5001.36,0.00,0.00,6.87,-254.19,'2022-08-12 19:03:28','',''),(2315,'1','277','1',1,'Retail Sale Id 2338',3698.24,0.00,0.00,5.08,-187.96,'2022-08-12 19:08:58','',''),(2316,'1','277','1',1,'Retail Sale Id 2339',997.36,0.00,0.00,1.37,-50.69,'2022-08-12 19:17:19','',''),(2317,'1','277','1',1,'Retail Sale Id 2340',1477.84,0.00,0.00,2.03,-75.11,'2022-08-12 19:56:18','',''),(2318,'1','277','1',1,'Retail Sale Id 2341',1499.68,0.00,0.00,2.06,-76.22,'2022-08-13 06:36:55','',''),(2319,'1','277','1',1,'Retail Sale Id 2343',2002.00,0.00,0.00,2.75,-101.75,'2022-08-13 06:57:30','',''),(2320,'1','277','1',1,'Retail Sale Id 2344',3996.72,0.00,0.00,5.49,-203.13,'2022-08-13 07:56:06','',''),(2321,'1','277','1',1,'Retail Sale Id 2345',2198.56,0.00,0.00,3.02,-111.74,'2022-08-13 08:12:14','',''),(2322,'1','277','1',1,'Retail Sale Id 2346',4397.12,0.00,0.00,6.04,-223.48,'2022-08-13 08:21:05','',''),(2323,'1','277','1',1,'Retail Sale Id 2347',1499.68,0.00,0.00,2.06,-76.22,'2022-08-13 08:21:55','',''),(2324,'1','277','1',1,'Retail Sale Id 2349',9100.00,0.00,0.00,12.50,-462.50,'2022-08-13 08:27:14','',''),(2325,'1','277','1',1,'Retail Sale Id 2350',2198.56,0.00,0.00,3.02,-111.74,'2022-08-13 08:34:37','',''),(2326,'1','277','1',1,'Retail Sale Id 2351',997.36,0.00,0.00,1.37,-50.69,'2022-08-13 08:38:06','',''),(2327,'1','277','1',1,'Retail Sale Id 2352',9100.00,0.00,0.00,12.50,-462.50,'2022-08-13 08:38:59','',''),(2328,'1','277','1',1,'Retail Sale Id 2353',2999.36,0.00,0.00,4.12,-152.44,'2022-08-13 08:40:44','',''),(2329,'1','277','1',1,'Retail Sale Id 2355',11648.00,0.00,0.00,16.00,-592.00,'2022-08-13 08:57:39','',''),(2330,'1','277','1',1,'Retail Sale Id 2357',9100.00,0.00,0.00,12.50,-462.50,'2022-08-13 09:00:44','',''),(2331,'1','277','1',1,'Retail Sale Id 2358',2002.00,0.00,0.00,2.75,-101.75,'2022-08-13 09:01:56','',''),(2332,'1','277','1',1,'Retail Sale Id 2359',4368.00,0.00,0.00,6.00,-222.00,'2022-08-13 09:14:23','',''),(2333,'1','277','1',1,'Retail Sale Id 2360',3647.28,0.00,0.00,5.01,-185.37,'2022-08-13 09:20:19','',''),(2334,'1','277','1',1,'Retail Sale Id 2361',749.84,0.00,0.00,1.03,-38.11,'2022-08-13 09:27:53','',''),(2335,'1','277','1',1,'Retail Sale Id 2362',4499.04,0.00,0.00,6.18,-228.66,'2022-08-13 09:31:49','',''),(2336,'1','277','1',1,'Retail Sale Id 2363',2198.56,0.00,0.00,3.02,-111.74,'2022-08-13 09:37:39','',''),(2337,'1','277','1',1,'Retail Sale Id 2364',1499.68,0.00,0.00,2.06,-76.22,'2022-08-13 09:41:29','',''),(2338,'1','277','1',1,'Retail Sale Id 2365',2999.36,0.00,0.00,4.12,-152.44,'2022-08-13 09:42:27','',''),(2339,'1','277','1',1,'Retail Sale Id 2366',1499.68,0.00,0.00,2.06,-76.22,'2022-08-13 09:53:38','',''),(2340,'1','277','1',1,'Retail Sale Id 2367',2198.56,0.00,0.00,3.02,-111.74,'2022-08-13 09:56:54','',''),(2341,'1','277','1',1,'Retail Sale Id 2368',1499.68,0.00,0.00,2.06,-76.22,'2022-08-13 09:58:23','',''),(2342,'1','277','1',1,'Retail Sale Id 2369',3698.24,0.00,0.00,5.08,-187.96,'2022-08-13 10:00:07','',''),(2343,'1','277','1',1,'Retail Sale Id 2370',3698.24,0.00,0.00,5.08,-187.96,'2022-08-13 10:06:32','',''),(2344,'1','277','1',1,'Retail Sale Id 2371',2999.36,0.00,0.00,4.12,-152.44,'2022-08-13 10:09:03','',''),(2345,'1','277','1',1,'Retail Sale Id 2372',3698.24,0.00,0.00,5.08,-187.96,'2022-08-13 10:11:35','',''),(2346,'1','277','1',1,'Retail Sale Id 2373',2999.36,0.00,0.00,4.12,-152.44,'2022-08-13 10:12:26','',''),(2347,'1','277','1',1,'Retail Sale Id 2374',4397.12,0.00,0.00,6.04,-223.48,'2022-08-13 10:18:58','',''),(2348,'1','277','1',1,'Retail Sale Id 2375',2198.56,0.00,0.00,3.02,-111.74,'2022-08-13 10:22:15','',''),(2349,'1','277','1',1,'Retail Sale Id 2376',2002.00,0.00,0.00,2.75,-101.75,'2022-08-13 10:24:15','',''),(2350,'1','277','1',1,'Retail Sale Id 2377',2198.56,0.00,0.00,3.02,-111.74,'2022-08-13 10:25:38','',''),(2351,'1','277','1',1,'Retail Sale Id 2378',3640.00,0.00,0.00,5.00,-185.00,'2022-08-13 10:26:23','',''),(2352,'1','277','1',1,'Retail Sale Id 2379',3501.68,0.00,0.00,4.81,-177.97,'2022-08-13 10:36:02','',''),(2353,'1','277','1',1,'Retail Sale Id 2380',3996.72,0.00,0.00,5.49,-203.13,'2022-08-13 10:51:27','',''),(2354,'1','277','1',1,'Retail Sale Id 2381',1499.68,0.00,0.00,2.06,-76.22,'2022-08-13 11:00:29','',''),(2355,'1','277','1',1,'Retail Sale Id 2382',9100.00,0.00,0.00,12.50,-462.50,'2022-08-13 11:02:45','',''),(2356,'1','277','1',1,'Retail Sale Id 2383',2198.56,0.00,0.00,3.02,-111.74,'2022-08-13 11:08:06','',''),(2357,'1','277','1',1,'Retail Sale Id 2384',1499.68,0.00,0.00,2.06,-76.22,'2022-08-13 11:16:02','',''),(2358,'1','277','1',1,'Retail Sale Id 2385',2198.56,0.00,0.00,3.02,-111.74,'2022-08-13 11:20:04','',''),(2359,'1','277','1',1,'Retail Sale Id 2386',502.32,0.00,0.00,0.69,-25.53,'2022-08-13 11:22:32','',''),(2360,'1','277','1',1,'Retail Sale Id 2387',2002.00,0.00,0.00,2.75,-101.75,'2022-08-13 11:23:25','',''),(2361,'1','277','1',1,'Retail Sale Id 2388',4397.12,0.00,0.00,6.04,-223.48,'2022-08-13 11:26:02','',''),(2362,'1','277','1',1,'Retail Sale Id 2389',1499.68,0.00,0.00,2.06,-76.22,'2022-08-13 11:41:46','',''),(2363,'1','277','1',1,'Retail Sale Id 2390',3501.68,0.00,0.00,4.81,-177.97,'2022-08-13 11:42:47','',''),(2364,'1','277','1',1,'Retail Sale Id 2391',1499.68,0.00,0.00,2.06,-76.22,'2022-08-13 11:53:42','',''),(2365,'1','277','1',1,'Retail Sale Id 2392',1499.68,0.00,0.00,2.06,-76.22,'2022-08-13 11:57:52','',''),(2366,'1','277','1',1,'Retail Sale Id 2393',2802.80,0.00,0.00,3.85,-142.45,'2022-08-13 11:58:45','',''),(2367,'1','277','1',1,'Retail Sale Id 2394',3698.24,0.00,0.00,5.08,-187.96,'2022-08-13 12:02:25','',''),(2368,'1','277','1',1,'Retail Sale Id 2395',7280.00,0.00,0.00,10.00,-370.00,'2022-08-13 12:07:15','',''),(2369,'1','277','1',1,'Return of Retail Sale Id 2394',0.00,3698.24,5.08,0.00,187.96,'2022-08-13 12:11:00','',''),(2370,'1','277','1',1,'Retail Sale Id 2396',2198.56,0.00,0.00,3.02,-111.74,'2022-08-13 12:17:57','',''),(2371,'1','277','1',1,'Retail Sale Id 2397',1499.68,0.00,0.00,2.06,-76.22,'2022-08-13 12:23:42','',''),(2372,'1','277','1',1,'Retail Sale Id 2398',4397.12,0.00,0.00,6.04,-223.48,'2022-08-13 12:45:43','',''),(2373,'1','277','1',1,'Retail Sale Id 2399',1099.28,0.00,0.00,1.51,-55.87,'2022-08-13 12:46:59','',''),(2374,'1','277','1',1,'Retail Sale Id 2400',2999.36,0.00,0.00,4.12,-152.44,'2022-08-13 12:50:33','',''),(2375,'1','277','1',1,'Retail Sale Id 2401',1499.68,0.00,0.00,2.06,-76.22,'2022-08-13 12:56:08','',''),(2376,'1','277','1',1,'Retail Sale Id 2402',4397.12,0.00,0.00,6.04,-223.48,'2022-08-13 12:58:54','',''),(2377,'1','277','1',1,'Retail Sale Id 2403',4397.12,0.00,0.00,6.04,-223.48,'2022-08-13 13:02:26','',''),(2378,'1','277','1',1,'Retail Sale Id 2404',2198.56,0.00,0.00,3.02,-111.74,'2022-08-13 13:19:12','',''),(2379,'1','277','1',1,'Retail Sale Id 2405',2198.56,0.00,0.00,3.02,-111.74,'2022-08-13 13:25:04','',''),(2380,'1','277','1',1,'Retail Sale Id 2406',1499.68,0.00,0.00,2.06,-76.22,'2022-08-13 13:25:48','',''),(2381,'1','277','1',1,'Retail Sale Id 2407',997.36,0.00,0.00,1.37,-50.69,'2022-08-13 13:30:59','',''),(2382,'1','277','1',1,'Retail Sale Id 2408',3501.68,0.00,0.00,4.81,-177.97,'2022-08-13 13:33:02','',''),(2383,'1','277','1',1,'Retail Sale Id 2409',3610.88,0.00,0.00,4.96,-183.52,'2022-08-13 13:39:44','',''),(2384,'1','277','1',1,'Retail Sale Id 2410',4397.12,0.00,0.00,6.04,-223.48,'2022-08-13 13:48:33','',''),(2385,'1','277','1',1,'Retail Sale Id 2411',4397.12,0.00,0.00,6.04,-223.48,'2022-08-13 13:51:49','',''),(2386,'1','277','1',1,'Retail Sale Id 2412',2002.00,0.00,0.00,2.75,-101.75,'2022-08-13 13:58:42','',''),(2387,'1','277','1',1,'Retail Sale Id 2413',2999.36,0.00,0.00,4.12,-152.44,'2022-08-13 14:01:27','',''),(2388,'1','277','1',1,'Retail Sale Id 2414',2198.56,0.00,0.00,3.02,-111.74,'2022-08-13 14:05:31','',''),(2389,'1','277','1',1,'Retail Sale Id 2415',2002.00,0.00,0.00,2.75,-101.75,'2022-08-13 14:16:20','',''),(2390,'1','277','1',1,'Retail Sale Id 2416',3698.24,0.00,0.00,5.08,-187.96,'2022-08-13 14:22:28','',''),(2391,'1','277','1',1,'Retail Sale Id 2417',2999.36,0.00,0.00,4.12,-152.44,'2022-08-13 14:26:38','',''),(2392,'1','277','1',1,'Retail Sale Id 2418',800.80,0.00,0.00,1.10,-40.70,'2022-08-13 14:34:18','',''),(2393,'1','277','1',1,'Retail Sale Id 2419',3996.72,0.00,0.00,5.49,-203.13,'2022-08-13 14:35:06','',''),(2394,'1','277','1',1,'Retail Sale Id 2420',2497.04,0.00,0.00,3.43,-126.91,'2022-08-13 14:35:48','',''),(2395,'1','277','1',1,'Retail Sale Id 2421',2198.56,0.00,0.00,3.02,-111.74,'2022-08-13 14:36:38','',''),(2396,'1','277','1',1,'Retail Sale Id 2422',502.32,0.00,0.00,0.69,-25.53,'2022-08-13 14:37:25','',''),(2397,'1','277','1',1,'Retail Sale Id 2423',2497.04,0.00,0.00,3.43,-126.91,'2022-08-13 14:45:53','',''),(2398,'1','277','1',1,'Retail Sale Id 2424',997.36,0.00,0.00,1.37,-50.69,'2022-08-13 14:52:31','',''),(2399,'1','277','1',1,'Retail Sale Id 2425',946.40,0.00,0.00,1.30,-48.10,'2022-08-13 14:53:36','',''),(2400,'1','277','1',1,'Retail Sale Id 2426',2999.36,0.00,0.00,4.12,-152.44,'2022-08-13 15:05:48','',''),(2401,'1','277','1',1,'Retail Sale Id 2427',2002.00,0.00,0.00,2.75,-101.75,'2022-08-13 15:07:10','',''),(2402,'1','277','1',1,'Retail Sale Id 2428',1499.68,0.00,0.00,2.06,-76.22,'2022-08-13 15:16:02','',''),(2403,'1','277','1',1,'Retail Sale Id 2429',71000.00,0.00,0.00,100.00,-5500.00,'2022-08-13 15:21:51','',''),(2404,'1','277','1',1,'Retail Sale Id 2430',5998.72,0.00,0.00,8.24,-304.88,'2022-08-13 15:46:58','',''),(2405,'1','277','1',1,'Retail Sale Id 2431',1499.68,0.00,0.00,2.06,-76.22,'2022-08-13 15:49:36','',''),(2407,'1','277','1',1,'Retail Sale Id 2433',5001.36,0.00,0.00,6.87,-254.19,'2022-08-13 16:08:03','',''),(2408,'1','277',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,131993.10,172.54,0.00,0.00,'2022-08-13 19:49:19','',''),(2409,'1','277',NULL,1,'Reception corrector for bridging 7',0.00,0.00,0.00,172.54,0.00,'2022-08-13 19:58:21','',''),(2410,'1','277','1',1,'Received from bridging 7',0.00,0.00,172.54,0.00,0.00,'2022-08-13 19:58:21','',''),(2411,'1','277','1',1,'Retail Sale Id 2436',125609.12,0.00,0.00,172.54,-6383.98,'2022-08-13 19:59:21','',''),(2412,'1','277','1',1,'Retail Sale Id 2437',968.24,0.00,0.00,1.33,-49.21,'2022-08-13 20:00:11','',''),(2413,'1','277',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,1530000.00,2000.00,0.00,0.00,'2022-08-14 06:18:31','',''),(2414,'1','277',NULL,1,'Reception corrector for bridging 9',0.00,0.00,0.00,2000.00,0.00,'2022-08-14 06:24:35','',''),(2415,'1','277','1',1,'Received from bridging 9',0.00,0.00,2000.00,0.00,0.00,'2022-08-14 06:24:35','',''),(2416,'1','277','1',1,'Retail Sale Id 2438',2999.36,0.00,0.00,4.12,-152.44,'2022-08-14 06:36:43','',''),(2417,'1','277','1',1,'Retail Sale Id 2439',2999.36,0.00,0.00,4.12,-152.44,'2022-08-14 07:30:30','',''),(2418,'1','277','1',1,'Retail Sale Id 2440',2198.56,0.00,0.00,3.02,-111.74,'2022-08-14 07:32:14','',''),(2419,'1','277','1',1,'Retail Sale Id 2441',8000.72,0.00,0.00,10.99,-406.63,'2022-08-14 07:33:21','',''),(2420,'1','277','1',1,'Retail Sale Id 2442',2002.00,0.00,0.00,2.75,-101.75,'2022-08-14 07:33:57','',''),(2421,'1','277','1',1,'Retail Sale Id 2443',4397.12,0.00,0.00,6.04,-223.48,'2022-08-14 07:35:06','',''),(2422,'1','277','1',1,'Retail Sale Id 2444',800.80,0.00,0.00,1.10,-40.70,'2022-08-14 07:35:50','',''),(2423,'1','277','1',1,'Retail Sale Id 2445',2198.56,0.00,0.00,3.02,-111.74,'2022-08-14 07:38:43','',''),(2424,'1','277','1',1,'Retail Sale Id 2446',2300.48,0.00,0.00,3.16,-116.92,'2022-08-14 07:43:58','',''),(2425,'1','277','1',1,'Retail Sale Id 2447',4397.12,0.00,0.00,6.04,-223.48,'2022-08-14 07:48:41','',''),(2426,'1','277','1',1,'Retail Sale Id 2448',3501.68,0.00,0.00,4.81,-177.97,'2022-08-14 08:10:53','',''),(2427,'1','277','1',1,'Retail Sale Id 2449',800.80,0.00,0.00,1.10,-40.70,'2022-08-14 08:21:14','',''),(2428,'1','277','1',1,'Retail Sale Id 2450',26980.00,0.00,0.00,38.00,-2090.00,'2022-08-14 08:23:35','',''),(2429,'1','277','1',1,'Retail Sale Id 2451',10497.76,0.00,0.00,14.42,-533.54,'2022-08-14 08:25:19','',''),(2430,'1','277','1',1,'Retail Sale Id 2452',7280.00,0.00,0.00,10.00,-370.00,'2022-08-14 08:27:53','',''),(2431,'1','277','1',1,'Retail Sale Id 2453',2897.44,0.00,0.00,3.98,-147.26,'2022-08-14 08:38:46','',''),(2432,'1','277','1',1,'Retail Sale Id 2454',1499.68,0.00,0.00,2.06,-76.22,'2022-08-14 08:41:55','',''),(2433,'1','277','1',1,'Retail Sale Id 2455',2002.00,0.00,0.00,2.75,-101.75,'2022-08-14 08:46:00','',''),(2434,'1','277','1',1,'Retail Sale Id 2456',2002.00,0.00,0.00,2.75,-101.75,'2022-08-14 08:46:52','',''),(2435,'1','277','1',1,'Retail Sale Id 2457',749.84,0.00,0.00,1.03,-38.11,'2022-08-14 08:53:36','',''),(2436,'1','277','1',1,'Retail Sale Id 2458',2999.36,0.00,0.00,4.12,-152.44,'2022-08-14 09:01:48','',''),(2437,'1','277','1',1,'Retail Sale Id 2459',1499.68,0.00,0.00,2.06,-76.22,'2022-08-14 09:13:37','',''),(2438,'1','277','1',1,'Retail Sale Id 2460',4397.12,0.00,0.00,6.04,-223.48,'2022-08-14 09:14:37','',''),(2439,'1','277','1',1,'Retail Sale Id 2461',2999.36,0.00,0.00,4.12,-152.44,'2022-08-14 09:23:53','',''),(2440,'1','277','1',1,'Retail Sale Id 2462',1499.68,0.00,0.00,2.06,-76.22,'2022-08-14 09:28:55','',''),(2441,'1','277','1',1,'Retail Sale Id 2463',2198.56,0.00,0.00,3.02,-111.74,'2022-08-14 09:34:06','',''),(2442,'1','277','1',1,'Retail Sale Id 2464',2198.56,0.00,0.00,3.02,-111.74,'2022-08-14 09:35:07','',''),(2443,'1','277','1',1,'Retail Sale Id 2465',2002.00,0.00,0.00,2.75,-101.75,'2022-08-14 09:36:44','',''),(2444,'1','277','1',1,'Retail Sale Id 2466',1499.68,0.00,0.00,2.06,-76.22,'2022-08-14 09:43:25','',''),(2445,'1','277','1',1,'Retail Sale Id 2467',2999.36,0.00,0.00,4.12,-152.44,'2022-08-14 09:45:20','',''),(2446,'1','277','1',1,'Retail Sale Id 2468',1499.68,0.00,0.00,2.06,-76.22,'2022-08-14 09:46:34','',''),(2447,'1','277','1',1,'Retail Sale Id 2469',2999.36,0.00,0.00,4.12,-152.44,'2022-08-14 10:16:46','',''),(2448,'1','277','1',1,'Retail Sale Id 2470',502.32,0.00,0.00,0.69,-25.53,'2022-08-14 10:17:53','',''),(2449,'1','277','1',1,'Retail Sale Id 2471',4397.12,0.00,0.00,6.04,-223.48,'2022-08-14 10:21:13','',''),(2450,'1','277','1',1,'Retail Sale Id 2472',749.84,0.00,0.00,1.03,-38.11,'2022-08-14 10:21:54','',''),(2451,'1','277','1',1,'Retail Sale Id 2473',2002.00,0.00,0.00,2.75,-101.75,'2022-08-14 10:24:57','',''),(2452,'1','277','1',1,'Retail Sale Id 2474',1499.68,0.00,0.00,2.06,-76.22,'2022-08-14 10:28:36','',''),(2453,'1','277','1',1,'Retail Sale Id 2475',2002.00,0.00,0.00,2.75,-101.75,'2022-08-14 10:32:48','',''),(2454,'1','277','1',1,'Retail Sale Id 2476',997.36,0.00,0.00,1.37,-50.69,'2022-08-14 10:42:12','',''),(2455,'1','277','1',1,'Retail Sale Id 2477',8000.72,0.00,0.00,10.99,-406.63,'2022-08-14 10:45:00','',''),(2456,'1','277','1',1,'Retail Sale Id 2478',749.84,0.00,0.00,1.03,-38.11,'2022-08-14 10:48:17','',''),(2457,'1','277','1',1,'Retail Sale Id 2479',997.36,0.00,0.00,1.37,-50.69,'2022-08-14 10:48:52','',''),(2458,'1','277','1',1,'Retail Sale Id 2480',9100.00,0.00,0.00,12.50,-462.50,'2022-08-14 10:50:06','',''),(2459,'1','277','1',1,'Retail Sale Id 2481',2002.00,0.00,0.00,2.75,-101.75,'2022-08-14 10:52:57','',''),(2460,'1','277','1',1,'Retail Sale Id 2482',2198.56,0.00,0.00,3.02,-111.74,'2022-08-14 10:58:15','',''),(2461,'1','277','1',1,'Retail Sale Id 2483',2198.56,0.00,0.00,3.02,-111.74,'2022-08-14 11:05:48','',''),(2462,'1','277','1',1,'Retail Sale Id 2484',1499.68,0.00,0.00,2.06,-76.22,'2022-08-14 11:09:17','',''),(2463,'1','277','1',1,'Retail Sale Id 2485',1499.68,0.00,0.00,2.06,-76.22,'2022-08-14 11:14:57','',''),(2464,'1','277','1',1,'Retail Sale Id 2486',9100.00,0.00,0.00,12.50,-462.50,'2022-08-14 11:16:18','',''),(2465,'1','277','1',1,'Retail Sale Id 2487',8998.08,0.00,0.00,12.36,-457.32,'2022-08-14 11:17:12','',''),(2466,'1','277','1',1,'Retail Sale Id 2488',5998.72,0.00,0.00,8.24,-304.88,'2022-08-14 11:17:55','',''),(2467,'1','277','1',1,'Retail Sale Id 2489',4448.08,0.00,0.00,6.11,-226.07,'2022-08-14 11:19:17','',''),(2468,'1','277','1',1,'Retail Sale Id 2490',9100.00,0.00,0.00,12.50,-462.50,'2022-08-14 11:21:25','',''),(2469,'1','277','1',1,'Retail Sale Id 2491',9100.00,0.00,0.00,12.50,-462.50,'2022-08-14 11:42:34','',''),(2470,'1','277','1',1,'Retail Sale Id 2492',2198.56,0.00,0.00,3.02,-111.74,'2022-08-14 11:44:54','',''),(2471,'1','277','1',1,'Retail Sale Id 2493',4302.48,0.00,0.00,5.91,-218.67,'2022-08-14 11:49:19','',''),(2472,'1','277','1',1,'Retail Sale Id 2494',749.84,0.00,0.00,1.03,-38.11,'2022-08-14 11:53:30','',''),(2473,'1','277','1',1,'Retail Sale Id 2495',3501.68,0.00,0.00,4.81,-177.97,'2022-08-14 12:03:39','',''),(2474,'1','277','1',1,'Retail Sale Id 2496',8000.72,0.00,0.00,10.99,-406.63,'2022-08-14 12:14:39','',''),(2475,'1','277','1',1,'Retail Sale Id 2497',1499.68,0.00,0.00,2.06,-76.22,'2022-08-14 12:16:38','',''),(2476,'1','277','1',1,'Retail Sale Id 2498',3698.24,0.00,0.00,5.08,-187.96,'2022-08-14 12:18:55','',''),(2477,'1','277','1',1,'Retail Sale Id 2499',2198.56,0.00,0.00,3.02,-111.74,'2022-08-14 12:22:58','',''),(2478,'1','277','1',1,'Retail Sale Id 2500',5001.36,0.00,0.00,6.87,-254.19,'2022-08-14 12:23:41','',''),(2479,'1','277','1',1,'Retail Sale Id 2501',502.32,0.00,0.00,0.69,-25.53,'2022-08-14 12:24:17','',''),(2480,'1','277','1',1,'Retail Sale Id 2502',1499.68,0.00,0.00,2.06,-76.22,'2022-08-14 12:25:38','',''),(2481,'1','277','1',1,'Retail Sale Id 2503',1499.68,0.00,0.00,2.06,-76.22,'2022-08-14 12:43:58','',''),(2482,'1','277','1',1,'Retail Sale Id 2504',1201.20,0.00,0.00,1.65,-61.05,'2022-08-14 12:53:10','',''),(2483,'1','277','1',1,'Retail Sale Id 2505',1499.68,0.00,0.00,2.06,-76.22,'2022-08-14 13:01:14','',''),(2484,'1','277','1',1,'Retail Sale Id 2506',2497.04,0.00,0.00,3.43,-126.91,'2022-08-14 13:01:58','',''),(2485,'1','277','1',1,'Retail Sale Id 2507',2497.04,0.00,0.00,3.43,-126.91,'2022-08-14 13:02:37','',''),(2486,'1','277','1',1,'Retail Sale Id 2508',800.80,0.00,0.00,1.10,-40.70,'2022-08-14 13:04:28','',''),(2487,'1','277','1',1,'Retail Sale Id 2509',21300.00,0.00,0.00,30.00,-1650.00,'2022-08-14 13:06:12','',''),(2488,'1','277','1',1,'Retail Sale Id 2510',2198.56,0.00,0.00,3.02,-111.74,'2022-08-14 13:10:01','',''),(2489,'1','277','1',1,'Retail Sale Id 2511',800.80,0.00,0.00,1.10,-40.70,'2022-08-14 13:10:49','',''),(2490,'1','277','1',1,'Retail Sale Id 2512',502.32,0.00,0.00,0.69,-25.53,'2022-08-14 13:14:51','',''),(2491,'1','277','1',1,'Retail Sale Id 2513',997.36,0.00,0.00,1.37,-50.69,'2022-08-14 13:15:36','',''),(2492,'1','277','1',1,'Retail Sale Id 2514',4397.12,0.00,0.00,6.04,-223.48,'2022-08-14 13:17:35','',''),(2493,'1','277','1',1,'Retail Sale Id 2516',3800.16,0.00,0.00,5.22,-193.14,'2022-08-14 13:18:53','',''),(2494,'1','277','1',1,'Retail Sale Id 2517',2300.48,0.00,0.00,3.16,-116.92,'2022-08-14 13:19:49','',''),(2495,'1','277','1',1,'Retail Sale Id 2518',4302.48,0.00,0.00,5.91,-218.67,'2022-08-14 13:24:29','',''),(2496,'1','277','1',1,'Retail Sale Id 2519',2002.00,0.00,0.00,2.75,-101.75,'2022-08-14 13:29:55','',''),(2497,'1','277','1',1,'Retail Sale Id 2520',2002.00,0.00,0.00,2.75,-101.75,'2022-08-14 13:30:57','',''),(2498,'1','277','1',1,'Retail Sale Id 2521',800.80,0.00,0.00,1.10,-40.70,'2022-08-14 13:32:32','',''),(2499,'1','277','1',1,'Retail Sale Id 2522',5001.36,0.00,0.00,6.87,-254.19,'2022-08-14 13:33:25','',''),(2500,'1','277','1',1,'Retail Sale Id 2523',2002.00,0.00,0.00,2.75,-101.75,'2022-08-14 13:34:27','',''),(2501,'1','277','1',1,'Retail Sale Id 2524',1499.68,0.00,0.00,2.06,-76.22,'2022-08-14 13:35:20','',''),(2502,'1','277','1',1,'Retail Sale Id 2525',2999.36,0.00,0.00,4.12,-152.44,'2022-08-14 13:40:05','',''),(2503,'1','277','1',1,'Retail Sale Id 2526',2999.36,0.00,0.00,4.12,-152.44,'2022-08-14 13:42:27','',''),(2504,'1','277','1',1,'Retail Sale Id 2527',2198.56,0.00,0.00,3.02,-111.74,'2022-08-14 13:43:32','',''),(2505,'1','277','1',1,'Retail Sale Id 2528',2002.00,0.00,0.00,2.75,-101.75,'2022-08-14 13:52:01','',''),(2506,'1','277','1',1,'Retail Sale Id 2529',2002.00,0.00,0.00,2.75,-101.75,'2022-08-14 13:55:14','',''),(2507,'1','277','1',1,'Retail Sale Id 2530',800.80,0.00,0.00,1.10,-40.70,'2022-08-14 13:59:00','',''),(2508,'1','277','1',1,'Retail Sale Id 2532',9100.00,0.00,0.00,12.50,-462.50,'2022-08-14 14:11:05','',''),(2509,'1','277','1',1,'Retail Sale Id 2533',9100.00,0.00,0.00,12.50,-462.50,'2022-08-14 14:12:49','',''),(2510,'1','277','1',1,'Retail Sale Id 2534',1499.68,0.00,0.00,2.06,-76.22,'2022-08-14 14:13:59','',''),(2511,'1','277','1',1,'Retail Sale Id 2535',9100.00,0.00,0.00,12.50,-462.50,'2022-08-14 14:16:27','',''),(2512,'1','277','1',1,'Retail Sale Id 2536',196.56,0.00,0.00,0.27,-9.99,'2022-08-14 14:18:13','',''),(2513,'1','277','1',1,'Retail Sale Id 2537',502.32,0.00,0.00,0.69,-25.53,'2022-08-14 14:21:18','',''),(2514,'1','277','1',1,'Retail Sale Id 2538',2198.56,0.00,0.00,3.02,-111.74,'2022-08-14 14:23:57','',''),(2515,'1','277','1',1,'Retail Sale Id 2539',28400.00,0.00,0.00,40.00,-2200.00,'2022-08-14 14:26:11','',''),(2516,'1','277','1',1,'Retail Sale Id 2540',2999.36,0.00,0.00,4.12,-152.44,'2022-08-14 14:27:12','',''),(2517,'1','277','1',1,'Retail Sale Id 2541',2300.48,0.00,0.00,3.16,-116.92,'2022-08-14 14:27:55','',''),(2518,'1','277','1',1,'Retail Sale Id 2542',2999.36,0.00,0.00,4.12,-152.44,'2022-08-14 14:28:42','',''),(2519,'1','277','1',1,'Retail Sale Id 2543',2002.00,0.00,0.00,2.75,-101.75,'2022-08-14 14:29:29','',''),(2520,'1','277','1',1,'Retail Sale Id 2544',9100.00,0.00,0.00,12.50,-462.50,'2022-08-14 14:40:40','',''),(2521,'1','277','1',1,'Retail Sale Id 2545',4397.12,0.00,0.00,6.04,-223.48,'2022-08-14 14:50:07','',''),(2522,'1','277','1',1,'Retail Sale Id 2546',14560.00,0.00,0.00,20.00,-740.00,'2022-08-14 14:51:39','',''),(2523,'1','277','1',1,'Retail Sale Id 2547',1201.20,0.00,0.00,1.65,-61.05,'2022-08-14 14:52:38','',''),(2524,'1','277','1',1,'Retail Sale Id 2548',502.32,0.00,0.00,0.69,-25.53,'2022-08-14 14:55:45','',''),(2525,'1','277','1',1,'Retail Sale Id 2549',6552.00,0.00,0.00,9.00,-333.00,'2022-08-14 14:58:00','',''),(2526,'1','277','1',1,'Retail Sale Id 2550',2198.56,0.00,0.00,3.02,-111.74,'2022-08-14 15:01:06','',''),(2527,'1','277','1',1,'Retail Sale Id 2551',3698.24,0.00,0.00,5.08,-187.96,'2022-08-14 15:04:20','',''),(2528,'1','277','1',1,'Retail Sale Id 2552',1499.68,0.00,0.00,2.06,-76.22,'2022-08-14 15:05:34','',''),(2529,'1','277','1',1,'Retail Sale Id 2553',8000.72,0.00,0.00,10.99,-406.63,'2022-08-14 15:06:22','',''),(2530,'1','277','1',1,'Retail Sale Id 2554',3640.00,0.00,0.00,5.00,-185.00,'2022-08-14 15:22:21','',''),(2531,'1','277','1',1,'Retail Sale Id 2555',1499.68,0.00,0.00,2.06,-76.22,'2022-08-14 15:24:27','',''),(2532,'1','277','1',1,'Retail Sale Id 2556',2999.36,0.00,0.00,4.12,-152.44,'2022-08-14 15:25:29','',''),(2533,'1','277','1',1,'Retail Sale Id 2557',1499.68,0.00,0.00,2.06,-76.22,'2022-08-14 15:26:18','',''),(2534,'1','277','1',1,'Retail Sale Id 2558',1201.20,0.00,0.00,1.65,-61.05,'2022-08-14 15:27:40','',''),(2535,'1','277','1',1,'Retail Sale Id 2559',4397.12,0.00,0.00,6.04,-223.48,'2022-08-14 15:30:08','',''),(2536,'1','277','1',1,'Retail Sale Id 2560',997.36,0.00,0.00,1.37,-50.69,'2022-08-14 15:38:44','',''),(2537,'1','277','1',1,'Retail Sale Id 2561',2999.36,0.00,0.00,4.12,-152.44,'2022-08-14 15:41:20','',''),(2538,'1','277','1',1,'Retail Sale Id 2562',749.84,0.00,0.00,1.03,-38.11,'2022-08-14 15:43:59','',''),(2539,'1','277','1',1,'Retail Sale Id 2563',1499.68,0.00,0.00,2.06,-76.22,'2022-08-14 15:47:20','',''),(2540,'1','277','1',1,'Retail Sale Id 2564',800.80,0.00,0.00,1.10,-40.70,'2022-08-14 15:48:13','',''),(2541,'1','277','1',1,'Retail Sale Id 2565',2999.36,0.00,0.00,4.12,-152.44,'2022-08-14 15:56:25','',''),(2542,'1','277','1',1,'Retail Sale Id 2566',2002.00,0.00,0.00,2.75,-101.75,'2022-08-14 15:59:03','',''),(2543,'1','277','1',1,'Retail Sale Id 2567',2002.00,0.00,0.00,2.75,-101.75,'2022-08-14 16:02:32','',''),(2544,'1','277','1',1,'Retail Sale Id 2568',9100.00,0.00,0.00,12.50,-462.50,'2022-08-14 16:09:02','',''),(2545,'1','277','1',1,'Retail Sale Id 2570',6552.00,0.00,0.00,9.00,-333.00,'2022-08-14 16:11:26','',''),(2546,'1','277','1',1,'Retail Sale Id 2571',2002.00,0.00,0.00,2.75,-101.75,'2022-08-14 16:12:16','',''),(2547,'1','277','1',1,'Retail Sale Id 2572',5001.36,0.00,0.00,6.87,-254.19,'2022-08-14 16:13:09','',''),(2548,'1','277','1',1,'Retail Sale Id 2573',2198.56,0.00,0.00,3.02,-111.74,'2022-08-14 16:18:41','',''),(2549,'1','277','1',1,'Retail Sale Id 2574',3996.72,0.00,0.00,5.49,-203.13,'2022-08-14 16:24:02','',''),(2550,'1','277','1',1,'Retail Sale Id 2575',2198.56,0.00,0.00,3.02,-111.74,'2022-08-14 16:28:29','',''),(2551,'1','277','1',1,'Retail Sale Id 2576',997.36,0.00,0.00,1.37,-50.69,'2022-08-14 16:49:21','',''),(2552,'1','277','1',1,'Retail Sale Id 2577',9100.00,0.00,0.00,12.50,-462.50,'2022-08-14 16:55:55','',''),(2553,'1','277','1',1,'Retail Sale Id 2578',2198.56,0.00,0.00,3.02,-111.74,'2022-08-14 16:57:26','',''),(2554,'1','277','1',1,'Retail Sale Id 2579',2002.00,0.00,0.00,2.75,-101.75,'2022-08-14 16:58:23','',''),(2555,'1','277','1',1,'Retail Sale Id 2580',2002.00,0.00,0.00,2.75,-101.75,'2022-08-14 16:59:44','',''),(2556,'1','277','1',1,'Retail Sale Id 2581',1499.68,0.00,0.00,2.06,-76.22,'2022-08-14 17:01:52','',''),(2557,'1','277','1',1,'Retail Sale Id 2582',2198.56,0.00,0.00,3.02,-111.74,'2022-08-14 17:05:42','',''),(2558,'1','277','1',1,'Retail Sale Id 2583',4397.12,0.00,0.00,6.04,-223.48,'2022-08-14 17:06:59','',''),(2559,'1','277','1',1,'Retail Sale Id 2584',2999.36,0.00,0.00,4.12,-152.44,'2022-08-14 17:11:34','',''),(2560,'1','277','1',1,'Retail Sale Id 2585',4397.12,0.00,0.00,6.04,-223.48,'2022-08-14 17:15:03','',''),(2561,'1','277','1',1,'Retail Sale Id 2586',5001.36,0.00,0.00,6.87,-254.19,'2022-08-14 17:23:54','',''),(2562,'1','277','1',1,'Retail Sale Id 2587',2198.56,0.00,0.00,3.02,-111.74,'2022-08-14 17:33:13','',''),(2563,'1','277','1',1,'Retail Sale Id 2588',2198.56,0.00,0.00,3.02,-111.74,'2022-08-14 17:33:54','',''),(2564,'1','277','1',1,'Retail Sale Id 2589',3996.72,0.00,0.00,5.49,-203.13,'2022-08-14 17:34:33','',''),(2565,'1','277','1',1,'Retail Sale Id 2590',997.36,0.00,0.00,1.37,-50.69,'2022-08-14 17:37:05','',''),(2566,'1','277','1',1,'Retail Sale Id 2591',2198.56,0.00,0.00,3.02,-111.74,'2022-08-14 17:39:26','',''),(2567,'1','277','1',1,'Retail Sale Id 2592',2999.36,0.00,0.00,4.12,-152.44,'2022-08-14 17:41:04','',''),(2568,'1','277','1',1,'Retail Sale Id 2593',1798.16,0.00,0.00,2.47,-91.39,'2022-08-14 17:48:39','',''),(2569,'1','277','1',1,'Retail Sale Id 2594',997.36,0.00,0.00,1.37,-50.69,'2022-08-14 17:51:49','',''),(2570,'1','277','1',1,'Retail Sale Id 2595',3996.72,0.00,0.00,5.49,-203.13,'2022-08-14 18:45:23','',''),(2571,'1','277','1',1,'Retail Sale Id 2596',3996.72,0.00,0.00,5.49,-203.13,'2022-08-14 18:46:09','',''),(2572,'1','277','1',1,'Retail Sale Id 2597',2198.56,0.00,0.00,3.02,-111.74,'2022-08-14 18:51:15','',''),(2573,'1','277','1',1,'Retail Sale Id 2598',27598.48,0.00,0.00,37.91,-1402.67,'2022-08-14 19:12:17','',''),(2574,'1','277','1',1,'Retail Sale Id 2599',1907.36,0.00,0.00,2.62,-96.94,'2022-08-14 19:43:18','',''),(2575,'1','277',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,1216350.00,1590.00,0.00,0.00,'2022-08-14 20:00:06','',''),(2576,'1','277',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,1590.00,0.00,'2022-08-14 20:01:27','',''),(2577,'1','277','1',1,'Received from bridging 10',0.00,0.00,1590.00,0.00,0.00,'2022-08-14 20:01:27','',''),(2578,'1','277','1',1,'Retail Sale Id 2601',4368.00,0.00,0.00,6.00,-222.00,'2022-08-15 06:57:35','',''),(2579,'1','277','1',1,'Retail Sale Id 2602',4499.04,0.00,0.00,6.18,-228.66,'2022-08-15 07:00:09','',''),(2580,'1','277','1',1,'Return of Retail Sale Id 2601',0.00,4368.00,6.00,0.00,222.00,'2022-08-15 07:03:30','',''),(2581,'1','277','1',1,'Retail Sale Id 2603',2999.36,0.00,0.00,4.12,-152.44,'2022-08-15 07:14:54','',''),(2582,'1','277','1',1,'Retail Sale Id 2604',2198.56,0.00,0.00,3.02,-111.74,'2022-08-15 08:32:14','',''),(2583,'1','277','1',1,'Retail Sale Id 2605',27765.92,0.00,0.00,38.14,-1411.18,'2022-08-15 08:35:44','',''),(2584,'1','277','1',1,'Retail Sale Id 2606',4397.12,0.00,0.00,6.04,-223.48,'2022-08-15 08:43:40','',''),(2585,'1','277','1',1,'Retail Sale Id 2607',997.36,0.00,0.00,1.37,-50.69,'2022-08-15 08:46:04','',''),(2586,'1','277','1',1,'Retail Sale Id 2608',2999.36,0.00,0.00,4.12,-152.44,'2022-08-15 08:51:12','',''),(2587,'1','277','1',1,'Retail Sale Id 2609',2198.56,0.00,0.00,3.02,-111.74,'2022-08-15 08:52:59','',''),(2588,'1','277','1',1,'Retail Sale Id 2610',1499.68,0.00,0.00,2.06,-76.22,'2022-08-15 09:00:15','',''),(2589,'1','277','1',1,'Retail Sale Id 2611',2002.00,0.00,0.00,2.75,-101.75,'2022-08-15 09:01:04','',''),(2590,'1','277','1',1,'Retail Sale Id 2612',1703.52,0.00,0.00,2.34,-86.58,'2022-08-15 09:08:51','',''),(2591,'1','277','1',1,'Retail Sale Id 2612',1703.52,0.00,0.00,2.34,-86.58,'2022-08-15 09:08:51','',''),(2592,'1','277','1',1,'Retail Sale Id 2613',2999.36,0.00,0.00,4.12,-152.44,'2022-08-15 09:12:50','',''),(2593,'1','277','1',1,'Retail Sale Id 2614',1499.68,0.00,0.00,2.06,-76.22,'2022-08-15 09:22:02','',''),(2594,'1','277','1',1,'Retail Sale Id 2615',4499.04,0.00,0.00,6.18,-228.66,'2022-08-15 09:26:09','',''),(2595,'1','277','1',1,'Retail Sale Id 2616',1201.20,0.00,0.00,1.65,-61.05,'2022-08-15 09:26:47','',''),(2596,'1','277','1',1,'Retail Sale Id 2617',4397.12,0.00,0.00,6.04,-223.48,'2022-08-15 09:28:01','',''),(2597,'1','277','1',1,'Retail Sale Id 2618',20590.00,0.00,0.00,29.00,-1595.00,'2022-08-15 09:30:24','',''),(2598,'1','277','1',1,'Retail Sale Id 2619',2002.00,0.00,0.00,2.75,-101.75,'2022-08-15 09:32:21','',''),(2599,'1','277','1',1,'Retail Sale Id 2620',4397.12,0.00,0.00,6.04,-223.48,'2022-08-15 09:41:25','',''),(2600,'1','277','1',1,'Retail Sale Id 2621',1201.20,0.00,0.00,1.65,-61.05,'2022-08-15 09:49:23','',''),(2601,'1','277','1',1,'Retail Sale Id 2622',7498.40,0.00,0.00,10.30,-381.10,'2022-08-15 09:50:13','',''),(2602,'1','277','1',1,'Retail Sale Id 2623',3501.68,0.00,0.00,4.81,-177.97,'2022-08-15 09:57:41','',''),(2603,'1','277','1',1,'Retail Sale Id 2624',4397.12,0.00,0.00,6.04,-223.48,'2022-08-15 10:05:26','',''),(2604,'1','277','1',1,'Retail Sale Id 2625',502.32,0.00,0.00,0.69,-25.53,'2022-08-15 10:06:11','',''),(2605,'1','277','1',1,'Retail Sale Id 2626',2999.36,0.00,0.00,4.12,-152.44,'2022-08-15 10:06:50','',''),(2606,'1','277','1',1,'Retail Sale Id 2627',997.36,0.00,0.00,1.37,-50.69,'2022-08-15 10:10:55','',''),(2607,'1','277','1',1,'Retail Sale Id 2628',4397.12,0.00,0.00,6.04,-223.48,'2022-08-15 10:14:44','',''),(2608,'1','277','1',1,'Retail Sale Id 2629',2999.36,0.00,0.00,4.12,-152.44,'2022-08-15 10:16:52','',''),(2609,'1','277','1',1,'Retail Sale Id 2630',997.36,0.00,0.00,1.37,-50.69,'2022-08-15 10:26:21','',''),(2610,'1','277','1',1,'Retail Sale Id 2631',997.36,0.00,0.00,1.37,-50.69,'2022-08-15 10:31:24','',''),(2611,'1','277','1',1,'Retail Sale Id 2632',1499.68,0.00,0.00,2.06,-76.22,'2022-08-15 10:36:36','',''),(2612,'1','277','1',1,'Retail Sale Id 2633',1499.68,0.00,0.00,2.06,-76.22,'2022-08-15 10:43:54','',''),(2613,'1','277','1',1,'Retail Sale Id 2634',800.80,0.00,0.00,1.10,-40.70,'2022-08-15 10:46:26','',''),(2614,'1','277','1',1,'Retail Sale Id 2635',2002.00,0.00,0.00,2.75,-101.75,'2022-08-15 11:06:26','',''),(2615,'1','277','1',1,'Retail Sale Id 2636',2198.56,0.00,0.00,3.02,-111.74,'2022-08-15 11:09:58','',''),(2616,'1','277','1',1,'Retail Sale Id 2637',2999.36,0.00,0.00,4.12,-152.44,'2022-08-15 11:20:45','',''),(2617,'1','277','1',1,'Retail Sale Id 2638',3647.28,0.00,0.00,5.01,-185.37,'2022-08-15 11:21:52','',''),(2618,'1','277','1',1,'Retail Sale Id 2639',800.80,0.00,0.00,1.10,-40.70,'2022-08-15 11:22:53','',''),(2619,'1','277','1',1,'Retail Sale Id 2640',1346.80,0.00,0.00,1.85,-68.45,'2022-08-15 11:24:20','',''),(2620,'1','277','1',1,'Retail Sale Id 2641',3996.72,0.00,0.00,5.49,-203.13,'2022-08-15 11:26:45','',''),(2621,'1','277','1',1,'Retail Sale Id 2641',9100.00,0.00,0.00,12.50,-462.50,'2022-08-15 11:26:45','',''),(2622,'1','277','1',1,'Retail Sale Id 2642',2002.00,0.00,0.00,2.75,-101.75,'2022-08-15 11:27:58','',''),(2623,'1','277','1',1,'Retail Sale Id 2643',997.36,0.00,0.00,1.37,-50.69,'2022-08-15 11:31:48','',''),(2624,'1','277','1',1,'Retail Sale Id 2644',1499.68,0.00,0.00,2.06,-76.22,'2022-08-15 11:39:41','',''),(2625,'1','277','1',1,'Retail Sale Id 2645',2497.04,0.00,0.00,3.43,-126.91,'2022-08-15 11:47:32','',''),(2626,'1','277','1',1,'Retail Sale Id 2646',2198.56,0.00,0.00,3.02,-111.74,'2022-08-15 11:52:27','',''),(2627,'1','277','1',1,'Retail Sale Id 2647',4397.12,0.00,0.00,6.04,-223.48,'2022-08-15 11:53:27','',''),(2628,'1','277','1',1,'Retail Sale Id 2648',2198.56,0.00,0.00,3.02,-111.74,'2022-08-15 11:59:58','',''),(2629,'1','277','1',1,'Retail Sale Id 2649',2002.00,0.00,0.00,2.75,-101.75,'2022-08-15 12:02:50','',''),(2630,'1','277','1',1,'Retail Sale Id 2650',2999.36,0.00,0.00,4.12,-152.44,'2022-08-15 12:04:42','',''),(2631,'1','277','1',1,'Retail Sale Id 2651',3603.60,0.00,0.00,4.95,-183.15,'2022-08-15 12:05:47','',''),(2632,'1','277','1',1,'Retail Sale Id 2652',3698.24,0.00,0.00,5.08,-187.96,'2022-08-15 12:09:53','',''),(2633,'1','277','1',1,'Retail Sale Id 2653',1499.68,0.00,0.00,2.06,-76.22,'2022-08-15 12:18:38','',''),(2634,'1','277','1',1,'Retail Sale Id 2654',2198.56,0.00,0.00,3.02,-111.74,'2022-08-15 12:23:53','',''),(2635,'1','277','1',1,'Retail Sale Id 2655',2002.00,0.00,0.00,2.75,-101.75,'2022-08-15 12:25:04','',''),(2636,'1','277','1',1,'Retail Sale Id 2656',1703.52,0.00,0.00,2.34,-86.58,'2022-08-15 12:52:39','',''),(2637,'1','277','1',1,'Retail Sale Id 2657',1499.68,0.00,0.00,2.06,-76.22,'2022-08-15 12:53:38','',''),(2638,'1','277','1',1,'Retail Sale Id 2658',2198.56,0.00,0.00,3.02,-111.74,'2022-08-15 12:55:36','',''),(2639,'1','277','1',1,'Retail Sale Id 2659',9100.00,0.00,0.00,12.50,-462.50,'2022-08-15 12:56:27','',''),(2640,'1','277','1',1,'Retail Sale Id 2660',2198.56,0.00,0.00,3.02,-111.74,'2022-08-15 13:01:09','',''),(2641,'1','277','1',1,'Retail Sale Id 2661',3501.68,0.00,0.00,4.81,-177.97,'2022-08-15 13:18:04','',''),(2642,'1','277','1',1,'Retail Sale Id 2662',2002.00,0.00,0.00,2.75,-101.75,'2022-08-15 13:19:50','',''),(2643,'1','277','1',1,'Retail Sale Id 2663',2198.56,0.00,0.00,3.02,-111.74,'2022-08-15 13:22:15','',''),(2644,'1','277','1',1,'Retail Sale Id 2664',2002.00,0.00,0.00,2.75,-101.75,'2022-08-15 13:22:53','',''),(2645,'1','277','1',1,'Retail Sale Id 2665',2999.36,0.00,0.00,4.12,-152.44,'2022-08-15 13:23:35','',''),(2646,'1','277','1',1,'Retail Sale Id 2666',2002.00,0.00,0.00,2.75,-101.75,'2022-08-15 13:32:17','',''),(2647,'1','277','1',1,'Retail Sale Id 2667',4397.12,0.00,0.00,6.04,-223.48,'2022-08-15 13:36:56','',''),(2648,'1','277','1',1,'Retail Sale Id 2668',1099.28,0.00,0.00,1.51,-55.87,'2022-08-15 13:42:13','',''),(2649,'1','277','1',1,'Retail Sale Id 2669',1499.68,0.00,0.00,2.06,-76.22,'2022-08-15 13:48:38','',''),(2650,'1','277','1',1,'Retail Sale Id 2670',4397.12,0.00,0.00,6.04,-223.48,'2022-08-15 13:54:59','',''),(2651,'1','277','1',1,'Retail Sale Id 2671',698.88,0.00,0.00,0.96,-35.52,'2022-08-15 14:08:18','',''),(2652,'1','277','1',1,'Retail Sale Id 2672',1499.68,0.00,0.00,2.06,-76.22,'2022-08-15 14:13:48','',''),(2653,'1','277','1',1,'Retail Sale Id 2673',2198.56,0.00,0.00,3.02,-111.74,'2022-08-15 14:24:20','',''),(2654,'1','277','1',1,'Retail Sale Id 2674',9100.00,0.00,0.00,12.50,-462.50,'2022-08-15 14:28:11','',''),(2655,'1','277','1',1,'Retail Sale Id 2675',800.80,0.00,0.00,1.10,-40.70,'2022-08-15 14:29:45','',''),(2656,'1','277','1',1,'Retail Sale Id 2676',2002.00,0.00,0.00,2.75,-101.75,'2022-08-15 14:32:26','',''),(2657,'1','277','1',1,'Retail Sale Id 2677',2198.56,0.00,0.00,3.02,-111.74,'2022-08-15 14:47:55','',''),(2658,'1','277','1',1,'Retail Sale Id 2678',7280.00,0.00,0.00,10.00,-370.00,'2022-08-15 14:53:05','',''),(2659,'1','277','1',1,'Retail Sale Id 2679',2598.96,0.00,0.00,3.57,-132.09,'2022-08-15 14:55:00','',''),(2660,'1','277','1',1,'Retail Sale Id 2679',4397.12,0.00,0.00,6.04,-223.48,'2022-08-15 14:55:00','',''),(2661,'1','277','1',1,'Retail Sale Id 2680',800.80,0.00,0.00,1.10,-40.70,'2022-08-15 14:58:42','',''),(2662,'1','277','1',1,'Retail Sale Id 2681',800.80,0.00,0.00,1.10,-40.70,'2022-08-15 15:17:38','',''),(2663,'1','277','1',1,'Retail Sale Id 2682',2999.36,0.00,0.00,4.12,-152.44,'2022-08-15 15:18:40','',''),(2664,'1','277','1',1,'Retail Sale Id 2684',3698.24,0.00,0.00,5.08,-187.96,'2022-08-15 15:36:43','',''),(2665,'1','277','1',1,'Retail Sale Id 2685',2002.00,0.00,0.00,2.75,-101.75,'2022-08-15 15:41:13','',''),(2666,'1','277','1',1,'Retail Sale Id 2686',4397.12,0.00,0.00,6.04,-223.48,'2022-08-15 15:52:54','',''),(2667,'1','277','1',1,'Retail Sale Id 2687',749.84,0.00,0.00,1.03,-38.11,'2022-08-15 15:53:39','',''),(2668,'1','277','1',1,'Retail Sale Id 2688',9100.00,0.00,0.00,12.50,-462.50,'2022-08-15 15:55:54','',''),(2669,'1','277','1',1,'Retail Sale Id 2689',4397.12,0.00,0.00,6.04,-223.48,'2022-08-15 15:58:30','',''),(2670,'1','277','1',1,'Retail Sale Id 2690',4397.12,0.00,0.00,6.04,-223.48,'2022-08-15 16:03:17','',''),(2671,'1','277','1',1,'Retail Sale Id 2691',9100.00,0.00,0.00,12.50,-462.50,'2022-08-15 16:08:23','',''),(2672,'1','277','1',1,'Retail Sale Id 2692',2912.00,0.00,0.00,4.00,-148.00,'2022-08-15 16:09:09','',''),(2673,'1','277','1',1,'Retail Sale Id 2693',3501.68,0.00,0.00,4.81,-177.97,'2022-08-15 16:21:49','',''),(2674,'1','277','1',1,'Retail Sale Id 2694',2198.56,0.00,0.00,3.02,-111.74,'2022-08-15 16:26:06','',''),(2675,'1','277','1',1,'Retail Sale Id 2696',2999.36,0.00,0.00,4.12,-152.44,'2022-08-15 16:27:37','',''),(2676,'1','277','1',1,'Retail Sale Id 2697',1499.68,0.00,0.00,2.06,-76.22,'2022-08-15 16:33:49','',''),(2677,'1','277','1',1,'Retail Sale Id 2698',4368.00,0.00,0.00,6.00,-222.00,'2022-08-15 16:40:49','',''),(2678,'1','277','1',1,'Retail Sale Id 2699',2999.36,0.00,0.00,4.12,-152.44,'2022-08-15 16:41:38','',''),(2679,'1','277','1',1,'Retail Sale Id 2700',2300.48,0.00,0.00,3.16,-116.92,'2022-08-15 16:42:29','',''),(2680,'1','277','1',1,'Retail Sale Id 2701',3501.68,0.00,0.00,4.81,-177.97,'2022-08-15 16:43:31','',''),(2681,'1','277','1',1,'Retail Sale Id 2702',2300.48,0.00,0.00,3.16,-116.92,'2022-08-15 16:45:48','',''),(2682,'1','277','1',1,'Retail Sale Id 2703',2999.36,0.00,0.00,4.12,-152.44,'2022-08-15 16:48:07','',''),(2683,'1','277','1',1,'Retail Sale Id 2704',4499.04,0.00,0.00,6.18,-228.66,'2022-08-15 16:57:25','',''),(2684,'1','277','1',1,'Retail Sale Id 2705',2897.44,0.00,0.00,3.98,-147.26,'2022-08-15 17:05:18','',''),(2685,'1','277','1',1,'Retail Sale Id 2706',4397.12,0.00,0.00,6.04,-223.48,'2022-08-15 17:09:08','',''),(2686,'1','277','1',1,'Retail Sale Id 2707',2002.00,0.00,0.00,2.75,-101.75,'2022-08-15 17:17:10','',''),(2687,'1','277','1',1,'Retail Sale Id 2708',1499.68,0.00,0.00,2.06,-76.22,'2022-08-15 17:21:22','',''),(2688,'1','277','1',1,'Retail Sale Id 2709',26980.00,0.00,0.00,38.00,-2090.00,'2022-08-15 17:23:48','',''),(2689,'1','277','1',1,'Retail Sale Id 2710',2999.36,0.00,0.00,4.12,-152.44,'2022-08-15 17:27:11','',''),(2690,'1','277','1',1,'Retail Sale Id 2711',2999.36,0.00,0.00,4.12,-152.44,'2022-08-15 17:28:03','',''),(2691,'1','277','1',1,'Retail Sale Id 2712',2999.36,0.00,0.00,4.12,-152.44,'2022-08-15 17:32:58','',''),(2692,'1','277','1',1,'Retail Sale Id 2713',1499.68,0.00,0.00,2.06,-76.22,'2022-08-15 17:35:20','',''),(2693,'1','277','1',1,'Retail Sale Id 2714',997.36,0.00,0.00,1.37,-50.69,'2022-08-15 17:36:20','',''),(2694,'1','277','1',1,'Retail Sale Id 2715',9100.00,0.00,0.00,12.50,-462.50,'2022-08-15 17:40:15','',''),(2695,'1','277','1',1,'Retail Sale Id 2716',4397.12,0.00,0.00,6.04,-223.48,'2022-08-15 17:45:12','',''),(2696,'1','277','1',1,'Retail Sale Id 2718',2198.56,0.00,0.00,3.02,-111.74,'2022-08-15 17:57:26','',''),(2697,'1','277','1',1,'Retail Sale Id 2719',1499.68,0.00,0.00,2.06,-76.22,'2022-08-15 17:59:09','',''),(2698,'1','277','1',1,'Retail Sale Id 2720',4368.00,0.00,0.00,6.00,-222.00,'2022-08-15 18:02:16','',''),(2699,'1','277','1',1,'Retail Sale Id 2721',7280.00,0.00,0.00,10.00,-370.00,'2022-08-15 18:03:58','',''),(2700,'1','277','1',1,'Retail Sale Id 2722',800.80,0.00,0.00,1.10,-40.70,'2022-08-15 18:05:28','',''),(2701,'1','277','1',1,'Retail Sale Id 2723',2999.36,0.00,0.00,4.12,-152.44,'2022-08-15 18:06:15','',''),(2702,'1','277','1',1,'Retail Sale Id 2724',2198.56,0.00,0.00,3.02,-111.74,'2022-08-15 18:07:05','',''),(2703,'1','277','1',1,'Retail Sale Id 2725',2999.36,0.00,0.00,4.12,-152.44,'2022-08-15 18:08:07','',''),(2704,'1','277','1',1,'Retail Sale Id 2726',3647.28,0.00,0.00,5.01,-185.37,'2022-08-15 18:10:17','',''),(2705,'1','277','1',1,'Retail Sale Id 2727',3996.72,0.00,0.00,5.49,-203.13,'2022-08-15 18:11:12','',''),(2706,'1','277','1',1,'Retail Sale Id 2728',2198.56,0.00,0.00,3.02,-111.74,'2022-08-15 18:13:11','',''),(2707,'1','277','1',1,'Retail Sale Id 2729',2002.00,0.00,0.00,2.75,-101.75,'2022-08-15 18:14:20','',''),(2708,'1','277','1',1,'Retail Sale Id 2730',1499.68,0.00,0.00,2.06,-76.22,'2022-08-15 18:15:24','',''),(2709,'1','277','1',1,'Retail Sale Id 2732',2198.56,0.00,0.00,3.02,-111.74,'2022-08-15 18:21:08','',''),(2710,'1','277','1',1,'Retail Sale Id 2733',2002.00,0.00,0.00,2.75,-101.75,'2022-08-15 18:21:51','',''),(2711,'1','277','1',1,'Retail Sale Id 2734',4397.12,0.00,0.00,6.04,-223.48,'2022-08-15 18:22:47','',''),(2712,'1','277','1',1,'Retail Sale Id 2735',2497.04,0.00,0.00,3.43,-126.91,'2022-08-15 18:23:42','',''),(2713,'1','277','1',1,'Retail Sale Id 2736',2999.36,0.00,0.00,4.12,-152.44,'2022-08-15 18:31:19','',''),(2714,'1','277','1',1,'Retail Sale Id 2737',9100.00,0.00,0.00,12.50,-462.50,'2022-08-15 18:34:48','',''),(2715,'1','277','1',1,'Retail Sale Id 2738',1303.12,0.00,0.00,1.79,-66.23,'2022-08-15 18:36:04','',''),(2716,'1','277','1',1,'Retail Sale Id 2739',1499.68,0.00,0.00,2.06,-76.22,'2022-08-15 18:36:57','',''),(2717,'1','277','1',1,'Retail Sale Id 2740',2999.36,0.00,0.00,4.12,-152.44,'2022-08-15 18:37:43','',''),(2718,'1','277','1',1,'Retail Sale Id 2741',4397.12,0.00,0.00,6.04,-223.48,'2022-08-15 18:38:47','',''),(2719,'1','277','1',1,'Retail Sale Id 2742',3640.00,0.00,0.00,5.00,-185.00,'2022-08-15 18:39:36','',''),(2720,'1','277','1',1,'Retail Sale Id 2743',9100.00,0.00,0.00,12.50,-462.50,'2022-08-15 18:40:37','',''),(2721,'1','277','1',1,'Retail Sale Id 2744',4302.48,0.00,0.00,5.91,-218.67,'2022-08-15 18:41:54','',''),(2722,'1','277','1',1,'Retail Sale Id 2745',1499.68,0.00,0.00,2.06,-76.22,'2022-08-15 18:42:29','',''),(2723,'1','277','1',1,'Retail Sale Id 2746',2002.00,0.00,0.00,2.75,-101.75,'2022-08-15 18:49:27','',''),(2724,'1','277','1',1,'Retail Sale Id 2747',2198.56,0.00,0.00,3.02,-111.74,'2022-08-15 18:51:06','',''),(2725,'1','277','1',1,'Return of Retail Sale Id 2728',0.00,2198.56,3.02,0.00,111.74,'2022-08-15 18:51:49','',''),(2726,'1','277','1',1,'Retail Sale Id 2748',2198.56,0.00,0.00,3.02,-111.74,'2022-08-15 19:11:56','',''),(2727,'1','277','1',1,'Retail Sale Id 2749',3800.16,0.00,0.00,5.22,-193.14,'2022-08-15 19:12:43','',''),(2728,'1','277','1',1,'Retail Sale Id 2750',298.48,0.00,0.00,0.41,-15.17,'2022-08-15 19:13:14','',''),(2729,'1','277','1',1,'Retail Sale Id 2751',502.32,0.00,0.00,0.69,-25.53,'2022-08-15 19:13:50','',''),(2730,'1','277','1',1,'Retail Sale Id 2752',3661.84,0.00,0.00,5.03,-186.11,'2022-08-15 19:16:37','',''),(2731,'1','277','1',1,'Retail Sale Id 2753',997.36,0.00,0.00,1.37,-50.69,'2022-08-15 19:21:11','',''),(2732,'1','277','1',1,'Return of Retail Sale Id 2753',0.00,997.36,1.37,0.00,50.69,'2022-08-15 19:22:20','',''),(2733,'1','277','1',1,'Retail Sale Id 2754',800.80,0.00,0.00,1.10,-40.70,'2022-08-15 19:23:30','',''),(2734,'1','277','1',1,'Retail Sale Id 2755',9100.00,0.00,0.00,12.50,-462.50,'2022-08-15 19:26:11','',''),(2735,'1','277','1',1,'Retail Sale Id 2756',2999.36,0.00,0.00,4.12,-152.44,'2022-08-15 19:26:58','',''),(2736,'1','277','1',1,'Retail Sale Id 2757',3501.68,0.00,0.00,4.81,-177.97,'2022-08-16 06:47:32','',''),(2737,'1','277','1',1,'Retail Sale Id 2758',1499.68,0.00,0.00,2.06,-76.22,'2022-08-16 06:56:39','',''),(2738,'1','277','1',1,'Retail Sale Id 2759',2184.00,0.00,0.00,3.00,-111.00,'2022-08-16 07:30:19','',''),(2739,'1','277','1',1,'Retail Sale Id 2760',2999.36,0.00,0.00,4.12,-152.44,'2022-08-16 07:32:58','',''),(2740,'1','277','1',1,'Retail Sale Id 2761',2497.04,0.00,0.00,3.43,-126.91,'2022-08-16 07:36:45','',''),(2741,'1','277','1',1,'Retail Sale Id 2762',4499.04,0.00,0.00,6.18,-228.66,'2022-08-16 07:47:08','',''),(2742,'1','277','1',1,'Retail Sale Id 2763',2999.36,0.00,0.00,4.12,-152.44,'2022-08-16 07:50:20','',''),(2743,'1','277','1',1,'Retail Sale Id 2764',3996.72,0.00,0.00,5.49,-203.13,'2022-08-16 07:53:43','',''),(2744,'1','277','1',1,'Retail Sale Id 2766',1499.68,0.00,0.00,2.06,-76.22,'2022-08-16 09:03:25','',''),(2745,'1','277','1',1,'Retail Sale Id 2767',2999.36,0.00,0.00,4.12,-152.44,'2022-08-16 09:04:41','',''),(2746,'1','277','1',1,'Retail Sale Id 2768',2002.00,0.00,0.00,2.75,-101.75,'2022-08-16 09:19:38','',''),(2747,'1','277','1',1,'Retail Sale Id 2769',1499.68,0.00,0.00,2.06,-76.22,'2022-08-16 09:24:49','',''),(2748,'1','277','1',1,'Retail Sale Id 2770',4368.00,0.00,0.00,6.00,-222.00,'2022-08-16 09:28:13','',''),(2749,'1','277','1',1,'Retail Sale Id 2771',11298.56,0.00,0.00,15.52,-574.24,'2022-08-16 09:33:19','',''),(2750,'1','277','1',1,'Retail Sale Id 2772',997.36,0.00,0.00,1.37,-50.69,'2022-08-16 09:34:07','',''),(2751,'1','277','1',1,'Retail Sale Id 2773',9100.00,0.00,0.00,12.50,-462.50,'2022-08-16 09:38:32','',''),(2752,'1','277','1',1,'Retail Sale Id 2774',10701.60,0.00,0.00,14.70,-543.90,'2022-08-16 09:39:13','',''),(2753,'1','277','1',1,'Retail Sale Id 2775',997.36,0.00,0.00,1.37,-50.69,'2022-08-16 09:43:30','',''),(2754,'1','277','1',1,'Retail Sale Id 2776',5824.00,0.00,0.00,8.00,-296.00,'2022-08-16 09:47:52','',''),(2755,'1','277','1',1,'Retail Sale Id 2777',997.36,0.00,0.00,1.37,-50.69,'2022-08-16 09:49:01','',''),(2756,'1','277','1',1,'Retail Sale Id 2778',4302.48,0.00,0.00,5.91,-218.67,'2022-08-16 09:53:52','',''),(2757,'1','277','1',1,'Retail Sale Id 2779',91000.00,0.00,0.00,125.00,-4625.00,'2022-08-16 10:00:51','',''),(2758,'1','277','1',1,'Retail Sale Id 2780',4499.04,0.00,0.00,6.18,-228.66,'2022-08-16 10:17:41','',''),(2759,'1','277','1',1,'Retail Sale Id 2781',2300.48,0.00,0.00,3.16,-116.92,'2022-08-16 10:38:31','',''),(2760,'1','277','1',1,'Retail Sale Id 2782',1499.68,0.00,0.00,2.06,-76.22,'2022-08-16 10:55:45','',''),(2761,'1','277','1',1,'Retail Sale Id 2783',2198.56,0.00,0.00,3.02,-111.74,'2022-08-16 10:58:52','',''),(2762,'1','277','1',1,'Retail Sale Id 2784',2999.36,0.00,0.00,4.12,-152.44,'2022-08-16 11:02:47','',''),(2763,'1','277','1',1,'Retail Sale Id 2785',2198.56,0.00,0.00,3.02,-111.74,'2022-08-16 11:03:55','',''),(2764,'1','277','1',1,'Retail Sale Id 2786',2198.56,0.00,0.00,3.02,-111.74,'2022-08-16 11:09:33','',''),(2765,'1','277','1',1,'Retail Sale Id 2787',1499.68,0.00,0.00,2.06,-76.22,'2022-08-16 11:13:02','',''),(2766,'1','277','1',1,'Retail Sale Id 2788',4397.12,0.00,0.00,6.04,-223.48,'2022-08-16 11:29:06','',''),(2767,'1','277','1',1,'Retail Sale Id 2789',997.36,0.00,0.00,1.37,-50.69,'2022-08-16 11:34:11','',''),(2768,'1','277','1',1,'Retail Sale Id 2790',1499.68,0.00,0.00,2.06,-76.22,'2022-08-16 11:36:37','',''),(2769,'1','277','1',1,'Retail Sale Id 2791',2002.00,0.00,0.00,2.75,-101.75,'2022-08-16 11:45:22','',''),(2770,'1','277','1',1,'Retail Sale Id 2793',4397.12,0.00,0.00,6.04,-223.48,'2022-08-16 11:56:23','',''),(2771,'1','277','1',1,'Retail Sale Id 2794',4397.12,0.00,0.00,6.04,-223.48,'2022-08-16 12:00:31','',''),(2772,'1','277','1',1,'Retail Sale Id 2795',9100.00,0.00,0.00,12.50,-462.50,'2022-08-16 12:02:10','',''),(2773,'1','277','1',1,'Retail Sale Id 2796',7280.00,0.00,0.00,10.00,-370.00,'2022-08-16 12:09:11','',''),(2774,'1','277','1',1,'Retail Sale Id 2797',4397.12,0.00,0.00,6.04,-223.48,'2022-08-16 12:21:18','',''),(2775,'1','277','1',1,'Retail Sale Id 2798',9100.00,0.00,0.00,12.50,-462.50,'2022-08-16 12:24:09','',''),(2776,'1','277','1',1,'Retail Sale Id 2799',7280.00,0.00,0.00,10.00,-370.00,'2022-08-16 12:39:10','',''),(2777,'1','277','1',1,'Retail Sale Id 2800',1499.68,0.00,0.00,2.06,-76.22,'2022-08-16 12:40:26','',''),(2778,'1','277','1',1,'Retail Sale Id 2801',2198.56,0.00,0.00,3.02,-111.74,'2022-08-16 12:48:57','',''),(2779,'1','277','1',1,'Retail Sale Id 2802',4397.12,0.00,0.00,6.04,-223.48,'2022-08-16 12:59:08','',''),(2780,'1','277','1',1,'Retail Sale Id 2803',3647.28,0.00,0.00,5.01,-185.37,'2022-08-16 13:00:10','',''),(2781,'1','277','1',1,'Retail Sale Id 2804',1499.68,0.00,0.00,2.06,-76.22,'2022-08-16 13:02:50','',''),(2782,'1','277','1',1,'Retail Sale Id 2805',1499.68,0.00,0.00,2.06,-76.22,'2022-08-16 13:31:56','',''),(2783,'1','277','1',1,'Retail Sale Id 2806',4397.12,0.00,0.00,6.04,-223.48,'2022-08-16 13:33:35','',''),(2784,'1','277','1',1,'Retail Sale Id 2807',997.36,0.00,0.00,1.37,-50.69,'2022-08-16 13:36:20','',''),(2785,'1','277','1',1,'Retail Sale Id 2808',4397.12,0.00,0.00,6.04,-223.48,'2022-08-16 13:39:16','',''),(2786,'1','277','1',1,'Retail Sale Id 2810',2002.00,0.00,0.00,2.75,-101.75,'2022-08-16 13:40:12','',''),(2787,'1','277','1',1,'Retail Sale Id 2811',502.32,0.00,0.00,0.69,-25.53,'2022-08-16 13:41:30','',''),(2788,'1','277','1',1,'Retail Sale Id 2812',1499.68,0.00,0.00,2.06,-76.22,'2022-08-16 13:42:21','',''),(2789,'1','277','1',1,'Retail Sale Id 2813',1499.68,0.00,0.00,2.06,-76.22,'2022-08-16 13:43:04','',''),(2790,'1','277','1',1,'Retail Sale Id 2815',1499.68,0.00,0.00,2.06,-76.22,'2022-08-16 13:48:15','',''),(2791,'1','277','1',1,'Retail Sale Id 2816',42600.00,0.00,0.00,60.00,-3300.00,'2022-08-16 13:53:18','',''),(2792,'1','277','1',1,'Retail Sale Id 2817',2002.00,0.00,0.00,2.75,-101.75,'2022-08-16 14:28:39','',''),(2793,'1','277','1',1,'Retail Sale Id 2818',19880.00,0.00,0.00,28.00,-1540.00,'2022-08-16 14:38:25','',''),(2794,'1','277','1',1,'Retail Sale Id 2820',13839.28,0.00,0.00,19.01,-703.37,'2022-08-16 14:48:40','',''),(2795,'1','277','1',1,'Retail Sale Id 2821',9100.00,0.00,0.00,12.50,-462.50,'2022-08-16 14:50:12','',''),(2796,'1','277','1',1,'Retail Sale Id 2822',1499.68,0.00,0.00,2.06,-76.22,'2022-08-16 14:55:21','',''),(2797,'1','277','1',1,'Retail Sale Id 2823',3501.68,0.00,0.00,4.81,-177.97,'2022-08-16 15:00:24','',''),(2798,'1','277','1',1,'Retail Sale Id 2824',3996.72,0.00,0.00,5.49,-203.13,'2022-08-16 15:01:24','',''),(2799,'1','277','1',1,'Retail Sale Id 2825',997.36,0.00,0.00,1.37,-50.69,'2022-08-16 15:02:17','',''),(2800,'1','277','1',1,'Retail Sale Id 2826',997.36,0.00,0.00,1.37,-50.69,'2022-08-16 15:04:28','',''),(2801,'1','277','1',1,'Retail Sale Id 2827',4397.12,0.00,0.00,6.04,-223.48,'2022-08-16 15:05:31','',''),(2802,'1','277','1',1,'Retail Sale Id 2828',5001.36,0.00,0.00,6.87,-254.19,'2022-08-16 15:17:42','',''),(2803,'1','277','1',1,'Retail Sale Id 2829',4397.12,0.00,0.00,6.04,-223.48,'2022-08-16 15:18:55','',''),(2804,'1','277','1',1,'Retail Sale Id 2830',4397.12,0.00,0.00,6.04,-223.48,'2022-08-16 15:21:30','',''),(2805,'1','277','1',1,'Retail Sale Id 2831',2002.00,0.00,0.00,2.75,-101.75,'2022-08-16 15:31:50','',''),(2806,'1','277','1',1,'Retail Sale Id 2832',5001.36,0.00,0.00,6.87,-254.19,'2022-08-16 15:40:39','',''),(2807,'1','277','1',1,'Retail Sale Id 2833',3647.28,0.00,0.00,5.01,-185.37,'2022-08-16 15:41:28','',''),(2808,'1','277','1',1,'Retail Sale Id 2834',2002.00,0.00,0.00,2.75,-101.75,'2022-08-16 15:42:16','',''),(2809,'1','277','1',1,'Retail Sale Id 2835',997.36,0.00,0.00,1.37,-50.69,'2022-08-16 15:46:05','',''),(2810,'1','277','1',1,'Retail Sale Id 2836',9100.00,0.00,0.00,12.50,-462.50,'2022-08-16 15:47:50','',''),(2811,'1','277','1',1,'Retail Sale Id 2837',2002.00,0.00,0.00,2.75,-101.75,'2022-08-16 15:48:56','',''),(2812,'1','277','1',1,'Retail Sale Id 2838',1499.68,0.00,0.00,2.06,-76.22,'2022-08-16 16:18:02','',''),(2813,'1','277','1',1,'Retail Sale Id 2839',1499.68,0.00,0.00,2.06,-76.22,'2022-08-16 16:20:46','',''),(2814,'1','277','1',1,'Retail Sale Id 2840',3996.72,0.00,0.00,5.49,-203.13,'2022-08-16 16:23:51','',''),(2815,'1','277','1',1,'Retail Sale Id 2841',4397.12,0.00,0.00,6.04,-223.48,'2022-08-16 16:38:55','',''),(2816,'1','277','1',1,'Retail Sale Id 2842',4397.12,0.00,0.00,6.04,-223.48,'2022-08-16 16:40:18','',''),(2817,'1','277','1',1,'Retail Sale Id 2843',3800.16,0.00,0.00,5.22,-193.14,'2022-08-16 16:42:31','',''),(2818,'1','277','1',1,'Retail Sale Id 2844',3640.00,0.00,0.00,5.00,-185.00,'2022-08-16 16:43:33','',''),(2819,'1','277','1',1,'Retail Sale Id 2845',2198.56,0.00,0.00,3.02,-111.74,'2022-08-16 16:52:00','',''),(2820,'1','277','1',1,'Retail Sale Id 2846',2002.00,0.00,0.00,2.75,-101.75,'2022-08-16 16:54:39','',''),(2821,'1','277','1',1,'Retail Sale Id 2847',997.36,0.00,0.00,1.37,-50.69,'2022-08-16 16:58:18','',''),(2822,'1','277','1',1,'Retail Sale Id 2848',5001.36,0.00,0.00,6.87,-254.19,'2022-08-16 16:59:16','',''),(2823,'1','277','1',1,'Retail Sale Id 2849',800.80,0.00,0.00,1.10,-40.70,'2022-08-16 17:01:12','',''),(2824,'1','277','1',1,'Retail Sale Id 2850',2497.04,0.00,0.00,3.43,-126.91,'2022-08-16 17:03:31','',''),(2825,'1','277','1',1,'Retail Sale Id 2851',2198.56,0.00,0.00,3.02,-111.74,'2022-08-16 17:06:20','',''),(2826,'1','277','1',1,'Retail Sale Id 2852',997.36,0.00,0.00,1.37,-50.69,'2022-08-16 17:07:42','',''),(2827,'1','277','1',1,'Retail Sale Id 2854',4397.12,0.00,0.00,6.04,-223.48,'2022-08-16 17:22:02','',''),(2828,'1','277','1',1,'Retail Sale Id 2855',1499.68,0.00,0.00,2.06,-76.22,'2022-08-16 17:22:59','',''),(2829,'1','277','1',1,'Retail Sale Id 2856',2002.00,0.00,0.00,2.75,-101.75,'2022-08-16 17:24:46','',''),(2830,'1','277','1',1,'Retail Sale Id 2857',4397.12,0.00,0.00,6.04,-223.48,'2022-08-16 17:26:17','',''),(2831,'1','277','1',1,'Retail Sale Id 2858',997.36,0.00,0.00,1.37,-50.69,'2022-08-16 17:29:37','',''),(2832,'1','277','1',1,'Retail Sale Id 2859',698.88,0.00,0.00,0.96,-35.52,'2022-08-16 17:34:55','',''),(2833,'1','277','1',1,'Retail Sale Id 2860',2999.36,0.00,0.00,4.12,-152.44,'2022-08-16 17:35:41','',''),(2834,'1','277','1',1,'Retail Sale Id 2861',1499.68,0.00,0.00,2.06,-76.22,'2022-08-16 17:36:24','',''),(2835,'1','277','1',1,'Retail Sale Id 2862',3661.84,0.00,0.00,5.03,-186.11,'2022-08-16 17:39:24','',''),(2836,'1','277','1',1,'Retail Sale Id 2863',3996.72,0.00,0.00,5.49,-203.13,'2022-08-16 17:41:47','',''),(2837,'1','277','1',1,'Retail Sale Id 2864',2999.36,0.00,0.00,4.12,-152.44,'2022-08-16 17:47:30','',''),(2838,'1','277','1',1,'Retail Sale Id 2865',2999.36,0.00,0.00,4.12,-152.44,'2022-08-16 17:50:19','',''),(2839,'1','277','1',1,'Retail Sale Id 2866',800.80,0.00,0.00,1.10,-40.70,'2022-08-16 17:57:02','',''),(2840,'1','277','1',1,'Retail Sale Id 2867',997.36,0.00,0.00,1.37,-50.69,'2022-08-16 18:08:01','',''),(2841,'1','277','1',1,'Retail Sale Id 2868',2497.04,0.00,0.00,3.43,-126.91,'2022-08-16 18:10:15','',''),(2842,'1','277','1',1,'Retail Sale Id 2869',3501.68,0.00,0.00,4.81,-177.97,'2022-08-16 18:14:34','',''),(2843,'1','277','1',1,'Retail Sale Id 2870',3996.72,0.00,0.00,5.49,-203.13,'2022-08-16 18:18:25','',''),(2844,'1','277','1',1,'Retail Sale Id 2871',502.32,0.00,0.00,0.69,-25.53,'2022-08-16 18:21:34','',''),(2845,'1','277','1',1,'Retail Sale Id 2872',2002.00,0.00,0.00,2.75,-101.75,'2022-08-16 18:23:23','',''),(2846,'1','277','1',1,'Retail Sale Id 2873',1499.68,0.00,0.00,2.06,-76.22,'2022-08-16 18:24:32','',''),(2847,'1','277','1',1,'Retail Sale Id 2874',1499.68,0.00,0.00,2.06,-76.22,'2022-08-16 18:32:56','',''),(2848,'1','277','1',1,'Retail Sale Id 2875',1499.68,0.00,0.00,2.06,-76.22,'2022-08-16 18:37:04','',''),(2849,'1','277','1',1,'Retail Sale Id 2876',1499.68,0.00,0.00,2.06,-76.22,'2022-08-16 18:37:45','',''),(2850,'1','277','1',1,'Retail Sale Id 2877',2999.36,0.00,0.00,4.12,-152.44,'2022-08-16 18:41:15','',''),(2851,'1','277','1',1,'Retail Sale Id 2878',2999.36,0.00,0.00,4.12,-152.44,'2022-08-16 18:42:02','',''),(2852,'1','277','1',1,'Retail Sale Id 2879',800.80,0.00,0.00,1.10,-40.70,'2022-08-16 18:42:58','',''),(2853,'1','277','1',1,'Retail Sale Id 2880',2999.36,0.00,0.00,4.12,-152.44,'2022-08-16 18:46:37','',''),(2854,'1','277','1',1,'Retail Sale Id 2881',4397.12,0.00,0.00,6.04,-223.48,'2022-08-16 18:51:37','',''),(2855,'1','277','1',1,'Retail Sale Id 2882',698.88,0.00,0.00,0.96,-35.52,'2022-08-16 18:57:08','',''),(2856,'1','277','1',1,'Retail Sale Id 2883',1499.68,0.00,0.00,2.06,-76.22,'2022-08-16 19:17:08','',''),(2857,'1','277','1',1,'Retail Sale Id 2884',4397.12,0.00,0.00,6.04,-223.48,'2022-08-16 19:18:46','',''),(2858,'1','277','1',1,'Retail Sale Id 2885',2315.04,0.00,0.00,3.18,-117.66,'2022-08-16 19:46:09','',''),(2859,'1','277','1',1,'Retail Sale Id 2886',2198.56,0.00,0.00,3.02,-111.74,'2022-08-17 06:52:33','',''),(2860,'1','277','1',1,'Retail Sale Id 2887',902.72,0.00,0.00,1.24,-45.88,'2022-08-17 07:11:07','',''),(2861,'1','277','1',1,'Retail Sale Id 2888',2198.56,0.00,0.00,3.02,-111.74,'2022-08-17 07:29:14','',''),(2862,'1','277','1',1,'Retail Sale Id 2890',3996.72,0.00,0.00,5.49,-203.13,'2022-08-17 07:33:40','',''),(2863,'1','277','1',1,'Retail Sale Id 2891',4397.12,0.00,0.00,6.04,-223.48,'2022-08-17 08:07:51','',''),(2864,'1','277','1',1,'Retail Sale Id 2892',3996.72,0.00,0.00,5.49,-203.13,'2022-08-17 08:09:08','',''),(2865,'1','277','1',1,'Retail Sale Id 2894',4397.12,0.00,0.00,6.04,-223.48,'2022-08-17 08:23:33','',''),(2866,'1','277','1',1,'Retail Sale Id 2895',5103.28,0.00,0.00,7.01,-259.37,'2022-08-17 08:50:55','',''),(2867,'1','277','1',1,'Retail Sale Id 2896',3698.24,0.00,0.00,5.08,-187.96,'2022-08-17 08:58:58','',''),(2868,'1','277','1',1,'Retail Sale Id 2897',3996.72,0.00,0.00,5.49,-203.13,'2022-08-17 09:05:05','',''),(2869,'1','277','1',1,'Retail Sale Id 2898',997.36,0.00,0.00,1.37,-50.69,'2022-08-17 09:05:48','',''),(2870,'1','277','1',1,'Retail Sale Id 2899',3501.68,0.00,0.00,4.81,-177.97,'2022-08-17 09:10:38','',''),(2871,'1','277','1',1,'Retail Sale Id 2900',4302.48,0.00,0.00,5.91,-218.67,'2022-08-17 09:22:03','',''),(2872,'1','277','1',1,'Retail Sale Id 2901',9100.00,0.00,0.00,12.50,-462.50,'2022-08-17 09:25:35','',''),(2873,'1','277','1',1,'Retail Sale Id 2902',7003.36,0.00,0.00,9.62,-355.94,'2022-08-17 09:27:11','',''),(2874,'1','277','1',1,'Retail Sale Id 2903',2002.00,0.00,0.00,2.75,-101.75,'2022-08-17 09:35:10','',''),(2875,'1','277','1',1,'Retail Sale Id 2904',3698.24,0.00,0.00,5.08,-187.96,'2022-08-17 09:46:47','',''),(2876,'1','277','1',1,'Retail Sale Id 2905',997.36,0.00,0.00,1.37,-50.69,'2022-08-17 09:48:02','',''),(2877,'1','277','1',1,'Retail Sale Id 2906',7003.36,0.00,0.00,9.62,-355.94,'2022-08-17 09:51:21','',''),(2878,'1','277','1',1,'Retail Sale Id 2907',1499.68,0.00,0.00,2.06,-76.22,'2022-08-17 09:52:52','',''),(2879,'1','277','1',1,'Retail Sale Id 2908',2999.36,0.00,0.00,4.12,-152.44,'2022-08-17 09:56:48','',''),(2880,'1','277','1',1,'Retail Sale Id 2909',1499.68,0.00,0.00,2.06,-76.22,'2022-08-17 09:59:57','',''),(2881,'1','277','1',1,'Retail Sale Id 2910',2198.56,0.00,0.00,3.02,-111.74,'2022-08-17 10:03:23','',''),(2882,'1','277','1',1,'Retail Sale Id 2911',9100.00,0.00,0.00,12.50,-462.50,'2022-08-17 10:06:17','',''),(2883,'1','277','1',1,'Retail Sale Id 2912',298.48,0.00,0.00,0.41,-15.17,'2022-08-17 10:07:08','',''),(2884,'1','277','1',1,'Retail Sale Id 2913',4397.12,0.00,0.00,6.04,-223.48,'2022-08-17 10:08:11','',''),(2885,'1','277','1',1,'Retail Sale Id 2914',7280.00,0.00,0.00,10.00,-370.00,'2022-08-17 10:17:05','',''),(2886,'1','277','1',1,'Retail Sale Id 2915',2497.04,0.00,0.00,3.43,-126.91,'2022-08-17 10:17:58','',''),(2887,'1','277','1',1,'Retail Sale Id 2916',9100.00,0.00,0.00,12.50,-462.50,'2022-08-17 10:22:56','',''),(2888,'1','277','1',1,'Retail Sale Id 2917',1499.68,0.00,0.00,2.06,-76.22,'2022-08-17 10:28:42','',''),(2889,'1','277','1',1,'Retail Sale Id 2918',4397.12,0.00,0.00,6.04,-223.48,'2022-08-17 10:34:26','',''),(2890,'1','277','1',1,'Retail Sale Id 2919',2300.48,0.00,0.00,3.16,-116.92,'2022-08-17 10:36:17','',''),(2891,'1','277','1',1,'Retail Sale Id 2920',5998.72,0.00,0.00,8.24,-304.88,'2022-08-17 10:37:38','',''),(2892,'1','277','1',1,'Retail Sale Id 2922',9100.00,0.00,0.00,12.50,-462.50,'2022-08-17 10:47:41','',''),(2893,'1','277','1',1,'Retail Sale Id 2923',997.36,0.00,0.00,1.37,-50.69,'2022-08-17 10:49:53','',''),(2894,'1','277','1',1,'Retail Sale Id 2924',3698.24,0.00,0.00,5.08,-187.96,'2022-08-17 10:51:54','',''),(2895,'1','277','1',1,'Retail Sale Id 2925',9100.00,0.00,0.00,12.50,-462.50,'2022-08-17 11:05:55','',''),(2896,'1','277','1',1,'Retail Sale Id 2927',3698.24,0.00,0.00,5.08,-187.96,'2022-08-17 11:23:45','',''),(2897,'1','277','1',1,'Retail Sale Id 2928',13468.00,0.00,0.00,18.50,-684.50,'2022-08-17 11:32:15','',''),(2898,'1','277','1',1,'Retail Sale Id 2929',1499.68,0.00,0.00,2.06,-76.22,'2022-08-17 11:33:29','',''),(2899,'1','277','1',1,'Retail Sale Id 2930',9100.00,0.00,0.00,12.50,-462.50,'2022-08-17 11:34:35','',''),(2900,'1','277','1',1,'Retail Sale Id 2931',3996.72,0.00,0.00,5.49,-203.13,'2022-08-17 11:36:14','',''),(2901,'1','277','1',1,'Retail Sale Id 2932',4302.48,0.00,0.00,5.91,-218.67,'2022-08-17 11:44:34','',''),(2902,'1','277','1',1,'Retail Sale Id 2933',4499.04,0.00,0.00,6.18,-228.66,'2022-08-17 11:45:24','',''),(2903,'1','277','1',1,'Retail Sale Id 2934',2198.56,0.00,0.00,3.02,-111.74,'2022-08-17 11:51:57','',''),(2904,'1','277','1',1,'Retail Sale Id 2935',9100.00,0.00,0.00,12.50,-462.50,'2022-08-17 11:57:53','',''),(2905,'1','277','1',1,'Retail Sale Id 2937',3698.24,0.00,0.00,5.08,-187.96,'2022-08-17 12:14:28','',''),(2906,'1','277','1',1,'Retail Sale Id 2938',2002.00,0.00,0.00,2.75,-101.75,'2022-08-17 12:21:56','',''),(2907,'1','277','1',1,'Retail Sale Id 2939',1397.76,0.00,0.00,1.92,-71.04,'2022-08-17 12:41:48','',''),(2908,'1','277','1',1,'Retail Sale Id 2940',997.36,0.00,0.00,1.37,-50.69,'2022-08-17 12:46:42','',''),(2909,'1','277','1',1,'Retail Sale Id 2941',7280.00,0.00,0.00,10.00,-370.00,'2022-08-17 12:53:38','',''),(2910,'1','277','1',1,'Retail Sale Id 2943',4368.00,0.00,0.00,6.00,-222.00,'2022-08-17 12:55:48','',''),(2911,'1','277','1',1,'Retail Sale Id 2944',2999.36,0.00,0.00,4.12,-152.44,'2022-08-17 12:58:06','',''),(2912,'1','277','1',1,'Retail Sale Id 2945',2002.00,0.00,0.00,2.75,-101.75,'2022-08-17 13:03:47','',''),(2913,'1','277','1',1,'Retail Sale Id 2946',4397.12,0.00,0.00,6.04,-223.48,'2022-08-17 13:17:46','',''),(2914,'1','277','1',1,'Retail Sale Id 2947',4302.48,0.00,0.00,5.91,-218.67,'2022-08-17 13:18:24','',''),(2915,'1','277','1',1,'Retail Sale Id 2948',3501.68,0.00,0.00,4.81,-177.97,'2022-08-17 13:19:19','',''),(2916,'1','277','1',1,'Retail Sale Id 2949',1921.92,0.00,0.00,2.64,-97.68,'2022-08-17 13:32:48','',''),(2917,'1','277','1',1,'Retail Sale Id 2950',4302.48,0.00,0.00,5.91,-218.67,'2022-08-17 13:46:58','',''),(2918,'1','277','1',1,'Retail Sale Id 2951',997.36,0.00,0.00,1.37,-50.69,'2022-08-17 14:24:29','',''),(2919,'1','277','1',1,'Retail Sale Id 2952',1463.28,0.00,0.00,2.01,-74.37,'2022-08-17 14:34:17','',''),(2920,'1','277','1',1,'Retail Sale Id 2953',2497.04,0.00,0.00,3.43,-126.91,'2022-08-17 14:43:01','',''),(2921,'1','277','1',1,'Retail Sale Id 2954',3640.00,0.00,0.00,5.00,-185.00,'2022-08-17 14:46:15','',''),(2922,'1','277','1',1,'Retail Sale Id 2955',5853.12,0.00,0.00,8.04,-297.48,'2022-08-17 15:03:05','',''),(2923,'1','277','1',1,'Retail Sale Id 2956',997.36,0.00,0.00,1.37,-50.69,'2022-08-17 15:18:57','',''),(2924,'1','277','1',1,'Retail Sale Id 2957',2198.56,0.00,0.00,3.02,-111.74,'2022-08-17 15:22:27','',''),(2925,'1','277','1',1,'Retail Sale Id 2958',2999.36,0.00,0.00,4.12,-152.44,'2022-08-17 15:46:53','',''),(2926,'1','277','1',1,'Retail Sale Id 2959',2002.00,0.00,0.00,2.75,-101.75,'2022-08-17 15:52:46','',''),(2927,'1','277','1',1,'Retail Sale Id 2960',2999.36,0.00,0.00,4.12,-152.44,'2022-08-17 15:57:56','',''),(2928,'1','277','1',1,'Retail Sale Id 2961',1499.68,0.00,0.00,2.06,-76.22,'2022-08-17 16:12:49','',''),(2929,'1','277','1',1,'Retail Sale Id 2962',2198.56,0.00,0.00,3.02,-111.74,'2022-08-17 16:18:09','',''),(2930,'1','277','1',1,'Retail Sale Id 2963',7280.00,0.00,0.00,10.00,-370.00,'2022-08-17 16:20:38','',''),(2931,'1','277','1',1,'Retail Sale Id 2964',1499.68,0.00,0.00,2.06,-76.22,'2022-08-17 16:24:58','',''),(2932,'1','277','1',1,'Retail Sale Id 2965',2002.00,0.00,0.00,2.75,-101.75,'2022-08-17 16:27:42','',''),(2933,'1','277','1',1,'Retail Sale Id 2966',997.36,0.00,0.00,1.37,-50.69,'2022-08-17 16:42:54','',''),(2934,'1','277','1',1,'Retail Sale Id 2967',9100.00,0.00,0.00,12.50,-462.50,'2022-08-17 16:51:38','',''),(2935,'1','277','1',1,'Retail Sale Id 2968',4397.12,0.00,0.00,6.04,-223.48,'2022-08-17 16:58:38','',''),(2936,'1','277','1',1,'Retail Sale Id 2969',9100.00,0.00,0.00,12.50,-462.50,'2022-08-17 17:03:45','',''),(2937,'1','277','1',1,'Retail Sale Id 2970',1499.68,0.00,0.00,2.06,-76.22,'2022-08-17 17:07:48','',''),(2938,'1','277','1',1,'Retail Sale Id 2971',997.36,0.00,0.00,1.37,-50.69,'2022-08-17 17:12:09','',''),(2939,'1','277','1',1,'Retail Sale Id 2972',9100.00,0.00,0.00,12.50,-462.50,'2022-08-17 17:18:47','',''),(2940,'1','277','1',1,'Retail Sale Id 2973',2198.56,0.00,0.00,3.02,-111.74,'2022-08-17 17:19:20','',''),(2941,'1','277','1',1,'Retail Sale Id 2974',2300.48,0.00,0.00,3.16,-116.92,'2022-08-17 17:25:42','',''),(2942,'1','277','1',1,'Retail Sale Id 2975',4302.48,0.00,0.00,5.91,-218.67,'2022-08-17 17:28:16','',''),(2943,'1','277','1',1,'Retail Sale Id 2976',2002.00,0.00,0.00,2.75,-101.75,'2022-08-17 17:31:54','',''),(2944,'1','277','1',1,'Retail Sale Id 2977',997.36,0.00,0.00,1.37,-50.69,'2022-08-17 17:32:38','',''),(2945,'1','277','1',1,'Retail Sale Id 2978',2002.00,0.00,0.00,2.75,-101.75,'2022-08-17 17:33:12','',''),(2946,'1','277','1',1,'Retail Sale Id 2980',2999.36,0.00,0.00,4.12,-152.44,'2022-08-17 17:34:13','',''),(2947,'1','277','1',1,'Retail Sale Id 2981',4397.12,0.00,0.00,6.04,-223.48,'2022-08-17 17:35:23','',''),(2948,'1','277','1',1,'Retail Sale Id 2982',1397.76,0.00,0.00,1.92,-71.04,'2022-08-17 17:36:29','',''),(2949,'1','277','1',1,'Retail Sale Id 2983',997.36,0.00,0.00,1.37,-50.69,'2022-08-17 17:41:36','',''),(2950,'1','277','1',1,'Retail Sale Id 2984',2999.36,0.00,0.00,4.12,-152.44,'2022-08-17 17:48:09','',''),(2951,'1','277','1',1,'Retail Sale Id 2985',800.80,0.00,0.00,1.10,-40.70,'2022-08-17 17:50:23','',''),(2952,'1','277','1',1,'Retail Sale Id 2986',3698.24,0.00,0.00,5.08,-187.96,'2022-08-17 17:54:29','',''),(2953,'1','277','1',1,'Retail Sale Id 2988',1303.12,0.00,0.00,1.79,-66.23,'2022-08-17 17:55:21','',''),(2954,'1','277','1',1,'Retail Sale Id 2989',9100.00,0.00,0.00,12.50,-462.50,'2022-08-17 18:02:53','',''),(2955,'1','277','1',1,'Retail Sale Id 2990',1499.68,0.00,0.00,2.06,-76.22,'2022-08-17 18:03:35','',''),(2956,'1','277','1',1,'Retail Sale Id 2991',2999.36,0.00,0.00,4.12,-152.44,'2022-08-17 18:04:52','',''),(2957,'1','277','1',1,'Retail Sale Id 2992',800.80,0.00,0.00,1.10,-40.70,'2022-08-17 18:13:39','',''),(2958,'1','277','1',1,'Retail Sale Id 2993',1601.60,0.00,0.00,2.20,-81.40,'2022-08-17 18:14:17','',''),(2959,'1','277','1',1,'Retail Sale Id 2994',1499.68,0.00,0.00,2.06,-76.22,'2022-08-17 18:15:47','',''),(2960,'1','277','1',1,'Retail Sale Id 2995',997.36,0.00,0.00,1.37,-50.69,'2022-08-17 18:30:08','',''),(2961,'1','277','1',1,'Retail Sale Id 2996',997.36,0.00,0.00,1.37,-50.69,'2022-08-17 18:40:36','',''),(2962,'1','277','1',1,'Retail Sale Id 2997',2198.56,0.00,0.00,3.02,-111.74,'2022-08-17 18:44:52','',''),(2963,'1','277','1',1,'Retail Sale Id 2998',1499.68,0.00,0.00,2.06,-76.22,'2022-08-17 19:03:24','',''),(2964,'1','277','1',1,'Retail Sale Id 2999',2497.04,0.00,0.00,3.43,-126.91,'2022-08-17 19:04:17','',''),(2965,'1','277','1',1,'Retail Sale Id 3000',4499.04,0.00,0.00,6.18,-228.66,'2022-08-17 19:05:09','',''),(2966,'1','277','1',1,'Retail Sale Id 3001',997.36,0.00,0.00,1.37,-50.69,'2022-08-17 19:08:23','',''),(2967,'1','277','1',1,'Retail Sale Id 3002',2002.00,0.00,0.00,2.75,-101.75,'2022-08-17 19:10:08','',''),(2968,'1','277','1',1,'Retail Sale Id 3003',800.80,0.00,0.00,1.10,-40.70,'2022-08-17 19:14:40','',''),(2969,'1','277','1',1,'Retail Sale Id 3004',997.36,0.00,0.00,1.37,-50.69,'2022-08-17 19:15:15','',''),(2970,'1','277','1',1,'Retail Sale Id 3005',2002.00,0.00,0.00,2.75,-101.75,'2022-08-17 19:19:13','',''),(2971,'1','277','1',1,'Retail Sale Id 3006',4397.12,0.00,0.00,6.04,-223.48,'2022-08-17 19:46:39','',''),(2972,'1','277','1',1,'Retail Sale Id 3007',2198.56,0.00,0.00,3.02,-111.74,'2022-08-18 07:27:10','',''),(2973,'1','277','1',1,'Retail Sale Id 3008',7199.92,0.00,0.00,9.89,-365.93,'2022-08-18 07:31:08','',''),(2974,'1','277','1',1,'Retail Sale Id 3009',2198.56,0.00,0.00,3.02,-111.74,'2022-08-18 07:35:02','',''),(2975,'1','277','1',1,'Retail Sale Id 3010',2002.00,0.00,0.00,2.75,-101.75,'2022-08-18 07:38:52','',''),(2976,'1','277','1',1,'Retail Sale Id 3011',9100.00,0.00,0.00,12.50,-462.50,'2022-08-18 07:53:14','',''),(2977,'1','277','1',1,'Retail Sale Id 3012',902.72,0.00,0.00,1.24,-45.88,'2022-08-18 08:04:10','',''),(2978,'1','277','1',1,'Retail Sale Id 3013',3996.72,0.00,0.00,5.49,-203.13,'2022-08-18 08:05:35','',''),(2979,'1','277','1',1,'Retail Sale Id 3014',3698.24,0.00,0.00,5.08,-187.96,'2022-08-18 08:18:13','',''),(2980,'1','277','1',1,'Retail Sale Id 3015',800.80,0.00,0.00,1.10,-40.70,'2022-08-18 08:22:48','',''),(2981,'1','277','1',1,'Retail Sale Id 3016',3996.72,0.00,0.00,5.49,-203.13,'2022-08-18 08:42:25','',''),(2982,'1','277','1',1,'Retail Sale Id 3017',502.32,0.00,0.00,0.69,-25.53,'2022-08-18 08:51:19','',''),(2983,'1','277','1',1,'Retail Sale Id 3018',2999.36,0.00,0.00,4.12,-152.44,'2022-08-18 08:52:26','',''),(2984,'1','277','1',1,'Retail Sale Id 3020',728.00,0.00,0.00,1.00,-37.00,'2022-08-18 09:14:14','',''),(2985,'1','277','1',1,'Retail Sale Id 3021',749.84,0.00,0.00,1.03,-38.11,'2022-08-18 09:34:54','',''),(2986,'1','277','1',1,'Retail Sale Id 3022',2198.56,0.00,0.00,3.02,-111.74,'2022-08-18 09:48:56','',''),(2987,'1','277','1',1,'Retail Sale Id 3023',728.00,0.00,0.00,1.00,-37.00,'2022-08-18 09:54:19','',''),(2988,'1','277','1',1,'Retail Sale Id 3024',2002.00,0.00,0.00,2.75,-101.75,'2022-08-18 09:55:05','',''),(2989,'1','277','1',1,'Retail Sale Id 3025',4397.12,0.00,0.00,6.04,-223.48,'2022-08-18 10:14:43','',''),(2990,'1','277','1',1,'Retail Sale Id 3026',3647.28,0.00,0.00,5.01,-185.37,'2022-08-18 10:17:39','',''),(2991,'1','277','1',1,'Retail Sale Id 3027',5001.36,0.00,0.00,6.87,-254.19,'2022-08-18 10:20:03','',''),(2992,'1','277','1',1,'Retail Sale Id 3028',997.36,0.00,0.00,1.37,-50.69,'2022-08-18 10:36:47','',''),(2993,'1','277','1',1,'Retail Sale Id 3029',2002.00,0.00,0.00,2.75,-101.75,'2022-08-18 11:01:53','',''),(2994,'1','277','1',1,'Retail Sale Id 3030',2002.00,0.00,0.00,2.75,-101.75,'2022-08-18 11:04:35','',''),(2995,'1','277','1',1,'Retail Sale Id 3031',997.36,0.00,0.00,1.37,-50.69,'2022-08-18 11:08:01','',''),(2996,'1','277','1',1,'Retail Sale Id 3032',4397.12,0.00,0.00,6.04,-223.48,'2022-08-18 11:11:12','',''),(2997,'1','277','1',1,'Retail Sale Id 3033',14200.00,0.00,0.00,20.00,-1100.00,'2022-08-18 11:20:17','',''),(2998,'1','277','1',1,'Retail Sale Id 3034',800.80,0.00,0.00,1.10,-40.70,'2022-08-18 11:31:05','',''),(2999,'1','277','1',1,'Retail Sale Id 3035',2497.04,0.00,0.00,3.43,-126.91,'2022-08-18 11:47:13','',''),(3000,'1','277','1',1,'Retail Sale Id 3036',9100.00,0.00,0.00,12.50,-462.50,'2022-08-18 11:48:28','',''),(3001,'1','277','1',1,'Retail Sale Id 3037',1703.52,0.00,0.00,2.34,-86.58,'2022-08-18 11:51:08','',''),(3002,'1','277','1',1,'Retail Sale Id 3038',728.00,0.00,0.00,1.00,-37.00,'2022-08-18 11:56:17','',''),(3003,'1','277','1',1,'Retail Sale Id 3039',997.36,0.00,0.00,1.37,-50.69,'2022-08-18 11:59:01','',''),(3004,'1','277','1',1,'Retail Sale Id 3040',1499.68,0.00,0.00,2.06,-76.22,'2022-08-18 12:06:29','',''),(3005,'1','277','1',1,'Retail Sale Id 3041',2198.56,0.00,0.00,3.02,-111.74,'2022-08-18 12:23:39','',''),(3006,'1','277','1',1,'Retail Sale Id 3042',2198.56,0.00,0.00,3.02,-111.74,'2022-08-18 13:24:14','',''),(3007,'1','277','1',1,'Retail Sale Id 3043',8102.64,0.00,0.00,11.13,-411.81,'2022-08-18 13:36:45','',''),(3008,'1','277','1',1,'Retail Sale Id 3044',6646.64,0.00,0.00,9.13,-337.81,'2022-08-18 13:38:40','',''),(3009,'1','277','1',1,'Retail Sale Id 3045',1499.68,0.00,0.00,2.06,-76.22,'2022-08-18 13:41:01','',''),(3010,'1','277','1',1,'Retail Sale Id 3046',2300.48,0.00,0.00,3.16,-116.92,'2022-08-18 14:03:17','',''),(3011,'1','277','1',1,'Retail Sale Id 3047',4397.12,0.00,0.00,6.04,-223.48,'2022-08-18 14:08:10','',''),(3012,'1','277','1',1,'Retail Sale Id 3048',3800.16,0.00,0.00,5.22,-193.14,'2022-08-18 14:20:33','',''),(3013,'1','277','1',1,'Retail Sale Id 3049',1499.68,0.00,0.00,2.06,-76.22,'2022-08-18 14:26:20','',''),(3014,'1','277','1',1,'Retail Sale Id 3050',5824.00,0.00,0.00,8.00,-296.00,'2022-08-18 14:45:43','',''),(3015,'1','277','1',1,'Retail Sale Id 3051',2912.00,0.00,0.00,4.00,-148.00,'2022-08-18 14:47:02','',''),(3016,'1','277','1',1,'Retail Sale Id 3052',1499.68,0.00,0.00,2.06,-76.22,'2022-08-18 14:49:02','',''),(3017,'1','277','1',1,'Retail Sale Id 3053',5998.72,0.00,0.00,8.24,-304.88,'2022-08-18 14:55:48','',''),(3018,'1','277','1',1,'Retail Sale Id 3054',9100.00,0.00,0.00,12.50,-462.50,'2022-08-18 15:17:07','',''),(3019,'1','277','1',1,'Retail Sale Id 3054',9100.00,0.00,0.00,12.50,-462.50,'2022-08-18 15:17:07','',''),(3020,'1','277','1',1,'Retail Sale Id 3055',2002.00,0.00,0.00,2.75,-101.75,'2022-08-18 15:27:21','',''),(3021,'1','277','1',1,'Retail Sale Id 3056',2002.00,0.00,0.00,2.75,-101.75,'2022-08-18 15:39:41','',''),(3022,'1','277','1',1,'Retail Sale Id 3057',2497.04,0.00,0.00,3.43,-126.91,'2022-08-18 15:51:41','',''),(3023,'1','277','1',1,'Retail Sale Id 3058',2999.36,0.00,0.00,4.12,-152.44,'2022-08-18 16:03:06','',''),(3024,'1','277','1',1,'Retail Sale Id 3059',2497.04,0.00,0.00,3.43,-126.91,'2022-08-18 16:11:11','',''),(3025,'1','277','1',1,'Retail Sale Id 3060',7301.84,0.00,0.00,10.03,-371.11,'2022-08-18 16:20:36','',''),(3026,'1','277','1',1,'Retail Sale Id 3061',5103.28,0.00,0.00,7.01,-259.37,'2022-08-18 16:26:52','',''),(3027,'1','277','1',1,'Retail Sale Id 3062',2198.56,0.00,0.00,3.02,-111.74,'2022-08-18 16:29:17','',''),(3028,'1','277','1',1,'Retail Sale Id 3063',3698.24,0.00,0.00,5.08,-187.96,'2022-08-18 16:31:19','',''),(3029,'1','277','1',1,'Retail Sale Id 3064',1499.68,0.00,0.00,2.06,-76.22,'2022-08-18 16:32:09','',''),(3030,'1','277','1',1,'Retail Sale Id 3065',800.80,0.00,0.00,1.10,-40.70,'2022-08-18 16:39:38','',''),(3031,'1','277','1',1,'Retail Sale Id 3066',6501.04,0.00,0.00,8.93,-330.41,'2022-08-18 16:41:05','',''),(3032,'1','277','1',1,'Retail Sale Id 3067',2002.00,0.00,0.00,2.75,-101.75,'2022-08-18 16:44:01','',''),(3033,'1','277','1',1,'Retail Sale Id 3068',2497.04,0.00,0.00,3.43,-126.91,'2022-08-18 16:53:34','',''),(3034,'1','277','1',1,'Retail Sale Id 3069',2198.56,0.00,0.00,3.02,-111.74,'2022-08-18 16:56:32','',''),(3035,'1','277','1',1,'Return of Retail Sale Id 3068',0.00,2497.04,3.43,0.00,126.91,'2022-08-18 16:57:17','',''),(3036,'1','277','1',1,'Retail Sale Id 3070',2002.00,0.00,0.00,2.75,-101.75,'2022-08-18 17:00:30','',''),(3037,'1','277','1',1,'Retail Sale Id 3071',2198.56,0.00,0.00,3.02,-111.74,'2022-08-18 17:02:49','',''),(3038,'1','277','1',1,'Retail Sale Id 3072',1499.68,0.00,0.00,2.06,-76.22,'2022-08-18 17:06:30','',''),(3039,'1','277','1',1,'Retail Sale Id 3073',5001.36,0.00,0.00,6.87,-254.19,'2022-08-18 17:13:40','',''),(3040,'1','277','1',1,'Retail Sale Id 3074',3640.00,0.00,0.00,5.00,-185.00,'2022-08-18 17:23:25','',''),(3041,'1','277','1',1,'Retail Sale Id 3074',9100.00,0.00,0.00,12.50,-462.50,'2022-08-18 17:23:25','',''),(3042,'1','277','1',1,'Retail Sale Id 3075',997.36,0.00,0.00,1.37,-50.69,'2022-08-18 17:41:23','',''),(3043,'1','277','1',1,'Retail Sale Id 3076',2002.00,0.00,0.00,2.75,-101.75,'2022-08-18 17:47:31','',''),(3044,'1','277','1',1,'Retail Sale Id 3077',1499.68,0.00,0.00,2.06,-76.22,'2022-08-18 17:55:02','',''),(3045,'1','277','1',1,'Retail Sale Id 3078',749.84,0.00,0.00,1.03,-38.11,'2022-08-18 18:07:18','',''),(3046,'1','277','1',1,'Retail Sale Id 3079',749.84,0.00,0.00,1.03,-38.11,'2022-08-18 18:07:56','',''),(3047,'1','277','1',1,'Retail Sale Id 3081',4368.00,0.00,0.00,6.00,-222.00,'2022-08-18 18:13:23','',''),(3048,'1','277','1',1,'Retail Sale Id 3082',2198.56,0.00,0.00,3.02,-111.74,'2022-08-18 18:14:29','',''),(3049,'1','277','1',1,'Retail Sale Id 3083',2999.36,0.00,0.00,4.12,-152.44,'2022-08-18 18:28:24','',''),(3050,'1','277','1',1,'Retail Sale Id 3084',800.80,0.00,0.00,1.10,-40.70,'2022-08-18 18:39:23','',''),(3051,'1','277','1',1,'Retail Sale Id 3085',1499.68,0.00,0.00,2.06,-76.22,'2022-08-18 18:42:25','',''),(3052,'1','277','1',1,'Retail Sale Id 3086',3996.72,0.00,0.00,5.49,-203.13,'2022-08-18 18:43:16','',''),(3053,'1','277','1',1,'Retail Sale Id 3087',2999.36,0.00,0.00,4.12,-152.44,'2022-08-18 18:47:08','',''),(3054,'1','277','1',1,'Retail Sale Id 3088',997.36,0.00,0.00,1.37,-50.69,'2022-08-18 18:51:21','',''),(3055,'1','277','1',1,'Retail Sale Id 3089',4368.00,0.00,0.00,6.00,-222.00,'2022-08-18 19:07:32','',''),(3056,'1','277','1',1,'Retail Sale Id 3090',2096.64,0.00,0.00,2.88,-106.56,'2022-08-19 07:19:07','',''),(3057,'1','277','1',1,'Retail Sale Id 3091',4368.00,0.00,0.00,6.00,-222.00,'2022-08-19 07:21:15','',''),(3058,'1','277','1',1,'Retail Sale Id 3092',997.36,0.00,0.00,1.37,-50.69,'2022-08-19 07:46:02','',''),(3059,'1','277','1',1,'Retail Sale Id 3093',2002.00,0.00,0.00,2.75,-101.75,'2022-08-19 07:46:52','',''),(3060,'1','277','1',1,'Retail Sale Id 3094',5001.36,0.00,0.00,6.87,-254.19,'2022-08-19 07:53:09','',''),(3061,'1','277','1',1,'Retail Sale Id 3095',997.36,0.00,0.00,1.37,-50.69,'2022-08-19 07:55:11','',''),(3062,'1','277','1',1,'Retail Sale Id 3096',8998.08,0.00,0.00,12.36,-457.32,'2022-08-19 08:01:31','',''),(3063,'1','277','1',1,'Retail Sale Id 3097',698.88,0.00,0.00,0.96,-35.52,'2022-08-19 08:02:36','',''),(3064,'1','277','1',1,'Retail Sale Id 3098',997.36,0.00,0.00,1.37,-50.69,'2022-08-19 08:06:59','',''),(3065,'1','277','1',1,'Retail Sale Id 3099',2999.36,0.00,0.00,4.12,-152.44,'2022-08-19 08:08:31','',''),(3066,'1','277','1',1,'Retail Sale Id 3100',2198.56,0.00,0.00,3.02,-111.74,'2022-08-19 08:13:14','',''),(3067,'1','277','1',1,'Retail Sale Id 3101',2999.36,0.00,0.00,4.12,-152.44,'2022-08-19 08:16:57','',''),(3068,'1','277','1',1,'Retail Sale Id 3103',749.84,0.00,0.00,1.03,-38.11,'2022-08-19 08:27:13','',''),(3069,'1','277','1',1,'Retail Sale Id 3104',9100.00,0.00,0.00,12.50,-462.50,'2022-08-19 08:28:13','',''),(3070,'1','277','1',1,'Retail Sale Id 3105',2999.36,0.00,0.00,4.12,-152.44,'2022-08-19 08:31:26','',''),(3071,'1','277','1',1,'Retail Sale Id 3106',1499.68,0.00,0.00,2.06,-76.22,'2022-08-19 08:34:31','',''),(3072,'1','277','1',1,'Retail Sale Id 3107',5001.36,0.00,0.00,6.87,-254.19,'2022-08-19 08:44:56','',''),(3073,'1','277','1',1,'Retail Sale Id 3108',2002.00,0.00,0.00,2.75,-101.75,'2022-08-19 08:59:56','',''),(3074,'1','277','1',1,'Retail Sale Id 3109',2002.00,0.00,0.00,2.75,-101.75,'2022-08-19 09:00:41','',''),(3075,'1','277','1',1,'Retail Sale Id 3110',2002.00,0.00,0.00,2.75,-101.75,'2022-08-19 09:06:51','',''),(3076,'1','277','1',1,'Retail Sale Id 3111',2999.36,0.00,0.00,4.12,-152.44,'2022-08-19 09:10:19','',''),(3077,'1','277','1',1,'Retail Sale Id 3112',1499.68,0.00,0.00,2.06,-76.22,'2022-08-19 09:26:01','',''),(3078,'1','277','1',1,'Retail Sale Id 3113',1499.68,0.00,0.00,2.06,-76.22,'2022-08-19 09:29:16','',''),(3079,'1','277','1',1,'Retail Sale Id 3114',2999.36,0.00,0.00,4.12,-152.44,'2022-08-19 09:33:26','',''),(3080,'1','277','1',1,'Retail Sale Id 3115',1499.68,0.00,0.00,2.06,-76.22,'2022-08-19 09:38:49','',''),(3081,'1','277','1',1,'Retail Sale Id 3116',2096.64,0.00,0.00,2.88,-106.56,'2022-08-19 09:50:50','',''),(3082,'1','277','1',1,'Return of Retail Sale Id 3116',0.00,2096.64,2.88,0.00,106.56,'2022-08-19 09:51:41','',''),(3083,'1','277','1',1,'Retail Sale Id 3117',2002.00,0.00,0.00,2.75,-101.75,'2022-08-19 09:52:14','',''),(3084,'1','277','1',1,'Retail Sale Id 3118',997.36,0.00,0.00,1.37,-50.69,'2022-08-19 09:56:24','',''),(3085,'1','277','1',1,'Retail Sale Id 3119',2999.36,0.00,0.00,4.12,-152.44,'2022-08-19 10:34:07','',''),(3086,'1','277','1',1,'Retail Sale Id 3120',1499.68,0.00,0.00,2.06,-76.22,'2022-08-19 10:39:54','',''),(3087,'1','277','1',1,'Retail Sale Id 3121',9100.00,0.00,0.00,12.50,-462.50,'2022-08-19 10:46:42','',''),(3088,'1','277','1',1,'Retail Sale Id 3122',800.80,0.00,0.00,1.10,-40.70,'2022-08-19 10:47:29','',''),(3089,'1','277','1',1,'Retail Sale Id 3123',3501.68,0.00,0.00,4.81,-177.97,'2022-08-19 10:52:59','',''),(3090,'1','277','1',1,'Retail Sale Id 3124',7301.84,0.00,0.00,10.03,-371.11,'2022-08-19 10:57:14','',''),(3091,'1','277','1',1,'Retail Sale Id 3125',9100.00,0.00,0.00,12.50,-462.50,'2022-08-19 11:09:30','',''),(3092,'1','277','1',1,'Retail Sale Id 3126',3749.20,0.00,0.00,5.15,-190.55,'2022-08-19 11:11:20','',''),(3093,'1','277','1',1,'Retail Sale Id 3127',4397.12,0.00,0.00,6.04,-223.48,'2022-08-19 11:22:48','',''),(3094,'1','277','1',1,'Retail Sale Id 3128',2002.00,0.00,0.00,2.75,-101.75,'2022-08-19 11:29:22','',''),(3095,'1','277','1',1,'Retail Sale Id 3129',3800.16,0.00,0.00,5.22,-193.14,'2022-08-19 11:48:34','',''),(3096,'1','277','1',1,'Retail Sale Id 3130',4397.12,0.00,0.00,6.04,-223.48,'2022-08-19 12:13:10','',''),(3097,'1','277','1',1,'Retail Sale Id 3131',1499.68,0.00,0.00,2.06,-76.22,'2022-08-19 12:14:03','',''),(3098,'1','277','1',1,'Retail Sale Id 3133',2198.56,0.00,0.00,3.02,-111.74,'2022-08-19 12:32:33','',''),(3099,'1','277','1',1,'Retail Sale Id 3133',7280.00,0.00,0.00,10.00,-370.00,'2022-08-19 12:32:33','',''),(3100,'1','277','1',1,'Retail Sale Id 3134',3698.24,0.00,0.00,5.08,-187.96,'2022-08-19 12:55:33','',''),(3101,'1','277','1',1,'Retail Sale Id 3135',749.84,0.00,0.00,1.03,-38.11,'2022-08-19 12:56:34','',''),(3102,'1','277','1',1,'Retail Sale Id 3136',7301.84,0.00,0.00,10.03,-371.11,'2022-08-19 12:59:01','',''),(3103,'1','277','1',1,'Retail Sale Id 3137',4499.04,0.00,0.00,6.18,-228.66,'2022-08-19 13:10:37','',''),(3104,'1','277','1',1,'Retail Sale Id 3138',2497.04,0.00,0.00,3.43,-126.91,'2022-08-19 13:14:26','',''),(3105,'1','277','1',1,'Retail Sale Id 3139',9100.00,0.00,0.00,12.50,-462.50,'2022-08-19 13:22:00','',''),(3106,'1','277','1',1,'Retail Sale Id 3140',7280.00,0.00,0.00,10.00,-370.00,'2022-08-19 13:23:51','',''),(3107,'1','277','1',1,'Retail Sale Id 3141',1499.68,0.00,0.00,2.06,-76.22,'2022-08-19 14:02:51','',''),(3108,'1','277','1',1,'Retail Sale Id 3142',2198.56,0.00,0.00,3.02,-111.74,'2022-08-19 14:04:12','',''),(3109,'1','277','1',1,'Retail Sale Id 3143',3640.00,0.00,0.00,5.00,-185.00,'2022-08-19 14:07:04','',''),(3110,'1','277','1',1,'Retail Sale Id 3144',2999.36,0.00,0.00,4.12,-152.44,'2022-08-19 14:09:35','',''),(3111,'1','277','1',1,'Retail Sale Id 3145',2198.56,0.00,0.00,3.02,-111.74,'2022-08-19 14:13:50','',''),(3112,'1','277','1',1,'Retail Sale Id 3146',3603.60,0.00,0.00,4.95,-183.15,'2022-08-19 14:22:58','',''),(3113,'1','277','1',1,'Retail Sale Id 3147',1499.68,0.00,0.00,2.06,-76.22,'2022-08-19 14:27:10','',''),(3114,'1','277','1',1,'Retail Sale Id 3148',2700.88,0.00,0.00,3.71,-137.27,'2022-08-19 14:31:19','',''),(3115,'1','277','1',1,'Retail Sale Id 3149',15833.00,0.00,0.00,22.30,-1226.50,'2022-08-19 14:43:59','',''),(3116,'1','277','1',1,'Retail Sale Id 3150',2002.00,0.00,0.00,2.75,-101.75,'2022-08-19 14:44:49','',''),(3117,'1','277','1',1,'Retail Sale Id 3151',2999.36,0.00,0.00,4.12,-152.44,'2022-08-19 14:45:37','',''),(3118,'1','277','1',1,'Retail Sale Id 3152',1499.68,0.00,0.00,2.06,-76.22,'2022-08-19 14:47:33','',''),(3119,'1','277','1',1,'Retail Sale Id 3153',1448.72,0.00,0.00,1.99,-73.63,'2022-08-19 14:58:42','',''),(3120,'1','277','1',1,'Retail Sale Id 3154',1703.52,0.00,0.00,2.34,-86.58,'2022-08-19 15:02:33','',''),(3121,'1','277','1',1,'Retail Sale Id 3155',2002.00,0.00,0.00,2.75,-101.75,'2022-08-19 15:07:03','',''),(3122,'1','277','1',1,'Retail Sale Id 3156',1499.68,0.00,0.00,2.06,-76.22,'2022-08-19 15:08:22','',''),(3123,'1','277','1',1,'Retail Sale Id 3157',2002.00,0.00,0.00,2.75,-101.75,'2022-08-19 15:21:14','',''),(3124,'1','277','1',1,'Retail Sale Id 3158',2999.36,0.00,0.00,4.12,-152.44,'2022-08-19 15:22:11','',''),(3125,'1','277','1',1,'Retail Sale Id 3159',2198.56,0.00,0.00,3.02,-111.74,'2022-08-19 15:29:05','',''),(3126,'1','277','1',1,'Retail Sale Id 3160',698.88,0.00,0.00,0.96,-35.52,'2022-08-19 15:29:55','',''),(3127,'1','277','1',1,'Retail Sale Id 3161',2002.00,0.00,0.00,2.75,-101.75,'2022-08-19 15:36:58','',''),(3128,'1','277','1',1,'Retail Sale Id 3162',4397.12,0.00,0.00,6.04,-223.48,'2022-08-19 15:41:22','',''),(3129,'1','277','1',1,'Retail Sale Id 3163',8503.04,0.00,0.00,11.68,-432.16,'2022-08-19 15:42:59','',''),(3130,'1','277','1',1,'Retail Sale Id 3164',1499.68,0.00,0.00,2.06,-76.22,'2022-08-19 15:45:33','',''),(3131,'1','277','1',1,'Retail Sale Id 3165',2999.36,0.00,0.00,4.12,-152.44,'2022-08-19 15:46:30','',''),(3132,'1','277','1',1,'Retail Sale Id 3166',9100.00,0.00,0.00,12.50,-462.50,'2022-08-19 16:09:54','',''),(3133,'1','277','1',1,'Retail Sale Id 3167',2198.56,0.00,0.00,3.02,-111.74,'2022-08-19 16:12:39','',''),(3134,'1','277','1',1,'Retail Sale Id 3168',4397.12,0.00,0.00,6.04,-223.48,'2022-08-19 16:25:50','',''),(3135,'1','277','1',1,'Retail Sale Id 3169',2198.56,0.00,0.00,3.02,-111.74,'2022-08-19 16:27:07','',''),(3136,'1','277','1',1,'Retail Sale Id 3170',5001.36,0.00,0.00,6.87,-254.19,'2022-08-19 16:31:42','',''),(3137,'1','277','1',1,'Retail Sale Id 3171',502.32,0.00,0.00,0.69,-25.53,'2022-08-19 16:33:12','',''),(3138,'1','277','1',1,'Retail Sale Id 3172',4397.12,0.00,0.00,6.04,-223.48,'2022-08-19 16:37:13','',''),(3139,'1','277','1',1,'Retail Sale Id 3173',8998.08,0.00,0.00,12.36,-457.32,'2022-08-19 16:40:00','',''),(3140,'1','277','1',1,'Retail Sale Id 3174',997.36,0.00,0.00,1.37,-50.69,'2022-08-19 16:51:39','',''),(3141,'1','277','1',1,'Retail Sale Id 3174',1499.68,0.00,0.00,2.06,-76.22,'2022-08-19 16:51:39','',''),(3142,'1','277','1',1,'Retail Sale Id 3175',1499.68,0.00,0.00,2.06,-76.22,'2022-08-19 16:57:03','',''),(3143,'1','277','1',1,'Retail Sale Id 3176',2002.00,0.00,0.00,2.75,-101.75,'2022-08-19 17:06:17','',''),(3144,'1','277','1',1,'Retail Sale Id 3177',2002.00,0.00,0.00,2.75,-101.75,'2022-08-19 17:19:02','',''),(3145,'1','277','1',1,'Retail Sale Id 3178',997.36,0.00,0.00,1.37,-50.69,'2022-08-19 17:23:23','',''),(3146,'1','277','1',1,'Retail Sale Id 3179',2249.52,0.00,0.00,3.09,-114.33,'2022-08-19 17:32:50','',''),(3147,'1','277','1',1,'Return of Retail Sale Id 3165',0.00,2999.36,4.12,0.00,152.44,'2022-08-19 17:34:04','',''),(3148,'1','277','1',1,'Retail Sale Id 3180',800.80,0.00,0.00,1.10,-40.70,'2022-08-19 17:41:20','',''),(3149,'1','277','1',1,'Retail Sale Id 3181',1499.68,0.00,0.00,2.06,-76.22,'2022-08-19 17:45:09','',''),(3150,'1','277','1',1,'Retail Sale Id 3182',1499.68,0.00,0.00,2.06,-76.22,'2022-08-19 17:51:14','',''),(3151,'1','277','1',1,'Retail Sale Id 3183',218.40,0.00,0.00,0.30,-11.10,'2022-08-19 19:17:45','',''),(3152,'1','277',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,48156.75,62.95,0.00,0.00,'2022-08-19 19:29:04','',''),(3153,'1','277',NULL,1,'Reception corrector for bridging 11',0.00,0.00,0.00,62.95,0.00,'2022-08-19 19:35:03','',''),(3154,'1','277','1',1,'Received from bridging 11',0.00,0.00,62.95,0.00,0.00,'2022-08-19 19:35:03','',''),(3155,'1','277','1',1,'Retail Sale Id 3184',45827.60,0.00,0.00,62.95,-2329.15,'2022-08-19 19:36:42','',''),(3156,'1','277','1',1,'Return of Retail Sale Id 3178',0.00,997.36,1.37,0.00,50.69,'2022-08-19 20:02:03','',''),(3157,'1','277','1',1,'Retail Sale Id 3185',800.80,0.00,0.00,1.10,-40.70,'2022-08-19 20:04:09','',''),(3158,'1','277',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,1350000.00,2000.00,0.00,0.00,'2022-08-20 10:50:52','',''),(3159,'1','277',NULL,1,'Reception corrector for bridging 12',0.00,0.00,0.00,2000.00,0.00,'2022-08-20 10:53:07','',''),(3160,'1','277','1',1,'Received from bridging 12',0.00,0.00,2000.00,0.00,0.00,'2022-08-20 10:53:07','',''),(3161,'1','277','1',1,'Retail Sale Id 3186',2198.56,0.00,0.00,3.02,160.06,'2022-08-20 10:57:48','',''),(3162,'1','277','1',1,'Retail Sale Id 3187',2300.48,0.00,0.00,3.16,167.48,'2022-08-20 10:58:43','',''),(3163,'1','277','1',1,'Retail Sale Id 3188',997.36,0.00,0.00,1.37,72.61,'2022-08-20 10:59:28','',''),(3164,'1','277','1',1,'Retail Sale Id 3189',3996.72,0.00,0.00,5.49,290.97,'2022-08-20 11:00:35','',''),(3165,'1','277','1',1,'Retail Sale Id 3190',2999.36,0.00,0.00,4.12,218.36,'2022-08-20 11:01:22','',''),(3166,'1','277','1',1,'Retail Sale Id 3191',2198.56,0.00,0.00,3.02,160.06,'2022-08-20 11:02:04','',''),(3167,'1','277','1',1,'Retail Sale Id 3192',2300.48,0.00,0.00,3.16,167.48,'2022-08-20 11:05:21','',''),(3168,'1','277','1',1,'Retail Sale Id 3193',502.32,0.00,0.00,0.69,36.57,'2022-08-20 11:06:01','',''),(3169,'1','277','1',1,'Retail Sale Id 3194',3698.24,0.00,0.00,5.08,269.24,'2022-08-20 11:10:56','',''),(3170,'1','277','1',1,'Retail Sale Id 3195',800.80,0.00,0.00,1.10,58.30,'2022-08-20 11:13:57','',''),(3171,'1','277','1',1,'Retail Sale Id 3196',2999.36,0.00,0.00,4.12,218.36,'2022-08-20 11:14:40','',''),(3172,'1','277','1',1,'Retail Sale Id 3197',1499.68,0.00,0.00,2.06,109.18,'2022-08-20 11:16:03','',''),(3173,'1','277','1',1,'Retail Sale Id 3198',2198.56,0.00,0.00,3.02,160.06,'2022-08-20 11:18:32','',''),(3174,'1','277','1',1,'Retail Sale Id 3199',5001.36,0.00,0.00,6.87,364.11,'2022-08-20 11:20:00','',''),(3175,'1','277','1',1,'Retail Sale Id 3200',2999.36,0.00,0.00,4.12,218.36,'2022-08-20 11:34:21','',''),(3176,'1','277','1',1,'Retail Sale Id 3201',2999.36,0.00,0.00,4.12,218.36,'2022-08-20 11:35:31','',''),(3177,'1','277','1',1,'Retail Sale Id 3202',2002.00,0.00,0.00,2.75,145.75,'2022-08-20 11:38:52','',''),(3178,'1','277','1',1,'Retail Sale Id 3203',2999.36,0.00,0.00,4.12,218.36,'2022-08-20 11:39:34','',''),(3179,'1','277','1',1,'Retail Sale Id 3204',3603.60,0.00,0.00,4.95,262.35,'2022-08-20 11:42:10','',''),(3180,'1','277','1',1,'Retail Sale Id 3205',4397.12,0.00,0.00,6.04,320.12,'2022-08-20 11:43:18','',''),(3181,'1','277','1',1,'Retail Sale Id 3206',5998.72,0.00,0.00,8.24,436.72,'2022-08-20 11:46:26','',''),(3182,'1','277','1',1,'Retail Sale Id 3207',3101.28,0.00,0.00,4.26,225.78,'2022-08-20 11:47:17','',''),(3183,'1','277','1',1,'Retail Sale Id 3208',2002.00,0.00,0.00,2.75,145.75,'2022-08-20 11:56:42','',''),(3184,'1','277','1',1,'Retail Sale Id 3209',5001.36,0.00,0.00,6.87,364.11,'2022-08-20 11:59:26','',''),(3185,'1','277','1',1,'Retail Sale Id 3210',9100.00,0.00,0.00,12.50,662.50,'2022-08-20 12:00:08','',''),(3186,'1','277','1',1,'Retail Sale Id 3211',4397.12,0.00,0.00,6.04,320.12,'2022-08-20 12:01:35','',''),(3187,'1','277','1',1,'Retail Sale Id 3212',1201.20,0.00,0.00,1.65,87.45,'2022-08-20 12:04:35','',''),(3188,'1','277','1',1,'Retail Sale Id 3213',9296.56,0.00,0.00,12.77,676.81,'2022-08-20 12:08:25','',''),(3189,'1','277','1',1,'Retail Sale Id 3214',2198.56,0.00,0.00,3.02,160.06,'2022-08-20 12:19:57','',''),(3190,'1','277','1',1,'Retail Sale Id 3215',5103.28,0.00,0.00,7.01,371.53,'2022-08-20 12:22:02','',''),(3191,'1','277','1',1,'Retail Sale Id 3216',3501.68,0.00,0.00,4.81,254.93,'2022-08-20 12:23:53','',''),(3192,'1','277','1',1,'Retail Sale Id 3217',800.80,0.00,0.00,1.10,58.30,'2022-08-20 12:31:54','',''),(3193,'1','277','1',1,'Retail Sale Id 3218',3501.68,0.00,0.00,4.81,254.93,'2022-08-20 12:39:43','',''),(3194,'1','277','1',1,'Retail Sale Id 3219',4397.12,0.00,0.00,6.04,320.12,'2022-08-20 12:43:36','',''),(3195,'1','277','1',1,'Retail Sale Id 3220',2300.48,0.00,0.00,3.16,167.48,'2022-08-20 12:46:57','',''),(3196,'1','277','1',1,'Retail Sale Id 3221',3698.24,0.00,0.00,5.08,269.24,'2022-08-20 12:50:14','',''),(3197,'1','277','1',1,'Retail Sale Id 3222',1499.68,0.00,0.00,2.06,109.18,'2022-08-20 12:55:42','',''),(3198,'1','277','1',1,'Retail Sale Id 3223',1499.68,0.00,0.00,2.06,109.18,'2022-08-20 13:03:34','',''),(3199,'1','277','1',1,'Retail Sale Id 3224',596.96,0.00,0.00,0.82,43.46,'2022-08-20 13:10:26','',''),(3200,'1','277','1',1,'Retail Sale Id 3225',1499.68,0.00,0.00,2.06,109.18,'2022-08-20 13:11:24','',''),(3201,'1','277','1',1,'Retail Sale Id 3226',2198.56,0.00,0.00,3.02,160.06,'2022-08-20 13:13:55','',''),(3202,'1','277','1',1,'Retail Sale Id 3227',1499.68,0.00,0.00,2.06,109.18,'2022-08-20 13:20:31','',''),(3203,'1','277','1',1,'Retail Sale Id 3228',3698.24,0.00,0.00,5.08,269.24,'2022-08-20 13:21:54','',''),(3204,'1','277','1',1,'Retail Sale Id 3229',2999.36,0.00,0.00,4.12,218.36,'2022-08-20 13:22:43','',''),(3205,'1','277','1',1,'Retail Sale Id 3230',9100.00,0.00,0.00,12.50,662.50,'2022-08-20 13:26:00','',''),(3206,'1','277','1',1,'Retail Sale Id 3231',2198.56,0.00,0.00,3.02,160.06,'2022-08-20 13:27:33','',''),(3207,'1','277','1',1,'Retail Sale Id 3232',2999.36,0.00,0.00,4.12,218.36,'2022-08-20 13:28:17','',''),(3208,'1','277','1',1,'Retail Sale Id 3233',5998.72,0.00,0.00,8.24,436.72,'2022-08-20 13:39:51','',''),(3209,'1','277','1',1,'Retail Sale Id 3234',1499.68,0.00,0.00,2.06,109.18,'2022-08-20 13:40:29','',''),(3210,'1','277','1',1,'Retail Sale Id 3235',3640.00,0.00,0.00,5.00,265.00,'2022-08-20 13:41:28','',''),(3211,'1','277','1',1,'Retail Sale Id 3236',1499.68,0.00,0.00,2.06,109.18,'2022-08-20 13:42:12','',''),(3212,'1','277',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,2018250.00,2990.00,0.00,0.00,'2022-08-20 13:44:25','',''),(3213,'1','277',NULL,1,'Reception corrector for bridging 13',0.00,0.00,0.00,2990.00,0.00,'2022-08-20 13:45:46','',''),(3214,'1','277','1',1,'Received from bridging 13',0.00,0.00,2990.00,0.00,0.00,'2022-08-20 13:45:46','',''),(3215,'1','277','1',1,'Retail Sale Id 3237',902.72,0.00,0.00,1.24,65.72,'2022-08-20 13:46:54','',''),(3216,'1','277','1',1,'Retail Sale Id 3238',4397.12,0.00,0.00,6.04,320.12,'2022-08-20 13:59:07','',''),(3217,'1','277','1',1,'Retail Sale Id 3239',8000.72,0.00,0.00,10.99,582.47,'2022-08-20 14:00:45','',''),(3218,'1','277','1',1,'Retail Sale Id 3240',9100.00,0.00,0.00,12.50,662.50,'2022-08-20 14:05:20','',''),(3219,'1','277','1',1,'Retail Sale Id 3241',2002.00,0.00,0.00,2.75,145.75,'2022-08-20 14:07:25','',''),(3220,'1','277','1',1,'Retail Sale Id 3242',4499.04,0.00,0.00,6.18,327.54,'2022-08-20 14:13:44','',''),(3221,'1','277','1',1,'Retail Sale Id 3243',2999.36,0.00,0.00,4.12,218.36,'2022-08-20 14:14:33','',''),(3222,'1','277','1',1,'Retail Sale Id 3244',4397.12,0.00,0.00,6.04,320.12,'2022-08-20 14:21:45','',''),(3223,'1','277','1',1,'Retail Sale Id 3246',1499.68,0.00,0.00,2.06,109.18,'2022-08-20 14:23:16','',''),(3224,'1','277','1',1,'Retail Sale Id 3247',1601.60,0.00,0.00,2.20,116.60,'2022-08-20 14:29:15','',''),(3225,'1','277','1',1,'Retail Sale Id 3248',997.36,0.00,0.00,1.37,72.61,'2022-08-20 14:30:22','',''),(3226,'1','277','1',1,'Retail Sale Id 3249',997.36,0.00,0.00,1.37,72.61,'2022-08-20 14:35:12','',''),(3227,'1','277','1',1,'Retail Sale Id 3250',5998.72,0.00,0.00,8.24,436.72,'2022-08-20 14:40:22','',''),(3228,'1','277','1',1,'Retail Sale Id 3251',1499.68,0.00,0.00,2.06,109.18,'2022-08-20 14:41:58','',''),(3229,'1','277','1',1,'Retail Sale Id 3252',13832.00,0.00,0.00,19.00,1007.00,'2022-08-20 14:46:38','',''),(3230,'1','277','1',1,'Retail Sale Id 3253',2497.04,0.00,0.00,3.43,181.79,'2022-08-20 14:49:16','',''),(3231,'1','277','1',1,'Retail Sale Id 3254',4397.12,0.00,0.00,6.04,320.12,'2022-08-20 14:53:38','',''),(3232,'1','277','1',1,'Retail Sale Id 3255',4397.12,0.00,0.00,6.04,320.12,'2022-08-20 14:57:51','',''),(3233,'1','277','1',1,'Retail Sale Id 3256',2999.36,0.00,0.00,4.12,218.36,'2022-08-20 14:59:08','',''),(3234,'1','277','1',1,'Retail Sale Id 3257',2700.88,0.00,0.00,3.71,196.63,'2022-08-20 15:00:45','',''),(3235,'1','277','1',1,'Retail Sale Id 3258',2198.56,0.00,0.00,3.02,160.06,'2022-08-20 15:02:01','',''),(3236,'1','277','1',1,'Retail Sale Id 3259',4600.96,0.00,0.00,6.32,334.96,'2022-08-20 15:04:10','',''),(3237,'1','277','1',1,'Retail Sale Id 3260',997.36,0.00,0.00,1.37,72.61,'2022-08-20 15:05:59','',''),(3238,'1','277','1',1,'Retail Sale Id 3261',2198.56,0.00,0.00,3.02,160.06,'2022-08-20 15:07:08','',''),(3239,'1','277','1',1,'Retail Sale Id 3262',9100.00,0.00,0.00,12.50,662.50,'2022-08-20 15:16:53','',''),(3240,'1','277','1',1,'Retail Sale Id 3263',2002.00,0.00,0.00,2.75,145.75,'2022-08-20 15:17:43','',''),(3241,'1','277','1',1,'Retail Sale Id 3264',800.80,0.00,0.00,1.10,58.30,'2022-08-20 15:18:57','',''),(3242,'1','277','1',1,'Retail Sale Id 3265',2002.00,0.00,0.00,2.75,145.75,'2022-08-20 15:25:17','',''),(3243,'1','277','1',1,'Retail Sale Id 3266',997.36,0.00,0.00,1.37,72.61,'2022-08-20 15:28:54','',''),(3244,'1','277','1',1,'Retail Sale Id 3267',2999.36,0.00,0.00,4.12,218.36,'2022-08-20 15:34:18','',''),(3245,'1','277','1',1,'Retail Sale Id 3268',4397.12,0.00,0.00,6.04,320.12,'2022-08-20 15:40:55','',''),(3246,'1','277','1',1,'Retail Sale Id 3269',997.36,0.00,0.00,1.37,72.61,'2022-08-20 15:57:29','',''),(3247,'1','277','1',1,'Retail Sale Id 3270',30000.88,0.00,0.00,41.21,2184.13,'2022-08-20 16:17:31','',''),(3248,'1','277','1',1,'Retail Sale Id 3271',2999.36,0.00,0.00,4.12,218.36,'2022-08-20 16:18:16','',''),(3249,'1','277','1',1,'Return of Retail Sale Id 3270',0.00,30000.88,41.21,0.00,-2184.13,'2022-08-20 16:19:21','',''),(3250,'1','277','1',1,'Retail Sale Id 3272',2198.56,0.00,0.00,3.02,160.06,'2022-08-20 16:22:37','',''),(3251,'1','277','1',1,'Retail Sale Id 3273',2198.56,0.00,0.00,3.02,160.06,'2022-08-20 16:25:02','',''),(3252,'1','277','1',1,'Retail Sale Id 3274',5998.72,0.00,0.00,8.24,436.72,'2022-08-20 16:32:46','',''),(3253,'1','277','1',1,'Retail Sale Id 3275',2198.56,0.00,0.00,3.02,160.06,'2022-08-20 16:34:05','',''),(3254,'1','277','1',1,'Retail Sale Id 3276',502.32,0.00,0.00,0.69,36.57,'2022-08-20 16:34:47','',''),(3255,'1','277','1',1,'Retail Sale Id 3277',1499.68,0.00,0.00,2.06,109.18,'2022-08-20 16:35:27','',''),(3256,'1','277','1',1,'Retail Sale Id 3278',2198.56,0.00,0.00,3.02,160.06,'2022-08-20 16:36:12','',''),(3257,'1','277','1',1,'Retail Sale Id 3279',2999.36,0.00,0.00,4.12,218.36,'2022-08-20 16:36:54','',''),(3258,'1','277','1',1,'Retail Sale Id 3280',3501.68,0.00,0.00,4.81,254.93,'2022-08-20 16:40:28','',''),(3259,'1','277','1',1,'Retail Sale Id 3281',2198.56,0.00,0.00,3.02,160.06,'2022-08-20 16:41:26','',''),(3260,'1','277','1',1,'Retail Sale Id 3282',2497.04,0.00,0.00,3.43,181.79,'2022-08-20 16:42:06','',''),(3261,'1','277','1',1,'Retail Sale Id 3283',3698.24,0.00,0.00,5.08,269.24,'2022-08-20 16:47:59','',''),(3262,'1','277','1',1,'Retail Sale Id 3284',1499.68,0.00,0.00,2.06,109.18,'2022-08-20 16:48:55','',''),(3263,'1','277','1',1,'Retail Sale Id 3285',3698.24,0.00,0.00,5.08,269.24,'2022-08-20 16:50:18','',''),(3264,'1','277','1',1,'Retail Sale Id 3286',2198.56,0.00,0.00,3.02,160.06,'2022-08-20 16:51:09','',''),(3265,'1','277','1',1,'Retail Sale Id 3287',2198.56,0.00,0.00,3.02,160.06,'2022-08-20 16:54:21','',''),(3266,'1','277','1',1,'Retail Sale Id 3288',2198.56,0.00,0.00,3.02,160.06,'2022-08-20 17:02:43','',''),(3267,'1','277','1',1,'Retail Sale Id 3289',997.36,0.00,0.00,1.37,72.61,'2022-08-20 17:04:55','',''),(3268,'1','277','1',1,'Retail Sale Id 3290',800.80,0.00,0.00,1.10,58.30,'2022-08-20 17:05:55','',''),(3269,'1','277','1',1,'Retail Sale Id 3291',1951.04,0.00,0.00,2.68,142.04,'2022-08-20 17:08:11','',''),(3270,'1','277','1',1,'Retail Sale Id 3292',2002.00,0.00,0.00,2.75,145.75,'2022-08-20 17:10:15','',''),(3271,'1','277','1',1,'Retail Sale Id 3293',8102.64,0.00,0.00,11.13,589.89,'2022-08-20 17:11:31','',''),(3272,'1','277','1',1,'Retail Sale Id 3294',4397.12,0.00,0.00,6.04,320.12,'2022-08-20 17:12:54','',''),(3273,'1','277','1',1,'Retail Sale Id 3295',4302.48,0.00,0.00,5.91,313.23,'2022-08-20 17:15:43','',''),(3274,'1','277','1',1,'Retail Sale Id 3296',3996.72,0.00,0.00,5.49,290.97,'2022-08-20 17:16:26','',''),(3275,'1','277','1',1,'Retail Sale Id 3297',5001.36,0.00,0.00,6.87,364.11,'2022-08-20 17:17:05','',''),(3276,'1','277','1',1,'Retail Sale Id 3298',9100.00,0.00,0.00,12.50,662.50,'2022-08-20 17:18:45','',''),(3277,'1','277','1',1,'Retail Sale Id 3299',1499.68,0.00,0.00,2.06,109.18,'2022-08-20 17:19:39','',''),(3278,'1','277','1',1,'Retail Sale Id 3300',1499.68,0.00,0.00,2.06,109.18,'2022-08-20 17:23:45','',''),(3279,'1','277','1',1,'Retail Sale Id 3301',4499.04,0.00,0.00,6.18,327.54,'2022-08-20 17:25:25','',''),(3280,'1','277','1',1,'Retail Sale Id 3302',2198.56,0.00,0.00,3.02,160.06,'2022-08-20 17:26:05','',''),(3281,'1','277','1',1,'Retail Sale Id 3303',5001.36,0.00,0.00,6.87,364.11,'2022-08-20 17:27:32','',''),(3282,'1','277','1',1,'Retail Sale Id 3304',5001.36,0.00,0.00,6.87,364.11,'2022-08-20 17:31:29','',''),(3283,'1','277','1',1,'Retail Sale Id 3305',9100.00,0.00,0.00,12.50,662.50,'2022-08-20 17:40:27','',''),(3284,'1','277','1',1,'Retail Sale Id 3306',2919.28,0.00,0.00,4.01,212.53,'2022-08-20 17:42:12','',''),(3285,'1','277','1',1,'Retail Sale Id 3307',1477.84,0.00,0.00,2.03,107.59,'2022-08-20 17:43:10','',''),(3286,'1','277','1',1,'Retail Sale Id 3308',2497.04,0.00,0.00,3.43,181.79,'2022-08-20 17:49:31','',''),(3287,'1','277','1',1,'Retail Sale Id 3309',2198.56,0.00,0.00,3.02,160.06,'2022-08-20 17:50:44','',''),(3288,'1','277','1',1,'Retail Sale Id 3310',2198.56,0.00,0.00,3.02,160.06,'2022-08-20 17:52:54','',''),(3289,'1','277','1',1,'Retail Sale Id 3311',2198.56,0.00,0.00,3.02,160.06,'2022-08-20 17:59:37','',''),(3290,'1','277','1',1,'Retail Sale Id 3312',997.36,0.00,0.00,1.37,72.61,'2022-08-20 18:00:56','',''),(3291,'1','277','1',1,'Retail Sale Id 3313',9100.00,0.00,0.00,12.50,662.50,'2022-08-20 18:03:11','',''),(3292,'1','277','1',1,'Retail Sale Id 3314',1499.68,0.00,0.00,2.06,109.18,'2022-08-20 18:07:31','',''),(3293,'1','277','1',1,'Retail Sale Id 3315',1499.68,0.00,0.00,2.06,109.18,'2022-08-20 18:11:50','',''),(3294,'1','277','1',1,'Retail Sale Id 3316',800.80,0.00,0.00,1.10,58.30,'2022-08-20 18:12:45','',''),(3295,'1','277','1',1,'Retail Sale Id 3317',502.32,0.00,0.00,0.69,36.57,'2022-08-20 18:13:21','',''),(3296,'1','277','1',1,'Retail Sale Id 3318',4302.48,0.00,0.00,5.91,313.23,'2022-08-20 18:14:30','',''),(3297,'1','277','1',1,'Retail Sale Id 3319',2999.36,0.00,0.00,4.12,218.36,'2022-08-20 18:16:09','',''),(3298,'1','277','1',1,'Retail Sale Id 3320',3698.24,0.00,0.00,5.08,269.24,'2022-08-20 18:16:59','',''),(3299,'1','277','1',1,'Retail Sale Id 3321',1499.68,0.00,0.00,2.06,109.18,'2022-08-20 18:20:39','',''),(3300,'1','277','1',1,'Retail Sale Id 3322',5001.36,0.00,0.00,6.87,364.11,'2022-08-20 18:26:02','',''),(3301,'1','277','1',1,'Retail Sale Id 3323',997.36,0.00,0.00,1.37,72.61,'2022-08-20 18:27:30','',''),(3302,'1','277','1',1,'Retail Sale Id 3324',997.36,0.00,0.00,1.37,72.61,'2022-08-20 18:35:00','',''),(3303,'1','277','1',1,'Retail Sale Id 3325',749.84,0.00,0.00,1.03,54.59,'2022-08-20 18:36:59','',''),(3304,'1','277','1',1,'Retail Sale Id 3326',2999.36,0.00,0.00,4.12,218.36,'2022-08-20 18:40:16','',''),(3305,'1','277','1',1,'Retail Sale Id 3327',2999.36,0.00,0.00,4.12,218.36,'2022-08-20 18:41:37','',''),(3306,'1','277','1',1,'Retail Sale Id 3328',1499.68,0.00,0.00,2.06,109.18,'2022-08-20 18:43:29','',''),(3307,'1','277','1',1,'Retail Sale Id 3329',9100.00,0.00,0.00,12.50,662.50,'2022-08-20 18:44:37','',''),(3308,'1','277','1',1,'Retail Sale Id 3330',3996.72,0.00,0.00,5.49,290.97,'2022-08-20 18:45:43','',''),(3309,'1','277','1',1,'Retail Sale Id 3331',2002.00,0.00,0.00,2.75,145.75,'2022-08-20 18:51:32','',''),(3310,'1','277','1',1,'Retail Sale Id 3332',3698.24,0.00,0.00,5.08,269.24,'2022-08-20 18:54:08','',''),(3311,'1','277','1',1,'Retail Sale Id 3333',1499.68,0.00,0.00,2.06,109.18,'2022-08-20 18:56:58','',''),(3312,'1','277','1',1,'Retail Sale Id 3334',2002.00,0.00,0.00,2.75,145.75,'2022-08-20 18:58:09','',''),(3313,'1','277','1',1,'Retail Sale Id 3335',4397.12,0.00,0.00,6.04,320.12,'2022-08-20 19:03:40','',''),(3314,'1','277','1',1,'Retail Sale Id 3336',800.80,0.00,0.00,1.10,58.30,'2022-08-20 19:05:02','',''),(3315,'1','277','1',1,'Retail Sale Id 3337',2999.36,0.00,0.00,4.12,218.36,'2022-08-20 19:12:08','',''),(3316,'1','277','1',1,'Retail Sale Id 3338',4302.48,0.00,0.00,5.91,313.23,'2022-08-20 19:14:58','',''),(3317,'1','277','1',1,'Retail Sale Id 3339',997.36,0.00,0.00,1.37,72.61,'2022-08-20 19:19:26','',''),(3318,'1','277','1',1,'Retail Sale Id 3340',2002.00,0.00,0.00,2.75,145.75,'2022-08-20 19:20:26','',''),(3319,'1','277','1',1,'Return of Retail Sale Id 3317',0.00,502.32,0.69,0.00,-36.57,'2022-08-20 19:43:32','',''),(3320,'1','277','1',1,'Retail Sale Id 3341',465.92,0.00,0.00,0.64,33.92,'2022-08-20 19:44:12','',''),(3321,'1','277','1',1,'Retail Sale Id 3342',7.28,0.00,0.00,0.01,0.53,'2022-08-20 19:46:43','',''),(3322,'1','277','1',1,'Retail Sale Id 3343',2999.36,0.00,0.00,4.12,218.36,'2022-08-21 06:39:05','',''),(3323,'1','277','1',1,'Retail Sale Id 3344',2497.04,0.00,0.00,3.43,181.79,'2022-08-21 06:40:13','',''),(3324,'1','277','1',1,'Retail Sale Id 3345',698.88,0.00,0.00,0.96,50.88,'2022-08-21 06:51:40','',''),(3325,'1','277','1',1,'Retail Sale Id 3346',902.72,0.00,0.00,1.24,65.72,'2022-08-21 06:54:03','',''),(3326,'1','277','1',1,'Retail Sale Id 3347',2497.04,0.00,0.00,3.43,181.79,'2022-08-21 07:09:48','',''),(3327,'1','277','1',1,'Retail Sale Id 3348',997.36,0.00,0.00,1.37,72.61,'2022-08-21 07:22:47','',''),(3328,'1','277','1',1,'Retail Sale Id 3349',1499.68,0.00,0.00,2.06,109.18,'2022-08-21 07:25:00','',''),(3329,'1','277','1',1,'Retail Sale Id 3350',3501.68,0.00,0.00,4.81,254.93,'2022-08-21 07:26:32','',''),(3330,'1','277','1',1,'Retail Sale Id 3351',3996.72,0.00,0.00,5.49,290.97,'2022-08-21 07:39:31','',''),(3331,'1','277','1',1,'Retail Sale Id 3352',2999.36,0.00,0.00,4.12,218.36,'2022-08-21 07:49:08','',''),(3332,'1','277','1',1,'Retail Sale Id 3353',1099.28,0.00,0.00,1.51,80.03,'2022-08-21 07:52:49','',''),(3333,'1','277','1',1,'Retail Sale Id 3354',1499.68,0.00,0.00,2.06,109.18,'2022-08-21 07:53:45','',''),(3334,'1','277','1',1,'Retail Sale Id 3355',997.36,0.00,0.00,1.37,72.61,'2022-08-21 07:54:32','',''),(3335,'1','277','1',1,'Retail Sale Id 3356',749.84,0.00,0.00,1.03,54.59,'2022-08-21 08:04:39','',''),(3336,'1','277','1',1,'Retail Sale Id 3357',997.36,0.00,0.00,1.37,72.61,'2022-08-21 08:05:28','',''),(3337,'1','277','1',1,'Retail Sale Id 3358',749.84,0.00,0.00,1.03,54.59,'2022-08-21 08:06:21','',''),(3338,'1','277','1',1,'Retail Sale Id 3359',502.32,0.00,0.00,0.69,36.57,'2022-08-21 08:07:09','',''),(3339,'1','277','1',1,'Retail Sale Id 3360',1499.68,0.00,0.00,2.06,109.18,'2022-08-21 08:08:15','',''),(3340,'1','277','1',1,'Retail Sale Id 3361',2300.48,0.00,0.00,3.16,167.48,'2022-08-21 08:09:23','',''),(3341,'1','277','1',1,'Retail Sale Id 3362',2198.56,0.00,0.00,3.02,160.06,'2022-08-21 08:10:26','',''),(3342,'1','277','1',1,'Retail Sale Id 3363',4397.12,0.00,0.00,6.04,320.12,'2022-08-21 08:14:32','',''),(3343,'1','277','1',1,'Retail Sale Id 3364',3698.24,0.00,0.00,5.08,269.24,'2022-08-21 08:16:45','',''),(3344,'1','277','1',1,'Retail Sale Id 3365',4397.12,0.00,0.00,6.04,320.12,'2022-08-21 08:19:33','',''),(3345,'1','277','1',1,'Retail Sale Id 3366',3647.28,0.00,0.00,5.01,265.53,'2022-08-21 08:21:14','',''),(3346,'1','277','1',1,'Retail Sale Id 3367',2999.36,0.00,0.00,4.12,218.36,'2022-08-21 08:23:57','',''),(3347,'1','277','1',1,'Retail Sale Id 3368',1499.68,0.00,0.00,2.06,109.18,'2022-08-21 08:24:55','',''),(3348,'1','277','1',1,'Retail Sale Id 3369',1499.68,0.00,0.00,2.06,109.18,'2022-08-21 08:33:00','',''),(3349,'1','277','1',1,'Retail Sale Id 3370',1499.68,0.00,0.00,2.06,109.18,'2022-08-21 08:42:17','',''),(3350,'1','277','1',1,'Retail Sale Id 3371',2497.04,0.00,0.00,3.43,181.79,'2022-08-21 08:43:36','',''),(3351,'1','277','1',1,'Retail Sale Id 3372',4397.12,0.00,0.00,6.04,320.12,'2022-08-21 08:48:47','',''),(3352,'1','277','1',1,'Retail Sale Id 3373',2184.00,0.00,0.00,3.00,159.00,'2022-08-21 08:51:07','',''),(3353,'1','277','1',1,'Retail Sale Id 3374',2198.56,0.00,0.00,3.02,160.06,'2022-08-21 08:57:45','',''),(3354,'1','277','1',1,'Retail Sale Id 3375',997.36,0.00,0.00,1.37,72.61,'2022-08-21 08:58:39','',''),(3355,'1','277','1',1,'Retail Sale Id 3376',1703.52,0.00,0.00,2.34,124.02,'2022-08-21 09:00:07','',''),(3356,'1','277','1',1,'Retail Sale Id 3377',3698.24,0.00,0.00,5.08,269.24,'2022-08-21 09:04:39','',''),(3357,'1','277','1',1,'Retail Sale Id 3378',2198.56,0.00,0.00,3.02,160.06,'2022-08-21 09:08:42','',''),(3358,'1','277','1',1,'Retail Sale Id 3379',4397.12,0.00,0.00,6.04,320.12,'2022-08-21 09:11:04','',''),(3359,'1','277','1',1,'Retail Sale Id 3380',2999.36,0.00,0.00,4.12,218.36,'2022-08-21 09:12:00','',''),(3360,'1','277','1',1,'Retail Sale Id 3381',742.56,0.00,0.00,1.02,54.06,'2022-08-21 09:21:33','',''),(3361,'1','277','1',1,'Retail Sale Id 3382',2198.56,0.00,0.00,3.02,160.06,'2022-08-21 09:22:11','',''),(3362,'1','277','1',1,'Retail Sale Id 3383',2999.36,0.00,0.00,4.12,218.36,'2022-08-21 09:34:35','',''),(3363,'1','277','1',1,'Retail Sale Id 3384',997.36,0.00,0.00,1.37,72.61,'2022-08-21 09:47:54','',''),(3364,'1','277','1',1,'Retail Sale Id 3385',2999.36,0.00,0.00,4.12,218.36,'2022-08-21 09:52:43','',''),(3365,'1','277','1',1,'Retail Sale Id 3386',2198.56,0.00,0.00,3.02,160.06,'2022-08-21 09:55:04','',''),(3366,'1','277','1',1,'Retail Sale Id 3387',2999.36,0.00,0.00,4.12,218.36,'2022-08-21 10:24:13','',''),(3367,'1','277','1',1,'Retail Sale Id 3388',1499.68,0.00,0.00,2.06,109.18,'2022-08-21 10:34:34','',''),(3368,'1','277','1',1,'Retail Sale Id 3389',5001.36,0.00,0.00,6.87,364.11,'2022-08-21 10:36:16','',''),(3369,'1','277','1',1,'Retail Sale Id 3390',3640.00,0.00,0.00,5.00,265.00,'2022-08-21 10:59:11','',''),(3370,'1','277','1',1,'Retail Sale Id 3391',1499.68,0.00,0.00,2.06,109.18,'2022-08-21 10:59:52','',''),(3371,'1','277','1',1,'Retail Sale Id 3392',2198.56,0.00,0.00,3.02,160.06,'2022-08-21 11:09:21','',''),(3372,'1','277','1',1,'Retail Sale Id 3393',1499.68,0.00,0.00,2.06,109.18,'2022-08-21 11:10:21','',''),(3373,'1','277','1',1,'Retail Sale Id 3394',2999.36,0.00,0.00,4.12,218.36,'2022-08-21 11:11:02','',''),(3374,'1','277','1',1,'Retail Sale Id 3395',4397.12,0.00,0.00,6.04,320.12,'2022-08-21 11:17:13','',''),(3375,'1','277','1',1,'Retail Sale Id 3396',2497.04,0.00,0.00,3.43,181.79,'2022-08-21 11:18:53','',''),(3376,'1','277','1',1,'Retail Sale Id 3397',3996.72,0.00,0.00,5.49,290.97,'2022-08-21 11:19:25','',''),(3377,'1','277','1',1,'Retail Sale Id 3398',2999.36,0.00,0.00,4.12,218.36,'2022-08-21 11:20:41','',''),(3378,'1','277','1',1,'Retail Sale Id 3399',9100.00,0.00,0.00,12.50,662.50,'2022-08-21 11:27:31','',''),(3379,'1','277','1',1,'Retail Sale Id 3400',2198.56,0.00,0.00,3.02,160.06,'2022-08-21 11:37:33','',''),(3380,'1','277','1',1,'Retail Sale Id 3401',2999.36,0.00,0.00,4.12,218.36,'2022-08-21 11:41:39','',''),(3381,'1','277','1',1,'Retail Sale Id 3402',1499.68,0.00,0.00,2.06,109.18,'2022-08-21 12:03:57','',''),(3382,'1','277','1',1,'Retail Sale Id 3403',3647.28,0.00,0.00,5.01,265.53,'2022-08-21 12:12:13','',''),(3383,'1','277','1',1,'Retail Sale Id 3404',2198.56,0.00,0.00,3.02,160.06,'2022-08-21 12:17:25','',''),(3384,'1','277','1',1,'Retail Sale Id 3405',749.84,0.00,0.00,1.03,54.59,'2022-08-21 12:22:50','',''),(3385,'1','277','1',1,'Retail Sale Id 3406',2002.00,0.00,0.00,2.75,145.75,'2022-08-21 12:23:51','',''),(3386,'1','277','1',1,'Retail Sale Id 3407',1499.68,0.00,0.00,2.06,109.18,'2022-08-21 12:28:17','',''),(3387,'1','277','1',1,'Retail Sale Id 3408',1499.68,0.00,0.00,2.06,109.18,'2022-08-21 12:29:01','',''),(3388,'1','277','1',1,'Retail Sale Id 3409',4397.12,0.00,0.00,6.04,320.12,'2022-08-21 12:30:40','',''),(3389,'1','277','1',1,'Retail Sale Id 3410',2198.56,0.00,0.00,3.02,160.06,'2022-08-21 12:33:17','',''),(3390,'1','277','1',1,'Retail Sale Id 3411',4368.00,0.00,0.00,6.00,318.00,'2022-08-21 12:35:27','',''),(3391,'1','277','1',1,'Retail Sale Id 3412',3996.72,0.00,0.00,5.49,290.97,'2022-08-21 12:50:06','',''),(3392,'1','277','1',1,'Retail Sale Id 3413',1499.68,0.00,0.00,2.06,109.18,'2022-08-21 12:51:21','',''),(3393,'1','277','1',1,'Retail Sale Id 3414',4397.12,0.00,0.00,6.04,320.12,'2022-08-21 12:52:38','',''),(3394,'1','277','1',1,'Retail Sale Id 3415',2002.00,0.00,0.00,2.75,145.75,'2022-08-21 12:57:41','',''),(3395,'1','277','1',1,'Retail Sale Id 3416',1499.68,0.00,0.00,2.06,109.18,'2022-08-21 12:58:35','',''),(3396,'1','277','1',1,'Retail Sale Id 3417',35500.00,0.00,0.00,50.00,1750.00,'2022-08-21 13:06:51','',''),(3397,'1','277','1',1,'Retail Sale Id 3418',3698.24,0.00,0.00,5.08,269.24,'2022-08-21 13:08:03','',''),(3398,'1','277','1',1,'Retail Sale Id 3419',997.36,0.00,0.00,1.37,72.61,'2022-08-21 13:12:37','',''),(3399,'1','277','1',1,'Retail Sale Id 3420',9100.00,0.00,0.00,12.50,662.50,'2022-08-21 13:16:05','',''),(3400,'1','277','1',1,'Retail Sale Id 3421',1499.68,0.00,0.00,2.06,109.18,'2022-08-21 13:16:53','',''),(3401,'1','277','1',1,'Retail Sale Id 3422',2999.36,0.00,0.00,4.12,218.36,'2022-08-21 13:25:01','',''),(3402,'1','277','1',1,'Retail Sale Id 3423',2999.36,0.00,0.00,4.12,218.36,'2022-08-21 13:26:30','',''),(3403,'1','277','1',1,'Retail Sale Id 3424',3640.00,0.00,0.00,5.00,265.00,'2022-08-21 13:28:21','',''),(3404,'1','277','1',1,'Retail Sale Id 3425',1456.00,0.00,0.00,2.00,106.00,'2022-08-21 13:32:03','',''),(3405,'1','277','1',1,'Retail Sale Id 3426',1499.68,0.00,0.00,2.06,109.18,'2022-08-21 13:33:07','',''),(3406,'1','277','1',1,'Retail Sale Id 3427',3698.24,0.00,0.00,5.08,269.24,'2022-08-21 13:35:50','',''),(3407,'1','277','1',1,'Retail Sale Id 3428',800.80,0.00,0.00,1.10,58.30,'2022-08-21 13:39:55','',''),(3408,'1','277','1',1,'Retail Sale Id 3429',2198.56,0.00,0.00,3.02,160.06,'2022-08-21 13:41:23','',''),(3409,'1','277','1',1,'Retail Sale Id 3430',2198.56,0.00,0.00,3.02,160.06,'2022-08-21 13:44:18','',''),(3410,'1','277','1',1,'Retail Sale Id 3431',997.36,0.00,0.00,1.37,72.61,'2022-08-21 13:45:00','',''),(3411,'1','277','1',1,'Retail Sale Id 3432',2912.00,0.00,0.00,4.00,212.00,'2022-08-21 13:48:10','',''),(3412,'1','277','1',1,'Retail Sale Id 3433',1499.68,0.00,0.00,2.06,109.18,'2022-08-21 13:52:04','',''),(3413,'1','277','1',1,'Retail Sale Id 3434',1499.68,0.00,0.00,2.06,109.18,'2022-08-21 13:53:28','',''),(3414,'1','277','1',1,'Retail Sale Id 3435',1499.68,0.00,0.00,2.06,109.18,'2022-08-21 13:54:12','',''),(3415,'1','277','1',1,'Retail Sale Id 3436',3996.72,0.00,0.00,5.49,290.97,'2022-08-21 13:56:04','',''),(3416,'1','277','1',1,'Retail Sale Id 3437',2002.00,0.00,0.00,2.75,145.75,'2022-08-21 13:57:13','',''),(3417,'1','277','1',1,'Retail Sale Id 3438',800.80,0.00,0.00,1.10,58.30,'2022-08-21 13:58:15','',''),(3418,'1','277','1',1,'Retail Sale Id 3439',2198.56,0.00,0.00,3.02,160.06,'2022-08-21 14:10:05','',''),(3419,'1','277','1',1,'Retail Sale Id 3442',2999.36,0.00,0.00,4.12,218.36,'2022-08-21 14:20:05','',''),(3420,'1','277','1',1,'Retail Sale Id 3443',3698.24,0.00,0.00,5.08,269.24,'2022-08-21 14:21:42','',''),(3421,'1','277','1',1,'Retail Sale Id 3444',2999.36,0.00,0.00,4.12,218.36,'2022-08-21 14:22:32','',''),(3422,'1','277','1',1,'Retail Sale Id 3445',2198.56,0.00,0.00,3.02,160.06,'2022-08-21 14:23:36','',''),(3423,'1','277','1',1,'Retail Sale Id 3446',4397.12,0.00,0.00,6.04,320.12,'2022-08-21 14:24:53','',''),(3424,'1','277','1',1,'Retail Sale Id 3447',997.36,0.00,0.00,1.37,72.61,'2022-08-21 14:27:14','',''),(3425,'1','277','1',1,'Retail Sale Id 3448',2002.00,0.00,0.00,2.75,145.75,'2022-08-21 14:41:17','',''),(3426,'1','277','1',1,'Retail Sale Id 3449',42600.00,0.00,0.00,60.00,2100.00,'2022-08-21 14:43:56','',''),(3427,'1','277','1',1,'Retail Sale Id 3450',2002.00,0.00,0.00,2.75,145.75,'2022-08-21 14:45:32','',''),(3428,'1','277','1',1,'Retail Sale Id 3451',2198.56,0.00,0.00,3.02,160.06,'2022-08-21 14:47:14','',''),(3429,'1','277','1',1,'Retail Sale Id 3452',2002.00,0.00,0.00,2.75,145.75,'2022-08-21 14:55:08','',''),(3430,'1','277','1',1,'Retail Sale Id 3453',997.36,0.00,0.00,1.37,72.61,'2022-08-21 15:02:18','',''),(3431,'1','277','1',1,'Retail Sale Id 3454',2002.00,0.00,0.00,2.75,145.75,'2022-08-21 15:04:30','',''),(3432,'1','277','1',1,'Retail Sale Id 3455',2002.00,0.00,0.00,2.75,145.75,'2022-08-21 15:09:04','',''),(3433,'1','277','1',1,'Retail Sale Id 3456',3640.00,0.00,0.00,5.00,265.00,'2022-08-21 15:13:01','',''),(3434,'1','277','1',1,'Retail Sale Id 3457',1499.68,0.00,0.00,2.06,109.18,'2022-08-21 15:14:01','',''),(3435,'1','277','1',1,'Retail Sale Id 3458',2497.04,0.00,0.00,3.43,181.79,'2022-08-21 15:14:57','',''),(3436,'1','277','1',1,'Retail Sale Id 3459',1499.68,0.00,0.00,2.06,109.18,'2022-08-21 15:15:37','',''),(3437,'1','277','1',1,'Retail Sale Id 3460',3996.72,0.00,0.00,5.49,290.97,'2022-08-21 15:18:15','',''),(3438,'1','277','1',1,'Retail Sale Id 3461',2002.00,0.00,0.00,2.75,145.75,'2022-08-21 15:30:06','',''),(3439,'1','277','1',1,'Retail Sale Id 3462',3698.24,0.00,0.00,5.08,269.24,'2022-08-21 15:34:45','',''),(3440,'1','277','1',1,'Retail Sale Id 3463',1499.68,0.00,0.00,2.06,109.18,'2022-08-21 15:35:27','',''),(3441,'1','277','1',1,'Retail Sale Id 3464',3996.72,0.00,0.00,5.49,290.97,'2022-08-21 15:50:24','',''),(3442,'1','277','1',1,'Retail Sale Id 3465',2198.56,0.00,0.00,3.02,160.06,'2022-08-21 15:51:01','',''),(3443,'1','277','1',1,'Retail Sale Id 3466',1499.68,0.00,0.00,2.06,109.18,'2022-08-21 15:51:39','',''),(3444,'1','277','1',1,'Retail Sale Id 3467',1703.52,0.00,0.00,2.34,124.02,'2022-08-21 15:55:26','',''),(3445,'1','277','1',1,'Retail Sale Id 3468',3640.00,0.00,0.00,5.00,265.00,'2022-08-21 15:59:54','',''),(3446,'1','277','1',1,'Retail Sale Id 3469',698.88,0.00,0.00,0.96,50.88,'2022-08-21 16:02:06','',''),(3447,'1','277','1',1,'Retail Sale Id 3470',3996.72,0.00,0.00,5.49,290.97,'2022-08-21 16:07:40','',''),(3448,'1','277','1',1,'Retail Sale Id 3471',2198.56,0.00,0.00,3.02,160.06,'2022-08-21 16:12:03','',''),(3449,'1','277','1',1,'Retail Sale Id 3472',1499.68,0.00,0.00,2.06,109.18,'2022-08-21 16:22:27','',''),(3450,'1','277','1',1,'Retail Sale Id 3473',1499.68,0.00,0.00,2.06,109.18,'2022-08-21 16:23:46','',''),(3451,'1','277','1',1,'Retail Sale Id 3474',2002.00,0.00,0.00,2.75,145.75,'2022-08-21 16:27:05','',''),(3452,'1','277','1',1,'Retail Sale Id 3475',2002.00,0.00,0.00,2.75,145.75,'2022-08-21 16:30:34','',''),(3453,'1','277','1',1,'Retail Sale Id 3476',4397.12,0.00,0.00,6.04,320.12,'2022-08-21 16:39:30','',''),(3454,'1','277','1',1,'Retail Sale Id 3477',5103.28,0.00,0.00,7.01,371.53,'2022-08-21 16:40:54','',''),(3455,'1','277','1',1,'Retail Sale Id 3478',4397.12,0.00,0.00,6.04,320.12,'2022-08-21 16:57:56','',''),(3456,'1','277','1',1,'Retail Sale Id 3479',3698.24,0.00,0.00,5.08,269.24,'2022-08-21 16:59:24','',''),(3457,'1','277','1',1,'Retail Sale Id 3480',1499.68,0.00,0.00,2.06,109.18,'2022-08-21 17:00:05','',''),(3458,'1','277','1',1,'Retail Sale Id 3481',2598.96,0.00,0.00,3.57,189.21,'2022-08-21 17:01:11','',''),(3459,'1','277','1',1,'Retail Sale Id 3482',4397.12,0.00,0.00,6.04,320.12,'2022-08-21 17:01:47','',''),(3460,'1','277','1',1,'Retail Sale Id 3483',9100.00,0.00,0.00,12.50,662.50,'2022-08-21 17:04:51','',''),(3461,'1','277','1',1,'Retail Sale Id 3484',5001.36,0.00,0.00,6.87,364.11,'2022-08-21 17:07:31','',''),(3462,'1','277','1',1,'Retail Sale Id 3485',4397.12,0.00,0.00,6.04,320.12,'2022-08-21 17:09:24','',''),(3463,'1','277','1',1,'Retail Sale Id 3486',2198.56,0.00,0.00,3.02,160.06,'2022-08-21 17:11:58','',''),(3464,'1','277','1',1,'Retail Sale Id 3487',997.36,0.00,0.00,1.37,72.61,'2022-08-21 17:20:24','',''),(3465,'1','277','1',1,'Retail Sale Id 3488',3698.24,0.00,0.00,5.08,269.24,'2022-08-21 17:21:34','',''),(3466,'1','277','1',1,'Retail Sale Id 3489',36996.96,0.00,0.00,50.82,2693.46,'2022-08-21 17:25:18','',''),(3467,'1','277','1',1,'Return of Retail Sale Id 3489',0.00,36996.96,50.82,0.00,-2693.46,'2022-08-21 17:25:52','',''),(3468,'1','277','1',1,'Retail Sale Id 3490',3698.24,0.00,0.00,5.08,269.24,'2022-08-21 17:26:29','',''),(3469,'1','277','1',1,'Retail Sale Id 3491',4368.00,0.00,0.00,6.00,318.00,'2022-08-21 17:29:15','',''),(3470,'1','277','1',1,'Retail Sale Id 3492',9100.00,0.00,0.00,12.50,662.50,'2022-08-21 17:33:38','',''),(3471,'1','277','1',1,'Retail Sale Id 3493',2300.48,0.00,0.00,3.16,167.48,'2022-08-21 17:36:03','',''),(3472,'1','277','1',1,'Retail Sale Id 3494',749.84,0.00,0.00,1.03,54.59,'2022-08-21 17:36:42','',''),(3473,'1','277','1',1,'Retail Sale Id 3495',1201.20,0.00,0.00,1.65,87.45,'2022-08-21 17:37:18','',''),(3474,'1','277','1',1,'Retail Sale Id 3496',749.84,0.00,0.00,1.03,54.59,'2022-08-21 17:41:21','',''),(3475,'1','277','1',1,'Retail Sale Id 3497',2002.00,0.00,0.00,2.75,145.75,'2022-08-21 17:44:35','',''),(3476,'1','277','1',1,'Retail Sale Id 3498',4397.12,0.00,0.00,6.04,320.12,'2022-08-21 17:49:26','',''),(3477,'1','277','1',1,'Retail Sale Id 3499',1499.68,0.00,0.00,2.06,109.18,'2022-08-21 18:02:13','',''),(3478,'1','277','1',1,'Retail Sale Id 3500',1499.68,0.00,0.00,2.06,109.18,'2022-08-21 18:04:39','',''),(3479,'1','277','1',1,'Retail Sale Id 3501',997.36,0.00,0.00,1.37,72.61,'2022-08-21 18:05:16','',''),(3480,'1','277','1',1,'Retail Sale Id 3502',2999.36,0.00,0.00,4.12,218.36,'2022-08-21 18:06:57','',''),(3481,'1','277','1',1,'Retail Sale Id 3503',749.84,0.00,0.00,1.03,54.59,'2022-08-21 18:18:29','',''),(3482,'1','277','1',1,'Retail Sale Id 3504',3698.24,0.00,0.00,5.08,269.24,'2022-08-21 18:19:35','',''),(3483,'1','277','1',1,'Retail Sale Id 3505',2002.00,0.00,0.00,2.75,145.75,'2022-08-21 18:27:33','',''),(3484,'1','277','1',1,'Retail Sale Id 3506',2002.00,0.00,0.00,2.75,145.75,'2022-08-21 18:33:17','',''),(3485,'1','277','1',1,'Retail Sale Id 3507',1499.68,0.00,0.00,2.06,109.18,'2022-08-21 18:35:35','',''),(3486,'1','277','1',1,'Retail Sale Id 3508',3698.24,0.00,0.00,5.08,269.24,'2022-08-21 18:36:56','',''),(3487,'1','277','1',1,'Retail Sale Id 3509',2999.36,0.00,0.00,4.12,218.36,'2022-08-21 18:38:08','',''),(3488,'1','277','1',1,'Retail Sale Id 3510',2999.36,0.00,0.00,4.12,218.36,'2022-08-21 18:48:03','',''),(3489,'1','277','1',1,'Retail Sale Id 3511',2198.56,0.00,0.00,3.02,160.06,'2022-08-21 19:07:59','',''),(3490,'1','277','1',1,'Return of Retail Sale Id 3503',0.00,749.84,1.03,0.00,-54.59,'2022-08-21 19:34:08','',''),(3491,'1','277','1',1,'Retail Sale Id 3512',742.56,0.00,0.00,1.02,54.06,'2022-08-21 19:36:10','',''),(3492,'1','277','1',1,'Retail Sale Id 3513',749.84,0.00,0.00,1.03,54.59,'2022-08-22 06:38:35','',''),(3493,'1','277','1',1,'Retail Sale Id 3514',3501.68,0.00,0.00,4.81,254.93,'2022-08-22 06:56:52','',''),(3494,'1','277','1',1,'Retail Sale Id 3515',2184.00,0.00,0.00,3.00,159.00,'2022-08-22 07:20:44','',''),(3495,'1','277','1',1,'Retail Sale Id 3516',1499.68,0.00,0.00,2.06,109.18,'2022-08-22 07:29:27','',''),(3496,'1','277','1',1,'Retail Sale Id 3517',3698.24,0.00,0.00,5.08,269.24,'2022-08-22 07:35:17','',''),(3497,'1','277','1',1,'Retail Sale Id 3518',9100.00,0.00,0.00,12.50,662.50,'2022-08-22 08:01:58','',''),(3498,'1','277','1',1,'Retail Sale Id 3519',2002.00,0.00,0.00,2.75,145.75,'2022-08-22 08:11:14','',''),(3499,'1','277','1',1,'Retail Sale Id 3520',9100.00,0.00,0.00,12.50,662.50,'2022-08-22 08:31:33','',''),(3500,'1','277','1',1,'Retail Sale Id 3521',2198.56,0.00,0.00,3.02,160.06,'2022-08-22 08:33:22','',''),(3501,'1','277','1',1,'Retail Sale Id 3522',2198.56,0.00,0.00,3.02,160.06,'2022-08-22 09:21:52','',''),(3502,'1','277','1',1,'Retail Sale Id 3523',1499.68,0.00,0.00,2.06,109.18,'2022-08-22 09:53:08','',''),(3503,'1','277','1',1,'Retail Sale Id 3524',997.36,0.00,0.00,1.37,72.61,'2022-08-22 09:56:47','',''),(3504,'1','277','1',1,'Retail Sale Id 3525',2999.36,0.00,0.00,4.12,218.36,'2022-08-22 09:58:15','',''),(3505,'1','277','1',1,'Retail Sale Id 3526',2002.00,0.00,0.00,2.75,145.75,'2022-08-22 10:01:45','',''),(3506,'1','277','1',1,'Retail Sale Id 3527',3996.72,0.00,0.00,5.49,290.97,'2022-08-22 10:02:44','',''),(3507,'1','277','1',1,'Retail Sale Id 3528',4397.12,0.00,0.00,6.04,320.12,'2022-08-22 10:20:52','',''),(3508,'1','277','1',1,'Retail Sale Id 3529',4397.12,0.00,0.00,6.04,320.12,'2022-08-22 10:21:30','',''),(3509,'1','277','1',1,'Retail Sale Id 3531',2919.28,0.00,0.00,4.01,212.53,'2022-08-22 10:23:30','',''),(3510,'1','277','1',1,'Retail Sale Id 3532',9100.00,0.00,0.00,12.50,662.50,'2022-08-22 10:28:08','',''),(3511,'1','277','1',1,'Retail Sale Id 3533',997.36,0.00,0.00,1.37,72.61,'2022-08-22 10:33:35','',''),(3512,'1','277','1',1,'Retail Sale Id 3534',997.36,0.00,0.00,1.37,72.61,'2022-08-22 10:35:24','',''),(3513,'1','277','1',1,'Retail Sale Id 3535',8299.20,0.00,0.00,11.40,604.20,'2022-08-22 10:37:15','',''),(3514,'1','277','1',1,'Return of Retail Sale Id 3532',0.00,9100.00,12.50,0.00,-662.50,'2022-08-22 10:37:48','',''),(3515,'1','277','1',1,'Retail Sale Id 3536',1499.68,0.00,0.00,2.06,109.18,'2022-08-22 10:40:57','',''),(3516,'1','277','1',1,'Retail Sale Id 3537',1499.68,0.00,0.00,2.06,109.18,'2022-08-22 10:44:31','',''),(3517,'1','277','1',1,'Retail Sale Id 3538',749.84,0.00,0.00,1.03,54.59,'2022-08-22 10:45:26','',''),(3518,'1','277','1',1,'Retail Sale Id 3539',2999.36,0.00,0.00,4.12,218.36,'2022-08-22 11:04:49','',''),(3519,'1','277','1',1,'Retail Sale Id 3540',3996.72,0.00,0.00,5.49,290.97,'2022-08-22 11:09:09','',''),(3520,'1','277','1',1,'Retail Sale Id 3541',1397.76,0.00,0.00,1.92,101.76,'2022-08-22 11:09:45','',''),(3521,'1','277','1',1,'Retail Sale Id 3542',3996.72,0.00,0.00,5.49,290.97,'2022-08-22 11:33:50','',''),(3522,'1','277','1',1,'Retail Sale Id 3543',8008.00,0.00,0.00,11.00,583.00,'2022-08-22 11:34:37','',''),(3523,'1','277','1',1,'Retail Sale Id 3544',1499.68,0.00,0.00,2.06,109.18,'2022-08-22 11:36:56','',''),(3524,'1','277','1',1,'Retail Sale Id 3545',3996.72,0.00,0.00,5.49,290.97,'2022-08-22 11:43:52','',''),(3525,'1','277','1',1,'Retail Sale Id 3546',3501.68,0.00,0.00,4.81,254.93,'2022-08-22 11:51:45','',''),(3526,'1','277','1',1,'Retail Sale Id 3547',800.80,0.00,0.00,1.10,58.30,'2022-08-22 11:53:09','',''),(3527,'1','277','1',1,'Retail Sale Id 3548',800.80,0.00,0.00,1.10,58.30,'2022-08-22 12:06:48','',''),(3528,'1','277','1',1,'Retail Sale Id 3549',2700.88,0.00,0.00,3.71,196.63,'2022-08-22 12:13:48','',''),(3529,'1','277','1',1,'Retail Sale Id 3550',502.32,0.00,0.00,0.69,36.57,'2022-08-22 12:20:29','',''),(3530,'1','277','1',1,'Retail Sale Id 3551',2002.00,0.00,0.00,2.75,145.75,'2022-08-22 12:21:09','',''),(3531,'1','277','1',1,'Retail Sale Id 3552',2198.56,0.00,0.00,3.02,160.06,'2022-08-22 12:27:18','',''),(3532,'1','277','1',1,'Retail Sale Id 3553',502.32,0.00,0.00,0.69,36.57,'2022-08-22 12:32:29','',''),(3533,'1','277','1',1,'Retail Sale Id 3554',9100.00,0.00,0.00,12.50,662.50,'2022-08-22 12:40:07','',''),(3534,'1','277','1',1,'Retail Sale Id 3555',2198.56,0.00,0.00,3.02,160.06,'2022-08-22 12:41:16','',''),(3535,'1','277','1',1,'Retail Sale Id 3556',800.80,0.00,0.00,1.10,58.30,'2022-08-22 12:43:22','',''),(3536,'1','277','1',1,'Retail Sale Id 3557',997.36,0.00,0.00,1.37,72.61,'2022-08-22 12:50:41','',''),(3537,'1','277','1',1,'Retail Sale Id 3558',698.88,0.00,0.00,0.96,50.88,'2022-08-22 12:53:45','',''),(3538,'1','277','1',1,'Retail Sale Id 3559',1499.68,0.00,0.00,2.06,109.18,'2022-08-22 13:08:12','',''),(3539,'1','277','1',1,'Retail Sale Id 3560',3640.00,0.00,0.00,5.00,265.00,'2022-08-22 13:14:38','',''),(3540,'1','277','1',1,'Retail Sale Id 3561',5103.28,0.00,0.00,7.01,371.53,'2022-08-22 13:28:37','',''),(3541,'1','277','1',1,'Retail Sale Id 3562',1499.68,0.00,0.00,2.06,109.18,'2022-08-22 13:29:13','',''),(3542,'1','277','1',1,'Retail Sale Id 3563',997.36,0.00,0.00,1.37,72.61,'2022-08-22 13:29:51','',''),(3543,'1','277','1',1,'Retail Sale Id 3564',2198.56,0.00,0.00,3.02,160.06,'2022-08-22 13:32:50','',''),(3544,'1','277','1',1,'Retail Sale Id 3565',4397.12,0.00,0.00,6.04,320.12,'2022-08-22 13:35:48','',''),(3545,'1','277','1',1,'Retail Sale Id 3566',2002.00,0.00,0.00,2.75,145.75,'2022-08-22 13:44:38','',''),(3546,'1','277','1',1,'Retail Sale Id 3567',2999.36,0.00,0.00,4.12,218.36,'2022-08-22 13:50:35','',''),(3547,'1','277','1',1,'Retail Sale Id 3568',1499.68,0.00,0.00,2.06,109.18,'2022-08-22 14:21:01','',''),(3548,'1','277','1',1,'Retail Sale Id 3569',2198.56,0.00,0.00,3.02,160.06,'2022-08-22 14:29:40','',''),(3549,'1','277','1',1,'Retail Sale Id 3570',9100.00,0.00,0.00,12.50,662.50,'2022-08-22 14:31:13','',''),(3550,'1','277','1',1,'Retail Sale Id 3571',2002.00,0.00,0.00,2.75,145.75,'2022-08-22 14:40:56','',''),(3551,'1','277','1',1,'Retail Sale Id 3572',4368.00,0.00,0.00,6.00,318.00,'2022-08-22 14:41:50','',''),(3552,'1','277','1',1,'Retail Sale Id 3573',2198.56,0.00,0.00,3.02,160.06,'2022-08-22 14:43:09','',''),(3553,'1','277','1',1,'Retail Sale Id 3574',2198.56,0.00,0.00,3.02,160.06,'2022-08-22 14:43:39','',''),(3554,'1','277','1',1,'Retail Sale Id 3575',8998.08,0.00,0.00,12.36,655.08,'2022-08-22 14:45:06','',''),(3555,'1','277','1',1,'Retail Sale Id 3576',9100.00,0.00,0.00,12.50,662.50,'2022-08-22 14:46:16','',''),(3556,'1','277','1',1,'Retail Sale Id 3577',3996.72,0.00,0.00,5.49,290.97,'2022-08-22 14:47:16','',''),(3557,'1','277','1',1,'Retail Sale Id 3578',1499.68,0.00,0.00,2.06,109.18,'2022-08-22 15:11:09','',''),(3558,'1','277','1',1,'Retail Sale Id 3579',2002.00,0.00,0.00,2.75,145.75,'2022-08-22 15:11:48','',''),(3559,'1','277','1',1,'Retail Sale Id 3580',2999.36,0.00,0.00,4.12,218.36,'2022-08-22 15:33:11','',''),(3560,'1','277','1',1,'Retail Sale Id 3581',1499.68,0.00,0.00,2.06,109.18,'2022-08-22 15:36:57','',''),(3561,'1','277','1',1,'Retail Sale Id 3582',1499.68,0.00,0.00,2.06,109.18,'2022-08-22 15:37:46','',''),(3562,'1','277','1',1,'Retail Sale Id 3583',3698.24,0.00,0.00,5.08,269.24,'2022-08-22 15:40:07','',''),(3563,'1','277','1',1,'Retail Sale Id 3584',3698.24,0.00,0.00,5.08,269.24,'2022-08-22 15:42:54','',''),(3564,'1','277','1',1,'Retail Sale Id 3585',1499.68,0.00,0.00,2.06,109.18,'2022-08-22 15:46:45','',''),(3565,'1','277','1',1,'Retail Sale Id 3586',2162.16,0.00,0.00,2.97,157.41,'2022-08-22 15:57:55','',''),(3566,'1','277','1',1,'Retail Sale Id 3587',4368.00,0.00,0.00,6.00,318.00,'2022-08-22 15:59:31','',''),(3567,'1','277','1',1,'Retail Sale Id 3588',997.36,0.00,0.00,1.37,72.61,'2022-08-22 16:02:21','',''),(3568,'1','277','1',1,'Retail Sale Id 3589',2002.00,0.00,0.00,2.75,145.75,'2022-08-22 16:09:10','',''),(3569,'1','277','1',1,'Retail Sale Id 3590',2198.56,0.00,0.00,3.02,160.06,'2022-08-22 16:12:20','',''),(3570,'1','277','1',1,'Retail Sale Id 3591',7301.84,0.00,0.00,10.03,531.59,'2022-08-22 16:16:42','',''),(3571,'1','277','1',1,'Retail Sale Id 3592',5001.36,0.00,0.00,6.87,364.11,'2022-08-22 16:20:06','',''),(3572,'1','277','1',1,'Retail Sale Id 3593',2002.00,0.00,0.00,2.75,145.75,'2022-08-22 16:31:47','',''),(3573,'1','277','1',1,'Retail Sale Id 3594',2919.28,0.00,0.00,4.01,212.53,'2022-08-22 16:34:17','',''),(3574,'1','277','1',1,'Retail Sale Id 3594',4368.00,0.00,0.00,6.00,318.00,'2022-08-22 16:34:17','',''),(3575,'1','277','1',1,'Retail Sale Id 3595',997.36,0.00,0.00,1.37,72.61,'2022-08-22 16:36:30','',''),(3576,'1','277','1',1,'Retail Sale Id 3596',1499.68,0.00,0.00,2.06,109.18,'2022-08-22 16:44:52','',''),(3577,'1','277','1',1,'Retail Sale Id 3597',4302.48,0.00,0.00,5.91,313.23,'2022-08-22 16:45:44','',''),(3578,'1','277','1',1,'Retail Sale Id 3598',29820.00,0.00,0.00,42.00,1470.00,'2022-08-22 16:49:48','',''),(3579,'1','277','1',1,'Retail Sale Id 3599',2999.36,0.00,0.00,4.12,218.36,'2022-08-22 16:50:30','',''),(3580,'1','277','1',1,'Retail Sale Id 3600',3640.00,0.00,0.00,5.00,265.00,'2022-08-22 16:57:49','',''),(3581,'1','277','1',1,'Retail Sale Id 3601',3698.24,0.00,0.00,5.08,269.24,'2022-08-22 17:00:12','',''),(3582,'1','277','1',1,'Retail Sale Id 3602',1499.68,0.00,0.00,2.06,109.18,'2022-08-22 17:01:04','',''),(3583,'1','277','1',1,'Retail Sale Id 3603',997.36,0.00,0.00,1.37,72.61,'2022-08-22 17:08:37','',''),(3584,'1','277','1',1,'Retail Sale Id 3604',4499.04,0.00,0.00,6.18,327.54,'2022-08-22 17:10:06','',''),(3585,'1','277','1',1,'Retail Sale Id 3605',749.84,0.00,0.00,1.03,54.59,'2022-08-22 17:12:19','',''),(3586,'1','277','1',1,'Retail Sale Id 3606',2897.44,0.00,0.00,3.98,210.94,'2022-08-22 17:14:23','',''),(3587,'1','277','1',1,'Retail Sale Id 3608',4397.12,0.00,0.00,6.04,320.12,'2022-08-22 17:16:08','',''),(3588,'1','277','1',1,'Retail Sale Id 3609',2198.56,0.00,0.00,3.02,160.06,'2022-08-22 17:19:31','',''),(3589,'1','277','1',1,'Return of Retail Sale Id 3606',0.00,2897.44,3.98,0.00,-210.94,'2022-08-22 17:20:15','',''),(3590,'1','277','1',1,'Retail Sale Id 3610',4397.12,0.00,0.00,6.04,320.12,'2022-08-22 17:26:07','',''),(3591,'1','277','1',1,'Retail Sale Id 3611',749.84,0.00,0.00,1.03,54.59,'2022-08-22 17:27:27','',''),(3592,'1','277','1',1,'Retail Sale Id 3613',2999.36,0.00,0.00,4.12,218.36,'2022-08-22 17:44:51','',''),(3593,'1','277','1',1,'Retail Sale Id 3615',7280.00,0.00,0.00,10.00,530.00,'2022-08-22 17:48:02','',''),(3594,'1','277','1',1,'Retail Sale Id 3616',6501.04,0.00,0.00,8.93,473.29,'2022-08-22 17:53:21','',''),(3595,'1','277','1',1,'Retail Sale Id 3617',3647.28,0.00,0.00,5.01,265.53,'2022-08-22 17:54:09','',''),(3596,'1','277','1',1,'Retail Sale Id 3618',997.36,0.00,0.00,1.37,72.61,'2022-08-22 17:55:38','',''),(3597,'1','277','1',1,'Retail Sale Id 3619',2999.36,0.00,0.00,4.12,218.36,'2022-08-22 17:56:32','',''),(3598,'1','277','1',1,'Retail Sale Id 3620',9100.00,0.00,0.00,12.50,662.50,'2022-08-22 17:57:21','',''),(3599,'1','277','1',1,'Retail Sale Id 3621',11597.04,0.00,0.00,15.93,844.29,'2022-08-22 17:59:02','',''),(3600,'1','277','1',1,'Retail Sale Id 3622',2198.56,0.00,0.00,3.02,160.06,'2022-08-22 18:00:34','',''),(3601,'1','277','1',1,'Retail Sale Id 3623',1499.68,0.00,0.00,2.06,109.18,'2022-08-22 18:13:12','',''),(3602,'1','277','1',1,'Retail Sale Id 3624',2198.56,0.00,0.00,3.02,160.06,'2022-08-22 18:26:28','',''),(3603,'1','277','1',1,'Retail Sale Id 3625',19880.00,0.00,0.00,28.00,980.00,'2022-08-22 18:31:45','',''),(3604,'1','277','1',1,'Retail Sale Id 3627',3698.24,0.00,0.00,5.08,269.24,'2022-08-22 18:34:32','',''),(3605,'1','277','1',1,'Retail Sale Id 3628',9100.00,0.00,0.00,12.50,662.50,'2022-08-22 18:38:03','',''),(3606,'1','277','1',1,'Retail Sale Id 3629',9100.00,0.00,0.00,12.50,662.50,'2022-08-22 18:40:14','',''),(3607,'1','277','1',1,'Retail Sale Id 3630',1499.68,0.00,0.00,2.06,109.18,'2022-08-22 18:41:15','',''),(3608,'1','277','1',1,'Retail Sale Id 3631',1499.68,0.00,0.00,2.06,109.18,'2022-08-22 18:42:05','',''),(3609,'1','277','1',1,'Retail Sale Id 3632',2002.00,0.00,0.00,2.75,145.75,'2022-08-22 18:46:32','',''),(3610,'1','277','1',1,'Retail Sale Id 3633',2002.00,0.00,0.00,2.75,145.75,'2022-08-22 18:49:56','',''),(3611,'1','277','1',1,'Retail Sale Id 3634',2198.56,0.00,0.00,3.02,160.06,'2022-08-22 18:51:02','',''),(3612,'1','277','1',1,'Retail Sale Id 3635',2999.36,0.00,0.00,4.12,218.36,'2022-08-22 18:52:56','',''),(3613,'1','277','1',1,'Retail Sale Id 3636',9100.00,0.00,0.00,12.50,662.50,'2022-08-22 18:53:44','',''),(3614,'1','277','1',1,'Retail Sale Id 3637',2198.56,0.00,0.00,3.02,160.06,'2022-08-22 18:54:42','',''),(3615,'1','277','1',1,'Retail Sale Id 3638',997.36,0.00,0.00,1.37,72.61,'2022-08-22 18:55:17','',''),(3616,'1','277','1',1,'Retail Sale Id 3639',3996.72,0.00,0.00,5.49,290.97,'2022-08-22 19:03:39','',''),(3617,'1','277','1',1,'Retail Sale Id 3640',800.80,0.00,0.00,1.10,58.30,'2022-08-22 19:05:57','',''),(3618,'1','277','1',1,'Retail Sale Id 3641',2999.36,0.00,0.00,4.12,218.36,'2022-08-22 19:06:43','',''),(3619,'1','277','1',1,'Return of Retail Sale Id 3639',0.00,3996.72,5.49,0.00,-290.97,'2022-08-22 19:07:19','',''),(3620,'1','277','1',1,'Retail Sale Id 3642',6552.00,0.00,0.00,9.00,477.00,'2022-08-22 19:14:12','',''),(3621,'1','277','1',1,'Retail Sale Id 3643',1499.68,0.00,0.00,2.06,109.18,'2022-08-22 19:20:43','',''),(3622,'1','277','1',1,'Retail Sale Id 3644',1499.68,0.00,0.00,2.06,109.18,'2022-08-22 19:24:55','',''),(3623,'1','277','1',1,'Retail Sale Id 3645',94.64,0.00,0.00,0.13,6.89,'2022-08-22 19:57:37','',''),(3624,'1','277','1',1,'Retail Sale Id 3646',997.36,0.00,0.00,1.37,72.61,'2022-08-23 06:39:05','',''),(3625,'1','277','1',1,'Retail Sale Id 3647',1499.68,0.00,0.00,2.06,109.18,'2022-08-23 06:55:41','',''),(3626,'1','277','1',1,'Retail Sale Id 3648',2002.00,0.00,0.00,2.75,145.75,'2022-08-23 07:00:32','',''),(3627,'1','277','1',1,'Retail Sale Id 3650',3698.24,0.00,0.00,5.08,269.24,'2022-08-23 07:23:54','',''),(3628,'1','277','1',1,'Retail Sale Id 3652',1499.68,0.00,0.00,2.06,109.18,'2022-08-23 10:15:59','',''),(3629,'1','277','1',1,'Retail Sale Id 3653',2198.56,0.00,0.00,3.02,160.06,'2022-08-23 10:16:58','',''),(3630,'1','277','1',1,'Retail Sale Id 3654',2002.00,0.00,0.00,2.75,145.75,'2022-08-23 10:17:40','',''),(3631,'1','277','1',1,'Retail Sale Id 3655',5197.92,0.00,0.00,7.14,378.42,'2022-08-23 10:18:32','',''),(3632,'1','277','1',1,'Retail Sale Id 3656',8801.52,0.00,0.00,12.09,640.77,'2022-08-23 10:19:15','',''),(3633,'1','277','1',1,'Retail Sale Id 3657',5998.72,0.00,0.00,8.24,436.72,'2022-08-23 10:19:56','',''),(3634,'1','277','1',1,'Retail Sale Id 3658',4702.88,0.00,0.00,6.46,342.38,'2022-08-23 10:20:20','',''),(3635,'1','277','1',1,'Retail Sale Id 3659',8102.64,0.00,0.00,11.13,589.89,'2022-08-23 10:20:56','',''),(3636,'1','277','1',1,'Retail Sale Id 3660',5496.40,0.00,0.00,7.55,400.15,'2022-08-23 10:21:42','',''),(3637,'1','277','1',1,'Retail Sale Id 3661',8000.72,0.00,0.00,10.99,582.47,'2022-08-23 10:22:15','',''),(3638,'1','277','1',1,'Retail Sale Id 3662',2002.00,0.00,0.00,2.75,145.75,'2022-08-23 10:22:48','',''),(3639,'1','277','1',1,'Retail Sale Id 3663',3698.24,0.00,0.00,5.08,269.24,'2022-08-23 10:24:47','',''),(3640,'1','277','1',1,'Retail Sale Id 3664',3647.28,0.00,0.00,5.01,265.53,'2022-08-23 10:25:33','',''),(3641,'1','277','1',1,'Retail Sale Id 3665',9900.80,0.00,0.00,13.60,720.80,'2022-08-23 10:26:19','',''),(3642,'1','277','1',1,'Retail Sale Id 3666',6399.12,0.00,0.00,8.79,465.87,'2022-08-23 10:26:55','',''),(3643,'1','277','1',1,'Retail Sale Id 3667',11102.00,0.00,0.00,15.25,808.25,'2022-08-23 10:27:26','',''),(3644,'1','277','1',1,'Retail Sale Id 3669',10599.68,0.00,0.00,14.56,771.68,'2022-08-23 10:28:27','',''),(3645,'1','277','1',1,'Retail Sale Id 3670',5998.72,0.00,0.00,8.24,436.72,'2022-08-23 10:28:54','',''),(3646,'1','277','1',1,'Retail Sale Id 3671',6697.60,0.00,0.00,9.20,487.60,'2022-08-23 10:29:19','',''),(3647,'1','277','1',1,'Retail Sale Id 3672',4368.00,0.00,0.00,6.00,318.00,'2022-08-23 10:29:53','',''),(3648,'1','277','1',1,'Retail Sale Id 3673',2999.36,0.00,0.00,4.12,218.36,'2022-08-23 10:30:37','',''),(3649,'1','277','1',1,'Retail Sale Id 3674',42600.00,0.00,0.00,60.00,2100.00,'2022-08-23 10:34:26','',''),(3650,'1','277','1',1,'Retail Sale Id 3675',5103.28,0.00,0.00,7.01,371.53,'2022-08-23 10:36:56','',''),(3651,'1','277','1',1,'Retail Sale Id 3676',2002.00,0.00,0.00,2.75,145.75,'2022-08-23 10:52:25','',''),(3652,'1','277','1',1,'Retail Sale Id 3677',9100.00,0.00,0.00,12.50,662.50,'2022-08-23 11:24:10','',''),(3653,'1','277','1',1,'Retail Sale Id 3678',9100.00,0.00,0.00,12.50,662.50,'2022-08-23 11:25:17','',''),(3654,'1','277','1',1,'Retail Sale Id 3679',9100.00,0.00,0.00,12.50,662.50,'2022-08-23 11:40:33','',''),(3655,'1','277','1',1,'Retail Sale Id 3680',2198.56,0.00,0.00,3.02,160.06,'2022-08-23 11:41:45','',''),(3656,'1','277','1',1,'Retail Sale Id 3681',1798.16,0.00,0.00,2.47,130.91,'2022-08-23 11:53:25','',''),(3657,'1','277','1',1,'Retail Sale Id 3682',2999.36,0.00,0.00,4.12,218.36,'2022-08-23 11:59:24','',''),(3658,'1','277','1',1,'Retail Sale Id 3683',3640.00,0.00,0.00,5.00,265.00,'2022-08-23 12:01:30','',''),(3659,'1','277','1',1,'Retail Sale Id 3684',1499.68,0.00,0.00,2.06,109.18,'2022-08-23 12:03:25','',''),(3660,'1','277','1',1,'Retail Sale Id 3685',1499.68,0.00,0.00,2.06,109.18,'2022-08-23 12:04:09','',''),(3661,'1','277','1',1,'Retail Sale Id 3686',9100.00,0.00,0.00,12.50,662.50,'2022-08-23 12:19:41','',''),(3662,'1','277','1',1,'Retail Sale Id 3687',2198.56,0.00,0.00,3.02,160.06,'2022-08-23 12:31:57','',''),(3663,'1','277','1',1,'Retail Sale Id 3688',2198.56,0.00,0.00,3.02,160.06,'2022-08-23 12:42:23','',''),(3664,'1','277','1',1,'Retail Sale Id 3689',3640.00,0.00,0.00,5.00,265.00,'2022-08-23 12:46:53','',''),(3665,'1','277','1',1,'Retail Sale Id 3690',7301.84,0.00,0.00,10.03,531.59,'2022-08-23 12:48:28','',''),(3666,'1','277','1',1,'Retail Sale Id 3691',5103.28,0.00,0.00,7.01,371.53,'2022-08-23 12:49:24','',''),(3667,'1','277','1',1,'Retail Sale Id 3692',2198.56,0.00,0.00,3.02,160.06,'2022-08-23 13:26:15','',''),(3668,'1','277','1',1,'Retail Sale Id 3693',9100.00,0.00,0.00,12.50,662.50,'2022-08-23 13:28:49','',''),(3669,'1','277','1',1,'Retail Sale Id 3694',1499.68,0.00,0.00,2.06,109.18,'2022-08-23 13:29:30','',''),(3670,'1','277','1',1,'Retail Sale Id 3695',3698.24,0.00,0.00,5.08,269.24,'2022-08-23 13:49:25','',''),(3671,'1','277','1',1,'Retail Sale Id 3696',502.32,0.00,0.00,0.69,36.57,'2022-08-23 13:58:34','',''),(3672,'1','277','1',1,'Retail Sale Id 3697',2002.00,0.00,0.00,2.75,145.75,'2022-08-23 14:05:14','',''),(3673,'1','277','1',1,'Retail Sale Id 3698',3698.24,0.00,0.00,5.08,269.24,'2022-08-23 14:08:44','',''),(3674,'1','277','1',1,'Retail Sale Id 3699',997.36,0.00,0.00,1.37,72.61,'2022-08-23 14:21:27','',''),(3675,'1','277','1',1,'Retail Sale Id 3700',4397.12,0.00,0.00,6.04,320.12,'2022-08-23 14:22:30','',''),(3676,'1','277','1',1,'Retail Sale Id 3701',997.36,0.00,0.00,1.37,72.61,'2022-08-23 14:24:55','',''),(3677,'1','277','1',1,'Retail Sale Id 3702',902.72,0.00,0.00,1.24,65.72,'2022-08-23 14:26:40','',''),(3678,'1','277','1',1,'Retail Sale Id 3705',749.84,0.00,0.00,1.03,54.59,'2022-08-23 14:46:41','',''),(3679,'1','277','1',1,'Retail Sale Id 3706',1499.68,0.00,0.00,2.06,109.18,'2022-08-23 14:47:27','',''),(3680,'1','277','1',1,'Retail Sale Id 3707',2999.36,0.00,0.00,4.12,218.36,'2022-08-23 14:52:07','',''),(3681,'1','277','1',1,'Retail Sale Id 3708',9100.00,0.00,0.00,12.50,662.50,'2022-08-23 14:59:11','',''),(3682,'1','277','1',1,'Retail Sale Id 3709',9100.00,0.00,0.00,12.50,662.50,'2022-08-23 15:20:21','',''),(3683,'1','277','1',1,'Retail Sale Id 3710',749.84,0.00,0.00,1.03,54.59,'2022-08-23 15:24:23','',''),(3684,'1','277','1',1,'Retail Sale Id 3711',3698.24,0.00,0.00,5.08,269.24,'2022-08-23 15:42:15','',''),(3685,'1','277','1',1,'Retail Sale Id 3712',698.88,0.00,0.00,0.96,50.88,'2022-08-23 15:51:18','',''),(3686,'1','277','1',1,'Retail Sale Id 3713',3996.72,0.00,0.00,5.49,290.97,'2022-08-23 15:55:46','',''),(3687,'1','277','1',1,'Retail Sale Id 3714',997.36,0.00,0.00,1.37,72.61,'2022-08-23 15:56:30','',''),(3688,'1','277','1',1,'Retail Sale Id 3715',7301.84,0.00,0.00,10.03,531.59,'2022-08-23 16:01:41','',''),(3689,'1','277','1',1,'Retail Sale Id 3716',3297.84,0.00,0.00,4.53,240.09,'2022-08-23 16:05:52','',''),(3690,'1','277','1',1,'Retail Sale Id 3717',728.00,0.00,0.00,1.00,53.00,'2022-08-23 16:07:35','',''),(3691,'1','277','1',1,'Retail Sale Id 3718',3647.28,0.00,0.00,5.01,265.53,'2022-08-23 16:16:08','',''),(3692,'1','277','1',1,'Retail Sale Id 3719',1499.68,0.00,0.00,2.06,109.18,'2022-08-23 16:16:59','',''),(3693,'1','277','1',1,'Retail Sale Id 3720',5001.36,0.00,0.00,6.87,364.11,'2022-08-23 16:18:41','',''),(3694,'1','277','1',1,'Retail Sale Id 3721',9100.00,0.00,0.00,12.50,662.50,'2022-08-23 16:26:31','',''),(3695,'1','277','1',1,'Retail Sale Id 3722',2198.56,0.00,0.00,3.02,160.06,'2022-08-23 16:29:18','',''),(3696,'1','277','1',1,'Retail Sale Id 3723',3698.24,0.00,0.00,5.08,269.24,'2022-08-23 16:30:18','',''),(3697,'1','277','1',1,'Retail Sale Id 3724',3640.00,0.00,0.00,5.00,265.00,'2022-08-23 16:47:36','',''),(3698,'1','277','1',1,'Retail Sale Id 3725',4397.12,0.00,0.00,6.04,320.12,'2022-08-23 16:53:31','',''),(3699,'1','277','1',1,'Retail Sale Id 3726',2198.56,0.00,0.00,3.02,160.06,'2022-08-23 17:08:01','',''),(3700,'1','277','1',1,'Retail Sale Id 3727',1499.68,0.00,0.00,2.06,109.18,'2022-08-23 17:16:54','',''),(3701,'1','277','1',1,'Retail Sale Id 3728',1499.68,0.00,0.00,2.06,109.18,'2022-08-23 17:17:55','',''),(3702,'1','277','1',1,'Retail Sale Id 3729',4397.12,0.00,0.00,6.04,320.12,'2022-08-23 17:18:49','',''),(3703,'1','277','1',1,'Retail Sale Id 3730',2198.56,0.00,0.00,3.02,160.06,'2022-08-23 17:21:35','',''),(3704,'1','277','1',1,'Retail Sale Id 3731',997.36,0.00,0.00,1.37,72.61,'2022-08-23 17:26:16','',''),(3705,'1','277','1',1,'Retail Sale Id 3732',1499.68,0.00,0.00,2.06,109.18,'2022-08-23 17:30:48','',''),(3706,'1','277','1',1,'Retail Sale Id 3733',1499.68,0.00,0.00,2.06,109.18,'2022-08-23 17:32:44','',''),(3707,'1','277','1',1,'Retail Sale Id 3734',1703.52,0.00,0.00,2.34,124.02,'2022-08-23 17:33:20','',''),(3708,'1','277','1',1,'Retail Sale Id 3735',698.88,0.00,0.00,0.96,50.88,'2022-08-23 17:39:07','',''),(3709,'1','277','1',1,'Retail Sale Id 3735',698.88,0.00,0.00,0.96,50.88,'2022-08-23 17:39:07','',''),(3710,'1','277','1',1,'Retail Sale Id 3736',3640.00,0.00,0.00,5.00,265.00,'2022-08-23 17:40:55','',''),(3711,'1','277','1',1,'Retail Sale Id 3737',2198.56,0.00,0.00,3.02,160.06,'2022-08-23 17:41:41','',''),(3712,'1','277','1',1,'Retail Sale Id 3738',2002.00,0.00,0.00,2.75,145.75,'2022-08-23 17:42:18','',''),(3713,'1','277','1',1,'Retail Sale Id 3739',2002.00,0.00,0.00,2.75,145.75,'2022-08-23 17:44:30','',''),(3714,'1','277','1',1,'Retail Sale Id 3740',4600.96,0.00,0.00,6.32,334.96,'2022-08-23 17:54:43','',''),(3715,'1','277','1',1,'Retail Sale Id 3741',2999.36,0.00,0.00,4.12,218.36,'2022-08-23 17:56:30','',''),(3716,'1','277','1',1,'Retail Sale Id 3742',2198.56,0.00,0.00,3.02,160.06,'2022-08-23 17:57:58','',''),(3717,'1','277','1',1,'Retail Sale Id 3743',1499.68,0.00,0.00,2.06,109.18,'2022-08-23 17:58:32','',''),(3718,'1','277','1',1,'Retail Sale Id 3744',502.32,0.00,0.00,0.69,36.57,'2022-08-23 17:59:17','',''),(3719,'1','277','1',1,'Retail Sale Id 3745',2999.36,0.00,0.00,4.12,218.36,'2022-08-23 18:00:02','',''),(3720,'1','277','1',1,'Retail Sale Id 3746',800.80,0.00,0.00,1.10,58.30,'2022-08-23 18:00:49','',''),(3721,'1','277','1',1,'Retail Sale Id 3747',3698.24,0.00,0.00,5.08,269.24,'2022-08-23 18:01:55','',''),(3722,'1','277','1',1,'Retail Sale Id 3748',4397.12,0.00,0.00,6.04,320.12,'2022-08-23 18:06:12','',''),(3723,'1','277','1',1,'Retail Sale Id 3749',997.36,0.00,0.00,1.37,72.61,'2022-08-23 18:07:11','',''),(3724,'1','277','1',1,'Retail Sale Id 3750',2002.00,0.00,0.00,2.75,145.75,'2022-08-23 18:08:07','',''),(3725,'1','277','1',1,'Retail Sale Id 3751',9100.00,0.00,0.00,12.50,662.50,'2022-08-23 18:19:47','',''),(3726,'1','277','1',1,'Retail Sale Id 3752',1499.68,0.00,0.00,2.06,109.18,'2022-08-23 18:20:32','',''),(3727,'1','277','1',1,'Retail Sale Id 3753',4397.12,0.00,0.00,6.04,320.12,'2022-08-23 18:23:04','',''),(3728,'1','277','1',1,'Retail Sale Id 3754',997.36,0.00,0.00,1.37,72.61,'2022-08-23 18:25:24','',''),(3729,'1','277','1',1,'Retail Sale Id 3755',1499.68,0.00,0.00,2.06,109.18,'2022-08-23 18:26:03','',''),(3730,'1','277','1',1,'Retail Sale Id 3756',2198.56,0.00,0.00,3.02,160.06,'2022-08-23 18:27:39','',''),(3731,'1','277','1',1,'Retail Sale Id 3757',800.80,0.00,0.00,1.10,58.30,'2022-08-23 18:30:41','',''),(3732,'1','277','1',1,'Retail Sale Id 3758',2002.00,0.00,0.00,2.75,145.75,'2022-08-23 18:35:52','',''),(3733,'1','277','1',1,'Retail Sale Id 3759',1499.68,0.00,0.00,2.06,109.18,'2022-08-23 18:42:32','',''),(3734,'1','277','1',1,'Retail Sale Id 3760',4397.12,0.00,0.00,6.04,320.12,'2022-08-23 18:44:37','',''),(3735,'1','277','1',1,'Retail Sale Id 3761',4397.12,0.00,0.00,6.04,320.12,'2022-08-23 18:46:57','',''),(3736,'1','277','1',1,'Retail Sale Id 3762',2198.56,0.00,0.00,3.02,160.06,'2022-08-23 18:48:06','',''),(3737,'1','277','1',1,'Retail Sale Id 3763',902.72,0.00,0.00,1.24,65.72,'2022-08-23 18:50:40','',''),(3738,'1','277','1',1,'Retail Sale Id 3764',5998.72,0.00,0.00,8.24,436.72,'2022-08-23 18:51:58','',''),(3739,'1','277','1',1,'Retail Sale Id 3765',3996.72,0.00,0.00,5.49,290.97,'2022-08-23 19:04:47','',''),(3740,'1','277','1',1,'Retail Sale Id 3766',997.36,0.00,0.00,1.37,72.61,'2022-08-23 19:14:16','',''),(3741,'1','277','1',1,'Retail Sale Id 3767',2497.04,0.00,0.00,3.43,181.79,'2022-08-23 19:15:00','',''),(3742,'1','277','1',1,'Return of Retail Sale Id 3767',0.00,2497.04,3.43,0.00,-181.79,'2022-08-23 19:34:47','',''),(3743,'1','277','1',1,'Retail Sale Id 3768',2489.76,0.00,0.00,3.42,181.26,'2022-08-23 19:36:32','',''),(3744,'1','277','1',1,'Retail Sale Id 3770',3647.28,0.00,0.00,5.01,265.53,'2022-08-24 06:59:16','',''),(3745,'1','277','1',1,'Retail Sale Id 3771',4499.04,0.00,0.00,6.18,327.54,'2022-08-24 07:08:01','',''),(3746,'1','277','1',1,'Retail Sale Id 3772',4397.12,0.00,0.00,6.04,320.12,'2022-08-24 07:09:13','',''),(3747,'1','277','1',1,'Retail Sale Id 3773',4499.04,0.00,0.00,6.18,327.54,'2022-08-24 07:23:39','',''),(3748,'1','277','1',1,'Retail Sale Id 3774',1499.68,0.00,0.00,2.06,109.18,'2022-08-24 07:30:41','',''),(3749,'1','277','1',1,'Retail Sale Id 3775',1703.52,0.00,0.00,2.34,124.02,'2022-08-24 07:38:09','',''),(3750,'1','277','1',1,'Retail Sale Id 3777',502.32,0.00,0.00,0.69,36.57,'2022-08-24 07:47:01','',''),(3751,'1','277','1',1,'Retail Sale Id 3778',3698.24,0.00,0.00,5.08,269.24,'2022-08-24 07:51:12','',''),(3752,'1','277','1',1,'Retail Sale Id 3779',2802.80,0.00,0.00,3.85,204.05,'2022-08-24 07:54:32','',''),(3753,'1','277','1',1,'Retail Sale Id 3780',2999.36,0.00,0.00,4.12,218.36,'2022-08-24 07:55:20','',''),(3754,'1','277','1',1,'Retail Sale Id 3781',7301.84,0.00,0.00,10.03,531.59,'2022-08-24 08:05:14','',''),(3755,'1','277','1',1,'Retail Sale Id 3783',3996.72,0.00,0.00,5.49,290.97,'2022-08-24 08:28:07','',''),(3756,'1','277','1',1,'Retail Sale Id 3784',4397.12,0.00,0.00,6.04,320.12,'2022-08-24 08:32:02','',''),(3757,'1','277','1',1,'Retail Sale Id 3785',2999.36,0.00,0.00,4.12,218.36,'2022-08-24 08:32:52','',''),(3758,'1','277','1',1,'Retail Sale Id 3786',5853.12,0.00,0.00,8.04,426.12,'2022-08-24 08:46:20','',''),(3759,'1','277','1',1,'Retail Sale Id 3787',2999.36,0.00,0.00,4.12,218.36,'2022-08-24 08:48:01','',''),(3760,'1','277','1',1,'Retail Sale Id 3788',9100.00,0.00,0.00,12.50,662.50,'2022-08-24 08:57:37','',''),(3761,'1','277','1',1,'Retail Sale Id 3789',2999.36,0.00,0.00,4.12,218.36,'2022-08-24 08:58:22','',''),(3762,'1','277','1',1,'Retail Sale Id 3790',9100.00,0.00,0.00,12.50,662.50,'2022-08-24 09:03:32','',''),(3763,'1','277','1',1,'Retail Sale Id 3791',9100.00,0.00,0.00,12.50,662.50,'2022-08-24 09:07:38','',''),(3764,'1','277','1',1,'Retail Sale Id 3792',400.40,0.00,0.00,0.55,29.15,'2022-08-24 09:11:34','',''),(3765,'1','277','1',1,'Retail Sale Id 3793',9100.00,0.00,0.00,12.50,662.50,'2022-08-24 09:26:05','',''),(3766,'1','277','1',1,'Retail Sale Id 3794',9100.00,0.00,0.00,12.50,662.50,'2022-08-24 09:37:39','',''),(3767,'1','277','1',1,'Retail Sale Id 3795',9100.00,0.00,0.00,12.50,662.50,'2022-08-24 09:46:02','',''),(3768,'1','277','1',1,'Retail Sale Id 3796',2198.56,0.00,0.00,3.02,160.06,'2022-08-24 09:47:21','',''),(3769,'1','277','1',1,'Retail Sale Id 3797',502.32,0.00,0.00,0.69,36.57,'2022-08-24 09:48:02','',''),(3770,'1','277','1',1,'Retail Sale Id 3798',2999.36,0.00,0.00,4.12,218.36,'2022-08-24 09:52:50','',''),(3771,'1','277','1',1,'Retail Sale Id 3799',9100.00,0.00,0.00,12.50,662.50,'2022-08-24 09:57:08','',''),(3772,'1','277','1',1,'Return of Retail Sale Id 3796',0.00,2198.56,3.02,0.00,-160.06,'2022-08-24 09:59:18','',''),(3773,'1','277','1',1,'Retail Sale Id 3800',2031.12,0.00,0.00,2.79,147.87,'2022-08-24 09:59:45','',''),(3774,'1','277','1',1,'Retail Sale Id 3801',9100.00,0.00,0.00,12.50,662.50,'2022-08-24 10:02:40','',''),(3775,'1','277','1',1,'Retail Sale Id 3802',4499.04,0.00,0.00,6.18,327.54,'2022-08-24 10:03:47','',''),(3776,'1','277','1',1,'Retail Sale Id 3803',1499.68,0.00,0.00,2.06,109.18,'2022-08-24 10:04:41','',''),(3777,'1','277','1',1,'Retail Sale Id 3804',1499.68,0.00,0.00,2.06,109.18,'2022-08-24 10:10:30','',''),(3778,'1','277','1',1,'Retail Sale Id 3805',749.84,0.00,0.00,1.03,54.59,'2022-08-24 10:11:16','',''),(3779,'1','277','1',1,'Retail Sale Id 3806',1456.00,0.00,0.00,2.00,106.00,'2022-08-24 10:14:38','',''),(3780,'1','277','1',1,'Retail Sale Id 3806',2912.00,0.00,0.00,4.00,212.00,'2022-08-24 10:14:38','',''),(3781,'1','277','1',1,'Retail Sale Id 3807',1499.68,0.00,0.00,2.06,109.18,'2022-08-24 10:23:35','',''),(3782,'1','277','1',1,'Retail Sale Id 3808',9100.00,0.00,0.00,12.50,662.50,'2022-08-24 10:24:15','',''),(3783,'1','277','1',1,'Retail Sale Id 3809',21300.00,0.00,0.00,30.00,1050.00,'2022-08-24 10:27:37','',''),(3784,'1','277','1',1,'Retail Sale Id 3810',2999.36,0.00,0.00,4.12,218.36,'2022-08-24 10:30:11','',''),(3785,'1','277','1',1,'Retail Sale Id 3811',2198.56,0.00,0.00,3.02,160.06,'2022-08-24 10:37:53','',''),(3786,'1','277','1',1,'Retail Sale Id 3812',502.32,0.00,0.00,0.69,36.57,'2022-08-24 10:43:19','',''),(3787,'1','277','1',1,'Retail Sale Id 3813',3996.72,0.00,0.00,5.49,290.97,'2022-08-24 11:08:50','',''),(3788,'1','277','1',1,'Retail Sale Id 3814',174660.00,0.00,0.00,246.00,8610.00,'2022-08-24 11:17:54','',''),(3789,'1','277','1',1,'Retail Sale Id 3815',997.36,0.00,0.00,1.37,72.61,'2022-08-24 11:34:17','',''),(3790,'1','277','1',1,'Retail Sale Id 3816',9100.00,0.00,0.00,12.50,662.50,'2022-08-24 11:36:36','',''),(3791,'1','277','1',1,'Retail Sale Id 3817',4397.12,0.00,0.00,6.04,320.12,'2022-08-24 11:39:24','',''),(3792,'1','277','1',1,'Retail Sale Id 3818',2198.56,0.00,0.00,3.02,160.06,'2022-08-24 11:44:48','',''),(3793,'1','277','1',1,'Retail Sale Id 3819',2002.00,0.00,0.00,2.75,145.75,'2022-08-24 11:51:13','',''),(3794,'1','277','1',1,'Retail Sale Id 3820',2002.00,0.00,0.00,2.75,145.75,'2022-08-24 12:01:08','',''),(3795,'1','277','1',1,'Retail Sale Id 3821',3698.24,0.00,0.00,5.08,269.24,'2022-08-24 12:14:41','',''),(3796,'1','277','1',1,'Retail Sale Id 3822',698.88,0.00,0.00,0.96,50.88,'2022-08-24 12:17:02','',''),(3797,'1','277','1',1,'Retail Sale Id 3823',2002.00,0.00,0.00,2.75,145.75,'2022-08-24 12:35:44','',''),(3798,'1','277','1',1,'Retail Sale Id 3824',7301.84,0.00,0.00,10.03,531.59,'2022-08-24 12:39:12','',''),(3799,'1','277','1',1,'Retail Sale Id 3825',5001.36,0.00,0.00,6.87,364.11,'2022-08-24 12:44:54','',''),(3800,'1','277','1',1,'Retail Sale Id 3826',9100.00,0.00,0.00,12.50,662.50,'2022-08-24 12:51:00','',''),(3801,'1','277','1',1,'Retail Sale Id 3827',5001.36,0.00,0.00,6.87,364.11,'2022-08-24 12:54:52','',''),(3802,'1','277','1',1,'Retail Sale Id 3828',2002.00,0.00,0.00,2.75,145.75,'2022-08-24 13:00:51','',''),(3803,'1','277','1',1,'Retail Sale Id 3829',9100.00,0.00,0.00,12.50,662.50,'2022-08-24 13:06:20','',''),(3804,'1','277','1',1,'Retail Sale Id 3830',2999.36,0.00,0.00,4.12,218.36,'2022-08-24 13:28:50','',''),(3805,'1','277','1',1,'Retail Sale Id 3831',3996.72,0.00,0.00,5.49,290.97,'2022-08-24 13:32:25','',''),(3806,'1','277','1',1,'Retail Sale Id 3832',2002.00,0.00,0.00,2.75,145.75,'2022-08-24 13:42:48','',''),(3807,'1','277','1',1,'Retail Sale Id 3833',5001.36,0.00,0.00,6.87,364.11,'2022-08-24 13:48:29','',''),(3808,'1','277','1',1,'Retail Sale Id 3834',800.80,0.00,0.00,1.10,58.30,'2022-08-24 14:03:54','',''),(3809,'1','277','1',1,'Retail Sale Id 3835',2002.00,0.00,0.00,2.75,145.75,'2022-08-24 14:08:46','',''),(3810,'1','277','1',1,'Retail Sale Id 3836',5001.36,0.00,0.00,6.87,364.11,'2022-08-24 14:28:47','',''),(3811,'1','277','1',1,'Retail Sale Id 3837',3501.68,0.00,0.00,4.81,254.93,'2022-08-24 14:29:50','',''),(3812,'1','277','1',1,'Retail Sale Id 3838',3647.28,0.00,0.00,5.01,265.53,'2022-08-24 14:35:49','',''),(3813,'1','277','1',1,'Retail Sale Id 3839',1499.68,0.00,0.00,2.06,109.18,'2022-08-24 14:40:47','',''),(3814,'1','277','1',1,'Retail Sale Id 3840',1499.68,0.00,0.00,2.06,109.18,'2022-08-24 14:45:54','',''),(3815,'1','277','1',1,'Retail Sale Id 3841',1499.68,0.00,0.00,2.06,109.18,'2022-08-24 14:53:42','',''),(3816,'1','277','1',1,'Retail Sale Id 3842',2999.36,0.00,0.00,4.12,218.36,'2022-08-24 15:00:15','',''),(3817,'1','277','1',1,'Retail Sale Id 3843',0.00,0.00,0.00,0.00,0.00,'2022-08-24 15:21:46','',''),(3818,'1','277','1',1,'Retail Sale Id 3844',997.36,0.00,0.00,1.37,72.61,'2022-08-24 15:26:21','',''),(3819,'1','277','1',1,'Retail Sale Id 3845',997.36,0.00,0.00,1.37,72.61,'2022-08-24 15:41:37','',''),(3820,'1','277','1',1,'Retail Sale Id 3846',8503.04,0.00,0.00,11.68,619.04,'2022-08-24 15:47:02','',''),(3821,'1','277','1',1,'Retail Sale Id 3847',9100.00,0.00,0.00,12.50,662.50,'2022-08-24 15:49:35','',''),(3822,'1','277','1',1,'Retail Sale Id 3848',2999.36,0.00,0.00,4.12,218.36,'2022-08-24 15:54:54','',''),(3823,'1','277','1',1,'Retail Sale Id 3849',2999.36,0.00,0.00,4.12,218.36,'2022-08-24 15:55:35','',''),(3824,'1','277','1',1,'Retail Sale Id 3850',1499.68,0.00,0.00,2.06,109.18,'2022-08-24 16:09:52','',''),(3825,'1','277','1',1,'Retail Sale Id 3851',3698.24,0.00,0.00,5.08,269.24,'2022-08-24 16:14:52','',''),(3826,'1','277','1',1,'Retail Sale Id 3852',298.48,0.00,0.00,0.41,21.73,'2022-08-24 16:20:11','',''),(3827,'1','277','1',1,'Retail Sale Id 3853',2198.56,0.00,0.00,3.02,160.06,'2022-08-24 16:27:29','',''),(3828,'1','277','1',1,'Retail Sale Id 3854',4397.12,0.00,0.00,6.04,320.12,'2022-08-24 16:28:53','',''),(3829,'1','277','1',1,'Retail Sale Id 3855',2999.36,0.00,0.00,4.12,218.36,'2022-08-24 16:29:45','',''),(3830,'1','277','1',1,'Retail Sale Id 3856',2002.00,0.00,0.00,2.75,145.75,'2022-08-24 16:30:49','',''),(3831,'1','277','1',1,'Retail Sale Id 3856',3996.72,0.00,0.00,5.49,290.97,'2022-08-24 16:30:49','',''),(3832,'1','277','1',1,'Retail Sale Id 3857',997.36,0.00,0.00,1.37,72.61,'2022-08-24 16:31:47','',''),(3833,'1','277','1',1,'Retail Sale Id 3858',997.36,0.00,0.00,1.37,72.61,'2022-08-24 16:32:52','',''),(3834,'1','277','1',1,'Retail Sale Id 3859',2002.00,0.00,0.00,2.75,145.75,'2022-08-24 16:33:37','',''),(3835,'1','277','1',1,'Retail Sale Id 3860',3698.24,0.00,0.00,5.08,269.24,'2022-08-24 16:38:51','',''),(3836,'1','277','1',1,'Retail Sale Id 3861',749.84,0.00,0.00,1.03,54.59,'2022-08-24 16:39:27','',''),(3837,'1','277','1',1,'Retail Sale Id 3862',997.36,0.00,0.00,1.37,72.61,'2022-08-24 16:40:05','',''),(3838,'1','277','1',1,'Retail Sale Id 3863',2198.56,0.00,0.00,3.02,160.06,'2022-08-24 16:41:22','',''),(3839,'1','277','1',1,'Retail Sale Id 3864',1499.68,0.00,0.00,2.06,109.18,'2022-08-24 16:52:50','',''),(3840,'1','277','1',1,'Retail Sale Id 3865',3698.24,0.00,0.00,5.08,269.24,'2022-08-24 16:57:41','',''),(3841,'1','277','1',1,'Retail Sale Id 3866',2249.52,0.00,0.00,3.09,163.77,'2022-08-24 16:58:38','',''),(3842,'1','277','1',1,'Retail Sale Id 3867',997.36,0.00,0.00,1.37,72.61,'2022-08-24 17:00:15','',''),(3843,'1','277','1',1,'Retail Sale Id 3868',2198.56,0.00,0.00,3.02,160.06,'2022-08-24 17:00:57','',''),(3844,'1','277','1',1,'Retail Sale Id 3869',2002.00,0.00,0.00,2.75,145.75,'2022-08-24 17:01:43','',''),(3845,'1','277','1',1,'Retail Sale Id 3870',4397.12,0.00,0.00,6.04,320.12,'2022-08-24 17:02:27','',''),(3846,'1','277','1',1,'Retail Sale Id 3871',2002.00,0.00,0.00,2.75,145.75,'2022-08-24 17:04:16','',''),(3847,'1','277','1',1,'Retail Sale Id 3872',9100.00,0.00,0.00,12.50,662.50,'2022-08-24 17:06:40','',''),(3848,'1','277','1',1,'Retail Sale Id 3874',14560.00,0.00,0.00,20.00,1060.00,'2022-08-24 17:08:34','',''),(3849,'1','277','1',1,'Retail Sale Id 3875',2198.56,0.00,0.00,3.02,160.06,'2022-08-24 17:16:35','',''),(3850,'1','277','1',1,'Retail Sale Id 3876',698.88,0.00,0.00,0.96,50.88,'2022-08-24 17:17:26','',''),(3851,'1','277','1',1,'Retail Sale Id 3877',1499.68,0.00,0.00,2.06,109.18,'2022-08-24 17:19:59','',''),(3852,'1','277','1',1,'Retail Sale Id 3878',4397.12,0.00,0.00,6.04,320.12,'2022-08-24 17:20:51','',''),(3853,'1','277','1',1,'Retail Sale Id 3879',3501.68,0.00,0.00,4.81,254.93,'2022-08-24 17:22:14','',''),(3854,'1','277','1',1,'Retail Sale Id 3880',298.48,0.00,0.00,0.41,21.73,'2022-08-24 17:29:03','',''),(3855,'1','277','1',1,'Retail Sale Id 3881',5700.24,0.00,0.00,7.83,414.99,'2022-08-24 17:31:44','',''),(3856,'1','277','1',1,'Retail Sale Id 3882',2198.56,0.00,0.00,3.02,160.06,'2022-08-24 17:32:37','',''),(3857,'1','277','1',1,'Retail Sale Id 3883',997.36,0.00,0.00,1.37,72.61,'2022-08-24 17:35:59','',''),(3858,'1','277','1',1,'Retail Sale Id 3884',3640.00,0.00,0.00,5.00,265.00,'2022-08-24 17:39:25','',''),(3859,'1','277','1',1,'Retail Sale Id 3885',2919.28,0.00,0.00,4.01,212.53,'2022-08-24 17:49:49','',''),(3860,'1','277','1',1,'Retail Sale Id 3886',1499.68,0.00,0.00,2.06,109.18,'2022-08-24 17:50:26','',''),(3861,'1','277','1',1,'Retail Sale Id 3887',4499.04,0.00,0.00,6.18,327.54,'2022-08-24 17:53:12','',''),(3862,'1','277','1',1,'Retail Sale Id 3888',2002.00,0.00,0.00,2.75,145.75,'2022-08-24 17:58:28','',''),(3863,'1','277','1',1,'Retail Sale Id 3889',1499.68,0.00,0.00,2.06,109.18,'2022-08-24 18:04:04','',''),(3864,'1','277','1',1,'Retail Sale Id 3890',19880.00,0.00,0.00,28.00,980.00,'2022-08-24 18:09:55','',''),(3865,'1','277','1',1,'Retail Sale Id 3891',997.36,0.00,0.00,1.37,72.61,'2022-08-24 18:12:58','',''),(3866,'1','277','1',1,'Retail Sale Id 3892',997.36,0.00,0.00,1.37,72.61,'2022-08-24 18:19:49','',''),(3867,'1','277','1',1,'Retail Sale Id 3893',7301.84,0.00,0.00,10.03,531.59,'2022-08-24 18:30:00','',''),(3868,'1','277','1',1,'Retail Sale Id 3894',698.88,0.00,0.00,0.96,50.88,'2022-08-24 18:36:45','',''),(3869,'1','277','1',1,'Retail Sale Id 3895',800.80,0.00,0.00,1.10,58.30,'2022-08-24 18:38:21','',''),(3870,'1','277','1',1,'Retail Sale Id 3896',997.36,0.00,0.00,1.37,72.61,'2022-08-24 18:38:58','',''),(3871,'1','277','1',1,'Retail Sale Id 3897',2198.56,0.00,0.00,3.02,160.06,'2022-08-24 18:41:31','',''),(3872,'1','277','1',1,'Retail Sale Id 3898',1499.68,0.00,0.00,2.06,109.18,'2022-08-24 18:42:20','',''),(3873,'1','277','1',1,'Retail Sale Id 3899',2999.36,0.00,0.00,4.12,218.36,'2022-08-24 18:45:39','',''),(3874,'1','277','1',1,'Retail Sale Id 3900',997.36,0.00,0.00,1.37,72.61,'2022-08-24 18:50:17','',''),(3875,'1','277','1',1,'Retail Sale Id 3901',1499.68,0.00,0.00,2.06,109.18,'2022-08-24 18:51:36','',''),(3876,'1','277','1',1,'Retail Sale Id 3902',997.36,0.00,0.00,1.37,72.61,'2022-08-24 18:55:37','',''),(3877,'1','277','1',1,'Retail Sale Id 3903',1499.68,0.00,0.00,2.06,109.18,'2022-08-24 19:07:24','',''),(3878,'1','277','1',1,'Retail Sale Id 3904',2198.56,0.00,0.00,3.02,160.06,'2022-08-24 19:09:21','',''),(3879,'1','277','1',1,'Retail Sale Id 3905',902.72,0.00,0.00,1.24,65.72,'2022-08-24 19:10:17','',''),(3880,'1','277','1',1,'Retail Sale Id 3906',3996.72,0.00,0.00,5.49,290.97,'2022-08-24 19:13:33','',''),(3881,'1','277','1',1,'Retail Sale Id 3907',3996.72,0.00,0.00,5.49,290.97,'2022-08-24 19:30:00','',''),(3882,'1','277','1',1,'Return of Retail Sale Id 3890',0.00,19880.00,28.00,0.00,-980.00,'2022-08-24 20:19:20','',''),(3883,'1','277','1',1,'Retail Sale Id 3908',17934.60,0.00,0.00,25.26,884.10,'2022-08-24 20:21:20','',''),(3884,'1','277','1',1,'Retail Sale Id 3909',1361.36,0.00,0.00,1.87,99.11,'2022-08-24 20:22:54','',''),(3885,'1','277','1',1,'Retail Sale Id 3911',1499.68,0.00,0.00,2.06,109.18,'2022-08-25 07:07:11','',''),(3886,'1','277','1',1,'Retail Sale Id 3912',9100.00,0.00,0.00,12.50,662.50,'2022-08-25 07:07:53','',''),(3887,'1','277','1',1,'Retail Sale Id 3913',2002.00,0.00,0.00,2.75,145.75,'2022-08-25 07:09:19','',''),(3888,'1','277','1',1,'Retail Sale Id 3918',728.00,0.00,0.00,1.00,53.00,'2022-08-25 07:17:46','',''),(3889,'1','277','1',1,'Retail Sale Id 3920',2198.56,0.00,0.00,3.02,160.06,'2022-08-25 07:28:48','',''),(3890,'1','277','1',1,'Retail Sale Id 3921',4397.12,0.00,0.00,6.04,320.12,'2022-08-25 07:31:41','',''),(3891,'1','277','1',1,'Retail Sale Id 3922',4368.00,0.00,0.00,6.00,318.00,'2022-08-25 07:34:02','',''),(3892,'1','277','1',1,'Retail Sale Id 3923',997.36,0.00,0.00,1.37,72.61,'2022-08-25 07:34:49','',''),(3893,'1','277','1',1,'Retail Sale Id 3924',2497.04,0.00,0.00,3.43,181.79,'2022-08-25 07:35:40','',''),(3894,'1','277','1',1,'Retail Sale Id 3925',1499.68,0.00,0.00,2.06,109.18,'2022-08-25 07:36:36','',''),(3895,'1','277','1',1,'Retail Sale Id 3926',9100.00,0.00,0.00,12.50,662.50,'2022-08-25 07:39:15','',''),(3896,'1','277','1',1,'Retail Sale Id 3927',3996.72,0.00,0.00,5.49,290.97,'2022-08-25 07:51:14','',''),(3897,'1','277','1',1,'Retail Sale Id 3928',9100.00,0.00,0.00,12.50,662.50,'2022-08-25 07:59:19','',''),(3898,'1','277','1',1,'Retail Sale Id 3929',3647.28,0.00,0.00,5.01,265.53,'2022-08-25 08:01:55','',''),(3899,'1','277','1',1,'Retail Sale Id 3930',2999.36,0.00,0.00,4.12,218.36,'2022-08-25 08:05:48','',''),(3900,'1','277','1',1,'Retail Sale Id 3931',2198.56,0.00,0.00,3.02,160.06,'2022-08-25 08:10:52','',''),(3901,'1','277','1',1,'Retail Sale Id 3932',4368.00,0.00,0.00,6.00,318.00,'2022-08-25 08:22:28','',''),(3902,'1','277','1',1,'Retail Sale Id 3933',1499.68,0.00,0.00,2.06,109.18,'2022-08-25 08:26:14','',''),(3903,'1','277','1',1,'Retail Sale Id 3934',2002.00,0.00,0.00,2.75,145.75,'2022-08-25 08:27:23','',''),(3904,'1','277','1',1,'Retail Sale Id 3935',4397.12,0.00,0.00,6.04,320.12,'2022-08-25 08:34:08','',''),(3905,'1','277','1',1,'Retail Sale Id 3936',1703.52,0.00,0.00,2.34,124.02,'2022-08-25 08:52:26','',''),(3906,'1','277','1',1,'Retail Sale Id 3937',3698.24,0.00,0.00,5.08,269.24,'2022-08-25 08:58:02','',''),(3907,'1','277','1',1,'Retail Sale Id 3938',2999.36,0.00,0.00,4.12,218.36,'2022-08-25 08:59:16','',''),(3908,'1','277','1',1,'Retail Sale Id 3939',9100.00,0.00,0.00,12.50,662.50,'2022-08-25 09:03:25','',''),(3909,'1','277','1',1,'Retail Sale Id 3940',28400.00,0.00,0.00,40.00,1400.00,'2022-08-25 09:19:56','',''),(3910,'1','277','1',1,'Retail Sale Id 3941',997.36,0.00,0.00,1.37,72.61,'2022-08-25 09:20:43','',''),(3911,'1','277','1',1,'Retail Sale Id 3942',997.36,0.00,0.00,1.37,72.61,'2022-08-25 09:24:39','',''),(3912,'1','277','1',1,'Retail Sale Id 3943',2999.36,0.00,0.00,4.12,218.36,'2022-08-25 09:31:04','',''),(3913,'1','277','1',1,'Retail Sale Id 3944',2497.04,0.00,0.00,3.43,181.79,'2022-08-25 09:37:23','',''),(3914,'1','277','1',1,'Retail Sale Id 3945',2002.00,0.00,0.00,2.75,145.75,'2022-08-25 09:38:15','',''),(3915,'1','277','1',1,'Retail Sale Id 3946',6552.00,0.00,0.00,9.00,477.00,'2022-08-25 09:51:23','',''),(3916,'1','277','1',1,'Retail Sale Id 3947',1201.20,0.00,0.00,1.65,87.45,'2022-08-25 10:00:44','',''),(3917,'1','277','1',1,'Retail Sale Id 3948',4397.12,0.00,0.00,6.04,320.12,'2022-08-25 10:08:23','',''),(3918,'1','277','1',1,'Retail Sale Id 3949',3640.00,0.00,0.00,5.00,265.00,'2022-08-25 10:17:55','',''),(3919,'1','277','1',1,'Retail Sale Id 3950',3647.28,0.00,0.00,5.01,265.53,'2022-08-25 10:28:02','',''),(3920,'1','277','1',1,'Retail Sale Id 3951',18200.00,0.00,0.00,25.00,1325.00,'2022-08-25 10:30:21','',''),(3921,'1','277','1',1,'Retail Sale Id 3952',1499.68,0.00,0.00,2.06,109.18,'2022-08-25 10:37:19','',''),(3922,'1','277','1',1,'Retail Sale Id 3953',2999.36,0.00,0.00,4.12,218.36,'2022-08-25 10:39:03','',''),(3923,'1','277','1',1,'Retail Sale Id 3954',10920.00,0.00,0.00,15.00,795.00,'2022-08-25 10:54:33','',''),(3924,'1','277','1',1,'Retail Sale Id 3955',749.84,0.00,0.00,1.03,54.59,'2022-08-25 10:59:31','',''),(3925,'1','277','1',1,'Retail Sale Id 3956',5001.36,0.00,0.00,6.87,364.11,'2022-08-25 11:02:10','',''),(3926,'1','277','1',1,'Retail Sale Id 3957',2198.56,0.00,0.00,3.02,160.06,'2022-08-25 11:03:52','',''),(3927,'1','277','1',1,'Retail Sale Id 3958',2002.00,0.00,0.00,2.75,145.75,'2022-08-25 11:29:17','',''),(3928,'1','277','1',1,'Retail Sale Id 3959',8401.12,0.00,0.00,11.54,611.62,'2022-08-25 11:36:22','',''),(3929,'1','277','1',1,'Retail Sale Id 3960',5001.36,0.00,0.00,6.87,364.11,'2022-08-25 11:45:42','',''),(3930,'1','277','1',1,'Retail Sale Id 3961',3698.24,0.00,0.00,5.08,269.24,'2022-08-25 12:02:26','',''),(3931,'1','277','1',1,'Retail Sale Id 3962',9100.00,0.00,0.00,12.50,662.50,'2022-08-25 12:23:27','',''),(3932,'1','277','1',1,'Retail Sale Id 3963',2198.56,0.00,0.00,3.02,160.06,'2022-08-25 12:36:59','',''),(3933,'1','277','1',1,'Retail Sale Id 3964',1397.76,0.00,0.00,1.92,101.76,'2022-08-25 12:40:17','',''),(3934,'1','277','1',1,'Retail Sale Id 3965',6552.00,0.00,0.00,9.00,477.00,'2022-08-25 12:44:58','',''),(3935,'1','277','1',1,'Retail Sale Id 3966',4397.12,0.00,0.00,6.04,320.12,'2022-08-25 12:45:45','',''),(3936,'1','277','1',1,'Retail Sale Id 3967',3698.24,0.00,0.00,5.08,269.24,'2022-08-25 13:01:46','',''),(3937,'1','277','1',1,'Retail Sale Id 3968',5001.36,0.00,0.00,6.87,364.11,'2022-08-25 13:12:51','',''),(3938,'1','277','1',1,'Return of Retail Sale Id 3968',0.00,5001.36,6.87,0.00,-364.11,'2022-08-25 13:13:51','',''),(3939,'1','277','1',1,'Retail Sale Id 3969',4397.12,0.00,0.00,6.04,320.12,'2022-08-25 13:14:15','',''),(3940,'1','277','1',1,'Retail Sale Id 3970',2497.04,0.00,0.00,3.43,181.79,'2022-08-25 13:15:41','',''),(3941,'1','277','1',1,'Retail Sale Id 3971',502.32,0.00,0.00,0.69,36.57,'2022-08-25 13:24:14','',''),(3942,'1','277','1',1,'Retail Sale Id 3972',5001.36,0.00,0.00,6.87,364.11,'2022-08-25 13:24:53','',''),(3943,'1','277','1',1,'Retail Sale Id 3973',1499.68,0.00,0.00,2.06,109.18,'2022-08-25 13:29:18','',''),(3944,'1','277','1',1,'Retail Sale Id 3974',2002.00,0.00,0.00,2.75,145.75,'2022-08-25 13:35:11','',''),(3945,'1','277','1',1,'Retail Sale Id 3975',2096.64,0.00,0.00,2.88,152.64,'2022-08-25 13:47:35','',''),(3946,'1','277','1',1,'Retail Sale Id 3976',4397.12,0.00,0.00,6.04,320.12,'2022-08-25 13:52:46','',''),(3947,'1','277','1',1,'Retail Sale Id 3977',18200.00,0.00,0.00,25.00,1325.00,'2022-08-25 14:01:59','',''),(3948,'1','277','1',1,'Retail Sale Id 3978',2999.36,0.00,0.00,4.12,218.36,'2022-08-25 14:10:12','',''),(3949,'1','277','1',1,'Retail Sale Id 3979',2497.04,0.00,0.00,3.43,181.79,'2022-08-25 14:10:57','',''),(3950,'1','277','1',1,'Retail Sale Id 3980',4397.12,0.00,0.00,6.04,320.12,'2022-08-25 14:12:31','',''),(3951,'1','277','1',1,'Retail Sale Id 3981',4397.12,0.00,0.00,6.04,320.12,'2022-08-25 14:32:45','',''),(3952,'1','277','1',1,'Retail Sale Id 3982',4397.12,0.00,0.00,6.04,320.12,'2022-08-25 14:39:15','',''),(3953,'1','277','1',1,'Retail Sale Id 3983',4397.12,0.00,0.00,6.04,320.12,'2022-08-25 14:55:29','',''),(3954,'1','277','1',1,'Retail Sale Id 3984',3698.24,0.00,0.00,5.08,269.24,'2022-08-25 14:56:57','',''),(3955,'1','277','1',1,'Retail Sale Id 3985',2198.56,0.00,0.00,3.02,160.06,'2022-08-25 15:20:46','',''),(3956,'1','277','1',1,'Retail Sale Id 3986',4397.12,0.00,0.00,6.04,320.12,'2022-08-25 15:28:21','',''),(3957,'1','277','1',1,'Retail Sale Id 3987',1499.68,0.00,0.00,2.06,109.18,'2022-08-25 15:29:32','',''),(3958,'1','277','1',1,'Retail Sale Id 3988',2198.56,0.00,0.00,3.02,160.06,'2022-08-25 15:33:26','',''),(3959,'1','277','1',1,'Retail Sale Id 3989',749.84,0.00,0.00,1.03,54.59,'2022-08-25 15:37:40','',''),(3960,'1','277','1',1,'Retail Sale Id 3990',2198.56,0.00,0.00,3.02,160.06,'2022-08-25 15:42:49','',''),(3961,'1','277','1',1,'Retail Sale Id 3991',9100.00,0.00,0.00,12.50,662.50,'2022-08-25 15:43:41','',''),(3962,'1','277','1',1,'Retail Sale Id 3992',4499.04,0.00,0.00,6.18,327.54,'2022-08-25 15:57:47','',''),(3963,'1','277','1',1,'Retail Sale Id 3993',997.36,0.00,0.00,1.37,72.61,'2022-08-25 16:11:17','',''),(3964,'1','277','1',1,'Retail Sale Id 3994',2184.00,0.00,0.00,3.00,159.00,'2022-08-25 16:22:55','',''),(3965,'1','277','1',1,'Retail Sale Id 3995',2198.56,0.00,0.00,3.02,160.06,'2022-08-25 16:27:59','',''),(3966,'1','277','1',1,'Retail Sale Id 3995',4397.12,0.00,0.00,6.04,320.12,'2022-08-25 16:27:59','',''),(3967,'1','277','1',1,'Retail Sale Id 3996',3640.00,0.00,0.00,5.00,265.00,'2022-08-25 16:31:25','',''),(3968,'1','277','1',1,'Retail Sale Id 3997',2002.00,0.00,0.00,2.75,145.75,'2022-08-25 16:39:29','',''),(3969,'1','277','1',1,'Retail Sale Id 3998',9100.00,0.00,0.00,12.50,662.50,'2022-08-25 16:44:16','',''),(3970,'1','277','1',1,'Retail Sale Id 3999',3996.72,0.00,0.00,5.49,290.97,'2022-08-25 16:47:24','',''),(3971,'1','277','1',1,'Retail Sale Id 4000',3698.24,0.00,0.00,5.08,269.24,'2022-08-25 16:53:54','',''),(3972,'1','277','1',1,'Retail Sale Id 4001',2999.36,0.00,0.00,4.12,218.36,'2022-08-25 16:55:07','',''),(3973,'1','277','1',1,'Retail Sale Id 4002',3698.24,0.00,0.00,5.08,269.24,'2022-08-25 17:05:41','',''),(3974,'1','277','1',1,'Retail Sale Id 4003',4397.12,0.00,0.00,6.04,320.12,'2022-08-25 17:07:38','',''),(3975,'1','277','1',1,'Retail Sale Id 4004',4397.12,0.00,0.00,6.04,320.12,'2022-08-25 17:13:17','',''),(3976,'1','277','1',1,'Retail Sale Id 4005',2198.56,0.00,0.00,3.02,160.06,'2022-08-25 17:21:24','',''),(3977,'1','277','1',1,'Retail Sale Id 4006',4397.12,0.00,0.00,6.04,320.12,'2022-08-25 17:25:21','',''),(3978,'1','277','1',1,'Retail Sale Id 4007',3647.28,0.00,0.00,5.01,265.53,'2022-08-25 17:33:48','',''),(3979,'1','277','1',1,'Retail Sale Id 4008',4397.12,0.00,0.00,6.04,320.12,'2022-08-25 17:35:02','',''),(3980,'1','277','1',1,'Retail Sale Id 4009',4397.12,0.00,0.00,6.04,320.12,'2022-08-25 17:36:41','',''),(3981,'1','277','1',1,'Retail Sale Id 4010',2002.00,0.00,0.00,2.75,145.75,'2022-08-25 17:43:26','',''),(3982,'1','277','1',1,'Retail Sale Id 4011',3647.28,0.00,0.00,5.01,265.53,'2022-08-25 17:45:18','',''),(3983,'1','277','1',1,'Retail Sale Id 4012',9100.00,0.00,0.00,12.50,662.50,'2022-08-25 17:49:27','',''),(3984,'1','277','1',1,'Retail Sale Id 4013',2002.00,0.00,0.00,2.75,145.75,'2022-08-25 17:52:13','',''),(3985,'1','277','1',1,'Retail Sale Id 4014',2198.56,0.00,0.00,3.02,160.06,'2022-08-25 17:55:23','',''),(3986,'1','277','1',1,'Retail Sale Id 4015',997.36,0.00,0.00,1.37,72.61,'2022-08-25 17:58:25','',''),(3987,'1','277','1',1,'Retail Sale Id 4016',2999.36,0.00,0.00,4.12,218.36,'2022-08-25 18:01:07','',''),(3988,'1','277','1',1,'Retail Sale Id 4017',800.80,0.00,0.00,1.10,58.30,'2022-08-25 18:04:51','',''),(3989,'1','277','1',1,'Retail Sale Id 4018',7301.84,0.00,0.00,10.03,531.59,'2022-08-25 18:07:10','',''),(3990,'1','277','1',1,'Retail Sale Id 4019',5001.36,0.00,0.00,6.87,364.11,'2022-08-25 18:08:54','',''),(3991,'1','277','1',1,'Retail Sale Id 4020',800.80,0.00,0.00,1.10,58.30,'2022-08-25 18:15:22','',''),(3992,'1','277','1',1,'Retail Sale Id 4021',16016.00,0.00,0.00,22.00,1166.00,'2022-08-25 18:17:33','',''),(3993,'1','277','1',1,'Retail Sale Id 4022',502.32,0.00,0.00,0.69,36.57,'2022-08-25 18:18:16','',''),(3994,'1','277','1',1,'Retail Sale Id 4023',502.32,0.00,0.00,0.69,36.57,'2022-08-25 18:21:55','',''),(3995,'1','277','1',1,'Retail Sale Id 4024',2002.00,0.00,0.00,2.75,145.75,'2022-08-25 18:26:06','',''),(3996,'1','277','1',1,'Retail Sale Id 4025',2402.40,0.00,0.00,3.30,174.90,'2022-08-25 18:30:42','',''),(3997,'1','277','1',1,'Retail Sale Id 4026',4397.12,0.00,0.00,6.04,320.12,'2022-08-25 18:35:22','',''),(3998,'1','277','1',1,'Retail Sale Id 4027',800.80,0.00,0.00,1.10,58.30,'2022-08-25 18:36:47','',''),(3999,'1','277','1',1,'Retail Sale Id 4028',1499.68,0.00,0.00,2.06,109.18,'2022-08-25 18:39:02','',''),(4000,'1','277','1',1,'Retail Sale Id 4029',1499.68,0.00,0.00,2.06,109.18,'2022-08-25 18:52:30','',''),(4001,'1','277','1',1,'Retail Sale Id 4030',997.36,0.00,0.00,1.37,72.61,'2022-08-25 19:19:32','',''),(4002,'1','277','1',1,'Retail Sale Id 4031',1499.68,0.00,0.00,2.06,109.18,'2022-08-25 19:22:41','',''),(4003,'1','277','1',1,'Return of Retail Sale Id 4030',0.00,997.36,1.37,0.00,-72.61,'2022-08-25 19:47:30','',''),(4004,'1','277','1',1,'Retail Sale Id 4032',960.96,0.00,0.00,1.32,69.96,'2022-08-25 19:48:35','',''),(4005,'1','277','1',1,'Retail Sale Id 4033',997.36,0.00,0.00,1.37,72.61,'2022-08-26 07:16:46','',''),(4006,'1','277','1',1,'Retail Sale Id 4034',3698.24,0.00,0.00,5.08,269.24,'2022-08-26 07:24:43','',''),(4007,'1','277','1',1,'Retail Sale Id 4035',2999.36,0.00,0.00,4.12,218.36,'2022-08-26 07:30:11','',''),(4008,'1','277','1',1,'Retail Sale Id 4036',2198.56,0.00,0.00,3.02,160.06,'2022-08-26 07:50:34','',''),(4009,'1','277','1',1,'Retail Sale Id 4037',1499.68,0.00,0.00,2.06,109.18,'2022-08-26 07:54:52','',''),(4010,'1','277','1',1,'Retail Sale Id 4038',4499.04,0.00,0.00,6.18,327.54,'2022-08-26 07:56:13','',''),(4011,'1','277','1',1,'Retail Sale Id 4039',800.80,0.00,0.00,1.10,58.30,'2022-08-26 08:22:49','',''),(4012,'1','277','1',1,'Retail Sale Id 4040',2198.56,0.00,0.00,3.02,160.06,'2022-08-26 08:26:15','',''),(4013,'1','277','1',1,'Retail Sale Id 4041',2999.36,0.00,0.00,4.12,218.36,'2022-08-26 08:27:04','',''),(4014,'1','277','1',1,'Retail Sale Id 4042',2198.56,0.00,0.00,3.02,160.06,'2022-08-26 08:34:02','',''),(4015,'1','277','1',1,'Retail Sale Id 4043',997.36,0.00,0.00,1.37,72.61,'2022-08-26 08:38:01','',''),(4016,'1','277','1',1,'Retail Sale Id 4044',8000.72,0.00,0.00,10.99,582.47,'2022-08-26 08:38:54','',''),(4017,'1','277','1',1,'Retail Sale Id 4045',2198.56,0.00,0.00,3.02,160.06,'2022-08-26 09:01:44','',''),(4018,'1','277','1',1,'Retail Sale Id 4046',997.36,0.00,0.00,1.37,72.61,'2022-08-26 09:05:01','',''),(4019,'1','277','1',1,'Retail Sale Id 4047',9100.00,0.00,0.00,12.50,662.50,'2022-08-26 09:06:32','',''),(4020,'1','277','1',1,'Retail Sale Id 4048',800.80,0.00,0.00,1.10,58.30,'2022-08-26 09:07:53','',''),(4021,'1','277','1',1,'Retail Sale Id 4049',2999.36,0.00,0.00,4.12,218.36,'2022-08-26 09:15:08','',''),(4022,'1','277','1',1,'Retail Sale Id 4050',800.80,0.00,0.00,1.10,58.30,'2022-08-26 09:15:46','',''),(4023,'1','277','1',1,'Retail Sale Id 4051',1499.68,0.00,0.00,2.06,109.18,'2022-08-26 09:21:25','',''),(4024,'1','277','1',1,'Retail Sale Id 4052',1499.68,0.00,0.00,2.06,109.18,'2022-08-26 09:31:10','',''),(4025,'1','277','1',1,'Retail Sale Id 4053',4397.12,0.00,0.00,6.04,320.12,'2022-08-26 09:33:36','',''),(4026,'1','277','1',1,'Retail Sale Id 4054',2999.36,0.00,0.00,4.12,218.36,'2022-08-26 09:37:47','',''),(4027,'1','277','1',1,'Retail Sale Id 4055',1499.68,0.00,0.00,2.06,109.18,'2022-08-26 09:39:54','',''),(4028,'1','277','1',1,'Retail Sale Id 4056',1499.68,0.00,0.00,2.06,109.18,'2022-08-26 09:48:12','',''),(4029,'1','277','1',1,'Retail Sale Id 4057',1499.68,0.00,0.00,2.06,109.18,'2022-08-26 09:51:58','',''),(4030,'1','277','1',1,'Retail Sale Id 4058',9100.00,0.00,0.00,12.50,662.50,'2022-08-26 09:53:47','',''),(4031,'1','277','1',1,'Retail Sale Id 4059',2002.00,0.00,0.00,2.75,145.75,'2022-08-26 09:55:44','',''),(4032,'1','277','1',1,'Retail Sale Id 4060',2198.56,0.00,0.00,3.02,160.06,'2022-08-26 10:00:30','',''),(4033,'1','277','1',1,'Retail Sale Id 4061',3996.72,0.00,0.00,5.49,290.97,'2022-08-26 10:01:52','',''),(4034,'1','277','1',1,'Retail Sale Id 4062',902.72,0.00,0.00,1.24,65.72,'2022-08-26 10:13:16','',''),(4035,'1','277','1',1,'Retail Sale Id 4063',997.36,0.00,0.00,1.37,72.61,'2022-08-26 10:14:02','',''),(4036,'1','277','1',1,'Retail Sale Id 4064',3640.00,0.00,0.00,5.00,265.00,'2022-08-26 10:17:51','',''),(4037,'1','277','1',1,'Retail Sale Id 4064',9100.00,0.00,0.00,12.50,662.50,'2022-08-26 10:17:51','',''),(4038,'1','277','1',1,'Retail Sale Id 4064',10920.00,0.00,0.00,15.00,795.00,'2022-08-26 10:17:51','',''),(4039,'1','277','1',1,'Retail Sale Id 4065',2999.36,0.00,0.00,4.12,218.36,'2022-08-26 10:19:32','',''),(4040,'1','277','1',1,'Retail Sale Id 4066',997.36,0.00,0.00,1.37,72.61,'2022-08-26 10:20:16','',''),(4041,'1','277','1',1,'Retail Sale Id 4067',997.36,0.00,0.00,1.37,72.61,'2022-08-26 10:29:41','',''),(4042,'1','277','1',1,'Retail Sale Id 4068',3996.72,0.00,0.00,5.49,290.97,'2022-08-26 10:32:35','',''),(4043,'1','277','1',1,'Retail Sale Id 4069',9100.00,0.00,0.00,12.50,662.50,'2022-08-26 10:38:28','',''),(4044,'1','277','1',1,'Retail Sale Id 4070',2497.04,0.00,0.00,3.43,181.79,'2022-08-26 10:39:32','',''),(4045,'1','277','1',1,'Retail Sale Id 4071',2184.00,0.00,0.00,3.00,159.00,'2022-08-26 10:44:43','',''),(4046,'1','277','1',1,'Retail Sale Id 4072',5001.36,0.00,0.00,6.87,364.11,'2022-08-26 10:48:53','',''),(4047,'1','277','1',1,'Retail Sale Id 4073',2198.56,0.00,0.00,3.02,160.06,'2022-08-26 10:53:34','',''),(4048,'1','277','1',1,'Retail Sale Id 4074',2002.00,0.00,0.00,2.75,145.75,'2022-08-26 11:35:02','',''),(4049,'1','277','1',1,'Retail Sale Id 4075',800.80,0.00,0.00,1.10,58.30,'2022-08-26 11:41:24','',''),(4050,'1','277','1',1,'Retail Sale Id 4076',7301.84,0.00,0.00,10.03,531.59,'2022-08-26 11:47:51','',''),(4051,'1','277','1',1,'Retail Sale Id 4077',3698.24,0.00,0.00,5.08,269.24,'2022-08-26 11:49:24','',''),(4052,'1','277','1',1,'Retail Sale Id 4078',2999.36,0.00,0.00,4.12,218.36,'2022-08-26 11:51:10','',''),(4053,'1','277','1',1,'Retail Sale Id 4079',4397.12,0.00,0.00,6.04,320.12,'2022-08-26 12:09:38','',''),(4054,'1','277','1',1,'Retail Sale Id 4080',9100.00,0.00,0.00,12.50,662.50,'2022-08-26 12:12:28','',''),(4055,'1','277','1',1,'Retail Sale Id 4081',4397.12,0.00,0.00,6.04,320.12,'2022-08-26 12:31:39','',''),(4056,'1','277','1',1,'Retail Sale Id 4082',2497.04,0.00,0.00,3.43,181.79,'2022-08-26 12:33:56','',''),(4057,'1','277','1',1,'Retail Sale Id 4083',2497.04,0.00,0.00,3.43,181.79,'2022-08-26 12:39:53','',''),(4058,'1','277','1',1,'Retail Sale Id 4084',1499.68,0.00,0.00,2.06,109.18,'2022-08-26 12:51:00','',''),(4059,'1','277','1',1,'Retail Sale Id 4085',2198.56,0.00,0.00,3.02,160.06,'2022-08-26 12:53:31','',''),(4060,'1','277','1',1,'Retail Sale Id 4086',6552.00,0.00,0.00,9.00,477.00,'2022-08-26 13:03:04','',''),(4061,'1','277','1',1,'Retail Sale Id 4087',2198.56,0.00,0.00,3.02,160.06,'2022-08-26 13:04:00','',''),(4062,'1','277','1',1,'Retail Sale Id 4088',2999.36,0.00,0.00,4.12,218.36,'2022-08-26 13:04:49','',''),(4063,'1','277','1',1,'Retail Sale Id 4089',2999.36,0.00,0.00,4.12,218.36,'2022-08-26 13:08:59','',''),(4064,'1','277','1',1,'Retail Sale Id 4090',2999.36,0.00,0.00,4.12,218.36,'2022-08-26 13:17:23','',''),(4065,'1','277','1',1,'Retail Sale Id 4091',2198.56,0.00,0.00,3.02,160.06,'2022-08-26 13:40:05','',''),(4066,'1','277','1',1,'Retail Sale Id 4092',3698.24,0.00,0.00,5.08,269.24,'2022-08-26 13:41:15','',''),(4067,'1','277','1',1,'Retail Sale Id 4093',4499.04,0.00,0.00,6.18,327.54,'2022-08-26 13:52:23','',''),(4068,'1','277','1',1,'Retail Sale Id 4094',596.96,0.00,0.00,0.82,43.46,'2022-08-26 13:59:42','',''),(4069,'1','277','1',1,'Retail Sale Id 4095',2002.00,0.00,0.00,2.75,145.75,'2022-08-26 14:05:24','',''),(4070,'1','277','1',1,'Retail Sale Id 4096',2198.56,0.00,0.00,3.02,160.06,'2022-08-26 14:16:26','',''),(4071,'1','277','1',1,'Retail Sale Id 4097',35500.00,0.00,0.00,50.00,1750.00,'2022-08-26 14:22:09','',''),(4072,'1','277','1',1,'Retail Sale Id 4098',2198.56,0.00,0.00,3.02,160.06,'2022-08-26 14:30:52','',''),(4073,'1','277','1',1,'Retail Sale Id 4099',2999.36,0.00,0.00,4.12,218.36,'2022-08-26 14:33:45','',''),(4074,'1','277','1',1,'Retail Sale Id 4100',2497.04,0.00,0.00,3.43,181.79,'2022-08-26 14:34:54','',''),(4075,'1','277','1',1,'Retail Sale Id 4101',902.72,0.00,0.00,1.24,65.72,'2022-08-26 14:41:15','',''),(4076,'1','277','1',1,'Retail Sale Id 4102',2497.04,0.00,0.00,3.43,181.79,'2022-08-26 14:52:51','',''),(4077,'1','277','1',1,'Retail Sale Id 4103',2002.00,0.00,0.00,2.75,145.75,'2022-08-26 15:06:10','',''),(4078,'1','277','1',1,'Retail Sale Id 4104',2198.56,0.00,0.00,3.02,160.06,'2022-08-26 15:07:05','',''),(4079,'1','277','1',1,'Retail Sale Id 4105',2999.36,0.00,0.00,4.12,218.36,'2022-08-26 15:07:52','',''),(4080,'1','277','1',1,'Retail Sale Id 4106',4397.12,0.00,0.00,6.04,320.12,'2022-08-26 15:14:21','',''),(4081,'1','277','1',1,'Retail Sale Id 4107',2897.44,0.00,0.00,3.98,210.94,'2022-08-26 15:22:17','',''),(4082,'1','277','1',1,'Retail Sale Id 4108',4397.12,0.00,0.00,6.04,320.12,'2022-08-26 15:33:08','',''),(4083,'1','277','1',1,'Retail Sale Id 4109',9100.00,0.00,0.00,12.50,662.50,'2022-08-26 15:35:21','',''),(4084,'1','277','1',1,'Retail Sale Id 4110',2198.56,0.00,0.00,3.02,160.06,'2022-08-26 15:36:58','',''),(4085,'1','277','1',1,'Retail Sale Id 4111',2198.56,0.00,0.00,3.02,160.06,'2022-08-26 15:48:34','',''),(4086,'1','277','1',1,'Retail Sale Id 4112',7301.84,0.00,0.00,10.03,531.59,'2022-08-26 16:00:35','',''),(4087,'1','277','1',1,'Retail Sale Id 4113',997.36,0.00,0.00,1.37,72.61,'2022-08-26 16:01:45','',''),(4088,'1','277','1',1,'Retail Sale Id 4114',2999.36,0.00,0.00,4.12,218.36,'2022-08-26 16:12:30','',''),(4089,'1','277','1',1,'Retail Sale Id 4115',698.88,0.00,0.00,0.96,50.88,'2022-08-26 16:14:06','',''),(4090,'1','277','1',1,'Return of Retail Sale Id 4115',0.00,698.88,0.96,0.00,-50.88,'2022-08-26 16:20:26','',''),(4091,'1','277','1',1,'Retail Sale Id 4116',800.80,0.00,0.00,1.10,58.30,'2022-08-26 16:20:56','',''),(4092,'1','277','1',1,'Retail Sale Id 4117',15620.00,0.00,0.00,22.00,770.00,'2022-08-26 16:27:51','',''),(4093,'1','277','1',1,'Retail Sale Id 4118',1499.68,0.00,0.00,2.06,109.18,'2022-08-26 16:30:00','',''),(4094,'1','277','1',1,'Retail Sale Id 4119',5001.36,0.00,0.00,6.87,364.11,'2022-08-26 16:39:24','',''),(4095,'1','277','1',1,'Retail Sale Id 4120',3996.72,0.00,0.00,5.49,290.97,'2022-08-26 16:51:16','',''),(4096,'1','277','1',1,'Retail Sale Id 4121',2999.36,0.00,0.00,4.12,218.36,'2022-08-26 17:01:55','',''),(4097,'1','277','1',1,'Retail Sale Id 4122',2002.00,0.00,0.00,2.75,145.75,'2022-08-26 17:02:33','',''),(4098,'1','277','1',1,'Retail Sale Id 4123',2002.00,0.00,0.00,2.75,145.75,'2022-08-26 17:12:21','',''),(4099,'1','277','1',1,'Retail Sale Id 4124',1499.68,0.00,0.00,2.06,109.18,'2022-08-26 17:13:13','',''),(4100,'1','277','1',1,'Retail Sale Id 4125',2198.56,0.00,0.00,3.02,160.06,'2022-08-26 17:13:53','',''),(4101,'1','277','1',1,'Retail Sale Id 4126',997.36,0.00,0.00,1.37,72.61,'2022-08-26 17:15:25','',''),(4102,'1','277','1',1,'Retail Sale Id 4127',2002.00,0.00,0.00,2.75,145.75,'2022-08-26 17:17:56','',''),(4103,'1','277','1',1,'Retail Sale Id 4128',5001.36,0.00,0.00,6.87,364.11,'2022-08-26 17:22:27','',''),(4104,'1','277','1',1,'Retail Sale Id 4129',997.36,0.00,0.00,1.37,72.61,'2022-08-26 17:24:30','',''),(4105,'1','277','1',1,'Retail Sale Id 4130',4499.04,0.00,0.00,6.18,327.54,'2022-08-26 17:25:43','',''),(4106,'1','277','1',1,'Retail Sale Id 4131',1499.68,0.00,0.00,2.06,109.18,'2022-08-26 17:26:26','',''),(4107,'1','277','1',1,'Retail Sale Id 4132',9100.00,0.00,0.00,12.50,662.50,'2022-08-26 17:34:05','',''),(4108,'1','277','1',1,'Retail Sale Id 4133',2999.36,0.00,0.00,4.12,218.36,'2022-08-26 17:37:01','',''),(4109,'1','277','1',1,'Retail Sale Id 4134',997.36,0.00,0.00,1.37,72.61,'2022-08-26 17:41:12','',''),(4110,'1','277','1',1,'Retail Sale Id 4135',1499.68,0.00,0.00,2.06,109.18,'2022-08-26 17:44:14','',''),(4111,'1','277','1',1,'Retail Sale Id 4136',1499.68,0.00,0.00,2.06,109.18,'2022-08-26 17:45:06','',''),(4112,'1','277','1',1,'Retail Sale Id 4137',2002.00,0.00,0.00,2.75,145.75,'2022-08-26 17:52:57','',''),(4113,'1','277','1',1,'Retail Sale Id 4138',2198.56,0.00,0.00,3.02,160.06,'2022-08-26 17:54:28','',''),(4114,'1','277','1',1,'Retail Sale Id 4139',4499.04,0.00,0.00,6.18,327.54,'2022-08-26 17:59:57','',''),(4115,'1','277','1',1,'Retail Sale Id 4140',997.36,0.00,0.00,1.37,72.61,'2022-08-26 18:19:02','',''),(4116,'1','277','1',1,'Retail Sale Id 4141',3640.00,0.00,0.00,5.00,265.00,'2022-08-26 18:20:20','',''),(4117,'1','277','1',1,'Retail Sale Id 4142',502.32,0.00,0.00,0.69,36.57,'2022-08-26 18:23:40','',''),(4118,'1','277','1',1,'Retail Sale Id 4144',4368.00,0.00,0.00,6.00,318.00,'2022-08-26 18:24:50','',''),(4119,'1','277','1',1,'Retail Sale Id 4145',1499.68,0.00,0.00,2.06,109.18,'2022-08-26 18:25:46','',''),(4120,'1','277','1',1,'Retail Sale Id 4146',9100.00,0.00,0.00,12.50,662.50,'2022-08-26 18:26:58','',''),(4121,'1','277','1',1,'Retail Sale Id 4147',3996.72,0.00,0.00,5.49,290.97,'2022-08-26 18:27:49','',''),(4122,'1','277','1',1,'Retail Sale Id 4148',749.84,0.00,0.00,1.03,54.59,'2022-08-26 18:44:03','',''),(4123,'1','277','1',1,'Retail Sale Id 4149',2802.80,0.00,0.00,3.85,204.05,'2022-08-26 18:49:41','',''),(4124,'1','277','1',1,'Retail Sale Id 4150',9100.00,0.00,0.00,12.50,662.50,'2022-08-26 18:54:20','',''),(4125,'1','277','1',1,'Retail Sale Id 4151',728.00,0.00,0.00,1.00,53.00,'2022-08-26 18:56:06','',''),(4126,'1','277','1',1,'Retail Sale Id 4152',9100.00,0.00,0.00,12.50,662.50,'2022-08-26 18:59:10','',''),(4127,'1','277','1',1,'Retail Sale Id 4153',749.84,0.00,0.00,1.03,54.59,'2022-08-26 19:00:21','',''),(4128,'1','277','1',1,'Retail Sale Id 4154',9100.00,0.00,0.00,12.50,662.50,'2022-08-26 19:02:02','',''),(4129,'1','277','1',1,'Retail Sale Id 4155',2999.36,0.00,0.00,4.12,218.36,'2022-08-26 19:12:56','',''),(4130,'1','277','1',1,'Retail Sale Id 4156',2198.56,0.00,0.00,3.02,160.06,'2022-08-26 19:15:48','',''),(4131,'1','277','1',1,'Return of Retail Sale Id 4153',0.00,749.84,1.03,0.00,-54.59,'2022-08-26 19:51:36','',''),(4132,'1','277','1',1,'Retail Sale Id 4157',742.56,0.00,0.00,1.02,54.06,'2022-08-26 19:52:12','',''),(4133,'1','277','1',1,'Retail Sale Id 4158',2999.36,0.00,0.00,4.12,218.36,'2022-08-27 06:59:25','',''),(4134,'1','277','1',1,'Retail Sale Id 4159',2999.36,0.00,0.00,4.12,218.36,'2022-08-27 07:03:08','',''),(4135,'1','277','1',1,'Retail Sale Id 4160',4397.12,0.00,0.00,6.04,320.12,'2022-08-27 07:05:00','',''),(4136,'1','277','1',1,'Retail Sale Id 4161',5001.36,0.00,0.00,6.87,364.11,'2022-08-27 07:07:50','',''),(4137,'1','277','1',1,'Retail Sale Id 4162',2002.00,0.00,0.00,2.75,145.75,'2022-08-27 07:08:33','',''),(4138,'1','277','1',1,'Retail Sale Id 4163',997.36,0.00,0.00,1.37,72.61,'2022-08-27 07:20:50','',''),(4139,'1','277','1',1,'Retail Sale Id 4164',997.36,0.00,0.00,1.37,72.61,'2022-08-27 07:25:25','',''),(4140,'1','277','1',1,'Retail Sale Id 4165',997.36,0.00,0.00,1.37,72.61,'2022-08-27 07:35:52','',''),(4141,'1','277','1',1,'Retail Sale Id 4166',2198.56,0.00,0.00,3.02,160.06,'2022-08-27 07:43:28','',''),(4142,'1','277','1',1,'Retail Sale Id 4167',9100.00,0.00,0.00,12.50,662.50,'2022-08-27 07:49:22','',''),(4143,'1','277','1',1,'Retail Sale Id 4168',997.36,0.00,0.00,1.37,72.61,'2022-08-27 07:49:59','',''),(4144,'1','277','1',1,'Retail Sale Id 4169',9100.00,0.00,0.00,12.50,662.50,'2022-08-27 07:50:38','',''),(4145,'1','277','1',1,'Retail Sale Id 4170',3996.72,0.00,0.00,5.49,290.97,'2022-08-27 07:52:40','',''),(4146,'1','277','1',1,'Retail Sale Id 4171',2184.00,0.00,0.00,3.00,159.00,'2022-08-27 07:54:43','',''),(4147,'1','277','1',1,'Retail Sale Id 4172',1499.68,0.00,0.00,2.06,109.18,'2022-08-27 07:55:26','',''),(4148,'1','277','1',1,'Retail Sale Id 4173',2198.56,0.00,0.00,3.02,160.06,'2022-08-27 07:58:16','',''),(4149,'1','277','1',1,'Retail Sale Id 4174',2497.04,0.00,0.00,3.43,181.79,'2022-08-27 07:59:34','',''),(4150,'1','277','1',1,'Retail Sale Id 4175',4397.12,0.00,0.00,6.04,320.12,'2022-08-27 08:00:32','',''),(4151,'1','277','1',1,'Retail Sale Id 4176',2497.04,0.00,0.00,3.43,181.79,'2022-08-27 08:01:24','',''),(4152,'1','277','1',1,'Retail Sale Id 4177',3996.72,0.00,0.00,5.49,290.97,'2022-08-27 08:02:44','',''),(4153,'1','277','1',1,'Retail Sale Id 4178',9100.00,0.00,0.00,12.50,662.50,'2022-08-27 08:04:40','',''),(4154,'1','277','1',1,'Retail Sale Id 4179',1499.68,0.00,0.00,2.06,109.18,'2022-08-27 08:08:48','',''),(4155,'1','277','1',1,'Retail Sale Id 4180',800.80,0.00,0.00,1.10,58.30,'2022-08-27 08:09:43','',''),(4156,'1','277','1',1,'Retail Sale Id 4181',1499.68,0.00,0.00,2.06,109.18,'2022-08-27 08:10:28','',''),(4157,'1','277','1',1,'Retail Sale Id 4182',2002.00,0.00,0.00,2.75,145.75,'2022-08-27 08:11:34','',''),(4158,'1','277','1',1,'Retail Sale Id 4183',2999.36,0.00,0.00,4.12,218.36,'2022-08-27 08:12:20','',''),(4159,'1','277','1',1,'Retail Sale Id 4184',7003.36,0.00,0.00,9.62,509.86,'2022-08-27 08:13:02','',''),(4160,'1','277','1',1,'Retail Sale Id 4185',9100.00,0.00,0.00,12.50,662.50,'2022-08-27 08:15:51','',''),(4161,'1','277','1',1,'Retail Sale Id 4186',3647.28,0.00,0.00,5.01,265.53,'2022-08-27 08:18:52','',''),(4162,'1','277','1',1,'Retail Sale Id 4187',2999.36,0.00,0.00,4.12,218.36,'2022-08-27 08:28:59','',''),(4163,'1','277','1',1,'Retail Sale Id 4188',1499.68,0.00,0.00,2.06,109.18,'2022-08-27 08:29:55','',''),(4164,'1','277','1',1,'Retail Sale Id 4189',5001.36,0.00,0.00,6.87,364.11,'2022-08-27 08:33:48','',''),(4165,'1','277','1',1,'Retail Sale Id 4190',997.36,0.00,0.00,1.37,72.61,'2022-08-27 08:39:53','',''),(4166,'1','277','1',1,'Retail Sale Id 4191',4368.00,0.00,0.00,6.00,318.00,'2022-08-27 08:45:17','',''),(4167,'1','277','1',1,'Retail Sale Id 4192',4397.12,0.00,0.00,6.04,320.12,'2022-08-27 08:47:00','',''),(4168,'1','277','1',1,'Retail Sale Id 4193',2002.00,0.00,0.00,2.75,145.75,'2022-08-27 08:55:04','',''),(4169,'1','277','1',1,'Retail Sale Id 4194',1499.68,0.00,0.00,2.06,109.18,'2022-08-27 08:55:58','',''),(4170,'1','277','1',1,'Retail Sale Id 4195',997.36,0.00,0.00,1.37,72.61,'2022-08-27 09:01:35','',''),(4171,'1','277','1',1,'Retail Sale Id 4196',9100.00,0.00,0.00,12.50,662.50,'2022-08-27 09:07:23','',''),(4172,'1','277','1',1,'Retail Sale Id 4197',7301.84,0.00,0.00,10.03,531.59,'2022-08-27 09:12:51','',''),(4173,'1','277','1',1,'Retail Sale Id 4198',1499.68,0.00,0.00,2.06,109.18,'2022-08-27 09:13:24','',''),(4174,'1','277','1',1,'Retail Sale Id 4199',2002.00,0.00,0.00,2.75,145.75,'2022-08-27 09:18:05','',''),(4175,'1','277','1',1,'Retail Sale Id 4200',2198.56,0.00,0.00,3.02,160.06,'2022-08-27 09:19:49','',''),(4176,'1','277','1',1,'Retail Sale Id 4201',997.36,0.00,0.00,1.37,72.61,'2022-08-27 09:20:42','',''),(4177,'1','277','1',1,'Retail Sale Id 4202',2198.56,0.00,0.00,3.02,160.06,'2022-08-27 09:24:21','',''),(4178,'1','277','1',1,'Retail Sale Id 4203',2919.28,0.00,0.00,4.01,212.53,'2022-08-27 09:33:31','',''),(4179,'1','277','1',1,'Retail Sale Id 4204',1499.68,0.00,0.00,2.06,109.18,'2022-08-27 09:40:56','',''),(4180,'1','277','1',1,'Return of Retail Sale Id 4201',0.00,997.36,1.37,0.00,-72.61,'2022-08-27 09:41:48','',''),(4181,'1','277','1',1,'Retail Sale Id 4205',2249.52,0.00,0.00,3.09,163.77,'2022-08-27 09:44:28','',''),(4182,'1','277','1',1,'Retail Sale Id 4206',116.48,0.00,0.00,0.16,8.48,'2022-08-27 10:02:44','',''),(4183,'1','277',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,2038.50,3.02,0.00,0.00,'2022-08-27 10:16:23','',''),(4184,'1','277',NULL,1,'Reception corrector for bridging 14',0.00,0.00,0.00,3.02,0.00,'2022-08-27 10:17:48','',''),(4185,'1','277','1',1,'Received from bridging 14',0.00,0.00,3.02,0.00,0.00,'2022-08-27 10:17:48','',''),(4186,'1','277','1',1,'Retail Sale Id 4207',2198.56,0.00,0.00,3.02,160.06,'2022-08-27 10:18:30','',''),(4187,'1','277',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,675.00,1.00,0.00,0.00,'2022-08-27 11:03:42','',''),(4188,'1','277',NULL,1,'Reception corrector for bridging 15',0.00,0.00,0.00,1.00,0.00,'2022-08-27 11:04:55','',''),(4189,'1','277','1',1,'Received from bridging 15',0.00,0.00,1.00,0.00,0.00,'2022-08-27 11:04:55','',''),(4190,'1','277','1',1,'Retail Sale Id 4208',684.32,0.00,0.00,0.94,49.82,'2022-08-27 11:05:35','',''),(4191,'1','277',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,1350000.00,2000.00,0.00,0.00,'2022-08-28 11:28:18','',''),(4192,'1','277',NULL,1,'Reception corrector for bridging 16',0.00,0.00,0.00,2000.00,0.00,'2022-08-28 11:30:28','',''),(4193,'1','277','1',1,'Received from bridging 16',0.00,0.00,2000.00,0.00,0.00,'2022-08-28 11:30:28','',''),(4194,'1','277','1',1,'Retail Sale Id 4209',1150.24,0.00,0.00,1.58,83.74,'2022-08-28 11:39:43','',''),(4195,'1','277','1',1,'Retail Sale Id 4210',2198.56,0.00,0.00,3.02,160.06,'2022-08-28 11:41:35','',''),(4196,'1','277','1',1,'Retail Sale Id 4211',1499.68,0.00,0.00,2.06,109.18,'2022-08-28 11:44:04','',''),(4197,'1','277','1',1,'Retail Sale Id 4212',2999.36,0.00,0.00,4.12,218.36,'2022-08-28 11:44:51','',''),(4198,'1','277','1',1,'Retail Sale Id 4213',4397.12,0.00,0.00,6.04,320.12,'2022-08-28 11:47:46','',''),(4199,'1','277','1',1,'Retail Sale Id 4214',3647.28,0.00,0.00,5.01,265.53,'2022-08-28 11:51:51','',''),(4200,'1','277','1',1,'Retail Sale Id 4215',9100.00,0.00,0.00,12.50,662.50,'2022-08-28 11:58:23','',''),(4201,'1','277','1',1,'Retail Sale Id 4216',2198.56,0.00,0.00,3.02,160.06,'2022-08-28 11:59:30','',''),(4202,'1','277','1',1,'Retail Sale Id 4217',800.80,0.00,0.00,1.10,58.30,'2022-08-28 12:17:35','',''),(4203,'1','277','1',1,'Retail Sale Id 4218',9100.00,0.00,0.00,12.50,662.50,'2022-08-28 12:22:48','',''),(4204,'1','277','1',1,'Retail Sale Id 4219',2184.00,0.00,0.00,3.00,159.00,'2022-08-28 12:25:20','',''),(4205,'1','277','1',1,'Retail Sale Id 4220',2897.44,0.00,0.00,3.98,210.94,'2022-08-28 12:26:21','',''),(4206,'1','277','1',1,'Retail Sale Id 4221',2198.56,0.00,0.00,3.02,160.06,'2022-08-28 12:27:16','',''),(4207,'1','277','1',1,'Retail Sale Id 4222',2999.36,0.00,0.00,4.12,218.36,'2022-08-28 12:28:02','',''),(4208,'1','277','1',1,'Retail Sale Id 4223',997.36,0.00,0.00,1.37,72.61,'2022-08-28 12:28:37','',''),(4209,'1','277','1',1,'Retail Sale Id 4224',997.36,0.00,0.00,1.37,72.61,'2022-08-28 12:29:13','',''),(4210,'1','277','1',1,'Retail Sale Id 4225',2002.00,0.00,0.00,2.75,145.75,'2022-08-28 12:32:22','',''),(4211,'1','277','1',1,'Retail Sale Id 4226',1499.68,0.00,0.00,2.06,109.18,'2022-08-28 12:36:47','',''),(4212,'1','277','1',1,'Retail Sale Id 4227',2002.00,0.00,0.00,2.75,145.75,'2022-08-28 12:38:50','',''),(4213,'1','277','1',1,'Retail Sale Id 4228',2002.00,0.00,0.00,2.75,145.75,'2022-08-28 12:39:36','',''),(4214,'1','277','1',1,'Retail Sale Id 4229',997.36,0.00,0.00,1.37,72.61,'2022-08-28 12:40:26','',''),(4215,'1','277','1',1,'Retail Sale Id 4230',4397.12,0.00,0.00,6.04,320.12,'2022-08-28 12:41:33','',''),(4216,'1','277','1',1,'Retail Sale Id 4231',2999.36,0.00,0.00,4.12,218.36,'2022-08-28 12:43:21','',''),(4217,'1','277','1',1,'Retail Sale Id 4232',3698.24,0.00,0.00,5.08,269.24,'2022-08-28 12:50:04','',''),(4218,'1','277','1',1,'Retail Sale Id 4233',1499.68,0.00,0.00,2.06,109.18,'2022-08-28 12:55:08','',''),(4219,'1','277','1',1,'Retail Sale Id 4234',800.80,0.00,0.00,1.10,58.30,'2022-08-28 13:01:06','',''),(4220,'1','277','1',1,'Retail Sale Id 4235',2002.00,0.00,0.00,2.75,145.75,'2022-08-28 13:06:05','',''),(4221,'1','277','1',1,'Retail Sale Id 4236',4397.12,0.00,0.00,6.04,320.12,'2022-08-28 13:09:16','',''),(4222,'1','277','1',1,'Retail Sale Id 4238',3800.16,0.00,0.00,5.22,276.66,'2022-08-28 13:14:51','',''),(4223,'1','277','1',1,'Retail Sale Id 4239',2999.36,0.00,0.00,4.12,218.36,'2022-08-28 13:18:12','',''),(4224,'1','277','1',1,'Retail Sale Id 4240',3501.68,0.00,0.00,4.81,254.93,'2022-08-28 13:19:48','',''),(4225,'1','277','1',1,'Retail Sale Id 4241',2999.36,0.00,0.00,4.12,218.36,'2022-08-28 13:20:35','',''),(4226,'1','277','1',1,'Retail Sale Id 4242',997.36,0.00,0.00,1.37,72.61,'2022-08-28 13:25:46','',''),(4227,'1','277','1',1,'Retail Sale Id 4243',2999.36,0.00,0.00,4.12,218.36,'2022-08-28 13:26:36','',''),(4228,'1','277','1',1,'Retail Sale Id 4244',3996.72,0.00,0.00,5.49,290.97,'2022-08-28 13:29:10','',''),(4229,'1','277','1',1,'Retail Sale Id 4245',4302.48,0.00,0.00,5.91,313.23,'2022-08-28 13:31:23','',''),(4230,'1','277','1',1,'Retail Sale Id 4246',4397.12,0.00,0.00,6.04,320.12,'2022-08-28 13:32:28','',''),(4231,'1','277','1',1,'Retail Sale Id 4247',2497.04,0.00,0.00,3.43,181.79,'2022-08-28 13:34:27','',''),(4232,'1','277','1',1,'Retail Sale Id 4248',2497.04,0.00,0.00,3.43,181.79,'2022-08-28 13:35:42','',''),(4233,'1','277','1',1,'Retail Sale Id 4249',2002.00,0.00,0.00,2.75,145.75,'2022-08-28 13:37:19','',''),(4234,'1','277','1',1,'Retail Sale Id 4250',2002.00,0.00,0.00,2.75,145.75,'2022-08-28 13:39:05','',''),(4235,'1','277','1',1,'Retail Sale Id 4251',997.36,0.00,0.00,1.37,72.61,'2022-08-28 13:41:04','',''),(4236,'1','277','1',1,'Retail Sale Id 4252',2999.36,0.00,0.00,4.12,218.36,'2022-08-28 13:45:42','',''),(4237,'1','277','1',1,'Retail Sale Id 4253',4397.12,0.00,0.00,6.04,320.12,'2022-08-28 13:53:36','',''),(4238,'1','277','1',1,'Retail Sale Id 4254',2300.48,0.00,0.00,3.16,167.48,'2022-08-28 13:59:51','',''),(4239,'1','277','1',1,'Retail Sale Id 4255',997.36,0.00,0.00,1.37,72.61,'2022-08-28 14:01:30','',''),(4240,'1','277','1',1,'Retail Sale Id 4256',3698.24,0.00,0.00,5.08,269.24,'2022-08-28 14:02:21','',''),(4241,'1','277','1',1,'Retail Sale Id 4257',9100.00,0.00,0.00,12.50,662.50,'2022-08-28 14:03:58','',''),(4242,'1','277','1',1,'Retail Sale Id 4258',4397.12,0.00,0.00,6.04,320.12,'2022-08-28 14:12:04','',''),(4243,'1','277','1',1,'Retail Sale Id 4259',3698.24,0.00,0.00,5.08,269.24,'2022-08-28 14:15:23','',''),(4244,'1','277','1',1,'Retail Sale Id 4260',2497.04,0.00,0.00,3.43,181.79,'2022-08-28 14:16:48','',''),(4245,'1','277','1',1,'Retail Sale Id 4261',2002.00,0.00,0.00,2.75,145.75,'2022-08-28 14:17:29','',''),(4246,'1','277','1',1,'Retail Sale Id 4262',2198.56,0.00,0.00,3.02,160.06,'2022-08-28 14:18:18','',''),(4247,'1','277','1',1,'Retail Sale Id 4263',800.80,0.00,0.00,1.10,58.30,'2022-08-28 14:19:05','',''),(4248,'1','277','1',1,'Retail Sale Id 4264',2999.36,0.00,0.00,4.12,218.36,'2022-08-28 14:21:17','',''),(4249,'1','277','1',1,'Retail Sale Id 4265',2999.36,0.00,0.00,4.12,218.36,'2022-08-28 14:23:42','',''),(4250,'1','277','1',1,'Retail Sale Id 4266',2198.56,0.00,0.00,3.02,160.06,'2022-08-28 14:24:21','',''),(4251,'1','277','1',1,'Retail Sale Id 4267',6501.04,0.00,0.00,8.93,473.29,'2022-08-28 14:30:25','',''),(4252,'1','277','1',1,'Retail Sale Id 4268',2497.04,0.00,0.00,3.43,181.79,'2022-08-28 14:31:13','',''),(4253,'1','277','1',1,'Retail Sale Id 4269',1499.68,0.00,0.00,2.06,109.18,'2022-08-28 14:32:49','',''),(4254,'1','277','1',1,'Retail Sale Id 4270',4302.48,0.00,0.00,5.91,313.23,'2022-08-28 14:34:40','',''),(4255,'1','277','1',1,'Retail Sale Id 4271',2999.36,0.00,0.00,4.12,218.36,'2022-08-28 14:35:31','',''),(4256,'1','277','1',1,'Retail Sale Id 4272',2198.56,0.00,0.00,3.02,160.06,'2022-08-28 14:42:46','',''),(4257,'1','277','1',1,'Retail Sale Id 4273',3698.24,0.00,0.00,5.08,269.24,'2022-08-28 14:46:09','',''),(4258,'1','277','1',1,'Retail Sale Id 4274',800.80,0.00,0.00,1.10,58.30,'2022-08-28 14:47:01','',''),(4259,'1','277','1',1,'Retail Sale Id 4275',2802.80,0.00,0.00,3.85,204.05,'2022-08-28 14:47:55','',''),(4260,'1','277','1',1,'Retail Sale Id 4276',2198.56,0.00,0.00,3.02,160.06,'2022-08-28 14:48:36','',''),(4261,'1','277','1',1,'Retail Sale Id 4277',2002.00,0.00,0.00,2.75,145.75,'2022-08-28 14:50:59','',''),(4262,'1','277','1',1,'Retail Sale Id 4278',2999.36,0.00,0.00,4.12,218.36,'2022-08-28 14:52:05','',''),(4263,'1','277','1',1,'Retail Sale Id 4280',1201.20,0.00,0.00,1.65,87.45,'2022-08-28 14:53:31','',''),(4264,'1','277','1',1,'Retail Sale Id 4281',502.32,0.00,0.00,0.69,36.57,'2022-08-28 14:54:17','',''),(4265,'1','277','1',1,'Retail Sale Id 4282',5496.40,0.00,0.00,7.55,400.15,'2022-08-28 14:58:29','',''),(4266,'1','277','1',1,'Retail Sale Id 4283',800.80,0.00,0.00,1.10,58.30,'2022-08-28 14:59:38','',''),(4267,'1','277','1',1,'Retail Sale Id 4284',2002.00,0.00,0.00,2.75,145.75,'2022-08-28 15:00:32','',''),(4268,'1','277','1',1,'Retail Sale Id 4285',3501.68,0.00,0.00,4.81,254.93,'2022-08-28 15:05:29','',''),(4269,'1','277','1',1,'Retail Sale Id 4286',1499.68,0.00,0.00,2.06,109.18,'2022-08-28 15:06:02','',''),(4270,'1','277','1',1,'Retail Sale Id 4287',1499.68,0.00,0.00,2.06,109.18,'2022-08-28 15:11:11','',''),(4271,'1','277','1',1,'Retail Sale Id 4288',18200.00,0.00,0.00,25.00,1325.00,'2022-08-28 15:13:00','',''),(4272,'1','277','1',1,'Retail Sale Id 4289',3996.72,0.00,0.00,5.49,290.97,'2022-08-28 15:20:03','',''),(4273,'1','277','1',1,'Retail Sale Id 4290',997.36,0.00,0.00,1.37,72.61,'2022-08-28 15:20:55','',''),(4274,'1','277','1',1,'Retail Sale Id 4291',2002.00,0.00,0.00,2.75,145.75,'2022-08-28 15:21:37','',''),(4275,'1','277','1',1,'Retail Sale Id 4292',2912.00,0.00,0.00,4.00,212.00,'2022-08-28 15:24:19','',''),(4276,'1','277','1',1,'Retail Sale Id 4293',2999.36,0.00,0.00,4.12,218.36,'2022-08-28 15:25:41','',''),(4277,'1','277','1',1,'Retail Sale Id 4294',2999.36,0.00,0.00,4.12,218.36,'2022-08-28 15:28:13','',''),(4278,'1','277','1',1,'Retail Sale Id 4295',7280.00,0.00,0.00,10.00,530.00,'2022-08-28 15:30:53','',''),(4279,'1','277','1',1,'Retail Sale Id 4296',3501.68,0.00,0.00,4.81,254.93,'2022-08-28 15:45:35','',''),(4280,'1','277','1',1,'Retail Sale Id 4297',1499.68,0.00,0.00,2.06,109.18,'2022-08-28 15:50:59','',''),(4281,'1','277','1',1,'Retail Sale Id 4298',698.88,0.00,0.00,0.96,50.88,'2022-08-28 15:51:46','',''),(4282,'1','277','1',1,'Retail Sale Id 4299',3996.72,0.00,0.00,5.49,290.97,'2022-08-28 15:52:49','',''),(4283,'1','277','1',1,'Retail Sale Id 4300',1499.68,0.00,0.00,2.06,109.18,'2022-08-28 15:54:24','',''),(4284,'1','277','1',1,'Retail Sale Id 4301',2999.36,0.00,0.00,4.12,218.36,'2022-08-28 15:56:03','',''),(4285,'1','277','1',1,'Retail Sale Id 4302',2802.80,0.00,0.00,3.85,204.05,'2022-08-28 15:56:58','',''),(4286,'1','277','1',1,'Retail Sale Id 4303',13497.12,0.00,0.00,18.54,982.62,'2022-08-28 15:58:40','',''),(4287,'1','277','1',1,'Retail Sale Id 4304',4368.00,0.00,0.00,6.00,318.00,'2022-08-28 16:00:44','',''),(4288,'1','277','1',1,'Retail Sale Id 4305',7280.00,0.00,0.00,10.00,530.00,'2022-08-28 16:03:05','',''),(4289,'1','277','1',1,'Retail Sale Id 4306',3698.24,0.00,0.00,5.08,269.24,'2022-08-28 16:05:09','',''),(4290,'1','277','1',1,'Retail Sale Id 4307',2999.36,0.00,0.00,4.12,218.36,'2022-08-28 16:05:46','',''),(4291,'1','277','1',1,'Retail Sale Id 4308',2497.04,0.00,0.00,3.43,181.79,'2022-08-28 16:09:10','',''),(4292,'1','277','1',1,'Retail Sale Id 4309',4368.00,0.00,0.00,6.00,318.00,'2022-08-28 16:36:23','',''),(4293,'1','277','1',1,'Retail Sale Id 4310',9100.00,0.00,0.00,12.50,662.50,'2022-08-28 16:37:13','',''),(4294,'1','277','1',1,'Retail Sale Id 4311',2497.04,0.00,0.00,3.43,181.79,'2022-08-28 16:37:59','',''),(4295,'1','277','1',1,'Retail Sale Id 4312',5802.16,0.00,0.00,7.97,422.41,'2022-08-28 16:45:51','',''),(4296,'1','277','1',1,'Retail Sale Id 4313',14101.36,0.00,0.00,19.37,1026.61,'2022-08-28 16:46:54','',''),(4297,'1','277','1',1,'Retail Sale Id 4314',997.36,0.00,0.00,1.37,72.61,'2022-08-28 16:49:31','',''),(4298,'1','277','1',1,'Retail Sale Id 4316',4397.12,0.00,0.00,6.04,320.12,'2022-08-28 16:52:19','',''),(4299,'1','277','1',1,'Retail Sale Id 4317',2198.56,0.00,0.00,3.02,160.06,'2022-08-28 16:53:13','',''),(4300,'1','277','1',1,'Retail Sale Id 4318',8051.68,0.00,0.00,11.06,586.18,'2022-08-28 16:54:11','',''),(4301,'1','277','1',1,'Retail Sale Id 4319',2999.36,0.00,0.00,4.12,218.36,'2022-08-28 16:56:20','',''),(4302,'1','277','1',1,'Retail Sale Id 4320',1499.68,0.00,0.00,2.06,109.18,'2022-08-28 16:57:12','',''),(4303,'1','277','1',1,'Retail Sale Id 4321',9100.00,0.00,0.00,12.50,662.50,'2022-08-28 16:58:52','',''),(4304,'1','277','1',1,'Retail Sale Id 4322',5001.36,0.00,0.00,6.87,364.11,'2022-08-28 17:01:30','',''),(4305,'1','277','1',1,'Retail Sale Id 4323',9100.00,0.00,0.00,12.50,662.50,'2022-08-28 17:02:12','',''),(4306,'1','277','1',1,'Retail Sale Id 4324',2198.56,0.00,0.00,3.02,160.06,'2022-08-28 17:08:59','',''),(4307,'1','277','1',1,'Retail Sale Id 4325',2002.00,0.00,0.00,2.75,145.75,'2022-08-28 17:10:39','',''),(4308,'1','277','1',1,'Retail Sale Id 4327',1463.28,0.00,0.00,2.01,106.53,'2022-08-28 17:11:57','',''),(4309,'1','277','1',1,'Retail Sale Id 4328',2002.00,0.00,0.00,2.75,145.75,'2022-08-28 17:12:39','',''),(4310,'1','277','1',1,'Retail Sale Id 4329',2999.36,0.00,0.00,4.12,218.36,'2022-08-28 17:13:22','',''),(4311,'1','277','1',1,'Retail Sale Id 4330',2198.56,0.00,0.00,3.02,160.06,'2022-08-28 17:15:01','',''),(4312,'1','277','1',1,'Retail Sale Id 4331',2300.48,0.00,0.00,3.16,167.48,'2022-08-28 17:17:20','',''),(4313,'1','277','1',1,'Retail Sale Id 4332',2198.56,0.00,0.00,3.02,160.06,'2022-08-28 17:18:21','',''),(4314,'1','277','1',1,'Retail Sale Id 4333',3996.72,0.00,0.00,5.49,290.97,'2022-08-28 17:19:28','',''),(4315,'1','277','1',1,'Retail Sale Id 4334',997.36,0.00,0.00,1.37,72.61,'2022-08-28 17:20:05','',''),(4316,'1','277','1',1,'Retail Sale Id 4335',3749.20,0.00,0.00,5.15,272.95,'2022-08-28 17:23:04','',''),(4317,'1','277','1',1,'Retail Sale Id 4336',3603.60,0.00,0.00,4.95,262.35,'2022-08-28 17:24:32','',''),(4318,'1','277','1',1,'Retail Sale Id 4337',3800.16,0.00,0.00,5.22,276.66,'2022-08-28 17:26:19','',''),(4319,'1','277','1',1,'Retail Sale Id 4338',1499.68,0.00,0.00,2.06,109.18,'2022-08-28 17:27:17','',''),(4320,'1','277','1',1,'Retail Sale Id 4339',1499.68,0.00,0.00,2.06,109.18,'2022-08-28 17:28:17','',''),(4321,'1','277','1',1,'Retail Sale Id 4340',2198.56,0.00,0.00,3.02,160.06,'2022-08-28 17:29:34','',''),(4322,'1','277','1',1,'Retail Sale Id 4341',3698.24,0.00,0.00,5.08,269.24,'2022-08-28 17:33:54','',''),(4323,'1','277','1',1,'Retail Sale Id 4342',3640.00,0.00,0.00,5.00,265.00,'2022-08-28 17:37:18','',''),(4324,'1','277','1',1,'Retail Sale Id 4343',7280.00,0.00,0.00,10.00,530.00,'2022-08-28 17:39:43','',''),(4325,'1','277','1',1,'Retail Sale Id 4344',1499.68,0.00,0.00,2.06,109.18,'2022-08-28 17:40:29','',''),(4326,'1','277','1',1,'Retail Sale Id 4345',2999.36,0.00,0.00,4.12,218.36,'2022-08-28 17:43:41','',''),(4327,'1','277','1',1,'Retail Sale Id 4346',4397.12,0.00,0.00,6.04,320.12,'2022-08-28 17:44:54','',''),(4328,'1','277','1',1,'Retail Sale Id 4347',2198.56,0.00,0.00,3.02,160.06,'2022-08-28 17:45:43','',''),(4329,'1','277','1',1,'Retail Sale Id 4350',9100.00,0.00,0.00,12.50,662.50,'2022-08-28 17:53:26','',''),(4330,'1','277','1',1,'Retail Sale Id 4351',9100.00,0.00,0.00,12.50,662.50,'2022-08-28 17:55:18','',''),(4331,'1','277','1',1,'Retail Sale Id 4352',2802.80,0.00,0.00,3.85,204.05,'2022-08-28 17:56:16','',''),(4332,'1','277','1',1,'Retail Sale Id 4353',2184.00,0.00,0.00,3.00,159.00,'2022-08-28 18:02:11','',''),(4333,'1','277','1',1,'Retail Sale Id 4354',997.36,0.00,0.00,1.37,72.61,'2022-08-28 18:03:08','',''),(4334,'1','277','1',1,'Retail Sale Id 4355',35500.00,0.00,0.00,50.00,1750.00,'2022-08-28 18:08:25','',''),(4335,'1','277','1',1,'Retail Sale Id 4356',1499.68,0.00,0.00,2.06,109.18,'2022-08-28 18:09:12','',''),(4336,'1','277','1',1,'Retail Sale Id 4357',1201.20,0.00,0.00,1.65,87.45,'2022-08-28 18:11:19','',''),(4337,'1','277','1',1,'Retail Sale Id 4358',2198.56,0.00,0.00,3.02,160.06,'2022-08-28 18:12:15','',''),(4338,'1','277','1',1,'Retail Sale Id 4359',2002.00,0.00,0.00,2.75,145.75,'2022-08-28 18:14:30','',''),(4339,'1','277','1',1,'Retail Sale Id 4360',2999.36,0.00,0.00,4.12,218.36,'2022-08-28 18:15:18','',''),(4340,'1','277','1',1,'Retail Sale Id 4361',8000.72,0.00,0.00,10.99,582.47,'2022-08-28 18:18:19','',''),(4341,'1','277','1',1,'Retail Sale Id 4362',2497.04,0.00,0.00,3.43,181.79,'2022-08-28 18:22:01','',''),(4342,'1','277','1',1,'Retail Sale Id 4363',997.36,0.00,0.00,1.37,72.61,'2022-08-28 18:27:40','',''),(4343,'1','277','1',1,'Retail Sale Id 4364',502.32,0.00,0.00,0.69,36.57,'2022-08-28 18:28:30','',''),(4344,'1','277','1',1,'Retail Sale Id 4365',298.48,0.00,0.00,0.41,21.73,'2022-08-28 18:29:28','',''),(4345,'1','277','1',1,'Retail Sale Id 4366',2497.04,0.00,0.00,3.43,181.79,'2022-08-28 18:37:42','',''),(4346,'1','277','1',1,'Retail Sale Id 4367',5001.36,0.00,0.00,6.87,364.11,'2022-08-28 18:46:01','',''),(4347,'1','277','1',1,'Retail Sale Id 4368',7280.00,0.00,0.00,10.00,530.00,'2022-08-28 18:46:50','',''),(4348,'1','277','1',1,'Retail Sale Id 4369',1703.52,0.00,0.00,2.34,124.02,'2022-08-28 19:11:45','',''),(4349,'1','277','1',1,'Retail Sale Id 4370',2002.00,0.00,0.00,2.75,145.75,'2022-08-28 19:16:38','',''),(4350,'1','277','1',1,'Retail Sale Id 4371',997.36,0.00,0.00,1.37,72.61,'2022-08-28 19:25:05','',''),(4351,'1','277','1',1,'Retail Sale Id 4372',2002.00,0.00,0.00,2.75,145.75,'2022-08-28 19:30:06','',''),(4352,'1','277','1',1,'Return of Retail Sale Id 4365',0.00,298.48,0.41,0.00,-21.73,'2022-08-28 20:07:30','',''),(4353,'1','277','1',1,'Retail Sale Id 4373',298.48,0.00,0.00,0.41,21.73,'2022-08-28 20:11:37','',''),(4354,'1','277','1',1,'Return of Retail Sale Id 4370',0.00,2002.00,2.75,0.00,-145.75,'2022-08-28 20:15:13','',''),(4355,'1','277','1',1,'Retail Sale Id 4374',1994.72,0.00,0.00,2.74,145.22,'2022-08-28 20:15:46','',''),(4356,'1','277',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,2227500.00,3300.00,0.00,0.00,'2022-08-28 21:01:19','',''),(4357,'1','277',NULL,1,'Reception corrector for bridging 17',0.00,0.00,0.00,3300.00,0.00,'2022-08-28 21:03:30','',''),(4358,'1','277','1',1,'Received from bridging 17',0.00,0.00,3300.00,0.00,0.00,'2022-08-28 21:03:30','',''),(4359,'1','277','1',1,'Retail Sale Id 4375',2198.56,0.00,0.00,3.02,160.06,'2022-08-29 06:17:07','',''),(4360,'1','277','1',1,'Retail Sale Id 4376',4397.12,0.00,0.00,6.04,320.12,'2022-08-29 06:59:37','',''),(4361,'1','277','1',1,'Retail Sale Id 4378',2198.56,0.00,0.00,3.02,160.06,'2022-08-29 07:27:51','',''),(4362,'1','277','1',1,'Retail Sale Id 4379',3996.72,0.00,0.00,5.49,290.97,'2022-08-29 07:54:28','',''),(4363,'1','277','1',1,'Retail Sale Id 4380',997.36,0.00,0.00,1.37,72.61,'2022-08-29 07:55:04','',''),(4364,'1','277','1',1,'Retail Sale Id 4381',2002.00,0.00,0.00,2.75,145.75,'2022-08-29 07:58:58','',''),(4365,'1','277','1',1,'Retail Sale Id 4382',800.80,0.00,0.00,1.10,58.30,'2022-08-29 08:08:45','',''),(4366,'1','277','1',1,'Retail Sale Id 4383',800.80,0.00,0.00,1.10,58.30,'2022-08-29 08:17:21','',''),(4367,'1','277','1',1,'Retail Sale Id 4384',3698.24,0.00,0.00,5.08,269.24,'2022-08-29 08:18:43','',''),(4368,'1','277','1',1,'Retail Sale Id 4385',4368.00,0.00,0.00,6.00,318.00,'2022-08-29 08:20:15','',''),(4369,'1','277','1',1,'Retail Sale Id 4386',5001.36,0.00,0.00,6.87,364.11,'2022-08-29 08:23:53','',''),(4370,'1','277','1',1,'Retail Sale Id 4387',4397.12,0.00,0.00,6.04,320.12,'2022-08-29 08:25:42','',''),(4371,'1','277','1',1,'Retail Sale Id 4388',3501.68,0.00,0.00,4.81,254.93,'2022-08-29 08:28:40','',''),(4372,'1','277','1',1,'Retail Sale Id 4389',4397.12,0.00,0.00,6.04,320.12,'2022-08-29 08:43:35','',''),(4373,'1','277','1',1,'Retail Sale Id 4390',4397.12,0.00,0.00,6.04,320.12,'2022-08-29 08:47:57','',''),(4374,'1','277','1',1,'Retail Sale Id 4391',2002.00,0.00,0.00,2.75,145.75,'2022-08-29 09:20:58','',''),(4375,'1','277','1',1,'Retail Sale Id 4392',3996.72,0.00,0.00,5.49,290.97,'2022-08-29 09:24:40','',''),(4376,'1','277','1',1,'Retail Sale Id 4393',2999.36,0.00,0.00,4.12,218.36,'2022-08-29 09:25:32','',''),(4377,'1','277','1',1,'Retail Sale Id 4394',1499.68,0.00,0.00,2.06,109.18,'2022-08-29 09:44:53','',''),(4378,'1','277','1',1,'Retail Sale Id 4395',2002.00,0.00,0.00,2.75,145.75,'2022-08-29 09:47:55','',''),(4379,'1','277','1',1,'Retail Sale Id 4396',1499.68,0.00,0.00,2.06,109.18,'2022-08-29 09:52:02','',''),(4380,'1','277','1',1,'Retail Sale Id 4397',298.48,0.00,0.00,0.41,21.73,'2022-08-29 09:56:31','',''),(4381,'1','277','1',1,'Retail Sale Id 4398',1798.16,0.00,0.00,2.47,130.91,'2022-08-29 10:05:32','',''),(4382,'1','277','1',1,'Retail Sale Id 4399',3996.72,0.00,0.00,5.49,290.97,'2022-08-29 10:07:59','',''),(4383,'1','277','1',1,'Retail Sale Id 4400',2999.36,0.00,0.00,4.12,218.36,'2022-08-29 10:15:15','',''),(4384,'1','277','1',1,'Retail Sale Id 4401',4499.04,0.00,0.00,6.18,327.54,'2022-08-29 10:18:35','',''),(4385,'1','277','1',1,'Retail Sale Id 4402',4397.12,0.00,0.00,6.04,320.12,'2022-08-29 10:22:22','',''),(4386,'1','277','1',1,'Retail Sale Id 4403',1499.68,0.00,0.00,2.06,109.18,'2022-08-29 10:23:08','',''),(4387,'1','277','1',1,'Retail Sale Id 4404',1499.68,0.00,0.00,2.06,109.18,'2022-08-29 10:37:01','',''),(4388,'1','277','1',1,'Retail Sale Id 4405',21840.00,0.00,0.00,30.00,1590.00,'2022-08-29 10:49:57','',''),(4389,'1','277','1',1,'Retail Sale Id 4406',1499.68,0.00,0.00,2.06,109.18,'2022-08-29 10:50:54','',''),(4390,'1','277','1',1,'Retail Sale Id 4407',9100.00,0.00,0.00,12.50,662.50,'2022-08-29 10:56:25','',''),(4391,'1','277','1',1,'Retail Sale Id 4408',2999.36,0.00,0.00,4.12,218.36,'2022-08-29 11:07:47','',''),(4392,'1','277','1',1,'Retail Sale Id 4409',5001.36,0.00,0.00,6.87,364.11,'2022-08-29 11:08:54','',''),(4393,'1','277','1',1,'Retail Sale Id 4410',2999.36,0.00,0.00,4.12,218.36,'2022-08-29 11:12:13','',''),(4394,'1','277','1',1,'Retail Sale Id 4411',3501.68,0.00,0.00,4.81,254.93,'2022-08-29 11:19:19','',''),(4395,'1','277','1',1,'Retail Sale Id 4412',2999.36,0.00,0.00,4.12,218.36,'2022-08-29 11:19:56','',''),(4396,'1','277','1',1,'Retail Sale Id 4413',1499.68,0.00,0.00,2.06,109.18,'2022-08-29 11:20:41','',''),(4397,'1','277','1',1,'Retail Sale Id 4414',3996.72,0.00,0.00,5.49,290.97,'2022-08-29 11:21:29','',''),(4398,'1','277','1',1,'Retail Sale Id 4415',1499.68,0.00,0.00,2.06,109.18,'2022-08-29 11:27:05','',''),(4399,'1','277','1',1,'Retail Sale Id 4416',2002.00,0.00,0.00,2.75,145.75,'2022-08-29 11:27:47','',''),(4400,'1','277','1',1,'Retail Sale Id 4417',4397.12,0.00,0.00,6.04,320.12,'2022-08-29 11:28:28','',''),(4401,'1','277','1',1,'Retail Sale Id 4419',29280.16,0.00,0.00,40.22,2131.66,'2022-08-29 13:22:39','',''),(4402,'1','277','1',1,'Retail Sale Id 4420',13642.72,0.00,0.00,18.74,993.22,'2022-08-29 13:23:45','',''),(4403,'1','277','1',1,'Retail Sale Id 4421',2999.36,0.00,0.00,4.12,218.36,'2022-08-29 13:25:11','',''),(4404,'1','277','1',1,'Retail Sale Id 4422',29098.16,0.00,0.00,39.97,2118.41,'2022-08-29 13:25:55','',''),(4405,'1','277','1',1,'Retail Sale Id 4423',9100.00,0.00,0.00,12.50,662.50,'2022-08-29 13:26:47','',''),(4406,'1','277','1',1,'Retail Sale Id 4424',997.36,0.00,0.00,1.37,72.61,'2022-08-29 13:28:19','',''),(4407,'1','277','1',1,'Retail Sale Id 4425',13351.52,0.00,0.00,18.34,972.02,'2022-08-29 13:29:16','',''),(4408,'1','277','1',1,'Retail Sale Id 4426',1499.68,0.00,0.00,2.06,109.18,'2022-08-29 13:32:21','',''),(4409,'1','277','1',1,'Retail Sale Id 4427',5998.72,0.00,0.00,8.24,436.72,'2022-08-29 13:33:02','',''),(4410,'1','277','1',1,'Retail Sale Id 4428',3698.24,0.00,0.00,5.08,269.24,'2022-08-29 13:35:03','',''),(4411,'1','277','1',1,'Retail Sale Id 4429',2999.36,0.00,0.00,4.12,218.36,'2022-08-29 13:36:18','',''),(4412,'1','277','1',1,'Retail Sale Id 4430',3996.72,0.00,0.00,5.49,290.97,'2022-08-29 13:38:23','',''),(4413,'1','277','1',1,'Retail Sale Id 4431',2999.36,0.00,0.00,4.12,218.36,'2022-08-29 13:46:02','',''),(4414,'1','277','1',1,'Retail Sale Id 4432',902.72,0.00,0.00,1.24,65.72,'2022-08-29 13:47:04','',''),(4415,'1','277','1',1,'Retail Sale Id 4433',4397.12,0.00,0.00,6.04,320.12,'2022-08-29 13:50:36','',''),(4416,'1','277','1',1,'Retail Sale Id 4434',2198.56,0.00,0.00,3.02,160.06,'2022-08-29 13:52:41','',''),(4417,'1','277','1',1,'Retail Sale Id 4435',698.88,0.00,0.00,0.96,50.88,'2022-08-29 13:54:45','',''),(4418,'1','277','1',1,'Retail Sale Id 4436',2999.36,0.00,0.00,4.12,218.36,'2022-08-29 14:00:35','',''),(4419,'1','277','1',1,'Retail Sale Id 4437',1499.68,0.00,0.00,2.06,109.18,'2022-08-29 14:01:31','',''),(4420,'1','277','1',1,'Retail Sale Id 4438',4397.12,0.00,0.00,6.04,320.12,'2022-08-29 14:04:30','',''),(4421,'1','277','1',1,'Retail Sale Id 4439',7280.00,0.00,0.00,10.00,530.00,'2022-08-29 14:23:52','',''),(4422,'1','277','1',1,'Retail Sale Id 4440',2002.00,0.00,0.00,2.75,145.75,'2022-08-29 14:33:20','',''),(4423,'1','277','1',1,'Retail Sale Id 4441',2002.00,0.00,0.00,2.75,145.75,'2022-08-29 14:34:36','',''),(4424,'1','277','1',1,'Retail Sale Id 4442',2002.00,0.00,0.00,2.75,145.75,'2022-08-29 14:35:42','',''),(4425,'1','277','1',1,'Retail Sale Id 4443',9100.00,0.00,0.00,12.50,662.50,'2022-08-29 14:37:53','',''),(4426,'1','277','1',1,'Retail Sale Id 4444',3996.72,0.00,0.00,5.49,290.97,'2022-08-29 14:42:21','',''),(4427,'1','277','1',1,'Retail Sale Id 4445',4397.12,0.00,0.00,6.04,320.12,'2022-08-29 14:44:33','',''),(4428,'1','277','1',1,'Retail Sale Id 4446',2999.36,0.00,0.00,4.12,218.36,'2022-08-29 14:57:56','',''),(4429,'1','277','1',1,'Retail Sale Id 4447',3603.60,0.00,0.00,4.95,262.35,'2022-08-29 15:03:53','',''),(4430,'1','277','1',1,'Retail Sale Id 4448',9100.00,0.00,0.00,12.50,662.50,'2022-08-29 15:09:20','',''),(4431,'1','277','1',1,'Retail Sale Id 4449',9100.00,0.00,0.00,12.50,662.50,'2022-08-29 15:10:33','',''),(4432,'1','277','1',1,'Retail Sale Id 4450',4397.12,0.00,0.00,6.04,320.12,'2022-08-29 15:11:45','',''),(4433,'1','277','1',1,'Retail Sale Id 4451',1499.68,0.00,0.00,2.06,109.18,'2022-08-29 15:13:25','',''),(4434,'1','277','1',1,'Retail Sale Id 4452',749.84,0.00,0.00,1.03,54.59,'2022-08-29 15:16:25','',''),(4435,'1','277','1',1,'Retail Sale Id 4453',8008.00,0.00,0.00,11.00,583.00,'2022-08-29 15:17:32','',''),(4436,'1','277','1',1,'Retail Sale Id 4454',4397.12,0.00,0.00,6.04,320.12,'2022-08-29 15:25:44','',''),(4437,'1','277','1',1,'Retail Sale Id 4455',2999.36,0.00,0.00,4.12,218.36,'2022-08-29 15:29:45','',''),(4438,'1','277','1',1,'Retail Sale Id 4456',997.36,0.00,0.00,1.37,72.61,'2022-08-29 15:30:36','',''),(4439,'1','277','1',1,'Retail Sale Id 4457',1499.68,0.00,0.00,2.06,109.18,'2022-08-29 15:32:16','',''),(4440,'1','277','1',1,'Retail Sale Id 4458',698.88,0.00,0.00,0.96,50.88,'2022-08-29 15:38:46','',''),(4441,'1','277','1',1,'Retail Sale Id 4459',5001.36,0.00,0.00,6.87,364.11,'2022-08-29 15:39:46','',''),(4442,'1','277','1',1,'Retail Sale Id 4460',4397.12,0.00,0.00,6.04,320.12,'2022-08-29 15:41:09','',''),(4443,'1','277','1',1,'Retail Sale Id 4461',3647.28,0.00,0.00,5.01,265.53,'2022-08-29 15:45:18','',''),(4444,'1','277','1',1,'Retail Sale Id 4462',5103.28,0.00,0.00,7.01,371.53,'2022-08-29 15:46:49','',''),(4445,'1','277','1',1,'Retail Sale Id 4463',2198.56,0.00,0.00,3.02,160.06,'2022-08-29 16:05:49','',''),(4446,'1','277','1',1,'Retail Sale Id 4464',2999.36,0.00,0.00,4.12,218.36,'2022-08-29 16:07:49','',''),(4447,'1','277','1',1,'Retail Sale Id 4465',4397.12,0.00,0.00,6.04,320.12,'2022-08-29 16:11:54','',''),(4448,'1','277','1',1,'Retail Sale Id 4466',3640.00,0.00,0.00,5.00,265.00,'2022-08-29 16:19:25','',''),(4449,'1','277','1',1,'Retail Sale Id 4467',1499.68,0.00,0.00,2.06,109.18,'2022-08-29 16:20:35','',''),(4450,'1','277','1',1,'Retail Sale Id 4468',2002.00,0.00,0.00,2.75,145.75,'2022-08-29 16:21:26','',''),(4451,'1','277','1',1,'Retail Sale Id 4469',1499.68,0.00,0.00,2.06,109.18,'2022-08-29 16:33:58','',''),(4452,'1','277','1',1,'Retail Sale Id 4470',3698.24,0.00,0.00,5.08,269.24,'2022-08-29 16:40:03','',''),(4453,'1','277','1',1,'Retail Sale Id 4471',2198.56,0.00,0.00,3.02,160.06,'2022-08-29 16:41:02','',''),(4454,'1','277','1',1,'Retail Sale Id 4472',2999.36,0.00,0.00,4.12,218.36,'2022-08-29 16:41:46','',''),(4455,'1','277','1',1,'Retail Sale Id 4473',4368.00,0.00,0.00,6.00,318.00,'2022-08-29 16:43:38','',''),(4456,'1','277','1',1,'Retail Sale Id 4473',10920.00,0.00,0.00,15.00,795.00,'2022-08-29 16:43:38','',''),(4457,'1','277','1',1,'Retail Sale Id 4474',502.32,0.00,0.00,0.69,36.57,'2022-08-29 16:44:18','',''),(4458,'1','277','1',1,'Retail Sale Id 4475',7280.00,0.00,0.00,10.00,530.00,'2022-08-29 16:45:18','',''),(4459,'1','277','1',1,'Retail Sale Id 4476',1499.68,0.00,0.00,2.06,109.18,'2022-08-29 16:46:06','',''),(4460,'1','277','1',1,'Retail Sale Id 4477',3996.72,0.00,0.00,5.49,290.97,'2022-08-29 16:46:44','',''),(4461,'1','277','1',1,'Retail Sale Id 4478',2198.56,0.00,0.00,3.02,160.06,'2022-08-29 16:47:22','',''),(4462,'1','277','1',1,'Retail Sale Id 4479',997.36,0.00,0.00,1.37,72.61,'2022-08-29 16:56:50','',''),(4463,'1','277','1',1,'Retail Sale Id 4479',2999.36,0.00,0.00,4.12,218.36,'2022-08-29 16:56:50','',''),(4464,'1','277','1',1,'Retail Sale Id 4480',3640.00,0.00,0.00,5.00,265.00,'2022-08-29 17:00:49','',''),(4465,'1','277','1',1,'Retail Sale Id 4481',3640.00,0.00,0.00,5.00,265.00,'2022-08-29 17:02:23','',''),(4466,'1','277','1',1,'Retail Sale Id 4482',2198.56,0.00,0.00,3.02,160.06,'2022-08-29 17:03:19','',''),(4467,'1','277','1',1,'Retail Sale Id 4483',7280.00,0.00,0.00,10.00,530.00,'2022-08-29 17:05:16','',''),(4468,'1','277','1',1,'Retail Sale Id 4484',9100.00,0.00,0.00,12.50,662.50,'2022-08-29 17:07:47','',''),(4469,'1','277','1',1,'Retail Sale Id 4485',2002.00,0.00,0.00,2.75,145.75,'2022-08-29 17:19:41','',''),(4470,'1','277','1',1,'Retail Sale Id 4486',4397.12,0.00,0.00,6.04,320.12,'2022-08-29 17:24:04','',''),(4471,'1','277','1',1,'Retail Sale Id 4487',1499.68,0.00,0.00,2.06,109.18,'2022-08-29 17:29:12','',''),(4472,'1','277','1',1,'Retail Sale Id 4488',2999.36,0.00,0.00,4.12,218.36,'2022-08-29 17:30:08','',''),(4473,'1','277','1',1,'Retail Sale Id 4489',2198.56,0.00,0.00,3.02,160.06,'2022-08-29 17:33:24','',''),(4474,'1','277','1',1,'Retail Sale Id 4490',9100.00,0.00,0.00,12.50,662.50,'2022-08-29 17:34:18','',''),(4475,'1','277','1',1,'Retail Sale Id 4491',2002.00,0.00,0.00,2.75,145.75,'2022-08-29 17:35:50','',''),(4476,'1','277','1',1,'Retail Sale Id 4492',2002.00,0.00,0.00,2.75,145.75,'2022-08-29 17:45:29','',''),(4477,'1','277','1',1,'Retail Sale Id 4493',4397.12,0.00,0.00,6.04,320.12,'2022-08-29 18:02:50','',''),(4478,'1','277','1',1,'Retail Sale Id 4493',9100.00,0.00,0.00,12.50,662.50,'2022-08-29 18:02:50','',''),(4479,'1','277','1',1,'Retail Sale Id 4494',2198.56,0.00,0.00,3.02,160.06,'2022-08-29 18:04:18','',''),(4480,'1','277','1',1,'Retail Sale Id 4495',2002.00,0.00,0.00,2.75,145.75,'2022-08-29 18:05:34','',''),(4481,'1','277','1',1,'Retail Sale Id 4495',2999.36,0.00,0.00,4.12,218.36,'2022-08-29 18:05:34','',''),(4482,'1','277','1',1,'Retail Sale Id 4496',3640.00,0.00,0.00,5.00,265.00,'2022-08-29 18:14:10','',''),(4483,'1','277','1',1,'Retail Sale Id 4497',1303.12,0.00,0.00,1.79,94.87,'2022-08-29 18:15:37','',''),(4484,'1','277','1',1,'Retail Sale Id 4498',2198.56,0.00,0.00,3.02,160.06,'2022-08-29 18:16:33','',''),(4485,'1','277','1',1,'Retail Sale Id 4499',1499.68,0.00,0.00,2.06,109.18,'2022-08-29 18:17:31','',''),(4486,'1','277','1',1,'Retail Sale Id 4500',2002.00,0.00,0.00,2.75,145.75,'2022-08-29 18:19:23','',''),(4487,'1','277','1',1,'Retail Sale Id 4501',3996.72,0.00,0.00,5.49,290.97,'2022-08-29 18:20:10','',''),(4488,'1','277','1',1,'Retail Sale Id 4502',1499.68,0.00,0.00,2.06,109.18,'2022-08-29 18:20:59','',''),(4489,'1','277','1',1,'Retail Sale Id 4503',749.84,0.00,0.00,1.03,54.59,'2022-08-29 18:21:53','',''),(4490,'1','277','1',1,'Retail Sale Id 4504',2999.36,0.00,0.00,4.12,218.36,'2022-08-29 18:22:38','',''),(4491,'1','277','1',1,'Retail Sale Id 4505',997.36,0.00,0.00,1.37,72.61,'2022-08-29 18:23:30','',''),(4492,'1','277','1',1,'Retail Sale Id 4506',2198.56,0.00,0.00,3.02,160.06,'2022-08-29 18:24:37','',''),(4493,'1','277','1',1,'Retail Sale Id 4507',1499.68,0.00,0.00,2.06,109.18,'2022-08-29 18:25:35','',''),(4494,'1','277','1',1,'Return of Retail Sale Id 4462',0.00,5103.28,7.01,0.00,-371.53,'2022-08-29 18:32:18','',''),(4495,'1','277','1',1,'Retail Sale Id 4508',2002.00,0.00,0.00,2.75,145.75,'2022-08-29 18:34:45','',''),(4496,'1','277','1',1,'Retail Sale Id 4509',4368.00,0.00,0.00,6.00,318.00,'2022-08-29 18:37:53','',''),(4497,'1','277','1',1,'Retail Sale Id 4510',3698.24,0.00,0.00,5.08,269.24,'2022-08-29 18:39:24','',''),(4498,'1','277','1',1,'Retail Sale Id 4511',997.36,0.00,0.00,1.37,72.61,'2022-08-29 18:40:09','',''),(4499,'1','277','1',1,'Retail Sale Id 4512',9900.80,0.00,0.00,13.60,720.80,'2022-08-29 18:41:43','',''),(4500,'1','277','1',1,'Retail Sale Id 4513',32403.28,0.00,0.00,44.51,2359.03,'2022-08-29 18:42:48','',''),(4501,'1','277','1',1,'Retail Sale Id 4514',9100.00,0.00,0.00,12.50,662.50,'2022-08-29 18:46:56','',''),(4502,'1','277','1',1,'Retail Sale Id 4515',1499.68,0.00,0.00,2.06,109.18,'2022-08-29 18:54:51','',''),(4503,'1','277','1',1,'Retail Sale Id 4516',1499.68,0.00,0.00,2.06,109.18,'2022-08-29 19:09:18','',''),(4504,'1','277','1',1,'Retail Sale Id 4517',2198.56,0.00,0.00,3.02,160.06,'2022-08-29 19:14:18','',''),(4505,'1','277','1',1,'Retail Sale Id 4518',997.36,0.00,0.00,1.37,72.61,'2022-08-29 19:20:53','',''),(4506,'1','277','1',1,'Retail Sale Id 4519',2198.56,0.00,0.00,3.02,160.06,'2022-08-29 19:26:49','',''),(4507,'1','277','1',1,'Retail Sale Id 4520',2198.56,0.00,0.00,3.02,160.06,'2022-08-29 19:28:03','',''),(4508,'1','277','1',1,'Retail Sale Id 4521',6515.60,0.00,0.00,8.95,474.35,'2022-08-29 19:45:23','',''),(4509,'1','277','1',1,'Retail Sale Id 4522',18200.00,0.00,0.00,25.00,1325.00,'2022-08-30 07:00:52','',''),(4510,'1','277','1',1,'Retail Sale Id 4523',5001.36,0.00,0.00,6.87,364.11,'2022-08-30 07:14:38','',''),(4511,'1','277','1',1,'Retail Sale Id 4524',1499.68,0.00,0.00,2.06,109.18,'2022-08-30 07:17:24','',''),(4512,'1','277','1',1,'Retail Sale Id 4525',3996.72,0.00,0.00,5.49,290.97,'2022-08-30 07:35:22','',''),(4513,'1','277','1',1,'Retail Sale Id 4526',9100.00,0.00,0.00,12.50,662.50,'2022-08-30 07:38:51','',''),(4514,'1','277','1',1,'Retail Sale Id 4527',997.36,0.00,0.00,1.37,72.61,'2022-08-30 07:39:36','',''),(4515,'1','277','1',1,'Retail Sale Id 4528',4397.12,0.00,0.00,6.04,320.12,'2022-08-30 07:41:59','',''),(4516,'1','277','1',1,'Retail Sale Id 4529',4397.12,0.00,0.00,6.04,320.12,'2022-08-30 07:48:07','',''),(4517,'1','277','1',1,'Retail Sale Id 4530',2497.04,0.00,0.00,3.43,181.79,'2022-08-30 08:07:30','',''),(4518,'1','277','1',1,'Retail Sale Id 4531',2096.64,0.00,0.00,2.88,152.64,'2022-08-30 08:14:35','',''),(4519,'1','277','1',1,'Retail Sale Id 4532',502.32,0.00,0.00,0.69,36.57,'2022-08-30 08:15:51','',''),(4520,'1','277','1',1,'Retail Sale Id 4533',1499.68,0.00,0.00,2.06,109.18,'2022-08-30 08:18:42','',''),(4521,'1','277','1',1,'Retail Sale Id 4534',2198.56,0.00,0.00,3.02,160.06,'2022-08-30 08:20:37','',''),(4522,'1','277','1',1,'Retail Sale Id 4535',1397.76,0.00,0.00,1.92,101.76,'2022-08-30 08:33:00','',''),(4523,'1','277','1',1,'Retail Sale Id 4536',2002.00,0.00,0.00,2.75,145.75,'2022-08-30 08:33:51','',''),(4524,'1','277','1',1,'Retail Sale Id 4537',4397.12,0.00,0.00,6.04,320.12,'2022-08-30 08:35:12','',''),(4525,'1','277','1',1,'Retail Sale Id 4538',1499.68,0.00,0.00,2.06,109.18,'2022-08-30 08:47:39','',''),(4526,'1','277','1',1,'Retail Sale Id 4539',2198.56,0.00,0.00,3.02,160.06,'2022-08-30 08:49:28','',''),(4527,'1','277','1',1,'Retail Sale Id 4540',1499.68,0.00,0.00,2.06,109.18,'2022-08-30 08:57:00','',''),(4528,'1','277','1',1,'Retail Sale Id 4541',997.36,0.00,0.00,1.37,72.61,'2022-08-30 08:57:59','',''),(4529,'1','277','1',1,'Retail Sale Id 4542',14910.00,0.00,0.00,21.00,735.00,'2022-08-30 09:02:30','',''),(4530,'1','277','1',1,'Retail Sale Id 4543',2002.00,0.00,0.00,2.75,145.75,'2022-08-30 09:04:00','',''),(4531,'1','277','1',1,'Retail Sale Id 4544',4397.12,0.00,0.00,6.04,320.12,'2022-08-30 09:27:04','',''),(4532,'1','277','1',1,'Retail Sale Id 4546',2002.00,0.00,0.00,2.75,145.75,'2022-08-30 09:35:47','',''),(4533,'1','277','1',1,'Retail Sale Id 4547',9100.00,0.00,0.00,12.50,662.50,'2022-08-30 09:37:34','',''),(4534,'1','277','1',1,'Retail Sale Id 4548',502.32,0.00,0.00,0.69,36.57,'2022-08-30 09:38:17','',''),(4535,'1','277','1',1,'Retail Sale Id 4549',800.80,0.00,0.00,1.10,58.30,'2022-08-30 09:39:11','',''),(4536,'1','277','1',1,'Retail Sale Id 4550',9100.00,0.00,0.00,12.50,662.50,'2022-08-30 09:47:12','',''),(4537,'1','277','1',1,'Retail Sale Id 4551',3647.28,0.00,0.00,5.01,265.53,'2022-08-30 09:49:12','',''),(4538,'1','277','1',1,'Retail Sale Id 4552',997.36,0.00,0.00,1.37,72.61,'2022-08-30 09:49:55','',''),(4539,'1','277','1',1,'Retail Sale Id 4553',1499.68,0.00,0.00,2.06,109.18,'2022-08-30 09:50:39','',''),(4540,'1','277','1',1,'Retail Sale Id 4554',4397.12,0.00,0.00,6.04,320.12,'2022-08-30 09:51:21','',''),(4541,'1','277','1',1,'Retail Sale Id 4556',2096.64,0.00,0.00,2.88,152.64,'2022-08-30 09:52:41','',''),(4542,'1','277','1',1,'Retail Sale Id 4557',3996.72,0.00,0.00,5.49,290.97,'2022-08-30 09:53:40','',''),(4543,'1','277','1',1,'Retail Sale Id 4558',3647.28,0.00,0.00,5.01,265.53,'2022-08-30 09:56:25','',''),(4544,'1','277','1',1,'Retail Sale Id 4559',997.36,0.00,0.00,1.37,72.61,'2022-08-30 09:59:31','',''),(4545,'1','277','1',1,'Retail Sale Id 4560',2919.28,0.00,0.00,4.01,212.53,'2022-08-30 10:01:25','',''),(4546,'1','277','1',1,'Retail Sale Id 4561',3698.24,0.00,0.00,5.08,269.24,'2022-08-30 10:05:04','',''),(4547,'1','277','1',1,'Retail Sale Id 4562',4397.12,0.00,0.00,6.04,320.12,'2022-08-30 10:10:29','',''),(4548,'1','277','1',1,'Retail Sale Id 4563',2999.36,0.00,0.00,4.12,218.36,'2022-08-30 10:15:02','',''),(4549,'1','277','1',1,'Retail Sale Id 4564',3698.24,0.00,0.00,5.08,269.24,'2022-08-30 10:28:23','',''),(4550,'1','277','1',1,'Retail Sale Id 4565',2184.00,0.00,0.00,3.00,159.00,'2022-08-30 10:31:24','',''),(4551,'1','277','1',1,'Retail Sale Id 4566',8750.56,0.00,0.00,12.02,637.06,'2022-08-30 10:34:11','',''),(4552,'1','277','1',1,'Retail Sale Id 4567',8372.00,0.00,0.00,11.50,609.50,'2022-08-30 10:36:49','',''),(4553,'1','277','1',1,'Retail Sale Id 4568',5103.28,0.00,0.00,7.01,371.53,'2022-08-30 10:40:56','',''),(4554,'1','277','1',1,'Retail Sale Id 4569',2198.56,0.00,0.00,3.02,160.06,'2022-08-30 10:43:43','',''),(4555,'1','277','1',1,'Retail Sale Id 4570',2999.36,0.00,0.00,4.12,218.36,'2022-08-30 10:48:59','',''),(4556,'1','277','1',1,'Retail Sale Id 4571',1499.68,0.00,0.00,2.06,109.18,'2022-08-30 10:50:45','',''),(4557,'1','277','1',1,'Retail Sale Id 4572',1499.68,0.00,0.00,2.06,109.18,'2022-08-30 10:51:47','',''),(4558,'1','277','1',1,'Retail Sale Id 4573',3640.00,0.00,0.00,5.00,265.00,'2022-08-30 10:55:35','',''),(4559,'1','277','1',1,'Retail Sale Id 4574',1499.68,0.00,0.00,2.06,109.18,'2022-08-30 10:59:12','',''),(4560,'1','277','1',1,'Retail Sale Id 4575',2198.56,0.00,0.00,3.02,160.06,'2022-08-30 11:03:46','',''),(4561,'1','277','1',1,'Retail Sale Id 4576',4499.04,0.00,0.00,6.18,327.54,'2022-08-30 11:04:59','',''),(4562,'1','277','1',1,'Retail Sale Id 4577',4397.12,0.00,0.00,6.04,320.12,'2022-08-30 11:15:01','',''),(4563,'1','277','1',1,'Retail Sale Id 4578',1499.68,0.00,0.00,2.06,109.18,'2022-08-30 11:16:26','',''),(4564,'1','277','1',1,'Retail Sale Id 4579',800.80,0.00,0.00,1.10,58.30,'2022-08-30 11:17:43','',''),(4565,'1','277','1',1,'Retail Sale Id 4580',4397.12,0.00,0.00,6.04,320.12,'2022-08-30 11:19:01','',''),(4566,'1','277','1',1,'Retail Sale Id 4581',997.36,0.00,0.00,1.37,72.61,'2022-08-30 11:20:12','',''),(4567,'1','277','1',1,'Retail Sale Id 4582',4397.12,0.00,0.00,6.04,320.12,'2022-08-30 11:21:14','',''),(4568,'1','277','1',1,'Retail Sale Id 4583',2002.00,0.00,0.00,2.75,145.75,'2022-08-30 11:22:50','',''),(4569,'1','277','1',1,'Retail Sale Id 4584',8736.00,0.00,0.00,12.00,636.00,'2022-08-30 11:25:42','',''),(4570,'1','277','1',1,'Retail Sale Id 4585',3640.00,0.00,0.00,5.00,265.00,'2022-08-30 11:27:16','',''),(4571,'1','277','1',1,'Retail Sale Id 4586',2999.36,0.00,0.00,4.12,218.36,'2022-08-30 11:37:04','',''),(4572,'1','277','1',1,'Retail Sale Id 4587',3647.28,0.00,0.00,5.01,265.53,'2022-08-30 11:43:49','',''),(4573,'1','277','1',1,'Retail Sale Id 4588',2999.36,0.00,0.00,4.12,218.36,'2022-08-30 11:55:36','',''),(4574,'1','277','1',1,'Retail Sale Id 4589',1499.68,0.00,0.00,2.06,109.18,'2022-08-30 12:07:22','',''),(4575,'1','277','1',1,'Retail Sale Id 4590',997.36,0.00,0.00,1.37,72.61,'2022-08-30 12:08:48','',''),(4576,'1','277','1',1,'Retail Sale Id 4591',3698.24,0.00,0.00,5.08,269.24,'2022-08-30 12:17:53','',''),(4577,'1','277','1',1,'Retail Sale Id 4592',4397.12,0.00,0.00,6.04,320.12,'2022-08-30 12:19:02','',''),(4578,'1','277','1',1,'Retail Sale Id 4593',997.36,0.00,0.00,1.37,72.61,'2022-08-30 12:19:53','',''),(4579,'1','277','1',1,'Retail Sale Id 4594',4368.00,0.00,0.00,6.00,318.00,'2022-08-30 12:35:25','',''),(4580,'1','277','1',1,'Retail Sale Id 4595',5001.36,0.00,0.00,6.87,364.11,'2022-08-30 12:43:59','',''),(4581,'1','277','1',1,'Retail Sale Id 4596',2198.56,0.00,0.00,3.02,160.06,'2022-08-30 12:45:38','',''),(4582,'1','277','1',1,'Retail Sale Id 4597',1499.68,0.00,0.00,2.06,109.18,'2022-08-30 12:48:37','',''),(4583,'1','277','1',1,'Retail Sale Id 4598',3996.72,0.00,0.00,5.49,290.97,'2022-08-30 12:50:37','',''),(4584,'1','277','1',1,'Retail Sale Id 4599',2198.56,0.00,0.00,3.02,160.06,'2022-08-30 12:54:48','',''),(4585,'1','277','1',1,'Retail Sale Id 4600',2912.00,0.00,0.00,4.00,212.00,'2022-08-30 12:55:31','',''),(4586,'1','277','1',1,'Retail Sale Id 4601',7280.00,0.00,0.00,10.00,530.00,'2022-08-30 12:58:21','',''),(4587,'1','277','1',1,'Return of Retail Sale Id 4601',0.00,7280.00,10.00,0.00,-530.00,'2022-08-30 12:59:10','',''),(4588,'1','277','1',1,'Retail Sale Id 4602',7003.36,0.00,0.00,9.62,509.86,'2022-08-30 12:59:54','',''),(4589,'1','277','1',1,'Retail Sale Id 4603',1499.68,0.00,0.00,2.06,109.18,'2022-08-30 13:01:35','',''),(4590,'1','277','1',1,'Retail Sale Id 4604',1499.68,0.00,0.00,2.06,109.18,'2022-08-30 13:06:06','',''),(4591,'1','277','1',1,'Retail Sale Id 4605',4397.12,0.00,0.00,6.04,320.12,'2022-08-30 13:19:51','',''),(4592,'1','277','1',1,'Retail Sale Id 4606',2198.56,0.00,0.00,3.02,160.06,'2022-08-30 13:29:15','',''),(4593,'1','277','1',1,'Retail Sale Id 4607',4397.12,0.00,0.00,6.04,320.12,'2022-08-30 13:30:12','',''),(4594,'1','277','1',1,'Retail Sale Id 4608',9100.00,0.00,0.00,12.50,662.50,'2022-08-30 15:23:45','',''),(4595,'1','277','1',1,'Retail Sale Id 4609',1499.68,0.00,0.00,2.06,109.18,'2022-08-30 15:25:46','',''),(4596,'1','277','1',1,'Retail Sale Id 4610',2198.56,0.00,0.00,3.02,160.06,'2022-08-30 15:31:26','',''),(4597,'1','277','1',1,'Retail Sale Id 4611',2999.36,0.00,0.00,4.12,218.36,'2022-08-30 15:41:18','',''),(4598,'1','277','1',1,'Retail Sale Id 4612',4397.12,0.00,0.00,6.04,320.12,'2022-08-30 15:49:11','',''),(4599,'1','277','1',1,'Retail Sale Id 4613',800.80,0.00,0.00,1.10,58.30,'2022-08-30 15:51:07','',''),(4600,'1','277','1',1,'Retail Sale Id 4616',2002.00,0.00,0.00,2.75,145.75,'2022-08-30 16:16:16','',''),(4601,'1','277','1',1,'Retail Sale Id 4617',22902.88,0.00,0.00,31.46,1667.38,'2022-08-30 16:24:49','',''),(4602,'1','277','1',1,'Retail Sale Id 4618',3698.24,0.00,0.00,5.08,269.24,'2022-08-30 16:26:00','',''),(4603,'1','277','1',1,'Retail Sale Id 4619',2999.36,0.00,0.00,4.12,218.36,'2022-08-30 16:26:50','',''),(4604,'1','277','1',1,'Retail Sale Id 4621',2497.04,0.00,0.00,3.43,181.79,'2022-08-30 16:28:40','',''),(4605,'1','277','1',1,'Retail Sale Id 4622',9100.00,0.00,0.00,12.50,662.50,'2022-08-30 16:30:13','',''),(4606,'1','277','1',1,'Retail Sale Id 4623',4448.08,0.00,0.00,6.11,323.83,'2022-08-30 16:32:10','',''),(4607,'1','277','1',1,'Retail Sale Id 4624',17501.12,0.00,0.00,24.04,1274.12,'2022-08-30 16:38:16','',''),(4608,'1','277','1',1,'Retail Sale Id 4625',13402.48,0.00,0.00,18.41,975.73,'2022-08-30 16:39:30','',''),(4609,'1','277','1',1,'Retail Sale Id 4626',19102.72,0.00,0.00,26.24,1390.72,'2022-08-30 16:40:53','',''),(4610,'1','277','1',1,'Retail Sale Id 4627',124250.00,0.00,0.00,175.00,6125.00,'2022-08-30 16:42:52','',''),(4611,'1','277','1',1,'Retail Sale Id 4628',7301.84,0.00,0.00,10.03,531.59,'2022-08-30 16:45:08','',''),(4612,'1','277','1',1,'Retail Sale Id 4629',997.36,0.00,0.00,1.37,72.61,'2022-08-30 16:46:01','',''),(4613,'1','277','1',1,'Retail Sale Id 4630',8998.08,0.00,0.00,12.36,655.08,'2022-08-30 16:49:40','',''),(4614,'1','277','1',1,'Retail Sale Id 4631',2999.36,0.00,0.00,4.12,218.36,'2022-08-30 16:54:53','',''),(4615,'1','277','1',1,'Retail Sale Id 4632',800.80,0.00,0.00,1.10,58.30,'2022-08-30 16:58:11','',''),(4616,'1','277','1',1,'Retail Sale Id 4634',2002.00,0.00,0.00,2.75,145.75,'2022-08-30 17:13:49','',''),(4617,'1','277','1',1,'Return of Retail Sale Id 4624',0.00,17501.12,24.04,0.00,-1274.12,'2022-08-30 17:23:37','',''),(4618,'1','277','1',1,'Return of Retail Sale Id 4617',0.00,22902.88,31.46,0.00,-1667.38,'2022-08-30 17:24:32','',''),(4619,'1','277','1',1,'Retail Sale Id 4635',19903.52,0.00,0.00,27.34,1449.02,'2022-08-30 17:25:31','',''),(4620,'1','277','1',1,'Retail Sale Id 4636',2497.04,0.00,0.00,3.43,181.79,'2022-08-30 17:27:17','',''),(4621,'1','277','1',1,'Retail Sale Id 4637',14501.76,0.00,0.00,19.92,1055.76,'2022-08-30 17:28:07','',''),(4622,'1','277','1',1,'Retail Sale Id 4638',4397.12,0.00,0.00,6.04,320.12,'2022-08-30 17:33:44','',''),(4623,'1','277','1',1,'Retail Sale Id 4639',8801.52,0.00,0.00,12.09,640.77,'2022-08-30 17:35:04','',''),(4624,'1','277','1',1,'Retail Sale Id 4644',1499.68,0.00,0.00,2.06,109.18,'2022-08-30 17:40:15','',''),(4625,'1','277','1',1,'Retail Sale Id 4645',800.80,0.00,0.00,1.10,58.30,'2022-08-30 17:41:06','',''),(4626,'1','277','1',1,'Retail Sale Id 4646',2999.36,0.00,0.00,4.12,218.36,'2022-08-30 17:45:02','',''),(4627,'1','277','1',1,'Retail Sale Id 4647',9100.00,0.00,0.00,12.50,662.50,'2022-08-30 17:46:32','',''),(4628,'1','277','1',1,'Retail Sale Id 4648',1499.68,0.00,0.00,2.06,109.18,'2022-08-30 17:47:41','',''),(4629,'1','277','1',1,'Retail Sale Id 4649',6602.96,0.00,0.00,9.07,480.71,'2022-08-30 17:50:57','',''),(4630,'1','277','1',1,'Retail Sale Id 4650',1397.76,0.00,0.00,1.92,101.76,'2022-08-30 17:54:44','',''),(4631,'1','277','1',1,'Retail Sale Id 4651',5001.36,0.00,0.00,6.87,364.11,'2022-08-30 17:57:20','',''),(4632,'1','277','1',1,'Retail Sale Id 4652',2999.36,0.00,0.00,4.12,218.36,'2022-08-30 17:57:58','',''),(4633,'1','277','1',1,'Retail Sale Id 4653',2198.56,0.00,0.00,3.02,160.06,'2022-08-30 17:59:49','',''),(4634,'1','277','1',1,'Retail Sale Id 4654',749.84,0.00,0.00,1.03,54.59,'2022-08-30 18:00:39','',''),(4635,'1','277','1',1,'Retail Sale Id 4655',298.48,0.00,0.00,0.41,21.73,'2022-08-30 18:07:21','',''),(4636,'1','277','1',1,'Retail Sale Id 4656',5824.00,0.00,0.00,8.00,424.00,'2022-08-30 18:08:06','',''),(4637,'1','277','1',1,'Retail Sale Id 4657',1303.12,0.00,0.00,1.79,94.87,'2022-08-30 18:08:45','',''),(4638,'1','277','1',1,'Retail Sale Id 4658',1499.68,0.00,0.00,2.06,109.18,'2022-08-30 18:09:19','',''),(4639,'1','277','1',1,'Retail Sale Id 4659',7280.00,0.00,0.00,10.00,530.00,'2022-08-30 18:15:01','',''),(4640,'1','277','1',1,'Retail Sale Id 4660',4397.12,0.00,0.00,6.04,320.12,'2022-08-30 18:18:09','',''),(4641,'1','277','1',1,'Retail Sale Id 4661',3996.72,0.00,0.00,5.49,290.97,'2022-08-30 18:22:35','',''),(4642,'1','277','1',1,'Retail Sale Id 4662',2300.48,0.00,0.00,3.16,167.48,'2022-08-30 18:23:24','',''),(4643,'1','277','1',1,'Retail Sale Id 4663',2999.36,0.00,0.00,4.12,218.36,'2022-08-30 18:25:28','',''),(4644,'1','277','1',1,'Retail Sale Id 4664',2198.56,0.00,0.00,3.02,160.06,'2022-08-30 18:27:07','',''),(4645,'1','277','1',1,'Retail Sale Id 4665',800.80,0.00,0.00,1.10,58.30,'2022-08-30 18:29:42','',''),(4646,'1','277','1',1,'Retail Sale Id 4666',997.36,0.00,0.00,1.37,72.61,'2022-08-30 18:30:20','',''),(4647,'1','277','1',1,'Retail Sale Id 4667',5001.36,0.00,0.00,6.87,364.11,'2022-08-30 18:31:11','',''),(4648,'1','277','1',1,'Retail Sale Id 4668',4397.12,0.00,0.00,6.04,320.12,'2022-08-30 18:44:04','',''),(4649,'1','277','1',1,'Retail Sale Id 4669',3501.68,0.00,0.00,4.81,254.93,'2022-08-30 18:46:39','',''),(4650,'1','277','1',1,'Retail Sale Id 4670',2912.00,0.00,0.00,4.00,212.00,'2022-08-30 18:52:27','',''),(4651,'1','277','1',1,'Retail Sale Id 4671',1499.68,0.00,0.00,2.06,109.18,'2022-08-30 18:58:57','',''),(4652,'1','277','1',1,'Retail Sale Id 4672',800.80,0.00,0.00,1.10,58.30,'2022-08-30 19:00:10','',''),(4653,'1','277','1',1,'Retail Sale Id 4673',2999.36,0.00,0.00,4.12,218.36,'2022-08-30 19:03:03','',''),(4654,'1','277','1',1,'Retail Sale Id 4674',9100.00,0.00,0.00,12.50,662.50,'2022-08-30 19:10:05','',''),(4655,'1','277','1',1,'Retail Sale Id 4675',2497.04,0.00,0.00,3.43,181.79,'2022-08-30 19:13:00','',''),(4656,'1','277','1',1,'Retail Sale Id 4676',8000.72,0.00,0.00,10.99,582.47,'2022-08-30 19:13:56','',''),(4657,'1','277','1',1,'Retail Sale Id 4677',1499.68,0.00,0.00,2.06,109.18,'2022-08-30 19:15:03','',''),(4658,'1','277','1',1,'Retail Sale Id 4678',9100.00,0.00,0.00,12.50,662.50,'2022-08-30 19:16:07','',''),(4659,'1','277','1',1,'Retail Sale Id 4679',997.36,0.00,0.00,1.37,72.61,'2022-08-30 19:18:09','',''),(4660,'1','277','1',1,'Retail Sale Id 4680',2002.00,0.00,0.00,2.75,145.75,'2022-08-30 19:24:19','',''),(4661,'1','277','1',1,'Retail Sale Id 4681',997.36,0.00,0.00,1.37,72.61,'2022-08-30 19:32:30','',''),(4662,'1','277','1',1,'Return of Retail Sale Id 4681',0.00,997.36,1.37,0.00,-72.61,'2022-08-30 19:48:18','',''),(4663,'1','277','1',1,'Retail Sale Id 4682',960.96,0.00,0.00,1.32,69.96,'2022-08-30 19:48:59','',''),(4664,'1','277','1',1,'Retail Sale Id 4683',2184.00,0.00,0.00,3.00,159.00,'2022-08-31 06:54:23','',''),(4665,'1','277','1',1,'Retail Sale Id 4684',5001.36,0.00,0.00,6.87,364.11,'2022-08-31 07:07:38','',''),(4666,'1','277','1',1,'Retail Sale Id 4685',1499.68,0.00,0.00,2.06,109.18,'2022-08-31 07:11:18','',''),(4667,'1','277','1',1,'Retail Sale Id 4686',1499.68,0.00,0.00,2.06,109.18,'2022-08-31 07:21:22','',''),(4668,'1','277','1',1,'Retail Sale Id 4687',4368.00,0.00,0.00,6.00,318.00,'2022-08-31 07:29:37','',''),(4669,'1','277','1',1,'Retail Sale Id 4688',2198.56,0.00,0.00,3.02,160.06,'2022-08-31 07:30:49','',''),(4670,'1','277','1',1,'Retail Sale Id 4689',8000.72,0.00,0.00,10.99,582.47,'2022-08-31 07:34:12','',''),(4671,'1','277','1',1,'Retail Sale Id 4690',4397.12,0.00,0.00,6.04,320.12,'2022-08-31 07:38:46','',''),(4672,'1','277','1',1,'Retail Sale Id 4691',5197.92,0.00,0.00,7.14,378.42,'2022-08-31 07:39:34','',''),(4673,'1','277','1',1,'Retail Sale Id 4693',997.36,0.00,0.00,1.37,72.61,'2022-08-31 07:54:15','',''),(4674,'1','277','1',1,'Retail Sale Id 4694',2999.36,0.00,0.00,4.12,218.36,'2022-08-31 07:55:14','',''),(4675,'1','277','1',1,'Retail Sale Id 4695',997.36,0.00,0.00,1.37,72.61,'2022-08-31 07:59:20','',''),(4676,'1','277','1',1,'Retail Sale Id 4696',2198.56,0.00,0.00,3.02,160.06,'2022-08-31 08:15:34','',''),(4677,'1','277','1',1,'Retail Sale Id 4697',4368.00,0.00,0.00,6.00,318.00,'2022-08-31 08:17:10','',''),(4678,'1','277','1',1,'Retail Sale Id 4698',9100.00,0.00,0.00,12.50,662.50,'2022-08-31 08:20:14','',''),(4679,'1','277','1',1,'Retail Sale Id 4699',2002.00,0.00,0.00,2.75,145.75,'2022-08-31 08:21:22','',''),(4680,'1','277','1',1,'Retail Sale Id 4700',16969.00,0.00,0.00,23.90,836.50,'2022-08-31 08:37:20','',''),(4681,'1','277','1',1,'Retail Sale Id 4701',9100.00,0.00,0.00,12.50,662.50,'2022-08-31 08:41:39','',''),(4682,'1','277','1',1,'Retail Sale Id 4702',4397.12,0.00,0.00,6.04,320.12,'2022-08-31 08:42:59','',''),(4683,'1','277','1',1,'Retail Sale Id 4703',3640.00,0.00,0.00,5.00,265.00,'2022-08-31 08:44:51','',''),(4684,'1','277','1',1,'Retail Sale Id 4704',2198.56,0.00,0.00,3.02,160.06,'2022-08-31 08:47:05','',''),(4685,'1','277','1',1,'Retail Sale Id 4705',3603.60,0.00,0.00,4.95,262.35,'2022-08-31 08:51:11','',''),(4686,'1','277','1',1,'Retail Sale Id 4706',2999.36,0.00,0.00,4.12,218.36,'2022-08-31 08:57:01','',''),(4687,'1','277','1',1,'Retail Sale Id 4707',2002.00,0.00,0.00,2.75,145.75,'2022-08-31 08:57:46','',''),(4688,'1','277','1',1,'Retail Sale Id 4708',2198.56,0.00,0.00,3.02,160.06,'2022-08-31 09:02:44','',''),(4689,'1','277','1',1,'Retail Sale Id 4709',2999.36,0.00,0.00,4.12,218.36,'2022-08-31 09:10:46','',''),(4690,'1','277','1',1,'Retail Sale Id 4710',7280.00,0.00,0.00,10.00,530.00,'2022-08-31 09:16:10','',''),(4691,'1','277','1',1,'Retail Sale Id 4711',2002.00,0.00,0.00,2.75,145.75,'2022-08-31 09:16:53','',''),(4692,'1','277','1',1,'Retail Sale Id 4712',4397.12,0.00,0.00,6.04,320.12,'2022-08-31 09:21:33','',''),(4693,'1','277','1',1,'Retail Sale Id 4713',1499.68,0.00,0.00,2.06,109.18,'2022-08-31 09:22:16','',''),(4694,'1','277','1',1,'Retail Sale Id 4714',3698.24,0.00,0.00,5.08,269.24,'2022-08-31 09:23:48','',''),(4695,'1','277','1',1,'Retail Sale Id 4715',698.88,0.00,0.00,0.96,50.88,'2022-08-31 09:26:28','',''),(4696,'1','277','1',1,'Retail Sale Id 4716',9100.00,0.00,0.00,12.50,662.50,'2022-08-31 09:27:14','',''),(4697,'1','277','1',1,'Retail Sale Id 4717',800.80,0.00,0.00,1.10,58.30,'2022-08-31 09:28:29','',''),(4698,'1','277','1',1,'Retail Sale Id 4718',2497.04,0.00,0.00,3.43,181.79,'2022-08-31 09:29:19','',''),(4699,'1','277','1',1,'Retail Sale Id 4719',4397.12,0.00,0.00,6.04,320.12,'2022-08-31 09:31:54','',''),(4700,'1','277','1',1,'Retail Sale Id 4720',1499.68,0.00,0.00,2.06,109.18,'2022-08-31 09:32:37','',''),(4701,'1','277','1',1,'Retail Sale Id 4721',3996.72,0.00,0.00,5.49,290.97,'2022-08-31 09:43:10','',''),(4702,'1','277','1',1,'Retail Sale Id 4722',1499.68,0.00,0.00,2.06,109.18,'2022-08-31 09:47:41','',''),(4703,'1','277','1',1,'Retail Sale Id 4723',9100.00,0.00,0.00,12.50,662.50,'2022-08-31 09:58:02','',''),(4704,'1','277','1',1,'Retail Sale Id 4724',2198.56,0.00,0.00,3.02,160.06,'2022-08-31 10:12:56','',''),(4705,'1','277','1',1,'Retail Sale Id 4725',2002.00,0.00,0.00,2.75,145.75,'2022-08-31 10:13:41','',''),(4706,'1','277','1',1,'Retail Sale Id 4726',4397.12,0.00,0.00,6.04,320.12,'2022-08-31 10:34:04','',''),(4707,'1','277','1',1,'Retail Sale Id 4727',698.88,0.00,0.00,0.96,50.88,'2022-08-31 10:37:26','',''),(4708,'1','277','1',1,'Retail Sale Id 4728',4397.12,0.00,0.00,6.04,320.12,'2022-08-31 10:40:37','',''),(4709,'1','277','1',1,'Retail Sale Id 4729',2002.00,0.00,0.00,2.75,145.75,'2022-08-31 10:49:38','',''),(4710,'1','277','1',1,'Retail Sale Id 4730',1499.68,0.00,0.00,2.06,109.18,'2022-08-31 10:53:30','',''),(4711,'1','277','1',1,'Retail Sale Id 4731',997.36,0.00,0.00,1.37,72.61,'2022-08-31 11:03:56','',''),(4712,'1','277','1',1,'Retail Sale Id 4732',9100.00,0.00,0.00,12.50,662.50,'2022-08-31 11:07:49','',''),(4713,'1','277','1',1,'Retail Sale Id 4733',1499.68,0.00,0.00,2.06,109.18,'2022-08-31 11:14:17','',''),(4714,'1','277','1',1,'Retail Sale Id 4734',4397.12,0.00,0.00,6.04,320.12,'2022-08-31 11:15:00','',''),(4715,'1','277','1',1,'Retail Sale Id 4735',5103.28,0.00,0.00,7.01,371.53,'2022-08-31 11:16:39','',''),(4716,'1','277','1',1,'Retail Sale Id 4736',1499.68,0.00,0.00,2.06,109.18,'2022-08-31 11:32:25','',''),(4717,'1','277','1',1,'Retail Sale Id 4737',3501.68,0.00,0.00,4.81,254.93,'2022-08-31 11:40:15','',''),(4718,'1','277','1',1,'Retail Sale Id 4738',298.48,0.00,0.00,0.41,21.73,'2022-08-31 11:45:26','',''),(4719,'1','277','1',1,'Retail Sale Id 4739',2497.04,0.00,0.00,3.43,181.79,'2022-08-31 11:46:13','',''),(4720,'1','277','1',1,'Retail Sale Id 4740',9100.00,0.00,0.00,12.50,662.50,'2022-08-31 11:48:50','',''),(4721,'1','277','1',1,'Retail Sale Id 4741',7498.40,0.00,0.00,10.30,545.90,'2022-08-31 11:57:00','',''),(4722,'1','277','1',1,'Retail Sale Id 4742',11000.08,0.00,0.00,15.11,800.83,'2022-08-31 12:09:02','',''),(4723,'1','277','1',1,'Retail Sale Id 4743',3647.28,0.00,0.00,5.01,265.53,'2022-08-31 12:17:16','',''),(4724,'1','277','1',1,'Retail Sale Id 4744',4397.12,0.00,0.00,6.04,320.12,'2022-08-31 12:18:32','',''),(4725,'1','277','1',1,'Retail Sale Id 4745',5001.36,0.00,0.00,6.87,364.11,'2022-08-31 12:19:17','',''),(4726,'1','277','1',1,'Retail Sale Id 4746',1499.68,0.00,0.00,2.06,109.18,'2022-08-31 12:27:16','',''),(4727,'1','277','1',1,'Retail Sale Id 4747',2999.36,0.00,0.00,4.12,218.36,'2022-08-31 12:36:01','',''),(4728,'1','277','1',1,'Retail Sale Id 4748',1499.68,0.00,0.00,2.06,109.18,'2022-08-31 12:36:48','',''),(4729,'1','277','1',1,'Retail Sale Id 4749',2999.36,0.00,0.00,4.12,218.36,'2022-08-31 12:39:12','',''),(4730,'1','277','1',1,'Retail Sale Id 4750',1499.68,0.00,0.00,2.06,109.18,'2022-08-31 13:13:36','',''),(4731,'1','277','1',1,'Retail Sale Id 4751',997.36,0.00,0.00,1.37,72.61,'2022-08-31 13:16:24','',''),(4732,'1','277','1',1,'Retail Sale Id 4752',4368.00,0.00,0.00,6.00,318.00,'2022-08-31 13:29:16','',''),(4733,'1','277','1',1,'Retail Sale Id 4753',2497.04,0.00,0.00,3.43,181.79,'2022-08-31 13:33:26','',''),(4734,'1','277','1',1,'Retail Sale Id 4754',749.84,0.00,0.00,1.03,54.59,'2022-08-31 13:43:25','',''),(4735,'1','277','1',1,'Retail Sale Id 4755',5001.36,0.00,0.00,6.87,364.11,'2022-08-31 13:45:10','',''),(4736,'1','277','1',1,'Retail Sale Id 4756',2002.00,0.00,0.00,2.75,145.75,'2022-08-31 13:45:57','',''),(4737,'1','277','1',1,'Retail Sale Id 4757',902.72,0.00,0.00,1.24,65.72,'2022-08-31 13:46:56','',''),(4738,'1','277','1',1,'Retail Sale Id 4758',2198.56,0.00,0.00,3.02,160.06,'2022-08-31 13:47:54','',''),(4739,'1','277','1',1,'Retail Sale Id 4759',2002.00,0.00,0.00,2.75,145.75,'2022-08-31 14:00:28','',''),(4740,'1','277','1',1,'Retail Sale Id 4760',4397.12,0.00,0.00,6.04,320.12,'2022-08-31 14:01:39','',''),(4741,'1','277','1',1,'Retail Sale Id 4761',9100.00,0.00,0.00,12.50,662.50,'2022-08-31 14:12:33','',''),(4742,'1','277','1',1,'Retail Sale Id 4762',1303.12,0.00,0.00,1.79,94.87,'2022-08-31 14:16:32','',''),(4743,'1','277','1',1,'Retail Sale Id 4763',2198.56,0.00,0.00,3.02,160.06,'2022-08-31 14:43:11','',''),(4744,'1','277','1',1,'Retail Sale Id 4764',2198.56,0.00,0.00,3.02,160.06,'2022-08-31 14:49:13','',''),(4745,'1','277','1',1,'Retail Sale Id 4765',9100.00,0.00,0.00,12.50,662.50,'2022-08-31 14:51:57','',''),(4746,'1','277','1',1,'Retail Sale Id 4766',4499.04,0.00,0.00,6.18,327.54,'2022-08-31 15:17:37','',''),(4747,'1','277','1',1,'Retail Sale Id 4767',3603.60,0.00,0.00,4.95,262.35,'2022-08-31 15:28:18','',''),(4748,'1','277','1',1,'Retail Sale Id 4768',9100.00,0.00,0.00,12.50,662.50,'2022-08-31 15:37:42','',''),(4749,'1','277','1',1,'Retail Sale Id 4769',997.36,0.00,0.00,1.37,72.61,'2022-08-31 15:38:19','',''),(4750,'1','277','1',1,'Retail Sale Id 4770',2999.36,0.00,0.00,4.12,218.36,'2022-08-31 15:42:10','',''),(4751,'1','277','1',1,'Retail Sale Id 4771',9100.00,0.00,0.00,12.50,662.50,'2022-08-31 15:46:40','',''),(4752,'1','277','1',1,'Retail Sale Id 4772',1499.68,0.00,0.00,2.06,109.18,'2022-08-31 15:47:38','',''),(4753,'1','277','1',1,'Retail Sale Id 4773',4397.12,0.00,0.00,6.04,320.12,'2022-08-31 15:51:04','',''),(4754,'1','277','1',1,'Retail Sale Id 4774',2919.28,0.00,0.00,4.01,212.53,'2022-08-31 15:55:47','',''),(4755,'1','277','1',1,'Retail Sale Id 4775',3996.72,0.00,0.00,5.49,290.97,'2022-08-31 16:00:25','',''),(4756,'1','277','1',1,'Retail Sale Id 4776',4499.04,0.00,0.00,6.18,327.54,'2022-08-31 16:01:36','',''),(4757,'1','277','1',1,'Retail Sale Id 4777',2198.56,0.00,0.00,3.02,160.06,'2022-08-31 16:02:31','',''),(4758,'1','277','1',1,'Retail Sale Id 4778',2002.00,0.00,0.00,2.75,145.75,'2022-08-31 16:03:13','',''),(4759,'1','277','1',1,'Retail Sale Id 4779',19880.00,0.00,0.00,28.00,980.00,'2022-08-31 16:04:33','',''),(4760,'1','277','1',1,'Retail Sale Id 4780',1499.68,0.00,0.00,2.06,109.18,'2022-08-31 16:06:00','',''),(4761,'1','277','1',1,'Retail Sale Id 4781',2002.00,0.00,0.00,2.75,145.75,'2022-08-31 16:06:45','',''),(4762,'1','277','1',1,'Retail Sale Id 4782',1499.68,0.00,0.00,2.06,109.18,'2022-08-31 16:07:25','',''),(4763,'1','277','1',1,'Retail Sale Id 4783',1499.68,0.00,0.00,2.06,109.18,'2022-08-31 16:15:14','',''),(4764,'1','277','1',1,'Retail Sale Id 4784',3698.24,0.00,0.00,5.08,269.24,'2022-08-31 16:19:25','',''),(4765,'1','277','1',1,'Retail Sale Id 4785',2002.00,0.00,0.00,2.75,145.75,'2022-08-31 16:20:15','',''),(4766,'1','277','1',1,'Retail Sale Id 4786',2198.56,0.00,0.00,3.02,160.06,'2022-08-31 16:24:54','',''),(4767,'1','277','1',1,'Retail Sale Id 4787',4397.12,0.00,0.00,6.04,320.12,'2022-08-31 16:31:37','',''),(4768,'1','277','1',1,'Retail Sale Id 4788',2198.56,0.00,0.00,3.02,160.06,'2022-08-31 16:35:08','',''),(4769,'1','277','1',1,'Retail Sale Id 4789',5001.36,0.00,0.00,6.87,364.11,'2022-08-31 16:38:51','',''),(4770,'1','277','1',1,'Retail Sale Id 4790',2002.00,0.00,0.00,2.75,145.75,'2022-08-31 16:43:14','',''),(4771,'1','277','1',1,'Retail Sale Id 4791',3996.72,0.00,0.00,5.49,290.97,'2022-08-31 16:50:24','',''),(4772,'1','277','1',1,'Retail Sale Id 4792',4397.12,0.00,0.00,6.04,320.12,'2022-08-31 16:55:01','',''),(4773,'1','277','1',1,'Retail Sale Id 4793',997.36,0.00,0.00,1.37,72.61,'2022-08-31 17:01:05','',''),(4774,'1','277','1',1,'Retail Sale Id 4794',1499.68,0.00,0.00,2.06,109.18,'2022-08-31 17:05:06','',''),(4775,'1','277','1',1,'Retail Sale Id 4795',4397.12,0.00,0.00,6.04,320.12,'2022-08-31 17:06:56','',''),(4776,'1','277','1',1,'Retail Sale Id 4796',14910.00,0.00,0.00,21.00,735.00,'2022-08-31 17:10:40','',''),(4777,'1','277','1',1,'Retail Sale Id 4797',2002.00,0.00,0.00,2.75,145.75,'2022-08-31 17:12:06','',''),(4778,'1','277','1',1,'Retail Sale Id 4798',749.84,0.00,0.00,1.03,54.59,'2022-08-31 17:12:57','',''),(4779,'1','277','1',1,'Retail Sale Id 4799',11640.72,0.00,0.00,15.99,847.47,'2022-08-31 17:16:25','',''),(4780,'1','277','1',1,'Retail Sale Id 4800',4397.12,0.00,0.00,6.04,320.12,'2022-08-31 17:17:16','',''),(4781,'1','277','1',1,'Retail Sale Id 4801',6602.96,0.00,0.00,9.07,480.71,'2022-08-31 17:18:41','',''),(4782,'1','277','1',1,'Retail Sale Id 4802',2198.56,0.00,0.00,3.02,160.06,'2022-08-31 17:31:37','',''),(4783,'1','277','1',1,'Retail Sale Id 4803',3603.60,0.00,0.00,4.95,262.35,'2022-08-31 17:32:46','',''),(4784,'1','277','1',1,'Retail Sale Id 4804',1499.68,0.00,0.00,2.06,109.18,'2022-08-31 17:36:35','',''),(4785,'1','277','1',1,'Retail Sale Id 4805',3996.72,0.00,0.00,5.49,290.97,'2022-08-31 17:37:59','',''),(4786,'1','277','1',1,'Retail Sale Id 4806',2198.56,0.00,0.00,3.02,160.06,'2022-08-31 17:42:23','',''),(4787,'1','277','1',1,'Retail Sale Id 4807',11000.08,0.00,0.00,15.11,800.83,'2022-08-31 17:46:54','',''),(4788,'1','277','1',1,'Retail Sale Id 4808',9100.00,0.00,0.00,12.50,662.50,'2022-08-31 17:48:19','',''),(4789,'1','277','1',1,'Retail Sale Id 4809',2198.56,0.00,0.00,3.02,160.06,'2022-08-31 17:50:30','',''),(4790,'1','277','1',1,'Retail Sale Id 4810',997.36,0.00,0.00,1.37,72.61,'2022-08-31 17:51:50','',''),(4791,'1','277','1',1,'Retail Sale Id 4811',5001.36,0.00,0.00,6.87,364.11,'2022-08-31 17:52:40','',''),(4792,'1','277','1',1,'Retail Sale Id 4812',5001.36,0.00,0.00,6.87,364.11,'2022-08-31 18:02:29','',''),(4793,'1','277','1',1,'Retail Sale Id 4813',1499.68,0.00,0.00,2.06,109.18,'2022-08-31 18:04:13','',''),(4794,'1','277','1',1,'Retail Sale Id 4814',4397.12,0.00,0.00,6.04,320.12,'2022-08-31 18:14:53','',''),(4795,'1','277','1',1,'Retail Sale Id 4815',11298.56,0.00,0.00,15.52,822.56,'2022-08-31 18:19:38','',''),(4796,'1','277','1',1,'Retail Sale Id 4816',1499.68,0.00,0.00,2.06,109.18,'2022-08-31 18:21:42','',''),(4797,'1','277','1',1,'Retail Sale Id 4817',997.36,0.00,0.00,1.37,72.61,'2022-08-31 18:22:23','',''),(4798,'1','277','1',1,'Retail Sale Id 4818',4368.00,0.00,0.00,6.00,318.00,'2022-08-31 18:25:12','',''),(4799,'1','277','1',1,'Retail Sale Id 4819',2198.56,0.00,0.00,3.02,160.06,'2022-08-31 18:32:18','',''),(4800,'1','277','1',1,'Retail Sale Id 4820',997.36,0.00,0.00,1.37,72.61,'2022-08-31 18:35:23','',''),(4801,'1','277','1',1,'Retail Sale Id 4821',2198.56,0.00,0.00,3.02,160.06,'2022-08-31 18:37:22','',''),(4802,'1','277','1',1,'Retail Sale Id 4822',2497.04,0.00,0.00,3.43,181.79,'2022-08-31 18:40:28','',''),(4803,'1','277','1',1,'Retail Sale Id 4823',2999.36,0.00,0.00,4.12,218.36,'2022-08-31 18:41:26','',''),(4804,'1','277','1',1,'Retail Sale Id 4824',4397.12,0.00,0.00,6.04,320.12,'2022-08-31 18:42:34','',''),(4805,'1','277','1',1,'Retail Sale Id 4825',2999.36,0.00,0.00,4.12,218.36,'2022-08-31 18:44:34','',''),(4806,'1','277','1',1,'Retail Sale Id 4826',5001.36,0.00,0.00,6.87,364.11,'2022-08-31 18:45:24','',''),(4807,'1','277','1',1,'Retail Sale Id 4827',5001.36,0.00,0.00,6.87,364.11,'2022-08-31 18:49:51','',''),(4808,'1','277','1',1,'Retail Sale Id 4828',2497.04,0.00,0.00,3.43,181.79,'2022-08-31 18:53:37','',''),(4809,'1','277','1',1,'Retail Sale Id 4829',7280.00,0.00,0.00,10.00,530.00,'2022-08-31 18:54:13','',''),(4810,'1','277','1',1,'Retail Sale Id 4830',2198.56,0.00,0.00,3.02,160.06,'2022-08-31 18:56:36','',''),(4811,'1','277','1',1,'Retail Sale Id 4831',2198.56,0.00,0.00,3.02,160.06,'2022-08-31 18:58:05','',''),(4812,'1','277','1',1,'Retail Sale Id 4832',4397.12,0.00,0.00,6.04,320.12,'2022-08-31 19:00:13','',''),(4813,'1','277','1',1,'Retail Sale Id 4833',9100.00,0.00,0.00,12.50,662.50,'2022-08-31 19:07:51','',''),(4814,'1','277','1',1,'Retail Sale Id 4834',502.32,0.00,0.00,0.69,36.57,'2022-08-31 19:10:09','',''),(4815,'1','277','1',1,'Retail Sale Id 4835',749.84,0.00,0.00,1.03,54.59,'2022-08-31 19:11:18','',''),(4816,'1','277','1',1,'Retail Sale Id 4836',2999.36,0.00,0.00,4.12,218.36,'2022-08-31 19:17:39','',''),(4817,'1','277','1',1,'Retail Sale Id 4837',902.72,0.00,0.00,1.24,65.72,'2022-08-31 19:18:15','',''),(4818,'1','277','1',1,'Retail Sale Id 4838',3996.72,0.00,0.00,5.49,290.97,'2022-08-31 19:26:57','',''),(4819,'1','277','1',1,'Return of Retail Sale Id 4837',0.00,902.72,1.24,0.00,-65.72,'2022-08-31 19:39:45','',''),(4820,'1','277','1',1,'Retail Sale Id 4839',808.08,0.00,0.00,1.11,58.83,'2022-08-31 19:40:45','',''),(4821,'1','277','1',1,'Retail Sale Id 4840',7.28,0.00,0.00,0.01,0.53,'2022-08-31 19:42:46','',''),(4822,'1','277','1',1,'Retail Sale Id 4841',5001.36,0.00,0.00,6.87,364.11,'2022-09-01 06:51:14','',''),(4823,'1','277','1',1,'Retail Sale Id 4842',2497.04,0.00,0.00,3.43,181.79,'2022-09-01 07:15:35','',''),(4824,'1','277','1',1,'Retail Sale Id 4843',2198.56,0.00,0.00,3.02,160.06,'2022-09-01 07:16:27','',''),(4825,'1','277','1',1,'Retail Sale Id 4845',1499.68,0.00,0.00,2.06,109.18,'2022-09-01 08:21:10','',''),(4826,'1','277','1',1,'Retail Sale Id 4846',3996.72,0.00,0.00,5.49,290.97,'2022-09-01 08:22:16','',''),(4827,'1','277','1',1,'Retail Sale Id 4847',2198.56,0.00,0.00,3.02,160.06,'2022-09-01 08:29:23','',''),(4828,'1','277','1',1,'Retail Sale Id 4848',1499.68,0.00,0.00,2.06,109.18,'2022-09-01 08:32:07','',''),(4829,'1','277','1',1,'Retail Sale Id 4849',9100.00,0.00,0.00,12.50,662.50,'2022-09-01 08:42:28','',''),(4830,'1','277','1',1,'Retail Sale Id 4850',997.36,0.00,0.00,1.37,72.61,'2022-09-01 08:43:26','',''),(4831,'1','277','1',1,'Retail Sale Id 4851',2002.00,0.00,0.00,2.75,145.75,'2022-09-01 08:47:17','',''),(4832,'1','277','1',1,'Retail Sale Id 4852',2999.36,0.00,0.00,4.12,218.36,'2022-09-01 08:51:54','',''),(4833,'1','277','1',1,'Retail Sale Id 4853',3698.24,0.00,0.00,5.08,269.24,'2022-09-01 08:59:18','',''),(4834,'1','277','1',1,'Retail Sale Id 4854',2198.56,0.00,0.00,3.02,160.06,'2022-09-01 09:01:49','',''),(4835,'1','277','1',1,'Retail Sale Id 4855',2002.00,0.00,0.00,2.75,145.75,'2022-09-01 09:04:18','',''),(4836,'1','277','1',1,'Retail Sale Id 4856',2999.36,0.00,0.00,4.12,218.36,'2022-09-01 09:06:03','',''),(4837,'1','277','1',1,'Retail Sale Id 4857',2497.04,0.00,0.00,3.43,181.79,'2022-09-01 09:08:15','',''),(4838,'1','277','1',1,'Retail Sale Id 4858',4397.12,0.00,0.00,6.04,320.12,'2022-09-01 09:23:47','',''),(4839,'1','277','1',1,'Retail Sale Id 4859',2497.04,0.00,0.00,3.43,181.79,'2022-09-01 09:30:30','',''),(4840,'1','277','1',1,'Retail Sale Id 4860',2096.64,0.00,0.00,2.88,152.64,'2022-09-01 09:32:12','',''),(4841,'1','277','1',1,'Retail Sale Id 4861',2002.00,0.00,0.00,2.75,145.75,'2022-09-01 09:40:50','',''),(4842,'1','277','1',1,'Retail Sale Id 4862',22502.48,0.00,0.00,30.91,1638.23,'2022-09-01 09:46:56','',''),(4843,'1','277','1',1,'Retail Sale Id 4863',20347.60,0.00,0.00,27.95,1481.35,'2022-09-01 09:49:25','',''),(4844,'1','277','1',1,'Retail Sale Id 4864',2002.00,0.00,0.00,2.75,145.75,'2022-09-01 09:54:30','',''),(4845,'1','277','1',1,'Retail Sale Id 4865',3996.72,0.00,0.00,5.49,290.97,'2022-09-01 09:56:08','',''),(4846,'1','277','1',1,'Retail Sale Id 4866',4368.00,0.00,0.00,6.00,318.00,'2022-09-01 10:03:00','',''),(4847,'1','277','1',1,'Retail Sale Id 4867',4397.12,0.00,0.00,6.04,320.12,'2022-09-01 10:05:50','',''),(4848,'1','277','1',1,'Retail Sale Id 4868',1499.68,0.00,0.00,2.06,109.18,'2022-09-01 10:06:55','',''),(4849,'1','277','1',1,'Retail Sale Id 4869',2999.36,0.00,0.00,4.12,218.36,'2022-09-01 10:08:02','',''),(4850,'1','277','1',1,'Retail Sale Id 4870',749.84,0.00,0.00,1.03,54.59,'2022-09-01 10:09:21','',''),(4851,'1','277','1',1,'Retail Sale Id 4871',2198.56,0.00,0.00,3.02,160.06,'2022-09-01 10:14:45','',''),(4852,'1','277','1',1,'Retail Sale Id 4871',9100.00,0.00,0.00,12.50,662.50,'2022-09-01 10:14:45','',''),(4853,'1','277','1',1,'Retail Sale Id 4872',2002.00,0.00,0.00,2.75,145.75,'2022-09-01 10:15:51','',''),(4854,'1','277','1',1,'Retail Sale Id 4873',4397.12,0.00,0.00,6.04,320.12,'2022-09-01 10:16:43','',''),(4855,'1','277','1',1,'Retail Sale Id 4874',3640.00,0.00,0.00,5.00,265.00,'2022-09-01 10:17:49','',''),(4856,'1','277','1',1,'Retail Sale Id 4875',9100.00,0.00,0.00,12.50,662.50,'2022-09-01 10:18:48','',''),(4857,'1','277','1',1,'Retail Sale Id 4876',2999.36,0.00,0.00,4.12,218.36,'2022-09-01 10:19:37','',''),(4858,'1','277','1',1,'Retail Sale Id 4877',2999.36,0.00,0.00,4.12,218.36,'2022-09-01 10:22:23','',''),(4859,'1','277','1',1,'Retail Sale Id 4878',9100.00,0.00,0.00,12.50,662.50,'2022-09-01 10:23:38','',''),(4860,'1','277','1',1,'Retail Sale Id 4879',2999.36,0.00,0.00,4.12,218.36,'2022-09-01 10:26:46','',''),(4861,'1','277','1',1,'Retail Sale Id 4880',4499.04,0.00,0.00,6.18,327.54,'2022-09-01 10:27:54','',''),(4862,'1','277','1',1,'Retail Sale Id 4881',4397.12,0.00,0.00,6.04,320.12,'2022-09-01 10:34:43','',''),(4863,'1','277','1',1,'Retail Sale Id 4882',1499.68,0.00,0.00,2.06,109.18,'2022-09-01 10:35:41','',''),(4864,'1','277','1',1,'Retail Sale Id 4883',902.72,0.00,0.00,1.24,65.72,'2022-09-01 10:37:41','',''),(4865,'1','277','1',1,'Retail Sale Id 4884',1499.68,0.00,0.00,2.06,109.18,'2022-09-01 10:41:18','',''),(4866,'1','277','1',1,'Retail Sale Id 4885',1499.68,0.00,0.00,2.06,109.18,'2022-09-01 13:05:23','',''),(4867,'1','277','1',1,'Retail Sale Id 4886',4397.12,0.00,0.00,6.04,320.12,'2022-09-01 13:07:05','',''),(4868,'1','277','1',1,'Retail Sale Id 4887',8998.08,0.00,0.00,12.36,655.08,'2022-09-01 13:07:59','',''),(4869,'1','277','1',1,'Retail Sale Id 4888',5001.36,0.00,0.00,6.87,364.11,'2022-09-01 13:08:40','',''),(4870,'1','277','1',1,'Retail Sale Id 4889',9100.00,0.00,0.00,12.50,662.50,'2022-09-01 13:09:30','',''),(4871,'1','277','1',1,'Retail Sale Id 4890',2002.00,0.00,0.00,2.75,145.75,'2022-09-01 13:10:32','',''),(4872,'1','277','1',1,'Retail Sale Id 4891',2999.36,0.00,0.00,4.12,218.36,'2022-09-01 13:11:17','',''),(4873,'1','277','1',1,'Retail Sale Id 4892',4397.12,0.00,0.00,6.04,320.12,'2022-09-01 13:15:34','',''),(4874,'1','277','1',1,'Retail Sale Id 4893',7280.00,0.00,0.00,10.00,530.00,'2022-09-01 13:18:53','',''),(4875,'1','277','1',1,'Retail Sale Id 4894',9100.00,0.00,0.00,12.50,662.50,'2022-09-01 13:21:04','',''),(4876,'1','277','1',1,'Retail Sale Id 4895',1499.68,0.00,0.00,2.06,109.18,'2022-09-01 13:22:05','',''),(4877,'1','277','1',1,'Retail Sale Id 4896',997.36,0.00,0.00,1.37,72.61,'2022-09-01 13:26:07','',''),(4878,'1','277','1',1,'Retail Sale Id 4897',2002.00,0.00,0.00,2.75,145.75,'2022-09-01 13:30:59','',''),(4879,'1','277','1',1,'Retail Sale Id 4898',4397.12,0.00,0.00,6.04,320.12,'2022-09-01 13:44:02','',''),(4880,'1','277','1',1,'Retail Sale Id 4899',1499.68,0.00,0.00,2.06,109.18,'2022-09-01 13:44:55','',''),(4881,'1','277','1',1,'Retail Sale Id 4900',4397.12,0.00,0.00,6.04,320.12,'2022-09-01 13:45:56','',''),(4882,'1','277','1',1,'Retail Sale Id 4901',1499.68,0.00,0.00,2.06,109.18,'2022-09-01 13:57:20','',''),(4883,'1','277','1',1,'Retail Sale Id 4902',800.80,0.00,0.00,1.10,58.30,'2022-09-01 14:05:30','',''),(4884,'1','277','1',1,'Retail Sale Id 4903',8008.00,0.00,0.00,11.00,583.00,'2022-09-01 14:32:42','',''),(4885,'1','277','1',1,'Retail Sale Id 4904',2198.56,0.00,0.00,3.02,160.06,'2022-09-01 14:33:25','',''),(4886,'1','277','1',1,'Retail Sale Id 4906',1499.68,0.00,0.00,2.06,109.18,'2022-09-01 14:41:27','',''),(4887,'1','277','1',1,'Retail Sale Id 4906',4397.12,0.00,0.00,6.04,320.12,'2022-09-01 14:41:27','',''),(4888,'1','277','1',1,'Retail Sale Id 4907',2184.00,0.00,0.00,3.00,159.00,'2022-09-01 14:44:42','',''),(4889,'1','277','1',1,'Retail Sale Id 4908',2198.56,0.00,0.00,3.02,160.06,'2022-09-01 14:47:18','',''),(4890,'1','277','1',1,'Retail Sale Id 4909',2002.00,0.00,0.00,2.75,145.75,'2022-09-01 14:48:03','',''),(4891,'1','277','1',1,'Retail Sale Id 4910',902.72,0.00,0.00,1.24,65.72,'2022-09-01 15:04:10','',''),(4892,'1','277','1',1,'Retail Sale Id 4911',997.36,0.00,0.00,1.37,72.61,'2022-09-01 15:05:35','',''),(4893,'1','277','1',1,'Retail Sale Id 4912',5103.28,0.00,0.00,7.01,371.53,'2022-09-01 15:16:40','',''),(4894,'1','277','1',1,'Retail Sale Id 4913',8000.72,0.00,0.00,10.99,582.47,'2022-09-01 15:29:57','',''),(4895,'1','277','1',1,'Retail Sale Id 4914',3640.00,0.00,0.00,5.00,265.00,'2022-09-01 15:32:01','',''),(4896,'1','277','1',1,'Retail Sale Id 4915',9100.00,0.00,0.00,12.50,662.50,'2022-09-01 15:33:08','',''),(4897,'1','277','1',1,'Retail Sale Id 4916',2999.36,0.00,0.00,4.12,218.36,'2022-09-01 15:34:03','',''),(4898,'1','277','1',1,'Retail Sale Id 4917',3647.28,0.00,0.00,5.01,265.53,'2022-09-01 15:59:37','',''),(4899,'1','277','1',1,'Retail Sale Id 4918',2002.00,0.00,0.00,2.75,145.75,'2022-09-01 16:00:33','',''),(4900,'1','277','1',1,'Retail Sale Id 4919',4397.12,0.00,0.00,6.04,320.12,'2022-09-01 16:01:10','',''),(4901,'1','277','1',1,'Retail Sale Id 4920',2999.36,0.00,0.00,4.12,218.36,'2022-09-01 16:05:19','',''),(4902,'1','277','1',1,'Retail Sale Id 4921',1499.68,0.00,0.00,2.06,109.18,'2022-09-01 16:09:16','',''),(4903,'1','277','1',1,'Retail Sale Id 4922',2198.56,0.00,0.00,3.02,160.06,'2022-09-01 16:10:00','',''),(4904,'1','277','1',1,'Retail Sale Id 4923',3640.00,0.00,0.00,5.00,265.00,'2022-09-01 16:11:30','',''),(4905,'1','277','1',1,'Retail Sale Id 4924',1798.16,0.00,0.00,2.47,130.91,'2022-09-01 16:12:58','',''),(4906,'1','277','1',1,'Retail Sale Id 4925',2002.00,0.00,0.00,2.75,145.75,'2022-09-01 16:15:09','',''),(4907,'1','277','1',1,'Retail Sale Id 4926',9100.00,0.00,0.00,12.50,662.50,'2022-09-01 16:16:36','',''),(4908,'1','277','1',1,'Retail Sale Id 4927',1499.68,0.00,0.00,2.06,109.18,'2022-09-01 16:21:11','',''),(4909,'1','277','1',1,'Retail Sale Id 4929',3698.24,0.00,0.00,5.08,269.24,'2022-09-01 16:24:59','',''),(4910,'1','277','1',1,'Retail Sale Id 4930',2402.40,0.00,0.00,3.30,174.90,'2022-09-01 16:26:10','',''),(4911,'1','277','1',1,'Retail Sale Id 4931',3501.68,0.00,0.00,4.81,254.93,'2022-09-01 16:27:55','',''),(4912,'1','277','1',1,'Retail Sale Id 4932',2198.56,0.00,0.00,3.02,160.06,'2022-09-01 16:30:08','',''),(4913,'1','277','1',1,'Retail Sale Id 4933',1499.68,0.00,0.00,2.06,109.18,'2022-09-01 16:33:00','',''),(4914,'1','277','1',1,'Retail Sale Id 4934',4397.12,0.00,0.00,6.04,320.12,'2022-09-01 16:36:37','',''),(4915,'1','277','1',1,'Retail Sale Id 4935',2002.00,0.00,0.00,2.75,145.75,'2022-09-01 16:38:16','',''),(4916,'1','277','1',1,'Retail Sale Id 4936',2002.00,0.00,0.00,2.75,145.75,'2022-09-01 16:39:00','',''),(4917,'1','277','1',1,'Retail Sale Id 4937',1499.68,0.00,0.00,2.06,109.18,'2022-09-01 16:39:41','',''),(4918,'1','277','1',1,'Retail Sale Id 4938',749.84,0.00,0.00,1.03,54.59,'2022-09-01 16:40:24','',''),(4919,'1','277','1',1,'Retail Sale Id 4939',4368.00,0.00,0.00,6.00,318.00,'2022-09-01 16:42:30','',''),(4920,'1','277','1',1,'Retail Sale Id 4940',1499.68,0.00,0.00,2.06,109.18,'2022-09-01 16:50:00','',''),(4921,'1','277','1',1,'Retail Sale Id 4941',3996.72,0.00,0.00,5.49,290.97,'2022-09-01 16:53:06','',''),(4922,'1','277','1',1,'Retail Sale Id 4942',2999.36,0.00,0.00,4.12,218.36,'2022-09-01 16:55:58','',''),(4923,'1','277','1',1,'Retail Sale Id 4943',1499.68,0.00,0.00,2.06,109.18,'2022-09-01 16:59:51','',''),(4924,'1','277','1',1,'Retail Sale Id 4944',1499.68,0.00,0.00,2.06,109.18,'2022-09-01 17:01:00','',''),(4925,'1','277','1',1,'Retail Sale Id 4945',2002.00,0.00,0.00,2.75,145.75,'2022-09-01 17:01:37','',''),(4926,'1','277','1',1,'Retail Sale Id 4946',2002.00,0.00,0.00,2.75,145.75,'2022-09-01 17:02:12','',''),(4927,'1','277','1',1,'Retail Sale Id 4947',2198.56,0.00,0.00,3.02,160.06,'2022-09-01 17:03:53','',''),(4928,'1','277','1',1,'Retail Sale Id 4948',2198.56,0.00,0.00,3.02,160.06,'2022-09-01 17:07:25','',''),(4929,'1','277','1',1,'Retail Sale Id 4949',698.88,0.00,0.00,0.96,50.88,'2022-09-01 17:09:51','',''),(4930,'1','277','1',1,'Retail Sale Id 4950',800.80,0.00,0.00,1.10,58.30,'2022-09-01 17:10:32','',''),(4931,'1','277','1',1,'Retail Sale Id 4951',4397.12,0.00,0.00,6.04,320.12,'2022-09-01 17:11:17','',''),(4932,'1','277','1',1,'Retail Sale Id 4952',4397.12,0.00,0.00,6.04,320.12,'2022-09-01 17:12:04','',''),(4933,'1','277','1',1,'Retail Sale Id 4953',2999.36,0.00,0.00,4.12,218.36,'2022-09-01 17:13:04','',''),(4934,'1','277','1',1,'Retail Sale Id 4954',9100.00,0.00,0.00,12.50,662.50,'2022-09-01 17:21:03','',''),(4935,'1','277','1',1,'Retail Sale Id 4956',2802.80,0.00,0.00,3.85,204.05,'2022-09-01 17:23:19','',''),(4936,'1','277','1',1,'Retail Sale Id 4957',2198.56,0.00,0.00,3.02,160.06,'2022-09-01 17:24:09','',''),(4937,'1','277','1',1,'Retail Sale Id 4958',5998.72,0.00,0.00,8.24,436.72,'2022-09-01 17:25:38','',''),(4938,'1','277','1',1,'Retail Sale Id 4959',2999.36,0.00,0.00,4.12,218.36,'2022-09-01 17:26:37','',''),(4939,'1','277','1',1,'Retail Sale Id 4960',2198.56,0.00,0.00,3.02,160.06,'2022-09-01 17:27:33','',''),(4940,'1','277','1',1,'Retail Sale Id 4961',4397.12,0.00,0.00,6.04,320.12,'2022-09-01 17:28:52','',''),(4941,'1','277','1',1,'Retail Sale Id 4962',749.84,0.00,0.00,1.03,54.59,'2022-09-01 17:30:40','',''),(4942,'1','277','1',1,'Retail Sale Id 4963',1499.68,0.00,0.00,2.06,109.18,'2022-09-01 17:31:30','',''),(4943,'1','277','1',1,'Retail Sale Id 4964',2002.00,0.00,0.00,2.75,145.75,'2022-09-01 17:34:53','',''),(4944,'1','277','1',1,'Retail Sale Id 4965',4397.12,0.00,0.00,6.04,320.12,'2022-09-01 17:36:17','',''),(4945,'1','277','1',1,'Retail Sale Id 4966',2198.56,0.00,0.00,3.02,160.06,'2022-09-01 17:37:12','',''),(4946,'1','277','1',1,'Retail Sale Id 4967',4397.12,0.00,0.00,6.04,320.12,'2022-09-01 17:39:16','',''),(4947,'1','277','1',1,'Retail Sale Id 4968',9100.00,0.00,0.00,12.50,662.50,'2022-09-01 17:40:50','',''),(4948,'1','277','1',1,'Retail Sale Id 4970',2002.00,0.00,0.00,2.75,145.75,'2022-09-01 17:44:33','',''),(4949,'1','277','1',1,'Retail Sale Id 4971',2999.36,0.00,0.00,4.12,218.36,'2022-09-01 17:51:25','',''),(4950,'1','277','1',1,'Retail Sale Id 4972',1499.68,0.00,0.00,2.06,109.18,'2022-09-01 17:52:31','',''),(4951,'1','277','1',1,'Retail Sale Id 4973',9100.00,0.00,0.00,12.50,662.50,'2022-09-01 17:56:19','',''),(4952,'1','277','1',1,'Retail Sale Id 4974',9100.00,0.00,0.00,12.50,662.50,'2022-09-01 17:57:53','',''),(4953,'1','277','1',1,'Retail Sale Id 4975',1499.68,0.00,0.00,2.06,109.18,'2022-09-01 17:58:58','',''),(4954,'1','277','1',1,'Retail Sale Id 4976',9100.00,0.00,0.00,12.50,662.50,'2022-09-01 18:01:27','',''),(4955,'1','277','1',1,'Retail Sale Id 4977',1499.68,0.00,0.00,2.06,109.18,'2022-09-01 18:03:52','',''),(4956,'1','277','1',1,'Retail Sale Id 4978',8998.08,0.00,0.00,12.36,655.08,'2022-09-01 18:05:39','',''),(4957,'1','277','1',1,'Retail Sale Id 4979',800.80,0.00,0.00,1.10,58.30,'2022-09-01 18:06:29','',''),(4958,'1','277','1',1,'Retail Sale Id 4980',2198.56,0.00,0.00,3.02,160.06,'2022-09-01 18:16:19','',''),(4959,'1','277','1',1,'Retail Sale Id 4981',997.36,0.00,0.00,1.37,72.61,'2022-09-01 18:17:28','',''),(4960,'1','277','1',1,'Retail Sale Id 4982',7280.00,0.00,0.00,10.00,530.00,'2022-09-01 18:20:23','',''),(4961,'1','277','1',1,'Retail Sale Id 4983',2999.36,0.00,0.00,4.12,218.36,'2022-09-01 18:26:59','',''),(4962,'1','277','1',1,'Retail Sale Id 4984',3996.72,0.00,0.00,5.49,290.97,'2022-09-01 18:27:48','',''),(4963,'1','277','1',1,'Retail Sale Id 4985',9100.00,0.00,0.00,12.50,662.50,'2022-09-01 18:28:47','',''),(4964,'1','277','1',1,'Retail Sale Id 4986',1499.68,0.00,0.00,2.06,109.18,'2022-09-01 18:29:25','',''),(4965,'1','277','1',1,'Retail Sale Id 4987',7280.00,0.00,0.00,10.00,530.00,'2022-09-01 18:31:06','',''),(4966,'1','277','1',1,'Retail Sale Id 4988',502.32,0.00,0.00,0.69,36.57,'2022-09-01 18:32:22','',''),(4967,'1','277','1',1,'Retail Sale Id 4989',1601.60,0.00,0.00,2.20,116.60,'2022-09-01 18:34:47','',''),(4968,'1','277','1',1,'Retail Sale Id 4990',698.88,0.00,0.00,0.96,50.88,'2022-09-01 18:35:37','',''),(4969,'1','277','1',1,'Retail Sale Id 4991',997.36,0.00,0.00,1.37,72.61,'2022-09-01 18:36:12','',''),(4970,'1','277','1',1,'Retail Sale Id 4992',2198.56,0.00,0.00,3.02,160.06,'2022-09-01 18:37:21','',''),(4971,'1','277','1',1,'Retail Sale Id 4993',9100.00,0.00,0.00,12.50,662.50,'2022-09-01 18:40:54','',''),(4972,'1','277','1',1,'Retail Sale Id 4994',2002.00,0.00,0.00,2.75,145.75,'2022-09-01 18:42:00','',''),(4973,'1','277','1',1,'Retail Sale Id 4995',4368.00,0.00,0.00,6.00,318.00,'2022-09-01 18:44:38','',''),(4974,'1','277','1',1,'Retail Sale Id 4996',2999.36,0.00,0.00,4.12,218.36,'2022-09-01 18:45:43','',''),(4975,'1','277','1',1,'Retail Sale Id 4997',2198.56,0.00,0.00,3.02,160.06,'2022-09-01 18:53:28','',''),(4976,'1','277','1',1,'Retail Sale Id 4998',3996.72,0.00,0.00,5.49,290.97,'2022-09-01 18:54:36','',''),(4977,'1','277','1',1,'Retail Sale Id 4999',5001.36,0.00,0.00,6.87,364.11,'2022-09-01 18:57:16','',''),(4978,'1','277','1',1,'Retail Sale Id 5000',2999.36,0.00,0.00,4.12,218.36,'2022-09-01 19:12:18','',''),(4979,'1','277','1',1,'Retail Sale Id 5001',9100.00,0.00,0.00,12.50,662.50,'2022-09-01 19:13:49','',''),(4980,'1','277','1',1,'Retail Sale Id 5002',5998.72,0.00,0.00,8.24,436.72,'2022-09-01 19:16:41','',''),(4981,'1','277','1',1,'Return of Retail Sale Id 5002',0.00,5998.72,8.24,0.00,-436.72,'2022-09-01 19:54:12','',''),(4982,'1','277','1',1,'Retail Sale Id 5003',3399.76,0.00,0.00,4.67,247.51,'2022-09-01 19:55:14','',''),(4983,'1','277','1',1,'Retail Sale Id 5004',2999.36,0.00,0.00,4.12,218.36,'2022-09-02 07:45:04','',''),(4984,'1','277','1',1,'Retail Sale Id 5005',997.36,0.00,0.00,1.37,72.61,'2022-09-02 07:52:04','',''),(4985,'1','277','1',1,'Retail Sale Id 5006',3996.72,0.00,0.00,5.49,290.97,'2022-09-02 07:58:56','',''),(4986,'1','277','1',1,'Retail Sale Id 5007',1499.68,0.00,0.00,2.06,109.18,'2022-09-02 08:02:51','',''),(4987,'1','277','1',1,'Retail Sale Id 5008',2198.56,0.00,0.00,3.02,160.06,'2022-09-02 08:08:04','',''),(4988,'1','277','1',1,'Retail Sale Id 5009',1499.68,0.00,0.00,2.06,109.18,'2022-09-02 08:19:58','',''),(4989,'1','277','1',1,'Retail Sale Id 5010',3501.68,0.00,0.00,4.81,254.93,'2022-09-02 08:21:50','',''),(4990,'1','277','1',1,'Retail Sale Id 5011',1499.68,0.00,0.00,2.06,109.18,'2022-09-02 08:22:46','',''),(4991,'1','277','1',1,'Retail Sale Id 5012',2002.00,0.00,0.00,2.75,145.75,'2022-09-02 08:23:25','',''),(4992,'1','277','1',1,'Retail Sale Id 5013',3996.72,0.00,0.00,5.49,290.97,'2022-09-02 08:34:49','',''),(4993,'1','277','1',1,'Retail Sale Id 5014',2999.36,0.00,0.00,4.12,218.36,'2022-09-02 08:35:29','',''),(4994,'1','277','1',1,'Retail Sale Id 5015',997.36,0.00,0.00,1.37,72.61,'2022-09-02 08:36:30','',''),(4995,'1','277','1',1,'Retail Sale Id 5016',1499.68,0.00,0.00,2.06,109.18,'2022-09-02 08:43:23','',''),(4996,'1','277','1',1,'Retail Sale Id 5017',997.36,0.00,0.00,1.37,72.61,'2022-09-02 08:47:41','',''),(4997,'1','277','1',1,'Retail Sale Id 5017',997.36,0.00,0.00,1.37,72.61,'2022-09-02 08:47:41','',''),(4998,'1','277','1',1,'Retail Sale Id 5017',2002.00,0.00,0.00,2.75,145.75,'2022-09-02 08:47:41','',''),(4999,'1','277','1',1,'Retail Sale Id 5018',2999.36,0.00,0.00,4.12,218.36,'2022-09-02 08:55:40','',''),(5000,'1','277','1',1,'Retail Sale Id 5019',2897.44,0.00,0.00,3.98,210.94,'2022-09-02 08:57:57','',''),(5001,'1','277','1',1,'Retail Sale Id 5020',2198.56,0.00,0.00,3.02,160.06,'2022-09-02 08:59:24','',''),(5002,'1','277','1',1,'Retail Sale Id 5021',3996.72,0.00,0.00,5.49,290.97,'2022-09-02 09:00:21','',''),(5003,'1','277','1',1,'Retail Sale Id 5022',2497.04,0.00,0.00,3.43,181.79,'2022-09-02 09:01:14','',''),(5004,'1','277','1',1,'Retail Sale Id 5023',3647.28,0.00,0.00,5.01,265.53,'2022-09-02 09:06:27','',''),(5005,'1','277','1',1,'Retail Sale Id 5024',1499.68,0.00,0.00,2.06,109.18,'2022-09-02 09:07:08','',''),(5006,'1','277','1',1,'Retail Sale Id 5025',4397.12,0.00,0.00,6.04,320.12,'2022-09-02 09:13:24','',''),(5007,'1','277','1',1,'Retail Sale Id 5026',749.84,0.00,0.00,1.03,54.59,'2022-09-02 09:14:14','',''),(5008,'1','277','1',1,'Retail Sale Id 5027',2198.56,0.00,0.00,3.02,160.06,'2022-09-02 09:16:35','',''),(5009,'1','277','1',1,'Retail Sale Id 5028',2999.36,0.00,0.00,4.12,218.36,'2022-09-02 09:17:40','',''),(5010,'1','277','1',1,'Retail Sale Id 5029',9100.00,0.00,0.00,12.50,662.50,'2022-09-02 09:40:38','',''),(5011,'1','277','1',1,'Retail Sale Id 5030',2002.00,0.00,0.00,2.75,145.75,'2022-09-02 09:43:31','',''),(5012,'1','277','1',1,'Retail Sale Id 5031',2002.00,0.00,0.00,2.75,145.75,'2022-09-02 10:04:00','',''),(5013,'1','277','1',1,'Retail Sale Id 5032',1499.68,0.00,0.00,2.06,109.18,'2022-09-02 10:29:33','',''),(5014,'1','277','1',1,'Retail Sale Id 5033',5001.36,0.00,0.00,6.87,364.11,'2022-09-02 10:49:28','',''),(5015,'1','277','1',1,'Retail Sale Id 5034',3640.00,0.00,0.00,5.00,265.00,'2022-09-02 10:50:38','',''),(5016,'1','277','1',1,'Retail Sale Id 5035',2002.00,0.00,0.00,2.75,145.75,'2022-09-02 10:54:06','',''),(5017,'1','277','1',1,'Retail Sale Id 5036',997.36,0.00,0.00,1.37,72.61,'2022-09-02 11:02:50','',''),(5018,'1','277','1',1,'Retail Sale Id 5037',5998.72,0.00,0.00,8.24,436.72,'2022-09-02 11:07:45','',''),(5019,'1','277','1',1,'Retail Sale Id 5038',2198.56,0.00,0.00,3.02,160.06,'2022-09-02 11:09:05','',''),(5020,'1','277','1',1,'Retail Sale Id 5039',2198.56,0.00,0.00,3.02,160.06,'2022-09-02 11:16:06','',''),(5021,'1','277','1',1,'Return of Retail Sale Id 5034',0.00,3640.00,5.00,0.00,-265.00,'2022-09-02 11:17:14','',''),(5022,'1','277','1',1,'Retail Sale Id 5040',3996.72,0.00,0.00,5.49,290.97,'2022-09-02 11:18:38','',''),(5023,'1','277','1',1,'Retail Sale Id 5041',1499.68,0.00,0.00,2.06,109.18,'2022-09-02 11:28:13','',''),(5024,'1','277','1',1,'Retail Sale Id 5042',1499.68,0.00,0.00,2.06,109.18,'2022-09-02 11:29:00','',''),(5025,'1','277','1',1,'Retail Sale Id 5043',14560.00,0.00,0.00,20.00,1060.00,'2022-09-02 11:31:02','',''),(5026,'1','277','1',1,'Retail Sale Id 5044',4368.00,0.00,0.00,6.00,318.00,'2022-09-02 11:51:46','',''),(5027,'1','277','1',1,'Retail Sale Id 5045',2198.56,0.00,0.00,3.02,160.06,'2022-09-02 11:52:54','',''),(5028,'1','277','1',1,'Retail Sale Id 5045',3698.24,0.00,0.00,5.08,269.24,'2022-09-02 11:52:54','',''),(5029,'1','277','1',1,'Retail Sale Id 5046',800.80,0.00,0.00,1.10,58.30,'2022-09-02 11:53:53','',''),(5030,'1','277','1',1,'Retail Sale Id 5047',4397.12,0.00,0.00,6.04,320.12,'2022-09-02 11:59:08','',''),(5031,'1','277','1',1,'Retail Sale Id 5048',2002.00,0.00,0.00,2.75,145.75,'2022-09-02 11:59:45','',''),(5032,'1','277','1',1,'Retail Sale Id 5049',9100.00,0.00,0.00,12.50,662.50,'2022-09-02 12:01:13','',''),(5033,'1','277','1',1,'Retail Sale Id 5050',3640.00,0.00,0.00,5.00,265.00,'2022-09-02 12:02:39','',''),(5034,'1','277','1',1,'Retail Sale Id 5050',9100.00,0.00,0.00,12.50,662.50,'2022-09-02 12:02:39','',''),(5035,'1','277','1',1,'Retail Sale Id 5051',2497.04,0.00,0.00,3.43,181.79,'2022-09-02 12:08:10','',''),(5036,'1','277','1',1,'Retail Sale Id 5052',2497.04,0.00,0.00,3.43,181.79,'2022-09-02 12:11:48','',''),(5037,'1','277','1',1,'Retail Sale Id 5053',2999.36,0.00,0.00,4.12,218.36,'2022-09-02 12:15:17','',''),(5038,'1','277','1',1,'Retail Sale Id 5054',8998.08,0.00,0.00,12.36,655.08,'2022-09-02 12:18:51','',''),(5039,'1','277','1',1,'Retail Sale Id 5055',2198.56,0.00,0.00,3.02,160.06,'2022-09-02 12:19:40','',''),(5040,'1','277','1',1,'Retail Sale Id 5056',4397.12,0.00,0.00,6.04,320.12,'2022-09-02 12:21:31','',''),(5041,'1','277','1',1,'Retail Sale Id 5057',2999.36,0.00,0.00,4.12,218.36,'2022-09-02 12:23:27','',''),(5042,'1','277','1',1,'Retail Sale Id 5058',3996.72,0.00,0.00,5.49,290.97,'2022-09-02 12:26:38','',''),(5043,'1','277','1',1,'Retail Sale Id 5059',9100.00,0.00,0.00,12.50,662.50,'2022-09-02 12:28:08','',''),(5044,'1','277','1',1,'Retail Sale Id 5060',3996.72,0.00,0.00,5.49,290.97,'2022-09-02 12:30:59','',''),(5045,'1','277','1',1,'Retail Sale Id 5061',2002.00,0.00,0.00,2.75,145.75,'2022-09-02 12:31:35','',''),(5046,'1','277','1',1,'Retail Sale Id 5062',3603.60,0.00,0.00,4.95,262.35,'2022-09-02 12:45:39','',''),(5047,'1','277','1',1,'Retail Sale Id 5063',3996.72,0.00,0.00,5.49,290.97,'2022-09-02 12:46:22','',''),(5048,'1','277','1',1,'Retail Sale Id 5064',2002.00,0.00,0.00,2.75,145.75,'2022-09-02 12:54:54','',''),(5049,'1','277','1',1,'Retail Sale Id 5065',9100.00,0.00,0.00,12.50,662.50,'2022-09-02 13:02:17','',''),(5050,'1','277','1',1,'Retail Sale Id 5066',2198.56,0.00,0.00,3.02,160.06,'2022-09-02 13:03:02','',''),(5051,'1','277','1',1,'Retail Sale Id 5067',4397.12,0.00,0.00,6.04,320.12,'2022-09-02 13:05:13','',''),(5052,'1','277','1',1,'Retail Sale Id 5068',9100.00,0.00,0.00,12.50,662.50,'2022-09-02 13:06:13','',''),(5053,'1','277','1',1,'Retail Sale Id 5069',3647.28,0.00,0.00,5.01,265.53,'2022-09-02 13:07:28','',''),(5054,'1','277','1',1,'Retail Sale Id 5070',800.80,0.00,0.00,1.10,58.30,'2022-09-02 13:08:22','',''),(5055,'1','277','1',1,'Retail Sale Id 5071',218.40,0.00,0.00,0.30,15.90,'2022-09-02 13:12:29','',''),(5056,'1','277','1',1,'Retail Sale Id 5072',2999.36,0.00,0.00,4.12,218.36,'2022-09-02 13:13:47','',''),(5057,'1','277','1',1,'Retail Sale Id 5073',3647.28,0.00,0.00,5.01,265.53,'2022-09-02 13:15:01','',''),(5058,'1','277','1',1,'Retail Sale Id 5074',4397.12,0.00,0.00,6.04,320.12,'2022-09-02 13:16:12','',''),(5059,'1','277','1',1,'Retail Sale Id 5075',2002.00,0.00,0.00,2.75,145.75,'2022-09-02 13:18:41','',''),(5060,'1','277','1',1,'Retail Sale Id 5076',2002.00,0.00,0.00,2.75,145.75,'2022-09-02 13:20:19','',''),(5061,'1','277','1',1,'Retail Sale Id 5077',2198.56,0.00,0.00,3.02,160.06,'2022-09-02 13:23:16','',''),(5062,'1','277','1',1,'Retail Sale Id 5078',2002.00,0.00,0.00,2.75,145.75,'2022-09-02 13:27:21','',''),(5063,'1','277','1',1,'Retail Sale Id 5079',4397.12,0.00,0.00,6.04,320.12,'2022-09-02 13:28:59','',''),(5064,'1','277','1',1,'Retail Sale Id 5080',2198.56,0.00,0.00,3.02,160.06,'2022-09-02 13:36:03','',''),(5065,'1','277','1',1,'Retail Sale Id 5081',1499.68,0.00,0.00,2.06,109.18,'2022-09-02 13:37:29','',''),(5066,'1','277','1',1,'Retail Sale Id 5082',3647.28,0.00,0.00,5.01,265.53,'2022-09-02 13:40:25','',''),(5067,'1','277','1',1,'Retail Sale Id 5083',2999.36,0.00,0.00,4.12,218.36,'2022-09-02 13:46:47','',''),(5068,'1','277','1',1,'Retail Sale Id 5084',1499.68,0.00,0.00,2.06,109.18,'2022-09-02 13:51:45','',''),(5069,'1','277','1',1,'Retail Sale Id 5085',2198.56,0.00,0.00,3.02,160.06,'2022-09-02 13:54:07','',''),(5070,'1','277','1',1,'Retail Sale Id 5086',9100.00,0.00,0.00,12.50,662.50,'2022-09-02 13:58:59','',''),(5071,'1','277','1',1,'Retail Sale Id 5087',2999.36,0.00,0.00,4.12,218.36,'2022-09-02 14:00:14','',''),(5072,'1','277','1',1,'Retail Sale Id 5088',3996.72,0.00,0.00,5.49,290.97,'2022-09-02 14:07:20','',''),(5073,'1','277','1',1,'Retail Sale Id 5089',5998.72,0.00,0.00,8.24,436.72,'2022-09-02 14:13:31','',''),(5074,'1','277','1',1,'Retail Sale Id 5090',2198.56,0.00,0.00,3.02,160.06,'2022-09-02 14:19:19','',''),(5075,'1','277','1',1,'Retail Sale Id 5091',2919.28,0.00,0.00,4.01,212.53,'2022-09-02 14:28:52','',''),(5076,'1','277','1',1,'Retail Sale Id 5092',596.96,0.00,0.00,0.82,43.46,'2022-09-02 14:33:31','',''),(5077,'1','277','1',1,'Retail Sale Id 5093',2198.56,0.00,0.00,3.02,160.06,'2022-09-02 14:34:37','',''),(5078,'1','277','1',1,'Retail Sale Id 5094',2198.56,0.00,0.00,3.02,160.06,'2022-09-02 14:35:16','',''),(5079,'1','277','1',1,'Retail Sale Id 5095',1499.68,0.00,0.00,2.06,109.18,'2022-09-02 14:46:26','',''),(5080,'1','277','1',1,'Retail Sale Id 5095',2002.00,0.00,0.00,2.75,145.75,'2022-09-02 14:46:26','',''),(5081,'1','277','1',1,'Retail Sale Id 5096',9100.00,0.00,0.00,12.50,662.50,'2022-09-02 14:47:21','',''),(5082,'1','277','1',1,'Retail Sale Id 5097',2002.00,0.00,0.00,2.75,145.75,'2022-09-02 14:48:24','',''),(5083,'1','277','1',1,'Retail Sale Id 5098',800.80,0.00,0.00,1.10,58.30,'2022-09-02 14:50:58','',''),(5084,'1','277','1',1,'Retail Sale Id 5099',997.36,0.00,0.00,1.37,72.61,'2022-09-02 14:52:21','',''),(5085,'1','277','1',1,'Retail Sale Id 5100',2198.56,0.00,0.00,3.02,160.06,'2022-09-02 14:57:45','',''),(5086,'1','277','1',1,'Retail Sale Id 5101',2198.56,0.00,0.00,3.02,160.06,'2022-09-02 14:59:19','',''),(5087,'1','277','1',1,'Retail Sale Id 5102',3647.28,0.00,0.00,5.01,265.53,'2022-09-02 15:01:37','',''),(5088,'1','277','1',1,'Retail Sale Id 5103',3698.24,0.00,0.00,5.08,269.24,'2022-09-02 15:09:13','',''),(5089,'1','277','1',1,'Retail Sale Id 5104',2198.56,0.00,0.00,3.02,160.06,'2022-09-02 15:11:19','',''),(5090,'1','277','1',1,'Retail Sale Id 5105',3996.72,0.00,0.00,5.49,290.97,'2022-09-02 15:14:02','',''),(5091,'1','277','1',1,'Retail Sale Id 5106',502.32,0.00,0.00,0.69,36.57,'2022-09-02 15:15:48','',''),(5092,'1','277','1',1,'Retail Sale Id 5107',2999.36,0.00,0.00,4.12,218.36,'2022-09-02 15:19:41','',''),(5093,'1','277','1',1,'Retail Sale Id 5108',3996.72,0.00,0.00,5.49,290.97,'2022-09-02 15:20:21','',''),(5094,'1','277','1',1,'Retail Sale Id 5109',1499.68,0.00,0.00,2.06,109.18,'2022-09-02 15:23:53','',''),(5095,'1','277','1',1,'Retail Sale Id 5110',9100.00,0.00,0.00,12.50,662.50,'2022-09-02 15:26:12','',''),(5096,'1','277','1',1,'Retail Sale Id 5111',3996.72,0.00,0.00,5.49,290.97,'2022-09-02 15:30:27','',''),(5097,'1','277','1',1,'Retail Sale Id 5112',2002.00,0.00,0.00,2.75,145.75,'2022-09-02 15:31:09','',''),(5098,'1','277','1',1,'Retail Sale Id 5113',1499.68,0.00,0.00,2.06,109.18,'2022-09-02 15:31:41','',''),(5099,'1','277','1',1,'Retail Sale Id 5114',4397.12,0.00,0.00,6.04,320.12,'2022-09-02 15:37:19','',''),(5100,'1','277','1',1,'Retail Sale Id 5115',1499.68,0.00,0.00,2.06,109.18,'2022-09-02 15:38:48','',''),(5101,'1','277','1',1,'Retail Sale Id 5116',5001.36,0.00,0.00,6.87,364.11,'2022-09-02 15:40:24','',''),(5102,'1','277','1',1,'Retail Sale Id 5117',2402.40,0.00,0.00,3.30,174.90,'2022-09-02 15:41:51','',''),(5103,'1','277','1',1,'Retail Sale Id 5118',2002.00,0.00,0.00,2.75,145.75,'2022-09-02 15:42:29','',''),(5104,'1','277','1',1,'Retail Sale Id 5119',997.36,0.00,0.00,1.37,72.61,'2022-09-02 15:43:16','',''),(5105,'1','277','1',1,'Retail Sale Id 5120',9100.00,0.00,0.00,12.50,662.50,'2022-09-02 15:47:03','',''),(5106,'1','277','1',1,'Retail Sale Id 5121',997.36,0.00,0.00,1.37,72.61,'2022-09-02 15:51:28','',''),(5107,'1','277','1',1,'Retail Sale Id 5122',2198.56,0.00,0.00,3.02,160.06,'2022-09-02 15:52:45','',''),(5108,'1','277','1',1,'Retail Sale Id 5123',9100.00,0.00,0.00,12.50,662.50,'2022-09-02 15:54:12','',''),(5109,'1','277','1',1,'Retail Sale Id 5124',1499.68,0.00,0.00,2.06,109.18,'2022-09-02 15:58:37','',''),(5110,'1','277','1',1,'Retail Sale Id 5125',18957.00,0.00,0.00,26.70,934.50,'2022-09-02 16:00:16','',''),(5111,'1','277','1',1,'Retail Sale Id 5126',7003.36,0.00,0.00,9.62,509.86,'2022-09-02 16:01:32','',''),(5112,'1','277','1',1,'Retail Sale Id 5127',1397.76,0.00,0.00,1.92,101.76,'2022-09-02 16:02:13','',''),(5113,'1','277','1',1,'Retail Sale Id 5128',2002.00,0.00,0.00,2.75,145.75,'2022-09-02 16:04:04','',''),(5114,'1','277','1',1,'Retail Sale Id 5129',9100.00,0.00,0.00,12.50,662.50,'2022-09-02 16:08:53','',''),(5115,'1','277','1',1,'Retail Sale Id 5131',2002.00,0.00,0.00,2.75,145.75,'2022-09-02 16:10:49','',''),(5116,'1','277','1',1,'Retail Sale Id 5132',2999.36,0.00,0.00,4.12,218.36,'2022-09-02 16:11:28','',''),(5117,'1','277','1',1,'Retail Sale Id 5133',1499.68,0.00,0.00,2.06,109.18,'2022-09-02 16:16:36','',''),(5118,'1','277','1',1,'Retail Sale Id 5134',997.36,0.00,0.00,1.37,72.61,'2022-09-02 16:17:31','',''),(5119,'1','277','1',1,'Retail Sale Id 5135',4397.12,0.00,0.00,6.04,320.12,'2022-09-02 16:18:34','',''),(5120,'1','277','1',1,'Retail Sale Id 5137',4397.12,0.00,0.00,6.04,320.12,'2022-09-02 16:20:09','',''),(5121,'1','277','1',1,'Retail Sale Id 5138',3640.00,0.00,0.00,5.00,265.00,'2022-09-02 16:21:21','',''),(5122,'1','277','1',1,'Retail Sale Id 5139',9100.00,0.00,0.00,12.50,662.50,'2022-09-02 16:23:06','',''),(5123,'1','277','1',1,'Retail Sale Id 5140',4397.12,0.00,0.00,6.04,320.12,'2022-09-02 16:25:59','',''),(5124,'1','277','1',1,'Retail Sale Id 5141',8401.12,0.00,0.00,11.54,611.62,'2022-09-02 16:29:45','',''),(5125,'1','277','1',1,'Retail Sale Id 5142',9100.00,0.00,0.00,12.50,662.50,'2022-09-02 16:31:05','',''),(5126,'1','277','1',1,'Retail Sale Id 5143',2198.56,0.00,0.00,3.02,160.06,'2022-09-02 16:34:29','',''),(5127,'1','277','1',1,'Retail Sale Id 5144',2198.56,0.00,0.00,3.02,160.06,'2022-09-02 16:35:12','',''),(5128,'1','277','1',1,'Retail Sale Id 5145',1397.76,0.00,0.00,1.92,101.76,'2022-09-02 16:36:07','',''),(5129,'1','277','1',1,'Retail Sale Id 5146',997.36,0.00,0.00,1.37,72.61,'2022-09-02 16:42:12','',''),(5130,'1','277','1',1,'Retail Sale Id 5147',4397.12,0.00,0.00,6.04,320.12,'2022-09-02 16:47:13','',''),(5131,'1','277','1',1,'Retail Sale Id 5148',1499.68,0.00,0.00,2.06,109.18,'2022-09-02 16:48:16','',''),(5132,'1','277','1',1,'Retail Sale Id 5149',2002.00,0.00,0.00,2.75,145.75,'2022-09-02 16:53:39','',''),(5133,'1','277','1',1,'Retail Sale Id 5150',2497.04,0.00,0.00,3.43,181.79,'2022-09-02 16:55:41','',''),(5134,'1','277','1',1,'Retail Sale Id 5151',997.36,0.00,0.00,1.37,72.61,'2022-09-02 17:03:38','',''),(5135,'1','277','1',1,'Retail Sale Id 5152',3640.00,0.00,0.00,5.00,265.00,'2022-09-02 17:04:55','',''),(5136,'1','277','1',1,'Retail Sale Id 5153',7003.36,0.00,0.00,9.62,509.86,'2022-09-02 17:07:09','',''),(5137,'1','277','1',1,'Retail Sale Id 5154',1499.68,0.00,0.00,2.06,109.18,'2022-09-02 17:08:02','',''),(5138,'1','277','1',1,'Retail Sale Id 5155',2002.00,0.00,0.00,2.75,145.75,'2022-09-02 17:11:40','',''),(5139,'1','277','1',1,'Retail Sale Id 5156',1499.68,0.00,0.00,2.06,109.18,'2022-09-02 17:30:47','',''),(5140,'1','277','1',1,'Retail Sale Id 5157',9100.00,0.00,0.00,12.50,662.50,'2022-09-02 17:32:24','',''),(5141,'1','277','1',1,'Retail Sale Id 5158',4397.12,0.00,0.00,6.04,320.12,'2022-09-02 17:35:22','',''),(5142,'1','277','1',1,'Retail Sale Id 5159',2999.36,0.00,0.00,4.12,218.36,'2022-09-02 17:37:03','',''),(5143,'1','277','1',1,'Retail Sale Id 5160',997.36,0.00,0.00,1.37,72.61,'2022-09-02 17:40:51','',''),(5144,'1','277','1',1,'Retail Sale Id 5161',2999.36,0.00,0.00,4.12,218.36,'2022-09-02 17:42:24','',''),(5145,'1','277','1',1,'Retail Sale Id 5162',2999.36,0.00,0.00,4.12,218.36,'2022-09-02 17:50:34','',''),(5146,'1','277','1',1,'Retail Sale Id 5163',997.36,0.00,0.00,1.37,72.61,'2022-09-02 17:51:19','',''),(5147,'1','277','1',1,'Retail Sale Id 5164',3698.24,0.00,0.00,5.08,269.24,'2022-09-02 17:55:46','',''),(5148,'1','277','1',1,'Retail Sale Id 5165',4397.12,0.00,0.00,6.04,320.12,'2022-09-02 17:56:23','',''),(5149,'1','277','1',1,'Retail Sale Id 5166',800.80,0.00,0.00,1.10,58.30,'2022-09-02 17:57:14','',''),(5150,'1','277','1',1,'Retail Sale Id 5167',2198.56,0.00,0.00,3.02,160.06,'2022-09-02 18:00:39','',''),(5151,'1','277','1',1,'Retail Sale Id 5168',1499.68,0.00,0.00,2.06,109.18,'2022-09-02 18:01:39','',''),(5152,'1','277','1',1,'Retail Sale Id 5169',800.80,0.00,0.00,1.10,58.30,'2022-09-02 18:02:26','',''),(5153,'1','277','1',1,'Retail Sale Id 5170',2999.36,0.00,0.00,4.12,218.36,'2022-09-02 18:04:02','',''),(5154,'1','277','1',1,'Retail Sale Id 5171',3996.72,0.00,0.00,5.49,290.97,'2022-09-02 18:07:07','',''),(5155,'1','277','1',1,'Retail Sale Id 5172',997.36,0.00,0.00,1.37,72.61,'2022-09-02 18:11:50','',''),(5156,'1','277','1',1,'Retail Sale Id 5173',4499.04,0.00,0.00,6.18,327.54,'2022-09-02 18:13:28','',''),(5157,'1','277','1',1,'Retail Sale Id 5174',2999.36,0.00,0.00,4.12,218.36,'2022-09-02 18:16:56','',''),(5158,'1','277','1',1,'Retail Sale Id 5175',2999.36,0.00,0.00,4.12,218.36,'2022-09-02 18:21:10','',''),(5159,'1','277','1',1,'Retail Sale Id 5176',2198.56,0.00,0.00,3.02,160.06,'2022-09-02 18:22:45','',''),(5160,'1','277','1',1,'Retail Sale Id 5177',4397.12,0.00,0.00,6.04,320.12,'2022-09-02 18:24:54','',''),(5161,'1','277','1',1,'Retail Sale Id 5178',2948.40,0.00,0.00,4.05,214.65,'2022-09-02 18:27:18','',''),(5162,'1','277','1',1,'Retail Sale Id 5179',4397.12,0.00,0.00,6.04,320.12,'2022-09-02 18:28:20','',''),(5163,'1','277','1',1,'Retail Sale Id 5181',9296.56,0.00,0.00,12.77,676.81,'2022-09-02 18:31:34','',''),(5164,'1','277','1',1,'Retail Sale Id 5182',997.36,0.00,0.00,1.37,72.61,'2022-09-02 18:36:42','',''),(5165,'1','277','1',1,'Retail Sale Id 5183',997.36,0.00,0.00,1.37,72.61,'2022-09-02 18:37:16','',''),(5166,'1','277','1',1,'Retail Sale Id 5184',1499.68,0.00,0.00,2.06,109.18,'2022-09-02 18:37:56','',''),(5167,'1','277','1',1,'Retail Sale Id 5185',3996.72,0.00,0.00,5.49,290.97,'2022-09-02 18:39:17','',''),(5168,'1','277','1',1,'Retail Sale Id 5186',3203.20,0.00,0.00,4.40,233.20,'2022-09-02 18:39:57','',''),(5169,'1','277','1',1,'Retail Sale Id 5188',4397.12,0.00,0.00,6.04,320.12,'2022-09-02 18:44:25','',''),(5170,'1','277','1',1,'Retail Sale Id 5189',997.36,0.00,0.00,1.37,72.61,'2022-09-02 18:45:46','',''),(5171,'1','277','1',1,'Retail Sale Id 5190',997.36,0.00,0.00,1.37,72.61,'2022-09-02 18:54:23','',''),(5172,'1','277','1',1,'Retail Sale Id 5191',3800.16,0.00,0.00,5.22,276.66,'2022-09-02 19:00:24','',''),(5173,'1','277','1',1,'Retail Sale Id 5192',2300.48,0.00,0.00,3.16,167.48,'2022-09-02 19:01:52','',''),(5174,'1','277','1',1,'Retail Sale Id 5193',902.72,0.00,0.00,1.24,65.72,'2022-09-02 19:02:30','',''),(5175,'1','277','1',1,'Retail Sale Id 5194',4397.12,0.00,0.00,6.04,320.12,'2022-09-02 19:05:20','',''),(5176,'1','277','1',1,'Retail Sale Id 5195',3698.24,0.00,0.00,5.08,269.24,'2022-09-02 19:08:24','',''),(5177,'1','277','1',1,'Retail Sale Id 5196',4397.12,0.00,0.00,6.04,320.12,'2022-09-02 19:09:43','',''),(5178,'1','277','1',1,'Retail Sale Id 5197',9100.00,0.00,0.00,12.50,662.50,'2022-09-02 19:13:53','',''),(5179,'1','277','1',1,'Retail Sale Id 5198',3996.72,0.00,0.00,5.49,290.97,'2022-09-02 19:15:03','',''),(5180,'1','277','1',1,'Retail Sale Id 5199',36.40,0.00,0.00,0.05,2.65,'2022-09-02 19:39:04','',''),(5181,'1','277','1',1,'Retail Sale Id 5200',2999.36,0.00,0.00,4.12,218.36,'2022-09-03 07:11:13','',''),(5182,'1','277','1',1,'Retail Sale Id 5201',1499.68,0.00,0.00,2.06,109.18,'2022-09-03 07:12:51','',''),(5183,'1','277','1',1,'Retail Sale Id 5202',3996.72,0.00,0.00,5.49,290.97,'2022-09-03 07:17:09','',''),(5184,'1','277','1',1,'Retail Sale Id 5203',2999.36,0.00,0.00,4.12,218.36,'2022-09-03 07:19:59','',''),(5185,'1','277','1',1,'Retail Sale Id 5204',9100.00,0.00,0.00,12.50,662.50,'2022-09-03 07:31:55','',''),(5186,'1','277','1',1,'Retail Sale Id 5205',5001.36,0.00,0.00,6.87,364.11,'2022-09-03 07:33:04','',''),(5187,'1','277','1',1,'Retail Sale Id 5206',1499.68,0.00,0.00,2.06,109.18,'2022-09-03 07:35:20','',''),(5188,'1','277','1',1,'Retail Sale Id 5207',2999.36,0.00,0.00,4.12,218.36,'2022-09-03 07:36:38','',''),(5189,'1','277','1',1,'Retail Sale Id 5208',997.36,0.00,0.00,1.37,72.61,'2022-09-03 07:42:10','',''),(5190,'1','277','1',1,'Retail Sale Id 5209',2198.56,0.00,0.00,3.02,160.06,'2022-09-03 07:47:35','',''),(5191,'1','277','1',1,'Retail Sale Id 5210',2002.00,0.00,0.00,2.75,145.75,'2022-09-03 07:48:26','',''),(5192,'1','277','1',1,'Retail Sale Id 5211',2999.36,0.00,0.00,4.12,218.36,'2022-09-03 07:49:29','',''),(5193,'1','277','1',1,'Retail Sale Id 5212',5001.36,0.00,0.00,6.87,364.11,'2022-09-03 07:52:33','',''),(5194,'1','277','1',1,'Retail Sale Id 5213',3698.24,0.00,0.00,5.08,269.24,'2022-09-03 07:55:46','',''),(5195,'1','277','1',1,'Return of Retail Sale Id 5212',0.00,5001.36,6.87,0.00,-364.11,'2022-09-03 07:57:27','',''),(5196,'1','277','1',1,'Retail Sale Id 5214',6501.04,0.00,0.00,8.93,473.29,'2022-09-03 08:00:56','',''),(5197,'1','277','1',1,'Retail Sale Id 5215',4397.12,0.00,0.00,6.04,320.12,'2022-09-03 08:06:27','',''),(5198,'1','277','1',1,'Retail Sale Id 5216',2198.56,0.00,0.00,3.02,160.06,'2022-09-03 08:07:42','',''),(5199,'1','277','1',1,'Retail Sale Id 5217',3712.80,0.00,0.00,5.10,270.30,'2022-09-03 08:10:05','',''),(5200,'1','277','1',1,'Retail Sale Id 5218',2002.00,0.00,0.00,2.75,145.75,'2022-09-03 08:12:51','',''),(5201,'1','277','1',1,'Retail Sale Id 5219',4302.48,0.00,0.00,5.91,313.23,'2022-09-03 08:15:04','',''),(5202,'1','277','1',1,'Retail Sale Id 5220',800.80,0.00,0.00,1.10,58.30,'2022-09-03 08:23:26','',''),(5203,'1','277','1',1,'Retail Sale Id 5221',9100.00,0.00,0.00,12.50,662.50,'2022-09-03 08:25:51','',''),(5204,'1','277','1',1,'Retail Sale Id 5222',4397.12,0.00,0.00,6.04,320.12,'2022-09-03 08:31:24','',''),(5205,'1','277','1',1,'Retail Sale Id 5224',3661.84,0.00,0.00,5.03,266.59,'2022-09-03 08:34:43','',''),(5206,'1','277','1',1,'Retail Sale Id 5224',8743.28,0.00,0.00,12.01,636.53,'2022-09-03 08:34:43','',''),(5207,'1','277','1',1,'Retail Sale Id 5225',1499.68,0.00,0.00,2.06,109.18,'2022-09-03 08:42:01','',''),(5208,'1','277','1',1,'Retail Sale Id 5226',997.36,0.00,0.00,1.37,72.61,'2022-09-03 08:47:21','',''),(5209,'1','277','1',1,'Retail Sale Id 5227',3640.00,0.00,0.00,5.00,265.00,'2022-09-03 08:49:13','',''),(5210,'1','277','1',1,'Retail Sale Id 5229',3698.24,0.00,0.00,5.08,269.24,'2022-09-03 08:51:06','',''),(5211,'1','277','1',1,'Retail Sale Id 5230',1499.68,0.00,0.00,2.06,109.18,'2022-09-03 08:52:05','',''),(5212,'1','277','1',1,'Retail Sale Id 5231',2198.56,0.00,0.00,3.02,160.06,'2022-09-03 08:52:52','',''),(5213,'1','277','1',1,'Retail Sale Id 5232',2198.56,0.00,0.00,3.02,160.06,'2022-09-03 08:54:44','',''),(5214,'1','277','1',1,'Retail Sale Id 5233',1499.68,0.00,0.00,2.06,109.18,'2022-09-03 08:57:32','',''),(5215,'1','277','1',1,'Retail Sale Id 5234',4397.12,0.00,0.00,6.04,320.12,'2022-09-03 09:05:52','',''),(5216,'1','277','1',1,'Retail Sale Id 5235',1499.68,0.00,0.00,2.06,109.18,'2022-09-03 09:12:37','',''),(5217,'1','277','1',1,'Retail Sale Id 5236',800.80,0.00,0.00,1.10,58.30,'2022-09-03 09:16:24','',''),(5218,'1','277','1',1,'Retail Sale Id 5236',1499.68,0.00,0.00,2.06,109.18,'2022-09-03 09:16:24','',''),(5219,'1','277','1',1,'Retail Sale Id 5237',6552.00,0.00,0.00,9.00,477.00,'2022-09-03 09:22:43','',''),(5220,'1','277','1',1,'Retail Sale Id 5238',1601.60,0.00,0.00,2.20,116.60,'2022-09-03 09:25:44','',''),(5221,'1','277','1',1,'Retail Sale Id 5239',3640.00,0.00,0.00,5.00,265.00,'2022-09-03 09:31:34','',''),(5222,'1','277','1',1,'Retail Sale Id 5240',8939.84,0.00,0.00,12.28,650.84,'2022-09-03 09:37:09','',''),(5223,'1','277',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,1390.50,2.06,0.00,0.00,'2022-09-03 10:19:35','',''),(5224,'1','277',NULL,1,'Reception corrector for bridging 18',0.00,0.00,0.00,2.06,0.00,'2022-09-03 10:21:07','',''),(5225,'1','277','1',1,'Received from bridging 18',0.00,0.00,2.06,0.00,0.00,'2022-09-03 10:21:07','',''),(5226,'1','277','1',1,'Retail Sale Id 5241',1499.68,0.00,0.00,2.06,109.18,'2022-09-03 10:22:16','',''),(5227,'1','277',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,1350000.00,2000.00,0.00,0.00,'2022-09-03 11:33:24','',''),(5228,'1','277',NULL,1,'Reception corrector for bridging 19',0.00,0.00,0.00,2000.00,0.00,'2022-09-03 11:34:54','',''),(5229,'1','277','1',1,'Received from bridging 19',0.00,0.00,2000.00,0.00,0.00,'2022-09-03 11:34:54','',''),(5230,'1','277','1',1,'Retail Sale Id 5242',2002.00,0.00,0.00,2.75,145.75,'2022-09-03 11:41:21','',''),(5231,'1','277','1',1,'Retail Sale Id 5243',1499.68,0.00,0.00,2.06,109.18,'2022-09-03 11:44:50','',''),(5232,'1','277','1',1,'Retail Sale Id 5244',2999.36,0.00,0.00,4.12,218.36,'2022-09-03 11:45:34','',''),(5233,'1','277','1',1,'Retail Sale Id 5245',2999.36,0.00,0.00,4.12,218.36,'2022-09-03 11:46:56','',''),(5234,'1','277','1',1,'Retail Sale Id 5246',5103.28,0.00,0.00,7.01,371.53,'2022-09-03 11:47:50','',''),(5235,'1','277','1',1,'Retail Sale Id 5247',2002.00,0.00,0.00,2.75,145.75,'2022-09-03 11:48:32','',''),(5236,'1','277','1',1,'Retail Sale Id 5248',2300.48,0.00,0.00,3.16,167.48,'2022-09-03 11:49:41','',''),(5237,'1','277','1',1,'Retail Sale Id 5249',4397.12,0.00,0.00,6.04,320.12,'2022-09-03 11:50:21','',''),(5238,'1','277','1',1,'Retail Sale Id 5250',3996.72,0.00,0.00,5.49,290.97,'2022-09-03 11:51:09','',''),(5239,'1','277','1',1,'Retail Sale Id 5251',1499.68,0.00,0.00,2.06,109.18,'2022-09-03 11:51:54','',''),(5240,'1','277','1',1,'Retail Sale Id 5252',1499.68,0.00,0.00,2.06,109.18,'2022-09-03 11:52:26','',''),(5241,'1','277','1',1,'Retail Sale Id 5253',4397.12,0.00,0.00,6.04,320.12,'2022-09-03 11:53:02','',''),(5242,'1','277','1',1,'Retail Sale Id 5254',1397.76,0.00,0.00,1.92,101.76,'2022-09-03 11:54:32','',''),(5243,'1','277','1',1,'Retail Sale Id 5254',1499.68,0.00,0.00,2.06,109.18,'2022-09-03 11:54:32','',''),(5244,'1','277','1',1,'Retail Sale Id 5255',997.36,0.00,0.00,1.37,72.61,'2022-09-03 11:55:12','',''),(5245,'1','277','1',1,'Retail Sale Id 5256',3829.28,0.00,0.00,5.26,278.78,'2022-09-03 11:56:31','',''),(5246,'1','277','1',1,'Retail Sale Id 5257',800.80,0.00,0.00,1.10,58.30,'2022-09-03 11:57:15','',''),(5247,'1','277','1',1,'Retail Sale Id 5258',4499.04,0.00,0.00,6.18,327.54,'2022-09-03 11:58:17','',''),(5248,'1','277','1',1,'Retail Sale Id 5259',9100.00,0.00,0.00,12.50,662.50,'2022-09-03 12:00:03','',''),(5249,'1','277','1',1,'Retail Sale Id 5260',2198.56,0.00,0.00,3.02,160.06,'2022-09-03 12:00:44','',''),(5250,'1','277','1',1,'Retail Sale Id 5261',7280.00,0.00,0.00,10.00,530.00,'2022-09-03 12:01:38','',''),(5251,'1','277','1',1,'Retail Sale Id 5262',2999.36,0.00,0.00,4.12,218.36,'2022-09-03 12:02:26','',''),(5252,'1','277','1',1,'Retail Sale Id 5263',17040.00,0.00,0.00,24.00,840.00,'2022-09-03 12:03:53','',''),(5253,'1','277','1',1,'Retail Sale Id 5264',2919.28,0.00,0.00,4.01,212.53,'2022-09-03 12:05:25','',''),(5254,'1','277','1',1,'Retail Sale Id 5265',2198.56,0.00,0.00,3.02,160.06,'2022-09-03 12:06:55','',''),(5255,'1','277','1',1,'Retail Sale Id 5266',502.32,0.00,0.00,0.69,36.57,'2022-09-03 12:09:11','',''),(5256,'1','277','1',1,'Retail Sale Id 5267',2198.56,0.00,0.00,3.02,160.06,'2022-09-03 12:11:15','',''),(5257,'1','277','1',1,'Retail Sale Id 5268',749.84,0.00,0.00,1.03,54.59,'2022-09-03 12:13:29','',''),(5258,'1','277','1',1,'Retail Sale Id 5269',3640.00,0.00,0.00,5.00,265.00,'2022-09-03 12:15:21','',''),(5259,'1','277','1',1,'Retail Sale Id 5270',4397.12,0.00,0.00,6.04,320.12,'2022-09-03 12:19:42','',''),(5260,'1','277','1',1,'Retail Sale Id 5271',2999.36,0.00,0.00,4.12,218.36,'2022-09-03 12:22:41','',''),(5261,'1','277','1',1,'Retail Sale Id 5272',9100.00,0.00,0.00,12.50,662.50,'2022-09-03 12:24:11','',''),(5262,'1','277','1',1,'Retail Sale Id 5273',749.84,0.00,0.00,1.03,54.59,'2022-09-03 12:25:35','',''),(5263,'1','277','1',1,'Retail Sale Id 5274',1499.68,0.00,0.00,2.06,109.18,'2022-09-03 12:29:54','',''),(5264,'1','277','1',1,'Retail Sale Id 5275',7498.40,0.00,0.00,10.30,545.90,'2022-09-03 12:37:31','',''),(5265,'1','277','1',1,'Retail Sale Id 5276',4499.04,0.00,0.00,6.18,327.54,'2022-09-03 12:43:21','',''),(5266,'1','277','1',1,'Retail Sale Id 5277',4397.12,0.00,0.00,6.04,320.12,'2022-09-03 12:44:29','',''),(5267,'1','277','1',1,'Retail Sale Id 5278',2002.00,0.00,0.00,2.75,145.75,'2022-09-03 12:45:09','',''),(5268,'1','277','1',1,'Retail Sale Id 5279',298.48,0.00,0.00,0.41,21.73,'2022-09-03 12:47:40','',''),(5269,'1','277','1',1,'Retail Sale Id 5280',1499.68,0.00,0.00,2.06,109.18,'2022-09-03 12:58:51','',''),(5270,'1','277','1',1,'Retail Sale Id 5281',997.36,0.00,0.00,1.37,72.61,'2022-09-03 13:01:05','',''),(5271,'1','277','1',1,'Retail Sale Id 5282',4397.12,0.00,0.00,6.04,320.12,'2022-09-03 13:02:22','',''),(5272,'1','277','1',1,'Retail Sale Id 5283',4397.12,0.00,0.00,6.04,320.12,'2022-09-03 13:07:18','',''),(5273,'1','277','1',1,'Retail Sale Id 5284',2249.52,0.00,0.00,3.09,163.77,'2022-09-03 13:09:33','',''),(5274,'1','277','1',1,'Retail Sale Id 5285',8372.00,0.00,0.00,11.50,609.50,'2022-09-03 13:23:27','',''),(5275,'1','277',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,1991250.00,2950.00,0.00,0.00,'2022-09-03 13:28:42','',''),(5276,'1','277',NULL,1,'Reception corrector for bridging 20',0.00,0.00,0.00,2950.00,0.00,'2022-09-03 13:29:59','',''),(5277,'1','277','1',1,'Received from bridging 20',0.00,0.00,2950.00,0.00,0.00,'2022-09-03 13:29:59','',''),(5278,'1','277','1',1,'Retail Sale Id 5286',698.88,0.00,0.00,0.96,50.88,'2022-09-03 13:30:58','',''),(5279,'1','277','1',1,'Retail Sale Id 5287',9100.00,0.00,0.00,12.50,662.50,'2022-09-03 14:16:07','',''),(5280,'1','277','1',1,'Retail Sale Id 5289',4397.12,0.00,0.00,6.04,320.12,'2022-09-03 14:17:44','',''),(5281,'1','277','1',1,'Retail Sale Id 5290',2002.00,0.00,0.00,2.75,145.75,'2022-09-03 14:18:28','',''),(5282,'1','277','1',1,'Retail Sale Id 5291',4397.12,0.00,0.00,6.04,320.12,'2022-09-03 14:19:54','',''),(5283,'1','277','1',1,'Retail Sale Id 5292',4397.12,0.00,0.00,6.04,320.12,'2022-09-03 14:21:11','',''),(5284,'1','277','1',1,'Retail Sale Id 5293',2198.56,0.00,0.00,3.02,160.06,'2022-09-03 14:24:20','',''),(5285,'1','277','1',1,'Retail Sale Id 5293',4397.12,0.00,0.00,6.04,320.12,'2022-09-03 14:24:20','',''),(5286,'1','277','1',1,'Retail Sale Id 5294',2999.36,0.00,0.00,4.12,218.36,'2022-09-03 14:26:57','',''),(5287,'1','277','1',1,'Retail Sale Id 5295',997.36,0.00,0.00,1.37,72.61,'2022-09-03 14:27:51','',''),(5288,'1','277','1',1,'Retail Sale Id 5296',2999.36,0.00,0.00,4.12,218.36,'2022-09-03 14:35:51','',''),(5289,'1','277','1',1,'Retail Sale Id 5297',9100.00,0.00,0.00,12.50,662.50,'2022-09-03 14:38:56','',''),(5290,'1','277','1',1,'Retail Sale Id 5298',2198.56,0.00,0.00,3.02,160.06,'2022-09-03 14:48:08','',''),(5291,'1','277','1',1,'Retail Sale Id 5299',2198.56,0.00,0.00,3.02,160.06,'2022-09-03 14:50:04','',''),(5292,'1','277','1',1,'Retail Sale Id 5300',3647.28,0.00,0.00,5.01,265.53,'2022-09-03 14:51:59','',''),(5293,'1','277','1',1,'Retail Sale Id 5301',2999.36,0.00,0.00,4.12,218.36,'2022-09-03 14:53:21','',''),(5294,'1','277','1',1,'Retail Sale Id 5302',9100.00,0.00,0.00,12.50,662.50,'2022-09-03 14:54:54','',''),(5295,'1','277','1',1,'Retail Sale Id 5303',9100.00,0.00,0.00,12.50,662.50,'2022-09-03 14:56:38','',''),(5296,'1','277','1',1,'Retail Sale Id 5304',3640.00,0.00,0.00,5.00,265.00,'2022-09-03 14:57:38','',''),(5297,'1','277','1',1,'Retail Sale Id 5305',3996.72,0.00,0.00,5.49,290.97,'2022-09-03 14:59:37','',''),(5298,'1','277','1',1,'Retail Sale Id 5306',2497.04,0.00,0.00,3.43,181.79,'2022-09-03 15:05:47','',''),(5299,'1','277','1',1,'Retail Sale Id 5307',2002.00,0.00,0.00,2.75,145.75,'2022-09-03 15:15:24','',''),(5300,'1','277','1',1,'Retail Sale Id 5308',2198.56,0.00,0.00,3.02,160.06,'2022-09-03 15:20:31','',''),(5301,'1','277','1',1,'Retail Sale Id 5309',4397.12,0.00,0.00,6.04,320.12,'2022-09-03 15:23:56','',''),(5302,'1','277','1',1,'Retail Sale Id 5310',997.36,0.00,0.00,1.37,72.61,'2022-09-03 15:25:55','',''),(5303,'1','277','1',1,'Retail Sale Id 5311',4397.12,0.00,0.00,6.04,320.12,'2022-09-03 15:28:07','',''),(5304,'1','277','1',1,'Retail Sale Id 5312',997.36,0.00,0.00,1.37,72.61,'2022-09-03 15:34:16','',''),(5305,'1','277','1',1,'Retail Sale Id 5313',9100.00,0.00,0.00,12.50,662.50,'2022-09-03 15:35:03','',''),(5306,'1','277','1',1,'Retail Sale Id 5314',7280.00,0.00,0.00,10.00,530.00,'2022-09-03 15:37:04','',''),(5307,'1','277','1',1,'Retail Sale Id 5315',2002.00,0.00,0.00,2.75,145.75,'2022-09-03 15:38:04','',''),(5308,'1','277','1',1,'Retail Sale Id 5316',3996.72,0.00,0.00,5.49,290.97,'2022-09-03 15:44:55','',''),(5309,'1','277','1',1,'Retail Sale Id 5317',1201.20,0.00,0.00,1.65,87.45,'2022-09-03 15:48:21','',''),(5310,'1','277','1',1,'Retail Sale Id 5318',4368.00,0.00,0.00,6.00,318.00,'2022-09-03 15:52:36','',''),(5311,'1','277','1',1,'Retail Sale Id 5319',1499.68,0.00,0.00,2.06,109.18,'2022-09-03 15:53:30','',''),(5312,'1','277','1',1,'Retail Sale Id 5320',2198.56,0.00,0.00,3.02,160.06,'2022-09-03 15:54:13','',''),(5313,'1','277','1',1,'Retail Sale Id 5321',9100.00,0.00,0.00,12.50,662.50,'2022-09-03 15:55:12','',''),(5314,'1','277','1',1,'Retail Sale Id 5323',3698.24,0.00,0.00,5.08,269.24,'2022-09-03 15:56:39','',''),(5315,'1','277','1',1,'Retail Sale Id 5324',3698.24,0.00,0.00,5.08,269.24,'2022-09-03 15:57:38','',''),(5316,'1','277','1',1,'Retail Sale Id 5325',1499.68,0.00,0.00,2.06,109.18,'2022-09-03 15:58:19','',''),(5317,'1','277','1',1,'Retail Sale Id 5326',997.36,0.00,0.00,1.37,72.61,'2022-09-03 16:05:22','',''),(5318,'1','277','1',1,'Retail Sale Id 5327',2198.56,0.00,0.00,3.02,160.06,'2022-09-03 16:12:01','',''),(5319,'1','277','1',1,'Retail Sale Id 5328',5998.72,0.00,0.00,8.24,436.72,'2022-09-03 16:13:30','',''),(5320,'1','277','1',1,'Retail Sale Id 5329',997.36,0.00,0.00,1.37,72.61,'2022-09-03 16:14:52','',''),(5321,'1','277','1',1,'Retail Sale Id 5330',2999.36,0.00,0.00,4.12,218.36,'2022-09-03 16:15:44','',''),(5322,'1','277','1',1,'Retail Sale Id 5331',698.88,0.00,0.00,0.96,50.88,'2022-09-03 16:22:41','',''),(5323,'1','277','1',1,'Retail Sale Id 5332',2198.56,0.00,0.00,3.02,160.06,'2022-09-03 16:23:48','',''),(5324,'1','277','1',1,'Retail Sale Id 5333',1397.76,0.00,0.00,1.92,101.76,'2022-09-03 16:24:33','',''),(5325,'1','277','1',1,'Retail Sale Id 5334',4368.00,0.00,0.00,6.00,318.00,'2022-09-03 16:31:42','',''),(5326,'1','277','1',1,'Retail Sale Id 5335',1499.68,0.00,0.00,2.06,109.18,'2022-09-03 16:34:07','',''),(5327,'1','277','1',1,'Retail Sale Id 5336',4397.12,0.00,0.00,6.04,320.12,'2022-09-03 16:38:30','',''),(5328,'1','277','1',1,'Retail Sale Id 5337',4397.12,0.00,0.00,6.04,320.12,'2022-09-03 16:40:47','',''),(5329,'1','277','1',1,'Retail Sale Id 5338',2198.56,0.00,0.00,3.02,160.06,'2022-09-03 16:41:54','',''),(5330,'1','277','1',1,'Retail Sale Id 5339',3698.24,0.00,0.00,5.08,269.24,'2022-09-03 16:43:53','',''),(5331,'1','277','1',1,'Retail Sale Id 5340',9100.00,0.00,0.00,12.50,662.50,'2022-09-03 16:44:35','',''),(5332,'1','277','1',1,'Retail Sale Id 5341',2999.36,0.00,0.00,4.12,218.36,'2022-09-03 16:57:44','',''),(5333,'1','277','1',1,'Retail Sale Id 5342',2198.56,0.00,0.00,3.02,160.06,'2022-09-03 16:58:37','',''),(5334,'1','277','1',1,'Retail Sale Id 5343',1499.68,0.00,0.00,2.06,109.18,'2022-09-03 16:59:21','',''),(5335,'1','277','1',1,'Retail Sale Id 5344',2198.56,0.00,0.00,3.02,160.06,'2022-09-03 17:01:32','',''),(5336,'1','277','1',1,'Retail Sale Id 5345',2999.36,0.00,0.00,4.12,218.36,'2022-09-03 17:03:06','',''),(5337,'1','277','1',1,'Retail Sale Id 5346',3647.28,0.00,0.00,5.01,265.53,'2022-09-03 17:03:56','',''),(5338,'1','277','1',1,'Retail Sale Id 5347',4397.12,0.00,0.00,6.04,320.12,'2022-09-03 17:04:31','',''),(5339,'1','277','1',1,'Retail Sale Id 5348',3698.24,0.00,0.00,5.08,269.24,'2022-09-03 17:06:38','',''),(5340,'1','277','1',1,'Retail Sale Id 5349',2999.36,0.00,0.00,4.12,218.36,'2022-09-03 17:08:01','',''),(5341,'1','277','1',1,'Retail Sale Id 5350',2002.00,0.00,0.00,2.75,145.75,'2022-09-03 17:08:51','',''),(5342,'1','277','1',1,'Retail Sale Id 5351',997.36,0.00,0.00,1.37,72.61,'2022-09-03 17:09:29','',''),(5343,'1','277','1',1,'Retail Sale Id 5352',5103.28,0.00,0.00,7.01,371.53,'2022-09-03 17:11:47','',''),(5344,'1','277','1',1,'Retail Sale Id 5353',3647.28,0.00,0.00,5.01,265.53,'2022-09-03 17:13:51','',''),(5345,'1','277','1',1,'Retail Sale Id 5354',1201.20,0.00,0.00,1.65,87.45,'2022-09-03 17:21:03','',''),(5346,'1','277','1',1,'Retail Sale Id 5355',2198.56,0.00,0.00,3.02,160.06,'2022-09-03 17:22:23','',''),(5347,'1','277','1',1,'Retail Sale Id 5356',997.36,0.00,0.00,1.37,72.61,'2022-09-03 17:27:40','',''),(5348,'1','277','1',1,'Retail Sale Id 5357',3800.16,0.00,0.00,5.22,276.66,'2022-09-03 17:30:31','',''),(5349,'1','277','1',1,'Retail Sale Id 5358',1499.68,0.00,0.00,2.06,109.18,'2022-09-03 17:35:13','',''),(5350,'1','277','1',1,'Retail Sale Id 5359',3603.60,0.00,0.00,4.95,262.35,'2022-09-03 17:36:44','',''),(5351,'1','277','1',1,'Retail Sale Id 5360',1798.16,0.00,0.00,2.47,130.91,'2022-09-03 17:38:00','',''),(5352,'1','277','1',1,'Retail Sale Id 5361',9100.00,0.00,0.00,12.50,662.50,'2022-09-03 17:39:24','',''),(5353,'1','277','1',1,'Retail Sale Id 5362',997.36,0.00,0.00,1.37,72.61,'2022-09-03 17:40:02','',''),(5354,'1','277','1',1,'Retail Sale Id 5363',5001.36,0.00,0.00,6.87,364.11,'2022-09-03 17:41:10','',''),(5355,'1','277','1',1,'Retail Sale Id 5364',3640.00,0.00,0.00,5.00,265.00,'2022-09-03 17:50:04','',''),(5356,'1','277','1',1,'Retail Sale Id 5365',997.36,0.00,0.00,1.37,72.61,'2022-09-03 17:56:05','',''),(5357,'1','277','1',1,'Retail Sale Id 5366',800.80,0.00,0.00,1.10,58.30,'2022-09-03 17:57:19','',''),(5358,'1','277','1',1,'Retail Sale Id 5367',9100.00,0.00,0.00,12.50,662.50,'2022-09-03 17:58:08','',''),(5359,'1','277','1',1,'Retail Sale Id 5368',2300.48,0.00,0.00,3.16,167.48,'2022-09-03 18:00:26','',''),(5360,'1','277','1',1,'Retail Sale Id 5369',2198.56,0.00,0.00,3.02,160.06,'2022-09-03 18:02:16','',''),(5361,'1','277','1',1,'Retail Sale Id 5370',3996.72,0.00,0.00,5.49,290.97,'2022-09-03 18:03:34','',''),(5362,'1','277','1',1,'Retail Sale Id 5371',997.36,0.00,0.00,1.37,72.61,'2022-09-03 18:08:57','',''),(5363,'1','277','1',1,'Retail Sale Id 5372',2198.56,0.00,0.00,3.02,160.06,'2022-09-03 18:11:52','',''),(5364,'1','277','1',1,'Retail Sale Id 5373',997.36,0.00,0.00,1.37,72.61,'2022-09-03 18:19:41','',''),(5365,'1','277','1',1,'Retail Sale Id 5374',1499.68,0.00,0.00,2.06,109.18,'2022-09-03 18:24:35','',''),(5366,'1','277','1',1,'Retail Sale Id 5375',2999.36,0.00,0.00,4.12,218.36,'2022-09-03 18:26:14','',''),(5367,'1','277','1',1,'Retail Sale Id 5376',4499.04,0.00,0.00,6.18,327.54,'2022-09-03 18:26:56','',''),(5368,'1','277','1',1,'Retail Sale Id 5377',3698.24,0.00,0.00,5.08,269.24,'2022-09-03 18:28:36','',''),(5369,'1','277','1',1,'Retail Sale Id 5378',4499.04,0.00,0.00,6.18,327.54,'2022-09-03 18:30:28','',''),(5370,'1','277','1',1,'Retail Sale Id 5379',1798.16,0.00,0.00,2.47,130.91,'2022-09-03 18:31:27','',''),(5371,'1','277','1',1,'Retail Sale Id 5380',2999.36,0.00,0.00,4.12,218.36,'2022-09-03 18:32:30','',''),(5372,'1','277','1',1,'Retail Sale Id 5381',1499.68,0.00,0.00,2.06,109.18,'2022-09-03 18:37:52','',''),(5373,'1','277','1',1,'Retail Sale Id 5382',4302.48,0.00,0.00,5.91,313.23,'2022-09-03 18:44:59','',''),(5374,'1','277','1',1,'Retail Sale Id 5383',4397.12,0.00,0.00,6.04,320.12,'2022-09-03 18:45:34','',''),(5375,'1','277','1',1,'Retail Sale Id 5384',3647.28,0.00,0.00,5.01,265.53,'2022-09-03 18:47:58','',''),(5376,'1','277','1',1,'Retail Sale Id 5385',4397.12,0.00,0.00,6.04,320.12,'2022-09-03 18:48:49','',''),(5377,'1','277','1',1,'Retail Sale Id 5386',800.80,0.00,0.00,1.10,58.30,'2022-09-03 18:49:39','',''),(5378,'1','277','1',1,'Retail Sale Id 5387',2002.00,0.00,0.00,2.75,145.75,'2022-09-03 18:50:31','',''),(5379,'1','277','1',1,'Retail Sale Id 5388',749.84,0.00,0.00,1.03,54.59,'2022-09-03 18:56:44','',''),(5380,'1','277','1',1,'Retail Sale Id 5389',2002.00,0.00,0.00,2.75,145.75,'2022-09-03 19:06:52','',''),(5381,'1','277','1',1,'Retail Sale Id 5391',14560.00,0.00,0.00,20.00,1060.00,'2022-09-03 19:09:28','',''),(5382,'1','277','1',1,'Retail Sale Id 5392',2999.36,0.00,0.00,4.12,218.36,'2022-09-03 19:11:20','',''),(5383,'1','277','1',1,'Retail Sale Id 5393',2198.56,0.00,0.00,3.02,160.06,'2022-09-03 19:15:10','',''),(5384,'1','277','1',1,'Retail Sale Id 5394',1499.68,0.00,0.00,2.06,109.18,'2022-09-03 19:19:19','',''),(5385,'1','277','1',1,'Retail Sale Id 5395',3640.00,0.00,0.00,5.00,265.00,'2022-09-03 19:25:40','',''),(5386,'1','277','1',1,'Retail Sale Id 5396',2002.00,0.00,0.00,2.75,145.75,'2022-09-03 19:27:04','',''),(5387,'1','277','1',1,'Retail Sale Id 5397',749.84,0.00,0.00,1.03,54.59,'2022-09-03 19:29:24','',''),(5388,'1','277','1',1,'Retail Sale Id 5398',3501.68,0.00,0.00,4.81,254.93,'2022-09-03 19:30:03','',''),(5389,'1','277','1',1,'Return of Retail Sale Id 5397',0.00,749.84,1.03,0.00,-54.59,'2022-09-03 19:46:37','',''),(5390,'1','277','1',1,'Retail Sale Id 5399',720.72,0.00,0.00,0.99,52.47,'2022-09-03 19:47:09','',''),(5391,'1','277','1',1,'Retail Sale Id 5400',4397.12,0.00,0.00,6.04,320.12,'2022-09-04 06:43:37','',''),(5392,'1','277','1',1,'Retail Sale Id 5401',997.36,0.00,0.00,1.37,72.61,'2022-09-04 06:44:26','',''),(5393,'1','277','1',1,'Retail Sale Id 5402',4397.12,0.00,0.00,6.04,320.12,'2022-09-04 06:52:30','',''),(5394,'1','277','1',1,'Retail Sale Id 5403',2999.36,0.00,0.00,4.12,218.36,'2022-09-04 07:05:08','',''),(5395,'1','277','1',1,'Retail Sale Id 5404',2999.36,0.00,0.00,4.12,218.36,'2022-09-04 07:12:26','',''),(5396,'1','277','1',1,'Retail Sale Id 5405',3640.00,0.00,0.00,5.00,265.00,'2022-09-04 07:13:28','',''),(5397,'1','277','1',1,'Retail Sale Id 5406',2002.00,0.00,0.00,2.75,145.75,'2022-09-04 07:18:07','',''),(5398,'1','277','1',1,'Retail Sale Id 5407',2999.36,0.00,0.00,4.12,218.36,'2022-09-04 07:25:42','',''),(5399,'1','277','1',1,'Retail Sale Id 5408',1499.68,0.00,0.00,2.06,109.18,'2022-09-04 07:31:28','',''),(5400,'1','277','1',1,'Retail Sale Id 5409',3698.24,0.00,0.00,5.08,269.24,'2022-09-04 07:35:31','',''),(5401,'1','277','1',1,'Retail Sale Id 5410',5001.36,0.00,0.00,6.87,364.11,'2022-09-04 07:38:16','',''),(5402,'1','277','1',1,'Retail Sale Id 5411',2002.00,0.00,0.00,2.75,145.75,'2022-09-04 07:51:15','',''),(5403,'1','277','1',1,'Retail Sale Id 5412',800.80,0.00,0.00,1.10,58.30,'2022-09-04 07:52:18','',''),(5404,'1','277','1',1,'Retail Sale Id 5413',2002.00,0.00,0.00,2.75,145.75,'2022-09-04 07:56:25','',''),(5405,'1','277','1',1,'Retail Sale Id 5414',1499.68,0.00,0.00,2.06,109.18,'2022-09-04 08:00:45','',''),(5406,'1','277','1',1,'Retail Sale Id 5415',1099.28,0.00,0.00,1.51,80.03,'2022-09-04 08:01:32','',''),(5407,'1','277','1',1,'Retail Sale Id 5416',1703.52,0.00,0.00,2.34,124.02,'2022-09-04 08:05:14','',''),(5408,'1','277','1',1,'Retail Sale Id 5417',502.32,0.00,0.00,0.69,36.57,'2022-09-04 08:16:17','',''),(5409,'1','277','1',1,'Retail Sale Id 5418',997.36,0.00,0.00,1.37,72.61,'2022-09-04 08:19:21','',''),(5410,'1','277','1',1,'Retail Sale Id 5419',1499.68,0.00,0.00,2.06,109.18,'2022-09-04 08:20:52','',''),(5411,'1','277','1',1,'Retail Sale Id 5420',997.36,0.00,0.00,1.37,72.61,'2022-09-04 08:21:55','',''),(5412,'1','277','1',1,'Retail Sale Id 5421',2002.00,0.00,0.00,2.75,145.75,'2022-09-04 08:27:54','',''),(5413,'1','277','1',1,'Retail Sale Id 5423',3501.68,0.00,0.00,4.81,254.93,'2022-09-04 08:29:45','',''),(5414,'1','277','1',1,'Retail Sale Id 5424',2002.00,0.00,0.00,2.75,145.75,'2022-09-04 08:30:32','',''),(5415,'1','277','1',1,'Retail Sale Id 5425',9100.00,0.00,0.00,12.50,662.50,'2022-09-04 08:31:29','',''),(5416,'1','277','1',1,'Retail Sale Id 5426',502.32,0.00,0.00,0.69,36.57,'2022-09-04 08:33:11','',''),(5417,'1','277','1',1,'Retail Sale Id 5427',2002.00,0.00,0.00,2.75,145.75,'2022-09-04 08:48:52','',''),(5418,'1','277','1',1,'Retail Sale Id 5428',2198.56,0.00,0.00,3.02,160.06,'2022-09-04 08:55:57','',''),(5419,'1','277','1',1,'Retail Sale Id 5429',2999.36,0.00,0.00,4.12,218.36,'2022-09-04 08:57:09','',''),(5420,'1','277','1',1,'Retail Sale Id 5430',3698.24,0.00,0.00,5.08,269.24,'2022-09-04 09:01:04','',''),(5421,'1','277','1',1,'Retail Sale Id 5431',4397.12,0.00,0.00,6.04,320.12,'2022-09-04 09:07:38','',''),(5422,'1','277','1',1,'Retail Sale Id 5432',3698.24,0.00,0.00,5.08,269.24,'2022-09-04 09:15:10','',''),(5423,'1','277','1',1,'Retail Sale Id 5433',2002.00,0.00,0.00,2.75,145.75,'2022-09-04 09:16:57','',''),(5424,'1','277','1',1,'Retail Sale Id 5434',2999.36,0.00,0.00,4.12,218.36,'2022-09-04 09:18:10','',''),(5425,'1','277','1',1,'Retail Sale Id 5435',997.36,0.00,0.00,1.37,72.61,'2022-09-04 09:21:19','',''),(5426,'1','277','1',1,'Retail Sale Id 5436',4302.48,0.00,0.00,5.91,313.23,'2022-09-04 09:23:23','',''),(5427,'1','277','1',1,'Retail Sale Id 5437',9100.00,0.00,0.00,12.50,662.50,'2022-09-04 09:26:29','',''),(5428,'1','277','1',1,'Retail Sale Id 5438',3640.00,0.00,0.00,5.00,265.00,'2022-09-04 09:39:52','',''),(5429,'1','277','1',1,'Retail Sale Id 5439',2198.56,0.00,0.00,3.02,160.06,'2022-09-04 09:40:35','',''),(5430,'1','277','1',1,'Retail Sale Id 5440',1499.68,0.00,0.00,2.06,109.18,'2022-09-04 09:46:16','',''),(5431,'1','277','1',1,'Retail Sale Id 5441',997.36,0.00,0.00,1.37,72.61,'2022-09-04 09:48:37','',''),(5432,'1','277','1',1,'Retail Sale Id 5442',2184.00,0.00,0.00,3.00,159.00,'2022-09-04 09:50:53','',''),(5433,'1','277','1',1,'Retail Sale Id 5443',997.36,0.00,0.00,1.37,72.61,'2022-09-04 09:52:38','',''),(5434,'1','277','1',1,'Retail Sale Id 5444',9100.00,0.00,0.00,12.50,662.50,'2022-09-04 09:53:29','',''),(5435,'1','277','1',1,'Retail Sale Id 5445',1499.68,0.00,0.00,2.06,109.18,'2022-09-04 09:55:41','',''),(5436,'1','277','1',1,'Retail Sale Id 5446',2002.00,0.00,0.00,2.75,145.75,'2022-09-04 10:11:22','',''),(5437,'1','277','1',1,'Retail Sale Id 5447',502.32,0.00,0.00,0.69,36.57,'2022-09-04 10:12:03','',''),(5438,'1','277','1',1,'Retail Sale Id 5448',5103.28,0.00,0.00,7.01,371.53,'2022-09-04 10:15:43','',''),(5439,'1','277','1',1,'Retail Sale Id 5449',1499.68,0.00,0.00,2.06,109.18,'2022-09-04 10:18:16','',''),(5440,'1','277','1',1,'Retail Sale Id 5450',2497.04,0.00,0.00,3.43,181.79,'2022-09-04 10:20:05','',''),(5441,'1','277','1',1,'Retail Sale Id 5451',2198.56,0.00,0.00,3.02,160.06,'2022-09-04 10:21:17','',''),(5442,'1','277','1',1,'Retail Sale Id 5452',3996.72,0.00,0.00,5.49,290.97,'2022-09-04 10:22:18','',''),(5443,'1','277','1',1,'Retail Sale Id 5453',2198.56,0.00,0.00,3.02,160.06,'2022-09-04 10:25:18','',''),(5444,'1','277','1',1,'Retail Sale Id 5454',4302.48,0.00,0.00,5.91,313.23,'2022-09-04 10:36:20','',''),(5445,'1','277','1',1,'Retail Sale Id 5455',1201.20,0.00,0.00,1.65,87.45,'2022-09-04 10:48:42','',''),(5446,'1','277','1',1,'Retail Sale Id 5456',2198.56,0.00,0.00,3.02,160.06,'2022-09-04 10:51:32','',''),(5447,'1','277','1',1,'Retail Sale Id 5457',4368.00,0.00,0.00,6.00,318.00,'2022-09-04 10:54:03','',''),(5448,'1','277','1',1,'Retail Sale Id 5458',2096.64,0.00,0.00,2.88,152.64,'2022-09-04 10:55:24','',''),(5449,'1','277','1',1,'Retail Sale Id 5459',1499.68,0.00,0.00,2.06,109.18,'2022-09-04 10:59:55','',''),(5450,'1','277','1',1,'Retail Sale Id 5460',4397.12,0.00,0.00,6.04,320.12,'2022-09-04 11:05:15','',''),(5451,'1','277','1',1,'Retail Sale Id 5461',5001.36,0.00,0.00,6.87,364.11,'2022-09-04 11:06:04','',''),(5452,'1','277','1',1,'Retail Sale Id 5462',5998.72,0.00,0.00,8.24,436.72,'2022-09-04 11:09:42','',''),(5453,'1','277','1',1,'Retail Sale Id 5463',2999.36,0.00,0.00,4.12,218.36,'2022-09-04 11:10:24','',''),(5454,'1','277','1',1,'Retail Sale Id 5464',4397.12,0.00,0.00,6.04,320.12,'2022-09-04 11:14:08','',''),(5455,'1','277','1',1,'Retail Sale Id 5465',2999.36,0.00,0.00,4.12,218.36,'2022-09-04 11:20:03','',''),(5456,'1','277','1',1,'Retail Sale Id 5466',5001.36,0.00,0.00,6.87,364.11,'2022-09-04 11:24:59','',''),(5457,'1','277','1',1,'Retail Sale Id 5467',2198.56,0.00,0.00,3.02,160.06,'2022-09-04 11:28:14','',''),(5458,'1','277','1',1,'Retail Sale Id 5468',1499.68,0.00,0.00,2.06,109.18,'2022-09-04 11:28:54','',''),(5459,'1','277','1',1,'Retail Sale Id 5469',3501.68,0.00,0.00,4.81,254.93,'2022-09-04 11:40:34','',''),(5460,'1','277','1',1,'Retail Sale Id 5470',2198.56,0.00,0.00,3.02,160.06,'2022-09-04 11:44:03','',''),(5461,'1','277','1',1,'Retail Sale Id 5471',9100.00,0.00,0.00,12.50,662.50,'2022-09-04 11:53:13','',''),(5462,'1','277','1',1,'Retail Sale Id 5472',2002.00,0.00,0.00,2.75,145.75,'2022-09-04 11:56:42','',''),(5463,'1','277','1',1,'Retail Sale Id 5473',2002.00,0.00,0.00,2.75,145.75,'2022-09-04 12:03:38','',''),(5464,'1','277','1',1,'Retail Sale Id 5474',3399.76,0.00,0.00,4.67,247.51,'2022-09-04 12:04:22','',''),(5465,'1','277','1',1,'Retail Sale Id 5476',800.80,0.00,0.00,1.10,58.30,'2022-09-04 12:10:49','',''),(5466,'1','277','1',1,'Retail Sale Id 5477',4397.12,0.00,0.00,6.04,320.12,'2022-09-04 12:15:22','',''),(5467,'1','277','1',1,'Retail Sale Id 5478',4397.12,0.00,0.00,6.04,320.12,'2022-09-04 12:18:44','',''),(5468,'1','277','1',1,'Retail Sale Id 5479',2999.36,0.00,0.00,4.12,218.36,'2022-09-04 12:22:06','',''),(5469,'1','277','1',1,'Retail Sale Id 5480',6188.00,0.00,0.00,8.50,450.50,'2022-09-04 12:23:06','',''),(5470,'1','277','1',1,'Retail Sale Id 5482',2002.00,0.00,0.00,2.75,145.75,'2022-09-04 12:24:45','',''),(5471,'1','277','1',1,'Retail Sale Id 5483',2300.48,0.00,0.00,3.16,167.48,'2022-09-04 12:26:09','',''),(5472,'1','277','1',1,'Retail Sale Id 5484',2002.00,0.00,0.00,2.75,145.75,'2022-09-04 12:27:08','',''),(5473,'1','277','1',1,'Retail Sale Id 5486',4499.04,0.00,0.00,6.18,327.54,'2022-09-04 12:33:35','',''),(5474,'1','277','1',1,'Retail Sale Id 5487',1499.68,0.00,0.00,2.06,109.18,'2022-09-04 12:37:28','',''),(5475,'1','277','1',1,'Retail Sale Id 5488',2198.56,0.00,0.00,3.02,160.06,'2022-09-04 12:38:24','',''),(5476,'1','277','1',1,'Retail Sale Id 5489',997.36,0.00,0.00,1.37,72.61,'2022-09-04 12:39:22','',''),(5477,'1','277','1',1,'Retail Sale Id 5490',800.80,0.00,0.00,1.10,58.30,'2022-09-04 12:41:48','',''),(5478,'1','277','1',1,'Retail Sale Id 5491',2999.36,0.00,0.00,4.12,218.36,'2022-09-04 12:44:19','',''),(5479,'1','277','1',1,'Retail Sale Id 5492',2198.56,0.00,0.00,3.02,160.06,'2022-09-04 12:56:32','',''),(5480,'1','277','1',1,'Retail Sale Id 5493',2497.04,0.00,0.00,3.43,181.79,'2022-09-04 12:58:23','',''),(5481,'1','277','1',1,'Retail Sale Id 5494',997.36,0.00,0.00,1.37,72.61,'2022-09-04 12:59:49','',''),(5482,'1','277','1',1,'Retail Sale Id 5495',3640.00,0.00,0.00,5.00,265.00,'2022-09-04 13:02:18','',''),(5483,'1','277','1',1,'Retail Sale Id 5496',14560.00,0.00,0.00,20.00,1060.00,'2022-09-04 13:04:24','',''),(5484,'1','277','1',1,'Retail Sale Id 5497',2999.36,0.00,0.00,4.12,218.36,'2022-09-04 13:06:10','',''),(5485,'1','277','1',1,'Retail Sale Id 5498',2002.00,0.00,0.00,2.75,145.75,'2022-09-04 13:11:25','',''),(5486,'1','277','1',1,'Retail Sale Id 5499',3647.28,0.00,0.00,5.01,265.53,'2022-09-04 13:12:33','',''),(5487,'1','277','1',1,'Retail Sale Id 5500',997.36,0.00,0.00,1.37,72.61,'2022-09-04 13:22:59','',''),(5488,'1','277','1',1,'Retail Sale Id 5501',1499.68,0.00,0.00,2.06,109.18,'2022-09-04 13:23:32','',''),(5489,'1','277','1',1,'Retail Sale Id 5502',2999.36,0.00,0.00,4.12,218.36,'2022-09-04 13:24:08','',''),(5490,'1','277','1',1,'Retail Sale Id 5503',800.80,0.00,0.00,1.10,58.30,'2022-09-04 13:24:38','',''),(5491,'1','277','1',1,'Retail Sale Id 5504',4397.12,0.00,0.00,6.04,320.12,'2022-09-04 13:28:43','',''),(5492,'1','277','1',1,'Retail Sale Id 5505',3698.24,0.00,0.00,5.08,269.24,'2022-09-04 13:31:02','',''),(5493,'1','277','1',1,'Retail Sale Id 5506',2002.00,0.00,0.00,2.75,145.75,'2022-09-04 13:39:21','',''),(5494,'1','277','1',1,'Retail Sale Id 5507',1980.16,0.00,0.00,2.72,144.16,'2022-09-04 13:44:02','',''),(5495,'1','277','1',1,'Retail Sale Id 5508',4368.00,0.00,0.00,6.00,318.00,'2022-09-04 13:51:33','',''),(5496,'1','277','1',1,'Retail Sale Id 5509',2198.56,0.00,0.00,3.02,160.06,'2022-09-04 13:52:10','',''),(5497,'1','277','1',1,'Retail Sale Id 5510',2198.56,0.00,0.00,3.02,160.06,'2022-09-04 14:02:33','',''),(5498,'1','277','1',1,'Retail Sale Id 5511',9100.00,0.00,0.00,12.50,662.50,'2022-09-04 14:09:56','',''),(5499,'1','277','1',1,'Retail Sale Id 5512',2002.00,0.00,0.00,2.75,145.75,'2022-09-04 14:10:40','',''),(5500,'1','277','1',1,'Retail Sale Id 5513',800.80,0.00,0.00,1.10,58.30,'2022-09-04 14:12:11','',''),(5501,'1','277','1',1,'Retail Sale Id 5514',997.36,0.00,0.00,1.37,72.61,'2022-09-04 14:12:50','',''),(5502,'1','277','1',1,'Retail Sale Id 5515',2002.00,0.00,0.00,2.75,145.75,'2022-09-04 14:14:52','',''),(5503,'1','277','1',1,'Retail Sale Id 5516',3647.28,0.00,0.00,5.01,265.53,'2022-09-04 14:17:46','',''),(5504,'1','277','1',1,'Retail Sale Id 5517',2999.36,0.00,0.00,4.12,218.36,'2022-09-04 14:23:36','',''),(5505,'1','277','1',1,'Retail Sale Id 5518',2002.00,0.00,0.00,2.75,145.75,'2022-09-04 14:26:21','',''),(5506,'1','277','1',1,'Retail Sale Id 5519',2497.04,0.00,0.00,3.43,181.79,'2022-09-04 14:31:54','',''),(5507,'1','277','1',1,'Retail Sale Id 5520',9100.00,0.00,0.00,12.50,662.50,'2022-09-04 14:34:37','',''),(5508,'1','277','1',1,'Retail Sale Id 5521',749.84,0.00,0.00,1.03,54.59,'2022-09-04 14:36:02','',''),(5509,'1','277','1',1,'Retail Sale Id 5522',2999.36,0.00,0.00,4.12,218.36,'2022-09-04 14:36:47','',''),(5510,'1','277','1',1,'Retail Sale Id 5523',1499.68,0.00,0.00,2.06,109.18,'2022-09-04 14:37:39','',''),(5511,'1','277','1',1,'Retail Sale Id 5524',1499.68,0.00,0.00,2.06,109.18,'2022-09-04 14:38:54','',''),(5512,'1','277','1',1,'Retail Sale Id 5525',2497.04,0.00,0.00,3.43,181.79,'2022-09-04 14:39:30','',''),(5513,'1','277','1',1,'Retail Sale Id 5526',2999.36,0.00,0.00,4.12,218.36,'2022-09-04 14:40:08','',''),(5514,'1','277','1',1,'Retail Sale Id 5527',2002.00,0.00,0.00,2.75,145.75,'2022-09-04 14:45:46','',''),(5515,'1','277','1',1,'Retail Sale Id 5528',1499.68,0.00,0.00,2.06,109.18,'2022-09-04 14:51:20','',''),(5516,'1','277','1',1,'Retail Sale Id 5528',2002.00,0.00,0.00,2.75,145.75,'2022-09-04 14:51:20','',''),(5517,'1','277','1',1,'Retail Sale Id 5529',4397.12,0.00,0.00,6.04,320.12,'2022-09-04 14:54:32','',''),(5518,'1','277','1',1,'Retail Sale Id 5530',1499.68,0.00,0.00,2.06,109.18,'2022-09-04 14:55:55','',''),(5519,'1','277','1',1,'Retail Sale Id 5531',1499.68,0.00,0.00,2.06,109.18,'2022-09-04 14:56:50','',''),(5520,'1','277','1',1,'Retail Sale Id 5532',2999.36,0.00,0.00,4.12,218.36,'2022-09-04 15:13:50','',''),(5521,'1','277','1',1,'Retail Sale Id 5533',3501.68,0.00,0.00,4.81,254.93,'2022-09-04 15:18:30','',''),(5522,'1','277','1',1,'Retail Sale Id 5534',2300.48,0.00,0.00,3.16,167.48,'2022-09-04 15:20:23','',''),(5523,'1','277','1',1,'Retail Sale Id 5535',2497.04,0.00,0.00,3.43,181.79,'2022-09-04 15:22:14','',''),(5524,'1','277','1',1,'Retail Sale Id 5536',1499.68,0.00,0.00,2.06,109.18,'2022-09-04 15:28:51','',''),(5525,'1','277','1',1,'Retail Sale Id 5537',749.84,0.00,0.00,1.03,54.59,'2022-09-04 15:29:36','',''),(5526,'1','277','1',1,'Retail Sale Id 5538',3996.72,0.00,0.00,5.49,290.97,'2022-09-04 15:40:35','',''),(5527,'1','277','1',1,'Retail Sale Id 5539',3996.72,0.00,0.00,5.49,290.97,'2022-09-04 15:56:41','',''),(5528,'1','277','1',1,'Retail Sale Id 5540',2002.00,0.00,0.00,2.75,145.75,'2022-09-04 15:57:34','',''),(5529,'1','277','1',1,'Retail Sale Id 5541',997.36,0.00,0.00,1.37,72.61,'2022-09-04 15:58:39','',''),(5530,'1','277','1',1,'Retail Sale Id 5542',42600.00,0.00,0.00,60.00,2100.00,'2022-09-04 16:00:40','',''),(5531,'1','277','1',1,'Retail Sale Id 5543',4397.12,0.00,0.00,6.04,320.12,'2022-09-04 16:02:05','',''),(5532,'1','277','1',1,'Retail Sale Id 5544',3647.28,0.00,0.00,5.01,265.53,'2022-09-04 16:02:47','',''),(5533,'1','277','1',1,'Retail Sale Id 5545',2002.00,0.00,0.00,2.75,145.75,'2022-09-04 16:03:33','',''),(5534,'1','277','1',1,'Retail Sale Id 5546',3640.00,0.00,0.00,5.00,265.00,'2022-09-04 16:04:56','',''),(5535,'1','277','1',1,'Retail Sale Id 5547',5001.36,0.00,0.00,6.87,364.11,'2022-09-04 16:05:40','',''),(5536,'1','277','1',1,'Retail Sale Id 5548',1499.68,0.00,0.00,2.06,109.18,'2022-09-04 16:09:01','',''),(5537,'1','277','1',1,'Retail Sale Id 5549',2198.56,0.00,0.00,3.02,160.06,'2022-09-04 16:10:21','',''),(5538,'1','277','1',1,'Retail Sale Id 5550',2999.36,0.00,0.00,4.12,218.36,'2022-09-04 16:10:54','',''),(5539,'1','277','1',1,'Retail Sale Id 5551',4397.12,0.00,0.00,6.04,320.12,'2022-09-04 16:11:50','',''),(5540,'1','277','1',1,'Retail Sale Id 5552',2198.56,0.00,0.00,3.02,160.06,'2022-09-04 16:13:27','',''),(5541,'1','277','1',1,'Retail Sale Id 5553',2002.00,0.00,0.00,2.75,145.75,'2022-09-04 16:18:29','',''),(5542,'1','277','1',1,'Retail Sale Id 5554',1499.68,0.00,0.00,2.06,109.18,'2022-09-04 16:20:04','',''),(5543,'1','277','1',1,'Retail Sale Id 5555',4397.12,0.00,0.00,6.04,320.12,'2022-09-04 16:21:20','',''),(5544,'1','277','1',1,'Retail Sale Id 5556',2497.04,0.00,0.00,3.43,181.79,'2022-09-04 16:21:58','',''),(5545,'1','277','1',1,'Retail Sale Id 5557',7280.00,0.00,0.00,10.00,530.00,'2022-09-04 16:28:16','',''),(5546,'1','277','1',1,'Retail Sale Id 5558',3501.68,0.00,0.00,4.81,254.93,'2022-09-04 16:32:24','',''),(5547,'1','277','1',1,'Retail Sale Id 5559',2999.36,0.00,0.00,4.12,218.36,'2022-09-04 16:45:18','',''),(5548,'1','277','1',1,'Retail Sale Id 5560',4397.12,0.00,0.00,6.04,320.12,'2022-09-04 16:46:21','',''),(5549,'1','277','1',1,'Retail Sale Id 5561',1499.68,0.00,0.00,2.06,109.18,'2022-09-04 16:47:01','',''),(5550,'1','277','1',1,'Retail Sale Id 5562',4397.12,0.00,0.00,6.04,320.12,'2022-09-04 16:49:00','',''),(5551,'1','277','1',1,'Retail Sale Id 5563',7280.00,0.00,0.00,10.00,530.00,'2022-09-04 17:04:32','',''),(5552,'1','277','1',1,'Retail Sale Id 5564',4397.12,0.00,0.00,6.04,320.12,'2022-09-04 17:08:38','',''),(5553,'1','277','1',1,'Retail Sale Id 5565',1499.68,0.00,0.00,2.06,109.18,'2022-09-04 17:09:28','',''),(5554,'1','277','1',1,'Retail Sale Id 5566',1499.68,0.00,0.00,2.06,109.18,'2022-09-04 17:11:23','',''),(5555,'1','277','1',1,'Retail Sale Id 5567',2002.00,0.00,0.00,2.75,145.75,'2022-09-04 17:12:09','',''),(5556,'1','277','1',1,'Retail Sale Id 5568',3996.72,0.00,0.00,5.49,290.97,'2022-09-04 17:19:14','',''),(5557,'1','277','1',1,'Retail Sale Id 5569',2300.48,0.00,0.00,3.16,167.48,'2022-09-04 17:20:19','',''),(5558,'1','277','1',1,'Retail Sale Id 5570',9100.00,0.00,0.00,12.50,662.50,'2022-09-04 17:23:58','',''),(5559,'1','277','1',1,'Retail Sale Id 5571',2198.56,0.00,0.00,3.02,160.06,'2022-09-04 17:29:33','',''),(5560,'1','277','1',1,'Retail Sale Id 5572',800.80,0.00,0.00,1.10,58.30,'2022-09-04 17:37:50','',''),(5561,'1','277','1',1,'Retail Sale Id 5573',997.36,0.00,0.00,1.37,72.61,'2022-09-04 17:38:49','',''),(5562,'1','277','1',1,'Retail Sale Id 5574',1499.68,0.00,0.00,2.06,109.18,'2022-09-04 17:40:01','',''),(5563,'1','277','1',1,'Retail Sale Id 5574',1499.68,0.00,0.00,2.06,109.18,'2022-09-04 17:40:01','',''),(5564,'1','277','1',1,'Retail Sale Id 5575',2002.00,0.00,0.00,2.75,145.75,'2022-09-04 17:54:19','',''),(5565,'1','277','1',1,'Retail Sale Id 5576',2002.00,0.00,0.00,2.75,145.75,'2022-09-04 17:55:21','',''),(5566,'1','277','1',1,'Retail Sale Id 5577',1499.68,0.00,0.00,2.06,109.18,'2022-09-04 17:56:49','',''),(5567,'1','277','1',1,'Retail Sale Id 5578',2198.56,0.00,0.00,3.02,160.06,'2022-09-04 18:00:19','',''),(5568,'1','277','1',1,'Retail Sale Id 5579',1703.52,0.00,0.00,2.34,124.02,'2022-09-04 18:13:06','',''),(5569,'1','277','1',1,'Retail Sale Id 5580',1499.68,0.00,0.00,2.06,109.18,'2022-09-04 18:13:55','',''),(5570,'1','277','1',1,'Retail Sale Id 5581',6552.00,0.00,0.00,9.00,477.00,'2022-09-04 18:16:54','',''),(5571,'1','277','1',1,'Retail Sale Id 5582',3996.72,0.00,0.00,5.49,290.97,'2022-09-04 18:20:05','',''),(5572,'1','277','1',1,'Retail Sale Id 5584',2351.44,0.00,0.00,3.23,171.19,'2022-09-04 18:21:52','',''),(5573,'1','277','1',1,'Retail Sale Id 5585',800.80,0.00,0.00,1.10,58.30,'2022-09-04 18:28:30','',''),(5574,'1','277','1',1,'Retail Sale Id 5586',1201.20,0.00,0.00,1.65,87.45,'2022-09-04 18:32:46','',''),(5575,'1','277','1',1,'Retail Sale Id 5587',2897.44,0.00,0.00,3.98,210.94,'2022-09-04 18:33:42','',''),(5576,'1','277','1',1,'Retail Sale Id 5588',2198.56,0.00,0.00,3.02,160.06,'2022-09-04 18:35:25','',''),(5577,'1','277','1',1,'Retail Sale Id 5589',698.88,0.00,0.00,0.96,50.88,'2022-09-04 18:36:17','',''),(5578,'1','277','1',1,'Retail Sale Id 5590',2002.00,0.00,0.00,2.75,145.75,'2022-09-04 18:39:28','',''),(5579,'1','277','1',1,'Retail Sale Id 5592',2198.56,0.00,0.00,3.02,160.06,'2022-09-04 18:55:10','',''),(5580,'1','277','1',1,'Retail Sale Id 5593',2198.56,0.00,0.00,3.02,160.06,'2022-09-04 18:56:42','',''),(5581,'1','277','1',1,'Retail Sale Id 5594',9100.00,0.00,0.00,12.50,662.50,'2022-09-04 18:57:20','',''),(5582,'1','277','1',1,'Retail Sale Id 5595',2999.36,0.00,0.00,4.12,218.36,'2022-09-04 18:58:07','',''),(5583,'1','277','1',1,'Retail Sale Id 5596',997.36,0.00,0.00,1.37,72.61,'2022-09-04 19:04:43','',''),(5584,'1','277','1',1,'Retail Sale Id 5597',5998.72,0.00,0.00,8.24,436.72,'2022-09-04 19:09:36','',''),(5585,'1','277','1',1,'Retail Sale Id 5598',2000.00,0.00,0.00,1.00,1325.00,'2022-09-04 19:11:10','',''),(5586,'1','277','1',1,'Retail Sale Id 5599',1456.00,0.00,0.00,2.00,106.00,'2022-09-04 19:12:03','',''),(5587,'1','277','1',1,'Retail Sale Id 5600',9100.00,0.00,0.00,12.50,662.50,'2022-09-04 19:15:35','',''),(5588,'1','277','1',1,'Retail Sale Id 5601',4397.12,0.00,0.00,6.04,320.12,'2022-09-04 19:21:23','',''),(5589,'1','277','1',1,'Retail Sale Id 5602',1259.44,0.00,0.00,1.73,91.69,'2022-09-04 20:05:33','',''),(5590,'1','277','1',1,'Retail Sale Id 5603',5001.36,0.00,0.00,6.87,364.11,'2022-09-05 06:39:13','',''),(5591,'1','277','1',1,'Retail Sale Id 5604',2002.00,0.00,0.00,2.75,145.75,'2022-09-05 06:44:08','',''),(5592,'1','277','1',1,'Retail Sale Id 5605',1499.68,0.00,0.00,2.06,109.18,'2022-09-05 07:17:52','',''),(5593,'1','277','1',1,'Retail Sale Id 5606',749.84,0.00,0.00,1.03,54.59,'2022-09-05 07:20:59','',''),(5594,'1','277','1',1,'Retail Sale Id 5607',742.56,0.00,0.00,1.02,54.06,'2022-09-05 07:28:59','',''),(5595,'1','277','1',1,'Retail Sale Id 5608',5001.36,0.00,0.00,6.87,364.11,'2022-09-05 07:37:30','',''),(5596,'1','277','1',1,'Retail Sale Id 5609',3698.24,0.00,0.00,5.08,269.24,'2022-09-05 07:40:06','',''),(5597,'1','277','1',1,'Retail Sale Id 5610',4368.00,0.00,0.00,6.00,318.00,'2022-09-05 07:51:02','',''),(5598,'1','277','1',1,'Retail Sale Id 5611',3712.80,0.00,0.00,5.10,270.30,'2022-09-05 07:53:03','',''),(5599,'1','277','1',1,'Retail Sale Id 5612',3996.72,0.00,0.00,5.49,290.97,'2022-09-05 07:56:57','',''),(5600,'1','277','1',1,'Retail Sale Id 5613',1499.68,0.00,0.00,2.06,109.18,'2022-09-05 07:57:40','',''),(5601,'1','277','1',1,'Retail Sale Id 5614',10920.00,0.00,0.00,15.00,795.00,'2022-09-05 08:04:18','',''),(5602,'1','277','1',1,'Retail Sale Id 5615',4368.00,0.00,0.00,6.00,318.00,'2022-09-05 08:16:04','',''),(5603,'1','277','1',1,'Retail Sale Id 5616',1499.68,0.00,0.00,2.06,109.18,'2022-09-05 08:20:47','',''),(5604,'1','277','1',1,'Retail Sale Id 5617',5001.36,0.00,0.00,6.87,364.11,'2022-09-05 08:24:11','',''),(5605,'1','277','1',1,'Retail Sale Id 5618',2002.00,0.00,0.00,2.75,145.75,'2022-09-05 08:25:46','',''),(5606,'1','277','1',1,'Retail Sale Id 5619',1499.68,0.00,0.00,2.06,109.18,'2022-09-05 08:27:27','',''),(5607,'1','277','1',1,'Retail Sale Id 5620',3996.72,0.00,0.00,5.49,290.97,'2022-09-05 08:29:50','',''),(5608,'1','277','1',1,'Retail Sale Id 5621',1499.68,0.00,0.00,2.06,109.18,'2022-09-05 08:34:33','',''),(5609,'1','277','1',1,'Retail Sale Id 5622',997.36,0.00,0.00,1.37,72.61,'2022-09-05 08:42:04','',''),(5610,'1','277','1',1,'Retail Sale Id 5623',9100.00,0.00,0.00,12.50,662.50,'2022-09-05 08:46:56','',''),(5611,'1','277','1',1,'Retail Sale Id 5624',2999.36,0.00,0.00,4.12,218.36,'2022-09-05 08:47:42','',''),(5612,'1','277','1',1,'Retail Sale Id 5625',42600.00,0.00,0.00,60.00,2100.00,'2022-09-05 08:50:44','',''),(5613,'1','277','1',1,'Retail Sale Id 5626',4397.12,0.00,0.00,6.04,320.12,'2022-09-05 08:51:29','',''),(5614,'1','277','1',1,'Retail Sale Id 5627',1499.68,0.00,0.00,2.06,109.18,'2022-09-05 09:13:36','',''),(5615,'1','277','1',1,'Retail Sale Id 5628',997.36,0.00,0.00,1.37,72.61,'2022-09-05 09:15:24','',''),(5616,'1','277','1',1,'Retail Sale Id 5629',698.88,0.00,0.00,0.96,50.88,'2022-09-05 09:18:47','',''),(5617,'1','277','1',1,'Retail Sale Id 5630',1303.12,0.00,0.00,1.79,94.87,'2022-09-05 09:22:28','',''),(5618,'1','277','1',1,'Retail Sale Id 5631',2198.56,0.00,0.00,3.02,160.06,'2022-09-05 09:26:46','',''),(5619,'1','277','1',1,'Retail Sale Id 5631',5103.28,0.00,0.00,7.01,371.53,'2022-09-05 09:26:46','',''),(5620,'1','277','1',1,'Retail Sale Id 5632',3640.00,0.00,0.00,5.00,265.00,'2022-09-05 09:28:35','',''),(5621,'1','277','1',1,'Retail Sale Id 5633',2002.00,0.00,0.00,2.75,145.75,'2022-09-05 09:30:04','',''),(5622,'1','277','1',1,'Retail Sale Id 5634',35500.00,0.00,0.00,50.00,1750.00,'2022-09-05 09:34:32','',''),(5623,'1','277','1',1,'Retail Sale Id 5635',800.80,0.00,0.00,1.10,58.30,'2022-09-05 09:42:02','',''),(5624,'1','277','1',1,'Retail Sale Id 5636',9100.00,0.00,0.00,12.50,662.50,'2022-09-05 09:46:33','',''),(5625,'1','277','1',1,'Retail Sale Id 5637',2999.36,0.00,0.00,4.12,218.36,'2022-09-05 09:56:23','',''),(5626,'1','277','1',1,'Retail Sale Id 5638',2198.56,0.00,0.00,3.02,160.06,'2022-09-05 10:11:49','',''),(5627,'1','277','1',1,'Retail Sale Id 5639',9100.00,0.00,0.00,12.50,662.50,'2022-09-05 10:26:17','',''),(5628,'1','277','1',1,'Retail Sale Id 5640',2198.56,0.00,0.00,3.02,160.06,'2022-09-05 10:30:58','',''),(5629,'1','277','1',1,'Retail Sale Id 5641',2198.56,0.00,0.00,3.02,160.06,'2022-09-05 10:42:19','',''),(5630,'1','277','1',1,'Retail Sale Id 5642',997.36,0.00,0.00,1.37,72.61,'2022-09-05 10:43:30','',''),(5631,'1','277','1',1,'Retail Sale Id 5643',1499.68,0.00,0.00,2.06,109.18,'2022-09-05 10:54:47','',''),(5632,'1','277','1',1,'Retail Sale Id 5644',997.36,0.00,0.00,1.37,72.61,'2022-09-05 10:55:28','',''),(5633,'1','277','1',1,'Retail Sale Id 5645',1499.68,0.00,0.00,2.06,109.18,'2022-09-05 11:06:37','',''),(5634,'1','277','1',1,'Retail Sale Id 5646',2198.56,0.00,0.00,3.02,160.06,'2022-09-05 11:16:00','',''),(5635,'1','277','1',1,'Retail Sale Id 5647',9100.00,0.00,0.00,12.50,662.50,'2022-09-05 11:20:34','',''),(5636,'1','277','1',1,'Retail Sale Id 5648',2002.00,0.00,0.00,2.75,145.75,'2022-09-05 11:45:47','',''),(5637,'1','277','1',1,'Retail Sale Id 5649',2198.56,0.00,0.00,3.02,160.06,'2022-09-05 11:48:59','',''),(5638,'1','277','1',1,'Retail Sale Id 5650',5001.36,0.00,0.00,6.87,364.11,'2022-09-05 11:54:10','',''),(5639,'1','277','1',1,'Retail Sale Id 5651',2198.56,0.00,0.00,3.02,160.06,'2022-09-05 12:07:46','',''),(5640,'1','277','1',1,'Retail Sale Id 5652',2497.04,0.00,0.00,3.43,181.79,'2022-09-05 12:10:05','',''),(5641,'1','277','1',1,'Retail Sale Id 5653',4397.12,0.00,0.00,6.04,320.12,'2022-09-05 12:15:12','',''),(5642,'1','277','1',1,'Retail Sale Id 5654',2999.36,0.00,0.00,4.12,218.36,'2022-09-05 12:26:13','',''),(5643,'1','277','1',1,'Retail Sale Id 5655',1499.68,0.00,0.00,2.06,109.18,'2022-09-05 12:29:14','',''),(5644,'1','277','1',1,'Retail Sale Id 5657',35500.00,0.00,0.00,50.00,1750.00,'2022-09-05 12:34:23','',''),(5645,'1','277','1',1,'Retail Sale Id 5659',2919.28,0.00,0.00,4.01,212.53,'2022-09-05 12:36:22','',''),(5646,'1','277','1',1,'Retail Sale Id 5660',1499.68,0.00,0.00,2.06,109.18,'2022-09-05 12:49:08','',''),(5647,'1','277','1',1,'Retail Sale Id 5661',9100.00,0.00,0.00,12.50,662.50,'2022-09-05 13:00:32','',''),(5648,'1','277','1',1,'Retail Sale Id 5663',2999.36,0.00,0.00,4.12,218.36,'2022-09-05 13:03:23','',''),(5649,'1','277','1',1,'Retail Sale Id 5664',4397.12,0.00,0.00,6.04,320.12,'2022-09-05 13:03:52','',''),(5650,'1','277','1',1,'Retail Sale Id 5665',2999.36,0.00,0.00,4.12,218.36,'2022-09-05 13:13:56','',''),(5651,'1','277','1',1,'Retail Sale Id 5666',2198.56,0.00,0.00,3.02,160.06,'2022-09-05 13:15:03','',''),(5652,'1','277','1',1,'Retail Sale Id 5667',18200.00,0.00,0.00,25.00,1325.00,'2022-09-05 13:32:57','',''),(5653,'1','277','1',1,'Retail Sale Id 5668',1499.68,0.00,0.00,2.06,109.18,'2022-09-05 13:35:09','',''),(5654,'1','277','1',1,'Retail Sale Id 5669',4368.00,0.00,0.00,6.00,318.00,'2022-09-05 13:37:28','',''),(5655,'1','277','1',1,'Retail Sale Id 5670',3698.24,0.00,0.00,5.08,269.24,'2022-09-05 13:42:17','',''),(5656,'1','277','1',1,'Retail Sale Id 5671',2999.36,0.00,0.00,4.12,218.36,'2022-09-05 13:43:12','',''),(5657,'1','277','1',1,'Retail Sale Id 5672',9100.00,0.00,0.00,12.50,662.50,'2022-09-05 13:45:07','',''),(5658,'1','277','1',1,'Retail Sale Id 5674',4448.08,0.00,0.00,6.11,323.83,'2022-09-05 13:52:46','',''),(5659,'1','277','1',1,'Retail Sale Id 5675',1601.60,0.00,0.00,2.20,116.60,'2022-09-05 13:55:08','',''),(5660,'1','277','1',1,'Retail Sale Id 5676',3647.28,0.00,0.00,5.01,265.53,'2022-09-05 13:56:13','',''),(5661,'1','277','1',1,'Retail Sale Id 5677',1499.68,0.00,0.00,2.06,109.18,'2022-09-05 14:01:48','',''),(5662,'1','277','1',1,'Retail Sale Id 5678',7003.36,0.00,0.00,9.62,509.86,'2022-09-05 14:08:55','',''),(5663,'1','277','1',1,'Retail Sale Id 5679',2497.04,0.00,0.00,3.43,181.79,'2022-09-05 14:11:33','',''),(5664,'1','277','1',1,'Retail Sale Id 5680',1201.20,0.00,0.00,1.65,87.45,'2022-09-05 14:12:28','',''),(5665,'1','277','1',1,'Retail Sale Id 5681',5001.36,0.00,0.00,6.87,364.11,'2022-09-05 14:24:15','',''),(5666,'1','277','1',1,'Retail Sale Id 5682',2999.36,0.00,0.00,4.12,218.36,'2022-09-05 14:24:56','',''),(5667,'1','277','1',1,'Retail Sale Id 5683',2497.04,0.00,0.00,3.43,181.79,'2022-09-05 14:28:43','',''),(5668,'1','277','1',1,'Retail Sale Id 5684',3996.72,0.00,0.00,5.49,290.97,'2022-09-05 14:33:36','',''),(5669,'1','277','1',1,'Retail Sale Id 5685',1499.68,0.00,0.00,2.06,109.18,'2022-09-05 14:53:18','',''),(5670,'1','277','1',1,'Retail Sale Id 5686',4397.12,0.00,0.00,6.04,320.12,'2022-09-05 15:11:19','',''),(5671,'1','277','1',1,'Retail Sale Id 5687',2999.36,0.00,0.00,4.12,218.36,'2022-09-05 15:12:12','',''),(5672,'1','277','1',1,'Retail Sale Id 5688',3640.00,0.00,0.00,5.00,265.00,'2022-09-05 15:13:28','',''),(5673,'1','277','1',1,'Retail Sale Id 5689',9100.00,0.00,0.00,12.50,662.50,'2022-09-05 15:14:29','',''),(5674,'1','277','1',1,'Retail Sale Id 5690',6602.96,0.00,0.00,9.07,480.71,'2022-09-05 15:19:19','',''),(5675,'1','277','1',1,'Retail Sale Id 5691',2002.00,0.00,0.00,2.75,145.75,'2022-09-05 15:21:03','',''),(5676,'1','277','1',1,'Retail Sale Id 5692',3647.28,0.00,0.00,5.01,265.53,'2022-09-05 15:24:25','',''),(5677,'1','277','1',1,'Retail Sale Id 5693',2002.00,0.00,0.00,2.75,145.75,'2022-09-05 15:27:39','',''),(5678,'1','277','1',1,'Retail Sale Id 5694',1499.68,0.00,0.00,2.06,109.18,'2022-09-05 15:41:45','',''),(5679,'1','277','1',1,'Retail Sale Id 5695',2948.40,0.00,0.00,4.05,214.65,'2022-09-05 15:55:11','',''),(5680,'1','277','1',1,'Retail Sale Id 5696',4397.12,0.00,0.00,6.04,320.12,'2022-09-05 15:56:15','',''),(5681,'1','277','1',1,'Retail Sale Id 5697',2497.04,0.00,0.00,3.43,181.79,'2022-09-05 15:56:53','',''),(5682,'1','277','1',1,'Retail Sale Id 5698',997.36,0.00,0.00,1.37,72.61,'2022-09-05 15:58:09','',''),(5683,'1','277','1',1,'Retail Sale Id 5699',8998.08,0.00,0.00,12.36,655.08,'2022-09-05 16:00:35','',''),(5684,'1','277','1',1,'Retail Sale Id 5700',9100.00,0.00,0.00,12.50,662.50,'2022-09-05 16:10:02','',''),(5685,'1','277','1',1,'Retail Sale Id 5701',2002.00,0.00,0.00,2.75,145.75,'2022-09-05 16:13:02','',''),(5686,'1','277','1',1,'Retail Sale Id 5702',3501.68,0.00,0.00,4.81,254.93,'2022-09-05 16:14:16','',''),(5687,'1','277','1',1,'Retail Sale Id 5703',2497.04,0.00,0.00,3.43,181.79,'2022-09-05 16:27:21','',''),(5688,'1','277','1',1,'Retail Sale Id 5704',1499.68,0.00,0.00,2.06,109.18,'2022-09-05 16:33:51','',''),(5689,'1','277','1',1,'Retail Sale Id 5705',3647.28,0.00,0.00,5.01,265.53,'2022-09-05 16:34:36','',''),(5690,'1','277','1',1,'Retail Sale Id 5706',698.88,0.00,0.00,0.96,50.88,'2022-09-05 16:35:18','',''),(5691,'1','277','1',1,'Retail Sale Id 5707',997.36,0.00,0.00,1.37,72.61,'2022-09-05 16:58:49','',''),(5692,'1','277','1',1,'Retail Sale Id 5708',4368.00,0.00,0.00,6.00,318.00,'2022-09-05 17:01:36','',''),(5693,'1','277','1',1,'Retail Sale Id 5709',1499.68,0.00,0.00,2.06,109.18,'2022-09-05 17:02:26','',''),(5694,'1','277','1',1,'Retail Sale Id 5710',997.36,0.00,0.00,1.37,72.61,'2022-09-05 17:03:04','',''),(5695,'1','277','1',1,'Retail Sale Id 5711',8000.72,0.00,0.00,10.99,582.47,'2022-09-05 17:07:24','',''),(5696,'1','277','1',1,'Retail Sale Id 5712',25560.00,0.00,0.00,36.00,1260.00,'2022-09-05 17:09:56','',''),(5697,'1','277','1',1,'Retail Sale Id 5713',1499.68,0.00,0.00,2.06,109.18,'2022-09-05 17:10:29','',''),(5698,'1','277','1',1,'Retail Sale Id 5714',1499.68,0.00,0.00,2.06,109.18,'2022-09-05 17:11:06','',''),(5699,'1','277','1',1,'Retail Sale Id 5715',1499.68,0.00,0.00,2.06,109.18,'2022-09-05 17:16:21','',''),(5700,'1','277','1',1,'Retail Sale Id 5716',3996.72,0.00,0.00,5.49,290.97,'2022-09-05 17:18:10','',''),(5701,'1','277','1',1,'Retail Sale Id 5717',1499.68,0.00,0.00,2.06,109.18,'2022-09-05 17:23:23','',''),(5702,'1','277','1',1,'Retail Sale Id 5718',2184.00,0.00,0.00,3.00,159.00,'2022-09-05 17:27:20','',''),(5703,'1','277','1',1,'Retail Sale Id 5719',25986.00,0.00,0.00,36.60,1281.00,'2022-09-05 17:33:22','',''),(5704,'1','277','1',1,'Retail Sale Id 5720',2198.56,0.00,0.00,3.02,160.06,'2022-09-05 17:36:42','',''),(5705,'1','277','1',1,'Retail Sale Id 5721',9100.00,0.00,0.00,12.50,662.50,'2022-09-05 17:38:17','',''),(5706,'1','277','1',1,'Retail Sale Id 5722',4397.12,0.00,0.00,6.04,320.12,'2022-09-05 17:39:59','',''),(5707,'1','277','1',1,'Retail Sale Id 5723',502.32,0.00,0.00,0.69,36.57,'2022-09-05 17:46:40','',''),(5708,'1','277','1',1,'Retail Sale Id 5724',9100.00,0.00,0.00,12.50,662.50,'2022-09-05 17:57:30','',''),(5709,'1','277','1',1,'Retail Sale Id 5725',2198.56,0.00,0.00,3.02,160.06,'2022-09-05 17:59:40','',''),(5710,'1','277','1',1,'Retail Sale Id 5726',728.00,0.00,0.00,1.00,53.00,'2022-09-05 18:00:22','',''),(5711,'1','277','1',1,'Retail Sale Id 5727',9100.00,0.00,0.00,12.50,662.50,'2022-09-05 18:02:05','',''),(5712,'1','277','1',1,'Retail Sale Id 5728',7003.36,0.00,0.00,9.62,509.86,'2022-09-05 18:03:10','',''),(5713,'1','277','1',1,'Retail Sale Id 5729',3698.24,0.00,0.00,5.08,269.24,'2022-09-05 18:04:07','',''),(5714,'1','277','1',1,'Retail Sale Id 5730',3800.16,0.00,0.00,5.22,276.66,'2022-09-05 18:05:55','',''),(5715,'1','277','1',1,'Retail Sale Id 5731',9100.00,0.00,0.00,12.50,662.50,'2022-09-05 18:09:22','',''),(5716,'1','277','1',1,'Retail Sale Id 5732',2002.00,0.00,0.00,2.75,145.75,'2022-09-05 18:10:05','',''),(5717,'1','277','1',1,'Retail Sale Id 5733',1499.68,0.00,0.00,2.06,109.18,'2022-09-05 18:15:49','',''),(5718,'1','277','1',1,'Retail Sale Id 5734',9100.00,0.00,0.00,12.50,662.50,'2022-09-05 18:17:08','',''),(5719,'1','277','1',1,'Retail Sale Id 5735',1499.68,0.00,0.00,2.06,109.18,'2022-09-05 18:20:03','',''),(5720,'1','277','1',1,'Retail Sale Id 5736',2497.04,0.00,0.00,3.43,181.79,'2022-09-05 18:28:05','',''),(5721,'1','277','1',1,'Retail Sale Id 5737',997.36,0.00,0.00,1.37,72.61,'2022-09-05 18:28:49','',''),(5722,'1','277','1',1,'Retail Sale Id 5738',2002.00,0.00,0.00,2.75,145.75,'2022-09-05 18:30:09','',''),(5723,'1','277','1',1,'Retail Sale Id 5739',9100.00,0.00,0.00,12.50,662.50,'2022-09-05 18:31:56','',''),(5724,'1','277','1',1,'Retail Sale Id 5740',4302.48,0.00,0.00,5.91,313.23,'2022-09-05 18:34:04','',''),(5725,'1','277','1',1,'Retail Sale Id 5741',1499.68,0.00,0.00,2.06,109.18,'2022-09-05 18:44:07','',''),(5726,'1','277','1',1,'Retail Sale Id 5743',9100.00,0.00,0.00,12.50,662.50,'2022-09-05 18:46:04','',''),(5727,'1','277','1',1,'Retail Sale Id 5744',2184.00,0.00,0.00,3.00,159.00,'2022-09-05 18:48:14','',''),(5728,'1','277','1',1,'Retail Sale Id 5745',997.36,0.00,0.00,1.37,72.61,'2022-09-05 18:48:52','',''),(5729,'1','277','1',1,'Retail Sale Id 5746',2198.56,0.00,0.00,3.02,160.06,'2022-09-05 19:04:11','',''),(5730,'1','277','1',1,'Retail Sale Id 5747',2198.56,0.00,0.00,3.02,160.06,'2022-09-05 19:05:10','',''),(5731,'1','277','1',1,'Retail Sale Id 5748',9100.00,0.00,0.00,12.50,662.50,'2022-09-05 19:05:53','',''),(5732,'1','277','1',1,'Retail Sale Id 5749',9100.00,0.00,0.00,12.50,662.50,'2022-09-05 19:10:17','',''),(5733,'1','277','1',1,'Retail Sale Id 5750',2999.36,0.00,0.00,4.12,218.36,'2022-09-05 19:11:10','',''),(5734,'1','277','1',1,'Retail Sale Id 5751',8998.08,0.00,0.00,12.36,655.08,'2022-09-06 06:56:10','',''),(5735,'1','277','1',1,'Retail Sale Id 5752',2184.00,0.00,0.00,3.00,159.00,'2022-09-06 07:15:04','',''),(5736,'1','277','1',1,'Retail Sale Id 5753',815.36,0.00,0.00,1.12,59.36,'2022-09-06 07:16:29','',''),(5737,'1','277','1',1,'Retail Sale Id 5754',2198.56,0.00,0.00,3.02,160.06,'2022-09-06 07:21:41','',''),(5738,'1','277','1',1,'Retail Sale Id 5755',4397.12,0.00,0.00,6.04,320.12,'2022-09-06 07:24:10','',''),(5739,'1','277','1',1,'Retail Sale Id 5756',2198.56,0.00,0.00,3.02,160.06,'2022-09-06 07:24:48','',''),(5740,'1','277','1',1,'Retail Sale Id 5757',2002.00,0.00,0.00,2.75,145.75,'2022-09-06 07:36:37','',''),(5741,'1','277','1',1,'Retail Sale Id 5758',2002.00,0.00,0.00,2.75,145.75,'2022-09-06 07:41:10','',''),(5742,'1','277','1',1,'Retail Sale Id 5759',2198.56,0.00,0.00,3.02,160.06,'2022-09-06 07:43:26','',''),(5743,'1','277','1',1,'Retail Sale Id 5760',2198.56,0.00,0.00,3.02,160.06,'2022-09-06 07:46:51','',''),(5744,'1','277','1',1,'Retail Sale Id 5761',2802.80,0.00,0.00,3.85,204.05,'2022-09-06 07:52:12','',''),(5745,'1','277','1',1,'Retail Sale Id 5762',2999.36,0.00,0.00,4.12,218.36,'2022-09-06 08:11:01','',''),(5746,'1','277','1',1,'Retail Sale Id 5763',2198.56,0.00,0.00,3.02,160.06,'2022-09-06 08:17:02','',''),(5747,'1','277','1',1,'Retail Sale Id 5764',2497.04,0.00,0.00,3.43,181.79,'2022-09-06 08:21:12','',''),(5748,'1','277','1',1,'Retail Sale Id 5765',2497.04,0.00,0.00,3.43,181.79,'2022-09-06 08:26:45','',''),(5749,'1','277','1',1,'Retail Sale Id 5766',4499.04,0.00,0.00,6.18,327.54,'2022-09-06 08:27:54','',''),(5750,'1','277','1',1,'Retail Sale Id 5767',2198.56,0.00,0.00,3.02,160.06,'2022-09-06 08:42:35','',''),(5751,'1','277','1',1,'Retail Sale Id 5769',2002.00,0.00,0.00,2.75,145.75,'2022-09-06 08:44:48','',''),(5752,'1','277','1',1,'Retail Sale Id 5770',3501.68,0.00,0.00,4.81,254.93,'2022-09-06 08:58:10','',''),(5753,'1','277','1',1,'Retail Sale Id 5772',2198.56,0.00,0.00,3.02,160.06,'2022-09-06 09:02:38','',''),(5754,'1','277','1',1,'Retail Sale Id 5773',9100.00,0.00,0.00,12.50,662.50,'2022-09-06 09:12:02','',''),(5755,'1','277','1',1,'Retail Sale Id 5774',35000.00,0.00,0.00,50.00,1250.00,'2022-09-06 09:25:20','',''),(5756,'1','277','1',1,'Retail Sale Id 5775',2999.36,0.00,0.00,4.12,218.36,'2022-09-06 09:26:46','',''),(5757,'1','277','1',1,'Retail Sale Id 5776',2919.28,0.00,0.00,4.01,212.53,'2022-09-06 09:27:50','',''),(5758,'1','277','1',1,'Retail Sale Id 5777',4397.12,0.00,0.00,6.04,320.12,'2022-09-06 09:29:12','',''),(5759,'1','277','1',1,'Retail Sale Id 5778',2402.40,0.00,0.00,3.30,174.90,'2022-09-06 09:34:54','',''),(5760,'1','277','1',1,'Retail Sale Id 5779',2184.00,0.00,0.00,3.00,159.00,'2022-09-06 09:39:44','',''),(5761,'1','277','1',1,'Retail Sale Id 5780',7003.36,0.00,0.00,9.62,509.86,'2022-09-06 09:50:31','',''),(5762,'1','277','1',1,'Retail Sale Id 5781',8000.72,0.00,0.00,10.99,582.47,'2022-09-06 09:52:27','',''),(5763,'1','277','1',1,'Retail Sale Id 5783',3501.68,0.00,0.00,4.81,254.93,'2022-09-06 09:56:29','',''),(5764,'1','277','1',1,'Retail Sale Id 5784',4397.12,0.00,0.00,6.04,320.12,'2022-09-06 09:57:59','',''),(5765,'1','277','1',1,'Retail Sale Id 5785',997.36,0.00,0.00,1.37,72.61,'2022-09-06 10:00:20','',''),(5766,'1','277','1',1,'Retail Sale Id 5786',2999.36,0.00,0.00,4.12,218.36,'2022-09-06 10:03:43','',''),(5767,'1','277','1',1,'Retail Sale Id 5787',1303.12,0.00,0.00,1.79,94.87,'2022-09-06 10:08:41','',''),(5768,'1','277','1',1,'Retail Sale Id 5788',5998.72,0.00,0.00,8.24,436.72,'2022-09-06 10:12:50','',''),(5769,'1','277','1',1,'Retail Sale Id 5789',3698.24,0.00,0.00,5.08,269.24,'2022-09-06 10:13:55','',''),(5770,'1','277','1',1,'Retail Sale Id 5790',502.32,0.00,0.00,0.69,36.57,'2022-09-06 10:14:34','',''),(5771,'1','277','1',1,'Retail Sale Id 5791',997.36,0.00,0.00,1.37,72.61,'2022-09-06 10:16:13','',''),(5772,'1','277','1',1,'Retail Sale Id 5792',2999.36,0.00,0.00,4.12,218.36,'2022-09-06 10:19:45','',''),(5773,'1','277','1',1,'Retail Sale Id 5793',2184.00,0.00,0.00,3.00,159.00,'2022-09-06 10:21:44','',''),(5774,'1','277','1',1,'Retail Sale Id 5794',3996.72,0.00,0.00,5.49,290.97,'2022-09-06 10:22:48','',''),(5775,'1','277','1',1,'Retail Sale Id 5795',1499.68,0.00,0.00,2.06,109.18,'2022-09-06 10:24:01','',''),(5776,'1','277','1',1,'Retail Sale Id 5797',1499.68,0.00,0.00,2.06,109.18,'2022-09-06 10:25:54','',''),(5777,'1','277','1',1,'Retail Sale Id 5798',2999.36,0.00,0.00,4.12,218.36,'2022-09-06 10:35:07','',''),(5778,'1','277','1',1,'Retail Sale Id 5799',4397.12,0.00,0.00,6.04,320.12,'2022-09-06 10:41:35','',''),(5779,'1','277','1',1,'Retail Sale Id 5801',4397.12,0.00,0.00,6.04,320.12,'2022-09-06 10:47:27','',''),(5780,'1','277','1',1,'Retail Sale Id 5802',2002.00,0.00,0.00,2.75,145.75,'2022-09-06 10:55:21','',''),(5781,'1','277','1',1,'Retail Sale Id 5803',1499.68,0.00,0.00,2.06,109.18,'2022-09-06 11:19:17','',''),(5782,'1','277','1',1,'Retail Sale Id 5804',2002.00,0.00,0.00,2.75,145.75,'2022-09-06 11:20:32','',''),(5783,'1','277','1',1,'Retail Sale Id 5805',2002.00,0.00,0.00,2.75,145.75,'2022-09-06 11:39:00','',''),(5784,'1','277','1',1,'Retail Sale Id 5806',1499.68,0.00,0.00,2.06,109.18,'2022-09-06 11:40:37','',''),(5785,'1','277','1',1,'Retail Sale Id 5807',997.36,0.00,0.00,1.37,72.61,'2022-09-06 11:45:08','',''),(5786,'1','277','1',1,'Retail Sale Id 5808',2402.40,0.00,0.00,3.30,174.90,'2022-09-06 11:52:33','',''),(5787,'1','277','1',1,'Retail Sale Id 5809',4397.12,0.00,0.00,6.04,320.12,'2022-09-06 11:53:54','',''),(5788,'1','277','1',1,'Retail Sale Id 5810',2999.36,0.00,0.00,4.12,218.36,'2022-09-06 12:02:18','',''),(5789,'1','277','1',1,'Retail Sale Id 5811',1499.68,0.00,0.00,2.06,109.18,'2022-09-06 12:10:36','',''),(5790,'1','277','1',1,'Retail Sale Id 5812',2999.36,0.00,0.00,4.12,218.36,'2022-09-06 12:11:10','',''),(5791,'1','277','1',1,'Retail Sale Id 5813',9100.00,0.00,0.00,12.50,662.50,'2022-09-06 12:15:01','',''),(5792,'1','277','1',1,'Retail Sale Id 5814',2198.56,0.00,0.00,3.02,160.06,'2022-09-06 12:24:20','',''),(5793,'1','277','1',1,'Retail Sale Id 5815',3640.00,0.00,0.00,5.00,265.00,'2022-09-06 12:51:12','',''),(5794,'1','277','1',1,'Retail Sale Id 5816',4397.12,0.00,0.00,6.04,320.12,'2022-09-06 12:55:31','',''),(5795,'1','277','1',1,'Retail Sale Id 5817',5103.28,0.00,0.00,7.01,371.53,'2022-09-06 12:56:11','',''),(5796,'1','277','1',1,'Retail Sale Id 5818',3640.00,0.00,0.00,5.00,265.00,'2022-09-06 12:56:48','',''),(5797,'1','277','1',1,'Retail Sale Id 5819',1499.68,0.00,0.00,2.06,109.18,'2022-09-06 13:02:20','',''),(5798,'1','277','1',1,'Retail Sale Id 5820',2002.00,0.00,0.00,2.75,145.75,'2022-09-06 13:12:39','',''),(5799,'1','277','1',1,'Retail Sale Id 5821',749.84,0.00,0.00,1.03,54.59,'2022-09-06 13:29:14','',''),(5800,'1','277','1',1,'Retail Sale Id 5822',1499.68,0.00,0.00,2.06,109.18,'2022-09-06 13:32:44','',''),(5801,'1','277','1',1,'Retail Sale Id 5823',3501.68,0.00,0.00,4.81,254.93,'2022-09-06 13:35:50','',''),(5802,'1','277','1',1,'Retail Sale Id 5824',1798.16,0.00,0.00,2.47,130.91,'2022-09-06 13:53:33','',''),(5803,'1','277','1',1,'Retail Sale Id 5825',9100.00,0.00,0.00,12.50,662.50,'2022-09-06 13:54:50','',''),(5804,'1','277','1',1,'Retail Sale Id 5826',2198.56,0.00,0.00,3.02,160.06,'2022-09-06 14:01:09','',''),(5805,'1','277','1',1,'Retail Sale Id 5827',10002.72,0.00,0.00,13.74,728.22,'2022-09-06 14:04:19','',''),(5806,'1','277','1',1,'Retail Sale Id 5828',9100.00,0.00,0.00,12.50,662.50,'2022-09-06 14:12:42','',''),(5807,'1','277','1',1,'Retail Sale Id 5830',4499.04,0.00,0.00,6.18,327.54,'2022-09-06 14:14:40','',''),(5808,'1','277','1',1,'Retail Sale Id 5831',2999.36,0.00,0.00,4.12,218.36,'2022-09-06 14:15:22','',''),(5809,'1','277','1',1,'Retail Sale Id 5832',2999.36,0.00,0.00,4.12,218.36,'2022-09-06 14:28:57','',''),(5810,'1','277','1',1,'Retail Sale Id 5833',3647.28,0.00,0.00,5.01,265.53,'2022-09-06 14:33:24','',''),(5811,'1','277','1',1,'Retail Sale Id 5834',4397.12,0.00,0.00,6.04,320.12,'2022-09-06 14:38:28','',''),(5812,'1','277','1',1,'Retail Sale Id 5835',3698.24,0.00,0.00,5.08,269.24,'2022-09-06 14:47:12','',''),(5813,'1','277','1',1,'Retail Sale Id 5836',997.36,0.00,0.00,1.37,72.61,'2022-09-06 14:59:23','',''),(5814,'1','277','1',1,'Retail Sale Id 5837',2002.00,0.00,0.00,2.75,145.75,'2022-09-06 15:00:03','',''),(5815,'1','277','1',1,'Retail Sale Id 5839',2198.56,0.00,0.00,3.02,160.06,'2022-09-06 15:02:06','',''),(5816,'1','277','1',1,'Retail Sale Id 5840',1499.68,0.00,0.00,2.06,109.18,'2022-09-06 15:02:48','',''),(5817,'1','277','1',1,'Retail Sale Id 5841',1601.60,0.00,0.00,2.20,116.60,'2022-09-06 15:07:03','',''),(5818,'1','277','1',1,'Retail Sale Id 5842',4397.12,0.00,0.00,6.04,320.12,'2022-09-06 15:08:48','',''),(5819,'1','277','1',1,'Retail Sale Id 5843',7301.84,0.00,0.00,10.03,531.59,'2022-09-06 15:10:24','',''),(5820,'1','277','1',1,'Retail Sale Id 5844',997.36,0.00,0.00,1.37,72.61,'2022-09-06 15:11:12','',''),(5821,'1','277','1',1,'Retail Sale Id 5845',997.36,0.00,0.00,1.37,72.61,'2022-09-06 15:13:46','',''),(5822,'1','277','1',1,'Retail Sale Id 5846',298.48,0.00,0.00,0.41,21.73,'2022-09-06 15:17:15','',''),(5823,'1','277','1',1,'Retail Sale Id 5847',9100.00,0.00,0.00,12.50,662.50,'2022-09-06 15:21:22','',''),(5824,'1','277','1',1,'Retail Sale Id 5848',1201.20,0.00,0.00,1.65,87.45,'2022-09-06 15:27:11','',''),(5825,'1','277','1',1,'Retail Sale Id 5848',2002.00,0.00,0.00,2.75,145.75,'2022-09-06 15:27:11','',''),(5826,'1','277','1',1,'Retail Sale Id 5849',8102.64,0.00,0.00,11.13,589.89,'2022-09-06 15:36:17','',''),(5827,'1','277','1',1,'Retail Sale Id 5850',7280.00,0.00,0.00,10.00,530.00,'2022-09-06 15:37:21','',''),(5828,'1','277','1',1,'Retail Sale Id 5851',3698.24,0.00,0.00,5.08,269.24,'2022-09-06 15:38:53','',''),(5829,'1','277','1',1,'Retail Sale Id 5852',2497.04,0.00,0.00,3.43,181.79,'2022-09-06 15:39:46','',''),(5830,'1','277','1',1,'Retail Sale Id 5853',4397.12,0.00,0.00,6.04,320.12,'2022-09-06 15:41:14','',''),(5831,'1','277','1',1,'Retail Sale Id 5854',997.36,0.00,0.00,1.37,72.61,'2022-09-06 15:41:51','',''),(5832,'1','277','1',1,'Retail Sale Id 5855',7003.36,0.00,0.00,9.62,509.86,'2022-09-06 15:56:11','',''),(5833,'1','277','1',1,'Retail Sale Id 5856',4397.12,0.00,0.00,6.04,320.12,'2022-09-06 16:00:24','',''),(5834,'1','277','1',1,'Retail Sale Id 5857',5001.36,0.00,0.00,6.87,364.11,'2022-09-06 16:08:21','',''),(5835,'1','277','1',1,'Retail Sale Id 5858',5001.36,0.00,0.00,6.87,364.11,'2022-09-06 16:09:11','',''),(5836,'1','277','1',1,'Retail Sale Id 5859',2999.36,0.00,0.00,4.12,218.36,'2022-09-06 16:09:55','',''),(5837,'1','277','1',1,'Retail Sale Id 5860',2198.56,0.00,0.00,3.02,160.06,'2022-09-06 16:10:49','',''),(5838,'1','277','1',1,'Retail Sale Id 5861',4397.12,0.00,0.00,6.04,320.12,'2022-09-06 16:14:16','',''),(5839,'1','277','1',1,'Retail Sale Id 5862',3603.60,0.00,0.00,4.95,262.35,'2022-09-06 16:15:46','',''),(5840,'1','277','1',1,'Retail Sale Id 5863',4368.00,0.00,0.00,6.00,318.00,'2022-09-06 16:17:17','',''),(5841,'1','277','1',1,'Retail Sale Id 5864',8801.52,0.00,0.00,12.09,640.77,'2022-09-06 16:20:57','',''),(5842,'1','277','1',1,'Return of Retail Sale Id 5861',0.00,4397.12,6.04,0.00,-320.12,'2022-09-06 16:22:49','',''),(5843,'1','277','1',1,'Retail Sale Id 5865',3996.72,0.00,0.00,5.49,290.97,'2022-09-06 16:23:19','',''),(5844,'1','277','1',1,'Retail Sale Id 5866',2999.36,0.00,0.00,4.12,218.36,'2022-09-06 16:24:11','',''),(5845,'1','277','1',1,'Return of Retail Sale Id 5863',0.00,4368.00,6.00,0.00,-318.00,'2022-09-06 16:28:16','',''),(5846,'1','277','1',1,'Retail Sale Id 5867',3640.00,0.00,0.00,5.00,265.00,'2022-09-06 16:29:00','',''),(5847,'1','277','1',1,'Retail Sale Id 5868',2999.36,0.00,0.00,4.12,218.36,'2022-09-06 16:30:06','',''),(5848,'1','277','1',1,'Retail Sale Id 5869',2198.56,0.00,0.00,3.02,160.06,'2022-09-06 16:31:01','',''),(5849,'1','277','1',1,'Retail Sale Id 5870',2002.00,0.00,0.00,2.75,145.75,'2022-09-06 16:33:08','',''),(5850,'1','277','1',1,'Retail Sale Id 5871',1499.68,0.00,0.00,2.06,109.18,'2022-09-06 16:36:12','',''),(5851,'1','277','1',1,'Retail Sale Id 5872',997.36,0.00,0.00,1.37,72.61,'2022-09-06 16:45:33','',''),(5852,'1','277','1',1,'Retail Sale Id 5873',2002.00,0.00,0.00,2.75,145.75,'2022-09-06 16:49:35','',''),(5853,'1','277','1',1,'Retail Sale Id 5874',800.80,0.00,0.00,1.10,58.30,'2022-09-06 16:53:37','',''),(5854,'1','277','1',1,'Retail Sale Id 5875',3647.28,0.00,0.00,5.01,265.53,'2022-09-06 16:54:58','',''),(5855,'1','277','1',1,'Retail Sale Id 5876',9100.00,0.00,0.00,12.50,662.50,'2022-09-06 16:56:05','',''),(5856,'1','277','1',1,'Retail Sale Id 5877',3647.28,0.00,0.00,5.01,265.53,'2022-09-06 16:59:27','',''),(5857,'1','277','1',1,'Retail Sale Id 5878',749.84,0.00,0.00,1.03,54.59,'2022-09-06 17:03:05','',''),(5858,'1','277','1',1,'Retail Sale Id 5879',3647.28,0.00,0.00,5.01,265.53,'2022-09-06 17:05:40','',''),(5859,'1','277','1',1,'Retail Sale Id 5880',12950.00,0.00,0.00,18.50,462.50,'2022-09-06 17:10:00','',''),(5860,'1','277','1',1,'Retail Sale Id 5881',2002.00,0.00,0.00,2.75,145.75,'2022-09-06 17:18:05','',''),(5861,'1','277','1',1,'Retail Sale Id 5882',2919.28,0.00,0.00,4.01,212.53,'2022-09-06 17:20:46','',''),(5862,'1','277','1',1,'Retail Sale Id 5883',2198.56,0.00,0.00,3.02,160.06,'2022-09-06 17:21:55','',''),(5863,'1','277','1',1,'Retail Sale Id 5884',8000.72,0.00,0.00,10.99,582.47,'2022-09-06 17:25:39','',''),(5864,'1','277','1',1,'Retail Sale Id 5885',3996.72,0.00,0.00,5.49,290.97,'2022-09-06 17:26:28','',''),(5865,'1','277','1',1,'Retail Sale Id 5886',997.36,0.00,0.00,1.37,72.61,'2022-09-06 17:29:26','',''),(5866,'1','277','1',1,'Retail Sale Id 5887',4397.12,0.00,0.00,6.04,320.12,'2022-09-06 17:38:57','',''),(5867,'1','277','1',1,'Retail Sale Id 5888',1499.68,0.00,0.00,2.06,109.18,'2022-09-06 17:40:12','',''),(5868,'1','277','1',1,'Retail Sale Id 5889',2198.56,0.00,0.00,3.02,160.06,'2022-09-06 17:45:31','',''),(5869,'1','277','1',1,'Retail Sale Id 5890',997.36,0.00,0.00,1.37,72.61,'2022-09-06 17:55:41','',''),(5870,'1','277','1',1,'Retail Sale Id 5891',749.84,0.00,0.00,1.03,54.59,'2022-09-06 18:02:45','',''),(5871,'1','277','1',1,'Retail Sale Id 5892',3996.72,0.00,0.00,5.49,290.97,'2022-09-06 18:08:37','',''),(5872,'1','277','1',1,'Retail Sale Id 5893',4397.12,0.00,0.00,6.04,320.12,'2022-09-06 18:10:41','',''),(5873,'1','277','1',1,'Retail Sale Id 5894',1499.68,0.00,0.00,2.06,109.18,'2022-09-06 18:13:19','',''),(5874,'1','277','1',1,'Retail Sale Id 5895',997.36,0.00,0.00,1.37,72.61,'2022-09-06 18:13:55','',''),(5875,'1','277','1',1,'Retail Sale Id 5896',4397.12,0.00,0.00,6.04,320.12,'2022-09-06 18:15:16','',''),(5876,'1','277','1',1,'Retail Sale Id 5897',1499.68,0.00,0.00,2.06,109.18,'2022-09-06 18:21:34','',''),(5877,'1','277','1',1,'Retail Sale Id 5898',2198.56,0.00,0.00,3.02,160.06,'2022-09-06 18:23:30','',''),(5878,'1','277','1',1,'Retail Sale Id 5899',2002.00,0.00,0.00,2.75,145.75,'2022-09-06 18:25:33','',''),(5879,'1','277','1',1,'Retail Sale Id 5900',2096.64,0.00,0.00,2.88,152.64,'2022-09-06 18:30:40','',''),(5880,'1','277','1',1,'Retail Sale Id 5901',2002.00,0.00,0.00,2.75,145.75,'2022-09-06 18:36:12','',''),(5881,'1','277','1',1,'Retail Sale Id 5902',2002.00,0.00,0.00,2.75,145.75,'2022-09-06 18:38:56','',''),(5882,'1','277','1',1,'Retail Sale Id 5903',298.48,0.00,0.00,0.41,21.73,'2022-09-06 18:41:34','',''),(5883,'1','277','1',1,'Retail Sale Id 5904',9100.00,0.00,0.00,12.50,662.50,'2022-09-06 18:42:10','',''),(5884,'1','277','1',1,'Retail Sale Id 5905',4499.04,0.00,0.00,6.18,327.54,'2022-09-06 18:44:19','',''),(5885,'1','277','1',1,'Retail Sale Id 5906',16380.00,0.00,0.00,22.50,1192.50,'2022-09-06 18:45:36','',''),(5886,'1','277','1',1,'Retail Sale Id 5907',3640.00,0.00,0.00,5.00,265.00,'2022-09-06 18:49:34','',''),(5887,'1','277','1',1,'Retail Sale Id 5908',1499.68,0.00,0.00,2.06,109.18,'2022-09-06 18:53:13','',''),(5888,'1','277','1',1,'Retail Sale Id 5909',2198.56,0.00,0.00,3.02,160.06,'2022-09-06 18:58:05','',''),(5889,'1','277','1',1,'Retail Sale Id 5910',2497.04,0.00,0.00,3.43,181.79,'2022-09-06 19:08:16','',''),(5890,'1','277','1',1,'Retail Sale Id 5911',2002.00,0.00,0.00,2.75,145.75,'2022-09-06 19:08:59','',''),(5891,'1','277','1',1,'Retail Sale Id 5912',1499.68,0.00,0.00,2.06,109.18,'2022-09-06 19:09:42','',''),(5892,'1','277','1',1,'Retail Sale Id 5913',2198.56,0.00,0.00,3.02,160.06,'2022-09-06 19:11:51','',''),(5893,'1','277','1',1,'Retail Sale Id 5914',2999.36,0.00,0.00,4.12,218.36,'2022-09-06 19:16:06','',''),(5894,'1','277','1',1,'Retail Sale Id 5915',2999.36,0.00,0.00,4.12,218.36,'2022-09-06 19:21:41','',''),(5895,'1','277','1',1,'Return of Retail Sale Id 5880',0.00,12950.00,18.50,0.00,-462.50,'2022-09-06 20:11:15','',''),(5896,'1','277','1',1,'Retail Sale Id 5916',13006.00,0.00,0.00,18.58,464.50,'2022-09-06 20:12:06','',''),(5897,'1','277','1',1,'Return of Retail Sale Id 5915',0.00,2999.36,4.12,0.00,-218.36,'2022-09-06 20:13:33','',''),(5898,'1','277','1',1,'Retail Sale Id 5917',2839.20,0.00,0.00,3.90,206.70,'2022-09-06 20:14:33','',''),(5899,'1','277','1',1,'Return of Retail Sale Id 5917',0.00,2839.20,3.90,0.00,-206.70,'2022-09-06 20:17:05','',''),(5900,'1','277','1',1,'Retail Sale Id 5918',2700.88,0.00,0.00,3.71,196.63,'2022-09-06 20:17:39','',''),(5901,'1','277','1',1,'Return of Retail Sale Id 5918',0.00,2700.88,3.71,0.00,-196.63,'2022-09-06 20:18:33','',''),(5902,'1','277','1',1,'Retail Sale Id 5919',2999.36,0.00,0.00,4.12,218.36,'2022-09-06 20:18:54','',''),(5903,'1','277','1',1,'Return of Retail Sale Id 5860',0.00,2198.56,3.02,0.00,-160.06,'2022-09-06 20:22:56','',''),(5904,'1','277','1',1,'Retail Sale Id 5920',2060.24,0.00,0.00,2.83,149.99,'2022-09-06 20:23:43','',''),(5905,'1','277','1',1,'Retail Sale Id 5921',997.36,0.00,0.00,1.37,72.61,'2022-09-07 06:19:02','',''),(5906,'1','277','1',1,'Retail Sale Id 5922',2002.00,0.00,0.00,2.75,145.75,'2022-09-07 06:20:29','',''),(5907,'1','277','1',1,'Retail Sale Id 5923',800.80,0.00,0.00,1.10,58.30,'2022-09-07 06:25:13','',''),(5908,'1','277','1',1,'Retail Sale Id 5924',8998.08,0.00,0.00,12.36,655.08,'2022-09-07 06:46:47','',''),(5909,'1','277','1',1,'Retail Sale Id 5925',35000.00,0.00,0.00,50.00,1250.00,'2022-09-07 07:30:57','',''),(5910,'1','277','1',1,'Retail Sale Id 5926',2002.00,0.00,0.00,2.75,145.75,'2022-09-07 07:46:29','',''),(5911,'1','277','1',1,'Retail Sale Id 5927',2497.04,0.00,0.00,3.43,181.79,'2022-09-07 07:49:46','',''),(5912,'1','277','1',1,'Retail Sale Id 5928',2002.00,0.00,0.00,2.75,145.75,'2022-09-07 07:51:32','',''),(5913,'1','277','1',1,'Retail Sale Id 5929',1499.68,0.00,0.00,2.06,109.18,'2022-09-07 07:58:32','',''),(5914,'1','277','1',1,'Retail Sale Id 5930',42000.00,0.00,0.00,60.00,1500.00,'2022-09-07 08:21:37','',''),(5915,'1','277','1',1,'Retail Sale Id 5931',997.36,0.00,0.00,1.37,72.61,'2022-09-07 08:22:19','',''),(5916,'1','277','1',1,'Retail Sale Id 5932',728.00,0.00,0.00,1.00,53.00,'2022-09-07 08:23:23','',''),(5917,'1','277','1',1,'Retail Sale Id 5933',3698.24,0.00,0.00,5.08,269.24,'2022-09-07 08:23:56','',''),(5918,'1','277','1',1,'Retail Sale Id 5934',3996.72,0.00,0.00,5.49,290.97,'2022-09-07 08:24:42','',''),(5919,'1','277','1',1,'Return of Retail Sale Id 5932',0.00,728.00,1.00,0.00,-53.00,'2022-09-07 08:25:14','',''),(5920,'1','277','1',1,'Retail Sale Id 5935',9100.00,0.00,0.00,12.50,662.50,'2022-09-07 08:28:46','',''),(5921,'1','277','1',1,'Retail Sale Id 5936',997.36,0.00,0.00,1.37,72.61,'2022-09-07 08:35:55','',''),(5922,'1','277','1',1,'Retail Sale Id 5937',3698.24,0.00,0.00,5.08,269.24,'2022-09-07 08:41:46','',''),(5923,'1','277','1',1,'Retail Sale Id 5938',997.36,0.00,0.00,1.37,72.61,'2022-09-07 08:45:09','',''),(5924,'1','277','1',1,'Retail Sale Id 5939',9100.00,0.00,0.00,12.50,662.50,'2022-09-07 08:46:26','',''),(5925,'1','277','1',1,'Retail Sale Id 5940',2002.00,0.00,0.00,2.75,145.75,'2022-09-07 08:56:11','',''),(5926,'1','277','1',1,'Retail Sale Id 5941',9100.00,0.00,0.00,12.50,662.50,'2022-09-07 08:58:08','',''),(5927,'1','277','1',1,'Retail Sale Id 5942',1201.20,0.00,0.00,1.65,87.45,'2022-09-07 09:06:00','',''),(5928,'1','277','1',1,'Retail Sale Id 5943',2184.00,0.00,0.00,3.00,159.00,'2022-09-07 09:07:55','',''),(5929,'1','277','1',1,'Retail Sale Id 5944',1499.68,0.00,0.00,2.06,109.18,'2022-09-07 09:09:30','',''),(5930,'1','277','1',1,'Retail Sale Id 5945',3501.68,0.00,0.00,4.81,254.93,'2022-09-07 09:12:17','',''),(5931,'1','277','1',1,'Retail Sale Id 5946',4397.12,0.00,0.00,6.04,320.12,'2022-09-07 09:14:50','',''),(5932,'1','277','1',1,'Retail Sale Id 5947',5001.36,0.00,0.00,6.87,364.11,'2022-09-07 09:24:08','',''),(5933,'1','277','1',1,'Retail Sale Id 5948',2999.36,0.00,0.00,4.12,218.36,'2022-09-07 09:25:47','',''),(5934,'1','277','1',1,'Retail Sale Id 5949',2198.56,0.00,0.00,3.02,160.06,'2022-09-07 09:28:58','',''),(5935,'1','277','1',1,'Retail Sale Id 5950',4397.12,0.00,0.00,6.04,320.12,'2022-09-07 09:32:13','',''),(5936,'1','277','1',1,'Retail Sale Id 5951',502.32,0.00,0.00,0.69,36.57,'2022-09-07 09:36:06','',''),(5937,'1','277','1',1,'Retail Sale Id 5952',2999.36,0.00,0.00,4.12,218.36,'2022-09-07 09:47:58','',''),(5938,'1','277','1',1,'Retail Sale Id 5953',4499.04,0.00,0.00,6.18,327.54,'2022-09-07 10:08:49','',''),(5939,'1','277','1',1,'Retail Sale Id 5954',1499.68,0.00,0.00,2.06,109.18,'2022-09-07 10:35:19','',''),(5940,'1','277','1',1,'Retail Sale Id 5955',3996.72,0.00,0.00,5.49,290.97,'2022-09-07 10:40:10','',''),(5941,'1','277','1',1,'Retail Sale Id 5956',698.88,0.00,0.00,0.96,50.88,'2022-09-07 10:49:04','',''),(5942,'1','277','1',1,'Retail Sale Id 5957',2497.04,0.00,0.00,3.43,181.79,'2022-09-07 10:51:09','',''),(5943,'1','277','1',1,'Retail Sale Id 5958',502.32,0.00,0.00,0.69,36.57,'2022-09-07 10:56:56','',''),(5944,'1','277','1',1,'Retail Sale Id 5959',2919.28,0.00,0.00,4.01,212.53,'2022-09-07 11:14:52','',''),(5945,'1','277','1',1,'Retail Sale Id 5960',1201.20,0.00,0.00,1.65,87.45,'2022-09-07 11:16:08','',''),(5946,'1','277','1',1,'Retail Sale Id 5961',29120.00,0.00,0.00,40.00,2120.00,'2022-09-07 11:18:50','',''),(5947,'1','277','1',1,'Retail Sale Id 5962',3640.00,0.00,0.00,5.00,265.00,'2022-09-07 11:21:40','',''),(5948,'1','277','1',1,'Retail Sale Id 5963',2198.56,0.00,0.00,3.02,160.06,'2022-09-07 11:25:11','',''),(5949,'1','277','1',1,'Retail Sale Id 5964',997.36,0.00,0.00,1.37,72.61,'2022-09-07 11:28:41','',''),(5950,'1','277','1',1,'Retail Sale Id 5965',3996.72,0.00,0.00,5.49,290.97,'2022-09-07 11:30:26','',''),(5951,'1','277','1',1,'Retail Sale Id 5966',997.36,0.00,0.00,1.37,72.61,'2022-09-07 11:39:01','',''),(5952,'1','277','1',1,'Retail Sale Id 5967',502.32,0.00,0.00,0.69,36.57,'2022-09-07 11:54:26','',''),(5953,'1','277','1',1,'Retail Sale Id 5968',800.80,0.00,0.00,1.10,58.30,'2022-09-07 11:58:11','',''),(5954,'1','277','1',1,'Retail Sale Id 5969',2198.56,0.00,0.00,3.02,160.06,'2022-09-07 12:05:19','',''),(5955,'1','277','1',1,'Retail Sale Id 5970',749.84,0.00,0.00,1.03,54.59,'2022-09-07 12:10:09','',''),(5956,'1','277','1',1,'Retail Sale Id 5971',42000.00,0.00,0.00,60.00,1500.00,'2022-09-07 12:30:01','',''),(5957,'1','277','1',1,'Retail Sale Id 5972',3501.68,0.00,0.00,4.81,254.93,'2022-09-07 12:31:54','',''),(5958,'1','277','1',1,'Retail Sale Id 5973',2002.00,0.00,0.00,2.75,145.75,'2022-09-07 12:32:35','',''),(5959,'1','277','1',1,'Retail Sale Id 5974',2999.36,0.00,0.00,4.12,218.36,'2022-09-07 12:43:26','',''),(5960,'1','277','1',1,'Retail Sale Id 5975',6501.04,0.00,0.00,8.93,473.29,'2022-09-07 12:44:27','',''),(5961,'1','277','1',1,'Retail Sale Id 5976',1499.68,0.00,0.00,2.06,109.18,'2022-09-07 12:50:47','',''),(5962,'1','277','1',1,'Retail Sale Id 5977',3698.24,0.00,0.00,5.08,269.24,'2022-09-07 12:58:16','',''),(5963,'1','277','1',1,'Retail Sale Id 5978',4499.04,0.00,0.00,6.18,327.54,'2022-09-07 12:59:07','',''),(5964,'1','277','1',1,'Retail Sale Id 5979',502.32,0.00,0.00,0.69,36.57,'2022-09-07 13:07:19','',''),(5965,'1','277','1',1,'Retail Sale Id 5980',4448.08,0.00,0.00,6.11,323.83,'2022-09-07 13:08:15','',''),(5966,'1','277','1',1,'Retail Sale Id 5981',1499.68,0.00,0.00,2.06,109.18,'2022-09-07 13:09:17','',''),(5967,'1','277','1',1,'Retail Sale Id 5982',2002.00,0.00,0.00,2.75,145.75,'2022-09-07 13:20:54','',''),(5968,'1','277','1',1,'Retail Sale Id 5983',2999.36,0.00,0.00,4.12,218.36,'2022-09-07 13:23:51','',''),(5969,'1','277','1',1,'Retail Sale Id 5984',1703.52,0.00,0.00,2.34,124.02,'2022-09-07 13:31:34','',''),(5970,'1','277','1',1,'Retail Sale Id 5985',9100.00,0.00,0.00,12.50,662.50,'2022-09-07 13:46:14','',''),(5971,'1','277','1',1,'Retail Sale Id 5986',2198.56,0.00,0.00,3.02,160.06,'2022-09-07 13:47:54','',''),(5972,'1','277','1',1,'Retail Sale Id 5987',2999.36,0.00,0.00,4.12,218.36,'2022-09-07 13:51:22','',''),(5973,'1','277','1',1,'Retail Sale Id 5988',4397.12,0.00,0.00,6.04,320.12,'2022-09-07 14:03:23','',''),(5974,'1','277','1',1,'Retail Sale Id 5989',2999.36,0.00,0.00,4.12,218.36,'2022-09-07 14:10:43','',''),(5975,'1','277','1',1,'Retail Sale Id 5990',1499.68,0.00,0.00,2.06,109.18,'2022-09-07 14:20:14','',''),(5976,'1','277','1',1,'Retail Sale Id 5991',3996.72,0.00,0.00,5.49,290.97,'2022-09-07 14:31:21','',''),(5977,'1','277','1',1,'Retail Sale Id 5992',2198.56,0.00,0.00,3.02,160.06,'2022-09-07 14:33:52','',''),(5978,'1','277','1',1,'Retail Sale Id 5993',2002.00,0.00,0.00,2.75,145.75,'2022-09-07 14:34:32','',''),(5979,'1','277','1',1,'Retail Sale Id 5994',3698.24,0.00,0.00,5.08,269.24,'2022-09-07 14:40:43','',''),(5980,'1','277','1',1,'Retail Sale Id 5995',3698.24,0.00,0.00,5.08,269.24,'2022-09-07 14:44:36','',''),(5981,'1','277','1',1,'Retail Sale Id 5996',9100.00,0.00,0.00,12.50,662.50,'2022-09-07 14:45:35','',''),(5982,'1','277','1',1,'Retail Sale Id 5997',2999.36,0.00,0.00,4.12,218.36,'2022-09-07 14:51:42','',''),(5983,'1','277','1',1,'Retail Sale Id 5998',2999.36,0.00,0.00,4.12,218.36,'2022-09-07 14:56:24','',''),(5984,'1','277','1',1,'Retail Sale Id 5999',2999.36,0.00,0.00,4.12,218.36,'2022-09-07 15:02:14','',''),(5985,'1','277','1',1,'Retail Sale Id 6000',9100.00,0.00,0.00,12.50,662.50,'2022-09-07 15:08:56','',''),(5986,'1','277','1',1,'Retail Sale Id 6001',1499.68,0.00,0.00,2.06,109.18,'2022-09-07 15:18:54','',''),(5987,'1','277','1',1,'Retail Sale Id 6002',749.84,0.00,0.00,1.03,54.59,'2022-09-07 15:22:14','',''),(5988,'1','277','1',1,'Retail Sale Id 6003',4397.12,0.00,0.00,6.04,320.12,'2022-09-07 15:27:21','',''),(5989,'1','277','1',1,'Retail Sale Id 6004',4397.12,0.00,0.00,6.04,320.12,'2022-09-07 15:32:41','',''),(5990,'1','277','1',1,'Retail Sale Id 6005',749.84,0.00,0.00,1.03,54.59,'2022-09-07 15:40:19','',''),(5991,'1','277','1',1,'Retail Sale Id 6006',1499.68,0.00,0.00,2.06,109.18,'2022-09-07 15:45:03','',''),(5992,'1','277','1',1,'Retail Sale Id 6007',2497.04,0.00,0.00,3.43,181.79,'2022-09-07 15:49:42','',''),(5993,'1','277','1',1,'Retail Sale Id 6008',9100.00,0.00,0.00,12.50,662.50,'2022-09-07 15:57:05','',''),(5994,'1','277','1',1,'Retail Sale Id 6009',4397.12,0.00,0.00,6.04,320.12,'2022-09-07 16:09:41','',''),(5995,'1','277','1',1,'Retail Sale Id 6010',2198.56,0.00,0.00,3.02,160.06,'2022-09-07 16:10:44','',''),(5996,'1','277','1',1,'Retail Sale Id 6011',3647.28,0.00,0.00,5.01,265.53,'2022-09-07 16:14:07','',''),(5997,'1','277','1',1,'Retail Sale Id 6012',2002.00,0.00,0.00,2.75,145.75,'2022-09-07 16:15:04','',''),(5998,'1','277','1',1,'Retail Sale Id 6013',997.36,0.00,0.00,1.37,72.61,'2022-09-07 16:15:55','',''),(5999,'1','277','1',1,'Retail Sale Id 6014',4397.12,0.00,0.00,6.04,320.12,'2022-09-07 16:18:03','',''),(6000,'1','277','1',1,'Retail Sale Id 6015',1499.68,0.00,0.00,2.06,109.18,'2022-09-07 16:20:33','',''),(6001,'1','277','1',1,'Retail Sale Id 6016',2198.56,0.00,0.00,3.02,160.06,'2022-09-07 16:31:10','',''),(6002,'1','277','1',1,'Retail Sale Id 6017',2999.36,0.00,0.00,4.12,218.36,'2022-09-07 16:33:03','',''),(6003,'1','277','1',1,'Retail Sale Id 6018',1703.52,0.00,0.00,2.34,124.02,'2022-09-07 16:40:12','',''),(6004,'1','277','1',1,'Retail Sale Id 6019',3647.28,0.00,0.00,5.01,265.53,'2022-09-07 16:41:13','',''),(6005,'1','277','1',1,'Retail Sale Id 6020',4499.04,0.00,0.00,6.18,327.54,'2022-09-07 16:42:04','',''),(6006,'1','277','1',1,'Retail Sale Id 6021',997.36,0.00,0.00,1.37,72.61,'2022-09-07 16:46:23','',''),(6007,'1','277','1',1,'Retail Sale Id 6022',1499.68,0.00,0.00,2.06,109.18,'2022-09-07 16:48:44','',''),(6008,'1','277','1',1,'Retail Sale Id 6023',1499.68,0.00,0.00,2.06,109.18,'2022-09-07 16:51:52','',''),(6009,'1','277','1',1,'Retail Sale Id 6024',2300.48,0.00,0.00,3.16,167.48,'2022-09-07 16:53:47','',''),(6010,'1','277','1',1,'Retail Sale Id 6025',800.80,0.00,0.00,1.10,58.30,'2022-09-07 16:54:47','',''),(6011,'1','277','1',1,'Retail Sale Id 6026',4397.12,0.00,0.00,6.04,320.12,'2022-09-07 16:56:14','',''),(6012,'1','277','1',1,'Retail Sale Id 6027',4368.00,0.00,0.00,6.00,318.00,'2022-09-07 16:57:36','',''),(6013,'1','277','1',1,'Retail Sale Id 6028',2198.56,0.00,0.00,3.02,160.06,'2022-09-07 17:05:28','',''),(6014,'1','277','1',1,'Retail Sale Id 6029',997.36,0.00,0.00,1.37,72.61,'2022-09-07 17:09:28','',''),(6015,'1','277','1',1,'Retail Sale Id 6030',997.36,0.00,0.00,1.37,72.61,'2022-09-07 17:10:05','',''),(6016,'1','277','1',1,'Retail Sale Id 6031',1499.68,0.00,0.00,2.06,109.18,'2022-09-07 17:10:52','',''),(6017,'1','277','1',1,'Retail Sale Id 6032',2198.56,0.00,0.00,3.02,160.06,'2022-09-07 17:11:43','',''),(6018,'1','277','1',1,'Retail Sale Id 6033',2002.00,0.00,0.00,2.75,145.75,'2022-09-07 17:15:05','',''),(6019,'1','277','1',1,'Retail Sale Id 6034',997.36,0.00,0.00,1.37,72.61,'2022-09-07 17:18:04','',''),(6020,'1','277','1',1,'Retail Sale Id 6035',4397.12,0.00,0.00,6.04,320.12,'2022-09-07 17:22:14','',''),(6021,'1','277','1',1,'Retail Sale Id 6036',997.36,0.00,0.00,1.37,72.61,'2022-09-07 17:22:53','',''),(6022,'1','277','1',1,'Retail Sale Id 6037',997.36,0.00,0.00,1.37,72.61,'2022-09-07 17:23:27','',''),(6023,'1','277','1',1,'Retail Sale Id 6038',800.80,0.00,0.00,1.10,58.30,'2022-09-07 17:30:14','',''),(6024,'1','277','1',1,'Retail Sale Id 6039',3698.24,0.00,0.00,5.08,269.24,'2022-09-07 17:32:57','',''),(6025,'1','277','1',1,'Retail Sale Id 6040',2999.36,0.00,0.00,4.12,218.36,'2022-09-07 17:33:35','',''),(6026,'1','277','1',1,'Retail Sale Id 6041',3501.68,0.00,0.00,4.81,254.93,'2022-09-07 17:34:06','',''),(6027,'1','277','1',1,'Retail Sale Id 6042',1499.68,0.00,0.00,2.06,109.18,'2022-09-07 17:34:48','',''),(6028,'1','277','1',1,'Retail Sale Id 6043',3640.00,0.00,0.00,5.00,265.00,'2022-09-07 17:36:47','',''),(6029,'1','277','1',1,'Retail Sale Id 6044',2198.56,0.00,0.00,3.02,160.06,'2022-09-07 17:37:23','',''),(6030,'1','277','1',1,'Retail Sale Id 6045',2198.56,0.00,0.00,3.02,160.06,'2022-09-07 17:46:07','',''),(6031,'1','277','1',1,'Retail Sale Id 6046',2198.56,0.00,0.00,3.02,160.06,'2022-09-07 17:47:04','',''),(6032,'1','277','1',1,'Retail Sale Id 6047',5001.36,0.00,0.00,6.87,364.11,'2022-09-07 17:48:06','',''),(6033,'1','277','1',1,'Retail Sale Id 6048',749.84,0.00,0.00,1.03,54.59,'2022-09-07 17:48:46','',''),(6034,'1','277','1',1,'Retail Sale Id 6049',502.32,0.00,0.00,0.69,36.57,'2022-09-07 17:53:11','',''),(6035,'1','277','1',1,'Retail Sale Id 6050',2999.36,0.00,0.00,4.12,218.36,'2022-09-07 17:54:37','',''),(6036,'1','277','1',1,'Retail Sale Id 6051',2198.56,0.00,0.00,3.02,160.06,'2022-09-07 17:57:05','',''),(6037,'1','277','1',1,'Retail Sale Id 6052',2198.56,0.00,0.00,3.02,160.06,'2022-09-07 17:57:54','',''),(6038,'1','277','1',1,'Retail Sale Id 6053',2198.56,0.00,0.00,3.02,160.06,'2022-09-07 17:58:51','',''),(6039,'1','277','1',1,'Retail Sale Id 6054',2999.36,0.00,0.00,4.12,218.36,'2022-09-07 18:01:00','',''),(6040,'1','277','1',1,'Retail Sale Id 6055',2002.00,0.00,0.00,2.75,145.75,'2022-09-07 18:01:40','',''),(6041,'1','277','1',1,'Retail Sale Id 6056',2002.00,0.00,0.00,2.75,145.75,'2022-09-07 18:02:18','',''),(6042,'1','277','1',1,'Retail Sale Id 6057',1499.68,0.00,0.00,2.06,109.18,'2022-09-07 18:02:49','',''),(6043,'1','277','1',1,'Retail Sale Id 6058',9100.00,0.00,0.00,12.50,662.50,'2022-09-07 18:04:53','',''),(6044,'1','277','1',1,'Retail Sale Id 6059',9100.00,0.00,0.00,12.50,662.50,'2022-09-07 18:08:02','',''),(6045,'1','277','1',1,'Retail Sale Id 6060',2999.36,0.00,0.00,4.12,218.36,'2022-09-07 18:09:56','',''),(6046,'1','277','1',1,'Retail Sale Id 6061',1499.68,0.00,0.00,2.06,109.18,'2022-09-07 18:10:21','',''),(6047,'1','277','1',1,'Retail Sale Id 6062',3996.72,0.00,0.00,5.49,290.97,'2022-09-07 18:11:02','',''),(6048,'1','277','1',1,'Retail Sale Id 6063',8801.52,0.00,0.00,12.09,640.77,'2022-09-07 18:13:01','',''),(6049,'1','277','1',1,'Retail Sale Id 6064',8000.72,0.00,0.00,10.99,582.47,'2022-09-07 18:14:03','',''),(6050,'1','277','1',1,'Retail Sale Id 6065',2497.04,0.00,0.00,3.43,181.79,'2022-09-07 18:15:35','',''),(6051,'1','277','1',1,'Retail Sale Id 6066',2198.56,0.00,0.00,3.02,160.06,'2022-09-07 18:19:48','',''),(6052,'1','277','1',1,'Retail Sale Id 6067',3996.72,0.00,0.00,5.49,290.97,'2022-09-07 18:21:27','',''),(6053,'1','277','1',1,'Retail Sale Id 6068',1499.68,0.00,0.00,2.06,109.18,'2022-09-07 18:22:27','',''),(6054,'1','277','1',1,'Retail Sale Id 6070',1397.76,0.00,0.00,1.92,101.76,'2022-09-07 18:24:44','',''),(6055,'1','277','1',1,'Retail Sale Id 6071',2002.00,0.00,0.00,2.75,145.75,'2022-09-07 18:26:29','',''),(6056,'1','277','1',1,'Retail Sale Id 6072',1499.68,0.00,0.00,2.06,109.18,'2022-09-07 18:29:32','',''),(6057,'1','277','1',1,'Retail Sale Id 6073',9100.00,0.00,0.00,12.50,662.50,'2022-09-07 18:31:28','',''),(6058,'1','277','1',1,'Retail Sale Id 6074',9100.00,0.00,0.00,12.50,662.50,'2022-09-07 18:33:09','',''),(6059,'1','277','1',1,'Retail Sale Id 6075',749.84,0.00,0.00,1.03,54.59,'2022-09-07 18:35:53','',''),(6060,'1','277','1',1,'Retail Sale Id 6076',2184.00,0.00,0.00,3.00,159.00,'2022-09-07 18:42:31','',''),(6061,'1','277','1',1,'Retail Sale Id 6077',3501.68,0.00,0.00,4.81,254.93,'2022-09-07 18:44:31','',''),(6062,'1','277','1',1,'Retail Sale Id 6078',1499.68,0.00,0.00,2.06,109.18,'2022-09-07 18:52:24','',''),(6063,'1','277','1',1,'Retail Sale Id 6079',2999.36,0.00,0.00,4.12,218.36,'2022-09-07 18:53:12','',''),(6064,'1','277','1',1,'Retail Sale Id 6080',1499.68,0.00,0.00,2.06,109.18,'2022-09-07 18:58:24','',''),(6065,'1','277','1',1,'Retail Sale Id 6081',1499.68,0.00,0.00,2.06,109.18,'2022-09-07 18:59:55','',''),(6066,'1','277','1',1,'Retail Sale Id 6082',4368.00,0.00,0.00,6.00,318.00,'2022-09-07 19:06:09','',''),(6067,'1','277','1',1,'Retail Sale Id 6083',3640.00,0.00,0.00,5.00,265.00,'2022-09-07 19:11:56','',''),(6068,'1','277','1',1,'Retail Sale Id 6084',997.36,0.00,0.00,1.37,72.61,'2022-09-07 19:14:13','',''),(6069,'1','277','1',1,'Retail Sale Id 6085',1201.20,0.00,0.00,1.65,87.45,'2022-09-07 19:17:21','',''),(6070,'1','277','1',1,'Retail Sale Id 6086',378.56,0.00,0.00,0.52,27.56,'2022-09-07 19:36:10','',''),(6071,'1','277','1',1,'Return of Retail Sale Id 6086',0.00,378.56,0.52,0.00,-27.56,'2022-09-07 19:41:33','',''),(6072,'1','277','1',1,'Return of Retail Sale Id 6071',0.00,2002.00,2.75,0.00,-145.75,'2022-09-07 19:43:48','',''),(6073,'1','277','1',1,'Retail Sale Id 6087',1623.44,0.00,0.00,2.23,118.19,'2022-09-07 19:44:22','',''),(6074,'1','277','1',1,'Retail Sale Id 6088',1499.68,0.00,0.00,2.06,109.18,'2022-09-08 06:49:08','',''),(6075,'1','277','1',1,'Retail Sale Id 6089',3640.00,0.00,0.00,5.00,265.00,'2022-09-08 07:04:40','',''),(6076,'1','277','1',1,'Retail Sale Id 6090',2912.00,0.00,0.00,4.00,212.00,'2022-09-08 07:05:57','',''),(6077,'1','277','1',1,'Retail Sale Id 6091',2198.56,0.00,0.00,3.02,160.06,'2022-09-08 07:10:19','',''),(6078,'1','277','1',1,'Retail Sale Id 6092',997.36,0.00,0.00,1.37,72.61,'2022-09-08 07:14:01','',''),(6079,'1','277','1',1,'Retail Sale Id 6093',2184.00,0.00,0.00,3.00,159.00,'2022-09-08 07:21:47','',''),(6080,'1','277','1',1,'Retail Sale Id 6094',5001.36,0.00,0.00,6.87,364.11,'2022-09-08 07:25:17','',''),(6081,'1','277','1',1,'Retail Sale Id 6095',2198.56,0.00,0.00,3.02,160.06,'2022-09-08 07:29:29','',''),(6082,'1','277','1',1,'Retail Sale Id 6096',5853.12,0.00,0.00,8.04,426.12,'2022-09-08 07:36:13','',''),(6083,'1','277','1',1,'Retail Sale Id 6097',2198.56,0.00,0.00,3.02,160.06,'2022-09-08 07:37:17','',''),(6084,'1','277','1',1,'Retail Sale Id 6098',2999.36,0.00,0.00,4.12,218.36,'2022-09-08 07:43:10','',''),(6085,'1','277','1',1,'Retail Sale Id 6099',2999.36,0.00,0.00,4.12,218.36,'2022-09-08 07:46:00','',''),(6086,'1','277','1',1,'Retail Sale Id 6100',1499.68,0.00,0.00,2.06,109.18,'2022-09-08 07:50:50','',''),(6087,'1','277','1',1,'Retail Sale Id 6101',42700.00,0.00,0.00,61.00,1525.00,'2022-09-08 08:00:32','',''),(6088,'1','277','1',1,'Retail Sale Id 6102',2912.00,0.00,0.00,4.00,212.00,'2022-09-08 08:05:21','',''),(6089,'1','277','1',1,'Retail Sale Id 6103',4397.12,0.00,0.00,6.04,320.12,'2022-09-08 08:29:29','',''),(6090,'1','277','1',1,'Retail Sale Id 6104',2497.04,0.00,0.00,3.43,181.79,'2022-09-08 08:33:31','',''),(6091,'1','277','1',1,'Retail Sale Id 6105',1499.68,0.00,0.00,2.06,109.18,'2022-09-08 08:34:03','',''),(6092,'1','277','1',1,'Retail Sale Id 6106',2999.36,0.00,0.00,4.12,218.36,'2022-09-08 08:34:55','',''),(6093,'1','277','1',1,'Retail Sale Id 6107',3996.72,0.00,0.00,5.49,290.97,'2022-09-08 08:35:46','',''),(6094,'1','277','1',1,'Retail Sale Id 6108',4368.00,0.00,0.00,6.00,318.00,'2022-09-08 08:38:33','',''),(6095,'1','277','1',1,'Retail Sale Id 6109',2999.36,0.00,0.00,4.12,218.36,'2022-09-08 08:39:34','',''),(6096,'1','277','1',1,'Retail Sale Id 6110',4368.00,0.00,0.00,6.00,318.00,'2022-09-08 08:44:24','',''),(6097,'1','277','1',1,'Retail Sale Id 6111',3698.24,0.00,0.00,5.08,269.24,'2022-09-08 08:46:58','',''),(6098,'1','277','1',1,'Retail Sale Id 6112',1499.68,0.00,0.00,2.06,109.18,'2022-09-08 08:47:49','',''),(6099,'1','277','1',1,'Retail Sale Id 6113',2002.00,0.00,0.00,2.75,145.75,'2022-09-08 08:48:38','',''),(6100,'1','277','1',1,'Retail Sale Id 6114',2999.36,0.00,0.00,4.12,218.36,'2022-09-08 08:50:02','',''),(6101,'1','277','1',1,'Retail Sale Id 6115',2002.00,0.00,0.00,2.75,145.75,'2022-09-08 08:51:59','',''),(6102,'1','277','1',1,'Retail Sale Id 6116',2002.00,0.00,0.00,2.75,145.75,'2022-09-08 08:59:01','',''),(6103,'1','277','1',1,'Retail Sale Id 6117',5853.12,0.00,0.00,8.04,426.12,'2022-09-08 09:02:12','',''),(6104,'1','277','1',1,'Retail Sale Id 6118',9100.00,0.00,0.00,12.50,662.50,'2022-09-08 09:10:46','',''),(6105,'1','277','1',1,'Retail Sale Id 6119',7003.36,0.00,0.00,9.62,509.86,'2022-09-08 09:11:27','',''),(6106,'1','277','1',1,'Retail Sale Id 6120',9100.00,0.00,0.00,12.50,662.50,'2022-09-08 09:17:44','',''),(6107,'1','277','1',1,'Retail Sale Id 6121',3698.24,0.00,0.00,5.08,269.24,'2022-09-08 09:19:17','',''),(6108,'1','277','1',1,'Retail Sale Id 6122',9100.00,0.00,0.00,12.50,662.50,'2022-09-08 09:20:46','',''),(6109,'1','277','1',1,'Retail Sale Id 6123',2402.40,0.00,0.00,3.30,174.90,'2022-09-08 09:33:16','',''),(6110,'1','277','1',1,'Retail Sale Id 6125',1499.68,0.00,0.00,2.06,109.18,'2022-09-08 09:40:46','',''),(6111,'1','277','1',1,'Retail Sale Id 6126',4397.12,0.00,0.00,6.04,320.12,'2022-09-08 09:45:26','',''),(6112,'1','277','1',1,'Retail Sale Id 6127',4397.12,0.00,0.00,6.04,320.12,'2022-09-08 09:49:37','',''),(6113,'1','277','1',1,'Retail Sale Id 6128',997.36,0.00,0.00,1.37,72.61,'2022-09-08 09:51:49','',''),(6114,'1','277','1',1,'Retail Sale Id 6129',4368.00,0.00,0.00,6.00,318.00,'2022-09-08 09:55:10','',''),(6115,'1','277','1',1,'Retail Sale Id 6130',2497.04,0.00,0.00,3.43,181.79,'2022-09-08 09:55:47','',''),(6116,'1','277','1',1,'Retail Sale Id 6131',1499.68,0.00,0.00,2.06,109.18,'2022-09-08 09:59:08','',''),(6117,'1','277','1',1,'Retail Sale Id 6132',4397.12,0.00,0.00,6.04,320.12,'2022-09-08 10:07:42','',''),(6118,'1','277','1',1,'Retail Sale Id 6133',2999.36,0.00,0.00,4.12,218.36,'2022-09-08 10:18:37','',''),(6119,'1','277','1',1,'Retail Sale Id 6134',9100.00,0.00,0.00,12.50,662.50,'2022-09-08 10:19:39','',''),(6120,'1','277','1',1,'Retail Sale Id 6135',2999.36,0.00,0.00,4.12,218.36,'2022-09-08 10:27:45','',''),(6121,'1','277','1',1,'Retail Sale Id 6136',4397.12,0.00,0.00,6.04,320.12,'2022-09-08 10:50:16','',''),(6122,'1','277','1',1,'Retail Sale Id 6137',35000.00,0.00,0.00,50.00,1250.00,'2022-09-08 10:58:47','',''),(6123,'1','277','1',1,'Retail Sale Id 6138',997.36,0.00,0.00,1.37,72.61,'2022-09-08 10:59:32','',''),(6124,'1','277','1',1,'Retail Sale Id 6139',9100.00,0.00,0.00,12.50,662.50,'2022-09-08 11:01:47','',''),(6125,'1','277','1',1,'Retail Sale Id 6140',3698.24,0.00,0.00,5.08,269.24,'2022-09-08 11:07:17','',''),(6126,'1','277','1',1,'Retail Sale Id 6141',9100.00,0.00,0.00,12.50,662.50,'2022-09-08 11:34:07','',''),(6127,'1','277','1',1,'Retail Sale Id 6142',997.36,0.00,0.00,1.37,72.61,'2022-09-08 11:43:08','',''),(6128,'1','277','1',1,'Retail Sale Id 6143',4368.00,0.00,0.00,6.00,318.00,'2022-09-08 11:49:40','',''),(6129,'1','277','1',1,'Retail Sale Id 6144',2198.56,0.00,0.00,3.02,160.06,'2022-09-08 11:50:27','',''),(6130,'1','277','1',1,'Retail Sale Id 6145',749.84,0.00,0.00,1.03,54.59,'2022-09-08 11:51:12','',''),(6131,'1','277','1',1,'Retail Sale Id 6146',4397.12,0.00,0.00,6.04,320.12,'2022-09-08 11:58:15','',''),(6132,'1','277','1',1,'Return of Retail Sale Id 6146',0.00,4397.12,6.04,0.00,-320.12,'2022-09-08 12:00:50','',''),(6133,'1','277','1',1,'Retail Sale Id 6147',2198.56,0.00,0.00,3.02,160.06,'2022-09-08 12:01:12','',''),(6134,'1','277','1',1,'Retail Sale Id 6148',749.84,0.00,0.00,1.03,54.59,'2022-09-08 12:11:05','',''),(6135,'1','277','1',1,'Retail Sale Id 6149',2198.56,0.00,0.00,3.02,160.06,'2022-09-08 12:19:56','',''),(6136,'1','277','1',1,'Retail Sale Id 6151',997.36,0.00,0.00,1.37,72.61,'2022-09-08 12:30:27','',''),(6137,'1','277','1',1,'Retail Sale Id 6152',9100.00,0.00,0.00,12.50,662.50,'2022-09-08 12:35:01','',''),(6138,'1','277','1',1,'Retail Sale Id 6153',2002.00,0.00,0.00,2.75,145.75,'2022-09-08 12:39:24','',''),(6139,'1','277','1',1,'Retail Sale Id 6154',997.36,0.00,0.00,1.37,72.61,'2022-09-08 12:47:22','',''),(6140,'1','277','1',1,'Retail Sale Id 6155',1499.68,0.00,0.00,2.06,109.18,'2022-09-08 12:48:26','',''),(6141,'1','277','1',1,'Retail Sale Id 6156',749.84,0.00,0.00,1.03,54.59,'2022-09-08 12:50:01','',''),(6142,'1','277','1',1,'Retail Sale Id 6157',5001.36,0.00,0.00,6.87,364.11,'2022-09-08 12:50:59','',''),(6143,'1','277','1',1,'Retail Sale Id 6158',2999.36,0.00,0.00,4.12,218.36,'2022-09-08 12:59:10','',''),(6144,'1','277','1',1,'Retail Sale Id 6159',3698.24,0.00,0.00,5.08,269.24,'2022-09-08 13:35:55','',''),(6145,'1','277','1',1,'Retail Sale Id 6160',2002.00,0.00,0.00,2.75,145.75,'2022-09-08 13:50:57','',''),(6146,'1','277','1',1,'Retail Sale Id 6161',1499.68,0.00,0.00,2.06,109.18,'2022-09-08 13:51:46','',''),(6147,'1','277','1',1,'Retail Sale Id 6162',2002.00,0.00,0.00,2.75,145.75,'2022-09-08 13:58:55','',''),(6148,'1','277','1',1,'Retail Sale Id 6163',2198.56,0.00,0.00,3.02,160.06,'2022-09-08 14:38:30','',''),(6149,'1','277','1',1,'Retail Sale Id 6164',2198.56,0.00,0.00,3.02,160.06,'2022-09-08 14:41:56','',''),(6150,'1','277','1',1,'Retail Sale Id 6165',9100.00,0.00,0.00,12.50,662.50,'2022-09-08 14:42:52','',''),(6151,'1','277','1',1,'Retail Sale Id 6166',997.36,0.00,0.00,1.37,72.61,'2022-09-08 14:50:17','',''),(6152,'1','277','1',1,'Retail Sale Id 6167',2198.56,0.00,0.00,3.02,160.06,'2022-09-08 14:51:37','',''),(6153,'1','277','1',1,'Retail Sale Id 6168',14700.00,0.00,0.00,21.00,525.00,'2022-09-08 15:07:55','',''),(6154,'1','277','1',1,'Retail Sale Id 6169',997.36,0.00,0.00,1.37,72.61,'2022-09-08 15:09:57','',''),(6155,'1','277','1',1,'Retail Sale Id 6170',31990.00,0.00,0.00,45.70,1142.50,'2022-09-08 15:18:20','',''),(6156,'1','277','1',1,'Retail Sale Id 6171',4397.12,0.00,0.00,6.04,320.12,'2022-09-08 15:19:00','',''),(6157,'1','277','1',1,'Retail Sale Id 6172',2999.36,0.00,0.00,4.12,218.36,'2022-09-08 15:28:22','',''),(6158,'1','277','1',1,'Retail Sale Id 6173',5001.36,0.00,0.00,6.87,364.11,'2022-09-08 15:38:48','',''),(6159,'1','277','1',1,'Retail Sale Id 6174',5998.72,0.00,0.00,8.24,436.72,'2022-09-08 15:40:02','',''),(6160,'1','277','1',1,'Retail Sale Id 6175',1303.12,0.00,0.00,1.79,94.87,'2022-09-08 15:40:34','',''),(6161,'1','277','1',1,'Retail Sale Id 6176',3996.72,0.00,0.00,5.49,290.97,'2022-09-08 15:41:21','',''),(6162,'1','277','1',1,'Retail Sale Id 6177',4499.04,0.00,0.00,6.18,327.54,'2022-09-08 15:52:09','',''),(6163,'1','277','1',1,'Retail Sale Id 6178',997.36,0.00,0.00,1.37,72.61,'2022-09-08 15:55:02','',''),(6164,'1','277','1',1,'Retail Sale Id 6179',2497.04,0.00,0.00,3.43,181.79,'2022-09-08 15:59:48','',''),(6165,'1','277','1',1,'Retail Sale Id 6180',2198.56,0.00,0.00,3.02,160.06,'2022-09-08 16:00:51','',''),(6166,'1','277','1',1,'Retail Sale Id 6181',2912.00,0.00,0.00,4.00,212.00,'2022-09-08 16:03:11','',''),(6167,'1','277','1',1,'Retail Sale Id 6182',9100.00,0.00,0.00,12.50,662.50,'2022-09-08 16:10:54','',''),(6168,'1','277','1',1,'Retail Sale Id 6183',3640.00,0.00,0.00,5.00,265.00,'2022-09-08 16:16:48','',''),(6169,'1','277','1',1,'Retail Sale Id 6184',2198.56,0.00,0.00,3.02,160.06,'2022-09-08 16:17:45','',''),(6170,'1','277','1',1,'Retail Sale Id 6185',3640.00,0.00,0.00,5.00,265.00,'2022-09-08 16:19:37','',''),(6171,'1','277','1',1,'Retail Sale Id 6186',800.80,0.00,0.00,1.10,58.30,'2022-09-08 16:21:23','',''),(6172,'1','277','1',1,'Retail Sale Id 6187',4397.12,0.00,0.00,6.04,320.12,'2022-09-08 16:23:40','',''),(6173,'1','277','1',1,'Retail Sale Id 6187',9100.00,0.00,0.00,12.50,662.50,'2022-09-08 16:23:40','',''),(6174,'1','277','1',1,'Retail Sale Id 6188',9100.00,0.00,0.00,12.50,662.50,'2022-09-08 16:29:42','',''),(6175,'1','277','1',1,'Retail Sale Id 6189',2999.36,0.00,0.00,4.12,218.36,'2022-09-08 16:34:47','',''),(6176,'1','277','1',1,'Retail Sale Id 6190',9100.00,0.00,0.00,12.50,662.50,'2022-09-08 16:43:16','',''),(6177,'1','277','1',1,'Retail Sale Id 6191',1499.68,0.00,0.00,2.06,109.18,'2022-09-08 16:55:52','',''),(6178,'1','277','1',1,'Retail Sale Id 6192',2999.36,0.00,0.00,4.12,218.36,'2022-09-08 16:56:53','',''),(6179,'1','277','1',1,'Retail Sale Id 6193',2999.36,0.00,0.00,4.12,218.36,'2022-09-08 16:57:43','',''),(6180,'1','277','1',1,'Retail Sale Id 6194',1499.68,0.00,0.00,2.06,109.18,'2022-09-08 17:00:11','',''),(6181,'1','277','1',1,'Retail Sale Id 6195',2198.56,0.00,0.00,3.02,160.06,'2022-09-08 17:07:07','',''),(6182,'1','277','1',1,'Retail Sale Id 6196',4397.12,0.00,0.00,6.04,320.12,'2022-09-08 17:14:15','',''),(6183,'1','277','1',1,'Retail Sale Id 6197',9100.00,0.00,0.00,12.50,662.50,'2022-09-08 17:18:50','',''),(6184,'1','277','1',1,'Retail Sale Id 6198',1499.68,0.00,0.00,2.06,109.18,'2022-09-08 17:23:03','',''),(6185,'1','277','1',1,'Retail Sale Id 6199',35000.00,0.00,0.00,50.00,1250.00,'2022-09-08 17:27:33','',''),(6186,'1','277','1',1,'Return of Retail Sale Id 6197',0.00,9100.00,12.50,0.00,-662.50,'2022-09-08 17:29:27','',''),(6187,'1','277','1',1,'Retail Sale Id 6200',902.72,0.00,0.00,1.24,65.72,'2022-09-08 17:29:55','',''),(6188,'1','277','1',1,'Return of Retail Sale Id 6200',0.00,902.72,1.24,0.00,-65.72,'2022-09-08 17:30:21','',''),(6189,'1','277','1',1,'Retail Sale Id 6201',8998.08,0.00,0.00,12.36,655.08,'2022-09-08 17:30:45','',''),(6190,'1','277','1',1,'Retail Sale Id 6202',4397.12,0.00,0.00,6.04,320.12,'2022-09-08 17:31:18','',''),(6191,'1','277','1',1,'Retail Sale Id 6203',2999.36,0.00,0.00,4.12,218.36,'2022-09-08 17:31:59','',''),(6192,'1','277','1',1,'Retail Sale Id 6204',997.36,0.00,0.00,1.37,72.61,'2022-09-08 17:37:25','',''),(6193,'1','277','1',1,'Retail Sale Id 6205',997.36,0.00,0.00,1.37,72.61,'2022-09-08 17:41:27','',''),(6194,'1','277','1',1,'Retail Sale Id 6206',749.84,0.00,0.00,1.03,54.59,'2022-09-08 17:46:24','',''),(6195,'1','277','1',1,'Retail Sale Id 6207',2999.36,0.00,0.00,4.12,218.36,'2022-09-08 17:50:13','',''),(6196,'1','277','1',1,'Retail Sale Id 6208',1499.68,0.00,0.00,2.06,109.18,'2022-09-08 17:50:51','',''),(6197,'1','277','1',1,'Retail Sale Id 6209',749.84,0.00,0.00,1.03,54.59,'2022-09-08 18:03:07','',''),(6198,'1','277','1',1,'Retail Sale Id 6210',3800.16,0.00,0.00,5.22,276.66,'2022-09-08 18:05:13','',''),(6199,'1','277','1',1,'Retail Sale Id 6211',1798.16,0.00,0.00,2.47,130.91,'2022-09-08 18:07:25','',''),(6200,'1','277','1',1,'Retail Sale Id 6212',2002.00,0.00,0.00,2.75,145.75,'2022-09-08 18:08:05','',''),(6201,'1','277','1',1,'Retail Sale Id 6213',4397.12,0.00,0.00,6.04,320.12,'2022-09-08 18:10:42','',''),(6202,'1','277','1',1,'Retail Sale Id 6214',2002.00,0.00,0.00,2.75,145.75,'2022-09-08 18:11:12','',''),(6203,'1','277','1',1,'Retail Sale Id 6215',728.00,0.00,0.00,1.00,53.00,'2022-09-08 18:13:42','',''),(6204,'1','277','1',1,'Retail Sale Id 6217',7280.00,0.00,0.00,10.00,530.00,'2022-09-08 18:15:07','',''),(6205,'1','277','1',1,'Retail Sale Id 6218',5263.44,0.00,0.00,7.23,383.19,'2022-09-08 18:22:49','',''),(6206,'1','277',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,4637.25,6.87,0.00,0.00,'2022-09-08 19:40:46','',''),(6207,'1','277',NULL,1,'Reception corrector for bridging 21',0.00,0.00,0.00,6.87,0.00,'2022-09-08 19:42:44','',''),(6208,'1','277','1',1,'Received from bridging 21',0.00,0.00,6.87,0.00,0.00,'2022-09-08 19:42:44','',''),(6209,'1','277','1',1,'Retail Sale Id 6219',5001.36,0.00,0.00,6.87,364.11,'2022-09-08 19:44:14','',''),(6210,'1','277','1',1,'Return of Retail Sale Id 6195',0.00,2198.56,3.02,0.00,-160.06,'2022-09-08 19:59:40','',''),(6211,'1','277','1',1,'Retail Sale Id 6220',2154.88,0.00,0.00,2.96,156.88,'2022-09-08 20:00:09','',''),(6212,'1','277',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,1350000.00,2000.00,0.00,0.00,'2022-09-09 10:00:16','',''),(6213,'1','277',NULL,1,'Reception corrector for bridging 22',0.00,0.00,0.00,2000.00,0.00,'2022-09-09 10:02:45','',''),(6214,'1','277','1',1,'Received from bridging 22',0.00,0.00,2000.00,0.00,0.00,'2022-09-09 10:02:45','',''),(6215,'1','277','1',1,'Retail Sale Id 6222',8000.72,0.00,0.00,10.99,582.47,'2022-09-09 10:17:03','',''),(6216,'1','277','1',1,'Retail Sale Id 6223',2002.00,0.00,0.00,2.75,145.75,'2022-09-09 10:18:22','',''),(6217,'1','277','1',1,'Retail Sale Id 6224',3996.72,0.00,0.00,5.49,290.97,'2022-09-09 10:19:30','',''),(6218,'1','277','1',1,'Retail Sale Id 6225',2999.36,0.00,0.00,4.12,218.36,'2022-09-09 10:22:40','',''),(6219,'1','277','1',1,'Retail Sale Id 6226',698.88,0.00,0.00,0.96,50.88,'2022-09-09 10:26:38','',''),(6220,'1','277','1',1,'Retail Sale Id 6227',4397.12,0.00,0.00,6.04,320.12,'2022-09-09 10:31:05','',''),(6221,'1','277','1',1,'Retail Sale Id 6228',1499.68,0.00,0.00,2.06,109.18,'2022-09-09 10:34:22','',''),(6222,'1','277','1',1,'Retail Sale Id 6229',2198.56,0.00,0.00,3.02,160.06,'2022-09-09 10:39:27','',''),(6223,'1','277','1',1,'Retail Sale Id 6230',5001.36,0.00,0.00,6.87,364.11,'2022-09-09 10:42:04','',''),(6224,'1','277','1',1,'Retail Sale Id 6231',749.84,0.00,0.00,1.03,54.59,'2022-09-09 10:50:33','',''),(6225,'1','277','1',1,'Retail Sale Id 6232',3996.72,0.00,0.00,5.49,290.97,'2022-09-09 10:53:37','',''),(6226,'1','277','1',1,'Retail Sale Id 6233',4397.12,0.00,0.00,6.04,320.12,'2022-09-09 10:55:39','',''),(6227,'1','277','1',1,'Retail Sale Id 6234',2002.00,0.00,0.00,2.75,145.75,'2022-09-09 11:09:26','',''),(6228,'1','277','1',1,'Retail Sale Id 6235',1499.68,0.00,0.00,2.06,109.18,'2022-09-09 11:10:39','',''),(6229,'1','277','1',1,'Retail Sale Id 6236',749.84,0.00,0.00,1.03,54.59,'2022-09-09 11:14:43','',''),(6230,'1','277','1',1,'Retail Sale Id 6237',2497.04,0.00,0.00,3.43,181.79,'2022-09-09 11:24:13','',''),(6231,'1','277','1',1,'Retail Sale Id 6237',4499.04,0.00,0.00,6.18,327.54,'2022-09-09 11:24:13','',''),(6232,'1','277','1',1,'Retail Sale Id 6238',4397.12,0.00,0.00,6.04,320.12,'2022-09-09 11:39:17','',''),(6233,'1','277','1',1,'Retail Sale Id 6239',3698.24,0.00,0.00,5.08,269.24,'2022-09-09 11:42:47','',''),(6234,'1','277','1',1,'Retail Sale Id 6240',997.36,0.00,0.00,1.37,72.61,'2022-09-09 11:44:18','',''),(6235,'1','277','1',1,'Retail Sale Id 6241',3647.28,0.00,0.00,5.01,265.53,'2022-09-09 11:47:20','',''),(6236,'1','277','1',1,'Retail Sale Id 6242',997.36,0.00,0.00,1.37,72.61,'2022-09-09 11:51:34','',''),(6237,'1','277','1',1,'Retail Sale Id 6243',3698.24,0.00,0.00,5.08,269.24,'2022-09-09 12:02:24','',''),(6238,'1','277','1',1,'Retail Sale Id 6245',1499.68,0.00,0.00,2.06,109.18,'2022-09-09 12:07:59','',''),(6239,'1','277','1',1,'Retail Sale Id 6245',2897.44,0.00,0.00,3.98,210.94,'2022-09-09 12:07:59','',''),(6240,'1','277','1',1,'Retail Sale Id 6246',1499.68,0.00,0.00,2.06,109.18,'2022-09-09 12:18:50','',''),(6241,'1','277','1',1,'Retail Sale Id 6247',3698.24,0.00,0.00,5.08,269.24,'2022-09-09 12:41:30','',''),(6242,'1','277','1',1,'Retail Sale Id 6248',1499.68,0.00,0.00,2.06,109.18,'2022-09-09 12:42:31','',''),(6243,'1','277','1',1,'Retail Sale Id 6249',5001.36,0.00,0.00,6.87,364.11,'2022-09-09 12:43:51','',''),(6244,'1','277','1',1,'Retail Sale Id 6250',4397.12,0.00,0.00,6.04,320.12,'2022-09-09 12:44:34','',''),(6245,'1','277','1',1,'Retail Sale Id 6251',4397.12,0.00,0.00,6.04,320.12,'2022-09-09 12:45:30','',''),(6246,'1','277','1',1,'Retail Sale Id 6252',2198.56,0.00,0.00,3.02,160.06,'2022-09-09 12:46:25','',''),(6247,'1','277','1',1,'Retail Sale Id 6254',1463.28,0.00,0.00,2.01,106.53,'2022-09-09 12:49:54','',''),(6248,'1','277','1',1,'Retail Sale Id 6254',1463.28,0.00,0.00,2.01,106.53,'2022-09-09 12:49:54','',''),(6249,'1','277','1',1,'Retail Sale Id 6255',1499.68,0.00,0.00,2.06,109.18,'2022-09-09 12:51:30','',''),(6250,'1','277',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,796459.50,1179.94,0.00,0.00,'2022-09-09 12:54:31','',''),(6251,'1','277',NULL,1,'Reception corrector for bridging 23',0.00,0.00,0.00,1179.94,0.00,'2022-09-09 12:55:52','',''),(6252,'1','277','1',1,'Received from bridging 23',0.00,0.00,1179.94,0.00,0.00,'2022-09-09 12:55:52','',''),(6253,'1','277','1',1,'Retail Sale Id 6256',2198.56,0.00,0.00,3.02,160.06,'2022-09-09 12:56:15','',''),(6254,'1','277','1',1,'Retail Sale Id 6257',2002.00,0.00,0.00,2.75,145.75,'2022-09-09 13:00:05','',''),(6255,'1','277','1',1,'Retail Sale Id 6258',596.96,0.00,0.00,0.82,43.46,'2022-09-09 13:03:23','',''),(6256,'1','277','1',1,'Retail Sale Id 6259',4397.12,0.00,0.00,6.04,320.12,'2022-09-09 13:07:40','',''),(6257,'1','277','1',1,'Return of Retail Sale Id 6239',0.00,3698.24,5.08,0.00,-269.24,'2022-09-09 13:08:28','',''),(6258,'1','277','1',1,'Retail Sale Id 6260',4397.12,0.00,0.00,6.04,320.12,'2022-09-09 13:11:46','',''),(6259,'1','277','1',1,'Retail Sale Id 6261',1303.12,0.00,0.00,1.79,94.87,'2022-09-09 13:21:01','',''),(6260,'1','277','1',1,'Retail Sale Id 6262',2999.36,0.00,0.00,4.12,218.36,'2022-09-09 13:24:12','',''),(6261,'1','277','1',1,'Retail Sale Id 6263',3698.24,0.00,0.00,5.08,269.24,'2022-09-09 14:41:49','',''),(6262,'1','277','1',1,'Retail Sale Id 6264',3996.72,0.00,0.00,5.49,290.97,'2022-09-09 14:42:43','',''),(6263,'1','277','1',1,'Retail Sale Id 6265',2999.36,0.00,0.00,4.12,218.36,'2022-09-09 14:50:49','',''),(6264,'1','277','1',1,'Retail Sale Id 6266',9100.00,0.00,0.00,12.50,662.50,'2022-09-09 14:56:22','',''),(6265,'1','277','1',1,'Retail Sale Id 6267',5998.72,0.00,0.00,8.24,436.72,'2022-09-09 14:57:43','',''),(6266,'1','277','1',1,'Retail Sale Id 6268',2497.04,0.00,0.00,3.43,181.79,'2022-09-09 15:00:47','',''),(6267,'1','277','1',1,'Retail Sale Id 6269',1201.20,0.00,0.00,1.65,87.45,'2022-09-09 15:03:31','',''),(6268,'1','277','1',1,'Retail Sale Id 6270',47967.92,0.00,0.00,65.89,3492.17,'2022-09-09 15:07:03','',''),(6269,'1','277','1',1,'Retail Sale Id 6271',1397.76,0.00,0.00,1.92,101.76,'2022-09-09 15:08:44','',''),(6270,'1','277','1',1,'Retail Sale Id 6272',3996.72,0.00,0.00,5.49,290.97,'2022-09-09 15:09:23','',''),(6271,'1','277','1',1,'Retail Sale Id 6273',298.48,0.00,0.00,0.41,21.73,'2022-09-09 15:10:33','',''),(6272,'1','277','1',1,'Retail Sale Id 6274',8000.72,0.00,0.00,10.99,582.47,'2022-09-09 15:19:04','',''),(6273,'1','277','1',1,'Retail Sale Id 6275',9100.00,0.00,0.00,12.50,662.50,'2022-09-09 15:35:57','',''),(6274,'1','277','1',1,'Retail Sale Id 6276',2497.04,0.00,0.00,3.43,181.79,'2022-09-09 15:38:25','',''),(6275,'1','277','1',1,'Retail Sale Id 6277',3996.72,0.00,0.00,5.49,290.97,'2022-09-09 15:50:39','',''),(6276,'1','277','1',1,'Retail Sale Id 6278',3996.72,0.00,0.00,5.49,290.97,'2022-09-09 15:52:06','',''),(6277,'1','277','1',1,'Return of Retail Sale Id 6251',0.00,4397.12,6.04,0.00,-320.12,'2022-09-09 16:00:55','',''),(6278,'1','277','1',1,'Retail Sale Id 6279',4397.12,0.00,0.00,6.04,320.12,'2022-09-09 16:03:57','',''),(6279,'1','277','1',1,'Retail Sale Id 6280',2198.56,0.00,0.00,3.02,160.06,'2022-09-09 16:18:31','',''),(6280,'1','277','1',1,'Retail Sale Id 6281',4397.12,0.00,0.00,6.04,320.12,'2022-09-09 16:23:36','',''),(6281,'1','277','1',1,'Retail Sale Id 6282',7280.00,0.00,0.00,10.00,530.00,'2022-09-09 16:25:39','',''),(6282,'1','277','1',1,'Retail Sale Id 6283',2999.36,0.00,0.00,4.12,218.36,'2022-09-09 16:26:26','',''),(6283,'1','277','1',1,'Retail Sale Id 6284',502.32,0.00,0.00,0.69,36.57,'2022-09-09 16:26:55','',''),(6284,'1','277','1',1,'Retail Sale Id 6285',1499.68,0.00,0.00,2.06,109.18,'2022-09-09 16:27:39','',''),(6285,'1','277','1',1,'Retail Sale Id 6286',5001.36,0.00,0.00,6.87,364.11,'2022-09-09 16:28:34','',''),(6286,'1','277','1',1,'Retail Sale Id 6287',749.84,0.00,0.00,1.03,54.59,'2022-09-09 16:29:19','',''),(6287,'1','277','1',1,'Retail Sale Id 6288',749.84,0.00,0.00,1.03,54.59,'2022-09-09 16:30:08','',''),(6288,'1','277','1',1,'Retail Sale Id 6289',502.32,0.00,0.00,0.69,36.57,'2022-09-09 16:30:44','',''),(6289,'1','277','1',1,'Retail Sale Id 6290',2999.36,0.00,0.00,4.12,218.36,'2022-09-09 16:56:30','',''),(6290,'1','277','1',1,'Retail Sale Id 6291',4368.00,0.00,0.00,6.00,318.00,'2022-09-09 16:58:57','',''),(6291,'1','277','1',1,'Retail Sale Id 6292',502.32,0.00,0.00,0.69,36.57,'2022-09-09 16:59:35','',''),(6292,'1','277','1',1,'Retail Sale Id 6293',2198.56,0.00,0.00,3.02,160.06,'2022-09-09 17:00:20','',''),(6293,'1','277','1',1,'Retail Sale Id 6294',2198.56,0.00,0.00,3.02,160.06,'2022-09-09 17:05:44','',''),(6294,'1','277','1',1,'Retail Sale Id 6295',2999.36,0.00,0.00,4.12,218.36,'2022-09-09 17:06:22','',''),(6295,'1','277','1',1,'Retail Sale Id 6296',4397.12,0.00,0.00,6.04,320.12,'2022-09-09 17:07:31','',''),(6296,'1','277','1',1,'Retail Sale Id 6297',1499.68,0.00,0.00,2.06,109.18,'2022-09-09 17:08:40','',''),(6297,'1','277','1',1,'Retail Sale Id 6298',8503.04,0.00,0.00,11.68,619.04,'2022-09-09 17:10:52','',''),(6298,'1','277','1',1,'Retail Sale Id 6299',997.36,0.00,0.00,1.37,72.61,'2022-09-09 17:11:42','',''),(6299,'1','277','1',1,'Retail Sale Id 6300',1499.68,0.00,0.00,2.06,109.18,'2022-09-09 17:13:03','',''),(6300,'1','277','1',1,'Retail Sale Id 6301',3698.24,0.00,0.00,5.08,269.24,'2022-09-09 17:14:09','',''),(6301,'1','277','1',1,'Retail Sale Id 6302',749.84,0.00,0.00,1.03,54.59,'2022-09-09 17:15:39','',''),(6302,'1','277','1',1,'Retail Sale Id 6303',2999.36,0.00,0.00,4.12,218.36,'2022-09-09 17:19:47','',''),(6303,'1','277','1',1,'Retail Sale Id 6304',2999.36,0.00,0.00,4.12,218.36,'2022-09-09 17:22:05','',''),(6304,'1','277','1',1,'Retail Sale Id 6305',3640.00,0.00,0.00,5.00,265.00,'2022-09-09 17:27:53','',''),(6305,'1','277','1',1,'Retail Sale Id 6306',2198.56,0.00,0.00,3.02,160.06,'2022-09-09 17:33:17','',''),(6306,'1','277','1',1,'Retail Sale Id 6307',749.84,0.00,0.00,1.03,54.59,'2022-09-09 17:34:31','',''),(6307,'1','277','1',1,'Retail Sale Id 6308',3501.68,0.00,0.00,4.81,254.93,'2022-09-09 17:35:48','',''),(6308,'1','277','1',1,'Retail Sale Id 6309',5496.40,0.00,0.00,7.55,400.15,'2022-09-09 17:36:27','',''),(6309,'1','277','1',1,'Retail Sale Id 6310',5001.36,0.00,0.00,6.87,364.11,'2022-09-09 17:38:45','',''),(6310,'1','277','1',1,'Retail Sale Id 6311',2198.56,0.00,0.00,3.02,160.06,'2022-09-09 17:39:46','',''),(6311,'1','277','1',1,'Retail Sale Id 6312',1499.68,0.00,0.00,2.06,109.18,'2022-09-09 17:43:05','',''),(6312,'1','277','1',1,'Retail Sale Id 6312',2919.28,0.00,0.00,4.01,212.53,'2022-09-09 17:43:05','',''),(6313,'1','277','1',1,'Retail Sale Id 6313',749.84,0.00,0.00,1.03,54.59,'2022-09-09 17:43:59','',''),(6314,'1','277','1',1,'Retail Sale Id 6314',2999.36,0.00,0.00,4.12,218.36,'2022-09-09 17:44:40','',''),(6315,'1','277','1',1,'Retail Sale Id 6315',997.36,0.00,0.00,1.37,72.61,'2022-09-09 17:46:42','',''),(6316,'1','277','1',1,'Retail Sale Id 6316',997.36,0.00,0.00,1.37,72.61,'2022-09-09 17:47:22','',''),(6317,'1','277','1',1,'Retail Sale Id 6317',3996.72,0.00,0.00,5.49,290.97,'2022-09-09 17:48:01','',''),(6318,'1','277','1',1,'Retail Sale Id 6318',1499.68,0.00,0.00,2.06,109.18,'2022-09-09 17:48:30','',''),(6319,'1','277','1',1,'Retail Sale Id 6320',4397.12,0.00,0.00,6.04,320.12,'2022-09-09 17:52:15','',''),(6320,'1','277','1',1,'Retail Sale Id 6321',4397.12,0.00,0.00,6.04,320.12,'2022-09-09 17:53:33','',''),(6321,'1','277','1',1,'Retail Sale Id 6322',9100.00,0.00,0.00,12.50,662.50,'2022-09-09 17:57:03','',''),(6322,'1','277','1',1,'Retail Sale Id 6323',2198.56,0.00,0.00,3.02,160.06,'2022-09-09 18:00:01','',''),(6323,'1','277','1',1,'Retail Sale Id 6324',2002.00,0.00,0.00,2.75,145.75,'2022-09-09 18:05:05','',''),(6324,'1','277','1',1,'Retail Sale Id 6325',2999.36,0.00,0.00,4.12,218.36,'2022-09-09 18:07:15','',''),(6325,'1','277','1',1,'Retail Sale Id 6326',4397.12,0.00,0.00,6.04,320.12,'2022-09-09 18:15:31','',''),(6326,'1','277','1',1,'Retail Sale Id 6327',1397.76,0.00,0.00,1.92,101.76,'2022-09-09 18:16:38','',''),(6327,'1','277','1',1,'Retail Sale Id 6327',3698.24,0.00,0.00,5.08,269.24,'2022-09-09 18:16:38','',''),(6328,'1','277','1',1,'Retail Sale Id 6327',3996.72,0.00,0.00,5.49,290.97,'2022-09-09 18:16:38','',''),(6329,'1','277','1',1,'Retail Sale Id 6328',2198.56,0.00,0.00,3.02,160.06,'2022-09-09 18:23:36','',''),(6330,'1','277','1',1,'Retail Sale Id 6329',3996.72,0.00,0.00,5.49,290.97,'2022-09-09 18:28:01','',''),(6331,'1','277','1',1,'Retail Sale Id 6330',1499.68,0.00,0.00,2.06,109.18,'2022-09-09 18:30:38','',''),(6332,'1','277','1',1,'Retail Sale Id 6331',997.36,0.00,0.00,1.37,72.61,'2022-09-09 18:31:19','',''),(6333,'1','277','1',1,'Retail Sale Id 6332',2198.56,0.00,0.00,3.02,160.06,'2022-09-09 18:38:44','',''),(6334,'1','277','1',1,'Retail Sale Id 6334',3996.72,0.00,0.00,5.49,290.97,'2022-09-09 18:46:07','',''),(6335,'1','277','1',1,'Retail Sale Id 6335',997.36,0.00,0.00,1.37,72.61,'2022-09-09 18:46:50','',''),(6336,'1','277','1',1,'Retail Sale Id 6336',1499.68,0.00,0.00,2.06,109.18,'2022-09-09 18:47:26','',''),(6337,'1','277','1',1,'Retail Sale Id 6337',3698.24,0.00,0.00,5.08,269.24,'2022-09-09 18:51:30','',''),(6338,'1','277','1',1,'Retail Sale Id 6338',2999.36,0.00,0.00,4.12,218.36,'2022-09-09 19:05:10','',''),(6339,'1','277','1',1,'Retail Sale Id 6339',4397.12,0.00,0.00,6.04,320.12,'2022-09-09 19:25:13','',''),(6340,'1','277','1',1,'Return of Retail Sale Id 6336',0.00,1499.68,2.06,0.00,-109.18,'2022-09-09 19:28:19','',''),(6341,'1','277','1',1,'Retail Sale Id 6341',1266.72,0.00,0.00,1.74,92.22,'2022-09-09 19:29:12','',''),(6342,'1','277','1',1,'Return of Retail Sale Id 6341',0.00,1266.72,1.74,0.00,-92.22,'2022-09-09 19:30:45','',''),(6343,'1','277','1',1,'Retail Sale Id 6342',1499.68,0.00,0.00,2.06,109.18,'2022-09-09 19:31:08','',''),(6344,'1','277','1',1,'Return of Retail Sale Id 6332',0.00,2198.56,3.02,0.00,-160.06,'2022-09-09 19:36:32','',''),(6345,'1','277','1',1,'Retail Sale Id 6343',1965.60,0.00,0.00,2.70,143.10,'2022-09-09 19:37:05','',''),(6346,'1','277','1',1,'Return of Retail Sale Id 6343',0.00,1965.60,2.70,0.00,-143.10,'2022-09-09 19:41:07','',''),(6347,'1','277','1',1,'Retail Sale Id 6344',2198.56,0.00,0.00,3.02,160.06,'2022-09-09 19:41:49','',''),(6348,'1','277','1',1,'Return of Retail Sale Id 6339',0.00,4397.12,6.04,0.00,-320.12,'2022-09-09 19:43:06','',''),(6349,'1','277','1',1,'Retail Sale Id 6345',4164.16,0.00,0.00,5.72,303.16,'2022-09-09 19:43:32','',''),(6350,'1','277','1',1,'Retail Sale Id 6346',465.92,0.00,0.00,0.64,33.92,'2022-09-09 19:45:48','',''),(6351,'1','277','1',1,'Retail Sale Id 6347',2002.00,0.00,0.00,2.75,145.75,'2022-09-10 06:55:03','',''),(6352,'1','277','1',1,'Retail Sale Id 6348',2999.36,0.00,0.00,4.12,218.36,'2022-09-10 06:56:13','',''),(6353,'1','277','1',1,'Retail Sale Id 6349',9100.00,0.00,0.00,12.50,662.50,'2022-09-10 06:59:56','',''),(6354,'1','277','1',1,'Retail Sale Id 6350',4397.12,0.00,0.00,6.04,320.12,'2022-09-10 07:00:53','',''),(6355,'1','277','1',1,'Retail Sale Id 6351',3647.28,0.00,0.00,5.01,265.53,'2022-09-10 07:12:07','',''),(6356,'1','277','1',1,'Retail Sale Id 6352',2002.00,0.00,0.00,2.75,145.75,'2022-09-10 07:16:29','',''),(6357,'1','277','1',1,'Retail Sale Id 6353',2002.00,0.00,0.00,2.75,145.75,'2022-09-10 07:17:31','',''),(6358,'1','277','1',1,'Retail Sale Id 6354',2999.36,0.00,0.00,4.12,218.36,'2022-09-10 07:30:53','',''),(6359,'1','277','1',1,'Retail Sale Id 6355',3640.00,0.00,0.00,5.00,265.00,'2022-09-10 07:31:44','',''),(6360,'1','277','1',1,'Retail Sale Id 6356',1499.68,0.00,0.00,2.06,109.18,'2022-09-10 07:33:46','',''),(6361,'1','277','1',1,'Retail Sale Id 6357',749.84,0.00,0.00,1.03,54.59,'2022-09-10 07:35:19','',''),(6362,'1','277','1',1,'Retail Sale Id 6358',3501.68,0.00,0.00,4.81,254.93,'2022-09-10 07:48:46','',''),(6363,'1','277','1',1,'Retail Sale Id 6359',800.80,0.00,0.00,1.10,58.30,'2022-09-10 07:52:41','',''),(6364,'1','277','1',1,'Retail Sale Id 6360',3647.28,0.00,0.00,5.01,265.53,'2022-09-10 07:55:46','',''),(6365,'1','277','1',1,'Retail Sale Id 6361',1499.68,0.00,0.00,2.06,109.18,'2022-09-10 08:00:25','',''),(6366,'1','277','1',1,'Retail Sale Id 6362',1499.68,0.00,0.00,2.06,109.18,'2022-09-10 08:09:59','',''),(6367,'1','277','1',1,'Retail Sale Id 6363',4397.12,0.00,0.00,6.04,320.12,'2022-09-10 08:11:54','',''),(6368,'1','277','1',1,'Retail Sale Id 6364',1499.68,0.00,0.00,2.06,109.18,'2022-09-10 08:13:15','',''),(6369,'1','277','1',1,'Retail Sale Id 6365',997.36,0.00,0.00,1.37,72.61,'2022-09-10 08:16:37','',''),(6370,'1','277','1',1,'Retail Sale Id 6366',2497.04,0.00,0.00,3.43,181.79,'2022-09-10 08:22:04','',''),(6371,'1','277','1',1,'Retail Sale Id 6367',1499.68,0.00,0.00,2.06,109.18,'2022-09-10 08:30:30','',''),(6372,'1','277','1',1,'Retail Sale Id 6368',3996.72,0.00,0.00,5.49,290.97,'2022-09-10 08:34:39','',''),(6373,'1','277','1',1,'Retail Sale Id 6369',2002.00,0.00,0.00,2.75,145.75,'2022-09-10 08:35:44','',''),(6374,'1','277','1',1,'Retail Sale Id 6370',4397.12,0.00,0.00,6.04,320.12,'2022-09-10 08:40:20','',''),(6375,'1','277','1',1,'Retail Sale Id 6371',7003.36,0.00,0.00,9.62,509.86,'2022-09-10 08:41:39','',''),(6376,'1','277','1',1,'Retail Sale Id 6372',2198.56,0.00,0.00,3.02,160.06,'2022-09-10 08:44:10','',''),(6377,'1','277','1',1,'Retail Sale Id 6373',4397.12,0.00,0.00,6.04,320.12,'2022-09-10 08:48:01','',''),(6378,'1','277','1',1,'Retail Sale Id 6373',9100.00,0.00,0.00,12.50,662.50,'2022-09-10 08:48:01','',''),(6379,'1','277','1',1,'Retail Sale Id 6374',1499.68,0.00,0.00,2.06,109.18,'2022-09-10 08:49:09','',''),(6380,'1','277','1',1,'Retail Sale Id 6375',1499.68,0.00,0.00,2.06,109.18,'2022-09-10 08:50:40','',''),(6381,'1','277','1',1,'Retail Sale Id 6376',997.36,0.00,0.00,1.37,72.61,'2022-09-10 08:51:52','',''),(6382,'1','277','1',1,'Retail Sale Id 6377',9100.00,0.00,0.00,12.50,662.50,'2022-09-10 09:00:04','',''),(6383,'1','277','1',1,'Retail Sale Id 6378',3698.24,0.00,0.00,5.08,269.24,'2022-09-10 09:08:49','',''),(6384,'1','277','1',1,'Retail Sale Id 6379',2198.56,0.00,0.00,3.02,160.06,'2022-09-10 09:16:43','',''),(6385,'1','277','1',1,'Retail Sale Id 6380',2198.56,0.00,0.00,3.02,160.06,'2022-09-10 09:34:50','',''),(6386,'1','277','1',1,'Retail Sale Id 6381',2999.36,0.00,0.00,4.12,218.36,'2022-09-10 09:42:15','',''),(6387,'1','277','1',1,'Retail Sale Id 6382',749.84,0.00,0.00,1.03,54.59,'2022-09-10 09:46:10','',''),(6388,'1','277','1',1,'Retail Sale Id 6383',2999.36,0.00,0.00,4.12,218.36,'2022-09-10 09:47:43','',''),(6389,'1','277','1',1,'Retail Sale Id 6384',502.32,0.00,0.00,0.69,36.57,'2022-09-10 09:50:39','',''),(6390,'1','277','1',1,'Retail Sale Id 6385',3800.16,0.00,0.00,5.22,276.66,'2022-09-10 09:54:16','',''),(6391,'1','277','1',1,'Retail Sale Id 6386',2802.80,0.00,0.00,3.85,204.05,'2022-09-10 09:59:15','',''),(6392,'1','277','1',1,'Retail Sale Id 6387',4499.04,0.00,0.00,6.18,327.54,'2022-09-10 10:00:23','',''),(6393,'1','277','1',1,'Retail Sale Id 6388',3698.24,0.00,0.00,5.08,269.24,'2022-09-10 10:01:25','',''),(6394,'1','277','1',1,'Retail Sale Id 6389',3698.24,0.00,0.00,5.08,269.24,'2022-09-10 10:09:24','',''),(6395,'1','277','1',1,'Retail Sale Id 6390',9100.00,0.00,0.00,12.50,662.50,'2022-09-10 10:13:11','',''),(6396,'1','277','1',1,'Retail Sale Id 6391',997.36,0.00,0.00,1.37,72.61,'2022-09-10 10:14:19','',''),(6397,'1','277','1',1,'Retail Sale Id 6392',3640.00,0.00,0.00,5.00,265.00,'2022-09-10 10:19:41','',''),(6398,'1','277','1',1,'Retail Sale Id 6393',1798.16,0.00,0.00,2.47,130.91,'2022-09-10 10:21:13','',''),(6399,'1','277','1',1,'Retail Sale Id 6394',8998.08,0.00,0.00,12.36,655.08,'2022-09-10 10:29:35','',''),(6400,'1','277','1',1,'Retail Sale Id 6395',4397.12,0.00,0.00,6.04,320.12,'2022-09-10 10:35:28','',''),(6401,'1','277','1',1,'Retail Sale Id 6396',4397.12,0.00,0.00,6.04,320.12,'2022-09-10 10:41:38','',''),(6402,'1','277','1',1,'Retail Sale Id 6397',502.32,0.00,0.00,0.69,36.57,'2022-09-10 10:45:25','',''),(6403,'1','277','1',1,'Retail Sale Id 6398',997.36,0.00,0.00,1.37,72.61,'2022-09-10 10:46:46','',''),(6404,'1','277','1',1,'Retail Sale Id 6399',2198.56,0.00,0.00,3.02,160.06,'2022-09-10 10:50:48','',''),(6405,'1','277','1',1,'Retail Sale Id 6400',2198.56,0.00,0.00,3.02,160.06,'2022-09-10 10:52:08','',''),(6406,'1','277','1',1,'Retail Sale Id 6401',2198.56,0.00,0.00,3.02,160.06,'2022-09-10 10:54:03','',''),(6407,'1','277','1',1,'Retail Sale Id 6403',2999.36,0.00,0.00,4.12,218.36,'2022-09-10 10:55:36','',''),(6408,'1','277','1',1,'Retail Sale Id 6404',4397.12,0.00,0.00,6.04,320.12,'2022-09-10 10:57:46','',''),(6409,'1','277','1',1,'Retail Sale Id 6405',2002.00,0.00,0.00,2.75,145.75,'2022-09-10 10:58:42','',''),(6410,'1','277','1',1,'Retail Sale Id 6406',749.84,0.00,0.00,1.03,54.59,'2022-09-10 11:04:04','',''),(6411,'1','277','1',1,'Retail Sale Id 6407',2999.36,0.00,0.00,4.12,218.36,'2022-09-10 11:15:34','',''),(6412,'1','277','1',1,'Retail Sale Id 6408',4397.12,0.00,0.00,6.04,320.12,'2022-09-10 11:16:49','',''),(6413,'1','277','1',1,'Retail Sale Id 6409',1499.68,0.00,0.00,2.06,109.18,'2022-09-10 11:18:10','',''),(6414,'1','277','1',1,'Retail Sale Id 6410',2002.00,0.00,0.00,2.75,145.75,'2022-09-10 11:23:42','',''),(6415,'1','277','1',1,'Retail Sale Id 6411',4397.12,0.00,0.00,6.04,320.12,'2022-09-10 11:33:31','',''),(6416,'1','277','1',1,'Retail Sale Id 6412',4397.12,0.00,0.00,6.04,320.12,'2022-09-10 11:42:50','',''),(6417,'1','277','1',1,'Retail Sale Id 6413',9100.00,0.00,0.00,12.50,662.50,'2022-09-10 11:51:02','',''),(6418,'1','277','1',1,'Retail Sale Id 6414',1499.68,0.00,0.00,2.06,109.18,'2022-09-10 11:58:11','',''),(6419,'1','277','1',1,'Retail Sale Id 6415',2198.56,0.00,0.00,3.02,160.06,'2022-09-10 12:16:04','',''),(6420,'1','277','1',1,'Retail Sale Id 6416',4397.12,0.00,0.00,6.04,320.12,'2022-09-10 12:19:24','',''),(6421,'1','277','1',1,'Retail Sale Id 6417',4397.12,0.00,0.00,6.04,320.12,'2022-09-10 12:20:59','',''),(6422,'1','277','1',1,'Retail Sale Id 6418',4302.48,0.00,0.00,5.91,313.23,'2022-09-10 12:22:10','',''),(6423,'1','277','1',1,'Retail Sale Id 6419',2198.56,0.00,0.00,3.02,160.06,'2022-09-10 12:25:07','',''),(6424,'1','277','1',1,'Retail Sale Id 6420',2002.00,0.00,0.00,2.75,145.75,'2022-09-10 12:30:31','',''),(6425,'1','277','1',1,'Retail Sale Id 6421',8000.72,0.00,0.00,10.99,582.47,'2022-09-10 12:32:18','',''),(6426,'1','277','1',1,'Retail Sale Id 6422',1499.68,0.00,0.00,2.06,109.18,'2022-09-10 12:36:38','',''),(6427,'1','277','1',1,'Retail Sale Id 6423',9100.00,0.00,0.00,12.50,662.50,'2022-09-10 12:37:40','',''),(6428,'1','277','1',1,'Retail Sale Id 6424',800.80,0.00,0.00,1.10,58.30,'2022-09-10 12:38:51','',''),(6429,'1','277','1',1,'Retail Sale Id 6425',13999.44,0.00,0.00,19.23,1019.19,'2022-09-10 12:40:20','',''),(6430,'1','277','1',1,'Retail Sale Id 6426',997.36,0.00,0.00,1.37,72.61,'2022-09-10 12:45:39','',''),(6431,'1','277','1',1,'Retail Sale Id 6427',9100.00,0.00,0.00,12.50,662.50,'2022-09-10 13:08:22','',''),(6432,'1','277','1',1,'Retail Sale Id 6428',9100.00,0.00,0.00,12.50,662.50,'2022-09-10 13:09:14','',''),(6433,'1','277','1',1,'Retail Sale Id 6429',36400.00,0.00,0.00,50.00,2650.00,'2022-09-10 13:12:09','',''),(6434,'1','277','1',1,'Retail Sale Id 6430',4397.12,0.00,0.00,6.04,320.12,'2022-09-10 13:17:39','',''),(6435,'1','277','1',1,'Retail Sale Id 6431',9100.00,0.00,0.00,12.50,662.50,'2022-09-10 13:18:32','',''),(6436,'1','277','1',1,'Retail Sale Id 6432',4200.56,0.00,0.00,5.77,305.81,'2022-09-10 13:19:31','',''),(6437,'1','277','1',1,'Retail Sale Id 6433',2999.36,0.00,0.00,4.12,218.36,'2022-09-10 13:20:23','',''),(6438,'1','277','1',1,'Retail Sale Id 6434',4499.04,0.00,0.00,6.18,327.54,'2022-09-10 13:37:19','',''),(6439,'1','277','1',1,'Retail Sale Id 6435',749.84,0.00,0.00,1.03,54.59,'2022-09-10 13:47:09','',''),(6440,'1','277','1',1,'Retail Sale Id 6436',3996.72,0.00,0.00,5.49,290.97,'2022-09-10 13:49:05','',''),(6441,'1','277','1',1,'Retail Sale Id 6437',8000.72,0.00,0.00,10.99,582.47,'2022-09-10 14:03:32','',''),(6442,'1','277','1',1,'Retail Sale Id 6438',1499.68,0.00,0.00,2.06,109.18,'2022-09-10 14:06:25','',''),(6443,'1','277','1',1,'Retail Sale Id 6439',502.32,0.00,0.00,0.69,36.57,'2022-09-10 14:12:43','',''),(6444,'1','277','1',1,'Retail Sale Id 6439',2999.36,0.00,0.00,4.12,218.36,'2022-09-10 14:12:43','',''),(6445,'1','277','1',1,'Retail Sale Id 6440',4397.12,0.00,0.00,6.04,320.12,'2022-09-10 14:21:38','',''),(6446,'1','277','1',1,'Retail Sale Id 6441',2999.36,0.00,0.00,4.12,218.36,'2022-09-10 14:27:20','',''),(6447,'1','277','1',1,'Retail Sale Id 6442',1499.68,0.00,0.00,2.06,109.18,'2022-09-10 14:28:32','',''),(6448,'1','277','1',1,'Retail Sale Id 6443',4397.12,0.00,0.00,6.04,320.12,'2022-09-10 14:31:40','',''),(6449,'1','277','1',1,'Retail Sale Id 6444',2999.36,0.00,0.00,4.12,218.36,'2022-09-10 14:36:23','',''),(6450,'1','277','1',1,'Retail Sale Id 6445',1900.08,0.00,0.00,2.61,138.33,'2022-09-10 14:42:19','',''),(6451,'1','277','1',1,'Retail Sale Id 6446',997.36,0.00,0.00,1.37,72.61,'2022-09-10 14:43:25','',''),(6452,'1','277','1',1,'Retail Sale Id 6447',997.36,0.00,0.00,1.37,72.61,'2022-09-10 14:44:30','',''),(6453,'1','277','1',1,'Retail Sale Id 6448',1499.68,0.00,0.00,2.06,109.18,'2022-09-10 14:45:40','',''),(6454,'1','277','1',1,'Retail Sale Id 6449',2999.36,0.00,0.00,4.12,218.36,'2022-09-10 14:47:21','',''),(6455,'1','277','1',1,'Retail Sale Id 6450',997.36,0.00,0.00,1.37,72.61,'2022-09-10 14:51:19','',''),(6456,'1','277','1',1,'Retail Sale Id 6451',2002.00,0.00,0.00,2.75,145.75,'2022-09-10 14:55:11','',''),(6457,'1','277','1',1,'Retail Sale Id 6452',2999.36,0.00,0.00,4.12,218.36,'2022-09-10 15:10:41','',''),(6458,'1','277','1',1,'Retail Sale Id 6453',4397.12,0.00,0.00,6.04,320.12,'2022-09-10 15:14:11','',''),(6459,'1','277','1',1,'Retail Sale Id 6454',4397.12,0.00,0.00,6.04,320.12,'2022-09-10 15:15:02','',''),(6460,'1','277','1',1,'Retail Sale Id 6455',2999.36,0.00,0.00,4.12,218.36,'2022-09-10 15:16:14','',''),(6461,'1','277','1',1,'Retail Sale Id 6456',4397.12,0.00,0.00,6.04,320.12,'2022-09-10 15:22:39','',''),(6462,'1','277','1',1,'Retail Sale Id 6457',1099.28,0.00,0.00,1.51,80.03,'2022-09-10 15:24:44','',''),(6463,'1','277','1',1,'Retail Sale Id 6458',2198.56,0.00,0.00,3.02,160.06,'2022-09-10 15:27:42','',''),(6464,'1','277','1',1,'Retail Sale Id 6459',9100.00,0.00,0.00,12.50,662.50,'2022-09-10 15:29:14','',''),(6465,'1','277','1',1,'Retail Sale Id 6460',2198.56,0.00,0.00,3.02,160.06,'2022-09-10 15:31:14','',''),(6466,'1','277','1',1,'Retail Sale Id 6461',4397.12,0.00,0.00,6.04,320.12,'2022-09-10 15:32:42','',''),(6467,'1','277','1',1,'Retail Sale Id 6462',1798.16,0.00,0.00,2.47,130.91,'2022-09-10 15:33:44','',''),(6468,'1','277','1',1,'Retail Sale Id 6463',2198.56,0.00,0.00,3.02,160.06,'2022-09-10 15:35:21','',''),(6469,'1','277','1',1,'Retail Sale Id 6464',2198.56,0.00,0.00,3.02,160.06,'2022-09-10 15:38:57','',''),(6470,'1','277','1',1,'Retail Sale Id 6465',2002.00,0.00,0.00,2.75,145.75,'2022-09-10 15:40:14','',''),(6471,'1','277','1',1,'Retail Sale Id 6466',2002.00,0.00,0.00,2.75,145.75,'2022-09-10 15:41:27','',''),(6472,'1','277','1',1,'Retail Sale Id 6467',2198.56,0.00,0.00,3.02,160.06,'2022-09-10 15:42:49','',''),(6473,'1','277','1',1,'Retail Sale Id 6468',3996.72,0.00,0.00,5.49,290.97,'2022-09-10 15:54:00','',''),(6474,'1','277','1',1,'Retail Sale Id 6469',2198.56,0.00,0.00,3.02,160.06,'2022-09-10 15:55:33','',''),(6475,'1','277','1',1,'Retail Sale Id 6470',997.36,0.00,0.00,1.37,72.61,'2022-09-10 15:56:45','',''),(6476,'1','277','1',1,'Retail Sale Id 6471',1499.68,0.00,0.00,2.06,109.18,'2022-09-10 15:58:14','',''),(6477,'1','277','1',1,'Retail Sale Id 6472',2198.56,0.00,0.00,3.02,160.06,'2022-09-10 16:06:05','',''),(6478,'1','277','1',1,'Retail Sale Id 6473',4397.12,0.00,0.00,6.04,320.12,'2022-09-10 16:07:18','',''),(6479,'1','277','1',1,'Retail Sale Id 6474',1499.68,0.00,0.00,2.06,109.18,'2022-09-10 16:17:59','',''),(6480,'1','277','1',1,'Retail Sale Id 6475',4499.04,0.00,0.00,6.18,327.54,'2022-09-10 16:21:01','',''),(6481,'1','277','1',1,'Retail Sale Id 6476',4397.12,0.00,0.00,6.04,320.12,'2022-09-10 16:23:13','',''),(6482,'1','277','1',1,'Retail Sale Id 6477',2002.00,0.00,0.00,2.75,145.75,'2022-09-10 16:28:56','',''),(6483,'1','277','1',1,'Retail Sale Id 6478',2002.00,0.00,0.00,2.75,145.75,'2022-09-10 16:30:03','',''),(6484,'1','277','1',1,'Retail Sale Id 6479',2198.56,0.00,0.00,3.02,160.06,'2022-09-10 16:31:17','',''),(6485,'1','277','1',1,'Retail Sale Id 6480',3647.28,0.00,0.00,5.01,265.53,'2022-09-10 16:32:55','',''),(6486,'1','277','1',1,'Retail Sale Id 6481',2497.04,0.00,0.00,3.43,181.79,'2022-09-10 16:33:45','',''),(6487,'1','277','1',1,'Retail Sale Id 6482',7702.24,0.00,0.00,10.58,560.74,'2022-09-10 16:36:01','',''),(6488,'1','277','1',1,'Retail Sale Id 6483',1499.68,0.00,0.00,2.06,109.18,'2022-09-10 16:37:08','',''),(6489,'1','277','1',1,'Retail Sale Id 6484',2002.00,0.00,0.00,2.75,145.75,'2022-09-10 16:38:38','',''),(6490,'1','277','1',1,'Retail Sale Id 6484',2002.00,0.00,0.00,2.75,145.75,'2022-09-10 16:38:38','',''),(6491,'1','277','1',1,'Retail Sale Id 6485',2002.00,0.00,0.00,2.75,145.75,'2022-09-10 16:39:38','',''),(6492,'1','277','1',1,'Retail Sale Id 6486',502.32,0.00,0.00,0.69,36.57,'2022-09-10 16:42:00','',''),(6493,'1','277','1',1,'Retail Sale Id 6487',1499.68,0.00,0.00,2.06,109.18,'2022-09-10 16:47:09','',''),(6494,'1','277','1',1,'Retail Sale Id 6487',9100.00,0.00,0.00,12.50,662.50,'2022-09-10 16:47:09','',''),(6495,'1','277','1',1,'Retail Sale Id 6488',1499.68,0.00,0.00,2.06,109.18,'2022-09-10 16:50:23','',''),(6496,'1','277','1',1,'Retail Sale Id 6489',1397.76,0.00,0.00,1.92,101.76,'2022-09-10 16:52:46','',''),(6497,'1','277','1',1,'Retail Sale Id 6490',9100.00,0.00,0.00,12.50,662.50,'2022-09-10 16:55:38','',''),(6498,'1','277','1',1,'Retail Sale Id 6491',2198.56,0.00,0.00,3.02,160.06,'2022-09-10 16:57:08','',''),(6499,'1','277','1',1,'Retail Sale Id 6492',2198.56,0.00,0.00,3.02,160.06,'2022-09-10 16:58:47','',''),(6500,'1','277','1',1,'Retail Sale Id 6493',7301.84,0.00,0.00,10.03,531.59,'2022-09-10 17:01:12','',''),(6501,'1','277','1',1,'Retail Sale Id 6494',749.84,0.00,0.00,1.03,54.59,'2022-09-10 17:05:27','',''),(6502,'1','277','1',1,'Retail Sale Id 6494',749.84,0.00,0.00,1.03,54.59,'2022-09-10 17:05:27','',''),(6503,'1','277','1',1,'Retail Sale Id 6496',4397.12,0.00,0.00,6.04,320.12,'2022-09-10 17:06:44','',''),(6504,'1','277','1',1,'Retail Sale Id 6497',1499.68,0.00,0.00,2.06,109.18,'2022-09-10 17:08:57','',''),(6505,'1','277','1',1,'Retail Sale Id 6498',1499.68,0.00,0.00,2.06,109.18,'2022-09-10 17:09:44','',''),(6506,'1','277','1',1,'Retail Sale Id 6499',2002.00,0.00,0.00,2.75,145.75,'2022-09-10 17:10:40','',''),(6507,'1','277','1',1,'Retail Sale Id 6500',997.36,0.00,0.00,1.37,72.61,'2022-09-10 17:11:43','',''),(6508,'1','277','1',1,'Retail Sale Id 6501',997.36,0.00,0.00,1.37,72.61,'2022-09-10 17:12:42','',''),(6509,'1','277','1',1,'Retail Sale Id 6502',800.80,0.00,0.00,1.10,58.30,'2022-09-10 17:17:10','',''),(6510,'1','277','1',1,'Retail Sale Id 6503',2999.36,0.00,0.00,4.12,218.36,'2022-09-10 17:19:48','',''),(6511,'1','277','1',1,'Retail Sale Id 6504',749.84,0.00,0.00,1.03,54.59,'2022-09-10 17:20:45','',''),(6512,'1','277','1',1,'Retail Sale Id 6505',5001.36,0.00,0.00,6.87,364.11,'2022-09-10 17:21:44','',''),(6513,'1','277','1',1,'Retail Sale Id 6506',1499.68,0.00,0.00,2.06,109.18,'2022-09-10 17:24:01','',''),(6514,'1','277','1',1,'Retail Sale Id 6507',3996.72,0.00,0.00,5.49,290.97,'2022-09-10 17:30:09','',''),(6515,'1','277','1',1,'Retail Sale Id 6508',2002.00,0.00,0.00,2.75,145.75,'2022-09-10 17:35:20','',''),(6516,'1','277','1',1,'Retail Sale Id 6509',9100.00,0.00,0.00,12.50,662.50,'2022-09-10 17:36:45','',''),(6517,'1','277','1',1,'Retail Sale Id 6510',2999.36,0.00,0.00,4.12,218.36,'2022-09-10 17:41:56','',''),(6518,'1','277','1',1,'Retail Sale Id 6511',2002.00,0.00,0.00,2.75,145.75,'2022-09-10 17:47:02','',''),(6519,'1','277','1',1,'Retail Sale Id 6512',1499.68,0.00,0.00,2.06,109.18,'2022-09-10 17:48:15','',''),(6520,'1','277','1',1,'Retail Sale Id 6513',4397.12,0.00,0.00,6.04,320.12,'2022-09-10 17:51:04','',''),(6521,'1','277','1',1,'Retail Sale Id 6514',1499.68,0.00,0.00,2.06,109.18,'2022-09-10 17:53:39','',''),(6522,'1','277','1',1,'Retail Sale Id 6515',3647.28,0.00,0.00,5.01,265.53,'2022-09-10 17:54:56','',''),(6523,'1','277','1',1,'Retail Sale Id 6516',9100.00,0.00,0.00,12.50,662.50,'2022-09-10 17:55:44','',''),(6524,'1','277','1',1,'Retail Sale Id 6517',2497.04,0.00,0.00,3.43,181.79,'2022-09-10 17:56:48','',''),(6525,'1','277','1',1,'Retail Sale Id 6518',3996.72,0.00,0.00,5.49,290.97,'2022-09-10 17:57:46','',''),(6526,'1','277','1',1,'Retail Sale Id 6519',2300.48,0.00,0.00,3.16,167.48,'2022-09-10 18:04:08','',''),(6527,'1','277','1',1,'Retail Sale Id 6520',4397.12,0.00,0.00,6.04,320.12,'2022-09-10 18:06:02','',''),(6528,'1','277','1',1,'Retail Sale Id 6521',997.36,0.00,0.00,1.37,72.61,'2022-09-10 18:07:34','',''),(6529,'1','277','1',1,'Retail Sale Id 6522',2198.56,0.00,0.00,3.02,160.06,'2022-09-10 18:08:31','',''),(6530,'1','277','1',1,'Retail Sale Id 6523',3647.28,0.00,0.00,5.01,265.53,'2022-09-10 18:10:00','',''),(6531,'1','277','1',1,'Retail Sale Id 6524',2999.36,0.00,0.00,4.12,218.36,'2022-09-10 18:12:12','',''),(6532,'1','277','1',1,'Retail Sale Id 6525',997.36,0.00,0.00,1.37,72.61,'2022-09-10 18:13:58','',''),(6533,'1','277','1',1,'Retail Sale Id 6526',4397.12,0.00,0.00,6.04,320.12,'2022-09-10 18:14:52','',''),(6534,'1','277','1',1,'Retail Sale Id 6527',4397.12,0.00,0.00,6.04,320.12,'2022-09-10 18:20:25','',''),(6535,'1','277','1',1,'Retail Sale Id 6528',1499.68,0.00,0.00,2.06,109.18,'2022-09-10 18:22:04','',''),(6536,'1','277','1',1,'Retail Sale Id 6529',3647.28,0.00,0.00,5.01,265.53,'2022-09-10 18:26:10','',''),(6537,'1','277','1',1,'Retail Sale Id 6530',9100.00,0.00,0.00,12.50,662.50,'2022-09-10 18:28:42','',''),(6538,'1','277','1',1,'Retail Sale Id 6531',2198.56,0.00,0.00,3.02,160.06,'2022-09-10 18:32:13','',''),(6539,'1','277','1',1,'Retail Sale Id 6531',3800.16,0.00,0.00,5.22,276.66,'2022-09-10 18:32:13','',''),(6540,'1','277','1',1,'Retail Sale Id 6532',800.80,0.00,0.00,1.10,58.30,'2022-09-10 18:33:31','',''),(6541,'1','277','1',1,'Retail Sale Id 6533',902.72,0.00,0.00,1.24,65.72,'2022-09-10 18:34:33','',''),(6542,'1','277','1',1,'Retail Sale Id 6534',749.84,0.00,0.00,1.03,54.59,'2022-09-10 18:35:42','',''),(6543,'1','277','1',1,'Retail Sale Id 6535',2999.36,0.00,0.00,4.12,218.36,'2022-09-10 18:36:34','',''),(6544,'1','277','1',1,'Retail Sale Id 6536',2999.36,0.00,0.00,4.12,218.36,'2022-09-10 18:37:26','',''),(6545,'1','277','1',1,'Retail Sale Id 6537',4397.12,0.00,0.00,6.04,320.12,'2022-09-10 18:38:54','',''),(6546,'1','277','1',1,'Retail Sale Id 6538',800.80,0.00,0.00,1.10,58.30,'2022-09-10 18:40:14','',''),(6547,'1','277','1',1,'Retail Sale Id 6539',9100.00,0.00,0.00,12.50,662.50,'2022-09-10 18:41:27','',''),(6548,'1','277','1',1,'Retail Sale Id 6540',4499.04,0.00,0.00,6.18,327.54,'2022-09-10 18:43:51','',''),(6549,'1','277','1',1,'Retail Sale Id 6541',5001.36,0.00,0.00,6.87,364.11,'2022-09-10 18:45:03','',''),(6550,'1','277','1',1,'Retail Sale Id 6542',4499.04,0.00,0.00,6.18,327.54,'2022-09-10 18:46:44','',''),(6551,'1','277','1',1,'Retail Sale Id 6543',596.96,0.00,0.00,0.82,43.46,'2022-09-10 18:48:34','',''),(6552,'1','277','1',1,'Retail Sale Id 6544',8998.08,0.00,0.00,12.36,655.08,'2022-09-10 18:49:58','',''),(6553,'1','277','1',1,'Retail Sale Id 6545',502.32,0.00,0.00,0.69,36.57,'2022-09-10 18:50:59','',''),(6554,'1','277','1',1,'Retail Sale Id 6546',2999.36,0.00,0.00,4.12,218.36,'2022-09-10 19:09:05','',''),(6555,'1','277','1',1,'Retail Sale Id 6547',2497.04,0.00,0.00,3.43,181.79,'2022-09-10 19:16:47','',''),(6556,'1','277','1',1,'Return of Retail Sale Id 6522',0.00,2198.56,3.02,0.00,-160.06,'2022-09-10 19:38:56','',''),(6557,'1','277','1',1,'Retail Sale Id 6548',2045.68,0.00,0.00,2.81,148.93,'2022-09-10 19:40:33','',''),(6558,'1','277','1',1,'Return of Retail Sale Id 6548',0.00,2045.68,2.81,0.00,-148.93,'2022-09-10 19:44:24','',''),(6559,'1','277','1',1,'Retail Sale Id 6550',2198.56,0.00,0.00,3.02,160.06,'2022-09-10 19:50:08','',''),(6560,'1','277','1',1,'Retail Sale Id 6551',152.88,0.00,0.00,0.21,11.13,'2022-09-10 19:54:05','',''),(6561,'1','277','1',1,'Retail Sale Id 6552',4397.12,0.00,0.00,6.04,320.12,'2022-09-11 07:02:02','',''),(6562,'1','277','1',1,'Retail Sale Id 6553',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 07:04:08','',''),(6563,'1','277','1',1,'Retail Sale Id 6554',1798.16,0.00,0.00,2.47,130.91,'2022-09-11 07:25:07','',''),(6564,'1','277','1',1,'Retail Sale Id 6555',2897.44,0.00,0.00,3.98,210.94,'2022-09-11 07:30:29','',''),(6565,'1','277','1',1,'Retail Sale Id 6556',2198.56,0.00,0.00,3.02,160.06,'2022-09-11 07:31:32','',''),(6566,'1','277','1',1,'Retail Sale Id 6557',749.84,0.00,0.00,1.03,54.59,'2022-09-11 07:42:08','',''),(6567,'1','277','1',1,'Retail Sale Id 6557',997.36,0.00,0.00,1.37,72.61,'2022-09-11 07:42:08','',''),(6568,'1','277','1',1,'Retail Sale Id 6558',4397.12,0.00,0.00,6.04,320.12,'2022-09-11 07:45:48','',''),(6569,'1','277','1',1,'Retail Sale Id 6559',997.36,0.00,0.00,1.37,72.61,'2022-09-11 07:47:56','',''),(6570,'1','277','1',1,'Retail Sale Id 6560',997.36,0.00,0.00,1.37,72.61,'2022-09-11 07:48:41','',''),(6571,'1','277','1',1,'Retail Sale Id 6561',749.84,0.00,0.00,1.03,54.59,'2022-09-11 07:49:52','',''),(6572,'1','277','1',1,'Retail Sale Id 6562',3501.68,0.00,0.00,4.81,254.93,'2022-09-11 07:51:13','',''),(6573,'1','277','1',1,'Retail Sale Id 6563',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 07:55:49','',''),(6574,'1','277','1',1,'Retail Sale Id 6564',997.36,0.00,0.00,1.37,72.61,'2022-09-11 07:57:59','',''),(6575,'1','277','1',1,'Retail Sale Id 6565',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 08:01:58','',''),(6576,'1','277','1',1,'Retail Sale Id 6566',7280.00,0.00,0.00,10.00,530.00,'2022-09-11 08:10:08','',''),(6577,'1','277','1',1,'Retail Sale Id 6567',3647.28,0.00,0.00,5.01,265.53,'2022-09-11 08:12:27','',''),(6578,'1','277','1',1,'Retail Sale Id 6568',2002.00,0.00,0.00,2.75,145.75,'2022-09-11 08:13:10','',''),(6579,'1','277','1',1,'Retail Sale Id 6569',4397.12,0.00,0.00,6.04,320.12,'2022-09-11 08:14:04','',''),(6580,'1','277','1',1,'Retail Sale Id 6570',2002.00,0.00,0.00,2.75,145.75,'2022-09-11 08:15:14','',''),(6581,'1','277','1',1,'Retail Sale Id 6571',2198.56,0.00,0.00,3.02,160.06,'2022-09-11 08:16:33','',''),(6582,'1','277','1',1,'Retail Sale Id 6572',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 08:22:50','',''),(6583,'1','277','1',1,'Retail Sale Id 6573',698.88,0.00,0.00,0.96,50.88,'2022-09-11 08:23:44','',''),(6584,'1','277','1',1,'Retail Sale Id 6574',3603.60,0.00,0.00,4.95,262.35,'2022-09-11 08:33:46','',''),(6585,'1','277','1',1,'Retail Sale Id 6575',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 08:35:05','',''),(6586,'1','277','1',1,'Retail Sale Id 6576',800.80,0.00,0.00,1.10,58.30,'2022-09-11 08:36:27','',''),(6587,'1','277','1',1,'Retail Sale Id 6577',2198.56,0.00,0.00,3.02,160.06,'2022-09-11 08:38:01','',''),(6588,'1','277','1',1,'Retail Sale Id 6578',1099.28,0.00,0.00,1.51,80.03,'2022-09-11 08:38:52','',''),(6589,'1','277','1',1,'Retail Sale Id 6579',5001.36,0.00,0.00,6.87,364.11,'2022-09-11 08:41:25','',''),(6590,'1','277','1',1,'Retail Sale Id 6580',997.36,0.00,0.00,1.37,72.61,'2022-09-11 08:42:29','',''),(6591,'1','277','1',1,'Retail Sale Id 6581',2002.00,0.00,0.00,2.75,145.75,'2022-09-11 08:43:22','',''),(6592,'1','277','1',1,'Retail Sale Id 6582',1703.52,0.00,0.00,2.34,124.02,'2022-09-11 08:44:21','',''),(6593,'1','277','1',1,'Retail Sale Id 6583',2002.00,0.00,0.00,2.75,145.75,'2022-09-11 08:50:38','',''),(6594,'1','277','1',1,'Retail Sale Id 6584',800.80,0.00,0.00,1.10,58.30,'2022-09-11 08:53:23','',''),(6595,'1','277','1',1,'Retail Sale Id 6585',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 08:54:12','',''),(6596,'1','277','1',1,'Retail Sale Id 6586',3996.72,0.00,0.00,5.49,290.97,'2022-09-11 08:54:57','',''),(6597,'1','277','1',1,'Retail Sale Id 6587',2198.56,0.00,0.00,3.02,160.06,'2022-09-11 08:57:47','',''),(6598,'1','277','1',1,'Retail Sale Id 6588',7280.00,0.00,0.00,10.00,530.00,'2022-09-11 08:59:45','',''),(6599,'1','277','1',1,'Retail Sale Id 6589',3276.00,0.00,0.00,4.50,238.50,'2022-09-11 09:05:33','',''),(6600,'1','277','1',1,'Retail Sale Id 6590',2198.56,0.00,0.00,3.02,160.06,'2022-09-11 09:07:01','',''),(6601,'1','277','1',1,'Retail Sale Id 6591',5998.72,0.00,0.00,8.24,436.72,'2022-09-11 09:20:21','',''),(6602,'1','277','1',1,'Retail Sale Id 6592',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 09:21:24','',''),(6603,'1','277','1',1,'Retail Sale Id 6593',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 09:23:35','',''),(6604,'1','277','1',1,'Retail Sale Id 6594',2198.56,0.00,0.00,3.02,160.06,'2022-09-11 09:24:22','',''),(6605,'1','277','1',1,'Retail Sale Id 6595',2198.56,0.00,0.00,3.02,160.06,'2022-09-11 09:30:07','',''),(6606,'1','277','1',1,'Retail Sale Id 6596',800.80,0.00,0.00,1.10,58.30,'2022-09-11 09:42:57','',''),(6607,'1','277','1',1,'Retail Sale Id 6597',2999.36,0.00,0.00,4.12,218.36,'2022-09-11 09:43:49','',''),(6608,'1','277','1',1,'Retail Sale Id 6598',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 09:47:24','',''),(6609,'1','277','1',1,'Retail Sale Id 6599',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 09:54:00','',''),(6610,'1','277','1',1,'Retail Sale Id 6600',2002.00,0.00,0.00,2.75,145.75,'2022-09-11 09:57:38','',''),(6611,'1','277','1',1,'Retail Sale Id 6601',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 09:58:38','',''),(6612,'1','277','1',1,'Retail Sale Id 6602',4397.12,0.00,0.00,6.04,320.12,'2022-09-11 10:01:03','',''),(6613,'1','277','1',1,'Retail Sale Id 6603',2198.56,0.00,0.00,3.02,160.06,'2022-09-11 10:05:01','',''),(6614,'1','277','1',1,'Retail Sale Id 6604',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 10:06:24','',''),(6615,'1','277','1',1,'Retail Sale Id 6605',4499.04,0.00,0.00,6.18,327.54,'2022-09-11 10:12:48','',''),(6616,'1','277','1',1,'Retail Sale Id 6606',997.36,0.00,0.00,1.37,72.61,'2022-09-11 10:13:49','',''),(6617,'1','277','1',1,'Retail Sale Id 6607',3698.24,0.00,0.00,5.08,269.24,'2022-09-11 10:19:06','',''),(6618,'1','277','1',1,'Retail Sale Id 6608',997.36,0.00,0.00,1.37,72.61,'2022-09-11 10:20:12','',''),(6619,'1','277','1',1,'Retail Sale Id 6609',2999.36,0.00,0.00,4.12,218.36,'2022-09-11 10:21:18','',''),(6620,'1','277','1',1,'Retail Sale Id 6610',2999.36,0.00,0.00,4.12,218.36,'2022-09-11 10:22:15','',''),(6621,'1','277','1',1,'Retail Sale Id 6611',997.36,0.00,0.00,1.37,72.61,'2022-09-11 10:23:09','',''),(6622,'1','277','1',1,'Retail Sale Id 6612',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 10:36:24','',''),(6623,'1','277','1',1,'Retail Sale Id 6613',2002.00,0.00,0.00,2.75,145.75,'2022-09-11 10:51:41','',''),(6624,'1','277','1',1,'Retail Sale Id 6613',9100.00,0.00,0.00,12.50,662.50,'2022-09-11 10:51:41','',''),(6625,'1','277','1',1,'Retail Sale Id 6614',3501.68,0.00,0.00,4.81,254.93,'2022-09-11 10:52:49','',''),(6626,'1','277','1',1,'Retail Sale Id 6615',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 10:53:43','',''),(6627,'1','277','1',1,'Retail Sale Id 6616',4397.12,0.00,0.00,6.04,320.12,'2022-09-11 10:57:22','',''),(6628,'1','277','1',1,'Retail Sale Id 6617',2198.56,0.00,0.00,3.02,160.06,'2022-09-11 11:02:20','',''),(6629,'1','277','1',1,'Retail Sale Id 6618',997.36,0.00,0.00,1.37,72.61,'2022-09-11 11:09:47','',''),(6630,'1','277','1',1,'Retail Sale Id 6618',2999.36,0.00,0.00,4.12,218.36,'2022-09-11 11:09:47','',''),(6631,'1','277','1',1,'Retail Sale Id 6619',9100.00,0.00,0.00,12.50,662.50,'2022-09-11 11:14:03','',''),(6632,'1','277','1',1,'Retail Sale Id 6620',4397.12,0.00,0.00,6.04,320.12,'2022-09-11 11:21:13','',''),(6633,'1','277','1',1,'Retail Sale Id 6621',1201.20,0.00,0.00,1.65,87.45,'2022-09-11 11:22:15','',''),(6634,'1','277','1',1,'Retail Sale Id 6622',3698.24,0.00,0.00,5.08,269.24,'2022-09-11 11:24:57','',''),(6635,'1','277','1',1,'Retail Sale Id 6623',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 11:28:36','',''),(6636,'1','277','1',1,'Retail Sale Id 6624',2999.36,0.00,0.00,4.12,218.36,'2022-09-11 11:30:45','',''),(6637,'1','277','1',1,'Retail Sale Id 6625',4397.12,0.00,0.00,6.04,320.12,'2022-09-11 11:34:30','',''),(6638,'1','277','1',1,'Retail Sale Id 6626',997.36,0.00,0.00,1.37,72.61,'2022-09-11 11:39:12','',''),(6639,'1','277','1',1,'Retail Sale Id 6628',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 11:43:16','',''),(6640,'1','277','1',1,'Retail Sale Id 6629',2802.80,0.00,0.00,3.85,204.05,'2022-09-11 11:44:33','',''),(6641,'1','277','1',1,'Retail Sale Id 6630',698.88,0.00,0.00,0.96,50.88,'2022-09-11 11:54:41','',''),(6642,'1','277','1',1,'Retail Sale Id 6631',502.32,0.00,0.00,0.69,36.57,'2022-09-11 11:55:53','',''),(6643,'1','277','1',1,'Retail Sale Id 6632',3640.00,0.00,0.00,5.00,265.00,'2022-09-11 12:00:21','',''),(6644,'1','277','1',1,'Retail Sale Id 6633',4397.12,0.00,0.00,6.04,320.12,'2022-09-11 12:03:48','',''),(6645,'1','277','1',1,'Retail Sale Id 6634',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 12:04:47','',''),(6646,'1','277','1',1,'Retail Sale Id 6635',2999.36,0.00,0.00,4.12,218.36,'2022-09-11 12:07:00','',''),(6647,'1','277','1',1,'Retail Sale Id 6636',698.88,0.00,0.00,0.96,50.88,'2022-09-11 12:08:31','',''),(6648,'1','277','1',1,'Retail Sale Id 6637',2497.04,0.00,0.00,3.43,181.79,'2022-09-11 12:09:17','',''),(6649,'1','277','1',1,'Retail Sale Id 6638',2999.36,0.00,0.00,4.12,218.36,'2022-09-11 12:10:12','',''),(6650,'1','277','1',1,'Retail Sale Id 6639',9100.00,0.00,0.00,12.50,662.50,'2022-09-11 12:11:30','',''),(6651,'1','277','1',1,'Retail Sale Id 6640',2999.36,0.00,0.00,4.12,218.36,'2022-09-11 12:18:53','',''),(6652,'1','277','1',1,'Retail Sale Id 6641',4397.12,0.00,0.00,6.04,320.12,'2022-09-11 12:22:25','',''),(6653,'1','277','1',1,'Retail Sale Id 6641',4397.12,0.00,0.00,6.04,320.12,'2022-09-11 12:22:25','',''),(6654,'1','277','1',1,'Retail Sale Id 6642',2002.00,0.00,0.00,2.75,145.75,'2022-09-11 12:23:22','',''),(6655,'1','277','1',1,'Retail Sale Id 6643',3996.72,0.00,0.00,5.49,290.97,'2022-09-11 12:24:09','',''),(6656,'1','277','1',1,'Retail Sale Id 6644',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 12:27:29','',''),(6657,'1','277','1',1,'Retail Sale Id 6645',2999.36,0.00,0.00,4.12,218.36,'2022-09-11 12:28:15','',''),(6658,'1','277','1',1,'Retail Sale Id 6646',2198.56,0.00,0.00,3.02,160.06,'2022-09-11 12:29:21','',''),(6659,'1','277','1',1,'Retail Sale Id 6647',3698.24,0.00,0.00,5.08,269.24,'2022-09-11 12:30:26','',''),(6660,'1','277','1',1,'Retail Sale Id 6648',2002.00,0.00,0.00,2.75,145.75,'2022-09-11 12:31:59','',''),(6661,'1','277','1',1,'Retail Sale Id 6649',749.84,0.00,0.00,1.03,54.59,'2022-09-11 12:36:24','',''),(6662,'1','277','1',1,'Retail Sale Id 6650',7280.00,0.00,0.00,10.00,530.00,'2022-09-11 12:38:40','',''),(6663,'1','277','1',1,'Retail Sale Id 6651',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 12:39:32','',''),(6664,'1','277','1',1,'Retail Sale Id 6652',5103.28,0.00,0.00,7.01,371.53,'2022-09-11 12:41:44','',''),(6665,'1','277','1',1,'Retail Sale Id 6653',2002.00,0.00,0.00,2.75,145.75,'2022-09-11 12:47:01','',''),(6666,'1','277','1',1,'Retail Sale Id 6654',1201.20,0.00,0.00,1.65,87.45,'2022-09-11 12:50:11','',''),(6667,'1','277','1',1,'Retail Sale Id 6655',4397.12,0.00,0.00,6.04,320.12,'2022-09-11 12:52:50','',''),(6668,'1','277','1',1,'Retail Sale Id 6655',9100.00,0.00,0.00,12.50,662.50,'2022-09-11 12:52:50','',''),(6669,'1','277','1',1,'Retail Sale Id 6656',2002.00,0.00,0.00,2.75,145.75,'2022-09-11 12:53:58','',''),(6670,'1','277','1',1,'Retail Sale Id 6657',749.84,0.00,0.00,1.03,54.59,'2022-09-11 12:55:10','',''),(6671,'1','277','1',1,'Retail Sale Id 6658',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 12:57:39','',''),(6672,'1','277','1',1,'Retail Sale Id 6659',3996.72,0.00,0.00,5.49,290.97,'2022-09-11 13:00:27','',''),(6673,'1','277','1',1,'Retail Sale Id 6660',997.36,0.00,0.00,1.37,72.61,'2022-09-11 13:01:11','',''),(6674,'1','277','1',1,'Retail Sale Id 6661',4397.12,0.00,0.00,6.04,320.12,'2022-09-11 13:02:01','',''),(6675,'1','277','1',1,'Retail Sale Id 6662',997.36,0.00,0.00,1.37,72.61,'2022-09-11 13:06:04','',''),(6676,'1','277','1',1,'Retail Sale Id 6663',2999.36,0.00,0.00,4.12,218.36,'2022-09-11 13:07:08','',''),(6677,'1','277','1',1,'Retail Sale Id 6664',8000.72,0.00,0.00,10.99,582.47,'2022-09-11 13:08:03','',''),(6678,'1','277','1',1,'Retail Sale Id 6665',800.80,0.00,0.00,1.10,58.30,'2022-09-11 13:09:26','',''),(6679,'1','277','1',1,'Retail Sale Id 6666',902.72,0.00,0.00,1.24,65.72,'2022-09-11 13:10:58','',''),(6680,'1','277','1',1,'Retail Sale Id 6667',2198.56,0.00,0.00,3.02,160.06,'2022-09-11 13:12:01','',''),(6681,'1','277','1',1,'Retail Sale Id 6668',5998.72,0.00,0.00,8.24,436.72,'2022-09-11 13:13:26','',''),(6682,'1','277','1',1,'Retail Sale Id 6669',6501.04,0.00,0.00,8.93,473.29,'2022-09-11 13:18:44','',''),(6683,'1','277','1',1,'Retail Sale Id 6670',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 13:19:54','',''),(6684,'1','277','1',1,'Retail Sale Id 6671',1397.76,0.00,0.00,1.92,101.76,'2022-09-11 13:21:15','',''),(6685,'1','277','1',1,'Retail Sale Id 6672',3603.60,0.00,0.00,4.95,262.35,'2022-09-11 13:23:28','',''),(6686,'1','277','1',1,'Retail Sale Id 6673',2999.36,0.00,0.00,4.12,218.36,'2022-09-11 13:24:32','',''),(6687,'1','277','1',1,'Retail Sale Id 6674',2999.36,0.00,0.00,4.12,218.36,'2022-09-11 13:27:38','',''),(6688,'1','277','1',1,'Retail Sale Id 6676',13926.64,0.00,0.00,19.13,1013.89,'2022-09-11 13:44:24','',''),(6689,'1','277','1',1,'Retail Sale Id 6678',2912.00,0.00,0.00,4.00,212.00,'2022-09-11 13:45:43','',''),(6690,'1','277','1',1,'Retail Sale Id 6679',2198.56,0.00,0.00,3.02,160.06,'2022-09-11 13:50:19','',''),(6691,'1','277','1',1,'Retail Sale Id 6680',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 13:51:12','',''),(6692,'1','277','1',1,'Retail Sale Id 6681',2497.04,0.00,0.00,3.43,181.79,'2022-09-11 13:52:05','',''),(6693,'1','277','1',1,'Retail Sale Id 6682',2999.36,0.00,0.00,4.12,218.36,'2022-09-11 13:52:51','',''),(6694,'1','277','1',1,'Retail Sale Id 6683',3996.72,0.00,0.00,5.49,290.97,'2022-09-11 14:03:36','',''),(6695,'1','277','1',1,'Retail Sale Id 6684',3246.88,0.00,0.00,4.46,236.38,'2022-09-11 14:05:48','',''),(6696,'1','277','1',1,'Retail Sale Id 6685',2198.56,0.00,0.00,3.02,160.06,'2022-09-11 14:06:41','',''),(6697,'1','277','1',1,'Retail Sale Id 6686',2497.04,0.00,0.00,3.43,181.79,'2022-09-11 14:07:53','',''),(6698,'1','277','1',1,'Retail Sale Id 6687',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 14:08:51','',''),(6699,'1','277','1',1,'Retail Sale Id 6688',7280.00,0.00,0.00,10.00,530.00,'2022-09-11 14:14:30','',''),(6700,'1','277','1',1,'Retail Sale Id 6689',997.36,0.00,0.00,1.37,72.61,'2022-09-11 14:15:11','',''),(6701,'1','277','1',1,'Retail Sale Id 6690',9100.00,0.00,0.00,12.50,662.50,'2022-09-11 14:16:11','',''),(6702,'1','277','1',1,'Retail Sale Id 6691',2184.00,0.00,0.00,3.00,159.00,'2022-09-11 14:24:15','',''),(6703,'1','277','1',1,'Retail Sale Id 6691',3640.00,0.00,0.00,5.00,265.00,'2022-09-11 14:24:15','',''),(6704,'1','277','1',1,'Retail Sale Id 6691',9100.00,0.00,0.00,12.50,662.50,'2022-09-11 14:24:15','',''),(6705,'1','277','1',1,'Retail Sale Id 6692',2198.56,0.00,0.00,3.02,160.06,'2022-09-11 14:25:39','',''),(6706,'1','277','1',1,'Retail Sale Id 6693',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 14:26:51','',''),(6707,'1','277','1',1,'Retail Sale Id 6694',2948.40,0.00,0.00,4.05,214.65,'2022-09-11 14:28:30','',''),(6708,'1','277','1',1,'Retail Sale Id 6695',997.36,0.00,0.00,1.37,72.61,'2022-09-11 14:29:21','',''),(6709,'1','277','1',1,'Retail Sale Id 6696',4397.12,0.00,0.00,6.04,320.12,'2022-09-11 14:30:08','',''),(6710,'1','277','1',1,'Retail Sale Id 6697',2198.56,0.00,0.00,3.02,160.06,'2022-09-11 14:31:01','',''),(6711,'1','277','1',1,'Retail Sale Id 6698',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 14:31:49','',''),(6712,'1','277','1',1,'Retail Sale Id 6699',2198.56,0.00,0.00,3.02,160.06,'2022-09-11 14:35:24','',''),(6713,'1','277','1',1,'Retail Sale Id 6700',2198.56,0.00,0.00,3.02,160.06,'2022-09-11 14:38:19','',''),(6714,'1','277','1',1,'Retail Sale Id 6701',3640.00,0.00,0.00,5.00,265.00,'2022-09-11 14:45:16','',''),(6715,'1','277','1',1,'Retail Sale Id 6701',4397.12,0.00,0.00,6.04,320.12,'2022-09-11 14:45:16','',''),(6716,'1','277','1',1,'Retail Sale Id 6702',4397.12,0.00,0.00,6.04,320.12,'2022-09-11 14:47:02','',''),(6717,'1','277','1',1,'Retail Sale Id 6702',9100.00,0.00,0.00,12.50,662.50,'2022-09-11 14:47:02','',''),(6718,'1','277','1',1,'Retail Sale Id 6703',4397.12,0.00,0.00,6.04,320.12,'2022-09-11 14:51:10','',''),(6719,'1','277','1',1,'Retail Sale Id 6704',997.36,0.00,0.00,1.37,72.61,'2022-09-11 14:52:01','',''),(6720,'1','277','1',1,'Retail Sale Id 6705',4397.12,0.00,0.00,6.04,320.12,'2022-09-11 14:53:22','',''),(6721,'1','277','1',1,'Retail Sale Id 6706',3297.84,0.00,0.00,4.53,240.09,'2022-09-11 14:54:32','',''),(6722,'1','277','1',1,'Retail Sale Id 6707',2198.56,0.00,0.00,3.02,160.06,'2022-09-11 14:55:57','',''),(6723,'1','277','1',1,'Retail Sale Id 6708',2198.56,0.00,0.00,3.02,160.06,'2022-09-11 14:57:20','',''),(6724,'1','277','1',1,'Retail Sale Id 6709',2002.00,0.00,0.00,2.75,145.75,'2022-09-11 15:04:46','',''),(6725,'1','277','1',1,'Retail Sale Id 6710',2198.56,0.00,0.00,3.02,160.06,'2022-09-11 15:08:26','',''),(6726,'1','277','1',1,'Retail Sale Id 6711',502.32,0.00,0.00,0.69,36.57,'2022-09-11 15:10:37','',''),(6727,'1','277','1',1,'Retail Sale Id 6712',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 15:21:35','',''),(6728,'1','277','1',1,'Retail Sale Id 6712',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 15:21:35','',''),(6729,'1','277','1',1,'Retail Sale Id 6713',997.36,0.00,0.00,1.37,72.61,'2022-09-11 15:23:20','',''),(6730,'1','277','1',1,'Retail Sale Id 6714',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 15:24:22','',''),(6731,'1','277','1',1,'Retail Sale Id 6715',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 15:26:28','',''),(6732,'1','277','1',1,'Retail Sale Id 6716',4397.12,0.00,0.00,6.04,320.12,'2022-09-11 15:30:52','',''),(6733,'1','277','1',1,'Retail Sale Id 6717',2999.36,0.00,0.00,4.12,218.36,'2022-09-11 15:33:25','',''),(6734,'1','277','1',1,'Retail Sale Id 6718',3501.68,0.00,0.00,4.81,254.93,'2022-09-11 15:34:48','',''),(6735,'1','277','1',1,'Retail Sale Id 6719',2198.56,0.00,0.00,3.02,160.06,'2022-09-11 15:35:44','',''),(6736,'1','277','1',1,'Retail Sale Id 6720',3800.16,0.00,0.00,5.22,276.66,'2022-09-11 15:37:35','',''),(6737,'1','277','1',1,'Retail Sale Id 6721',2198.56,0.00,0.00,3.02,160.06,'2022-09-11 15:38:20','',''),(6738,'1','277','1',1,'Retail Sale Id 6722',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 15:39:39','',''),(6739,'1','277','1',1,'Retail Sale Id 6723',800.80,0.00,0.00,1.10,58.30,'2022-09-11 15:44:05','',''),(6740,'1','277','1',1,'Retail Sale Id 6724',997.36,0.00,0.00,1.37,72.61,'2022-09-11 15:48:48','',''),(6741,'1','277','1',1,'Retail Sale Id 6725',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 15:49:43','',''),(6742,'1','277','1',1,'Retail Sale Id 6726',5001.36,0.00,0.00,6.87,364.11,'2022-09-11 15:50:28','',''),(6743,'1','277','1',1,'Retail Sale Id 6727',2497.04,0.00,0.00,3.43,181.79,'2022-09-11 15:51:16','',''),(6744,'1','277','1',1,'Retail Sale Id 6728',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 15:52:19','',''),(6745,'1','277','1',1,'Retail Sale Id 6729',2002.00,0.00,0.00,2.75,145.75,'2022-09-11 15:53:32','',''),(6746,'1','277','1',1,'Retail Sale Id 6730',3698.24,0.00,0.00,5.08,269.24,'2022-09-11 15:55:36','',''),(6747,'1','277','1',1,'Retail Sale Id 6731',997.36,0.00,0.00,1.37,72.61,'2022-09-11 15:58:29','',''),(6748,'1','277','1',1,'Retail Sale Id 6732',502.32,0.00,0.00,0.69,36.57,'2022-09-11 16:04:47','',''),(6749,'1','277','1',1,'Retail Sale Id 6733',2198.56,0.00,0.00,3.02,160.06,'2022-09-11 16:05:55','',''),(6750,'1','277','1',1,'Retail Sale Id 6734',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 16:06:38','',''),(6751,'1','277','1',1,'Retail Sale Id 6735',4499.04,0.00,0.00,6.18,327.54,'2022-09-11 16:07:47','',''),(6752,'1','277','1',1,'Retail Sale Id 6736',997.36,0.00,0.00,1.37,72.61,'2022-09-11 16:08:59','',''),(6753,'1','277','1',1,'Retail Sale Id 6737',9100.00,0.00,0.00,12.50,662.50,'2022-09-11 16:12:09','',''),(6754,'1','277','1',1,'Retail Sale Id 6738',2999.36,0.00,0.00,4.12,218.36,'2022-09-11 16:13:22','',''),(6755,'1','277','1',1,'Retail Sale Id 6739',4368.00,0.00,0.00,6.00,318.00,'2022-09-11 16:18:34','',''),(6756,'1','277','1',1,'Retail Sale Id 6739',8736.00,0.00,0.00,12.00,636.00,'2022-09-11 16:18:34','',''),(6757,'1','277','1',1,'Retail Sale Id 6740',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 16:20:55','',''),(6758,'1','277','1',1,'Retail Sale Id 6741',2002.00,0.00,0.00,2.75,145.75,'2022-09-11 16:21:41','',''),(6759,'1','277','1',1,'Retail Sale Id 6742',2002.00,0.00,0.00,2.75,145.75,'2022-09-11 16:22:22','',''),(6760,'1','277','1',1,'Retail Sale Id 6743',2002.00,0.00,0.00,2.75,145.75,'2022-09-11 16:23:12','',''),(6761,'1','277','1',1,'Retail Sale Id 6744',7301.84,0.00,0.00,10.03,531.59,'2022-09-11 16:26:19','',''),(6762,'1','277','1',1,'Retail Sale Id 6745',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 16:28:04','',''),(6763,'1','277','1',1,'Retail Sale Id 6746',800.80,0.00,0.00,1.10,58.30,'2022-09-11 16:29:11','',''),(6764,'1','277','1',1,'Retail Sale Id 6747',698.88,0.00,0.00,0.96,50.88,'2022-09-11 16:32:33','',''),(6765,'1','277','1',1,'Retail Sale Id 6748',997.36,0.00,0.00,1.37,72.61,'2022-09-11 16:33:50','',''),(6766,'1','277','1',1,'Retail Sale Id 6749',3996.72,0.00,0.00,5.49,290.97,'2022-09-11 16:35:02','',''),(6767,'1','277','1',1,'Retail Sale Id 6750',2002.00,0.00,0.00,2.75,145.75,'2022-09-11 16:36:00','',''),(6768,'1','277','1',1,'Retail Sale Id 6751',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 16:36:46','',''),(6769,'1','277','1',1,'Retail Sale Id 6752',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 16:37:25','',''),(6770,'1','277','1',1,'Retail Sale Id 6753',2002.00,0.00,0.00,2.75,145.75,'2022-09-11 16:40:18','',''),(6771,'1','277','1',1,'Retail Sale Id 6754',2198.56,0.00,0.00,3.02,160.06,'2022-09-11 16:41:33','',''),(6772,'1','277','1',1,'Retail Sale Id 6755',2002.00,0.00,0.00,2.75,145.75,'2022-09-11 16:45:09','',''),(6773,'1','277','1',1,'Retail Sale Id 6756',9100.00,0.00,0.00,12.50,662.50,'2022-09-11 16:45:58','',''),(6774,'1','277','1',1,'Retail Sale Id 6757',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 16:50:03','',''),(6775,'1','277','1',1,'Retail Sale Id 6758',1303.12,0.00,0.00,1.79,94.87,'2022-09-11 16:51:53','',''),(6776,'1','277','1',1,'Retail Sale Id 6759',2198.56,0.00,0.00,3.02,160.06,'2022-09-11 16:54:17','',''),(6777,'1','277','1',1,'Retail Sale Id 6760',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 16:55:22','',''),(6778,'1','277','1',1,'Retail Sale Id 6761',2999.36,0.00,0.00,4.12,218.36,'2022-09-11 16:57:54','',''),(6779,'1','277','1',1,'Retail Sale Id 6762',3698.24,0.00,0.00,5.08,269.24,'2022-09-11 16:59:18','',''),(6780,'1','277','1',1,'Retail Sale Id 6763',2249.52,0.00,0.00,3.09,163.77,'2022-09-11 17:00:54','',''),(6781,'1','277','1',1,'Retail Sale Id 6764',4499.04,0.00,0.00,6.18,327.54,'2022-09-11 17:01:54','',''),(6782,'1','277','1',1,'Retail Sale Id 6765',2198.56,0.00,0.00,3.02,160.06,'2022-09-11 17:02:43','',''),(6783,'1','277','1',1,'Retail Sale Id 6766',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 17:12:09','',''),(6784,'1','277','1',1,'Retail Sale Id 6767',5001.36,0.00,0.00,6.87,364.11,'2022-09-11 17:13:08','',''),(6785,'1','277','1',1,'Retail Sale Id 6768',4397.12,0.00,0.00,6.04,320.12,'2022-09-11 17:16:42','',''),(6786,'1','277','1',1,'Retail Sale Id 6769',2002.00,0.00,0.00,2.75,145.75,'2022-09-11 17:18:46','',''),(6787,'1','277','1',1,'Retail Sale Id 6770',2002.00,0.00,0.00,2.75,145.75,'2022-09-11 17:25:02','',''),(6788,'1','277','1',1,'Retail Sale Id 6771',4397.12,0.00,0.00,6.04,320.12,'2022-09-11 17:27:00','',''),(6789,'1','277','1',1,'Retail Sale Id 6772',2999.36,0.00,0.00,4.12,218.36,'2022-09-11 17:32:52','',''),(6790,'1','277','1',1,'Retail Sale Id 6773',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 17:33:46','',''),(6791,'1','277','1',1,'Retail Sale Id 6774',298.48,0.00,0.00,0.41,21.73,'2022-09-11 17:38:13','',''),(6792,'1','277','1',1,'Retail Sale Id 6775',1798.16,0.00,0.00,2.47,130.91,'2022-09-11 17:42:02','',''),(6793,'1','277','1',1,'Retail Sale Id 6776',72800.00,0.00,0.00,100.00,5300.00,'2022-09-11 17:45:14','',''),(6794,'1','277','1',1,'Retail Sale Id 6777',2198.56,0.00,0.00,3.02,160.06,'2022-09-11 17:46:50','',''),(6795,'1','277','1',1,'Retail Sale Id 6778',5001.36,0.00,0.00,6.87,364.11,'2022-09-11 17:54:07','',''),(6796,'1','277','1',1,'Retail Sale Id 6780',2198.56,0.00,0.00,3.02,160.06,'2022-09-11 17:56:03','',''),(6797,'1','277','1',1,'Retail Sale Id 6781',9100.00,0.00,0.00,12.50,662.50,'2022-09-11 17:58:13','',''),(6798,'1','277','1',1,'Retail Sale Id 6782',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 18:04:12','',''),(6799,'1','277','1',1,'Retail Sale Id 6783',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 18:05:03','',''),(6800,'1','277','1',1,'Retail Sale Id 6784',2198.56,0.00,0.00,3.02,160.06,'2022-09-11 18:06:26','',''),(6801,'1','277','1',1,'Retail Sale Id 6785',3640.00,0.00,0.00,5.00,265.00,'2022-09-11 18:07:30','',''),(6802,'1','277','1',1,'Retail Sale Id 6786',3647.28,0.00,0.00,5.01,265.53,'2022-09-11 18:28:59','',''),(6803,'1','277','1',1,'Retail Sale Id 6787',5496.40,0.00,0.00,7.55,400.15,'2022-09-11 18:37:18','',''),(6804,'1','277','1',1,'Retail Sale Id 6788',997.36,0.00,0.00,1.37,72.61,'2022-09-11 18:38:25','',''),(6805,'1','277','1',1,'Retail Sale Id 6789',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 18:39:53','',''),(6806,'1','277','1',1,'Retail Sale Id 6790',1499.68,0.00,0.00,2.06,109.18,'2022-09-11 18:41:20','',''),(6807,'1','277','1',1,'Retail Sale Id 6791',2198.56,0.00,0.00,3.02,160.06,'2022-09-11 18:42:19','',''),(6808,'1','277','1',1,'Retail Sale Id 6792',800.80,0.00,0.00,1.10,58.30,'2022-09-11 18:43:10','',''),(6809,'1','277','1',1,'Retail Sale Id 6793',997.36,0.00,0.00,1.37,72.61,'2022-09-11 18:45:48','',''),(6810,'1','277','1',1,'Retail Sale Id 6794',2497.04,0.00,0.00,3.43,181.79,'2022-09-11 18:49:33','',''),(6811,'1','277','1',1,'Retail Sale Id 6795',2198.56,0.00,0.00,3.02,160.06,'2022-09-11 18:52:58','',''),(6812,'1','277','1',1,'Retail Sale Id 6796',4302.48,0.00,0.00,5.91,313.23,'2022-09-11 18:54:55','',''),(6813,'1','277','1',1,'Retail Sale Id 6797',9100.00,0.00,0.00,12.50,662.50,'2022-09-11 18:59:40','',''),(6814,'1','277','1',1,'Retail Sale Id 6798',4499.04,0.00,0.00,6.18,327.54,'2022-09-11 19:10:03','',''),(6815,'1','277','1',1,'Retail Sale Id 6799',2002.00,0.00,0.00,2.75,145.75,'2022-09-11 19:12:14','',''),(6816,'1','277','1',1,'Retail Sale Id 6800',2198.56,0.00,0.00,3.02,160.06,'2022-09-11 19:13:17','',''),(6817,'1','277','1',1,'Retail Sale Id 6801',997.36,0.00,0.00,1.37,72.61,'2022-09-11 19:21:58','',''),(6818,'1','277','1',1,'Retail Sale Id 6802',3996.72,0.00,0.00,5.49,290.97,'2022-09-11 19:22:52','',''),(6819,'1','277','1',1,'Retail Sale Id 6803',10519.60,0.00,0.00,14.45,765.85,'2022-09-11 19:31:02','',''),(6820,'1','277','1',1,'Retail Sale Id 6804',11553.36,0.00,0.00,15.87,841.11,'2022-09-11 19:33:53','',''),(6821,'1','277','1',1,'Retail Sale Id 6805',29229.20,0.00,0.00,40.15,2127.95,'2022-09-11 19:35:17','',''),(6822,'1','277','1',1,'Retail Sale Id 6806',400.40,0.00,0.00,0.55,29.15,'2022-09-11 19:37:54','',''),(6823,'1','277','1',1,'Retail Sale Id 6807',990.08,0.00,0.00,1.36,72.08,'2022-09-11 20:39:34','',''),(6824,'1','277','1',1,'Retail Sale Id 6808',3996.72,0.00,0.00,5.49,290.97,'2022-09-12 06:26:39','',''),(6825,'1','277','1',1,'Retail Sale Id 6809',1499.68,0.00,0.00,2.06,109.18,'2022-09-12 06:28:08','',''),(6826,'1','277','1',1,'Retail Sale Id 6810',1499.68,0.00,0.00,2.06,109.18,'2022-09-12 07:05:38','',''),(6827,'1','277','1',1,'Retail Sale Id 6811',2198.56,0.00,0.00,3.02,160.06,'2022-09-12 07:08:25','',''),(6828,'1','277','1',1,'Retail Sale Id 6812',2999.36,0.00,0.00,4.12,218.36,'2022-09-12 07:16:45','',''),(6829,'1','277','1',1,'Retail Sale Id 6813',2999.36,0.00,0.00,4.12,218.36,'2022-09-12 07:20:50','',''),(6830,'1','277','1',1,'Retail Sale Id 6814',2999.36,0.00,0.00,4.12,218.36,'2022-09-12 07:22:13','',''),(6831,'1','277','1',1,'Retail Sale Id 6815',1499.68,0.00,0.00,2.06,109.18,'2022-09-12 07:33:00','',''),(6832,'1','277','1',1,'Retail Sale Id 6816',5001.36,0.00,0.00,6.87,364.11,'2022-09-12 07:33:59','',''),(6833,'1','277','1',1,'Retail Sale Id 6817',997.36,0.00,0.00,1.37,72.61,'2022-09-12 07:37:38','',''),(6834,'1','277','1',1,'Retail Sale Id 6818',9100.00,0.00,0.00,12.50,662.50,'2022-09-12 07:41:29','',''),(6835,'1','277','1',1,'Retail Sale Id 6819',9100.00,0.00,0.00,12.50,662.50,'2022-09-12 07:49:42','',''),(6836,'1','277','1',1,'Retail Sale Id 6820',1499.68,0.00,0.00,2.06,109.18,'2022-09-12 07:52:02','',''),(6837,'1','277','1',1,'Retail Sale Id 6820',2999.36,0.00,0.00,4.12,218.36,'2022-09-12 07:52:02','',''),(6838,'1','277','1',1,'Retail Sale Id 6821',3698.24,0.00,0.00,5.08,269.24,'2022-09-12 07:58:32','',''),(6839,'1','277','1',1,'Retail Sale Id 6822',4397.12,0.00,0.00,6.04,320.12,'2022-09-12 07:59:51','',''),(6840,'1','277','1',1,'Retail Sale Id 6823',9100.00,0.00,0.00,12.50,662.50,'2022-09-12 08:15:28','',''),(6841,'1','277','1',1,'Retail Sale Id 6824',997.36,0.00,0.00,1.37,72.61,'2022-09-12 08:22:58','',''),(6842,'1','277','1',1,'Retail Sale Id 6825',4397.12,0.00,0.00,6.04,320.12,'2022-09-12 08:25:45','',''),(6843,'1','277','1',1,'Retail Sale Id 6826',1499.68,0.00,0.00,2.06,109.18,'2022-09-12 08:29:34','',''),(6844,'1','277','1',1,'Retail Sale Id 6827',2198.56,0.00,0.00,3.02,160.06,'2022-09-12 08:38:22','',''),(6845,'1','277','1',1,'Retail Sale Id 6828',4397.12,0.00,0.00,6.04,320.12,'2022-09-12 08:41:03','',''),(6846,'1','277','1',1,'Retail Sale Id 6828',9100.00,0.00,0.00,12.50,662.50,'2022-09-12 08:41:03','',''),(6847,'1','277','1',1,'Retail Sale Id 6829',2999.36,0.00,0.00,4.12,218.36,'2022-09-12 08:41:54','',''),(6848,'1','277','1',1,'Retail Sale Id 6830',1601.60,0.00,0.00,2.20,116.60,'2022-09-12 09:00:44','',''),(6849,'1','277','1',1,'Retail Sale Id 6831',2002.00,0.00,0.00,2.75,145.75,'2022-09-12 09:01:42','',''),(6850,'1','277','1',1,'Retail Sale Id 6832',13002.08,0.00,0.00,17.86,946.58,'2022-09-12 09:10:44','',''),(6851,'1','277','1',1,'Retail Sale Id 6833',2999.36,0.00,0.00,4.12,218.36,'2022-09-12 09:15:55','',''),(6852,'1','277','1',1,'Retail Sale Id 6834',1499.68,0.00,0.00,2.06,109.18,'2022-09-12 09:18:15','',''),(6853,'1','277','1',1,'Retail Sale Id 6835',2198.56,0.00,0.00,3.02,160.06,'2022-09-12 09:20:06','',''),(6854,'1','277','1',1,'Retail Sale Id 6836',4397.12,0.00,0.00,6.04,320.12,'2022-09-12 09:26:25','',''),(6855,'1','277','1',1,'Retail Sale Id 6837',3996.72,0.00,0.00,5.49,290.97,'2022-09-12 09:27:14','',''),(6856,'1','277','1',1,'Retail Sale Id 6838',9100.00,0.00,0.00,12.50,662.50,'2022-09-12 09:39:06','',''),(6857,'1','277','1',1,'Retail Sale Id 6839',5103.28,0.00,0.00,7.01,371.53,'2022-09-12 09:40:23','',''),(6858,'1','277','1',1,'Retail Sale Id 6840',4397.12,0.00,0.00,6.04,320.12,'2022-09-12 09:41:15','',''),(6859,'1','277','1',1,'Retail Sale Id 6841',997.36,0.00,0.00,1.37,72.61,'2022-09-12 09:41:56','',''),(6860,'1','277','1',1,'Retail Sale Id 6842',5998.72,0.00,0.00,8.24,436.72,'2022-09-12 09:46:35','',''),(6861,'1','277','1',1,'Retail Sale Id 6842',5998.72,0.00,0.00,8.24,436.72,'2022-09-12 09:46:35','',''),(6862,'1','277','1',1,'Retail Sale Id 6843',2198.56,0.00,0.00,3.02,160.06,'2022-09-12 09:54:13','',''),(6863,'1','277','1',1,'Retail Sale Id 6844',4397.12,0.00,0.00,6.04,320.12,'2022-09-12 09:55:45','',''),(6864,'1','277','1',1,'Retail Sale Id 6845',2198.56,0.00,0.00,3.02,160.06,'2022-09-12 09:58:09','',''),(6865,'1','277','1',1,'Retail Sale Id 6846',1499.68,0.00,0.00,2.06,109.18,'2022-09-12 10:04:37','',''),(6866,'1','277','1',1,'Retail Sale Id 6847',3698.24,0.00,0.00,5.08,269.24,'2022-09-12 10:07:48','',''),(6867,'1','277','1',1,'Retail Sale Id 6848',800.80,0.00,0.00,1.10,58.30,'2022-09-12 10:24:35','',''),(6868,'1','277','1',1,'Retail Sale Id 6849',2198.56,0.00,0.00,3.02,160.06,'2022-09-12 10:26:13','',''),(6869,'1','277','1',1,'Retail Sale Id 6850',2002.00,0.00,0.00,2.75,145.75,'2022-09-12 10:39:46','',''),(6870,'1','277','1',1,'Retail Sale Id 6851',1499.68,0.00,0.00,2.06,109.18,'2022-09-12 10:46:36','',''),(6871,'1','277','1',1,'Retail Sale Id 6852',997.36,0.00,0.00,1.37,72.61,'2022-09-12 10:47:18','',''),(6872,'1','277','1',1,'Retail Sale Id 6853',2002.00,0.00,0.00,2.75,145.75,'2022-09-12 10:48:09','',''),(6873,'1','277','1',1,'Retail Sale Id 6854',902.72,0.00,0.00,1.24,65.72,'2022-09-12 10:50:00','',''),(6874,'1','277','1',1,'Retail Sale Id 6855',4368.00,0.00,0.00,6.00,318.00,'2022-09-12 11:02:48','',''),(6875,'1','277','1',1,'Retail Sale Id 6856',4397.12,0.00,0.00,6.04,320.12,'2022-09-12 11:03:53','',''),(6876,'1','277','1',1,'Retail Sale Id 6857',902.72,0.00,0.00,1.24,65.72,'2022-09-12 11:10:09','',''),(6877,'1','277','1',1,'Retail Sale Id 6858',997.36,0.00,0.00,1.37,72.61,'2022-09-12 11:14:12','',''),(6878,'1','277','1',1,'Retail Sale Id 6859',502.32,0.00,0.00,0.69,36.57,'2022-09-12 11:21:17','',''),(6879,'1','277','1',1,'Retail Sale Id 6860',4397.12,0.00,0.00,6.04,320.12,'2022-09-12 11:22:57','',''),(6880,'1','277','1',1,'Retail Sale Id 6861',3698.24,0.00,0.00,5.08,269.24,'2022-09-12 11:25:30','',''),(6881,'1','277','1',1,'Retail Sale Id 6862',4397.12,0.00,0.00,6.04,320.12,'2022-09-12 11:35:23','',''),(6882,'1','277','1',1,'Retail Sale Id 6863',1798.16,0.00,0.00,2.47,130.91,'2022-09-12 11:36:20','',''),(6883,'1','277','1',1,'Retail Sale Id 6864',1499.68,0.00,0.00,2.06,109.18,'2022-09-12 11:46:32','',''),(6884,'1','277','1',1,'Retail Sale Id 6865',1499.68,0.00,0.00,2.06,109.18,'2022-09-12 11:50:37','',''),(6885,'1','277','1',1,'Retail Sale Id 6866',2002.00,0.00,0.00,2.75,145.75,'2022-09-12 11:52:48','',''),(6886,'1','277','1',1,'Retail Sale Id 6867',3501.68,0.00,0.00,4.81,254.93,'2022-09-12 11:59:37','',''),(6887,'1','277','1',1,'Retail Sale Id 6868',2999.36,0.00,0.00,4.12,218.36,'2022-09-12 12:14:17','',''),(6888,'1','277','1',1,'Retail Sale Id 6869',1499.68,0.00,0.00,2.06,109.18,'2022-09-12 12:15:00','',''),(6889,'1','277','1',1,'Retail Sale Id 6870',9100.00,0.00,0.00,12.50,662.50,'2022-09-12 12:20:51','',''),(6890,'1','277','1',1,'Retail Sale Id 6871',2999.36,0.00,0.00,4.12,218.36,'2022-09-12 12:21:35','',''),(6891,'1','277','1',1,'Retail Sale Id 6872',2999.36,0.00,0.00,4.12,218.36,'2022-09-12 12:25:28','',''),(6892,'1','277','1',1,'Retail Sale Id 6873',2497.04,0.00,0.00,3.43,181.79,'2022-09-12 12:39:51','',''),(6893,'1','277','1',1,'Retail Sale Id 6874',4499.04,0.00,0.00,6.18,327.54,'2022-09-12 12:53:26','',''),(6894,'1','277','1',1,'Retail Sale Id 6875',9100.00,0.00,0.00,12.50,662.50,'2022-09-12 12:59:55','',''),(6895,'1','277','1',1,'Retail Sale Id 6876',9100.00,0.00,0.00,12.50,662.50,'2022-09-12 13:13:00','',''),(6896,'1','277','1',1,'Retail Sale Id 6877',4499.04,0.00,0.00,6.18,327.54,'2022-09-12 13:24:28','',''),(6897,'1','277','1',1,'Retail Sale Id 6878',4397.12,0.00,0.00,6.04,320.12,'2022-09-12 13:34:14','',''),(6898,'1','277','1',1,'Retail Sale Id 6879',2002.00,0.00,0.00,2.75,145.75,'2022-09-12 13:36:01','',''),(6899,'1','277','1',1,'Retail Sale Id 6880',4499.04,0.00,0.00,6.18,327.54,'2022-09-12 13:43:53','',''),(6900,'1','277','1',1,'Retail Sale Id 6881',997.36,0.00,0.00,1.37,72.61,'2022-09-12 13:46:05','',''),(6901,'1','277','1',1,'Retail Sale Id 6882',3647.28,0.00,0.00,5.01,265.53,'2022-09-12 13:54:12','',''),(6902,'1','277','1',1,'Retail Sale Id 6883',3640.00,0.00,0.00,5.00,265.00,'2022-09-12 13:56:31','',''),(6903,'1','277','1',1,'Retail Sale Id 6884',2002.00,0.00,0.00,2.75,145.75,'2022-09-12 14:02:07','',''),(6904,'1','277','1',1,'Retail Sale Id 6885',2198.56,0.00,0.00,3.02,160.06,'2022-09-12 14:07:20','',''),(6905,'1','277','1',1,'Retail Sale Id 6886',2802.80,0.00,0.00,3.85,204.05,'2022-09-12 14:08:26','',''),(6906,'1','277','1',1,'Retail Sale Id 6887',997.36,0.00,0.00,1.37,72.61,'2022-09-12 14:09:30','',''),(6907,'1','277','1',1,'Retail Sale Id 6888',2002.00,0.00,0.00,2.75,145.75,'2022-09-12 14:13:43','',''),(6908,'1','277','1',1,'Retail Sale Id 6889',3698.24,0.00,0.00,5.08,269.24,'2022-09-12 14:15:28','',''),(6909,'1','277','1',1,'Retail Sale Id 6890',9100.00,0.00,0.00,12.50,662.50,'2022-09-12 14:24:51','',''),(6910,'1','277','1',1,'Retail Sale Id 6891',1499.68,0.00,0.00,2.06,109.18,'2022-09-12 14:27:14','',''),(6911,'1','277','1',1,'Retail Sale Id 6892',9100.00,0.00,0.00,12.50,662.50,'2022-09-12 14:28:41','',''),(6912,'1','277','1',1,'Retail Sale Id 6893',997.36,0.00,0.00,1.37,72.61,'2022-09-12 14:31:34','',''),(6913,'1','277','1',1,'Retail Sale Id 6894',8000.72,0.00,0.00,10.99,582.47,'2022-09-12 14:32:40','',''),(6914,'1','277','1',1,'Retail Sale Id 6895',9100.00,0.00,0.00,12.50,662.50,'2022-09-12 14:34:03','',''),(6915,'1','277','1',1,'Retail Sale Id 6896',800.80,0.00,0.00,1.10,58.30,'2022-09-12 14:39:53','',''),(6916,'1','277','1',1,'Retail Sale Id 6897',7003.36,0.00,0.00,9.62,509.86,'2022-09-12 14:44:25','',''),(6917,'1','277','1',1,'Retail Sale Id 6898',7280.00,0.00,0.00,10.00,530.00,'2022-09-12 14:50:59','',''),(6918,'1','277','1',1,'Return of Retail Sale Id 6897',0.00,7003.36,9.62,0.00,-509.86,'2022-09-12 14:58:33','',''),(6919,'1','277','1',1,'Retail Sale Id 6899',2002.00,0.00,0.00,2.75,145.75,'2022-09-12 15:04:11','',''),(6920,'1','277','1',1,'Retail Sale Id 6900',2999.36,0.00,0.00,4.12,218.36,'2022-09-12 15:05:09','',''),(6921,'1','277','1',1,'Retail Sale Id 6901',2999.36,0.00,0.00,4.12,218.36,'2022-09-12 15:06:30','',''),(6922,'1','277',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,675.00,1.00,0.00,0.00,'2022-09-12 16:00:46','',''),(6923,'1','277',NULL,1,'Reception corrector for bridging 24',0.00,0.00,0.00,1.00,0.00,'2022-09-12 16:02:54','',''),(6924,'1','277','1',1,'Received from bridging 24',0.00,0.00,1.00,0.00,0.00,'2022-09-12 16:02:54','',''),(6925,'1','277','1',1,'Retail Sale Id 6902',1354.08,0.00,0.00,1.86,98.58,'2022-09-12 16:04:35','',''),(6926,'1','277',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,1350000.00,2000.00,0.00,0.00,'2022-09-13 14:54:22','',''),(6927,'1','277',NULL,1,'Reception corrector for bridging 25',0.00,0.00,0.00,2000.00,0.00,'2022-09-13 14:56:53','',''),(6928,'1','277','1',1,'Received from bridging 25',0.00,0.00,2000.00,0.00,0.00,'2022-09-13 14:56:53','',''),(6929,'1','277','1',1,'Retail Sale Id 6903',1499.68,0.00,0.00,2.06,109.18,'2022-09-13 15:20:06','',''),(6930,'1','277','1',1,'Retail Sale Id 6904',3501.68,0.00,0.00,4.81,254.93,'2022-09-13 15:21:06','',''),(6931,'1','277','1',1,'Retail Sale Id 6905',2002.00,0.00,0.00,2.75,145.75,'2022-09-13 15:21:50','',''),(6932,'1','277','1',1,'Retail Sale Id 6906',2999.36,0.00,0.00,4.12,218.36,'2022-09-13 15:22:28','',''),(6933,'1','277','1',1,'Retail Sale Id 6907',2198.56,0.00,0.00,3.02,160.06,'2022-09-13 15:23:55','',''),(6934,'1','277','1',1,'Retail Sale Id 6908',1798.16,0.00,0.00,2.47,130.91,'2022-09-13 15:24:28','',''),(6935,'1','277','1',1,'Retail Sale Id 6909',5001.36,0.00,0.00,6.87,364.11,'2022-09-13 15:25:02','',''),(6936,'1','277','1',1,'Retail Sale Id 6910',2497.04,0.00,0.00,3.43,181.79,'2022-09-13 15:25:36','',''),(6937,'1','277','1',1,'Retail Sale Id 6911',1499.68,0.00,0.00,2.06,109.18,'2022-09-13 15:26:15','',''),(6938,'1','277','1',1,'Retail Sale Id 6912',997.36,0.00,0.00,1.37,72.61,'2022-09-13 15:27:24','',''),(6939,'1','277','1',1,'Retail Sale Id 6913',2999.36,0.00,0.00,4.12,218.36,'2022-09-13 15:29:01','',''),(6940,'1','277','1',1,'Retail Sale Id 6914',30000.88,0.00,0.00,41.21,2184.13,'2022-09-13 15:30:55','',''),(6941,'1','277','1',1,'Retail Sale Id 6915',4397.12,0.00,0.00,6.04,320.12,'2022-09-13 15:34:49','',''),(6942,'1','277','1',1,'Retail Sale Id 6916',3698.24,0.00,0.00,5.08,269.24,'2022-09-13 15:38:28','',''),(6943,'1','277','1',1,'Retail Sale Id 6917',2999.36,0.00,0.00,4.12,218.36,'2022-09-13 15:39:43','',''),(6944,'1','277','1',1,'Retail Sale Id 6918',2198.56,0.00,0.00,3.02,160.06,'2022-09-13 15:47:32','',''),(6945,'1','277','1',1,'Retail Sale Id 6919',1499.68,0.00,0.00,2.06,109.18,'2022-09-13 15:48:56','',''),(6946,'1','277','1',1,'Retail Sale Id 6920',1499.68,0.00,0.00,2.06,109.18,'2022-09-13 15:53:04','',''),(6947,'1','277','1',1,'Retail Sale Id 6921',3996.72,0.00,0.00,5.49,290.97,'2022-09-13 16:00:09','',''),(6948,'1','277','1',1,'Retail Sale Id 6922',2198.56,0.00,0.00,3.02,160.06,'2022-09-13 16:05:29','',''),(6949,'1','277','1',1,'Retail Sale Id 6923',2198.56,0.00,0.00,3.02,160.06,'2022-09-13 16:10:22','',''),(6950,'1','277','1',1,'Retail Sale Id 6924',2497.04,0.00,0.00,3.43,181.79,'2022-09-13 16:11:47','',''),(6951,'1','277','1',1,'Retail Sale Id 6925',4397.12,0.00,0.00,6.04,320.12,'2022-09-13 16:14:49','',''),(6952,'1','277','1',1,'Retail Sale Id 6926',4397.12,0.00,0.00,6.04,320.12,'2022-09-13 16:16:12','',''),(6953,'1','277','1',1,'Retail Sale Id 6927',9100.00,0.00,0.00,12.50,662.50,'2022-09-13 16:19:40','',''),(6954,'1','277','1',1,'Retail Sale Id 6928',902.72,0.00,0.00,1.24,65.72,'2022-09-13 16:20:54','',''),(6955,'1','277','1',1,'Retail Sale Id 6929',9100.00,0.00,0.00,12.50,662.50,'2022-09-13 16:23:09','',''),(6956,'1','277','1',1,'Retail Sale Id 6930',3996.72,0.00,0.00,5.49,290.97,'2022-09-13 16:29:58','',''),(6957,'1','277','1',1,'Retail Sale Id 6931',2002.00,0.00,0.00,2.75,145.75,'2022-09-13 16:30:35','',''),(6958,'1','277','1',1,'Retail Sale Id 6932',3996.72,0.00,0.00,5.49,290.97,'2022-09-13 16:31:03','',''),(6959,'1','277','1',1,'Retail Sale Id 6933',4499.04,0.00,0.00,6.18,327.54,'2022-09-13 16:33:19','',''),(6960,'1','277','1',1,'Retail Sale Id 6934',3640.00,0.00,0.00,5.00,265.00,'2022-09-13 16:34:16','',''),(6961,'1','277','1',1,'Retail Sale Id 6935',4397.12,0.00,0.00,6.04,320.12,'2022-09-13 16:34:44','',''),(6962,'1','277','1',1,'Retail Sale Id 6936',2002.00,0.00,0.00,2.75,145.75,'2022-09-13 16:40:02','',''),(6963,'1','277','1',1,'Retail Sale Id 6938',997.36,0.00,0.00,1.37,72.61,'2022-09-13 16:42:52','',''),(6964,'1','277','1',1,'Retail Sale Id 6939',2198.56,0.00,0.00,3.02,160.06,'2022-09-13 16:44:45','',''),(6965,'1','277','1',1,'Retail Sale Id 6940',1499.68,0.00,0.00,2.06,109.18,'2022-09-13 16:45:35','',''),(6966,'1','277','1',1,'Retail Sale Id 6941',9100.00,0.00,0.00,12.50,662.50,'2022-09-13 16:47:09','',''),(6967,'1','277','1',1,'Retail Sale Id 6942',1499.68,0.00,0.00,2.06,109.18,'2022-09-13 16:48:04','',''),(6968,'1','277','1',1,'Retail Sale Id 6943',2002.00,0.00,0.00,2.75,145.75,'2022-09-13 16:52:03','',''),(6969,'1','277','1',1,'Retail Sale Id 6944',7280.00,0.00,0.00,10.00,530.00,'2022-09-13 16:55:35','',''),(6970,'1','277','1',1,'Retail Sale Id 6945',2002.00,0.00,0.00,2.75,145.75,'2022-09-13 16:56:21','',''),(6971,'1','277','1',1,'Retail Sale Id 6946',3647.28,0.00,0.00,5.01,265.53,'2022-09-13 16:57:37','',''),(6972,'1','277','1',1,'Retail Sale Id 6947',18200.00,0.00,0.00,25.00,1325.00,'2022-09-13 17:05:41','',''),(6973,'1','277','1',1,'Retail Sale Id 6948',2002.00,0.00,0.00,2.75,145.75,'2022-09-13 17:08:21','',''),(6974,'1','277','1',1,'Retail Sale Id 6949',2002.00,0.00,0.00,2.75,145.75,'2022-09-13 17:09:21','',''),(6975,'1','277','1',1,'Retail Sale Id 6950',2999.36,0.00,0.00,4.12,218.36,'2022-09-13 17:10:16','',''),(6976,'1','277','1',1,'Retail Sale Id 6951',3996.72,0.00,0.00,5.49,290.97,'2022-09-13 17:11:00','',''),(6977,'1','277','1',1,'Retail Sale Id 6952',2198.56,0.00,0.00,3.02,160.06,'2022-09-13 17:11:41','',''),(6978,'1','277','1',1,'Retail Sale Id 6953',997.36,0.00,0.00,1.37,72.61,'2022-09-13 17:16:41','',''),(6979,'1','277','1',1,'Retail Sale Id 6954',2002.00,0.00,0.00,2.75,145.75,'2022-09-13 17:17:27','',''),(6980,'1','277','1',1,'Retail Sale Id 6955',2919.28,0.00,0.00,4.01,212.53,'2022-09-13 17:22:23','',''),(6981,'1','277','1',1,'Retail Sale Id 6956',2198.56,0.00,0.00,3.02,160.06,'2022-09-13 17:25:49','',''),(6982,'1','277','1',1,'Retail Sale Id 6957',7280.00,0.00,0.00,10.00,530.00,'2022-09-13 17:33:01','',''),(6983,'1','277','1',1,'Retail Sale Id 6958',1499.68,0.00,0.00,2.06,109.18,'2022-09-13 17:40:05','',''),(6984,'1','277','1',1,'Retail Sale Id 6959',2497.04,0.00,0.00,3.43,181.79,'2022-09-13 17:41:20','',''),(6985,'1','277','1',1,'Retail Sale Id 6960',2497.04,0.00,0.00,3.43,181.79,'2022-09-13 17:42:23','',''),(6986,'1','277','1',1,'Retail Sale Id 6961',2002.00,0.00,0.00,2.75,145.75,'2022-09-13 17:43:20','',''),(6987,'1','277','1',1,'Retail Sale Id 6962',3698.24,0.00,0.00,5.08,269.24,'2022-09-13 17:44:10','',''),(6988,'1','277','1',1,'Retail Sale Id 6963',2999.36,0.00,0.00,4.12,218.36,'2022-09-13 17:44:57','',''),(6989,'1','277','1',1,'Retail Sale Id 6964',800.80,0.00,0.00,1.10,58.30,'2022-09-13 17:50:23','',''),(6990,'1','277','1',1,'Retail Sale Id 6965',9100.00,0.00,0.00,12.50,662.50,'2022-09-13 17:52:41','',''),(6991,'1','277','1',1,'Retail Sale Id 6966',1499.68,0.00,0.00,2.06,109.18,'2022-09-13 17:53:51','',''),(6992,'1','277','1',1,'Retail Sale Id 6968',2999.36,0.00,0.00,4.12,218.36,'2022-09-13 17:56:11','',''),(6993,'1','277','1',1,'Retail Sale Id 6969',2198.56,0.00,0.00,3.02,160.06,'2022-09-13 17:57:14','',''),(6994,'1','277','1',1,'Retail Sale Id 6970',2198.56,0.00,0.00,3.02,160.06,'2022-09-13 17:58:05','',''),(6995,'1','277','1',1,'Retail Sale Id 6971',1499.68,0.00,0.00,2.06,109.18,'2022-09-13 17:58:58','',''),(6996,'1','277','1',1,'Retail Sale Id 6972',2198.56,0.00,0.00,3.02,160.06,'2022-09-13 18:00:01','',''),(6997,'1','277','1',1,'Retail Sale Id 6973',749.84,0.00,0.00,1.03,54.59,'2022-09-13 18:02:24','',''),(6998,'1','277','1',1,'Retail Sale Id 6974',3647.28,0.00,0.00,5.01,265.53,'2022-09-13 18:05:27','',''),(6999,'1','277','1',1,'Retail Sale Id 6975',2002.00,0.00,0.00,2.75,145.75,'2022-09-13 18:06:16','',''),(7000,'1','277','1',1,'Retail Sale Id 6976',8998.08,0.00,0.00,12.36,655.08,'2022-09-13 18:08:18','',''),(7001,'1','277','1',1,'Retail Sale Id 6977',3996.72,0.00,0.00,5.49,290.97,'2022-09-13 18:09:01','',''),(7002,'1','277','1',1,'Retail Sale Id 6978',4397.12,0.00,0.00,6.04,320.12,'2022-09-13 18:11:22','',''),(7003,'1','277','1',1,'Retail Sale Id 6979',7003.36,0.00,0.00,9.62,509.86,'2022-09-13 18:13:18','',''),(7004,'1','277','1',1,'Retail Sale Id 6980',9100.00,0.00,0.00,12.50,662.50,'2022-09-13 18:14:13','',''),(7005,'1','277','1',1,'Retail Sale Id 6981',2300.48,0.00,0.00,3.16,167.48,'2022-09-13 18:15:34','',''),(7006,'1','277','1',1,'Retail Sale Id 6982',2999.36,0.00,0.00,4.12,218.36,'2022-09-13 18:16:29','',''),(7007,'1','277','1',1,'Retail Sale Id 6983',997.36,0.00,0.00,1.37,72.61,'2022-09-13 18:17:11','',''),(7008,'1','277','1',1,'Retail Sale Id 6984',4499.04,0.00,0.00,6.18,327.54,'2022-09-13 18:17:51','',''),(7009,'1','277','1',1,'Retail Sale Id 6985',4397.12,0.00,0.00,6.04,320.12,'2022-09-13 18:18:57','',''),(7010,'1','277','1',1,'Retail Sale Id 6986',997.36,0.00,0.00,1.37,72.61,'2022-09-13 18:19:40','',''),(7011,'1','277','1',1,'Retail Sale Id 6987',1499.68,0.00,0.00,2.06,109.18,'2022-09-13 18:20:18','',''),(7012,'1','277','1',1,'Retail Sale Id 6988',2999.36,0.00,0.00,4.12,218.36,'2022-09-13 18:23:03','',''),(7013,'1','277','1',1,'Retail Sale Id 6989',2002.00,0.00,0.00,2.75,145.75,'2022-09-13 18:25:32','',''),(7014,'1','277','1',1,'Retail Sale Id 6990',298.48,0.00,0.00,0.41,21.73,'2022-09-13 18:28:06','',''),(7015,'1','277','1',1,'Retail Sale Id 6991',3647.28,0.00,0.00,5.01,265.53,'2022-09-13 18:29:19','',''),(7016,'1','277','1',1,'Retail Sale Id 6992',800.80,0.00,0.00,1.10,58.30,'2022-09-13 18:30:15','',''),(7017,'1','277','1',1,'Retail Sale Id 6993',2497.04,0.00,0.00,3.43,181.79,'2022-09-13 18:31:10','',''),(7018,'1','277','1',1,'Retail Sale Id 6994',4397.12,0.00,0.00,6.04,320.12,'2022-09-13 18:32:12','',''),(7019,'1','277','1',1,'Retail Sale Id 6995',698.88,0.00,0.00,0.96,50.88,'2022-09-13 18:36:09','',''),(7020,'1','277','1',1,'Retail Sale Id 6996',1470.56,0.00,0.00,2.02,107.06,'2022-09-13 18:39:05','',''),(7021,'1','277','1',1,'Retail Sale Id 6997',2497.04,0.00,0.00,3.43,181.79,'2022-09-13 18:40:05','',''),(7022,'1','277','1',1,'Retail Sale Id 6998',3996.72,0.00,0.00,5.49,290.97,'2022-09-13 18:41:11','',''),(7023,'1','277','1',1,'Retail Sale Id 6999',2198.56,0.00,0.00,3.02,160.06,'2022-09-13 18:42:52','',''),(7024,'1','277','1',1,'Retail Sale Id 7000',2198.56,0.00,0.00,3.02,160.06,'2022-09-13 18:44:11','',''),(7025,'1','277','1',1,'Retail Sale Id 7001',2002.00,0.00,0.00,2.75,145.75,'2022-09-13 18:45:31','',''),(7026,'1','277','1',1,'Retail Sale Id 7002',4397.12,0.00,0.00,6.04,320.12,'2022-09-13 18:51:04','',''),(7027,'1','277','1',1,'Retail Sale Id 7003',1201.20,0.00,0.00,1.65,87.45,'2022-09-13 18:54:45','',''),(7028,'1','277','1',1,'Retail Sale Id 7004',698.88,0.00,0.00,0.96,50.88,'2022-09-13 18:57:52','',''),(7029,'1','277','1',1,'Retail Sale Id 7005',1499.68,0.00,0.00,2.06,109.18,'2022-09-13 19:05:31','',''),(7030,'1','277','1',1,'Retail Sale Id 7006',8998.08,0.00,0.00,12.36,655.08,'2022-09-13 19:14:54','',''),(7031,'1','277','1',1,'Retail Sale Id 7007',4302.48,0.00,0.00,5.91,313.23,'2022-09-13 19:17:46','',''),(7032,'1','277','1',1,'Retail Sale Id 7008',502.32,0.00,0.00,0.69,36.57,'2022-09-13 19:18:33','',''),(7033,'1','277','1',1,'Retail Sale Id 7009',9100.00,0.00,0.00,12.50,662.50,'2022-09-13 19:24:01','',''),(7034,'1','277','1',1,'Retail Sale Id 7010',502.32,0.00,0.00,0.69,36.57,'2022-09-13 19:25:29','',''),(7035,'1','277','1',1,'Return of Retail Sale Id 7010',0.00,502.32,0.69,0.00,-36.57,'2022-09-13 19:39:39','',''),(7036,'1','277','1',1,'Retail Sale Id 7011',495.04,0.00,0.00,0.68,36.04,'2022-09-13 19:40:52','',''),(7037,'1','277',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,2369250.00,3510.00,0.00,0.00,'2022-09-13 20:09:46','',''),(7038,'1','277',NULL,1,'Reception corrector for bridging 26',0.00,0.00,0.00,3510.00,0.00,'2022-09-13 20:11:34','',''),(7039,'1','277','1',1,'Received from bridging 26',0.00,0.00,3510.00,0.00,0.00,'2022-09-13 20:11:34','',''),(7040,'1','277','1',1,'Retail Sale Id 7012',2002.00,0.00,0.00,2.75,145.75,'2022-09-14 06:29:28','',''),(7041,'1','277','1',1,'Retail Sale Id 7013',1499.68,0.00,0.00,2.06,109.18,'2022-09-14 06:43:59','',''),(7042,'1','277','1',1,'Retail Sale Id 7014',2497.04,0.00,0.00,3.43,181.79,'2022-09-14 06:48:58','',''),(7043,'1','277','1',1,'Retail Sale Id 7015',902.72,0.00,0.00,1.24,65.72,'2022-09-14 06:51:14','',''),(7044,'1','277','1',1,'Retail Sale Id 7016',1499.68,0.00,0.00,2.06,109.18,'2022-09-14 06:53:04','',''),(7045,'1','277','1',1,'Retail Sale Id 7017',2999.36,0.00,0.00,4.12,218.36,'2022-09-14 06:54:48','',''),(7046,'1','277','1',1,'Retail Sale Id 7018',2198.56,0.00,0.00,3.02,160.06,'2022-09-14 07:03:50','',''),(7047,'1','277','1',1,'Retail Sale Id 7019',749.84,0.00,0.00,1.03,54.59,'2022-09-14 07:19:14','',''),(7048,'1','277','1',1,'Retail Sale Id 7020',9100.00,0.00,0.00,12.50,662.50,'2022-09-14 07:41:08','',''),(7049,'1','277','1',1,'Retail Sale Id 7021',2999.36,0.00,0.00,4.12,218.36,'2022-09-14 07:59:57','',''),(7050,'1','277','1',1,'Retail Sale Id 7022',9100.00,0.00,0.00,12.50,662.50,'2022-09-14 08:01:40','',''),(7051,'1','277','1',1,'Retail Sale Id 7023',3640.00,0.00,0.00,5.00,265.00,'2022-09-14 08:08:53','',''),(7052,'1','277','1',1,'Retail Sale Id 7024',4397.12,0.00,0.00,6.04,320.12,'2022-09-14 08:16:28','',''),(7053,'1','277','1',1,'Retail Sale Id 7025',4397.12,0.00,0.00,6.04,320.12,'2022-09-14 08:36:33','',''),(7054,'1','277','1',1,'Retail Sale Id 7026',9100.00,0.00,0.00,12.50,662.50,'2022-09-14 08:43:18','',''),(7055,'1','277','1',1,'Retail Sale Id 7027',2002.00,0.00,0.00,2.75,145.75,'2022-09-14 08:44:32','',''),(7056,'1','277','1',1,'Retail Sale Id 7028',1499.68,0.00,0.00,2.06,109.18,'2022-09-14 08:45:46','',''),(7057,'1','277','1',1,'Retail Sale Id 7029',997.36,0.00,0.00,1.37,72.61,'2022-09-14 08:46:56','',''),(7058,'1','277','1',1,'Retail Sale Id 7030',2002.00,0.00,0.00,2.75,145.75,'2022-09-14 08:49:24','',''),(7059,'1','277','1',1,'Retail Sale Id 7031',2002.00,0.00,0.00,2.75,145.75,'2022-09-14 08:51:29','',''),(7060,'1','277','1',1,'Retail Sale Id 7032',4499.04,0.00,0.00,6.18,327.54,'2022-09-14 08:57:02','',''),(7061,'1','277','1',1,'Retail Sale Id 7033',4397.12,0.00,0.00,6.04,320.12,'2022-09-14 09:01:34','',''),(7062,'1','277','1',1,'Retail Sale Id 7034',2198.56,0.00,0.00,3.02,160.06,'2022-09-14 09:05:43','',''),(7063,'1','277','1',1,'Retail Sale Id 7035',2002.00,0.00,0.00,2.75,145.75,'2022-09-14 09:06:33','',''),(7064,'1','277','1',1,'Retail Sale Id 7036',2002.00,0.00,0.00,2.75,145.75,'2022-09-14 09:07:16','',''),(7065,'1','277','1',1,'Retail Sale Id 7037',2999.36,0.00,0.00,4.12,218.36,'2022-09-14 09:09:08','',''),(7066,'1','277','1',1,'Retail Sale Id 7038',502.32,0.00,0.00,0.69,36.57,'2022-09-14 09:11:55','',''),(7067,'1','277','1',1,'Retail Sale Id 7039',2198.56,0.00,0.00,3.02,160.06,'2022-09-14 09:14:56','',''),(7068,'1','277','1',1,'Retail Sale Id 7040',3640.00,0.00,0.00,5.00,265.00,'2022-09-14 09:18:11','',''),(7069,'1','277','1',1,'Retail Sale Id 7041',2999.36,0.00,0.00,4.12,218.36,'2022-09-14 09:28:31','',''),(7070,'1','277','1',1,'Retail Sale Id 7042',2002.00,0.00,0.00,2.75,145.75,'2022-09-14 09:30:44','',''),(7071,'1','277','1',1,'Retail Sale Id 7043',2999.36,0.00,0.00,4.12,218.36,'2022-09-14 09:43:52','',''),(7072,'1','277','1',1,'Retail Sale Id 7044',2999.36,0.00,0.00,4.12,218.36,'2022-09-14 10:05:01','',''),(7073,'1','277','1',1,'Retail Sale Id 7045',2002.00,0.00,0.00,2.75,145.75,'2022-09-14 10:06:00','',''),(7074,'1','277','1',1,'Retail Sale Id 7046',1499.68,0.00,0.00,2.06,109.18,'2022-09-14 10:20:55','',''),(7075,'1','277','1',1,'Retail Sale Id 7048',2999.36,0.00,0.00,4.12,218.36,'2022-09-14 10:22:18','',''),(7076,'1','277','1',1,'Retail Sale Id 7049',502.32,0.00,0.00,0.69,36.57,'2022-09-14 10:28:20','',''),(7077,'1','277','1',1,'Retail Sale Id 7050',2002.00,0.00,0.00,2.75,145.75,'2022-09-14 10:40:57','',''),(7078,'1','277','1',1,'Retail Sale Id 7051',749.84,0.00,0.00,1.03,54.59,'2022-09-14 10:42:16','',''),(7079,'1','277','1',1,'Retail Sale Id 7052',3603.60,0.00,0.00,4.95,262.35,'2022-09-14 10:55:26','',''),(7080,'1','277','1',1,'Retail Sale Id 7053',1499.68,0.00,0.00,2.06,109.18,'2022-09-14 10:59:18','',''),(7081,'1','277','1',1,'Retail Sale Id 7053',3647.28,0.00,0.00,5.01,265.53,'2022-09-14 10:59:18','',''),(7082,'1','277','1',1,'Retail Sale Id 7054',9100.00,0.00,0.00,12.50,662.50,'2022-09-14 11:00:10','',''),(7083,'1','277','1',1,'Retail Sale Id 7055',1703.52,0.00,0.00,2.34,124.02,'2022-09-14 11:03:35','',''),(7084,'1','277','1',1,'Retail Sale Id 7056',7280.00,0.00,0.00,10.00,530.00,'2022-09-14 11:15:05','',''),(7085,'1','277','1',1,'Retail Sale Id 7057',9100.00,0.00,0.00,12.50,662.50,'2022-09-14 11:19:45','',''),(7086,'1','277','1',1,'Retail Sale Id 7058',1499.68,0.00,0.00,2.06,109.18,'2022-09-14 11:22:02','',''),(7087,'1','277','1',1,'Retail Sale Id 7059',997.36,0.00,0.00,1.37,72.61,'2022-09-14 11:24:16','',''),(7088,'1','277','1',1,'Retail Sale Id 7060',9100.00,0.00,0.00,12.50,662.50,'2022-09-14 11:25:39','',''),(7089,'1','277','1',1,'Retail Sale Id 7061',997.36,0.00,0.00,1.37,72.61,'2022-09-14 11:29:38','',''),(7090,'1','277','1',1,'Retail Sale Id 7062',1499.68,0.00,0.00,2.06,109.18,'2022-09-14 11:40:24','',''),(7091,'1','277','1',1,'Retail Sale Id 7063',4397.12,0.00,0.00,6.04,320.12,'2022-09-14 11:41:54','',''),(7092,'1','277','1',1,'Retail Sale Id 7064',14742.00,0.00,0.00,20.25,1073.25,'2022-09-14 11:59:52','',''),(7093,'1','277','1',1,'Retail Sale Id 7065',24846.64,0.00,0.00,34.13,1808.89,'2022-09-14 12:01:40','',''),(7094,'1','277','1',1,'Retail Sale Id 7066',2002.00,0.00,0.00,2.75,145.75,'2022-09-14 12:05:07','',''),(7095,'1','277','1',1,'Retail Sale Id 7067',4397.12,0.00,0.00,6.04,320.12,'2022-09-14 12:08:55','',''),(7096,'1','277','1',1,'Retail Sale Id 7068',5001.36,0.00,0.00,6.87,364.11,'2022-09-14 12:12:48','',''),(7097,'1','277','1',1,'Retail Sale Id 7069',3996.72,0.00,0.00,5.49,290.97,'2022-09-14 12:13:31','',''),(7098,'1','277','1',1,'Retail Sale Id 7070',5001.36,0.00,0.00,6.87,364.11,'2022-09-14 12:15:16','',''),(7099,'1','277','1',1,'Retail Sale Id 7071',2198.56,0.00,0.00,3.02,160.06,'2022-09-14 12:20:14','',''),(7100,'1','277','1',1,'Retail Sale Id 7072',2198.56,0.00,0.00,3.02,160.06,'2022-09-14 12:25:09','',''),(7101,'1','277','1',1,'Retail Sale Id 7073',2002.00,0.00,0.00,2.75,145.75,'2022-09-14 12:34:09','',''),(7102,'1','277','1',1,'Retail Sale Id 7074',4397.12,0.00,0.00,6.04,320.12,'2022-09-14 12:50:12','',''),(7103,'1','277','1',1,'Retail Sale Id 7075',2999.36,0.00,0.00,4.12,218.36,'2022-09-14 12:53:30','',''),(7104,'1','277','1',1,'Retail Sale Id 7076',749.84,0.00,0.00,1.03,54.59,'2022-09-14 13:08:07','',''),(7105,'1','277','1',1,'Retail Sale Id 7077',2198.56,0.00,0.00,3.02,160.06,'2022-09-14 13:09:47','',''),(7106,'1','277','1',1,'Retail Sale Id 7078',997.36,0.00,0.00,1.37,72.61,'2022-09-14 13:44:13','',''),(7107,'1','277','1',1,'Retail Sale Id 7079',3640.00,0.00,0.00,5.00,265.00,'2022-09-14 13:58:31','',''),(7108,'1','277','1',1,'Retail Sale Id 7079',9100.00,0.00,0.00,12.50,662.50,'2022-09-14 13:58:31','',''),(7109,'1','277','1',1,'Retail Sale Id 7080',3698.24,0.00,0.00,5.08,269.24,'2022-09-14 14:00:59','',''),(7110,'1','277','1',1,'Retail Sale Id 7081',9100.00,0.00,0.00,12.50,662.50,'2022-09-14 14:02:34','',''),(7111,'1','277','1',1,'Retail Sale Id 7082',1499.68,0.00,0.00,2.06,109.18,'2022-09-14 14:31:03','',''),(7112,'1','277','1',1,'Retail Sale Id 7083',36400.00,0.00,0.00,50.00,2650.00,'2022-09-14 14:32:03','',''),(7113,'1','277','1',1,'Retail Sale Id 7084',2497.04,0.00,0.00,3.43,181.79,'2022-09-14 14:37:06','',''),(7114,'1','277','1',1,'Retail Sale Id 7085',1499.68,0.00,0.00,2.06,109.18,'2022-09-14 14:41:04','',''),(7115,'1','277','1',1,'Retail Sale Id 7086',4397.12,0.00,0.00,6.04,320.12,'2022-09-14 14:42:00','',''),(7116,'1','277','1',1,'Retail Sale Id 7087',800.80,0.00,0.00,1.10,58.30,'2022-09-14 14:43:04','',''),(7117,'1','277','1',1,'Retail Sale Id 7088',7003.36,0.00,0.00,9.62,509.86,'2022-09-14 14:45:07','',''),(7118,'1','277','1',1,'Retail Sale Id 7089',2999.36,0.00,0.00,4.12,218.36,'2022-09-14 14:49:21','',''),(7119,'1','277','1',1,'Retail Sale Id 7090',4397.12,0.00,0.00,6.04,320.12,'2022-09-14 14:54:46','',''),(7120,'1','277','1',1,'Retail Sale Id 7091',1201.20,0.00,0.00,1.65,87.45,'2022-09-14 15:14:57','',''),(7121,'1','277','1',1,'Retail Sale Id 7092',502.32,0.00,0.00,0.69,36.57,'2022-09-14 15:16:52','',''),(7122,'1','277','1',1,'Retail Sale Id 7093',4397.12,0.00,0.00,6.04,320.12,'2022-09-14 15:18:17','',''),(7123,'1','277','1',1,'Retail Sale Id 7094',3698.24,0.00,0.00,5.08,269.24,'2022-09-14 15:25:28','',''),(7124,'1','277','1',1,'Retail Sale Id 7095',4397.12,0.00,0.00,6.04,320.12,'2022-09-14 15:37:49','',''),(7125,'1','277','1',1,'Retail Sale Id 7096',3996.72,0.00,0.00,5.49,290.97,'2022-09-14 15:44:59','',''),(7126,'1','277','1',1,'Retail Sale Id 7097',9100.00,0.00,0.00,12.50,662.50,'2022-09-14 15:51:17','',''),(7127,'1','277','1',1,'Retail Sale Id 7098',18200.00,0.00,0.00,25.00,1325.00,'2022-09-14 15:53:51','',''),(7128,'1','277','1',1,'Retail Sale Id 7099',1499.68,0.00,0.00,2.06,109.18,'2022-09-14 15:54:53','',''),(7129,'1','277','1',1,'Retail Sale Id 7100',9100.00,0.00,0.00,12.50,662.50,'2022-09-14 16:02:57','',''),(7130,'1','277','1',1,'Retail Sale Id 7101',43680.00,0.00,0.00,60.00,3180.00,'2022-09-14 16:06:18','',''),(7131,'1','277','1',1,'Retail Sale Id 7102',2002.00,0.00,0.00,2.75,145.75,'2022-09-14 16:07:33','',''),(7132,'1','277','1',1,'Retail Sale Id 7103',1499.68,0.00,0.00,2.06,109.18,'2022-09-14 16:12:32','',''),(7133,'1','277','1',1,'Retail Sale Id 7104',2198.56,0.00,0.00,3.02,160.06,'2022-09-14 16:15:01','',''),(7134,'1','277','1',1,'Retail Sale Id 7105',2198.56,0.00,0.00,3.02,160.06,'2022-09-14 16:23:41','',''),(7135,'1','277','1',1,'Retail Sale Id 7106',4368.00,0.00,0.00,6.00,318.00,'2022-09-14 16:26:34','',''),(7136,'1','277','1',1,'Retail Sale Id 7107',29600.48,0.00,0.00,40.66,2154.98,'2022-09-14 16:32:28','',''),(7137,'1','277','1',1,'Retail Sale Id 7108',2198.56,0.00,0.00,3.02,160.06,'2022-09-14 16:33:15','',''),(7138,'1','277','1',1,'Retail Sale Id 7109',2999.36,0.00,0.00,4.12,218.36,'2022-09-14 16:35:16','',''),(7139,'1','277','1',1,'Retail Sale Id 7110',7301.84,0.00,0.00,10.03,531.59,'2022-09-14 16:37:05','',''),(7140,'1','277','1',1,'Retail Sale Id 7111',3996.72,0.00,0.00,5.49,290.97,'2022-09-14 16:43:38','',''),(7141,'1','277','1',1,'Retail Sale Id 7112',4397.12,0.00,0.00,6.04,320.12,'2022-09-14 16:45:45','',''),(7142,'1','277','1',1,'Retail Sale Id 7113',4397.12,0.00,0.00,6.04,320.12,'2022-09-14 16:46:47','',''),(7143,'1','277','1',1,'Retail Sale Id 7114',4499.04,0.00,0.00,6.18,327.54,'2022-09-14 16:51:17','',''),(7144,'1','277','1',1,'Retail Sale Id 7115',1499.68,0.00,0.00,2.06,109.18,'2022-09-14 16:53:16','',''),(7145,'1','277','1',1,'Retail Sale Id 7116',997.36,0.00,0.00,1.37,72.61,'2022-09-14 17:00:38','',''),(7146,'1','277','1',1,'Retail Sale Id 7117',2002.00,0.00,0.00,2.75,145.75,'2022-09-14 17:05:43','',''),(7147,'1','277','1',1,'Retail Sale Id 7118',2198.56,0.00,0.00,3.02,160.06,'2022-09-14 17:10:14','',''),(7148,'1','277','1',1,'Retail Sale Id 7119',3996.72,0.00,0.00,5.49,290.97,'2022-09-14 17:14:31','',''),(7149,'1','277','1',1,'Retail Sale Id 7120',4397.12,0.00,0.00,6.04,320.12,'2022-09-14 17:15:40','',''),(7150,'1','277','1',1,'Retail Sale Id 7121',9100.00,0.00,0.00,12.50,662.50,'2022-09-14 17:16:29','',''),(7151,'1','277','1',1,'Retail Sale Id 7122',4397.12,0.00,0.00,6.04,320.12,'2022-09-14 17:21:39','',''),(7152,'1','277','1',1,'Retail Sale Id 7123',4499.04,0.00,0.00,6.18,327.54,'2022-09-14 17:23:58','',''),(7153,'1','277','1',1,'Retail Sale Id 7124',1499.68,0.00,0.00,2.06,109.18,'2022-09-14 17:24:57','',''),(7154,'1','277','1',1,'Retail Sale Id 7125',1499.68,0.00,0.00,2.06,109.18,'2022-09-14 17:25:39','',''),(7155,'1','277','1',1,'Retail Sale Id 7126',2999.36,0.00,0.00,4.12,218.36,'2022-09-14 17:26:29','',''),(7156,'1','277','1',1,'Retail Sale Id 7127',2999.36,0.00,0.00,4.12,218.36,'2022-09-14 17:27:19','',''),(7157,'1','277','1',1,'Retail Sale Id 7128',997.36,0.00,0.00,1.37,72.61,'2022-09-14 17:29:44','',''),(7158,'1','277','1',1,'Retail Sale Id 7130',3996.72,0.00,0.00,5.49,290.97,'2022-09-14 17:32:33','',''),(7159,'1','277','1',1,'Retail Sale Id 7131',3996.72,0.00,0.00,5.49,290.97,'2022-09-14 17:33:58','',''),(7160,'1','277','1',1,'Retail Sale Id 7132',800.80,0.00,0.00,1.10,58.30,'2022-09-14 17:35:12','',''),(7161,'1','277','1',1,'Retail Sale Id 7133',2198.56,0.00,0.00,3.02,160.06,'2022-09-14 17:44:10','',''),(7162,'1','277','1',1,'Retail Sale Id 7134',4397.12,0.00,0.00,6.04,320.12,'2022-09-14 17:48:45','',''),(7163,'1','277','1',1,'Retail Sale Id 7135',2002.00,0.00,0.00,2.75,145.75,'2022-09-14 17:53:43','',''),(7164,'1','277','1',1,'Retail Sale Id 7136',1499.68,0.00,0.00,2.06,109.18,'2022-09-14 17:55:52','',''),(7165,'1','277','1',1,'Retail Sale Id 7137',2002.00,0.00,0.00,2.75,145.75,'2022-09-14 17:59:33','',''),(7166,'1','277','1',1,'Retail Sale Id 7138',2999.36,0.00,0.00,4.12,218.36,'2022-09-14 18:05:09','',''),(7167,'1','277','1',1,'Retail Sale Id 7139',2198.56,0.00,0.00,3.02,160.06,'2022-09-14 18:09:57','',''),(7168,'1','277','1',1,'Retail Sale Id 7140',2402.40,0.00,0.00,3.30,174.90,'2022-09-14 18:12:14','',''),(7169,'1','277','1',1,'Retail Sale Id 7141',3996.72,0.00,0.00,5.49,290.97,'2022-09-14 18:16:21','',''),(7170,'1','277','1',1,'Retail Sale Id 7142',9100.00,0.00,0.00,12.50,662.50,'2022-09-14 18:17:44','',''),(7171,'1','277','1',1,'Retail Sale Id 7143',2497.04,0.00,0.00,3.43,181.79,'2022-09-14 18:21:42','',''),(7172,'1','277','1',1,'Retail Sale Id 7144',2198.56,0.00,0.00,3.02,160.06,'2022-09-14 18:23:28','',''),(7173,'1','277','1',1,'Retail Sale Id 7145',1499.68,0.00,0.00,2.06,109.18,'2022-09-14 18:29:41','',''),(7174,'1','277','1',1,'Retail Sale Id 7146',1499.68,0.00,0.00,2.06,109.18,'2022-09-14 18:33:22','',''),(7175,'1','277','1',1,'Retail Sale Id 7147',2198.56,0.00,0.00,3.02,160.06,'2022-09-14 18:35:59','',''),(7176,'1','277','1',1,'Retail Sale Id 7147',9100.00,0.00,0.00,12.50,662.50,'2022-09-14 18:35:59','',''),(7177,'1','277','1',1,'Retail Sale Id 7148',2999.36,0.00,0.00,4.12,218.36,'2022-09-14 18:36:48','',''),(7178,'1','277','1',1,'Retail Sale Id 7149',3996.72,0.00,0.00,5.49,290.97,'2022-09-14 18:37:46','',''),(7179,'1','277','1',1,'Retail Sale Id 7150',3996.72,0.00,0.00,5.49,290.97,'2022-09-14 18:42:55','',''),(7180,'1','277','1',1,'Retail Sale Id 7151',2249.52,0.00,0.00,3.09,163.77,'2022-09-14 18:49:40','',''),(7181,'1','277','1',1,'Retail Sale Id 7152',800.80,0.00,0.00,1.10,58.30,'2022-09-14 18:51:01','',''),(7182,'1','277','1',1,'Retail Sale Id 7153',4397.12,0.00,0.00,6.04,320.12,'2022-09-14 18:52:05','',''),(7183,'1','277','1',1,'Retail Sale Id 7154',9100.00,0.00,0.00,12.50,662.50,'2022-09-14 18:53:58','',''),(7184,'1','277','1',1,'Retail Sale Id 7155',2198.56,0.00,0.00,3.02,160.06,'2022-09-14 18:56:07','',''),(7185,'1','277','1',1,'Retail Sale Id 7156',997.36,0.00,0.00,1.37,72.61,'2022-09-14 18:59:43','',''),(7186,'1','277','1',1,'Retail Sale Id 7157',3640.00,0.00,0.00,5.00,265.00,'2022-09-14 19:03:35','',''),(7187,'1','277','1',1,'Retail Sale Id 7157',3640.00,0.00,0.00,5.00,265.00,'2022-09-14 19:03:35','',''),(7188,'1','277','1',1,'Retail Sale Id 7158',2300.48,0.00,0.00,3.16,167.48,'2022-09-14 19:05:49','',''),(7189,'1','277','1',1,'Retail Sale Id 7159',2300.48,0.00,0.00,3.16,167.48,'2022-09-14 19:15:29','',''),(7190,'1','277','1',1,'Retail Sale Id 7160',356.72,0.00,0.00,0.49,25.97,'2022-09-14 19:41:53','',''),(7191,'1','277','1',1,'Retail Sale Id 7161',9100.00,0.00,0.00,12.50,662.50,'2022-09-15 06:22:19','',''),(7192,'1','277','1',1,'Retail Sale Id 7162',4397.12,0.00,0.00,6.04,320.12,'2022-09-15 06:23:55','',''),(7193,'1','277','1',1,'Retail Sale Id 7163',997.36,0.00,0.00,1.37,72.61,'2022-09-15 06:56:34','',''),(7194,'1','277','1',1,'Retail Sale Id 7164',2198.56,0.00,0.00,3.02,160.06,'2022-09-15 07:06:09','',''),(7195,'1','277','1',1,'Retail Sale Id 7165',997.36,0.00,0.00,1.37,72.61,'2022-09-15 07:08:38','',''),(7196,'1','277','1',1,'Retail Sale Id 7166',9100.00,0.00,0.00,12.50,662.50,'2022-09-15 07:17:59','',''),(7197,'1','277','1',1,'Retail Sale Id 7167',4397.12,0.00,0.00,6.04,320.12,'2022-09-15 07:33:25','',''),(7198,'1','277','1',1,'Retail Sale Id 7168',4397.12,0.00,0.00,6.04,320.12,'2022-09-15 07:37:28','',''),(7199,'1','277','1',1,'Retail Sale Id 7169',1397.76,0.00,0.00,1.92,101.76,'2022-09-15 07:41:50','',''),(7200,'1','277','1',1,'Retail Sale Id 7170',9100.00,0.00,0.00,12.50,662.50,'2022-09-15 07:50:52','',''),(7201,'1','277','1',1,'Retail Sale Id 7171',9100.00,0.00,0.00,12.50,662.50,'2022-09-15 07:58:12','',''),(7202,'1','277','1',1,'Retail Sale Id 7172',2999.36,0.00,0.00,4.12,218.36,'2022-09-15 08:02:48','',''),(7203,'1','277','1',1,'Retail Sale Id 7173',749.84,0.00,0.00,1.03,54.59,'2022-09-15 08:09:11','',''),(7204,'1','277','1',1,'Retail Sale Id 7174',2198.56,0.00,0.00,3.02,160.06,'2022-09-15 08:20:03','',''),(7205,'1','277','1',1,'Retail Sale Id 7174',3698.24,0.00,0.00,5.08,269.24,'2022-09-15 08:20:03','',''),(7206,'1','277','1',1,'Retail Sale Id 7175',2999.36,0.00,0.00,4.12,218.36,'2022-09-15 08:21:15','',''),(7207,'1','277','1',1,'Retail Sale Id 7176',3996.72,0.00,0.00,5.49,290.97,'2022-09-15 08:26:29','',''),(7208,'1','277','1',1,'Retail Sale Id 7177',2198.56,0.00,0.00,3.02,160.06,'2022-09-15 08:34:27','',''),(7209,'1','277','1',1,'Retail Sale Id 7178',3647.28,0.00,0.00,5.01,265.53,'2022-09-15 08:36:57','',''),(7210,'1','277','1',1,'Retail Sale Id 7179',2999.36,0.00,0.00,4.12,218.36,'2022-09-15 08:39:38','',''),(7211,'1','277','1',1,'Retail Sale Id 7180',800.80,0.00,0.00,1.10,58.30,'2022-09-15 08:41:28','',''),(7212,'1','277','1',1,'Retail Sale Id 7181',1397.76,0.00,0.00,1.92,101.76,'2022-09-15 08:42:55','',''),(7213,'1','277','1',1,'Retail Sale Id 7182',9100.00,0.00,0.00,12.50,662.50,'2022-09-15 08:59:42','',''),(7214,'1','277','1',1,'Retail Sale Id 7183',4397.12,0.00,0.00,6.04,320.12,'2022-09-15 09:01:07','',''),(7215,'1','277','1',1,'Retail Sale Id 7184',3647.28,0.00,0.00,5.01,265.53,'2022-09-15 09:02:56','',''),(7216,'1','277','1',1,'Retail Sale Id 7185',9100.00,0.00,0.00,12.50,662.50,'2022-09-15 09:03:55','',''),(7217,'1','277','1',1,'Retail Sale Id 7186',4397.12,0.00,0.00,6.04,320.12,'2022-09-15 09:05:00','',''),(7218,'1','277','1',1,'Retail Sale Id 7187',3399.76,0.00,0.00,4.67,247.51,'2022-09-15 09:12:12','',''),(7219,'1','277','1',1,'Retail Sale Id 7188',9100.00,0.00,0.00,12.50,662.50,'2022-09-15 09:14:17','',''),(7220,'1','277','1',1,'Retail Sale Id 7189',698.88,0.00,0.00,0.96,50.88,'2022-09-15 09:24:54','',''),(7221,'1','277','1',1,'Retail Sale Id 7190',749.84,0.00,0.00,1.03,54.59,'2022-09-15 09:59:31','',''),(7222,'1','277','1',1,'Retail Sale Id 7191',2198.56,0.00,0.00,3.02,160.06,'2022-09-15 10:00:47','',''),(7223,'1','277','1',1,'Retail Sale Id 7192',9464.00,0.00,0.00,13.00,689.00,'2022-09-15 10:10:38','',''),(7224,'1','277','1',1,'Retail Sale Id 7192',9464.00,0.00,0.00,13.00,689.00,'2022-09-15 10:10:38','',''),(7225,'1','277','1',1,'Retail Sale Id 7193',9100.00,0.00,0.00,12.50,662.50,'2022-09-15 10:11:35','',''),(7226,'1','277','1',1,'Retail Sale Id 7194',9100.00,0.00,0.00,12.50,662.50,'2022-09-15 10:17:51','',''),(7227,'1','277','1',1,'Retail Sale Id 7195',997.36,0.00,0.00,1.37,72.61,'2022-09-15 10:23:03','',''),(7228,'1','277','1',1,'Retail Sale Id 7195',997.36,0.00,0.00,1.37,72.61,'2022-09-15 10:23:03','',''),(7229,'1','277','1',1,'Retail Sale Id 7196',2002.00,0.00,0.00,2.75,145.75,'2022-09-15 10:23:42','',''),(7230,'1','277','1',1,'Retail Sale Id 7197',2999.36,0.00,0.00,4.12,218.36,'2022-09-15 10:24:56','',''),(7231,'1','277','1',1,'Retail Sale Id 7198',997.36,0.00,0.00,1.37,72.61,'2022-09-15 10:25:39','',''),(7232,'1','277','1',1,'Retail Sale Id 7199',997.36,0.00,0.00,1.37,72.61,'2022-09-15 10:28:41','',''),(7233,'1','277','1',1,'Retail Sale Id 7200',2198.56,0.00,0.00,3.02,160.06,'2022-09-15 10:38:07','',''),(7234,'1','277','1',1,'Retail Sale Id 7201',2999.36,0.00,0.00,4.12,218.36,'2022-09-15 10:44:33','',''),(7235,'1','277','1',1,'Retail Sale Id 7202',2198.56,0.00,0.00,3.02,160.06,'2022-09-15 10:47:18','',''),(7236,'1','277','1',1,'Retail Sale Id 7203',8998.08,0.00,0.00,12.36,655.08,'2022-09-15 10:53:26','',''),(7237,'1','277','1',1,'Retail Sale Id 7204',2999.36,0.00,0.00,4.12,218.36,'2022-09-15 10:59:32','',''),(7238,'1','277','1',1,'Retail Sale Id 7205',800.80,0.00,0.00,1.10,58.30,'2022-09-15 11:02:15','',''),(7239,'1','277','1',1,'Retail Sale Id 7206',2402.40,0.00,0.00,3.30,174.90,'2022-09-15 11:12:26','',''),(7240,'1','277','1',1,'Retail Sale Id 7207',2198.56,0.00,0.00,3.02,160.06,'2022-09-15 11:21:39','',''),(7241,'1','277','1',1,'Retail Sale Id 7208',800.80,0.00,0.00,1.10,58.30,'2022-09-15 11:22:57','',''),(7242,'1','277','1',1,'Retail Sale Id 7209',2497.04,0.00,0.00,3.43,181.79,'2022-09-15 11:45:42','',''),(7243,'1','277','1',1,'Retail Sale Id 7210',4397.12,0.00,0.00,6.04,320.12,'2022-09-15 12:10:01','',''),(7244,'1','277','1',1,'Retail Sale Id 7212',4397.12,0.00,0.00,6.04,320.12,'2022-09-15 12:11:34','',''),(7245,'1','277','1',1,'Retail Sale Id 7213',2198.56,0.00,0.00,3.02,160.06,'2022-09-15 12:12:53','',''),(7246,'1','277','1',1,'Retail Sale Id 7214',1499.68,0.00,0.00,2.06,109.18,'2022-09-15 12:15:08','',''),(7247,'1','277','1',1,'Retail Sale Id 7215',1499.68,0.00,0.00,2.06,109.18,'2022-09-15 12:22:58','',''),(7248,'1','277','1',1,'Retail Sale Id 7216',3698.24,0.00,0.00,5.08,269.24,'2022-09-15 12:25:39','',''),(7249,'1','277','1',1,'Retail Sale Id 7217',2999.36,0.00,0.00,4.12,218.36,'2022-09-15 12:31:51','',''),(7250,'1','277','1',1,'Retail Sale Id 7218',2999.36,0.00,0.00,4.12,218.36,'2022-09-15 12:32:45','',''),(7251,'1','277','1',1,'Retail Sale Id 7219',2497.04,0.00,0.00,3.43,181.79,'2022-09-15 12:35:23','',''),(7252,'1','277','1',1,'Retail Sale Id 7220',4397.12,0.00,0.00,6.04,320.12,'2022-09-15 12:45:23','',''),(7253,'1','277','1',1,'Retail Sale Id 7221',997.36,0.00,0.00,1.37,72.61,'2022-09-15 12:58:51','',''),(7254,'1','277','1',1,'Retail Sale Id 7222',800.80,0.00,0.00,1.10,58.30,'2022-09-15 13:09:27','',''),(7255,'1','277','1',1,'Retail Sale Id 7223',5096.00,0.00,0.00,7.00,371.00,'2022-09-15 13:32:20','',''),(7256,'1','277','1',1,'Retail Sale Id 7223',5096.00,0.00,0.00,7.00,371.00,'2022-09-15 13:32:20','',''),(7257,'1','277','1',1,'Retail Sale Id 7224',3698.24,0.00,0.00,5.08,269.24,'2022-09-15 13:33:47','',''),(7258,'1','277','1',1,'Retail Sale Id 7225',2096.64,0.00,0.00,2.88,152.64,'2022-09-15 13:35:16','',''),(7259,'1','277','1',1,'Retail Sale Id 7226',2999.36,0.00,0.00,4.12,218.36,'2022-09-15 13:36:06','',''),(7260,'1','277','1',1,'Retail Sale Id 7228',27001.52,0.00,0.00,37.09,1965.77,'2022-09-15 13:37:37','',''),(7261,'1','277','1',1,'Retail Sale Id 7229',997.36,0.00,0.00,1.37,72.61,'2022-09-15 13:40:38','',''),(7262,'1','277','1',1,'Retail Sale Id 7230',4397.12,0.00,0.00,6.04,320.12,'2022-09-15 13:43:15','',''),(7263,'1','277','1',1,'Retail Sale Id 7231',728.00,0.00,0.00,1.00,53.00,'2022-09-15 13:45:59','',''),(7264,'1','277','1',1,'Retail Sale Id 7232',2999.36,0.00,0.00,4.12,218.36,'2022-09-15 14:20:01','',''),(7265,'1','277','1',1,'Retail Sale Id 7233',2948.40,0.00,0.00,4.05,214.65,'2022-09-15 14:20:52','',''),(7266,'1','277','1',1,'Retail Sale Id 7234',4397.12,0.00,0.00,6.04,320.12,'2022-09-15 14:21:43','',''),(7267,'1','277','1',1,'Retail Sale Id 7235',2999.36,0.00,0.00,4.12,218.36,'2022-09-15 14:22:35','',''),(7268,'1','277','1',1,'Retail Sale Id 7236',2198.56,0.00,0.00,3.02,160.06,'2022-09-15 14:23:25','',''),(7269,'1','277','1',1,'Retail Sale Id 7237',2999.36,0.00,0.00,4.12,218.36,'2022-09-15 14:27:50','',''),(7270,'1','277','1',1,'Retail Sale Id 7238',2002.00,0.00,0.00,2.75,145.75,'2022-09-15 14:29:14','',''),(7271,'1','277','1',1,'Retail Sale Id 7239',2999.36,0.00,0.00,4.12,218.36,'2022-09-15 14:30:44','',''),(7272,'1','277','1',1,'Retail Sale Id 7241',997.36,0.00,0.00,1.37,72.61,'2022-09-15 14:34:56','',''),(7273,'1','277','1',1,'Retail Sale Id 7242',2198.56,0.00,0.00,3.02,160.06,'2022-09-15 14:37:03','',''),(7274,'1','277','1',1,'Retail Sale Id 7243',1499.68,0.00,0.00,2.06,109.18,'2022-09-15 14:37:51','',''),(7275,'1','277','1',1,'Retail Sale Id 7244',2002.00,0.00,0.00,2.75,145.75,'2022-09-15 14:40:33','',''),(7276,'1','277','1',1,'Retail Sale Id 7245',997.36,0.00,0.00,1.37,72.61,'2022-09-15 14:44:07','',''),(7277,'1','277','1',1,'Retail Sale Id 7246',2002.00,0.00,0.00,2.75,145.75,'2022-09-15 14:46:10','',''),(7278,'1','277','1',1,'Retail Sale Id 7246',2002.00,0.00,0.00,2.75,145.75,'2022-09-15 14:46:10','',''),(7279,'1','277','1',1,'Retail Sale Id 7246',2002.00,0.00,0.00,2.75,145.75,'2022-09-15 14:46:10','',''),(7280,'1','277','1',1,'Retail Sale Id 7247',2999.36,0.00,0.00,4.12,218.36,'2022-09-15 15:12:06','',''),(7281,'1','277','1',1,'Retail Sale Id 7249',2198.56,0.00,0.00,3.02,160.06,'2022-09-15 15:13:32','',''),(7282,'1','277','1',1,'Retail Sale Id 7252',2198.56,0.00,0.00,3.02,160.06,'2022-09-15 15:14:40','',''),(7283,'1','277','1',1,'Retail Sale Id 7253',2999.36,0.00,0.00,4.12,218.36,'2022-09-15 15:16:01','',''),(7284,'1','277','1',1,'Retail Sale Id 7254',2999.36,0.00,0.00,4.12,218.36,'2022-09-15 15:17:27','',''),(7285,'1','277','1',1,'Retail Sale Id 7255',1499.68,0.00,0.00,2.06,109.18,'2022-09-15 15:18:47','',''),(7286,'1','277','1',1,'Retail Sale Id 7256',749.84,0.00,0.00,1.03,54.59,'2022-09-15 15:19:52','',''),(7287,'1','277','1',1,'Retail Sale Id 7257',1499.68,0.00,0.00,2.06,109.18,'2022-09-15 15:22:13','',''),(7288,'1','277','1',1,'Retail Sale Id 7258',4397.12,0.00,0.00,6.04,320.12,'2022-09-15 15:27:15','',''),(7289,'1','277','1',1,'Retail Sale Id 7259',4499.04,0.00,0.00,6.18,327.54,'2022-09-15 15:32:18','',''),(7290,'1','277','1',1,'Retail Sale Id 7260',2002.00,0.00,0.00,2.75,145.75,'2022-09-15 15:36:23','',''),(7291,'1','277','1',1,'Retail Sale Id 7261',2497.04,0.00,0.00,3.43,181.79,'2022-09-15 15:44:35','',''),(7292,'1','277','1',1,'Retail Sale Id 7262',1499.68,0.00,0.00,2.06,109.18,'2022-09-15 15:45:41','',''),(7293,'1','277','1',1,'Retail Sale Id 7263',1499.68,0.00,0.00,2.06,109.18,'2022-09-15 15:49:12','',''),(7294,'1','277','1',1,'Retail Sale Id 7264',2198.56,0.00,0.00,3.02,160.06,'2022-09-15 15:51:20','',''),(7295,'1','277','1',1,'Retail Sale Id 7265',2999.36,0.00,0.00,4.12,218.36,'2022-09-15 15:57:56','',''),(7296,'1','277','1',1,'Retail Sale Id 7266',2198.56,0.00,0.00,3.02,160.06,'2022-09-15 16:00:33','',''),(7297,'1','277','1',1,'Retail Sale Id 7267',9100.00,0.00,0.00,12.50,662.50,'2022-09-15 16:02:07','',''),(7298,'1','277','1',1,'Retail Sale Id 7268',3640.00,0.00,0.00,5.00,265.00,'2022-09-15 16:14:42','',''),(7299,'1','277','1',1,'Retail Sale Id 7269',4397.12,0.00,0.00,6.04,320.12,'2022-09-15 16:16:47','',''),(7300,'1','277','1',1,'Retail Sale Id 7270',2198.56,0.00,0.00,3.02,160.06,'2022-09-15 16:19:52','',''),(7301,'1','277','1',1,'Retail Sale Id 7271',3996.72,0.00,0.00,5.49,290.97,'2022-09-15 16:23:29','',''),(7302,'1','277','1',1,'Retail Sale Id 7272',997.36,0.00,0.00,1.37,72.61,'2022-09-15 16:24:33','',''),(7303,'1','277','1',1,'Retail Sale Id 7272',2002.00,0.00,0.00,2.75,145.75,'2022-09-15 16:24:33','',''),(7304,'1','277','1',1,'Retail Sale Id 7273',1499.68,0.00,0.00,2.06,109.18,'2022-09-15 16:32:36','',''),(7305,'1','277','1',1,'Retail Sale Id 7274',2002.00,0.00,0.00,2.75,145.75,'2022-09-15 16:42:13','',''),(7306,'1','277','1',1,'Retail Sale Id 7275',9100.00,0.00,0.00,12.50,662.50,'2022-09-15 16:55:07','',''),(7307,'1','277','1',1,'Retail Sale Id 7276',1397.76,0.00,0.00,1.92,101.76,'2022-09-15 16:56:13','',''),(7308,'1','277','1',1,'Retail Sale Id 7277',1499.68,0.00,0.00,2.06,109.18,'2022-09-15 16:57:04','',''),(7309,'1','277','1',1,'Retail Sale Id 7278',3647.28,0.00,0.00,5.01,265.53,'2022-09-15 16:58:30','',''),(7310,'1','277','1',1,'Retail Sale Id 7279',3996.72,0.00,0.00,5.49,290.97,'2022-09-15 17:00:22','',''),(7311,'1','277','1',1,'Retail Sale Id 7280',2198.56,0.00,0.00,3.02,160.06,'2022-09-15 17:09:50','',''),(7312,'1','277','1',1,'Retail Sale Id 7281',2497.04,0.00,0.00,3.43,181.79,'2022-09-15 17:11:10','',''),(7313,'1','277','1',1,'Retail Sale Id 7282',5001.36,0.00,0.00,6.87,364.11,'2022-09-15 17:11:52','',''),(7314,'1','277','1',1,'Retail Sale Id 7283',3996.72,0.00,0.00,5.49,290.97,'2022-09-15 17:15:49','',''),(7315,'1','277','1',1,'Retail Sale Id 7284',1499.68,0.00,0.00,2.06,109.18,'2022-09-15 17:16:33','',''),(7316,'1','277','1',1,'Retail Sale Id 7285',3501.68,0.00,0.00,4.81,254.93,'2022-09-15 17:23:02','',''),(7317,'1','277','1',1,'Retail Sale Id 7286',4397.12,0.00,0.00,6.04,320.12,'2022-09-15 17:24:09','',''),(7318,'1','277','1',1,'Retail Sale Id 7287',1900.08,0.00,0.00,2.61,138.33,'2022-09-15 17:51:32','',''),(7319,'1','277','1',1,'Retail Sale Id 7288',9100.00,0.00,0.00,12.50,662.50,'2022-09-15 17:53:50','',''),(7320,'1','277','1',1,'Retail Sale Id 7289',5001.36,0.00,0.00,6.87,364.11,'2022-09-15 17:55:27','',''),(7321,'1','277','1',1,'Retail Sale Id 7290',2002.00,0.00,0.00,2.75,145.75,'2022-09-15 18:06:14','',''),(7322,'1','277','1',1,'Retail Sale Id 7291',1900.08,0.00,0.00,2.61,138.33,'2022-09-15 18:10:45','',''),(7323,'1','277','1',1,'Retail Sale Id 7292',2002.00,0.00,0.00,2.75,145.75,'2022-09-15 18:11:43','',''),(7324,'1','277','1',1,'Retail Sale Id 7293',1499.68,0.00,0.00,2.06,109.18,'2022-09-15 18:12:38','',''),(7325,'1','277','1',1,'Retail Sale Id 7294',749.84,0.00,0.00,1.03,54.59,'2022-09-15 18:13:34','',''),(7326,'1','277','1',1,'Retail Sale Id 7295',749.84,0.00,0.00,1.03,54.59,'2022-09-15 18:14:13','',''),(7327,'1','277','1',1,'Retail Sale Id 7296',2002.00,0.00,0.00,2.75,145.75,'2022-09-15 18:16:32','',''),(7328,'1','277','1',1,'Retail Sale Id 7297',2999.36,0.00,0.00,4.12,218.36,'2022-09-15 18:17:53','',''),(7329,'1','277','1',1,'Retail Sale Id 7298',1499.68,0.00,0.00,2.06,109.18,'2022-09-15 18:23:40','',''),(7330,'1','277','1',1,'Retail Sale Id 7298',2002.00,0.00,0.00,2.75,145.75,'2022-09-15 18:23:40','',''),(7331,'1','277','1',1,'Retail Sale Id 7299',7301.84,0.00,0.00,10.03,531.59,'2022-09-15 18:31:13','',''),(7332,'1','277','1',1,'Retail Sale Id 7300',997.36,0.00,0.00,1.37,72.61,'2022-09-15 18:33:38','',''),(7333,'1','277','1',1,'Retail Sale Id 7301',502.32,0.00,0.00,0.69,36.57,'2022-09-15 18:41:55','',''),(7334,'1','277','1',1,'Retail Sale Id 7302',1499.68,0.00,0.00,2.06,109.18,'2022-09-15 18:47:38','',''),(7335,'1','277','1',1,'Retail Sale Id 7303',1499.68,0.00,0.00,2.06,109.18,'2022-09-15 18:57:11','',''),(7336,'1','277','1',1,'Retail Sale Id 7304',3996.72,0.00,0.00,5.49,290.97,'2022-09-15 18:58:51','',''),(7337,'1','277','1',1,'Retail Sale Id 7305',997.36,0.00,0.00,1.37,72.61,'2022-09-15 19:00:51','',''),(7338,'1','277','1',1,'Retail Sale Id 7306',997.36,0.00,0.00,1.37,72.61,'2022-09-15 19:03:34','',''),(7339,'1','277','1',1,'Retail Sale Id 7307',1499.68,0.00,0.00,2.06,109.18,'2022-09-15 19:18:02','',''),(7340,'1','277','1',1,'Retail Sale Id 7308',4397.12,0.00,0.00,6.04,320.12,'2022-09-15 19:20:11','',''),(7341,'1','277','1',1,'Retail Sale Id 7309',80.08,0.00,0.00,0.11,5.83,'2022-09-15 19:41:26','',''),(7342,'1','277','1',1,'Retail Sale Id 7310',2402.40,0.00,0.00,3.30,174.90,'2022-09-16 07:28:25','',''),(7343,'1','277','1',1,'Retail Sale Id 7311',1499.68,0.00,0.00,2.06,109.18,'2022-09-16 07:29:18','',''),(7344,'1','277','1',1,'Retail Sale Id 7312',2999.36,0.00,0.00,4.12,218.36,'2022-09-16 07:41:02','',''),(7345,'1','277','1',1,'Retail Sale Id 7313',1499.68,0.00,0.00,2.06,109.18,'2022-09-16 07:43:15','',''),(7346,'1','277','1',1,'Retail Sale Id 7314',997.36,0.00,0.00,1.37,72.61,'2022-09-16 07:44:54','',''),(7347,'1','277','1',1,'Retail Sale Id 7315',997.36,0.00,0.00,1.37,72.61,'2022-09-16 07:57:32','',''),(7348,'1','277','1',1,'Retail Sale Id 7316',4397.12,0.00,0.00,6.04,320.12,'2022-09-16 08:21:05','',''),(7349,'1','277','1',1,'Retail Sale Id 7317',3640.00,0.00,0.00,5.00,265.00,'2022-09-16 08:29:28','',''),(7350,'1','277','1',1,'Retail Sale Id 7317',9100.00,0.00,0.00,12.50,662.50,'2022-09-16 08:29:28','',''),(7351,'1','277','1',1,'Retail Sale Id 7318',1499.68,0.00,0.00,2.06,109.18,'2022-09-16 08:31:05','',''),(7352,'1','277','1',1,'Retail Sale Id 7319',800.80,0.00,0.00,1.10,58.30,'2022-09-16 08:35:10','',''),(7353,'1','277','1',1,'Retail Sale Id 7321',5103.28,0.00,0.00,7.01,371.53,'2022-09-16 08:40:57','',''),(7354,'1','277','1',1,'Retail Sale Id 7322',2002.00,0.00,0.00,2.75,145.75,'2022-09-16 08:45:56','',''),(7355,'1','277','1',1,'Retail Sale Id 7323',9100.00,0.00,0.00,12.50,662.50,'2022-09-16 08:59:07','',''),(7356,'1','277','1',1,'Retail Sale Id 7324',4397.12,0.00,0.00,6.04,320.12,'2022-09-16 09:00:08','',''),(7357,'1','277','1',1,'Retail Sale Id 7325',3996.72,0.00,0.00,5.49,290.97,'2022-09-16 09:02:38','',''),(7358,'1','277','1',1,'Retail Sale Id 7326',997.36,0.00,0.00,1.37,72.61,'2022-09-16 09:08:23','',''),(7359,'1','277','1',1,'Retail Sale Id 7327',5001.36,0.00,0.00,6.87,364.11,'2022-09-16 09:12:27','',''),(7360,'1','277','1',1,'Retail Sale Id 7328',9100.00,0.00,0.00,12.50,662.50,'2022-09-16 09:15:46','',''),(7361,'1','277','1',1,'Retail Sale Id 7329',4397.12,0.00,0.00,6.04,320.12,'2022-09-16 09:24:01','',''),(7362,'1','277','1',1,'Retail Sale Id 7330',4397.12,0.00,0.00,6.04,320.12,'2022-09-16 09:27:07','',''),(7363,'1','277','1',1,'Retail Sale Id 7331',3996.72,0.00,0.00,5.49,290.97,'2022-09-16 09:35:08','',''),(7364,'1','277','1',1,'Retail Sale Id 7332',997.36,0.00,0.00,1.37,72.61,'2022-09-16 09:39:06','',''),(7365,'1','277','1',1,'Retail Sale Id 7333',2002.00,0.00,0.00,2.75,145.75,'2022-09-16 09:47:29','',''),(7366,'1','277','1',1,'Retail Sale Id 7334',9100.00,0.00,0.00,12.50,662.50,'2022-09-16 09:48:48','',''),(7367,'1','277','1',1,'Retail Sale Id 7335',3640.00,0.00,0.00,5.00,265.00,'2022-09-16 09:50:25','',''),(7368,'1','277','1',1,'Retail Sale Id 7336',2999.36,0.00,0.00,4.12,218.36,'2022-09-16 09:52:58','',''),(7369,'1','277','1',1,'Retail Sale Id 7337',1303.12,0.00,0.00,1.79,94.87,'2022-09-16 09:54:53','',''),(7370,'1','277','1',1,'Retail Sale Id 7338',2002.00,0.00,0.00,2.75,145.75,'2022-09-16 09:55:42','',''),(7371,'1','277','1',1,'Retail Sale Id 7339',9100.00,0.00,0.00,12.50,662.50,'2022-09-16 10:01:50','',''),(7372,'1','277','1',1,'Retail Sale Id 7340',5896.80,0.00,0.00,8.10,429.30,'2022-09-16 10:03:49','',''),(7373,'1','277','1',1,'Retail Sale Id 7341',2999.36,0.00,0.00,4.12,218.36,'2022-09-16 10:04:51','',''),(7374,'1','277','1',1,'Retail Sale Id 7342',502.32,0.00,0.00,0.69,36.57,'2022-09-16 10:11:27','',''),(7375,'1','277','1',1,'Retail Sale Id 7343',2002.00,0.00,0.00,2.75,145.75,'2022-09-16 10:12:40','',''),(7376,'1','277','1',1,'Retail Sale Id 7344',4397.12,0.00,0.00,6.04,320.12,'2022-09-16 10:17:04','',''),(7377,'1','277','1',1,'Retail Sale Id 7345',1499.68,0.00,0.00,2.06,109.18,'2022-09-16 10:27:11','',''),(7378,'1','277','1',1,'Retail Sale Id 7346',1499.68,0.00,0.00,2.06,109.18,'2022-09-16 10:28:55','',''),(7379,'1','277','1',1,'Retail Sale Id 7347',2002.00,0.00,0.00,2.75,145.75,'2022-09-16 10:29:52','',''),(7380,'1','277','1',1,'Retail Sale Id 7348',3640.00,0.00,0.00,5.00,265.00,'2022-09-16 10:33:23','',''),(7381,'1','277','1',1,'Retail Sale Id 7349',4397.12,0.00,0.00,6.04,320.12,'2022-09-16 10:34:13','',''),(7382,'1','277','1',1,'Retail Sale Id 7350',2002.00,0.00,0.00,2.75,145.75,'2022-09-16 10:34:52','',''),(7383,'1','277','1',1,'Retail Sale Id 7351',5001.36,0.00,0.00,6.87,364.11,'2022-09-16 10:42:24','',''),(7384,'1','277','1',1,'Retail Sale Id 7352',596.96,0.00,0.00,0.82,43.46,'2022-09-16 10:45:57','',''),(7385,'1','277','1',1,'Retail Sale Id 7353',2198.56,0.00,0.00,3.02,160.06,'2022-09-16 10:47:44','',''),(7386,'1','277','1',1,'Retail Sale Id 7354',4397.12,0.00,0.00,6.04,320.12,'2022-09-16 11:04:30','',''),(7387,'1','277','1',1,'Retail Sale Id 7355',3603.60,0.00,0.00,4.95,262.35,'2022-09-16 11:07:24','',''),(7388,'1','277','1',1,'Retail Sale Id 7356',698.88,0.00,0.00,0.96,50.88,'2022-09-16 11:18:31','',''),(7389,'1','277','1',1,'Retail Sale Id 7357',2999.36,0.00,0.00,4.12,218.36,'2022-09-16 11:20:12','',''),(7390,'1','277','1',1,'Retail Sale Id 7358',4397.12,0.00,0.00,6.04,320.12,'2022-09-16 11:26:03','',''),(7391,'1','277','1',1,'Retail Sale Id 7359',5001.36,0.00,0.00,6.87,364.11,'2022-09-16 11:27:52','',''),(7392,'1','277','1',1,'Retail Sale Id 7360',2198.56,0.00,0.00,3.02,160.06,'2022-09-16 11:33:02','',''),(7393,'1','277','1',1,'Retail Sale Id 7360',4397.12,0.00,0.00,6.04,320.12,'2022-09-16 11:33:02','',''),(7394,'1','277','1',1,'Retail Sale Id 7361',2198.56,0.00,0.00,3.02,160.06,'2022-09-16 11:38:59','',''),(7395,'1','277','1',1,'Retail Sale Id 7362',24999.52,0.00,0.00,34.34,1820.02,'2022-09-16 11:49:01','',''),(7396,'1','277','1',1,'Retail Sale Id 7363',800.80,0.00,0.00,1.10,58.30,'2022-09-16 11:59:39','',''),(7397,'1','277','1',1,'Retail Sale Id 7364',2198.56,0.00,0.00,3.02,160.06,'2022-09-16 12:29:43','',''),(7398,'1','277','1',1,'Retail Sale Id 7365',2198.56,0.00,0.00,3.02,160.06,'2022-09-16 12:36:31','',''),(7399,'1','277','1',1,'Retail Sale Id 7366',698.88,0.00,0.00,0.96,50.88,'2022-09-16 12:37:13','',''),(7400,'1','277','1',1,'Retail Sale Id 7367',2002.00,0.00,0.00,2.75,145.75,'2022-09-16 12:37:54','',''),(7401,'1','277','1',1,'Retail Sale Id 7368',2198.56,0.00,0.00,3.02,160.06,'2022-09-16 12:47:50','',''),(7402,'1','277','1',1,'Retail Sale Id 7369',2999.36,0.00,0.00,4.12,218.36,'2022-09-16 12:48:38','',''),(7403,'1','277','1',1,'Retail Sale Id 7370',2999.36,0.00,0.00,4.12,218.36,'2022-09-16 12:53:06','',''),(7404,'1','277','1',1,'Retail Sale Id 7371',9100.00,0.00,0.00,12.50,662.50,'2022-09-16 12:53:55','',''),(7405,'1','277','1',1,'Retail Sale Id 7372',7280.00,0.00,0.00,10.00,530.00,'2022-09-16 12:56:29','',''),(7406,'1','277','1',1,'Retail Sale Id 7373',2198.56,0.00,0.00,3.02,160.06,'2022-09-16 13:02:37','',''),(7407,'1','277','1',1,'Retail Sale Id 7374',997.36,0.00,0.00,1.37,72.61,'2022-09-16 13:03:45','',''),(7408,'1','277','1',1,'Retail Sale Id 7375',3640.00,0.00,0.00,5.00,265.00,'2022-09-16 13:13:48','',''),(7409,'1','277','1',1,'Retail Sale Id 7376',997.36,0.00,0.00,1.37,72.61,'2022-09-16 13:15:59','',''),(7410,'1','277','1',1,'Retail Sale Id 7377',4397.12,0.00,0.00,6.04,320.12,'2022-09-16 13:30:22','',''),(7411,'1','277','1',1,'Retail Sale Id 7378',502.32,0.00,0.00,0.69,36.57,'2022-09-16 13:40:30','',''),(7412,'1','277','1',1,'Retail Sale Id 7379',698.88,0.00,0.00,0.96,50.88,'2022-09-16 13:57:43','',''),(7413,'1','277','1',1,'Retail Sale Id 7380',2497.04,0.00,0.00,3.43,181.79,'2022-09-16 13:59:23','',''),(7414,'1','277','1',1,'Retail Sale Id 7381',2198.56,0.00,0.00,3.02,160.06,'2022-09-16 14:01:04','',''),(7415,'1','277','1',1,'Retail Sale Id 7382',1499.68,0.00,0.00,2.06,109.18,'2022-09-16 14:02:20','',''),(7416,'1','277','1',1,'Retail Sale Id 7383',3996.72,0.00,0.00,5.49,290.97,'2022-09-16 14:05:09','',''),(7417,'1','277','1',1,'Retail Sale Id 7384',2497.04,0.00,0.00,3.43,181.79,'2022-09-16 14:08:08','',''),(7418,'1','277','1',1,'Retail Sale Id 7385',749.84,0.00,0.00,1.03,54.59,'2022-09-16 14:09:08','',''),(7419,'1','277','1',1,'Retail Sale Id 7386',9100.00,0.00,0.00,12.50,662.50,'2022-09-16 14:22:01','',''),(7420,'1','277','1',1,'Retail Sale Id 7387',2999.36,0.00,0.00,4.12,218.36,'2022-09-16 14:43:33','',''),(7421,'1','277','1',1,'Retail Sale Id 7388',4397.12,0.00,0.00,6.04,320.12,'2022-09-16 14:44:13','',''),(7422,'1','277','1',1,'Retail Sale Id 7389',1499.68,0.00,0.00,2.06,109.18,'2022-09-16 14:44:46','',''),(7423,'1','277','1',1,'Retail Sale Id 7390',2002.00,0.00,0.00,2.75,145.75,'2022-09-16 14:45:21','',''),(7424,'1','277','1',1,'Retail Sale Id 7391',997.36,0.00,0.00,1.37,72.61,'2022-09-16 14:45:53','',''),(7425,'1','277','1',1,'Retail Sale Id 7392',800.80,0.00,0.00,1.10,58.30,'2022-09-16 14:46:44','',''),(7426,'1','277','1',1,'Retail Sale Id 7394',2002.00,0.00,0.00,2.75,145.75,'2022-09-16 14:48:25','',''),(7427,'1','277','1',1,'Retail Sale Id 7395',698.88,0.00,0.00,0.96,50.88,'2022-09-16 14:49:19','',''),(7428,'1','277','1',1,'Retail Sale Id 7396',2198.56,0.00,0.00,3.02,160.06,'2022-09-16 14:50:41','',''),(7429,'1','277','1',1,'Retail Sale Id 7397',5998.72,0.00,0.00,8.24,436.72,'2022-09-16 14:51:43','',''),(7430,'1','277','1',1,'Retail Sale Id 7398',3996.72,0.00,0.00,5.49,290.97,'2022-09-16 14:53:20','',''),(7431,'1','277','1',1,'Retail Sale Id 7399',4397.12,0.00,0.00,6.04,320.12,'2022-09-16 15:03:05','',''),(7432,'1','277','1',1,'Retail Sale Id 7399',9100.00,0.00,0.00,12.50,662.50,'2022-09-16 15:03:05','',''),(7433,'1','277','1',1,'Retail Sale Id 7400',2497.04,0.00,0.00,3.43,181.79,'2022-09-16 15:04:30','',''),(7434,'1','277','1',1,'Retail Sale Id 7401',1499.68,0.00,0.00,2.06,109.18,'2022-09-16 15:07:10','',''),(7435,'1','277','1',1,'Retail Sale Id 7402',4397.12,0.00,0.00,6.04,320.12,'2022-09-16 15:10:56','',''),(7436,'1','277','1',1,'Retail Sale Id 7403',1499.68,0.00,0.00,2.06,109.18,'2022-09-16 15:13:12','',''),(7437,'1','277','1',1,'Retail Sale Id 7404',1499.68,0.00,0.00,2.06,109.18,'2022-09-16 15:18:49','',''),(7438,'1','277','1',1,'Retail Sale Id 7405',2002.00,0.00,0.00,2.75,145.75,'2022-09-16 15:27:43','',''),(7439,'1','277','1',1,'Retail Sale Id 7406',2999.36,0.00,0.00,4.12,218.36,'2022-09-16 15:29:07','',''),(7440,'1','277','1',1,'Retail Sale Id 7407',749.84,0.00,0.00,1.03,54.59,'2022-09-16 15:31:09','',''),(7441,'1','277','1',1,'Retail Sale Id 7408',4397.12,0.00,0.00,6.04,320.12,'2022-09-16 15:33:16','',''),(7442,'1','277','1',1,'Retail Sale Id 7409',997.36,0.00,0.00,1.37,72.61,'2022-09-16 15:45:11','',''),(7443,'1','277','1',1,'Retail Sale Id 7410',4397.12,0.00,0.00,6.04,320.12,'2022-09-16 15:56:29','',''),(7444,'1','277','1',1,'Retail Sale Id 7411',10920.00,0.00,0.00,15.00,795.00,'2022-09-16 16:03:04','',''),(7445,'1','277','1',1,'Retail Sale Id 7412',3996.72,0.00,0.00,5.49,290.97,'2022-09-16 16:05:16','',''),(7446,'1','277','1',1,'Retail Sale Id 7413',3640.00,0.00,0.00,5.00,265.00,'2022-09-16 16:09:14','',''),(7447,'1','277','1',1,'Retail Sale Id 7414',2198.56,0.00,0.00,3.02,160.06,'2022-09-16 16:10:23','',''),(7448,'1','277','1',1,'Retail Sale Id 7415',2198.56,0.00,0.00,3.02,160.06,'2022-09-16 16:15:02','',''),(7449,'1','277','1',1,'Retail Sale Id 7416',2002.00,0.00,0.00,2.75,145.75,'2022-09-16 16:18:06','',''),(7450,'1','277','1',1,'Retail Sale Id 7417',2999.36,0.00,0.00,4.12,218.36,'2022-09-16 16:19:27','',''),(7451,'1','277','1',1,'Retail Sale Id 7418',997.36,0.00,0.00,1.37,72.61,'2022-09-16 16:21:34','',''),(7452,'1','277','1',1,'Retail Sale Id 7419',3996.72,0.00,0.00,5.49,290.97,'2022-09-16 16:22:26','',''),(7453,'1','277','1',1,'Retail Sale Id 7420',9100.00,0.00,0.00,12.50,662.50,'2022-09-16 16:23:29','',''),(7454,'1','277','1',1,'Retail Sale Id 7421',1499.68,0.00,0.00,2.06,109.18,'2022-09-16 16:24:08','',''),(7455,'1','277','1',1,'Retail Sale Id 7422',997.36,0.00,0.00,1.37,72.61,'2022-09-16 16:28:49','',''),(7456,'1','277','1',1,'Retail Sale Id 7423',4368.00,0.00,0.00,6.00,318.00,'2022-09-16 16:34:02','',''),(7457,'1','277','1',1,'Retail Sale Id 7424',9100.00,0.00,0.00,12.50,662.50,'2022-09-16 16:35:39','',''),(7458,'1','277','1',1,'Retail Sale Id 7425',9100.00,0.00,0.00,12.50,662.50,'2022-09-16 16:36:36','',''),(7459,'1','277','1',1,'Retail Sale Id 7426',1303.12,0.00,0.00,1.79,94.87,'2022-09-16 16:37:22','',''),(7460,'1','277','1',1,'Retail Sale Id 7427',4397.12,0.00,0.00,6.04,320.12,'2022-09-16 16:38:18','',''),(7461,'1','277','1',1,'Retail Sale Id 7428',2002.00,0.00,0.00,2.75,145.75,'2022-09-16 16:39:06','',''),(7462,'1','277','1',1,'Retail Sale Id 7429',3698.24,0.00,0.00,5.08,269.24,'2022-09-16 16:40:23','',''),(7463,'1','277','1',1,'Retail Sale Id 7430',4397.12,0.00,0.00,6.04,320.12,'2022-09-16 16:42:21','',''),(7464,'1','277','1',1,'Retail Sale Id 7431',5001.36,0.00,0.00,6.87,364.11,'2022-09-16 16:44:42','',''),(7465,'1','277','1',1,'Retail Sale Id 7432',4397.12,0.00,0.00,6.04,320.12,'2022-09-16 16:46:03','',''),(7466,'1','277','1',1,'Retail Sale Id 7433',2999.36,0.00,0.00,4.12,218.36,'2022-09-16 16:47:01','',''),(7467,'1','277','1',1,'Retail Sale Id 7434',2198.56,0.00,0.00,3.02,160.06,'2022-09-16 16:48:26','',''),(7468,'1','277','1',1,'Retail Sale Id 7435',3996.72,0.00,0.00,5.49,290.97,'2022-09-16 16:51:46','',''),(7469,'1','277','1',1,'Retail Sale Id 7436',1499.68,0.00,0.00,2.06,109.18,'2022-09-16 16:53:04','',''),(7470,'1','277','1',1,'Retail Sale Id 7437',851.76,0.00,0.00,1.17,62.01,'2022-09-16 16:54:49','',''),(7471,'1','277','1',1,'Retail Sale Id 7438',1499.68,0.00,0.00,2.06,109.18,'2022-09-16 16:59:01','',''),(7472,'1','277','1',1,'Retail Sale Id 7439',2002.00,0.00,0.00,2.75,145.75,'2022-09-16 17:03:38','',''),(7473,'1','277','1',1,'Retail Sale Id 7440',2999.36,0.00,0.00,4.12,218.36,'2022-09-16 17:05:30','',''),(7474,'1','277','1',1,'Retail Sale Id 7441',4397.12,0.00,0.00,6.04,320.12,'2022-09-16 17:07:37','',''),(7475,'1','277','1',1,'Retail Sale Id 7442',2999.36,0.00,0.00,4.12,218.36,'2022-09-16 17:11:26','',''),(7476,'1','277','1',1,'Retail Sale Id 7443',749.84,0.00,0.00,1.03,54.59,'2022-09-16 17:14:45','',''),(7477,'1','277','1',1,'Retail Sale Id 7443',1499.68,0.00,0.00,2.06,109.18,'2022-09-16 17:14:45','',''),(7478,'1','277','1',1,'Retail Sale Id 7444',1499.68,0.00,0.00,2.06,109.18,'2022-09-16 17:16:50','',''),(7479,'1','277','1',1,'Retail Sale Id 7445',902.72,0.00,0.00,1.24,65.72,'2022-09-16 17:17:40','',''),(7480,'1','277','1',1,'Retail Sale Id 7446',3640.00,0.00,0.00,5.00,265.00,'2022-09-16 17:20:02','',''),(7481,'1','277','1',1,'Retail Sale Id 7447',997.36,0.00,0.00,1.37,72.61,'2022-09-16 17:20:44','',''),(7482,'1','277','1',1,'Retail Sale Id 7448',1499.68,0.00,0.00,2.06,109.18,'2022-09-16 17:21:29','',''),(7483,'1','277','1',1,'Retail Sale Id 7449',2999.36,0.00,0.00,4.12,218.36,'2022-09-16 17:22:11','',''),(7484,'1','277','1',1,'Retail Sale Id 7450',6602.96,0.00,0.00,9.07,480.71,'2022-09-16 17:26:31','',''),(7485,'1','277','1',1,'Retail Sale Id 7451',1499.68,0.00,0.00,2.06,109.18,'2022-09-16 17:27:34','',''),(7486,'1','277','1',1,'Retail Sale Id 7452',4397.12,0.00,0.00,6.04,320.12,'2022-09-16 17:28:46','',''),(7487,'1','277','1',1,'Retail Sale Id 7453',3996.72,0.00,0.00,5.49,290.97,'2022-09-16 17:31:22','',''),(7488,'1','277','1',1,'Retail Sale Id 7454',997.36,0.00,0.00,1.37,72.61,'2022-09-16 17:32:04','',''),(7489,'1','277','1',1,'Retail Sale Id 7455',2002.00,0.00,0.00,2.75,145.75,'2022-09-16 17:32:44','',''),(7490,'1','277','1',1,'Retail Sale Id 7456',800.80,0.00,0.00,1.10,58.30,'2022-09-16 17:33:34','',''),(7491,'1','277','1',1,'Retail Sale Id 7457',2002.00,0.00,0.00,2.75,145.75,'2022-09-16 17:35:00','',''),(7492,'1','277','1',1,'Retail Sale Id 7457',7301.84,0.00,0.00,10.03,531.59,'2022-09-16 17:35:00','',''),(7493,'1','277','1',1,'Retail Sale Id 7458',502.32,0.00,0.00,0.69,36.57,'2022-09-16 17:35:49','',''),(7494,'1','277','1',1,'Retail Sale Id 7459',1499.68,0.00,0.00,2.06,109.18,'2022-09-16 17:41:22','',''),(7495,'1','277','1',1,'Retail Sale Id 7460',2198.56,0.00,0.00,3.02,160.06,'2022-09-16 17:45:53','',''),(7496,'1','277','1',1,'Retail Sale Id 7461',2999.36,0.00,0.00,4.12,218.36,'2022-09-16 17:48:37','',''),(7497,'1','277','1',1,'Retail Sale Id 7462',2184.00,0.00,0.00,3.00,159.00,'2022-09-16 17:55:11','',''),(7498,'1','277','1',1,'Retail Sale Id 7463',7280.00,0.00,0.00,10.00,530.00,'2022-09-16 17:58:29','',''),(7499,'1','277','1',1,'Retail Sale Id 7464',2002.00,0.00,0.00,2.75,145.75,'2022-09-16 18:01:19','',''),(7500,'1','277','1',1,'Retail Sale Id 7465',997.36,0.00,0.00,1.37,72.61,'2022-09-16 18:08:06','',''),(7501,'1','277','1',1,'Retail Sale Id 7466',502.32,0.00,0.00,0.69,36.57,'2022-09-16 18:10:46','',''),(7502,'1','277','1',1,'Retail Sale Id 7469',4550.00,0.00,0.00,6.25,331.25,'2022-09-16 18:15:41','',''),(7503,'1','277','1',1,'Retail Sale Id 7470',4397.12,0.00,0.00,6.04,320.12,'2022-09-16 18:16:28','',''),(7504,'1','277','1',1,'Retail Sale Id 7471',2198.56,0.00,0.00,3.02,160.06,'2022-09-16 18:17:03','',''),(7505,'1','277','1',1,'Retail Sale Id 7472',9100.00,0.00,0.00,12.50,662.50,'2022-09-16 18:17:51','',''),(7506,'1','277','1',1,'Retail Sale Id 7473',1499.68,0.00,0.00,2.06,109.18,'2022-09-16 18:25:01','',''),(7507,'1','277','1',1,'Retail Sale Id 7474',4397.12,0.00,0.00,6.04,320.12,'2022-09-16 18:25:56','',''),(7508,'1','277','1',1,'Retail Sale Id 7475',4397.12,0.00,0.00,6.04,320.12,'2022-09-16 18:32:47','',''),(7509,'1','277','1',1,'Retail Sale Id 7476',3698.24,0.00,0.00,5.08,269.24,'2022-09-16 18:33:55','',''),(7510,'1','277','1',1,'Retail Sale Id 7477',8000.72,0.00,0.00,10.99,582.47,'2022-09-16 18:37:37','',''),(7511,'1','277','1',1,'Retail Sale Id 7478',749.84,0.00,0.00,1.03,54.59,'2022-09-16 18:45:11','',''),(7512,'1','277','1',1,'Retail Sale Id 7479',2198.56,0.00,0.00,3.02,160.06,'2022-09-16 18:47:19','',''),(7513,'1','277','1',1,'Retail Sale Id 7480',7280.00,0.00,0.00,10.00,530.00,'2022-09-16 18:48:43','',''),(7514,'1','277','1',1,'Retail Sale Id 7481',2002.00,0.00,0.00,2.75,145.75,'2022-09-16 18:49:29','',''),(7515,'1','277','1',1,'Retail Sale Id 7482',698.88,0.00,0.00,0.96,50.88,'2022-09-16 18:52:50','',''),(7516,'1','277','1',1,'Retail Sale Id 7483',2198.56,0.00,0.00,3.02,160.06,'2022-09-16 18:55:41','',''),(7517,'1','277','1',1,'Retail Sale Id 7484',1499.68,0.00,0.00,2.06,109.18,'2022-09-16 18:59:39','',''),(7518,'1','277','1',1,'Retail Sale Id 7485',12303.20,0.00,0.00,16.90,895.70,'2022-09-16 19:12:54','',''),(7519,'1','277','1',1,'Return of Retail Sale Id 7466',0.00,502.32,0.69,0.00,-36.57,'2022-09-16 19:17:56','',''),(7520,'1','277','1',1,'Retail Sale Id 7486',502.32,0.00,0.00,0.69,36.57,'2022-09-16 19:21:51','',''),(7521,'1','277','1',1,'Return of Retail Sale Id 7460',0.00,2198.56,3.02,0.00,-160.06,'2022-09-16 19:29:19','',''),(7522,'1','277','1',1,'Retail Sale Id 7487',1907.36,0.00,0.00,2.62,138.86,'2022-09-16 19:30:36','',''),(7523,'1','277','1',1,'Retail Sale Id 7488',9100.00,0.00,0.00,12.50,662.50,'2022-09-17 06:49:49','',''),(7524,'1','277','1',1,'Retail Sale Id 7489',997.36,0.00,0.00,1.37,72.61,'2022-09-17 07:10:47','',''),(7525,'1','277','1',1,'Retail Sale Id 7490',9100.00,0.00,0.00,12.50,662.50,'2022-09-17 07:19:37','',''),(7526,'1','277','1',1,'Retail Sale Id 7491',9100.00,0.00,0.00,12.50,662.50,'2022-09-17 07:27:19','',''),(7527,'1','277','1',1,'Retail Sale Id 7492',2002.00,0.00,0.00,2.75,145.75,'2022-09-17 07:31:45','',''),(7528,'1','277','1',1,'Retail Sale Id 7493',997.36,0.00,0.00,1.37,72.61,'2022-09-17 08:06:40','',''),(7529,'1','277','1',1,'Retail Sale Id 7494',2999.36,0.00,0.00,4.12,218.36,'2022-09-17 08:07:29','',''),(7530,'1','277','1',1,'Retail Sale Id 7495',2002.00,0.00,0.00,2.75,145.75,'2022-09-17 08:14:14','',''),(7531,'1','277','1',1,'Retail Sale Id 7496',2198.56,0.00,0.00,3.02,160.06,'2022-09-17 08:15:43','',''),(7532,'1','277','1',1,'Retail Sale Id 7497',4397.12,0.00,0.00,6.04,320.12,'2022-09-17 08:17:55','',''),(7533,'1','277','1',1,'Retail Sale Id 7498',997.36,0.00,0.00,1.37,72.61,'2022-09-17 08:20:20','',''),(7534,'1','277','1',1,'Retail Sale Id 7499',997.36,0.00,0.00,1.37,72.61,'2022-09-17 08:21:33','',''),(7535,'1','277','1',1,'Retail Sale Id 7500',997.36,0.00,0.00,1.37,72.61,'2022-09-17 08:22:54','',''),(7536,'1','277','1',1,'Retail Sale Id 7501',3996.72,0.00,0.00,5.49,290.97,'2022-09-17 08:23:49','',''),(7537,'1','277','1',1,'Retail Sale Id 7502',1499.68,0.00,0.00,2.06,109.18,'2022-09-17 08:29:18','',''),(7538,'1','277','1',1,'Retail Sale Id 7503',9100.00,0.00,0.00,12.50,662.50,'2022-09-17 08:31:59','',''),(7539,'1','277','1',1,'Retail Sale Id 7504',3996.72,0.00,0.00,5.49,290.97,'2022-09-17 08:33:21','',''),(7540,'1','277','1',1,'Retail Sale Id 7505',1499.68,0.00,0.00,2.06,109.18,'2022-09-17 08:35:20','',''),(7541,'1','277','1',1,'Retail Sale Id 7506',3698.24,0.00,0.00,5.08,269.24,'2022-09-17 08:36:52','',''),(7542,'1','277','1',1,'Retail Sale Id 7507',4397.12,0.00,0.00,6.04,320.12,'2022-09-17 08:41:13','',''),(7543,'1','277','1',1,'Retail Sale Id 7508',1499.68,0.00,0.00,2.06,109.18,'2022-09-17 08:42:17','',''),(7544,'1','277','1',1,'Retail Sale Id 7509',5998.72,0.00,0.00,8.24,436.72,'2022-09-17 08:51:24','',''),(7545,'1','277','1',1,'Retail Sale Id 7510',2999.36,0.00,0.00,4.12,218.36,'2022-09-17 09:04:02','',''),(7546,'1','277','1',1,'Retail Sale Id 7511',8998.08,0.00,0.00,12.36,655.08,'2022-09-17 09:04:55','',''),(7547,'1','277','1',1,'Retail Sale Id 7512',4302.48,0.00,0.00,5.91,313.23,'2022-09-17 09:06:17','',''),(7548,'1','277','1',1,'Retail Sale Id 7513',6552.00,0.00,0.00,9.00,477.00,'2022-09-17 09:17:58','',''),(7549,'1','277','1',1,'Retail Sale Id 7514',997.36,0.00,0.00,1.37,72.61,'2022-09-17 09:19:56','',''),(7550,'1','277','1',1,'Retail Sale Id 7515',2198.56,0.00,0.00,3.02,160.06,'2022-09-17 09:29:01','',''),(7551,'1','277','1',1,'Retail Sale Id 7515',3640.00,0.00,0.00,5.00,265.00,'2022-09-17 09:29:01','',''),(7552,'1','277','1',1,'Retail Sale Id 7516',2198.56,0.00,0.00,3.02,160.06,'2022-09-17 09:33:01','',''),(7553,'1','277','1',1,'Retail Sale Id 7517',749.84,0.00,0.00,1.03,54.59,'2022-09-17 09:35:24','',''),(7554,'1','277','1',1,'Retail Sale Id 7518',2198.56,0.00,0.00,3.02,160.06,'2022-09-17 09:48:56','',''),(7555,'1','277','1',1,'Retail Sale Id 7519',1499.68,0.00,0.00,2.06,109.18,'2022-09-17 09:57:15','',''),(7556,'1','277','1',1,'Retail Sale Id 7520',1499.68,0.00,0.00,2.06,109.18,'2022-09-17 09:58:17','',''),(7557,'1','277','1',1,'Retail Sale Id 7521',800.80,0.00,0.00,1.10,58.30,'2022-09-17 10:10:56','',''),(7558,'1','277','1',1,'Retail Sale Id 7522',2198.56,0.00,0.00,3.02,160.06,'2022-09-17 10:14:43','',''),(7559,'1','277','1',1,'Retail Sale Id 7523',2497.04,0.00,0.00,3.43,181.79,'2022-09-17 10:15:16','',''),(7560,'1','277','1',1,'Retail Sale Id 7524',4397.12,0.00,0.00,6.04,320.12,'2022-09-17 10:16:05','',''),(7561,'1','277','1',1,'Retail Sale Id 7525',4397.12,0.00,0.00,6.04,320.12,'2022-09-17 10:20:56','',''),(7562,'1','277','1',1,'Retail Sale Id 7526',2198.56,0.00,0.00,3.02,160.06,'2022-09-17 10:28:22','',''),(7563,'1','277','1',1,'Retail Sale Id 7527',29498.56,0.00,0.00,40.52,2147.56,'2022-09-17 10:33:32','',''),(7564,'1','277','1',1,'Retail Sale Id 7528',2002.00,0.00,0.00,2.75,145.75,'2022-09-17 10:35:23','',''),(7565,'1','277','1',1,'Retail Sale Id 7529',2002.00,0.00,0.00,2.75,145.75,'2022-09-17 10:36:02','',''),(7566,'1','277','1',1,'Retail Sale Id 7530',2002.00,0.00,0.00,2.75,145.75,'2022-09-17 10:40:34','',''),(7567,'1','277','1',1,'Retail Sale Id 7531',2002.00,0.00,0.00,2.75,145.75,'2022-09-17 10:44:51','',''),(7568,'1','277','1',1,'Retail Sale Id 7532',2999.36,0.00,0.00,4.12,218.36,'2022-09-17 10:54:56','',''),(7569,'1','277','1',1,'Retail Sale Id 7533',2198.56,0.00,0.00,3.02,160.06,'2022-09-17 10:59:23','',''),(7570,'1','277','1',1,'Retail Sale Id 7534',3603.60,0.00,0.00,4.95,262.35,'2022-09-17 11:04:56','',''),(7571,'1','277','1',1,'Retail Sale Id 7535',4397.12,0.00,0.00,6.04,320.12,'2022-09-17 11:05:45','',''),(7572,'1','277','1',1,'Retail Sale Id 7536',9100.00,0.00,0.00,12.50,662.50,'2022-09-17 11:07:49','',''),(7573,'1','277','1',1,'Retail Sale Id 7537',3647.28,0.00,0.00,5.01,265.53,'2022-09-17 11:08:59','',''),(7574,'1','277','1',1,'Retail Sale Id 7538',4397.12,0.00,0.00,6.04,320.12,'2022-09-17 11:11:39','',''),(7575,'1','277','1',1,'Retail Sale Id 7539',800.80,0.00,0.00,1.10,58.30,'2022-09-17 11:12:43','',''),(7576,'1','277','1',1,'Retail Sale Id 7540',4397.12,0.00,0.00,6.04,320.12,'2022-09-17 11:14:50','',''),(7577,'1','277','1',1,'Retail Sale Id 7541',997.36,0.00,0.00,1.37,72.61,'2022-09-17 11:16:41','',''),(7578,'1','277','1',1,'Retail Sale Id 7542',997.36,0.00,0.00,1.37,72.61,'2022-09-17 11:18:15','',''),(7579,'1','277','1',1,'Retail Sale Id 7543',1499.68,0.00,0.00,2.06,109.18,'2022-09-17 11:25:38','',''),(7580,'1','277','1',1,'Retail Sale Id 7544',1499.68,0.00,0.00,2.06,109.18,'2022-09-17 11:27:36','',''),(7581,'1','277','1',1,'Retail Sale Id 7545',2002.00,0.00,0.00,2.75,145.75,'2022-09-17 11:31:32','',''),(7582,'1','277','1',1,'Retail Sale Id 7546',2002.00,0.00,0.00,2.75,145.75,'2022-09-17 11:33:22','',''),(7583,'1','277','1',1,'Retail Sale Id 7547',4397.12,0.00,0.00,6.04,320.12,'2022-09-17 11:34:47','',''),(7584,'1','277','1',1,'Retail Sale Id 7548',1201.20,0.00,0.00,1.65,87.45,'2022-09-17 11:44:42','',''),(7585,'1','277','1',1,'Retail Sale Id 7549',698.88,0.00,0.00,0.96,50.88,'2022-09-17 11:45:57','',''),(7586,'1','277','1',1,'Retail Sale Id 7550',997.36,0.00,0.00,1.37,72.61,'2022-09-17 11:46:41','',''),(7587,'1','277','1',1,'Retail Sale Id 7551',2999.36,0.00,0.00,4.12,218.36,'2022-09-17 11:48:33','',''),(7588,'1','277','1',1,'Retail Sale Id 7552',3501.68,0.00,0.00,4.81,254.93,'2022-09-17 11:55:54','',''),(7589,'1','277','1',1,'Retail Sale Id 7553',2002.00,0.00,0.00,2.75,145.75,'2022-09-17 11:56:36','',''),(7590,'1','277','1',1,'Retail Sale Id 7554',5001.36,0.00,0.00,6.87,364.11,'2022-09-17 11:58:14','',''),(7591,'1','277','1',1,'Retail Sale Id 7555',9100.00,0.00,0.00,12.50,662.50,'2022-09-17 12:00:06','',''),(7592,'1','277','1',1,'Retail Sale Id 7556',9100.00,0.00,0.00,12.50,662.50,'2022-09-17 12:01:26','',''),(7593,'1','277','1',1,'Retail Sale Id 7557',1798.16,0.00,0.00,2.47,130.91,'2022-09-17 12:03:14','',''),(7594,'1','277','1',1,'Retail Sale Id 7558',2002.00,0.00,0.00,2.75,145.75,'2022-09-17 12:11:20','',''),(7595,'1','277','1',1,'Retail Sale Id 7559',1499.68,0.00,0.00,2.06,109.18,'2022-09-17 12:17:44','',''),(7596,'1','277','1',1,'Retail Sale Id 7560',5001.36,0.00,0.00,6.87,364.11,'2022-09-17 12:21:39','',''),(7597,'1','277','1',1,'Retail Sale Id 7561',3501.68,0.00,0.00,4.81,254.93,'2022-09-17 12:27:36','',''),(7598,'1','277','1',1,'Retail Sale Id 7562',2999.36,0.00,0.00,4.12,218.36,'2022-09-17 12:28:20','',''),(7599,'1','277','1',1,'Retail Sale Id 7563',4397.12,0.00,0.00,6.04,320.12,'2022-09-17 12:32:13','',''),(7600,'1','277','1',1,'Retail Sale Id 7564',9100.00,0.00,0.00,12.50,662.50,'2022-09-17 12:41:30','',''),(7601,'1','277','1',1,'Retail Sale Id 7565',997.36,0.00,0.00,1.37,72.61,'2022-09-17 12:42:12','',''),(7602,'1','277','1',1,'Retail Sale Id 7566',5896.80,0.00,0.00,8.10,429.30,'2022-09-17 12:49:32','',''),(7603,'1','277','1',1,'Retail Sale Id 7567',502.32,0.00,0.00,0.69,36.57,'2022-09-17 12:51:54','',''),(7604,'1','277','1',1,'Retail Sale Id 7568',3698.24,0.00,0.00,5.08,269.24,'2022-09-17 12:55:45','',''),(7605,'1','277','1',1,'Retail Sale Id 7569',4397.12,0.00,0.00,6.04,320.12,'2022-09-17 12:58:44','',''),(7606,'1','277','1',1,'Retail Sale Id 7570',997.36,0.00,0.00,1.37,72.61,'2022-09-17 12:59:53','',''),(7607,'1','277','1',1,'Retail Sale Id 7571',2919.28,0.00,0.00,4.01,212.53,'2022-09-17 13:06:25','',''),(7608,'1','277','1',1,'Retail Sale Id 7572',1499.68,0.00,0.00,2.06,109.18,'2022-09-17 13:07:56','',''),(7609,'1','277','1',1,'Retail Sale Id 7573',2198.56,0.00,0.00,3.02,160.06,'2022-09-17 13:08:27','',''),(7610,'1','277','1',1,'Retail Sale Id 7574',2999.36,0.00,0.00,4.12,218.36,'2022-09-17 13:09:48','',''),(7611,'1','277','1',1,'Retail Sale Id 7575',997.36,0.00,0.00,1.37,72.61,'2022-09-17 13:20:07','',''),(7612,'1','277','1',1,'Retail Sale Id 7576',4397.12,0.00,0.00,6.04,320.12,'2022-09-17 13:27:53','',''),(7613,'1','277','1',1,'Retail Sale Id 7577',9100.00,0.00,0.00,12.50,662.50,'2022-09-17 13:28:59','',''),(7614,'1','277','1',1,'Retail Sale Id 7578',4397.12,0.00,0.00,6.04,320.12,'2022-09-17 13:30:02','',''),(7615,'1','277','1',1,'Retail Sale Id 7579',2198.56,0.00,0.00,3.02,160.06,'2022-09-17 13:34:05','',''),(7616,'1','277','1',1,'Retail Sale Id 7579',4397.12,0.00,0.00,6.04,320.12,'2022-09-17 13:34:05','',''),(7617,'1','277','1',1,'Retail Sale Id 7579',9100.00,0.00,0.00,12.50,662.50,'2022-09-17 13:34:05','',''),(7618,'1','277','1',1,'Retail Sale Id 7580',1499.68,0.00,0.00,2.06,109.18,'2022-09-17 13:35:58','',''),(7619,'1','277','1',1,'Retail Sale Id 7581',1499.68,0.00,0.00,2.06,109.18,'2022-09-17 13:36:52','',''),(7620,'1','277','1',1,'Retail Sale Id 7582',2198.56,0.00,0.00,3.02,160.06,'2022-09-17 13:41:04','',''),(7621,'1','277','1',1,'Retail Sale Id 7583',4499.04,0.00,0.00,6.18,327.54,'2022-09-17 13:43:49','',''),(7622,'1','277','1',1,'Retail Sale Id 7584',2198.56,0.00,0.00,3.02,160.06,'2022-09-17 13:44:43','',''),(7623,'1','277','1',1,'Retail Sale Id 7585',502.32,0.00,0.00,0.69,36.57,'2022-09-17 13:45:42','',''),(7624,'1','277','1',1,'Retail Sale Id 7586',9100.00,0.00,0.00,12.50,662.50,'2022-09-17 13:47:34','',''),(7625,'1','277','1',1,'Retail Sale Id 7587',9100.00,0.00,0.00,12.50,662.50,'2022-09-17 13:48:41','',''),(7626,'1','277','1',1,'Retail Sale Id 7588',2198.56,0.00,0.00,3.02,160.06,'2022-09-17 13:49:58','',''),(7627,'1','277','1',1,'Retail Sale Id 7589',1499.68,0.00,0.00,2.06,109.18,'2022-09-17 14:01:25','',''),(7628,'1','277','1',1,'Retail Sale Id 7590',9100.00,0.00,0.00,12.50,662.50,'2022-09-17 14:05:58','',''),(7629,'1','277','1',1,'Retail Sale Id 7591',2999.36,0.00,0.00,4.12,218.36,'2022-09-17 14:06:42','',''),(7630,'1','277','1',1,'Retail Sale Id 7592',1499.68,0.00,0.00,2.06,109.18,'2022-09-17 14:07:26','',''),(7631,'1','277','1',1,'Retail Sale Id 7593',1499.68,0.00,0.00,2.06,109.18,'2022-09-17 14:10:03','',''),(7632,'1','277','1',1,'Retail Sale Id 7594',2999.36,0.00,0.00,4.12,218.36,'2022-09-17 14:13:55','',''),(7633,'1','277','1',1,'Retail Sale Id 7595',43680.00,0.00,0.00,60.00,3180.00,'2022-09-17 14:16:00','',''),(7634,'1','277','1',1,'Retail Sale Id 7596',1499.68,0.00,0.00,2.06,109.18,'2022-09-17 14:16:38','',''),(7635,'1','277','1',1,'Retail Sale Id 7597',2002.00,0.00,0.00,2.75,145.75,'2022-09-17 14:17:09','',''),(7636,'1','277','1',1,'Retail Sale Id 7598',3698.24,0.00,0.00,5.08,269.24,'2022-09-17 14:17:52','',''),(7637,'1','277','1',1,'Retail Sale Id 7599',997.36,0.00,0.00,1.37,72.61,'2022-09-17 14:18:29','',''),(7638,'1','277','1',1,'Retail Sale Id 7600',2700.88,0.00,0.00,3.71,196.63,'2022-09-17 14:22:00','',''),(7639,'1','277','1',1,'Retail Sale Id 7601',997.36,0.00,0.00,1.37,72.61,'2022-09-17 14:31:35','',''),(7640,'1','277','1',1,'Retail Sale Id 7602',1499.68,0.00,0.00,2.06,109.18,'2022-09-17 14:36:40','',''),(7641,'1','277','1',1,'Retail Sale Id 7603',2002.00,0.00,0.00,2.75,145.75,'2022-09-17 14:39:44','',''),(7642,'1','277','1',1,'Retail Sale Id 7604',2198.56,0.00,0.00,3.02,160.06,'2022-09-17 14:42:46','',''),(7643,'1','277','1',1,'Retail Sale Id 7605',1499.68,0.00,0.00,2.06,109.18,'2022-09-17 15:09:26','',''),(7644,'1','277','1',1,'Retail Sale Id 7606',3647.28,0.00,0.00,5.01,265.53,'2022-09-17 15:13:35','',''),(7645,'1','277','1',1,'Retail Sale Id 7607',4397.12,0.00,0.00,6.04,320.12,'2022-09-17 15:14:06','',''),(7646,'1','277','1',1,'Retail Sale Id 7608',2198.56,0.00,0.00,3.02,160.06,'2022-09-17 15:22:34','',''),(7647,'1','277','1',1,'Retail Sale Id 7609',997.36,0.00,0.00,1.37,72.61,'2022-09-17 15:23:42','',''),(7648,'1','277','1',1,'Retail Sale Id 7610',1499.68,0.00,0.00,2.06,109.18,'2022-09-17 15:33:42','',''),(7649,'1','277','1',1,'Retail Sale Id 7611',2999.36,0.00,0.00,4.12,218.36,'2022-09-17 15:39:40','',''),(7650,'1','277','1',1,'Retail Sale Id 7612',7280.00,0.00,0.00,10.00,530.00,'2022-09-17 15:45:28','',''),(7651,'1','277','1',1,'Retail Sale Id 7613',9100.00,0.00,0.00,12.50,662.50,'2022-09-17 15:46:37','',''),(7652,'1','277','1',1,'Retail Sale Id 7614',4397.12,0.00,0.00,6.04,320.12,'2022-09-17 15:48:13','',''),(7653,'1','277','1',1,'Retail Sale Id 7615',1499.68,0.00,0.00,2.06,109.18,'2022-09-17 15:48:46','',''),(7654,'1','277','1',1,'Retail Sale Id 7616',5001.36,0.00,0.00,6.87,364.11,'2022-09-17 15:49:37','',''),(7655,'1','277','1',1,'Retail Sale Id 7617',2198.56,0.00,0.00,3.02,160.06,'2022-09-17 15:56:19','',''),(7656,'1','277','1',1,'Retail Sale Id 7618',4397.12,0.00,0.00,6.04,320.12,'2022-09-17 15:59:11','',''),(7657,'1','277','1',1,'Retail Sale Id 7619',2002.00,0.00,0.00,2.75,145.75,'2022-09-17 15:59:55','',''),(7658,'1','277','1',1,'Retail Sale Id 7620',3996.72,0.00,0.00,5.49,290.97,'2022-09-17 16:11:48','',''),(7659,'1','277','1',1,'Retail Sale Id 7621',800.80,0.00,0.00,1.10,58.30,'2022-09-17 16:18:45','',''),(7660,'1','277','1',1,'Retail Sale Id 7622',902.72,0.00,0.00,1.24,65.72,'2022-09-17 16:20:13','',''),(7661,'1','277','1',1,'Retail Sale Id 7623',997.36,0.00,0.00,1.37,72.61,'2022-09-17 16:26:02','',''),(7662,'1','277','1',1,'Retail Sale Id 7624',8000.72,0.00,0.00,10.99,582.47,'2022-09-17 16:30:06','',''),(7663,'1','277','1',1,'Retail Sale Id 7625',1499.68,0.00,0.00,2.06,109.18,'2022-09-17 16:34:37','',''),(7664,'1','277','1',1,'Retail Sale Id 7626',9100.00,0.00,0.00,12.50,662.50,'2022-09-17 16:43:57','',''),(7665,'1','277','1',1,'Retail Sale Id 7627',4397.12,0.00,0.00,6.04,320.12,'2022-09-17 16:50:13','',''),(7666,'1','277','1',1,'Retail Sale Id 7628',1499.68,0.00,0.00,2.06,109.18,'2022-09-17 16:54:58','',''),(7667,'1','277','1',1,'Retail Sale Id 7629',2002.00,0.00,0.00,2.75,145.75,'2022-09-17 16:55:30','',''),(7668,'1','277','1',1,'Retail Sale Id 7630',4397.12,0.00,0.00,6.04,320.12,'2022-09-17 16:56:33','',''),(7669,'1','277','1',1,'Retail Sale Id 7631',2999.36,0.00,0.00,4.12,218.36,'2022-09-17 16:57:03','',''),(7670,'1','277','1',1,'Retail Sale Id 7632',1499.68,0.00,0.00,2.06,109.18,'2022-09-17 16:57:39','',''),(7671,'1','277','1',1,'Retail Sale Id 7633',2198.56,0.00,0.00,3.02,160.06,'2022-09-17 16:58:36','',''),(7672,'1','277','1',1,'Retail Sale Id 7633',2198.56,0.00,0.00,3.02,160.06,'2022-09-17 16:58:36','',''),(7673,'1','277','1',1,'Retail Sale Id 7634',997.36,0.00,0.00,1.37,72.61,'2022-09-17 16:59:12','',''),(7674,'1','277','1',1,'Retail Sale Id 7635',749.84,0.00,0.00,1.03,54.59,'2022-09-17 17:00:41','',''),(7675,'1','277','1',1,'Retail Sale Id 7635',749.84,0.00,0.00,1.03,54.59,'2022-09-17 17:00:41','',''),(7676,'1','277','1',1,'Retail Sale Id 7636',5001.36,0.00,0.00,6.87,364.11,'2022-09-17 17:03:37','',''),(7677,'1','277','1',1,'Retail Sale Id 7637',4397.12,0.00,0.00,6.04,320.12,'2022-09-17 17:07:27','',''),(7678,'1','277','1',1,'Retail Sale Id 7638',2002.00,0.00,0.00,2.75,145.75,'2022-09-17 17:12:46','',''),(7679,'1','277','1',1,'Retail Sale Id 7639',1499.68,0.00,0.00,2.06,109.18,'2022-09-17 17:13:20','',''),(7680,'1','277','1',1,'Retail Sale Id 7640',2999.36,0.00,0.00,4.12,218.36,'2022-09-17 17:13:56','',''),(7681,'1','277','1',1,'Retail Sale Id 7641',14501.76,0.00,0.00,19.92,1055.76,'2022-09-17 17:20:35','',''),(7682,'1','277','1',1,'Retail Sale Id 7642',1499.68,0.00,0.00,2.06,109.18,'2022-09-17 17:21:28','',''),(7683,'1','277','1',1,'Retail Sale Id 7643',997.36,0.00,0.00,1.37,72.61,'2022-09-17 17:22:26','',''),(7684,'1','277','1',1,'Retail Sale Id 7644',2999.36,0.00,0.00,4.12,218.36,'2022-09-17 17:23:01','',''),(7685,'1','277','1',1,'Retail Sale Id 7645',7301.84,0.00,0.00,10.03,531.59,'2022-09-17 17:24:13','',''),(7686,'1','277','1',1,'Retail Sale Id 7646',3996.72,0.00,0.00,5.49,290.97,'2022-09-17 17:25:22','',''),(7687,'1','277','1',1,'Retail Sale Id 7647',1601.60,0.00,0.00,2.20,116.60,'2022-09-17 17:27:12','',''),(7688,'1','277','1',1,'Retail Sale Id 7648',749.84,0.00,0.00,1.03,54.59,'2022-09-17 17:27:45','',''),(7689,'1','277','1',1,'Retail Sale Id 7649',2002.00,0.00,0.00,2.75,145.75,'2022-09-17 17:32:26','',''),(7690,'1','277','1',1,'Retail Sale Id 7650',9100.00,0.00,0.00,12.50,662.50,'2022-09-17 17:32:55','',''),(7691,'1','277','1',1,'Retail Sale Id 7651',749.84,0.00,0.00,1.03,54.59,'2022-09-17 17:34:58','',''),(7692,'1','277','1',1,'Retail Sale Id 7652',2999.36,0.00,0.00,4.12,218.36,'2022-09-17 17:35:38','',''),(7693,'1','277','1',1,'Retail Sale Id 7653',2198.56,0.00,0.00,3.02,160.06,'2022-09-17 17:41:06','',''),(7694,'1','277','1',1,'Retail Sale Id 7654',2002.00,0.00,0.00,2.75,145.75,'2022-09-17 17:42:58','',''),(7695,'1','277','1',1,'Retail Sale Id 7655',1499.68,0.00,0.00,2.06,109.18,'2022-09-17 17:45:06','',''),(7696,'1','277','1',1,'Retail Sale Id 7656',2198.56,0.00,0.00,3.02,160.06,'2022-09-17 17:46:20','',''),(7697,'1','277','1',1,'Retail Sale Id 7657',2497.04,0.00,0.00,3.43,181.79,'2022-09-17 17:47:40','',''),(7698,'1','277','1',1,'Retail Sale Id 7658',1397.76,0.00,0.00,1.92,101.76,'2022-09-17 17:49:02','',''),(7699,'1','277','1',1,'Retail Sale Id 7659',2198.56,0.00,0.00,3.02,160.06,'2022-09-17 17:52:09','',''),(7700,'1','277','1',1,'Retail Sale Id 7660',9100.00,0.00,0.00,12.50,662.50,'2022-09-17 17:56:40','',''),(7701,'1','277','1',1,'Retail Sale Id 7661',749.84,0.00,0.00,1.03,54.59,'2022-09-17 18:00:44','',''),(7702,'1','277','1',1,'Retail Sale Id 7662',5001.36,0.00,0.00,6.87,364.11,'2022-09-17 18:03:37','',''),(7703,'1','277','1',1,'Retail Sale Id 7663',11000.08,0.00,0.00,15.11,800.83,'2022-09-17 18:05:49','',''),(7704,'1','277','1',1,'Retail Sale Id 7664',997.36,0.00,0.00,1.37,72.61,'2022-09-17 18:09:39','',''),(7705,'1','277','1',1,'Retail Sale Id 7665',5103.28,0.00,0.00,7.01,371.53,'2022-09-17 18:16:38','',''),(7706,'1','277','1',1,'Retail Sale Id 7666',4397.12,0.00,0.00,6.04,320.12,'2022-09-17 18:18:41','',''),(7707,'1','277','1',1,'Retail Sale Id 7667',997.36,0.00,0.00,1.37,72.61,'2022-09-17 18:22:26','',''),(7708,'1','277','1',1,'Retail Sale Id 7668',997.36,0.00,0.00,1.37,72.61,'2022-09-17 18:23:31','',''),(7709,'1','277','1',1,'Retail Sale Id 7669',1463.28,0.00,0.00,2.01,106.53,'2022-09-17 18:30:41','',''),(7710,'1','277','1',1,'Retail Sale Id 7669',3640.00,0.00,0.00,5.00,265.00,'2022-09-17 18:30:41','',''),(7711,'1','277','1',1,'Retail Sale Id 7670',728.00,0.00,0.00,1.00,53.00,'2022-09-17 18:36:26','',''),(7712,'1','277','1',1,'Retail Sale Id 7670',3640.00,0.00,0.00,5.00,265.00,'2022-09-17 18:36:26','',''),(7713,'1','277','1',1,'Retail Sale Id 7671',2999.36,0.00,0.00,4.12,218.36,'2022-09-17 18:37:39','',''),(7714,'1','277','1',1,'Retail Sale Id 7672',1456.00,0.00,0.00,2.00,106.00,'2022-09-17 18:38:55','',''),(7715,'1','277','1',1,'Retail Sale Id 7672',1456.00,0.00,0.00,2.00,106.00,'2022-09-17 18:38:55','',''),(7716,'1','277','1',1,'Retail Sale Id 7673',1499.68,0.00,0.00,2.06,109.18,'2022-09-17 18:40:18','',''),(7717,'1','277','1',1,'Retail Sale Id 7674',2198.56,0.00,0.00,3.02,160.06,'2022-09-17 18:41:29','',''),(7718,'1','277','1',1,'Retail Sale Id 7675',1397.76,0.00,0.00,1.92,101.76,'2022-09-17 18:42:11','',''),(7719,'1','277','1',1,'Retail Sale Id 7676',2198.56,0.00,0.00,3.02,160.06,'2022-09-17 18:42:52','',''),(7720,'1','277','1',1,'Retail Sale Id 7677',6552.00,0.00,0.00,9.00,477.00,'2022-09-17 18:43:23','',''),(7721,'1','277','1',1,'Retail Sale Id 7678',1499.68,0.00,0.00,2.06,109.18,'2022-09-17 18:43:59','',''),(7722,'1','277','1',1,'Retail Sale Id 7679',4397.12,0.00,0.00,6.04,320.12,'2022-09-17 18:44:39','',''),(7723,'1','277','1',1,'Retail Sale Id 7680',2002.00,0.00,0.00,2.75,145.75,'2022-09-17 18:45:10','',''),(7724,'1','277','1',1,'Retail Sale Id 7681',1303.12,0.00,0.00,1.79,94.87,'2022-09-17 18:45:59','',''),(7725,'1','277','1',1,'Retail Sale Id 7682',2002.00,0.00,0.00,2.75,145.75,'2022-09-17 18:46:38','',''),(7726,'1','277','1',1,'Retail Sale Id 7683',3640.00,0.00,0.00,5.00,265.00,'2022-09-17 18:47:33','',''),(7727,'1','277','1',1,'Retail Sale Id 7684',2999.36,0.00,0.00,4.12,218.36,'2022-09-17 18:49:35','',''),(7728,'1','277','1',1,'Retail Sale Id 7685',3640.00,0.00,0.00,5.00,265.00,'2022-09-17 18:50:16','',''),(7729,'1','277','1',1,'Retail Sale Id 7686',2198.56,0.00,0.00,3.02,160.06,'2022-09-17 18:50:56','',''),(7730,'1','277','1',1,'Retail Sale Id 7687',3698.24,0.00,0.00,5.08,269.24,'2022-09-17 18:53:25','',''),(7731,'1','277','1',1,'Retail Sale Id 7688',3996.72,0.00,0.00,5.49,290.97,'2022-09-17 19:00:46','',''),(7732,'1','277','1',1,'Retail Sale Id 7689',87.36,0.00,0.00,0.12,6.36,'2022-09-17 19:02:22','',''),(7733,'1','277','1',1,'Retail Sale Id 7690',2002.00,0.00,0.00,2.75,145.75,'2022-09-17 19:06:00','',''),(7734,'1','277','1',1,'Retail Sale Id 7691',2198.56,0.00,0.00,3.02,160.06,'2022-09-17 19:06:32','',''),(7735,'1','277','1',1,'Retail Sale Id 7692',1499.68,0.00,0.00,2.06,109.18,'2022-09-17 19:07:07','',''),(7736,'1','277','1',1,'Retail Sale Id 7693',502.32,0.00,0.00,0.69,36.57,'2022-09-17 19:07:37','',''),(7737,'1','277','1',1,'Retail Sale Id 7694',2999.36,0.00,0.00,4.12,218.36,'2022-09-17 19:08:53','',''),(7738,'1','277','1',1,'Return of Retail Sale Id 7669',0.00,1463.28,2.01,0.00,-106.53,'2022-09-17 19:11:42','',''),(7739,'1','277','1',1,'Return of Retail Sale Id 7669',0.00,3640.00,5.00,0.00,-265.00,'2022-09-17 19:11:42','',''),(7740,'1','277','1',1,'Return of Retail Sale Id 7665',0.00,5103.28,7.01,0.00,-371.53,'2022-09-17 19:13:12','',''),(7741,'1','277','1',1,'Retail Sale Id 7695',3996.72,0.00,0.00,5.49,290.97,'2022-09-17 19:15:57','',''),(7742,'1','277','1',1,'Retail Sale Id 7696',3640.00,0.00,0.00,5.00,265.00,'2022-09-17 19:19:50','',''),(7743,'1','277','1',1,'Retail Sale Id 7697',997.36,0.00,0.00,1.37,72.61,'2022-09-17 19:26:26','',''),(7744,'1','277','1',1,'Retail Sale Id 7698',225.68,0.00,0.00,0.31,16.43,'2022-09-17 19:38:29','',''),(7745,'1','277','1',1,'Retail Sale Id 7699',2002.00,0.00,0.00,2.75,145.75,'2022-09-18 06:28:34','',''),(7746,'1','277','1',1,'Retail Sale Id 7700',9100.00,0.00,0.00,12.50,662.50,'2022-09-18 06:37:16','',''),(7747,'1','277','1',1,'Retail Sale Id 7701',3996.72,0.00,0.00,5.49,290.97,'2022-09-18 06:57:57','',''),(7748,'1','277','1',1,'Retail Sale Id 7702',3996.72,0.00,0.00,5.49,290.97,'2022-09-18 07:01:46','',''),(7749,'1','277','1',1,'Retail Sale Id 7703',1397.76,0.00,0.00,1.92,101.76,'2022-09-18 07:03:14','',''),(7750,'1','277','1',1,'Retail Sale Id 7703',1397.76,0.00,0.00,1.92,101.76,'2022-09-18 07:03:14','',''),(7751,'1','277','1',1,'Retail Sale Id 7704',749.84,0.00,0.00,1.03,54.59,'2022-09-18 07:09:23','',''),(7752,'1','277','1',1,'Retail Sale Id 7705',1499.68,0.00,0.00,2.06,109.18,'2022-09-18 07:22:28','',''),(7753,'1','277','1',1,'Retail Sale Id 7706',2198.56,0.00,0.00,3.02,160.06,'2022-09-18 07:46:42','',''),(7754,'1','277','1',1,'Retail Sale Id 7707',2198.56,0.00,0.00,3.02,160.06,'2022-09-18 07:49:18','',''),(7755,'1','277','1',1,'Retail Sale Id 7707',4397.12,0.00,0.00,6.04,320.12,'2022-09-18 07:49:18','',''),(7756,'1','277','1',1,'Retail Sale Id 7708',2999.36,0.00,0.00,4.12,218.36,'2022-09-18 07:55:18','',''),(7757,'1','277','1',1,'Retail Sale Id 7709',2002.00,0.00,0.00,2.75,145.75,'2022-09-18 07:55:49','',''),(7758,'1','277','1',1,'Retail Sale Id 7710',2198.56,0.00,0.00,3.02,160.06,'2022-09-18 07:58:32','',''),(7759,'1','277','1',1,'Retail Sale Id 7711',9100.00,0.00,0.00,12.50,662.50,'2022-09-18 08:01:19','',''),(7760,'1','277','1',1,'Retail Sale Id 7712',502.32,0.00,0.00,0.69,36.57,'2022-09-18 08:03:28','',''),(7761,'1','277','1',1,'Retail Sale Id 7713',2002.00,0.00,0.00,2.75,145.75,'2022-09-18 08:14:06','',''),(7762,'1','277','1',1,'Retail Sale Id 7714',3996.72,0.00,0.00,5.49,290.97,'2022-09-18 08:15:13','',''),(7763,'1','277','1',1,'Retail Sale Id 7715',2999.36,0.00,0.00,4.12,218.36,'2022-09-18 08:18:07','',''),(7764,'1','277','1',1,'Retail Sale Id 7716',4397.12,0.00,0.00,6.04,320.12,'2022-09-18 08:19:27','',''),(7765,'1','277','1',1,'Retail Sale Id 7717',2999.36,0.00,0.00,4.12,218.36,'2022-09-18 08:25:55','',''),(7766,'1','277','1',1,'Retail Sale Id 7718',2002.00,0.00,0.00,2.75,145.75,'2022-09-18 08:26:29','',''),(7767,'1','277','1',1,'Retail Sale Id 7720',698.88,0.00,0.00,0.96,50.88,'2022-09-18 08:30:08','',''),(7768,'1','277','1',1,'Retail Sale Id 7720',2999.36,0.00,0.00,4.12,218.36,'2022-09-18 08:30:08','',''),(7769,'1','277','1',1,'Retail Sale Id 7721',2198.56,0.00,0.00,3.02,160.06,'2022-09-18 08:30:52','',''),(7770,'1','277','1',1,'Retail Sale Id 7722',1499.68,0.00,0.00,2.06,109.18,'2022-09-18 08:34:03','',''),(7771,'1','277','1',1,'Retail Sale Id 7723',1499.68,0.00,0.00,2.06,109.18,'2022-09-18 08:36:35','',''),(7772,'1','277','1',1,'Retail Sale Id 7724',997.36,0.00,0.00,1.37,72.61,'2022-09-18 08:40:15','',''),(7773,'1','277','1',1,'Retail Sale Id 7725',2999.36,0.00,0.00,4.12,218.36,'2022-09-18 08:42:21','',''),(7774,'1','277','1',1,'Retail Sale Id 7726',1499.68,0.00,0.00,2.06,109.18,'2022-09-18 08:42:58','',''),(7775,'1','277','1',1,'Retail Sale Id 7727',2198.56,0.00,0.00,3.02,160.06,'2022-09-18 08:47:30','',''),(7776,'1','277','1',1,'Retail Sale Id 7728',4397.12,0.00,0.00,6.04,320.12,'2022-09-18 08:51:39','',''),(7777,'1','277','1',1,'Retail Sale Id 7729',997.36,0.00,0.00,1.37,72.61,'2022-09-18 08:52:30','',''),(7778,'1','277','1',1,'Retail Sale Id 7730',4397.12,0.00,0.00,6.04,320.12,'2022-09-18 08:53:51','',''),(7779,'1','277','1',1,'Retail Sale Id 7731',1499.68,0.00,0.00,2.06,109.18,'2022-09-18 08:54:29','',''),(7780,'1','277','1',1,'Retail Sale Id 7732',997.36,0.00,0.00,1.37,72.61,'2022-09-18 08:56:45','',''),(7781,'1','277','1',1,'Retail Sale Id 7733',2002.00,0.00,0.00,2.75,145.75,'2022-09-18 08:58:02','',''),(7782,'1','277','1',1,'Retail Sale Id 7734',4397.12,0.00,0.00,6.04,320.12,'2022-09-18 08:59:40','',''),(7783,'1','277','1',1,'Retail Sale Id 7735',1499.68,0.00,0.00,2.06,109.18,'2022-09-18 09:00:19','',''),(7784,'1','277','1',1,'Retail Sale Id 7736',2999.36,0.00,0.00,4.12,218.36,'2022-09-18 09:01:07','',''),(7785,'1','277','1',1,'Retail Sale Id 7737',9100.00,0.00,0.00,12.50,662.50,'2022-09-18 09:03:55','',''),(7786,'1','277','1',1,'Retail Sale Id 7737',9100.00,0.00,0.00,12.50,662.50,'2022-09-18 09:03:55','',''),(7787,'1','277','1',1,'Retail Sale Id 7738',2198.56,0.00,0.00,3.02,160.06,'2022-09-18 09:04:55','',''),(7788,'1','277','1',1,'Retail Sale Id 7739',800.80,0.00,0.00,1.10,58.30,'2022-09-18 09:16:51','',''),(7789,'1','277','1',1,'Retail Sale Id 7740',9100.00,0.00,0.00,12.50,662.50,'2022-09-18 09:17:32','',''),(7790,'1','277','1',1,'Retail Sale Id 7741',2999.36,0.00,0.00,4.12,218.36,'2022-09-18 09:18:16','',''),(7791,'1','277','1',1,'Retail Sale Id 7742',4397.12,0.00,0.00,6.04,320.12,'2022-09-18 09:20:20','',''),(7792,'1','277','1',1,'Retail Sale Id 7743',1499.68,0.00,0.00,2.06,109.18,'2022-09-18 09:24:24','',''),(7793,'1','277','1',1,'Retail Sale Id 7744',997.36,0.00,0.00,1.37,72.61,'2022-09-18 09:29:38','',''),(7794,'1','277','1',1,'Retail Sale Id 7745',749.84,0.00,0.00,1.03,54.59,'2022-09-18 09:30:20','',''),(7795,'1','277','1',1,'Retail Sale Id 7746',997.36,0.00,0.00,1.37,72.61,'2022-09-18 09:31:21','',''),(7796,'1','277','1',1,'Retail Sale Id 7747',3501.68,0.00,0.00,4.81,254.93,'2022-09-18 09:32:06','',''),(7797,'1','277','1',1,'Retail Sale Id 7748',1201.20,0.00,0.00,1.65,87.45,'2022-09-18 09:37:28','',''),(7798,'1','277','1',1,'Retail Sale Id 7749',3647.28,0.00,0.00,5.01,265.53,'2022-09-18 09:41:49','',''),(7799,'1','277','1',1,'Retail Sale Id 7750',749.84,0.00,0.00,1.03,54.59,'2022-09-18 09:42:54','',''),(7800,'1','277','1',1,'Retail Sale Id 7751',4397.12,0.00,0.00,6.04,320.12,'2022-09-18 09:49:21','',''),(7801,'1','277','1',1,'Retail Sale Id 7752',1499.68,0.00,0.00,2.06,109.18,'2022-09-18 09:50:49','',''),(7802,'1','277','1',1,'Retail Sale Id 7753',800.80,0.00,0.00,1.10,58.30,'2022-09-18 09:57:20','',''),(7803,'1','277','1',1,'Retail Sale Id 7754',2198.56,0.00,0.00,3.02,160.06,'2022-09-18 09:59:28','',''),(7804,'1','277','1',1,'Retail Sale Id 7755',3698.24,0.00,0.00,5.08,269.24,'2022-09-18 10:07:38','',''),(7805,'1','277','1',1,'Retail Sale Id 7756',5001.36,0.00,0.00,6.87,364.11,'2022-09-18 10:08:26','',''),(7806,'1','277','1',1,'Retail Sale Id 7757',2184.00,0.00,0.00,3.00,159.00,'2022-09-18 10:09:37','',''),(7807,'1','277','1',1,'Retail Sale Id 7758',997.36,0.00,0.00,1.37,72.61,'2022-09-18 10:10:24','',''),(7808,'1','277','1',1,'Retail Sale Id 7759',800.80,0.00,0.00,1.10,58.30,'2022-09-18 10:11:26','',''),(7809,'1','277','1',1,'Retail Sale Id 7760',4397.12,0.00,0.00,6.04,320.12,'2022-09-18 10:13:08','',''),(7810,'1','277','1',1,'Retail Sale Id 7761',2184.00,0.00,0.00,3.00,159.00,'2022-09-18 10:14:03','',''),(7811,'1','277','1',1,'Retail Sale Id 7762',1499.68,0.00,0.00,2.06,109.18,'2022-09-18 10:14:53','',''),(7812,'1','277','1',1,'Retail Sale Id 7763',3640.00,0.00,0.00,5.00,265.00,'2022-09-18 10:18:01','',''),(7813,'1','277','1',1,'Retail Sale Id 7764',2198.56,0.00,0.00,3.02,160.06,'2022-09-18 10:18:55','',''),(7814,'1','277','1',1,'Retail Sale Id 7765',4397.12,0.00,0.00,6.04,320.12,'2022-09-18 10:20:55','',''),(7815,'1','277','1',1,'Retail Sale Id 7766',3640.00,0.00,0.00,5.00,265.00,'2022-09-18 10:23:07','',''),(7816,'1','277','1',1,'Retail Sale Id 7767',3603.60,0.00,0.00,4.95,262.35,'2022-09-18 10:26:58','',''),(7817,'1','277','1',1,'Retail Sale Id 7768',698.88,0.00,0.00,0.96,50.88,'2022-09-18 10:30:01','',''),(7818,'1','277','1',1,'Retail Sale Id 7769',2198.56,0.00,0.00,3.02,160.06,'2022-09-18 10:32:21','',''),(7819,'1','277','1',1,'Retail Sale Id 7770',1499.68,0.00,0.00,2.06,109.18,'2022-09-18 10:34:20','',''),(7820,'1','277','1',1,'Retail Sale Id 7771',2999.36,0.00,0.00,4.12,218.36,'2022-09-18 10:41:24','',''),(7821,'1','277','1',1,'Retail Sale Id 7772',32760.00,0.00,0.00,45.00,2385.00,'2022-09-18 10:49:39','',''),(7822,'1','277','1',1,'Retail Sale Id 7772',32760.00,0.00,0.00,45.00,2385.00,'2022-09-18 10:49:39','',''),(7823,'1','277','1',1,'Retail Sale Id 7773',2497.04,0.00,0.00,3.43,181.79,'2022-09-18 10:50:41','',''),(7824,'1','277','1',1,'Retail Sale Id 7774',43680.00,0.00,0.00,60.00,3180.00,'2022-09-18 10:53:30','',''),(7825,'1','277','1',1,'Retail Sale Id 7775',1201.20,0.00,0.00,1.65,87.45,'2022-09-18 10:54:21','',''),(7826,'1','277','1',1,'Retail Sale Id 7776',2497.04,0.00,0.00,3.43,181.79,'2022-09-18 10:55:05','',''),(7827,'1','277','1',1,'Retail Sale Id 7777',2198.56,0.00,0.00,3.02,160.06,'2022-09-18 10:56:26','',''),(7828,'1','277','1',1,'Retail Sale Id 7781',3698.24,0.00,0.00,5.08,269.24,'2022-09-18 11:04:44','',''),(7829,'1','277','1',1,'Retail Sale Id 7782',2999.36,0.00,0.00,4.12,218.36,'2022-09-18 11:08:44','',''),(7830,'1','277','1',1,'Retail Sale Id 7783',1499.68,0.00,0.00,2.06,109.18,'2022-09-18 11:10:48','',''),(7831,'1','277','1',1,'Retail Sale Id 7784',1601.60,0.00,0.00,2.20,116.60,'2022-09-18 11:11:35','',''),(7832,'1','277','1',1,'Retail Sale Id 7785',5001.36,0.00,0.00,6.87,364.11,'2022-09-18 11:15:16','',''),(7833,'1','277','1',1,'Retail Sale Id 7786',1499.68,0.00,0.00,2.06,109.18,'2022-09-18 11:18:46','',''),(7834,'1','277','1',1,'Retail Sale Id 7787',4499.04,0.00,0.00,6.18,327.54,'2022-09-18 11:24:38','',''),(7835,'1','277','1',1,'Retail Sale Id 7788',2002.00,0.00,0.00,2.75,145.75,'2022-09-18 11:25:22','',''),(7836,'1','277','1',1,'Retail Sale Id 7789',2002.00,0.00,0.00,2.75,145.75,'2022-09-18 11:26:04','',''),(7837,'1','277','1',1,'Retail Sale Id 7790',749.84,0.00,0.00,1.03,54.59,'2022-09-18 11:26:48','',''),(7838,'1','277','1',1,'Retail Sale Id 7792',9100.00,0.00,0.00,12.50,662.50,'2022-09-18 11:29:19','',''),(7839,'1','277','1',1,'Retail Sale Id 7793',800.80,0.00,0.00,1.10,58.30,'2022-09-18 11:29:55','',''),(7840,'1','277','1',1,'Retail Sale Id 7794',997.36,0.00,0.00,1.37,72.61,'2022-09-18 11:30:49','',''),(7841,'1','277','1',1,'Retail Sale Id 7795',14996.80,0.00,0.00,20.60,1091.80,'2022-09-18 11:34:41','',''),(7842,'1','277','1',1,'Retail Sale Id 7796',3698.24,0.00,0.00,5.08,269.24,'2022-09-18 11:35:54','',''),(7843,'1','277','1',1,'Retail Sale Id 7797',800.80,0.00,0.00,1.10,58.30,'2022-09-18 11:36:26','',''),(7844,'1','277','1',1,'Retail Sale Id 7799',1499.68,0.00,0.00,2.06,109.18,'2022-09-18 11:37:22','',''),(7845,'1','277','1',1,'Retail Sale Id 7801',8008.00,0.00,0.00,11.00,583.00,'2022-09-18 11:40:13','',''),(7846,'1','277','1',1,'Retail Sale Id 7803',2002.00,0.00,0.00,2.75,145.75,'2022-09-18 11:41:14','',''),(7847,'1','277','1',1,'Retail Sale Id 7804',728.00,0.00,0.00,1.00,53.00,'2022-09-18 11:42:51','',''),(7848,'1','277','1',1,'Retail Sale Id 7805',1499.68,0.00,0.00,2.06,109.18,'2022-09-18 11:43:47','',''),(7849,'1','277','1',1,'Retail Sale Id 7806',9100.00,0.00,0.00,12.50,662.50,'2022-09-18 11:45:27','',''),(7850,'1','277','1',1,'Retail Sale Id 7807',4397.12,0.00,0.00,6.04,320.12,'2022-09-18 11:48:08','',''),(7851,'1','277','1',1,'Retail Sale Id 7808',2999.36,0.00,0.00,4.12,218.36,'2022-09-18 11:51:05','',''),(7852,'1','277','1',1,'Retail Sale Id 7809',997.36,0.00,0.00,1.37,72.61,'2022-09-18 11:53:23','',''),(7853,'1','277','1',1,'Retail Sale Id 7810',2002.00,0.00,0.00,2.75,145.75,'2022-09-18 11:54:04','',''),(7854,'1','277','1',1,'Retail Sale Id 7811',4397.12,0.00,0.00,6.04,320.12,'2022-09-18 11:56:54','',''),(7855,'1','277','1',1,'Retail Sale Id 7812',698.88,0.00,0.00,0.96,50.88,'2022-09-18 11:58:53','',''),(7856,'1','277','1',1,'Retail Sale Id 7813',502.32,0.00,0.00,0.69,36.57,'2022-09-18 11:59:41','',''),(7857,'1','277','1',1,'Retail Sale Id 7814',2198.56,0.00,0.00,3.02,160.06,'2022-09-18 12:09:09','',''),(7858,'1','277','1',1,'Retail Sale Id 7815',3698.24,0.00,0.00,5.08,269.24,'2022-09-18 12:15:14','',''),(7859,'1','277','1',1,'Retail Sale Id 7816',2002.00,0.00,0.00,2.75,145.75,'2022-09-18 12:17:00','',''),(7860,'1','277','1',1,'Retail Sale Id 7817',2912.00,0.00,0.00,4.00,212.00,'2022-09-18 12:18:36','',''),(7861,'1','277','1',1,'Retail Sale Id 7818',800.80,0.00,0.00,1.10,58.30,'2022-09-18 12:19:09','',''),(7862,'1','277','1',1,'Retail Sale Id 7819',4397.12,0.00,0.00,6.04,320.12,'2022-09-18 12:34:01','',''),(7863,'1','277','1',1,'Retail Sale Id 7820',3698.24,0.00,0.00,5.08,269.24,'2022-09-18 12:34:47','',''),(7864,'1','277','1',1,'Retail Sale Id 7821',3698.24,0.00,0.00,5.08,269.24,'2022-09-18 12:35:26','',''),(7865,'1','277','1',1,'Retail Sale Id 7822',1499.68,0.00,0.00,2.06,109.18,'2022-09-18 12:36:14','',''),(7866,'1','277','1',1,'Retail Sale Id 7823',3640.00,0.00,0.00,5.00,265.00,'2022-09-18 12:40:16','',''),(7867,'1','277','1',1,'Retail Sale Id 7824',5001.36,0.00,0.00,6.87,364.11,'2022-09-18 12:41:16','',''),(7868,'1','277','1',1,'Retail Sale Id 7825',997.36,0.00,0.00,1.37,72.61,'2022-09-18 12:41:59','',''),(7869,'1','277','1',1,'Retail Sale Id 7826',2999.36,0.00,0.00,4.12,218.36,'2022-09-18 12:45:35','',''),(7870,'1','277','1',1,'Retail Sale Id 7827',2002.00,0.00,0.00,2.75,145.75,'2022-09-18 12:46:06','',''),(7871,'1','277','1',1,'Retail Sale Id 7828',1499.68,0.00,0.00,2.06,109.18,'2022-09-18 12:46:40','',''),(7872,'1','277','1',1,'Retail Sale Id 7829',1499.68,0.00,0.00,2.06,109.18,'2022-09-18 13:02:44','',''),(7873,'1','277','1',1,'Retail Sale Id 7829',2497.04,0.00,0.00,3.43,181.79,'2022-09-18 13:02:44','',''),(7874,'1','277','1',1,'Retail Sale Id 7830',5001.36,0.00,0.00,6.87,364.11,'2022-09-18 13:03:51','',''),(7875,'1','277','1',1,'Retail Sale Id 7831',1499.68,0.00,0.00,2.06,109.18,'2022-09-18 13:04:54','',''),(7876,'1','277','1',1,'Retail Sale Id 7832',4397.12,0.00,0.00,6.04,320.12,'2022-09-18 13:07:23','',''),(7877,'1','277','1',1,'Retail Sale Id 7833',1499.68,0.00,0.00,2.06,109.18,'2022-09-18 13:09:53','',''),(7878,'1','277','1',1,'Retail Sale Id 7834',2198.56,0.00,0.00,3.02,160.06,'2022-09-18 13:10:28','',''),(7879,'1','277','1',1,'Retail Sale Id 7835',3603.60,0.00,0.00,4.95,262.35,'2022-09-18 13:12:36','',''),(7880,'1','277','1',1,'Retail Sale Id 7836',997.36,0.00,0.00,1.37,72.61,'2022-09-18 13:18:04','',''),(7881,'1','277','1',1,'Retail Sale Id 7837',2999.36,0.00,0.00,4.12,218.36,'2022-09-18 13:21:30','',''),(7882,'1','277','1',1,'Retail Sale Id 7838',7280.00,0.00,0.00,10.00,530.00,'2022-09-18 13:22:13','',''),(7883,'1','277','1',1,'Retail Sale Id 7840',400.40,0.00,0.00,0.55,29.15,'2022-09-18 13:23:15','',''),(7884,'1','277','1',1,'Retail Sale Id 7841',2497.04,0.00,0.00,3.43,181.79,'2022-09-18 13:23:43','',''),(7885,'1','277','1',1,'Retail Sale Id 7842',3647.28,0.00,0.00,5.01,265.53,'2022-09-18 13:24:43','',''),(7886,'1','277','1',1,'Retail Sale Id 7843',749.84,0.00,0.00,1.03,54.59,'2022-09-18 13:25:49','',''),(7887,'1','277','1',1,'Retail Sale Id 7844',9100.00,0.00,0.00,12.50,662.50,'2022-09-18 13:26:31','',''),(7888,'1','277','1',1,'Retail Sale Id 7845',3647.28,0.00,0.00,5.01,265.53,'2022-09-18 13:28:05','',''),(7889,'1','277','1',1,'Retail Sale Id 7846',1601.60,0.00,0.00,2.20,116.60,'2022-09-18 13:31:45','',''),(7890,'1','277','1',1,'Retail Sale Id 7846',4397.12,0.00,0.00,6.04,320.12,'2022-09-18 13:31:45','',''),(7891,'1','277','1',1,'Retail Sale Id 7847',1397.76,0.00,0.00,1.92,101.76,'2022-09-18 13:32:22','',''),(7892,'1','277','1',1,'Retail Sale Id 7848',2999.36,0.00,0.00,4.12,218.36,'2022-09-18 13:32:52','',''),(7893,'1','277','1',1,'Retail Sale Id 7849',7301.84,0.00,0.00,10.03,531.59,'2022-09-18 13:33:40','',''),(7894,'1','277','1',1,'Retail Sale Id 7850',2198.56,0.00,0.00,3.02,160.06,'2022-09-18 13:34:12','',''),(7895,'1','277','1',1,'Retail Sale Id 7851',12951.12,0.00,0.00,17.79,942.87,'2022-09-18 13:39:45','',''),(7896,'1','277','1',1,'Retail Sale Id 7852',1499.68,0.00,0.00,2.06,109.18,'2022-09-18 13:41:35','',''),(7897,'1','277','1',1,'Retail Sale Id 7853',9100.00,0.00,0.00,12.50,662.50,'2022-09-18 13:42:49','',''),(7898,'1','277','1',1,'Retail Sale Id 7854',1499.68,0.00,0.00,2.06,109.18,'2022-09-18 13:43:45','',''),(7899,'1','277','1',1,'Retail Sale Id 7854',1499.68,0.00,0.00,2.06,109.18,'2022-09-18 13:43:45','',''),(7900,'1','277','1',1,'Retail Sale Id 7855',2999.36,0.00,0.00,4.12,218.36,'2022-09-18 13:45:17','',''),(7901,'1','277','1',1,'Retail Sale Id 7856',9100.00,0.00,0.00,12.50,662.50,'2022-09-18 13:49:55','',''),(7902,'1','277','1',1,'Retail Sale Id 7857',2999.36,0.00,0.00,4.12,218.36,'2022-09-18 13:50:48','',''),(7903,'1','277','1',1,'Retail Sale Id 7858',3698.24,0.00,0.00,5.08,269.24,'2022-09-18 13:52:52','',''),(7904,'1','277','1',1,'Retail Sale Id 7859',3698.24,0.00,0.00,5.08,269.24,'2022-09-18 13:53:27','',''),(7905,'1','277','1',1,'Retail Sale Id 7860',2198.56,0.00,0.00,3.02,160.06,'2022-09-18 14:01:37','',''),(7906,'1','277','1',1,'Retail Sale Id 7861',2999.36,0.00,0.00,4.12,218.36,'2022-09-18 14:03:30','',''),(7907,'1','277','1',1,'Retail Sale Id 7862',2002.00,0.00,0.00,2.75,145.75,'2022-09-18 14:04:13','',''),(7908,'1','277','1',1,'Retail Sale Id 7863',3698.24,0.00,0.00,5.08,269.24,'2022-09-18 14:16:13','',''),(7909,'1','277','1',1,'Retail Sale Id 7864',5001.36,0.00,0.00,6.87,364.11,'2022-09-18 14:20:46','',''),(7910,'1','277','1',1,'Retail Sale Id 7865',997.36,0.00,0.00,1.37,72.61,'2022-09-18 14:24:03','',''),(7911,'1','277','1',1,'Retail Sale Id 7866',2198.56,0.00,0.00,3.02,160.06,'2022-09-18 14:25:52','',''),(7912,'1','277','1',1,'Retail Sale Id 7866',4397.12,0.00,0.00,6.04,320.12,'2022-09-18 14:25:52','',''),(7913,'1','277','1',1,'Retail Sale Id 7867',4397.12,0.00,0.00,6.04,320.12,'2022-09-18 14:31:52','',''),(7914,'1','277','1',1,'Retail Sale Id 7868',1499.68,0.00,0.00,2.06,109.18,'2022-09-18 14:33:07','',''),(7915,'1','277','1',1,'Retail Sale Id 7869',3647.28,0.00,0.00,5.01,265.53,'2022-09-18 14:34:26','',''),(7916,'1','277','1',1,'Retail Sale Id 7870',2497.04,0.00,0.00,3.43,181.79,'2022-09-18 14:35:34','',''),(7917,'1','277','1',1,'Retail Sale Id 7871',997.36,0.00,0.00,1.37,72.61,'2022-09-18 14:38:24','',''),(7918,'1','277','1',1,'Retail Sale Id 7872',1499.68,0.00,0.00,2.06,109.18,'2022-09-18 14:40:49','',''),(7919,'1','277','1',1,'Retail Sale Id 7873',9100.00,0.00,0.00,12.50,662.50,'2022-09-18 14:46:39','',''),(7920,'1','277','1',1,'Retail Sale Id 7874',2002.00,0.00,0.00,2.75,145.75,'2022-09-18 14:49:47','',''),(7921,'1','277','1',1,'Retail Sale Id 7875',4397.12,0.00,0.00,6.04,320.12,'2022-09-18 14:52:16','',''),(7922,'1','277','1',1,'Retail Sale Id 7876',2999.36,0.00,0.00,4.12,218.36,'2022-09-18 14:52:56','',''),(7923,'1','277','1',1,'Retail Sale Id 7877',2198.56,0.00,0.00,3.02,160.06,'2022-09-18 14:54:26','',''),(7924,'1','277','1',1,'Retail Sale Id 7878',698.88,0.00,0.00,0.96,50.88,'2022-09-18 14:56:30','',''),(7925,'1','277','1',1,'Retail Sale Id 7879',1397.76,0.00,0.00,1.92,101.76,'2022-09-18 14:57:36','',''),(7926,'1','277','1',1,'Retail Sale Id 7880',2497.04,0.00,0.00,3.43,181.79,'2022-09-18 14:59:01','',''),(7927,'1','277','1',1,'Retail Sale Id 7881',1499.68,0.00,0.00,2.06,109.18,'2022-09-18 15:00:38','',''),(7928,'1','277','1',1,'Retail Sale Id 7882',1499.68,0.00,0.00,2.06,109.18,'2022-09-18 15:02:33','',''),(7929,'1','277','1',1,'Retail Sale Id 7883',1201.20,0.00,0.00,1.65,87.45,'2022-09-18 15:03:36','',''),(7930,'1','277','1',1,'Retail Sale Id 7884',2002.00,0.00,0.00,2.75,145.75,'2022-09-18 15:04:54','',''),(7931,'1','277','1',1,'Retail Sale Id 7885',2002.00,0.00,0.00,2.75,145.75,'2022-09-18 15:09:38','',''),(7932,'1','277','1',1,'Retail Sale Id 7886',2497.04,0.00,0.00,3.43,181.79,'2022-09-18 15:10:14','',''),(7933,'1','277','1',1,'Retail Sale Id 7887',1499.68,0.00,0.00,2.06,109.18,'2022-09-18 15:12:02','',''),(7934,'1','277','1',1,'Retail Sale Id 7888',3647.28,0.00,0.00,5.01,265.53,'2022-09-18 15:15:25','',''),(7935,'1','277','1',1,'Retail Sale Id 7889',9100.00,0.00,0.00,12.50,662.50,'2022-09-18 15:22:10','',''),(7936,'1','277','1',1,'Retail Sale Id 7890',997.36,0.00,0.00,1.37,72.61,'2022-09-18 15:24:50','',''),(7937,'1','277','1',1,'Retail Sale Id 7891',728.00,0.00,0.00,1.00,53.00,'2022-09-18 15:27:23','',''),(7938,'1','277','1',1,'Retail Sale Id 7892',1499.68,0.00,0.00,2.06,109.18,'2022-09-18 15:44:04','',''),(7939,'1','277','1',1,'Retail Sale Id 7893',1499.68,0.00,0.00,2.06,109.18,'2022-09-18 15:47:00','',''),(7940,'1','277','1',1,'Retail Sale Id 7894',1499.68,0.00,0.00,2.06,109.18,'2022-09-18 15:49:22','',''),(7941,'1','277','1',1,'Retail Sale Id 7895',1798.16,0.00,0.00,2.47,130.91,'2022-09-18 15:49:54','',''),(7942,'1','277','1',1,'Retail Sale Id 7896',2999.36,0.00,0.00,4.12,218.36,'2022-09-18 15:51:08','',''),(7943,'1','277','1',1,'Retail Sale Id 7897',2002.00,0.00,0.00,2.75,145.75,'2022-09-18 15:52:04','',''),(7944,'1','277','1',1,'Retail Sale Id 7898',2002.00,0.00,0.00,2.75,145.75,'2022-09-18 15:56:35','',''),(7945,'1','277','1',1,'Retail Sale Id 7899',502.32,0.00,0.00,0.69,36.57,'2022-09-18 15:57:15','',''),(7946,'1','277','1',1,'Retail Sale Id 7900',997.36,0.00,0.00,1.37,72.61,'2022-09-18 15:58:59','',''),(7947,'1','277','1',1,'Retail Sale Id 7901',997.36,0.00,0.00,1.37,72.61,'2022-09-18 16:04:20','',''),(7948,'1','277','1',1,'Retail Sale Id 7902',2999.36,0.00,0.00,4.12,218.36,'2022-09-18 16:05:57','',''),(7949,'1','277','1',1,'Retail Sale Id 7903',4397.12,0.00,0.00,6.04,320.12,'2022-09-18 16:15:31','',''),(7950,'1','277','1',1,'Retail Sale Id 7904',2198.56,0.00,0.00,3.02,160.06,'2022-09-18 16:17:16','',''),(7951,'1','277','1',1,'Retail Sale Id 7905',1499.68,0.00,0.00,2.06,109.18,'2022-09-18 16:18:26','',''),(7952,'1','277','1',1,'Retail Sale Id 7906',2999.36,0.00,0.00,4.12,218.36,'2022-09-18 16:19:49','',''),(7953,'1','277','1',1,'Retail Sale Id 7907',2999.36,0.00,0.00,4.12,218.36,'2022-09-18 16:20:36','',''),(7954,'1','277','1',1,'Retail Sale Id 7908',902.72,0.00,0.00,1.24,65.72,'2022-09-18 16:25:27','',''),(7955,'1','277','1',1,'Retail Sale Id 7909',3996.72,0.00,0.00,5.49,290.97,'2022-09-18 16:26:08','',''),(7956,'1','277','1',1,'Retail Sale Id 7910',749.84,0.00,0.00,1.03,54.59,'2022-09-18 16:29:42','',''),(7957,'1','277','1',1,'Retail Sale Id 7911',1499.68,0.00,0.00,2.06,109.18,'2022-09-18 16:30:41','',''),(7958,'1','277','1',1,'Retail Sale Id 7912',2497.04,0.00,0.00,3.43,181.79,'2022-09-18 16:34:22','',''),(7959,'1','277','1',1,'Retail Sale Id 7913',3676.40,0.00,0.00,5.05,267.65,'2022-09-18 16:36:24','',''),(7960,'1','277','1',1,'Retail Sale Id 7914',2497.04,0.00,0.00,3.43,181.79,'2022-09-18 16:45:12','',''),(7961,'1','277','1',1,'Retail Sale Id 7915',9100.00,0.00,0.00,12.50,662.50,'2022-09-18 16:47:30','',''),(7962,'1','277','1',1,'Retail Sale Id 7916',2198.56,0.00,0.00,3.02,160.06,'2022-09-18 16:50:52','',''),(7963,'1','277','1',1,'Retail Sale Id 7916',2198.56,0.00,0.00,3.02,160.06,'2022-09-18 16:50:52','',''),(7964,'1','277','1',1,'Retail Sale Id 7917',2999.36,0.00,0.00,4.12,218.36,'2022-09-18 16:52:28','',''),(7965,'1','277','1',1,'Retail Sale Id 7918',3647.28,0.00,0.00,5.01,265.53,'2022-09-18 16:54:35','',''),(7966,'1','277','1',1,'Retail Sale Id 7919',997.36,0.00,0.00,1.37,72.61,'2022-09-18 16:56:52','',''),(7967,'1','277','1',1,'Retail Sale Id 7920',2096.64,0.00,0.00,2.88,152.64,'2022-09-18 17:00:02','',''),(7968,'1','277','1',1,'Retail Sale Id 7921',3647.28,0.00,0.00,5.01,265.53,'2022-09-18 17:02:37','',''),(7969,'1','277','1',1,'Retail Sale Id 7922',1499.68,0.00,0.00,2.06,109.18,'2022-09-18 17:11:00','',''),(7970,'1','277','1',1,'Retail Sale Id 7923',1900.08,0.00,0.00,2.61,138.33,'2022-09-18 17:17:03','',''),(7971,'1','277','1',1,'Retail Sale Id 7924',2198.56,0.00,0.00,3.02,160.06,'2022-09-18 17:17:40','',''),(7972,'1','277','1',1,'Retail Sale Id 7925',1499.68,0.00,0.00,2.06,109.18,'2022-09-18 17:18:12','',''),(7973,'1','277','1',1,'Retail Sale Id 7926',9100.00,0.00,0.00,12.50,662.50,'2022-09-18 17:18:49','',''),(7974,'1','277','1',1,'Retail Sale Id 7927',3698.24,0.00,0.00,5.08,269.24,'2022-09-18 17:19:48','',''),(7975,'1','277','1',1,'Retail Sale Id 7928',4397.12,0.00,0.00,6.04,320.12,'2022-09-18 17:20:46','',''),(7976,'1','277','1',1,'Retail Sale Id 7929',2198.56,0.00,0.00,3.02,160.06,'2022-09-18 17:23:02','',''),(7977,'1','277','1',1,'Retail Sale Id 7930',2999.36,0.00,0.00,4.12,218.36,'2022-09-18 17:27:09','',''),(7978,'1','277','1',1,'Retail Sale Id 7931',3501.68,0.00,0.00,4.81,254.93,'2022-09-18 17:28:12','',''),(7979,'1','277','1',1,'Retail Sale Id 7932',2002.00,0.00,0.00,2.75,145.75,'2022-09-18 17:29:06','',''),(7980,'1','277','1',1,'Retail Sale Id 7933',2497.04,0.00,0.00,3.43,181.79,'2022-09-18 17:36:10','',''),(7981,'1','277','1',1,'Retail Sale Id 7934',1499.68,0.00,0.00,2.06,109.18,'2022-09-18 17:36:48','',''),(7982,'1','277','1',1,'Retail Sale Id 7935',2002.00,0.00,0.00,2.75,145.75,'2022-09-18 17:38:17','',''),(7983,'1','277','1',1,'Retail Sale Id 7936',749.84,0.00,0.00,1.03,54.59,'2022-09-18 17:41:07','',''),(7984,'1','277','1',1,'Retail Sale Id 7937',2002.00,0.00,0.00,2.75,145.75,'2022-09-18 17:42:07','',''),(7985,'1','277','1',1,'Retail Sale Id 7938',2002.00,0.00,0.00,2.75,145.75,'2022-09-18 17:44:51','',''),(7986,'1','277','1',1,'Retail Sale Id 7939',9100.00,0.00,0.00,12.50,662.50,'2022-09-18 17:45:40','',''),(7987,'1','277','1',1,'Retail Sale Id 7940',3698.24,0.00,0.00,5.08,269.24,'2022-09-18 17:46:51','',''),(7988,'1','277','1',1,'Retail Sale Id 7941',2198.56,0.00,0.00,3.02,160.06,'2022-09-18 17:47:38','',''),(7989,'1','277','1',1,'Retail Sale Id 7942',997.36,0.00,0.00,1.37,72.61,'2022-09-18 17:48:27','',''),(7990,'1','277','1',1,'Retail 