-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_275
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_275`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_275` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_275`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,4000,'',0,'22','1','275','PURCHASES','','2022-05-29 12:27:18',5,0.00,0.00,'','479','2022-05-29 12:27:18','479',0,0),(2,7000,'',0,'20','1','275','SALES','','2022-05-29 12:27:31',5,0.00,0.00,'','479','2022-05-29 12:27:31','479',0,0),(3,500,'',0,'6.1','1','275','CASH','','2022-05-29 12:27:47',5,0.00,0.00,'','479','2022-05-29 12:27:47','479',0,0),(4,8000,'',0,'24','1','275','SALARIES & WAGES','','2022-05-29 12:28:13',5,0.00,0.00,'','479','2022-05-29 12:28:13','479',0,0),(5,8001,'',0,'24','1','275','PURCHASES','','2022-05-29 12:28:24',5,0.00,0.00,'','479','2022-05-29 12:28:24','479',0,0),(6,2500,'',0,'2','1','275','FID POS COLLECTION-5620141491','','2022-05-29 12:33:44',5,0.00,0.00,'','479','2022-05-29 12:33:44','479',0,0),(7,2501,'',0,'2','1','275','ZNB E-BILLS COLLECTION :101471','','2022-05-29 12:34:13',5,0.00,0.00,'','479','2022-05-29 12:34:13','479',0,0),(8,2502,'',0,'2','1','275','FB(IBAL)2023855223','','2022-05-29 12:35:11',5,0.00,0.00,'','479','2022-05-29 12:35:11','479',0,0),(9,2503,'',0,'2','1','275','E-BILLS  IBAL 1015372548','','2022-05-29 12:35:47',5,0.00,0.00,'','479','2022-05-29 12:35:47','479',0,0),(10,2504,'',0,'2','1','275','DANKANO-EBILLS:ZNB1014717618','','2022-05-29 12:36:01',5,0.00,0.00,'','479','2022-05-29 12:36:01','479',0,0),(11,2505,'',0,'2','1','275','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:13:42',5,0.00,0.00,'','792','2023-02-20 14:13:42','792',0,0),(12,2506,'',0,'2','1','275','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:25:19',5,0.00,0.00,'2023-03-15','792','2023-03-17 12:28:46','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','1','275','Operational lost','Bulk sales','07066026467','adamadamsalisu@gmail.com','Kano','Kano','Hotoro danmarke Kano','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-13 10:43:09',5,'889','2022-06-13 10:43:09','889'),(2,'','1','275','OPPRETIONAL LOST ','LOST','08100434643','kabiribrahimrano0@gmail.com','ABUJA','ABUJA','GUDU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-13 10:43:47',5,'889','2022-06-13 10:43:47','889'),(3,'','1','275','DEALER','DEALER','08100434643','kabiribrahimrano0@gmail.com','ABUJA','ABUJA','GUDU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-19 18:03:22',5,'889','2022-07-19 18:03:22','889'),(4,'','1','275','KOLA GAS','DEALER','08138447802','kolawolekorede07@gmail.com','ABUJA','ABUJA','PRINCE&PRINCESS ESTATE CORNER SHOP','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-19 18:19:53',5,'889','2022-07-19 18:19:53','889'),(5,'','1','275','CHINEDU GAS','DEALER','09019032264','chinedu01@gmail.com','ABUJA','ABUJA','gudu abj','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-20 07:48:56',5,'889','2022-07-20 07:48:56','889'),(6,'','1','275','BUDIES GAS','DEALER','08091761813','budies@gmail.com','ABUJA','ABUJA','DURUMI ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-20 08:13:22',5,'889','2022-07-20 08:13:22','889'),(7,'','1','275','C.J GAS','DEALER','07032247973','cjgas@yahoo.com','ABUJA','ABUJA','gudu abuja','Nigeria',200000.00,0.00,0.00,'0000-00-00','2022-07-21 12:10:29',5,'889','2022-07-21 12:10:29','889'),(8,'','1','275','PIUS GAS','DEALER','08164838679','pius@gmail.com','ABUJA','ABUJA','DURUMI ABUJA','Nigeria',200000.00,0.00,0.00,'0000-00-00','2022-07-21 14:05:28',5,'889','2022-07-21 14:05:28','889'),(9,'','1','275','MIKE GAS','DEALER','07082999136','mike@gmail.com','ABUJA','ABUJA','DURUMI 2 BY CHIEF PALACE','Nigeria',200000.00,0.00,0.00,'0000-00-00','2022-07-22 15:50:18',5,'889','2022-07-22 15:50:18','889'),(10,'','1','275','SAMO GAS','DEALER','08073414109','samo@gmail.com','ABUJA','ABUJA','DURUMI ABUJA','Nigeria',200000.00,0.00,0.00,'0000-00-00','2022-07-23 08:44:15',5,'889','2022-07-23 08:44:15','889'),(11,'','1','275','ENDURANCE GAS','DEALER','08135125514','endurance@gmail.com','ABUJA','ABUJA','durumi 2','Nigeria',200000.00,0.00,0.00,'0000-00-00','2022-07-23 11:26:22',5,'889','2022-07-23 11:26:22','889'),(12,'','1','275','JIDOPO GAS','DEALER','08036407301','jidopo@gmail.com','ABUJA','ABUJA','DURUMI ','Nigeria',200000.00,0.00,0.00,'0000-00-00','2022-07-23 11:55:58',5,'889','2022-07-23 11:55:58','889'),(13,'','1','275','SYSTEM GAS','DEALER','08139331114,08073539050','systemgas@gmail.com','ABUJA','ABUJA','DURUMI 2','Nigeria',200000.00,0.00,0.00,'0000-00-00','2022-07-24 18:12:42',5,'889','2022-07-24 18:12:42','889'),(14,'','1','275','PRINCE GAS','DEALER','08177909741','prince@gmail.com','ABUJA','ABUJA','DURUMI 2 BEHIND PRIMARY SCHOOL','Nigeria',200000.00,0.00,0.00,'0000-00-00','2022-07-26 08:32:08',5,'889','2022-07-26 08:32:08','889'),(15,'','1','275','FRANCO GAS','DEALER','09021010023','franco@gmail.com','ABUJA','ABUJA','DURUMI 2 BY POLICE STATION','Nigeria',200000.00,0.00,0.00,'0000-00-00','2022-07-26 10:22:41',5,'889','2022-07-26 10:22:41','889'),(16,'','1','275','OKWISCO GAS','DEALER','08037258644','okwisco@gmail.com','ABUJA','ABUJA','GASME VILLAGE','Nigeria',200000.00,0.00,0.00,'0000-00-00','2022-07-26 10:57:50',5,'889','2022-07-26 10:57:50','889'),(17,'','1','275','SUNNYBEST GAS','DEALER','08035967426','sunnybest@gmail.com','ABUJA','ABUJA','GADUWA OPP OANDO FILLING STATION','Nigeria',200000.00,0.00,0.00,'0000-00-00','2022-07-26 11:13:32',5,'889','2022-07-26 11:13:32','889'),(18,'','1','275','PROMISE GAS','DEALER','07032247973','promise@gmail.com','ABUJA','ABUJA','durumi ','Nigeria',200000.00,0.00,0.00,'0000-00-00','2022-07-26 16:15:36',5,'889','2022-07-26 16:15:36','889'),(19,'','1','275','wakil gas','DEALER','08121024943','wakil@gmail.com','ABUJA','ABUJA','durimi','Nigeria',200000.00,0.00,0.00,'0000-00-00','2022-07-26 17:47:36',5,'889','2022-07-26 17:47:36','889'),(20,'','1','275','EDESON GLOBAL GAS','DEALER','08036782042','edeson@gmail.com','ABUJA','ABUJA','kaura market','Nigeria',200000.00,0.00,0.00,'0000-00-00','2022-07-27 15:08:11',5,'889','2022-07-27 15:08:11','889'),(21,'','1','275','KENNETH GAS','DEALER','08112802027','kenneth@gmail.com','ABUJA','ABUJA','DURUMI 2','Nigeria',200000.00,0.00,0.00,'0000-00-00','2022-07-28 15:38:42',5,'889','2022-07-28 15:38:42','889'),(22,'','1','275','LION GAS','DEALER','08036268839','lio22@gmail.com','ABUJA','ABUJA','durumi','Nigeria',200000.00,0.00,0.00,'0000-00-00','2022-07-31 15:13:16',5,'889','2022-07-31 15:13:16','889'),(23,'','1','275','LIGUPASS GAS','DEALER','08032688591','ligupass@gmail.com','ABUJA','ABUJA','APO RESETTLEMENT','Nigeria',200000.00,0.00,0.00,'0000-00-00','2022-08-06 17:40:56',5,'889','2022-08-06 17:40:56','889'),(24,'','1','275','EVERGREEN GAS','DEALER','08035861408','evergreen@gmail.com','ABUJA','ABUJA','GAME VILLAGE','Nigeria',200000.00,0.00,0.00,'0000-00-00','2022-08-17 07:43:31',5,'889','2022-08-17 07:43:31','889'),(25,'','1','275','ARIZONA GAS','DEALER','09064058560','arizona@gmail.com','ABUJA','ABUJA','DURUMI 2','Nigeria',200000.00,0.00,0.00,'0000-00-00','2022-08-23 08:39:10',5,'889','2022-08-23 08:39:10','889'),(26,'','1','275','ZACHEOUS GAS','DEALER','07059277155','zacheous@gmail.com','ABUJA','ABUJA','KAGARKO ','Nigeria',200000.00,0.00,0.00,'0000-00-00','2022-08-25 16:49:59',5,'889','2022-08-25 16:49:59','889'),(27,'','1','275','METRO GAS','DEALER','08036120277','metro@gmail.com','ABUJA','ABUJA','AREA 10 GARKI','Nigeria',200000.00,0.00,0.00,'0000-00-00','2022-08-25 17:13:52',5,'889','2022-08-25 17:13:52','889'),(28,'','1','275','JONAH GAS','DEALER','07030307428','jonah@gmail.com','ABUJA','ABUJA','AREA 1 OPPOSITE ZENITH BANK','Nigeria',200000.00,0.00,0.00,'0000-00-00','2022-09-01 17:44:46',5,'889','2022-09-01 17:44:46','889'),(29,'','1','275','GASS RIGHT','DEALER','08065635593','yahayaabubakar386@gmail.com','ABUJA','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-05 18:37:28',5,'889','2022-09-05 18:37:28','889');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','275','1',1,'5','LPG NOZZLE 1',172534.32,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','275','1',2,'5','LPG NOZZLE 2',85518.34,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=354 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','275',1,'DAILY SALES','2022-06-03','2022-06-03 17:55:17','2022-06-04 17:55:17','889',0.00,0.00,'889','2022-06-03 19:25:36','889','2022-06-03 19:26:06',10,0),('1','275',2,'DAILY SALES','2022-06-04','2022-06-04 07:13:23','2022-06-05 07:13:23','889',0.00,0.00,'889','2022-06-04 19:40:12','889','2022-06-04 19:40:33',10,0),('1','275',3,'DAILY SALES','2022-06-05','2022-06-05 06:57:38','2022-06-06 06:57:38','889',0.00,0.00,'889','2022-06-05 19:32:12','889','2022-06-05 19:32:35',10,0),('1','275',4,'DAILY SALES','2022-06-06','2022-06-06 07:18:57','2022-06-07 07:18:57','889',0.00,0.00,'889','2022-06-06 19:55:58','889','2022-06-06 19:56:19',10,0),('1','275',5,'DAILY SALES','2022-06-07','2022-06-07 06:41:32','2022-06-08 06:41:32','889',0.00,0.00,'889','2022-06-07 19:41:40','889','2022-06-07 19:42:57',10,0),('1','275',6,'DAILY SALES','2022-06-08','2022-06-08 06:46:16','2022-06-09 06:46:16','889',0.00,0.00,'889','2022-06-08 19:30:11','889','2022-06-08 19:30:34',10,0),('1','275',7,'DAILY SALES','2022-06-09','2022-06-09 07:10:48','2022-06-10 07:10:48','889',0.00,0.00,'889','2022-06-09 20:11:02','889','2022-06-09 20:11:34',10,0),('1','275',8,'DAILY SALES','2022-06-10','2022-06-10 07:27:25','2022-06-11 07:27:25','889',0.00,0.00,'889','2022-06-10 19:47:26','889','2022-06-10 19:47:44',10,0),('1','275',9,'DAILY SALES','2022-06-11','2022-06-11 07:08:03','2022-06-12 07:08:03','889',0.00,0.00,'889','2022-06-11 20:03:29','889','2022-06-11 20:07:26',10,0),('1','275',10,'DAILY SALES','2022-06-12','2022-06-12 09:02:35','2022-06-13 09:02:35','889',0.00,0.00,'889','2022-06-12 10:46:27','889','2022-06-12 10:47:06',10,0),('1','275',11,'DAILY SALES','2022-06-13','2022-06-13 07:32:22','2022-06-14 07:32:22','889',0.00,0.00,'889','2022-06-13 10:48:53','889','2022-06-13 10:49:20',10,0),('1','275',12,'DAILY SALES','2022-06-13','2022-06-13 13:44:41','2022-06-14 13:44:41','889',0.00,0.00,'889','2022-06-13 19:15:09','889','2022-06-13 19:15:27',10,0),('1','275',13,'DAILY SALES','2022-06-14','2022-06-14 07:33:28','2022-06-15 07:33:28','889',0.00,0.00,'889','2022-06-14 20:01:09','889','2022-06-14 20:01:29',10,0),('1','275',14,'DAILY SALES','2022-06-15','2022-06-15 06:53:38','2022-06-16 06:53:38','889',0.00,0.00,'889','2022-06-15 19:18:48','889','2022-06-15 19:19:38',10,0),('1','275',15,'DAILY SALES','2022-06-16','2022-06-16 07:25:08','2022-06-17 07:25:08','889',0.00,0.00,'889','2022-06-16 16:29:57','889','2022-06-16 16:30:15',10,0),('1','275',16,'DAILY SALES','2022-06-17','2022-06-17 09:23:08','2022-06-18 09:23:08','889',0.00,0.00,'889','2022-06-17 09:27:27','889','2022-06-17 09:27:45',10,0),('1','275',17,'DAILY SALES','2022-06-17','2022-06-17 19:45:53','2022-06-18 19:45:53','889',0.00,0.00,'889','2022-06-17 19:47:56','889','2022-06-17 19:48:16',10,0),('1','275',18,'DAILY SALES','2022-06-18','2022-06-18 07:29:00','2022-06-19 07:29:00','889',0.00,0.00,'889','2022-06-18 19:29:27','889','2022-06-18 19:29:45',10,0),('1','275',19,'DAILY SALES','2022-06-19','2022-06-19 07:30:22','2022-06-20 07:30:22','889',0.00,0.00,'889','2022-06-19 19:37:45','889','2022-06-19 19:38:09',10,0),('1','275',20,'Daily shift','2022-06-20','2022-06-20 06:53:03','2022-06-21 06:53:03','889',0.00,0.00,'889','2022-06-20 19:26:36','889','2022-06-20 19:26:54',10,0),('1','275',21,'DAILY SALES','2022-06-21','2022-06-21 07:30:32','2022-06-22 07:30:32','889',0.00,0.00,'889','2022-06-21 19:38:11','889','2022-06-21 19:38:33',10,0),('1','275',22,'DAILY SALES','2022-06-22','2022-06-22 06:54:09','2022-06-23 06:54:09','889',0.00,0.00,'889','2022-06-22 11:09:02','889','2022-06-22 11:09:25',10,0),('1','275',23,'DAILY SALES','2022-06-22','2022-06-22 11:11:25','2022-06-23 11:11:25','889',0.00,0.00,'889','2022-06-22 11:13:39','889','2022-06-22 11:13:57',10,0),('1','275',24,'DAILY SALES','2022-06-22','2022-06-22 13:16:48','2022-06-23 13:16:48','889',0.00,0.00,'889','2022-06-22 19:36:27','889','2022-06-22 19:36:46',10,0),('1','275',25,'DAILY SALES','2022-06-23','2022-06-23 07:12:08','2022-06-24 07:12:08','889',0.00,0.00,'889','2022-06-23 19:30:14','889','2022-06-23 19:30:34',10,0),('1','275',26,'DAILY SALES','2022-06-24','2022-06-24 07:50:21','2022-06-25 07:50:21','889',0.00,0.00,'889','2022-06-24 19:33:20','889','2022-06-24 19:33:41',10,0),('1','275',27,'DAILY SALES','2022-06-25','2022-06-25 07:34:06','2022-06-26 07:34:06','889',0.00,0.00,'889','2022-06-25 19:26:30','889','2022-06-25 19:26:59',10,0),('1','275',28,'DAILY SALES','2022-06-26','2022-06-26 07:30:06','2022-06-27 07:30:06','889',0.00,0.00,'889','2022-06-26 19:32:44','889','2022-06-26 19:33:01',10,0),('1','275',29,'DAILY SALES','2022-06-27','2022-06-27 07:25:08','2022-06-28 07:25:08','889',0.00,0.00,'889','2022-06-27 19:18:00','889','2022-06-27 19:18:20',10,0),('1','275',30,'DAILY SALES','2022-06-28','2022-06-28 06:51:57','2022-06-29 06:51:57','889',0.00,0.00,'889','2022-06-28 18:51:04','889','2022-06-28 18:51:26',10,0),('1','275',31,'DAILY SALES','2022-06-29','2022-06-29 07:20:56','2022-06-30 07:20:56','889',0.00,0.00,'889','2022-06-29 07:24:39','889','2022-06-29 07:25:03',10,0),('1','275',32,'DAILY SALES','2022-06-29','2022-06-29 08:04:14','2022-06-30 08:04:14','889',0.00,0.00,'889','2022-06-29 19:38:14','889','2022-06-29 19:38:31',10,0),('1','275',33,'DAILY SALES','2022-06-30','2022-06-30 06:49:35','2022-07-01 06:49:35','889',0.00,0.00,'889','2022-06-30 19:55:49','889','2022-06-30 19:56:23',10,0),('1','275',34,'DAILY SALES','2022-07-01','2022-07-01 07:03:05','2022-07-02 07:03:05','889',0.00,0.00,'889','2022-07-01 19:58:57','889','2022-07-01 19:59:19',10,0),('1','275',35,'DAILY SALES','2022-07-02','2022-07-02 06:50:22','2022-07-03 06:50:22','889',0.00,0.00,'889','2022-07-02 20:21:37','889','2022-07-02 20:22:01',10,0),('1','275',36,'DAILY SALES','2022-07-03','2022-07-03 05:52:19','2022-07-04 05:52:19','889',0.00,0.00,'889','2022-07-03 19:26:37','889','2022-07-03 19:27:11',10,0),('1','275',37,'DAILY SALES','2022-07-04','2022-07-04 06:04:13','2022-07-05 06:04:13','889',0.00,0.00,'889','2022-07-04 20:10:23','889','2022-07-04 20:10:43',10,0),('1','275',38,'DAILY SALES','2022-07-05','2022-07-05 06:10:59','2022-07-06 06:10:59','889',0.00,0.00,'889','2022-07-05 20:24:32','889','2022-07-05 20:24:51',10,0),('1','275',39,'DAILY SALES','2022-07-06','2022-07-06 06:17:54','2022-07-07 06:17:54','889',0.00,0.00,'889','2022-07-06 19:48:13','889','2022-07-06 19:48:32',10,0),('1','275',40,'DAILY SALES','2022-07-07','2022-07-07 06:47:46','2022-07-08 06:47:46','889',0.00,0.00,'889','2022-07-07 19:42:18','889','2022-07-07 19:42:37',10,0),('1','275',41,'DAILY SALES','2022-07-08','2022-07-08 06:21:48','2022-07-09 06:21:48','889',0.00,0.00,'889','2022-07-08 19:59:53','889','2022-07-08 20:00:09',10,0),('1','275',42,'DAILY SALES','2022-07-09','2022-07-09 13:02:04','2022-07-10 13:02:04','889',0.00,0.00,'889','2022-07-09 13:04:29','889','2022-07-09 13:04:47',10,0),('1','275',43,'DAILY SALES','2022-07-09','2022-07-09 14:57:13','2022-07-10 14:57:13','889',0.00,0.00,'889','2022-07-09 19:33:07','889','2022-07-09 19:33:24',10,0),('1','275',44,'DAILY SALES','2022-07-10','2022-07-10 07:03:48','2022-07-11 07:03:48','889',0.00,0.00,'889','2022-07-10 19:25:28','889','2022-07-10 19:25:48',10,0),('1','275',45,'DAILY SALES','2022-07-11','2022-07-11 06:44:33','2022-07-12 06:44:33','889',0.00,0.00,'889','2022-07-11 20:02:01','889','2022-07-11 20:02:18',10,0),('1','275',46,'DAILY SALES','2022-07-12','2022-07-12 06:37:40','2022-07-13 06:37:40','889',0.00,0.00,'889','2022-07-12 19:20:59','889','2022-07-12 19:21:16',10,0),('1','275',47,'DAILY SALES','2022-07-13','2022-07-13 06:30:22','2022-07-14 06:30:22','889',0.00,0.00,'889','2022-07-13 19:49:51','889','2022-07-13 19:50:08',10,0),('1','275',48,'DAILY SALES','2022-07-14','2022-07-14 06:32:52','2022-07-15 06:32:52','889',0.00,0.00,'889','2022-07-14 20:01:27','889','2022-07-14 20:01:47',10,0),('1','275',49,'DAILY SALES','2022-07-15','2022-07-15 06:26:59','2022-07-16 06:26:59','889',0.00,0.00,'889','2022-07-15 20:04:21','889','2022-07-15 20:04:39',10,0),('1','275',50,'DAILY SALES','2022-07-16','2022-07-16 07:05:28','2022-07-17 07:05:28','889',0.00,0.00,'889','2022-07-16 19:46:16','889','2022-07-16 19:46:34',10,0),('1','275',51,'DAILY SALES','2022-07-17','2022-07-17 06:25:14','2022-07-18 06:25:14','889',0.00,0.00,'889','2022-07-17 19:28:06','889','2022-07-17 19:28:30',10,0),('1','275',52,'DAILY SALES','2022-07-18','2022-07-18 06:14:36','2022-07-19 06:14:36','889',0.00,0.00,'889','2022-07-18 19:40:05','889','2022-07-18 19:40:23',10,0),('1','275',53,'DAILY SALES','2022-07-19','2022-07-19 07:02:49','2022-07-20 07:02:49','889',0.00,0.00,'889','2022-07-19 19:41:20','889','2022-07-19 19:41:39',10,0),('1','275',54,'DAILY SALES','2022-07-20','2022-07-20 06:55:44','2022-07-21 06:55:44','889',0.00,0.00,'889','2022-07-20 18:16:17','889','2022-07-20 18:16:44',10,0),('1','275',55,'DAILY SALES','2022-07-21','2022-07-21 08:48:46','2022-07-22 08:48:46','889',0.00,0.00,'889','2022-07-21 08:52:05','889','2022-07-21 08:52:26',10,0),('1','275',56,'DAILY SALES','2022-07-21','2022-07-21 12:04:17','2022-07-22 12:04:17','889',0.00,0.00,'889','2022-07-21 19:28:27','889','2022-07-21 19:28:58',10,0),('1','275',57,'DAILY SALES','2022-07-22','2022-07-22 06:50:06','2022-07-23 06:50:06','889',0.00,0.00,'889','2022-07-22 19:43:30','889','2022-07-22 19:43:50',10,0),('1','275',58,'DAILY SALES','2022-07-23','2022-07-23 06:56:04','2022-07-24 06:56:04','889',0.00,0.00,'889','2022-07-23 19:31:35','889','2022-07-23 19:32:02',10,0),('1','275',59,'DAILY SALES','2022-07-24','2022-07-24 06:53:00','2022-07-25 06:53:00','889',0.00,0.00,'889','2022-07-24 19:45:42','889','2022-07-24 19:46:06',10,0),('1','275',60,'DAILY SALES','2022-07-25','2022-07-25 06:35:39','2022-07-26 06:35:39','889',0.00,0.00,'889','2022-07-25 19:56:01','889','2022-07-25 19:56:31',10,0),('1','275',61,'DAILY SALES','2022-07-26','2022-07-26 07:27:58','2022-07-27 07:27:58','889',0.00,0.00,'889','2022-07-26 07:31:44','889','2022-07-26 07:32:24',10,0),('1','275',62,'DAILY SALES','2022-07-26','2022-07-26 08:10:34','2022-07-27 08:10:34','889',0.00,0.00,'889','2022-07-26 19:23:19','889','2022-07-26 19:23:46',10,0),('1','275',63,'DAILY SALES','2022-07-27','2022-07-27 06:58:46','2022-07-28 06:58:46','889',0.00,0.00,'889','2022-07-27 21:45:13','889','2022-07-27 21:45:30',10,0),('1','275',64,'DAILY SALES','2022-07-28','2022-07-28 06:55:00','2022-07-29 06:55:00','889',0.00,0.00,'889','2022-07-28 19:33:26','889','2022-07-28 19:33:43',10,0),('1','275',65,'DAILY SALES','2022-07-29','2022-07-29 06:27:17','2022-07-30 06:27:17','889',0.00,0.00,'889','2022-07-29 17:11:27','889','2022-07-29 17:11:46',10,0),('1','275',66,'DAILY SALES','2022-07-29','2022-07-29 19:05:53','2022-07-30 19:05:53','889',0.00,0.00,'889','2022-07-29 19:10:41','889','2022-07-29 19:11:02',10,0),('1','275',67,'DAILY SALES','2022-07-29','2022-07-29 20:06:52','2022-07-30 20:06:52','889',0.00,0.00,'889','2022-07-29 20:09:07','889','2022-07-29 20:09:25',10,0),('1','275',68,'DAILY SALES','2022-07-30','2022-07-30 06:48:46','2022-07-31 06:48:46','889',0.00,0.00,'889','2022-07-30 19:19:32','889','2022-07-30 19:19:51',10,0),('1','275',69,'DAILY SALES','2022-07-31','2022-07-31 06:39:24','2022-08-01 06:39:24','889',0.00,0.00,'889','2022-07-31 19:22:33','889','2022-07-31 19:22:52',10,0),('1','275',70,'DAILY SALES','2022-08-01','2022-08-01 06:41:46','2022-08-02 06:41:46','889',0.00,0.00,'889','2022-08-01 19:59:42','889','2022-08-01 20:00:10',10,0),('1','275',71,'DAILY SALES','2022-08-02','2022-08-02 06:33:19','2022-08-03 06:33:19','889',0.00,0.00,'889','2022-08-02 09:07:07','889','2022-08-02 09:07:26',10,0),('1','275',72,'DAILY SALES OVER','2022-08-02','2022-08-02 09:11:02','2022-08-03 09:11:02','889',0.00,0.00,'889','2022-08-02 09:12:41','889','2022-08-02 09:13:01',10,0),('1','275',73,'DAILY SALES','2022-08-02','2022-08-02 11:43:25','2022-08-03 11:43:25','889',0.00,0.00,'889','2022-08-02 19:41:34','889','2022-08-02 19:41:52',10,0),('1','275',74,'DAILY SALES','2022-08-03','2022-08-03 06:41:13','2022-08-04 06:41:13','889',0.00,0.00,'889','2022-08-03 19:27:04','889','2022-08-03 19:27:31',10,0),('1','275',75,'DAILY SALES','2022-08-04','2022-08-04 06:22:48','2022-08-05 06:22:48','889',0.00,0.00,'889','2022-08-04 21:26:07','889','2022-08-04 21:26:26',10,0),('1','275',76,'DAILY SALES','2022-08-05','2022-08-05 06:41:20','2022-08-06 06:41:20','889',0.00,0.00,'889','2022-08-05 19:36:33','889','2022-08-05 19:36:51',10,0),('1','275',77,'DAILY SALES','2022-08-06','2022-08-06 06:43:02','2022-08-07 06:43:02','889',0.00,0.00,'889','2022-08-06 12:05:35','889','2022-08-06 12:05:53',10,0),('1','275',78,'DAILY SALES','2022-08-06','2022-08-06 12:08:24','2022-08-07 12:08:24','889',0.00,0.00,'889','2022-08-06 12:11:56','889','2022-08-06 12:12:16',10,0),('1','275',79,'DAILY SALES','2022-08-06','2022-08-06 14:40:58','2022-08-07 14:40:58','889',0.00,0.00,'889','2022-08-06 19:53:55','889','2022-08-06 19:54:20',10,0),('1','275',80,'DAILY SALES','2022-08-07','2022-08-07 06:39:03','2022-08-08 06:39:03','889',0.00,0.00,'889','2022-08-07 19:28:42','889','2022-08-07 19:29:00',10,0),('1','275',81,'DAILY SALES','2022-08-08','2022-08-08 06:25:00','2022-08-09 06:25:00','889',0.00,0.00,'889','2022-08-08 19:27:35','889','2022-08-08 19:27:56',10,0),('1','275',82,'DAILY SALES','2022-08-09','2022-08-09 06:34:53','2022-08-10 06:34:53','889',0.00,0.00,'889','2022-08-09 19:16:33','889','2022-08-09 19:16:54',10,0),('1','275',83,'DAILY SALES','2022-08-10','2022-08-10 06:47:31','2022-08-11 06:47:31','889',0.00,0.00,'889','2022-08-10 19:37:20','889','2022-08-10 19:37:36',10,0),('1','275',84,'DAILY SALES','2022-08-11','2022-08-11 06:31:53','2022-08-12 06:31:53','889',0.00,0.00,'889','2022-08-11 18:13:11','889','2022-08-11 18:13:32',10,0),('1','275',85,'DAILY SALES','2022-08-11','2022-08-11 18:24:20','2022-08-12 18:24:20','889',0.00,0.00,'889','2022-08-11 18:27:09','889','2022-08-11 18:27:27',10,0),('1','275',86,'DAILY SALES','2022-08-12','2022-08-12 11:11:18','2022-08-13 11:11:18','889',0.00,0.00,'889','2022-08-12 19:25:19','889','2022-08-12 19:25:38',10,0),('1','275',87,'DAILY SALES','2022-08-13','2022-08-13 06:24:18','2022-08-14 06:24:18','889',0.00,0.00,'889','2022-08-13 19:00:47','889','2022-08-13 19:01:06',10,0),('1','275',88,'DAILY SALES','2022-08-14','2022-08-14 06:36:19','2022-08-15 06:36:19','889',0.00,0.00,'889','2022-08-14 19:40:26','889','2022-08-14 19:40:44',10,0),('1','275',89,'DAILY SALES','2022-08-15','2022-08-15 06:31:13','2022-08-16 06:31:13','889',0.00,0.00,'889','2022-08-15 19:44:34','889','2022-08-15 19:44:56',10,0),('1','275',90,'DAILY SALES','2022-08-16','2022-08-16 06:22:52','2022-08-17 06:22:52','889',0.00,0.00,'889','2022-08-16 19:23:37','889','2022-08-16 19:23:55',10,0),('1','275',91,'DAILY SALES','2022-08-17','2022-08-17 06:19:08','2022-08-18 06:19:08','889',0.00,0.00,'889','2022-08-17 11:19:18','889','2022-08-17 11:19:37',10,0),('1','275',92,'DAILY SALES','2022-08-17','2022-08-17 11:20:33','2022-08-18 11:20:33','889',0.00,0.00,'889','2022-08-17 12:26:12','889','2022-08-17 12:26:28',10,0),('1','275',93,'DAILY SALES','2022-08-17','2022-08-17 12:29:29','2022-08-18 12:29:29','889',0.00,0.00,'889','2022-08-17 19:46:18','889','2022-08-17 19:46:44',10,0),('1','275',94,'DAILY SALES','2022-08-18','2022-08-18 06:34:16','2022-08-19 06:34:16','889',0.00,0.00,'889','2022-08-18 19:34:46','889','2022-08-18 19:35:05',10,0),('1','275',95,'DAILY SALES','2022-08-19','2022-08-19 06:18:14','2022-08-20 06:18:14','889',0.00,0.00,'889','2022-08-19 19:18:12','889','2022-08-19 19:18:33',10,0),('1','275',96,'DAILY SALES','2022-08-20','2022-08-20 06:27:16','2022-08-21 06:27:16','889',0.00,0.00,'889','2022-08-20 19:35:14','889','2022-08-20 19:35:34',10,0),('1','275',97,'DAILY SALES','2022-08-21','2022-08-21 06:24:17','2022-08-22 06:24:17','889',0.00,0.00,'889','2022-08-21 15:37:58','889','2022-08-21 15:38:14',10,0),('1','275',98,'DAILY SALES','2022-08-21','2022-08-21 15:39:45','2022-08-22 15:39:45','889',0.00,0.00,'889','2022-08-21 15:48:05','889','2022-08-21 15:48:24',10,0),('1','275',99,'DAILY SALES','2022-08-21','2022-08-21 17:46:56','2022-08-22 17:46:56','889',0.00,0.00,'889','2022-08-21 19:26:07','889','2022-08-21 19:26:23',10,0),('1','275',100,'DAILY SALES','2022-08-22','2022-08-22 06:32:42','2022-08-23 06:32:42','889',0.00,0.00,'889','2022-08-22 19:18:31','889','2022-08-22 19:18:47',10,0),('1','275',101,'DAILY SALES','2022-08-23','2022-08-23 06:27:24','2022-08-24 06:27:24','889',0.00,0.00,'889','2022-08-23 19:17:31','889','2022-08-23 19:17:50',10,0),('1','275',102,'DAILY SALES','2022-08-24','2022-08-24 06:42:02','2022-08-25 06:42:02','889',0.00,0.00,'889','2022-08-24 19:14:55','889','2022-08-24 19:15:15',10,0),('1','275',103,'DAILY SALES','2022-08-25','2022-08-25 07:06:02','2022-08-26 07:06:02','889',0.00,0.00,'889','2022-08-25 19:20:52','889','2022-08-25 19:21:09',10,0),('1','275',104,'DAILY SALES','2022-08-26','2022-08-26 08:21:40','2022-08-27 08:21:40','889',0.00,0.00,'889','2022-08-26 08:23:25','889','2022-08-26 08:23:46',10,0),('1','275',105,'DAILY SALES','2022-08-26','2022-08-26 08:37:27','2022-08-27 08:37:27','889',0.00,0.00,'889','2022-08-26 08:42:47','889','2022-08-26 08:43:10',10,0),('1','275',106,'DAILY SALES','2022-08-28','2022-08-28 08:15:54','2022-08-29 08:15:54','889',0.00,0.00,'889','2022-08-28 19:35:42','889','2022-08-28 19:35:58',10,0),('1','275',107,'DAILY SALES','2022-08-29','2022-08-29 06:32:20','2022-08-30 06:32:20','889',0.00,0.00,'889','2022-08-29 19:57:54','889','2022-08-29 19:59:11',10,0),('1','275',108,'DAILY SALES','2022-08-30','2022-08-30 06:27:41','2022-08-31 06:27:41','889',0.00,0.00,'889','2022-08-30 19:40:29','889','2022-08-30 19:40:48',10,0),('1','275',109,'DAILY SALES','2022-08-31','2022-08-31 06:22:10','2022-09-01 06:22:10','889',0.00,0.00,'889','2022-08-31 19:05:32','889','2022-08-31 19:05:53',10,0),('1','275',110,'DAILY SALES','2022-09-01','2022-09-01 06:27:14','2022-09-02 06:27:14','889',0.00,0.00,'889','2022-09-01 13:25:43','889','2022-09-01 13:26:01',10,0),('1','275',111,'DAILY SALES','2022-09-01','2022-09-01 13:26:48','2022-09-02 13:26:48','889',0.00,0.00,'889','2022-09-01 13:34:26','889','2022-09-01 13:34:49',10,0),('1','275',112,'DAILY SALES','2022-09-01','2022-09-01 16:40:31','2022-09-02 16:40:31','889',0.00,0.00,'889','2022-09-01 19:28:51','889','2022-09-01 19:29:10',10,0),('1','275',113,'DAILY SALES','2022-09-02','2022-09-02 06:38:14','2022-09-03 06:38:14','889',0.00,0.00,'889','2022-09-02 19:22:31','889','2022-09-02 19:22:51',10,0),('1','275',114,'DAILY SALES','2022-09-03','2022-09-03 06:25:50','2022-09-04 06:25:50','889',0.00,0.00,'889','2022-09-03 19:41:46','889','2022-09-03 19:42:03',10,0),('1','275',115,'DAILY SALES','2022-09-04','2022-09-04 06:35:59','2022-09-05 06:35:59','889',0.00,0.00,'889','2022-09-04 18:29:15','889','2022-09-04 18:29:37',10,0),('1','275',116,'DAILY SALES','2022-09-05','2022-09-05 09:34:47','2022-09-06 09:34:47','889',0.00,0.00,'889','2022-09-05 09:37:12','889','2022-09-05 09:37:30',10,0),('1','275',117,'DAILY SALES','2022-09-05','2022-09-05 10:19:34','2022-09-06 10:19:34','889',0.00,0.00,'889','2022-09-05 19:52:55','889','2022-09-05 19:53:14',10,0),('1','275',118,'DAILY SALES','2022-09-06','2022-09-06 06:29:54','2022-09-07 06:29:54','889',0.00,0.00,'889','2022-09-06 19:25:22','889','2022-09-06 19:25:41',10,0),('1','275',119,'DAILY SALES','2022-09-07','2022-09-07 06:17:19','2022-09-08 06:17:19','889',0.00,0.00,'889','2022-09-07 19:28:04','889','2022-09-07 19:28:22',10,0),('1','275',120,'DAILY SALES','2022-09-08','2022-09-08 06:24:50','2022-09-09 06:24:50','889',0.00,0.00,'889','2022-09-08 19:12:37','889','2022-09-08 19:12:55',10,0),('1','275',121,'DAILY SALES','2022-09-09','2022-09-09 06:13:59','2022-09-10 06:13:59','889',0.00,0.00,'889','2022-09-09 14:54:24','889','2022-09-09 14:54:46',10,0),('1','275',122,'DAILY SALES','2022-09-09','2022-09-09 20:55:24','2022-09-10 20:55:24','889',0.00,0.00,'889','2022-09-09 20:58:21','889','2022-09-09 20:58:41',10,0),('1','275',123,'DAILY SALES','2022-09-10','2022-09-10 06:30:21','2022-09-11 06:30:21','889',0.00,0.00,'889','2022-09-10 19:10:21','889','2022-09-10 19:10:40',10,0),('1','275',124,'DAILY SALES','2022-09-11','2022-09-11 06:28:22','2022-09-12 06:28:22','889',0.00,0.00,'889','2022-09-11 19:30:41','889','2022-09-11 19:30:59',10,0),('1','275',125,'DAILY SALES','2022-09-12','2022-09-12 13:08:19','2022-09-13 13:08:19','889',0.00,0.00,'889','2022-09-12 13:13:15','889','2022-09-12 13:13:35',10,0),('1','275',126,'DAILY SALES','2022-09-13','2022-09-13 15:33:15','2022-09-14 15:33:15','889',0.00,0.00,'889','2022-09-13 19:40:54','889','2022-09-13 19:41:14',10,0),('1','275',127,'DAILY SALES','2022-09-14','2022-09-14 06:23:04','2022-09-15 06:23:04','889',0.00,0.00,'889','2022-09-14 19:32:26','889','2022-09-14 19:32:48',10,0),('1','275',128,'DAILY SALES','2022-09-15','2022-09-15 06:23:56','2022-09-16 06:23:56','889',0.00,0.00,'889','2022-09-15 19:11:52','889','2022-09-15 19:12:09',10,0),('1','275',129,'DAILY SALES','2022-09-16','2022-09-16 06:27:16','2022-09-17 06:27:16','889',0.00,0.00,'889','2022-09-16 19:30:05','889','2022-09-16 19:30:24',10,0),('1','275',130,'DAILY SALES','2022-09-17','2022-09-17 06:20:07','2022-09-18 06:20:07','889',0.00,0.00,'889','2022-09-17 16:45:27','889','2022-09-17 16:45:48',10,0),('1','275',131,'DAILY SALES','2022-09-17','2022-09-17 16:46:24','2022-09-18 16:46:24','889',0.00,0.00,'889','2022-09-17 16:50:19','889','2022-09-17 16:50:42',10,0),('1','275',132,'DAILY SALES','2022-09-20','2022-09-20 09:55:44','2022-09-21 09:55:44','889',0.00,0.00,'889','2022-09-20 19:20:07','889','2022-09-20 19:20:25',10,0),('1','275',133,'DAILY SALES','2022-09-21','2022-09-21 06:43:02','2022-09-22 06:43:02','889',0.00,0.00,'889','2022-09-21 19:28:20','889','2022-09-21 19:28:43',10,0),('1','275',134,'DAILY SALES','2022-09-22','2022-09-22 06:25:05','2022-09-23 06:25:05','889',0.00,0.00,'889','2022-09-22 19:09:41','889','2022-09-22 19:10:00',10,0),('1','275',135,'DAILY SALES','2022-09-23','2022-09-23 06:50:32','2022-09-24 06:50:32','889',0.00,0.00,'889','2022-09-23 19:42:08','889','2022-09-23 19:42:27',10,0),('1','275',136,'DAILY SALES','2022-09-24','2022-09-24 06:52:11','2022-09-25 06:52:11','889',0.00,0.00,'889','2022-09-24 19:05:04','889','2022-09-24 19:05:19',10,0),('1','275',137,'DAILY SALES','2022-09-25','2022-09-25 06:31:53','2022-09-26 06:31:53','889',0.00,0.00,'889','2022-09-25 14:19:13','889','2022-09-25 14:19:38',10,0),('1','275',138,'DAILY SALES','2022-09-25','2022-09-25 14:20:50','2022-09-26 14:20:50','889',0.00,0.00,'889','2022-09-25 14:34:36','889','2022-09-25 14:34:55',10,0),('1','275',139,'DAILY SALES','2022-09-26','2022-09-26 12:22:34','2022-09-27 12:22:34','889',0.00,0.00,'889','2022-09-26 18:57:16','889','2022-09-26 18:57:31',10,0),('1','275',140,'DAILY SALES','2022-09-27','2022-09-27 06:34:30','2022-09-28 06:34:30','889',0.00,0.00,'889','2022-09-27 19:04:23','889','2022-09-27 19:04:44',10,0),('1','275',141,'DAILY SALES','2022-09-28','2022-09-28 06:33:31','2022-09-29 06:33:31','889',0.00,0.00,'889','2022-09-28 19:21:07','889','2022-09-28 19:21:22',10,0),('1','275',142,'DAILY SALES','2022-09-29','2022-09-29 06:18:11','2022-09-30 06:18:11','889',0.00,0.00,'889','2022-09-29 19:13:16','889','2022-09-29 19:13:37',10,0),('1','275',143,'DAILY SALES','2022-09-30','2022-09-30 06:29:24','2022-10-01 06:29:24','889',0.00,0.00,'889','2022-09-30 19:06:32','889','2022-09-30 19:06:48',10,0),('1','275',144,'DAILY SALES','2022-10-01','2022-10-01 06:15:56','2022-10-02 06:15:56','889',0.00,0.00,'889','2022-10-01 19:34:36','889','2022-10-01 19:34:53',10,0),('1','275',145,'DAILY SALES','2022-10-02','2022-10-02 06:36:48','2022-10-03 06:36:48','889',0.00,0.00,'889','2022-10-02 16:37:47','889','2022-10-02 16:38:07',10,0),('1','275',146,'DAILY SALES','2022-10-02','2022-10-02 16:38:32','2022-10-03 16:38:32','889',0.00,0.00,'889','2022-10-02 16:41:51','889','2022-10-02 16:42:07',10,0),('1','275',147,'DAILY SALES','2022-10-03','2022-10-03 07:30:21','2022-10-04 07:30:21','889',0.00,0.00,'889','2022-10-03 19:05:38','889','2022-10-03 19:05:57',10,0),('1','275',148,'DAILY SALES','2022-10-04','2022-10-04 06:18:59','2022-10-05 06:18:59','889',0.00,0.00,'889','2022-10-04 19:31:25','889','2022-10-04 19:31:48',10,0),('1','275',149,'DAILY SALES','2022-10-05','2022-10-05 06:24:49','2022-10-06 06:24:49','889',0.00,0.00,'889','2022-10-05 19:12:12','889','2022-10-05 19:12:34',10,0),('1','275',150,'DAILY SALES','2022-10-06','2022-10-06 06:38:42','2022-10-07 06:38:42','889',0.00,0.00,'889','2022-10-06 19:02:55','889','2022-10-06 19:03:14',10,0),('1','275',151,'DAILY SALES','2022-10-07','2022-10-07 06:14:06','2022-10-08 06:14:06','889',0.00,0.00,'889','2022-10-07 17:18:06','889','2022-10-07 17:18:28',10,0),('1','275',152,'DAILY SALES','2022-10-10','2022-10-10 16:51:57','2022-10-11 16:51:57','889',0.00,0.00,'889','2022-10-10 19:26:08','889','2022-10-10 19:26:31',10,0),('1','275',153,'DAILY SALES','2022-10-11','2022-10-11 06:19:26','2022-10-12 06:19:26','889',0.00,0.00,'889','2022-10-11 19:39:23','889','2022-10-11 19:39:42',10,0),('1','275',154,'DAILY SALES','2022-10-12','2022-10-12 06:27:20','2022-10-13 06:27:20','889',0.00,0.00,'889','2022-10-12 18:38:48','889','2022-10-12 18:39:08',10,0),('1','275',155,'DAILY SALES','2022-10-13','2022-10-13 06:30:59','2022-10-14 06:30:59','889',0.00,0.00,'889','2022-10-13 19:20:10','889','2022-10-13 19:20:26',10,0),('1','275',156,'DAILY SALES','2022-10-14','2022-10-14 06:10:56','2022-10-15 06:10:56','889',0.00,0.00,'889','2022-10-14 15:49:40','889','2022-10-14 15:50:00',10,0),('1','275',157,'DAILY SALES','2022-10-14','2022-10-14 21:34:19','2022-10-15 21:34:19','889',0.00,0.00,'889','2022-10-14 21:38:37','889','2022-10-14 21:39:25',10,0),('1','275',158,'DAILY SALES','2022-10-15','2022-10-15 06:20:54','2022-10-16 06:20:54','889',0.00,0.00,'889','2022-10-15 18:52:30','889','2022-10-15 18:52:51',10,0),('1','275',159,'DAILY SALES','2022-10-16','2022-10-16 06:33:33','2022-10-17 06:33:33','889',0.00,0.00,'889','2022-10-16 19:13:36','889','2022-10-16 19:13:57',10,0),('1','275',160,'DAILY SALES','2022-10-17','2022-10-17 06:24:27','2022-10-18 06:24:27','889',0.00,0.00,'889','2022-10-17 18:29:07','889','2022-10-17 18:29:26',10,0),('1','275',161,'DAILY SALES','2022-10-18','2022-10-18 06:44:18','2022-10-19 06:44:18','889',0.00,0.00,'889','2022-10-18 06:47:22','889','2022-10-18 06:47:45',10,0),('1','275',162,'DAILY SALES','2022-10-18','2022-10-18 08:03:32','2022-10-19 08:03:32','889',0.00,0.00,'889','2022-10-18 19:03:06','889','2022-10-18 19:03:31',10,0),('1','275',163,'DAILY SALES','2022-10-19','2022-10-19 06:22:07','2022-10-20 06:22:07','889',0.00,0.00,'889','2022-10-19 19:25:17','889','2022-10-19 19:25:33',10,0),('1','275',164,'DAILY SALES','2022-10-20','2022-10-20 06:30:49','2022-10-21 06:30:49','889',0.00,0.00,'889','2022-10-20 19:15:15','889','2022-10-20 19:15:31',10,0),('1','275',165,'DAILY SALES','2022-10-21','2022-10-21 06:23:10','2022-10-22 06:23:10','889',0.00,0.00,'889','2022-10-21 15:28:06','889','2022-10-21 15:28:23',10,0),('1','275',166,'DAILY SALES','2022-10-22','2022-10-22 10:06:44','2022-10-23 10:06:44','889',0.00,0.00,'889','2022-10-22 19:09:21','889','2022-10-22 19:09:36',10,0),('1','275',167,'DAILY SALES','2022-10-23','2022-10-23 06:33:54','2022-10-24 06:33:54','889',0.00,0.00,'889','2022-10-23 19:19:05','889','2022-10-23 19:19:22',10,0),('1','275',168,'DAILY SALES','2022-10-24','2022-10-24 06:30:47','2022-10-25 06:30:47','889',0.00,0.00,'889','2022-10-24 18:37:54','889','2022-10-24 18:38:09',10,0),('1','275',169,'DAILY SALES','2022-10-25','2022-10-25 06:30:18','2022-10-26 06:30:18','889',0.00,0.00,'889','2022-10-25 15:35:16','889','2022-10-25 15:35:32',10,0),('1','275',170,'DAILY SALES','2022-10-25','2022-10-25 15:36:04','2022-10-26 15:36:04','889',0.00,0.00,'889','2022-10-25 15:38:42','889','2022-10-25 15:38:57',10,0),('1','275',171,'DAILY SALES','2022-10-25','2022-10-25 15:43:49','2022-10-26 15:43:49','889',0.00,0.00,'889','2022-10-25 19:25:50','889','2022-10-25 19:26:04',10,0),('1','275',172,'DAILY SALES','2022-10-26','2022-10-26 06:27:35','2022-10-27 06:27:35','889',0.00,0.00,'889','2022-10-26 18:58:14','889','2022-10-26 18:58:30',10,0),('1','275',173,'DAILY SALES','2022-10-27','2022-10-27 06:23:57','2022-10-28 06:23:57','889',0.00,0.00,'889','2022-10-27 18:48:20','889','2022-10-27 18:48:36',10,0),('1','275',174,'DAILY SALES','2022-10-28','2022-10-28 06:20:43','2022-10-29 06:20:43','889',0.00,0.00,'889','2022-10-28 19:05:34','889','2022-10-28 19:06:35',10,0),('1','275',175,'DAILY SALES','2022-10-29','2022-10-29 06:35:42','2022-10-30 06:35:42','889',0.00,0.00,'889','2022-10-29 19:06:42','889','2022-10-29 19:06:57',10,0),('1','275',176,'DAILY SALES','2022-10-30','2022-10-30 07:01:28','2022-10-31 07:01:28','889',0.00,0.00,'889','2022-10-30 19:19:15','889','2022-10-30 19:19:34',10,0),('1','275',177,'DAILY SALES','2022-10-31','2022-10-31 06:34:54','2022-11-01 06:34:54','889',0.00,0.00,'889','2022-10-31 15:09:06','889','2022-10-31 15:10:48',10,0),('1','275',178,'DAILY SALES','2022-10-31','2022-10-31 15:16:38','2022-11-01 15:16:38','889',0.00,0.00,'889','2022-10-31 15:19:01','889','2022-10-31 15:19:15',10,0),('1','275',179,'DAILY SALES','2022-11-04','2022-11-04 17:22:10','2022-11-05 17:22:10','889',0.00,0.00,'889','2022-11-04 19:40:14','889','2022-11-04 19:40:34',10,0),('1','275',180,'DAILY SALES','2022-11-05','2022-11-05 08:53:24','2022-11-06 08:53:24','889',0.00,0.00,'889','2022-11-05 19:26:16','889','2022-11-05 19:26:34',10,0),('1','275',181,'DAILY SALES','2022-11-06','2022-11-06 08:10:36','2022-11-07 08:10:36','889',0.00,0.00,'889','2022-11-06 19:29:35','889','2022-11-06 19:29:54',10,0),('1','275',182,'DAILY SALES','2022-11-07','2022-11-07 07:02:31','2022-11-08 07:02:31','889',0.00,0.00,'889','2022-11-07 19:33:55','889','2022-11-07 19:34:11',10,0),('1','275',183,'DAILY SALES','2022-11-08','2022-11-08 06:26:52','2022-11-09 06:26:52','889',0.00,0.00,'889','2022-11-08 18:12:49','889','2022-11-08 18:13:06',10,0),('1','275',184,'DAILY SALES','2022-11-08','2022-11-08 18:13:35','2022-11-09 18:13:35','889',0.00,0.00,'889','2022-11-08 18:16:47','889','2022-11-08 18:17:02',10,0),('1','275',185,'DAILY SALES','2022-11-09','2022-11-09 06:22:05','2022-11-10 06:22:05','889',0.00,0.00,'889','2022-11-09 06:22:20','889','2022-11-09 06:22:54',10,0),('1','275',186,'DAILY SALES','2022-11-09','2022-11-09 06:23:14','2022-11-10 06:23:14','889',0.00,0.00,'889','2022-11-09 18:53:32','889','2022-11-09 18:53:46',10,0),('1','275',187,'DAILY SALES','2022-11-10','2022-11-10 06:47:52','2022-11-11 06:47:52','889',0.00,0.00,'889','2022-11-10 19:24:24','889','2022-11-10 19:24:39',10,0),('1','275',188,'DAILY SALES','2022-11-11','2022-11-11 06:36:50','2022-11-12 06:36:50','889',0.00,0.00,'889','2022-11-11 18:58:01','889','2022-11-11 18:58:31',10,0),('1','275',189,'DAILY SALES','2022-11-12','2022-11-12 06:52:50','2022-11-13 06:52:50','889',0.00,0.00,'889','2022-11-12 18:53:50','889','2022-11-12 18:54:10',10,0),('1','275',190,'DAILY SALES','2022-11-13','2022-11-13 06:27:54','2022-11-14 06:27:54','889',0.00,0.00,'889','2022-11-13 19:13:32','889','2022-11-13 19:13:46',10,0),('1','275',191,'DAILY SALES','2022-11-14','2022-11-14 06:32:05','2022-11-15 06:32:05','889',0.00,0.00,'889','2022-11-14 17:17:33','889','2022-11-14 17:17:56',10,0),('1','275',192,'DAILY SALES','2022-11-14','2022-11-14 17:18:21','2022-11-15 17:18:21','889',0.00,0.00,'889','2022-11-14 17:20:57','889','2022-11-14 17:21:18',10,0),('1','275',193,'DAILY SALES','2022-11-15','2022-11-15 06:56:24','2022-11-16 06:56:24','889',0.00,0.00,'889','2022-11-15 19:28:17','889','2022-11-15 19:28:33',10,0),('1','275',194,'DAILY SALES','2022-11-16','2022-11-16 06:50:36','2022-11-17 06:50:36','889',0.00,0.00,'889','2022-11-16 19:04:07','889','2022-11-16 19:04:25',10,0),('1','275',195,'DAILY SALES','2022-11-17','2022-11-17 06:46:21','2022-11-18 06:46:21','889',0.00,0.00,'889','2022-11-17 19:06:50','889','2022-11-17 19:07:07',10,0),('1','275',196,'DAILY SALES','2022-11-18','2022-11-18 06:57:18','2022-11-19 06:57:18','889',0.00,0.00,'889','2022-11-18 19:15:09','889','2022-11-18 19:15:27',10,0),('1','275',197,'DAILY SALES','2022-11-19','2022-11-19 06:50:36','2022-11-20 06:50:36','889',0.00,0.00,'889','2022-11-19 19:10:10','889','2022-11-19 19:10:32',10,0),('1','275',198,'DAILY SALES','2022-11-20','2022-11-20 06:53:43','2022-11-21 06:53:43','889',0.00,0.00,'889','2022-11-20 16:32:13','889','2022-11-20 16:32:35',10,0),('1','275',199,'DAILY SALES','2022-11-20','2022-11-20 16:34:02','2022-11-21 16:34:02','889',0.00,0.00,'889','2022-11-20 16:38:00','889','2022-11-20 16:38:21',10,0),('1','275',200,'DAILY SALES','2022-11-20','2022-11-20 17:17:40','2022-11-21 17:17:40','889',0.00,0.00,'889','2022-11-20 18:45:13','889','2022-11-20 18:45:31',10,0),('1','275',201,'DAILY SALES','2022-11-21','2022-11-21 07:04:44','2022-11-22 07:04:44','889',0.00,0.00,'889','2022-11-21 18:57:18','889','2022-11-21 18:57:34',10,0),('1','275',202,'DAILY SALES','2022-11-22','2022-11-22 07:05:27','2022-11-23 07:05:27','889',0.00,0.00,'889','2022-11-22 19:05:17','889','2022-11-22 19:05:32',10,0),('1','275',203,'DAILY SALES','2022-11-23','2022-11-23 06:48:32','2022-11-24 06:48:32','889',0.00,0.00,'889','2022-11-23 18:58:34','889','2022-11-23 18:58:50',10,0),('1','275',204,'DAILY SALES','2022-11-24','2022-11-24 06:45:58','2022-11-25 06:45:58','889',0.00,0.00,'889','2022-11-24 19:06:15','889','2022-11-24 19:06:34',10,0),('1','275',205,'DAILY SALES','2022-11-25','2022-11-25 06:53:18','2022-11-26 06:53:18','889',0.00,0.00,'889','2022-11-25 19:13:56','889','2022-11-25 19:14:14',10,0),('1','275',206,'DAILY SALES','2022-11-26','2022-11-26 06:58:39','2022-11-27 06:58:39','889',0.00,0.00,'889','2022-11-26 15:56:17','889','2022-11-26 15:56:33',10,0),('1','275',207,'DAILY SALES','2022-11-26','2022-11-26 16:40:41','2022-11-27 16:40:41','889',0.00,0.00,'889','2022-11-26 18:52:32','889','2022-11-26 18:52:50',10,0),('1','275',208,'DAILY SALES','2022-11-27','2022-11-27 06:58:30','2022-11-28 06:58:30','889',0.00,0.00,'889','2022-11-27 18:50:03','889','2022-11-27 18:50:22',10,0),('1','275',209,'DAILY SALES','2022-11-28','2022-11-28 07:38:02','2022-11-29 07:38:02','889',0.00,0.00,'889','2022-11-28 18:49:08','889','2022-11-28 18:49:22',10,0),('1','275',210,'DAILY SALES','2022-11-29','2022-11-29 06:30:54','2022-11-30 06:30:54','889',0.00,0.00,'889','2022-11-29 19:05:44','889','2022-11-29 19:05:58',10,0),('1','275',211,'DAILY SALES','2022-11-30','2022-11-30 06:32:35','2022-12-01 06:32:35','889',0.00,0.00,'889','2022-11-30 18:52:36','889','2022-11-30 18:52:51',10,0),('1','275',212,'DAILY SALES','2022-12-01','2022-12-01 06:38:27','2022-12-02 06:38:27','889',0.00,0.00,'889','2022-12-01 18:55:26','889','2022-12-01 18:55:40',10,0),('1','275',213,'DAILY SALES','2022-12-02','2022-12-02 07:00:02','2022-12-03 07:00:02','889',0.00,0.00,'889','2022-12-02 18:59:05','889','2022-12-02 18:59:20',10,0),('1','275',214,'DAILY SALES','2022-12-03','2022-12-03 06:45:54','2022-12-04 06:45:54','889',0.00,0.00,'889','2022-12-03 10:57:37','889','2022-12-03 10:58:17',10,0),('1','275',215,'DAILY SALES','2022-12-03','2022-12-03 12:10:35','2022-12-04 12:10:35','889',0.00,0.00,'889','2022-12-03 19:00:21','889','2022-12-03 19:00:38',10,0),('1','275',216,'DAILY SALES','2022-12-04','2022-12-04 06:38:23','2022-12-05 06:38:23','889',0.00,0.00,'889','2022-12-04 19:08:25','889','2022-12-04 19:08:40',10,0),('1','275',217,'DAILY SALES','2022-12-05','2022-12-05 06:42:16','2022-12-06 06:42:16','889',0.00,0.00,'889','2022-12-05 19:07:53','889','2022-12-05 19:08:11',10,0),('1','275',218,'DAILY SALES','2022-12-06','2022-12-06 06:47:27','2022-12-07 06:47:27','889',0.00,0.00,'889','2022-12-06 18:51:20','889','2022-12-06 18:51:40',10,0),('1','275',219,'DAILY SALES','2022-12-07','2022-12-07 07:00:48','2022-12-08 07:00:48','889',0.00,0.00,'889','2022-12-07 19:21:34','889','2022-12-07 19:21:50',10,0),('1','275',220,'DAILY SALES','2022-12-08','2022-12-08 07:01:37','2022-12-09 07:01:37','889',0.00,0.00,'889','2022-12-08 19:07:22','889','2022-12-08 19:07:39',10,0),('1','275',221,'DAILY SALES','2022-12-09','2022-12-09 07:15:20','2022-12-10 07:15:20','889',0.00,0.00,'889','2022-12-09 08:49:07','889','2022-12-09 08:49:26',10,0),('1','275',222,'DAILY SALES','2022-12-09','2022-12-09 08:49:54','2022-12-10 08:49:54','889',0.00,0.00,'889','2022-12-09 08:53:29','889','2022-12-09 08:53:46',10,0),('1','275',223,'DAILY SALES','2022-12-09','2022-12-09 12:04:22','2022-12-10 12:04:22','889',0.00,0.00,'889','2022-12-09 19:04:09','889','2022-12-09 19:04:23',10,0),('1','275',224,'DAILY SALES','2022-12-10','2022-12-10 07:04:41','2022-12-11 07:04:41','889',0.00,0.00,'889','2022-12-10 18:47:10','889','2022-12-10 18:47:25',10,0),('1','275',225,'DAILY SALES','2022-12-11','2022-12-11 07:18:30','2022-12-12 07:18:30','889',0.00,0.00,'889','2022-12-11 19:14:39','889','2022-12-11 19:14:57',10,0),('1','275',226,'DAILY SALES','2022-12-12','2022-12-12 06:34:51','2022-12-13 06:34:51','889',0.00,0.00,'889','2022-12-12 19:01:59','889','2022-12-12 19:02:14',10,0),('1','275',227,'DAILY SALES','2022-12-13','2022-12-13 06:50:54','2022-12-14 06:50:54','889',0.00,0.00,'889','2022-12-13 19:17:51','889','2022-12-13 19:18:07',10,0),('1','275',228,'DAILY SALES','2022-12-14','2022-12-14 06:26:50','2022-12-15 06:26:50','889',0.00,0.00,'889','2022-12-14 19:21:33','889','2022-12-14 19:21:47',10,0),('1','275',229,'DAILY SALES','2022-12-15','2022-12-15 06:25:02','2022-12-16 06:25:02','889',0.00,0.00,'889','2022-12-15 15:27:42','889','2022-12-15 15:27:57',10,0),('1','275',230,'DAILY SALES','2022-12-15','2022-12-15 15:28:47','2022-12-16 15:28:47','889',0.00,0.00,'889','2022-12-15 16:14:15','889','2022-12-15 16:14:33',10,0),('1','275',231,'DAILY SALES','2022-12-15','2022-12-15 16:50:01','2022-12-16 16:50:01','889',0.00,0.00,'889','2022-12-15 19:11:30','889','2022-12-15 19:11:44',10,0),('1','275',232,'DAILY SALES','2022-12-16','2022-12-16 06:38:36','2022-12-17 06:38:36','889',0.00,0.00,'889','2022-12-16 19:04:06','889','2022-12-16 19:04:26',10,0),('1','275',233,'DAILY SALES','2022-12-17','2022-12-17 06:28:53','2022-12-18 06:28:53','889',0.00,0.00,'889','2022-12-17 19:24:44','889','2022-12-17 19:25:04',10,0),('1','275',234,'DAILY SALES','2022-12-18','2022-12-18 06:36:34','2022-12-19 06:36:34','889',0.00,0.00,'889','2022-12-18 19:11:48','889','2022-12-18 19:12:07',10,0),('1','275',235,'DAILY SALES','2022-12-19','2022-12-19 06:36:42','2022-12-20 06:36:42','889',0.00,0.00,'889','2022-12-19 19:03:15','889','2022-12-19 19:03:29',10,0),('1','275',236,'DAILY SALES','2022-12-20','2022-12-20 06:28:37','2022-12-21 06:28:37','889',0.00,0.00,'889','2022-12-20 18:56:17','889','2022-12-20 18:56:31',10,0),('1','275',237,'DAILY SALES','2022-12-20','2022-12-20 19:04:03','2022-12-21 19:04:03','889',0.00,0.00,'889','2022-12-20 19:06:35','889','2022-12-20 19:06:50',10,0),('1','275',238,'DAILY SALES','2022-12-21','2022-12-21 07:26:51','2022-12-22 07:26:51','889',0.00,0.00,'889','2022-12-21 18:55:29','889','2022-12-21 18:55:44',10,0),('1','275',239,'DAILY SALES','2022-12-22','2022-12-22 06:35:29','2022-12-23 06:35:29','889',0.00,0.00,'889','2022-12-22 19:03:35','889','2022-12-22 19:03:51',10,0),('1','275',240,'DAILY SALES','2022-12-23','2022-12-23 06:56:49','2022-12-24 06:56:49','889',0.00,0.00,'889','2022-12-23 19:06:20','889','2022-12-23 19:06:39',10,0),('1','275',241,'DAILY SALES','2022-12-24','2022-12-24 06:51:41','2022-12-25 06:51:41','889',0.00,0.00,'889','2022-12-24 18:49:14','889','2022-12-24 18:49:32',10,0),('1','275',242,'DAILY SALES','2022-12-24','2022-12-24 18:53:00','2022-12-25 18:53:00','889',0.00,0.00,'889','2022-12-24 18:55:46','889','2022-12-24 18:56:07',10,0),('1','275',243,'DAILY SALES','2022-12-25','2022-12-25 07:26:11','2022-12-26 07:26:11','889',0.00,0.00,'889','2022-12-25 19:06:35','889','2022-12-25 19:06:48',10,0),('1','275',244,'DAILY SALES','2022-12-26','2022-12-26 06:41:26','2022-12-27 06:41:26','889',0.00,0.00,'889','2022-12-26 19:12:35','889','2022-12-26 19:12:51',10,0),('1','275',245,'DAILY SALES','2022-12-27','2022-12-27 06:47:14','2022-12-28 06:47:14','889',0.00,0.00,'889','2022-12-27 19:09:35','889','2022-12-27 19:09:49',10,0),('1','275',246,'DAILY SALES','2022-12-28','2022-12-28 06:53:50','2022-12-29 06:53:50','889',0.00,0.00,'889','2022-12-28 19:23:36','889','2022-12-28 19:23:51',10,0),('1','275',247,'DAILY SALES','2022-12-29','2022-12-29 06:21:12','2022-12-30 06:21:12','889',0.00,0.00,'889','2022-12-29 19:36:44','889','2022-12-29 19:36:59',10,0),('1','275',248,'DAILY SALES','2022-12-30','2022-12-30 06:46:33','2022-12-31 06:46:33','889',0.00,0.00,'889','2022-12-30 19:25:20','889','2022-12-30 19:25:35',10,0),('1','275',249,'DAILY SALES','2022-12-31','2022-12-31 06:38:25','2023-01-01 06:38:25','889',0.00,0.00,'889','2022-12-31 19:21:59','889','2022-12-31 19:22:14',10,0),('1','275',250,'DAILY SALES','2022-12-31','2022-12-31 19:31:41','2023-01-01 19:31:41','889',0.00,0.00,'889','2022-12-31 19:37:09','889','2022-12-31 19:37:23',10,0),('1','275',251,'DAILY SALES','2023-01-01','2023-01-01 08:13:45','2023-01-02 08:13:45','889',0.00,0.00,'889','2023-01-01 19:01:26','889','2023-01-01 19:01:40',10,0),('1','275',252,'DAILY SALES','2023-01-02','2023-01-02 06:56:09','2023-01-03 06:56:09','889',0.00,0.00,'889','2023-01-02 19:13:44','889','2023-01-02 19:14:02',10,0),('1','275',253,'DAILY SALES','2023-01-03','2023-01-03 06:47:25','2023-01-04 06:47:25','889',0.00,0.00,'889','2023-01-03 19:20:47','889','2023-01-03 19:21:02',10,0),('1','275',254,'DAILY SALES','2023-01-04','2023-01-04 06:57:18','2023-01-05 06:57:18','889',0.00,0.00,'889','2023-01-04 19:38:32','889','2023-01-04 19:38:47',10,0),('1','275',255,'DAILY SALES','2023-01-05','2023-01-05 06:43:59','2023-01-06 06:43:59','889',0.00,0.00,'889','2023-01-05 18:57:54','889','2023-01-05 18:58:10',10,0),('1','275',256,'DAILY SALES','2023-01-06','2023-01-06 06:49:39','2023-01-07 06:49:39','889',0.00,0.00,'889','2023-01-06 19:03:53','889','2023-01-06 19:04:09',10,0),('1','275',257,'DAILY SALES','2023-01-07','2023-01-07 06:44:01','2023-01-08 06:44:01','889',0.00,0.00,'889','2023-01-07 13:22:37','889','2023-01-07 13:22:51',10,0),('1','275',258,'DAILY SALES','2023-01-07','2023-01-07 13:23:17','2023-01-08 13:23:17','889',0.00,0.00,'889','2023-01-07 14:29:46','889','2023-01-07 14:30:00',10,0),('1','275',259,'DAILY SALES','2023-01-07','2023-01-07 14:30:57','2023-01-08 14:30:57','889',0.00,0.00,'889','2023-01-07 19:29:12','889','2023-01-07 19:29:29',10,0),('1','275',260,'DAILY SALES','2023-01-08','2023-01-08 06:43:07','2023-01-09 06:43:07','889',0.00,0.00,'889','2023-01-08 19:44:48','889','2023-01-08 19:45:03',10,0),('1','275',261,'DAILY SALES','2023-01-09','2023-01-09 06:50:51','2023-01-10 06:50:51','889',0.00,0.00,'889','2023-01-09 19:19:31','889','2023-01-09 19:20:04',10,0),('1','275',262,'DAILY SALES','2023-01-10','2023-01-10 07:03:52','2023-01-11 07:03:52','889',0.00,0.00,'889','2023-01-10 19:29:33','889','2023-01-10 19:30:59',10,0),('1','275',263,'DAILY SALES','2023-01-11','2023-01-11 07:00:39','2023-01-12 07:00:39','889',0.00,0.00,'889','2023-01-11 19:22:13','889','2023-01-11 19:22:40',10,0),('1','275',264,'DAILY SALES','2023-01-12','2023-01-12 06:46:35','2023-01-13 06:46:35','889',0.00,0.00,'889','2023-01-12 19:18:42','889','2023-01-12 19:18:56',10,0),('1','275',265,'DAILY SALES','2023-01-13','2023-01-13 06:59:23','2023-01-14 06:59:23','889',0.00,0.00,'889','2023-01-13 12:50:11','889','2023-01-13 12:50:43',10,0),('1','275',266,'DAILY SALES','2023-01-13','2023-01-13 12:52:48','2023-01-14 12:52:48','889',0.00,0.00,'889','2023-01-13 12:58:18','889','2023-01-13 12:58:45',10,0),('1','275',267,'DAILY SALES','2023-01-13','2023-01-13 12:59:29','2023-01-14 12:59:29','889',0.00,0.00,'889','2023-01-13 19:26:52','889','2023-01-13 19:27:24',10,0),('1','275',268,'DAILY SALES','2023-01-14','2023-01-14 06:55:35','2023-01-15 06:55:35','889',0.00,0.00,'889','2023-01-14 19:12:32','889','2023-01-14 19:12:58',10,0),('1','275',269,'DAILY SALES','2023-01-15','2023-01-15 06:53:20','2023-01-16 06:53:20','889',0.00,0.00,'889','2023-01-15 19:14:08','889','2023-01-15 19:14:30',10,0),('1','275',270,'DAILY SALES','2023-01-16','2023-01-16 06:53:26','2023-01-17 06:53:26','889',0.00,0.00,'889','2023-01-16 19:10:30','889','2023-01-16 19:10:47',10,0),('1','275',271,'DAILY SALES','2023-01-17','2023-01-17 06:42:04','2023-01-18 06:42:04','889',0.00,0.00,'889','2023-01-17 19:28:55','889','2023-01-17 19:29:17',10,0),('1','275',272,'DAILY SALES','2023-01-18','2023-01-18 07:02:04','2023-01-19 07:02:04','889',0.00,0.00,'889','2023-01-18 19:40:51','889','2023-01-18 19:41:09',10,0),('1','275',273,'DAILY SALES','2023-01-19','2023-01-19 07:04:54','2023-01-20 07:04:54','889',0.00,0.00,'889','2023-01-19 11:21:51','889','2023-01-19 11:22:07',10,0),('1','275',274,'DAILY SALES','2023-01-19','2023-01-19 11:22:58','2023-01-20 11:22:58','889',0.00,0.00,'889','2023-01-19 11:28:03','889','2023-01-19 11:28:17',10,0),('1','275',275,'DAILY SALES','2023-01-19','2023-01-19 11:33:24','2023-01-20 11:33:24','889',0.00,0.00,'889','2023-01-19 19:28:58','889','2023-01-19 19:29:42',10,0),('1','275',276,'DAILY SALES','2023-01-20','2023-01-20 06:46:35','2023-01-21 06:46:35','889',0.00,0.00,'889','2023-01-20 19:26:58','889','2023-01-20 19:27:15',10,0),('1','275',277,'DAILY SALES','2023-01-21','2023-01-21 07:02:05','2023-01-22 07:02:05','889',0.00,0.00,'889','2023-01-21 19:39:31','889','2023-01-21 19:39:55',10,0),('1','275',278,'DAILY SALES','2023-01-22','2023-01-22 07:11:17','2023-01-23 07:11:17','889',0.00,0.00,'889','2023-01-22 19:18:39','889','2023-01-22 19:18:58',10,0),('1','275',279,'DAILY SALES','2023-01-23','2023-01-23 07:11:02','2023-01-24 07:11:02','889',0.00,0.00,'889','2023-01-23 19:45:49','889','2023-01-23 19:46:12',10,0),('1','275',280,'DAILY SALES','2023-01-24','2023-01-24 07:05:43','2023-01-25 07:05:43','889',0.00,0.00,'889','2023-01-24 12:14:37','889','2023-01-24 12:14:57',10,0),('1','275',281,'DAILY SALES','2023-01-24','2023-01-24 12:34:25','2023-01-25 12:34:25','889',0.00,0.00,'889','2023-01-24 16:45:20','889','2023-01-24 16:45:35',10,0),('1','275',282,'DAILY SALES','2023-01-24','2023-01-24 16:45:51','2023-01-25 16:45:51','889',0.00,0.00,'889','2023-01-25 06:59:41','889','2023-01-25 07:00:05',10,0),('1','275',283,'DAILY SALES','2023-01-25','2023-01-25 07:01:30','2023-01-26 07:01:30','889',0.00,0.00,'889','2023-01-25 20:02:53','889','2023-01-25 20:03:16',10,0),('1','275',284,'DAILY SALES','2023-01-26','2023-01-26 07:03:37','2023-01-27 07:03:37','889',0.00,0.00,'889','2023-01-26 19:48:56','889','2023-01-26 19:49:14',10,0),('1','275',285,'DAILY SALES','2023-01-27','2023-01-27 06:55:01','2023-01-28 06:55:01','889',0.00,0.00,'889','2023-01-27 19:39:44','889','2023-01-27 19:40:04',10,0),('1','275',286,'DAILY SALES','2023-01-28','2023-01-28 06:48:47','2023-01-29 06:48:47','889',0.00,0.00,'889','2023-01-28 20:00:41','889','2023-01-28 20:01:03',10,0),('1','275',287,'DAILY SALES','2023-01-29','2023-01-29 07:02:35','2023-01-30 07:02:35','889',0.00,0.00,'889','2023-01-29 20:16:13','889','2023-01-29 20:16:32',10,0),('1','275',288,'DAILY SALES','2023-01-30','2023-01-30 06:55:37','2023-01-31 06:55:37','889',0.00,0.00,'889','2023-01-30 11:44:48','889','2023-01-30 11:45:29',10,0),('1','275',289,'DAILY SALES','2023-01-30','2023-01-30 11:46:00','2023-01-31 11:46:00','889',0.00,0.00,'889','2023-01-30 19:58:03','889','2023-01-30 19:58:22',10,0),('1','275',290,'DAILY SALES','2023-01-31','2023-01-31 07:05:02','2023-02-01 07:05:02','889',0.00,0.00,'889','2023-01-31 20:33:03','889','2023-01-31 20:34:06',10,0),('1','275',291,'DAILY SALES','2023-02-01','2023-02-01 07:03:38','2023-02-02 07:03:38','889',0.00,0.00,'889','2023-02-01 20:12:38','889','2023-02-01 20:12:59',10,0),('1','275',292,'DAILY SALES','2023-02-02','2023-02-02 07:01:14','2023-02-03 07:01:14','889',0.00,0.00,'889','2023-02-02 19:58:25','889','2023-02-02 19:58:49',10,0),('1','275',293,'DAILY SALES','2023-02-03','2023-02-03 07:12:17','2023-02-04 07:12:17','889',0.00,0.00,'889','2023-02-03 20:31:36','889','2023-02-03 20:32:09',10,0),('1','275',294,'DAILY SALES','2023-02-04','2023-02-04 06:44:29','2023-02-05 06:44:29','889',0.00,0.00,'889','2023-02-04 08:57:24','889','2023-02-04 08:57:41',10,0),('1','275',295,'DAILY SALES','2023-02-04','2023-02-04 08:58:09','2023-02-05 08:58:09','889',0.00,0.00,'889','2023-02-04 09:01:34','889','2023-02-04 09:01:53',10,0),('1','275',296,'DAILY SALES','2023-02-04','2023-02-04 09:55:10','2023-02-05 09:55:10','889',0.00,0.00,'889','2023-02-04 20:14:54','889','2023-02-04 20:15:23',10,0),('1','275',297,'DAILY SALES','2023-02-05','2023-02-05 07:07:57','2023-02-06 07:07:57','889',0.00,0.00,'889','2023-02-05 19:25:19','889','2023-02-05 19:25:33',10,0),('1','275',298,'DAILY SALES','2023-02-06','2023-02-06 06:40:30','2023-02-07 06:40:30','889',0.00,0.00,'889','2023-02-06 20:11:44','889','2023-02-06 20:12:02',10,0),('1','275',299,'DAILY SALES','2023-02-07','2023-02-07 06:34:24','2023-02-08 06:34:24','889',0.00,0.00,'889','2023-02-07 12:46:27','889','2023-02-07 12:46:42',10,0),('1','275',300,'DAILY SALES','2023-02-07','2023-02-07 12:47:20','2023-02-08 12:47:20','889',0.00,0.00,'889','2023-02-07 12:49:36','889','2023-02-07 12:49:52',10,0),('1','275',301,'DAILY SALES','2023-02-07','2023-02-07 17:43:56','2023-02-08 17:43:56','889',0.00,0.00,'889','2023-02-07 19:41:15','889','2023-02-07 19:41:29',10,0),('1','275',302,'DAILY SALES','2023-02-08','2023-02-08 06:41:07','2023-02-09 06:41:07','889',0.00,0.00,'889','2023-02-08 19:03:30','889','2023-02-08 19:03:47',10,0),('1','275',303,'DAILY SALES','2023-02-09','2023-02-09 06:44:43','2023-02-10 06:44:43','889',0.00,0.00,'889','2023-02-09 19:49:15','889','2023-02-09 19:49:31',10,0),('1','275',304,'DAILY SALES','2023-02-10','2023-02-10 06:48:30','2023-02-11 06:48:30','889',0.00,0.00,'889','2023-02-10 20:12:31','889','2023-02-10 20:12:51',10,0),('1','275',305,'DAILY SALES','2023-02-11','2023-02-11 06:45:54','2023-02-12 06:45:54','889',0.00,0.00,'889','2023-02-11 19:50:07','889','2023-02-11 19:51:16',10,0),('1','275',306,'DAILY SALES','2023-02-12','2023-02-12 06:47:21','2023-02-13 06:47:21','889',0.00,0.00,'889','2023-02-12 19:25:29','889','2023-02-12 19:25:45',10,0),('1','275',307,'DAILY SALES','2023-02-13','2023-02-13 07:50:14','2023-02-14 07:50:14','889',0.00,0.00,'889','2023-02-13 11:57:26','889','2023-02-13 11:57:42',10,0),('1','275',308,'DAILY SALES','2023-02-13','2023-02-13 12:01:10','2023-02-14 12:01:10','889',0.00,0.00,'889','2023-02-13 20:16:52','889','2023-02-13 20:17:17',10,0),('1','275',309,'DAILY SALES','2023-02-14','2023-02-14 06:37:20','2023-02-15 06:37:20','889',0.00,0.00,'889','2023-02-14 20:51:50','889','2023-02-14 20:52:08',10,0),('1','275',310,'DAILY SALES','2023-02-15','2023-02-15 06:24:08','2023-02-16 06:24:08','889',0.00,0.00,'889','2023-02-15 20:22:56','889','2023-02-15 20:23:14',10,0),('1','275',311,'DAILY SALES','2023-02-16','2023-02-16 06:59:13','2023-02-17 06:59:13','889',0.00,0.00,'889','2023-02-16 20:51:55','889','2023-02-16 20:52:16',10,0),('1','275',312,'DAILY SALES','2023-02-17','2023-02-17 06:38:11','2023-02-18 06:38:11','889',0.00,0.00,'889','2023-02-17 20:24:26','889','2023-02-17 20:24:45',10,0),('1','275',313,'DAILY SALES','2023-02-18','2023-02-18 07:00:11','2023-02-19 07:00:11','889',0.00,0.00,'889','2023-02-18 13:09:45','889','2023-02-18 14:43:35',10,0),('1','275',314,'DAILY SALES','2023-02-18','2023-02-18 14:47:19','2023-02-19 14:47:19','889',0.00,0.00,'889','2023-02-18 14:50:26','889','2023-02-18 14:50:43',10,0),('1','275',315,'DAILY SALES','2023-02-18','2023-02-18 14:52:55','2023-02-19 14:52:55','889',0.00,0.00,'889','2023-02-18 19:49:35','889','2023-02-18 19:49:52',10,0),('1','275',316,'DAILY SALES','2023-02-19','2023-02-19 06:49:23','2023-02-20 06:49:23','889',0.00,0.00,'889','2023-02-19 19:29:33','889','2023-02-19 19:29:48',10,0),('1','275',317,'DAILY SALES','2023-02-20','2023-02-20 06:45:59','2023-02-21 06:45:59','889',0.00,0.00,'889','2023-02-20 20:29:37','889','2023-02-20 20:29:57',10,0),('1','275',318,'DAILY SALES','2023-02-21','2023-02-21 06:57:27','2023-02-22 06:57:27','889',0.00,0.00,'889','2023-02-21 20:03:13','889','2023-02-21 20:03:29',10,0),('1','275',319,'DAILY SALES','2023-02-22','2023-02-22 06:48:41','2023-02-23 06:48:41','889',0.00,0.00,'889','2023-02-22 17:55:28','889','2023-02-22 17:55:46',10,0),('1','275',320,'DAILY SALES','2023-02-22','2023-02-22 18:04:13','2023-02-23 18:04:13','889',0.00,0.00,'889','2023-02-22 18:07:47','889','2023-02-22 18:08:05',10,0),('1','275',321,'DAILY SALES','2023-02-22','2023-02-22 20:10:07','2023-02-23 20:10:07','889',0.00,0.00,'889','2023-02-22 20:11:50','889','2023-02-22 20:12:28',10,0),('1','275',322,'DAILY SALES','2023-02-23','2023-02-23 06:47:06','2023-02-24 06:47:06','889',0.00,0.00,'889','2023-02-23 19:44:04','889','2023-02-23 19:44:22',10,0),('1','275',323,'DAILY SALES','2023-02-24','2023-02-24 06:46:47','2023-02-25 06:46:47','889',0.00,0.00,'889','2023-02-24 20:35:42','889','2023-02-24 20:36:41',10,0),('1','275',324,'DAILY SALES','2023-02-26','2023-02-26 06:48:30','2023-02-27 06:48:30','889',0.00,0.00,'889','2023-02-26 19:42:23','889','2023-02-26 19:43:02',10,0),('1','275',325,'DAILY SALES','2023-02-27','2023-02-27 07:57:05','2023-02-28 07:57:05','889',0.00,0.00,'889','2023-02-27 10:15:28','889','2023-02-27 10:15:46',10,0),('1','275',326,'DAILY SALES','2023-02-27','2023-02-27 10:16:10','2023-02-28 10:16:10','889',0.00,0.00,'889','2023-02-27 21:08:46','889','2023-02-27 21:09:05',10,0),('1','275',327,'DAILY SALES','2023-02-28','2023-02-28 06:49:24','2023-03-01 06:49:24','889',0.00,0.00,'889','2023-02-28 19:44:11','889','2023-02-28 19:44:29',10,0),('1','275',328,'DAILY SALES','2023-03-01','2023-03-01 06:33:57','2023-03-02 06:33:57','889',0.00,0.00,'889','2023-03-01 20:20:57','889','2023-03-01 20:21:22',10,0),('1','275',329,'DAILY SALES','2023-03-02','2023-03-02 06:48:02','2023-03-03 06:48:02','889',0.00,0.00,'889','2023-03-02 19:42:22','889','2023-03-02 19:42:40',10,0),('1','275',330,'DAILY SALES','2023-03-03','2023-03-03 06:53:44','2023-03-04 06:53:44','889',0.00,0.00,'889','2023-03-03 16:48:46','889','2023-03-03 16:49:05',10,0),('1','275',331,'DAILY SALES','2023-03-03','2023-03-03 17:34:38','2023-03-04 17:34:38','889',0.00,0.00,'889','2023-03-03 17:38:09','889','2023-03-03 17:38:30',10,0),('1','275',332,'DAILY SALES','2023-03-03','2023-03-03 17:55:23','2023-03-04 17:55:23','889',0.00,0.00,'889','2023-03-03 19:27:48','889','2023-03-03 19:28:02',10,0),('1','275',333,'DAILY SALES','2023-03-04','2023-03-04 06:50:58','2023-03-05 06:50:58','889',0.00,0.00,'889','2023-03-04 19:43:51','889','2023-03-04 19:44:08',10,0),('1','275',334,'DAILY SALES','2023-03-05','2023-03-05 06:43:08','2023-03-06 06:43:08','889',0.00,0.00,'889','2023-03-05 20:14:12','889','2023-03-05 20:14:29',10,0),('1','275',335,'DAILY SALES','2023-03-06','2023-03-06 06:39:45','2023-03-07 06:39:45','889',0.00,0.00,'889','2023-03-06 19:38:58','889','2023-03-06 19:39:15',10,0),('1','275',336,'DAILY SALES','2023-03-07','2023-03-07 06:46:19','2023-03-08 06:46:19','889',0.00,0.00,'889','2023-03-07 20:14:21','889','2023-03-07 20:14:40',10,0),('1','275',337,'DAILY SALES','2023-03-08','2023-03-08 06:47:20','2023-03-09 06:47:20','889',0.00,0.00,'889','2023-03-08 16:15:02','889','2023-03-08 16:15:22',10,0),('1','275',338,'DAILY SALES','2023-03-08','2023-03-08 16:17:18','2023-03-09 16:17:18','889',0.00,0.00,'889','2023-03-08 16:19:44','889','2023-03-08 16:19:59',10,0),('1','275',339,'DAILY SALES','2023-03-08','2023-03-08 20:03:27','2023-03-09 20:03:27','889',0.00,0.00,'889','2023-03-08 20:06:51','889','2023-03-08 20:07:08',10,0),('1','275',340,'DAILY SALES','2023-03-09','2023-03-09 06:45:19','2023-03-10 06:45:19','889',0.00,0.00,'889','2023-03-09 19:29:34','889','2023-03-09 19:29:49',10,0),('1','275',341,'DAILY SALES','2023-03-10','2023-03-10 06:39:28','2023-03-11 06:39:28','889',0.00,0.00,'889','2023-03-10 19:55:22','889','2023-03-10 19:55:38',10,0),('1','275',342,'DAILY SALES','2023-03-11','2023-03-11 06:54:39','2023-03-12 06:54:39','889',0.00,0.00,'889','2023-03-11 20:11:49','889','2023-03-11 20:12:05',10,0),('1','275',343,'DAILY SALES','2023-03-12','2023-03-12 06:38:26','2023-03-13 06:38:26','889',0.00,0.00,'889','2023-03-12 20:26:30','889','2023-03-12 20:26:54',10,0),('1','275',344,'DAILY SALES','2023-03-13','2023-03-13 06:25:44','2023-03-14 06:25:44','889',0.00,0.00,'889','2023-03-13 14:43:39','889','2023-03-13 14:43:59',10,0),('1','275',345,'DAILY SALES','2023-03-13','2023-03-13 14:44:23','2023-03-14 14:44:23','889',0.00,0.00,'889','2023-03-13 20:23:06','889','2023-03-13 20:23:25',10,0),('1','275',346,'DAILY SALES','2023-03-14','2023-03-14 06:40:39','2023-03-15 06:40:39','889',0.00,0.00,'889','2023-03-14 19:36:32','889','2023-03-14 19:36:47',10,0),('1','275',347,'DAILY SALES','2023-03-15','2023-03-15 06:37:25','2023-03-16 06:37:25','889',0.00,0.00,'889','2023-03-15 19:45:29','889','2023-03-15 19:45:43',10,0),('1','275',348,'DAILY SALES','2023-03-16','2023-03-16 06:53:52','2023-03-17 06:53:52','889',0.00,0.00,'889','2023-03-16 19:41:21','889','2023-03-16 19:41:38',10,0),('1','275',349,'DAILY SALES','2023-03-17','2023-03-17 06:27:07','2023-03-18 06:27:07','889',0.00,0.00,'889','2023-03-17 19:46:01','889','2023-03-17 19:46:14',10,0),('1','275',350,'DAILY SALES','2023-03-18','2023-03-18 07:13:24','2023-03-19 07:13:24','889',0.00,0.00,'889','2023-03-18 09:57:34','889','2023-03-18 09:57:48',10,0),('1','275',351,'DAILY SALES','2023-03-18','2023-03-18 10:01:55','2023-03-19 10:01:55','889',0.00,0.00,'889','2023-03-18 19:53:22','889','2023-03-18 19:53:38',10,0),('1','275',352,'DAILY SALES','2023-03-19','2023-03-19 06:48:59','2023-03-20 06:48:59','889',0.00,0.00,'889','2023-03-19 19:19:27','889','2023-03-19 19:19:41',10,0),('1','275',353,'DAILY SALES','2023-03-20','2023-03-20 06:52:37','2023-03-21 06:52:37','889',0.00,0.00,'889','2023-03-20 20:05:55','889','2023-03-20 20:06:14',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=707 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','275','1','1',1,'1','1',0.00,205.70,0.00,0.00,205.70,153040.80,0.00,0.00,0.00),('1','275','1','1',2,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','2',3,'1','1',205.70,218.20,0.00,0.00,12.50,9300.00,0.00,0.00,0.00),('1','275','1','2',4,'2','1',0.00,83.13,0.00,0.00,83.13,61848.72,0.00,0.00,0.00),('1','275','1','3',5,'1','1',218.20,235.70,0.00,0.00,17.50,13020.00,0.00,0.00,0.00),('1','275','1','3',6,'2','1',83.13,266.62,0.00,0.00,183.49,136516.56,0.00,0.00,0.00),('1','275','1','4',7,'1','1',235.70,356.42,0.00,0.00,120.72,89815.68,0.00,0.00,0.00),('1','275','1','4',8,'2','1',266.62,266.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','5',9,'1','1',356.42,356.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','5',10,'2','1',266.62,387.74,0.00,0.00,121.12,90113.28,0.00,0.00,0.00),('1','275','1','6',11,'1','1',356.42,523.82,0.00,0.00,167.40,124545.60,0.00,0.00,0.00),('1','275','1','6',12,'2','1',387.74,387.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','7',13,'1','1',523.82,862.33,0.00,0.00,338.51,251851.44,0.00,0.00,0.00),('1','275','1','7',14,'2','1',387.74,387.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','8',15,'1','1',862.33,862.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','8',16,'2','1',387.74,619.70,0.00,0.00,231.96,172578.24,0.00,0.00,0.00),('1','275','1','9',17,'1','1',862.33,1055.86,0.00,0.00,193.53,143986.32,0.00,0.00,0.00),('1','275','1','9',18,'2','1',619.70,676.28,0.00,0.00,56.58,42095.52,0.00,0.00,0.00),('1','275','1','10',19,'1','1',1055.86,1055.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','10',20,'2','1',676.28,727.94,0.00,0.00,51.66,38435.04,0.00,0.00,0.00),('1','275','1','11',21,'1','1',1055.86,1055.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','11',22,'2','1',727.94,727.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','12',23,'1','1',1055.86,1937.07,0.00,0.00,881.21,655620.24,0.00,0.00,0.00),('1','275','1','12',24,'2','1',727.94,1407.63,0.00,0.00,679.69,505689.36,0.00,0.00,0.00),('1','275','1','13',25,'1','1',1937.07,3300.21,0.00,0.00,1363.14,1014176.16,0.00,0.00,0.00),('1','275','1','13',26,'2','1',1407.63,2071.59,0.00,0.00,663.96,493986.24,0.00,0.00,0.00),('1','275','1','14',27,'1','1',3300.21,3891.28,0.00,0.00,591.07,439756.08,0.00,0.00,0.00),('1','275','1','14',28,'2','1',2071.59,2139.92,0.00,0.00,68.33,50837.52,0.00,0.00,0.00),('1','275','1','15',29,'1','1',3891.28,4080.17,0.00,0.00,188.89,140534.16,0.00,0.00,0.00),('1','275','1','15',30,'2','1',2139.92,2425.75,0.00,0.00,285.83,212657.52,0.00,0.00,0.00),('1','275','1','16',31,'1','1',4080.17,4080.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','16',32,'2','1',2425.75,2425.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','17',33,'1','1',4080.17,4080.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','17',34,'2','1',2425.75,2612.64,0.00,0.00,186.89,139046.16,0.00,0.00,0.00),('1','275','1','18',35,'1','1',4080.17,4791.02,0.00,0.00,710.85,528872.40,0.00,0.00,0.00),('1','275','1','18',36,'2','1',2612.64,2956.68,0.00,0.00,344.04,255965.76,0.00,0.00,0.00),('1','275','1','19',37,'1','1',4791.02,6122.98,0.00,0.00,1331.96,990978.24,0.00,0.00,0.00),('1','275','1','19',38,'2','1',2956.68,3039.18,0.00,0.00,82.50,61380.00,0.00,0.00,0.00),('1','275','1','20',39,'1','1',6122.98,6994.30,0.00,0.00,871.32,648262.08,0.00,0.00,0.00),('1','275','1','20',40,'2','1',3039.18,3051.68,0.00,0.00,12.50,9300.00,0.00,0.00,0.00),('1','275','1','21',41,'1','1',6994.30,7787.55,0.00,0.00,793.25,590178.00,0.00,0.00,0.00),('1','275','1','21',42,'2','1',3051.68,3701.90,0.00,0.00,650.22,483763.68,0.00,0.00,0.00),('1','275','1','22',43,'1','1',7787.55,8046.07,0.00,0.00,258.52,192338.88,0.00,0.00,0.00),('1','275','1','22',44,'2','1',3701.90,3788.65,0.00,0.00,86.75,64542.00,0.00,0.00,0.00),('1','275','1','23',45,'1','1',8046.07,8046.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','23',46,'2','1',3788.65,3788.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','24',47,'1','1',8046.07,8153.73,0.00,0.00,107.66,80099.04,0.00,0.00,0.00),('1','275','1','24',48,'2','1',3788.65,3863.66,0.00,0.00,75.01,55807.44,0.00,0.00,0.00),('1','275','1','25',49,'1','1',8153.73,8701.15,0.00,0.00,547.42,407280.48,0.00,0.00,0.00),('1','275','1','25',50,'2','1',3863.66,4132.12,0.00,0.00,268.46,199734.24,0.00,0.00,0.00),('1','275','1','26',51,'1','1',8701.15,9023.62,0.00,0.00,322.47,239917.68,0.00,0.00,0.00),('1','275','1','26',52,'2','1',4132.12,4435.26,0.00,0.00,303.14,225536.16,0.00,0.00,0.00),('1','275','1','27',53,'1','1',9023.62,9946.85,0.00,0.00,923.23,686883.12,0.00,0.00,0.00),('1','275','1','27',54,'2','1',4435.26,4782.52,0.00,0.00,347.26,258361.44,0.00,0.00,0.00),('1','275','1','28',55,'1','1',9946.85,10548.51,0.00,0.00,601.66,447635.04,0.00,0.00,0.00),('1','275','1','28',56,'2','1',4782.52,5173.21,0.00,0.00,390.69,290673.36,0.00,0.00,0.00),('1','275','1','29',57,'1','1',10548.51,10712.22,0.00,0.00,163.71,121800.24,0.00,0.00,0.00),('1','275','1','29',58,'2','1',5173.21,5772.09,0.00,0.00,598.88,445566.72,0.00,0.00,0.00),('1','275','1','30',59,'1','1',10712.22,10874.37,0.00,0.00,162.15,120639.60,0.00,0.00,0.00),('1','275','1','30',60,'2','1',5772.09,6222.93,0.00,0.00,450.84,335424.96,0.00,0.00,0.00),('1','275','1','31',61,'1','1',10874.37,10874.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','31',62,'2','1',6222.93,6222.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','32',63,'1','1',10874.37,11100.25,0.00,0.00,225.88,168054.72,0.00,0.00,0.00),('1','275','1','32',64,'2','1',6222.93,6675.35,0.00,0.00,452.42,336600.48,0.00,0.00,0.00),('1','275','1','33',65,'1','1',11100.25,11659.51,0.00,0.00,559.26,416089.44,0.00,0.00,0.00),('1','275','1','33',66,'2','1',6675.35,6744.47,0.00,0.00,69.12,51425.28,0.00,0.00,0.00),('1','275','1','34',67,'1','1',11659.51,11972.96,0.00,0.00,313.45,233206.80,0.00,0.00,0.00),('1','275','1','34',68,'2','1',6744.47,6831.51,0.00,0.00,87.04,64757.76,0.00,0.00,0.00),('1','275','1','35',69,'1','1',11972.96,12723.27,0.00,0.00,750.31,558230.64,0.00,0.00,0.00),('1','275','1','35',70,'2','1',6831.51,6901.94,0.00,0.00,70.43,52399.92,0.00,0.00,0.00),('1','275','1','36',71,'1','1',12723.27,13192.81,0.00,0.00,469.54,349337.76,0.00,0.00,0.00),('1','275','1','36',72,'2','1',6901.94,6999.39,0.00,0.00,97.45,72502.80,0.00,0.00,0.00),('1','275','1','37',73,'1','1',13192.81,13492.52,0.00,0.00,299.71,222984.24,0.00,0.00,0.00),('1','275','1','37',74,'2','1',6999.39,7079.79,0.00,0.00,80.40,59817.60,0.00,0.00,0.00),('1','275','1','38',75,'1','1',13492.52,13832.30,0.00,0.00,339.78,252796.32,0.00,0.00,0.00),('1','275','1','38',76,'2','1',7079.79,7187.74,0.00,0.00,107.95,80314.80,0.00,0.00,0.00),('1','275','1','39',77,'1','1',13832.30,14142.25,0.00,0.00,309.95,230602.80,0.00,0.00,0.00),('1','275','1','39',78,'2','1',7187.74,7238.33,0.00,0.00,50.59,37638.96,0.00,0.00,0.00),('1','275','1','40',79,'1','1',14142.25,14373.57,0.00,0.00,231.32,172102.08,0.00,0.00,0.00),('1','275','1','40',80,'2','1',7238.33,7379.26,0.00,0.00,140.93,104851.92,0.00,0.00,0.00),('1','275','1','41',81,'1','1',14373.57,14768.47,0.00,0.00,394.90,293805.60,0.00,0.00,0.00),('1','275','1','41',82,'2','1',7379.26,7583.95,0.00,0.00,204.69,152289.36,0.00,0.00,0.00),('1','275','1','42',83,'1','1',14768.47,14768.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','42',84,'2','1',7583.95,7583.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','43',85,'1','1',14768.47,14768.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','43',86,'2','1',7583.95,7819.40,0.00,0.00,235.45,175174.80,0.00,0.00,0.00),('1','275','1','44',87,'1','1',14768.47,14776.56,0.00,0.00,8.09,6018.96,0.00,0.00,0.00),('1','275','1','44',88,'2','1',7819.40,8329.37,0.00,0.00,509.97,379417.68,0.00,0.00,0.00),('1','275','1','45',89,'1','1',14776.56,14776.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','45',90,'2','1',8329.37,8562.08,0.00,0.00,232.71,173136.24,0.00,0.00,0.00),('1','275','1','46',91,'1','1',14776.56,14776.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','46',92,'2','1',8562.08,8905.53,0.00,0.00,343.45,255526.80,0.00,0.00,0.00),('1','275','1','47',93,'1','1',14776.56,14776.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','47',94,'2','1',8905.53,9338.58,0.00,0.00,433.05,322189.20,0.00,0.00,0.00),('1','275','1','48',95,'1','1',14776.56,14776.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','48',96,'2','1',9338.58,9718.53,0.00,0.00,379.95,282682.80,0.00,0.00,0.00),('1','275','1','49',97,'1','1',14776.56,14776.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','49',98,'2','1',9718.53,10187.92,0.00,0.00,469.39,349226.16,0.00,0.00,0.00),('1','275','1','50',99,'1','1',14776.56,14776.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','50',100,'2','1',10187.92,10608.82,0.00,0.00,420.90,313149.60,0.00,0.00,0.00),('1','275','1','51',101,'1','1',14776.56,15463.38,0.00,0.00,686.82,510994.08,0.00,0.00,0.00),('1','275','1','51',102,'2','1',10608.82,10872.87,0.00,0.00,264.05,196453.20,0.00,0.00,0.00),('1','275','1','52',103,'1','1',15463.38,15620.77,0.00,0.00,157.39,117098.16,0.00,0.00,0.00),('1','275','1','52',104,'2','1',10872.87,11115.93,0.00,0.00,243.06,180836.64,0.00,0.00,0.00),('1','275','1','53',105,'1','1',15620.77,15922.52,0.00,0.00,301.75,224502.00,0.00,0.00,0.00),('1','275','1','53',106,'2','1',11115.93,11397.59,0.00,0.00,281.66,201948.64,0.00,0.00,0.00),('1','275','1','54',107,'1','1',15922.52,16221.90,0.00,0.00,299.38,222738.72,0.00,0.00,0.00),('1','275','1','54',108,'2','1',11397.59,11512.56,0.00,0.00,114.97,81858.64,0.00,0.00,0.00),('1','275','1','55',109,'1','1',16221.90,16221.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','55',110,'2','1',11512.56,11512.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','56',111,'1','1',16221.90,16449.83,0.00,0.00,227.93,169579.92,0.00,0.00,0.00),('1','275','1','56',112,'2','1',11512.56,11998.19,0.00,0.00,485.63,345768.56,0.00,0.00,0.00),('1','275','1','57',113,'1','1',16449.83,16661.86,0.00,0.00,212.03,157750.32,0.00,0.00,0.00),('1','275','1','57',114,'2','1',11998.19,12488.40,0.00,0.00,490.21,349029.52,0.00,0.00,0.00),('1','275','1','58',115,'1','1',16661.86,16996.03,0.00,0.00,334.17,248622.48,0.00,0.00,0.00),('1','275','1','58',116,'2','1',12488.40,13958.00,0.00,0.00,1469.60,1021372.00,0.00,0.00,0.00),('1','275','1','59',117,'1','1',16996.03,17278.08,0.00,0.00,282.05,209845.20,0.00,0.00,0.00),('1','275','1','59',118,'2','1',13958.00,14366.10,0.00,0.00,408.10,283629.50,0.00,0.00,0.00),('1','275','1','60',119,'1','1',17278.08,17500.44,0.00,0.00,222.36,165435.84,0.00,0.00,0.00),('1','275','1','60',120,'2','1',14366.10,15163.10,0.00,0.00,797.00,553915.00,0.00,0.00,0.00),('1','275','1','61',121,'1','1',17500.44,17500.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','61',122,'2','1',15163.10,15163.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','62',123,'1','1',17500.44,17857.31,0.00,0.00,356.87,265511.28,0.00,0.00,0.00),('1','275','1','62',124,'2','1',15163.10,16458.10,0.00,0.00,1295.00,900025.00,0.00,0.00,0.00),('1','275','1','63',125,'1','1',17857.31,18107.61,0.00,0.00,250.30,186223.20,0.00,0.00,0.00),('1','275','1','63',126,'2','1',16458.10,17100.90,0.00,0.00,642.80,446746.00,0.00,0.00,0.00),('1','275','1','64',127,'1','1',18107.61,18503.17,0.00,0.00,395.56,294296.64,0.00,0.00,0.00),('1','275','1','64',128,'2','1',17100.90,18097.62,0.00,0.00,996.72,692720.40,0.00,0.00,0.00),('1','275','1','65',129,'1','1',18503.17,18711.99,0.00,0.00,208.82,155362.08,0.00,0.00,0.00),('1','275','1','65',130,'2','1',18097.62,18958.82,0.00,0.00,861.20,598534.00,0.00,0.00,0.00),('1','275','1','66',131,'1','1',18711.99,18711.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','66',132,'2','1',18958.82,18958.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','67',133,'1','1',18711.99,18893.06,0.00,0.00,181.07,134716.08,0.00,0.00,0.00),('1','275','1','67',134,'2','1',18958.82,19100.34,0.00,0.00,141.52,98356.40,0.00,0.00,0.00),('1','275','1','68',135,'1','1',18893.06,19482.61,0.00,0.00,589.55,438625.20,0.00,0.00,0.00),('1','275','1','68',136,'2','1',19100.34,20067.90,0.00,0.00,967.56,672454.20,0.00,0.00,0.00),('1','275','1','69',137,'1','1',19482.61,20030.93,0.00,0.00,548.32,407950.08,0.00,0.00,0.00),('1','275','1','69',138,'2','1',20067.90,21088.93,0.00,0.00,1021.03,709615.85,0.00,0.00,0.00),('1','275','1','70',139,'1','1',20030.93,20602.25,0.00,0.00,571.32,425062.08,0.00,0.00,0.00),('1','275','1','70',140,'2','1',21088.93,21765.43,0.00,0.00,676.50,470167.50,0.00,0.00,0.00),('1','275','1','71',141,'1','1',20602.25,20738.19,0.00,0.00,135.94,101139.36,0.00,0.00,0.00),('1','275','1','71',142,'2','1',21765.43,21962.62,0.00,0.00,197.19,137047.05,0.00,0.00,0.00),('1','275','1','72',143,'1','1',20738.19,20738.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','72',144,'2','1',21962.62,21968.12,0.00,0.00,5.50,3822.50,0.00,0.00,0.00),('1','275','1','73',145,'1','1',20738.19,21444.06,0.00,0.00,705.87,525167.28,0.00,0.00,0.00),('1','275','1','73',146,'2','1',21968.12,22415.43,0.00,0.00,447.31,310880.45,0.00,0.00,0.00),('1','275','1','74',147,'1','1',21444.06,22237.67,0.00,0.00,793.61,590445.84,0.00,0.00,0.00),('1','275','1','74',148,'2','1',22415.43,22415.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','75',149,'1','1',22237.67,23053.05,0.00,0.00,815.38,606642.72,0.00,0.00,0.00),('1','275','1','75',150,'2','1',22415.43,22809.03,0.00,0.00,393.60,273552.00,0.00,0.00,0.00),('1','275','1','76',151,'1','1',23053.05,23638.94,0.00,0.00,585.89,435902.16,0.00,0.00,0.00),('1','275','1','76',152,'2','1',22809.03,23421.97,0.00,0.00,612.94,425993.30,0.00,0.00,0.00),('1','275','1','77',153,'1','1',23638.94,23930.53,0.00,0.00,291.59,216942.96,0.00,0.00,0.00),('1','275','1','77',154,'2','1',23421.97,23847.29,0.00,0.00,425.32,295597.40,0.00,0.00,0.00),('1','275','1','78',155,'1','1',23930.53,23930.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','78',156,'2','1',23847.29,23847.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','79',157,'1','1',23930.53,24358.54,0.00,0.00,428.01,318439.44,0.00,0.00,0.00),('1','275','1','79',158,'2','1',23847.29,24322.94,0.00,0.00,475.65,330576.75,0.00,0.00,0.00),('1','275','1','80',159,'1','1',24358.54,25281.23,0.00,0.00,922.69,686481.36,0.00,0.00,0.00),('1','275','1','80',160,'2','1',24322.94,24822.79,0.00,0.00,499.85,347395.75,0.00,0.00,0.00),('1','275','1','81',161,'1','1',25281.23,26122.47,0.00,0.00,841.24,639342.40,0.00,0.00,0.00),('1','275','1','81',162,'2','1',24822.79,24822.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','82',163,'1','1',26122.47,26992.52,0.00,0.00,870.05,661238.00,0.00,0.00,0.00),('1','275','1','82',164,'2','1',24822.79,24822.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','83',165,'1','1',26992.52,27782.97,0.00,0.00,790.45,600742.00,0.00,0.00,0.00),('1','275','1','83',166,'2','1',24822.79,24822.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','84',167,'1','1',27782.97,28356.97,0.00,0.00,574.00,436240.00,0.00,0.00,0.00),('1','275','1','84',168,'2','1',24822.79,24822.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','85',169,'1','1',28356.97,28356.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','85',170,'2','1',24822.79,24822.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','86',171,'1','1',28356.97,28962.89,0.00,0.00,605.92,460499.20,0.00,0.00,0.00),('1','275','1','86',172,'2','1',24822.79,24822.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','87',173,'1','1',28962.89,29841.18,0.00,0.00,878.29,667500.40,0.00,0.00,0.00),('1','275','1','87',174,'2','1',24822.79,24822.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','88',175,'1','1',29841.18,30844.57,0.00,0.00,1003.39,762576.40,0.00,0.00,0.00),('1','275','1','88',176,'2','1',24822.79,24822.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','89',177,'1','1',30844.57,31549.73,0.00,0.00,705.16,535921.60,0.00,0.00,0.00),('1','275','1','89',178,'2','1',24822.79,24822.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','90',179,'1','1',31549.73,31960.77,0.00,0.00,411.04,305813.76,0.00,0.00,0.00),('1','275','1','90',180,'2','1',24822.79,25874.13,0.00,0.00,1051.34,746451.40,0.00,0.00,0.00),('1','275','1','91',181,'1','1',31960.77,31960.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','91',182,'2','1',25874.13,25874.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','92',183,'1','1',31960.77,32108.71,0.00,0.00,147.94,110067.36,0.00,0.00,0.00),('1','275','1','92',184,'2','1',25874.13,26089.20,0.00,0.00,215.07,152699.70,0.00,0.00,0.00),('1','275','1','93',185,'1','1',32108.71,32693.47,0.00,0.00,584.76,435061.44,0.00,0.00,0.00),('1','275','1','93',186,'2','1',26089.20,26523.05,0.00,0.00,433.85,308033.50,0.00,0.00,0.00),('1','275','1','94',187,'1','1',32693.47,33288.97,0.00,0.00,595.50,443052.00,0.00,0.00,0.00),('1','275','1','94',188,'2','1',26523.05,27127.34,0.00,0.00,604.29,429045.90,0.00,0.00,0.00),('1','275','1','95',189,'1','1',33288.97,33960.64,0.00,0.00,671.67,499722.48,0.00,0.00,0.00),('1','275','1','95',190,'2','1',27127.34,27816.60,0.00,0.00,689.26,489374.60,0.00,0.00,0.00),('1','275','1','96',191,'1','1',33960.64,34659.81,0.00,0.00,699.17,520182.48,0.00,0.00,0.00),('1','275','1','96',192,'2','1',27816.60,28175.81,0.00,0.00,359.21,255039.10,0.00,0.00,0.00),('1','275','1','97',193,'1','1',34659.81,35081.29,0.00,0.00,421.48,313581.12,0.00,0.00,0.00),('1','275','1','97',194,'2','1',28175.81,28274.46,0.00,0.00,98.65,70041.50,0.00,0.00,0.00),('1','275','1','98',195,'1','1',35081.29,35081.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','98',196,'2','1',28274.46,28274.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','99',197,'1','1',35081.29,35221.78,0.00,0.00,140.49,104524.56,0.00,0.00,0.00),('1','275','1','99',198,'2','1',28274.46,28701.46,0.00,0.00,427.00,303170.00,0.00,0.00,0.00),('1','275','1','100',199,'1','1',35221.78,35842.53,0.00,0.00,620.75,461838.00,0.00,0.00,0.00),('1','275','1','100',200,'2','1',28701.46,29076.36,0.00,0.00,374.90,266179.00,0.00,0.00,0.00),('1','275','1','101',201,'1','1',35842.53,36498.28,0.00,0.00,655.75,487878.00,0.00,0.00,0.00),('1','275','1','101',202,'2','1',29076.36,29738.47,0.00,0.00,662.11,470098.10,0.00,0.00,0.00),('1','275','1','102',203,'1','1',36498.28,36949.92,0.00,0.00,451.64,336020.16,0.00,0.00,0.00),('1','275','1','102',204,'2','1',29738.47,30214.98,0.00,0.00,476.51,338322.10,0.00,0.00,0.00),('1','275','1','103',205,'1','1',36949.92,37572.49,0.00,0.00,622.57,463192.08,0.00,0.00,0.00),('1','275','1','103',206,'2','1',30214.98,31091.68,0.00,0.00,876.70,622457.00,0.00,0.00,0.00),('1','275','1','104',207,'1','1',37572.49,37593.06,0.00,0.00,20.57,15304.08,0.00,0.00,0.00),('1','275','1','104',208,'2','1',31091.68,31091.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','105',209,'1','1',37593.06,37593.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','105',210,'2','1',31091.68,31091.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','106',211,'1','1',37593.06,38315.12,0.00,0.00,722.06,537212.64,0.00,0.00,0.00),('1','275','1','106',212,'2','1',31091.68,31650.94,0.00,0.00,559.26,397280.30,0.00,0.00,0.00),('1','275','1','107',213,'1','1',38315.12,39192.72,0.00,0.00,877.60,652934.40,0.00,0.00,0.00),('1','275','1','107',214,'2','1',31650.94,32298.42,0.00,0.00,647.48,459710.80,0.00,0.00,0.00),('1','275','1','108',215,'1','1',39192.72,39687.60,0.00,0.00,494.88,368190.72,0.00,0.00,0.00),('1','275','1','108',216,'2','1',32298.42,32695.89,0.00,0.00,397.47,282203.70,0.00,0.00,0.00),('1','275','1','109',217,'1','1',39687.60,40361.57,0.00,0.00,673.97,501433.68,0.00,0.00,0.00),('1','275','1','109',218,'2','1',32695.89,33156.09,0.00,0.00,460.20,326742.00,0.00,0.00,0.00),('1','275','1','110',219,'1','1',40361.57,40478.15,0.00,0.00,116.58,86735.52,0.00,0.00,0.00),('1','275','1','110',220,'2','1',33156.09,33414.36,0.00,0.00,258.27,183371.70,0.00,0.00,0.00),('1','275','1','111',221,'1','1',40478.15,40478.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','111',222,'2','1',33414.36,33414.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','112',223,'1','1',40478.15,40801.97,0.00,0.00,323.82,240922.08,0.00,0.00,0.00),('1','275','1','112',224,'2','1',33414.36,33714.36,0.00,0.00,300.00,213000.00,0.00,0.00,0.00),('1','275','1','113',225,'1','1',40801.97,41575.93,0.00,0.00,773.96,575826.24,0.00,0.00,0.00),('1','275','1','113',226,'2','1',33714.36,34094.21,0.00,0.00,379.85,269693.50,0.00,0.00,0.00),('1','275','1','114',227,'1','1',41575.93,42449.39,0.00,0.00,873.46,649854.24,0.00,0.00,0.00),('1','275','1','114',228,'2','1',34094.21,34746.80,0.00,0.00,652.59,463338.90,0.00,0.00,0.00),('1','275','1','115',229,'1','1',42449.39,43066.87,0.00,0.00,617.48,459405.12,0.00,0.00,0.00),('1','275','1','115',230,'2','1',34746.80,35488.71,0.00,0.00,741.91,527181.10,0.00,0.00,0.00),('1','275','1','116',231,'1','1',43066.87,43066.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','116',232,'2','1',35488.71,35488.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','117',233,'1','1',43066.87,43716.45,0.00,0.00,649.58,483287.52,0.00,0.00,0.00),('1','275','1','117',234,'2','1',35488.71,36081.05,0.00,0.00,592.34,420561.40,0.00,0.00,0.00),('1','275','1','118',235,'1','1',43716.45,44342.28,0.00,0.00,625.83,465617.52,0.00,0.00,0.00),('1','275','1','118',236,'2','1',36081.05,36651.91,0.00,0.00,570.86,399779.32,0.00,0.00,0.00),('1','275','1','119',237,'1','1',44342.28,44893.28,0.00,0.00,551.00,409944.00,0.00,0.00,0.00),('1','275','1','119',238,'2','1',36651.91,37194.26,0.00,0.00,542.35,379645.00,0.00,0.00,0.00),('1','275','1','120',239,'1','1',44893.28,45663.99,0.00,0.00,770.71,573408.24,0.00,0.00,0.00),('1','275','1','120',240,'2','1',37194.26,37341.31,0.00,0.00,147.05,109405.20,0.00,0.00,0.00),('1','275','1','121',241,'1','1',45663.99,45999.65,0.00,0.00,335.66,249731.04,0.00,0.00,0.00),('1','275','1','121',242,'2','1',37341.31,37422.91,0.00,0.00,81.60,60710.40,0.00,0.00,0.00),('1','275','1','122',243,'1','1',45999.65,45999.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','122',244,'2','1',37422.91,37422.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','123',245,'1','1',45999.65,46863.83,0.00,0.00,864.18,642949.92,0.00,0.00,0.00),('1','275','1','123',246,'2','1',37422.91,37778.19,0.00,0.00,355.28,264328.32,0.00,0.00,0.00),('1','275','1','124',247,'1','1',46863.83,47930.29,0.00,0.00,1066.46,793446.24,0.00,0.00,0.00),('1','275','1','124',248,'2','1',37778.19,38390.88,0.00,0.00,612.69,455841.36,0.00,0.00,0.00),('1','275','1','125',249,'1','1',47930.29,47930.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','125',250,'2','1',38390.88,38390.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','126',251,'1','1',47930.29,48189.12,0.00,0.00,258.83,192569.52,0.00,0.00,0.00),('1','275','1','126',252,'2','1',38390.88,38511.85,0.00,0.00,120.97,90001.68,0.00,0.00,0.00),('1','275','1','127',253,'1','1',48189.12,48653.24,0.00,0.00,464.12,345305.28,0.00,0.00,0.00),('1','275','1','127',254,'2','1',38511.85,38809.88,0.00,0.00,298.03,221734.32,0.00,0.00,0.00),('1','275','1','128',255,'1','1',48653.24,49314.71,0.00,0.00,661.47,492133.68,0.00,0.00,0.00),('1','275','1','128',256,'2','1',38809.88,38912.05,0.00,0.00,102.17,76014.48,0.00,0.00,0.00),('1','275','1','129',257,'1','1',49314.71,49960.33,0.00,0.00,645.62,480341.28,0.00,0.00,0.00),('1','275','1','129',258,'2','1',38912.05,39250.03,0.00,0.00,337.98,251457.12,0.00,0.00,0.00),('1','275','1','130',259,'1','1',49960.33,50008.29,0.00,0.00,47.96,35298.56,0.00,0.00,0.00),('1','275','1','130',260,'2','1',39250.03,39294.52,0.00,0.00,44.49,32744.64,0.00,0.00,0.00),('1','275','1','131',261,'1','1',50008.29,50008.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','131',262,'2','1',39294.52,39294.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','132',263,'1','1',50008.29,50746.79,0.00,0.00,738.50,543536.00,0.00,0.00,0.00),('1','275','1','132',264,'2','1',39294.52,39294.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','133',265,'1','1',50746.79,51598.08,0.00,0.00,851.29,626549.44,0.00,0.00,0.00),('1','275','1','133',266,'2','1',39294.52,39345.32,0.00,0.00,50.80,37388.80,0.00,0.00,0.00),('1','275','1','134',267,'1','1',51598.08,52226.17,0.00,0.00,628.09,462274.24,0.00,0.00,0.00),('1','275','1','134',268,'2','1',39345.32,39565.19,0.00,0.00,219.87,161824.32,0.00,0.00,0.00),('1','275','1','135',269,'1','1',52226.17,52943.90,0.00,0.00,717.73,528249.28,0.00,0.00,0.00),('1','275','1','135',270,'2','1',39565.19,39815.54,0.00,0.00,250.35,184257.60,0.00,0.00,0.00),('1','275','1','136',271,'1','1',52943.90,53729.88,0.00,0.00,785.98,578481.28,0.00,0.00,0.00),('1','275','1','136',272,'2','1',39815.54,40125.55,0.00,0.00,310.01,228167.36,0.00,0.00,0.00),('1','275','1','137',273,'1','1',53729.88,54441.25,0.00,0.00,711.37,523568.32,0.00,0.00,0.00),('1','275','1','137',274,'2','1',40125.55,40211.33,0.00,0.00,85.78,63134.08,0.00,0.00,0.00),('1','275','1','138',275,'1','1',54441.25,54441.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','138',276,'2','1',40211.33,40211.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','139',277,'1','1',54441.25,55053.02,0.00,0.00,611.77,450262.72,0.00,0.00,0.00),('1','275','1','139',278,'2','1',40211.33,40264.60,0.00,0.00,53.27,39206.72,0.00,0.00,0.00),('1','275','1','140',279,'1','1',55053.02,55533.22,0.00,0.00,480.20,353427.20,0.00,0.00,0.00),('1','275','1','140',280,'2','1',40264.60,40432.77,0.00,0.00,168.17,123773.12,0.00,0.00,0.00),('1','275','1','141',281,'1','1',55533.22,56351.05,0.00,0.00,817.83,601922.88,0.00,0.00,0.00),('1','275','1','141',282,'2','1',40432.77,40565.19,0.00,0.00,132.42,97461.12,0.00,0.00,0.00),('1','275','1','142',283,'1','1',56351.05,57078.24,0.00,0.00,727.19,535211.84,0.00,0.00,0.00),('1','275','1','142',284,'2','1',40565.19,40693.11,0.00,0.00,127.92,94149.12,0.00,0.00,0.00),('1','275','1','143',285,'1','1',57078.24,57681.15,0.00,0.00,602.91,443741.76,0.00,0.00,0.00),('1','275','1','143',286,'2','1',40693.11,40842.22,0.00,0.00,149.11,109744.96,0.00,0.00,0.00),('1','275','1','144',287,'1','1',57681.15,58539.21,0.00,0.00,858.06,631532.16,0.00,0.00,0.00),('1','275','1','144',288,'2','1',40842.22,40970.23,0.00,0.00,128.01,94215.36,0.00,0.00,0.00),('1','275','1','145',289,'1','1',58539.21,59140.41,0.00,0.00,601.20,442483.20,0.00,0.00,0.00),('1','275','1','145',290,'2','1',40970.23,41108.11,0.00,0.00,137.88,101479.68,0.00,0.00,0.00),('1','275','1','146',291,'1','1',59140.41,59140.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','146',292,'2','1',41108.11,41108.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','147',293,'1','1',59140.41,60022.30,0.00,0.00,881.89,649071.04,0.00,0.00,0.00),('1','275','1','147',294,'2','1',41108.11,41297.54,0.00,0.00,189.43,139420.48,0.00,0.00,0.00),('1','275','1','148',295,'1','1',60022.30,61031.49,0.00,0.00,1009.19,742763.84,0.00,0.00,0.00),('1','275','1','148',296,'2','1',41297.54,41528.56,0.00,0.00,231.02,170030.72,0.00,0.00,0.00),('1','275','1','149',297,'1','1',61031.49,61813.05,0.00,0.00,781.56,575228.16,0.00,0.00,0.00),('1','275','1','149',298,'2','1',41528.56,41684.06,0.00,0.00,155.50,114448.00,0.00,0.00,0.00),('1','275','1','150',299,'1','1',61813.05,62759.12,0.00,0.00,946.07,696307.52,0.00,0.00,0.00),('1','275','1','150',300,'2','1',41684.06,42044.26,0.00,0.00,360.20,265107.20,0.00,0.00,0.00),('1','275','1','151',301,'1','1',62759.12,63384.64,0.00,0.00,625.52,460382.72,0.00,0.00,0.00),('1','275','1','151',302,'2','1',42044.26,42193.06,0.00,0.00,148.80,109516.80,0.00,0.00,0.00),('1','275','1','152',303,'1','1',63384.64,63516.49,0.00,0.00,131.85,100733.40,0.00,0.00,0.00),('1','275','1','152',304,'2','1',42193.06,42247.12,0.00,0.00,54.06,41301.84,0.00,0.00,0.00),('1','275','1','153',305,'1','1',63516.49,64206.39,0.00,0.00,689.90,527083.60,0.00,0.00,0.00),('1','275','1','153',306,'2','1',42247.12,42518.46,0.00,0.00,271.34,207303.76,0.00,0.00,0.00),('1','275','1','154',307,'1','1',64206.39,64851.15,0.00,0.00,644.76,482280.48,0.00,0.00,0.00),('1','275','1','154',308,'2','1',42518.46,42859.44,0.00,0.00,340.98,255143.12,0.00,0.00,0.00),('1','275','1','155',309,'1','1',64851.15,65360.72,0.00,0.00,509.57,381158.36,0.00,0.00,0.00),('1','275','1','155',310,'2','1',42859.44,43300.60,0.00,0.00,441.16,329987.68,0.00,0.00,0.00),('1','275','1','156',311,'1','1',65360.72,65703.57,0.00,0.00,342.85,256451.80,0.00,0.00,0.00),('1','275','1','156',312,'2','1',43300.60,43743.41,0.00,0.00,442.81,331221.88,0.00,0.00,0.00),('1','275','1','157',313,'1','1',65703.57,65703.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','157',314,'2','1',43743.41,43743.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','158',315,'1','1',65703.57,67258.01,0.00,0.00,1554.44,1162721.12,0.00,0.00,0.00),('1','275','1','158',316,'2','1',43743.41,43983.36,0.00,0.00,239.95,179482.60,0.00,0.00,0.00),('1','275','1','159',317,'1','1',67258.01,68263.49,0.00,0.00,1005.48,752099.04,0.00,0.00,0.00),('1','275','1','159',318,'2','1',43983.36,44218.03,0.00,0.00,234.67,175533.16,0.00,0.00,0.00),('1','275','1','160',319,'1','1',68263.49,68822.98,0.00,0.00,559.49,418498.52,0.00,0.00,0.00),('1','275','1','160',320,'2','1',44218.03,44532.45,0.00,0.00,314.42,235186.16,0.00,0.00,0.00),('1','275','1','161',321,'1','1',68822.98,68822.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','161',322,'2','1',44532.45,44532.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','162',323,'1','1',68822.98,69740.00,0.00,0.00,917.02,685930.96,0.00,0.00,0.00),('1','275','1','162',324,'2','1',44532.45,44908.08,0.00,0.00,375.63,280971.24,0.00,0.00,0.00),('1','275','1','163',325,'1','1',69740.00,70463.84,0.00,0.00,723.84,550118.40,0.00,0.00,0.00),('1','275','1','163',326,'2','1',44908.08,45382.75,0.00,0.00,474.67,360749.20,0.00,0.00,0.00),('1','275','1','164',327,'1','1',70463.84,71787.33,0.00,0.00,1323.49,1005852.40,0.00,0.00,0.00),('1','275','1','164',328,'2','1',45382.75,45725.45,0.00,0.00,342.70,260452.00,0.00,0.00,0.00),('1','275','1','165',329,'1','1',71787.33,72585.33,0.00,0.00,798.00,606480.00,0.00,0.00,0.00),('1','275','1','165',330,'2','1',45725.45,46025.72,0.00,0.00,300.27,228205.20,0.00,0.00,0.00),('1','275','1','166',331,'1','1',72585.33,73911.64,0.00,0.00,1326.31,1007995.60,0.00,0.00,0.00),('1','275','1','166',332,'2','1',46025.72,46548.75,0.00,0.00,523.03,397502.80,0.00,0.00,0.00),('1','275','1','167',333,'1','1',73911.64,74985.56,0.00,0.00,1073.92,816179.20,0.00,0.00,0.00),('1','275','1','167',334,'2','1',46548.75,46877.43,0.00,0.00,328.68,249796.80,0.00,0.00,0.00),('1','275','1','168',335,'1','1',74985.56,75988.24,0.00,0.00,1002.68,762036.80,0.00,0.00,0.00),('1','275','1','168',336,'2','1',46877.43,47186.46,0.00,0.00,309.03,234862.80,0.00,0.00,0.00),('1','275','1','169',337,'1','1',75988.24,76528.13,0.00,0.00,539.89,410316.40,0.00,0.00,0.00),('1','275','1','169',338,'2','1',47186.46,47404.23,0.00,0.00,217.77,165505.20,0.00,0.00,0.00),('1','275','1','170',339,'1','1',76528.13,76528.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','170',340,'2','1',47404.23,47404.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','171',341,'1','1',76528.13,76735.65,0.00,0.00,207.52,157715.20,0.00,0.00,0.00),('1','275','1','171',342,'2','1',47404.23,47443.54,0.00,0.00,39.31,29875.60,0.00,0.00,0.00),('1','275','1','172',343,'1','1',76735.65,77176.84,0.00,0.00,441.19,352952.00,0.00,0.00,0.00),('1','275','1','172',344,'2','1',47443.54,47869.54,0.00,0.00,426.00,340800.00,0.00,0.00,0.00),('1','275','1','173',345,'1','1',77176.84,77731.37,0.00,0.00,554.53,443624.00,0.00,0.00,0.00),('1','275','1','173',346,'2','1',47869.54,48241.17,0.00,0.00,371.63,297304.00,0.00,0.00,0.00),('1','275','1','174',347,'1','1',77731.37,78369.73,0.00,0.00,638.36,510688.00,0.00,0.00,0.00),('1','275','1','174',348,'2','1',48241.17,48665.82,0.00,0.00,424.65,339720.00,0.00,0.00,0.00),('1','275','1','175',349,'1','1',78369.73,79020.40,0.00,0.00,650.67,497194.40,0.00,0.00,0.00),('1','275','1','175',350,'2','1',48665.82,48956.16,0.00,0.00,290.34,221353.60,0.00,0.00,0.00),('1','275','1','176',351,'1','1',79020.40,79557.24,0.00,0.00,536.84,407998.40,0.00,0.00,0.00),('1','275','1','176',352,'2','1',48956.16,49148.85,0.00,0.00,192.69,146444.40,0.00,0.00,0.00),('1','275','1','177',353,'1','1',79557.24,79836.01,0.00,0.00,278.77,211865.20,0.00,0.00,0.00),('1','275','1','177',354,'2','1',49148.85,49252.15,0.00,0.00,103.30,78508.00,0.00,0.00,0.00),('1','275','1','178',355,'1','1',79836.01,79836.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','178',356,'2','1',49252.15,49252.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','179',357,'1','1',79836.01,79979.96,0.00,0.00,143.95,109402.00,0.00,0.00,0.00),('1','275','1','179',358,'2','1',49252.15,49310.50,0.00,0.00,58.35,44346.00,0.00,0.00,0.00),('1','275','1','180',359,'1','1',79979.96,80727.10,0.00,0.00,747.14,567826.40,0.00,0.00,0.00),('1','275','1','180',360,'2','1',49310.50,49767.00,0.00,0.00,456.50,346940.00,0.00,0.00,0.00),('1','275','1','181',361,'1','1',80727.10,81349.59,0.00,0.00,622.49,473092.40,0.00,0.00,0.00),('1','275','1','181',362,'2','1',49767.00,50034.72,0.00,0.00,267.72,203467.20,0.00,0.00,0.00),('1','275','1','182',363,'1','1',81349.59,81989.75,0.00,0.00,640.16,486521.60,0.00,0.00,0.00),('1','275','1','182',364,'2','1',50034.72,50252.88,0.00,0.00,218.16,165801.60,0.00,0.00,0.00),('1','275','1','183',365,'1','1',81989.75,82267.60,0.00,0.00,277.85,211166.00,0.00,0.00,0.00),('1','275','1','183',366,'2','1',50252.88,50660.42,0.00,0.00,407.54,309730.40,0.00,0.00,0.00),('1','275','1','184',367,'1','1',82267.60,82267.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','184',368,'2','1',50660.42,50660.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','185',369,'1','1',82267.60,82267.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','185',370,'2','1',50660.42,50660.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','186',371,'1','1',82267.60,82911.35,0.00,0.00,643.75,489250.00,0.00,0.00,0.00),('1','275','1','186',372,'2','1',50660.42,50950.26,0.00,0.00,289.84,220278.40,0.00,0.00,0.00),('1','275','1','187',373,'1','1',82911.35,83360.93,0.00,0.00,449.58,341680.80,0.00,0.00,0.00),('1','275','1','187',374,'2','1',50950.26,51261.32,0.00,0.00,311.06,236405.60,0.00,0.00,0.00),('1','275','1','188',375,'1','1',83360.93,83950.87,0.00,0.00,589.94,448354.40,0.00,0.00,0.00),('1','275','1','188',376,'2','1',51261.32,51506.88,0.00,0.00,245.56,186625.60,0.00,0.00,0.00),('1','275','1','189',377,'1','1',83950.87,84779.71,0.00,0.00,828.84,629918.40,0.00,0.00,0.00),('1','275','1','189',378,'2','1',51506.88,51727.57,0.00,0.00,220.69,167724.40,0.00,0.00,0.00),('1','275','1','190',379,'1','1',84779.71,85365.79,0.00,0.00,586.08,445420.80,0.00,0.00,0.00),('1','275','1','190',380,'2','1',51727.57,51890.80,0.00,0.00,163.23,124054.80,0.00,0.00,0.00),('1','275','1','191',381,'1','1',85365.79,85795.80,0.00,0.00,430.01,326807.60,0.00,0.00,0.00),('1','275','1','191',382,'2','1',51890.80,52057.84,0.00,0.00,167.04,126950.40,0.00,0.00,0.00),('1','275','1','192',383,'1','1',85795.80,85795.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','192',384,'2','1',52057.84,52057.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','193',385,'1','1',85795.80,86323.74,0.00,0.00,527.94,401234.40,0.00,0.00,0.00),('1','275','1','193',386,'2','1',52057.84,52432.42,0.00,0.00,374.58,284680.80,0.00,0.00,0.00),('1','275','1','194',387,'1','1',86323.74,86904.29,0.00,0.00,580.55,441218.00,0.00,0.00,0.00),('1','275','1','194',388,'2','1',52432.42,52669.59,0.00,0.00,237.17,180249.20,0.00,0.00,0.00),('1','275','1','195',389,'1','1',86904.29,87618.73,0.00,0.00,714.44,542974.40,0.00,0.00,0.00),('1','275','1','195',390,'2','1',52669.59,52918.43,0.00,0.00,248.84,189118.40,0.00,0.00,0.00),('1','275','1','196',391,'1','1',87618.73,88404.44,0.00,0.00,785.71,597139.60,0.00,0.00,0.00),('1','275','1','196',392,'2','1',52918.43,53053.63,0.00,0.00,135.20,102752.00,0.00,0.00,0.00),('1','275','1','197',393,'1','1',88404.44,89369.41,0.00,0.00,964.97,733377.20,0.00,0.00,0.00),('1','275','1','197',394,'2','1',53053.63,53186.08,0.00,0.00,132.45,100662.00,0.00,0.00,0.00),('1','275','1','198',395,'1','1',89369.41,89856.68,0.00,0.00,487.27,370325.20,0.00,0.00,0.00),('1','275','1','198',396,'2','1',53186.08,53231.34,0.00,0.00,45.26,34397.60,0.00,0.00,0.00),('1','275','1','199',397,'1','1',89856.68,89856.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','199',398,'2','1',53231.34,53231.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','200',399,'1','1',89856.68,90024.64,0.00,0.00,167.96,127649.60,0.00,0.00,0.00),('1','275','1','200',400,'2','1',53231.34,53255.34,0.00,0.00,24.00,18240.00,0.00,0.00,0.00),('1','275','1','201',401,'1','1',90024.64,90676.92,0.00,0.00,652.28,495732.80,0.00,0.00,0.00),('1','275','1','201',402,'2','1',53255.34,53417.91,0.00,0.00,162.57,123553.20,0.00,0.00,0.00),('1','275','1','202',403,'1','1',90676.92,91200.64,0.00,0.00,523.72,398027.20,0.00,0.00,0.00),('1','275','1','202',404,'2','1',53417.91,53589.97,0.00,0.00,172.06,130765.60,0.00,0.00,0.00),('1','275','1','203',405,'1','1',91200.64,91842.55,0.00,0.00,641.91,487851.60,0.00,0.00,0.00),('1','275','1','203',406,'2','1',53589.97,53904.37,0.00,0.00,314.40,238944.00,0.00,0.00,0.00),('1','275','1','204',407,'1','1',91842.55,92427.08,0.00,0.00,584.53,444242.80,0.00,0.00,0.00),('1','275','1','204',408,'2','1',53904.37,54051.25,0.00,0.00,146.88,111628.80,0.00,0.00,0.00),('1','275','1','205',409,'1','1',92427.08,93200.40,0.00,0.00,773.32,587723.20,0.00,0.00,0.00),('1','275','1','205',410,'2','1',54051.25,54158.50,0.00,0.00,107.25,81510.00,0.00,0.00,0.00),('1','275','1','206',411,'1','1',93200.40,93972.07,0.00,0.00,771.67,586469.20,0.00,0.00,0.00),('1','275','1','206',412,'2','1',54158.50,54312.26,0.00,0.00,153.76,116857.60,0.00,0.00,0.00),('1','275','1','207',413,'1','1',93972.07,94176.02,0.00,0.00,203.95,155002.00,0.00,0.00,0.00),('1','275','1','207',414,'2','1',54312.26,54316.87,0.00,0.00,4.61,3503.60,0.00,0.00,0.00),('1','275','1','208',415,'1','1',94176.02,94629.43,0.00,0.00,453.41,344591.60,0.00,0.00,0.00),('1','275','1','208',416,'2','1',54316.87,54358.64,0.00,0.00,41.77,31745.20,0.00,0.00,0.00),('1','275','1','209',417,'1','1',94629.43,95202.66,0.00,0.00,573.23,435654.80,0.00,0.00,0.00),('1','275','1','209',418,'2','1',54358.64,54646.19,0.00,0.00,287.55,218538.00,0.00,0.00,0.00),('1','275','1','210',419,'1','1',95202.66,95810.21,0.00,0.00,607.55,461738.00,0.00,0.00,0.00),('1','275','1','210',420,'2','1',54646.19,54874.53,0.00,0.00,228.34,173538.40,0.00,0.00,0.00),('1','275','1','211',421,'1','1',95810.21,96510.67,0.00,0.00,700.46,532349.60,0.00,0.00,0.00),('1','275','1','211',422,'2','1',54874.53,55074.24,0.00,0.00,199.71,151779.60,0.00,0.00,0.00),('1','275','1','212',423,'1','1',96510.67,97163.66,0.00,0.00,652.99,496272.40,0.00,0.00,0.00),('1','275','1','212',424,'2','1',55074.24,55208.21,0.00,0.00,133.97,101817.20,0.00,0.00,0.00),('1','275','1','213',425,'1','1',97163.66,97825.01,0.00,0.00,661.35,502626.00,0.00,0.00,0.00),('1','275','1','213',426,'2','1',55208.21,55309.62,0.00,0.00,101.41,77071.60,0.00,0.00,0.00),('1','275','1','214',427,'1','1',97825.01,97980.95,0.00,0.00,155.94,118514.40,0.00,0.00,0.00),('1','275','1','214',428,'2','1',55309.62,55343.78,0.00,0.00,34.16,25961.60,0.00,0.00,0.00),('1','275','1','215',429,'1','1',97980.95,98564.53,0.00,0.00,583.58,443520.80,0.00,0.00,0.00),('1','275','1','215',430,'2','1',55343.78,55641.83,0.00,0.00,298.05,226518.00,0.00,0.00,0.00),('1','275','1','216',431,'1','1',98564.53,99165.19,0.00,0.00,600.66,456501.60,0.00,0.00,0.00),('1','275','1','216',432,'2','1',55641.83,55743.34,0.00,0.00,101.51,77147.60,0.00,0.00,0.00),('1','275','1','217',433,'1','1',99165.19,99970.36,0.00,0.00,805.17,611929.20,0.00,0.00,0.00),('1','275','1','217',434,'2','1',55743.34,55867.28,0.00,0.00,123.94,94194.40,0.00,0.00,0.00),('1','275','1','218',435,'1','1',99970.36,100658.92,0.00,0.00,688.56,523305.60,0.00,0.00,0.00),('1','275','1','218',436,'2','1',55867.28,56059.21,0.00,0.00,191.93,145866.80,0.00,0.00,0.00),('1','275','1','219',437,'1','1',100658.92,101105.14,0.00,0.00,446.22,339127.20,0.00,0.00,0.00),('1','275','1','219',438,'2','1',56059.21,56378.48,0.00,0.00,319.27,242645.20,0.00,0.00,0.00),('1','275','1','220',439,'1','1',101105.14,101782.17,0.00,0.00,677.03,514542.80,0.00,0.00,0.00),('1','275','1','220',440,'2','1',56378.48,56627.75,0.00,0.00,249.27,189445.20,0.00,0.00,0.00),('1','275','1','221',441,'1','1',101782.17,101820.13,0.00,0.00,37.96,28849.60,0.00,0.00,0.00),('1','275','1','221',442,'2','1',56627.75,56654.98,0.00,0.00,27.23,20694.80,0.00,0.00,0.00),('1','275','1','222',443,'1','1',101820.13,101820.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','222',444,'2','1',56654.98,56654.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','223',445,'1','1',101820.13,102131.27,0.00,0.00,311.14,228999.04,0.00,0.00,0.00),('1','275','1','223',446,'2','1',56654.98,56845.21,0.00,0.00,190.23,140009.28,0.00,0.00,0.00),('1','275','1','224',447,'1','1',102131.27,102729.96,0.00,0.00,598.69,440635.84,0.00,0.00,0.00),('1','275','1','224',448,'2','1',56845.21,57364.01,0.00,0.00,518.80,381836.80,0.00,0.00,0.00),('1','275','1','225',449,'1','1',102729.96,103180.47,0.00,0.00,450.51,331575.36,0.00,0.00,0.00),('1','275','1','225',450,'2','1',57364.01,57699.57,0.00,0.00,335.56,246972.16,0.00,0.00,0.00),('1','275','1','226',451,'1','1',103180.47,103521.61,0.00,0.00,341.14,251079.04,0.00,0.00,0.00),('1','275','1','226',452,'2','1',57699.57,57926.18,0.00,0.00,226.61,166784.96,0.00,0.00,0.00),('1','275','1','227',453,'1','1',103521.61,103952.84,0.00,0.00,431.23,317385.28,0.00,0.00,0.00),('1','275','1','227',454,'2','1',57926.18,58287.61,0.00,0.00,361.43,266012.48,0.00,0.00,0.00),('1','275','1','228',455,'1','1',103952.84,104592.33,0.00,0.00,639.49,470664.64,0.00,0.00,0.00),('1','275','1','228',456,'2','1',58287.61,58618.08,0.00,0.00,330.47,243225.92,0.00,0.00,0.00),('1','275','1','229',457,'1','1',104592.33,105074.89,0.00,0.00,482.56,355164.16,0.00,0.00,0.00),('1','275','1','229',458,'2','1',58618.08,58771.78,0.00,0.00,153.70,113123.20,0.00,0.00,0.00),('1','275','1','230',459,'1','1',105074.89,105074.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','230',460,'2','1',58771.78,58771.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','231',461,'1','1',105074.89,105183.96,0.00,0.00,109.07,80275.52,0.00,0.00,0.00),('1','275','1','231',462,'2','1',58771.78,58875.67,0.00,0.00,103.89,76463.04,0.00,0.00,0.00),('1','275','1','232',463,'1','1',105183.96,105666.85,0.00,0.00,482.89,355407.04,0.00,0.00,0.00),('1','275','1','232',464,'2','1',58875.67,59225.89,0.00,0.00,350.22,257761.92,0.00,0.00,0.00),('1','275','1','233',465,'1','1',105666.85,106278.69,0.00,0.00,611.84,450314.24,0.00,0.00,0.00),('1','275','1','233',466,'2','1',59225.89,59806.70,0.00,0.00,580.81,427476.16,0.00,0.00,0.00),('1','275','1','234',467,'1','1',106278.69,107050.41,0.00,0.00,771.72,567985.92,0.00,0.00,0.00),('1','275','1','234',468,'2','1',59806.70,60192.67,0.00,0.00,385.97,284073.92,0.00,0.00,0.00),('1','275','1','235',469,'1','1',107050.41,107515.10,0.00,0.00,464.69,342011.84,0.00,0.00,0.00),('1','275','1','235',470,'2','1',60192.67,60424.36,0.00,0.00,231.69,170523.84,0.00,0.00,0.00),('1','275','1','236',471,'1','1',107515.10,108198.37,0.00,0.00,683.27,502886.72,0.00,0.00,0.00),('1','275','1','236',472,'2','1',60424.36,60819.03,0.00,0.00,394.67,290477.12,0.00,0.00,0.00),('1','275','1','237',473,'1','1',108198.37,108198.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','237',474,'2','1',60819.03,60819.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','238',475,'1','1',108198.37,109110.29,0.00,0.00,911.92,671173.12,0.00,0.00,0.00),('1','275','1','238',476,'2','1',60819.03,61224.06,0.00,0.00,405.03,298102.08,0.00,0.00,0.00),('1','275','1','239',477,'1','1',109110.29,110069.25,0.00,0.00,958.96,705794.56,0.00,0.00,0.00),('1','275','1','239',478,'2','1',61224.06,61549.34,0.00,0.00,325.28,239406.08,0.00,0.00,0.00),('1','275','1','240',479,'1','1',110069.25,110785.47,0.00,0.00,716.22,527137.92,0.00,0.00,0.00),('1','275','1','240',480,'2','1',61549.34,61868.03,0.00,0.00,318.69,234555.84,0.00,0.00,0.00),('1','275','1','241',481,'1','1',110785.47,111919.01,0.00,0.00,1133.54,834285.44,0.00,0.00,0.00),('1','275','1','241',482,'2','1',61868.03,62426.05,0.00,0.00,558.02,410702.72,0.00,0.00,0.00),('1','275','1','242',483,'1','1',111919.01,111919.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','242',484,'2','1',62426.05,62426.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','243',485,'1','1',111919.01,112514.48,0.00,0.00,595.47,438265.92,0.00,0.00,0.00),('1','275','1','243',486,'2','1',62426.05,62685.21,0.00,0.00,259.16,190741.76,0.00,0.00,0.00),('1','275','1','244',487,'1','1',112514.48,113046.11,0.00,0.00,531.63,391279.68,0.00,0.00,0.00),('1','275','1','244',488,'2','1',62685.21,62843.44,0.00,0.00,158.23,116457.28,0.00,0.00,0.00),('1','275','1','245',489,'1','1',113046.11,113469.32,0.00,0.00,423.21,311482.56,0.00,0.00,0.00),('1','275','1','245',490,'2','1',62843.44,63154.84,0.00,0.00,311.40,229190.40,0.00,0.00,0.00),('1','275','1','246',491,'1','1',113469.32,113921.95,0.00,0.00,452.63,333135.68,0.00,0.00,0.00),('1','275','1','246',492,'2','1',63154.84,63346.28,0.00,0.00,191.44,140899.84,0.00,0.00,0.00),('1','275','1','247',493,'1','1',113921.95,114308.34,0.00,0.00,386.39,284383.04,0.00,0.00,0.00),('1','275','1','247',494,'2','1',63346.28,63662.67,0.00,0.00,316.39,232863.04,0.00,0.00,0.00),('1','275','1','248',495,'1','1',114308.34,114748.27,0.00,0.00,439.93,323788.48,0.00,0.00,0.00),('1','275','1','248',496,'2','1',63662.67,63873.18,0.00,0.00,210.51,154935.36,0.00,0.00,0.00),('1','275','1','249',497,'1','1',114748.27,115414.39,0.00,0.00,666.12,490264.32,0.00,0.00,0.00),('1','275','1','249',498,'2','1',63873.18,64054.76,0.00,0.00,181.58,133642.88,0.00,0.00,0.00),('1','275','1','250',499,'1','1',115414.39,115414.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','250',500,'2','1',64054.76,64054.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','251',501,'1','1',115414.39,115772.74,0.00,0.00,358.35,263745.60,0.00,0.00,0.00),('1','275','1','251',502,'2','1',64054.76,64277.46,0.00,0.00,222.70,163907.20,0.00,0.00,0.00),('1','275','1','252',503,'1','1',115772.74,116305.94,0.00,0.00,533.20,392435.20,0.00,0.00,0.00),('1','275','1','252',504,'2','1',64277.46,64581.19,0.00,0.00,303.73,223545.28,0.00,0.00,0.00),('1','275','1','253',505,'1','1',116305.94,116960.14,0.00,0.00,654.20,481491.20,0.00,0.00,0.00),('1','275','1','253',506,'2','1',64581.19,64844.53,0.00,0.00,263.34,193818.24,0.00,0.00,0.00),('1','275','1','254',507,'1','1',116960.14,117444.97,0.00,0.00,484.83,356834.88,0.00,0.00,0.00),('1','275','1','254',508,'2','1',64844.53,65163.16,0.00,0.00,318.63,234511.68,0.00,0.00,0.00),('1','275','1','255',509,'1','1',117444.97,118127.79,0.00,0.00,682.82,502555.52,0.00,0.00,0.00),('1','275','1','255',510,'2','1',65163.16,65450.47,0.00,0.00,287.31,211460.16,0.00,0.00,0.00),('1','275','1','256',511,'1','1',118127.79,118808.53,0.00,0.00,680.74,501024.64,0.00,0.00,0.00),('1','275','1','256',512,'2','1',65450.47,65631.20,0.00,0.00,180.73,133017.28,0.00,0.00,0.00),('1','275','1','257',513,'1','1',118808.53,119059.46,0.00,0.00,250.93,184684.48,0.00,0.00,0.00),('1','275','1','257',514,'2','1',65631.20,65705.38,0.00,0.00,74.18,54596.48,0.00,0.00,0.00),('1','275','1','258',515,'1','1',119059.46,119059.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','258',516,'2','1',65705.38,65705.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','259',517,'1','1',119059.46,119306.61,0.00,0.00,247.15,181902.40,0.00,0.00,0.00),('1','275','1','259',518,'2','1',65705.38,65814.12,0.00,0.00,108.74,80032.64,0.00,0.00,0.00),('1','275','1','260',519,'1','1',119306.61,119936.36,0.00,0.00,629.75,463496.00,0.00,0.00,0.00),('1','275','1','260',520,'2','1',65814.12,66233.54,0.00,0.00,419.42,308693.12,0.00,0.00,0.00),('1','275','1','261',521,'1','1',119936.36,120680.19,0.00,0.00,743.83,547458.88,0.00,0.00,0.00),('1','275','1','261',522,'2','1',66233.54,66598.47,0.00,0.00,364.93,268588.48,0.00,0.00,0.00),('1','275','1','262',523,'1','1',120680.19,121413.86,0.00,0.00,733.67,539981.12,0.00,0.00,0.00),('1','275','1','262',524,'2','1',66598.47,66618.92,0.00,0.00,20.45,15051.20,0.00,0.00,0.00),('1','275','1','263',525,'1','1',121413.86,122050.56,0.00,0.00,636.70,468611.20,0.00,0.00,0.00),('1','275','1','263',526,'2','1',66618.92,66748.30,0.00,0.00,129.38,95223.68,0.00,0.00,0.00),('1','275','1','264',527,'1','1',122050.56,122713.61,0.00,0.00,663.05,488004.80,0.00,0.00,0.00),('1','275','1','264',528,'2','1',66748.30,66859.13,0.00,0.00,110.83,81570.88,0.00,0.00,0.00),('1','275','1','265',529,'1','1',122713.61,122993.31,0.00,0.00,279.70,205859.20,0.00,0.00,0.00),('1','275','1','265',530,'2','1',66859.13,66901.38,0.00,0.00,42.25,31096.00,0.00,0.00,0.00),('1','275','1','266',531,'1','1',122993.31,122993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','266',532,'2','1',66901.38,66901.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','267',533,'1','1',122993.31,123235.30,0.00,0.00,241.99,178104.64,0.00,0.00,0.00),('1','275','1','267',534,'2','1',66901.38,66949.76,0.00,0.00,48.38,35607.68,0.00,0.00,0.00),('1','275','1','268',535,'1','1',123235.30,124236.78,0.00,0.00,1001.48,737089.28,0.00,0.00,0.00),('1','275','1','268',536,'2','1',66949.76,67162.48,0.00,0.00,212.72,156561.92,0.00,0.00,0.00),('1','275','1','269',537,'1','1',124236.78,124849.27,0.00,0.00,612.49,450792.64,0.00,0.00,0.00),('1','275','1','269',538,'2','1',67162.48,67438.63,0.00,0.00,276.15,203246.40,0.00,0.00,0.00),('1','275','1','270',539,'1','1',124849.27,125615.97,0.00,0.00,766.70,564291.20,0.00,0.00,0.00),('1','275','1','270',540,'2','1',67438.63,67512.44,0.00,0.00,73.81,54324.16,0.00,0.00,0.00),('1','275','1','271',541,'1','1',125615.97,126470.64,0.00,0.00,854.67,629037.12,0.00,0.00,0.00),('1','275','1','271',542,'2','1',67512.44,67703.02,0.00,0.00,190.58,140266.88,0.00,0.00,0.00),('1','275','1','272',543,'1','1',126470.64,127205.55,0.00,0.00,734.91,540893.76,0.00,0.00,0.00),('1','275','1','272',544,'2','1',67703.02,67819.44,0.00,0.00,116.42,85685.12,0.00,0.00,0.00),('1','275','1','273',545,'1','1',127205.55,127389.77,0.00,0.00,184.22,135585.92,0.00,0.00,0.00),('1','275','1','273',546,'2','1',67819.44,67911.73,0.00,0.00,92.29,67925.44,0.00,0.00,0.00),('1','275','1','274',547,'1','1',127389.77,127389.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','274',548,'2','1',67911.73,67911.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','275',549,'1','1',127389.77,127741.68,0.00,0.00,351.91,259005.76,0.00,0.00,0.00),('1','275','1','275',550,'2','1',67911.73,68035.50,0.00,0.00,123.77,91094.72,0.00,0.00,0.00),('1','275','1','276',551,'1','1',127741.68,128398.27,0.00,0.00,656.59,483250.24,0.00,0.00,0.00),('1','275','1','276',552,'2','1',68035.50,68385.95,0.00,0.00,350.45,257931.20,0.00,0.00,0.00),('1','275','1','277',553,'1','1',128398.27,129333.09,0.00,0.00,934.82,688027.52,0.00,0.00,0.00),('1','275','1','277',554,'2','1',68385.95,68768.24,0.00,0.00,382.29,281365.44,0.00,0.00,0.00),('1','275','1','278',555,'1','1',129333.09,130161.38,0.00,0.00,828.29,609621.44,0.00,0.00,0.00),('1','275','1','278',556,'2','1',68768.24,69144.90,0.00,0.00,376.66,277221.76,0.00,0.00,0.00),('1','275','1','279',557,'1','1',130161.38,130881.23,0.00,0.00,719.85,529809.60,0.00,0.00,0.00),('1','275','1','279',558,'2','1',69144.90,69263.15,0.00,0.00,118.25,87032.00,0.00,0.00,0.00),('1','275','1','280',559,'1','1',130881.23,131249.80,0.00,0.00,368.57,271267.52,0.00,0.00,0.00),('1','275','1','280',560,'2','1',69263.15,69269.94,0.00,0.00,6.79,4997.44,0.00,0.00,0.00),('1','275','1','281',561,'1','1',131249.80,131249.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','281',562,'2','1',69269.94,69269.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','282',563,'1','1',131249.80,131492.28,0.00,0.00,242.48,178465.28,0.00,0.00,0.00),('1','275','1','282',564,'2','1',69269.94,69418.44,0.00,0.00,148.50,109296.00,0.00,0.00,0.00),('1','275','1','283',565,'1','1',131492.28,132253.13,0.00,0.00,760.85,559985.60,0.00,0.00,0.00),('1','275','1','283',566,'2','1',69418.44,69497.26,0.00,0.00,78.82,58011.52,0.00,0.00,0.00),('1','275','1','284',567,'1','1',132253.13,133012.66,0.00,0.00,759.53,559014.08,0.00,0.00,0.00),('1','275','1','284',568,'2','1',69497.26,69595.78,0.00,0.00,98.52,72510.72,0.00,0.00,0.00),('1','275','1','285',569,'1','1',133012.66,133718.21,0.00,0.00,705.55,519284.80,0.00,0.00,0.00),('1','275','1','285',570,'2','1',69595.78,69650.04,0.00,0.00,54.26,39935.36,0.00,0.00,0.00),('1','275','1','286',571,'1','1',133718.21,134795.85,0.00,0.00,1077.64,793143.04,0.00,0.00,0.00),('1','275','1','286',572,'2','1',69650.04,69698.81,0.00,0.00,48.77,35894.72,0.00,0.00,0.00),('1','275','1','287',573,'1','1',134795.85,135612.17,0.00,0.00,816.32,600811.52,0.00,0.00,0.00),('1','275','1','287',574,'2','1',69698.81,69858.33,0.00,0.00,159.52,117406.72,0.00,0.00,0.00),('1','275','1','288',575,'1','1',135612.17,135910.11,0.00,0.00,297.94,219283.84,0.00,0.00,0.00),('1','275','1','288',576,'2','1',69858.33,69929.63,0.00,0.00,71.30,52476.80,0.00,0.00,0.00),('1','275','1','289',577,'1','1',135910.11,136418.16,0.00,0.00,508.05,373924.80,0.00,0.00,0.00),('1','275','1','289',578,'2','1',69929.63,70069.24,0.00,0.00,139.61,102752.96,0.00,0.00,0.00),('1','275','1','290',579,'1','1',136418.16,137231.85,0.00,0.00,813.69,598875.84,0.00,0.00,0.00),('1','275','1','290',580,'2','1',70069.24,70188.84,0.00,0.00,119.60,88025.60,0.00,0.00,0.00),('1','275','1','291',581,'1','1',137231.85,138085.83,0.00,0.00,853.98,628529.28,0.00,0.00,0.00),('1','275','1','291',582,'2','1',70188.84,70462.30,0.00,0.00,273.46,201266.56,0.00,0.00,0.00),('1','275','1','292',583,'1','1',138085.83,139039.75,0.00,0.00,953.92,702085.12,0.00,0.00,0.00),('1','275','1','292',584,'2','1',70462.30,70626.71,0.00,0.00,164.41,121005.76,0.00,0.00,0.00),('1','275','1','293',585,'1','1',139039.75,139901.11,0.00,0.00,861.36,633960.96,0.00,0.00,0.00),('1','275','1','293',586,'2','1',70626.71,70879.73,0.00,0.00,253.02,186222.72,0.00,0.00,0.00),('1','275','1','294',587,'1','1',139901.11,139932.93,0.00,0.00,31.82,23419.52,0.00,0.00,0.00),('1','275','1','294',588,'2','1',70879.73,70895.36,0.00,0.00,15.63,11503.68,0.00,0.00,0.00),('1','275','1','295',589,'1','1',139932.93,139932.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','295',590,'2','1',70895.36,70895.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','296',591,'1','1',139932.93,140855.97,0.00,0.00,923.04,679357.44,0.00,0.00,0.00),('1','275','1','296',592,'2','1',70895.36,71130.12,0.00,0.00,234.76,172783.36,0.00,0.00,0.00),('1','275','1','297',593,'1','1',140855.97,141969.87,0.00,0.00,1113.90,819830.40,0.00,0.00,0.00),('1','275','1','297',594,'2','1',71130.12,71391.64,0.00,0.00,261.52,192478.72,0.00,0.00,0.00),('1','275','1','298',595,'1','1',141969.87,142900.89,0.00,0.00,931.02,685230.72,0.00,0.00,0.00),('1','275','1','298',596,'2','1',71391.64,71537.38,0.00,0.00,145.74,107264.64,0.00,0.00,0.00),('1','275','1','299',597,'1','1',142900.89,143153.11,0.00,0.00,252.22,185633.92,0.00,0.00,0.00),('1','275','1','299',598,'2','1',71537.38,71657.71,0.00,0.00,120.33,88562.88,0.00,0.00,0.00),('1','275','1','300',599,'1','1',143153.11,143153.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','300',600,'2','1',71657.71,71657.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','301',601,'1','1',143153.11,143290.42,0.00,0.00,137.31,101060.16,0.00,0.00,0.00),('1','275','1','301',602,'2','1',71657.71,71681.76,0.00,0.00,24.05,17700.80,0.00,0.00,0.00),('1','275','1','302',603,'1','1',143290.42,143968.69,0.00,0.00,678.27,499206.72,0.00,0.00,0.00),('1','275','1','302',604,'2','1',71681.76,71848.79,0.00,0.00,167.03,122934.08,0.00,0.00,0.00),('1','275','1','303',605,'1','1',143968.69,144594.80,0.00,0.00,626.11,460816.96,0.00,0.00,0.00),('1','275','1','303',606,'2','1',71848.79,72137.96,0.00,0.00,289.17,212829.12,0.00,0.00,0.00),('1','275','1','304',607,'1','1',144594.80,145074.55,0.00,0.00,479.75,353096.00,0.00,0.00,0.00),('1','275','1','304',608,'2','1',72137.96,72542.52,0.00,0.00,404.56,297756.16,0.00,0.00,0.00),('1','275','1','305',609,'1','1',145074.55,145955.42,0.00,0.00,880.87,648320.32,0.00,0.00,0.00),('1','275','1','305',610,'2','1',72542.52,72873.77,0.00,0.00,331.25,243800.00,0.00,0.00,0.00),('1','275','1','306',611,'1','1',145955.42,146692.43,0.00,0.00,737.01,542439.36,0.00,0.00,0.00),('1','275','1','306',612,'2','1',72873.77,73153.82,0.00,0.00,280.05,206116.80,0.00,0.00,0.00),('1','275','1','307',613,'1','1',146692.43,146989.88,0.00,0.00,297.45,218923.20,0.00,0.00,0.00),('1','275','1','307',614,'2','1',73153.82,73250.94,0.00,0.00,97.12,71480.32,0.00,0.00,0.00),('1','275','1','308',615,'1','1',146989.88,147202.49,0.00,0.00,212.61,156480.96,0.00,0.00,0.00),('1','275','1','308',616,'2','1',73250.94,73570.03,0.00,0.00,319.09,234850.24,0.00,0.00,0.00),('1','275','1','309',617,'1','1',147202.49,148031.86,0.00,0.00,829.37,610416.32,0.00,0.00,0.00),('1','275','1','309',618,'2','1',73570.03,73892.85,0.00,0.00,322.82,237595.52,0.00,0.00,0.00),('1','275','1','310',619,'1','1',148031.86,148707.78,0.00,0.00,675.92,497477.12,0.00,0.00,0.00),('1','275','1','310',620,'2','1',73892.85,74104.51,0.00,0.00,211.66,155781.76,0.00,0.00,0.00),('1','275','1','311',621,'1','1',148707.78,148850.53,0.00,0.00,142.75,105064.00,0.00,0.00,0.00),('1','275','1','311',622,'2','1',74104.51,74869.63,0.00,0.00,765.12,563128.32,0.00,0.00,0.00),('1','275','1','312',623,'1','1',148850.53,149138.32,0.00,0.00,287.79,211813.44,0.00,0.00,0.00),('1','275','1','312',624,'2','1',74869.63,75651.63,0.00,0.00,782.00,575552.00,0.00,0.00,0.00),('1','275','1','313',625,'1','1',149138.32,149492.80,0.00,0.00,354.48,260897.28,0.00,0.00,0.00),('1','275','1','313',626,'2','1',75651.63,75710.74,0.00,0.00,59.11,43504.96,0.00,0.00,0.00),('1','275','1','314',627,'1','1',149492.80,149492.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','314',628,'2','1',75710.74,75710.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','315',629,'1','1',149492.80,150114.83,0.00,0.00,622.03,457814.08,0.00,0.00,0.00),('1','275','1','315',630,'2','1',75710.74,75830.76,0.00,0.00,120.02,88334.72,0.00,0.00,0.00),('1','275','1','316',631,'1','1',150114.83,151200.36,0.00,0.00,1085.53,798950.08,0.00,0.00,0.00),('1','275','1','316',632,'2','1',75830.76,76078.92,0.00,0.00,248.16,182645.76,0.00,0.00,0.00),('1','275','1','317',633,'1','1',151200.36,152091.75,0.00,0.00,891.39,656063.04,0.00,0.00,0.00),('1','275','1','317',634,'2','1',76078.92,76293.01,0.00,0.00,214.09,157570.24,0.00,0.00,0.00),('1','275','1','318',635,'1','1',152091.75,152341.66,0.00,0.00,249.91,183933.76,0.00,0.00,0.00),('1','275','1','318',636,'2','1',76293.01,76684.24,0.00,0.00,391.23,287945.28,0.00,0.00,0.00),('1','275','1','319',637,'1','1',152341.66,152897.32,0.00,0.00,555.66,408965.76,0.00,0.00,0.00),('1','275','1','319',638,'2','1',76684.24,77207.42,0.00,0.00,523.18,385060.48,0.00,0.00,0.00),('1','275','1','320',639,'1','1',152897.32,152897.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','320',640,'2','1',77207.42,77207.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','321',641,'1','1',152897.32,153098.44,0.00,0.00,201.12,148024.32,0.00,0.00,0.00),('1','275','1','321',642,'2','1',77207.42,77207.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','322',643,'1','1',153098.44,154317.70,0.00,0.00,1219.26,897375.36,0.00,0.00,0.00),('1','275','1','322',644,'2','1',77207.42,77700.27,0.00,0.00,492.85,362737.60,0.00,0.00,0.00),('1','275','1','323',645,'1','1',154317.70,154974.94,0.00,0.00,657.24,483728.64,0.00,0.00,0.00),('1','275','1','323',646,'2','1',77700.27,78518.24,0.00,0.00,817.97,602025.92,0.00,0.00,0.00),('1','275','1','324',647,'1','1',154974.94,155983.43,0.00,0.00,1008.49,742248.64,0.00,0.00,0.00),('1','275','1','324',648,'2','1',78518.24,79007.71,0.00,0.00,489.47,360249.92,0.00,0.00,0.00),('1','275','1','325',649,'1','1',155983.43,156096.30,0.00,0.00,112.87,83072.32,0.00,0.00,0.00),('1','275','1','325',650,'2','1',79007.71,79108.44,0.00,0.00,100.73,74137.28,0.00,0.00,0.00),('1','275','1','326',651,'1','1',156096.30,156631.19,0.00,0.00,534.89,393679.04,0.00,0.00,0.00),('1','275','1','326',652,'2','1',79108.44,79353.78,0.00,0.00,245.34,180570.24,0.00,0.00,0.00),('1','275','1','327',653,'1','1',156631.19,157379.92,0.00,0.00,748.73,551065.28,0.00,0.00,0.00),('1','275','1','327',654,'2','1',79353.78,79693.29,0.00,0.00,339.51,249879.36,0.00,0.00,0.00),('1','275','1','328',655,'1','1',157379.92,158246.49,0.00,0.00,866.57,637795.52,0.00,0.00,0.00),('1','275','1','328',656,'2','1',79693.29,79960.80,0.00,0.00,267.51,196887.36,0.00,0.00,0.00),('1','275','1','329',657,'1','1',158246.49,158809.28,0.00,0.00,562.79,414213.44,0.00,0.00,0.00),('1','275','1','329',658,'2','1',79960.80,80249.84,0.00,0.00,289.04,212733.44,0.00,0.00,0.00),('1','275','1','330',659,'1','1',158809.28,159490.52,0.00,0.00,681.24,501392.64,0.00,0.00,0.00),('1','275','1','330',660,'2','1',80249.84,80436.67,0.00,0.00,186.83,137506.88,0.00,0.00,0.00),('1','275','1','331',661,'1','1',159490.52,159490.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','331',662,'2','1',80436.67,80436.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','332',663,'1','1',159490.52,159611.02,0.00,0.00,120.50,88688.00,0.00,0.00,0.00),('1','275','1','332',664,'2','1',80436.67,80502.52,0.00,0.00,65.85,48465.60,0.00,0.00,0.00),('1','275','1','333',665,'1','1',159611.02,160370.69,0.00,0.00,759.67,559117.12,0.00,0.00,0.00),('1','275','1','333',666,'2','1',80502.52,80929.69,0.00,0.00,427.17,314397.12,0.00,0.00,0.00),('1','275','1','334',667,'1','1',160370.69,161261.63,0.00,0.00,890.94,655731.84,0.00,0.00,0.00),('1','275','1','334',668,'2','1',80929.69,81234.98,0.00,0.00,305.29,224693.44,0.00,0.00,0.00),('1','275','1','335',669,'1','1',161261.63,161778.15,0.00,0.00,516.52,380158.72,0.00,0.00,0.00),('1','275','1','335',670,'2','1',81234.98,81456.05,0.00,0.00,221.07,162707.52,0.00,0.00,0.00),('1','275','1','336',671,'1','1',161778.15,162588.97,0.00,0.00,810.82,596763.52,0.00,0.00,0.00),('1','275','1','336',672,'2','1',81456.05,81616.87,0.00,0.00,160.82,118363.52,0.00,0.00,0.00),('1','275','1','337',673,'1','1',162588.97,163097.27,0.00,0.00,508.30,374108.80,0.00,0.00,0.00),('1','275','1','337',674,'2','1',81616.87,81660.76,0.00,0.00,43.89,32303.04,0.00,0.00,0.00),('1','275','1','338',675,'1','1',163097.27,163097.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','338',676,'2','1',81660.76,81660.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','339',677,'1','1',163097.27,163283.99,0.00,0.00,186.72,130704.00,0.00,0.00,0.00),('1','275','1','339',678,'2','1',81660.76,81660.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','275','1','340',679,'1','1',163283.99,163956.50,0.00,0.00,672.51,470757.00,0.00,0.00,0.00),('1','275','1','340',680,'2','1',81660.76,81942.53,0.00,0.00,281.77,197239.00,0.00,0.00,0.00),('1','275','1','341',681,'1','1',163956.50,164862.20,0.00,0.00,905.70,633990.00,0.00,0.00,0.00),('1','275','1','341',682,'2','1',81942.53,82019.89,0.00,0.00,77.36,54152.00,0.00,0.00,0.00),('1','275','1','342',683,'1','1',164862.20,165720.14,0.00,0.00,857.94,600558.00,0.00,0.00,0.00),('1','275','1','342',684,'2','1',82019.89,82530.95,0.00,0.00,511.06,357742.00,0.00,0.00,0.00),('1','275','1','343',685,'1','1',165720.14,166585.07,0.00,0.00,864.93,605451.00,0.00,0.00,0.00),('1','275','1','343',686,'2','1',82530.95,82811.52,0.00,0.00,280.57,196399.00,0.00,0.00,0.00),('1','275','1','344',687,'1','1',166585.07,166960.79,0.00,0.00,375.72,263004.00,0.00,0.00,0.00),('1','275','1','344',688,'2','1',82811.52,82897.24,0.00,0.00,85.72,60004.00,0.00,0.00,0.00),('1','275','1','345',689,'1','1',166960.79,167254.83,0.00,0.00,294.04,205828.00,0.00,0.00,0.00),('1','275','1','345',690,'2','1',82897.24,83053.38,0.00,0.00,156.14,109298.00,0.00,0.00,0.00),('1','275','1','346',691,'1','1',167254.83,167925.86,0.00,0.00,671.03,469721.00,0.00,0.00,0.00),('1','275','1','346',692,'2','1',83053.38,83496.14,0.00,0.00,442.76,309932.00,0.00,0.00,0.00),('1','275','1','347',693,'1','1',167925.86,168635.41,0.00,0.00,709.55,496685.00,0.00,0.00,0.00),('1','275','1','347',694,'2','1',83496.14,83937.80,0.00,0.00,441.66,309162.00,0.00,0.00,0.00),('1','275','1','348',695,'1','1',168635.41,169465.09,0.00,0.00,829.68,580776.00,0.00,0.00,0.00),('1','275','1','348',696,'2','1',83937.80,84210.75,0.00,0.00,272.95,191065.00,0.00,0.00,0.00),('1','275','1','349',697,'1','1',169465.09,170100.07,0.00,0.00,634.98,444486.00,0.00,0.00,0.00),('1','275','1','349',698,'2','1',84210.75,84432.38,0.00,0.00,221.63,155141.00,0.00,0.00,0.00),('1','275','1','350',699,'1','1',170100.07,170205.15,0.00,0.00,105.08,73556.00,0.00,0.00,0.00),('1','275','1','350',700,'2','1',84432.38,84482.88,0.00,0.00,50.50,35350.00,0.00,0.00,0.00),('1','275','1','351',701,'1','1',170205.15,171087.96,0.00,0.00,882.81,617967.00,0.00,0.00,0.00),('1','275','1','351',702,'2','1',84482.88,85076.27,0.00,0.00,593.39,415373.00,0.00,0.00,0.00),('1','275','1','352',703,'1','1',171087.96,171739.87,0.00,0.00,651.91,456337.00,0.00,0.00,0.00),('1','275','1','352',704,'2','1',85076.27,85362.47,0.00,0.00,286.20,200340.00,0.00,0.00,0.00),('1','275','1','353',705,'1','1',171739.87,172534.32,0.00,0.00,794.45,556115.00,0.00,0.00,0.00),('1','275','1','353',706,'2','1',85362.47,85518.34,0.00,0.00,155.87,109109.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=354 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','275','1','1',682.00,744.00,0.00,205.70,140287.40,153040.80,12753.40,1),('1','275','2','1',682.00,744.00,0.00,95.63,65219.66,71148.72,5929.06,2),('1','275','3','1',682.00,744.00,0.00,200.99,137075.18,149536.56,12461.38,3),('1','275','4','1',682.00,744.00,0.00,120.72,82331.04,89815.68,7484.64,4),('1','275','5','1',682.00,744.00,0.00,121.12,82603.84,90113.28,7509.44,5),('1','275','6','1',682.00,744.00,0.00,167.40,114166.80,124545.60,10378.80,6),('1','275','7','1',682.00,744.00,0.00,338.51,230863.82,251851.44,20987.62,7),('1','275','8','1',682.00,744.00,0.00,231.96,158196.72,172578.24,14381.52,8),('1','275','9','1',682.00,744.00,0.00,250.11,170575.02,186081.84,15506.82,9),('1','275','10','1',682.00,744.00,0.00,51.66,35232.12,38435.04,3202.92,10),('1','275','11','1',682.00,744.00,0.00,0.00,0.00,0.00,0.00,11),('1','275','12','1',682.00,744.00,0.00,1560.90,1064533.80,1161309.60,96775.80,12),('1','275','13','1',682.00,744.00,0.00,2027.10,1382482.20,1508162.40,125680.20,13),('1','275','14','1',682.00,744.00,0.00,659.40,449710.80,490593.60,40882.80,14),('1','275','15','1',682.00,744.00,0.00,474.72,323759.04,353191.68,29432.64,15),('1','275','16','1',682.00,744.00,0.00,0.00,0.00,0.00,0.00,16),('1','275','17','1',682.00,744.00,0.00,186.89,127458.98,139046.16,11587.18,17),('1','275','18','1',682.00,744.00,0.00,1054.89,719434.98,784838.16,65403.18,18),('1','275','19','1',682.00,744.00,0.00,1414.46,964661.72,1052358.24,87696.52,19),('1','275','20','1',682.00,744.00,0.00,883.82,602765.24,657562.08,54796.84,20),('1','275','21','1',682.00,744.00,0.00,1443.47,984446.54,1073941.68,89495.14,21),('1','275','22','1',682.00,744.00,0.00,345.27,235474.14,256880.88,21406.74,22),('1','275','23','1',682.00,744.00,0.00,0.00,0.00,0.00,0.00,23),('1','275','24','1',682.00,744.00,0.00,182.67,124580.94,135906.48,11325.54,24),('1','275','25','1',682.00,744.00,0.00,815.88,556430.16,607014.72,50584.56,25),('1','275','26','1',682.00,744.00,0.00,625.61,426666.02,465453.84,38787.82,26),('1','275','27','1',682.00,744.00,0.00,1270.49,866474.18,945244.56,78770.38,27),('1','275','28','1',682.00,744.00,0.00,992.35,676782.70,738308.40,61525.70,28),('1','275','29','1',682.00,744.00,0.00,762.59,520086.38,567366.96,47280.58,29),('1','275','30','1',682.00,744.00,0.00,612.99,418059.18,456064.56,38005.38,30),('1','275','31','1',682.00,744.00,0.00,0.00,0.00,0.00,0.00,31),('1','275','32','1',682.00,744.00,0.00,678.30,462600.60,504655.20,42054.60,32),('1','275','33','1',682.00,744.00,0.00,628.38,428555.16,467514.72,38959.56,33),('1','275','34','1',682.00,744.00,0.00,400.49,273134.18,297964.56,24830.38,34),('1','275','35','1',682.00,744.00,0.00,820.74,559744.68,610630.56,50885.88,35),('1','275','36','1',682.00,744.00,0.00,566.99,386687.18,421840.56,35153.38,36),('1','275','37','1',682.00,744.00,0.00,380.11,259235.02,282801.84,23566.82,37),('1','275','38','1',682.00,744.00,0.00,447.73,305351.86,333111.12,27759.26,38),('1','275','39','1',682.00,744.00,0.00,360.54,245888.28,268241.76,22353.48,39),('1','275','40','1',682.00,744.00,0.00,372.25,253874.50,276954.00,23079.50,40),('1','275','41','1',682.00,744.00,0.00,599.59,408920.38,446094.96,37174.58,41),('1','275','42','1',682.00,744.00,0.00,0.00,0.00,0.00,0.00,42),('1','275','43','1',682.00,744.00,0.00,235.45,160576.90,175174.80,14597.90,43),('1','275','44','1',682.00,744.00,0.00,518.06,353316.92,385436.64,32119.72,44),('1','275','45','1',682.00,744.00,0.00,232.71,158708.22,173136.24,14428.02,45),('1','275','46','1',682.00,744.00,0.00,343.45,234232.90,255526.80,21293.90,46),('1','275','47','1',682.00,744.00,0.00,433.05,295340.10,322189.20,26849.10,47),('1','275','48','1',682.00,744.00,0.00,379.95,259125.90,282682.80,23556.90,48),('1','275','49','1',682.00,744.00,0.00,469.39,320123.98,349226.16,29102.18,49),('1','275','50','1',682.00,744.00,0.00,420.90,287053.80,313149.60,26095.80,50),('1','275','51','1',682.00,744.00,0.00,950.87,648493.34,707447.28,58953.94,51),('1','275','52','1',682.00,744.00,0.00,400.45,273106.90,297934.80,24827.90,52),('1','275','53','1',682.00,744.00,0.00,583.41,397885.62,426450.64,28565.02,53),('1','275','54','1',682.00,744.00,0.00,414.35,282586.70,304597.36,22010.66,54),('1','275','55','1',682.00,744.00,0.00,0.00,0.00,0.00,0.00,55),('1','275','56','1',682.00,744.00,0.00,713.56,486647.92,515348.48,28700.56,56),('1','275','57','1',682.00,744.00,0.00,702.24,478927.68,506779.84,27852.16,57),('1','275','58','1',682.00,744.00,0.00,1803.77,1230171.14,1269994.48,39823.34,58),('1','275','59','1',682.00,744.00,0.00,690.15,470682.30,493474.70,22792.40,59),('1','275','60','1',682.00,744.00,0.00,1019.36,695203.52,719350.84,24147.32,60),('1','275','61','1',682.00,744.00,0.00,0.00,0.00,0.00,0.00,61),('1','275','62','1',682.00,744.00,0.00,1651.87,1126575.34,1165536.28,38960.94,62),('1','275','63','1',682.00,744.00,0.00,893.10,609094.20,632969.20,23875.00,63),('1','275','64','1',682.00,744.00,0.00,1392.28,949534.96,987017.04,37482.08,64),('1','275','65','1',682.00,744.00,0.00,1070.02,729753.64,753896.08,24142.44,65),('1','275','66','1',682.00,744.00,0.00,0.00,0.00,0.00,0.00,66),('1','275','67','1',665.00,744.00,0.00,322.59,214522.35,233072.48,18550.13,67),('1','275','68','1',665.00,744.00,0.00,1557.11,1035478.15,1111079.40,75601.25,68),('1','275','69','1',665.00,744.00,0.00,1569.35,1043617.75,1117565.93,73948.18,69),('1','275','70','1',665.00,744.00,0.00,1247.82,829800.30,895229.58,65429.28,70),('1','275','71','1',665.00,744.00,0.00,333.13,221531.45,238186.41,16654.96,71),('1','275','72','1',665.00,744.00,0.00,5.50,3657.50,3822.50,165.00,72),('1','275','73','1',665.00,744.00,0.00,1153.18,766864.70,836047.73,69183.03,73),('1','275','74','1',665.00,744.00,0.00,793.61,527750.65,590445.84,62695.19,74),('1','275','75','1',665.00,744.00,0.00,1208.98,803971.70,880194.72,76223.02,75),('1','275','76','1',665.00,744.00,0.00,1198.83,797221.95,861895.46,64673.51,76),('1','275','77','1',665.00,744.00,0.00,716.91,476745.15,512540.36,35795.21,77),('1','275','78','1',665.00,744.00,0.00,0.00,0.00,0.00,0.00,78),('1','275','79','1',665.00,744.00,0.00,903.66,600933.90,649016.19,48082.29,79),('1','275','80','1',665.00,744.00,0.00,1422.54,945989.10,1033877.11,87888.01,80),('1','275','81','1',665.00,744.00,0.00,841.24,559424.60,639342.40,79917.80,81),('1','275','82','1',665.00,760.00,0.00,870.05,578583.25,661238.00,82654.75,82),('1','275','83','1',665.00,760.00,0.00,790.45,525649.25,600742.00,75092.75,83),('1','275','84','1',665.00,760.00,0.00,574.00,381710.00,436240.00,54530.00,84),('1','275','85','1',665.00,760.00,0.00,0.00,0.00,0.00,0.00,85),('1','275','86','1',665.00,760.00,0.00,605.92,402936.80,460499.20,57562.40,86),('1','275','87','1',665.00,760.00,0.00,878.29,584062.85,667500.40,83437.55,87),('1','275','88','1',665.00,760.00,0.00,1003.39,667254.35,762576.40,95322.05,88),('1','275','89','1',665.00,760.00,0.00,705.16,468931.40,535921.60,66990.20,89),('1','275','90','1',665.00,744.00,0.00,1462.38,972482.70,1052265.16,79782.46,90),('1','275','91','1',665.00,744.00,0.00,0.00,0.00,0.00,0.00,91),('1','275','92','1',665.00,744.00,0.00,363.01,241401.65,262767.06,21365.41,92),('1','275','93','1',665.00,744.00,0.00,1018.61,677375.65,743094.94,65719.29,93),('1','275','94','1',665.00,744.00,0.00,1199.79,797860.35,872097.90,74237.55,94),('1','275','95','1',665.00,744.00,0.00,1360.93,905018.45,989097.08,84078.63,95),('1','275','96','1',665.00,744.00,0.00,1058.38,703822.70,775221.58,71398.88,96),('1','275','97','1',665.00,744.00,0.00,520.13,345886.45,383622.62,37736.17,97),('1','275','98','1',665.00,744.00,0.00,0.00,0.00,0.00,0.00,98),('1','275','99','1',665.00,744.00,0.00,567.49,377380.85,407694.56,30313.71,99),('1','275','100','1',665.00,744.00,0.00,995.65,662107.25,728017.00,65909.75,100),('1','275','101','1',665.00,744.00,0.00,1317.86,876376.90,957976.10,81599.20,101),('1','275','102','1',665.00,744.00,0.00,928.15,617219.75,674342.26,57122.51,102),('1','275','103','1',665.00,744.00,0.00,1499.27,997014.55,1085649.08,88634.53,103),('1','275','104','1',665.00,744.00,0.00,20.57,13679.05,15304.08,1625.03,104),('1','275','105','1',665.00,744.00,0.00,0.00,0.00,0.00,0.00,105),('1','275','106','1',665.00,744.00,0.00,1281.32,852077.80,934492.94,82415.14,106),('1','275','107','1',665.00,744.00,0.00,1525.08,1014178.20,1112645.20,98467.00,107),('1','275','108','1',665.00,744.00,0.00,892.35,593412.75,650394.42,56981.67,108),('1','275','109','1',665.00,744.00,0.00,1134.17,754223.05,828175.68,73952.63,109),('1','275','110','1',665.00,744.00,0.00,374.85,249275.25,270107.22,20831.97,110),('1','275','111','1',665.00,744.00,0.00,0.00,0.00,0.00,0.00,111),('1','275','112','1',665.00,744.00,0.00,623.82,414840.30,453922.08,39081.78,112),('1','275','113','1',665.00,744.00,0.00,1153.81,767283.65,845519.74,78236.09,113),('1','275','114','1',665.00,744.00,0.00,1526.05,1014823.25,1113193.14,98369.89,114),('1','275','115','1',665.00,744.00,0.00,1359.39,903994.35,986586.22,82591.87,115),('1','275','116','1',665.00,744.00,0.00,0.00,0.00,0.00,0.00,116),('1','275','117','1',665.00,744.00,0.00,1241.92,825876.80,903848.92,77972.12,117),('1','275','118','1',665.00,744.00,0.00,1196.69,795798.85,865396.84,69597.99,118),('1','275','119','1',665.00,744.00,0.00,1093.35,727077.75,789589.00,62511.25,119),('1','275','120','1',665.00,744.00,0.00,917.76,610310.40,682813.44,72503.04,120),('1','275','121','1',665.00,744.00,0.00,417.26,277477.90,310441.44,32963.54,121),('1','275','122','1',665.00,744.00,0.00,0.00,0.00,0.00,0.00,122),('1','275','123','1',665.00,744.00,0.00,1219.46,810940.90,907278.24,96337.34,123),('1','275','124','1',665.00,744.00,0.00,1679.15,1116634.75,1249287.60,132652.85,124),('1','275','125','1',665.00,744.00,0.00,0.00,0.00,0.00,0.00,125),('1','275','126','1',665.00,744.00,0.00,379.80,252567.00,282571.20,30004.20,126),('1','275','127','1',665.00,744.00,0.00,762.15,506829.75,567039.60,60209.85,127),('1','275','128','1',665.00,744.00,0.00,763.64,507820.60,568148.16,60327.56,128),('1','275','129','1',665.00,744.00,0.00,983.60,654094.00,731798.40,77704.40,129),('1','275','130','1',665.00,744.00,0.00,92.45,61479.25,68043.20,6563.95,130),('1','275','131','1',665.00,736.00,0.00,0.00,0.00,0.00,0.00,131),('1','275','132','1',665.00,736.00,0.00,738.50,489910.00,543536.00,53626.00,132),('1','275','133','1',660.00,736.00,0.00,902.09,595379.40,663938.24,68558.84,133),('1','275','134','1',660.00,736.00,0.00,847.96,559653.60,624098.56,64444.96,134),('1','275','135','1',660.00,736.00,0.00,968.08,638932.80,712506.88,73574.08,135),('1','275','136','1',660.00,736.00,0.00,1095.99,723353.40,806648.64,83295.24,136),('1','275','137','1',660.00,736.00,0.00,797.15,526119.00,586702.40,60583.40,137),('1','275','138','1',660.00,736.00,0.00,0.00,0.00,0.00,0.00,138),('1','275','139','1',660.00,736.00,0.00,665.04,438926.40,489469.44,50543.04,139),('1','275','140','1',660.00,736.00,0.00,648.37,427924.20,477200.32,49276.12,140),('1','275','141','1',660.00,736.00,0.00,950.25,627165.00,699384.00,72219.00,141),('1','275','142','1',660.00,736.00,0.00,855.11,564372.60,629360.96,64988.36,142),('1','275','143','1',660.00,736.00,0.00,752.02,496333.20,553486.72,57153.52,143),('1','275','144','1',660.00,736.00,0.00,986.07,650806.20,725747.52,74941.32,144),('1','275','145','1',660.00,736.00,0.00,739.08,487792.80,543962.88,56170.08,145),('1','275','146','1',660.00,736.00,0.00,0.00,0.00,0.00,0.00,146),('1','275','147','1',660.00,736.00,0.00,1071.32,717784.40,788491.52,70707.12,147),('1','275','148','1',670.00,736.00,0.00,1240.21,830940.70,912794.56,81853.86,148),('1','275','149','1',670.00,736.00,0.00,937.06,627830.20,689676.16,61845.96,149),('1','275','150','1',670.00,736.00,0.00,1306.27,875200.90,961414.72,86213.82,150),('1','275','151','1',670.00,736.00,0.00,774.32,518794.40,569899.52,51105.12,151),('1','275','152','1',670.00,764.00,0.00,185.91,124559.70,142035.24,17475.54,152),('1','275','153','1',670.00,764.00,0.00,961.24,644030.80,734387.36,90356.56,153),('1','275','154','1',670.00,764.00,0.00,985.74,660445.80,737423.60,76977.80,154),('1','275','155','1',670.00,748.00,0.00,950.73,636989.10,711146.04,74156.94,155),('1','275','156','1',670.00,748.00,0.00,785.66,526392.20,587673.68,61281.48,156),('1','275','157','1',670.00,748.00,0.00,0.00,0.00,0.00,0.00,157),('1','275','158','1',670.00,748.00,0.00,1794.39,1202241.30,1342203.72,139962.42,158),('1','275','159','1',670.00,748.00,0.00,1240.15,830900.50,927632.20,96731.70,159),('1','275','160','1',670.00,748.00,0.00,873.91,585519.70,653684.68,68164.98,160),('1','275','161','1',670.00,748.00,0.00,0.00,0.00,0.00,0.00,161),('1','275','162','1',670.00,748.00,0.00,1292.65,866075.50,966902.20,100826.70,162),('1','275','163','1',670.00,748.00,0.00,1198.51,803001.70,910867.60,107865.90,163),('1','275','164','1',670.00,760.00,0.00,1666.19,1116347.30,1266304.40,149957.10,164),('1','275','165','1',670.00,760.00,0.00,1098.27,735840.90,834685.20,98844.30,165),('1','275','166','1',670.00,760.00,0.00,1849.34,1239057.80,1405498.40,166440.60,166),('1','275','167','1',670.00,760.00,0.00,1402.60,939742.00,1065976.00,126234.00,167),('1','275','168','1',670.00,760.00,0.00,1311.71,878845.70,996899.60,118053.90,168),('1','275','169','1',670.00,760.00,0.00,757.66,507632.20,575821.60,68189.40,169),('1','275','170','1',670.00,760.00,0.00,0.00,0.00,0.00,0.00,170),('1','275','171','1',670.00,760.00,0.00,246.83,165376.10,187590.80,22214.70,171),('1','275','172','1',670.00,800.00,0.00,867.19,581017.30,693752.00,112734.70,172),('1','275','173','1',670.00,800.00,0.00,926.16,620527.20,740928.00,120400.80,173),('1','275','174','1',670.00,800.00,0.00,1063.01,712216.70,850408.00,138191.30,174),('1','275','175','1',670.00,800.00,0.00,941.01,630476.70,718548.00,88071.30,175),('1','275','176','1',670.00,760.00,0.00,729.53,488785.10,554442.80,65657.70,176),('1','275','177','1',670.00,760.00,0.00,382.07,255986.90,290373.20,34386.30,177),('1','275','178','1',670.00,760.00,0.00,0.00,0.00,0.00,0.00,178),('1','275','179','1',670.00,760.00,0.00,202.30,135541.00,153748.00,18207.00,179),('1','275','180','1',670.00,760.00,0.00,1203.64,806438.80,914766.40,108327.60,180),('1','275','181','1',670.00,760.00,0.00,890.21,596440.70,676559.60,80118.90,181),('1','275','182','1',670.00,760.00,0.00,858.32,575074.40,652323.20,77248.80,182),('1','275','183','1',670.00,760.00,0.00,685.39,459211.30,520896.40,61685.10,183),('1','275','184','1',670.00,760.00,0.00,0.00,0.00,0.00,0.00,184),('1','275','185','1',670.00,760.00,0.00,0.00,0.00,0.00,0.00,185),('1','275','186','1',670.00,760.00,0.00,933.59,625505.30,709528.40,84023.10,186),('1','275','187','1',670.00,760.00,0.00,760.64,509628.80,578086.40,68457.60,187),('1','275','188','1',670.00,760.00,0.00,835.50,559785.00,634980.00,75195.00,188),('1','275','189','1',670.00,760.00,0.00,1049.53,703185.10,797642.80,94457.70,189),('1','275','190','1',670.00,760.00,0.00,749.31,502037.70,569475.60,67437.90,190),('1','275','191','1',670.00,760.00,0.00,597.05,400023.50,453758.00,53734.50,191),('1','275','192','1',670.00,760.00,0.00,0.00,0.00,0.00,0.00,192),('1','275','193','1',685.00,760.00,0.00,902.52,618226.20,685915.20,67689.00,193),('1','275','194','1',685.00,760.00,0.00,817.72,560138.20,621467.20,61329.00,194),('1','275','195','1',685.00,760.00,0.00,963.28,659846.80,732092.80,72246.00,195),('1','275','196','1',685.00,760.00,0.00,920.91,630823.35,699891.60,69068.25,196),('1','275','197','1',685.00,760.00,0.00,1097.42,751732.70,834039.20,82306.50,197),('1','275','198','1',685.00,760.00,0.00,532.53,364783.05,404722.80,39939.75,198),('1','275','199','1',685.00,760.00,0.00,0.00,0.00,0.00,0.00,199),('1','275','200','1',685.00,760.00,0.00,191.96,131492.60,145889.60,14397.00,200),('1','275','201','1',685.00,760.00,0.00,814.85,558172.25,619286.00,61113.75,201),('1','275','202','1',685.00,760.00,0.00,695.78,476609.30,528792.80,52183.50,202),('1','275','203','1',685.00,760.00,0.00,956.31,655072.35,726795.60,71723.25,203),('1','275','204','1',685.00,760.00,0.00,731.41,501015.85,555871.60,54855.75,204),('1','275','205','1',685.00,760.00,0.00,880.57,603190.45,669233.20,66042.75,205),('1','275','206','1',685.00,760.00,0.00,925.43,633919.55,703326.80,69407.25,206),('1','275','207','1',685.00,760.00,0.00,208.56,142863.60,158505.60,15642.00,207),('1','275','208','1',685.00,760.00,0.00,495.18,339198.30,376336.80,37138.50,208),('1','275','209','1',685.00,760.00,0.00,860.78,589634.30,654192.80,64558.50,209),('1','275','210','1',685.00,760.00,0.00,835.89,572584.65,635276.40,62691.75,210),('1','275','211','1',685.00,760.00,0.00,900.17,616616.45,684129.20,67512.75,211),('1','275','212','1',685.00,760.00,0.00,786.96,539067.60,598089.60,59022.00,212),('1','275','213','1',685.00,760.00,0.00,762.76,522490.60,579697.60,57207.00,213),('1','275','214','1',685.00,760.00,0.00,190.10,129306.65,144476.00,15169.35,214),('1','275','215','1',670.00,760.00,0.00,881.63,590692.10,670038.80,79346.70,215),('1','275','216','1',670.00,760.00,0.00,702.17,470453.90,533649.20,63195.30,216),('1','275','217','1',670.00,760.00,0.00,929.11,622503.70,706123.60,83619.90,217),('1','275','218','1',670.00,760.00,0.00,880.49,589928.30,669172.40,79244.10,218),('1','275','219','1',670.00,760.00,0.00,765.49,512878.30,581772.40,68894.10,219),('1','275','220','1',670.00,760.00,0.00,926.30,620621.00,703988.00,83367.00,220),('1','275','221','1',670.00,760.00,0.00,65.19,43677.30,49544.40,5867.10,221),('1','275','222','1',670.00,760.00,0.00,0.00,0.00,0.00,0.00,222),('1','275','223','1',670.00,736.00,0.00,501.37,335917.90,369008.32,33090.42,223),('1','275','224','1',670.00,736.00,0.00,1117.49,748718.30,822472.64,73754.34,224),('1','275','225','1',670.00,736.00,0.00,786.07,526666.90,578547.52,51880.62,225),('1','275','226','1',670.00,736.00,0.00,567.75,380392.50,417864.00,37471.50,226),('1','275','227','1',670.00,736.00,0.00,792.66,531082.20,583397.76,52315.56,227),('1','275','228','1',670.00,736.00,0.00,969.96,649873.20,713890.56,64017.36,228),('1','275','229','1',670.00,736.00,0.00,636.26,426294.20,468287.36,41993.16,229),('1','275','230','1',670.00,736.00,0.00,0.00,0.00,0.00,0.00,230),('1','275','231','1',670.00,736.00,0.00,212.96,142683.20,156738.56,14055.36,231),('1','275','232','1',670.00,736.00,0.00,833.11,558183.70,613168.96,54985.26,232),('1','275','233','1',670.00,736.00,0.00,1192.65,799075.50,877790.40,78714.90,233),('1','275','234','1',670.00,736.00,0.00,1157.69,775652.30,852059.84,76407.54,234),('1','275','235','1',670.00,736.00,0.00,696.38,466574.60,512535.68,45961.08,235),('1','275','236','1',670.00,736.00,0.00,1077.94,722219.80,793363.84,71144.04,236),('1','275','237','1',670.00,736.00,0.00,0.00,0.00,0.00,0.00,237),('1','275','238','1',670.00,736.00,0.00,1316.95,882356.50,969275.20,86918.70,238),('1','275','239','1',670.00,736.00,0.00,1284.24,860440.80,945200.64,84759.84,239),('1','275','240','1',670.00,736.00,0.00,1034.91,693389.70,761693.76,68304.06,240),('1','275','241','1',670.00,736.00,0.00,1691.56,1133345.20,1244988.16,111642.96,241),('1','275','242','1',670.00,736.00,0.00,0.00,0.00,0.00,0.00,242),('1','275','243','1',670.00,736.00,0.00,854.63,572602.10,629007.68,56405.58,243),('1','275','244','1',670.00,736.00,0.00,689.86,462206.20,507736.96,45530.76,244),('1','275','245','1',670.00,736.00,0.00,734.61,492188.70,540672.96,48484.26,245),('1','275','246','1',670.00,736.00,0.00,644.07,431526.90,474035.52,42508.62,246),('1','275','247','1',670.00,736.00,0.00,702.78,470862.60,517246.08,46383.48,247),('1','275','248','1',670.00,736.00,0.00,650.44,435794.80,478723.84,42929.04,248),('1','275','249','1',670.00,736.00,0.00,847.70,567959.00,623907.20,55948.20,249),('1','275','250','1',670.00,736.00,0.00,0.00,0.00,0.00,0.00,250),('1','275','251','1',670.00,736.00,0.00,581.05,389303.50,427652.80,38349.30,251),('1','275','252','1',670.00,736.00,0.00,836.93,560743.10,615980.48,55237.38,252),('1','275','253','1',670.00,736.00,0.00,917.54,614751.80,675309.44,60557.64,253),('1','275','254','1',670.00,736.00,0.00,803.46,538318.20,591346.56,53028.36,254),('1','275','255','1',670.00,736.00,0.00,970.13,649987.10,714015.68,64028.58,255),('1','275','256','1',670.00,736.00,0.00,861.47,577184.90,634041.92,56857.02,256),('1','275','257','1',670.00,736.00,0.00,325.11,217823.70,239280.96,21457.26,257),('1','275','258','1',670.00,736.00,0.00,0.00,0.00,0.00,0.00,258),('1','275','259','1',670.00,736.00,0.00,355.89,238446.30,261935.04,23488.74,259),('1','275','260','1',670.00,736.00,0.00,1049.17,702943.90,772189.12,69245.22,260),('1','275','261','1',670.00,736.00,0.00,1108.76,742869.20,816047.36,73178.16,261),('1','275','262','1',670.00,736.00,0.00,754.12,505260.40,555032.32,49771.92,262),('1','275','263','1',670.00,736.00,0.00,766.08,513273.60,563834.88,50561.28,263),('1','275','264','1',670.00,736.00,0.00,773.88,518499.60,569575.68,51076.08,264),('1','275','265','1',670.00,736.00,0.00,321.95,215706.50,236955.20,21248.70,265),('1','275','266','1',670.00,736.00,0.00,0.00,0.00,0.00,0.00,266),('1','275','267','1',670.00,736.00,0.00,290.37,194547.90,213712.32,19164.42,267),('1','275','268','1',670.00,736.00,0.00,1214.20,813514.00,893651.20,80137.20,268),('1','275','269','1',670.00,736.00,0.00,888.64,595388.80,654039.04,58650.24,269),('1','275','270','1',670.00,736.00,0.00,840.51,563141.70,618615.36,55473.66,270),('1','275','271','1',670.00,736.00,0.00,1045.25,700317.50,769304.00,68986.50,271),('1','275','272','1',670.00,736.00,0.00,851.33,570391.10,626578.88,56187.78,272),('1','275','273','1',670.00,736.00,0.00,276.51,185261.70,203511.36,18249.66,273),('1','275','274','1',670.00,736.00,0.00,0.00,0.00,0.00,0.00,274),('1','275','275','1',670.00,736.00,0.00,475.68,318705.60,350100.48,31394.88,275),('1','275','276','1',670.00,736.00,0.00,1007.04,674716.80,741181.44,66464.64,276),('1','275','277','1',670.00,736.00,0.00,1317.11,882463.70,969392.96,86929.26,277),('1','275','278','1',670.00,736.00,0.00,1204.95,807316.50,886843.20,79526.70,278),('1','275','279','1',670.00,736.00,0.00,838.10,561527.00,616841.60,55314.60,279),('1','275','280','1',670.00,736.00,0.00,375.36,251491.20,276264.96,24773.76,280),('1','275','281','1',670.00,736.00,0.00,0.00,0.00,0.00,0.00,281),('1','275','282','1',640.00,736.00,0.00,390.98,250227.20,287761.28,37534.08,282),('1','275','283','1',640.00,736.00,0.00,839.67,537388.80,617997.12,80608.32,283),('1','275','284','1',640.00,736.00,0.00,858.05,549152.00,631524.80,82372.80,284),('1','275','285','1',640.00,736.00,0.00,759.81,486278.40,559220.16,72941.76,285),('1','275','286','1',640.00,736.00,0.00,1126.41,720902.40,829037.76,108135.36,286),('1','275','287','1',640.00,736.00,0.00,975.84,624537.60,718218.24,93680.64,287),('1','275','288','1',640.00,736.00,0.00,369.24,236313.60,271760.64,35447.04,288),('1','275','289','1',640.00,736.00,0.00,647.66,414502.40,476677.76,62175.36,289),('1','275','290','1',640.00,736.00,0.00,933.29,597305.60,686901.44,89595.84,290),('1','275','291','1',640.00,736.00,0.00,1127.44,721561.60,829795.84,108234.24,291),('1','275','292','1',640.00,736.00,0.00,1118.33,715731.20,823090.88,107359.68,292),('1','275','293','1',640.00,736.00,0.00,1114.38,713203.20,820183.68,106980.48,293),('1','275','294','1',640.00,736.00,0.00,47.45,30368.00,34923.20,4555.20,294),('1','275','295','1',640.00,736.00,0.00,0.00,0.00,0.00,0.00,295),('1','275','296','1',640.00,736.00,0.00,1157.80,740992.00,852140.80,111148.80,296),('1','275','297','1',640.00,736.00,0.00,1375.42,880268.80,1012309.12,132040.32,297),('1','275','298','1',640.00,736.00,0.00,1076.76,689126.40,792495.36,103368.96,298),('1','275','299','1',640.00,736.00,0.00,372.55,238432.00,274196.80,35764.80,299),('1','275','300','1',640.00,736.00,0.00,0.00,0.00,0.00,0.00,300),('1','275','301','1',640.00,736.00,0.00,161.36,103270.40,118760.96,15490.56,301),('1','275','302','1',640.00,736.00,0.00,845.30,540992.00,622140.80,81148.80,302),('1','275','303','1',640.00,736.00,0.00,915.28,585779.20,673646.08,87866.88,303),('1','275','304','1',640.00,736.00,0.00,884.31,565958.40,650852.16,84893.76,304),('1','275','305','1',640.00,736.00,0.00,1212.12,775756.80,892120.32,116363.52,305),('1','275','306','1',640.00,736.00,0.00,1017.06,650918.40,748556.16,97637.76,306),('1','275','307','1',640.00,736.00,0.00,394.57,252524.80,290403.52,37878.72,307),('1','275','308','1',640.00,736.00,0.00,531.70,340288.00,391331.20,51043.20,308),('1','275','309','1',640.00,736.00,0.00,1152.19,737401.60,848011.84,110610.24,309),('1','275','310','1',640.00,736.00,0.00,887.58,568051.20,653258.88,85207.68,310),('1','275','311','1',640.00,736.00,0.00,907.87,581036.80,668192.32,87155.52,311),('1','275','312','1',640.00,736.00,0.00,1069.79,684665.60,787365.44,102699.84,312),('1','275','313','1',640.00,736.00,0.00,413.59,264697.60,304402.24,39704.64,313),('1','275','314','1',640.00,736.00,0.00,0.00,0.00,0.00,0.00,314),('1','275','315','1',640.00,736.00,0.00,742.05,474912.00,546148.80,71236.80,315),('1','275','316','1',640.00,736.00,0.00,1333.69,853561.60,981595.84,128034.24,316),('1','275','317','1',640.00,736.00,0.00,1105.48,707507.20,813633.28,106126.08,317),('1','275','318','1',640.00,736.00,0.00,641.14,410329.60,471879.04,61549.44,318),('1','275','319','1',640.00,736.00,0.00,1078.84,690457.60,794026.24,103568.64,319),('1','275','320','1',640.00,736.00,0.00,0.00,0.00,0.00,0.00,320),('1','275','321','1',640.00,736.00,0.00,201.12,128716.80,148024.32,19307.52,321),('1','275','322','1',640.00,736.00,0.00,1712.11,1095750.40,1260112.96,164362.56,322),('1','275','323','1',640.00,736.00,0.00,1475.21,944134.40,1085754.56,141620.16,323),('1','275','324','1',640.00,736.00,0.00,1497.96,958694.40,1102498.56,143804.16,324),('1','275','325','1',640.00,736.00,0.00,213.60,136704.00,157209.60,20505.60,325),('1','275','326','1',640.00,736.00,0.00,780.23,499347.20,574249.28,74902.08,326),('1','275','327','1',640.00,736.00,0.00,1088.24,696473.60,800944.64,104471.04,327),('1','275','328','1',640.00,736.00,0.00,1134.08,725811.20,834682.88,108871.68,328),('1','275','329','1',640.00,736.00,0.00,851.83,545171.20,626946.88,81775.68,329),('1','275','330','1',640.00,736.00,0.00,868.07,555564.80,638899.52,83334.72,330),('1','275','331','1',640.00,736.00,0.00,0.00,0.00,0.00,0.00,331),('1','275','332','1',640.00,736.00,0.00,186.35,119264.00,137153.60,17889.60,332),('1','275','333','1',640.00,736.00,0.00,1186.84,759577.60,873514.24,113936.64,333),('1','275','334','1',640.00,736.00,0.00,1196.23,765587.20,880425.28,114838.08,334),('1','275','335','1',640.00,736.00,0.00,737.59,472057.60,542866.24,70808.64,335),('1','275','336','1',640.00,736.00,0.00,971.64,621849.60,715127.04,93277.44,336),('1','275','337','1',640.00,736.00,0.00,552.19,353401.60,406411.84,53010.24,337),('1','275','338','1',640.00,736.00,0.00,0.00,0.00,0.00,0.00,338),('1','275','339','1',634.00,700.00,0.00,186.72,118380.48,130704.00,12323.52,339),('1','275','340','1',634.00,700.00,0.00,954.28,605013.52,667996.00,62982.48,340),('1','275','341','1',634.00,700.00,0.00,983.06,623260.04,688142.00,64881.96,341),('1','275','342','1',634.00,700.00,0.00,1369.00,867946.00,958300.00,90354.00,342),('1','275','343','1',634.00,700.00,0.00,1145.50,726247.00,801850.00,75603.00,343),('1','275','344','1',634.00,700.00,0.00,461.44,292552.96,323008.00,30455.04,344),('1','275','345','1',634.00,700.00,0.00,450.18,285414.12,315126.00,29711.88,345),('1','275','346','1',634.00,700.00,0.00,1113.79,706142.86,779653.00,73510.14,346),('1','275','347','1',634.00,700.00,0.00,1151.21,729867.14,805847.00,75979.86,347),('1','275','348','1',634.00,700.00,0.00,1102.63,699067.42,771841.00,72773.58,348),('1','275','349','1',634.00,700.00,0.00,856.61,543090.74,599627.00,56536.26,349),('1','275','350','1',634.00,700.00,0.00,155.58,98637.72,108906.00,10268.28,350),('1','275','351','1',634.00,700.00,0.00,1476.20,935910.80,1033340.00,97429.20,351),('1','275','352','1',634.00,700.00,0.00,938.11,594761.74,656677.00,61915.26,352),('1','275','353','1',634.00,700.00,0.00,950.32,602502.88,665224.00,62721.12,353);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',1,'275','LPG PRODUCT TANK','Tanks Containing LPG Product.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','275','1',1,1,'1','LPG TANK ',7000.00,0.00,NULL,'TANK CONTAINING LPG PRODUCT','479','2022-05-29 12:25:31','2022-05-29 12:25:31','479',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','275',1,1523.37,'2023-03-20 20:05:28');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=23695 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'1','275',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,1384460.00,2030.00,0.00,0.00,'2022-06-03 17:27:52','',''),(2,'1','275',NULL,1,'Reception corrector for bridging 1',0.00,0.00,0.00,2030.00,0.00,'2022-06-03 17:29:20','',''),(3,'1','275','1',1,'Received from bridging 1',0.00,0.00,2030.00,0.00,0.00,'2022-06-03 17:29:20','',''),(4,'1','275','1',1,'Retail Sale Id 1',153040.80,0.00,0.00,205.70,12753.40,'2022-06-03 19:23:55','',''),(5,'1','275','1',1,'Retail Sale Id 2',9300.00,0.00,0.00,12.50,775.00,'2022-06-04 17:24:54','',''),(6,'1','275','1',1,'Retail Sale Id 3',9300.00,0.00,0.00,12.50,775.00,'2022-06-04 17:29:26','',''),(7,'1','275','1',1,'Retail Sale Id 6',7001.04,0.00,0.00,9.41,583.42,'2022-06-04 17:32:17','',''),(8,'1','275','1',1,'Retail Sale Id 7',4464.00,0.00,0.00,6.00,372.00,'2022-06-04 17:42:09','',''),(9,'1','275','1',1,'Retail Sale Id 8',41083.68,0.00,0.00,55.22,3423.64,'2022-06-04 19:35:45','',''),(10,'1','275','1',1,'Retail Sale Id 9',3720.00,0.00,0.00,5.00,310.00,'2022-06-05 09:08:47','',''),(11,'1','275','1',1,'Retail Sale Id 9',9300.00,0.00,0.00,12.50,775.00,'2022-06-05 09:08:47','',''),(12,'1','275','1',1,'Retail Sale Id 10',3720.00,0.00,0.00,5.00,310.00,'2022-06-05 09:29:15','',''),(13,'1','275','1',1,'Retail Sale Id 11',1488.00,0.00,0.00,2.00,124.00,'2022-06-05 09:46:27','',''),(14,'1','275','1',1,'Retail Sale Id 12',131308.56,0.00,0.00,176.49,10942.38,'2022-06-05 19:26:23','',''),(15,'1','275','1',1,'Retail Sale Id 13',6703.44,0.00,0.00,9.01,558.62,'2022-06-06 13:42:44','',''),(16,'1','275','1',1,'Retail Sale Id 14',4464.00,0.00,0.00,6.00,372.00,'2022-06-06 13:51:46','',''),(17,'1','275','1',1,'Retail Sale Id 15',9300.00,0.00,0.00,12.50,775.00,'2022-06-06 13:52:37','',''),(18,'1','275','1',1,'Retail Sale Id 16',4999.68,0.00,0.00,6.72,416.64,'2022-06-06 13:53:52','',''),(19,'1','275','1',1,'Retail Sale Id 17',1502.88,0.00,0.00,2.02,125.24,'2022-06-06 13:54:28','',''),(20,'1','275','1',1,'Retail Sale Id 19',2298.96,0.00,0.00,3.09,191.58,'2022-06-06 15:10:05','',''),(21,'1','275','1',1,'Retail Sale Id 20',60546.72,0.00,0.00,81.38,5045.56,'2022-06-06 19:50:17','',''),(22,'1','275','1',1,'Retail Sale Id 22',9300.00,0.00,0.00,12.50,775.00,'2022-06-07 09:37:35','',''),(23,'1','275','1',1,'Retail Sale Id 23',9002.40,0.00,0.00,12.10,750.20,'2022-06-07 09:48:26','',''),(24,'1','275','1',1,'Retail Sale Id 24',9300.00,0.00,0.00,12.50,775.00,'2022-06-07 14:05:30','',''),(25,'1','275','1',1,'Retail Sale Id 25',14999.04,0.00,0.00,20.16,1249.92,'2022-06-07 14:28:33','',''),(26,'1','275','1',1,'Retail Sale Id 26',9300.00,0.00,0.00,12.50,775.00,'2022-06-07 14:51:56','',''),(27,'1','275','1',1,'Retail Sale Id 27',38211.84,0.00,0.00,51.36,3184.32,'2022-06-07 19:38:00','',''),(28,'1','275','1',1,'Retail Sale Id 28',9300.00,0.00,0.00,12.50,775.00,'2022-06-08 07:45:48','',''),(29,'1','275','1',1,'Retail Sale Id 29',37200.00,0.00,0.00,50.00,3100.00,'2022-06-08 10:07:06','',''),(30,'1','275','1',1,'Retail Sale Id 31',9300.00,0.00,0.00,12.50,775.00,'2022-06-08 15:06:12','',''),(31,'1','275','1',1,'Retail Sale Id 34',7998.00,0.00,0.00,10.75,666.50,'2022-06-08 15:59:34','',''),(32,'1','275','1',1,'Retail Sale Id 35',3749.76,0.00,0.00,5.04,312.48,'2022-06-08 16:31:41','',''),(33,'1','275','1',1,'Retail Sale Id 36',1502.88,0.00,0.00,2.02,125.24,'2022-06-08 17:28:58','',''),(34,'1','275','1',1,'Retail Sale Id 37',55494.96,0.00,0.00,74.59,4624.58,'2022-06-08 19:29:06','',''),(35,'1','275','1',1,'Retail Sale Id 38',37200.00,0.00,0.00,50.00,3100.00,'2022-06-09 13:41:23','',''),(36,'1','275','1',1,'Retail Sale Id 39',18600.00,0.00,0.00,25.00,1550.00,'2022-06-09 13:41:56','',''),(37,'1','275','1',1,'Retail Sale Id 41',9300.00,0.00,0.00,12.50,775.00,'2022-06-09 13:43:01','',''),(38,'1','275','1',1,'Retail Sale Id 42',2998.32,0.00,0.00,4.03,249.86,'2022-06-09 13:44:10','',''),(39,'1','275','1',1,'Retail Sale Id 43',7998.00,0.00,0.00,10.75,666.50,'2022-06-09 13:45:14','',''),(40,'1','275','1',1,'Retail Sale Id 44',9300.00,0.00,0.00,12.50,775.00,'2022-06-09 15:24:09','',''),(41,'1','275','1',1,'Retail Sale Id 45',20460.00,0.00,0.00,27.50,1705.00,'2022-06-09 18:17:48','',''),(42,'1','275','1',1,'Retail Sale Id 46',145995.12,0.00,0.00,196.23,12166.26,'2022-06-09 20:05:01','',''),(43,'1','275','1',1,'Retail Sale Id 47',27900.00,0.00,0.00,37.50,2325.00,'2022-06-10 08:36:03','',''),(44,'1','275','1',1,'Retail Sale Id 48',996.96,0.00,0.00,1.34,83.08,'2022-06-10 08:37:18','',''),(45,'1','275','1',1,'Retail Sale Id 49',9300.00,0.00,0.00,12.50,775.00,'2022-06-10 09:25:35','',''),(46,'1','275','1',1,'Retail Sale Id 49',18600.00,0.00,0.00,25.00,1550.00,'2022-06-10 09:25:35','',''),(47,'1','275','1',1,'Retail Sale Id 50',2298.96,0.00,0.00,3.09,191.58,'2022-06-10 09:27:30','',''),(48,'1','275','1',1,'Retail Sale Id 51',9300.00,0.00,0.00,12.50,775.00,'2022-06-10 09:30:49','',''),(49,'1','275','1',1,'Retail Sale Id 52',18600.00,0.00,0.00,25.00,1550.00,'2022-06-10 09:51:50','',''),(50,'1','275','1',1,'Retail Sale Id 53',4501.20,0.00,0.00,6.05,375.10,'2022-06-10 11:37:12','',''),(51,'1','275','1',1,'Retail Sale Id 54',4501.20,0.00,0.00,6.05,375.10,'2022-06-10 11:38:03','',''),(52,'1','275','1',1,'Retail Sale Id 55',4999.68,0.00,0.00,6.72,416.64,'2022-06-10 11:39:04','',''),(53,'1','275','1',1,'Retail Sale Id 56',9300.00,0.00,0.00,12.50,775.00,'2022-06-10 12:37:10','',''),(54,'1','275','1',1,'Retail Sale Id 57',1502.88,0.00,0.00,2.02,125.24,'2022-06-10 12:42:11','',''),(55,'1','275','1',1,'Retail Sale Id 58',4501.20,0.00,0.00,6.05,375.10,'2022-06-10 12:43:26','',''),(56,'1','275','1',1,'Retail Sale Id 59',8496.48,0.00,0.00,11.42,708.04,'2022-06-10 13:02:43','',''),(57,'1','275','1',1,'Retail Sale Id 60',2298.96,0.00,0.00,3.09,191.58,'2022-06-10 15:24:50','',''),(58,'1','275','1',1,'Retail Sale Id 62',9300.00,0.00,0.00,12.50,775.00,'2022-06-10 15:42:57','',''),(59,'1','275','1',1,'Return of Retail Sale Id 62',0.00,9300.00,12.50,0.00,-775.00,'2022-06-10 15:52:16','',''),(60,'1','275','1',1,'Retail Sale Id 63',9300.00,0.00,0.00,12.50,775.00,'2022-06-10 16:29:39','',''),(61,'1','275','1',1,'Retail Sale Id 64',2298.96,0.00,0.00,3.09,191.58,'2022-06-10 18:04:41','',''),(62,'1','275','1',1,'Retail Sale Id 65',9300.00,0.00,0.00,12.50,775.00,'2022-06-10 18:19:02','',''),(63,'1','275','1',1,'Retail Sale Id 66',4501.20,0.00,0.00,6.05,375.10,'2022-06-10 18:23:45','',''),(64,'1','275','1',1,'Retail Sale Id 67',9300.00,0.00,0.00,12.50,775.00,'2022-06-10 18:49:54','',''),(65,'1','275','1',1,'Retail Sale Id 68',10780.56,0.00,0.00,14.49,898.38,'2022-06-10 19:31:28','',''),(66,'1','275','1',1,'Retail Sale Id 69',9300.00,0.00,0.00,12.50,775.00,'2022-06-11 07:52:36','',''),(67,'1','275','1',1,'Retail Sale Id 70',9300.00,0.00,0.00,12.50,775.00,'2022-06-11 08:37:16','',''),(68,'1','275','1',1,'Retail Sale Id 71',7998.00,0.00,0.00,10.75,666.50,'2022-06-11 08:38:24','',''),(69,'1','275','1',1,'Retail Sale Id 72',4002.72,0.00,0.00,5.38,333.56,'2022-06-11 09:12:18','',''),(70,'1','275','1',1,'Return of Retail Sale Id 72',0.00,4002.72,5.38,0.00,-333.56,'2022-06-11 09:13:03','',''),(71,'1','275','1',1,'Retail Sale Id 73',2998.32,0.00,0.00,4.03,249.86,'2022-06-11 09:13:40','',''),(72,'1','275','1',1,'Retail Sale Id 74',9300.00,0.00,0.00,12.50,775.00,'2022-06-11 11:32:35','',''),(73,'1','275','1',1,'Retail Sale Id 75',17000.40,0.00,0.00,22.85,1416.70,'2022-06-11 11:49:34','',''),(74,'1','275','1',1,'Retail Sale Id 76',9300.00,0.00,0.00,12.50,775.00,'2022-06-11 12:24:15','',''),(75,'1','275','1',1,'Retail Sale Id 78',3720.00,0.00,0.00,5.00,310.00,'2022-06-11 13:26:09','',''),(76,'1','275','1',1,'Retail Sale Id 79',2998.32,0.00,0.00,4.03,249.86,'2022-06-11 13:27:34','',''),(77,'1','275','1',1,'Retail Sale Id 80',9300.00,0.00,0.00,12.50,775.00,'2022-06-11 13:28:39','',''),(78,'1','275','1',1,'Retail Sale Id 81',2001.36,0.00,0.00,2.69,166.78,'2022-06-11 14:13:02','',''),(79,'1','275','1',1,'Retail Sale Id 82',4501.20,0.00,0.00,6.05,375.10,'2022-06-11 18:09:29','',''),(80,'1','275','1',1,'Retail Sale Id 83',9300.00,0.00,0.00,12.50,775.00,'2022-06-11 18:13:59','',''),(81,'1','275','1',1,'Retail Sale Id 84',4464.00,0.00,0.00,6.00,372.00,'2022-06-11 18:17:42','',''),(82,'1','275','1',1,'Retail Sale Id 85',9300.00,0.00,0.00,12.50,775.00,'2022-06-11 18:19:46','',''),(83,'1','275','1',1,'Retail Sale Id 86',9300.00,0.00,0.00,12.50,775.00,'2022-06-11 18:33:58','',''),(84,'1','275','1',1,'Retail Sale Id 87',37200.00,0.00,0.00,50.00,3100.00,'2022-06-11 18:53:27','',''),(85,'1','275','1',1,'Retail Sale Id 88',9300.00,0.00,0.00,12.50,775.00,'2022-06-11 19:06:57','',''),(86,'1','275','1',1,'Retail Sale Id 89',803.52,0.00,0.00,1.08,66.96,'2022-06-11 19:08:05','',''),(87,'1','275','1',1,'Retail Sale Id 90',9300.00,0.00,0.00,12.50,775.00,'2022-06-11 19:15:53','',''),(88,'1','275','1',1,'Retail Sale Id 91',4501.20,0.00,0.00,6.05,375.10,'2022-06-11 19:35:43','',''),(89,'1','275','1',1,'Retail Sale Id 92',4895.52,0.00,0.00,6.58,407.96,'2022-06-11 19:57:43','',''),(90,'1','275','1',1,'Retail Sale Id 93',7998.00,0.00,0.00,10.75,666.50,'2022-06-12 09:03:21','',''),(91,'1','275','1',1,'Return of Retail Sale Id 93',0.00,7998.00,10.75,0.00,-666.50,'2022-06-12 09:05:48','',''),(92,'1','275','1',1,'Retail Sale Id 95',4501.20,0.00,0.00,6.05,375.10,'2022-06-12 09:20:12','',''),(93,'1','275','1',1,'Retail Sale Id 96',1502.88,0.00,0.00,2.02,125.24,'2022-06-12 09:21:30','',''),(94,'1','275','1',1,'Retail Sale Id 97',4501.20,0.00,0.00,6.05,375.10,'2022-06-12 09:29:40','',''),(95,'1','275','1',1,'Retail Sale Id 98',27929.76,0.00,0.00,37.54,2327.48,'2022-06-12 10:41:45','',''),(96,'1','275','1',1,'Distributed to Operational lost for sales id:2',167908.40,0.00,0.00,246.20,0.00,'2022-06-13 10:46:02','',''),(97,'1','275',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3253140.00,4770.00,0.00,0.00,'2022-06-13 12:10:21','',''),(98,'1','275',NULL,1,'Reception corrector for bridging 2',0.00,0.00,0.00,4770.00,0.00,'2022-06-13 13:43:57','',''),(99,'1','275','1',1,'Received from bridging 2',0.00,0.00,4770.00,0.00,0.00,'2022-06-13 13:43:57','',''),(100,'1','275','1',1,'Retail Sale Id 99',37200.00,0.00,0.00,50.00,3100.00,'2022-06-13 14:10:52','',''),(101,'1','275','1',1,'Retail Sale Id 100',59520.00,0.00,0.00,80.00,4960.00,'2022-06-13 14:12:45','',''),(102,'1','275','1',1,'Retail Sale Id 101',3720.00,0.00,0.00,5.00,310.00,'2022-06-13 14:28:34','',''),(103,'1','275','1',1,'Retail Sale Id 102',9300.00,0.00,0.00,12.50,775.00,'2022-06-13 14:30:30','',''),(104,'1','275','1',1,'Retail Sale Id 103',37200.00,0.00,0.00,50.00,3100.00,'2022-06-13 14:32:14','',''),(105,'1','275','1',1,'Retail Sale Id 104',37200.00,0.00,0.00,50.00,3100.00,'2022-06-13 14:41:03','',''),(106,'1','275','1',1,'Retail Sale Id 105',4002.72,0.00,0.00,5.38,333.56,'2022-06-13 14:42:38','',''),(107,'1','275','1',1,'Retail Sale Id 106',3720.00,0.00,0.00,5.00,310.00,'2022-06-13 14:56:04','',''),(108,'1','275','1',1,'Retail Sale Id 107',9300.00,0.00,0.00,12.50,775.00,'2022-06-13 15:10:09','',''),(109,'1','275','1',1,'Retail Sale Id 108',9300.00,0.00,0.00,12.50,775.00,'2022-06-13 15:18:00','',''),(110,'1','275','1',1,'Retail Sale Id 109',2246.88,0.00,0.00,3.02,187.24,'2022-06-13 15:22:32','',''),(111,'1','275','1',1,'Retail Sale Id 111',9300.00,0.00,0.00,12.50,775.00,'2022-06-13 16:04:49','',''),(112,'1','275','1',1,'Retail Sale Id 112',2998.32,0.00,0.00,4.03,249.86,'2022-06-13 16:06:29','',''),(113,'1','275','1',1,'Retail Sale Id 113',9300.00,0.00,0.00,12.50,775.00,'2022-06-13 16:08:07','',''),(114,'1','275','1',1,'Retail Sale Id 113',14880.00,0.00,0.00,20.00,1240.00,'2022-06-13 16:08:07','',''),(115,'1','275','1',1,'Retail Sale Id 114',2998.32,0.00,0.00,4.03,249.86,'2022-06-13 16:09:04','',''),(116,'1','275','1',1,'Retail Sale Id 115',6696.00,0.00,0.00,9.00,558.00,'2022-06-13 16:10:58','',''),(117,'1','275','1',1,'Retail Sale Id 116',9300.00,0.00,0.00,12.50,775.00,'2022-06-13 16:13:07','',''),(118,'1','275','1',1,'Retail Sale Id 117',9300.00,0.00,0.00,12.50,775.00,'2022-06-13 16:16:08','',''),(119,'1','275','1',1,'Retail Sale Id 118',9300.00,0.00,0.00,12.50,775.00,'2022-06-13 16:25:05','',''),(120,'1','275','1',1,'Retail Sale Id 119',13503.60,0.00,0.00,18.15,1125.30,'2022-06-13 16:46:23','',''),(121,'1','275','1',1,'Retail Sale Id 120',37200.00,0.00,0.00,50.00,3100.00,'2022-06-13 16:49:16','',''),(122,'1','275','1',1,'Retail Sale Id 121',31002.48,0.00,0.00,41.67,2583.54,'2022-06-13 17:04:43','',''),(123,'1','275','1',1,'Retail Sale Id 122',2001.36,0.00,0.00,2.69,166.78,'2022-06-13 17:10:07','',''),(124,'1','275','1',1,'Retail Sale Id 123',9300.00,0.00,0.00,12.50,775.00,'2022-06-13 17:12:01','',''),(125,'1','275','1',1,'Retail Sale Id 124',9300.00,0.00,0.00,12.50,775.00,'2022-06-13 17:26:06','',''),(126,'1','275','1',1,'Retail Sale Id 125',2998.32,0.00,0.00,4.03,249.86,'2022-06-13 17:28:12','',''),(127,'1','275','1',1,'Retail Sale Id 126',2001.36,0.00,0.00,2.69,166.78,'2022-06-13 17:31:37','',''),(128,'1','275','1',1,'Retail Sale Id 127',655620.24,0.00,0.00,881.21,54635.02,'2022-06-13 19:13:22','',''),(129,'1','275','1',1,'Retail Sale Id 128',111600.00,0.00,0.00,150.00,9300.00,'2022-06-13 19:13:52','',''),(130,'1','275','1',1,'Retail Sale Id 129',111600.00,0.00,0.00,150.00,9300.00,'2022-06-14 07:45:28','',''),(131,'1','275','1',1,'Retail Sale Id 130',11160.00,0.00,0.00,15.00,930.00,'2022-06-14 09:38:29','',''),(132,'1','275','1',1,'Retail Sale Id 131',9300.00,0.00,0.00,12.50,775.00,'2022-06-14 09:41:15','',''),(133,'1','275','1',1,'Retail Sale Id 132',148800.00,0.00,0.00,200.00,12400.00,'2022-06-14 09:46:25','',''),(134,'1','275','1',1,'Retail Sale Id 133',1398.72,0.00,0.00,1.88,116.56,'2022-06-14 09:48:42','',''),(135,'1','275','1',1,'Retail Sale Id 134',9300.00,0.00,0.00,12.50,775.00,'2022-06-14 09:56:19','',''),(136,'1','275','1',1,'Retail Sale Id 135',7001.04,0.00,0.00,9.41,583.42,'2022-06-14 10:03:39','',''),(137,'1','275','1',1,'Retail Sale Id 136',3720.00,0.00,0.00,5.00,310.00,'2022-06-14 10:09:25','',''),(138,'1','275','1',1,'Retail Sale Id 137',2232.00,0.00,0.00,3.00,186.00,'2022-06-14 10:29:55','',''),(139,'1','275','1',1,'Retail Sale Id 137',9300.00,0.00,0.00,12.50,775.00,'2022-06-14 10:29:55','',''),(140,'1','275','1',1,'Retail Sale Id 137',9300.00,0.00,0.00,12.50,775.00,'2022-06-14 10:29:55','',''),(141,'1','275','1',1,'Retail Sale Id 138',8184.00,0.00,0.00,11.00,682.00,'2022-06-14 10:40:00','',''),(142,'1','275','1',1,'Retail Sale Id 138',22320.00,0.00,0.00,30.00,1860.00,'2022-06-14 10:40:00','',''),(143,'1','275','1',1,'Retail Sale Id 138',29760.00,0.00,0.00,40.00,2480.00,'2022-06-14 10:40:00','',''),(144,'1','275','1',1,'Retail Sale Id 138',111600.00,0.00,0.00,150.00,9300.00,'2022-06-14 10:40:00','',''),(145,'1','275','1',1,'Retail Sale Id 138',111600.00,0.00,0.00,150.00,9300.00,'2022-06-14 10:40:00','',''),(146,'1','275','1',1,'Retail Sale Id 138',111600.00,0.00,0.00,150.00,9300.00,'2022-06-14 10:40:00','',''),(147,'1','275','1',1,'Return of Retail Sale Id 138',0.00,8184.00,11.00,0.00,-682.00,'2022-06-14 10:40:22','',''),(148,'1','275','1',1,'Return of Retail Sale Id 138',0.00,22320.00,30.00,0.00,-1860.00,'2022-06-14 10:40:22','',''),(149,'1','275','1',1,'Return of Retail Sale Id 138',0.00,29760.00,40.00,0.00,-2480.00,'2022-06-14 10:40:22','',''),(150,'1','275','1',1,'Return of Retail Sale Id 138',0.00,111600.00,150.00,0.00,-9300.00,'2022-06-14 10:40:22','',''),(151,'1','275','1',1,'Return of Retail Sale Id 138',0.00,111600.00,150.00,0.00,-9300.00,'2022-06-14 10:40:22','',''),(152,'1','275','1',1,'Return of Retail Sale Id 138',0.00,111600.00,150.00,0.00,-9300.00,'2022-06-14 10:40:22','',''),(153,'1','275','1',1,'Retail Sale Id 139',8184.00,0.00,0.00,11.00,682.00,'2022-06-14 10:42:41','',''),(154,'1','275','1',1,'Retail Sale Id 139',22320.00,0.00,0.00,30.00,1860.00,'2022-06-14 10:42:41','',''),(155,'1','275','1',1,'Retail Sale Id 139',29760.00,0.00,0.00,40.00,2480.00,'2022-06-14 10:42:41','',''),(156,'1','275','1',1,'Retail Sale Id 139',37200.00,0.00,0.00,50.00,3100.00,'2022-06-14 10:42:41','',''),(157,'1','275','1',1,'Retail Sale Id 139',37200.00,0.00,0.00,50.00,3100.00,'2022-06-14 10:42:41','',''),(158,'1','275','1',1,'Retail Sale Id 139',37200.00,0.00,0.00,50.00,3100.00,'2022-06-14 10:42:41','',''),(159,'1','275','1',1,'Retail Sale Id 140',37200.00,0.00,0.00,50.00,3100.00,'2022-06-14 11:07:44','',''),(160,'1','275','1',1,'Retail Sale Id 141',3720.00,0.00,0.00,5.00,310.00,'2022-06-14 11:08:46','',''),(161,'1','275','1',1,'Retail Sale Id 142',9300.00,0.00,0.00,12.50,775.00,'2022-06-14 11:23:33','',''),(162,'1','275','1',1,'Retail Sale Id 143',11502.24,0.00,0.00,15.46,958.52,'2022-06-14 12:12:38','',''),(163,'1','275','1',1,'Retail Sale Id 144',148800.00,0.00,0.00,200.00,12400.00,'2022-06-14 12:15:32','',''),(164,'1','275','1',1,'Retail Sale Id 145',9300.00,0.00,0.00,12.50,775.00,'2022-06-14 12:47:59','',''),(165,'1','275','1',1,'Retail Sale Id 146',3720.00,0.00,0.00,5.00,310.00,'2022-06-14 12:52:23','',''),(166,'1','275','1',1,'Retail Sale Id 146',9300.00,0.00,0.00,12.50,775.00,'2022-06-14 12:52:23','',''),(167,'1','275','1',1,'Retail Sale Id 147',119040.00,0.00,0.00,160.00,9920.00,'2022-06-14 12:57:21','',''),(168,'1','275','1',1,'Retail Sale Id 148',18600.00,0.00,0.00,25.00,1550.00,'2022-06-14 13:05:22','',''),(169,'1','275','1',1,'Retail Sale Id 149',111600.00,0.00,0.00,150.00,9300.00,'2022-06-14 13:06:50','',''),(170,'1','275','1',1,'Retail Sale Id 150',2001.36,0.00,0.00,2.69,166.78,'2022-06-14 13:07:45','',''),(171,'1','275','1',1,'Retail Sale Id 151',12648.00,0.00,0.00,17.00,1054.00,'2022-06-14 13:10:03','',''),(172,'1','275','1',1,'Retail Sale Id 153',2298.96,0.00,0.00,3.09,191.58,'2022-06-14 13:23:00','',''),(173,'1','275','1',1,'Retail Sale Id 154',1502.88,0.00,0.00,2.02,125.24,'2022-06-14 13:25:34','',''),(174,'1','275','1',1,'Retail Sale Id 154',9300.00,0.00,0.00,12.50,775.00,'2022-06-14 13:25:34','',''),(175,'1','275','1',1,'Retail Sale Id 155',1197.84,0.00,0.00,1.61,99.82,'2022-06-14 13:32:11','',''),(176,'1','275','1',1,'Retail Sale Id 156',9300.00,0.00,0.00,12.50,775.00,'2022-06-14 14:14:20','',''),(177,'1','275','1',1,'Retail Sale Id 157',4464.00,0.00,0.00,6.00,372.00,'2022-06-14 14:17:09','',''),(178,'1','275','1',1,'Retail Sale Id 157',4464.00,0.00,0.00,6.00,372.00,'2022-06-14 14:17:09','',''),(179,'1','275','1',1,'Retail Sale Id 157',9300.00,0.00,0.00,12.50,775.00,'2022-06-14 14:17:09','',''),(180,'1','275','1',1,'Retail Sale Id 158',4501.20,0.00,0.00,6.05,375.10,'2022-06-14 14:23:45','',''),(181,'1','275','1',1,'Retail Sale Id 159',138384.00,0.00,0.00,186.00,11532.00,'2022-06-14 14:32:17','',''),(182,'1','275','1',1,'Retail Sale Id 160',33502.32,0.00,0.00,45.03,2791.86,'2022-06-14 14:48:37','',''),(183,'1','275','1',1,'Retail Sale Id 161',996.96,0.00,0.00,1.34,83.08,'2022-06-14 14:57:54','',''),(184,'1','275','1',1,'Retail Sale Id 162',1696.32,0.00,0.00,2.28,141.36,'2022-06-14 14:59:47','',''),(185,'1','275','1',1,'Retail Sale Id 163',1696.32,0.00,0.00,2.28,141.36,'2022-06-14 15:00:45','',''),(186,'1','275','1',1,'Retail Sale Id 164',39997.44,0.00,0.00,53.76,3333.12,'2022-06-14 15:30:02','',''),(187,'1','275','1',1,'Retail Sale Id 165',3720.00,0.00,0.00,5.00,310.00,'2022-06-14 15:31:21','',''),(188,'1','275','1',1,'Retail Sale Id 166',9300.00,0.00,0.00,12.50,775.00,'2022-06-14 15:32:51','',''),(189,'1','275','1',1,'Return of Retail Sale Id 164',0.00,39997.44,53.76,0.00,-3333.12,'2022-06-14 15:35:08','',''),(190,'1','275','1',1,'Retail Sale Id 167',37200.00,0.00,0.00,50.00,3100.00,'2022-06-14 15:35:45','',''),(191,'1','275','1',1,'Retail Sale Id 168',2998.32,0.00,0.00,4.03,249.86,'2022-06-14 15:49:05','',''),(192,'1','275','1',1,'Retail Sale Id 169',49848.00,0.00,0.00,67.00,4154.00,'2022-06-14 15:56:38','',''),(193,'1','275','1',1,'Retail Sale Id 170',2298.96,0.00,0.00,3.09,191.58,'2022-06-14 16:35:41','',''),(194,'1','275','1',1,'Retail Sale Id 171',4002.72,0.00,0.00,5.38,333.56,'2022-06-14 17:07:11','',''),(195,'1','275','1',1,'Retail Sale Id 172',184482.24,0.00,0.00,247.96,15373.52,'2022-06-14 19:59:40','',''),(196,'1','275','1',1,'Retail Sale Id 173',8496.48,0.00,0.00,11.42,708.04,'2022-06-15 09:17:37','',''),(197,'1','275','1',1,'Retail Sale Id 174',18600.00,0.00,0.00,25.00,1550.00,'2022-06-15 09:27:49','',''),(198,'1','275','1',1,'Retail Sale Id 175',4501.20,0.00,0.00,6.05,375.10,'2022-06-15 09:32:14','',''),(199,'1','275','1',1,'Retail Sale Id 176',9300.00,0.00,0.00,12.50,775.00,'2022-06-15 09:34:00','',''),(200,'1','275','1',1,'Retail Sale Id 177',996.96,0.00,0.00,1.34,83.08,'2022-06-15 09:37:53','',''),(201,'1','275','1',1,'Retail Sale Id 178',111600.00,0.00,0.00,150.00,9300.00,'2022-06-15 10:30:36','',''),(202,'1','275','1',1,'Retail Sale Id 179',2499.84,0.00,0.00,3.36,208.32,'2022-06-15 10:31:45','',''),(203,'1','275','1',1,'Retail Sale Id 180',7440.00,0.00,0.00,10.00,620.00,'2022-06-15 11:13:03','',''),(204,'1','275','1',1,'Retail Sale Id 181',79608.00,0.00,0.00,107.00,6634.00,'2022-06-15 11:34:18','',''),(205,'1','275','1',1,'Retail Sale Id 182',37200.00,0.00,0.00,50.00,3100.00,'2022-06-15 13:59:15','',''),(206,'1','275','1',1,'Retail Sale Id 183',2298.96,0.00,0.00,3.09,191.58,'2022-06-15 14:11:05','',''),(207,'1','275','1',1,'Retail Sale Id 184',4002.72,0.00,0.00,5.38,333.56,'2022-06-15 15:16:04','',''),(208,'1','275','1',1,'Retail Sale Id 185',9300.00,0.00,0.00,12.50,775.00,'2022-06-15 15:21:38','',''),(209,'1','275','1',1,'Retail Sale Id 186',1502.88,0.00,0.00,2.02,125.24,'2022-06-15 17:21:46','',''),(210,'1','275','1',1,'Retail Sale Id 187',193246.56,0.00,0.00,259.74,16103.88,'2022-06-15 19:16:36','',''),(211,'1','275','1',1,'Retail Sale Id 188',9300.00,0.00,0.00,12.50,775.00,'2022-06-16 07:53:03','',''),(212,'1','275','1',1,'Retail Sale Id 189',46291.68,0.00,0.00,62.22,3857.64,'2022-06-16 16:24:22','',''),(213,'1','275','1',1,'Retail Sale Id 190',84942.48,0.00,0.00,114.17,7078.54,'2022-06-16 16:26:45','',''),(214,'1','275','1',1,'Retail Sale Id 191',212657.52,0.00,0.00,285.83,17721.46,'2022-06-16 16:27:50','',''),(215,'1','275','1',1,'Distributed to Operational lost for sales id:3',32654.16,0.00,0.00,47.88,0.00,'2022-06-17 09:25:18','',''),(216,'1','275',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3641880.00,5340.00,0.00,0.00,'2022-06-17 19:42:34','',''),(217,'1','275',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,5340.00,0.00,'2022-06-17 19:43:28','',''),(218,'1','275','1',1,'Received from bridging 3',0.00,0.00,5340.00,0.00,0.00,'2022-06-17 19:43:28','',''),(219,'1','275','1',1,'Retail Sale Id 192',139046.16,0.00,0.00,186.89,11587.18,'2022-06-17 19:46:56','',''),(220,'1','275','1',1,'Retail Sale Id 193',9300.00,0.00,0.00,12.50,775.00,'2022-06-18 07:29:47','',''),(221,'1','275','1',1,'Retail Sale Id 194',9300.00,0.00,0.00,12.50,775.00,'2022-06-18 08:00:22','',''),(222,'1','275','1',1,'Retail Sale Id 195',9300.00,0.00,0.00,12.50,775.00,'2022-06-18 08:03:56','',''),(223,'1','275','1',1,'Retail Sale Id 196',119040.00,0.00,0.00,160.00,9920.00,'2022-06-18 08:18:15','',''),(224,'1','275','1',1,'Retail Sale Id 197',4999.68,0.00,0.00,6.72,416.64,'2022-06-18 08:40:59','',''),(225,'1','275','1',1,'Retail Sale Id 198',2998.32,0.00,0.00,4.03,249.86,'2022-06-18 08:44:21','',''),(226,'1','275','1',1,'Retail Sale Id 199',18600.00,0.00,0.00,25.00,1550.00,'2022-06-18 08:45:59','',''),(227,'1','275','1',1,'Retail Sale Id 200',2976.00,0.00,0.00,4.00,248.00,'2022-06-18 08:55:18','',''),(228,'1','275','1',1,'Retail Sale Id 201',2202.24,0.00,0.00,2.96,183.52,'2022-06-18 08:57:06','',''),(229,'1','275','1',1,'Retail Sale Id 202',7001.04,0.00,0.00,9.41,583.42,'2022-06-18 09:36:10','',''),(230,'1','275','1',1,'Retail Sale Id 203',9300.00,0.00,0.00,12.50,775.00,'2022-06-18 09:41:30','',''),(231,'1','275','1',1,'Retail Sale Id 204',7001.04,0.00,0.00,9.41,583.42,'2022-06-18 09:45:09','',''),(232,'1','275','1',1,'Retail Sale Id 205',2298.96,0.00,0.00,3.09,191.58,'2022-06-18 09:46:22','',''),(233,'1','275','1',1,'Retail Sale Id 206',148800.00,0.00,0.00,200.00,12400.00,'2022-06-18 10:14:13','',''),(234,'1','275','1',1,'Retail Sale Id 207',4464.00,0.00,0.00,6.00,372.00,'2022-06-18 10:16:12','',''),(235,'1','275','1',1,'Retail Sale Id 207',9300.00,0.00,0.00,12.50,775.00,'2022-06-18 10:16:12','',''),(236,'1','275','1',1,'Retail Sale Id 208',7440.00,0.00,0.00,10.00,620.00,'2022-06-18 10:18:05','',''),(237,'1','275','1',1,'Retail Sale Id 209',2298.96,0.00,0.00,3.09,191.58,'2022-06-18 10:19:56','',''),(238,'1','275','1',1,'Retail Sale Id 210',17112.00,0.00,0.00,23.00,1426.00,'2022-06-18 10:27:34','',''),(239,'1','275','1',1,'Retail Sale Id 211',4501.20,0.00,0.00,6.05,375.10,'2022-06-18 10:30:24','',''),(240,'1','275','1',1,'Retail Sale Id 212',7440.00,0.00,0.00,10.00,620.00,'2022-06-18 10:32:29','',''),(241,'1','275','1',1,'Retail Sale Id 212',9300.00,0.00,0.00,12.50,775.00,'2022-06-18 10:32:29','',''),(242,'1','275','1',1,'Retail Sale Id 214',9300.00,0.00,0.00,12.50,775.00,'2022-06-18 11:33:03','',''),(243,'1','275','1',1,'Retail Sale Id 215',111600.00,0.00,0.00,150.00,9300.00,'2022-06-18 11:44:01','',''),(244,'1','275','1',1,'Retail Sale Id 216',248964.72,0.00,0.00,334.63,20747.06,'2022-06-18 19:28:47','',''),(245,'1','275','1',1,'Retail Sale Id 217',12000.72,0.00,0.00,16.13,1000.06,'2022-06-19 07:33:25','',''),(246,'1','275','1',1,'Retail Sale Id 218',18600.00,0.00,0.00,25.00,1550.00,'2022-06-19 07:47:16','',''),(247,'1','275','1',1,'Retail Sale Id 219',44640.00,0.00,0.00,60.00,3720.00,'2022-06-19 10:24:25','',''),(248,'1','275','1',1,'Retail Sale Id 220',145824.00,0.00,0.00,196.00,12152.00,'2022-06-19 10:29:38','',''),(249,'1','275','1',1,'Retail Sale Id 221',1502.88,0.00,0.00,2.02,125.24,'2022-06-19 10:31:02','',''),(250,'1','275','1',1,'Retail Sale Id 222',9300.00,0.00,0.00,12.50,775.00,'2022-06-19 10:38:38','',''),(251,'1','275','1',1,'Retail Sale Id 223',7440.00,0.00,0.00,10.00,620.00,'2022-06-19 10:49:00','',''),(252,'1','275','1',1,'Retail Sale Id 224',4999.68,0.00,0.00,6.72,416.64,'2022-06-19 10:51:03','',''),(253,'1','275','1',1,'Retail Sale Id 225',7001.04,0.00,0.00,9.41,583.42,'2022-06-19 10:52:24','',''),(254,'1','275','1',1,'Retail Sale Id 226',996.96,0.00,0.00,1.34,83.08,'2022-06-19 10:56:04','',''),(255,'1','275','1',1,'Retail Sale Id 227',145824.00,0.00,0.00,196.00,12152.00,'2022-06-19 11:18:10','',''),(256,'1','275','1',1,'Retail Sale Id 228',4002.72,0.00,0.00,5.38,333.56,'2022-06-19 11:20:28','',''),(257,'1','275','1',1,'Retail Sale Id 229',9002.40,0.00,0.00,12.10,750.20,'2022-06-19 11:32:54','',''),(258,'1','275','1',1,'Retail Sale Id 230',3720.00,0.00,0.00,5.00,310.00,'2022-06-19 11:46:05','',''),(259,'1','275','1',1,'Retail Sale Id 231',9300.00,0.00,0.00,12.50,775.00,'2022-06-19 11:50:48','',''),(260,'1','275','1',1,'Retail Sale Id 232',744.00,0.00,0.00,1.00,62.00,'2022-06-19 11:58:36','',''),(261,'1','275','1',1,'Retail Sale Id 232',758.88,0.00,0.00,1.02,63.24,'2022-06-19 11:58:36','',''),(262,'1','275','1',1,'Retail Sale Id 233',156240.00,0.00,0.00,210.00,13020.00,'2022-06-19 12:04:51','',''),(263,'1','275','1',1,'Retail Sale Id 234',2998.32,0.00,0.00,4.03,249.86,'2022-06-19 12:10:14','',''),(264,'1','275','1',1,'Retail Sale Id 235',2001.36,0.00,0.00,2.69,166.78,'2022-06-19 12:14:03','',''),(265,'1','275','1',1,'Retail Sale Id 236',751.44,0.00,0.00,1.01,62.62,'2022-06-19 12:18:17','',''),(266,'1','275','1',1,'Retail Sale Id 237',16003.44,0.00,0.00,21.51,1333.62,'2022-06-19 12:23:00','',''),(267,'1','275','1',1,'Retail Sale Id 238',9300.00,0.00,0.00,12.50,775.00,'2022-06-19 12:59:50','',''),(268,'1','275','1',1,'Retail Sale Id 239',3720.00,0.00,0.00,5.00,310.00,'2022-06-19 13:07:53','',''),(269,'1','275','1',1,'Retail Sale Id 240',8928.00,0.00,0.00,12.00,744.00,'2022-06-19 13:22:55','',''),(270,'1','275','1',1,'Retail Sale Id 241',5952.00,0.00,0.00,8.00,496.00,'2022-06-19 13:58:13','',''),(271,'1','275','1',1,'Retail Sale Id 241',9300.00,0.00,0.00,12.50,775.00,'2022-06-19 13:58:13','',''),(272,'1','275','1',1,'Retail Sale Id 242',2001.36,0.00,0.00,2.69,166.78,'2022-06-19 13:59:38','',''),(273,'1','275','1',1,'Retail Sale Id 243',9300.00,0.00,0.00,12.50,775.00,'2022-06-19 14:14:26','',''),(274,'1','275','1',1,'Retail Sale Id 244',9300.00,0.00,0.00,12.50,775.00,'2022-06-19 15:20:46','',''),(275,'1','275','1',1,'Retail Sale Id 245',44640.00,0.00,0.00,60.00,3720.00,'2022-06-19 15:22:53','',''),(276,'1','275','1',1,'Retail Sale Id 246',12648.00,0.00,0.00,17.00,1054.00,'2022-06-19 15:27:38','',''),(277,'1','275','1',1,'Retail Sale Id 247',7001.04,0.00,0.00,9.41,583.42,'2022-06-19 15:37:05','',''),(278,'1','275','1',1,'Return of Retail Sale Id 247',0.00,7001.04,9.41,0.00,-583.42,'2022-06-19 15:38:41','',''),(279,'1','275','1',1,'Retail Sale Id 248',7499.52,0.00,0.00,10.08,624.96,'2022-06-19 15:39:59','',''),(280,'1','275','1',1,'Retail Sale Id 249',4501.20,0.00,0.00,6.05,375.10,'2022-06-19 15:54:36','',''),(281,'1','275','1',1,'Retail Sale Id 250',18600.00,0.00,0.00,25.00,1550.00,'2022-06-19 16:47:15','',''),(282,'1','275','1',1,'Retail Sale Id 251',4501.20,0.00,0.00,6.05,375.10,'2022-06-19 16:53:43','',''),(283,'1','275','1',1,'Retail Sale Id 252',9300.00,0.00,0.00,12.50,775.00,'2022-06-19 16:54:44','',''),(284,'1','275','1',1,'Retail Sale Id 253',18600.00,0.00,0.00,25.00,1550.00,'2022-06-19 17:02:41','',''),(285,'1','275','1',1,'Retail Sale Id 254',7001.04,0.00,0.00,9.41,583.42,'2022-06-19 17:15:20','',''),(286,'1','275','1',1,'Retail Sale Id 255',37200.00,0.00,0.00,50.00,3100.00,'2022-06-19 17:24:51','',''),(287,'1','275','1',1,'Retail Sale Id 256',18600.00,0.00,0.00,25.00,1550.00,'2022-06-19 17:43:41','',''),(288,'1','275','1',1,'Retail Sale Id 257',207814.08,0.00,0.00,279.32,17317.84,'2022-06-19 19:37:09','',''),(289,'1','275','1',1,'Retail Sale Id 258',2998.32,0.00,0.00,4.03,249.86,'2022-06-20 07:59:27','',''),(290,'1','275','1',1,'Retail Sale Id 259',18600.00,0.00,0.00,25.00,1550.00,'2022-06-20 08:09:30','',''),(291,'1','275','1',1,'Retail Sale Id 260',9300.00,0.00,0.00,12.50,775.00,'2022-06-20 08:30:53','',''),(292,'1','275','1',1,'Retail Sale Id 261',996.96,0.00,0.00,1.34,83.08,'2022-06-20 08:36:48','',''),(293,'1','275','1',1,'Retail Sale Id 262',9300.00,0.00,0.00,12.50,775.00,'2022-06-20 08:38:34','',''),(294,'1','275','1',1,'Retail Sale Id 265',33502.32,0.00,0.00,45.03,2791.86,'2022-06-20 09:38:44','',''),(295,'1','275','1',1,'Retail Sale Id 266',2001.36,0.00,0.00,2.69,166.78,'2022-06-20 09:42:28','',''),(296,'1','275','1',1,'Retail Sale Id 267',4501.20,0.00,0.00,6.05,375.10,'2022-06-20 09:44:40','',''),(297,'1','275','1',1,'Retail Sale Id 267',9300.00,0.00,0.00,12.50,775.00,'2022-06-20 09:44:40','',''),(298,'1','275','1',1,'Retail Sale Id 269',2499.84,0.00,0.00,3.36,208.32,'2022-06-20 09:53:23','',''),(299,'1','275','1',1,'Retail Sale Id 270',9002.40,0.00,0.00,12.10,750.20,'2022-06-20 10:12:00','',''),(300,'1','275','1',1,'Retail Sale Id 271',7298.64,0.00,0.00,9.81,608.22,'2022-06-20 10:14:38','',''),(301,'1','275','1',1,'Retail Sale Id 272',37200.00,0.00,0.00,50.00,3100.00,'2022-06-20 10:19:47','',''),(302,'1','275','1',1,'Retail Sale Id 273',9300.00,0.00,0.00,12.50,775.00,'2022-06-20 10:21:05','',''),(303,'1','275','1',1,'Retail Sale Id 274',9002.40,0.00,0.00,12.10,750.20,'2022-06-20 10:26:54','',''),(304,'1','275','1',1,'Retail Sale Id 275',4501.20,0.00,0.00,6.05,375.10,'2022-06-20 10:28:29','',''),(305,'1','275','1',1,'Retail Sale Id 276',2298.96,0.00,0.00,3.09,191.58,'2022-06-20 11:13:33','',''),(306,'1','275','1',1,'Retail Sale Id 277',9300.00,0.00,0.00,12.50,775.00,'2022-06-20 11:14:49','',''),(307,'1','275','1',1,'Retail Sale Id 278',67704.00,0.00,0.00,91.00,5642.00,'2022-06-20 11:33:08','',''),(308,'1','275','1',1,'Retail Sale Id 279',408954.48,0.00,0.00,549.67,34079.54,'2022-06-20 19:25:23','',''),(309,'1','275','1',1,'Retail Sale Id 280',9300.00,0.00,0.00,12.50,775.00,'2022-06-21 07:32:23','',''),(310,'1','275','1',1,'Retail Sale Id 281',4501.20,0.00,0.00,6.05,375.10,'2022-06-21 07:33:20','',''),(311,'1','275','1',1,'Retail Sale Id 282',9300.00,0.00,0.00,12.50,775.00,'2022-06-21 07:37:06','',''),(312,'1','275','1',1,'Retail Sale Id 283',37200.00,0.00,0.00,50.00,3100.00,'2022-06-21 07:52:31','',''),(313,'1','275','1',1,'Retail Sale Id 284',7998.00,0.00,0.00,10.75,666.50,'2022-06-21 08:01:42','',''),(314,'1','275','1',1,'Retail Sale Id 285',996.96,0.00,0.00,1.34,83.08,'2022-06-21 08:13:19','',''),(315,'1','275','1',1,'Retail Sale Id 286',4501.20,0.00,0.00,6.05,375.10,'2022-06-21 08:15:41','',''),(316,'1','275','1',1,'Retail Sale Id 287',37200.00,0.00,0.00,50.00,3100.00,'2022-06-21 08:30:17','',''),(317,'1','275','1',1,'Retail Sale Id 288',9300.00,0.00,0.00,12.50,775.00,'2022-06-21 08:31:32','',''),(318,'1','275','1',1,'Retail Sale Id 289',9999.36,0.00,0.00,13.44,833.28,'2022-06-21 09:02:49','',''),(319,'1','275','1',1,'Retail Sale Id 290',24552.00,0.00,0.00,33.00,2046.00,'2022-06-21 09:05:56','',''),(320,'1','275','1',1,'Retail Sale Id 291',2001.36,0.00,0.00,2.69,166.78,'2022-06-21 09:08:13','',''),(321,'1','275','1',1,'Retail Sale Id 292',9300.00,0.00,0.00,12.50,775.00,'2022-06-21 09:11:52','',''),(322,'1','275','1',1,'Retail Sale Id 293',2001.36,0.00,0.00,2.69,166.78,'2022-06-21 09:41:23','',''),(323,'1','275','1',1,'Retail Sale Id 293',4501.20,0.00,0.00,6.05,375.10,'2022-06-21 09:41:23','',''),(324,'1','275','1',1,'Retail Sale Id 293',9300.00,0.00,0.00,12.50,775.00,'2022-06-21 09:41:23','',''),(325,'1','275','1',1,'Retail Sale Id 294',44640.00,0.00,0.00,60.00,3720.00,'2022-06-21 09:45:26','',''),(326,'1','275','1',1,'Retail Sale Id 295',148800.00,0.00,0.00,200.00,12400.00,'2022-06-21 10:11:52','',''),(327,'1','275','1',1,'Retail Sale Id 296',28272.00,0.00,0.00,38.00,2356.00,'2022-06-21 10:18:04','',''),(328,'1','275','1',1,'Retail Sale Id 297',18600.00,0.00,0.00,25.00,1550.00,'2022-06-21 10:23:36','',''),(329,'1','275','1',1,'Retail Sale Id 298',9300.00,0.00,0.00,12.50,775.00,'2022-06-21 10:24:33','',''),(330,'1','275','1',1,'Retail Sale Id 299',23064.00,0.00,0.00,31.00,1922.00,'2022-06-21 10:30:23','',''),(331,'1','275','1',1,'Retail Sale Id 300',18600.00,0.00,0.00,25.00,1550.00,'2022-06-21 10:45:34','',''),(332,'1','275','1',1,'Retail Sale Id 301',37200.00,0.00,0.00,50.00,3100.00,'2022-06-21 10:57:57','',''),(333,'1','275','1',1,'Retail Sale Id 302',4501.20,0.00,0.00,6.05,375.10,'2022-06-21 11:06:15','',''),(334,'1','275','1',1,'Retail Sale Id 303',4501.20,0.00,0.00,6.05,375.10,'2022-06-21 11:09:39','',''),(335,'1','275','1',1,'Retail Sale Id 303',9300.00,0.00,0.00,12.50,775.00,'2022-06-21 11:09:39','',''),(336,'1','275','1',1,'Retail Sale Id 304',111600.00,0.00,0.00,150.00,9300.00,'2022-06-21 11:14:56','',''),(337,'1','275','1',1,'Retail Sale Id 305',9300.00,0.00,0.00,12.50,775.00,'2022-06-21 11:20:23','',''),(338,'1','275','1',1,'Retail Sale Id 306',996.96,0.00,0.00,1.34,83.08,'2022-06-21 11:23:45','',''),(339,'1','275','1',1,'Retail Sale Id 307',2998.32,0.00,0.00,4.03,249.86,'2022-06-21 11:47:51','',''),(340,'1','275','1',1,'Retail Sale Id 308',46500.00,0.00,0.00,62.50,3875.00,'2022-06-21 11:51:23','',''),(341,'1','275','1',1,'Retail Sale Id 309',2298.96,0.00,0.00,3.09,191.58,'2022-06-21 12:51:47','',''),(342,'1','275','1',1,'Retail Sale Id 310',5996.64,0.00,0.00,8.06,499.72,'2022-06-21 13:26:33','',''),(343,'1','275','1',1,'Retail Sale Id 311',18600.00,0.00,0.00,25.00,1550.00,'2022-06-21 13:27:39','',''),(344,'1','275','1',1,'Retail Sale Id 312',4597.92,0.00,0.00,6.18,383.16,'2022-06-21 13:32:28','',''),(345,'1','275','1',1,'Retail Sale Id 313',2998.32,0.00,0.00,4.03,249.86,'2022-06-21 13:54:03','',''),(346,'1','275','1',1,'Retail Sale Id 316',9300.00,0.00,0.00,12.50,775.00,'2022-06-21 14:23:25','',''),(347,'1','275','1',1,'Retail Sale Id 317',2001.36,0.00,0.00,2.69,166.78,'2022-06-21 14:27:48','',''),(348,'1','275','1',1,'Retail Sale Id 318',2298.96,0.00,0.00,3.09,191.58,'2022-06-21 14:38:38','',''),(349,'1','275','1',1,'Retail Sale Id 319',9300.00,0.00,0.00,12.50,775.00,'2022-06-21 14:53:30','',''),(350,'1','275','1',1,'Retail Sale Id 320',4002.72,0.00,0.00,5.38,333.56,'2022-06-21 14:56:39','',''),(351,'1','275','1',1,'Retail Sale Id 321',37200.00,0.00,0.00,50.00,3100.00,'2022-06-21 15:28:24','',''),(352,'1','275','1',1,'Retail Sale Id 322',4501.20,0.00,0.00,6.05,375.10,'2022-06-21 15:34:19','',''),(353,'1','275','1',1,'Retail Sale Id 323',7499.52,0.00,0.00,10.08,624.96,'2022-06-21 15:56:08','',''),(354,'1','275','1',1,'Retail Sale Id 324',5952.00,0.00,0.00,8.00,496.00,'2022-06-21 16:34:56','',''),(355,'1','275','1',1,'Retail Sale Id 325',9300.00,0.00,0.00,12.50,775.00,'2022-06-21 16:35:39','',''),(356,'1','275','1',1,'Retail Sale Id 326',2998.32,0.00,0.00,4.03,249.86,'2022-06-21 16:36:35','',''),(357,'1','275','1',1,'Retail Sale Id 327',9300.00,0.00,0.00,12.50,775.00,'2022-06-21 16:46:10','',''),(358,'1','275','1',1,'Retail Sale Id 328',4501.20,0.00,0.00,6.05,375.10,'2022-06-21 17:19:10','',''),(359,'1','275','1',1,'Retail Sale Id 329',18600.00,0.00,0.00,25.00,1550.00,'2022-06-21 17:20:31','',''),(360,'1','275','1',1,'Retail Sale Id 330',35712.00,0.00,0.00,48.00,2976.00,'2022-06-21 17:46:06','',''),(361,'1','275','1',1,'Retail Sale Id 331',2499.84,0.00,0.00,3.36,208.32,'2022-06-21 17:47:09','',''),(362,'1','275','1',1,'Retail Sale Id 332',9300.00,0.00,0.00,12.50,775.00,'2022-06-21 17:54:55','',''),(363,'1','275','1',1,'Retail Sale Id 333',751.44,0.00,0.00,1.01,62.62,'2022-06-21 18:06:30','',''),(364,'1','275','1',1,'Retail Sale Id 334',37572.00,0.00,0.00,50.50,3131.00,'2022-06-21 18:08:16','',''),(365,'1','275','1',1,'Retail Sale Id 335',7440.00,0.00,0.00,10.00,620.00,'2022-06-21 18:23:06','',''),(366,'1','275','1',1,'Retail Sale Id 336',2298.96,0.00,0.00,3.09,191.58,'2022-06-21 18:24:11','',''),(367,'1','275','1',1,'Retail Sale Id 337',13392.00,0.00,0.00,18.00,1116.00,'2022-06-21 18:56:18','',''),(368,'1','275','1',1,'Retail Sale Id 338',17112.00,0.00,0.00,23.00,1426.00,'2022-06-21 19:12:37','',''),(369,'1','275','1',1,'Retail Sale Id 339',86490.00,0.00,0.00,116.25,7207.50,'2022-06-21 19:37:02','',''),(370,'1','275','1',1,'Retail Sale Id 340',34000.80,0.00,0.00,45.70,2833.40,'2022-06-22 07:16:05','',''),(371,'1','275','1',1,'Retail Sale Id 341',5996.64,0.00,0.00,8.06,499.72,'2022-06-22 07:16:52','',''),(372,'1','275','1',1,'Retail Sale Id 342',44640.00,0.00,0.00,60.00,3720.00,'2022-06-22 07:17:41','',''),(373,'1','275','1',1,'Retail Sale Id 343',9300.00,0.00,0.00,12.50,775.00,'2022-06-22 07:24:21','',''),(374,'1','275','1',1,'Retail Sale Id 344',4501.20,0.00,0.00,6.05,375.10,'2022-06-22 07:42:39','',''),(375,'1','275','1',1,'Retail Sale Id 345',2001.36,0.00,0.00,2.69,166.78,'2022-06-22 07:52:06','',''),(376,'1','275','1',1,'Retail Sale Id 346',9300.00,0.00,0.00,12.50,775.00,'2022-06-22 07:57:19','',''),(377,'1','275','1',1,'Retail Sale Id 347',74400.00,0.00,0.00,100.00,6200.00,'2022-06-22 10:06:55','',''),(378,'1','275','1',1,'Retail Sale Id 348',17900.64,0.00,0.00,24.06,1491.72,'2022-06-22 10:07:36','',''),(379,'1','275','1',1,'Retail Sale Id 349',9300.00,0.00,0.00,12.50,775.00,'2022-06-22 10:08:08','',''),(380,'1','275','1',1,'Retail Sale Id 350',4999.68,0.00,0.00,6.72,416.64,'2022-06-22 10:08:51','',''),(381,'1','275','1',1,'Retail Sale Id 351',40540.56,0.00,0.00,54.49,3378.38,'2022-06-22 10:22:46','',''),(382,'1','275','1',1,'Distributed to Operational lost for sales id:4',7638.40,0.00,0.00,11.20,0.00,'2022-06-22 11:13:13','',''),(383,'1','275',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3648700.00,5350.00,0.00,0.00,'2022-06-22 13:15:11','',''),(384,'1','275',NULL,1,'Reception corrector for bridging 4',0.00,0.00,0.00,5350.00,0.00,'2022-06-22 13:16:08','',''),(385,'1','275','1',1,'Received from bridging 4',0.00,0.00,5350.00,0.00,0.00,'2022-06-22 13:16:08','',''),(386,'1','275','1',1,'Retail Sale Id 352',2998.32,0.00,0.00,4.03,249.86,'2022-06-22 13:24:19','',''),(387,'1','275','1',1,'Retail Sale Id 353',4999.68,0.00,0.00,6.72,416.64,'2022-06-22 13:26:48','',''),(388,'1','275','1',1,'Retail Sale Id 354',2001.36,0.00,0.00,2.69,166.78,'2022-06-22 13:50:09','',''),(389,'1','275','1',1,'Return of Retail Sale Id 354',0.00,2001.36,2.69,0.00,-166.78,'2022-06-22 13:50:45','',''),(390,'1','275','1',1,'Retail Sale Id 355',2001.36,0.00,0.00,2.69,166.78,'2022-06-22 13:51:43','',''),(391,'1','275','1',1,'Retail Sale Id 356',8496.48,0.00,0.00,11.42,708.04,'2022-06-22 13:57:38','',''),(392,'1','275','1',1,'Retail Sale Id 357',18600.00,0.00,0.00,25.00,1550.00,'2022-06-22 14:09:55','',''),(393,'1','275','1',1,'Retail Sale Id 358',9300.00,0.00,0.00,12.50,775.00,'2022-06-22 14:56:45','',''),(394,'1','275','1',1,'Retail Sale Id 359',4501.20,0.00,0.00,6.05,375.10,'2022-06-22 14:58:30','',''),(395,'1','275','1',1,'Retail Sale Id 360',2298.96,0.00,0.00,3.09,191.58,'2022-06-22 15:15:14','',''),(396,'1','275','1',1,'Retail Sale Id 361',2298.96,0.00,0.00,3.09,191.58,'2022-06-22 15:20:13','',''),(397,'1','275','1',1,'Retail Sale Id 361',4501.20,0.00,0.00,6.05,375.10,'2022-06-22 15:20:13','',''),(398,'1','275','1',1,'Retail Sale Id 361',4501.20,0.00,0.00,6.05,375.10,'2022-06-22 15:20:13','',''),(399,'1','275','1',1,'Retail Sale Id 362',4501.20,0.00,0.00,6.05,375.10,'2022-06-22 16:32:22','',''),(400,'1','275','1',1,'Retail Sale Id 363',2298.96,0.00,0.00,3.09,191.58,'2022-06-22 16:40:34','',''),(401,'1','275','1',1,'Retail Sale Id 364',1502.88,0.00,0.00,2.02,125.24,'2022-06-22 16:51:44','',''),(402,'1','275','1',1,'Retail Sale Id 365',9300.00,0.00,0.00,12.50,775.00,'2022-06-22 17:00:15','',''),(403,'1','275','1',1,'Retail Sale Id 366',53806.08,0.00,0.00,72.32,4483.84,'2022-06-22 19:31:48','',''),(404,'1','275','1',1,'Retail Sale Id 367',9701.76,0.00,0.00,13.04,808.48,'2022-06-23 07:40:30','',''),(405,'1','275','1',1,'Retail Sale Id 368',9300.00,0.00,0.00,12.50,775.00,'2022-06-23 08:00:57','',''),(406,'1','275','1',1,'Retail Sale Id 369',7440.00,0.00,0.00,10.00,620.00,'2022-06-23 08:27:15','',''),(407,'1','275','1',1,'Retail Sale Id 370',9300.00,0.00,0.00,12.50,775.00,'2022-06-23 08:32:25','',''),(408,'1','275','1',1,'Retail Sale Id 371',803.52,0.00,0.00,1.08,66.96,'2022-06-23 08:34:03','',''),(409,'1','275','1',1,'Retail Sale Id 372',9300.00,0.00,0.00,12.50,775.00,'2022-06-23 09:00:56','',''),(410,'1','275','1',1,'Retail Sale Id 373',2998.32,0.00,0.00,4.03,249.86,'2022-06-23 09:35:25','',''),(411,'1','275','1',1,'Retail Sale Id 374',9300.00,0.00,0.00,12.50,775.00,'2022-06-23 09:36:41','',''),(412,'1','275','1',1,'Retail Sale Id 375',1502.88,0.00,0.00,2.02,125.24,'2022-06-23 10:44:15','',''),(413,'1','275','1',1,'Retail Sale Id 376',9300.00,0.00,0.00,12.50,775.00,'2022-06-23 10:45:35','',''),(414,'1','275','1',1,'Retail Sale Id 377',2298.96,0.00,0.00,3.09,191.58,'2022-06-23 11:01:16','',''),(415,'1','275','1',1,'Retail Sale Id 378',14500.56,0.00,0.00,19.49,1208.38,'2022-06-23 11:05:37','',''),(416,'1','275','1',1,'Retail Sale Id 379',9300.00,0.00,0.00,12.50,775.00,'2022-06-23 12:02:10','',''),(417,'1','275','1',1,'Retail Sale Id 380',18600.00,0.00,0.00,25.00,1550.00,'2022-06-23 12:13:01','',''),(418,'1','275','1',1,'Retail Sale Id 381',151776.00,0.00,0.00,204.00,12648.00,'2022-06-23 12:16:55','',''),(419,'1','275','1',1,'Retail Sale Id 382',18600.00,0.00,0.00,25.00,1550.00,'2022-06-23 12:21:48','',''),(420,'1','275','1',1,'Retail Sale Id 383',5208.00,0.00,0.00,7.00,434.00,'2022-06-23 12:22:47','',''),(421,'1','275','1',1,'Retail Sale Id 384',37200.00,0.00,0.00,50.00,3100.00,'2022-06-23 12:30:48','',''),(422,'1','275','1',1,'Retail Sale Id 385',1502.88,0.00,0.00,2.02,125.24,'2022-06-23 12:41:07','',''),(423,'1','275','1',1,'Retail Sale Id 386',996.96,0.00,0.00,1.34,83.08,'2022-06-23 12:58:06','',''),(424,'1','275','1',1,'Retail Sale Id 387',7440.00,0.00,0.00,10.00,620.00,'2022-06-23 13:00:45','',''),(425,'1','275','1',1,'Retail Sale Id 388',18562.80,0.00,0.00,24.95,1546.90,'2022-06-23 13:02:50','',''),(426,'1','275','1',1,'Retail Sale Id 389',9300.00,0.00,0.00,12.50,775.00,'2022-06-23 13:11:38','',''),(427,'1','275','1',1,'Retail Sale Id 390',41001.84,0.00,0.00,55.11,3416.82,'2022-06-23 13:24:04','',''),(428,'1','275','1',1,'Retail Sale Id 391',9300.00,0.00,0.00,12.50,775.00,'2022-06-23 13:26:27','',''),(429,'1','275','1',1,'Retail Sale Id 392',4501.20,0.00,0.00,6.05,375.10,'2022-06-23 13:33:45','',''),(430,'1','275','1',1,'Retail Sale Id 393',996.96,0.00,0.00,1.34,83.08,'2022-06-23 13:34:42','',''),(431,'1','275','1',1,'Retail Sale Id 395',20088.00,0.00,0.00,27.00,1674.00,'2022-06-23 13:52:43','',''),(432,'1','275','1',1,'Retail Sale Id 396',8184.00,0.00,0.00,11.00,682.00,'2022-06-23 13:54:06','',''),(433,'1','275','1',1,'Retail Sale Id 397',9002.40,0.00,0.00,12.10,750.20,'2022-06-23 15:24:19','',''),(434,'1','275','1',1,'Retail Sale Id 398',2001.36,0.00,0.00,2.69,166.78,'2022-06-23 15:30:00','',''),(435,'1','275','1',1,'Retail Sale Id 399',8928.00,0.00,0.00,12.00,744.00,'2022-06-23 16:37:54','',''),(436,'1','275','1',1,'Retail Sale Id 400',9300.00,0.00,0.00,12.50,775.00,'2022-06-23 16:42:32','',''),(437,'1','275','1',1,'Retail Sale Id 401',3749.76,0.00,0.00,5.04,312.48,'2022-06-23 16:46:12','',''),(438,'1','275','1',1,'Retail Sale Id 402',9300.00,0.00,0.00,12.50,775.00,'2022-06-23 16:51:22','',''),(439,'1','275','1',1,'Retail Sale Id 403',116428.56,0.00,0.00,156.49,9702.38,'2022-06-23 19:29:18','',''),(440,'1','275','1',1,'Retail Sale Id 404',4501.20,0.00,0.00,6.05,375.10,'2022-06-24 08:34:35','',''),(441,'1','275','1',1,'Retail Sale Id 406',38003.52,0.00,0.00,51.08,3166.96,'2022-06-24 09:34:48','',''),(442,'1','275','1',1,'Return of Retail Sale Id 406',0.00,38003.52,51.08,0.00,-3166.96,'2022-06-24 09:37:08','',''),(443,'1','275','1',1,'Retail Sale Id 407',37200.00,0.00,0.00,50.00,3100.00,'2022-06-24 09:37:57','',''),(444,'1','275','1',1,'Retail Sale Id 408',2998.32,0.00,0.00,4.03,249.86,'2022-06-24 09:39:03','',''),(445,'1','275','1',1,'Retail Sale Id 409',4501.20,0.00,0.00,6.05,375.10,'2022-06-24 10:20:57','',''),(446,'1','275','1',1,'Retail Sale Id 411',3720.00,0.00,0.00,5.00,310.00,'2022-06-24 10:22:27','',''),(447,'1','275','1',1,'Retail Sale Id 412',9300.00,0.00,0.00,12.50,775.00,'2022-06-24 10:39:53','',''),(448,'1','275','1',1,'Retail Sale Id 413',9300.00,0.00,0.00,12.50,775.00,'2022-06-24 10:54:54','',''),(449,'1','275','1',1,'Retail Sale Id 414',18600.00,0.00,0.00,25.00,1550.00,'2022-06-24 10:55:59','',''),(450,'1','275','1',1,'Retail Sale Id 415',3720.00,0.00,0.00,5.00,310.00,'2022-06-24 11:13:38','',''),(451,'1','275','1',1,'Retail Sale Id 416',16501.92,0.00,0.00,22.18,1375.16,'2022-06-24 11:16:10','',''),(452,'1','275','1',1,'Retail Sale Id 417',8928.00,0.00,0.00,12.00,744.00,'2022-06-24 11:21:05','',''),(453,'1','275','1',1,'Retail Sale Id 417',37200.00,0.00,0.00,50.00,3100.00,'2022-06-24 11:21:05','',''),(454,'1','275','1',1,'Retail Sale Id 418',2998.32,0.00,0.00,4.03,249.86,'2022-06-24 11:25:01','',''),(455,'1','275','1',1,'Retail Sale Id 419',9300.00,0.00,0.00,12.50,775.00,'2022-06-24 11:32:34','',''),(456,'1','275','1',1,'Retail Sale Id 420',9300.00,0.00,0.00,12.50,775.00,'2022-06-24 11:36:38','',''),(457,'1','275','1',1,'Retail Sale Id 421',9300.00,0.00,0.00,12.50,775.00,'2022-06-24 11:37:32','',''),(458,'1','275','1',1,'Retail Sale Id 422',996.96,0.00,0.00,1.34,83.08,'2022-06-24 11:41:57','',''),(459,'1','275','1',1,'Retail Sale Id 423',18600.00,0.00,0.00,25.00,1550.00,'2022-06-24 12:15:13','',''),(460,'1','275','1',1,'Retail Sale Id 424',1502.88,0.00,0.00,2.02,125.24,'2022-06-24 12:20:15','',''),(461,'1','275','1',1,'Retail Sale Id 425',9300.00,0.00,0.00,12.50,775.00,'2022-06-24 12:48:48','',''),(462,'1','275','1',1,'Retail Sale Id 426',4999.68,0.00,0.00,6.72,416.64,'2022-06-24 12:55:14','',''),(463,'1','275','1',1,'Retail Sale Id 427',996.96,0.00,0.00,1.34,83.08,'2022-06-24 12:56:10','',''),(464,'1','275','1',1,'Retail Sale Id 428',4650.00,0.00,0.00,6.25,387.50,'2022-06-24 17:12:14','',''),(465,'1','275','1',1,'Retail Sale Id 429',2298.96,0.00,0.00,3.09,191.58,'2022-06-24 17:16:16','',''),(466,'1','275','1',1,'Retail Sale Id 430',18600.00,0.00,0.00,25.00,1550.00,'2022-06-24 18:14:43','',''),(467,'1','275','1',1,'Retail Sale Id 431',4501.20,0.00,0.00,6.05,375.10,'2022-06-24 18:16:17','',''),(468,'1','275','1',1,'Retail Sale Id 432',9300.00,0.00,0.00,12.50,775.00,'2022-06-24 18:52:07','',''),(469,'1','275','1',1,'Retail Sale Id 433',14999.04,0.00,0.00,20.16,1249.92,'2022-06-24 18:57:30','',''),(470,'1','275','1',1,'Retail Sale Id 434',187339.20,0.00,0.00,251.80,15611.60,'2022-06-24 19:32:25','',''),(471,'1','275','1',1,'Retail Sale Id 435',4501.20,0.00,0.00,6.05,375.10,'2022-06-25 07:37:12','',''),(472,'1','275','1',1,'Retail Sale Id 436',1502.88,0.00,0.00,2.02,125.24,'2022-06-25 10:11:58','',''),(473,'1','275','1',1,'Retail Sale Id 437',4002.72,0.00,0.00,5.38,333.56,'2022-06-25 10:13:24','',''),(474,'1','275','1',1,'Retail Sale Id 438',2998.32,0.00,0.00,4.03,249.86,'2022-06-25 10:14:08','',''),(475,'1','275','1',1,'Retail Sale Id 439',19998.72,0.00,0.00,26.88,1666.56,'2022-06-25 10:15:27','',''),(476,'1','275','1',1,'Retail Sale Id 442',2001.36,0.00,0.00,2.69,166.78,'2022-06-25 10:19:26','',''),(477,'1','275','1',1,'Retail Sale Id 443',9300.00,0.00,0.00,12.50,775.00,'2022-06-25 10:26:31','',''),(478,'1','275','1',1,'Retail Sale Id 445',74400.00,0.00,0.00,100.00,6200.00,'2022-06-25 10:32:28','',''),(479,'1','275','1',1,'Retail Sale Id 446',3801.84,0.00,0.00,5.11,316.82,'2022-06-25 10:41:17','',''),(480,'1','275','1',1,'Retail Sale Id 447',4092.00,0.00,0.00,5.50,341.00,'2022-06-25 11:58:20','',''),(481,'1','275','1',1,'Retail Sale Id 448',996.96,0.00,0.00,1.34,83.08,'2022-06-25 12:15:02','',''),(482,'1','275','1',1,'Retail Sale Id 449',9300.00,0.00,0.00,12.50,775.00,'2022-06-25 12:20:54','',''),(483,'1','275','1',1,'Retail Sale Id 450',32996.40,0.00,0.00,44.35,2749.70,'2022-06-25 12:53:15','',''),(484,'1','275','1',1,'Retail Sale Id 451',9300.00,0.00,0.00,12.50,775.00,'2022-06-25 12:57:11','',''),(485,'1','275','1',1,'Retail Sale Id 452',2298.96,0.00,0.00,3.09,191.58,'2022-06-25 13:00:56','',''),(486,'1','275','1',1,'Retail Sale Id 453',9300.00,0.00,0.00,12.50,775.00,'2022-06-25 13:20:17','',''),(487,'1','275','1',1,'Retail Sale Id 454',9300.00,0.00,0.00,12.50,775.00,'2022-06-25 13:31:55','',''),(488,'1','275','1',1,'Retail Sale Id 455',4501.20,0.00,0.00,6.05,375.10,'2022-06-25 13:45:39','',''),(489,'1','275','1',1,'Retail Sale Id 458',7998.00,0.00,0.00,10.75,666.50,'2022-06-25 13:50:59','',''),(490,'1','275','1',1,'Retail Sale Id 459',34997.76,0.00,0.00,47.04,2916.48,'2022-06-25 14:05:33','',''),(491,'1','275','1',1,'Retail Sale Id 460',2298.96,0.00,0.00,3.09,191.58,'2022-06-25 14:11:59','',''),(492,'1','275','1',1,'Retail Sale Id 461',9300.00,0.00,0.00,12.50,775.00,'2022-06-25 15:04:38','',''),(493,'1','275','1',1,'Retail Sale Id 462',18600.00,0.00,0.00,25.00,1550.00,'2022-06-25 15:05:51','',''),(494,'1','275','1',1,'Retail Sale Id 463',37200.00,0.00,0.00,50.00,3100.00,'2022-06-25 15:07:40','',''),(495,'1','275','1',1,'Retail Sale Id 464',11160.00,0.00,0.00,15.00,930.00,'2022-06-25 15:09:47','',''),(496,'1','275','1',1,'Retail Sale Id 465',7998.00,0.00,0.00,10.75,666.50,'2022-06-25 15:12:37','',''),(497,'1','275','1',1,'Retail Sale Id 466',9300.00,0.00,0.00,12.50,775.00,'2022-06-25 15:23:04','',''),(498,'1','275','1',1,'Retail Sale Id 467',9300.00,0.00,0.00,12.50,775.00,'2022-06-25 15:25:44','',''),(499,'1','275','1',1,'Retail Sale Id 468',9300.00,0.00,0.00,12.50,775.00,'2022-06-25 15:40:39','',''),(500,'1','275','1',1,'Retail Sale Id 470',2001.36,0.00,0.00,2.69,166.78,'2022-06-25 15:43:34','',''),(501,'1','275','1',1,'Retail Sale Id 471',145824.00,0.00,0.00,196.00,12152.00,'2022-06-25 15:47:42','',''),(502,'1','275','1',1,'Retail Sale Id 472',9300.00,0.00,0.00,12.50,775.00,'2022-06-25 15:50:13','',''),(503,'1','275','1',1,'Retail Sale Id 473',37200.00,0.00,0.00,50.00,3100.00,'2022-06-25 15:52:57','',''),(504,'1','275','1',1,'Retail Sale Id 474',18600.00,0.00,0.00,25.00,1550.00,'2022-06-25 16:27:06','',''),(505,'1','275','1',1,'Retail Sale Id 475',9300.00,0.00,0.00,12.50,775.00,'2022-06-25 16:27:58','',''),(506,'1','275','1',1,'Retail Sale Id 476',4501.20,0.00,0.00,6.05,375.10,'2022-06-25 16:34:24','',''),(507,'1','275','1',1,'Retail Sale Id 477',1502.88,0.00,0.00,2.02,125.24,'2022-06-25 16:43:35','',''),(508,'1','275','1',1,'Retail Sale Id 478',36456.00,0.00,0.00,49.00,3038.00,'2022-06-25 16:51:38','',''),(509,'1','275','1',1,'Retail Sale Id 479',2998.32,0.00,0.00,4.03,249.86,'2022-06-25 16:57:20','',''),(510,'1','275','1',1,'Retail Sale Id 480',74400.00,0.00,0.00,100.00,6200.00,'2022-06-25 17:02:31','',''),(511,'1','275','1',1,'Retail Sale Id 481',4501.20,0.00,0.00,6.05,375.10,'2022-06-25 17:08:05','',''),(512,'1','275','1',1,'Retail Sale Id 482',3720.00,0.00,0.00,5.00,310.00,'2022-06-25 17:21:43','',''),(513,'1','275','1',1,'Retail Sale Id 483',2998.32,0.00,0.00,4.03,249.86,'2022-06-25 17:23:09','',''),(514,'1','275','1',1,'Retail Sale Id 484',13392.00,0.00,0.00,18.00,1116.00,'2022-06-25 17:36:56','',''),(515,'1','275','1',1,'Retail Sale Id 485',9300.00,0.00,0.00,12.50,775.00,'2022-06-25 17:37:49','',''),(516,'1','275','1',1,'Retail Sale Id 486',5996.64,0.00,0.00,8.06,499.72,'2022-06-25 17:48:13','',''),(517,'1','275','1',1,'Retail Sale Id 487',9300.00,0.00,0.00,12.50,775.00,'2022-06-25 17:51:57','',''),(518,'1','275','1',1,'Retail Sale Id 488',4501.20,0.00,0.00,6.05,375.10,'2022-06-25 18:12:27','',''),(519,'1','275','1',1,'Retail Sale Id 489',22997.04,0.00,0.00,30.91,1916.42,'2022-06-25 18:15:35','',''),(520,'1','275','1',1,'Retail Sale Id 490',9300.00,0.00,0.00,12.50,775.00,'2022-06-25 18:21:07','',''),(521,'1','275','1',1,'Retail Sale Id 491',37200.00,0.00,0.00,50.00,3100.00,'2022-06-25 18:21:57','',''),(522,'1','275','1',1,'Retail Sale Id 492',117909.12,0.00,0.00,158.48,9825.76,'2022-06-25 19:25:56','',''),(523,'1','275','1',1,'Retail Sale Id 493',4501.20,0.00,0.00,6.05,375.10,'2022-06-26 07:51:10','',''),(524,'1','275','1',1,'Retail Sale Id 494',2001.36,0.00,0.00,2.69,166.78,'2022-06-26 07:59:38','',''),(525,'1','275','1',1,'Retail Sale Id 495',9300.00,0.00,0.00,12.50,775.00,'2022-06-26 08:10:58','',''),(526,'1','275','1',1,'Retail Sale Id 496',74400.00,0.00,0.00,100.00,6200.00,'2022-06-26 08:31:27','',''),(527,'1','275','1',1,'Retail Sale Id 497',34997.76,0.00,0.00,47.04,2916.48,'2022-06-26 08:33:01','',''),(528,'1','275','1',1,'Retail Sale Id 498',4501.20,0.00,0.00,6.05,375.10,'2022-06-26 08:52:37','',''),(529,'1','275','1',1,'Retail Sale Id 499',4501.20,0.00,0.00,6.05,375.10,'2022-06-26 09:03:42','',''),(530,'1','275','1',1,'Retail Sale Id 500',1502.88,0.00,0.00,2.02,125.24,'2022-06-26 09:06:43','',''),(531,'1','275','1',1,'Retail Sale Id 501',2998.32,0.00,0.00,4.03,249.86,'2022-06-26 09:07:45','',''),(532,'1','275','1',1,'Retail Sale Id 502',18600.00,0.00,0.00,25.00,1550.00,'2022-06-26 09:16:35','',''),(533,'1','275','1',1,'Retail Sale Id 503',9300.00,0.00,0.00,12.50,775.00,'2022-06-26 09:21:56','',''),(534,'1','275','1',1,'Retail Sale Id 504',9300.00,0.00,0.00,12.50,775.00,'2022-06-26 09:41:26','',''),(535,'1','275','1',1,'Retail Sale Id 505',2976.00,0.00,0.00,4.00,248.00,'2022-06-26 09:44:05','',''),(536,'1','275','1',1,'Retail Sale Id 505',4464.00,0.00,0.00,6.00,372.00,'2022-06-26 09:44:05','',''),(537,'1','275','1',1,'Retail Sale Id 506',9300.00,0.00,0.00,12.50,775.00,'2022-06-26 09:46:15','',''),(538,'1','275','1',1,'Retail Sale Id 507',7440.00,0.00,0.00,10.00,620.00,'2022-06-26 09:56:05','',''),(539,'1','275','1',1,'Retail Sale Id 508',1502.88,0.00,0.00,2.02,125.24,'2022-06-26 10:23:31','',''),(540,'1','275','1',1,'Retail Sale Id 509',9300.00,0.00,0.00,12.50,775.00,'2022-06-26 10:26:26','',''),(541,'1','275','1',1,'Retail Sale Id 510',4501.20,0.00,0.00,6.05,375.10,'2022-06-26 10:29:59','',''),(542,'1','275','1',1,'Retail Sale Id 511',18600.00,0.00,0.00,25.00,1550.00,'2022-06-26 10:40:37','',''),(543,'1','275','1',1,'Retail Sale Id 512',7440.00,0.00,0.00,10.00,620.00,'2022-06-26 10:45:50','',''),(544,'1','275','1',1,'Retail Sale Id 513',23808.00,0.00,0.00,32.00,1984.00,'2022-06-26 10:54:16','',''),(545,'1','275','1',1,'Retail Sale Id 514',9500.88,0.00,0.00,12.77,791.74,'2022-06-26 10:55:17','',''),(546,'1','275','1',1,'Retail Sale Id 515',24998.40,0.00,0.00,33.60,2083.20,'2022-06-26 11:59:51','',''),(547,'1','275','1',1,'Retail Sale Id 516',3720.00,0.00,0.00,5.00,310.00,'2022-06-26 12:12:24','',''),(548,'1','275','1',1,'Retail Sale Id 517',4397.04,0.00,0.00,5.91,366.42,'2022-06-26 12:34:49','',''),(549,'1','275','1',1,'Retail Sale Id 517',8898.24,0.00,0.00,11.96,741.52,'2022-06-26 12:34:49','',''),(550,'1','275','1',1,'Retail Sale Id 518',3496.80,0.00,0.00,4.70,291.40,'2022-06-26 12:35:53','',''),(551,'1','275','1',1,'Retail Sale Id 519',37200.00,0.00,0.00,50.00,3100.00,'2022-06-26 12:41:15','',''),(552,'1','275','1',1,'Retail Sale Id 520',4501.20,0.00,0.00,6.05,375.10,'2022-06-26 12:47:24','',''),(553,'1','275','1',1,'Retail Sale Id 521',9300.00,0.00,0.00,12.50,775.00,'2022-06-26 12:54:34','',''),(554,'1','275','1',1,'Retail Sale Id 522',4501.20,0.00,0.00,6.05,375.10,'2022-06-26 13:14:24','',''),(555,'1','275','1',1,'Retail Sale Id 523',4501.20,0.00,0.00,6.05,375.10,'2022-06-26 13:23:23','',''),(556,'1','275','1',1,'Retail Sale Id 524',4501.20,0.00,0.00,6.05,375.10,'2022-06-26 13:26:31','',''),(557,'1','275','1',1,'Retail Sale Id 525',2298.96,0.00,0.00,3.09,191.58,'2022-06-26 14:50:25','',''),(558,'1','275','1',1,'Retail Sale Id 526',3720.00,0.00,0.00,5.00,310.00,'2022-06-26 14:54:48','',''),(559,'1','275','1',1,'Retail Sale Id 528',9300.00,0.00,0.00,12.50,775.00,'2022-06-26 14:59:11','',''),(560,'1','275','1',1,'Retail Sale Id 529',9300.00,0.00,0.00,12.50,775.00,'2022-06-26 15:02:51','',''),(561,'1','275','1',1,'Retail Sale Id 529',18600.00,0.00,0.00,25.00,1550.00,'2022-06-26 15:02:51','',''),(562,'1','275','1',1,'Retail Sale Id 530',2001.36,0.00,0.00,2.69,166.78,'2022-06-26 15:45:29','',''),(563,'1','275','1',1,'Retail Sale Id 531',37200.00,0.00,0.00,50.00,3100.00,'2022-06-26 15:46:16','',''),(564,'1','275','1',1,'Retail Sale Id 532',9300.00,0.00,0.00,12.50,775.00,'2022-06-26 16:43:09','',''),(565,'1','275','1',1,'Retail Sale Id 533',4501.20,0.00,0.00,6.05,375.10,'2022-06-26 16:43:49','',''),(566,'1','275','1',1,'Retail Sale Id 534',18600.00,0.00,0.00,25.00,1550.00,'2022-06-26 16:53:03','',''),(567,'1','275','1',1,'Retail Sale Id 535',9300.00,0.00,0.00,12.50,775.00,'2022-06-26 17:01:39','',''),(568,'1','275','1',1,'Retail Sale Id 536',4501.20,0.00,0.00,6.05,375.10,'2022-06-26 17:28:36','',''),(569,'1','275','1',1,'Retail Sale Id 537',224933.52,0.00,0.00,302.33,18744.46,'2022-06-26 19:32:01','',''),(570,'1','275','1',1,'Retail Sale Id 539',14999.04,0.00,0.00,20.16,1249.92,'2022-06-27 08:16:21','',''),(571,'1','275','1',1,'Retail Sale Id 540',8303.04,0.00,0.00,11.16,691.92,'2022-06-27 08:17:35','',''),(572,'1','275','1',1,'Retail Sale Id 541',29998.08,0.00,0.00,40.32,2499.84,'2022-06-27 08:28:43','',''),(573,'1','275','1',1,'Retail Sale Id 542',1488.00,0.00,0.00,2.00,124.00,'2022-06-27 08:31:25','',''),(574,'1','275','1',1,'Retail Sale Id 543',10996.32,0.00,0.00,14.78,916.36,'2022-06-27 09:37:43','',''),(575,'1','275','1',1,'Retail Sale Id 544',9300.00,0.00,0.00,12.50,775.00,'2022-06-27 09:39:06','',''),(576,'1','275','1',1,'Retail Sale Id 545',29998.08,0.00,0.00,40.32,2499.84,'2022-06-27 09:41:29','',''),(577,'1','275','1',1,'Return of Retail Sale Id 545',0.00,29998.08,40.32,0.00,-2499.84,'2022-06-27 09:41:58','',''),(578,'1','275','1',1,'Retail Sale Id 546',27996.72,0.00,0.00,37.63,2333.06,'2022-06-27 09:42:37','',''),(579,'1','275','1',1,'Retail Sale Id 547',4501.20,0.00,0.00,6.05,375.10,'2022-06-27 09:51:33','',''),(580,'1','275','1',1,'Retail Sale Id 548',2998.32,0.00,0.00,4.03,249.86,'2022-06-27 09:55:24','',''),(581,'1','275','1',1,'Retail Sale Id 549',1502.88,0.00,0.00,2.02,125.24,'2022-06-27 10:18:41','',''),(582,'1','275','1',1,'Retail Sale Id 550',9300.00,0.00,0.00,12.50,775.00,'2022-06-27 10:36:11','',''),(583,'1','275','1',1,'Retail Sale Id 551',2298.96,0.00,0.00,3.09,191.58,'2022-06-27 10:39:24','',''),(584,'1','275','1',1,'Retail Sale Id 552',4501.20,0.00,0.00,6.05,375.10,'2022-06-27 10:55:07','',''),(585,'1','275','1',1,'Retail Sale Id 553',9300.00,0.00,0.00,12.50,775.00,'2022-06-27 11:02:07','',''),(586,'1','275','1',1,'Retail Sale Id 554',9300.00,0.00,0.00,12.50,775.00,'2022-06-27 11:19:46','',''),(587,'1','275','1',1,'Retail Sale Id 555',69192.00,0.00,0.00,93.00,5766.00,'2022-06-27 11:46:26','',''),(588,'1','275','1',1,'Retail Sale Id 557',7440.00,0.00,0.00,10.00,620.00,'2022-06-27 15:01:05','',''),(589,'1','275','1',1,'Retail Sale Id 558',9300.00,0.00,0.00,12.50,775.00,'2022-06-27 15:43:31','',''),(590,'1','275','1',1,'Retail Sale Id 559',37200.00,0.00,0.00,50.00,3100.00,'2022-06-27 16:01:53','',''),(591,'1','275','1',1,'Retail Sale Id 560',9002.40,0.00,0.00,12.10,750.20,'2022-06-27 16:07:20','',''),(592,'1','275','1',1,'Retail Sale Id 561',4501.20,0.00,0.00,6.05,375.10,'2022-06-27 16:22:45','',''),(593,'1','275','1',1,'Retail Sale Id 562',2998.32,0.00,0.00,4.03,249.86,'2022-06-27 16:31:09','',''),(594,'1','275','1',1,'Retail Sale Id 563',18600.00,0.00,0.00,25.00,1550.00,'2022-06-27 16:36:26','',''),(595,'1','275','1',1,'Retail Sale Id 564',18600.00,0.00,0.00,25.00,1550.00,'2022-06-27 16:37:03','',''),(596,'1','275','1',1,'Retail Sale Id 565',9300.00,0.00,0.00,12.50,775.00,'2022-06-27 16:37:56','',''),(597,'1','275','1',1,'Retail Sale Id 566',9300.00,0.00,0.00,12.50,775.00,'2022-06-27 16:38:29','',''),(598,'1','275','1',1,'Retail Sale Id 568',7499.52,0.00,0.00,10.08,624.96,'2022-06-27 16:47:58','',''),(599,'1','275','1',1,'Retail Sale Id 569',1502.88,0.00,0.00,2.02,125.24,'2022-06-27 16:49:02','',''),(600,'1','275','1',1,'Retail Sale Id 570',21576.00,0.00,0.00,29.00,1798.00,'2022-06-27 17:04:42','',''),(601,'1','275','1',1,'Retail Sale Id 571',803.52,0.00,0.00,1.08,66.96,'2022-06-27 17:13:43','',''),(602,'1','275','1',1,'Retail Sale Id 572',9300.00,0.00,0.00,12.50,775.00,'2022-06-27 17:17:33','',''),(603,'1','275','1',1,'Retail Sale Id 573',9300.00,0.00,0.00,12.50,775.00,'2022-06-27 17:46:26','',''),(604,'1','275','1',1,'Retail Sale Id 574',34997.76,0.00,0.00,47.04,2916.48,'2022-06-27 17:48:44','',''),(605,'1','275','1',1,'Retail Sale Id 575',996.96,0.00,0.00,1.34,83.08,'2022-06-27 17:50:52','',''),(606,'1','275','1',1,'Retail Sale Id 578',34968.00,0.00,0.00,47.00,2914.00,'2022-06-27 18:16:29','',''),(607,'1','275','1',1,'Retail Sale Id 579',996.96,0.00,0.00,1.34,83.08,'2022-06-27 18:23:57','',''),(608,'1','275','1',1,'Retail Sale Id 580',18600.00,0.00,0.00,25.00,1550.00,'2022-06-27 18:30:09','',''),(609,'1','275','1',1,'Retail Sale Id 581',1502.88,0.00,0.00,2.02,125.24,'2022-06-27 18:31:35','',''),(610,'1','275','1',1,'Retail Sale Id 582',9300.00,0.00,0.00,12.50,775.00,'2022-06-27 18:36:29','',''),(611,'1','275','1',1,'Retail Sale Id 584',40920.00,0.00,0.00,55.00,3410.00,'2022-06-27 18:37:39','',''),(612,'1','275','1',1,'Retail Sale Id 585',2298.96,0.00,0.00,3.09,191.58,'2022-06-27 18:48:21','',''),(613,'1','275','1',1,'Retail Sale Id 586',30585.84,0.00,0.00,41.11,2548.82,'2022-06-27 19:17:25','',''),(614,'1','275','1',1,'Retail Sale Id 587',38003.52,0.00,0.00,51.08,3166.96,'2022-06-28 07:19:40','',''),(615,'1','275','1',1,'Retail Sale Id 588',36002.16,0.00,0.00,48.39,3000.18,'2022-06-28 07:20:32','',''),(616,'1','275','1',1,'Return of Retail Sale Id 587',0.00,38003.52,51.08,0.00,-3166.96,'2022-06-28 07:21:54','',''),(617,'1','275','1',1,'Retail Sale Id 589',2298.96,0.00,0.00,3.09,191.58,'2022-06-28 07:39:21','',''),(618,'1','275','1',1,'Retail Sale Id 590',29998.08,0.00,0.00,40.32,2499.84,'2022-06-28 07:43:18','',''),(619,'1','275','1',1,'Retail Sale Id 591',9300.00,0.00,0.00,12.50,775.00,'2022-06-28 07:55:37','',''),(620,'1','275','1',1,'Retail Sale Id 592',9300.00,0.00,0.00,12.50,775.00,'2022-06-28 08:04:39','',''),(621,'1','275','1',1,'Retail Sale Id 593',9300.00,0.00,0.00,12.50,775.00,'2022-06-28 08:32:46','',''),(622,'1','275','1',1,'Retail Sale Id 594',9300.00,0.00,0.00,12.50,775.00,'2022-06-28 08:38:33','',''),(623,'1','275','1',1,'Retail Sale Id 595',9300.00,0.00,0.00,12.50,775.00,'2022-06-28 09:37:49','',''),(624,'1','275','1',1,'Retail Sale Id 596',9300.00,0.00,0.00,12.50,775.00,'2022-06-28 09:39:07','',''),(625,'1','275','1',1,'Retail Sale Id 597',7440.00,0.00,0.00,10.00,620.00,'2022-06-28 09:47:51','',''),(626,'1','275','1',1,'Retail Sale Id 598',9999.36,0.00,0.00,13.44,833.28,'2022-06-28 09:51:12','',''),(627,'1','275','1',1,'Retail Sale Id 600',2998.32,0.00,0.00,4.03,249.86,'2022-06-28 10:22:50','',''),(628,'1','275','1',1,'Retail Sale Id 600',2998.32,0.00,0.00,4.03,249.86,'2022-06-28 10:22:50','',''),(629,'1','275','1',1,'Retail Sale Id 601',119040.00,0.00,0.00,160.00,9920.00,'2022-06-28 11:10:28','',''),(630,'1','275','1',1,'Retail Sale Id 602',9300.00,0.00,0.00,12.50,775.00,'2022-06-28 11:11:39','',''),(631,'1','275','1',1,'Retail Sale Id 603',1197.84,0.00,0.00,1.61,99.82,'2022-06-28 11:18:05','',''),(632,'1','275','1',1,'Retail Sale Id 604',29998.08,0.00,0.00,40.32,2499.84,'2022-06-28 12:05:14','',''),(633,'1','275','1',1,'Return of Retail Sale Id 604',0.00,29998.08,40.32,0.00,-2499.84,'2022-06-28 12:05:52','',''),(634,'1','275','1',1,'Retail Sale Id 605',27996.72,0.00,0.00,37.63,2333.06,'2022-06-28 12:06:30','',''),(635,'1','275','1',1,'Retail Sale Id 607',1502.88,0.00,0.00,2.02,125.24,'2022-06-28 13:01:17','',''),(636,'1','275','1',1,'Retail Sale Id 608',24998.40,0.00,0.00,33.60,2083.20,'2022-06-28 13:02:49','',''),(637,'1','275','1',1,'Retail Sale Id 609',2998.32,0.00,0.00,4.03,249.86,'2022-06-28 14:08:05','',''),(638,'1','275','1',1,'Retail Sale Id 610',18600.00,0.00,0.00,25.00,1550.00,'2022-06-28 14:14:10','',''),(639,'1','275','1',1,'Retail Sale Id 611',9300.00,0.00,0.00,12.50,775.00,'2022-06-28 15:11:29','',''),(640,'1','275','1',1,'Retail Sale Id 612',19001.76,0.00,0.00,25.54,1583.48,'2022-06-28 15:40:54','',''),(641,'1','275','1',1,'Retail Sale Id 613',4501.20,0.00,0.00,6.05,375.10,'2022-06-28 16:02:13','',''),(642,'1','275','1',1,'Retail Sale Id 614',3720.00,0.00,0.00,5.00,310.00,'2022-06-28 16:38:19','',''),(643,'1','275','1',1,'Retail Sale Id 615',66372.24,0.00,0.00,89.21,5531.02,'2022-06-28 18:44:29','',''),(644,'1','275','1',1,'Distributed to Operational lost for sales id:5',59620.44,0.00,0.00,87.42,0.00,'2022-06-29 07:23:44','',''),(645,'1','275',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3641880.00,5340.00,0.00,0.00,'2022-06-29 08:00:46','',''),(646,'1','275',NULL,1,'Reception corrector for bridging 5',0.00,0.00,0.00,5340.00,0.00,'2022-06-29 08:03:16','',''),(647,'1','275','1',1,'Received from bridging 5',0.00,0.00,5340.00,0.00,0.00,'2022-06-29 08:03:16','',''),(648,'1','275','1',1,'Retail Sale Id 616',18600.00,0.00,0.00,25.00,1550.00,'2022-06-29 08:52:55','',''),(649,'1','275','1',1,'Retail Sale Id 617',9300.00,0.00,0.00,12.50,775.00,'2022-06-29 08:53:25','',''),(650,'1','275','1',1,'Retail Sale Id 618',9300.00,0.00,0.00,12.50,775.00,'2022-06-29 08:54:00','',''),(651,'1','275','1',1,'Retail Sale Id 619',9300.00,0.00,0.00,12.50,775.00,'2022-06-29 09:08:11','',''),(652,'1','275','1',1,'Retail Sale Id 620',9300.00,0.00,0.00,12.50,775.00,'2022-06-29 09:12:37','',''),(653,'1','275','1',1,'Retail Sale Id 621',9300.00,0.00,0.00,12.50,775.00,'2022-06-29 09:37:42','',''),(654,'1','275','1',1,'Retail Sale Id 622',9300.00,0.00,0.00,12.50,775.00,'2022-06-29 10:18:58','',''),(655,'1','275','1',1,'Retail Sale Id 623',4999.68,0.00,0.00,6.72,416.64,'2022-06-29 10:19:52','',''),(656,'1','275','1',1,'Retail Sale Id 624',996.96,0.00,0.00,1.34,83.08,'2022-06-29 10:29:45','',''),(657,'1','275','1',1,'Retail Sale Id 625',4501.20,0.00,0.00,6.05,375.10,'2022-06-29 10:30:30','',''),(658,'1','275','1',1,'Retail Sale Id 626',9300.00,0.00,0.00,12.50,775.00,'2022-06-29 10:33:52','',''),(659,'1','275','1',1,'Retail Sale Id 627',4501.20,0.00,0.00,6.05,375.10,'2022-06-29 10:34:35','',''),(660,'1','275','1',1,'Retail Sale Id 628',996.96,0.00,0.00,1.34,83.08,'2022-06-29 11:04:22','',''),(661,'1','275','1',1,'Retail Sale Id 629',996.96,0.00,0.00,1.34,83.08,'2022-06-29 11:10:01','',''),(662,'1','275','1',1,'Retail Sale Id 630',9300.00,0.00,0.00,12.50,775.00,'2022-06-29 11:14:28','',''),(663,'1','275','1',1,'Retail Sale Id 631',18600.00,0.00,0.00,25.00,1550.00,'2022-06-29 11:24:25','',''),(664,'1','275','1',1,'Retail Sale Id 632',9002.40,0.00,0.00,12.10,750.20,'2022-06-29 11:31:56','',''),(665,'1','275','1',1,'Retail Sale Id 633',751.44,0.00,0.00,1.01,62.62,'2022-06-29 11:34:46','',''),(666,'1','275','1',1,'Retail Sale Id 634',52080.00,0.00,0.00,70.00,4340.00,'2022-06-29 11:44:52','',''),(667,'1','275','1',1,'Retail Sale Id 635',4999.68,0.00,0.00,6.72,416.64,'2022-06-29 11:53:10','',''),(668,'1','275','1',1,'Retail Sale Id 636',2998.32,0.00,0.00,4.03,249.86,'2022-06-29 11:58:15','',''),(669,'1','275','1',1,'Retail Sale Id 637',4501.20,0.00,0.00,6.05,375.10,'2022-06-29 13:04:18','',''),(670,'1','275','1',1,'Retail Sale Id 638',8496.48,0.00,0.00,11.42,708.04,'2022-06-29 13:12:05','',''),(671,'1','275','1',1,'Retail Sale Id 639',2298.96,0.00,0.00,3.09,191.58,'2022-06-29 13:17:37','',''),(672,'1','275','1',1,'Retail Sale Id 640',1502.88,0.00,0.00,2.02,125.24,'2022-06-29 13:24:33','',''),(673,'1','275','1',1,'Retail Sale Id 641',2998.32,0.00,0.00,4.03,249.86,'2022-06-29 13:43:40','',''),(674,'1','275','1',1,'Retail Sale Id 642',12648.00,0.00,0.00,17.00,1054.00,'2022-06-29 13:47:34','',''),(675,'1','275','1',1,'Retail Sale Id 643',9300.00,0.00,0.00,12.50,775.00,'2022-06-29 14:21:50','',''),(676,'1','275','1',1,'Retail Sale Id 644',2298.96,0.00,0.00,3.09,191.58,'2022-06-29 14:25:03','',''),(677,'1','275','1',1,'Retail Sale Id 645',1502.88,0.00,0.00,2.02,125.24,'2022-06-29 14:34:31','',''),(678,'1','275','1',1,'Retail Sale Id 645',1502.88,0.00,0.00,2.02,125.24,'2022-06-29 14:34:31','',''),(679,'1','275','1',1,'Retail Sale Id 646',9300.00,0.00,0.00,12.50,775.00,'2022-06-29 14:38:40','',''),(680,'1','275','1',1,'Retail Sale Id 647',6703.44,0.00,0.00,9.01,558.62,'2022-06-29 14:41:03','',''),(681,'1','275','1',1,'Retail Sale Id 647',9300.00,0.00,0.00,12.50,775.00,'2022-06-29 14:41:03','',''),(682,'1','275','1',1,'Retail Sale Id 648',3720.00,0.00,0.00,5.00,310.00,'2022-06-29 14:58:05','',''),(683,'1','275','1',1,'Retail Sale Id 648',9300.00,0.00,0.00,12.50,775.00,'2022-06-29 14:58:05','',''),(684,'1','275','1',1,'Retail Sale Id 649',3720.00,0.00,0.00,5.00,310.00,'2022-06-29 15:01:53','',''),(685,'1','275','1',1,'Retail Sale Id 650',217136.40,0.00,0.00,291.85,18094.70,'2022-06-29 19:37:38','',''),(686,'1','275','1',1,'Retail Sale Id 651',4999.68,0.00,0.00,6.72,416.64,'2022-06-30 07:12:28','',''),(687,'1','275','1',1,'Retail Sale Id 652',4798.80,0.00,0.00,6.45,399.90,'2022-06-30 07:13:40','',''),(688,'1','275','1',1,'Retail Sale Id 652',37200.00,0.00,0.00,50.00,3100.00,'2022-06-30 07:13:40','',''),(689,'1','275','1',1,'Retail Sale Id 653',9300.00,0.00,0.00,12.50,775.00,'2022-06-30 07:24:01','',''),(690,'1','275','1',1,'Retail Sale Id 654',9300.00,0.00,0.00,12.50,775.00,'2022-06-30 07:26:28','',''),(691,'1','275','1',1,'Retail Sale Id 655',3720.00,0.00,0.00,5.00,310.00,'2022-06-30 07:27:07','',''),(692,'1','275','1',1,'Retail Sale Id 656',2976.00,0.00,0.00,4.00,248.00,'2022-06-30 07:27:49','',''),(693,'1','275','1',1,'Retail Sale Id 657',9300.00,0.00,0.00,12.50,775.00,'2022-06-30 07:32:49','',''),(694,'1','275','1',1,'Retail Sale Id 658',9300.00,0.00,0.00,12.50,775.00,'2022-06-30 07:48:52','',''),(695,'1','275','1',1,'Retail Sale Id 659',9300.00,0.00,0.00,12.50,775.00,'2022-06-30 08:01:27','',''),(696,'1','275','1',1,'Retail Sale Id 660',4464.00,0.00,0.00,6.00,372.00,'2022-06-30 08:10:07','',''),(697,'1','275','1',1,'Retail Sale Id 661',2298.96,0.00,0.00,3.09,191.58,'2022-06-30 08:16:05','',''),(698,'1','275','1',1,'Retail Sale Id 662',9300.00,0.00,0.00,12.50,775.00,'2022-06-30 08:31:52','',''),(699,'1','275','1',1,'Retail Sale Id 663',9300.00,0.00,0.00,12.50,775.00,'2022-06-30 08:38:43','',''),(700,'1','275','1',1,'Retail Sale Id 664',4501.20,0.00,0.00,6.05,375.10,'2022-06-30 08:40:43','',''),(701,'1','275','1',1,'Retail Sale Id 665',4501.20,0.00,0.00,6.05,375.10,'2022-06-30 09:16:57','',''),(702,'1','275','1',1,'Retail Sale Id 665',9300.00,0.00,0.00,12.50,775.00,'2022-06-30 09:16:57','',''),(703,'1','275','1',1,'Retail Sale Id 666',9300.00,0.00,0.00,12.50,775.00,'2022-06-30 09:20:10','',''),(704,'1','275','1',1,'Retail Sale Id 667',3720.00,0.00,0.00,5.00,310.00,'2022-06-30 09:22:09','',''),(705,'1','275','1',1,'Retail Sale Id 668',9300.00,0.00,0.00,12.50,775.00,'2022-06-30 09:24:32','',''),(706,'1','275','1',1,'Retail Sale Id 669',1502.88,0.00,0.00,2.02,125.24,'2022-06-30 09:38:16','',''),(707,'1','275','1',1,'Retail Sale Id 670',1502.88,0.00,0.00,2.02,125.24,'2022-06-30 09:45:29','',''),(708,'1','275','1',1,'Retail Sale Id 671',1502.88,0.00,0.00,2.02,125.24,'2022-06-30 09:46:18','',''),(709,'1','275','1',1,'Retail Sale Id 672',4501.20,0.00,0.00,6.05,375.10,'2022-06-30 10:16:17','',''),(710,'1','275','1',1,'Retail Sale Id 674',4501.20,0.00,0.00,6.05,375.10,'2022-06-30 10:34:47','',''),(711,'1','275','1',1,'Retail Sale Id 675',2998.32,0.00,0.00,4.03,249.86,'2022-06-30 10:35:59','',''),(712,'1','275','1',1,'Retail Sale Id 676',18600.00,0.00,0.00,25.00,1550.00,'2022-06-30 10:41:44','',''),(713,'1','275','1',1,'Retail Sale Id 677',1197.84,0.00,0.00,1.61,99.82,'2022-06-30 10:46:16','',''),(714,'1','275','1',1,'Retail Sale Id 678',18600.00,0.00,0.00,25.00,1550.00,'2022-06-30 11:06:07','',''),(715,'1','275','1',1,'Retail Sale Id 679',9300.00,0.00,0.00,12.50,775.00,'2022-06-30 11:11:05','',''),(716,'1','275','1',1,'Retail Sale Id 680',4501.20,0.00,0.00,6.05,375.10,'2022-06-30 11:21:31','',''),(717,'1','275','1',1,'Retail Sale Id 681',3496.80,0.00,0.00,4.70,291.40,'2022-06-30 11:22:26','',''),(718,'1','275','1',1,'Retail Sale Id 682',1502.88,0.00,0.00,2.02,125.24,'2022-06-30 11:25:32','',''),(719,'1','275','1',1,'Retail Sale Id 683',2499.84,0.00,0.00,3.36,208.32,'2022-06-30 12:39:42','',''),(720,'1','275','1',1,'Retail Sale Id 684',17856.00,0.00,0.00,24.00,1488.00,'2022-06-30 12:51:28','',''),(721,'1','275','1',1,'Retail Sale Id 685',9300.00,0.00,0.00,12.50,775.00,'2022-06-30 12:54:16','',''),(722,'1','275','1',1,'Retail Sale Id 686',4501.20,0.00,0.00,6.05,375.10,'2022-06-30 13:22:17','',''),(723,'1','275','1',1,'Retail Sale Id 687',2998.32,0.00,0.00,4.03,249.86,'2022-06-30 13:42:10','',''),(724,'1','275','1',1,'Retail Sale Id 688',2298.96,0.00,0.00,3.09,191.58,'2022-06-30 13:57:35','',''),(725,'1','275','1',1,'Retail Sale Id 689',1502.88,0.00,0.00,2.02,125.24,'2022-06-30 15:50:17','',''),(726,'1','275','1',1,'Retail Sale Id 690',9300.00,0.00,0.00,12.50,775.00,'2022-06-30 15:59:24','',''),(727,'1','275','1',1,'Retail Sale Id 691',2298.96,0.00,0.00,3.09,191.58,'2022-06-30 16:13:57','',''),(728,'1','275','1',1,'Retail Sale Id 692',2998.32,0.00,0.00,4.03,249.86,'2022-06-30 16:20:53','',''),(729,'1','275','1',1,'Retail Sale Id 693',3720.00,0.00,0.00,5.00,310.00,'2022-06-30 16:42:09','',''),(730,'1','275','1',1,'Retail Sale Id 694',4002.72,0.00,0.00,5.38,333.56,'2022-06-30 16:47:51','',''),(731,'1','275','1',1,'Retail Sale Id 695',2499.84,0.00,0.00,3.36,208.32,'2022-06-30 17:16:35','',''),(732,'1','275','1',1,'Retail Sale Id 695',9300.00,0.00,0.00,12.50,775.00,'2022-06-30 17:16:35','',''),(733,'1','275','1',1,'Retail Sale Id 696',4501.20,0.00,0.00,6.05,375.10,'2022-06-30 18:08:39','',''),(734,'1','275','1',1,'Retail Sale Id 697',4501.20,0.00,0.00,6.05,375.10,'2022-06-30 18:10:24','',''),(735,'1','275','1',1,'Retail Sale Id 698',18600.00,0.00,0.00,25.00,1550.00,'2022-06-30 18:22:25','',''),(736,'1','275','1',1,'Retail Sale Id 699',7998.00,0.00,0.00,10.75,666.50,'2022-06-30 18:23:36','',''),(737,'1','275','1',1,'Retail Sale Id 700',9300.00,0.00,0.00,12.50,775.00,'2022-06-30 18:29:52','',''),(738,'1','275','1',1,'Retail Sale Id 701',9300.00,0.00,0.00,12.50,775.00,'2022-06-30 18:33:31','',''),(739,'1','275','1',1,'Retail Sale Id 702',9300.00,0.00,0.00,12.50,775.00,'2022-06-30 18:47:51','',''),(740,'1','275','1',1,'Retail Sale Id 703',55056.00,0.00,0.00,74.00,4588.00,'2022-06-30 19:20:21','',''),(741,'1','275','1',1,'Retail Sale Id 704',33993.36,0.00,0.00,45.69,2832.78,'2022-06-30 19:47:20','',''),(742,'1','275','1',1,'Return of Retail Sale Id 704',0.00,33993.36,45.69,0.00,-2832.78,'2022-06-30 19:48:31','',''),(743,'1','275','1',1,'Retail Sale Id 705',33993.36,0.00,0.00,45.69,2832.78,'2022-06-30 19:50:08','',''),(744,'1','275','1',1,'Retail Sale Id 706',9300.00,0.00,0.00,12.50,775.00,'2022-07-01 08:27:00','',''),(745,'1','275','1',1,'Retail Sale Id 707',9300.00,0.00,0.00,12.50,775.00,'2022-07-01 08:52:18','',''),(746,'1','275','1',1,'Retail Sale Id 708',9300.00,0.00,0.00,12.50,775.00,'2022-07-01 09:06:47','',''),(747,'1','275','1',1,'Retail Sale Id 709',2998.32,0.00,0.00,4.03,249.86,'2022-07-01 09:11:20','',''),(748,'1','275','1',1,'Retail Sale Id 710',1502.88,0.00,0.00,2.02,125.24,'2022-07-01 09:26:17','',''),(749,'1','275','1',1,'Retail Sale Id 711',9300.00,0.00,0.00,12.50,775.00,'2022-07-01 09:43:42','',''),(750,'1','275','1',1,'Retail Sale Id 712',3720.00,0.00,0.00,5.00,310.00,'2022-07-01 10:15:44','',''),(751,'1','275','1',1,'Retail Sale Id 712',9300.00,0.00,0.00,12.50,775.00,'2022-07-01 10:15:44','',''),(752,'1','275','1',1,'Retail Sale Id 713',9300.00,0.00,0.00,12.50,775.00,'2022-07-01 10:33:31','',''),(753,'1','275','1',1,'Retail Sale Id 714',14002.08,0.00,0.00,18.82,1166.84,'2022-07-01 10:34:26','',''),(754,'1','275','1',1,'Retail Sale Id 715',9300.00,0.00,0.00,12.50,775.00,'2022-07-01 12:24:38','',''),(755,'1','275','1',1,'Retail Sale Id 716',18600.00,0.00,0.00,25.00,1550.00,'2022-07-01 12:25:08','',''),(756,'1','275','1',1,'Retail Sale Id 717',3720.00,0.00,0.00,5.00,310.00,'2022-07-01 12:26:24','',''),(757,'1','275','1',1,'Retail Sale Id 718',9300.00,0.00,0.00,12.50,775.00,'2022-07-01 12:28:20','',''),(758,'1','275','1',1,'Retail Sale Id 719',2298.96,0.00,0.00,3.09,191.58,'2022-07-01 12:47:38','',''),(759,'1','275','1',1,'Retail Sale Id 720',4501.20,0.00,0.00,6.05,375.10,'2022-07-01 13:27:26','',''),(760,'1','275','1',1,'Retail Sale Id 721',4501.20,0.00,0.00,6.05,375.10,'2022-07-01 13:28:53','',''),(761,'1','275','1',1,'Retail Sale Id 721',9300.00,0.00,0.00,12.50,775.00,'2022-07-01 13:28:53','',''),(762,'1','275','1',1,'Retail Sale Id 722',3720.00,0.00,0.00,5.00,310.00,'2022-07-01 14:17:55','',''),(763,'1','275','1',1,'Retail Sale Id 723',4501.20,0.00,0.00,6.05,375.10,'2022-07-01 14:20:57','',''),(764,'1','275','1',1,'Retail Sale Id 724',7998.00,0.00,0.00,10.75,666.50,'2022-07-01 14:28:56','',''),(765,'1','275','1',1,'Retail Sale Id 725',4501.20,0.00,0.00,6.05,375.10,'2022-07-01 14:44:56','',''),(766,'1','275','1',1,'Retail Sale Id 726',9300.00,0.00,0.00,12.50,775.00,'2022-07-01 15:00:08','',''),(767,'1','275','1',1,'Retail Sale Id 727',18600.00,0.00,0.00,25.00,1550.00,'2022-07-01 15:07:44','',''),(768,'1','275','1',1,'Retail Sale Id 728',1502.88,0.00,0.00,2.02,125.24,'2022-07-01 15:28:24','',''),(769,'1','275','1',1,'Retail Sale Id 729',26040.00,0.00,0.00,35.00,2170.00,'2022-07-01 15:31:22','',''),(770,'1','275','1',1,'Retail Sale Id 730',2298.96,0.00,0.00,3.09,191.58,'2022-07-01 15:57:32','',''),(771,'1','275','1',1,'Retail Sale Id 731',4501.20,0.00,0.00,6.05,375.10,'2022-07-01 16:14:48','',''),(772,'1','275','1',1,'Retail Sale Id 732',9300.00,0.00,0.00,12.50,775.00,'2022-07-01 16:37:57','',''),(773,'1','275','1',1,'Retail Sale Id 733',2998.32,0.00,0.00,4.03,249.86,'2022-07-01 17:06:36','',''),(774,'1','275','1',1,'Retail Sale Id 734',16003.44,0.00,0.00,21.51,1333.62,'2022-07-01 17:22:50','',''),(775,'1','275','1',1,'Retail Sale Id 736',29760.00,0.00,0.00,40.00,2480.00,'2022-07-01 17:36:07','',''),(776,'1','275','1',1,'Retail Sale Id 737',1197.84,0.00,0.00,1.61,99.82,'2022-07-01 18:02:21','',''),(777,'1','275','1',1,'Retail Sale Id 738',4501.20,0.00,0.00,6.05,375.10,'2022-07-01 18:54:40','',''),(778,'1','275','1',1,'Retail Sale Id 739',4501.20,0.00,0.00,6.05,375.10,'2022-07-01 19:17:51','',''),(779,'1','275','1',1,'Retail Sale Id 740',7194.48,0.00,0.00,9.67,599.54,'2022-07-01 19:58:20','',''),(780,'1','275','1',1,'Retail Sale Id 741',29998.08,0.00,0.00,40.32,2499.84,'2022-07-02 08:10:30','',''),(781,'1','275','1',1,'Return of Retail Sale Id 741',0.00,29998.08,40.32,0.00,-2499.84,'2022-07-02 08:10:54','',''),(782,'1','275','1',1,'Retail Sale Id 742',27996.72,0.00,0.00,37.63,2333.06,'2022-07-02 08:11:32','',''),(783,'1','275','1',1,'Retail Sale Id 743',2001.36,0.00,0.00,2.69,166.78,'2022-07-02 08:13:42','',''),(784,'1','275','1',1,'Retail Sale Id 744',1502.88,0.00,0.00,2.02,125.24,'2022-07-02 08:25:28','',''),(785,'1','275','1',1,'Retail Sale Id 745',9300.00,0.00,0.00,12.50,775.00,'2022-07-02 08:26:35','',''),(786,'1','275','1',1,'Retail Sale Id 746',9300.00,0.00,0.00,12.50,775.00,'2022-07-02 08:31:59','',''),(787,'1','275','1',1,'Retail Sale Id 747',4501.20,0.00,0.00,6.05,375.10,'2022-07-02 08:39:29','',''),(788,'1','275','1',1,'Retail Sale Id 748',1502.88,0.00,0.00,2.02,125.24,'2022-07-02 08:46:58','',''),(789,'1','275','1',1,'Retail Sale Id 749',2998.32,0.00,0.00,4.03,249.86,'2022-07-02 08:53:19','',''),(790,'1','275','1',1,'Retail Sale Id 750',2001.36,0.00,0.00,2.69,166.78,'2022-07-02 08:59:30','',''),(791,'1','275','1',1,'Retail Sale Id 751',2998.32,0.00,0.00,4.03,249.86,'2022-07-02 09:29:03','',''),(792,'1','275','1',1,'Retail Sale Id 752',7440.00,0.00,0.00,10.00,620.00,'2022-07-02 09:29:59','',''),(793,'1','275','1',1,'Retail Sale Id 753',9300.00,0.00,0.00,12.50,775.00,'2022-07-02 09:31:04','',''),(794,'1','275','1',1,'Retail Sale Id 754',3720.00,0.00,0.00,5.00,310.00,'2022-07-02 09:46:13','',''),(795,'1','275','1',1,'Retail Sale Id 756',24001.44,0.00,0.00,32.26,2000.12,'2022-07-02 10:28:28','',''),(796,'1','275','1',1,'Retail Sale Id 757',37200.00,0.00,0.00,50.00,3100.00,'2022-07-02 10:34:15','',''),(797,'1','275','1',1,'Retail Sale Id 758',9002.40,0.00,0.00,12.10,750.20,'2022-07-02 10:34:44','',''),(798,'1','275','1',1,'Retail Sale Id 759',14247.60,0.00,0.00,19.15,1187.30,'2022-07-02 10:35:43','',''),(799,'1','275','1',1,'Retail Sale Id 760',37200.00,0.00,0.00,50.00,3100.00,'2022-07-02 10:47:18','',''),(800,'1','275','1',1,'Retail Sale Id 761',2298.96,0.00,0.00,3.09,191.58,'2022-07-02 10:53:35','',''),(801,'1','275','1',1,'Retail Sale Id 762',9300.00,0.00,0.00,12.50,775.00,'2022-07-02 10:56:03','',''),(802,'1','275','1',1,'Retail Sale Id 763',7440.00,0.00,0.00,10.00,620.00,'2022-07-02 10:56:48','',''),(803,'1','275','1',1,'Retail Sale Id 764',2998.32,0.00,0.00,4.03,249.86,'2022-07-02 10:57:37','',''),(804,'1','275','1',1,'Retail Sale Id 765',3720.00,0.00,0.00,5.00,310.00,'2022-07-02 10:59:14','',''),(805,'1','275','1',1,'Retail Sale Id 766',2998.32,0.00,0.00,4.03,249.86,'2022-07-02 11:02:04','',''),(806,'1','275','1',1,'Retail Sale Id 767',2298.96,0.00,0.00,3.09,191.58,'2022-07-02 11:05:22','',''),(807,'1','275','1',1,'Retail Sale Id 767',9300.00,0.00,0.00,12.50,775.00,'2022-07-02 11:05:22','',''),(808,'1','275','1',1,'Retail Sale Id 768',9300.00,0.00,0.00,12.50,775.00,'2022-07-02 11:20:33','',''),(809,'1','275','1',1,'Retail Sale Id 769',2298.96,0.00,0.00,3.09,191.58,'2022-07-02 11:24:14','',''),(810,'1','275','1',1,'Retail Sale Id 770',1502.88,0.00,0.00,2.02,125.24,'2022-07-02 11:36:32','',''),(811,'1','275','1',1,'Retail Sale Id 771',18600.00,0.00,0.00,25.00,1550.00,'2022-07-02 11:37:32','',''),(812,'1','275','1',1,'Retail Sale Id 772',2298.96,0.00,0.00,3.09,191.58,'2022-07-02 11:53:28','',''),(813,'1','275','1',1,'Retail Sale Id 773',9300.00,0.00,0.00,12.50,775.00,'2022-07-02 11:54:25','',''),(814,'1','275','1',1,'Retail Sale Id 774',9300.00,0.00,0.00,12.50,775.00,'2022-07-02 12:00:52','',''),(815,'1','275','1',1,'Retail Sale Id 775',1502.88,0.00,0.00,2.02,125.24,'2022-07-02 12:19:57','',''),(816,'1','275','1',1,'Retail Sale Id 776',9300.00,0.00,0.00,12.50,775.00,'2022-07-02 12:48:39','',''),(817,'1','275','1',1,'Retail Sale Id 777',37200.00,0.00,0.00,50.00,3100.00,'2022-07-02 12:55:49','',''),(818,'1','275','1',1,'Retail Sale Id 778',1502.88,0.00,0.00,2.02,125.24,'2022-07-02 13:24:14','',''),(819,'1','275','1',1,'Retail Sale Id 780',2298.96,0.00,0.00,3.09,191.58,'2022-07-02 15:03:39','',''),(820,'1','275','1',1,'Retail Sale Id 781',9300.00,0.00,0.00,12.50,775.00,'2022-07-02 15:04:40','',''),(821,'1','275','1',1,'Retail Sale Id 782',2298.96,0.00,0.00,3.09,191.58,'2022-07-02 15:23:09','',''),(822,'1','275','1',1,'Retail Sale Id 783',4501.20,0.00,0.00,6.05,375.10,'2022-07-02 15:44:22','',''),(823,'1','275','1',1,'Retail Sale Id 784',3720.00,0.00,0.00,5.00,310.00,'2022-07-02 15:51:45','',''),(824,'1','275','1',1,'Retail Sale Id 785',3720.00,0.00,0.00,5.00,310.00,'2022-07-02 16:09:15','',''),(825,'1','275','1',1,'Retail Sale Id 785',9300.00,0.00,0.00,12.50,775.00,'2022-07-02 16:09:15','',''),(826,'1','275','1',1,'Retail Sale Id 786',4501.20,0.00,0.00,6.05,375.10,'2022-07-02 16:35:02','',''),(827,'1','275','1',1,'Retail Sale Id 787',9300.00,0.00,0.00,12.50,775.00,'2022-07-02 16:49:43','',''),(828,'1','275','1',1,'Retail Sale Id 788',2001.36,0.00,0.00,2.69,166.78,'2022-07-02 17:04:08','',''),(829,'1','275','1',1,'Retail Sale Id 789',9300.00,0.00,0.00,12.50,775.00,'2022-07-02 17:26:30','',''),(830,'1','275','1',1,'Retail Sale Id 790',24998.40,0.00,0.00,33.60,2083.20,'2022-07-02 17:45:18','',''),(831,'1','275','1',1,'Retail Sale Id 791',22997.04,0.00,0.00,30.91,1916.42,'2022-07-02 17:46:12','',''),(832,'1','275','1',1,'Return of Retail Sale Id 790',0.00,24998.40,33.60,0.00,-2083.20,'2022-07-02 17:49:27','',''),(833,'1','275','1',1,'Retail Sale Id 792',8184.00,0.00,0.00,11.00,682.00,'2022-07-02 18:07:00','',''),(834,'1','275','1',1,'Retail Sale Id 793',2298.96,0.00,0.00,3.09,191.58,'2022-07-02 18:24:33','',''),(835,'1','275','1',1,'Retail Sale Id 794',9300.00,0.00,0.00,12.50,775.00,'2022-07-02 18:47:01','',''),(836,'1','275','1',1,'Retail Sale Id 795',9300.00,0.00,0.00,12.50,775.00,'2022-07-02 18:55:47','',''),(837,'1','275','1',1,'Retail Sale Id 797',29998.08,0.00,0.00,40.32,2499.84,'2022-07-02 19:04:04','',''),(838,'1','275','1',1,'Retail Sale Id 798',27996.72,0.00,0.00,37.63,2333.06,'2022-07-02 19:04:50','',''),(839,'1','275','1',1,'Return of Retail Sale Id 797',0.00,29998.08,40.32,0.00,-2499.84,'2022-07-02 19:06:01','',''),(840,'1','275','1',1,'Retail Sale Id 799',9300.00,0.00,0.00,12.50,775.00,'2022-07-02 19:07:56','',''),(841,'1','275','1',1,'Retail Sale Id 800',3720.00,0.00,0.00,5.00,310.00,'2022-07-02 19:12:11','',''),(842,'1','275','1',1,'Retail Sale Id 801',74400.00,0.00,0.00,100.00,6200.00,'2022-07-02 19:49:36','',''),(843,'1','275','1',1,'Retail Sale Id 802',34216.56,0.00,0.00,45.99,2851.38,'2022-07-02 19:51:06','',''),(844,'1','275','1',1,'Retail Sale Id 803',9300.00,0.00,0.00,12.50,775.00,'2022-07-03 07:28:31','',''),(845,'1','275','1',1,'Retail Sale Id 804',9300.00,0.00,0.00,12.50,775.00,'2022-07-03 07:29:18','',''),(846,'1','275','1',1,'Retail Sale Id 805',4501.20,0.00,0.00,6.05,375.10,'2022-07-03 07:44:39','',''),(847,'1','275','1',1,'Retail Sale Id 806',9300.00,0.00,0.00,12.50,775.00,'2022-07-03 07:49:51','',''),(848,'1','275','1',1,'Retail Sale Id 807',4501.20,0.00,0.00,6.05,375.10,'2022-07-03 08:02:59','',''),(849,'1','275','1',1,'Retail Sale Id 808',2998.32,0.00,0.00,4.03,249.86,'2022-07-03 08:04:06','',''),(850,'1','275','1',1,'Retail Sale Id 809',2298.96,0.00,0.00,3.09,191.58,'2022-07-03 08:48:43','',''),(851,'1','275','1',1,'Retail Sale Id 810',996.96,0.00,0.00,1.34,83.08,'2022-07-03 09:09:43','',''),(852,'1','275','1',1,'Retail Sale Id 811',9300.00,0.00,0.00,12.50,775.00,'2022-07-03 10:01:47','',''),(853,'1','275','1',1,'Retail Sale Id 812',4501.20,0.00,0.00,6.05,375.10,'2022-07-03 10:13:36','',''),(854,'1','275','1',1,'Retail Sale Id 813',9300.00,0.00,0.00,12.50,775.00,'2022-07-03 10:27:07','',''),(855,'1','275','1',1,'Retail Sale Id 814',1502.88,0.00,0.00,2.02,125.24,'2022-07-03 10:28:00','',''),(856,'1','275','1',1,'Retail Sale Id 816',9300.00,0.00,0.00,12.50,775.00,'2022-07-03 10:31:23','',''),(857,'1','275','1',1,'Retail Sale Id 817',9300.00,0.00,0.00,12.50,775.00,'2022-07-03 10:34:30','',''),(858,'1','275','1',1,'Retail Sale Id 817',11160.00,0.00,0.00,15.00,930.00,'2022-07-03 10:34:30','',''),(859,'1','275','1',1,'Retail Sale Id 818',2298.96,0.00,0.00,3.09,191.58,'2022-07-03 10:36:45','',''),(860,'1','275','1',1,'Retail Sale Id 819',9300.00,0.00,0.00,12.50,775.00,'2022-07-03 10:41:58','',''),(861,'1','275','1',1,'Retail Sale Id 820',2298.96,0.00,0.00,3.09,191.58,'2022-07-03 10:59:56','',''),(862,'1','275','1',1,'Retail Sale Id 820',2998.32,0.00,0.00,4.03,249.86,'2022-07-03 10:59:56','',''),(863,'1','275','1',1,'Retail Sale Id 821',1502.88,0.00,0.00,2.02,125.24,'2022-07-03 11:21:51','',''),(864,'1','275','1',1,'Retail Sale Id 822',996.96,0.00,0.00,1.34,83.08,'2022-07-03 11:23:22','',''),(865,'1','275','1',1,'Retail Sale Id 823',18600.00,0.00,0.00,25.00,1550.00,'2022-07-03 11:35:37','',''),(866,'1','275','1',1,'Retail Sale Id 824',2499.84,0.00,0.00,3.36,208.32,'2022-07-03 11:50:43','',''),(867,'1','275','1',1,'Retail Sale Id 825',3720.00,0.00,0.00,5.00,310.00,'2022-07-03 11:54:55','',''),(868,'1','275','1',1,'Retail Sale Id 826',31999.44,0.00,0.00,43.01,2666.62,'2022-07-03 12:06:56','',''),(869,'1','275','1',1,'Retail Sale Id 827',29998.08,0.00,0.00,40.32,2499.84,'2022-07-03 12:07:46','',''),(870,'1','275','1',1,'Retail Sale Id 828',2499.84,0.00,0.00,3.36,208.32,'2022-07-03 12:36:29','',''),(871,'1','275','1',1,'Return of Retail Sale Id 826',0.00,31999.44,43.01,0.00,-2666.62,'2022-07-03 12:37:08','',''),(872,'1','275','1',1,'Retail Sale Id 829',9300.00,0.00,0.00,12.50,775.00,'2022-07-03 12:51:16','',''),(873,'1','275','1',1,'Retail Sale Id 830',27996.72,0.00,0.00,37.63,2333.06,'2022-07-03 12:54:59','',''),(874,'1','275','1',1,'Retail Sale Id 831',9300.00,0.00,0.00,12.50,775.00,'2022-07-03 12:57:58','',''),(875,'1','275','1',1,'Retail Sale Id 832',2298.96,0.00,0.00,3.09,191.58,'2022-07-03 13:04:59','',''),(876,'1','275','1',1,'Retail Sale Id 833',4501.20,0.00,0.00,6.05,375.10,'2022-07-03 13:05:43','',''),(877,'1','275','1',1,'Retail Sale Id 834',9300.00,0.00,0.00,12.50,775.00,'2022-07-03 14:43:09','',''),(878,'1','275','1',1,'Retail Sale Id 835',2298.96,0.00,0.00,3.09,191.58,'2022-07-03 14:56:36','',''),(879,'1','275','1',1,'Retail Sale Id 836',9002.40,0.00,0.00,12.10,750.20,'2022-07-03 15:04:41','',''),(880,'1','275','1',1,'Retail Sale Id 837',9300.00,0.00,0.00,12.50,775.00,'2022-07-03 15:18:30','',''),(881,'1','275','1',1,'Retail Sale Id 838',1502.88,0.00,0.00,2.02,125.24,'2022-07-03 15:46:21','',''),(882,'1','275','1',1,'Retail Sale Id 839',4501.20,0.00,0.00,6.05,375.10,'2022-07-03 15:47:26','',''),(883,'1','275','1',1,'Retail Sale Id 840',2298.96,0.00,0.00,3.09,191.58,'2022-07-03 16:17:00','',''),(884,'1','275','1',1,'Retail Sale Id 841',9300.00,0.00,0.00,12.50,775.00,'2022-07-03 16:24:53','',''),(885,'1','275','1',1,'Retail Sale Id 842',36999.12,0.00,0.00,49.73,3083.26,'2022-07-03 16:38:53','',''),(886,'1','275','1',1,'Return of Retail Sale Id 842',0.00,36999.12,49.73,0.00,-3083.26,'2022-07-03 16:43:35','',''),(887,'1','275','1',1,'Retail Sale Id 843',34997.76,0.00,0.00,47.04,2916.48,'2022-07-03 16:45:05','',''),(888,'1','275','1',1,'Retail Sale Id 844',9300.00,0.00,0.00,12.50,775.00,'2022-07-03 16:51:31','',''),(889,'1','275','1',1,'Retail Sale Id 844',9300.00,0.00,0.00,12.50,775.00,'2022-07-03 16:51:31','',''),(890,'1','275','1',1,'Retail Sale Id 845',3496.80,0.00,0.00,4.70,291.40,'2022-07-03 17:08:53','',''),(891,'1','275','1',1,'Retail Sale Id 846',9300.00,0.00,0.00,12.50,775.00,'2022-07-03 17:34:39','',''),(892,'1','275','1',1,'Retail Sale Id 847',4702.08,0.00,0.00,6.32,391.84,'2022-07-03 17:40:37','',''),(893,'1','275','1',1,'Retail Sale Id 848',2998.32,0.00,0.00,4.03,249.86,'2022-07-03 17:46:45','',''),(894,'1','275','1',1,'Retail Sale Id 849',9300.00,0.00,0.00,12.50,775.00,'2022-07-03 17:48:50','',''),(895,'1','275','1',1,'Retail Sale Id 850',14880.00,0.00,0.00,20.00,1240.00,'2022-07-03 17:52:12','',''),(896,'1','275','1',1,'Retail Sale Id 851',4650.00,0.00,0.00,6.25,387.50,'2022-07-03 17:56:26','',''),(897,'1','275','1',1,'Retail Sale Id 852',2998.32,0.00,0.00,4.03,249.86,'2022-07-03 18:06:04','',''),(898,'1','275','1',1,'Retail Sale Id 853',3720.00,0.00,0.00,5.00,310.00,'2022-07-03 18:30:57','',''),(899,'1','275','1',1,'Retail Sale Id 854',7440.00,0.00,0.00,10.00,620.00,'2022-07-03 18:40:34','',''),(900,'1','275','1',1,'Retail Sale Id 855',9300.00,0.00,0.00,12.50,775.00,'2022-07-03 18:46:44','',''),(901,'1','275','1',1,'Retail Sale Id 856',20281.44,0.00,0.00,27.26,1690.12,'2022-07-03 19:22:11','',''),(902,'1','275','1',1,'Retail Sale Id 857',34997.76,0.00,0.00,47.04,2916.48,'2022-07-04 07:17:38','',''),(903,'1','275','1',1,'Retail Sale Id 858',744.00,0.00,0.00,1.00,62.00,'2022-07-04 07:45:57','',''),(904,'1','275','1',1,'Retail Sale Id 859',4999.68,0.00,0.00,6.72,416.64,'2022-07-04 08:26:36','',''),(905,'1','275','1',1,'Retail Sale Id 860',1502.88,0.00,0.00,2.02,125.24,'2022-07-04 08:37:40','',''),(906,'1','275','1',1,'Retail Sale Id 861',9300.00,0.00,0.00,12.50,775.00,'2022-07-04 08:53:00','',''),(907,'1','275','1',1,'Retail Sale Id 862',1502.88,0.00,0.00,2.02,125.24,'2022-07-04 09:49:45','',''),(908,'1','275','1',1,'Retail Sale Id 863',9300.00,0.00,0.00,12.50,775.00,'2022-07-04 10:05:56','',''),(909,'1','275','1',1,'Retail Sale Id 864',1502.88,0.00,0.00,2.02,125.24,'2022-07-04 10:40:08','',''),(910,'1','275','1',1,'Retail Sale Id 864',1502.88,0.00,0.00,2.02,125.24,'2022-07-04 10:40:08','',''),(911,'1','275','1',1,'Retail Sale Id 865',4501.20,0.00,0.00,6.05,375.10,'2022-07-04 10:43:18','',''),(912,'1','275','1',1,'Retail Sale Id 866',996.96,0.00,0.00,1.34,83.08,'2022-07-04 11:00:40','',''),(913,'1','275','1',1,'Retail Sale Id 867',9300.00,0.00,0.00,12.50,775.00,'2022-07-04 11:11:23','',''),(914,'1','275','1',1,'Retail Sale Id 868',996.96,0.00,0.00,1.34,83.08,'2022-07-04 11:23:42','',''),(915,'1','275','1',1,'Retail Sale Id 869',3720.00,0.00,0.00,5.00,310.00,'2022-07-04 11:36:19','',''),(916,'1','275','1',1,'Retail Sale Id 870',2298.96,0.00,0.00,3.09,191.58,'2022-07-04 11:56:35','',''),(917,'1','275','1',1,'Retail Sale Id 871',9300.00,0.00,0.00,12.50,775.00,'2022-07-04 12:07:53','',''),(918,'1','275','1',1,'Retail Sale Id 872',11160.00,0.00,0.00,15.00,930.00,'2022-07-04 12:47:17','',''),(919,'1','275','1',1,'Retail Sale Id 873',9203.28,0.00,0.00,12.37,766.94,'2022-07-04 12:48:18','',''),(920,'1','275','1',1,'Retail Sale Id 874',18600.00,0.00,0.00,25.00,1550.00,'2022-07-04 13:18:13','',''),(921,'1','275','1',1,'Retail Sale Id 875',8184.00,0.00,0.00,11.00,682.00,'2022-07-04 13:27:34','',''),(922,'1','275','1',1,'Retail Sale Id 875',8184.00,0.00,0.00,11.00,682.00,'2022-07-04 13:27:34','',''),(923,'1','275','1',1,'Retail Sale Id 876',4002.72,0.00,0.00,5.38,333.56,'2022-07-04 14:30:00','',''),(924,'1','275','1',1,'Retail Sale Id 876',4002.72,0.00,0.00,5.38,333.56,'2022-07-04 14:30:00','',''),(925,'1','275','1',1,'Retail Sale Id 877',4002.72,0.00,0.00,5.38,333.56,'2022-07-04 14:36:48','',''),(926,'1','275','1',1,'Retail Sale Id 878',9300.00,0.00,0.00,12.50,775.00,'2022-07-04 14:53:01','',''),(927,'1','275','1',1,'Retail Sale Id 879',7998.00,0.00,0.00,10.75,666.50,'2022-07-04 15:01:34','',''),(928,'1','275','1',1,'Retail Sale Id 880',4702.08,0.00,0.00,6.32,391.84,'2022-07-04 15:04:54','',''),(929,'1','275','1',1,'Retail Sale Id 881',4501.20,0.00,0.00,6.05,375.10,'2022-07-04 16:48:05','',''),(930,'1','275','1',1,'Retail Sale Id 883',9300.00,0.00,0.00,12.50,775.00,'2022-07-04 16:56:31','',''),(931,'1','275','1',1,'Retail Sale Id 884',2499.84,0.00,0.00,3.36,208.32,'2022-07-04 16:57:58','',''),(932,'1','275','1',1,'Retail Sale Id 885',4702.08,0.00,0.00,6.32,391.84,'2022-07-04 17:21:58','',''),(933,'1','275','1',1,'Retail Sale Id 886',9300.00,0.00,0.00,12.50,775.00,'2022-07-04 17:24:34','',''),(934,'1','275','1',1,'Retail Sale Id 887',2001.36,0.00,0.00,2.69,166.78,'2022-07-04 17:25:33','',''),(935,'1','275','1',1,'Retail Sale Id 888',9300.00,0.00,0.00,12.50,775.00,'2022-07-04 18:02:51','',''),(936,'1','275','1',1,'Retail Sale Id 889',4501.20,0.00,0.00,6.05,375.10,'2022-07-04 18:20:58','',''),(937,'1','275','1',1,'Retail Sale Id 890',4501.20,0.00,0.00,6.05,375.10,'2022-07-04 18:41:15','',''),(938,'1','275','1',1,'Retail Sale Id 891',9300.00,0.00,0.00,12.50,775.00,'2022-07-04 18:42:49','',''),(939,'1','275','1',1,'Retail Sale Id 892',2499.84,0.00,0.00,3.36,208.32,'2022-07-04 18:50:02','',''),(940,'1','275','1',1,'Retail Sale Id 893',27996.72,0.00,0.00,37.63,2333.06,'2022-07-04 19:30:17','',''),(941,'1','275','1',1,'Return of Retail Sale Id 893',0.00,27996.72,37.63,0.00,-2333.06,'2022-07-04 19:30:39','',''),(942,'1','275','1',1,'Retail Sale Id 894',26002.80,0.00,0.00,34.95,2166.90,'2022-07-04 19:31:09','',''),(943,'1','275','1',1,'Retail Sale Id 895',8585.76,0.00,0.00,11.54,715.48,'2022-07-04 20:05:49','',''),(944,'1','275','1',1,'Retail Sale Id 896',996.96,0.00,0.00,1.34,83.08,'2022-07-05 08:06:08','',''),(945,'1','275','1',1,'Retail Sale Id 897',4501.20,0.00,0.00,6.05,375.10,'2022-07-05 08:32:14','',''),(946,'1','275','1',1,'Retail Sale Id 897',9300.00,0.00,0.00,12.50,775.00,'2022-07-05 08:32:14','',''),(947,'1','275','1',1,'Retail Sale Id 898',37200.00,0.00,0.00,50.00,3100.00,'2022-07-05 09:13:39','',''),(948,'1','275','1',1,'Retail Sale Id 899',9300.00,0.00,0.00,12.50,775.00,'2022-07-05 09:18:48','',''),(949,'1','275','1',1,'Retail Sale Id 900',2298.96,0.00,0.00,3.09,191.58,'2022-07-05 09:26:31','',''),(950,'1','275','1',1,'Retail Sale Id 901',9300.00,0.00,0.00,12.50,775.00,'2022-07-05 09:27:42','',''),(951,'1','275','1',1,'Retail Sale Id 902',2298.96,0.00,0.00,3.09,191.58,'2022-07-05 09:41:32','',''),(952,'1','275','1',1,'Retail Sale Id 902',3720.00,0.00,0.00,5.00,310.00,'2022-07-05 09:41:32','',''),(953,'1','275','1',1,'Retail Sale Id 903',2998.32,0.00,0.00,4.03,249.86,'2022-07-05 09:54:15','',''),(954,'1','275','1',1,'Retail Sale Id 904',9300.00,0.00,0.00,12.50,775.00,'2022-07-05 10:01:37','',''),(955,'1','275','1',1,'Retail Sale Id 905',1502.88,0.00,0.00,2.02,125.24,'2022-07-05 10:42:41','',''),(956,'1','275','1',1,'Retail Sale Id 906',3496.80,0.00,0.00,4.70,291.40,'2022-07-05 10:56:06','',''),(957,'1','275','1',1,'Retail Sale Id 907',4002.72,0.00,0.00,5.38,333.56,'2022-07-05 11:33:09','',''),(958,'1','275','1',1,'Retail Sale Id 908',4999.68,0.00,0.00,6.72,416.64,'2022-07-05 11:35:51','',''),(959,'1','275','1',1,'Retail Sale Id 909',4501.20,0.00,0.00,6.05,375.10,'2022-07-05 12:40:31','',''),(960,'1','275','1',1,'Retail Sale Id 910',2298.96,0.00,0.00,3.09,191.58,'2022-07-05 12:43:14','',''),(961,'1','275','1',1,'Retail Sale Id 911',9300.00,0.00,0.00,12.50,775.00,'2022-07-05 13:53:52','',''),(962,'1','275','1',1,'Retail Sale Id 912',9300.00,0.00,0.00,12.50,775.00,'2022-07-05 13:54:38','',''),(963,'1','275','1',1,'Retail Sale Id 913',9300.00,0.00,0.00,12.50,775.00,'2022-07-05 14:12:32','',''),(964,'1','275','1',1,'Retail Sale Id 914',2001.36,0.00,0.00,2.69,166.78,'2022-07-05 14:42:03','',''),(965,'1','275','1',1,'Retail Sale Id 915',4999.68,0.00,0.00,6.72,416.64,'2022-07-05 15:08:42','',''),(966,'1','275','1',1,'Retail Sale Id 916',3720.00,0.00,0.00,5.00,310.00,'2022-07-05 15:16:35','',''),(967,'1','275','1',1,'Retail Sale Id 916',8184.00,0.00,0.00,11.00,682.00,'2022-07-05 15:16:35','',''),(968,'1','275','1',1,'Retail Sale Id 917',9300.00,0.00,0.00,12.50,775.00,'2022-07-05 15:24:04','',''),(969,'1','275','1',1,'Retail Sale Id 918',9300.00,0.00,0.00,12.50,775.00,'2022-07-05 15:38:52','',''),(970,'1','275','1',1,'Retail Sale Id 919',2001.36,0.00,0.00,2.69,166.78,'2022-07-05 15:48:24','',''),(971,'1','275','1',1,'Retail Sale Id 919',9300.00,0.00,0.00,12.50,775.00,'2022-07-05 15:48:24','',''),(972,'1','275','1',1,'Retail Sale Id 920',9002.40,0.00,0.00,12.10,750.20,'2022-07-05 16:08:45','',''),(973,'1','275','1',1,'Retail Sale Id 921',4002.72,0.00,0.00,5.38,333.56,'2022-07-05 16:16:57','',''),(974,'1','275','1',1,'Retail Sale Id 922',9300.00,0.00,0.00,12.50,775.00,'2022-07-05 16:30:07','',''),(975,'1','275','1',1,'Retail Sale Id 923',37200.00,0.00,0.00,50.00,3100.00,'2022-07-05 16:37:01','',''),(976,'1','275','1',1,'Retail Sale Id 924',9300.00,0.00,0.00,12.50,775.00,'2022-07-05 16:38:52','',''),(977,'1','275','1',1,'Retail Sale Id 925',996.96,0.00,0.00,1.34,83.08,'2022-07-05 16:53:29','',''),(978,'1','275','1',1,'Retail Sale Id 926',5952.00,0.00,0.00,8.00,496.00,'2022-07-05 17:00:54','',''),(979,'1','275','1',1,'Retail Sale Id 927',1153.20,0.00,0.00,1.55,96.10,'2022-07-05 17:27:06','',''),(980,'1','275','1',1,'Retail Sale Id 928',2298.96,0.00,0.00,3.09,191.58,'2022-07-05 17:41:34','',''),(981,'1','275','1',1,'Retail Sale Id 929',2976.00,0.00,0.00,4.00,248.00,'2022-07-05 18:35:06','',''),(982,'1','275','1',1,'Retail Sale Id 929',4464.00,0.00,0.00,6.00,372.00,'2022-07-05 18:35:06','',''),(983,'1','275','1',1,'Retail Sale Id 930',2298.96,0.00,0.00,3.09,191.58,'2022-07-05 18:47:46','',''),(984,'1','275','1',1,'Retail Sale Id 931',9300.00,0.00,0.00,12.50,775.00,'2022-07-05 18:48:43','',''),(985,'1','275','1',1,'Retail Sale Id 932',9300.00,0.00,0.00,12.50,775.00,'2022-07-05 19:06:06','',''),(986,'1','275','1',1,'Retail Sale Id 933',24998.40,0.00,0.00,33.60,2083.20,'2022-07-05 19:20:12','',''),(987,'1','275','1',1,'Retail Sale Id 934',11844.48,0.00,0.00,15.92,987.04,'2022-07-05 19:51:58','',''),(988,'1','275','1',1,'Retail Sale Id 935',9300.00,0.00,0.00,12.50,775.00,'2022-07-06 07:33:07','',''),(989,'1','275','1',1,'Retail Sale Id 936',1249.92,0.00,0.00,1.68,104.16,'2022-07-06 08:13:47','',''),(990,'1','275','1',1,'Retail Sale Id 937',9300.00,0.00,0.00,12.50,775.00,'2022-07-06 08:15:10','',''),(991,'1','275','1',1,'Retail Sale Id 939',3749.76,0.00,0.00,5.04,312.48,'2022-07-06 08:20:16','',''),(992,'1','275','1',1,'Retail Sale Id 940',7998.00,0.00,0.00,10.75,666.50,'2022-07-06 08:23:16','',''),(993,'1','275','1',1,'Retail Sale Id 941',4501.20,0.00,0.00,6.05,375.10,'2022-07-06 08:33:51','',''),(994,'1','275','1',1,'Retail Sale Id 942',9300.00,0.00,0.00,12.50,775.00,'2022-07-06 08:45:47','',''),(995,'1','275','1',1,'Retail Sale Id 943',18600.00,0.00,0.00,25.00,1550.00,'2022-07-06 09:04:41','',''),(996,'1','275','1',1,'Retail Sale Id 944',4501.20,0.00,0.00,6.05,375.10,'2022-07-06 09:17:34','',''),(997,'1','275','1',1,'Retail Sale Id 945',9300.00,0.00,0.00,12.50,775.00,'2022-07-06 09:23:56','',''),(998,'1','275','1',1,'Retail Sale Id 946',4501.20,0.00,0.00,6.05,375.10,'2022-07-06 09:30:23','',''),(999,'1','275','1',1,'Retail Sale Id 947',44640.00,0.00,0.00,60.00,3720.00,'2022-07-06 10:14:32','',''),(1000,'1','275','1',1,'Retail Sale Id 948',7440.00,0.00,0.00,10.00,620.00,'2022-07-06 10:28:19','',''),(1001,'1','275','1',1,'Retail Sale Id 949',2298.96,0.00,0.00,3.09,191.58,'2022-07-06 10:45:25','',''),(1002,'1','275','1',1,'Retail Sale Id 950',1502.88,0.00,0.00,2.02,125.24,'2022-07-06 10:52:48','',''),(1003,'1','275','1',1,'Retail Sale Id 951',996.96,0.00,0.00,1.34,83.08,'2022-07-06 11:19:06','',''),(1004,'1','275','1',1,'Retail Sale Id 952',3720.00,0.00,0.00,5.00,310.00,'2022-07-06 12:00:03','',''),(1005,'1','275','1',1,'Retail Sale Id 953',2001.36,0.00,0.00,2.69,166.78,'2022-07-06 12:42:06','',''),(1006,'1','275','1',1,'Retail Sale Id 954',9300.00,0.00,0.00,12.50,775.00,'2022-07-06 13:35:31','',''),(1007,'1','275','1',1,'Retail Sale Id 956',9300.00,0.00,0.00,12.50,775.00,'2022-07-06 13:54:40','',''),(1008,'1','275','1',1,'Retail Sale Id 957',9300.00,0.00,0.00,12.50,775.00,'2022-07-06 14:04:53','',''),(1009,'1','275','1',1,'Retail Sale Id 958',9300.00,0.00,0.00,12.50,775.00,'2022-07-06 15:16:46','',''),(1010,'1','275','1',1,'Retail Sale Id 959',22320.00,0.00,0.00,30.00,1860.00,'2022-07-06 15:32:08','',''),(1011,'1','275','1',1,'Retail Sale Id 960',2298.96,0.00,0.00,3.09,191.58,'2022-07-06 15:40:06','',''),(1012,'1','275','1',1,'Retail Sale Id 961',9300.00,0.00,0.00,12.50,775.00,'2022-07-06 16:35:37','',''),(1013,'1','275','1',1,'Retail Sale Id 962',4501.20,0.00,0.00,6.05,375.10,'2022-07-06 17:10:59','',''),(1014,'1','275','1',1,'Retail Sale Id 963',9300.00,0.00,0.00,12.50,775.00,'2022-07-06 17:17:18','',''),(1015,'1','275','1',1,'Retail Sale Id 964',1502.88,0.00,0.00,2.02,125.24,'2022-07-06 17:32:36','',''),(1016,'1','275','1',1,'Retail Sale Id 965',9300.00,0.00,0.00,12.50,775.00,'2022-07-06 17:44:36','',''),(1017,'1','275','1',1,'Retail Sale Id 966',2298.96,0.00,0.00,3.09,191.58,'2022-07-06 17:47:24','',''),(1018,'1','275','1',1,'Retail Sale Id 967',996.96,0.00,0.00,1.34,83.08,'2022-07-06 18:13:13','',''),(1019,'1','275','1',1,'Retail Sale Id 968',9300.00,0.00,0.00,12.50,775.00,'2022-07-06 18:33:50','',''),(1020,'1','275','1',1,'Retail Sale Id 969',3720.00,0.00,0.00,5.00,310.00,'2022-07-06 18:54:30','',''),(1021,'1','275','1',1,'Retail Sale Id 970',9300.00,0.00,0.00,12.50,775.00,'2022-07-06 19:01:50','',''),(1022,'1','275','1',1,'Retail Sale Id 971',2998.32,0.00,0.00,4.03,249.86,'2022-07-06 19:15:04','',''),(1023,'1','275','1',1,'Return of Retail Sale Id 967',0.00,996.96,1.34,0.00,-83.08,'2022-07-06 19:46:54','',''),(1024,'1','275','1',1,'Retail Sale Id 972',9300.00,0.00,0.00,12.50,775.00,'2022-07-07 07:42:31','',''),(1025,'1','275','1',1,'Retail Sale Id 973',2998.32,0.00,0.00,4.03,249.86,'2022-07-07 09:12:42','',''),(1026,'1','275','1',1,'Retail Sale Id 974',17484.00,0.00,0.00,23.50,1457.00,'2022-07-07 10:14:36','',''),(1027,'1','275','1',1,'Retail Sale Id 975',1502.88,0.00,0.00,2.02,125.24,'2022-07-07 10:15:32','',''),(1028,'1','275','1',1,'Retail Sale Id 976',18600.00,0.00,0.00,25.00,1550.00,'2022-07-07 10:16:30','',''),(1029,'1','275','1',1,'Retail Sale Id 977',9002.40,0.00,0.00,12.10,750.20,'2022-07-07 10:17:11','',''),(1030,'1','275','1',1,'Retail Sale Id 978',9300.00,0.00,0.00,12.50,775.00,'2022-07-07 10:17:52','',''),(1031,'1','275','1',1,'Retail Sale Id 979',13020.00,0.00,0.00,17.50,1085.00,'2022-07-07 10:53:13','',''),(1032,'1','275','1',1,'Retail Sale Id 980',9300.00,0.00,0.00,12.50,775.00,'2022-07-07 10:56:01','',''),(1033,'1','275','1',1,'Retail Sale Id 981',7998.00,0.00,0.00,10.75,666.50,'2022-07-07 11:13:48','',''),(1034,'1','275','1',1,'Retail Sale Id 982',9300.00,0.00,0.00,12.50,775.00,'2022-07-07 11:28:38','',''),(1035,'1','275','1',1,'Retail Sale Id 983',18600.00,0.00,0.00,25.00,1550.00,'2022-07-07 14:13:40','',''),(1036,'1','275','1',1,'Retail Sale Id 984',14999.04,0.00,0.00,20.16,1249.92,'2022-07-07 14:59:46','',''),(1037,'1','275','1',1,'Retail Sale Id 985',7001.04,0.00,0.00,9.41,583.42,'2022-07-07 15:01:58','',''),(1038,'1','275','1',1,'Retail Sale Id 986',9300.00,0.00,0.00,12.50,775.00,'2022-07-07 15:06:18','',''),(1039,'1','275','1',1,'Retail Sale Id 987',1502.88,0.00,0.00,2.02,125.24,'2022-07-07 15:09:46','',''),(1040,'1','275','1',1,'Retail Sale Id 988',1502.88,0.00,0.00,2.02,125.24,'2022-07-07 15:50:29','',''),(1041,'1','275','1',1,'Retail Sale Id 989',9300.00,0.00,0.00,12.50,775.00,'2022-07-07 15:53:53','',''),(1042,'1','275','1',1,'Retail Sale Id 990',5996.64,0.00,0.00,8.06,499.72,'2022-07-07 16:33:23','',''),(1043,'1','275','1',1,'Retail Sale Id 991',5996.64,0.00,0.00,8.06,499.72,'2022-07-07 16:35:22','',''),(1044,'1','275','1',1,'Retail Sale Id 992',4501.20,0.00,0.00,6.05,375.10,'2022-07-07 16:43:34','',''),(1045,'1','275','1',1,'Retail Sale Id 993',9002.40,0.00,0.00,12.10,750.20,'2022-07-07 16:59:57','',''),(1046,'1','275','1',1,'Retail Sale Id 994',9300.00,0.00,0.00,12.50,775.00,'2022-07-07 17:05:55','',''),(1047,'1','275','1',1,'Retail Sale Id 995',4501.20,0.00,0.00,6.05,375.10,'2022-07-07 17:15:03','',''),(1048,'1','275','1',1,'Retail Sale Id 996',9300.00,0.00,0.00,12.50,775.00,'2022-07-07 17:27:06','',''),(1049,'1','275','1',1,'Retail Sale Id 997',7998.00,0.00,0.00,10.75,666.50,'2022-07-07 17:28:48','',''),(1050,'1','275','1',1,'Retail Sale Id 998',2298.96,0.00,0.00,3.09,191.58,'2022-07-07 17:49:02','',''),(1051,'1','275','1',1,'Retail Sale Id 999',996.96,0.00,0.00,1.34,83.08,'2022-07-07 17:57:35','',''),(1052,'1','275','1',1,'Retail Sale Id 1000',12648.00,0.00,0.00,17.00,1054.00,'2022-07-07 18:06:51','',''),(1053,'1','275','1',1,'Retail Sale Id 1001',2998.32,0.00,0.00,4.03,249.86,'2022-07-07 18:08:54','',''),(1054,'1','275','1',1,'Retail Sale Id 1002',1502.88,0.00,0.00,2.02,125.24,'2022-07-07 18:19:38','',''),(1055,'1','275','1',1,'Retail Sale Id 1003',18600.00,0.00,0.00,25.00,1550.00,'2022-07-07 18:27:56','',''),(1056,'1','275','1',1,'Retail Sale Id 1004',9300.00,0.00,0.00,12.50,775.00,'2022-07-07 18:45:07','',''),(1057,'1','275','1',1,'Retail Sale Id 1005',2001.36,0.00,0.00,2.69,166.78,'2022-07-07 19:41:22','',''),(1058,'1','275','1',1,'Retail Sale Id 1006',2232.00,0.00,0.00,3.00,186.00,'2022-07-08 07:56:07','',''),(1059,'1','275','1',1,'Retail Sale Id 1007',996.96,0.00,0.00,1.34,83.08,'2022-07-08 07:58:09','',''),(1060,'1','275','1',1,'Retail Sale Id 1008',9002.40,0.00,0.00,12.10,750.20,'2022-07-08 08:12:40','',''),(1061,'1','275','1',1,'Retail Sale Id 1009',4501.20,0.00,0.00,6.05,375.10,'2022-07-08 08:25:13','',''),(1062,'1','275','1',1,'Retail Sale Id 1010',3720.00,0.00,0.00,5.00,310.00,'2022-07-08 08:26:38','',''),(1063,'1','275','1',1,'Retail Sale Id 1011',13020.00,0.00,0.00,17.50,1085.00,'2022-07-08 08:28:08','',''),(1064,'1','275','1',1,'Retail Sale Id 1012',9300.00,0.00,0.00,12.50,775.00,'2022-07-08 08:29:29','',''),(1065,'1','275','1',1,'Retail Sale Id 1013',9300.00,0.00,0.00,12.50,775.00,'2022-07-08 08:37:33','',''),(1066,'1','275','1',1,'Retail Sale Id 1014',9300.00,0.00,0.00,12.50,775.00,'2022-07-08 08:58:13','',''),(1067,'1','275','1',1,'Retail Sale Id 1015',1502.88,0.00,0.00,2.02,125.24,'2022-07-08 09:13:47','',''),(1068,'1','275','1',1,'Retail Sale Id 1016',9300.00,0.00,0.00,12.50,775.00,'2022-07-08 09:18:23','',''),(1069,'1','275','1',1,'Retail Sale Id 1017',4501.20,0.00,0.00,6.05,375.10,'2022-07-08 09:35:18','',''),(1070,'1','275','1',1,'Retail Sale Id 1018',3496.80,0.00,0.00,4.70,291.40,'2022-07-08 10:13:27','',''),(1071,'1','275','1',1,'Retail Sale Id 1019',2298.96,0.00,0.00,3.09,191.58,'2022-07-08 11:03:16','',''),(1072,'1','275','1',1,'Retail Sale Id 1020',9300.00,0.00,0.00,12.50,775.00,'2022-07-08 11:06:53','',''),(1073,'1','275','1',1,'Retail Sale Id 1021',9300.00,0.00,0.00,12.50,775.00,'2022-07-08 11:20:00','',''),(1074,'1','275','1',1,'Retail Sale Id 1022',1502.88,0.00,0.00,2.02,125.24,'2022-07-08 11:25:19','',''),(1075,'1','275','1',1,'Retail Sale Id 1023',9300.00,0.00,0.00,12.50,775.00,'2022-07-08 11:31:36','',''),(1076,'1','275','1',1,'Retail Sale Id 1024',9300.00,0.00,0.00,12.50,775.00,'2022-07-08 12:29:41','',''),(1077,'1','275','1',1,'Retail Sale Id 1025',10996.32,0.00,0.00,14.78,916.36,'2022-07-08 14:31:10','',''),(1078,'1','275','1',1,'Retail Sale Id 1026',2298.96,0.00,0.00,3.09,191.58,'2022-07-08 14:31:59','',''),(1079,'1','275','1',1,'Retail Sale Id 1027',9300.00,0.00,0.00,12.50,775.00,'2022-07-08 14:32:46','',''),(1080,'1','275','1',1,'Retail Sale Id 1028',17856.00,0.00,0.00,24.00,1488.00,'2022-07-08 14:33:50','',''),(1081,'1','275','1',1,'Retail Sale Id 1029',4501.20,0.00,0.00,6.05,375.10,'2022-07-08 14:48:48','',''),(1082,'1','275','1',1,'Retail Sale Id 1030',4002.72,0.00,0.00,5.38,333.56,'2022-07-08 14:49:56','',''),(1083,'1','275','1',1,'Retail Sale Id 1031',2298.96,0.00,0.00,3.09,191.58,'2022-07-08 14:58:56','',''),(1084,'1','275','1',1,'Retail Sale Id 1032',2298.96,0.00,0.00,3.09,191.58,'2022-07-08 15:00:11','',''),(1085,'1','275','1',1,'Retail Sale Id 1033',4501.20,0.00,0.00,6.05,375.10,'2022-07-08 15:13:31','',''),(1086,'1','275','1',1,'Retail Sale Id 1034',4501.20,0.00,0.00,6.05,375.10,'2022-07-08 15:14:33','',''),(1087,'1','275','1',1,'Retail Sale Id 1035',14136.00,0.00,0.00,19.00,1178.00,'2022-07-08 15:22:35','',''),(1088,'1','275','1',1,'Retail Sale Id 1036',4501.20,0.00,0.00,6.05,375.10,'2022-07-08 15:24:07','',''),(1089,'1','275','1',1,'Retail Sale Id 1037',9300.00,0.00,0.00,12.50,775.00,'2022-07-08 15:27:28','',''),(1090,'1','275','1',1,'Retail Sale Id 1038',3496.80,0.00,0.00,4.70,291.40,'2022-07-08 15:51:27','',''),(1091,'1','275','1',1,'Retail Sale Id 1039',2298.96,0.00,0.00,3.09,191.58,'2022-07-08 15:59:40','',''),(1092,'1','275','1',1,'Retail Sale Id 1040',13392.00,0.00,0.00,18.00,1116.00,'2022-07-08 16:04:08','',''),(1093,'1','275','1',1,'Retail Sale Id 1041',8928.00,0.00,0.00,12.00,744.00,'2022-07-08 16:04:52','',''),(1094,'1','275','1',1,'Retail Sale Id 1042',2298.96,0.00,0.00,3.09,191.58,'2022-07-08 16:07:05','',''),(1095,'1','275','1',1,'Retail Sale Id 1043',9300.00,0.00,0.00,12.50,775.00,'2022-07-08 16:32:58','',''),(1096,'1','275','1',1,'Retail Sale Id 1044',2298.96,0.00,0.00,3.09,191.58,'2022-07-08 16:34:29','',''),(1097,'1','275','1',1,'Retail Sale Id 1046',37200.00,0.00,0.00,50.00,3100.00,'2022-07-08 17:09:14','',''),(1098,'1','275','1',1,'Retail Sale Id 1047',9300.00,0.00,0.00,12.50,775.00,'2022-07-08 17:10:36','',''),(1099,'1','275','1',1,'Retail Sale Id 1048',3720.00,0.00,0.00,5.00,310.00,'2022-07-08 17:11:14','',''),(1100,'1','275','1',1,'Retail Sale Id 1049',9300.00,0.00,0.00,12.50,775.00,'2022-07-08 17:14:27','',''),(1101,'1','275','1',1,'Retail Sale Id 1050',46128.00,0.00,0.00,62.00,3844.00,'2022-07-08 17:16:13','',''),(1102,'1','275','1',1,'Retail Sale Id 1051',4002.72,0.00,0.00,5.38,333.56,'2022-07-08 17:32:59','',''),(1103,'1','275','1',1,'Retail Sale Id 1052',14880.00,0.00,0.00,20.00,1240.00,'2022-07-08 17:51:22','',''),(1104,'1','275','1',1,'Retail Sale Id 1053',9300.00,0.00,0.00,12.50,775.00,'2022-07-08 17:52:03','',''),(1105,'1','275','1',1,'Retail Sale Id 1054',18600.00,0.00,0.00,25.00,1550.00,'2022-07-08 18:08:33','',''),(1106,'1','275','1',1,'Retail Sale Id 1055',2998.32,0.00,0.00,4.03,249.86,'2022-07-08 18:09:26','',''),(1107,'1','275','1',1,'Retail Sale Id 1056',18600.00,0.00,0.00,25.00,1550.00,'2022-07-08 18:39:12','',''),(1108,'1','275','1',1,'Retail Sale Id 1057',4464.00,0.00,0.00,6.00,372.00,'2022-07-08 18:40:16','',''),(1109,'1','275','1',1,'Retail Sale Id 1058',2298.96,0.00,0.00,3.09,191.58,'2022-07-08 18:41:06','',''),(1110,'1','275','1',1,'Retail Sale Id 1059',11621.28,0.00,0.00,15.62,968.44,'2022-07-08 19:59:04','',''),(1111,'1','275','1',1,'Distributed to Operational lost for sales id:6',57888.16,0.00,0.00,84.88,0.00,'2022-07-09 13:04:01','',''),(1112,'1','275',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3730540.00,5470.00,0.00,0.00,'2022-07-09 14:54:24','',''),(1113,'1','275',NULL,1,'Reception corrector for bridging 6',0.00,0.00,0.00,5470.00,0.00,'2022-07-09 14:55:23','',''),(1114,'1','275','1',1,'Received from bridging 6',0.00,0.00,5470.00,0.00,0.00,'2022-07-09 14:55:23','',''),(1115,'1','275','1',1,'Retail Sale Id 1060',42408.00,0.00,0.00,57.00,3534.00,'2022-07-09 15:06:01','',''),(1116,'1','275','1',1,'Retail Sale Id 1061',9300.00,0.00,0.00,12.50,775.00,'2022-07-09 15:25:31','',''),(1117,'1','275','1',1,'Retail Sale Id 1062',4501.20,0.00,0.00,6.05,375.10,'2022-07-09 15:26:32','',''),(1118,'1','275','1',1,'Retail Sale Id 1063',996.96,0.00,0.00,1.34,83.08,'2022-07-09 15:48:40','',''),(1119,'1','275','1',1,'Retail Sale Id 1064',9002.40,0.00,0.00,12.10,750.20,'2022-07-09 16:07:33','',''),(1120,'1','275','1',1,'Retail Sale Id 1065',1502.88,0.00,0.00,2.02,125.24,'2022-07-09 16:18:09','',''),(1121,'1','275','1',1,'Retail Sale Id 1066',107463.36,0.00,0.00,144.44,8955.28,'2022-07-09 19:31:57','',''),(1122,'1','275','1',1,'Retail Sale Id 1067',37200.00,0.00,0.00,50.00,3100.00,'2022-07-10 07:11:46','',''),(1123,'1','275','1',1,'Retail Sale Id 1068',9300.00,0.00,0.00,12.50,775.00,'2022-07-10 08:09:56','',''),(1124,'1','275','1',1,'Retail Sale Id 1069',9300.00,0.00,0.00,12.50,775.00,'2022-07-10 08:26:44','',''),(1125,'1','275','1',1,'Retail Sale Id 1071',9300.00,0.00,0.00,12.50,775.00,'2022-07-10 08:30:05','',''),(1126,'1','275','1',1,'Retail Sale Id 1072',996.96,0.00,0.00,1.34,83.08,'2022-07-10 09:36:29','',''),(1127,'1','275','1',1,'Retail Sale Id 1073',4002.72,0.00,0.00,5.38,333.56,'2022-07-10 09:40:32','',''),(1128,'1','275','1',1,'Retail Sale Id 1074',9300.00,0.00,0.00,12.50,775.00,'2022-07-10 09:42:27','',''),(1129,'1','275','1',1,'Retail Sale Id 1075',3720.00,0.00,0.00,5.00,310.00,'2022-07-10 10:01:33','',''),(1130,'1','275','1',1,'Retail Sale Id 1076',18600.00,0.00,0.00,25.00,1550.00,'2022-07-10 10:14:05','',''),(1131,'1','275','1',1,'Retail Sale Id 1077',9300.00,0.00,0.00,12.50,775.00,'2022-07-10 10:25:33','',''),(1132,'1','275','1',1,'Retail Sale Id 1078',9300.00,0.00,0.00,12.50,775.00,'2022-07-10 12:15:47','',''),(1133,'1','275','1',1,'Retail Sale Id 1079',5996.64,0.00,0.00,8.06,499.72,'2022-07-10 12:17:33','',''),(1134,'1','275','1',1,'Retail Sale Id 1080',9300.00,0.00,0.00,12.50,775.00,'2022-07-10 12:19:32','',''),(1135,'1','275','1',1,'Retail Sale Id 1081',3720.00,0.00,0.00,5.00,310.00,'2022-07-10 12:39:26','',''),(1136,'1','275','1',1,'Retail Sale Id 1082',4501.20,0.00,0.00,6.05,375.10,'2022-07-10 12:40:37','',''),(1137,'1','275','1',1,'Retail Sale Id 1083',9300.00,0.00,0.00,12.50,775.00,'2022-07-10 12:42:41','',''),(1138,'1','275','1',1,'Retail Sale Id 1084',46872.00,0.00,0.00,63.00,3906.00,'2022-07-10 13:33:49','',''),(1139,'1','275','1',1,'Retail Sale Id 1085',9300.00,0.00,0.00,12.50,775.00,'2022-07-10 13:49:26','',''),(1140,'1','275','1',1,'Retail Sale Id 1086',9300.00,0.00,0.00,12.50,775.00,'2022-07-10 15:49:54','',''),(1141,'1','275','1',1,'Retail Sale Id 1087',9300.00,0.00,0.00,12.50,775.00,'2022-07-10 15:55:17','',''),(1142,'1','275','1',1,'Retail Sale Id 1088',9300.00,0.00,0.00,12.50,775.00,'2022-07-10 16:21:45','',''),(1143,'1','275','1',1,'Retail Sale Id 1089',4999.68,0.00,0.00,6.72,416.64,'2022-07-10 16:25:02','',''),(1144,'1','275','1',1,'Retail Sale Id 1090',14880.00,0.00,0.00,20.00,1240.00,'2022-07-10 16:27:42','',''),(1145,'1','275','1',1,'Retail Sale Id 1091',3801.84,0.00,0.00,5.11,316.82,'2022-07-10 16:37:39','',''),(1146,'1','275','1',1,'Retail Sale Id 1092',7001.04,0.00,0.00,9.41,583.42,'2022-07-10 16:43:24','',''),(1147,'1','275','1',1,'Retail Sale Id 1093',18600.00,0.00,0.00,25.00,1550.00,'2022-07-10 16:45:55','',''),(1148,'1','275','1',1,'Retail Sale Id 1094',9300.00,0.00,0.00,12.50,775.00,'2022-07-10 16:58:22','',''),(1149,'1','275','1',1,'Retail Sale Id 1095',2298.96,0.00,0.00,3.09,191.58,'2022-07-10 17:11:45','',''),(1150,'1','275','1',1,'Retail Sale Id 1096',9300.00,0.00,0.00,12.50,775.00,'2022-07-10 17:21:05','',''),(1151,'1','275','1',1,'Retail Sale Id 1097',2298.96,0.00,0.00,3.09,191.58,'2022-07-10 17:22:15','',''),(1152,'1','275','1',1,'Retail Sale Id 1098',3720.00,0.00,0.00,5.00,310.00,'2022-07-10 17:51:58','',''),(1153,'1','275','1',1,'Retail Sale Id 1099',29998.08,0.00,0.00,40.32,2499.84,'2022-07-10 17:57:48','',''),(1154,'1','275','1',1,'Retail Sale Id 1100',42028.56,0.00,0.00,56.49,3502.38,'2022-07-10 19:24:32','',''),(1155,'1','275','1',1,'Retail Sale Id 1101',9300.00,0.00,0.00,12.50,775.00,'2022-07-11 08:03:56','',''),(1156,'1','275','1',1,'Retail Sale Id 1102',2298.96,0.00,0.00,3.09,191.58,'2022-07-11 09:03:36','',''),(1157,'1','275','1',1,'Retail Sale Id 1103',9300.00,0.00,0.00,12.50,775.00,'2022-07-11 09:42:51','',''),(1158,'1','275','1',1,'Retail Sale Id 1104',5996.64,0.00,0.00,8.06,499.72,'2022-07-11 09:44:09','',''),(1159,'1','275','1',1,'Retail Sale Id 1105',9300.00,0.00,0.00,12.50,775.00,'2022-07-11 09:50:19','',''),(1160,'1','275','1',1,'Retail Sale Id 1106',996.96,0.00,0.00,1.34,83.08,'2022-07-11 11:42:15','',''),(1161,'1','275','1',1,'Retail Sale Id 1108',7499.52,0.00,0.00,10.08,624.96,'2022-07-11 12:36:05','',''),(1162,'1','275','1',1,'Retail Sale Id 1109',996.96,0.00,0.00,1.34,83.08,'2022-07-11 12:37:32','',''),(1163,'1','275','1',1,'Retail Sale Id 1110',4397.04,0.00,0.00,5.91,366.42,'2022-07-11 13:07:22','',''),(1164,'1','275','1',1,'Retail Sale Id 1111',9300.00,0.00,0.00,12.50,775.00,'2022-07-11 13:24:22','',''),(1165,'1','275','1',1,'Retail Sale Id 1112',2298.96,0.00,0.00,3.09,191.58,'2022-07-11 13:32:22','',''),(1166,'1','275','1',1,'Retail Sale Id 1113',11532.00,0.00,0.00,15.50,961.00,'2022-07-11 13:39:05','',''),(1167,'1','275','1',1,'Retail Sale Id 1114',99919.20,0.00,0.00,134.30,8326.60,'2022-07-11 20:01:16','',''),(1168,'1','275','1',1,'Retail Sale Id 1115',9300.00,0.00,0.00,12.50,775.00,'2022-07-12 07:36:48','',''),(1169,'1','275','1',1,'Retail Sale Id 1116',9300.00,0.00,0.00,12.50,775.00,'2022-07-12 07:46:27','',''),(1170,'1','275','1',1,'Retail Sale Id 1117',18600.00,0.00,0.00,25.00,1550.00,'2022-07-12 08:55:27','',''),(1171,'1','275','1',1,'Retail Sale Id 1118',9300.00,0.00,0.00,12.50,775.00,'2022-07-12 09:20:17','',''),(1172,'1','275','1',1,'Retail Sale Id 1119',996.96,0.00,0.00,1.34,83.08,'2022-07-12 09:21:10','',''),(1173,'1','275','1',1,'Retail Sale Id 1120',4002.72,0.00,0.00,5.38,333.56,'2022-07-12 09:22:19','',''),(1174,'1','275','1',1,'Retail Sale Id 1121',18600.00,0.00,0.00,25.00,1550.00,'2022-07-12 09:34:29','',''),(1175,'1','275','1',1,'Retail Sale Id 1122',9300.00,0.00,0.00,12.50,775.00,'2022-07-12 09:42:43','',''),(1176,'1','275','1',1,'Retail Sale Id 1123',9300.00,0.00,0.00,12.50,775.00,'2022-07-12 10:49:40','',''),(1177,'1','275','1',1,'Retail Sale Id 1124',4501.20,0.00,0.00,6.05,375.10,'2022-07-12 11:14:44','',''),(1178,'1','275','1',1,'Retail Sale Id 1125',2298.96,0.00,0.00,3.09,191.58,'2022-07-12 11:36:58','',''),(1179,'1','275','1',1,'Retail Sale Id 1126',2001.36,0.00,0.00,2.69,166.78,'2022-07-12 11:56:04','',''),(1180,'1','275','1',1,'Retail Sale Id 1127',9300.00,0.00,0.00,12.50,775.00,'2022-07-12 12:09:38','',''),(1181,'1','275','1',1,'Retail Sale Id 1128',1502.88,0.00,0.00,2.02,125.24,'2022-07-12 13:09:53','',''),(1182,'1','275','1',1,'Retail Sale Id 1129',4501.20,0.00,0.00,6.05,375.10,'2022-07-12 15:00:36','',''),(1183,'1','275','1',1,'Retail Sale Id 1130',2998.32,0.00,0.00,4.03,249.86,'2022-07-12 15:53:10','',''),(1184,'1','275','1',1,'Retail Sale Id 1131',9300.00,0.00,0.00,12.50,775.00,'2022-07-12 16:10:16','',''),(1185,'1','275','1',1,'Retail Sale Id 1132',2001.36,0.00,0.00,2.69,166.78,'2022-07-12 16:24:42','',''),(1186,'1','275','1',1,'Retail Sale Id 1133',2298.96,0.00,0.00,3.09,191.58,'2022-07-12 16:26:34','',''),(1187,'1','275','1',1,'Retail Sale Id 1134',9300.00,0.00,0.00,12.50,775.00,'2022-07-12 16:30:54','',''),(1188,'1','275','1',1,'Retail Sale Id 1135',7499.52,0.00,0.00,10.08,624.96,'2022-07-12 16:39:12','',''),(1189,'1','275','1',1,'Retail Sale Id 1136',1860.00,0.00,0.00,2.50,155.00,'2022-07-12 16:48:41','',''),(1190,'1','275','1',1,'Retail Sale Id 1137',4501.20,0.00,0.00,6.05,375.10,'2022-07-12 16:53:16','',''),(1191,'1','275','1',1,'Retail Sale Id 1138',4501.20,0.00,0.00,6.05,375.10,'2022-07-12 16:58:04','',''),(1192,'1','275','1',1,'Retail Sale Id 1139',4501.20,0.00,0.00,6.05,375.10,'2022-07-12 17:08:04','',''),(1193,'1','275','1',1,'Retail Sale Id 1140',9300.00,0.00,0.00,12.50,775.00,'2022-07-12 17:20:19','',''),(1194,'1','275','1',1,'Retail Sale Id 1141',9300.00,0.00,0.00,12.50,775.00,'2022-07-12 17:21:10','',''),(1195,'1','275','1',1,'Retail Sale Id 1142',1502.88,0.00,0.00,2.02,125.24,'2022-07-12 17:38:49','',''),(1196,'1','275','1',1,'Retail Sale Id 1144',7998.00,0.00,0.00,10.75,666.50,'2022-07-12 17:44:05','',''),(1197,'1','275','1',1,'Retail Sale Id 1145',2499.84,0.00,0.00,3.36,208.32,'2022-07-12 17:54:01','',''),(1198,'1','275','1',1,'Retail Sale Id 1146',63359.04,0.00,0.00,85.16,5279.92,'2022-07-12 19:20:16','',''),(1199,'1','275','1',1,'Retail Sale Id 1147',3496.80,0.00,0.00,4.70,291.40,'2022-07-13 08:03:54','',''),(1200,'1','275','1',1,'Retail Sale Id 1148',1502.88,0.00,0.00,2.02,125.24,'2022-07-13 08:45:08','',''),(1201,'1','275','1',1,'Retail Sale Id 1149',37296.72,0.00,0.00,50.13,3108.06,'2022-07-13 09:08:10','',''),(1202,'1','275','1',1,'Retail Sale Id 1150',4002.72,0.00,0.00,5.38,333.56,'2022-07-13 09:57:33','',''),(1203,'1','275','1',1,'Retail Sale Id 1151',2001.36,0.00,0.00,2.69,166.78,'2022-07-13 09:58:11','',''),(1204,'1','275','1',1,'Retail Sale Id 1152',4999.68,0.00,0.00,6.72,416.64,'2022-07-13 12:37:42','',''),(1205,'1','275','1',1,'Retail Sale Id 1153',18600.00,0.00,0.00,25.00,1550.00,'2022-07-13 17:24:40','',''),(1206,'1','275','1',1,'Retail Sale Id 1154',2246.88,0.00,0.00,3.02,187.24,'2022-07-13 17:26:56','',''),(1207,'1','275','1',1,'Retail Sale Id 1155',3720.00,0.00,0.00,5.00,310.00,'2022-07-13 17:27:43','',''),(1208,'1','275','1',1,'Retail Sale Id 1156',2298.96,0.00,0.00,3.09,191.58,'2022-07-13 17:29:32','',''),(1209,'1','275','1',1,'Retail Sale Id 1157',1502.88,0.00,0.00,2.02,125.24,'2022-07-13 17:30:32','',''),(1210,'1','275','1',1,'Retail Sale Id 1158',18600.00,0.00,0.00,25.00,1550.00,'2022-07-13 17:41:10','',''),(1211,'1','275','1',1,'Retail Sale Id 1159',3720.00,0.00,0.00,5.00,310.00,'2022-07-13 18:07:40','',''),(1212,'1','275','1',1,'Retail Sale Id 1160',1502.88,0.00,0.00,2.02,125.24,'2022-07-13 18:16:12','',''),(1213,'1','275','1',1,'Retail Sale Id 1161',29998.08,0.00,0.00,40.32,2499.84,'2022-07-13 18:18:54','',''),(1214,'1','275','1',1,'Retail Sale Id 1162',4501.20,0.00,0.00,6.05,375.10,'2022-07-13 18:24:28','',''),(1215,'1','275','1',1,'Retail Sale Id 1163',2499.84,0.00,0.00,3.36,208.32,'2022-07-13 18:25:18','',''),(1216,'1','275','1',1,'Retail Sale Id 1164',9300.00,0.00,0.00,12.50,775.00,'2022-07-13 18:43:55','',''),(1217,'1','275','1',1,'Retail Sale Id 1165',29760.00,0.00,0.00,40.00,2480.00,'2022-07-13 19:02:28','',''),(1218,'1','275','1',1,'Retail Sale Id 1166',140638.32,0.00,0.00,189.03,11719.86,'2022-07-13 19:48:47','',''),(1219,'1','275','1',1,'Retail Sale Id 1167',2298.96,0.00,0.00,3.09,191.58,'2022-07-14 07:12:07','',''),(1220,'1','275','1',1,'Retail Sale Id 1168',7998.00,0.00,0.00,10.75,666.50,'2022-07-14 08:15:41','',''),(1221,'1','275','1',1,'Retail Sale Id 1169',2298.96,0.00,0.00,3.09,191.58,'2022-07-14 08:17:00','',''),(1222,'1','275','1',1,'Retail Sale Id 1170',4999.68,0.00,0.00,6.72,416.64,'2022-07-14 08:18:37','',''),(1223,'1','275','1',1,'Retail Sale Id 1171',2298.96,0.00,0.00,3.09,191.58,'2022-07-14 08:20:37','',''),(1224,'1','275','1',1,'Retail Sale Id 1172',2998.32,0.00,0.00,4.03,249.86,'2022-07-14 08:39:51','',''),(1225,'1','275','1',1,'Retail Sale Id 1173',9300.00,0.00,0.00,12.50,775.00,'2022-07-14 08:56:19','',''),(1226,'1','275','1',1,'Retail Sale Id 1174',9300.00,0.00,0.00,12.50,775.00,'2022-07-14 09:15:52','',''),(1227,'1','275','1',1,'Retail Sale Id 1174',18600.00,0.00,0.00,25.00,1550.00,'2022-07-14 09:15:52','',''),(1228,'1','275','1',1,'Retail Sale Id 1175',37200.00,0.00,0.00,50.00,3100.00,'2022-07-14 10:45:10','',''),(1229,'1','275','1',1,'Retail Sale Id 1176',803.52,0.00,0.00,1.08,66.96,'2022-07-14 10:46:59','',''),(1230,'1','275','1',1,'Retail Sale Id 1177',1502.88,0.00,0.00,2.02,125.24,'2022-07-14 12:06:45','',''),(1231,'1','275','1',1,'Retail Sale Id 1178',1502.88,0.00,0.00,2.02,125.24,'2022-07-14 16:31:11','',''),(1232,'1','275','1',1,'Retail Sale Id 1179',181580.64,0.00,0.00,244.06,15131.72,'2022-07-14 20:00:27','',''),(1233,'1','275','1',1,'Retail Sale Id 1180',34997.76,0.00,0.00,47.04,2916.48,'2022-07-15 07:30:05','',''),(1234,'1','275','1',1,'Retail Sale Id 1181',9300.00,0.00,0.00,12.50,775.00,'2022-07-15 08:06:19','',''),(1235,'1','275','1',1,'Retail Sale Id 1182',9300.00,0.00,0.00,12.50,775.00,'2022-07-15 16:41:43','',''),(1236,'1','275','1',1,'Retail Sale Id 1183',31999.44,0.00,0.00,43.01,2666.62,'2022-07-15 16:48:00','',''),(1237,'1','275','1',1,'Retail Sale Id 1184',9300.00,0.00,0.00,12.50,775.00,'2022-07-15 16:53:33','',''),(1238,'1','275','1',1,'Retail Sale Id 1185',3720.00,0.00,0.00,5.00,310.00,'2022-07-15 17:41:14','',''),(1239,'1','275','1',1,'Retail Sale Id 1186',9300.00,0.00,0.00,12.50,775.00,'2022-07-15 17:53:38','',''),(1240,'1','275','1',1,'Retail Sale Id 1187',996.96,0.00,0.00,1.34,83.08,'2022-07-15 17:54:34','',''),(1241,'1','275','1',1,'Retail Sale Id 1188',240312.00,0.00,0.00,323.00,20026.00,'2022-07-15 20:03:37','',''),(1242,'1','275','1',1,'Retail Sale Id 1189',9300.00,0.00,0.00,12.50,775.00,'2022-07-16 08:24:51','',''),(1243,'1','275','1',1,'Retail Sale Id 1190',4597.92,0.00,0.00,6.18,383.16,'2022-07-16 09:05:11','',''),(1244,'1','275','1',1,'Retail Sale Id 1191',6502.56,0.00,0.00,8.74,541.88,'2022-07-16 09:18:51','',''),(1245,'1','275','1',1,'Retail Sale Id 1192',9300.00,0.00,0.00,12.50,775.00,'2022-07-16 09:28:56','',''),(1246,'1','275','1',1,'Retail Sale Id 1193',2232.00,0.00,0.00,3.00,186.00,'2022-07-16 11:11:35','',''),(1247,'1','275','1',1,'Retail Sale Id 1194',37200.00,0.00,0.00,50.00,3100.00,'2022-07-16 11:35:44','',''),(1248,'1','275','1',1,'Retail Sale Id 1195',2298.96,0.00,0.00,3.09,191.58,'2022-07-16 11:40:57','',''),(1249,'1','275','1',1,'Retail Sale Id 1196',9300.00,0.00,0.00,12.50,775.00,'2022-07-16 11:56:34','',''),(1250,'1','275','1',1,'Retail Sale Id 1197',13801.20,0.00,0.00,18.55,1150.10,'2022-07-16 12:01:20','',''),(1251,'1','275','1',1,'Retail Sale Id 1198',3720.00,0.00,0.00,5.00,310.00,'2022-07-16 12:07:03','',''),(1252,'1','275','1',1,'Retail Sale Id 1199',2298.96,0.00,0.00,3.09,191.58,'2022-07-16 12:33:18','',''),(1253,'1','275','1',1,'Retail Sale Id 1200',14880.00,0.00,0.00,20.00,1240.00,'2022-07-16 13:04:16','',''),(1254,'1','275','1',1,'Retail Sale Id 1201',9300.00,0.00,0.00,12.50,775.00,'2022-07-16 13:23:21','',''),(1255,'1','275','1',1,'Retail Sale Id 1202',2298.96,0.00,0.00,3.09,191.58,'2022-07-16 14:47:55','',''),(1256,'1','275','1',1,'Retail Sale Id 1203',2001.36,0.00,0.00,2.69,166.78,'2022-07-16 14:51:21','',''),(1257,'1','275','1',1,'Retail Sale Id 1204',27900.00,0.00,0.00,37.50,2325.00,'2022-07-16 15:42:51','',''),(1258,'1','275','1',1,'Retail Sale Id 1205',9300.00,0.00,0.00,12.50,775.00,'2022-07-16 15:47:45','',''),(1259,'1','275','1',1,'Retail Sale Id 1206',4501.20,0.00,0.00,6.05,375.10,'2022-07-16 15:48:55','',''),(1260,'1','275','1',1,'Retail Sale Id 1207',9300.00,0.00,0.00,12.50,775.00,'2022-07-16 16:19:08','',''),(1261,'1','275','1',1,'Retail Sale Id 1208',9300.00,0.00,0.00,12.50,775.00,'2022-07-16 16:43:32','',''),(1262,'1','275','1',1,'Retail Sale Id 1209',9300.00,0.00,0.00,12.50,775.00,'2022-07-16 18:07:20','',''),(1263,'1','275','1',1,'Retail Sale Id 1210',74400.00,0.00,0.00,100.00,6200.00,'2022-07-16 19:44:23','',''),(1264,'1','275','1',1,'Retail Sale Id 1211',40116.48,0.00,0.00,53.92,3343.04,'2022-07-16 19:45:38','',''),(1265,'1','275','1',1,'Retail Sale Id 1212',17112.00,0.00,0.00,23.00,1426.00,'2022-07-17 07:47:44','',''),(1266,'1','275','1',1,'Retail Sale Id 1213',7998.00,0.00,0.00,10.75,666.50,'2022-07-17 07:50:01','',''),(1267,'1','275','1',1,'Retail Sale Id 1214',2001.36,0.00,0.00,2.69,166.78,'2022-07-17 08:10:25','',''),(1268,'1','275','1',1,'Retail Sale Id 1215',9300.00,0.00,0.00,12.50,775.00,'2022-07-17 08:14:09','',''),(1269,'1','275','1',1,'Retail Sale Id 1216',2998.32,0.00,0.00,4.03,249.86,'2022-07-17 08:15:34','',''),(1270,'1','275','1',1,'Retail Sale Id 1217',996.96,0.00,0.00,1.34,83.08,'2022-07-17 08:16:31','',''),(1271,'1','275','1',1,'Retail Sale Id 1218',34997.76,0.00,0.00,47.04,2916.48,'2022-07-17 08:23:17','',''),(1272,'1','275','1',1,'Retail Sale Id 1219',4999.68,0.00,0.00,6.72,416.64,'2022-07-17 08:33:56','',''),(1273,'1','275','1',1,'Retail Sale Id 1220',9300.00,0.00,0.00,12.50,775.00,'2022-07-17 09:00:31','',''),(1274,'1','275','1',1,'Retail Sale Id 1221',34997.76,0.00,0.00,47.04,2916.48,'2022-07-17 10:08:11','',''),(1275,'1','275','1',1,'Retail Sale Id 1222',74400.00,0.00,0.00,100.00,6200.00,'2022-07-17 10:22:35','',''),(1276,'1','275','1',1,'Retail Sale Id 1223',4501.20,0.00,0.00,6.05,375.10,'2022-07-17 10:27:55','',''),(1277,'1','275','1',1,'Retail Sale Id 1224',9300.00,0.00,0.00,12.50,775.00,'2022-07-17 10:32:55','',''),(1278,'1','275','1',1,'Retail Sale Id 1225',4501.20,0.00,0.00,6.05,375.10,'2022-07-17 10:52:02','',''),(1279,'1','275','1',1,'Retail Sale Id 1226',5996.64,0.00,0.00,8.06,499.72,'2022-07-17 10:53:36','',''),(1280,'1','275','1',1,'Retail Sale Id 1226',9002.40,0.00,0.00,12.10,750.20,'2022-07-17 10:53:36','',''),(1281,'1','275','1',1,'Retail Sale Id 1227',13764.00,0.00,0.00,18.50,1147.00,'2022-07-17 11:48:25','',''),(1282,'1','275','1',1,'Retail Sale Id 1228',9300.00,0.00,0.00,12.50,775.00,'2022-07-17 12:25:43','',''),(1283,'1','275','1',1,'Retail Sale Id 1229',9300.00,0.00,0.00,12.50,775.00,'2022-07-17 12:34:23','',''),(1284,'1','275','1',1,'Retail Sale Id 1230',34997.76,0.00,0.00,47.04,2916.48,'2022-07-17 12:35:09','',''),(1285,'1','275','1',1,'Retail Sale Id 1231',2499.84,0.00,0.00,3.36,208.32,'2022-07-17 12:44:09','',''),(1286,'1','275','1',1,'Retail Sale Id 1232',18600.00,0.00,0.00,25.00,1550.00,'2022-07-17 12:53:00','',''),(1287,'1','275','1',1,'Retail Sale Id 1233',34997.76,0.00,0.00,47.04,2916.48,'2022-07-17 12:56:28','',''),(1288,'1','275','1',1,'Retail Sale Id 1234',3720.00,0.00,0.00,5.00,310.00,'2022-07-17 13:22:03','',''),(1289,'1','275','1',1,'Retail Sale Id 1235',17498.88,0.00,0.00,23.52,1458.24,'2022-07-17 13:25:21','',''),(1290,'1','275','1',1,'Retail Sale Id 1236',9300.00,0.00,0.00,12.50,775.00,'2022-07-17 13:32:35','',''),(1291,'1','275','1',1,'Retail Sale Id 1237',9300.00,0.00,0.00,12.50,775.00,'2022-07-17 13:39:41','',''),(1292,'1','275','1',1,'Retail Sale Id 1238',18600.00,0.00,0.00,25.00,1550.00,'2022-07-17 13:41:21','',''),(1293,'1','275','1',1,'Retail Sale Id 1239',9999.36,0.00,0.00,13.44,833.28,'2022-07-17 13:51:05','',''),(1294,'1','275','1',1,'Retail Sale Id 1240',4501.20,0.00,0.00,6.05,375.10,'2022-07-17 13:51:57','',''),(1295,'1','275','1',1,'Retail Sale Id 1241',5208.00,0.00,0.00,7.00,434.00,'2022-07-17 13:53:58','',''),(1296,'1','275','1',1,'Retail Sale Id 1242',2998.32,0.00,0.00,4.03,249.86,'2022-07-17 14:13:38','',''),(1297,'1','275','1',1,'Retail Sale Id 1243',2998.32,0.00,0.00,4.03,249.86,'2022-07-17 14:15:04','',''),(1298,'1','275','1',1,'Retail Sale Id 1244',7001.04,0.00,0.00,9.41,583.42,'2022-07-17 14:18:06','',''),(1299,'1','275','1',1,'Retail Sale Id 1245',9002.40,0.00,0.00,12.10,750.20,'2022-07-17 14:28:05','',''),(1300,'1','275','1',1,'Retail Sale Id 1246',4501.20,0.00,0.00,6.05,375.10,'2022-07-17 14:28:57','',''),(1301,'1','275','1',1,'Retail Sale Id 1247',27900.00,0.00,0.00,37.50,2325.00,'2022-07-17 14:36:56','',''),(1302,'1','275','1',1,'Retail Sale Id 1248',4501.20,0.00,0.00,6.05,375.10,'2022-07-17 15:07:57','',''),(1303,'1','275','1',1,'Retail Sale Id 1249',12000.72,0.00,0.00,16.13,1000.06,'2022-07-17 15:30:10','',''),(1304,'1','275','1',1,'Retail Sale Id 1250',49996.80,0.00,0.00,67.20,4166.40,'2022-07-17 15:39:15','',''),(1305,'1','275','1',1,'Retail Sale Id 1251',34997.76,0.00,0.00,47.04,2916.48,'2022-07-17 15:43:18','',''),(1306,'1','275','1',1,'Retail Sale Id 1252',2998.32,0.00,0.00,4.03,249.86,'2022-07-17 16:00:59','',''),(1307,'1','275','1',1,'Retail Sale Id 1253',2998.32,0.00,0.00,4.03,249.86,'2022-07-17 16:12:55','',''),(1308,'1','275','1',1,'Retail Sale Id 1254',1502.88,0.00,0.00,2.02,125.24,'2022-07-17 16:23:25','',''),(1309,'1','275','1',1,'Retail Sale Id 1255',2298.96,0.00,0.00,3.09,191.58,'2022-07-17 17:08:48','',''),(1310,'1','275','1',1,'Retail Sale Id 1256',37200.00,0.00,0.00,50.00,3100.00,'2022-07-17 17:11:04','',''),(1311,'1','275','1',1,'Retail Sale Id 1257',18600.00,0.00,0.00,25.00,1550.00,'2022-07-17 18:10:07','',''),(1312,'1','275','1',1,'Retail Sale Id 1258',18600.00,0.00,0.00,25.00,1550.00,'2022-07-17 18:14:58','',''),(1313,'1','275','1',1,'Retail Sale Id 1259',2499.84,0.00,0.00,3.36,208.32,'2022-07-17 18:59:29','',''),(1314,'1','275','1',1,'Retail Sale Id 1260',9300.00,0.00,0.00,12.50,775.00,'2022-07-17 19:01:03','',''),(1315,'1','275','1',1,'Retail Sale Id 1261',21561.12,0.00,0.00,28.98,1796.76,'2022-07-17 19:26:56','',''),(1316,'1','275','1',1,'Retail Sale Id 1262',2001.36,0.00,0.00,2.69,166.78,'2022-07-18 07:25:19','',''),(1317,'1','275','1',1,'Retail Sale Id 1263',5996.64,0.00,0.00,8.06,499.72,'2022-07-18 07:33:17','',''),(1318,'1','275','1',1,'Retail Sale Id 1264',9300.00,0.00,0.00,12.50,775.00,'2022-07-18 08:02:03','',''),(1319,'1','275','1',1,'Retail Sale Id 1265',9300.00,0.00,0.00,12.50,775.00,'2022-07-18 08:19:03','',''),(1320,'1','275','1',1,'Retail Sale Id 1266',2298.96,0.00,0.00,3.09,191.58,'2022-07-18 08:20:52','',''),(1321,'1','275','1',1,'Retail Sale Id 1267',18600.00,0.00,0.00,25.00,1550.00,'2022-07-18 09:36:15','',''),(1322,'1','275','1',1,'Retail Sale Id 1268',9300.00,0.00,0.00,12.50,775.00,'2022-07-18 09:43:41','',''),(1323,'1','275','1',1,'Retail Sale Id 1269',9300.00,0.00,0.00,12.50,775.00,'2022-07-18 10:38:07','',''),(1324,'1','275','1',1,'Retail Sale Id 1270',9300.00,0.00,0.00,12.50,775.00,'2022-07-18 13:58:42','',''),(1325,'1','275','1',1,'Retail Sale Id 1271',11532.00,0.00,0.00,15.50,961.00,'2022-07-18 14:22:44','',''),(1326,'1','275','1',1,'Retail Sale Id 1272',4597.92,0.00,0.00,6.18,383.16,'2022-07-18 15:00:34','',''),(1327,'1','275','1',1,'Retail Sale Id 1273',9300.00,0.00,0.00,12.50,775.00,'2022-07-18 15:20:44','',''),(1328,'1','275','1',1,'Retail Sale Id 1274',9300.00,0.00,0.00,12.50,775.00,'2022-07-18 15:43:57','',''),(1329,'1','275','1',1,'Retail Sale Id 1275',37200.00,0.00,0.00,50.00,3100.00,'2022-07-18 15:49:03','',''),(1330,'1','275','1',1,'Retail Sale Id 1276',4999.68,0.00,0.00,6.72,416.64,'2022-07-18 16:00:31','',''),(1331,'1','275','1',1,'Retail Sale Id 1277',9300.00,0.00,0.00,12.50,775.00,'2022-07-18 16:29:33','',''),(1332,'1','275','1',1,'Retail Sale Id 1278',9300.00,0.00,0.00,12.50,775.00,'2022-07-18 16:34:47','',''),(1333,'1','275','1',1,'Retail Sale Id 1279',9300.00,0.00,0.00,12.50,775.00,'2022-07-18 16:54:09','',''),(1334,'1','275','1',1,'Retail Sale Id 1280',4501.20,0.00,0.00,6.05,375.10,'2022-07-18 17:00:11','',''),(1335,'1','275','1',1,'Retail Sale Id 1281',4501.20,0.00,0.00,6.05,375.10,'2022-07-18 17:05:07','',''),(1336,'1','275','1',1,'Retail Sale Id 1282',9300.00,0.00,0.00,12.50,775.00,'2022-07-18 17:16:23','',''),(1337,'1','275','1',1,'Retail Sale Id 1283',4501.20,0.00,0.00,6.05,375.10,'2022-07-18 17:36:40','',''),(1338,'1','275','1',1,'Retail Sale Id 1284',1502.88,0.00,0.00,2.02,125.24,'2022-07-18 17:38:17','',''),(1339,'1','275','1',1,'Retail Sale Id 1285',9300.00,0.00,0.00,12.50,775.00,'2022-07-18 18:05:17','',''),(1340,'1','275','1',1,'Retail Sale Id 1286',2001.36,0.00,0.00,2.69,166.78,'2022-07-18 18:19:45','',''),(1341,'1','275','1',1,'Retail Sale Id 1287',1502.88,0.00,0.00,2.02,125.24,'2022-07-18 18:21:38','',''),(1342,'1','275','1',1,'Retail Sale Id 1288',2998.32,0.00,0.00,4.03,249.86,'2022-07-18 18:27:33','',''),(1343,'1','275','1',1,'Retail Sale Id 1289',77599.20,0.00,0.00,104.30,6466.60,'2022-07-18 19:39:26','',''),(1344,'1','275','1',1,'Retail Sale Id 1290',11197.20,0.00,0.00,15.05,933.10,'2022-07-19 07:23:37','',''),(1345,'1','275','1',1,'Retail Sale Id 1291',9300.00,0.00,0.00,12.50,775.00,'2022-07-19 07:41:21','',''),(1346,'1','275','1',1,'Retail Sale Id 1292',9300.00,0.00,0.00,12.50,775.00,'2022-07-19 07:46:18','',''),(1347,'1','275','1',1,'Retail Sale Id 1293',1502.88,0.00,0.00,2.02,125.24,'2022-07-19 07:48:03','',''),(1348,'1','275','1',1,'Retail Sale Id 1294',2298.96,0.00,0.00,3.09,191.58,'2022-07-19 07:54:05','',''),(1349,'1','275','1',1,'Retail Sale Id 1295',2998.32,0.00,0.00,4.03,249.86,'2022-07-19 08:09:26','',''),(1350,'1','275','1',1,'Retail Sale Id 1295',5996.64,0.00,0.00,8.06,499.72,'2022-07-19 08:09:26','',''),(1351,'1','275','1',1,'Retail Sale Id 1296',9300.00,0.00,0.00,12.50,775.00,'2022-07-19 08:10:29','',''),(1352,'1','275','1',1,'Retail Sale Id 1297',27900.00,0.00,0.00,37.50,2325.00,'2022-07-19 08:18:27','',''),(1353,'1','275','1',1,'Retail Sale Id 1298',2998.32,0.00,0.00,4.03,249.86,'2022-07-19 08:39:23','',''),(1354,'1','275','1',1,'Retail Sale Id 1299',9300.00,0.00,0.00,12.50,775.00,'2022-07-19 08:44:54','',''),(1355,'1','275','1',1,'Retail Sale Id 1300',9300.00,0.00,0.00,12.50,775.00,'2022-07-19 08:51:11','',''),(1356,'1','275','1',1,'Retail Sale Id 1301',9300.00,0.00,0.00,12.50,775.00,'2022-07-19 09:16:44','',''),(1357,'1','275','1',1,'Retail Sale Id 1302',2001.36,0.00,0.00,2.69,166.78,'2022-07-19 09:29:45','',''),(1358,'1','275','1',1,'Retail Sale Id 1303',4501.20,0.00,0.00,6.05,375.10,'2022-07-19 09:50:56','',''),(1359,'1','275','1',1,'Retail Sale Id 1304',9300.00,0.00,0.00,12.50,775.00,'2022-07-19 10:29:57','',''),(1360,'1','275','1',1,'Retail Sale Id 1305',9300.00,0.00,0.00,12.50,775.00,'2022-07-19 10:37:40','',''),(1361,'1','275','1',1,'Retail Sale Id 1306',1800.48,0.00,0.00,2.42,150.04,'2022-07-19 10:46:48','',''),(1362,'1','275','1',1,'Retail Sale Id 1307',996.96,0.00,0.00,1.34,83.08,'2022-07-19 10:50:09','',''),(1363,'1','275','1',1,'Retail Sale Id 1308',9300.00,0.00,0.00,12.50,775.00,'2022-07-19 11:40:15','',''),(1364,'1','275','1',1,'Retail Sale Id 1309',9300.00,0.00,0.00,12.50,775.00,'2022-07-19 11:52:02','',''),(1365,'1','275','1',1,'Retail Sale Id 1310',9300.00,0.00,0.00,12.50,775.00,'2022-07-19 11:53:36','',''),(1366,'1','275','1',1,'Retail Sale Id 1311',3720.00,0.00,0.00,5.00,310.00,'2022-07-19 12:07:44','',''),(1367,'1','275','1',1,'Retail Sale Id 1312',1502.88,0.00,0.00,2.02,125.24,'2022-07-19 12:50:03','',''),(1368,'1','275','1',1,'Retail Sale Id 1313',4501.20,0.00,0.00,6.05,375.10,'2022-07-19 13:02:07','',''),(1369,'1','275','1',1,'Retail Sale Id 1314',8496.48,0.00,0.00,11.42,708.04,'2022-07-19 14:21:12','',''),(1370,'1','275','1',1,'Retail Sale Id 1315',9300.00,0.00,0.00,12.50,775.00,'2022-07-19 14:29:25','',''),(1371,'1','275','1',1,'Retail Sale Id 1316',4501.20,0.00,0.00,6.05,375.10,'2022-07-19 14:39:45','',''),(1372,'1','275','1',1,'Retail Sale Id 1317',9300.00,0.00,0.00,12.50,775.00,'2022-07-19 14:47:43','',''),(1373,'1','275','1',1,'Retail Sale Id 1318',996.96,0.00,0.00,1.34,83.08,'2022-07-19 15:57:54','',''),(1374,'1','275','1',1,'Retail Sale Id 1319',1502.88,0.00,0.00,2.02,125.24,'2022-07-19 15:59:06','',''),(1375,'1','275','1',1,'Retail Sale Id 1320',3720.00,0.00,0.00,5.00,310.00,'2022-07-19 16:25:19','',''),(1376,'1','275','1',1,'Retail Sale Id 1320',9300.00,0.00,0.00,12.50,775.00,'2022-07-19 16:25:19','',''),(1377,'1','275','1',1,'Retail Sale Id 1321',7998.00,0.00,0.00,10.75,666.50,'2022-07-19 16:27:51','',''),(1378,'1','275','1',1,'Retail Sale Id 1321',7998.00,0.00,0.00,10.75,666.50,'2022-07-19 16:27:51','',''),(1379,'1','275','1',1,'Retail Sale Id 1322',4501.20,0.00,0.00,6.05,375.10,'2022-07-19 16:29:47','',''),(1380,'1','275','1',1,'Retail Sale Id 1324',1502.88,0.00,0.00,2.02,125.24,'2022-07-19 16:56:17','',''),(1381,'1','275','1',1,'Retail Sale Id 1325',1502.88,0.00,0.00,2.02,125.24,'2022-07-19 17:32:58','',''),(1382,'1','275','1',1,'Retail Sale Id 1326',4999.68,0.00,0.00,6.72,416.64,'2022-07-19 17:34:00','',''),(1383,'1','275','1',1,'Retail Sale Id 1327',1532.64,0.00,0.00,2.06,127.72,'2022-07-19 17:46:54','',''),(1384,'1','275','1',1,'Retail Sale Id 1327',3720.00,0.00,0.00,5.00,310.00,'2022-07-19 17:46:54','',''),(1385,'1','275','1',1,'Retail Sale Id 1329',3720.00,0.00,0.00,5.00,310.00,'2022-07-19 17:51:46','',''),(1386,'1','275','1',1,'Retail Sale Id 1330',3720.00,0.00,0.00,5.00,310.00,'2022-07-19 17:57:43','',''),(1387,'1','275','1',1,'Retail Sale Id 1331',35600.00,0.00,0.00,50.00,1500.00,'2022-07-19 18:04:09','',''),(1388,'1','275','1',1,'Retail Sale Id 1332',35600.00,0.00,0.00,50.00,1500.00,'2022-07-19 18:05:00','',''),(1389,'1','275','1',1,'Retail Sale Id 1333',996.96,0.00,0.00,1.34,83.08,'2022-07-19 18:12:14','',''),(1390,'1','275','1',1,'Retail Sale Id 1334',25632.00,0.00,0.00,36.00,1080.00,'2022-07-19 18:23:41','',''),(1391,'1','275','1',1,'Retail Sale Id 1335',72410.40,0.00,0.00,101.70,3051.00,'2022-07-19 19:30:09','',''),(1392,'1','275','1',1,'Return of Retail Sale Id 1310',0.00,9300.00,12.50,0.00,-775.00,'2022-07-19 19:33:08','',''),(1393,'1','275','1',1,'Retail Sale Id 1337',982.08,0.00,0.00,1.32,81.84,'2022-07-19 19:36:05','',''),(1394,'1','275','1',1,'Retail Sale Id 1339',22499.20,0.00,0.00,31.60,948.00,'2022-07-20 07:53:22','',''),(1395,'1','275','1',1,'Retail Sale Id 1340',996.96,0.00,0.00,1.34,83.08,'2022-07-20 07:56:07','',''),(1396,'1','275','1',1,'Retail Sale Id 1341',14503.44,0.00,0.00,20.37,611.10,'2022-07-20 08:14:31','',''),(1397,'1','275','1',1,'Retail Sale Id 1342',9300.00,0.00,0.00,12.50,775.00,'2022-07-20 08:50:14','',''),(1398,'1','275','1',1,'Retail Sale Id 1343',9300.00,0.00,0.00,12.50,775.00,'2022-07-20 09:12:23','',''),(1399,'1','275','1',1,'Retail Sale Id 1344',9099.12,0.00,0.00,12.23,758.26,'2022-07-20 09:13:24','',''),(1400,'1','275','1',1,'Retail Sale Id 1346',9300.00,0.00,0.00,12.50,775.00,'2022-07-20 09:18:00','',''),(1401,'1','275','1',1,'Retail Sale Id 1347',996.96,0.00,0.00,1.34,83.08,'2022-07-20 09:45:07','',''),(1402,'1','275','1',1,'Retail Sale Id 1348',2298.96,0.00,0.00,3.09,191.58,'2022-07-20 10:42:17','',''),(1403,'1','275','1',1,'Retail Sale Id 1349',14880.00,0.00,0.00,20.00,1240.00,'2022-07-20 10:57:33','',''),(1404,'1','275','1',1,'Retail Sale Id 1349',18600.00,0.00,0.00,25.00,1550.00,'2022-07-20 10:57:33','',''),(1405,'1','275','1',1,'Retail Sale Id 1350',18600.00,0.00,0.00,25.00,1550.00,'2022-07-20 12:23:39','',''),(1406,'1','275','1',1,'Retail Sale Id 1351',9002.40,0.00,0.00,12.10,750.20,'2022-07-20 12:59:48','',''),(1407,'1','275','1',1,'Retail Sale Id 1352',2499.84,0.00,0.00,3.36,208.32,'2022-07-20 14:04:34','',''),(1408,'1','275','1',1,'Retail Sale Id 1353',4501.20,0.00,0.00,6.05,375.10,'2022-07-20 14:50:18','',''),(1409,'1','275','1',1,'Retail Sale Id 1354',9300.00,0.00,0.00,12.50,775.00,'2022-07-20 14:56:43','',''),(1410,'1','275','1',1,'Retail Sale Id 1355',4464.00,0.00,0.00,6.00,372.00,'2022-07-20 15:07:30','',''),(1411,'1','275','1',1,'Retail Sale Id 1355',7440.00,0.00,0.00,10.00,620.00,'2022-07-20 15:07:30','',''),(1412,'1','275','1',1,'Retail Sale Id 1356',7998.00,0.00,0.00,10.75,666.50,'2022-07-20 15:10:03','',''),(1413,'1','275','1',1,'Retail Sale Id 1357',9002.40,0.00,0.00,12.10,750.20,'2022-07-20 15:16:46','',''),(1414,'1','275','1',1,'Retail Sale Id 1359',2298.96,0.00,0.00,3.09,191.58,'2022-07-20 16:03:11','',''),(1415,'1','275','1',1,'Retail Sale Id 1360',18600.00,0.00,0.00,25.00,1550.00,'2022-07-20 16:34:09','',''),(1416,'1','275','1',1,'Retail Sale Id 1361',18600.00,0.00,0.00,25.00,1550.00,'2022-07-20 16:47:02','',''),(1417,'1','275','1',1,'Retail Sale Id 1362',2298.96,0.00,0.00,3.09,191.58,'2022-07-20 17:11:30','',''),(1418,'1','275','1',1,'Retail Sale Id 1363',4501.20,0.00,0.00,6.05,375.10,'2022-07-20 17:12:25','',''),(1419,'1','275','1',1,'Retail Sale Id 1364',44856.00,0.00,0.00,63.00,1890.00,'2022-07-20 17:47:09','',''),(1420,'1','275','1',1,'Retail Sale Id 1365',22907.76,0.00,0.00,30.79,1908.98,'2022-07-20 17:50:01','',''),(1421,'1','275','1',1,'Retail Sale Id 1366',5952.00,0.00,0.00,8.00,496.00,'2022-07-20 17:51:43','',''),(1422,'1','275','1',1,'Distributed to OPPRETIONAL LOST  for sales id:7',59988.72,0.00,0.00,87.96,0.00,'2022-07-21 08:51:21','',''),(1423,'1','275',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3410000.00,5000.00,0.00,0.00,'2022-07-21 12:02:41','',''),(1424,'1','275',NULL,1,'Reception corrector for bridging 7',0.00,0.00,0.00,5000.00,0.00,'2022-07-21 12:03:47','',''),(1425,'1','275','1',1,'Received from bridging 7',0.00,0.00,5000.00,0.00,0.00,'2022-07-21 12:03:47','',''),(1426,'1','275','1',1,'Retail Sale Id 1367',24920.00,0.00,0.00,35.00,1050.00,'2022-07-21 12:11:41','',''),(1427,'1','275','1',1,'Retail Sale Id 1368',9999.36,0.00,0.00,13.44,833.28,'2022-07-21 12:14:21','',''),(1428,'1','275','1',1,'Retail Sale Id 1369',18600.00,0.00,0.00,25.00,1550.00,'2022-07-21 12:15:05','',''),(1429,'1','275','1',1,'Retail Sale Id 1370',996.96,0.00,0.00,1.34,83.08,'2022-07-21 12:16:20','',''),(1430,'1','275','1',1,'Retail Sale Id 1371',3496.80,0.00,0.00,4.70,291.40,'2022-07-21 12:44:01','',''),(1431,'1','275','1',1,'Retail Sale Id 1372',17999.36,0.00,0.00,25.28,758.40,'2022-07-21 12:46:48','',''),(1432,'1','275','1',1,'Retail Sale Id 1373',4501.20,0.00,0.00,6.05,375.10,'2022-07-21 12:54:52','',''),(1433,'1','275','1',1,'Retail Sale Id 1374',115344.00,0.00,0.00,162.00,4860.00,'2022-07-21 13:18:31','',''),(1434,'1','275','1',1,'Retail Sale Id 1375',3720.00,0.00,0.00,5.00,310.00,'2022-07-21 13:45:49','',''),(1435,'1','275','1',1,'Retail Sale Id 1376',2998.32,0.00,0.00,4.03,249.86,'2022-07-21 14:02:45','',''),(1436,'1','275','1',1,'Retail Sale Id 1377',71200.00,0.00,0.00,100.00,3000.00,'2022-07-21 14:07:07','',''),(1437,'1','275','1',1,'Retail Sale Id 1378',2298.96,0.00,0.00,3.09,191.58,'2022-07-21 14:22:58','',''),(1438,'1','275','1',1,'Retail Sale Id 1379',9300.00,0.00,0.00,12.50,775.00,'2022-07-21 14:24:29','',''),(1439,'1','275','1',1,'Retail Sale Id 1380',20648.00,0.00,0.00,29.00,870.00,'2022-07-21 14:30:25','',''),(1440,'1','275','1',1,'Retail Sale Id 1381',9300.00,0.00,0.00,12.50,775.00,'2022-07-21 14:32:49','',''),(1441,'1','275','1',1,'Retail Sale Id 1382',3720.00,0.00,0.00,5.00,310.00,'2022-07-21 15:17:02','',''),(1442,'1','275','1',1,'Retail Sale Id 1382',18600.00,0.00,0.00,25.00,1550.00,'2022-07-21 15:17:02','',''),(1443,'1','275','1',1,'Retail Sale Id 1397',29998.08,0.00,0.00,40.32,2499.84,'2022-07-21 15:22:49','',''),(1444,'1','275','1',1,'Retail Sale Id 1416',17088.00,0.00,0.00,24.00,720.00,'2022-07-21 15:46:54','',''),(1445,'1','275','1',1,'Retail Sale Id 1417',1502.88,0.00,0.00,2.02,125.24,'2022-07-21 16:11:24','',''),(1446,'1','275','1',1,'Retail Sale Id 1418',9300.00,0.00,0.00,12.50,775.00,'2022-07-21 16:29:55','',''),(1447,'1','275','1',1,'Retail Sale Id 1419',1197.84,0.00,0.00,1.61,99.82,'2022-07-21 16:31:54','',''),(1448,'1','275','1',1,'Retail Sale Id 1420',2001.36,0.00,0.00,2.69,166.78,'2022-07-21 16:42:17','',''),(1449,'1','275','1',1,'Retail Sale Id 1421',35600.00,0.00,0.00,50.00,1500.00,'2022-07-21 16:44:52','',''),(1450,'1','275','1',1,'Retail Sale Id 1428',9300.00,0.00,0.00,12.50,775.00,'2022-07-21 16:59:46','',''),(1451,'1','275','1',1,'Retail Sale Id 1430',4501.20,0.00,0.00,6.05,375.10,'2022-07-21 17:17:02','',''),(1452,'1','275','1',1,'Retail Sale Id 1433',2001.36,0.00,0.00,2.69,166.78,'2022-07-21 17:25:38','',''),(1453,'1','275','1',1,'Retail Sale Id 1434',18600.00,0.00,0.00,25.00,1550.00,'2022-07-21 17:26:46','',''),(1454,'1','275','1',1,'Retail Sale Id 1435',9300.00,0.00,0.00,12.50,775.00,'2022-07-21 17:32:19','',''),(1455,'1','275','1',1,'Retail Sale Id 1436',1502.88,0.00,0.00,2.02,125.24,'2022-07-21 17:38:19','',''),(1456,'1','275','1',1,'Retail Sale Id 1437',2298.96,0.00,0.00,3.09,191.58,'2022-07-21 17:40:53','',''),(1457,'1','275','1',1,'Retail Sale Id 1438',996.96,0.00,0.00,1.34,83.08,'2022-07-21 17:49:53','',''),(1458,'1','275','1',1,'Retail Sale Id 1439',2298.96,0.00,0.00,3.09,191.58,'2022-07-21 17:52:07','',''),(1459,'1','275','1',1,'Retail Sale Id 1444',2298.96,0.00,0.00,3.09,191.58,'2022-07-21 18:25:09','',''),(1460,'1','275','1',1,'Return of Retail Sale Id 1428',0.00,9300.00,12.50,0.00,-775.00,'2022-07-21 19:15:15','',''),(1461,'1','275','1',1,'Return of Retail Sale Id 1435',0.00,9300.00,12.50,0.00,-775.00,'2022-07-21 19:19:27','',''),(1462,'1','275','1',1,'Retail Sale Id 1445',3548.88,0.00,0.00,4.77,295.74,'2022-07-21 19:22:44','',''),(1463,'1','275','1',1,'Retail Sale Id 1446',42969.20,0.00,0.00,60.35,1810.50,'2022-07-21 19:25:35','',''),(1464,'1','275','1',1,'Retail Sale Id 1447',9300.00,0.00,0.00,12.50,775.00,'2022-07-22 08:41:35','',''),(1465,'1','275','1',1,'Retail Sale Id 1448',98256.00,0.00,0.00,138.00,4140.00,'2022-07-22 10:02:05','',''),(1466,'1','275','1',1,'Retail Sale Id 1449',9300.00,0.00,0.00,12.50,775.00,'2022-07-22 10:52:03','',''),(1467,'1','275','1',1,'Retail Sale Id 1450',35600.00,0.00,0.00,50.00,1500.00,'2022-07-22 10:53:48','',''),(1468,'1','275','1',1,'Retail Sale Id 1451',24001.52,0.00,0.00,33.71,1011.30,'2022-07-22 11:04:44','',''),(1469,'1','275','1',1,'Retail Sale Id 1452',2298.96,0.00,0.00,3.09,191.58,'2022-07-22 11:09:44','',''),(1470,'1','275','1',1,'Retail Sale Id 1453',803.52,0.00,0.00,1.08,66.96,'2022-07-22 11:10:38','',''),(1471,'1','275','1',1,'Retail Sale Id 1454',8900.00,0.00,0.00,12.50,375.00,'2022-07-22 12:07:30','',''),(1472,'1','275','1',1,'Retail Sale Id 1455',996.96,0.00,0.00,1.34,83.08,'2022-07-22 12:09:45','',''),(1473,'1','275','1',1,'Retail Sale Id 1456',35600.00,0.00,0.00,50.00,1500.00,'2022-07-22 12:15:14','',''),(1474,'1','275','1',1,'Retail Sale Id 1457',2001.36,0.00,0.00,2.69,166.78,'2022-07-22 12:32:42','',''),(1475,'1','275','1',1,'Retail Sale Id 1458',4501.20,0.00,0.00,6.05,375.10,'2022-07-22 15:00:46','',''),(1476,'1','275','1',1,'Retail Sale Id 1459',9300.00,0.00,0.00,12.50,775.00,'2022-07-22 15:01:53','',''),(1477,'1','275','1',1,'Retail Sale Id 1460',4501.20,0.00,0.00,6.05,375.10,'2022-07-22 15:18:55','',''),(1478,'1','275','1',1,'Retail Sale Id 1461',9300.00,0.00,0.00,12.50,775.00,'2022-07-22 15:34:19','',''),(1479,'1','275','1',1,'Retail Sale Id 1462',2298.96,0.00,0.00,3.09,191.58,'2022-07-22 15:42:57','',''),(1480,'1','275','1',1,'Retail Sale Id 1463',22000.80,0.00,0.00,30.90,927.00,'2022-07-22 15:52:40','',''),(1481,'1','275','1',1,'Retail Sale Id 1465',2298.96,0.00,0.00,3.09,191.58,'2022-07-22 16:06:26','',''),(1482,'1','275','1',1,'Retail Sale Id 1466',2998.32,0.00,0.00,4.03,249.86,'2022-07-22 16:07:19','',''),(1483,'1','275','1',1,'Retail Sale Id 1467',4501.20,0.00,0.00,6.05,375.10,'2022-07-22 16:14:53','',''),(1484,'1','275','1',1,'Retail Sale Id 1468',28999.76,0.00,0.00,40.73,1221.90,'2022-07-22 16:33:34','',''),(1485,'1','275','1',1,'Retail Sale Id 1469',2298.96,0.00,0.00,3.09,191.58,'2022-07-22 16:42:50','',''),(1486,'1','275','1',1,'Retail Sale Id 1470',2298.96,0.00,0.00,3.09,191.58,'2022-07-22 17:00:39','',''),(1487,'1','275','1',1,'Retail Sale Id 1473',4501.20,0.00,0.00,6.05,375.10,'2022-07-22 17:12:08','',''),(1488,'1','275','1',1,'Retail Sale Id 1474',18600.00,0.00,0.00,25.00,1550.00,'2022-07-22 18:19:37','',''),(1489,'1','275','1',1,'Retail Sale Id 1475',24499.92,0.00,0.00,34.41,1032.30,'2022-07-22 18:23:02','',''),(1490,'1','275','1',1,'Retail Sale Id 1472',4501.20,0.00,0.00,6.05,375.10,'2022-07-22 18:39:07','',''),(1491,'1','275','1',1,'Retail Sale Id 1471',4501.20,0.00,0.00,6.05,375.10,'2022-07-22 18:40:00','',''),(1492,'1','275','1',1,'Retail Sale Id 1476',2298.96,0.00,0.00,3.09,191.58,'2022-07-22 18:48:29','',''),(1493,'1','275','1',1,'Retail Sale Id 1477',2298.96,0.00,0.00,3.09,191.58,'2022-07-22 18:49:42','',''),(1494,'1','275','1',1,'Retail Sale Id 1478',52050.24,0.00,0.00,69.96,4337.52,'2022-07-22 19:33:21','',''),(1495,'1','275','1',1,'Retail Sale Id 1479',71171.52,0.00,0.00,99.96,2998.80,'2022-07-22 19:39:04','',''),(1496,'1','275','1',1,'Retail Sale Id 1480',4501.20,0.00,0.00,6.05,375.10,'2022-07-23 07:26:17','',''),(1497,'1','275','1',1,'Retail Sale Id 1481',9300.00,0.00,0.00,12.50,775.00,'2022-07-23 07:59:49','',''),(1498,'1','275','1',1,'Retail Sale Id 1482',4999.68,0.00,0.00,6.72,416.64,'2022-07-23 08:21:47','',''),(1499,'1','275','1',1,'Retail Sale Id 1483',278000.00,0.00,0.00,400.00,5200.00,'2022-07-23 08:54:20','',''),(1500,'1','275','1',1,'Retail Sale Id 1484',9300.00,0.00,0.00,12.50,775.00,'2022-07-23 09:20:37','',''),(1501,'1','275','1',1,'Retail Sale Id 1485',1502.88,0.00,0.00,2.02,125.24,'2022-07-23 09:39:25','',''),(1502,'1','275','1',1,'Retail Sale Id 1490',4501.20,0.00,0.00,6.05,375.10,'2022-07-23 09:43:17','',''),(1503,'1','275','1',1,'Retail Sale Id 1491',8928.00,0.00,0.00,12.00,744.00,'2022-07-23 09:48:03','',''),(1504,'1','275','1',1,'Retail Sale Id 1492',18600.00,0.00,0.00,25.00,1550.00,'2022-07-23 10:20:21','',''),(1505,'1','275','1',1,'Retail Sale Id 1493',9300.00,0.00,0.00,12.50,775.00,'2022-07-23 10:24:58','',''),(1506,'1','275','1',1,'Retail Sale Id 1495',9300.00,0.00,0.00,12.50,775.00,'2022-07-23 11:14:12','',''),(1507,'1','275','1',1,'Retail Sale Id 1496',77145.00,0.00,0.00,111.00,1443.00,'2022-07-23 11:17:06','',''),(1508,'1','275','1',1,'Retail Sale Id 1497',3720.00,0.00,0.00,5.00,310.00,'2022-07-23 11:23:46','',''),(1509,'1','275','1',1,'Retail Sale Id 1498',14998.10,0.00,0.00,21.58,280.54,'2022-07-23 11:27:53','',''),(1510,'1','275','1',1,'Retail Sale Id 1499',1502.88,0.00,0.00,2.02,125.24,'2022-07-23 11:29:56','',''),(1511,'1','275','1',1,'Retail Sale Id 1500',139000.00,0.00,0.00,200.00,2600.00,'2022-07-23 12:12:21','',''),(1512,'1','275','1',1,'Retail Sale Id 1501',2298.96,0.00,0.00,3.09,191.58,'2022-07-23 12:22:27','',''),(1513,'1','275','1',1,'Retail Sale Id 1504',9300.00,0.00,0.00,12.50,775.00,'2022-07-23 13:18:15','',''),(1514,'1','275','1',1,'Retail Sale Id 1505',996.96,0.00,0.00,1.34,83.08,'2022-07-23 13:33:21','',''),(1515,'1','275','1',1,'Retail Sale Id 1506',4650.00,0.00,0.00,6.25,387.50,'2022-07-23 14:04:23','',''),(1516,'1','275','1',1,'Retail Sale Id 1506',9300.00,0.00,0.00,12.50,775.00,'2022-07-23 14:04:23','',''),(1517,'1','275','1',1,'Retail Sale Id 1512',1502.88,0.00,0.00,2.02,125.24,'2022-07-23 14:07:25','',''),(1518,'1','275','1',1,'Retail Sale Id 1513',1502.88,0.00,0.00,2.02,125.24,'2022-07-23 14:08:52','',''),(1519,'1','275','1',1,'Retail Sale Id 1511',1502.88,0.00,0.00,2.02,125.24,'2022-07-23 14:10:49','',''),(1520,'1','275','1',1,'Retail Sale Id 1507',1502.88,0.00,0.00,2.02,125.24,'2022-07-23 14:11:40','',''),(1521,'1','275','1',1,'Retail Sale Id 1510',1502.88,0.00,0.00,2.02,125.24,'2022-07-23 14:13:59','',''),(1522,'1','275','1',1,'Retail Sale Id 1509',1502.88,0.00,0.00,2.02,125.24,'2022-07-23 14:15:37','',''),(1523,'1','275','1',1,'Retail Sale Id 1508',1502.88,0.00,0.00,2.02,125.24,'2022-07-23 14:18:25','',''),(1524,'1','275','1',1,'Retail Sale Id 1514',1502.88,0.00,0.00,2.02,125.24,'2022-07-23 14:58:43','',''),(1525,'1','275','1',1,'Retail Sale Id 1515',3720.00,0.00,0.00,5.00,310.00,'2022-07-23 15:05:53','',''),(1526,'1','275','1',1,'Retail Sale Id 1516',9300.00,0.00,0.00,12.50,775.00,'2022-07-23 15:48:34','',''),(1527,'1','275','1',1,'Retail Sale Id 1522',4501.20,0.00,0.00,6.05,375.10,'2022-07-23 16:09:12','',''),(1528,'1','275','1',1,'Retail Sale Id 1523',69500.00,0.00,0.00,100.00,1300.00,'2022-07-23 16:50:20','',''),(1529,'1','275','1',1,'Retail Sale Id 1524',107076.48,0.00,0.00,143.92,8923.04,'2022-07-23 19:26:45','',''),(1530,'1','275','1',1,'Retail Sale Id 1525',442728.90,0.00,0.00,637.02,8281.26,'2022-07-23 19:30:46','',''),(1531,'1','275','1',1,'Retail Sale Id 1526',18600.00,0.00,0.00,25.00,1550.00,'2022-07-24 12:28:37','',''),(1532,'1','275','1',1,'Retail Sale Id 1527',9300.00,0.00,0.00,12.50,775.00,'2022-07-24 12:29:10','',''),(1533,'1','275','1',1,'Retail Sale Id 1529',14998.10,0.00,0.00,21.58,280.54,'2022-07-24 13:07:26','',''),(1534,'1','275','1',1,'Retail Sale Id 1530',18600.00,0.00,0.00,25.00,1550.00,'2022-07-24 13:09:52','',''),(1535,'1','275','1',1,'Retail Sale Id 1531',3720.00,0.00,0.00,5.00,310.00,'2022-07-24 13:11:48','',''),(1536,'1','275','1',1,'Retail Sale Id 1534',9300.00,0.00,0.00,12.50,775.00,'2022-07-24 13:31:58','',''),(1537,'1','275','1',1,'Retail Sale Id 1535',18600.00,0.00,0.00,25.00,1550.00,'2022-07-24 13:34:06','',''),(1538,'1','275','1',1,'Retail Sale Id 1536',4501.20,0.00,0.00,6.05,375.10,'2022-07-24 13:35:26','',''),(1539,'1','275','1',1,'Retail Sale Id 1539',1502.88,0.00,0.00,2.02,125.24,'2022-07-24 13:41:31','',''),(1540,'1','275','1',1,'Retail Sale Id 1540',9300.00,0.00,0.00,12.50,775.00,'2022-07-24 13:59:43','',''),(1541,'1','275','1',1,'Retail Sale Id 1541',7998.00,0.00,0.00,10.75,666.50,'2022-07-24 14:15:36','',''),(1542,'1','275','1',1,'Retail Sale Id 1542',16680.00,0.00,0.00,24.00,312.00,'2022-07-24 15:06:58','',''),(1543,'1','275','1',1,'Retail Sale Id 1543',4999.68,0.00,0.00,6.72,416.64,'2022-07-24 15:08:23','',''),(1544,'1','275','1',1,'Retail Sale Id 1544',9300.00,0.00,0.00,12.50,775.00,'2022-07-24 15:09:45','',''),(1545,'1','275','1',1,'Retail Sale Id 1545',2298.96,0.00,0.00,3.09,191.58,'2022-07-24 15:12:23','',''),(1546,'1','275','1',1,'Retail Sale Id 1546',4999.68,0.00,0.00,6.72,416.64,'2022-07-24 15:48:30','',''),(1547,'1','275','1',1,'Retail Sale Id 1547',77840.00,0.00,0.00,112.00,1456.00,'2022-07-24 15:54:52','',''),(1548,'1','275','1',1,'Retail Sale Id 1548',2232.00,0.00,0.00,3.00,186.00,'2022-07-24 15:56:24','',''),(1549,'1','275','1',1,'Retail Sale Id 1549',2998.32,0.00,0.00,4.03,249.86,'2022-07-24 16:22:02','',''),(1550,'1','275','1',1,'Retail Sale Id 1550',2001.36,0.00,0.00,2.69,166.78,'2022-07-24 16:33:47','',''),(1551,'1','275','1',1,'Retail Sale Id 1551',9300.00,0.00,0.00,12.50,775.00,'2022-07-24 16:45:28','',''),(1552,'1','275','1',1,'Retail Sale Id 1552',9300.00,0.00,0.00,12.50,775.00,'2022-07-24 17:27:27','',''),(1553,'1','275','1',1,'Retail Sale Id 1553',2998.32,0.00,0.00,4.03,249.86,'2022-07-24 17:30:11','',''),(1554,'1','275','1',1,'Retail Sale Id 1554',4501.20,0.00,0.00,6.05,375.10,'2022-07-24 18:05:02','',''),(1555,'1','275','1',1,'Retail Sale Id 1555',69500.00,0.00,0.00,100.00,1300.00,'2022-07-24 18:15:17','',''),(1556,'1','275','1',1,'Retail Sale Id 1556',4999.68,0.00,0.00,6.72,416.64,'2022-07-24 18:16:57','',''),(1557,'1','275','1',1,'Retail Sale Id 1557',2298.96,0.00,0.00,3.09,191.58,'2022-07-24 18:36:36','',''),(1558,'1','275','1',1,'Retail Sale Id 1558',9300.00,0.00,0.00,12.50,775.00,'2022-07-24 18:46:32','',''),(1559,'1','275','1',1,'Retail Sale Id 1559',79925.00,0.00,0.00,115.00,1495.00,'2022-07-24 19:12:37','',''),(1560,'1','275','1',1,'Retail Sale Id 1560',36894.96,0.00,0.00,49.59,3074.58,'2022-07-24 19:38:47','',''),(1561,'1','275','1',1,'Retail Sale Id 1563',24686.40,0.00,0.00,35.52,461.76,'2022-07-24 19:42:48','',''),(1562,'1','275','1',1,'Retail Sale Id 1564',32498.20,0.00,0.00,46.76,607.88,'2022-07-25 06:58:02','',''),(1563,'1','275','1',1,'Retail Sale Id 1565',2001.36,0.00,0.00,2.69,166.78,'2022-07-25 07:21:03','',''),(1564,'1','275','1',1,'Retail Sale Id 1566',14880.00,0.00,0.00,20.00,1240.00,'2022-07-25 07:46:19','',''),(1565,'1','275','1',1,'Retail Sale Id 1567',1502.88,0.00,0.00,2.02,125.24,'2022-07-25 08:01:33','',''),(1566,'1','275','1',1,'Retail Sale Id 1568',10996.32,0.00,0.00,14.78,916.36,'2022-07-25 08:31:19','',''),(1567,'1','275','1',1,'Retail Sale Id 1569',9300.00,0.00,0.00,12.50,775.00,'2022-07-25 08:46:11','',''),(1568,'1','275','1',1,'Retail Sale Id 1570',8687.50,0.00,0.00,12.50,162.50,'2022-07-25 09:05:27','',''),(1569,'1','275','1',1,'Retail Sale Id 1571',38225.00,0.00,0.00,55.00,715.00,'2022-07-25 10:35:08','',''),(1570,'1','275','1',1,'Retail Sale Id 1572',13003.45,0.00,0.00,18.71,243.23,'2022-07-25 10:37:18','',''),(1571,'1','275','1',1,'Retail Sale Id 1573',139000.00,0.00,0.00,200.00,2600.00,'2022-07-25 10:41:14','',''),(1572,'1','275','1',1,'Retail Sale Id 1574',9300.00,0.00,0.00,12.50,775.00,'2022-07-25 10:48:18','',''),(1573,'1','275','1',1,'Retail Sale Id 1575',104250.00,0.00,0.00,150.00,1950.00,'2022-07-25 10:51:03','',''),(1574,'1','275','1',1,'Retail Sale Id 1576',20002.10,0.00,0.00,28.78,374.14,'2022-07-25 11:01:04','',''),(1575,'1','275','1',1,'Retail Sale Id 1577',9300.00,0.00,0.00,12.50,775.00,'2022-07-25 11:18:46','',''),(1576,'1','275','1',1,'Retail Sale Id 1580',996.96,0.00,0.00,1.34,83.08,'2022-07-25 11:45:19','',''),(1577,'1','275','1',1,'Retail Sale Id 1581',9300.00,0.00,0.00,12.50,775.00,'2022-07-25 12:38:05','',''),(1578,'1','275','1',1,'Retail Sale Id 1582',4999.68,0.00,0.00,6.72,416.64,'2022-07-25 12:39:47','',''),(1579,'1','275','1',1,'Retail Sale Id 1583',4501.20,0.00,0.00,6.05,375.10,'2022-07-25 12:45:15','',''),(1580,'1','275','1',1,'Retail Sale Id 1584',9300.00,0.00,0.00,12.50,775.00,'2022-07-25 12:57:17','',''),(1581,'1','275','1',1,'Retail Sale Id 1585',7440.00,0.00,0.00,10.00,620.00,'2022-07-25 13:05:04','',''),(1582,'1','275','1',1,'Retail Sale Id 1586',17375.00,0.00,0.00,25.00,325.00,'2022-07-25 13:59:55','',''),(1583,'1','275','1',1,'Retail Sale Id 1587',9300.00,0.00,0.00,12.50,775.00,'2022-07-25 14:06:04','',''),(1584,'1','275','1',1,'Retail Sale Id 1588',9002.40,0.00,0.00,12.10,750.20,'2022-07-25 14:10:15','',''),(1585,'1','275','1',1,'Retail Sale Id 1591',1502.88,0.00,0.00,2.02,125.24,'2022-07-25 14:14:02','',''),(1586,'1','275','1',1,'Retail Sale Id 1592',130312.50,0.00,0.00,187.50,2437.50,'2022-07-25 15:36:09','',''),(1587,'1','275','1',1,'Retail Sale Id 1594',4002.72,0.00,0.00,5.38,333.56,'2022-07-25 15:48:37','',''),(1588,'1','275','1',1,'Retail Sale Id 1595',9300.00,0.00,0.00,12.50,775.00,'2022-07-25 15:50:10','',''),(1589,'1','275','1',1,'Retail Sale Id 1596',38509.44,0.00,0.00,51.76,3209.12,'2022-07-25 17:15:18','',''),(1590,'1','275','1',1,'Retail Sale Id 1597',50561.25,0.00,0.00,72.75,945.75,'2022-07-25 17:15:53','',''),(1591,'1','275','1',1,'Distributed to Operational lost for sales id:8',48367.44,0.00,0.00,70.92,0.00,'2022-07-26 07:30:59','',''),(1592,'1','275',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3444100.00,5050.00,0.00,0.00,'2022-07-26 08:08:50','',''),(1593,'1','275',NULL,1,'Reception corrector for bridging 8',0.00,0.00,0.00,5050.00,0.00,'2022-07-26 08:10:06','',''),(1594,'1','275','1',1,'Received from bridging 8',0.00,0.00,5050.00,0.00,0.00,'2022-07-26 08:10:06','',''),(1595,'1','275','1',1,'Retail Sale Id 1598',9300.00,0.00,0.00,12.50,775.00,'2022-07-26 08:15:04','',''),(1596,'1','275','1',1,'Retail Sale Id 1599',9002.40,0.00,0.00,12.10,750.20,'2022-07-26 08:21:08','',''),(1597,'1','275','1',1,'Retail Sale Id 1600',33360.00,0.00,0.00,48.00,624.00,'2022-07-26 08:33:52','',''),(1598,'1','275','1',1,'Retail Sale Id 1601',59770.00,0.00,0.00,86.00,1118.00,'2022-07-26 08:53:57','',''),(1599,'1','275','1',1,'Retail Sale Id 1602',2298.96,0.00,0.00,3.09,191.58,'2022-07-26 09:05:04','',''),(1600,'1','275','1',1,'Retail Sale Id 1603',2001.36,0.00,0.00,2.69,166.78,'2022-07-26 09:13:53','',''),(1601,'1','275','1',1,'Retail Sale Id 1604',7998.00,0.00,0.00,10.75,666.50,'2022-07-26 09:19:26','',''),(1602,'1','275','1',1,'Retail Sale Id 1605',2298.96,0.00,0.00,3.09,191.58,'2022-07-26 09:36:49','',''),(1603,'1','275','1',1,'Retail Sale Id 1606',34750.00,0.00,0.00,50.00,650.00,'2022-07-26 09:45:34','',''),(1604,'1','275','1',1,'Retail Sale Id 1607',3749.76,0.00,0.00,5.04,312.48,'2022-07-26 10:19:11','',''),(1605,'1','275','1',1,'Retail Sale Id 1608',38225.00,0.00,0.00,55.00,715.00,'2022-07-26 10:23:34','',''),(1606,'1','275','1',1,'Retail Sale Id 1609',2499.84,0.00,0.00,3.36,208.32,'2022-07-26 10:35:42','',''),(1607,'1','275','1',1,'Retail Sale Id 1610',2998.32,0.00,0.00,4.03,249.86,'2022-07-26 10:39:35','',''),(1608,'1','275','1',1,'Retail Sale Id 1611',30580.00,0.00,0.00,44.00,572.00,'2022-07-26 10:58:39','',''),(1609,'1','275','1',1,'Retail Sale Id 1612',104250.00,0.00,0.00,150.00,1950.00,'2022-07-26 11:14:09','',''),(1610,'1','275','1',1,'Retail Sale Id 1613',8496.48,0.00,0.00,11.42,708.04,'2022-07-26 11:23:09','',''),(1611,'1','275','1',1,'Retail Sale Id 1614',9300.00,0.00,0.00,12.50,775.00,'2022-07-26 11:58:54','',''),(1612,'1','275','1',1,'Retail Sale Id 1615',996.96,0.00,0.00,1.34,83.08,'2022-07-26 12:10:33','',''),(1613,'1','275','1',1,'Retail Sale Id 1616',7440.00,0.00,0.00,10.00,620.00,'2022-07-26 12:19:24','',''),(1614,'1','275','1',1,'Retail Sale Id 1617',1502.88,0.00,0.00,2.02,125.24,'2022-07-26 12:37:17','',''),(1615,'1','275','1',1,'Retail Sale Id 1618',9300.00,0.00,0.00,12.50,775.00,'2022-07-26 12:45:23','',''),(1616,'1','275','1',1,'Retail Sale Id 1619',4999.68,0.00,0.00,6.72,416.64,'2022-07-26 12:51:30','',''),(1617,'1','275','1',1,'Retail Sale Id 1620',9300.00,0.00,0.00,12.50,775.00,'2022-07-26 12:53:59','',''),(1618,'1','275','1',1,'Retail Sale Id 1621',139000.00,0.00,0.00,200.00,2600.00,'2022-07-26 13:09:29','',''),(1619,'1','275','1',1,'Retail Sale Id 1622',70890.00,0.00,0.00,102.00,1326.00,'2022-07-26 13:24:12','',''),(1620,'1','275','1',1,'Retail Sale Id 1623',2499.84,0.00,0.00,3.36,208.32,'2022-07-26 13:27:23','',''),(1621,'1','275','1',1,'Retail Sale Id 1624',8687.50,0.00,0.00,12.50,162.50,'2022-07-26 13:29:07','',''),(1622,'1','275','1',1,'Retail Sale Id 1625',4501.20,0.00,0.00,6.05,375.10,'2022-07-26 14:15:22','',''),(1623,'1','275','1',1,'Retail Sale Id 1626',1502.88,0.00,0.00,2.02,125.24,'2022-07-26 14:52:59','',''),(1624,'1','275','1',1,'Retail Sale Id 1627',18600.00,0.00,0.00,25.00,1550.00,'2022-07-26 15:41:21','',''),(1625,'1','275','1',1,'Retail Sale Id 1628',2001.36,0.00,0.00,2.69,166.78,'2022-07-26 15:53:55','',''),(1626,'1','275','1',1,'Retail Sale Id 1629',4501.20,0.00,0.00,6.05,375.10,'2022-07-26 16:07:14','',''),(1627,'1','275','1',1,'Retail Sale Id 1630',9300.00,0.00,0.00,12.50,775.00,'2022-07-26 16:11:18','',''),(1628,'1','275','1',1,'Retail Sale Id 1631',41700.00,0.00,0.00,60.00,780.00,'2022-07-26 16:16:14','',''),(1629,'1','275','1',1,'Retail Sale Id 1633',13003.45,0.00,0.00,18.71,243.23,'2022-07-26 17:50:11','',''),(1630,'1','275','1',1,'Retail Sale Id 1634',3496.80,0.00,0.00,4.70,291.40,'2022-07-26 17:50:57','',''),(1631,'1','275','1',1,'Retail Sale Id 1635',4002.72,0.00,0.00,5.38,333.56,'2022-07-26 17:52:04','',''),(1632,'1','275','1',1,'Retail Sale Id 1636',3720.00,0.00,0.00,5.00,310.00,'2022-07-26 18:02:58','',''),(1633,'1','275','1',1,'Retail Sale Id 1637',14880.00,0.00,0.00,20.00,1240.00,'2022-07-26 18:04:44','',''),(1634,'1','275','1',1,'Retail Sale Id 1638',18600.00,0.00,0.00,25.00,1550.00,'2022-07-26 18:08:03','',''),(1635,'1','275','1',1,'Retail Sale Id 1640',4501.20,0.00,0.00,6.05,375.10,'2022-07-26 18:10:51','',''),(1636,'1','275','1',1,'Retail Sale Id 1641',89655.00,0.00,0.00,129.00,1677.00,'2022-07-26 18:12:27','',''),(1637,'1','275','1',1,'Retail Sale Id 1642',8340.00,0.00,0.00,12.00,156.00,'2022-07-26 18:27:01','',''),(1638,'1','275','1',1,'Return of Retail Sale Id 1642',0.00,8340.00,12.00,0.00,-156.00,'2022-07-26 18:27:47','',''),(1639,'1','275','1',1,'Retail Sale Id 1643',3496.80,0.00,0.00,4.70,291.40,'2022-07-26 18:28:22','',''),(1640,'1','275','1',1,'Retail Sale Id 1644',7999.45,0.00,0.00,11.51,149.63,'2022-07-26 18:29:50','',''),(1641,'1','275','1',1,'Retail Sale Id 1645',76423.68,0.00,0.00,102.72,6368.64,'2022-07-26 19:21:31','',''),(1642,'1','275','1',1,'Retail Sale Id 1646',228154.60,0.00,0.00,328.28,4267.64,'2022-07-26 19:22:25','',''),(1643,'1','275','1',1,'Retail Sale Id 1647',9300.00,0.00,0.00,12.50,775.00,'2022-07-27 07:40:28','',''),(1644,'1','275','1',1,'Retail Sale Id 1648',32996.40,0.00,0.00,44.35,2749.70,'2022-07-27 07:49:48','',''),(1645,'1','275','1',1,'Retail Sale Id 1649',4501.20,0.00,0.00,6.05,375.10,'2022-07-27 09:09:04','',''),(1646,'1','275','1',1,'Retail Sale Id 1650',9203.28,0.00,0.00,12.37,766.94,'2022-07-27 09:23:32','',''),(1647,'1','275','1',1,'Retail Sale Id 1651',4002.72,0.00,0.00,5.38,333.56,'2022-07-27 09:27:22','',''),(1648,'1','275','1',1,'Retail Sale Id 1652',2298.96,0.00,0.00,3.09,191.58,'2022-07-27 09:31:55','',''),(1649,'1','275','1',1,'Retail Sale Id 1653',4501.20,0.00,0.00,6.05,375.10,'2022-07-27 10:15:30','',''),(1650,'1','275','1',1,'Retail Sale Id 1654',24325.00,0.00,0.00,35.00,455.00,'2022-07-27 11:27:25','',''),(1651,'1','275','1',1,'Retail Sale Id 1655',2298.96,0.00,0.00,3.09,191.58,'2022-07-27 12:10:55','',''),(1652,'1','275','1',1,'Retail Sale Id 1656',2298.96,0.00,0.00,3.09,191.58,'2022-07-27 12:13:51','',''),(1653,'1','275','1',1,'Retail Sale Id 1657',996.96,0.00,0.00,1.34,83.08,'2022-07-27 12:14:37','',''),(1654,'1','275','1',1,'Retail Sale Id 1658',9300.00,0.00,0.00,12.50,775.00,'2022-07-27 12:36:02','',''),(1655,'1','275','1',1,'Retail Sale Id 1659',2298.96,0.00,0.00,3.09,191.58,'2022-07-27 13:23:07','',''),(1656,'1','275','1',1,'Retail Sale Id 1660',34750.00,0.00,0.00,50.00,650.00,'2022-07-27 14:17:14','',''),(1657,'1','275','1',1,'Retail Sale Id 1661',14880.00,0.00,0.00,20.00,1240.00,'2022-07-27 14:24:15','',''),(1658,'1','275','1',1,'Retail Sale Id 1662',9300.00,0.00,0.00,12.50,775.00,'2022-07-27 14:34:48','',''),(1659,'1','275','1',1,'Retail Sale Id 1663',9300.00,0.00,0.00,12.50,775.00,'2022-07-27 14:38:39','',''),(1660,'1','275','1',1,'Retail Sale Id 1664',9300.00,0.00,0.00,12.50,775.00,'2022-07-27 14:48:36','',''),(1661,'1','275','1',1,'Retail Sale Id 1665',33360.00,0.00,0.00,48.00,624.00,'2022-07-27 15:09:21','',''),(1662,'1','275','1',1,'Retail Sale Id 1666',34750.00,0.00,0.00,50.00,650.00,'2022-07-27 15:11:23','',''),(1663,'1','275','1',1,'Retail Sale Id 1667',4501.20,0.00,0.00,6.05,375.10,'2022-07-27 15:13:55','',''),(1664,'1','275','1',1,'Retail Sale Id 1668',4501.20,0.00,0.00,6.05,375.10,'2022-07-27 15:16:25','',''),(1665,'1','275','1',1,'Retail Sale Id 1669',13205.00,0.00,0.00,19.00,247.00,'2022-07-27 15:32:59','',''),(1666,'1','275','1',1,'Retail Sale Id 1670',8303.04,0.00,0.00,11.16,691.92,'2022-07-27 15:40:45','',''),(1667,'1','275','1',1,'Retail Sale Id 1671',9300.00,0.00,0.00,12.50,775.00,'2022-07-27 15:48:04','',''),(1668,'1','275','1',1,'Retail Sale Id 1672',2976.00,0.00,0.00,4.00,248.00,'2022-07-27 17:02:04','',''),(1669,'1','275','1',1,'Retail Sale Id 1673',4999.68,0.00,0.00,6.72,416.64,'2022-07-27 17:09:14','',''),(1670,'1','275','1',1,'Retail Sale Id 1674',4501.20,0.00,0.00,6.05,375.10,'2022-07-27 17:10:45','',''),(1671,'1','275','1',1,'Retail Sale Id 1675',1502.88,0.00,0.00,2.02,125.24,'2022-07-27 17:13:48','',''),(1672,'1','275','1',1,'Retail Sale Id 1676',9300.00,0.00,0.00,12.50,775.00,'2022-07-27 17:24:04','',''),(1673,'1','275','1',1,'Retail Sale Id 1677',2298.96,0.00,0.00,3.09,191.58,'2022-07-27 17:35:39','',''),(1674,'1','275','1',1,'Retail Sale Id 1678',17375.00,0.00,0.00,25.00,325.00,'2022-07-27 17:38:39','',''),(1675,'1','275','1',1,'Retail Sale Id 1679',2298.96,0.00,0.00,3.09,191.58,'2022-07-27 17:49:21','',''),(1676,'1','275','1',1,'Retail Sale Id 1680',4501.20,0.00,0.00,6.05,375.10,'2022-07-27 17:50:22','',''),(1677,'1','275','1',1,'Retail Sale Id 1681',101470.00,0.00,0.00,146.00,1898.00,'2022-07-27 18:46:35','',''),(1678,'1','275','1',1,'Retail Sale Id 1682',1502.88,0.00,0.00,2.02,125.24,'2022-07-27 18:49:24','',''),(1679,'1','275','1',1,'Retail Sale Id 1683',34750.00,0.00,0.00,50.00,650.00,'2022-07-27 18:55:45','',''),(1680,'1','275','1',1,'Retail Sale Id 1684',32665.00,0.00,0.00,47.00,611.00,'2022-07-27 18:56:27','',''),(1681,'1','275','1',1,'Retail Sale Id 1685',2998.32,0.00,0.00,4.03,249.86,'2022-07-27 19:02:21','',''),(1682,'1','275','1',1,'Retail Sale Id 1686',996.96,0.00,0.00,1.34,83.08,'2022-07-27 19:43:26','',''),(1683,'1','275','1',1,'Retail Sale Id 1687',18765.00,0.00,0.00,27.00,351.00,'2022-07-27 19:45:34','',''),(1684,'1','275','1',1,'Retail Sale Id 1688',996.96,0.00,0.00,1.34,83.08,'2022-07-27 19:54:39','',''),(1685,'1','275','1',1,'Return of Retail Sale Id 1661',0.00,14880.00,20.00,0.00,-1240.00,'2022-07-27 21:38:42','',''),(1686,'1','275','1',1,'Retail Sale Id 1689',8846.16,0.00,0.00,11.89,737.18,'2022-07-27 21:41:42','',''),(1687,'1','275','1',1,'Retail Sale Id 1690',101331.00,0.00,0.00,145.80,1895.40,'2022-07-27 21:44:22','',''),(1688,'1','275','1',1,'Retail Sale Id 1691',18600.00,0.00,0.00,25.00,1550.00,'2022-07-28 07:49:15','',''),(1689,'1','275','1',1,'Retail Sale Id 1692',9300.00,0.00,0.00,12.50,775.00,'2022-07-28 08:22:37','',''),(1690,'1','275','1',1,'Retail Sale Id 1693',9300.00,0.00,0.00,12.50,775.00,'2022-07-28 08:34:47','',''),(1691,'1','275','1',1,'Retail Sale Id 1694',9300.00,0.00,0.00,12.50,775.00,'2022-07-28 08:41:14','',''),(1692,'1','275','1',1,'Retail Sale Id 1695',12002.65,0.00,0.00,17.27,224.51,'2022-07-28 08:48:28','',''),(1693,'1','275','1',1,'Retail Sale Id 1696',18600.00,0.00,0.00,25.00,1550.00,'2022-07-28 09:59:20','',''),(1694,'1','275','1',1,'Retail Sale Id 1697',3720.00,0.00,0.00,5.00,310.00,'2022-07-28 10:05:42','',''),(1695,'1','275','1',1,'Retail Sale Id 1698',74400.00,0.00,0.00,100.00,6200.00,'2022-07-28 10:07:43','',''),(1696,'1','275','1',1,'Retail Sale Id 1699',34750.00,0.00,0.00,50.00,650.00,'2022-07-28 10:10:20','',''),(1697,'1','275','1',1,'Retail Sale Id 1700',34750.00,0.00,0.00,50.00,650.00,'2022-07-28 10:33:56','',''),(1698,'1','275','1',1,'Retail Sale Id 1701',996.96,0.00,0.00,1.34,83.08,'2022-07-28 10:47:20','',''),(1699,'1','275','1',1,'Retail Sale Id 1702',19001.30,0.00,0.00,27.34,355.42,'2022-07-28 12:43:28','',''),(1700,'1','275','1',1,'Retail Sale Id 1703',42742.50,0.00,0.00,61.50,799.50,'2022-07-28 13:06:23','',''),(1701,'1','275','1',1,'Retail Sale Id 1704',34750.00,0.00,0.00,50.00,650.00,'2022-07-28 13:49:08','',''),(1702,'1','275','1',1,'Retail Sale Id 1705',69500.00,0.00,0.00,100.00,1300.00,'2022-07-28 14:49:06','',''),(1703,'1','275','1',1,'Retail Sale Id 1706',9300.00,0.00,0.00,12.50,775.00,'2022-07-28 14:51:03','',''),(1704,'1','275','1',1,'Retail Sale Id 1707',30003.15,0.00,0.00,43.17,561.21,'2022-07-28 15:05:44','',''),(1705,'1','275','1',1,'Retail Sale Id 1708',9300.00,0.00,0.00,12.50,775.00,'2022-07-28 15:15:35','',''),(1706,'1','275','1',1,'Retail Sale Id 1709',4999.68,0.00,0.00,6.72,416.64,'2022-07-28 15:19:17','',''),(1707,'1','275','1',1,'Retail Sale Id 1710',139000.00,0.00,0.00,200.00,2600.00,'2022-07-28 15:41:19','',''),(1708,'1','275','1',1,'Retail Sale Id 1711',9300.00,0.00,0.00,12.50,775.00,'2022-07-28 15:42:18','',''),(1709,'1','275','1',1,'Retail Sale Id 1713',2298.96,0.00,0.00,3.09,191.58,'2022-07-28 15:43:56','',''),(1710,'1','275','1',1,'Retail Sale Id 1714',5997.85,0.00,0.00,8.63,112.19,'2022-07-28 15:45:10','',''),(1711,'1','275','1',1,'Retail Sale Id 1715',9002.40,0.00,0.00,12.10,750.20,'2022-07-28 15:55:50','',''),(1712,'1','275','1',1,'Retail Sale Id 1716',9300.00,0.00,0.00,12.50,775.00,'2022-07-28 15:58:14','',''),(1713,'1','275','1',1,'Retail Sale Id 1717',4002.72,0.00,0.00,5.38,333.56,'2022-07-28 16:02:31','',''),(1714,'1','275','1',1,'Retail Sale Id 1717',4501.20,0.00,0.00,6.05,375.10,'2022-07-28 16:02:31','',''),(1715,'1','275','1',1,'Retail Sale Id 1718',69500.00,0.00,0.00,100.00,1300.00,'2022-07-28 16:04:28','',''),(1716,'1','275','1',1,'Retail Sale Id 1719',52820.00,0.00,0.00,76.00,988.00,'2022-07-28 16:22:48','',''),(1717,'1','275','1',1,'Retail Sale Id 1720',9300.00,0.00,0.00,12.50,775.00,'2022-07-28 17:19:31','',''),(1718,'1','275','1',1,'Retail Sale Id 1721',4999.68,0.00,0.00,6.72,416.64,'2022-07-28 17:43:43','',''),(1719,'1','275','1',1,'Retail Sale Id 1722',68110.00,0.00,0.00,98.00,1274.00,'2022-07-28 17:51:00','',''),(1720,'1','275','1',1,'Retail Sale Id 1723',9300.00,0.00,0.00,12.50,775.00,'2022-07-28 17:55:36','',''),(1721,'1','275','1',1,'Retail Sale Id 1724',34750.00,0.00,0.00,50.00,650.00,'2022-07-28 17:59:16','',''),(1722,'1','275','1',1,'Retail Sale Id 1725',7992.50,0.00,0.00,11.50,149.50,'2022-07-28 18:00:26','',''),(1723,'1','275','1',1,'Retail Sale Id 1726',5996.64,0.00,0.00,8.06,499.72,'2022-07-28 18:27:55','',''),(1724,'1','275','1',1,'Retail Sale Id 1727',4501.20,0.00,0.00,6.05,375.10,'2022-07-28 18:38:06','',''),(1725,'1','275','1',1,'Retail Sale Id 1728',9300.00,0.00,0.00,12.50,775.00,'2022-07-28 18:45:17','',''),(1726,'1','275','1',1,'Retail Sale Id 1729',4002.72,0.00,0.00,5.38,333.56,'2022-07-28 18:47:17','',''),(1727,'1','275','1',1,'Retail Sale Id 1730',28842.50,0.00,0.00,41.50,539.50,'2022-07-28 19:12:35','',''),(1728,'1','275','1',1,'Retail Sale Id 1731',40674.48,0.00,0.00,54.67,3389.54,'2022-07-28 19:31:10','',''),(1729,'1','275','1',1,'Retail Sale Id 1732',8207.95,0.00,0.00,11.81,153.53,'2022-07-28 19:32:49','',''),(1730,'1','275','1',1,'Retail Sale Id 1733',9300.00,0.00,0.00,12.50,775.00,'2022-07-29 08:33:38','',''),(1731,'1','275','1',1,'Retail Sale Id 1734',9300.00,0.00,0.00,12.50,775.00,'2022-07-29 08:35:12','',''),(1732,'1','275','1',1,'Retail Sale Id 1735',19001.30,0.00,0.00,27.34,355.42,'2022-07-29 08:39:09','',''),(1733,'1','275','1',1,'Retail Sale Id 1736',9300.00,0.00,0.00,12.50,775.00,'2022-07-29 08:58:48','',''),(1734,'1','275','1',1,'Retail Sale Id 1737',72975.00,0.00,0.00,105.00,1365.00,'2022-07-29 09:06:20','',''),(1735,'1','275','1',1,'Retail Sale Id 1738',7499.05,0.00,0.00,10.79,140.27,'2022-07-29 09:14:00','',''),(1736,'1','275','1',1,'Retail Sale Id 1739',996.96,0.00,0.00,1.34,83.08,'2022-07-29 09:16:50','',''),(1737,'1','275','1',1,'Retail Sale Id 1740',139000.00,0.00,0.00,200.00,2600.00,'2022-07-29 09:42:11','',''),(1738,'1','275','1',1,'Retail Sale Id 1741',996.96,0.00,0.00,1.34,83.08,'2022-07-29 09:50:34','',''),(1739,'1','275','1',1,'Retail Sale Id 1742',2298.96,0.00,0.00,3.09,191.58,'2022-07-29 10:06:21','',''),(1740,'1','275','1',1,'Retail Sale Id 1743',2998.32,0.00,0.00,4.03,249.86,'2022-07-29 10:09:05','',''),(1741,'1','275','1',1,'Retail Sale Id 1744',2001.36,0.00,0.00,2.69,166.78,'2022-07-29 10:15:54','',''),(1742,'1','275','1',1,'Retail Sale Id 1745',9999.36,0.00,0.00,13.44,833.28,'2022-07-29 10:24:18','',''),(1743,'1','275','1',1,'Retail Sale Id 1746',1502.88,0.00,0.00,2.02,125.24,'2022-07-29 10:38:44','',''),(1744,'1','275','1',1,'Retail Sale Id 1747',4501.20,0.00,0.00,6.05,375.10,'2022-07-29 11:10:20','',''),(1745,'1','275','1',1,'Retail Sale Id 1748',20850.00,0.00,0.00,30.00,390.00,'2022-07-29 11:14:27','',''),(1746,'1','275','1',1,'Retail Sale Id 1749',3720.00,0.00,0.00,5.00,310.00,'2022-07-29 11:18:28','',''),(1747,'1','275','1',1,'Retail Sale Id 1750',9300.00,0.00,0.00,12.50,775.00,'2022-07-29 11:19:32','',''),(1748,'1','275','1',1,'Retail Sale Id 1752',18600.00,0.00,0.00,25.00,1550.00,'2022-07-29 11:37:58','',''),(1749,'1','275','1',1,'Retail Sale Id 1753',59770.00,0.00,0.00,86.00,1118.00,'2022-07-29 11:46:42','',''),(1750,'1','275','1',1,'Retail Sale Id 1754',1502.88,0.00,0.00,2.02,125.24,'2022-07-29 12:11:05','',''),(1751,'1','275','1',1,'Retail Sale Id 1755',9002.40,0.00,0.00,12.10,750.20,'2022-07-29 12:16:26','',''),(1752,'1','275','1',1,'Retail Sale Id 1756',2232.00,0.00,0.00,3.00,186.00,'2022-07-29 12:34:32','',''),(1753,'1','275','1',1,'Retail Sale Id 1756',9300.00,0.00,0.00,12.50,775.00,'2022-07-29 12:34:32','',''),(1754,'1','275','1',1,'Retail Sale Id 1757',104250.00,0.00,0.00,150.00,1950.00,'2022-07-29 12:36:50','',''),(1755,'1','275','1',1,'Retail Sale Id 1759',4002.72,0.00,0.00,5.38,333.56,'2022-07-29 13:06:25','',''),(1756,'1','275','1',1,'Retail Sale Id 1760',9300.00,0.00,0.00,12.50,775.00,'2022-07-29 13:17:12','',''),(1757,'1','275','1',1,'Retail Sale Id 1761',1502.88,0.00,0.00,2.02,125.24,'2022-07-29 14:27:36','',''),(1758,'1','275','1',1,'Retail Sale Id 1762',11815.00,0.00,0.00,17.00,221.00,'2022-07-29 14:29:18','',''),(1759,'1','275','1',1,'Retail Sale Id 1763',41700.00,0.00,0.00,60.00,780.00,'2022-07-29 14:54:34','',''),(1760,'1','275','1',1,'Retail Sale Id 1764',102860.00,0.00,0.00,148.00,1924.00,'2022-07-29 14:59:10','',''),(1761,'1','275','1',1,'Retail Sale Id 1765',7992.50,0.00,0.00,11.50,149.50,'2022-07-29 15:04:39','',''),(1762,'1','275','1',1,'Retail Sale Id 1766',9300.00,0.00,0.00,12.50,775.00,'2022-07-29 15:09:58','',''),(1763,'1','275','1',1,'Retail Sale Id 1767',24403.20,0.00,0.00,32.80,2033.60,'2022-07-29 17:00:51','',''),(1764,'1','275','1',1,'Retail Sale Id 1768',10821.15,0.00,0.00,15.57,202.41,'2022-07-29 17:04:17','',''),(1765,'1','275','1',1,'Distributed to Operational lost for sales id:9',29141.86,0.00,0.00,42.73,0.00,'2022-07-29 19:09:50','',''),(1766,'1','275',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3344950.00,5030.00,0.00,0.00,'2022-07-29 20:05:09','',''),(1767,'1','275',NULL,1,'Reception corrector for bridging 9',0.00,0.00,0.00,5030.00,0.00,'2022-07-29 20:06:10','',''),(1768,'1','275','1',1,'Received from bridging 9',0.00,0.00,5030.00,0.00,0.00,'2022-07-29 20:06:10','',''),(1769,'1','275','1',1,'Retail Sale Id 1769',134716.08,0.00,0.00,181.07,14304.53,'2022-07-29 20:07:28','',''),(1770,'1','275','1',1,'Retail Sale Id 1770',98356.40,0.00,0.00,141.52,4245.60,'2022-07-29 20:08:10','',''),(1771,'1','275','1',1,'Retail Sale Id 1772',5208.00,0.00,0.00,7.00,553.00,'2022-07-30 07:36:52','',''),(1772,'1','275','1',1,'Retail Sale Id 1772',9300.00,0.00,0.00,12.50,987.50,'2022-07-30 07:36:52','',''),(1773,'1','275','1',1,'Retail Sale Id 1773',2298.96,0.00,0.00,3.09,244.11,'2022-07-30 07:38:58','',''),(1774,'1','275','1',1,'Retail Sale Id 1774',34750.00,0.00,0.00,50.00,1500.00,'2022-07-30 07:44:51','',''),(1775,'1','275','1',1,'Retail Sale Id 1775',11160.00,0.00,0.00,15.00,1185.00,'2022-07-30 08:19:58','',''),(1776,'1','275','1',1,'Retail Sale Id 1776',9300.00,0.00,0.00,12.50,987.50,'2022-07-30 08:22:55','',''),(1777,'1','275','1',1,'Retail Sale Id 1777',4501.20,0.00,0.00,6.05,477.95,'2022-07-30 08:23:41','',''),(1778,'1','275','1',1,'Retail Sale Id 1778',9300.00,0.00,0.00,12.50,987.50,'2022-07-30 08:28:38','',''),(1779,'1','275','1',1,'Retail Sale Id 1779',7440.00,0.00,0.00,10.00,790.00,'2022-07-30 08:30:47','',''),(1780,'1','275','1',1,'Retail Sale Id 1780',9300.00,0.00,0.00,12.50,987.50,'2022-07-30 08:32:01','',''),(1781,'1','275','1',1,'Retail Sale Id 1781',9300.00,0.00,0.00,12.50,987.50,'2022-07-30 08:50:04','',''),(1782,'1','275','1',1,'Retail Sale Id 1782',4501.20,0.00,0.00,6.05,477.95,'2022-07-30 08:52:12','',''),(1783,'1','275','1',1,'Retail Sale Id 1783',9300.00,0.00,0.00,12.50,987.50,'2022-07-30 09:00:26','',''),(1784,'1','275','1',1,'Retail Sale Id 1784',9300.00,0.00,0.00,12.50,987.50,'2022-07-30 09:01:31','',''),(1785,'1','275','1',1,'Retail Sale Id 1785',2298.96,0.00,0.00,3.09,244.11,'2022-07-30 09:03:41','',''),(1786,'1','275','1',1,'Retail Sale Id 1786',28501.95,0.00,0.00,41.01,1230.30,'2022-07-30 09:06:13','',''),(1787,'1','275','1',1,'Retail Sale Id 1787',31275.00,0.00,0.00,45.00,1350.00,'2022-07-30 09:11:34','',''),(1788,'1','275','1',1,'Retail Sale Id 1788',9300.00,0.00,0.00,12.50,987.50,'2022-07-30 09:18:45','',''),(1789,'1','275','1',1,'Retail Sale Id 1789',2298.96,0.00,0.00,3.09,244.11,'2022-07-30 09:25:06','',''),(1790,'1','275','1',1,'Retail Sale Id 1790',52125.00,0.00,0.00,75.00,2250.00,'2022-07-30 09:40:32','',''),(1791,'1','275','1',1,'Retail Sale Id 1791',18600.00,0.00,0.00,25.00,1975.00,'2022-07-30 09:51:51','',''),(1792,'1','275','1',1,'Retail Sale Id 1792',4002.72,0.00,0.00,5.38,425.02,'2022-07-30 10:11:43','',''),(1793,'1','275','1',1,'Retail Sale Id 1793',7499.05,0.00,0.00,10.79,323.70,'2022-07-30 10:23:47','',''),(1794,'1','275','1',1,'Retail Sale Id 1794',34750.00,0.00,0.00,50.00,1500.00,'2022-07-30 10:35:16','',''),(1795,'1','275','1',1,'Retail Sale Id 1795',2998.32,0.00,0.00,4.03,318.37,'2022-07-30 10:54:32','',''),(1796,'1','275','1',1,'Retail Sale Id 1796',9300.00,0.00,0.00,12.50,987.50,'2022-07-30 11:01:33','',''),(1797,'1','275','1',1,'Retail Sale Id 1797',4999.68,0.00,0.00,6.72,530.88,'2022-07-30 11:02:43','',''),(1798,'1','275','1',1,'Retail Sale Id 1798',10425.00,0.00,0.00,15.00,450.00,'2022-07-30 11:07:08','',''),(1799,'1','275','1',1,'Retail Sale Id 1799',69500.00,0.00,0.00,100.00,3000.00,'2022-07-30 11:18:03','',''),(1800,'1','275','1',1,'Retail Sale Id 1800',9300.00,0.00,0.00,12.50,987.50,'2022-07-30 11:20:18','',''),(1801,'1','275','1',1,'Retail Sale Id 1801',4999.68,0.00,0.00,6.72,530.88,'2022-07-30 11:32:04','',''),(1802,'1','275','1',1,'Retail Sale Id 1802',10001.05,0.00,0.00,14.39,431.70,'2022-07-30 12:34:30','',''),(1803,'1','275','1',1,'Retail Sale Id 1803',9300.00,0.00,0.00,12.50,987.50,'2022-07-30 12:38:35','',''),(1804,'1','275','1',1,'Retail Sale Id 1804',9300.00,0.00,0.00,12.50,987.50,'2022-07-30 12:40:48','',''),(1805,'1','275','1',1,'Retail Sale Id 1805',102860.00,0.00,0.00,148.00,4440.00,'2022-07-30 12:43:23','',''),(1806,'1','275','1',1,'Retail Sale Id 1806',3199.20,0.00,0.00,4.30,339.70,'2022-07-30 12:44:16','',''),(1807,'1','275','1',1,'Retail Sale Id 1808',13503.60,0.00,0.00,18.15,1433.85,'2022-07-30 12:50:17','',''),(1808,'1','275','1',1,'Retail Sale Id 1809',9300.00,0.00,0.00,12.50,987.50,'2022-07-30 12:51:12','',''),(1809,'1','275','1',1,'Retail Sale Id 1810',9300.00,0.00,0.00,12.50,987.50,'2022-07-30 12:52:26','',''),(1810,'1','275','1',1,'Retail Sale Id 1811',3496.80,0.00,0.00,4.70,371.30,'2022-07-30 12:53:18','',''),(1811,'1','275','1',1,'Retail Sale Id 1812',9300.00,0.00,0.00,12.50,987.50,'2022-07-30 12:55:06','',''),(1812,'1','275','1',1,'Retail Sale Id 1813',18600.00,0.00,0.00,25.00,1975.00,'2022-07-30 13:02:02','',''),(1813,'1','275','1',1,'Retail Sale Id 1814',34750.00,0.00,0.00,50.00,1500.00,'2022-07-30 13:12:07','',''),(1814,'1','275','1',1,'Retail Sale Id 1815',9002.40,0.00,0.00,12.10,955.90,'2022-07-30 13:35:29','',''),(1815,'1','275','1',1,'Retail Sale Id 1816',37200.00,0.00,0.00,50.00,3950.00,'2022-07-30 13:38:03','',''),(1816,'1','275','1',1,'Retail Sale Id 1817',9300.00,0.00,0.00,12.50,987.50,'2022-07-30 13:47:53','',''),(1817,'1','275','1',1,'Retail Sale Id 1818',3720.00,0.00,0.00,5.00,395.00,'2022-07-30 14:00:30','',''),(1818,'1','275','1',1,'Retail Sale Id 1819',9300.00,0.00,0.00,12.50,987.50,'2022-07-30 14:03:52','',''),(1819,'1','275','1',1,'Retail Sale Id 1820',9300.00,0.00,0.00,12.50,987.50,'2022-07-30 14:10:17','',''),(1820,'1','275','1',1,'Retail Sale Id 1821',7001.04,0.00,0.00,9.41,743.39,'2022-07-30 14:13:20','',''),(1821,'1','275','1',1,'Retail Sale Id 1822',2001.36,0.00,0.00,2.69,212.51,'2022-07-30 14:24:50','',''),(1822,'1','275','1',1,'Retail Sale Id 1822',9300.00,0.00,0.00,12.50,987.50,'2022-07-30 14:24:50','',''),(1823,'1','275','1',1,'Retail Sale Id 1823',71585.00,0.00,0.00,103.00,3090.00,'2022-07-30 14:27:33','',''),(1824,'1','275','1',1,'Retail Sale Id 1824',2001.36,0.00,0.00,2.69,212.51,'2022-07-30 14:48:02','',''),(1825,'1','275','1',1,'Retail Sale Id 1825',8184.00,0.00,0.00,11.00,869.00,'2022-07-30 14:51:22','',''),(1826,'1','275','1',1,'Retail Sale Id 1826',14595.00,0.00,0.00,21.00,630.00,'2022-07-30 14:59:22','',''),(1827,'1','275','1',1,'Retail Sale Id 1827',2246.88,0.00,0.00,3.02,238.58,'2022-07-30 15:00:48','',''),(1828,'1','275','1',1,'Retail Sale Id 1828',751.44,0.00,0.00,1.01,79.79,'2022-07-30 15:28:28','',''),(1829,'1','275','1',1,'Retail Sale Id 1829',30003.15,0.00,0.00,43.17,1295.10,'2022-07-30 16:15:16','',''),(1830,'1','275','1',1,'Retail Sale Id 1830',7998.00,0.00,0.00,10.75,849.25,'2022-07-30 16:19:55','',''),(1831,'1','275','1',1,'Retail Sale Id 1831',25902.65,0.00,0.00,37.27,1118.10,'2022-07-30 17:05:58','',''),(1832,'1','275','1',1,'Retail Sale Id 1832',15637.50,0.00,0.00,22.50,675.00,'2022-07-30 18:59:04','',''),(1833,'1','275','1',1,'Retail Sale Id 1833',67711.44,0.00,0.00,91.01,7189.79,'2022-07-30 19:16:55','',''),(1834,'1','275','1',1,'Retail Sale Id 1834',98293.85,0.00,0.00,141.43,4242.90,'2022-07-30 19:17:51','',''),(1835,'1','275','1',1,'Retail Sale Id 1835',34750.00,0.00,0.00,50.00,1500.00,'2022-07-31 07:00:27','',''),(1836,'1','275','1',1,'Retail Sale Id 1836',11001.85,0.00,0.00,15.83,474.90,'2022-07-31 07:13:07','',''),(1837,'1','275','1',1,'Retail Sale Id 1837',9300.00,0.00,0.00,12.50,987.50,'2022-07-31 07:14:31','',''),(1838,'1','275','1',1,'Retail Sale Id 1838',2001.36,0.00,0.00,2.69,212.51,'2022-07-31 07:53:06','',''),(1839,'1','275','1',1,'Retail Sale Id 1839',2998.32,0.00,0.00,4.03,318.37,'2022-07-31 08:03:29','',''),(1840,'1','275','1',1,'Retail Sale Id 1840',2298.96,0.00,0.00,3.09,244.11,'2022-07-31 08:20:36','',''),(1841,'1','275','1',1,'Retail Sale Id 1841',2001.36,0.00,0.00,2.69,212.51,'2022-07-31 08:22:28','',''),(1842,'1','275','1',1,'Retail Sale Id 1842',803.52,0.00,0.00,1.08,85.32,'2022-07-31 08:29:26','',''),(1843,'1','275','1',1,'Retail Sale Id 1843',3720.00,0.00,0.00,5.00,395.00,'2022-07-31 08:35:13','',''),(1844,'1','275','1',1,'Retail Sale Id 1843',9300.00,0.00,0.00,12.50,987.50,'2022-07-31 08:35:13','',''),(1845,'1','275','1',1,'Retail Sale Id 1844',9300.00,0.00,0.00,12.50,987.50,'2022-07-31 08:40:59','',''),(1846,'1','275','1',1,'Retail Sale Id 1845',17000.40,0.00,0.00,22.85,1805.15,'2022-07-31 08:48:57','',''),(1847,'1','275','1',1,'Retail Sale Id 1846',1502.88,0.00,0.00,2.02,159.58,'2022-07-31 08:50:28','',''),(1848,'1','275','1',1,'Retail Sale Id 1847',996.96,0.00,0.00,1.34,105.86,'2022-07-31 08:57:16','',''),(1849,'1','275','1',1,'Retail Sale Id 1848',9300.00,0.00,0.00,12.50,987.50,'2022-07-31 09:20:54','',''),(1850,'1','275','1',1,'Retail Sale Id 1849',2001.36,0.00,0.00,2.69,212.51,'2022-07-31 09:27:10','',''),(1851,'1','275','1',1,'Retail Sale Id 1850',4464.00,0.00,0.00,6.00,474.00,'2022-07-31 09:28:57','',''),(1852,'1','275','1',1,'Retail Sale Id 1851',4650.00,0.00,0.00,6.25,493.75,'2022-07-31 09:31:26','',''),(1853,'1','275','1',1,'Retail Sale Id 1852',2998.32,0.00,0.00,4.03,318.37,'2022-07-31 09:33:09','',''),(1854,'1','275','1',1,'Retail Sale Id 1853',5208.00,0.00,0.00,7.00,553.00,'2022-07-31 09:39:27','',''),(1855,'1','275','1',1,'Retail Sale Id 1854',3720.00,0.00,0.00,5.00,395.00,'2022-07-31 09:48:13','',''),(1856,'1','275','1',1,'Retail Sale Id 1855',1502.88,0.00,0.00,2.02,159.58,'2022-07-31 11:01:12','',''),(1857,'1','275','1',1,'Retail Sale Id 1856',34750.00,0.00,0.00,50.00,1500.00,'2022-07-31 11:07:09','',''),(1858,'1','275','1',1,'Retail Sale Id 1857',9300.00,0.00,0.00,12.50,987.50,'2022-07-31 11:22:53','',''),(1859,'1','275','1',1,'Retail Sale Id 1858',32665.00,0.00,0.00,47.00,1410.00,'2022-07-31 11:36:27','',''),(1860,'1','275','1',1,'Retail Sale Id 1859',2499.84,0.00,0.00,3.36,265.44,'2022-07-31 12:07:09','',''),(1861,'1','275','1',1,'Retail Sale Id 1860',4002.72,0.00,0.00,5.38,425.02,'2022-07-31 12:20:07','',''),(1862,'1','275','1',1,'Retail Sale Id 1861',1502.88,0.00,0.00,2.02,159.58,'2022-07-31 12:25:20','',''),(1863,'1','275','1',1,'Retail Sale Id 1862',136220.00,0.00,0.00,196.00,5880.00,'2022-07-31 12:30:00','',''),(1864,'1','275','1',1,'Retail Sale Id 1863',751.44,0.00,0.00,1.01,79.79,'2022-07-31 12:30:58','',''),(1865,'1','275','1',1,'Retail Sale Id 1864',1502.88,0.00,0.00,2.02,159.58,'2022-07-31 12:31:46','',''),(1866,'1','275','1',1,'Retail Sale Id 1865',1502.88,0.00,0.00,2.02,159.58,'2022-07-31 12:37:52','',''),(1867,'1','275','1',1,'Retail Sale Id 1866',9300.00,0.00,0.00,12.50,987.50,'2022-07-31 12:41:53','',''),(1868,'1','275','1',1,'Retail Sale Id 1867',996.96,0.00,0.00,1.34,105.86,'2022-07-31 12:47:09','',''),(1869,'1','275','1',1,'Retail Sale Id 1868',37200.00,0.00,0.00,50.00,3950.00,'2022-07-31 12:49:14','',''),(1870,'1','275','1',1,'Retail Sale Id 1869',9300.00,0.00,0.00,12.50,987.50,'2022-07-31 12:55:05','',''),(1871,'1','275','1',1,'Retail Sale Id 1870',4501.20,0.00,0.00,6.05,477.95,'2022-07-31 13:02:10','',''),(1872,'1','275','1',1,'Retail Sale Id 1871',2998.32,0.00,0.00,4.03,318.37,'2022-07-31 13:07:19','',''),(1873,'1','275','1',1,'Retail Sale Id 1872',4002.72,0.00,0.00,5.38,425.02,'2022-07-31 13:14:05','',''),(1874,'1','275','1',1,'Retail Sale Id 1873',5996.64,0.00,0.00,8.06,636.74,'2022-07-31 13:16:03','',''),(1875,'1','275','1',1,'Retail Sale Id 1874',9999.36,0.00,0.00,13.44,1061.76,'2022-07-31 13:19:14','',''),(1876,'1','275','1',1,'Retail Sale Id 1875',102860.00,0.00,0.00,148.00,4440.00,'2022-07-31 13:23:21','',''),(1877,'1','275','1',1,'Retail Sale Id 1876',7998.00,0.00,0.00,10.75,849.25,'2022-07-31 13:25:28','',''),(1878,'1','275','1',1,'Retail Sale Id 1877',136220.00,0.00,0.00,196.00,5880.00,'2022-07-31 13:32:44','',''),(1879,'1','275','1',1,'Retail Sale Id 1878',6696.00,0.00,0.00,9.00,711.00,'2022-07-31 13:35:22','',''),(1880,'1','275','1',1,'Retail Sale Id 1879',4999.68,0.00,0.00,6.72,530.88,'2022-07-31 13:36:31','',''),(1881,'1','275','1',1,'Retail Sale Id 1880',2001.36,0.00,0.00,2.69,212.51,'2022-07-31 13:40:05','',''),(1882,'1','275','1',1,'Retail Sale Id 1881',9300.00,0.00,0.00,12.50,987.50,'2022-07-31 13:41:25','',''),(1883,'1','275','1',1,'Retail Sale Id 1882',4002.72,0.00,0.00,5.38,425.02,'2022-07-31 13:48:54','',''),(1884,'1','275','1',1,'Retail Sale Id 1883',1101.12,0.00,0.00,1.48,116.92,'2022-07-31 13:55:28','',''),(1885,'1','275','1',1,'Retail Sale Id 1884',1153.20,0.00,0.00,1.55,122.45,'2022-07-31 13:56:25','',''),(1886,'1','275','1',1,'Retail Sale Id 1885',2298.96,0.00,0.00,3.09,244.11,'2022-07-31 13:58:06','',''),(1887,'1','275','1',1,'Retail Sale Id 1886',4501.20,0.00,0.00,6.05,477.95,'2022-07-31 14:11:39','',''),(1888,'1','275','1',1,'Retail Sale Id 1887',4501.20,0.00,0.00,6.05,477.95,'2022-07-31 14:34:02','',''),(1889,'1','275','1',1,'Retail Sale Id 1888',9300.00,0.00,0.00,12.50,987.50,'2022-07-31 14:46:21','',''),(1890,'1','275','1',1,'Retail Sale Id 1889',17375.00,0.00,0.00,25.00,750.00,'2022-07-31 14:48:11','',''),(1891,'1','275','1',1,'Retail Sale Id 1890',9300.00,0.00,0.00,12.50,987.50,'2022-07-31 14:52:52','',''),(1892,'1','275','1',1,'Retail Sale Id 1891',4501.20,0.00,0.00,6.05,477.95,'2022-07-31 14:58:27','',''),(1893,'1','275','1',1,'Retail Sale Id 1892',69500.00,0.00,0.00,100.00,3000.00,'2022-07-31 15:14:49','',''),(1894,'1','275','1',1,'Retail Sale Id 1893',2298.96,0.00,0.00,3.09,244.11,'2022-07-31 15:36:01','',''),(1895,'1','275','1',1,'Retail Sale Id 1894',32998.60,0.00,0.00,47.48,1424.40,'2022-07-31 15:44:19','',''),(1896,'1','275','1',1,'Retail Sale Id 1895',3720.00,0.00,0.00,5.00,395.00,'2022-07-31 15:49:50','',''),(1897,'1','275','1',1,'Retail Sale Id 1896',1502.88,0.00,0.00,2.02,159.58,'2022-07-31 16:13:04','',''),(1898,'1','275','1',1,'Retail Sale Id 1897',1502.88,0.00,0.00,2.02,159.58,'2022-07-31 16:33:06','',''),(1899,'1','275','1',1,'Retail Sale Id 1898',18600.00,0.00,0.00,25.00,1975.00,'2022-07-31 16:34:12','',''),(1900,'1','275','1',1,'Retail Sale Id 1899',9300.00,0.00,0.00,12.50,987.50,'2022-07-31 16:37:00','',''),(1901,'1','275','1',1,'Retail Sale Id 1900',3839.04,0.00,0.00,5.16,407.64,'2022-07-31 16:57:46','',''),(1902,'1','275','1',1,'Retail Sale Id 1900',11160.00,0.00,0.00,15.00,1185.00,'2022-07-31 16:57:46','',''),(1903,'1','275','1',1,'Retail Sale Id 1901',4501.20,0.00,0.00,6.05,477.95,'2022-07-31 17:40:20','',''),(1904,'1','275','1',1,'Retail Sale Id 1902',4002.72,0.00,0.00,5.38,425.02,'2022-07-31 17:52:39','',''),(1905,'1','275','1',1,'Retail Sale Id 1903',9300.00,0.00,0.00,12.50,987.50,'2022-07-31 17:59:31','',''),(1906,'1','275','1',1,'Retail Sale Id 1904',803.52,0.00,0.00,1.08,85.32,'2022-07-31 18:01:13','',''),(1907,'1','275','1',1,'Retail Sale Id 1905',4501.20,0.00,0.00,6.05,477.95,'2022-07-31 18:04:02','',''),(1908,'1','275','1',1,'Retail Sale Id 1906',1398.72,0.00,0.00,1.88,148.52,'2022-07-31 18:05:32','',''),(1909,'1','275','1',1,'Retail Sale Id 1907',9002.40,0.00,0.00,12.10,955.90,'2022-07-31 18:16:11','',''),(1910,'1','275','1',1,'Retail Sale Id 1908',1599.60,0.00,0.00,2.15,169.85,'2022-07-31 18:22:59','',''),(1911,'1','275','1',1,'Retail Sale Id 1909',4999.68,0.00,0.00,6.72,530.88,'2022-07-31 18:39:59','',''),(1912,'1','275','1',1,'Retail Sale Id 1910',2298.96,0.00,0.00,3.09,244.11,'2022-07-31 18:41:40','',''),(1913,'1','275','1',1,'Retail Sale Id 1910',9002.40,0.00,0.00,12.10,955.90,'2022-07-31 18:41:40','',''),(1914,'1','275','1',1,'Retail Sale Id 1911',9300.00,0.00,0.00,12.50,987.50,'2022-07-31 18:44:47','',''),(1915,'1','275','1',1,'Retail Sale Id 1912',4501.20,0.00,0.00,6.05,477.95,'2022-07-31 18:46:41','',''),(1916,'1','275','1',1,'Retail Sale Id 1913',4501.20,0.00,0.00,6.05,477.95,'2022-07-31 18:54:23','',''),(1917,'1','275','1',1,'Retail Sale Id 1914',2001.36,0.00,0.00,2.69,212.51,'2022-07-31 18:55:20','',''),(1918,'1','275','1',1,'Retail Sale Id 1915',12231.36,0.00,0.00,16.44,1298.76,'2022-07-31 19:17:49','',''),(1919,'1','275','1',1,'Retail Sale Id 1916',101275.40,0.00,0.00,145.72,4371.60,'2022-07-31 19:20:55','',''),(1920,'1','275','1',1,'Retail Sale Id 1917',9300.00,0.00,0.00,12.50,987.50,'2022-08-01 07:39:24','',''),(1921,'1','275','1',1,'Retail Sale Id 1918',9300.00,0.00,0.00,12.50,987.50,'2022-08-01 07:52:57','',''),(1922,'1','275','1',1,'Retail Sale Id 1919',9300.00,0.00,0.00,12.50,987.50,'2022-08-01 08:06:54','',''),(1923,'1','275','1',1,'Retail Sale Id 1920',38225.00,0.00,0.00,55.00,1650.00,'2022-08-01 08:25:31','',''),(1924,'1','275','1',1,'Retail Sale Id 1921',34750.00,0.00,0.00,50.00,1500.00,'2022-08-01 08:26:49','',''),(1925,'1','275','1',1,'Retail Sale Id 1922',900.24,0.00,0.00,1.21,95.59,'2022-08-01 08:43:54','',''),(1926,'1','275','1',1,'Retail Sale Id 1923',1860.00,0.00,0.00,2.50,197.50,'2022-08-01 08:56:02','',''),(1927,'1','275','1',1,'Retail Sale Id 1924',9300.00,0.00,0.00,12.50,987.50,'2022-08-01 08:57:54','',''),(1928,'1','275','1',1,'Retail Sale Id 1925',9300.00,0.00,0.00,12.50,987.50,'2022-08-01 09:02:13','',''),(1929,'1','275','1',1,'Retail Sale Id 1926',9300.00,0.00,0.00,12.50,987.50,'2022-08-01 09:09:07','',''),(1930,'1','275','1',1,'Retail Sale Id 1927',34750.00,0.00,0.00,50.00,1500.00,'2022-08-01 09:40:19','',''),(1931,'1','275','1',1,'Retail Sale Id 1928',9300.00,0.00,0.00,12.50,987.50,'2022-08-01 09:44:40','',''),(1932,'1','275','1',1,'Retail Sale Id 1929',9300.00,0.00,0.00,12.50,987.50,'2022-08-01 09:46:37','',''),(1933,'1','275','1',1,'Retail Sale Id 1930',9300.00,0.00,0.00,12.50,987.50,'2022-08-01 10:10:32','',''),(1934,'1','275','1',1,'Retail Sale Id 1931',139000.00,0.00,0.00,200.00,6000.00,'2022-08-01 10:15:42','',''),(1935,'1','275','1',1,'Retail Sale Id 1932',14880.00,0.00,0.00,20.00,1580.00,'2022-08-01 10:16:58','',''),(1936,'1','275','1',1,'Retail Sale Id 1933',9300.00,0.00,0.00,12.50,987.50,'2022-08-01 10:41:17','',''),(1937,'1','275','1',1,'Retail Sale Id 1934',4501.20,0.00,0.00,6.05,477.95,'2022-08-01 10:43:37','',''),(1938,'1','275','1',1,'Retail Sale Id 1935',21996.75,0.00,0.00,31.65,949.50,'2022-08-01 11:04:07','',''),(1939,'1','275','1',1,'Retail Sale Id 1936',7440.00,0.00,0.00,10.00,790.00,'2022-08-01 11:30:49','',''),(1940,'1','275','1',1,'Retail Sale Id 1937',14136.00,0.00,0.00,19.00,1501.00,'2022-08-01 11:51:06','',''),(1941,'1','275','1',1,'Retail Sale Id 1938',996.96,0.00,0.00,1.34,105.86,'2022-08-01 11:59:24','',''),(1942,'1','275','1',1,'Retail Sale Id 1939',2298.96,0.00,0.00,3.09,244.11,'2022-08-01 12:24:55','',''),(1943,'1','275','1',1,'Retail Sale Id 1940',9300.00,0.00,0.00,12.50,987.50,'2022-08-01 12:44:33','',''),(1944,'1','275','1',1,'Retail Sale Id 1941',2298.96,0.00,0.00,3.09,244.11,'2022-08-01 12:50:14','',''),(1945,'1','275','1',1,'Retail Sale Id 1942',4501.20,0.00,0.00,6.05,477.95,'2022-08-01 13:22:34','',''),(1946,'1','275','1',1,'Retail Sale Id 1943',4999.68,0.00,0.00,6.72,530.88,'2022-08-01 13:25:27','',''),(1947,'1','275','1',1,'Retail Sale Id 1945',1800.48,0.00,0.00,2.42,191.18,'2022-08-01 13:35:21','',''),(1948,'1','275','1',1,'Retail Sale Id 1946',5996.64,0.00,0.00,8.06,636.74,'2022-08-01 13:49:30','',''),(1949,'1','275','1',1,'Retail Sale Id 1947',16368.00,0.00,0.00,22.00,1738.00,'2022-08-01 13:53:06','',''),(1950,'1','275','1',1,'Retail Sale Id 1948',2499.84,0.00,0.00,3.36,265.44,'2022-08-01 13:58:10','',''),(1951,'1','275','1',1,'Retail Sale Id 1949',2298.96,0.00,0.00,3.09,244.11,'2022-08-01 13:58:58','',''),(1952,'1','275','1',1,'Retail Sale Id 1950',803.52,0.00,0.00,1.08,85.32,'2022-08-01 14:32:29','',''),(1953,'1','275','1',1,'Retail Sale Id 1951',9300.00,0.00,0.00,12.50,987.50,'2022-08-01 14:52:51','',''),(1954,'1','275','1',1,'Retail Sale Id 1952',9300.00,0.00,0.00,12.50,987.50,'2022-08-01 14:54:47','',''),(1955,'1','275','1',1,'Retail Sale Id 1953',9300.00,0.00,0.00,12.50,987.50,'2022-08-01 15:00:17','',''),(1956,'1','275','1',1,'Retail Sale Id 1954',71585.00,0.00,0.00,103.00,3090.00,'2022-08-01 15:01:44','',''),(1957,'1','275','1',1,'Retail Sale Id 1955',12002.65,0.00,0.00,17.27,518.10,'2022-08-01 16:36:36','',''),(1958,'1','275','1',1,'Retail Sale Id 1956',2998.32,0.00,0.00,4.03,318.37,'2022-08-01 16:40:00','',''),(1959,'1','275','1',1,'Retail Sale Id 1956',17000.40,0.00,0.00,22.85,1805.15,'2022-08-01 16:40:00','',''),(1960,'1','275','1',1,'Retail Sale Id 1957',2298.96,0.00,0.00,3.09,244.11,'2022-08-01 16:41:27','',''),(1961,'1','275','1',1,'Retail Sale Id 1958',9300.00,0.00,0.00,12.50,987.50,'2022-08-01 16:47:05','',''),(1962,'1','275','1',1,'Retail Sale Id 1959',9300.00,0.00,0.00,12.50,987.50,'2022-08-01 16:56:56','',''),(1963,'1','275','1',1,'Retail Sale Id 1960',2001.36,0.00,0.00,2.69,212.51,'2022-08-01 17:03:04','',''),(1964,'1','275','1',1,'Retail Sale Id 1961',15985.00,0.00,0.00,23.00,690.00,'2022-08-01 17:08:30','',''),(1965,'1','275','1',1,'Retail Sale Id 1962',4002.72,0.00,0.00,5.38,425.02,'2022-08-01 17:10:19','',''),(1966,'1','275','1',1,'Retail Sale Id 1963',3720.00,0.00,0.00,5.00,395.00,'2022-08-01 17:30:30','',''),(1967,'1','275','1',1,'Retail Sale Id 1964',9300.00,0.00,0.00,12.50,987.50,'2022-08-01 17:32:52','',''),(1968,'1','275','1',1,'Retail Sale Id 1965',9300.00,0.00,0.00,12.50,987.50,'2022-08-01 17:38:28','',''),(1969,'1','275','1',1,'Retail Sale Id 1966',4397.04,0.00,0.00,5.91,466.89,'2022-08-01 17:42:05','',''),(1970,'1','275','1',1,'Retail Sale Id 1966',9300.00,0.00,0.00,12.50,987.50,'2022-08-01 17:42:05','',''),(1971,'1','275','1',1,'Retail Sale Id 1967',9300.00,0.00,0.00,12.50,987.50,'2022-08-01 17:43:18','',''),(1972,'1','275','1',1,'Retail Sale Id 1968',2298.96,0.00,0.00,3.09,244.11,'2022-08-01 17:44:16','',''),(1973,'1','275','1',1,'Retail Sale Id 1969',2998.32,0.00,0.00,4.03,318.37,'2022-08-01 17:45:06','',''),(1974,'1','275','1',1,'Retail Sale Id 1970',37200.00,0.00,0.00,50.00,3950.00,'2022-08-01 17:50:33','',''),(1975,'1','275','1',1,'Retail Sale Id 1971',28495.00,0.00,0.00,41.00,1230.00,'2022-08-01 18:13:36','',''),(1976,'1','275','1',1,'Retail Sale Id 1972',2001.36,0.00,0.00,2.69,212.51,'2022-08-01 18:17:58','',''),(1977,'1','275','1',1,'Retail Sale Id 1973',4501.20,0.00,0.00,6.05,477.95,'2022-08-01 18:18:57','',''),(1978,'1','275','1',1,'Retail Sale Id 1974',2499.84,0.00,0.00,3.36,265.44,'2022-08-01 18:28:14','',''),(1979,'1','275','1',1,'Retail Sale Id 1975',7645.00,0.00,0.00,11.00,330.00,'2022-08-01 18:39:54','',''),(1980,'1','275','1',1,'Retail Sale Id 1976',13020.00,0.00,0.00,17.50,1382.50,'2022-08-01 18:46:49','',''),(1981,'1','275','1',1,'Retail Sale Id 1977',2998.32,0.00,0.00,4.03,318.37,'2022-08-01 18:49:51','',''),(1982,'1','275','1',1,'Retail Sale Id 1978',996.96,0.00,0.00,1.34,105.86,'2022-08-01 18:51:23','',''),(1983,'1','275','1',1,'Retail Sale Id 1979',2298.96,0.00,0.00,3.09,244.11,'2022-08-01 18:52:27','',''),(1984,'1','275','1',1,'Retail Sale Id 1980',9300.00,0.00,0.00,12.50,987.50,'2022-08-01 18:55:36','',''),(1985,'1','275','1',1,'Retail Sale Id 1981',2298.96,0.00,0.00,3.09,244.11,'2022-08-01 18:57:11','',''),(1986,'1','275','1',1,'Retail Sale Id 1982',31649.76,0.00,0.00,42.54,3360.66,'2022-08-01 19:55:36','',''),(1987,'1','275','1',1,'Retail Sale Id 1983',65733.10,0.00,0.00,94.58,2837.40,'2022-08-01 19:57:50','',''),(1988,'1','275','1',1,'Retail Sale Id 1984',3720.00,0.00,0.00,5.00,395.00,'2022-08-02 07:10:10','',''),(1989,'1','275','1',1,'Retail Sale Id 1985',15985.00,0.00,0.00,23.00,690.00,'2022-08-02 07:13:32','',''),(1990,'1','275','1',1,'Retail Sale Id 1986',19460.00,0.00,0.00,28.00,840.00,'2022-08-02 07:30:08','',''),(1991,'1','275','1',1,'Retail Sale Id 1987',34750.00,0.00,0.00,50.00,1500.00,'2022-08-02 07:35:20','',''),(1992,'1','275','1',1,'Retail Sale Id 1988',3720.00,0.00,0.00,5.00,395.00,'2022-08-02 07:36:36','',''),(1993,'1','275','1',1,'Retail Sale Id 1989',18600.00,0.00,0.00,25.00,1975.00,'2022-08-02 07:47:26','',''),(1994,'1','275','1',1,'Retail Sale Id 1990',18600.00,0.00,0.00,25.00,1975.00,'2022-08-02 07:49:05','',''),(1995,'1','275','1',1,'Retail Sale Id 1990',37200.00,0.00,0.00,50.00,3950.00,'2022-08-02 07:49:05','',''),(1996,'1','275','1',1,'Retail Sale Id 1991',27000.75,0.00,0.00,38.85,1165.50,'2022-08-02 08:01:59','',''),(1997,'1','275','1',1,'Retail Sale Id 1992',34750.00,0.00,0.00,50.00,1500.00,'2022-08-02 08:14:59','',''),(1998,'1','275','1',1,'Retail Sale Id 1993',19299.36,0.00,0.00,25.94,2049.26,'2022-08-02 08:55:17','',''),(1999,'1','275','1',1,'Retail Sale Id 1994',5101.30,0.00,0.00,7.34,220.20,'2022-08-02 08:56:46','',''),(2000,'1','275',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3657.50,5.50,0.00,0.00,'2022-08-02 09:08:54','',''),(2001,'1','275',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,5.50,0.00,'2022-08-02 09:09:51','',''),(2002,'1','275','1',1,'Received from bridging 10',0.00,0.00,5.50,0.00,0.00,'2022-08-02 09:09:51','',''),(2003,'1','275','1',1,'Retail Sale Id 1995',3822.50,0.00,0.00,5.50,165.00,'2022-08-02 09:12:02','',''),(2004,'1','275',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3444700.00,5180.00,0.00,0.00,'2022-08-02 11:41:27','',''),(2005,'1','275',NULL,1,'Reception corrector for bridging 11',0.00,0.00,0.00,5180.00,0.00,'2022-08-02 11:42:26','',''),(2006,'1','275','1',1,'Received from bridging 11',0.00,0.00,5180.00,0.00,0.00,'2022-08-02 11:42:26','',''),(2007,'1','275','1',1,'Retail Sale Id 1996',18600.00,0.00,0.00,25.00,1975.00,'2022-08-02 11:52:39','',''),(2008,'1','275','1',1,'Retail Sale Id 1997',4501.20,0.00,0.00,6.05,477.95,'2022-08-02 11:59:43','',''),(2009,'1','275','1',1,'Retail Sale Id 1998',4501.20,0.00,0.00,6.05,477.95,'2022-08-02 12:03:55','',''),(2010,'1','275','1',1,'Retail Sale Id 1999',3720.00,0.00,0.00,5.00,395.00,'2022-08-02 12:09:52','',''),(2011,'1','275','1',1,'Retail Sale Id 2000',9300.00,0.00,0.00,12.50,987.50,'2022-08-02 12:17:37','',''),(2012,'1','275','1',1,'Retail Sale Id 2001',1502.88,0.00,0.00,2.02,159.58,'2022-08-02 12:18:27','',''),(2013,'1','275','1',1,'Retail Sale Id 2002',996.96,0.00,0.00,1.34,105.86,'2022-08-02 12:19:06','',''),(2014,'1','275','1',1,'Retail Sale Id 2003',9300.00,0.00,0.00,12.50,987.50,'2022-08-02 12:35:57','',''),(2015,'1','275','1',1,'Retail Sale Id 2004',16680.00,0.00,0.00,24.00,720.00,'2022-08-02 12:37:33','',''),(2016,'1','275','1',1,'Retail Sale Id 2005',1502.88,0.00,0.00,2.02,159.58,'2022-08-02 12:38:16','',''),(2017,'1','275','1',1,'Retail Sale Id 2007',294200.45,0.00,0.00,423.31,12699.30,'2022-08-02 14:53:04','',''),(2018,'1','275','1',1,'Retail Sale Id 2008',1800.48,0.00,0.00,2.42,191.18,'2022-08-02 15:14:54','',''),(2019,'1','275','1',1,'Return of Retail Sale Id 2008',0.00,1800.48,2.42,0.00,-191.18,'2022-08-02 15:16:49','',''),(2020,'1','275','1',1,'Retail Sale Id 2011',1502.88,0.00,0.00,2.02,159.58,'2022-08-02 15:20:11','',''),(2021,'1','275','1',1,'Retail Sale Id 2012',8496.48,0.00,0.00,11.42,902.18,'2022-08-02 15:29:37','',''),(2022,'1','275','1',1,'Retail Sale Id 2013',9300.00,0.00,0.00,12.50,987.50,'2022-08-02 16:35:34','',''),(2023,'1','275','1',1,'Retail Sale Id 2014',9300.00,0.00,0.00,12.50,987.50,'2022-08-02 16:38:22','',''),(2024,'1','275','1',1,'Retail Sale Id 2015',4002.72,0.00,0.00,5.38,425.02,'2022-08-02 16:44:23','',''),(2025,'1','275','1',1,'Retail Sale Id 2016',4501.20,0.00,0.00,6.05,477.95,'2022-08-02 17:17:14','',''),(2026,'1','275','1',1,'Retail Sale Id 2017',2499.84,0.00,0.00,3.36,265.44,'2022-08-02 17:21:44','',''),(2027,'1','275','1',1,'Retail Sale Id 2018',2001.36,0.00,0.00,2.69,212.51,'2022-08-02 17:27:31','',''),(2028,'1','275','1',1,'Retail Sale Id 2019',9300.00,0.00,0.00,12.50,987.50,'2022-08-02 17:32:19','',''),(2029,'1','275','1',1,'Retail Sale Id 2020',3697.68,0.00,0.00,4.97,392.63,'2022-08-02 17:33:24','',''),(2030,'1','275','1',1,'Retail Sale Id 2021',4002.72,0.00,0.00,5.38,425.02,'2022-08-02 17:36:27','',''),(2031,'1','275','1',1,'Retail Sale Id 2022',2298.96,0.00,0.00,3.09,244.11,'2022-08-02 17:37:29','',''),(2032,'1','275','1',1,'Retail Sale Id 2023',7499.52,0.00,0.00,10.08,796.32,'2022-08-02 17:43:27','',''),(2033,'1','275','1',1,'Retail Sale Id 2024',9300.00,0.00,0.00,12.50,987.50,'2022-08-02 17:46:28','',''),(2034,'1','275','1',1,'Retail Sale Id 2025',5699.04,0.00,0.00,7.66,605.14,'2022-08-02 17:50:02','',''),(2035,'1','275','1',1,'Retail Sale Id 2025',9300.00,0.00,0.00,12.50,987.50,'2022-08-02 17:50:02','',''),(2036,'1','275','1',1,'Retail Sale Id 2026',4501.20,0.00,0.00,6.05,477.95,'2022-08-02 17:52:31','',''),(2037,'1','275','1',1,'Retail Sale Id 2027',8928.00,0.00,0.00,12.00,948.00,'2022-08-02 17:54:38','',''),(2038,'1','275','1',1,'Retail Sale Id 2028',9002.40,0.00,0.00,12.10,955.90,'2022-08-02 18:19:38','',''),(2039,'1','275','1',1,'Retail Sale Id 2029',2001.36,0.00,0.00,2.69,212.51,'2022-08-02 18:20:40','',''),(2040,'1','275','1',1,'Retail Sale Id 2030',9300.00,0.00,0.00,12.50,987.50,'2022-08-02 18:25:08','',''),(2041,'1','275','1',1,'Retail Sale Id 2031',9300.00,0.00,0.00,12.50,987.50,'2022-08-02 18:50:53','',''),(2042,'1','275','1',1,'Retail Sale Id 2032',9300.00,0.00,0.00,12.50,987.50,'2022-08-02 18:56:35','',''),(2043,'1','275','1',1,'Retail Sale Id 2033',9300.00,0.00,0.00,12.50,987.50,'2022-08-02 19:00:56','',''),(2044,'1','275','1',1,'Retail Sale Id 2034',7998.00,0.00,0.00,10.75,849.25,'2022-08-02 19:01:52','',''),(2045,'1','275','1',1,'Retail Sale Id 2035',148800.00,0.00,0.00,200.00,15800.00,'2022-08-02 19:38:38','',''),(2046,'1','275','1',1,'Retail Sale Id 2036',160108.80,0.00,0.00,215.20,17000.80,'2022-08-02 19:40:03','',''),(2047,'1','275','1',1,'Retail Sale Id 2037',2298.96,0.00,0.00,3.09,244.11,'2022-08-03 08:04:26','',''),(2048,'1','275','1',1,'Retail Sale Id 2038',2001.36,0.00,0.00,2.69,212.51,'2022-08-03 08:17:38','',''),(2049,'1','275','1',1,'Retail Sale Id 2039',2998.32,0.00,0.00,4.03,318.37,'2022-08-03 08:19:10','',''),(2050,'1','275','1',1,'Retail Sale Id 2040',9300.00,0.00,0.00,12.50,987.50,'2022-08-03 08:27:42','',''),(2051,'1','275','1',1,'Retail Sale Id 2041',2998.32,0.00,0.00,4.03,318.37,'2022-08-03 08:29:03','',''),(2052,'1','275','1',1,'Retail Sale Id 2042',1502.88,0.00,0.00,2.02,159.58,'2022-08-03 08:45:53','',''),(2053,'1','275','1',1,'Retail Sale Id 2043',2499.84,0.00,0.00,3.36,265.44,'2022-08-03 08:52:20','',''),(2054,'1','275','1',1,'Retail Sale Id 2044',2298.96,0.00,0.00,3.09,244.11,'2022-08-03 09:06:20','',''),(2055,'1','275','1',1,'Retail Sale Id 2045',2298.96,0.00,0.00,3.09,244.11,'2022-08-03 09:09:55','',''),(2056,'1','275','1',1,'Retail Sale Id 2046',2998.32,0.00,0.00,4.03,318.37,'2022-08-03 09:14:31','',''),(2057,'1','275','1',1,'Retail Sale Id 2047',9300.00,0.00,0.00,12.50,987.50,'2022-08-03 09:17:34','',''),(2058,'1','275','1',1,'Retail Sale Id 2048',4798.80,0.00,0.00,6.45,509.55,'2022-08-03 09:23:32','',''),(2059,'1','275','1',1,'Return of Retail Sale Id 2048',0.00,4798.80,6.45,0.00,-509.55,'2022-08-03 09:24:56','',''),(2060,'1','275','1',1,'Retail Sale Id 2049',3720.00,0.00,0.00,5.00,395.00,'2022-08-03 09:26:23','',''),(2061,'1','275','1',1,'Retail Sale Id 2050',3720.00,0.00,0.00,5.00,395.00,'2022-08-03 09:32:01','',''),(2062,'1','275','1',1,'Retail Sale Id 2051',2001.36,0.00,0.00,2.69,212.51,'2022-08-03 09:34:26','',''),(2063,'1','275','1',1,'Retail Sale Id 2052',7499.52,0.00,0.00,10.08,796.32,'2022-08-03 09:38:10','',''),(2064,'1','275','1',1,'Retail Sale Id 2053',9300.00,0.00,0.00,12.50,987.50,'2022-08-03 09:41:44','',''),(2065,'1','275','1',1,'Retail Sale Id 2053',9300.00,0.00,0.00,12.50,987.50,'2022-08-03 09:41:44','',''),(2066,'1','275','1',1,'Retail Sale Id 2053',9300.00,0.00,0.00,12.50,987.50,'2022-08-03 09:41:44','',''),(2067,'1','275','1',1,'Retail Sale Id 2054',9300.00,0.00,0.00,12.50,987.50,'2022-08-03 09:43:21','',''),(2068,'1','275','1',1,'Retail Sale Id 2055',2001.36,0.00,0.00,2.69,212.51,'2022-08-03 10:03:20','',''),(2069,'1','275','1',1,'Retail Sale Id 2056',1502.88,0.00,0.00,2.02,159.58,'2022-08-03 10:15:30','',''),(2070,'1','275','1',1,'Retail Sale Id 2057',4501.20,0.00,0.00,6.05,477.95,'2022-08-03 10:23:24','',''),(2071,'1','275','1',1,'Retail Sale Id 2058',9300.00,0.00,0.00,12.50,987.50,'2022-08-03 10:28:17','',''),(2072,'1','275','1',1,'Retail Sale Id 2059',2001.36,0.00,0.00,2.69,212.51,'2022-08-03 10:31:10','',''),(2073,'1','275','1',1,'Retail Sale Id 2060',2499.84,0.00,0.00,3.36,265.44,'2022-08-03 10:32:07','',''),(2074,'1','275','1',1,'Retail Sale Id 2061',7499.52,0.00,0.00,10.08,796.32,'2022-08-03 10:37:40','',''),(2075,'1','275','1',1,'Retail Sale Id 2062',9300.00,0.00,0.00,12.50,987.50,'2022-08-03 10:48:23','',''),(2076,'1','275','1',1,'Retail Sale Id 2063',9300.00,0.00,0.00,12.50,987.50,'2022-08-03 10:54:16','',''),(2077,'1','275','1',1,'Retail Sale Id 2064',2298.96,0.00,0.00,3.09,244.11,'2022-08-03 11:00:08','',''),(2078,'1','275','1',1,'Retail Sale Id 2065',744.00,0.00,0.00,1.00,79.00,'2022-08-03 11:23:05','',''),(2079,'1','275','1',1,'Retail Sale Id 2066',1502.88,0.00,0.00,2.02,159.58,'2022-08-03 11:24:16','',''),(2080,'1','275','1',1,'Retail Sale Id 2067',22320.00,0.00,0.00,30.00,2370.00,'2022-08-03 12:07:14','',''),(2081,'1','275','1',1,'Retail Sale Id 2068',2298.96,0.00,0.00,3.09,244.11,'2022-08-03 12:34:39','',''),(2082,'1','275','1',1,'Retail Sale Id 2069',996.96,0.00,0.00,1.34,105.86,'2022-08-03 12:42:04','',''),(2083,'1','275','1',1,'Retail Sale Id 2070',2998.32,0.00,0.00,4.03,318.37,'2022-08-03 12:54:52','',''),(2084,'1','275','1',1,'Retail Sale Id 2071',3720.00,0.00,0.00,5.00,395.00,'2022-08-03 13:09:00','',''),(2085,'1','275','1',1,'Retail Sale Id 2072',2298.96,0.00,0.00,3.09,244.11,'2022-08-03 13:12:19','',''),(2086,'1','275','1',1,'Retail Sale Id 2073',9300.00,0.00,0.00,12.50,987.50,'2022-08-03 13:21:39','',''),(2087,'1','275','1',1,'Retail Sale Id 2074',2298.96,0.00,0.00,3.09,244.11,'2022-08-03 13:32:42','',''),(2088,'1','275','1',1,'Retail Sale Id 2075',18600.00,0.00,0.00,25.00,1975.00,'2022-08-03 13:47:34','',''),(2089,'1','275','1',1,'Retail Sale Id 2076',7499.52,0.00,0.00,10.08,796.32,'2022-08-03 13:48:36','',''),(2090,'1','275','1',1,'Retail Sale Id 2077',4501.20,0.00,0.00,6.05,477.95,'2022-08-03 14:16:38','',''),(2091,'1','275','1',1,'Retail Sale Id 2078',8184.00,0.00,0.00,11.00,869.00,'2022-08-03 14:37:40','',''),(2092,'1','275','1',1,'Retail Sale Id 2079',1302.00,0.00,0.00,1.75,138.25,'2022-08-03 14:52:41','',''),(2093,'1','275','1',1,'Retail Sale Id 2080',9300.00,0.00,0.00,12.50,987.50,'2022-08-03 14:57:59','',''),(2094,'1','275','1',1,'Retail Sale Id 2081',9300.00,0.00,0.00,12.50,987.50,'2022-08-03 15:15:29','',''),(2095,'1','275','1',1,'Retail Sale Id 2082',9300.00,0.00,0.00,12.50,987.50,'2022-08-03 15:23:10','',''),(2096,'1','275','1',1,'Retail Sale Id 2083',9300.00,0.00,0.00,12.50,987.50,'2022-08-03 15:27:21','',''),(2097,'1','275','1',1,'Retail Sale Id 2084',2298.96,0.00,0.00,3.09,244.11,'2022-08-03 15:49:21','',''),(2098,'1','275','1',1,'Retail Sale Id 2085',2298.96,0.00,0.00,3.09,244.11,'2022-08-03 15:50:22','',''),(2099,'1','275','1',1,'Retail Sale Id 2086',996.96,0.00,0.00,1.34,105.86,'2022-08-03 15:51:29','',''),(2100,'1','275','1',1,'Retail Sale Id 2087',9300.00,0.00,0.00,12.50,987.50,'2022-08-03 15:53:57','',''),(2101,'1','275','1',1,'Retail Sale Id 2088',3720.00,0.00,0.00,5.00,395.00,'2022-08-03 15:56:11','',''),(2102,'1','275','1',1,'Retail Sale Id 2089',7001.04,0.00,0.00,9.41,743.39,'2022-08-03 16:12:12','',''),(2103,'1','275','1',1,'Retail Sale Id 2090',9300.00,0.00,0.00,12.50,987.50,'2022-08-03 16:19:14','',''),(2104,'1','275','1',1,'Retail Sale Id 2091',33480.00,0.00,0.00,45.00,3555.00,'2022-08-03 16:34:40','',''),(2105,'1','275','1',1,'Retail Sale Id 2092',9300.00,0.00,0.00,12.50,987.50,'2022-08-03 16:50:16','',''),(2106,'1','275','1',1,'Retail Sale Id 2093',9300.00,0.00,0.00,12.50,987.50,'2022-08-03 16:51:27','',''),(2107,'1','275','1',1,'Retail Sale Id 2094',3720.00,0.00,0.00,5.00,395.00,'2022-08-03 16:53:52','',''),(2108,'1','275','1',1,'Retail Sale Id 2094',8184.00,0.00,0.00,11.00,869.00,'2022-08-03 16:53:52','',''),(2109,'1','275','1',1,'Return of Retail Sale Id 2094',0.00,3720.00,5.00,0.00,-395.00,'2022-08-03 16:54:12','',''),(2110,'1','275','1',1,'Return of Retail Sale Id 2094',0.00,8184.00,11.00,0.00,-869.00,'2022-08-03 16:54:12','',''),(2111,'1','275','1',1,'Retail Sale Id 2095',8184.00,0.00,0.00,11.00,869.00,'2022-08-03 16:55:19','',''),(2112,'1','275','1',1,'Retail Sale Id 2095',33480.00,0.00,0.00,45.00,3555.00,'2022-08-03 16:55:19','',''),(2113,'1','275','1',1,'Retail Sale Id 2096',9300.00,0.00,0.00,12.50,987.50,'2022-08-03 17:00:39','',''),(2114,'1','275','1',1,'Retail Sale Id 2097',18600.00,0.00,0.00,25.00,1975.00,'2022-08-03 17:02:17','',''),(2115,'1','275','1',1,'Retail Sale Id 2098',996.96,0.00,0.00,1.34,105.86,'2022-08-03 17:18:00','',''),(2116,'1','275','1',1,'Retail Sale Id 2099',9300.00,0.00,0.00,12.50,987.50,'2022-08-03 17:23:28','',''),(2117,'1','275','1',1,'Retail Sale Id 2100',3720.00,0.00,0.00,5.00,395.00,'2022-08-03 17:39:56','',''),(2118,'1','275','1',1,'Retail Sale Id 2100',9300.00,0.00,0.00,12.50,987.50,'2022-08-03 17:39:56','',''),(2119,'1','275','1',1,'Retail Sale Id 2101',2298.96,0.00,0.00,3.09,244.11,'2022-08-03 17:41:23','',''),(2120,'1','275','1',1,'Retail Sale Id 2102',9300.00,0.00,0.00,12.50,987.50,'2022-08-03 17:42:42','',''),(2121,'1','275','1',1,'Retail Sale Id 2103',37200.00,0.00,0.00,50.00,3950.00,'2022-08-03 17:48:15','',''),(2122,'1','275','1',1,'Retail Sale Id 2104',996.96,0.00,0.00,1.34,105.86,'2022-08-03 17:49:00','',''),(2123,'1','275','1',1,'Retail Sale Id 2105',3720.00,0.00,0.00,5.00,395.00,'2022-08-03 17:53:34','',''),(2124,'1','275','1',1,'Retail Sale Id 2106',2998.32,0.00,0.00,4.03,318.37,'2022-08-03 17:56:57','',''),(2125,'1','275','1',1,'Retail Sale Id 2107',9300.00,0.00,0.00,12.50,987.50,'2022-08-03 18:04:56','',''),(2126,'1','275','1',1,'Retail Sale Id 2108',4501.20,0.00,0.00,6.05,477.95,'2022-08-03 18:06:45','',''),(2127,'1','275','1',1,'Retail Sale Id 2109',18600.00,0.00,0.00,25.00,1975.00,'2022-08-03 18:20:49','',''),(2128,'1','275','1',1,'Retail Sale Id 2110',8184.00,0.00,0.00,11.00,869.00,'2022-08-03 18:22:33','',''),(2129,'1','275','1',1,'Retail Sale Id 2111',1502.88,0.00,0.00,2.02,159.58,'2022-08-03 18:30:04','',''),(2130,'1','275','1',1,'Retail Sale Id 2111',9300.00,0.00,0.00,12.50,987.50,'2022-08-03 18:30:04','',''),(2131,'1','275','1',1,'Retail Sale Id 2112',2001.36,0.00,0.00,2.69,212.51,'2022-08-03 18:34:35','',''),(2132,'1','275','1',1,'Retail Sale Id 2113',30057.60,0.00,0.00,40.40,3191.60,'2022-08-03 19:26:09','',''),(2133,'1','275','1',1,'Retail Sale Id 2114',9300.00,0.00,0.00,12.50,987.50,'2022-08-04 07:19:52','',''),(2134,'1','275','1',1,'Retail Sale Id 2115',40920.00,0.00,0.00,55.00,4345.00,'2022-08-04 07:39:33','',''),(2135,'1','275','1',1,'Retail Sale Id 2116',11197.20,0.00,0.00,15.05,1188.95,'2022-08-04 07:40:14','',''),(2136,'1','275','1',1,'Retail Sale Id 2117',9300.00,0.00,0.00,12.50,987.50,'2022-08-04 08:02:40','',''),(2137,'1','275','1',1,'Retail Sale Id 2118',4999.68,0.00,0.00,6.72,530.88,'2022-08-04 08:35:36','',''),(2138,'1','275','1',1,'Retail Sale Id 2119',4501.20,0.00,0.00,6.05,477.95,'2022-08-04 08:59:47','',''),(2139,'1','275','1',1,'Retail Sale Id 2120',1502.88,0.00,0.00,2.02,159.58,'2022-08-04 09:12:59','',''),(2140,'1','275','1',1,'Retail Sale Id 2121',9300.00,0.00,0.00,12.50,987.50,'2022-08-04 09:14:11','',''),(2141,'1','275','1',1,'Retail Sale Id 2122',9300.00,0.00,0.00,12.50,987.50,'2022-08-04 09:15:36','',''),(2142,'1','275','1',1,'Retail Sale Id 2123',9300.00,0.00,0.00,12.50,987.50,'2022-08-04 09:17:02','',''),(2143,'1','275','1',1,'Retail Sale Id 2124',1502.88,0.00,0.00,2.02,159.58,'2022-08-04 09:17:57','',''),(2144,'1','275','1',1,'Retail Sale Id 2125',1302.00,0.00,0.00,1.75,138.25,'2022-08-04 09:19:20','',''),(2145,'1','275','1',1,'Retail Sale Id 2126',9300.00,0.00,0.00,12.50,987.50,'2022-08-04 09:26:49','',''),(2146,'1','275','1',1,'Retail Sale Id 2127',37200.00,0.00,0.00,50.00,3950.00,'2022-08-04 12:10:15','',''),(2147,'1','275','1',1,'Retail Sale Id 2128',121277.50,0.00,0.00,174.50,5235.00,'2022-08-04 12:15:31','',''),(2148,'1','275','1',1,'Retail Sale Id 2129',4999.68,0.00,0.00,6.72,530.88,'2022-08-04 12:19:50','',''),(2149,'1','275','1',1,'Retail Sale Id 2130',18600.00,0.00,0.00,25.00,1975.00,'2022-08-04 12:39:20','',''),(2150,'1','275','1',1,'Retail Sale Id 2131',2001.36,0.00,0.00,2.69,212.51,'2022-08-04 12:51:51','',''),(2151,'1','275','1',1,'Retail Sale Id 2132',4501.20,0.00,0.00,6.05,477.95,'2022-08-04 13:30:21','',''),(2152,'1','275','1',1,'Retail Sale Id 2133',4501.20,0.00,0.00,6.05,477.95,'2022-08-04 14:17:35','',''),(2153,'1','275','1',1,'Retail Sale Id 2134',37200.00,0.00,0.00,50.00,3950.00,'2022-08-04 14:37:43','',''),(2154,'1','275','1',1,'Retail Sale Id 2135',4002.72,0.00,0.00,5.38,425.02,'2022-08-04 14:45:29','',''),(2155,'1','275','1',1,'Retail Sale Id 2136',9002.40,0.00,0.00,12.10,955.90,'2022-08-04 15:12:46','',''),(2156,'1','275','1',1,'Retail Sale Id 2137',25499.55,0.00,0.00,36.69,1100.70,'2022-08-04 15:15:26','',''),(2157,'1','275','1',1,'Retail Sale Id 2138',9300.00,0.00,0.00,12.50,987.50,'2022-08-04 15:16:46','',''),(2158,'1','275','1',1,'Retail Sale Id 2139',16680.00,0.00,0.00,24.00,720.00,'2022-08-04 15:18:31','',''),(2159,'1','275','1',1,'Retail Sale Id 2140',34750.00,0.00,0.00,50.00,1500.00,'2022-08-04 15:31:04','',''),(2160,'1','275','1',1,'Retail Sale Id 2141',37200.00,0.00,0.00,50.00,3950.00,'2022-08-04 15:33:55','',''),(2161,'1','275','1',1,'Retail Sale Id 2142',1502.88,0.00,0.00,2.02,159.58,'2022-08-04 15:35:08','',''),(2162,'1','275','1',1,'Retail Sale Id 2143',996.96,0.00,0.00,1.34,105.86,'2022-08-04 15:37:52','',''),(2163,'1','275','1',1,'Retail Sale Id 2144',34750.00,0.00,0.00,50.00,1500.00,'2022-08-04 15:50:41','',''),(2164,'1','275','1',1,'Retail Sale Id 2145',2298.96,0.00,0.00,3.09,244.11,'2022-08-04 15:56:48','',''),(2165,'1','275','1',1,'Retail Sale Id 2146',9300.00,0.00,0.00,12.50,987.50,'2022-08-04 15:59:21','',''),(2166,'1','275','1',1,'Retail Sale Id 2147',2001.36,0.00,0.00,2.69,212.51,'2022-08-04 16:01:22','',''),(2167,'1','275','1',1,'Retail Sale Id 2148',2298.96,0.00,0.00,3.09,244.11,'2022-08-04 16:07:54','',''),(2168,'1','275','1',1,'Retail Sale Id 2149',2998.32,0.00,0.00,4.03,318.37,'2022-08-04 16:21:59','',''),(2169,'1','275','1',1,'Retail Sale Id 2149',5996.64,0.00,0.00,8.06,636.74,'2022-08-04 16:21:59','',''),(2170,'1','275','1',1,'Retail Sale Id 2150',9300.00,0.00,0.00,12.50,987.50,'2022-08-04 16:33:29','',''),(2171,'1','275','1',1,'Retail Sale Id 2151',2298.96,0.00,0.00,3.09,244.11,'2022-08-04 16:44:51','',''),(2172,'1','275','1',1,'Retail Sale Id 2152',4501.20,0.00,0.00,6.05,477.95,'2022-08-04 16:49:16','',''),(2173,'1','275','1',1,'Retail Sale Id 2153',9300.00,0.00,0.00,12.50,987.50,'2022-08-04 16:50:32','',''),(2174,'1','275','1',1,'Retail Sale Id 2154',2001.36,0.00,0.00,2.69,212.51,'2022-08-04 17:08:06','',''),(2175,'1','275','1',1,'Retail Sale Id 2155',37200.00,0.00,0.00,50.00,3950.00,'2022-08-04 17:09:50','',''),(2176,'1','275','1',1,'Retail Sale Id 2156',9300.00,0.00,0.00,12.50,987.50,'2022-08-04 17:15:04','',''),(2177,'1','275','1',1,'Retail Sale Id 2157',8687.50,0.00,0.00,12.50,375.00,'2022-08-04 18:05:38','',''),(2178,'1','275','1',1,'Retail Sale Id 2158',4501.20,0.00,0.00,6.05,477.95,'2022-08-04 18:16:55','',''),(2179,'1','275','1',1,'Retail Sale Id 2159',9300.00,0.00,0.00,12.50,987.50,'2022-08-04 18:28:12','',''),(2180,'1','275','1',1,'Retail Sale Id 2160',9300.00,0.00,0.00,12.50,987.50,'2022-08-04 18:40:11','',''),(2181,'1','275','1',1,'Retail Sale Id 2161',3720.00,0.00,0.00,5.00,395.00,'2022-08-04 18:48:37','',''),(2182,'1','275','1',1,'Retail Sale Id 2162',9300.00,0.00,0.00,12.50,987.50,'2022-08-04 18:49:56','',''),(2183,'1','275','1',1,'Retail Sale Id 2163',2001.36,0.00,0.00,2.69,212.51,'2022-08-04 18:56:47','',''),(2184,'1','275','1',1,'Retail Sale Id 2163',9300.00,0.00,0.00,12.50,987.50,'2022-08-04 18:56:47','',''),(2185,'1','275','1',1,'Retail Sale Id 2164',9300.00,0.00,0.00,12.50,987.50,'2022-08-04 19:01:03','',''),(2186,'1','275','1',1,'Retail Sale Id 2166',158390.16,0.00,0.00,212.89,16818.31,'2022-08-04 19:29:41','',''),(2187,'1','275','1',1,'Retail Sale Id 2167',31907.45,0.00,0.00,45.91,1377.30,'2022-08-04 19:31:26','',''),(2188,'1','275','1',1,'Retail Sale Id 2168',2001.36,0.00,0.00,2.69,212.51,'2022-08-05 07:07:03','',''),(2189,'1','275','1',1,'Retail Sale Id 2169',9300.00,0.00,0.00,12.50,987.50,'2022-08-05 07:20:35','',''),(2190,'1','275','1',1,'Retail Sale Id 2170',1502.88,0.00,0.00,2.02,159.58,'2022-08-05 07:43:00','',''),(2191,'1','275','1',1,'Retail Sale Id 2170',9300.00,0.00,0.00,12.50,987.50,'2022-08-05 07:43:00','',''),(2192,'1','275','1',1,'Retail Sale Id 2171',4501.20,0.00,0.00,6.05,477.95,'2022-08-05 07:47:39','',''),(2193,'1','275','1',1,'Retail Sale Id 2172',4501.20,0.00,0.00,6.05,477.95,'2022-08-05 07:52:27','',''),(2194,'1','275','1',1,'Retail Sale Id 2173',3749.76,0.00,0.00,5.04,398.16,'2022-08-05 08:16:49','',''),(2195,'1','275','1',1,'Retail Sale Id 2174',9300.00,0.00,0.00,12.50,987.50,'2022-08-05 08:23:10','',''),(2196,'1','275','1',1,'Retail Sale Id 2175',112590.00,0.00,0.00,162.00,4860.00,'2022-08-05 08:40:42','',''),(2197,'1','275','1',1,'Retail Sale Id 2176',4501.20,0.00,0.00,6.05,477.95,'2022-08-05 09:11:47','',''),(2198,'1','275','1',1,'Retail Sale Id 2177',2298.96,0.00,0.00,3.09,244.11,'2022-08-05 09:13:49','',''),(2199,'1','275','1',1,'Retail Sale Id 2178',2001.36,0.00,0.00,2.69,212.51,'2022-08-05 09:23:07','',''),(2200,'1','275','1',1,'Retail Sale Id 2179',9300.00,0.00,0.00,12.50,987.50,'2022-08-05 09:37:59','',''),(2201,'1','275','1',1,'Retail Sale Id 2180',2298.96,0.00,0.00,3.09,244.11,'2022-08-05 09:54:47','',''),(2202,'1','275','1',1,'Retail Sale Id 2181',996.96,0.00,0.00,1.34,105.86,'2022-08-05 09:57:24','',''),(2203,'1','275','1',1,'Retail Sale Id 2182',9300.00,0.00,0.00,12.50,987.50,'2022-08-05 09:58:19','',''),(2204,'1','275','1',1,'Retail Sale Id 2183',3720.00,0.00,0.00,5.00,395.00,'2022-08-05 10:02:32','',''),(2205,'1','275','1',1,'Retail Sale Id 2184',1502.88,0.00,0.00,2.02,159.58,'2022-08-05 10:19:04','',''),(2206,'1','275','1',1,'Retail Sale Id 2185',9300.00,0.00,0.00,12.50,987.50,'2022-08-05 10:30:12','',''),(2207,'1','275','1',1,'Retail Sale Id 2187',4501.20,0.00,0.00,6.05,477.95,'2022-08-05 10:47:44','',''),(2208,'1','275','1',1,'Retail Sale Id 2188',2998.32,0.00,0.00,4.03,318.37,'2022-08-05 10:49:02','',''),(2209,'1','275','1',1,'Retail Sale Id 2189',4002.72,0.00,0.00,5.38,425.02,'2022-08-05 10:50:11','',''),(2210,'1','275','1',1,'Retail Sale Id 2190',4002.72,0.00,0.00,5.38,425.02,'2022-08-05 11:03:12','',''),(2211,'1','275','1',1,'Retail Sale Id 2191',3720.00,0.00,0.00,5.00,395.00,'2022-08-05 11:17:40','',''),(2212,'1','275','1',1,'Retail Sale Id 2191',9300.00,0.00,0.00,12.50,987.50,'2022-08-05 11:17:40','',''),(2213,'1','275','1',1,'Retail Sale Id 2192',996.96,0.00,0.00,1.34,105.86,'2022-08-05 11:25:36','',''),(2214,'1','275','1',1,'Retail Sale Id 2193',9300.00,0.00,0.00,12.50,987.50,'2022-08-05 11:26:26','',''),(2215,'1','275','1',1,'Retail Sale Id 2194',9002.40,0.00,0.00,12.10,955.90,'2022-08-05 11:33:51','',''),(2216,'1','275','1',1,'Retail Sale Id 2195',9300.00,0.00,0.00,12.50,987.50,'2022-08-05 11:40:22','',''),(2217,'1','275','1',1,'Retail Sale Id 2196',8184.00,0.00,0.00,11.00,869.00,'2022-08-05 11:48:20','',''),(2218,'1','275','1',1,'Retail Sale Id 2197',69500.00,0.00,0.00,100.00,3000.00,'2022-08-05 12:32:34','',''),(2219,'1','275','1',1,'Retail Sale Id 2198',996.96,0.00,0.00,1.34,105.86,'2022-08-05 14:39:11','',''),(2220,'1','275','1',1,'Retail Sale Id 2199',2298.96,0.00,0.00,3.09,244.11,'2022-08-05 14:40:56','',''),(2221,'1','275','1',1,'Retail Sale Id 2200',996.96,0.00,0.00,1.34,105.86,'2022-08-05 14:42:25','',''),(2222,'1','275','1',1,'Retail Sale Id 2201',9300.00,0.00,0.00,12.50,987.50,'2022-08-05 14:43:50','',''),(2223,'1','275','1',1,'Retail Sale Id 2202',9300.00,0.00,0.00,12.50,987.50,'2022-08-05 14:48:13','',''),(2224,'1','275','1',1,'Retail Sale Id 2203',9300.00,0.00,0.00,12.50,987.50,'2022-08-05 14:49:33','',''),(2225,'1','275','1',1,'Retail Sale Id 2204',4501.20,0.00,0.00,6.05,477.95,'2022-08-05 14:59:14','',''),(2226,'1','275','1',1,'Retail Sale Id 2205',2001.36,0.00,0.00,2.69,212.51,'2022-08-05 15:27:18','',''),(2227,'1','275','1',1,'Retail Sale Id 2206',8303.04,0.00,0.00,11.16,881.64,'2022-08-05 15:35:23','',''),(2228,'1','275','1',1,'Retail Sale Id 2207',4501.20,0.00,0.00,6.05,477.95,'2022-08-05 15:44:31','',''),(2229,'1','275','1',1,'Retail Sale Id 2207',9300.00,0.00,0.00,12.50,987.50,'2022-08-05 15:44:31','',''),(2230,'1','275','1',1,'Retail Sale Id 2208',9300.00,0.00,0.00,12.50,987.50,'2022-08-05 15:45:33','',''),(2231,'1','275','1',1,'Retail Sale Id 2209',18600.00,0.00,0.00,25.00,1975.00,'2022-08-05 15:50:51','',''),(2232,'1','275','1',1,'Retail Sale Id 2210',21002.90,0.00,0.00,30.22,906.60,'2022-08-05 16:02:31','',''),(2233,'1','275','1',1,'Retail Sale Id 2211',3749.76,0.00,0.00,5.04,398.16,'2022-08-05 16:04:20','',''),(2234,'1','275','1',1,'Retail Sale Id 2212',9300.00,0.00,0.00,12.50,987.50,'2022-08-05 16:23:39','',''),(2235,'1','275','1',1,'Retail Sale Id 2214',1502.88,0.00,0.00,2.02,159.58,'2022-08-05 16:39:33','',''),(2236,'1','275','1',1,'Retail Sale Id 2215',18600.00,0.00,0.00,25.00,1975.00,'2022-08-05 16:41:48','',''),(2237,'1','275','1',1,'Retail Sale Id 2215',27900.00,0.00,0.00,37.50,2962.50,'2022-08-05 16:41:48','',''),(2238,'1','275','1',1,'Retail Sale Id 2216',9300.00,0.00,0.00,12.50,987.50,'2022-08-05 16:48:08','',''),(2239,'1','275','1',1,'Retail Sale Id 2216',14880.00,0.00,0.00,20.00,1580.00,'2022-08-05 16:48:08','',''),(2240,'1','275','1',1,'Retail Sale Id 2217',9300.00,0.00,0.00,12.50,987.50,'2022-08-05 16:53:49','',''),(2241,'1','275','1',1,'Retail Sale Id 2218',9300.00,0.00,0.00,12.50,987.50,'2022-08-05 16:55:05','',''),(2242,'1','275','1',1,'Retail Sale Id 2219',7499.52,0.00,0.00,10.08,796.32,'2022-08-05 17:01:23','',''),(2243,'1','275','1',1,'Retail Sale Id 2220',8340.00,0.00,0.00,12.00,360.00,'2022-08-05 17:06:32','',''),(2244,'1','275','1',1,'Retail Sale Id 2221',9300.00,0.00,0.00,12.50,987.50,'2022-08-05 17:13:59','',''),(2245,'1','275','1',1,'Retail Sale Id 2222',16680.00,0.00,0.00,24.00,720.00,'2022-08-05 17:29:23','',''),(2246,'1','275','1',1,'Retail Sale Id 2223',9300.00,0.00,0.00,12.50,987.50,'2022-08-05 17:34:01','',''),(2247,'1','275','1',1,'Retail Sale Id 2224',68805.00,0.00,0.00,99.00,2970.00,'2022-08-05 17:41:49','',''),(2248,'1','275','1',1,'Retail Sale Id 2225',6703.44,0.00,0.00,9.01,711.79,'2022-08-05 17:44:32','',''),(2249,'1','275','1',1,'Retail Sale Id 2226',9300.00,0.00,0.00,12.50,987.50,'2022-08-05 18:08:20','',''),(2250,'1','275','1',1,'Retail Sale Id 2227',1502.88,0.00,0.00,2.02,159.58,'2022-08-05 18:10:36','',''),(2251,'1','275','1',1,'Retail Sale Id 2228',2298.96,0.00,0.00,3.09,244.11,'2022-08-05 18:20:19','',''),(2252,'1','275','1',1,'Retail Sale Id 2229',28995.40,0.00,0.00,41.72,1251.60,'2022-08-05 18:22:10','',''),(2253,'1','275','1',1,'Retail Sale Id 2230',34750.00,0.00,0.00,50.00,1500.00,'2022-08-05 18:23:13','',''),(2254,'1','275','1',1,'Retail Sale Id 2231',3496.80,0.00,0.00,4.70,371.30,'2022-08-05 18:24:33','',''),(2255,'1','275','1',1,'Retail Sale Id 2232',8340.00,0.00,0.00,12.00,360.00,'2022-08-05 18:26:52','',''),(2256,'1','275','1',1,'Retail Sale Id 2233',9300.00,0.00,0.00,12.50,987.50,'2022-08-05 18:50:41','',''),(2257,'1','275','1',1,'Retail Sale Id 2234',1197.84,0.00,0.00,1.61,127.19,'2022-08-05 19:03:56','',''),(2258,'1','275','1',1,'Retail Sale Id 2235',9300.00,0.00,0.00,12.50,987.50,'2022-08-05 19:06:40','',''),(2259,'1','275','1',1,'Retail Sale Id 2236',19485.36,0.00,0.00,26.19,2069.01,'2022-08-05 19:31:07','',''),(2260,'1','275','1',1,'Retail Sale Id 2237',56990.00,0.00,0.00,82.00,2460.00,'2022-08-05 19:32:47','',''),(2261,'1','275','1',1,'Retail Sale Id 2238',2499.84,0.00,0.00,3.36,265.44,'2022-08-06 07:32:55','',''),(2262,'1','275','1',1,'Retail Sale Id 2239',34750.00,0.00,0.00,50.00,1500.00,'2022-08-06 07:44:30','',''),(2263,'1','275','1',1,'Retail Sale Id 2240',9300.00,0.00,0.00,12.50,987.50,'2022-08-06 07:45:39','',''),(2264,'1','275','1',1,'Retail Sale Id 2241',8340.00,0.00,0.00,12.00,360.00,'2022-08-06 07:55:24','',''),(2265,'1','275','1',1,'Retail Sale Id 2242',9300.00,0.00,0.00,12.50,987.50,'2022-08-06 08:12:27','',''),(2266,'1','275','1',1,'Retail Sale Id 2243',1502.88,0.00,0.00,2.02,159.58,'2022-08-06 08:37:07','',''),(2267,'1','275','1',1,'Retail Sale Id 2244',4002.72,0.00,0.00,5.38,425.02,'2022-08-06 08:40:56','',''),(2268,'1','275','1',1,'Retail Sale Id 2245',18600.00,0.00,0.00,25.00,1975.00,'2022-08-06 08:44:34','',''),(2269,'1','275','1',1,'Retail Sale Id 2246',9300.00,0.00,0.00,12.50,987.50,'2022-08-06 08:46:41','',''),(2270,'1','275','1',1,'Retail Sale Id 2247',18600.00,0.00,0.00,25.00,1975.00,'2022-08-06 08:50:01','',''),(2271,'1','275','1',1,'Retail Sale Id 2248',9300.00,0.00,0.00,12.50,987.50,'2022-08-06 08:51:16','',''),(2272,'1','275','1',1,'Retail Sale Id 2249',3720.00,0.00,0.00,5.00,395.00,'2022-08-06 08:52:01','',''),(2273,'1','275','1',1,'Retail Sale Id 2251',14998.10,0.00,0.00,21.58,647.40,'2022-08-06 08:54:42','',''),(2274,'1','275','1',1,'Retail Sale Id 2252',9002.40,0.00,0.00,12.10,955.90,'2022-08-06 08:55:38','',''),(2275,'1','275','1',1,'Retail Sale Id 2253',9300.00,0.00,0.00,12.50,987.50,'2022-08-06 09:01:45','',''),(2276,'1','275','1',1,'Retail Sale Id 2254',3749.76,0.00,0.00,5.04,398.16,'2022-08-06 09:03:31','',''),(2277,'1','275','1',1,'Retail Sale Id 2255',8340.00,0.00,0.00,12.00,360.00,'2022-08-06 09:14:54','',''),(2278,'1','275','1',1,'Retail Sale Id 2256',9300.00,0.00,0.00,12.50,987.50,'2022-08-06 09:23:06','',''),(2279,'1','275','1',1,'Retail Sale Id 2257',9300.00,0.00,0.00,12.50,987.50,'2022-08-06 09:27:05','',''),(2280,'1','275','1',1,'Retail Sale Id 2258',4501.20,0.00,0.00,6.05,477.95,'2022-08-06 09:27:58','',''),(2281,'1','275','1',1,'Retail Sale Id 2259',4999.68,0.00,0.00,6.72,530.88,'2022-08-06 09:35:05','',''),(2282,'1','275','1',1,'Retail Sale Id 2260',9300.00,0.00,0.00,12.50,987.50,'2022-08-06 09:44:34','',''),(2283,'1','275','1',1,'Retail Sale Id 2261',9300.00,0.00,0.00,12.50,987.50,'2022-08-06 09:49:05','',''),(2284,'1','275','1',1,'Retail Sale Id 2262',803.52,0.00,0.00,1.08,85.32,'2022-08-06 09:50:23','',''),(2285,'1','275','1',1,'Retail Sale Id 2263',4002.72,0.00,0.00,5.38,425.02,'2022-08-06 09:57:19','',''),(2286,'1','275','1',1,'Retail Sale Id 2264',139000.00,0.00,0.00,200.00,6000.00,'2022-08-06 10:07:33','',''),(2287,'1','275','1',1,'Retail Sale Id 2265',4999.68,0.00,0.00,6.72,530.88,'2022-08-06 10:11:03','',''),(2288,'1','275','1',1,'Retail Sale Id 2266',9300.00,0.00,0.00,12.50,987.50,'2022-08-06 10:32:11','',''),(2289,'1','275','1',1,'Retail Sale Id 2267',9300.00,0.00,0.00,12.50,987.50,'2022-08-06 10:35:35','',''),(2290,'1','275','1',1,'Retail Sale Id 2268',5996.64,0.00,0.00,8.06,636.74,'2022-08-06 10:43:55','',''),(2291,'1','275','1',1,'Retail Sale Id 2269',2298.96,0.00,0.00,3.09,244.11,'2022-08-06 10:52:00','',''),(2292,'1','275','1',1,'Retail Sale Id 2270',9300.00,0.00,0.00,12.50,987.50,'2022-08-06 10:58:07','',''),(2293,'1','275','1',1,'Retail Sale Id 2271',4501.20,0.00,0.00,6.05,477.95,'2022-08-06 10:59:58','',''),(2294,'1','275','1',1,'Retail Sale Id 2271',18600.00,0.00,0.00,25.00,1975.00,'2022-08-06 10:59:58','',''),(2295,'1','275','1',1,'Retail Sale Id 2272',9300.00,0.00,0.00,12.50,987.50,'2022-08-06 11:01:56','',''),(2296,'1','275','1',1,'Retail Sale Id 2273',7499.52,0.00,0.00,10.08,796.32,'2022-08-06 11:09:33','',''),(2297,'1','275','1',1,'Retail Sale Id 2273',9300.00,0.00,0.00,12.50,987.50,'2022-08-06 11:09:33','',''),(2298,'1','275','1',1,'Retail Sale Id 2274',9300.00,0.00,0.00,12.50,987.50,'2022-08-06 11:11:17','',''),(2299,'1','275','1',1,'Return of Retail Sale Id 2271',0.00,4501.20,6.05,0.00,-477.95,'2022-08-06 11:56:12','',''),(2300,'1','275','1',1,'Return of Retail Sale Id 2271',0.00,18600.00,25.00,0.00,-1975.00,'2022-08-06 11:56:12','',''),(2301,'1','275','1',1,'Return of Retail Sale Id 2273',0.00,7499.52,10.08,0.00,-796.32,'2022-08-06 11:57:32','',''),(2302,'1','275','1',1,'Return of Retail Sale Id 2273',0.00,9300.00,12.50,0.00,-987.50,'2022-08-06 11:57:32','',''),(2303,'1','275','1',1,'Return of Retail Sale Id 2265',0.00,4999.68,6.72,0.00,-530.88,'2022-08-06 11:58:12','',''),(2304,'1','275','1',1,'Retail Sale Id 2275',2462.64,0.00,0.00,3.31,261.49,'2022-08-06 11:59:22','',''),(2305,'1','275','1',1,'Retail Sale Id 2276',90169.30,0.00,0.00,129.74,3892.20,'2022-08-06 12:00:54','',''),(2306,'1','275','1',1,'Distributed to Operational lost for sales id:10',72145.85,0.00,0.00,108.49,0.00,'2022-08-06 12:11:22','',''),(2307,'1','275',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3610950.00,5430.00,0.00,0.00,'2022-08-06 14:39:08','',''),(2308,'1','275',NULL,1,'Reception corrector for bridging 12',0.00,0.00,0.00,5430.00,0.00,'2022-08-06 14:40:29','',''),(2309,'1','275','1',1,'Received from bridging 12',0.00,0.00,5430.00,0.00,0.00,'2022-08-06 14:40:29','',''),(2310,'1','275','1',1,'Retail Sale Id 2277',9300.00,0.00,0.00,12.50,987.50,'2022-08-06 14:42:00','',''),(2311,'1','275','1',1,'Retail Sale Id 2278',8340.00,0.00,0.00,12.00,360.00,'2022-08-06 14:43:13','',''),(2312,'1','275','1',1,'Retail Sale Id 2279',9300.00,0.00,0.00,12.50,987.50,'2022-08-06 14:45:20','',''),(2313,'1','275','1',1,'Retail Sale Id 2280',8340.00,0.00,0.00,12.00,360.00,'2022-08-06 15:05:13','',''),(2314,'1','275','1',1,'Retail Sale Id 2281',8687.50,0.00,0.00,12.50,375.00,'2022-08-06 15:05:58','',''),(2315,'1','275','1',1,'Retail Sale Id 2282',4501.20,0.00,0.00,6.05,477.95,'2022-08-06 15:15:03','',''),(2316,'1','275','1',1,'Retail Sale Id 2283',14999.04,0.00,0.00,20.16,1592.64,'2022-08-06 15:22:22','',''),(2317,'1','275','1',1,'Retail Sale Id 2284',1502.88,0.00,0.00,2.02,159.58,'2022-08-06 15:28:35','',''),(2318,'1','275','1',1,'Retail Sale Id 2285',2998.32,0.00,0.00,4.03,318.37,'2022-08-06 15:29:31','',''),(2319,'1','275','1',1,'Retail Sale Id 2286',9300.00,0.00,0.00,12.50,987.50,'2022-08-06 15:31:14','',''),(2320,'1','275','1',1,'Retail Sale Id 2287',3720.00,0.00,0.00,5.00,395.00,'2022-08-06 15:33:03','',''),(2321,'1','275','1',1,'Retail Sale Id 2288',2298.96,0.00,0.00,3.09,244.11,'2022-08-06 15:39:47','',''),(2322,'1','275','1',1,'Retail Sale Id 2289',1502.88,0.00,0.00,2.02,159.58,'2022-08-06 15:41:02','',''),(2323,'1','275','1',1,'Retail Sale Id 2290',8496.48,0.00,0.00,11.42,902.18,'2022-08-06 15:45:28','',''),(2324,'1','275','1',1,'Retail Sale Id 2291',2098.08,0.00,0.00,2.82,222.78,'2022-08-06 15:57:05','',''),(2325,'1','275','1',1,'Retail Sale Id 2292',1197.84,0.00,0.00,1.61,127.19,'2022-08-06 15:57:49','',''),(2326,'1','275','1',1,'Retail Sale Id 2293',8340.00,0.00,0.00,12.00,360.00,'2022-08-06 15:58:34','',''),(2327,'1','275','1',1,'Retail Sale Id 2294',9300.00,0.00,0.00,12.50,987.50,'2022-08-06 15:59:55','',''),(2328,'1','275','1',1,'Retail Sale Id 2295',4501.20,0.00,0.00,6.05,477.95,'2022-08-06 16:08:57','',''),(2329,'1','275','1',1,'Retail Sale Id 2296',2298.96,0.00,0.00,3.09,244.11,'2022-08-06 16:12:03','',''),(2330,'1','275','1',1,'Retail Sale Id 2297',9300.00,0.00,0.00,12.50,987.50,'2022-08-06 16:25:23','',''),(2331,'1','275','1',1,'Retail Sale Id 2298',4999.68,0.00,0.00,6.72,530.88,'2022-08-06 16:29:13','',''),(2332,'1','275','1',1,'Retail Sale Id 2299',4501.20,0.00,0.00,6.05,477.95,'2022-08-06 16:41:35','',''),(2333,'1','275','1',1,'Retail Sale Id 2300',4501.20,0.00,0.00,6.05,477.95,'2022-08-06 16:45:12','',''),(2334,'1','275','1',1,'Retail Sale Id 2301',9300.00,0.00,0.00,12.50,987.50,'2022-08-06 16:46:15','',''),(2335,'1','275','1',1,'Retail Sale Id 2302',9300.00,0.00,0.00,12.50,987.50,'2022-08-06 16:52:34','',''),(2336,'1','275','1',1,'Retail Sale Id 2303',2998.32,0.00,0.00,4.03,318.37,'2022-08-06 17:11:51','',''),(2337,'1','275','1',1,'Retail Sale Id 2304',9300.00,0.00,0.00,12.50,987.50,'2022-08-06 17:12:56','',''),(2338,'1','275','1',1,'Retail Sale Id 2305',2998.32,0.00,0.00,4.03,318.37,'2022-08-06 17:27:01','',''),(2339,'1','275','1',1,'Retail Sale Id 2306',79230.00,0.00,0.00,114.00,3420.00,'2022-08-06 17:29:57','',''),(2340,'1','275','1',1,'Retail Sale Id 2307',104250.00,0.00,0.00,150.00,4500.00,'2022-08-06 17:33:41','',''),(2341,'1','275','1',1,'Retail Sale Id 2308',61160.00,0.00,0.00,88.00,2640.00,'2022-08-06 17:41:28','',''),(2342,'1','275','1',1,'Retail Sale Id 2309',9300.00,0.00,0.00,12.50,987.50,'2022-08-06 17:42:12','',''),(2343,'1','275','1',1,'Retail Sale Id 2310',803.52,0.00,0.00,1.08,85.32,'2022-08-06 17:44:29','',''),(2344,'1','275','1',1,'Retail Sale Id 2311',1502.88,0.00,0.00,2.02,159.58,'2022-08-06 17:45:40','',''),(2345,'1','275','1',1,'Retail Sale Id 2312',1502.88,0.00,0.00,2.02,159.58,'2022-08-06 17:46:50','',''),(2346,'1','275','1',1,'Retail Sale Id 2313',2001.36,0.00,0.00,2.69,212.51,'2022-08-06 17:56:16','',''),(2347,'1','275','1',1,'Retail Sale Id 2314',2001.36,0.00,0.00,2.69,212.51,'2022-08-06 17:57:34','',''),(2348,'1','275','1',1,'Retail Sale Id 2315',5208.00,0.00,0.00,7.00,553.00,'2022-08-06 18:03:00','',''),(2349,'1','275','1',1,'Retail Sale Id 2316',9300.00,0.00,0.00,12.50,987.50,'2022-08-06 18:08:52','',''),(2350,'1','275','1',1,'Retail Sale Id 2317',2998.32,0.00,0.00,4.03,318.37,'2022-08-06 18:10:04','',''),(2351,'1','275','1',1,'Retail Sale Id 2318',9300.00,0.00,0.00,12.50,987.50,'2022-08-06 18:11:01','',''),(2352,'1','275','1',1,'Retail Sale Id 2319',1502.88,0.00,0.00,2.02,159.58,'2022-08-06 18:21:53','',''),(2353,'1','275','1',1,'Retail Sale Id 2320',2998.32,0.00,0.00,4.03,318.37,'2022-08-06 18:22:47','',''),(2354,'1','275','1',1,'Retail Sale Id 2321',2499.84,0.00,0.00,3.36,265.44,'2022-08-06 18:35:08','',''),(2355,'1','275','1',1,'Retail Sale Id 2322',9300.00,0.00,0.00,12.50,987.50,'2022-08-06 18:39:03','',''),(2356,'1','275','1',1,'Retail Sale Id 2323',4501.20,0.00,0.00,6.05,477.95,'2022-08-06 18:43:28','',''),(2357,'1','275','1',1,'Retail Sale Id 2324',9300.00,0.00,0.00,12.50,987.50,'2022-08-06 18:51:19','',''),(2358,'1','275','1',1,'Retail Sale Id 2326',8687.50,0.00,0.00,12.50,375.00,'2022-08-06 19:05:16','',''),(2359,'1','275','1',1,'Retail Sale Id 2327',99904.32,0.00,0.00,134.28,10608.12,'2022-08-06 19:28:57','',''),(2360,'1','275','1',1,'Retail Sale Id 2328',43541.75,0.00,0.00,62.65,1879.50,'2022-08-06 19:30:17','',''),(2361,'1','275','1',1,'Retail Sale Id 2329',2998.32,0.00,0.00,4.03,318.37,'2022-08-07 07:29:20','',''),(2362,'1','275','1',1,'Retail Sale Id 2330',4501.20,0.00,0.00,6.05,477.95,'2022-08-07 07:31:59','',''),(2363,'1','275','1',1,'Retail Sale Id 2331',1502.88,0.00,0.00,2.02,159.58,'2022-08-07 07:32:49','',''),(2364,'1','275','1',1,'Retail Sale Id 2332',4501.20,0.00,0.00,6.05,477.95,'2022-08-07 08:01:37','',''),(2365,'1','275','1',1,'Retail Sale Id 2333',1502.88,0.00,0.00,2.02,159.58,'2022-08-07 08:05:04','',''),(2366,'1','275','1',1,'Retail Sale Id 2334',2998.32,0.00,0.00,4.03,318.37,'2022-08-07 08:07:18','',''),(2367,'1','275','1',1,'Retail Sale Id 2335',3720.00,0.00,0.00,5.00,395.00,'2022-08-07 08:12:25','',''),(2368,'1','275','1',1,'Retail Sale Id 2336',16332.50,0.00,0.00,23.50,705.00,'2022-08-07 08:22:35','',''),(2369,'1','275','1',1,'Retail Sale Id 2337',996.96,0.00,0.00,1.34,105.86,'2022-08-07 08:39:56','',''),(2370,'1','275','1',1,'Retail Sale Id 2338',28272.00,0.00,0.00,38.00,3002.00,'2022-08-07 09:05:25','',''),(2371,'1','275','1',1,'Retail Sale Id 2339',3720.00,0.00,0.00,5.00,395.00,'2022-08-07 09:28:29','',''),(2372,'1','275','1',1,'Retail Sale Id 2340',2298.96,0.00,0.00,3.09,244.11,'2022-08-07 09:30:08','',''),(2373,'1','275','1',1,'Retail Sale Id 2341',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 09:31:39','',''),(2374,'1','275','1',1,'Retail Sale Id 2342',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 09:33:30','',''),(2375,'1','275','1',1,'Retail Sale Id 2343',3720.00,0.00,0.00,5.00,395.00,'2022-08-07 09:34:32','',''),(2376,'1','275','1',1,'Retail Sale Id 2344',2499.84,0.00,0.00,3.36,265.44,'2022-08-07 09:40:42','',''),(2377,'1','275','1',1,'Retail Sale Id 2345',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 09:48:54','',''),(2378,'1','275','1',1,'Retail Sale Id 2346',2001.36,0.00,0.00,2.69,212.51,'2022-08-07 10:01:27','',''),(2379,'1','275','1',1,'Retail Sale Id 2347',13020.00,0.00,0.00,17.50,1382.50,'2022-08-07 10:16:01','',''),(2380,'1','275','1',1,'Retail Sale Id 2348',2001.36,0.00,0.00,2.69,212.51,'2022-08-07 10:17:49','',''),(2381,'1','275','1',1,'Retail Sale Id 2349',2001.36,0.00,0.00,2.69,212.51,'2022-08-07 10:21:59','',''),(2382,'1','275','1',1,'Retail Sale Id 2350',996.96,0.00,0.00,1.34,105.86,'2022-08-07 10:23:09','',''),(2383,'1','275','1',1,'Retail Sale Id 2351',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 10:33:21','',''),(2384,'1','275','1',1,'Retail Sale Id 2352',13764.00,0.00,0.00,18.50,1461.50,'2022-08-07 10:34:25','',''),(2385,'1','275','1',1,'Retail Sale Id 2353',996.96,0.00,0.00,1.34,105.86,'2022-08-07 10:38:31','',''),(2386,'1','275','1',1,'Retail Sale Id 2354',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 10:41:48','',''),(2387,'1','275','1',1,'Retail Sale Id 2356',8340.00,0.00,0.00,12.00,360.00,'2022-08-07 10:43:58','',''),(2388,'1','275','1',1,'Retail Sale Id 2357',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 10:58:09','',''),(2389,'1','275','1',1,'Retail Sale Id 2358',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 11:12:48','',''),(2390,'1','275','1',1,'Retail Sale Id 2359',996.96,0.00,0.00,1.34,105.86,'2022-08-07 11:14:40','',''),(2391,'1','275','1',1,'Retail Sale Id 2360',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 11:20:25','',''),(2392,'1','275','1',1,'Retail Sale Id 2361',11904.00,0.00,0.00,16.00,1264.00,'2022-08-07 11:26:22','',''),(2393,'1','275','1',1,'Retail Sale Id 2362',4501.20,0.00,0.00,6.05,477.95,'2022-08-07 11:34:04','',''),(2394,'1','275','1',1,'Retail Sale Id 2363',23630.00,0.00,0.00,34.00,1020.00,'2022-08-07 11:35:59','',''),(2395,'1','275','1',1,'Retail Sale Id 2364',34750.00,0.00,0.00,50.00,1500.00,'2022-08-07 11:40:37','',''),(2396,'1','275','1',1,'Retail Sale Id 2365',2298.96,0.00,0.00,3.09,244.11,'2022-08-07 11:43:21','',''),(2397,'1','275','1',1,'Retail Sale Id 2366',9002.40,0.00,0.00,12.10,955.90,'2022-08-07 11:48:09','',''),(2398,'1','275','1',1,'Retail Sale Id 2367',25999.95,0.00,0.00,37.41,1122.30,'2022-08-07 11:55:06','',''),(2399,'1','275','1',1,'Retail Sale Id 2368',4300.32,0.00,0.00,5.78,456.62,'2022-08-07 11:57:08','',''),(2400,'1','275','1',1,'Retail Sale Id 2369',1502.88,0.00,0.00,2.02,159.58,'2022-08-07 11:58:18','',''),(2401,'1','275','1',1,'Retail Sale Id 2370',13764.00,0.00,0.00,18.50,1461.50,'2022-08-07 12:05:58','',''),(2402,'1','275','1',1,'Retail Sale Id 2371',4501.20,0.00,0.00,6.05,477.95,'2022-08-07 12:18:20','',''),(2403,'1','275','1',1,'Retail Sale Id 2372',996.96,0.00,0.00,1.34,105.86,'2022-08-07 12:19:34','',''),(2404,'1','275','1',1,'Retail Sale Id 2373',2298.96,0.00,0.00,3.09,244.11,'2022-08-07 12:34:51','',''),(2405,'1','275','1',1,'Retail Sale Id 2374',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 12:37:12','',''),(2406,'1','275','1',1,'Retail Sale Id 2375',18600.00,0.00,0.00,25.00,1975.00,'2022-08-07 12:40:16','',''),(2407,'1','275','1',1,'Retail Sale Id 2376',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 12:42:15','',''),(2408,'1','275','1',1,'Retail Sale Id 2377',1502.88,0.00,0.00,2.02,159.58,'2022-08-07 12:44:09','',''),(2409,'1','275','1',1,'Retail Sale Id 2378',3720.00,0.00,0.00,5.00,395.00,'2022-08-07 13:10:30','',''),(2410,'1','275','1',1,'Retail Sale Id 2380',4501.20,0.00,0.00,6.05,477.95,'2022-08-07 13:14:55','',''),(2411,'1','275','1',1,'Retail Sale Id 2381',103555.00,0.00,0.00,149.00,4470.00,'2022-08-07 13:21:35','',''),(2412,'1','275','1',1,'Retail Sale Id 2382',7992.50,0.00,0.00,11.50,345.00,'2022-08-07 13:27:36','',''),(2413,'1','275','1',1,'Retail Sale Id 2383',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 13:31:15','',''),(2414,'1','275','1',1,'Retail Sale Id 2384',4501.20,0.00,0.00,6.05,477.95,'2022-08-07 13:33:09','',''),(2415,'1','275','1',1,'Retail Sale Id 2385',996.96,0.00,0.00,1.34,105.86,'2022-08-07 13:39:26','',''),(2416,'1','275','1',1,'Retail Sale Id 2386',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 13:41:30','',''),(2417,'1','275','1',1,'Retail Sale Id 2387',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 13:46:35','',''),(2418,'1','275','1',1,'Retail Sale Id 2388',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 13:49:25','',''),(2419,'1','275','1',1,'Retail Sale Id 2389',2998.32,0.00,0.00,4.03,318.37,'2022-08-07 13:51:00','',''),(2420,'1','275','1',1,'Retail Sale Id 2390',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 13:52:10','',''),(2421,'1','275','1',1,'Retail Sale Id 2391',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 13:54:50','',''),(2422,'1','275','1',1,'Retail Sale Id 2392',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 13:59:49','',''),(2423,'1','275','1',1,'Retail Sale Id 2393',4501.20,0.00,0.00,6.05,477.95,'2022-08-07 14:08:09','',''),(2424,'1','275','1',1,'Retail Sale Id 2394',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 14:09:38','',''),(2425,'1','275','1',1,'Retail Sale Id 2395',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 14:12:07','',''),(2426,'1','275','1',1,'Retail Sale Id 2396',2998.32,0.00,0.00,4.03,318.37,'2022-08-07 14:19:49','',''),(2427,'1','275','1',1,'Retail Sale Id 2397',69500.00,0.00,0.00,100.00,3000.00,'2022-08-07 14:40:09','',''),(2428,'1','275','1',1,'Retail Sale Id 2398',18600.00,0.00,0.00,25.00,1975.00,'2022-08-07 14:44:27','',''),(2429,'1','275','1',1,'Retail Sale Id 2399',4501.20,0.00,0.00,6.05,477.95,'2022-08-07 14:46:05','',''),(2430,'1','275','1',1,'Retail Sale Id 2400',4002.72,0.00,0.00,5.38,425.02,'2022-08-07 14:48:10','',''),(2431,'1','275','1',1,'Retail Sale Id 2401',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 14:55:08','',''),(2432,'1','275','1',1,'Retail Sale Id 2402',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 15:22:58','',''),(2433,'1','275','1',1,'Retail Sale Id 2403',2298.96,0.00,0.00,3.09,244.11,'2022-08-07 15:27:10','',''),(2434,'1','275','1',1,'Retail Sale Id 2404',16332.50,0.00,0.00,23.50,705.00,'2022-08-07 15:30:38','',''),(2435,'1','275','1',1,'Retail Sale Id 2405',996.96,0.00,0.00,1.34,105.86,'2022-08-07 15:32:18','',''),(2436,'1','275','1',1,'Retail Sale Id 2406',37200.00,0.00,0.00,50.00,3950.00,'2022-08-07 15:45:36','',''),(2437,'1','275','1',1,'Retail Sale Id 2407',2998.32,0.00,0.00,4.03,318.37,'2022-08-07 15:51:10','',''),(2438,'1','275','1',1,'Retail Sale Id 2408',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 15:55:41','',''),(2439,'1','275','1',1,'Retail Sale Id 2409',16740.00,0.00,0.00,22.50,1777.50,'2022-08-07 15:57:23','',''),(2440,'1','275','1',1,'Retail Sale Id 2410',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 15:59:27','',''),(2441,'1','275','1',1,'Retail Sale Id 2411',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 16:04:10','',''),(2442,'1','275','1',1,'Retail Sale Id 2412',4501.20,0.00,0.00,6.05,477.95,'2022-08-07 16:10:20','',''),(2443,'1','275','1',1,'Retail Sale Id 2413',46500.00,0.00,0.00,62.50,4937.50,'2022-08-07 16:16:57','',''),(2444,'1','275','1',1,'Retail Sale Id 2414',17856.00,0.00,0.00,24.00,1896.00,'2022-08-07 16:25:51','',''),(2445,'1','275','1',1,'Retail Sale Id 2415',18600.00,0.00,0.00,25.00,1975.00,'2022-08-07 16:32:44','',''),(2446,'1','275','1',1,'Retail Sale Id 2416',15985.00,0.00,0.00,23.00,690.00,'2022-08-07 16:44:34','',''),(2447,'1','275','1',1,'Retail Sale Id 2417',3720.00,0.00,0.00,5.00,395.00,'2022-08-07 17:05:52','',''),(2448,'1','275','1',1,'Retail Sale Id 2418',4999.68,0.00,0.00,6.72,530.88,'2022-08-07 17:07:01','',''),(2449,'1','275','1',1,'Retail Sale Id 2419',1502.88,0.00,0.00,2.02,159.58,'2022-08-07 17:09:27','',''),(2450,'1','275','1',1,'Retail Sale Id 2420',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 17:15:33','',''),(2451,'1','275','1',1,'Retail Sale Id 2421',1502.88,0.00,0.00,2.02,159.58,'2022-08-07 17:16:22','',''),(2452,'1','275','1',1,'Retail Sale Id 2422',996.96,0.00,0.00,1.34,105.86,'2022-08-07 17:26:12','',''),(2453,'1','275','1',1,'Retail Sale Id 2423',2298.96,0.00,0.00,3.09,244.11,'2022-08-07 17:28:12','',''),(2454,'1','275','1',1,'Retail Sale Id 2424',11160.00,0.00,0.00,15.00,1185.00,'2022-08-07 17:29:12','',''),(2455,'1','275','1',1,'Retail Sale Id 2425',803.52,0.00,0.00,1.08,85.32,'2022-08-07 17:52:14','',''),(2456,'1','275','1',1,'Retail Sale Id 2426',4002.72,0.00,0.00,5.38,425.02,'2022-08-07 18:10:35','',''),(2457,'1','275','1',1,'Retail Sale Id 2427',4002.72,0.00,0.00,5.38,425.02,'2022-08-07 18:18:00','',''),(2458,'1','275','1',1,'Retail Sale Id 2428',4501.20,0.00,0.00,6.05,477.95,'2022-08-07 18:30:10','',''),(2459,'1','275','1',1,'Retail Sale Id 2429',4501.20,0.00,0.00,6.05,477.95,'2022-08-07 18:39:53','',''),(2460,'1','275','1',1,'Retail Sale Id 2430',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 18:40:52','',''),(2461,'1','275','1',1,'Retail Sale Id 2431',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 18:42:18','',''),(2462,'1','275','1',1,'Retail Sale Id 2432',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 18:48:07','',''),(2463,'1','275','1',1,'Retail Sale Id 2433',8340.00,0.00,0.00,12.00,360.00,'2022-08-07 18:56:15','',''),(2464,'1','275','1',1,'Retail Sale Id 2434',2298.96,0.00,0.00,3.09,244.11,'2022-08-07 18:57:47','',''),(2465,'1','275','1',1,'Retail Sale Id 2435',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 19:03:54','',''),(2466,'1','275','1',1,'Return of Retail Sale Id 2427',0.00,4002.72,5.38,0.00,-425.02,'2022-08-07 19:24:20','',''),(2467,'1','275','1',1,'Retail Sale Id 2436',16638.30,0.00,0.00,23.94,718.20,'2022-08-07 19:27:01','',''),(2468,'1','275','1',1,'Retail Sale Id 2437',1294.56,0.00,0.00,1.74,137.46,'2022-08-07 19:27:37','',''),(2469,'1','275','1',1,'Retail Sale Id 2438',1003.20,0.00,0.00,1.32,125.40,'2022-08-08 07:16:18','',''),(2470,'1','275','1',1,'Retail Sale Id 2439',9500.00,0.00,0.00,12.50,1187.50,'2022-08-08 08:14:59','',''),(2471,'1','275','1',1,'Retail Sale Id 2440',1998.80,0.00,0.00,2.63,249.85,'2022-08-08 08:16:02','',''),(2472,'1','275','1',1,'Retail Sale Id 2441',2302.80,0.00,0.00,3.03,287.85,'2022-08-08 08:21:59','',''),(2473,'1','275','1',1,'Retail Sale Id 2442',15998.00,0.00,0.00,21.05,1999.75,'2022-08-08 08:26:30','',''),(2474,'1','275','1',1,'Retail Sale Id 2443',9500.00,0.00,0.00,12.50,1187.50,'2022-08-08 08:28:28','',''),(2475,'1','275','1',1,'Retail Sale Id 2444',2302.80,0.00,0.00,3.03,287.85,'2022-08-08 08:34:17','',''),(2476,'1','275','1',1,'Retail Sale Id 2445',9500.00,0.00,0.00,12.50,1187.50,'2022-08-08 08:44:49','',''),(2477,'1','275','1',1,'Retail Sale Id 2446',1520.00,0.00,0.00,2.00,190.00,'2022-08-08 08:57:00','',''),(2478,'1','275','1',1,'Retail Sale Id 2447',7220.00,0.00,0.00,9.50,902.50,'2022-08-08 09:07:18','',''),(2479,'1','275','1',1,'Retail Sale Id 2448',19000.00,0.00,0.00,25.00,2375.00,'2022-08-08 09:15:11','',''),(2480,'1','275','1',1,'Retail Sale Id 2449',4750.00,0.00,0.00,6.25,593.75,'2022-08-08 09:22:25','',''),(2481,'1','275','1',1,'Retail Sale Id 2449',9500.00,0.00,0.00,12.50,1187.50,'2022-08-08 09:22:25','',''),(2482,'1','275','1',1,'Retail Sale Id 2450',9500.00,0.00,0.00,12.50,1187.50,'2022-08-08 09:23:57','',''),(2483,'1','275','1',1,'Retail Sale Id 2451',9500.00,0.00,0.00,12.50,1187.50,'2022-08-08 09:36:59','',''),(2484,'1','275','1',1,'Retail Sale Id 2452',5000.80,0.00,0.00,6.58,625.10,'2022-08-08 09:57:43','',''),(2485,'1','275','1',1,'Retail Sale Id 2453',9500.00,0.00,0.00,12.50,1187.50,'2022-08-08 09:59:55','',''),(2486,'1','275','1',1,'Retail Sale Id 2454',8360.00,0.00,0.00,11.00,1045.00,'2022-08-08 10:09:02','',''),(2487,'1','275','1',1,'Retail Sale Id 2455',9500.00,0.00,0.00,12.50,1187.50,'2022-08-08 10:09:48','',''),(2488,'1','275','1',1,'Retail Sale Id 2456',6999.60,0.00,0.00,9.21,874.95,'2022-08-08 10:14:50','',''),(2489,'1','275','1',1,'Retail Sale Id 2457',4096.40,0.00,0.00,5.39,512.05,'2022-08-08 10:16:45','',''),(2490,'1','275','1',1,'Retail Sale Id 2458',3002.00,0.00,0.00,3.95,375.25,'2022-08-08 10:38:50','',''),(2491,'1','275','1',1,'Return of Retail Sale Id 2458',0.00,3002.00,3.95,0.00,-375.25,'2022-08-08 10:40:13','',''),(2492,'1','275','1',1,'Retail Sale Id 2459',3040.00,0.00,0.00,4.00,380.00,'2022-08-08 10:40:42','',''),(2493,'1','275','1',1,'Retail Sale Id 2460',4560.00,0.00,0.00,6.00,570.00,'2022-08-08 10:47:58','',''),(2494,'1','275','1',1,'Retail Sale Id 2461',3040.00,0.00,0.00,4.00,380.00,'2022-08-08 11:06:53','',''),(2495,'1','275','1',1,'Retail Sale Id 2462',9500.00,0.00,0.00,12.50,1187.50,'2022-08-08 11:11:11','',''),(2496,'1','275','1',1,'Retail Sale Id 2463',9500.00,0.00,0.00,12.50,1187.50,'2022-08-08 11:18:38','',''),(2497,'1','275','1',1,'Retail Sale Id 2464',8496.80,0.00,0.00,11.18,1062.10,'2022-08-08 11:27:00','',''),(2498,'1','275','1',1,'Retail Sale Id 2465',9500.00,0.00,0.00,12.50,1187.50,'2022-08-08 11:56:10','',''),(2499,'1','275','1',1,'Retail Sale Id 2466',47500.00,0.00,0.00,62.50,5937.50,'2022-08-08 12:19:18','',''),(2500,'1','275','1',1,'Retail Sale Id 2467',9500.00,0.00,0.00,12.50,1187.50,'2022-08-08 12:36:00','',''),(2501,'1','275','1',1,'Retail Sale Id 2468',9500.00,0.00,0.00,12.50,1187.50,'2022-08-08 12:56:47','',''),(2502,'1','275','1',1,'Retail Sale Id 2469',1003.20,0.00,0.00,1.32,125.40,'2022-08-08 13:20:17','',''),(2503,'1','275','1',1,'Retail Sale Id 2470',1003.20,0.00,0.00,1.32,125.40,'2022-08-08 13:20:59','',''),(2504,'1','275','1',1,'Retail Sale Id 2471',699.20,0.00,0.00,0.92,87.40,'2022-08-08 13:21:52','',''),(2505,'1','275','1',1,'Retail Sale Id 2472',9500.00,0.00,0.00,12.50,1187.50,'2022-08-08 13:33:06','',''),(2506,'1','275','1',1,'Retail Sale Id 2473',2302.80,0.00,0.00,3.03,287.85,'2022-08-08 13:43:55','',''),(2507,'1','275','1',1,'Retail Sale Id 2474',11400.00,0.00,0.00,15.00,1425.00,'2022-08-08 14:07:48','',''),(2508,'1','275','1',1,'Retail Sale Id 2475',9500.00,0.00,0.00,12.50,1187.50,'2022-08-08 14:24:10','',''),(2509,'1','275','1',1,'Retail Sale Id 2476',4560.00,0.00,0.00,6.00,570.00,'2022-08-08 14:32:17','',''),(2510,'1','275','1',1,'Retail Sale Id 2477',9500.00,0.00,0.00,12.50,1187.50,'2022-08-08 15:16:50','',''),(2511,'1','275','1',1,'Retail Sale Id 2478',1603.60,0.00,0.00,2.11,200.45,'2022-08-08 15:19:18','',''),(2512,'1','275','1',1,'Retail Sale Id 2478',18240.00,0.00,0.00,24.00,2280.00,'2022-08-08 15:19:18','',''),(2513,'1','275','1',1,'Retail Sale Id 2479',28500.00,0.00,0.00,37.50,3562.50,'2022-08-08 15:35:17','',''),(2514,'1','275','1',1,'Retail Sale Id 2480',9500.00,0.00,0.00,12.50,1187.50,'2022-08-08 15:44:12','',''),(2515,'1','275','1',1,'Retail Sale Id 2481',8496.80,0.00,0.00,11.18,1062.10,'2022-08-08 16:05:10','',''),(2516,'1','275','1',1,'Retail Sale Id 2482',3002.00,0.00,0.00,3.95,375.25,'2022-08-08 16:19:32','',''),(2517,'1','275','1',1,'Retail Sale Id 2483',9500.00,0.00,0.00,12.50,1187.50,'2022-08-08 16:27:11','',''),(2518,'1','275','1',1,'Retail Sale Id 2484',8496.80,0.00,0.00,11.18,1062.10,'2022-08-08 16:28:20','',''),(2519,'1','275','1',1,'Retail Sale Id 2485',4750.00,0.00,0.00,6.25,593.75,'2022-08-08 16:57:57','',''),(2520,'1','275','1',1,'Retail Sale Id 2486',7600.00,0.00,0.00,10.00,950.00,'2022-08-08 17:05:18','',''),(2521,'1','275','1',1,'Retail Sale Id 2487',9500.00,0.00,0.00,12.50,1187.50,'2022-08-08 17:10:18','',''),(2522,'1','275','1',1,'Retail Sale Id 2488',4560.00,0.00,0.00,6.00,570.00,'2022-08-08 17:11:52','',''),(2523,'1','275','1',1,'Retail Sale Id 2489',9500.00,0.00,0.00,12.50,1187.50,'2022-08-08 17:13:44','',''),(2524,'1','275','1',1,'Retail Sale Id 2490',19000.00,0.00,0.00,25.00,2375.00,'2022-08-08 17:16:13','',''),(2525,'1','275','1',1,'Retail Sale Id 2491',9500.00,0.00,0.00,12.50,1187.50,'2022-08-08 17:18:47','',''),(2526,'1','275','1',1,'Retail Sale Id 2492',9500.00,0.00,0.00,12.50,1187.50,'2022-08-08 17:20:13','',''),(2527,'1','275','1',1,'Retail Sale Id 2493',9500.00,0.00,0.00,12.50,1187.50,'2022-08-08 17:21:59','',''),(2528,'1','275','1',1,'Retail Sale Id 2494',9500.00,0.00,0.00,12.50,1187.50,'2022-08-08 17:28:18','',''),(2529,'1','275','1',1,'Retail Sale Id 2495',2302.80,0.00,0.00,3.03,287.85,'2022-08-08 17:33:37','',''),(2530,'1','275','1',1,'Retail Sale Id 2496',3997.60,0.00,0.00,5.26,499.70,'2022-08-08 17:35:02','',''),(2531,'1','275','1',1,'Retail Sale Id 2497',19000.00,0.00,0.00,25.00,2375.00,'2022-08-08 17:36:10','',''),(2532,'1','275','1',1,'Retail Sale Id 2498',1998.80,0.00,0.00,2.63,249.85,'2022-08-08 17:38:10','',''),(2533,'1','275','1',1,'Retail Sale Id 2499',2302.80,0.00,0.00,3.03,287.85,'2022-08-08 17:46:10','',''),(2534,'1','275','1',1,'Retail Sale Id 2500',5996.40,0.00,0.00,7.89,749.55,'2022-08-08 17:54:38','',''),(2535,'1','275','1',1,'Retail Sale Id 2501',8496.80,0.00,0.00,11.18,1062.10,'2022-08-08 18:03:02','',''),(2536,'1','275','1',1,'Retail Sale Id 2502',4560.00,0.00,0.00,6.00,570.00,'2022-08-08 18:06:22','',''),(2537,'1','275','1',1,'Retail Sale Id 2503',9500.00,0.00,0.00,12.50,1187.50,'2022-08-08 18:08:44','',''),(2538,'1','275','1',1,'Retail Sale Id 2504',760.00,0.00,0.00,1.00,95.00,'2022-08-08 18:10:25','',''),(2539,'1','275','1',1,'Retail Sale Id 2505',1003.20,0.00,0.00,1.32,125.40,'2022-08-08 18:11:39','',''),(2540,'1','275','1',1,'Retail Sale Id 2506',17480.00,0.00,0.00,23.00,2185.00,'2022-08-08 18:12:15','',''),(2541,'1','275','1',1,'Retail Sale Id 2507',3800.00,0.00,0.00,5.00,475.00,'2022-08-08 18:13:19','',''),(2542,'1','275','1',1,'Retail Sale Id 2508',1497.20,0.00,0.00,1.97,187.15,'2022-08-08 18:19:26','',''),(2543,'1','275','1',1,'Retail Sale Id 2509',2302.80,0.00,0.00,3.03,287.85,'2022-08-08 18:20:55','',''),(2544,'1','275','1',1,'Retail Sale Id 2510',1497.20,0.00,0.00,1.97,187.15,'2022-08-08 18:33:49','',''),(2545,'1','275','1',1,'Retail Sale Id 2511',3800.00,0.00,0.00,5.00,475.00,'2022-08-08 18:49:17','',''),(2546,'1','275','1',1,'Retail Sale Id 2512',9500.00,0.00,0.00,12.50,1187.50,'2022-08-08 18:50:56','',''),(2547,'1','275','1',1,'Retail Sale Id 2513',9500.00,0.00,0.00,12.50,1187.50,'2022-08-08 19:01:58','',''),(2548,'1','275','1',1,'Retail Sale Id 2514',29640.00,0.00,0.00,39.00,3705.00,'2022-08-08 19:20:07','',''),(2549,'1','275','1',1,'Retail Sale Id 2515',8496.80,0.00,0.00,11.18,1062.10,'2022-08-09 07:14:35','',''),(2550,'1','275','1',1,'Retail Sale Id 2516',2302.80,0.00,0.00,3.03,287.85,'2022-08-09 07:53:46','',''),(2551,'1','275','1',1,'Retail Sale Id 2517',8002.80,0.00,0.00,10.53,1000.35,'2022-08-09 07:58:23','',''),(2552,'1','275','1',1,'Retail Sale Id 2518',19000.00,0.00,0.00,25.00,2375.00,'2022-08-09 08:18:11','',''),(2553,'1','275','1',1,'Retail Sale Id 2520',9500.00,0.00,0.00,12.50,1187.50,'2022-08-09 08:31:03','',''),(2554,'1','275','1',1,'Retail Sale Id 2520',38000.00,0.00,0.00,50.00,4750.00,'2022-08-09 08:31:03','',''),(2555,'1','275','1',1,'Retail Sale Id 2521',9500.00,0.00,0.00,12.50,1187.50,'2022-08-09 08:32:16','',''),(2556,'1','275','1',1,'Retail Sale Id 2522',9500.00,0.00,0.00,12.50,1187.50,'2022-08-09 08:52:38','',''),(2557,'1','275','1',1,'Retail Sale Id 2523',9500.00,0.00,0.00,12.50,1187.50,'2022-08-09 08:56:49','',''),(2558,'1','275','1',1,'Retail Sale Id 2524',9500.00,0.00,0.00,12.50,1187.50,'2022-08-09 09:00:18','',''),(2559,'1','275','1',1,'Retail Sale Id 2525',3800.00,0.00,0.00,5.00,475.00,'2022-08-09 09:06:24','',''),(2560,'1','275','1',1,'Retail Sale Id 2526',3800.00,0.00,0.00,5.00,475.00,'2022-08-09 09:11:09','',''),(2561,'1','275','1',1,'Retail Sale Id 2527',1003.20,0.00,0.00,1.32,125.40,'2022-08-09 09:24:57','',''),(2562,'1','275','1',1,'Retail Sale Id 2528',11780.00,0.00,0.00,15.50,1472.50,'2022-08-09 09:26:04','',''),(2563,'1','275','1',1,'Retail Sale Id 2529',1998.80,0.00,0.00,2.63,249.85,'2022-08-09 09:33:40','',''),(2564,'1','275','1',1,'Retail Sale Id 2530',9500.00,0.00,0.00,12.50,1187.50,'2022-08-09 09:35:06','',''),(2565,'1','275','1',1,'Retail Sale Id 2531',1998.80,0.00,0.00,2.63,249.85,'2022-08-09 09:36:22','',''),(2566,'1','275','1',1,'Retail Sale Id 2532',9500.00,0.00,0.00,12.50,1187.50,'2022-08-09 09:38:53','',''),(2567,'1','275','1',1,'Retail Sale Id 2533',9120.00,0.00,0.00,12.00,1140.00,'2022-08-09 09:46:25','',''),(2568,'1','275','1',1,'Retail Sale Id 2534',9500.00,0.00,0.00,12.50,1187.50,'2022-08-09 10:14:18','',''),(2569,'1','275','1',1,'Retail Sale Id 2535',3002.00,0.00,0.00,3.95,375.25,'2022-08-09 10:20:03','',''),(2570,'1','275','1',1,'Retail Sale Id 2536',1998.80,0.00,0.00,2.63,249.85,'2022-08-09 10:21:15','',''),(2571,'1','275','1',1,'Retail Sale Id 2537',4499.20,0.00,0.00,5.92,562.40,'2022-08-09 10:29:57','',''),(2572,'1','275','1',1,'Retail Sale Id 2538',10001.60,0.00,0.00,13.16,1250.20,'2022-08-09 11:08:49','',''),(2573,'1','275','1',1,'Retail Sale Id 2539',1003.20,0.00,0.00,1.32,125.40,'2022-08-09 11:10:01','',''),(2574,'1','275','1',1,'Retail Sale Id 2540',9500.00,0.00,0.00,12.50,1187.50,'2022-08-09 11:14:52','',''),(2575,'1','275','1',1,'Retail Sale Id 2541',9500.00,0.00,0.00,12.50,1187.50,'2022-08-09 11:26:37','',''),(2576,'1','275','1',1,'Retail Sale Id 2542',1998.80,0.00,0.00,2.63,249.85,'2022-08-09 11:40:38','',''),(2577,'1','275','1',1,'Retail Sale Id 2543',9500.00,0.00,0.00,12.50,1187.50,'2022-08-09 11:53:08','',''),(2578,'1','275','1',1,'Retail Sale Id 2544',28500.00,0.00,0.00,37.50,3562.50,'2022-08-09 12:21:12','',''),(2579,'1','275','1',1,'Retail Sale Id 2545',2302.80,0.00,0.00,3.03,287.85,'2022-08-09 12:35:51','',''),(2580,'1','275','1',1,'Retail Sale Id 2546',11802.80,0.00,0.00,15.53,1475.35,'2022-08-09 12:57:59','',''),(2581,'1','275','1',1,'Retail Sale Id 2547',3800.00,0.00,0.00,5.00,475.00,'2022-08-09 13:04:03','',''),(2582,'1','275','1',1,'Retail Sale Id 2548',9500.00,0.00,0.00,12.50,1187.50,'2022-08-09 13:14:22','',''),(2583,'1','275','1',1,'Retail Sale Id 2549',19000.00,0.00,0.00,25.00,2375.00,'2022-08-09 13:16:20','',''),(2584,'1','275','1',1,'Retail Sale Id 2550',68400.00,0.00,0.00,90.00,8550.00,'2022-08-09 13:23:23','',''),(2585,'1','275','1',1,'Retail Sale Id 2551',2302.80,0.00,0.00,3.03,287.85,'2022-08-09 13:26:56','',''),(2586,'1','275','1',1,'Retail Sale Id 2552',9500.00,0.00,0.00,12.50,1187.50,'2022-08-09 13:29:50','',''),(2587,'1','275','1',1,'Retail Sale Id 2553',9500.00,0.00,0.00,12.50,1187.50,'2022-08-09 13:49:08','',''),(2588,'1','275','1',1,'Retail Sale Id 2554',4560.00,0.00,0.00,6.00,570.00,'2022-08-09 14:04:47','',''),(2589,'1','275','1',1,'Retail Sale Id 2555',3002.00,0.00,0.00,3.95,375.25,'2022-08-09 14:06:08','',''),(2590,'1','275','1',1,'Retail Sale Id 2556',9203.60,0.00,0.00,12.11,1150.45,'2022-08-09 14:19:50','',''),(2591,'1','275','1',1,'Retail Sale Id 2557',2302.80,0.00,0.00,3.03,287.85,'2022-08-09 14:27:55','',''),(2592,'1','275','1',1,'Retail Sale Id 2558',5000.80,0.00,0.00,6.58,625.10,'2022-08-09 14:51:37','',''),(2593,'1','275','1',1,'Retail Sale Id 2559',4560.00,0.00,0.00,6.00,570.00,'2022-08-09 15:05:31','',''),(2594,'1','275','1',1,'Retail Sale Id 2560',2302.80,0.00,0.00,3.03,287.85,'2022-08-09 15:06:59','',''),(2595,'1','275','1',1,'Retail Sale Id 2561',19000.00,0.00,0.00,25.00,2375.00,'2022-08-09 15:08:57','',''),(2596,'1','275','1',1,'Retail Sale Id 2562',8002.80,0.00,0.00,10.53,1000.35,'2022-08-09 15:19:25','',''),(2597,'1','275','1',1,'Retail Sale Id 2563',24700.00,0.00,0.00,32.50,3087.50,'2022-08-09 15:33:38','',''),(2598,'1','275','1',1,'Retail Sale Id 2564',4499.20,0.00,0.00,5.92,562.40,'2022-08-09 15:34:42','',''),(2599,'1','275','1',1,'Retail Sale Id 2565',3002.00,0.00,0.00,3.95,375.25,'2022-08-09 15:40:11','',''),(2600,'1','275','1',1,'Retail Sale Id 2566',9500.00,0.00,0.00,12.50,1187.50,'2022-08-09 15:43:08','',''),(2601,'1','275','1',1,'Retail Sale Id 2567',19000.00,0.00,0.00,25.00,2375.00,'2022-08-09 15:56:26','',''),(2602,'1','275','1',1,'Retail Sale Id 2568',699.20,0.00,0.00,0.92,87.40,'2022-08-09 15:59:13','',''),(2603,'1','275','1',1,'Retail Sale Id 2569',1998.80,0.00,0.00,2.63,249.85,'2022-08-09 16:42:22','',''),(2604,'1','275','1',1,'Retail Sale Id 2570',8360.00,0.00,0.00,11.00,1045.00,'2022-08-09 16:51:47','',''),(2605,'1','275','1',1,'Retail Sale Id 2571',2302.80,0.00,0.00,3.03,287.85,'2022-08-09 16:54:23','',''),(2606,'1','275','1',1,'Retail Sale Id 2572',19000.00,0.00,0.00,25.00,2375.00,'2022-08-09 16:57:33','',''),(2607,'1','275','1',1,'Retail Sale Id 2573',9500.00,0.00,0.00,12.50,1187.50,'2022-08-09 16:58:27','',''),(2608,'1','275','1',1,'Retail Sale Id 2574',3040.00,0.00,0.00,4.00,380.00,'2022-08-09 16:59:44','',''),(2609,'1','275','1',1,'Retail Sale Id 2575',9500.00,0.00,0.00,12.50,1187.50,'2022-08-09 17:02:28','',''),(2610,'1','275','1',1,'Retail Sale Id 2576',19000.00,0.00,0.00,25.00,2375.00,'2022-08-09 17:08:48','',''),(2611,'1','275','1',1,'Retail Sale Id 2577',9500.00,0.00,0.00,12.50,1187.50,'2022-08-09 17:14:19','',''),(2612,'1','275','1',1,'Retail Sale Id 2578',9500.00,0.00,0.00,12.50,1187.50,'2022-08-09 17:19:39','',''),(2613,'1','275','1',1,'Retail Sale Id 2579',19000.00,0.00,0.00,25.00,2375.00,'2022-08-09 17:42:30','',''),(2614,'1','275','1',1,'Retail Sale Id 2580',18240.00,0.00,0.00,24.00,2280.00,'2022-08-09 18:50:08','',''),(2615,'1','275','1',1,'Retail Sale Id 2581',12046.00,0.00,0.00,15.85,1505.75,'2022-08-09 19:15:33','',''),(2616,'1','275','1',1,'Retail Sale Id 2582',9500.00,0.00,0.00,12.50,1187.50,'2022-08-10 06:55:23','',''),(2617,'1','275','1',1,'Retail Sale Id 2583',2302.80,0.00,0.00,3.03,287.85,'2022-08-10 07:20:20','',''),(2618,'1','275','1',1,'Retail Sale Id 2584',5700.00,0.00,0.00,7.50,712.50,'2022-08-10 08:10:10','',''),(2619,'1','275','1',1,'Retail Sale Id 2585',9500.00,0.00,0.00,12.50,1187.50,'2022-08-10 08:11:30','',''),(2620,'1','275','1',1,'Retail Sale Id 2586',8002.80,0.00,0.00,10.53,1000.35,'2022-08-10 08:12:50','',''),(2621,'1','275','1',1,'Retail Sale Id 2587',1497.20,0.00,0.00,1.97,187.15,'2022-08-10 08:18:36','',''),(2622,'1','275','1',1,'Retail Sale Id 2587',1998.80,0.00,0.00,2.63,249.85,'2022-08-10 08:18:36','',''),(2623,'1','275','1',1,'Retail Sale Id 2588',6999.60,0.00,0.00,9.21,874.95,'2022-08-10 08:44:23','',''),(2624,'1','275','1',1,'Retail Sale Id 2588',8002.80,0.00,0.00,10.53,1000.35,'2022-08-10 08:44:23','',''),(2625,'1','275','1',1,'Retail Sale Id 2589',1998.80,0.00,0.00,2.63,249.85,'2022-08-10 08:47:22','',''),(2626,'1','275','1',1,'Retail Sale Id 2590',4598.00,0.00,0.00,6.05,574.75,'2022-08-10 08:55:07','',''),(2627,'1','275','1',1,'Retail Sale Id 2592',9500.00,0.00,0.00,12.50,1187.50,'2022-08-10 08:56:43','',''),(2628,'1','275','1',1,'Retail Sale Id 2593',5000.80,0.00,0.00,6.58,625.10,'2022-08-10 09:07:17','',''),(2629,'1','275','1',1,'Retail Sale Id 2594',1003.20,0.00,0.00,1.32,125.40,'2022-08-10 09:18:48','',''),(2630,'1','275','1',1,'Retail Sale Id 2595',9500.00,0.00,0.00,12.50,1187.50,'2022-08-10 09:19:57','',''),(2631,'1','275','1',1,'Retail Sale Id 2596',3997.60,0.00,0.00,5.26,499.70,'2022-08-10 09:24:29','',''),(2632,'1','275','1',1,'Retail Sale Id 2597',9302.40,0.00,0.00,12.24,1162.80,'2022-08-10 09:30:49','',''),(2633,'1','275','1',1,'Retail Sale Id 2597',9302.40,0.00,0.00,12.24,1162.80,'2022-08-10 09:30:49','',''),(2634,'1','275','1',1,'Retail Sale Id 2598',3997.60,0.00,0.00,5.26,499.70,'2022-08-10 09:32:29','',''),(2635,'1','275','1',1,'Retail Sale Id 2599',3800.00,0.00,0.00,5.00,475.00,'2022-08-10 09:43:38','',''),(2636,'1','275','1',1,'Retail Sale Id 2600',3040.00,0.00,0.00,4.00,380.00,'2022-08-10 09:47:30','',''),(2637,'1','275','1',1,'Retail Sale Id 2601',3800.00,0.00,0.00,5.00,475.00,'2022-08-10 10:08:06','',''),(2638,'1','275','1',1,'Retail Sale Id 2602',9500.00,0.00,0.00,12.50,1187.50,'2022-08-10 10:12:25','',''),(2639,'1','275','1',1,'Retail Sale Id 2603',9500.00,0.00,0.00,12.50,1187.50,'2022-08-10 10:16:10','',''),(2640,'1','275','1',1,'Retail Sale Id 2604',1497.20,0.00,0.00,1.97,187.15,'2022-08-10 10:21:05','',''),(2641,'1','275','1',1,'Retail Sale Id 2605',9500.00,0.00,0.00,12.50,1187.50,'2022-08-10 10:39:23','',''),(2642,'1','275','1',1,'Retail Sale Id 2606',4598.00,0.00,0.00,6.05,574.75,'2022-08-10 10:46:36','',''),(2643,'1','275','1',1,'Retail Sale Id 2607',3800.00,0.00,0.00,5.00,475.00,'2022-08-10 10:50:42','',''),(2644,'1','275','1',1,'Retail Sale Id 2607',9500.00,0.00,0.00,12.50,1187.50,'2022-08-10 10:50:42','',''),(2645,'1','275','1',1,'Retail Sale Id 2608',2302.80,0.00,0.00,3.03,287.85,'2022-08-10 11:18:48','',''),(2646,'1','275','1',1,'Retail Sale Id 2609',1497.20,0.00,0.00,1.97,187.15,'2022-08-10 11:19:31','',''),(2647,'1','275','1',1,'Retail Sale Id 2610',1497.20,0.00,0.00,1.97,187.15,'2022-08-10 11:20:44','',''),(2648,'1','275','1',1,'Retail Sale Id 2612',4598.00,0.00,0.00,6.05,574.75,'2022-08-10 11:39:37','',''),(2649,'1','275','1',1,'Retail Sale Id 2613',9500.00,0.00,0.00,12.50,1187.50,'2022-08-10 11:42:18','',''),(2650,'1','275','1',1,'Retail Sale Id 2614',1497.20,0.00,0.00,1.97,187.15,'2022-08-10 11:51:35','',''),(2651,'1','275','1',1,'Retail Sale Id 2615',9500.00,0.00,0.00,12.50,1187.50,'2022-08-10 11:55:19','',''),(2652,'1','275','1',1,'Retail Sale Id 2616',1003.20,0.00,0.00,1.32,125.40,'2022-08-10 11:56:09','',''),(2653,'1','275','1',1,'Retail Sale Id 2617',1003.20,0.00,0.00,1.32,125.40,'2022-08-10 12:06:40','',''),(2654,'1','275','1',1,'Retail Sale Id 2618',3002.00,0.00,0.00,3.95,375.25,'2022-08-10 12:09:16','',''),(2655,'1','275','1',1,'Retail Sale Id 2619',8998.40,0.00,0.00,11.84,1124.80,'2022-08-10 12:12:45','',''),(2656,'1','275','1',1,'Retail Sale Id 2620',9500.00,0.00,0.00,12.50,1187.50,'2022-08-10 12:23:47','',''),(2657,'1','275','1',1,'Retail Sale Id 2621',9500.00,0.00,0.00,12.50,1187.50,'2022-08-10 12:35:40','',''),(2658,'1','275','1',1,'Retail Sale Id 2622',9500.00,0.00,0.00,12.50,1187.50,'2022-08-10 12:38:20','',''),(2659,'1','275','1',1,'Retail Sale Id 2623',1140.00,0.00,0.00,1.50,142.50,'2022-08-10 13:07:53','',''),(2660,'1','275','1',1,'Retail Sale Id 2624',9500.00,0.00,0.00,12.50,1187.50,'2022-08-10 13:43:13','',''),(2661,'1','275','1',1,'Retail Sale Id 2625',2302.80,0.00,0.00,3.03,287.85,'2022-08-10 13:45:59','',''),(2662,'1','275','1',1,'Retail Sale Id 2626',4598.00,0.00,0.00,6.05,574.75,'2022-08-10 13:50:24','',''),(2663,'1','275','1',1,'Retail Sale Id 2627',3002.00,0.00,0.00,3.95,375.25,'2022-08-10 14:20:32','',''),(2664,'1','275','1',1,'Retail Sale Id 2628',3800.00,0.00,0.00,5.00,475.00,'2022-08-10 14:33:43','',''),(2665,'1','275','1',1,'Retail Sale Id 2629',38000.00,0.00,0.00,50.00,4750.00,'2022-08-10 15:11:52','',''),(2666,'1','275','1',1,'Retail Sale Id 2630',9500.00,0.00,0.00,12.50,1187.50,'2022-08-10 15:17:51','',''),(2667,'1','275','1',1,'Retail Sale Id 2631',10640.00,0.00,0.00,14.00,1330.00,'2022-08-10 15:19:32','',''),(2668,'1','275','1',1,'Retail Sale Id 2632',4598.00,0.00,0.00,6.05,574.75,'2022-08-10 15:24:35','',''),(2669,'1','275','1',1,'Retail Sale Id 2633',9500.00,0.00,0.00,12.50,1187.50,'2022-08-10 15:34:45','',''),(2670,'1','275','1',1,'Retail Sale Id 2634',9500.00,0.00,0.00,12.50,1187.50,'2022-08-10 15:50:40','',''),(2671,'1','275','1',1,'Retail Sale Id 2635',9500.00,0.00,0.00,12.50,1187.50,'2022-08-10 16:03:09','',''),(2672,'1','275','1',1,'Retail Sale Id 2636',1497.20,0.00,0.00,1.97,187.15,'2022-08-10 16:05:36','',''),(2673,'1','275','1',1,'Retail Sale Id 2638',19000.00,0.00,0.00,25.00,2375.00,'2022-08-10 16:12:20','',''),(2674,'1','275','1',1,'Retail Sale Id 2639',2302.80,0.00,0.00,3.03,287.85,'2022-08-10 16:13:00','',''),(2675,'1','275','1',1,'Retail Sale Id 2640',18240.00,0.00,0.00,24.00,2280.00,'2022-08-10 16:15:00','',''),(2676,'1','275','1',1,'Retail Sale Id 2641',2302.80,0.00,0.00,3.03,287.85,'2022-08-10 16:45:28','',''),(2677,'1','275','1',1,'Retail Sale Id 2642',2302.80,0.00,0.00,3.03,287.85,'2022-08-10 16:47:18','',''),(2678,'1','275','1',1,'Retail Sale Id 2643',3002.00,0.00,0.00,3.95,375.25,'2022-08-10 16:48:31','',''),(2679,'1','275','1',1,'Retail Sale Id 2644',9500.00,0.00,0.00,12.50,1187.50,'2022-08-10 16:58:30','',''),(2680,'1','275','1',1,'Retail Sale Id 2645',19000.00,0.00,0.00,25.00,2375.00,'2022-08-10 16:59:50','',''),(2681,'1','275','1',1,'Retail Sale Id 2646',9500.00,0.00,0.00,12.50,1187.50,'2022-08-10 17:07:02','',''),(2682,'1','275','1',1,'Retail Sale Id 2647',1998.80,0.00,0.00,2.63,249.85,'2022-08-10 17:22:40','',''),(2683,'1','275','1',1,'Retail Sale Id 2648',4598.00,0.00,0.00,6.05,574.75,'2022-08-10 17:29:21','',''),(2684,'1','275','1',1,'Retail Sale Id 2649',9203.60,0.00,0.00,12.11,1150.45,'2022-08-10 17:32:54','',''),(2685,'1','275','1',1,'Retail Sale Id 2650',9500.00,0.00,0.00,12.50,1187.50,'2022-08-10 17:35:23','',''),(2686,'1','275','1',1,'Retail Sale Id 2651',3503.60,0.00,0.00,4.61,437.95,'2022-08-10 17:41:45','',''),(2687,'1','275','1',1,'Retail Sale Id 2652',9500.00,0.00,0.00,12.50,1187.50,'2022-08-10 17:42:41','',''),(2688,'1','275','1',1,'Retail Sale Id 2653',3800.00,0.00,0.00,5.00,475.00,'2022-08-10 17:45:02','',''),(2689,'1','275','1',1,'Retail Sale Id 2654',1497.20,0.00,0.00,1.97,187.15,'2022-08-10 17:49:58','',''),(2690,'1','275','1',1,'Retail Sale Id 2655',9500.00,0.00,0.00,12.50,1187.50,'2022-08-10 17:56:08','',''),(2691,'1','275','1',1,'Retail Sale Id 2656',2302.80,0.00,0.00,3.03,287.85,'2022-08-10 18:05:44','',''),(2692,'1','275','1',1,'Retail Sale Id 2657',1497.20,0.00,0.00,1.97,187.15,'2022-08-10 18:19:07','',''),(2693,'1','275','1',1,'Retail Sale Id 2658',9120.00,0.00,0.00,12.00,1140.00,'2022-08-10 18:22:21','',''),(2694,'1','275','1',1,'Retail Sale Id 2659',5000.80,0.00,0.00,6.58,625.10,'2022-08-10 18:27:34','',''),(2695,'1','275','1',1,'Retail Sale Id 2660',5000.80,0.00,0.00,6.58,625.10,'2022-08-10 18:29:02','',''),(2696,'1','275','1',1,'Retail Sale Id 2661',9500.00,0.00,0.00,12.50,1187.50,'2022-08-10 18:32:05','',''),(2697,'1','275','1',1,'Retail Sale Id 2662',9500.00,0.00,0.00,12.50,1187.50,'2022-08-10 18:41:15','',''),(2698,'1','275','1',1,'Retail Sale Id 2663',1003.20,0.00,0.00,1.32,125.40,'2022-08-10 18:47:47','',''),(2699,'1','275','1',1,'Retail Sale Id 2664',1998.80,0.00,0.00,2.63,249.85,'2022-08-10 18:48:33','',''),(2700,'1','275','1',1,'Retail Sale Id 2665',9120.00,0.00,0.00,12.00,1140.00,'2022-08-10 18:51:37','',''),(2701,'1','275','1',1,'Retail Sale Id 2666',9500.00,0.00,0.00,12.50,1187.50,'2022-08-10 18:52:16','',''),(2702,'1','275','1',1,'Retail Sale Id 2667',4598.00,0.00,0.00,6.05,574.75,'2022-08-10 18:53:37','',''),(2703,'1','275','1',1,'Retail Sale Id 2668',9500.00,0.00,0.00,12.50,1187.50,'2022-08-10 19:04:00','',''),(2704,'1','275','1',1,'Retail Sale Id 2669',24631.60,0.00,0.00,32.41,3078.95,'2022-08-10 19:33:37','',''),(2705,'1','275','1',1,'Retail Sale Id 2670',9500.00,0.00,0.00,12.50,1187.50,'2022-08-11 08:08:23','',''),(2706,'1','275','1',1,'Retail Sale Id 2671',13999.20,0.00,0.00,18.42,1749.90,'2022-08-11 08:11:12','',''),(2707,'1','275','1',1,'Retail Sale Id 2672',9500.00,0.00,0.00,12.50,1187.50,'2022-08-11 08:27:39','',''),(2708,'1','275','1',1,'Retail Sale Id 2673',1497.20,0.00,0.00,1.97,187.15,'2022-08-11 08:32:55','',''),(2709,'1','275','1',1,'Retail Sale Id 2674',9500.00,0.00,0.00,12.50,1187.50,'2022-08-11 08:41:16','',''),(2710,'1','275','1',1,'Retail Sale Id 2675',1003.20,0.00,0.00,1.32,125.40,'2022-08-11 08:42:59','',''),(2711,'1','275','1',1,'Retail Sale Id 2676',9500.00,0.00,0.00,12.50,1187.50,'2022-08-11 08:45:47','',''),(2712,'1','275','1',1,'Retail Sale Id 2677',1497.20,0.00,0.00,1.97,187.15,'2022-08-11 08:46:56','',''),(2713,'1','275','1',1,'Retail Sale Id 2678',760.00,0.00,0.00,1.00,95.00,'2022-08-11 09:04:03','',''),(2714,'1','275','1',1,'Retail Sale Id 2679',9500.00,0.00,0.00,12.50,1187.50,'2022-08-11 09:05:27','',''),(2715,'1','275','1',1,'Retail Sale Id 2680',7600.00,0.00,0.00,10.00,950.00,'2022-08-11 09:06:05','',''),(2716,'1','275','1',1,'Return of Retail Sale Id 2678',0.00,760.00,1.00,0.00,-95.00,'2022-08-11 09:07:32','',''),(2717,'1','275','1',1,'Retail Sale Id 2681',6080.00,0.00,0.00,8.00,760.00,'2022-08-11 09:37:32','',''),(2718,'1','275','1',1,'Retail Sale Id 2683',4499.20,0.00,0.00,5.92,562.40,'2022-08-11 10:12:30','',''),(2719,'1','275','1',1,'Retail Sale Id 2684',4598.00,0.00,0.00,6.05,574.75,'2022-08-11 10:23:56','',''),(2720,'1','275','1',1,'Retail Sale Id 2685',4499.20,0.00,0.00,5.92,562.40,'2022-08-11 10:45:33','',''),(2721,'1','275','1',1,'Retail Sale Id 2686',15200.00,0.00,0.00,20.00,1900.00,'2022-08-11 11:12:17','',''),(2722,'1','275','1',1,'Retail Sale Id 2687',3800.00,0.00,0.00,5.00,475.00,'2022-08-11 11:17:12','',''),(2723,'1','275','1',1,'Retail Sale Id 2688',19000.00,0.00,0.00,25.00,2375.00,'2022-08-11 11:22:18','',''),(2724,'1','275','1',1,'Retail Sale Id 2689',9500.00,0.00,0.00,12.50,1187.50,'2022-08-11 11:25:35','',''),(2725,'1','275','1',1,'Retail Sale Id 2690',1003.20,0.00,0.00,1.32,125.40,'2022-08-11 11:47:55','',''),(2726,'1','275','1',1,'Retail Sale Id 2691',9500.00,0.00,0.00,12.50,1187.50,'2022-08-11 12:19:53','',''),(2727,'1','275','1',1,'Retail Sale Id 2692',3800.00,0.00,0.00,5.00,475.00,'2022-08-11 12:28:43','',''),(2728,'1','275','1',1,'Retail Sale Id 2693',19000.00,0.00,0.00,25.00,2375.00,'2022-08-11 12:31:43','',''),(2729,'1','275','1',1,'Retail Sale Id 2694',9500.00,0.00,0.00,12.50,1187.50,'2022-08-11 12:39:29','',''),(2730,'1','275','1',1,'Retail Sale Id 2695',2302.80,0.00,0.00,3.03,287.85,'2022-08-11 12:54:13','',''),(2731,'1','275','1',1,'Retail Sale Id 2696',9500.00,0.00,0.00,12.50,1187.50,'2022-08-11 13:03:39','',''),(2732,'1','275','1',1,'Retail Sale Id 2697',4598.00,0.00,0.00,6.05,574.75,'2022-08-11 13:09:46','',''),(2733,'1','275','1',1,'Retail Sale Id 2698',4499.20,0.00,0.00,5.92,562.40,'2022-08-11 13:16:05','',''),(2734,'1','275','1',1,'Retail Sale Id 2699',4598.00,0.00,0.00,6.05,574.75,'2022-08-11 13:23:02','',''),(2735,'1','275','1',1,'Retail Sale Id 2700',9500.00,0.00,0.00,12.50,1187.50,'2022-08-11 13:32:44','',''),(2736,'1','275','1',1,'Retail Sale Id 2701',4750.00,0.00,0.00,6.25,593.75,'2022-08-11 13:34:15','',''),(2737,'1','275','1',1,'Retail Sale Id 2702',4598.00,0.00,0.00,6.05,574.75,'2022-08-11 13:36:05','',''),(2738,'1','275','1',1,'Retail Sale Id 2703',9500.00,0.00,0.00,12.50,1187.50,'2022-08-11 13:37:12','',''),(2739,'1','275','1',1,'Retail Sale Id 2704',8998.40,0.00,0.00,11.84,1124.80,'2022-08-11 13:40:27','',''),(2740,'1','275','1',1,'Retail Sale Id 2705',1998.80,0.00,0.00,2.63,249.85,'2022-08-11 13:47:13','',''),(2741,'1','275','1',1,'Retail Sale Id 2706',1900.00,0.00,0.00,2.50,237.50,'2022-08-11 13:48:06','',''),(2742,'1','275','1',1,'Retail Sale Id 2707',9401.20,0.00,0.00,12.37,1175.15,'2022-08-11 14:12:54','',''),(2743,'1','275','1',1,'Retail Sale Id 2708',1998.80,0.00,0.00,2.63,249.85,'2022-08-11 14:18:43','',''),(2744,'1','275','1',1,'Retail Sale Id 2708',19000.00,0.00,0.00,25.00,2375.00,'2022-08-11 14:18:43','',''),(2745,'1','275','1',1,'Retail Sale Id 2708',19000.00,0.00,0.00,25.00,2375.00,'2022-08-11 14:18:43','',''),(2746,'1','275','1',1,'Retail Sale Id 2708',19000.00,0.00,0.00,25.00,2375.00,'2022-08-11 14:18:43','',''),(2747,'1','275','1',1,'Retail Sale Id 2709',4560.00,0.00,0.00,6.00,570.00,'2022-08-11 14:28:28','',''),(2748,'1','275','1',1,'Retail Sale Id 2710',3800.00,0.00,0.00,5.00,475.00,'2022-08-11 14:34:12','',''),(2749,'1','275','1',1,'Retail Sale Id 2711',9500.00,0.00,0.00,12.50,1187.50,'2022-08-11 14:39:08','',''),(2750,'1','275','1',1,'Return of Retail Sale Id 2711',0.00,9500.00,12.50,0.00,-1187.50,'2022-08-11 14:40:33','',''),(2751,'1','275','1',1,'Retail Sale Id 2712',8998.40,0.00,0.00,11.84,1124.80,'2022-08-11 14:41:07','',''),(2752,'1','275','1',1,'Retail Sale Id 2713',767.60,0.00,0.00,1.01,95.95,'2022-08-11 14:43:16','',''),(2753,'1','275','1',1,'Retail Sale Id 2714',5000.80,0.00,0.00,6.58,625.10,'2022-08-11 15:26:15','',''),(2754,'1','275','1',1,'Retail Sale Id 2715',8998.40,0.00,0.00,11.84,1124.80,'2022-08-11 15:36:04','',''),(2755,'1','275','1',1,'Retail Sale Id 2716',9500.00,0.00,0.00,12.50,1187.50,'2022-08-11 15:40:45','',''),(2756,'1','275','1',1,'Retail Sale Id 2717',76395.20,0.00,0.00,100.52,9549.40,'2022-08-11 18:11:55','',''),(2757,'1','275','1',1,'Distributed to OPPRETIONAL LOST  for sales id:11',18659.90,0.00,0.00,28.06,0.00,'2022-08-11 18:26:22','',''),(2758,'1','275',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3424750.00,5150.00,0.00,0.00,'2022-08-12 11:12:41','',''),(2759,'1','275',NULL,1,'Reception corrector for bridging 13',0.00,0.00,0.00,5150.00,0.00,'2022-08-12 11:14:01','',''),(2760,'1','275','1',1,'Received from bridging 13',0.00,0.00,5150.00,0.00,0.00,'2022-08-12 11:14:01','',''),(2761,'1','275','1',1,'Retail Sale Id 2718',1003.20,0.00,0.00,1.32,125.40,'2022-08-12 11:16:54','',''),(2762,'1','275','1',1,'Retail Sale Id 2719',2302.80,0.00,0.00,3.03,287.85,'2022-08-12 11:19:38','',''),(2763,'1','275','1',1,'Retail Sale Id 2720',9500.00,0.00,0.00,12.50,1187.50,'2022-08-12 11:21:09','',''),(2764,'1','275','1',1,'Retail Sale Id 2721',4598.00,0.00,0.00,6.05,574.75,'2022-08-12 11:21:42','',''),(2765,'1','275','1',1,'Retail Sale Id 2722',9500.00,0.00,0.00,12.50,1187.50,'2022-08-12 11:22:14','',''),(2766,'1','275','1',1,'Retail Sale Id 2723',4598.00,0.00,0.00,6.05,574.75,'2022-08-12 11:25:28','',''),(2767,'1','275','1',1,'Retail Sale Id 2724',9500.00,0.00,0.00,12.50,1187.50,'2022-08-12 11:27:37','',''),(2768,'1','275','1',1,'Retail Sale Id 2725',11400.00,0.00,0.00,15.00,1425.00,'2022-08-12 11:43:39','',''),(2769,'1','275','1',1,'Retail Sale Id 2726',4598.00,0.00,0.00,6.05,574.75,'2022-08-12 11:57:06','',''),(2770,'1','275','1',1,'Retail Sale Id 2727',3800.00,0.00,0.00,5.00,475.00,'2022-08-12 11:59:55','',''),(2771,'1','275','1',1,'Retail Sale Id 2728',4598.00,0.00,0.00,6.05,574.75,'2022-08-12 12:03:13','',''),(2772,'1','275','1',1,'Retail Sale Id 2729',7600.00,0.00,0.00,10.00,950.00,'2022-08-12 12:06:53','',''),(2773,'1','275','1',1,'Retail Sale Id 2730',9203.60,0.00,0.00,12.11,1150.45,'2022-08-12 12:10:13','',''),(2774,'1','275','1',1,'Retail Sale Id 2732',4598.00,0.00,0.00,6.05,574.75,'2022-08-12 12:34:28','',''),(2775,'1','275','1',1,'Retail Sale Id 2733',9500.00,0.00,0.00,12.50,1187.50,'2022-08-12 12:48:46','',''),(2776,'1','275','1',1,'Retail Sale Id 2734',4598.00,0.00,0.00,6.05,574.75,'2022-08-12 12:52:36','',''),(2777,'1','275','1',1,'Retail Sale Id 2735',8496.80,0.00,0.00,11.18,1062.10,'2022-08-12 12:54:46','',''),(2778,'1','275','1',1,'Retail Sale Id 2736',1200.80,0.00,0.00,1.58,150.10,'2022-08-12 12:57:25','',''),(2779,'1','275','1',1,'Retail Sale Id 2737',9500.00,0.00,0.00,12.50,1187.50,'2022-08-12 14:25:49','',''),(2780,'1','275','1',1,'Retail Sale Id 2738',19000.00,0.00,0.00,25.00,2375.00,'2022-08-12 14:29:37','',''),(2781,'1','275','1',1,'Retail Sale Id 2739',9500.00,0.00,0.00,12.50,1187.50,'2022-08-12 14:30:17','',''),(2782,'1','275','1',1,'Retail Sale Id 2740',3002.00,0.00,0.00,3.95,375.25,'2022-08-12 14:30:55','',''),(2783,'1','275','1',1,'Retail Sale Id 2741',1497.20,0.00,0.00,1.97,187.15,'2022-08-12 14:37:58','',''),(2784,'1','275','1',1,'Retail Sale Id 2742',4598.00,0.00,0.00,6.05,574.75,'2022-08-12 14:43:19','',''),(2785,'1','275','1',1,'Retail Sale Id 2743',1497.20,0.00,0.00,1.97,187.15,'2022-08-12 14:44:20','',''),(2786,'1','275','1',1,'Retail Sale Id 2744',9500.00,0.00,0.00,12.50,1187.50,'2022-08-12 15:15:05','',''),(2787,'1','275','1',1,'Retail Sale Id 2745',9500.00,0.00,0.00,12.50,1187.50,'2022-08-12 15:19:09','',''),(2788,'1','275','1',1,'Retail Sale Id 2746',9500.00,0.00,0.00,12.50,1187.50,'2022-08-12 15:54:59','',''),(2789,'1','275','1',1,'Retail Sale Id 2747',9500.00,0.00,0.00,12.50,1187.50,'2022-08-12 16:00:27','',''),(2790,'1','275','1',1,'Retail Sale Id 2748',5000.80,0.00,0.00,6.58,625.10,'2022-08-12 16:08:31','',''),(2791,'1','275','1',1,'Retail Sale Id 2749',3800.00,0.00,0.00,5.00,475.00,'2022-08-12 16:10:10','',''),(2792,'1','275','1',1,'Retail Sale Id 2749',9500.00,0.00,0.00,12.50,1187.50,'2022-08-12 16:10:10','',''),(2793,'1','275','1',1,'Retail Sale Id 2750',1003.20,0.00,0.00,1.32,125.40,'2022-08-12 16:25:52','',''),(2794,'1','275','1',1,'Retail Sale Id 2751',6999.60,0.00,0.00,9.21,874.95,'2022-08-12 16:36:20','',''),(2795,'1','275','1',1,'Retail Sale Id 2752',2302.80,0.00,0.00,3.03,287.85,'2022-08-12 16:42:21','',''),(2796,'1','275','1',1,'Retail Sale Id 2753',5000.80,0.00,0.00,6.58,625.10,'2022-08-12 16:58:27','',''),(2797,'1','275','1',1,'Retail Sale Id 2754',1497.20,0.00,0.00,1.97,187.15,'2022-08-12 16:59:16','',''),(2798,'1','275','1',1,'Retail Sale Id 2755',4598.00,0.00,0.00,6.05,574.75,'2022-08-12 17:00:11','',''),(2799,'1','275','1',1,'Retail Sale Id 2756',9500.00,0.00,0.00,12.50,1187.50,'2022-08-12 17:10:08','',''),(2800,'1','275','1',1,'Retail Sale Id 2757',2302.80,0.00,0.00,3.03,287.85,'2022-08-12 17:11:27','',''),(2801,'1','275','1',1,'Retail Sale Id 2758',9500.00,0.00,0.00,12.50,1187.50,'2022-08-12 17:22:31','',''),(2802,'1','275','1',1,'Retail Sale Id 2759',8002.80,0.00,0.00,10.53,1000.35,'2022-08-12 17:24:45','',''),(2803,'1','275','1',1,'Retail Sale Id 2760',38000.00,0.00,0.00,50.00,4750.00,'2022-08-12 17:29:05','',''),(2804,'1','275','1',1,'Retail Sale Id 2761',5996.40,0.00,0.00,7.89,749.55,'2022-08-12 17:30:14','',''),(2805,'1','275','1',1,'Retail Sale Id 2762',3002.00,0.00,0.00,3.95,375.25,'2022-08-12 17:31:03','',''),(2806,'1','275','1',1,'Retail Sale Id 2763',3800.00,0.00,0.00,5.00,475.00,'2022-08-12 17:35:29','',''),(2807,'1','275','1',1,'Retail Sale Id 2764',9500.00,0.00,0.00,12.50,1187.50,'2022-08-12 17:36:25','',''),(2808,'1','275','1',1,'Retail Sale Id 2765',9500.00,0.00,0.00,12.50,1187.50,'2022-08-12 17:38:49','',''),(2809,'1','275','1',1,'Retail Sale Id 2766',760.00,0.00,0.00,1.00,95.00,'2022-08-12 17:45:53','',''),(2810,'1','275','1',1,'Retail Sale Id 2767',1998.80,0.00,0.00,2.63,249.85,'2022-08-12 18:01:42','',''),(2811,'1','275','1',1,'Retail Sale Id 2768',9500.00,0.00,0.00,12.50,1187.50,'2022-08-12 18:04:35','',''),(2812,'1','275','1',1,'Retail Sale Id 2769',2302.80,0.00,0.00,3.03,287.85,'2022-08-12 18:08:28','',''),(2813,'1','275','1',1,'Retail Sale Id 2770',9500.00,0.00,0.00,12.50,1187.50,'2022-08-12 18:13:16','',''),(2814,'1','275','1',1,'Retail Sale Id 2771',9500.00,0.00,0.00,12.50,1187.50,'2022-08-12 18:32:03','',''),(2815,'1','275','1',1,'Retail Sale Id 2772',9500.00,0.00,0.00,12.50,1187.50,'2022-08-12 18:33:28','',''),(2816,'1','275','1',1,'Retail Sale Id 2773',2302.80,0.00,0.00,3.03,287.85,'2022-08-12 18:41:47','',''),(2817,'1','275','1',1,'Retail Sale Id 2774',9500.00,0.00,0.00,12.50,1187.50,'2022-08-12 18:42:48','',''),(2818,'1','275','1',1,'Retail Sale Id 2775',3002.00,0.00,0.00,3.95,375.25,'2022-08-12 18:48:02','',''),(2819,'1','275','1',1,'Retail Sale Id 2776',4499.20,0.00,0.00,5.92,562.40,'2022-08-12 18:52:06','',''),(2820,'1','275','1',1,'Retail Sale Id 2777',62137.60,0.00,0.00,81.76,7767.20,'2022-08-12 19:21:27','',''),(2821,'1','275','1',1,'Retail Sale Id 2778',4598.00,0.00,0.00,6.05,574.75,'2022-08-13 07:44:10','',''),(2822,'1','275','1',1,'Retail Sale Id 2779',2302.80,0.00,0.00,3.03,287.85,'2022-08-13 08:00:41','',''),(2823,'1','275','1',1,'Retail Sale Id 2780',2302.80,0.00,0.00,3.03,287.85,'2022-08-13 08:08:09','',''),(2824,'1','275','1',1,'Retail Sale Id 2781',4598.00,0.00,0.00,6.05,574.75,'2022-08-13 08:14:40','',''),(2825,'1','275','1',1,'Retail Sale Id 2782',38000.00,0.00,0.00,50.00,4750.00,'2022-08-13 08:21:49','',''),(2826,'1','275','1',1,'Retail Sale Id 2783',9500.00,0.00,0.00,12.50,1187.50,'2022-08-13 08:33:18','',''),(2827,'1','275','1',1,'Retail Sale Id 2784',13999.20,0.00,0.00,18.42,1749.90,'2022-08-13 08:42:03','',''),(2828,'1','275','1',1,'Retail Sale Id 2785',4598.00,0.00,0.00,6.05,574.75,'2022-08-13 08:43:30','',''),(2829,'1','275','1',1,'Retail Sale Id 2786',5996.40,0.00,0.00,7.89,749.55,'2022-08-13 08:44:24','',''),(2830,'1','275','1',1,'Retail Sale Id 2787',798.00,0.00,0.00,1.05,99.75,'2022-08-13 08:45:50','',''),(2831,'1','275','1',1,'Retail Sale Id 2788',4750.00,0.00,0.00,6.25,593.75,'2022-08-13 08:51:28','',''),(2832,'1','275','1',1,'Retail Sale Id 2789',4499.20,0.00,0.00,5.92,562.40,'2022-08-13 08:56:09','',''),(2833,'1','275','1',1,'Retail Sale Id 2790',3503.60,0.00,0.00,4.61,437.95,'2022-08-13 08:57:27','',''),(2834,'1','275','1',1,'Retail Sale Id 2791',8002.80,0.00,0.00,10.53,1000.35,'2022-08-13 09:02:24','',''),(2835,'1','275','1',1,'Retail Sale Id 2792',4598.00,0.00,0.00,6.05,574.75,'2022-08-13 09:06:23','',''),(2836,'1','275','1',1,'Retail Sale Id 2793',1003.20,0.00,0.00,1.32,125.40,'2022-08-13 09:10:35','',''),(2837,'1','275','1',1,'Retail Sale Id 2794',2302.80,0.00,0.00,3.03,287.85,'2022-08-13 09:27:35','',''),(2838,'1','275','1',1,'Retail Sale Id 2795',8360.00,0.00,0.00,11.00,1045.00,'2022-08-13 09:33:23','',''),(2839,'1','275','1',1,'Retail Sale Id 2796',3002.00,0.00,0.00,3.95,375.25,'2022-08-13 09:41:34','',''),(2840,'1','275','1',1,'Retail Sale Id 2797',1998.80,0.00,0.00,2.63,249.85,'2022-08-13 09:42:18','',''),(2841,'1','275','1',1,'Retail Sale Id 2798',9500.00,0.00,0.00,12.50,1187.50,'2022-08-13 09:49:18','',''),(2842,'1','275','1',1,'Retail Sale Id 2799',8002.80,0.00,0.00,10.53,1000.35,'2022-08-13 09:55:51','',''),(2843,'1','275','1',1,'Retail Sale Id 2800',3040.00,0.00,0.00,4.00,380.00,'2022-08-13 09:56:38','',''),(2844,'1','275','1',1,'Return of Retail Sale Id 2800',0.00,3040.00,4.00,0.00,-380.00,'2022-08-13 09:57:00','',''),(2845,'1','275','1',1,'Retail Sale Id 2801',3002.00,0.00,0.00,3.95,375.25,'2022-08-13 09:57:33','',''),(2846,'1','275','1',1,'Retail Sale Id 2802',9500.00,0.00,0.00,12.50,1187.50,'2022-08-13 10:04:09','',''),(2847,'1','275','1',1,'Retail Sale Id 2803',4598.00,0.00,0.00,6.05,574.75,'2022-08-13 10:05:24','',''),(2848,'1','275','1',1,'Retail Sale Id 2804',19000.00,0.00,0.00,25.00,2375.00,'2022-08-13 10:09:16','',''),(2849,'1','275','1',1,'Retail Sale Id 2805',4598.00,0.00,0.00,6.05,574.75,'2022-08-13 10:13:17','',''),(2850,'1','275','1',1,'Retail Sale Id 2806',5000.80,0.00,0.00,6.58,625.10,'2022-08-13 10:14:15','',''),(2851,'1','275','1',1,'Retail Sale Id 2807',9500.00,0.00,0.00,12.50,1187.50,'2022-08-13 10:22:12','',''),(2852,'1','275','1',1,'Retail Sale Id 2808',1603.60,0.00,0.00,2.11,200.45,'2022-08-13 10:28:08','',''),(2853,'1','275','1',1,'Retail Sale Id 2809',9500.00,0.00,0.00,12.50,1187.50,'2022-08-13 10:40:18','',''),(2854,'1','275','1',1,'Retail Sale Id 2810',7980.00,0.00,0.00,10.50,997.50,'2022-08-13 10:55:53','',''),(2855,'1','275','1',1,'Retail Sale Id 2811',3800.00,0.00,0.00,5.00,475.00,'2022-08-13 10:56:48','',''),(2856,'1','275','1',1,'Retail Sale Id 2812',9500.00,0.00,0.00,12.50,1187.50,'2022-08-13 11:13:14','',''),(2857,'1','275','1',1,'Retail Sale Id 2813',19000.00,0.00,0.00,25.00,2375.00,'2022-08-13 11:20:03','',''),(2858,'1','275','1',1,'Retail Sale Id 2814',3800.00,0.00,0.00,5.00,475.00,'2022-08-13 11:33:55','',''),(2859,'1','275','1',1,'Retail Sale Id 2815',9500.00,0.00,0.00,12.50,1187.50,'2022-08-13 11:36:58','',''),(2860,'1','275','1',1,'Retail Sale Id 2816',9500.00,0.00,0.00,12.50,1187.50,'2022-08-13 11:51:55','',''),(2861,'1','275','1',1,'Retail Sale Id 2817',9500.00,0.00,0.00,12.50,1187.50,'2022-08-13 11:56:45','',''),(2862,'1','275','1',1,'Retail Sale Id 2818',2302.80,0.00,0.00,3.03,287.85,'2022-08-13 11:57:58','',''),(2863,'1','275','1',1,'Retail Sale Id 2819',4499.20,0.00,0.00,5.92,562.40,'2022-08-13 12:13:49','',''),(2864,'1','275','1',1,'Retail Sale Id 2820',4499.20,0.00,0.00,5.92,562.40,'2022-08-13 12:18:18','',''),(2865,'1','275','1',1,'Retail Sale Id 2821',9500.00,0.00,0.00,12.50,1187.50,'2022-08-13 12:19:42','',''),(2866,'1','275','1',1,'Retail Sale Id 2822',9500.00,0.00,0.00,12.50,1187.50,'2022-08-13 12:21:08','',''),(2867,'1','275','1',1,'Retail Sale Id 2823',1003.20,0.00,0.00,1.32,125.40,'2022-08-13 12:22:36','',''),(2868,'1','275','1',1,'Retail Sale Id 2824',9500.00,0.00,0.00,12.50,1187.50,'2022-08-13 12:28:03','',''),(2869,'1','275','1',1,'Retail Sale Id 2825',9500.00,0.00,0.00,12.50,1187.50,'2022-08-13 12:41:15','',''),(2870,'1','275','1',1,'Retail Sale Id 2826',4560.00,0.00,0.00,6.00,570.00,'2022-08-13 12:54:04','',''),(2871,'1','275','1',1,'Retail Sale Id 2826',9500.00,0.00,0.00,12.50,1187.50,'2022-08-13 12:54:04','',''),(2872,'1','275','1',1,'Retail Sale Id 2827',1998.80,0.00,0.00,2.63,249.85,'2022-08-13 13:01:59','',''),(2873,'1','275','1',1,'Retail Sale Id 2828',4598.00,0.00,0.00,6.05,574.75,'2022-08-13 13:09:37','',''),(2874,'1','275','1',1,'Retail Sale Id 2829',9500.00,0.00,0.00,12.50,1187.50,'2022-08-13 13:15:08','',''),(2875,'1','275','1',1,'Retail Sale Id 2830',9203.60,0.00,0.00,12.11,1150.45,'2022-08-13 13:29:53','',''),(2876,'1','275','1',1,'Retail Sale Id 2831',9500.00,0.00,0.00,12.50,1187.50,'2022-08-13 13:31:06','',''),(2877,'1','275','1',1,'Retail Sale Id 2832',9500.00,0.00,0.00,12.50,1187.50,'2022-08-13 13:39:57','',''),(2878,'1','275','1',1,'Retail Sale Id 2833',4499.20,0.00,0.00,5.92,562.40,'2022-08-13 13:45:04','',''),(2879,'1','275','1',1,'Retail Sale Id 2834',5000.80,0.00,0.00,6.58,625.10,'2022-08-13 13:55:02','',''),(2880,'1','275','1',1,'Retail Sale Id 2835',1998.80,0.00,0.00,2.63,249.85,'2022-08-13 14:02:27','',''),(2881,'1','275','1',1,'Retail Sale Id 2836',4598.00,0.00,0.00,6.05,574.75,'2022-08-13 14:08:03','',''),(2882,'1','275','1',1,'Retail Sale Id 2837',1497.20,0.00,0.00,1.97,187.15,'2022-08-13 14:09:29','',''),(2883,'1','275','1',1,'Retail Sale Id 2838',9500.00,0.00,0.00,12.50,1187.50,'2022-08-13 14:28:43','',''),(2884,'1','275','1',1,'Retail Sale Id 2839',1497.20,0.00,0.00,1.97,187.15,'2022-08-13 14:30:33','',''),(2885,'1','275','1',1,'Retail Sale Id 2840',9500.00,0.00,0.00,12.50,1187.50,'2022-08-13 14:32:36','',''),(2886,'1','275','1',1,'Retail Sale Id 2841',9500.00,0.00,0.00,12.50,1187.50,'2022-08-13 14:35:51','',''),(2887,'1','275','1',1,'Retail Sale Id 2842',2302.80,0.00,0.00,3.03,287.85,'2022-08-13 14:38:20','',''),(2888,'1','275','1',1,'Retail Sale Id 2843',9500.00,0.00,0.00,12.50,1187.50,'2022-08-13 15:04:37','',''),(2889,'1','275','1',1,'Retail Sale Id 2844',2302.80,0.00,0.00,3.03,287.85,'2022-08-13 15:06:14','',''),(2890,'1','275','1',1,'Retail Sale Id 2845',8360.00,0.00,0.00,11.00,1045.00,'2022-08-13 15:17:06','',''),(2891,'1','275','1',1,'Retail Sale Id 2846',4598.00,0.00,0.00,6.05,574.75,'2022-08-13 15:18:04','',''),(2892,'1','275','1',1,'Retail Sale Id 2847',9500.00,0.00,0.00,12.50,1187.50,'2022-08-13 15:30:30','',''),(2893,'1','275','1',1,'Retail Sale Id 2848',9500.00,0.00,0.00,12.50,1187.50,'2022-08-13 15:33:51','',''),(2894,'1','275','1',1,'Retail Sale Id 2849',1497.20,0.00,0.00,1.97,187.15,'2022-08-13 15:54:34','',''),(2895,'1','275','1',1,'Retail Sale Id 2850',798.00,0.00,0.00,1.05,99.75,'2022-08-13 15:56:51','',''),(2896,'1','275','1',1,'Retail Sale Id 2851',9500.00,0.00,0.00,12.50,1187.50,'2022-08-13 16:01:05','',''),(2897,'1','275','1',1,'Retail Sale Id 2852',19000.00,0.00,0.00,25.00,2375.00,'2022-08-13 16:07:55','',''),(2898,'1','275','1',1,'Retail Sale Id 2853',9500.00,0.00,0.00,12.50,1187.50,'2022-08-13 16:16:22','',''),(2899,'1','275','1',1,'Retail Sale Id 2854',3002.00,0.00,0.00,3.95,375.25,'2022-08-13 16:18:33','',''),(2900,'1','275','1',1,'Retail Sale Id 2855',3047.60,0.00,0.00,4.01,380.95,'2022-08-13 16:22:13','',''),(2901,'1','275','1',1,'Retail Sale Id 2856',9500.00,0.00,0.00,12.50,1187.50,'2022-08-13 16:28:38','',''),(2902,'1','275','1',1,'Retail Sale Id 2857',9500.00,0.00,0.00,12.50,1187.50,'2022-08-13 16:30:27','',''),(2903,'1','275','1',1,'Retail Sale Id 2858',9500.00,0.00,0.00,12.50,1187.50,'2022-08-13 16:35:00','',''),(2904,'1','275','1',1,'Retail Sale Id 2859',9500.00,0.00,0.00,12.50,1187.50,'2022-08-13 16:36:16','',''),(2905,'1','275','1',1,'Retail Sale Id 2860',9500.00,0.00,0.00,12.50,1187.50,'2022-08-13 16:38:13','',''),(2906,'1','275','1',1,'Retail Sale Id 2861',2302.80,0.00,0.00,3.03,287.85,'2022-08-13 16:46:03','',''),(2907,'1','275','1',1,'Retail Sale Id 2862',1497.20,0.00,0.00,1.97,187.15,'2022-08-13 16:57:30','',''),(2908,'1','275','1',1,'Retail Sale Id 2863',9500.00,0.00,0.00,12.50,1187.50,'2022-08-13 16:59:26','',''),(2909,'1','275','1',1,'Retail Sale Id 2864',9500.00,0.00,0.00,12.50,1187.50,'2022-08-13 17:05:27','',''),(2910,'1','275','1',1,'Retail Sale Id 2865',9500.00,0.00,0.00,12.50,1187.50,'2022-08-13 17:06:39','',''),(2911,'1','275','1',1,'Retail Sale Id 2866',3800.00,0.00,0.00,5.00,475.00,'2022-08-13 17:14:00','',''),(2912,'1','275','1',1,'Retail Sale Id 2867',5996.40,0.00,0.00,7.89,749.55,'2022-08-13 17:15:33','',''),(2913,'1','275','1',1,'Retail Sale Id 2868',1520.00,0.00,0.00,2.00,190.00,'2022-08-13 17:17:00','',''),(2914,'1','275','1',1,'Retail Sale Id 2869',1998.80,0.00,0.00,2.63,249.85,'2022-08-13 17:19:30','',''),(2915,'1','275','1',1,'Retail Sale Id 2870',9500.00,0.00,0.00,12.50,1187.50,'2022-08-13 17:22:15','',''),(2916,'1','275','1',1,'Retail Sale Id 2871',9500.00,0.00,0.00,12.50,1187.50,'2022-08-13 17:29:03','',''),(2917,'1','275','1',1,'Retail Sale Id 2872',1497.20,0.00,0.00,1.97,187.15,'2022-08-13 17:32:15','',''),(2918,'1','275','1',1,'Retail Sale Id 2873',3047.60,0.00,0.00,4.01,380.95,'2022-08-13 17:42:21','',''),(2919,'1','275','1',1,'Retail Sale Id 2874',4598.00,0.00,0.00,6.05,574.75,'2022-08-13 17:48:12','',''),(2920,'1','275','1',1,'Retail Sale Id 2875',3800.00,0.00,0.00,5.00,475.00,'2022-08-13 17:51:00','',''),(2921,'1','275','1',1,'Retail Sale Id 2876',2302.80,0.00,0.00,3.03,287.85,'2022-08-13 18:34:05','',''),(2922,'1','275','1',1,'Retail Sale Id 2877',6376.40,0.00,0.00,8.39,797.05,'2022-08-13 18:57:36','',''),(2923,'1','275','1',1,'Retail Sale Id 2878',3997.60,0.00,0.00,5.26,499.70,'2022-08-14 07:35:39','',''),(2924,'1','275','1',1,'Retail Sale Id 2879',3800.00,0.00,0.00,5.00,475.00,'2022-08-14 07:43:36','',''),(2925,'1','275','1',1,'Retail Sale Id 2880',1003.20,0.00,0.00,1.32,125.40,'2022-08-14 08:17:16','',''),(2926,'1','275','1',1,'Retail Sale Id 2881',9500.00,0.00,0.00,12.50,1187.50,'2022-08-14 08:22:51','',''),(2927,'1','275','1',1,'Retail Sale Id 2882',9500.00,0.00,0.00,12.50,1187.50,'2022-08-14 08:25:29','',''),(2928,'1','275','1',1,'Retail Sale Id 2883',9500.00,0.00,0.00,12.50,1187.50,'2022-08-14 08:37:35','',''),(2929,'1','275','1',1,'Retail Sale Id 2884',9500.00,0.00,0.00,12.50,1187.50,'2022-08-14 08:39:50','',''),(2930,'1','275','1',1,'Retail Sale Id 2885',9500.00,0.00,0.00,12.50,1187.50,'2022-08-14 08:41:08','',''),(2931,'1','275','1',1,'Retail Sale Id 2886',1003.20,0.00,0.00,1.32,125.40,'2022-08-14 08:43:08','',''),(2932,'1','275','1',1,'Retail Sale Id 2887',2599.20,0.00,0.00,3.42,324.90,'2022-08-14 09:08:55','',''),(2933,'1','275','1',1,'Retail Sale Id 2888',1003.20,0.00,0.00,1.32,125.40,'2022-08-14 09:45:55','',''),(2934,'1','275','1',1,'Retail Sale Id 2889',38000.00,0.00,0.00,50.00,4750.00,'2022-08-14 10:44:29','',''),(2935,'1','275','1',1,'Retail Sale Id 2890',2302.80,0.00,0.00,3.03,287.85,'2022-08-14 10:45:43','',''),(2936,'1','275','1',1,'Retail Sale Id 2891',2302.80,0.00,0.00,3.03,287.85,'2022-08-14 10:57:35','',''),(2937,'1','275','1',1,'Retail Sale Id 2892',5000.80,0.00,0.00,6.58,625.10,'2022-08-14 11:17:54','',''),(2938,'1','275','1',1,'Retail Sale Id 2893',9500.00,0.00,0.00,12.50,1187.50,'2022-08-14 11:19:09','',''),(2939,'1','275','1',1,'Retail Sale Id 2894',3800.00,0.00,0.00,5.00,475.00,'2022-08-14 11:30:01','',''),(2940,'1','275','1',1,'Retail Sale Id 2894',9500.00,0.00,0.00,12.50,1187.50,'2022-08-14 11:30:01','',''),(2941,'1','275','1',1,'Retail Sale Id 2895',3040.00,0.00,0.00,4.00,380.00,'2022-08-14 11:35:16','',''),(2942,'1','275','1',1,'Retail Sale Id 2896',9500.00,0.00,0.00,12.50,1187.50,'2022-08-14 11:39:44','',''),(2943,'1','275','1',1,'Retail Sale Id 2897',1998.80,0.00,0.00,2.63,249.85,'2022-08-14 11:46:48','',''),(2944,'1','275','1',1,'Retail Sale Id 2898',4598.00,0.00,0.00,6.05,574.75,'2022-08-14 12:00:09','',''),(2945,'1','275','1',1,'Retail Sale Id 2899',9500.00,0.00,0.00,12.50,1187.50,'2022-08-14 12:08:09','',''),(2946,'1','275','1',1,'Retail Sale Id 2900',2500.40,0.00,0.00,3.29,312.55,'2022-08-14 12:21:22','',''),(2947,'1','275','1',1,'Retail Sale Id 2901',9500.00,0.00,0.00,12.50,1187.50,'2022-08-14 12:29:49','',''),(2948,'1','275','1',1,'Retail Sale Id 2902',30498.80,0.00,0.00,40.13,3812.35,'2022-08-14 12:48:08','',''),(2949,'1','275','1',1,'Return of Retail Sale Id 2902',0.00,30498.80,40.13,0.00,-3812.35,'2022-08-14 12:48:56','',''),(2950,'1','275','1',1,'Retail Sale Id 2903',1702.40,0.00,0.00,2.24,212.80,'2022-08-14 12:50:02','',''),(2951,'1','275','1',1,'Retail Sale Id 2903',30400.00,0.00,0.00,40.00,3800.00,'2022-08-14 12:50:02','',''),(2952,'1','275','1',1,'Retail Sale Id 2904',1003.20,0.00,0.00,1.32,125.40,'2022-08-14 12:51:55','',''),(2953,'1','275','1',1,'Retail Sale Id 2905',9500.00,0.00,0.00,12.50,1187.50,'2022-08-14 13:02:40','',''),(2954,'1','275','1',1,'Retail Sale Id 2906',4598.00,0.00,0.00,6.05,574.75,'2022-08-14 13:04:35','',''),(2955,'1','275','1',1,'Retail Sale Id 2907',9500.00,0.00,0.00,12.50,1187.50,'2022-08-14 13:08:16','',''),(2956,'1','275','1',1,'Retail Sale Id 2908',19000.00,0.00,0.00,25.00,2375.00,'2022-08-14 13:09:23','',''),(2957,'1','275','1',1,'Retail Sale Id 2909',9500.00,0.00,0.00,12.50,1187.50,'2022-08-14 13:12:33','',''),(2958,'1','275','1',1,'Retail Sale Id 2910',19000.00,0.00,0.00,25.00,2375.00,'2022-08-14 13:15:12','',''),(2959,'1','275','1',1,'Retail Sale Id 2911',1497.20,0.00,0.00,1.97,187.15,'2022-08-14 13:17:12','',''),(2960,'1','275','1',1,'Retail Sale Id 2912',6080.00,0.00,0.00,8.00,760.00,'2022-08-14 13:18:46','',''),(2961,'1','275','1',1,'Retail Sale Id 2913',1998.80,0.00,0.00,2.63,249.85,'2022-08-14 13:28:53','',''),(2962,'1','275','1',1,'Retail Sale Id 2914',3002.00,0.00,0.00,3.95,375.25,'2022-08-14 13:31:28','',''),(2963,'1','275','1',1,'Retail Sale Id 2915',9500.00,0.00,0.00,12.50,1187.50,'2022-08-14 13:55:43','',''),(2964,'1','275','1',1,'Retail Sale Id 2916',4598.00,0.00,0.00,6.05,574.75,'2022-08-14 13:57:20','',''),(2965,'1','275','1',1,'Retail Sale Id 2916',9500.00,0.00,0.00,12.50,1187.50,'2022-08-14 13:57:20','',''),(2966,'1','275','1',1,'Retail Sale Id 2917',3800.00,0.00,0.00,5.00,475.00,'2022-08-14 13:59:45','',''),(2967,'1','275','1',1,'Retail Sale Id 2917',9500.00,0.00,0.00,12.50,1187.50,'2022-08-14 13:59:45','',''),(2968,'1','275','1',1,'Retail Sale Id 2919',19000.00,0.00,0.00,25.00,2375.00,'2022-08-14 14:00:56','',''),(2969,'1','275','1',1,'Retail Sale Id 2920',9500.00,0.00,0.00,12.50,1187.50,'2022-08-14 14:03:16','',''),(2970,'1','275','1',1,'Retail Sale Id 2918',19000.00,0.00,0.00,25.00,2375.00,'2022-08-14 14:05:18','',''),(2971,'1','275','1',1,'Return of Retail Sale Id 2917',0.00,3800.00,5.00,0.00,-475.00,'2022-08-14 14:05:43','',''),(2972,'1','275','1',1,'Return of Retail Sale Id 2917',0.00,9500.00,12.50,0.00,-1187.50,'2022-08-14 14:05:43','',''),(2973,'1','275','1',1,'Retail Sale Id 2921',3800.00,0.00,0.00,5.00,475.00,'2022-08-14 14:06:28','',''),(2974,'1','275','1',1,'Retail Sale Id 2921',6840.00,0.00,0.00,9.00,855.00,'2022-08-14 14:06:28','',''),(2975,'1','275','1',1,'Retail Sale Id 2922',9500.00,0.00,0.00,12.50,1187.50,'2022-08-14 14:43:09','',''),(2976,'1','275','1',1,'Retail Sale Id 2923',4598.00,0.00,0.00,6.05,574.75,'2022-08-14 14:44:42','',''),(2977,'1','275','1',1,'Retail Sale Id 2924',9203.60,0.00,0.00,12.11,1150.45,'2022-08-14 14:46:52','',''),(2978,'1','275','1',1,'Retail Sale Id 2925',19000.00,0.00,0.00,25.00,2375.00,'2022-08-14 14:49:52','',''),(2979,'1','275','1',1,'Retail Sale Id 2926',3800.00,0.00,0.00,5.00,475.00,'2022-08-14 14:56:43','',''),(2980,'1','275','1',1,'Retail Sale Id 2927',47500.00,0.00,0.00,62.50,5937.50,'2022-08-14 14:58:53','',''),(2981,'1','275','1',1,'Retail Sale Id 2928',25080.00,0.00,0.00,33.00,3135.00,'2022-08-14 15:30:39','',''),(2982,'1','275','1',1,'Retail Sale Id 2929',7600.00,0.00,0.00,10.00,950.00,'2022-08-14 15:32:34','',''),(2983,'1','275','1',1,'Retail Sale Id 2930',4598.00,0.00,0.00,6.05,574.75,'2022-08-14 15:35:25','',''),(2984,'1','275','1',1,'Return of Retail Sale Id 2929',0.00,7600.00,10.00,0.00,-950.00,'2022-08-14 15:36:21','',''),(2985,'1','275','1',1,'Retail Sale Id 2931',9120.00,0.00,0.00,12.00,1140.00,'2022-08-14 15:37:19','',''),(2986,'1','275','1',1,'Retail Sale Id 2932',2302.80,0.00,0.00,3.03,287.85,'2022-08-14 15:43:04','',''),(2987,'1','275','1',1,'Retail Sale Id 2933',2302.80,0.00,0.00,3.03,287.85,'2022-08-14 15:48:49','',''),(2988,'1','275','1',1,'Retail Sale Id 2934',1520.00,0.00,0.00,2.00,190.00,'2022-08-14 15:50:48','',''),(2989,'1','275','1',1,'Retail Sale Id 2935',1497.20,0.00,0.00,1.97,187.15,'2022-08-14 15:51:47','',''),(2990,'1','275','1',1,'Retail Sale Id 2936',30400.00,0.00,0.00,40.00,3800.00,'2022-08-14 15:54:03','',''),(2991,'1','275','1',1,'Return of Retail Sale Id 2936',0.00,30400.00,40.00,0.00,-3800.00,'2022-08-14 15:55:55','',''),(2992,'1','275','1',1,'Retail Sale Id 2937',30498.80,0.00,0.00,40.13,3812.35,'2022-08-14 15:57:53','',''),(2993,'1','275','1',1,'Retail Sale Id 2938',8496.80,0.00,0.00,11.18,1062.10,'2022-08-14 15:58:57','',''),(2994,'1','275','1',1,'Retail Sale Id 2939',39900.00,0.00,0.00,52.50,4987.50,'2022-08-14 16:06:51','',''),(2995,'1','275','1',1,'Retail Sale Id 2940',9500.00,0.00,0.00,12.50,1187.50,'2022-08-14 16:09:16','',''),(2996,'1','275','1',1,'Retail Sale Id 2941',3800.00,0.00,0.00,5.00,475.00,'2022-08-14 16:16:50','',''),(2997,'1','275','1',1,'Retail Sale Id 2942',9500.00,0.00,0.00,12.50,1187.50,'2022-08-14 16:19:29','',''),(2998,'1','275','1',1,'Retail Sale Id 2943',767.60,0.00,0.00,1.01,95.95,'2022-08-14 16:22:06','',''),(2999,'1','275','1',1,'Retail Sale Id 2944',2302.80,0.00,0.00,3.03,287.85,'2022-08-14 16:26:31','',''),(3000,'1','275','1',1,'Retail Sale Id 2945',4598.00,0.00,0.00,6.05,574.75,'2022-08-14 16:31:28','',''),(3001,'1','275','1',1,'Retail Sale Id 2946',3800.00,0.00,0.00,5.00,475.00,'2022-08-14 16:45:32','',''),(3002,'1','275','1',1,'Retail Sale Id 2947',9500.00,0.00,0.00,12.50,1187.50,'2022-08-14 16:51:33','',''),(3003,'1','275','1',1,'Retail Sale Id 2948',9500.00,0.00,0.00,12.50,1187.50,'2022-08-14 17:22:02','',''),(3004,'1','275','1',1,'Retail Sale Id 2949',9500.00,0.00,0.00,12.50,1187.50,'2022-08-14 17:27:17','',''),(3005,'1','275','1',1,'Retail Sale Id 2950',1497.20,0.00,0.00,1.97,187.15,'2022-08-14 17:29:13','',''),(3006,'1','275','1',1,'Retail Sale Id 2951',1998.80,0.00,0.00,2.63,249.85,'2022-08-14 17:31:52','',''),(3007,'1','275','1',1,'Retail Sale Id 2952',19000.00,0.00,0.00,25.00,2375.00,'2022-08-14 17:36:22','',''),(3008,'1','275','1',1,'Retail Sale Id 2953',3800.00,0.00,0.00,5.00,475.00,'2022-08-14 17:39:02','',''),(3009,'1','275','1',1,'Retail Sale Id 2954',5000.80,0.00,0.00,6.58,625.10,'2022-08-14 17:45:32','',''),(3010,'1','275','1',1,'Retail Sale Id 2955',7600.00,0.00,0.00,10.00,950.00,'2022-08-14 17:47:04','',''),(3011,'1','275','1',1,'Retail Sale Id 2956',1520.00,0.00,0.00,2.00,190.00,'2022-08-14 18:01:56','',''),(3012,'1','275','1',1,'Retail Sale Id 2957',2302.80,0.00,0.00,3.03,287.85,'2022-08-14 18:06:36','',''),(3013,'1','275','1',1,'Retail Sale Id 2958',4750.00,0.00,0.00,6.25,593.75,'2022-08-14 18:38:05','',''),(3014,'1','275','1',1,'Retail Sale Id 2959',9500.00,0.00,0.00,12.50,1187.50,'2022-08-14 18:42:03','',''),(3015,'1','275','1',1,'Retail Sale Id 2960',24700.00,0.00,0.00,32.50,3087.50,'2022-08-14 18:44:12','',''),(3016,'1','275','1',1,'Retail Sale Id 2961',19000.00,0.00,0.00,25.00,2375.00,'2022-08-14 18:45:38','',''),(3017,'1','275','1',1,'Retail Sale Id 2962',9500.00,0.00,0.00,12.50,1187.50,'2022-08-14 18:57:19','',''),(3018,'1','275','1',1,'Retail Sale Id 2963',3800.00,0.00,0.00,5.00,475.00,'2022-08-14 18:59:01','',''),(3019,'1','275','1',1,'Retail Sale Id 2963',4598.00,0.00,0.00,6.05,574.75,'2022-08-14 18:59:01','',''),(3020,'1','275','1',1,'Return of Retail Sale Id 2959',0.00,9500.00,12.50,0.00,-1187.50,'2022-08-14 19:16:53','',''),(3021,'1','275','1',1,'Retail Sale Id 2964',1352.80,0.00,0.00,1.78,169.10,'2022-08-14 19:18:14','',''),(3022,'1','275','1',1,'Retail Sale Id 2965',5996.40,0.00,0.00,7.89,749.55,'2022-08-15 07:43:13','',''),(3023,'1','275','1',1,'Retail Sale Id 2966',7600.00,0.00,0.00,10.00,950.00,'2022-08-15 08:21:25','',''),(3024,'1','275','1',1,'Retail Sale Id 2967',3503.60,0.00,0.00,4.61,437.95,'2022-08-15 08:25:37','',''),(3025,'1','275','1',1,'Retail Sale Id 2968',3002.00,0.00,0.00,3.95,375.25,'2022-08-15 08:26:59','',''),(3026,'1','275','1',1,'Retail Sale Id 2969',9500.00,0.00,0.00,12.50,1187.50,'2022-08-15 08:30:24','',''),(3027,'1','275','1',1,'Retail Sale Id 2970',1497.20,0.00,0.00,1.97,187.15,'2022-08-15 08:33:33','',''),(3028,'1','275','1',1,'Retail Sale Id 2971',1998.80,0.00,0.00,2.63,249.85,'2022-08-15 08:44:54','',''),(3029,'1','275','1',1,'Retail Sale Id 2972',2500.40,0.00,0.00,3.29,312.55,'2022-08-15 08:54:41','',''),(3030,'1','275','1',1,'Return of Retail Sale Id 2972',0.00,2500.40,3.29,0.00,-312.55,'2022-08-15 08:54:56','',''),(3031,'1','275','1',1,'Retail Sale Id 2973',3002.00,0.00,0.00,3.95,375.25,'2022-08-15 08:55:26','',''),(3032,'1','275','1',1,'Retail Sale Id 2974',1998.80,0.00,0.00,2.63,249.85,'2022-08-15 08:56:44','',''),(3033,'1','275','1',1,'Retail Sale Id 2975',1520.00,0.00,0.00,2.00,190.00,'2022-08-15 09:05:44','',''),(3034,'1','275','1',1,'Retail Sale Id 2976',1998.80,0.00,0.00,2.63,249.85,'2022-08-15 09:06:39','',''),(3035,'1','275','1',1,'Retail Sale Id 2977',9500.00,0.00,0.00,12.50,1187.50,'2022-08-15 09:09:32','',''),(3036,'1','275','1',1,'Retail Sale Id 2978',8740.00,0.00,0.00,11.50,1092.50,'2022-08-15 09:22:59','',''),(3037,'1','275','1',1,'Retail Sale Id 2978',8740.00,0.00,0.00,11.50,1092.50,'2022-08-15 09:22:59','',''),(3038,'1','275','1',1,'Retail Sale Id 2979',9500.00,0.00,0.00,12.50,1187.50,'2022-08-15 09:33:00','',''),(3039,'1','275','1',1,'Retail Sale Id 2980',1520.00,0.00,0.00,2.00,190.00,'2022-08-15 09:51:22','',''),(3040,'1','275','1',1,'Retail Sale Id 2980',3800.00,0.00,0.00,5.00,475.00,'2022-08-15 09:51:22','',''),(3041,'1','275','1',1,'Return of Retail Sale Id 2980',0.00,1520.00,2.00,0.00,-190.00,'2022-08-15 09:52:45','',''),(3042,'1','275','1',1,'Return of Retail Sale Id 2980',0.00,3800.00,5.00,0.00,-475.00,'2022-08-15 09:52:45','',''),(3043,'1','275','1',1,'Retail Sale Id 2981',1998.80,0.00,0.00,2.63,249.85,'2022-08-15 09:54:22','',''),(3044,'1','275','1',1,'Retail Sale Id 2981',5000.80,0.00,0.00,6.58,625.10,'2022-08-15 09:54:22','',''),(3045,'1','275','1',1,'Retail Sale Id 2982',1998.80,0.00,0.00,2.63,249.85,'2022-08-15 10:03:19','',''),(3046,'1','275','1',1,'Retail Sale Id 2983',5000.80,0.00,0.00,6.58,625.10,'2022-08-15 10:10:43','',''),(3047,'1','275','1',1,'Retail Sale Id 2984',4598.00,0.00,0.00,6.05,574.75,'2022-08-15 10:19:58','',''),(3048,'1','275','1',1,'Retail Sale Id 2985',9120.00,0.00,0.00,12.00,1140.00,'2022-08-15 10:25:47','',''),(3049,'1','275','1',1,'Retail Sale Id 2986',15200.00,0.00,0.00,20.00,1900.00,'2022-08-15 10:37:38','',''),(3050,'1','275','1',1,'Retail Sale Id 2987',9500.00,0.00,0.00,12.50,1187.50,'2022-08-15 10:48:08','',''),(3051,'1','275','1',1,'Retail Sale Id 2988',2302.80,0.00,0.00,3.03,287.85,'2022-08-15 10:49:06','',''),(3052,'1','275','1',1,'Retail Sale Id 2989',3701.20,0.00,0.00,4.87,462.65,'2022-08-15 10:51:22','',''),(3053,'1','275','1',1,'Retail Sale Id 2990',3002.00,0.00,0.00,3.95,375.25,'2022-08-15 10:54:22','',''),(3054,'1','275','1',1,'Retail Sale Id 2991',9500.00,0.00,0.00,12.50,1187.50,'2022-08-15 11:12:09','',''),(3055,'1','275','1',1,'Retail Sale Id 2992',7501.20,0.00,0.00,9.87,937.65,'2022-08-15 11:31:26','',''),(3056,'1','275','1',1,'Retail Sale Id 2993',1497.20,0.00,0.00,1.97,187.15,'2022-08-15 11:32:58','',''),(3057,'1','275','1',1,'Retail Sale Id 2994',3800.00,0.00,0.00,5.00,475.00,'2022-08-15 11:34:52','',''),(3058,'1','275','1',1,'Retail Sale Id 2995',3800.00,0.00,0.00,5.00,475.00,'2022-08-15 11:43:02','',''),(3059,'1','275','1',1,'Retail Sale Id 2996',4598.00,0.00,0.00,6.05,574.75,'2022-08-15 11:49:11','',''),(3060,'1','275','1',1,'Retail Sale Id 2997',9500.00,0.00,0.00,12.50,1187.50,'2022-08-15 12:04:12','',''),(3061,'1','275','1',1,'Retail Sale Id 2998',2302.80,0.00,0.00,3.03,287.85,'2022-08-15 12:11:48','',''),(3062,'1','275','1',1,'Retail Sale Id 2999',7600.00,0.00,0.00,10.00,950.00,'2022-08-15 12:13:23','',''),(3063,'1','275','1',1,'Retail Sale Id 3000',7600.00,0.00,0.00,10.00,950.00,'2022-08-15 12:34:05','',''),(3064,'1','275','1',1,'Retail Sale Id 3001',9500.00,0.00,0.00,12.50,1187.50,'2022-08-15 12:42:53','',''),(3065,'1','275','1',1,'Retail Sale Id 3002',6102.80,0.00,0.00,8.03,762.85,'2022-08-15 12:57:18','',''),(3066,'1','275','1',1,'Retail Sale Id 3003',2302.80,0.00,0.00,3.03,287.85,'2022-08-15 12:58:38','',''),(3067,'1','275','1',1,'Retail Sale Id 3004',699.20,0.00,0.00,0.92,87.40,'2022-08-15 13:15:21','',''),(3068,'1','275','1',1,'Retail Sale Id 3005',5000.80,0.00,0.00,6.58,625.10,'2022-08-15 13:47:36','',''),(3069,'1','275','1',1,'Retail Sale Id 3006',1801.20,0.00,0.00,2.37,225.15,'2022-08-15 14:04:20','',''),(3070,'1','275','1',1,'Retail Sale Id 3007',9500.00,0.00,0.00,12.50,1187.50,'2022-08-15 14:07:34','',''),(3071,'1','275','1',1,'Retail Sale Id 3008',9500.00,0.00,0.00,12.50,1187.50,'2022-08-15 14:29:53','',''),(3072,'1','275','1',1,'Retail Sale Id 3009',1497.20,0.00,0.00,1.97,187.15,'2022-08-15 14:30:55','',''),(3073,'1','275','1',1,'Retail Sale Id 3010',15200.00,0.00,0.00,20.00,1900.00,'2022-08-15 14:42:08','',''),(3074,'1','275','1',1,'Retail Sale Id 3011',9500.00,0.00,0.00,12.50,1187.50,'2022-08-15 15:25:10','',''),(3075,'1','275','1',1,'Retail Sale Id 3012',1003.20,0.00,0.00,1.32,125.40,'2022-08-15 15:27:12','',''),(3076,'1','275','1',1,'Retail Sale Id 3013',38000.00,0.00,0.00,50.00,4750.00,'2022-08-15 15:29:00','',''),(3077,'1','275','1',1,'Retail Sale Id 3014',2302.80,0.00,0.00,3.03,287.85,'2022-08-15 15:30:21','',''),(3078,'1','275','1',1,'Retail Sale Id 3015',9500.00,0.00,0.00,12.50,1187.50,'2022-08-15 15:31:37','',''),(3079,'1','275','1',1,'Retail Sale Id 3016',3040.00,0.00,0.00,4.00,380.00,'2022-08-15 15:32:54','',''),(3080,'1','275','1',1,'Retail Sale Id 3017',4598.00,0.00,0.00,6.05,574.75,'2022-08-15 15:44:22','',''),(3081,'1','275','1',1,'Retail Sale Id 3018',2302.80,0.00,0.00,3.03,287.85,'2022-08-15 15:47:41','',''),(3082,'1','275','1',1,'Retail Sale Id 3019',9500.00,0.00,0.00,12.50,1187.50,'2022-08-15 15:52:23','',''),(3083,'1','275','1',1,'Retail Sale Id 3020',4598.00,0.00,0.00,6.05,574.75,'2022-08-15 16:01:22','',''),(3084,'1','275','1',1,'Retail Sale Id 3021',4598.00,0.00,0.00,6.05,574.75,'2022-08-15 16:31:40','',''),(3085,'1','275','1',1,'Retail Sale Id 3022',5996.40,0.00,0.00,7.89,749.55,'2022-08-15 16:40:26','',''),(3086,'1','275','1',1,'Retail Sale Id 3023',4560.00,0.00,0.00,6.00,570.00,'2022-08-15 16:48:17','',''),(3087,'1','275','1',1,'Retail Sale Id 3024',9500.00,0.00,0.00,12.50,1187.50,'2022-08-15 16:51:54','',''),(3088,'1','275','1',1,'Retail Sale Id 3025',9500.00,0.00,0.00,12.50,1187.50,'2022-08-15 17:00:38','',''),(3089,'1','275','1',1,'Retail Sale Id 3026',4560.00,0.00,0.00,6.00,570.00,'2022-08-15 17:01:59','',''),(3090,'1','275','1',1,'Retail Sale Id 3027',3503.60,0.00,0.00,4.61,437.95,'2022-08-15 17:08:59','',''),(3091,'1','275','1',1,'Retail Sale Id 3028',4499.20,0.00,0.00,5.92,562.40,'2022-08-15 17:10:03','',''),(3092,'1','275','1',1,'Retail Sale Id 3029',6840.00,0.00,0.00,9.00,855.00,'2022-08-15 17:17:49','',''),(3093,'1','275','1',1,'Retail Sale Id 3030',1497.20,0.00,0.00,1.97,187.15,'2022-08-15 17:20:47','',''),(3094,'1','275','1',1,'Retail Sale Id 3031',4598.00,0.00,0.00,6.05,574.75,'2022-08-15 17:21:37','',''),(3095,'1','275','1',1,'Retail Sale Id 3032',14060.00,0.00,0.00,18.50,1757.50,'2022-08-15 17:27:01','',''),(3096,'1','275','1',1,'Retail Sale Id 3033',28500.00,0.00,0.00,37.50,3562.50,'2022-08-15 17:30:34','',''),(3097,'1','275','1',1,'Retail Sale Id 3034',3002.00,0.00,0.00,3.95,375.25,'2022-08-15 17:33:08','',''),(3098,'1','275','1',1,'Retail Sale Id 3035',1497.20,0.00,0.00,1.97,187.15,'2022-08-15 17:33:56','',''),(3099,'1','275','1',1,'Retail Sale Id 3036',2302.80,0.00,0.00,3.03,287.85,'2022-08-15 17:34:47','',''),(3100,'1','275','1',1,'Retail Sale Id 3037',4499.20,0.00,0.00,5.92,562.40,'2022-08-15 17:41:07','',''),(3101,'1','275','1',1,'Retail Sale Id 3038',13300.00,0.00,0.00,17.50,1662.50,'2022-08-15 17:45:45','',''),(3102,'1','275','1',1,'Retail Sale Id 3039',1398.40,0.00,0.00,1.84,174.80,'2022-08-15 18:09:50','',''),(3103,'1','275','1',1,'Retail Sale Id 3040',1003.20,0.00,0.00,1.32,125.40,'2022-08-15 18:15:53','',''),(3104,'1','275','1',1,'Retail Sale Id 3041',9500.00,0.00,0.00,12.50,1187.50,'2022-08-15 18:23:48','',''),(3105,'1','275','1',1,'Retail Sale Id 3042',2302.80,0.00,0.00,3.03,287.85,'2022-08-15 18:26:22','',''),(3106,'1','275','1',1,'Retail Sale Id 3043',9500.00,0.00,0.00,12.50,1187.50,'2022-08-15 18:41:06','',''),(3107,'1','275','1',1,'Retail Sale Id 3044',2302.80,0.00,0.00,3.03,287.85,'2022-08-15 18:42:19','',''),(3108,'1','275','1',1,'Retail Sale Id 3045',9500.00,0.00,0.00,12.50,1187.50,'2022-08-15 18:50:13','',''),(3109,'1','275','1',1,'Retail Sale Id 3046',1702.40,0.00,0.00,2.24,212.80,'2022-08-15 18:57:26','',''),(3110,'1','275','1',1,'Retail Sale Id 3047',4560.00,0.00,0.00,6.00,570.00,'2022-08-15 18:58:57','',''),(3111,'1','275','1',1,'Retail Sale Id 3048',24669.60,0.00,0.00,32.46,3083.70,'2022-08-15 19:43:04','',''),(3112,'1','275','1',1,'Retail Sale Id 3049',9300.00,0.00,0.00,12.50,987.50,'2022-08-16 07:32:29','',''),(3113,'1','275','1',1,'Retail Sale Id 3050',2001.36,0.00,0.00,2.69,212.51,'2022-08-16 07:36:31','',''),(3114,'1','275','1',1,'Retail Sale Id 3051',2298.96,0.00,0.00,3.09,244.11,'2022-08-16 07:42:52','',''),(3115,'1','275','1',1,'Retail Sale Id 3052',3801.84,0.00,0.00,5.11,403.69,'2022-08-16 07:51:06','',''),(3116,'1','275','1',1,'Retail Sale Id 3053',3496.80,0.00,0.00,4.70,371.30,'2022-08-16 08:27:14','',''),(3117,'1','275','1',1,'Retail Sale Id 3054',9300.00,0.00,0.00,12.50,987.50,'2022-08-16 08:39:03','',''),(3118,'1','275','1',1,'Retail Sale Id 3055',4501.20,0.00,0.00,6.05,477.95,'2022-08-16 08:40:34','',''),(3119,'1','275','1',1,'Retail Sale Id 3056',9300.00,0.00,0.00,12.50,987.50,'2022-08-16 08:42:40','',''),(3120,'1','275','1',1,'Retail Sale Id 3057',2298.96,0.00,0.00,3.09,244.11,'2022-08-16 08:45:16','',''),(3121,'1','275','1',1,'Retail Sale Id 3058',699.36,0.00,0.00,0.94,74.26,'2022-08-16 09:27:30','',''),(3122,'1','275','1',1,'Retail Sale Id 3059',22320.00,0.00,0.00,30.00,2370.00,'2022-08-16 09:29:20','',''),(3123,'1','275','1',1,'Retail Sale Id 3060',2298.96,0.00,0.00,3.09,244.11,'2022-08-16 09:35:02','',''),(3124,'1','275','1',1,'Retail Sale Id 3061',9300.00,0.00,0.00,12.50,987.50,'2022-08-16 09:39:42','',''),(3125,'1','275','1',1,'Retail Sale Id 3062',63190.00,0.00,0.00,89.00,4005.00,'2022-08-16 09:42:06','',''),(3126,'1','275','1',1,'Retail Sale Id 3063',71000.00,0.00,0.00,100.00,4500.00,'2022-08-16 09:56:14','',''),(3127,'1','275','1',1,'Retail Sale Id 3064',2998.32,0.00,0.00,4.03,318.37,'2022-08-16 09:58:51','',''),(3128,'1','275','1',1,'Retail Sale Id 3065',21300.00,0.00,0.00,30.00,1350.00,'2022-08-16 10:01:13','',''),(3129,'1','275','1',1,'Retail Sale Id 3066',2998.32,0.00,0.00,4.03,318.37,'2022-08-16 10:11:02','',''),(3130,'1','275','1',1,'Retail Sale Id 3067',9300.00,0.00,0.00,12.50,987.50,'2022-08-16 10:19:20','',''),(3131,'1','275','1',1,'Retail Sale Id 3068',2298.96,0.00,0.00,3.09,244.11,'2022-08-16 10:43:28','',''),(3132,'1','275','1',1,'Retail Sale Id 3069',9300.00,0.00,0.00,12.50,987.50,'2022-08-16 10:47:52','',''),(3133,'1','275','1',1,'Retail Sale Id 3070',3720.00,0.00,0.00,5.00,395.00,'2022-08-16 10:51:08','',''),(3134,'1','275','1',1,'Retail Sale Id 3071',35500.00,0.00,0.00,50.00,2250.00,'2022-08-16 11:11:09','',''),(3135,'1','275','1',1,'Retail Sale Id 3073',9300.00,0.00,0.00,12.50,987.50,'2022-08-16 11:40:09','',''),(3136,'1','275','1',1,'Retail Sale Id 3074',142000.00,0.00,0.00,200.00,9000.00,'2022-08-16 11:41:34','',''),(3137,'1','275','1',1,'Retail Sale Id 3075',9300.00,0.00,0.00,12.50,987.50,'2022-08-16 11:47:10','',''),(3138,'1','275','1',1,'Retail Sale Id 3076',71000.00,0.00,0.00,100.00,4500.00,'2022-08-16 11:54:17','',''),(3139,'1','275','1',1,'Retail Sale Id 3077',9300.00,0.00,0.00,12.50,987.50,'2022-08-16 12:12:59','',''),(3140,'1','275','1',1,'Retail Sale Id 3078',7440.00,0.00,0.00,10.00,790.00,'2022-08-16 12:25:54','',''),(3141,'1','275','1',1,'Retail Sale Id 3079',23064.00,0.00,0.00,31.00,2449.00,'2022-08-16 12:33:00','',''),(3142,'1','275','1',1,'Retail Sale Id 3080',9300.00,0.00,0.00,12.50,987.50,'2022-08-16 12:56:20','',''),(3143,'1','275','1',1,'Retail Sale Id 3081',3720.00,0.00,0.00,5.00,395.00,'2022-08-16 13:21:32','',''),(3144,'1','275','1',1,'Retail Sale Id 3082',9300.00,0.00,0.00,12.50,987.50,'2022-08-16 13:43:00','',''),(3145,'1','275','1',1,'Retail Sale Id 3083',4501.20,0.00,0.00,6.05,477.95,'2022-08-16 13:44:01','',''),(3146,'1','275','1',1,'Retail Sale Id 3084',2246.88,0.00,0.00,3.02,238.58,'2022-08-16 13:45:08','',''),(3147,'1','275','1',1,'Retail Sale Id 3085',217970.00,0.00,0.00,307.00,13815.00,'2022-08-16 13:49:19','',''),(3148,'1','275','1',1,'Retail Sale Id 3086',2998.32,0.00,0.00,4.03,318.37,'2022-08-16 14:16:11','',''),(3149,'1','275','1',1,'Retail Sale Id 3087',2998.32,0.00,0.00,4.03,318.37,'2022-08-16 14:16:55','',''),(3150,'1','275','1',1,'Retail Sale Id 3088',3720.00,0.00,0.00,5.00,395.00,'2022-08-16 14:18:02','',''),(3151,'1','275','1',1,'Retail Sale Id 3089',9300.00,0.00,0.00,12.50,987.50,'2022-08-16 14:29:21','',''),(3152,'1','275','1',1,'Retail Sale Id 3090',1502.88,0.00,0.00,2.02,159.58,'2022-08-16 14:33:17','',''),(3153,'1','275','1',1,'Retail Sale Id 3091',1502.88,0.00,0.00,2.02,159.58,'2022-08-16 14:38:30','',''),(3154,'1','275','1',1,'Retail Sale Id 3092',9300.00,0.00,0.00,12.50,987.50,'2022-08-16 14:49:35','',''),(3155,'1','275','1',1,'Retail Sale Id 3093',2298.96,0.00,0.00,3.09,244.11,'2022-08-16 14:57:50','',''),(3156,'1','275','1',1,'Retail Sale Id 3094',996.96,0.00,0.00,1.34,105.86,'2022-08-16 15:05:07','',''),(3157,'1','275','1',1,'Retail Sale Id 3095',9300.00,0.00,0.00,12.50,987.50,'2022-08-16 15:09:21','',''),(3158,'1','275','1',1,'Retail Sale Id 3096',93010.00,0.00,0.00,131.00,5895.00,'2022-08-16 15:15:39','',''),(3159,'1','275','1',1,'Retail Sale Id 3097',2001.36,0.00,0.00,2.69,212.51,'2022-08-16 15:21:11','',''),(3160,'1','275','1',1,'Retail Sale Id 3098',3905.00,0.00,0.00,5.50,247.50,'2022-08-16 15:22:47','',''),(3161,'1','275','1',1,'Retail Sale Id 3099',803.52,0.00,0.00,1.08,85.32,'2022-08-16 15:35:35','',''),(3162,'1','275','1',1,'Retail Sale Id 3100',2499.84,0.00,0.00,3.36,265.44,'2022-08-16 15:55:13','',''),(3163,'1','275','1',1,'Retail Sale Id 3101',27995.30,0.00,0.00,39.43,1774.35,'2022-08-16 16:34:27','',''),(3164,'1','275','1',1,'Retail Sale Id 3102',2001.36,0.00,0.00,2.69,212.51,'2022-08-16 16:39:34','',''),(3165,'1','275','1',1,'Retail Sale Id 3103',1197.84,0.00,0.00,1.61,127.19,'2022-08-16 16:49:09','',''),(3166,'1','275','1',1,'Retail Sale Id 3104',2298.96,0.00,0.00,3.09,244.11,'2022-08-16 16:52:14','',''),(3167,'1','275','1',1,'Retail Sale Id 3105',1197.84,0.00,0.00,1.61,127.19,'2022-08-16 16:56:26','',''),(3168,'1','275','1',1,'Retail Sale Id 3106',3749.76,0.00,0.00,5.04,398.16,'2022-08-16 17:06:34','',''),(3169,'1','275','1',1,'Retail Sale Id 3107',9002.40,0.00,0.00,12.10,955.90,'2022-08-16 17:08:18','',''),(3170,'1','275','1',1,'Retail Sale Id 3108',2298.96,0.00,0.00,3.09,244.11,'2022-08-16 17:09:53','',''),(3171,'1','275','1',1,'Retail Sale Id 3109',4501.20,0.00,0.00,6.05,477.95,'2022-08-16 17:12:41','',''),(3172,'1','275','1',1,'Retail Sale Id 3110',4501.20,0.00,0.00,6.05,477.95,'2022-08-16 17:27:48','',''),(3173,'1','275','1',1,'Retail Sale Id 3111',4002.72,0.00,0.00,5.38,425.02,'2022-08-16 17:29:04','',''),(3174,'1','275','1',1,'Retail Sale Id 3112',4501.20,0.00,0.00,6.05,477.95,'2022-08-16 18:01:37','',''),(3175,'1','275','1',1,'Retail Sale Id 3113',7440.00,0.00,0.00,10.00,790.00,'2022-08-16 18:08:37','',''),(3176,'1','275','1',1,'Retail Sale Id 3114',2298.96,0.00,0.00,3.09,244.11,'2022-08-16 18:13:36','',''),(3177,'1','275','1',1,'Retail Sale Id 3115',2001.36,0.00,0.00,2.69,212.51,'2022-08-16 18:23:22','',''),(3178,'1','275','1',1,'Retail Sale Id 3116',2998.32,0.00,0.00,4.03,318.37,'2022-08-16 18:36:43','',''),(3179,'1','275','1',1,'Retail Sale Id 3117',5996.64,0.00,0.00,8.06,636.74,'2022-08-16 18:45:01','',''),(3180,'1','275','1',1,'Retail Sale Id 3118',1502.88,0.00,0.00,2.02,159.58,'2022-08-16 18:46:01','',''),(3181,'1','275','1',1,'Return of Retail Sale Id 3100',0.00,2499.84,3.36,0.00,-265.44,'2022-08-16 19:15:34','',''),(3182,'1','275','1',1,'Return of Retail Sale Id 3111',0.00,4002.72,5.38,0.00,-425.02,'2022-08-16 19:17:25','',''),(3183,'1','275','1',1,'Return of Retail Sale Id 3098',0.00,3905.00,5.50,0.00,-247.50,'2022-08-16 19:18:33','',''),(3184,'1','275','1',1,'Retail Sale Id 3119',3486.10,0.00,0.00,4.91,220.95,'2022-08-16 19:21:18','',''),(3185,'1','275','1',1,'Retail Sale Id 3120',2596.56,0.00,0.00,3.49,275.71,'2022-08-16 19:22:46','',''),(3186,'1','275','1',1,'Retail Sale Id 3121',2998.32,0.00,0.00,4.03,318.37,'2022-08-17 07:28:39','',''),(3187,'1','275','1',1,'Retail Sale Id 3122',1502.88,0.00,0.00,2.02,159.58,'2022-08-17 07:34:46','',''),(3188,'1','275','1',1,'Retail Sale Id 3123',11197.20,0.00,0.00,15.05,1188.95,'2022-08-17 07:37:43','',''),(3189,'1','275','1',1,'Retail Sale Id 3124',153360.00,0.00,0.00,216.00,9720.00,'2022-08-17 07:55:53','',''),(3190,'1','275','1',1,'Retail Sale Id 3125',2001.36,0.00,0.00,2.69,212.51,'2022-08-17 07:56:42','',''),(3191,'1','275','1',1,'Retail Sale Id 3126',9300.00,0.00,0.00,12.50,987.50,'2022-08-17 07:58:16','',''),(3192,'1','275','1',1,'Retail Sale Id 3127',9300.00,0.00,0.00,12.50,987.50,'2022-08-17 08:11:08','',''),(3193,'1','275','1',1,'Retail Sale Id 3128',2246.88,0.00,0.00,3.02,238.58,'2022-08-17 08:12:33','',''),(3194,'1','275','1',1,'Retail Sale Id 3129',9300.00,0.00,0.00,12.50,987.50,'2022-08-17 08:17:26','',''),(3195,'1','275','1',1,'Retail Sale Id 3130',9300.00,0.00,0.00,12.50,987.50,'2022-08-17 08:21:01','',''),(3196,'1','275','1',1,'Retail Sale Id 3131',9300.00,0.00,0.00,12.50,987.50,'2022-08-17 08:27:30','',''),(3197,'1','275','1',1,'Retail Sale Id 3132',18600.00,0.00,0.00,25.00,1975.00,'2022-08-17 09:08:44','',''),(3198,'1','275','1',1,'Retail Sale Id 3133',18600.00,0.00,0.00,25.00,1975.00,'2022-08-17 09:12:28','',''),(3199,'1','275','1',1,'Return of Retail Sale Id 3133',0.00,18600.00,25.00,0.00,-1975.00,'2022-08-17 09:13:53','',''),(3200,'1','275','1',1,'Retail Sale Id 3134',17997.36,0.00,0.00,24.19,1911.01,'2022-08-17 09:15:29','',''),(3201,'1','275','1',1,'Retail Sale Id 3135',751.44,0.00,0.00,1.01,79.79,'2022-08-17 09:48:45','',''),(3202,'1','275','1',1,'Retail Sale Id 3136',9300.00,0.00,0.00,12.50,987.50,'2022-08-17 09:52:23','',''),(3203,'1','275','1',1,'Return of Retail Sale Id 3128',0.00,2246.88,3.02,0.00,-238.58,'2022-08-17 10:42:31','',''),(3204,'1','275','1',1,'Retail Sale Id 3137',781.20,0.00,0.00,1.05,82.95,'2022-08-17 10:43:08','',''),(3205,'1','275','1',1,'Return of Retail Sale Id 3124',0.00,153360.00,216.00,0.00,-9720.00,'2022-08-17 10:44:41','',''),(3206,'1','275','1',1,'Retail Sale Id 3138',152699.70,0.00,0.00,215.07,9678.15,'2022-08-17 10:45:40','',''),(3207,'1','275','1',1,'Return of Retail Sale Id 3131',0.00,9300.00,12.50,0.00,-987.50,'2022-08-17 10:47:19','',''),(3208,'1','275','1',1,'Retail Sale Id 3139',7737.60,0.00,0.00,10.40,821.60,'2022-08-17 10:47:59','',''),(3209,'1','275','1',1,'Distributed to OPPRETIONAL LOST  for sales id:12',87680.25,0.00,0.00,131.85,0.00,'2022-08-17 10:52:26','',''),(3210,'1','275','1',1,'Return of Retail Sale Id 3138',0.00,152699.70,215.07,0.00,-9678.15,'2022-08-17 11:09:31','',''),(3211,'1','275','1',1,'Return of Retail Sale Id 3139',0.00,7737.60,10.40,0.00,-821.60,'2022-08-17 11:10:53','',''),(3212,'1','275','1',1,'Return of Retail Sale Id 3137',0.00,781.20,1.05,0.00,-82.95,'2022-08-17 11:11:15','',''),(3213,'1','275','1',1,'Return of Retail Sale Id 3136',0.00,9300.00,12.50,0.00,-987.50,'2022-08-17 11:11:38','',''),(3214,'1','275','1',1,'Return of Retail Sale Id 3135',0.00,751.44,1.01,0.00,-79.79,'2022-08-17 11:12:35','',''),(3215,'1','275','1',1,'Return of Retail Sale Id 3134',0.00,17997.36,24.19,0.00,-1911.01,'2022-08-17 11:13:00','',''),(3216,'1','275','1',1,'Return of Retail Sale Id 3132',0.00,18600.00,25.00,0.00,-1975.00,'2022-08-17 11:13:37','',''),(3217,'1','275','1',1,'Return of Retail Sale Id 3130',0.00,9300.00,12.50,0.00,-987.50,'2022-08-17 11:14:06','',''),(3218,'1','275','1',1,'Return of Retail Sale Id 3129',0.00,9300.00,12.50,0.00,-987.50,'2022-08-17 11:14:34','',''),(3219,'1','275','1',1,'Return of Retail Sale Id 3127',0.00,9300.00,12.50,0.00,-987.50,'2022-08-17 11:15:25','',''),(3220,'1','275','1',1,'Return of Retail Sale Id 3121',0.00,2998.32,4.03,0.00,-318.37,'2022-08-17 11:16:00','',''),(3221,'1','275','1',1,'Return of Retail Sale Id 3122',0.00,1502.88,2.02,0.00,-159.58,'2022-08-17 11:16:31','',''),(3222,'1','275','1',1,'Return of Retail Sale Id 3123',0.00,11197.20,15.05,0.00,-1188.95,'2022-08-17 11:17:03','',''),(3223,'1','275','1',1,'Return of Retail Sale Id 3125',0.00,2001.36,2.69,0.00,-212.51,'2022-08-17 11:17:41','',''),(3224,'1','275','1',1,'Return of Retail Sale Id 3126',0.00,9300.00,12.50,0.00,-987.50,'2022-08-17 11:18:12','',''),(3225,'1','275','1',1,'Retail Sale Id 3140',110067.36,0.00,0.00,147.94,11687.26,'2022-08-17 11:21:30','',''),(3226,'1','275','1',1,'Retail Sale Id 3141',152699.70,0.00,0.00,215.07,9678.15,'2022-08-17 11:22:36','',''),(3227,'1','275',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3484600.00,5240.00,0.00,0.00,'2022-08-17 12:27:59','',''),(3228,'1','275',NULL,1,'Reception corrector for bridging 14',0.00,0.00,0.00,5240.00,0.00,'2022-08-17 12:28:59','',''),(3229,'1','275','1',1,'Received from bridging 14',0.00,0.00,5240.00,0.00,0.00,'2022-08-17 12:28:59','',''),(3230,'1','275','1',1,'Retail Sale Id 3142',35500.00,0.00,0.00,50.00,2250.00,'2022-08-17 12:34:25','',''),(3231,'1','275','1',1,'Retail Sale Id 3143',9300.00,0.00,0.00,12.50,987.50,'2022-08-17 12:41:53','',''),(3232,'1','275','1',1,'Retail Sale Id 3144',2298.96,0.00,0.00,3.09,244.11,'2022-08-17 12:47:59','',''),(3233,'1','275','1',1,'Retail Sale Id 3145',2998.32,0.00,0.00,4.03,318.37,'2022-08-17 12:59:33','',''),(3234,'1','275','1',1,'Retail Sale Id 3146',5208.00,0.00,0.00,7.00,553.00,'2022-08-17 13:19:11','',''),(3235,'1','275','1',1,'Retail Sale Id 3147',9300.00,0.00,0.00,12.50,987.50,'2022-08-17 13:34:59','',''),(3236,'1','275','1',1,'Retail Sale Id 3148',2001.36,0.00,0.00,2.69,212.51,'2022-08-17 13:58:12','',''),(3237,'1','275','1',1,'Retail Sale Id 3149',18600.00,0.00,0.00,25.00,1975.00,'2022-08-17 14:05:54','',''),(3238,'1','275','1',1,'Retail Sale Id 3150',44020.00,0.00,0.00,62.00,2790.00,'2022-08-17 14:07:47','',''),(3239,'1','275','1',1,'Retail Sale Id 3151',7298.64,0.00,0.00,9.81,774.99,'2022-08-17 14:13:17','',''),(3240,'1','275','1',1,'Retail Sale Id 3152',7810.00,0.00,0.00,11.00,495.00,'2022-08-17 14:15:39','',''),(3241,'1','275','1',1,'Retail Sale Id 3153',2298.96,0.00,0.00,3.09,244.11,'2022-08-17 14:23:02','',''),(3242,'1','275','1',1,'Retail Sale Id 3154',18600.00,0.00,0.00,25.00,1975.00,'2022-08-17 14:27:28','',''),(3243,'1','275','1',1,'Retail Sale Id 3155',9300.00,0.00,0.00,12.50,987.50,'2022-08-17 14:35:12','',''),(3244,'1','275','1',1,'Retail Sale Id 3157',9300.00,0.00,0.00,12.50,987.50,'2022-08-17 14:42:47','',''),(3245,'1','275','1',1,'Retail Sale Id 3158',9300.00,0.00,0.00,12.50,987.50,'2022-08-17 14:44:00','',''),(3246,'1','275','1',1,'Retail Sale Id 3159',2998.32,0.00,0.00,4.03,318.37,'2022-08-17 14:57:17','',''),(3247,'1','275','1',1,'Retail Sale Id 3160',5996.64,0.00,0.00,8.06,636.74,'2022-08-17 15:23:19','',''),(3248,'1','275','1',1,'Retail Sale Id 3161',35500.00,0.00,0.00,50.00,2250.00,'2022-08-17 15:28:57','',''),(3249,'1','275','1',1,'Retail Sale Id 3162',4501.20,0.00,0.00,6.05,477.95,'2022-08-17 15:31:57','',''),(3250,'1','275','1',1,'Retail Sale Id 3163',8600.64,0.00,0.00,11.56,913.24,'2022-08-17 15:38:59','',''),(3251,'1','275','1',1,'Retail Sale Id 3164',2499.84,0.00,0.00,3.36,265.44,'2022-08-17 15:58:32','',''),(3252,'1','275','1',1,'Retail Sale Id 3165',37200.00,0.00,0.00,50.00,3950.00,'2022-08-17 16:01:03','',''),(3253,'1','275','1',1,'Retail Sale Id 3166',3720.00,0.00,0.00,5.00,395.00,'2022-08-17 16:20:39','',''),(3254,'1','275','1',1,'Retail Sale Id 3167',14880.00,0.00,0.00,20.00,1580.00,'2022-08-17 16:21:49','',''),(3255,'1','275','1',1,'Retail Sale Id 3168',13490.00,0.00,0.00,19.00,855.00,'2022-08-17 16:30:37','',''),(3256,'1','275','1',1,'Retail Sale Id 3169',9300.00,0.00,0.00,12.50,987.50,'2022-08-17 16:32:00','',''),(3257,'1','275','1',1,'Retail Sale Id 3170',9300.00,0.00,0.00,12.50,987.50,'2022-08-17 16:42:01','',''),(3258,'1','275','1',1,'Retail Sale Id 3171',1748.40,0.00,0.00,2.35,185.65,'2022-08-17 16:47:52','',''),(3259,'1','275','1',1,'Retail Sale Id 3172',46500.00,0.00,0.00,62.50,4937.50,'2022-08-17 16:51:54','',''),(3260,'1','275','1',1,'Retail Sale Id 3173',46150.00,0.00,0.00,65.00,2925.00,'2022-08-17 16:53:55','',''),(3261,'1','275','1',1,'Retail Sale Id 3174',2298.96,0.00,0.00,3.09,244.11,'2022-08-17 16:54:54','',''),(3262,'1','275','1',1,'Retail Sale Id 3175',9300.00,0.00,0.00,12.50,987.50,'2022-08-17 16:59:14','',''),(3263,'1','275','1',1,'Retail Sale Id 3176',3720.00,0.00,0.00,5.00,395.00,'2022-08-17 17:02:05','',''),(3264,'1','275','1',1,'Retail Sale Id 3177',7440.00,0.00,0.00,10.00,790.00,'2022-08-17 17:03:19','',''),(3265,'1','275','1',1,'Retail Sale Id 3178',9300.00,0.00,0.00,12.50,987.50,'2022-08-17 17:05:30','',''),(3266,'1','275','1',1,'Retail Sale Id 3179',9300.00,0.00,0.00,12.50,987.50,'2022-08-17 17:19:20','',''),(3267,'1','275','1',1,'Retail Sale Id 3180',9300.00,0.00,0.00,12.50,987.50,'2022-08-17 17:27:22','',''),(3268,'1','275','1',1,'Retail Sale Id 3181',5498.16,0.00,0.00,7.39,583.81,'2022-08-17 17:32:24','',''),(3269,'1','275','1',1,'Retail Sale Id 3182',4501.20,0.00,0.00,6.05,477.95,'2022-08-17 17:35:52','',''),(3270,'1','275','1',1,'Retail Sale Id 3183',61060.00,0.00,0.00,86.00,3870.00,'2022-08-17 17:39:14','',''),(3271,'1','275','1',1,'Retail Sale Id 3184',4501.20,0.00,0.00,6.05,477.95,'2022-08-17 17:39:52','',''),(3272,'1','275','1',1,'Retail Sale Id 3185',4501.20,0.00,0.00,6.05,477.95,'2022-08-17 17:53:43','',''),(3273,'1','275','1',1,'Retail Sale Id 3185',9300.00,0.00,0.00,12.50,987.50,'2022-08-17 17:53:43','',''),(3274,'1','275','1',1,'Retail Sale Id 3186',2298.96,0.00,0.00,3.09,244.11,'2022-08-17 17:55:13','',''),(3275,'1','275','1',1,'Retail Sale Id 3187',2001.36,0.00,0.00,2.69,212.51,'2022-08-17 17:55:58','',''),(3276,'1','275','1',1,'Retail Sale Id 3188',1502.88,0.00,0.00,2.02,159.58,'2022-08-17 18:03:19','',''),(3277,'1','275','1',1,'Retail Sale Id 3189',9300.00,0.00,0.00,12.50,987.50,'2022-08-17 18:06:56','',''),(3278,'1','275','1',1,'Retail Sale Id 3190',2298.96,0.00,0.00,3.09,244.11,'2022-08-17 18:07:43','',''),(3279,'1','275','1',1,'Retail Sale Id 3191',7499.52,0.00,0.00,10.08,796.32,'2022-08-17 18:19:15','',''),(3280,'1','275','1',1,'Retail Sale Id 3192',2998.32,0.00,0.00,4.03,318.37,'2022-08-17 18:29:31','',''),(3281,'1','275','1',1,'Retail Sale Id 3193',3749.76,0.00,0.00,5.04,398.16,'2022-08-17 18:33:33','',''),(3282,'1','275','1',1,'Retail Sale Id 3194',4501.20,0.00,0.00,6.05,477.95,'2022-08-17 18:34:48','',''),(3283,'1','275','1',1,'Retail Sale Id 3195',9300.00,0.00,0.00,12.50,987.50,'2022-08-17 18:36:02','',''),(3284,'1','275','1',1,'Retail Sale Id 3196',15499.30,0.00,0.00,21.83,982.35,'2022-08-17 18:37:26','',''),(3285,'1','275','1',1,'Retail Sale Id 3197',2298.96,0.00,0.00,3.09,244.11,'2022-08-17 18:53:55','',''),(3286,'1','275','1',1,'Retail Sale Id 3198',4002.72,0.00,0.00,5.38,425.02,'2022-08-17 18:59:35','',''),(3287,'1','275','1',1,'Retail Sale Id 3199',51298.80,0.00,0.00,68.95,5447.05,'2022-08-17 19:43:39','',''),(3288,'1','275','1',1,'Retail Sale Id 3200',49004.20,0.00,0.00,69.02,3105.90,'2022-08-17 19:45:38','',''),(3289,'1','275','1',1,'Retail Sale Id 3201',9300.00,0.00,0.00,12.50,987.50,'2022-08-18 07:44:52','',''),(3290,'1','275','1',1,'Retail Sale Id 3202',4002.72,0.00,0.00,5.38,425.02,'2022-08-18 08:04:42','',''),(3291,'1','275','1',1,'Retail Sale Id 3203',142000.00,0.00,0.00,200.00,9000.00,'2022-08-18 08:19:56','',''),(3292,'1','275','1',1,'Retail Sale Id 3204',2001.36,0.00,0.00,2.69,212.51,'2022-08-18 08:51:41','',''),(3293,'1','275','1',1,'Retail Sale Id 3205',996.96,0.00,0.00,1.34,105.86,'2022-08-18 08:52:38','',''),(3294,'1','275','1',1,'Retail Sale Id 3206',2001.36,0.00,0.00,2.69,212.51,'2022-08-18 08:53:32','',''),(3295,'1','275','1',1,'Retail Sale Id 3207',9300.00,0.00,0.00,12.50,987.50,'2022-08-18 08:56:07','',''),(3296,'1','275','1',1,'Retail Sale Id 3208',9300.00,0.00,0.00,12.50,987.50,'2022-08-18 09:07:00','',''),(3297,'1','275','1',1,'Retail Sale Id 3209',9300.00,0.00,0.00,12.50,987.50,'2022-08-18 09:09:37','',''),(3298,'1','275','1',1,'Retail Sale Id 3210',9300.00,0.00,0.00,12.50,987.50,'2022-08-18 09:11:14','',''),(3299,'1','275','1',1,'Retail Sale Id 3211',996.96,0.00,0.00,1.34,105.86,'2022-08-18 09:20:29','',''),(3300,'1','275','1',1,'Retail Sale Id 3212',2976.00,0.00,0.00,4.00,316.00,'2022-08-18 09:27:11','',''),(3301,'1','275','1',1,'Retail Sale Id 3212',4464.00,0.00,0.00,6.00,474.00,'2022-08-18 09:27:11','',''),(3302,'1','275','1',1,'Retail Sale Id 3212',7440.00,0.00,0.00,10.00,790.00,'2022-08-18 09:27:11','',''),(3303,'1','275','1',1,'Retail Sale Id 3213',2001.36,0.00,0.00,2.69,212.51,'2022-08-18 09:28:33','',''),(3304,'1','275','1',1,'Retail Sale Id 3214',2998.32,0.00,0.00,4.03,318.37,'2022-08-18 09:29:38','',''),(3305,'1','275','1',1,'Retail Sale Id 3215',9300.00,0.00,0.00,12.50,987.50,'2022-08-18 09:32:23','',''),(3306,'1','275','1',1,'Retail Sale Id 3216',4501.20,0.00,0.00,6.05,477.95,'2022-08-18 09:36:45','',''),(3307,'1','275','1',1,'Retail Sale Id 3217',4999.68,0.00,0.00,6.72,530.88,'2022-08-18 09:41:54','',''),(3308,'1','275','1',1,'Retail Sale Id 3217',4999.68,0.00,0.00,6.72,530.88,'2022-08-18 09:41:54','',''),(3309,'1','275','1',1,'Retail Sale Id 3218',9300.00,0.00,0.00,12.50,987.50,'2022-08-18 09:43:28','',''),(3310,'1','275','1',1,'Retail Sale Id 3219',9999.36,0.00,0.00,13.44,1061.76,'2022-08-18 09:57:57','',''),(3311,'1','275','1',1,'Retail Sale Id 3220',4501.20,0.00,0.00,6.05,477.95,'2022-08-18 10:07:25','',''),(3312,'1','275','1',1,'Retail Sale Id 3221',2001.36,0.00,0.00,2.69,212.51,'2022-08-18 10:14:19','',''),(3313,'1','275','1',1,'Retail Sale Id 3222',9300.00,0.00,0.00,12.50,987.50,'2022-08-18 10:16:44','',''),(3314,'1','275','1',1,'Retail Sale Id 3223',4501.20,0.00,0.00,6.05,477.95,'2022-08-18 10:19:31','',''),(3315,'1','275','1',1,'Retail Sale Id 3223',9300.00,0.00,0.00,12.50,987.50,'2022-08-18 10:19:31','',''),(3316,'1','275','1',1,'Retail Sale Id 3224',18600.00,0.00,0.00,25.00,1975.00,'2022-08-18 10:21:25','',''),(3317,'1','275','1',1,'Retail Sale Id 3225',9300.00,0.00,0.00,12.50,987.50,'2022-08-18 10:23:09','',''),(3318,'1','275','1',1,'Retail Sale Id 3226',9300.00,0.00,0.00,12.50,987.50,'2022-08-18 10:29:15','',''),(3319,'1','275','1',1,'Retail Sale Id 3227',18600.00,0.00,0.00,25.00,1975.00,'2022-08-18 10:41:36','',''),(3320,'1','275','1',1,'Retail Sale Id 3228',2298.96,0.00,0.00,3.09,244.11,'2022-08-18 10:46:21','',''),(3321,'1','275','1',1,'Retail Sale Id 3229',1197.84,0.00,0.00,1.61,127.19,'2022-08-18 10:48:42','',''),(3322,'1','275','1',1,'Retail Sale Id 3230',2298.96,0.00,0.00,3.09,244.11,'2022-08-18 11:15:47','',''),(3323,'1','275','1',1,'Retail Sale Id 3231',996.96,0.00,0.00,1.34,105.86,'2022-08-18 11:18:54','',''),(3324,'1','275','1',1,'Retail Sale Id 3232',5208.00,0.00,0.00,7.00,553.00,'2022-08-18 11:21:13','',''),(3325,'1','275','1',1,'Retail Sale Id 3233',9300.00,0.00,0.00,12.50,987.50,'2022-08-18 11:47:13','',''),(3326,'1','275','1',1,'Retail Sale Id 3234',4501.20,0.00,0.00,6.05,477.95,'2022-08-18 11:48:57','',''),(3327,'1','275','1',1,'Retail Sale Id 3235',9300.00,0.00,0.00,12.50,987.50,'2022-08-18 11:54:23','',''),(3328,'1','275','1',1,'Retail Sale Id 3236',9300.00,0.00,0.00,12.50,987.50,'2022-08-18 11:58:27','',''),(3329,'1','275','1',1,'Retail Sale Id 3237',71000.00,0.00,0.00,100.00,4500.00,'2022-08-18 12:25:31','',''),(3330,'1','275','1',1,'Retail Sale Id 3238',1502.88,0.00,0.00,2.02,159.58,'2022-08-18 12:51:03','',''),(3331,'1','275','1',1,'Retail Sale Id 3239',996.96,0.00,0.00,1.34,105.86,'2022-08-18 13:38:26','',''),(3332,'1','275','1',1,'Retail Sale Id 3240',32660.00,0.00,0.00,46.00,2070.00,'2022-08-18 13:58:07','',''),(3333,'1','275','1',1,'Retail Sale Id 3241',9300.00,0.00,0.00,12.50,987.50,'2022-08-18 14:00:31','',''),(3334,'1','275','1',1,'Retail Sale Id 3242',35500.00,0.00,0.00,50.00,2250.00,'2022-08-18 14:02:22','',''),(3335,'1','275','1',1,'Retail Sale Id 3243',996.96,0.00,0.00,1.34,105.86,'2022-08-18 14:03:31','',''),(3336,'1','275','1',1,'Retail Sale Id 3244',2998.32,0.00,0.00,4.03,318.37,'2022-08-18 14:29:23','',''),(3337,'1','275','1',1,'Retail Sale Id 3245',2001.36,0.00,0.00,2.69,212.51,'2022-08-18 14:37:26','',''),(3338,'1','275','1',1,'Retail Sale Id 3246',1502.88,0.00,0.00,2.02,159.58,'2022-08-18 14:38:31','',''),(3339,'1','275','1',1,'Retail Sale Id 3247',71000.00,0.00,0.00,100.00,4500.00,'2022-08-18 14:41:20','',''),(3340,'1','275','1',1,'Retail Sale Id 3249',2298.96,0.00,0.00,3.09,244.11,'2022-08-18 14:57:28','',''),(3341,'1','275','1',1,'Retail Sale Id 3250',18600.00,0.00,0.00,25.00,1975.00,'2022-08-18 15:00:37','',''),(3342,'1','275','1',1,'Retail Sale Id 3251',9300.00,0.00,0.00,12.50,987.50,'2022-08-18 15:02:38','',''),(3343,'1','275','1',1,'Retail Sale Id 3252',8520.00,0.00,0.00,12.00,540.00,'2022-08-18 15:04:10','',''),(3344,'1','275','1',1,'Retail Sale Id 3254',18600.00,0.00,0.00,25.00,1975.00,'2022-08-18 15:27:38','',''),(3345,'1','275','1',1,'Retail Sale Id 3255',27690.00,0.00,0.00,39.00,1755.00,'2022-08-18 15:45:03','',''),(3346,'1','275','1',1,'Retail Sale Id 3256',18600.00,0.00,0.00,25.00,1975.00,'2022-08-18 16:24:48','',''),(3347,'1','275','1',1,'Retail Sale Id 3257',1197.84,0.00,0.00,1.61,127.19,'2022-08-18 16:27:42','',''),(3348,'1','275','1',1,'Retail Sale Id 3258',2298.96,0.00,0.00,3.09,244.11,'2022-08-18 16:28:53','',''),(3349,'1','275','1',1,'Retail Sale Id 3259',3720.00,0.00,0.00,5.00,395.00,'2022-08-18 16:31:59','',''),(3350,'1','275','1',1,'Retail Sale Id 3260',2998.32,0.00,0.00,4.03,318.37,'2022-08-18 16:35:40','',''),(3351,'1','275','1',1,'Retail Sale Id 3261',2001.36,0.00,0.00,2.69,212.51,'2022-08-18 16:36:45','',''),(3352,'1','275','1',1,'Retail Sale Id 3262',2298.96,0.00,0.00,3.09,244.11,'2022-08-18 16:43:17','',''),(3353,'1','275','1',1,'Retail Sale Id 3263',1197.84,0.00,0.00,1.61,127.19,'2022-08-18 16:58:00','',''),(3354,'1','275','1',1,'Retail Sale Id 3264',11160.00,0.00,0.00,15.00,1185.00,'2022-08-18 17:09:05','',''),(3355,'1','275','1',1,'Retail Sale Id 3265',2298.96,0.00,0.00,3.09,244.11,'2022-08-18 17:16:48','',''),(3356,'1','275','1',1,'Retail Sale Id 3266',4501.20,0.00,0.00,6.05,477.95,'2022-08-18 17:20:28','',''),(3357,'1','275','1',1,'Retail Sale Id 3267',22002.90,0.00,0.00,30.99,1394.55,'2022-08-18 17:27:22','',''),(3358,'1','275','1',1,'Retail Sale Id 3268',4999.68,0.00,0.00,6.72,530.88,'2022-08-18 17:33:32','',''),(3359,'1','275','1',1,'Retail Sale Id 3269',1502.88,0.00,0.00,2.02,159.58,'2022-08-18 17:35:51','',''),(3360,'1','275','1',1,'Retail Sale Id 3270',2298.96,0.00,0.00,3.09,244.11,'2022-08-18 17:36:50','',''),(3361,'1','275','1',1,'Retail Sale Id 3271',2298.96,0.00,0.00,3.09,244.11,'2022-08-18 17:51:51','',''),(3362,'1','275','1',1,'Retail Sale Id 3271',2298.96,0.00,0.00,3.09,244.11,'2022-08-18 17:51:51','',''),(3363,'1','275','1',1,'Retail Sale Id 3272',1502.88,0.00,0.00,2.02,159.58,'2022-08-18 17:54:11','',''),(3364,'1','275','1',1,'Retail Sale Id 3273',9300.00,0.00,0.00,12.50,987.50,'2022-08-18 17:57:35','',''),(3365,'1','275','1',1,'Retail Sale Id 3274',3720.00,0.00,0.00,5.00,395.00,'2022-08-18 18:13:19','',''),(3366,'1','275','1',1,'Retail Sale Id 3275',9300.00,0.00,0.00,12.50,987.50,'2022-08-18 18:15:38','',''),(3367,'1','275','1',1,'Retail Sale Id 3276',9300.00,0.00,0.00,12.50,987.50,'2022-08-18 18:32:16','',''),(3368,'1','275','1',1,'Retail Sale Id 3277',9300.00,0.00,0.00,12.50,987.50,'2022-08-18 18:34:00','',''),(3369,'1','275','1',1,'Retail Sale Id 3278',1502.88,0.00,0.00,2.02,159.58,'2022-08-18 18:42:52','',''),(3370,'1','275','1',1,'Retail Sale Id 3279',5996.64,0.00,0.00,8.06,636.74,'2022-08-18 18:57:32','',''),(3371,'1','275','1',1,'Retail Sale Id 3280',19880.00,0.00,0.00,28.00,1260.00,'2022-08-18 19:00:38','',''),(3372,'1','275','1',1,'Retail Sale Id 3281',7998.00,0.00,0.00,10.75,849.25,'2022-08-18 19:03:50','',''),(3373,'1','275','1',1,'Retail Sale Id 3282',2075.76,0.00,0.00,2.79,220.41,'2022-08-18 19:32:01','',''),(3374,'1','275','1',1,'Return of Retail Sale Id 3280',0.00,19880.00,28.00,0.00,-1260.00,'2022-08-18 19:32:34','',''),(3375,'1','275','1',1,'Retail Sale Id 3283',18673.00,0.00,0.00,26.30,1183.50,'2022-08-18 19:34:14','',''),(3376,'1','275','1',1,'Retail Sale Id 3284',1502.88,0.00,0.00,2.02,159.58,'2022-08-19 07:31:31','',''),(3377,'1','275','1',1,'Retail Sale Id 3285',2998.32,0.00,0.00,4.03,318.37,'2022-08-19 08:16:01','',''),(3378,'1','275','1',1,'Retail Sale Id 3286',4501.20,0.00,0.00,6.05,477.95,'2022-08-19 08:32:23','',''),(3379,'1','275','1',1,'Retail Sale Id 3289',9300.00,0.00,0.00,12.50,987.50,'2022-08-19 08:57:28','',''),(3380,'1','275','1',1,'Retail Sale Id 3290',18600.00,0.00,0.00,25.00,1975.00,'2022-08-19 09:08:40','',''),(3381,'1','275','1',1,'Retail Sale Id 3291',9300.00,0.00,0.00,12.50,987.50,'2022-08-19 09:15:02','',''),(3382,'1','275','1',1,'Retail Sale Id 3292',9300.00,0.00,0.00,12.50,987.50,'2022-08-19 09:17:29','',''),(3383,'1','275','1',1,'Retail Sale Id 3293',4501.20,0.00,0.00,6.05,477.95,'2022-08-19 09:23:27','',''),(3384,'1','275','1',1,'Retail Sale Id 3294',44020.00,0.00,0.00,62.00,2790.00,'2022-08-19 09:25:31','',''),(3385,'1','275','1',1,'Retail Sale Id 3295',996.96,0.00,0.00,1.34,105.86,'2022-08-19 09:28:13','',''),(3386,'1','275','1',1,'Retail Sale Id 3296',996.96,0.00,0.00,1.34,105.86,'2022-08-19 09:42:50','',''),(3387,'1','275','1',1,'Retail Sale Id 3297',8520.00,0.00,0.00,12.00,540.00,'2022-08-19 09:45:00','',''),(3388,'1','275','1',1,'Retail Sale Id 3298',4501.20,0.00,0.00,6.05,477.95,'2022-08-19 09:45:58','',''),(3389,'1','275','1',1,'Retail Sale Id 3299',62480.00,0.00,0.00,88.00,3960.00,'2022-08-19 09:58:20','',''),(3390,'1','275','1',1,'Retail Sale Id 3300',9300.00,0.00,0.00,12.50,987.50,'2022-08-19 10:00:28','',''),(3391,'1','275','1',1,'Retail Sale Id 3301',4002.72,0.00,0.00,5.38,425.02,'2022-08-19 10:02:21','',''),(3392,'1','275','1',1,'Retail Sale Id 3302',3720.00,0.00,0.00,5.00,395.00,'2022-08-19 10:03:38','',''),(3393,'1','275','1',1,'Retail Sale Id 3303',1502.88,0.00,0.00,2.02,159.58,'2022-08-19 10:15:40','',''),(3394,'1','275','1',1,'Retail Sale Id 3304',2001.36,0.00,0.00,2.69,212.51,'2022-08-19 10:17:01','',''),(3395,'1','275','1',1,'Retail Sale Id 3305',2998.32,0.00,0.00,4.03,318.37,'2022-08-19 10:18:30','',''),(3396,'1','275','1',1,'Retail Sale Id 3306',14200.00,0.00,0.00,20.00,900.00,'2022-08-19 10:23:14','',''),(3397,'1','275','1',1,'Retail Sale Id 3307',1502.88,0.00,0.00,2.02,159.58,'2022-08-19 10:28:27','',''),(3398,'1','275','1',1,'Retail Sale Id 3308',8520.00,0.00,0.00,12.00,540.00,'2022-08-19 10:33:08','',''),(3399,'1','275','1',1,'Retail Sale Id 3309',18600.00,0.00,0.00,25.00,1975.00,'2022-08-19 10:41:02','',''),(3400,'1','275','1',1,'Retail Sale Id 3310',190280.00,0.00,0.00,268.00,12060.00,'2022-08-19 11:38:12','',''),(3401,'1','275','1',1,'Retail Sale Id 3311',9002.40,0.00,0.00,12.10,955.90,'2022-08-19 11:40:23','',''),(3402,'1','275','1',1,'Retail Sale Id 3312',18600.00,0.00,0.00,25.00,1975.00,'2022-08-19 11:41:37','',''),(3403,'1','275','1',1,'Retail Sale Id 3313',9300.00,0.00,0.00,12.50,987.50,'2022-08-19 11:51:59','',''),(3404,'1','275','1',1,'Retail Sale Id 3314',4501.20,0.00,0.00,6.05,477.95,'2022-08-19 11:57:28','',''),(3405,'1','275','1',1,'Retail Sale Id 3315',4999.68,0.00,0.00,6.72,530.88,'2022-08-19 11:59:07','',''),(3406,'1','275','1',1,'Retail Sale Id 3316',9300.00,0.00,0.00,12.50,987.50,'2022-08-19 12:04:20','',''),(3407,'1','275','1',1,'Retail Sale Id 3317',9300.00,0.00,0.00,12.50,987.50,'2022-08-19 12:32:39','',''),(3408,'1','275','1',1,'Retail Sale Id 3318',4501.20,0.00,0.00,6.05,477.95,'2022-08-19 12:33:25','',''),(3409,'1','275','1',1,'Retail Sale Id 3319',9300.00,0.00,0.00,12.50,987.50,'2022-08-19 12:49:51','',''),(3410,'1','275','1',1,'Retail Sale Id 3320',4501.20,0.00,0.00,6.05,477.95,'2022-08-19 12:51:50','',''),(3411,'1','275','1',1,'Retail Sale Id 3321',4501.20,0.00,0.00,6.05,477.95,'2022-08-19 12:52:54','',''),(3412,'1','275','1',1,'Retail Sale Id 3322',4501.20,0.00,0.00,6.05,477.95,'2022-08-19 13:02:50','',''),(3413,'1','275','1',1,'Retail Sale Id 3323',2998.32,0.00,0.00,4.03,318.37,'2022-08-19 13:22:24','',''),(3414,'1','275','1',1,'Retail Sale Id 3324',9300.00,0.00,0.00,12.50,987.50,'2022-08-19 13:35:11','',''),(3415,'1','275','1',1,'Retail Sale Id 3325',9300.00,0.00,0.00,12.50,987.50,'2022-08-19 13:38:24','',''),(3416,'1','275','1',1,'Retail Sale Id 3326',9300.00,0.00,0.00,12.50,987.50,'2022-08-19 14:36:23','',''),(3417,'1','275','1',1,'Retail Sale Id 3327',2001.36,0.00,0.00,2.69,212.51,'2022-08-19 14:37:55','',''),(3418,'1','275','1',1,'Retail Sale Id 3328',9300.00,0.00,0.00,12.50,987.50,'2022-08-19 14:40:35','',''),(3419,'1','275','1',1,'Retail Sale Id 3329',9300.00,0.00,0.00,12.50,987.50,'2022-08-19 14:47:02','',''),(3420,'1','275','1',1,'Retail Sale Id 3330',2298.96,0.00,0.00,3.09,244.11,'2022-08-19 14:47:59','',''),(3421,'1','275','1',1,'Retail Sale Id 3331',1502.88,0.00,0.00,2.02,159.58,'2022-08-19 14:58:23','',''),(3422,'1','275','1',1,'Retail Sale Id 3332',35500.00,0.00,0.00,50.00,2250.00,'2022-08-19 15:03:49','',''),(3423,'1','275','1',1,'Retail Sale Id 3333',35500.00,0.00,0.00,50.00,2250.00,'2022-08-19 15:05:33','',''),(3424,'1','275','1',1,'Retail Sale Id 3334',1502.88,0.00,0.00,2.02,159.58,'2022-08-19 15:36:51','',''),(3425,'1','275','1',1,'Retail Sale Id 3335',9300.00,0.00,0.00,12.50,987.50,'2022-08-19 15:38:04','',''),(3426,'1','275','1',1,'Retail Sale Id 3336',9300.00,0.00,0.00,12.50,987.50,'2022-08-19 15:39:14','',''),(3427,'1','275','1',1,'Retail Sale Id 3337',4999.68,0.00,0.00,6.72,530.88,'2022-08-19 15:44:10','',''),(3428,'1','275','1',1,'Retail Sale Id 3338',2001.36,0.00,0.00,2.69,212.51,'2022-08-19 15:48:49','',''),(3429,'1','275','1',1,'Retail Sale Id 3339',4501.20,0.00,0.00,6.05,477.95,'2022-08-19 15:58:45','',''),(3430,'1','275','1',1,'Retail Sale Id 3340',2298.96,0.00,0.00,3.09,244.11,'2022-08-19 16:09:30','',''),(3431,'1','275','1',1,'Retail Sale Id 3340',2298.96,0.00,0.00,3.09,244.11,'2022-08-19 16:09:30','',''),(3432,'1','275','1',1,'Retail Sale Id 3341',1502.88,0.00,0.00,2.02,159.58,'2022-08-19 16:18:25','',''),(3433,'1','275','1',1,'Retail Sale Id 3342',93000.00,0.00,0.00,125.00,9875.00,'2022-08-19 16:26:54','',''),(3434,'1','275','1',1,'Retail Sale Id 3343',2298.96,0.00,0.00,3.09,244.11,'2022-08-19 16:48:30','',''),(3435,'1','275','1',1,'Retail Sale Id 3344',2298.96,0.00,0.00,3.09,244.11,'2022-08-19 16:53:32','',''),(3436,'1','275','1',1,'Retail Sale Id 3345',23501.00,0.00,0.00,33.10,1489.50,'2022-08-19 17:07:47','',''),(3437,'1','275','1',1,'Retail Sale Id 3346',3720.00,0.00,0.00,5.00,395.00,'2022-08-19 17:13:53','',''),(3438,'1','275','1',1,'Retail Sale Id 3347',9300.00,0.00,0.00,12.50,987.50,'2022-08-19 17:17:33','',''),(3439,'1','275','1',1,'Retail Sale Id 3348',4501.20,0.00,0.00,6.05,477.95,'2022-08-19 17:18:55','',''),(3440,'1','275','1',1,'Retail Sale Id 3349',4002.72,0.00,0.00,5.38,425.02,'2022-08-19 17:20:04','',''),(3441,'1','275','1',1,'Retail Sale Id 3350',11197.20,0.00,0.00,15.05,1188.95,'2022-08-19 17:41:52','',''),(3442,'1','275','1',1,'Retail Sale Id 3351',35500.00,0.00,0.00,50.00,2250.00,'2022-08-19 17:47:43','',''),(3443,'1','275','1',1,'Retail Sale Id 3352',9300.00,0.00,0.00,12.50,987.50,'2022-08-19 17:58:57','',''),(3444,'1','275','1',1,'Retail Sale Id 3353',7440.00,0.00,0.00,10.00,790.00,'2022-08-19 18:00:05','',''),(3445,'1','275','1',1,'Retail Sale Id 3354',4501.20,0.00,0.00,6.05,477.95,'2022-08-19 18:01:55','',''),(3446,'1','275','1',1,'Retail Sale Id 3355',2298.96,0.00,0.00,3.09,244.11,'2022-08-19 18:22:49','',''),(3447,'1','275','1',1,'Retail Sale Id 3356',2998.32,0.00,0.00,4.03,318.37,'2022-08-19 18:24:47','',''),(3448,'1','275','1',1,'Retail Sale Id 3357',996.96,0.00,0.00,1.34,105.86,'2022-08-19 18:29:21','',''),(3449,'1','275','1',1,'Retail Sale Id 3358',7001.04,0.00,0.00,9.41,743.39,'2022-08-19 18:33:08','',''),(3450,'1','275','1',1,'Retail Sale Id 3359',39424.56,0.00,0.00,52.99,4186.21,'2022-08-19 19:16:39','',''),(3451,'1','275','1',1,'Retail Sale Id 3360',31353.60,0.00,0.00,44.16,1987.20,'2022-08-19 19:17:31','',''),(3452,'1','275','1',1,'Retail Sale Id 3361',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 07:45:06','',''),(3453,'1','275','1',1,'Retail Sale Id 3362',9002.40,0.00,0.00,12.10,955.90,'2022-08-20 07:56:14','',''),(3454,'1','275','1',1,'Retail Sale Id 3363',2001.36,0.00,0.00,2.69,212.51,'2022-08-20 08:00:38','',''),(3455,'1','275','1',1,'Retail Sale Id 3364',2001.36,0.00,0.00,2.69,212.51,'2022-08-20 08:06:23','',''),(3456,'1','275','1',1,'Retail Sale Id 3365',2298.96,0.00,0.00,3.09,244.11,'2022-08-20 08:08:48','',''),(3457,'1','275','1',1,'Retail Sale Id 3366',4501.20,0.00,0.00,6.05,477.95,'2022-08-20 08:23:00','',''),(3458,'1','275','1',1,'Retail Sale Id 3367',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 08:25:54','',''),(3459,'1','275','1',1,'Retail Sale Id 3368',3496.80,0.00,0.00,4.70,371.30,'2022-08-20 08:35:26','',''),(3460,'1','275','1',1,'Retail Sale Id 3368',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 08:35:26','',''),(3461,'1','275','1',1,'Retail Sale Id 3369',4501.20,0.00,0.00,6.05,477.95,'2022-08-20 08:44:42','',''),(3462,'1','275','1',1,'Retail Sale Id 3370',2298.96,0.00,0.00,3.09,244.11,'2022-08-20 08:49:42','',''),(3463,'1','275','1',1,'Retail Sale Id 3371',2298.96,0.00,0.00,3.09,244.11,'2022-08-20 09:09:47','',''),(3464,'1','275','1',1,'Retail Sale Id 3372',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 09:25:26','',''),(3465,'1','275','1',1,'Retail Sale Id 3373',2298.96,0.00,0.00,3.09,244.11,'2022-08-20 09:30:50','',''),(3466,'1','275','1',1,'Retail Sale Id 3374',4501.20,0.00,0.00,6.05,477.95,'2022-08-20 09:33:05','',''),(3467,'1','275','1',1,'Retail Sale Id 3375',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 09:34:40','',''),(3468,'1','275','1',1,'Retail Sale Id 3376',2298.96,0.00,0.00,3.09,244.11,'2022-08-20 09:35:45','',''),(3469,'1','275','1',1,'Retail Sale Id 3377',4501.20,0.00,0.00,6.05,477.95,'2022-08-20 09:37:11','',''),(3470,'1','275','1',1,'Retail Sale Id 3378',23064.00,0.00,0.00,31.00,2449.00,'2022-08-20 09:55:57','',''),(3471,'1','275','1',1,'Retail Sale Id 3379',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 10:05:44','',''),(3472,'1','275','1',1,'Retail Sale Id 3380',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 10:07:28','',''),(3473,'1','275','1',1,'Retail Sale Id 3381',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 10:14:14','',''),(3474,'1','275','1',1,'Retail Sale Id 3382',7998.00,0.00,0.00,10.75,849.25,'2022-08-20 10:18:48','',''),(3475,'1','275','1',1,'Retail Sale Id 3383',996.96,0.00,0.00,1.34,105.86,'2022-08-20 10:20:26','',''),(3476,'1','275','1',1,'Retail Sale Id 3384',803.52,0.00,0.00,1.08,85.32,'2022-08-20 10:24:47','',''),(3477,'1','275','1',1,'Retail Sale Id 3385',803.52,0.00,0.00,1.08,85.32,'2022-08-20 10:25:33','',''),(3478,'1','275','1',1,'Retail Sale Id 3386',7100.00,0.00,0.00,10.00,450.00,'2022-08-20 10:27:35','',''),(3479,'1','275','1',1,'Retail Sale Id 3387',4501.20,0.00,0.00,6.05,477.95,'2022-08-20 10:39:07','',''),(3480,'1','275','1',1,'Retail Sale Id 3388',19880.00,0.00,0.00,28.00,1260.00,'2022-08-20 10:50:23','',''),(3481,'1','275','1',1,'Retail Sale Id 3389',18600.00,0.00,0.00,25.00,1975.00,'2022-08-20 10:58:12','',''),(3482,'1','275','1',1,'Retail Sale Id 3390',4501.20,0.00,0.00,6.05,477.95,'2022-08-20 11:13:53','',''),(3483,'1','275','1',1,'Retail Sale Id 3391',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 11:18:16','',''),(3484,'1','275','1',1,'Retail Sale Id 3392',4002.72,0.00,0.00,5.38,425.02,'2022-08-20 11:19:25','',''),(3485,'1','275','1',1,'Retail Sale Id 3393',2001.36,0.00,0.00,2.69,212.51,'2022-08-20 11:29:56','',''),(3486,'1','275','1',1,'Retail Sale Id 3394',3720.00,0.00,0.00,5.00,395.00,'2022-08-20 11:35:13','',''),(3487,'1','275','1',1,'Retail Sale Id 3395',1502.88,0.00,0.00,2.02,159.58,'2022-08-20 11:36:11','',''),(3488,'1','275','1',1,'Retail Sale Id 3396',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 11:44:29','',''),(3489,'1','275','1',1,'Retail Sale Id 3397',1502.88,0.00,0.00,2.02,159.58,'2022-08-20 11:45:58','',''),(3490,'1','275','1',1,'Retail Sale Id 3398',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 11:47:23','',''),(3491,'1','275','1',1,'Retail Sale Id 3399',31240.00,0.00,0.00,44.00,1980.00,'2022-08-20 11:59:33','',''),(3492,'1','275','1',1,'Retail Sale Id 3400',8496.48,0.00,0.00,11.42,902.18,'2022-08-20 12:02:35','',''),(3493,'1','275','1',1,'Retail Sale Id 3401',46150.00,0.00,0.00,65.00,2925.00,'2022-08-20 12:04:04','',''),(3494,'1','275','1',1,'Retail Sale Id 3402',14880.00,0.00,0.00,20.00,1580.00,'2022-08-20 12:08:27','',''),(3495,'1','275','1',1,'Retail Sale Id 3403',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 12:09:23','',''),(3496,'1','275','1',1,'Retail Sale Id 3404',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 12:11:36','',''),(3497,'1','275','1',1,'Retail Sale Id 3405',7440.00,0.00,0.00,10.00,790.00,'2022-08-20 12:14:14','',''),(3498,'1','275','1',1,'Retail Sale Id 3406',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 12:15:53','',''),(3499,'1','275','1',1,'Retail Sale Id 3407',1860.00,0.00,0.00,2.50,197.50,'2022-08-20 12:23:25','',''),(3500,'1','275','1',1,'Retail Sale Id 3408',4464.00,0.00,0.00,6.00,474.00,'2022-08-20 12:32:48','',''),(3501,'1','275','1',1,'Retail Sale Id 3408',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 12:32:48','',''),(3502,'1','275','1',1,'Retail Sale Id 3409',2298.96,0.00,0.00,3.09,244.11,'2022-08-20 12:38:17','',''),(3503,'1','275','1',1,'Retail Sale Id 3410',4017.60,0.00,0.00,5.40,426.60,'2022-08-20 12:41:20','',''),(3504,'1','275','1',1,'Retail Sale Id 3411',996.96,0.00,0.00,1.34,105.86,'2022-08-20 12:58:48','',''),(3505,'1','275','1',1,'Retail Sale Id 3412',996.96,0.00,0.00,1.34,105.86,'2022-08-20 12:59:33','',''),(3506,'1','275','1',1,'Retail Sale Id 3413',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 13:10:05','',''),(3507,'1','275','1',1,'Retail Sale Id 3414',3496.80,0.00,0.00,4.70,371.30,'2022-08-20 13:22:45','',''),(3508,'1','275','1',1,'Retail Sale Id 3415',4501.20,0.00,0.00,6.05,477.95,'2022-08-20 13:28:58','',''),(3509,'1','275','1',1,'Retail Sale Id 3416',46150.00,0.00,0.00,65.00,2925.00,'2022-08-20 13:32:53','',''),(3510,'1','275','1',1,'Retail Sale Id 3417',2298.96,0.00,0.00,3.09,244.11,'2022-08-20 13:52:02','',''),(3511,'1','275','1',1,'Retail Sale Id 3418',1197.84,0.00,0.00,1.61,127.19,'2022-08-20 13:57:25','',''),(3512,'1','275','1',1,'Retail Sale Id 3419',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 15:03:42','',''),(3513,'1','275','1',1,'Retail Sale Id 3420',2700.72,0.00,0.00,3.63,286.77,'2022-08-20 15:07:48','',''),(3514,'1','275','1',1,'Retail Sale Id 3421',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 15:13:20','',''),(3515,'1','275','1',1,'Retail Sale Id 3422',4501.20,0.00,0.00,6.05,477.95,'2022-08-20 15:17:32','',''),(3516,'1','275','1',1,'Retail Sale Id 3423',4501.20,0.00,0.00,6.05,477.95,'2022-08-20 15:21:37','',''),(3517,'1','275','1',1,'Retail Sale Id 3424',35500.00,0.00,0.00,50.00,2250.00,'2022-08-20 15:26:10','',''),(3518,'1','275','1',1,'Retail Sale Id 3425',996.96,0.00,0.00,1.34,105.86,'2022-08-20 15:27:55','',''),(3519,'1','275','1',1,'Retail Sale Id 3426',44020.00,0.00,0.00,62.00,2790.00,'2022-08-20 15:29:28','',''),(3520,'1','275','1',1,'Retail Sale Id 3427',1502.88,0.00,0.00,2.02,159.58,'2022-08-20 15:43:18','',''),(3521,'1','275','1',1,'Retail Sale Id 3428',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 15:49:54','',''),(3522,'1','275','1',1,'Retail Sale Id 3429',1502.88,0.00,0.00,2.02,159.58,'2022-08-20 15:54:53','',''),(3523,'1','275','1',1,'Retail Sale Id 3430',4501.20,0.00,0.00,6.05,477.95,'2022-08-20 15:57:56','',''),(3524,'1','275','1',1,'Retail Sale Id 3431',23064.00,0.00,0.00,31.00,2449.00,'2022-08-20 15:59:29','',''),(3525,'1','275','1',1,'Retail Sale Id 3432',4999.68,0.00,0.00,6.72,530.88,'2022-08-20 16:01:09','',''),(3526,'1','275','1',1,'Retail Sale Id 3433',4501.20,0.00,0.00,6.05,477.95,'2022-08-20 16:01:53','',''),(3527,'1','275','1',1,'Retail Sale Id 3434',1502.88,0.00,0.00,2.02,159.58,'2022-08-20 16:28:08','',''),(3528,'1','275','1',1,'Retail Sale Id 3435',996.96,0.00,0.00,1.34,105.86,'2022-08-20 16:32:16','',''),(3529,'1','275','1',1,'Retail Sale Id 3436',4650.00,0.00,0.00,6.25,493.75,'2022-08-20 16:43:08','',''),(3530,'1','275','1',1,'Retail Sale Id 3437',4650.00,0.00,0.00,6.25,493.75,'2022-08-20 16:48:08','',''),(3531,'1','275','1',1,'Retail Sale Id 3438',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 16:58:16','',''),(3532,'1','275','1',1,'Retail Sale Id 3440',18600.00,0.00,0.00,25.00,1975.00,'2022-08-20 17:03:14','',''),(3533,'1','275','1',1,'Retail Sale Id 3441',2298.96,0.00,0.00,3.09,244.11,'2022-08-20 17:18:06','',''),(3534,'1','275','1',1,'Retail Sale Id 3442',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 17:29:14','',''),(3535,'1','275','1',1,'Retail Sale Id 3443',996.96,0.00,0.00,1.34,105.86,'2022-08-20 17:38:56','',''),(3536,'1','275','1',1,'Retail Sale Id 3444',1860.00,0.00,0.00,2.50,197.50,'2022-08-20 17:44:28','',''),(3537,'1','275','1',1,'Retail Sale Id 3445',7998.00,0.00,0.00,10.75,849.25,'2022-08-20 18:00:26','',''),(3538,'1','275','1',1,'Retail Sale Id 3446',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 18:01:29','',''),(3539,'1','275','1',1,'Retail Sale Id 3447',24999.10,0.00,0.00,35.21,1584.45,'2022-08-20 18:20:14','',''),(3540,'1','275','1',1,'Retail Sale Id 3448',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 18:22:27','',''),(3541,'1','275','1',1,'Retail Sale Id 3449',1860.00,0.00,0.00,2.50,197.50,'2022-08-20 18:27:08','',''),(3542,'1','275','1',1,'Retail Sale Id 3450',2998.32,0.00,0.00,4.03,318.37,'2022-08-20 18:28:24','',''),(3543,'1','275','1',1,'Retail Sale Id 3451',4501.20,0.00,0.00,6.05,477.95,'2022-08-20 18:45:31','',''),(3544,'1','275','1',1,'Retail Sale Id 3452',2298.96,0.00,0.00,3.09,244.11,'2022-08-20 18:56:59','',''),(3545,'1','275','1',1,'Retail Sale Id 3453',1502.88,0.00,0.00,2.02,159.58,'2022-08-20 18:57:51','',''),(3546,'1','275','1',1,'Retail Sale Id 3454',1502.88,0.00,0.00,2.02,159.58,'2022-08-20 19:12:32','',''),(3547,'1','275','1',1,'Retail Sale Id 3455',18347.04,0.00,0.00,24.66,1948.14,'2022-08-20 19:26:09','',''),(3548,'1','275','1',1,'Return of Retail Sale Id 3440',0.00,18600.00,25.00,0.00,-1975.00,'2022-08-20 19:27:49','',''),(3549,'1','275','1',1,'Retail Sale Id 3456',18600.00,0.00,0.00,25.00,1975.00,'2022-08-20 19:32:46','',''),(3550,'1','275','1',1,'Retail Sale Id 3457',9300.00,0.00,0.00,12.50,987.50,'2022-08-21 07:48:21','',''),(3551,'1','275','1',1,'Retail Sale Id 3458',2298.96,0.00,0.00,3.09,244.11,'2022-08-21 07:50:14','',''),(3552,'1','275','1',1,'Retail Sale Id 3459',996.96,0.00,0.00,1.34,105.86,'2022-08-21 08:10:09','',''),(3553,'1','275','1',1,'Retail Sale Id 3460',9300.00,0.00,0.00,12.50,987.50,'2022-08-21 08:49:18','',''),(3554,'1','275','1',1,'Retail Sale Id 3461',9300.00,0.00,0.00,12.50,987.50,'2022-08-21 09:40:05','',''),(3555,'1','275','1',1,'Retail Sale Id 3462',2298.96,0.00,0.00,3.09,244.11,'2022-08-21 09:40:57','',''),(3556,'1','275','1',1,'Retail Sale Id 3463',4501.20,0.00,0.00,6.05,477.95,'2022-08-21 09:43:17','',''),(3557,'1','275','1',1,'Retail Sale Id 3464',4501.20,0.00,0.00,6.05,477.95,'2022-08-21 09:44:07','',''),(3558,'1','275','1',1,'Retail Sale Id 3465',3720.00,0.00,0.00,5.00,395.00,'2022-08-21 09:52:12','',''),(3559,'1','275','1',1,'Retail Sale Id 3466',9300.00,0.00,0.00,12.50,987.50,'2022-08-21 09:59:15','',''),(3560,'1','275','1',1,'Retail Sale Id 3467',9300.00,0.00,0.00,12.50,987.50,'2022-08-21 10:10:35','',''),(3561,'1','275','1',1,'Retail Sale Id 3468',9300.00,0.00,0.00,12.50,987.50,'2022-08-21 10:13:46','',''),(3562,'1','275','1',1,'Retail Sale Id 3469',9300.00,0.00,0.00,12.50,987.50,'2022-08-21 10:16:58','',''),(3563,'1','275','1',1,'Retail Sale Id 3470',2001.36,0.00,0.00,2.69,212.51,'2022-08-21 10:32:56','',''),(3564,'1','275','1',1,'Retail Sale Id 3471',1502.88,0.00,0.00,2.02,159.58,'2022-08-21 11:10:30','',''),(3565,'1','275','1',1,'Retail Sale Id 3472',4999.68,0.00,0.00,6.72,530.88,'2022-08-21 11:12:54','',''),(3566,'1','275','1',1,'Retail Sale Id 3473',1101.12,0.00,0.00,1.48,116.92,'2022-08-21 11:26:06','',''),(3567,'1','275','1',1,'Retail Sale Id 3474',2998.32,0.00,0.00,4.03,318.37,'2022-08-21 11:29:07','',''),(3568,'1','275','1',1,'Retail Sale Id 3475',2298.96,0.00,0.00,3.09,244.11,'2022-08-21 11:35:55','',''),(3569,'1','275','1',1,'Retail Sale Id 3476',7440.00,0.00,0.00,10.00,790.00,'2022-08-21 11:46:51','',''),(3570,'1','275','1',1,'Retail Sale Id 3477',4501.20,0.00,0.00,6.05,477.95,'2022-08-21 11:53:31','',''),(3571,'1','275','1',1,'Retail Sale Id 3478',9300.00,0.00,0.00,12.50,987.50,'2022-08-21 11:57:06','',''),(3572,'1','275','1',1,'Retail Sale Id 3479',751.44,0.00,0.00,1.01,79.79,'2022-08-21 12:02:48','',''),(3573,'1','275','1',1,'Retail Sale Id 3480',1502.88,0.00,0.00,2.02,159.58,'2022-08-21 12:13:26','',''),(3574,'1','275','1',1,'Retail Sale Id 3481',4002.72,0.00,0.00,5.38,425.02,'2022-08-21 12:14:32','',''),(3575,'1','275','1',1,'Retail Sale Id 3482',4501.20,0.00,0.00,6.05,477.95,'2022-08-21 12:17:06','',''),(3576,'1','275','1',1,'Retail Sale Id 3483',4002.72,0.00,0.00,5.38,425.02,'2022-08-21 12:18:11','',''),(3577,'1','275','1',1,'Retail Sale Id 3484',4501.20,0.00,0.00,6.05,477.95,'2022-08-21 12:24:25','',''),(3578,'1','275','1',1,'Retail Sale Id 3485',35500.00,0.00,0.00,50.00,2250.00,'2022-08-21 12:26:39','',''),(3579,'1','275','1',1,'Retail Sale Id 3486',2232.00,0.00,0.00,3.00,237.00,'2022-08-21 12:38:27','',''),(3580,'1','275','1',1,'Retail Sale Id 3486',9300.00,0.00,0.00,12.50,987.50,'2022-08-21 12:38:27','',''),(3581,'1','275','1',1,'Retail Sale Id 3487',9300.00,0.00,0.00,12.50,987.50,'2022-08-21 12:50:21','',''),(3582,'1','275','1',1,'Retail Sale Id 3488',9300.00,0.00,0.00,12.50,987.50,'2022-08-21 12:56:47','',''),(3583,'1','275','1',1,'Retail Sale Id 3489',17997.36,0.00,0.00,24.19,1911.01,'2022-08-21 12:59:20','',''),(3584,'1','275','1',1,'Retail Sale Id 3490',803.52,0.00,0.00,1.08,85.32,'2022-08-21 13:02:18','',''),(3585,'1','275','1',1,'Retail Sale Id 3491',4501.20,0.00,0.00,6.05,477.95,'2022-08-21 13:16:25','',''),(3586,'1','275','1',1,'Retail Sale Id 3492',996.96,0.00,0.00,1.34,105.86,'2022-08-21 13:18:38','',''),(3587,'1','275','1',1,'Retail Sale Id 3493',9300.00,0.00,0.00,12.50,987.50,'2022-08-21 13:20:53','',''),(3588,'1','275','1',1,'Retail Sale Id 3494',2298.96,0.00,0.00,3.09,244.11,'2022-08-21 13:22:09','',''),(3589,'1','275','1',1,'Retail Sale Id 3495',4501.20,0.00,0.00,6.05,477.95,'2022-08-21 13:25:57','',''),(3590,'1','275','1',1,'Retail Sale Id 3496',9300.00,0.00,0.00,12.50,987.50,'2022-08-21 13:30:16','',''),(3591,'1','275','1',1,'Retail Sale Id 3497',9300.00,0.00,0.00,12.50,987.50,'2022-08-21 13:32:12','',''),(3592,'1','275','1',1,'Retail Sale Id 3498',4501.20,0.00,0.00,6.05,477.95,'2022-08-21 13:39:09','',''),(3593,'1','275','1',1,'Retail Sale Id 3499',2298.96,0.00,0.00,3.09,244.11,'2022-08-21 13:56:26','',''),(3594,'1','275','1',1,'Retail Sale Id 3500',7440.00,0.00,0.00,10.00,790.00,'2022-08-21 13:58:59','',''),(3595,'1','275','1',1,'Retail Sale Id 3500',9300.00,0.00,0.00,12.50,987.50,'2022-08-21 13:58:59','',''),(3596,'1','275','1',1,'Retail Sale Id 3501',7440.00,0.00,0.00,10.00,790.00,'2022-08-21 14:06:39','',''),(3597,'1','275','1',1,'Retail Sale Id 3502',2001.36,0.00,0.00,2.69,212.51,'2022-08-21 14:16:49','',''),(3598,'1','275','1',1,'Retail Sale Id 3503',18600.00,0.00,0.00,25.00,1975.00,'2022-08-21 14:18:21','',''),(3599,'1','275','1',1,'Retail Sale Id 3504',2998.32,0.00,0.00,4.03,318.37,'2022-08-21 14:19:01','',''),(3600,'1','275','1',1,'Retail Sale Id 3505',2998.32,0.00,0.00,4.03,318.37,'2022-08-21 14:22:35','',''),(3601,'1','275','1',1,'Retail Sale Id 3506',2998.32,0.00,0.00,4.03,318.37,'2022-08-21 14:27:58','',''),(3602,'1','275','1',1,'Retail Sale Id 3507',2298.96,0.00,0.00,3.09,244.11,'2022-08-21 14:29:27','',''),(3603,'1','275','1',1,'Retail Sale Id 3507',9300.00,0.00,0.00,12.50,987.50,'2022-08-21 14:29:27','',''),(3604,'1','275','1',1,'Retail Sale Id 3508',9300.00,0.00,0.00,12.50,987.50,'2022-08-21 14:40:06','',''),(3605,'1','275','1',1,'Retail Sale Id 3509',35145.00,0.00,0.00,49.50,2227.50,'2022-08-21 15:08:08','',''),(3606,'1','275','1',1,'Retail Sale Id 3510',4151.52,0.00,0.00,5.58,440.82,'2022-08-21 15:32:11','',''),(3607,'1','275','1',1,'Return of Retail Sale Id 3509',0.00,35145.00,49.50,0.00,-2227.50,'2022-08-21 15:33:45','',''),(3608,'1','275','1',1,'Retail Sale Id 3511',34541.50,0.00,0.00,48.65,2189.25,'2022-08-21 15:35:26','',''),(3609,'1','275','1',1,'Distributed to OPPRETIONAL LOST  for sales id:13',54636.40,0.00,0.00,82.16,0.00,'2022-08-21 15:47:37','',''),(3610,'1','275',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3610950.00,5430.00,0.00,0.00,'2022-08-21 17:45:24','',''),(3611,'1','275',NULL,1,'Reception corrector for bridging 15',0.00,0.00,0.00,5430.00,0.00,'2022-08-21 17:46:13','',''),(3612,'1','275','1',1,'Received from bridging 15',0.00,0.00,5430.00,0.00,0.00,'2022-08-21 17:46:13','',''),(3613,'1','275','1',1,'Retail Sale Id 3512',105790.00,0.00,0.00,149.00,6705.00,'2022-08-21 17:51:29','',''),(3614,'1','275','1',1,'Retail Sale Id 3513',39050.00,0.00,0.00,55.00,2475.00,'2022-08-21 17:53:09','',''),(3615,'1','275','1',1,'Retail Sale Id 3514',18600.00,0.00,0.00,25.00,1975.00,'2022-08-21 17:53:59','',''),(3616,'1','275','1',1,'Retail Sale Id 3515',9300.00,0.00,0.00,12.50,987.50,'2022-08-21 17:54:29','',''),(3617,'1','275','1',1,'Retail Sale Id 3516',9300.00,0.00,0.00,12.50,987.50,'2022-08-21 17:55:03','',''),(3618,'1','275','1',1,'Retail Sale Id 3517',996.96,0.00,0.00,1.34,105.86,'2022-08-21 18:11:05','',''),(3619,'1','275','1',1,'Retail Sale Id 3518',4501.20,0.00,0.00,6.05,477.95,'2022-08-21 18:11:57','',''),(3620,'1','275','1',1,'Retail Sale Id 3519',996.96,0.00,0.00,1.34,105.86,'2022-08-21 18:21:38','',''),(3621,'1','275','1',1,'Retail Sale Id 3520',3801.84,0.00,0.00,5.11,403.69,'2022-08-21 18:38:23','',''),(3622,'1','275','1',1,'Retail Sale Id 3521',4999.68,0.00,0.00,6.72,530.88,'2022-08-21 18:48:55','',''),(3623,'1','275','1',1,'Retail Sale Id 3522',52027.92,0.00,0.00,69.93,5524.47,'2022-08-21 19:18:55','',''),(3624,'1','275','1',1,'Retail Sale Id 3523',158330.00,0.00,0.00,223.00,10035.00,'2022-08-21 19:20:33','',''),(3625,'1','275','1',1,'Retail Sale Id 3524',4501.20,0.00,0.00,6.05,477.95,'2022-08-22 07:34:45','',''),(3626,'1','275','1',1,'Retail Sale Id 3525',2298.96,0.00,0.00,3.09,244.11,'2022-08-22 08:02:39','',''),(3627,'1','275','1',1,'Retail Sale Id 3526',2499.84,0.00,0.00,3.36,265.44,'2022-08-22 08:13:25','',''),(3628,'1','275','1',1,'Retail Sale Id 3527',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 08:30:53','',''),(3629,'1','275','1',1,'Retail Sale Id 3528',2001.36,0.00,0.00,2.69,212.51,'2022-08-22 09:01:30','',''),(3630,'1','275','1',1,'Retail Sale Id 3529',2998.32,0.00,0.00,4.03,318.37,'2022-08-22 09:05:04','',''),(3631,'1','275','1',1,'Retail Sale Id 3530',9002.40,0.00,0.00,12.10,955.90,'2022-08-22 09:16:31','',''),(3632,'1','275','1',1,'Retail Sale Id 3531',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 09:35:56','',''),(3633,'1','275','1',1,'Retail Sale Id 3532',2998.32,0.00,0.00,4.03,318.37,'2022-08-22 09:48:51','',''),(3634,'1','275','1',1,'Retail Sale Id 3533',4501.20,0.00,0.00,6.05,477.95,'2022-08-22 09:50:07','',''),(3635,'1','275','1',1,'Retail Sale Id 3534',4501.20,0.00,0.00,6.05,477.95,'2022-08-22 10:07:58','',''),(3636,'1','275','1',1,'Retail Sale Id 3535',2998.32,0.00,0.00,4.03,318.37,'2022-08-22 10:20:38','',''),(3637,'1','275','1',1,'Retail Sale Id 3536',2298.96,0.00,0.00,3.09,244.11,'2022-08-22 10:23:04','',''),(3638,'1','275','1',1,'Retail Sale Id 3537',3720.00,0.00,0.00,5.00,395.00,'2022-08-22 10:24:39','',''),(3639,'1','275','1',1,'Retail Sale Id 3538',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 10:30:04','',''),(3640,'1','275','1',1,'Retail Sale Id 3538',37200.00,0.00,0.00,50.00,3950.00,'2022-08-22 10:30:04','',''),(3641,'1','275','1',1,'Retail Sale Id 3539',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 10:32:05','',''),(3642,'1','275','1',1,'Retail Sale Id 3540',5996.64,0.00,0.00,8.06,636.74,'2022-08-22 10:34:49','',''),(3643,'1','275','1',1,'Retail Sale Id 3541',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 10:49:25','',''),(3644,'1','275','1',1,'Retail Sale Id 3542',7440.00,0.00,0.00,10.00,790.00,'2022-08-22 11:06:49','',''),(3645,'1','275','1',1,'Retail Sale Id 3543',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 11:08:24','',''),(3646,'1','275','1',1,'Retail Sale Id 3544',35500.00,0.00,0.00,50.00,2250.00,'2022-08-22 11:29:32','',''),(3647,'1','275','1',1,'Retail Sale Id 3545',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 11:40:07','',''),(3648,'1','275','1',1,'Retail Sale Id 3546',71000.00,0.00,0.00,100.00,4500.00,'2022-08-22 11:42:14','',''),(3649,'1','275','1',1,'Retail Sale Id 3547',1153.20,0.00,0.00,1.55,122.45,'2022-08-22 11:46:19','',''),(3650,'1','275','1',1,'Retail Sale Id 3548',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 11:49:48','',''),(3651,'1','275','1',1,'Retail Sale Id 3549',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 11:56:36','',''),(3652,'1','275','1',1,'Retail Sale Id 3550',7440.00,0.00,0.00,10.00,790.00,'2022-08-22 12:02:17','',''),(3653,'1','275','1',1,'Retail Sale Id 3551',4999.68,0.00,0.00,6.72,530.88,'2022-08-22 12:17:10','',''),(3654,'1','275','1',1,'Retail Sale Id 3552',59640.00,0.00,0.00,84.00,3780.00,'2022-08-22 12:36:43','',''),(3655,'1','275','1',1,'Retail Sale Id 3553',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 12:42:45','',''),(3656,'1','275','1',1,'Retail Sale Id 3554',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 12:52:46','',''),(3657,'1','275','1',1,'Retail Sale Id 3555',2001.36,0.00,0.00,2.69,212.51,'2022-08-22 13:12:41','',''),(3658,'1','275','1',1,'Retail Sale Id 3556',2001.36,0.00,0.00,2.69,212.51,'2022-08-22 13:27:40','',''),(3659,'1','275','1',1,'Retail Sale Id 3557',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 13:40:00','',''),(3660,'1','275','1',1,'Retail Sale Id 3559',3801.84,0.00,0.00,5.11,403.69,'2022-08-22 14:27:57','',''),(3661,'1','275','1',1,'Retail Sale Id 3559',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 14:27:57','',''),(3662,'1','275','1',1,'Retail Sale Id 3560',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 14:31:30','',''),(3663,'1','275','1',1,'Retail Sale Id 3561',2298.96,0.00,0.00,3.09,244.11,'2022-08-22 14:33:17','',''),(3664,'1','275','1',1,'Retail Sale Id 3562',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 14:36:17','',''),(3665,'1','275','1',1,'Retail Sale Id 3563',2298.96,0.00,0.00,3.09,244.11,'2022-08-22 14:43:01','',''),(3666,'1','275','1',1,'Retail Sale Id 3564',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 14:55:12','',''),(3667,'1','275','1',1,'Retail Sale Id 3565',2298.96,0.00,0.00,3.09,244.11,'2022-08-22 14:56:44','',''),(3668,'1','275','1',1,'Retail Sale Id 3566',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 14:58:12','',''),(3669,'1','275','1',1,'Retail Sale Id 3567',18600.00,0.00,0.00,25.00,1975.00,'2022-08-22 15:08:43','',''),(3670,'1','275','1',1,'Retail Sale Id 3568',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 15:10:27','',''),(3671,'1','275','1',1,'Retail Sale Id 3569',1502.88,0.00,0.00,2.02,159.58,'2022-08-22 15:20:53','',''),(3672,'1','275','1',1,'Retail Sale Id 3570',7440.00,0.00,0.00,10.00,790.00,'2022-08-22 15:22:11','',''),(3673,'1','275','1',1,'Retail Sale Id 3571',2298.96,0.00,0.00,3.09,244.11,'2022-08-22 15:28:59','',''),(3674,'1','275','1',1,'Retail Sale Id 3572',2998.32,0.00,0.00,4.03,318.37,'2022-08-22 15:37:31','',''),(3675,'1','275','1',1,'Retail Sale Id 3573',35500.00,0.00,0.00,50.00,2250.00,'2022-08-22 15:40:50','',''),(3676,'1','275','1',1,'Retail Sale Id 3574',4501.20,0.00,0.00,6.05,477.95,'2022-08-22 15:46:29','',''),(3677,'1','275','1',1,'Retail Sale Id 3575',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 15:52:38','',''),(3678,'1','275','1',1,'Retail Sale Id 3576',1197.84,0.00,0.00,1.61,127.19,'2022-08-22 16:00:58','',''),(3679,'1','275','1',1,'Retail Sale Id 3577',4501.20,0.00,0.00,6.05,477.95,'2022-08-22 16:16:13','',''),(3680,'1','275','1',1,'Retail Sale Id 3578',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 16:27:13','',''),(3681,'1','275','1',1,'Retail Sale Id 3579',4002.72,0.00,0.00,5.38,425.02,'2022-08-22 16:29:51','',''),(3682,'1','275','1',1,'Retail Sale Id 3579',4002.72,0.00,0.00,5.38,425.02,'2022-08-22 16:29:51','',''),(3683,'1','275','1',1,'Retail Sale Id 3580',4501.20,0.00,0.00,6.05,477.95,'2022-08-22 16:33:50','',''),(3684,'1','275','1',1,'Retail Sale Id 3581',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 16:34:43','',''),(3685,'1','275','1',1,'Retail Sale Id 3582',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 17:01:43','',''),(3686,'1','275','1',1,'Retail Sale Id 3583',1502.88,0.00,0.00,2.02,159.58,'2022-08-22 17:08:12','',''),(3687,'1','275','1',1,'Retail Sale Id 3584',47570.00,0.00,0.00,67.00,3015.00,'2022-08-22 17:10:25','',''),(3688,'1','275','1',1,'Retail Sale Id 3585',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 17:22:49','',''),(3689,'1','275','1',1,'Retail Sale Id 3586',2298.96,0.00,0.00,3.09,244.11,'2022-08-22 17:24:17','',''),(3690,'1','275','1',1,'Retail Sale Id 3587',2998.32,0.00,0.00,4.03,318.37,'2022-08-22 17:29:27','',''),(3691,'1','275','1',1,'Retail Sale Id 3587',2998.32,0.00,0.00,4.03,318.37,'2022-08-22 17:29:27','',''),(3692,'1','275','1',1,'Retail Sale Id 3588',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 17:35:22','',''),(3693,'1','275','1',1,'Retail Sale Id 3589',16997.40,0.00,0.00,23.94,1077.30,'2022-08-22 17:45:29','',''),(3694,'1','275','1',1,'Retail Sale Id 3590',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 17:51:09','',''),(3695,'1','275','1',1,'Retail Sale Id 3591',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 17:52:56','',''),(3696,'1','275','1',1,'Retail Sale Id 3592',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 18:11:29','',''),(3697,'1','275','1',1,'Retail Sale Id 3593',1502.88,0.00,0.00,2.02,159.58,'2022-08-22 18:19:39','',''),(3698,'1','275','1',1,'Retail Sale Id 3594',2001.36,0.00,0.00,2.69,212.51,'2022-08-22 18:26:40','',''),(3699,'1','275','1',1,'Retail Sale Id 3595',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 18:29:18','',''),(3700,'1','275','1',1,'Retail Sale Id 3596',2298.96,0.00,0.00,3.09,244.11,'2022-08-22 18:34:35','',''),(3701,'1','275','1',1,'Retail Sale Id 3597',1101.12,0.00,0.00,1.48,116.92,'2022-08-22 18:35:27','',''),(3702,'1','275','1',1,'Retail Sale Id 3599',5208.00,0.00,0.00,7.00,553.00,'2022-08-22 18:49:20','',''),(3703,'1','275','1',1,'Retail Sale Id 3600',729.12,0.00,0.00,0.98,77.42,'2022-08-22 19:12:04','',''),(3704,'1','275','1',1,'Return of Retail Sale Id 3589',0.00,16997.40,23.94,0.00,-1077.30,'2022-08-22 19:13:22','',''),(3705,'1','275','1',1,'Retail Sale Id 3601',16969.00,0.00,0.00,23.90,1075.50,'2022-08-22 19:15:16','',''),(3706,'1','275','1',1,'Retail Sale Id 3602',1502.88,0.00,0.00,2.02,159.58,'2022-08-23 07:48:00','',''),(3707,'1','275','1',1,'Retail Sale Id 3603',46150.00,0.00,0.00,65.00,2925.00,'2022-08-23 08:08:34','',''),(3708,'1','275','1',1,'Retail Sale Id 3604',2298.96,0.00,0.00,3.09,244.11,'2022-08-23 08:17:54','',''),(3709,'1','275','1',1,'Retail Sale Id 3605',9300.00,0.00,0.00,12.50,987.50,'2022-08-23 08:21:20','',''),(3710,'1','275','1',1,'Retail Sale Id 3607',29997.50,0.00,0.00,42.25,1901.25,'2022-08-23 08:32:02','',''),(3711,'1','275','1',1,'Retail Sale Id 3608',16003.44,0.00,0.00,21.51,1699.29,'2022-08-23 08:33:32','',''),(3712,'1','275','1',1,'Retail Sale Id 3609',39050.00,0.00,0.00,55.00,2475.00,'2022-08-23 08:41:47','',''),(3713,'1','275','1',1,'Retail Sale Id 3610',7998.00,0.00,0.00,10.75,849.25,'2022-08-23 08:43:45','',''),(3714,'1','275','1',1,'Retail Sale Id 3611',996.96,0.00,0.00,1.34,105.86,'2022-08-23 08:44:53','',''),(3715,'1','275','1',1,'Retail Sale Id 3612',4501.20,0.00,0.00,6.05,477.95,'2022-08-23 09:00:32','',''),(3716,'1','275','1',1,'Retail Sale Id 3613',9300.00,0.00,0.00,12.50,987.50,'2022-08-23 09:02:23','',''),(3717,'1','275','1',1,'Retail Sale Id 3614',1502.88,0.00,0.00,2.02,159.58,'2022-08-23 09:33:03','',''),(3718,'1','275','1',1,'Retail Sale Id 3615',4002.72,0.00,0.00,5.38,425.02,'2022-08-23 09:37:57','',''),(3719,'1','275','1',1,'Retail Sale Id 3616',7998.00,0.00,0.00,10.75,849.25,'2022-08-23 09:42:12','',''),(3720,'1','275','1',1,'Retail Sale Id 3617',4501.20,0.00,0.00,6.05,477.95,'2022-08-23 09:58:05','',''),(3721,'1','275','1',1,'Retail Sale Id 3617',9300.00,0.00,0.00,12.50,987.50,'2022-08-23 09:58:05','',''),(3722,'1','275','1',1,'Retail Sale Id 3618',9300.00,0.00,0.00,12.50,987.50,'2022-08-23 10:04:35','',''),(3723,'1','275','1',1,'Retail Sale Id 3619',7499.52,0.00,0.00,10.08,796.32,'2022-08-23 10:23:29','',''),(3724,'1','275','1',1,'Retail Sale Id 3620',9300.00,0.00,0.00,12.50,987.50,'2022-08-23 10:39:11','',''),(3725,'1','275','1',1,'Retail Sale Id 3621',8520.00,0.00,0.00,12.00,540.00,'2022-08-23 10:46:58','',''),(3726,'1','275','1',1,'Retail Sale Id 3622',996.96,0.00,0.00,1.34,105.86,'2022-08-23 11:11:09','',''),(3727,'1','275','1',1,'Retail Sale Id 3623',18600.00,0.00,0.00,25.00,1975.00,'2022-08-23 11:18:41','',''),(3728,'1','275','1',1,'Retail Sale Id 3624',2298.96,0.00,0.00,3.09,244.11,'2022-08-23 11:26:45','',''),(3729,'1','275','1',1,'Retail Sale Id 3625',9300.00,0.00,0.00,12.50,987.50,'2022-08-23 11:52:23','',''),(3730,'1','275','1',1,'Retail Sale Id 3626',9300.00,0.00,0.00,12.50,987.50,'2022-08-23 12:03:13','',''),(3731,'1','275','1',1,'Retail Sale Id 3627',4002.72,0.00,0.00,5.38,425.02,'2022-08-23 12:20:04','',''),(3732,'1','275','1',1,'Retail Sale Id 3628',9300.00,0.00,0.00,12.50,987.50,'2022-08-23 12:21:09','',''),(3733,'1','275','1',1,'Retail Sale Id 3629',7998.00,0.00,0.00,10.75,849.25,'2022-08-23 12:24:33','',''),(3734,'1','275','1',1,'Retail Sale Id 3630',9300.00,0.00,0.00,12.50,987.50,'2022-08-23 12:34:05','',''),(3735,'1','275','1',1,'Retail Sale Id 3631',33370.00,0.00,0.00,47.00,2115.00,'2022-08-23 12:52:54','',''),(3736,'1','275','1',1,'Retail Sale Id 3632',35500.00,0.00,0.00,50.00,2250.00,'2022-08-23 13:08:57','',''),(3737,'1','275','1',1,'Retail Sale Id 3633',4501.20,0.00,0.00,6.05,477.95,'2022-08-23 13:21:01','',''),(3738,'1','275','1',1,'Retail Sale Id 3634',181760.00,0.00,0.00,256.00,11520.00,'2022-08-23 13:33:37','',''),(3739,'1','275','1',1,'Retail Sale Id 3635',7440.00,0.00,0.00,10.00,790.00,'2022-08-23 13:34:34','',''),(3740,'1','275','1',1,'Retail Sale Id 3636',4501.20,0.00,0.00,6.05,477.95,'2022-08-23 13:39:40','',''),(3741,'1','275','1',1,'Retail Sale Id 3637',35500.00,0.00,0.00,50.00,2250.00,'2022-08-23 13:41:31','',''),(3742,'1','275','1',1,'Retail Sale Id 3638',8520.00,0.00,0.00,12.00,540.00,'2022-08-23 13:43:32','',''),(3743,'1','275','1',1,'Retail Sale Id 3639',2001.36,0.00,0.00,2.69,212.51,'2022-08-23 13:57:12','',''),(3744,'1','275','1',1,'Retail Sale Id 3640',5996.64,0.00,0.00,8.06,636.74,'2022-08-23 13:58:00','',''),(3745,'1','275','1',1,'Retail Sale Id 3641',4002.72,0.00,0.00,5.38,425.02,'2022-08-23 14:07:56','',''),(3746,'1','275','1',1,'Retail Sale Id 3642',498.48,0.00,0.00,0.67,52.93,'2022-08-23 14:20:28','',''),(3747,'1','275','1',1,'Retail Sale Id 3643',2202.24,0.00,0.00,2.96,233.84,'2022-08-23 14:28:11','',''),(3748,'1','275','1',1,'Retail Sale Id 3644',9300.00,0.00,0.00,12.50,987.50,'2022-08-23 14:51:34','',''),(3749,'1','275','1',1,'Retail Sale Id 3645',996.96,0.00,0.00,1.34,105.86,'2022-08-23 15:01:46','',''),(3750,'1','275','1',1,'Retail Sale Id 3647',14880.00,0.00,0.00,20.00,1580.00,'2022-08-23 15:41:09','',''),(3751,'1','275','1',1,'Retail Sale Id 3648',3749.76,0.00,0.00,5.04,398.16,'2022-08-23 15:42:59','',''),(3752,'1','275','1',1,'Retail Sale Id 3649',4002.72,0.00,0.00,5.38,425.02,'2022-08-23 15:44:29','',''),(3753,'1','275','1',1,'Retail Sale Id 3650',9300.00,0.00,0.00,12.50,987.50,'2022-08-23 15:45:31','',''),(3754,'1','275','1',1,'Retail Sale Id 3651',2001.36,0.00,0.00,2.69,212.51,'2022-08-23 15:49:44','',''),(3755,'1','275','1',1,'Retail Sale Id 3646',4501.20,0.00,0.00,6.05,477.95,'2022-08-23 15:58:15','',''),(3756,'1','275','1',1,'Retail Sale Id 3652',9002.40,0.00,0.00,12.10,955.90,'2022-08-23 16:02:07','',''),(3757,'1','275','1',1,'Retail Sale Id 3653',18600.00,0.00,0.00,25.00,1975.00,'2022-08-23 16:19:46','',''),(3758,'1','275','1',1,'Retail Sale Id 3654',9300.00,0.00,0.00,12.50,987.50,'2022-08-23 16:20:55','',''),(3759,'1','275','1',1,'Retail Sale Id 3655',7499.52,0.00,0.00,10.08,796.32,'2022-08-23 16:30:46','',''),(3760,'1','275','1',1,'Retail Sale Id 3656',9300.00,0.00,0.00,12.50,987.50,'2022-08-23 16:36:27','',''),(3761,'1','275','1',1,'Retail Sale Id 3657',9300.00,0.00,0.00,12.50,987.50,'2022-08-23 16:37:49','',''),(3762,'1','275','1',1,'Retail Sale Id 3658',1696.32,0.00,0.00,2.28,180.12,'2022-08-23 16:47:04','',''),(3763,'1','275','1',1,'Retail Sale Id 3659',2001.36,0.00,0.00,2.69,212.51,'2022-08-23 16:49:34','',''),(3764,'1','275','1',1,'Retail Sale Id 3660',2298.96,0.00,0.00,3.09,244.11,'2022-08-23 16:55:50','',''),(3765,'1','275','1',1,'Retail Sale Id 3660',2298.96,0.00,0.00,3.09,244.11,'2022-08-23 16:55:50','',''),(3766,'1','275','1',1,'Retail Sale Id 3661',2499.84,0.00,0.00,3.36,265.44,'2022-08-23 17:02:25','',''),(3767,'1','275','1',1,'Retail Sale Id 3662',1502.88,0.00,0.00,2.02,159.58,'2022-08-23 17:10:48','',''),(3768,'1','275','1',1,'Retail Sale Id 3663',4501.20,0.00,0.00,6.05,477.95,'2022-08-23 17:15:23','',''),(3769,'1','275','1',1,'Retail Sale Id 3664',1502.88,0.00,0.00,2.02,159.58,'2022-08-23 17:21:59','',''),(3770,'1','275','1',1,'Retail Sale Id 3665',37200.00,0.00,0.00,50.00,3950.00,'2022-08-23 17:27:20','',''),(3771,'1','275','1',1,'Retail Sale Id 3666',996.96,0.00,0.00,1.34,105.86,'2022-08-23 17:30:56','',''),(3772,'1','275','1',1,'Retail Sale Id 3667',4002.72,0.00,0.00,5.38,425.02,'2022-08-23 17:47:20','',''),(3773,'1','275','1',1,'Retail Sale Id 3668',2298.96,0.00,0.00,3.09,244.11,'2022-08-23 17:50:27','',''),(3774,'1','275','1',1,'Retail Sale Id 3669',9300.00,0.00,0.00,12.50,987.50,'2022-08-23 17:53:06','',''),(3775,'1','275','1',1,'Retail Sale Id 3670',37200.00,0.00,0.00,50.00,3950.00,'2022-08-23 17:54:49','',''),(3776,'1','275','1',1,'Retail Sale Id 3671',35500.00,0.00,0.00,50.00,2250.00,'2022-08-23 17:57:27','',''),(3777,'1','275','1',1,'Retail Sale Id 3672',9300.00,0.00,0.00,12.50,987.50,'2022-08-23 18:04:11','',''),(3778,'1','275','1',1,'Retail Sale Id 3673',2998.32,0.00,0.00,4.03,318.37,'2022-08-23 18:07:51','',''),(3779,'1','275','1',1,'Retail Sale Id 3674',9300.00,0.00,0.00,12.50,987.50,'2022-08-23 18:19:11','',''),(3780,'1','275','1',1,'Retail Sale Id 3675',2998.32,0.00,0.00,4.03,318.37,'2022-08-23 18:27:35','',''),(3781,'1','275','1',1,'Retail Sale Id 3676',1502.88,0.00,0.00,2.02,159.58,'2022-08-23 18:29:47','',''),(3782,'1','275','1',1,'Retail Sale Id 3677',9300.00,0.00,0.00,12.50,987.50,'2022-08-23 18:30:57','',''),(3783,'1','275','1',1,'Retail Sale Id 3678',7440.00,0.00,0.00,10.00,790.00,'2022-08-23 18:40:06','',''),(3784,'1','275','1',1,'Retail Sale Id 3679',996.96,0.00,0.00,1.34,105.86,'2022-08-23 18:43:57','',''),(3785,'1','275','1',1,'Retail Sale Id 3680',3496.80,0.00,0.00,4.70,371.30,'2022-08-23 18:45:37','',''),(3786,'1','275','1',1,'Retail Sale Id 3680',5498.16,0.00,0.00,7.39,583.81,'2022-08-23 18:45:37','',''),(3787,'1','275','1',1,'Retail Sale Id 3681',9300.00,0.00,0.00,12.50,987.50,'2022-08-23 18:50:42','',''),(3788,'1','275','1',1,'Return of Retail Sale Id 3681',0.00,9300.00,12.50,0.00,-987.50,'2022-08-23 19:14:05','',''),(3789,'1','275','1',1,'Retail Sale Id 3682',6465.36,0.00,0.00,8.69,686.51,'2022-08-23 19:15:58','',''),(3790,'1','275','1',1,'Retail Sale Id 3683',16230.60,0.00,0.00,22.86,1028.70,'2022-08-23 19:16:40','',''),(3791,'1','275','1',1,'Retail Sale Id 3684',9300.00,0.00,0.00,12.50,987.50,'2022-08-24 07:41:29','',''),(3792,'1','275','1',1,'Retail Sale Id 3685',2998.32,0.00,0.00,4.03,318.37,'2022-08-24 07:50:28','',''),(3793,'1','275','1',1,'Retail Sale Id 3686',4501.20,0.00,0.00,6.05,477.95,'2022-08-24 08:08:44','',''),(3794,'1','275','1',1,'Retail Sale Id 3687',27001.30,0.00,0.00,38.03,1711.35,'2022-08-24 08:37:55','',''),(3795,'1','275','1',1,'Retail Sale Id 3688',35500.00,0.00,0.00,50.00,2250.00,'2022-08-24 08:43:30','',''),(3796,'1','275','1',1,'Retail Sale Id 3689',2001.36,0.00,0.00,2.69,212.51,'2022-08-24 08:51:32','',''),(3797,'1','275','1',1,'Retail Sale Id 3690',9300.00,0.00,0.00,12.50,987.50,'2022-08-24 08:52:36','',''),(3798,'1','275','1',1,'Retail Sale Id 3691',4501.20,0.00,0.00,6.05,477.95,'2022-08-24 09:26:00','',''),(3799,'1','275','1',1,'Retail Sale Id 3692',2001.36,0.00,0.00,2.69,212.51,'2022-08-24 09:26:41','',''),(3800,'1','275','1',1,'Retail Sale Id 3693',2298.96,0.00,0.00,3.09,244.11,'2022-08-24 09:28:43','',''),(3801,'1','275','1',1,'Retail Sale Id 3694',996.96,0.00,0.00,1.34,105.86,'2022-08-24 09:29:55','',''),(3802,'1','275','1',1,'Retail Sale Id 3695',3496.80,0.00,0.00,4.70,371.30,'2022-08-24 09:36:38','',''),(3803,'1','275','1',1,'Retail Sale Id 3695',7499.52,0.00,0.00,10.08,796.32,'2022-08-24 09:36:38','',''),(3804,'1','275','1',1,'Retail Sale Id 3696',9300.00,0.00,0.00,12.50,987.50,'2022-08-24 10:00:39','',''),(3805,'1','275','1',1,'Retail Sale Id 3697',2298.96,0.00,0.00,3.09,244.11,'2022-08-24 10:03:28','',''),(3806,'1','275','1',1,'Retail Sale Id 3698',9300.00,0.00,0.00,12.50,987.50,'2022-08-24 10:07:38','',''),(3807,'1','275','1',1,'Retail Sale Id 3699',4501.20,0.00,0.00,6.05,477.95,'2022-08-24 10:15:17','',''),(3808,'1','275','1',1,'Retail Sale Id 3700',1502.88,0.00,0.00,2.02,159.58,'2022-08-24 10:52:58','',''),(3809,'1','275','1',1,'Retail Sale Id 3701',9300.00,0.00,0.00,12.50,987.50,'2022-08-24 11:03:30','',''),(3810,'1','275','1',1,'Retail Sale Id 3702',996.96,0.00,0.00,1.34,105.86,'2022-08-24 11:12:10','',''),(3811,'1','275','1',1,'Retail Sale Id 3703',30998.60,0.00,0.00,43.66,1964.70,'2022-08-24 11:15:32','',''),(3812,'1','275','1',1,'Retail Sale Id 3704',4501.20,0.00,0.00,6.05,477.95,'2022-08-24 11:22:06','',''),(3813,'1','275','1',1,'Retail Sale Id 3705',37200.00,0.00,0.00,50.00,3950.00,'2022-08-24 11:52:52','',''),(3814,'1','275','1',1,'Retail Sale Id 3706',2001.36,0.00,0.00,2.69,212.51,'2022-08-24 12:10:38','',''),(3815,'1','275','1',1,'Retail Sale Id 3707',46150.00,0.00,0.00,65.00,2925.00,'2022-08-24 12:24:04','',''),(3816,'1','275','1',1,'Retail Sale Id 3708',9300.00,0.00,0.00,12.50,987.50,'2022-08-24 12:25:29','',''),(3817,'1','275','1',1,'Retail Sale Id 3709',4501.20,0.00,0.00,6.05,477.95,'2022-08-24 12:57:47','',''),(3818,'1','275','1',1,'Retail Sale Id 3710',2298.96,0.00,0.00,3.09,244.11,'2022-08-24 13:02:51','',''),(3819,'1','275','1',1,'Retail Sale Id 3711',9300.00,0.00,0.00,12.50,987.50,'2022-08-24 13:04:55','',''),(3820,'1','275','1',1,'Retail Sale Id 3712',9300.00,0.00,0.00,12.50,987.50,'2022-08-24 13:06:47','',''),(3821,'1','275','1',1,'Retail Sale Id 3713',4501.20,0.00,0.00,6.05,477.95,'2022-08-24 13:08:09','',''),(3822,'1','275','1',1,'Retail Sale Id 3714',2298.96,0.00,0.00,3.09,244.11,'2022-08-24 13:15:31','',''),(3823,'1','275','1',1,'Retail Sale Id 3714',4002.72,0.00,0.00,5.38,425.02,'2022-08-24 13:15:31','',''),(3824,'1','275','1',1,'Retail Sale Id 3715',35500.00,0.00,0.00,50.00,2250.00,'2022-08-24 13:38:19','',''),(3825,'1','275','1',1,'Retail Sale Id 3716',28002.40,0.00,0.00,39.44,1774.80,'2022-08-24 14:06:04','',''),(3826,'1','275','1',1,'Retail Sale Id 3717',9300.00,0.00,0.00,12.50,987.50,'2022-08-24 14:12:52','',''),(3827,'1','275','1',1,'Retail Sale Id 3718',2998.32,0.00,0.00,4.03,318.37,'2022-08-24 14:34:26','',''),(3828,'1','275','1',1,'Retail Sale Id 3719',9300.00,0.00,0.00,12.50,987.50,'2022-08-24 14:50:08','',''),(3829,'1','275','1',1,'Retail Sale Id 3720',9300.00,0.00,0.00,12.50,987.50,'2022-08-24 15:01:12','',''),(3830,'1','275','1',1,'Retail Sale Id 3721',1502.88,0.00,0.00,2.02,159.58,'2022-08-24 15:09:53','',''),(3831,'1','275','1',1,'Retail Sale Id 3722',9300.00,0.00,0.00,12.50,987.50,'2022-08-24 15:25:40','',''),(3832,'1','275','1',1,'Retail Sale Id 3723',9300.00,0.00,0.00,12.50,987.50,'2022-08-24 15:43:16','',''),(3833,'1','275','1',1,'Retail Sale Id 3724',35500.00,0.00,0.00,50.00,2250.00,'2022-08-24 15:45:32','',''),(3834,'1','275','1',1,'Retail Sale Id 3725',1502.88,0.00,0.00,2.02,159.58,'2022-08-24 15:54:13','',''),(3835,'1','275','1',1,'Retail Sale Id 3726',996.96,0.00,0.00,1.34,105.86,'2022-08-24 15:55:07','',''),(3836,'1','275','1',1,'Retail Sale Id 3727',2298.96,0.00,0.00,3.09,244.11,'2022-08-24 15:59:43','',''),(3837,'1','275','1',1,'Retail Sale Id 3728',9300.00,0.00,0.00,12.50,987.50,'2022-08-24 16:01:54','',''),(3838,'1','275','1',1,'Retail Sale Id 3729',4999.68,0.00,0.00,6.72,530.88,'2022-08-24 16:14:56','',''),(3839,'1','275','1',1,'Retail Sale Id 3730',1800.48,0.00,0.00,2.42,191.18,'2022-08-24 16:38:45','',''),(3840,'1','275','1',1,'Retail Sale Id 3731',4501.20,0.00,0.00,6.05,477.95,'2022-08-24 16:46:53','',''),(3841,'1','275','1',1,'Retail Sale Id 3732',996.96,0.00,0.00,1.34,105.86,'2022-08-24 16:51:46','',''),(3842,'1','275','1',1,'Retail Sale Id 3733',4501.20,0.00,0.00,6.05,477.95,'2022-08-24 16:59:04','',''),(3843,'1','275','1',1,'Retail Sale Id 3734',2298.96,0.00,0.00,3.09,244.11,'2022-08-24 17:10:43','',''),(3844,'1','275','1',1,'Retail Sale Id 3735',3801.84,0.00,0.00,5.11,403.69,'2022-08-24 17:12:48','',''),(3845,'1','275','1',1,'Retail Sale Id 3736',9002.40,0.00,0.00,12.10,955.90,'2022-08-24 17:30:31','',''),(3846,'1','275','1',1,'Retail Sale Id 3737',4501.20,0.00,0.00,6.05,477.95,'2022-08-24 17:35:48','',''),(3847,'1','275','1',1,'Retail Sale Id 3738',14200.00,0.00,0.00,20.00,900.00,'2022-08-24 17:36:39','',''),(3848,'1','275','1',1,'Retail Sale Id 3739',3720.00,0.00,0.00,5.00,395.00,'2022-08-24 17:38:40','',''),(3849,'1','275','1',1,'Retail Sale Id 3739',9300.00,0.00,0.00,12.50,987.50,'2022-08-24 17:38:40','',''),(3850,'1','275','1',1,'Retail Sale Id 3740',35500.00,0.00,0.00,50.00,2250.00,'2022-08-24 17:42:06','',''),(3851,'1','275','1',1,'Retail Sale Id 3741',2998.32,0.00,0.00,4.03,318.37,'2022-08-24 17:42:50','',''),(3852,'1','275','1',1,'Retail Sale Id 3742',3749.76,0.00,0.00,5.04,398.16,'2022-08-24 17:45:12','',''),(3853,'1','275','1',1,'Retail Sale Id 3743',35500.00,0.00,0.00,50.00,2250.00,'2022-08-24 17:52:04','',''),(3854,'1','275','1',1,'Retail Sale Id 3744',9300.00,0.00,0.00,12.50,987.50,'2022-08-24 18:01:58','',''),(3855,'1','275','1',1,'Retail Sale Id 3745',4501.20,0.00,0.00,6.05,477.95,'2022-08-24 18:16:26','',''),(3856,'1','275','1',1,'Retail Sale Id 3746',9300.00,0.00,0.00,12.50,987.50,'2022-08-24 18:28:01','',''),(3857,'1','275','1',1,'Retail Sale Id 3747',16345.68,0.00,0.00,21.97,1735.63,'2022-08-24 19:08:35','',''),(3858,'1','275','1',1,'Retail Sale Id 3748',14469.80,0.00,0.00,20.38,917.10,'2022-08-24 19:10:12','',''),(3859,'1','275','1',1,'Retail Sale Id 3749',9300.00,0.00,0.00,12.50,987.50,'2022-08-25 07:14:25','',''),(3860,'1','275','1',1,'Retail Sale Id 3751',9300.00,0.00,0.00,12.50,987.50,'2022-08-25 07:25:38','',''),(3861,'1','275','1',1,'Retail Sale Id 3752',2998.32,0.00,0.00,4.03,318.37,'2022-08-25 07:26:24','',''),(3862,'1','275','1',1,'Retail Sale Id 3753',3496.80,0.00,0.00,4.70,371.30,'2022-08-25 07:29:07','',''),(3863,'1','275','1',1,'Retail Sale Id 3754',744.00,0.00,0.00,1.00,79.00,'2022-08-25 07:50:48','',''),(3864,'1','275','1',1,'Retail Sale Id 3755',7797.12,0.00,0.00,10.48,827.92,'2022-08-25 08:08:20','',''),(3865,'1','275','1',1,'Retail Sale Id 3756',9300.00,0.00,0.00,12.50,987.50,'2022-08-25 08:11:46','',''),(3866,'1','275','1',1,'Retail Sale Id 3757',8520.00,0.00,0.00,12.00,540.00,'2022-08-25 08:16:10','',''),(3867,'1','275','1',1,'Retail Sale Id 3758',34498.90,0.00,0.00,48.59,2186.55,'2022-08-25 08:18:18','',''),(3868,'1','275','1',1,'Retail Sale Id 3759',7998.00,0.00,0.00,10.75,849.25,'2022-08-25 08:34:17','',''),(3869,'1','275','1',1,'Retail Sale Id 3761',7998.00,0.00,0.00,10.75,849.25,'2022-08-25 08:42:23','',''),(3870,'1','275','1',1,'Retail Sale Id 3762',9300.00,0.00,0.00,12.50,987.50,'2022-08-25 08:48:44','',''),(3871,'1','275','1',1,'Retail Sale Id 3763',9300.00,0.00,0.00,12.50,987.50,'2022-08-25 08:49:49','',''),(3872,'1','275','1',1,'Retail Sale Id 3764',4501.20,0.00,0.00,6.05,477.95,'2022-08-25 09:05:56','',''),(3873,'1','275','1',1,'Retail Sale Id 3765',5996.64,0.00,0.00,8.06,636.74,'2022-08-25 09:07:37','',''),(3874,'1','275','1',1,'Retail Sale Id 3766',3496.80,0.00,0.00,4.70,371.30,'2022-08-25 09:12:26','',''),(3875,'1','275','1',1,'Retail Sale Id 3767',9300.00,0.00,0.00,12.50,987.50,'2022-08-25 09:16:02','',''),(3876,'1','275','1',1,'Retail Sale Id 3768',4999.68,0.00,0.00,6.72,530.88,'2022-08-25 09:31:46','',''),(3877,'1','275','1',1,'Retail Sale Id 3769',8556.00,0.00,0.00,11.50,908.50,'2022-08-25 09:35:12','',''),(3878,'1','275','1',1,'Retail Sale Id 3770',67450.00,0.00,0.00,95.00,4275.00,'2022-08-25 09:54:59','',''),(3879,'1','275','1',1,'Retail Sale Id 3771',3720.00,0.00,0.00,5.00,395.00,'2022-08-25 10:01:32','',''),(3880,'1','275','1',1,'Retail Sale Id 3771',9300.00,0.00,0.00,12.50,987.50,'2022-08-25 10:01:32','',''),(3881,'1','275','1',1,'Retail Sale Id 3772',9300.00,0.00,0.00,12.50,987.50,'2022-08-25 10:24:07','',''),(3882,'1','275','1',1,'Retail Sale Id 3773',71000.00,0.00,0.00,100.00,4500.00,'2022-08-25 10:45:00','',''),(3883,'1','275','1',1,'Retail Sale Id 3774',6696.00,0.00,0.00,9.00,711.00,'2022-08-25 10:48:18','',''),(3884,'1','275','1',1,'Retail Sale Id 3775',9300.00,0.00,0.00,12.50,987.50,'2022-08-25 10:52:09','',''),(3885,'1','275','1',1,'Retail Sale Id 3776',996.96,0.00,0.00,1.34,105.86,'2022-08-25 11:11:52','',''),(3886,'1','275','1',1,'Retail Sale Id 3777',3496.80,0.00,0.00,4.70,371.30,'2022-08-25 11:12:44','',''),(3887,'1','275','1',1,'Retail Sale Id 3778',4999.68,0.00,0.00,6.72,530.88,'2022-08-25 11:20:56','',''),(3888,'1','275','1',1,'Retail Sale Id 3779',9300.00,0.00,0.00,12.50,987.50,'2022-08-25 11:57:27','',''),(3889,'1','275','1',1,'Retail Sale Id 3780',4501.20,0.00,0.00,6.05,477.95,'2022-08-25 11:58:25','',''),(3890,'1','275','1',1,'Retail Sale Id 3781',744.00,0.00,0.00,1.00,79.00,'2022-08-25 12:33:10','',''),(3891,'1','275','1',1,'Retail Sale Id 3782',9300.00,0.00,0.00,12.50,987.50,'2022-08-25 12:34:56','',''),(3892,'1','275','1',1,'Retail Sale Id 3783',3720.00,0.00,0.00,5.00,395.00,'2022-08-25 12:45:57','',''),(3893,'1','275','1',1,'Retail Sale Id 3784',9300.00,0.00,0.00,12.50,987.50,'2022-08-25 12:49:05','',''),(3894,'1','275','1',1,'Retail Sale Id 3785',2001.36,0.00,0.00,2.69,212.51,'2022-08-25 12:55:03','',''),(3895,'1','275','1',1,'Retail Sale Id 3786',35500.00,0.00,0.00,50.00,2250.00,'2022-08-25 13:02:13','',''),(3896,'1','275','1',1,'Retail Sale Id 3787',4501.20,0.00,0.00,6.05,477.95,'2022-08-25 13:03:18','',''),(3897,'1','275','1',1,'Retail Sale Id 3788',2298.96,0.00,0.00,3.09,244.11,'2022-08-25 13:04:18','',''),(3898,'1','275','1',1,'Retail Sale Id 3789',3801.84,0.00,0.00,5.11,403.69,'2022-08-25 13:16:50','',''),(3899,'1','275','1',1,'Retail Sale Id 3790',996.96,0.00,0.00,1.34,105.86,'2022-08-25 13:17:37','',''),(3900,'1','275','1',1,'Retail Sale Id 3791',14200.00,0.00,0.00,20.00,900.00,'2022-08-25 13:22:28','',''),(3901,'1','275','1',1,'Retail Sale Id 3792',9300.00,0.00,0.00,12.50,987.50,'2022-08-25 13:23:19','',''),(3902,'1','275','1',1,'Retail Sale Id 3793',14880.00,0.00,0.00,20.00,1580.00,'2022-08-25 13:27:02','',''),(3903,'1','275','1',1,'Retail Sale Id 3794',4002.72,0.00,0.00,5.38,425.02,'2022-08-25 13:30:45','',''),(3904,'1','275','1',1,'Retail Sale Id 3795',1488.00,0.00,0.00,2.00,158.00,'2022-08-25 13:34:35','',''),(3905,'1','275','1',1,'Retail Sale Id 3796',2998.32,0.00,0.00,4.03,318.37,'2022-08-25 13:35:43','',''),(3906,'1','275','1',1,'Retail Sale Id 3797',744.00,0.00,0.00,1.00,79.00,'2022-08-25 13:44:05','',''),(3907,'1','275','1',1,'Retail Sale Id 3798',9300.00,0.00,0.00,12.50,987.50,'2022-08-25 13:47:49','',''),(3908,'1','275','1',1,'Retail Sale Id 3799',4501.20,0.00,0.00,6.05,477.95,'2022-08-25 14:21:43','',''),(3909,'1','275','1',1,'Retail Sale Id 3800',1502.88,0.00,0.00,2.02,159.58,'2022-08-25 14:32:11','',''),(3910,'1','275','1',1,'Retail Sale Id 3801',1197.84,0.00,0.00,1.61,127.19,'2022-08-25 14:57:45','',''),(3911,'1','275','1',1,'Retail Sale Id 3802',996.96,0.00,0.00,1.34,105.86,'2022-08-25 15:00:08','',''),(3912,'1','275','1',1,'Retail Sale Id 3803',9300.00,0.00,0.00,12.50,987.50,'2022-08-25 15:05:12','',''),(3913,'1','275','1',1,'Retail Sale Id 3804',2001.36,0.00,0.00,2.69,212.51,'2022-08-25 15:11:27','',''),(3914,'1','275','1',1,'Retail Sale Id 3805',9300.00,0.00,0.00,12.50,987.50,'2022-08-25 15:33:07','',''),(3915,'1','275','1',1,'Retail Sale Id 3806',2998.32,0.00,0.00,4.03,318.37,'2022-08-25 15:40:00','',''),(3916,'1','275','1',1,'Retail Sale Id 3807',3749.76,0.00,0.00,5.04,398.16,'2022-08-25 15:44:21','',''),(3917,'1','275','1',1,'Retail Sale Id 3808',9300.00,0.00,0.00,12.50,987.50,'2022-08-25 15:46:21','',''),(3918,'1','275','1',1,'Retail Sale Id 3809',2298.96,0.00,0.00,3.09,244.11,'2022-08-25 16:13:45','',''),(3919,'1','275','1',1,'Retail Sale Id 3811',24999.10,0.00,0.00,35.21,1584.45,'2022-08-25 16:33:08','',''),(3920,'1','275','1',1,'Retail Sale Id 3812',4501.20,0.00,0.00,6.05,477.95,'2022-08-25 16:35:12','',''),(3921,'1','275','1',1,'Retail Sale Id 3814',4702.08,0.00,0.00,6.32,499.28,'2022-08-25 16:45:35','',''),(3922,'1','275','1',1,'Retail Sale Id 3814',9300.00,0.00,0.00,12.50,987.50,'2022-08-25 16:45:35','',''),(3923,'1','275','1',1,'Retail Sale Id 3815',9300.00,0.00,0.00,12.50,987.50,'2022-08-25 16:47:08','',''),(3924,'1','275','1',1,'Retail Sale Id 3816',2998.32,0.00,0.00,4.03,318.37,'2022-08-25 16:50:32','',''),(3925,'1','275','1',1,'Retail Sale Id 3817',9300.00,0.00,0.00,12.50,987.50,'2022-08-25 17:01:47','',''),(3926,'1','275','1',1,'Retail Sale Id 3818',9300.00,0.00,0.00,12.50,987.50,'2022-08-25 17:05:04','',''),(3927,'1','275','1',1,'Retail Sale Id 3819',7998.00,0.00,0.00,10.75,849.25,'2022-08-25 17:06:26','',''),(3928,'1','275','1',1,'Retail Sale Id 3820',9230.00,0.00,0.00,13.00,585.00,'2022-08-25 17:14:42','',''),(3929,'1','275','1',1,'Retail Sale Id 3821',3749.76,0.00,0.00,5.04,398.16,'2022-08-25 17:16:11','',''),(3930,'1','275','1',1,'Retail Sale Id 3822',279740.00,0.00,0.00,394.00,17730.00,'2022-08-25 17:18:18','',''),(3931,'1','275','1',1,'Retail Sale Id 3823',9300.00,0.00,0.00,12.50,987.50,'2022-08-25 17:37:31','',''),(3932,'1','275','1',1,'Retail Sale Id 3824',3749.76,0.00,0.00,5.04,398.16,'2022-08-25 17:43:18','',''),(3933,'1','275','1',1,'Retail Sale Id 3825',9300.00,0.00,0.00,12.50,987.50,'2022-08-25 17:45:17','',''),(3934,'1','275','1',1,'Retail Sale Id 3826',46150.00,0.00,0.00,65.00,2925.00,'2022-08-25 17:49:42','',''),(3935,'1','275','1',1,'Retail Sale Id 3827',9300.00,0.00,0.00,12.50,987.50,'2022-08-25 17:55:52','',''),(3936,'1','275','1',1,'Retail Sale Id 3827',11160.00,0.00,0.00,15.00,1185.00,'2022-08-25 17:55:52','',''),(3937,'1','275','1',1,'Retail Sale Id 3828',4501.20,0.00,0.00,6.05,477.95,'2022-08-25 17:57:13','',''),(3938,'1','275','1',1,'Retail Sale Id 3829',996.96,0.00,0.00,1.34,105.86,'2022-08-25 18:04:39','',''),(3939,'1','275','1',1,'Retail Sale Id 3830',2001.36,0.00,0.00,2.69,212.51,'2022-08-25 18:11:10','',''),(3940,'1','275','1',1,'Retail Sale Id 3831',4501.20,0.00,0.00,6.05,477.95,'2022-08-25 18:15:37','',''),(3941,'1','275','1',1,'Retail Sale Id 3832',2998.32,0.00,0.00,4.03,318.37,'2022-08-25 18:20:11','',''),(3942,'1','275','1',1,'Retail Sale Id 3833',7001.04,0.00,0.00,9.41,743.39,'2022-08-25 18:22:41','',''),(3943,'1','275','1',1,'Retail Sale Id 3834',34715.04,0.00,0.00,46.66,3686.14,'2022-08-25 19:18:46','',''),(3944,'1','275','1',1,'Retail Sale Id 3835',31169.00,0.00,0.00,43.90,1975.50,'2022-08-25 19:19:22','',''),(3945,'1','275','1',1,'Retail Sale Id 3836',15304.08,0.00,0.00,20.57,1625.03,'2022-08-26 08:22:44','',''),(3946,'1','275','1',1,'Distributed to OPPRETIONAL LOST  for sales id:14',67171.65,0.00,0.00,101.01,0.00,'2022-08-26 08:40:39','',''),(3947,'1','275',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3551100.00,5340.00,0.00,0.00,'2022-08-28 08:13:53','',''),(3948,'1','275',NULL,1,'Reception corrector for bridging 16',0.00,0.00,0.00,5340.00,0.00,'2022-08-28 08:15:10','',''),(3949,'1','275','1',1,'Received from bridging 16',0.00,0.00,5340.00,0.00,0.00,'2022-08-28 08:15:10','',''),(3950,'1','275','1',1,'Retail Sale Id 3837',2298.96,0.00,0.00,3.09,244.11,'2022-08-28 08:44:00','',''),(3951,'1','275','1',1,'Retail Sale Id 3838',4999.68,0.00,0.00,6.72,530.88,'2022-08-28 08:45:05','',''),(3952,'1','275','1',1,'Retail Sale Id 3839',2298.96,0.00,0.00,3.09,244.11,'2022-08-28 08:45:49','',''),(3953,'1','275','1',1,'Retail Sale Id 3840',996.96,0.00,0.00,1.34,105.86,'2022-08-28 08:46:41','',''),(3954,'1','275','1',1,'Retail Sale Id 3841',4501.20,0.00,0.00,6.05,477.95,'2022-08-28 09:07:13','',''),(3955,'1','275','1',1,'Retail Sale Id 3842',2499.84,0.00,0.00,3.36,265.44,'2022-08-28 09:08:35','',''),(3956,'1','275','1',1,'Retail Sale Id 3843',9300.00,0.00,0.00,12.50,987.50,'2022-08-28 09:12:53','',''),(3957,'1','275','1',1,'Retail Sale Id 3844',35500.00,0.00,0.00,50.00,2250.00,'2022-08-28 09:25:43','',''),(3958,'1','275','1',1,'Retail Sale Id 3845',4999.68,0.00,0.00,6.72,530.88,'2022-08-28 09:35:02','',''),(3959,'1','275','1',1,'Retail Sale Id 3846',7440.00,0.00,0.00,10.00,790.00,'2022-08-28 09:57:04','',''),(3960,'1','275','1',1,'Retail Sale Id 3847',9300.00,0.00,0.00,12.50,987.50,'2022-08-28 10:03:13','',''),(3961,'1','275','1',1,'Retail Sale Id 3848',9300.00,0.00,0.00,12.50,987.50,'2022-08-28 10:24:52','',''),(3962,'1','275','1',1,'Retail Sale Id 3849',3720.00,0.00,0.00,5.00,395.00,'2022-08-28 10:30:10','',''),(3963,'1','275','1',1,'Retail Sale Id 3850',9300.00,0.00,0.00,12.50,987.50,'2022-08-28 10:42:04','',''),(3964,'1','275','1',1,'Retail Sale Id 3851',4501.20,0.00,0.00,6.05,477.95,'2022-08-28 10:43:00','',''),(3965,'1','275','1',1,'Retail Sale Id 3852',1502.88,0.00,0.00,2.02,159.58,'2022-08-28 11:02:41','',''),(3966,'1','275','1',1,'Retail Sale Id 3853',996.96,0.00,0.00,1.34,105.86,'2022-08-28 11:15:27','',''),(3967,'1','275','1',1,'Retail Sale Id 3854',18600.00,0.00,0.00,25.00,1975.00,'2022-08-28 11:17:40','',''),(3968,'1','275','1',1,'Retail Sale Id 3855',2298.96,0.00,0.00,3.09,244.11,'2022-08-28 11:23:30','',''),(3969,'1','275','1',1,'Retail Sale Id 3856',9300.00,0.00,0.00,12.50,987.50,'2022-08-28 11:27:58','',''),(3970,'1','275','1',1,'Retail Sale Id 3857',7499.52,0.00,0.00,10.08,796.32,'2022-08-28 11:30:55','',''),(3971,'1','275','1',1,'Retail Sale Id 3858',9300.00,0.00,0.00,12.50,987.50,'2022-08-28 11:31:49','',''),(3972,'1','275','1',1,'Retail Sale Id 3859',996.96,0.00,0.00,1.34,105.86,'2022-08-28 11:32:55','',''),(3973,'1','275','1',1,'Retail Sale Id 3860',803.52,0.00,0.00,1.08,85.32,'2022-08-28 11:34:46','',''),(3974,'1','275','1',1,'Retail Sale Id 3861',9300.00,0.00,0.00,12.50,987.50,'2022-08-28 11:36:14','',''),(3975,'1','275','1',1,'Retail Sale Id 3862',2298.96,0.00,0.00,3.09,244.11,'2022-08-28 11:37:03','',''),(3976,'1','275','1',1,'Retail Sale Id 3863',9300.00,0.00,0.00,12.50,987.50,'2022-08-28 11:38:16','',''),(3977,'1','275','1',1,'Retail Sale Id 3864',9300.00,0.00,0.00,12.50,987.50,'2022-08-28 11:45:17','',''),(3978,'1','275','1',1,'Retail Sale Id 3865',47925.00,0.00,0.00,67.50,3037.50,'2022-08-28 11:48:01','',''),(3979,'1','275','1',1,'Retail Sale Id 3866',20590.00,0.00,0.00,29.00,1305.00,'2022-08-28 11:51:44','',''),(3980,'1','275','1',1,'Retail Sale Id 3867',27498.30,0.00,0.00,38.73,1742.85,'2022-08-28 11:53:10','',''),(3981,'1','275','1',1,'Retail Sale Id 3868',9300.00,0.00,0.00,12.50,987.50,'2022-08-28 11:54:47','',''),(3982,'1','275','1',1,'Retail Sale Id 3869',7440.00,0.00,0.00,10.00,790.00,'2022-08-28 11:56:06','',''),(3983,'1','275','1',1,'Retail Sale Id 3870',35500.00,0.00,0.00,50.00,2250.00,'2022-08-28 11:57:46','',''),(3984,'1','275','1',1,'Retail Sale Id 3871',9300.00,0.00,0.00,12.50,987.50,'2022-08-28 11:58:51','',''),(3985,'1','275','1',1,'Retail Sale Id 3872',4501.20,0.00,0.00,6.05,477.95,'2022-08-28 12:00:08','',''),(3986,'1','275','1',1,'Retail Sale Id 3873',9300.00,0.00,0.00,12.50,987.50,'2022-08-28 12:01:14','',''),(3987,'1','275','1',1,'Retail Sale Id 3874',7440.00,0.00,0.00,10.00,790.00,'2022-08-28 12:03:38','',''),(3988,'1','275','1',1,'Retail Sale Id 3874',9300.00,0.00,0.00,12.50,987.50,'2022-08-28 12:03:38','',''),(3989,'1','275','1',1,'Retail Sale Id 3875',4501.20,0.00,0.00,6.05,477.95,'2022-08-28 12:06:12','',''),(3990,'1','275','1',1,'Retail Sale Id 3876',4501.20,0.00,0.00,6.05,477.95,'2022-08-28 12:09:34','',''),(3991,'1','275','1',1,'Retail Sale Id 3876',9300.00,0.00,0.00,12.50,987.50,'2022-08-28 12:09:34','',''),(3992,'1','275','1',1,'Retail Sale Id 3877',9300.00,0.00,0.00,12.50,987.50,'2022-08-28 12:11:39','',''),(3993,'1','275','1',1,'Retail Sale Id 3878',2998.32,0.00,0.00,4.03,318.37,'2022-08-28 12:19:47','',''),(3994,'1','275','1',1,'Retail Sale Id 3879',699.36,0.00,0.00,0.94,74.26,'2022-08-28 12:24:07','',''),(3995,'1','275','1',1,'Retail Sale Id 3880',3720.00,0.00,0.00,5.00,395.00,'2022-08-28 12:25:23','',''),(3996,'1','275','1',1,'Retail Sale Id 3881',4501.20,0.00,0.00,6.05,477.95,'2022-08-28 12:32:40','',''),(3997,'1','275','1',1,'Retail Sale Id 3882',14999.04,0.00,0.00,20.16,1592.64,'2022-08-28 12:43:37','',''),(3998,'1','275','1',1,'Retail Sale Id 3883',3720.00,0.00,0.00,5.00,395.00,'2022-08-28 12:48:26','',''),(3999,'1','275','1',1,'Retail Sale Id 3884',4501.20,0.00,0.00,6.05,477.95,'2022-08-28 12:55:42','',''),(4000,'1','275','1',1,'Retail Sale Id 3885',2001.36,0.00,0.00,2.69,212.51,'2022-08-28 12:56:49','',''),(4001,'1','275','1',1,'Retail Sale Id 3886',996.96,0.00,0.00,1.34,105.86,'2022-08-28 12:59:31','',''),(4002,'1','275','1',1,'Retail Sale Id 3887',9300.00,0.00,0.00,12.50,987.50,'2022-08-28 13:01:45','',''),(4003,'1','275','1',1,'Retail Sale Id 3888',7810.00,0.00,0.00,11.00,495.00,'2022-08-28 13:15:26','',''),(4004,'1','275','1',1,'Retail Sale Id 3889',2298.96,0.00,0.00,3.09,244.11,'2022-08-28 13:24:58','',''),(4005,'1','275','1',1,'Retail Sale Id 3890',1502.88,0.00,0.00,2.02,159.58,'2022-08-28 13:25:49','',''),(4006,'1','275','1',1,'Retail Sale Id 3891',16368.00,0.00,0.00,22.00,1738.00,'2022-08-28 13:41:53','',''),(4007,'1','275','1',1,'Retail Sale Id 3892',9300.00,0.00,0.00,12.50,987.50,'2022-08-28 13:57:04','',''),(4008,'1','275','1',1,'Retail Sale Id 3893',2001.36,0.00,0.00,2.69,212.51,'2022-08-28 14:00:52','',''),(4009,'1','275','1',1,'Retail Sale Id 3894',9300.00,0.00,0.00,12.50,987.50,'2022-08-28 14:08:33','',''),(4010,'1','275','1',1,'Retail Sale Id 3895',1502.88,0.00,0.00,2.02,159.58,'2022-08-28 14:14:16','',''),(4011,'1','275','1',1,'Retail Sale Id 3896',9300.00,0.00,0.00,12.50,987.50,'2022-08-28 14:20:36','',''),(4012,'1','275','1',1,'Retail Sale Id 3897',2998.32,0.00,0.00,4.03,318.37,'2022-08-28 14:22:20','',''),(4013,'1','275','1',1,'Retail Sale Id 3898',803.52,0.00,0.00,1.08,85.32,'2022-08-28 14:23:49','',''),(4014,'1','275','1',1,'Retail Sale Id 3899',3720.00,0.00,0.00,5.00,395.00,'2022-08-28 14:45:58','',''),(4015,'1','275','1',1,'Retail Sale Id 3900',4501.20,0.00,0.00,6.05,477.95,'2022-08-28 15:00:16','',''),(4016,'1','275','1',1,'Retail Sale Id 3900',18600.00,0.00,0.00,25.00,1975.00,'2022-08-28 15:00:16','',''),(4017,'1','275','1',1,'Retail Sale Id 3901',9300.00,0.00,0.00,12.50,987.50,'2022-08-28 15:01:37','',''),(4018,'1','275','1',1,'Retail Sale Id 3902',18600.00,0.00,0.00,25.00,1975.00,'2022-08-28 15:02:47','',''),(4019,'1','275','1',1,'Retail Sale Id 3903',1502.88,0.00,0.00,2.02,159.58,'2022-08-28 15:03:35','',''),(4020,'1','275','1',1,'Retail Sale Id 3904',37200.00,0.00,0.00,50.00,3950.00,'2022-08-28 15:04:42','',''),(4021,'1','275','1',1,'Retail Sale Id 3905',36920.00,0.00,0.00,52.00,2340.00,'2022-08-28 15:09:25','',''),(4022,'1','275','1',1,'Retail Sale Id 3906',9300.00,0.00,0.00,12.50,987.50,'2022-08-28 15:18:12','',''),(4023,'1','275','1',1,'Retail Sale Id 3907',1502.88,0.00,0.00,2.02,159.58,'2022-08-28 15:40:32','',''),(4024,'1','275','1',1,'Retail Sale Id 3908',2298.96,0.00,0.00,3.09,244.11,'2022-08-28 16:43:07','',''),(4025,'1','275','1',1,'Retail Sale Id 3909',4501.20,0.00,0.00,6.05,477.95,'2022-08-28 16:57:00','',''),(4026,'1','275','1',1,'Retail Sale Id 3910',996.96,0.00,0.00,1.34,105.86,'2022-08-28 17:06:13','',''),(4027,'1','275','1',1,'Retail Sale Id 3911',2998.32,0.00,0.00,4.03,318.37,'2022-08-28 17:17:16','',''),(4028,'1','275','1',1,'Retail Sale Id 3912',9300.00,0.00,0.00,12.50,987.50,'2022-08-28 17:21:27','',''),(4029,'1','275','1',1,'Retail Sale Id 3913',8556.00,0.00,0.00,11.50,908.50,'2022-08-28 17:32:34','',''),(4030,'1','275','1',1,'Retail Sale Id 3914',2298.96,0.00,0.00,3.09,244.11,'2022-08-28 17:47:54','',''),(4031,'1','275','1',1,'Retail Sale Id 3915',996.96,0.00,0.00,1.34,105.86,'2022-08-28 17:52:44','',''),(4032,'1','275','1',1,'Retail Sale Id 3916',8303.04,0.00,0.00,11.16,881.64,'2022-08-28 18:00:42','',''),(4033,'1','275','1',1,'Retail Sale Id 3917',1502.88,0.00,0.00,2.02,159.58,'2022-08-28 18:19:55','',''),(4034,'1','275','1',1,'Retail Sale Id 3918',181760.00,0.00,0.00,256.00,11520.00,'2022-08-28 18:43:41','',''),(4035,'1','275','1',1,'Retail Sale Id 3919',9300.00,0.00,0.00,12.50,987.50,'2022-08-28 18:45:17','',''),(4036,'1','275','1',1,'Retail Sale Id 3920',9300.00,0.00,0.00,12.50,987.50,'2022-08-28 18:47:40','',''),(4037,'1','275','1',1,'Retail Sale Id 3921',2298.96,0.00,0.00,3.09,244.11,'2022-08-28 18:53:43','',''),(4038,'1','275','1',1,'Retail Sale Id 3922',30883.44,0.00,0.00,41.51,3279.29,'2022-08-28 19:29:03','',''),(4039,'1','275','1',1,'Return of Retail Sale Id 3888',0.00,7810.00,11.00,0.00,-495.00,'2022-08-28 19:30:47','',''),(4040,'1','275','1',1,'Retail Sale Id 3923',7085.80,0.00,0.00,9.98,449.10,'2022-08-28 19:32:45','',''),(4041,'1','275','1',1,'Retail Sale Id 3924',9300.00,0.00,0.00,12.50,987.50,'2022-08-29 07:59:15','',''),(4042,'1','275','1',1,'Retail Sale Id 3925',2298.96,0.00,0.00,3.09,244.11,'2022-08-29 08:23:14','',''),(4043,'1','275','1',1,'Retail Sale Id 3926',9300.00,0.00,0.00,12.50,987.50,'2022-08-29 08:29:12','',''),(4044,'1','275','1',1,'Retail Sale Id 3927',4501.20,0.00,0.00,6.05,477.95,'2022-08-29 08:31:25','',''),(4045,'1','275','1',1,'Retail Sale Id 3928',35500.00,0.00,0.00,50.00,2250.00,'2022-08-29 08:33:39','',''),(4046,'1','275','1',1,'Retail Sale Id 3929',2298.96,0.00,0.00,3.09,244.11,'2022-08-29 08:40:05','',''),(4047,'1','275','1',1,'Retail Sale Id 3930',996.96,0.00,0.00,1.34,105.86,'2022-08-29 08:45:15','',''),(4048,'1','275','1',1,'Retail Sale Id 3930',996.96,0.00,0.00,1.34,105.86,'2022-08-29 08:45:15','',''),(4049,'1','275','1',1,'Retail Sale Id 3931',996.96,0.00,0.00,1.34,105.86,'2022-08-29 08:46:04','',''),(4050,'1','275','1',1,'Retail Sale Id 3932',1502.88,0.00,0.00,2.02,159.58,'2022-08-29 08:48:53','',''),(4051,'1','275','1',1,'Retail Sale Id 3933',8165.00,0.00,0.00,11.50,517.50,'2022-08-29 09:25:24','',''),(4052,'1','275','1',1,'Retail Sale Id 3934',9300.00,0.00,0.00,12.50,987.50,'2022-08-29 09:42:35','',''),(4053,'1','275','1',1,'Retail Sale Id 3935',24140.00,0.00,0.00,34.00,1530.00,'2022-08-29 10:02:51','',''),(4054,'1','275','1',1,'Retail Sale Id 3936',9300.00,0.00,0.00,12.50,987.50,'2022-08-29 10:40:26','',''),(4055,'1','275','1',1,'Retail Sale Id 3937',8496.48,0.00,0.00,11.42,902.18,'2022-08-29 10:41:13','',''),(4056,'1','275','1',1,'Retail Sale Id 3938',3697.68,0.00,0.00,4.97,392.63,'2022-08-29 10:42:01','',''),(4057,'1','275','1',1,'Retail Sale Id 3939',8184.00,0.00,0.00,11.00,869.00,'2022-08-29 10:42:41','',''),(4058,'1','275','1',1,'Retail Sale Id 3940',9300.00,0.00,0.00,12.50,987.50,'2022-08-29 11:10:22','',''),(4059,'1','275','1',1,'Retail Sale Id 3941',37200.00,0.00,0.00,50.00,3950.00,'2022-08-29 11:32:43','',''),(4060,'1','275','1',1,'Retail Sale Id 3942',13497.10,0.00,0.00,19.01,855.45,'2022-08-29 11:34:35','',''),(4061,'1','275','1',1,'Retail Sale Id 3943',2298.96,0.00,0.00,3.09,244.11,'2022-08-29 11:36:02','',''),(4062,'1','275','1',1,'Retail Sale Id 3944',37200.00,0.00,0.00,50.00,3950.00,'2022-08-29 11:37:04','',''),(4063,'1','275','1',1,'Retail Sale Id 3945',2001.36,0.00,0.00,2.69,212.51,'2022-08-29 11:37:52','',''),(4064,'1','275','1',1,'Retail Sale Id 3946',22002.90,0.00,0.00,30.99,1394.55,'2022-08-29 11:40:20','',''),(4065,'1','275','1',1,'Retail Sale Id 3947',9300.00,0.00,0.00,12.50,987.50,'2022-08-29 11:41:10','',''),(4066,'1','275','1',1,'Retail Sale Id 3948',2298.96,0.00,0.00,3.09,244.11,'2022-08-29 11:42:39','',''),(4067,'1','275','1',1,'Retail Sale Id 3949',28400.00,0.00,0.00,40.00,1800.00,'2022-08-29 11:43:52','',''),(4068,'1','275','1',1,'Retail Sale Id 3950',9300.00,0.00,0.00,12.50,987.50,'2022-08-29 11:46:29','',''),(4069,'1','275','1',1,'Retail Sale Id 3951',2998.32,0.00,0.00,4.03,318.37,'2022-08-29 11:53:23','',''),(4070,'1','275','1',1,'Retail Sale Id 3952',17040.00,0.00,0.00,24.00,1080.00,'2022-08-29 12:05:17','',''),(4071,'1','275','1',1,'Retail Sale Id 3954',9996.80,0.00,0.00,14.08,633.60,'2022-08-29 12:20:55','',''),(4072,'1','275','1',1,'Retail Sale Id 3955',996.96,0.00,0.00,1.34,105.86,'2022-08-29 12:21:41','',''),(4073,'1','275','1',1,'Retail Sale Id 3956',9300.00,0.00,0.00,12.50,987.50,'2022-08-29 12:24:51','',''),(4074,'1','275','1',1,'Retail Sale Id 3956',37200.00,0.00,0.00,50.00,3950.00,'2022-08-29 12:24:51','',''),(4075,'1','275','1',1,'Retail Sale Id 3957',14880.00,0.00,0.00,20.00,1580.00,'2022-08-29 12:27:33','',''),(4076,'1','275','1',1,'Retail Sale Id 3958',2499.84,0.00,0.00,3.36,265.44,'2022-08-29 12:28:54','',''),(4077,'1','275','1',1,'Retail Sale Id 3959',9300.00,0.00,0.00,12.50,987.50,'2022-08-29 12:30:28','',''),(4078,'1','275','1',1,'Retail Sale Id 3960',2499.84,0.00,0.00,3.36,265.44,'2022-08-29 12:32:20','',''),(4079,'1','275','1',1,'Retail Sale Id 3960',3496.80,0.00,0.00,4.70,371.30,'2022-08-29 12:32:20','',''),(4080,'1','275','1',1,'Retail Sale Id 3961',996.96,0.00,0.00,1.34,105.86,'2022-08-29 12:33:38','',''),(4081,'1','275','1',1,'Retail Sale Id 3962',996.96,0.00,0.00,1.34,105.86,'2022-08-29 12:34:25','',''),(4082,'1','275','1',1,'Retail Sale Id 3963',2998.32,0.00,0.00,4.03,318.37,'2022-08-29 12:42:03','',''),(4083,'1','275','1',1,'Retail Sale Id 3963',9300.00,0.00,0.00,12.50,987.50,'2022-08-29 12:42:03','',''),(4084,'1','275','1',1,'Retail Sale Id 3964',18600.00,0.00,0.00,25.00,1975.00,'2022-08-29 12:46:10','',''),(4085,'1','275','1',1,'Retail Sale Id 3965',803.52,0.00,0.00,1.08,85.32,'2022-08-29 12:48:46','',''),(4086,'1','275','1',1,'Retail Sale Id 3966',17040.00,0.00,0.00,24.00,1080.00,'2022-08-29 12:54:43','',''),(4087,'1','275','1',1,'Retail Sale Id 3967',9300.00,0.00,0.00,12.50,987.50,'2022-08-29 13:01:03','',''),(4088,'1','275','1',1,'Retail Sale Id 3968',2298.96,0.00,0.00,3.09,244.11,'2022-08-29 13:05:47','',''),(4089,'1','275','1',1,'Retail Sale Id 3968',2998.32,0.00,0.00,4.03,318.37,'2022-08-29 13:05:47','',''),(4090,'1','275','1',1,'Retail Sale Id 3969',1502.88,0.00,0.00,2.02,159.58,'2022-08-29 13:11:25','',''),(4091,'1','275','1',1,'Retail Sale Id 3970',4501.20,0.00,0.00,6.05,477.95,'2022-08-29 13:22:27','',''),(4092,'1','275','1',1,'Retail Sale Id 3971',2298.96,0.00,0.00,3.09,244.11,'2022-08-29 13:23:27','',''),(4093,'1','275','1',1,'Retail Sale Id 3972',7440.00,0.00,0.00,10.00,790.00,'2022-08-29 13:25:45','',''),(4094,'1','275','1',1,'Retail Sale Id 3973',4501.20,0.00,0.00,6.05,477.95,'2022-08-29 13:31:45','',''),(4095,'1','275','1',1,'Retail Sale Id 3974',2298.96,0.00,0.00,3.09,244.11,'2022-08-29 13:37:03','',''),(4096,'1','275','1',1,'Retail Sale Id 3975',4501.20,0.00,0.00,6.05,477.95,'2022-08-29 13:40:01','',''),(4097,'1','275','1',1,'Retail Sale Id 3976',2998.32,0.00,0.00,4.03,318.37,'2022-08-29 13:49:34','',''),(4098,'1','275','1',1,'Retail Sale Id 3977',37200.00,0.00,0.00,50.00,3950.00,'2022-08-29 14:05:22','',''),(4099,'1','275','1',1,'Retail Sale Id 3978',3720.00,0.00,0.00,5.00,395.00,'2022-08-29 14:26:58','',''),(4100,'1','275','1',1,'Retail Sale Id 3979',9300.00,0.00,0.00,12.50,987.50,'2022-08-29 14:33:57','',''),(4101,'1','275','1',1,'Retail Sale Id 3980',18600.00,0.00,0.00,25.00,1975.00,'2022-08-29 14:35:53','',''),(4102,'1','275','1',1,'Retail Sale Id 3981',1502.88,0.00,0.00,2.02,159.58,'2022-08-29 14:36:48','',''),(4103,'1','275','1',1,'Retail Sale Id 3982',2998.32,0.00,0.00,4.03,318.37,'2022-08-29 14:38:24','',''),(4104,'1','275','1',1,'Retail Sale Id 3983',9300.00,0.00,0.00,12.50,987.50,'2022-08-29 14:39:11','',''),(4105,'1','275','1',1,'Retail Sale Id 3984',4999.68,0.00,0.00,6.72,530.88,'2022-08-29 14:39:53','',''),(4106,'1','275','1',1,'Retail Sale Id 3985',9300.00,0.00,0.00,12.50,987.50,'2022-08-29 14:44:25','',''),(4107,'1','275','1',1,'Retail Sale Id 3986',4501.20,0.00,0.00,6.05,477.95,'2022-08-29 14:46:16','',''),(4108,'1','275','1',1,'Retail Sale Id 3987',34080.00,0.00,0.00,48.00,2160.00,'2022-08-29 14:50:20','',''),(4109,'1','275','1',1,'Retail Sale Id 3988',8520.00,0.00,0.00,12.00,540.00,'2022-08-29 15:09:24','',''),(4110,'1','275','1',1,'Retail Sale Id 3989',14880.00,0.00,0.00,20.00,1580.00,'2022-08-29 15:11:33','',''),(4111,'1','275','1',1,'Retail Sale Id 3990',2298.96,0.00,0.00,3.09,244.11,'2022-08-29 15:15:34','',''),(4112,'1','275','1',1,'Retail Sale Id 3991',35500.00,0.00,0.00,50.00,2250.00,'2022-08-29 15:22:48','',''),(4113,'1','275','1',1,'Retail Sale Id 3992',2001.36,0.00,0.00,2.69,212.51,'2022-08-29 15:24:51','',''),(4114,'1','275','1',1,'Retail Sale Id 3993',37200.00,0.00,0.00,50.00,3950.00,'2022-08-29 15:35:42','',''),(4115,'1','275','1',1,'Retail Sale Id 3994',4501.20,0.00,0.00,6.05,477.95,'2022-08-29 15:38:48','',''),(4116,'1','275','1',1,'Retail Sale Id 3995',9300.00,0.00,0.00,12.50,987.50,'2022-08-29 15:55:31','',''),(4117,'1','275','1',1,'Retail Sale Id 3996',1502.88,0.00,0.00,2.02,159.58,'2022-08-29 16:03:51','',''),(4118,'1','275','1',1,'Retail Sale Id 3996',2001.36,0.00,0.00,2.69,212.51,'2022-08-29 16:03:51','',''),(4119,'1','275','1',1,'Retail Sale Id 3997',2298.96,0.00,0.00,3.09,244.11,'2022-08-29 16:15:19','',''),(4120,'1','275','1',1,'Retail Sale Id 3998',8184.00,0.00,0.00,11.00,869.00,'2022-08-29 16:27:01','',''),(4121,'1','275','1',1,'Retail Sale Id 3999',1502.88,0.00,0.00,2.02,159.58,'2022-08-29 16:45:13','',''),(4122,'1','275','1',1,'Retail Sale Id 4000',18600.00,0.00,0.00,25.00,1975.00,'2022-08-29 16:46:42','',''),(4123,'1','275','1',1,'Retail Sale Id 4001',4501.20,0.00,0.00,6.05,477.95,'2022-08-29 16:58:46','',''),(4124,'1','275','1',1,'Retail Sale Id 4002',71000.00,0.00,0.00,100.00,4500.00,'2022-08-29 17:08:32','',''),(4125,'1','275','1',1,'Retail Sale Id 4003',2001.36,0.00,0.00,2.69,212.51,'2022-08-29 17:15:46','',''),(4126,'1','275','1',1,'Retail Sale Id 4004',4501.20,0.00,0.00,6.05,477.95,'2022-08-29 17:16:49','',''),(4127,'1','275','1',1,'Retail Sale Id 4005',1502.88,0.00,0.00,2.02,159.58,'2022-08-29 17:18:19','',''),(4128,'1','275','1',1,'Retail Sale Id 4006',1502.88,0.00,0.00,2.02,159.58,'2022-08-29 17:24:20','',''),(4129,'1','275','1',1,'Retail Sale Id 4007',24999.10,0.00,0.00,35.21,1584.45,'2022-08-29 17:31:45','',''),(4130,'1','275','1',1,'Retail Sale Id 4008',13845.00,0.00,0.00,19.50,877.50,'2022-08-29 17:33:37','',''),(4131,'1','275','1',1,'Retail Sale Id 4009',9300.00,0.00,0.00,12.50,987.50,'2022-08-29 17:39:58','',''),(4132,'1','275','1',1,'Retail Sale Id 4010',9300.00,0.00,0.00,12.50,987.50,'2022-08-29 17:42:39','',''),(4133,'1','275','1',1,'Retail Sale Id 4011',996.96,0.00,0.00,1.34,105.86,'2022-08-29 17:46:47','',''),(4134,'1','275','1',1,'Retail Sale Id 4012',3720.00,0.00,0.00,5.00,395.00,'2022-08-29 17:59:25','',''),(4135,'1','275','1',1,'Retail Sale Id 4012',9300.00,0.00,0.00,12.50,987.50,'2022-08-29 17:59:25','',''),(4136,'1','275','1',1,'Retail Sale Id 4013',9300.00,0.00,0.00,12.50,987.50,'2022-08-29 18:01:18','',''),(4137,'1','275','1',1,'Retail Sale Id 4014',9300.00,0.00,0.00,12.50,987.50,'2022-08-29 18:03:40','',''),(4138,'1','275','1',1,'Retail Sale Id 4015',996.96,0.00,0.00,1.34,105.86,'2022-08-29 18:04:54','',''),(4139,'1','275','1',1,'Retail Sale Id 4015',1502.88,0.00,0.00,2.02,159.58,'2022-08-29 18:04:54','',''),(4140,'1','275','1',1,'Retail Sale Id 4016',1502.88,0.00,0.00,2.02,159.58,'2022-08-29 18:05:58','',''),(4141,'1','275','1',1,'Retail Sale Id 4017',1197.84,0.00,0.00,1.61,127.19,'2022-08-29 18:16:29','',''),(4142,'1','275','1',1,'Retail Sale Id 4018',2998.32,0.00,0.00,4.03,318.37,'2022-08-29 18:34:30','',''),(4143,'1','275','1',1,'Retail Sale Id 4018',2998.32,0.00,0.00,4.03,318.37,'2022-08-29 18:34:30','',''),(4144,'1','275','1',1,'Retail Sale Id 4019',996.96,0.00,0.00,1.34,105.86,'2022-08-29 18:39:35','',''),(4145,'1','275','1',1,'Retail Sale Id 4020',9300.00,0.00,0.00,12.50,987.50,'2022-08-29 18:46:43','',''),(4146,'1','275','1',1,'Retail Sale Id 4021',71000.00,0.00,0.00,100.00,4500.00,'2022-08-29 18:51:41','',''),(4147,'1','275','1',1,'Retail Sale Id 4022',14999.04,0.00,0.00,20.16,1592.64,'2022-08-29 18:55:22','',''),(4148,'1','275','1',1,'Retail Sale Id 4023',25560.00,0.00,0.00,36.00,1620.00,'2022-08-29 19:26:14','',''),(4149,'1','275','1',1,'Retail Sale Id 4024',3943.20,0.00,0.00,5.30,418.70,'2022-08-29 19:49:30','',''),(4150,'1','275','1',1,'Return of Retail Sale Id 4023',0.00,25560.00,36.00,0.00,-1620.00,'2022-08-29 19:52:10','',''),(4151,'1','275','1',1,'Retail Sale Id 4025',24984.90,0.00,0.00,35.19,1583.55,'2022-08-29 19:53:48','',''),(4152,'1','275','1',1,'Retail Sale Id 4026',9300.00,0.00,0.00,12.50,987.50,'2022-08-30 08:12:23','',''),(4153,'1','275','1',1,'Retail Sale Id 4027',9300.00,0.00,0.00,12.50,987.50,'2022-08-30 08:35:37','',''),(4154,'1','275','1',1,'Retail Sale Id 4028',9300.00,0.00,0.00,12.50,987.50,'2022-08-30 08:49:59','',''),(4155,'1','275','1',1,'Retail Sale Id 4029',106500.00,0.00,0.00,150.00,6750.00,'2022-08-30 08:56:12','',''),(4156,'1','275','1',1,'Retail Sale Id 4032',9300.00,0.00,0.00,12.50,987.50,'2022-08-30 09:09:56','',''),(4157,'1','275','1',1,'Retail Sale Id 4033',2001.36,0.00,0.00,2.69,212.51,'2022-08-30 09:11:15','',''),(4158,'1','275','1',1,'Retail Sale Id 4034',9300.00,0.00,0.00,12.50,987.50,'2022-08-30 09:12:24','',''),(4159,'1','275','1',1,'Retail Sale Id 4035',4999.68,0.00,0.00,6.72,530.88,'2022-08-30 09:15:36','',''),(4160,'1','275','1',1,'Retail Sale Id 4036',2998.32,0.00,0.00,4.03,318.37,'2022-08-30 09:22:50','',''),(4161,'1','275','1',1,'Retail Sale Id 4037',9300.00,0.00,0.00,12.50,987.50,'2022-08-30 09:27:34','',''),(4162,'1','275','1',1,'Retail Sale Id 4038',996.96,0.00,0.00,1.34,105.86,'2022-08-30 10:32:11','',''),(4163,'1','275','1',1,'Retail Sale Id 4039',996.96,0.00,0.00,1.34,105.86,'2022-08-30 10:33:29','',''),(4164,'1','275','1',1,'Retail Sale Id 4040',9300.00,0.00,0.00,12.50,987.50,'2022-08-30 10:38:51','',''),(4165,'1','275','1',1,'Retail Sale Id 4041',2001.36,0.00,0.00,2.69,212.51,'2022-08-30 10:40:33','',''),(4166,'1','275','1',1,'Retail Sale Id 4042',1502.88,0.00,0.00,2.02,159.58,'2022-08-30 10:42:28','',''),(4167,'1','275','1',1,'Retail Sale Id 4043',4501.20,0.00,0.00,6.05,477.95,'2022-08-30 12:05:54','',''),(4168,'1','275','1',1,'Retail Sale Id 4044',4999.68,0.00,0.00,6.72,530.88,'2022-08-30 12:31:25','',''),(4169,'1','275','1',1,'Retail Sale Id 4045',71000.00,0.00,0.00,100.00,4500.00,'2022-08-30 12:31:59','',''),(4170,'1','275','1',1,'Retail Sale Id 4046',1502.88,0.00,0.00,2.02,159.58,'2022-08-30 12:40:19','',''),(4171,'1','275','1',1,'Retail Sale Id 4047',9300.00,0.00,0.00,12.50,987.50,'2022-08-30 13:01:40','',''),(4172,'1','275','1',1,'Retail Sale Id 4049',9300.00,0.00,0.00,12.50,987.50,'2022-08-30 15:45:07','',''),(4173,'1','275','1',1,'Retail Sale Id 4048',9300.00,0.00,0.00,12.50,987.50,'2022-08-30 15:45:23','',''),(4174,'1','275','1',1,'Retail Sale Id 4030',9300.00,0.00,0.00,12.50,987.50,'2022-08-30 15:45:50','',''),(4175,'1','275','1',1,'Retail Sale Id 4031',9300.00,0.00,0.00,12.50,987.50,'2022-08-30 15:46:14','',''),(4176,'1','275','1',1,'Retail Sale Id 4050',7998.00,0.00,0.00,10.75,849.25,'2022-08-30 15:59:40','',''),(4177,'1','275','1',1,'Retail Sale Id 4051',2499.84,0.00,0.00,3.36,265.44,'2022-08-30 17:31:51','',''),(4178,'1','275','1',1,'Retail Sale Id 4052',5208.00,0.00,0.00,7.00,553.00,'2022-08-30 17:34:36','',''),(4179,'1','275','1',1,'Retail Sale Id 4053',4002.72,0.00,0.00,5.38,425.02,'2022-08-30 17:36:11','',''),(4180,'1','275','1',1,'Retail Sale Id 4054',4501.20,0.00,0.00,6.05,477.95,'2022-08-30 17:50:56','',''),(4181,'1','275','1',1,'Retail Sale Id 4055',2998.32,0.00,0.00,4.03,318.37,'2022-08-30 17:54:39','',''),(4182,'1','275','1',1,'Retail Sale Id 4056',9300.00,0.00,0.00,12.50,987.50,'2022-08-30 17:55:25','',''),(4183,'1','275','1',1,'Retail Sale Id 4057',9300.00,0.00,0.00,12.50,987.50,'2022-08-30 17:57:09','',''),(4184,'1','275','1',1,'Retail Sale Id 4058',9300.00,0.00,0.00,12.50,987.50,'2022-08-30 17:58:29','',''),(4185,'1','275','1',1,'Retail Sale Id 4059',1502.88,0.00,0.00,2.02,159.58,'2022-08-30 18:02:20','',''),(4186,'1','275','1',1,'Retail Sale Id 4060',2001.36,0.00,0.00,2.69,212.51,'2022-08-30 18:04:29','',''),(4187,'1','275','1',1,'Retail Sale Id 4061',2499.84,0.00,0.00,3.36,265.44,'2022-08-30 18:05:28','',''),(4188,'1','275','1',1,'Retail Sale Id 4062',4501.20,0.00,0.00,6.05,477.95,'2022-08-30 18:06:59','',''),(4189,'1','275','1',1,'Retail Sale Id 4063',9300.00,0.00,0.00,12.50,987.50,'2022-08-30 18:08:12','',''),(4190,'1','275','1',1,'Retail Sale Id 4064',2998.32,0.00,0.00,4.03,318.37,'2022-08-30 18:09:45','',''),(4191,'1','275','1',1,'Retail Sale Id 4065',996.96,0.00,0.00,1.34,105.86,'2022-08-30 18:18:02','',''),(4192,'1','275','1',1,'Retail Sale Id 4066',7998.00,0.00,0.00,10.75,849.25,'2022-08-30 18:22:49','',''),(4193,'1','275','1',1,'Retail Sale Id 4067',996.96,0.00,0.00,1.34,105.86,'2022-08-30 18:31:48','',''),(4194,'1','275','1',1,'Retail Sale Id 4068',8928.00,0.00,0.00,12.00,948.00,'2022-08-30 18:33:57','',''),(4195,'1','275','1',1,'Retail Sale Id 4069',2998.32,0.00,0.00,4.03,318.37,'2022-08-30 18:34:53','',''),(4196,'1','275','1',1,'Retail Sale Id 4070',23998.00,0.00,0.00,33.80,1521.00,'2022-08-30 18:39:24','',''),(4197,'1','275','1',1,'Retail Sale Id 4071',22996.90,0.00,0.00,32.39,1457.55,'2022-08-30 18:42:15','',''),(4198,'1','275','1',1,'Retail Sale Id 4073',3749.76,0.00,0.00,5.04,398.16,'2022-08-30 18:44:46','',''),(4199,'1','275','1',1,'Retail Sale Id 4074',9300.00,0.00,0.00,12.50,987.50,'2022-08-30 18:45:49','',''),(4200,'1','275','1',1,'Retail Sale Id 4075',4501.20,0.00,0.00,6.05,477.95,'2022-08-30 18:51:25','',''),(4201,'1','275','1',1,'Retail Sale Id 4076',1502.88,0.00,0.00,2.02,159.58,'2022-08-30 19:02:47','',''),(4202,'1','275','1',1,'Retail Sale Id 4077',111205.68,0.00,0.00,149.47,11808.13,'2022-08-30 19:32:44','',''),(4203,'1','275','1',1,'Retail Sale Id 4078',57708.80,0.00,0.00,81.28,3657.60,'2022-08-30 19:34:54','',''),(4204,'1','275','1',1,'Retail Sale Id 4079',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 07:32:23','',''),(4205,'1','275','1',1,'Retail Sale Id 4080',11904.00,0.00,0.00,16.00,1264.00,'2022-08-31 07:34:44','',''),(4206,'1','275','1',1,'Retail Sale Id 4081',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 07:36:45','',''),(4207,'1','275','1',1,'Retail Sale Id 4082',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 07:43:05','',''),(4208,'1','275','1',1,'Retail Sale Id 4083',7440.00,0.00,0.00,10.00,790.00,'2022-08-31 07:44:13','',''),(4209,'1','275','1',1,'Retail Sale Id 4084',4501.20,0.00,0.00,6.05,477.95,'2022-08-31 07:52:30','',''),(4210,'1','275','1',1,'Retail Sale Id 4085',18600.00,0.00,0.00,25.00,1975.00,'2022-08-31 07:53:46','',''),(4211,'1','275','1',1,'Retail Sale Id 4086',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 08:01:19','',''),(4212,'1','275','1',1,'Retail Sale Id 4087',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 08:15:21','',''),(4213,'1','275','1',1,'Retail Sale Id 4088',18600.00,0.00,0.00,25.00,1975.00,'2022-08-31 08:20:25','',''),(4214,'1','275','1',1,'Retail Sale Id 4089',2998.32,0.00,0.00,4.03,318.37,'2022-08-31 08:27:45','',''),(4215,'1','275','1',1,'Retail Sale Id 4090',2998.32,0.00,0.00,4.03,318.37,'2022-08-31 08:34:42','',''),(4216,'1','275','1',1,'Retail Sale Id 4091',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 08:38:24','',''),(4217,'1','275','1',1,'Retail Sale Id 4092',18600.00,0.00,0.00,25.00,1975.00,'2022-08-31 08:42:13','',''),(4218,'1','275','1',1,'Retail Sale Id 4093',996.96,0.00,0.00,1.34,105.86,'2022-08-31 08:44:42','',''),(4219,'1','275','1',1,'Retail Sale Id 4094',35500.00,0.00,0.00,50.00,2250.00,'2022-08-31 08:46:43','',''),(4220,'1','275','1',1,'Retail Sale Id 4095',4501.20,0.00,0.00,6.05,477.95,'2022-08-31 08:50:48','',''),(4221,'1','275','1',1,'Retail Sale Id 4096',2001.36,0.00,0.00,2.69,212.51,'2022-08-31 08:51:59','',''),(4222,'1','275','1',1,'Retail Sale Id 4097',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 09:12:19','',''),(4223,'1','275','1',1,'Retail Sale Id 4098',2298.96,0.00,0.00,3.09,244.11,'2022-08-31 09:13:47','',''),(4224,'1','275','1',1,'Retail Sale Id 4099',11160.00,0.00,0.00,15.00,1185.00,'2022-08-31 09:16:27','',''),(4225,'1','275','1',1,'Retail Sale Id 4100',34080.00,0.00,0.00,48.00,2160.00,'2022-08-31 09:27:24','',''),(4226,'1','275','1',1,'Retail Sale Id 4101',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 09:32:57','',''),(4227,'1','275','1',1,'Retail Sale Id 4102',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 10:26:24','',''),(4228,'1','275','1',1,'Retail Sale Id 4103',7998.00,0.00,0.00,10.75,849.25,'2022-08-31 10:27:21','',''),(4229,'1','275','1',1,'Retail Sale Id 4104',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 10:33:48','',''),(4230,'1','275','1',1,'Retail Sale Id 4105',21300.00,0.00,0.00,30.00,1350.00,'2022-08-31 10:51:27','',''),(4231,'1','275','1',1,'Retail Sale Id 4106',9996.80,0.00,0.00,14.08,633.60,'2022-08-31 11:21:29','',''),(4232,'1','275','1',1,'Retail Sale Id 4107',996.96,0.00,0.00,1.34,105.86,'2022-08-31 11:31:35','',''),(4233,'1','275','1',1,'Retail Sale Id 4108',14136.00,0.00,0.00,19.00,1501.00,'2022-08-31 12:25:31','',''),(4234,'1','275','1',1,'Retail Sale Id 4109',18600.00,0.00,0.00,25.00,1975.00,'2022-08-31 12:28:21','',''),(4235,'1','275','1',1,'Retail Sale Id 4110',7998.00,0.00,0.00,10.75,849.25,'2022-08-31 12:33:06','',''),(4236,'1','275','1',1,'Retail Sale Id 4111',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 12:37:09','',''),(4237,'1','275','1',1,'Retail Sale Id 4112',46150.00,0.00,0.00,65.00,2925.00,'2022-08-31 12:47:04','',''),(4238,'1','275','1',1,'Retail Sale Id 4113',4501.20,0.00,0.00,6.05,477.95,'2022-08-31 13:06:18','',''),(4239,'1','275','1',1,'Retail Sale Id 4114',4501.20,0.00,0.00,6.05,477.95,'2022-08-31 13:12:02','',''),(4240,'1','275','1',1,'Retail Sale Id 4115',2298.96,0.00,0.00,3.09,244.11,'2022-08-31 13:17:38','',''),(4241,'1','275','1',1,'Retail Sale Id 4115',2998.32,0.00,0.00,4.03,318.37,'2022-08-31 13:17:38','',''),(4242,'1','275','1',1,'Retail Sale Id 4116',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 13:25:37','',''),(4243,'1','275','1',1,'Retail Sale Id 4117',71000.00,0.00,0.00,100.00,4500.00,'2022-08-31 13:40:13','',''),(4244,'1','275','1',1,'Retail Sale Id 4118',2298.96,0.00,0.00,3.09,244.11,'2022-08-31 13:43:27','',''),(4245,'1','275','1',1,'Retail Sale Id 4119',1502.88,0.00,0.00,2.02,159.58,'2022-08-31 14:04:41','',''),(4246,'1','275','1',1,'Retail Sale Id 4120',2298.96,0.00,0.00,3.09,244.11,'2022-08-31 14:19:23','',''),(4247,'1','275','1',1,'Retail Sale Id 4121',4501.20,0.00,0.00,6.05,477.95,'2022-08-31 14:20:43','',''),(4248,'1','275','1',1,'Retail Sale Id 4122',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 14:34:52','',''),(4249,'1','275','1',1,'Retail Sale Id 4123',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 14:45:47','',''),(4250,'1','275','1',1,'Retail Sale Id 4124',2499.84,0.00,0.00,3.36,265.44,'2022-08-31 15:27:44','',''),(4251,'1','275','1',1,'Retail Sale Id 4125',1502.88,0.00,0.00,2.02,159.58,'2022-08-31 15:32:10','',''),(4252,'1','275','1',1,'Retail Sale Id 4126',2298.96,0.00,0.00,3.09,244.11,'2022-08-31 15:33:14','',''),(4253,'1','275','1',1,'Retail Sale Id 4127',12070.00,0.00,0.00,17.00,765.00,'2022-08-31 15:36:42','',''),(4254,'1','275','1',1,'Retail Sale Id 4128',4260.00,0.00,0.00,6.00,270.00,'2022-08-31 15:44:55','',''),(4255,'1','275','1',1,'Retail Sale Id 4129',2499.84,0.00,0.00,3.36,265.44,'2022-08-31 15:48:46','',''),(4256,'1','275','1',1,'Retail Sale Id 4130',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 15:55:00','',''),(4257,'1','275','1',1,'Retail Sale Id 4131',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 16:03:38','',''),(4258,'1','275','1',1,'Retail Sale Id 4132',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 16:49:25','',''),(4259,'1','275','1',1,'Retail Sale Id 4133',4501.20,0.00,0.00,6.05,477.95,'2022-08-31 16:58:18','',''),(4260,'1','275','1',1,'Retail Sale Id 4134',1502.88,0.00,0.00,2.02,159.58,'2022-08-31 16:59:43','',''),(4261,'1','275','1',1,'Retail Sale Id 4135',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 17:10:28','',''),(4262,'1','275','1',1,'Retail Sale Id 4136',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 17:12:48','',''),(4263,'1','275','1',1,'Retail Sale Id 4137',996.96,0.00,0.00,1.34,105.86,'2022-08-31 17:14:02','',''),(4264,'1','275','1',1,'Retail Sale Id 4138',2298.96,0.00,0.00,3.09,244.11,'2022-08-31 17:28:45','',''),(4265,'1','275','1',1,'Retail Sale Id 4139',2298.96,0.00,0.00,3.09,244.11,'2022-08-31 17:32:21','',''),(4266,'1','275','1',1,'Retail Sale Id 4140',18600.00,0.00,0.00,25.00,1975.00,'2022-08-31 17:38:03','',''),(4267,'1','275','1',1,'Retail Sale Id 4141',3720.00,0.00,0.00,5.00,395.00,'2022-08-31 17:42:27','',''),(4268,'1','275','1',1,'Retail Sale Id 4142',996.96,0.00,0.00,1.34,105.86,'2022-08-31 17:43:39','',''),(4269,'1','275','1',1,'Retail Sale Id 4143',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 17:44:49','',''),(4270,'1','275','1',1,'Retail Sale Id 4144',2298.96,0.00,0.00,3.09,244.11,'2022-08-31 17:46:17','',''),(4271,'1','275','1',1,'Retail Sale Id 4145',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 17:47:23','',''),(4272,'1','275','1',1,'Retail Sale Id 4146',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 17:48:57','',''),(4273,'1','275','1',1,'Retail Sale Id 4147',4002.72,0.00,0.00,5.38,425.02,'2022-08-31 17:59:47','',''),(4274,'1','275','1',1,'Retail Sale Id 4147',4002.72,0.00,0.00,5.38,425.02,'2022-08-31 17:59:47','',''),(4275,'1','275','1',1,'Retail Sale Id 4148',5996.64,0.00,0.00,8.06,636.74,'2022-08-31 18:00:58','',''),(4276,'1','275','1',1,'Retail Sale Id 4149',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 18:03:49','',''),(4277,'1','275','1',1,'Retail Sale Id 4150',26000.20,0.00,0.00,36.62,1647.90,'2022-08-31 18:05:33','',''),(4278,'1','275','1',1,'Retail Sale Id 4151',2298.96,0.00,0.00,3.09,244.11,'2022-08-31 18:07:54','',''),(4279,'1','275','1',1,'Retail Sale Id 4152',5996.64,0.00,0.00,8.06,636.74,'2022-08-31 18:08:55','',''),(4280,'1','275','1',1,'Retail Sale Id 4153',2298.96,0.00,0.00,3.09,244.11,'2022-08-31 18:11:53','',''),(4281,'1','275','1',1,'Retail Sale Id 4154',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 18:14:31','',''),(4282,'1','275','1',1,'Retail Sale Id 4155',33370.00,0.00,0.00,47.00,2115.00,'2022-08-31 18:19:46','',''),(4283,'1','275','1',1,'Retail Sale Id 4156',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 18:21:49','',''),(4284,'1','275','1',1,'Retail Sale Id 4157',2298.96,0.00,0.00,3.09,244.11,'2022-08-31 18:34:33','',''),(4285,'1','275','1',1,'Retail Sale Id 4158',14790.72,0.00,0.00,19.88,1570.52,'2022-08-31 18:52:50','',''),(4286,'1','275','1',1,'Retail Sale Id 4159',33015.00,0.00,0.00,46.50,2092.50,'2022-08-31 18:54:27','',''),(4287,'1','275','1',1,'Retail Sale Id 4160',11360.00,0.00,0.00,16.00,720.00,'2022-09-01 07:14:32','',''),(4288,'1','275','1',1,'Retail Sale Id 4161',9300.00,0.00,0.00,12.50,987.50,'2022-09-01 07:31:43','',''),(4289,'1','275','1',1,'Retail Sale Id 4162',14880.00,0.00,0.00,20.00,1580.00,'2022-09-01 07:52:41','',''),(4290,'1','275','1',1,'Retail Sale Id 4163',744.00,0.00,0.00,1.00,79.00,'2022-09-01 08:00:23','',''),(4291,'1','275','1',1,'Retail Sale Id 4163',8184.00,0.00,0.00,11.00,869.00,'2022-09-01 08:00:23','',''),(4292,'1','275','1',1,'Retail Sale Id 4164',2998.32,0.00,0.00,4.03,318.37,'2022-09-01 08:04:57','',''),(4293,'1','275','1',1,'Retail Sale Id 4166',3348.00,0.00,0.00,4.50,355.50,'2022-09-01 08:23:46','',''),(4294,'1','275','1',1,'Retail Sale Id 4166',11160.00,0.00,0.00,15.00,1185.00,'2022-09-01 08:23:46','',''),(4295,'1','275','1',1,'Retail Sale Id 4167',9300.00,0.00,0.00,12.50,987.50,'2022-09-01 08:26:18','',''),(4296,'1','275','1',1,'Retail Sale Id 4168',190280.00,0.00,0.00,268.00,12060.00,'2022-09-01 08:51:33','',''),(4297,'1','275','1',1,'Return of Retail Sale Id 4168',0.00,190280.00,268.00,0.00,-12060.00,'2022-09-01 09:25:27','',''),(4298,'1','275','1',1,'Retail Sale Id 4169',172011.70,0.00,0.00,242.27,10902.15,'2022-09-01 09:27:05','',''),(4299,'1','275','1',1,'Retail Sale Id 4170',26821.20,0.00,0.00,36.05,2847.95,'2022-09-01 09:28:51','',''),(4300,'1','275','1',1,'Distributed to OPPRETIONAL LOST  for sales id:15',87932.95,0.00,0.00,132.23,0.00,'2022-09-01 13:33:03','',''),(4301,'1','275',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3251850.00,4890.00,0.00,0.00,'2022-09-01 16:39:12','',''),(4302,'1','275',NULL,1,'Reception corrector for bridging 17',0.00,0.00,0.00,4890.00,0.00,'2022-09-01 16:40:07','',''),(4303,'1','275','1',1,'Received from bridging 17',0.00,0.00,4890.00,0.00,0.00,'2022-09-01 16:40:07','',''),(4304,'1','275','1',1,'Retail Sale Id 4171',7440.00,0.00,0.00,10.00,790.00,'2022-09-01 16:41:27','',''),(4305,'1','275','1',1,'Retail Sale Id 4172',9300.00,0.00,0.00,12.50,987.50,'2022-09-01 16:43:20','',''),(4306,'1','275','1',1,'Retail Sale Id 4173',14880.00,0.00,0.00,20.00,1580.00,'2022-09-01 17:00:43','',''),(4307,'1','275','1',1,'Retail Sale Id 4174',8184.00,0.00,0.00,11.00,869.00,'2022-09-01 17:06:02','',''),(4308,'1','275','1',1,'Retail Sale Id 4175',9300.00,0.00,0.00,12.50,987.50,'2022-09-01 17:07:21','',''),(4309,'1','275','1',1,'Retail Sale Id 4177',9300.00,0.00,0.00,12.50,987.50,'2022-09-01 17:28:12','',''),(4310,'1','275','1',1,'Retail Sale Id 4178',2298.96,0.00,0.00,3.09,244.11,'2022-09-01 17:34:08','',''),(4311,'1','275','1',1,'Retail Sale Id 4179',9300.00,0.00,0.00,12.50,987.50,'2022-09-01 17:37:18','',''),(4312,'1','275','1',1,'Retail Sale Id 4180',142000.00,0.00,0.00,200.00,9000.00,'2022-09-01 17:49:39','',''),(4313,'1','275','1',1,'Retail Sale Id 4181',4002.72,0.00,0.00,5.38,425.02,'2022-09-01 17:56:03','',''),(4314,'1','275','1',1,'Retail Sale Id 4182',71000.00,0.00,0.00,100.00,4500.00,'2022-09-01 17:58:40','',''),(4315,'1','275','1',1,'Retail Sale Id 4183',4501.20,0.00,0.00,6.05,477.95,'2022-09-01 18:08:47','',''),(4316,'1','275','1',1,'Retail Sale Id 4184',2298.96,0.00,0.00,3.09,244.11,'2022-09-01 18:10:06','',''),(4317,'1','275','1',1,'Retail Sale Id 4185',9300.00,0.00,0.00,12.50,987.50,'2022-09-01 18:11:37','',''),(4318,'1','275','1',1,'Retail Sale Id 4186',1502.88,0.00,0.00,2.02,159.58,'2022-09-01 18:12:36','',''),(4319,'1','275','1',1,'Retail Sale Id 4187',2001.36,0.00,0.00,2.69,212.51,'2022-09-01 18:17:40','',''),(4320,'1','275','1',1,'Retail Sale Id 4188',9300.00,0.00,0.00,12.50,987.50,'2022-09-01 18:22:27','',''),(4321,'1','275','1',1,'Retail Sale Id 4189',2998.32,0.00,0.00,4.03,318.37,'2022-09-01 18:27:30','',''),(4322,'1','275','1',1,'Retail Sale Id 4190',9300.00,0.00,0.00,12.50,987.50,'2022-09-01 18:28:42','',''),(4323,'1','275','1',1,'Retail Sale Id 4191',2001.36,0.00,0.00,2.69,212.51,'2022-09-01 18:35:55','',''),(4324,'1','275','1',1,'Retail Sale Id 4192',7998.00,0.00,0.00,10.75,849.25,'2022-09-01 18:36:52','',''),(4325,'1','275','1',1,'Retail Sale Id 4193',2001.36,0.00,0.00,2.69,212.51,'2022-09-01 18:48:07','',''),(4326,'1','275','1',1,'Retail Sale Id 4194',4501.20,0.00,0.00,6.05,477.95,'2022-09-01 18:51:21','',''),(4327,'1','275','1',1,'Retail Sale Id 4195',3720.00,0.00,0.00,5.00,395.00,'2022-09-01 18:56:58','',''),(4328,'1','275','1',1,'Retail Sale Id 4196',996.96,0.00,0.00,1.34,105.86,'2022-09-01 18:58:21','',''),(4329,'1','275','1',1,'Retail Sale Id 4197',104494.80,0.00,0.00,140.45,11095.55,'2022-09-01 19:28:06','',''),(4330,'1','275','1',1,'Retail Sale Id 4198',2298.96,0.00,0.00,3.09,244.11,'2022-09-02 07:10:19','',''),(4331,'1','275','1',1,'Retail Sale Id 4199',9300.00,0.00,0.00,12.50,987.50,'2022-09-02 07:53:13','',''),(4332,'1','275','1',1,'Retail Sale Id 4200',9300.00,0.00,0.00,12.50,987.50,'2022-09-02 07:56:06','',''),(4333,'1','275','1',1,'Retail Sale Id 4201',2998.32,0.00,0.00,4.03,318.37,'2022-09-02 08:13:55','',''),(4334,'1','275','1',1,'Retail Sale Id 4202',18600.00,0.00,0.00,25.00,1975.00,'2022-09-02 08:20:12','',''),(4335,'1','275','1',1,'Retail Sale Id 4203',2998.32,0.00,0.00,4.03,318.37,'2022-09-02 08:21:00','',''),(4336,'1','275','1',1,'Retail Sale Id 4205',9300.00,0.00,0.00,12.50,987.50,'2022-09-02 08:32:44','',''),(4337,'1','275','1',1,'Retail Sale Id 4206',3720.00,0.00,0.00,5.00,395.00,'2022-09-02 08:45:15','',''),(4338,'1','275','1',1,'Retail Sale Id 4206',9300.00,0.00,0.00,12.50,987.50,'2022-09-02 08:45:15','',''),(4339,'1','275','1',1,'Retail Sale Id 4207',9300.00,0.00,0.00,12.50,987.50,'2022-09-02 08:48:08','',''),(4340,'1','275','1',1,'Retail Sale Id 4208',2001.36,0.00,0.00,2.69,212.51,'2022-09-02 08:54:29','',''),(4341,'1','275','1',1,'Retail Sale Id 4209',3496.80,0.00,0.00,4.70,371.30,'2022-09-02 08:59:17','',''),(4342,'1','275','1',1,'Retail Sale Id 4210',9300.00,0.00,0.00,12.50,987.50,'2022-09-02 09:02:40','',''),(4343,'1','275','1',1,'Retail Sale Id 4211',8184.00,0.00,0.00,11.00,869.00,'2022-09-02 09:05:01','',''),(4344,'1','275','1',1,'Retail Sale Id 4211',8184.00,0.00,0.00,11.00,869.00,'2022-09-02 09:05:01','',''),(4345,'1','275','1',1,'Retail Sale Id 4212',35500.00,0.00,0.00,50.00,2250.00,'2022-09-02 09:14:13','',''),(4346,'1','275','1',1,'Retail Sale Id 4213',2998.32,0.00,0.00,4.03,318.37,'2022-09-02 09:16:07','',''),(4347,'1','275','1',1,'Retail Sale Id 4213',9300.00,0.00,0.00,12.50,987.50,'2022-09-02 09:16:07','',''),(4348,'1','275','1',1,'Retail Sale Id 4214',9300.00,0.00,0.00,12.50,987.50,'2022-09-02 09:17:55','',''),(4349,'1','275','1',1,'Retail Sale Id 4215',2298.96,0.00,0.00,3.09,244.11,'2022-09-02 09:19:43','',''),(4350,'1','275','1',1,'Retail Sale Id 4216',9300.00,0.00,0.00,12.50,987.50,'2022-09-02 09:21:24','',''),(4351,'1','275','1',1,'Retail Sale Id 4217',2001.36,0.00,0.00,2.69,212.51,'2022-09-02 09:24:39','',''),(4352,'1','275','1',1,'Retail Sale Id 4219',19998.72,0.00,0.00,26.88,2123.52,'2022-09-02 09:27:28','',''),(4353,'1','275','1',1,'Retail Sale Id 4220',7998.00,0.00,0.00,10.75,849.25,'2022-09-02 09:28:33','',''),(4354,'1','275','1',1,'Retail Sale Id 4221',9300.00,0.00,0.00,12.50,987.50,'2022-09-02 09:36:18','',''),(4355,'1','275','1',1,'Retail Sale Id 4222',71000.00,0.00,0.00,100.00,4500.00,'2022-09-02 09:39:28','',''),(4356,'1','275','1',1,'Retail Sale Id 4223',17750.00,0.00,0.00,25.00,1125.00,'2022-09-02 09:41:59','',''),(4357,'1','275','1',1,'Retail Sale Id 4224',996.96,0.00,0.00,1.34,105.86,'2022-09-02 09:45:37','',''),(4358,'1','275','1',1,'Retail Sale Id 4225',2001.36,0.00,0.00,2.69,212.51,'2022-09-02 09:46:26','',''),(4359,'1','275','1',1,'Retail Sale Id 4226',2298.96,0.00,0.00,3.09,244.11,'2022-09-02 09:51:49','',''),(4360,'1','275','1',1,'Retail Sale Id 4227',4501.20,0.00,0.00,6.05,477.95,'2022-09-02 09:54:36','',''),(4361,'1','275','1',1,'Retail Sale Id 4228',0.00,0.00,0.00,0.00,0.00,'2022-09-02 10:48:00','',''),(4362,'1','275','1',1,'Retail Sale Id 4229',35500.00,0.00,0.00,50.00,2250.00,'2022-09-02 10:58:55','',''),(4363,'1','275','1',1,'Retail Sale Id 4230',2499.84,0.00,0.00,3.36,265.44,'2022-09-02 11:18:57','',''),(4364,'1','275','1',1,'Retail Sale Id 4231',9300.00,0.00,0.00,12.50,987.50,'2022-09-02 11:20:59','',''),(4365,'1','275','1',1,'Retail Sale Id 4232',2001.36,0.00,0.00,2.69,212.51,'2022-09-02 11:49:44','',''),(4366,'1','275','1',1,'Retail Sale Id 4233',7440.00,0.00,0.00,10.00,790.00,'2022-09-02 12:01:43','',''),(4367,'1','275','1',1,'Retail Sale Id 4234',16003.44,0.00,0.00,21.51,1699.29,'2022-09-02 12:02:31','',''),(4368,'1','275','1',1,'Retail Sale Id 4235',4999.68,0.00,0.00,6.72,530.88,'2022-09-02 12:07:05','',''),(4369,'1','275','1',1,'Retail Sale Id 4236',3199.20,0.00,0.00,4.30,339.70,'2022-09-02 12:22:15','',''),(4370,'1','275','1',1,'Retail Sale Id 4237',4002.72,0.00,0.00,5.38,425.02,'2022-09-02 12:24:49','',''),(4371,'1','275','1',1,'Retail Sale Id 4238',9300.00,0.00,0.00,12.50,987.50,'2022-09-02 12:28:39','',''),(4372,'1','275','1',1,'Retail Sale Id 4239',2298.96,0.00,0.00,3.09,244.11,'2022-09-02 12:35:59','',''),(4373,'1','275','1',1,'Retail Sale Id 4240',27335.00,0.00,0.00,38.50,1732.50,'2022-09-02 12:42:53','',''),(4374,'1','275','1',1,'Retail Sale Id 4241',1502.88,0.00,0.00,2.02,159.58,'2022-09-02 12:43:33','',''),(4375,'1','275','1',1,'Retail Sale Id 4242',37200.00,0.00,0.00,50.00,3950.00,'2022-09-02 13:31:38','',''),(4376,'1','275','1',1,'Retail Sale Id 4243',9300.00,0.00,0.00,12.50,987.50,'2022-09-02 14:39:06','',''),(4377,'1','275','1',1,'Retail Sale Id 4244',4501.20,0.00,0.00,6.05,477.95,'2022-09-02 14:52:32','',''),(4378,'1','275','1',1,'Retail Sale Id 4245',22010.00,0.00,0.00,31.00,1395.00,'2022-09-02 14:54:40','',''),(4379,'1','275','1',1,'Retail Sale Id 4246',9300.00,0.00,0.00,12.50,987.50,'2022-09-02 15:00:40','',''),(4380,'1','275','1',1,'Retail Sale Id 4247',2298.96,0.00,0.00,3.09,244.11,'2022-09-02 15:01:18','',''),(4381,'1','275','1',1,'Retail Sale Id 4248',1502.88,0.00,0.00,2.02,159.58,'2022-09-02 15:30:16','',''),(4382,'1','275','1',1,'Retail Sale Id 4249',4501.20,0.00,0.00,6.05,477.95,'2022-09-02 15:52:51','',''),(4383,'1','275','1',1,'Retail Sale Id 4250',2298.96,0.00,0.00,3.09,244.11,'2022-09-02 15:56:50','',''),(4384,'1','275','1',1,'Retail Sale Id 4250',27900.00,0.00,0.00,37.50,2962.50,'2022-09-02 15:56:50','',''),(4385,'1','275','1',1,'Retail Sale Id 4251',3720.00,0.00,0.00,5.00,395.00,'2022-09-02 16:07:38','',''),(4386,'1','275','1',1,'Retail Sale Id 4252',1502.88,0.00,0.00,2.02,159.58,'2022-09-02 16:08:38','',''),(4387,'1','275','1',1,'Retail Sale Id 4253',996.96,0.00,0.00,1.34,105.86,'2022-09-02 16:15:40','',''),(4388,'1','275','1',1,'Retail Sale Id 4254',5996.64,0.00,0.00,8.06,636.74,'2022-09-02 16:18:15','',''),(4389,'1','275','1',1,'Retail Sale Id 4255',1502.88,0.00,0.00,2.02,159.58,'2022-09-02 16:50:50','',''),(4390,'1','275','1',1,'Retail Sale Id 4256',996.96,0.00,0.00,1.34,105.86,'2022-09-02 16:58:00','',''),(4391,'1','275','1',1,'Retail Sale Id 4257',2298.96,0.00,0.00,3.09,244.11,'2022-09-02 17:08:46','',''),(4392,'1','275','1',1,'Retail Sale Id 4258',2298.96,0.00,0.00,3.09,244.11,'2022-09-02 17:09:53','',''),(4393,'1','275','1',1,'Retail Sale Id 4259',9300.00,0.00,0.00,12.50,987.50,'2022-09-02 17:24:47','',''),(4394,'1','275','1',1,'Retail Sale Id 4260',9300.00,0.00,0.00,12.50,987.50,'2022-09-02 17:28:50','',''),(4395,'1','275','1',1,'Retail Sale Id 4261',9300.00,0.00,0.00,12.50,987.50,'2022-09-02 17:30:15','',''),(4396,'1','275','1',1,'Retail Sale Id 4262',37200.00,0.00,0.00,50.00,3950.00,'2022-09-02 17:33:08','',''),(4397,'1','275','1',1,'Retail Sale Id 4263',4999.68,0.00,0.00,6.72,530.88,'2022-09-02 17:34:18','',''),(4398,'1','275','1',1,'Retail Sale Id 4264',2202.24,0.00,0.00,2.96,233.84,'2022-09-02 17:37:06','',''),(4399,'1','275','1',1,'Retail Sale Id 4265',18600.00,0.00,0.00,25.00,1975.00,'2022-09-02 17:43:02','',''),(4400,'1','275','1',1,'Retail Sale Id 4266',11999.00,0.00,0.00,16.90,760.50,'2022-09-02 17:47:08','',''),(4401,'1','275','1',1,'Retail Sale Id 4267',4002.72,0.00,0.00,5.38,425.02,'2022-09-02 17:48:32','',''),(4402,'1','275','1',1,'Retail Sale Id 4267',4002.72,0.00,0.00,5.38,425.02,'2022-09-02 17:48:32','',''),(4403,'1','275','1',1,'Retail Sale Id 4268',1153.20,0.00,0.00,1.55,122.45,'2022-09-02 17:51:31','',''),(4404,'1','275','1',1,'Retail Sale Id 4269',1502.88,0.00,0.00,2.02,159.58,'2022-09-02 17:53:56','',''),(4405,'1','275','1',1,'Retail Sale Id 4270',2298.96,0.00,0.00,3.09,244.11,'2022-09-02 17:55:29','',''),(4406,'1','275','1',1,'Retail Sale Id 4271',2499.84,0.00,0.00,3.36,265.44,'2022-09-02 17:56:27','',''),(4407,'1','275','1',1,'Retail Sale Id 4272',1502.88,0.00,0.00,2.02,159.58,'2022-09-02 17:57:20','',''),(4408,'1','275','1',1,'Retail Sale Id 4273',2298.96,0.00,0.00,3.09,244.11,'2022-09-02 18:00:55','',''),(4409,'1','275','1',1,'Retail Sale Id 4274',4464.00,0.00,0.00,6.00,474.00,'2022-09-02 18:07:28','',''),(4410,'1','275','1',1,'Retail Sale Id 4274',9300.00,0.00,0.00,12.50,987.50,'2022-09-02 18:07:28','',''),(4411,'1','275','1',1,'Retail Sale Id 4275',2998.32,0.00,0.00,4.03,318.37,'2022-09-02 18:08:39','',''),(4412,'1','275','1',1,'Retail Sale Id 4276',9300.00,0.00,0.00,12.50,987.50,'2022-09-02 18:09:50','',''),(4413,'1','275','1',1,'Retail Sale Id 4277',9300.00,0.00,0.00,12.50,987.50,'2022-09-02 18:11:54','',''),(4414,'1','275','1',1,'Retail Sale Id 4278',3720.00,0.00,0.00,5.00,395.00,'2022-09-02 18:19:15','',''),(4415,'1','275','1',1,'Retail Sale Id 4279',9300.00,0.00,0.00,12.50,987.50,'2022-09-02 18:22:10','',''),(4416,'1','275','1',1,'Retail Sale Id 4280',42600.00,0.00,0.00,60.00,2700.00,'2022-09-02 18:23:48','',''),(4417,'1','275','1',1,'Retail Sale Id 4281',9300.00,0.00,0.00,12.50,987.50,'2022-09-02 18:25:45','',''),(4418,'1','275','1',1,'Retail Sale Id 4282',4501.20,0.00,0.00,6.05,477.95,'2022-09-02 18:32:19','',''),(4419,'1','275','1',1,'Retail Sale Id 4283',2298.96,0.00,0.00,3.09,244.11,'2022-09-02 18:37:55','',''),(4420,'1','275','1',1,'Retail Sale Id 4284',14999.04,0.00,0.00,20.16,1592.64,'2022-09-02 18:39:20','',''),(4421,'1','275','1',1,'Retail Sale Id 4285',7998.00,0.00,0.00,10.75,849.25,'2022-09-02 18:43:24','',''),(4422,'1','275','1',1,'Retail Sale Id 4286',5999.50,0.00,0.00,8.45,380.25,'2022-09-02 19:21:19','',''),(4423,'1','275','1',1,'Retail Sale Id 4287',6941.52,0.00,0.00,9.33,737.07,'2022-09-02 19:21:57','',''),(4424,'1','275','1',1,'Retail Sale Id 4288',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 07:01:24','',''),(4425,'1','275','1',1,'Retail Sale Id 4289',7440.00,0.00,0.00,10.00,790.00,'2022-09-03 07:40:01','',''),(4426,'1','275','1',1,'Retail Sale Id 4290',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 07:50:53','',''),(4427,'1','275','1',1,'Retail Sale Id 4291',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 08:01:27','',''),(4428,'1','275','1',1,'Retail Sale Id 4292',2001.36,0.00,0.00,2.69,212.51,'2022-09-03 08:10:58','',''),(4429,'1','275','1',1,'Retail Sale Id 4293',4501.20,0.00,0.00,6.05,477.95,'2022-09-03 08:13:34','',''),(4430,'1','275','1',1,'Retail Sale Id 4294',8184.00,0.00,0.00,11.00,869.00,'2022-09-03 08:24:39','',''),(4431,'1','275','1',1,'Retail Sale Id 4295',3720.00,0.00,0.00,5.00,395.00,'2022-09-03 08:29:26','',''),(4432,'1','275','1',1,'Retail Sale Id 4296',4501.20,0.00,0.00,6.05,477.95,'2022-09-03 08:46:35','',''),(4433,'1','275','1',1,'Retail Sale Id 4297',2298.96,0.00,0.00,3.09,244.11,'2022-09-03 08:47:51','',''),(4434,'1','275','1',1,'Retail Sale Id 4298',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 08:49:05','',''),(4435,'1','275','1',1,'Retail Sale Id 4299',751.44,0.00,0.00,1.01,79.79,'2022-09-03 08:54:12','',''),(4436,'1','275','1',1,'Retail Sale Id 4299',751.44,0.00,0.00,1.01,79.79,'2022-09-03 08:54:12','',''),(4437,'1','275','1',1,'Retail Sale Id 4300',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 08:59:35','',''),(4438,'1','275','1',1,'Retail Sale Id 4301',2298.96,0.00,0.00,3.09,244.11,'2022-09-03 09:04:13','',''),(4439,'1','275','1',1,'Retail Sale Id 4302',1502.88,0.00,0.00,2.02,159.58,'2022-09-03 09:07:19','',''),(4440,'1','275','1',1,'Retail Sale Id 4303',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 09:18:18','',''),(4441,'1','275','1',1,'Retail Sale Id 4304',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 09:27:25','',''),(4442,'1','275','1',1,'Retail Sale Id 4305',10416.00,0.00,0.00,14.00,1106.00,'2022-09-03 09:29:38','',''),(4443,'1','275','1',1,'Retail Sale Id 4306',4501.20,0.00,0.00,6.05,477.95,'2022-09-03 09:37:47','',''),(4444,'1','275','1',1,'Retail Sale Id 4307',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 09:41:27','',''),(4445,'1','275','1',1,'Retail Sale Id 4308',4501.20,0.00,0.00,6.05,477.95,'2022-09-03 09:42:31','',''),(4446,'1','275','1',1,'Retail Sale Id 4309',35500.00,0.00,0.00,50.00,2250.00,'2022-09-03 09:44:52','',''),(4447,'1','275','1',1,'Retail Sale Id 4310',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 09:46:34','',''),(4448,'1','275','1',1,'Retail Sale Id 4311',2998.32,0.00,0.00,4.03,318.37,'2022-09-03 09:47:42','',''),(4449,'1','275','1',1,'Retail Sale Id 4312',4501.20,0.00,0.00,6.05,477.95,'2022-09-03 09:50:45','',''),(4450,'1','275','1',1,'Retail Sale Id 4313',2298.96,0.00,0.00,3.09,244.11,'2022-09-03 09:57:43','',''),(4451,'1','275','1',1,'Retail Sale Id 4314',2298.96,0.00,0.00,3.09,244.11,'2022-09-03 10:05:42','',''),(4452,'1','275','1',1,'Retail Sale Id 4315',1502.88,0.00,0.00,2.02,159.58,'2022-09-03 10:08:38','',''),(4453,'1','275','1',1,'Retail Sale Id 4316',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 10:14:33','',''),(4454,'1','275','1',1,'Retail Sale Id 4317',4501.20,0.00,0.00,6.05,477.95,'2022-09-03 10:15:33','',''),(4455,'1','275','1',1,'Retail Sale Id 4318',996.96,0.00,0.00,1.34,105.86,'2022-09-03 10:16:27','',''),(4456,'1','275','1',1,'Retail Sale Id 4319',4501.20,0.00,0.00,6.05,477.95,'2022-09-03 10:25:46','',''),(4457,'1','275','1',1,'Retail Sale Id 4320',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 10:32:56','',''),(4458,'1','275','1',1,'Retail Sale Id 4321',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 10:33:57','',''),(4459,'1','275','1',1,'Retail Sale Id 4322',4999.68,0.00,0.00,6.72,530.88,'2022-09-03 10:35:02','',''),(4460,'1','275','1',1,'Retail Sale Id 4323',4501.20,0.00,0.00,6.05,477.95,'2022-09-03 10:36:01','',''),(4461,'1','275','1',1,'Retail Sale Id 4324',1502.88,0.00,0.00,2.02,159.58,'2022-09-03 10:53:23','',''),(4462,'1','275','1',1,'Retail Sale Id 4325',3720.00,0.00,0.00,5.00,395.00,'2022-09-03 10:54:59','',''),(4463,'1','275','1',1,'Retail Sale Id 4326',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 11:06:51','',''),(4464,'1','275','1',1,'Retail Sale Id 4327',2001.36,0.00,0.00,2.69,212.51,'2022-09-03 11:09:20','',''),(4465,'1','275','1',1,'Retail Sale Id 4328',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 11:25:27','',''),(4466,'1','275','1',1,'Retail Sale Id 4329',3496.80,0.00,0.00,4.70,371.30,'2022-09-03 11:28:27','',''),(4467,'1','275','1',1,'Retail Sale Id 4329',7499.52,0.00,0.00,10.08,796.32,'2022-09-03 11:28:27','',''),(4468,'1','275','1',1,'Retail Sale Id 4330',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 11:42:10','',''),(4469,'1','275','1',1,'Retail Sale Id 4331',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 11:45:21','',''),(4470,'1','275','1',1,'Retail Sale Id 4332',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 11:59:29','',''),(4471,'1','275','1',1,'Retail Sale Id 4333',18600.00,0.00,0.00,25.00,1975.00,'2022-09-03 12:00:36','',''),(4472,'1','275','1',1,'Retail Sale Id 4334',2001.36,0.00,0.00,2.69,212.51,'2022-09-03 12:04:50','',''),(4473,'1','275','1',1,'Retail Sale Id 4335',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 12:08:46','',''),(4474,'1','275','1',1,'Retail Sale Id 4336',2001.36,0.00,0.00,2.69,212.51,'2022-09-03 12:19:23','',''),(4475,'1','275','1',1,'Retail Sale Id 4337',12070.00,0.00,0.00,17.00,765.00,'2022-09-03 12:22:17','',''),(4476,'1','275','1',1,'Retail Sale Id 4338',2298.96,0.00,0.00,3.09,244.11,'2022-09-03 12:26:01','',''),(4477,'1','275','1',1,'Retail Sale Id 4339',2001.36,0.00,0.00,2.69,212.51,'2022-09-03 12:27:54','',''),(4478,'1','275','1',1,'Retail Sale Id 4340',35500.00,0.00,0.00,50.00,2250.00,'2022-09-03 12:34:54','',''),(4479,'1','275','1',1,'Retail Sale Id 4341',4501.20,0.00,0.00,6.05,477.95,'2022-09-03 12:38:03','',''),(4480,'1','275','1',1,'Retail Sale Id 4342',14880.00,0.00,0.00,20.00,1580.00,'2022-09-03 12:45:35','',''),(4481,'1','275','1',1,'Retail Sale Id 4343',2998.32,0.00,0.00,4.03,318.37,'2022-09-03 12:50:15','',''),(4482,'1','275','1',1,'Retail Sale Id 4344',2298.96,0.00,0.00,3.09,244.11,'2022-09-03 13:08:22','',''),(4483,'1','275','1',1,'Retail Sale Id 4345',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 13:11:56','',''),(4484,'1','275','1',1,'Retail Sale Id 4346',190280.00,0.00,0.00,268.00,12060.00,'2022-09-03 13:19:36','',''),(4485,'1','275','1',1,'Retail Sale Id 4347',2298.96,0.00,0.00,3.09,244.11,'2022-09-03 13:20:22','',''),(4486,'1','275','1',1,'Retail Sale Id 4348',4501.20,0.00,0.00,6.05,477.95,'2022-09-03 13:26:35','',''),(4487,'1','275','1',1,'Retail Sale Id 4349',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 13:27:34','',''),(4488,'1','275','1',1,'Retail Sale Id 4350',3720.00,0.00,0.00,5.00,395.00,'2022-09-03 13:29:15','',''),(4489,'1','275','1',1,'Retail Sale Id 4351',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 13:37:22','',''),(4490,'1','275','1',1,'Retail Sale Id 4352',16330.00,0.00,0.00,23.00,1035.00,'2022-09-03 13:39:29','',''),(4491,'1','275','1',1,'Retail Sale Id 4353',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 13:43:08','',''),(4492,'1','275','1',1,'Retail Sale Id 4354',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 15:15:52','',''),(4493,'1','275','1',1,'Retail Sale Id 4355',4002.72,0.00,0.00,5.38,425.02,'2022-09-03 15:16:58','',''),(4494,'1','275','1',1,'Retail Sale Id 4356',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 15:21:19','',''),(4495,'1','275','1',1,'Retail Sale Id 4357',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 15:26:43','',''),(4496,'1','275','1',1,'Retail Sale Id 4358',2998.32,0.00,0.00,4.03,318.37,'2022-09-03 15:27:54','',''),(4497,'1','275','1',1,'Retail Sale Id 4359',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 15:33:16','',''),(4498,'1','275','1',1,'Retail Sale Id 4360',2298.96,0.00,0.00,3.09,244.11,'2022-09-03 15:34:04','',''),(4499,'1','275','1',1,'Retail Sale Id 4361',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 15:41:54','',''),(4500,'1','275','1',1,'Retail Sale Id 4362',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 15:54:28','',''),(4501,'1','275','1',1,'Retail Sale Id 4363',37200.00,0.00,0.00,50.00,3950.00,'2022-09-03 15:57:51','',''),(4502,'1','275','1',1,'Retail Sale Id 4364',1502.88,0.00,0.00,2.02,159.58,'2022-09-03 16:04:22','',''),(4503,'1','275','1',1,'Retail Sale Id 4365',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 16:11:29','',''),(4504,'1','275','1',1,'Retail Sale Id 4366',996.96,0.00,0.00,1.34,105.86,'2022-09-03 16:16:49','',''),(4505,'1','275','1',1,'Retail Sale Id 4367',35500.00,0.00,0.00,50.00,2250.00,'2022-09-03 16:22:42','',''),(4506,'1','275','1',1,'Retail Sale Id 4368',4999.68,0.00,0.00,6.72,530.88,'2022-09-03 16:24:16','',''),(4507,'1','275','1',1,'Retail Sale Id 4369',7998.00,0.00,0.00,10.75,849.25,'2022-09-03 16:29:52','',''),(4508,'1','275','1',1,'Retail Sale Id 4370',4999.68,0.00,0.00,6.72,530.88,'2022-09-03 16:33:29','',''),(4509,'1','275','1',1,'Retail Sale Id 4371',18600.00,0.00,0.00,25.00,1975.00,'2022-09-03 16:35:43','',''),(4510,'1','275','1',1,'Retail Sale Id 4372',7001.04,0.00,0.00,9.41,743.39,'2022-09-03 16:39:50','',''),(4511,'1','275','1',1,'Retail Sale Id 4373',4501.20,0.00,0.00,6.05,477.95,'2022-09-03 16:45:23','',''),(4512,'1','275','1',1,'Retail Sale Id 4375',33000.80,0.00,0.00,46.48,2091.60,'2022-09-03 17:06:26','',''),(4513,'1','275','1',1,'Retail Sale Id 4376',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 17:10:58','',''),(4514,'1','275','1',1,'Retail Sale Id 4377',4501.20,0.00,0.00,6.05,477.95,'2022-09-03 17:17:51','',''),(4515,'1','275','1',1,'Retail Sale Id 4378',2001.36,0.00,0.00,2.69,212.51,'2022-09-03 17:18:44','',''),(4516,'1','275','1',1,'Retail Sale Id 4379',996.96,0.00,0.00,1.34,105.86,'2022-09-03 17:23:28','',''),(4517,'1','275','1',1,'Retail Sale Id 4380',2298.96,0.00,0.00,3.09,244.11,'2022-09-03 17:24:41','',''),(4518,'1','275','1',1,'Retail Sale Id 4381',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 17:36:56','',''),(4519,'1','275','1',1,'Retail Sale Id 4382',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 17:40:18','',''),(4520,'1','275','1',1,'Retail Sale Id 4383',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 17:42:45','',''),(4521,'1','275','1',1,'Retail Sale Id 4384',1800.48,0.00,0.00,2.42,191.18,'2022-09-03 17:43:54','',''),(4522,'1','275','1',1,'Retail Sale Id 4385',3720.00,0.00,0.00,5.00,395.00,'2022-09-03 17:53:10','',''),(4523,'1','275','1',1,'Retail Sale Id 4385',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 17:53:10','',''),(4524,'1','275','1',1,'Retail Sale Id 4386',14880.00,0.00,0.00,20.00,1580.00,'2022-09-03 17:57:57','',''),(4525,'1','275','1',1,'Retail Sale Id 4387',2998.32,0.00,0.00,4.03,318.37,'2022-09-03 18:10:29','',''),(4526,'1','275','1',1,'Retail Sale Id 4388',996.96,0.00,0.00,1.34,105.86,'2022-09-03 18:16:25','',''),(4527,'1','275','1',1,'Retail Sale Id 4389',1502.88,0.00,0.00,2.02,159.58,'2022-09-03 18:23:13','',''),(4528,'1','275','1',1,'Retail Sale Id 4390',1502.88,0.00,0.00,2.02,159.58,'2022-09-03 18:26:11','',''),(4529,'1','275','1',1,'Retail Sale Id 4391',35500.00,0.00,0.00,50.00,2250.00,'2022-09-03 18:28:17','',''),(4530,'1','275','1',1,'Retail Sale Id 4392',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 18:36:48','',''),(4531,'1','275','1',1,'Retail Sale Id 4393',35500.00,0.00,0.00,50.00,2250.00,'2022-09-03 18:43:38','',''),(4532,'1','275','1',1,'Retail Sale Id 4394',19262.16,0.00,0.00,25.89,2045.31,'2022-09-03 19:37:22','',''),(4533,'1','275','1',1,'Retail Sale Id 4395',34158.10,0.00,0.00,48.11,2164.95,'2022-09-03 19:38:50','',''),(4534,'1','275','1',1,'Retail Sale Id 4396',4999.68,0.00,0.00,6.72,530.88,'2022-09-04 07:06:01','',''),(4535,'1','275','1',1,'Retail Sale Id 4397',4999.68,0.00,0.00,6.72,530.88,'2022-09-04 07:19:19','',''),(4536,'1','275','1',1,'Retail Sale Id 4398',146260.00,0.00,0.00,206.00,9270.00,'2022-09-04 07:29:29','',''),(4537,'1','275','1',1,'Retail Sale Id 4399',23493.90,0.00,0.00,33.09,1489.05,'2022-09-04 08:13:19','',''),(4538,'1','275','1',1,'Retail Sale Id 4400',4002.72,0.00,0.00,5.38,425.02,'2022-09-04 08:32:49','',''),(4539,'1','275','1',1,'Retail Sale Id 4401',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 08:34:09','',''),(4540,'1','275','1',1,'Retail Sale Id 4402',996.96,0.00,0.00,1.34,105.86,'2022-09-04 08:37:09','',''),(4541,'1','275','1',1,'Retail Sale Id 4403',996.96,0.00,0.00,1.34,105.86,'2022-09-04 08:39:22','',''),(4542,'1','275','1',1,'Retail Sale Id 4404',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 08:46:47','',''),(4543,'1','275','1',1,'Retail Sale Id 4405',2298.96,0.00,0.00,3.09,244.11,'2022-09-04 08:52:59','',''),(4544,'1','275','1',1,'Retail Sale Id 4405',2298.96,0.00,0.00,3.09,244.11,'2022-09-04 08:52:59','',''),(4545,'1','275','1',1,'Retail Sale Id 4406',4501.20,0.00,0.00,6.05,477.95,'2022-09-04 09:02:11','',''),(4546,'1','275','1',1,'Retail Sale Id 4406',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 09:02:11','',''),(4547,'1','275','1',1,'Retail Sale Id 4407',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 09:03:30','',''),(4548,'1','275','1',1,'Retail Sale Id 4408',4002.72,0.00,0.00,5.38,425.02,'2022-09-04 09:52:03','',''),(4549,'1','275','1',1,'Retail Sale Id 4408',9002.40,0.00,0.00,12.10,955.90,'2022-09-04 09:52:03','',''),(4550,'1','275','1',1,'Retail Sale Id 4409',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 09:52:58','',''),(4551,'1','275','1',1,'Retail Sale Id 4410',33370.00,0.00,0.00,47.00,2115.00,'2022-09-04 09:56:52','',''),(4552,'1','275','1',1,'Retail Sale Id 4411',9002.40,0.00,0.00,12.10,955.90,'2022-09-04 10:02:37','',''),(4553,'1','275','1',1,'Retail Sale Id 4412',297.60,0.00,0.00,0.40,31.60,'2022-09-04 10:06:56','',''),(4554,'1','275','1',1,'Retail Sale Id 4414',4501.20,0.00,0.00,6.05,477.95,'2022-09-04 10:08:39','',''),(4555,'1','275','1',1,'Retail Sale Id 4415',131350.00,0.00,0.00,185.00,8325.00,'2022-09-04 10:13:53','',''),(4556,'1','275','1',1,'Retail Sale Id 4416',67450.00,0.00,0.00,95.00,4275.00,'2022-09-04 10:18:37','',''),(4557,'1','275','1',1,'Retail Sale Id 4417',7499.52,0.00,0.00,10.08,796.32,'2022-09-04 10:33:53','',''),(4558,'1','275','1',1,'Retail Sale Id 4418',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 10:40:48','',''),(4559,'1','275','1',1,'Retail Sale Id 4419',0.00,0.00,0.00,0.00,0.00,'2022-09-04 10:46:50','',''),(4560,'1','275','1',1,'Retail Sale Id 4420',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 10:55:26','',''),(4561,'1','275','1',1,'Retail Sale Id 4421',1696.32,0.00,0.00,2.28,180.12,'2022-09-04 11:02:00','',''),(4562,'1','275','1',1,'Retail Sale Id 4422',996.96,0.00,0.00,1.34,105.86,'2022-09-04 11:07:20','',''),(4563,'1','275','1',1,'Retail Sale Id 4423',1502.88,0.00,0.00,2.02,159.58,'2022-09-04 11:30:06','',''),(4564,'1','275','1',1,'Retail Sale Id 4424',1502.88,0.00,0.00,2.02,159.58,'2022-09-04 11:36:37','',''),(4565,'1','275','1',1,'Retail Sale Id 4425',26270.00,0.00,0.00,37.00,1665.00,'2022-09-04 11:40:19','',''),(4566,'1','275','1',1,'Retail Sale Id 4426',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 11:42:28','',''),(4567,'1','275','1',1,'Retail Sale Id 4427',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 11:51:57','',''),(4568,'1','275','1',1,'Retail Sale Id 4428',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 11:55:13','',''),(4569,'1','275','1',1,'Retail Sale Id 4429',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 11:59:14','',''),(4570,'1','275','1',1,'Retail Sale Id 4430',4501.20,0.00,0.00,6.05,477.95,'2022-09-04 12:05:49','',''),(4571,'1','275','1',1,'Retail Sale Id 4431',5996.64,0.00,0.00,8.06,636.74,'2022-09-04 12:11:52','',''),(4572,'1','275','1',1,'Retail Sale Id 4432',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 12:13:45','',''),(4573,'1','275','1',1,'Retail Sale Id 4433',18600.00,0.00,0.00,25.00,1975.00,'2022-09-04 12:27:59','',''),(4574,'1','275','1',1,'Retail Sale Id 4434',3720.00,0.00,0.00,5.00,395.00,'2022-09-04 12:37:51','',''),(4575,'1','275','1',1,'Retail Sale Id 4435',8520.00,0.00,0.00,12.00,540.00,'2022-09-04 12:40:03','',''),(4576,'1','275','1',1,'Retail Sale Id 4436',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 12:41:57','',''),(4577,'1','275','1',1,'Retail Sale Id 4437',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 12:52:25','',''),(4578,'1','275','1',1,'Retail Sale Id 4438',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 12:55:22','',''),(4579,'1','275','1',1,'Retail Sale Id 4439',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 12:58:02','',''),(4580,'1','275','1',1,'Retail Sale Id 4440',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 13:00:46','',''),(4581,'1','275','1',1,'Retail Sale Id 4441',1502.88,0.00,0.00,2.02,159.58,'2022-09-04 13:06:20','',''),(4582,'1','275','1',1,'Retail Sale Id 4442',4999.68,0.00,0.00,6.72,530.88,'2022-09-04 13:09:13','',''),(4583,'1','275','1',1,'Retail Sale Id 4442',7001.04,0.00,0.00,9.41,743.39,'2022-09-04 13:09:13','',''),(4584,'1','275','1',1,'Retail Sale Id 4443',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 13:10:43','',''),(4585,'1','275','1',1,'Retail Sale Id 4444',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 13:11:59','',''),(4586,'1','275','1',1,'Retail Sale Id 4445',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 13:17:52','',''),(4587,'1','275','1',1,'Retail Sale Id 4446',4501.20,0.00,0.00,6.05,477.95,'2022-09-04 13:27:27','',''),(4588,'1','275','1',1,'Retail Sale Id 4447',4501.20,0.00,0.00,6.05,477.95,'2022-09-04 13:38:58','',''),(4589,'1','275','1',1,'Retail Sale Id 4448',3720.00,0.00,0.00,5.00,395.00,'2022-09-04 13:41:27','',''),(4590,'1','275','1',1,'Retail Sale Id 4449',1502.88,0.00,0.00,2.02,159.58,'2022-09-04 13:46:36','',''),(4591,'1','275','1',1,'Retail Sale Id 4450',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 13:49:51','',''),(4592,'1','275','1',1,'Retail Sale Id 4451',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 14:01:29','',''),(4593,'1','275','1',1,'Retail Sale Id 4452',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 14:11:10','',''),(4594,'1','275','1',1,'Retail Sale Id 4453',2499.84,0.00,0.00,3.36,265.44,'2022-09-04 14:17:29','',''),(4595,'1','275','1',1,'Retail Sale Id 4454',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 14:21:41','',''),(4596,'1','275','1',1,'Retail Sale Id 4455',2298.96,0.00,0.00,3.09,244.11,'2022-09-04 14:31:46','',''),(4597,'1','275','1',1,'Retail Sale Id 4456',2001.36,0.00,0.00,2.69,212.51,'2022-09-04 14:46:30','',''),(4598,'1','275','1',1,'Retail Sale Id 4457',4002.72,0.00,0.00,5.38,425.02,'2022-09-04 14:54:56','',''),(4599,'1','275','1',1,'Retail Sale Id 4458',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 15:04:53','',''),(4600,'1','275','1',1,'Retail Sale Id 4459',4501.20,0.00,0.00,6.05,477.95,'2022-09-04 15:06:01','',''),(4601,'1','275','1',1,'Retail Sale Id 4460',996.96,0.00,0.00,1.34,105.86,'2022-09-04 15:06:56','',''),(4602,'1','275','1',1,'Retail Sale Id 4461',2298.96,0.00,0.00,3.09,244.11,'2022-09-04 15:33:48','',''),(4603,'1','275','1',1,'Retail Sale Id 4462',4002.72,0.00,0.00,5.38,425.02,'2022-09-04 16:16:48','',''),(4604,'1','275','1',1,'Retail Sale Id 4463',2001.36,0.00,0.00,2.69,212.51,'2022-09-04 16:19:42','',''),(4605,'1','275','1',1,'Retail Sale Id 4464',2298.96,0.00,0.00,3.09,244.11,'2022-09-04 16:20:33','',''),(4606,'1','275','1',1,'Retail Sale Id 4465',4501.20,0.00,0.00,6.05,477.95,'2022-09-04 16:27:48','',''),(4607,'1','275','1',1,'Retail Sale Id 4466',4002.72,0.00,0.00,5.38,425.02,'2022-09-04 16:40:03','',''),(4608,'1','275','1',1,'Retail Sale Id 4467',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 16:56:22','',''),(4609,'1','275','1',1,'Retail Sale Id 4468',3720.00,0.00,0.00,5.00,395.00,'2022-09-04 16:57:28','',''),(4610,'1','275','1',1,'Retail Sale Id 4469',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 17:12:58','',''),(4611,'1','275','1',1,'Retail Sale Id 4470',3720.00,0.00,0.00,5.00,395.00,'2022-09-04 17:30:07','',''),(4612,'1','275','1',1,'Retail Sale Id 4471',2998.32,0.00,0.00,4.03,318.37,'2022-09-04 17:31:33','',''),(4613,'1','275','1',1,'Retail Sale Id 4472',35500.00,0.00,0.00,50.00,2250.00,'2022-09-04 17:39:11','',''),(4614,'1','275','1',1,'Retail Sale Id 4473',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 17:41:35','',''),(4615,'1','275','1',1,'Retail Sale Id 4474',4002.72,0.00,0.00,5.38,425.02,'2022-09-04 17:42:54','',''),(4616,'1','275','1',1,'Retail Sale Id 4475',4597.92,0.00,0.00,6.18,488.22,'2022-09-04 17:44:11','',''),(4617,'1','275','1',1,'Retail Sale Id 4476',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 17:46:31','',''),(4618,'1','275','1',1,'Retail Sale Id 4477',4002.72,0.00,0.00,5.38,425.02,'2022-09-04 17:53:17','',''),(4619,'1','275','1',1,'Retail Sale Id 4478',45667.20,0.00,0.00,64.32,2894.40,'2022-09-04 18:27:46','',''),(4620,'1','275','1',1,'Retail Sale Id 4479',14909.76,0.00,0.00,20.04,1583.16,'2022-09-04 18:28:21','',''),(4621,'1','275','1',1,'Distributed to OPPRETIONAL LOST  for sales id:16',150908.45,0.00,0.00,226.93,0.00,'2022-09-05 09:36:31','',''),(4622,'1','275',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3271800.00,4920.00,0.00,0.00,'2022-09-05 10:32:13','',''),(4623,'1','275',NULL,1,'Reception corrector for bridging 18',0.00,0.00,0.00,4920.00,0.00,'2022-09-05 10:33:08','',''),(4624,'1','275','1',1,'Received from bridging 18',0.00,0.00,4920.00,0.00,0.00,'2022-09-05 10:33:08','',''),(4625,'1','275','1',1,'Retail Sale Id 4480',46150.00,0.00,0.00,65.00,2925.00,'2022-09-05 10:33:52','',''),(4626,'1','275','1',1,'Retail Sale Id 4481',71000.00,0.00,0.00,100.00,4500.00,'2022-09-05 10:35:21','',''),(4627,'1','275','1',1,'Retail Sale Id 4482',18600.00,0.00,0.00,25.00,1975.00,'2022-09-05 10:36:26','',''),(4628,'1','275','1',1,'Retail Sale Id 4483',9300.00,0.00,0.00,12.50,987.50,'2022-09-05 10:36:55','',''),(4629,'1','275','1',1,'Retail Sale Id 4484',7998.00,0.00,0.00,10.75,849.25,'2022-09-05 10:51:08','',''),(4630,'1','275','1',1,'Retail Sale Id 4485',5996.64,0.00,0.00,8.06,636.74,'2022-09-05 10:52:31','',''),(4631,'1','275','1',1,'Retail Sale Id 4486',9300.00,0.00,0.00,12.50,987.50,'2022-09-05 10:54:30','',''),(4632,'1','275','1',1,'Retail Sale Id 4487',18600.00,0.00,0.00,25.00,1975.00,'2022-09-05 11:09:27','',''),(4633,'1','275','1',1,'Retail Sale Id 4489',2001.36,0.00,0.00,2.69,212.51,'2022-09-05 11:11:17','',''),(4634,'1','275','1',1,'Retail Sale Id 4490',37200.00,0.00,0.00,50.00,3950.00,'2022-09-05 11:12:19','',''),(4635,'1','275','1',1,'Retail Sale Id 4491',2001.36,0.00,0.00,2.69,212.51,'2022-09-05 11:15:48','',''),(4636,'1','275','1',1,'Retail Sale Id 4492',2298.96,0.00,0.00,3.09,244.11,'2022-09-05 11:23:44','',''),(4637,'1','275','1',1,'Retail Sale Id 4493',27900.00,0.00,0.00,37.50,2962.50,'2022-09-05 11:29:40','',''),(4638,'1','275','1',1,'Retail Sale Id 4494',1502.88,0.00,0.00,2.02,159.58,'2022-09-05 11:30:55','',''),(4639,'1','275','1',1,'Retail Sale Id 4495',5996.64,0.00,0.00,8.06,636.74,'2022-09-05 12:02:11','',''),(4640,'1','275','1',1,'Retail Sale Id 4496',996.96,0.00,0.00,1.34,105.86,'2022-09-05 12:03:11','',''),(4641,'1','275','1',1,'Retail Sale Id 4497',9300.00,0.00,0.00,12.50,987.50,'2022-09-05 12:20:16','',''),(4642,'1','275','1',1,'Retail Sale Id 4498',2298.96,0.00,0.00,3.09,244.11,'2022-09-05 12:31:59','',''),(4643,'1','275','1',1,'Retail Sale Id 4499',9300.00,0.00,0.00,12.50,987.50,'2022-09-05 12:36:17','',''),(4644,'1','275','1',1,'Retail Sale Id 4500',4501.20,0.00,0.00,6.05,477.95,'2022-09-05 12:40:45','',''),(4645,'1','275','1',1,'Retail Sale Id 4501',9300.00,0.00,0.00,12.50,987.50,'2022-09-05 12:44:57','',''),(4646,'1','275','1',1,'Retail Sale Id 4502',4999.68,0.00,0.00,6.72,530.88,'2022-09-05 13:14:53','',''),(4647,'1','275','1',1,'Retail Sale Id 4503',2499.84,0.00,0.00,3.36,265.44,'2022-09-05 13:39:14','',''),(4648,'1','275','1',1,'Retail Sale Id 4504',36565.00,0.00,0.00,51.50,2317.50,'2022-09-05 13:43:25','',''),(4649,'1','275','1',1,'Retail Sale Id 4505',71000.00,0.00,0.00,100.00,4500.00,'2022-09-05 14:05:19','',''),(4650,'1','275','1',1,'Retail Sale Id 4506',7440.00,0.00,0.00,10.00,790.00,'2022-09-05 14:07:41','',''),(4651,'1','275','1',1,'Retail Sale Id 4507',2298.96,0.00,0.00,3.09,244.11,'2022-09-05 14:23:52','',''),(4652,'1','275','1',1,'Retail Sale Id 4508',3720.00,0.00,0.00,5.00,395.00,'2022-09-05 14:25:25','',''),(4653,'1','275','1',1,'Retail Sale Id 4509',71000.00,0.00,0.00,100.00,4500.00,'2022-09-05 14:39:10','',''),(4654,'1','275','1',1,'Retail Sale Id 4510',71000.00,0.00,0.00,100.00,4500.00,'2022-09-05 14:47:25','',''),(4655,'1','275','1',1,'Retail Sale Id 4511',1502.88,0.00,0.00,2.02,159.58,'2022-09-05 15:01:23','',''),(4656,'1','275','1',1,'Retail Sale Id 4512',2001.36,0.00,0.00,2.69,212.51,'2022-09-05 15:09:35','',''),(4657,'1','275','1',1,'Retail Sale Id 4513',9300.00,0.00,0.00,12.50,987.50,'2022-09-05 15:37:13','',''),(4658,'1','275','1',1,'Retail Sale Id 4514',2298.96,0.00,0.00,3.09,244.11,'2022-09-05 15:39:06','',''),(4659,'1','275','1',1,'Retail Sale Id 4515',9300.00,0.00,0.00,12.50,987.50,'2022-09-05 15:41:46','',''),(4660,'1','275','1',1,'Retail Sale Id 4516',1502.88,0.00,0.00,2.02,159.58,'2022-09-05 15:46:07','',''),(4661,'1','275','1',1,'Retail Sale Id 4517',2001.36,0.00,0.00,2.69,212.51,'2022-09-05 15:50:37','',''),(4662,'1','275','1',1,'Retail Sale Id 4518',699.36,0.00,0.00,0.94,74.26,'2022-09-05 15:51:45','',''),(4663,'1','275','1',1,'Retail Sale Id 4519',9300.00,0.00,0.00,12.50,987.50,'2022-09-05 15:56:51','',''),(4664,'1','275','1',1,'Retail Sale Id 4520',5996.64,0.00,0.00,8.06,636.74,'2022-09-05 16:03:23','',''),(4665,'1','275','1',1,'Retail Sale Id 4521',9300.00,0.00,0.00,12.50,987.50,'2022-09-05 16:05:05','',''),(4666,'1','275','1',1,'Retail Sale Id 4522',2001.36,0.00,0.00,2.69,212.51,'2022-09-05 16:06:33','',''),(4667,'1','275','1',1,'Retail Sale Id 4523',27900.00,0.00,0.00,37.50,2962.50,'2022-09-05 16:07:43','',''),(4668,'1','275','1',1,'Retail Sale Id 4524',2298.96,0.00,0.00,3.09,244.11,'2022-09-05 16:21:05','',''),(4669,'1','275','1',1,'Retail Sale Id 4525',4836.00,0.00,0.00,6.50,513.50,'2022-09-05 16:34:01','',''),(4670,'1','275','1',1,'Retail Sale Id 4525',4836.00,0.00,0.00,6.50,513.50,'2022-09-05 16:34:01','',''),(4671,'1','275','1',1,'Retail Sale Id 4526',24180.00,0.00,0.00,32.50,2567.50,'2022-09-05 16:44:06','',''),(4672,'1','275','1',1,'Retail Sale Id 4527',2998.32,0.00,0.00,4.03,318.37,'2022-09-05 16:45:56','',''),(4673,'1','275','1',1,'Retail Sale Id 4528',2298.96,0.00,0.00,3.09,244.11,'2022-09-05 16:47:34','',''),(4674,'1','275','1',1,'Retail Sale Id 4529',4501.20,0.00,0.00,6.05,477.95,'2022-09-05 16:53:48','',''),(4675,'1','275','1',1,'Retail Sale Id 4530',4501.20,0.00,0.00,6.05,477.95,'2022-09-05 16:57:45','',''),(4676,'1','275','1',1,'Retail Sale Id 4531',2001.36,0.00,0.00,2.69,212.51,'2022-09-05 17:11:06','',''),(4677,'1','275','1',1,'Retail Sale Id 4532',9300.00,0.00,0.00,12.50,987.50,'2022-09-05 17:13:29','',''),(4678,'1','275','1',1,'Retail Sale Id 4533',9300.00,0.00,0.00,12.50,987.50,'2022-09-05 17:15:40','',''),(4679,'1','275','1',1,'Retail Sale Id 4534',4501.20,0.00,0.00,6.05,477.95,'2022-09-05 17:21:20','',''),(4680,'1','275','1',1,'Retail Sale Id 4535',1502.88,0.00,0.00,2.02,159.58,'2022-09-05 17:22:11','',''),(4681,'1','275','1',1,'Retail Sale Id 4536',9300.00,0.00,0.00,12.50,987.50,'2022-09-05 17:27:29','',''),(4682,'1','275','1',1,'Retail Sale Id 4537',996.96,0.00,0.00,1.34,105.86,'2022-09-05 17:28:36','',''),(4683,'1','275','1',1,'Retail Sale Id 4538',8303.04,0.00,0.00,11.16,881.64,'2022-09-05 17:29:46','',''),(4684,'1','275','1',1,'Retail Sale Id 4539',4002.72,0.00,0.00,5.38,425.02,'2022-09-05 17:42:33','',''),(4685,'1','275','1',1,'Retail Sale Id 4540',1502.88,0.00,0.00,2.02,159.58,'2022-09-05 17:58:05','',''),(4686,'1','275','1',1,'Retail Sale Id 4541',9300.00,0.00,0.00,12.50,987.50,'2022-09-05 17:59:11','',''),(4687,'1','275','1',1,'Retail Sale Id 4542',996.96,0.00,0.00,1.34,105.86,'2022-09-05 18:08:49','',''),(4688,'1','275','1',1,'Retail Sale Id 4543',4999.68,0.00,0.00,6.72,530.88,'2022-09-05 18:16:17','',''),(4689,'1','275','1',1,'Retail Sale Id 4544',14498.20,0.00,0.00,20.42,918.90,'2022-09-05 18:18:24','',''),(4690,'1','275','1',1,'Retail Sale Id 4545',2499.84,0.00,0.00,3.36,265.44,'2022-09-05 18:19:54','',''),(4691,'1','275','1',1,'Retail Sale Id 4546',2001.36,0.00,0.00,2.69,212.51,'2022-09-05 18:26:23','',''),(4692,'1','275','1',1,'Retail Sale Id 4547',37200.00,0.00,0.00,50.00,3950.00,'2022-09-05 18:31:16','',''),(4693,'1','275','1',1,'Retail Sale Id 4548',33370.00,0.00,0.00,47.00,2115.00,'2022-09-05 18:38:22','',''),(4694,'1','275','1',1,'Retail Sale Id 4549',3720.00,0.00,0.00,5.00,395.00,'2022-09-05 18:44:06','',''),(4695,'1','275','1',1,'Retail Sale Id 4550',2298.96,0.00,0.00,3.09,244.11,'2022-09-05 19:02:37','',''),(4696,'1','275','1',1,'Retail Sale Id 4551',3720.00,0.00,0.00,5.00,395.00,'2022-09-05 19:05:01','',''),(4697,'1','275','1',1,'Retail Sale Id 4552',3720.00,0.00,0.00,5.00,395.00,'2022-09-05 19:06:16','',''),(4698,'1','275','1',1,'Retail Sale Id 4553',9300.00,0.00,0.00,12.50,987.50,'2022-09-05 19:07:25','',''),(4699,'1','275','1',1,'Retail Sale Id 4554',13912.80,0.00,0.00,18.70,1477.30,'2022-09-05 19:50:15','',''),(4700,'1','275','1',1,'Retail Sale Id 4555',5978.20,0.00,0.00,8.42,378.90,'2022-09-05 19:50:59','',''),(4701,'1','275','1',1,'Retail Sale Id 4556',9300.00,0.00,0.00,12.50,987.50,'2022-09-06 07:07:06','',''),(4702,'1','275','1',1,'Retail Sale Id 4557',9002.40,0.00,0.00,12.10,955.90,'2022-09-06 08:22:17','',''),(4703,'1','275','1',1,'Retail Sale Id 4558',4999.68,0.00,0.00,6.72,530.88,'2022-09-06 08:24:09','',''),(4704,'1','275','1',1,'Retail Sale Id 4559',70000.00,0.00,0.00,100.00,3500.00,'2022-09-06 08:25:09','',''),(4705,'1','275','1',1,'Retail Sale Id 4560',4999.68,0.00,0.00,6.72,530.88,'2022-09-06 08:31:02','',''),(4706,'1','275','1',1,'Retail Sale Id 4561',3303.36,0.00,0.00,4.44,350.76,'2022-09-06 08:32:49','',''),(4707,'1','275','1',1,'Retail Sale Id 4562',1502.88,0.00,0.00,2.02,159.58,'2022-09-06 08:35:52','',''),(4708,'1','275','1',1,'Retail Sale Id 4563',7440.00,0.00,0.00,10.00,790.00,'2022-09-06 08:45:10','',''),(4709,'1','275','1',1,'Retail Sale Id 4564',2298.96,0.00,0.00,3.09,244.11,'2022-09-06 08:47:48','',''),(4710,'1','275','1',1,'Retail Sale Id 4565',11160.00,0.00,0.00,15.00,1185.00,'2022-09-06 08:56:16','',''),(4711,'1','275','1',1,'Retail Sale Id 4566',18200.00,0.00,0.00,26.00,910.00,'2022-09-06 08:57:32','',''),(4712,'1','275','1',1,'Retail Sale Id 4567',32200.00,0.00,0.00,46.00,1610.00,'2022-09-06 09:00:19','',''),(4713,'1','275','1',1,'Retail Sale Id 4568',4501.20,0.00,0.00,6.05,477.95,'2022-09-06 09:12:19','',''),(4714,'1','275','1',1,'Retail Sale Id 4569',2298.96,0.00,0.00,3.09,244.11,'2022-09-06 09:42:21','',''),(4715,'1','275','1',1,'Retail Sale Id 4570',3720.00,0.00,0.00,5.00,395.00,'2022-09-06 09:43:35','',''),(4716,'1','275','1',1,'Retail Sale Id 4571',16003.44,0.00,0.00,21.51,1699.29,'2022-09-06 09:47:56','',''),(4717,'1','275','1',1,'Retail Sale Id 4572',7998.00,0.00,0.00,10.75,849.25,'2022-09-06 09:58:30','',''),(4718,'1','275','1',1,'Retail Sale Id 4573',2298.96,0.00,0.00,3.09,244.11,'2022-09-06 10:08:01','',''),(4719,'1','275','1',1,'Retail Sale Id 4574',140000.00,0.00,0.00,200.00,7000.00,'2022-09-06 10:31:20','',''),(4720,'1','275','1',1,'Retail Sale Id 4575',996.96,0.00,0.00,1.34,105.86,'2022-09-06 10:38:22','',''),(4721,'1','275','1',1,'Retail Sale Id 4576',18600.00,0.00,0.00,25.00,1975.00,'2022-09-06 10:51:52','',''),(4722,'1','275','1',1,'Retail Sale Id 4577',35000.00,0.00,0.00,50.00,1750.00,'2022-09-06 10:53:51','',''),(4723,'1','275','1',1,'Retail Sale Id 4578',22995.00,0.00,0.00,32.85,1149.75,'2022-09-06 11:16:00','',''),(4724,'1','275','1',1,'Retail Sale Id 4579',22400.00,0.00,0.00,32.00,1120.00,'2022-09-06 11:20:36','',''),(4725,'1','275','1',1,'Return of Retail Sale Id 4578',0.00,22995.00,32.85,0.00,-1149.75,'2022-09-06 11:22:41','',''),(4726,'1','275','1',1,'Retail Sale Id 4580',9300.00,0.00,0.00,12.50,987.50,'2022-09-06 11:27:05','',''),(4727,'1','275','1',1,'Retail Sale Id 4581',9300.00,0.00,0.00,12.50,987.50,'2022-09-06 11:33:40','',''),(4728,'1','275','1',1,'Retail Sale Id 4582',7998.00,0.00,0.00,10.75,849.25,'2022-09-06 11:49:32','',''),(4729,'1','275','1',1,'Retail Sale Id 4583',3720.00,0.00,0.00,5.00,395.00,'2022-09-06 11:56:18','',''),(4730,'1','275','1',1,'Retail Sale Id 4584',18600.00,0.00,0.00,25.00,1975.00,'2022-09-06 12:06:18','',''),(4731,'1','275','1',1,'Retail Sale Id 4585',4002.72,0.00,0.00,5.38,425.02,'2022-09-06 12:07:21','',''),(4732,'1','275','1',1,'Retail Sale Id 4586',2998.32,0.00,0.00,4.03,318.37,'2022-09-06 12:24:55','',''),(4733,'1','275','1',1,'Retail Sale Id 4586',2998.32,0.00,0.00,4.03,318.37,'2022-09-06 12:24:55','',''),(4734,'1','275','1',1,'Retail Sale Id 4587',9300.00,0.00,0.00,12.50,987.50,'2022-09-06 12:35:48','',''),(4735,'1','275','1',1,'Retail Sale Id 4588',14202.96,0.00,0.00,19.09,1508.11,'2022-09-06 13:15:53','',''),(4736,'1','275','1',1,'Retail Sale Id 4589',4999.68,0.00,0.00,6.72,530.88,'2022-09-06 13:21:01','',''),(4737,'1','275','1',1,'Retail Sale Id 4590',9300.00,0.00,0.00,12.50,987.50,'2022-09-06 13:24:00','',''),(4738,'1','275','1',1,'Retail Sale Id 4591',35000.00,0.00,0.00,50.00,1750.00,'2022-09-06 13:54:29','',''),(4739,'1','275','1',1,'Retail Sale Id 4592',996.96,0.00,0.00,1.34,105.86,'2022-09-06 13:55:19','',''),(4740,'1','275','1',1,'Retail Sale Id 4593',9300.00,0.00,0.00,12.50,987.50,'2022-09-06 13:57:28','',''),(4741,'1','275','1',1,'Retail Sale Id 4594',7001.04,0.00,0.00,9.41,743.39,'2022-09-06 14:06:44','',''),(4742,'1','275','1',1,'Retail Sale Id 4595',2998.32,0.00,0.00,4.03,318.37,'2022-09-06 14:40:23','',''),(4743,'1','275','1',1,'Retail Sale Id 4596',9300.00,0.00,0.00,12.50,987.50,'2022-09-06 14:43:47','',''),(4744,'1','275','1',1,'Retail Sale Id 4597',4501.20,0.00,0.00,6.05,477.95,'2022-09-06 15:13:30','',''),(4745,'1','275','1',1,'Retail Sale Id 4598',9300.00,0.00,0.00,12.50,987.50,'2022-09-06 15:26:00','',''),(4746,'1','275','1',1,'Retail Sale Id 4599',7998.00,0.00,0.00,10.75,849.25,'2022-09-06 15:27:31','',''),(4747,'1','275','1',1,'Retail Sale Id 4600',4501.20,0.00,0.00,6.05,477.95,'2022-09-06 15:43:28','',''),(4748,'1','275','1',1,'Retail Sale Id 4601',7499.52,0.00,0.00,10.08,796.32,'2022-09-06 15:52:40','',''),(4749,'1','275','1',1,'Retail Sale Id 4602',9300.00,0.00,0.00,12.50,987.50,'2022-09-06 16:09:09','',''),(4750,'1','275','1',1,'Retail Sale Id 4603',2298.96,0.00,0.00,3.09,244.11,'2022-09-06 16:41:07','',''),(4751,'1','275','1',1,'Retail Sale Id 4604',9300.00,0.00,0.00,12.50,987.50,'2022-09-06 16:44:01','',''),(4752,'1','275','1',1,'Retail Sale Id 4605',1502.88,0.00,0.00,2.02,159.58,'2022-09-06 16:48:17','',''),(4753,'1','275','1',1,'Retail Sale Id 4606',14880.00,0.00,0.00,20.00,1580.00,'2022-09-06 16:59:32','',''),(4754,'1','275','1',1,'Retail Sale Id 4607',9300.00,0.00,0.00,12.50,987.50,'2022-09-06 17:04:19','',''),(4755,'1','275','1',1,'Retail Sale Id 4608',9300.00,0.00,0.00,12.50,987.50,'2022-09-06 17:06:22','',''),(4756,'1','275','1',1,'Retail Sale Id 4609',2998.32,0.00,0.00,4.03,318.37,'2022-09-06 17:23:46','',''),(4757,'1','275','1',1,'Retail Sale Id 4610',996.96,0.00,0.00,1.34,105.86,'2022-09-06 17:24:42','',''),(4758,'1','275','1',1,'Retail Sale Id 4611',4501.20,0.00,0.00,6.05,477.95,'2022-09-06 17:25:33','',''),(4759,'1','275','1',1,'Retail Sale Id 4612',7440.00,0.00,0.00,10.00,790.00,'2022-09-06 17:30:06','',''),(4760,'1','275','1',1,'Retail Sale Id 4613',4002.72,0.00,0.00,5.38,425.02,'2022-09-06 17:32:20','',''),(4761,'1','275','1',1,'Retail Sale Id 4614',22001.00,0.00,0.00,31.43,1100.05,'2022-09-06 17:49:49','',''),(4762,'1','275','1',1,'Retail Sale Id 4615',9300.00,0.00,0.00,12.50,987.50,'2022-09-06 17:50:44','',''),(4763,'1','275','1',1,'Retail Sale Id 4616',4999.68,0.00,0.00,6.72,530.88,'2022-09-06 17:54:45','',''),(4764,'1','275','1',1,'Retail Sale Id 4617',4464.00,0.00,0.00,6.00,474.00,'2022-09-06 17:56:56','',''),(4765,'1','275','1',1,'Retail Sale Id 4618',9300.00,0.00,0.00,12.50,987.50,'2022-09-06 18:02:55','',''),(4766,'1','275','1',1,'Retail Sale Id 4619',9300.00,0.00,0.00,12.50,987.50,'2022-09-06 18:10:54','',''),(4767,'1','275','1',1,'Retail Sale Id 4620',2298.96,0.00,0.00,3.09,244.11,'2022-09-06 18:16:47','',''),(4768,'1','275','1',1,'Retail Sale Id 4621',2298.96,0.00,0.00,3.09,244.11,'2022-09-06 18:17:46','',''),(4769,'1','275','1',1,'Retail Sale Id 4622',4501.20,0.00,0.00,6.05,477.95,'2022-09-06 18:19:43','',''),(4770,'1','275','1',1,'Retail Sale Id 4623',14497.00,0.00,0.00,20.71,724.85,'2022-09-06 18:22:52','',''),(4771,'1','275','1',1,'Retail Sale Id 4624',8400.00,0.00,0.00,12.00,420.00,'2022-09-06 18:29:36','',''),(4772,'1','275','1',1,'Retail Sale Id 4625',27996.72,0.00,0.00,37.63,2972.77,'2022-09-06 18:30:52','',''),(4773,'1','275','1',1,'Retail Sale Id 4626',2001.36,0.00,0.00,2.69,212.51,'2022-09-06 18:31:47','',''),(4774,'1','275','1',1,'Retail Sale Id 4627',2298.96,0.00,0.00,3.09,244.11,'2022-09-06 18:33:22','',''),(4775,'1','275','1',1,'Retail Sale Id 4628',1502.88,0.00,0.00,2.02,159.58,'2022-09-06 18:34:14','',''),(4776,'1','275','1',1,'Return of Retail Sale Id 4624',0.00,8400.00,12.00,0.00,-420.00,'2022-09-06 19:20:33','',''),(4777,'1','275','1',1,'Retail Sale Id 4629',7483.00,0.00,0.00,10.69,374.15,'2022-09-06 19:23:48','',''),(4778,'1','275','1',1,'Retail Sale Id 4630',41991.36,0.00,0.00,56.44,4458.76,'2022-09-06 19:24:30','',''),(4779,'1','275','1',1,'Retail Sale Id 4631',9300.00,0.00,0.00,12.50,987.50,'2022-09-07 06:48:08','',''),(4780,'1','275','1',1,'Retail Sale Id 4632',2901.60,0.00,0.00,3.90,308.10,'2022-09-07 06:58:46','',''),(4781,'1','275','1',1,'Retail Sale Id 4633',2998.32,0.00,0.00,4.03,318.37,'2022-09-07 07:11:47','',''),(4782,'1','275','1',1,'Retail Sale Id 4634',13020.00,0.00,0.00,17.50,1382.50,'2022-09-07 07:17:52','',''),(4783,'1','275','1',1,'Retail Sale Id 4635',1502.88,0.00,0.00,2.02,159.58,'2022-09-07 07:32:59','',''),(4784,'1','275','1',1,'Retail Sale Id 4636',2298.96,0.00,0.00,3.09,244.11,'2022-09-07 07:36:17','',''),(4785,'1','275','1',1,'Retail Sale Id 4637',4501.20,0.00,0.00,6.05,477.95,'2022-09-07 07:41:53','',''),(4786,'1','275','1',1,'Retail Sale Id 4638',18600.00,0.00,0.00,25.00,1975.00,'2022-09-07 08:04:28','',''),(4787,'1','275','1',1,'Retail Sale Id 4639',2298.96,0.00,0.00,3.09,244.11,'2022-09-07 08:10:21','',''),(4788,'1','275','1',1,'Retail Sale Id 4640',45500.00,0.00,0.00,65.00,2275.00,'2022-09-07 08:13:35','',''),(4789,'1','275','1',1,'Retail Sale Id 4641',3720.00,0.00,0.00,5.00,395.00,'2022-09-07 08:27:54','',''),(4790,'1','275','1',1,'Retail Sale Id 4642',9300.00,0.00,0.00,12.50,987.50,'2022-09-07 08:37:04','',''),(4791,'1','275','1',1,'Retail Sale Id 4643',49000.00,0.00,0.00,70.00,2450.00,'2022-09-07 08:38:05','',''),(4792,'1','275','1',1,'Retail Sale Id 4644',2298.96,0.00,0.00,3.09,244.11,'2022-09-07 08:39:15','',''),(4793,'1','275','1',1,'Retail Sale Id 4645',2998.32,0.00,0.00,4.03,318.37,'2022-09-07 08:54:43','',''),(4794,'1','275','1',1,'Retail Sale Id 4646',9300.00,0.00,0.00,12.50,987.50,'2022-09-07 09:03:23','',''),(4795,'1','275','1',1,'Retail Sale Id 4647',2298.96,0.00,0.00,3.09,244.11,'2022-09-07 09:10:33','',''),(4796,'1','275','1',1,'Retail Sale Id 4648',744.00,0.00,0.00,1.00,79.00,'2022-09-07 09:21:41','',''),(4797,'1','275','1',1,'Retail Sale Id 4649',9300.00,0.00,0.00,12.50,987.50,'2022-09-07 09:43:25','',''),(4798,'1','275','1',1,'Retail Sale Id 4650',70000.00,0.00,0.00,100.00,3500.00,'2022-09-07 09:57:13','',''),(4799,'1','275','1',1,'Retail Sale Id 4651',2998.32,0.00,0.00,4.03,318.37,'2022-09-07 09:58:19','',''),(4800,'1','275','1',1,'Retail Sale Id 4652',996.96,0.00,0.00,1.34,105.86,'2022-09-07 09:59:33','',''),(4801,'1','275','1',1,'Retail Sale Id 4653',20832.00,0.00,0.00,28.00,2212.00,'2022-09-07 10:08:24','',''),(4802,'1','275','1',1,'Retail Sale Id 4654',9300.00,0.00,0.00,12.50,987.50,'2022-09-07 10:13:36','',''),(4803,'1','275','1',1,'Retail Sale Id 4655',2001.36,0.00,0.00,2.69,212.51,'2022-09-07 10:15:05','',''),(4804,'1','275','1',1,'Retail Sale Id 4656',3720.00,0.00,0.00,5.00,395.00,'2022-09-07 10:16:07','',''),(4805,'1','275','1',1,'Retail Sale Id 4657',4501.20,0.00,0.00,6.05,477.95,'2022-09-07 10:18:48','',''),(4806,'1','275','1',1,'Retail Sale Id 4658',9300.00,0.00,0.00,12.50,987.50,'2022-09-07 10:21:49','',''),(4807,'1','275','1',1,'Retail Sale Id 4659',9300.00,0.00,0.00,12.50,987.50,'2022-09-07 10:47:13','',''),(4808,'1','275','1',1,'Retail Sale Id 4660',7998.00,0.00,0.00,10.75,849.25,'2022-09-07 11:05:01','',''),(4809,'1','275','1',1,'Retail Sale Id 4661',2298.96,0.00,0.00,3.09,244.11,'2022-09-07 11:48:07','',''),(4810,'1','275','1',1,'Retail Sale Id 4662',9300.00,0.00,0.00,12.50,987.50,'2022-09-07 11:58:45','',''),(4811,'1','275','1',1,'Retail Sale Id 4663',18600.00,0.00,0.00,25.00,1975.00,'2022-09-07 12:08:30','',''),(4812,'1','275','1',1,'Retail Sale Id 4664',4501.20,0.00,0.00,6.05,477.95,'2022-09-07 12:30:07','',''),(4813,'1','275','1',1,'Retail Sale Id 4665',2998.32,0.00,0.00,4.03,318.37,'2022-09-07 12:34:15','',''),(4814,'1','275','1',1,'Retail Sale Id 4666',744.00,0.00,0.00,1.00,79.00,'2022-09-07 12:50:44','',''),(4815,'1','275','1',1,'Retail Sale Id 4667',4999.68,0.00,0.00,6.72,530.88,'2022-09-07 13:11:00','',''),(4816,'1','275','1',1,'Retail Sale Id 4668',11598.96,0.00,0.00,15.59,1231.61,'2022-09-07 13:13:12','',''),(4817,'1','275','1',1,'Retail Sale Id 4669',4501.20,0.00,0.00,6.05,477.95,'2022-09-07 13:19:28','',''),(4818,'1','275','1',1,'Retail Sale Id 4670',14880.00,0.00,0.00,20.00,1580.00,'2022-09-07 13:37:12','',''),(4819,'1','275','1',1,'Retail Sale Id 4671',2246.88,0.00,0.00,3.02,238.58,'2022-09-07 13:38:31','',''),(4820,'1','275','1',1,'Retail Sale Id 4672',2298.96,0.00,0.00,3.09,244.11,'2022-09-07 13:48:54','',''),(4821,'1','275','1',1,'Retail Sale Id 4673',4501.20,0.00,0.00,6.05,477.95,'2022-09-07 14:11:21','',''),(4822,'1','275','1',1,'Retail Sale Id 4674',3697.68,0.00,0.00,4.97,392.63,'2022-09-07 14:29:14','',''),(4823,'1','275','1',1,'Retail Sale Id 4675',2998.32,0.00,0.00,4.03,318.37,'2022-09-07 14:31:10','',''),(4824,'1','275','1',1,'Retail Sale Id 4676',4501.20,0.00,0.00,6.05,477.95,'2022-09-07 14:35:38','',''),(4825,'1','275','1',1,'Retail Sale Id 4677',9300.00,0.00,0.00,12.50,987.50,'2022-09-07 14:43:21','',''),(4826,'1','275','1',1,'Retail Sale Id 4678',151200.00,0.00,0.00,216.00,7560.00,'2022-09-07 15:22:01','',''),(4827,'1','275','1',1,'Retail Sale Id 4679',35000.00,0.00,0.00,50.00,1750.00,'2022-09-07 15:30:17','',''),(4828,'1','275','1',1,'Retail Sale Id 4680',996.96,0.00,0.00,1.34,105.86,'2022-09-07 15:34:29','',''),(4829,'1','275','1',1,'Retail Sale Id 4681',996.96,0.00,0.00,1.34,105.86,'2022-09-07 15:35:22','',''),(4830,'1','275','1',1,'Retail Sale Id 4682',2001.36,0.00,0.00,2.69,212.51,'2022-09-07 15:41:54','',''),(4831,'1','275','1',1,'Retail Sale Id 4683',2998.32,0.00,0.00,4.03,318.37,'2022-09-07 15:45:17','',''),(4832,'1','275','1',1,'Retail Sale Id 4684',9300.00,0.00,0.00,12.50,987.50,'2022-09-07 15:54:16','',''),(4833,'1','275','1',1,'Retail Sale Id 4685',2298.96,0.00,0.00,3.09,244.11,'2022-09-07 16:04:55','',''),(4834,'1','275','1',1,'Retail Sale Id 4686',9300.00,0.00,0.00,12.50,987.50,'2022-09-07 16:18:57','',''),(4835,'1','275','1',1,'Retail Sale Id 4688',16740.00,0.00,0.00,22.50,1777.50,'2022-09-07 16:26:22','',''),(4836,'1','275','1',1,'Retail Sale Id 4689',2298.96,0.00,0.00,3.09,244.11,'2022-09-07 16:30:43','',''),(4837,'1','275','1',1,'Retail Sale Id 4690',2001.36,0.00,0.00,2.69,212.51,'2022-09-07 16:31:56','',''),(4838,'1','275','1',1,'Retail Sale Id 4691',9300.00,0.00,0.00,12.50,987.50,'2022-09-07 16:37:08','',''),(4839,'1','275','1',1,'Retail Sale Id 4692',2298.96,0.00,0.00,3.09,244.11,'2022-09-07 16:41:54','',''),(4840,'1','275','1',1,'Retail Sale Id 4693',2298.96,0.00,0.00,3.09,244.11,'2022-09-07 16:44:29','',''),(4841,'1','275','1',1,'Retail Sale Id 4694',9300.00,0.00,0.00,12.50,987.50,'2022-09-07 17:20:57','',''),(4842,'1','275','1',1,'Retail Sale Id 4695',2998.32,0.00,0.00,4.03,318.37,'2022-09-07 17:26:36','',''),(4843,'1','275','1',1,'Retail Sale Id 4696',4501.20,0.00,0.00,6.05,477.95,'2022-09-07 17:30:07','',''),(4844,'1','275','1',1,'Retail Sale Id 4697',2998.32,0.00,0.00,4.03,318.37,'2022-09-07 17:32:48','',''),(4845,'1','275','1',1,'Retail Sale Id 4698',2001.36,0.00,0.00,2.69,212.51,'2022-09-07 17:39:27','',''),(4846,'1','275','1',1,'Retail Sale Id 4699',9300.00,0.00,0.00,12.50,987.50,'2022-09-07 17:50:46','',''),(4847,'1','275','1',1,'Retail Sale Id 4700',2298.96,0.00,0.00,3.09,244.11,'2022-09-07 17:59:29','',''),(4848,'1','275','1',1,'Retail Sale Id 4701',9300.00,0.00,0.00,12.50,987.50,'2022-09-07 18:11:07','',''),(4849,'1','275','1',1,'Retail Sale Id 4702',9300.00,0.00,0.00,12.50,987.50,'2022-09-07 18:30:21','',''),(4850,'1','275','1',1,'Retail Sale Id 4703',4501.20,0.00,0.00,6.05,477.95,'2022-09-07 18:35:39','',''),(4851,'1','275','1',1,'Retail Sale Id 4704',9300.00,0.00,0.00,12.50,987.50,'2022-09-07 18:41:02','',''),(4852,'1','275','1',1,'Retail Sale Id 4705',9017.28,0.00,0.00,12.12,957.48,'2022-09-07 19:26:38','',''),(4853,'1','275','1',1,'Retail Sale Id 4706',28945.00,0.00,0.00,41.35,1447.25,'2022-09-07 19:27:11','',''),(4854,'1','275','1',1,'Retail Sale Id 4707',27900.00,0.00,0.00,37.50,2962.50,'2022-09-08 06:45:44','',''),(4855,'1','275','1',1,'Retail Sale Id 4708',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 07:38:53','',''),(4856,'1','275','1',1,'Retail Sale Id 4709',1502.88,0.00,0.00,2.02,159.58,'2022-09-08 07:41:24','',''),(4857,'1','275','1',1,'Retail Sale Id 4710',2298.96,0.00,0.00,3.09,244.11,'2022-09-08 07:45:54','',''),(4858,'1','275','1',1,'Retail Sale Id 4711',18600.00,0.00,0.00,25.00,1975.00,'2022-09-08 07:51:13','',''),(4859,'1','275','1',1,'Retail Sale Id 4712',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 08:05:42','',''),(4860,'1','275','1',1,'Retail Sale Id 4713',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 08:13:59','',''),(4861,'1','275','1',1,'Retail Sale Id 4714',5996.64,0.00,0.00,8.06,636.74,'2022-09-08 08:18:52','',''),(4862,'1','275','1',1,'Retail Sale Id 4715',4501.20,0.00,0.00,6.05,477.95,'2022-09-08 08:22:28','',''),(4863,'1','275','1',1,'Retail Sale Id 4716',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 08:36:57','',''),(4864,'1','275','1',1,'Retail Sale Id 4717',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 08:44:02','',''),(4865,'1','275','1',1,'Retail Sale Id 4718',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 08:45:26','',''),(4866,'1','275','1',1,'Retail Sale Id 4719',7.44,0.00,0.00,0.01,0.79,'2022-09-08 09:18:15','',''),(4867,'1','275','1',1,'Retail Sale Id 4720',3720.00,0.00,0.00,5.00,395.00,'2022-09-08 09:19:06','',''),(4868,'1','275','1',1,'Retail Sale Id 4721',4501.20,0.00,0.00,6.05,477.95,'2022-09-08 09:20:37','',''),(4869,'1','275','1',1,'Retail Sale Id 4722',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 09:21:47','',''),(4870,'1','275','1',1,'Retail Sale Id 4723',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 09:23:21','',''),(4871,'1','275','1',1,'Retail Sale Id 4724',1502.88,0.00,0.00,2.02,159.58,'2022-09-08 09:25:39','',''),(4872,'1','275','1',1,'Retail Sale Id 4725',2998.32,0.00,0.00,4.03,318.37,'2022-09-08 09:30:45','',''),(4873,'1','275','1',1,'Retail Sale Id 4726',1502.88,0.00,0.00,2.02,159.58,'2022-09-08 09:34:13','',''),(4874,'1','275','1',1,'Retail Sale Id 4727',8556.00,0.00,0.00,11.50,908.50,'2022-09-08 09:36:41','',''),(4875,'1','275','1',1,'Retail Sale Id 4728',4501.20,0.00,0.00,6.05,477.95,'2022-09-08 10:01:45','',''),(4876,'1','275','1',1,'Retail Sale Id 4729',2298.96,0.00,0.00,3.09,244.11,'2022-09-08 10:07:30','',''),(4877,'1','275','1',1,'Retail Sale Id 4730',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 10:13:29','',''),(4878,'1','275','1',1,'Retail Sale Id 4731',98580.00,0.00,0.00,132.50,10467.50,'2022-09-08 10:21:47','',''),(4879,'1','275','1',1,'Retail Sale Id 4732',9002.40,0.00,0.00,12.10,955.90,'2022-09-08 10:27:42','',''),(4880,'1','275','1',1,'Retail Sale Id 4733',11598.96,0.00,0.00,15.59,1231.61,'2022-09-08 10:29:18','',''),(4881,'1','275','1',1,'Retail Sale Id 4734',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 10:35:52','',''),(4882,'1','275','1',1,'Retail Sale Id 4735',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 11:10:59','',''),(4883,'1','275','1',1,'Retail Sale Id 4736',996.96,0.00,0.00,1.34,105.86,'2022-09-08 11:17:50','',''),(4884,'1','275','1',1,'Retail Sale Id 4737',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 11:24:23','',''),(4885,'1','275','1',1,'Retail Sale Id 4738',4501.20,0.00,0.00,6.05,477.95,'2022-09-08 11:30:27','',''),(4886,'1','275','1',1,'Retail Sale Id 4739',744.00,0.00,0.00,1.00,79.00,'2022-09-08 11:32:23','',''),(4887,'1','275','1',1,'Retail Sale Id 4740',2998.32,0.00,0.00,4.03,318.37,'2022-09-08 11:33:40','',''),(4888,'1','275','1',1,'Retail Sale Id 4741',10788.00,0.00,0.00,14.50,1145.50,'2022-09-08 11:38:00','',''),(4889,'1','275','1',1,'Retail Sale Id 4742',4999.68,0.00,0.00,6.72,530.88,'2022-09-08 12:04:03','',''),(4890,'1','275','1',1,'Retail Sale Id 4743',2298.96,0.00,0.00,3.09,244.11,'2022-09-08 12:17:20','',''),(4891,'1','275','1',1,'Retail Sale Id 4744',2998.32,0.00,0.00,4.03,318.37,'2022-09-08 12:22:42','',''),(4892,'1','275','1',1,'Retail Sale Id 4745',22320.00,0.00,0.00,30.00,2370.00,'2022-09-08 13:29:56','',''),(4893,'1','275','1',1,'Retail Sale Id 4747',18600.00,0.00,0.00,25.00,1975.00,'2022-09-08 14:06:29','',''),(4894,'1','275','1',1,'Retail Sale Id 4748',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 14:28:28','',''),(4895,'1','275','1',1,'Retail Sale Id 4749',2998.32,0.00,0.00,4.03,318.37,'2022-09-08 14:33:20','',''),(4896,'1','275','1',1,'Retail Sale Id 4750',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 14:35:45','',''),(4897,'1','275','1',1,'Retail Sale Id 4751',2298.96,0.00,0.00,3.09,244.11,'2022-09-08 15:02:26','',''),(4898,'1','275','1',1,'Retail Sale Id 4752',4501.20,0.00,0.00,6.05,477.95,'2022-09-08 15:17:49','',''),(4899,'1','275','1',1,'Retail Sale Id 4753',19344.00,0.00,0.00,26.00,2054.00,'2022-09-08 15:19:01','',''),(4900,'1','275','1',1,'Retail Sale Id 4754',7440.00,0.00,0.00,10.00,790.00,'2022-09-08 15:23:19','',''),(4901,'1','275','1',1,'Retail Sale Id 4755',7998.00,0.00,0.00,10.75,849.25,'2022-09-08 15:25:24','',''),(4902,'1','275','1',1,'Retail Sale Id 4756',996.96,0.00,0.00,1.34,105.86,'2022-09-08 15:31:04','',''),(4903,'1','275','1',1,'Retail Sale Id 4757',996.96,0.00,0.00,1.34,105.86,'2022-09-08 15:31:50','',''),(4904,'1','275','1',1,'Retail Sale Id 4758',1502.88,0.00,0.00,2.02,159.58,'2022-09-08 15:35:12','',''),(4905,'1','275','1',1,'Retail Sale Id 4759',4501.20,0.00,0.00,6.05,477.95,'2022-09-08 15:47:22','',''),(4906,'1','275','1',1,'Retail Sale Id 4760',1502.88,0.00,0.00,2.02,159.58,'2022-09-08 16:13:44','',''),(4907,'1','275','1',1,'Retail Sale Id 4761',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 16:16:02','',''),(4908,'1','275','1',1,'Retail Sale Id 4762',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 16:19:36','',''),(4909,'1','275','1',1,'Retail Sale Id 4763',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 16:20:46','',''),(4910,'1','275','1',1,'Retail Sale Id 4764',4501.20,0.00,0.00,6.05,477.95,'2022-09-08 16:25:42','',''),(4911,'1','275','1',1,'Retail Sale Id 4765',13801.20,0.00,0.00,18.55,1465.45,'2022-09-08 16:28:33','',''),(4912,'1','275','1',1,'Retail Sale Id 4766',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 16:51:20','',''),(4913,'1','275','1',1,'Retail Sale Id 4767',18600.00,0.00,0.00,25.00,1975.00,'2022-09-08 17:00:27','',''),(4914,'1','275','1',1,'Retail Sale Id 4768',4002.72,0.00,0.00,5.38,425.02,'2022-09-08 17:04:14','',''),(4915,'1','275','1',1,'Retail Sale Id 4768',4501.20,0.00,0.00,6.05,477.95,'2022-09-08 17:04:14','',''),(4916,'1','275','1',1,'Retail Sale Id 4769',4501.20,0.00,0.00,6.05,477.95,'2022-09-08 17:11:47','',''),(4917,'1','275','1',1,'Retail Sale Id 4770',4501.20,0.00,0.00,6.05,477.95,'2022-09-08 17:26:58','',''),(4918,'1','275','1',1,'Retail Sale Id 4771',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 17:31:07','',''),(4919,'1','275','1',1,'Retail Sale Id 4772',18600.00,0.00,0.00,25.00,1975.00,'2022-09-08 17:37:12','',''),(4920,'1','275','1',1,'Retail Sale Id 4773',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 17:38:47','',''),(4921,'1','275','1',1,'Retail Sale Id 4774',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 17:43:30','',''),(4922,'1','275','1',1,'Retail Sale Id 4775',2298.96,0.00,0.00,3.09,244.11,'2022-09-08 17:49:04','',''),(4923,'1','275','1',1,'Retail Sale Id 4776',1502.88,0.00,0.00,2.02,159.58,'2022-09-08 17:55:35','',''),(4924,'1','275','1',1,'Retail Sale Id 4777',34224.00,0.00,0.00,46.00,3634.00,'2022-09-08 18:15:20','',''),(4925,'1','275','1',1,'Retail Sale Id 4778',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 18:18:00','',''),(4926,'1','275','1',1,'Retail Sale Id 4779',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 18:20:55','',''),(4927,'1','275','1',1,'Retail Sale Id 4780',1502.88,0.00,0.00,2.02,159.58,'2022-09-08 18:24:38','',''),(4928,'1','275','1',1,'Retail Sale Id 4781',4501.20,0.00,0.00,6.05,477.95,'2022-09-08 18:51:35','',''),(4929,'1','275','1',1,'Retail Sale Id 4782',16978.08,0.00,0.00,22.82,1802.78,'2022-09-08 19:11:55','',''),(4930,'1','275','1',1,'Retail Sale Id 4783',1502.88,0.00,0.00,2.02,159.58,'2022-09-09 07:24:56','',''),(4931,'1','275','1',1,'Retail Sale Id 4784',9300.00,0.00,0.00,12.50,987.50,'2022-09-09 07:26:49','',''),(4932,'1','275','1',1,'Retail Sale Id 4785',52080.00,0.00,0.00,70.00,5530.00,'2022-09-09 07:39:28','',''),(4933,'1','275','1',1,'Retail Sale Id 4786',9300.00,0.00,0.00,12.50,987.50,'2022-09-09 08:05:30','',''),(4934,'1','275','1',1,'Retail Sale Id 4787',9300.00,0.00,0.00,12.50,987.50,'2022-09-09 08:07:48','',''),(4935,'1','275','1',1,'Retail Sale Id 4788',2298.96,0.00,0.00,3.09,244.11,'2022-09-09 08:28:59','',''),(4936,'1','275','1',1,'Retail Sale Id 4789',1502.88,0.00,0.00,2.02,159.58,'2022-09-09 08:32:21','',''),(4937,'1','275','1',1,'Retail Sale Id 4790',9300.00,0.00,0.00,12.50,987.50,'2022-09-09 09:00:49','',''),(4938,'1','275','1',1,'Retail Sale Id 4791',9300.00,0.00,0.00,12.50,987.50,'2022-09-09 09:05:09','',''),(4939,'1','275','1',1,'Retail Sale Id 4792',13764.00,0.00,0.00,18.50,1461.50,'2022-09-09 09:13:59','',''),(4940,'1','275','1',1,'Retail Sale Id 4793',996.96,0.00,0.00,1.34,105.86,'2022-09-09 09:16:04','',''),(4941,'1','275','1',1,'Retail Sale Id 4794',2998.32,0.00,0.00,4.03,318.37,'2022-09-09 09:16:53','',''),(4942,'1','275','1',1,'Retail Sale Id 4795',2298.96,0.00,0.00,3.09,244.11,'2022-09-09 10:01:20','',''),(4943,'1','275','1',1,'Retail Sale Id 4796',4501.20,0.00,0.00,6.05,477.95,'2022-09-09 10:11:45','',''),(4944,'1','275','1',1,'Retail Sale Id 4797',55800.00,0.00,0.00,75.00,5925.00,'2022-09-09 10:16:49','',''),(4945,'1','275','1',1,'Retail Sale Id 4798',18228.00,0.00,0.00,24.50,1935.50,'2022-09-09 10:17:52','',''),(4946,'1','275','1',1,'Retail Sale Id 4799',2998.32,0.00,0.00,4.03,318.37,'2022-09-09 10:48:39','',''),(4947,'1','275','1',1,'Retail Sale Id 4800',4501.20,0.00,0.00,6.05,477.95,'2022-09-09 10:50:11','',''),(4948,'1','275','1',1,'Retail Sale Id 4801',1302.00,0.00,0.00,1.75,138.25,'2022-09-09 10:55:25','',''),(4949,'1','275','1',1,'Retail Sale Id 4802',9300.00,0.00,0.00,12.50,987.50,'2022-09-09 11:05:04','',''),(4950,'1','275','1',1,'Retail Sale Id 4803',8556.00,0.00,0.00,11.50,908.50,'2022-09-09 11:17:40','',''),(4951,'1','275','1',1,'Retail Sale Id 4804',9300.00,0.00,0.00,12.50,987.50,'2022-09-09 11:37:14','',''),(4952,'1','275','1',1,'Retail Sale Id 4805',9300.00,0.00,0.00,12.50,987.50,'2022-09-09 12:07:57','',''),(4953,'1','275','1',1,'Retail Sale Id 4806',9300.00,0.00,0.00,12.50,987.50,'2022-09-09 12:38:04','',''),(4954,'1','275','1',1,'Retail Sale Id 4807',9300.00,0.00,0.00,12.50,987.50,'2022-09-09 12:56:06','',''),(4955,'1','275','1',1,'Retail Sale Id 4808',4501.20,0.00,0.00,6.05,477.95,'2022-09-09 13:10:29','',''),(4956,'1','275','1',1,'Retail Sale Id 4809',4501.20,0.00,0.00,6.05,477.95,'2022-09-09 13:12:27','',''),(4957,'1','275','1',1,'Retail Sale Id 4810',9300.00,0.00,0.00,12.50,987.50,'2022-09-09 13:39:55','',''),(4958,'1','275','1',1,'Retail Sale Id 4811',2298.96,0.00,0.00,3.09,244.11,'2022-09-09 13:52:34','',''),(4959,'1','275','1',1,'Retail Sale Id 4812',6301.68,0.00,0.00,8.47,669.13,'2022-09-09 14:04:07','',''),(4960,'1','275','1',1,'Retail Sale Id 4813',17208.72,0.00,0.00,23.13,1827.27,'2022-09-09 14:53:27','',''),(4961,'1','275','1',1,'Distributed to OPPRETIONAL LOST  for sales id:17',35258.30,0.00,0.00,53.02,0.00,'2022-09-09 20:57:37','',''),(4962,'1','275',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,1995000.00,3000.00,0.00,0.00,'2022-09-09 21:00:48','',''),(4963,'1','275',NULL,1,'Reception corrector for bridging 19',0.00,0.00,0.00,3000.00,0.00,'2022-09-09 21:01:48','',''),(4964,'1','275','1',1,'Received from bridging 19',0.00,0.00,3000.00,0.00,0.00,'2022-09-09 21:01:48','',''),(4965,'1','275','1',1,'Retail Sale Id 4814',2202.24,0.00,0.00,2.96,233.84,'2022-09-10 10:27:43','',''),(4966,'1','275','1',1,'Retail Sale Id 4815',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 10:31:14','',''),(4967,'1','275','1',1,'Retail Sale Id 4816',996.96,0.00,0.00,1.34,105.86,'2022-09-10 10:33:14','',''),(4968,'1','275','1',1,'Retail Sale Id 4817',74400.00,0.00,0.00,100.00,7900.00,'2022-09-10 11:09:08','',''),(4969,'1','275','1',1,'Retail Sale Id 4818',4002.72,0.00,0.00,5.38,425.02,'2022-09-10 11:25:00','',''),(4970,'1','275','1',1,'Retail Sale Id 4819',37200.00,0.00,0.00,50.00,3950.00,'2022-09-10 11:27:35','',''),(4971,'1','275','1',1,'Retail Sale Id 4820',4501.20,0.00,0.00,6.05,477.95,'2022-09-10 11:33:10','',''),(4972,'1','275','1',1,'Retail Sale Id 4821',4501.20,0.00,0.00,6.05,477.95,'2022-09-10 11:35:13','',''),(4973,'1','275','1',1,'Retail Sale Id 4822',37200.00,0.00,0.00,50.00,3950.00,'2022-09-10 11:39:16','',''),(4974,'1','275','1',1,'Retail Sale Id 4823',33480.00,0.00,0.00,45.00,3555.00,'2022-09-10 11:44:52','',''),(4975,'1','275','1',1,'Retail Sale Id 4824',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 11:50:29','',''),(4976,'1','275','1',1,'Retail Sale Id 4825',3801.84,0.00,0.00,5.11,403.69,'2022-09-10 11:53:22','',''),(4977,'1','275','1',1,'Retail Sale Id 4826',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 11:59:48','',''),(4978,'1','275','1',1,'Retail Sale Id 4827',4999.68,0.00,0.00,6.72,530.88,'2022-09-10 12:04:56','',''),(4979,'1','275','1',1,'Retail Sale Id 4828',6502.56,0.00,0.00,8.74,690.46,'2022-09-10 12:06:52','',''),(4980,'1','275','1',1,'Retail Sale Id 4829',4501.20,0.00,0.00,6.05,477.95,'2022-09-10 12:20:19','',''),(4981,'1','275','1',1,'Retail Sale Id 4830',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 12:24:30','',''),(4982,'1','275','1',1,'Retail Sale Id 4831',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 12:28:37','',''),(4983,'1','275','1',1,'Retail Sale Id 4832',10416.00,0.00,0.00,14.00,1106.00,'2022-09-10 12:30:35','',''),(4984,'1','275','1',1,'Retail Sale Id 4833',4999.68,0.00,0.00,6.72,530.88,'2022-09-10 12:39:01','',''),(4985,'1','275','1',1,'Retail Sale Id 4834',3720.00,0.00,0.00,5.00,395.00,'2022-09-10 12:41:13','',''),(4986,'1','275','1',1,'Retail Sale Id 4835',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 12:57:06','',''),(4987,'1','275','1',1,'Retail Sale Id 4836',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 13:05:25','',''),(4988,'1','275','1',1,'Retail Sale Id 4838',4501.20,0.00,0.00,6.05,477.95,'2022-09-10 13:14:47','',''),(4989,'1','275','1',1,'Retail Sale Id 4839',2298.96,0.00,0.00,3.09,244.11,'2022-09-10 13:15:56','',''),(4990,'1','275','1',1,'Retail Sale Id 4840',37200.00,0.00,0.00,50.00,3950.00,'2022-09-10 13:18:19','',''),(4991,'1','275','1',1,'Retail Sale Id 4841',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 13:20:32','',''),(4992,'1','275','1',1,'Retail Sale Id 4842',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 13:24:17','',''),(4993,'1','275','1',1,'Retail Sale Id 4843',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 13:33:37','',''),(4994,'1','275','1',1,'Retail Sale Id 4844',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 13:37:25','',''),(4995,'1','275','1',1,'Retail Sale Id 4845',2998.32,0.00,0.00,4.03,318.37,'2022-09-10 13:55:39','',''),(4996,'1','275','1',1,'Retail Sale Id 4847',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 14:01:25','',''),(4997,'1','275','1',1,'Retail Sale Id 4848',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 14:03:11','',''),(4998,'1','275','1',1,'Retail Sale Id 4849',1897.20,0.00,0.00,2.55,201.45,'2022-09-10 14:06:08','',''),(4999,'1','275','1',1,'Retail Sale Id 4850',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 14:08:24','',''),(5000,'1','275','1',1,'Retail Sale Id 4851',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 14:18:38','',''),(5001,'1','275','1',1,'Retail Sale Id 4852',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 14:19:51','',''),(5002,'1','275','1',1,'Retail Sale Id 4853',1502.88,0.00,0.00,2.02,159.58,'2022-09-10 14:24:49','',''),(5003,'1','275','1',1,'Retail Sale Id 4854',18600.00,0.00,0.00,25.00,1975.00,'2022-09-10 14:25:49','',''),(5004,'1','275','1',1,'Retail Sale Id 4855',11904.00,0.00,0.00,16.00,1264.00,'2022-09-10 14:30:30','',''),(5005,'1','275','1',1,'Retail Sale Id 4856',2998.32,0.00,0.00,4.03,318.37,'2022-09-10 14:38:43','',''),(5006,'1','275','1',1,'Retail Sale Id 4857',2001.36,0.00,0.00,2.69,212.51,'2022-09-10 14:39:50','',''),(5007,'1','275','1',1,'Retail Sale Id 4858',29998.08,0.00,0.00,40.32,3185.28,'2022-09-10 14:42:11','',''),(5008,'1','275','1',1,'Retail Sale Id 4859',4501.20,0.00,0.00,6.05,477.95,'2022-09-10 15:01:16','',''),(5009,'1','275','1',1,'Retail Sale Id 4860',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 15:12:55','',''),(5010,'1','275','1',1,'Retail Sale Id 4861',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 16:10:33','',''),(5011,'1','275','1',1,'Retail Sale Id 4862',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 16:25:42','',''),(5012,'1','275','1',1,'Retail Sale Id 4863',7440.00,0.00,0.00,10.00,790.00,'2022-09-10 16:29:49','',''),(5013,'1','275','1',1,'Retail Sale Id 4864',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 16:32:38','',''),(5014,'1','275','1',1,'Retail Sale Id 4865',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 16:34:28','',''),(5015,'1','275','1',1,'Retail Sale Id 4867',7998.00,0.00,0.00,10.75,849.25,'2022-09-10 16:36:02','',''),(5016,'1','275','1',1,'Retail Sale Id 4868',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 16:37:22','',''),(5017,'1','275','1',1,'Retail Sale Id 4869',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 16:38:11','',''),(5018,'1','275','1',1,'Retail Sale Id 4870',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 16:39:00','',''),(5019,'1','275','1',1,'Retail Sale Id 4871',27900.00,0.00,0.00,37.50,2962.50,'2022-09-10 16:51:36','',''),(5020,'1','275','1',1,'Retail Sale Id 4872',4501.20,0.00,0.00,6.05,477.95,'2022-09-10 16:56:40','',''),(5021,'1','275','1',1,'Retail Sale Id 4873',11160.00,0.00,0.00,15.00,1185.00,'2022-09-10 17:05:11','',''),(5022,'1','275','1',1,'Retail Sale Id 4874',996.96,0.00,0.00,1.34,105.86,'2022-09-10 17:13:28','',''),(5023,'1','275','1',1,'Retail Sale Id 4875',5996.64,0.00,0.00,8.06,636.74,'2022-09-10 17:19:27','',''),(5024,'1','275','1',1,'Retail Sale Id 4876',4501.20,0.00,0.00,6.05,477.95,'2022-09-10 17:26:49','',''),(5025,'1','275','1',1,'Retail Sale Id 4877',2001.36,0.00,0.00,2.69,212.51,'2022-09-10 17:44:46','',''),(5026,'1','275','1',1,'Retail Sale Id 4878',3801.84,0.00,0.00,5.11,403.69,'2022-09-10 17:48:38','',''),(5027,'1','275','1',1,'Retail Sale Id 4879',803.52,0.00,0.00,1.08,85.32,'2022-09-10 18:18:49','',''),(5028,'1','275','1',1,'Retail Sale Id 4880',4501.20,0.00,0.00,6.05,477.95,'2022-09-10 18:24:46','',''),(5029,'1','275','1',1,'Retail Sale Id 4881',37200.00,0.00,0.00,50.00,3950.00,'2022-09-10 18:31:35','',''),(5030,'1','275','1',1,'Retail Sale Id 4882',74400.00,0.00,0.00,100.00,7900.00,'2022-09-10 19:07:46','',''),(5031,'1','275','1',1,'Retail Sale Id 4883',74400.00,0.00,0.00,100.00,7900.00,'2022-09-10 19:08:22','',''),(5032,'1','275','1',1,'Retail Sale Id 4884',58649.52,0.00,0.00,78.83,6227.57,'2022-09-10 19:08:58','',''),(5033,'1','275','1',1,'Retail Sale Id 4885',37200.00,0.00,0.00,50.00,3950.00,'2022-09-11 06:59:55','',''),(5034,'1','275','1',1,'Retail Sale Id 4886',26040.00,0.00,0.00,35.00,2765.00,'2022-09-11 07:00:38','',''),(5035,'1','275','1',1,'Retail Sale Id 4887',1502.88,0.00,0.00,2.02,159.58,'2022-09-11 07:23:15','',''),(5036,'1','275','1',1,'Retail Sale Id 4888',2298.96,0.00,0.00,3.09,244.11,'2022-09-11 07:34:04','',''),(5037,'1','275','1',1,'Retail Sale Id 4889',2001.36,0.00,0.00,2.69,212.51,'2022-09-11 07:39:58','',''),(5038,'1','275','1',1,'Retail Sale Id 4890',3720.00,0.00,0.00,5.00,395.00,'2022-09-11 07:42:07','',''),(5039,'1','275','1',1,'Retail Sale Id 4891',1502.88,0.00,0.00,2.02,159.58,'2022-09-11 08:01:19','',''),(5040,'1','275','1',1,'Retail Sale Id 4892',2298.96,0.00,0.00,3.09,244.11,'2022-09-11 08:21:06','',''),(5041,'1','275','1',1,'Retail Sale Id 4893',2001.36,0.00,0.00,2.69,212.51,'2022-09-11 08:24:51','',''),(5042,'1','275','1',1,'Retail Sale Id 4894',1502.88,0.00,0.00,2.02,159.58,'2022-09-11 08:26:28','',''),(5043,'1','275','1',1,'Retail Sale Id 4895',996.96,0.00,0.00,1.34,105.86,'2022-09-11 08:27:20','',''),(5044,'1','275','1',1,'Retail Sale Id 4896',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 09:39:06','',''),(5045,'1','275','1',1,'Retail Sale Id 4897',14880.00,0.00,0.00,20.00,1580.00,'2022-09-11 09:41:14','',''),(5046,'1','275','1',1,'Retail Sale Id 4898',1502.88,0.00,0.00,2.02,159.58,'2022-09-11 09:42:35','',''),(5047,'1','275','1',1,'Retail Sale Id 4899',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 09:43:49','',''),(5048,'1','275','1',1,'Retail Sale Id 4900',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 09:45:48','',''),(5049,'1','275','1',1,'Retail Sale Id 4901',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 09:48:57','',''),(5050,'1','275','1',1,'Retail Sale Id 4902',4501.20,0.00,0.00,6.05,477.95,'2022-09-11 09:53:45','',''),(5051,'1','275','1',1,'Retail Sale Id 4903',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 09:55:49','',''),(5052,'1','275','1',1,'Retail Sale Id 4904',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 09:57:00','',''),(5053,'1','275','1',1,'Retail Sale Id 4905',1101.12,0.00,0.00,1.48,116.92,'2022-09-11 09:58:33','',''),(5054,'1','275','1',1,'Retail Sale Id 4906',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 10:04:24','',''),(5055,'1','275','1',1,'Retail Sale Id 4907',7440.00,0.00,0.00,10.00,790.00,'2022-09-11 10:05:41','',''),(5056,'1','275','1',1,'Retail Sale Id 4908',17856.00,0.00,0.00,24.00,1896.00,'2022-09-11 10:14:08','',''),(5057,'1','275','1',1,'Retail Sale Id 4909',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 10:24:15','',''),(5058,'1','275','1',1,'Retail Sale Id 4910',3801.84,0.00,0.00,5.11,403.69,'2022-09-11 10:28:15','',''),(5059,'1','275','1',1,'Retail Sale Id 4911',2001.36,0.00,0.00,2.69,212.51,'2022-09-11 10:37:21','',''),(5060,'1','275','1',1,'Retail Sale Id 4912',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 10:38:45','',''),(5061,'1','275','1',1,'Retail Sale Id 4913',1502.88,0.00,0.00,2.02,159.58,'2022-09-11 10:39:36','',''),(5062,'1','275','1',1,'Retail Sale Id 4914',9002.40,0.00,0.00,12.10,955.90,'2022-09-11 10:43:14','',''),(5063,'1','275','1',1,'Retail Sale Id 4915',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 10:44:46','',''),(5064,'1','275','1',1,'Retail Sale Id 4916',4999.68,0.00,0.00,6.72,530.88,'2022-09-11 10:49:10','',''),(5065,'1','275','1',1,'Retail Sale Id 4917',2298.96,0.00,0.00,3.09,244.11,'2022-09-11 10:54:29','',''),(5066,'1','275','1',1,'Retail Sale Id 4918',1502.88,0.00,0.00,2.02,159.58,'2022-09-11 11:04:06','',''),(5067,'1','275','1',1,'Retail Sale Id 4919',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 11:23:10','',''),(5068,'1','275','1',1,'Retail Sale Id 4920',6696.00,0.00,0.00,9.00,711.00,'2022-09-11 11:27:34','',''),(5069,'1','275','1',1,'Retail Sale Id 4921',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 11:29:13','',''),(5070,'1','275','1',1,'Retail Sale Id 4922',996.96,0.00,0.00,1.34,105.86,'2022-09-11 11:30:05','',''),(5071,'1','275','1',1,'Retail Sale Id 4923',4501.20,0.00,0.00,6.05,477.95,'2022-09-11 11:31:37','',''),(5072,'1','275','1',1,'Retail Sale Id 4924',8928.00,0.00,0.00,12.00,948.00,'2022-09-11 11:32:33','',''),(5073,'1','275','1',1,'Retail Sale Id 4925',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 11:34:25','',''),(5074,'1','275','1',1,'Retail Sale Id 4926',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 11:35:31','',''),(5075,'1','275','1',1,'Retail Sale Id 4927',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 11:37:26','',''),(5076,'1','275','1',1,'Retail Sale Id 4928',4501.20,0.00,0.00,6.05,477.95,'2022-09-11 11:38:47','',''),(5077,'1','275','1',1,'Retail Sale Id 4929',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 11:59:23','',''),(5078,'1','275','1',1,'Retail Sale Id 4930',2001.36,0.00,0.00,2.69,212.51,'2022-09-11 12:00:13','',''),(5079,'1','275','1',1,'Retail Sale Id 4931',2001.36,0.00,0.00,2.69,212.51,'2022-09-11 12:01:57','',''),(5080,'1','275','1',1,'Retail Sale Id 4931',2998.32,0.00,0.00,4.03,318.37,'2022-09-11 12:01:57','',''),(5081,'1','275','1',1,'Retail Sale Id 4932',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 12:03:24','',''),(5082,'1','275','1',1,'Retail Sale Id 4933',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 12:04:06','',''),(5083,'1','275','1',1,'Retail Sale Id 4934',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 12:10:14','',''),(5084,'1','275','1',1,'Retail Sale Id 4935',7499.52,0.00,0.00,10.08,796.32,'2022-09-11 12:11:13','',''),(5085,'1','275','1',1,'Retail Sale Id 4936',4501.20,0.00,0.00,6.05,477.95,'2022-09-11 12:19:35','',''),(5086,'1','275','1',1,'Retail Sale Id 4937',20460.00,0.00,0.00,27.50,2172.50,'2022-09-11 12:35:18','',''),(5087,'1','275','1',1,'Retail Sale Id 4938',4999.68,0.00,0.00,6.72,530.88,'2022-09-11 12:37:54','',''),(5088,'1','275','1',1,'Retail Sale Id 4939',13764.00,0.00,0.00,18.50,1461.50,'2022-09-11 12:40:03','',''),(5089,'1','275','1',1,'Retail Sale Id 4940',6696.00,0.00,0.00,9.00,711.00,'2022-09-11 12:41:13','',''),(5090,'1','275','1',1,'Retail Sale Id 4941',2001.36,0.00,0.00,2.69,212.51,'2022-09-11 12:43:48','',''),(5091,'1','275','1',1,'Retail Sale Id 4942',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 12:48:07','',''),(5092,'1','275','1',1,'Retail Sale Id 4943',803.52,0.00,0.00,1.08,85.32,'2022-09-11 12:56:10','',''),(5093,'1','275','1',1,'Retail Sale Id 4944',4999.68,0.00,0.00,6.72,530.88,'2022-09-11 12:57:58','',''),(5094,'1','275','1',1,'Retail Sale Id 4945',2001.36,0.00,0.00,2.69,212.51,'2022-09-11 12:59:03','',''),(5095,'1','275','1',1,'Retail Sale Id 4946',6800.16,0.00,0.00,9.14,722.06,'2022-09-11 13:03:05','',''),(5096,'1','275','1',1,'Retail Sale Id 4947',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 13:04:37','',''),(5097,'1','275','1',1,'Retail Sale Id 4948',4501.20,0.00,0.00,6.05,477.95,'2022-09-11 13:15:22','',''),(5098,'1','275','1',1,'Retail Sale Id 4949',2298.96,0.00,0.00,3.09,244.11,'2022-09-11 13:17:42','',''),(5099,'1','275','1',1,'Retail Sale Id 4950',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 13:22:55','',''),(5100,'1','275','1',1,'Retail Sale Id 4951',2001.36,0.00,0.00,2.69,212.51,'2022-09-11 13:26:12','',''),(5101,'1','275','1',1,'Retail Sale Id 4952',18600.00,0.00,0.00,25.00,1975.00,'2022-09-11 13:27:32','',''),(5102,'1','275','1',1,'Retail Sale Id 4953',4999.68,0.00,0.00,6.72,530.88,'2022-09-11 13:28:57','',''),(5103,'1','275','1',1,'Retail Sale Id 4954',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 13:30:23','',''),(5104,'1','275','1',1,'Retail Sale Id 4955',4999.68,0.00,0.00,6.72,530.88,'2022-09-11 13:37:18','',''),(5105,'1','275','1',1,'Retail Sale Id 4956',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 13:39:57','',''),(5106,'1','275','1',1,'Retail Sale Id 4957',1502.88,0.00,0.00,2.02,159.58,'2022-09-11 13:42:46','',''),(5107,'1','275','1',1,'Retail Sale Id 4958',4501.20,0.00,0.00,6.05,477.95,'2022-09-11 13:44:44','',''),(5108,'1','275','1',1,'Retail Sale Id 4959',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 13:45:56','',''),(5109,'1','275','1',1,'Retail Sale Id 4960',9999.36,0.00,0.00,13.44,1061.76,'2022-09-11 13:48:07','',''),(5110,'1','275','1',1,'Retail Sale Id 4961',4999.68,0.00,0.00,6.72,530.88,'2022-09-11 13:49:50','',''),(5111,'1','275','1',1,'Retail Sale Id 4962',2298.96,0.00,0.00,3.09,244.11,'2022-09-11 13:52:06','',''),(5112,'1','275','1',1,'Retail Sale Id 4963',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 13:53:24','',''),(5113,'1','275','1',1,'Retail Sale Id 4964',22320.00,0.00,0.00,30.00,2370.00,'2022-09-11 13:54:34','',''),(5114,'1','275','1',1,'Retail Sale Id 4965',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 13:56:22','',''),(5115,'1','275','1',1,'Retail Sale Id 4966',2001.36,0.00,0.00,2.69,212.51,'2022-09-11 13:57:09','',''),(5116,'1','275','1',1,'Retail Sale Id 4967',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 14:04:04','',''),(5117,'1','275','1',1,'Retail Sale Id 4968',4501.20,0.00,0.00,6.05,477.95,'2022-09-11 14:05:34','',''),(5118,'1','275','1',1,'Retail Sale Id 4969',3720.00,0.00,0.00,5.00,395.00,'2022-09-11 14:07:07','',''),(5119,'1','275','1',1,'Retail Sale Id 4970',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 14:09:34','',''),(5120,'1','275','1',1,'Retail Sale Id 4971',14999.04,0.00,0.00,20.16,1592.64,'2022-09-11 14:12:42','',''),(5121,'1','275','1',1,'Retail Sale Id 4972',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 14:17:33','',''),(5122,'1','275','1',1,'Retail Sale Id 4973',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 14:19:08','',''),(5123,'1','275','1',1,'Retail Sale Id 4974',2298.96,0.00,0.00,3.09,244.11,'2022-09-11 14:21:35','',''),(5124,'1','275','1',1,'Retail Sale Id 4975',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 14:25:41','',''),(5125,'1','275','1',1,'Retail Sale Id 4976',7998.00,0.00,0.00,10.75,849.25,'2022-09-11 14:27:11','',''),(5126,'1','275','1',1,'Retail Sale Id 4977',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 14:29:18','',''),(5127,'1','275','1',1,'Retail Sale Id 4978',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 14:32:07','',''),(5128,'1','275','1',1,'Retail Sale Id 4979',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 14:32:45','',''),(5129,'1','275','1',1,'Retail Sale Id 4980',2001.36,0.00,0.00,2.69,212.51,'2022-09-11 14:35:55','',''),(5130,'1','275','1',1,'Retail Sale Id 4981',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 14:39:10','',''),(5131,'1','275','1',1,'Retail Sale Id 4982',8198.88,0.00,0.00,11.02,870.58,'2022-09-11 14:43:46','',''),(5132,'1','275','1',1,'Retail Sale Id 4983',1502.88,0.00,0.00,2.02,159.58,'2022-09-11 14:45:18','',''),(5133,'1','275','1',1,'Retail Sale Id 4984',18600.00,0.00,0.00,25.00,1975.00,'2022-09-11 14:46:39','',''),(5134,'1','275','1',1,'Retail Sale Id 4985',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 14:47:30','',''),(5135,'1','275','1',1,'Retail Sale Id 4986',2298.96,0.00,0.00,3.09,244.11,'2022-09-11 14:48:56','',''),(5136,'1','275','1',1,'Retail Sale Id 4987',37200.00,0.00,0.00,50.00,3950.00,'2022-09-11 14:59:57','',''),(5137,'1','275','1',1,'Retail Sale Id 4988',23064.00,0.00,0.00,31.00,2449.00,'2022-09-11 15:04:43','',''),(5138,'1','275','1',1,'Retail Sale Id 4989',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 15:08:39','',''),(5139,'1','275','1',1,'Retail Sale Id 4990',4501.20,0.00,0.00,6.05,477.95,'2022-09-11 15:09:56','',''),(5140,'1','275','1',1,'Retail Sale Id 4991',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 15:10:45','',''),(5141,'1','275','1',1,'Retail Sale Id 4992',996.96,0.00,0.00,1.34,105.86,'2022-09-11 15:12:42','',''),(5142,'1','275','1',1,'Retail Sale Id 4993',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 15:14:30','',''),(5143,'1','275','1',1,'Retail Sale Id 4994',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 15:15:19','',''),(5144,'1','275','1',1,'Retail Sale Id 4995',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 15:30:31','',''),(5145,'1','275','1',1,'Retail Sale Id 4996',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 15:31:16','',''),(5146,'1','275','1',1,'Retail Sale Id 4997',18600.00,0.00,0.00,25.00,1975.00,'2022-09-11 15:48:13','',''),(5147,'1','275','1',1,'Retail Sale Id 4998',7499.52,0.00,0.00,10.08,796.32,'2022-09-11 16:08:54','',''),(5148,'1','275','1',1,'Retail Sale Id 4999',4501.20,0.00,0.00,6.05,477.95,'2022-09-11 16:14:33','',''),(5149,'1','275','1',1,'Retail Sale Id 5000',14880.00,0.00,0.00,20.00,1580.00,'2022-09-11 16:23:59','',''),(5150,'1','275','1',1,'Retail Sale Id 5001',18600.00,0.00,0.00,25.00,1975.00,'2022-09-11 16:26:18','',''),(5151,'1','275','1',1,'Retail Sale Id 5002',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 16:31:37','',''),(5152,'1','275','1',1,'Retail Sale Id 5003',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 16:32:55','',''),(5153,'1','275','1',1,'Retail Sale Id 5004',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 16:35:48','',''),(5154,'1','275','1',1,'Retail Sale Id 5005',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 16:36:25','',''),(5155,'1','275','1',1,'Retail Sale Id 5006',13020.00,0.00,0.00,17.50,1382.50,'2022-09-11 16:50:22','',''),(5156,'1','275','1',1,'Retail Sale Id 5007',2298.96,0.00,0.00,3.09,244.11,'2022-09-11 16:52:38','',''),(5157,'1','275','1',1,'Retail Sale Id 5008',3720.00,0.00,0.00,5.00,395.00,'2022-09-11 16:56:03','',''),(5158,'1','275','1',1,'Retail Sale Id 5009',37200.00,0.00,0.00,50.00,3950.00,'2022-09-11 16:57:59','',''),(5159,'1','275','1',1,'Retail Sale Id 5010',2298.96,0.00,0.00,3.09,244.11,'2022-09-11 16:59:52','',''),(5160,'1','275','1',1,'Retail Sale Id 5011',2998.32,0.00,0.00,4.03,318.37,'2022-09-11 17:02:32','',''),(5161,'1','275','1',1,'Retail Sale Id 5012',2998.32,0.00,0.00,4.03,318.37,'2022-09-11 17:04:24','',''),(5162,'1','275','1',1,'Retail Sale Id 5013',4999.68,0.00,0.00,6.72,530.88,'2022-09-11 17:07:51','',''),(5163,'1','275','1',1,'Retail Sale Id 5014',29760.00,0.00,0.00,40.00,3160.00,'2022-09-11 17:12:30','',''),(5164,'1','275','1',1,'Retail Sale Id 5015',4501.20,0.00,0.00,6.05,477.95,'2022-09-11 17:14:36','',''),(5165,'1','275','1',1,'Retail Sale Id 5016',4501.20,0.00,0.00,6.05,477.95,'2022-09-11 17:17:55','',''),(5166,'1','275','1',1,'Retail Sale Id 5017',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 17:19:47','',''),(5167,'1','275','1',1,'Retail Sale Id 5018',13392.00,0.00,0.00,18.00,1422.00,'2022-09-11 17:28:24','',''),(5168,'1','275','1',1,'Retail Sale Id 5019',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 17:30:08','',''),(5169,'1','275','1',1,'Retail Sale Id 5020',2001.36,0.00,0.00,2.69,212.51,'2022-09-11 17:31:56','',''),(5170,'1','275','1',1,'Retail Sale Id 5021',1502.88,0.00,0.00,2.02,159.58,'2022-09-11 17:33:19','',''),(5171,'1','275','1',1,'Retail Sale Id 5022',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 17:34:22','',''),(5172,'1','275','1',1,'Retail Sale Id 5023',1502.88,0.00,0.00,2.02,159.58,'2022-09-11 17:43:39','',''),(5173,'1','275','1',1,'Retail Sale Id 5024',7998.00,0.00,0.00,10.75,849.25,'2022-09-11 17:56:21','',''),(5174,'1','275','1',1,'Retail Sale Id 5025',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 17:57:35','',''),(5175,'1','275','1',1,'Retail Sale Id 5026',2298.96,0.00,0.00,3.09,244.11,'2022-09-11 18:00:32','',''),(5176,'1','275','1',1,'Retail Sale Id 5027',3801.84,0.00,0.00,5.11,403.69,'2022-09-11 18:06:41','',''),(5177,'1','275','1',1,'Retail Sale Id 5028',1502.88,0.00,0.00,2.02,159.58,'2022-09-11 18:19:41','',''),(5178,'1','275','1',1,'Retail Sale Id 5029',7440.00,0.00,0.00,10.00,790.00,'2022-09-11 18:22:22','',''),(5179,'1','275','1',1,'Retail Sale Id 5030',2298.96,0.00,0.00,3.09,244.11,'2022-09-11 18:33:26','',''),(5180,'1','275','1',1,'Retail Sale Id 5031',2499.84,0.00,0.00,3.36,265.44,'2022-09-11 18:34:57','',''),(5181,'1','275','1',1,'Retail Sale Id 5032',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 18:35:48','',''),(5182,'1','275','1',1,'Retail Sale Id 5033',2001.36,0.00,0.00,2.69,212.51,'2022-09-11 18:36:54','',''),(5183,'1','275','1',1,'Retail Sale Id 5034',2298.96,0.00,0.00,3.09,244.11,'2022-09-11 18:38:18','',''),(5184,'1','275','1',1,'Retail Sale Id 5035',1502.88,0.00,0.00,2.02,159.58,'2022-09-11 18:39:34','',''),(5185,'1','275','1',1,'Retail Sale Id 5036',2298.96,0.00,0.00,3.09,244.11,'2022-09-11 18:40:45','',''),(5186,'1','275','1',1,'Retail Sale Id 5037',3496.80,0.00,0.00,4.70,371.30,'2022-09-11 18:46:40','',''),(5187,'1','275','1',1,'Retail Sale Id 5038',1502.88,0.00,0.00,2.02,159.58,'2022-09-11 18:47:24','',''),(5188,'1','275','1',1,'Retail Sale Id 5039',2298.96,0.00,0.00,3.09,244.11,'2022-09-11 18:48:09','',''),(5189,'1','275','1',1,'Retail Sale Id 5040',1502.88,0.00,0.00,2.02,159.58,'2022-09-11 18:50:41','',''),(5190,'1','275','1',1,'Retail Sale Id 5041',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 18:51:34','',''),(5191,'1','275','1',1,'Retail Sale Id 5042',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 18:52:36','',''),(5192,'1','275','1',1,'Retail Sale Id 5043',996.96,0.00,0.00,1.34,105.86,'2022-09-11 18:53:44','',''),(5193,'1','275','1',1,'Retail Sale Id 5044',2998.32,0.00,0.00,4.03,318.37,'2022-09-11 18:54:25','',''),(5194,'1','275','1',1,'Retail Sale Id 5045',30057.60,0.00,0.00,40.40,3191.60,'2022-09-11 19:27:33','',''),(5195,'1','275','1',1,'Distributed to OPPRETIONAL LOST  for sales id:18',67424.35,0.00,0.00,101.39,0.00,'2022-09-12 13:12:21','',''),(5196,'1','275',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,332500.00,500.00,0.00,0.00,'2022-09-13 15:35:54','',''),(5197,'1','275',NULL,1,'Reception corrector for bridging 20',0.00,0.00,0.00,500.00,0.00,'2022-09-13 17:50:59','',''),(5198,'1','275','1',1,'Received from bridging 20',0.00,0.00,500.00,0.00,0.00,'2022-09-13 17:50:59','',''),(5199,'1','275','1',1,'Retail Sale Id 5046',37200.00,0.00,0.00,50.00,3950.00,'2022-09-13 17:51:36','',''),(5200,'1','275','1',1,'Retail Sale Id 5047',37200.00,0.00,0.00,50.00,3950.00,'2022-09-13 17:52:08','',''),(5201,'1','275','1',1,'Retail Sale Id 5048',90001.68,0.00,0.00,120.97,9556.63,'2022-09-13 18:03:06','',''),(5202,'1','275','1',1,'Retail Sale Id 5049',118169.52,0.00,0.00,158.83,12547.57,'2022-09-13 19:39:57','',''),(5203,'1','275','1',1,'Retail Sale Id 5050',18600.00,0.00,0.00,25.00,1975.00,'2022-09-14 06:49:48','',''),(5204,'1','275','1',1,'Retail Sale Id 5051',4501.20,0.00,0.00,6.05,477.95,'2022-09-14 06:50:28','',''),(5205,'1','275','1',1,'Retail Sale Id 5052',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 07:16:41','',''),(5206,'1','275','1',1,'Retail Sale Id 5053',2298.96,0.00,0.00,3.09,244.11,'2022-09-14 07:26:03','',''),(5207,'1','275','1',1,'Retail Sale Id 5054',2001.36,0.00,0.00,2.69,212.51,'2022-09-14 07:33:45','',''),(5208,'1','275','1',1,'Retail Sale Id 5055',18600.00,0.00,0.00,25.00,1975.00,'2022-09-14 07:38:25','',''),(5209,'1','275','1',1,'Retail Sale Id 5056',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 07:39:27','',''),(5210,'1','275','1',1,'Retail Sale Id 5057',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 07:40:04','',''),(5211,'1','275','1',1,'Retail Sale Id 5058',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 07:40:38','',''),(5212,'1','275','1',1,'Retail Sale Id 5059',6227.28,0.00,0.00,8.37,661.23,'2022-09-14 07:41:30','',''),(5213,'1','275',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,1722350.00,2590.00,0.00,0.00,'2022-09-14 07:44:15','',''),(5214,'1','275',NULL,1,'Reception corrector for bridging 21',0.00,0.00,0.00,2590.00,0.00,'2022-09-14 07:45:14','',''),(5215,'1','275','1',1,'Received from bridging 21',0.00,0.00,2590.00,0.00,0.00,'2022-09-14 07:45:14','',''),(5216,'1','275','1',1,'Retail Sale Id 5060',3720.00,0.00,0.00,5.00,395.00,'2022-09-14 07:50:26','',''),(5217,'1','275','1',1,'Retail Sale Id 5061',2998.32,0.00,0.00,4.03,318.37,'2022-09-14 07:56:04','',''),(5218,'1','275','1',1,'Retail Sale Id 5062',4999.68,0.00,0.00,6.72,530.88,'2022-09-14 08:07:24','',''),(5219,'1','275','1',1,'Retail Sale Id 5063',5996.64,0.00,0.00,8.06,636.74,'2022-09-14 08:10:35','',''),(5220,'1','275','1',1,'Retail Sale Id 5064',996.96,0.00,0.00,1.34,105.86,'2022-09-14 08:32:53','',''),(5221,'1','275','1',1,'Retail Sale Id 5065',37200.00,0.00,0.00,50.00,3950.00,'2022-09-14 08:34:06','',''),(5222,'1','275','1',1,'Retail Sale Id 5066',2298.96,0.00,0.00,3.09,244.11,'2022-09-14 08:40:52','',''),(5223,'1','275','1',1,'Retail Sale Id 5067',3496.80,0.00,0.00,4.70,371.30,'2022-09-14 08:48:14','',''),(5224,'1','275','1',1,'Retail Sale Id 5068',4999.68,0.00,0.00,6.72,530.88,'2022-09-14 08:56:33','',''),(5225,'1','275','1',1,'Retail Sale Id 5069',996.96,0.00,0.00,1.34,105.86,'2022-09-14 09:02:59','',''),(5226,'1','275','1',1,'Retail Sale Id 5070',1197.84,0.00,0.00,1.61,127.19,'2022-09-14 09:15:43','',''),(5227,'1','275','1',1,'Retail Sale Id 5071',1502.88,0.00,0.00,2.02,159.58,'2022-09-14 09:18:40','',''),(5228,'1','275','1',1,'Retail Sale Id 5072',4501.20,0.00,0.00,6.05,477.95,'2022-09-14 09:20:33','',''),(5229,'1','275','1',1,'Retail Sale Id 5073',2998.32,0.00,0.00,4.03,318.37,'2022-09-14 09:22:25','',''),(5230,'1','275','1',1,'Retail Sale Id 5074',14880.00,0.00,0.00,20.00,1580.00,'2022-09-14 09:31:16','',''),(5231,'1','275','1',1,'Retail Sale Id 5075',1502.88,0.00,0.00,2.02,159.58,'2022-09-14 09:59:53','',''),(5232,'1','275','1',1,'Retail Sale Id 5076',13020.00,0.00,0.00,17.50,1382.50,'2022-09-14 10:51:19','',''),(5233,'1','275','1',1,'Retail Sale Id 5077',2001.36,0.00,0.00,2.69,212.51,'2022-09-14 11:17:47','',''),(5234,'1','275','1',1,'Retail Sale Id 5078',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 11:41:02','',''),(5235,'1','275','1',1,'Retail Sale Id 5079',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 11:50:59','',''),(5236,'1','275','1',1,'Retail Sale Id 5080',4999.68,0.00,0.00,6.72,530.88,'2022-09-14 11:56:17','',''),(5237,'1','275','1',1,'Retail Sale Id 5081',2998.32,0.00,0.00,4.03,318.37,'2022-09-14 12:10:36','',''),(5238,'1','275','1',1,'Retail Sale Id 5082',996.96,0.00,0.00,1.34,105.86,'2022-09-14 12:42:26','',''),(5239,'1','275','1',1,'Retail Sale Id 5083',4002.72,0.00,0.00,5.38,425.02,'2022-09-14 12:44:24','',''),(5240,'1','275','1',1,'Retail Sale Id 5084',4501.20,0.00,0.00,6.05,477.95,'2022-09-14 12:57:58','',''),(5241,'1','275','1',1,'Retail Sale Id 5085',4999.68,0.00,0.00,6.72,530.88,'2022-09-14 13:04:17','',''),(5242,'1','275','1',1,'Retail Sale Id 5086',4501.20,0.00,0.00,6.05,477.95,'2022-09-14 13:11:27','',''),(5243,'1','275','1',1,'Retail Sale Id 5087',1502.88,0.00,0.00,2.02,159.58,'2022-09-14 13:16:25','',''),(5244,'1','275','1',1,'Retail Sale Id 5088',2001.36,0.00,0.00,2.69,212.51,'2022-09-14 13:17:46','',''),(5245,'1','275','1',1,'Retail Sale Id 5089',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 13:28:56','',''),(5246,'1','275','1',1,'Retail Sale Id 5090',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 14:01:40','',''),(5247,'1','275','1',1,'Retail Sale Id 5091',4002.72,0.00,0.00,5.38,425.02,'2022-09-14 14:07:47','',''),(5248,'1','275','1',1,'Retail Sale Id 5092',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 14:09:04','',''),(5249,'1','275','1',1,'Retail Sale Id 5093',4501.20,0.00,0.00,6.05,477.95,'2022-09-14 14:14:39','',''),(5250,'1','275','1',1,'Retail Sale Id 5094',4999.68,0.00,0.00,6.72,530.88,'2022-09-14 14:21:34','',''),(5251,'1','275','1',1,'Retail Sale Id 5095',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 14:46:25','',''),(5252,'1','275','1',1,'Retail Sale Id 5096',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 14:51:17','',''),(5253,'1','275','1',1,'Retail Sale Id 5097',2001.36,0.00,0.00,2.69,212.51,'2022-09-14 15:02:58','',''),(5254,'1','275','1',1,'Retail Sale Id 5098',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 15:10:46','',''),(5255,'1','275','1',1,'Retail Sale Id 5099',3697.68,0.00,0.00,4.97,392.63,'2022-09-14 15:23:40','',''),(5256,'1','275','1',1,'Retail Sale Id 5100',4501.20,0.00,0.00,6.05,477.95,'2022-09-14 15:35:45','',''),(5257,'1','275','1',1,'Retail Sale Id 5101',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 15:36:21','',''),(5258,'1','275','1',1,'Retail Sale Id 5102',4501.20,0.00,0.00,6.05,477.95,'2022-09-14 15:37:46','',''),(5259,'1','275','1',1,'Retail Sale Id 5103',4501.20,0.00,0.00,6.05,477.95,'2022-09-14 15:42:03','',''),(5260,'1','275','1',1,'Retail Sale Id 5104',4002.72,0.00,0.00,5.38,425.02,'2022-09-14 15:43:22','',''),(5261,'1','275','1',1,'Retail Sale Id 5105',13764.00,0.00,0.00,18.50,1461.50,'2022-09-14 15:48:34','',''),(5262,'1','275','1',1,'Retail Sale Id 5106',996.96,0.00,0.00,1.34,105.86,'2022-09-14 15:55:20','',''),(5263,'1','275','1',1,'Retail Sale Id 5107',2998.32,0.00,0.00,4.03,318.37,'2022-09-14 15:58:10','',''),(5264,'1','275','1',1,'Retail Sale Id 5108',4501.20,0.00,0.00,6.05,477.95,'2022-09-14 16:01:32','',''),(5265,'1','275','1',1,'Retail Sale Id 5109',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 16:07:14','',''),(5266,'1','275','1',1,'Retail Sale Id 5110',2001.36,0.00,0.00,2.69,212.51,'2022-09-14 16:09:46','',''),(5267,'1','275','1',1,'Retail Sale Id 5111',4501.20,0.00,0.00,6.05,477.95,'2022-09-14 16:27:01','',''),(5268,'1','275','1',1,'Retail Sale Id 5112',2246.88,0.00,0.00,3.02,238.58,'2022-09-14 16:27:51','',''),(5269,'1','275','1',1,'Retail Sale Id 5113',4501.20,0.00,0.00,6.05,477.95,'2022-09-14 16:32:28','',''),(5270,'1','275','1',1,'Retail Sale Id 5114',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 16:38:51','',''),(5271,'1','275','1',1,'Retail Sale Id 5115',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 16:42:03','',''),(5272,'1','275','1',1,'Retail Sale Id 5116',2998.32,0.00,0.00,4.03,318.37,'2022-09-14 16:46:27','',''),(5273,'1','275','1',1,'Retail Sale Id 5117',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 16:50:31','',''),(5274,'1','275','1',1,'Retail Sale Id 5118',1502.88,0.00,0.00,2.02,159.58,'2022-09-14 17:05:41','',''),(5275,'1','275','1',1,'Retail Sale Id 5119',3720.00,0.00,0.00,5.00,395.00,'2022-09-14 17:06:34','',''),(5276,'1','275','1',1,'Retail Sale Id 5120',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 17:11:51','',''),(5277,'1','275','1',1,'Retail Sale Id 5121',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 17:14:22','',''),(5278,'1','275','1',1,'Retail Sale Id 5122',4501.20,0.00,0.00,6.05,477.95,'2022-09-14 17:15:45','',''),(5279,'1','275','1',1,'Retail Sale Id 5123',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 17:17:51','',''),(5280,'1','275','1',1,'Retail Sale Id 5124',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 17:23:14','',''),(5281,'1','275','1',1,'Retail Sale Id 5125',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 17:26:49','',''),(5282,'1','275','1',1,'Retail Sale Id 5126',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 17:27:49','',''),(5283,'1','275','1',1,'Retail Sale Id 5127',1502.88,0.00,0.00,2.02,159.58,'2022-09-14 17:41:18','',''),(5284,'1','275','1',1,'Retail Sale Id 5128',7499.52,0.00,0.00,10.08,796.32,'2022-09-14 17:43:44','',''),(5285,'1','275','1',1,'Retail Sale Id 5129',4501.20,0.00,0.00,6.05,477.95,'2022-09-14 17:44:41','',''),(5286,'1','275','1',1,'Retail Sale Id 5130',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 17:48:36','',''),(5287,'1','275','1',1,'Retail Sale Id 5131',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 17:49:50','',''),(5288,'1','275','1',1,'Retail Sale Id 5132',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 17:51:03','',''),(5289,'1','275','1',1,'Retail Sale Id 5133',4501.20,0.00,0.00,6.05,477.95,'2022-09-14 18:25:30','',''),(5290,'1','275','1',1,'Retail Sale Id 5134',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 18:27:43','',''),(5291,'1','275','1',1,'Retail Sale Id 5135',20951.04,0.00,0.00,28.16,2224.64,'2022-09-14 19:31:35','',''),(5292,'1','275','1',1,'Retail Sale Id 5136',1502.88,0.00,0.00,2.02,159.58,'2022-09-15 07:07:49','',''),(5293,'1','275','1',1,'Retail Sale Id 5137',996.96,0.00,0.00,1.34,105.86,'2022-09-15 07:08:56','',''),(5294,'1','275','1',1,'Retail Sale Id 5138',4002.72,0.00,0.00,5.38,425.02,'2022-09-15 07:26:18','',''),(5295,'1','275','1',1,'Retail Sale Id 5139',2001.36,0.00,0.00,2.69,212.51,'2022-09-15 07:42:45','',''),(5296,'1','275','1',1,'Retail Sale Id 5140',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 07:53:49','',''),(5297,'1','275','1',1,'Retail Sale Id 5141',2298.96,0.00,0.00,3.09,244.11,'2022-09-15 07:54:54','',''),(5298,'1','275','1',1,'Retail Sale Id 5142',3720.00,0.00,0.00,5.00,395.00,'2022-09-15 07:57:44','',''),(5299,'1','275','1',1,'Retail Sale Id 5143',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 08:02:49','',''),(5300,'1','275','1',1,'Retail Sale Id 5144',18228.00,0.00,0.00,24.50,1935.50,'2022-09-15 08:05:48','',''),(5301,'1','275','1',1,'Retail Sale Id 5145',13764.00,0.00,0.00,18.50,1461.50,'2022-09-15 08:26:47','',''),(5302,'1','275','1',1,'Retail Sale Id 5146',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 08:45:58','',''),(5303,'1','275','1',1,'Retail Sale Id 5147',1502.88,0.00,0.00,2.02,159.58,'2022-09-15 08:49:05','',''),(5304,'1','275','1',1,'Retail Sale Id 5148',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 09:17:41','',''),(5305,'1','275','1',1,'Retail Sale Id 5149',996.96,0.00,0.00,1.34,105.86,'2022-09-15 09:22:26','',''),(5306,'1','275','1',1,'Retail Sale Id 5150',3720.00,0.00,0.00,5.00,395.00,'2022-09-15 09:28:07','',''),(5307,'1','275','1',1,'Retail Sale Id 5151',3720.00,0.00,0.00,5.00,395.00,'2022-09-15 09:29:02','',''),(5308,'1','275','1',1,'Retail Sale Id 5152',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 09:30:29','',''),(5309,'1','275','1',1,'Retail Sale Id 5153',5498.16,0.00,0.00,7.39,583.81,'2022-09-15 09:33:40','',''),(5310,'1','275','1',1,'Retail Sale Id 5154',1197.84,0.00,0.00,1.61,127.19,'2022-09-15 09:34:51','',''),(5311,'1','275','1',1,'Retail Sale Id 5155',1502.88,0.00,0.00,2.02,159.58,'2022-09-15 09:45:35','',''),(5312,'1','275','1',1,'Retail Sale Id 5156',4999.68,0.00,0.00,6.72,530.88,'2022-09-15 10:09:37','',''),(5313,'1','275','1',1,'Retail Sale Id 5157',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 10:15:03','',''),(5314,'1','275','1',1,'Retail Sale Id 5158',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 10:20:39','',''),(5315,'1','275','1',1,'Retail Sale Id 5159',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 10:26:55','',''),(5316,'1','275','1',1,'Retail Sale Id 5160',3720.00,0.00,0.00,5.00,395.00,'2022-09-15 10:31:24','',''),(5317,'1','275','1',1,'Retail Sale Id 5161',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 10:33:50','',''),(5318,'1','275','1',1,'Retail Sale Id 5162',2001.36,0.00,0.00,2.69,212.51,'2022-09-15 10:39:28','',''),(5319,'1','275','1',1,'Retail Sale Id 5163',12997.68,0.00,0.00,17.47,1380.13,'2022-09-15 10:51:33','',''),(5320,'1','275','1',1,'Retail Sale Id 5164',4501.20,0.00,0.00,6.05,477.95,'2022-09-15 10:55:52','',''),(5321,'1','275','1',1,'Retail Sale Id 5165',4999.68,0.00,0.00,6.72,530.88,'2022-09-15 10:59:55','',''),(5322,'1','275','1',1,'Retail Sale Id 5166',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 11:01:43','',''),(5323,'1','275','1',1,'Retail Sale Id 5167',4501.20,0.00,0.00,6.05,477.95,'2022-09-15 11:26:06','',''),(5324,'1','275','1',1,'Retail Sale Id 5168',4501.20,0.00,0.00,6.05,477.95,'2022-09-15 11:39:31','',''),(5325,'1','275','1',1,'Retail Sale Id 5169',4002.72,0.00,0.00,5.38,425.02,'2022-09-15 11:56:39','',''),(5326,'1','275','1',1,'Retail Sale Id 5170',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 11:58:51','',''),(5327,'1','275','1',1,'Retail Sale Id 5171',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 12:02:04','',''),(5328,'1','275','1',1,'Retail Sale Id 5172',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 12:20:49','',''),(5329,'1','275','1',1,'Retail Sale Id 5173',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 12:53:23','',''),(5330,'1','275','1',1,'Retail Sale Id 5174',2998.32,0.00,0.00,4.03,318.37,'2022-09-15 13:10:28','',''),(5331,'1','275','1',1,'Retail Sale Id 5175',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 13:11:49','',''),(5332,'1','275','1',1,'Retail Sale Id 5176',2001.36,0.00,0.00,2.69,212.51,'2022-09-15 13:26:21','',''),(5333,'1','275','1',1,'Retail Sale Id 5177',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 13:30:22','',''),(5334,'1','275','1',1,'Retail Sale Id 5178',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 13:39:25','',''),(5335,'1','275','1',1,'Retail Sale Id 5179',2298.96,0.00,0.00,3.09,244.11,'2022-09-15 13:41:52','',''),(5336,'1','275','1',1,'Retail Sale Id 5180',2298.96,0.00,0.00,3.09,244.11,'2022-09-15 13:53:20','',''),(5337,'1','275','1',1,'Retail Sale Id 5181',4501.20,0.00,0.00,6.05,477.95,'2022-09-15 13:57:27','',''),(5338,'1','275','1',1,'Retail Sale Id 5182',2998.32,0.00,0.00,4.03,318.37,'2022-09-15 14:02:37','',''),(5339,'1','275','1',1,'Retail Sale Id 5183',10802.88,0.00,0.00,14.52,1147.08,'2022-09-15 14:16:02','',''),(5340,'1','275','1',1,'Retail Sale Id 5184',4501.20,0.00,0.00,6.05,477.95,'2022-09-15 14:25:33','',''),(5341,'1','275','1',1,'Retail Sale Id 5185',11904.00,0.00,0.00,16.00,1264.00,'2022-09-15 14:29:38','',''),(5342,'1','275','1',1,'Retail Sale Id 5186',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 14:36:41','',''),(5343,'1','275','1',1,'Retail Sale Id 5187',4501.20,0.00,0.00,6.05,477.95,'2022-09-15 14:50:16','',''),(5344,'1','275','1',1,'Retail Sale Id 5188',1599.60,0.00,0.00,2.15,169.85,'2022-09-15 14:58:34','',''),(5345,'1','275','1',1,'Retail Sale Id 5189',4501.20,0.00,0.00,6.05,477.95,'2022-09-15 15:08:28','',''),(5346,'1','275','1',1,'Retail Sale Id 5190',14999.04,0.00,0.00,20.16,1592.64,'2022-09-15 15:38:31','',''),(5347,'1','275','1',1,'Retail Sale Id 5191',5996.64,0.00,0.00,8.06,636.74,'2022-09-15 15:41:43','',''),(5348,'1','275','1',1,'Retail Sale Id 5192',3720.00,0.00,0.00,5.00,395.00,'2022-09-15 15:48:41','',''),(5349,'1','275','1',1,'Retail Sale Id 5194',3749.76,0.00,0.00,5.04,398.16,'2022-09-15 15:50:06','',''),(5350,'1','275','1',1,'Retail Sale Id 5195',1502.88,0.00,0.00,2.02,159.58,'2022-09-15 16:25:05','',''),(5351,'1','275','1',1,'Retail Sale Id 5196',18600.00,0.00,0.00,25.00,1975.00,'2022-09-15 16:26:32','',''),(5352,'1','275','1',1,'Retail Sale Id 5197',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 16:28:11','',''),(5353,'1','275','1',1,'Retail Sale Id 5198',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 16:32:52','',''),(5354,'1','275','1',1,'Retail Sale Id 5199',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 16:35:22','',''),(5355,'1','275','1',1,'Retail Sale Id 5200',1302.00,0.00,0.00,1.75,138.25,'2022-09-15 16:51:17','',''),(5356,'1','275','1',1,'Retail Sale Id 5201',744.00,0.00,0.00,1.00,79.00,'2022-09-15 17:03:17','',''),(5357,'1','275','1',1,'Retail Sale Id 5202',3720.00,0.00,0.00,5.00,395.00,'2022-09-15 17:04:32','',''),(5358,'1','275','1',1,'Retail Sale Id 5203',4999.68,0.00,0.00,6.72,530.88,'2022-09-15 17:09:00','',''),(5359,'1','275','1',1,'Retail Sale Id 5204',1502.88,0.00,0.00,2.02,159.58,'2022-09-15 17:20:24','',''),(5360,'1','275','1',1,'Retail Sale Id 5205',4501.20,0.00,0.00,6.05,477.95,'2022-09-15 17:21:44','',''),(5361,'1','275','1',1,'Retail Sale Id 5206',1502.88,0.00,0.00,2.02,159.58,'2022-09-15 17:22:43','',''),(5362,'1','275','1',1,'Retail Sale Id 5207',1502.88,0.00,0.00,2.02,159.58,'2022-09-15 17:25:14','',''),(5363,'1','275','1',1,'Retail Sale Id 5208',4501.20,0.00,0.00,6.05,477.95,'2022-09-15 17:29:17','',''),(5364,'1','275','1',1,'Retail Sale Id 5209',2298.96,0.00,0.00,3.09,244.11,'2022-09-15 17:30:24','',''),(5365,'1','275','1',1,'Retail Sale Id 5210',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 17:31:42','',''),(5366,'1','275','1',1,'Retail Sale Id 5211',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 17:37:57','',''),(5367,'1','275','1',1,'Retail Sale Id 5212',996.96,0.00,0.00,1.34,105.86,'2022-09-15 17:38:53','',''),(5368,'1','275','1',1,'Retail Sale Id 5213',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 17:40:02','',''),(5369,'1','275','1',1,'Retail Sale Id 5214',27900.00,0.00,0.00,37.50,2962.50,'2022-09-15 17:48:26','',''),(5370,'1','275','1',1,'Retail Sale Id 5215',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 17:50:12','',''),(5371,'1','275','1',1,'Retail Sale Id 5216',2998.32,0.00,0.00,4.03,318.37,'2022-09-15 17:54:51','',''),(5372,'1','275','1',1,'Retail Sale Id 5217',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 18:03:11','',''),(5373,'1','275','1',1,'Retail Sale Id 5218',1502.88,0.00,0.00,2.02,159.58,'2022-09-15 18:06:01','',''),(5374,'1','275','1',1,'Retail Sale Id 5219',1398.72,0.00,0.00,1.88,148.52,'2022-09-15 18:07:31','',''),(5375,'1','275','1',1,'Retail Sale Id 5220',996.96,0.00,0.00,1.34,105.86,'2022-09-15 18:14:56','',''),(5376,'1','275','1',1,'Retail Sale Id 5221',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 18:17:05','',''),(5377,'1','275','1',1,'Retail Sale Id 5222',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 18:19:25','',''),(5378,'1','275','1',1,'Retail Sale Id 5223',1502.88,0.00,0.00,2.02,159.58,'2022-09-15 18:20:38','',''),(5379,'1','275','1',1,'Retail Sale Id 5224',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 18:22:05','',''),(5380,'1','275','1',1,'Retail Sale Id 5225',3496.80,0.00,0.00,4.70,371.30,'2022-09-15 18:29:12','',''),(5381,'1','275','1',1,'Retail Sale Id 5226',13801.20,0.00,0.00,18.55,1465.45,'2022-09-15 18:37:47','',''),(5382,'1','275','1',1,'Retail Sale Id 5227',2998.32,0.00,0.00,4.03,318.37,'2022-09-15 18:41:02','',''),(5383,'1','275','1',1,'Return of Retail Sale Id 5227',0.00,2998.32,4.03,0.00,-318.37,'2022-09-15 19:10:06','',''),(5384,'1','275','1',1,'Retail Sale Id 5228',2923.92,0.00,0.00,3.93,310.47,'2022-09-15 19:11:22','',''),(5385,'1','275','1',1,'Retail Sale Id 5229',60003.60,0.00,0.00,80.65,6371.35,'2022-09-16 07:00:27','',''),(5386,'1','275','1',1,'Retail Sale Id 5230',4999.68,0.00,0.00,6.72,530.88,'2022-09-16 07:55:59','',''),(5387,'1','275','1',1,'Retail Sale Id 5231',2001.36,0.00,0.00,2.69,212.51,'2022-09-16 08:10:31','',''),(5388,'1','275','1',1,'Retail Sale Id 5232',996.96,0.00,0.00,1.34,105.86,'2022-09-16 08:18:53','',''),(5389,'1','275','1',1,'Retail Sale Id 5233',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 08:19:48','',''),(5390,'1','275','1',1,'Retail Sale Id 5234',1941.84,0.00,0.00,2.61,206.19,'2022-09-16 08:42:36','',''),(5391,'1','275','1',1,'Retail Sale Id 5234',2298.96,0.00,0.00,3.09,244.11,'2022-09-16 08:42:36','',''),(5392,'1','275','1',1,'Retail Sale Id 5235',996.96,0.00,0.00,1.34,105.86,'2022-09-16 09:07:46','',''),(5393,'1','275','1',1,'Retail Sale Id 5236',996.96,0.00,0.00,1.34,105.86,'2022-09-16 09:27:06','',''),(5394,'1','275','1',1,'Retail Sale Id 5237',1502.88,0.00,0.00,2.02,159.58,'2022-09-16 09:30:32','',''),(5395,'1','275','1',1,'Retail Sale Id 5238',20460.00,0.00,0.00,27.50,2172.50,'2022-09-16 09:41:54','',''),(5396,'1','275','1',1,'Retail Sale Id 5239',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 09:57:50','',''),(5397,'1','275','1',1,'Retail Sale Id 5240',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 10:08:19','',''),(5398,'1','275','1',1,'Retail Sale Id 5241',1502.88,0.00,0.00,2.02,159.58,'2022-09-16 10:17:40','',''),(5399,'1','275','1',1,'Retail Sale Id 5242',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 10:21:44','',''),(5400,'1','275','1',1,'Retail Sale Id 5243',2298.96,0.00,0.00,3.09,244.11,'2022-09-16 10:22:39','',''),(5401,'1','275','1',1,'Retail Sale Id 5244',4501.20,0.00,0.00,6.05,477.95,'2022-09-16 10:27:56','',''),(5402,'1','275','1',1,'Retail Sale Id 5245',4501.20,0.00,0.00,6.05,477.95,'2022-09-16 10:43:59','',''),(5403,'1','275','1',1,'Retail Sale Id 5246',2298.96,0.00,0.00,3.09,244.11,'2022-09-16 10:53:27','',''),(5404,'1','275','1',1,'Retail Sale Id 5247',2998.32,0.00,0.00,4.03,318.37,'2022-09-16 11:01:44','',''),(5405,'1','275','1',1,'Retail Sale Id 5248',18600.00,0.00,0.00,25.00,1975.00,'2022-09-16 11:04:19','',''),(5406,'1','275','1',1,'Retail Sale Id 5249',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 11:09:34','',''),(5407,'1','275','1',1,'Retail Sale Id 5250',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 11:15:34','',''),(5408,'1','275','1',1,'Retail Sale Id 5251',2001.36,0.00,0.00,2.69,212.51,'2022-09-16 11:16:52','',''),(5409,'1','275','1',1,'Retail Sale Id 5252',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 11:36:55','',''),(5410,'1','275','1',1,'Retail Sale Id 5253',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 11:41:45','',''),(5411,'1','275','1',1,'Retail Sale Id 5254',9002.40,0.00,0.00,12.10,955.90,'2022-09-16 11:43:20','',''),(5412,'1','275','1',1,'Retail Sale Id 5255',3496.80,0.00,0.00,4.70,371.30,'2022-09-16 11:46:35','',''),(5413,'1','275','1',1,'Retail Sale Id 5256',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 12:27:44','',''),(5414,'1','275','1',1,'Retail Sale Id 5257',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 12:29:04','',''),(5415,'1','275','1',1,'Retail Sale Id 5258',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 12:32:44','',''),(5416,'1','275','1',1,'Retail Sale Id 5259',5200.56,0.00,0.00,6.99,552.21,'2022-09-16 12:52:15','',''),(5417,'1','275','1',1,'Retail Sale Id 5260',7440.00,0.00,0.00,10.00,790.00,'2022-09-16 12:56:39','',''),(5418,'1','275','1',1,'Retail Sale Id 5261',18600.00,0.00,0.00,25.00,1975.00,'2022-09-16 13:01:11','',''),(5419,'1','275','1',1,'Retail Sale Id 5262',18600.00,0.00,0.00,25.00,1975.00,'2022-09-16 13:04:22','',''),(5420,'1','275','1',1,'Retail Sale Id 5263',7499.52,0.00,0.00,10.08,796.32,'2022-09-16 13:07:28','',''),(5421,'1','275','1',1,'Retail Sale Id 5264',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 13:17:44','',''),(5422,'1','275','1',1,'Retail Sale Id 5265',803.52,0.00,0.00,1.08,85.32,'2022-09-16 14:35:37','',''),(5423,'1','275','1',1,'Retail Sale Id 5266',2298.96,0.00,0.00,3.09,244.11,'2022-09-16 14:36:36','',''),(5424,'1','275','1',1,'Retail Sale Id 5267',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 14:38:26','',''),(5425,'1','275','1',1,'Retail Sale Id 5268',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 14:39:47','',''),(5426,'1','275','1',1,'Retail Sale Id 5269',4501.20,0.00,0.00,6.05,477.95,'2022-09-16 14:41:30','',''),(5427,'1','275','1',1,'Retail Sale Id 5270',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 14:52:03','',''),(5428,'1','275','1',1,'Retail Sale Id 5271',23064.00,0.00,0.00,31.00,2449.00,'2022-09-16 14:54:49','',''),(5429,'1','275','1',1,'Retail Sale Id 5272',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 14:56:24','',''),(5430,'1','275','1',1,'Retail Sale Id 5273',2998.32,0.00,0.00,4.03,318.37,'2022-09-16 14:58:31','',''),(5431,'1','275','1',1,'Retail Sale Id 5274',2298.96,0.00,0.00,3.09,244.11,'2022-09-16 15:09:55','',''),(5432,'1','275','1',1,'Retail Sale Id 5275',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 15:10:54','',''),(5433,'1','275','1',1,'Retail Sale Id 5276',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 15:11:58','',''),(5434,'1','275','1',1,'Retail Sale Id 5277',11598.96,0.00,0.00,15.59,1231.61,'2022-09-16 15:36:08','',''),(5435,'1','275','1',1,'Retail Sale Id 5278',4501.20,0.00,0.00,6.05,477.95,'2022-09-16 15:37:20','',''),(5436,'1','275','1',1,'Retail Sale Id 5279',7001.04,0.00,0.00,9.41,743.39,'2022-09-16 15:40:54','',''),(5437,'1','275','1',1,'Retail Sale Id 5280',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 15:42:59','',''),(5438,'1','275','1',1,'Retail Sale Id 5281',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 15:51:23','',''),(5439,'1','275','1',1,'Retail Sale Id 5282',996.96,0.00,0.00,1.34,105.86,'2022-09-16 15:52:59','',''),(5440,'1','275','1',1,'Retail Sale Id 5283',2298.96,0.00,0.00,3.09,244.11,'2022-09-16 16:00:07','',''),(5441,'1','275','1',1,'Retail Sale Id 5284',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 16:06:23','',''),(5442,'1','275','1',1,'Retail Sale Id 5285',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 16:10:07','',''),(5443,'1','275','1',1,'Retail Sale Id 5286',29760.00,0.00,0.00,40.00,3160.00,'2022-09-16 16:17:08','',''),(5444,'1','275','1',1,'Retail Sale Id 5287',2001.36,0.00,0.00,2.69,212.51,'2022-09-16 16:21:01','',''),(5445,'1','275','1',1,'Retail Sale Id 5288',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 16:24:10','',''),(5446,'1','275','1',1,'Retail Sale Id 5289',18600.00,0.00,0.00,25.00,1975.00,'2022-09-16 16:34:55','',''),(5447,'1','275','1',1,'Retail Sale Id 5290',4002.72,0.00,0.00,5.38,425.02,'2022-09-16 16:36:15','',''),(5448,'1','275','1',1,'Retail Sale Id 5291',2001.36,0.00,0.00,2.69,212.51,'2022-09-16 16:38:48','',''),(5449,'1','275','1',1,'Retail Sale Id 5292',4501.20,0.00,0.00,6.05,477.95,'2022-09-16 16:54:46','',''),(5450,'1','275','1',1,'Retail Sale Id 5293',1502.88,0.00,0.00,2.02,159.58,'2022-09-16 17:05:49','',''),(5451,'1','275','1',1,'Retail Sale Id 5294',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 17:08:36','',''),(5452,'1','275','1',1,'Retail Sale Id 5295',2298.96,0.00,0.00,3.09,244.11,'2022-09-16 17:10:21','',''),(5453,'1','275','1',1,'Retail Sale Id 5296',2298.96,0.00,0.00,3.09,244.11,'2022-09-16 17:15:25','',''),(5454,'1','275','1',1,'Retail Sale Id 5297',803.52,0.00,0.00,1.08,85.32,'2022-09-16 17:18:33','',''),(5455,'1','275','1',1,'Retail Sale Id 5298',14002.08,0.00,0.00,18.82,1486.78,'2022-09-16 17:30:08','',''),(5456,'1','275','1',1,'Retail Sale Id 5299',7499.52,0.00,0.00,10.08,796.32,'2022-09-16 17:31:02','',''),(5457,'1','275','1',1,'Retail Sale Id 5300',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 17:37:55','',''),(5458,'1','275','1',1,'Retail Sale Id 5301',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 17:40:53','',''),(5459,'1','275','1',1,'Retail Sale Id 5302',2998.32,0.00,0.00,4.03,318.37,'2022-09-16 17:45:37','',''),(5460,'1','275','1',1,'Retail Sale Id 5303',3801.84,0.00,0.00,5.11,403.69,'2022-09-16 17:46:32','',''),(5461,'1','275','1',1,'Retail Sale Id 5304',4501.20,0.00,0.00,6.05,477.95,'2022-09-16 17:49:47','',''),(5462,'1','275','1',1,'Retail Sale Id 5305',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 17:54:31','',''),(5463,'1','275','1',1,'Retail Sale Id 5306',2298.96,0.00,0.00,3.09,244.11,'2022-09-16 18:03:01','',''),(5464,'1','275','1',1,'Retail Sale Id 5307',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 18:06:14','',''),(5465,'1','275','1',1,'Retail Sale Id 5308',996.96,0.00,0.00,1.34,105.86,'2022-09-16 18:07:39','',''),(5466,'1','275','1',1,'Retail Sale Id 5309',4002.72,0.00,0.00,5.38,425.02,'2022-09-16 18:09:03','',''),(5467,'1','275','1',1,'Retail Sale Id 5310',1897.20,0.00,0.00,2.55,201.45,'2022-09-16 18:09:51','',''),(5468,'1','275','1',1,'Retail Sale Id 5311',1502.88,0.00,0.00,2.02,159.58,'2022-09-16 18:10:50','',''),(5469,'1','275','1',1,'Retail Sale Id 5312',16003.44,0.00,0.00,21.51,1699.29,'2022-09-16 18:12:00','',''),(5470,'1','275','1',1,'Retail Sale Id 5313',4501.20,0.00,0.00,6.05,477.95,'2022-09-16 18:13:31','',''),(5471,'1','275','1',1,'Retail Sale Id 5314',1502.88,0.00,0.00,2.02,159.58,'2022-09-16 18:19:03','',''),(5472,'1','275','1',1,'Retail Sale Id 5315',4501.20,0.00,0.00,6.05,477.95,'2022-09-16 18:28:58','',''),(5473,'1','275','1',1,'Retail Sale Id 5316',2298.96,0.00,0.00,3.09,244.11,'2022-09-16 18:33:01','',''),(5474,'1','275','1',1,'Retail Sale Id 5317',3801.84,0.00,0.00,5.11,403.69,'2022-09-16 18:38:29','',''),(5475,'1','275','1',1,'Retail Sale Id 5318',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 18:39:55','',''),(5476,'1','275','1',1,'Retail Sale Id 5319',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 18:42:44','',''),(5477,'1','275','1',1,'Retail Sale Id 5320',18600.00,0.00,0.00,25.00,1975.00,'2022-09-16 18:48:23','',''),(5478,'1','275','1',1,'Retail Sale Id 5321',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 18:52:44','',''),(5479,'1','275','1',1,'Retail Sale Id 5322',13912.80,0.00,0.00,18.70,1477.30,'2022-09-16 19:27:41','',''),(5480,'1','275','1',1,'Retail Sale Id 5323',11040.00,0.00,0.00,15.00,1065.00,'2022-09-17 07:27:41','',''),(5481,'1','275','1',1,'Retail Sale Id 5324',9200.00,0.00,0.00,12.50,887.50,'2022-09-17 07:39:08','',''),(5482,'1','275','1',1,'Retail Sale Id 5325',2001.92,0.00,0.00,2.72,193.12,'2022-09-17 08:00:19','',''),(5483,'1','275','1',1,'Retail Sale Id 5326',2303.68,0.00,0.00,3.13,222.23,'2022-09-17 08:04:31','',''),(5484,'1','275','1',1,'Retail Sale Id 5327',3996.48,0.00,0.00,5.43,385.53,'2022-09-17 08:09:11','',''),(5485,'1','275','1',1,'Retail Sale Id 5328',3002.88,0.00,0.00,4.08,289.68,'2022-09-17 08:11:12','',''),(5486,'1','275','1',1,'Retail Sale Id 5329',9200.00,0.00,0.00,12.50,887.50,'2022-09-17 08:15:51','',''),(5487,'1','275','1',1,'Retail Sale Id 5330',4997.44,0.00,0.00,6.79,482.09,'2022-09-17 08:17:35','',''),(5488,'1','275','1',1,'Retail Sale Id 5331',8096.00,0.00,0.00,11.00,781.00,'2022-09-17 08:19:14','',''),(5489,'1','275','1',1,'Retail Sale Id 5332',4452.80,0.00,0.00,6.05,429.55,'2022-09-17 09:02:43','',''),(5490,'1','275','1',1,'Retail Sale Id 5333',3680.00,0.00,0.00,5.00,355.00,'2022-09-17 09:04:42','',''),(5491,'1','275','1',1,'Retail Sale Id 5334',3702.08,0.00,0.00,5.03,357.13,'2022-09-17 09:05:56','',''),(5492,'1','275','1',1,'Return of Retail Sale Id 5334',0.00,3702.08,5.03,0.00,-357.13,'2022-09-17 09:07:10','',''),(5493,'1','275','1',1,'Retail Sale Id 5335',2075.52,0.00,0.00,2.82,200.22,'2022-09-17 09:21:15','',''),(5494,'1','275','1',1,'Retail Sale Id 5336',3996.48,0.00,0.00,5.43,385.53,'2022-09-17 09:23:44','',''),(5495,'1','275','1',1,'Distributed to OPPRETIONAL LOST  for sales id:19',72059.40,0.00,0.00,108.36,0.00,'2022-09-17 16:49:01','',''),(5496,'1','275',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,332500.00,500.00,0.00,0.00,'2022-09-20 09:56:58','',''),(5497,'1','275',NULL,1,'Reception corrector for bridging 22',0.00,0.00,0.00,500.00,0.00,'2022-09-20 09:58:02','',''),(5498,'1','275','1',1,'Received from bridging 22',0.00,0.00,500.00,0.00,0.00,'2022-09-20 09:58:02','',''),(5499,'1','275','1',1,'Retail Sale Id 5337',9200.00,0.00,0.00,12.50,887.50,'2022-09-20 10:11:10','',''),(5500,'1','275','1',1,'Retail Sale Id 5338',9200.00,0.00,0.00,12.50,887.50,'2022-09-20 11:16:58','',''),(5501,'1','275','1',1,'Retail Sale Id 5339',4416.00,0.00,0.00,6.00,426.00,'2022-09-20 11:25:40','',''),(5502,'1','275','1',1,'Retail Sale Id 5340',27600.00,0.00,0.00,37.50,2662.50,'2022-09-20 11:29:31','',''),(5503,'1','275','1',1,'Retail Sale Id 5341',9200.00,0.00,0.00,12.50,887.50,'2022-09-20 11:48:16','',''),(5504,'1','275','1',1,'Retail Sale Id 5342',9200.00,0.00,0.00,12.50,887.50,'2022-09-20 11:49:47','',''),(5505,'1','275','1',1,'Retail Sale Id 5343',44160.00,0.00,0.00,60.00,4260.00,'2022-09-20 12:05:31','',''),(5506,'1','275','1',1,'Retail Sale Id 5344',3002.88,0.00,0.00,4.08,289.68,'2022-09-20 12:30:35','',''),(5507,'1','275','1',1,'Retail Sale Id 5345',2303.68,0.00,0.00,3.13,222.23,'2022-09-20 12:31:58','',''),(5508,'1','275','1',1,'Retail Sale Id 5346',18400.00,0.00,0.00,25.00,1775.00,'2022-09-20 12:47:10','',''),(5509,'1','275','1',1,'Retail Sale Id 5347',2097.60,0.00,0.00,2.85,202.35,'2022-09-20 12:50:23','',''),(5510,'1','275','1',1,'Retail Sale Id 5348',1000.96,0.00,0.00,1.36,96.56,'2022-09-20 12:51:52','',''),(5511,'1','275','1',1,'Retail Sale Id 5349',4496.96,0.00,0.00,6.11,433.81,'2022-09-20 12:54:34','',''),(5512,'1','275','1',1,'Retail Sale Id 5350',1000.96,0.00,0.00,1.36,96.56,'2022-09-20 13:12:39','',''),(5513,'1','275','1',1,'Retail Sale Id 5351',3702.08,0.00,0.00,5.03,357.13,'2022-09-20 13:18:26','',''),(5514,'1','275','1',1,'Retail Sale Id 5352',2001.92,0.00,0.00,2.72,193.12,'2022-09-20 13:19:16','',''),(5515,'1','275','1',1,'Retail Sale Id 5353',1501.44,0.00,0.00,2.04,144.84,'2022-09-20 13:22:53','',''),(5516,'1','275','1',1,'Retail Sale Id 5354',9200.00,0.00,0.00,12.50,887.50,'2022-09-20 13:32:20','',''),(5517,'1','275','1',1,'Retail Sale Id 5355',9200.00,0.00,0.00,12.50,887.50,'2022-09-20 13:47:29','',''),(5518,'1','275','1',1,'Retail Sale Id 5356',9200.00,0.00,0.00,12.50,887.50,'2022-09-20 13:49:05','',''),(5519,'1','275','1',1,'Retail Sale Id 5357',1000.96,0.00,0.00,1.36,96.56,'2022-09-20 13:56:36','',''),(5520,'1','275','1',1,'Retail Sale Id 5358',2502.40,0.00,0.00,3.40,241.40,'2022-09-20 14:08:01','',''),(5521,'1','275','1',1,'Retail Sale Id 5359',9200.00,0.00,0.00,12.50,887.50,'2022-09-20 14:13:29','',''),(5522,'1','275','1',1,'Retail Sale Id 5360',9200.00,0.00,0.00,12.50,887.50,'2022-09-20 14:28:44','',''),(5523,'1','275','1',1,'Retail Sale Id 5361',36800.00,0.00,0.00,50.00,3550.00,'2022-09-20 14:32:35','',''),(5524,'1','275','1',1,'Retail Sale Id 5362',9200.00,0.00,0.00,12.50,887.50,'2022-09-20 14:34:33','',''),(5525,'1','275','1',1,'Retail Sale Id 5363',3503.36,0.00,0.00,4.76,337.96,'2022-09-20 14:35:41','',''),(5526,'1','275','1',1,'Retail Sale Id 5364',9200.00,0.00,0.00,12.50,887.50,'2022-09-20 14:39:57','',''),(5527,'1','275','1',1,'Retail Sale Id 5365',9200.00,0.00,0.00,12.50,887.50,'2022-09-20 14:41:26','',''),(5528,'1','275','1',1,'Retail Sale Id 5366',4416.00,0.00,0.00,6.00,426.00,'2022-09-20 15:01:01','',''),(5529,'1','275','1',1,'Retail Sale Id 5367',4496.96,0.00,0.00,6.11,433.81,'2022-09-20 15:05:03','',''),(5530,'1','275','1',1,'Retail Sale Id 5368',7499.84,0.00,0.00,10.19,723.49,'2022-09-20 15:10:00','',''),(5531,'1','275','1',1,'Retail Sale Id 5369',8199.04,0.00,0.00,11.14,790.94,'2022-09-20 15:11:34','',''),(5532,'1','275','1',1,'Retail Sale Id 5370',3996.48,0.00,0.00,5.43,385.53,'2022-09-20 15:13:57','',''),(5533,'1','275','1',1,'Retail Sale Id 5371',2001.92,0.00,0.00,2.72,193.12,'2022-09-20 15:15:20','',''),(5534,'1','275','1',1,'Retail Sale Id 5372',3996.48,0.00,0.00,5.43,385.53,'2022-09-20 15:19:26','',''),(5535,'1','275','1',1,'Retail Sale Id 5373',9200.00,0.00,0.00,12.50,887.50,'2022-09-20 15:21:37','',''),(5536,'1','275','1',1,'Retail Sale Id 5374',3996.48,0.00,0.00,5.43,385.53,'2022-09-20 15:23:21','',''),(5537,'1','275','1',1,'Retail Sale Id 5375',9200.00,0.00,0.00,12.50,887.50,'2022-09-20 15:39:53','',''),(5538,'1','275','1',1,'Retail Sale Id 5376',9200.00,0.00,0.00,12.50,887.50,'2022-09-20 15:46:03','',''),(5539,'1','275','1',1,'Retail Sale Id 5377',3996.48,0.00,0.00,5.43,385.53,'2022-09-20 15:54:50','',''),(5540,'1','275','1',1,'Retail Sale Id 5378',1501.44,0.00,0.00,2.04,144.84,'2022-09-20 16:00:28','',''),(5541,'1','275','1',1,'Retail Sale Id 5379',18400.00,0.00,0.00,25.00,1775.00,'2022-09-20 16:23:27','',''),(5542,'1','275','1',1,'Retail Sale Id 5380',4496.96,0.00,0.00,6.11,433.81,'2022-09-20 16:27:12','',''),(5543,'1','275','1',1,'Retail Sale Id 5381',3510.72,0.00,0.00,4.77,338.67,'2022-09-20 16:28:00','',''),(5544,'1','275',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3220800.00,4880.00,0.00,0.00,'2022-09-20 16:30:39','',''),(5545,'1','275',NULL,1,'Reception corrector for bridging 23',0.00,0.00,0.00,4880.00,0.00,'2022-09-20 16:31:56','',''),(5546,'1','275','1',1,'Received from bridging 23',0.00,0.00,4880.00,0.00,0.00,'2022-09-20 16:31:56','',''),(5547,'1','275','1',1,'Retail Sale Id 5382',1501.44,0.00,0.00,2.04,155.04,'2022-09-20 16:32:27','',''),(5548,'1','275','1',1,'Retail Sale Id 5383',11408.00,0.00,0.00,15.50,1178.00,'2022-09-20 16:33:43','',''),(5549,'1','275','1',1,'Retail Sale Id 5384',3702.08,0.00,0.00,5.03,382.28,'2022-09-20 16:36:59','',''),(5550,'1','275','1',1,'Retail Sale Id 5385',3680.00,0.00,0.00,5.00,380.00,'2022-09-20 16:42:54','',''),(5551,'1','275','1',1,'Retail Sale Id 5386',8832.00,0.00,0.00,12.00,912.00,'2022-09-20 16:45:56','',''),(5552,'1','275','1',1,'Retail Sale Id 5387',4496.96,0.00,0.00,6.11,464.36,'2022-09-20 16:47:11','',''),(5553,'1','275','1',1,'Retail Sale Id 5388',9200.00,0.00,0.00,12.50,950.00,'2022-09-20 16:51:09','',''),(5554,'1','275','1',1,'Retail Sale Id 5389',9200.00,0.00,0.00,12.50,950.00,'2022-09-20 17:10:19','',''),(5555,'1','275','1',1,'Retail Sale Id 5391',1199.68,0.00,0.00,1.63,123.88,'2022-09-20 17:20:52','',''),(5556,'1','275','1',1,'Retail Sale Id 5392',2208.00,0.00,0.00,3.00,228.00,'2022-09-20 17:22:06','',''),(5557,'1','275','1',1,'Retail Sale Id 5393',2502.40,0.00,0.00,3.40,258.40,'2022-09-20 17:36:07','',''),(5558,'1','275','1',1,'Retail Sale Id 5394',3503.36,0.00,0.00,4.76,361.76,'2022-09-20 17:37:07','',''),(5559,'1','275','1',1,'Retail Sale Id 5395',4496.96,0.00,0.00,6.11,464.36,'2022-09-20 17:40:12','',''),(5560,'1','275','1',1,'Retail Sale Id 5396',3002.88,0.00,0.00,4.08,310.08,'2022-09-20 17:43:27','',''),(5561,'1','275','1',1,'Retail Sale Id 5396',3002.88,0.00,0.00,4.08,310.08,'2022-09-20 17:43:27','',''),(5562,'1','275','1',1,'Retail Sale Id 5397',4997.44,0.00,0.00,6.79,516.04,'2022-09-20 17:50:18','',''),(5563,'1','275','1',1,'Retail Sale Id 5398',9200.00,0.00,0.00,12.50,950.00,'2022-09-20 17:56:26','',''),(5564,'1','275','1',1,'Retail Sale Id 5399',9200.00,0.00,0.00,12.50,950.00,'2022-09-20 18:05:16','',''),(5565,'1','275','1',1,'Retail Sale Id 5400',2208.00,0.00,0.00,3.00,228.00,'2022-09-20 18:11:50','',''),(5566,'1','275','1',1,'Retail Sale Id 5401',3002.88,0.00,0.00,4.08,310.08,'2022-09-20 18:17:28','',''),(5567,'1','275','1',1,'Retail Sale Id 5402',9200.00,0.00,0.00,12.50,950.00,'2022-09-20 18:18:39','',''),(5568,'1','275','1',1,'Retail Sale Id 5403',736.00,0.00,0.00,1.00,76.00,'2022-09-20 18:25:48','',''),(5569,'1','275','1',1,'Retail Sale Id 5404',9200.00,0.00,0.00,12.50,950.00,'2022-09-20 18:27:10','',''),(5570,'1','275','1',1,'Retail Sale Id 5405',802.24,0.00,0.00,1.09,82.84,'2022-09-20 18:28:22','',''),(5571,'1','275','1',1,'Retail Sale Id 5406',18400.00,0.00,0.00,25.00,1900.00,'2022-09-20 18:30:59','',''),(5572,'1','275','1',1,'Retail Sale Id 5407',3996.48,0.00,0.00,5.43,412.68,'2022-09-20 18:35:46','',''),(5573,'1','275','1',1,'Retail Sale Id 5408',32656.32,0.00,0.00,44.37,3372.12,'2022-09-20 19:06:35','',''),(5574,'1','275','1',1,'Retail Sale Id 5409',4496.96,0.00,0.00,6.11,464.36,'2022-09-21 07:20:33','',''),(5575,'1','275','1',1,'Retail Sale Id 5410',2208.00,0.00,0.00,3.00,228.00,'2022-09-21 08:02:13','',''),(5576,'1','275','1',1,'Retail Sale Id 5411',4997.44,0.00,0.00,6.79,516.04,'2022-09-21 08:23:34','',''),(5577,'1','275','1',1,'Retail Sale Id 5412',16000.64,0.00,0.00,21.74,1652.24,'2022-09-21 08:48:45','',''),(5578,'1','275','1',1,'Retail Sale Id 5413',9200.00,0.00,0.00,12.50,950.00,'2022-09-21 08:54:03','',''),(5579,'1','275','1',1,'Retail Sale Id 5414',9200.00,0.00,0.00,12.50,950.00,'2022-09-21 08:55:10','',''),(5580,'1','275','1',1,'Retail Sale Id 5415',1199.68,0.00,0.00,1.63,123.88,'2022-09-21 09:15:23','',''),(5581,'1','275','1',1,'Retail Sale Id 5416',4496.96,0.00,0.00,6.11,464.36,'2022-09-21 09:17:21','',''),(5582,'1','275','1',1,'Retail Sale Id 5417',4496.96,0.00,0.00,6.11,464.36,'2022-09-21 09:30:55','',''),(5583,'1','275','1',1,'Retail Sale Id 5418',1000.96,0.00,0.00,1.36,103.36,'2022-09-21 09:39:42','',''),(5584,'1','275','1',1,'Retail Sale Id 5419',2001.92,0.00,0.00,2.72,206.72,'2022-09-21 09:42:54','',''),(5585,'1','275','1',1,'Retail Sale Id 5420',9200.00,0.00,0.00,12.50,950.00,'2022-09-21 09:53:50','',''),(5586,'1','275','1',1,'Retail Sale Id 5421',9200.00,0.00,0.00,12.50,950.00,'2022-09-21 09:57:40','',''),(5587,'1','275','1',1,'Retail Sale Id 5422',2001.92,0.00,0.00,2.72,206.72,'2022-09-21 09:59:33','',''),(5588,'1','275','1',1,'Retail Sale Id 5423',1501.44,0.00,0.00,2.04,155.04,'2022-09-21 10:22:28','',''),(5589,'1','275','1',1,'Retail Sale Id 5424',8096.00,0.00,0.00,11.00,836.00,'2022-09-21 10:25:15','',''),(5590,'1','275','1',1,'Retail Sale Id 5425',3680.00,0.00,0.00,5.00,380.00,'2022-09-21 10:27:47','',''),(5591,'1','275','1',1,'Retail Sale Id 5426',1000.96,0.00,0.00,1.36,103.36,'2022-09-21 10:35:16','',''),(5592,'1','275','1',1,'Retail Sale Id 5427',9200.00,0.00,0.00,12.50,950.00,'2022-09-21 10:36:39','',''),(5593,'1','275','1',1,'Retail Sale Id 5428',2252.16,0.00,0.00,3.06,232.56,'2022-09-21 10:47:42','',''),(5594,'1','275','1',1,'Retail Sale Id 5429',8832.00,0.00,0.00,12.00,912.00,'2022-09-21 10:49:09','',''),(5595,'1','275','1',1,'Retail Sale Id 5430',9200.00,0.00,0.00,12.50,950.00,'2022-09-21 11:05:43','',''),(5596,'1','275','1',1,'Retail Sale Id 5431',9200.00,0.00,0.00,12.50,950.00,'2022-09-21 11:19:10','',''),(5597,'1','275','1',1,'Retail Sale Id 5432',1104.00,0.00,0.00,1.50,114.00,'2022-09-21 11:28:48','',''),(5598,'1','275','1',1,'Retail Sale Id 5433',2303.68,0.00,0.00,3.13,237.88,'2022-09-21 11:32:32','',''),(5599,'1','275','1',1,'Retail Sale Id 5434',9200.00,0.00,0.00,12.50,950.00,'2022-09-21 11:34:11','',''),(5600,'1','275','1',1,'Retail Sale Id 5435',3002.88,0.00,0.00,4.08,310.08,'2022-09-21 12:07:57','',''),(5601,'1','275','1',1,'Retail Sale Id 5436',2001.92,0.00,0.00,2.72,206.72,'2022-09-21 12:08:52','',''),(5602,'1','275','1',1,'Retail Sale Id 5437',3002.88,0.00,0.00,4.08,310.08,'2022-09-21 12:29:04','',''),(5603,'1','275','1',1,'Retail Sale Id 5438',9200.00,0.00,0.00,12.50,950.00,'2022-09-21 12:42:23','',''),(5604,'1','275','1',1,'Return of Retail Sale Id 5438',0.00,9200.00,12.50,0.00,-950.00,'2022-09-21 12:53:34','',''),(5605,'1','275','1',1,'Retail Sale Id 5439',7418.88,0.00,0.00,10.08,766.08,'2022-09-21 12:54:35','',''),(5606,'1','275','1',1,'Retail Sale Id 5440',8000.32,0.00,0.00,10.87,826.12,'2022-09-21 13:29:44','',''),(5607,'1','275','1',1,'Retail Sale Id 5441',9200.00,0.00,0.00,12.50,950.00,'2022-09-21 13:43:16','',''),(5608,'1','275','1',1,'Retail Sale Id 5442',4496.96,0.00,0.00,6.11,464.36,'2022-09-21 13:44:10','',''),(5609,'1','275','1',1,'Retail Sale Id 5443',1501.44,0.00,0.00,2.04,155.04,'2022-09-21 14:05:03','',''),(5610,'1','275','1',1,'Retail Sale Id 5444',9200.00,0.00,0.00,12.50,950.00,'2022-09-21 14:09:57','',''),(5611,'1','275','1',1,'Retail Sale Id 5445',9200.00,0.00,0.00,12.50,950.00,'2022-09-21 14:15:05','',''),(5612,'1','275','1',1,'Retail Sale Id 5446',9200.00,0.00,0.00,12.50,950.00,'2022-09-21 14:17:25','',''),(5613,'1','275','1',1,'Retail Sale Id 5447',9200.00,0.00,0.00,12.50,950.00,'2022-09-21 14:18:30','',''),(5614,'1','275','1',1,'Retail Sale Id 5448',4997.44,0.00,0.00,6.79,516.04,'2022-09-21 14:21:27','',''),(5615,'1','275','1',1,'Retail Sale Id 5449',5888.00,0.00,0.00,8.00,608.00,'2022-09-21 14:22:44','',''),(5616,'1','275','1',1,'Retail Sale Id 5450',9200.00,0.00,0.00,12.50,950.00,'2022-09-21 14:30:54','',''),(5617,'1','275','1',1,'Retail Sale Id 5451',4416.00,0.00,0.00,6.00,456.00,'2022-09-21 14:37:45','',''),(5618,'1','275','1',1,'Retail Sale Id 5452',1000.96,0.00,0.00,1.36,103.36,'2022-09-21 14:41:51','',''),(5619,'1','275','1',1,'Retail Sale Id 5453',18400.00,0.00,0.00,25.00,1900.00,'2022-09-21 14:44:32','',''),(5620,'1','275','1',1,'Retail Sale Id 5454',4496.96,0.00,0.00,6.11,464.36,'2022-09-21 14:59:02','',''),(5621,'1','275','1',1,'Return of Retail Sale Id 5454',0.00,4496.96,6.11,0.00,-464.36,'2022-09-21 14:59:48','',''),(5622,'1','275','1',1,'Retail Sale Id 5455',9200.00,0.00,0.00,12.50,950.00,'2022-09-21 15:00:35','',''),(5623,'1','275','1',1,'Retail Sale Id 5456',3996.48,0.00,0.00,5.43,412.68,'2022-09-21 15:02:35','',''),(5624,'1','275','1',1,'Retail Sale Id 5457',2944.00,0.00,0.00,4.00,304.00,'2022-09-21 15:05:08','',''),(5625,'1','275','1',1,'Retail Sale Id 5458',9200.00,0.00,0.00,12.50,950.00,'2022-09-21 15:11:58','',''),(5626,'1','275','1',1,'Retail Sale Id 5459',9200.00,0.00,0.00,12.50,950.00,'2022-09-21 15:13:14','',''),(5627,'1','275','1',1,'Retail Sale Id 5460',9200.00,0.00,0.00,12.50,950.00,'2022-09-21 15:30:04','',''),(5628,'1','275','1',1,'Retail Sale Id 5461',9200.00,0.00,0.00,12.50,950.00,'2022-09-21 15:32:57','',''),(5629,'1','275','1',1,'Retail Sale Id 5462',1501.44,0.00,0.00,2.04,155.04,'2022-09-21 15:38:34','',''),(5630,'1','275','1',1,'Retail Sale Id 5463',3002.88,0.00,0.00,4.08,310.08,'2022-09-21 15:39:15','',''),(5631,'1','275','1',1,'Retail Sale Id 5464',1501.44,0.00,0.00,2.04,155.04,'2022-09-21 15:41:32','',''),(5632,'1','275','1',1,'Retail Sale Id 5465',2303.68,0.00,0.00,3.13,237.88,'2022-09-21 15:45:58','',''),(5633,'1','275','1',1,'Retail Sale Id 5466',9200.00,0.00,0.00,12.50,950.00,'2022-09-21 15:55:25','',''),(5634,'1','275','1',1,'Retail Sale Id 5466',36800.00,0.00,0.00,50.00,3800.00,'2022-09-21 15:55:25','',''),(5635,'1','275','1',1,'Retail Sale Id 5467',1501.44,0.00,0.00,2.04,155.04,'2022-09-21 15:56:55','',''),(5636,'1','275','1',1,'Retail Sale Id 5468',1000.96,0.00,0.00,1.36,103.36,'2022-09-21 16:00:31','',''),(5637,'1','275','1',1,'Retail Sale Id 5469',3503.36,0.00,0.00,4.76,361.76,'2022-09-21 16:04:26','',''),(5638,'1','275','1',1,'Retail Sale Id 5470',18400.00,0.00,0.00,25.00,1900.00,'2022-09-21 16:05:54','',''),(5639,'1','275','1',1,'Retail Sale Id 5471',1302.72,0.00,0.00,1.77,134.52,'2022-09-21 16:10:05','',''),(5640,'1','275','1',1,'Retail Sale Id 5472',9200.00,0.00,0.00,12.50,950.00,'2022-09-21 16:17:16','',''),(5641,'1','275','1',1,'Retail Sale Id 5473',9001.28,0.00,0.00,12.23,929.48,'2022-09-21 16:27:51','',''),(5642,'1','275','1',1,'Retail Sale Id 5474',1501.44,0.00,0.00,2.04,155.04,'2022-09-21 16:33:13','',''),(5643,'1','275','1',1,'Retail Sale Id 5474',2303.68,0.00,0.00,3.13,237.88,'2022-09-21 16:33:13','',''),(5644,'1','275','1',1,'Retail Sale Id 5475',4416.00,0.00,0.00,6.00,456.00,'2022-09-21 16:38:27','',''),(5645,'1','275','1',1,'Retail Sale Id 5476',4496.96,0.00,0.00,6.11,464.36,'2022-09-21 16:41:46','',''),(5646,'1','275','1',1,'Retail Sale Id 5477',9200.00,0.00,0.00,12.50,950.00,'2022-09-21 16:44:09','',''),(5647,'1','275','1',1,'Retail Sale Id 5478',9200.00,0.00,0.00,12.50,950.00,'2022-09-21 16:48:07','',''),(5648,'1','275','1',1,'Retail Sale Id 5479',4496.96,0.00,0.00,6.11,464.36,'2022-09-21 17:05:32','',''),(5649,'1','275','1',1,'Retail Sale Id 5480',4496.96,0.00,0.00,6.11,464.36,'2022-09-21 17:07:08','',''),(5650,'1','275','1',1,'Retail Sale Id 5481',802.24,0.00,0.00,1.09,82.84,'2022-09-21 17:07:56','',''),(5651,'1','275','1',1,'Retail Sale Id 5482',9200.00,0.00,0.00,12.50,950.00,'2022-09-21 17:10:57','',''),(5652,'1','275','1',1,'Retail Sale Id 5483',4416.00,0.00,0.00,6.00,456.00,'2022-09-21 17:26:18','',''),(5653,'1','275','1',1,'Retail Sale Id 5484',3002.88,0.00,0.00,4.08,310.08,'2022-09-21 17:40:22','',''),(5654,'1','275','1',1,'Retail Sale Id 5485',1096.64,0.00,0.00,1.49,113.24,'2022-09-21 17:42:38','',''),(5655,'1','275','1',1,'Return of Retail Sale Id 5485',0.00,1096.64,1.49,0.00,-113.24,'2022-09-21 17:43:14','',''),(5656,'1','275','1',1,'Retail Sale Id 5486',1148.16,0.00,0.00,1.56,118.56,'2022-09-21 17:43:43','',''),(5657,'1','275','1',1,'Retail Sale Id 5487',29440.00,0.00,0.00,40.00,3040.00,'2022-09-21 17:44:57','',''),(5658,'1','275','1',1,'Retail Sale Id 5487',33120.00,0.00,0.00,45.00,3420.00,'2022-09-21 17:44:57','',''),(5659,'1','275','1',1,'Retail Sale Id 5488',2001.92,0.00,0.00,2.72,206.72,'2022-09-21 17:45:35','',''),(5660,'1','275','1',1,'Retail Sale Id 5489',9200.00,0.00,0.00,12.50,950.00,'2022-09-21 17:50:35','',''),(5661,'1','275','1',1,'Retail Sale Id 5490',3503.36,0.00,0.00,4.76,361.76,'2022-09-21 17:52:21','',''),(5662,'1','275','1',1,'Retail Sale Id 5491',27600.00,0.00,0.00,37.50,2850.00,'2022-09-21 17:56:08','',''),(5663,'1','275','1',1,'Retail Sale Id 5492',9200.00,0.00,0.00,12.50,950.00,'2022-09-21 18:00:18','',''),(5664,'1','275','1',1,'Retail Sale Id 5493',3002.88,0.00,0.00,4.08,310.08,'2022-09-21 18:11:35','',''),(5665,'1','275','1',1,'Retail Sale Id 5494',1501.44,0.00,0.00,2.04,155.04,'2022-09-21 18:19:48','',''),(5666,'1','275','1',1,'Retail Sale Id 5495',2001.92,0.00,0.00,2.72,206.72,'2022-09-21 18:20:37','',''),(5667,'1','275','1',1,'Retail Sale Id 5496',3996.48,0.00,0.00,5.43,412.68,'2022-09-21 18:21:52','',''),(5668,'1','275','1',1,'Retail Sale Id 5497',2303.68,0.00,0.00,3.13,237.88,'2022-09-21 18:23:39','',''),(5669,'1','275','1',1,'Retail Sale Id 5498',1000.96,0.00,0.00,1.36,103.36,'2022-09-21 18:32:38','',''),(5670,'1','275','1',1,'Retail Sale Id 5499',1000.96,0.00,0.00,1.36,103.36,'2022-09-21 18:33:36','',''),(5671,'1','275','1',1,'Retail Sale Id 5500',3002.88,0.00,0.00,4.08,310.08,'2022-09-21 18:36:47','',''),(5672,'1','275','1',1,'Retail Sale Id 5501',9200.00,0.00,0.00,12.50,950.00,'2022-09-21 18:38:51','',''),(5673,'1','275','1',1,'Retail Sale Id 5502',18400.00,0.00,0.00,25.00,1900.00,'2022-09-21 18:44:19','',''),(5674,'1','275','1',1,'Retail Sale Id 5503',9200.00,0.00,0.00,12.50,950.00,'2022-09-21 18:46:02','',''),(5675,'1','275','1',1,'Retail Sale Id 5504',1000.96,0.00,0.00,1.36,103.36,'2022-09-21 18:46:56','',''),(5676,'1','275','1',1,'Retail Sale Id 5505',2502.40,0.00,0.00,3.40,258.40,'2022-09-21 18:48:42','',''),(5677,'1','275','1',1,'Retail Sale Id 5506',17318.08,0.00,0.00,23.53,1788.28,'2022-09-21 19:27:29','',''),(5678,'1','275','1',1,'Retail Sale Id 5507',4496.96,0.00,0.00,6.11,464.36,'2022-09-22 06:41:05','',''),(5679,'1','275','1',1,'Retail Sale Id 5508',3996.48,0.00,0.00,5.43,412.68,'2022-09-22 07:16:22','',''),(5680,'1','275','1',1,'Retail Sale Id 5509',1000.96,0.00,0.00,1.36,103.36,'2022-09-22 07:42:07','',''),(5681,'1','275','1',1,'Retail Sale Id 5510',9200.00,0.00,0.00,12.50,950.00,'2022-09-22 07:45:25','',''),(5682,'1','275','1',1,'Retail Sale Id 5511',2001.92,0.00,0.00,2.72,206.72,'2022-09-22 07:53:47','',''),(5683,'1','275','1',1,'Retail Sale Id 5512',9200.00,0.00,0.00,12.50,950.00,'2022-09-22 08:01:00','',''),(5684,'1','275','1',1,'Retail Sale Id 5513',9200.00,0.00,0.00,12.50,950.00,'2022-09-22 08:02:39','',''),(5685,'1','275','1',1,'Retail Sale Id 5514',3702.08,0.00,0.00,5.03,382.28,'2022-09-22 08:18:35','',''),(5686,'1','275','1',1,'Retail Sale Id 5515',9200.00,0.00,0.00,12.50,950.00,'2022-09-22 08:36:06','',''),(5687,'1','275','1',1,'Retail Sale Id 5516',3996.48,0.00,0.00,5.43,412.68,'2022-09-22 08:58:36','',''),(5688,'1','275','1',1,'Retail Sale Id 5517',2303.68,0.00,0.00,3.13,237.88,'2022-09-22 09:10:36','',''),(5689,'1','275','1',1,'Retail Sale Id 5518',1199.68,0.00,0.00,1.63,123.88,'2022-09-22 09:24:11','',''),(5690,'1','275','1',1,'Retail Sale Id 5519',1000.96,0.00,0.00,1.36,103.36,'2022-09-22 09:28:57','',''),(5691,'1','275','1',1,'Retail Sale Id 5520',9200.00,0.00,0.00,12.50,950.00,'2022-09-22 09:35:13','',''),(5692,'1','275','1',1,'Retail Sale Id 5521',4496.96,0.00,0.00,6.11,464.36,'2022-09-22 09:36:10','',''),(5693,'1','275','1',1,'Retail Sale Id 5522',18400.00,0.00,0.00,25.00,1900.00,'2022-09-22 09:37:09','',''),(5694,'1','275','1',1,'Retail Sale Id 5523',7109.76,0.00,0.00,9.66,734.16,'2022-09-22 09:50:28','',''),(5695,'1','275','1',1,'Retail Sale Id 5524',9200.00,0.00,0.00,12.50,950.00,'2022-09-22 09:54:51','',''),(5696,'1','275','1',1,'Retail Sale Id 5525',3996.48,0.00,0.00,5.43,412.68,'2022-09-22 09:56:16','',''),(5697,'1','275','1',1,'Retail Sale Id 5526',4496.96,0.00,0.00,6.11,464.36,'2022-09-22 10:12:06','',''),(5698,'1','275','1',1,'Retail Sale Id 5527',9200.00,0.00,0.00,12.50,950.00,'2022-09-22 10:18:23','',''),(5699,'1','275','1',1,'Retail Sale Id 5528',4997.44,0.00,0.00,6.79,516.04,'2022-09-22 10:21:18','',''),(5700,'1','275','1',1,'Retail Sale Id 5529',1501.44,0.00,0.00,2.04,155.04,'2022-09-22 10:24:35','',''),(5701,'1','275','1',1,'Retail Sale Id 5530',9200.00,0.00,0.00,12.50,950.00,'2022-09-22 10:32:06','',''),(5702,'1','275','1',1,'Retail Sale Id 5531',5998.40,0.00,0.00,8.15,619.40,'2022-09-22 10:42:39','',''),(5703,'1','275','1',1,'Retail Sale Id 5532',2001.92,0.00,0.00,2.72,206.72,'2022-09-22 10:43:55','',''),(5704,'1','275','1',1,'Retail Sale Id 5533',1501.44,0.00,0.00,2.04,155.04,'2022-09-22 10:55:22','',''),(5705,'1','275','1',1,'Retail Sale Id 5534',6999.36,0.00,0.00,9.51,722.76,'2022-09-22 10:56:09','',''),(5706,'1','275','1',1,'Return of Retail Sale Id 5531',0.00,5998.40,8.15,0.00,-619.40,'2022-09-22 10:56:55','',''),(5707,'1','275','1',1,'Retail Sale Id 5535',8096.00,0.00,0.00,11.00,836.00,'2022-09-22 11:02:08','',''),(5708,'1','275','1',1,'Retail Sale Id 5536',9200.00,0.00,0.00,12.50,950.00,'2022-09-22 11:05:12','',''),(5709,'1','275','1',1,'Retail Sale Id 5537',802.24,0.00,0.00,1.09,82.84,'2022-09-22 11:16:01','',''),(5710,'1','275','1',1,'Retail Sale Id 5538',9200.00,0.00,0.00,12.50,950.00,'2022-09-22 11:33:42','',''),(5711,'1','275','1',1,'Retail Sale Id 5539',3996.48,0.00,0.00,5.43,412.68,'2022-09-22 11:52:47','',''),(5712,'1','275','1',1,'Retail Sale Id 5540',2502.40,0.00,0.00,3.40,258.40,'2022-09-22 12:02:48','',''),(5713,'1','275','1',1,'Retail Sale Id 5541',18400.00,0.00,0.00,25.00,1900.00,'2022-09-22 12:24:19','',''),(5714,'1','275','1',1,'Retail Sale Id 5542',9200.00,0.00,0.00,12.50,950.00,'2022-09-22 12:25:53','',''),(5715,'1','275','1',1,'Retail Sale Id 5543',9200.00,0.00,0.00,12.50,950.00,'2022-09-22 12:30:51','',''),(5716,'1','275','1',1,'Retail Sale Id 5544',802.24,0.00,0.00,1.09,82.84,'2022-09-22 12:49:56','',''),(5717,'1','275','1',1,'Retail Sale Id 5545',2001.92,0.00,0.00,2.72,206.72,'2022-09-22 12:57:33','',''),(5718,'1','275','1',1,'Retail Sale Id 5546',2303.68,0.00,0.00,3.13,237.88,'2022-09-22 12:58:25','',''),(5719,'1','275','1',1,'Retail Sale Id 5547',1000.96,0.00,0.00,1.36,103.36,'2022-09-22 13:07:12','',''),(5720,'1','275','1',1,'Retail Sale Id 5548',14720.00,0.00,0.00,20.00,1520.00,'2022-09-22 13:32:13','',''),(5721,'1','275','1',1,'Retail Sale Id 5549',9200.00,0.00,0.00,12.50,950.00,'2022-09-22 13:51:02','',''),(5722,'1','275','1',1,'Retail Sale Id 5550',2001.92,0.00,0.00,2.72,206.72,'2022-09-22 13:58:45','',''),(5723,'1','275','1',1,'Retail Sale Id 5551',4298.24,0.00,0.00,5.84,443.84,'2022-09-22 14:17:15','',''),(5724,'1','275','1',1,'Retail Sale Id 5552',9200.00,0.00,0.00,12.50,950.00,'2022-09-22 14:27:26','',''),(5725,'1','275','1',1,'Retail Sale Id 5553',1501.44,0.00,0.00,2.04,155.04,'2022-09-22 14:30:07','',''),(5726,'1','275','1',1,'Retail Sale Id 5554',8000.32,0.00,0.00,10.87,826.12,'2022-09-22 14:48:43','',''),(5727,'1','275','1',1,'Retail Sale Id 5554',8000.32,0.00,0.00,10.87,826.12,'2022-09-22 14:48:43','',''),(5728,'1','275','1',1,'Retail Sale Id 5555',8000.32,0.00,0.00,10.87,826.12,'2022-09-22 14:49:36','',''),(5729,'1','275','1',1,'Retail Sale Id 5556',3702.08,0.00,0.00,5.03,382.28,'2022-09-22 14:50:42','',''),(5730,'1','275','1',1,'Retail Sale Id 5557',2502.40,0.00,0.00,3.40,258.40,'2022-09-22 15:07:30','',''),(5731,'1','275','1',1,'Retail Sale Id 5558',3702.08,0.00,0.00,5.03,382.28,'2022-09-22 15:19:06','',''),(5732,'1','275','1',1,'Retail Sale Id 5559',9200.00,0.00,0.00,12.50,950.00,'2022-09-22 15:20:26','',''),(5733,'1','275','1',1,'Retail Sale Id 5560',9200.00,0.00,0.00,12.50,950.00,'2022-09-22 15:25:42','',''),(5734,'1','275','1',1,'Retail Sale Id 5561',36800.00,0.00,0.00,50.00,3800.00,'2022-09-22 15:30:07','',''),(5735,'1','275','1',1,'Retail Sale Id 5562',1501.44,0.00,0.00,2.04,155.04,'2022-09-22 15:34:34','',''),(5736,'1','275','1',1,'Retail Sale Id 5563',4496.96,0.00,0.00,6.11,464.36,'2022-09-22 15:47:53','',''),(5737,'1','275','1',1,'Retail Sale Id 5564',9200.00,0.00,0.00,12.50,950.00,'2022-09-22 16:00:12','',''),(5738,'1','275','1',1,'Retail Sale Id 5565',1000.96,0.00,0.00,1.36,103.36,'2022-09-22 16:01:51','',''),(5739,'1','275','1',1,'Retail Sale Id 5566',27600.00,0.00,0.00,37.50,2850.00,'2022-09-22 16:03:24','',''),(5740,'1','275','1',1,'Retail Sale Id 5567',4496.96,0.00,0.00,6.11,464.36,'2022-09-22 16:08:13','',''),(5741,'1','275','1',1,'Retail Sale Id 5568',2502.40,0.00,0.00,3.40,258.40,'2022-09-22 16:36:40','',''),(5742,'1','275','1',1,'Retail Sale Id 5569',9200.00,0.00,0.00,12.50,950.00,'2022-09-22 16:46:11','',''),(5743,'1','275','1',1,'Retail Sale Id 5570',9200.00,0.00,0.00,12.50,950.00,'2022-09-22 16:51:31','',''),(5744,'1','275','1',1,'Retail Sale Id 5571',9200.00,0.00,0.00,12.50,950.00,'2022-09-22 16:52:23','',''),(5745,'1','275','1',1,'Retail Sale Id 5572',11040.00,0.00,0.00,15.00,1140.00,'2022-09-22 16:55:56','',''),(5746,'1','275','1',1,'Retail Sale Id 5573',9200.00,0.00,0.00,12.50,950.00,'2022-09-22 17:04:23','',''),(5747,'1','275','1',1,'Retail Sale Id 5574',9200.00,0.00,0.00,12.50,950.00,'2022-09-22 17:12:57','',''),(5748,'1','275','1',1,'Retail Sale Id 5575',3002.88,0.00,0.00,4.08,310.08,'2022-09-22 17:15:30','',''),(5749,'1','275','1',1,'Retail Sale Id 5576',4997.44,0.00,0.00,6.79,516.04,'2022-09-22 17:17:54','',''),(5750,'1','275','1',1,'Retail Sale Id 5577',802.24,0.00,0.00,1.09,82.84,'2022-09-22 17:26:33','',''),(5751,'1','275','1',1,'Retail Sale Id 5578',18400.00,0.00,0.00,25.00,1900.00,'2022-09-22 17:27:22','',''),(5752,'1','275','1',1,'Retail Sale Id 5579',9200.00,0.00,0.00,12.50,950.00,'2022-09-22 17:31:55','',''),(5753,'1','275','1',1,'Retail Sale Id 5579',18400.00,0.00,0.00,25.00,1900.00,'2022-09-22 17:31:55','',''),(5754,'1','275','1',1,'Retail Sale Id 5580',1501.44,0.00,0.00,2.04,155.04,'2022-09-22 17:36:54','',''),(5755,'1','275','1',1,'Retail Sale Id 5581',3702.08,0.00,0.00,5.03,382.28,'2022-09-22 17:39:22','',''),(5756,'1','275','1',1,'Retail Sale Id 5582',8000.32,0.00,0.00,10.87,826.12,'2022-09-22 17:40:57','',''),(5757,'1','275','1',1,'Retail Sale Id 5583',2001.92,0.00,0.00,2.72,206.72,'2022-09-22 17:46:52','',''),(5758,'1','275','1',1,'Retail Sale Id 5584',9200.00,0.00,0.00,12.50,950.00,'2022-09-22 17:53:19','',''),(5759,'1','275','1',1,'Retail Sale Id 5585',1000.96,0.00,0.00,1.36,103.36,'2022-09-22 18:05:16','',''),(5760,'1','275','1',1,'Retail Sale Id 5586',2001.92,0.00,0.00,2.72,206.72,'2022-09-22 18:10:59','',''),(5761,'1','275','1',1,'Retail Sale Id 5587',4416.00,0.00,0.00,6.00,456.00,'2022-09-22 18:13:41','',''),(5762,'1','275','1',1,'Retail Sale Id 5588',9200.00,0.00,0.00,12.50,950.00,'2022-09-22 18:14:45','',''),(5763,'1','275','1',1,'Retail Sale Id 5589',8103.36,0.00,0.00,11.01,836.76,'2022-09-22 18:34:12','',''),(5764,'1','275','1',1,'Retail Sale Id 5590',9200.00,0.00,0.00,12.50,950.00,'2022-09-22 18:37:10','',''),(5765,'1','275','1',1,'Retail Sale Id 5591',2208.00,0.00,0.00,3.00,228.00,'2022-09-22 18:38:39','',''),(5766,'1','275','1',1,'Retail Sale Id 5592',4496.96,0.00,0.00,6.11,464.36,'2022-09-22 18:40:04','',''),(5767,'1','275','1',1,'Retail Sale Id 5593',4416.00,0.00,0.00,6.00,456.00,'2022-09-22 18:45:48','',''),(5768,'1','275','1',1,'Retail Sale Id 5594',4496.96,0.00,0.00,6.11,464.36,'2022-09-22 18:47:11','',''),(5769,'1','275','1',1,'Retail Sale Id 5595',16192.00,0.00,0.00,22.00,1672.00,'2022-09-22 18:47:47','',''),(5770,'1','275','1',1,'Retail Sale Id 5596',11783.36,0.00,0.00,16.01,1216.76,'2022-09-22 19:05:53','',''),(5771,'1','275','1',1,'Retail Sale Id 5597',9200.00,0.00,0.00,12.50,950.00,'2022-09-23 07:04:36','',''),(5772,'1','275','1',1,'Retail Sale Id 5598',4496.96,0.00,0.00,6.11,464.36,'2022-09-23 07:14:56','',''),(5773,'1','275','1',1,'Retail Sale Id 5599',3503.36,0.00,0.00,4.76,361.76,'2022-09-23 07:25:01','',''),(5774,'1','275','1',1,'Retail Sale Id 5600',9200.00,0.00,0.00,12.50,950.00,'2022-09-23 07:48:01','',''),(5775,'1','275','1',1,'Retail Sale Id 5601',9200.00,0.00,0.00,12.50,950.00,'2022-09-23 07:51:26','',''),(5776,'1','275','1',1,'Retail Sale Id 5602',1501.44,0.00,0.00,2.04,155.04,'2022-09-23 07:55:40','',''),(5777,'1','275','1',1,'Retail Sale Id 5603',9200.00,0.00,0.00,12.50,950.00,'2022-09-23 08:08:27','',''),(5778,'1','275','1',1,'Retail Sale Id 5604',9568.00,0.00,0.00,13.00,988.00,'2022-09-23 08:19:33','',''),(5779,'1','275','1',1,'Retail Sale Id 5605',36800.00,0.00,0.00,50.00,3800.00,'2022-09-23 09:49:04','',''),(5780,'1','275','1',1,'Retail Sale Id 5606',3503.36,0.00,0.00,4.76,361.76,'2022-09-23 09:49:58','',''),(5781,'1','275','1',1,'Retail Sale Id 5607',4496.96,0.00,0.00,6.11,464.36,'2022-09-23 09:50:44','',''),(5782,'1','275','1',1,'Retail Sale Id 5608',9200.00,0.00,0.00,12.50,950.00,'2022-09-23 09:51:35','',''),(5783,'1','275','1',1,'Retail Sale Id 5609',2303.68,0.00,0.00,3.13,237.88,'2022-09-23 09:54:03','',''),(5784,'1','275','1',1,'Retail Sale Id 5610',7499.84,0.00,0.00,10.19,774.44,'2022-09-23 09:56:14','',''),(5785,'1','275','1',1,'Retail Sale Id 5611',9200.00,0.00,0.00,12.50,950.00,'2022-09-23 09:59:36','',''),(5786,'1','275','1',1,'Retail Sale Id 5612',4416.00,0.00,0.00,6.00,456.00,'2022-09-23 10:04:59','',''),(5787,'1','275','1',1,'Retail Sale Id 5612',4416.00,0.00,0.00,6.00,456.00,'2022-09-23 10:04:59','',''),(5788,'1','275','1',1,'Retail Sale Id 5613',8000.32,0.00,0.00,10.87,826.12,'2022-09-23 10:10:02','',''),(5789,'1','275','1',1,'Retail Sale Id 5614',9200.00,0.00,0.00,12.50,950.00,'2022-09-23 10:17:56','',''),(5790,'1','275','1',1,'Retail Sale Id 5615',2252.16,0.00,0.00,3.06,232.56,'2022-09-23 10:19:59','',''),(5791,'1','275','1',1,'Retail Sale Id 5615',2252.16,0.00,0.00,3.06,232.56,'2022-09-23 10:19:59','',''),(5792,'1','275','1',1,'Retail Sale Id 5616',8500.80,0.00,0.00,11.55,877.80,'2022-09-23 10:28:46','',''),(5793,'1','275','1',1,'Retail Sale Id 5616',8500.80,0.00,0.00,11.55,877.80,'2022-09-23 10:28:46','',''),(5794,'1','275','1',1,'Retail Sale Id 5617',3002.88,0.00,0.00,4.08,310.08,'2022-09-23 10:30:05','',''),(5795,'1','275','1',1,'Retail Sale Id 5619',4496.96,0.00,0.00,6.11,464.36,'2022-09-23 10:40:19','',''),(5796,'1','275','1',1,'Retail Sale Id 5620',15500.16,0.00,0.00,21.06,1600.56,'2022-09-23 10:42:41','',''),(5797,'1','275','1',1,'Retail Sale Id 5621',9200.00,0.00,0.00,12.50,950.00,'2022-09-23 10:44:58','',''),(5798,'1','275','1',1,'Retail Sale Id 5622',4496.96,0.00,0.00,6.11,464.36,'2022-09-23 10:47:11','',''),(5799,'1','275','1',1,'Retail Sale Id 5623',8000.32,0.00,0.00,10.87,826.12,'2022-09-23 10:48:02','',''),(5800,'1','275','1',1,'Retail Sale Id 5624',9200.00,0.00,0.00,12.50,950.00,'2022-09-23 10:50:50','',''),(5801,'1','275','1',1,'Retail Sale Id 5625',2001.92,0.00,0.00,2.72,206.72,'2022-09-23 11:04:25','',''),(5802,'1','275','1',1,'Retail Sale Id 5626',9200.00,0.00,0.00,12.50,950.00,'2022-09-23 11:14:34','',''),(5803,'1','275','1',1,'Retail Sale Id 5627',4496.96,0.00,0.00,6.11,464.36,'2022-09-23 11:15:09','',''),(5804,'1','275','1',1,'Retail Sale Id 5628',4496.96,0.00,0.00,6.11,464.36,'2022-09-23 11:24:15','',''),(5805,'1','275','1',1,'Retail Sale Id 5629',9200.00,0.00,0.00,12.50,950.00,'2022-09-23 11:27:58','',''),(5806,'1','275','1',1,'Retail Sale Id 5630',9200.00,0.00,0.00,12.50,950.00,'2022-09-23 11:36:37','',''),(5807,'1','275','1',1,'Retail Sale Id 5631',2001.92,0.00,0.00,2.72,206.72,'2022-09-23 11:56:16','',''),(5808,'1','275','1',1,'Retail Sale Id 5632',9200.00,0.00,0.00,12.50,950.00,'2022-09-23 12:36:53','',''),(5809,'1','275','1',1,'Retail Sale Id 5633',3503.36,0.00,0.00,4.76,361.76,'2022-09-23 12:38:19','',''),(5810,'1','275','1',1,'Retail Sale Id 5634',9001.28,0.00,0.00,12.23,929.48,'2022-09-23 12:39:18','',''),(5811,'1','275','1',1,'Retail Sale Id 5635',5902.72,0.00,0.00,8.02,609.52,'2022-09-23 12:45:49','',''),(5812,'1','275','1',1,'Retail Sale Id 5636',9200.00,0.00,0.00,12.50,950.00,'2022-09-23 13:08:40','',''),(5813,'1','275','1',1,'Retail Sale Id 5637',2208.00,0.00,0.00,3.00,228.00,'2022-09-23 13:13:06','',''),(5814,'1','275','1',1,'Retail Sale Id 5638',9200.00,0.00,0.00,12.50,950.00,'2022-09-23 13:27:22','',''),(5815,'1','275','1',1,'Retail Sale Id 5639',2502.40,0.00,0.00,3.40,258.40,'2022-09-23 13:34:41','',''),(5816,'1','275','1',1,'Retail Sale Id 5640',18400.00,0.00,0.00,25.00,1900.00,'2022-09-23 13:37:57','',''),(5817,'1','275','1',1,'Retail Sale Id 5640',18400.00,0.00,0.00,25.00,1900.00,'2022-09-23 13:37:57','',''),(5818,'1','275','1',1,'Retail Sale Id 5641',4496.96,0.00,0.00,6.11,464.36,'2022-09-23 13:45:45','',''),(5819,'1','275','1',1,'Retail Sale Id 5642',4496.96,0.00,0.00,6.11,464.36,'2022-09-23 14:39:28','',''),(5820,'1','275','1',1,'Retail Sale Id 5642',9200.00,0.00,0.00,12.50,950.00,'2022-09-23 14:39:28','',''),(5821,'1','275','1',1,'Retail Sale Id 5643',9200.00,0.00,0.00,12.50,950.00,'2022-09-23 14:40:47','',''),(5822,'1','275','1',1,'Retail Sale Id 5644',9200.00,0.00,0.00,12.50,950.00,'2022-09-23 14:41:57','',''),(5823,'1','275','1',1,'Retail Sale Id 5645',9200.00,0.00,0.00,12.50,950.00,'2022-09-23 14:42:56','',''),(5824,'1','275','1',1,'Retail Sale Id 5646',9200.00,0.00,0.00,12.50,950.00,'2022-09-23 14:43:45','',''),(5825,'1','275','1',1,'Retail Sale Id 5647',2208.00,0.00,0.00,3.00,228.00,'2022-09-23 14:55:46','',''),(5826,'1','275','1',1,'Retail Sale Id 5647',4416.00,0.00,0.00,6.00,456.00,'2022-09-23 14:55:46','',''),(5827,'1','275','1',1,'Retail Sale Id 5648',11040.00,0.00,0.00,15.00,1140.00,'2022-09-23 14:58:48','',''),(5828,'1','275','1',1,'Retail Sale Id 5649',2001.92,0.00,0.00,2.72,206.72,'2022-09-23 15:07:08','',''),(5829,'1','275','1',1,'Retail Sale Id 5650',7396.80,0.00,0.00,10.05,763.80,'2022-09-23 15:08:37','',''),(5830,'1','275','1',1,'Retail Sale Id 5651',3002.88,0.00,0.00,4.08,310.08,'2022-09-23 15:12:20','',''),(5831,'1','275','1',1,'Retail Sale Id 5652',9200.00,0.00,0.00,12.50,950.00,'2022-09-23 15:13:29','',''),(5832,'1','275','1',1,'Retail Sale Id 5653',1000.96,0.00,0.00,1.36,103.36,'2022-09-23 15:14:51','',''),(5833,'1','275','1',1,'Retail Sale Id 5654',1000.96,0.00,0.00,1.36,103.36,'2022-09-23 15:23:58','',''),(5834,'1','275','1',1,'Retail Sale Id 5655',1000.96,0.00,0.00,1.36,103.36,'2022-09-23 15:29:43','',''),(5835,'1','275','1',1,'Retail Sale Id 5656',9200.00,0.00,0.00,12.50,950.00,'2022-09-23 15:34:41','',''),(5836,'1','275','1',1,'Retail Sale Id 5658',2001.92,0.00,0.00,2.72,206.72,'2022-09-23 15:42:12','',''),(5837,'1','275','1',1,'Retail Sale Id 5659',6999.36,0.00,0.00,9.51,722.76,'2022-09-23 15:48:00','',''),(5838,'1','275','1',1,'Retail Sale Id 5660',802.24,0.00,0.00,1.09,82.84,'2022-09-23 15:59:20','',''),(5839,'1','275','1',1,'Retail Sale Id 5661',9200.00,0.00,0.00,12.50,950.00,'2022-09-23 16:33:12','',''),(5840,'1','275','1',1,'Retail Sale Id 5662',2208.00,0.00,0.00,3.00,228.00,'2022-09-23 16:37:08','',''),(5841,'1','275','1',1,'Retail Sale Id 5663',1501.44,0.00,0.00,2.04,155.04,'2022-09-23 16:39:46','',''),(5842,'1','275','1',1,'Retail Sale Id 5664',1501.44,0.00,0.00,2.04,155.04,'2022-09-23 16:54:42','',''),(5843,'1','275','1',1,'Retail Sale Id 5665',4496.96,0.00,0.00,6.11,464.36,'2022-09-23 16:58:07','',''),(5844,'1','275','1',1,'Retail Sale Id 5666',2001.92,0.00,0.00,2.72,206.72,'2022-09-23 16:59:41','',''),(5845,'1','275','1',1,'Retail Sale Id 5667',4997.44,0.00,0.00,6.79,516.04,'2022-09-23 17:00:31','',''),(5846,'1','275','1',1,'Retail Sale Id 5668',3002.88,0.00,0.00,4.08,310.08,'2022-09-23 17:01:53','',''),(5847,'1','275','1',1,'Retail Sale Id 5669',9200.00,0.00,0.00,12.50,950.00,'2022-09-23 17:03:46','',''),(5848,'1','275','1',1,'Retail Sale Id 5670',9200.00,0.00,0.00,12.50,950.00,'2022-09-23 17:06:44','',''),(5849,'1','275','1',1,'Retail Sale Id 5671',4416.00,0.00,0.00,6.00,456.00,'2022-09-23 17:13:32','',''),(5850,'1','275','1',1,'Retail Sale Id 5671',17664.00,0.00,0.00,24.00,1824.00,'2022-09-23 17:13:32','',''),(5851,'1','275','1',1,'Retail Sale Id 5672',18400.00,0.00,0.00,25.00,1900.00,'2022-09-23 17:17:40','',''),(5852,'1','275','1',1,'Retail Sale Id 5673',9200.00,0.00,0.00,12.50,950.00,'2022-09-23 17:22:34','',''),(5853,'1','275','1',1,'Retail Sale Id 5674',9200.00,0.00,0.00,12.50,950.00,'2022-09-23 17:36:05','',''),(5854,'1','275','1',1,'Retail Sale Id 5675',6999.36,0.00,0.00,9.51,722.76,'2022-09-23 17:38:22','',''),(5855,'1','275','1',1,'Retail Sale Id 5676',5998.40,0.00,0.00,8.15,619.40,'2022-09-23 17:43:12','',''),(5856,'1','275','1',1,'Retail Sale Id 5677',9200.00,0.00,0.00,12.50,950.00,'2022-09-23 17:45:37','',''),(5857,'1','275','1',1,'Retail Sale Id 5678',5998.40,0.00,0.00,8.15,619.40,'2022-09-23 17:46:40','',''),(5858,'1','275','1',1,'Retail Sale Id 5679',3996.48,0.00,0.00,5.43,412.68,'2022-09-23 17:47:50','',''),(5859,'1','275','1',1,'Retail Sale Id 5680',3002.88,0.00,0.00,4.08,310.08,'2022-09-23 17:48:54','',''),(5860,'1','275','1',1,'Retail Sale Id 5681',4496.96,0.00,0.00,6.11,464.36,'2022-09-23 17:55:39','',''),(5861,'1','275','1',1,'Retail Sale Id 5682',5998.40,0.00,0.00,8.15,619.40,'2022-09-23 18:02:19','',''),(5862,'1','275','1',1,'Retail Sale Id 5683',4997.44,0.00,0.00,6.79,516.04,'2022-09-23 18:04:07','',''),(5863,'1','275','1',1,'Retail Sale Id 5684',2303.68,0.00,0.00,3.13,237.88,'2022-09-23 18:11:43','',''),(5864,'1','275','1',1,'Retail Sale Id 5685',2303.68,0.00,0.00,3.13,237.88,'2022-09-23 18:18:17','',''),(5865,'1','275','1',1,'Retail Sale Id 5686',9200.00,0.00,0.00,12.50,950.00,'2022-09-23 18:24:49','',''),(5866,'1','275','1',1,'Retail Sale Id 5687',1000.96,0.00,0.00,1.36,103.36,'2022-09-23 18:31:35','',''),(5867,'1','275','1',1,'Retail Sale Id 5688',66129.60,0.00,0.00,89.85,6828.60,'2022-09-23 19:41:37','',''),(5868,'1','275','1',1,'Retail Sale Id 5689',4416.00,0.00,0.00,6.00,456.00,'2022-09-24 06:53:24','',''),(5869,'1','275','1',1,'Retail Sale Id 5689',4416.00,0.00,0.00,6.00,456.00,'2022-09-24 06:53:24','',''),(5870,'1','275','1',1,'Retail Sale Id 5689',8832.00,0.00,0.00,12.00,912.00,'2022-09-24 06:53:24','',''),(5871,'1','275','1',1,'Retail Sale Id 5690',4496.96,0.00,0.00,6.11,464.36,'2022-09-24 06:55:44','',''),(5872,'1','275','1',1,'Retail Sale Id 5691',2208.00,0.00,0.00,3.00,228.00,'2022-09-24 07:02:03','',''),(5873,'1','275','1',1,'Retail Sale Id 5692',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 07:47:00','',''),(5874,'1','275','1',1,'Retail Sale Id 5693',9001.28,0.00,0.00,12.23,929.48,'2022-09-24 07:56:57','',''),(5875,'1','275','1',1,'Retail Sale Id 5694',2303.68,0.00,0.00,3.13,237.88,'2022-09-24 08:17:51','',''),(5876,'1','275','1',1,'Retail Sale Id 5695',3680.00,0.00,0.00,5.00,380.00,'2022-09-24 08:20:40','',''),(5877,'1','275','1',1,'Retail Sale Id 5695',3680.00,0.00,0.00,5.00,380.00,'2022-09-24 08:20:40','',''),(5878,'1','275','1',1,'Retail Sale Id 5696',3702.08,0.00,0.00,5.03,382.28,'2022-09-24 08:29:16','',''),(5879,'1','275','1',1,'Retail Sale Id 5697',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 08:42:33','',''),(5880,'1','275','1',1,'Retail Sale Id 5698',2303.68,0.00,0.00,3.13,237.88,'2022-09-24 09:01:16','',''),(5881,'1','275','1',1,'Retail Sale Id 5699',36800.00,0.00,0.00,50.00,3800.00,'2022-09-24 09:03:21','',''),(5882,'1','275','1',1,'Retail Sale Id 5700',1398.40,0.00,0.00,1.90,144.40,'2022-09-24 09:15:55','',''),(5883,'1','275','1',1,'Retail Sale Id 5701',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 09:26:54','',''),(5884,'1','275','1',1,'Retail Sale Id 5702',1000.96,0.00,0.00,1.36,103.36,'2022-09-24 09:32:23','',''),(5885,'1','275','1',1,'Retail Sale Id 5703',2303.68,0.00,0.00,3.13,237.88,'2022-09-24 09:39:32','',''),(5886,'1','275','1',1,'Retail Sale Id 5704',6999.36,0.00,0.00,9.51,722.76,'2022-09-24 09:41:45','',''),(5887,'1','275','1',1,'Retail Sale Id 5705',1501.44,0.00,0.00,2.04,155.04,'2022-09-24 09:42:44','',''),(5888,'1','275','1',1,'Retail Sale Id 5706',4496.96,0.00,0.00,6.11,464.36,'2022-09-24 09:45:05','',''),(5889,'1','275','1',1,'Retail Sale Id 5707',2208.00,0.00,0.00,3.00,228.00,'2022-09-24 09:50:28','',''),(5890,'1','275','1',1,'Retail Sale Id 5709',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 09:58:12','',''),(5891,'1','275','1',1,'Retail Sale Id 5710',736.00,0.00,0.00,1.00,76.00,'2022-09-24 10:03:14','',''),(5892,'1','275','1',1,'Return of Retail Sale Id 5710',0.00,736.00,1.00,0.00,-76.00,'2022-09-24 10:03:25','',''),(5893,'1','275','1',1,'Retail Sale Id 5711',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 10:03:53','',''),(5894,'1','275','1',1,'Retail Sale Id 5712',2303.68,0.00,0.00,3.13,237.88,'2022-09-24 10:34:03','',''),(5895,'1','275','1',1,'Retail Sale Id 5713',5998.40,0.00,0.00,8.15,619.40,'2022-09-24 10:36:14','',''),(5896,'1','275','1',1,'Retail Sale Id 5714',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 10:40:09','',''),(5897,'1','275','1',1,'Retail Sale Id 5715',14720.00,0.00,0.00,20.00,1520.00,'2022-09-24 10:42:03','',''),(5898,'1','275','1',1,'Retail Sale Id 5716',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 10:44:12','',''),(5899,'1','275','1',1,'Retail Sale Id 5717',9001.28,0.00,0.00,12.23,929.48,'2022-09-24 10:45:54','',''),(5900,'1','275','1',1,'Retail Sale Id 5718',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 11:00:08','',''),(5901,'1','275','1',1,'Retail Sale Id 5719',1000.96,0.00,0.00,1.36,103.36,'2022-09-24 11:01:00','',''),(5902,'1','275','1',1,'Retail Sale Id 5720',1501.44,0.00,0.00,2.04,155.04,'2022-09-24 11:01:43','',''),(5903,'1','275','1',1,'Retail Sale Id 5721',4600.00,0.00,0.00,6.25,475.00,'2022-09-24 11:05:03','',''),(5904,'1','275','1',1,'Retail Sale Id 5722',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 11:14:02','',''),(5905,'1','275','1',1,'Retail Sale Id 5723',2001.92,0.00,0.00,2.72,206.72,'2022-09-24 11:15:47','',''),(5906,'1','275','1',1,'Retail Sale Id 5724',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 11:17:16','',''),(5907,'1','275','1',1,'Retail Sale Id 5725',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 11:23:12','',''),(5908,'1','275','1',1,'Retail Sale Id 5726',4496.96,0.00,0.00,6.11,464.36,'2022-09-24 11:32:08','',''),(5909,'1','275','1',1,'Retail Sale Id 5727',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 11:42:43','',''),(5910,'1','275','1',1,'Retail Sale Id 5728',2001.92,0.00,0.00,2.72,206.72,'2022-09-24 11:46:04','',''),(5911,'1','275','1',1,'Retail Sale Id 5729',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 11:51:48','',''),(5912,'1','275','1',1,'Retail Sale Id 5730',4784.00,0.00,0.00,6.50,494.00,'2022-09-24 11:57:22','',''),(5913,'1','275','1',1,'Retail Sale Id 5730',4784.00,0.00,0.00,6.50,494.00,'2022-09-24 11:57:22','',''),(5914,'1','275','1',1,'Retail Sale Id 5730',4784.00,0.00,0.00,6.50,494.00,'2022-09-24 11:57:22','',''),(5915,'1','275','1',1,'Retail Sale Id 5731',1000.96,0.00,0.00,1.36,103.36,'2022-09-24 12:00:03','',''),(5916,'1','275','1',1,'Retail Sale Id 5732',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 12:12:09','',''),(5917,'1','275','1',1,'Retail Sale Id 5733',4496.96,0.00,0.00,6.11,464.36,'2022-09-24 12:37:52','',''),(5918,'1','275','1',1,'Retail Sale Id 5734',4416.00,0.00,0.00,6.00,456.00,'2022-09-24 12:53:47','',''),(5919,'1','275','1',1,'Retail Sale Id 5735',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 12:58:34','',''),(5920,'1','275','1',1,'Retail Sale Id 5736',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 13:01:40','',''),(5921,'1','275','1',1,'Retail Sale Id 5737',2502.40,0.00,0.00,3.40,258.40,'2022-09-24 13:03:47','',''),(5922,'1','275','1',1,'Retail Sale Id 5738',5203.52,0.00,0.00,7.07,537.32,'2022-09-24 13:18:05','',''),(5923,'1','275','1',1,'Retail Sale Id 5739',2303.68,0.00,0.00,3.13,237.88,'2022-09-24 13:19:02','',''),(5924,'1','275','1',1,'Retail Sale Id 5740',8000.32,0.00,0.00,10.87,826.12,'2022-09-24 13:20:05','',''),(5925,'1','275','1',1,'Retail Sale Id 5741',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 13:26:27','',''),(5926,'1','275','1',1,'Retail Sale Id 5742',3680.00,0.00,0.00,5.00,380.00,'2022-09-24 13:30:01','',''),(5927,'1','275','1',1,'Retail Sale Id 5743',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 13:34:22','',''),(5928,'1','275','1',1,'Retail Sale Id 5744',18400.00,0.00,0.00,25.00,1900.00,'2022-09-24 13:35:03','',''),(5929,'1','275','1',1,'Retail Sale Id 5745',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 13:41:33','',''),(5930,'1','275','1',1,'Retail Sale Id 5746',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 13:43:35','',''),(5931,'1','275','1',1,'Retail Sale Id 5747',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 13:44:46','',''),(5932,'1','275','1',1,'Retail Sale Id 5748',3702.08,0.00,0.00,5.03,382.28,'2022-09-24 13:51:05','',''),(5933,'1','275','1',1,'Retail Sale Id 5749',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 13:53:05','',''),(5934,'1','275','1',1,'Retail Sale Id 5750',18400.00,0.00,0.00,25.00,1900.00,'2022-09-24 13:54:05','',''),(5935,'1','275','1',1,'Retail Sale Id 5751',2208.00,0.00,0.00,3.00,228.00,'2022-09-24 13:55:17','',''),(5936,'1','275','1',1,'Retail Sale Id 5751',3680.00,0.00,0.00,5.00,380.00,'2022-09-24 13:55:17','',''),(5937,'1','275','1',1,'Retail Sale Id 5752',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 13:58:13','',''),(5938,'1','275','1',1,'Retail Sale Id 5753',9001.28,0.00,0.00,12.23,929.48,'2022-09-24 13:59:45','',''),(5939,'1','275','1',1,'Retail Sale Id 5754',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 14:08:20','',''),(5940,'1','275','1',1,'Retail Sale Id 5755',3002.88,0.00,0.00,4.08,310.08,'2022-09-24 14:29:54','',''),(5941,'1','275','1',1,'Retail Sale Id 5756',1501.44,0.00,0.00,2.04,155.04,'2022-09-24 14:32:05','',''),(5942,'1','275','1',1,'Retail Sale Id 5757',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 14:35:10','',''),(5943,'1','275','1',1,'Retail Sale Id 5758',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 14:43:34','',''),(5944,'1','275','1',1,'Retail Sale Id 5759',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 14:53:23','',''),(5945,'1','275','1',1,'Retail Sale Id 5760',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 15:07:58','',''),(5946,'1','275','1',1,'Retail Sale Id 5761',1501.44,0.00,0.00,2.04,155.04,'2022-09-24 15:10:29','',''),(5947,'1','275','1',1,'Retail Sale Id 5762',1501.44,0.00,0.00,2.04,155.04,'2022-09-24 15:12:49','',''),(5948,'1','275','1',1,'Retail Sale Id 5763',3680.00,0.00,0.00,5.00,380.00,'2022-09-24 15:18:16','',''),(5949,'1','275','1',1,'Retail Sale Id 5764',2001.92,0.00,0.00,2.72,206.72,'2022-09-24 15:19:56','',''),(5950,'1','275','1',1,'Retail Sale Id 5765',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 15:21:08','',''),(5951,'1','275','1',1,'Retail Sale Id 5766',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 15:22:30','',''),(5952,'1','275','1',1,'Retail Sale Id 5767',4416.00,0.00,0.00,6.00,456.00,'2022-09-24 15:26:43','',''),(5953,'1','275','1',1,'Retail Sale Id 5767',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 15:26:43','',''),(5954,'1','275','1',1,'Retail Sale Id 5768',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 15:30:26','',''),(5955,'1','275','1',1,'Retail Sale Id 5769',4496.96,0.00,0.00,6.11,464.36,'2022-09-24 15:34:43','',''),(5956,'1','275','1',1,'Retail Sale Id 5770',8096.00,0.00,0.00,11.00,836.00,'2022-09-24 15:39:10','',''),(5957,'1','275','1',1,'Retail Sale Id 5771',4416.00,0.00,0.00,6.00,456.00,'2022-09-24 15:40:51','',''),(5958,'1','275','1',1,'Retail Sale Id 5772',29498.88,0.00,0.00,40.08,3046.08,'2022-09-24 15:42:46','',''),(5959,'1','275','1',1,'Retail Sale Id 5773',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 15:43:36','',''),(5960,'1','275','1',1,'Retail Sale Id 5774',7360.00,0.00,0.00,10.00,760.00,'2022-09-24 15:44:58','',''),(5961,'1','275','1',1,'Retail Sale Id 5775',736.00,0.00,0.00,1.00,76.00,'2022-09-24 15:48:23','',''),(5962,'1','275','1',1,'Return of Retail Sale Id 5775',0.00,736.00,1.00,0.00,-76.00,'2022-09-24 15:48:33','',''),(5963,'1','275','1',1,'Retail Sale Id 5776',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 15:48:57','',''),(5964,'1','275','1',1,'Retail Sale Id 5777',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 15:51:28','',''),(5965,'1','275','1',1,'Retail Sale Id 5778',8832.00,0.00,0.00,12.00,912.00,'2022-09-24 15:53:18','',''),(5966,'1','275','1',1,'Retail Sale Id 5779',4496.96,0.00,0.00,6.11,464.36,'2022-09-24 16:03:56','',''),(5967,'1','275','1',1,'Retail Sale Id 5780',8199.04,0.00,0.00,11.14,846.64,'2022-09-24 16:05:22','',''),(5968,'1','275','1',1,'Retail Sale Id 5781',8000.32,0.00,0.00,10.87,826.12,'2022-09-24 16:09:01','',''),(5969,'1','275','1',1,'Retail Sale Id 5782',3996.48,0.00,0.00,5.43,412.68,'2022-09-24 16:10:23','',''),(5970,'1','275','1',1,'Retail Sale Id 5783',2303.68,0.00,0.00,3.13,237.88,'2022-09-24 16:16:08','',''),(5971,'1','275','1',1,'Return of Retail Sale Id 5777',0.00,9200.00,12.50,0.00,-950.00,'2022-09-24 16:17:04','',''),(5972,'1','275','1',1,'Retail Sale Id 5784',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 16:24:00','',''),(5973,'1','275','1',1,'Retail Sale Id 5785',3503.36,0.00,0.00,4.76,361.76,'2022-09-24 16:28:28','',''),(5974,'1','275','1',1,'Retail Sale Id 5786',1501.44,0.00,0.00,2.04,155.04,'2022-09-24 16:43:10','',''),(5975,'1','275','1',1,'Retail Sale Id 5787',2303.68,0.00,0.00,3.13,237.88,'2022-09-24 16:46:45','',''),(5976,'1','275','1',1,'Retail Sale Id 5788',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 16:54:02','',''),(5977,'1','275','1',1,'Retail Sale Id 5789',2701.12,0.00,0.00,3.67,278.92,'2022-09-24 16:54:49','',''),(5978,'1','275','1',1,'Retail Sale Id 5790',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 17:18:49','',''),(5979,'1','275','1',1,'Retail Sale Id 5791',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 17:21:13','',''),(5980,'1','275','1',1,'Retail Sale Id 5792',4496.96,0.00,0.00,6.11,464.36,'2022-09-24 17:22:53','',''),(5981,'1','275','1',1,'Retail Sale Id 5793',7499.84,0.00,0.00,10.19,774.44,'2022-09-24 17:23:51','',''),(5982,'1','275','1',1,'Retail Sale Id 5794',1501.44,0.00,0.00,2.04,155.04,'2022-09-24 17:29:48','',''),(5983,'1','275','1',1,'Retail Sale Id 5795',4416.00,0.00,0.00,6.00,456.00,'2022-09-24 17:35:55','',''),(5984,'1','275','1',1,'Retail Sale Id 5796',2208.00,0.00,0.00,3.00,228.00,'2022-09-24 17:36:56','',''),(5985,'1','275','1',1,'Retail Sale Id 5797',1501.44,0.00,0.00,2.04,155.04,'2022-09-24 17:39:19','',''),(5986,'1','275','1',1,'Retail Sale Id 5798',4997.44,0.00,0.00,6.79,516.04,'2022-09-24 17:40:13','',''),(5987,'1','275','1',1,'Retail Sale Id 5799',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 17:41:08','',''),(5988,'1','275','1',1,'Retail Sale Id 5800',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 17:45:24','',''),(5989,'1','275','1',1,'Retail Sale Id 5801',1501.44,0.00,0.00,2.04,155.04,'2022-09-24 17:46:37','',''),(5990,'1','275','1',1,'Retail Sale Id 5802',3002.88,0.00,0.00,4.08,310.08,'2022-09-24 17:51:04','',''),(5991,'1','275','1',1,'Retail Sale Id 5802',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 17:51:04','',''),(5992,'1','275','1',1,'Return of Retail Sale Id 5802',0.00,3002.88,4.08,0.00,-310.08,'2022-09-24 17:51:49','',''),(5993,'1','275','1',1,'Return of Retail Sale Id 5802',0.00,9200.00,12.50,0.00,-950.00,'2022-09-24 17:51:49','',''),(5994,'1','275','1',1,'Retail Sale Id 5803',3996.48,0.00,0.00,5.43,412.68,'2022-09-24 17:54:11','',''),(5995,'1','275','1',1,'Retail Sale Id 5803',9200.00,0.00,0.00,12.50,950.00,'2022-09-24 17:54:11','',''),(5996,'1','275','1',1,'Retail Sale Id 5804',1398.40,0.00,0.00,1.90,144.40,'2022-09-24 17:56:37','',''),(5997,'1','275','1',1,'Retail Sale Id 5805',3002.88,0.00,0.00,4.08,310.08,'2022-09-24 17:57:36','',''),(5998,'1','275','1',1,'Retail Sale Id 5806',500.48,0.00,0.00,0.68,51.68,'2022-09-24 18:09:09','',''),(5999,'1','275','1',1,'Retail Sale Id 5807',4416.00,0.00,0.00,6.00,456.00,'2022-09-24 18:16:50','',''),(6000,'1','275','1',1,'Retail Sale Id 5809',8000.32,0.00,0.00,10.87,826.12,'2022-09-24 18:31:41','',''),(6001,'1','275','1',1,'Retail Sale Id 5810',3996.48,0.00,0.00,5.43,412.68,'2022-09-24 18:40:38','',''),(6002,'1','275','1',1,'Retail Sale Id 5811',3702.08,0.00,0.00,5.03,382.28,'2022-09-24 18:43:32','',''),(6003,'1','275','1',1,'Retail Sale Id 5812',10304.00,0.00,0.00,14.00,1064.00,'2022-09-24 18:46:14','',''),(6004,'1','275','1',1,'Retail Sale Id 5813',1501.44,0.00,0.00,2.04,155.04,'2022-09-24 18:47:40','',''),(6005,'1','275','1',1,'Retail Sale Id 5814',2001.92,0.00,0.00,2.72,206.72,'2022-09-24 18:49:12','',''),(6006,'1','275','1',1,'Return of Retail Sale Id 5812',0.00,10304.00,14.00,0.00,-1064.00,'2022-09-24 19:00:27','',''),(6007,'1','275','1',1,'Return of Retail Sale Id 5811',0.00,3702.08,5.03,0.00,-382.28,'2022-09-24 19:01:18','',''),(6008,'1','275','1',1,'Retail Sale Id 5815',478.40,0.00,0.00,0.65,49.40,'2022-09-24 19:02:16','',''),(6009,'1','275','1',1,'Retail Sale Id 5816',2303.68,0.00,0.00,3.13,237.88,'2022-09-25 06:56:48','',''),(6010,'1','275','1',1,'Return of Retail Sale Id 5816',0.00,2303.68,3.13,0.00,-237.88,'2022-09-25 06:58:06','',''),(6011,'1','275','1',1,'Retail Sale Id 5817',2252.16,0.00,0.00,3.06,232.56,'2022-09-25 06:58:44','',''),(6012,'1','275','1',1,'Retail Sale Id 5818',9200.00,0.00,0.00,12.50,950.00,'2022-09-25 07:25:05','',''),(6013,'1','275','1',1,'Retail Sale Id 5819',3702.08,0.00,0.00,5.03,382.28,'2022-09-25 07:26:07','',''),(6014,'1','275','1',1,'Retail Sale Id 5820',2001.92,0.00,0.00,2.72,206.72,'2022-09-25 08:04:48','',''),(6015,'1','275','1',1,'Retail Sale Id 5821',1501.44,0.00,0.00,2.04,155.04,'2022-09-25 08:11:48','',''),(6016,'1','275','1',1,'Retail Sale Id 5822',34996.80,0.00,0.00,47.55,3613.80,'2022-09-25 08:32:35','',''),(6017,'1','275','1',1,'Retail Sale Id 5823',1501.44,0.00,0.00,2.04,155.04,'2022-09-25 08:38:17','',''),(6018,'1','275','1',1,'Retail Sale Id 5824',1501.44,0.00,0.00,2.04,155.04,'2022-09-25 08:58:14','',''),(6019,'1','275','1',1,'Retail Sale Id 5825',9200.00,0.00,0.00,12.50,950.00,'2022-09-25 08:59:43','',''),(6020,'1','275','1',1,'Retail Sale Id 5826',9200.00,0.00,0.00,12.50,950.00,'2022-09-25 09:04:16','',''),(6021,'1','275','1',1,'Retail Sale Id 5827',2001.92,0.00,0.00,2.72,206.72,'2022-09-25 09:07:57','',''),(6022,'1','275','1',1,'Retail Sale Id 5827',4416.00,0.00,0.00,6.00,456.00,'2022-09-25 09:07:57','',''),(6023,'1','275','1',1,'Retail Sale Id 5827',9200.00,0.00,0.00,12.50,950.00,'2022-09-25 09:07:57','',''),(6024,'1','275','1',1,'Retail Sale Id 5828',3702.08,0.00,0.00,5.03,382.28,'2022-09-25 09:10:36','',''),(6025,'1','275','1',1,'Retail Sale Id 5829',9200.00,0.00,0.00,12.50,950.00,'2022-09-25 09:12:50','',''),(6026,'1','275','1',1,'Retail Sale Id 5830',4496.96,0.00,0.00,6.11,464.36,'2022-09-25 09:17:34','',''),(6027,'1','275','1',1,'Retail Sale Id 5831',34996.80,0.00,0.00,47.55,3613.80,'2022-09-25 09:24:07','',''),(6028,'1','275','1',1,'Retail Sale Id 5832',4496.96,0.00,0.00,6.11,464.36,'2022-09-25 09:27:16','',''),(6029,'1','275','1',1,'Retail Sale Id 5833',5888.00,0.00,0.00,8.00,608.00,'2022-09-25 09:30:58','',''),(6030,'1','275','1',1,'Retail Sale Id 5834',9200.00,0.00,0.00,12.50,950.00,'2022-09-25 09:39:16','',''),(6031,'1','275','1',1,'Retail Sale Id 5835',9200.00,0.00,0.00,12.50,950.00,'2022-09-25 09:43:15','',''),(6032,'1','275','1',1,'Retail Sale Id 5836',4496.96,0.00,0.00,6.11,464.36,'2022-09-25 09:44:55','',''),(6033,'1','275','1',1,'Retail Sale Id 5837',1501.44,0.00,0.00,2.04,155.04,'2022-09-25 10:03:36','',''),(6034,'1','275','1',1,'Retail Sale Id 5838',4600.00,0.00,0.00,6.25,475.00,'2022-09-25 10:05:02','',''),(6035,'1','275','1',1,'Retail Sale Id 5839',8199.04,0.00,0.00,11.14,846.64,'2022-09-25 10:09:45','',''),(6036,'1','275','1',1,'Retail Sale Id 5840',2303.68,0.00,0.00,3.13,237.88,'2022-09-25 10:10:36','',''),(6037,'1','275','1',1,'Retail Sale Id 5841',3702.08,0.00,0.00,5.03,382.28,'2022-09-25 10:20:45','',''),(6038,'1','275','1',1,'Retail Sale Id 5842',2208.00,0.00,0.00,3.00,228.00,'2022-09-25 10:28:06','',''),(6039,'1','275','1',1,'Retail Sale Id 5842',2208.00,0.00,0.00,3.00,228.00,'2022-09-25 10:28:06','',''),(6040,'1','275','1',1,'Retail Sale Id 5843',9200.00,0.00,0.00,12.50,950.00,'2022-09-25 10:35:06','',''),(6041,'1','275','1',1,'Retail Sale Id 5844',3002.88,0.00,0.00,4.08,310.08,'2022-09-25 10:46:07','',''),(6042,'1','275','1',1,'Retail Sale Id 5845',2701.12,0.00,0.00,3.67,278.92,'2022-09-25 10:48:32','',''),(6043,'1','275','1',1,'Retail Sale Id 5846',1501.44,0.00,0.00,2.04,155.04,'2022-09-25 10:50:07','',''),(6044,'1','275','1',1,'Retail Sale Id 5847',9200.00,0.00,0.00,12.50,950.00,'2022-09-25 10:57:04','',''),(6045,'1','275','1',1,'Retail Sale Id 5848',9200.00,0.00,0.00,12.50,950.00,'2022-09-25 11:02:01','',''),(6046,'1','275','1',1,'Retail Sale Id 5849',9200.00,0.00,0.00,12.50,950.00,'2022-09-25 11:03:53','',''),(6047,'1','275','1',1,'Retail Sale Id 5850',3002.88,0.00,0.00,4.08,310.08,'2022-09-25 11:04:52','',''),(6048,'1','275','1',1,'Retail Sale Id 5851',1501.44,0.00,0.00,2.04,155.04,'2022-09-25 11:15:29','',''),(6049,'1','275','1',1,'Retail Sale Id 5851',9200.00,0.00,0.00,12.50,950.00,'2022-09-25 11:15:29','',''),(6050,'1','275','1',1,'Retail Sale Id 5852',4416.00,0.00,0.00,6.00,456.00,'2022-09-25 11:16:30','',''),(6051,'1','275','1',1,'Retail Sale Id 5853',9200.00,0.00,0.00,12.50,950.00,'2022-09-25 11:20:31','',''),(6052,'1','275','1',1,'Retail Sale Id 5854',2001.92,0.00,0.00,2.72,206.72,'2022-09-25 11:28:05','',''),(6053,'1','275','1',1,'Retail Sale Id 5855',2001.92,0.00,0.00,2.72,206.72,'2022-09-25 11:28:54','',''),(6054,'1','275','1',1,'Retail Sale Id 5856',2303.68,0.00,0.00,3.13,237.88,'2022-09-25 11:32:04','',''),(6055,'1','275','1',1,'Retail Sale Id 5857',30912.00,0.00,0.00,42.00,3192.00,'2022-09-25 11:39:47','',''),(6056,'1','275','1',1,'Return of Retail Sale Id 5849',0.00,9200.00,12.50,0.00,-950.00,'2022-09-25 11:40:45','',''),(6057,'1','275','1',1,'Retail Sale Id 5858',9200.00,0.00,0.00,12.50,950.00,'2022-09-25 11:44:29','',''),(6058,'1','275','1',1,'Retail Sale Id 5858',36800.00,0.00,0.00,50.00,3800.00,'2022-09-25 11:44:29','',''),(6059,'1','275','1',1,'Retail Sale Id 5859',1000.96,0.00,0.00,1.36,103.36,'2022-09-25 11:46:31','',''),(6060,'1','275','1',1,'Retail Sale Id 5860',2303.68,0.00,0.00,3.13,237.88,'2022-09-25 11:54:47','',''),(6061,'1','275','1',1,'Retail Sale Id 5861',3702.08,0.00,0.00,5.03,382.28,'2022-09-25 11:58:30','',''),(6062,'1','275','1',1,'Retail Sale Id 5862',1501.44,0.00,0.00,2.04,155.04,'2022-09-25 12:03:00','',''),(6063,'1','275','1',1,'Retail Sale Id 5863',2502.40,0.00,0.00,3.40,258.40,'2022-09-25 12:05:54','',''),(6064,'1','275','1',1,'Retail Sale Id 5864',2303.68,0.00,0.00,3.13,237.88,'2022-09-25 12:06:47','',''),(6065,'1','275','1',1,'Retail Sale Id 5865',9200.00,0.00,0.00,12.50,950.00,'2022-09-25 12:20:46','',''),(6066,'1','275','1',1,'Retail Sale Id 5866',18002.56,0.00,0.00,24.46,1858.96,'2022-09-25 12:27:40','',''),(6067,'1','275','1',1,'Retail Sale Id 5867',4496.96,0.00,0.00,6.11,464.36,'2022-09-25 12:28:29','',''),(6068,'1','275','1',1,'Retail Sale Id 5868',9200.00,0.00,0.00,12.50,950.00,'2022-09-25 12:31:51','',''),(6069,'1','275','1',1,'Retail Sale Id 5869',3702.08,0.00,0.00,5.03,382.28,'2022-09-25 12:32:53','',''),(6070,'1','275','1',1,'Retail Sale Id 5870',2303.68,0.00,0.00,3.13,237.88,'2022-09-25 12:35:13','',''),(6071,'1','275','1',1,'Retail Sale Id 5871',9200.00,0.00,0.00,12.50,950.00,'2022-09-25 12:36:32','',''),(6072,'1','275','1',1,'Retail Sale Id 5872',802.24,0.00,0.00,1.09,82.84,'2022-09-25 12:42:47','',''),(6073,'1','275','1',1,'Retail Sale Id 5873',9200.00,0.00,0.00,12.50,950.00,'2022-09-25 12:52:42','',''),(6074,'1','275','1',1,'Retail Sale Id 5874',7360.00,0.00,0.00,10.00,760.00,'2022-09-25 12:53:57','',''),(6075,'1','275','1',1,'Retail Sale Id 5875',2200.64,0.00,0.00,2.99,227.24,'2022-09-25 12:59:04','',''),(6076,'1','275','1',1,'Retail Sale Id 5876',9200.00,0.00,0.00,12.50,950.00,'2022-09-25 13:00:47','',''),(6077,'1','275','1',1,'Retail Sale Id 5877',4496.96,0.00,0.00,6.11,464.36,'2022-09-25 13:07:55','',''),(6078,'1','275','1',1,'Retail Sale Id 5878',36800.00,0.00,0.00,50.00,3800.00,'2022-09-25 13:12:38','',''),(6079,'1','275','1',1,'Retail Sale Id 5879',9200.00,0.00,0.00,12.50,950.00,'2022-09-25 13:13:36','',''),(6080,'1','275','1',1,'Retail Sale Id 5880',4496.96,0.00,0.00,6.11,464.36,'2022-09-25 13:17:41','',''),(6081,'1','275','1',1,'Retail Sale Id 5881',18400.00,0.00,0.00,25.00,1900.00,'2022-09-25 13:34:26','',''),(6082,'1','275','1',1,'Retail Sale Id 5882',3002.88,0.00,0.00,4.08,310.08,'2022-09-25 13:35:46','',''),(6083,'1','275','1',1,'Retail Sale Id 5883',7360.00,0.00,0.00,10.00,760.00,'2022-09-25 13:36:26','',''),(6084,'1','275','1',1,'Retail Sale Id 5884',9200.00,0.00,0.00,12.50,950.00,'2022-09-25 13:37:35','',''),(6085,'1','275','1',1,'Retail Sale Id 5885',2208.00,0.00,0.00,3.00,228.00,'2022-09-25 13:41:32','',''),(6086,'1','275','1',1,'Retail Sale Id 5886',9200.00,0.00,0.00,12.50,950.00,'2022-09-25 13:43:07','',''),(6087,'1','275','1',1,'Retail Sale Id 5887',9200.00,0.00,0.00,12.50,950.00,'2022-09-25 13:44:32','',''),(6088,'1','275','1',1,'Retail Sale Id 5888',18400.00,0.00,0.00,25.00,1900.00,'2022-09-25 13:54:47','',''),(6089,'1','275','1',1,'Retail Sale Id 5889',10134.72,0.00,0.00,13.77,1046.52,'2022-09-25 14:17:41','',''),(6090,'1','275','1',1,'Distributed to OPPRETIONAL LOST  for sales id:20',19951.80,0.00,0.00,30.23,0.00,'2022-09-25 14:23:35','',''),(6091,'1','275',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,330000.00,500.00,0.00,0.00,'2022-09-26 12:21:12','',''),(6092,'1','275',NULL,1,'Reception corrector for bridging 24',0.00,0.00,0.00,500.00,0.00,'2022-09-26 12:22:16','',''),(6093,'1','275','1',1,'Received from bridging 24',0.00,0.00,500.00,0.00,0.00,'2022-09-26 12:22:16','',''),(6094,'1','275','1',1,'Retail Sale Id 5890',3002.88,0.00,0.00,4.08,310.08,'2022-09-26 13:18:19','',''),(6095,'1','275','1',1,'Retail Sale Id 5891',2303.68,0.00,0.00,3.13,237.88,'2022-09-26 13:20:22','',''),(6096,'1','275','1',1,'Retail Sale Id 5892',2303.68,0.00,0.00,3.13,237.88,'2022-09-26 13:21:17','',''),(6097,'1','275','1',1,'Retail Sale Id 5893',9200.00,0.00,0.00,12.50,950.00,'2022-09-26 13:22:01','',''),(6098,'1','275','1',1,'Retail Sale Id 5894',9200.00,0.00,0.00,12.50,950.00,'2022-09-26 13:23:19','',''),(6099,'1','275','1',1,'Retail Sale Id 5895',9200.00,0.00,0.00,12.50,950.00,'2022-09-26 13:29:09','',''),(6100,'1','275','1',1,'Retail Sale Id 5896',1501.44,0.00,0.00,2.04,155.04,'2022-09-26 13:30:17','',''),(6101,'1','275','1',1,'Retail Sale Id 5897',4496.96,0.00,0.00,6.11,464.36,'2022-09-26 13:35:03','',''),(6102,'1','275','1',1,'Retail Sale Id 5898',8832.00,0.00,0.00,12.00,912.00,'2022-09-26 13:38:29','',''),(6103,'1','275','1',1,'Retail Sale Id 5899',9200.00,0.00,0.00,12.50,950.00,'2022-09-26 13:51:27','',''),(6104,'1','275','1',1,'Retail Sale Id 5900',1000.96,0.00,0.00,1.36,103.36,'2022-09-26 13:54:16','',''),(6105,'1','275','1',1,'Retail Sale Id 5901',9200.00,0.00,0.00,12.50,950.00,'2022-09-26 13:59:49','',''),(6106,'1','275','1',1,'Retail Sale Id 5902',9200.00,0.00,0.00,12.50,950.00,'2022-09-26 14:18:53','',''),(6107,'1','275','1',1,'Retail Sale Id 5903',9200.00,0.00,0.00,12.50,950.00,'2022-09-26 14:20:04','',''),(6108,'1','275','1',1,'Retail Sale Id 5904',2303.68,0.00,0.00,3.13,237.88,'2022-09-26 14:21:00','',''),(6109,'1','275','1',1,'Retail Sale Id 5905',9200.00,0.00,0.00,12.50,950.00,'2022-09-26 14:34:04','',''),(6110,'1','275','1',1,'Retail Sale Id 5906',2303.68,0.00,0.00,3.13,237.88,'2022-09-26 14:34:54','',''),(6111,'1','275','1',1,'Retail Sale Id 5907',7396.80,0.00,0.00,10.05,763.80,'2022-09-26 14:35:50','',''),(6112,'1','275','1',1,'Retail Sale Id 5908',2303.68,0.00,0.00,3.13,237.88,'2022-09-26 14:36:43','',''),(6113,'1','275','1',1,'Retail Sale Id 5909',736.00,0.00,0.00,1.00,76.00,'2022-09-26 14:38:28','',''),(6114,'1','275','1',1,'Return of Retail Sale Id 5909',0.00,736.00,1.00,0.00,-76.00,'2022-09-26 14:38:38','',''),(6115,'1','275','1',1,'Retail Sale Id 5910',9200.00,0.00,0.00,12.50,950.00,'2022-09-26 14:39:05','',''),(6116,'1','275','1',1,'Retail Sale Id 5911',1199.68,0.00,0.00,1.63,123.88,'2022-09-26 14:40:23','',''),(6117,'1','275','1',1,'Retail Sale Id 5912',9200.00,0.00,0.00,12.50,950.00,'2022-09-26 15:02:13','',''),(6118,'1','275','1',1,'Retail Sale Id 5913',36800.00,0.00,0.00,50.00,3800.00,'2022-09-26 15:06:02','',''),(6119,'1','275','1',1,'Retail Sale Id 5914',2303.68,0.00,0.00,3.13,237.88,'2022-09-26 15:12:48','',''),(6120,'1','275','1',1,'Retail Sale Id 5915',40480.00,0.00,0.00,55.00,4180.00,'2022-09-26 15:33:48','',''),(6121,'1','275','1',1,'Retail Sale Id 5916',1398.40,0.00,0.00,1.90,144.40,'2022-09-26 15:34:47','',''),(6122,'1','275','1',1,'Retail Sale Id 5917',9200.00,0.00,0.00,12.50,950.00,'2022-09-26 15:38:49','',''),(6123,'1','275','1',1,'Retail Sale Id 5918',9200.00,0.00,0.00,12.50,950.00,'2022-09-26 15:46:40','',''),(6124,'1','275','1',1,'Retail Sale Id 5919',7396.80,0.00,0.00,10.05,763.80,'2022-09-26 15:53:55','',''),(6125,'1','275','1',1,'Retail Sale Id 5920',4496.96,0.00,0.00,6.11,464.36,'2022-09-26 15:59:34','',''),(6126,'1','275','1',1,'Retail Sale Id 5921',2001.92,0.00,0.00,2.72,206.72,'2022-09-26 16:08:06','',''),(6127,'1','275','1',1,'Retail Sale Id 5922',18400.00,0.00,0.00,25.00,1900.00,'2022-09-26 16:09:11','',''),(6128,'1','275','1',1,'Retail Sale Id 5923',9200.00,0.00,0.00,12.50,950.00,'2022-09-26 16:20:47','',''),(6129,'1','275','1',1,'Retail Sale Id 5924',1000.96,0.00,0.00,1.36,103.36,'2022-09-26 16:37:26','',''),(6130,'1','275','1',1,'Retail Sale Id 5925',1000.96,0.00,0.00,1.36,103.36,'2022-09-26 16:38:27','',''),(6131,'1','275','1',1,'Retail Sale Id 5926',9200.00,0.00,0.00,12.50,950.00,'2022-09-26 16:50:12','',''),(6132,'1','275','1',1,'Retail Sale Id 5928',3680.00,0.00,0.00,5.00,380.00,'2022-09-26 16:56:01','',''),(6133,'1','275','1',1,'Retail Sale Id 5929',9200.00,0.00,0.00,12.50,950.00,'2022-09-26 16:57:14','',''),(6134,'1','275','1',1,'Retail Sale Id 5930',816.96,0.00,0.00,1.11,84.36,'2022-09-26 16:59:23','',''),(6135,'1','275','1',1,'Retail Sale Id 5931',4496.96,0.00,0.00,6.11,464.36,'2022-09-26 17:00:33','',''),(6136,'1','275','1',1,'Retail Sale Id 5931',9200.00,0.00,0.00,12.50,950.00,'2022-09-26 17:00:33','',''),(6137,'1','275','1',1,'Retail Sale Id 5932',9200.00,0.00,0.00,12.50,950.00,'2022-09-26 17:02:07','',''),(6138,'1','275','1',1,'Retail Sale Id 5933',2208.00,0.00,0.00,3.00,228.00,'2022-09-26 17:09:41','',''),(6139,'1','275','1',1,'Retail Sale Id 5934',9200.00,0.00,0.00,12.50,950.00,'2022-09-26 17:11:32','',''),(6140,'1','275','1',1,'Retail Sale Id 5935',2303.68,0.00,0.00,3.13,237.88,'2022-09-26 17:13:13','',''),(6141,'1','275','1',1,'Retail Sale Id 5936',4496.96,0.00,0.00,6.11,464.36,'2022-09-26 17:16:52','',''),(6142,'1','275','1',1,'Retail Sale Id 5937',9200.00,0.00,0.00,12.50,950.00,'2022-09-26 17:18:21','',''),(6143,'1','275','1',1,'Retail Sale Id 5938',1501.44,0.00,0.00,2.04,155.04,'2022-09-26 17:19:09','',''),(6144,'1','275','1',1,'Retail Sale Id 5940',4496.96,0.00,0.00,6.11,464.36,'2022-09-26 17:24:19','',''),(6145,'1','275','1',1,'Retail Sale Id 5940',9200.00,0.00,0.00,12.50,950.00,'2022-09-26 17:24:19','',''),(6146,'1','275','1',1,'Retail Sale Id 5941',4496.96,0.00,0.00,6.11,464.36,'2022-09-26 17:25:17','',''),(6147,'1','275','1',1,'Retail Sale Id 5942',1273.28,0.00,0.00,1.73,131.48,'2022-09-26 17:26:34','',''),(6148,'1','275',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3366000.00,5100.00,0.00,0.00,'2022-09-26 17:28:05','',''),(6149,'1','275',NULL,1,'Reception corrector for bridging 25',0.00,0.00,0.00,5100.00,0.00,'2022-09-26 17:29:08','',''),(6150,'1','275','1',1,'Received from bridging 25',0.00,0.00,5100.00,0.00,0.00,'2022-09-26 17:29:08','',''),(6151,'1','275','1',1,'Retail Sale Id 5943',3002.88,0.00,0.00,4.08,310.08,'2022-09-26 17:29:43','',''),(6152,'1','275','1',1,'Retail Sale Id 5944',3503.36,0.00,0.00,4.76,361.76,'2022-09-26 17:30:45','',''),(6153,'1','275','1',1,'Retail Sale Id 5945',2001.92,0.00,0.00,2.72,206.72,'2022-09-26 17:43:53','',''),(6154,'1','275','1',1,'Retail Sale Id 5946',1700.16,0.00,0.00,2.31,175.56,'2022-09-26 17:45:28','',''),(6155,'1','275','1',1,'Retail Sale Id 5947',9001.28,0.00,0.00,12.23,929.48,'2022-09-26 17:47:53','',''),(6156,'1','275','1',1,'Retail Sale Id 5948',1000.96,0.00,0.00,1.36,103.36,'2022-09-26 17:50:04','',''),(6157,'1','275','1',1,'Retail Sale Id 5949',5152.00,0.00,0.00,7.00,532.00,'2022-09-26 17:52:24','',''),(6158,'1','275','1',1,'Retail Sale Id 5950',2303.68,0.00,0.00,3.13,237.88,'2022-09-26 17:53:18','',''),(6159,'1','275','1',1,'Retail Sale Id 5951',2303.68,0.00,0.00,3.13,237.88,'2022-09-26 17:54:48','',''),(6160,'1','275','1',1,'Retail Sale Id 5952',1000.96,0.00,0.00,1.36,103.36,'2022-09-26 17:55:31','',''),(6161,'1','275','1',1,'Retail Sale Id 5953',9200.00,0.00,0.00,12.50,950.00,'2022-09-26 17:57:00','',''),(6162,'1','275','1',1,'Retail Sale Id 5954',4496.96,0.00,0.00,6.11,464.36,'2022-09-26 17:57:55','',''),(6163,'1','275','1',1,'Retail Sale Id 5955',2502.40,0.00,0.00,3.40,258.40,'2022-09-26 17:59:10','',''),(6164,'1','275','1',1,'Retail Sale Id 5956',7728.00,0.00,0.00,10.50,798.00,'2022-09-26 18:02:14','',''),(6165,'1','275','1',1,'Retail Sale Id 5957',1000.96,0.00,0.00,1.36,103.36,'2022-09-26 18:05:24','',''),(6166,'1','275','1',1,'Retail Sale Id 5958',18400.00,0.00,0.00,25.00,1900.00,'2022-09-26 18:15:57','',''),(6167,'1','275','1',1,'Retail Sale Id 5959',9200.00,0.00,0.00,12.50,950.00,'2022-09-26 18:18:13','',''),(6168,'1','275','1',1,'Retail Sale Id 5960',9200.00,0.00,0.00,12.50,950.00,'2022-09-26 18:27:15','',''),(6169,'1','275','1',1,'Retail Sale Id 5961',9200.00,0.00,0.00,12.50,950.00,'2022-09-26 18:31:59','',''),(6170,'1','275','1',1,'Retail Sale Id 5962',19570.24,0.00,0.00,26.59,2020.84,'2022-09-26 18:56:40','',''),(6171,'1','275','1',1,'Retail Sale Id 5963',4496.96,0.00,0.00,6.11,464.36,'2022-09-27 07:24:23','',''),(6172,'1','275','1',1,'Retail Sale Id 5964',2001.92,0.00,0.00,2.72,206.72,'2022-09-27 07:36:05','',''),(6173,'1','275','1',1,'Retail Sale Id 5965',8000.32,0.00,0.00,10.87,826.12,'2022-09-27 07:42:13','',''),(6174,'1','275','1',1,'Retail Sale Id 5966',9200.00,0.00,0.00,12.50,950.00,'2022-09-27 08:02:07','',''),(6175,'1','275','1',1,'Retail Sale Id 5967',9200.00,0.00,0.00,12.50,950.00,'2022-09-27 08:06:50','',''),(6176,'1','275','1',1,'Retail Sale Id 5968',9200.00,0.00,0.00,12.50,950.00,'2022-09-27 08:08:58','',''),(6177,'1','275','1',1,'Retail Sale Id 5968',9200.00,0.00,0.00,12.50,950.00,'2022-09-27 08:08:58','',''),(6178,'1','275','1',1,'Retail Sale Id 5969',9200.00,0.00,0.00,12.50,950.00,'2022-09-27 08:16:38','',''),(6179,'1','275','1',1,'Retail Sale Id 5970',9200.00,0.00,0.00,12.50,950.00,'2022-09-27 08:18:47','',''),(6180,'1','275','1',1,'Retail Sale Id 5971',2001.92,0.00,0.00,2.72,206.72,'2022-09-27 08:22:34','',''),(6181,'1','275','1',1,'Retail Sale Id 5972',9200.00,0.00,0.00,12.50,950.00,'2022-09-27 08:25:18','',''),(6182,'1','275','1',1,'Retail Sale Id 5973',2502.40,0.00,0.00,3.40,258.40,'2022-09-27 08:26:44','',''),(6183,'1','275','1',1,'Retail Sale Id 5974',2303.68,0.00,0.00,3.13,237.88,'2022-09-27 08:27:28','',''),(6184,'1','275','1',1,'Retail Sale Id 5975',1000.96,0.00,0.00,1.36,103.36,'2022-09-27 08:29:00','',''),(6185,'1','275','1',1,'Retail Sale Id 5976',7831.04,0.00,0.00,10.64,808.64,'2022-09-27 08:34:23','',''),(6186,'1','275','1',1,'Retail Sale Id 5977',1700.16,0.00,0.00,2.31,175.56,'2022-09-27 08:38:37','',''),(6187,'1','275','1',1,'Retail Sale Id 5978',3680.00,0.00,0.00,5.00,380.00,'2022-09-27 08:54:18','',''),(6188,'1','275','1',1,'Retail Sale Id 5978',9200.00,0.00,0.00,12.50,950.00,'2022-09-27 08:54:18','',''),(6189,'1','275','1',1,'Retail Sale Id 5979',8500.80,0.00,0.00,11.55,877.80,'2022-09-27 09:02:11','',''),(6190,'1','275','1',1,'Retail Sale Id 5980',7360.00,0.00,0.00,10.00,760.00,'2022-09-27 09:16:55','',''),(6191,'1','275','1',1,'Retail Sale Id 5980',9200.00,0.00,0.00,12.50,950.00,'2022-09-27 09:16:55','',''),(6192,'1','275','1',1,'Retail Sale Id 5981',9200.00,0.00,0.00,12.50,950.00,'2022-09-27 09:29:34','',''),(6193,'1','275','1',1,'Retail Sale Id 5981',9200.00,0.00,0.00,12.50,950.00,'2022-09-27 09:29:34','',''),(6194,'1','275','1',1,'Retail Sale Id 5982',3680.00,0.00,0.00,5.00,380.00,'2022-09-27 09:38:31','',''),(6195,'1','275','1',1,'Retail Sale Id 5983',4496.96,0.00,0.00,6.11,464.36,'2022-09-27 10:38:15','',''),(6196,'1','275','1',1,'Retail Sale Id 5984',2303.68,0.00,0.00,3.13,237.88,'2022-09-27 10:51:03','',''),(6197,'1','275','1',1,'Retail Sale Id 5985',7396.80,0.00,0.00,10.05,763.80,'2022-09-27 11:12:40','',''),(6198,'1','275','1',1,'Retail Sale Id 5986',1000.96,0.00,0.00,1.36,103.36,'2022-09-27 11:16:20','',''),(6199,'1','275','1',1,'Retail Sale Id 5987',4416.00,0.00,0.00,6.00,456.00,'2022-09-27 11:17:57','',''),(6200,'1','275','1',1,'Retail Sale Id 5987',9200.00,0.00,0.00,12.50,950.00,'2022-09-27 11:17:57','',''),(6201,'1','275','1',1,'Retail Sale Id 5988',5998.40,0.00,0.00,8.15,619.40,'2022-09-27 11:27:56','',''),(6202,'1','275','1',1,'Retail Sale Id 5989',9200.00,0.00,0.00,12.50,950.00,'2022-09-27 11:41:23','',''),(6203,'1','275','1',1,'Retail Sale Id 5990',2200.64,0.00,0.00,2.99,227.24,'2022-09-27 12:00:37','',''),(6204,'1','275','1',1,'Retail Sale Id 5991',1000.96,0.00,0.00,1.36,103.36,'2022-09-27 12:01:20','',''),(6205,'1','275','1',1,'Retail Sale Id 5992',9200.00,0.00,0.00,12.50,950.00,'2022-09-27 12:04:48','',''),(6206,'1','275','1',1,'Retail Sale Id 5993',4099.52,0.00,0.00,5.57,423.32,'2022-09-27 12:06:21','',''),(6207,'1','275','1',1,'Retail Sale Id 5994',1000.96,0.00,0.00,1.36,103.36,'2022-09-27 12:25:23','',''),(6208,'1','275','1',1,'Retail Sale Id 5995',9200.00,0.00,0.00,12.50,950.00,'2022-09-27 12:41:04','',''),(6209,'1','275','1',1,'Retail Sale Id 5996',13984.00,0.00,0.00,19.00,1444.00,'2022-09-27 12:55:58','',''),(6210,'1','275','1',1,'Retail Sale Id 5997',18400.00,0.00,0.00,25.00,1900.00,'2022-09-27 13:07:53','',''),(6211,'1','275','1',1,'Retail Sale Id 5998',1346.88,0.00,0.00,1.83,139.08,'2022-09-27 13:09:13','',''),(6212,'1','275','1',1,'Retail Sale Id 5999',802.24,0.00,0.00,1.09,82.84,'2022-09-27 13:38:38','',''),(6213,'1','275','1',1,'Retail Sale Id 6000',2001.92,0.00,0.00,2.72,206.72,'2022-09-27 13:57:48','',''),(6214,'1','275','1',1,'Retail Sale Id 6001',36800.00,0.00,0.00,50.00,3800.00,'2022-09-27 14:07:14','',''),(6215,'1','275','1',1,'Retail Sale Id 6002',3002.88,0.00,0.00,4.08,310.08,'2022-09-27 14:09:05','',''),(6216,'1','275','1',1,'Retail Sale Id 6003',4496.96,0.00,0.00,6.11,464.36,'2022-09-27 14:27:43','',''),(6217,'1','275','1',1,'Retail Sale Id 6004',3002.88,0.00,0.00,4.08,310.08,'2022-09-27 14:43:22','',''),(6218,'1','275','1',1,'Retail Sale Id 6005',1000.96,0.00,0.00,1.36,103.36,'2022-09-27 14:44:26','',''),(6219,'1','275','1',1,'Retail Sale Id 6006',1501.44,0.00,0.00,2.04,155.04,'2022-09-27 14:49:08','',''),(6220,'1','275','1',1,'Retail Sale Id 6007',2502.40,0.00,0.00,3.40,258.40,'2022-09-27 14:58:13','',''),(6221,'1','275','1',1,'Retail Sale Id 6008',3002.88,0.00,0.00,4.08,310.08,'2022-09-27 15:05:55','',''),(6222,'1','275','1',1,'Retail Sale Id 6009',9200.00,0.00,0.00,12.50,950.00,'2022-09-27 15:07:04','',''),(6223,'1','275','1',1,'Retail Sale Id 6010',7956.16,0.00,0.00,10.81,821.56,'2022-09-27 15:11:17','',''),(6224,'1','275','1',1,'Retail Sale Id 6011',6999.36,0.00,0.00,9.51,722.76,'2022-09-27 15:24:14','',''),(6225,'1','275','1',1,'Retail Sale Id 6011',6999.36,0.00,0.00,9.51,722.76,'2022-09-27 15:24:14','',''),(6226,'1','275','1',1,'Retail Sale Id 6012',2200.64,0.00,0.00,2.99,227.24,'2022-09-27 15:36:35','',''),(6227,'1','275','1',1,'Retail Sale Id 6013',2502.40,0.00,0.00,3.40,258.40,'2022-09-27 15:42:54','',''),(6228,'1','275','1',1,'Retail Sale Id 6015',2303.68,0.00,0.00,3.13,237.88,'2022-09-27 15:52:29','',''),(6229,'1','275','1',1,'Retail Sale Id 6016',1501.44,0.00,0.00,2.04,155.04,'2022-09-27 15:54:06','',''),(6230,'1','275','1',1,'Retail Sale Id 6017',8199.04,0.00,0.00,11.14,846.64,'2022-09-27 16:03:26','',''),(6231,'1','275','1',1,'Retail Sale Id 6018',4496.96,0.00,0.00,6.11,464.36,'2022-09-27 16:06:03','',''),(6232,'1','275','1',1,'Retail Sale Id 6019',2303.68,0.00,0.00,3.13,237.88,'2022-09-27 16:24:18','',''),(6233,'1','275','1',1,'Retail Sale Id 6019',9200.00,0.00,0.00,12.50,950.00,'2022-09-27 16:24:18','',''),(6234,'1','275','1',1,'Retail Sale Id 6020',9200.00,0.00,0.00,12.50,950.00,'2022-09-27 16:27:24','',''),(6235,'1','275','1',1,'Retail Sale Id 6021',6999.36,0.00,0.00,9.51,722.76,'2022-09-27 16:34:21','',''),(6236,'1','275','1',1,'Retail Sale Id 6022',1000.96,0.00,0.00,1.36,103.36,'2022-09-27 16:39:08','',''),(6237,'1','275','1',1,'Retail Sale Id 6023',1000.96,0.00,0.00,1.36,103.36,'2022-09-27 16:39:45','',''),(6238,'1','275','1',1,'Retail Sale Id 6024',9200.00,0.00,0.00,12.50,950.00,'2022-09-27 16:44:16','',''),(6239,'1','275','1',1,'Retail Sale Id 6025',9200.00,0.00,0.00,12.50,950.00,'2022-09-27 16:53:49','',''),(6240,'1','275','1',1,'Retail Sale Id 6026',9200.00,0.00,0.00,12.50,950.00,'2022-09-27 17:02:22','',''),(6241,'1','275','1',1,'Retail Sale Id 6027',1501.44,0.00,0.00,2.04,155.04,'2022-09-27 17:09:38','',''),(6242,'1','275','1',1,'Retail Sale Id 6028',13616.00,0.00,0.00,18.50,1406.00,'2022-09-27 17:17:37','',''),(6243,'1','275','1',1,'Retail Sale Id 6029',2001.92,0.00,0.00,2.72,206.72,'2022-09-27 17:21:36','',''),(6244,'1','275','1',1,'Retail Sale Id 6030',2001.92,0.00,0.00,2.72,206.72,'2022-09-27 17:36:05','',''),(6245,'1','275','1',1,'Retail Sale Id 6031',3002.88,0.00,0.00,4.08,310.08,'2022-09-27 17:45:25','',''),(6246,'1','275','1',1,'Retail Sale Id 6032',1501.44,0.00,0.00,2.04,155.04,'2022-09-27 17:48:50','',''),(6247,'1','275','1',1,'Retail Sale Id 6034',2303.68,0.00,0.00,3.13,237.88,'2022-09-27 17:58:32','',''),(6248,'1','275','1',1,'Retail Sale Id 6035',500.48,0.00,0.00,0.68,51.68,'2022-09-27 18:02:31','',''),(6249,'1','275','1',1,'Retail Sale Id 6036',1000.96,0.00,0.00,1.36,103.36,'2022-09-27 18:26:51','',''),(6250,'1','275','1',1,'Retail Sale Id 6037',4496.96,0.00,0.00,6.11,464.36,'2022-09-27 18:27:26','',''),(6251,'1','275','1',1,'Retail Sale Id 6038',4496.96,0.00,0.00,6.11,464.36,'2022-09-27 18:28:25','',''),(6252,'1','275','1',1,'Retail Sale Id 6039',12291.20,0.00,0.00,16.70,1269.20,'2022-09-27 18:52:08','',''),(6253,'1','275','1',1,'Retail Sale Id 6040',1000.96,0.00,0.00,1.36,103.36,'2022-09-28 07:24:35','',''),(6254,'1','275','1',1,'Retail Sale Id 6041',9200.00,0.00,0.00,12.50,950.00,'2022-09-28 07:47:41','',''),(6255,'1','275','1',1,'Retail Sale Id 6042',9200.00,0.00,0.00,12.50,950.00,'2022-09-28 07:48:49','',''),(6256,'1','275','1',1,'Retail Sale Id 6043',2001.92,0.00,0.00,2.72,206.72,'2022-09-28 07:50:21','',''),(6257,'1','275','1',1,'Retail Sale Id 6044',9200.00,0.00,0.00,12.50,950.00,'2022-09-28 08:03:35','',''),(6258,'1','275','1',1,'Retail Sale Id 6045',1000.96,0.00,0.00,1.36,103.36,'2022-09-28 08:06:21','',''),(6259,'1','275','1',1,'Retail Sale Id 6046',1501.44,0.00,0.00,2.04,155.04,'2022-09-28 08:16:15','',''),(6260,'1','275','1',1,'Retail Sale Id 6047',9200.00,0.00,0.00,12.50,950.00,'2022-09-28 08:21:23','',''),(6261,'1','275','1',1,'Retail Sale Id 6048',1000.96,0.00,0.00,1.36,103.36,'2022-09-28 08:29:40','',''),(6262,'1','275','1',1,'Retail Sale Id 6049',2303.68,0.00,0.00,3.13,237.88,'2022-09-28 08:30:54','',''),(6263,'1','275','1',1,'Retail Sale Id 6050',51520.00,0.00,0.00,70.00,5320.00,'2022-09-28 08:35:55','',''),(6264,'1','275','1',1,'Retail Sale Id 6051',9200.00,0.00,0.00,12.50,950.00,'2022-09-28 08:45:25','',''),(6265,'1','275','1',1,'Retail Sale Id 6052',8802.56,0.00,0.00,11.96,908.96,'2022-09-28 08:54:26','',''),(6266,'1','275','1',1,'Retail Sale Id 6053',9200.00,0.00,0.00,12.50,950.00,'2022-09-28 08:55:43','',''),(6267,'1','275','1',1,'Retail Sale Id 6054',3996.48,0.00,0.00,5.43,412.68,'2022-09-28 08:57:54','',''),(6268,'1','275','1',1,'Retail Sale Id 6055',11040.00,0.00,0.00,15.00,1140.00,'2022-09-28 08:59:47','',''),(6269,'1','275','1',1,'Retail Sale Id 6056',2303.68,0.00,0.00,3.13,237.88,'2022-09-28 09:05:36','',''),(6270,'1','275','1',1,'Retail Sale Id 6057',2001.92,0.00,0.00,2.72,206.72,'2022-09-28 09:41:57','',''),(6271,'1','275','1',1,'Retail Sale Id 6058',9200.00,0.00,0.00,12.50,950.00,'2022-09-28 09:42:59','',''),(6272,'1','275','1',1,'Retail Sale Id 6059',7728.00,0.00,0.00,10.50,798.00,'2022-09-28 09:43:39','',''),(6273,'1','275','1',1,'Retail Sale Id 6060',1501.44,0.00,0.00,2.04,155.04,'2022-09-28 09:44:32','',''),(6274,'1','275','1',1,'Retail Sale Id 6061',7396.80,0.00,0.00,10.05,763.80,'2022-09-28 09:48:54','',''),(6275,'1','275','1',1,'Retail Sale Id 6062',9200.00,0.00,0.00,12.50,950.00,'2022-09-28 09:50:58','',''),(6276,'1','275','1',1,'Retail Sale Id 6064',1501.44,0.00,0.00,2.04,155.04,'2022-09-28 09:56:33','',''),(6277,'1','275','1',1,'Retail Sale Id 6065',25001.92,0.00,0.00,33.97,2581.72,'2022-09-28 10:04:34','',''),(6278,'1','275','1',1,'Retail Sale Id 6065',25001.92,0.00,0.00,33.97,2581.72,'2022-09-28 10:04:34','',''),(6279,'1','275','1',1,'Return of Retail Sale Id 6065',0.00,25001.92,33.97,0.00,-2581.72,'2022-09-28 10:04:54','',''),(6280,'1','275','1',1,'Return of Retail Sale Id 6065',0.00,25001.92,33.97,0.00,-2581.72,'2022-09-28 10:04:54','',''),(6281,'1','275','1',1,'Retail Sale Id 6066',25001.92,0.00,0.00,33.97,2581.72,'2022-09-28 10:05:41','',''),(6282,'1','275','1',1,'Retail Sale Id 6066',25001.92,0.00,0.00,33.97,2581.72,'2022-09-28 10:05:41','',''),(6283,'1','275','1',1,'Retail Sale Id 6067',9200.00,0.00,0.00,12.50,950.00,'2022-09-28 10:06:38','',''),(6284,'1','275','1',1,'Retail Sale Id 6069',2001.92,0.00,0.00,2.72,206.72,'2022-09-28 10:18:55','',''),(6285,'1','275','1',1,'Retail Sale Id 6070',36800.00,0.00,0.00,50.00,3800.00,'2022-09-28 10:37:35','',''),(6286,'1','275','1',1,'Retail Sale Id 6071',4997.44,0.00,0.00,6.79,516.04,'2022-09-28 10:39:08','',''),(6287,'1','275','1',1,'Retail Sale Id 6072',4496.96,0.00,0.00,6.11,464.36,'2022-09-28 10:40:24','',''),(6288,'1','275','1',1,'Retail Sale Id 6073',2303.68,0.00,0.00,3.13,237.88,'2022-09-28 10:41:07','',''),(6289,'1','275','1',1,'Retail Sale Id 6074',1501.44,0.00,0.00,2.04,155.04,'2022-09-28 10:49:13','',''),(6290,'1','275','1',1,'Retail Sale Id 6075',4496.96,0.00,0.00,6.11,464.36,'2022-09-28 10:51:30','',''),(6291,'1','275','1',1,'Retail Sale Id 6076',2303.68,0.00,0.00,3.13,237.88,'2022-09-28 10:52:17','',''),(6292,'1','275','1',1,'Retail Sale Id 6077',4416.00,0.00,0.00,6.00,456.00,'2022-09-28 10:58:21','',''),(6293,'1','275','1',1,'Retail Sale Id 6078',1398.40,0.00,0.00,1.90,144.40,'2022-09-28 11:01:19','',''),(6294,'1','275','1',1,'Retail Sale Id 6079',1000.96,0.00,0.00,1.36,103.36,'2022-09-28 11:06:13','',''),(6295,'1','275','1',1,'Retail Sale Id 6080',3002.88,0.00,0.00,4.08,310.08,'2022-09-28 11:38:23','',''),(6296,'1','275','1',1,'Retail Sale Id 6081',4496.96,0.00,0.00,6.11,464.36,'2022-09-28 11:46:47','',''),(6297,'1','275','1',1,'Retail Sale Id 6081',9200.00,0.00,0.00,12.50,950.00,'2022-09-28 11:46:47','',''),(6298,'1','275','1',1,'Retail Sale Id 6082',35997.76,0.00,0.00,48.91,3717.16,'2022-09-28 12:07:30','',''),(6299,'1','275','1',1,'Retail Sale Id 6083',3680.00,0.00,0.00,5.00,380.00,'2022-09-28 12:09:41','',''),(6300,'1','275','1',1,'Retail Sale Id 6083',3680.00,0.00,0.00,5.00,380.00,'2022-09-28 12:09:41','',''),(6301,'1','275','1',1,'Retail Sale Id 6084',3702.08,0.00,0.00,5.03,382.28,'2022-09-28 12:15:27','',''),(6302,'1','275','1',1,'Retail Sale Id 6085',9200.00,0.00,0.00,12.50,950.00,'2022-09-28 12:51:14','',''),(6303,'1','275','1',1,'Retail Sale Id 6086',9200.00,0.00,0.00,12.50,950.00,'2022-09-28 13:20:44','',''),(6304,'1','275','1',1,'Retail Sale Id 6087',3002.88,0.00,0.00,4.08,310.08,'2022-09-28 13:22:38','',''),(6305,'1','275','1',1,'Retail Sale Id 6088',1501.44,0.00,0.00,2.04,155.04,'2022-09-28 13:24:38','',''),(6306,'1','275','1',1,'Retail Sale Id 6089',18400.00,0.00,0.00,25.00,1900.00,'2022-09-28 13:38:39','',''),(6307,'1','275','1',1,'Retail Sale Id 6090',3002.88,0.00,0.00,4.08,310.08,'2022-09-28 13:53:26','',''),(6308,'1','275','1',1,'Retail Sale Id 6091',9200.00,0.00,0.00,12.50,950.00,'2022-09-28 13:56:48','',''),(6309,'1','275','1',1,'Retail Sale Id 6092',2399.36,0.00,0.00,3.26,247.76,'2022-09-28 13:59:49','',''),(6310,'1','275','1',1,'Retail Sale Id 6093',5888.00,0.00,0.00,8.00,608.00,'2022-09-28 14:10:55','',''),(6311,'1','275','1',1,'Retail Sale Id 6094',1501.44,0.00,0.00,2.04,155.04,'2022-09-28 14:18:07','',''),(6312,'1','275','1',1,'Retail Sale Id 6095',9200.00,0.00,0.00,12.50,950.00,'2022-09-28 14:29:44','',''),(6313,'1','275','1',1,'Retail Sale Id 6096',9200.00,0.00,0.00,12.50,950.00,'2022-09-28 14:34:59','',''),(6314,'1','275','1',1,'Retail Sale Id 6097',9200.00,0.00,0.00,12.50,950.00,'2022-09-28 14:44:22','',''),(6315,'1','275','1',1,'Retail Sale Id 6098',9200.00,0.00,0.00,12.50,950.00,'2022-09-28 15:15:55','',''),(6316,'1','275','1',1,'Retail Sale Id 6099',3702.08,0.00,0.00,5.03,382.28,'2022-09-28 15:20:05','',''),(6317,'1','275','1',1,'Retail Sale Id 6100',18400.00,0.00,0.00,25.00,1900.00,'2022-09-28 15:21:15','',''),(6318,'1','275','1',1,'Retail Sale Id 6101',4496.96,0.00,0.00,6.11,464.36,'2022-09-28 15:25:17','',''),(6319,'1','275','1',1,'Retail Sale Id 6102',9001.28,0.00,0.00,12.23,929.48,'2022-09-28 15:36:04','',''),(6320,'1','275','1',1,'Retail Sale Id 6103',9200.00,0.00,0.00,12.50,950.00,'2022-09-28 16:05:07','',''),(6321,'1','275','1',1,'Retail Sale Id 6104',9200.00,0.00,0.00,12.50,950.00,'2022-09-28 16:09:56','',''),(6322,'1','275','1',1,'Retail Sale Id 6105',4496.96,0.00,0.00,6.11,464.36,'2022-09-28 16:29:12','',''),(6323,'1','275','1',1,'Retail Sale Id 6106',2303.68,0.00,0.00,3.13,237.88,'2022-09-28 16:30:28','',''),(6324,'1','275','1',1,'Retail Sale Id 6107',802.24,0.00,0.00,1.09,82.84,'2022-09-28 16:46:20','',''),(6325,'1','275','1',1,'Retail Sale Id 6108',4496.96,0.00,0.00,6.11,464.36,'2022-09-28 17:07:23','',''),(6326,'1','275','1',1,'Retail Sale Id 6109',4416.00,0.00,0.00,6.00,456.00,'2022-09-28 17:26:33','',''),(6327,'1','275','1',1,'Retail Sale Id 6110',3002.88,0.00,0.00,4.08,310.08,'2022-09-28 17:35:56','',''),(6328,'1','275','1',1,'Retail Sale Id 6111',7360.00,0.00,0.00,10.00,760.00,'2022-09-28 17:40:11','',''),(6329,'1','275','1',1,'Retail Sale Id 6112',3702.08,0.00,0.00,5.03,382.28,'2022-09-28 17:45:08','',''),(6330,'1','275','1',1,'Retail Sale Id 6113',9200.00,0.00,0.00,12.50,950.00,'2022-09-28 17:49:04','',''),(6331,'1','275','1',1,'Retail Sale Id 6114',2208.00,0.00,0.00,3.00,228.00,'2022-09-28 17:51:19','',''),(6332,'1','275','1',1,'Retail Sale Id 6114',4416.00,0.00,0.00,6.00,456.00,'2022-09-28 17:51:19','',''),(6333,'1','275','1',1,'Retail Sale Id 6114',27600.00,0.00,0.00,37.50,2850.00,'2022-09-28 17:51:19','',''),(6334,'1','275','1',1,'Retail Sale Id 6115',1501.44,0.00,0.00,2.04,155.04,'2022-09-28 18:11:59','',''),(6335,'1','275','1',1,'Retail Sale Id 6116',8500.80,0.00,0.00,11.55,877.80,'2022-09-28 18:23:54','',''),(6336,'1','275','1',1,'Retail Sale Id 6117',9200.00,0.00,0.00,12.50,950.00,'2022-09-28 18:35:39','',''),(6337,'1','275','1',1,'Retail Sale Id 6118',1000.96,0.00,0.00,1.36,103.36,'2022-09-28 18:38:25','',''),(6338,'1','275','1',1,'Retail Sale Id 6119',2944.00,0.00,0.00,4.00,304.00,'2022-09-28 18:39:59','',''),(6339,'1','275','1',1,'Retail Sale Id 6119',9200.00,0.00,0.00,12.50,950.00,'2022-09-28 18:39:59','',''),(6340,'1','275','1',1,'Retail Sale Id 6120',3996.48,0.00,0.00,5.43,412.68,'2022-09-28 18:40:47','',''),(6341,'1','275','1',1,'Retail Sale Id 6121',2303.68,0.00,0.00,3.13,237.88,'2022-09-28 18:41:46','',''),(6342,'1','275','1',1,'Retail Sale Id 6122',2303.68,0.00,0.00,3.13,237.88,'2022-09-28 18:43:33','',''),(6343,'1','275','1',1,'Retail Sale Id 6123',2303.68,0.00,0.00,3.13,237.88,'2022-09-28 18:45:16','',''),(6344,'1','275','1',1,'Retail Sale Id 6124',3702.08,0.00,0.00,5.03,382.28,'2022-09-28 18:46:09','',''),(6345,'1','275','1',1,'Retail Sale Id 6125',2208.00,0.00,0.00,3.00,228.00,'2022-09-28 18:47:15','',''),(6346,'1','275','1',1,'Retail Sale Id 6126',1501.44,0.00,0.00,2.04,155.04,'2022-09-28 18:53:02','',''),(6347,'1','275','1',1,'Retail Sale Id 6127',4496.96,0.00,0.00,6.11,464.36,'2022-09-28 18:54:39','',''),(6348,'1','275','1',1,'Retail Sale Id 6128',11040.00,0.00,0.00,15.00,1140.00,'2022-09-28 18:57:04','',''),(6349,'1','275','1',1,'Retail Sale Id 6129',8000.32,0.00,0.00,10.87,826.12,'2022-09-28 19:05:15','',''),(6350,'1','275','1',1,'Retail Sale Id 6130',6999.36,0.00,0.00,9.51,722.76,'2022-09-28 19:06:24','',''),(6351,'1','275','1',1,'Retail Sale Id 6131',21196.80,0.00,0.00,28.80,2188.80,'2022-09-28 19:20:07','',''),(6352,'1','275','1',1,'Retail Sale Id 6132',4496.96,0.00,0.00,6.11,464.36,'2022-09-29 06:41:22','',''),(6353,'1','275','1',1,'Retail Sale Id 6133',9200.00,0.00,0.00,12.50,950.00,'2022-09-29 06:49:59','',''),(6354,'1','275','1',1,'Retail Sale Id 6134',2208.00,0.00,0.00,3.00,228.00,'2022-09-29 07:23:26','',''),(6355,'1','275','1',1,'Retail Sale Id 6135',1501.44,0.00,0.00,2.04,155.04,'2022-09-29 07:34:03','',''),(6356,'1','275','1',1,'Retail Sale Id 6136',3702.08,0.00,0.00,5.03,382.28,'2022-09-29 07:35:44','',''),(6357,'1','275','1',1,'Retail Sale Id 6137',9200.00,0.00,0.00,12.50,950.00,'2022-09-29 07:39:26','',''),(6358,'1','275','1',1,'Retail Sale Id 6138',4496.96,0.00,0.00,6.11,464.36,'2022-09-29 07:42:06','',''),(6359,'1','275','1',1,'Retail Sale Id 6139',9200.00,0.00,0.00,12.50,950.00,'2022-09-29 07:43:22','',''),(6360,'1','275','1',1,'Retail Sale Id 6140',1000.96,0.00,0.00,1.36,103.36,'2022-09-29 07:51:21','',''),(6361,'1','275','1',1,'Retail Sale Id 6141',7396.80,0.00,0.00,10.05,763.80,'2022-09-29 07:58:49','',''),(6362,'1','275','1',1,'Retail Sale Id 6142',2252.16,0.00,0.00,3.06,232.56,'2022-09-29 08:04:39','',''),(6363,'1','275','1',1,'Retail Sale Id 6143',4496.96,0.00,0.00,6.11,464.36,'2022-09-29 08:15:04','',''),(6364,'1','275','1',1,'Retail Sale Id 6144',5998.40,0.00,0.00,8.15,619.40,'2022-09-29 08:26:18','',''),(6365,'1','275','1',1,'Retail Sale Id 6145',6999.36,0.00,0.00,9.51,722.76,'2022-09-29 08:27:45','',''),(6366,'1','275','1',1,'Retail Sale Id 6146',9200.00,0.00,0.00,12.50,950.00,'2022-09-29 09:16:54','',''),(6367,'1','275','1',1,'Retail Sale Id 6147',9200.00,0.00,0.00,12.50,950.00,'2022-09-29 09:32:20','',''),(6368,'1','275','1',1,'Retail Sale Id 6148',9200.00,0.00,0.00,12.50,950.00,'2022-09-29 09:39:19','',''),(6369,'1','275','1',1,'Retail Sale Id 6149',9200.00,0.00,0.00,12.50,950.00,'2022-09-29 09:40:08','',''),(6370,'1','275','1',1,'Retail Sale Id 6150',4416.00,0.00,0.00,6.00,456.00,'2022-09-29 09:43:46','',''),(6371,'1','275','1',1,'Retail Sale Id 6151',1501.44,0.00,0.00,2.04,155.04,'2022-09-29 09:45:43','',''),(6372,'1','275','1',1,'Retail Sale Id 6151',18400.00,0.00,0.00,25.00,1900.00,'2022-09-29 09:45:43','',''),(6373,'1','275','1',1,'Retail Sale Id 6152',9200.00,0.00,0.00,12.50,950.00,'2022-09-29 09:47:23','',''),(6374,'1','275','1',1,'Retail Sale Id 6152',9200.00,0.00,0.00,12.50,950.00,'2022-09-29 09:47:23','',''),(6375,'1','275','1',1,'Retail Sale Id 6153',40480.00,0.00,0.00,55.00,4180.00,'2022-09-29 10:02:03','',''),(6376,'1','275','1',1,'Retail Sale Id 6154',9200.00,0.00,0.00,12.50,950.00,'2022-09-29 10:05:04','',''),(6377,'1','275','1',1,'Retail Sale Id 6155',3702.08,0.00,0.00,5.03,382.28,'2022-09-29 10:16:53','',''),(6378,'1','275','1',1,'Retail Sale Id 6156',1501.44,0.00,0.00,2.04,155.04,'2022-09-29 10:21:44','',''),(6379,'1','275','1',1,'Retail Sale Id 6157',2303.68,0.00,0.00,3.13,237.88,'2022-09-29 10:33:21','',''),(6380,'1','275','1',1,'Retail Sale Id 6158',7360.00,0.00,0.00,10.00,760.00,'2022-09-29 10:34:28','',''),(6381,'1','275','1',1,'Retail Sale Id 6159',4496.96,0.00,0.00,6.11,464.36,'2022-09-29 10:37:17','',''),(6382,'1','275','1',1,'Retail Sale Id 6160',1000.96,0.00,0.00,1.36,103.36,'2022-09-29 10:40:21','',''),(6383,'1','275','1',1,'Retail Sale Id 6160',1501.44,0.00,0.00,2.04,155.04,'2022-09-29 10:40:21','',''),(6384,'1','275','1',1,'Retail Sale Id 6161',3702.08,0.00,0.00,5.03,382.28,'2022-09-29 10:49:46','',''),(6385,'1','275','1',1,'Retail Sale Id 6162',4496.96,0.00,0.00,6.11,464.36,'2022-09-29 11:25:09','',''),(6386,'1','275','1',1,'Retail Sale Id 6163',3996.48,0.00,0.00,5.43,412.68,'2022-09-29 11:30:40','',''),(6387,'1','275','1',1,'Retail Sale Id 6164',2001.92,0.00,0.00,2.72,206.72,'2022-09-29 11:44:13','',''),(6388,'1','275','1',1,'Retail Sale Id 6165',4496.96,0.00,0.00,6.11,464.36,'2022-09-29 11:46:38','',''),(6389,'1','275','1',1,'Retail Sale Id 6166',36800.00,0.00,0.00,50.00,3800.00,'2022-09-29 11:58:27','',''),(6390,'1','275','1',1,'Retail Sale Id 6167',9200.00,0.00,0.00,12.50,950.00,'2022-09-29 12:03:07','',''),(6391,'1','275','1',1,'Retail Sale Id 6168',9200.00,0.00,0.00,12.50,950.00,'2022-09-29 12:04:04','',''),(6392,'1','275','1',1,'Retail Sale Id 6169',2303.68,0.00,0.00,3.13,237.88,'2022-09-29 12:18:40','',''),(6393,'1','275','1',1,'Retail Sale Id 6170',9200.00,0.00,0.00,12.50,950.00,'2022-09-29 12:19:38','',''),(6394,'1','275','1',1,'Retail Sale Id 6171',9200.00,0.00,0.00,12.50,950.00,'2022-09-29 12:31:00','',''),(6395,'1','275','1',1,'Retail Sale Id 6172',7698.56,0.00,0.00,10.46,794.96,'2022-09-29 12:48:06','',''),(6396,'1','275','1',1,'Retail Sale Id 6173',1000.96,0.00,0.00,1.36,103.36,'2022-09-29 12:52:11','',''),(6397,'1','275','1',1,'Retail Sale Id 6174',5998.40,0.00,0.00,8.15,619.40,'2022-09-29 12:54:18','',''),(6398,'1','275','1',1,'Retail Sale Id 6175',4496.96,0.00,0.00,6.11,464.36,'2022-09-29 13:14:03','',''),(6399,'1','275','1',1,'Retail Sale Id 6176',9001.28,0.00,0.00,12.23,929.48,'2022-09-29 13:15:06','',''),(6400,'1','275','1',1,'Retail Sale Id 6177',9200.00,0.00,0.00,12.50,950.00,'2022-09-29 13:18:54','',''),(6401,'1','275','1',1,'Retail Sale Id 6178',5998.40,0.00,0.00,8.15,619.40,'2022-09-29 13:56:05','',''),(6402,'1','275','1',1,'Retail Sale Id 6179',1000.96,0.00,0.00,1.36,103.36,'2022-09-29 14:04:24','',''),(6403,'1','275','1',1,'Retail Sale Id 6180',802.24,0.00,0.00,1.09,82.84,'2022-09-29 14:05:21','',''),(6404,'1','275','1',1,'Retail Sale Id 6181',9200.00,0.00,0.00,12.50,950.00,'2022-09-29 14:06:31','',''),(6405,'1','275','1',1,'Retail Sale Id 6182',8199.04,0.00,0.00,11.14,846.64,'2022-09-29 14:10:32','',''),(6406,'1','275','1',1,'Retail Sale Id 6183',1000.96,0.00,0.00,1.36,103.36,'2022-09-29 14:27:44','',''),(6407,'1','275','1',1,'Retail Sale Id 6184',2303.68,0.00,0.00,3.13,237.88,'2022-09-29 14:31:50','',''),(6408,'1','275','1',1,'Retail Sale Id 6184',4496.96,0.00,0.00,6.11,464.36,'2022-09-29 14:31:50','',''),(6409,'1','275','1',1,'Retail Sale Id 6185',2303.68,0.00,0.00,3.13,237.88,'2022-09-29 14:37:27','',''),(6410,'1','275','1',1,'Retail Sale Id 6186',1000.96,0.00,0.00,1.36,103.36,'2022-09-29 14:44:34','',''),(6411,'1','275','1',1,'Retail Sale Id 6187',8199.04,0.00,0.00,11.14,846.64,'2022-09-29 14:47:51','',''),(6412,'1','275','1',1,'Retail Sale Id 6188',4997.44,0.00,0.00,6.79,516.04,'2022-09-29 14:51:30','',''),(6413,'1','275','1',1,'Retail Sale Id 6189',1199.68,0.00,0.00,1.63,123.88,'2022-09-29 14:52:27','',''),(6414,'1','275','1',1,'Retail Sale Id 6190',2001.92,0.00,0.00,2.72,206.72,'2022-09-29 15:36:22','',''),(6415,'1','275','1',1,'Retail Sale Id 6191',9200.00,0.00,0.00,12.50,950.00,'2022-09-29 15:48:55','',''),(6416,'1','275','1',1,'Retail Sale Id 6192',3702.08,0.00,0.00,5.03,382.28,'2022-09-29 16:09:54','',''),(6417,'1','275','1',1,'Retail Sale Id 6193',36800.00,0.00,0.00,50.00,3800.00,'2022-09-29 16:35:14','',''),(6418,'1','275','1',1,'Retail Sale Id 6194',2303.68,0.00,0.00,3.13,237.88,'2022-09-29 16:54:39','',''),(6419,'1','275','1',1,'Retail Sale Id 6195',4496.96,0.00,0.00,6.11,464.36,'2022-09-29 17:08:05','',''),(6420,'1','275','1',1,'Retail Sale Id 6195',9200.00,0.00,0.00,12.50,950.00,'2022-09-29 17:08:05','',''),(6421,'1','275','1',1,'Retail Sale Id 6196',4997.44,0.00,0.00,6.79,516.04,'2022-09-29 17:09:36','',''),(6422,'1','275','1',1,'Retail Sale Id 6197',4496.96,0.00,0.00,6.11,464.36,'2022-09-29 17:10:37','',''),(6423,'1','275','1',1,'Retail Sale Id 6198',2303.68,0.00,0.00,3.13,237.88,'2022-09-29 17:19:44','',''),(6424,'1','275','1',1,'Retail Sale Id 6199',9200.00,0.00,0.00,12.50,950.00,'2022-09-29 17:24:20','',''),(6425,'1','275','1',1,'Retail Sale Id 6200',1501.44,0.00,0.00,2.04,155.04,'2022-09-29 17:25:18','',''),(6426,'1','275','1',1,'Retail Sale Id 6201',18400.00,0.00,0.00,25.00,1900.00,'2022-09-29 17:29:50','',''),(6427,'1','275','1',1,'Retail Sale Id 6202',9200.00,0.00,0.00,12.50,950.00,'2022-09-29 17:36:06','',''),(6428,'1','275','1',1,'Retail Sale Id 6203',4496.96,0.00,0.00,6.11,464.36,'2022-09-29 17:40:41','',''),(6429,'1','275','1',1,'Retail Sale Id 6204',9200.00,0.00,0.00,12.50,950.00,'2022-09-29 17:46:39','',''),(6430,'1','275','1',1,'Retail Sale Id 6205',1501.44,0.00,0.00,2.04,155.04,'2022-09-29 17:52:06','',''),(6431,'1','275','1',1,'Retail Sale Id 6206',1501.44,0.00,0.00,2.04,155.04,'2022-09-29 17:53:55','',''),(6432,'1','275','1',1,'Retail Sale Id 6207',9200.00,0.00,0.00,12.50,950.00,'2022-09-29 18:03:42','',''),(6433,'1','275','1',1,'Retail Sale Id 6208',9200.00,0.00,0.00,12.50,950.00,'2022-09-29 18:05:49','',''),(6434,'1','275','1',1,'Retail Sale Id 6209',9200.00,0.00,0.00,12.50,950.00,'2022-09-29 18:07:46','',''),(6435,'1','275','1',1,'Retail Sale Id 6210',8500.80,0.00,0.00,11.55,877.80,'2022-09-29 18:14:08','',''),(6436,'1','275','1',1,'Retail Sale Id 6211',9200.00,0.00,0.00,12.50,950.00,'2022-09-29 18:15:18','',''),(6437,'1','275','1',1,'Retail Sale Id 6212',2001.92,0.00,0.00,2.72,206.72,'2022-09-29 18:16:09','',''),(6438,'1','275','1',1,'Retail Sale Id 6213',1501.44,0.00,0.00,2.04,155.04,'2022-09-29 18:21:26','',''),(6439,'1','275','1',1,'Retail Sale Id 6213',2502.40,0.00,0.00,3.40,258.40,'2022-09-29 18:21:26','',''),(6440,'1','275','1',1,'Retail Sale Id 6214',1000.96,0.00,0.00,1.36,103.36,'2022-09-29 18:22:21','',''),(6441,'1','275','1',1,'Retail Sale Id 6215',9200.00,0.00,0.00,12.50,950.00,'2022-09-29 18:23:49','',''),(6442,'1','275','1',1,'Retail Sale Id 6216',2001.92,0.00,0.00,2.72,206.72,'2022-09-29 18:24:40','',''),(6443,'1','275','1',1,'Retail Sale Id 6217',9200.00,0.00,0.00,12.50,950.00,'2022-09-29 18:28:25','',''),(6444,'1','275','1',1,'Retail Sale Id 6218',9200.00,0.00,0.00,12.50,950.00,'2022-09-29 18:44:08','',''),(6445,'1','275','1',1,'Retail Sale Id 6219',7036.16,0.00,0.00,9.56,726.56,'2022-09-29 19:11:53','',''),(6446,'1','275','1',1,'Retail Sale Id 6226',2303.68,0.00,0.00,3.13,237.88,'2022-09-30 06:58:37','',''),(6447,'1','275','1',1,'Retail Sale Id 6227',4496.96,0.00,0.00,6.11,464.36,'2022-09-30 07:01:48','',''),(6448,'1','275','1',1,'Retail Sale Id 6228',9200.00,0.00,0.00,12.50,950.00,'2022-09-30 07:13:34','',''),(6449,'1','275','1',1,'Retail Sale Id 6229',4496.96,0.00,0.00,6.11,464.36,'2022-09-30 07:26:01','',''),(6450,'1','275','1',1,'Retail Sale Id 6230',1000.96,0.00,0.00,1.36,103.36,'2022-09-30 07:30:12','',''),(6451,'1','275','1',1,'Retail Sale Id 6231',9200.00,0.00,0.00,12.50,950.00,'2022-09-30 07:31:13','',''),(6452,'1','275','1',1,'Retail Sale Id 6232',9200.00,0.00,0.00,12.50,950.00,'2022-09-30 07:36:26','',''),(6453,'1','275','1',1,'Retail Sale Id 6233',4496.96,0.00,0.00,6.11,464.36,'2022-09-30 07:40:22','',''),(6454,'1','275','1',1,'Retail Sale Id 6234',9200.00,0.00,0.00,12.50,950.00,'2022-09-30 07:48:10','',''),(6455,'1','275','1',1,'Retail Sale Id 6235',4496.96,0.00,0.00,6.11,464.36,'2022-09-30 07:53:24','',''),(6456,'1','275','1',1,'Retail Sale Id 6236',1501.44,0.00,0.00,2.04,155.04,'2022-09-30 07:57:27','',''),(6457,'1','275','1',1,'Retail Sale Id 6237',2001.92,0.00,0.00,2.72,206.72,'2022-09-30 08:08:49','',''),(6458,'1','275','1',1,'Retail Sale Id 6238',9200.00,0.00,0.00,12.50,950.00,'2022-09-30 08:24:00','',''),(6459,'1','275','1',1,'Retail Sale Id 6239',2001.92,0.00,0.00,2.72,206.72,'2022-09-30 08:26:42','',''),(6460,'1','275','1',1,'Retail Sale Id 6240',7360.00,0.00,0.00,10.00,760.00,'2022-09-30 08:29:12','',''),(6461,'1','275','1',1,'Retail Sale Id 6240',9200.00,0.00,0.00,12.50,950.00,'2022-09-30 08:29:12','',''),(6462,'1','275','1',1,'Retail Sale Id 6240',9200.00,0.00,0.00,12.50,950.00,'2022-09-30 08:29:12','',''),(6463,'1','275','1',1,'Retail Sale Id 6241',3680.00,0.00,0.00,5.00,380.00,'2022-09-30 08:38:03','',''),(6464,'1','275','1',1,'Retail Sale Id 6241',9200.00,0.00,0.00,12.50,950.00,'2022-09-30 08:38:03','',''),(6465,'1','275','1',1,'Retail Sale Id 6242',2303.68,0.00,0.00,3.13,237.88,'2022-09-30 08:40:24','',''),(6466,'1','275','1',1,'Retail Sale Id 6243',4496.96,0.00,0.00,6.11,464.36,'2022-09-30 08:45:32','',''),(6467,'1','275','1',1,'Retail Sale Id 6244',4997.44,0.00,0.00,6.79,516.04,'2022-09-30 09:02:38','',''),(6468,'1','275','1',1,'Retail Sale Id 6245',1000.96,0.00,0.00,1.36,103.36,'2022-09-30 09:04:32','',''),(6469,'1','275','1',1,'Retail Sale Id 6246',1501.44,0.00,0.00,2.04,155.04,'2022-09-30 09:07:06','',''),(6470,'1','275','1',1,'Retail Sale Id 6247',9200.00,0.00,0.00,12.50,950.00,'2022-09-30 09:11:53','',''),(6471,'1','275','1',1,'Retail Sale Id 6248',5998.40,0.00,0.00,8.15,619.40,'2022-09-30 09:12:57','',''),(6472,'1','275','1',1,'Retail Sale Id 6249',1000.96,0.00,0.00,1.36,103.36,'2022-09-30 09:14:46','',''),(6473,'1','275','1',1,'Retail Sale Id 6250',1501.44,0.00,0.00,2.04,155.04,'2022-09-30 09:20:46','',''),(6474,'1','275','1',1,'Retail Sale Id 6251',1000.96,0.00,0.00,1.36,103.36,'2022-09-30 09:28:11','',''),(6475,'1','275','1',1,'Retail Sale Id 6252',9200.00,0.00,0.00,12.50,950.00,'2022-09-30 09:29:32','',''),(6476,'1','275','1',1,'Retail Sale Id 6253',9200.00,0.00,0.00,12.50,950.00,'2022-09-30 10:02:00','',''),(6477,'1','275','1',1,'Retail Sale Id 6254',4416.00,0.00,0.00,6.00,456.00,'2022-09-30 10:12:41','',''),(6478,'1','275','1',1,'Retail Sale Id 6255',9200.00,0.00,0.00,12.50,950.00,'2022-09-30 10:18:29','',''),(6479,'1','275','1',1,'Retail Sale Id 6256',4416.00,0.00,0.00,6.00,456.00,'2022-09-30 10:27:21','',''),(6480,'1','275','1',1,'Retail Sale Id 6257',11040.00,0.00,0.00,15.00,1140.00,'2022-09-30 10:40:39','',''),(6481,'1','275','1',1,'Retail Sale Id 6257',14720.00,0.00,0.00,20.00,1520.00,'2022-09-30 10:40:39','',''),(6482,'1','275','1',1,'Retail Sale Id 6258',9200.00,0.00,0.00,12.50,950.00,'2022-09-30 10:45:20','',''),(6483,'1','275','1',1,'Retail Sale Id 6259',9200.00,0.00,0.00,12.50,950.00,'2022-09-30 10:50:01','',''),(6484,'1','275','1',1,'Retail Sale Id 6260',8464.00,0.00,0.00,11.50,874.00,'2022-09-30 11:58:11','',''),(6485,'1','275','1',1,'Retail Sale Id 6260',8464.00,0.00,0.00,11.50,874.00,'2022-09-30 11:58:11','',''),(6486,'1','275','1',1,'Retail Sale Id 6261',4496.96,0.00,0.00,6.11,464.36,'2022-09-30 12:00:11','',''),(6487,'1','275','1',1,'Retail Sale Id 6262',9200.00,0.00,0.00,12.50,950.00,'2022-09-30 12:04:40','',''),(6488,'1','275','1',1,'Retail Sale Id 6263',9200.00,0.00,0.00,12.50,950.00,'2022-09-30 12:14:54','',''),(6489,'1','275','1',1,'Retail Sale Id 6264',1501.44,0.00,0.00,2.04,155.04,'2022-09-30 12:15:39','',''),(6490,'1','275','1',1,'Retail Sale Id 6266',802.24,0.00,0.00,1.09,82.84,'2022-09-30 12:56:02','',''),(6491,'1','275','1',1,'Retail Sale Id 6267',36800.00,0.00,0.00,50.00,3800.00,'2022-09-30 13:00:40','',''),(6492,'1','275','1',1,'Retail Sale Id 6268',3002.88,0.00,0.00,4.08,310.08,'2022-09-30 13:24:27','',''),(6493,'1','275','1',1,'Retail Sale Id 6269',3002.88,0.00,0.00,4.08,310.08,'2022-09-30 13:39:34','',''),(6494,'1','275','1',1,'Retail Sale Id 6270',699.20,0.00,0.00,0.95,72.20,'2022-09-30 14:34:37','',''),(6495,'1','275','1',1,'Retail Sale Id 6271',9200.00,0.00,0.00,12.50,950.00,'2022-09-30 14:35:21','',''),(6496,'1','275','1',1,'Retail Sale Id 6272',2303.68,0.00,0.00,3.13,237.88,'2022-09-30 14:36:00','',''),(6497,'1','275','1',1,'Retail Sale Id 6273',2001.92,0.00,0.00,2.72,206.72,'2022-09-30 14:45:29','',''),(6498,'1','275','1',1,'Retail Sale Id 6274',18400.00,0.00,0.00,25.00,1900.00,'2022-09-30 14:55:30','',''),(6499,'1','275','1',1,'Retail Sale Id 6275',9200.00,0.00,0.00,12.50,950.00,'2022-09-30 15:02:26','',''),(6500,'1','275','1',1,'Retail Sale Id 6276',9200.00,0.00,0.00,12.50,950.00,'2022-09-30 15:17:45','',''),(6501,'1','275','1',1,'Retail Sale Id 6276',18400.00,0.00,0.00,25.00,1900.00,'2022-09-30 15:17:45','',''),(6502,'1','275','1',1,'Retail Sale Id 6277',9200.00,0.00,0.00,12.50,950.00,'2022-09-30 15:31:12','',''),(6503,'1','275','1',1,'Retail Sale Id 6278',1000.96,0.00,0.00,1.36,103.36,'2022-09-30 15:42:47','',''),(6504,'1','275','1',1,'Retail Sale Id 6279',9200.00,0.00,0.00,12.50,950.00,'2022-09-30 15:56:47','',''),(6505,'1','275','1',1,'Retail Sale Id 6280',9200.00,0.00,0.00,12.50,950.00,'2022-09-30 16:04:33','',''),(6506,'1','275','1',1,'Retail Sale Id 6281',1501.44,0.00,0.00,2.04,155.04,'2022-09-30 16:06:00','',''),(6507,'1','275','1',1,'Retail Sale Id 6282',9200.00,0.00,0.00,12.50,950.00,'2022-09-30 16:07:31','',''),(6508,'1','275','1',1,'Retail Sale Id 6283',1000.96,0.00,0.00,1.36,103.36,'2022-09-30 16:08:17','',''),(6509,'1','275','1',1,'Retail Sale Id 6284',802.24,0.00,0.00,1.09,82.84,'2022-09-30 16:12:57','',''),(6510,'1','275','1',1,'Retail Sale Id 6285',3002.88,0.00,0.00,4.08,310.08,'2022-09-30 16:16:10','',''),(6511,'1','275','1',1,'Retail Sale Id 6286',9200.00,0.00,0.00,12.50,950.00,'2022-09-30 16:29:25','',''),(6512,'1','275','1',1,'Retail Sale Id 6287',1501.44,0.00,0.00,2.04,155.04,'2022-09-30 16:32:55','',''),(6513,'1','275','1',1,'Retail Sale Id 6288',9200.00,0.00,0.00,12.50,950.00,'2022-09-30 16:33:55','',''),(6514,'1','275','1',1,'Retail Sale Id 6289',1000.96,0.00,0.00,1.36,103.36,'2022-09-30 16:35:53','',''),(6515,'1','275','1',1,'Retail Sale Id 6290',2303.68,0.00,0.00,3.13,237.88,'2022-09-30 16:44:41','',''),(6516,'1','275','1',1,'Retail Sale Id 6291',14720.00,0.00,0.00,20.00,1520.00,'2022-09-30 16:51:29','',''),(6517,'1','275','1',1,'Retail Sale Id 6292',3002.88,0.00,0.00,4.08,310.08,'2022-09-30 17:03:31','',''),(6518,'1','275','1',1,'Retail Sale Id 6293',3702.08,0.00,0.00,5.03,382.28,'2022-09-30 17:08:03','',''),(6519,'1','275','1',1,'Retail Sale Id 6294',9200.00,0.00,0.00,12.50,950.00,'2022-09-30 17:16:19','',''),(6520,'1','275','1',1,'Retail Sale Id 6295',3002.88,0.00,0.00,4.08,310.08,'2022-09-30 17:22:53','',''),(6521,'1','275','1',1,'Retail Sale Id 6296',9200.00,0.00,0.00,12.50,950.00,'2022-09-30 17:27:02','',''),(6522,'1','275','1',1,'Retail Sale Id 6297',2001.92,0.00,0.00,2.72,206.72,'2022-09-30 17:31:20','',''),(6523,'1','275','1',1,'Retail Sale Id 6298',2303.68,0.00,0.00,3.13,237.88,'2022-09-30 17:36:15','',''),(6524,'1','275','1',1,'Retail Sale Id 6299',1501.44,0.00,0.00,2.04,155.04,'2022-09-30 17:41:03','',''),(6525,'1','275','1',1,'Retail Sale Id 6300',184000.00,0.00,0.00,250.00,19000.00,'2022-09-30 17:47:40','',''),(6526,'1','275','1',1,'Return of Retail Sale Id 6300',0.00,184000.00,250.00,0.00,-19000.00,'2022-09-30 17:48:03','',''),(6527,'1','275','1',1,'Retail Sale Id 6301',18400.00,0.00,0.00,25.00,1900.00,'2022-09-30 17:48:40','',''),(6528,'1','275','1',1,'Retail Sale Id 6302',2001.92,0.00,0.00,2.72,206.72,'2022-09-30 17:49:24','',''),(6529,'1','275','1',1,'Retail Sale Id 6303',4496.96,0.00,0.00,6.11,464.36,'2022-09-30 17:58:49','',''),(6530,'1','275','1',1,'Retail Sale Id 6304',2303.68,0.00,0.00,3.13,237.88,'2022-09-30 18:11:48','',''),(6531,'1','275','1',1,'Retail Sale Id 6305',9200.00,0.00,0.00,12.50,950.00,'2022-09-30 18:18:24','',''),(6532,'1','275','1',1,'Retail Sale Id 6306',3002.88,0.00,0.00,4.08,310.08,'2022-09-30 18:20:58','',''),(6533,'1','275','1',1,'Retail Sale Id 6307',2502.40,0.00,0.00,3.40,258.40,'2022-09-30 18:21:39','',''),(6534,'1','275','1',1,'Retail Sale Id 6308',1501.44,0.00,0.00,2.04,155.04,'2022-09-30 18:25:21','',''),(6535,'1','275','1',1,'Retail Sale Id 6309',14756.80,0.00,0.00,20.05,1523.80,'2022-09-30 19:05:28','',''),(6536,'1','275','1',1,'Retail Sale Id 6310',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 07:12:25','',''),(6537,'1','275','1',1,'Retail Sale Id 6311',3002.88,0.00,0.00,4.08,310.08,'2022-10-01 07:28:46','',''),(6538,'1','275','1',1,'Retail Sale Id 6312',8500.80,0.00,0.00,11.55,877.80,'2022-10-01 07:38:37','',''),(6539,'1','275','1',1,'Retail Sale Id 6313',2001.92,0.00,0.00,2.72,206.72,'2022-10-01 07:48:47','',''),(6540,'1','275','1',1,'Retail Sale Id 6314',3680.00,0.00,0.00,5.00,380.00,'2022-10-01 07:56:34','',''),(6541,'1','275','1',1,'Retail Sale Id 6315',3002.88,0.00,0.00,4.08,310.08,'2022-10-01 08:05:30','',''),(6542,'1','275','1',1,'Retail Sale Id 6316',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 08:10:41','',''),(6543,'1','275','1',1,'Retail Sale Id 6317',3996.48,0.00,0.00,5.43,412.68,'2022-10-01 08:19:27','',''),(6544,'1','275','1',1,'Retail Sale Id 6318',2502.40,0.00,0.00,3.40,258.40,'2022-10-01 08:29:26','',''),(6545,'1','275','1',1,'Retail Sale Id 6319',1000.96,0.00,0.00,1.36,103.36,'2022-10-01 08:30:14','',''),(6546,'1','275','1',1,'Retail Sale Id 6320',3996.48,0.00,0.00,5.43,412.68,'2022-10-01 08:38:33','',''),(6547,'1','275','1',1,'Retail Sale Id 6321',40480.00,0.00,0.00,55.00,4180.00,'2022-10-01 08:39:53','',''),(6548,'1','275','1',1,'Retail Sale Id 6322',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 08:43:07','',''),(6549,'1','275','1',1,'Retail Sale Id 6323',1501.44,0.00,0.00,2.04,155.04,'2022-10-01 08:54:41','',''),(6550,'1','275','1',1,'Retail Sale Id 6323',1501.44,0.00,0.00,2.04,155.04,'2022-10-01 08:54:41','',''),(6551,'1','275','1',1,'Retail Sale Id 6324',3680.00,0.00,0.00,5.00,380.00,'2022-10-01 09:01:50','',''),(6552,'1','275','1',1,'Retail Sale Id 6325',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 09:11:12','',''),(6553,'1','275','1',1,'Retail Sale Id 6326',2303.68,0.00,0.00,3.13,237.88,'2022-10-01 09:14:04','',''),(6554,'1','275','1',1,'Retail Sale Id 6327',1000.96,0.00,0.00,1.36,103.36,'2022-10-01 09:19:37','',''),(6555,'1','275','1',1,'Retail Sale Id 6328',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 09:42:46','',''),(6556,'1','275','1',1,'Retail Sale Id 6329',750.72,0.00,0.00,1.02,77.52,'2022-10-01 09:45:48','',''),(6557,'1','275','1',1,'Retail Sale Id 6330',1501.44,0.00,0.00,2.04,155.04,'2022-10-01 09:49:20','',''),(6558,'1','275','1',1,'Retail Sale Id 6331',6999.36,0.00,0.00,9.51,722.76,'2022-10-01 09:54:01','',''),(6559,'1','275','1',1,'Retail Sale Id 6332',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 09:55:12','',''),(6560,'1','275','1',1,'Retail Sale Id 6332',19997.12,0.00,0.00,27.17,2064.92,'2022-10-01 09:55:12','',''),(6561,'1','275','1',1,'Retail Sale Id 6333',3312.00,0.00,0.00,4.50,342.00,'2022-10-01 10:12:20','',''),(6562,'1','275','1',1,'Retail Sale Id 6334',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 10:17:32','',''),(6563,'1','275','1',1,'Retail Sale Id 6335',8000.32,0.00,0.00,10.87,826.12,'2022-10-01 10:43:06','',''),(6564,'1','275','1',1,'Retail Sale Id 6336',4997.44,0.00,0.00,6.79,516.04,'2022-10-01 10:44:43','',''),(6565,'1','275','1',1,'Retail Sale Id 6337',5497.92,0.00,0.00,7.47,567.72,'2022-10-01 10:45:46','',''),(6566,'1','275','1',1,'Retail Sale Id 6338',2001.92,0.00,0.00,2.72,206.72,'2022-10-01 10:47:02','',''),(6567,'1','275','1',1,'Retail Sale Id 6339',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 10:57:30','',''),(6568,'1','275','1',1,'Retail Sale Id 6340',4496.96,0.00,0.00,6.11,464.36,'2022-10-01 11:01:58','',''),(6569,'1','275','1',1,'Retail Sale Id 6341',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 11:05:39','',''),(6570,'1','275','1',1,'Retail Sale Id 6342',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 11:09:11','',''),(6571,'1','275','1',1,'Retail Sale Id 6344',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 11:13:41','',''),(6572,'1','275','1',1,'Retail Sale Id 6345',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 11:21:27','',''),(6573,'1','275','1',1,'Retail Sale Id 6346',1523.52,0.00,0.00,2.07,157.32,'2022-10-01 11:22:16','',''),(6574,'1','275','1',1,'Retail Sale Id 6347',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 11:30:03','',''),(6575,'1','275','1',1,'Retail Sale Id 6348',6999.36,0.00,0.00,9.51,722.76,'2022-10-01 11:31:30','',''),(6576,'1','275','1',1,'Retail Sale Id 6349',3996.48,0.00,0.00,5.43,412.68,'2022-10-01 11:35:14','',''),(6577,'1','275','1',1,'Retail Sale Id 6350',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 11:36:05','',''),(6578,'1','275','1',1,'Retail Sale Id 6351',2303.68,0.00,0.00,3.13,237.88,'2022-10-01 11:36:53','',''),(6579,'1','275','1',1,'Retail Sale Id 6352',1501.44,0.00,0.00,2.04,155.04,'2022-10-01 11:44:28','',''),(6580,'1','275','1',1,'Retail Sale Id 6353',802.24,0.00,0.00,1.09,82.84,'2022-10-01 11:49:59','',''),(6581,'1','275','1',1,'Retail Sale Id 6354',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 11:50:52','',''),(6582,'1','275','1',1,'Retail Sale Id 6355',4496.96,0.00,0.00,6.11,464.36,'2022-10-01 11:52:41','',''),(6583,'1','275','1',1,'Retail Sale Id 6356',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 11:53:38','',''),(6584,'1','275','1',1,'Retail Sale Id 6357',9001.28,0.00,0.00,12.23,929.48,'2022-10-01 12:00:08','',''),(6585,'1','275','1',1,'Retail Sale Id 6358',3680.00,0.00,0.00,5.00,380.00,'2022-10-01 12:01:34','',''),(6586,'1','275','1',1,'Retail Sale Id 6359',2252.16,0.00,0.00,3.06,232.56,'2022-10-01 12:03:00','',''),(6587,'1','275','1',1,'Retail Sale Id 6360',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 12:16:02','',''),(6588,'1','275','1',1,'Retail Sale Id 6361',4416.00,0.00,0.00,6.00,456.00,'2022-10-01 12:24:09','',''),(6589,'1','275','1',1,'Retail Sale Id 6362',5520.00,0.00,0.00,7.50,570.00,'2022-10-01 12:30:47','',''),(6590,'1','275','1',1,'Retail Sale Id 6362',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 12:30:47','',''),(6591,'1','275','1',1,'Retail Sale Id 6363',3002.88,0.00,0.00,4.08,310.08,'2022-10-01 12:36:39','',''),(6592,'1','275','1',1,'Retail Sale Id 6364',2208.00,0.00,0.00,3.00,228.00,'2022-10-01 12:46:10','',''),(6593,'1','275','1',1,'Retail Sale Id 6365',4496.96,0.00,0.00,6.11,464.36,'2022-10-01 12:52:21','',''),(6594,'1','275','1',1,'Retail Sale Id 6366',1700.16,0.00,0.00,2.31,175.56,'2022-10-01 13:06:47','',''),(6595,'1','275','1',1,'Retail Sale Id 6367',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 13:24:02','',''),(6596,'1','275','1',1,'Retail Sale Id 6368',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 13:34:32','',''),(6597,'1','275','1',1,'Retail Sale Id 6368',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 13:34:32','',''),(6598,'1','275','1',1,'Retail Sale Id 6369',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 13:41:30','',''),(6599,'1','275','1',1,'Retail Sale Id 6370',1501.44,0.00,0.00,2.04,155.04,'2022-10-01 14:09:03','',''),(6600,'1','275','1',1,'Retail Sale Id 6371',1000.96,0.00,0.00,1.36,103.36,'2022-10-01 14:16:27','',''),(6601,'1','275','1',1,'Retail Sale Id 6372',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 14:53:35','',''),(6602,'1','275','1',1,'Retail Sale Id 6373',3002.88,0.00,0.00,4.08,310.08,'2022-10-01 15:03:33','',''),(6603,'1','275','1',1,'Retail Sale Id 6374',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 15:06:50','',''),(6604,'1','275','1',1,'Retail Sale Id 6375',4416.00,0.00,0.00,6.00,456.00,'2022-10-01 15:08:57','',''),(6605,'1','275','1',1,'Retail Sale Id 6376',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 15:12:25','',''),(6606,'1','275','1',1,'Retail Sale Id 6377',36800.00,0.00,0.00,50.00,3800.00,'2022-10-01 15:15:08','',''),(6607,'1','275','1',1,'Retail Sale Id 6378',3702.08,0.00,0.00,5.03,382.28,'2022-10-01 15:24:21','',''),(6608,'1','275','1',1,'Retail Sale Id 6378',4496.96,0.00,0.00,6.11,464.36,'2022-10-01 15:24:21','',''),(6609,'1','275','1',1,'Retail Sale Id 6380',5998.40,0.00,0.00,8.15,619.40,'2022-10-01 15:37:31','',''),(6610,'1','275','1',1,'Retail Sale Id 6381',4416.00,0.00,0.00,6.00,456.00,'2022-10-01 15:38:11','',''),(6611,'1','275','1',1,'Retail Sale Id 6382',2303.68,0.00,0.00,3.13,237.88,'2022-10-01 15:39:03','',''),(6612,'1','275','1',1,'Retail Sale Id 6383',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 15:45:56','',''),(6613,'1','275','1',1,'Retail Sale Id 6384',1501.44,0.00,0.00,2.04,155.04,'2022-10-01 15:57:53','',''),(6614,'1','275','1',1,'Retail Sale Id 6384',1501.44,0.00,0.00,2.04,155.04,'2022-10-01 15:57:53','',''),(6615,'1','275','1',1,'Retail Sale Id 6385',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 16:09:02','',''),(6616,'1','275','1',1,'Retail Sale Id 6386',36800.00,0.00,0.00,50.00,3800.00,'2022-10-01 16:11:32','',''),(6617,'1','275','1',1,'Retail Sale Id 6387',1501.44,0.00,0.00,2.04,155.04,'2022-10-01 16:14:05','',''),(6618,'1','275','1',1,'Retail Sale Id 6388',4496.96,0.00,0.00,6.11,464.36,'2022-10-01 16:19:28','',''),(6619,'1','275','1',1,'Retail Sale Id 6389',2303.68,0.00,0.00,3.13,237.88,'2022-10-01 16:20:09','',''),(6620,'1','275','1',1,'Retail Sale Id 6390',2252.16,0.00,0.00,3.06,232.56,'2022-10-01 16:20:44','',''),(6621,'1','275','1',1,'Retail Sale Id 6391',2303.68,0.00,0.00,3.13,237.88,'2022-10-01 16:25:49','',''),(6622,'1','275','1',1,'Retail Sale Id 6392',3503.36,0.00,0.00,4.76,361.76,'2022-10-01 16:27:12','',''),(6623,'1','275','1',1,'Retail Sale Id 6393',1501.44,0.00,0.00,2.04,155.04,'2022-10-01 16:32:28','',''),(6624,'1','275','1',1,'Retail Sale Id 6394',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 16:42:08','',''),(6625,'1','275','1',1,'Retail Sale Id 6395',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 16:53:45','',''),(6626,'1','275','1',1,'Retail Sale Id 6396',4496.96,0.00,0.00,6.11,464.36,'2022-10-01 16:54:52','',''),(6627,'1','275','1',1,'Retail Sale Id 6397',3002.88,0.00,0.00,4.08,310.08,'2022-10-01 16:56:50','',''),(6628,'1','275','1',1,'Retail Sale Id 6399',2303.68,0.00,0.00,3.13,237.88,'2022-10-01 16:59:35','',''),(6629,'1','275','1',1,'Retail Sale Id 6400',18400.00,0.00,0.00,25.00,1900.00,'2022-10-01 17:00:56','',''),(6630,'1','275','1',1,'Retail Sale Id 6401',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 17:03:06','',''),(6631,'1','275','1',1,'Retail Sale Id 6402',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 17:16:35','',''),(6632,'1','275','1',1,'Retail Sale Id 6404',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 17:22:05','',''),(6633,'1','275','1',1,'Retail Sale Id 6405',18400.00,0.00,0.00,25.00,1900.00,'2022-10-01 17:43:28','',''),(6634,'1','275','1',1,'Retail Sale Id 6406',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 17:44:22','',''),(6635,'1','275','1',1,'Retail Sale Id 6407',4496.96,0.00,0.00,6.11,464.36,'2022-10-01 17:48:05','',''),(6636,'1','275','1',1,'Retail Sale Id 6408',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 17:50:42','',''),(6637,'1','275','1',1,'Retail Sale Id 6409',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 17:53:20','',''),(6638,'1','275','1',1,'Retail Sale Id 6410',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 17:56:46','',''),(6639,'1','275','1',1,'Retail Sale Id 6411',4496.96,0.00,0.00,6.11,464.36,'2022-10-01 18:07:22','',''),(6640,'1','275','1',1,'Retail Sale Id 6411',9200.00,0.00,0.00,12.50,950.00,'2022-10-01 18:07:22','',''),(6641,'1','275','1',1,'Retail Sale Id 6412',4496.96,0.00,0.00,6.11,464.36,'2022-10-01 18:16:50','',''),(6642,'1','275','1',1,'Retail Sale Id 6413',3002.88,0.00,0.00,4.08,310.08,'2022-10-01 18:17:35','',''),(6643,'1','275','1',1,'Retail Sale Id 6414',2303.68,0.00,0.00,3.13,237.88,'2022-10-01 18:31:55','',''),(6644,'1','275','1',1,'Return of Retail Sale Id 6413',0.00,3002.88,4.08,0.00,-310.08,'2022-10-01 19:32:09','',''),(6645,'1','275','1',1,'Return of Retail Sale Id 6414',0.00,2303.68,3.13,0.00,-237.88,'2022-10-01 19:33:00','',''),(6646,'1','275','1',1,'Retail Sale Id 6415',2340.48,0.00,0.00,3.18,241.68,'2022-10-01 19:33:51','',''),(6647,'1','275','1',1,'Retail Sale Id 6416',14720.00,0.00,0.00,20.00,1520.00,'2022-10-02 07:12:02','',''),(6648,'1','275','1',1,'Retail Sale Id 6417',9200.00,0.00,0.00,12.50,950.00,'2022-10-02 07:17:47','',''),(6649,'1','275','1',1,'Retail Sale Id 6418',4997.44,0.00,0.00,6.79,516.04,'2022-10-02 07:20:34','',''),(6650,'1','275','1',1,'Retail Sale Id 6419',1501.44,0.00,0.00,2.04,155.04,'2022-10-02 08:16:38','',''),(6651,'1','275','1',1,'Retail Sale Id 6420',9200.00,0.00,0.00,12.50,950.00,'2022-10-02 08:18:16','',''),(6652,'1','275','1',1,'Retail Sale Id 6421',1501.44,0.00,0.00,2.04,155.04,'2022-10-02 08:23:49','',''),(6653,'1','275','1',1,'Retail Sale Id 6422',1501.44,0.00,0.00,2.04,155.04,'2022-10-02 08:31:28','',''),(6654,'1','275','1',1,'Retail Sale Id 6423',2303.68,0.00,0.00,3.13,237.88,'2022-10-02 08:41:49','',''),(6655,'1','275','1',1,'Retail Sale Id 6424',1000.96,0.00,0.00,1.36,103.36,'2022-10-02 08:42:33','',''),(6656,'1','275','1',1,'Retail Sale Id 6425',3201.60,0.00,0.00,4.35,330.60,'2022-10-02 09:08:36','',''),(6657,'1','275','1',1,'Retail Sale Id 6426',2001.92,0.00,0.00,2.72,206.72,'2022-10-02 09:11:46','',''),(6658,'1','275','1',1,'Retail Sale Id 6427',9200.00,0.00,0.00,12.50,950.00,'2022-10-02 09:12:50','',''),(6659,'1','275','1',1,'Retail Sale Id 6428',1000.96,0.00,0.00,1.36,103.36,'2022-10-02 09:18:47','',''),(6660,'1','275','1',1,'Retail Sale Id 6429',1501.44,0.00,0.00,2.04,155.04,'2022-10-02 09:26:23','',''),(6661,'1','275','1',1,'Retail Sale Id 6430',802.24,0.00,0.00,1.09,82.84,'2022-10-02 09:30:50','',''),(6662,'1','275','1',1,'Retail Sale Id 6431',18400.00,0.00,0.00,25.00,1900.00,'2022-10-02 09:37:27','',''),(6663,'1','275','1',1,'Retail Sale Id 6432',9200.00,0.00,0.00,12.50,950.00,'2022-10-02 09:44:43','',''),(6664,'1','275','1',1,'Retail Sale Id 6433',9200.00,0.00,0.00,12.50,950.00,'2022-10-02 09:49:25','',''),(6665,'1','275','1',1,'Retail Sale Id 6434',2001.92,0.00,0.00,2.72,206.72,'2022-10-02 09:52:34','',''),(6666,'1','275','1',1,'Retail Sale Id 6435',9200.00,0.00,0.00,12.50,950.00,'2022-10-02 09:54:03','',''),(6667,'1','275','1',1,'Retail Sale Id 6436',3702.08,0.00,0.00,5.03,382.28,'2022-10-02 09:58:05','',''),(6668,'1','275','1',1,'Retail Sale Id 6437',9200.00,0.00,0.00,12.50,950.00,'2022-10-02 10:13:49','',''),(6669,'1','275','1',1,'Retail Sale Id 6438',2208.00,0.00,0.00,3.00,228.00,'2022-10-02 10:30:29','',''),(6670,'1','275','1',1,'Retail Sale Id 6439',14720.00,0.00,0.00,20.00,1520.00,'2022-10-02 10:41:50','',''),(6671,'1','275','1',1,'Retail Sale Id 6440',3680.00,0.00,0.00,5.00,380.00,'2022-10-02 10:43:37','',''),(6672,'1','275','1',1,'Retail Sale Id 6441',1000.96,0.00,0.00,1.36,103.36,'2022-10-02 10:49:26','',''),(6673,'1','275','1',1,'Retail Sale Id 6441',1000.96,0.00,0.00,1.36,103.36,'2022-10-02 10:49:26','',''),(6674,'1','275','1',1,'Retail Sale Id 6442',4496.96,0.00,0.00,6.11,464.36,'2022-10-02 10:50:52','',''),(6675,'1','275','1',1,'Retail Sale Id 6442',9200.00,0.00,0.00,12.50,950.00,'2022-10-02 10:50:52','',''),(6676,'1','275','1',1,'Retail Sale Id 6443',2208.00,0.00,0.00,3.00,228.00,'2022-10-02 10:52:23','',''),(6677,'1','275','1',1,'Retail Sale Id 6444',9200.00,0.00,0.00,12.50,950.00,'2022-10-02 10:53:09','',''),(6678,'1','275','1',1,'Retail Sale Id 6445',1000.96,0.00,0.00,1.36,103.36,'2022-10-02 10:56:29','',''),(6679,'1','275','1',1,'Retail Sale Id 6446',9200.00,0.00,0.00,12.50,950.00,'2022-10-02 11:03:20','',''),(6680,'1','275','1',1,'Retail Sale Id 6447',2303.68,0.00,0.00,3.13,237.88,'2022-10-02 11:04:23','',''),(6681,'1','275','1',1,'Retail Sale Id 6448',9200.00,0.00,0.00,12.50,950.00,'2022-10-02 11:42:11','',''),(6682,'1','275','1',1,'Retail Sale Id 6449',1840.00,0.00,0.00,2.50,190.00,'2022-10-02 11:44:13','',''),(6683,'1','275','1',1,'Retail Sale Id 6450',9200.00,0.00,0.00,12.50,950.00,'2022-10-02 11:46:02','',''),(6684,'1','275','1',1,'Retail Sale Id 6450',9200.00,0.00,0.00,12.50,950.00,'2022-10-02 11:46:02','',''),(6685,'1','275','1',1,'Retail Sale Id 6451',3002.88,0.00,0.00,4.08,310.08,'2022-10-02 12:06:07','',''),(6686,'1','275','1',1,'Retail Sale Id 6452',1501.44,0.00,0.00,2.04,155.04,'2022-10-02 12:14:13','',''),(6687,'1','275','1',1,'Retail Sale Id 6453',4416.00,0.00,0.00,6.00,456.00,'2022-10-02 12:17:18','',''),(6688,'1','275','1',1,'Retail Sale Id 6453',9200.00,0.00,0.00,12.50,950.00,'2022-10-02 12:17:18','',''),(6689,'1','275','1',1,'Retail Sale Id 6454',9200.00,0.00,0.00,12.50,950.00,'2022-10-02 12:24:21','',''),(6690,'1','275','1',1,'Retail Sale Id 6455',4496.96,0.00,0.00,6.11,464.36,'2022-10-02 12:25:24','',''),(6691,'1','275','1',1,'Retail Sale Id 6456',9200.00,0.00,0.00,12.50,950.00,'2022-10-02 12:29:13','',''),(6692,'1','275','1',1,'Retail Sale Id 6456',9200.00,0.00,0.00,12.50,950.00,'2022-10-02 12:29:13','',''),(6693,'1','275','1',1,'Retail Sale Id 6457',9200.00,0.00,0.00,12.50,950.00,'2022-10-02 12:42:14','',''),(6694,'1','275','1',1,'Retail Sale Id 6458',3002.88,0.00,0.00,4.08,310.08,'2022-10-02 12:53:27','',''),(6695,'1','275','1',1,'Retail Sale Id 6459',6624.00,0.00,0.00,9.00,684.00,'2022-10-02 12:56:03','',''),(6696,'1','275','1',1,'Retail Sale Id 6460',3002.88,0.00,0.00,4.08,310.08,'2022-10-02 12:57:22','',''),(6697,'1','275','1',1,'Retail Sale Id 6461',1398.40,0.00,0.00,1.90,144.40,'2022-10-02 13:10:27','',''),(6698,'1','275','1',1,'Retail Sale Id 6462',3702.08,0.00,0.00,5.03,382.28,'2022-10-02 13:13:45','',''),(6699,'1','275','1',1,'Retail Sale Id 6463',8096.00,0.00,0.00,11.00,836.00,'2022-10-02 13:15:38','',''),(6700,'1','275','1',1,'Retail Sale Id 6464',2001.92,0.00,0.00,2.72,206.72,'2022-10-02 13:16:31','',''),(6701,'1','275','1',1,'Retail Sale Id 6465',8000.32,0.00,0.00,10.87,826.12,'2022-10-02 13:17:57','',''),(6702,'1','275','1',1,'Retail Sale Id 6466',9200.00,0.00,0.00,12.50,950.00,'2022-10-02 13:18:59','',''),(6703,'1','275','1',1,'Retail Sale Id 6467',9200.00,0.00,0.00,12.50,950.00,'2022-10-02 13:23:21','',''),(6704,'1','275','1',1,'Retail Sale Id 6468',4416.00,0.00,0.00,6.00,456.00,'2022-10-02 13:24:40','',''),(6705,'1','275','1',1,'Retail Sale Id 6469',4997.44,0.00,0.00,6.79,516.04,'2022-10-02 13:45:40','',''),(6706,'1','275','1',1,'Retail Sale Id 6470',2001.92,0.00,0.00,2.72,206.72,'2022-10-02 13:52:55','',''),(6707,'1','275','1',1,'Retail Sale Id 6470',3002.88,0.00,0.00,4.08,310.08,'2022-10-02 13:52:55','',''),(6708,'1','275','1',1,'Retail Sale Id 6471',9200.00,0.00,0.00,12.50,950.00,'2022-10-02 14:08:15','',''),(6709,'1','275','1',1,'Retail Sale Id 6472',9200.00,0.00,0.00,12.50,950.00,'2022-10-02 14:09:42','',''),(6710,'1','275','1',1,'Retail Sale Id 6473',3680.00,0.00,0.00,5.00,380.00,'2022-10-02 14:11:30','',''),(6711,'1','275','1',1,'Retail Sale Id 6474',3002.88,0.00,0.00,4.08,310.08,'2022-10-02 14:12:26','',''),(6712,'1','275','1',1,'Retail Sale Id 6475',4416.00,0.00,0.00,6.00,456.00,'2022-10-02 14:18:00','',''),(6713,'1','275','1',1,'Retail Sale Id 6476',9200.00,0.00,0.00,12.50,950.00,'2022-10-02 14:22:05','',''),(6714,'1','275','1',1,'Retail Sale Id 6477',3002.88,0.00,0.00,4.08,310.08,'2022-10-02 14:24:24','',''),(6715,'1','275','1',1,'Retail Sale Id 6478',3680.00,0.00,0.00,5.00,380.00,'2022-10-02 14:25:55','',''),(6716,'1','275','1',1,'Retail Sale Id 6478',9200.00,0.00,0.00,12.50,950.00,'2022-10-02 14:25:55','',''),(6717,'1','275','1',1,'Retail Sale Id 6479',9200.00,0.00,0.00,12.50,950.00,'2022-10-02 14:27:58','',''),(6718,'1','275','1',1,'Retail Sale Id 6480',9200.00,0.00,0.00,12.50,950.00,'2022-10-02 14:38:08','',''),(6719,'1','275','1',1,'Retail Sale Id 6481',9200.00,0.00,0.00,12.50,950.00,'2022-10-02 14:42:56','',''),(6720,'1','275','1',1,'Retail Sale Id 6482',6653.44,0.00,0.00,9.04,687.04,'2022-10-02 14:45:54','',''),(6721,'1','275','1',1,'Retail Sale Id 6483',2502.40,0.00,0.00,3.40,258.40,'2022-10-02 14:46:53','',''),(6722,'1','275','1',1,'Retail Sale Id 6484',3002.88,0.00,0.00,4.08,310.08,'2022-10-02 14:49:44','',''),(6723,'1','275','1',1,'Retail Sale Id 6485',9200.00,0.00,0.00,12.50,950.00,'2022-10-02 15:00:16','',''),(6724,'1','275','1',1,'Retail Sale Id 6486',9200.00,0.00,0.00,12.50,950.00,'2022-10-02 15:04:44','',''),(6725,'1','275','1',1,'Retail Sale Id 6487',2502.40,0.00,0.00,3.40,258.40,'2022-10-02 15:06:39','',''),(6726,'1','275','1',1,'Retail Sale Id 6488',9200.00,0.00,0.00,12.50,950.00,'2022-10-02 15:09:16','',''),(6727,'1','275','1',1,'Retail Sale Id 6488',18400.00,0.00,0.00,25.00,1900.00,'2022-10-02 15:09:16','',''),(6728,'1','275','1',1,'Retail Sale Id 6489',9200.00,0.00,0.00,12.50,950.00,'2022-10-02 15:21:28','',''),(6729,'1','275','1',1,'Retail Sale Id 6490',9200.00,0.00,0.00,12.50,950.00,'2022-10-02 15:29:19','',''),(6730,'1','275','1',1,'Retail Sale Id 6491',8832.00,0.00,0.00,12.00,912.00,'2022-10-02 15:38:33','',''),(6731,'1','275','1',1,'Retail Sale Id 6492',9200.00,0.00,0.00,12.50,950.00,'2022-10-02 15:53:46','',''),(6732,'1','275','1',1,'Retail Sale Id 6493',9200.00,0.00,0.00,12.50,950.00,'2022-10-02 16:04:05','',''),(6733,'1','275','1',1,'Retail Sale Id 6494',9200.00,0.00,0.00,12.50,950.00,'2022-10-02 16:16:36','',''),(6734,'1','275','1',1,'Return of Retail Sale Id 6487',0.00,2502.40,3.40,0.00,-258.40,'2022-10-02 16:35:11','',''),(6735,'1','275','1',1,'Retail Sale Id 6495',6528.32,0.00,0.00,8.87,674.12,'2022-10-02 16:36:45','',''),(6736,'1','275','1',1,'Distributed to Operational lost for sales id:21',2679.60,0.00,0.00,4.06,0.00,'2022-10-02 16:41:14','',''),(6737,'1','275',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3551000.00,5300.00,0.00,0.00,'2022-10-03 07:43:56','',''),(6738,'1','275',NULL,1,'Reception corrector for bridging 26',0.00,0.00,0.00,5300.00,0.00,'2022-10-03 07:45:08','',''),(6739,'1','275','1',1,'Received from bridging 26',0.00,0.00,5300.00,0.00,0.00,'2022-10-03 07:45:08','',''),(6740,'1','275','1',1,'Retail Sale Id 6496',2303.68,0.00,0.00,3.13,206.58,'2022-10-03 07:45:55','',''),(6741,'1','275','1',1,'Retail Sale Id 6497',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 07:54:55','',''),(6742,'1','275','1',1,'Retail Sale Id 6498',2303.68,0.00,0.00,3.13,206.58,'2022-10-03 07:55:51','',''),(6743,'1','275','1',1,'Retail Sale Id 6500',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 08:01:15','',''),(6744,'1','275','1',1,'Retail Sale Id 6501',3702.08,0.00,0.00,5.03,331.98,'2022-10-03 08:07:32','',''),(6745,'1','275','1',1,'Retail Sale Id 6502',18400.00,0.00,0.00,25.00,1650.00,'2022-10-03 08:10:59','',''),(6746,'1','275','1',1,'Retail Sale Id 6503',1000.96,0.00,0.00,1.36,89.76,'2022-10-03 08:12:45','',''),(6747,'1','275','1',1,'Retail Sale Id 6504',12600.32,0.00,0.00,17.12,1129.92,'2022-10-03 08:19:41','',''),(6748,'1','275','1',1,'Retail Sale Id 6505',2208.00,0.00,0.00,3.00,198.00,'2022-10-03 08:20:58','',''),(6749,'1','275','1',1,'Retail Sale Id 6506',2502.40,0.00,0.00,3.40,224.40,'2022-10-03 08:24:52','',''),(6750,'1','275','1',1,'Retail Sale Id 6507',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 08:33:21','',''),(6751,'1','275','1',1,'Retail Sale Id 6508',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 08:40:13','',''),(6752,'1','275','1',1,'Retail Sale Id 6509',36800.00,0.00,0.00,50.00,3300.00,'2022-10-03 08:41:42','',''),(6753,'1','275','1',1,'Retail Sale Id 6510',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 08:46:46','',''),(6754,'1','275','1',1,'Retail Sale Id 6511',3002.88,0.00,0.00,4.08,269.28,'2022-10-03 08:50:59','',''),(6755,'1','275','1',1,'Retail Sale Id 6512',1000.96,0.00,0.00,1.36,89.76,'2022-10-03 08:52:13','',''),(6756,'1','275','1',1,'Retail Sale Id 6513',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 09:02:09','',''),(6757,'1','275','1',1,'Retail Sale Id 6514',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 09:11:43','',''),(6758,'1','275','1',1,'Retail Sale Id 6515',2001.92,0.00,0.00,2.72,179.52,'2022-10-03 09:28:32','',''),(6759,'1','275','1',1,'Retail Sale Id 6515',8000.32,0.00,0.00,10.87,717.42,'2022-10-03 09:28:32','',''),(6760,'1','275','1',1,'Retail Sale Id 6516',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 09:36:27','',''),(6761,'1','275','1',1,'Retail Sale Id 6517',1000.96,0.00,0.00,1.36,89.76,'2022-10-03 09:45:24','',''),(6762,'1','275','1',1,'Retail Sale Id 6518',3002.88,0.00,0.00,4.08,269.28,'2022-10-03 09:49:27','',''),(6763,'1','275','1',1,'Retail Sale Id 6519',2001.92,0.00,0.00,2.72,179.52,'2022-10-03 09:54:48','',''),(6764,'1','275','1',1,'Retail Sale Id 6520',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 10:02:17','',''),(6765,'1','275','1',1,'Retail Sale Id 6521',4600.00,0.00,0.00,6.25,412.50,'2022-10-03 10:03:22','',''),(6766,'1','275','1',1,'Retail Sale Id 6522',4997.44,0.00,0.00,6.79,448.14,'2022-10-03 10:12:20','',''),(6767,'1','275','1',1,'Retail Sale Id 6523',3680.00,0.00,0.00,5.00,330.00,'2022-10-03 10:15:50','',''),(6768,'1','275','1',1,'Retail Sale Id 6523',13984.00,0.00,0.00,19.00,1254.00,'2022-10-03 10:15:50','',''),(6769,'1','275','1',1,'Retail Sale Id 6524',4416.00,0.00,0.00,6.00,396.00,'2022-10-03 10:16:31','',''),(6770,'1','275','1',1,'Retail Sale Id 6525',4496.96,0.00,0.00,6.11,403.26,'2022-10-03 10:17:23','',''),(6771,'1','275','1',1,'Retail Sale Id 6526',27600.00,0.00,0.00,37.50,2475.00,'2022-10-03 10:27:15','',''),(6772,'1','275','1',1,'Retail Sale Id 6527',8000.32,0.00,0.00,10.87,717.42,'2022-10-03 10:28:46','',''),(6773,'1','275','1',1,'Retail Sale Id 6528',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 10:39:00','',''),(6774,'1','275','1',1,'Retail Sale Id 6529',1898.88,0.00,0.00,2.58,170.28,'2022-10-03 10:40:53','',''),(6775,'1','275','1',1,'Retail Sale Id 6530',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 10:42:58','',''),(6776,'1','275','1',1,'Retail Sale Id 6531',18400.00,0.00,0.00,25.00,1650.00,'2022-10-03 10:44:31','',''),(6777,'1','275','1',1,'Retail Sale Id 6532',11776.00,0.00,0.00,16.00,1056.00,'2022-10-03 10:47:41','',''),(6778,'1','275','1',1,'Retail Sale Id 6533',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 10:53:41','',''),(6779,'1','275','1',1,'Retail Sale Id 6534',2208.00,0.00,0.00,3.00,198.00,'2022-10-03 10:56:18','',''),(6780,'1','275','1',1,'Retail Sale Id 6535',4997.44,0.00,0.00,6.79,448.14,'2022-10-03 11:03:22','',''),(6781,'1','275','1',1,'Retail Sale Id 6536',1501.44,0.00,0.00,2.04,134.64,'2022-10-03 11:05:10','',''),(6782,'1','275','1',1,'Retail Sale Id 6537',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 11:06:45','',''),(6783,'1','275','1',1,'Retail Sale Id 6538',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 11:07:47','',''),(6784,'1','275','1',1,'Retail Sale Id 6539',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 11:16:38','',''),(6785,'1','275','1',1,'Retail Sale Id 6540',3702.08,0.00,0.00,5.03,331.98,'2022-10-03 11:22:43','',''),(6786,'1','275','1',1,'Retail Sale Id 6541',4496.96,0.00,0.00,6.11,403.26,'2022-10-03 11:36:10','',''),(6787,'1','275','1',1,'Retail Sale Id 6542',18400.00,0.00,0.00,25.00,1650.00,'2022-10-03 11:48:47','',''),(6788,'1','275','1',1,'Retail Sale Id 6543',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 11:51:52','',''),(6789,'1','275','1',1,'Retail Sale Id 6544',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 11:56:40','',''),(6790,'1','275','1',1,'Retail Sale Id 6545',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 12:02:17','',''),(6791,'1','275','1',1,'Retail Sale Id 6546',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 12:11:01','',''),(6792,'1','275','1',1,'Retail Sale Id 6547',3702.08,0.00,0.00,5.03,331.98,'2022-10-03 12:17:24','',''),(6793,'1','275','1',1,'Retail Sale Id 6548',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 12:19:25','',''),(6794,'1','275','1',1,'Retail Sale Id 6549',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 12:49:04','',''),(6795,'1','275','1',1,'Retail Sale Id 6550',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 13:02:49','',''),(6796,'1','275','1',1,'Retail Sale Id 6551',3503.36,0.00,0.00,4.76,314.16,'2022-10-03 13:03:38','',''),(6797,'1','275','1',1,'Retail Sale Id 6552',4600.00,0.00,0.00,6.25,412.50,'2022-10-03 13:14:17','',''),(6798,'1','275','1',1,'Retail Sale Id 6553',1501.44,0.00,0.00,2.04,134.64,'2022-10-03 13:24:15','',''),(6799,'1','275','1',1,'Retail Sale Id 6554',2001.92,0.00,0.00,2.72,179.52,'2022-10-03 13:25:01','',''),(6800,'1','275','1',1,'Retail Sale Id 6555',2303.68,0.00,0.00,3.13,206.58,'2022-10-03 13:32:26','',''),(6801,'1','275','1',1,'Retail Sale Id 6556',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 13:33:46','',''),(6802,'1','275','1',1,'Retail Sale Id 6557',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 13:54:52','',''),(6803,'1','275','1',1,'Retail Sale Id 6558',3002.88,0.00,0.00,4.08,269.28,'2022-10-03 14:00:51','',''),(6804,'1','275','1',1,'Retail Sale Id 6559',3503.36,0.00,0.00,4.76,314.16,'2022-10-03 14:01:40','',''),(6805,'1','275','1',1,'Retail Sale Id 6560',7360.00,0.00,0.00,10.00,660.00,'2022-10-03 14:10:00','',''),(6806,'1','275','1',1,'Retail Sale Id 6561',2303.68,0.00,0.00,3.13,206.58,'2022-10-03 14:16:04','',''),(6807,'1','275','1',1,'Retail Sale Id 6562',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 14:17:07','',''),(6808,'1','275','1',1,'Retail Sale Id 6563',3503.36,0.00,0.00,4.76,314.16,'2022-10-03 14:22:58','',''),(6809,'1','275','1',1,'Retail Sale Id 6564',3996.48,0.00,0.00,5.43,358.38,'2022-10-03 14:52:35','',''),(6810,'1','275','1',1,'Retail Sale Id 6565',4997.44,0.00,0.00,6.79,448.14,'2022-10-03 15:10:22','',''),(6811,'1','275','1',1,'Retail Sale Id 6566',3996.48,0.00,0.00,5.43,358.38,'2022-10-03 15:16:15','',''),(6812,'1','275','1',1,'Retail Sale Id 6567',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 15:18:18','',''),(6813,'1','275','1',1,'Retail Sale Id 6568',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 15:19:17','',''),(6814,'1','275','1',1,'Retail Sale Id 6569',3680.00,0.00,0.00,5.00,330.00,'2022-10-03 15:31:19','',''),(6815,'1','275','1',1,'Retail Sale Id 6569',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 15:31:19','',''),(6816,'1','275','1',1,'Retail Sale Id 6570',5998.40,0.00,0.00,8.15,537.90,'2022-10-03 15:32:27','',''),(6817,'1','275','1',1,'Retail Sale Id 6571',1501.44,0.00,0.00,2.04,134.64,'2022-10-03 15:46:14','',''),(6818,'1','275','1',1,'Retail Sale Id 6572',4496.96,0.00,0.00,6.11,403.26,'2022-10-03 15:53:05','',''),(6819,'1','275','1',1,'Retail Sale Id 6573',2252.16,0.00,0.00,3.06,201.96,'2022-10-03 16:08:48','',''),(6820,'1','275','1',1,'Retail Sale Id 6574',3702.08,0.00,0.00,5.03,331.98,'2022-10-03 16:17:21','',''),(6821,'1','275','1',1,'Retail Sale Id 6576',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 16:20:23','',''),(6822,'1','275','1',1,'Retail Sale Id 6577',3702.08,0.00,0.00,5.03,331.98,'2022-10-03 16:25:33','',''),(6823,'1','275','1',1,'Retail Sale Id 6578',2001.92,0.00,0.00,2.72,179.52,'2022-10-03 16:27:58','',''),(6824,'1','275','1',1,'Retail Sale Id 6579',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 16:28:58','',''),(6825,'1','275','1',1,'Retail Sale Id 6580',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 16:31:26','',''),(6826,'1','275','1',1,'Retail Sale Id 6581',2303.68,0.00,0.00,3.13,206.58,'2022-10-03 16:34:14','',''),(6827,'1','275','1',1,'Retail Sale Id 6583',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 16:37:25','',''),(6828,'1','275','1',1,'Retail Sale Id 6584',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 16:49:54','',''),(6829,'1','275','1',1,'Retail Sale Id 6585',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 16:59:50','',''),(6830,'1','275','1',1,'Retail Sale Id 6586',2208.00,0.00,0.00,3.00,198.00,'2022-10-03 17:01:45','',''),(6831,'1','275','1',1,'Retail Sale Id 6587',1501.44,0.00,0.00,2.04,134.64,'2022-10-03 17:02:33','',''),(6832,'1','275','1',1,'Retail Sale Id 6588',4496.96,0.00,0.00,6.11,403.26,'2022-10-03 17:03:22','',''),(6833,'1','275','1',1,'Retail Sale Id 6589',2303.68,0.00,0.00,3.13,206.58,'2022-10-03 17:04:45','',''),(6834,'1','275','1',1,'Retail Sale Id 6590',4496.96,0.00,0.00,6.11,403.26,'2022-10-03 17:10:54','',''),(6835,'1','275','1',1,'Retail Sale Id 6591',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 17:12:24','',''),(6836,'1','275','1',1,'Retail Sale Id 6592',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 17:13:27','',''),(6837,'1','275','1',1,'Retail Sale Id 6593',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 17:18:27','',''),(6838,'1','275','1',1,'Retail Sale Id 6594',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 17:19:58','',''),(6839,'1','275','1',1,'Retail Sale Id 6595',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 17:26:21','',''),(6840,'1','275','1',1,'Retail Sale Id 6596',4496.96,0.00,0.00,6.11,403.26,'2022-10-03 17:29:45','',''),(6841,'1','275','1',1,'Retail Sale Id 6596',4496.96,0.00,0.00,6.11,403.26,'2022-10-03 17:29:45','',''),(6842,'1','275','1',1,'Retail Sale Id 6597',3702.08,0.00,0.00,5.03,331.98,'2022-10-03 17:34:38','',''),(6843,'1','275','1',1,'Retail Sale Id 6598',3996.48,0.00,0.00,5.43,358.38,'2022-10-03 17:39:36','',''),(6844,'1','275','1',1,'Retail Sale Id 6599',1501.44,0.00,0.00,2.04,134.64,'2022-10-03 17:40:22','',''),(6845,'1','275','1',1,'Retail Sale Id 6600',2303.68,0.00,0.00,3.13,206.58,'2022-10-03 17:44:44','',''),(6846,'1','275','1',1,'Retail Sale Id 6601',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 17:45:58','',''),(6847,'1','275','1',1,'Retail Sale Id 6602',8000.32,0.00,0.00,10.87,717.42,'2022-10-03 17:48:46','',''),(6848,'1','275','1',1,'Retail Sale Id 6603',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 17:51:20','',''),(6849,'1','275','1',1,'Retail Sale Id 6604',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 17:55:37','',''),(6850,'1','275','1',1,'Retail Sale Id 6605',3002.88,0.00,0.00,4.08,269.28,'2022-10-03 17:58:07','',''),(6851,'1','275','1',1,'Retail Sale Id 6606',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 18:06:25','',''),(6852,'1','275','1',1,'Retail Sale Id 6607',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 18:08:07','',''),(6853,'1','275','1',1,'Retail Sale Id 6608',4416.00,0.00,0.00,6.00,396.00,'2022-10-03 18:10:49','',''),(6854,'1','275','1',1,'Retail Sale Id 6609',3996.48,0.00,0.00,5.43,358.38,'2022-10-03 18:30:20','',''),(6855,'1','275','1',1,'Retail Sale Id 6610',1000.96,0.00,0.00,1.36,89.76,'2022-10-03 18:32:06','',''),(6856,'1','275','1',1,'Retail Sale Id 6612',3002.88,0.00,0.00,4.08,269.28,'2022-10-03 18:43:51','',''),(6857,'1','275','1',1,'Retail Sale Id 6613',3864.00,0.00,0.00,5.25,346.50,'2022-10-03 19:04:47','',''),(6858,'1','275','1',1,'Retail Sale Id 6614',9200.00,0.00,0.00,12.50,825.00,'2022-10-04 07:08:21','',''),(6859,'1','275','1',1,'Retail Sale Id 6615',18400.00,0.00,0.00,25.00,1650.00,'2022-10-04 07:22:00','',''),(6860,'1','275','1',1,'Retail Sale Id 6617',3702.08,0.00,0.00,5.03,331.98,'2022-10-04 07:24:28','',''),(6861,'1','275','1',1,'Retail Sale Id 6618',8096.00,0.00,0.00,11.00,726.00,'2022-10-04 07:51:12','',''),(6862,'1','275','1',1,'Retail Sale Id 6619',9200.00,0.00,0.00,12.50,825.00,'2022-10-04 07:57:47','',''),(6863,'1','275','1',1,'Retail Sale Id 6620',2303.68,0.00,0.00,3.13,206.58,'2022-10-04 08:05:13','',''),(6864,'1','275','1',1,'Retail Sale Id 6621',2001.92,0.00,0.00,2.72,179.52,'2022-10-04 08:06:13','',''),(6865,'1','275','1',1,'Retail Sale Id 6622',2303.68,0.00,0.00,3.13,206.58,'2022-10-04 08:11:49','',''),(6866,'1','275','1',1,'Retail Sale Id 6623',51520.00,0.00,0.00,70.00,4620.00,'2022-10-04 08:16:03','',''),(6867,'1','275','1',1,'Retail Sale Id 6624',18400.00,0.00,0.00,25.00,1650.00,'2022-10-04 08:19:10','',''),(6868,'1','275','1',1,'Retail Sale Id 6625',29999.36,0.00,0.00,40.76,2690.16,'2022-10-04 08:24:36','',''),(6869,'1','275','1',1,'Retail Sale Id 6626',9200.00,0.00,0.00,12.50,825.00,'2022-10-04 08:29:23','',''),(6870,'1','275','1',1,'Retail Sale Id 6627',1000.96,0.00,0.00,1.36,89.76,'2022-10-04 08:50:41','',''),(6871,'1','275','1',1,'Retail Sale Id 6628',4496.96,0.00,0.00,6.11,403.26,'2022-10-04 08:51:32','',''),(6872,'1','275','1',1,'Retail Sale Id 6629',1000.96,0.00,0.00,1.36,89.76,'2022-10-04 08:54:01','',''),(6873,'1','275','1',1,'Retail Sale Id 6630',3002.88,0.00,0.00,4.08,269.28,'2022-10-04 08:56:28','',''),(6874,'1','275','1',1,'Retail Sale Id 6631',1501.44,0.00,0.00,2.04,134.64,'2022-10-04 09:01:20','',''),(6875,'1','275','1',1,'Retail Sale Id 6632',4496.96,0.00,0.00,6.11,403.26,'2022-10-04 09:08:40','',''),(6876,'1','275','1',1,'Retail Sale Id 6633',2303.68,0.00,0.00,3.13,206.58,'2022-10-04 09:12:27','',''),(6877,'1','275','1',1,'Retail Sale Id 6634',1501.44,0.00,0.00,2.04,134.64,'2022-10-04 09:26:08','',''),(6878,'1','275','1',1,'Retail Sale Id 6635',4496.96,0.00,0.00,6.11,403.26,'2022-10-04 09:29:21','',''),(6879,'1','275','1',1,'Retail Sale Id 6636',3002.88,0.00,0.00,4.08,269.28,'2022-10-04 09:47:49','',''),(6880,'1','275','1',1,'Retail Sale Id 6637',4496.96,0.00,0.00,6.11,403.26,'2022-10-04 09:48:44','',''),(6881,'1','275','1',1,'Retail Sale Id 6638',6999.36,0.00,0.00,9.51,627.66,'2022-10-04 09:53:37','',''),(6882,'1','275','1',1,'Retail Sale Id 6638',8000.32,0.00,0.00,10.87,717.42,'2022-10-04 09:53:37','',''),(6883,'1','275','1',1,'Retail Sale Id 6639',2944.00,0.00,0.00,4.00,264.00,'2022-10-04 10:03:00','',''),(6884,'1','275','1',1,'Retail Sale Id 6640',9200.00,0.00,0.00,12.50,825.00,'2022-10-04 10:12:03','',''),(6885,'1','275','1',1,'Retail Sale Id 6641',8000.32,0.00,0.00,10.87,717.42,'2022-10-04 10:16:34','',''),(6886,'1','275','1',1,'Retail Sale Id 6641',8000.32,0.00,0.00,10.87,717.42,'2022-10-04 10:16:34','',''),(6887,'1','275','1',1,'Retail Sale Id 6642',9200.00,0.00,0.00,12.50,825.00,'2022-10-04 10:19:15','',''),(6888,'1','275','1',1,'Retail Sale Id 6643',8464.00,0.00,0.00,11.50,759.00,'2022-10-04 10:24:00','',''),(6889,'1','275','1',1,'Retail Sale Id 6644',1501.44,0.00,0.00,2.04,134.64,'2022-10-04 10:34:29','',''),(6890,'1','275','1',1,'Retail Sale Id 6645',9200.00,0.00,0.00,12.50,825.00,'2022-10-04 11:01:26','',''),(6891,'1','275','1',1,'Retail Sale Id 6646',4452.80,0.00,0.00,6.05,399.30,'2022-10-04 11:08:17','',''),(6892,'1','275','1',1,'Retail Sale Id 6647',9200.00,0.00,0.00,12.50,825.00,'2022-10-04 11:21:46','',''),(6893,'1','275','1',1,'Retail Sale Id 6648',9200.00,0.00,0.00,12.50,825.00,'2022-10-04 11:26:11','',''),(6894,'1','275','1',1,'Retail Sale Id 6650',1000.96,0.00,0.00,1.36,89.76,'2022-10-04 11:32:58','',''),(6895,'1','275','1',1,'Retail Sale Id 6650',1000.96,0.00,0.00,1.36,89.76,'2022-10-04 11:32:58','',''),(6896,'1','275','1',1,'Retail Sale Id 6651',7396.80,0.00,0.00,10.05,663.30,'2022-10-04 11:49:00','',''),(6897,'1','275','1',1,'Retail Sale Id 6652',2208.00,0.00,0.00,3.00,198.00,'2022-10-04 11:52:08','',''),(6898,'1','275','1',1,'Retail Sale Id 6653',36800.00,0.00,0.00,50.00,3300.00,'2022-10-04 11:56:59','',''),(6899,'1','275','1',1,'Retail Sale Id 6654',2252.16,0.00,0.00,3.06,201.96,'2022-10-04 12:01:58','',''),(6900,'1','275','1',1,'Retail Sale Id 6654',2252.16,0.00,0.00,3.06,201.96,'2022-10-04 12:01:58','',''),(6901,'1','275','1',1,'Retail Sale Id 6655',18400.00,0.00,0.00,25.00,1650.00,'2022-10-04 12:26:46','',''),(6902,'1','275','1',1,'Retail Sale Id 6656',36800.00,0.00,0.00,50.00,3300.00,'2022-10-04 12:43:01','',''),(6903,'1','275','1',1,'Retail Sale Id 6657',9200.00,0.00,0.00,12.50,825.00,'2022-10-04 12:46:48','',''),(6904,'1','275','1',1,'Retail Sale Id 6658',4496.96,0.00,0.00,6.11,403.26,'2022-10-04 13:00:27','',''),(6905,'1','275','1',1,'Retail Sale Id 6659',4496.96,0.00,0.00,6.11,403.26,'2022-10-04 13:26:34','',''),(6906,'1','275','1',1,'Retail Sale Id 6660',802.24,0.00,0.00,1.09,71.94,'2022-10-04 13:35:00','',''),(6907,'1','275','1',1,'Retail Sale Id 6661',9200.00,0.00,0.00,12.50,825.00,'2022-10-04 13:47:22','',''),(6908,'1','275','1',1,'Retail Sale Id 6662',4997.44,0.00,0.00,6.79,448.14,'2022-10-04 13:48:14','',''),(6909,'1','275','1',1,'Retail Sale Id 6663',3002.88,0.00,0.00,4.08,269.28,'2022-10-04 13:54:07','',''),(6910,'1','275','1',1,'Retail Sale Id 6664',2303.68,0.00,0.00,3.13,206.58,'2022-10-04 14:03:51','',''),(6911,'1','275','1',1,'Retail Sale Id 6665',2303.68,0.00,0.00,3.13,206.58,'2022-10-04 14:12:16','',''),(6912,'1','275','1',1,'Retail Sale Id 6666',2303.68,0.00,0.00,3.13,206.58,'2022-10-04 14:17:53','',''),(6913,'1','275','1',1,'Retail Sale Id 6667',2303.68,0.00,0.00,3.13,206.58,'2022-10-04 14:22:53','',''),(6914,'1','275','1',1,'Retail Sale Id 6668',83999.68,0.00,0.00,114.13,7532.58,'2022-10-04 14:27:24','',''),(6915,'1','275','1',1,'Retail Sale Id 6669',9200.00,0.00,0.00,12.50,825.00,'2022-10-04 14:28:38','',''),(6916,'1','275','1',1,'Retail Sale Id 6670',36800.00,0.00,0.00,50.00,3300.00,'2022-10-04 14:29:42','',''),(6917,'1','275','1',1,'Retail Sale Id 6671',8000.32,0.00,0.00,10.87,717.42,'2022-10-04 14:39:13','',''),(6918,'1','275','1',1,'Retail Sale Id 6672',2303.68,0.00,0.00,3.13,206.58,'2022-10-04 14:40:17','',''),(6919,'1','275','1',1,'Retail Sale Id 6673',9200.00,0.00,0.00,12.50,825.00,'2022-10-04 14:53:54','',''),(6920,'1','275','1',1,'Retail Sale Id 6674',9200.00,0.00,0.00,12.50,825.00,'2022-10-04 15:02:03','',''),(6921,'1','275','1',1,'Retail Sale Id 6675',1766.40,0.00,0.00,2.40,158.40,'2022-10-04 15:10:31','',''),(6922,'1','275','1',1,'Retail Sale Id 6675',8832.00,0.00,0.00,12.00,792.00,'2022-10-04 15:10:31','',''),(6923,'1','275','1',1,'Retail Sale Id 6676',9200.00,0.00,0.00,12.50,825.00,'2022-10-04 15:13:15','',''),(6924,'1','275','1',1,'Retail Sale Id 6677',1501.44,0.00,0.00,2.04,134.64,'2022-10-04 15:21:34','',''),(6925,'1','275','1',1,'Retail Sale Id 6678',18400.00,0.00,0.00,25.00,1650.00,'2022-10-04 15:23:40','',''),(6926,'1','275','1',1,'Retail Sale Id 6679',9200.00,0.00,0.00,12.50,825.00,'2022-10-04 15:28:10','',''),(6927,'1','275','1',1,'Retail Sale Id 6679',73600.00,0.00,0.00,100.00,6600.00,'2022-10-04 15:28:10','',''),(6928,'1','275','1',1,'Return of Retail Sale Id 6668',0.00,83999.68,114.13,0.00,-7532.58,'2022-10-04 15:32:12','',''),(6929,'1','275','1',1,'Retail Sale Id 6680',79502.72,0.00,0.00,108.02,7129.32,'2022-10-04 15:32:54','',''),(6930,'1','275','1',1,'Retail Sale Id 6681',3996.48,0.00,0.00,5.43,358.38,'2022-10-04 15:41:09','',''),(6931,'1','275','1',1,'Retail Sale Id 6682',4416.00,0.00,0.00,6.00,396.00,'2022-10-04 15:42:31','',''),(6932,'1','275','1',1,'Retail Sale Id 6683',2303.68,0.00,0.00,3.13,206.58,'2022-10-04 15:58:13','',''),(6933,'1','275','1',1,'Retail Sale Id 6684',3702.08,0.00,0.00,5.03,331.98,'2022-10-04 16:13:37','',''),(6934,'1','275','1',1,'Retail Sale Id 6685',2303.68,0.00,0.00,3.13,206.58,'2022-10-04 16:14:20','',''),(6935,'1','275','1',1,'Retail Sale Id 6686',3002.88,0.00,0.00,4.08,269.28,'2022-10-04 16:17:43','',''),(6936,'1','275','1',1,'Retail Sale Id 6687',1751.68,0.00,0.00,2.38,157.08,'2022-10-04 16:21:10','',''),(6937,'1','275','1',1,'Retail Sale Id 6688',8846.72,0.00,0.00,12.02,793.32,'2022-10-04 16:23:44','',''),(6938,'1','275','1',1,'Return of Retail Sale Id 6688',0.00,8846.72,12.02,0.00,-793.32,'2022-10-04 16:24:55','',''),(6939,'1','275','1',1,'Retail Sale Id 6689',8500.80,0.00,0.00,11.55,762.30,'2022-10-04 16:25:59','',''),(6940,'1','275','1',1,'Retail Sale Id 6690',11040.00,0.00,0.00,15.00,990.00,'2022-10-04 16:30:10','',''),(6941,'1','275','1',1,'Retail Sale Id 6691',9200.00,0.00,0.00,12.50,825.00,'2022-10-04 16:32:56','',''),(6942,'1','275','1',1,'Retail Sale Id 6692',3002.88,0.00,0.00,4.08,269.28,'2022-10-04 16:33:43','',''),(6943,'1','275','1',1,'Retail Sale Id 6693',4496.96,0.00,0.00,6.11,403.26,'2022-10-04 16:38:12','',''),(6944,'1','275','1',1,'Retail Sale Id 6694',9200.00,0.00,0.00,12.50,825.00,'2022-10-04 16:40:26','',''),(6945,'1','275','1',1,'Retail Sale Id 6695',1000.96,0.00,0.00,1.36,89.76,'2022-10-04 16:44:50','',''),(6946,'1','275','1',1,'Retail Sale Id 6696',9200.00,0.00,0.00,12.50,825.00,'2022-10-04 16:49:28','',''),(6947,'1','275','1',1,'Retail Sale Id 6697',2303.68,0.00,0.00,3.13,206.58,'2022-10-04 16:53:44','',''),(6948,'1','275','1',1,'Retail Sale Id 6698',4496.96,0.00,0.00,6.11,403.26,'2022-10-04 16:56:17','',''),(6949,'1','275','1',1,'Retail Sale Id 6699',3503.36,0.00,0.00,4.76,314.16,'2022-10-04 17:00:46','',''),(6950,'1','275','1',1,'Retail Sale Id 6700',9200.00,0.00,0.00,12.50,825.00,'2022-10-04 17:03:27','',''),(6951,'1','275','1',1,'Retail Sale Id 6701',2001.92,0.00,0.00,2.72,179.52,'2022-10-04 17:17:20','',''),(6952,'1','275','1',1,'Retail Sale Id 6702',4416.00,0.00,0.00,6.00,396.00,'2022-10-04 17:19:18','',''),(6953,'1','275','1',1,'Retail Sale Id 6703',2001.92,0.00,0.00,2.72,179.52,'2022-10-04 17:20:52','',''),(6954,'1','275','1',1,'Retail Sale Id 6704',4496.96,0.00,0.00,6.11,403.26,'2022-10-04 17:37:53','',''),(6955,'1','275','1',1,'Retail Sale Id 6705',7360.00,0.00,0.00,10.00,660.00,'2022-10-04 17:45:45','',''),(6956,'1','275','1',1,'Retail Sale Id 6706',9200.00,0.00,0.00,12.50,825.00,'2022-10-04 17:49:03','',''),(6957,'1','275','1',1,'Retail Sale Id 6707',9200.00,0.00,0.00,12.50,825.00,'2022-10-04 17:50:05','',''),(6958,'1','275','1',1,'Retail Sale Id 6709',2208.00,0.00,0.00,3.00,198.00,'2022-10-04 18:00:33','',''),(6959,'1','275','1',1,'Retail Sale Id 6710',3503.36,0.00,0.00,4.76,314.16,'2022-10-04 18:12:19','',''),(6960,'1','275','1',1,'Retail Sale Id 6711',2303.68,0.00,0.00,3.13,206.58,'2022-10-04 18:23:52','',''),(6961,'1','275','1',1,'Retail Sale Id 6712',4416.00,0.00,0.00,6.00,396.00,'2022-10-04 18:37:01','',''),(6962,'1','275','1',1,'Retail Sale Id 6713',897.92,0.00,0.00,1.22,80.52,'2022-10-04 18:39:45','',''),(6963,'1','275','1',1,'Retail Sale Id 6714',4997.44,0.00,0.00,6.79,448.14,'2022-10-04 18:42:20','',''),(6964,'1','275','1',1,'Retail Sale Id 6715',3503.36,0.00,0.00,4.76,314.16,'2022-10-04 18:44:14','',''),(6965,'1','275','1',1,'Retail Sale Id 6716',9200.00,0.00,0.00,12.50,825.00,'2022-10-04 18:52:41','',''),(6966,'1','275','1',1,'Retail Sale Id 6717',18400.00,0.00,0.00,25.00,1650.00,'2022-10-04 18:56:17','',''),(6967,'1','275','1',1,'Retail Sale Id 6718',4040.64,0.00,0.00,5.49,362.34,'2022-10-04 19:10:50','',''),(6968,'1','275','1',1,'Retail Sale Id 6719',3805.12,0.00,0.00,5.17,341.22,'2022-10-04 19:16:43','',''),(6969,'1','275','1',1,'Retail Sale Id 6720',3702.08,0.00,0.00,5.03,331.98,'2022-10-05 07:19:55','',''),(6970,'1','275','1',1,'Retail Sale Id 6721',1000.96,0.00,0.00,1.36,89.76,'2022-10-05 07:21:03','',''),(6971,'1','275','1',1,'Retail Sale Id 6722',1000.96,0.00,0.00,1.36,89.76,'2022-10-05 07:48:36','',''),(6972,'1','275','1',1,'Retail Sale Id 6723',4997.44,0.00,0.00,6.79,448.14,'2022-10-05 07:51:59','',''),(6973,'1','275','1',1,'Retail Sale Id 6724',9200.00,0.00,0.00,12.50,825.00,'2022-10-05 07:53:18','',''),(6974,'1','275','1',1,'Retail Sale Id 6725',2303.68,0.00,0.00,3.13,206.58,'2022-10-05 07:59:49','',''),(6975,'1','275','1',1,'Retail Sale Id 6726',1000.96,0.00,0.00,1.36,89.76,'2022-10-05 08:04:54','',''),(6976,'1','275','1',1,'Retail Sale Id 6727',9899.20,0.00,0.00,13.45,887.70,'2022-10-05 08:16:58','',''),(6977,'1','275','1',1,'Return of Retail Sale Id 6727',0.00,9899.20,13.45,0.00,-887.70,'2022-10-05 08:17:26','',''),(6978,'1','275','1',1,'Retail Sale Id 6728',6999.36,0.00,0.00,9.51,627.66,'2022-10-05 08:18:28','',''),(6979,'1','275','1',1,'Retail Sale Id 6729',3002.88,0.00,0.00,4.08,269.28,'2022-10-05 08:25:18','',''),(6980,'1','275','1',1,'Retail Sale Id 6729',9200.00,0.00,0.00,12.50,825.00,'2022-10-05 08:25:18','',''),(6981,'1','275','1',1,'Retail Sale Id 6730',3680.00,0.00,0.00,5.00,330.00,'2022-10-05 08:31:34','',''),(6982,'1','275','1',1,'Retail Sale Id 6731',9200.00,0.00,0.00,12.50,825.00,'2022-10-05 08:33:35','',''),(6983,'1','275','1',1,'Retail Sale Id 6732',9200.00,0.00,0.00,12.50,825.00,'2022-10-05 08:37:07','',''),(6984,'1','275','1',1,'Retail Sale Id 6733',1000.96,0.00,0.00,1.36,89.76,'2022-10-05 08:50:52','',''),(6985,'1','275','1',1,'Retail Sale Id 6734',9200.00,0.00,0.00,12.50,825.00,'2022-10-05 08:55:57','',''),(6986,'1','275','1',1,'Retail Sale Id 6735',5998.40,0.00,0.00,8.15,537.90,'2022-10-05 09:10:14','',''),(6987,'1','275','1',1,'Retail Sale Id 6735',6999.36,0.00,0.00,9.51,627.66,'2022-10-05 09:10:14','',''),(6988,'1','275','1',1,'Return of Retail Sale Id 6735',0.00,5998.40,8.15,0.00,-537.90,'2022-10-05 09:10:35','',''),(6989,'1','275','1',1,'Return of Retail Sale Id 6735',0.00,6999.36,9.51,0.00,-627.66,'2022-10-05 09:10:35','',''),(6990,'1','275','1',1,'Retail Sale Id 6736',1501.44,0.00,0.00,2.04,134.64,'2022-10-05 09:40:19','',''),(6991,'1','275','1',1,'Retail Sale Id 6737',3702.08,0.00,0.00,5.03,331.98,'2022-10-05 09:53:02','',''),(6992,'1','275','1',1,'Retail Sale Id 6738',2303.68,0.00,0.00,3.13,206.58,'2022-10-05 10:06:27','',''),(6993,'1','275','1',1,'Retail Sale Id 6739',14720.00,0.00,0.00,20.00,1320.00,'2022-10-05 10:07:43','',''),(6994,'1','275','1',1,'Retail Sale Id 6740',9200.00,0.00,0.00,12.50,825.00,'2022-10-05 11:06:11','',''),(6995,'1','275','1',1,'Retail Sale Id 6741',1501.44,0.00,0.00,2.04,134.64,'2022-10-05 11:15:47','',''),(6996,'1','275','1',1,'Retail Sale Id 6742',2001.92,0.00,0.00,2.72,179.52,'2022-10-05 11:21:54','',''),(6997,'1','275','1',1,'Retail Sale Id 6743',9200.00,0.00,0.00,12.50,825.00,'2022-10-05 11:24:44','',''),(6998,'1','275','1',1,'Retail Sale Id 6743',9200.00,0.00,0.00,12.50,825.00,'2022-10-05 11:24:44','',''),(6999,'1','275','1',1,'Retail Sale Id 6744',9200.00,0.00,0.00,12.50,825.00,'2022-10-05 11:27:49','',''),(7000,'1','275','1',1,'Retail Sale Id 6745',9200.00,0.00,0.00,12.50,825.00,'2022-10-05 11:29:40','',''),(7001,'1','275','1',1,'Retail Sale Id 6746',2252.16,0.00,0.00,3.06,201.96,'2022-10-05 11:35:39','',''),(7002,'1','275','1',1,'Retail Sale Id 6747',11040.00,0.00,0.00,15.00,990.00,'2022-10-05 11:42:09','',''),(7003,'1','275','1',1,'Retail Sale Id 6748',18400.00,0.00,0.00,25.00,1650.00,'2022-10-05 11:47:24','',''),(7004,'1','275','1',1,'Retail Sale Id 6749',1000.96,0.00,0.00,1.36,89.76,'2022-10-05 11:48:14','',''),(7005,'1','275','1',1,'Retail Sale Id 6750',2001.92,0.00,0.00,2.72,179.52,'2022-10-05 11:53:15','',''),(7006,'1','275','1',1,'Retail Sale Id 6751',18400.00,0.00,0.00,25.00,1650.00,'2022-10-05 12:03:35','',''),(7007,'1','275','1',1,'Retail Sale Id 6752',3002.88,0.00,0.00,4.08,269.28,'2022-10-05 12:06:40','',''),(7008,'1','275','1',1,'Retail Sale Id 6753',1000.96,0.00,0.00,1.36,89.76,'2022-10-05 12:13:06','',''),(7009,'1','275','1',1,'Retail Sale Id 6754',1501.44,0.00,0.00,2.04,134.64,'2022-10-05 12:16:02','',''),(7010,'1','275','1',1,'Retail Sale Id 6755',18400.00,0.00,0.00,25.00,1650.00,'2022-10-05 12:24:00','',''),(7011,'1','275','1',1,'Retail Sale Id 6756',3680.00,0.00,0.00,5.00,330.00,'2022-10-05 12:26:05','',''),(7012,'1','275','1',1,'Retail Sale Id 6757',2001.92,0.00,0.00,2.72,179.52,'2022-10-05 12:34:03','',''),(7013,'1','275','1',1,'Retail Sale Id 6758',1501.44,0.00,0.00,2.04,134.64,'2022-10-05 12:50:58','',''),(7014,'1','275','1',1,'Retail Sale Id 6759',2208.00,0.00,0.00,3.00,198.00,'2022-10-05 12:58:42','',''),(7015,'1','275','1',1,'Retail Sale Id 6759',9200.00,0.00,0.00,12.50,825.00,'2022-10-05 12:58:42','',''),(7016,'1','275','1',1,'Retail Sale Id 6760',4496.96,0.00,0.00,6.11,403.26,'2022-10-05 13:45:31','',''),(7017,'1','275','1',1,'Retail Sale Id 6761',9200.00,0.00,0.00,12.50,825.00,'2022-10-05 14:11:20','',''),(7018,'1','275','1',1,'Retail Sale Id 6762',1501.44,0.00,0.00,2.04,134.64,'2022-10-05 14:12:05','',''),(7019,'1','275','1',1,'Retail Sale Id 6763',9200.00,0.00,0.00,12.50,825.00,'2022-10-05 14:12:48','',''),(7020,'1','275','1',1,'Retail Sale Id 6764',80224.00,0.00,0.00,109.00,7194.00,'2022-10-05 14:16:01','',''),(7021,'1','275','1',1,'Return of Retail Sale Id 6764',0.00,80224.00,109.00,0.00,-7194.00,'2022-10-05 14:29:51','',''),(7022,'1','275','1',1,'Retail Sale Id 6765',43424.00,0.00,0.00,59.00,3894.00,'2022-10-05 14:30:32','',''),(7023,'1','275','1',1,'Retail Sale Id 6766',9200.00,0.00,0.00,12.50,825.00,'2022-10-05 14:35:24','',''),(7024,'1','275','1',1,'Retail Sale Id 6767',9200.00,0.00,0.00,12.50,825.00,'2022-10-05 14:43:24','',''),(7025,'1','275','1',1,'Retail Sale Id 6768',4496.96,0.00,0.00,6.11,403.26,'2022-10-05 14:49:02','',''),(7026,'1','275','1',1,'Retail Sale Id 6769',4997.44,0.00,0.00,6.79,448.14,'2022-10-05 14:52:33','',''),(7027,'1','275','1',1,'Retail Sale Id 6770',8832.00,0.00,0.00,12.00,792.00,'2022-10-05 15:07:38','',''),(7028,'1','275','1',1,'Retail Sale Id 6771',9200.00,0.00,0.00,12.50,825.00,'2022-10-05 15:37:13','',''),(7029,'1','275','1',1,'Retail Sale Id 6772',2796.80,0.00,0.00,3.80,250.80,'2022-10-05 15:47:13','',''),(7030,'1','275','1',1,'Retail Sale Id 6773',2303.68,0.00,0.00,3.13,206.58,'2022-10-05 15:49:25','',''),(7031,'1','275','1',1,'Retail Sale Id 6774',2303.68,0.00,0.00,3.13,206.58,'2022-10-05 15:55:27','',''),(7032,'1','275','1',1,'Retail Sale Id 6775',8500.80,0.00,0.00,11.55,762.30,'2022-10-05 15:57:24','',''),(7033,'1','275','1',1,'Retail Sale Id 6776',7360.00,0.00,0.00,10.00,660.00,'2022-10-05 15:59:29','',''),(7034,'1','275','1',1,'Retail Sale Id 6777',4496.96,0.00,0.00,6.11,403.26,'2022-10-05 16:06:16','',''),(7035,'1','275','1',1,'Retail Sale Id 6778',2001.92,0.00,0.00,2.72,179.52,'2022-10-05 16:16:55','',''),(7036,'1','275','1',1,'Retail Sale Id 6779',18400.00,0.00,0.00,25.00,1650.00,'2022-10-05 16:21:03','',''),(7037,'1','275','1',1,'Retail Sale Id 6780',9200.00,0.00,0.00,12.50,825.00,'2022-10-05 16:25:59','',''),(7038,'1','275','1',1,'Retail Sale Id 6781',16928.00,0.00,0.00,23.00,1518.00,'2022-10-05 16:34:46','',''),(7039,'1','275','1',1,'Retail Sale Id 6782',3680.00,0.00,0.00,5.00,330.00,'2022-10-05 16:38:02','',''),(7040,'1','275','1',1,'Retail Sale Id 6783',8898.24,0.00,0.00,12.09,797.94,'2022-10-05 16:44:42','',''),(7041,'1','275','1',1,'Retail Sale Id 6784',2303.68,0.00,0.00,3.13,206.58,'2022-10-05 16:45:34','',''),(7042,'1','275','1',1,'Retail Sale Id 6785',3996.48,0.00,0.00,5.43,358.38,'2022-10-05 16:46:20','',''),(7043,'1','275','1',1,'Retail Sale Id 6786',4496.96,0.00,0.00,6.11,403.26,'2022-10-05 16:47:10','',''),(7044,'1','275','1',1,'Retail Sale Id 6787',2303.68,0.00,0.00,3.13,206.58,'2022-10-05 16:54:46','',''),(7045,'1','275','1',1,'Retail Sale Id 6788',3002.88,0.00,0.00,4.08,269.28,'2022-10-05 16:58:49','',''),(7046,'1','275','1',1,'Retail Sale Id 6789',8898.24,0.00,0.00,12.09,797.94,'2022-10-05 17:00:25','',''),(7047,'1','275','1',1,'Retail Sale Id 6790',4496.96,0.00,0.00,6.11,403.26,'2022-10-05 17:01:45','',''),(7048,'1','275','1',1,'Retail Sale Id 6791',8832.00,0.00,0.00,12.00,792.00,'2022-10-05 17:02:28','',''),(7049,'1','275','1',1,'Retail Sale Id 6792',9200.00,0.00,0.00,12.50,825.00,'2022-10-05 17:07:59','',''),(7050,'1','275','1',1,'Retail Sale Id 6793',1000.96,0.00,0.00,1.36,89.76,'2022-10-05 17:14:51','',''),(7051,'1','275','1',1,'Retail Sale Id 6794',34592.00,0.00,0.00,47.00,3102.00,'2022-10-05 17:16:22','',''),(7052,'1','275','1',1,'Retail Sale Id 6795',4600.00,0.00,0.00,6.25,412.50,'2022-10-05 17:17:27','',''),(7053,'1','275','1',1,'Retail Sale Id 6796',1501.44,0.00,0.00,2.04,134.64,'2022-10-05 17:18:58','',''),(7054,'1','275','1',1,'Retail Sale Id 6797',2303.68,0.00,0.00,3.13,206.58,'2022-10-05 17:26:14','',''),(7055,'1','275','1',1,'Retail Sale Id 6798',1501.44,0.00,0.00,2.04,134.64,'2022-10-05 17:28:22','',''),(7056,'1','275','1',1,'Retail Sale Id 6799',14999.68,0.00,0.00,20.38,1345.08,'2022-10-05 17:38:15','',''),(7057,'1','275','1',1,'Retail Sale Id 6800',3002.88,0.00,0.00,4.08,269.28,'2022-10-05 17:46:46','',''),(7058,'1','275','1',1,'Retail Sale Id 6801',9200.00,0.00,0.00,12.50,825.00,'2022-10-05 17:50:04','',''),(7059,'1','275','1',1,'Retail Sale Id 6802',27600.00,0.00,0.00,37.50,2475.00,'2022-10-05 17:58:20','',''),(7060,'1','275','1',1,'Retail Sale Id 6803',9200.00,0.00,0.00,12.50,825.00,'2022-10-05 18:02:49','',''),(7061,'1','275','1',1,'Retail Sale Id 6804',1000.96,0.00,0.00,1.36,89.76,'2022-10-05 18:12:16','',''),(7062,'1','275','1',1,'Retail Sale Id 6805',1501.44,0.00,0.00,2.04,134.64,'2022-10-05 18:17:25','',''),(7063,'1','275','1',1,'Retail Sale Id 6806',1501.44,0.00,0.00,2.04,134.64,'2022-10-05 18:22:30','',''),(7064,'1','275','1',1,'Retail Sale Id 6807',2303.68,0.00,0.00,3.13,206.58,'2022-10-05 18:26:23','',''),(7065,'1','275','1',1,'Retail Sale Id 6808',2208.00,0.00,0.00,3.00,198.00,'2022-10-05 18:28:17','',''),(7066,'1','275','1',1,'Retail Sale Id 6809',14720.00,0.00,0.00,20.00,1320.00,'2022-10-05 18:49:09','',''),(7067,'1','275','1',1,'Retail Sale Id 6810',66777.28,0.00,0.00,90.73,5988.18,'2022-10-05 19:11:35','',''),(7068,'1','275','1',1,'Retail Sale Id 6811',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 07:07:48','',''),(7069,'1','275','1',1,'Retail Sale Id 6812',1501.44,0.00,0.00,2.04,134.64,'2022-10-06 07:08:46','',''),(7070,'1','275','1',1,'Retail Sale Id 6813',1501.44,0.00,0.00,2.04,134.64,'2022-10-06 07:30:06','',''),(7071,'1','275','1',1,'Retail Sale Id 6814',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 07:38:36','',''),(7072,'1','275','1',1,'Retail Sale Id 6815',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 07:50:25','',''),(7073,'1','275','1',1,'Retail Sale Id 6816',1000.96,0.00,0.00,1.36,89.76,'2022-10-06 07:57:21','',''),(7074,'1','275','1',1,'Retail Sale Id 6817',51520.00,0.00,0.00,70.00,4620.00,'2022-10-06 08:05:52','',''),(7075,'1','275','1',1,'Retail Sale Id 6818',1501.44,0.00,0.00,2.04,134.64,'2022-10-06 08:09:11','',''),(7076,'1','275','1',1,'Retail Sale Id 6819',4600.00,0.00,0.00,6.25,412.50,'2022-10-06 08:15:31','',''),(7077,'1','275','1',1,'Retail Sale Id 6819',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 08:15:31','',''),(7078,'1','275','1',1,'Retail Sale Id 6820',18400.00,0.00,0.00,25.00,1650.00,'2022-10-06 08:18:32','',''),(7079,'1','275','1',1,'Retail Sale Id 6821',18400.00,0.00,0.00,25.00,1650.00,'2022-10-06 08:23:49','',''),(7080,'1','275','1',1,'Retail Sale Id 6822',4496.96,0.00,0.00,6.11,403.26,'2022-10-06 08:26:04','',''),(7081,'1','275','1',1,'Retail Sale Id 6822',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 08:26:04','',''),(7082,'1','275','1',1,'Return of Retail Sale Id 6820',0.00,18400.00,25.00,0.00,-1650.00,'2022-10-06 08:32:16','',''),(7083,'1','275','1',1,'Retail Sale Id 6823',8464.00,0.00,0.00,11.50,759.00,'2022-10-06 08:33:07','',''),(7084,'1','275','1',1,'Retail Sale Id 6823',8464.00,0.00,0.00,11.50,759.00,'2022-10-06 08:33:07','',''),(7085,'1','275','1',1,'Retail Sale Id 6824',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 08:53:58','',''),(7086,'1','275','1',1,'Retail Sale Id 6825',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 08:56:32','',''),(7087,'1','275','1',1,'Retail Sale Id 6826',4416.00,0.00,0.00,6.00,396.00,'2022-10-06 08:57:37','',''),(7088,'1','275','1',1,'Retail Sale Id 6827',1501.44,0.00,0.00,2.04,134.64,'2022-10-06 09:00:36','',''),(7089,'1','275','1',1,'Retail Sale Id 6828',8898.24,0.00,0.00,12.09,797.94,'2022-10-06 09:16:24','',''),(7090,'1','275','1',1,'Retail Sale Id 6829',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 09:18:12','',''),(7091,'1','275','1',1,'Retail Sale Id 6830',4496.96,0.00,0.00,6.11,403.26,'2022-10-06 09:21:32','',''),(7092,'1','275','1',1,'Retail Sale Id 6831',36800.00,0.00,0.00,50.00,3300.00,'2022-10-06 09:40:58','',''),(7093,'1','275','1',1,'Retail Sale Id 6832',3002.88,0.00,0.00,4.08,269.28,'2022-10-06 09:51:57','',''),(7094,'1','275','1',1,'Retail Sale Id 6832',3996.48,0.00,0.00,5.43,358.38,'2022-10-06 09:51:57','',''),(7095,'1','275','1',1,'Retail Sale Id 6833',3002.88,0.00,0.00,4.08,269.28,'2022-10-06 09:52:47','',''),(7096,'1','275','1',1,'Retail Sale Id 6834',3996.48,0.00,0.00,5.43,358.38,'2022-10-06 09:53:21','',''),(7097,'1','275','1',1,'Retail Sale Id 6835',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 10:01:51','',''),(7098,'1','275','1',1,'Retail Sale Id 6836',17296.00,0.00,0.00,23.50,1551.00,'2022-10-06 10:07:19','',''),(7099,'1','275','1',1,'Retail Sale Id 6837',3002.88,0.00,0.00,4.08,269.28,'2022-10-06 10:19:37','',''),(7100,'1','275','1',1,'Retail Sale Id 6838',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 10:30:38','',''),(7101,'1','275','1',1,'Retail Sale Id 6839',2001.92,0.00,0.00,2.72,179.52,'2022-10-06 10:31:32','',''),(7102,'1','275','1',1,'Retail Sale Id 6840',1501.44,0.00,0.00,2.04,134.64,'2022-10-06 10:37:59','',''),(7103,'1','275','1',1,'Retail Sale Id 6841',3002.88,0.00,0.00,4.08,269.28,'2022-10-06 10:47:03','',''),(7104,'1','275','1',1,'Retail Sale Id 6842',2303.68,0.00,0.00,3.13,206.58,'2022-10-06 10:50:55','',''),(7105,'1','275','1',1,'Retail Sale Id 6843',18400.00,0.00,0.00,25.00,1650.00,'2022-10-06 10:55:13','',''),(7106,'1','275','1',1,'Retail Sale Id 6844',11776.00,0.00,0.00,16.00,1056.00,'2022-10-06 10:59:23','',''),(7107,'1','275','1',1,'Retail Sale Id 6845',3996.48,0.00,0.00,5.43,358.38,'2022-10-06 11:08:47','',''),(7108,'1','275','1',1,'Retail Sale Id 6846',2252.16,0.00,0.00,3.06,201.96,'2022-10-06 11:12:20','',''),(7109,'1','275','1',1,'Retail Sale Id 6847',3996.48,0.00,0.00,5.43,358.38,'2022-10-06 11:13:40','',''),(7110,'1','275','1',1,'Retail Sale Id 6848',4496.96,0.00,0.00,6.11,403.26,'2022-10-06 11:28:20','',''),(7111,'1','275','1',1,'Retail Sale Id 6849',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 11:37:56','',''),(7112,'1','275','1',1,'Retail Sale Id 6850',1000.96,0.00,0.00,1.36,89.76,'2022-10-06 11:44:44','',''),(7113,'1','275','1',1,'Retail Sale Id 6851',18400.00,0.00,0.00,25.00,1650.00,'2022-10-06 11:58:53','',''),(7114,'1','275','1',1,'Retail Sale Id 6852',2303.68,0.00,0.00,3.13,206.58,'2022-10-06 12:01:47','',''),(7115,'1','275','1',1,'Retail Sale Id 6853',4496.96,0.00,0.00,6.11,403.26,'2022-10-06 12:13:04','',''),(7116,'1','275','1',1,'Retail Sale Id 6853',4496.96,0.00,0.00,6.11,403.26,'2022-10-06 12:13:04','',''),(7117,'1','275','1',1,'Retail Sale Id 6854',1501.44,0.00,0.00,2.04,134.64,'2022-10-06 12:14:31','',''),(7118,'1','275','1',1,'Retail Sale Id 6855',2303.68,0.00,0.00,3.13,206.58,'2022-10-06 12:26:22','',''),(7119,'1','275','1',1,'Retail Sale Id 6856',3002.88,0.00,0.00,4.08,269.28,'2022-10-06 12:28:21','',''),(7120,'1','275','1',1,'Retail Sale Id 6857',4496.96,0.00,0.00,6.11,403.26,'2022-10-06 12:30:35','',''),(7121,'1','275','1',1,'Retail Sale Id 6858',4600.00,0.00,0.00,6.25,412.50,'2022-10-06 12:47:52','',''),(7122,'1','275','1',1,'Retail Sale Id 6859',2303.68,0.00,0.00,3.13,206.58,'2022-10-06 13:20:42','',''),(7123,'1','275','1',1,'Retail Sale Id 6860',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 13:38:43','',''),(7124,'1','275','1',1,'Retail Sale Id 6861',64400.00,0.00,0.00,87.50,5775.00,'2022-10-06 13:45:53','',''),(7125,'1','275','1',1,'Retail Sale Id 6862',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 13:48:35','',''),(7126,'1','275','1',1,'Retail Sale Id 6863',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 14:06:01','',''),(7127,'1','275','1',1,'Retail Sale Id 6864',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 14:11:44','',''),(7128,'1','275','1',1,'Retail Sale Id 6865',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 14:13:04','',''),(7129,'1','275','1',1,'Retail Sale Id 6866',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 14:27:06','',''),(7130,'1','275','1',1,'Retail Sale Id 6867',2001.92,0.00,0.00,2.72,179.52,'2022-10-06 14:28:08','',''),(7131,'1','275','1',1,'Retail Sale Id 6869',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 14:43:27','',''),(7132,'1','275','1',1,'Retail Sale Id 6870',92000.00,0.00,0.00,125.00,8250.00,'2022-10-06 14:48:48','',''),(7133,'1','275','1',1,'Retail Sale Id 6871',2001.92,0.00,0.00,2.72,179.52,'2022-10-06 14:50:28','',''),(7134,'1','275','1',1,'Retail Sale Id 6872',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 14:58:56','',''),(7135,'1','275','1',1,'Retail Sale Id 6873',2303.68,0.00,0.00,3.13,206.58,'2022-10-06 14:59:46','',''),(7136,'1','275','1',1,'Retail Sale Id 6874',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 15:04:33','',''),(7137,'1','275','1',1,'Retail Sale Id 6875',4416.00,0.00,0.00,6.00,396.00,'2022-10-06 15:08:44','',''),(7138,'1','275','1',1,'Retail Sale Id 6876',3996.48,0.00,0.00,5.43,358.38,'2022-10-06 15:15:53','',''),(7139,'1','275','1',1,'Retail Sale Id 6877',8500.80,0.00,0.00,11.55,762.30,'2022-10-06 15:27:19','',''),(7140,'1','275','1',1,'Retail Sale Id 6878',4600.00,0.00,0.00,6.25,412.50,'2022-10-06 15:31:14','',''),(7141,'1','275','1',1,'Retail Sale Id 6879',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 15:33:15','',''),(7142,'1','275','1',1,'Retail Sale Id 6880',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 15:34:29','',''),(7143,'1','275','1',1,'Retail Sale Id 6881',32384.00,0.00,0.00,44.00,2904.00,'2022-10-06 15:36:43','',''),(7144,'1','275','1',1,'Retail Sale Id 6882',18400.00,0.00,0.00,25.00,1650.00,'2022-10-06 15:46:03','',''),(7145,'1','275','1',1,'Retail Sale Id 6883',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 15:49:48','',''),(7146,'1','275','1',1,'Retail Sale Id 6884',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 16:00:14','',''),(7147,'1','275','1',1,'Retail Sale Id 6885',3996.48,0.00,0.00,5.43,358.38,'2022-10-06 16:04:21','',''),(7148,'1','275','1',1,'Retail Sale Id 6886',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 16:11:29','',''),(7149,'1','275','1',1,'Retail Sale Id 6887',3702.08,0.00,0.00,5.03,331.98,'2022-10-06 16:13:02','',''),(7150,'1','275','1',1,'Retail Sale Id 6888',1000.96,0.00,0.00,1.36,89.76,'2022-10-06 16:14:19','',''),(7151,'1','275','1',1,'Retail Sale Id 6889',2303.68,0.00,0.00,3.13,206.58,'2022-10-06 16:15:02','',''),(7152,'1','275','1',1,'Retail Sale Id 6890',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 16:29:09','',''),(7153,'1','275','1',1,'Retail Sale Id 6891',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 16:31:57','',''),(7154,'1','275','1',1,'Retail Sale Id 6892',1000.96,0.00,0.00,1.36,89.76,'2022-10-06 16:33:08','',''),(7155,'1','275','1',1,'Retail Sale Id 6893',2001.92,0.00,0.00,2.72,179.52,'2022-10-06 16:33:42','',''),(7156,'1','275','1',1,'Retail Sale Id 6894',1000.96,0.00,0.00,1.36,89.76,'2022-10-06 16:34:18','',''),(7157,'1','275','1',1,'Retail Sale Id 6895',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 16:34:57','',''),(7158,'1','275','1',1,'Retail Sale Id 6896',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 16:36:08','',''),(7159,'1','275','1',1,'Retail Sale Id 6897',2303.68,0.00,0.00,3.13,206.58,'2022-10-06 16:37:40','',''),(7160,'1','275','1',1,'Retail Sale Id 6898',2001.92,0.00,0.00,2.72,179.52,'2022-10-06 16:41:48','',''),(7161,'1','275','1',1,'Retail Sale Id 6899',3996.48,0.00,0.00,5.43,358.38,'2022-10-06 16:45:39','',''),(7162,'1','275','1',1,'Retail Sale Id 6900',34592.00,0.00,0.00,47.00,3102.00,'2022-10-06 16:55:47','',''),(7163,'1','275','1',1,'Retail Sale Id 6901',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 16:57:09','',''),(7164,'1','275','1',1,'Retail Sale Id 6902',4416.00,0.00,0.00,6.00,396.00,'2022-10-06 17:08:06','',''),(7165,'1','275','1',1,'Retail Sale Id 6903',3702.08,0.00,0.00,5.03,331.98,'2022-10-06 17:15:27','',''),(7166,'1','275','1',1,'Retail Sale Id 6904',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 17:19:49','',''),(7167,'1','275','1',1,'Retail Sale Id 6905',3002.88,0.00,0.00,4.08,269.28,'2022-10-06 17:30:26','',''),(7168,'1','275','1',1,'Retail Sale Id 6906',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 17:34:35','',''),(7169,'1','275','1',1,'Retail Sale Id 6907',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 17:35:28','',''),(7170,'1','275','1',1,'Retail Sale Id 6908',2001.92,0.00,0.00,2.72,179.52,'2022-10-06 17:43:13','',''),(7171,'1','275','1',1,'Retail Sale Id 6909',1000.96,0.00,0.00,1.36,89.76,'2022-10-06 17:44:02','',''),(7172,'1','275','1',1,'Retail Sale Id 6910',8103.36,0.00,0.00,11.01,726.66,'2022-10-06 17:48:08','',''),(7173,'1','275','1',1,'Retail Sale Id 6911',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 17:51:08','',''),(7174,'1','275','1',1,'Retail Sale Id 6912',2303.68,0.00,0.00,3.13,206.58,'2022-10-06 17:52:04','',''),(7175,'1','275','1',1,'Retail Sale Id 6913',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 17:54:32','',''),(7176,'1','275','1',1,'Retail Sale Id 6914',4997.44,0.00,0.00,6.79,448.14,'2022-10-06 17:55:27','',''),(7177,'1','275','1',1,'Retail Sale Id 6915',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 17:56:57','',''),(7178,'1','275','1',1,'Retail Sale Id 6916',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 17:59:55','',''),(7179,'1','275','1',1,'Retail Sale Id 6917',2001.92,0.00,0.00,2.72,179.52,'2022-10-06 18:03:27','',''),(7180,'1','275','1',1,'Retail Sale Id 6918',2303.68,0.00,0.00,3.13,206.58,'2022-10-06 18:07:57','',''),(7181,'1','275','1',1,'Retail Sale Id 6919',3702.08,0.00,0.00,5.03,331.98,'2022-10-06 18:25:44','',''),(7182,'1','275','1',1,'Retail Sale Id 6920',1346.88,0.00,0.00,1.83,120.78,'2022-10-06 18:28:04','',''),(7183,'1','275','1',1,'Retail Sale Id 6921',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 18:45:53','',''),(7184,'1','275','1',1,'Return of Retail Sale Id 6921',0.00,9200.00,12.50,0.00,-825.00,'2022-10-06 18:59:45','',''),(7185,'1','275','1',1,'Return of Retail Sale Id 6914',0.00,4997.44,6.79,0.00,-448.14,'2022-10-06 19:00:16','',''),(7186,'1','275','1',1,'Return of Retail Sale Id 6920',0.00,1346.88,1.83,0.00,-120.78,'2022-10-06 19:00:50','',''),(7187,'1','275','1',1,'Retail Sale Id 6922',1074.56,0.00,0.00,1.46,96.36,'2022-10-06 19:02:10','',''),(7188,'1','275','1',1,'Retail Sale Id 6923',2796.80,0.00,0.00,3.80,250.80,'2022-10-07 07:05:37','',''),(7189,'1','275','1',1,'Retail Sale Id 6924',3002.88,0.00,0.00,4.08,269.28,'2022-10-07 07:06:41','',''),(7190,'1','275','1',1,'Retail Sale Id 6925',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 07:22:37','',''),(7191,'1','275','1',1,'Retail Sale Id 6926',4496.96,0.00,0.00,6.11,403.26,'2022-10-07 07:30:32','',''),(7192,'1','275','1',1,'Retail Sale Id 6927',9001.28,0.00,0.00,12.23,807.18,'2022-10-07 07:35:48','',''),(7193,'1','275','1',1,'Retail Sale Id 6928',4416.00,0.00,0.00,6.00,396.00,'2022-10-07 08:14:08','',''),(7194,'1','275','1',1,'Retail Sale Id 6928',4416.00,0.00,0.00,6.00,396.00,'2022-10-07 08:14:08','',''),(7195,'1','275','1',1,'Retail Sale Id 6929',1501.44,0.00,0.00,2.04,134.64,'2022-10-07 08:15:59','',''),(7196,'1','275','1',1,'Retail Sale Id 6932',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 08:45:57','',''),(7197,'1','275','1',1,'Retail Sale Id 6933',14720.00,0.00,0.00,20.00,1320.00,'2022-10-07 08:48:00','',''),(7198,'1','275','1',1,'Retail Sale Id 6934',4600.00,0.00,0.00,6.25,412.50,'2022-10-07 08:52:51','',''),(7199,'1','275','1',1,'Retail Sale Id 6935',3002.88,0.00,0.00,4.08,269.28,'2022-10-07 09:04:37','',''),(7200,'1','275','1',1,'Retail Sale Id 6936',8000.32,0.00,0.00,10.87,717.42,'2022-10-07 09:14:36','',''),(7201,'1','275','1',1,'Retail Sale Id 6937',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 10:05:13','',''),(7202,'1','275','1',1,'Retail Sale Id 6938',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 10:12:47','',''),(7203,'1','275','1',1,'Retail Sale Id 6939',4496.96,0.00,0.00,6.11,403.26,'2022-10-07 10:13:28','',''),(7204,'1','275','1',1,'Retail Sale Id 6940',1501.44,0.00,0.00,2.04,134.64,'2022-10-07 10:14:07','',''),(7205,'1','275','1',1,'Retail Sale Id 6941',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 10:31:41','',''),(7206,'1','275','1',1,'Retail Sale Id 6941',18400.00,0.00,0.00,25.00,1650.00,'2022-10-07 10:31:41','',''),(7207,'1','275','1',1,'Retail Sale Id 6942',36800.00,0.00,0.00,50.00,3300.00,'2022-10-07 10:34:32','',''),(7208,'1','275','1',1,'Retail Sale Id 6943',2001.92,0.00,0.00,2.72,179.52,'2022-10-07 10:46:12','',''),(7209,'1','275','1',1,'Retail Sale Id 6944',9001.28,0.00,0.00,12.23,807.18,'2022-10-07 10:47:26','',''),(7210,'1','275','1',1,'Retail Sale Id 6945',36800.00,0.00,0.00,50.00,3300.00,'2022-10-07 10:57:06','',''),(7211,'1','275','1',1,'Retail Sale Id 6946',8000.32,0.00,0.00,10.87,717.42,'2022-10-07 10:59:15','',''),(7212,'1','275','1',1,'Retail Sale Id 6947',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 11:08:49','',''),(7213,'1','275','1',1,'Retail Sale Id 6948',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 11:16:37','',''),(7214,'1','275','1',1,'Retail Sale Id 6949',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 11:22:49','',''),(7215,'1','275','1',1,'Retail Sale Id 6950',4496.96,0.00,0.00,6.11,403.26,'2022-10-07 11:31:49','',''),(7216,'1','275','1',1,'Retail Sale Id 6951',4600.00,0.00,0.00,6.25,412.50,'2022-10-07 11:50:57','',''),(7217,'1','275','1',1,'Retail Sale Id 6952',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 12:01:51','',''),(7218,'1','275','1',1,'Retail Sale Id 6953',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 12:12:28','',''),(7219,'1','275','1',1,'Retail Sale Id 6954',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 12:19:55','',''),(7220,'1','275','1',1,'Retail Sale Id 6954',36800.00,0.00,0.00,50.00,3300.00,'2022-10-07 12:19:55','',''),(7221,'1','275','1',1,'Retail Sale Id 6955',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 12:22:05','',''),(7222,'1','275','1',1,'Retail Sale Id 6955',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 12:22:05','',''),(7223,'1','275','1',1,'Retail Sale Id 6956',4997.44,0.00,0.00,6.79,448.14,'2022-10-07 12:30:17','',''),(7224,'1','275','1',1,'Retail Sale Id 6957',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 12:32:54','',''),(7225,'1','275','1',1,'Retail Sale Id 6958',1000.96,0.00,0.00,1.36,89.76,'2022-10-07 12:33:38','',''),(7226,'1','275','1',1,'Retail Sale Id 6959',1000.96,0.00,0.00,1.36,89.76,'2022-10-07 12:36:40','',''),(7227,'1','275','1',1,'Retail Sale Id 6960',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 13:09:22','',''),(7228,'1','275','1',1,'Retail Sale Id 6961',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 13:14:19','',''),(7229,'1','275','1',1,'Retail Sale Id 6961',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 13:14:19','',''),(7230,'1','275','1',1,'Retail Sale Id 6962',3002.88,0.00,0.00,4.08,269.28,'2022-10-07 13:16:21','',''),(7231,'1','275','1',1,'Retail Sale Id 6963',1501.44,0.00,0.00,2.04,134.64,'2022-10-07 13:23:23','',''),(7232,'1','275','1',1,'Retail Sale Id 6964',3002.88,0.00,0.00,4.08,269.28,'2022-10-07 13:36:24','',''),(7233,'1','275','1',1,'Retail Sale Id 6965',4496.96,0.00,0.00,6.11,403.26,'2022-10-07 14:43:32','',''),(7234,'1','275','1',1,'Retail Sale Id 6966',4997.44,0.00,0.00,6.79,448.14,'2022-10-07 14:45:42','',''),(7235,'1','275','1',1,'Retail Sale Id 6967',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 14:46:39','',''),(7236,'1','275','1',1,'Retail Sale Id 6968',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 14:47:19','',''),(7237,'1','275','1',1,'Retail Sale Id 6969',2303.68,0.00,0.00,3.13,206.58,'2022-10-07 14:47:50','',''),(7238,'1','275','1',1,'Retail Sale Id 6970',2303.68,0.00,0.00,3.13,206.58,'2022-10-07 14:49:31','',''),(7239,'1','275','1',1,'Retail Sale Id 6971',3002.88,0.00,0.00,4.08,269.28,'2022-10-07 14:53:58','',''),(7240,'1','275','1',1,'Retail Sale Id 6972',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 14:56:51','',''),(7241,'1','275','1',1,'Retail Sale Id 6973',27600.00,0.00,0.00,37.50,2475.00,'2022-10-07 15:02:43','',''),(7242,'1','275','1',1,'Retail Sale Id 6974',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 15:12:12','',''),(7243,'1','275','1',1,'Retail Sale Id 6975',16560.00,0.00,0.00,22.50,1485.00,'2022-10-07 15:13:55','',''),(7244,'1','275','1',1,'Retail Sale Id 6976',1501.44,0.00,0.00,2.04,134.64,'2022-10-07 15:14:49','',''),(7245,'1','275','1',1,'Retail Sale Id 6977',18400.00,0.00,0.00,25.00,1650.00,'2022-10-07 15:54:36','',''),(7246,'1','275','1',1,'Retail Sale Id 6978',6999.36,0.00,0.00,9.51,627.66,'2022-10-07 15:55:13','',''),(7247,'1','275','1',1,'Retail Sale Id 6979',4997.44,0.00,0.00,6.79,448.14,'2022-10-07 15:56:08','',''),(7248,'1','275','1',1,'Retail Sale Id 6980',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 16:16:54','',''),(7249,'1','275','1',1,'Retail Sale Id 6981',15500.16,0.00,0.00,21.06,1389.96,'2022-10-07 17:08:00','',''),(7250,'1','275',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,19550.60,29.18,0.00,0.00,'2022-10-07 17:10:54','',''),(7251,'1','275',NULL,1,'Reception corrector for bridging 27',0.00,0.00,0.00,29.18,0.00,'2022-10-07 17:11:49','',''),(7252,'1','275','1',1,'Received from bridging 27',0.00,0.00,29.18,0.00,0.00,'2022-10-07 17:11:49','',''),(7253,'1','275','1',1,'Retail Sale Id 6982',21476.48,0.00,0.00,29.18,1925.88,'2022-10-07 17:12:38','',''),(7254,'1','275',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,335000.00,500.00,0.00,0.00,'2022-10-10 16:53:17','',''),(7255,'1','275',NULL,1,'Reception corrector for bridging 28',0.00,0.00,0.00,500.00,0.00,'2022-10-10 16:54:39','',''),(7256,'1','275','1',1,'Received from bridging 28',0.00,0.00,500.00,0.00,0.00,'2022-10-10 16:54:39','',''),(7257,'1','275','1',1,'Retail Sale Id 6983',3499.12,0.00,0.00,4.58,430.52,'2022-10-10 17:09:40','',''),(7258,'1','275','1',1,'Retail Sale Id 6984',2299.64,0.00,0.00,3.01,282.94,'2022-10-10 17:10:37','',''),(7259,'1','275','1',1,'Retail Sale Id 6985',1000.84,0.00,0.00,1.31,123.14,'2022-10-10 17:11:20','',''),(7260,'1','275','1',1,'Retail Sale Id 6986',3101.84,0.00,0.00,4.06,381.64,'2022-10-10 17:12:03','',''),(7261,'1','275','1',1,'Retail Sale Id 6987',5997.40,0.00,0.00,7.85,737.90,'2022-10-10 17:13:14','',''),(7262,'1','275','1',1,'Retail Sale Id 6988',9603.48,0.00,0.00,12.57,1181.58,'2022-10-10 17:14:23','',''),(7263,'1','275','1',1,'Retail Sale Id 6989',4003.36,0.00,0.00,5.24,492.56,'2022-10-10 17:37:06','',''),(7264,'1','275','1',1,'Retail Sale Id 6990',9550.00,0.00,0.00,12.50,1175.00,'2022-10-10 17:39:21','',''),(7265,'1','275','1',1,'Retail Sale Id 6991',2299.64,0.00,0.00,3.01,282.94,'2022-10-10 17:51:39','',''),(7266,'1','275','1',1,'Retail Sale Id 6992',3820.00,0.00,0.00,5.00,470.00,'2022-10-10 17:55:49','',''),(7267,'1','275','1',1,'Retail Sale Id 6993',1398.12,0.00,0.00,1.83,172.02,'2022-10-10 18:01:03','',''),(7268,'1','275','1',1,'Retail Sale Id 6994',3820.00,0.00,0.00,5.00,470.00,'2022-10-10 18:05:17','',''),(7269,'1','275','1',1,'Retail Sale Id 6995',9550.00,0.00,0.00,12.50,1175.00,'2022-10-10 18:10:50','',''),(7270,'1','275','1',1,'Retail Sale Id 6996',1298.80,0.00,0.00,1.70,159.80,'2022-10-10 18:11:14','',''),(7271,'1','275','1',1,'Retail Sale Id 6997',5401.48,0.00,0.00,7.07,664.58,'2022-10-10 18:13:01','',''),(7272,'1','275','1',1,'Retail Sale Id 6998',4202.00,0.00,0.00,5.50,517.00,'2022-10-10 18:14:38','',''),(7273,'1','275','1',1,'Retail Sale Id 6998',4599.28,0.00,0.00,6.02,565.88,'2022-10-10 18:14:38','',''),(7274,'1','275','1',1,'Retail Sale Id 6999',4599.28,0.00,0.00,6.02,565.88,'2022-10-10 18:15:31','',''),(7275,'1','275','1',1,'Retail Sale Id 7000',7999.08,0.00,0.00,10.47,984.18,'2022-10-10 18:17:24','',''),(7276,'1','275','1',1,'Retail Sale Id 7001',1398.12,0.00,0.00,1.83,172.02,'2022-10-10 18:20:10','',''),(7277,'1','275','1',1,'Retail Sale Id 7002',4599.28,0.00,0.00,6.02,565.88,'2022-10-10 18:21:30','',''),(7278,'1','275','1',1,'Retail Sale Id 7003',4996.56,0.00,0.00,6.54,614.76,'2022-10-10 18:24:47','',''),(7279,'1','275','1',1,'Retail Sale Id 7004',4996.56,0.00,0.00,6.54,614.76,'2022-10-10 18:32:35','',''),(7280,'1','275','1',1,'Retail Sale Id 7005',9550.00,0.00,0.00,12.50,1175.00,'2022-10-10 18:38:57','',''),(7281,'1','275','1',1,'Retail Sale Id 7006',4996.56,0.00,0.00,6.54,614.76,'2022-10-10 18:40:47','',''),(7282,'1','275','1',1,'Retail Sale Id 7007',15302.92,0.00,0.00,20.03,1882.82,'2022-10-10 18:47:20','',''),(7283,'1','275','1',1,'Retail Sale Id 7008',8151.88,0.00,0.00,10.67,1002.98,'2022-10-10 19:15:58','',''),(7284,'1','275','1',1,'Retail Sale Id 7009',1000.84,0.00,0.00,1.31,123.14,'2022-10-11 07:19:32','',''),(7285,'1','275','1',1,'Retail Sale Id 7010',18336.00,0.00,0.00,24.00,2256.00,'2022-10-11 07:37:11','',''),(7286,'1','275','1',1,'Retail Sale Id 7011',9550.00,0.00,0.00,12.50,1175.00,'2022-10-11 07:48:39','',''),(7287,'1','275','1',1,'Retail Sale Id 7012',2001.68,0.00,0.00,2.62,246.28,'2022-10-11 07:50:19','',''),(7288,'1','275','1',1,'Retail Sale Id 7013',9550.00,0.00,0.00,12.50,1175.00,'2022-10-11 07:51:38','',''),(7289,'1','275','1',1,'Retail Sale Id 7014',9550.00,0.00,0.00,12.50,1175.00,'2022-10-11 08:15:38','',''),(7290,'1','275','1',1,'Retail Sale Id 7015',9550.00,0.00,0.00,12.50,1175.00,'2022-10-11 08:17:59','',''),(7291,'1','275','1',1,'Retail Sale Id 7016',53480.00,0.00,0.00,70.00,6580.00,'2022-10-11 08:25:11','',''),(7292,'1','275','1',1,'Retail Sale Id 7017',3896.40,0.00,0.00,5.10,479.40,'2022-10-11 08:26:07','',''),(7293,'1','275','1',1,'Retail Sale Id 7018',2299.64,0.00,0.00,3.01,282.94,'2022-10-11 08:31:16','',''),(7294,'1','275','1',1,'Retail Sale Id 7019',1596.76,0.00,0.00,2.09,196.46,'2022-10-11 08:33:06','',''),(7295,'1','275','1',1,'Retail Sale Id 7020',3002.52,0.00,0.00,3.93,369.42,'2022-10-11 08:33:54','',''),(7296,'1','275','1',1,'Retail Sale Id 7021',3002.52,0.00,0.00,3.93,369.42,'2022-10-11 08:43:44','',''),(7297,'1','275','1',1,'Retail Sale Id 7022',6998.24,0.00,0.00,9.16,861.04,'2022-10-11 08:45:04','',''),(7298,'1','275','1',1,'Retail Sale Id 7023',6898.92,0.00,0.00,9.03,848.82,'2022-10-11 08:54:31','',''),(7299,'1','275','1',1,'Retail Sale Id 7024',19100.00,0.00,0.00,25.00,2350.00,'2022-10-11 08:59:30','',''),(7300,'1','275','1',1,'Retail Sale Id 7025',1497.44,0.00,0.00,1.96,184.24,'2022-10-11 09:02:48','',''),(7301,'1','275','1',1,'Retail Sale Id 7026',9550.00,0.00,0.00,12.50,1175.00,'2022-10-11 09:07:39','',''),(7302,'1','275','1',1,'Retail Sale Id 7027',3499.12,0.00,0.00,4.58,430.52,'2022-10-11 09:14:12','',''),(7303,'1','275','1',1,'Retail Sale Id 7028',9550.00,0.00,0.00,12.50,1175.00,'2022-10-11 10:00:40','',''),(7304,'1','275','1',1,'Retail Sale Id 7029',2299.64,0.00,0.00,3.01,282.94,'2022-10-11 10:11:28','',''),(7305,'1','275','1',1,'Retail Sale Id 7030',1497.44,0.00,0.00,1.96,184.24,'2022-10-11 10:26:00','',''),(7306,'1','275','1',1,'Retail Sale Id 7031',9550.00,0.00,0.00,12.50,1175.00,'2022-10-11 10:31:06','',''),(7307,'1','275','1',1,'Retail Sale Id 7032',2299.64,0.00,0.00,3.01,282.94,'2022-10-11 10:31:31','',''),(7308,'1','275','1',1,'Retail Sale Id 7033',2001.68,0.00,0.00,2.62,246.28,'2022-10-11 10:32:34','',''),(7309,'1','275','1',1,'Return of Retail Sale Id 7033',0.00,2001.68,2.62,0.00,-246.28,'2022-10-11 10:33:08','',''),(7310,'1','275','1',1,'Retail Sale Id 7034',2299.64,0.00,0.00,3.01,282.94,'2022-10-11 10:34:40','',''),(7311,'1','275','1',1,'Retail Sale Id 7034',9550.00,0.00,0.00,12.50,1175.00,'2022-10-11 10:34:40','',''),(7312,'1','275','1',1,'Retail Sale Id 7035',9550.00,0.00,0.00,12.50,1175.00,'2022-10-11 10:36:50','',''),(7313,'1','275','1',1,'Retail Sale Id 7036',9550.00,0.00,0.00,12.50,1175.00,'2022-10-11 10:38:20','',''),(7314,'1','275',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,2271300.00,3390.00,0.00,0.00,'2022-10-11 10:39:47','',''),(7315,'1','275',NULL,1,'Reception corrector for bridging 29',0.00,0.00,0.00,3390.00,0.00,'2022-10-11 10:40:39','',''),(7316,'1','275','1',1,'Received from bridging 29',0.00,0.00,3390.00,0.00,0.00,'2022-10-11 10:40:39','',''),(7317,'1','275','1',1,'Retail Sale Id 7037',19100.00,0.00,0.00,25.00,2350.00,'2022-10-11 10:41:19','',''),(7318,'1','275','1',1,'Retail Sale Id 7038',1000.84,0.00,0.00,1.31,123.14,'2022-10-11 10:42:06','',''),(7319,'1','275','1',1,'Retail Sale Id 7039',7999.08,0.00,0.00,10.47,984.18,'2022-10-11 10:43:11','',''),(7320,'1','275','1',1,'Retail Sale Id 7040',2299.64,0.00,0.00,3.01,282.94,'2022-10-11 10:44:46','',''),(7321,'1','275','1',1,'Retail Sale Id 7041',2299.64,0.00,0.00,3.01,282.94,'2022-10-11 10:47:18','',''),(7322,'1','275','1',1,'Retail Sale Id 7042',8801.28,0.00,0.00,11.52,1082.88,'2022-10-11 10:54:19','',''),(7323,'1','275','1',1,'Retail Sale Id 7043',2001.68,0.00,0.00,2.62,246.28,'2022-10-11 10:55:46','',''),(7324,'1','275','1',1,'Return of Retail Sale Id 7036',0.00,9550.00,12.50,0.00,-1175.00,'2022-10-11 10:56:38','',''),(7325,'1','275','1',1,'Retail Sale Id 7044',8786.00,0.00,0.00,11.50,1081.00,'2022-10-11 10:57:24','',''),(7326,'1','275','1',1,'Retail Sale Id 7045',2299.64,0.00,0.00,3.01,282.94,'2022-10-11 11:06:26','',''),(7327,'1','275','1',1,'Retail Sale Id 7046',3499.12,0.00,0.00,4.58,430.52,'2022-10-11 11:07:45','',''),(7328,'1','275','1',1,'Retail Sale Id 7047',7701.12,0.00,0.00,10.08,947.52,'2022-10-11 11:17:52','',''),(7329,'1','275','1',1,'Retail Sale Id 7048',9550.00,0.00,0.00,12.50,1175.00,'2022-10-11 11:38:08','',''),(7330,'1','275','1',1,'Retail Sale Id 7049',1199.48,0.00,0.00,1.57,147.58,'2022-10-11 12:09:17','',''),(7331,'1','275','1',1,'Retail Sale Id 7050',4996.56,0.00,0.00,6.54,614.76,'2022-10-11 12:22:30','',''),(7332,'1','275','1',1,'Retail Sale Id 7051',95500.00,0.00,0.00,125.00,11750.00,'2022-10-11 12:38:36','',''),(7333,'1','275','1',1,'Retail Sale Id 7052',9550.00,0.00,0.00,12.50,1175.00,'2022-10-11 12:43:51','',''),(7334,'1','275','1',1,'Retail Sale Id 7053',3002.52,0.00,0.00,3.93,369.42,'2022-10-11 12:45:19','',''),(7335,'1','275','1',1,'Retail Sale Id 7053',7502.48,0.00,0.00,9.82,923.08,'2022-10-11 12:45:19','',''),(7336,'1','275','1',1,'Return of Retail Sale Id 7052',0.00,9550.00,12.50,0.00,-1175.00,'2022-10-11 12:48:37','',''),(7337,'1','275','1',1,'Retail Sale Id 7054',38200.00,0.00,0.00,50.00,4700.00,'2022-10-11 12:49:16','',''),(7338,'1','275','1',1,'Retail Sale Id 7055',2498.28,0.00,0.00,3.27,307.38,'2022-10-11 12:54:40','',''),(7339,'1','275','1',1,'Retail Sale Id 7056',1902.36,0.00,0.00,2.49,234.06,'2022-10-11 12:56:52','',''),(7340,'1','275','1',1,'Retail Sale Id 7057',9550.00,0.00,0.00,12.50,1175.00,'2022-10-11 12:59:15','',''),(7341,'1','275','1',1,'Retail Sale Id 7058',1497.44,0.00,0.00,1.96,184.24,'2022-10-11 13:00:16','',''),(7342,'1','275','1',1,'Retail Sale Id 7059',9550.00,0.00,0.00,12.50,1175.00,'2022-10-11 13:02:11','',''),(7343,'1','275','1',1,'Retail Sale Id 7059',9550.00,0.00,0.00,12.50,1175.00,'2022-10-11 13:02:11','',''),(7344,'1','275','1',1,'Retail Sale Id 7059',9550.00,0.00,0.00,12.50,1175.00,'2022-10-11 13:02:11','',''),(7345,'1','275','1',1,'Retail Sale Id 7059',38200.00,0.00,0.00,50.00,4700.00,'2022-10-11 13:02:11','',''),(7346,'1','275','1',1,'Retail Sale Id 7060',1528.00,0.00,0.00,2.00,188.00,'2022-10-11 13:28:48','',''),(7347,'1','275','1',1,'Retail Sale Id 7061',9550.00,0.00,0.00,12.50,1175.00,'2022-10-11 13:38:00','',''),(7348,'1','275','1',1,'Retail Sale Id 7062',2398.96,0.00,0.00,3.14,295.16,'2022-10-11 13:41:22','',''),(7349,'1','275','1',1,'Retail Sale Id 7063',2299.64,0.00,0.00,3.01,282.94,'2022-10-11 13:46:41','',''),(7350,'1','275','1',1,'Retail Sale Id 7064',9550.00,0.00,0.00,12.50,1175.00,'2022-10-11 13:57:57','',''),(7351,'1','275','1',1,'Retail Sale Id 7065',7701.12,0.00,0.00,10.08,947.52,'2022-10-11 14:00:04','',''),(7352,'1','275','1',1,'Retail Sale Id 7066',9550.00,0.00,0.00,12.50,1175.00,'2022-10-11 14:01:29','',''),(7353,'1','275','1',1,'Retail Sale Id 7067',2001.68,0.00,0.00,2.62,246.28,'2022-10-11 14:15:23','',''),(7354,'1','275','1',1,'Retail Sale Id 7068',2299.64,0.00,0.00,3.01,282.94,'2022-10-11 14:54:16','',''),(7355,'1','275','1',1,'Retail Sale Id 7069',9550.00,0.00,0.00,12.50,1175.00,'2022-10-11 15:18:32','',''),(7356,'1','275','1',1,'Retail Sale Id 7070',9932.00,0.00,0.00,13.00,1222.00,'2022-10-11 15:20:28','',''),(7357,'1','275','1',1,'Retail Sale Id 7070',19100.00,0.00,0.00,25.00,2350.00,'2022-10-11 15:20:28','',''),(7358,'1','275','1',1,'Retail Sale Id 7071',7701.12,0.00,0.00,10.08,947.52,'2022-10-11 15:23:11','',''),(7359,'1','275','1',1,'Retail Sale Id 7072',9550.00,0.00,0.00,12.50,1175.00,'2022-10-11 15:38:32','',''),(7360,'1','275','1',1,'Retail Sale Id 7073',9550.00,0.00,0.00,12.50,1175.00,'2022-10-11 16:02:10','',''),(7361,'1','275','1',1,'Retail Sale Id 7074',4996.56,0.00,0.00,6.54,614.76,'2022-10-11 16:16:46','',''),(7362,'1','275','1',1,'Retail Sale Id 7075',4599.28,0.00,0.00,6.02,565.88,'2022-10-11 17:16:58','',''),(7363,'1','275','1',1,'Retail Sale Id 7076',802.20,0.00,0.00,1.05,98.70,'2022-10-11 17:19:57','',''),(7364,'1','275','1',1,'Retail Sale Id 7077',7640.00,0.00,0.00,10.00,940.00,'2022-10-11 17:24:03','',''),(7365,'1','275','1',1,'Retail Sale Id 7078',4499.96,0.00,0.00,5.89,553.66,'2022-10-11 17:31:55','',''),(7366,'1','275','1',1,'Retail Sale Id 7079',3101.84,0.00,0.00,4.06,381.64,'2022-10-11 17:33:20','',''),(7367,'1','275','1',1,'Retail Sale Id 7080',2498.28,0.00,0.00,3.27,307.38,'2022-10-11 17:34:54','',''),(7368,'1','275','1',1,'Retail Sale Id 7081',1497.44,0.00,0.00,1.96,184.24,'2022-10-11 17:35:53','',''),(7369,'1','275','1',1,'Retail Sale Id 7082',1497.44,0.00,0.00,1.96,184.24,'2022-10-11 17:43:40','',''),(7370,'1','275','1',1,'Retail Sale Id 7083',2299.64,0.00,0.00,3.01,282.94,'2022-10-11 17:46:41','',''),(7371,'1','275','1',1,'Retail Sale Id 7084',9550.00,0.00,0.00,12.50,1175.00,'2022-10-11 17:48:07','',''),(7372,'1','275','1',1,'Retail Sale Id 7085',802.20,0.00,0.00,1.05,98.70,'2022-10-11 17:51:48','',''),(7373,'1','275','1',1,'Retail Sale Id 7086',7701.12,0.00,0.00,10.08,947.52,'2022-10-11 18:08:36','',''),(7374,'1','275','1',1,'Retail Sale Id 7087',2292.00,0.00,0.00,3.00,282.00,'2022-10-11 18:12:26','',''),(7375,'1','275','1',1,'Retail Sale Id 7088',4003.36,0.00,0.00,5.24,492.56,'2022-10-11 18:19:10','',''),(7376,'1','275','1',1,'Retail Sale Id 7089',9550.00,0.00,0.00,12.50,1175.00,'2022-10-11 18:25:02','',''),(7377,'1','275','1',1,'Retail Sale Id 7090',25800.28,0.00,0.00,33.77,3174.38,'2022-10-11 19:38:55','',''),(7378,'1','275','1',1,'Retail Sale Id 7091',4301.32,0.00,0.00,5.63,529.22,'2022-10-12 07:14:03','',''),(7379,'1','275','1',1,'Retail Sale Id 7092',9350.00,0.00,0.00,12.50,975.00,'2022-10-12 07:42:34','',''),(7380,'1','275','1',1,'Retail Sale Id 7093',1802.68,0.00,0.00,2.41,187.98,'2022-10-12 07:48:14','',''),(7381,'1','275','1',1,'Retail Sale Id 7094',9350.00,0.00,0.00,12.50,975.00,'2022-10-12 07:54:18','',''),(7382,'1','275','1',1,'Retail Sale Id 7095',9350.00,0.00,0.00,12.50,975.00,'2022-10-12 07:57:39','',''),(7383,'1','275','1',1,'Retail Sale Id 7096',2999.48,0.00,0.00,4.01,312.78,'2022-10-12 08:17:56','',''),(7384,'1','275','1',1,'Retail Sale Id 7097',9350.00,0.00,0.00,12.50,975.00,'2022-10-12 08:25:59','',''),(7385,'1','275','1',1,'Retail Sale Id 7099',1997.16,0.00,0.00,2.67,208.26,'2022-10-12 08:32:22','',''),(7386,'1','275','1',1,'Retail Sale Id 7100',9350.00,0.00,0.00,12.50,975.00,'2022-10-12 08:37:14','',''),(7387,'1','275','1',1,'Retail Sale Id 7100',11220.00,0.00,0.00,15.00,1170.00,'2022-10-12 08:37:14','',''),(7388,'1','275','1',1,'Retail Sale Id 7101',9350.00,0.00,0.00,12.50,975.00,'2022-10-12 08:46:04','',''),(7389,'1','275','1',1,'Retail Sale Id 7102',1997.16,0.00,0.00,2.67,208.26,'2022-10-12 08:49:32','',''),(7390,'1','275','1',1,'Retail Sale Id 7103',9350.00,0.00,0.00,12.50,975.00,'2022-10-12 09:03:53','',''),(7391,'1','275','1',1,'Retail Sale Id 7103',14960.00,0.00,0.00,20.00,1560.00,'2022-10-12 09:03:53','',''),(7392,'1','275','1',1,'Retail Sale Id 7104',7502.44,0.00,0.00,10.03,782.34,'2022-10-12 09:09:22','',''),(7393,'1','275','1',1,'Retail Sale Id 7105',3747.48,0.00,0.00,5.01,390.78,'2022-10-12 09:10:51','',''),(7394,'1','275','1',1,'Retail Sale Id 7106',2296.36,0.00,0.00,3.07,239.46,'2022-10-12 09:12:09','',''),(7395,'1','275','1',1,'Retail Sale Id 7107',9350.00,0.00,0.00,12.50,975.00,'2022-10-12 09:18:53','',''),(7396,'1','275','1',1,'Retail Sale Id 7108',2999.48,0.00,0.00,4.01,312.78,'2022-10-12 09:22:34','',''),(7397,'1','275','1',1,'Retail Sale Id 7109',3740.00,0.00,0.00,5.00,390.00,'2022-10-12 09:26:29','',''),(7398,'1','275','1',1,'Retail Sale Id 7110',1503.48,0.00,0.00,2.01,156.78,'2022-10-12 09:39:07','',''),(7399,'1','275','1',1,'Retail Sale Id 7111',1997.16,0.00,0.00,2.67,208.26,'2022-10-12 09:44:00','',''),(7400,'1','275','1',1,'Retail Sale Id 7112',8602.00,0.00,0.00,11.50,897.00,'2022-10-12 09:46:23','',''),(7401,'1','275','1',1,'Retail Sale Id 7113',14212.00,0.00,0.00,19.00,1482.00,'2022-10-12 09:55:14','',''),(7402,'1','275','1',1,'Retail Sale Id 7114',2999.48,0.00,0.00,4.01,312.78,'2022-10-12 10:06:01','',''),(7403,'1','275','1',1,'Retail Sale Id 7115',1503.48,0.00,0.00,2.01,156.78,'2022-10-12 10:07:48','',''),(7404,'1','275','1',1,'Retail Sale Id 7116',13464.00,0.00,0.00,18.00,1404.00,'2022-10-12 10:13:42','',''),(7405,'1','275','1',1,'Retail Sale Id 7117',4502.96,0.00,0.00,6.02,469.56,'2022-10-12 10:18:08','',''),(7406,'1','275','1',1,'Retail Sale Id 7118',9350.00,0.00,0.00,12.50,975.00,'2022-10-12 10:50:30','',''),(7407,'1','275','1',1,'Retail Sale Id 7120',3740.00,0.00,0.00,5.00,390.00,'2022-10-12 11:09:11','',''),(7408,'1','275','1',1,'Retail Sale Id 7120',18700.00,0.00,0.00,25.00,1950.00,'2022-10-12 11:09:11','',''),(7409,'1','275','1',1,'Retail Sale Id 7121',9350.00,0.00,0.00,12.50,975.00,'2022-10-12 11:16:28','',''),(7410,'1','275','1',1,'Retail Sale Id 7122',1997.16,0.00,0.00,2.67,208.26,'2022-10-12 11:17:40','',''),(7411,'1','275','1',1,'Retail Sale Id 7123',2296.36,0.00,0.00,3.07,239.46,'2022-10-12 11:32:10','',''),(7412,'1','275','1',1,'Retail Sale Id 7124',8228.00,0.00,0.00,11.00,858.00,'2022-10-12 11:33:40','',''),(7413,'1','275','1',1,'Retail Sale Id 7124',8976.00,0.00,0.00,12.00,936.00,'2022-10-12 11:33:40','',''),(7414,'1','275','1',1,'Retail Sale Id 7125',9350.00,0.00,0.00,12.50,975.00,'2022-10-12 11:39:42','',''),(7415,'1','275','1',1,'Retail Sale Id 7126',4001.80,0.00,0.00,5.35,417.30,'2022-10-12 11:40:34','',''),(7416,'1','275','1',1,'Retail Sale Id 7127',3747.48,0.00,0.00,5.01,390.78,'2022-10-12 11:44:02','',''),(7417,'1','275','1',1,'Retail Sale Id 7128',2999.48,0.00,0.00,4.01,312.78,'2022-10-12 11:45:35','',''),(7418,'1','275','1',1,'Retail Sale Id 7129',9350.00,0.00,0.00,12.50,975.00,'2022-10-12 11:46:45','',''),(7419,'1','275','1',1,'Retail Sale Id 7130',4488.00,0.00,0.00,6.00,468.00,'2022-10-12 11:53:04','',''),(7420,'1','275','1',1,'Retail Sale Id 7131',4502.96,0.00,0.00,6.02,469.56,'2022-10-12 11:54:49','',''),(7421,'1','275','1',1,'Retail Sale Id 7132',17952.00,0.00,0.00,24.00,1872.00,'2022-10-12 12:09:11','',''),(7422,'1','275','1',1,'Retail Sale Id 7133',9350.00,0.00,0.00,12.50,975.00,'2022-10-12 12:23:19','',''),(7423,'1','275','1',1,'Retail Sale Id 7134',3740.00,0.00,0.00,5.00,390.00,'2022-10-12 12:35:46','',''),(7424,'1','275','1',1,'Retail Sale Id 7135',37400.00,0.00,0.00,50.00,3900.00,'2022-10-12 12:43:55','',''),(7425,'1','275','1',1,'Retail Sale Id 7136',9350.00,0.00,0.00,12.50,975.00,'2022-10-12 13:00:09','',''),(7426,'1','275','1',1,'Retail Sale Id 7137',2999.48,0.00,0.00,4.01,312.78,'2022-10-12 13:07:26','',''),(7427,'1','275','1',1,'Retail Sale Id 7138',4488.00,0.00,0.00,6.00,468.00,'2022-10-12 13:10:50','',''),(7428,'1','275','1',1,'Retail Sale Id 7139',10098.00,0.00,0.00,13.50,1053.00,'2022-10-12 13:14:28','',''),(7429,'1','275','1',1,'Retail Sale Id 7140',3740.00,0.00,0.00,5.00,390.00,'2022-10-12 13:25:09','',''),(7430,'1','275','1',1,'Retail Sale Id 7141',9350.00,0.00,0.00,12.50,975.00,'2022-10-12 13:29:27','',''),(7431,'1','275','1',1,'Retail Sale Id 7142',1503.48,0.00,0.00,2.01,156.78,'2022-10-12 13:34:07','',''),(7432,'1','275','1',1,'Retail Sale Id 7143',9798.80,0.00,0.00,13.10,1021.80,'2022-10-12 13:48:17','',''),(7433,'1','275','1',1,'Retail Sale Id 7144',18700.00,0.00,0.00,25.00,1950.00,'2022-10-12 13:52:26','',''),(7434,'1','275','1',1,'Retail Sale Id 7146',28424.00,0.00,0.00,38.00,2964.00,'2022-10-12 14:01:35','',''),(7435,'1','275','1',1,'Retail Sale Id 7147',1002.32,0.00,0.00,1.34,104.52,'2022-10-12 14:10:44','',''),(7436,'1','275','1',1,'Retail Sale Id 7148',15498.56,0.00,0.00,20.72,1616.16,'2022-10-12 14:12:43','',''),(7437,'1','275','1',1,'Retail Sale Id 7149',9350.00,0.00,0.00,12.50,975.00,'2022-10-12 14:13:53','',''),(7438,'1','275','1',1,'Retail Sale Id 7150',9350.00,0.00,0.00,12.50,975.00,'2022-10-12 14:18:41','',''),(7439,'1','275','1',1,'Retail Sale Id 7151',3740.00,0.00,0.00,5.00,390.00,'2022-10-12 14:23:51','',''),(7440,'1','275','1',1,'Retail Sale Id 7151',4488.00,0.00,0.00,6.00,468.00,'2022-10-12 14:23:51','',''),(7441,'1','275','1',1,'Retail Sale Id 7152',1997.16,0.00,0.00,2.67,208.26,'2022-10-12 14:28:00','',''),(7442,'1','275','1',1,'Retail Sale Id 7153',1503.48,0.00,0.00,2.01,156.78,'2022-10-12 14:29:10','',''),(7443,'1','275','1',1,'Retail Sale Id 7154',4488.00,0.00,0.00,6.00,468.00,'2022-10-12 14:39:23','',''),(7444,'1','275','1',1,'Retail Sale Id 7155',1002.32,0.00,0.00,1.34,104.52,'2022-10-12 14:43:54','',''),(7445,'1','275','1',1,'Retail Sale Id 7156',1398.76,0.00,0.00,1.87,145.86,'2022-10-12 14:49:38','',''),(7446,'1','275','1',1,'Retail Sale Id 7157',4001.80,0.00,0.00,5.35,417.30,'2022-10-12 15:11:47','',''),(7447,'1','275','1',1,'Retail Sale Id 7158',9350.00,0.00,0.00,12.50,975.00,'2022-10-12 15:14:53','',''),(7448,'1','275','1',1,'Retail Sale Id 7159',2999.48,0.00,0.00,4.01,312.78,'2022-10-12 15:20:43','',''),(7449,'1','275','1',1,'Retail Sale Id 7160',9350.00,0.00,0.00,12.50,975.00,'2022-10-12 15:44:56','',''),(7450,'1','275','1',1,'Retail Sale Id 7161',37400.00,0.00,0.00,50.00,3900.00,'2022-10-12 16:05:03','',''),(7451,'1','275','1',1,'Retail Sale Id 7162',9350.00,0.00,0.00,12.50,975.00,'2022-10-12 16:14:42','',''),(7452,'1','275','1',1,'Retail Sale Id 7163',2296.36,0.00,0.00,3.07,239.46,'2022-10-12 16:15:32','',''),(7453,'1','275','1',1,'Retail Sale Id 7164',9350.00,0.00,0.00,12.50,975.00,'2022-10-12 16:22:22','',''),(7454,'1','275','1',1,'Retail Sale Id 7165',2296.36,0.00,0.00,3.07,239.46,'2022-10-12 16:23:55','',''),(7455,'1','275','1',1,'Retail Sale Id 7166',1503.48,0.00,0.00,2.01,156.78,'2022-10-12 16:28:51','',''),(7456,'1','275','1',1,'Retail Sale Id 7167',18700.00,0.00,0.00,25.00,1950.00,'2022-10-12 16:32:02','',''),(7457,'1','275','1',1,'Retail Sale Id 7168',1997.16,0.00,0.00,2.67,208.26,'2022-10-12 16:36:09','',''),(7458,'1','275','1',1,'Retail Sale Id 7169',2296.36,0.00,0.00,3.07,239.46,'2022-10-12 16:44:06','',''),(7459,'1','275','1',1,'Retail Sale Id 7170',8998.44,0.00,0.00,12.03,938.34,'2022-10-12 16:46:03','',''),(7460,'1','275','1',1,'Retail Sale Id 7171',2498.32,0.00,0.00,3.34,260.52,'2022-10-12 16:47:13','',''),(7461,'1','275','1',1,'Retail Sale Id 7172',1997.16,0.00,0.00,2.67,208.26,'2022-10-12 16:55:37','',''),(7462,'1','275','1',1,'Retail Sale Id 7173',9350.00,0.00,0.00,12.50,975.00,'2022-10-12 17:00:27','',''),(7463,'1','275','1',1,'Retail Sale Id 7174',4996.64,0.00,0.00,6.68,521.04,'2022-10-12 17:14:26','',''),(7464,'1','275','1',1,'Retail Sale Id 7175',8497.28,0.00,0.00,11.36,886.08,'2022-10-12 17:21:15','',''),(7465,'1','275','1',1,'Retail Sale Id 7176',2296.36,0.00,0.00,3.07,239.46,'2022-10-12 17:23:23','',''),(7466,'1','275','1',1,'Retail Sale Id 7177',2999.48,0.00,0.00,4.01,312.78,'2022-10-12 17:34:09','',''),(7467,'1','275','1',1,'Retail Sale Id 7178',1997.16,0.00,0.00,2.67,208.26,'2022-10-12 17:38:03','',''),(7468,'1','275','1',1,'Retail Sale Id 7180',2244.00,0.00,0.00,3.00,234.00,'2022-10-12 17:48:24','',''),(7469,'1','275','1',1,'Retail Sale Id 7180',2244.00,0.00,0.00,3.00,234.00,'2022-10-12 17:48:24','',''),(7470,'1','275','1',1,'Retail Sale Id 7181',2244.00,0.00,0.00,3.00,234.00,'2022-10-12 17:53:14','',''),(7471,'1','275','1',1,'Retail Sale Id 7182',1997.16,0.00,0.00,2.67,208.26,'2022-10-12 17:55:11','',''),(7472,'1','275','1',1,'Retail Sale Id 7183',9402.36,0.00,0.00,12.57,980.46,'2022-10-12 17:57:27','',''),(7473,'1','275','1',1,'Retail Sale Id 7184',7480.00,0.00,0.00,10.00,780.00,'2022-10-12 18:01:08','',''),(7474,'1','275','1',1,'Retail Sale Id 7186',5998.96,0.00,0.00,8.02,625.56,'2022-10-12 18:06:21','',''),(7475,'1','275','1',1,'Retail Sale Id 7187',1997.16,0.00,0.00,2.67,208.26,'2022-10-12 18:07:17','',''),(7476,'1','275','1',1,'Retail Sale Id 7188',9350.00,0.00,0.00,12.50,975.00,'2022-10-12 18:18:21','',''),(7477,'1','275','1',1,'Retail Sale Id 7189',35006.40,0.00,0.00,46.80,3650.40,'2022-10-12 18:37:59','',''),(7478,'1','275','1',1,'Retail Sale Id 7190',9350.00,0.00,0.00,12.50,975.00,'2022-10-13 06:54:54','',''),(7479,'1','275','1',1,'Retail Sale Id 7190',9350.00,0.00,0.00,12.50,975.00,'2022-10-13 06:54:54','',''),(7480,'1','275','1',1,'Retail Sale Id 7191',9350.00,0.00,0.00,12.50,975.00,'2022-10-13 07:39:16','',''),(7481,'1','275','1',1,'Retail Sale Id 7192',4502.96,0.00,0.00,6.02,469.56,'2022-10-13 07:55:16','',''),(7482,'1','275','1',1,'Retail Sale Id 7193',8998.44,0.00,0.00,12.03,938.34,'2022-10-13 08:12:54','',''),(7483,'1','275','1',1,'Retail Sale Id 7194',37400.00,0.00,0.00,50.00,3900.00,'2022-10-13 08:15:17','',''),(7484,'1','275','1',1,'Retail Sale Id 7195',9350.00,0.00,0.00,12.50,975.00,'2022-10-13 08:20:08','',''),(7485,'1','275','1',1,'Retail Sale Id 7196',9350.00,0.00,0.00,12.50,975.00,'2022-10-13 08:29:53','',''),(7486,'1','275','1',1,'Retail Sale Id 7197',9402.36,0.00,0.00,12.57,980.46,'2022-10-13 08:31:45','',''),(7487,'1','275','1',1,'Retail Sale Id 7198',1997.16,0.00,0.00,2.67,208.26,'2022-10-13 08:50:24','',''),(7488,'1','275','1',1,'Retail Sale Id 7199',4502.96,0.00,0.00,6.02,469.56,'2022-10-13 08:51:54','',''),(7489,'1','275','1',1,'Retail Sale Id 7199',9350.00,0.00,0.00,12.50,975.00,'2022-10-13 08:51:54','',''),(7490,'1','275','1',1,'Retail Sale Id 7200',4996.64,0.00,0.00,6.68,521.04,'2022-10-13 08:53:06','',''),(7491,'1','275','1',1,'Retail Sale Id 7201',26180.00,0.00,0.00,35.00,2730.00,'2022-10-13 09:03:55','',''),(7492,'1','275','1',1,'Retail Sale Id 7202',1002.32,0.00,0.00,1.34,104.52,'2022-10-13 09:06:08','',''),(7493,'1','275','1',1,'Retail Sale Id 7204',8228.00,0.00,0.00,11.00,858.00,'2022-10-13 09:15:54','',''),(7494,'1','275','1',1,'Retail Sale Id 7205',9350.00,0.00,0.00,12.50,975.00,'2022-10-13 09:17:01','',''),(7495,'1','275','1',1,'Retail Sale Id 7206',2296.36,0.00,0.00,3.07,239.46,'2022-10-13 09:18:06','',''),(7496,'1','275','1',1,'Retail Sale Id 7207',9350.00,0.00,0.00,12.50,975.00,'2022-10-13 09:19:55','',''),(7497,'1','275','1',1,'Retail Sale Id 7208',9350.00,0.00,0.00,12.50,975.00,'2022-10-13 09:24:14','',''),(7498,'1','275','1',1,'Retail Sale Id 7209',1997.16,0.00,0.00,2.67,208.26,'2022-10-13 10:06:09','',''),(7499,'1','275','1',1,'Retail Sale Id 7210',8998.44,0.00,0.00,12.03,938.34,'2022-10-13 10:15:32','',''),(7500,'1','275','1',1,'Retail Sale Id 7211',3740.00,0.00,0.00,5.00,390.00,'2022-10-13 10:19:22','',''),(7501,'1','275','1',1,'Retail Sale Id 7211',28050.00,0.00,0.00,37.50,2925.00,'2022-10-13 10:19:22','',''),(7502,'1','275','1',1,'Retail Sale Id 7212',2999.48,0.00,0.00,4.01,312.78,'2022-10-13 10:27:04','',''),(7503,'1','275','1',1,'Retail Sale Id 7213',2296.36,0.00,0.00,3.07,239.46,'2022-10-13 10:36:34','',''),(7504,'1','275','1',1,'Retail Sale Id 7214',2296.36,0.00,0.00,3.07,239.46,'2022-10-13 10:53:29','',''),(7505,'1','275','1',1,'Retail Sale Id 7215',1503.48,0.00,0.00,2.01,156.78,'2022-10-13 10:57:00','',''),(7506,'1','275','1',1,'Retail Sale Id 7216',1002.32,0.00,0.00,1.34,104.52,'2022-10-13 10:57:52','',''),(7507,'1','275','1',1,'Retail Sale Id 7217',9350.00,0.00,0.00,12.50,975.00,'2022-10-13 11:17:59','',''),(7508,'1','275','1',1,'Retail Sale Id 7218',1997.16,0.00,0.00,2.67,208.26,'2022-10-13 11:32:24','',''),(7509,'1','275','1',1,'Retail Sale Id 7219',1997.16,0.00,0.00,2.67,208.26,'2022-10-13 11:40:17','',''),(7510,'1','275','1',1,'Retail Sale Id 7220',4502.96,0.00,0.00,6.02,469.56,'2022-10-13 11:54:08','',''),(7511,'1','275','1',1,'Retail Sale Id 7221',37400.00,0.00,0.00,50.00,3900.00,'2022-10-13 12:04:31','',''),(7512,'1','275','1',1,'Retail Sale Id 7222',3740.00,0.00,0.00,5.00,390.00,'2022-10-13 12:18:31','',''),(7513,'1','275','1',1,'Retail Sale Id 7223',2296.36,0.00,0.00,3.07,239.46,'2022-10-13 12:23:37','',''),(7514,'1','275','1',1,'Retail Sale Id 7224',1002.32,0.00,0.00,1.34,104.52,'2022-10-13 12:44:46','',''),(7515,'1','275','1',1,'Retail Sale Id 7225',8003.60,0.00,0.00,10.70,834.60,'2022-10-13 12:46:10','',''),(7516,'1','275','1',1,'Retail Sale Id 7226',9350.00,0.00,0.00,12.50,975.00,'2022-10-13 12:56:58','',''),(7517,'1','275','1',1,'Retail Sale Id 7227',1503.48,0.00,0.00,2.01,156.78,'2022-10-13 13:01:30','',''),(7518,'1','275','1',1,'Retail Sale Id 7228',29920.00,0.00,0.00,40.00,3120.00,'2022-10-13 13:15:20','',''),(7519,'1','275','1',1,'Retail Sale Id 7229',2296.36,0.00,0.00,3.07,239.46,'2022-10-13 13:26:19','',''),(7520,'1','275','1',1,'Retail Sale Id 7230',2296.36,0.00,0.00,3.07,239.46,'2022-10-13 14:06:38','',''),(7521,'1','275','1',1,'Retail Sale Id 7231',1099.56,0.00,0.00,1.47,114.66,'2022-10-13 14:34:51','',''),(7522,'1','275','1',1,'Retail Sale Id 7232',703.12,0.00,0.00,0.94,73.32,'2022-10-13 14:37:36','',''),(7523,'1','275','1',1,'Retail Sale Id 7233',1503.48,0.00,0.00,2.01,156.78,'2022-10-13 14:48:02','',''),(7524,'1','275','1',1,'Retail Sale Id 7234',59840.00,0.00,0.00,80.00,6240.00,'2022-10-13 15:09:52','',''),(7525,'1','275','1',1,'Retail Sale Id 7235',8998.44,0.00,0.00,12.03,938.34,'2022-10-13 15:10:50','',''),(7526,'1','275','1',1,'Retail Sale Id 7236',1997.16,0.00,0.00,2.67,208.26,'2022-10-13 15:18:31','',''),(7527,'1','275','1',1,'Retail Sale Id 7237',4001.80,0.00,0.00,5.35,417.30,'2022-10-13 15:31:09','',''),(7528,'1','275','1',1,'Retail Sale Id 7238',9350.00,0.00,0.00,12.50,975.00,'2022-10-13 15:35:09','',''),(7529,'1','275','1',1,'Retail Sale Id 7239',9350.00,0.00,0.00,12.50,975.00,'2022-10-13 15:49:03','',''),(7530,'1','275','1',1,'Retail Sale Id 7240',4996.64,0.00,0.00,6.68,521.04,'2022-10-13 15:51:06','',''),(7531,'1','275','1',1,'Retail Sale Id 7241',7502.44,0.00,0.00,10.03,782.34,'2022-10-13 15:52:04','',''),(7532,'1','275','1',1,'Retail Sale Id 7242',9350.00,0.00,0.00,12.50,975.00,'2022-10-13 15:53:14','',''),(7533,'1','275','1',1,'Retail Sale Id 7243',1002.32,0.00,0.00,1.34,104.52,'2022-10-13 15:58:10','',''),(7534,'1','275','1',1,'Retail Sale Id 7244',9350.00,0.00,0.00,12.50,975.00,'2022-10-13 16:12:12','',''),(7535,'1','275','1',1,'Retail Sale Id 7245',2296.36,0.00,0.00,3.07,239.46,'2022-10-13 16:22:54','',''),(7536,'1','275','1',1,'Retail Sale Id 7246',8998.44,0.00,0.00,12.03,938.34,'2022-10-13 16:24:27','',''),(7537,'1','275','1',1,'Retail Sale Id 7247',9350.00,0.00,0.00,12.50,975.00,'2022-10-13 16:25:42','',''),(7538,'1','275','1',1,'Retail Sale Id 7248',7480.00,0.00,0.00,10.00,780.00,'2022-10-13 16:33:37','',''),(7539,'1','275','1',1,'Retail Sale Id 7249',4502.96,0.00,0.00,6.02,469.56,'2022-10-13 16:49:24','',''),(7540,'1','275','1',1,'Retail Sale Id 7250',1503.48,0.00,0.00,2.01,156.78,'2022-10-13 16:50:32','',''),(7541,'1','275','1',1,'Retail Sale Id 7251',4502.96,0.00,0.00,6.02,469.56,'2022-10-13 16:52:01','',''),(7542,'1','275','1',1,'Retail Sale Id 7252',26180.00,0.00,0.00,35.00,2730.00,'2022-10-13 16:58:03','',''),(7543,'1','275','1',1,'Retail Sale Id 7253',9350.00,0.00,0.00,12.50,975.00,'2022-10-13 16:59:09','',''),(7544,'1','275','1',1,'Retail Sale Id 7254',1002.32,0.00,0.00,1.34,104.52,'2022-10-13 17:02:49','',''),(7545,'1','275','1',1,'Retail Sale Id 7255',1002.32,0.00,0.00,1.34,104.52,'2022-10-13 17:03:29','',''),(7546,'1','275','1',1,'Retail Sale Id 7256',1002.32,0.00,0.00,1.34,104.52,'2022-10-13 17:15:58','',''),(7547,'1','275','1',1,'Retail Sale Id 7257',2296.36,0.00,0.00,3.07,239.46,'2022-10-13 17:18:33','',''),(7548,'1','275','1',1,'Retail Sale Id 7258',18700.00,0.00,0.00,25.00,1950.00,'2022-10-13 17:27:15','',''),(7549,'1','275','1',1,'Retail Sale Id 7260',2992.00,0.00,0.00,4.00,312.00,'2022-10-13 17:34:28','',''),(7550,'1','275','1',1,'Retail Sale Id 7260',4488.00,0.00,0.00,6.00,468.00,'2022-10-13 17:34:28','',''),(7551,'1','275','1',1,'Retail Sale Id 7261',56100.00,0.00,0.00,75.00,5850.00,'2022-10-13 17:35:04','',''),(7552,'1','275','1',1,'Retail Sale Id 7262',8976.00,0.00,0.00,12.00,936.00,'2022-10-13 17:37:41','',''),(7553,'1','275','1',1,'Retail Sale Id 7263',3500.64,0.00,0.00,4.68,365.04,'2022-10-13 17:50:36','',''),(7554,'1','275','1',1,'Retail Sale Id 7264',3747.48,0.00,0.00,5.01,390.78,'2022-10-13 17:52:29','',''),(7555,'1','275','1',1,'Retail Sale Id 7265',2296.36,0.00,0.00,3.07,239.46,'2022-10-13 17:54:07','',''),(7556,'1','275','1',1,'Retail Sale Id 7266',9350.00,0.00,0.00,12.50,975.00,'2022-10-13 18:01:02','',''),(7557,'1','275','1',1,'Retail Sale Id 7267',9350.00,0.00,0.00,12.50,975.00,'2022-10-13 18:05:53','',''),(7558,'1','275','1',1,'Retail Sale Id 7268',8602.00,0.00,0.00,11.50,897.00,'2022-10-13 18:08:11','',''),(7559,'1','275','1',1,'Retail Sale Id 7269',7502.44,0.00,0.00,10.03,782.34,'2022-10-13 18:10:17','',''),(7560,'1','275','1',1,'Retail Sale Id 7270',17952.00,0.00,0.00,24.00,1872.00,'2022-10-13 18:33:16','',''),(7561,'1','275','1',1,'Return of Retail Sale Id 7270',0.00,17952.00,24.00,0.00,-1872.00,'2022-10-13 19:18:02','',''),(7562,'1','275','1',1,'Retail Sale Id 7271',4832.08,0.00,0.00,6.46,503.88,'2022-10-13 19:19:01','',''),(7563,'1','275','1',1,'Retail Sale Id 7272',2244.00,0.00,0.00,3.00,234.00,'2022-10-14 06:38:31','',''),(7564,'1','275','1',1,'Retail Sale Id 7273',9350.00,0.00,0.00,12.50,975.00,'2022-10-14 06:40:13','',''),(7565,'1','275','1',1,'Retail Sale Id 7274',8003.60,0.00,0.00,10.70,834.60,'2022-10-14 06:56:29','',''),(7566,'1','275','1',1,'Retail Sale Id 7275',4996.64,0.00,0.00,6.68,521.04,'2022-10-14 06:57:57','',''),(7567,'1','275','1',1,'Retail Sale Id 7276',9350.00,0.00,0.00,12.50,975.00,'2022-10-14 06:59:44','',''),(7568,'1','275','1',1,'Retail Sale Id 7277',8602.00,0.00,0.00,11.50,897.00,'2022-10-14 07:12:52','',''),(7569,'1','275','1',1,'Retail Sale Id 7277',8976.00,0.00,0.00,12.00,936.00,'2022-10-14 07:12:52','',''),(7570,'1','275','1',1,'Retail Sale Id 7278',18700.00,0.00,0.00,25.00,1950.00,'2022-10-14 07:14:04','',''),(7571,'1','275','1',1,'Retail Sale Id 7279',1503.48,0.00,0.00,2.01,156.78,'2022-10-14 07:39:43','',''),(7572,'1','275','1',1,'Retail Sale Id 7280',9350.00,0.00,0.00,12.50,975.00,'2022-10-14 07:44:43','',''),(7573,'1','275','1',1,'Retail Sale Id 7281',4502.96,0.00,0.00,6.02,469.56,'2022-10-14 07:45:36','',''),(7574