-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_274
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_274`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_274` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_274`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,4000,'',0,'22','1','274','PURCHASES','','2022-05-29 12:53:23',5,0.00,0.00,'','479','2022-05-29 12:53:23','479',0,0),(2,7000,'',0,'20','1','274','SALES','','2022-05-29 12:53:34',5,0.00,0.00,'','479','2022-05-29 12:53:34','479',0,0),(3,500,'',0,'6.1','1','274','CASH','','2022-05-29 12:53:47',5,0.00,0.00,'','479','2022-05-29 12:53:47','479',0,0),(4,8000,'',0,'24','1','274','PURCHASES','','2022-05-29 12:53:59',5,0.00,0.00,'','479','2022-05-29 12:53:59','479',0,0),(5,8001,'',0,'24','1','274','SALARIES & WAGES','','2022-05-29 12:54:11',5,0.00,0.00,'','479','2022-05-29 12:54:11','479',0,0),(6,2500,'',0,'2','1','274','ZNB E-BILL COLLECTION :1014717','','2022-05-29 12:54:36',5,0.00,0.00,'','479','2022-05-29 12:54:36','479',0,0),(7,2501,'',0,'2','1','274','FID POS COLLECTION-5620141491','','2022-05-29 12:54:51',5,0.00,0.00,'','479','2022-05-29 12:54:51','479',0,0),(8,2502,'',0,'2','1','274','E-BILLS 1015372548','','2022-05-29 12:55:08',5,0.00,0.00,'','479','2022-05-29 12:55:08','479',0,0),(9,2503,'',0,'2','1','274','DANKANO-EBILLS:ZNB1014717618','','2022-05-29 12:55:30',5,0.00,0.00,'','479','2022-05-29 12:55:30','479',0,0),(10,2504,'',0,'2','1','274','FB(IBAL)2023855223','','2022-05-29 12:57:05',5,0.00,0.00,'','479','2022-05-29 12:57:05','479',0,0),(11,2505,'',0,'2','1','274','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:11:14',5,0.00,0.00,'','792','2023-02-20 14:11:14','792',0,0),(12,2506,'',0,'2','1','274','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:23:57',5,0.00,0.00,'2023-03-15','792','2023-03-17 12:26:43','792',0,0),(13,2507,'',0,'2','1','274','UBA LPG COLL ACCT:-1020811140','UBA LPG COLL ACCT:-1020811140','2023-03-18 11:44:17',5,0.00,0.00,'','792','2023-03-18 11:44:17','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','1','274','operational loss','operational loss','07063885369','mahadisurajo@mail.com','gwarinpa','Abuja','mahadisurajo@mail.com','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-06-02 18:40:37',5,'888','2022-06-02 18:40:37','888');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','274','1',1,'5','LPG NOZZLE 1',128515.59,'LPG DISPENSER.','',NULL,NULL,'',5,'2022-06-03 07:01:30','483'),('1','274','1',2,'5','LPG NOZZLE 2',86834.89,'LPG DISPENSER.','',NULL,NULL,'',5,'2022-06-03 07:01:59','483');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=314 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','274',1,'DAILY SHIFT','2022-05-26','2022-05-30 14:42:36','2022-06-02 14:42:36','888',0.00,0.00,'888','2022-05-31 11:43:08','888','2022-05-31 16:46:55',10,0),('1','274',2,'DAILY SHIFT','2022-05-27','2022-05-31 16:48:32','2022-06-01 16:48:32','888',0.00,0.00,'888','2022-05-31 16:51:33','888','2022-05-31 16:52:48',10,0),('1','274',3,'DAILY SHIFT','2022-05-28','2022-05-31 16:57:16','2022-06-01 16:57:16','888',0.00,0.00,'888','2022-05-31 17:00:12','888','2022-05-31 17:00:27',10,0),('1','274',4,'DAILY SHIFT','2022-05-29','2022-05-31 17:02:28','2022-06-01 17:02:28','888',0.00,0.00,'888','2022-05-31 17:05:56','888','2022-05-31 17:06:13',10,0),('1','274',5,'DAILY SHIFT','2022-05-30','2022-05-31 17:08:58','2022-06-01 17:08:58','888',0.00,0.00,'888','2022-05-31 17:12:32','888','2022-05-31 17:13:01',10,0),('1','274',6,'DAILY SHIFT','2022-05-31','2022-05-31 17:18:39','2022-06-01 17:18:39','888',0.00,0.00,'888','2022-05-31 19:56:23','888','2022-05-31 19:56:44',10,0),('1','274',7,'DAILY SHIFT','2022-06-01','2022-06-01 07:16:26','2022-06-02 07:16:26','888',0.00,0.00,'888','2022-06-01 19:40:30','888','2022-06-01 19:40:50',10,0),('1','274',8,'DAILY SHIFT','2022-06-02','2022-06-02 07:34:33','2022-06-03 07:34:33','888',0.00,0.00,'888','2022-06-02 18:25:15','888','2022-06-02 18:25:50',10,0),('1','274',9,'DAILY SHIFT','2022-06-02','2022-06-02 18:26:49','2022-06-03 18:26:49','888',0.00,0.00,'888','2022-06-02 19:18:08','888','2022-06-02 19:18:28',10,0),('1','274',10,'DAILY SHIFT','2022-06-03','2022-06-03 08:29:52','2022-06-04 08:29:52','888',0.00,0.00,'888','2022-06-03 21:14:20','888','2022-06-03 21:14:44',10,0),('1','274',11,'DAILY SHIFT','2022-06-04','2022-06-04 07:12:44','2022-06-05 07:12:44','888',0.00,0.00,'888','2022-06-04 19:56:32','888','2022-06-04 19:57:02',10,0),('1','274',12,'DAILY SHIFT','2022-06-05','2022-06-05 07:12:24','2022-06-06 07:12:24','888',0.00,0.00,'888','2022-06-05 20:35:57','888','2022-06-05 20:36:23',10,0),('1','274',13,'DAILY SHIFT','2022-06-06','2022-06-06 07:01:55','2022-06-07 07:01:55','888',0.00,0.00,'888','2022-06-06 22:06:08','888','2022-06-06 22:06:33',10,0),('1','274',14,'DAILY SHIFT','2022-06-07','2022-06-07 06:28:48','2022-06-08 06:28:48','888',0.00,0.00,'888','2022-06-07 19:43:47','888','2022-06-07 19:44:10',10,0),('1','274',15,'DAILY SHIFT','2022-06-08','2022-06-08 05:57:26','2022-06-09 05:57:26','888',0.00,0.00,'888','2022-06-08 19:29:18','888','2022-06-08 19:29:38',10,0),('1','274',16,'DAILY SHIFT','2022-06-09','2022-06-09 06:20:58','2022-06-10 06:20:58','888',0.00,0.00,'888','2022-06-09 10:15:10','888','2022-06-09 10:15:30',10,0),('1','274',17,'DAILY SHIFT','2022-06-10','2022-06-10 10:32:15','2022-06-11 10:32:15','888',0.00,0.00,'888','2022-06-10 21:02:37','888','2022-06-10 21:03:00',10,0),('1','274',18,'DAILY SHIFT','2022-06-11','2022-06-11 07:17:50','2022-06-12 07:17:50','888',0.00,0.00,'888','2022-06-11 19:48:48','888','2022-06-11 19:49:07',10,0),('1','274',19,'DAILY SHIFT','2022-06-12','2022-06-12 07:10:20','2022-06-13 07:10:20','888',0.00,0.00,'888','2022-06-12 19:52:55','888','2022-06-12 19:53:14',10,0),('1','274',20,'DAILY SHIFT','2022-06-13','2022-06-13 06:42:47','2022-06-14 06:42:47','888',0.00,0.00,'888','2022-06-13 19:16:31','888','2022-06-13 19:16:53',10,0),('1','274',21,'DAILY SHIFT','2022-06-14','2022-06-14 07:41:47','2022-06-15 07:41:47','888',0.00,0.00,'888','2022-06-14 17:42:56','888','2022-06-14 17:43:17',10,0),('1','274',22,'DAILY SHIFT','2022-06-15','2022-06-15 09:23:15','2022-06-16 09:23:15','888',0.00,0.00,'888','2022-06-15 19:46:07','888','2022-06-15 19:46:30',10,0),('1','274',23,'DAILY SHIFT','2022-06-16','2022-06-16 07:33:21','2022-06-17 07:33:21','888',0.00,0.00,'888','2022-06-16 19:32:23','888','2022-06-16 19:32:40',10,0),('1','274',24,'DAILY SHIFT','2022-06-17','2022-06-17 08:11:23','2022-06-18 08:11:23','888',0.00,0.00,'888','2022-06-18 08:36:48','888','2022-06-18 08:37:16',10,0),('1','274',25,'DAILY SHIFT','2022-06-18','2022-06-18 08:37:52','2022-06-19 08:37:52','888',0.00,0.00,'888','2022-06-18 19:32:08','888','2022-06-18 19:32:28',10,0),('1','274',26,'DAILY SHIFT','2022-06-19','2022-06-19 07:27:30','2022-06-20 07:27:30','888',0.00,0.00,'888','2022-06-19 19:22:24','888','2022-06-19 19:22:40',10,0),('1','274',27,'DAILY SHIFT','2022-06-20','2022-06-20 06:44:58','2022-06-21 06:44:58','888',0.00,0.00,'888','2022-06-20 11:58:46','888','2022-06-20 11:59:05',10,0),('1','274',28,'DAILY SHIFT','2022-06-20','2022-06-20 13:22:24','2022-06-21 13:22:24','888',0.00,0.00,'888','2022-06-20 18:54:35','888','2022-06-20 18:55:07',10,0),('1','274',29,'DAILY SHIFT','2022-06-21','2022-06-21 07:04:43','2022-06-22 07:04:43','888',0.00,0.00,'888','2022-06-21 20:27:51','888','2022-06-21 20:28:08',10,0),('1','274',30,'DAILY SHIFT','2022-06-22','2022-06-22 07:20:55','2022-06-23 07:20:55','888',0.00,0.00,'888','2022-06-22 17:55:28','888','2022-06-22 17:55:46',10,0),('1','274',31,'DAILY SHIFT','2022-06-23','2022-06-23 07:05:44','2022-06-24 07:05:44','888',0.00,0.00,'888','2022-06-23 19:36:15','888','2022-06-23 19:36:36',10,0),('1','274',32,'DAILY SHIFT','2022-06-24','2022-06-24 10:34:14','2022-06-25 10:34:14','888',0.00,0.00,'888','2022-06-24 20:00:49','888','2022-06-24 20:01:08',10,0),('1','274',33,'DAILY SHIFT','2022-06-25','2022-06-25 07:06:42','2022-06-26 07:06:42','888',0.00,0.00,'888','2022-06-25 19:38:24','888','2022-06-25 19:38:46',10,0),('1','274',34,'DAILY SHIFT','2022-06-26','2022-06-26 07:31:26','2022-06-27 07:31:26','888',0.00,0.00,'888','2022-06-26 19:23:34','888','2022-06-26 19:23:52',10,0),('1','274',35,'DAILY SHIFT','2022-06-27','2022-06-27 07:35:09','2022-06-28 07:35:09','888',0.00,0.00,'888','2022-06-27 20:16:30','888','2022-06-27 20:16:48',10,0),('1','274',36,'DAILY SHIFT','2022-06-28','2022-06-28 07:08:24','2022-06-29 07:08:24','888',0.00,0.00,'888','2022-06-28 15:17:57','888','2022-06-28 15:18:13',10,0),('1','274',37,'DAILY SHIFT','2022-06-28','2022-06-28 15:19:00','2022-06-29 15:19:00','888',0.00,0.00,'888','2022-06-28 15:23:21','888','2022-06-28 15:23:37',10,0),('1','274',38,'DAILY SHIFT','2022-06-28','2022-06-28 16:20:30','2022-06-29 16:20:30','888',0.00,0.00,'888','2022-06-28 20:00:59','888','2022-06-28 20:01:17',10,0),('1','274',39,'DAILY SHIFT','2022-06-29','2022-06-29 06:38:29','2022-06-30 06:38:29','888',0.00,0.00,'888','2022-06-29 19:52:41','888','2022-06-29 19:53:06',10,0),('1','274',40,'DAILY SHIFT','2022-06-30','2022-06-30 06:50:44','2022-07-01 06:50:44','888',0.00,0.00,'888','2022-06-30 19:46:54','888','2022-06-30 19:47:14',10,0),('1','274',41,'DAILY SHIFT','2022-07-01','2022-07-01 07:22:54','2022-07-02 07:22:54','888',0.00,0.00,'888','2022-07-01 19:44:02','888','2022-07-01 19:45:32',10,0),('1','274',42,'DAILY SHIFT','2022-07-02','2022-07-02 07:04:50','2022-07-03 07:04:50','888',0.00,0.00,'888','2022-07-02 20:04:04','888','2022-07-02 20:04:22',10,0),('1','274',43,'DAILY SHIFT','2022-07-03','2022-07-03 06:31:52','2022-07-04 06:31:52','888',0.00,0.00,'888','2022-07-03 20:02:21','888','2022-07-03 20:02:38',10,0),('1','274',44,'DAILY SHIFTS','2022-07-04','2022-07-04 07:48:53','2022-07-05 07:48:53','888',0.00,0.00,'888','2022-07-04 19:55:23','888','2022-07-04 19:55:46',10,0),('1','274',45,'DAILY SHIFT','2022-07-05','2022-07-05 06:29:20','2022-07-06 06:29:20','888',0.00,0.00,'888','2022-07-05 19:54:11','888','2022-07-05 19:54:44',10,0),('1','274',46,'DAILY SHIFT','2022-07-06','2022-07-06 07:19:28','2022-07-07 07:19:28','888',0.00,0.00,'888','2022-07-06 19:55:10','888','2022-07-06 19:55:33',10,0),('1','274',47,'DAILY SHIFT','2022-07-07','2022-07-07 06:42:28','2022-07-08 06:42:28','888',0.00,0.00,'888','2022-07-07 20:18:03','888','2022-07-08 07:07:01',10,0),('1','274',48,'DAILY SHIFT','2022-07-08','2022-07-08 07:07:24','2022-07-09 07:07:24','888',0.00,0.00,'888','2022-07-08 20:04:39','888','2022-07-08 20:04:57',10,0),('1','274',49,'DAILY SHIFT','2022-07-09','2022-07-09 08:12:00','2022-07-10 08:12:00','888',0.00,0.00,'888','2022-07-09 20:11:01','888','2022-07-09 20:11:21',10,0),('1','274',50,'DAILY SHIFT','2022-07-10','2022-07-10 07:22:46','2022-07-11 07:22:46','888',0.00,0.00,'888','2022-07-10 19:28:49','888','2022-07-10 19:29:09',10,0),('1','274',51,'DAILY SHIFT','2022-07-11','2022-07-11 07:59:09','2022-07-12 07:59:09','888',0.00,0.00,'888','2022-07-11 19:43:20','888','2022-07-11 19:43:48',10,0),('1','274',52,'DAILY SHIFT','2022-07-12','2022-07-12 08:12:10','2022-07-13 08:12:10','888',0.00,0.00,'888','2022-07-12 18:58:37','888','2022-07-12 18:58:55',10,0),('1','274',53,'DAILY SHIFT','2022-07-13','2022-07-13 07:46:48','2022-07-14 07:46:48','888',0.00,0.00,'888','2022-07-13 19:34:40','888','2022-07-13 19:35:01',10,0),('1','274',54,'DAILY SHIFT','2022-07-14','2022-07-14 06:51:34','2022-07-15 06:51:34','888',0.00,0.00,'888','2022-07-14 19:35:11','888','2022-07-14 19:35:28',10,0),('1','274',55,'DAILY SHIFT','2022-07-15','2022-07-15 06:40:50','2022-07-16 06:40:50','888',0.00,0.00,'888','2022-07-15 19:30:25','888','2022-07-15 19:30:47',10,0),('1','274',56,'DAILY SHIFT','2022-07-16','2022-07-16 06:25:24','2022-07-17 06:25:24','888',0.00,0.00,'888','2022-07-16 19:36:22','888','2022-07-16 19:36:41',10,0),('1','274',57,'DAILY SHIFT','2022-07-17','2022-07-17 07:04:44','2022-07-18 07:04:44','888',0.00,0.00,'888','2022-07-17 14:57:12','888','2022-07-17 14:57:30',10,0),('1','274',58,'DAILY SHIFT','2022-07-17','2022-07-17 16:36:32','2022-07-18 16:36:32','888',0.00,0.00,'888','2022-07-17 20:58:28','888','2022-07-17 20:58:47',10,0),('1','274',59,'DAILY SHIFT','2022-07-18','2022-07-18 07:23:26','2022-07-19 07:23:26','888',0.00,0.00,'888','2022-07-18 19:47:36','888','2022-07-18 19:47:54',10,0),('1','274',60,'DAILY SHIFT','2022-07-19','2022-07-19 06:34:21','2022-07-20 06:34:21','888',0.00,0.00,'888','2022-07-19 20:07:04','888','2022-07-19 20:07:23',10,0),('1','274',61,'DAILY SHIFT','2022-07-20','2022-07-20 07:04:18','2022-07-21 07:04:18','888',0.00,0.00,'888','2022-07-20 20:15:09','888','2022-07-20 20:15:34',10,0),('1','274',62,'DAILY SHIFT','2022-07-21','2022-07-21 07:54:10','2022-07-22 07:54:10','888',0.00,0.00,'888','2022-07-21 19:56:43','888','2022-07-21 19:57:06',10,0),('1','274',63,'DAILY SHIFT909','2022-07-22','2022-07-22 08:43:17','2022-07-23 08:43:17','888',0.00,0.00,'888','2022-07-22 20:16:53','888','2022-07-22 20:17:15',10,0),('1','274',64,'DAILY SHIFT','2022-07-23','2022-07-23 06:49:14','2022-07-24 06:49:14','888',0.00,0.00,'888','2022-07-23 21:00:00','888','2022-07-23 21:01:56',10,0),('1','274',65,'DAILY SHIFT','2022-07-24','2022-07-24 06:50:22','2022-07-25 06:50:22','888',0.00,0.00,'888','2022-07-24 20:34:56','888','2022-07-24 20:35:32',10,0),('1','274',66,'DAILY SHIFT','2022-07-25','2022-07-25 08:01:56','2022-07-26 08:01:56','888',0.00,0.00,'888','2022-07-25 20:07:16','888','2022-07-25 20:08:21',10,0),('1','274',67,'DAILY SHIFT','2022-07-26','2022-07-26 08:30:25','2022-07-27 08:30:25','888',0.00,0.00,'888','2022-07-27 06:24:55','888','2022-07-27 06:30:38',10,0),('1','274',68,'DAILY SHIFT','2022-07-27','2022-07-27 06:31:11','2022-07-28 06:31:11','888',0.00,0.00,'888','2022-07-27 20:13:26','888','2022-07-27 20:13:49',10,0),('1','274',69,'DAILY SHIFT','2022-07-28','2022-07-28 06:36:35','2022-07-29 06:36:35','888',0.00,0.00,'888','2022-07-28 20:20:22','888','2022-07-28 20:21:15',10,0),('1','274',70,'DAILY SHIFT','2022-07-29','2022-07-29 06:46:55','2022-07-30 06:46:55','888',0.00,0.00,'888','2022-07-29 20:15:52','888','2022-07-29 20:18:40',10,0),('1','274',71,'DAILY SHIFT','2022-07-30','2022-07-30 06:59:05','2022-07-31 06:59:05','888',0.00,0.00,'888','2022-07-30 21:06:16','888','2022-07-30 21:06:56',10,0),('1','274',72,'DAILY SHIFT','2022-07-31','2022-07-31 06:34:06','2022-08-01 06:34:06','888',0.00,0.00,'888','2022-07-31 16:52:13','888','2022-07-31 16:52:53',10,0),('1','274',73,'DAILY SHIFT','2022-08-01','2022-08-01 06:37:59','2022-08-02 06:37:59','888',0.00,0.00,'888','2022-08-01 20:29:48','888','2022-08-01 20:30:12',10,0),('1','274',74,'DAILY SHIFT','2022-08-02','2022-08-02 06:49:01','2022-08-03 06:49:01','888',0.00,0.00,'888','2022-08-02 19:51:57','888','2022-08-03 06:41:47',10,0),('1','274',75,'DAILY SHIFT','2022-08-03','2022-08-03 06:42:18','2022-08-04 06:42:18','888',0.00,0.00,'888','2022-08-03 20:02:45','888','2022-08-03 20:03:06',10,0),('1','274',76,'DAILY SHIFT','2022-08-04','2022-08-04 06:38:26','2022-08-05 06:38:26','888',0.00,0.00,'888','2022-08-04 20:17:02','888','2022-08-04 20:17:20',10,0),('1','274',77,'DAILY SHIFT','2022-08-05','2022-08-05 07:20:15','2022-08-06 07:20:15','888',0.00,0.00,'888','2022-08-05 20:51:56','888','2022-08-05 20:52:42',10,0),('1','274',78,'DAILY SHIFT','2022-08-06','2022-08-06 07:35:03','2022-08-07 07:35:03','888',0.00,0.00,'888','2022-08-06 20:22:00','888','2022-08-06 20:25:17',10,0),('1','274',79,'DAILY SHIFT','2022-08-07','2022-08-07 07:15:31','2022-08-08 07:15:31','888',0.00,0.00,'888','2022-08-07 11:45:58','888','2022-08-07 11:46:27',10,0),('1','274',80,'DAILY SHIFTS','2022-08-07','2022-08-07 13:39:07','2022-08-08 13:39:07','888',0.00,0.00,'888','2022-08-07 19:52:58','888','2022-08-07 19:53:25',10,0),('1','274',81,'DAILY SHIFT','2022-08-08','2022-08-08 06:53:32','2022-08-09 06:53:32','888',0.00,0.00,'888','2022-08-08 19:56:43','888','2022-08-08 19:57:13',10,0),('1','274',82,'DAILY SHIFT','2022-08-09','2022-08-09 07:20:06','2022-08-10 07:20:06','888',0.00,0.00,'888','2022-08-10 06:13:49','888','2022-08-10 06:14:13',10,0),('1','274',83,'DAILY SHIFT','2022-08-10','2022-08-10 06:14:39','2022-08-11 06:14:39','888',0.00,0.00,'888','2022-08-10 19:55:23','888','2022-08-10 19:55:40',10,0),('1','274',84,'DAILY SHIFT','2022-08-11','2022-08-11 07:56:16','2022-08-12 07:56:16','888',0.00,0.00,'888','2022-08-11 19:47:04','888','2022-08-11 19:47:23',10,0),('1','274',85,'DAILY SHIFT','2022-08-12','2022-08-12 06:36:18','2022-08-13 06:36:18','888',0.00,0.00,'888','2022-08-12 20:08:08','888','2022-08-12 20:09:04',10,0),('1','274',86,'DAILY SHIFTS','2022-08-13','2022-08-13 06:36:30','2022-08-14 06:36:30','888',0.00,0.00,'888','2022-08-13 20:12:20','888','2022-08-13 20:12:37',10,0),('1','274',87,'DAILY SHIFT','2022-08-14','2022-08-14 06:32:05','2022-08-15 06:32:05','888',0.00,0.00,'888','2022-08-14 16:40:18','888','2022-08-14 16:40:44',10,0),('1','274',88,'DAILY SHIFT','2022-08-14','2022-08-14 19:18:15','2022-08-15 19:18:15','888',0.00,0.00,'888','2022-08-14 20:26:05','888','2022-08-14 20:26:21',10,0),('1','274',89,'DAILY SHIFT ','2022-08-15','2022-08-15 07:07:48','2022-08-16 07:07:48','888',0.00,0.00,'888','2022-08-15 19:34:29','888','2022-08-15 19:34:50',10,0),('1','274',90,'DAILY SHIFT ','2022-08-16','2022-08-16 06:33:33','2022-08-17 06:33:33','888',0.00,0.00,'888','2022-08-16 20:35:42','888','2022-08-16 20:36:00',10,0),('1','274',91,'DAILY SHIFT ','2022-08-17','2022-08-17 07:06:54','2022-08-18 07:06:54','888',0.00,0.00,'888','2022-08-17 20:07:44','888','2022-08-17 20:07:59',10,0),('1','274',92,'DAILY SHIFT ','2022-08-18','2022-08-18 06:48:31','2022-08-19 06:48:31','888',0.00,0.00,'888','2022-08-18 19:39:39','888','2022-08-18 19:39:54',10,0),('1','274',93,'DAILY SHIFT ','2022-08-19','2022-08-19 06:29:31','2022-08-20 06:29:31','888',0.00,0.00,'888','2022-08-19 19:43:01','888','2022-08-19 19:44:03',10,0),('1','274',94,'DAILY SHIFT ','2022-08-20','2022-08-20 06:38:57','2022-08-21 06:38:57','888',0.00,0.00,'888','2022-08-20 19:45:18','888','2022-08-20 19:46:08',10,0),('1','274',95,'DAILY SHIFT ','2022-08-21','2022-08-21 07:16:46','2022-08-22 07:16:46','888',0.00,0.00,'888','2022-08-21 17:07:55','888','2022-08-21 17:08:12',10,0),('1','274',96,'DAILY SHIFT ','2022-08-22','2022-08-22 07:15:06','2022-08-23 07:15:06','888',0.00,0.00,'888','2022-08-22 20:27:24','888','2022-08-22 20:27:41',10,0),('1','274',97,'DAILY SHIFT ','2022-08-23','2022-08-23 06:29:15','2022-08-24 06:29:15','888',0.00,0.00,'888','2022-08-23 19:53:17','888','2022-08-23 19:56:30',10,0),('1','274',98,'DAILY SHIFT ','2022-08-24','2022-08-24 06:40:56','2022-08-25 06:40:56','888',0.00,0.00,'888','2022-08-24 19:37:31','888','2022-08-24 19:37:51',10,0),('1','274',99,'DAILY SHIFT','2022-08-25','2022-08-25 06:32:31','2022-08-26 06:32:31','888',0.00,0.00,'888','2022-08-25 19:41:20','888','2022-08-25 19:41:45',10,0),('1','274',100,'DAILY SHIFT ','2022-08-26','2022-08-26 07:55:45','2022-08-27 07:55:45','888',0.00,0.00,'888','2022-08-26 20:07:49','888','2022-08-26 20:08:05',10,0),('1','274',101,'DAILY SHIFT ','2022-08-27','2022-08-27 06:36:38','2022-08-28 06:36:38','888',0.00,0.00,'888','2022-08-27 19:09:36','888','2022-08-27 19:09:59',10,0),('1','274',102,'DAILY SHIFT','2022-08-28','2022-08-28 07:47:35','2022-08-29 07:47:35','888',0.00,0.00,'888','2022-08-28 20:15:02','888','2022-08-28 20:15:38',10,0),('1','274',103,'DAILY SHIFT','2022-08-29','2022-08-29 06:37:39','2022-08-30 06:37:39','888',0.00,0.00,'888','2022-08-29 19:36:00','888','2022-08-29 19:36:32',10,0),('1','274',104,'DAILY SHIFT ','2022-08-30','2022-08-30 06:30:39','2022-08-31 06:30:39','888',0.00,0.00,'888','2022-08-30 20:01:30','888','2022-08-30 20:01:49',10,0),('1','274',105,'DAILY SHIFT ','2022-08-31','2022-08-31 06:31:40','2022-09-01 06:31:40','888',0.00,0.00,'888','2022-08-31 19:30:00','888','2022-08-31 19:30:19',10,0),('1','274',106,'DAILY SHIFT ','2022-09-01','2022-09-01 06:26:02','2022-09-02 06:26:02','888',0.00,0.00,'888','2022-09-01 19:52:05','888','2022-09-01 19:52:20',10,0),('1','274',107,'DAILY SHIFT ','2022-09-02','2022-09-02 06:23:13','2022-09-03 06:23:13','888',0.00,0.00,'888','2022-09-02 19:49:26','888','2022-09-02 19:49:50',10,0),('1','274',108,'DAILY SHIFT ','2022-09-03','2022-09-03 07:05:41','2022-09-04 07:05:41','888',0.00,0.00,'888','2022-09-03 08:08:58','888','2022-09-03 08:09:15',10,0),('1','274',109,'DAILY SHIFT','2022-09-03','2022-09-03 09:55:39','2022-09-04 09:55:39','888',0.00,0.00,'888','2022-09-03 19:37:21','888','2022-09-03 19:37:47',10,0),('1','274',110,'DAILY SHIFT ','2022-09-04','2022-09-04 06:29:28','2022-09-05 06:29:28','888',0.00,0.00,'888','2022-09-04 19:55:29','888','2022-09-04 19:55:53',10,0),('1','274',111,'DAILY SHIFT ','2022-09-05','2022-09-05 06:58:19','2022-09-06 06:58:19','888',0.00,0.00,'888','2022-09-05 20:00:32','888','2022-09-05 20:00:46',10,0),('1','274',112,'DAILY SHIFT ','2022-09-06','2022-09-06 05:53:53','2022-09-07 05:53:53','888',0.00,0.00,'888','2022-09-06 15:44:32','888','2022-09-06 15:45:03',10,0),('1','274',113,'DAILY SHIFT','2022-09-06','2022-09-06 15:54:18','2022-09-07 15:54:18','888',0.00,0.00,'888','2022-09-06 19:59:41','888','2022-09-06 19:59:58',10,0),('1','274',114,'DAILY SHIFT','2022-09-07','2022-09-07 06:13:24','2022-09-08 06:13:24','888',0.00,0.00,'888','2022-09-07 19:31:07','888','2022-09-07 19:31:29',10,0),('1','274',115,'DAILY SHIFT ','2022-09-08','2022-09-08 06:32:33','2022-09-09 06:32:33','888',0.00,0.00,'888','2022-09-08 19:52:33','888','2022-09-08 19:52:48',10,0),('1','274',116,'DAILY SHIFT ','2022-09-09','2022-09-09 06:05:05','2022-09-10 06:05:05','888',0.00,0.00,'888','2022-09-09 19:43:12','888','2022-09-09 19:59:04',10,0),('1','274',117,'DAILY SHIFT ','2022-09-10','2022-09-10 06:13:05','2022-09-11 06:13:05','888',0.00,0.00,'888','2022-09-10 19:24:03','888','2022-09-10 19:24:20',10,0),('1','274',118,'DAILY SHIFT ','2022-09-11','2022-09-11 07:46:07','2022-09-12 07:46:07','888',0.00,0.00,'888','2022-09-11 19:21:28','888','2022-09-11 19:27:56',10,0),('1','274',119,'DAILY SHIFT ','2022-09-12','2022-09-12 06:16:02','2022-09-13 06:16:02','888',0.00,0.00,'888','2022-09-12 19:42:57','888','2022-09-12 19:43:20',10,0),('1','274',120,'DAILY SHIFT ','2022-09-13','2022-09-13 06:06:09','2022-09-14 06:06:09','888',0.00,0.00,'888','2022-09-13 10:46:24','888','2022-09-13 10:46:54',10,0),('1','274',121,'DAILY SHIFT','2022-09-13','2022-09-13 14:21:09','2022-09-14 14:21:09','888',0.00,0.00,'888','2022-09-13 19:54:18','888','2022-09-13 19:54:37',10,0),('1','274',122,'DAILY SHIFT ','2022-09-14','2022-09-14 06:25:52','2022-09-15 06:25:52','888',0.00,0.00,'888','2022-09-14 19:50:56','888','2022-09-14 19:51:48',10,0),('1','274',123,'DAILY SHIFT ','2022-09-15','2022-09-15 06:12:57','2022-09-16 06:12:57','888',0.00,0.00,'888','2022-09-15 20:16:55','888','2022-09-15 20:17:55',10,0),('1','274',124,'DAILY SHIFT ','2022-09-16','2022-09-16 06:13:35','2022-09-17 06:13:35','888',0.00,0.00,'888','2022-09-16 19:18:48','888','2022-09-16 21:23:42',10,0),('1','274',125,'DAILY SHIFT','2022-09-17','2022-09-17 06:56:34','2022-09-18 06:56:34','888',0.00,0.00,'888','2022-09-17 20:16:04','888','2022-09-17 20:16:21',10,0),('1','274',126,'DAILY SHIFT ','2022-09-18','2022-09-18 06:07:18','2022-09-19 06:07:18','888',0.00,0.00,'888','2022-09-18 19:19:07','888','2022-09-18 20:21:37',10,0),('1','274',127,'DAILY SHIFT','2022-09-19','2022-09-19 08:12:41','2022-09-20 08:12:41','888',0.00,0.00,'888','2022-09-19 14:30:36','888','2022-09-19 14:31:02',10,0),('1','274',128,'DAILY SHIFT','2022-09-21','2022-09-21 08:32:07','2022-09-22 08:32:07','888',0.00,0.00,'888','2022-09-21 19:37:52','888','2022-09-21 19:50:37',10,0),('1','274',129,'DAILY SHIFT','2022-09-22','2022-09-22 06:34:04','2022-09-23 06:34:04','888',0.00,0.00,'888','2022-09-22 19:37:22','888','2022-09-22 19:37:40',10,0),('1','274',130,'DAILY SHIFT','2022-09-23','2022-09-23 06:27:12','2022-09-24 06:27:12','888',0.00,0.00,'888','2022-09-23 19:32:45','888','2022-09-23 19:33:04',10,0),('1','274',131,'DAILY SHIFT','2022-09-24','2022-09-24 06:27:12','2022-09-25 06:27:12','888',0.00,0.00,'888','2022-09-24 19:21:52','888','2022-09-24 19:22:14',10,0),('1','274',132,'DAILY SHIFT','2022-09-25','2022-09-25 06:26:40','2022-09-26 06:26:40','888',0.00,0.00,'888','2022-09-25 19:19:46','888','2022-09-25 19:20:04',10,0),('1','274',133,'DAILY SHIFT','2022-09-26','2022-09-26 06:05:05','2022-09-27 06:05:05','888',0.00,0.00,'888','2022-09-26 19:05:17','888','2022-09-26 19:05:51',10,0),('1','274',134,'DAILY SHIFT ','2022-09-27','2022-09-27 06:23:27','2022-09-28 06:23:27','888',0.00,0.00,'888','2022-09-27 19:12:30','888','2022-09-27 19:12:50',10,0),('1','274',135,'DAILY SHIFT','2022-09-28','2022-09-28 06:40:02','2022-09-29 06:40:02','888',0.00,0.00,'888','2022-09-28 23:52:55','888','2022-09-28 23:53:40',10,0),('1','274',136,'DAILY SHIFT','2022-09-29','2022-09-29 06:24:57','2022-09-30 06:24:57','888',0.00,0.00,'888','2022-09-29 19:44:07','888','2022-09-29 19:44:35',10,0),('1','274',137,'DAILY SHIFT','2022-09-30','2022-09-30 06:17:41','2022-10-01 06:17:41','888',0.00,0.00,'888','2022-09-30 20:00:37','888','2022-09-30 20:01:07',10,0),('1','274',138,'DAILY SHIFT','2022-10-01','2022-10-01 06:26:17','2022-10-02 06:26:17','888',0.00,0.00,'888','2022-10-01 18:56:39','888','2022-10-01 18:57:02',10,0),('1','274',139,'DAILY SHIFT','2022-10-02','2022-10-02 06:47:06','2022-10-03 06:47:06','888',0.00,0.00,'888','2022-10-02 20:06:20','888','2022-10-02 20:06:41',10,0),('1','274',140,'DAILY SHIFT','2022-10-03','2022-10-03 06:16:59','2022-10-04 06:16:59','888',0.00,0.00,'888','2022-10-03 19:56:39','888','2022-10-03 19:56:55',10,0),('1','274',141,'DAILY SHIFT ','2022-10-04','2022-10-04 06:16:06','2022-10-05 06:16:06','888',0.00,0.00,'888','2022-10-04 08:57:37','888','2022-10-04 08:57:58',10,0),('1','274',142,'DAILY SHIFT','2022-10-06','2022-10-06 16:33:31','2022-10-07 16:33:31','888',0.00,0.00,'888','2022-10-06 19:19:37','888','2022-10-06 19:19:59',10,0),('1','274',143,'DAILY ','2022-10-07','2022-10-07 06:12:00','2022-10-08 06:12:00','888',0.00,0.00,'888','2022-10-07 19:55:59','888','2022-10-07 19:56:14',10,0),('1','274',144,'DAILY SHIFT ','2022-10-08','2022-10-08 06:23:03','2022-10-09 06:23:03','888',0.00,0.00,'888','2022-10-08 19:37:05','888','2022-10-08 19:37:21',10,0),('1','274',145,'DAILY SHIFT ','2022-10-09','2022-10-09 06:34:45','2022-10-10 06:34:45','888',0.00,0.00,'888','2022-10-09 09:21:58','888','2022-10-09 09:22:13',10,0),('1','274',146,'DAILY SHIFT','2022-10-10','2022-10-10 15:47:42','2022-10-11 15:47:42','888',0.00,0.00,'888','2022-10-10 19:26:36','888','2022-10-10 19:26:58',10,0),('1','274',147,'DAILY SHIFT ','2022-10-11','2022-10-11 06:06:37','2022-10-12 06:06:37','888',0.00,0.00,'888','2022-10-11 19:54:03','888','2022-10-11 19:55:01',10,0),('1','274',148,'DAILY SHIFT ','2022-10-12','2022-10-12 06:28:41','2022-10-13 06:28:41','888',0.00,0.00,'888','2022-10-12 19:13:48','888','2022-10-12 19:14:05',10,0),('1','274',149,'DAILY SHIFT ','2022-10-13','2022-10-13 06:06:20','2022-10-14 06:06:20','888',0.00,0.00,'888','2022-10-13 19:26:16','888','2022-10-13 19:26:32',10,0),('1','274',150,'DAILY SHIFT ','2022-10-14','2022-10-14 06:20:08','2022-10-15 06:20:08','888',0.00,0.00,'888','2022-10-14 18:55:28','888','2022-10-14 18:55:43',10,0),('1','274',151,'DAILY SHIFT ','2022-10-16','2022-10-16 06:06:21','2022-10-17 06:06:21','888',0.00,0.00,'888','2022-10-16 21:16:34','888','2022-10-16 21:16:51',10,0),('1','274',152,'DAILY SHIFT ','2022-10-17','2022-10-17 06:19:47','2022-10-18 06:19:47','888',0.00,0.00,'888','2022-10-17 19:27:26','888','2022-10-17 19:28:07',10,0),('1','274',153,'DAILY SHIFT ','2022-10-18','2022-10-18 06:24:44','2022-10-19 06:24:44','888',0.00,0.00,'888','2022-10-18 19:29:12','888','2022-10-18 19:30:23',10,0),('1','274',154,'DAILY SHIFT ','2022-10-19','2022-10-19 06:53:51','2022-10-20 06:53:51','888',0.00,0.00,'888','2022-10-19 13:53:59','888','2022-10-19 13:54:14',10,0),('1','274',155,'DAILY SHIFT','2022-10-19','2022-10-19 14:36:31','2022-10-20 14:36:31','888',0.00,0.00,'888','2022-10-19 14:59:53','888','2022-10-19 15:00:05',10,0),('1','274',156,'DAILY SHIFT','2022-10-19','2022-10-19 15:08:28','2022-10-20 15:08:28','888',0.00,0.00,'888','2022-10-19 20:06:59','888','2022-10-19 20:07:17',10,0),('1','274',157,'DAILY SHIFT ','2022-10-20','2022-10-20 06:37:20','2022-10-21 06:37:20','888',0.00,0.00,'888','2022-10-20 19:29:55','888','2022-10-20 19:32:39',10,0),('1','274',158,'DAILY SHIFT','2022-10-21','2022-10-21 09:10:12','2022-10-22 09:10:12','888',0.00,0.00,'888','2022-10-21 19:33:45','888','2022-10-21 19:34:25',10,0),('1','274',159,'DAILY SHIFT ','2022-10-22','2022-10-22 06:53:47','2022-10-23 06:53:47','888',0.00,0.00,'888','2022-10-22 19:21:44','888','2022-10-22 19:22:15',10,0),('1','274',160,'DAILY SHIFT ','2022-10-23','2022-10-23 06:28:22','2022-10-24 06:28:22','888',0.00,0.00,'888','2022-10-23 19:06:41','888','2022-10-23 19:06:59',10,0),('1','274',161,'DAILY SHIFT ','2022-10-24','2022-10-24 07:26:58','2022-10-25 07:26:58','888',0.00,0.00,'888','2022-10-24 16:41:39','888','2022-10-24 16:41:53',10,0),('1','274',162,'DAILY SHIFTS','2022-10-24','2022-10-24 17:09:24','2022-10-25 17:09:24','888',0.00,0.00,'888','2022-10-24 17:18:08','888','2022-10-24 17:18:29',10,0),('1','274',163,'DAILY SHIFT','2022-10-25','2022-10-25 06:52:00','2022-10-26 06:52:00','888',0.00,0.00,'888','2022-10-25 19:59:20','888','2022-10-25 19:59:40',10,0),('1','274',164,'DAILY SHIFT ','2022-10-26','2022-10-26 06:21:08','2022-10-27 06:21:08','888',0.00,0.00,'888','2022-10-26 19:04:49','888','2022-10-26 19:05:54',10,0),('1','274',165,'DAILY SHIFT ','2022-10-27','2022-10-27 06:21:34','2022-10-28 06:21:34','888',0.00,0.00,'888','2022-10-27 20:00:26','888','2022-10-27 20:00:46',10,0),('1','274',166,'DAILY SHIFT ','2022-10-28','2022-10-28 06:31:02','2022-10-29 06:31:02','888',0.00,0.00,'888','2022-10-28 19:43:06','888','2022-10-28 19:43:21',10,0),('1','274',167,'DAILY SHIFT','2022-10-29','2022-10-29 06:23:32','2022-10-30 06:23:32','888',0.00,0.00,'888','2022-10-29 19:15:24','888','2022-10-29 19:15:44',10,0),('1','274',168,'DAILY SHIFT ','2022-10-30','2022-10-30 06:30:58','2022-10-31 06:30:58','888',0.00,0.00,'888','2022-10-30 19:17:13','888','2022-10-30 19:17:33',10,0),('1','274',169,'DAILY SHIFT','2022-11-04','2022-11-04 08:15:54','2022-11-05 08:15:54','888',0.00,0.00,'888','2022-11-04 19:11:43','888','2022-11-04 19:12:29',10,0),('1','274',170,'DAILY SHIFT ','2022-11-05','2022-11-05 07:57:47','2022-11-06 07:57:47','888',0.00,0.00,'888','2022-11-05 18:54:40','888','2022-11-05 18:55:25',10,0),('1','274',171,'DAILY SHIFT ','2022-11-06','2022-11-06 07:55:45','2022-11-07 07:55:45','888',0.00,0.00,'888','2022-11-06 19:01:58','888','2022-11-06 19:02:23',10,0),('1','274',172,'DAILY SHIFT ','2022-11-07','2022-11-07 06:51:59','2022-11-08 06:51:59','888',0.00,0.00,'888','2022-11-07 19:14:11','888','2022-11-07 19:14:26',10,0),('1','274',173,'DAILY SHIFT ','2022-11-08','2022-11-08 06:26:56','2022-11-09 06:26:56','888',0.00,0.00,'888','2022-11-08 19:25:15','888','2022-11-08 19:25:37',10,0),('1','274',174,'DAILY SHIFT ','2022-11-09','2022-11-09 06:13:30','2022-11-10 06:13:30','888',0.00,0.00,'888','2022-11-09 19:03:15','888','2022-11-09 19:03:55',10,0),('1','274',175,'DAILY SHIFT ','2022-11-10','2022-11-10 06:10:13','2022-11-11 06:10:13','888',0.00,0.00,'888','2022-11-10 17:20:40','888','2022-11-10 17:21:00',10,0),('1','274',176,'DAILY SHIFT ','2022-11-11','2022-11-11 08:13:08','2022-11-12 08:13:08','888',0.00,0.00,'888','2022-11-11 19:12:52','888','2022-11-12 00:17:54',10,0),('1','274',177,'DAILY SHIFT ','2022-11-12','2022-11-12 07:31:47','2022-11-13 07:31:47','888',0.00,0.00,'888','2022-11-12 19:00:45','888','2022-11-12 19:23:20',10,0),('1','274',178,'daily sales','2022-11-13','2022-11-13 08:22:48','2022-11-14 08:22:48','888',0.00,0.00,'888','2022-11-13 20:12:55','888','2022-11-13 20:13:25',10,0),('1','274',179,'DAILY SHIFT ','2022-11-14','2022-11-14 06:28:49','2022-11-15 06:28:49','888',0.00,0.00,'888','2022-11-14 18:49:54','888','2022-11-15 06:43:51',10,0),('1','274',180,'DAILY SHIFT ','2022-11-15','2022-11-15 06:44:52','2022-11-16 06:44:52','888',0.00,0.00,'888','2022-11-15 19:18:01','888','2022-11-15 19:18:53',10,0),('1','274',181,'DAILY SHIFT ','2022-11-16','2022-11-16 06:05:30','2022-11-17 06:05:30','888',0.00,0.00,'888','2022-11-16 19:42:44','888','2022-11-16 19:43:07',10,0),('1','274',182,'DAILY SHIFT ','2022-11-17','2022-11-17 05:56:47','2022-11-18 05:56:47','888',0.00,0.00,'888','2022-11-17 19:49:28','888','2022-11-17 19:49:58',10,0),('1','274',183,'DAILY SHIFT ','2022-11-18','2022-11-18 06:09:25','2022-11-19 06:09:25','888',0.00,0.00,'888','2022-11-18 10:32:48','888','2022-11-18 10:33:03',10,0),('1','274',184,'DAILY SHIFT','2022-11-18','2022-11-18 10:33:56','2022-11-19 10:33:56','888',0.00,0.00,'888','2022-11-18 19:57:44','888','2022-11-18 19:58:04',10,0),('1','274',185,'DAILY SHIFT ','2022-11-19','2022-11-19 06:28:57','2022-11-20 06:28:57','888',0.00,0.00,'888','2022-11-19 19:00:40','888','2022-11-19 19:00:57',10,0),('1','274',186,'DAILY SHIFT ','2022-11-20','2022-11-20 06:53:57','2022-11-21 06:53:57','888',0.00,0.00,'888','2022-11-20 23:13:43','888','2022-11-20 23:14:06',10,0),('1','274',187,'DAILY SHIFT ','2022-11-21','2022-11-21 06:07:08','2022-11-22 06:07:08','888',0.00,0.00,'888','2022-11-21 19:22:47','888','2022-11-21 19:23:09',10,0),('1','274',188,'DAILY SHIFT ','2022-11-22','2022-11-22 07:09:44','2022-11-23 07:09:44','888',0.00,0.00,'888','2022-11-22 19:21:02','888','2022-11-22 19:21:25',10,0),('1','274',189,'DAILY SHIFT ','2022-11-23','2022-11-23 05:47:36','2022-11-24 05:47:36','888',0.00,0.00,'888','2022-11-23 19:24:42','888','2022-11-23 19:25:06',10,0),('1','274',190,'DAILY SHIFT ','2022-11-24','2022-11-24 06:31:39','2022-11-25 06:31:39','888',0.00,0.00,'888','2022-11-24 16:43:30','888','2022-11-24 16:43:46',10,0),('1','274',191,'DAILY SHIFT ','2022-11-25','2022-11-25 08:02:55','2022-11-26 08:02:55','888',0.00,0.00,'888','2022-11-25 19:46:08','888','2022-11-25 19:46:39',10,0),('1','274',192,'DAILY SHIFT ','2022-11-26','2022-11-26 06:46:30','2022-11-27 06:46:30','888',0.00,0.00,'888','2022-11-26 19:10:02','888','2022-11-26 19:10:51',10,0),('1','274',193,'DAILY SHIFT ','2022-11-27','2022-11-27 06:11:12','2022-11-28 06:11:12','888',0.00,0.00,'888','2022-11-27 19:52:12','888','2022-11-27 19:52:34',10,0),('1','274',194,'DAILY SHIFT ','2022-11-28','2022-11-28 06:09:39','2022-11-29 06:09:39','888',0.00,0.00,'888','2022-11-28 19:11:32','888','2022-11-28 19:11:49',10,0),('1','274',195,'DAILY SHIFT ','2022-11-29','2022-11-29 06:21:58','2022-11-30 06:21:58','888',0.00,0.00,'888','2022-11-29 19:04:41','888','2022-11-29 19:05:01',10,0),('1','274',196,'DAILY SHIFT ','2022-11-30','2022-11-30 06:16:12','2022-12-01 06:16:12','888',0.00,0.00,'888','2022-11-30 19:07:52','888','2022-11-30 19:08:10',10,0),('1','274',197,'DAILY SHIFT ','2022-12-01','2022-12-01 06:29:33','2022-12-02 06:29:33','888',0.00,0.00,'888','2022-12-01 19:03:19','888','2022-12-01 19:03:41',10,0),('1','274',198,'DAILY SHIFT ','2022-12-02','2022-12-02 06:27:33','2022-12-03 06:27:33','888',0.00,0.00,'888','2022-12-02 18:56:06','888','2022-12-02 18:56:21',10,0),('1','274',199,'DAILY SHIFT ','2022-12-03','2022-12-03 07:35:11','2022-12-04 07:35:11','888',0.00,0.00,'888','2022-12-03 21:59:21','888','2022-12-03 22:00:22',10,0),('1','274',200,'DAILY SHIFT ','2022-12-04','2022-12-04 06:25:01','2022-12-05 06:25:01','888',0.00,0.00,'888','2022-12-04 19:17:19','888','2022-12-04 19:17:37',10,0),('1','274',201,'DAILY SHIFT ','2022-12-05','2022-12-05 07:01:11','2022-12-06 07:01:11','888',0.00,0.00,'888','2022-12-05 20:20:48','888','2022-12-05 20:21:12',10,0),('1','274',202,'DAILY SHIFT ','2022-12-06','2022-12-06 06:41:07','2022-12-07 06:41:07','888',0.00,0.00,'888','2022-12-06 20:39:02','888','2022-12-06 20:39:28',10,0),('1','274',203,'DAILY SHIFT ','2022-12-07','2022-12-07 06:41:05','2022-12-08 06:41:05','888',0.00,0.00,'888','2022-12-07 21:32:09','888','2022-12-07 21:32:25',10,0),('1','274',204,'DAILY SHIFT ','2022-12-08','2022-12-08 06:36:31','2022-12-09 06:36:31','888',0.00,0.00,'888','2022-12-08 19:48:31','888','2022-12-08 19:48:55',10,0),('1','274',205,'DAILY SHIFT ','2022-12-09','2022-12-09 07:17:16','2022-12-10 07:17:16','888',0.00,0.00,'888','2022-12-09 15:18:03','888','2022-12-09 15:18:21',10,0),('1','274',206,'DAILY SHIFT','2022-12-09','2022-12-09 17:25:45','2022-12-10 17:25:45','888',0.00,0.00,'888','2022-12-09 20:01:36','888','2022-12-09 20:03:02',10,0),('1','274',207,'DAILY SHIFT ','2022-12-10','2022-12-10 06:16:32','2022-12-11 06:16:32','888',0.00,0.00,'888','2022-12-10 19:41:48','888','2022-12-10 19:42:50',10,0),('1','274',208,'DAILY SHIFT ','2022-12-11','2022-12-11 06:49:02','2022-12-12 06:49:02','888',0.00,0.00,'888','2022-12-11 19:04:25','888','2022-12-11 19:04:43',10,0),('1','274',209,'DAILY SHIFT ','2022-12-12','2022-12-12 06:18:35','2022-12-13 06:18:35','888',0.00,0.00,'888','2022-12-12 18:58:28','888','2022-12-12 18:58:46',10,0),('1','274',210,'DAILY SHIFT ','2022-12-13','2022-12-13 06:43:00','2022-12-14 06:43:00','888',0.00,0.00,'888','2022-12-13 20:47:53','888','2022-12-13 20:48:18',10,0),('1','274',211,'DAILY SHIFT ','2022-12-14','2022-12-14 06:46:55','2022-12-15 06:46:55','888',0.00,0.00,'888','2022-12-14 20:45:12','888','2022-12-14 20:45:28',10,0),('1','274',212,'DAILY SHIFT ','2022-12-15','2022-12-15 06:05:48','2022-12-16 06:05:48','888',0.00,0.00,'888','2022-12-15 19:16:51','888','2022-12-15 19:17:10',10,0),('1','274',213,'DAILY SHIFT ','2022-12-16','2022-12-16 06:16:06','2022-12-17 06:16:06','888',0.00,0.00,'888','2022-12-16 19:16:14','888','2022-12-16 19:20:00',10,0),('1','274',214,'DAILY SHIFT ','2022-12-17','2022-12-17 09:06:13','2022-12-18 09:06:13','888',0.00,0.00,'888','2022-12-17 09:52:28','888','2022-12-17 09:53:05',10,0),('1','274',215,'DAILY SHIFT','2022-12-17','2022-12-17 09:54:48','2022-12-18 09:54:48','888',0.00,0.00,'888','2022-12-17 18:58:21','888','2022-12-17 18:58:40',10,0),('1','274',216,'DAILY SHIFT ','2022-12-18','2022-12-18 06:36:16','2022-12-19 06:36:16','888',0.00,0.00,'888','2022-12-18 20:32:47','888','2022-12-18 20:34:01',10,0),('1','274',217,'DAILY SHIFT ','2022-12-19','2022-12-19 06:50:04','2022-12-20 06:50:04','888',0.00,0.00,'888','2022-12-19 20:09:34','888','2022-12-19 20:09:54',10,0),('1','274',218,'DAILY SHIFT ','2022-12-20','2022-12-20 06:32:05','2022-12-21 06:32:05','888',0.00,0.00,'888','2022-12-20 19:42:40','888','2022-12-20 19:43:54',10,0),('1','274',219,'DAILY SHIFT ','2022-12-21','2022-12-21 06:51:00','2022-12-22 06:51:00','888',0.00,0.00,'888','2022-12-21 19:19:16','888','2022-12-21 19:19:44',10,0),('1','274',220,'DAILY SHIFT ','2022-12-22','2022-12-22 06:23:51','2022-12-23 06:23:51','888',0.00,0.00,'888','2022-12-22 19:03:52','888','2022-12-22 19:04:17',10,0),('1','274',221,'DAILY SHIFT ','2022-12-23','2022-12-23 06:13:11','2022-12-24 06:13:11','888',0.00,0.00,'888','2022-12-23 18:51:23','888','2022-12-23 18:51:45',10,0),('1','274',222,'DAILY SHIFT ','2022-12-24','2022-12-24 06:25:14','2022-12-25 06:25:14','888',0.00,0.00,'888','2022-12-24 11:08:47','888','2022-12-24 13:36:54',10,0),('1','274',223,'DAILY SHIFT','2022-12-24','2022-12-24 13:37:23','2022-12-25 13:37:23','888',0.00,0.00,'888','2022-12-24 18:56:06','888','2022-12-25 06:49:34',10,0),('1','274',224,'DAILY SHIFT ','2022-12-25','2022-12-25 06:50:08','2022-12-26 06:50:08','888',0.00,0.00,'888','2022-12-25 21:04:19','888','2022-12-25 21:04:39',10,0),('1','274',225,'DAILY SHIFT ','2022-12-26','2022-12-26 06:42:58','2022-12-27 06:42:58','888',0.00,0.00,'888','2022-12-26 19:08:21','888','2022-12-27 07:53:00',10,0),('1','274',226,'DAILY SHIFT ','2022-12-27','2022-12-27 07:53:29','2022-12-28 07:53:29','888',0.00,0.00,'888','2022-12-27 21:07:57','888','2022-12-27 21:08:33',10,0),('1','274',227,'DAILY SHIFT','2022-12-28','2022-12-28 06:57:17','2022-12-29 06:57:17','888',0.00,0.00,'888','2022-12-28 19:17:01','888','2022-12-28 19:17:27',10,0),('1','274',228,'DAILY SHIFT','2022-12-29','2022-12-29 06:57:55','2022-12-30 06:57:55','888',0.00,0.00,'888','2022-12-29 19:18:24','888','2022-12-30 06:51:09',10,0),('1','274',229,'DAILY SHIFT','2022-12-30','2022-12-30 06:52:15','2022-12-31 06:52:15','888',0.00,0.00,'888','2022-12-30 19:19:49','888','2022-12-30 19:51:38',10,0),('1','274',230,'DAILY SHIFT ','2022-12-31','2022-12-31 06:35:21','2023-01-01 06:35:21','888',0.00,0.00,'888','2022-12-31 20:49:55','888','2022-12-31 20:50:37',10,0),('1','274',231,'DAILY SHIFT','2023-01-01','2023-01-01 06:55:35','2023-01-02 06:55:35','888',0.00,0.00,'888','2023-01-01 12:11:46','888','2023-01-01 12:13:32',10,0),('1','274',232,'DAILY SALES','2023-01-01','2023-01-01 12:14:35','2023-01-02 12:14:35','888',0.00,0.00,'888','2023-01-01 21:10:05','888','2023-01-01 21:10:25',10,0),('1','274',233,'DAILY SHIFT','2023-01-02','2023-01-02 09:53:38','2023-01-03 09:53:38','888',0.00,0.00,'888','2023-01-02 19:13:40','888','2023-01-02 19:13:59',10,0),('1','274',234,'DAILY SHIFT ','2023-01-03','2023-01-03 07:36:12','2023-01-04 07:36:12','888',0.00,0.00,'888','2023-01-03 19:21:54','888','2023-01-04 06:17:50',10,0),('1','274',235,'DAILY SHIFT ','2023-01-04','2023-01-04 06:18:19','2023-01-05 06:18:19','888',0.00,0.00,'888','2023-01-04 20:36:50','888','2023-01-04 20:37:08',10,0),('1','274',236,'DAILY SHIFT ','2023-01-05','2023-01-05 07:10:45','2023-01-06 07:10:45','888',0.00,0.00,'888','2023-01-05 19:55:15','888','2023-01-05 19:55:34',10,0),('1','274',237,'DAILY SHIFT ','2023-01-06','2023-01-06 06:12:07','2023-01-07 06:12:07','888',0.00,0.00,'888','2023-01-06 18:50:16','888','2023-01-06 19:07:19',10,0),('1','274',238,'DAILY SHIFT ','2023-01-07','2023-01-07 07:01:17','2023-01-08 07:01:17','888',0.00,0.00,'888','2023-01-07 19:29:38','888','2023-01-07 19:29:59',10,0),('1','274',239,'DAILY SHIFT ','2023-01-08','2023-01-08 06:46:30','2023-01-09 06:46:30','888',0.00,0.00,'888','2023-01-08 14:32:54','888','2023-01-08 14:33:28',10,0),('1','274',240,'DAILY SHIFT','2023-01-08','2023-01-08 14:33:49','2023-01-09 14:33:49','888',0.00,0.00,'888','2023-01-08 19:00:27','888','2023-01-08 19:00:52',10,0),('1','274',241,'DAILY SHIFT ','2023-01-09','2023-01-09 06:55:52','2023-01-10 06:55:52','888',0.00,0.00,'888','2023-01-09 20:04:39','888','2023-01-09 20:05:11',10,0),('1','274',242,'DAILY SHIFT ','2023-01-10','2023-01-10 06:41:59','2023-01-11 06:41:59','888',0.00,0.00,'888','2023-01-10 19:28:41','888','2023-01-10 19:29:17',10,0),('1','274',243,'DAILY SHIFT ','2023-01-11','2023-01-11 06:33:06','2023-01-12 06:33:06','888',0.00,0.00,'888','2023-01-11 19:29:53','888','2023-01-11 19:30:19',10,0),('1','274',244,'DAILY SHIFT ','2023-01-12','2023-01-12 06:21:17','2023-01-13 06:21:17','888',0.00,0.00,'888','2023-01-12 19:37:06','888','2023-01-12 19:38:39',10,0),('1','274',245,'DAILY SHIFT ','2023-01-13','2023-01-13 06:34:37','2023-01-14 06:34:37','888',0.00,0.00,'888','2023-01-13 19:16:48','888','2023-01-13 19:17:24',10,0),('1','274',246,'DAILY SHIFT ','2023-01-14','2023-01-14 06:54:55','2023-01-15 06:54:55','888',0.00,0.00,'888','2023-01-14 19:34:49','888','2023-01-14 19:35:06',10,0),('1','274',247,'DAILY SHIFT','2023-01-15','2023-01-15 19:23:32','2023-01-16 19:23:32','888',0.00,0.00,'888','2023-01-15 20:09:19','888','2023-01-15 20:09:44',10,0),('1','274',248,'DAILY SHIFT ','2023-01-16','2023-01-16 07:36:12','2023-01-17 07:36:12','888',0.00,0.00,'888','2023-01-16 19:44:07','888','2023-01-16 19:44:45',10,0),('1','274',249,'DAILY SHIFT ','2023-01-17','2023-01-17 06:33:11','2023-01-18 06:33:11','888',0.00,0.00,'888','2023-01-17 19:32:25','888','2023-01-17 19:32:43',10,0),('1','274',250,'DAILY SHIFT ','2023-01-18','2023-01-18 06:17:47','2023-01-19 06:17:47','888',0.00,0.00,'888','2023-01-18 19:23:13','888','2023-01-18 19:24:24',10,0),('1','274',251,'DAILY SHIFT ','2023-01-19','2023-01-19 07:21:49','2023-01-20 07:21:49','888',0.00,0.00,'888','2023-01-19 19:35:09','888','2023-01-19 19:35:27',10,0),('1','274',252,'DAILY SHIFT ','2023-01-20','2023-01-20 06:41:44','2023-01-21 06:41:44','888',0.00,0.00,'888','2023-01-20 19:22:46','888','2023-01-20 19:23:20',10,0),('1','274',253,'DAILY SHIFT ','2023-01-21','2023-01-21 08:55:56','2023-01-22 08:55:56','888',0.00,0.00,'888','2023-01-21 20:32:41','888','2023-01-21 20:33:02',10,0),('1','274',254,'DAILY SHIFT ','2023-01-22','2023-01-22 07:02:55','2023-01-23 07:02:55','888',0.00,0.00,'888','2023-01-22 18:10:35','888','2023-01-22 18:10:53',10,0),('1','274',255,'DAILY SHIFT ','2023-01-23','2023-01-23 06:23:26','2023-01-24 06:23:26','888',0.00,0.00,'888','2023-01-23 19:54:13','888','2023-01-23 19:54:30',10,0),('1','274',256,'DAILY SHIFT ','2023-01-24','2023-01-24 07:07:23','2023-01-25 07:07:23','888',0.00,0.00,'888','2023-01-24 20:00:18','888','2023-01-24 20:00:46',10,0),('1','274',257,'DAILY SHIFT ','2023-01-25','2023-01-25 06:31:31','2023-01-26 06:31:31','888',0.00,0.00,'888','2023-01-25 19:36:14','888','2023-01-25 19:36:43',10,0),('1','274',258,'DAILY SHIFT ','2023-01-26','2023-01-26 07:27:27','2023-01-27 07:27:27','888',0.00,0.00,'888','2023-01-26 20:07:47','888','2023-01-26 20:08:07',10,0),('1','274',259,'DAILY SHIFT ','2023-01-27','2023-01-27 06:32:18','2023-01-28 06:32:18','888',0.00,0.00,'888','2023-01-27 19:43:57','888','2023-01-28 06:36:16',10,0),('1','274',260,'DAILY SHIFT ','2023-01-28','2023-01-28 06:36:43','2023-01-29 06:36:43','888',0.00,0.00,'888','2023-01-28 19:27:46','888','2023-01-28 19:29:04',10,0),('1','274',261,'DAILY SHIFT ','2023-01-29','2023-01-29 06:59:32','2023-01-30 06:59:32','888',0.00,0.00,'888','2023-01-29 21:00:48','888','2023-01-29 21:01:48',10,0),('1','274',262,'DAILY SHIFT ','2023-01-30','2023-01-30 06:52:58','2023-01-31 06:52:58','888',0.00,0.00,'888','2023-01-30 20:28:29','888','2023-01-30 20:28:47',10,0),('1','274',263,'DAILY SHIFT ','2023-01-31','2023-01-31 07:16:49','2023-02-01 07:16:49','888',0.00,0.00,'888','2023-01-31 20:51:04','888','2023-01-31 21:19:57',10,0),('1','274',264,'DAILY SHIFT ','2023-02-01','2023-02-01 06:29:29','2023-02-02 06:29:29','888',0.00,0.00,'888','2023-02-01 19:27:51','888','2023-02-01 19:28:12',10,0),('1','274',265,'DAILY SHIFT ','2023-02-02','2023-02-02 07:04:55','2023-02-03 07:04:55','888',0.00,0.00,'888','2023-02-02 20:27:16','888','2023-02-02 20:27:33',10,0),('1','274',266,'DAILY SHIFT ','2023-02-03','2023-02-03 06:58:52','2023-02-04 06:58:52','888',0.00,0.00,'888','2023-02-03 19:31:53','888','2023-02-03 19:32:27',10,0),('1','274',267,'DAILY SHIFT ','2023-02-04','2023-02-04 07:09:47','2023-02-05 07:09:47','888',0.00,0.00,'888','2023-02-04 20:48:28','888','2023-02-04 20:48:49',10,0),('1','274',268,'DAILY SHIFT ','2023-02-05','2023-02-05 06:54:52','2023-02-06 06:54:52','888',0.00,0.00,'888','2023-02-05 20:36:10','888','2023-02-05 20:36:28',10,0),('1','274',269,'DAILY SHIFT','2023-02-06','2023-02-06 07:04:51','2023-02-07 07:04:51','888',0.00,0.00,'888','2023-02-06 19:43:03','888','2023-02-06 19:43:22',10,0),('1','274',270,'DAILY SHIFT ','2023-02-07','2023-02-07 07:22:11','2023-02-08 07:22:11','888',0.00,0.00,'888','2023-02-07 20:06:59','888','2023-02-07 20:07:32',10,0),('1','274',271,'DAILY SHIFT ','2023-02-08','2023-02-08 07:19:35','2023-02-09 07:19:35','888',0.00,0.00,'888','2023-02-08 19:31:55','888','2023-02-08 19:32:28',10,0),('1','274',272,'DAILY SHIFT ','2023-02-09','2023-02-09 06:35:56','2023-02-10 06:35:56','888',0.00,0.00,'888','2023-02-09 19:38:13','888','2023-02-09 19:38:41',10,0),('1','274',273,'DAILY SHIFT ','2023-02-10','2023-02-10 06:36:13','2023-02-11 06:36:13','888',0.00,0.00,'888','2023-02-10 19:29:18','888','2023-02-10 20:28:38',10,0),('1','274',274,'DAILY SHIFT ','2023-02-11','2023-02-11 07:43:11','2023-02-12 07:43:11','888',0.00,0.00,'888','2023-02-11 19:28:49','888','2023-02-11 20:51:57',10,0),('1','274',275,'DAILY SHIFT','2023-02-12','2023-02-12 06:31:28','2023-02-13 06:31:28','888',0.00,0.00,'888','2023-02-12 19:49:53','888','2023-02-12 19:50:48',10,0),('1','274',276,'DAILY SHIFT ','2023-02-13','2023-02-13 06:51:01','2023-02-14 06:51:01','888',0.00,0.00,'888','2023-02-13 22:38:04','888','2023-02-13 22:38:31',10,0),('1','274',277,'DAILY SHIFT ','2023-02-14','2023-02-14 06:45:09','2023-02-15 06:45:09','888',0.00,0.00,'888','2023-02-14 19:45:06','888','2023-02-14 19:46:18',10,0),('1','274',278,'DAILY SHIFT','2023-02-15','2023-02-15 06:47:47','2023-02-16 06:47:47','888',0.00,0.00,'888','2023-02-15 20:18:03','888','2023-02-15 20:18:42',10,0),('1','274',279,'DAILY SHIFT ','2023-02-16','2023-02-16 06:45:22','2023-02-17 06:45:22','888',0.00,0.00,'888','2023-02-16 19:36:03','888','2023-02-16 19:36:51',10,0),('1','274',280,'DAILY SHIFT ','2023-02-17','2023-02-17 06:53:35','2023-02-18 06:53:35','888',0.00,0.00,'888','2023-02-17 19:26:37','888','2023-02-17 21:11:06',10,0),('1','274',281,'DAILY SHIFT','2023-02-18','2023-02-18 06:52:58','2023-02-19 06:52:58','888',0.00,0.00,'888','2023-02-18 21:36:09','888','2023-02-18 21:36:50',10,0),('1','274',282,'DAILY SHIFT','2023-02-19','2023-02-19 06:50:14','2023-02-20 06:50:14','888',0.00,0.00,'888','2023-02-19 19:25:21','888','2023-02-19 20:59:11',10,0),('1','274',283,'DAILY SHIFT','2023-02-20','2023-02-20 06:58:07','2023-02-21 06:58:07','888',0.00,0.00,'888','2023-02-20 19:29:12','888','2023-02-20 19:29:38',10,0),('1','274',284,'DAILY SHIFT ','2023-02-21','2023-02-21 08:33:17','2023-02-22 08:33:17','888',0.00,0.00,'888','2023-02-21 09:32:59','888','2023-02-21 09:33:31',10,0),('1','274',285,'DAILY SHIFT ','2023-02-21','2023-02-21 10:02:36','2023-02-22 10:02:36','888',0.00,0.00,'888','2023-02-21 20:59:33','888','2023-02-21 20:59:52',10,0),('1','274',286,'DAILY SHIFT','2023-02-22','2023-02-22 07:15:29','2023-02-23 07:15:29','888',0.00,0.00,'888','2023-02-22 20:20:23','888','2023-02-22 20:20:47',10,0),('1','274',287,'DAILY SHIFT','2023-02-23','2023-02-23 06:49:18','2023-02-24 06:49:18','888',0.00,0.00,'888','2023-02-23 20:01:19','888','2023-02-23 20:15:33',10,0),('1','274',288,'DAILY SHIFT','2023-02-24','2023-02-24 06:49:11','2023-02-25 06:49:11','888',0.00,0.00,'888','2023-02-24 20:17:29','888','2023-02-24 20:18:21',10,0),('1','274',289,'DAILY SHIFT ','2023-02-26','2023-02-26 09:21:14','2023-02-27 09:21:14','888',0.00,0.00,'888','2023-02-26 19:37:35','888','2023-02-26 19:38:01',10,0),('1','274',290,'DAILY SHIFT ','2023-02-27','2023-02-27 06:31:05','2023-02-28 06:31:05','888',0.00,0.00,'888','2023-02-27 19:16:27','888','2023-02-27 19:39:26',10,0),('1','274',291,'DAILY SHIFT','2023-02-28','2023-02-28 07:01:10','2023-03-01 07:01:10','888',0.00,0.00,'888','2023-02-28 19:21:54','888','2023-02-28 21:29:59',10,0),('1','274',292,'DAILY SHIFT','2023-03-01','2023-03-01 06:18:46','2023-03-02 06:18:46','888',0.00,0.00,'888','2023-03-01 19:18:35','888','2023-03-01 21:22:36',10,0),('1','274',293,'DAILY SHIFT','2023-03-02','2023-03-02 06:46:42','2023-03-03 06:46:42','888',0.00,0.00,'888','2023-03-02 19:14:45','888','2023-03-02 21:03:23',10,0),('1','274',294,'DAILY SHIFT','2023-03-03','2023-03-03 07:19:52','2023-03-04 07:19:52','888',0.00,0.00,'888','2023-03-03 21:27:13','888','2023-03-03 21:27:43',10,0),('1','274',295,'DAILY SHIFT ','2023-03-04','2023-03-04 07:24:04','2023-03-05 07:24:04','888',0.00,0.00,'888','2023-03-04 09:06:24','888','2023-03-04 09:06:45',10,0),('1','274',296,'daily sales','2023-03-04','2023-03-04 09:07:11','2023-03-05 09:07:11','888',0.00,0.00,'888','2023-03-04 19:59:18','888','2023-03-04 19:59:38',10,0),('1','274',297,'DAILY SHIFT','2023-03-05','2023-03-05 08:12:54','2023-03-06 08:12:54','888',0.00,0.00,'888','2023-03-05 19:58:36','888','2023-03-05 19:59:04',10,0),('1','274',298,'DAILY SHIFT','2023-03-06','2023-03-06 06:38:43','2023-03-07 06:38:43','888',0.00,0.00,'888','2023-03-06 20:18:25','888','2023-03-06 20:22:45',10,0),('1','274',299,'DAILY SHIFT ','2023-03-07','2023-03-07 07:20:04','2023-03-08 07:20:04','888',0.00,0.00,'888','2023-03-07 21:15:29','888','2023-03-07 21:17:13',10,0),('1','274',300,'DAILY SHIFT ','2023-03-08','2023-03-08 07:08:42','2023-03-09 07:08:42','888',0.00,0.00,'888','2023-03-08 21:19:12','888','2023-03-08 21:19:28',10,0),('1','274',301,'DAILY SHIFT ','2023-03-09','2023-03-09 07:00:28','2023-03-10 07:00:28','888',0.00,0.00,'888','2023-03-09 21:30:54','888','2023-03-09 21:31:09',10,0),('1','274',302,'DAILY SHIFT ','2023-03-10','2023-03-10 07:10:34','2023-03-11 07:10:34','888',0.00,0.00,'888','2023-03-10 20:35:17','888','2023-03-10 20:36:00',10,0),('1','274',303,'DAILY SHIFT','2023-03-11','2023-03-11 06:42:34','2023-03-12 06:42:34','888',0.00,0.00,'888','2023-03-11 21:15:52','888','2023-03-11 21:17:02',10,0),('1','274',304,'DAILY SHIFT ','2023-03-12','2023-03-12 06:38:41','2023-03-13 06:38:41','888',0.00,0.00,'888','2023-03-12 21:14:46','888','2023-03-12 21:15:26',10,0),('1','274',305,'DAILY SHIFT ','2023-03-13','2023-03-13 07:45:10','2023-03-14 07:45:10','888',0.00,0.00,'888','2023-03-13 20:46:09','888','2023-03-13 20:46:32',10,0),('1','274',306,'DAILY SHIFT ','2023-03-14','2023-03-14 06:27:33','2023-03-15 06:27:33','888',0.00,0.00,'888','2023-03-14 17:58:31','888','2023-03-14 17:59:00',10,0),('1','274',307,'DAILY SHIFT ','2023-03-14','2023-03-14 17:59:38','2023-03-15 17:59:38','888',0.00,0.00,'888','2023-03-14 21:15:17','888','2023-03-14 21:15:43',10,0),('1','274',308,'DAILY SHIFT ','2023-03-15','2023-03-15 06:33:28','2023-03-16 06:33:28','888',0.00,0.00,'888','2023-03-15 19:57:39','888','2023-03-15 19:57:58',10,0),('1','274',309,'DAILY SHIFT ','2023-03-16','2023-03-16 06:54:44','2023-03-17 06:54:44','888',0.00,0.00,'888','2023-03-16 20:12:31','888','2023-03-16 20:12:48',10,0),('1','274',310,'DAILY SHIFT ','2023-03-17','2023-03-17 07:15:59','2023-03-18 07:15:59','888',0.00,0.00,'888','2023-03-17 20:09:09','888','2023-03-17 20:09:28',10,0),('1','274',311,'DAILY SHIFT ','2023-03-18','2023-03-18 06:28:19','2023-03-19 06:28:19','888',0.00,0.00,'888','2023-03-18 19:57:22','888','2023-03-18 20:09:27',10,0),('1','274',312,'DAILY SHIFT ','2023-03-19','2023-03-19 06:37:01','2023-03-20 06:37:01','888',0.00,0.00,'888','2023-03-19 20:22:46','888','2023-03-19 20:23:01',10,0),('1','274',313,'DAILY SHIFT ','2023-03-20','2023-03-20 06:25:11','2023-03-21 06:25:11','888',0.00,0.00,'888','2023-03-20 19:59:17','888','2023-03-20 20:17:10',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=627 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','274','1','1',1,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','274','1','1',2,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','274','1','2',3,'1','1',0.00,115.42,0.00,0.00,115.42,81255.68,0.00,0.00,0.00),('1','274','1','2',4,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','274','1','3',5,'1','1',115.42,413.30,0.00,0.00,297.88,209707.52,0.00,0.00,0.00),('1','274','1','3',6,'2','1',0.00,81.58,0.00,0.00,81.58,57432.32,0.00,0.00,0.00),('1','274','1','4',7,'1','1',413.30,877.19,0.00,0.00,463.89,326578.56,0.00,0.00,0.00),('1','274','1','4',8,'2','1',81.58,387.81,0.00,0.00,306.23,215585.92,0.00,0.00,0.00),('1','274','1','5',9,'1','1',877.19,1256.46,0.00,0.00,379.27,267006.08,0.00,0.00,0.00),('1','274','1','5',10,'2','1',387.81,524.45,0.00,0.00,136.64,96194.56,0.00,0.00,0.00),('1','274','1','6',11,'1','1',1256.46,1337.51,0.00,0.00,81.05,60301.20,0.00,0.00,0.00),('1','274','1','6',12,'2','1',524.45,1010.38,0.00,0.00,485.93,361531.92,0.00,0.00,0.00),('1','274','1','7',13,'1','1',1337.51,1379.99,0.00,0.00,42.48,31605.12,0.00,0.00,0.00),('1','274','1','7',14,'2','1',1010.38,1599.36,0.00,0.00,588.98,438201.12,0.00,0.00,0.00),('1','274','1','8',15,'1','1',1379.99,1720.01,0.00,0.00,340.02,252974.88,0.00,0.00,0.00),('1','274','1','8',16,'2','1',1599.36,1764.47,0.00,0.00,165.11,122841.84,0.00,0.00,0.00),('1','274','1','9',17,'1','1',1720.01,1720.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','274','1','9',18,'2','1',1764.47,1764.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','274','1','10',19,'1','1',2588.10,2947.49,0.00,0.00,359.39,267386.16,0.00,0.00,0.00),('1','274','1','10',20,'2','1',908.51,995.70,0.00,0.00,87.19,64869.36,0.00,0.00,0.00),('1','274','1','11',21,'1','1',2947.49,3399.15,0.00,0.00,451.66,336035.04,0.00,0.00,0.00),('1','274','1','11',22,'2','1',995.70,1249.53,0.00,0.00,253.83,188849.52,0.00,0.00,0.00),('1','274','1','12',23,'1','1',3399.15,3709.28,0.00,0.00,310.13,230736.72,0.00,0.00,0.00),('1','274','1','12',24,'2','1',1249.53,1450.11,0.00,0.00,200.58,149231.52,0.00,0.00,0.00),('1','274','1','13',25,'1','1',3709.28,4048.62,0.00,0.00,339.34,252468.96,0.00,0.00,0.00),('1','274','1','13',26,'2','1',1450.11,1563.32,0.00,0.00,113.21,84228.24,0.00,0.00,0.00),('1','274','1','14',27,'1','1',4048.62,4556.32,0.00,0.00,507.70,377728.80,0.00,0.00,0.00),('1','274','1','14',28,'2','1',1563.32,1740.08,0.00,0.00,176.76,131509.44,0.00,0.00,0.00),('1','274','1','15',29,'1','1',4556.32,4851.90,0.00,0.00,295.58,219911.52,0.00,0.00,0.00),('1','274','1','15',30,'2','1',1740.08,1852.52,0.00,0.00,112.44,83655.36,0.00,0.00,0.00),('1','274','1','16',31,'1','1',4851.90,4988.70,0.00,0.00,136.80,101779.20,0.00,0.00,0.00),('1','274','1','16',32,'2','1',1852.52,1868.43,0.00,0.00,15.91,11837.04,0.00,0.00,0.00),('1','274','1','17',33,'1','1',4988.70,5307.08,0.00,0.00,318.38,236874.72,0.00,0.00,0.00),('1','274','1','17',34,'2','1',1868.43,2051.82,0.00,0.00,183.39,136442.16,0.00,0.00,0.00),('1','274','1','18',35,'1','1',5307.08,6086.73,0.00,0.00,779.65,580059.60,0.00,0.00,0.00),('1','274','1','18',36,'2','1',2051.82,2627.87,0.00,0.00,576.05,428581.20,0.00,0.00,0.00),('1','274','1','19',37,'1','1',6086.73,6552.81,0.00,0.00,466.08,346763.52,0.00,0.00,0.00),('1','274','1','19',38,'2','1',2627.87,2954.20,0.00,0.00,326.33,242789.52,0.00,0.00,0.00),('1','274','1','20',39,'1','1',6552.81,7023.32,0.00,0.00,470.51,350059.44,0.00,0.00,0.00),('1','274','1','20',40,'2','1',2954.20,3185.90,0.00,0.00,231.70,172384.80,0.00,0.00,0.00),('1','274','1','21',41,'1','1',7023.32,7393.62,0.00,0.00,370.30,275503.20,0.00,0.00,0.00),('1','274','1','21',42,'2','1',3185.90,3307.02,0.00,0.00,121.12,90113.28,0.00,0.00,0.00),('1','274','1','22',43,'1','1',7393.62,7856.65,0.00,0.00,463.03,344494.32,0.00,0.00,0.00),('1','274','1','22',44,'2','1',3307.02,3656.68,0.00,0.00,349.66,260147.04,0.00,0.00,0.00),('1','274','1','23',45,'1','1',7856.65,8237.72,0.00,0.00,381.07,283516.08,0.00,0.00,0.00),('1','274','1','23',46,'2','1',3656.68,4124.26,0.00,0.00,467.58,347879.52,0.00,0.00,0.00),('1','274','1','24',47,'1','1',8237.72,9024.36,0.00,0.00,786.64,585260.16,0.00,0.00,0.00),('1','274','1','24',48,'2','1',4124.26,4555.36,0.00,0.00,431.10,320738.40,0.00,0.00,0.00),('1','274','1','25',49,'1','1',9024.36,9717.53,0.00,0.00,693.17,515718.48,0.00,0.00,0.00),('1','274','1','25',50,'2','1',4555.36,4876.30,0.00,0.00,320.94,238779.36,0.00,0.00,0.00),('1','274','1','26',51,'1','1',9717.53,10221.37,0.00,0.00,503.84,374856.96,0.00,0.00,0.00),('1','274','1','26',52,'2','1',4876.30,5127.09,0.00,0.00,250.79,186587.76,0.00,0.00,0.00),('1','274','1','27',53,'1','1',10221.37,10400.54,0.00,0.00,179.17,133302.48,0.00,0.00,0.00),('1','274','1','27',54,'2','1',5127.09,5239.13,0.00,0.00,112.04,83357.76,0.00,0.00,0.00),('1','274','1','28',55,'1','1',10400.54,10498.38,0.00,0.00,97.84,72792.96,0.00,0.00,0.00),('1','274','1','28',56,'2','1',5239.13,5309.09,0.00,0.00,69.96,52050.24,0.00,0.00,0.00),('1','274','1','29',57,'1','1',10498.38,11234.69,0.00,0.00,736.31,547814.64,0.00,0.00,0.00),('1','274','1','29',58,'2','1',5309.09,5497.93,0.00,0.00,188.84,140496.96,0.00,0.00,0.00),('1','274','1','30',59,'1','1',11234.69,11607.40,0.00,0.00,372.71,277296.24,0.00,0.00,0.00),('1','274','1','30',60,'2','1',5497.93,5596.92,0.00,0.00,98.99,73648.56,0.00,0.00,0.00),('1','274','1','31',61,'1','1',11607.40,11990.18,0.00,0.00,382.78,284788.32,0.00,0.00,0.00),('1','274','1','31',62,'2','1',5596.92,5645.10,0.00,0.00,48.18,35845.92,0.00,0.00,0.00),('1','274','1','32',63,'1','1',11990.18,12420.23,0.00,0.00,430.05,319957.20,0.00,0.00,0.00),('1','274','1','32',64,'2','1',5645.10,5745.47,0.00,0.00,100.37,74675.28,0.00,0.00,0.00),('1','274','1','33',65,'1','1',12420.23,12987.60,0.00,0.00,567.37,422123.28,0.00,0.00,0.00),('1','274','1','33',66,'2','1',5745.47,5875.81,0.00,0.00,130.34,96972.96,0.00,0.00,0.00),('1','274','1','34',67,'1','1',12987.60,13272.43,0.00,0.00,284.83,211913.52,0.00,0.00,0.00),('1','274','1','34',68,'2','1',5875.81,6154.05,0.00,0.00,278.24,207010.56,0.00,0.00,0.00),('1','274','1','35',69,'1','1',13272.43,13751.32,0.00,0.00,478.89,356294.16,0.00,0.00,0.00),('1','274','1','35',70,'2','1',6154.05,6279.15,0.00,0.00,125.10,93074.40,0.00,0.00,0.00),('1','274','1','36',71,'1','1',13751.32,14096.26,0.00,0.00,344.94,256635.36,0.00,0.00,0.00),('1','274','1','36',72,'2','1',6279.15,6403.41,0.00,0.00,124.26,92449.44,0.00,0.00,0.00),('1','274','1','37',73,'1','1',14096.26,14096.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','274','1','37',74,'2','1',6403.41,6403.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','274','1','38',75,'1','1',14096.26,14201.19,0.00,0.00,104.93,78067.92,0.00,0.00,0.00),('1','274','1','38',76,'2','1',6403.41,6444.05,0.00,0.00,40.64,30236.16,0.00,0.00,0.00),('1','274','1','39',77,'1','1',14201.19,14506.20,0.00,0.00,305.01,226927.44,0.00,0.00,0.00),('1','274','1','39',78,'2','1',6444.05,6556.53,0.00,0.00,112.48,83685.12,0.00,0.00,0.00),('1','274','1','40',79,'1','1',14506.20,14845.22,0.00,0.00,339.02,252230.88,0.00,0.00,0.00),('1','274','1','40',80,'2','1',6556.53,6743.45,0.00,0.00,186.92,139068.48,0.00,0.00,0.00),('1','274','1','41',81,'1','1',14845.22,15427.57,0.00,0.00,582.35,433268.40,0.00,0.00,0.00),('1','274','1','41',82,'2','1',6743.45,6827.55,0.00,0.00,84.10,62570.40,0.00,0.00,0.00),('1','274','1','42',83,'1','1',15427.57,15907.70,0.00,0.00,480.13,357216.72,0.00,0.00,0.00),('1','274','1','42',84,'2','1',6827.55,6966.51,0.00,0.00,138.96,103386.24,0.00,0.00,0.00),('1','274','1','43',85,'1','1',15907.70,16682.50,0.00,0.00,774.80,576451.20,0.00,0.00,0.00),('1','274','1','43',86,'2','1',6966.51,6968.23,0.00,0.00,1.72,1279.68,0.00,0.00,0.00),('1','274','1','44',87,'1','1',16682.50,17260.93,0.00,0.00,578.43,430351.92,0.00,0.00,0.00),('1','274','1','44',88,'2','1',6968.23,7030.73,0.00,0.00,62.50,46500.00,0.00,0.00,0.00),('1','274','1','45',89,'1','1',17260.93,17727.32,0.00,0.00,466.39,346994.16,0.00,0.00,0.00),('1','274','1','45',90,'2','1',7030.73,7030.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','274','1','46',91,'1','1',17727.32,18277.59,0.00,0.00,550.27,409400.88,0.00,0.00,0.00),('1','274','1','46',92,'2','1',7030.73,7072.54,0.00,0.00,41.81,31106.64,0.00,0.00,0.00),('1','274','1','47',93,'1','1',18277.59,18736.19,0.00,0.00,458.60,341198.40,0.00,0.00,0.00),('1','274','1','47',94,'2','1',7072.54,7257.98,0.00,0.00,185.44,137967.36,0.00,0.00,0.00),('1','274','1','48',95,'1','1',18736.19,19111.08,0.00,0.00,374.89,278918.16,0.00,0.00,0.00),('1','274','1','48',96,'2','1',7257.98,7458.01,0.00,0.00,200.03,148822.32,0.00,0.00,0.00),('1','274','1','49',97,'1','1',19111.08,19755.43,0.00,0.00,644.35,479396.40,0.00,0.00,0.00),('1','274','1','49',98,'2','1',7458.01,7560.50,0.00,0.00,102.49,76252.56,0.00,0.00,0.00),('1','274','1','50',99,'1','1',19755.43,20088.32,0.00,0.00,332.89,247670.16,0.00,0.00,0.00),('1','274','1','50',100,'2','1',7560.50,7617.24,0.00,0.00,56.74,42214.56,0.00,0.00,0.00),('1','274','1','51',101,'1','1',20088.32,20455.18,0.00,0.00,366.86,272943.84,0.00,0.00,0.00),('1','274','1','51',102,'2','1',7617.24,7671.32,0.00,0.00,54.08,40235.52,0.00,0.00,0.00),('1','274','1','52',103,'1','1',20455.18,20816.56,0.00,0.00,361.38,268866.72,0.00,0.00,0.00),('1','274','1','52',104,'2','1',7671.32,7696.52,0.00,0.00,25.20,18748.80,0.00,0.00,0.00),('1','274','1','53',105,'1','1',20816.56,21237.49,0.00,0.00,420.93,313171.92,0.00,0.00,0.00),('1','274','1','53',106,'2','1',7696.52,7764.16,0.00,0.00,67.64,50324.16,0.00,0.00,0.00),('1','274','1','54',107,'1','1',21237.49,21686.51,0.00,0.00,449.02,334070.88,0.00,0.00,0.00),('1','274','1','54',108,'2','1',7764.16,7792.88,0.00,0.00,28.72,21367.68,0.00,0.00,0.00),('1','274','1','55',109,'1','1',21686.51,22154.12,0.00,0.00,467.61,347901.84,0.00,0.00,0.00),('1','274','1','55',110,'2','1',7792.88,7844.03,0.00,0.00,51.15,38055.60,0.00,0.00,0.00),('1','274','1','56',111,'1','1',22154.12,22845.93,0.00,0.00,691.81,514706.64,0.00,0.00,0.00),('1','274','1','56',112,'2','1',7844.03,7997.55,0.00,0.00,153.52,114218.88,0.00,0.00,0.00),('1','274','1','57',113,'1','1',22845.93,23138.23,0.00,0.00,292.30,217471.20,0.00,0.00,0.00),('1','274','1','57',114,'2','1',7997.55,8012.99,0.00,0.00,15.44,11487.36,0.00,0.00,0.00),('1','274','1','58',115,'1','1',23138.23,23352.40,0.00,0.00,214.17,159342.48,0.00,0.00,0.00),('1','274','1','58',116,'2','1',8012.99,8025.63,0.00,0.00,12.64,9404.16,0.00,0.00,0.00),('1','274','1','59',117,'1','1',23352.40,23860.16,0.00,0.00,507.76,377773.44,0.00,0.00,0.00),('1','274','1','59',118,'2','1',8025.63,8115.68,0.00,0.00,90.05,66997.20,0.00,0.00,0.00),('1','274','1','60',119,'1','1',23860.16,24442.20,0.00,0.00,582.04,433037.76,0.00,0.00,0.00),('1','274','1','60',120,'2','1',8115.68,8263.61,0.00,0.00,147.93,110059.92,0.00,0.00,0.00),('1','274','1','61',121,'1','1',24442.20,24959.93,0.00,0.00,517.73,385191.12,0.00,0.00,0.00),('1','274','1','61',122,'2','1',8263.61,8345.63,0.00,0.00,82.02,61022.88,0.00,0.00,0.00),('1','274','1','62',123,'1','1',24959.93,25475.56,0.00,0.00,515.63,383628.72,0.00,0.00,0.00),('1','274','1','62',124,'2','1',8345.63,8415.68,0.00,0.00,70.05,52117.20,0.00,0.00,0.00),('1','274','1','63',125,'1','1',25475.56,26016.27,0.00,0.00,540.71,402288.24,0.00,0.00,0.00),('1','274','1','63',126,'2','1',8415.68,8445.04,0.00,0.00,29.36,21843.84,0.00,0.00,0.00),('1','274','1','64',127,'1','1',26016.27,26754.46,0.00,0.00,738.19,549213.36,0.00,0.00,0.00),('1','274','1','64',128,'2','1',8445.04,8583.09,0.00,0.00,138.05,102709.20,0.00,0.00,0.00),('1','274','1','65',129,'1','1',26754.46,27288.74,0.00,0.00,534.28,397504.32,0.00,0.00,0.00),('1','274','1','65',130,'2','1',8583.09,8616.57,0.00,0.00,33.48,24909.12,0.00,0.00,0.00),('1','274','1','66',131,'1','1',27288.74,27903.92,0.00,0.00,615.18,457693.92,0.00,0.00,0.00),('1','274','1','66',132,'2','1',8616.57,8657.09,0.00,0.00,40.52,30146.88,0.00,0.00,0.00),('1','274','1','67',133,'1','1',27903.92,28389.22,0.00,0.00,485.30,361063.20,0.00,0.00,0.00),('1','274','1','67',134,'2','1',8657.09,8657.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','274','1','68',135,'1','1',28389.22,28929.29,0.00,0.00,540.07,401812.08,0.00,0.00,0.00),('1','274','1','68',136,'2','1',8657.09,8672.51,0.00,0.00,15.42,11472.48,0.00,0.00,0.00),('1','274','1','69',137,'1','1',28929.29,29435.40,0.00,0.00,506.11,376545.84,0.00,0.00,0.00),('1','274','1','69',138,'2','1',8672.51,8749.31,0.00,0.00,76.80,57139.20,0.00,0.00,0.00),('1','274','1','70',139,'1','1',29435.40,29886.47,0.00,0.00,451.07,335596.08,0.00,0.00,0.00),('1','274','1','70',140,'2','1',8749.31,8839.83,0.00,0.00,90.52,67346.88,0.00,0.00,0.00),('1','274','1','71',141,'1','1',29886.47,30445.26,0.00,0.00,558.79,415739.76,0.00,0.00,0.00),('1','274','1','71',142,'2','1',8839.83,9206.85,0.00,0.00,367.02,273062.88,0.00,0.00,0.00),('1','274','1','72',143,'1','1',30445.26,30885.84,0.00,0.00,440.58,327791.52,0.00,0.00,0.00),('1','274','1','72',144,'2','1',9206.85,9446.02,0.00,0.00,239.17,177942.48,0.00,0.00,0.00),('1','274','1','73',145,'1','1',30885.84,31429.00,0.00,0.00,543.16,404111.04,0.00,0.00,0.00),('1','274','1','73',146,'2','1',9446.02,9490.78,0.00,0.00,44.76,33301.44,0.00,0.00,0.00),('1','274','1','74',147,'1','1',31429.00,32149.23,0.00,0.00,720.23,535851.12,0.00,0.00,0.00),('1','274','1','74',148,'2','1',9490.78,9710.03,0.00,0.00,219.25,163122.00,0.00,0.00,0.00),('1','274','1','75',149,'1','1',32149.23,32537.85,0.00,0.00,388.62,289133.28,0.00,0.00,0.00),('1','274','1','75',150,'2','1',9710.03,9764.53,0.00,0.00,54.50,40548.00,0.00,0.00,0.00),('1','274','1','76',151,'1','1',32537.85,32755.78,0.00,0.00,217.93,162139.92,0.00,0.00,0.00),('1','274','1','76',152,'2','1',9764.53,10168.53,0.00,0.00,404.00,300576.00,0.00,0.00,0.00),('1','274','1','77',153,'1','1',32755.78,33329.22,0.00,0.00,573.44,426639.36,0.00,0.00,0.00),('1','274','1','77',154,'2','1',10168.53,10658.28,0.00,0.00,489.75,364374.00,0.00,0.00,0.00),('1','274','1','78',155,'1','1',33329.22,34042.43,0.00,0.00,713.21,530628.24,0.00,0.00,0.00),('1','274','1','78',156,'2','1',10658.28,10865.24,0.00,0.00,206.96,153978.24,0.00,0.00,0.00),('1','274','1','79',157,'1','1',34042.43,34121.20,0.00,0.00,78.77,58604.88,0.00,0.00,0.00),('1','274','1','79',158,'2','1',10865.24,10965.05,0.00,0.00,99.81,74258.64,0.00,0.00,0.00),('1','274','1','80',159,'1','1',34121.20,34295.31,0.00,0.00,174.11,129537.84,0.00,0.00,0.00),('1','274','1','80',160,'2','1',10965.05,11130.24,0.00,0.00,165.19,122901.36,0.00,0.00,0.00),('1','274','1','81',161,'1','1',34295.31,34986.91,0.00,0.00,691.60,519413.36,0.00,0.00,0.00),('1','274','1','81',162,'2','1',11130.24,11320.76,0.00,0.00,190.52,143246.88,0.00,0.00,0.00),('1','274','1','82',163,'1','1',34986.91,35213.33,0.00,0.00,226.42,170267.84,0.00,0.00,0.00),('1','274','1','82',164,'2','1',11320.76,11629.32,0.00,0.00,308.56,232037.12,0.00,0.00,0.00),('1','274','1','83',165,'1','1',35213.33,35808.52,0.00,0.00,595.19,447582.88,0.00,0.00,0.00),('1','274','1','83',166,'2','1',11629.32,11714.83,0.00,0.00,85.51,64303.52,0.00,0.00,0.00),('1','274','1','84',167,'1','1',35808.52,36322.48,0.00,0.00,513.96,386497.92,0.00,0.00,0.00),('1','274','1','84',168,'2','1',11714.83,11774.13,0.00,0.00,59.30,44593.60,0.00,0.00,0.00),('1','274','1','85',169,'1','1',36322.48,36971.53,0.00,0.00,649.05,488085.60,0.00,0.00,0.00),('1','274','1','85',170,'2','1',11774.13,11774.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','274','1','86',171,'1','1',36971.53,37620.50,0.00,0.00,648.97,488025.44,0.00,0.00,0.00),('1','274','1','86',172,'2','1',11774.13,11991.22,0.00,0.00,217.09,163251.68,0.00,0.00,0.00),('1','274','1','87',173,'1','1',37620.50,37907.56,0.00,0.00,287.06,215869.12,0.00,0.00,0.00),('1','274','1','87',174,'2','1',11991.22,12107.77,0.00,0.00,116.55,87645.60,0.00,0.00,0.00),('1','274','1','88',175,'1','1',37907.56,38038.95,0.00,0.00,131.39,98805.28,0.00,0.00,0.00),('1','274','1','88',176,'2','1',12107.77,12135.77,0.00,0.00,28.00,21056.00,0.00,0.00,0.00),('1','274','1','89',177,'1','1',38038.95,38668.87,0.00,0.00,629.92,473699.84,0.00,0.00,0.00),('1','274','1','89',178,'2','1',12135.77,12205.77,0.00,0.00,70.00,52640.00,0.00,0.00,0.00),('1','274','1','90',179,'1','1',38668.87,39199.41,0.00,0.00,530.54,394721.76,0.00,0.00,0.00),('1','274','1','90',180,'2','1',12205.77,12296.66,0.00,0.00,90.89,67622.16,0.00,0.00,0.00),('1','274','1','91',181,'1','1',39199.41,39755.47,0.00,0.00,556.06,413708.64,0.00,0.00,0.00),('1','274','1','91',182,'2','1',12296.66,12544.49,0.00,0.00,247.83,184385.52,0.00,0.00,0.00),('1','274','1','92',183,'1','1',39755.47,40288.86,0.00,0.00,533.39,396842.16,0.00,0.00,0.00),('1','274','1','92',184,'2','1',12544.49,12703.87,0.00,0.00,159.38,118578.72,0.00,0.00,0.00),('1','274','1','93',185,'1','1',40288.86,40736.52,0.00,0.00,447.66,333059.04,0.00,0.00,0.00),('1','274','1','93',186,'2','1',12703.87,12928.87,0.00,0.00,225.00,167400.00,0.00,0.00,0.00),('1','274','1','94',187,'1','1',40736.52,41471.30,0.00,0.00,734.78,546676.32,0.00,0.00,0.00),('1','274','1','94',188,'2','1',12928.87,13332.96,0.00,0.00,404.09,300642.96,0.00,0.00,0.00),('1','274','1','95',189,'1','1',41471.30,41958.88,0.00,0.00,487.58,362759.52,0.00,0.00,0.00),('1','274','1','95',190,'2','1',13332.96,13566.84,0.00,0.00,233.88,174006.72,0.00,0.00,0.00),('1','274','1','96',191,'1','1',41958.88,42407.39,0.00,0.00,448.51,333691.44,0.00,0.00,0.00),('1','274','1','96',192,'2','1',13566.84,13702.59,0.00,0.00,135.75,100998.00,0.00,0.00,0.00),('1','274','1','97',193,'1','1',42407.39,42849.10,0.00,0.00,441.71,328632.24,0.00,0.00,0.00),('1','274','1','97',194,'2','1',13702.59,14034.31,0.00,0.00,331.72,246799.68,0.00,0.00,0.00),('1','274','1','98',195,'1','1',42849.10,43321.08,0.00,0.00,471.98,351153.12,0.00,0.00,0.00),('1','274','1','98',196,'2','1',14034.31,14235.62,0.00,0.00,201.31,149774.64,0.00,0.00,0.00),('1','274','1','99',197,'1','1',43321.08,43924.99,0.00,0.00,603.91,449309.04,0.00,0.00,0.00),('1','274','1','99',198,'2','1',14235.62,14381.39,0.00,0.00,145.77,108452.88,0.00,0.00,0.00),('1','274','1','100',199,'1','1',43924.99,44391.52,0.00,0.00,466.53,347098.32,0.00,0.00,0.00),('1','274','1','100',200,'2','1',14381.39,14646.20,0.00,0.00,264.81,197018.64,0.00,0.00,0.00),('1','274','1','101',201,'1','1',44391.52,44943.33,0.00,0.00,551.81,410546.64,0.00,0.00,0.00),('1','274','1','101',202,'2','1',14646.20,14740.22,0.00,0.00,94.02,69950.88,0.00,0.00,0.00),('1','274','1','102',203,'1','1',44943.33,45600.29,0.00,0.00,656.96,488778.24,0.00,0.00,0.00),('1','274','1','102',204,'2','1',14740.22,14994.51,0.00,0.00,254.29,189191.76,0.00,0.00,0.00),('1','274','1','103',205,'1','1',45600.29,46020.07,0.00,0.00,419.78,312316.32,0.00,0.00,0.00),('1','274','1','103',206,'2','1',14994.51,15145.25,0.00,0.00,150.74,112150.56,0.00,0.00,0.00),('1','274','1','104',207,'1','1',46020.07,46671.70,0.00,0.00,651.63,484812.72,0.00,0.00,0.00),('1','274','1','104',208,'2','1',15145.25,15325.24,0.00,0.00,179.99,133912.56,0.00,0.00,0.00),('1','274','1','105',209,'1','1',46671.70,47220.73,0.00,0.00,549.03,408478.32,0.00,0.00,0.00),('1','274','1','105',210,'2','1',15325.24,15683.83,0.00,0.00,358.59,266790.96,0.00,0.00,0.00),('1','274','1','106',211,'1','1',47220.73,48122.53,0.00,0.00,901.80,670939.20,0.00,0.00,0.00),('1','274','1','106',212,'2','1',15683.83,16207.98,0.00,0.00,524.15,389967.60,0.00,0.00,0.00),('1','274','1','107',213,'1','1',48122.53,48585.75,0.00,0.00,463.22,344635.68,0.00,0.00,0.00),('1','274','1','107',214,'2','1',16207.98,16484.84,0.00,0.00,276.86,205983.84,0.00,0.00,0.00),('1','274','1','108',215,'1','1',48585.75,48649.91,0.00,0.00,64.16,47735.04,0.00,0.00,0.00),('1','274','1','108',216,'2','1',16484.84,16487.84,0.00,0.00,3.00,2232.00,0.00,0.00,0.00),('1','274','1','109',217,'1','1',48649.91,49173.47,0.00,0.00,523.56,389528.64,0.00,0.00,0.00),('1','274','1','109',218,'2','1',16487.84,16696.22,0.00,0.00,208.38,155034.72,0.00,0.00,0.00),('1','274','1','110',219,'1','1',49173.47,49823.66,0.00,0.00,650.19,483741.36,0.00,0.00,0.00),('1','274','1','110',220,'2','1',16696.22,17209.20,0.00,0.00,512.98,381657.12,0.00,0.00,0.00),('1','274','1','111',221,'1','1',49823.66,50355.70,0.00,0.00,532.04,395837.76,0.00,0.00,0.00),('1','274','1','111',222,'2','1',17209.20,17469.66,0.00,0.00,260.46,193782.24,0.00,0.00,0.00),('1','274','1','112',223,'1','1',50355.70,50611.05,0.00,0.00,255.35,189980.40,0.00,0.00,0.00),('1','274','1','112',224,'2','1',17469.66,17683.29,0.00,0.00,213.63,158940.72,0.00,0.00,0.00),('1','274','1','113',225,'1','1',50611.05,50743.40,0.00,0.00,132.35,98468.40,0.00,0.00,0.00),('1','274','1','113',226,'2','1',17683.29,17733.72,0.00,0.00,50.43,37519.92,0.00,0.00,0.00),('1','274','1','114',227,'1','1',50743.40,51238.20,0.00,0.00,494.80,368131.20,0.00,0.00,0.00),('1','274','1','114',228,'2','1',17733.72,17966.00,0.00,0.00,232.28,172816.32,0.00,0.00,0.00),('1','274','1','115',229,'1','1',51238.20,51837.91,0.00,0.00,599.71,446184.24,0.00,0.00,0.00),('1','274','1','115',230,'2','1',17966.00,18251.97,0.00,0.00,285.97,212761.68,0.00,0.00,0.00),('1','274','1','116',231,'1','1',51837.91,52387.14,0.00,0.00,549.23,408627.12,0.00,0.00,0.00),('1','274','1','116',232,'2','1',18251.97,18451.41,0.00,0.00,199.44,148383.36,0.00,0.00,0.00),('1','274','1','117',233,'1','1',52387.14,52876.21,0.00,0.00,489.07,363868.08,0.00,0.00,0.00),('1','274','1','117',234,'2','1',18451.41,18738.72,0.00,0.00,287.31,213758.64,0.00,0.00,0.00),('1','274','1','118',235,'1','1',52876.21,53701.06,0.00,0.00,824.85,613688.40,0.00,0.00,0.00),('1','274','1','118',236,'2','1',18738.72,19032.80,0.00,0.00,294.08,218795.52,0.00,0.00,0.00),('1','274','1','119',237,'1','1',53701.06,54348.03,0.00,0.00,646.97,481345.68,0.00,0.00,0.00),('1','274','1','119',238,'2','1',19032.80,19194.52,0.00,0.00,161.72,120319.68,0.00,0.00,0.00),('1','274','1','120',239,'1','1',54348.03,54549.32,0.00,0.00,201.29,149759.76,0.00,0.00,0.00),('1','274','1','120',240,'2','1',19194.52,19247.47,0.00,0.00,52.95,39394.80,0.00,0.00,0.00),('1','274','1','121',241,'1','1',54549.32,54812.84,0.00,0.00,263.52,196058.88,0.00,0.00,0.00),('1','274','1','121',242,'2','1',19247.47,19360.13,0.00,0.00,112.66,83819.04,0.00,0.00,0.00),('1','274','1','122',243,'1','1',54812.84,55481.25,0.00,0.00,668.41,497297.04,0.00,0.00,0.00),('1','274','1','122',244,'2','1',19360.13,19528.66,0.00,0.00,168.53,125386.32,0.00,0.00,0.00),('1','274','1','123',245,'1','1',55481.25,56194.85,0.00,0.00,713.60,530918.40,0.00,0.00,0.00),('1','274','1','123',246,'2','1',19528.66,19745.90,0.00,0.00,217.24,161626.56,0.00,0.00,0.00),('1','274','1','124',247,'1','1',56194.85,56788.40,0.00,0.00,593.55,441601.20,0.00,0.00,0.00),('1','274','1','124',248,'2','1',19745.90,19848.90,0.00,0.00,103.00,76632.00,0.00,0.00,0.00),('1','274','1','125',249,'1','1',56788.40,57468.66,0.00,0.00,680.26,500671.36,0.00,0.00,0.00),('1','274','1','125',250,'2','1',19848.90,20211.08,0.00,0.00,362.18,266564.48,0.00,0.00,0.00),('1','274','1','126',251,'1','1',57468.66,57989.18,0.00,0.00,520.52,383102.72,0.00,0.00,0.00),('1','274','1','126',252,'2','1',20211.08,20380.25,0.00,0.00,169.17,124509.12,0.00,0.00,0.00),('1','274','1','127',253,'1','1',57989.18,58183.01,0.00,0.00,193.83,142658.88,0.00,0.00,0.00),('1','274','1','127',254,'2','1',20380.25,20423.76,0.00,0.00,43.51,32023.36,0.00,0.00,0.00),('1','274','1','128',255,'1','1',58183.01,58787.11,0.00,0.00,604.10,444617.60,0.00,0.00,0.00),('1','274','1','128',256,'2','1',20423.76,20610.39,0.00,0.00,186.63,137359.68,0.00,0.00,0.00),('1','274','1','129',257,'1','1',58787.11,59334.05,0.00,0.00,546.94,402547.84,0.00,0.00,0.00),('1','274','1','129',258,'2','1',20610.39,20857.25,0.00,0.00,246.86,181688.96,0.00,0.00,0.00),('1','274','1','130',259,'1','1',59334.05,59911.06,0.00,0.00,577.01,424679.36,0.00,0.00,0.00),('1','274','1','130',260,'2','1',20857.25,21220.92,0.00,0.00,363.67,267661.12,0.00,0.00,0.00),('1','274','1','131',261,'1','1',59911.06,60392.37,0.00,0.00,481.31,354244.16,0.00,0.00,0.00),('1','274','1','131',262,'2','1',21220.92,21455.22,0.00,0.00,234.30,172444.80,0.00,0.00,0.00),('1','274','1','132',263,'1','1',60392.37,60937.12,0.00,0.00,544.75,400936.00,0.00,0.00,0.00),('1','274','1','132',264,'2','1',21455.22,21797.36,0.00,0.00,342.14,251815.04,0.00,0.00,0.00),('1','274','1','133',265,'1','1',60937.12,61438.57,0.00,0.00,501.45,369067.20,0.00,0.00,0.00),('1','274','1','133',266,'2','1',21797.36,21929.94,0.00,0.00,132.58,97578.88,0.00,0.00,0.00),('1','274','1','134',267,'1','1',61438.57,61868.02,0.00,0.00,429.45,316075.20,0.00,0.00,0.00),('1','274','1','134',268,'2','1',21929.94,22200.40,0.00,0.00,270.46,199058.56,0.00,0.00,0.00),('1','274','1','135',269,'1','1',61868.02,62465.36,0.00,0.00,597.34,439642.24,0.00,0.00,0.00),('1','274','1','135',270,'2','1',22200.40,22547.40,0.00,0.00,347.00,255392.00,0.00,0.00,0.00),('1','274','1','136',271,'1','1',62465.36,63032.39,0.00,0.00,567.03,417334.08,0.00,0.00,0.00),('1','274','1','136',272,'2','1',22547.40,22633.16,0.00,0.00,85.76,63119.36,0.00,0.00,0.00),('1','274','1','137',273,'1','1',63032.39,63636.53,0.00,0.00,604.14,444647.04,0.00,0.00,0.00),('1','274','1','137',274,'2','1',22633.16,22854.61,0.00,0.00,221.45,162987.20,0.00,0.00,0.00),('1','274','1','138',275,'1','1',63636.53,64286.86,0.00,0.00,650.33,478642.88,0.00,0.00,0.00),('1','274','1','138',276,'2','1',22854.61,23268.11,0.00,0.00,413.50,304336.00,0.00,0.00,0.00),('1','274','1','139',277,'1','1',64286.86,64928.27,0.00,0.00,641.41,472077.76,0.00,0.00,0.00),('1','274','1','139',278,'2','1',23268.11,23531.75,0.00,0.00,263.64,194039.04,0.00,0.00,0.00),('1','274','1','140',279,'1','1',64928.27,65463.58,0.00,0.00,535.31,393988.16,0.00,0.00,0.00),('1','274','1','140',280,'2','1',23531.75,23693.80,0.00,0.00,162.05,119268.80,0.00,0.00,0.00),('1','274','1','141',281,'1','1',65463.58,65513.36,0.00,0.00,49.78,36638.08,0.00,0.00,0.00),('1','274','1','141',282,'2','1',23693.80,23732.97,0.00,0.00,39.17,28829.12,0.00,0.00,0.00),('1','274','1','142',283,'1','1',65513.36,65659.62,0.00,0.00,146.26,107647.36,0.00,0.00,0.00),('1','274','1','142',284,'2','1',23732.97,24005.14,0.00,0.00,272.17,200317.12,0.00,0.00,0.00),('1','274','1','143',285,'1','1',65659.62,66441.51,0.00,0.00,781.89,575471.04,0.00,0.00,0.00),('1','274','1','143',286,'2','1',24005.14,24480.67,0.00,0.00,475.53,349990.08,0.00,0.00,0.00),('1','274','1','144',287,'1','1',66441.51,67991.61,0.00,0.00,1550.10,1140873.60,0.00,0.00,0.00),('1','274','1','144',288,'2','1',24480.67,25285.93,0.00,0.00,805.26,592671.36,0.00,0.00,0.00),('1','274','1','145',289,'1','1',67991.61,68108.48,0.00,0.00,116.87,89288.68,0.00,0.00,0.00),('1','274','1','145',290,'2','1',25285.93,25424.69,0.00,0.00,138.76,106012.64,0.00,0.00,0.00),('1','274','1','146',291,'1','1',68108.48,68381.60,0.00,0.00,273.12,208663.68,0.00,0.00,0.00),('1','274','1','146',292,'2','1',25424.69,25670.38,0.00,0.00,245.69,187707.16,0.00,0.00,0.00),('1','274','1','147',293,'1','1',68381.60,68907.87,0.00,0.00,526.27,402070.28,0.00,0.00,0.00),('1','274','1','147',294,'2','1',25670.38,25790.84,0.00,0.00,120.46,92031.44,0.00,0.00,0.00),('1','274','1','148',295,'1','1',68907.87,69646.48,0.00,0.00,738.61,552480.28,0.00,0.00,0.00),('1','274','1','148',296,'2','1',25790.84,25898.83,0.00,0.00,107.99,80776.52,0.00,0.00,0.00),('1','274','1','149',297,'1','1',69646.48,70357.04,0.00,0.00,710.56,531498.88,0.00,0.00,0.00),('1','274','1','149',298,'2','1',25898.83,26001.77,0.00,0.00,102.94,76999.12,0.00,0.00,0.00),('1','274','1','150',299,'1','1',70357.04,71125.54,0.00,0.00,768.50,574838.00,0.00,0.00,0.00),('1','274','1','150',300,'2','1',26001.77,26177.85,0.00,0.00,176.08,131707.84,0.00,0.00,0.00),('1','274','1','151',301,'1','1',71125.54,72260.30,0.00,0.00,1134.76,849000.48,0.00,0.00,0.00),('1','274','1','151',302,'2','1',26177.85,26677.14,0.00,0.00,499.29,373468.92,0.00,0.00,0.00),('1','274','1','152',303,'1','1',72260.30,72889.85,0.00,0.00,629.55,470903.40,0.00,0.00,0.00),('1','274','1','152',304,'2','1',26677.14,27118.93,0.00,0.00,441.79,330458.92,0.00,0.00,0.00),('1','274','1','153',305,'1','1',72889.85,73579.89,0.00,0.00,690.04,516299.27,0.00,0.00,0.00),('1','274','1','153',306,'2','1',27118.93,27240.16,0.00,0.00,121.23,90680.04,0.00,0.00,0.00),('1','274','1','154',307,'1','1',73579.89,73836.29,0.00,0.00,256.40,194864.00,0.00,0.00,0.00),('1','274','1','154',308,'2','1',27240.16,27373.34,0.00,0.00,133.18,101216.80,0.00,0.00,0.00),('1','274','1','155',309,'1','1',73836.29,73836.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','274','1','155',310,'2','1',27373.34,27373.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','274','1','156',311,'1','1',73836.29,74085.10,0.00,0.00,248.81,189095.60,0.00,0.00,0.00),('1','274','1','156',312,'2','1',27373.34,27385.46,0.00,0.00,12.12,9211.20,0.00,0.00,0.00),('1','274','1','157',313,'1','1',74085.10,74780.86,0.00,0.00,695.76,528777.60,0.00,0.00,0.00),('1','274','1','157',314,'2','1',27385.46,27911.59,0.00,0.00,526.13,399858.80,0.00,0.00,0.00),('1','274','1','158',315,'1','1',74780.86,75664.06,0.00,0.00,883.20,671232.00,0.00,0.00,0.00),('1','274','1','158',316,'2','1',27911.59,28134.73,0.00,0.00,223.14,169586.40,0.00,0.00,0.00),('1','274','1','159',317,'1','1',75664.06,76576.41,0.00,0.00,912.35,693386.00,0.00,0.00,0.00),('1','274','1','159',318,'2','1',28134.73,28525.03,0.00,0.00,390.30,296628.00,0.00,0.00,0.00),('1','274','1','160',319,'1','1',76576.41,77331.59,0.00,0.00,755.18,573936.80,0.00,0.00,0.00),('1','274','1','160',320,'2','1',28525.03,28849.04,0.00,0.00,324.01,246247.60,0.00,0.00,0.00),('1','274','1','161',321,'1','1',77331.59,77755.00,0.00,0.00,423.41,321791.60,0.00,0.00,0.00),('1','274','1','161',322,'2','1',28849.04,28985.36,0.00,0.00,136.32,103603.20,0.00,0.00,0.00),('1','274','1','162',323,'1','1',77755.00,77755.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','274','1','162',324,'2','1',28985.36,28985.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','274','1','163',325,'1','1',77755.00,78416.32,0.00,0.00,661.32,502603.20,0.00,0.00,0.00),('1','274','1','163',326,'2','1',28985.36,29162.65,0.00,0.00,177.29,134740.40,0.00,0.00,0.00),('1','274','1','164',327,'1','1',78416.32,79138.51,0.00,0.00,722.19,577752.00,0.00,0.00,0.00),('1','274','1','164',328,'2','1',29162.65,29358.05,0.00,0.00,195.40,156320.00,0.00,0.00,0.00),('1','274','1','165',329,'1','1',79138.51,79948.99,0.00,0.00,810.48,648384.00,0.00,0.00,0.00),('1','274','1','165',330,'2','1',29358.05,29546.55,0.00,0.00,188.50,150800.00,0.00,0.00,0.00),('1','274','1','166',331,'1','1',79948.99,80452.00,0.00,0.00,503.01,402408.00,0.00,0.00,0.00),('1','274','1','166',332,'2','1',29546.55,29653.55,0.00,0.00,107.00,85600.00,0.00,0.00,0.00),('1','274','1','167',333,'1','1',80452.00,81141.15,0.00,0.00,689.15,523754.00,0.00,0.00,0.00),('1','274','1','167',334,'2','1',29653.55,29855.12,0.00,0.00,201.57,153193.20,0.00,0.00,0.00),('1','274','1','168',335,'1','1',81141.15,81658.96,0.00,0.00,517.81,393535.60,0.00,0.00,0.00),('1','274','1','168',336,'2','1',29855.12,30096.61,0.00,0.00,241.49,183532.40,0.00,0.00,0.00),('1','274','1','169',337,'1','1',81658.96,82143.34,0.00,0.00,484.38,368128.80,0.00,0.00,0.00),('1','274','1','169',338,'2','1',30096.61,30549.66,0.00,0.00,453.05,344318.00,0.00,0.00,0.00),('1','274','1','170',339,'1','1',82143.34,82673.04,0.00,0.00,529.70,402572.00,0.00,0.00,0.00),('1','274','1','170',340,'2','1',30549.66,30979.27,0.00,0.00,429.61,326503.60,0.00,0.00,0.00),('1','274','1','171',341,'1','1',82673.04,83299.35,0.00,0.00,626.31,475995.60,0.00,0.00,0.00),('1','274','1','171',342,'2','1',30979.27,31230.77,0.00,0.00,251.50,191140.00,0.00,0.00,0.00),('1','274','1','172',343,'1','1',83299.35,83714.24,0.00,0.00,414.89,315316.40,0.00,0.00,0.00),('1','274','1','172',344,'2','1',31230.77,31394.89,0.00,0.00,164.12,124731.20,0.00,0.00,0.00),('1','274','1','173',345,'1','1',83714.24,84177.97,0.00,0.00,463.73,352434.80,0.00,0.00,0.00),('1','274','1','173',346,'2','1',31394.89,31674.61,0.00,0.00,279.72,212587.20,0.00,0.00,0.00),('1','274','1','174',347,'1','1',84177.97,84622.04,0.00,0.00,444.07,337493.20,0.00,0.00,0.00),('1','274','1','174',348,'2','1',31674.61,31961.86,0.00,0.00,287.25,218310.00,0.00,0.00,0.00),('1','274','1','175',349,'1','1',84622.04,84948.88,0.00,0.00,326.84,248398.40,0.00,0.00,0.00),('1','274','1','175',350,'2','1',31961.86,32107.32,0.00,0.00,145.46,110549.60,0.00,0.00,0.00),('1','274','1','176',351,'1','1',84948.88,85462.43,0.00,0.00,513.55,390298.00,0.00,0.00,0.00),('1','274','1','176',352,'2','1',32107.32,32407.42,0.00,0.00,300.10,228076.00,0.00,0.00,0.00),('1','274','1','177',353,'1','1',85462.43,86051.88,0.00,0.00,589.45,447982.00,0.00,0.00,0.00),('1','274','1','177',354,'2','1',32407.42,32856.67,0.00,0.00,449.25,341430.00,0.00,0.00,0.00),('1','274','1','178',355,'1','1',86051.88,86444.46,0.00,0.00,392.58,298360.80,0.00,0.00,0.00),('1','274','1','178',356,'2','1',32856.67,32946.02,0.00,0.00,89.35,67906.00,0.00,0.00,0.00),('1','274','1','179',357,'1','1',86444.46,86838.87,0.00,0.00,394.41,299751.60,0.00,0.00,0.00),('1','274','1','179',358,'2','1',32946.02,33160.00,0.00,0.00,213.98,162624.80,0.00,0.00,0.00),('1','274','1','180',359,'1','1',86838.87,87383.22,0.00,0.00,544.35,413706.00,0.00,0.00,0.00),('1','274','1','180',360,'2','1',33160.00,33458.79,0.00,0.00,298.79,227080.40,0.00,0.00,0.00),('1','274','1','181',361,'1','1',87383.22,87878.19,0.00,0.00,494.97,376177.20,0.00,0.00,0.00),('1','274','1','181',362,'2','1',33458.79,33539.11,0.00,0.00,80.32,61043.20,0.00,0.00,0.00),('1','274','1','182',363,'1','1',87878.19,88481.38,0.00,0.00,603.19,458424.40,0.00,0.00,0.00),('1','274','1','182',364,'2','1',33539.11,33752.24,0.00,0.00,213.13,161978.80,0.00,0.00,0.00),('1','274','1','183',365,'1','1',88481.38,88559.88,0.00,0.00,78.50,59660.00,0.00,0.00,0.00),('1','274','1','183',366,'2','1',33752.24,33803.26,0.00,0.00,51.02,38775.20,0.00,0.00,0.00),('1','274','1','184',367,'1','1',88559.88,88982.03,0.00,0.00,422.15,320834.00,0.00,0.00,0.00),('1','274','1','184',368,'2','1',33803.26,34196.40,0.00,0.00,393.14,298786.40,0.00,0.00,0.00),('1','274','1','185',369,'1','1',88982.03,89414.55,0.00,0.00,432.52,328715.20,0.00,0.00,0.00),('1','274','1','185',370,'2','1',34196.40,34402.84,0.00,0.00,206.44,156894.40,0.00,0.00,0.00),('1','274','1','186',371,'1','1',89414.55,89811.73,0.00,0.00,397.18,301856.80,0.00,0.00,0.00),('1','274','1','186',372,'2','1',34402.84,34713.37,0.00,0.00,310.53,236002.80,0.00,0.00,0.00),('1','274','1','187',373,'1','1',89811.73,90428.47,0.00,0.00,616.74,468722.40,0.00,0.00,0.00),('1','274','1','187',374,'2','1',34713.37,34755.37,0.00,0.00,42.00,31920.00,0.00,0.00,0.00),('1','274','1','188',375,'1','1',90428.47,90921.94,0.00,0.00,493.47,375037.20,0.00,0.00,0.00),('1','274','1','188',376,'2','1',34755.37,34967.56,0.00,0.00,212.19,161264.40,0.00,0.00,0.00),('1','274','1','189',377,'1','1',90921.94,91385.28,0.00,0.00,463.34,352138.40,0.00,0.00,0.00),('1','274','1','189',378,'2','1',34967.56,35278.56,0.00,0.00,311.00,236360.00,0.00,0.00,0.00),('1','274','1','190',379,'1','1',91385.28,91880.68,0.00,0.00,495.40,376504.00,0.00,0.00,0.00),('1','274','1','190',380,'2','1',35278.56,35528.06,0.00,0.00,249.50,189620.00,0.00,0.00,0.00),('1','274','1','191',381,'1','1',91880.68,92386.16,0.00,0.00,505.48,384164.80,0.00,0.00,0.00),('1','274','1','191',382,'2','1',35528.06,35777.60,0.00,0.00,249.54,189650.40,0.00,0.00,0.00),('1','274','1','192',383,'1','1',92386.16,93169.06,0.00,0.00,782.90,595004.00,0.00,0.00,0.00),('1','274','1','192',384,'2','1',35777.60,36075.41,0.00,0.00,297.81,226335.60,0.00,0.00,0.00),('1','274','1','193',385,'1','1',93169.06,93678.41,0.00,0.00,509.35,387106.00,0.00,0.00,0.00),('1','274','1','193',386,'2','1',36075.41,36344.91,0.00,0.00,269.50,204820.00,0.00,0.00,0.00),('1','274','1','194',387,'1','1',93678.41,94052.46,0.00,0.00,374.05,284278.00,0.00,0.00,0.00),('1','274','1','194',388,'2','1',36344.91,36527.46,0.00,0.00,182.55,138738.00,0.00,0.00,0.00),('1','274','1','195',389,'1','1',94052.46,94415.09,0.00,0.00,362.63,275598.80,0.00,0.00,0.00),('1','274','1','195',390,'2','1',36527.46,36908.34,0.00,0.00,380.88,289468.80,0.00,0.00,0.00),('1','274','1','196',391,'1','1',94415.09,94920.16,0.00,0.00,505.07,383853.20,0.00,0.00,0.00),('1','274','1','196',392,'2','1',36908.34,37203.55,0.00,0.00,295.21,224359.60,0.00,0.00,0.00),('1','274','1','197',393,'1','1',94920.16,95253.71,0.00,0.00,333.55,253498.00,0.00,0.00,0.00),('1','274','1','197',394,'2','1',37203.55,37382.58,0.00,0.00,179.03,136062.80,0.00,0.00,0.00),('1','274','1','198',395,'1','1',95253.71,95559.81,0.00,0.00,306.10,232636.00,0.00,0.00,0.00),('1','274','1','198',396,'2','1',37382.58,37588.63,0.00,0.00,206.05,156598.00,0.00,0.00,0.00),('1','274','1','199',397,'1','1',95559.81,95746.49,0.00,0.00,186.68,141876.80,0.00,0.00,0.00),('1','274','1','199',398,'2','1',37588.63,38087.23,0.00,0.00,498.60,378936.00,0.00,0.00,0.00),('1','274','1','200',399,'1','1',95746.49,95973.49,0.00,0.00,227.00,172520.00,0.00,0.00,0.00),('1','274','1','200',400,'2','1',38087.23,38473.72,0.00,0.00,386.49,293732.40,0.00,0.00,0.00),('1','274','1','201',401,'1','1',95973.49,96225.34,0.00,0.00,251.85,191406.00,0.00,0.00,0.00),('1','274','1','201',402,'2','1',38473.72,38751.35,0.00,0.00,277.63,210998.80,0.00,0.00,0.00),('1','274','1','202',403,'1','1',96225.34,96430.27,0.00,0.00,204.93,155746.80,0.00,0.00,0.00),('1','274','1','202',404,'2','1',38751.35,39387.80,0.00,0.00,636.45,483702.00,0.00,0.00,0.00),('1','274','1','203',405,'1','1',96430.27,96778.93,0.00,0.00,348.66,264981.60,0.00,0.00,0.00),('1','274','1','203',406,'2','1',39387.80,39599.01,0.00,0.00,211.21,160519.60,0.00,0.00,0.00),('1','274','1','204',407,'1','1',96778.93,97175.70,0.00,0.00,396.77,301545.20,0.00,0.00,0.00),('1','274','1','204',408,'2','1',39599.01,39874.64,0.00,0.00,275.63,209478.80,0.00,0.00,0.00),('1','274','1','205',409,'1','1',97175.70,97466.88,0.00,0.00,291.18,215171.76,0.00,0.00,0.00),('1','274','1','205',410,'2','1',39874.64,39941.93,0.00,0.00,67.29,50005.44,0.00,0.00,0.00),('1','274','1','206',411,'1','1',97466.88,97620.21,0.00,0.00,153.33,112850.88,0.00,0.00,0.00),('1','274','1','206',412,'2','1',39941.93,40061.56,0.00,0.00,119.63,88047.68,0.00,0.00,0.00),('1','274','1','207',413,'1','1',97620.21,98059.45,0.00,0.00,439.24,323280.64,0.00,0.00,0.00),('1','274','1','207',414,'2','1',40061.56,40420.46,0.00,0.00,358.90,264150.40,0.00,0.00,0.00),('1','274','1','208',415,'1','1',98059.45,98477.95,0.00,0.00,418.50,308016.00,0.00,0.00,0.00),('1','274','1','208',416,'2','1',40420.46,40704.40,0.00,0.00,283.94,208979.84,0.00,0.00,0.00),('1','274','1','209',417,'1','1',98477.95,98818.19,0.00,0.00,340.24,250416.64,0.00,0.00,0.00),('1','274','1','209',418,'2','1',40704.40,40933.40,0.00,0.00,229.00,168544.00,0.00,0.00,0.00),('1','274','1','210',419,'1','1',98818.19,99147.76,0.00,0.00,329.57,242563.52,0.00,0.00,0.00),('1','274','1','210',420,'2','1',40933.40,41207.80,0.00,0.00,274.40,201958.40,0.00,0.00,0.00),('1','274','1','211',421,'1','1',99147.76,99631.72,0.00,0.00,483.96,356194.56,0.00,0.00,0.00),('1','274','1','211',422,'2','1',41207.80,41650.18,0.00,0.00,442.38,325591.68,0.00,0.00,0.00),('1','274','1','212',423,'1','1',99631.72,100081.17,0.00,0.00,449.45,330795.20,0.00,0.00,0.00),('1','274','1','212',424,'2','1',41650.18,41950.21,0.00,0.00,300.03,220822.08,0.00,0.00,0.00),('1','274','1','213',425,'1','1',100081.17,100539.08,0.00,0.00,457.91,337021.76,0.00,0.00,0.00),('1','274','1','213',426,'2','1',41950.21,42215.18,0.00,0.00,264.97,195017.92,0.00,0.00,0.00),('1','274','1','214',427,'1','1',100539.08,100570.68,0.00,0.00,31.60,23257.60,0.00,0.00,0.00),('1','274','1','214',428,'2','1',42215.18,42215.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','274','1','215',429,'1','1',100570.68,101076.73,0.00,0.00,506.05,372452.80,0.00,0.00,0.00),('1','274','1','215',430,'2','1',42215.18,42503.93,0.00,0.00,288.75,212520.00,0.00,0.00,0.00),('1','274','1','216',431,'1','1',101076.73,101502.32,0.00,0.00,425.59,313234.24,0.00,0.00,0.00),('1','274','1','216',432,'2','1',42503.93,42801.41,0.00,0.00,297.48,218945.28,0.00,0.00,0.00),('1','274','1','217',433,'1','1',101502.32,101886.79,0.00,0.00,384.47,282969.92,0.00,0.00,0.00),('1','274','1','217',434,'2','1',42801.41,43119.94,0.00,0.00,318.53,234438.08,0.00,0.00,0.00),('1','274','1','218',435,'1','1',101886.79,102164.98,0.00,0.00,278.19,204747.84,0.00,0.00,0.00),('1','274','1','218',436,'2','1',43119.94,43514.22,0.00,0.00,394.28,290190.08,0.00,0.00,0.00),('1','274','1','219',437,'1','1',102164.98,102436.00,0.00,0.00,271.02,199470.72,0.00,0.00,0.00),('1','274','1','219',438,'2','1',43514.22,43872.62,0.00,0.00,358.40,263782.40,0.00,0.00,0.00),('1','274','1','220',439,'1','1',102436.00,102759.51,0.00,0.00,323.51,238103.36,0.00,0.00,0.00),('1','274','1','220',440,'2','1',43872.62,44366.85,0.00,0.00,494.23,363753.28,0.00,0.00,0.00),('1','274','1','221',441,'1','1',102759.51,103120.21,0.00,0.00,360.70,265475.20,0.00,0.00,0.00),('1','274','1','221',442,'2','1',44366.85,44960.85,0.00,0.00,594.00,437184.00,0.00,0.00,0.00),('1','274','1','222',443,'1','1',103120.21,103230.35,0.00,0.00,110.14,81063.04,0.00,0.00,0.00),('1','274','1','222',444,'2','1',44960.85,45013.35,0.00,0.00,52.50,38640.00,0.00,0.00,0.00),('1','274','1','223',445,'1','1',103230.35,103335.78,0.00,0.00,105.43,77596.48,0.00,0.00,0.00),('1','274','1','223',446,'2','1',45013.35,45466.77,0.00,0.00,453.42,333717.12,0.00,0.00,0.00),('1','274','1','224',447,'1','1',103335.78,103612.95,0.00,0.00,277.17,203997.12,0.00,0.00,0.00),('1','274','1','224',448,'2','1',45466.77,45654.70,0.00,0.00,187.93,138316.48,0.00,0.00,0.00),('1','274','1','225',449,'1','1',103612.95,103799.16,0.00,0.00,186.21,137050.56,0.00,0.00,0.00),('1','274','1','225',450,'2','1',45654.70,45968.59,0.00,0.00,313.89,231023.04,0.00,0.00,0.00),('1','274','1','226',451,'1','1',103799.16,103931.85,0.00,0.00,132.69,97659.84,0.00,0.00,0.00),('1','274','1','226',452,'2','1',45968.59,46326.31,0.00,0.00,357.72,263281.92,0.00,0.00,0.00),('1','274','1','227',453,'1','1',103931.85,104027.95,0.00,0.00,96.10,70729.60,0.00,0.00,0.00),('1','274','1','227',454,'2','1',46326.31,46597.60,0.00,0.00,271.29,199669.44,0.00,0.00,0.00),('1','274','1','228',455,'1','1',104027.95,104269.45,0.00,0.00,241.50,177744.00,0.00,0.00,0.00),('1','274','1','228',456,'2','1',46597.60,47018.25,0.00,0.00,420.65,309598.40,0.00,0.00,0.00),('1','274','1','229',457,'1','1',104269.45,104413.13,0.00,0.00,143.68,105748.48,0.00,0.00,0.00),('1','274','1','229',458,'2','1',47018.25,47429.79,0.00,0.00,411.54,302893.44,0.00,0.00,0.00),('1','274','1','230',459,'1','1',104413.13,104762.43,0.00,0.00,349.30,257084.80,0.00,0.00,0.00),('1','274','1','230',460,'2','1',47429.79,47790.53,0.00,0.00,360.74,265504.64,0.00,0.00,0.00),('1','274','1','231',461,'1','1',104762.43,104793.34,0.00,0.00,30.91,22749.76,0.00,0.00,0.00),('1','274','1','231',462,'2','1',47790.53,47905.10,0.00,0.00,114.57,84323.52,0.00,0.00,0.00),('1','274','1','232',463,'1','1',104793.34,104905.93,0.00,0.00,112.59,82866.24,0.00,0.00,0.00),('1','274','1','232',464,'2','1',47905.10,48082.32,0.00,0.00,177.22,130433.92,0.00,0.00,0.00),('1','274','1','233',465,'1','1',104905.93,105218.12,0.00,0.00,312.19,229771.84,0.00,0.00,0.00),('1','274','1','233',466,'2','1',48082.32,48623.71,0.00,0.00,541.39,398463.04,0.00,0.00,0.00),('1','274','1','234',467,'1','1',105218.12,105525.58,0.00,0.00,307.46,226290.56,0.00,0.00,0.00),('1','274','1','234',468,'2','1',48623.71,49068.63,0.00,0.00,444.92,327461.12,0.00,0.00,0.00),('1','274','1','235',469,'1','1',105525.58,105933.78,0.00,0.00,408.20,300435.20,0.00,0.00,0.00),('1','274','1','235',470,'2','1',49068.63,49415.09,0.00,0.00,346.46,254994.56,0.00,0.00,0.00),('1','274','1','236',471,'1','1',105933.78,106210.26,0.00,0.00,276.48,203489.28,0.00,0.00,0.00),('1','274','1','236',472,'2','1',49415.09,49634.30,0.00,0.00,219.21,161338.56,0.00,0.00,0.00),('1','274','1','237',473,'1','1',106210.26,106495.09,0.00,0.00,284.83,209634.88,0.00,0.00,0.00),('1','274','1','237',474,'2','1',49634.30,50000.81,0.00,0.00,366.51,269751.36,0.00,0.00,0.00),('1','274','1','238',475,'1','1',106495.09,106836.77,0.00,0.00,341.68,251476.48,0.00,0.00,0.00),('1','274','1','238',476,'2','1',50000.81,50363.83,0.00,0.00,363.02,267182.72,0.00,0.00,0.00),('1','274','1','239',477,'1','1',106836.77,106965.19,0.00,0.00,128.42,94517.12,0.00,0.00,0.00),('1','274','1','239',478,'2','1',50363.83,50465.58,0.00,0.00,101.75,74888.00,0.00,0.00,0.00),('1','274','1','240',479,'1','1',106965.19,107029.69,0.00,0.00,64.50,47472.00,0.00,0.00,0.00),('1','274','1','240',480,'2','1',50465.58,50676.41,0.00,0.00,210.83,155170.88,0.00,0.00,0.00),('1','274','1','241',481,'1','1',107029.69,107269.79,0.00,0.00,240.10,176713.60,0.00,0.00,0.00),('1','274','1','241',482,'2','1',50676.41,51086.26,0.00,0.00,409.85,301649.60,0.00,0.00,0.00),('1','274','1','242',483,'1','1',107269.79,107634.33,0.00,0.00,364.54,268301.44,0.00,0.00,0.00),('1','274','1','242',484,'2','1',51086.26,51637.91,0.00,0.00,551.65,406014.40,0.00,0.00,0.00),('1','274','1','243',485,'1','1',107634.33,107989.27,0.00,0.00,354.94,261235.84,0.00,0.00,0.00),('1','274','1','243',486,'2','1',51637.91,52228.97,0.00,0.00,591.06,435020.16,0.00,0.00,0.00),('1','274','1','244',487,'1','1',107989.27,108313.67,0.00,0.00,324.40,238758.40,0.00,0.00,0.00),('1','274','1','244',488,'2','1',52228.97,52636.56,0.00,0.00,407.59,299986.24,0.00,0.00,0.00),('1','274','1','245',489,'1','1',108313.67,108589.25,0.00,0.00,275.58,202826.88,0.00,0.00,0.00),('1','274','1','245',490,'2','1',52636.56,53085.88,0.00,0.00,449.32,330699.52,0.00,0.00,0.00),('1','274','1','246',491,'1','1',108589.25,108899.84,0.00,0.00,310.59,228594.24,0.00,0.00,0.00),('1','274','1','246',492,'2','1',53085.88,53680.92,0.00,0.00,595.04,437949.44,0.00,0.00,0.00),('1','274','1','247',493,'1','1',108899.84,109001.57,0.00,0.00,101.73,74873.28,0.00,0.00,0.00),('1','274','1','247',494,'2','1',53680.92,53736.21,0.00,0.00,55.29,40693.44,0.00,0.00,0.00),('1','274','1','248',495,'1','1',109001.57,109514.39,0.00,0.00,512.82,377435.52,0.00,0.00,0.00),('1','274','1','248',496,'2','1',53736.21,54257.07,0.00,0.00,520.86,383352.96,0.00,0.00,0.00),('1','274','1','249',497,'1','1',109514.39,109805.81,0.00,0.00,291.42,214485.12,0.00,0.00,0.00),('1','274','1','249',498,'2','1',54257.07,54986.63,0.00,0.00,729.56,536956.16,0.00,0.00,0.00),('1','274','1','250',499,'1','1',109805.81,110009.45,0.00,0.00,203.64,149879.04,0.00,0.00,0.00),('1','274','1','250',500,'2','1',54986.63,55362.03,0.00,0.00,375.40,276294.40,0.00,0.00,0.00),('1','274','1','251',501,'1','1',110009.45,110292.45,0.00,0.00,283.00,208288.00,0.00,0.00,0.00),('1','274','1','251',502,'2','1',55362.03,55658.23,0.00,0.00,296.20,218003.20,0.00,0.00,0.00),('1','274','1','252',503,'1','1',110292.45,110514.26,0.00,0.00,221.81,163252.16,0.00,0.00,0.00),('1','274','1','252',504,'2','1',55658.23,55990.87,0.00,0.00,332.64,244823.04,0.00,0.00,0.00),('1','274','1','253',505,'1','1',110514.26,110692.26,0.00,0.00,178.00,131008.00,0.00,0.00,0.00),('1','274','1','253',506,'2','1',55990.87,56395.53,0.00,0.00,404.66,297829.76,0.00,0.00,0.00),('1','274','1','254',507,'1','1',110692.26,110882.91,0.00,0.00,190.65,140318.40,0.00,0.00,0.00),('1','274','1','254',508,'2','1',56395.53,56633.71,0.00,0.00,238.18,175300.48,0.00,0.00,0.00),('1','274','1','255',509,'1','1',110882.91,111066.41,0.00,0.00,183.50,135056.00,0.00,0.00,0.00),('1','274','1','255',510,'2','1',56633.71,57023.48,0.00,0.00,389.77,286870.72,0.00,0.00,0.00),('1','274','1','256',511,'1','1',111066.41,111181.15,0.00,0.00,114.74,84448.64,0.00,0.00,0.00),('1','274','1','256',512,'2','1',57023.48,57446.53,0.00,0.00,423.05,311364.80,0.00,0.00,0.00),('1','274','1','257',513,'1','1',111181.15,111547.90,0.00,0.00,366.75,269928.00,0.00,0.00,0.00),('1','274','1','257',514,'2','1',57446.53,57915.48,0.00,0.00,468.95,345147.20,0.00,0.00,0.00),('1','274','1','258',515,'1','1',111547.90,111953.98,0.00,0.00,406.08,298874.88,0.00,0.00,0.00),('1','274','1','258',516,'2','1',57915.48,58537.99,0.00,0.00,622.51,458167.36,0.00,0.00,0.00),('1','274','1','259',517,'1','1',111953.98,112096.35,0.00,0.00,142.37,104784.32,0.00,0.00,0.00),('1','274','1','259',518,'2','1',58537.99,58922.09,0.00,0.00,384.10,282697.60,0.00,0.00,0.00),('1','274','1','260',519,'1','1',112096.35,112317.90,0.00,0.00,221.55,163060.80,0.00,0.00,0.00),('1','274','1','260',520,'2','1',58922.09,59353.89,0.00,0.00,431.80,317804.80,0.00,0.00,0.00),('1','274','1','261',521,'1','1',112317.90,112492.82,0.00,0.00,174.92,128741.12,0.00,0.00,0.00),('1','274','1','261',522,'2','1',59353.89,59717.42,0.00,0.00,363.53,267558.08,0.00,0.00,0.00),('1','274','1','262',523,'1','1',112492.82,112605.15,0.00,0.00,112.33,82674.88,0.00,0.00,0.00),('1','274','1','262',524,'2','1',59717.42,60141.49,0.00,0.00,424.07,312115.52,0.00,0.00,0.00),('1','274','1','263',525,'1','1',112605.15,112893.40,0.00,0.00,288.25,212152.00,0.00,0.00,0.00),('1','274','1','263',526,'2','1',60141.49,60707.72,0.00,0.00,566.23,416745.28,0.00,0.00,0.00),('1','274','1','264',527,'1','1',112893.40,113267.43,0.00,0.00,374.03,275286.08,0.00,0.00,0.00),('1','274','1','264',528,'2','1',60707.72,61171.41,0.00,0.00,463.69,341275.84,0.00,0.00,0.00),('1','274','1','265',529,'1','1',113267.43,113398.93,0.00,0.00,131.50,96784.00,0.00,0.00,0.00),('1','274','1','265',530,'2','1',61171.41,61627.39,0.00,0.00,455.98,335601.28,0.00,0.00,0.00),('1','274','1','266',531,'1','1',113398.93,113562.68,0.00,0.00,163.75,120520.00,0.00,0.00,0.00),('1','274','1','266',532,'2','1',61627.39,62071.22,0.00,0.00,443.83,326658.88,0.00,0.00,0.00),('1','274','1','267',533,'1','1',113562.68,113829.37,0.00,0.00,266.69,196283.84,0.00,0.00,0.00),('1','274','1','267',534,'2','1',62071.22,62853.63,0.00,0.00,782.41,575853.76,0.00,0.00,0.00),('1','274','1','268',535,'1','1',113829.37,113982.37,0.00,0.00,153.00,112608.00,0.00,0.00,0.00),('1','274','1','268',536,'2','1',62853.63,63346.25,0.00,0.00,492.62,362568.32,0.00,0.00,0.00),('1','274','1','269',537,'1','1',113982.37,114307.17,0.00,0.00,324.80,239052.80,0.00,0.00,0.00),('1','274','1','269',538,'2','1',63346.25,63910.32,0.00,0.00,564.07,415155.52,0.00,0.00,0.00),('1','274','1','270',539,'1','1',114307.17,114590.88,0.00,0.00,283.71,208810.56,0.00,0.00,0.00),('1','274','1','270',540,'2','1',63910.32,64306.51,0.00,0.00,396.19,291595.84,0.00,0.00,0.00),('1','274','1','271',541,'1','1',114590.88,114713.21,0.00,0.00,122.33,90034.88,0.00,0.00,0.00),('1','274','1','271',542,'2','1',64306.51,64825.54,0.00,0.00,519.03,382006.08,0.00,0.00,0.00),('1','274','1','272',543,'1','1',114713.21,114943.91,0.00,0.00,230.70,169795.20,0.00,0.00,0.00),('1','274','1','272',544,'2','1',64825.54,65287.69,0.00,0.00,462.15,340142.40,0.00,0.00,0.00),('1','274','1','273',545,'1','1',114943.91,115230.23,0.00,0.00,286.32,210731.52,0.00,0.00,0.00),('1','274','1','273',546,'2','1',65287.69,65800.74,0.00,0.00,513.05,377604.80,0.00,0.00,0.00),('1','274','1','274',547,'1','1',115230.23,115432.21,0.00,0.00,201.98,148657.28,0.00,0.00,0.00),('1','274','1','274',548,'2','1',65800.74,66362.03,0.00,0.00,561.29,413109.44,0.00,0.00,0.00),('1','274','1','275',549,'1','1',115432.21,115729.75,0.00,0.00,297.54,218989.44,0.00,0.00,0.00),('1','274','1','275',550,'2','1',66362.03,66790.46,0.00,0.00,428.43,315324.48,0.00,0.00,0.00),('1','274','1','276',551,'1','1',115729.75,115918.21,0.00,0.00,188.46,138706.56,0.00,0.00,0.00),('1','274','1','276',552,'2','1',66790.46,67224.25,0.00,0.00,433.79,319269.44,0.00,0.00,0.00),('1','274','1','277',553,'1','1',115918.21,116233.05,0.00,0.00,314.84,231722.24,0.00,0.00,0.00),('1','274','1','277',554,'2','1',67224.25,67726.59,0.00,0.00,502.34,369722.24,0.00,0.00,0.00),('1','274','1','278',555,'1','1',116233.05,116497.68,0.00,0.00,264.63,194767.68,0.00,0.00,0.00),('1','274','1','278',556,'2','1',67726.59,67982.70,0.00,0.00,256.11,188496.96,0.00,0.00,0.00),('1','274','1','279',557,'1','1',116497.68,116717.34,0.00,0.00,219.66,161669.76,0.00,0.00,0.00),('1','274','1','279',558,'2','1',67982.70,68324.79,0.00,0.00,342.09,251778.24,0.00,0.00,0.00),('1','274','1','280',559,'1','1',116717.34,116959.54,0.00,0.00,242.20,178259.20,0.00,0.00,0.00),('1','274','1','280',560,'2','1',68324.79,68720.10,0.00,0.00,395.31,290948.16,0.00,0.00,0.00),('1','274','1','281',561,'1','1',116959.54,117396.76,0.00,0.00,437.22,321793.92,0.00,0.00,0.00),('1','274','1','281',562,'2','1',68720.10,69404.81,0.00,0.00,684.71,503946.56,0.00,0.00,0.00),('1','274','1','282',563,'1','1',117396.76,117657.50,0.00,0.00,260.74,191904.64,0.00,0.00,0.00),('1','274','1','282',564,'2','1',69404.81,69938.68,0.00,0.00,533.87,392928.32,0.00,0.00,0.00),('1','274','1','283',565,'1','1',117657.50,117732.95,0.00,0.00,75.45,55531.20,0.00,0.00,0.00),('1','274','1','283',566,'2','1',69938.68,70274.87,0.00,0.00,336.19,247435.84,0.00,0.00,0.00),('1','274','1','284',567,'1','1',117732.95,117745.45,0.00,0.00,12.50,9200.00,0.00,0.00,0.00),('1','274','1','284',568,'2','1',70274.87,70277.32,0.00,0.00,2.45,1803.20,0.00,0.00,0.00),('1','274','1','285',569,'1','1',117745.45,118151.85,0.00,0.00,406.40,299110.40,0.00,0.00,0.00),('1','274','1','285',570,'2','1',70277.32,70769.12,0.00,0.00,491.80,361964.80,0.00,0.00,0.00),('1','274','1','286',571,'1','1',118151.85,118481.36,0.00,0.00,329.51,242519.36,0.00,0.00,0.00),('1','274','1','286',572,'2','1',70769.12,71726.01,0.00,0.00,956.89,704271.04,0.00,0.00,0.00),('1','274','1','287',573,'1','1',118481.36,119012.21,0.00,0.00,530.85,390705.60,0.00,0.00,0.00),('1','274','1','287',574,'2','1',71726.01,72857.00,0.00,0.00,1130.99,832408.64,0.00,0.00,0.00),('1','274','1','288',575,'1','1',119012.21,119424.14,0.00,0.00,411.93,303180.48,0.00,0.00,0.00),('1','274','1','288',576,'2','1',72857.00,73591.40,0.00,0.00,734.40,540518.40,0.00,0.00,0.00),('1','274','1','289',577,'1','1',119424.14,119787.16,0.00,0.00,363.02,267182.72,0.00,0.00,0.00),('1','274','1','289',578,'2','1',73591.40,74525.52,0.00,0.00,934.12,687512.32,0.00,0.00,0.00),('1','274','1','290',579,'1','1',119787.16,119952.36,0.00,0.00,165.20,121587.20,0.00,0.00,0.00),('1','274','1','290',580,'2','1',74525.52,74973.21,0.00,0.00,447.69,329499.84,0.00,0.00,0.00),('1','274','1','291',581,'1','1',119952.36,120372.08,0.00,0.00,419.72,308913.92,0.00,0.00,0.00),('1','274','1','291',582,'2','1',74973.21,75379.51,0.00,0.00,406.30,299036.80,0.00,0.00,0.00),('1','274','1','292',583,'1','1',120372.08,120730.50,0.00,0.00,358.42,263797.12,0.00,0.00,0.00),('1','274','1','292',584,'2','1',75379.51,75877.45,0.00,0.00,497.94,366483.84,0.00,0.00,0.00),('1','274','1','293',585,'1','1',120730.50,120951.73,0.00,0.00,221.23,162825.28,0.00,0.00,0.00),('1','274','1','293',586,'2','1',75877.45,76299.29,0.00,0.00,421.84,310474.24,0.00,0.00,0.00),('1','274','1','294',587,'1','1',120951.73,121228.45,0.00,0.00,276.72,203665.92,0.00,0.00,0.00),('1','274','1','294',588,'2','1',76299.29,76932.68,0.00,0.00,633.39,466175.04,0.00,0.00,0.00),('1','274','1','295',589,'1','1',121228.45,121241.64,0.00,0.00,13.19,9707.84,0.00,0.00,0.00),('1','274','1','295',590,'2','1',76932.68,76950.53,0.00,0.00,17.85,13137.60,0.00,0.00,0.00),('1','274','1','296',591,'1','1',121241.64,121660.48,0.00,0.00,418.84,308266.24,0.00,0.00,0.00),('1','274','1','296',592,'2','1',76950.53,77605.03,0.00,0.00,654.50,481712.00,0.00,0.00,0.00),('1','274','1','297',593,'1','1',121660.48,122127.05,0.00,0.00,466.57,343395.52,0.00,0.00,0.00),('1','274','1','297',594,'2','1',77605.03,77781.40,0.00,0.00,176.37,129808.32,0.00,0.00,0.00),('1','274','1','298',595,'1','1',122127.05,122625.21,0.00,0.00,498.16,366645.76,0.00,0.00,0.00),('1','274','1','298',596,'2','1',77781.40,78244.37,0.00,0.00,462.97,340745.92,0.00,0.00,0.00),('1','274','1','299',597,'1','1',122625.21,122970.34,0.00,0.00,345.13,254015.68,0.00,0.00,0.00),('1','274','1','299',598,'2','1',78244.37,78742.21,0.00,0.00,497.84,366410.24,0.00,0.00,0.00),('1','274','1','300',599,'1','1',122970.34,123328.87,0.00,0.00,358.53,256191.00,0.00,0.00,0.00),('1','274','1','300',600,'2','1',78742.21,79034.15,0.00,0.00,291.94,205708.00,0.00,0.00,0.00),('1','274','1','301',601,'1','1',123328.87,123693.26,0.00,0.00,364.39,255073.00,0.00,0.00,0.00),('1','274','1','301',602,'2','1',79034.15,79335.37,0.00,0.00,301.22,210854.00,0.00,0.00,0.00),('1','274','1','302',603,'1','1',123693.26,124079.51,0.00,0.00,386.25,270375.00,0.00,0.00,0.00),('1','274','1','302',604,'2','1',79335.37,79859.65,0.00,0.00,524.28,366996.00,0.00,0.00,0.00),('1','274','1','303',605,'1','1',124079.51,124745.17,0.00,0.00,665.66,465962.00,0.00,0.00,0.00),('1','274','1','303',606,'2','1',79859.65,80931.10,0.00,0.00,1071.45,750015.00,0.00,0.00,0.00),('1','274','1','304',607,'1','1',124745.17,125247.84,0.00,0.00,502.67,351869.00,0.00,0.00,0.00),('1','274','1','304',608,'2','1',80931.10,81755.71,0.00,0.00,824.61,577227.00,0.00,0.00,0.00),('1','274','1','305',609,'1','1',125247.84,125588.24,0.00,0.00,340.40,238280.00,0.00,0.00,0.00),('1','274','1','305',610,'2','1',81755.71,82591.96,0.00,0.00,836.25,585375.00,0.00,0.00,0.00),('1','274','1','306',611,'1','1',125588.24,125631.04,0.00,0.00,42.80,29960.00,0.00,0.00,0.00),('1','274','1','306',612,'2','1',82591.96,82648.03,0.00,0.00,56.07,39249.00,0.00,0.00,0.00),('1','274','1','307',613,'1','1',125631.04,125762.25,0.00,0.00,131.21,91847.00,0.00,0.00,0.00),('1','274','1','307',614,'2','1',82648.03,82773.17,0.00,0.00,125.14,87598.00,0.00,0.00,0.00),('1','274','1','308',615,'1','1',125762.25,126156.35,0.00,0.00,394.10,275870.00,0.00,0.00,0.00),('1','274','1','308',616,'2','1',82773.17,83370.78,0.00,0.00,597.61,418327.00,0.00,0.00,0.00),('1','274','1','309',617,'1','1',126156.35,126810.01,0.00,0.00,653.66,457562.00,0.00,0.00,0.00),('1','274','1','309',618,'2','1',83370.78,84306.24,0.00,0.00,935.46,654822.00,0.00,0.00,0.00),('1','274','1','310',619,'1','1',126810.01,127290.90,0.00,0.00,480.89,336623.00,0.00,0.00,0.00),('1','274','1','310',620,'2','1',84306.24,84909.34,0.00,0.00,603.10,422170.00,0.00,0.00,0.00),('1','274','1','311',621,'1','1',127290.90,127731.30,0.00,0.00,440.40,308280.00,0.00,0.00,0.00),('1','274','1','311',622,'2','1',84909.34,85590.87,0.00,0.00,681.53,477071.00,0.00,0.00,0.00),('1','274','1','312',623,'1','1',127731.30,128223.29,0.00,0.00,491.99,344393.00,0.00,0.00,0.00),('1','274','1','312',624,'2','1',85590.87,86319.84,0.00,0.00,728.97,510279.00,0.00,0.00,0.00),('1','274','1','313',625,'1','1',128223.29,128515.59,0.00,0.00,292.30,204610.00,0.00,0.00,0.00),('1','274','1','313',626,'2','1',86319.84,86834.89,0.00,0.00,515.05,360535.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=314 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','274','1','1',662.00,704.00,0.00,0.00,0.00,0.00,0.00,1),('1','274','2','1',662.00,704.00,0.00,115.42,76408.04,81255.68,4847.64,2),('1','274','3','1',662.00,704.00,0.00,379.46,251202.52,267139.84,15937.32,3),('1','274','4','1',662.00,704.00,0.00,770.12,509819.44,542164.48,32345.04,4),('1','274','5','1',662.00,704.00,0.00,515.91,341532.42,363200.64,21668.22,5),('1','274','6','1',662.00,744.00,0.00,566.98,375340.76,421833.12,46492.36,6),('1','274','7','1',662.00,744.00,0.00,631.46,418026.52,469806.24,51779.72,7),('1','274','8','1',662.00,744.00,0.00,505.13,334396.06,375816.72,41420.66,8),('1','274','9','1',662.00,744.00,0.00,0.00,0.00,0.00,0.00,9),('1','274','10','1',662.00,744.00,0.00,446.58,295635.96,332255.52,36619.56,10),('1','274','11','1',662.00,744.00,0.00,705.49,467034.38,524884.56,57850.18,11),('1','274','12','1',662.00,744.00,0.00,510.71,338090.02,379968.24,41878.22,12),('1','274','13','1',662.00,744.00,0.00,452.55,299588.10,336697.20,37109.10,13),('1','274','14','1',662.00,744.00,0.00,684.46,453112.52,509238.24,56125.72,14),('1','274','15','1',662.00,744.00,0.00,408.02,270109.24,303566.88,33457.64,15),('1','274','16','1',662.00,744.00,0.00,152.71,101094.02,113616.24,12522.22,16),('1','274','17','1',662.00,744.00,0.00,501.77,332171.74,373316.88,41145.14,17),('1','274','18','1',662.00,744.00,0.00,1355.70,897473.40,1008640.80,111167.40,18),('1','274','19','1',662.00,744.00,0.00,792.41,524575.42,589553.04,64977.62,19),('1','274','20','1',662.00,744.00,0.00,702.21,464863.02,522444.24,57581.22,20),('1','274','21','1',662.00,744.00,0.00,491.42,325320.04,365616.48,40296.44,21),('1','274','22','1',662.00,744.00,0.00,812.69,538000.78,604641.36,66640.58,22),('1','274','23','1',662.00,744.00,0.00,848.65,561806.30,631395.60,69589.30,23),('1','274','24','1',662.00,744.00,0.00,1217.74,806143.88,905998.56,99854.68,24),('1','274','25','1',662.00,744.00,0.00,1014.11,671340.82,754497.84,83157.02,25),('1','274','26','1',662.00,744.00,0.00,754.63,499565.06,561444.72,61879.66,26),('1','274','27','1',662.00,744.00,0.00,291.21,192781.02,216660.24,23879.22,27),('1','274','28','1',662.00,744.00,0.00,167.80,111083.60,124843.20,13759.60,28),('1','274','29','1',662.00,744.00,0.00,925.15,612449.30,688311.60,75862.30,29),('1','274','30','1',662.00,744.00,0.00,471.70,312265.40,350944.80,38679.40,30),('1','274','31','1',662.00,744.00,0.00,430.96,285295.52,320634.24,35338.72,31),('1','274','32','1',662.00,744.00,0.00,530.42,351138.04,394632.48,43494.44,32),('1','274','33','1',662.00,744.00,0.00,697.71,461884.02,519096.24,57212.22,33),('1','274','34','1',662.00,744.00,0.00,563.07,372752.34,418924.08,46171.74,34),('1','274','35','1',662.00,744.00,0.00,603.99,399841.38,449368.56,49527.18,35),('1','274','36','1',662.00,744.00,0.00,469.20,310610.40,349084.80,38474.40,36),('1','274','37','1',662.00,744.00,0.00,0.00,0.00,0.00,0.00,37),('1','274','38','1',662.00,744.00,0.00,145.57,96367.34,108304.08,11936.74,38),('1','274','39','1',662.00,744.00,0.00,417.49,276378.38,310612.56,34234.18,39),('1','274','40','1',662.00,744.00,0.00,525.94,348172.28,391299.36,43127.08,40),('1','274','41','1',662.00,744.00,0.00,666.45,441189.90,495838.80,54648.90,41),('1','274','42','1',662.00,744.00,0.00,619.09,409837.58,460602.96,50765.38,42),('1','274','43','1',662.00,744.00,0.00,776.52,514056.24,577730.88,63674.64,43),('1','274','44','1',662.00,744.00,0.00,640.93,424295.66,476851.92,52556.26,44),('1','274','45','1',662.00,744.00,0.00,466.39,308750.18,346994.16,38243.98,45),('1','274','46','1',662.00,744.00,0.00,592.08,391956.96,440507.52,48550.56,46),('1','274','47','1',662.00,744.00,0.00,644.04,426354.48,479165.76,52811.28,47),('1','274','48','1',662.00,744.00,0.00,574.92,380597.04,427740.48,47143.44,48),('1','274','49','1',662.00,744.00,0.00,746.84,494408.08,555648.96,61240.88,49),('1','274','50','1',662.00,744.00,0.00,389.63,257935.06,289884.72,31949.66,50),('1','274','51','1',662.00,744.00,0.00,420.94,278662.28,313179.36,34517.08,51),('1','274','52','1',662.00,744.00,0.00,386.58,255915.96,287615.52,31699.56,52),('1','274','53','1',662.00,744.00,0.00,488.57,323433.34,363496.08,40062.74,53),('1','274','54','1',662.00,744.00,0.00,477.74,316263.88,355438.56,39174.68,54),('1','274','55','1',662.00,744.00,0.00,518.76,343419.12,385957.44,42538.32,55),('1','274','56','1',662.00,744.00,0.00,845.33,559608.46,628925.52,69317.06,56),('1','274','57','1',662.00,744.00,0.00,307.74,203723.88,228958.56,25234.68,57),('1','274','58','1',662.00,744.00,0.00,226.81,150148.22,168746.64,18598.42,58),('1','274','59','1',662.00,744.00,0.00,597.81,395750.22,444770.64,49020.42,59),('1','274','60','1',662.00,744.00,0.00,729.97,483240.14,543097.68,59857.54,60),('1','274','61','1',662.00,744.00,0.00,599.75,397034.50,446214.00,49179.50,61),('1','274','62','1',662.00,744.00,0.00,585.68,387720.16,435745.92,48025.76,62),('1','274','63','1',662.00,744.00,0.00,570.07,377386.34,424132.08,46745.74,63),('1','274','64','1',662.00,744.00,0.00,876.24,580070.88,651922.56,71851.68,64),('1','274','65','1',662.00,744.00,0.00,567.76,375857.12,422413.44,46556.32,65),('1','274','66','1',662.00,744.00,0.00,655.70,434073.40,487840.80,53767.40,66),('1','274','67','1',662.00,744.00,0.00,485.30,321268.60,361063.20,39794.60,67),('1','274','68','1',662.00,744.00,0.00,555.49,367734.38,413284.56,45550.18,68),('1','274','69','1',662.00,744.00,0.00,582.91,385886.42,433685.04,47798.62,69),('1','274','70','1',662.00,744.00,0.00,541.59,358532.58,402942.96,44410.38,70),('1','274','71','1',662.00,744.00,0.00,925.81,612886.22,688802.64,75916.42,71),('1','274','72','1',662.00,744.00,0.00,679.75,449994.50,505734.00,55739.50,72),('1','274','73','1',662.00,744.00,0.00,587.92,389203.04,437412.48,48209.44,73),('1','274','74','1',662.00,744.00,0.00,939.48,621935.76,698973.12,77037.36,74),('1','274','75','1',662.00,744.00,0.00,443.12,293345.44,329681.28,36335.84,75),('1','274','76','1',662.00,744.00,0.00,621.93,411717.66,462715.92,50998.26,76),('1','274','77','1',662.00,744.00,0.00,1063.19,703831.78,791013.36,87181.58,77),('1','274','78','1',662.00,744.00,0.00,920.17,609152.54,684606.48,75453.94,78),('1','274','79','1',662.00,744.00,0.00,178.58,118219.96,132863.52,14643.56,79),('1','274','80','1',665.00,744.00,0.00,339.30,225634.50,252439.20,26804.70,80),('1','274','81','1',665.00,744.00,0.00,882.12,586609.80,662660.24,76050.44,81),('1','274','82','1',665.00,752.00,0.00,534.98,355761.70,402304.96,46543.26,82),('1','274','83','1',665.00,752.00,0.00,680.70,452665.50,511886.40,59220.90,83),('1','274','84','1',665.00,752.00,0.00,573.26,381217.90,431091.52,49873.62,84),('1','274','85','1',665.00,752.00,0.00,649.05,431618.25,488085.60,56467.35,85),('1','274','86','1',665.00,752.00,0.00,866.06,575929.90,651277.12,75347.22,86),('1','274','87','1',665.00,752.00,0.00,403.61,268400.65,303514.72,35114.07,87),('1','274','88','1',665.00,752.00,0.00,159.39,105994.35,119861.28,13866.93,88),('1','274','89','1',665.00,752.00,0.00,699.92,465446.80,526339.84,60893.04,89),('1','274','90','1',665.00,752.00,0.00,621.43,413250.95,462343.92,49092.97,90),('1','274','91','1',665.00,744.00,0.00,803.89,534586.85,598094.16,63507.31,91),('1','274','92','1',665.00,744.00,0.00,692.77,460692.05,515420.88,54728.83,92),('1','274','93','1',665.00,744.00,0.00,672.66,447318.90,500459.04,53140.14,93),('1','274','94','1',665.00,744.00,0.00,1138.87,757348.55,847319.28,89970.73,94),('1','274','95','1',665.00,744.00,0.00,721.46,479770.90,536766.24,56995.34,95),('1','274','96','1',665.00,744.00,0.00,584.26,388532.90,434689.44,46156.54,96),('1','274','97','1',665.00,744.00,0.00,773.43,514330.95,575431.92,61100.97,97),('1','274','98','1',665.00,744.00,0.00,673.29,447737.85,500927.76,53189.91,98),('1','274','99','1',665.00,744.00,0.00,749.68,498537.20,557761.92,59224.72,99),('1','274','100','1',665.00,744.00,0.00,731.34,486341.10,544116.96,57775.86,100),('1','274','101','1',665.00,744.00,0.00,645.83,429476.95,480497.52,51020.57,101),('1','274','102','1',665.00,744.00,0.00,911.25,605981.25,677970.00,71988.75,102),('1','274','103','1',665.00,744.00,0.00,570.52,379395.80,424466.88,45071.08,103),('1','274','104','1',665.00,744.00,0.00,831.62,553027.30,618725.28,65697.98,104),('1','274','105','1',665.00,744.00,0.00,907.62,603567.30,675269.28,71701.98,105),('1','274','106','1',665.00,744.00,0.00,1425.95,948256.75,1060906.80,112650.05,106),('1','274','107','1',665.00,744.00,0.00,740.08,492153.20,550619.52,58466.32,107),('1','274','108','1',665.00,744.00,0.00,67.16,44661.40,49967.04,5305.64,108),('1','274','109','1',665.00,744.00,0.00,731.94,486740.10,544563.36,57823.26,109),('1','274','110','1',665.00,744.00,0.00,1163.17,773508.05,865398.48,91890.43,110),('1','274','111','1',665.00,744.00,0.00,792.50,527012.50,589620.00,62607.50,111),('1','274','112','1',665.00,744.00,0.00,468.98,311871.70,348921.12,37049.42,112),('1','274','113','1',665.00,744.00,0.00,182.78,121548.70,135988.32,14439.62,113),('1','274','114','1',665.00,744.00,0.00,727.08,483508.20,540947.52,57439.32,114),('1','274','115','1',665.00,744.00,0.00,885.68,588977.20,658945.92,69968.72,115),('1','274','116','1',665.00,744.00,0.00,748.67,497865.55,557010.48,59144.93,116),('1','274','117','1',665.00,744.00,0.00,776.38,516292.70,577626.72,61334.02,117),('1','274','118','1',665.00,744.00,0.00,1118.93,744088.45,832483.92,88395.47,118),('1','274','119','1',665.00,744.00,0.00,808.69,537778.85,601665.36,63886.51,119),('1','274','120','1',665.00,744.00,0.00,254.24,169069.60,189154.56,20084.96,120),('1','274','121','1',665.00,744.00,0.00,376.18,250159.70,279877.92,29718.22,121),('1','274','122','1',665.00,744.00,0.00,836.94,556565.10,622683.36,66118.26,122),('1','274','123','1',665.00,744.00,0.00,930.84,619008.60,692544.96,73536.36,123),('1','274','124','1',665.00,744.00,0.00,696.55,463205.75,518233.20,55027.45,124),('1','274','125','1',665.00,736.00,0.00,1042.44,693222.60,767235.84,74013.24,125),('1','274','126','1',665.00,736.00,0.00,689.69,458643.85,507611.84,48967.99,126),('1','274','127','1',665.00,736.00,0.00,237.34,157831.10,174682.24,16851.14,127),('1','274','128','1',670.00,736.00,0.00,790.73,529789.10,581977.28,52188.18,128),('1','274','129','1',670.00,736.00,0.00,793.80,531846.00,584236.80,52390.80,129),('1','274','130','1',670.00,736.00,0.00,940.68,630255.60,692340.48,62084.88,130),('1','274','131','1',670.00,736.00,0.00,715.61,479458.70,526688.96,47230.26,131),('1','274','132','1',670.00,736.00,0.00,886.89,594216.30,652751.04,58534.74,132),('1','274','133','1',670.00,736.00,0.00,634.03,424800.10,466646.08,41845.98,133),('1','274','134','1',670.00,736.00,0.00,699.91,468939.70,515133.76,46194.06,134),('1','274','135','1',670.00,736.00,0.00,944.34,632707.80,695034.24,62326.44,135),('1','274','136','1',670.00,736.00,0.00,652.79,437369.30,480453.44,43084.14,136),('1','274','137','1',670.00,736.00,0.00,825.59,553145.30,607634.24,54488.94,137),('1','274','138','1',670.00,736.00,0.00,1063.83,712766.10,782978.88,70212.78,138),('1','274','139','1',670.00,736.00,0.00,905.05,606383.50,666116.80,59733.30,139),('1','274','140','1',670.00,736.00,0.00,697.36,467231.20,513256.96,46025.76,140),('1','274','141','1',670.00,736.00,0.00,88.95,59596.50,65467.20,5870.70,141),('1','274','142','1',670.00,736.00,0.00,418.43,280348.10,307964.48,27616.38,142),('1','274','143','1',670.00,736.00,0.00,1257.42,842471.40,925461.12,82989.72,143),('1','274','144','1',670.00,736.00,0.00,2355.36,1578091.20,1733544.96,155453.76,144),('1','274','145','1',670.00,764.00,0.00,255.63,171272.10,195301.32,24029.22,145),('1','274','146','1',670.00,764.00,0.00,518.81,347602.70,396370.84,48768.14,146),('1','274','147','1',670.00,764.00,0.00,646.73,433309.10,494101.72,60792.62,147),('1','274','148','1',670.00,748.00,0.00,846.60,567222.00,633256.80,66034.80,148),('1','274','149','1',670.00,748.00,0.00,813.50,545045.00,608498.00,63453.00,149),('1','274','150','1',670.00,748.00,0.00,944.58,632868.60,706545.84,73677.24,150),('1','274','151','1',670.00,748.00,0.00,1634.05,1094813.50,1222469.40,127655.90,151),('1','274','152','1',670.00,748.00,0.00,1071.34,717797.80,801362.32,83564.52,152),('1','274','153','1',670.00,748.00,0.00,811.27,543550.90,606979.31,63428.41,153),('1','274','154','1',670.00,748.00,0.00,389.58,261018.60,296080.80,35062.20,154),('1','274','155','1',670.00,760.00,0.00,0.00,0.00,0.00,0.00,155),('1','274','156','1',670.00,760.00,0.00,260.93,174823.10,198306.80,23483.70,156),('1','274','157','1',670.00,760.00,0.00,1221.89,818666.30,928636.40,109970.10,157),('1','274','158','1',670.00,760.00,0.00,1106.34,741247.80,840818.40,99570.60,158),('1','274','159','1',670.00,760.00,0.00,1302.65,872775.50,990014.00,117238.50,159),('1','274','160','1',670.00,760.00,0.00,1079.19,723057.30,820184.40,97127.10,160),('1','274','161','1',670.00,760.00,0.00,559.73,375019.10,425394.80,50375.70,161),('1','274','162','1',670.00,760.00,0.00,0.00,0.00,0.00,0.00,162),('1','274','163','1',670.00,760.00,0.00,838.61,561868.70,637343.60,75474.90,163),('1','274','164','1',670.00,760.00,0.00,917.59,614785.30,734072.00,119286.70,164),('1','274','165','1',670.00,800.00,0.00,998.98,669316.60,799184.00,129867.40,165),('1','274','166','1',670.00,800.00,0.00,610.01,408706.70,488008.00,79301.30,166),('1','274','167','1',670.00,800.00,0.00,890.72,596782.40,676947.20,80164.80,167),('1','274','168','1',670.00,760.00,0.00,759.30,508731.00,577068.00,68337.00,168),('1','274','169','1',670.00,760.00,0.00,937.43,628078.10,712446.80,84368.70,169),('1','274','170','1',670.00,760.00,0.00,959.31,642737.70,729075.60,86337.90,170),('1','274','171','1',670.00,760.00,0.00,877.81,588132.70,667135.60,79002.90,171),('1','274','172','1',670.00,760.00,0.00,579.01,387936.70,440047.60,52110.90,172),('1','274','173','1',670.00,760.00,0.00,743.45,498111.50,565022.00,66910.50,173),('1','274','174','1',670.00,760.00,0.00,731.32,489984.40,555803.20,65818.80,174),('1','274','175','1',670.00,760.00,0.00,472.30,316441.00,358948.00,42507.00,175),('1','274','176','1',685.00,760.00,0.00,813.65,557350.25,618374.00,61023.75,176),('1','274','177','1',685.00,760.00,0.00,1038.70,711509.50,789412.00,77902.50,177),('1','274','178','1',685.00,760.00,0.00,481.93,330122.05,366266.80,36144.75,178),('1','274','179','1',685.00,760.00,0.00,608.39,416747.15,462376.40,45629.25,179),('1','274','180','1',685.00,760.00,0.00,843.14,577550.90,640786.40,63235.50,180),('1','274','181','1',685.00,760.00,0.00,575.29,394073.65,437220.40,43146.75,181),('1','274','182','1',685.00,760.00,0.00,816.32,559179.20,620403.20,61224.00,182),('1','274','183','1',685.00,760.00,0.00,129.52,88721.20,98435.20,9714.00,183),('1','274','184','1',685.00,760.00,0.00,815.29,558473.65,619620.40,61146.75,184),('1','274','185','1',685.00,760.00,0.00,638.96,437687.60,485609.60,47922.00,185),('1','274','186','1',685.00,760.00,0.00,707.71,484781.35,537859.60,53078.25,186),('1','274','187','1',685.00,760.00,0.00,658.74,451236.90,500642.40,49405.50,187),('1','274','188','1',685.00,760.00,0.00,705.66,483377.10,536301.60,52924.50,188),('1','274','189','1',685.00,760.00,0.00,774.34,530422.90,588498.40,58075.50,189),('1','274','190','1',685.00,760.00,0.00,744.90,510256.50,566124.00,55867.50,190),('1','274','191','1',685.00,760.00,0.00,755.02,517188.70,573815.20,56626.50,191),('1','274','192','1',685.00,760.00,0.00,1080.71,740286.35,821339.60,81053.25,192),('1','274','193','1',685.00,760.00,0.00,778.85,533512.25,591926.00,58413.75,193),('1','274','194','1',685.00,760.00,0.00,556.60,381271.00,423016.00,41745.00,194),('1','274','195','1',685.00,760.00,0.00,743.51,509304.35,565067.60,55763.25,195),('1','274','196','1',685.00,760.00,0.00,800.28,548191.80,608212.80,60021.00,196),('1','274','197','1',685.00,760.00,0.00,512.58,351117.30,389560.80,38443.50,197),('1','274','198','1',685.00,760.00,0.00,512.15,343140.50,389234.00,46093.50,198),('1','274','199','1',670.00,760.00,0.00,685.28,459137.60,520812.80,61675.20,199),('1','274','200','1',670.00,760.00,0.00,613.49,411038.30,466252.40,55214.10,200),('1','274','201','1',670.00,760.00,0.00,529.48,354751.60,402404.80,47653.20,201),('1','274','202','1',670.00,760.00,0.00,841.38,563724.60,639448.80,75724.20,202),('1','274','203','1',670.00,760.00,0.00,559.87,375112.90,425501.20,50388.30,203),('1','274','204','1',670.00,760.00,0.00,672.40,450508.00,511024.00,60516.00,204),('1','274','205','1',670.00,760.00,0.00,358.47,240174.90,265177.20,25002.30,205),('1','274','206','1',670.00,736.00,0.00,272.96,182883.20,200898.56,18015.36,206),('1','274','207','1',670.00,736.00,0.00,798.14,534753.80,587431.04,52677.24,207),('1','274','208','1',670.00,736.00,0.00,702.44,470634.80,516995.84,46361.04,208),('1','274','209','1',670.00,736.00,0.00,569.24,381390.80,418960.64,37569.84,209),('1','274','210','1',670.00,736.00,0.00,603.97,404659.90,444521.92,39862.02,210),('1','274','211','1',670.00,736.00,0.00,926.34,620647.80,681786.24,61138.44,211),('1','274','212','1',670.00,736.00,0.00,749.48,502151.60,551617.28,49465.68,212),('1','274','213','1',670.00,736.00,0.00,722.88,484329.60,532039.68,47710.08,213),('1','274','214','1',670.00,736.00,0.00,31.60,21172.00,23257.60,2085.60,214),('1','274','215','1',670.00,736.00,0.00,794.80,527747.20,584972.80,57225.60,215),('1','274','216','1',664.00,736.00,0.00,723.07,480118.48,532179.52,52061.04,216),('1','274','217','1',664.00,736.00,0.00,703.00,466792.00,517408.00,50616.00,217),('1','274','218','1',664.00,736.00,0.00,672.47,446520.08,494937.92,48417.84,218),('1','274','219','1',664.00,736.00,0.00,629.42,417934.88,463253.12,45318.24,219),('1','274','220','1',664.00,736.00,0.00,817.74,542979.36,601856.64,58877.28,220),('1','274','221','1',664.00,736.00,0.00,954.70,633920.80,702659.20,68738.40,221),('1','274','222','1',664.00,736.00,0.00,162.64,107992.96,119703.04,11710.08,222),('1','274','223','1',664.00,736.00,0.00,558.85,371076.40,411313.60,40237.20,223),('1','274','224','1',664.00,736.00,0.00,465.10,308826.40,342313.60,33487.20,224),('1','274','225','1',664.00,736.00,0.00,500.10,332066.40,368073.60,36007.20,225),('1','274','226','1',664.00,736.00,0.00,490.41,325632.24,360941.76,35309.52,226),('1','274','227','1',664.00,736.00,0.00,367.39,243946.96,270399.04,26452.08,227),('1','274','228','1',664.00,736.00,0.00,662.15,439667.60,487342.40,47674.80,228),('1','274','229','1',664.00,736.00,0.00,555.22,368666.08,408641.92,39975.84,229),('1','274','230','1',664.00,736.00,0.00,710.04,471466.56,522589.44,51122.88,230),('1','274','231','1',664.00,736.00,0.00,145.48,96598.72,107073.28,10474.56,231),('1','274','232','1',664.00,736.00,0.00,289.81,192433.84,213300.16,20866.32,232),('1','274','233','1',664.00,736.00,0.00,853.58,566777.12,628234.88,61457.76,233),('1','274','234','1',664.00,736.00,0.00,752.38,499580.32,553751.68,54171.36,234),('1','274','235','1',664.00,736.00,0.00,754.66,501094.24,555429.76,54335.52,235),('1','274','236','1',664.00,736.00,0.00,495.69,329138.16,364827.84,35689.68,236),('1','274','237','1',664.00,736.00,0.00,651.34,432489.76,479386.24,46896.48,237),('1','274','238','1',664.00,736.00,0.00,704.70,467920.80,518659.20,50738.40,238),('1','274','239','1',664.00,736.00,0.00,230.17,152832.88,169405.12,16572.24,239),('1','274','240','1',664.00,736.00,0.00,275.33,182819.12,202642.88,19823.76,240),('1','274','241','1',664.00,736.00,0.00,649.95,431566.80,478363.20,46796.40,241),('1','274','242','1',664.00,736.00,0.00,916.19,608350.16,674315.84,65965.68,242),('1','274','243','1',664.00,736.00,0.00,946.00,628144.00,696256.00,68112.00,243),('1','274','244','1',664.00,736.00,0.00,731.99,486041.36,538744.64,52703.28,244),('1','274','245','1',664.00,736.00,0.00,724.90,481333.60,533526.40,52192.80,245),('1','274','246','1',664.00,736.00,0.00,905.63,601338.32,666543.68,65205.36,246),('1','274','247','1',664.00,736.00,0.00,157.02,104261.28,115566.72,11305.44,247),('1','274','248','1',664.00,736.00,0.00,1033.68,686363.52,760788.48,74424.96,248),('1','274','249','1',664.00,736.00,0.00,1020.98,677930.72,751441.28,73510.56,249),('1','274','250','1',664.00,736.00,0.00,579.04,384482.56,426173.44,41690.88,250),('1','274','251','1',664.00,736.00,0.00,579.20,384588.80,426291.20,41702.40,251),('1','274','252','1',664.00,736.00,0.00,554.45,368154.80,408075.20,39920.40,252),('1','274','253','1',664.00,736.00,0.00,582.66,386886.24,428837.76,41951.52,253),('1','274','254','1',664.00,736.00,0.00,428.83,284743.12,315618.88,30875.76,254),('1','274','255','1',640.00,736.00,0.00,573.27,366892.80,421926.72,55033.92,255),('1','274','256','1',640.00,736.00,0.00,537.79,344185.60,395813.44,51627.84,256),('1','274','257','1',640.00,736.00,0.00,835.70,534848.00,615075.20,80227.20,257),('1','274','258','1',640.00,736.00,0.00,1028.59,658297.60,757042.24,98744.64,258),('1','274','259','1',640.00,736.00,0.00,526.47,336940.80,387481.92,50541.12,259),('1','274','260','1',640.00,736.00,0.00,653.35,418144.00,480865.60,62721.60,260),('1','274','261','1',640.00,736.00,0.00,538.45,344608.00,396299.20,51691.20,261),('1','274','262','1',640.00,736.00,0.00,536.40,343296.00,394790.40,51494.40,262),('1','274','263','1',640.00,736.00,0.00,854.48,546867.20,628897.28,82030.08,263),('1','274','264','1',640.00,736.00,0.00,837.72,536140.80,616561.92,80421.12,264),('1','274','265','1',640.00,736.00,0.00,587.48,375987.20,432385.28,56398.08,265),('1','274','266','1',640.00,736.00,0.00,607.58,388851.20,447178.88,58327.68,266),('1','274','267','1',640.00,736.00,0.00,1049.10,671424.00,772137.60,100713.60,267),('1','274','268','1',640.00,736.00,0.00,645.62,413196.80,475176.32,61979.52,268),('1','274','269','1',640.00,736.00,0.00,888.87,568876.80,654208.32,85331.52,269),('1','274','270','1',640.00,736.00,0.00,679.90,435136.00,500406.40,65270.40,270),('1','274','271','1',640.00,736.00,0.00,641.36,410470.40,472040.96,61570.56,271),('1','274','272','1',640.00,736.00,0.00,692.85,443424.00,509937.60,66513.60,272),('1','274','273','1',640.00,736.00,0.00,799.37,511596.80,588336.32,76739.52,273),('1','274','274','1',640.00,736.00,0.00,763.27,488492.80,561766.72,73273.92,274),('1','274','275','1',640.00,736.00,0.00,725.97,464620.80,534313.92,69693.12,275),('1','274','276','1',640.00,736.00,0.00,622.25,398240.00,457976.00,59736.00,276),('1','274','277','1',640.00,736.00,0.00,817.18,522995.20,601444.48,78449.28,277),('1','274','278','1',640.00,736.00,0.00,520.74,333273.60,383264.64,49991.04,278),('1','274','279','1',640.00,736.00,0.00,561.75,359520.00,413448.00,53928.00,279),('1','274','280','1',640.00,736.00,0.00,637.51,408006.40,469207.36,61200.96,280),('1','274','281','1',640.00,736.00,0.00,1121.93,718035.20,825740.48,107705.28,281),('1','274','282','1',640.00,736.00,0.00,794.61,508550.40,584832.96,76282.56,282),('1','274','283','1',640.00,736.00,0.00,411.64,263449.60,302967.04,39517.44,283),('1','274','284','1',640.00,736.00,0.00,14.95,9568.00,11003.20,1435.20,284),('1','274','285','1',640.00,736.00,0.00,898.20,574848.00,661075.20,86227.20,285),('1','274','286','1',640.00,736.00,0.00,1286.40,823296.00,946790.40,123494.40,286),('1','274','287','1',640.00,736.00,0.00,1661.84,1063577.60,1223114.24,159536.64,287),('1','274','288','1',640.00,736.00,0.00,1146.33,733651.20,843698.88,110047.68,288),('1','274','289','1',640.00,736.00,0.00,1297.14,830169.60,954695.04,124525.44,289),('1','274','290','1',640.00,736.00,0.00,612.89,392249.60,451087.04,58837.44,290),('1','274','291','1',640.00,736.00,0.00,826.02,528652.80,607950.72,79297.92,291),('1','274','292','1',640.00,736.00,0.00,856.36,548070.40,630280.96,82210.56,292),('1','274','293','1',640.00,736.00,0.00,643.07,411564.80,473299.52,61734.72,293),('1','274','294','1',640.00,736.00,0.00,910.11,582470.40,669840.96,87370.56,294),('1','274','295','1',640.00,736.00,0.00,31.04,19865.60,22845.44,2979.84,295),('1','274','296','1',640.00,736.00,0.00,1073.34,686937.60,789978.24,103040.64,296),('1','274','297','1',640.00,736.00,0.00,642.94,411481.60,473203.84,61722.24,297),('1','274','298','1',640.00,736.00,0.00,961.13,615123.20,707391.68,92268.48,298),('1','274','299','1',640.00,736.00,0.00,842.97,539500.80,620425.92,80925.12,299),('1','274','300','1',640.00,736.00,0.00,650.47,416300.80,461899.00,45598.20,300),('1','274','301','1',640.00,700.00,0.00,665.61,425990.40,465927.00,39936.60,301),('1','274','302','1',640.00,700.00,0.00,910.53,577741.02,637371.00,59629.98,302),('1','274','303','1',634.00,700.00,0.00,1737.11,1101327.74,1215977.00,114649.26,303),('1','274','304','1',634.00,700.00,0.00,1327.28,841495.52,929096.00,87600.48,304),('1','274','305','1',634.00,700.00,0.00,1176.65,745996.10,823655.00,77658.90,305),('1','274','306','1',634.00,700.00,0.00,98.87,62683.58,69209.00,6525.42,306),('1','274','307','1',634.00,700.00,0.00,256.35,162525.90,179445.00,16919.10,307),('1','274','308','1',634.00,700.00,0.00,991.71,628744.14,694197.00,65452.86,308),('1','274','309','1',634.00,700.00,0.00,1589.12,1007502.08,1112384.00,104881.92,309),('1','274','310','1',634.00,700.00,0.00,1083.99,687249.66,758793.00,71543.34,310),('1','274','311','1',634.00,700.00,0.00,1121.93,711303.62,785351.00,74047.38,311),('1','274','312','1',634.00,700.00,0.00,1220.96,774088.64,854672.00,80583.36,312),('1','274','313','1',634.00,700.00,0.00,807.35,511859.90,565145.00,53285.10,313);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',1,'274','LPG PRODUCT ','Tank Containing LPG Product.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','274','1',1,1,'1','LPG TANK ',7000.00,0.00,NULL,'TANK CONTAINING LPG PRODUCT','479','2022-05-29 12:52:15','2022-05-29 12:52:15','479',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','274',1,3001.69,'2023-03-20 19:19:05');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=13026 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,2429540.00,3670.00,0.00,0.00,'2022-05-30 15:54:34','',''),(2,'1','274',NULL,1,'Reception corrector for bridging 1',0.00,0.00,0.00,3670.00,0.00,'2022-05-30 16:42:05','',''),(3,'1','274','1',1,'Received from bridging 1',0.00,0.00,3670.00,0.00,0.00,'2022-05-30 16:42:05','',''),(4,'1','274','1',1,'Retail Sale Id 1',81255.68,0.00,0.00,115.42,4847.64,'2022-05-31 16:50:42','',''),(5,'1','274','1',1,'Retail Sale Id 2',209707.52,0.00,0.00,297.88,12510.96,'2022-05-31 16:58:38','',''),(6,'1','274','1',1,'Retail Sale Id 3',57432.32,0.00,0.00,81.58,3426.36,'2022-05-31 16:59:28','',''),(7,'1','274','1',1,'Retail Sale Id 4',326578.56,0.00,0.00,463.89,19483.38,'2022-05-31 17:03:36','',''),(8,'1','274','1',1,'Retail Sale Id 5',215585.92,0.00,0.00,306.23,12861.66,'2022-05-31 17:05:02','',''),(9,'1','274','1',1,'Retail Sale Id 6',267006.08,0.00,0.00,379.27,15929.34,'2022-05-31 17:10:25','',''),(10,'1','274','1',1,'Retail Sale Id 7',96194.56,0.00,0.00,136.64,5738.88,'2022-05-31 17:11:36','',''),(11,'1','274','1',1,'Retail Sale Id 8',4501.20,0.00,0.00,6.05,496.10,'2022-05-31 18:20:04','',''),(12,'1','274','1',1,'Retail Sale Id 9',9300.00,0.00,0.00,12.50,1025.00,'2022-05-31 18:21:54','',''),(13,'1','274','1',1,'Retail Sale Id 10',9300.00,0.00,0.00,12.50,1025.00,'2022-05-31 19:04:50','',''),(14,'1','274','1',1,'Retail Sale Id 11',37200.00,0.00,0.00,50.00,4100.00,'2022-05-31 19:06:23','',''),(15,'1','274','1',1,'Retail Sale Id 12',361531.92,0.00,0.00,485.93,39846.26,'2022-05-31 19:55:51','',''),(16,'1','274','1',1,'Retail Sale Id 13',1502.88,0.00,0.00,2.02,165.64,'2022-06-01 07:23:22','',''),(17,'1','274','1',1,'Retail Sale Id 14',996.96,0.00,0.00,1.34,109.88,'2022-06-01 07:38:05','',''),(18,'1','274','1',1,'Retail Sale Id 15',996.96,0.00,0.00,1.34,109.88,'2022-06-01 07:55:25','',''),(19,'1','274','1',1,'Retail Sale Id 16',1502.88,0.00,0.00,2.02,165.64,'2022-06-01 08:04:37','',''),(20,'1','274','1',1,'Retail Sale Id 17',4501.20,0.00,0.00,6.05,496.10,'2022-06-01 08:39:06','',''),(21,'1','274','1',1,'Retail Sale Id 19',13801.20,0.00,0.00,18.55,1521.10,'2022-06-01 17:29:33','',''),(22,'1','274','1',1,'Retail Sale Id 20',9300.00,0.00,0.00,12.50,1025.00,'2022-06-01 17:30:59','',''),(23,'1','274','1',1,'Retail Sale Id 21',9300.00,0.00,0.00,12.50,1025.00,'2022-06-01 17:45:37','',''),(24,'1','274','1',1,'Retail Sale Id 24',427904.16,0.00,0.00,575.14,47161.48,'2022-06-01 19:38:53','',''),(25,'1','274','1',1,'Retail Sale Id 25',1502.88,0.00,0.00,2.02,165.64,'2022-06-02 07:46:19','',''),(26,'1','274','1',1,'Retail Sale Id 26',9300.00,0.00,0.00,12.50,1025.00,'2022-06-02 08:19:01','',''),(27,'1','274','1',1,'Retail Sale Id 27',2998.32,0.00,0.00,4.03,330.46,'2022-06-02 08:21:42','',''),(28,'1','274','1',1,'Retail Sale Id 32',14880.00,0.00,0.00,20.00,1640.00,'2022-06-02 09:26:49','',''),(29,'1','274','1',1,'Retail Sale Id 35',3749.76,0.00,0.00,5.04,413.28,'2022-06-02 09:57:09','',''),(30,'1','274','1',1,'Retail Sale Id 36',9300.00,0.00,0.00,12.50,1025.00,'2022-06-02 10:16:23','',''),(31,'1','274','1',1,'Retail Sale Id 37',9300.00,0.00,0.00,12.50,1025.00,'2022-06-02 10:22:39','',''),(32,'1','274','1',1,'Retail Sale Id 38',9300.00,0.00,0.00,12.50,1025.00,'2022-06-02 10:32:26','',''),(33,'1','274','1',1,'Retail Sale Id 39',74400.00,0.00,0.00,100.00,8200.00,'2022-06-02 11:10:09','',''),(34,'1','274','1',1,'Retail Sale Id 40',4002.72,0.00,0.00,5.38,441.16,'2022-06-02 11:56:00','',''),(35,'1','274','1',1,'Retail Sale Id 41',9203.28,0.00,0.00,12.37,1014.34,'2022-06-02 12:25:47','',''),(36,'1','274','1',1,'Retail Sale Id 42',37200.00,0.00,0.00,50.00,4100.00,'2022-06-02 12:30:13','',''),(37,'1','274','1',1,'Retail Sale Id 43',744.00,0.00,0.00,1.00,82.00,'2022-06-02 12:37:27','',''),(38,'1','274','1',1,'Retail Sale Id 44',2001.36,0.00,0.00,2.69,220.58,'2022-06-02 12:38:48','',''),(39,'1','274','1',1,'Retail Sale Id 45',4501.20,0.00,0.00,6.05,496.10,'2022-06-02 12:50:07','',''),(40,'1','274','1',1,'Retail Sale Id 46',1502.88,0.00,0.00,2.02,165.64,'2022-06-02 12:54:40','',''),(41,'1','274','1',1,'Retail Sale Id 47',4002.72,0.00,0.00,5.38,441.16,'2022-06-02 13:01:20','',''),(42,'1','274','1',1,'Retail Sale Id 48',9300.00,0.00,0.00,12.50,1025.00,'2022-06-02 13:02:47','',''),(43,'1','274','1',1,'Retail Sale Id 49',4501.20,0.00,0.00,6.05,496.10,'2022-06-02 13:34:50','',''),(44,'1','274','1',1,'Retail Sale Id 50',3749.76,0.00,0.00,5.04,413.28,'2022-06-02 13:40:45','',''),(45,'1','274','1',1,'Retail Sale Id 51',2246.88,0.00,0.00,3.02,247.64,'2022-06-02 14:16:17','',''),(46,'1','274','1',1,'Retail Sale Id 52',2001.36,0.00,0.00,2.69,220.58,'2022-06-02 14:43:28','',''),(47,'1','274','1',1,'Retail Sale Id 53',2953.68,0.00,0.00,3.97,325.54,'2022-06-02 14:55:25','',''),(48,'1','274','1',1,'Retail Sale Id 54',98580.00,0.00,0.00,132.50,10865.00,'2022-06-02 15:07:19','',''),(49,'1','274','1',1,'Return of Retail Sale Id 54',0.00,98580.00,132.50,0.00,-10865.00,'2022-06-02 15:09:25','',''),(50,'1','274','1',1,'Retail Sale Id 55',24180.00,0.00,0.00,32.50,2665.00,'2022-06-02 15:11:27','',''),(51,'1','274','1',1,'Retail Sale Id 56',803.52,0.00,0.00,1.08,88.56,'2022-06-02 15:15:25','',''),(52,'1','274','1',1,'Retail Sale Id 57',2001.36,0.00,0.00,2.69,220.58,'2022-06-02 15:16:39','',''),(53,'1','274','1',1,'Retail Sale Id 58',9300.00,0.00,0.00,12.50,1025.00,'2022-06-02 15:25:02','',''),(54,'1','274','1',1,'Retail Sale Id 59',1502.88,0.00,0.00,2.02,165.64,'2022-06-02 15:29:26','',''),(55,'1','274','1',1,'Retail Sale Id 60',996.96,0.00,0.00,1.34,109.88,'2022-06-02 15:43:04','',''),(56,'1','274','1',1,'Retail Sale Id 61',996.96,0.00,0.00,1.34,109.88,'2022-06-02 15:46:32','',''),(57,'1','274','1',1,'Retail Sale Id 62',2246.88,0.00,0.00,3.02,247.64,'2022-06-02 15:50:20','',''),(58,'1','274','1',1,'Retail Sale Id 63',2001.36,0.00,0.00,2.69,220.58,'2022-06-02 15:58:04','',''),(59,'1','274','1',1,'Retail Sale Id 63',9300.00,0.00,0.00,12.50,1025.00,'2022-06-02 15:58:04','',''),(60,'1','274','1',1,'Retail Sale Id 64',1302.00,0.00,0.00,1.75,143.50,'2022-06-02 16:02:29','',''),(61,'1','274','1',1,'Retail Sale Id 65',3749.76,0.00,0.00,5.04,413.28,'2022-06-02 16:05:54','',''),(62,'1','274','1',1,'Retail Sale Id 66',4501.20,0.00,0.00,6.05,496.10,'2022-06-02 16:18:42','',''),(63,'1','274','1',1,'Retail Sale Id 67',9300.00,0.00,0.00,12.50,1025.00,'2022-06-02 16:24:48','',''),(64,'1','274','1',1,'Retail Sale Id 68',18600.00,0.00,0.00,25.00,2050.00,'2022-06-02 16:27:03','',''),(65,'1','274','1',1,'Retail Sale Id 69',2202.24,0.00,0.00,2.96,242.72,'2022-06-02 17:02:04','',''),(66,'1','274','1',1,'Retail Sale Id 70',4501.20,0.00,0.00,6.05,496.10,'2022-06-02 17:14:39','',''),(67,'1','274','1',1,'Retail Sale Id 71',1398.72,0.00,0.00,1.88,154.16,'2022-06-02 17:18:09','',''),(68,'1','274','1',1,'Retail Sale Id 72',9300.00,0.00,0.00,12.50,1025.00,'2022-06-02 17:19:27','',''),(69,'1','274','1',1,'Retail Sale Id 73',44989.68,0.00,0.00,60.47,4958.54,'2022-06-02 18:15:09','',''),(70,'1','274','1',1,'Distributed to operational loss for sales id:1',122814.24,0.00,0.00,185.52,0.00,'2022-06-02 19:16:55','',''),(71,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,2177980.00,3290.00,0.00,0.00,'2022-06-03 08:24:22','',''),(72,'1','274',NULL,1,'Reception corrector for bridging 2',0.00,0.00,0.00,3290.00,0.00,'2022-06-03 08:29:24','',''),(73,'1','274','1',1,'Received from bridging 2',0.00,0.00,3290.00,0.00,0.00,'2022-06-03 08:29:24','',''),(74,'1','274','1',1,'Retail Sale Id 74',996.96,0.00,0.00,1.34,109.88,'2022-06-03 08:30:55','',''),(75,'1','274','1',1,'Retail Sale Id 75',2202.24,0.00,0.00,2.96,242.72,'2022-06-03 08:32:05','',''),(76,'1','274','1',1,'Retail Sale Id 76',1502.88,0.00,0.00,2.02,165.64,'2022-06-03 08:33:22','',''),(77,'1','274','1',1,'Retail Sale Id 77',7998.00,0.00,0.00,10.75,881.50,'2022-06-03 08:35:02','',''),(78,'1','274','1',1,'Retail Sale Id 78',4501.20,0.00,0.00,6.05,496.10,'2022-06-03 08:35:45','',''),(79,'1','274','1',1,'Retail Sale Id 79',2246.88,0.00,0.00,3.02,247.64,'2022-06-03 08:36:29','',''),(80,'1','274','1',1,'Retail Sale Id 80',9300.00,0.00,0.00,12.50,1025.00,'2022-06-03 08:37:35','',''),(81,'1','274','1',1,'Retail Sale Id 81',7998.00,0.00,0.00,10.75,881.50,'2022-06-03 08:39:10','',''),(82,'1','274','1',1,'Retail Sale Id 82',4501.20,0.00,0.00,6.05,496.10,'2022-06-03 08:40:06','',''),(83,'1','274','1',1,'Retail Sale Id 83',9300.00,0.00,0.00,12.50,1025.00,'2022-06-03 08:41:55','',''),(84,'1','274','1',1,'Retail Sale Id 84',4501.20,0.00,0.00,6.05,496.10,'2022-06-03 08:42:30','',''),(85,'1','274','1',1,'Retail Sale Id 85',4501.20,0.00,0.00,6.05,496.10,'2022-06-03 09:06:24','',''),(86,'1','274','1',1,'Retail Sale Id 86',996.96,0.00,0.00,1.34,109.88,'2022-06-03 09:15:26','',''),(87,'1','274','1',1,'Retail Sale Id 87',2998.32,0.00,0.00,4.03,330.46,'2022-06-03 09:18:45','',''),(88,'1','274','1',1,'Retail Sale Id 88',2001.36,0.00,0.00,2.69,220.58,'2022-06-03 09:20:33','',''),(89,'1','274','1',1,'Retail Sale Id 89',3720.00,0.00,0.00,5.00,410.00,'2022-06-03 09:27:51','',''),(90,'1','274','1',1,'Retail Sale Id 89',4464.00,0.00,0.00,6.00,492.00,'2022-06-03 09:27:51','',''),(91,'1','274','1',1,'Retail Sale Id 90',2499.84,0.00,0.00,3.36,275.52,'2022-06-03 09:43:24','',''),(92,'1','274','1',1,'Retail Sale Id 92',1488.00,0.00,0.00,2.00,164.00,'2022-06-03 10:09:02','',''),(93,'1','274','1',1,'Retail Sale Id 93',2232.00,0.00,0.00,3.00,246.00,'2022-06-03 10:15:04','',''),(94,'1','274','1',1,'Retail Sale Id 94',803.52,0.00,0.00,1.08,88.56,'2022-06-03 10:24:58','',''),(95,'1','274','1',1,'Retail Sale Id 95',4501.20,0.00,0.00,6.05,496.10,'2022-06-03 10:47:39','',''),(96,'1','274','1',1,'Retail Sale Id 96',9300.00,0.00,0.00,12.50,1025.00,'2022-06-03 12:32:14','',''),(97,'1','274','1',1,'Retail Sale Id 96',9300.00,0.00,0.00,12.50,1025.00,'2022-06-03 12:32:14','',''),(98,'1','274','1',1,'Retail Sale Id 97',751.44,0.00,0.00,1.01,82.82,'2022-06-03 12:50:16','',''),(99,'1','274','1',1,'Retail Sale Id 98',2246.88,0.00,0.00,3.02,247.64,'2022-06-03 13:18:54','',''),(100,'1','274','1',1,'Retail Sale Id 99',29001.12,0.00,0.00,38.98,3196.36,'2022-06-03 15:06:29','',''),(101,'1','274','1',1,'Retail Sale Id 100',2001.36,0.00,0.00,2.69,220.58,'2022-06-03 15:08:42','',''),(102,'1','274','1',1,'Retail Sale Id 101',4501.20,0.00,0.00,6.05,496.10,'2022-06-03 15:12:14','',''),(103,'1','274','1',1,'Retail Sale Id 103',4501.20,0.00,0.00,6.05,496.10,'2022-06-03 15:14:04','',''),(104,'1','274','1',1,'Retail Sale Id 104',2001.36,0.00,0.00,2.69,220.58,'2022-06-03 16:03:49','',''),(105,'1','274','1',1,'Retail Sale Id 105',1398.72,0.00,0.00,1.88,154.16,'2022-06-03 16:05:10','',''),(106,'1','274','1',1,'Retail Sale Id 106',2246.88,0.00,0.00,3.02,247.64,'2022-06-03 16:08:30','',''),(107,'1','274','1',1,'Retail Sale Id 107',14500.56,0.00,0.00,19.49,1598.18,'2022-06-03 16:10:53','',''),(108,'1','274','1',1,'Retail Sale Id 108',2246.88,0.00,0.00,3.02,247.64,'2022-06-03 16:34:46','',''),(109,'1','274','1',1,'Retail Sale Id 109',3801.84,0.00,0.00,5.11,419.02,'2022-06-03 16:36:48','',''),(110,'1','274','1',1,'Retail Sale Id 110',4501.20,0.00,0.00,6.05,496.10,'2022-06-03 16:38:24','',''),(111,'1','274','1',1,'Retail Sale Id 111',9300.00,0.00,0.00,12.50,1025.00,'2022-06-03 16:41:34','',''),(112,'1','274','1',1,'Retail Sale Id 112',3749.76,0.00,0.00,5.04,413.28,'2022-06-03 16:49:10','',''),(113,'1','274','1',1,'Retail Sale Id 113',4501.20,0.00,0.00,6.05,496.10,'2022-06-03 17:07:13','',''),(114,'1','274','1',1,'Retail Sale Id 114',4501.20,0.00,0.00,6.05,496.10,'2022-06-03 17:08:49','',''),(115,'1','274','1',1,'Retail Sale Id 115',2998.32,0.00,0.00,4.03,330.46,'2022-06-03 17:11:12','',''),(116,'1','274','1',1,'Retail Sale Id 116',2246.88,0.00,0.00,3.02,247.64,'2022-06-03 17:12:49','',''),(117,'1','274','1',1,'Retail Sale Id 117',4501.20,0.00,0.00,6.05,496.10,'2022-06-03 17:26:26','',''),(118,'1','274','1',1,'Retail Sale Id 118',9300.00,0.00,0.00,12.50,1025.00,'2022-06-03 17:30:52','',''),(119,'1','274','1',1,'Retail Sale Id 119',2001.36,0.00,0.00,2.69,220.58,'2022-06-03 17:32:05','',''),(120,'1','274','1',1,'Retail Sale Id 120',4999.68,0.00,0.00,6.72,551.04,'2022-06-03 17:33:31','',''),(121,'1','274','1',1,'Retail Sale Id 121',2499.84,0.00,0.00,3.36,275.52,'2022-06-03 17:37:43','',''),(122,'1','274','1',1,'Retail Sale Id 122',2246.88,0.00,0.00,3.02,247.64,'2022-06-03 17:40:04','',''),(123,'1','274','1',1,'Retail Sale Id 122',2246.88,0.00,0.00,3.02,247.64,'2022-06-03 17:40:04','',''),(124,'1','274','1',1,'Retail Sale Id 123',1398.72,0.00,0.00,1.88,154.16,'2022-06-03 17:41:33','',''),(125,'1','274','1',1,'Retail Sale Id 124',4999.68,0.00,0.00,6.72,551.04,'2022-06-03 17:42:56','',''),(126,'1','274','1',1,'Retail Sale Id 126',4501.20,0.00,0.00,6.05,496.10,'2022-06-03 17:45:43','',''),(127,'1','274','1',1,'Retail Sale Id 127',1502.88,0.00,0.00,2.02,165.64,'2022-06-03 17:53:27','',''),(128,'1','274','1',1,'Retail Sale Id 128',9300.00,0.00,0.00,12.50,1025.00,'2022-06-03 17:58:13','',''),(129,'1','274','1',1,'Retail Sale Id 129',2246.88,0.00,0.00,3.02,247.64,'2022-06-03 18:04:18','',''),(130,'1','274','1',1,'Retail Sale Id 130',1502.88,0.00,0.00,2.02,165.64,'2022-06-03 18:05:36','',''),(131,'1','274','1',1,'Retail Sale Id 131',2246.88,0.00,0.00,3.02,247.64,'2022-06-03 18:26:39','',''),(132,'1','274','1',1,'Retail Sale Id 131',2246.88,0.00,0.00,3.02,247.64,'2022-06-03 18:26:39','',''),(133,'1','274','1',1,'Retail Sale Id 132',996.96,0.00,0.00,1.34,109.88,'2022-06-03 18:29:19','',''),(134,'1','274','1',1,'Retail Sale Id 134',2998.32,0.00,0.00,4.03,330.46,'2022-06-03 18:33:41','',''),(135,'1','274','1',1,'Retail Sale Id 135',9300.00,0.00,0.00,12.50,1025.00,'2022-06-03 18:43:14','',''),(136,'1','274','1',1,'Retail Sale Id 136',4999.68,0.00,0.00,6.72,551.04,'2022-06-03 18:55:46','',''),(137,'1','274','1',1,'Retail Sale Id 137',3749.76,0.00,0.00,5.04,413.28,'2022-06-03 19:03:04','',''),(138,'1','274','1',1,'Return of Retail Sale Id 131',0.00,2246.88,3.02,0.00,-247.64,'2022-06-03 21:07:47','',''),(139,'1','274','1',1,'Return of Retail Sale Id 131',0.00,2246.88,3.02,0.00,-247.64,'2022-06-03 21:07:47','',''),(140,'1','274','1',1,'Return of Retail Sale Id 96',0.00,9300.00,12.50,0.00,-1025.00,'2022-06-03 21:08:43','',''),(141,'1','274','1',1,'Return of Retail Sale Id 96',0.00,9300.00,12.50,0.00,-1025.00,'2022-06-03 21:08:43','',''),(142,'1','274','1',1,'Retail Sale Id 138',1696.32,0.00,0.00,2.28,186.96,'2022-06-03 21:12:57','',''),(143,'1','274','1',1,'Retail Sale Id 138',69013.44,0.00,0.00,92.76,7606.32,'2022-06-03 21:12:57','',''),(144,'1','274','1',1,'Retail Sale Id 139',9300.00,0.00,0.00,12.50,1025.00,'2022-06-04 07:23:46','',''),(145,'1','274','1',1,'Retail Sale Id 140',1502.88,0.00,0.00,2.02,165.64,'2022-06-04 08:06:05','',''),(146,'1','274','1',1,'Retail Sale Id 141',9300.00,0.00,0.00,12.50,1025.00,'2022-06-04 08:13:52','',''),(147,'1','274','1',1,'Retail Sale Id 142',4501.20,0.00,0.00,6.05,496.10,'2022-06-04 08:31:11','',''),(148,'1','274','1',1,'Retail Sale Id 143',4002.72,0.00,0.00,5.38,441.16,'2022-06-04 08:32:46','',''),(149,'1','274','1',1,'Retail Sale Id 144',498.48,0.00,0.00,0.67,54.94,'2022-06-04 08:36:43','',''),(150,'1','274','1',1,'Retail Sale Id 145',9300.00,0.00,0.00,12.50,1025.00,'2022-06-04 09:18:49','',''),(151,'1','274','1',1,'Retail Sale Id 146',2001.36,0.00,0.00,2.69,220.58,'2022-06-04 09:24:32','',''),(152,'1','274','1',1,'Retail Sale Id 147',4501.20,0.00,0.00,6.05,496.10,'2022-06-04 09:25:41','',''),(153,'1','274','1',1,'Retail Sale Id 148',3898.56,0.00,0.00,5.24,429.68,'2022-06-04 09:40:54','',''),(154,'1','274','1',1,'Retail Sale Id 150',9300.00,0.00,0.00,12.50,1025.00,'2022-06-04 09:53:59','',''),(155,'1','274','1',1,'Retail Sale Id 151',2001.36,0.00,0.00,2.69,220.58,'2022-06-04 09:56:27','',''),(156,'1','274','1',1,'Retail Sale Id 152',8496.48,0.00,0.00,11.42,936.44,'2022-06-04 10:01:48','',''),(157,'1','274','1',1,'Retail Sale Id 153',2246.88,0.00,0.00,3.02,247.64,'2022-06-04 10:06:09','',''),(158,'1','274','1',1,'Retail Sale Id 154',2246.88,0.00,0.00,3.02,247.64,'2022-06-04 10:09:53','',''),(159,'1','274','1',1,'Retail Sale Id 155',4999.68,0.00,0.00,6.72,551.04,'2022-06-04 10:11:37','',''),(160,'1','274','1',1,'Retail Sale Id 156',7440.00,0.00,0.00,10.00,820.00,'2022-06-04 10:17:49','',''),(161,'1','274','1',1,'Retail Sale Id 157',8496.48,0.00,0.00,11.42,936.44,'2022-06-04 10:32:37','',''),(162,'1','274','1',1,'Retail Sale Id 158',9002.40,0.00,0.00,12.10,992.20,'2022-06-04 10:34:36','',''),(163,'1','274','1',1,'Retail Sale Id 159',2246.88,0.00,0.00,3.02,247.64,'2022-06-04 10:48:27','',''),(164,'1','274','1',1,'Retail Sale Id 160',9300.00,0.00,0.00,12.50,1025.00,'2022-06-04 10:51:29','',''),(165,'1','274','1',1,'Retail Sale Id 161',1502.88,0.00,0.00,2.02,165.64,'2022-06-04 10:56:14','',''),(166,'1','274','1',1,'Retail Sale Id 162',2246.88,0.00,0.00,3.02,247.64,'2022-06-04 11:10:02','',''),(167,'1','274','1',1,'Retail Sale Id 163',9300.00,0.00,0.00,12.50,1025.00,'2022-06-04 11:32:07','',''),(168,'1','274','1',1,'Retail Sale Id 163',9300.00,0.00,0.00,12.50,1025.00,'2022-06-04 11:32:07','',''),(169,'1','274','1',1,'Retail Sale Id 163',9300.00,0.00,0.00,12.50,1025.00,'2022-06-04 11:32:07','',''),(170,'1','274','1',1,'Retail Sale Id 164',9300.00,0.00,0.00,12.50,1025.00,'2022-06-04 11:36:49','',''),(171,'1','274','1',1,'Retail Sale Id 164',9300.00,0.00,0.00,12.50,1025.00,'2022-06-04 11:36:49','',''),(172,'1','274','1',1,'Retail Sale Id 165',8496.48,0.00,0.00,11.42,936.44,'2022-06-04 11:57:39','',''),(173,'1','274','1',1,'Retail Sale Id 166',2246.88,0.00,0.00,3.02,247.64,'2022-06-04 12:06:03','',''),(174,'1','274','1',1,'Retail Sale Id 167',2246.88,0.00,0.00,3.02,247.64,'2022-06-04 12:06:50','',''),(175,'1','274','1',1,'Retail Sale Id 168',2246.88,0.00,0.00,3.02,247.64,'2022-06-04 12:29:15','',''),(176,'1','274','1',1,'Retail Sale Id 169',4501.20,0.00,0.00,6.05,496.10,'2022-06-04 13:25:34','',''),(177,'1','274','1',1,'Retail Sale Id 170',2001.36,0.00,0.00,2.69,220.58,'2022-06-04 13:28:12','',''),(178,'1','274','1',1,'Retail Sale Id 171',4501.20,0.00,0.00,6.05,496.10,'2022-06-04 13:33:08','',''),(179,'1','274','1',1,'Retail Sale Id 172',9300.00,0.00,0.00,12.50,1025.00,'2022-06-04 13:34:55','',''),(180,'1','274','1',1,'Retail Sale Id 173',4501.20,0.00,0.00,6.05,496.10,'2022-06-04 14:27:41','',''),(181,'1','274','1',1,'Retail Sale Id 173',4501.20,0.00,0.00,6.05,496.10,'2022-06-04 14:27:41','',''),(182,'1','274','1',1,'Retail Sale Id 174',37200.00,0.00,0.00,50.00,4100.00,'2022-06-04 14:32:30','',''),(183,'1','274','1',1,'Retail Sale Id 175',9300.00,0.00,0.00,12.50,1025.00,'2022-06-04 14:43:27','',''),(184,'1','274','1',1,'Retail Sale Id 176',46500.00,0.00,0.00,62.50,5125.00,'2022-06-04 14:59:32','',''),(185,'1','274','1',1,'Retail Sale Id 178',2998.32,0.00,0.00,4.03,330.46,'2022-06-04 15:15:27','',''),(186,'1','274','1',1,'Retail Sale Id 179',4999.68,0.00,0.00,6.72,551.04,'2022-06-04 15:18:55','',''),(187,'1','274','1',1,'Retail Sale Id 180',9300.00,0.00,0.00,12.50,1025.00,'2022-06-04 15:33:53','',''),(188,'1','274','1',1,'Retail Sale Id 181',1488000.00,0.00,0.00,2000.00,164000.00,'2022-06-04 15:37:18','',''),(189,'1','274','1',1,'Retail Sale Id 182',2001.36,0.00,0.00,2.69,220.58,'2022-06-04 15:41:16','',''),(190,'1','274','1',1,'Retail Sale Id 183',9300.00,0.00,0.00,12.50,1025.00,'2022-06-04 15:43:41','',''),(191,'1','274','1',1,'Retail Sale Id 184',9300.00,0.00,0.00,12.50,1025.00,'2022-06-04 15:45:41','',''),(192,'1','274','1',1,'Retail Sale Id 185',2001.36,0.00,0.00,2.69,220.58,'2022-06-04 15:48:30','',''),(193,'1','274','1',1,'Retail Sale Id 186',2797.44,0.00,0.00,3.76,308.32,'2022-06-04 15:49:52','',''),(194,'1','274','1',1,'Retail Sale Id 189',2998.32,0.00,0.00,4.03,330.46,'2022-06-04 15:58:17','',''),(195,'1','274','1',1,'Retail Sale Id 190',2998.32,0.00,0.00,4.03,330.46,'2022-06-04 16:03:20','',''),(196,'1','274','1',1,'Retail Sale Id 191',37200.00,0.00,0.00,50.00,4100.00,'2022-06-04 16:07:45','',''),(197,'1','274','1',1,'Retail Sale Id 192',4002.72,0.00,0.00,5.38,441.16,'2022-06-04 16:24:48','',''),(198,'1','274','1',1,'Return of Retail Sale Id 181',0.00,1488000.00,2000.00,0.00,-164000.00,'2022-06-04 16:30:56','',''),(199,'1','274','1',1,'Retail Sale Id 193',1502.88,0.00,0.00,2.02,165.64,'2022-06-04 16:34:25','',''),(200,'1','274','1',1,'Retail Sale Id 194',4002.72,0.00,0.00,5.38,441.16,'2022-06-04 16:41:32','',''),(201,'1','274','1',1,'Retail Sale Id 195',4002.72,0.00,0.00,5.38,441.16,'2022-06-04 16:54:59','',''),(202,'1','274','1',1,'Retail Sale Id 196',2246.88,0.00,0.00,3.02,247.64,'2022-06-04 16:57:52','',''),(203,'1','274','1',1,'Retail Sale Id 197',3749.76,0.00,0.00,5.04,413.28,'2022-06-04 17:06:21','',''),(204,'1','274','1',1,'Retail Sale Id 198',9300.00,0.00,0.00,12.50,1025.00,'2022-06-04 17:14:26','',''),(205,'1','274','1',1,'Retail Sale Id 199',9300.00,0.00,0.00,12.50,1025.00,'2022-06-04 17:24:10','',''),(206,'1','274','1',1,'Retail Sale Id 200',4501.20,0.00,0.00,6.05,496.10,'2022-06-04 17:26:54','',''),(207,'1','274','1',1,'Retail Sale Id 201',996.96,0.00,0.00,1.34,109.88,'2022-06-04 17:30:48','',''),(208,'1','274','1',1,'Retail Sale Id 202',7499.52,0.00,0.00,10.08,826.56,'2022-06-04 17:38:59','',''),(209,'1','274','1',1,'Retail Sale Id 203',9300.00,0.00,0.00,12.50,1025.00,'2022-06-04 17:50:11','',''),(210,'1','274','1',1,'Retail Sale Id 204',9300.00,0.00,0.00,12.50,1025.00,'2022-06-04 17:55:31','',''),(211,'1','274','1',1,'Retail Sale Id 205',4999.68,0.00,0.00,6.72,551.04,'2022-06-04 18:20:08','',''),(212,'1','274','1',1,'Retail Sale Id 206',4501.20,0.00,0.00,6.05,496.10,'2022-06-04 18:21:36','',''),(213,'1','274','1',1,'Retail Sale Id 207',996.96,0.00,0.00,1.34,109.88,'2022-06-04 18:31:04','',''),(214,'1','274','1',1,'Retail Sale Id 207',3496.80,0.00,0.00,4.70,385.40,'2022-06-04 18:31:04','',''),(215,'1','274','1',1,'Retail Sale Id 208',5200.56,0.00,0.00,6.99,573.18,'2022-06-04 18:41:35','',''),(216,'1','274','1',1,'Retail Sale Id 208',5200.56,0.00,0.00,6.99,573.18,'2022-06-04 18:41:35','',''),(217,'1','274','1',1,'Retail Sale Id 209',9300.00,0.00,0.00,12.50,1025.00,'2022-06-04 18:44:20','',''),(218,'1','274','1',1,'Retail Sale Id 210',2246.88,0.00,0.00,3.02,247.64,'2022-06-04 18:48:43','',''),(219,'1','274','1',1,'Retail Sale Id 211',1197.84,0.00,0.00,1.61,132.02,'2022-06-04 18:52:49','',''),(220,'1','274','1',1,'Retail Sale Id 212',4501.20,0.00,0.00,6.05,496.10,'2022-06-04 18:54:23','',''),(221,'1','274','1',1,'Retail Sale Id 214',9300.00,0.00,0.00,12.50,1025.00,'2022-06-04 19:13:56','',''),(222,'1','274','1',1,'Return of Retail Sale Id 206',0.00,4501.20,6.05,0.00,-496.10,'2022-06-04 19:51:34','',''),(223,'1','274','1',1,'Return of Retail Sale Id 209',0.00,9300.00,12.50,0.00,-1025.00,'2022-06-04 19:53:07','',''),(224,'1','274','1',1,'Retail Sale Id 215',10713.60,0.00,0.00,14.40,1180.80,'2022-06-04 19:55:53','',''),(225,'1','274','1',1,'Retail Sale Id 215',19053.84,0.00,0.00,25.61,2100.02,'2022-06-04 19:55:53','',''),(226,'1','274','1',1,'Retail Sale Id 216',4501.20,0.00,0.00,6.05,496.10,'2022-06-05 07:30:05','',''),(227,'1','274','1',1,'Retail Sale Id 217',2001.36,0.00,0.00,2.69,220.58,'2022-06-05 07:34:48','',''),(228,'1','274','1',1,'Retail Sale Id 218',4002.72,0.00,0.00,5.38,441.16,'2022-06-05 08:13:17','',''),(229,'1','274','1',1,'Retail Sale Id 219',4501.20,0.00,0.00,6.05,496.10,'2022-06-05 08:31:13','',''),(230,'1','274','1',1,'Retail Sale Id 220',4501.20,0.00,0.00,6.05,496.10,'2022-06-05 08:51:23','',''),(231,'1','274','1',1,'Retail Sale Id 221',699.36,0.00,0.00,0.94,77.08,'2022-06-05 09:04:04','',''),(232,'1','274','1',1,'Retail Sale Id 222',2001.36,0.00,0.00,2.69,220.58,'2022-06-05 09:05:24','',''),(233,'1','274','1',1,'Retail Sale Id 223',2998.32,0.00,0.00,4.03,330.46,'2022-06-05 10:08:09','',''),(234,'1','274','1',1,'Retail Sale Id 224',4501.20,0.00,0.00,6.05,496.10,'2022-06-05 10:14:34','',''),(235,'1','274','1',1,'Retail Sale Id 226',9300.00,0.00,0.00,12.50,1025.00,'2022-06-05 10:25:36','',''),(236,'1','274','1',1,'Retail Sale Id 227',4501.20,0.00,0.00,6.05,496.10,'2022-06-05 10:41:07','',''),(237,'1','274','1',1,'Retail Sale Id 228',2001.36,0.00,0.00,2.69,220.58,'2022-06-05 10:57:46','',''),(238,'1','274','1',1,'Retail Sale Id 229',2001.36,0.00,0.00,2.69,220.58,'2022-06-05 11:01:21','',''),(239,'1','274','1',1,'Retail Sale Id 230',996.96,0.00,0.00,1.34,109.88,'2022-06-05 11:16:16','',''),(240,'1','274','1',1,'Retail Sale Id 231',4002.72,0.00,0.00,5.38,441.16,'2022-06-05 11:23:07','',''),(241,'1','274','1',1,'Retail Sale Id 232',2246.88,0.00,0.00,3.02,247.64,'2022-06-05 11:31:41','',''),(242,'1','274','1',1,'Retail Sale Id 233',3697.68,0.00,0.00,4.97,407.54,'2022-06-05 11:34:21','',''),(243,'1','274','1',1,'Retail Sale Id 233',9300.00,0.00,0.00,12.50,1025.00,'2022-06-05 11:34:21','',''),(244,'1','274','1',1,'Retail Sale Id 234',2001.36,0.00,0.00,2.69,220.58,'2022-06-05 11:36:28','',''),(245,'1','274','1',1,'Retail Sale Id 235',9002.40,0.00,0.00,12.10,992.20,'2022-06-05 11:52:24','',''),(246,'1','274','1',1,'Retail Sale Id 236',4501.20,0.00,0.00,6.05,496.10,'2022-06-05 11:56:09','',''),(247,'1','274','1',1,'Retail Sale Id 237',9300.00,0.00,0.00,12.50,1025.00,'2022-06-05 11:59:00','',''),(248,'1','274','1',1,'Retail Sale Id 237',14880.00,0.00,0.00,20.00,1640.00,'2022-06-05 11:59:00','',''),(249,'1','274','1',1,'Retail Sale Id 238',2246.88,0.00,0.00,3.02,247.64,'2022-06-05 12:00:46','',''),(250,'1','274','1',1,'Retail Sale Id 239',9300.00,0.00,0.00,12.50,1025.00,'2022-06-05 12:12:29','',''),(251,'1','274','1',1,'Retail Sale Id 240',4501.20,0.00,0.00,6.05,496.10,'2022-06-05 12:13:28','',''),(252,'1','274','1',1,'Retail Sale Id 241',2246.88,0.00,0.00,3.02,247.64,'2022-06-05 12:27:57','',''),(253,'1','274','1',1,'Retail Sale Id 241',9300.00,0.00,0.00,12.50,1025.00,'2022-06-05 12:27:57','',''),(254,'1','274','1',1,'Retail Sale Id 242',4501.20,0.00,0.00,6.05,496.10,'2022-06-05 12:30:37','',''),(255,'1','274','1',1,'Retail Sale Id 242',4501.20,0.00,0.00,6.05,496.10,'2022-06-05 12:30:37','',''),(256,'1','274','1',1,'Retail Sale Id 242',9300.00,0.00,0.00,12.50,1025.00,'2022-06-05 12:30:37','',''),(257,'1','274','1',1,'Retail Sale Id 243',8198.88,0.00,0.00,11.02,903.64,'2022-06-05 12:35:36','',''),(258,'1','274','1',1,'Retail Sale Id 244',4501.20,0.00,0.00,6.05,496.10,'2022-06-05 12:39:37','',''),(259,'1','274','1',1,'Retail Sale Id 245',2998.32,0.00,0.00,4.03,330.46,'2022-06-05 12:47:55','',''),(260,'1','274','1',1,'Retail Sale Id 246',1502.88,0.00,0.00,2.02,165.64,'2022-06-05 12:49:54','',''),(261,'1','274','1',1,'Retail Sale Id 247',2998.32,0.00,0.00,4.03,330.46,'2022-06-05 13:02:48','',''),(262,'1','274','1',1,'Retail Sale Id 248',3749.76,0.00,0.00,5.04,413.28,'2022-06-05 13:04:58','',''),(263,'1','274','1',1,'Retail Sale Id 249',7001.04,0.00,0.00,9.41,771.62,'2022-06-05 13:10:02','',''),(264,'1','274','1',1,'Retail Sale Id 250',37200.00,0.00,0.00,50.00,4100.00,'2022-06-05 15:27:51','',''),(265,'1','274','1',1,'Retail Sale Id 251',4501.20,0.00,0.00,6.05,496.10,'2022-06-05 15:29:17','',''),(266,'1','274','1',1,'Retail Sale Id 252',2499.84,0.00,0.00,3.36,275.52,'2022-06-05 16:22:56','',''),(267,'1','274','1',1,'Retail Sale Id 253',2001.36,0.00,0.00,2.69,220.58,'2022-06-05 16:31:25','',''),(268,'1','274','1',1,'Retail Sale Id 254',2001.36,0.00,0.00,2.69,220.58,'2022-06-05 16:38:03','',''),(269,'1','274','1',1,'Retail Sale Id 256',996.96,0.00,0.00,1.34,109.88,'2022-06-05 16:50:17','',''),(270,'1','274','1',1,'Retail Sale Id 257',1502.88,0.00,0.00,2.02,165.64,'2022-06-05 16:51:42','',''),(271,'1','274','1',1,'Retail Sale Id 258',2998.32,0.00,0.00,4.03,330.46,'2022-06-05 17:18:52','',''),(272,'1','274','1',1,'Retail Sale Id 259',3496.80,0.00,0.00,4.70,385.40,'2022-06-05 17:25:24','',''),(273,'1','274','1',1,'Retail Sale Id 261',3801.84,0.00,0.00,5.11,419.02,'2022-06-05 17:34:11','',''),(274,'1','274','1',1,'Retail Sale Id 262',2001.36,0.00,0.00,2.69,220.58,'2022-06-05 17:39:57','',''),(275,'1','274','1',1,'Retail Sale Id 263',2246.88,0.00,0.00,3.02,247.64,'2022-06-05 17:59:00','',''),(276,'1','274','1',1,'Retail Sale Id 265',4501.20,0.00,0.00,6.05,496.10,'2022-06-05 18:01:51','',''),(277,'1','274','1',1,'Retail Sale Id 267',4501.20,0.00,0.00,6.05,496.10,'2022-06-05 18:05:04','',''),(278,'1','274','1',1,'Retail Sale Id 269',996.96,0.00,0.00,1.34,109.88,'2022-06-05 18:05:59','',''),(279,'1','274','1',1,'Retail Sale Id 270',2001.36,0.00,0.00,2.69,220.58,'2022-06-05 18:08:50','',''),(280,'1','274','1',1,'Retail Sale Id 271',2246.88,0.00,0.00,3.02,247.64,'2022-06-05 18:11:16','',''),(281,'1','274','1',1,'Retail Sale Id 272',699.36,0.00,0.00,0.94,77.08,'2022-06-05 18:26:57','',''),(282,'1','274','1',1,'Retail Sale Id 273',4501.20,0.00,0.00,6.05,496.10,'2022-06-05 18:33:08','',''),(283,'1','274','1',1,'Retail Sale Id 274',3749.76,0.00,0.00,5.04,413.28,'2022-06-05 18:42:24','',''),(284,'1','274','1',1,'Retail Sale Id 276',900.24,0.00,0.00,1.21,99.22,'2022-06-05 18:46:08','',''),(285,'1','274','1',1,'Retail Sale Id 277',2246.88,0.00,0.00,3.02,247.64,'2022-06-05 18:52:05','',''),(286,'1','274','1',1,'Retail Sale Id 278',7499.52,0.00,0.00,10.08,826.56,'2022-06-05 18:57:58','',''),(287,'1','274','1',1,'Retail Sale Id 279',2246.88,0.00,0.00,3.02,247.64,'2022-06-05 19:07:49','',''),(288,'1','274','1',1,'Retail Sale Id 280',751.44,0.00,0.00,1.01,82.82,'2022-06-05 19:09:05','',''),(289,'1','274','1',1,'Retail Sale Id 281',13548.24,0.00,0.00,18.21,1493.22,'2022-06-05 20:35:15','',''),(290,'1','274','1',1,'Retail Sale Id 281',80039.52,0.00,0.00,107.58,8821.56,'2022-06-05 20:35:15','',''),(291,'1','274','1',1,'Retail Sale Id 282',9300.00,0.00,0.00,12.50,1025.00,'2022-06-06 07:35:14','',''),(292,'1','274','1',1,'Retail Sale Id 283',18600.00,0.00,0.00,25.00,2050.00,'2022-06-06 07:57:30','',''),(293,'1','274','1',1,'Retail Sale Id 284',9300.00,0.00,0.00,12.50,1025.00,'2022-06-06 08:05:49','',''),(294,'1','274','1',1,'Retail Sale Id 285',751.44,0.00,0.00,1.01,82.82,'2022-06-06 08:23:50','',''),(295,'1','274','1',1,'Retail Sale Id 286',1502.88,0.00,0.00,2.02,165.64,'2022-06-06 08:51:24','',''),(296,'1','274','1',1,'Retail Sale Id 287',996.96,0.00,0.00,1.34,109.88,'2022-06-06 09:01:37','',''),(297,'1','274','1',1,'Retail Sale Id 288',4501.20,0.00,0.00,6.05,496.10,'2022-06-06 09:13:41','',''),(298,'1','274','1',1,'Retail Sale Id 289',5996.64,0.00,0.00,8.06,660.92,'2022-06-06 09:25:33','',''),(299,'1','274','1',1,'Return of Retail Sale Id 289',0.00,5996.64,8.06,0.00,-660.92,'2022-06-06 09:37:19','',''),(300,'1','274','1',1,'Retail Sale Id 291',2998.32,0.00,0.00,4.03,330.46,'2022-06-06 09:51:01','',''),(301,'1','274','1',1,'Retail Sale Id 292',2998.32,0.00,0.00,4.03,330.46,'2022-06-06 09:52:37','',''),(302,'1','274','1',1,'Retail Sale Id 293',9300.00,0.00,0.00,12.50,1025.00,'2022-06-06 10:30:01','',''),(303,'1','274','1',1,'Retail Sale Id 294',3720.00,0.00,0.00,5.00,410.00,'2022-06-06 10:57:57','',''),(304,'1','274','1',1,'Retail Sale Id 295',751.44,0.00,0.00,1.01,82.82,'2022-06-06 11:03:31','',''),(305,'1','274','1',1,'Retail Sale Id 296',9300.00,0.00,0.00,12.50,1025.00,'2022-06-06 11:22:09','',''),(306,'1','274','1',1,'Retail Sale Id 297',7998.00,0.00,0.00,10.75,881.50,'2022-06-06 11:29:35','',''),(307,'1','274','1',1,'Retail Sale Id 298',2001.36,0.00,0.00,2.69,220.58,'2022-06-06 11:31:52','',''),(308,'1','274','1',1,'Retail Sale Id 299',2246.88,0.00,0.00,3.02,247.64,'2022-06-06 11:33:20','',''),(309,'1','274','1',1,'Retail Sale Id 300',3720.00,0.00,0.00,5.00,410.00,'2022-06-06 11:36:20','',''),(310,'1','274','1',1,'Retail Sale Id 302',2246.88,0.00,0.00,3.02,247.64,'2022-06-06 12:02:12','',''),(311,'1','274','1',1,'Retail Sale Id 307',4501.20,0.00,0.00,6.05,496.10,'2022-06-06 12:11:44','',''),(312,'1','274','1',1,'Retail Sale Id 309',2246.88,0.00,0.00,3.02,247.64,'2022-06-06 12:13:43','',''),(313,'1','274','1',1,'Retail Sale Id 310',9002.40,0.00,0.00,12.10,992.20,'2022-06-06 12:43:08','',''),(314,'1','274','1',1,'Retail Sale Id 311',74400.00,0.00,0.00,100.00,8200.00,'2022-06-06 14:12:22','',''),(315,'1','274','1',1,'Retail Sale Id 312',1502.88,0.00,0.00,2.02,165.64,'2022-06-06 15:09:41','',''),(316,'1','274','1',1,'Retail Sale Id 313',2246.88,0.00,0.00,3.02,247.64,'2022-06-06 15:46:15','',''),(317,'1','274','1',1,'Retail Sale Id 314',1502.88,0.00,0.00,2.02,165.64,'2022-06-06 15:50:52','',''),(318,'1','274','1',1,'Retail Sale Id 315',9300.00,0.00,0.00,12.50,1025.00,'2022-06-06 15:52:43','',''),(319,'1','274','1',1,'Retail Sale Id 316',3749.76,0.00,0.00,5.04,413.28,'2022-06-06 15:57:24','',''),(320,'1','274','1',1,'Retail Sale Id 317',4501.20,0.00,0.00,6.05,496.10,'2022-06-06 16:01:58','',''),(321,'1','274','1',1,'Retail Sale Id 318',3496.80,0.00,0.00,4.70,385.40,'2022-06-06 16:20:05','',''),(322,'1','274','1',1,'Retail Sale Id 319',2998.32,0.00,0.00,4.03,330.46,'2022-06-06 16:36:09','',''),(323,'1','274','1',1,'Retail Sale Id 320',4397.04,0.00,0.00,5.91,484.62,'2022-06-06 16:37:36','',''),(324,'1','274','1',1,'Retail Sale Id 321',602.64,0.00,0.00,0.81,66.42,'2022-06-06 16:45:36','',''),(325,'1','274','1',1,'Retail Sale Id 322',2001.36,0.00,0.00,2.69,220.58,'2022-06-06 16:58:05','',''),(326,'1','274','1',1,'Retail Sale Id 323',2246.88,0.00,0.00,3.02,247.64,'2022-06-06 17:03:35','',''),(327,'1','274','1',1,'Retail Sale Id 324',2232.00,0.00,0.00,3.00,246.00,'2022-06-06 17:07:33','',''),(328,'1','274','1',1,'Retail Sale Id 325',4002.72,0.00,0.00,5.38,441.16,'2022-06-06 17:10:13','',''),(329,'1','274','1',1,'Retail Sale Id 328',4501.20,0.00,0.00,6.05,496.10,'2022-06-06 17:24:13','',''),(330,'1','274','1',1,'Retail Sale Id 329',2246.88,0.00,0.00,3.02,247.64,'2022-06-06 17:26:38','',''),(331,'1','274','1',1,'Retail Sale Id 330',2998.32,0.00,0.00,4.03,330.46,'2022-06-06 17:42:35','',''),(332,'1','274','1',1,'Retail Sale Id 333',9300.00,0.00,0.00,12.50,1025.00,'2022-06-06 18:07:31','',''),(333,'1','274','1',1,'Retail Sale Id 334',9300.00,0.00,0.00,12.50,1025.00,'2022-06-06 18:09:17','',''),(334,'1','274','1',1,'Retail Sale Id 334',9300.00,0.00,0.00,12.50,1025.00,'2022-06-06 18:09:17','',''),(335,'1','274','1',1,'Retail Sale Id 335',9002.40,0.00,0.00,12.10,992.20,'2022-06-06 18:17:23','',''),(336,'1','274','1',1,'Retail Sale Id 336',2202.24,0.00,0.00,2.96,242.72,'2022-06-06 18:23:04','',''),(337,'1','274','1',1,'Retail Sale Id 337',2499.84,0.00,0.00,3.36,275.52,'2022-06-06 18:27:50','',''),(338,'1','274','1',1,'Retail Sale Id 338',3749.76,0.00,0.00,5.04,413.28,'2022-06-06 18:49:52','',''),(339,'1','274','1',1,'Retail Sale Id 339',14880.00,0.00,0.00,20.00,1640.00,'2022-06-06 18:52:55','',''),(340,'1','274','1',1,'Retail Sale Id 340',2499.84,0.00,0.00,3.36,275.52,'2022-06-06 18:59:02','',''),(341,'1','274','1',1,'Retail Sale Id 341',2499.84,0.00,0.00,3.36,275.52,'2022-06-06 19:01:20','',''),(342,'1','274','1',1,'Retail Sale Id 342',3749.76,0.00,0.00,5.04,413.28,'2022-06-06 19:02:33','',''),(343,'1','274','1',1,'Retail Sale Id 343',3221.52,0.00,0.00,4.33,355.06,'2022-06-06 22:05:31','',''),(344,'1','274','1',1,'Retail Sale Id 343',27580.08,0.00,0.00,37.07,3039.74,'2022-06-06 22:05:31','',''),(345,'1','274','1',1,'Retail Sale Id 344',996.96,0.00,0.00,1.34,109.88,'2022-06-07 07:18:17','',''),(346,'1','274','1',1,'Retail Sale Id 345',4002.72,0.00,0.00,5.38,441.16,'2022-06-07 07:38:44','',''),(347,'1','274','1',1,'Retail Sale Id 346',996.96,0.00,0.00,1.34,109.88,'2022-06-07 08:04:49','',''),(348,'1','274','1',1,'Retail Sale Id 347',9300.00,0.00,0.00,12.50,1025.00,'2022-06-07 08:06:58','',''),(349,'1','274','1',1,'Retail Sale Id 348',2001.36,0.00,0.00,2.69,220.58,'2022-06-07 08:23:50','',''),(350,'1','274','1',1,'Retail Sale Id 348',2998.32,0.00,0.00,4.03,330.46,'2022-06-07 08:23:50','',''),(351,'1','274','1',1,'Retail Sale Id 349',3749.76,0.00,0.00,5.04,413.28,'2022-06-07 10:41:41','',''),(352,'1','274','1',1,'Retail Sale Id 350',9002.40,0.00,0.00,12.10,992.20,'2022-06-07 11:27:43','',''),(353,'1','274','1',1,'Retail Sale Id 351',9300.00,0.00,0.00,12.50,1025.00,'2022-06-07 11:36:02','',''),(354,'1','274','1',1,'Retail Sale Id 352',27996.72,0.00,0.00,37.63,3085.66,'2022-06-07 11:41:44','',''),(355,'1','274','1',1,'Retail Sale Id 353',37200.00,0.00,0.00,50.00,4100.00,'2022-06-07 12:04:10','',''),(356,'1','274','1',1,'Retail Sale Id 354',9300.00,0.00,0.00,12.50,1025.00,'2022-06-07 12:05:11','',''),(357,'1','274','1',1,'Retail Sale Id 355',4999.68,0.00,0.00,6.72,551.04,'2022-06-07 12:45:42','',''),(358,'1','274','1',1,'Retail Sale Id 356',9300.00,0.00,0.00,12.50,1025.00,'2022-06-07 12:47:28','',''),(359,'1','274','1',1,'Retail Sale Id 357',2246.88,0.00,0.00,3.02,247.64,'2022-06-07 12:57:57','',''),(360,'1','274','1',1,'Retail Sale Id 359',4501.20,0.00,0.00,6.05,496.10,'2022-06-07 12:58:54','',''),(361,'1','274','1',1,'Retail Sale Id 360',9300.00,0.00,0.00,12.50,1025.00,'2022-06-07 13:47:10','',''),(362,'1','274','1',1,'Retail Sale Id 361',13801.20,0.00,0.00,18.55,1521.10,'2022-06-07 14:03:36','',''),(363,'1','274','1',1,'Retail Sale Id 362',9002.40,0.00,0.00,12.10,992.20,'2022-06-07 14:08:12','',''),(364,'1','274','1',1,'Retail Sale Id 363',996.96,0.00,0.00,1.34,109.88,'2022-06-07 14:32:25','',''),(365,'1','274','1',1,'Retail Sale Id 365',2001.36,0.00,0.00,2.69,220.58,'2022-06-07 14:55:47','',''),(366,'1','274','1',1,'Retail Sale Id 367',996.96,0.00,0.00,1.34,109.88,'2022-06-07 15:02:15','',''),(367,'1','274','1',1,'Retail Sale Id 368',498.48,0.00,0.00,0.67,54.94,'2022-06-07 15:11:56','',''),(368,'1','274','1',1,'Retail Sale Id 370',4002.72,0.00,0.00,5.38,441.16,'2022-06-07 15:31:14','',''),(369,'1','274','1',1,'Retail Sale Id 371',2499.84,0.00,0.00,3.36,275.52,'2022-06-07 15:34:37','',''),(370,'1','274','1',1,'Retail Sale Id 372',18600.00,0.00,0.00,25.00,2050.00,'2022-06-07 15:55:51','',''),(371,'1','274','1',1,'Retail Sale Id 373',9300.00,0.00,0.00,12.50,1025.00,'2022-06-07 16:18:49','',''),(372,'1','274','1',1,'Retail Sale Id 374',46500.00,0.00,0.00,62.50,5125.00,'2022-06-07 16:22:11','',''),(373,'1','274','1',1,'Retail Sale Id 375',4999.68,0.00,0.00,6.72,551.04,'2022-06-07 16:25:25','',''),(374,'1','274','1',1,'Retail Sale Id 376',4501.20,0.00,0.00,6.05,496.10,'2022-06-07 16:53:30','',''),(375,'1','274','1',1,'Retail Sale Id 377',3720.00,0.00,0.00,5.00,410.00,'2022-06-07 17:02:07','',''),(376,'1','274','1',1,'Retail Sale Id 378',4501.20,0.00,0.00,6.05,496.10,'2022-06-07 17:03:23','',''),(377,'1','274','1',1,'Retail Sale Id 379',1502.88,0.00,0.00,2.02,165.64,'2022-06-07 17:08:20','',''),(378,'1','274','1',1,'Retail Sale Id 380',2246.88,0.00,0.00,3.02,247.64,'2022-06-07 17:10:04','',''),(379,'1','274','1',1,'Retail Sale Id 381',1502.88,0.00,0.00,2.02,165.64,'2022-06-07 17:12:06','',''),(380,'1','274','1',1,'Retail Sale Id 382',2246.88,0.00,0.00,3.02,247.64,'2022-06-07 17:15:37','',''),(381,'1','274','1',1,'Retail Sale Id 383',2246.88,0.00,0.00,3.02,247.64,'2022-06-07 17:16:50','',''),(382,'1','274','1',1,'Retail Sale Id 384',9300.00,0.00,0.00,12.50,1025.00,'2022-06-07 17:19:06','',''),(383,'1','274','1',1,'Retail Sale Id 385',2998.32,0.00,0.00,4.03,330.46,'2022-06-07 17:21:10','',''),(384,'1','274','1',1,'Retail Sale Id 386',2246.88,0.00,0.00,3.02,247.64,'2022-06-07 17:36:20','',''),(385,'1','274','1',1,'Retail Sale Id 387',2998.32,0.00,0.00,4.03,330.46,'2022-06-07 17:39:00','',''),(386,'1','274','1',1,'Retail Sale Id 388',8198.88,0.00,0.00,11.02,903.64,'2022-06-07 17:40:12','',''),(387,'1','274','1',1,'Retail Sale Id 389',9300.00,0.00,0.00,12.50,1025.00,'2022-06-07 17:46:16','',''),(388,'1','274','1',1,'Retail Sale Id 390',9300.00,0.00,0.00,12.50,1025.00,'2022-06-07 17:47:29','',''),(389,'1','274','1',1,'Retail Sale Id 391',996.96,0.00,0.00,1.34,109.88,'2022-06-07 17:53:20','',''),(390,'1','274','1',1,'Retail Sale Id 392',4501.20,0.00,0.00,6.05,496.10,'2022-06-07 17:58:33','',''),(391,'1','274','1',1,'Retail Sale Id 393',3749.76,0.00,0.00,5.04,413.28,'2022-06-07 18:02:32','',''),(392,'1','274','1',1,'Retail Sale Id 394',3749.76,0.00,0.00,5.04,413.28,'2022-06-07 18:03:41','',''),(393,'1','274','1',1,'Retail Sale Id 395',996.96,0.00,0.00,1.34,109.88,'2022-06-07 18:04:52','',''),(394,'1','274','1',1,'Retail Sale Id 396',5996.64,0.00,0.00,8.06,660.92,'2022-06-07 18:07:14','',''),(395,'1','274','1',1,'Retail Sale Id 397',1599.60,0.00,0.00,2.15,176.30,'2022-06-07 18:08:31','',''),(396,'1','274','1',1,'Retail Sale Id 398',2499.84,0.00,0.00,3.36,275.52,'2022-06-07 18:09:30','',''),(397,'1','274','1',1,'Retail Sale Id 399',996.96,0.00,0.00,1.34,109.88,'2022-06-07 18:10:26','',''),(398,'1','274','1',1,'Retail Sale Id 400',2998.32,0.00,0.00,4.03,330.46,'2022-06-07 18:11:37','',''),(399,'1','274','1',1,'Retail Sale Id 401',37200.00,0.00,0.00,50.00,4100.00,'2022-06-07 18:13:45','',''),(400,'1','274','1',1,'Retail Sale Id 402',2202.24,0.00,0.00,2.96,242.72,'2022-06-07 18:18:27','',''),(401,'1','274','1',1,'Retail Sale Id 403',996.96,0.00,0.00,1.34,109.88,'2022-06-07 18:20:49','',''),(402,'1','274','1',1,'Retail Sale Id 404',2202.24,0.00,0.00,2.96,242.72,'2022-06-07 18:33:51','',''),(403,'1','274','1',1,'Retail Sale Id 405',39900.72,0.00,0.00,53.63,4397.66,'2022-06-07 19:43:03','',''),(404,'1','274','1',1,'Retail Sale Id 405',71446.32,0.00,0.00,96.03,7874.46,'2022-06-07 19:43:03','',''),(405,'1','274','1',1,'Retail Sale Id 406',2998.32,0.00,0.00,4.03,330.46,'2022-06-08 06:43:26','',''),(406,'1','274','1',1,'Retail Sale Id 407',2001.36,0.00,0.00,2.69,220.58,'2022-06-08 07:27:29','',''),(407,'1','274','1',1,'Retail Sale Id 408',9300.00,0.00,0.00,12.50,1025.00,'2022-06-08 07:52:27','',''),(408,'1','274','1',1,'Retail Sale Id 409',3749.76,0.00,0.00,5.04,413.28,'2022-06-08 08:12:53','',''),(409,'1','274','1',1,'Retail Sale Id 410',9300.00,0.00,0.00,12.50,1025.00,'2022-06-08 08:24:23','',''),(410,'1','274','1',1,'Retail Sale Id 411',2001.36,0.00,0.00,2.69,220.58,'2022-06-08 08:34:33','',''),(411,'1','274','1',1,'Retail Sale Id 412',14002.08,0.00,0.00,18.82,1543.24,'2022-06-08 11:42:26','',''),(412,'1','274','1',1,'Retail Sale Id 414',9300.00,0.00,0.00,12.50,1025.00,'2022-06-08 11:46:34','',''),(413,'1','274','1',1,'Retail Sale Id 415',4999.68,0.00,0.00,6.72,551.04,'2022-06-08 12:34:46','',''),(414,'1','274','1',1,'Retail Sale Id 416',0.00,0.00,0.00,0.00,0.00,'2022-06-08 13:01:45','',''),(415,'1','274','1',1,'Return of Retail Sale Id 416',0.00,0.00,0.00,0.00,0.00,'2022-06-08 13:03:28','',''),(416,'1','274','1',1,'Retail Sale Id 417',9300.00,0.00,0.00,12.50,1025.00,'2022-06-08 13:05:13','',''),(417,'1','274','1',1,'Retail Sale Id 419',996.96,0.00,0.00,1.34,109.88,'2022-06-08 13:06:59','',''),(418,'1','274','1',1,'Retail Sale Id 420',4501.20,0.00,0.00,6.05,496.10,'2022-06-08 13:37:46','',''),(419,'1','274','1',1,'Retail Sale Id 421',9300.00,0.00,0.00,12.50,1025.00,'2022-06-08 13:40:56','',''),(420,'1','274','1',1,'Retail Sale Id 422',11160.00,0.00,0.00,15.00,1230.00,'2022-06-08 13:51:29','',''),(421,'1','274','1',1,'Retail Sale Id 423',9300.00,0.00,0.00,12.50,1025.00,'2022-06-08 13:57:55','',''),(422,'1','274','1',1,'Retail Sale Id 424',3697.68,0.00,0.00,4.97,407.54,'2022-06-08 14:01:52','',''),(423,'1','274','1',1,'Retail Sale Id 426',2246.88,0.00,0.00,3.02,247.64,'2022-06-08 14:51:22','',''),(424,'1','274','1',1,'Retail Sale Id 428',9300.00,0.00,0.00,12.50,1025.00,'2022-06-08 15:16:02','',''),(425,'1','274','1',1,'Retail Sale Id 435',2246.88,0.00,0.00,3.02,247.64,'2022-06-08 15:17:38','',''),(426,'1','274','1',1,'Retail Sale Id 441',13020.00,0.00,0.00,17.50,1435.00,'2022-06-08 15:31:43','',''),(427,'1','274','1',1,'Retail Sale Id 442',4501.20,0.00,0.00,6.05,496.10,'2022-06-08 15:45:20','',''),(428,'1','274','1',1,'Retail Sale Id 443',19998.72,0.00,0.00,26.88,2204.16,'2022-06-08 16:31:12','',''),(429,'1','274','1',1,'Retail Sale Id 444',9300.00,0.00,0.00,12.50,1025.00,'2022-06-08 17:07:33','',''),(430,'1','274','1',1,'Retail Sale Id 445',37200.00,0.00,0.00,50.00,4100.00,'2022-06-08 17:26:39','',''),(431,'1','274','1',1,'Retail Sale Id 446',4501.20,0.00,0.00,6.05,496.10,'2022-06-08 17:35:40','',''),(432,'1','274','1',1,'Retail Sale Id 447',1502.88,0.00,0.00,2.02,165.64,'2022-06-08 17:37:30','',''),(433,'1','274','1',1,'Retail Sale Id 448',4501.20,0.00,0.00,6.05,496.10,'2022-06-08 17:51:02','',''),(434,'1','274','1',1,'Retail Sale Id 449',9002.40,0.00,0.00,12.10,992.20,'2022-06-08 18:05:19','',''),(435,'1','274','1',1,'Retail Sale Id 450',4501.20,0.00,0.00,6.05,496.10,'2022-06-08 18:13:11','',''),(436,'1','274','1',1,'Retail Sale Id 451',4501.20,0.00,0.00,6.05,496.10,'2022-06-08 18:15:00','',''),(437,'1','274','1',1,'Retail Sale Id 452',2998.32,0.00,0.00,4.03,330.46,'2022-06-08 18:53:09','',''),(438,'1','274','1',1,'Retail Sale Id 453',8593.20,0.00,0.00,11.55,947.10,'2022-06-08 19:28:01','',''),(439,'1','274','1',1,'Retail Sale Id 453',59743.20,0.00,0.00,80.30,6584.60,'2022-06-08 19:28:01','',''),(440,'1','274','1',1,'Retail Sale Id 454',9300.00,0.00,0.00,12.50,1025.00,'2022-06-09 07:36:30','',''),(441,'1','274','1',1,'Retail Sale Id 455',6346.32,0.00,0.00,8.53,699.46,'2022-06-09 07:37:39','',''),(442,'1','274','1',1,'Retail Sale Id 456',2001.36,0.00,0.00,2.69,220.58,'2022-06-09 07:50:48','',''),(443,'1','274','1',1,'Retail Sale Id 457',30504.00,0.00,0.00,41.00,3362.00,'2022-06-09 08:07:02','',''),(444,'1','274','1',1,'Retail Sale Id 458',2246.88,0.00,0.00,3.02,247.64,'2022-06-09 08:09:40','',''),(445,'1','274','1',1,'Retail Sale Id 459',9300.00,0.00,0.00,12.50,1025.00,'2022-06-09 08:19:39','',''),(446,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,46684.24,70.52,0.00,0.00,'2022-06-09 10:08:50','',''),(447,'1','274',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,70.52,0.00,'2022-06-09 10:12:41','',''),(448,'1','274','1',1,'Received from bridging 3',0.00,0.00,70.52,0.00,0.00,'2022-06-09 10:12:41','',''),(449,'1','274','1',1,'Retail Sale Id 460',42080.64,0.00,0.00,56.56,4637.92,'2022-06-09 10:13:36','',''),(450,'1','274','1',1,'Retail Sale Id 461',11837.04,0.00,0.00,15.91,1304.62,'2022-06-09 10:14:32','',''),(451,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,662000.00,1000.00,0.00,0.00,'2022-06-10 10:29:59','',''),(452,'1','274',NULL,1,'Reception corrector for bridging 4',0.00,0.00,0.00,1000.00,0.00,'2022-06-10 10:31:42','',''),(453,'1','274','1',1,'Received from bridging 4',0.00,0.00,1000.00,0.00,0.00,'2022-06-10 10:31:42','',''),(454,'1','274','1',1,'Retail Sale Id 463',2001.36,0.00,0.00,2.69,220.58,'2022-06-10 10:33:43','',''),(455,'1','274','1',1,'Retail Sale Id 464',2202.24,0.00,0.00,2.96,242.72,'2022-06-10 10:34:27','',''),(456,'1','274','1',1,'Retail Sale Id 465',1502.88,0.00,0.00,2.02,165.64,'2022-06-10 10:35:14','',''),(457,'1','274','1',1,'Retail Sale Id 466',10416.00,0.00,0.00,14.00,1148.00,'2022-06-10 10:39:20','',''),(458,'1','274','1',1,'Retail Sale Id 467',74400.00,0.00,0.00,100.00,8200.00,'2022-06-10 10:41:05','',''),(459,'1','274','1',1,'Retail Sale Id 468',4501.20,0.00,0.00,6.05,496.10,'2022-06-10 11:05:03','',''),(460,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,1860220.00,2810.00,0.00,0.00,'2022-06-10 12:03:01','',''),(461,'1','274',NULL,1,'Reception corrector for bridging 5',0.00,0.00,0.00,2810.00,0.00,'2022-06-10 12:04:20','',''),(462,'1','274','1',1,'Received from bridging 5',0.00,0.00,2810.00,0.00,0.00,'2022-06-10 12:04:20','',''),(463,'1','274','1',1,'Retail Sale Id 469',2998.32,0.00,0.00,4.03,330.46,'2022-06-10 12:05:24','',''),(464,'1','274','1',1,'Retail Sale Id 470',2998.32,0.00,0.00,4.03,330.46,'2022-06-10 12:13:31','',''),(465,'1','274','1',1,'Retail Sale Id 471',1800.48,0.00,0.00,2.42,198.44,'2022-06-10 12:55:33','',''),(466,'1','274','1',1,'Retail Sale Id 472',4203.60,0.00,0.00,5.65,463.30,'2022-06-10 14:17:22','',''),(467,'1','274','1',1,'Retail Sale Id 473',9300.00,0.00,0.00,12.50,1025.00,'2022-06-10 14:21:27','',''),(468,'1','274','1',1,'Retail Sale Id 474',17856.00,0.00,0.00,24.00,1968.00,'2022-06-10 15:02:39','',''),(469,'1','274','1',1,'Retail Sale Id 475',2246.88,0.00,0.00,3.02,247.64,'2022-06-10 15:04:26','',''),(470,'1','274','1',1,'Retail Sale Id 476',1502.88,0.00,0.00,2.02,165.64,'2022-06-10 15:16:38','',''),(471,'1','274','1',1,'Retail Sale Id 477',3251.28,0.00,0.00,4.37,358.34,'2022-06-10 15:53:15','',''),(472,'1','274','1',1,'Retail Sale Id 480',9002.40,0.00,0.00,12.10,992.20,'2022-06-10 16:06:56','',''),(473,'1','274','1',1,'Retail Sale Id 481',8950.32,0.00,0.00,12.03,986.46,'2022-06-10 16:24:16','',''),(474,'1','274','1',1,'Retail Sale Id 482',2001.36,0.00,0.00,2.69,220.58,'2022-06-10 16:26:14','',''),(475,'1','274','1',1,'Retail Sale Id 483',2098.08,0.00,0.00,2.82,231.24,'2022-06-10 16:27:45','',''),(476,'1','274','1',1,'Retail Sale Id 484',1502.88,0.00,0.00,2.02,165.64,'2022-06-10 16:28:29','',''),(477,'1','274','1',1,'Retail Sale Id 485',3749.76,0.00,0.00,5.04,413.28,'2022-06-10 16:33:02','',''),(478,'1','274','1',1,'Retail Sale Id 486',4203.60,0.00,0.00,5.65,463.30,'2022-06-10 16:38:35','',''),(479,'1','274','1',1,'Retail Sale Id 487',9300.00,0.00,0.00,12.50,1025.00,'2022-06-10 16:39:54','',''),(480,'1','274','1',1,'Retail Sale Id 488',2998.32,0.00,0.00,4.03,330.46,'2022-06-10 16:41:36','',''),(481,'1','274','1',1,'Retail Sale Id 489',2998.32,0.00,0.00,4.03,330.46,'2022-06-10 16:50:13','',''),(482,'1','274','1',1,'Retail Sale Id 490',2246.88,0.00,0.00,3.02,247.64,'2022-06-10 16:51:36','',''),(483,'1','274','1',1,'Retail Sale Id 490',2246.88,0.00,0.00,3.02,247.64,'2022-06-10 16:51:36','',''),(484,'1','274','1',1,'Retail Sale Id 492',4501.20,0.00,0.00,6.05,496.10,'2022-06-10 16:58:53','',''),(485,'1','274','1',1,'Retail Sale Id 493',7998.00,0.00,0.00,10.75,881.50,'2022-06-10 17:01:09','',''),(486,'1','274','1',1,'Retail Sale Id 494',9300.00,0.00,0.00,12.50,1025.00,'2022-06-10 17:05:39','',''),(487,'1','274','1',1,'Retail Sale Id 495',9300.00,0.00,0.00,12.50,1025.00,'2022-06-10 17:11:21','',''),(488,'1','274','1',1,'Retail Sale Id 496',996.96,0.00,0.00,1.34,109.88,'2022-06-10 17:23:50','',''),(489,'1','274','1',1,'Retail Sale Id 498',4501.20,0.00,0.00,6.05,496.10,'2022-06-10 17:54:14','',''),(490,'1','274','1',1,'Retail Sale Id 499',3749.76,0.00,0.00,5.04,413.28,'2022-06-10 17:55:24','',''),(491,'1','274','1',1,'Retail Sale Id 500',9300.00,0.00,0.00,12.50,1025.00,'2022-06-10 18:10:14','',''),(492,'1','274','1',1,'Retail Sale Id 501',9002.40,0.00,0.00,12.10,992.20,'2022-06-10 18:24:51','',''),(493,'1','274','1',1,'Retail Sale Id 502',1502.88,0.00,0.00,2.02,165.64,'2022-06-10 18:26:45','',''),(494,'1','274','1',1,'Retail Sale Id 503',9300.00,0.00,0.00,12.50,1025.00,'2022-06-10 18:28:01','',''),(495,'1','274','1',1,'Retail Sale Id 504',6398.40,0.00,0.00,8.60,705.20,'2022-06-10 18:35:03','',''),(496,'1','274','1',1,'Retail Sale Id 505',2246.88,0.00,0.00,3.02,247.64,'2022-06-10 18:41:20','',''),(497,'1','274','1',1,'Retail Sale Id 506',5498.16,0.00,0.00,7.39,605.98,'2022-06-10 18:42:46','',''),(498,'1','274','1',1,'Retail Sale Id 507',9300.00,0.00,0.00,12.50,1025.00,'2022-06-10 18:44:07','',''),(499,'1','274','1',1,'Retail Sale Id 508',3749.76,0.00,0.00,5.04,413.28,'2022-06-10 18:45:32','',''),(500,'1','274','1',1,'Retail Sale Id 509',15795.12,0.00,0.00,21.23,1740.86,'2022-06-10 21:01:58','',''),(501,'1','274','1',1,'Retail Sale Id 509',68395.92,0.00,0.00,91.93,7538.26,'2022-06-10 21:01:58','',''),(502,'1','274','1',1,'Retail Sale Id 510',2001.36,0.00,0.00,2.69,220.58,'2022-06-11 07:36:27','',''),(503,'1','274','1',1,'Retail Sale Id 511',751.44,0.00,0.00,1.01,82.82,'2022-06-11 07:43:00','',''),(504,'1','274','1',1,'Retail Sale Id 512',2246.88,0.00,0.00,3.02,247.64,'2022-06-11 07:47:40','',''),(505,'1','274','1',1,'Retail Sale Id 513',2246.88,0.00,0.00,3.02,247.64,'2022-06-11 07:50:43','',''),(506,'1','274','1',1,'Retail Sale Id 514',4501.20,0.00,0.00,6.05,496.10,'2022-06-11 08:05:18','',''),(507,'1','274','1',1,'Retail Sale Id 515',7001.04,0.00,0.00,9.41,771.62,'2022-06-11 08:08:35','',''),(508,'1','274','1',1,'Retail Sale Id 516',16501.92,0.00,0.00,22.18,1818.76,'2022-06-11 08:12:11','',''),(509,'1','274','1',1,'Retail Sale Id 517',1302.00,0.00,0.00,1.75,143.50,'2022-06-11 08:15:04','',''),(510,'1','274','1',1,'Retail Sale Id 518',3749.76,0.00,0.00,5.04,413.28,'2022-06-11 08:19:22','',''),(511,'1','274','1',1,'Retail Sale Id 519',1502.88,0.00,0.00,2.02,165.64,'2022-06-11 08:20:59','',''),(512,'1','274','1',1,'Retail Sale Id 520',2998.32,0.00,0.00,4.03,330.46,'2022-06-11 08:26:18','',''),(513,'1','274','1',1,'Retail Sale Id 521',4501.20,0.00,0.00,6.05,496.10,'2022-06-11 08:30:43','',''),(514,'1','274','1',1,'Retail Sale Id 522',4501.20,0.00,0.00,6.05,496.10,'2022-06-11 08:32:33','',''),(515,'1','274','1',1,'Retail Sale Id 523',2246.88,0.00,0.00,3.02,247.64,'2022-06-11 08:33:56','',''),(516,'1','274','1',1,'Retail Sale Id 524',1502.88,0.00,0.00,2.02,165.64,'2022-06-11 08:37:43','',''),(517,'1','274','1',1,'Retail Sale Id 525',3749.76,0.00,0.00,5.04,413.28,'2022-06-11 08:40:16','',''),(518,'1','274','1',1,'Retail Sale Id 526',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 08:43:08','',''),(519,'1','274','1',1,'Retail Sale Id 527',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 08:45:56','',''),(520,'1','274','1',1,'Retail Sale Id 528',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 09:01:21','',''),(521,'1','274','1',1,'Retail Sale Id 528',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 09:01:21','',''),(522,'1','274','1',1,'Retail Sale Id 529',2246.88,0.00,0.00,3.02,247.64,'2022-06-11 09:02:58','',''),(523,'1','274','1',1,'Retail Sale Id 530',4501.20,0.00,0.00,6.05,496.10,'2022-06-11 09:21:35','',''),(524,'1','274','1',1,'Retail Sale Id 531',2001.36,0.00,0.00,2.69,220.58,'2022-06-11 09:25:48','',''),(525,'1','274','1',1,'Retail Sale Id 532',37200.00,0.00,0.00,50.00,4100.00,'2022-06-11 09:28:38','',''),(526,'1','274','1',1,'Retail Sale Id 533',8496.48,0.00,0.00,11.42,936.44,'2022-06-11 09:33:21','',''),(527,'1','274','1',1,'Retail Sale Id 534',4501.20,0.00,0.00,6.05,496.10,'2022-06-11 09:41:02','',''),(528,'1','274','1',1,'Retail Sale Id 535',9002.40,0.00,0.00,12.10,992.20,'2022-06-11 09:47:25','',''),(529,'1','274','1',1,'Retail Sale Id 536',4999.68,0.00,0.00,6.72,551.04,'2022-06-11 09:48:17','',''),(530,'1','274','1',1,'Retail Sale Id 537',2499.84,0.00,0.00,3.36,275.52,'2022-06-11 09:55:04','',''),(531,'1','274','1',1,'Retail Sale Id 538',2001.36,0.00,0.00,2.69,220.58,'2022-06-11 09:56:30','',''),(532,'1','274','1',1,'Retail Sale Id 543',4501.20,0.00,0.00,6.05,496.10,'2022-06-11 10:01:30','',''),(533,'1','274','1',1,'Retail Sale Id 543',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 10:01:30','',''),(534,'1','274','1',1,'Retail Sale Id 544',37200.00,0.00,0.00,50.00,4100.00,'2022-06-11 10:10:32','',''),(535,'1','274','1',1,'Retail Sale Id 545',4501.20,0.00,0.00,6.05,496.10,'2022-06-11 10:11:19','',''),(536,'1','274','1',1,'Retail Sale Id 546',2246.88,0.00,0.00,3.02,247.64,'2022-06-11 10:13:28','',''),(537,'1','274','1',1,'Retail Sale Id 547',4501.20,0.00,0.00,6.05,496.10,'2022-06-11 10:16:45','',''),(538,'1','274','1',1,'Retail Sale Id 548',3496.80,0.00,0.00,4.70,385.40,'2022-06-11 10:33:40','',''),(539,'1','274','1',1,'Retail Sale Id 549',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 10:41:55','',''),(540,'1','274','1',1,'Retail Sale Id 550',3749.76,0.00,0.00,5.04,413.28,'2022-06-11 10:47:58','',''),(541,'1','274','1',1,'Retail Sale Id 551',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 10:50:34','',''),(542,'1','274','1',1,'Retail Sale Id 552',3697.68,0.00,0.00,4.97,407.54,'2022-06-11 10:53:05','',''),(543,'1','274','1',1,'Retail Sale Id 553',1502.88,0.00,0.00,2.02,165.64,'2022-06-11 10:54:14','',''),(544,'1','274','1',1,'Retail Sale Id 554',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 10:57:30','',''),(545,'1','274','1',1,'Retail Sale Id 555',2246.88,0.00,0.00,3.02,247.64,'2022-06-11 10:59:09','',''),(546,'1','274','1',1,'Retail Sale Id 556',4501.20,0.00,0.00,6.05,496.10,'2022-06-11 11:08:33','',''),(547,'1','274','1',1,'Retail Sale Id 557',14150.88,0.00,0.00,19.02,1559.64,'2022-06-11 11:25:30','',''),(548,'1','274','1',1,'Retail Sale Id 558',18600.00,0.00,0.00,25.00,2050.00,'2022-06-11 11:27:04','',''),(549,'1','274','1',1,'Retail Sale Id 559',3749.76,0.00,0.00,5.04,413.28,'2022-06-11 11:32:58','',''),(550,'1','274','1',1,'Retail Sale Id 560',4501.20,0.00,0.00,6.05,496.10,'2022-06-11 11:34:35','',''),(551,'1','274','1',1,'Retail Sale Id 561',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 11:39:44','',''),(552,'1','274','1',1,'Retail Sale Id 562',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 11:43:47','',''),(553,'1','274','1',1,'Retail Sale Id 563',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 11:46:36','',''),(554,'1','274','1',1,'Retail Sale Id 564',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 11:50:04','',''),(555,'1','274','1',1,'Retail Sale Id 565',7998.00,0.00,0.00,10.75,881.50,'2022-06-11 11:51:47','',''),(556,'1','274','1',1,'Retail Sale Id 566',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 12:02:15','',''),(557,'1','274','1',1,'Retail Sale Id 567',2998.32,0.00,0.00,4.03,330.46,'2022-06-11 12:04:00','',''),(558,'1','274','1',1,'Retail Sale Id 568',2499.84,0.00,0.00,3.36,275.52,'2022-06-11 12:19:33','',''),(559,'1','274','1',1,'Retail Sale Id 569',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 12:22:06','',''),(560,'1','274','1',1,'Retail Sale Id 570',29998.08,0.00,0.00,40.32,3306.24,'2022-06-11 12:25:23','',''),(561,'1','274','1',1,'Retail Sale Id 571',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 12:30:08','',''),(562,'1','274','1',1,'Retail Sale Id 572',2998.32,0.00,0.00,4.03,330.46,'2022-06-11 12:35:03','',''),(563,'1','274','1',1,'Retail Sale Id 573',4300.32,0.00,0.00,5.78,473.96,'2022-06-11 12:42:23','',''),(564,'1','274','1',1,'Retail Sale Id 574',2001.36,0.00,0.00,2.69,220.58,'2022-06-11 12:50:24','',''),(565,'1','274','1',1,'Retail Sale Id 575',2246.88,0.00,0.00,3.02,247.64,'2022-06-11 12:53:31','',''),(566,'1','274','1',1,'Retail Sale Id 576',18600.00,0.00,0.00,25.00,2050.00,'2022-06-11 13:03:14','',''),(567,'1','274','1',1,'Retail Sale Id 577',4002.72,0.00,0.00,5.38,441.16,'2022-06-11 13:04:51','',''),(568,'1','274','1',1,'Retail Sale Id 578',3720.00,0.00,0.00,5.00,410.00,'2022-06-11 13:07:37','',''),(569,'1','274','1',1,'Retail Sale Id 579',996.96,0.00,0.00,1.34,109.88,'2022-06-11 13:08:42','',''),(570,'1','274','1',1,'Retail Sale Id 580',7447.44,0.00,0.00,10.01,820.82,'2022-06-11 13:11:39','',''),(571,'1','274','1',1,'Retail Sale Id 581',18600.00,0.00,0.00,25.00,2050.00,'2022-06-11 13:13:26','',''),(572,'1','274','1',1,'Retail Sale Id 582',4501.20,0.00,0.00,6.05,496.10,'2022-06-11 13:18:58','',''),(573,'1','274','1',1,'Retail Sale Id 583',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 13:26:23','',''),(574,'1','274','1',1,'Retail Sale Id 584',4501.20,0.00,0.00,6.05,496.10,'2022-06-11 13:27:20','',''),(575,'1','274','1',1,'Retail Sale Id 585',3749.76,0.00,0.00,5.04,413.28,'2022-06-11 13:48:10','',''),(576,'1','274','1',1,'Retail Sale Id 587',1502.88,0.00,0.00,2.02,165.64,'2022-06-11 13:49:35','',''),(577,'1','274','1',1,'Retail Sale Id 588',2001.36,0.00,0.00,2.69,220.58,'2022-06-11 13:50:28','',''),(578,'1','274','1',1,'Retail Sale Id 589',2246.88,0.00,0.00,3.02,247.64,'2022-06-11 13:53:47','',''),(579,'1','274','1',1,'Retail Sale Id 590',4501.20,0.00,0.00,6.05,496.10,'2022-06-11 14:06:28','',''),(580,'1','274','1',1,'Retail Sale Id 591',4002.72,0.00,0.00,5.38,441.16,'2022-06-11 14:17:13','',''),(581,'1','274','1',1,'Retail Sale Id 592',8496.48,0.00,0.00,11.42,936.44,'2022-06-11 14:22:56','',''),(582,'1','274','1',1,'Retail Sale Id 593',4999.68,0.00,0.00,6.72,551.04,'2022-06-11 14:24:55','',''),(583,'1','274','1',1,'Retail Sale Id 594',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 14:26:53','',''),(584,'1','274','1',1,'Retail Sale Id 595',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 14:28:34','',''),(585,'1','274','1',1,'Retail Sale Id 596',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 14:33:08','',''),(586,'1','274','1',1,'Retail Sale Id 597',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 14:35:11','',''),(587,'1','274','1',1,'Retail Sale Id 599',1502.88,0.00,0.00,2.02,165.64,'2022-06-11 14:40:19','',''),(588,'1','274','1',1,'Retail Sale Id 600',2246.88,0.00,0.00,3.02,247.64,'2022-06-11 14:43:25','',''),(589,'1','274','1',1,'Retail Sale Id 601',2499.84,0.00,0.00,3.36,275.52,'2022-06-11 14:46:40','',''),(590,'1','274','1',1,'Retail Sale Id 602',498.48,0.00,0.00,0.67,54.94,'2022-06-11 14:49:54','',''),(591,'1','274','1',1,'Retail Sale Id 603',4501.20,0.00,0.00,6.05,496.10,'2022-06-11 14:51:21','',''),(592,'1','274','1',1,'Retail Sale Id 604',1502.88,0.00,0.00,2.02,165.64,'2022-06-11 14:55:25','',''),(593,'1','274','1',1,'Retail Sale Id 605',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 15:27:40','',''),(594,'1','274','1',1,'Retail Sale Id 606',4002.72,0.00,0.00,5.38,441.16,'2022-06-11 15:32:27','',''),(595,'1','274','1',1,'Retail Sale Id 607',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 15:42:27','',''),(596,'1','274','1',1,'Retail Sale Id 608',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 15:43:50','',''),(597,'1','274','1',1,'Retail Sale Id 609',2998.32,0.00,0.00,4.03,330.46,'2022-06-11 15:54:36','',''),(598,'1','274','1',1,'Retail Sale Id 610',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 16:02:19','',''),(599,'1','274','1',1,'Retail Sale Id 611',14880.00,0.00,0.00,20.00,1640.00,'2022-06-11 16:07:38','',''),(600,'1','274','1',1,'Retail Sale Id 612',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 16:11:22','',''),(601,'1','274','1',1,'Retail Sale Id 613',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 16:15:25','',''),(602,'1','274','1',1,'Retail Sale Id 614',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 16:18:00','',''),(603,'1','274','1',1,'Retail Sale Id 615',2001.36,0.00,0.00,2.69,220.58,'2022-06-11 16:21:05','',''),(604,'1','274','1',1,'Retail Sale Id 616',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 16:25:16','',''),(605,'1','274','1',1,'Retail Sale Id 617',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 16:27:28','',''),(606,'1','274','1',1,'Retail Sale Id 618',1502.88,0.00,0.00,2.02,165.64,'2022-06-11 16:34:47','',''),(607,'1','274','1',1,'Retail Sale Id 619',2001.36,0.00,0.00,2.69,220.58,'2022-06-11 16:41:00','',''),(608,'1','274','1',1,'Retail Sale Id 620',4002.72,0.00,0.00,5.38,441.16,'2022-06-11 16:45:13','',''),(609,'1','274','1',1,'Retail Sale Id 621',2001.36,0.00,0.00,2.69,220.58,'2022-06-11 16:46:20','',''),(610,'1','274','1',1,'Retail Sale Id 622',2246.88,0.00,0.00,3.02,247.64,'2022-06-11 16:50:44','',''),(611,'1','274','1',1,'Retail Sale Id 623',4999.68,0.00,0.00,6.72,551.04,'2022-06-11 16:52:29','',''),(612,'1','274','1',1,'Retail Sale Id 624',2001.36,0.00,0.00,2.69,220.58,'2022-06-11 16:56:52','',''),(613,'1','274','1',1,'Retail Sale Id 625',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 17:00:31','',''),(614,'1','274','1',1,'Retail Sale Id 626',1502.88,0.00,0.00,2.02,165.64,'2022-06-11 17:03:21','',''),(615,'1','274','1',1,'Retail Sale Id 626',1502.88,0.00,0.00,2.02,165.64,'2022-06-11 17:03:21','',''),(616,'1','274','1',1,'Retail Sale Id 627',4002.72,0.00,0.00,5.38,441.16,'2022-06-11 17:09:51','',''),(617,'1','274','1',1,'Retail Sale Id 628',2246.88,0.00,0.00,3.02,247.64,'2022-06-11 17:11:44','',''),(618,'1','274','1',1,'Retail Sale Id 629',4501.20,0.00,0.00,6.05,496.10,'2022-06-11 17:13:43','',''),(619,'1','274','1',1,'Retail Sale Id 630',3720.00,0.00,0.00,5.00,410.00,'2022-06-11 17:23:13','',''),(620,'1','274','1',1,'Retail Sale Id 631',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 17:26:21','',''),(621,'1','274','1',1,'Retail Sale Id 632',2001.36,0.00,0.00,2.69,220.58,'2022-06-11 17:28:54','',''),(622,'1','274','1',1,'Retail Sale Id 633',2246.88,0.00,0.00,3.02,247.64,'2022-06-11 17:30:45','',''),(623,'1','274','1',1,'Retail Sale Id 634',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 17:33:15','',''),(624,'1','274','1',1,'Retail Sale Id 635',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 17:42:38','',''),(625,'1','274','1',1,'Retail Sale Id 636',2001.36,0.00,0.00,2.69,220.58,'2022-06-11 17:43:47','',''),(626,'1','274','1',1,'Retail Sale Id 637',2246.88,0.00,0.00,3.02,247.64,'2022-06-11 17:46:05','',''),(627,'1','274','1',1,'Retail Sale Id 637',2246.88,0.00,0.00,3.02,247.64,'2022-06-11 17:46:05','',''),(628,'1','274','1',1,'Retail Sale Id 638',37200.00,0.00,0.00,50.00,4100.00,'2022-06-11 17:48:33','',''),(629,'1','274','1',1,'Retail Sale Id 639',5208.00,0.00,0.00,7.00,574.00,'2022-06-11 17:50:41','',''),(630,'1','274','1',1,'Retail Sale Id 640',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 17:54:48','',''),(631,'1','274','1',1,'Retail Sale Id 641',7998.00,0.00,0.00,10.75,881.50,'2022-06-11 18:01:51','',''),(632,'1','274','1',1,'Retail Sale Id 642',3720.00,0.00,0.00,5.00,410.00,'2022-06-11 18:17:57','',''),(633,'1','274','1',1,'Retail Sale Id 643',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 18:20:00','',''),(634,'1','274','1',1,'Retail Sale Id 644',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 18:21:51','',''),(635,'1','274','1',1,'Retail Sale Id 645',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 18:23:31','',''),(636,'1','274','1',1,'Retail Sale Id 646',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 18:27:18','',''),(637,'1','274','1',1,'Retail Sale Id 647',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 18:31:16','',''),(638,'1','274','1',1,'Retail Sale Id 648',4501.20,0.00,0.00,6.05,496.10,'2022-06-11 18:51:20','',''),(639,'1','274','1',1,'Retail Sale Id 649',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 18:52:22','',''),(640,'1','274','1',1,'Retail Sale Id 650',18600.00,0.00,0.00,25.00,2050.00,'2022-06-11 18:53:45','',''),(641,'1','274','1',1,'Retail Sale Id 651',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 18:56:51','',''),(642,'1','274','1',1,'Retail Sale Id 652',2246.88,0.00,0.00,3.02,247.64,'2022-06-11 18:59:06','',''),(643,'1','274','1',1,'Retail Sale Id 653',4501.20,0.00,0.00,6.05,496.10,'2022-06-11 19:03:08','',''),(644,'1','274','1',1,'Retail Sale Id 654',1502.88,0.00,0.00,2.02,165.64,'2022-06-11 19:04:10','',''),(645,'1','274','1',1,'Retail Sale Id 655',9300.00,0.00,0.00,12.50,1025.00,'2022-06-11 19:05:27','',''),(646,'1','274','1',1,'Retail Sale Id 656',9002.40,0.00,0.00,12.10,992.20,'2022-06-11 19:08:41','',''),(647,'1','274','1',1,'Retail Sale Id 657',7001.04,0.00,0.00,9.41,771.62,'2022-06-11 19:10:18','',''),(648,'1','274','1',1,'Retail Sale Id 658',7998.00,0.00,0.00,10.75,881.50,'2022-06-11 19:12:51','',''),(649,'1','274','1',1,'Return of Retail Sale Id 650',0.00,18600.00,25.00,0.00,-2050.00,'2022-06-11 19:28:46','',''),(650,'1','274','1',1,'Return of Retail Sale Id 646',0.00,9300.00,12.50,0.00,-1025.00,'2022-06-11 19:32:49','',''),(651,'1','274','1',1,'Return of Retail Sale Id 658',0.00,7998.00,10.75,0.00,-881.50,'2022-06-11 19:33:44','',''),(652,'1','274','1',1,'Return of Retail Sale Id 657',0.00,7001.04,9.41,0.00,-771.62,'2022-06-11 19:34:15','',''),(653,'1','274','1',1,'Return of Retail Sale Id 576',0.00,18600.00,25.00,0.00,-2050.00,'2022-06-11 19:36:57','',''),(654,'1','274','1',1,'Return of Retail Sale Id 532',0.00,37200.00,50.00,0.00,-4100.00,'2022-06-11 19:38:14','',''),(655,'1','274','1',1,'Return of Retail Sale Id 516',0.00,16501.92,22.18,0.00,-1818.76,'2022-06-11 19:39:47','',''),(656,'1','274','1',1,'Return of Retail Sale Id 656',0.00,9002.40,12.10,0.00,-992.20,'2022-06-11 19:40:28','',''),(657,'1','274','1',1,'Retail Sale Id 659',42184.80,0.00,0.00,56.70,4649.40,'2022-06-11 19:48:06','',''),(658,'1','274','1',1,'Retail Sale Id 659',106153.92,0.00,0.00,142.68,11699.76,'2022-06-11 19:48:06','',''),(659,'1','274','1',1,'Retail Sale Id 660',9300.00,0.00,0.00,12.50,1025.00,'2022-06-12 07:13:42','',''),(660,'1','274','1',1,'Retail Sale Id 661',3496.80,0.00,0.00,4.70,385.40,'2022-06-12 07:33:22','',''),(661,'1','274','1',1,'Retail Sale Id 662',2298.96,0.00,0.00,3.09,253.38,'2022-06-12 07:45:00','',''),(662,'1','274','1',1,'Retail Sale Id 663',2001.36,0.00,0.00,2.69,220.58,'2022-06-12 07:53:27','',''),(663,'1','274','1',1,'Retail Sale Id 664',9300.00,0.00,0.00,12.50,1025.00,'2022-06-12 07:59:49','',''),(664,'1','274','1',1,'Retail Sale Id 665',996.96,0.00,0.00,1.34,109.88,'2022-06-12 08:11:37','',''),(665,'1','274','1',1,'Retail Sale Id 666',1502.88,0.00,0.00,2.02,165.64,'2022-06-12 08:13:23','',''),(666,'1','274','1',1,'Retail Sale Id 666',2001.36,0.00,0.00,2.69,220.58,'2022-06-12 08:13:23','',''),(667,'1','274','1',1,'Retail Sale Id 667',996.96,0.00,0.00,1.34,109.88,'2022-06-12 08:27:53','',''),(668,'1','274','1',1,'Retail Sale Id 668',2001.36,0.00,0.00,2.69,220.58,'2022-06-12 08:32:55','',''),(669,'1','274','1',1,'Retail Sale Id 669',9300.00,0.00,0.00,12.50,1025.00,'2022-06-12 08:36:02','',''),(670,'1','274','1',1,'Retail Sale Id 670',4999.68,0.00,0.00,6.72,551.04,'2022-06-12 08:38:59','',''),(671,'1','274','1',1,'Retail Sale Id 671',1800.48,0.00,0.00,2.42,198.44,'2022-06-12 08:40:15','',''),(672,'1','274','1',1,'Retail Sale Id 672',3801.84,0.00,0.00,5.11,419.02,'2022-06-12 08:45:32','',''),(673,'1','274','1',1,'Retail Sale Id 673',2001.36,0.00,0.00,2.69,220.58,'2022-06-12 08:49:02','',''),(674,'1','274','1',1,'Retail Sale Id 674',2001.36,0.00,0.00,2.69,220.58,'2022-06-12 08:50:07','',''),(675,'1','274','1',1,'Retail Sale Id 675',9300.00,0.00,0.00,12.50,1025.00,'2022-06-12 08:53:00','',''),(676,'1','274','1',1,'Retail Sale Id 676',9300.00,0.00,0.00,12.50,1025.00,'2022-06-12 08:54:45','',''),(677,'1','274','1',1,'Retail Sale Id 676',33480.00,0.00,0.00,45.00,3690.00,'2022-06-12 08:54:45','',''),(678,'1','274','1',1,'Retail Sale Id 677',9300.00,0.00,0.00,12.50,1025.00,'2022-06-12 09:02:26','',''),(679,'1','274','1',1,'Retail Sale Id 677',9300.00,0.00,0.00,12.50,1025.00,'2022-06-12 09:02:26','',''),(680,'1','274','1',1,'Retail Sale Id 678',2499.84,0.00,0.00,3.36,275.52,'2022-06-12 09:08:11','',''),(681,'1','274','1',1,'Retail Sale Id 679',9300.00,0.00,0.00,12.50,1025.00,'2022-06-12 09:10:08','',''),(682,'1','274','1',1,'Retail Sale Id 680',2998.32,0.00,0.00,4.03,330.46,'2022-06-12 09:15:14','',''),(683,'1','274','1',1,'Retail Sale Id 681',4501.20,0.00,0.00,6.05,496.10,'2022-06-12 09:21:40','',''),(684,'1','274','1',1,'Retail Sale Id 682',2998.32,0.00,0.00,4.03,330.46,'2022-06-12 09:24:23','',''),(685,'1','274','1',1,'Retail Sale Id 683',2001.36,0.00,0.00,2.69,220.58,'2022-06-12 09:33:39','',''),(686,'1','274','1',1,'Retail Sale Id 684',18600.00,0.00,0.00,25.00,2050.00,'2022-06-12 09:38:12','',''),(687,'1','274','1',1,'Retail Sale Id 685',17997.36,0.00,0.00,24.19,1983.58,'2022-06-12 09:40:37','',''),(688,'1','274','1',1,'Retail Sale Id 687',9300.00,0.00,0.00,12.50,1025.00,'2022-06-12 09:57:01','',''),(689,'1','274','1',1,'Retail Sale Id 688',9300.00,0.00,0.00,12.50,1025.00,'2022-06-12 09:59:18','',''),(690,'1','274','1',1,'Retail Sale Id 689',9300.00,0.00,0.00,12.50,1025.00,'2022-06-12 10:10:06','',''),(691,'1','274','1',1,'Retail Sale Id 690',2499.84,0.00,0.00,3.36,275.52,'2022-06-12 10:12:02','',''),(692,'1','274','1',1,'Retail Sale Id 691',9300.00,0.00,0.00,12.50,1025.00,'2022-06-12 10:24:11','',''),(693,'1','274','1',1,'Retail Sale Id 691',9300.00,0.00,0.00,12.50,1025.00,'2022-06-12 10:24:11','',''),(694,'1','274','1',1,'Retail Sale Id 692',4501.20,0.00,0.00,6.05,496.10,'2022-06-12 10:32:09','',''),(695,'1','274','1',1,'Retail Sale Id 692',9300.00,0.00,0.00,12.50,1025.00,'2022-06-12 10:32:09','',''),(696,'1','274','1',1,'Retail Sale Id 693',9300.00,0.00,0.00,12.50,1025.00,'2022-06-12 10:42:00','',''),(697,'1','274','1',1,'Retail Sale Id 694',18600.00,0.00,0.00,25.00,2050.00,'2022-06-12 11:11:11','',''),(698,'1','274','1',1,'Retail Sale Id 695',9300.00,0.00,0.00,12.50,1025.00,'2022-06-12 11:34:06','',''),(699,'1','274','1',1,'Retail Sale Id 696',4501.20,0.00,0.00,6.05,496.10,'2022-06-12 11:39:16','',''),(700,'1','274','1',1,'Retail Sale Id 697',2001.36,0.00,0.00,2.69,220.58,'2022-06-12 11:57:28','',''),(701,'1','274','1',1,'Retail Sale Id 698',1502.88,0.00,0.00,2.02,165.64,'2022-06-12 12:01:37','',''),(702,'1','274','1',1,'Retail Sale Id 699',2246.88,0.00,0.00,3.02,247.64,'2022-06-12 12:03:40','',''),(703,'1','274','1',1,'Retail Sale Id 700',2998.32,0.00,0.00,4.03,330.46,'2022-06-12 12:06:43','',''),(704,'1','274','1',1,'Retail Sale Id 701',2001.36,0.00,0.00,2.69,220.58,'2022-06-12 12:16:04','',''),(705,'1','274','1',1,'Retail Sale Id 702',4501.20,0.00,0.00,6.05,496.10,'2022-06-12 12:21:40','',''),(706,'1','274','1',1,'Retail Sale Id 703',9701.76,0.00,0.00,13.04,1069.28,'2022-06-12 12:26:58','',''),(707,'1','274','1',1,'Retail Sale Id 704',4501.20,0.00,0.00,6.05,496.10,'2022-06-12 12:30:08','',''),(708,'1','274','1',1,'Retail Sale Id 705',2246.88,0.00,0.00,3.02,247.64,'2022-06-12 12:34:02','',''),(709,'1','274','1',1,'Retail Sale Id 706',18600.00,0.00,0.00,25.00,2050.00,'2022-06-12 12:40:05','',''),(710,'1','274','1',1,'Retail Sale Id 707',1502.88,0.00,0.00,2.02,165.64,'2022-06-12 12:41:16','',''),(711,'1','274','1',1,'Retail Sale Id 708',2998.32,0.00,0.00,4.03,330.46,'2022-06-12 13:12:13','',''),(712,'1','274','1',1,'Retail Sale Id 709',4002.72,0.00,0.00,5.38,441.16,'2022-06-12 13:22:43','',''),(713,'1','274','1',1,'Retail Sale Id 710',803.52,0.00,0.00,1.08,88.56,'2022-06-12 13:28:14','',''),(714,'1','274','1',1,'Retail Sale Id 711',4002.72,0.00,0.00,5.38,441.16,'2022-06-12 13:35:05','',''),(715,'1','274','1',1,'Retail Sale Id 712',9300.00,0.00,0.00,12.50,1025.00,'2022-06-12 13:47:26','',''),(716,'1','274','1',1,'Retail Sale Id 713',7499.52,0.00,0.00,10.08,826.56,'2022-06-12 14:06:09','',''),(717,'1','274','1',1,'Retail Sale Id 714',7998.00,0.00,0.00,10.75,881.50,'2022-06-12 14:33:43','',''),(718,'1','274','1',1,'Retail Sale Id 715',9300.00,0.00,0.00,12.50,1025.00,'2022-06-12 14:34:39','',''),(719,'1','274','1',1,'Retail Sale Id 718',2998.32,0.00,0.00,4.03,330.46,'2022-06-12 14:40:17','',''),(720,'1','274','1',1,'Retail Sale Id 719',9300.00,0.00,0.00,12.50,1025.00,'2022-06-12 14:59:52','',''),(721,'1','274','1',1,'Retail Sale Id 720',2246.88,0.00,0.00,3.02,247.64,'2022-06-12 15:09:53','',''),(722,'1','274','1',1,'Retail Sale Id 721',3720.00,0.00,0.00,5.00,410.00,'2022-06-12 15:14:07','',''),(723,'1','274','1',1,'Retail Sale Id 722',9300.00,0.00,0.00,12.50,1025.00,'2022-06-12 15:15:23','',''),(724,'1','274','1',1,'Retail Sale Id 723',9300.00,0.00,0.00,12.50,1025.00,'2022-06-12 15:19:23','',''),(725,'1','274','1',1,'Retail Sale Id 724',4501.20,0.00,0.00,6.05,496.10,'2022-06-12 15:25:54','',''),(726,'1','274','1',1,'Retail Sale Id 725',4501.20,0.00,0.00,6.05,496.10,'2022-06-12 15:28:45','',''),(727,'1','274','1',1,'Retail Sale Id 726',2001.36,0.00,0.00,2.69,220.58,'2022-06-12 15:35:05','',''),(728,'1','274','1',1,'Retail Sale Id 727',12000.72,0.00,0.00,16.13,1322.66,'2022-06-12 15:41:16','',''),(729,'1','274','1',1,'Retail Sale Id 728',2246.88,0.00,0.00,3.02,247.64,'2022-06-12 15:45:19','',''),(730,'1','274','1',1,'Retail Sale Id 729',4999.68,0.00,0.00,6.72,551.04,'2022-06-12 15:46:08','',''),(731,'1','274','1',1,'Retail Sale Id 730',4002.72,0.00,0.00,5.38,441.16,'2022-06-12 15:49:30','',''),(732,'1','274','1',1,'Retail Sale Id 731',4501.20,0.00,0.00,6.05,496.10,'2022-06-12 15:57:25','',''),(733,'1','274','1',1,'Retail Sale Id 732',6748.08,0.00,0.00,9.07,743.74,'2022-06-12 16:20:16','',''),(734,'1','274','1',1,'Retail Sale Id 733',2001.36,0.00,0.00,2.69,220.58,'2022-06-12 16:23:21','',''),(735,'1','274','1',1,'Retail Sale Id 735',1502.88,0.00,0.00,2.02,165.64,'2022-06-12 16:28:13','',''),(736,'1','274','1',1,'Retail Sale Id 735',4501.20,0.00,0.00,6.05,496.10,'2022-06-12 16:28:13','',''),(737,'1','274','1',1,'Retail Sale Id 736',4501.20,0.00,0.00,6.05,496.10,'2022-06-12 16:29:53','',''),(738,'1','274','1',1,'Retail Sale Id 737',1502.88,0.00,0.00,2.02,165.64,'2022-06-12 16:30:44','',''),(739,'1','274','1',1,'Return of Retail Sale Id 735',0.00,1502.88,2.02,0.00,-165.64,'2022-06-12 16:31:52','',''),(740,'1','274','1',1,'Return of Retail Sale Id 735',0.00,4501.20,6.05,0.00,-496.10,'2022-06-12 16:31:52','',''),(741,'1','274','1',1,'Retail Sale Id 738',2246.88,0.00,0.00,3.02,247.64,'2022-06-12 17:06:33','',''),(742,'1','274','1',1,'Retail Sale Id 739',9300.00,0.00,0.00,12.50,1025.00,'2022-06-12 17:08:10','',''),(743,'1','274','1',1,'Retail Sale Id 740',1502.88,0.00,0.00,2.02,165.64,'2022-06-12 17:17:38','',''),(744,'1','274','1',1,'Retail Sale Id 741',9300.00,0.00,0.00,12.50,1025.00,'2022-06-12 17:19:09','',''),(745,'1','274','1',1,'Retail Sale Id 742',1502.88,0.00,0.00,2.02,165.64,'2022-06-12 17:21:46','',''),(746,'1','274','1',1,'Retail Sale Id 743',9300.00,0.00,0.00,12.50,1025.00,'2022-06-12 17:38:18','',''),(747,'1','274','1',1,'Retail Sale Id 745',9300.00,0.00,0.00,12.50,1025.00,'2022-06-12 17:47:26','',''),(748,'1','274','1',1,'Retail Sale Id 746',2298.96,0.00,0.00,3.09,253.38,'2022-06-12 17:49:31','',''),(749,'1','274','1',1,'Retail Sale Id 747',9300.00,0.00,0.00,12.50,1025.00,'2022-06-12 17:51:05','',''),(750,'1','274','1',1,'Retail Sale Id 748',2001.36,0.00,0.00,2.69,220.58,'2022-06-12 17:52:34','',''),(751,'1','274','1',1,'Retail Sale Id 749',996.96,0.00,0.00,1.34,109.88,'2022-06-12 17:57:10','',''),(752,'1','274','1',1,'Retail Sale Id 750',996.96,0.00,0.00,1.34,109.88,'2022-06-12 18:01:00','',''),(753,'1','274','1',1,'Retail Sale Id 751',2246.88,0.00,0.00,3.02,247.64,'2022-06-12 18:16:25','',''),(754,'1','274','1',1,'Retail Sale Id 752',2998.32,0.00,0.00,4.03,330.46,'2022-06-12 18:28:18','',''),(755,'1','274','1',1,'Retail Sale Id 753',19998.72,0.00,0.00,26.88,2204.16,'2022-06-12 18:29:44','',''),(756,'1','274','1',1,'Retail Sale Id 754',1502.88,0.00,0.00,2.02,165.64,'2022-06-12 18:37:00','',''),(757,'1','274','1',1,'Retail Sale Id 755',1502.88,0.00,0.00,2.02,165.64,'2022-06-12 18:47:06','',''),(758,'1','274','1',1,'Return of Retail Sale Id 755',0.00,1502.88,2.02,0.00,-165.64,'2022-06-12 19:48:20','',''),(759,'1','274','1',1,'Return of Retail Sale Id 754',0.00,1502.88,2.02,0.00,-165.64,'2022-06-12 19:49:09','',''),(760,'1','274','1',1,'Retail Sale Id 756',781.20,0.00,0.00,1.05,86.10,'2022-06-12 19:51:56','',''),(761,'1','274','1',1,'Retail Sale Id 756',23517.84,0.00,0.00,31.61,2592.02,'2022-06-12 19:51:56','',''),(762,'1','274','1',1,'Retail Sale Id 757',996.96,0.00,0.00,1.34,109.88,'2022-06-13 07:14:39','',''),(763,'1','274','1',1,'Retail Sale Id 758',2998.32,0.00,0.00,4.03,330.46,'2022-06-13 07:32:24','',''),(764,'1','274','1',1,'Retail Sale Id 759',2001.36,0.00,0.00,2.69,220.58,'2022-06-13 07:37:57','',''),(765,'1','274','1',1,'Retail Sale Id 760',2998.32,0.00,0.00,4.03,330.46,'2022-06-13 07:49:19','',''),(766,'1','274','1',1,'Retail Sale Id 761',4501.20,0.00,0.00,6.05,496.10,'2022-06-13 08:10:41','',''),(767,'1','274','1',1,'Retail Sale Id 762',2998.32,0.00,0.00,4.03,330.46,'2022-06-13 08:17:51','',''),(768,'1','274','1',1,'Retail Sale Id 763',2001.36,0.00,0.00,2.69,220.58,'2022-06-13 08:23:42','',''),(769,'1','274','1',1,'Retail Sale Id 764',2499.84,0.00,0.00,3.36,275.52,'2022-06-13 08:40:20','',''),(770,'1','274','1',1,'Retail Sale Id 765',4501.20,0.00,0.00,6.05,496.10,'2022-06-13 08:41:48','',''),(771,'1','274','1',1,'Retail Sale Id 766',1502.88,0.00,0.00,2.02,165.64,'2022-06-13 08:45:25','',''),(772,'1','274','1',1,'Retail Sale Id 767',1502.88,0.00,0.00,2.02,165.64,'2022-06-13 09:06:27','',''),(773,'1','274','1',1,'Retail Sale Id 768',3749.76,0.00,0.00,5.04,413.28,'2022-06-13 09:33:20','',''),(774,'1','274','1',1,'Retail Sale Id 769',37200.00,0.00,0.00,50.00,4100.00,'2022-06-13 09:36:55','',''),(775,'1','274','1',1,'Retail Sale Id 770',2998.32,0.00,0.00,4.03,330.46,'2022-06-13 09:38:26','',''),(776,'1','274','1',1,'Retail Sale Id 771',9300.00,0.00,0.00,12.50,1025.00,'2022-06-13 10:02:28','',''),(777,'1','274','1',1,'Retail Sale Id 772',9300.00,0.00,0.00,12.50,1025.00,'2022-06-13 10:41:55','',''),(778,'1','274','1',1,'Retail Sale Id 773',2246.88,0.00,0.00,3.02,247.64,'2022-06-13 10:44:12','',''),(779,'1','274','1',1,'Retail Sale Id 773',4501.20,0.00,0.00,6.05,496.10,'2022-06-13 10:44:12','',''),(780,'1','274','1',1,'Retail Sale Id 774',2001.36,0.00,0.00,2.69,220.58,'2022-06-13 10:46:23','',''),(781,'1','274','1',1,'Retail Sale Id 775',9300.00,0.00,0.00,12.50,1025.00,'2022-06-13 10:48:09','',''),(782,'1','274','1',1,'Retail Sale Id 776',5996.64,0.00,0.00,8.06,660.92,'2022-06-13 11:08:10','',''),(783,'1','274','1',1,'Retail Sale Id 777',4501.20,0.00,0.00,6.05,496.10,'2022-06-13 11:09:47','',''),(784,'1','274','1',1,'Retail Sale Id 778',2001.36,0.00,0.00,2.69,220.58,'2022-06-13 11:32:39','',''),(785,'1','274','1',1,'Retail Sale Id 778',4002.72,0.00,0.00,5.38,441.16,'2022-06-13 11:32:39','',''),(786,'1','274','1',1,'Retail Sale Id 779',2001.36,0.00,0.00,2.69,220.58,'2022-06-13 11:33:39','',''),(787,'1','274','1',1,'Retail Sale Id 780',9300.00,0.00,0.00,12.50,1025.00,'2022-06-13 11:38:33','',''),(788,'1','274','1',1,'Retail Sale Id 781',2001.36,0.00,0.00,2.69,220.58,'2022-06-13 11:39:36','',''),(789,'1','274','1',1,'Retail Sale Id 783',7998.00,0.00,0.00,10.75,881.50,'2022-06-13 11:43:56','',''),(790,'1','274','1',1,'Retail Sale Id 784',9300.00,0.00,0.00,12.50,1025.00,'2022-06-13 11:56:54','',''),(791,'1','274','1',1,'Retail Sale Id 785',2001.36,0.00,0.00,2.69,220.58,'2022-06-13 12:15:27','',''),(792,'1','274','1',1,'Retail Sale Id 786',8303.04,0.00,0.00,11.16,915.12,'2022-06-13 12:18:08','',''),(793,'1','274','1',1,'Retail Sale Id 787',8801.52,0.00,0.00,11.83,970.06,'2022-06-13 12:19:10','',''),(794,'1','274','1',1,'Retail Sale Id 788',2499.84,0.00,0.00,3.36,275.52,'2022-06-13 12:27:06','',''),(795,'1','274','1',1,'Return of Retail Sale Id 786',0.00,8303.04,11.16,0.00,-915.12,'2022-06-13 12:36:58','',''),(796,'1','274','1',1,'Retail Sale Id 789',9300.00,0.00,0.00,12.50,1025.00,'2022-06-13 12:43:34','',''),(797,'1','274','1',1,'Retail Sale Id 790',2998.32,0.00,0.00,4.03,330.46,'2022-06-13 12:48:45','',''),(798,'1','274','1',1,'Retail Sale Id 791',9500.88,0.00,0.00,12.77,1047.14,'2022-06-13 13:25:33','',''),(799,'1','274','1',1,'Retail Sale Id 793',3496.80,0.00,0.00,4.70,385.40,'2022-06-13 13:26:31','',''),(800,'1','274','1',1,'Retail Sale Id 794',37200.00,0.00,0.00,50.00,4100.00,'2022-06-13 13:30:03','',''),(801,'1','274','1',1,'Retail Sale Id 795',4002.72,0.00,0.00,5.38,441.16,'2022-06-13 13:32:11','',''),(802,'1','274','1',1,'Retail Sale Id 796',1502.88,0.00,0.00,2.02,165.64,'2022-06-13 13:36:31','',''),(803,'1','274','1',1,'Retail Sale Id 797',2998.32,0.00,0.00,4.03,330.46,'2022-06-13 14:06:14','',''),(804,'1','274','1',1,'Retail Sale Id 798',7001.04,0.00,0.00,9.41,771.62,'2022-06-13 14:12:15','',''),(805,'1','274','1',1,'Retail Sale Id 799',996.96,0.00,0.00,1.34,109.88,'2022-06-13 14:33:54','',''),(806,'1','274','1',1,'Retail Sale Id 800',9300.00,0.00,0.00,12.50,1025.00,'2022-06-13 14:48:54','',''),(807,'1','274','1',1,'Retail Sale Id 800',37200.00,0.00,0.00,50.00,4100.00,'2022-06-13 14:48:54','',''),(808,'1','274','1',1,'Retail Sale Id 801',2202.24,0.00,0.00,2.96,242.72,'2022-06-13 14:49:51','',''),(809,'1','274','1',1,'Retail Sale Id 802',4002.72,0.00,0.00,5.38,441.16,'2022-06-13 15:00:42','',''),(810,'1','274','1',1,'Retail Sale Id 803',4501.20,0.00,0.00,6.05,496.10,'2022-06-13 15:08:05','',''),(811,'1','274','1',1,'Retail Sale Id 804',9300.00,0.00,0.00,12.50,1025.00,'2022-06-13 15:21:19','',''),(812,'1','274','1',1,'Retail Sale Id 805',9300.00,0.00,0.00,12.50,1025.00,'2022-06-13 15:25:26','',''),(813,'1','274','1',1,'Retail Sale Id 806',4501.20,0.00,0.00,6.05,496.10,'2022-06-13 15:28:26','',''),(814,'1','274','1',1,'Retail Sale Id 806',4501.20,0.00,0.00,6.05,496.10,'2022-06-13 15:28:26','',''),(815,'1','274','1',1,'Retail Sale Id 806',9300.00,0.00,0.00,12.50,1025.00,'2022-06-13 15:28:26','',''),(816,'1','274','1',1,'Retail Sale Id 807',3720.00,0.00,0.00,5.00,410.00,'2022-06-13 15:30:57','',''),(817,'1','274','1',1,'Retail Sale Id 808',1502.88,0.00,0.00,2.02,165.64,'2022-06-13 15:35:06','',''),(818,'1','274','1',1,'Retail Sale Id 810',18600.00,0.00,0.00,25.00,2050.00,'2022-06-13 15:52:39','',''),(819,'1','274','1',1,'Retail Sale Id 811',4501.20,0.00,0.00,6.05,496.10,'2022-06-13 15:54:31','',''),(820,'1','274','1',1,'Retail Sale Id 812',1502.88,0.00,0.00,2.02,165.64,'2022-06-13 15:57:59','',''),(821,'1','274','1',1,'Retail Sale Id 813',1502.88,0.00,0.00,2.02,165.64,'2022-06-13 15:58:48','',''),(822,'1','274','1',1,'Retail Sale Id 814',9300.00,0.00,0.00,12.50,1025.00,'2022-06-13 16:06:28','',''),(823,'1','274','1',1,'Retail Sale Id 815',2298.96,0.00,0.00,3.09,253.38,'2022-06-13 16:11:52','',''),(824,'1','274','1',1,'Retail Sale Id 816',1800.48,0.00,0.00,2.42,198.44,'2022-06-13 16:14:36','',''),(825,'1','274','1',1,'Retail Sale Id 817',1502.88,0.00,0.00,2.02,165.64,'2022-06-13 16:22:25','',''),(826,'1','274','1',1,'Retail Sale Id 818',4501.20,0.00,0.00,6.05,496.10,'2022-06-13 16:32:32','',''),(827,'1','274','1',1,'Retail Sale Id 819',5996.64,0.00,0.00,8.06,660.92,'2022-06-13 16:35:17','',''),(828,'1','274','1',1,'Retail Sale Id 820',2246.88,0.00,0.00,3.02,247.64,'2022-06-13 16:37:00','',''),(829,'1','274','1',1,'Retail Sale Id 821',9999.36,0.00,0.00,13.44,1102.08,'2022-06-13 16:42:23','',''),(830,'1','274','1',1,'Retail Sale Id 822',37200.00,0.00,0.00,50.00,4100.00,'2022-06-13 16:44:30','',''),(831,'1','274','1',1,'Retail Sale Id 823',2246.88,0.00,0.00,3.02,247.64,'2022-06-13 16:55:02','',''),(832,'1','274','1',1,'Retail Sale Id 824',2998.32,0.00,0.00,4.03,330.46,'2022-06-13 17:02:38','',''),(833,'1','274','1',1,'Retail Sale Id 825',2499.84,0.00,0.00,3.36,275.52,'2022-06-13 17:03:42','',''),(834,'1','274','1',1,'Retail Sale Id 826',9300.00,0.00,0.00,12.50,1025.00,'2022-06-13 17:05:14','',''),(835,'1','274','1',1,'Retail Sale Id 827',1302.00,0.00,0.00,1.75,143.50,'2022-06-13 17:33:48','',''),(836,'1','274','1',1,'Retail Sale Id 828',7893.84,0.00,0.00,10.61,870.02,'2022-06-13 19:15:54','',''),(837,'1','274','1',1,'Retail Sale Id 828',47415.12,0.00,0.00,63.73,5225.86,'2022-06-13 19:15:54','',''),(838,'1','274','1',1,'Retail Sale Id 829',9300.00,0.00,0.00,12.50,1025.00,'2022-06-14 07:42:22','',''),(839,'1','274','1',1,'Retail Sale Id 830',2001.36,0.00,0.00,2.69,220.58,'2022-06-14 07:43:50','',''),(840,'1','274','1',1,'Retail Sale Id 831',4002.72,0.00,0.00,5.38,441.16,'2022-06-14 08:06:12','',''),(841,'1','274','1',1,'Retail Sale Id 832',6502.56,0.00,0.00,8.74,716.68,'2022-06-14 08:09:16','',''),(842,'1','274','1',1,'Retail Sale Id 833',4501.20,0.00,0.00,6.05,496.10,'2022-06-14 08:17:42','',''),(843,'1','274','1',1,'Retail Sale Id 834',9300.00,0.00,0.00,12.50,1025.00,'2022-06-14 08:28:49','',''),(844,'1','274','1',1,'Retail Sale Id 835',1502.88,0.00,0.00,2.02,165.64,'2022-06-14 08:36:29','',''),(845,'1','274','1',1,'Retail Sale Id 836',2246.88,0.00,0.00,3.02,247.64,'2022-06-14 08:47:34','',''),(846,'1','274','1',1,'Retail Sale Id 837',7001.04,0.00,0.00,9.41,771.62,'2022-06-14 08:48:43','',''),(847,'1','274','1',1,'Retail Sale Id 838',996.96,0.00,0.00,1.34,109.88,'2022-06-14 08:55:12','',''),(848,'1','274','1',1,'Retail Sale Id 839',2001.36,0.00,0.00,2.69,220.58,'2022-06-14 09:49:13','',''),(849,'1','274','1',1,'Retail Sale Id 840',2998.32,0.00,0.00,4.03,330.46,'2022-06-14 09:51:57','',''),(850,'1','274','1',1,'Retail Sale Id 841',17119.44,0.00,0.00,23.01,1886.82,'2022-06-14 10:18:45','',''),(851,'1','274','1',1,'Retail Sale Id 843',1502.88,0.00,0.00,2.02,165.64,'2022-06-14 10:20:22','',''),(852,'1','274','1',1,'Retail Sale Id 844',33480.00,0.00,0.00,45.00,3690.00,'2022-06-14 10:29:00','',''),(853,'1','274','1',1,'Retail Sale Id 845',2202.24,0.00,0.00,2.96,242.72,'2022-06-14 10:31:40','',''),(854,'1','274','1',1,'Retail Sale Id 846',9300.00,0.00,0.00,12.50,1025.00,'2022-06-14 10:34:54','',''),(855,'1','274','1',1,'Retail Sale Id 847',3749.76,0.00,0.00,5.04,413.28,'2022-06-14 10:37:35','',''),(856,'1','274','1',1,'Retail Sale Id 848',4501.20,0.00,0.00,6.05,496.10,'2022-06-14 10:38:53','',''),(857,'1','274','1',1,'Retail Sale Id 849',3720.00,0.00,0.00,5.00,410.00,'2022-06-14 11:10:30','',''),(858,'1','274','1',1,'Retail Sale Id 850',4002.72,0.00,0.00,5.38,441.16,'2022-06-14 11:21:51','',''),(859,'1','274','1',1,'Retail Sale Id 851',3749.76,0.00,0.00,5.04,413.28,'2022-06-14 11:24:49','',''),(860,'1','274','1',1,'Retail Sale Id 852',74400.00,0.00,0.00,100.00,8200.00,'2022-06-14 11:49:01','',''),(861,'1','274','1',1,'Retail Sale Id 855',27900.00,0.00,0.00,37.50,3075.00,'2022-06-14 12:07:56','',''),(862,'1','274','1',1,'Retail Sale Id 857',4501.20,0.00,0.00,6.05,496.10,'2022-06-14 12:37:03','',''),(863,'1','274','1',1,'Retail Sale Id 858',9002.40,0.00,0.00,12.10,992.20,'2022-06-14 13:27:58','',''),(864,'1','274','1',1,'Retail Sale Id 861',2001.36,0.00,0.00,2.69,220.58,'2022-06-14 14:02:07','',''),(865,'1','274','1',1,'Retail Sale Id 862',3697.68,0.00,0.00,4.97,407.54,'2022-06-14 14:12:22','',''),(866,'1','274','1',1,'Retail Sale Id 863',9002.40,0.00,0.00,12.10,992.20,'2022-06-14 15:05:04','',''),(867,'1','274','1',1,'Retail Sale Id 865',9300.00,0.00,0.00,12.50,1025.00,'2022-06-14 15:07:41','',''),(868,'1','274','1',1,'Retail Sale Id 867',2246.88,0.00,0.00,3.02,247.64,'2022-06-14 15:08:46','',''),(869,'1','274','1',1,'Retail Sale Id 869',4464.00,0.00,0.00,6.00,492.00,'2022-06-14 15:11:16','',''),(870,'1','274','1',1,'Retail Sale Id 871',2246.88,0.00,0.00,3.02,247.64,'2022-06-14 15:58:26','',''),(871,'1','274','1',1,'Retail Sale Id 872',9300.00,0.00,0.00,12.50,1025.00,'2022-06-14 16:01:44','',''),(872,'1','274','1',1,'Retail Sale Id 873',9300.00,0.00,0.00,12.50,1025.00,'2022-06-14 16:24:55','',''),(873,'1','274','1',1,'Retail Sale Id 874',2246.88,0.00,0.00,3.02,247.64,'2022-06-14 16:30:32','',''),(874,'1','274','1',1,'Retail Sale Id 875',3749.76,0.00,0.00,5.04,413.28,'2022-06-14 16:33:20','',''),(875,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,22183.62,33.51,0.00,0.00,'2022-06-14 16:59:39','',''),(876,'1','274',NULL,1,'Reception corrector for bridging 6',0.00,0.00,0.00,33.51,0.00,'2022-06-14 17:01:00','',''),(877,'1','274','1',1,'Received from bridging 6',0.00,0.00,33.51,0.00,0.00,'2022-06-14 17:01:00','',''),(878,'1','274','1',1,'Retail Sale Id 876',21687.60,0.00,0.00,29.15,2390.30,'2022-06-14 17:02:08','',''),(879,'1','274','1',1,'Retail Sale Id 876',34886.16,0.00,0.00,46.89,3844.98,'2022-06-14 17:02:08','',''),(880,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,662000.00,1000.00,0.00,0.00,'2022-06-15 09:31:52','',''),(881,'1','274',NULL,1,'Reception corrector for bridging 7',0.00,0.00,0.00,1000.00,0.00,'2022-06-15 09:33:13','',''),(882,'1','274','1',1,'Received from bridging 7',0.00,0.00,1000.00,0.00,0.00,'2022-06-15 09:33:13','',''),(883,'1','274','1',1,'Retail Sale Id 877',2998.32,0.00,0.00,4.03,330.46,'2022-06-15 09:55:24','',''),(884,'1','274','1',1,'Retail Sale Id 878',1488.00,0.00,0.00,2.00,164.00,'2022-06-15 10:10:41','',''),(885,'1','274','1',1,'Retail Sale Id 878',18600.00,0.00,0.00,25.00,2050.00,'2022-06-15 10:10:41','',''),(886,'1','274','1',1,'Retail Sale Id 879',22320.00,0.00,0.00,30.00,2460.00,'2022-06-15 10:12:19','',''),(887,'1','274','1',1,'Retail Sale Id 880',14880.00,0.00,0.00,20.00,1640.00,'2022-06-15 10:13:36','',''),(888,'1','274','1',1,'Retail Sale Id 881',3749.76,0.00,0.00,5.04,413.28,'2022-06-15 10:16:11','',''),(889,'1','274','1',1,'Retail Sale Id 882',16368.00,0.00,0.00,22.00,1804.00,'2022-06-15 10:18:44','',''),(890,'1','274','1',1,'Retail Sale Id 883',19998.72,0.00,0.00,26.88,2204.16,'2022-06-15 10:26:18','',''),(891,'1','274','1',1,'Retail Sale Id 884',5996.64,0.00,0.00,8.06,660.92,'2022-06-15 10:30:10','',''),(892,'1','274','1',1,'Retail Sale Id 885',996.96,0.00,0.00,1.34,109.88,'2022-06-15 10:32:34','',''),(893,'1','274','1',1,'Return of Retail Sale Id 880',0.00,14880.00,20.00,0.00,-1640.00,'2022-06-15 10:41:13','',''),(894,'1','274','1',1,'Retail Sale Id 886',2202.24,0.00,0.00,2.96,242.72,'2022-06-15 10:44:33','',''),(895,'1','274','1',1,'Retail Sale Id 887',2298.96,0.00,0.00,3.09,253.38,'2022-06-15 10:54:10','',''),(896,'1','274','1',1,'Retail Sale Id 888',1502.88,0.00,0.00,2.02,165.64,'2022-06-15 11:01:10','',''),(897,'1','274','1',1,'Retail Sale Id 889',4999.68,0.00,0.00,6.72,551.04,'2022-06-15 11:03:11','',''),(898,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,2608280.00,3940.00,0.00,0.00,'2022-06-15 11:06:21','',''),(899,'1','274',NULL,1,'Reception corrector for bridging 8',0.00,0.00,0.00,3940.00,0.00,'2022-06-15 11:07:46','',''),(900,'1','274','1',1,'Received from bridging 8',0.00,0.00,3940.00,0.00,0.00,'2022-06-15 11:07:46','',''),(901,'1','274','1',1,'Retail Sale Id 890',2001.36,0.00,0.00,2.69,220.58,'2022-06-15 11:19:53','',''),(902,'1','274','1',1,'Retail Sale Id 891',1197.84,0.00,0.00,1.61,132.02,'2022-06-15 11:44:53','',''),(903,'1','274','1',1,'Retail Sale Id 892',2246.88,0.00,0.00,3.02,247.64,'2022-06-15 11:47:42','',''),(904,'1','274','1',1,'Retail Sale Id 892',4501.20,0.00,0.00,6.05,496.10,'2022-06-15 11:47:42','',''),(905,'1','274','1',1,'Retail Sale Id 893',9300.00,0.00,0.00,12.50,1025.00,'2022-06-15 12:26:17','',''),(906,'1','274','1',1,'Retail Sale Id 895',8898.24,0.00,0.00,11.96,980.72,'2022-06-15 13:15:46','',''),(907,'1','274','1',1,'Retail Sale Id 896',8898.24,0.00,0.00,11.96,980.72,'2022-06-15 13:17:40','',''),(908,'1','274','1',1,'Retail Sale Id 897',2246.88,0.00,0.00,3.02,247.64,'2022-06-15 13:29:39','',''),(909,'1','274','1',1,'Retail Sale Id 898',9300.00,0.00,0.00,12.50,1025.00,'2022-06-15 13:45:39','',''),(910,'1','274','1',1,'Retail Sale Id 900',37200.00,0.00,0.00,50.00,4100.00,'2022-06-15 14:30:24','',''),(911,'1','274','1',1,'Retail Sale Id 901',1502.88,0.00,0.00,2.02,165.64,'2022-06-15 14:32:53','',''),(912,'1','274','1',1,'Retail Sale Id 902',1502.88,0.00,0.00,2.02,165.64,'2022-06-15 14:37:45','',''),(913,'1','274','1',1,'Retail Sale Id 903',4501.20,0.00,0.00,6.05,496.10,'2022-06-15 14:54:43','',''),(914,'1','274','1',1,'Retail Sale Id 904',7440.00,0.00,0.00,10.00,820.00,'2022-06-15 15:01:29','',''),(915,'1','274','1',1,'Retail Sale Id 905',1502.88,0.00,0.00,2.02,165.64,'2022-06-15 15:09:34','',''),(916,'1','274','1',1,'Retail Sale Id 906',1502.88,0.00,0.00,2.02,165.64,'2022-06-15 15:16:02','',''),(917,'1','274','1',1,'Retail Sale Id 907',9999.36,0.00,0.00,13.44,1102.08,'2022-06-15 15:22:16','',''),(918,'1','274','1',1,'Retail Sale Id 908',4002.72,0.00,0.00,5.38,441.16,'2022-06-15 15:28:01','',''),(919,'1','274','1',1,'Retail Sale Id 909',8496.48,0.00,0.00,11.42,936.44,'2022-06-15 15:39:34','',''),(920,'1','274','1',1,'Retail Sale Id 911',14880.00,0.00,0.00,20.00,1640.00,'2022-06-15 15:44:40','',''),(921,'1','274','1',1,'Retail Sale Id 913',2246.88,0.00,0.00,3.02,247.64,'2022-06-15 15:53:31','',''),(922,'1','274','1',1,'Retail Sale Id 914',3749.76,0.00,0.00,5.04,413.28,'2022-06-15 16:03:32','',''),(923,'1','274','1',1,'Retail Sale Id 915',2246.88,0.00,0.00,3.02,247.64,'2022-06-15 16:14:28','',''),(924,'1','274','1',1,'Retail Sale Id 916',9300.00,0.00,0.00,12.50,1025.00,'2022-06-15 16:45:04','',''),(925,'1','274','1',1,'Retail Sale Id 917',9300.00,0.00,0.00,12.50,1025.00,'2022-06-15 16:46:03','',''),(926,'1','274','1',1,'Retail Sale Id 920',9300.00,0.00,0.00,12.50,1025.00,'2022-06-15 17:02:43','',''),(927,'1','274','1',1,'Retail Sale Id 920',37200.00,0.00,0.00,50.00,4100.00,'2022-06-15 17:02:43','',''),(928,'1','274','1',1,'Retail Sale Id 921',996.96,0.00,0.00,1.34,109.88,'2022-06-15 17:16:09','',''),(929,'1','274','1',1,'Retail Sale Id 922',3749.76,0.00,0.00,5.04,413.28,'2022-06-15 17:20:19','',''),(930,'1','274','1',1,'Retail Sale Id 923',2001.36,0.00,0.00,2.69,220.58,'2022-06-15 17:23:27','',''),(931,'1','274','1',1,'Retail Sale Id 924',9300.00,0.00,0.00,12.50,1025.00,'2022-06-15 17:26:25','',''),(932,'1','274','1',1,'Retail Sale Id 925',2246.88,0.00,0.00,3.02,247.64,'2022-06-15 17:27:28','',''),(933,'1','274','1',1,'Retail Sale Id 926',9300.00,0.00,0.00,12.50,1025.00,'2022-06-15 17:29:28','',''),(934,'1','274','1',1,'Retail Sale Id 927',996.96,0.00,0.00,1.34,109.88,'2022-06-15 17:31:43','',''),(935,'1','274','1',1,'Retail Sale Id 928',1502.88,0.00,0.00,2.02,165.64,'2022-06-15 17:35:54','',''),(936,'1','274','1',1,'Retail Sale Id 929',2499.84,0.00,0.00,3.36,275.52,'2022-06-15 17:38:08','',''),(937,'1','274','1',1,'Retail Sale Id 930',1502.88,0.00,0.00,2.02,165.64,'2022-06-15 17:49:22','',''),(938,'1','274','1',1,'Retail Sale Id 930',1502.88,0.00,0.00,2.02,165.64,'2022-06-15 17:49:22','',''),(939,'1','274','1',1,'Retail Sale Id 930',1502.88,0.00,0.00,2.02,165.64,'2022-06-15 17:49:22','',''),(940,'1','274','1',1,'Retail Sale Id 931',4501.20,0.00,0.00,6.05,496.10,'2022-06-15 17:50:36','',''),(941,'1','274','1',1,'Retail Sale Id 932',2001.36,0.00,0.00,2.69,220.58,'2022-06-15 17:52:23','',''),(942,'1','274','1',1,'Retail Sale Id 933',18600.00,0.00,0.00,25.00,2050.00,'2022-06-15 17:54:13','',''),(943,'1','274','1',1,'Retail Sale Id 934',9300.00,0.00,0.00,12.50,1025.00,'2022-06-15 17:58:47','',''),(944,'1','274','1',1,'Retail Sale Id 935',996.96,0.00,0.00,1.34,109.88,'2022-06-15 18:03:17','',''),(945,'1','274','1',1,'Retail Sale Id 936',9300.00,0.00,0.00,12.50,1025.00,'2022-06-15 18:04:49','',''),(946,'1','274','1',1,'Retail Sale Id 937',22320.00,0.00,0.00,30.00,2460.00,'2022-06-15 18:23:19','',''),(947,'1','274','1',1,'Retail Sale Id 938',14880.00,0.00,0.00,20.00,1640.00,'2022-06-15 18:24:09','',''),(948,'1','274','1',1,'Retail Sale Id 939',18600.00,0.00,0.00,25.00,2050.00,'2022-06-15 18:35:43','',''),(949,'1','274','1',1,'Retail Sale Id 940',2998.32,0.00,0.00,4.03,330.46,'2022-06-15 18:43:56','',''),(950,'1','274','1',1,'Retail Sale Id 941',9300.00,0.00,0.00,12.50,1025.00,'2022-06-15 18:50:43','',''),(951,'1','274','1',1,'Retail Sale Id 942',2499.84,0.00,0.00,3.36,275.52,'2022-06-15 18:54:20','',''),(952,'1','274','1',1,'Retail Sale Id 943',9300.00,0.00,0.00,12.50,1025.00,'2022-06-15 19:02:59','',''),(953,'1','274','1',1,'Retail Sale Id 944',37200.00,0.00,0.00,50.00,4100.00,'2022-06-15 19:08:52','',''),(954,'1','274','1',1,'Retail Sale Id 944',37200.00,0.00,0.00,50.00,4100.00,'2022-06-15 19:08:52','',''),(955,'1','274','1',1,'Retail Sale Id 945',13243.20,0.00,0.00,17.80,1459.60,'2022-06-15 19:45:20','',''),(956,'1','274','1',1,'Retail Sale Id 945',37311.60,0.00,0.00,50.15,4112.30,'2022-06-15 19:45:20','',''),(957,'1','274','1',1,'Retail Sale Id 946',37200.00,0.00,0.00,50.00,4100.00,'2022-06-16 07:34:01','',''),(958,'1','274','1',1,'Retail Sale Id 947',2001.36,0.00,0.00,2.69,220.58,'2022-06-16 07:43:13','',''),(959,'1','274','1',1,'Retail Sale Id 948',4501.20,0.00,0.00,6.05,496.10,'2022-06-16 08:10:14','',''),(960,'1','274','1',1,'Retail Sale Id 949',7998.00,0.00,0.00,10.75,881.50,'2022-06-16 08:16:03','',''),(961,'1','274','1',1,'Retail Sale Id 950',9002.40,0.00,0.00,12.10,992.20,'2022-06-16 08:23:05','',''),(962,'1','274','1',1,'Retail Sale Id 952',9300.00,0.00,0.00,12.50,1025.00,'2022-06-16 08:31:23','',''),(963,'1','274','1',1,'Retail Sale Id 953',2700.72,0.00,0.00,3.63,297.66,'2022-06-16 08:35:47','',''),(964,'1','274','1',1,'Retail Sale Id 954',9300.00,0.00,0.00,12.50,1025.00,'2022-06-16 08:40:40','',''),(965,'1','274','1',1,'Retail Sale Id 955',4999.68,0.00,0.00,6.72,551.04,'2022-06-16 08:41:27','',''),(966,'1','274','1',1,'Retail Sale Id 956',1101.12,0.00,0.00,1.48,121.36,'2022-06-16 08:45:32','',''),(967,'1','274','1',1,'Retail Sale Id 957',9300.00,0.00,0.00,12.50,1025.00,'2022-06-16 08:51:30','',''),(968,'1','274','1',1,'Retail Sale Id 958',9300.00,0.00,0.00,12.50,1025.00,'2022-06-16 08:59:00','',''),(969,'1','274','1',1,'Retail Sale Id 959',7998.00,0.00,0.00,10.75,881.50,'2022-06-16 09:05:50','',''),(970,'1','274','1',1,'Retail Sale Id 960',2001.36,0.00,0.00,2.69,220.58,'2022-06-16 09:08:52','',''),(971,'1','274','1',1,'Retail Sale Id 960',3697.68,0.00,0.00,4.97,407.54,'2022-06-16 09:08:52','',''),(972,'1','274','1',1,'Retail Sale Id 961',2001.36,0.00,0.00,2.69,220.58,'2022-06-16 09:19:30','',''),(973,'1','274','1',1,'Retail Sale Id 962',1398.72,0.00,0.00,1.88,154.16,'2022-06-16 09:21:51','',''),(974,'1','274','1',1,'Retail Sale Id 963',1502.88,0.00,0.00,2.02,165.64,'2022-06-16 09:22:52','',''),(975,'1','274','1',1,'Retail Sale Id 964',4501.20,0.00,0.00,6.05,496.10,'2022-06-16 09:27:30','',''),(976,'1','274','1',1,'Retail Sale Id 965',996.96,0.00,0.00,1.34,109.88,'2022-06-16 09:33:32','',''),(977,'1','274','1',1,'Retail Sale Id 966',2246.88,0.00,0.00,3.02,247.64,'2022-06-16 10:36:29','',''),(978,'1','274','1',1,'Retail Sale Id 967',4501.20,0.00,0.00,6.05,496.10,'2022-06-16 10:47:49','',''),(979,'1','274','1',1,'Retail Sale Id 968',3749.76,0.00,0.00,5.04,413.28,'2022-06-16 10:48:33','',''),(980,'1','274','1',1,'Retail Sale Id 969',2246.88,0.00,0.00,3.02,247.64,'2022-06-16 10:49:14','',''),(981,'1','274','1',1,'Retail Sale Id 970',2499.84,0.00,0.00,3.36,275.52,'2022-06-16 11:06:50','',''),(982,'1','274','1',1,'Retail Sale Id 971',1502.88,0.00,0.00,2.02,165.64,'2022-06-16 11:07:41','',''),(983,'1','274','1',1,'Retail Sale Id 972',14999.04,0.00,0.00,20.16,1653.12,'2022-06-16 11:12:30','',''),(984,'1','274','1',1,'Retail Sale Id 973',4501.20,0.00,0.00,6.05,496.10,'2022-06-16 11:15:45','',''),(985,'1','274','1',1,'Retail Sale Id 975',81840.00,0.00,0.00,110.00,9020.00,'2022-06-16 11:55:40','',''),(986,'1','274','1',1,'Retail Sale Id 976',9300.00,0.00,0.00,12.50,1025.00,'2022-06-16 11:59:56','',''),(987,'1','274','1',1,'Retail Sale Id 977',4501.20,0.00,0.00,6.05,496.10,'2022-06-16 12:04:54','',''),(988,'1','274','1',1,'Retail Sale Id 978',24180.00,0.00,0.00,32.50,2665.00,'2022-06-16 13:46:04','',''),(989,'1','274','1',1,'Retail Sale Id 979',37200.00,0.00,0.00,50.00,4100.00,'2022-06-16 13:47:02','',''),(990,'1','274','1',1,'Retail Sale Id 980',4501.20,0.00,0.00,6.05,496.10,'2022-06-16 13:48:03','',''),(991,'1','274','1',1,'Retail Sale Id 981',803.52,0.00,0.00,1.08,88.56,'2022-06-16 14:00:54','',''),(992,'1','274','1',1,'Retail Sale Id 982',37200.00,0.00,0.00,50.00,4100.00,'2022-06-16 14:07:56','',''),(993,'1','274','1',1,'Retail Sale Id 983',2001.36,0.00,0.00,2.69,220.58,'2022-06-16 14:25:12','',''),(994,'1','274','1',1,'Retail Sale Id 984',2001.36,0.00,0.00,2.69,220.58,'2022-06-16 14:27:44','',''),(995,'1','274','1',1,'Retail Sale Id 985',6502.56,0.00,0.00,8.74,716.68,'2022-06-16 14:34:19','',''),(996,'1','274','1',1,'Retail Sale Id 986',2246.88,0.00,0.00,3.02,247.64,'2022-06-16 14:49:55','',''),(997,'1','274','1',1,'Retail Sale Id 988',2001.36,0.00,0.00,2.69,220.58,'2022-06-16 14:56:17','',''),(998,'1','274','1',1,'Retail Sale Id 989',9300.00,0.00,0.00,12.50,1025.00,'2022-06-16 15:00:06','',''),(999,'1','274','1',1,'Retail Sale Id 990',1502.88,0.00,0.00,2.02,165.64,'2022-06-16 15:05:47','',''),(1000,'1','274','1',1,'Retail Sale Id 991',3749.76,0.00,0.00,5.04,413.28,'2022-06-16 15:06:53','',''),(1001,'1','274','1',1,'Retail Sale Id 992',9300.00,0.00,0.00,12.50,1025.00,'2022-06-16 15:09:28','',''),(1002,'1','274','1',1,'Retail Sale Id 993',3749.76,0.00,0.00,5.04,413.28,'2022-06-16 15:11:00','',''),(1003,'1','274','1',1,'Retail Sale Id 993',4501.20,0.00,0.00,6.05,496.10,'2022-06-16 15:11:00','',''),(1004,'1','274','1',1,'Retail Sale Id 994',3749.76,0.00,0.00,5.04,413.28,'2022-06-16 15:22:33','',''),(1005,'1','274','1',1,'Retail Sale Id 995',19351.44,0.00,0.00,26.01,2132.82,'2022-06-16 15:32:00','',''),(1006,'1','274','1',1,'Retail Sale Id 996',3496.80,0.00,0.00,4.70,385.40,'2022-06-16 15:58:15','',''),(1007,'1','274','1',1,'Retail Sale Id 997',9300.00,0.00,0.00,12.50,1025.00,'2022-06-16 16:19:28','',''),(1008,'1','274','1',1,'Retail Sale Id 998',2246.88,0.00,0.00,3.02,247.64,'2022-06-16 16:35:32','',''),(1009,'1','274','1',1,'Retail Sale Id 999',2998.32,0.00,0.00,4.03,330.46,'2022-06-16 16:41:03','',''),(1010,'1','274','1',1,'Retail Sale Id 1000',9300.00,0.00,0.00,12.50,1025.00,'2022-06-16 16:45:07','',''),(1011,'1','274','1',1,'Retail Sale Id 1001',7499.52,0.00,0.00,10.08,826.56,'2022-06-16 16:46:42','',''),(1012,'1','274','1',1,'Retail Sale Id 1002',1502.88,0.00,0.00,2.02,165.64,'2022-06-16 16:50:50','',''),(1013,'1','274','1',1,'Retail Sale Id 1003',9300.00,0.00,0.00,12.50,1025.00,'2022-06-16 16:55:17','',''),(1014,'1','274','1',1,'Retail Sale Id 1004',1502.88,0.00,0.00,2.02,165.64,'2022-06-16 17:06:30','',''),(1015,'1','274','1',1,'Retail Sale Id 1005',7440.00,0.00,0.00,10.00,820.00,'2022-06-16 17:13:48','',''),(1016,'1','274','1',1,'Retail Sale Id 1006',2001.36,0.00,0.00,2.69,220.58,'2022-06-16 17:24:05','',''),(1017,'1','274','1',1,'Retail Sale Id 1007',3749.76,0.00,0.00,5.04,413.28,'2022-06-16 17:28:59','',''),(1018,'1','274','1',1,'Retail Sale Id 1008',29760.00,0.00,0.00,40.00,3280.00,'2022-06-16 17:31:15','',''),(1019,'1','274','1',1,'Retail Sale Id 1009',16368.00,0.00,0.00,22.00,1804.00,'2022-06-16 17:44:36','',''),(1020,'1','274','1',1,'Retail Sale Id 1010',4501.20,0.00,0.00,6.05,496.10,'2022-06-16 17:46:55','',''),(1021,'1','274','1',1,'Retail Sale Id 1011',4501.20,0.00,0.00,6.05,496.10,'2022-06-16 17:56:43','',''),(1022,'1','274','1',1,'Retail Sale Id 1012',900.24,0.00,0.00,1.21,99.22,'2022-06-16 18:09:19','',''),(1023,'1','274','1',1,'Retail Sale Id 1013',3496.80,0.00,0.00,4.70,385.40,'2022-06-16 18:16:46','',''),(1024,'1','274','1',1,'Retail Sale Id 1014',699.36,0.00,0.00,0.94,77.08,'2022-06-16 18:36:06','',''),(1025,'1','274','1',1,'Retail Sale Id 1015',1502.88,0.00,0.00,2.02,165.64,'2022-06-16 18:39:52','',''),(1026,'1','274','1',1,'Retail Sale Id 1016',9300.00,0.00,0.00,12.50,1025.00,'2022-06-16 18:46:30','',''),(1027,'1','274','1',1,'Retail Sale Id 1017',2001.36,0.00,0.00,2.69,220.58,'2022-06-16 18:49:56','',''),(1028,'1','274','1',1,'Retail Sale Id 1018',2998.32,0.00,0.00,4.03,330.46,'2022-06-16 18:57:43','',''),(1029,'1','274','1',1,'Retail Sale Id 1019',4902.96,0.00,0.00,6.59,540.38,'2022-06-16 19:28:08','',''),(1030,'1','274','1',1,'Retail Sale Id 1019',53590.32,0.00,0.00,72.03,5906.46,'2022-06-16 19:28:08','',''),(1031,'1','274','1',1,'Retail Sale Id 1020',9300.00,0.00,0.00,12.50,1025.00,'2022-06-17 08:12:01','',''),(1032,'1','274','1',1,'Retail Sale Id 1021',9300.00,0.00,0.00,12.50,1025.00,'2022-06-17 08:13:21','',''),(1033,'1','274','1',1,'Retail Sale Id 1022',4501.20,0.00,0.00,6.05,496.10,'2022-06-17 08:14:02','',''),(1034,'1','274','1',1,'Retail Sale Id 1023',9300.00,0.00,0.00,12.50,1025.00,'2022-06-17 08:40:58','',''),(1035,'1','274','1',1,'Retail Sale Id 1024',2246.88,0.00,0.00,3.02,247.64,'2022-06-17 08:42:04','',''),(1036,'1','274','1',1,'Retail Sale Id 1025',9300.00,0.00,0.00,12.50,1025.00,'2022-06-17 08:52:47','',''),(1037,'1','274','1',1,'Retail Sale Id 1026',4501.20,0.00,0.00,6.05,496.10,'2022-06-17 08:59:59','',''),(1038,'1','274','1',1,'Retail Sale Id 1027',33480.00,0.00,0.00,45.00,3690.00,'2022-06-17 09:21:50','',''),(1039,'1','274','1',1,'Retail Sale Id 1028',9300.00,0.00,0.00,12.50,1025.00,'2022-06-17 09:41:31','',''),(1040,'1','274','1',1,'Retail Sale Id 1029',1502.88,0.00,0.00,2.02,165.64,'2022-06-17 10:08:32','',''),(1041,'1','274','1',1,'Retail Sale Id 1030',9300.00,0.00,0.00,12.50,1025.00,'2022-06-17 10:12:59','',''),(1042,'1','274','1',1,'Retail Sale Id 1031',9300.00,0.00,0.00,12.50,1025.00,'2022-06-17 10:15:29','',''),(1043,'1','274','1',1,'Retail Sale Id 1032',9300.00,0.00,0.00,12.50,1025.00,'2022-06-17 10:16:59','',''),(1044,'1','274','1',1,'Retail Sale Id 1033',4501.20,0.00,0.00,6.05,496.10,'2022-06-17 10:19:57','',''),(1045,'1','274','1',1,'Retail Sale Id 1034',7001.04,0.00,0.00,9.41,771.62,'2022-06-17 10:21:58','',''),(1046,'1','274','1',1,'Retail Sale Id 1035',1502.88,0.00,0.00,2.02,165.64,'2022-06-17 10:23:35','',''),(1047,'1','274','1',1,'Retail Sale Id 1036',22349.76,0.00,0.00,30.04,2463.28,'2022-06-17 10:34:11','',''),(1048,'1','274','1',1,'Retail Sale Id 1037',9002.40,0.00,0.00,12.10,992.20,'2022-06-17 10:51:01','',''),(1049,'1','274','1',1,'Retail Sale Id 1038',4501.20,0.00,0.00,6.05,496.10,'2022-06-17 11:03:15','',''),(1050,'1','274','1',1,'Retail Sale Id 1039',2232.00,0.00,0.00,3.00,246.00,'2022-06-17 11:05:47','',''),(1051,'1','274','1',1,'Retail Sale Id 1040',4501.20,0.00,0.00,6.05,496.10,'2022-06-17 11:09:38','',''),(1052,'1','274','1',1,'Retail Sale Id 1041',16368.00,0.00,0.00,22.00,1804.00,'2022-06-17 11:26:43','',''),(1053,'1','274','1',1,'Retail Sale Id 1042',2499.84,0.00,0.00,3.36,275.52,'2022-06-17 11:37:06','',''),(1054,'1','274','1',1,'Retail Sale Id 1043',9300.00,0.00,0.00,12.50,1025.00,'2022-06-17 11:37:59','',''),(1055,'1','274','1',1,'Retail Sale Id 1044',4002.72,0.00,0.00,5.38,441.16,'2022-06-17 11:39:11','',''),(1056,'1','274','1',1,'Retail Sale Id 1045',9300.00,0.00,0.00,12.50,1025.00,'2022-06-17 12:12:05','',''),(1057,'1','274','1',1,'Retail Sale Id 1046',18600.00,0.00,0.00,25.00,2050.00,'2022-06-17 12:45:00','',''),(1058,'1','274','1',1,'Retail Sale Id 1047',2998.32,0.00,0.00,4.03,330.46,'2022-06-17 12:52:23','',''),(1059,'1','274','1',1,'Retail Sale Id 1048',2001.36,0.00,0.00,2.69,220.58,'2022-06-17 13:06:30','',''),(1060,'1','274','1',1,'Retail Sale Id 1049',9300.00,0.00,0.00,12.50,1025.00,'2022-06-17 13:28:10','',''),(1061,'1','274','1',1,'Retail Sale Id 1050',4002.72,0.00,0.00,5.38,441.16,'2022-06-17 13:30:33','',''),(1062,'1','274','1',1,'Retail Sale Id 1051',5996.64,0.00,0.00,8.06,660.92,'2022-06-17 14:02:18','',''),(1063,'1','274','1',1,'Retail Sale Id 1052',9300.00,0.00,0.00,12.50,1025.00,'2022-06-17 14:09:15','',''),(1064,'1','274','1',1,'Retail Sale Id 1053',74400.00,0.00,0.00,100.00,8200.00,'2022-06-17 14:36:04','',''),(1065,'1','274','1',1,'Retail Sale Id 1054',99696.00,0.00,0.00,134.00,10988.00,'2022-06-17 14:37:09','',''),(1066,'1','274','1',1,'Retail Sale Id 1055',9300.00,0.00,0.00,12.50,1025.00,'2022-06-17 14:43:14','',''),(1067,'1','274','1',1,'Return of Retail Sale Id 1053',0.00,74400.00,100.00,0.00,-8200.00,'2022-06-17 15:03:14','',''),(1068,'1','274','1',1,'Retail Sale Id 1056',74400.00,0.00,0.00,100.00,8200.00,'2022-06-17 15:03:50','',''),(1069,'1','274','1',1,'Retail Sale Id 1057',4002.72,0.00,0.00,5.38,441.16,'2022-06-17 15:10:22','',''),(1070,'1','274','1',1,'Retail Sale Id 1058',1800.48,0.00,0.00,2.42,198.44,'2022-06-17 15:52:41','',''),(1071,'1','274','1',1,'Retail Sale Id 1059',13020.00,0.00,0.00,17.50,1435.00,'2022-06-17 16:30:05','',''),(1072,'1','274','1',1,'Retail Sale Id 1060',4501.20,0.00,0.00,6.05,496.10,'2022-06-17 16:31:45','',''),(1073,'1','274','1',1,'Retail Sale Id 1061',9300.00,0.00,0.00,12.50,1025.00,'2022-06-17 16:46:38','',''),(1074,'1','274','1',1,'Retail Sale Id 1065',3496.80,0.00,0.00,4.70,385.40,'2022-06-17 17:53:06','',''),(1075,'1','274','1',1,'Retail Sale Id 1068',4501.20,0.00,0.00,6.05,496.10,'2022-06-17 17:54:42','',''),(1076,'1','274','1',1,'Retail Sale Id 1071',2998.32,0.00,0.00,4.03,330.46,'2022-06-17 17:58:35','',''),(1077,'1','274','1',1,'Retail Sale Id 1072',74400.00,0.00,0.00,100.00,8200.00,'2022-06-17 18:01:47','',''),(1078,'1','274','1',1,'Retail Sale Id 1073',2998.32,0.00,0.00,4.03,330.46,'2022-06-17 18:11:50','',''),(1079,'1','274','1',1,'Retail Sale Id 1074',9300.00,0.00,0.00,12.50,1025.00,'2022-06-17 18:14:58','',''),(1080,'1','274','1',1,'Retail Sale Id 1076',13020.00,0.00,0.00,17.50,1435.00,'2022-06-17 18:17:35','',''),(1081,'1','274','1',1,'Retail Sale Id 1077',19344.00,0.00,0.00,26.00,2132.00,'2022-06-17 18:37:34','',''),(1082,'1','274','1',1,'Retail Sale Id 1078',4501.20,0.00,0.00,6.05,496.10,'2022-06-17 18:45:14','',''),(1083,'1','274','1',1,'Retail Sale Id 1079',996.96,0.00,0.00,1.34,109.88,'2022-06-17 18:53:31','',''),(1084,'1','274','1',1,'Retail Sale Id 1080',9300.00,0.00,0.00,12.50,1025.00,'2022-06-17 18:56:41','',''),(1085,'1','274','1',1,'Retail Sale Id 1081',996.96,0.00,0.00,1.34,109.88,'2022-06-17 18:57:54','',''),(1086,'1','274','1',1,'Retail Sale Id 1082',3749.76,0.00,0.00,5.04,413.28,'2022-06-17 18:58:53','',''),(1087,'1','274','1',1,'Retail Sale Id 1083',44640.00,0.00,0.00,60.00,4920.00,'2022-06-17 19:00:34','',''),(1088,'1','274','1',1,'Retail Sale Id 1084',64244.40,0.00,0.00,86.35,7080.70,'2022-06-17 19:20:13','',''),(1089,'1','274','1',1,'Retail Sale Id 1084',161596.80,0.00,0.00,217.20,17810.40,'2022-06-17 19:20:13','',''),(1090,'1','274','1',1,'Retail Sale Id 1085',9300.00,0.00,0.00,12.50,1025.00,'2022-06-18 08:41:16','',''),(1091,'1','274','1',1,'Retail Sale Id 1086',9300.00,0.00,0.00,12.50,1025.00,'2022-06-18 08:42:35','',''),(1092,'1','274','1',1,'Retail Sale Id 1087',4501.20,0.00,0.00,6.05,496.10,'2022-06-18 08:43:29','',''),(1093,'1','274','1',1,'Retail Sale Id 1088',1800.48,0.00,0.00,2.42,198.44,'2022-06-18 08:44:20','',''),(1094,'1','274','1',1,'Retail Sale Id 1089',2998.32,0.00,0.00,4.03,330.46,'2022-06-18 08:46:37','',''),(1095,'1','274','1',1,'Retail Sale Id 1090',4501.20,0.00,0.00,6.05,496.10,'2022-06-18 08:49:03','',''),(1096,'1','274','1',1,'Retail Sale Id 1091',8250.96,0.00,0.00,11.09,909.38,'2022-06-18 08:51:19','',''),(1097,'1','274','1',1,'Retail Sale Id 1092',13020.00,0.00,0.00,17.50,1435.00,'2022-06-18 09:07:35','',''),(1098,'1','274','1',1,'Retail Sale Id 1093',4501.20,0.00,0.00,6.05,496.10,'2022-06-18 09:57:18','',''),(1099,'1','274','1',1,'Retail Sale Id 1094',1897.20,0.00,0.00,2.55,209.10,'2022-06-18 10:07:21','',''),(1100,'1','274','1',1,'Retail Sale Id 1095',1502.88,0.00,0.00,2.02,165.64,'2022-06-18 10:15:21','',''),(1101,'1','274','1',1,'Retail Sale Id 1096',32364.00,0.00,0.00,43.50,3567.00,'2022-06-18 10:19:25','',''),(1102,'1','274','1',1,'Retail Sale Id 1097',699.36,0.00,0.00,0.94,77.08,'2022-06-18 10:23:48','',''),(1103,'1','274','1',1,'Retail Sale Id 1098',5498.16,0.00,0.00,7.39,605.98,'2022-06-18 10:28:59','',''),(1104,'1','274','1',1,'Retail Sale Id 1099',3749.76,0.00,0.00,5.04,413.28,'2022-06-18 10:31:33','',''),(1105,'1','274','1',1,'Retail Sale Id 1100',16368.00,0.00,0.00,22.00,1804.00,'2022-06-18 10:32:54','',''),(1106,'1','274','1',1,'Retail Sale Id 1101',4002.72,0.00,0.00,5.38,441.16,'2022-06-18 10:53:16','',''),(1107,'1','274','1',1,'Retail Sale Id 1102',2298.96,0.00,0.00,3.09,253.38,'2022-06-18 10:54:25','',''),(1108,'1','274','1',1,'Retail Sale Id 1103',9300.00,0.00,0.00,12.50,1025.00,'2022-06-18 11:21:53','',''),(1109,'1','274','1',1,'Retail Sale Id 1104',2246.88,0.00,0.00,3.02,247.64,'2022-06-18 11:25:10','',''),(1110,'1','274','1',1,'Retail Sale Id 1105',20832.00,0.00,0.00,28.00,2296.00,'2022-06-18 11:32:22','',''),(1111,'1','274','1',1,'Retail Sale Id 1106',31992.00,0.00,0.00,43.00,3526.00,'2022-06-18 11:44:38','',''),(1112,'1','274','1',1,'Retail Sale Id 1107',2499.84,0.00,0.00,3.36,275.52,'2022-06-18 11:46:58','',''),(1113,'1','274','1',1,'Retail Sale Id 1108',5996.64,0.00,0.00,8.06,660.92,'2022-06-18 11:53:28','',''),(1114,'1','274','1',1,'Retail Sale Id 1109',2998.32,0.00,0.00,4.03,330.46,'2022-06-18 12:00:39','',''),(1115,'1','274','1',1,'Retail Sale Id 1110',2976.00,0.00,0.00,4.00,328.00,'2022-06-18 12:06:40','',''),(1116,'1','274','1',1,'Retail Sale Id 1111',996.96,0.00,0.00,1.34,109.88,'2022-06-18 12:07:44','',''),(1117,'1','274','1',1,'Retail Sale Id 1112',4999.68,0.00,0.00,6.72,551.04,'2022-06-18 12:13:54','',''),(1118,'1','274','1',1,'Retail Sale Id 1113',4501.20,0.00,0.00,6.05,496.10,'2022-06-18 12:15:01','',''),(1119,'1','274','1',1,'Retail Sale Id 1114',50964.00,0.00,0.00,68.50,5617.00,'2022-06-18 12:35:10','',''),(1120,'1','274','1',1,'Retail Sale Id 1115',2232.00,0.00,0.00,3.00,246.00,'2022-06-18 12:48:37','',''),(1121,'1','274','1',1,'Retail Sale Id 1116',4501.20,0.00,0.00,6.05,496.10,'2022-06-18 12:52:02','',''),(1122,'1','274','1',1,'Retail Sale Id 1117',9300.00,0.00,0.00,12.50,1025.00,'2022-06-18 12:53:50','',''),(1123,'1','274','1',1,'Retail Sale Id 1118',9300.00,0.00,0.00,12.50,1025.00,'2022-06-18 13:17:33','',''),(1124,'1','274','1',1,'Retail Sale Id 1119',9300.00,0.00,0.00,12.50,1025.00,'2022-06-18 13:20:29','',''),(1125,'1','274','1',1,'Retail Sale Id 1120',996.96,0.00,0.00,1.34,109.88,'2022-06-18 13:21:44','',''),(1126,'1','274','1',1,'Retail Sale Id 1121',1502.88,0.00,0.00,2.02,165.64,'2022-06-18 13:31:25','',''),(1127,'1','274','1',1,'Retail Sale Id 1122',2001.36,0.00,0.00,2.69,220.58,'2022-06-18 13:32:43','',''),(1128,'1','274','1',1,'Retail Sale Id 1123',3749.76,0.00,0.00,5.04,413.28,'2022-06-18 13:38:52','',''),(1129,'1','274','1',1,'Retail Sale Id 1124',9300.00,0.00,0.00,12.50,1025.00,'2022-06-18 13:45:42','',''),(1130,'1','274','1',1,'Retail Sale Id 1125',9300.00,0.00,0.00,12.50,1025.00,'2022-06-18 13:51:29','',''),(1131,'1','274','1',1,'Retail Sale Id 1126',3749.76,0.00,0.00,5.04,413.28,'2022-06-18 13:53:02','',''),(1132,'1','274','1',1,'Retail Sale Id 1127',2202.24,0.00,0.00,2.96,242.72,'2022-06-18 13:56:56','',''),(1133,'1','274','1',1,'Retail Sale Id 1128',3749.76,0.00,0.00,5.04,413.28,'2022-06-18 14:27:50','',''),(1134,'1','274','1',1,'Retail Sale Id 1129',9300.00,0.00,0.00,12.50,1025.00,'2022-06-18 15:00:17','',''),(1135,'1','274','1',1,'Retail Sale Id 1130',4501.20,0.00,0.00,6.05,496.10,'2022-06-18 15:02:19','',''),(1136,'1','274','1',1,'Retail Sale Id 1131',15296.64,0.00,0.00,20.56,1685.92,'2022-06-18 15:08:05','',''),(1137,'1','274','1',1,'Retail Sale Id 1132',18600.00,0.00,0.00,25.00,2050.00,'2022-06-18 15:12:36','',''),(1138,'1','274','1',1,'Retail Sale Id 1133',4501.20,0.00,0.00,6.05,496.10,'2022-06-18 15:14:29','',''),(1139,'1','274','1',1,'Retail Sale Id 1134',2976.00,0.00,0.00,4.00,328.00,'2022-06-18 15:19:05','',''),(1140,'1','274','1',1,'Retail Sale Id 1135',2998.32,0.00,0.00,4.03,330.46,'2022-06-18 15:23:01','',''),(1141,'1','274','1',1,'Retail Sale Id 1136',74400.00,0.00,0.00,100.00,8200.00,'2022-06-18 16:52:09','',''),(1142,'1','274','1',1,'Retail Sale Id 1137',9300.00,0.00,0.00,12.50,1025.00,'2022-06-18 16:52:44','',''),(1143,'1','274','1',1,'Retail Sale Id 1138',9300.00,0.00,0.00,12.50,1025.00,'2022-06-18 16:53:31','',''),(1144,'1','274','1',1,'Retail Sale Id 1139',14002.08,0.00,0.00,18.82,1543.24,'2022-06-18 16:54:47','',''),(1145,'1','274','1',1,'Retail Sale Id 1140',1502.88,0.00,0.00,2.02,165.64,'2022-06-18 17:02:47','',''),(1146,'1','274','1',1,'Retail Sale Id 1141',14880.00,0.00,0.00,20.00,1640.00,'2022-06-18 17:03:50','',''),(1147,'1','274','1',1,'Retail Sale Id 1142',4002.72,0.00,0.00,5.38,441.16,'2022-06-18 17:04:41','',''),(1148,'1','274','1',1,'Retail Sale Id 1143',3496.80,0.00,0.00,4.70,385.40,'2022-06-18 17:06:51','',''),(1149,'1','274','1',1,'Retail Sale Id 1144',1502.88,0.00,0.00,2.02,165.64,'2022-06-18 17:09:36','',''),(1150,'1','274','1',1,'Retail Sale Id 1145',2001.36,0.00,0.00,2.69,220.58,'2022-06-18 17:10:27','',''),(1151,'1','274','1',1,'Retail Sale Id 1146',9300.00,0.00,0.00,12.50,1025.00,'2022-06-18 17:12:55','',''),(1152,'1','274','1',1,'Retail Sale Id 1147',996.96,0.00,0.00,1.34,109.88,'2022-06-18 17:18:45','',''),(1153,'1','274','1',1,'Retail Sale Id 1148',4501.20,0.00,0.00,6.05,496.10,'2022-06-18 17:21:47','',''),(1154,'1','274','1',1,'Retail Sale Id 1149',9300.00,0.00,0.00,12.50,1025.00,'2022-06-18 17:26:09','',''),(1155,'1','274','1',1,'Retail Sale Id 1150',2246.88,0.00,0.00,3.02,247.64,'2022-06-18 17:27:39','',''),(1156,'1','274','1',1,'Retail Sale Id 1151',2246.88,0.00,0.00,3.02,247.64,'2022-06-18 17:34:17','',''),(1157,'1','274','1',1,'Retail Sale Id 1152',1502.88,0.00,0.00,2.02,165.64,'2022-06-18 17:35:24','',''),(1158,'1','274','1',1,'Retail Sale Id 1153',44640.00,0.00,0.00,60.00,4920.00,'2022-06-18 17:37:18','',''),(1159,'1','274','1',1,'Retail Sale Id 1154',2998.32,0.00,0.00,4.03,330.46,'2022-06-18 17:39:49','',''),(1160,'1','274','1',1,'Retail Sale Id 1155',4501.20,0.00,0.00,6.05,496.10,'2022-06-18 17:41:16','',''),(1161,'1','274','1',1,'Retail Sale Id 1156',26040.00,0.00,0.00,35.00,2870.00,'2022-06-18 17:54:16','',''),(1162,'1','274','1',1,'Retail Sale Id 1157',4501.20,0.00,0.00,6.05,496.10,'2022-06-18 18:03:20','',''),(1163,'1','274','1',1,'Retail Sale Id 1158',1502.88,0.00,0.00,2.02,165.64,'2022-06-18 18:05:04','',''),(1164,'1','274','1',1,'Retail Sale Id 1159',9300.00,0.00,0.00,12.50,1025.00,'2022-06-18 18:14:35','',''),(1165,'1','274','1',1,'Retail Sale Id 1160',14880.00,0.00,0.00,20.00,1640.00,'2022-06-18 18:28:02','',''),(1166,'1','274','1',1,'Retail Sale Id 1161',4501.20,0.00,0.00,6.05,496.10,'2022-06-18 18:31:30','',''),(1167,'1','274','1',1,'Retail Sale Id 1162',4501.20,0.00,0.00,6.05,496.10,'2022-06-18 18:43:50','',''),(1168,'1','274','1',1,'Return of Retail Sale Id 1153',0.00,44640.00,60.00,0.00,-4920.00,'2022-06-18 19:27:52','',''),(1169,'1','274','1',1,'Retail Sale Id 1163',20028.48,0.00,0.00,26.92,2207.44,'2022-06-18 19:31:25','',''),(1170,'1','274','1',1,'Retail Sale Id 1163',101042.64,0.00,0.00,135.81,11136.42,'2022-06-18 19:31:25','',''),(1171,'1','274','1',1,'Retail Sale Id 1164',9300.00,0.00,0.00,12.50,1025.00,'2022-06-19 08:33:51','',''),(1172,'1','274','1',1,'Retail Sale Id 1165',2001.36,0.00,0.00,2.69,220.58,'2022-06-19 08:36:13','',''),(1173,'1','274','1',1,'Retail Sale Id 1166',803.52,0.00,0.00,1.08,88.56,'2022-06-19 08:49:00','',''),(1174,'1','274','1',1,'Retail Sale Id 1167',2246.88,0.00,0.00,3.02,247.64,'2022-06-19 08:50:56','',''),(1175,'1','274','1',1,'Retail Sale Id 1168',44640.00,0.00,0.00,60.00,4920.00,'2022-06-19 09:01:08','',''),(1176,'1','274','1',1,'Retail Sale Id 1169',2246.88,0.00,0.00,3.02,247.64,'2022-06-19 09:18:26','',''),(1177,'1','274','1',1,'Retail Sale Id 1170',9300.00,0.00,0.00,12.50,1025.00,'2022-06-19 09:31:58','',''),(1178,'1','274','1',1,'Retail Sale Id 1171',2246.88,0.00,0.00,3.02,247.64,'2022-06-19 09:42:09','',''),(1179,'1','274','1',1,'Retail Sale Id 1172',1502.88,0.00,0.00,2.02,165.64,'2022-06-19 09:44:03','',''),(1180,'1','274','1',1,'Retail Sale Id 1173',2246.88,0.00,0.00,3.02,247.64,'2022-06-19 09:49:26','',''),(1181,'1','274','1',1,'Retail Sale Id 1174',4501.20,0.00,0.00,6.05,496.10,'2022-06-19 09:59:03','',''),(1182,'1','274','1',1,'Retail Sale Id 1175',1502.88,0.00,0.00,2.02,165.64,'2022-06-19 10:22:23','',''),(1183,'1','274','1',1,'Retail Sale Id 1176',2001.36,0.00,0.00,2.69,220.58,'2022-06-19 10:23:36','',''),(1184,'1','274','1',1,'Retail Sale Id 1177',11160.00,0.00,0.00,15.00,1230.00,'2022-06-19 10:24:25','',''),(1185,'1','274','1',1,'Retail Sale Id 1178',3749.76,0.00,0.00,5.04,413.28,'2022-06-19 10:42:56','',''),(1186,'1','274','1',1,'Retail Sale Id 1179',4501.20,0.00,0.00,6.05,496.10,'2022-06-19 10:45:00','',''),(1187,'1','274','1',1,'Retail Sale Id 1180',8928.00,0.00,0.00,12.00,984.00,'2022-06-19 10:46:53','',''),(1188,'1','274','1',1,'Retail Sale Id 1181',2232.00,0.00,0.00,3.00,246.00,'2022-06-19 10:48:26','',''),(1189,'1','274','1',1,'Retail Sale Id 1182',4501.20,0.00,0.00,6.05,496.10,'2022-06-19 10:49:35','',''),(1190,'1','274','1',1,'Retail Sale Id 1183',7998.00,0.00,0.00,10.75,881.50,'2022-06-19 10:59:03','',''),(1191,'1','274','1',1,'Retail Sale Id 1184',9300.00,0.00,0.00,12.50,1025.00,'2022-06-19 11:05:01','',''),(1192,'1','274','1',1,'Retail Sale Id 1185',9300.00,0.00,0.00,12.50,1025.00,'2022-06-19 11:06:58','',''),(1193,'1','274','1',1,'Retail Sale Id 1186',996.96,0.00,0.00,1.34,109.88,'2022-06-19 11:10:57','',''),(1194,'1','274','1',1,'Retail Sale Id 1187',18600.00,0.00,0.00,25.00,2050.00,'2022-06-19 11:22:51','',''),(1195,'1','274','1',1,'Retail Sale Id 1188',2001.36,0.00,0.00,2.69,220.58,'2022-06-19 11:32:28','',''),(1196,'1','274','1',1,'Retail Sale Id 1189',2001.36,0.00,0.00,2.69,220.58,'2022-06-19 11:35:13','',''),(1197,'1','274','1',1,'Retail Sale Id 1190',4501.20,0.00,0.00,6.05,496.10,'2022-06-19 11:40:01','',''),(1198,'1','274','1',1,'Retail Sale Id 1191',4501.20,0.00,0.00,6.05,496.10,'2022-06-19 11:41:14','',''),(1199,'1','274','1',1,'Retail Sale Id 1192',4501.20,0.00,0.00,6.05,496.10,'2022-06-19 11:42:51','',''),(1200,'1','274','1',1,'Retail Sale Id 1193',2001.36,0.00,0.00,2.69,220.58,'2022-06-19 11:53:27','',''),(1201,'1','274','1',1,'Retail Sale Id 1194',2499.84,0.00,0.00,3.36,275.52,'2022-06-19 11:55:37','',''),(1202,'1','274','1',1,'Retail Sale Id 1195',2298.96,0.00,0.00,3.09,253.38,'2022-06-19 11:59:34','',''),(1203,'1','274','1',1,'Retail Sale Id 1196',699.36,0.00,0.00,0.94,77.08,'2022-06-19 12:00:34','',''),(1204,'1','274','1',1,'Retail Sale Id 1197',13801.20,0.00,0.00,18.55,1521.10,'2022-06-19 12:02:04','',''),(1205,'1','274','1',1,'Retail Sale Id 1198',2001.36,0.00,0.00,2.69,220.58,'2022-06-19 12:03:08','',''),(1206,'1','274','1',1,'Retail Sale Id 1199',4501.20,0.00,0.00,6.05,496.10,'2022-06-19 12:05:04','',''),(1207,'1','274','1',1,'Retail Sale Id 1200',16368.00,0.00,0.00,22.00,1804.00,'2022-06-19 12:06:27','',''),(1208,'1','274','1',1,'Retail Sale Id 1201',9300.00,0.00,0.00,12.50,1025.00,'2022-06-19 12:08:03','',''),(1209,'1','274','1',1,'Retail Sale Id 1202',2246.88,0.00,0.00,3.02,247.64,'2022-06-19 12:10:01','',''),(1210,'1','274','1',1,'Retail Sale Id 1203',2700.72,0.00,0.00,3.63,297.66,'2022-06-19 12:11:09','',''),(1211,'1','274','1',1,'Retail Sale Id 1204',2001.36,0.00,0.00,2.69,220.58,'2022-06-19 12:20:38','',''),(1212,'1','274','1',1,'Retail Sale Id 1205',4464.00,0.00,0.00,6.00,492.00,'2022-06-19 12:22:35','',''),(1213,'1','274','1',1,'Retail Sale Id 1206',2001.36,0.00,0.00,2.69,220.58,'2022-06-19 12:24:45','',''),(1214,'1','274','1',1,'Retail Sale Id 1207',5580.00,0.00,0.00,7.50,615.00,'2022-06-19 12:25:48','',''),(1215,'1','274','1',1,'Retail Sale Id 1208',1502.88,0.00,0.00,2.02,165.64,'2022-06-19 12:27:32','',''),(1216,'1','274','1',1,'Retail Sale Id 1209',4999.68,0.00,0.00,6.72,551.04,'2022-06-19 12:34:12','',''),(1217,'1','274','1',1,'Retail Sale Id 1210',4501.20,0.00,0.00,6.05,496.10,'2022-06-19 12:50:31','',''),(1218,'1','274','1',1,'Retail Sale Id 1211',4501.20,0.00,0.00,6.05,496.10,'2022-06-19 12:51:26','',''),(1219,'1','274','1',1,'Retail Sale Id 1212',4501.20,0.00,0.00,6.05,496.10,'2022-06-19 12:57:31','',''),(1220,'1','274','1',1,'Retail Sale Id 1213',44640.00,0.00,0.00,60.00,4920.00,'2022-06-19 13:17:32','',''),(1221,'1','274','1',1,'Retail Sale Id 1214',9300.00,0.00,0.00,12.50,1025.00,'2022-06-19 13:30:14','',''),(1222,'1','274','1',1,'Retail Sale Id 1215',9300.00,0.00,0.00,12.50,1025.00,'2022-06-19 13:43:10','',''),(1223,'1','274','1',1,'Retail Sale Id 1216',3496.80,0.00,0.00,4.70,385.40,'2022-06-19 13:44:46','',''),(1224,'1','274','1',1,'Retail Sale Id 1217',4501.20,0.00,0.00,6.05,496.10,'2022-06-19 13:45:34','',''),(1225,'1','274','1',1,'Retail Sale Id 1218',9300.00,0.00,0.00,12.50,1025.00,'2022-06-19 14:03:14','',''),(1226,'1','274','1',1,'Retail Sale Id 1219',1502.88,0.00,0.00,2.02,165.64,'2022-06-19 14:09:06','',''),(1227,'1','274','1',1,'Retail Sale Id 1220',5996.64,0.00,0.00,8.06,660.92,'2022-06-19 14:16:36','',''),(1228,'1','274','1',1,'Retail Sale Id 1221',3749.76,0.00,0.00,5.04,413.28,'2022-06-19 14:17:50','',''),(1229,'1','274','1',1,'Retail Sale Id 1222',9300.00,0.00,0.00,12.50,1025.00,'2022-06-19 14:37:56','',''),(1230,'1','274','1',1,'Retail Sale Id 1223',9300.00,0.00,0.00,12.50,1025.00,'2022-06-19 14:39:13','',''),(1231,'1','274','1',1,'Retail Sale Id 1224',3749.76,0.00,0.00,5.04,413.28,'2022-06-19 15:17:03','',''),(1232,'1','274','1',1,'Retail Sale Id 1225',1502.88,0.00,0.00,2.02,165.64,'2022-06-19 15:41:38','',''),(1233,'1','274','1',1,'Retail Sale Id 1226',9300.00,0.00,0.00,12.50,1025.00,'2022-06-19 15:42:22','',''),(1234,'1','274','1',1,'Retail Sale Id 1227',4501.20,0.00,0.00,6.05,496.10,'2022-06-19 15:44:14','',''),(1235,'1','274','1',1,'Retail Sale Id 1228',7001.04,0.00,0.00,9.41,771.62,'2022-06-19 15:45:24','',''),(1236,'1','274','1',1,'Retail Sale Id 1229',2998.32,0.00,0.00,4.03,330.46,'2022-06-19 15:46:29','',''),(1237,'1','274','1',1,'Retail Sale Id 1230',4501.20,0.00,0.00,6.05,496.10,'2022-06-19 15:47:30','',''),(1238,'1','274','1',1,'Retail Sale Id 1231',9300.00,0.00,0.00,12.50,1025.00,'2022-06-19 15:53:28','',''),(1239,'1','274','1',1,'Retail Sale Id 1232',4501.20,0.00,0.00,6.05,496.10,'2022-06-19 15:54:42','',''),(1240,'1','274','1',1,'Retail Sale Id 1233',4501.20,0.00,0.00,6.05,496.10,'2022-06-19 15:58:08','',''),(1241,'1','274','1',1,'Retail Sale Id 1234',11532.00,0.00,0.00,15.50,1271.00,'2022-06-19 16:24:32','',''),(1242,'1','274','1',1,'Retail Sale Id 1235',4501.20,0.00,0.00,6.05,496.10,'2022-06-19 16:43:43','',''),(1243,'1','274','1',1,'Retail Sale Id 1236',2246.88,0.00,0.00,3.02,247.64,'2022-06-19 16:51:56','',''),(1244,'1','274','1',1,'Retail Sale Id 1237',2998.32,0.00,0.00,4.03,330.46,'2022-06-19 17:11:10','',''),(1245,'1','274','1',1,'Retail Sale Id 1238',1398.72,0.00,0.00,1.88,154.16,'2022-06-19 17:12:30','',''),(1246,'1','274','1',1,'Retail Sale Id 1239',1502.88,0.00,0.00,2.02,165.64,'2022-06-19 17:14:08','',''),(1247,'1','274','1',1,'Retail Sale Id 1240',2246.88,0.00,0.00,3.02,247.64,'2022-06-19 17:15:02','',''),(1248,'1','274','1',1,'Retail Sale Id 1241',2246.88,0.00,0.00,3.02,247.64,'2022-06-19 17:19:17','',''),(1249,'1','274','1',1,'Retail Sale Id 1242',4300.32,0.00,0.00,5.78,473.96,'2022-06-19 17:23:27','',''),(1250,'1','274','1',1,'Retail Sale Id 1243',9002.40,0.00,0.00,12.10,992.20,'2022-06-19 17:59:01','',''),(1251,'1','274','1',1,'Retail Sale Id 1244',4501.20,0.00,0.00,6.05,496.10,'2022-06-19 18:10:42','',''),(1252,'1','274','1',1,'Retail Sale Id 1245',1502.88,0.00,0.00,2.02,165.64,'2022-06-19 18:17:29','',''),(1253,'1','274','1',1,'Retail Sale Id 1246',2001.36,0.00,0.00,2.69,220.58,'2022-06-19 18:35:31','',''),(1254,'1','274','1',1,'Return of Retail Sale Id 1180',0.00,8928.00,12.00,0.00,-984.00,'2022-06-19 18:57:39','',''),(1255,'1','274','1',1,'Return of Retail Sale Id 1242',0.00,4300.32,5.78,0.00,-473.96,'2022-06-19 18:58:40','',''),(1256,'1','274','1',1,'Return of Retail Sale Id 1183',0.00,7998.00,10.75,0.00,-881.50,'2022-06-19 19:18:22','',''),(1257,'1','274','1',1,'Retail Sale Id 1247',28108.32,0.00,0.00,37.78,3097.96,'2022-06-19 19:21:20','',''),(1258,'1','274','1',1,'Retail Sale Id 1247',66550.80,0.00,0.00,89.45,7334.90,'2022-06-19 19:21:20','',''),(1259,'1','274','1',1,'Retail Sale Id 1248',10416.00,0.00,0.00,14.00,1148.00,'2022-06-20 07:35:12','',''),(1260,'1','274','1',1,'Retail Sale Id 1249',9300.00,0.00,0.00,12.50,1025.00,'2022-06-20 07:57:35','',''),(1261,'1','274','1',1,'Retail Sale Id 1250',9300.00,0.00,0.00,12.50,1025.00,'2022-06-20 08:01:29','',''),(1262,'1','274','1',1,'Retail Sale Id 1251',2998.32,0.00,0.00,4.03,330.46,'2022-06-20 08:10:52','',''),(1263,'1','274','1',1,'Retail Sale Id 1252',2998.32,0.00,0.00,4.03,330.46,'2022-06-20 08:14:15','',''),(1264,'1','274','1',1,'Retail Sale Id 1253',4002.72,0.00,0.00,5.38,441.16,'2022-06-20 08:21:08','',''),(1265,'1','274','1',1,'Retail Sale Id 1254',9300.00,0.00,0.00,12.50,1025.00,'2022-06-20 08:25:53','',''),(1266,'1','274','1',1,'Retail Sale Id 1255',9300.00,0.00,0.00,12.50,1025.00,'2022-06-20 08:30:53','',''),(1267,'1','274','1',1,'Retail Sale Id 1256',9300.00,0.00,0.00,12.50,1025.00,'2022-06-20 08:34:17','',''),(1268,'1','274','1',1,'Retail Sale Id 1257',4501.20,0.00,0.00,6.05,496.10,'2022-06-20 08:39:44','',''),(1269,'1','274','1',1,'Retail Sale Id 1258',7998.00,0.00,0.00,10.75,881.50,'2022-06-20 08:51:59','',''),(1270,'1','274','1',1,'Retail Sale Id 1259',2246.88,0.00,0.00,3.02,247.64,'2022-06-20 08:54:04','',''),(1271,'1','274','1',1,'Retail Sale Id 1259',4501.20,0.00,0.00,6.05,496.10,'2022-06-20 08:54:04','',''),(1272,'1','274','1',1,'Retail Sale Id 1260',996.96,0.00,0.00,1.34,109.88,'2022-06-20 09:02:29','',''),(1273,'1','274','1',1,'Retail Sale Id 1261',4002.72,0.00,0.00,5.38,441.16,'2022-06-20 09:06:38','',''),(1274,'1','274','1',1,'Retail Sale Id 1262',996.96,0.00,0.00,1.34,109.88,'2022-06-20 09:40:46','',''),(1275,'1','274','1',1,'Retail Sale Id 1263',996.96,0.00,0.00,1.34,109.88,'2022-06-20 09:41:37','',''),(1276,'1','274','1',1,'Retail Sale Id 1264',4501.20,0.00,0.00,6.05,496.10,'2022-06-20 09:46:50','',''),(1277,'1','274','1',1,'Retail Sale Id 1265',2001.36,0.00,0.00,2.69,220.58,'2022-06-20 09:48:37','',''),(1278,'1','274','1',1,'Retail Sale Id 1266',9300.00,0.00,0.00,12.50,1025.00,'2022-06-20 10:24:47','',''),(1279,'1','274','1',1,'Retail Sale Id 1267',8198.88,0.00,0.00,11.02,903.64,'2022-06-20 10:39:36','',''),(1280,'1','274','1',1,'Retail Sale Id 1268',2246.88,0.00,0.00,3.02,247.64,'2022-06-20 10:48:40','',''),(1281,'1','274','1',1,'Retail Sale Id 1269',81840.00,0.00,0.00,110.00,9020.00,'2022-06-20 11:01:46','',''),(1282,'1','274','1',1,'Retail Sale Id 1270',3615.84,0.00,0.00,4.86,398.52,'2022-06-20 11:38:04','',''),(1283,'1','274','1',1,'Retail Sale Id 1270',11799.84,0.00,0.00,15.86,1300.52,'2022-06-20 11:38:04','',''),(1284,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,662000.00,1000.00,0.00,0.00,'2022-06-20 12:54:06','',''),(1285,'1','274',NULL,1,'Reception corrector for bridging 9',0.00,0.00,0.00,1000.00,0.00,'2022-06-20 12:55:11','',''),(1286,'1','274','1',1,'Received from bridging 9',0.00,0.00,1000.00,0.00,0.00,'2022-06-20 12:55:11','',''),(1287,'1','274','1',1,'Retail Sale Id 1271',9300.00,0.00,0.00,12.50,1025.00,'2022-06-20 13:24:49','',''),(1288,'1','274','1',1,'Retail Sale Id 1272',2246.88,0.00,0.00,3.02,247.64,'2022-06-20 13:27:53','',''),(1289,'1','274','1',1,'Retail Sale Id 1273',2001.36,0.00,0.00,2.69,220.58,'2022-06-20 13:28:55','',''),(1290,'1','274','1',1,'Retail Sale Id 1274',3749.76,0.00,0.00,5.04,413.28,'2022-06-20 13:29:38','',''),(1291,'1','274','1',1,'Retail Sale Id 1275',2246.88,0.00,0.00,3.02,247.64,'2022-06-20 13:32:11','',''),(1292,'1','274','1',1,'Retail Sale Id 1276',2001.36,0.00,0.00,2.69,220.58,'2022-06-20 13:35:53','',''),(1293,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,2568560.00,3880.00,0.00,0.00,'2022-06-20 13:55:38','',''),(1294,'1','274',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,3880.00,0.00,'2022-06-20 13:56:54','',''),(1295,'1','274','1',1,'Received from bridging 10',0.00,0.00,3880.00,0.00,0.00,'2022-06-20 13:56:54','',''),(1296,'1','274','1',1,'Retail Sale Id 1277',2998.32,0.00,0.00,4.03,330.46,'2022-06-20 14:04:14','',''),(1297,'1','274','1',1,'Retail Sale Id 1278',10296.96,0.00,0.00,13.84,1134.88,'2022-06-20 15:06:36','',''),(1298,'1','274','1',1,'Retail Sale Id 1279',9300.00,0.00,0.00,12.50,1025.00,'2022-06-20 15:28:10','',''),(1299,'1','274','1',1,'Retail Sale Id 1280',2998.32,0.00,0.00,4.03,330.46,'2022-06-20 15:35:28','',''),(1300,'1','274','1',1,'Retail Sale Id 1281',4501.20,0.00,0.00,6.05,496.10,'2022-06-20 15:46:03','',''),(1301,'1','274','1',1,'Retail Sale Id 1282',2499.84,0.00,0.00,3.36,275.52,'2022-06-20 15:49:22','',''),(1302,'1','274','1',1,'Retail Sale Id 1283',3496.80,0.00,0.00,4.70,385.40,'2022-06-20 15:52:54','',''),(1303,'1','274','1',1,'Retail Sale Id 1284',9300.00,0.00,0.00,12.50,1025.00,'2022-06-20 15:54:19','',''),(1304,'1','274','1',1,'Retail Sale Id 1285',9300.00,0.00,0.00,12.50,1025.00,'2022-06-20 16:20:38','',''),(1305,'1','274','1',1,'Retail Sale Id 1286',4501.20,0.00,0.00,6.05,496.10,'2022-06-20 16:25:34','',''),(1306,'1','274','1',1,'Retail Sale Id 1287',2998.32,0.00,0.00,4.03,330.46,'2022-06-20 16:27:29','',''),(1307,'1','274','1',1,'Retail Sale Id 1289',1502.88,0.00,0.00,2.02,165.64,'2022-06-20 16:35:26','',''),(1308,'1','274','1',1,'Retail Sale Id 1290',996.96,0.00,0.00,1.34,109.88,'2022-06-20 16:50:48','',''),(1309,'1','274','1',1,'Retail Sale Id 1291',7998.00,0.00,0.00,10.75,881.50,'2022-06-20 16:54:04','',''),(1310,'1','274','1',1,'Retail Sale Id 1292',2246.88,0.00,0.00,3.02,247.64,'2022-06-20 16:56:16','',''),(1311,'1','274','1',1,'Retail Sale Id 1293',2246.88,0.00,0.00,3.02,247.64,'2022-06-20 17:14:16','',''),(1312,'1','274','1',1,'Retail Sale Id 1294',1502.88,0.00,0.00,2.02,165.64,'2022-06-20 17:15:51','',''),(1313,'1','274','1',1,'Retail Sale Id 1295',2001.36,0.00,0.00,2.69,220.58,'2022-06-20 17:45:03','',''),(1314,'1','274','1',1,'Retail Sale Id 1296',9672.00,0.00,0.00,13.00,1066.00,'2022-06-20 17:55:28','',''),(1315,'1','274','1',1,'Retail Sale Id 1297',1502.88,0.00,0.00,2.02,165.64,'2022-06-20 17:58:37','',''),(1316,'1','274','1',1,'Retail Sale Id 1298',2001.36,0.00,0.00,2.69,220.58,'2022-06-20 18:08:20','',''),(1317,'1','274','1',1,'Return of Retail Sale Id 1296',0.00,9672.00,13.00,0.00,-1066.00,'2022-06-20 18:51:08','',''),(1318,'1','274','1',1,'Retail Sale Id 1299',550.56,0.00,0.00,0.74,60.68,'2022-06-20 18:53:59','',''),(1319,'1','274','1',1,'Retail Sale Id 1299',18555.36,0.00,0.00,24.94,2045.08,'2022-06-20 18:53:59','',''),(1320,'1','274','1',1,'Retail Sale Id 1300',2998.32,0.00,0.00,4.03,330.46,'2022-06-21 07:05:18','',''),(1321,'1','274','1',1,'Retail Sale Id 1301',498.48,0.00,0.00,0.67,54.94,'2022-06-21 07:06:39','',''),(1322,'1','274','1',1,'Retail Sale Id 1302',4999.68,0.00,0.00,6.72,551.04,'2022-06-21 07:07:46','',''),(1323,'1','274','1',1,'Retail Sale Id 1303',9300.00,0.00,0.00,12.50,1025.00,'2022-06-21 08:11:19','',''),(1324,'1','274','1',1,'Retail Sale Id 1304',3720.00,0.00,0.00,5.00,410.00,'2022-06-21 08:12:17','',''),(1325,'1','274','1',1,'Retail Sale Id 1305',9300.00,0.00,0.00,12.50,1025.00,'2022-06-21 08:32:36','',''),(1326,'1','274','1',1,'Retail Sale Id 1306',996.96,0.00,0.00,1.34,109.88,'2022-06-21 08:50:45','',''),(1327,'1','274','1',1,'Retail Sale Id 1307',9300.00,0.00,0.00,12.50,1025.00,'2022-06-21 09:05:12','',''),(1328,'1','274','1',1,'Retail Sale Id 1308',4501.20,0.00,0.00,6.05,496.10,'2022-06-21 09:09:46','',''),(1329,'1','274','1',1,'Retail Sale Id 1309',996.96,0.00,0.00,1.34,109.88,'2022-06-21 09:14:11','',''),(1330,'1','274','1',1,'Retail Sale Id 1310',3697.68,0.00,0.00,4.97,407.54,'2022-06-21 09:23:43','',''),(1331,'1','274','1',1,'Retail Sale Id 1311',4501.20,0.00,0.00,6.05,496.10,'2022-06-21 09:26:26','',''),(1332,'1','274','1',1,'Retail Sale Id 1312',2246.88,0.00,0.00,3.02,247.64,'2022-06-21 10:03:02','',''),(1333,'1','274','1',1,'Retail Sale Id 1313',9300.00,0.00,0.00,12.50,1025.00,'2022-06-21 10:03:57','',''),(1334,'1','274','1',1,'Retail Sale Id 1314',9300.00,0.00,0.00,12.50,1025.00,'2022-06-21 10:06:21','',''),(1335,'1','274','1',1,'Retail Sale Id 1315',996.96,0.00,0.00,1.34,109.88,'2022-06-21 10:27:02','',''),(1336,'1','274','1',1,'Retail Sale Id 1316',3749.76,0.00,0.00,5.04,413.28,'2022-06-21 10:37:06','',''),(1337,'1','274','1',1,'Retail Sale Id 1317',9300.00,0.00,0.00,12.50,1025.00,'2022-06-21 10:41:07','',''),(1338,'1','274','1',1,'Retail Sale Id 1318',9300.00,0.00,0.00,12.50,1025.00,'2022-06-21 10:52:55','',''),(1339,'1','274','1',1,'Retail Sale Id 1319',9300.00,0.00,0.00,12.50,1025.00,'2022-06-21 11:06:42','',''),(1340,'1','274','1',1,'Retail Sale Id 1320',2246.88,0.00,0.00,3.02,247.64,'2022-06-21 11:07:30','',''),(1341,'1','274','1',1,'Retail Sale Id 1321',996.96,0.00,0.00,1.34,109.88,'2022-06-21 11:16:22','',''),(1342,'1','274','1',1,'Retail Sale Id 1322',699.36,0.00,0.00,0.94,77.08,'2022-06-21 11:38:48','',''),(1343,'1','274','1',1,'Retail Sale Id 1323',7998.00,0.00,0.00,10.75,881.50,'2022-06-21 11:45:12','',''),(1344,'1','274','1',1,'Retail Sale Id 1324',9300.00,0.00,0.00,12.50,1025.00,'2022-06-21 11:56:36','',''),(1345,'1','274','1',1,'Retail Sale Id 1325',22320.00,0.00,0.00,30.00,2460.00,'2022-06-21 15:58:39','',''),(1346,'1','274','1',1,'Retail Sale Id 1326',9300.00,0.00,0.00,12.50,1025.00,'2022-06-21 16:28:30','',''),(1347,'1','274','1',1,'Retail Sale Id 1327',2232.00,0.00,0.00,3.00,246.00,'2022-06-21 16:31:22','',''),(1348,'1','274','1',1,'Retail Sale Id 1328',2001.36,0.00,0.00,2.69,220.58,'2022-06-21 16:34:09','',''),(1349,'1','274','1',1,'Retail Sale Id 1329',5996.64,0.00,0.00,8.06,660.92,'2022-06-21 16:35:24','',''),(1350,'1','274','1',1,'Retail Sale Id 1330',2001.36,0.00,0.00,2.69,220.58,'2022-06-21 16:36:46','',''),(1351,'1','274','1',1,'Retail Sale Id 1331',9300.00,0.00,0.00,12.50,1025.00,'2022-06-21 16:37:47','',''),(1352,'1','274','1',1,'Retail Sale Id 1332',3749.76,0.00,0.00,5.04,413.28,'2022-06-21 16:39:30','',''),(1353,'1','274','1',1,'Retail Sale Id 1333',1502.88,0.00,0.00,2.02,165.64,'2022-06-21 16:45:35','',''),(1354,'1','274','1',1,'Retail Sale Id 1334',996.96,0.00,0.00,1.34,109.88,'2022-06-21 16:48:44','',''),(1355,'1','274','1',1,'Retail Sale Id 1335',4501.20,0.00,0.00,6.05,496.10,'2022-06-21 16:50:52','',''),(1356,'1','274','1',1,'Retail Sale Id 1336',4999.68,0.00,0.00,6.72,551.04,'2022-06-21 16:53:11','',''),(1357,'1','274','1',1,'Retail Sale Id 1337',2246.88,0.00,0.00,3.02,247.64,'2022-06-21 16:59:00','',''),(1358,'1','274','1',1,'Retail Sale Id 1338',2998.32,0.00,0.00,4.03,330.46,'2022-06-21 17:00:35','',''),(1359,'1','274','1',1,'Retail Sale Id 1339',4501.20,0.00,0.00,6.05,496.10,'2022-06-21 17:01:43','',''),(1360,'1','274','1',1,'Retail Sale Id 1340',9300.00,0.00,0.00,12.50,1025.00,'2022-06-21 17:10:36','',''),(1361,'1','274','1',1,'Retail Sale Id 1341',5996.64,0.00,0.00,8.06,660.92,'2022-06-21 17:22:52','',''),(1362,'1','274','1',1,'Retail Sale Id 1342',13801.20,0.00,0.00,18.55,1521.10,'2022-06-21 17:24:36','',''),(1363,'1','274','1',1,'Retail Sale Id 1343',1800.48,0.00,0.00,2.42,198.44,'2022-06-21 17:27:44','',''),(1364,'1','274','1',1,'Retail Sale Id 1344',37200.00,0.00,0.00,50.00,4100.00,'2022-06-21 17:30:07','',''),(1365,'1','274','1',1,'Retail Sale Id 1345',4501.20,0.00,0.00,6.05,496.10,'2022-06-21 17:52:39','',''),(1366,'1','274','1',1,'Retail Sale Id 1346',9999.36,0.00,0.00,13.44,1102.08,'2022-06-21 17:53:48','',''),(1367,'1','274','1',1,'Retail Sale Id 1347',4501.20,0.00,0.00,6.05,496.10,'2022-06-21 17:55:44','',''),(1368,'1','274','1',1,'Retail Sale Id 1348',9300.00,0.00,0.00,12.50,1025.00,'2022-06-21 17:57:58','',''),(1369,'1','274','1',1,'Retail Sale Id 1349',2001.36,0.00,0.00,2.69,220.58,'2022-06-21 18:15:42','',''),(1370,'1','274','1',1,'Retail Sale Id 1350',3749.76,0.00,0.00,5.04,413.28,'2022-06-21 18:24:46','',''),(1371,'1','274','1',1,'Retail Sale Id 1351',2001.36,0.00,0.00,2.69,220.58,'2022-06-21 18:26:44','',''),(1372,'1','274','1',1,'Retail Sale Id 1352',5996.64,0.00,0.00,8.06,660.92,'2022-06-21 18:27:48','',''),(1373,'1','274','1',1,'Retail Sale Id 1353',9300.00,0.00,0.00,12.50,1025.00,'2022-06-21 18:33:34','',''),(1374,'1','274','1',1,'Retail Sale Id 1354',4397.04,0.00,0.00,5.91,484.62,'2022-06-21 18:38:30','',''),(1375,'1','274','1',1,'Retail Sale Id 1355',3496.80,0.00,0.00,4.70,385.40,'2022-06-21 18:46:34','',''),(1376,'1','274','1',1,'Retail Sale Id 1356',9300.00,0.00,0.00,12.50,1025.00,'2022-06-21 18:54:51','',''),(1377,'1','274','1',1,'Retail Sale Id 1357',66960.00,0.00,0.00,90.00,7380.00,'2022-06-21 18:56:54','',''),(1378,'1','274','1',1,'Retail Sale Id 1358',31992.00,0.00,0.00,43.00,3526.00,'2022-06-21 18:58:35','',''),(1379,'1','274','1',1,'Retail Sale Id 1359',45398.88,0.00,0.00,61.02,5003.64,'2022-06-21 19:08:01','',''),(1380,'1','274','1',1,'Return of Retail Sale Id 1359',0.00,45398.88,61.02,0.00,-5003.64,'2022-06-21 19:08:44','',''),(1381,'1','274','1',1,'Retail Sale Id 1361',4501.20,0.00,0.00,6.05,496.10,'2022-06-21 19:10:12','',''),(1382,'1','274','1',1,'Retail Sale Id 1362',83759.52,0.00,0.00,112.58,9231.56,'2022-06-21 20:26:57','',''),(1383,'1','274','1',1,'Retail Sale Id 1362',156262.32,0.00,0.00,210.03,17222.46,'2022-06-21 20:26:57','',''),(1384,'1','274','1',1,'Retail Sale Id 1363',1502.88,0.00,0.00,2.02,165.64,'2022-06-22 07:21:26','',''),(1385,'1','274','1',1,'Retail Sale Id 1364',9300.00,0.00,0.00,12.50,1025.00,'2022-06-22 08:03:56','',''),(1386,'1','274','1',1,'Retail Sale Id 1365',9300.00,0.00,0.00,12.50,1025.00,'2022-06-22 08:09:00','',''),(1387,'1','274','1',1,'Retail Sale Id 1366',2998.32,0.00,0.00,4.03,330.46,'2022-06-22 08:10:35','',''),(1388,'1','274','1',1,'Retail Sale Id 1367',4999.68,0.00,0.00,6.72,551.04,'2022-06-22 08:25:46','',''),(1389,'1','274','1',1,'Retail Sale Id 1368',2499.84,0.00,0.00,3.36,275.52,'2022-06-22 08:28:09','',''),(1390,'1','274','1',1,'Retail Sale Id 1369',2998.32,0.00,0.00,4.03,330.46,'2022-06-22 09:14:31','',''),(1391,'1','274','1',1,'Retail Sale Id 1370',744.00,0.00,0.00,1.00,82.00,'2022-06-22 09:26:08','',''),(1392,'1','274','1',1,'Retail Sale Id 1372',10416.00,0.00,0.00,14.00,1148.00,'2022-06-22 09:27:20','',''),(1393,'1','274','1',1,'Retail Sale Id 1373',2499.84,0.00,0.00,3.36,275.52,'2022-06-22 09:33:07','',''),(1394,'1','274','1',1,'Retail Sale Id 1374',9300.00,0.00,0.00,12.50,1025.00,'2022-06-22 09:35:06','',''),(1395,'1','274','1',1,'Retail Sale Id 1375',996.96,0.00,0.00,1.34,109.88,'2022-06-22 09:46:33','',''),(1396,'1','274','1',1,'Retail Sale Id 1376',7001.04,0.00,0.00,9.41,771.62,'2022-06-22 10:05:59','',''),(1397,'1','274','1',1,'Retail Sale Id 1377',4501.20,0.00,0.00,6.05,496.10,'2022-06-22 10:39:33','',''),(1398,'1','274','1',1,'Retail Sale Id 1378',1502.88,0.00,0.00,2.02,165.64,'2022-06-22 10:51:26','',''),(1399,'1','274','1',1,'Retail Sale Id 1379',2246.88,0.00,0.00,3.02,247.64,'2022-06-22 11:02:26','',''),(1400,'1','274','1',1,'Retail Sale Id 1380',996.96,0.00,0.00,1.34,109.88,'2022-06-22 11:11:12','',''),(1401,'1','274','1',1,'Retail Sale Id 1381',4501.20,0.00,0.00,6.05,496.10,'2022-06-22 11:48:38','',''),(1402,'1','274','1',1,'Retail Sale Id 1383',4999.68,0.00,0.00,6.72,551.04,'2022-06-22 11:53:55','',''),(1403,'1','274','1',1,'Retail Sale Id 1384',1502.88,0.00,0.00,2.02,165.64,'2022-06-22 12:33:39','',''),(1404,'1','274','1',1,'Retail Sale Id 1385',81840.00,0.00,0.00,110.00,9020.00,'2022-06-22 12:47:04','',''),(1405,'1','274','1',1,'Retail Sale Id 1386',9300.00,0.00,0.00,12.50,1025.00,'2022-06-22 13:16:49','',''),(1406,'1','274','1',1,'Retail Sale Id 1387',9300.00,0.00,0.00,12.50,1025.00,'2022-06-22 13:19:04','',''),(1407,'1','274','1',1,'Retail Sale Id 1388',10996.32,0.00,0.00,14.78,1211.96,'2022-06-22 13:19:56','',''),(1408,'1','274','1',1,'Retail Sale Id 1389',4501.20,0.00,0.00,6.05,496.10,'2022-06-22 13:22:15','',''),(1409,'1','274','1',1,'Retail Sale Id 1390',9300.00,0.00,0.00,12.50,1025.00,'2022-06-22 13:24:02','',''),(1410,'1','274','1',1,'Retail Sale Id 1391',7998.00,0.00,0.00,10.75,881.50,'2022-06-22 13:25:57','',''),(1411,'1','274','1',1,'Retail Sale Id 1392',12298.32,0.00,0.00,16.53,1355.46,'2022-06-22 13:31:33','',''),(1412,'1','274','1',1,'Retail Sale Id 1393',4501.20,0.00,0.00,6.05,496.10,'2022-06-22 13:33:30','',''),(1413,'1','274','1',1,'Retail Sale Id 1394',803.52,0.00,0.00,1.08,88.56,'2022-06-22 13:34:41','',''),(1414,'1','274','1',1,'Retail Sale Id 1395',9300.00,0.00,0.00,12.50,1025.00,'2022-06-22 13:35:40','',''),(1415,'1','274','1',1,'Retail Sale Id 1396',2246.88,0.00,0.00,3.02,247.64,'2022-06-22 14:27:30','',''),(1416,'1','274','1',1,'Retail Sale Id 1397',3749.76,0.00,0.00,5.04,413.28,'2022-06-22 15:14:25','',''),(1417,'1','274','1',1,'Retail Sale Id 1398',2998.32,0.00,0.00,4.03,330.46,'2022-06-22 15:18:41','',''),(1418,'1','274','1',1,'Retail Sale Id 1399',9300.00,0.00,0.00,12.50,1025.00,'2022-06-22 15:40:35','',''),(1419,'1','274','1',1,'Retail Sale Id 1400',4501.20,0.00,0.00,6.05,496.10,'2022-06-22 15:44:21','',''),(1420,'1','274','1',1,'Retail Sale Id 1402',2998.32,0.00,0.00,4.03,330.46,'2022-06-22 16:25:36','',''),(1421,'1','274','1',1,'Retail Sale Id 1404',24180.00,0.00,0.00,32.50,2665.00,'2022-06-22 16:26:50','',''),(1422,'1','274','1',1,'Retail Sale Id 1405',29760.00,0.00,0.00,40.00,3280.00,'2022-06-22 16:31:09','',''),(1423,'1','274','1',1,'Retail Sale Id 1406',2001.36,0.00,0.00,2.69,220.58,'2022-06-22 16:50:03','',''),(1424,'1','274','1',1,'Retail Sale Id 1407',18600.00,0.00,0.00,25.00,2050.00,'2022-06-22 16:59:37','',''),(1425,'1','274','1',1,'Return of Retail Sale Id 1407',0.00,18600.00,25.00,0.00,-2050.00,'2022-06-22 17:50:24','',''),(1426,'1','274','1',1,'Return of Retail Sale Id 1405',0.00,29760.00,40.00,0.00,-3280.00,'2022-06-22 17:51:29','',''),(1427,'1','274','1',1,'Retail Sale Id 1408',14277.36,0.00,0.00,19.19,1573.58,'2022-06-22 17:54:32','',''),(1428,'1','274','1',1,'Retail Sale Id 1408',39744.48,0.00,0.00,53.42,4380.44,'2022-06-22 17:54:32','',''),(1429,'1','274','1',1,'Retail Sale Id 1409',2976.00,0.00,0.00,4.00,328.00,'2022-06-23 08:20:25','',''),(1430,'1','274','1',1,'Retail Sale Id 1410',8124.48,0.00,0.00,10.92,895.44,'2022-06-23 08:21:34','',''),(1431,'1','274','1',1,'Retail Sale Id 1411',9300.00,0.00,0.00,12.50,1025.00,'2022-06-23 08:26:08','',''),(1432,'1','274','1',1,'Retail Sale Id 1412',37200.00,0.00,0.00,50.00,4100.00,'2022-06-23 08:33:29','',''),(1433,'1','274','1',1,'Retail Sale Id 1413',3749.76,0.00,0.00,5.04,413.28,'2022-06-23 08:44:08','',''),(1434,'1','274','1',1,'Retail Sale Id 1414',2998.32,0.00,0.00,4.03,330.46,'2022-06-23 08:48:41','',''),(1435,'1','274','1',1,'Retail Sale Id 1415',4002.72,0.00,0.00,5.38,441.16,'2022-06-23 08:50:03','',''),(1436,'1','274','1',1,'Retail Sale Id 1416',2202.24,0.00,0.00,2.96,242.72,'2022-06-23 09:11:35','',''),(1437,'1','274','1',1,'Retail Sale Id 1417',9300.00,0.00,0.00,12.50,1025.00,'2022-06-23 09:16:35','',''),(1438,'1','274','1',1,'Retail Sale Id 1418',3749.76,0.00,0.00,5.04,413.28,'2022-06-23 09:22:12','',''),(1439,'1','274','1',1,'Retail Sale Id 1418',4501.20,0.00,0.00,6.05,496.10,'2022-06-23 09:22:12','',''),(1440,'1','274','1',1,'Retail Sale Id 1419',9300.00,0.00,0.00,12.50,1025.00,'2022-06-23 09:25:28','',''),(1441,'1','274','1',1,'Retail Sale Id 1420',18600.00,0.00,0.00,25.00,2050.00,'2022-06-23 09:33:18','',''),(1442,'1','274','1',1,'Retail Sale Id 1421',14136.00,0.00,0.00,19.00,1558.00,'2022-06-23 10:02:49','',''),(1443,'1','274','1',1,'Retail Sale Id 1422',2246.88,0.00,0.00,3.02,247.64,'2022-06-23 10:23:39','',''),(1444,'1','274','1',1,'Retail Sale Id 1423',996.96,0.00,0.00,1.34,109.88,'2022-06-23 10:31:51','',''),(1445,'1','274','1',1,'Retail Sale Id 1424',3496.80,0.00,0.00,4.70,385.40,'2022-06-23 10:44:39','',''),(1446,'1','274','1',1,'Retail Sale Id 1426',2246.88,0.00,0.00,3.02,247.64,'2022-06-23 10:57:13','',''),(1447,'1','274','1',1,'Retail Sale Id 1427',4501.20,0.00,0.00,6.05,496.10,'2022-06-23 11:29:29','',''),(1448,'1','274','1',1,'Retail Sale Id 1428',1502.88,0.00,0.00,2.02,165.64,'2022-06-23 11:31:36','',''),(1449,'1','274','1',1,'Retail Sale Id 1429',2001.36,0.00,0.00,2.69,220.58,'2022-06-23 12:53:19','',''),(1450,'1','274','1',1,'Retail Sale Id 1431',12900.96,0.00,0.00,17.34,1421.88,'2022-06-23 15:23:48','',''),(1451,'1','274','1',1,'Retail Sale Id 1432',2998.32,0.00,0.00,4.03,330.46,'2022-06-23 15:30:39','',''),(1452,'1','274','1',1,'Retail Sale Id 1433',9002.40,0.00,0.00,12.10,992.20,'2022-06-23 16:26:11','',''),(1453,'1','274','1',1,'Retail Sale Id 1434',9300.00,0.00,0.00,12.50,1025.00,'2022-06-23 16:41:39','',''),(1454,'1','274','1',1,'Retail Sale Id 1435',2001.36,0.00,0.00,2.69,220.58,'2022-06-23 16:44:53','',''),(1455,'1','274','1',1,'Retail Sale Id 1436',4501.20,0.00,0.00,6.05,496.10,'2022-06-23 17:00:54','',''),(1456,'1','274','1',1,'Retail Sale Id 1437',2001.36,0.00,0.00,2.69,220.58,'2022-06-23 17:18:18','',''),(1457,'1','274','1',1,'Retail Sale Id 1438',4999.68,0.00,0.00,6.72,551.04,'2022-06-23 17:23:19','',''),(1458,'1','274','1',1,'Retail Sale Id 1439',9300.00,0.00,0.00,12.50,1025.00,'2022-06-23 17:24:45','',''),(1459,'1','274','1',1,'Retail Sale Id 1440',6748.08,0.00,0.00,9.07,743.74,'2022-06-23 17:27:31','',''),(1460,'1','274','1',1,'Retail Sale Id 1441',2298.96,0.00,0.00,3.09,253.38,'2022-06-23 17:48:00','',''),(1461,'1','274','1',1,'Retail Sale Id 1442',13801.20,0.00,0.00,18.55,1521.10,'2022-06-23 17:51:27','',''),(1462,'1','274','1',1,'Retail Sale Id 1443',2001.36,0.00,0.00,2.69,220.58,'2022-06-23 17:52:47','',''),(1463,'1','274','1',1,'Retail Sale Id 1444',34997.76,0.00,0.00,47.04,3857.28,'2022-06-23 17:57:12','',''),(1464,'1','274','1',1,'Retail Sale Id 1445',4501.20,0.00,0.00,6.05,496.10,'2022-06-23 18:07:29','',''),(1465,'1','274','1',1,'Retail Sale Id 1446',2001.36,0.00,0.00,2.69,220.58,'2022-06-23 18:15:08','',''),(1466,'1','274','1',1,'Retail Sale Id 1447',14880.00,0.00,0.00,20.00,1640.00,'2022-06-23 18:20:36','',''),(1467,'1','274','1',1,'Retail Sale Id 1448',3801.84,0.00,0.00,5.11,419.02,'2022-06-23 18:30:29','',''),(1468,'1','274','1',1,'Retail Sale Id 1449',4501.20,0.00,0.00,6.05,496.10,'2022-06-23 18:39:35','',''),(1469,'1','274','1',1,'Retail Sale Id 1450',2202.24,0.00,0.00,2.96,242.72,'2022-06-23 18:41:51','',''),(1470,'1','274','1',1,'Retail Sale Id 1451',4002.72,0.00,0.00,5.38,441.16,'2022-06-23 18:51:30','',''),(1471,'1','274','1',1,'Retail Sale Id 1452',1502.88,0.00,0.00,2.02,165.64,'2022-06-23 18:54:12','',''),(1472,'1','274','1',1,'Return of Retail Sale Id 1447',0.00,14880.00,20.00,0.00,-1640.00,'2022-06-23 19:32:27','',''),(1473,'1','274','1',1,'Retail Sale Id 1453',8094.72,0.00,0.00,10.88,892.16,'2022-06-23 19:35:37','',''),(1474,'1','274','1',1,'Retail Sale Id 1453',26040.00,0.00,0.00,35.00,2870.00,'2022-06-23 19:35:37','',''),(1475,'1','274','1',1,'Retail Sale Id 1454',24998.40,0.00,0.00,33.60,2755.20,'2022-06-24 10:36:37','',''),(1476,'1','274','1',1,'Retail Sale Id 1455',1101.12,0.00,0.00,1.48,121.36,'2022-06-24 10:43:30','',''),(1477,'1','274','1',1,'Retail Sale Id 1456',9300.00,0.00,0.00,12.50,1025.00,'2022-06-24 11:09:30','',''),(1478,'1','274','1',1,'Retail Sale Id 1457',2246.88,0.00,0.00,3.02,247.64,'2022-06-24 11:13:48','',''),(1479,'1','274','1',1,'Retail Sale Id 1458',1502.88,0.00,0.00,2.02,165.64,'2022-06-24 11:18:59','',''),(1480,'1','274','1',1,'Retail Sale Id 1459',2246.88,0.00,0.00,3.02,247.64,'2022-06-24 11:20:03','',''),(1481,'1','274','1',1,'Retail Sale Id 1460',2246.88,0.00,0.00,3.02,247.64,'2022-06-24 11:25:47','',''),(1482,'1','274','1',1,'Retail Sale Id 1461',9300.00,0.00,0.00,12.50,1025.00,'2022-06-24 11:31:02','',''),(1483,'1','274','1',1,'Retail Sale Id 1462',2998.32,0.00,0.00,4.03,330.46,'2022-06-24 11:40:40','',''),(1484,'1','274','1',1,'Retail Sale Id 1463',81840.00,0.00,0.00,110.00,9020.00,'2022-06-24 12:01:56','',''),(1485,'1','274','1',1,'Retail Sale Id 1464',17603.04,0.00,0.00,23.66,1940.12,'2022-06-24 12:04:13','',''),(1486,'1','274','1',1,'Return of Retail Sale Id 1464',0.00,17603.04,23.66,0.00,-1940.12,'2022-06-24 12:08:27','',''),(1487,'1','274','1',1,'Retail Sale Id 1465',18600.00,0.00,0.00,25.00,2050.00,'2022-06-24 12:09:04','',''),(1488,'1','274','1',1,'Retail Sale Id 1466',4501.20,0.00,0.00,6.05,496.10,'2022-06-24 12:11:37','',''),(1489,'1','274','1',1,'Retail Sale Id 1467',9300.00,0.00,0.00,12.50,1025.00,'2022-06-24 12:34:49','',''),(1490,'1','274','1',1,'Retail Sale Id 1468',44640.00,0.00,0.00,60.00,4920.00,'2022-06-24 12:58:18','',''),(1491,'1','274','1',1,'Retail Sale Id 1470',7998.00,0.00,0.00,10.75,881.50,'2022-06-24 14:35:18','',''),(1492,'1','274','1',1,'Retail Sale Id 1471',2001.36,0.00,0.00,2.69,220.58,'2022-06-24 15:41:41','',''),(1493,'1','274','1',1,'Retail Sale Id 1472',2001.36,0.00,0.00,2.69,220.58,'2022-06-24 15:42:49','',''),(1494,'1','274','1',1,'Retail Sale Id 1473',9300.00,0.00,0.00,12.50,1025.00,'2022-06-24 16:36:20','',''),(1495,'1','274','1',1,'Retail Sale Id 1474',4501.20,0.00,0.00,6.05,496.10,'2022-06-24 16:38:52','',''),(1496,'1','274','1',1,'Retail Sale Id 1475',1502.88,0.00,0.00,2.02,165.64,'2022-06-24 16:47:57','',''),(1497,'1','274','1',1,'Retail Sale Id 1476',18600.00,0.00,0.00,25.00,2050.00,'2022-06-24 17:22:40','',''),(1498,'1','274','1',1,'Retail Sale Id 1477',13801.20,0.00,0.00,18.55,1521.10,'2022-06-24 17:23:33','',''),(1499,'1','274','1',1,'Retail Sale Id 1478',4501.20,0.00,0.00,6.05,496.10,'2022-06-24 17:40:39','',''),(1500,'1','274','1',1,'Retail Sale Id 1479',2246.88,0.00,0.00,3.02,247.64,'2022-06-24 17:47:06','',''),(1501,'1','274','1',1,'Retail Sale Id 1480',996.96,0.00,0.00,1.34,109.88,'2022-06-24 17:49:54','',''),(1502,'1','274','1',1,'Retail Sale Id 1481',5996.64,0.00,0.00,8.06,660.92,'2022-06-24 17:50:38','',''),(1503,'1','274','1',1,'Retail Sale Id 1482',4501.20,0.00,0.00,6.05,496.10,'2022-06-24 17:52:08','',''),(1504,'1','274','1',1,'Retail Sale Id 1483',22320.00,0.00,0.00,30.00,2460.00,'2022-06-24 18:08:20','',''),(1505,'1','274','1',1,'Retail Sale Id 1485',10416.00,0.00,0.00,14.00,1148.00,'2022-06-24 18:26:25','',''),(1506,'1','274','1',1,'Retail Sale Id 1486',4002.72,0.00,0.00,5.38,441.16,'2022-06-24 18:27:34','',''),(1507,'1','274','1',1,'Retail Sale Id 1487',4501.20,0.00,0.00,6.05,496.10,'2022-06-24 18:49:07','',''),(1508,'1','274','1',1,'Retail Sale Id 1488',16472.16,0.00,0.00,22.14,1815.48,'2022-06-24 20:00:05','',''),(1509,'1','274','1',1,'Retail Sale Id 1488',44148.96,0.00,0.00,59.34,4865.88,'2022-06-24 20:00:05','',''),(1510,'1','274','1',1,'Retail Sale Id 1489',4002.72,0.00,0.00,5.38,441.16,'2022-06-25 07:13:12','',''),(1511,'1','274','1',1,'Retail Sale Id 1490',9300.00,0.00,0.00,12.50,1025.00,'2022-06-25 07:30:18','',''),(1512,'1','274','1',1,'Retail Sale Id 1491',9300.00,0.00,0.00,12.50,1025.00,'2022-06-25 07:40:36','',''),(1513,'1','274','1',1,'Retail Sale Id 1492',9300.00,0.00,0.00,12.50,1025.00,'2022-06-25 07:52:21','',''),(1514,'1','274','1',1,'Retail Sale Id 1493',2150.16,0.00,0.00,2.89,236.98,'2022-06-25 07:53:21','',''),(1515,'1','274','1',1,'Retail Sale Id 1494',4501.20,0.00,0.00,6.05,496.10,'2022-06-25 07:55:13','',''),(1516,'1','274','1',1,'Retail Sale Id 1495',4501.20,0.00,0.00,6.05,496.10,'2022-06-25 07:56:28','',''),(1517,'1','274','1',1,'Retail Sale Id 1496',1502.88,0.00,0.00,2.02,165.64,'2022-06-25 07:57:19','',''),(1518,'1','274','1',1,'Retail Sale Id 1497',2001.36,0.00,0.00,2.69,220.58,'2022-06-25 07:59:43','',''),(1519,'1','274','1',1,'Retail Sale Id 1498',4002.72,0.00,0.00,5.38,441.16,'2022-06-25 08:01:56','',''),(1520,'1','274','1',1,'Retail Sale Id 1499',9300.00,0.00,0.00,12.50,1025.00,'2022-06-25 08:04:53','',''),(1521,'1','274','1',1,'Retail Sale Id 1500',8496.48,0.00,0.00,11.42,936.44,'2022-06-25 08:07:04','',''),(1522,'1','274','1',1,'Retail Sale Id 1501',996.96,0.00,0.00,1.34,109.88,'2022-06-25 08:11:32','',''),(1523,'1','274','1',1,'Retail Sale Id 1502',7440.00,0.00,0.00,10.00,820.00,'2022-06-25 08:27:16','',''),(1524,'1','274','1',1,'Retail Sale Id 1503',4999.68,0.00,0.00,6.72,551.04,'2022-06-25 08:28:02','',''),(1525,'1','274','1',1,'Retail Sale Id 1504',4501.20,0.00,0.00,6.05,496.10,'2022-06-25 08:33:03','',''),(1526,'1','274','1',1,'Retail Sale Id 1505',2246.88,0.00,0.00,3.02,247.64,'2022-06-25 08:34:46','',''),(1527,'1','274','1',1,'Retail Sale Id 1505',3749.76,0.00,0.00,5.04,413.28,'2022-06-25 08:34:46','',''),(1528,'1','274','1',1,'Retail Sale Id 1506',9300.00,0.00,0.00,12.50,1025.00,'2022-06-25 08:58:10','',''),(1529,'1','274','1',1,'Retail Sale Id 1507',2998.32,0.00,0.00,4.03,330.46,'2022-06-25 09:08:06','',''),(1530,'1','274','1',1,'Retail Sale Id 1508',2998.32,0.00,0.00,4.03,330.46,'2022-06-25 09:15:31','',''),(1531,'1','274','1',1,'Retail Sale Id 1509',996.96,0.00,0.00,1.34,109.88,'2022-06-25 09:18:40','',''),(1532,'1','274','1',1,'Retail Sale Id 1510',1502.88,0.00,0.00,2.02,165.64,'2022-06-25 09:33:54','',''),(1533,'1','274','1',1,'Retail Sale Id 1511',4501.20,0.00,0.00,6.05,496.10,'2022-06-25 09:35:57','',''),(1534,'1','274','1',1,'Retail Sale Id 1512',803.52,0.00,0.00,1.08,88.56,'2022-06-25 09:41:56','',''),(1535,'1','274','1',1,'Retail Sale Id 1513',7998.00,0.00,0.00,10.75,881.50,'2022-06-25 09:59:26','',''),(1536,'1','274','1',1,'Retail Sale Id 1514',7998.00,0.00,0.00,10.75,881.50,'2022-06-25 10:13:14','',''),(1537,'1','274','1',1,'Retail Sale Id 1515',9300.00,0.00,0.00,12.50,1025.00,'2022-06-25 10:15:15','',''),(1538,'1','274','1',1,'Retail Sale Id 1516',9300.00,0.00,0.00,12.50,1025.00,'2022-06-25 10:19:49','',''),(1539,'1','274','1',1,'Retail Sale Id 1517',996.96,0.00,0.00,1.34,109.88,'2022-06-25 10:37:28','',''),(1540,'1','274','1',1,'Retail Sale Id 1518',9300.00,0.00,0.00,12.50,1025.00,'2022-06-25 10:41:20','',''),(1541,'1','274','1',1,'Retail Sale Id 1519',9002.40,0.00,0.00,12.10,992.20,'2022-06-25 10:47:02','',''),(1542,'1','274','1',1,'Retail Sale Id 1520',996.96,0.00,0.00,1.34,109.88,'2022-06-25 10:52:41','',''),(1543,'1','274','1',1,'Retail Sale Id 1521',1502.88,0.00,0.00,2.02,165.64,'2022-06-25 11:05:30','',''),(1544,'1','274','1',1,'Retail Sale Id 1522',4999.68,0.00,0.00,6.72,551.04,'2022-06-25 11:08:06','',''),(1545,'1','274','1',1,'Retail Sale Id 1523',4002.72,0.00,0.00,5.38,441.16,'2022-06-25 11:10:36','',''),(1546,'1','274','1',1,'Retail Sale Id 1524',2001.36,0.00,0.00,2.69,220.58,'2022-06-25 11:21:27','',''),(1547,'1','274','1',1,'Retail Sale Id 1525',4501.20,0.00,0.00,6.05,496.10,'2022-06-25 11:22:25','',''),(1548,'1','274','1',1,'Retail Sale Id 1526',7499.52,0.00,0.00,10.08,826.56,'2022-06-25 11:25:44','',''),(1549,'1','274','1',1,'Retail Sale Id 1527',2499.84,0.00,0.00,3.36,275.52,'2022-06-25 11:30:58','',''),(1550,'1','274','1',1,'Retail Sale Id 1528',2998.32,0.00,0.00,4.03,330.46,'2022-06-25 11:37:56','',''),(1551,'1','274','1',1,'Retail Sale Id 1529',2246.88,0.00,0.00,3.02,247.64,'2022-06-25 11:40:06','',''),(1552,'1','274','1',1,'Retail Sale Id 1530',29760.00,0.00,0.00,40.00,3280.00,'2022-06-25 11:51:53','',''),(1553,'1','274','1',1,'Retail Sale Id 1531',1502.88,0.00,0.00,2.02,165.64,'2022-06-25 11:53:25','',''),(1554,'1','274','1',1,'Retail Sale Id 1532',11904.00,0.00,0.00,16.00,1312.00,'2022-06-25 12:37:50','',''),(1555,'1','274','1',1,'Retail Sale Id 1533',9300.00,0.00,0.00,12.50,1025.00,'2022-06-25 12:41:54','',''),(1556,'1','274','1',1,'Retail Sale Id 1534',9300.00,0.00,0.00,12.50,1025.00,'2022-06-25 12:44:29','',''),(1557,'1','274','1',1,'Retail Sale Id 1535',29998.08,0.00,0.00,40.32,3306.24,'2022-06-25 12:45:55','',''),(1558,'1','274','1',1,'Retail Sale Id 1536',22320.00,0.00,0.00,30.00,2460.00,'2022-06-25 13:00:39','',''),(1559,'1','274','1',1,'Retail Sale Id 1537',2001.36,0.00,0.00,2.69,220.58,'2022-06-25 13:19:10','',''),(1560,'1','274','1',1,'Retail Sale Id 1538',996.96,0.00,0.00,1.34,109.88,'2022-06-25 13:59:29','',''),(1561,'1','274','1',1,'Retail Sale Id 1539',4501.20,0.00,0.00,6.05,496.10,'2022-06-25 14:10:03','',''),(1562,'1','274','1',1,'Retail Sale Id 1540',37200.00,0.00,0.00,50.00,4100.00,'2022-06-25 14:35:37','',''),(1563,'1','274','1',1,'Retail Sale Id 1541',2998.32,0.00,0.00,4.03,330.46,'2022-06-25 14:40:06','',''),(1564,'1','274','1',1,'Retail Sale Id 1542',9300.00,0.00,0.00,12.50,1025.00,'2022-06-25 14:43:08','',''),(1565,'1','274','1',1,'Retail Sale Id 1543',3496.80,0.00,0.00,4.70,385.40,'2022-06-25 15:15:51','',''),(1566,'1','274','1',1,'Retail Sale Id 1544',9002.40,0.00,0.00,12.10,992.20,'2022-06-25 15:35:57','',''),(1567,'1','274','1',1,'Return of Retail Sale Id 1544',0.00,9002.40,12.10,0.00,-992.20,'2022-06-25 15:37:36','',''),(1568,'1','274','1',1,'Return of Retail Sale Id 1543',0.00,3496.80,4.70,0.00,-385.40,'2022-06-25 15:38:11','',''),(1569,'1','274','1',1,'Return of Retail Sale Id 1542',0.00,9300.00,12.50,0.00,-1025.00,'2022-06-25 15:38:56','',''),(1570,'1','274','1',1,'Retail Sale Id 1545',4501.20,0.00,0.00,6.05,496.10,'2022-06-25 15:51:18','',''),(1571,'1','274','1',1,'Retail Sale Id 1546',4501.20,0.00,0.00,6.05,496.10,'2022-06-25 16:40:06','',''),(1572,'1','274','1',1,'Retail Sale Id 1547',2001.36,0.00,0.00,2.69,220.58,'2022-06-25 17:38:37','',''),(1573,'1','274','1',1,'Retail Sale Id 1548',4501.20,0.00,0.00,6.05,496.10,'2022-06-25 17:40:22','',''),(1574,'1','274','1',1,'Retail Sale Id 1549',4501.20,0.00,0.00,6.05,496.10,'2022-06-25 17:46:13','',''),(1575,'1','274','1',1,'Retail Sale Id 1550',2001.36,0.00,0.00,2.69,220.58,'2022-06-25 17:50:52','',''),(1576,'1','274','1',1,'Retail Sale Id 1551',3749.76,0.00,0.00,5.04,413.28,'2022-06-25 17:51:48','',''),(1577,'1','274','1',1,'Retail Sale Id 1552',2998.32,0.00,0.00,4.03,330.46,'2022-06-25 18:24:07','',''),(1578,'1','274','1',1,'Retail Sale Id 1553',803.52,0.00,0.00,1.08,88.56,'2022-06-25 18:25:01','',''),(1579,'1','274','1',1,'Retail Sale Id 1554',2246.88,0.00,0.00,3.02,247.64,'2022-06-25 18:37:11','',''),(1580,'1','274','1',1,'Retail Sale Id 1555',2700.72,0.00,0.00,3.63,297.66,'2022-06-25 18:41:50','',''),(1581,'1','274','1',1,'Retail Sale Id 1556',18600.00,0.00,0.00,25.00,2050.00,'2022-06-25 18:52:23','',''),(1582,'1','274','1',1,'Retail Sale Id 1557',996.96,0.00,0.00,1.34,109.88,'2022-06-25 18:53:33','',''),(1583,'1','274','1',1,'Retail Sale Id 1560',4501.20,0.00,0.00,6.05,496.10,'2022-06-25 18:54:44','',''),(1584,'1','274','1',1,'Retail Sale Id 1561',7901.28,0.00,0.00,10.62,870.84,'2022-06-25 18:56:01','',''),(1585,'1','274','1',1,'Retail Sale Id 1563',1502.88,0.00,0.00,2.02,165.64,'2022-06-25 19:00:12','',''),(1586,'1','274','1',1,'Retail Sale Id 1564',19448.16,0.00,0.00,26.14,2143.48,'2022-06-25 19:37:24','',''),(1587,'1','274','1',1,'Retail Sale Id 1564',67317.12,0.00,0.00,90.48,7419.36,'2022-06-25 19:37:24','',''),(1588,'1','274','1',1,'Retail Sale Id 1565',1502.88,0.00,0.00,2.02,165.64,'2022-06-26 07:32:25','',''),(1589,'1','274','1',1,'Retail Sale Id 1565',9300.00,0.00,0.00,12.50,1025.00,'2022-06-26 07:32:25','',''),(1590,'1','274','1',1,'Retail Sale Id 1566',1502.88,0.00,0.00,2.02,165.64,'2022-06-26 08:06:33','',''),(1591,'1','274','1',1,'Retail Sale Id 1567',9300.00,0.00,0.00,12.50,1025.00,'2022-06-26 08:17:09','',''),(1592,'1','274','1',1,'Retail Sale Id 1568',7440.00,0.00,0.00,10.00,820.00,'2022-06-26 08:29:28','',''),(1593,'1','274','1',1,'Retail Sale Id 1569',2246.88,0.00,0.00,3.02,247.64,'2022-06-26 08:31:31','',''),(1594,'1','274','1',1,'Retail Sale Id 1570',996.96,0.00,0.00,1.34,109.88,'2022-06-26 08:47:00','',''),(1595,'1','274','1',1,'Retail Sale Id 1571',2001.36,0.00,0.00,2.69,220.58,'2022-06-26 09:02:00','',''),(1596,'1','274','1',1,'Retail Sale Id 1572',2246.88,0.00,0.00,3.02,247.64,'2022-06-26 09:24:14','',''),(1597,'1','274','1',1,'Retail Sale Id 1573',2246.88,0.00,0.00,3.02,247.64,'2022-06-26 09:26:06','',''),(1598,'1','274','1',1,'Retail Sale Id 1574',4501.20,0.00,0.00,6.05,496.10,'2022-06-26 09:42:21','',''),(1599,'1','274','1',1,'Retail Sale Id 1575',9300.00,0.00,0.00,12.50,1025.00,'2022-06-26 09:50:21','',''),(1600,'1','274','1',1,'Retail Sale Id 1576',2001.36,0.00,0.00,2.69,220.58,'2022-06-26 09:54:28','',''),(1601,'1','274','1',1,'Retail Sale Id 1577',4501.20,0.00,0.00,6.05,496.10,'2022-06-26 09:55:50','',''),(1602,'1','274','1',1,'Retail Sale Id 1578',7998.00,0.00,0.00,10.75,881.50,'2022-06-26 09:59:57','',''),(1603,'1','274','1',1,'Retail Sale Id 1579',2001.36,0.00,0.00,2.69,220.58,'2022-06-26 10:10:46','',''),(1604,'1','274','1',1,'Retail Sale Id 1580',9300.00,0.00,0.00,12.50,1025.00,'2022-06-26 10:30:27','',''),(1605,'1','274','1',1,'Retail Sale Id 1581',44640.00,0.00,0.00,60.00,4920.00,'2022-06-26 13:45:28','',''),(1606,'1','274','1',1,'Retail Sale Id 1582',2202.24,0.00,0.00,2.96,242.72,'2022-06-26 13:47:43','',''),(1607,'1','274','1',1,'Retail Sale Id 1583',1502.88,0.00,0.00,2.02,165.64,'2022-06-26 13:49:15','',''),(1608,'1','274','1',1,'Retail Sale Id 1584',2001.36,0.00,0.00,2.69,220.58,'2022-06-26 14:06:24','',''),(1609,'1','274','1',1,'Retail Sale Id 1585',1502.88,0.00,0.00,2.02,165.64,'2022-06-26 14:21:36','',''),(1610,'1','274','1',1,'Retail Sale Id 1586',3749.76,0.00,0.00,5.04,413.28,'2022-06-26 14:28:57','',''),(1611,'1','274','1',1,'Retail Sale Id 1587',803.52,0.00,0.00,1.08,88.56,'2022-06-26 14:43:04','',''),(1612,'1','274','1',1,'Retail Sale Id 1588',4501.20,0.00,0.00,6.05,496.10,'2022-06-26 15:11:50','',''),(1613,'1','274','1',1,'Retail Sale Id 1589',2998.32,0.00,0.00,4.03,330.46,'2022-06-26 15:17:53','',''),(1614,'1','274','1',1,'Retail Sale Id 1590',9300.00,0.00,0.00,12.50,1025.00,'2022-06-26 15:33:26','',''),(1615,'1','274','1',1,'Retail Sale Id 1591',2998.32,0.00,0.00,4.03,330.46,'2022-06-26 15:35:06','',''),(1616,'1','274','1',1,'Retail Sale Id 1592',2001.36,0.00,0.00,2.69,220.58,'2022-06-26 15:37:07','',''),(1617,'1','274','1',1,'Retail Sale Id 1593',2246.88,0.00,0.00,3.02,247.64,'2022-06-26 15:38:01','',''),(1618,'1','274','1',1,'Retail Sale Id 1594',9300.00,0.00,0.00,12.50,1025.00,'2022-06-26 15:41:32','',''),(1619,'1','274','1',1,'Retail Sale Id 1595',2246.88,0.00,0.00,3.02,247.64,'2022-06-26 15:47:26','',''),(1620,'1','274','1',1,'Retail Sale Id 1596',9300.00,0.00,0.00,12.50,1025.00,'2022-06-26 15:51:51','',''),(1621,'1','274','1',1,'Retail Sale Id 1597',9300.00,0.00,0.00,12.50,1025.00,'2022-06-26 15:53:05','',''),(1622,'1','274','1',1,'Retail Sale Id 1598',2001.36,0.00,0.00,2.69,220.58,'2022-06-26 16:35:04','',''),(1623,'1','274','1',1,'Retail Sale Id 1599',1502.88,0.00,0.00,2.02,165.64,'2022-06-26 16:46:52','',''),(1624,'1','274','1',1,'Retail Sale Id 1600',4501.20,0.00,0.00,6.05,496.10,'2022-06-26 17:02:50','',''),(1625,'1','274','1',1,'Retail Sale Id 1601',9300.00,0.00,0.00,12.50,1025.00,'2022-06-26 17:33:57','',''),(1626,'1','274','1',1,'Retail Sale Id 1602',4501.20,0.00,0.00,6.05,496.10,'2022-06-26 17:44:43','',''),(1627,'1','274','1',1,'Retail Sale Id 1603',4002.72,0.00,0.00,5.38,441.16,'2022-06-26 17:46:26','',''),(1628,'1','274','1',1,'Retail Sale Id 1604',27528.00,0.00,0.00,37.00,3034.00,'2022-06-26 18:02:46','',''),(1629,'1','274','1',1,'Retail Sale Id 1605',9300.00,0.00,0.00,12.50,1025.00,'2022-06-26 18:03:42','',''),(1630,'1','274','1',1,'Retail Sale Id 1606',9300.00,0.00,0.00,12.50,1025.00,'2022-06-26 18:05:28','',''),(1631,'1','274','1',1,'Retail Sale Id 1607',2202.24,0.00,0.00,2.96,242.72,'2022-06-26 18:25:15','',''),(1632,'1','274','1',1,'Retail Sale Id 1608',9300.00,0.00,0.00,12.50,1025.00,'2022-06-26 18:29:14','',''),(1633,'1','274','1',1,'Retail Sale Id 1609',9300.00,0.00,0.00,12.50,1025.00,'2022-06-26 18:36:24','',''),(1634,'1','274','1',1,'Retail Sale Id 1610',9300.00,0.00,0.00,12.50,1025.00,'2022-06-26 18:37:10','',''),(1635,'1','274','1',1,'Retail Sale Id 1611',9300.00,0.00,0.00,12.50,1025.00,'2022-06-26 18:39:22','',''),(1636,'1','274','1',1,'Retail Sale Id 1611',37200.00,0.00,0.00,50.00,4100.00,'2022-06-26 18:39:22','',''),(1637,'1','274','1',1,'Retail Sale Id 1612',803.52,0.00,0.00,1.08,88.56,'2022-06-26 18:45:35','',''),(1638,'1','274','1',1,'Retail Sale Id 1613',699.36,0.00,0.00,0.94,77.08,'2022-06-26 18:46:57','',''),(1639,'1','274','1',1,'Retail Sale Id 1614',751.44,0.00,0.00,1.01,82.82,'2022-06-26 18:47:50','',''),(1640,'1','274','1',1,'Retail Sale Id 1615',9300.00,0.00,0.00,12.50,1025.00,'2022-06-26 18:52:29','',''),(1641,'1','274','1',1,'Retail Sale Id 1616',9300.00,0.00,0.00,12.50,1025.00,'2022-06-26 18:55:30','',''),(1642,'1','274','1',1,'Retail Sale Id 1617',431.52,0.00,0.00,0.58,47.56,'2022-06-26 19:22:59','',''),(1643,'1','274','1',1,'Retail Sale Id 1617',60115.20,0.00,0.00,80.80,6625.60,'2022-06-26 19:22:59','',''),(1644,'1','274','1',1,'Retail Sale Id 1618',2998.32,0.00,0.00,4.03,330.46,'2022-06-27 07:35:49','',''),(1645,'1','274','1',1,'Retail Sale Id 1619',3496.80,0.00,0.00,4.70,385.40,'2022-06-27 07:51:52','',''),(1646,'1','274','1',1,'Retail Sale Id 1620',9300.00,0.00,0.00,12.50,1025.00,'2022-06-27 07:58:16','',''),(1647,'1','274','1',1,'Retail Sale Id 1621',9300.00,0.00,0.00,12.50,1025.00,'2022-06-27 08:04:30','',''),(1648,'1','274','1',1,'Retail Sale Id 1622',4501.20,0.00,0.00,6.05,496.10,'2022-06-27 08:13:47','',''),(1649,'1','274','1',1,'Retail Sale Id 1623',2246.88,0.00,0.00,3.02,247.64,'2022-06-27 08:35:52','',''),(1650,'1','274','1',1,'Retail Sale Id 1624',9300.00,0.00,0.00,12.50,1025.00,'2022-06-27 08:45:58','',''),(1651,'1','274','1',1,'Retail Sale Id 1625',2001.36,0.00,0.00,2.69,220.58,'2022-06-27 08:49:04','',''),(1652,'1','274','1',1,'Retail Sale Id 1626',9300.00,0.00,0.00,12.50,1025.00,'2022-06-27 08:52:36','',''),(1653,'1','274','1',1,'Retail Sale Id 1627',7440.00,0.00,0.00,10.00,820.00,'2022-06-27 09:00:14','',''),(1654,'1','274','1',1,'Retail Sale Id 1628',2001.36,0.00,0.00,2.69,220.58,'2022-06-27 09:07:35','',''),(1655,'1','274','1',1,'Retail Sale Id 1629',2246.88,0.00,0.00,3.02,247.64,'2022-06-27 09:10:29','',''),(1656,'1','274','1',1,'Retail Sale Id 1630',9300.00,0.00,0.00,12.50,1025.00,'2022-06-27 09:20:01','',''),(1657,'1','274','1',1,'Retail Sale Id 1631',1502.88,0.00,0.00,2.02,165.64,'2022-06-27 09:21:39','',''),(1658,'1','274','1',1,'Retail Sale Id 1632',2246.88,0.00,0.00,3.02,247.64,'2022-06-27 09:24:57','',''),(1659,'1','274','1',1,'Retail Sale Id 1633',4501.20,0.00,0.00,6.05,496.10,'2022-06-27 09:32:33','',''),(1660,'1','274','1',1,'Retail Sale Id 1634',8198.88,0.00,0.00,11.02,903.64,'2022-06-27 09:37:06','',''),(1661,'1','274','1',1,'Retail Sale Id 1635',7440.00,0.00,0.00,10.00,820.00,'2022-06-27 09:40:17','',''),(1662,'1','274','1',1,'Retail Sale Id 1636',2001.36,0.00,0.00,2.69,220.58,'2022-06-27 09:43:17','',''),(1663,'1','274','1',1,'Retail Sale Id 1637',4002.72,0.00,0.00,5.38,441.16,'2022-06-27 09:52:11','',''),(1664,'1','274','1',1,'Retail Sale Id 1638',9300.00,0.00,0.00,12.50,1025.00,'2022-06-27 10:24:38','',''),(1665,'1','274','1',1,'Retail Sale Id 1639',4501.20,0.00,0.00,6.05,496.10,'2022-06-27 10:32:17','',''),(1666,'1','274','1',1,'Retail Sale Id 1640',9300.00,0.00,0.00,12.50,1025.00,'2022-06-27 10:42:34','',''),(1667,'1','274','1',1,'Retail Sale Id 1641',2499.84,0.00,0.00,3.36,275.52,'2022-06-27 10:43:31','',''),(1668,'1','274','1',1,'Retail Sale Id 1642',18600.00,0.00,0.00,25.00,2050.00,'2022-06-27 11:02:55','',''),(1669,'1','274','1',1,'Retail Sale Id 1643',3749.76,0.00,0.00,5.04,413.28,'2022-06-27 11:08:11','',''),(1670,'1','274','1',1,'Retail Sale Id 1644',7998.00,0.00,0.00,10.75,881.50,'2022-06-27 11:11:02','',''),(1671,'1','274','1',1,'Retail Sale Id 1645',19998.72,0.00,0.00,26.88,2204.16,'2022-06-27 11:12:08','',''),(1672,'1','274','1',1,'Retail Sale Id 1646',1502.88,0.00,0.00,2.02,165.64,'2022-06-27 11:26:21','',''),(1673,'1','274','1',1,'Retail Sale Id 1647',3749.76,0.00,0.00,5.04,413.28,'2022-06-27 11:35:21','',''),(1674,'1','274','1',1,'Retail Sale Id 1648',4501.20,0.00,0.00,6.05,496.10,'2022-06-27 11:44:45','',''),(1675,'1','274','1',1,'Retail Sale Id 1649',4501.20,0.00,0.00,6.05,496.10,'2022-06-27 11:45:56','',''),(1676,'1','274','1',1,'Retail Sale Id 1650',9300.00,0.00,0.00,12.50,1025.00,'2022-06-27 11:49:11','',''),(1677,'1','274','1',1,'Retail Sale Id 1651',4002.72,0.00,0.00,5.38,441.16,'2022-06-27 12:04:22','',''),(1678,'1','274','1',1,'Retail Sale Id 1652',10416.00,0.00,0.00,14.00,1148.00,'2022-06-27 12:06:05','',''),(1679,'1','274','1',1,'Retail Sale Id 1653',16368.00,0.00,0.00,22.00,1804.00,'2022-06-27 12:06:47','',''),(1680,'1','274','1',1,'Retail Sale Id 1654',2246.88,0.00,0.00,3.02,247.64,'2022-06-27 12:58:07','',''),(1681,'1','274','1',1,'Retail Sale Id 1655',5996.64,0.00,0.00,8.06,660.92,'2022-06-27 13:29:15','',''),(1682,'1','274','1',1,'Retail Sale Id 1656',2998.32,0.00,0.00,4.03,330.46,'2022-06-27 14:00:47','',''),(1683,'1','274','1',1,'Retail Sale Id 1658',37200.00,0.00,0.00,50.00,4100.00,'2022-06-27 17:31:12','',''),(1684,'1','274','1',1,'Retail Sale Id 1659',3749.76,0.00,0.00,5.04,413.28,'2022-06-27 17:49:44','',''),(1685,'1','274','1',1,'Retail Sale Id 1660',79481.52,0.00,0.00,106.83,8760.06,'2022-06-27 20:14:12','',''),(1686,'1','274','1',1,'Retail Sale Id 1660',84079.44,0.00,0.00,113.01,9266.82,'2022-06-27 20:14:12','',''),(1687,'1','274','1',1,'Retail Sale Id 1661',1696.32,0.00,0.00,2.28,186.96,'2022-06-28 07:17:18','',''),(1688,'1','274','1',1,'Retail Sale Id 1662',9300.00,0.00,0.00,12.50,1025.00,'2022-06-28 08:31:59','',''),(1689,'1','274','1',1,'Retail Sale Id 1663',37200.00,0.00,0.00,50.00,4100.00,'2022-06-28 08:38:21','',''),(1690,'1','274','1',1,'Retail Sale Id 1664',2998.32,0.00,0.00,4.03,330.46,'2022-06-28 08:42:58','',''),(1691,'1','274','1',1,'Retail Sale Id 1665',9300.00,0.00,0.00,12.50,1025.00,'2022-06-28 08:54:00','',''),(1692,'1','274','1',1,'Retail Sale Id 1666',4002.72,0.00,0.00,5.38,441.16,'2022-06-28 09:29:51','',''),(1693,'1','274','1',1,'Retail Sale Id 1667',4002.72,0.00,0.00,5.38,441.16,'2022-06-28 09:30:59','',''),(1694,'1','274','1',1,'Retail Sale Id 1668',4999.68,0.00,0.00,6.72,551.04,'2022-06-28 09:37:57','',''),(1695,'1','274','1',1,'Retail Sale Id 1669',9300.00,0.00,0.00,12.50,1025.00,'2022-06-28 10:02:30','',''),(1696,'1','274','1',1,'Retail Sale Id 1670',9300.00,0.00,0.00,12.50,1025.00,'2022-06-28 10:13:09','',''),(1697,'1','274','1',1,'Retail Sale Id 1671',8250.96,0.00,0.00,11.09,909.38,'2022-06-28 10:21:13','',''),(1698,'1','274','1',1,'Retail Sale Id 1672',59520.00,0.00,0.00,80.00,6560.00,'2022-06-28 10:36:45','',''),(1699,'1','274','1',1,'Retail Sale Id 1673',4002.72,0.00,0.00,5.38,441.16,'2022-06-28 10:47:09','',''),(1700,'1','274','1',1,'Retail Sale Id 1674',13801.20,0.00,0.00,18.55,1521.10,'2022-06-28 11:07:24','',''),(1701,'1','274','1',1,'Retail Sale Id 1675',9002.40,0.00,0.00,12.10,992.20,'2022-06-28 11:50:26','',''),(1702,'1','274','1',1,'Retail Sale Id 1676',9300.00,0.00,0.00,12.50,1025.00,'2022-06-28 12:19:54','',''),(1703,'1','274','1',1,'Retail Sale Id 1677',9300.00,0.00,0.00,12.50,1025.00,'2022-06-28 12:24:16','',''),(1704,'1','274','1',1,'Retail Sale Id 1678',2246.88,0.00,0.00,3.02,247.64,'2022-06-28 12:33:57','',''),(1705,'1','274','1',1,'Retail Sale Id 1679',9300.00,0.00,0.00,12.50,1025.00,'2022-06-28 12:47:45','',''),(1706,'1','274','1',1,'Retail Sale Id 1680',7440.00,0.00,0.00,10.00,820.00,'2022-06-28 12:55:30','',''),(1707,'1','274','1',1,'Retail Sale Id 1681',3496.80,0.00,0.00,4.70,385.40,'2022-06-28 12:56:15','',''),(1708,'1','274','1',1,'Retail Sale Id 1682',2976.00,0.00,0.00,4.00,328.00,'2022-06-28 14:50:08','',''),(1709,'1','274','1',1,'Retail Sale Id 1683',16501.92,0.00,0.00,22.18,1818.76,'2022-06-28 15:08:01','',''),(1710,'1','274','1',1,'Retail Sale Id 1685',24641.28,0.00,0.00,33.12,2715.84,'2022-06-28 15:17:12','',''),(1711,'1','274','1',1,'Retail Sale Id 1685',77204.88,0.00,0.00,103.77,8509.14,'2022-06-28 15:17:12','',''),(1712,'1','274','1',1,'Distributed to operational loss for sales id:2',13882.14,0.00,0.00,20.97,0.00,'2022-06-28 15:22:51','',''),(1713,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,662000.00,1000.00,0.00,0.00,'2022-06-28 15:25:34','',''),(1714,'1','274',NULL,1,'Reception corrector for bridging 11',0.00,0.00,0.00,1000.00,0.00,'2022-06-28 15:26:40','',''),(1715,'1','274','1',1,'Received from bridging 11',0.00,0.00,1000.00,0.00,0.00,'2022-06-28 15:26:40','',''),(1716,'1','274','1',1,'Retail Sale Id 1686',2001.36,0.00,0.00,2.69,220.58,'2022-06-28 16:22:18','',''),(1717,'1','274','1',1,'Retail Sale Id 1687',803.52,0.00,0.00,1.08,88.56,'2022-06-28 16:25:35','',''),(1718,'1','274','1',1,'Retail Sale Id 1688',2001.36,0.00,0.00,2.69,220.58,'2022-06-28 16:27:12','',''),(1719,'1','274','1',1,'Retail Sale Id 1689',37200.00,0.00,0.00,50.00,4100.00,'2022-06-28 16:28:07','',''),(1720,'1','274','1',1,'Retail Sale Id 1690',2001.36,0.00,0.00,2.69,220.58,'2022-06-28 16:44:04','',''),(1721,'1','274','1',1,'Retail Sale Id 1691',4002.72,0.00,0.00,5.38,441.16,'2022-06-28 17:04:10','',''),(1722,'1','274','1',1,'Retail Sale Id 1692',2499.84,0.00,0.00,3.36,275.52,'2022-06-28 17:07:14','',''),(1723,'1','274','1',1,'Retail Sale Id 1693',3496.80,0.00,0.00,4.70,385.40,'2022-06-28 17:08:24','',''),(1724,'1','274','1',1,'Retail Sale Id 1694',9300.00,0.00,0.00,12.50,1025.00,'2022-06-28 17:09:08','',''),(1725,'1','274','1',1,'Retail Sale Id 1695',2001.36,0.00,0.00,2.69,220.58,'2022-06-28 17:53:38','',''),(1726,'1','274','1',1,'Retail Sale Id 1696',4501.20,0.00,0.00,6.05,496.10,'2022-06-28 18:15:31','',''),(1727,'1','274','1',1,'Retail Sale Id 1697',9002.40,0.00,0.00,12.10,992.20,'2022-06-28 18:16:39','',''),(1728,'1','274','1',1,'Retail Sale Id 1698',996.96,0.00,0.00,1.34,109.88,'2022-06-28 18:22:37','',''),(1729,'1','274','1',1,'Retail Sale Id 1699',1502.88,0.00,0.00,2.02,165.64,'2022-06-28 18:30:40','',''),(1730,'1','274','1',1,'Retail Sale Id 1700',16368.00,0.00,0.00,22.00,1804.00,'2022-06-28 18:41:09','',''),(1731,'1','274','1',1,'Retail Sale Id 1701',491.04,0.00,0.00,0.66,54.12,'2022-06-28 19:59:08','',''),(1732,'1','274','1',1,'Retail Sale Id 1701',10133.28,0.00,0.00,13.62,1116.84,'2022-06-28 19:59:08','',''),(1733,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,2959140.00,4470.00,0.00,0.00,'2022-06-28 20:51:23','',''),(1734,'1','274',NULL,1,'Reception corrector for bridging 12',0.00,0.00,0.00,4470.00,0.00,'2022-06-28 20:52:49','',''),(1735,'1','274','1',1,'Received from bridging 12',0.00,0.00,4470.00,0.00,0.00,'2022-06-28 20:52:49','',''),(1736,'1','274','1',1,'Retail Sale Id 1702',9300.00,0.00,0.00,12.50,1025.00,'2022-06-29 07:58:55','',''),(1737,'1','274','1',1,'Retail Sale Id 1703',9300.00,0.00,0.00,12.50,1025.00,'2022-06-29 08:33:36','',''),(1738,'1','274','1',1,'Retail Sale Id 1704',2998.32,0.00,0.00,4.03,330.46,'2022-06-29 08:36:11','',''),(1739,'1','274','1',1,'Retail Sale Id 1705',1502.88,0.00,0.00,2.02,165.64,'2022-06-29 08:57:46','',''),(1740,'1','274','1',1,'Retail Sale Id 1706',4501.20,0.00,0.00,6.05,496.10,'2022-06-29 09:29:54','',''),(1741,'1','274','1',1,'Retail Sale Id 1707',1502.88,0.00,0.00,2.02,165.64,'2022-06-29 09:30:46','',''),(1742,'1','274','1',1,'Retail Sale Id 1708',4501.20,0.00,0.00,6.05,496.10,'2022-06-29 09:44:25','',''),(1743,'1','274','1',1,'Retail Sale Id 1709',2001.36,0.00,0.00,2.69,220.58,'2022-06-29 10:07:57','',''),(1744,'1','274','1',1,'Retail Sale Id 1710',4999.68,0.00,0.00,6.72,551.04,'2022-06-29 10:12:54','',''),(1745,'1','274','1',1,'Retail Sale Id 1711',2001.36,0.00,0.00,2.69,220.58,'2022-06-29 10:16:10','',''),(1746,'1','274','1',1,'Retail Sale Id 1712',2001.36,0.00,0.00,2.69,220.58,'2022-06-29 10:17:14','',''),(1747,'1','274','1',1,'Retail Sale Id 1713',2246.88,0.00,0.00,3.02,247.64,'2022-06-29 11:01:36','',''),(1748,'1','274','1',1,'Retail Sale Id 1715',4501.20,0.00,0.00,6.05,496.10,'2022-06-29 11:16:46','',''),(1749,'1','274','1',1,'Retail Sale Id 1716',4501.20,0.00,0.00,6.05,496.10,'2022-06-29 11:18:56','',''),(1750,'1','274','1',1,'Retail Sale Id 1717',9300.00,0.00,0.00,12.50,1025.00,'2022-06-29 11:21:39','',''),(1751,'1','274','1',1,'Retail Sale Id 1718',2998.32,0.00,0.00,4.03,330.46,'2022-06-29 11:22:33','',''),(1752,'1','274','1',1,'Retail Sale Id 1719',4002.72,0.00,0.00,5.38,441.16,'2022-06-29 11:24:55','',''),(1753,'1','274','1',1,'Return of Retail Sale Id 1718',0.00,2998.32,4.03,0.00,-330.46,'2022-06-29 11:26:27','',''),(1754,'1','274','1',1,'Retail Sale Id 1721',3496.80,0.00,0.00,4.70,385.40,'2022-06-29 11:39:43','',''),(1755,'1','274','1',1,'Retail Sale Id 1722',2998.32,0.00,0.00,4.03,330.46,'2022-06-29 11:59:44','',''),(1756,'1','274','1',1,'Retail Sale Id 1723',2246.88,0.00,0.00,3.02,247.64,'2022-06-29 12:00:56','',''),(1757,'1','274','1',1,'Retail Sale Id 1724',9300.00,0.00,0.00,12.50,1025.00,'2022-06-29 12:08:54','',''),(1758,'1','274','1',1,'Retail Sale Id 1725',4501.20,0.00,0.00,6.05,496.10,'2022-06-29 12:14:35','',''),(1759,'1','274','1',1,'Retail Sale Id 1726',9300.00,0.00,0.00,12.50,1025.00,'2022-06-29 12:18:04','',''),(1760,'1','274','1',1,'Retail Sale Id 1727',9300.00,0.00,0.00,12.50,1025.00,'2022-06-29 12:26:58','',''),(1761,'1','274','1',1,'Retail Sale Id 1728',2001.36,0.00,0.00,2.69,220.58,'2022-06-29 12:31:15','',''),(1762,'1','274','1',1,'Retail Sale Id 1729',2001.36,0.00,0.00,2.69,220.58,'2022-06-29 12:32:50','',''),(1763,'1','274','1',1,'Retail Sale Id 1730',4501.20,0.00,0.00,6.05,496.10,'2022-06-29 12:51:23','',''),(1764,'1','274','1',1,'Retail Sale Id 1731',4999.68,0.00,0.00,6.72,551.04,'2022-06-29 13:01:48','',''),(1765,'1','274','1',1,'Retail Sale Id 1732',2246.88,0.00,0.00,3.02,247.64,'2022-06-29 13:31:03','',''),(1766,'1','274','1',1,'Retail Sale Id 1733',9300.00,0.00,0.00,12.50,1025.00,'2022-06-29 13:39:11','',''),(1767,'1','274','1',1,'Retail Sale Id 1734',1502.88,0.00,0.00,2.02,165.64,'2022-06-29 14:32:18','',''),(1768,'1','274','1',1,'Retail Sale Id 1735',18600.00,0.00,0.00,25.00,2050.00,'2022-06-29 14:39:04','',''),(1769,'1','274','1',1,'Retail Sale Id 1736',9300.00,0.00,0.00,12.50,1025.00,'2022-06-29 14:58:36','',''),(1770,'1','274','1',1,'Retail Sale Id 1737',9300.00,0.00,0.00,12.50,1025.00,'2022-06-29 15:14:45','',''),(1771,'1','274','1',1,'Retail Sale Id 1738',1502.88,0.00,0.00,2.02,165.64,'2022-06-29 15:15:25','',''),(1772,'1','274','1',1,'Retail Sale Id 1739',7440.00,0.00,0.00,10.00,820.00,'2022-06-29 15:17:13','',''),(1773,'1','274','1',1,'Retail Sale Id 1740',13503.60,0.00,0.00,18.15,1488.30,'2022-06-29 15:33:03','',''),(1774,'1','274','1',1,'Retail Sale Id 1741',9300.00,0.00,0.00,12.50,1025.00,'2022-06-29 15:47:02','',''),(1775,'1','274','1',1,'Retail Sale Id 1742',1502.88,0.00,0.00,2.02,165.64,'2022-06-29 16:22:00','',''),(1776,'1','274','1',1,'Retail Sale Id 1743',2998.32,0.00,0.00,4.03,330.46,'2022-06-29 16:23:35','',''),(1777,'1','274','1',1,'Retail Sale Id 1744',2499.84,0.00,0.00,3.36,275.52,'2022-06-29 16:34:54','',''),(1778,'1','274','1',1,'Retail Sale Id 1746',9300.00,0.00,0.00,12.50,1025.00,'2022-06-29 16:40:16','',''),(1779,'1','274','1',1,'Retail Sale Id 1747',2246.88,0.00,0.00,3.02,247.64,'2022-06-29 16:43:46','',''),(1780,'1','274','1',1,'Retail Sale Id 1748',9300.00,0.00,0.00,12.50,1025.00,'2022-06-29 17:19:27','',''),(1781,'1','274','1',1,'Retail Sale Id 1749',9300.00,0.00,0.00,12.50,1025.00,'2022-06-29 17:20:36','',''),(1782,'1','274','1',1,'Retail Sale Id 1750',4999.68,0.00,0.00,6.72,551.04,'2022-06-29 17:35:11','',''),(1783,'1','274','1',1,'Retail Sale Id 1751',2998.32,0.00,0.00,4.03,330.46,'2022-06-29 17:36:13','',''),(1784,'1','274','1',1,'Retail Sale Id 1752',2998.32,0.00,0.00,4.03,330.46,'2022-06-29 17:37:29','',''),(1785,'1','274','1',1,'Retail Sale Id 1753',9300.00,0.00,0.00,12.50,1025.00,'2022-06-29 17:44:00','',''),(1786,'1','274','1',1,'Retail Sale Id 1754',2001.36,0.00,0.00,2.69,220.58,'2022-06-29 17:56:45','',''),(1787,'1','274','1',1,'Retail Sale Id 1755',4501.20,0.00,0.00,6.05,496.10,'2022-06-29 18:00:26','',''),(1788,'1','274','1',1,'Retail Sale Id 1756',2499.84,0.00,0.00,3.36,275.52,'2022-06-29 18:11:37','',''),(1789,'1','274','1',1,'Retail Sale Id 1757',11546.88,0.00,0.00,15.52,1272.64,'2022-06-29 18:16:53','',''),(1790,'1','274','1',1,'Retail Sale Id 1758',2001.36,0.00,0.00,2.69,220.58,'2022-06-29 18:18:16','',''),(1791,'1','274','1',1,'Retail Sale Id 1759',16368.00,0.00,0.00,22.00,1804.00,'2022-06-29 18:23:28','',''),(1792,'1','274','1',1,'Retail Sale Id 1760',3452.16,0.00,0.00,4.64,380.48,'2022-06-29 19:51:51','',''),(1793,'1','274','1',1,'Retail Sale Id 1760',4992.24,0.00,0.00,6.71,550.22,'2022-06-29 19:51:51','',''),(1794,'1','274','1',1,'Retail Sale Id 1761',9300.00,0.00,0.00,12.50,1025.00,'2022-06-30 07:15:03','',''),(1795,'1','274','1',1,'Retail Sale Id 1762',4999.68,0.00,0.00,6.72,551.04,'2022-06-30 07:52:54','',''),(1796,'1','274','1',1,'Retail Sale Id 1763',9002.40,0.00,0.00,12.10,992.20,'2022-06-30 07:54:18','',''),(1797,'1','274','1',1,'Retail Sale Id 1764',2246.88,0.00,0.00,3.02,247.64,'2022-06-30 07:55:25','',''),(1798,'1','274','1',1,'Retail Sale Id 1765',9300.00,0.00,0.00,12.50,1025.00,'2022-06-30 08:14:59','',''),(1799,'1','274','1',1,'Retail Sale Id 1766',4501.20,0.00,0.00,6.05,496.10,'2022-06-30 08:17:20','',''),(1800,'1','274','1',1,'Retail Sale Id 1767',18600.00,0.00,0.00,25.00,2050.00,'2022-06-30 08:26:01','',''),(1801,'1','274','1',1,'Retail Sale Id 1768',8496.48,0.00,0.00,11.42,936.44,'2022-06-30 08:45:08','',''),(1802,'1','274','1',1,'Retail Sale Id 1769',8250.96,0.00,0.00,11.09,909.38,'2022-06-30 08:50:53','',''),(1803,'1','274','1',1,'Retail Sale Id 1770',2001.36,0.00,0.00,2.69,220.58,'2022-06-30 09:01:18','',''),(1804,'1','274','1',1,'Retail Sale Id 1771',4501.20,0.00,0.00,6.05,496.10,'2022-06-30 09:02:20','',''),(1805,'1','274','1',1,'Retail Sale Id 1772',9300.00,0.00,0.00,12.50,1025.00,'2022-06-30 09:04:32','',''),(1806,'1','274','1',1,'Retail Sale Id 1773',4501.20,0.00,0.00,6.05,496.10,'2022-06-30 09:11:12','',''),(1807,'1','274','1',1,'Retail Sale Id 1774',1502.88,0.00,0.00,2.02,165.64,'2022-06-30 09:12:24','',''),(1808,'1','274','1',1,'Retail Sale Id 1775',18600.00,0.00,0.00,25.00,2050.00,'2022-06-30 09:24:11','',''),(1809,'1','274','1',1,'Retail Sale Id 1776',37200.00,0.00,0.00,50.00,4100.00,'2022-06-30 12:32:33','',''),(1810,'1','274','1',1,'Retail Sale Id 1777',18600.00,0.00,0.00,25.00,2050.00,'2022-06-30 12:44:58','',''),(1811,'1','274','1',1,'Retail Sale Id 1778',9300.00,0.00,0.00,12.50,1025.00,'2022-06-30 12:58:22','',''),(1812,'1','274','1',1,'Retail Sale Id 1779',13801.20,0.00,0.00,18.55,1521.10,'2022-06-30 13:49:23','',''),(1813,'1','274','1',1,'Retail Sale Id 1780',4501.20,0.00,0.00,6.05,496.10,'2022-06-30 14:24:29','',''),(1814,'1','274','1',1,'Retail Sale Id 1781',1502.88,0.00,0.00,2.02,165.64,'2022-06-30 15:58:36','',''),(1815,'1','274','1',1,'Retail Sale Id 1782',2998.32,0.00,0.00,4.03,330.46,'2022-06-30 16:19:16','',''),(1816,'1','274','1',1,'Retail Sale Id 1783',4501.20,0.00,0.00,6.05,496.10,'2022-06-30 16:19:57','',''),(1817,'1','274','1',1,'Retail Sale Id 1784',1696.32,0.00,0.00,2.28,186.96,'2022-06-30 17:28:34','',''),(1818,'1','274','1',1,'Retail Sale Id 1785',9300.00,0.00,0.00,12.50,1025.00,'2022-06-30 17:56:07','',''),(1819,'1','274','1',1,'Retail Sale Id 1786',13801.20,0.00,0.00,18.55,1521.10,'2022-06-30 17:59:25','',''),(1820,'1','274','1',1,'Retail Sale Id 1787',4501.20,0.00,0.00,6.05,496.10,'2022-06-30 18:04:26','',''),(1821,'1','274','1',1,'Retail Sale Id 1788',16368.00,0.00,0.00,22.00,1804.00,'2022-06-30 19:04:58','',''),(1822,'1','274','1',1,'Retail Sale Id 1789',55703.28,0.00,0.00,74.87,6139.34,'2022-06-30 19:45:40','',''),(1823,'1','274','1',1,'Retail Sale Id 1789',82420.32,0.00,0.00,110.78,9083.96,'2022-06-30 19:45:40','',''),(1824,'1','274','1',1,'Retail Sale Id 1790',4501.20,0.00,0.00,6.05,496.10,'2022-07-01 07:43:10','',''),(1825,'1','274','1',1,'Retail Sale Id 1791',9300.00,0.00,0.00,12.50,1025.00,'2022-07-01 08:11:05','',''),(1826,'1','274','1',1,'Retail Sale Id 1792',111600.00,0.00,0.00,150.00,12300.00,'2022-07-01 08:14:00','',''),(1827,'1','274','1',1,'Retail Sale Id 1793',4501.20,0.00,0.00,6.05,496.10,'2022-07-01 08:15:16','',''),(1828,'1','274','1',1,'Retail Sale Id 1794',4999.68,0.00,0.00,6.72,551.04,'2022-07-01 08:27:24','',''),(1829,'1','274','1',1,'Retail Sale Id 1796',46500.00,0.00,0.00,62.50,5125.00,'2022-07-01 08:47:30','',''),(1830,'1','274','1',1,'Retail Sale Id 1797',4002.72,0.00,0.00,5.38,441.16,'2022-07-01 08:57:38','',''),(1831,'1','274','1',1,'Retail Sale Id 1798',9300.00,0.00,0.00,12.50,1025.00,'2022-07-01 09:23:03','',''),(1832,'1','274','1',1,'Retail Sale Id 1799',2001.36,0.00,0.00,2.69,220.58,'2022-07-01 09:25:28','',''),(1833,'1','274','1',1,'Retail Sale Id 1800',2998.32,0.00,0.00,4.03,330.46,'2022-07-01 09:32:08','',''),(1834,'1','274','1',1,'Retail Sale Id 1801',9300.00,0.00,0.00,12.50,1025.00,'2022-07-01 09:38:11','',''),(1835,'1','274','1',1,'Retail Sale Id 1802',4501.20,0.00,0.00,6.05,496.10,'2022-07-01 10:06:16','',''),(1836,'1','274','1',1,'Retail Sale Id 1803',2499.84,0.00,0.00,3.36,275.52,'2022-07-01 11:03:53','',''),(1837,'1','274','1',1,'Retail Sale Id 1804',1599.60,0.00,0.00,2.15,176.30,'2022-07-01 11:08:41','',''),(1838,'1','274','1',1,'Retail Sale Id 1806',4464.00,0.00,0.00,6.00,492.00,'2022-07-01 12:02:46','',''),(1839,'1','274','1',1,'Retail Sale Id 1807',2499.84,0.00,0.00,3.36,275.52,'2022-07-01 13:07:33','',''),(1840,'1','274','1',1,'Retail Sale Id 1808',10296.96,0.00,0.00,13.84,1134.88,'2022-07-01 14:07:26','',''),(1841,'1','274','1',1,'Retail Sale Id 1809',9300.00,0.00,0.00,12.50,1025.00,'2022-07-01 14:08:22','',''),(1842,'1','274','1',1,'Retail Sale Id 1810',14880.00,0.00,0.00,20.00,1640.00,'2022-07-01 14:19:10','',''),(1843,'1','274','1',1,'Retail Sale Id 1811',29760.00,0.00,0.00,40.00,3280.00,'2022-07-01 14:34:33','',''),(1844,'1','274','1',1,'Retail Sale Id 1812',7998.00,0.00,0.00,10.75,881.50,'2022-07-01 14:37:02','',''),(1845,'1','274','1',1,'Retail Sale Id 1813',2998.32,0.00,0.00,4.03,330.46,'2022-07-01 14:37:42','',''),(1846,'1','274','1',1,'Retail Sale Id 1814',9300.00,0.00,0.00,12.50,1025.00,'2022-07-01 14:57:08','',''),(1847,'1','274','1',1,'Retail Sale Id 1816',18600.00,0.00,0.00,25.00,2050.00,'2022-07-01 15:25:44','',''),(1848,'1','274','1',1,'Retail Sale Id 1817',1502.88,0.00,0.00,2.02,165.64,'2022-07-01 15:44:35','',''),(1849,'1','274','1',1,'Retail Sale Id 1818',2246.88,0.00,0.00,3.02,247.64,'2022-07-01 15:54:36','',''),(1850,'1','274','1',1,'Retail Sale Id 1819',1502.88,0.00,0.00,2.02,165.64,'2022-07-01 15:56:08','',''),(1851,'1','274','1',1,'Retail Sale Id 1820',2246.88,0.00,0.00,3.02,247.64,'2022-07-01 16:14:06','',''),(1852,'1','274','1',1,'Retail Sale Id 1821',4501.20,0.00,0.00,6.05,496.10,'2022-07-01 16:34:03','',''),(1853,'1','274','1',1,'Retail Sale Id 1822',2001.36,0.00,0.00,2.69,220.58,'2022-07-01 16:52:31','',''),(1854,'1','274','1',1,'Retail Sale Id 1823',2001.36,0.00,0.00,2.69,220.58,'2022-07-01 17:06:14','',''),(1855,'1','274','1',1,'Retail Sale Id 1824',3801.84,0.00,0.00,5.11,419.02,'2022-07-01 17:13:49','',''),(1856,'1','274','1',1,'Retail Sale Id 1825',803.52,0.00,0.00,1.08,88.56,'2022-07-01 17:17:12','',''),(1857,'1','274','1',1,'Retail Sale Id 1826',9300.00,0.00,0.00,12.50,1025.00,'2022-07-01 17:30:12','',''),(1858,'1','274','1',1,'Retail Sale Id 1827',2998.32,0.00,0.00,4.03,330.46,'2022-07-01 17:34:08','',''),(1859,'1','274','1',1,'Retail Sale Id 1828',2998.32,0.00,0.00,4.03,330.46,'2022-07-01 17:35:00','',''),(1860,'1','274','1',1,'Retail Sale Id 1829',2298.96,0.00,0.00,3.09,253.38,'2022-07-01 17:53:30','',''),(1861,'1','274','1',1,'Retail Sale Id 1830',4501.20,0.00,0.00,6.05,496.10,'2022-07-01 17:57:59','',''),(1862,'1','274','1',1,'Retail Sale Id 1831',5200.56,0.00,0.00,6.99,573.18,'2022-07-01 17:58:55','',''),(1863,'1','274','1',1,'Retail Sale Id 1832',3749.76,0.00,0.00,5.04,413.28,'2022-07-01 18:07:47','',''),(1864,'1','274','1',1,'Retail Sale Id 1833',9300.00,0.00,0.00,12.50,1025.00,'2022-07-01 18:09:27','',''),(1865,'1','274','1',1,'Retail Sale Id 1834',37200.00,0.00,0.00,50.00,4100.00,'2022-07-01 18:13:43','',''),(1866,'1','274','1',1,'Retail Sale Id 1835',4999.68,0.00,0.00,6.72,551.04,'2022-07-01 18:14:47','',''),(1867,'1','274','1',1,'Retail Sale Id 1836',996.96,0.00,0.00,1.34,109.88,'2022-07-01 18:20:52','',''),(1868,'1','274','1',1,'Retail Sale Id 1837',2001.36,0.00,0.00,2.69,220.58,'2022-07-01 18:27:19','',''),(1869,'1','274','1',1,'Retail Sale Id 1838',9300.00,0.00,0.00,12.50,1025.00,'2022-07-01 18:31:50','',''),(1870,'1','274','1',1,'Retail Sale Id 1839',16368.00,0.00,0.00,22.00,1804.00,'2022-07-01 18:39:17','',''),(1871,'1','274','1',1,'Return of Retail Sale Id 1819',0.00,1502.88,2.02,0.00,-165.64,'2022-07-01 19:20:05','',''),(1872,'1','274','1',1,'Retail Sale Id 1840',1168.08,0.00,0.00,1.57,128.74,'2022-07-01 19:22:05','',''),(1873,'1','274','1',1,'Retail Sale Id 1840',36649.44,0.00,0.00,49.26,4039.32,'2022-07-01 19:22:05','',''),(1874,'1','274','1',1,'Retail Sale Id 1841',2001.36,0.00,0.00,2.69,220.58,'2022-07-02 07:26:48','',''),(1875,'1','274','1',1,'Retail Sale Id 1842',9300.00,0.00,0.00,12.50,1025.00,'2022-07-02 07:33:33','',''),(1876,'1','274','1',1,'Retail Sale Id 1843',4501.20,0.00,0.00,6.05,496.10,'2022-07-02 07:47:19','',''),(1877,'1','274','1',1,'Retail Sale Id 1844',996.96,0.00,0.00,1.34,109.88,'2022-07-02 08:03:36','',''),(1878,'1','274','1',1,'Retail Sale Id 1846',9300.00,0.00,0.00,12.50,1025.00,'2022-07-02 08:59:28','',''),(1879,'1','274','1',1,'Retail Sale Id 1847',37200.00,0.00,0.00,50.00,4100.00,'2022-07-02 09:03:43','',''),(1880,'1','274','1',1,'Retail Sale Id 1848',2001.36,0.00,0.00,2.69,220.58,'2022-07-02 09:05:18','',''),(1881,'1','274','1',1,'Retail Sale Id 1849',4501.20,0.00,0.00,6.05,496.10,'2022-07-02 10:40:24','',''),(1882,'1','274','1',1,'Retail Sale Id 1850',9300.00,0.00,0.00,12.50,1025.00,'2022-07-02 10:46:27','',''),(1883,'1','274','1',1,'Retail Sale Id 1851',1502.88,0.00,0.00,2.02,165.64,'2022-07-02 11:21:26','',''),(1884,'1','274','1',1,'Retail Sale Id 1852',1502.88,0.00,0.00,2.02,165.64,'2022-07-02 11:42:51','',''),(1885,'1','274','1',1,'Retail Sale Id 1853',2001.36,0.00,0.00,2.69,220.58,'2022-07-02 11:50:21','',''),(1886,'1','274','1',1,'Retail Sale Id 1854',2246.88,0.00,0.00,3.02,247.64,'2022-07-02 12:12:41','',''),(1887,'1','274','1',1,'Retail Sale Id 1855',4002.72,0.00,0.00,5.38,441.16,'2022-07-02 12:14:40','',''),(1888,'1','274','1',1,'Retail Sale Id 1856',9300.00,0.00,0.00,12.50,1025.00,'2022-07-02 12:28:13','',''),(1889,'1','274','1',1,'Retail Sale Id 1857',9300.00,0.00,0.00,12.50,1025.00,'2022-07-02 12:29:34','',''),(1890,'1','274','1',1,'Retail Sale Id 1858',3496.80,0.00,0.00,4.70,385.40,'2022-07-02 12:31:34','',''),(1891,'1','274','1',1,'Retail Sale Id 1859',9300.00,0.00,0.00,12.50,1025.00,'2022-07-02 12:42:19','',''),(1892,'1','274','1',1,'Retail Sale Id 1860',9300.00,0.00,0.00,12.50,1025.00,'2022-07-02 12:44:21','',''),(1893,'1','274','1',1,'Retail Sale Id 1861',4501.20,0.00,0.00,6.05,496.10,'2022-07-02 12:54:01','',''),(1894,'1','274','1',1,'Retail Sale Id 1862',4999.68,0.00,0.00,6.72,551.04,'2022-07-02 13:24:06','',''),(1895,'1','274','1',1,'Retail Sale Id 1863',4002.72,0.00,0.00,5.38,441.16,'2022-07-02 13:26:44','',''),(1896,'1','274','1',1,'Retail Sale Id 1864',6748.08,0.00,0.00,9.07,743.74,'2022-07-02 13:33:21','',''),(1897,'1','274','1',1,'Retail Sale Id 1865',18600.00,0.00,0.00,25.00,2050.00,'2022-07-02 14:04:35','',''),(1898,'1','274','1',1,'Retail Sale Id 1866',2246.88,0.00,0.00,3.02,247.64,'2022-07-02 14:06:04','',''),(1899,'1','274','1',1,'Retail Sale Id 1867',1502.88,0.00,0.00,2.02,165.64,'2022-07-02 16:54:01','',''),(1900,'1','274','1',1,'Retail Sale Id 1868',9300.00,0.00,0.00,12.50,1025.00,'2022-07-02 17:15:57','',''),(1901,'1','274','1',1,'Retail Sale Id 1869',1502.88,0.00,0.00,2.02,165.64,'2022-07-02 17:18:22','',''),(1902,'1','274','1',1,'Retail Sale Id 1870',4501.20,0.00,0.00,6.05,496.10,'2022-07-02 17:20:31','',''),(1903,'1','274','1',1,'Retail Sale Id 1871',4501.20,0.00,0.00,6.05,496.10,'2022-07-02 17:23:59','',''),(1904,'1','274','1',1,'Retail Sale Id 1872',996.96,0.00,0.00,1.34,109.88,'2022-07-02 17:25:32','',''),(1905,'1','274','1',1,'Retail Sale Id 1873',4002.72,0.00,0.00,5.38,441.16,'2022-07-02 17:35:29','',''),(1906,'1','274','1',1,'Retail Sale Id 1874',4501.20,0.00,0.00,6.05,496.10,'2022-07-02 17:36:40','',''),(1907,'1','274','1',1,'Retail Sale Id 1875',2998.32,0.00,0.00,4.03,330.46,'2022-07-02 17:38:16','',''),(1908,'1','274','1',1,'Retail Sale Id 1876',4999.68,0.00,0.00,6.72,551.04,'2022-07-02 17:41:18','',''),(1909,'1','274','1',1,'Retail Sale Id 1877',2246.88,0.00,0.00,3.02,247.64,'2022-07-02 17:46:39','',''),(1910,'1','274','1',1,'Retail Sale Id 1878',996.96,0.00,0.00,1.34,109.88,'2022-07-02 17:49:59','',''),(1911,'1','274','1',1,'Retail Sale Id 1879',9300.00,0.00,0.00,12.50,1025.00,'2022-07-02 17:52:24','',''),(1912,'1','274','1',1,'Retail Sale Id 1880',9300.00,0.00,0.00,12.50,1025.00,'2022-07-02 17:55:28','',''),(1913,'1','274','1',1,'Retail Sale Id 1881',2246.88,0.00,0.00,3.02,247.64,'2022-07-02 17:58:16','',''),(1914,'1','274','1',1,'Retail Sale Id 1882',2001.36,0.00,0.00,2.69,220.58,'2022-07-02 17:59:02','',''),(1915,'1','274','1',1,'Retail Sale Id 1884',4002.72,0.00,0.00,5.38,441.16,'2022-07-02 18:09:08','',''),(1916,'1','274','1',1,'Retail Sale Id 1885',4002.72,0.00,0.00,5.38,441.16,'2022-07-02 18:10:02','',''),(1917,'1','274','1',1,'Retail Sale Id 1886',2246.88,0.00,0.00,3.02,247.64,'2022-07-02 18:13:49','',''),(1918,'1','274','1',1,'Retail Sale Id 1887',16368.00,0.00,0.00,22.00,1804.00,'2022-07-02 18:14:35','',''),(1919,'1','274','1',1,'Retail Sale Id 1888',4999.68,0.00,0.00,6.72,551.04,'2022-07-02 18:35:13','',''),(1920,'1','274','1',1,'Retail Sale Id 1889',3496.80,0.00,0.00,4.70,385.40,'2022-07-02 18:42:48','',''),(1921,'1','274','1',1,'Retail Sale Id 1890',2998.32,0.00,0.00,4.03,330.46,'2022-07-02 18:44:29','',''),(1922,'1','274','1',1,'Retail Sale Id 1891',9300.00,0.00,0.00,12.50,1025.00,'2022-07-02 18:57:35','',''),(1923,'1','274','1',1,'Retail Sale Id 1892',3801.84,0.00,0.00,5.11,419.02,'2022-07-02 19:01:40','',''),(1924,'1','274','1',1,'Retail Sale Id 1893',2998.32,0.00,0.00,4.03,330.46,'2022-07-02 19:02:47','',''),(1925,'1','274','1',1,'Retail Sale Id 1894',37200.00,0.00,0.00,50.00,4100.00,'2022-07-02 19:21:56','',''),(1926,'1','274','1',1,'Retail Sale Id 1895',9300.00,0.00,0.00,12.50,1025.00,'2022-07-02 19:24:14','',''),(1927,'1','274','1',1,'Retail Sale Id 1896',2499.84,0.00,0.00,3.36,275.52,'2022-07-02 19:29:55','',''),(1928,'1','274','1',1,'Retail Sale Id 1897',50733.36,0.00,0.00,68.19,5591.58,'2022-07-02 20:03:13','',''),(1929,'1','274','1',1,'Retail Sale Id 1897',69601.20,0.00,0.00,93.55,7671.10,'2022-07-02 20:03:13','',''),(1930,'1','274','1',1,'Retail Sale Id 1898',4501.20,0.00,0.00,6.05,496.10,'2022-07-03 06:32:26','',''),(1931,'1','274','1',1,'Retail Sale Id 1899',4501.20,0.00,0.00,6.05,496.10,'2022-07-03 06:42:27','',''),(1932,'1','274','1',1,'Retail Sale Id 1900',1502.88,0.00,0.00,2.02,165.64,'2022-07-03 07:08:48','',''),(1933,'1','274','1',1,'Retail Sale Id 1901',9300.00,0.00,0.00,12.50,1025.00,'2022-07-03 07:11:58','',''),(1934,'1','274','1',1,'Retail Sale Id 1902',1502.88,0.00,0.00,2.02,165.64,'2022-07-03 07:40:08','',''),(1935,'1','274','1',1,'Retail Sale Id 1903',2499.84,0.00,0.00,3.36,275.52,'2022-07-03 07:41:43','',''),(1936,'1','274','1',1,'Retail Sale Id 1904',2001.36,0.00,0.00,2.69,220.58,'2022-07-03 07:42:39','',''),(1937,'1','274','1',1,'Retail Sale Id 1905',2998.32,0.00,0.00,4.03,330.46,'2022-07-03 07:46:34','',''),(1938,'1','274','1',1,'Retail Sale Id 1906',2998.32,0.00,0.00,4.03,330.46,'2022-07-03 07:47:46','',''),(1939,'1','274','1',1,'Retail Sale Id 1907',9300.00,0.00,0.00,12.50,1025.00,'2022-07-03 07:52:21','',''),(1940,'1','274','1',1,'Retail Sale Id 1908',2001.36,0.00,0.00,2.69,220.58,'2022-07-03 08:03:08','',''),(1941,'1','274','1',1,'Retail Sale Id 1909',1502.88,0.00,0.00,2.02,165.64,'2022-07-03 08:04:15','',''),(1942,'1','274','1',1,'Retail Sale Id 1910',2499.84,0.00,0.00,3.36,275.52,'2022-07-03 08:24:58','',''),(1943,'1','274','1',1,'Retail Sale Id 1911',4002.72,0.00,0.00,5.38,441.16,'2022-07-03 08:26:03','',''),(1944,'1','274','1',1,'Retail Sale Id 1912',9300.00,0.00,0.00,12.50,1025.00,'2022-07-03 08:58:02','',''),(1945,'1','274','1',1,'Retail Sale Id 1913',7499.52,0.00,0.00,10.08,826.56,'2022-07-03 09:03:30','',''),(1946,'1','274','1',1,'Retail Sale Id 1914',4002.72,0.00,0.00,5.38,441.16,'2022-07-03 09:06:57','',''),(1947,'1','274','1',1,'Retail Sale Id 1915',9300.00,0.00,0.00,12.50,1025.00,'2022-07-03 09:17:33','',''),(1948,'1','274','1',1,'Retail Sale Id 1916',9300.00,0.00,0.00,12.50,1025.00,'2022-07-03 09:28:29','',''),(1949,'1','274','1',1,'Retail Sale Id 1917',1502.88,0.00,0.00,2.02,165.64,'2022-07-03 09:30:14','',''),(1950,'1','274','1',1,'Retail Sale Id 1918',2246.88,0.00,0.00,3.02,247.64,'2022-07-03 09:31:52','',''),(1951,'1','274','1',1,'Retail Sale Id 1919',9300.00,0.00,0.00,12.50,1025.00,'2022-07-03 09:39:01','',''),(1952,'1','274','1',1,'Retail Sale Id 1920',12648.00,0.00,0.00,17.00,1394.00,'2022-07-03 09:43:46','',''),(1953,'1','274','1',1,'Retail Sale Id 1921',2246.88,0.00,0.00,3.02,247.64,'2022-07-03 09:56:04','',''),(1954,'1','274','1',1,'Retail Sale Id 1922',3749.76,0.00,0.00,5.04,413.28,'2022-07-03 09:58:52','',''),(1955,'1','274','1',1,'Retail Sale Id 1923',996.96,0.00,0.00,1.34,109.88,'2022-07-03 10:07:14','',''),(1956,'1','274','1',1,'Retail Sale Id 1924',4999.68,0.00,0.00,6.72,551.04,'2022-07-03 10:13:46','',''),(1957,'1','274','1',1,'Retail Sale Id 1925',4501.20,0.00,0.00,6.05,496.10,'2022-07-03 10:47:28','',''),(1958,'1','274','1',1,'Retail Sale Id 1926',9300.00,0.00,0.00,12.50,1025.00,'2022-07-03 10:56:12','',''),(1959,'1','274','1',1,'Retail Sale Id 1927',4501.20,0.00,0.00,6.05,496.10,'2022-07-03 10:58:37','',''),(1960,'1','274','1',1,'Retail Sale Id 1928',2001.36,0.00,0.00,2.69,220.58,'2022-07-03 10:59:37','',''),(1961,'1','274','1',1,'Retail Sale Id 1929',996.96,0.00,0.00,1.34,109.88,'2022-07-03 11:01:10','',''),(1962,'1','274','1',1,'Retail Sale Id 1930',2001.36,0.00,0.00,2.69,220.58,'2022-07-03 11:17:49','',''),(1963,'1','274','1',1,'Retail Sale Id 1931',3496.80,0.00,0.00,4.70,385.40,'2022-07-03 12:05:01','',''),(1964,'1','274','1',1,'Retail Sale Id 1932',3720.00,0.00,0.00,5.00,410.00,'2022-07-03 12:06:25','',''),(1965,'1','274','1',1,'Retail Sale Id 1933',996.96,0.00,0.00,1.34,109.88,'2022-07-03 12:07:39','',''),(1966,'1','274','1',1,'Retail Sale Id 1934',4501.20,0.00,0.00,6.05,496.10,'2022-07-03 12:12:45','',''),(1967,'1','274','1',1,'Retail Sale Id 1935',9300.00,0.00,0.00,12.50,1025.00,'2022-07-03 12:15:06','',''),(1968,'1','274','1',1,'Retail Sale Id 1936',5498.16,0.00,0.00,7.39,605.98,'2022-07-03 12:16:43','',''),(1969,'1','274','1',1,'Retail Sale Id 1937',9300.00,0.00,0.00,12.50,1025.00,'2022-07-03 12:25:20','',''),(1970,'1','274','1',1,'Retail Sale Id 1938',2298.96,0.00,0.00,3.09,253.38,'2022-07-03 12:28:38','',''),(1971,'1','274','1',1,'Retail Sale Id 1939',2998.32,0.00,0.00,4.03,330.46,'2022-07-03 12:33:04','',''),(1972,'1','274','1',1,'Retail Sale Id 1940',4501.20,0.00,0.00,6.05,496.10,'2022-07-03 12:38:53','',''),(1973,'1','274','1',1,'Retail Sale Id 1941',4002.72,0.00,0.00,5.38,441.16,'2022-07-03 12:40:54','',''),(1974,'1','274','1',1,'Retail Sale Id 1942',9300.00,0.00,0.00,12.50,1025.00,'2022-07-03 12:44:08','',''),(1975,'1','274','1',1,'Retail Sale Id 1943',2001.36,0.00,0.00,2.69,220.58,'2022-07-03 12:48:56','',''),(1976,'1','274','1',1,'Retail Sale Id 1944',18600.00,0.00,0.00,25.00,2050.00,'2022-07-03 13:25:46','',''),(1977,'1','274','1',1,'Retail Sale Id 1945',8496.48,0.00,0.00,11.42,936.44,'2022-07-03 13:27:20','',''),(1978,'1','274','1',1,'Retail Sale Id 1946',37200.00,0.00,0.00,50.00,4100.00,'2022-07-03 13:40:08','',''),(1979,'1','274','1',1,'Retail Sale Id 1947',3749.76,0.00,0.00,5.04,413.28,'2022-07-03 13:44:34','',''),(1980,'1','274','1',1,'Retail Sale Id 1948',2246.88,0.00,0.00,3.02,247.64,'2022-07-03 13:51:31','',''),(1981,'1','274','1',1,'Retail Sale Id 1949',1502.88,0.00,0.00,2.02,165.64,'2022-07-03 14:05:32','',''),(1982,'1','274','1',1,'Retail Sale Id 1950',9300.00,0.00,0.00,12.50,1025.00,'2022-07-03 14:06:49','',''),(1983,'1','274','1',1,'Retail Sale Id 1951',2246.88,0.00,0.00,3.02,247.64,'2022-07-03 14:21:19','',''),(1984,'1','274','1',1,'Retail Sale Id 1952',9300.00,0.00,0.00,12.50,1025.00,'2022-07-03 14:22:10','',''),(1985,'1','274','1',1,'Retail Sale Id 1953',1502.88,0.00,0.00,2.02,165.64,'2022-07-03 14:26:31','',''),(1986,'1','274','1',1,'Retail Sale Id 1954',4501.20,0.00,0.00,6.05,496.10,'2022-07-03 14:28:23','',''),(1987,'1','274','1',1,'Retail Sale Id 1955',46500.00,0.00,0.00,62.50,5125.00,'2022-07-03 14:30:36','',''),(1988,'1','274','1',1,'Retail Sale Id 1956',9300.00,0.00,0.00,12.50,1025.00,'2022-07-03 15:03:07','',''),(1989,'1','274','1',1,'Retail Sale Id 1957',6696.00,0.00,0.00,9.00,738.00,'2022-07-03 15:09:03','',''),(1990,'1','274','1',1,'Retail Sale Id 1958',3496.80,0.00,0.00,4.70,385.40,'2022-07-03 15:19:02','',''),(1991,'1','274','1',1,'Retail Sale Id 1959',37200.00,0.00,0.00,50.00,4100.00,'2022-07-03 15:29:06','',''),(1992,'1','274','1',1,'Retail Sale Id 1960',2001.36,0.00,0.00,2.69,220.58,'2022-07-03 15:38:50','',''),(1993,'1','274','1',1,'Retail Sale Id 1961',2998.32,0.00,0.00,4.03,330.46,'2022-07-03 15:46:12','',''),(1994,'1','274','1',1,'Retail Sale Id 1962',11160.00,0.00,0.00,15.00,1230.00,'2022-07-03 15:49:44','',''),(1995,'1','274','1',1,'Retail Sale Id 1963',2246.88,0.00,0.00,3.02,247.64,'2022-07-03 15:53:27','',''),(1996,'1','274','1',1,'Retail Sale Id 1965',4501.20,0.00,0.00,6.05,496.10,'2022-07-03 17:01:18','',''),(1997,'1','274','1',1,'Retail Sale Id 1966',4501.20,0.00,0.00,6.05,496.10,'2022-07-03 17:05:20','',''),(1998,'1','274','1',1,'Retail Sale Id 1967',4501.20,0.00,0.00,6.05,496.10,'2022-07-03 17:07:31','',''),(1999,'1','274','1',1,'Retail Sale Id 1968',2998.32,0.00,0.00,4.03,330.46,'2022-07-03 17:11:04','',''),(2000,'1','274','1',1,'Retail Sale Id 1969',3496.80,0.00,0.00,4.70,385.40,'2022-07-03 17:13:47','',''),(2001,'1','274','1',1,'Retail Sale Id 1970',9300.00,0.00,0.00,12.50,1025.00,'2022-07-03 17:17:53','',''),(2002,'1','274','1',1,'Retail Sale Id 1971',3199.20,0.00,0.00,4.30,352.60,'2022-07-03 17:24:12','',''),(2003,'1','274','1',1,'Retail Sale Id 1972',2246.88,0.00,0.00,3.02,247.64,'2022-07-03 17:34:48','',''),(2004,'1','274','1',1,'Retail Sale Id 1973',4501.20,0.00,0.00,6.05,496.10,'2022-07-03 17:43:26','',''),(2005,'1','274','1',1,'Retail Sale Id 1974',4002.72,0.00,0.00,5.38,441.16,'2022-07-03 17:47:39','',''),(2006,'1','274','1',1,'Retail Sale Id 1975',9300.00,0.00,0.00,12.50,1025.00,'2022-07-03 18:02:45','',''),(2007,'1','274','1',1,'Retail Sale Id 1976',751.44,0.00,0.00,1.01,82.82,'2022-07-03 18:21:48','',''),(2008,'1','274','1',1,'Retail Sale Id 1977',4002.72,0.00,0.00,5.38,441.16,'2022-07-03 18:33:43','',''),(2009,'1','274','1',1,'Retail Sale Id 1978',37200.00,0.00,0.00,50.00,4100.00,'2022-07-03 18:34:49','',''),(2010,'1','274','1',1,'Retail Sale Id 1979',4464.00,0.00,0.00,6.00,492.00,'2022-07-03 18:42:09','',''),(2011,'1','274','1',1,'Retail Sale Id 1980',2001.36,0.00,0.00,2.69,220.58,'2022-07-03 18:44:25','',''),(2012,'1','274','1',1,'Retail Sale Id 1981',751.44,0.00,0.00,1.01,82.82,'2022-07-03 19:23:04','',''),(2013,'1','274','1',1,'Retail Sale Id 1982',1279.68,0.00,0.00,1.72,141.04,'2022-07-03 20:01:21','',''),(2014,'1','274','1',1,'Retail Sale Id 1982',41061.36,0.00,0.00,55.19,4525.58,'2022-07-03 20:01:21','',''),(2015,'1','274','1',1,'Retail Sale Id 1983',8496.48,0.00,0.00,11.42,936.44,'2022-07-04 07:50:09','',''),(2016,'1','274','1',1,'Retail Sale Id 1984',2001.36,0.00,0.00,2.69,220.58,'2022-07-04 08:49:15','',''),(2017,'1','274','1',1,'Retail Sale Id 1985',9300.00,0.00,0.00,12.50,1025.00,'2022-07-04 08:57:02','',''),(2018,'1','274','1',1,'Retail Sale Id 1986',4501.20,0.00,0.00,6.05,496.10,'2022-07-04 09:06:31','',''),(2019,'1','274','1',1,'Retail Sale Id 1987',1502.88,0.00,0.00,2.02,165.64,'2022-07-04 09:11:34','',''),(2020,'1','274','1',1,'Retail Sale Id 1988',9300.00,0.00,0.00,12.50,1025.00,'2022-07-04 09:14:40','',''),(2021,'1','274','1',1,'Retail Sale Id 1989',2298.96,0.00,0.00,3.09,253.38,'2022-07-04 09:25:24','',''),(2022,'1','274','1',1,'Retail Sale Id 1990',9300.00,0.00,0.00,12.50,1025.00,'2022-07-04 09:33:17','',''),(2023,'1','274','1',1,'Retail Sale Id 1991',2499.84,0.00,0.00,3.36,275.52,'2022-07-04 09:36:55','',''),(2024,'1','274','1',1,'Retail Sale Id 1992',9672.00,0.00,0.00,13.00,1066.00,'2022-07-04 09:49:43','',''),(2025,'1','274','1',1,'Retail Sale Id 1993',4002.72,0.00,0.00,5.38,441.16,'2022-07-04 09:56:42','',''),(2026,'1','274','1',1,'Retail Sale Id 1994',2001.36,0.00,0.00,2.69,220.58,'2022-07-04 10:39:48','',''),(2027,'1','274','1',1,'Retail Sale Id 1995',751.44,0.00,0.00,1.01,82.82,'2022-07-04 10:41:17','',''),(2028,'1','274','1',1,'Retail Sale Id 1996',9300.00,0.00,0.00,12.50,1025.00,'2022-07-04 10:44:51','',''),(2029,'1','274','1',1,'Retail Sale Id 1997',4501.20,0.00,0.00,6.05,496.10,'2022-07-04 10:49:36','',''),(2030,'1','274','1',1,'Retail Sale Id 1998',4999.68,0.00,0.00,6.72,551.04,'2022-07-04 11:26:47','',''),(2031,'1','274','1',1,'Retail Sale Id 1999',2202.24,0.00,0.00,2.96,242.72,'2022-07-04 11:27:34','',''),(2032,'1','274','1',1,'Retail Sale Id 2000',3749.76,0.00,0.00,5.04,413.28,'2022-07-04 11:29:09','',''),(2033,'1','274','1',1,'Retail Sale Id 2001',16368.00,0.00,0.00,22.00,1804.00,'2022-07-04 11:42:50','',''),(2034,'1','274','1',1,'Retail Sale Id 2002',12997.68,0.00,0.00,17.47,1432.54,'2022-07-04 11:59:16','',''),(2035,'1','274','1',1,'Retail Sale Id 2003',9300.00,0.00,0.00,12.50,1025.00,'2022-07-04 12:02:44','',''),(2036,'1','274','1',1,'Retail Sale Id 2004',2998.32,0.00,0.00,4.03,330.46,'2022-07-04 12:04:28','',''),(2037,'1','274','1',1,'Retail Sale Id 2005',2298.96,0.00,0.00,3.09,253.38,'2022-07-04 12:13:31','',''),(2038,'1','274','1',1,'Retail Sale Id 2006',9002.40,0.00,0.00,12.10,992.20,'2022-07-04 12:34:42','',''),(2039,'1','274','1',1,'Retail Sale Id 2007',2998.32,0.00,0.00,4.03,330.46,'2022-07-04 12:40:15','',''),(2040,'1','274','1',1,'Retail Sale Id 2008',9300.00,0.00,0.00,12.50,1025.00,'2022-07-04 12:47:45','',''),(2041,'1','274','1',1,'Retail Sale Id 2009',14880.00,0.00,0.00,20.00,1640.00,'2022-07-04 12:53:27','',''),(2042,'1','274','1',1,'Retail Sale Id 2010',74400.00,0.00,0.00,100.00,8200.00,'2022-07-04 12:58:56','',''),(2043,'1','274','1',1,'Retail Sale Id 2011',9300.00,0.00,0.00,12.50,1025.00,'2022-07-04 13:05:47','',''),(2044,'1','274','1',1,'Retail Sale Id 2012',9300.00,0.00,0.00,12.50,1025.00,'2022-07-04 13:18:59','',''),(2045,'1','274','1',1,'Retail Sale Id 2013',9300.00,0.00,0.00,12.50,1025.00,'2022-07-04 13:20:56','',''),(2046,'1','274','1',1,'Retail Sale Id 2014',1502.88,0.00,0.00,2.02,165.64,'2022-07-04 13:59:36','',''),(2047,'1','274','1',1,'Retail Sale Id 2015',9300.00,0.00,0.00,12.50,1025.00,'2022-07-04 14:04:46','',''),(2048,'1','274','1',1,'Retail Sale Id 2016',2246.88,0.00,0.00,3.02,247.64,'2022-07-04 14:07:29','',''),(2049,'1','274','1',1,'Retail Sale Id 2017',18600.00,0.00,0.00,25.00,2050.00,'2022-07-04 14:19:28','',''),(2050,'1','274','1',1,'Retail Sale Id 2018',10051.44,0.00,0.00,13.51,1107.82,'2022-07-04 14:27:13','',''),(2051,'1','274','1',1,'Return of Retail Sale Id 2018',0.00,10051.44,13.51,0.00,-1107.82,'2022-07-04 14:28:46','',''),(2052,'1','274','1',1,'Retail Sale Id 2019',2246.88,0.00,0.00,3.02,247.64,'2022-07-04 14:29:22','',''),(2053,'1','274','1',1,'Retail Sale Id 2020',13049.76,0.00,0.00,17.54,1438.28,'2022-07-04 14:30:35','',''),(2054,'1','274','1',1,'Retail Sale Id 2021',2001.36,0.00,0.00,2.69,220.58,'2022-07-04 14:31:52','',''),(2055,'1','274','1',1,'Retail Sale Id 2022',7499.52,0.00,0.00,10.08,826.56,'2022-07-04 14:36:48','',''),(2056,'1','274','1',1,'Retail Sale Id 2023',4501.20,0.00,0.00,6.05,496.10,'2022-07-04 14:37:55','',''),(2057,'1','274','1',1,'Retail Sale Id 2024',9300.00,0.00,0.00,12.50,1025.00,'2022-07-04 14:39:48','',''),(2058,'1','274','1',1,'Retail Sale Id 2025',2001.36,0.00,0.00,2.69,220.58,'2022-07-04 14:59:59','',''),(2059,'1','274','1',1,'Retail Sale Id 2026',9300.00,0.00,0.00,12.50,1025.00,'2022-07-04 15:50:20','',''),(2060,'1','274','1',1,'Retail Sale Id 2027',4999.68,0.00,0.00,6.72,551.04,'2022-07-04 15:56:02','',''),(2061,'1','274','1',1,'Retail Sale Id 2028',996.96,0.00,0.00,1.34,109.88,'2022-07-04 16:57:43','',''),(2062,'1','274','1',1,'Retail Sale Id 2029',2246.88,0.00,0.00,3.02,247.64,'2022-07-04 17:02:05','',''),(2063,'1','274','1',1,'Retail Sale Id 2030',2499.84,0.00,0.00,3.36,275.52,'2022-07-04 17:04:42','',''),(2064,'1','274','1',1,'Retail Sale Id 2031',4501.20,0.00,0.00,6.05,496.10,'2022-07-04 17:42:38','',''),(2065,'1','274','1',1,'Retail Sale Id 2032',4999.68,0.00,0.00,6.72,551.04,'2022-07-04 17:44:00','',''),(2066,'1','274','1',1,'Retail Sale Id 2033',9300.00,0.00,0.00,12.50,1025.00,'2022-07-04 18:11:48','',''),(2067,'1','274','1',1,'Retail Sale Id 2034',2001.36,0.00,0.00,2.69,220.58,'2022-07-04 18:12:34','',''),(2068,'1','274','1',1,'Retail Sale Id 2035',4501.20,0.00,0.00,6.05,496.10,'2022-07-04 18:14:03','',''),(2069,'1','274','1',1,'Retail Sale Id 2036',9300.00,0.00,0.00,12.50,1025.00,'2022-07-04 18:18:36','',''),(2070,'1','274','1',1,'Retail Sale Id 2037',4501.20,0.00,0.00,6.05,496.10,'2022-07-04 18:21:15','',''),(2071,'1','274','1',1,'Retail Sale Id 2038',1502.88,0.00,0.00,2.02,165.64,'2022-07-04 18:25:56','',''),(2072,'1','274','1',1,'Retail Sale Id 2039',4501.20,0.00,0.00,6.05,496.10,'2022-07-04 18:37:28','',''),(2073,'1','274','1',1,'Retail Sale Id 2040',2202.24,0.00,0.00,2.96,242.72,'2022-07-04 18:38:47','',''),(2074,'1','274','1',1,'Retail Sale Id 2041',2246.88,0.00,0.00,3.02,247.64,'2022-07-04 18:40:28','',''),(2075,'1','274','1',1,'Retail Sale Id 2042',9300.00,0.00,0.00,12.50,1025.00,'2022-07-04 18:41:41','',''),(2076,'1','274','1',1,'Retail Sale Id 2043',9300.00,0.00,0.00,12.50,1025.00,'2022-07-04 18:43:15','',''),(2077,'1','274','1',1,'Retail Sale Id 2045',2499.84,0.00,0.00,3.36,275.52,'2022-07-04 19:09:42','',''),(2078,'1','274','1',1,'Return of Retail Sale Id 2043',0.00,9300.00,12.50,0.00,-1025.00,'2022-07-04 19:52:24','',''),(2079,'1','274','1',1,'Retail Sale Id 2046',3876.24,0.00,0.00,5.21,427.22,'2022-07-04 19:54:23','',''),(2080,'1','274','1',1,'Retail Sale Id 2046',46500.00,0.00,0.00,62.50,5125.00,'2022-07-04 19:54:23','',''),(2081,'1','274','1',1,'Retail Sale Id 2047',7001.04,0.00,0.00,9.41,771.62,'2022-07-05 06:29:59','',''),(2082,'1','274','1',1,'Retail Sale Id 2048',9002.40,0.00,0.00,12.10,992.20,'2022-07-05 07:47:00','',''),(2083,'1','274','1',1,'Retail Sale Id 2049',7001.04,0.00,0.00,9.41,771.62,'2022-07-05 08:22:09','',''),(2084,'1','274','1',1,'Retail Sale Id 2050',3720.00,0.00,0.00,5.00,410.00,'2022-07-05 08:28:33','',''),(2085,'1','274','1',1,'Retail Sale Id 2050',18600.00,0.00,0.00,25.00,2050.00,'2022-07-05 08:28:33','',''),(2086,'1','274','1',1,'Retail Sale Id 2051',9300.00,0.00,0.00,12.50,1025.00,'2022-07-05 08:54:48','',''),(2087,'1','274','1',1,'Retail Sale Id 2052',4501.20,0.00,0.00,6.05,496.10,'2022-07-05 09:07:11','',''),(2088,'1','274','1',1,'Retail Sale Id 2053',3496.80,0.00,0.00,4.70,385.40,'2022-07-05 09:16:29','',''),(2089,'1','274','1',1,'Retail Sale Id 2055',1502.88,0.00,0.00,2.02,165.64,'2022-07-05 09:17:58','',''),(2090,'1','274','1',1,'Retail Sale Id 2056',9300.00,0.00,0.00,12.50,1025.00,'2022-07-05 09:23:38','',''),(2091,'1','274','1',1,'Retail Sale Id 2057',3697.68,0.00,0.00,4.97,407.54,'2022-07-05 09:26:23','',''),(2092,'1','274','1',1,'Retail Sale Id 2058',7998.00,0.00,0.00,10.75,881.50,'2022-07-05 09:27:34','',''),(2093,'1','274','1',1,'Retail Sale Id 2059',9300.00,0.00,0.00,12.50,1025.00,'2022-07-05 09:34:55','',''),(2094,'1','274','1',1,'Retail Sale Id 2060',8303.04,0.00,0.00,11.16,915.12,'2022-07-05 09:51:04','',''),(2095,'1','274','1',1,'Retail Sale Id 2061',9300.00,0.00,0.00,12.50,1025.00,'2022-07-05 10:17:51','',''),(2096,'1','274','1',1,'Retail Sale Id 2062',4501.20,0.00,0.00,6.05,496.10,'2022-07-05 10:23:05','',''),(2097,'1','274','1',1,'Retail Sale Id 2063',9300.00,0.00,0.00,12.50,1025.00,'2022-07-05 11:00:42','',''),(2098,'1','274','1',1,'Retail Sale Id 2064',803.52,0.00,0.00,1.08,88.56,'2022-07-05 11:26:46','',''),(2099,'1','274','1',1,'Retail Sale Id 2065',4002.72,0.00,0.00,5.38,441.16,'2022-07-05 11:40:44','',''),(2100,'1','274','1',1,'Retail Sale Id 2066',9300.00,0.00,0.00,12.50,1025.00,'2022-07-05 11:50:14','',''),(2101,'1','274','1',1,'Retail Sale Id 2067',2001.36,0.00,0.00,2.69,220.58,'2022-07-05 11:57:22','',''),(2102,'1','274','1',1,'Retail Sale Id 2068',2998.32,0.00,0.00,4.03,330.46,'2022-07-05 13:18:03','',''),(2103,'1','274','1',1,'Retail Sale Id 2069',2998.32,0.00,0.00,4.03,330.46,'2022-07-05 13:24:40','',''),(2104,'1','274','1',1,'Retail Sale Id 2070',9300.00,0.00,0.00,12.50,1025.00,'2022-07-05 13:25:37','',''),(2105,'1','274','1',1,'Retail Sale Id 2071',33480.00,0.00,0.00,45.00,3690.00,'2022-07-05 13:26:49','',''),(2106,'1','274','1',1,'Retail Sale Id 2072',17997.36,0.00,0.00,24.19,1983.58,'2022-07-05 13:42:44','',''),(2107,'1','274','1',1,'Retail Sale Id 2073',3749.76,0.00,0.00,5.04,413.28,'2022-07-05 14:28:48','',''),(2108,'1','274','1',1,'Retail Sale Id 2074',803.52,0.00,0.00,1.08,88.56,'2022-07-05 14:52:49','',''),(2109,'1','274','1',1,'Retail Sale Id 2075',3496.80,0.00,0.00,4.70,385.40,'2022-07-05 14:57:27','',''),(2110,'1','274','1',1,'Retail Sale Id 2076',2001.36,0.00,0.00,2.69,220.58,'2022-07-05 15:04:08','',''),(2111,'1','274','1',1,'Retail Sale Id 2077',2998.32,0.00,0.00,4.03,330.46,'2022-07-05 15:29:40','',''),(2112,'1','274','1',1,'Retail Sale Id 2078',9300.00,0.00,0.00,12.50,1025.00,'2022-07-05 15:32:07','',''),(2113,'1','274','1',1,'Retail Sale Id 2079',2246.88,0.00,0.00,3.02,247.64,'2022-07-05 16:49:17','',''),(2114,'1','274','1',1,'Retail Sale Id 2080',4501.20,0.00,0.00,6.05,496.10,'2022-07-05 16:56:23','',''),(2115,'1','274','1',1,'Retail Sale Id 2081',2998.32,0.00,0.00,4.03,330.46,'2022-07-05 16:57:46','',''),(2116,'1','274','1',1,'Retail Sale Id 2082',2246.88,0.00,0.00,3.02,247.64,'2022-07-05 17:12:56','',''),(2117,'1','274','1',1,'Retail Sale Id 2083',9300.00,0.00,0.00,12.50,1025.00,'2022-07-05 17:14:03','',''),(2118,'1','274','1',1,'Retail Sale Id 2084',13801.20,0.00,0.00,18.55,1521.10,'2022-07-05 17:19:44','',''),(2119,'1','274','1',1,'Retail Sale Id 2085',2001.36,0.00,0.00,2.69,220.58,'2022-07-05 17:23:09','',''),(2120,'1','274','1',1,'Retail Sale Id 2086',2001.36,0.00,0.00,2.69,220.58,'2022-07-05 17:30:13','',''),(2121,'1','274','1',1,'Retail Sale Id 2087',2246.88,0.00,0.00,3.02,247.64,'2022-07-05 17:32:23','',''),(2122,'1','274','1',1,'Retail Sale Id 2088',2246.88,0.00,0.00,3.02,247.64,'2022-07-05 18:06:04','',''),(2123,'1','274','1',1,'Retail Sale Id 2089',2998.32,0.00,0.00,4.03,330.46,'2022-07-05 18:12:21','',''),(2124,'1','274','1',1,'Retail Sale Id 2090',2998.32,0.00,0.00,4.03,330.46,'2022-07-05 18:13:45','',''),(2125,'1','274','1',1,'Retail Sale Id 2091',9300.00,0.00,0.00,12.50,1025.00,'2022-07-05 18:20:45','',''),(2126,'1','274','1',1,'Retail Sale Id 2092',9300.00,0.00,0.00,12.50,1025.00,'2022-07-05 18:47:46','',''),(2127,'1','274','1',1,'Retail Sale Id 2093',996.96,0.00,0.00,1.34,109.88,'2022-07-05 18:55:07','',''),(2128,'1','274','1',1,'Retail Sale Id 2094',47496.96,0.00,0.00,63.84,5234.88,'2022-07-05 19:50:55','',''),(2129,'1','274','1',1,'Return of Retail Sale Id 2094',0.00,47496.96,63.84,0.00,-5234.88,'2022-07-05 19:52:09','',''),(2130,'1','274','1',1,'Retail Sale Id 2095',46752.96,0.00,0.00,62.84,5152.88,'2022-07-05 19:53:33','',''),(2131,'1','274','1',1,'Retail Sale Id 2096',1502.88,0.00,0.00,2.02,165.64,'2022-07-06 07:20:07','',''),(2132,'1','274','1',1,'Retail Sale Id 2097',18600.00,0.00,0.00,25.00,2050.00,'2022-07-06 07:32:18','',''),(2133,'1','274','1',1,'Retail Sale Id 2098',9002.40,0.00,0.00,12.10,992.20,'2022-07-06 08:05:03','',''),(2134,'1','274','1',1,'Retail Sale Id 2099',9999.36,0.00,0.00,13.44,1102.08,'2022-07-06 09:07:45','',''),(2135,'1','274','1',1,'Retail Sale Id 2100',9300.00,0.00,0.00,12.50,1025.00,'2022-07-06 09:17:19','',''),(2136,'1','274','1',1,'Retail Sale Id 2101',2499.84,0.00,0.00,3.36,275.52,'2022-07-06 09:18:08','',''),(2137,'1','274','1',1,'Retail Sale Id 2102',2499.84,0.00,0.00,3.36,275.52,'2022-07-06 09:28:44','',''),(2138,'1','274','1',1,'Retail Sale Id 2103',3720.00,0.00,0.00,5.00,410.00,'2022-07-06 09:30:04','',''),(2139,'1','274','1',1,'Retail Sale Id 2104',1197.84,0.00,0.00,1.61,132.02,'2022-07-06 09:31:59','',''),(2140,'1','274','1',1,'Retail Sale Id 2105',1502.88,0.00,0.00,2.02,165.64,'2022-07-06 09:33:23','',''),(2141,'1','274','1',1,'Retail Sale Id 2106',4501.20,0.00,0.00,6.05,496.10,'2022-07-06 09:34:36','',''),(2142,'1','274','1',1,'Retail Sale Id 2107',2001.36,0.00,0.00,2.69,220.58,'2022-07-06 09:36:57','',''),(2143,'1','274','1',1,'Retail Sale Id 2108',9300.00,0.00,0.00,12.50,1025.00,'2022-07-06 10:07:18','',''),(2144,'1','274','1',1,'Retail Sale Id 2109',33480.00,0.00,0.00,45.00,3690.00,'2022-07-06 10:11:16','',''),(2145,'1','274','1',1,'Retail Sale Id 2110',2246.88,0.00,0.00,3.02,247.64,'2022-07-06 10:30:20','',''),(2146,'1','274','1',1,'Retail Sale Id 2111',4501.20,0.00,0.00,6.05,496.10,'2022-07-06 10:40:10','',''),(2147,'1','274','1',1,'Retail Sale Id 2112',3496.80,0.00,0.00,4.70,385.40,'2022-07-06 11:10:35','',''),(2148,'1','274','1',1,'Retail Sale Id 2113',4999.68,0.00,0.00,6.72,551.04,'2022-07-06 11:27:41','',''),(2149,'1','274','1',1,'Retail Sale Id 2114',2246.88,0.00,0.00,3.02,247.64,'2022-07-06 11:39:55','',''),(2150,'1','274','1',1,'Retail Sale Id 2115',8496.48,0.00,0.00,11.42,936.44,'2022-07-06 11:50:15','',''),(2151,'1','274','1',1,'Retail Sale Id 2116',4002.72,0.00,0.00,5.38,441.16,'2022-07-06 12:05:18','',''),(2152,'1','274','1',1,'Retail Sale Id 2118',18600.00,0.00,0.00,25.00,2050.00,'2022-07-06 12:25:28','',''),(2153,'1','274','1',1,'Retail Sale Id 2120',3496.80,0.00,0.00,4.70,385.40,'2022-07-06 12:27:25','',''),(2154,'1','274','1',1,'Retail Sale Id 2121',2246.88,0.00,0.00,3.02,247.64,'2022-07-06 12:35:30','',''),(2155,'1','274','1',1,'Retail Sale Id 2122',3600.96,0.00,0.00,4.84,396.88,'2022-07-06 12:41:41','',''),(2156,'1','274','1',1,'Retail Sale Id 2123',9300.00,0.00,0.00,12.50,1025.00,'2022-07-06 13:24:12','',''),(2157,'1','274','1',1,'Retail Sale Id 2124',996.96,0.00,0.00,1.34,109.88,'2022-07-06 13:26:02','',''),(2158,'1','274','1',1,'Retail Sale Id 2125',6748.08,0.00,0.00,9.07,743.74,'2022-07-06 13:48:13','',''),(2159,'1','274','1',1,'Retail Sale Id 2126',9300.00,0.00,0.00,12.50,1025.00,'2022-07-06 14:19:45','',''),(2160,'1','274','1',1,'Retail Sale Id 2127',18600.00,0.00,0.00,25.00,2050.00,'2022-07-06 14:24:53','',''),(2161,'1','274','1',1,'Retail Sale Id 2128',4501.20,0.00,0.00,6.05,496.10,'2022-07-06 14:27:50','',''),(2162,'1','274','1',1,'Retail Sale Id 2129',2001.36,0.00,0.00,2.69,220.58,'2022-07-06 14:28:54','',''),(2163,'1','274','1',1,'Retail Sale Id 2130',9300.00,0.00,0.00,12.50,1025.00,'2022-07-06 14:38:46','',''),(2164,'1','274','1',1,'Retail Sale Id 2131',2499.84,0.00,0.00,3.36,275.52,'2022-07-06 15:23:54','',''),(2165,'1','274','1',1,'Retail Sale Id 2132',2998.32,0.00,0.00,4.03,330.46,'2022-07-06 16:20:02','',''),(2166,'1','274','1',1,'Retail Sale Id 2133',9300.00,0.00,0.00,12.50,1025.00,'2022-07-06 16:21:07','',''),(2167,'1','274','1',1,'Retail Sale Id 2134',2499.84,0.00,0.00,3.36,275.52,'2022-07-06 17:17:10','',''),(2168,'1','274','1',1,'Retail Sale Id 2135',3749.76,0.00,0.00,5.04,413.28,'2022-07-06 17:18:44','',''),(2169,'1','274','1',1,'Retail Sale Id 2136',9300.00,0.00,0.00,12.50,1025.00,'2022-07-06 17:24:29','',''),(2170,'1','274','1',1,'Retail Sale Id 2137',2499.84,0.00,0.00,3.36,275.52,'2022-07-06 17:26:33','',''),(2171,'1','274','1',1,'Retail Sale Id 2138',4501.20,0.00,0.00,6.05,496.10,'2022-07-06 17:28:18','',''),(2172,'1','274','1',1,'Retail Sale Id 2139',2998.32,0.00,0.00,4.03,330.46,'2022-07-06 17:35:14','',''),(2173,'1','274','1',1,'Retail Sale Id 2140',6502.56,0.00,0.00,8.74,716.68,'2022-07-06 17:43:17','',''),(2174,'1','274','1',1,'Retail Sale Id 2141',2998.32,0.00,0.00,4.03,330.46,'2022-07-06 17:46:13','',''),(2175,'1','274','1',1,'Retail Sale Id 2142',14002.08,0.00,0.00,18.82,1543.24,'2022-07-06 17:46:58','',''),(2176,'1','274','1',1,'Retail Sale Id 2143',1502.88,0.00,0.00,2.02,165.64,'2022-07-06 17:50:27','',''),(2177,'1','274','1',1,'Retail Sale Id 2144',16368.00,0.00,0.00,22.00,1804.00,'2022-07-06 17:51:30','',''),(2178,'1','274','1',1,'Retail Sale Id 2145',9300.00,0.00,0.00,12.50,1025.00,'2022-07-06 17:53:24','',''),(2179,'1','274','1',1,'Retail Sale Id 2146',2001.36,0.00,0.00,2.69,220.58,'2022-07-06 17:59:37','',''),(2180,'1','274','1',1,'Retail Sale Id 2147',9300.00,0.00,0.00,12.50,1025.00,'2022-07-06 18:03:25','',''),(2181,'1','274','1',1,'Retail Sale Id 2148',9300.00,0.00,0.00,12.50,1025.00,'2022-07-06 18:05:03','',''),(2182,'1','274','1',1,'Retail Sale Id 2149',2001.36,0.00,0.00,2.69,220.58,'2022-07-06 18:09:03','',''),(2183,'1','274','1',1,'Retail Sale Id 2150',11301.36,0.00,0.00,15.19,1245.58,'2022-07-06 18:28:03','',''),(2184,'1','274','1',1,'Retail Sale Id 2151',7499.52,0.00,0.00,10.08,826.56,'2022-07-06 18:30:55','',''),(2185,'1','274','1',1,'Retail Sale Id 2152',4501.20,0.00,0.00,6.05,496.10,'2022-07-06 18:34:41','',''),(2186,'1','274','1',1,'Retail Sale Id 2153',31091.76,0.00,0.00,41.79,3426.78,'2022-07-06 19:51:50','',''),(2187,'1','274','1',1,'Retail Sale Id 2153',44684.64,0.00,0.00,60.06,4924.92,'2022-07-06 19:51:50','',''),(2188,'1','274','1',1,'Return of Retail Sale Id 2153',0.00,31091.76,41.79,0.00,-3426.78,'2022-07-06 19:53:22','',''),(2189,'1','274','1',1,'Return of Retail Sale Id 2153',0.00,44684.64,60.06,0.00,-4924.92,'2022-07-06 19:53:22','',''),(2190,'1','274','1',1,'Retail Sale Id 2154',31106.64,0.00,0.00,41.81,3428.42,'2022-07-06 19:54:19','',''),(2191,'1','274','1',1,'Retail Sale Id 2154',44684.64,0.00,0.00,60.06,4924.92,'2022-07-06 19:54:19','',''),(2192,'1','274','1',1,'Retail Sale Id 2155',4449.12,0.00,0.00,5.98,490.36,'2022-07-07 06:43:11','',''),(2193,'1','274','1',1,'Retail Sale Id 2156',9300.00,0.00,0.00,12.50,1025.00,'2022-07-07 06:43:55','',''),(2194,'1','274','1',1,'Retail Sale Id 2157',9300.00,0.00,0.00,12.50,1025.00,'2022-07-07 08:42:00','',''),(2195,'1','274','1',1,'Retail Sale Id 2158',2001.36,0.00,0.00,2.69,220.58,'2022-07-07 08:42:51','',''),(2196,'1','274','1',1,'Retail Sale Id 2159',7499.52,0.00,0.00,10.08,826.56,'2022-07-07 08:43:28','',''),(2197,'1','274','1',1,'Retail Sale Id 2160',4002.72,0.00,0.00,5.38,441.16,'2022-07-07 09:00:15','',''),(2198,'1','274','1',1,'Retail Sale Id 2161',2998.32,0.00,0.00,4.03,330.46,'2022-07-07 09:18:20','',''),(2199,'1','274','1',1,'Retail Sale Id 2162',3496.80,0.00,0.00,4.70,385.40,'2022-07-07 09:35:29','',''),(2200,'1','274','1',1,'Retail Sale Id 2163',2499.84,0.00,0.00,3.36,275.52,'2022-07-07 09:39:23','',''),(2201,'1','274','1',1,'Retail Sale Id 2164',9300.00,0.00,0.00,12.50,1025.00,'2022-07-07 09:53:30','',''),(2202,'1','274','1',1,'Retail Sale Id 2165',4501.20,0.00,0.00,6.05,496.10,'2022-07-07 10:07:50','',''),(2203,'1','274','1',1,'Retail Sale Id 2166',4501.20,0.00,0.00,6.05,496.10,'2022-07-07 10:13:07','',''),(2204,'1','274','1',1,'Retail Sale Id 2167',1502.88,0.00,0.00,2.02,165.64,'2022-07-07 10:21:10','',''),(2205,'1','274','1',1,'Retail Sale Id 2168',2499.84,0.00,0.00,3.36,275.52,'2022-07-07 10:25:11','',''),(2206,'1','274','1',1,'Retail Sale Id 2169',7998.00,0.00,0.00,10.75,881.50,'2022-07-07 10:42:16','',''),(2207,'1','274','1',1,'Retail Sale Id 2171',4501.20,0.00,0.00,6.05,496.10,'2022-07-07 10:52:18','',''),(2208,'1','274','1',1,'Retail Sale Id 2171',11160.00,0.00,0.00,15.00,1230.00,'2022-07-07 10:52:18','',''),(2209,'1','274','1',1,'Retail Sale Id 2172',4501.20,0.00,0.00,6.05,496.10,'2022-07-07 11:32:23','',''),(2210,'1','274','1',1,'Retail Sale Id 2173',9300.00,0.00,0.00,12.50,1025.00,'2022-07-07 11:37:28','',''),(2211,'1','274','1',1,'Retail Sale Id 2173',18600.00,0.00,0.00,25.00,2050.00,'2022-07-07 11:37:28','',''),(2212,'1','274','1',1,'Retail Sale Id 2174',9300.00,0.00,0.00,12.50,1025.00,'2022-07-07 11:56:27','',''),(2213,'1','274','1',1,'Retail Sale Id 2175',83700.00,0.00,0.00,112.50,9225.00,'2022-07-07 12:25:49','',''),(2214,'1','274','1',1,'Retail Sale Id 2176',2998.32,0.00,0.00,4.03,330.46,'2022-07-07 12:28:02','',''),(2215,'1','274','1',1,'Retail Sale Id 2177',1696.32,0.00,0.00,2.28,186.96,'2022-07-07 12:33:48','',''),(2216,'1','274','1',1,'Retail Sale Id 2178',9002.40,0.00,0.00,12.10,992.20,'2022-07-07 12:40:01','',''),(2217,'1','274','1',1,'Retail Sale Id 2179',9300.00,0.00,0.00,12.50,1025.00,'2022-07-07 14:06:07','',''),(2218,'1','274','1',1,'Retail Sale Id 2180',4501.20,0.00,0.00,6.05,496.10,'2022-07-07 14:21:22','',''),(2219,'1','274','1',1,'Retail Sale Id 2180',9300.00,0.00,0.00,12.50,1025.00,'2022-07-07 14:21:22','',''),(2220,'1','274','1',1,'Retail Sale Id 2181',2998.32,0.00,0.00,4.03,330.46,'2022-07-07 14:58:35','',''),(2221,'1','274','1',1,'Retail Sale Id 2182',4501.20,0.00,0.00,6.05,496.10,'2022-07-07 14:59:37','',''),(2222,'1','274','1',1,'Retail Sale Id 2183',996.96,0.00,0.00,1.34,109.88,'2022-07-07 15:30:01','',''),(2223,'1','274','1',1,'Retail Sale Id 2184',2001.36,0.00,0.00,2.69,220.58,'2022-07-07 15:33:24','',''),(2224,'1','274','1',1,'Retail Sale Id 2185',33480.00,0.00,0.00,45.00,3690.00,'2022-07-07 15:54:18','',''),(2225,'1','274','1',1,'Retail Sale Id 2186',2998.32,0.00,0.00,4.03,330.46,'2022-07-07 16:01:59','',''),(2226,'1','274','1',1,'Retail Sale Id 2187',9300.00,0.00,0.00,12.50,1025.00,'2022-07-07 16:02:57','',''),(2227,'1','274','1',1,'Retail Sale Id 2188',4501.20,0.00,0.00,6.05,496.10,'2022-07-07 16:52:24','',''),(2228,'1','274','1',1,'Retail Sale Id 2189',2246.88,0.00,0.00,3.02,247.64,'2022-07-07 16:53:15','',''),(2229,'1','274','1',1,'Retail Sale Id 2190',9300.00,0.00,0.00,12.50,1025.00,'2022-07-07 17:59:49','',''),(2230,'1','274','1',1,'Retail Sale Id 2191',2499.84,0.00,0.00,3.36,275.52,'2022-07-07 18:01:49','',''),(2231,'1','274','1',1,'Retail Sale Id 2192',4501.20,0.00,0.00,6.05,496.10,'2022-07-07 18:11:58','',''),(2232,'1','274','1',1,'Retail Sale Id 2193',9300.00,0.00,0.00,12.50,1025.00,'2022-07-07 18:13:38','',''),(2233,'1','274','1',1,'Retail Sale Id 2194',2001.36,0.00,0.00,2.69,220.58,'2022-07-07 18:17:54','',''),(2234,'1','274','1',1,'Retail Sale Id 2195',4501.20,0.00,0.00,6.05,496.10,'2022-07-07 18:23:47','',''),(2235,'1','274','1',1,'Retail Sale Id 2195',9300.00,0.00,0.00,12.50,1025.00,'2022-07-07 18:23:47','',''),(2236,'1','274','1',1,'Retail Sale Id 2196',9300.00,0.00,0.00,12.50,1025.00,'2022-07-07 18:24:44','',''),(2237,'1','274','1',1,'Retail Sale Id 2197',9300.00,0.00,0.00,12.50,1025.00,'2022-07-07 18:25:31','',''),(2238,'1','274','1',1,'Retail Sale Id 2198',6093.36,0.00,0.00,8.19,671.58,'2022-07-07 18:30:59','',''),(2239,'1','274','1',1,'Retail Sale Id 2199',9300.00,0.00,0.00,12.50,1025.00,'2022-07-07 18:32:01','',''),(2240,'1','274','1',1,'Retail Sale Id 2200',4501.20,0.00,0.00,6.05,496.10,'2022-07-07 18:39:59','',''),(2241,'1','274','1',1,'Retail Sale Id 2200',9300.00,0.00,0.00,12.50,1025.00,'2022-07-07 18:39:59','',''),(2242,'1','274','1',1,'Retail Sale Id 2201',9701.76,0.00,0.00,13.04,1069.28,'2022-07-07 18:43:38','',''),(2243,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,16219.00,24.50,0.00,0.00,'2022-07-07 20:05:04','',''),(2244,'1','274',NULL,1,'Reception corrector for bridging 13',0.00,0.00,0.00,24.50,0.00,'2022-07-07 20:06:23','',''),(2245,'1','274','1',1,'Received from bridging 13',0.00,0.00,24.50,0.00,0.00,'2022-07-07 20:06:23','',''),(2246,'1','274','1',1,'Retail Sale Id 2202',29090.40,0.00,0.00,39.10,3206.20,'2022-07-07 20:09:09','',''),(2247,'1','274','1',1,'Retail Sale Id 2202',34439.76,0.00,0.00,46.29,3795.78,'2022-07-07 20:09:09','',''),(2248,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,662000.00,1000.00,0.00,0.00,'2022-07-08 10:18:49','',''),(2249,'1','274',NULL,1,'Reception corrector for bridging 14',0.00,0.00,0.00,1000.00,0.00,'2022-07-08 10:21:45','',''),(2250,'1','274','1',1,'Received from bridging 14',0.00,0.00,1000.00,0.00,0.00,'2022-07-08 10:21:45','',''),(2251,'1','274','1',1,'Retail Sale Id 2203',4501.20,0.00,0.00,6.05,496.10,'2022-07-08 10:22:23','',''),(2252,'1','274','1',1,'Retail Sale Id 2204',4099.44,0.00,0.00,5.51,451.82,'2022-07-08 10:23:10','',''),(2253,'1','274','1',1,'Retail Sale Id 2205',7499.52,0.00,0.00,10.08,826.56,'2022-07-08 10:24:14','',''),(2254,'1','274','1',1,'Retail Sale Id 2206',2001.36,0.00,0.00,2.69,220.58,'2022-07-08 10:25:20','',''),(2255,'1','274','1',1,'Retail Sale Id 2207',37200.00,0.00,0.00,50.00,4100.00,'2022-07-08 10:30:00','',''),(2256,'1','274','1',1,'Retail Sale Id 2207',37200.00,0.00,0.00,50.00,4100.00,'2022-07-08 10:30:00','',''),(2257,'1','274','1',1,'Retail Sale Id 2208',9300.00,0.00,0.00,12.50,1025.00,'2022-07-08 11:11:35','',''),(2258,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,2687720.00,4060.00,0.00,0.00,'2022-07-08 12:14:22','',''),(2259,'1','274',NULL,1,'Reception corrector for bridging 15',0.00,0.00,0.00,4060.00,0.00,'2022-07-08 12:15:19','',''),(2260,'1','274','1',1,'Received from bridging 15',0.00,0.00,4060.00,0.00,0.00,'2022-07-08 12:15:19','',''),(2261,'1','274','1',1,'Retail Sale Id 2209',8496.48,0.00,0.00,11.42,936.44,'2022-07-08 12:45:47','',''),(2262,'1','274','1',1,'Retail Sale Id 2210',4501.20,0.00,0.00,6.05,496.10,'2022-07-08 14:24:15','',''),(2263,'1','274','1',1,'Retail Sale Id 2210',9300.00,0.00,0.00,12.50,1025.00,'2022-07-08 14:24:15','',''),(2264,'1','274','1',1,'Retail Sale Id 2211',4501.20,0.00,0.00,6.05,496.10,'2022-07-08 14:29:20','',''),(2265,'1','274','1',1,'Retail Sale Id 2212',37200.00,0.00,0.00,50.00,4100.00,'2022-07-08 14:30:53','',''),(2266,'1','274','1',1,'Retail Sale Id 2213',37200.00,0.00,0.00,50.00,4100.00,'2022-07-08 14:53:31','',''),(2267,'1','274','1',1,'Retail Sale Id 2214',2001.36,0.00,0.00,2.69,220.58,'2022-07-08 15:15:00','',''),(2268,'1','274','1',1,'Retail Sale Id 2215',9300.00,0.00,0.00,12.50,1025.00,'2022-07-08 16:04:29','',''),(2269,'1','274','1',1,'Retail Sale Id 2216',9300.00,0.00,0.00,12.50,1025.00,'2022-07-08 16:23:04','',''),(2270,'1','274','1',1,'Retail Sale Id 2217',9300.00,0.00,0.00,12.50,1025.00,'2022-07-08 16:39:24','',''),(2271,'1','274','1',1,'Retail Sale Id 2218',9300.00,0.00,0.00,12.50,1025.00,'2022-07-08 16:47:43','',''),(2272,'1','274','1',1,'Retail Sale Id 2219',2998.32,0.00,0.00,4.03,330.46,'2022-07-08 16:51:43','',''),(2273,'1','274','1',1,'Retail Sale Id 2220',63120.96,0.00,0.00,84.84,6956.88,'2022-07-08 20:03:49','',''),(2274,'1','274','1',1,'Retail Sale Id 2220',119419.44,0.00,0.00,160.51,13161.82,'2022-07-08 20:03:49','',''),(2275,'1','274','1',1,'Retail Sale Id 2221',9300.00,0.00,0.00,12.50,1025.00,'2022-07-09 08:12:40','',''),(2276,'1','274','1',1,'Retail Sale Id 2222',9300.00,0.00,0.00,12.50,1025.00,'2022-07-09 08:13:43','',''),(2277,'1','274','1',1,'Retail Sale Id 2223',7998.00,0.00,0.00,10.75,881.50,'2022-07-09 08:14:20','',''),(2278,'1','274','1',1,'Retail Sale Id 2224',7499.52,0.00,0.00,10.08,826.56,'2022-07-09 08:14:57','',''),(2279,'1','274','1',1,'Retail Sale Id 2225',9300.00,0.00,0.00,12.50,1025.00,'2022-07-09 10:12:51','',''),(2280,'1','274','1',1,'Retail Sale Id 2225',11160.00,0.00,0.00,15.00,1230.00,'2022-07-09 10:12:51','',''),(2281,'1','274','1',1,'Retail Sale Id 2226',3749.76,0.00,0.00,5.04,413.28,'2022-07-09 10:21:31','',''),(2282,'1','274','1',1,'Retail Sale Id 2227',9300.00,0.00,0.00,12.50,1025.00,'2022-07-09 10:47:02','',''),(2283,'1','274','1',1,'Retail Sale Id 2228',111600.00,0.00,0.00,150.00,12300.00,'2022-07-09 16:22:23','',''),(2284,'1','274','1',1,'Retail Sale Id 2229',9300.00,0.00,0.00,12.50,1025.00,'2022-07-09 17:33:16','',''),(2285,'1','274','1',1,'Retail Sale Id 2230',22320.00,0.00,0.00,30.00,2460.00,'2022-07-09 17:36:16','',''),(2286,'1','274','1',1,'Retail Sale Id 2231',16368.00,0.00,0.00,22.00,1804.00,'2022-07-09 17:53:28','',''),(2287,'1','274','1',1,'Retail Sale Id 2232',2246.88,0.00,0.00,3.02,247.64,'2022-07-09 18:07:52','',''),(2288,'1','274','1',1,'Retail Sale Id 2233',4501.20,0.00,0.00,6.05,496.10,'2022-07-09 18:12:15','',''),(2289,'1','274','1',1,'Retail Sale Id 2234',1197.84,0.00,0.00,1.61,132.02,'2022-07-09 18:17:26','',''),(2290,'1','274','1',1,'Retail Sale Id 2235',4501.20,0.00,0.00,6.05,496.10,'2022-07-09 18:18:03','',''),(2291,'1','274','1',1,'Retail Sale Id 2236',2246.88,0.00,0.00,3.02,247.64,'2022-07-09 18:20:56','',''),(2292,'1','274','1',1,'Retail Sale Id 2237',2001.36,0.00,0.00,2.69,220.58,'2022-07-09 18:24:14','',''),(2293,'1','274','1',1,'Retail Sale Id 2238',9300.00,0.00,0.00,12.50,1025.00,'2022-07-09 18:25:05','',''),(2294,'1','274','1',1,'Retail Sale Id 2239',37200.00,0.00,0.00,50.00,4100.00,'2022-07-09 18:51:26','',''),(2295,'1','274','1',1,'Retail Sale Id 2240',60591.36,0.00,0.00,81.44,6678.08,'2022-07-09 19:27:09','',''),(2296,'1','274','1',1,'Retail Sale Id 2241',204666.96,0.00,0.00,275.09,22557.38,'2022-07-09 19:43:21','',''),(2297,'1','274','1',1,'Retail Sale Id 2242',2001.36,0.00,0.00,2.69,220.58,'2022-07-10 09:12:42','',''),(2298,'1','274','1',1,'Retail Sale Id 2243',996.96,0.00,0.00,1.34,109.88,'2022-07-10 09:13:49','',''),(2299,'1','274','1',1,'Retail Sale Id 2244',4501.20,0.00,0.00,6.05,496.10,'2022-07-10 09:34:10','',''),(2300,'1','274','1',1,'Retail Sale Id 2245',9300.00,0.00,0.00,12.50,1025.00,'2022-07-10 09:41:18','',''),(2301,'1','274','1',1,'Retail Sale Id 2246',4501.20,0.00,0.00,6.05,496.10,'2022-07-10 09:42:03','',''),(2302,'1','274','1',1,'Retail Sale Id 2247',1502.88,0.00,0.00,2.02,165.64,'2022-07-10 15:03:00','',''),(2303,'1','274','1',1,'Retail Sale Id 2248',4999.68,0.00,0.00,6.72,551.04,'2022-07-10 15:05:24','',''),(2304,'1','274','1',1,'Retail Sale Id 2249',4501.20,0.00,0.00,6.05,496.10,'2022-07-10 15:14:17','',''),(2305,'1','274','1',1,'Retail Sale Id 2250',2499.84,0.00,0.00,3.36,275.52,'2022-07-10 15:19:59','',''),(2306,'1','274','1',1,'Retail Sale Id 2251',18600.00,0.00,0.00,25.00,2050.00,'2022-07-10 15:30:57','',''),(2307,'1','274','1',1,'Retail Sale Id 2252',9300.00,0.00,0.00,12.50,1025.00,'2022-07-10 15:32:07','',''),(2308,'1','274','1',1,'Retail Sale Id 2253',3749.76,0.00,0.00,5.04,413.28,'2022-07-10 16:01:56','',''),(2309,'1','274','1',1,'Retail Sale Id 2254',9300.00,0.00,0.00,12.50,1025.00,'2022-07-10 17:15:14','',''),(2310,'1','274','1',1,'Retail Sale Id 2255',37200.00,0.00,0.00,50.00,4100.00,'2022-07-10 18:15:34','',''),(2311,'1','274','1',1,'Retail Sale Id 2256',32996.40,0.00,0.00,44.35,3636.70,'2022-07-10 18:17:40','',''),(2312,'1','274','1',1,'Retail Sale Id 2257',34000.80,0.00,0.00,45.70,3747.40,'2022-07-10 18:22:11','',''),(2313,'1','274','1',1,'Retail Sale Id 2258',9300.00,0.00,0.00,12.50,1025.00,'2022-07-10 18:25:34','',''),(2314,'1','274','1',1,'Retail Sale Id 2259',4501.20,0.00,0.00,6.05,496.10,'2022-07-10 19:18:28','',''),(2315,'1','274','1',1,'Retail Sale Id 2260',28413.36,0.00,0.00,38.19,3131.58,'2022-07-10 19:26:28','',''),(2316,'1','274','1',1,'Retail Sale Id 2261',67718.88,0.00,0.00,91.02,7463.64,'2022-07-10 19:28:15','',''),(2317,'1','274','1',1,'Retail Sale Id 2262',4501.20,0.00,0.00,6.05,496.10,'2022-07-11 08:00:27','',''),(2318,'1','274','1',1,'Retail Sale Id 2263',4501.20,0.00,0.00,6.05,496.10,'2022-07-11 09:04:00','',''),(2319,'1','274','1',1,'Retail Sale Id 2264',22320.00,0.00,0.00,30.00,2460.00,'2022-07-11 09:47:10','',''),(2320,'1','274','1',1,'Retail Sale Id 2265',2246.88,0.00,0.00,3.02,247.64,'2022-07-11 09:48:23','',''),(2321,'1','274','1',1,'Retail Sale Id 2265',3749.76,0.00,0.00,5.04,413.28,'2022-07-11 09:48:23','',''),(2322,'1','274','1',1,'Retail Sale Id 2266',74400.00,0.00,0.00,100.00,8200.00,'2022-07-11 09:53:44','',''),(2323,'1','274','1',1,'Retail Sale Id 2267',4501.20,0.00,0.00,6.05,496.10,'2022-07-11 10:00:53','',''),(2324,'1','274','1',1,'Retail Sale Id 2268',4501.20,0.00,0.00,6.05,496.10,'2022-07-11 10:05:34','',''),(2325,'1','274','1',1,'Retail Sale Id 2269',2001.36,0.00,0.00,2.69,220.58,'2022-07-11 10:19:54','',''),(2326,'1','274','1',1,'Retail Sale Id 2270',4501.20,0.00,0.00,6.05,496.10,'2022-07-11 10:34:28','',''),(2327,'1','274','1',1,'Retail Sale Id 2271',1502.88,0.00,0.00,2.02,165.64,'2022-07-11 10:49:38','',''),(2328,'1','274','1',1,'Retail Sale Id 2272',2499.84,0.00,0.00,3.36,275.52,'2022-07-11 10:50:52','',''),(2329,'1','274','1',1,'Retail Sale Id 2273',2001.36,0.00,0.00,2.69,220.58,'2022-07-11 11:11:32','',''),(2330,'1','274','1',1,'Retail Sale Id 2274',9300.00,0.00,0.00,12.50,1025.00,'2022-07-11 11:15:10','',''),(2331,'1','274','1',1,'Retail Sale Id 2275',4501.20,0.00,0.00,6.05,496.10,'2022-07-11 17:47:50','',''),(2332,'1','274','1',1,'Retail Sale Id 2276',2998.32,0.00,0.00,4.03,330.46,'2022-07-11 17:53:04','',''),(2333,'1','274','1',1,'Retail Sale Id 2277',2998.32,0.00,0.00,4.03,330.46,'2022-07-11 18:00:29','',''),(2334,'1','274','1',1,'Retail Sale Id 2278',9300.00,0.00,0.00,12.50,1025.00,'2022-07-11 18:23:07','',''),(2335,'1','274','1',1,'Retail Sale Id 2279',2246.88,0.00,0.00,3.02,247.64,'2022-07-11 18:24:36','',''),(2336,'1','274','1',1,'Retail Sale Id 2279',2246.88,0.00,0.00,3.02,247.64,'2022-07-11 18:24:36','',''),(2337,'1','274','1',1,'Retail Sale Id 2279',2246.88,0.00,0.00,3.02,247.64,'2022-07-11 18:24:36','',''),(2338,'1','274','1',1,'Retail Sale Id 2280',4501.20,0.00,0.00,6.05,496.10,'2022-07-11 18:31:34','',''),(2339,'1','274','1',1,'Retail Sale Id 2281',1502.88,0.00,0.00,2.02,165.64,'2022-07-11 19:04:32','',''),(2340,'1','274','1',1,'Retail Sale Id 2282',4501.20,0.00,0.00,6.05,496.10,'2022-07-11 19:08:11','',''),(2341,'1','274','1',1,'Retail Sale Id 2283',2246.88,0.00,0.00,3.02,247.64,'2022-07-11 19:09:08','',''),(2342,'1','274','1',1,'Retail Sale Id 2284',9300.00,0.00,0.00,12.50,1025.00,'2022-07-11 19:17:25','',''),(2343,'1','274','1',1,'Retail Sale Id 2285',12491.76,0.00,0.00,16.79,1376.78,'2022-07-11 19:23:20','',''),(2344,'1','274','1',1,'Retail Sale Id 2286',109568.88,0.00,0.00,147.27,12076.14,'2022-07-11 19:33:01','',''),(2345,'1','274','1',1,'Retail Sale Id 2287',4501.20,0.00,0.00,6.05,496.10,'2022-07-12 08:12:53','',''),(2346,'1','274','1',1,'Retail Sale Id 2288',2998.32,0.00,0.00,4.03,330.46,'2022-07-12 08:13:40','',''),(2347,'1','274','1',1,'Retail Sale Id 2289',9300.00,0.00,0.00,12.50,1025.00,'2022-07-12 08:19:20','',''),(2348,'1','274','1',1,'Retail Sale Id 2290',3749.76,0.00,0.00,5.04,413.28,'2022-07-12 08:30:10','',''),(2349,'1','274','1',1,'Retail Sale Id 2290',4501.20,0.00,0.00,6.05,496.10,'2022-07-12 08:30:10','',''),(2350,'1','274','1',1,'Retail Sale Id 2290',9300.00,0.00,0.00,12.50,1025.00,'2022-07-12 08:30:10','',''),(2351,'1','274','1',1,'Retail Sale Id 2291',22320.00,0.00,0.00,30.00,2460.00,'2022-07-12 09:50:20','',''),(2352,'1','274','1',1,'Retail Sale Id 2292',7998.00,0.00,0.00,10.75,881.50,'2022-07-12 10:12:51','',''),(2353,'1','274','1',1,'Retail Sale Id 2293',37200.00,0.00,0.00,50.00,4100.00,'2022-07-12 10:39:26','',''),(2354,'1','274','1',1,'Retail Sale Id 2294',9300.00,0.00,0.00,12.50,1025.00,'2022-07-12 13:16:26','',''),(2355,'1','274','1',1,'Retail Sale Id 2295',29760.00,0.00,0.00,40.00,3280.00,'2022-07-12 14:00:10','',''),(2356,'1','274','1',1,'Retail Sale Id 2296',9300.00,0.00,0.00,12.50,1025.00,'2022-07-12 14:08:53','',''),(2357,'1','274','1',1,'Retail Sale Id 2297',3749.76,0.00,0.00,5.04,413.28,'2022-07-12 14:43:28','',''),(2358,'1','274','1',1,'Retail Sale Id 2298',9300.00,0.00,0.00,12.50,1025.00,'2022-07-12 15:31:06','',''),(2359,'1','274','1',1,'Retail Sale Id 2299',9300.00,0.00,0.00,12.50,1025.00,'2022-07-12 16:18:22','',''),(2360,'1','274','1',1,'Retail Sale Id 2300',9300.00,0.00,0.00,12.50,1025.00,'2022-07-12 16:21:15','',''),(2361,'1','274','1',1,'Retail Sale Id 2302',2246.88,0.00,0.00,3.02,247.64,'2022-07-12 17:14:56','',''),(2362,'1','274','1',1,'Retail Sale Id 2303',16397.76,0.00,0.00,22.04,1807.28,'2022-07-12 17:57:58','',''),(2363,'1','274','1',1,'Retail Sale Id 2304',18748.80,0.00,0.00,25.20,2066.40,'2022-07-12 18:51:25','',''),(2364,'1','274','1',1,'Retail Sale Id 2304',68343.84,0.00,0.00,91.86,7532.52,'2022-07-12 18:51:25','',''),(2365,'1','274','1',1,'Retail Sale Id 2305',7998.00,0.00,0.00,10.75,881.50,'2022-07-13 07:47:34','',''),(2366,'1','274','1',1,'Retail Sale Id 2306',4501.20,0.00,0.00,6.05,496.10,'2022-07-13 07:48:23','',''),(2367,'1','274','1',1,'Retail Sale Id 2307',4501.20,0.00,0.00,6.05,496.10,'2022-07-13 08:05:35','',''),(2368,'1','274','1',1,'Retail Sale Id 2308',4501.20,0.00,0.00,6.05,496.10,'2022-07-13 08:07:13','',''),(2369,'1','274','1',1,'Retail Sale Id 2309',4501.20,0.00,0.00,6.05,496.10,'2022-07-13 08:41:47','',''),(2370,'1','274','1',1,'Retail Sale Id 2310',9300.00,0.00,0.00,12.50,1025.00,'2022-07-13 08:57:03','',''),(2371,'1','274','1',1,'Retail Sale Id 2311',9300.00,0.00,0.00,12.50,1025.00,'2022-07-13 09:20:25','',''),(2372,'1','274','1',1,'Retail Sale Id 2312',3749.76,0.00,0.00,5.04,413.28,'2022-07-13 09:26:00','',''),(2373,'1','274','1',1,'Retail Sale Id 2313',9300.00,0.00,0.00,12.50,1025.00,'2022-07-13 09:39:00','',''),(2374,'1','274','1',1,'Retail Sale Id 2314',4501.20,0.00,0.00,6.05,496.10,'2022-07-13 09:43:51','',''),(2375,'1','274','1',1,'Retail Sale Id 2315',3749.76,0.00,0.00,5.04,413.28,'2022-07-13 10:06:26','',''),(2376,'1','274','1',1,'Retail Sale Id 2316',37200.00,0.00,0.00,50.00,4100.00,'2022-07-13 11:16:02','',''),(2377,'1','274','1',1,'Retail Sale Id 2317',37200.00,0.00,0.00,50.00,4100.00,'2022-07-13 13:19:36','',''),(2378,'1','274','1',1,'Retail Sale Id 2318',4501.20,0.00,0.00,6.05,496.10,'2022-07-13 13:38:13','',''),(2379,'1','274','1',1,'Retail Sale Id 2318',4501.20,0.00,0.00,6.05,496.10,'2022-07-13 13:38:13','',''),(2380,'1','274','1',1,'Retail Sale Id 2319',2246.88,0.00,0.00,3.02,247.64,'2022-07-13 13:39:09','',''),(2381,'1','274','1',1,'Retail Sale Id 2319',2246.88,0.00,0.00,3.02,247.64,'2022-07-13 13:39:09','',''),(2382,'1','274','1',1,'Retail Sale Id 2320',33480.00,0.00,0.00,45.00,3690.00,'2022-07-13 14:00:32','',''),(2383,'1','274','1',1,'Retail Sale Id 2321',9300.00,0.00,0.00,12.50,1025.00,'2022-07-13 14:11:38','',''),(2384,'1','274','1',1,'Retail Sale Id 2322',3720.00,0.00,0.00,5.00,410.00,'2022-07-13 14:24:51','',''),(2385,'1','274','1',1,'Retail Sale Id 2323',2998.32,0.00,0.00,4.03,330.46,'2022-07-13 14:27:26','',''),(2386,'1','274','1',1,'Retail Sale Id 2324',1502.88,0.00,0.00,2.02,165.64,'2022-07-13 15:24:54','',''),(2387,'1','274','1',1,'Retail Sale Id 2325',9300.00,0.00,0.00,12.50,1025.00,'2022-07-13 15:34:52','',''),(2388,'1','274','1',1,'Retail Sale Id 2326',9300.00,0.00,0.00,12.50,1025.00,'2022-07-13 15:53:43','',''),(2389,'1','274','1',1,'Retail Sale Id 2327',4002.72,0.00,0.00,5.38,441.16,'2022-07-13 15:57:01','',''),(2390,'1','274','1',1,'Retail Sale Id 2328',9300.00,0.00,0.00,12.50,1025.00,'2022-07-13 16:05:01','',''),(2391,'1','274','1',1,'Retail Sale Id 2329',9300.00,0.00,0.00,12.50,1025.00,'2022-07-13 16:38:41','',''),(2392,'1','274','1',1,'Retail Sale Id 2330',9300.00,0.00,0.00,12.50,1025.00,'2022-07-13 16:55:46','',''),(2393,'1','274','1',1,'Retail Sale Id 2331',4501.20,0.00,0.00,6.05,496.10,'2022-07-13 17:19:26','',''),(2394,'1','274','1',1,'Retail Sale Id 2332',1897.20,0.00,0.00,2.55,209.10,'2022-07-13 17:20:15','',''),(2395,'1','274','1',1,'Retail Sale Id 2333',9672.00,0.00,0.00,13.00,1066.00,'2022-07-13 18:48:20','',''),(2396,'1','274','1',1,'Retail Sale Id 2334',12499.20,0.00,0.00,16.80,1377.60,'2022-07-13 18:53:25','',''),(2397,'1','274','1',1,'Retail Sale Id 2335',3749.76,0.00,0.00,5.04,413.28,'2022-07-13 19:00:02','',''),(2398,'1','274','1',1,'Retail Sale Id 2336',2998.32,0.00,0.00,4.03,330.46,'2022-07-13 19:01:46','',''),(2399,'1','274','1',1,'Retail Sale Id 2337',996.96,0.00,0.00,1.34,109.88,'2022-07-13 19:02:37','',''),(2400,'1','274','1',1,'Retail Sale Id 2338',9300.00,0.00,0.00,12.50,1025.00,'2022-07-13 19:14:25','',''),(2401,'1','274','1',1,'Retail Sale Id 2339',21628.08,0.00,0.00,29.07,2383.74,'2022-07-13 19:22:11','',''),(2402,'1','274','1',1,'Retail Sale Id 2339',40949.76,0.00,0.00,55.04,4513.28,'2022-07-13 19:22:11','',''),(2403,'1','274','1',1,'Retail Sale Id 2340',9300.00,0.00,0.00,12.50,1025.00,'2022-07-14 06:52:10','',''),(2404,'1','274','1',1,'Retail Sale Id 2341',9300.00,0.00,0.00,12.50,1025.00,'2022-07-14 06:52:46','',''),(2405,'1','274','1',1,'Retail Sale Id 2342',4501.20,0.00,0.00,6.05,496.10,'2022-07-14 06:53:55','',''),(2406,'1','274','1',1,'Retail Sale Id 2343',4397.04,0.00,0.00,5.91,484.62,'2022-07-14 07:43:00','',''),(2407,'1','274','1',1,'Retail Sale Id 2344',2001.36,0.00,0.00,2.69,220.58,'2022-07-14 08:01:23','',''),(2408,'1','274','1',1,'Retail Sale Id 2345',2001.36,0.00,0.00,2.69,220.58,'2022-07-14 09:12:47','',''),(2409,'1','274','1',1,'Retail Sale Id 2346',9300.00,0.00,0.00,12.50,1025.00,'2022-07-14 09:17:08','',''),(2410,'1','274','1',1,'Retail Sale Id 2347',7998.00,0.00,0.00,10.75,881.50,'2022-07-14 09:40:12','',''),(2411,'1','274','1',1,'Retail Sale Id 2348',9300.00,0.00,0.00,12.50,1025.00,'2022-07-14 09:42:09','',''),(2412,'1','274','1',1,'Retail Sale Id 2349',2001.36,0.00,0.00,2.69,220.58,'2022-07-14 10:55:08','',''),(2413,'1','274','1',1,'Retail Sale Id 2350',37200.00,0.00,0.00,50.00,4100.00,'2022-07-14 11:01:15','',''),(2414,'1','274','1',1,'Retail Sale Id 2351',4002.72,0.00,0.00,5.38,441.16,'2022-07-14 11:18:07','',''),(2415,'1','274','1',1,'Retail Sale Id 2351',7998.00,0.00,0.00,10.75,881.50,'2022-07-14 11:18:07','',''),(2416,'1','274','1',1,'Retail Sale Id 2352',18600.00,0.00,0.00,25.00,2050.00,'2022-07-14 11:21:42','',''),(2417,'1','274','1',1,'Retail Sale Id 2353',2001.36,0.00,0.00,2.69,220.58,'2022-07-14 11:27:52','',''),(2418,'1','274','1',1,'Retail Sale Id 2354',2499.84,0.00,0.00,3.36,275.52,'2022-07-14 11:43:13','',''),(2419,'1','274','1',1,'Retail Sale Id 2355',2998.32,0.00,0.00,4.03,330.46,'2022-07-14 12:00:09','',''),(2420,'1','274','1',1,'Retail Sale Id 2356',4002.72,0.00,0.00,5.38,441.16,'2022-07-14 12:01:33','',''),(2421,'1','274','1',1,'Retail Sale Id 2357',9300.00,0.00,0.00,12.50,1025.00,'2022-07-14 12:34:11','',''),(2422,'1','274','1',1,'Retail Sale Id 2358',9300.00,0.00,0.00,12.50,1025.00,'2022-07-14 16:46:12','',''),(2423,'1','274','1',1,'Retail Sale Id 2359',3496.80,0.00,0.00,4.70,385.40,'2022-07-14 16:54:27','',''),(2424,'1','274','1',1,'Retail Sale Id 2360',29499.60,0.00,0.00,39.65,3251.30,'2022-07-14 17:20:26','',''),(2425,'1','274','1',1,'Retail Sale Id 2361',5996.64,0.00,0.00,8.06,660.92,'2022-07-14 17:32:35','',''),(2426,'1','274','1',1,'Retail Sale Id 2362',5996.64,0.00,0.00,8.06,660.92,'2022-07-14 17:35:30','',''),(2427,'1','274','1',1,'Retail Sale Id 2363',4999.68,0.00,0.00,6.72,551.04,'2022-07-14 17:55:56','',''),(2428,'1','274','1',1,'Retail Sale Id 2365',3749.76,0.00,0.00,5.04,413.28,'2022-07-14 18:00:48','',''),(2429,'1','274','1',1,'Retail Sale Id 2365',9300.00,0.00,0.00,12.50,1025.00,'2022-07-14 18:00:48','',''),(2430,'1','274','1',1,'Retail Sale Id 2366',9300.00,0.00,0.00,12.50,1025.00,'2022-07-14 18:03:22','',''),(2431,'1','274','1',1,'Retail Sale Id 2367',4501.20,0.00,0.00,6.05,496.10,'2022-07-14 18:18:34','',''),(2432,'1','274','1',1,'Retail Sale Id 2369',16397.76,0.00,0.00,22.04,1807.28,'2022-07-14 18:48:14','',''),(2433,'1','274','1',1,'Retail Sale Id 2370',21367.68,0.00,0.00,28.72,2355.04,'2022-07-14 19:21:27','',''),(2434,'1','274','1',1,'Retail Sale Id 2371',4501.20,0.00,0.00,6.05,496.10,'2022-07-14 19:22:28','',''),(2435,'1','274','1',1,'Retail Sale Id 2372',9300.00,0.00,0.00,12.50,1025.00,'2022-07-14 19:28:38','',''),(2436,'1','274','1',1,'Retail Sale Id 2373',69028.32,0.00,0.00,92.78,7607.96,'2022-07-14 19:33:47','',''),(2437,'1','274','1',1,'Retail Sale Id 2374',11502.24,0.00,0.00,15.46,1267.72,'2022-07-15 07:40:29','',''),(2438,'1','274','1',1,'Retail Sale Id 2375',7499.52,0.00,0.00,10.08,826.56,'2022-07-15 07:40:59','',''),(2439,'1','274','1',1,'Retail Sale Id 2376',4002.72,0.00,0.00,5.38,441.16,'2022-07-15 07:41:38','',''),(2440,'1','274','1',1,'Retail Sale Id 2377',2998.32,0.00,0.00,4.03,330.46,'2022-07-15 07:43:28','',''),(2441,'1','274','1',1,'Retail Sale Id 2377',7998.00,0.00,0.00,10.75,881.50,'2022-07-15 07:43:28','',''),(2442,'1','274','1',1,'Retail Sale Id 2378',2998.32,0.00,0.00,4.03,330.46,'2022-07-15 07:46:49','',''),(2443,'1','274','1',1,'Retail Sale Id 2379',9300.00,0.00,0.00,12.50,1025.00,'2022-07-15 08:08:44','',''),(2444,'1','274','1',1,'Retail Sale Id 2380',9300.00,0.00,0.00,12.50,1025.00,'2022-07-15 08:38:45','',''),(2445,'1','274','1',1,'Retail Sale Id 2381',2246.88,0.00,0.00,3.02,247.64,'2022-07-15 09:57:52','',''),(2446,'1','274','1',1,'Retail Sale Id 2382',3749.76,0.00,0.00,5.04,413.28,'2022-07-15 10:01:32','',''),(2447,'1','274','1',1,'Retail Sale Id 2383',9300.00,0.00,0.00,12.50,1025.00,'2022-07-15 10:13:45','',''),(2448,'1','274','1',1,'Retail Sale Id 2384',4501.20,0.00,0.00,6.05,496.10,'2022-07-15 10:15:02','',''),(2449,'1','274','1',1,'Retail Sale Id 2385',18600.00,0.00,0.00,25.00,2050.00,'2022-07-15 10:31:10','',''),(2450,'1','274','1',1,'Retail Sale Id 2386',37200.00,0.00,0.00,50.00,4100.00,'2022-07-15 10:36:26','',''),(2451,'1','274','1',1,'Retail Sale Id 2387',4999.68,0.00,0.00,6.72,551.04,'2022-07-15 11:07:37','',''),(2452,'1','274','1',1,'Retail Sale Id 2388',42780.00,0.00,0.00,57.50,4715.00,'2022-07-15 12:32:27','',''),(2453,'1','274','1',1,'Retail Sale Id 2389',2246.88,0.00,0.00,3.02,247.64,'2022-07-15 15:41:07','',''),(2454,'1','274','1',1,'Retail Sale Id 2390',5907.36,0.00,0.00,7.94,651.08,'2022-07-15 17:44:29','',''),(2455,'1','274','1',1,'Retail Sale Id 2391',4501.20,0.00,0.00,6.05,496.10,'2022-07-15 17:55:39','',''),(2456,'1','274','1',1,'Retail Sale Id 2391',9300.00,0.00,0.00,12.50,1025.00,'2022-07-15 17:55:39','',''),(2457,'1','274','1',1,'Retail Sale Id 2392',16368.00,0.00,0.00,22.00,1804.00,'2022-07-15 18:41:55','',''),(2458,'1','274','1',1,'Retail Sale Id 2393',7440.00,0.00,0.00,10.00,820.00,'2022-07-15 18:56:08','',''),(2459,'1','274','1',1,'Retail Sale Id 2394',31054.56,0.00,0.00,41.74,3422.68,'2022-07-15 19:24:31','',''),(2460,'1','274','1',1,'Retail Sale Id 2395',130162.80,0.00,0.00,174.95,14345.90,'2022-07-15 19:29:39','',''),(2461,'1','274','1',1,'Retail Sale Id 2396',7001.04,0.00,0.00,9.41,771.62,'2022-07-16 06:25:59','',''),(2462,'1','274','1',1,'Retail Sale Id 2397',2098.08,0.00,0.00,2.82,231.24,'2022-07-16 07:53:19','',''),(2463,'1','274','1',1,'Retail Sale Id 2398',2998.32,0.00,0.00,4.03,330.46,'2022-07-16 07:55:04','',''),(2464,'1','274','1',1,'Retail Sale Id 2399',2246.88,0.00,0.00,3.02,247.64,'2022-07-16 08:04:19','',''),(2465,'1','274','1',1,'Retail Sale Id 2400',2499.84,0.00,0.00,3.36,275.52,'2022-07-16 08:26:57','',''),(2466,'1','274','1',1,'Retail Sale Id 2401',33480.00,0.00,0.00,45.00,3690.00,'2022-07-16 08:32:25','',''),(2467,'1','274','1',1,'Retail Sale Id 2402',9300.00,0.00,0.00,12.50,1025.00,'2022-07-16 08:45:59','',''),(2468,'1','274','1',1,'Retail Sale Id 2403',4501.20,0.00,0.00,6.05,496.10,'2022-07-16 08:48:03','',''),(2469,'1','274','1',1,'Retail Sale Id 2404',9300.00,0.00,0.00,12.50,1025.00,'2022-07-16 09:16:56','',''),(2470,'1','274','1',1,'Retail Sale Id 2405',4501.20,0.00,0.00,6.05,496.10,'2022-07-16 09:31:23','',''),(2471,'1','274','1',1,'Retail Sale Id 2406',7440.00,0.00,0.00,10.00,820.00,'2022-07-16 09:52:10','',''),(2472,'1','274','1',1,'Retail Sale Id 2407',2998.32,0.00,0.00,4.03,330.46,'2022-07-16 09:52:46','',''),(2473,'1','274','1',1,'Retail Sale Id 2408',12997.68,0.00,0.00,17.47,1432.54,'2022-07-16 10:48:03','',''),(2474,'1','274','1',1,'Retail Sale Id 2409',9300.00,0.00,0.00,12.50,1025.00,'2022-07-16 11:02:23','',''),(2475,'1','274','1',1,'Retail Sale Id 2410',9300.00,0.00,0.00,12.50,1025.00,'2022-07-16 11:14:08','',''),(2476,'1','274','1',1,'Retail Sale Id 2411',7998.00,0.00,0.00,10.75,881.50,'2022-07-16 11:15:20','',''),(2477,'1','274','1',1,'Retail Sale Id 2412',4501.20,0.00,0.00,6.05,496.10,'2022-07-16 11:32:38','',''),(2478,'1','274','1',1,'Retail Sale Id 2413',18600.00,0.00,0.00,25.00,2050.00,'2022-07-16 11:37:55','',''),(2479,'1','274','1',1,'Retail Sale Id 2414',4501.20,0.00,0.00,6.05,496.10,'2022-07-16 11:44:44','',''),(2480,'1','274','1',1,'Retail Sale Id 2415',9300.00,0.00,0.00,12.50,1025.00,'2022-07-16 12:17:19','',''),(2481,'1','274','1',1,'Retail Sale Id 2416',9300.00,0.00,0.00,12.50,1025.00,'2022-07-16 12:23:04','',''),(2482,'1','274','1',1,'Retail Sale Id 2417',9300.00,0.00,0.00,12.50,1025.00,'2022-07-16 12:37:10','',''),(2483,'1','274','1',1,'Retail Sale Id 2418',9300.00,0.00,0.00,12.50,1025.00,'2022-07-16 12:40:01','',''),(2484,'1','274','1',1,'Retail Sale Id 2419',7998.00,0.00,0.00,10.75,881.50,'2022-07-16 12:44:59','',''),(2485,'1','274','1',1,'Retail Sale Id 2420',22320.00,0.00,0.00,30.00,2460.00,'2022-07-16 15:30:46','',''),(2486,'1','274','1',1,'Retail Sale Id 2421',4501.20,0.00,0.00,6.05,496.10,'2022-07-16 16:13:29','',''),(2487,'1','274','1',1,'Retail Sale Id 2422',83618.16,0.00,0.00,112.39,9215.98,'2022-07-16 16:15:45','',''),(2488,'1','274','1',1,'Retail Sale Id 2423',170472.72,0.00,0.00,229.13,18788.66,'2022-07-16 16:18:58','',''),(2489,'1','274','1',1,'Retail Sale Id 2424',24998.40,0.00,0.00,33.60,2755.20,'2022-07-16 18:35:35','',''),(2490,'1','274','1',1,'Retail Sale Id 2425',16368.00,0.00,0.00,22.00,1804.00,'2022-07-16 18:40:51','',''),(2491,'1','274','1',1,'Retail Sale Id 2426',16397.76,0.00,0.00,22.04,1807.28,'2022-07-16 18:41:58','',''),(2492,'1','274','1',1,'Return of Retail Sale Id 2425',0.00,16368.00,22.00,0.00,-1804.00,'2022-07-16 18:42:41','',''),(2493,'1','274','1',1,'Retail Sale Id 2427',2998.32,0.00,0.00,4.03,330.46,'2022-07-16 18:43:22','',''),(2494,'1','274','1',1,'Retail Sale Id 2428',2001.36,0.00,0.00,2.69,220.58,'2022-07-16 18:45:41','',''),(2495,'1','274','1',1,'Retail Sale Id 2429',9300.00,0.00,0.00,12.50,1025.00,'2022-07-16 18:58:05','',''),(2496,'1','274','1',1,'Retail Sale Id 2430',87806.88,0.00,0.00,118.02,9677.64,'2022-07-16 19:21:47','',''),(2497,'1','274','1',1,'Retail Sale Id 2431',3749.76,0.00,0.00,5.04,413.28,'2022-07-16 19:35:18','',''),(2498,'1','274','1',1,'Retail Sale Id 2432',602.64,0.00,0.00,0.81,66.42,'2022-07-17 07:05:21','',''),(2499,'1','274','1',1,'Retail Sale Id 2433',9300.00,0.00,0.00,12.50,1025.00,'2022-07-17 07:24:25','',''),(2500,'1','274','1',1,'Retail Sale Id 2434',1696.32,0.00,0.00,2.28,186.96,'2022-07-17 08:46:36','',''),(2501,'1','274','1',1,'Retail Sale Id 2435',2001.36,0.00,0.00,2.69,220.58,'2022-07-17 09:17:31','',''),(2502,'1','274','1',1,'Retail Sale Id 2436',2001.36,0.00,0.00,2.69,220.58,'2022-07-17 10:05:57','',''),(2503,'1','274','1',1,'Retail Sale Id 2437',4501.20,0.00,0.00,6.05,496.10,'2022-07-17 10:18:40','',''),(2504,'1','274','1',1,'Retail Sale Id 2438',2998.32,0.00,0.00,4.03,330.46,'2022-07-17 10:52:13','',''),(2505,'1','274','1',1,'Retail Sale Id 2439',1502.88,0.00,0.00,2.02,165.64,'2022-07-17 10:54:16','',''),(2506,'1','274','1',1,'Retail Sale Id 2440',4501.20,0.00,0.00,6.05,496.10,'2022-07-17 11:36:25','',''),(2507,'1','274','1',1,'Retail Sale Id 2441',9300.00,0.00,0.00,12.50,1025.00,'2022-07-17 11:39:46','',''),(2508,'1','274','1',1,'Retail Sale Id 2442',9300.00,0.00,0.00,12.50,1025.00,'2022-07-17 11:40:51','',''),(2509,'1','274','1',1,'Retail Sale Id 2443',4501.20,0.00,0.00,6.05,496.10,'2022-07-17 12:07:52','',''),(2510,'1','274','1',1,'Retail Sale Id 2444',996.96,0.00,0.00,1.34,109.88,'2022-07-17 12:25:53','',''),(2511,'1','274','1',1,'Retail Sale Id 2445',9672.00,0.00,0.00,13.00,1066.00,'2022-07-17 12:32:53','',''),(2512,'1','274','1',1,'Retail Sale Id 2446',9300.00,0.00,0.00,12.50,1025.00,'2022-07-17 12:43:38','',''),(2513,'1','274','1',1,'Retail Sale Id 2446',37200.00,0.00,0.00,50.00,4100.00,'2022-07-17 12:43:38','',''),(2514,'1','274','1',1,'Retail Sale Id 2447',2246.88,0.00,0.00,3.02,247.64,'2022-07-17 12:46:23','',''),(2515,'1','274','1',1,'Retail Sale Id 2448',4501.20,0.00,0.00,6.05,496.10,'2022-07-17 12:47:41','',''),(2516,'1','274','1',1,'Retail Sale Id 2449',1502.88,0.00,0.00,2.02,165.64,'2022-07-17 12:54:06','',''),(2517,'1','274','1',1,'Retail Sale Id 2450',2246.88,0.00,0.00,3.02,247.64,'2022-07-17 12:56:47','',''),(2518,'1','274','1',1,'Retail Sale Id 2451',22997.04,0.00,0.00,30.91,2534.62,'2022-07-17 13:00:12','',''),(2519,'1','274','1',1,'Retail Sale Id 2452',9300.00,0.00,0.00,12.50,1025.00,'2022-07-17 13:28:51','',''),(2520,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,64247.10,97.05,0.00,0.00,'2022-07-17 14:41:02','',''),(2521,'1','274',NULL,1,'Reception corrector for bridging 16',0.00,0.00,0.00,97.05,0.00,'2022-07-17 14:42:30','',''),(2522,'1','274','1',1,'Received from bridging 16',0.00,0.00,97.05,0.00,0.00,'2022-07-17 14:42:30','',''),(2523,'1','274','1',1,'Retail Sale Id 2453',989.52,0.00,0.00,1.33,109.06,'2022-07-17 14:43:48','',''),(2524,'1','274','1',1,'Retail Sale Id 2453',75798.72,0.00,0.00,101.88,8354.16,'2022-07-17 14:43:49','',''),(2525,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,662000.00,1000.00,0.00,0.00,'2022-07-17 16:34:41','',''),(2526,'1','274',NULL,1,'Reception corrector for bridging 17',0.00,0.00,0.00,1000.00,0.00,'2022-07-17 16:36:01','',''),(2527,'1','274','1',1,'Received from bridging 17',0.00,0.00,1000.00,0.00,0.00,'2022-07-17 16:36:01','',''),(2528,'1','274','1',1,'Retail Sale Id 2454',2246.88,0.00,0.00,3.02,247.64,'2022-07-17 16:37:16','',''),(2529,'1','274','1',1,'Retail Sale Id 2455',3199.20,0.00,0.00,4.30,352.60,'2022-07-17 16:37:49','',''),(2530,'1','274','1',1,'Retail Sale Id 2456',32996.40,0.00,0.00,44.35,3636.70,'2022-07-17 18:47:41','',''),(2531,'1','274','1',1,'Retail Sale Id 2457',9300.00,0.00,0.00,12.50,1025.00,'2022-07-17 18:50:13','',''),(2532,'1','274','1',1,'Retail Sale Id 2458',4501.20,0.00,0.00,6.05,496.10,'2022-07-17 18:58:59','',''),(2533,'1','274','1',1,'Retail Sale Id 2459',2001.36,0.00,0.00,2.69,220.58,'2022-07-17 19:14:56','',''),(2534,'1','274','1',1,'Retail Sale Id 2460',2998.32,0.00,0.00,4.03,330.46,'2022-07-17 19:22:35','',''),(2535,'1','274','1',1,'Retail Sale Id 2461',9300.00,0.00,0.00,12.50,1025.00,'2022-07-17 19:49:46','',''),(2536,'1','274','1',1,'Retail Sale Id 2461',37200.00,0.00,0.00,50.00,4100.00,'2022-07-17 19:49:46','',''),(2537,'1','274','1',1,'Retail Sale Id 2462',9404.16,0.00,0.00,12.64,1036.48,'2022-07-17 20:50:20','',''),(2538,'1','274','1',1,'Retail Sale Id 2462',55599.12,0.00,0.00,74.73,6127.86,'2022-07-17 20:50:20','',''),(2539,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,2456020.00,3710.00,0.00,0.00,'2022-07-17 22:08:01','',''),(2540,'1','274',NULL,1,'Reception corrector for bridging 18',0.00,0.00,0.00,3710.00,0.00,'2022-07-17 22:09:17','',''),(2541,'1','274','1',1,'Received from bridging 18',0.00,0.00,3710.00,0.00,0.00,'2022-07-17 22:09:17','',''),(2542,'1','274','1',1,'Retail Sale Id 2463',7440.00,0.00,0.00,10.00,820.00,'2022-07-18 07:24:04','',''),(2543,'1','274','1',1,'Retail Sale Id 2464',9300.00,0.00,0.00,12.50,1025.00,'2022-07-18 07:38:38','',''),(2544,'1','274','1',1,'Retail Sale Id 2465',2001.36,0.00,0.00,2.69,220.58,'2022-07-18 07:57:48','',''),(2545,'1','274','1',1,'Retail Sale Id 2465',7998.00,0.00,0.00,10.75,881.50,'2022-07-18 07:57:48','',''),(2546,'1','274','1',1,'Retail Sale Id 2466',9300.00,0.00,0.00,12.50,1025.00,'2022-07-18 08:31:50','',''),(2547,'1','274','1',1,'Retail Sale Id 2467',4501.20,0.00,0.00,6.05,496.10,'2022-07-18 08:46:24','',''),(2548,'1','274','1',1,'Retail Sale Id 2468',7440.00,0.00,0.00,10.00,820.00,'2022-07-18 10:53:58','',''),(2549,'1','274','1',1,'Retail Sale Id 2468',37200.00,0.00,0.00,50.00,4100.00,'2022-07-18 10:53:58','',''),(2550,'1','274','1',1,'Retail Sale Id 2469',18600.00,0.00,0.00,25.00,2050.00,'2022-07-18 10:57:31','',''),(2551,'1','274','1',1,'Retail Sale Id 2470',9300.00,0.00,0.00,12.50,1025.00,'2022-07-18 11:08:25','',''),(2552,'1','274','1',1,'Retail Sale Id 2471',4501.20,0.00,0.00,6.05,496.10,'2022-07-18 11:17:12','',''),(2553,'1','274','1',1,'Retail Sale Id 2471',9300.00,0.00,0.00,12.50,1025.00,'2022-07-18 11:17:12','',''),(2554,'1','274','1',1,'Retail Sale Id 2472',9300.00,0.00,0.00,12.50,1025.00,'2022-07-18 11:22:42','',''),(2555,'1','274','1',1,'Retail Sale Id 2473',13399.44,0.00,0.00,18.01,1476.82,'2022-07-18 11:41:02','',''),(2556,'1','274','1',1,'Retail Sale Id 2474',9300.00,0.00,0.00,12.50,1025.00,'2022-07-18 11:51:13','',''),(2557,'1','274','1',1,'Retail Sale Id 2475',9300.00,0.00,0.00,12.50,1025.00,'2022-07-18 11:59:56','',''),(2558,'1','274','1',1,'Retail Sale Id 2476',3720.00,0.00,0.00,5.00,410.00,'2022-07-18 12:22:37','',''),(2559,'1','274','1',1,'Retail Sale Id 2478',996.96,0.00,0.00,1.34,109.88,'2022-07-18 12:51:04','',''),(2560,'1','274','1',1,'Retail Sale Id 2480',9300.00,0.00,0.00,12.50,1025.00,'2022-07-18 14:15:46','',''),(2561,'1','274','1',1,'Retail Sale Id 2481',1502.88,0.00,0.00,2.02,165.64,'2022-07-18 16:56:45','',''),(2562,'1','274','1',1,'Retail Sale Id 2482',4501.20,0.00,0.00,6.05,496.10,'2022-07-18 17:00:05','',''),(2563,'1','274','1',1,'Retail Sale Id 2483',16397.76,0.00,0.00,22.04,1807.28,'2022-07-18 17:11:33','',''),(2564,'1','274','1',1,'Retail Sale Id 2484',2202.24,0.00,0.00,2.96,242.72,'2022-07-18 17:37:00','',''),(2565,'1','274','1',1,'Retail Sale Id 2485',4501.20,0.00,0.00,6.05,496.10,'2022-07-18 17:42:48','',''),(2566,'1','274','1',1,'Retail Sale Id 2486',9701.76,0.00,0.00,13.04,1069.28,'2022-07-18 18:01:08','',''),(2567,'1','274','1',1,'Retail Sale Id 2487',3749.76,0.00,0.00,5.04,413.28,'2022-07-18 18:04:37','',''),(2568,'1','274','1',1,'Retail Sale Id 2488',4999.68,0.00,0.00,6.72,551.04,'2022-07-18 18:08:08','',''),(2569,'1','274','1',1,'Retail Sale Id 2490',2998.32,0.00,0.00,4.03,330.46,'2022-07-18 18:16:45','',''),(2570,'1','274','1',1,'Retail Sale Id 2491',1502.88,0.00,0.00,2.02,165.64,'2022-07-18 18:23:22','',''),(2571,'1','274','1',1,'Retail Sale Id 2492',1800.48,0.00,0.00,2.42,198.44,'2022-07-18 18:28:45','',''),(2572,'1','274','1',1,'Retail Sale Id 2493',9300.00,0.00,0.00,12.50,1025.00,'2022-07-18 18:29:44','',''),(2573,'1','274','1',1,'Retail Sale Id 2494',2001.36,0.00,0.00,2.69,220.58,'2022-07-18 18:30:37','',''),(2574,'1','274','1',1,'Retail Sale Id 2495',3749.76,0.00,0.00,5.04,413.28,'2022-07-18 18:44:58','',''),(2575,'1','274','1',1,'Retail Sale Id 2496',9300.00,0.00,0.00,12.50,1025.00,'2022-07-18 18:46:30','',''),(2576,'1','274','1',1,'Retail Sale Id 2497',9300.00,0.00,0.00,12.50,1025.00,'2022-07-18 18:52:25','',''),(2577,'1','274','1',1,'Retail Sale Id 2498',9300.00,0.00,0.00,12.50,1025.00,'2022-07-18 18:53:28','',''),(2578,'1','274','1',1,'Retail Sale Id 2499',14195.52,0.00,0.00,19.08,1564.56,'2022-07-18 19:04:48','',''),(2579,'1','274','1',1,'Retail Sale Id 2500',11301.36,0.00,0.00,15.19,1245.58,'2022-07-18 19:07:26','',''),(2580,'1','274','1',1,'Retail Sale Id 2501',140266.32,0.00,0.00,188.53,15459.46,'2022-07-18 19:32:20','',''),(2581,'1','274','1',1,'Retail Sale Id 2502',3199.20,0.00,0.00,4.30,352.60,'2022-07-19 07:00:01','',''),(2582,'1','274','1',1,'Retail Sale Id 2503',1502.88,0.00,0.00,2.02,165.64,'2022-07-19 07:22:43','',''),(2583,'1','274','1',1,'Retail Sale Id 2504',4501.20,0.00,0.00,6.05,496.10,'2022-07-19 07:23:15','',''),(2584,'1','274','1',1,'Retail Sale Id 2505',2001.36,0.00,0.00,2.69,220.58,'2022-07-19 07:24:25','',''),(2585,'1','274','1',1,'Retail Sale Id 2506',4501.20,0.00,0.00,6.05,496.10,'2022-07-19 07:50:22','',''),(2586,'1','274','1',1,'Retail Sale Id 2507',9300.00,0.00,0.00,12.50,1025.00,'2022-07-19 07:50:53','',''),(2587,'1','274','1',1,'Retail Sale Id 2508',9300.00,0.00,0.00,12.50,1025.00,'2022-07-19 08:04:14','',''),(2588,'1','274','1',1,'Retail Sale Id 2509',4999.68,0.00,0.00,6.72,551.04,'2022-07-19 08:10:02','',''),(2589,'1','274','1',1,'Retail Sale Id 2510',18600.00,0.00,0.00,25.00,2050.00,'2022-07-19 08:33:25','',''),(2590,'1','274','1',1,'Retail Sale Id 2512',9300.00,0.00,0.00,12.50,1025.00,'2022-07-19 08:49:14','',''),(2591,'1','274','1',1,'Retail Sale Id 2513',20497.20,0.00,0.00,27.55,2259.10,'2022-07-19 09:45:29','',''),(2592,'1','274','1',1,'Retail Sale Id 2514',37200.00,0.00,0.00,50.00,4100.00,'2022-07-19 10:09:41','',''),(2593,'1','274','1',1,'Retail Sale Id 2515',9002.40,0.00,0.00,12.10,992.20,'2022-07-19 12:18:43','',''),(2594,'1','274','1',1,'Retail Sale Id 2516',74400.00,0.00,0.00,100.00,8200.00,'2022-07-19 12:25:34','',''),(2595,'1','274','1',1,'Retail Sale Id 2517',9300.00,0.00,0.00,12.50,1025.00,'2022-07-19 15:22:49','',''),(2596,'1','274','1',1,'Retail Sale Id 2518',2246.88,0.00,0.00,3.02,247.64,'2022-07-19 15:28:03','',''),(2597,'1','274','1',1,'Retail Sale Id 2519',9300.00,0.00,0.00,12.50,1025.00,'2022-07-19 15:37:08','',''),(2598,'1','274','1',1,'Retail Sale Id 2520',45398.88,0.00,0.00,61.02,5003.64,'2022-07-19 15:48:33','',''),(2599,'1','274','1',1,'Retail Sale Id 2521',2499.84,0.00,0.00,3.36,275.52,'2022-07-19 15:54:36','',''),(2600,'1','274','1',1,'Retail Sale Id 2522',4501.20,0.00,0.00,6.05,496.10,'2022-07-19 15:55:48','',''),(2601,'1','274','1',1,'Retail Sale Id 2523',7499.52,0.00,0.00,10.08,826.56,'2022-07-19 16:16:18','',''),(2602,'1','274','1',1,'Retail Sale Id 2524',4999.68,0.00,0.00,6.72,551.04,'2022-07-19 16:19:46','',''),(2603,'1','274','1',1,'Retail Sale Id 2525',9300.00,0.00,0.00,12.50,1025.00,'2022-07-19 16:21:27','',''),(2604,'1','274','1',1,'Retail Sale Id 2526',9300.00,0.00,0.00,12.50,1025.00,'2022-07-19 17:06:41','',''),(2605,'1','274','1',1,'Retail Sale Id 2527',2998.32,0.00,0.00,4.03,330.46,'2022-07-19 17:25:27','',''),(2606,'1','274','1',1,'Retail Sale Id 2528',17298.00,0.00,0.00,23.25,1906.50,'2022-07-19 17:27:22','',''),(2607,'1','274','1',1,'Retail Sale Id 2529',9300.00,0.00,0.00,12.50,1025.00,'2022-07-19 17:33:46','',''),(2608,'1','274','1',1,'Retail Sale Id 2530',6703.44,0.00,0.00,9.01,738.82,'2022-07-19 17:36:50','',''),(2609,'1','274','1',1,'Retail Sale Id 2531',996.96,0.00,0.00,1.34,109.88,'2022-07-19 17:42:26','',''),(2610,'1','274','1',1,'Retail Sale Id 2532',6502.56,0.00,0.00,8.74,716.68,'2022-07-19 17:50:41','',''),(2611,'1','274','1',1,'Retail Sale Id 2533',11160.00,0.00,0.00,15.00,1230.00,'2022-07-19 18:25:46','',''),(2612,'1','274','1',1,'Retail Sale Id 2534',9300.00,0.00,0.00,12.50,1025.00,'2022-07-19 18:27:17','',''),(2613,'1','274','1',1,'Retail Sale Id 2535',4501.20,0.00,0.00,6.05,496.10,'2022-07-19 18:32:17','',''),(2614,'1','274','1',1,'Retail Sale Id 2536',9300.00,0.00,0.00,12.50,1025.00,'2022-07-19 18:36:16','',''),(2615,'1','274','1',1,'Retail Sale Id 2537',9300.00,0.00,0.00,12.50,1025.00,'2022-07-19 18:41:39','',''),(2616,'1','274','1',1,'Retail Sale Id 2538',9300.00,0.00,0.00,12.50,1025.00,'2022-07-19 18:46:45','',''),(2617,'1','274','1',1,'Retail Sale Id 2539',7499.52,0.00,0.00,10.08,826.56,'2022-07-19 18:47:45','',''),(2618,'1','274','1',1,'Retail Sale Id 2540',9701.76,0.00,0.00,13.04,1069.28,'2022-07-19 18:55:24','',''),(2619,'1','274','1',1,'Retail Sale Id 2541',110059.92,0.00,0.00,147.93,12130.26,'2022-07-19 19:16:10','',''),(2620,'1','274','1',1,'Return of Retail Sale Id 2520',0.00,45398.88,61.02,0.00,-5003.64,'2022-07-19 19:17:27','',''),(2621,'1','274','1',1,'Return of Retail Sale Id 2541',0.00,110059.92,147.93,0.00,-12130.26,'2022-07-19 19:18:26','',''),(2622,'1','274','1',1,'Retail Sale Id 2542',32922.00,0.00,0.00,44.25,3628.50,'2022-07-19 19:20:10','',''),(2623,'1','274','1',1,'Retail Sale Id 2543',110059.92,0.00,0.00,147.93,12130.26,'2022-07-19 19:22:33','',''),(2624,'1','274','1',1,'Retail Sale Id 2544',9999.36,0.00,0.00,13.44,1102.08,'2022-07-19 19:23:26','',''),(2625,'1','274','1',1,'Retail Sale Id 2545',4501.20,0.00,0.00,6.05,496.10,'2022-07-19 19:41:19','',''),(2626,'1','274','1',1,'Retail Sale Id 2546',4501.20,0.00,0.00,6.05,496.10,'2022-07-19 19:42:17','',''),(2627,'1','274','1',1,'Retail Sale Id 2547',4248.24,0.00,0.00,5.71,468.22,'2022-07-20 07:04:54','',''),(2628,'1','274','1',1,'Retail Sale Id 2548',9300.00,0.00,0.00,12.50,1025.00,'2022-07-20 07:05:31','',''),(2629,'1','274','1',1,'Retail Sale Id 2549',5952.00,0.00,0.00,8.00,656.00,'2022-07-20 07:05:57','',''),(2630,'1','274','1',1,'Retail Sale Id 2550',4002.72,0.00,0.00,5.38,441.16,'2022-07-20 08:14:05','',''),(2631,'1','274','1',1,'Retail Sale Id 2551',2998.32,0.00,0.00,4.03,330.46,'2022-07-20 08:19:43','',''),(2632,'1','274','1',1,'Retail Sale Id 2552',2998.32,0.00,0.00,4.03,330.46,'2022-07-20 08:20:48','',''),(2633,'1','274','1',1,'Retail Sale Id 2553',18600.00,0.00,0.00,25.00,2050.00,'2022-07-20 08:27:15','',''),(2634,'1','274','1',1,'Retail Sale Id 2554',2001.36,0.00,0.00,2.69,220.58,'2022-07-20 08:53:42','',''),(2635,'1','274','1',1,'Retail Sale Id 2555',9002.40,0.00,0.00,12.10,992.20,'2022-07-20 09:03:28','',''),(2636,'1','274','1',1,'Retail Sale Id 2556',6748.08,0.00,0.00,9.07,743.74,'2022-07-20 09:10:24','',''),(2637,'1','274','1',1,'Retail Sale Id 2557',9300.00,0.00,0.00,12.50,1025.00,'2022-07-20 09:35:33','',''),(2638,'1','274','1',1,'Retail Sale Id 2558',2998.32,0.00,0.00,4.03,330.46,'2022-07-20 09:56:03','',''),(2639,'1','274','1',1,'Retail Sale Id 2559',2998.32,0.00,0.00,4.03,330.46,'2022-07-20 11:18:26','',''),(2640,'1','274','1',1,'Retail Sale Id 2560',7998.00,0.00,0.00,10.75,881.50,'2022-07-20 11:20:18','',''),(2641,'1','274','1',1,'Retail Sale Id 2561',4999.68,0.00,0.00,6.72,551.04,'2022-07-20 11:26:19','',''),(2642,'1','274','1',1,'Retail Sale Id 2562',4999.68,0.00,0.00,6.72,551.04,'2022-07-20 12:29:58','',''),(2643,'1','274','1',1,'Retail Sale Id 2563',18600.00,0.00,0.00,25.00,2050.00,'2022-07-20 12:42:37','',''),(2644,'1','274','1',1,'Retail Sale Id 2564',1502.88,0.00,0.00,2.02,165.64,'2022-07-20 13:30:57','',''),(2645,'1','274','1',1,'Retail Sale Id 2565',1502.88,0.00,0.00,2.02,165.64,'2022-07-20 13:35:33','',''),(2646,'1','274','1',1,'Retail Sale Id 2566',2998.32,0.00,0.00,4.03,330.46,'2022-07-20 14:06:00','',''),(2647,'1','274','1',1,'Retail Sale Id 2567',996.96,0.00,0.00,1.34,109.88,'2022-07-20 14:08:41','',''),(2648,'1','274','1',1,'Retail Sale Id 2568',2499.84,0.00,0.00,3.36,275.52,'2022-07-20 14:20:05','',''),(2649,'1','274','1',1,'Retail Sale Id 2569',2001.36,0.00,0.00,2.69,220.58,'2022-07-20 14:47:48','',''),(2650,'1','274','1',1,'Retail Sale Id 2570',7998.00,0.00,0.00,10.75,881.50,'2022-07-20 14:51:31','',''),(2651,'1','274','1',1,'Retail Sale Id 2571',37200.00,0.00,0.00,50.00,4100.00,'2022-07-20 14:55:37','',''),(2652,'1','274','1',1,'Retail Sale Id 2572',25496.88,0.00,0.00,34.27,2810.14,'2022-07-20 15:00:29','',''),(2653,'1','274','1',1,'Retail Sale Id 2573',9300.00,0.00,0.00,12.50,1025.00,'2022-07-20 15:56:47','',''),(2654,'1','274','1',1,'Retail Sale Id 2574',3720.00,0.00,0.00,5.00,410.00,'2022-07-20 15:57:48','',''),(2655,'1','274','1',1,'Retail Sale Id 2575',9300.00,0.00,0.00,12.50,1025.00,'2022-07-20 16:30:56','',''),(2656,'1','274','1',1,'Retail Sale Id 2576',996.96,0.00,0.00,1.34,109.88,'2022-07-20 16:40:44','',''),(2657,'1','274','1',1,'Retail Sale Id 2577',9300.00,0.00,0.00,12.50,1025.00,'2022-07-20 16:44:58','',''),(2658,'1','274','1',1,'Retail Sale Id 2578',2001.36,0.00,0.00,2.69,220.58,'2022-07-20 17:01:21','',''),(2659,'1','274','1',1,'Retail Sale Id 2579',5996.64,0.00,0.00,8.06,660.92,'2022-07-20 17:23:35','',''),(2660,'1','274','1',1,'Retail Sale Id 2580',4501.20,0.00,0.00,6.05,496.10,'2022-07-20 17:25:29','',''),(2661,'1','274','1',1,'Retail Sale Id 2581',498.48,0.00,0.00,0.67,54.94,'2022-07-20 17:28:12','',''),(2662,'1','274','1',1,'Retail Sale Id 2582',803.52,0.00,0.00,1.08,88.56,'2022-07-20 17:38:10','',''),(2663,'1','274','1',1,'Retail Sale Id 2583',1502.88,0.00,0.00,2.02,165.64,'2022-07-20 17:53:52','',''),(2664,'1','274','1',1,'Retail Sale Id 2584',9300.00,0.00,0.00,12.50,1025.00,'2022-07-20 18:00:35','',''),(2665,'1','274','1',1,'Retail Sale Id 2585',9300.00,0.00,0.00,12.50,1025.00,'2022-07-20 18:06:06','',''),(2666,'1','274','1',1,'Retail Sale Id 2586',16368.00,0.00,0.00,22.00,1804.00,'2022-07-20 18:09:34','',''),(2667,'1','274','1',1,'Retail Sale Id 2587',3720.00,0.00,0.00,5.00,410.00,'2022-07-20 18:12:57','',''),(2668,'1','274','1',1,'Retail Sale Id 2588',996.96,0.00,0.00,1.34,109.88,'2022-07-20 18:34:50','',''),(2669,'1','274','1',1,'Retail Sale Id 2589',4002.72,0.00,0.00,5.38,441.16,'2022-07-20 18:38:39','',''),(2670,'1','274','1',1,'Retail Sale Id 2590',9300.00,0.00,0.00,12.50,1025.00,'2022-07-20 18:39:30','',''),(2671,'1','274','1',1,'Retail Sale Id 2591',1696.32,0.00,0.00,2.28,186.96,'2022-07-20 18:44:12','',''),(2672,'1','274','1',1,'Retail Sale Id 2592',2499.84,0.00,0.00,3.36,275.52,'2022-07-20 18:44:55','',''),(2673,'1','274','1',1,'Retail Sale Id 2593',9300.00,0.00,0.00,12.50,1025.00,'2022-07-20 19:13:21','',''),(2674,'1','274','1',1,'Retail Sale Id 2594',37200.00,0.00,0.00,50.00,4100.00,'2022-07-20 19:14:58','',''),(2675,'1','274','1',1,'Retail Sale Id 2595',9300.00,0.00,0.00,12.50,1025.00,'2022-07-20 19:16:40','',''),(2676,'1','274','1',1,'Retail Sale Id 2596',803.52,0.00,0.00,1.08,88.56,'2022-07-20 19:18:41','',''),(2677,'1','274','1',1,'Retail Sale Id 2597',1502.88,0.00,0.00,2.02,165.64,'2022-07-20 19:22:39','',''),(2678,'1','274','1',1,'Retail Sale Id 2598',70040.16,0.00,0.00,94.14,7719.48,'2022-07-20 19:40:51','',''),(2679,'1','274','1',1,'Retail Sale Id 2599',13020.00,0.00,0.00,17.50,1435.00,'2022-07-20 19:44:06','',''),(2680,'1','274','1',1,'Retail Sale Id 2600',13302.72,0.00,0.00,17.88,1466.16,'2022-07-21 07:54:59','',''),(2681,'1','274','1',1,'Retail Sale Id 2601',37200.00,0.00,0.00,50.00,4100.00,'2022-07-21 10:54:16','',''),(2682,'1','274','1',1,'Retail Sale Id 2602',74400.00,0.00,0.00,100.00,8200.00,'2022-07-21 11:23:44','',''),(2683,'1','274','1',1,'Retail Sale Id 2603',2001.36,0.00,0.00,2.69,220.58,'2022-07-21 12:31:47','',''),(2684,'1','274','1',1,'Retail Sale Id 2604',2499.84,0.00,0.00,3.36,275.52,'2022-07-21 13:21:40','',''),(2685,'1','274','1',1,'Retail Sale Id 2605',996.96,0.00,0.00,1.34,109.88,'2022-07-21 13:29:23','',''),(2686,'1','274','1',1,'Retail Sale Id 2606',36456.00,0.00,0.00,49.00,4018.00,'2022-07-21 13:53:27','',''),(2687,'1','274','1',1,'Retail Sale Id 2607',9300.00,0.00,0.00,12.50,1025.00,'2022-07-21 13:56:06','',''),(2688,'1','274','1',1,'Retail Sale Id 2608',2246.88,0.00,0.00,3.02,247.64,'2022-07-21 13:57:24','',''),(2689,'1','274','1',1,'Retail Sale Id 2609',4501.20,0.00,0.00,6.05,496.10,'2022-07-21 14:00:08','',''),(2690,'1','274','1',1,'Retail Sale Id 2610',2998.32,0.00,0.00,4.03,330.46,'2022-07-21 14:12:02','',''),(2691,'1','274','1',1,'Retail Sale Id 2611',2001.36,0.00,0.00,2.69,220.58,'2022-07-21 14:36:35','',''),(2692,'1','274','1',1,'Retail Sale Id 2612',4501.20,0.00,0.00,6.05,496.10,'2022-07-21 14:39:49','',''),(2693,'1','274','1',1,'Retail Sale Id 2613',18600.00,0.00,0.00,25.00,2050.00,'2022-07-21 15:06:11','',''),(2694,'1','274','1',1,'Retail Sale Id 2614',9300.00,0.00,0.00,12.50,1025.00,'2022-07-21 15:11:56','',''),(2695,'1','274','1',1,'Retail Sale Id 2615',9300.00,0.00,0.00,12.50,1025.00,'2022-07-21 15:44:33','',''),(2696,'1','274','1',1,'Retail Sale Id 2616',1502.88,0.00,0.00,2.02,165.64,'2022-07-21 15:47:48','',''),(2697,'1','274','1',1,'Retail Sale Id 2617',2246.88,0.00,0.00,3.02,247.64,'2022-07-21 15:59:22','',''),(2698,'1','274','1',1,'Retail Sale Id 2618',18600.00,0.00,0.00,25.00,2050.00,'2022-07-21 16:02:17','',''),(2699,'1','274','1',1,'Retail Sale Id 2619',3496.80,0.00,0.00,4.70,385.40,'2022-07-21 16:04:41','',''),(2700,'1','274','1',1,'Retail Sale Id 2620',996.96,0.00,0.00,1.34,109.88,'2022-07-21 16:26:59','',''),(2701,'1','274','1',1,'Retail Sale Id 2621',2001.36,0.00,0.00,2.69,220.58,'2022-07-21 16:37:53','',''),(2702,'1','274','1',1,'Retail Sale Id 2622',2499.84,0.00,0.00,3.36,275.52,'2022-07-21 17:05:16','',''),(2703,'1','274','1',1,'Retail Sale Id 2623',4397.04,0.00,0.00,5.91,484.62,'2022-07-21 17:07:00','',''),(2704,'1','274','1',1,'Retail Sale Id 2624',16368.00,0.00,0.00,22.00,1804.00,'2022-07-21 18:31:51','',''),(2705,'1','274','1',1,'Retail Sale Id 2625',4999.68,0.00,0.00,6.72,551.04,'2022-07-21 18:32:40','',''),(2706,'1','274','1',1,'Retail Sale Id 2626',9300.00,0.00,0.00,12.50,1025.00,'2022-07-21 18:35:17','',''),(2707,'1','274','1',1,'Retail Sale Id 2627',130758.00,0.00,0.00,175.75,14411.50,'2022-07-21 19:37:27','',''),(2708,'1','274','1',1,'Retail Sale Id 2628',8972.64,0.00,0.00,12.06,988.92,'2022-07-21 19:39:31','',''),(2709,'1','274','1',1,'Retail Sale Id 2629',9300.00,0.00,0.00,12.50,1025.00,'2022-07-22 08:46:22','',''),(2710,'1','274','1',1,'Retail Sale Id 2631',9300.00,0.00,0.00,12.50,1025.00,'2022-07-22 09:57:23','',''),(2711,'1','274','1',1,'Retail Sale Id 2630',9300.00,0.00,0.00,12.50,1025.00,'2022-07-22 09:58:17','',''),(2712,'1','274','1',1,'Retail Sale Id 2633',9300.00,0.00,0.00,12.50,1025.00,'2022-07-22 11:27:30','',''),(2713,'1','274','1',1,'Retail Sale Id 2634',7001.04,0.00,0.00,9.41,771.62,'2022-07-22 12:01:07','',''),(2714,'1','274','1',1,'Retail Sale Id 2635',2998.32,0.00,0.00,4.03,330.46,'2022-07-22 12:10:37','',''),(2715,'1','274','1',1,'Retail Sale Id 2636',148800.00,0.00,0.00,200.00,16400.00,'2022-07-22 12:17:38','',''),(2716,'1','274','1',1,'Retail Sale Id 2637',9300.00,0.00,0.00,12.50,1025.00,'2022-07-22 14:27:29','',''),(2717,'1','274','1',1,'Retail Sale Id 2638',9300.00,0.00,0.00,12.50,1025.00,'2022-07-22 15:14:05','',''),(2718,'1','274','1',1,'Retail Sale Id 2639',2499.84,0.00,0.00,3.36,275.52,'2022-07-22 15:24:09','',''),(2719,'1','274','1',1,'Retail Sale Id 2640',4002.72,0.00,0.00,5.38,441.16,'2022-07-22 15:24:39','',''),(2720,'1','274','1',1,'Retail Sale Id 2641',4002.72,0.00,0.00,5.38,441.16,'2022-07-22 15:29:46','',''),(2721,'1','274','1',1,'Retail Sale Id 2642',4501.20,0.00,0.00,6.05,496.10,'2022-07-22 15:59:10','',''),(2722,'1','274','1',1,'Retail Sale Id 2643',4501.20,0.00,0.00,6.05,496.10,'2022-07-22 16:02:28','',''),(2723,'1','274','1',1,'Retail Sale Id 2644',2998.32,0.00,0.00,4.03,330.46,'2022-07-22 16:12:50','',''),(2724,'1','274','1',1,'Retail Sale Id 2645',2998.32,0.00,0.00,4.03,330.46,'2022-07-22 16:13:33','',''),(2725,'1','274','1',1,'Retail Sale Id 2646',9300.00,0.00,0.00,12.50,1025.00,'2022-07-22 16:26:59','',''),(2726,'1','274','1',1,'Retail Sale Id 2647',4501.20,0.00,0.00,6.05,496.10,'2022-07-22 17:12:41','',''),(2727,'1','274','1',1,'Retail Sale Id 2649',2499.84,0.00,0.00,3.36,275.52,'2022-07-22 17:13:27','',''),(2728,'1','274','1',1,'Retail Sale Id 2650',22320.00,0.00,0.00,30.00,2460.00,'2022-07-22 17:29:33','',''),(2729,'1','274','1',1,'Retail Sale Id 2651',18600.00,0.00,0.00,25.00,2050.00,'2022-07-22 17:58:59','',''),(2730,'1','274','1',1,'Retail Sale Id 2652',2246.88,0.00,0.00,3.02,247.64,'2022-07-22 18:19:07','',''),(2731,'1','274','1',1,'Retail Sale Id 2653',9300.00,0.00,0.00,12.50,1025.00,'2022-07-22 18:20:51','',''),(2732,'1','274','1',1,'Retail Sale Id 2654',2246.88,0.00,0.00,3.02,247.64,'2022-07-22 18:23:20','',''),(2733,'1','274','1',1,'Retail Sale Id 2655',1502.88,0.00,0.00,2.02,165.64,'2022-07-22 18:26:01','',''),(2734,'1','274','1',1,'Retail Sale Id 2656',9300.00,0.00,0.00,12.50,1025.00,'2022-07-22 18:33:59','',''),(2735,'1','274','1',1,'Retail Sale Id 2657',9300.00,0.00,0.00,12.50,1025.00,'2022-07-22 18:42:58','',''),(2736,'1','274','1',1,'Retail Sale Id 2658',9300.00,0.00,0.00,12.50,1025.00,'2022-07-22 18:46:31','',''),(2737,'1','274','1',1,'Retail Sale Id 2659',9300.00,0.00,0.00,12.50,1025.00,'2022-07-22 18:58:10','',''),(2738,'1','274','1',1,'Retail Sale Id 2660',9002.40,0.00,0.00,12.10,992.20,'2022-07-22 18:58:41','',''),(2739,'1','274','1',1,'Retail Sale Id 2661',2298.96,0.00,0.00,3.09,253.38,'2022-07-22 19:00:32','',''),(2740,'1','274','1',1,'Retail Sale Id 2662',9300.00,0.00,0.00,12.50,1025.00,'2022-07-22 19:02:14','',''),(2741,'1','274','1',1,'Retail Sale Id 2663',17498.88,0.00,0.00,23.52,1928.64,'2022-07-22 19:04:00','',''),(2742,'1','274','1',1,'Retail Sale Id 2664',2001.36,0.00,0.00,2.69,220.58,'2022-07-22 19:05:38','',''),(2743,'1','274','1',1,'Retail Sale Id 2665',30913.20,0.00,0.00,41.55,3407.10,'2022-07-22 19:54:19','',''),(2744,'1','274','1',1,'Retail Sale Id 2666',3295.92,0.00,0.00,4.43,363.26,'2022-07-22 19:56:50','',''),(2745,'1','274','1',1,'Retail Sale Id 2667',9300.00,0.00,0.00,12.50,1025.00,'2022-07-23 07:53:17','',''),(2746,'1','274','1',1,'Retail Sale Id 2668',9300.00,0.00,0.00,12.50,1025.00,'2022-07-23 08:05:07','',''),(2747,'1','274','1',1,'Retail Sale Id 2670',5996.64,0.00,0.00,8.06,660.92,'2022-07-23 08:20:59','',''),(2748,'1','274','1',1,'Retail Sale Id 2672',2246.88,0.00,0.00,3.02,247.64,'2022-07-23 08:33:13','',''),(2749,'1','274','1',1,'Retail Sale Id 2674',7440.00,0.00,0.00,10.00,820.00,'2022-07-23 08:51:33','',''),(2750,'1','274','1',1,'Retail Sale Id 2676',3720.00,0.00,0.00,5.00,410.00,'2022-07-23 09:15:57','',''),(2751,'1','274','1',1,'Retail Sale Id 2678',9300.00,0.00,0.00,12.50,1025.00,'2022-07-23 09:22:47','',''),(2752,'1','274','1',1,'Retail Sale Id 2679',16368.00,0.00,0.00,22.00,1804.00,'2022-07-23 09:46:06','',''),(2753,'1','274','1',1,'Retail Sale Id 2680',2998.32,0.00,0.00,4.03,330.46,'2022-07-23 09:50:47','',''),(2754,'1','274','1',1,'Retail Sale Id 2681',1502.88,0.00,0.00,2.02,165.64,'2022-07-23 09:55:01','',''),(2755,'1','274','1',1,'Retail Sale Id 2682',9300.00,0.00,0.00,12.50,1025.00,'2022-07-23 09:57:50','',''),(2756,'1','274','1',1,'Retail Sale Id 2683',3898.56,0.00,0.00,5.24,429.68,'2022-07-23 10:07:24','',''),(2757,'1','274','1',1,'Retail Sale Id 2684',8184.00,0.00,0.00,11.00,902.00,'2022-07-23 10:12:41','',''),(2758,'1','274','1',1,'Retail Sale Id 2685',9300.00,0.00,0.00,12.50,1025.00,'2022-07-23 10:13:37','',''),(2759,'1','274','1',1,'Retail Sale Id 2686',9300.00,0.00,0.00,12.50,1025.00,'2022-07-23 10:21:50','',''),(2760,'1','274','1',1,'Retail Sale Id 2687',3749.76,0.00,0.00,5.04,413.28,'2022-07-23 10:26:33','',''),(2761,'1','274','1',1,'Retail Sale Id 2688',8250.96,0.00,0.00,11.09,909.38,'2022-07-23 10:28:05','',''),(2762,'1','274','1',1,'Retail Sale Id 2689',9300.00,0.00,0.00,12.50,1025.00,'2022-07-23 10:40:37','',''),(2763,'1','274','1',1,'Retail Sale Id 2690',4397.04,0.00,0.00,5.91,484.62,'2022-07-23 10:47:31','',''),(2764,'1','274','1',1,'Retail Sale Id 2691',16003.44,0.00,0.00,21.51,1763.82,'2022-07-23 11:06:02','',''),(2765,'1','274','1',1,'Retail Sale Id 2692',4501.20,0.00,0.00,6.05,496.10,'2022-07-23 11:07:51','',''),(2766,'1','274','1',1,'Retail Sale Id 2693',17856.00,0.00,0.00,24.00,1968.00,'2022-07-23 11:08:52','',''),(2767,'1','274','1',1,'Retail Sale Id 2694',2998.32,0.00,0.00,4.03,330.46,'2022-07-23 11:14:36','',''),(2768,'1','274','1',1,'Retail Sale Id 2695',9300.00,0.00,0.00,12.50,1025.00,'2022-07-23 11:17:23','',''),(2769,'1','274','1',1,'Retail Sale Id 2696',2001.36,0.00,0.00,2.69,220.58,'2022-07-23 11:31:46','',''),(2770,'1','274','1',1,'Retail Sale Id 2698',6249.60,0.00,0.00,8.40,688.80,'2022-07-23 11:35:11','',''),(2771,'1','274','1',1,'Retail Sale Id 2699',9300.00,0.00,0.00,12.50,1025.00,'2022-07-23 12:43:52','',''),(2772,'1','274','1',1,'Retail Sale Id 2700',1502.88,0.00,0.00,2.02,165.64,'2022-07-23 12:44:42','',''),(2773,'1','274','1',1,'Retail Sale Id 2701',37200.00,0.00,0.00,50.00,4100.00,'2022-07-23 12:45:41','',''),(2774,'1','274','1',1,'Retail Sale Id 2702',9300.00,0.00,0.00,12.50,1025.00,'2022-07-23 12:57:20','',''),(2775,'1','274','1',1,'Retail Sale Id 2703',2246.88,0.00,0.00,3.02,247.64,'2022-07-23 13:01:04','',''),(2776,'1','274','1',1,'Retail Sale Id 2704',2998.32,0.00,0.00,4.03,330.46,'2022-07-23 13:03:52','',''),(2777,'1','274','1',1,'Retail Sale Id 2705',9300.00,0.00,0.00,12.50,1025.00,'2022-07-23 13:16:47','',''),(2778,'1','274','1',1,'Retail Sale Id 2706',9300.00,0.00,0.00,12.50,1025.00,'2022-07-23 13:26:15','',''),(2779,'1','274','1',1,'Retail Sale Id 2707',9300.00,0.00,0.00,12.50,1025.00,'2022-07-23 13:44:29','',''),(2780,'1','274','1',1,'Retail Sale Id 2708',9300.00,0.00,0.00,12.50,1025.00,'2022-07-23 14:03:13','',''),(2781,'1','274','1',1,'Retail Sale Id 2709',996.96,0.00,0.00,1.34,109.88,'2022-07-23 14:04:43','',''),(2782,'1','274','1',1,'Retail Sale Id 2710',9300.00,0.00,0.00,12.50,1025.00,'2022-07-23 14:17:05','',''),(2783,'1','274','1',1,'Retail Sale Id 2711',1502.88,0.00,0.00,2.02,165.64,'2022-07-23 14:41:12','',''),(2784,'1','274','1',1,'Retail Sale Id 2712',2998.32,0.00,0.00,4.03,330.46,'2022-07-23 15:21:24','',''),(2785,'1','274','1',1,'Retail Sale Id 2713',9002.40,0.00,0.00,12.10,992.20,'2022-07-23 15:34:06','',''),(2786,'1','274','1',1,'Retail Sale Id 2714',848.16,0.00,0.00,1.14,93.48,'2022-07-23 15:46:11','',''),(2787,'1','274','1',1,'Retail Sale Id 2715',8496.48,0.00,0.00,11.42,936.44,'2022-07-23 15:47:31','',''),(2788,'1','274','1',1,'Retail Sale Id 2716',3749.76,0.00,0.00,5.04,413.28,'2022-07-23 16:09:44','',''),(2789,'1','274','1',1,'Retail Sale Id 2717',3749.76,0.00,0.00,5.04,413.28,'2022-07-23 16:19:10','',''),(2790,'1','274','1',1,'Retail Sale Id 2718',4501.20,0.00,0.00,6.05,496.10,'2022-07-23 16:27:58','',''),(2791,'1','274','1',1,'Retail Sale Id 2719',2246.88,0.00,0.00,3.02,247.64,'2022-07-23 16:59:57','',''),(2792,'1','274','1',1,'Retail Sale Id 2720',22320.00,0.00,0.00,30.00,2460.00,'2022-07-23 17:07:11','',''),(2793,'1','274','1',1,'Retail Sale Id 2721',17997.36,0.00,0.00,24.19,1983.58,'2022-07-23 17:08:03','',''),(2794,'1','274','1',1,'Retail Sale Id 2722',3496.80,0.00,0.00,4.70,385.40,'2022-07-23 17:12:23','',''),(2795,'1','274','1',1,'Retail Sale Id 2724',4999.68,0.00,0.00,6.72,551.04,'2022-07-23 17:14:23','',''),(2796,'1','274','1',1,'Retail Sale Id 2725',9300.00,0.00,0.00,12.50,1025.00,'2022-07-23 17:20:28','',''),(2797,'1','274','1',1,'Retail Sale Id 2726',9300.00,0.00,0.00,12.50,1025.00,'2022-07-23 17:35:39','',''),(2798,'1','274','1',1,'Retail Sale Id 2727',996.96,0.00,0.00,1.34,109.88,'2022-07-23 17:36:31','',''),(2799,'1','274','1',1,'Retail Sale Id 2728',1800.48,0.00,0.00,2.42,198.44,'2022-07-23 18:02:41','',''),(2800,'1','274','1',1,'Retail Sale Id 2729',9300.00,0.00,0.00,12.50,1025.00,'2022-07-23 18:03:31','',''),(2801,'1','274','1',1,'Retail Sale Id 2730',6748.08,0.00,0.00,9.07,743.74,'2022-07-23 18:06:28','',''),(2802,'1','274','1',1,'Retail Sale Id 2731',9300.00,0.00,0.00,12.50,1025.00,'2022-07-23 18:07:52','',''),(2803,'1','274','1',1,'Retail Sale Id 2732',4501.20,0.00,0.00,6.05,496.10,'2022-07-23 18:12:20','',''),(2804,'1','274','1',1,'Retail Sale Id 2733',2001.36,0.00,0.00,2.69,220.58,'2022-07-23 18:14:46','',''),(2805,'1','274','1',1,'Retail Sale Id 2734',1502.88,0.00,0.00,2.02,165.64,'2022-07-23 18:25:09','',''),(2806,'1','274','1',1,'Retail Sale Id 2735',4501.20,0.00,0.00,6.05,496.10,'2022-07-23 18:27:22','',''),(2807,'1','274','1',1,'Retail Sale Id 2736',1398.72,0.00,0.00,1.88,154.16,'2022-07-23 18:29:31','',''),(2808,'1','274','1',1,'Retail Sale Id 2737',2998.32,0.00,0.00,4.03,330.46,'2022-07-23 18:36:31','',''),(2809,'1','274','1',1,'Retail Sale Id 2738',9672.00,0.00,0.00,13.00,1066.00,'2022-07-23 18:37:04','',''),(2810,'1','274','1',1,'Retail Sale Id 2739',9300.00,0.00,0.00,12.50,1025.00,'2022-07-23 18:39:13','',''),(2811,'1','274','1',1,'Retail Sale Id 2740',2246.88,0.00,0.00,3.02,247.64,'2022-07-23 18:41:15','',''),(2812,'1','274','1',1,'Retail Sale Id 2741',7440.00,0.00,0.00,10.00,820.00,'2022-07-23 18:44:09','',''),(2813,'1','274','1',1,'Retail Sale Id 2742',9300.00,0.00,0.00,12.50,1025.00,'2022-07-23 18:45:55','',''),(2814,'1','274','1',1,'Retail Sale Id 2743',37200.00,0.00,0.00,50.00,4100.00,'2022-07-23 18:59:51','',''),(2815,'1','274','1',1,'Retail Sale Id 2744',1502.88,0.00,0.00,2.02,165.64,'2022-07-23 19:00:59','',''),(2816,'1','274','1',1,'Retail Sale Id 2745',8898.24,0.00,0.00,11.96,980.72,'2022-07-23 19:18:50','',''),(2817,'1','274','1',1,'Retail Sale Id 2746',79942.80,0.00,0.00,107.45,8810.90,'2022-07-23 20:44:58','',''),(2818,'1','274','1',1,'Retail Sale Id 2747',34052.88,0.00,0.00,45.77,3753.14,'2022-07-23 20:46:29','',''),(2819,'1','274','1',1,'Retail Sale Id 2748',9300.00,0.00,0.00,12.50,1025.00,'2022-07-24 06:51:50','',''),(2820,'1','274','1',1,'Retail Sale Id 2749',3749.76,0.00,0.00,5.04,413.28,'2022-07-24 06:55:25','',''),(2821,'1','274','1',1,'Retail Sale Id 2750',2001.36,0.00,0.00,2.69,220.58,'2022-07-24 07:14:13','',''),(2822,'1','274','1',1,'Retail Sale Id 2751',9300.00,0.00,0.00,12.50,1025.00,'2022-07-24 07:27:09','',''),(2823,'1','274','1',1,'Retail Sale Id 2752',1502.88,0.00,0.00,2.02,165.64,'2022-07-24 07:51:40','',''),(2824,'1','274','1',1,'Retail Sale Id 2753',37200.00,0.00,0.00,50.00,4100.00,'2022-07-24 07:52:13','',''),(2825,'1','274','1',1,'Retail Sale Id 2754',4464.00,0.00,0.00,6.00,492.00,'2022-07-24 08:06:25','',''),(2826,'1','274','1',1,'Retail Sale Id 2755',9300.00,0.00,0.00,12.50,1025.00,'2022-07-24 08:09:09','',''),(2827,'1','274','1',1,'Retail Sale Id 2756',2246.88,0.00,0.00,3.02,247.64,'2022-07-24 08:13:32','',''),(2828,'1','274','1',1,'Retail Sale Id 2757',2246.88,0.00,0.00,3.02,247.64,'2022-07-24 08:15:27','',''),(2829,'1','274','1',1,'Retail Sale Id 2758',2998.32,0.00,0.00,4.03,330.46,'2022-07-24 08:30:43','',''),(2830,'1','274','1',1,'Retail Sale Id 2759',996.96,0.00,0.00,1.34,109.88,'2022-07-24 08:48:17','',''),(2831,'1','274','1',1,'Retail Sale Id 2760',996.96,0.00,0.00,1.34,109.88,'2022-07-24 09:05:28','',''),(2832,'1','274','1',1,'Retail Sale Id 2761',9300.00,0.00,0.00,12.50,1025.00,'2022-07-24 09:06:19','',''),(2833,'1','274','1',1,'Retail Sale Id 2762',29998.08,0.00,0.00,40.32,3306.24,'2022-07-24 10:41:35','',''),(2834,'1','274','1',1,'Retail Sale Id 2763',20497.20,0.00,0.00,27.55,2259.10,'2022-07-24 10:42:49','',''),(2835,'1','274','1',1,'Retail Sale Id 2764',18600.00,0.00,0.00,25.00,2050.00,'2022-07-24 10:43:50','',''),(2836,'1','274','1',1,'Retail Sale Id 2765',2499.84,0.00,0.00,3.36,275.52,'2022-07-24 10:52:14','',''),(2837,'1','274','1',1,'Retail Sale Id 2766',996.96,0.00,0.00,1.34,109.88,'2022-07-24 10:59:06','',''),(2838,'1','274','1',1,'Retail Sale Id 2767',9300.00,0.00,0.00,12.50,1025.00,'2022-07-24 11:06:57','',''),(2839,'1','274','1',1,'Retail Sale Id 2768',4501.20,0.00,0.00,6.05,496.10,'2022-07-24 11:14:50','',''),(2840,'1','274','1',1,'Retail Sale Id 2769',11546.88,0.00,0.00,15.52,1272.64,'2022-07-24 11:17:54','',''),(2841,'1','274','1',1,'Retail Sale Id 2770',22320.00,0.00,0.00,30.00,2460.00,'2022-07-24 11:19:24','',''),(2842,'1','274','1',1,'Return of Retail Sale Id 2770',0.00,22320.00,30.00,0.00,-2460.00,'2022-07-24 11:19:44','',''),(2843,'1','274','1',1,'Retail Sale Id 2771',22320.00,0.00,0.00,30.00,2460.00,'2022-07-24 11:20:46','',''),(2844,'1','274','1',1,'Retail Sale Id 2772',4099.44,0.00,0.00,5.51,451.82,'2022-07-24 11:35:40','',''),(2845,'1','274','1',1,'Retail Sale Id 2773',9300.00,0.00,0.00,12.50,1025.00,'2022-07-24 11:59:44','',''),(2846,'1','274','1',1,'Retail Sale Id 2774',2998.32,0.00,0.00,4.03,330.46,'2022-07-24 12:13:54','',''),(2847,'1','274','1',1,'Retail Sale Id 2775',9300.00,0.00,0.00,12.50,1025.00,'2022-07-24 12:17:55','',''),(2848,'1','274','1',1,'Retail Sale Id 2776',2001.36,0.00,0.00,2.69,220.58,'2022-07-24 12:20:40','',''),(2849,'1','274','1',1,'Retail Sale Id 2777',9300.00,0.00,0.00,12.50,1025.00,'2022-07-24 12:31:59','',''),(2850,'1','274','1',1,'Retail Sale Id 2778',4002.72,0.00,0.00,5.38,441.16,'2022-07-24 12:33:02','',''),(2851,'1','274','1',1,'Retail Sale Id 2779',4501.20,0.00,0.00,6.05,496.10,'2022-07-24 12:37:42','',''),(2852,'1','274','1',1,'Retail Sale Id 2780',4501.20,0.00,0.00,6.05,496.10,'2022-07-24 13:03:46','',''),(2853,'1','274','1',1,'Retail Sale Id 2781',4501.20,0.00,0.00,6.05,496.10,'2022-07-24 13:08:42','',''),(2854,'1','274','1',1,'Retail Sale Id 2782',9300.00,0.00,0.00,12.50,1025.00,'2022-07-24 13:17:38','',''),(2855,'1','274','1',1,'Retail Sale Id 2783',7998.00,0.00,0.00,10.75,881.50,'2022-07-24 13:21:53','',''),(2856,'1','274','1',1,'Retail Sale Id 2784',2001.36,0.00,0.00,2.69,220.58,'2022-07-24 13:34:30','',''),(2857,'1','274','1',1,'Retail Sale Id 2785',4501.20,0.00,0.00,6.05,496.10,'2022-07-24 14:02:00','',''),(2858,'1','274','1',1,'Retail Sale Id 2786',3749.76,0.00,0.00,5.04,413.28,'2022-07-24 14:15:09','',''),(2859,'1','274','1',1,'Retail Sale Id 2787',4002.72,0.00,0.00,5.38,441.16,'2022-07-24 14:16:04','',''),(2860,'1','274','1',1,'Retail Sale Id 2788',2499.84,0.00,0.00,3.36,275.52,'2022-07-24 14:28:38','',''),(2861,'1','274','1',1,'Retail Sale Id 2789',4501.20,0.00,0.00,6.05,496.10,'2022-07-24 14:29:40','',''),(2862,'1','274','1',1,'Retail Sale Id 2790',9300.00,0.00,0.00,12.50,1025.00,'2022-07-24 14:30:10','',''),(2863,'1','274','1',1,'Retail Sale Id 2791',9300.00,0.00,0.00,12.50,1025.00,'2022-07-24 14:32:55','',''),(2864,'1','274','1',1,'Retail Sale Id 2792',1502.88,0.00,0.00,2.02,165.64,'2022-07-24 14:49:14','',''),(2865,'1','274','1',1,'Retail Sale Id 2793',4501.20,0.00,0.00,6.05,496.10,'2022-07-24 14:54:43','',''),(2866,'1','274','1',1,'Retail Sale Id 2794',1302.00,0.00,0.00,1.75,143.50,'2022-07-24 15:40:30','',''),(2867,'1','274','1',1,'Retail Sale Id 2795',17000.40,0.00,0.00,22.85,1873.70,'2022-07-24 15:44:21','',''),(2868,'1','274','1',1,'Retail Sale Id 2796',10296.96,0.00,0.00,13.84,1134.88,'2022-07-24 16:51:02','',''),(2869,'1','274','1',1,'Retail Sale Id 2797',4501.20,0.00,0.00,6.05,496.10,'2022-07-24 17:25:27','',''),(2870,'1','274','1',1,'Retail Sale Id 2798',22320.00,0.00,0.00,30.00,2460.00,'2022-07-24 17:35:48','',''),(2871,'1','274','1',1,'Retail Sale Id 2799',662.16,0.00,0.00,0.89,72.98,'2022-07-24 18:07:36','',''),(2872,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,29187.58,44.09,0.00,0.00,'2022-07-24 18:12:59','',''),(2873,'1','274',NULL,1,'Reception corrector for bridging 20',0.00,0.00,0.00,44.09,0.00,'2022-07-24 18:31:43','',''),(2874,'1','274','1',1,'Received from bridging 20',0.00,0.00,44.09,0.00,0.00,'2022-07-24 18:31:43','',''),(2875,'1','274','1',1,'Return of Retail Sale Id 2771',0.00,22320.00,30.00,0.00,-2460.00,'2022-07-24 20:25:54','',''),(2876,'1','274','1',1,'Retail Sale Id 2800',3809.28,0.00,0.00,5.12,419.84,'2022-07-24 20:30:25','',''),(2877,'1','274','1',1,'Retail Sale Id 2801',51313.68,0.00,0.00,68.97,5655.54,'2022-07-24 20:32:24','',''),(2878,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,2912800.00,4400.00,0.00,0.00,'2022-07-25 14:54:00','',''),(2879,'1','274',NULL,1,'Reception corrector for bridging 21',0.00,0.00,0.00,4400.00,0.00,'2022-07-25 14:58:59','',''),(2880,'1','274','1',1,'Received from bridging 21',0.00,0.00,4400.00,0.00,0.00,'2022-07-25 14:58:59','',''),(2881,'1','274','1',1,'Retail Sale Id 2802',37200.00,0.00,0.00,50.00,4100.00,'2022-07-25 14:59:47','',''),(2882,'1','274','1',1,'Retail Sale Id 2803',37200.00,0.00,0.00,50.00,4100.00,'2022-07-25 16:53:00','',''),(2883,'1','274','1',1,'Retail Sale Id 2804',9300.00,0.00,0.00,12.50,1025.00,'2022-07-25 16:54:06','',''),(2884,'1','274','1',1,'Retail Sale Id 2805',4501.20,0.00,0.00,6.05,496.10,'2022-07-25 16:54:37','',''),(2885,'1','274','1',1,'Retail Sale Id 2806',2246.88,0.00,0.00,3.02,247.64,'2022-07-25 16:55:19','',''),(2886,'1','274','1',1,'Retail Sale Id 2807',9300.00,0.00,0.00,12.50,1025.00,'2022-07-25 17:00:52','',''),(2887,'1','274','1',1,'Retail Sale Id 2808',498.48,0.00,0.00,0.67,54.94,'2022-07-25 17:26:42','',''),(2888,'1','274','1',1,'Retail Sale Id 2810',14999.04,0.00,0.00,20.16,1653.12,'2022-07-25 18:44:32','',''),(2889,'1','274','1',1,'Retail Sale Id 2811',342448.32,0.00,0.00,460.28,37742.96,'2022-07-25 19:55:54','',''),(2890,'1','274','1',1,'Retail Sale Id 2812',30146.88,0.00,0.00,40.52,3322.64,'2022-07-25 19:56:59','',''),(2891,'1','274','1',1,'Retail Sale Id 2813',2998.32,0.00,0.00,4.03,330.46,'2022-07-26 08:36:53','',''),(2892,'1','274','1',1,'Retail Sale Id 2814',4501.20,0.00,0.00,6.05,496.10,'2022-07-26 08:44:25','',''),(2893,'1','274','1',1,'Retail Sale Id 2815',9300.00,0.00,0.00,12.50,1025.00,'2022-07-26 09:11:36','',''),(2894,'1','274','1',1,'Retail Sale Id 2816',4501.20,0.00,0.00,6.05,496.10,'2022-07-26 09:21:59','',''),(2895,'1','274','1',1,'Retail Sale Id 2817',4501.20,0.00,0.00,6.05,496.10,'2022-07-26 09:33:08','',''),(2896,'1','274','1',1,'Retail Sale Id 2819',4999.68,0.00,0.00,6.72,551.04,'2022-07-26 11:59:56','',''),(2897,'1','274','1',1,'Retail Sale Id 2821',9300.00,0.00,0.00,12.50,1025.00,'2022-07-26 12:21:36','',''),(2898,'1','274','1',1,'Retail Sale Id 2822',3749.76,0.00,0.00,5.04,413.28,'2022-07-26 12:27:31','',''),(2899,'1','274','1',1,'Retail Sale Id 2823',2001.36,0.00,0.00,2.69,220.58,'2022-07-26 12:39:29','',''),(2900,'1','274','1',1,'Retail Sale Id 2824',14902.32,0.00,0.00,20.03,1642.46,'2022-07-26 12:40:31','',''),(2901,'1','274','1',1,'Retail Sale Id 2825',37200.00,0.00,0.00,50.00,4100.00,'2022-07-26 12:42:38','',''),(2902,'1','274','1',1,'Retail Sale Id 2826',2499.84,0.00,0.00,3.36,275.52,'2022-07-26 12:53:33','',''),(2903,'1','274','1',1,'Retail Sale Id 2827',9300.00,0.00,0.00,12.50,1025.00,'2022-07-26 13:03:02','',''),(2904,'1','274','1',1,'Retail Sale Id 2828',14902.32,0.00,0.00,20.03,1642.46,'2022-07-26 13:13:02','',''),(2905,'1','274','1',1,'Retail Sale Id 2829',3749.76,0.00,0.00,5.04,413.28,'2022-07-26 14:47:49','',''),(2906,'1','274','1',1,'Retail Sale Id 2830',9300.00,0.00,0.00,12.50,1025.00,'2022-07-26 14:50:01','',''),(2907,'1','274','1',1,'Retail Sale Id 2831',2998.32,0.00,0.00,4.03,330.46,'2022-07-26 14:51:43','',''),(2908,'1','274','1',1,'Retail Sale Id 2832',27996.72,0.00,0.00,37.63,3085.66,'2022-07-26 14:54:23','',''),(2909,'1','274','1',1,'Retail Sale Id 2833',2499.84,0.00,0.00,3.36,275.52,'2022-07-26 16:59:21','',''),(2910,'1','274','1',1,'Retail Sale Id 2834',4501.20,0.00,0.00,6.05,496.10,'2022-07-26 17:08:16','',''),(2911,'1','274','1',1,'Retail Sale Id 2835',4501.20,0.00,0.00,6.05,496.10,'2022-07-26 18:00:59','',''),(2912,'1','274','1',1,'Retail Sale Id 2836',157549.44,0.00,0.00,211.76,17364.32,'2022-07-26 18:16:48','',''),(2913,'1','274','1',1,'Retail Sale Id 2837',4501.20,0.00,0.00,6.05,496.10,'2022-07-26 18:17:40','',''),(2914,'1','274','1',1,'Retail Sale Id 2838',2001.36,0.00,0.00,2.69,220.58,'2022-07-26 18:20:32','',''),(2915,'1','274','1',1,'Retail Sale Id 2839',1502.88,0.00,0.00,2.02,165.64,'2022-07-26 18:27:22','',''),(2916,'1','274','1',1,'Retail Sale Id 2840',4002.72,0.00,0.00,5.38,441.16,'2022-07-26 18:33:49','',''),(2917,'1','274','1',1,'Retail Sale Id 2842',2001.36,0.00,0.00,2.69,220.58,'2022-07-26 18:35:54','',''),(2918,'1','274','1',1,'Retail Sale Id 2843',9300.00,0.00,0.00,12.50,1025.00,'2022-07-26 18:43:55','',''),(2919,'1','274','1',1,'Retail Sale Id 2844',2246.88,0.00,0.00,3.02,247.64,'2022-07-27 07:09:56','',''),(2920,'1','274','1',1,'Retail Sale Id 2845',1502.88,0.00,0.00,2.02,165.64,'2022-07-27 07:16:46','',''),(2921,'1','274','1',1,'Retail Sale Id 2846',4002.72,0.00,0.00,5.38,441.16,'2022-07-27 07:18:02','',''),(2922,'1','274','1',1,'Retail Sale Id 2847',4501.20,0.00,0.00,6.05,496.10,'2022-07-27 07:24:24','',''),(2923,'1','274','1',1,'Retail Sale Id 2848',996.96,0.00,0.00,1.34,109.88,'2022-07-27 07:29:16','',''),(2924,'1','274','1',1,'Retail Sale Id 2849',16368.00,0.00,0.00,22.00,1804.00,'2022-07-27 07:52:47','',''),(2925,'1','274','1',1,'Retail Sale Id 2850',16368.00,0.00,0.00,22.00,1804.00,'2022-07-27 08:02:31','',''),(2926,'1','274','1',1,'Retail Sale Id 2851',18600.00,0.00,0.00,25.00,2050.00,'2022-07-27 08:07:10','',''),(2927,'1','274','1',1,'Retail Sale Id 2852',9300.00,0.00,0.00,12.50,1025.00,'2022-07-27 08:09:05','',''),(2928,'1','274','1',1,'Return of Retail Sale Id 2852',0.00,9300.00,12.50,0.00,-1025.00,'2022-07-27 08:11:37','',''),(2929,'1','274','1',1,'Retail Sale Id 2853',9999.36,0.00,0.00,13.44,1102.08,'2022-07-27 08:12:50','',''),(2930,'1','274','1',1,'Retail Sale Id 2854',9300.00,0.00,0.00,12.50,1025.00,'2022-07-27 08:31:24','',''),(2931,'1','274','1',1,'Retail Sale Id 2855',4002.72,0.00,0.00,5.38,441.16,'2022-07-27 09:05:05','',''),(2932,'1','274','1',1,'Retail Sale Id 2856',37200.00,0.00,0.00,50.00,4100.00,'2022-07-27 09:42:36','',''),(2933,'1','274','1',1,'Retail Sale Id 2857',9300.00,0.00,0.00,12.50,1025.00,'2022-07-27 09:43:49','',''),(2934,'1','274','1',1,'Retail Sale Id 2858',9300.00,0.00,0.00,12.50,1025.00,'2022-07-27 10:38:54','',''),(2935,'1','274','1',1,'Retail Sale Id 2859',4501.20,0.00,0.00,6.05,496.10,'2022-07-27 11:28:59','',''),(2936,'1','274','1',1,'Retail Sale Id 2861',9300.00,0.00,0.00,12.50,1025.00,'2022-07-27 13:37:40','',''),(2937,'1','274','1',1,'Retail Sale Id 2862',4999.68,0.00,0.00,6.72,551.04,'2022-07-27 14:02:16','',''),(2938,'1','274','1',1,'Retail Sale Id 2863',9300.00,0.00,0.00,12.50,1025.00,'2022-07-27 14:25:08','',''),(2939,'1','274','1',1,'Retail Sale Id 2864',9300.00,0.00,0.00,12.50,1025.00,'2022-07-27 15:50:20','',''),(2940,'1','274','1',1,'Retail Sale Id 2865',9300.00,0.00,0.00,12.50,1025.00,'2022-07-27 15:54:29','',''),(2941,'1','274','1',1,'Retail Sale Id 2866',3749.76,0.00,0.00,5.04,413.28,'2022-07-27 17:06:55','',''),(2942,'1','274','1',1,'Retail Sale Id 2867',2246.88,0.00,0.00,3.02,247.64,'2022-07-27 17:20:37','',''),(2943,'1','274','1',1,'Retail Sale Id 2868',9300.00,0.00,0.00,12.50,1025.00,'2022-07-27 17:23:29','',''),(2944,'1','274','1',1,'Retail Sale Id 2869',2001.36,0.00,0.00,2.69,220.58,'2022-07-27 17:34:02','',''),(2945,'1','274','1',1,'Retail Sale Id 2870',996.96,0.00,0.00,1.34,109.88,'2022-07-27 18:02:31','',''),(2946,'1','274','1',1,'Retail Sale Id 2871',9300.00,0.00,0.00,12.50,1025.00,'2022-07-27 18:05:34','',''),(2947,'1','274','1',1,'Retail Sale Id 2872',3749.76,0.00,0.00,5.04,413.28,'2022-07-27 18:07:48','',''),(2948,'1','274','1',1,'Retail Sale Id 2873',11904.00,0.00,0.00,16.00,1312.00,'2022-07-27 18:12:06','',''),(2949,'1','274','1',1,'Retail Sale Id 2874',9672.00,0.00,0.00,13.00,1066.00,'2022-07-27 18:13:23','',''),(2950,'1','274','1',1,'Retail Sale Id 2875',9300.00,0.00,0.00,12.50,1025.00,'2022-07-27 18:25:13','',''),(2951,'1','274','1',1,'Retail Sale Id 2876',16368.00,0.00,0.00,22.00,1804.00,'2022-07-27 18:28:42','',''),(2952,'1','274','1',1,'Retail Sale Id 2877',26501.28,0.00,0.00,35.62,2920.84,'2022-07-27 19:05:56','',''),(2953,'1','274','1',1,'Retail Sale Id 2878',116004.48,0.00,0.00,155.92,12785.44,'2022-07-27 19:49:50','',''),(2954,'1','274','1',1,'Retail Sale Id 2879',1800.48,0.00,0.00,2.42,198.44,'2022-07-27 19:50:54','',''),(2955,'1','274','1',1,'Retail Sale Id 2880',9300.00,0.00,0.00,12.50,1025.00,'2022-07-28 07:57:29','',''),(2956,'1','274','1',1,'Retail Sale Id 2881',9300.00,0.00,0.00,12.50,1025.00,'2022-07-28 08:01:48','',''),(2957,'1','274','1',1,'Retail Sale Id 2882',9300.00,0.00,0.00,12.50,1025.00,'2022-07-28 08:06:49','',''),(2958,'1','274','1',1,'Retail Sale Id 2883',9300.00,0.00,0.00,12.50,1025.00,'2022-07-28 08:09:45','',''),(2959,'1','274','1',1,'Retail Sale Id 2884',4999.68,0.00,0.00,6.72,551.04,'2022-07-28 08:14:06','',''),(2960,'1','274','1',1,'Retail Sale Id 2885',751.44,0.00,0.00,1.01,82.82,'2022-07-28 08:19:16','',''),(2961,'1','274','1',1,'Retail Sale Id 2886',1897.20,0.00,0.00,2.55,209.10,'2022-07-28 08:32:50','',''),(2962,'1','274','1',1,'Retail Sale Id 2887',4501.20,0.00,0.00,6.05,496.10,'2022-07-28 08:50:15','',''),(2963,'1','274','1',1,'Retail Sale Id 2888',996.96,0.00,0.00,1.34,109.88,'2022-07-28 09:09:25','',''),(2964,'1','274','1',1,'Retail Sale Id 2889',4999.68,0.00,0.00,6.72,551.04,'2022-07-28 09:10:01','',''),(2965,'1','274','1',1,'Retail Sale Id 2890',2246.88,0.00,0.00,3.02,247.64,'2022-07-28 09:15:57','',''),(2966,'1','274','1',1,'Retail Sale Id 2891',22349.76,0.00,0.00,30.04,2463.28,'2022-07-28 09:26:12','',''),(2967,'1','274','1',1,'Retail Sale Id 2892',2001.36,0.00,0.00,2.69,220.58,'2022-07-28 09:27:01','',''),(2968,'1','274','1',1,'Retail Sale Id 2893',7447.44,0.00,0.00,10.01,820.82,'2022-07-28 09:28:53','',''),(2969,'1','274','1',1,'Retail Sale Id 2894',2246.88,0.00,0.00,3.02,247.64,'2022-07-28 10:10:11','',''),(2970,'1','274','1',1,'Retail Sale Id 2895',2246.88,0.00,0.00,3.02,247.64,'2022-07-28 10:21:06','',''),(2971,'1','274','1',1,'Retail Sale Id 2896',7001.04,0.00,0.00,9.41,771.62,'2022-07-28 10:26:12','',''),(2972,'1','274','1',1,'Retail Sale Id 2897',7001.04,0.00,0.00,9.41,771.62,'2022-07-28 10:55:46','',''),(2973,'1','274','1',1,'Retail Sale Id 2898',3801.84,0.00,0.00,5.11,419.02,'2022-07-28 10:56:54','',''),(2974,'1','274','1',1,'Retail Sale Id 2899',2998.32,0.00,0.00,4.03,330.46,'2022-07-28 11:16:02','',''),(2975,'1','274','1',1,'Retail Sale Id 2900',3496.80,0.00,0.00,4.70,385.40,'2022-07-28 11:29:32','',''),(2976,'1','274','1',1,'Retail Sale Id 2901',7998.00,0.00,0.00,10.75,881.50,'2022-07-28 11:42:07','',''),(2977,'1','274','1',1,'Retail Sale Id 2902',16003.44,0.00,0.00,21.51,1763.82,'2022-07-28 11:58:06','',''),(2978,'1','274','1',1,'Retail Sale Id 2903',8496.48,0.00,0.00,11.42,936.44,'2022-07-28 12:06:54','',''),(2979,'1','274','1',1,'Retail Sale Id 2904',6748.08,0.00,0.00,9.07,743.74,'2022-07-28 13:12:17','',''),(2980,'1','274','1',1,'Retail Sale Id 2905',4501.20,0.00,0.00,6.05,496.10,'2022-07-28 13:14:49','',''),(2981,'1','274','1',1,'Retail Sale Id 2906',11546.88,0.00,0.00,15.52,1272.64,'2022-07-28 13:16:41','',''),(2982,'1','274','1',1,'Retail Sale Id 2907',5996.64,0.00,0.00,8.06,660.92,'2022-07-28 13:33:52','',''),(2983,'1','274','1',1,'Retail Sale Id 2908',1502.88,0.00,0.00,2.02,165.64,'2022-07-28 13:37:22','',''),(2984,'1','274','1',1,'Retail Sale Id 2909',9300.00,0.00,0.00,12.50,1025.00,'2022-07-28 13:40:49','',''),(2985,'1','274','1',1,'Retail Sale Id 2910',2998.32,0.00,0.00,4.03,330.46,'2022-07-28 13:47:30','',''),(2986,'1','274','1',1,'Retail Sale Id 2911',4501.20,0.00,0.00,6.05,496.10,'2022-07-28 13:49:57','',''),(2987,'1','274','1',1,'Retail Sale Id 2913',19998.72,0.00,0.00,26.88,2204.16,'2022-07-28 15:23:16','',''),(2988,'1','274','1',1,'Retail Sale Id 2914',9300.00,0.00,0.00,12.50,1025.00,'2022-07-28 15:40:00','',''),(2989,'1','274','1',1,'Retail Sale Id 2915',2001.36,0.00,0.00,2.69,220.58,'2022-07-28 16:02:46','',''),(2990,'1','274','1',1,'Retail Sale Id 2916',2499.84,0.00,0.00,3.36,275.52,'2022-07-28 16:12:48','',''),(2991,'1','274','1',1,'Retail Sale Id 2917',2998.32,0.00,0.00,4.03,330.46,'2022-07-28 16:48:42','',''),(2992,'1','274','1',1,'Retail Sale Id 2918',2246.88,0.00,0.00,3.02,247.64,'2022-07-28 17:03:17','',''),(2993,'1','274','1',1,'Retail Sale Id 2919',9300.00,0.00,0.00,12.50,1025.00,'2022-07-28 17:15:09','',''),(2994,'1','274','1',1,'Retail Sale Id 2920',4501.20,0.00,0.00,6.05,496.10,'2022-07-28 17:21:40','',''),(2995,'1','274','1',1,'Retail Sale Id 2921',1502.88,0.00,0.00,2.02,165.64,'2022-07-28 17:22:48','',''),(2996,'1','274','1',1,'Retail Sale Id 2922',9300.00,0.00,0.00,12.50,1025.00,'2022-07-28 17:23:47','',''),(2997,'1','274','1',1,'Retail Sale Id 2923',2246.88,0.00,0.00,3.02,247.64,'2022-07-28 17:29:14','',''),(2998,'1','274','1',1,'Retail Sale Id 2924',9300.00,0.00,0.00,12.50,1025.00,'2022-07-28 17:31:03','',''),(2999,'1','274','1',1,'Retail Sale Id 2925',9999.36,0.00,0.00,13.44,1102.08,'2022-07-28 17:36:15','',''),(3000,'1','274','1',1,'Retail Sale Id 2926',7849.20,0.00,0.00,10.55,865.10,'2022-07-28 17:37:50','',''),(3001,'1','274','1',1,'Retail Sale Id 2927',18600.00,0.00,0.00,25.00,2050.00,'2022-07-28 17:39:07','',''),(3002,'1','274','1',1,'Retail Sale Id 2928',27900.00,0.00,0.00,37.50,3075.00,'2022-07-28 17:47:39','',''),(3003,'1','274','1',1,'Retail Sale Id 2929',996.96,0.00,0.00,1.34,109.88,'2022-07-28 18:39:48','',''),(3004,'1','274','1',1,'Retail Sale Id 2930',16397.76,0.00,0.00,22.04,1807.28,'2022-07-28 18:46:39','',''),(3005,'1','274','1',1,'Retail Sale Id 2931',19998.72,0.00,0.00,26.88,2204.16,'2022-07-28 18:49:21','',''),(3006,'1','274','1',1,'Retail Sale Id 2932',9300.00,0.00,0.00,12.50,1025.00,'2022-07-28 19:20:32','',''),(3007,'1','274','1',1,'Retail Sale Id 2933',29.76,0.00,0.00,0.04,3.28,'2022-07-28 20:12:44','',''),(3008,'1','274','1',1,'Retail Sale Id 2934',49639.68,0.00,0.00,66.72,5471.04,'2022-07-28 20:14:38','',''),(3009,'1','274','1',1,'Retail Sale Id 2935',1502.88,0.00,0.00,2.02,165.64,'2022-07-29 07:05:20','',''),(3010,'1','274','1',1,'Retail Sale Id 2936',2998.32,0.00,0.00,4.03,330.46,'2022-07-29 07:46:38','',''),(3011,'1','274','1',1,'Retail Sale Id 2937',4501.20,0.00,0.00,6.05,496.10,'2022-07-29 08:03:06','',''),(3012,'1','274','1',1,'Retail Sale Id 2938',996.96,0.00,0.00,1.34,109.88,'2022-07-29 08:54:48','',''),(3013,'1','274','1',1,'Retail Sale Id 2939',29760.00,0.00,0.00,40.00,3280.00,'2022-07-29 09:07:53','',''),(3014,'1','274','1',1,'Retail Sale Id 2940',9999.36,0.00,0.00,13.44,1102.08,'2022-07-29 09:25:26','',''),(3015,'1','274','1',1,'Retail Sale Id 2941',17000.40,0.00,0.00,22.85,1873.70,'2022-07-29 09:29:33','',''),(3016,'1','274','1',1,'Retail Sale Id 2942',9300.00,0.00,0.00,12.50,1025.00,'2022-07-29 10:11:09','',''),(3017,'1','274','1',1,'Retail Sale Id 2943',4464.00,0.00,0.00,6.00,492.00,'2022-07-29 11:11:14','',''),(3018,'1','274','1',1,'Retail Sale Id 2944',27900.00,0.00,0.00,37.50,3075.00,'2022-07-29 11:40:28','',''),(3019,'1','274','1',1,'Retail Sale Id 2945',37200.00,0.00,0.00,50.00,4100.00,'2022-07-29 11:46:01','',''),(3020,'1','274','1',1,'Retail Sale Id 2946',4002.72,0.00,0.00,5.38,441.16,'2022-07-29 11:50:21','',''),(3021,'1','274','1',1,'Retail Sale Id 2947',4464.00,0.00,0.00,6.00,492.00,'2022-07-29 11:55:10','',''),(3022,'1','274','1',1,'Retail Sale Id 2948',24001.44,0.00,0.00,32.26,2645.32,'2022-07-29 12:06:41','',''),(3023,'1','274','1',1,'Retail Sale Id 2949',3720.00,0.00,0.00,5.00,410.00,'2022-07-29 12:27:42','',''),(3024,'1','274','1',1,'Retail Sale Id 2950',4397.04,0.00,0.00,5.91,484.62,'2022-07-29 14:11:49','',''),(3025,'1','274','1',1,'Retail Sale Id 2951',3749.76,0.00,0.00,5.04,413.28,'2022-07-29 14:12:26','',''),(3026,'1','274','1',1,'Retail Sale Id 2952',9300.00,0.00,0.00,12.50,1025.00,'2022-07-29 14:13:03','',''),(3027,'1','274','1',1,'Retail Sale Id 2953',9300.00,0.00,0.00,12.50,1025.00,'2022-07-29 14:35:50','',''),(3028,'1','274','1',1,'Retail Sale Id 2954',24596.64,0.00,0.00,33.06,2710.92,'2022-07-29 15:01:28','',''),(3029,'1','274','1',1,'Retail Sale Id 2955',4501.20,0.00,0.00,6.05,496.10,'2022-07-29 15:51:33','',''),(3030,'1','274','1',1,'Retail Sale Id 2957',3496.80,0.00,0.00,4.70,385.40,'2022-07-29 15:54:40','',''),(3031,'1','274','1',1,'Retail Sale Id 2960',8496.48,0.00,0.00,11.42,936.44,'2022-07-29 15:56:16','',''),(3032,'1','274','1',1,'Retail Sale Id 2962',2001.36,0.00,0.00,2.69,220.58,'2022-07-29 16:02:41','',''),(3033,'1','274','1',1,'Retail Sale Id 2963',2246.88,0.00,0.00,3.02,247.64,'2022-07-29 16:04:20','',''),(3034,'1','274','1',1,'Retail Sale Id 2964',2246.88,0.00,0.00,3.02,247.64,'2022-07-29 16:06:28','',''),(3035,'1','274','1',1,'Retail Sale Id 2965',2246.88,0.00,0.00,3.02,247.64,'2022-07-29 16:08:30','',''),(3036,'1','274','1',1,'Retail Sale Id 2966',2246.88,0.00,0.00,3.02,247.64,'2022-07-29 16:11:28','',''),(3037,'1','274','1',1,'Retail Sale Id 2968',2499.84,0.00,0.00,3.36,275.52,'2022-07-29 16:19:58','',''),(3038,'1','274','1',1,'Retail Sale Id 2969',13883.04,0.00,0.00,18.66,1530.12,'2022-07-29 16:31:31','',''),(3039,'1','274','1',1,'Retail Sale Id 2970',3496.80,0.00,0.00,4.70,385.40,'2022-07-29 16:44:08','',''),(3040,'1','274','1',1,'Retail Sale Id 2971',996.96,0.00,0.00,1.34,109.88,'2022-07-29 16:45:38','',''),(3041,'1','274','1',1,'Retail Sale Id 2972',9300.00,0.00,0.00,12.50,1025.00,'2022-07-29 16:54:10','',''),(3042,'1','274','1',1,'Retail Sale Id 2974',9300.00,0.00,0.00,12.50,1025.00,'2022-07-29 17:26:31','',''),(3043,'1','274','1',1,'Retail Sale Id 2975',2246.88,0.00,0.00,3.02,247.64,'2022-07-29 17:28:56','',''),(3044,'1','274','1',1,'Retail Sale Id 2976',12313.20,0.00,0.00,16.55,1357.10,'2022-07-29 17:38:57','',''),(3045,'1','274','1',1,'Retail Sale Id 2977',4002.72,0.00,0.00,5.38,441.16,'2022-07-29 17:47:20','',''),(3046,'1','274','1',1,'Retail Sale Id 2978',11859.36,0.00,0.00,15.94,1307.08,'2022-07-29 19:51:42','',''),(3047,'1','274','1',1,'Retail Sale Id 2979',60859.20,0.00,0.00,81.80,6707.60,'2022-07-29 20:10:14','',''),(3048,'1','274','1',1,'Retail Sale Id 2980',11546.88,0.00,0.00,15.52,1272.64,'2022-07-29 20:12:40','',''),(3049,'1','274','1',1,'Retail Sale Id 2981',4501.20,0.00,0.00,6.05,496.10,'2022-07-30 07:53:03','',''),(3050,'1','274','1',1,'Retail Sale Id 2982',2998.32,0.00,0.00,4.03,330.46,'2022-07-30 07:53:34','',''),(3051,'1','274','1',1,'Retail Sale Id 2983',3720.00,0.00,0.00,5.00,410.00,'2022-07-30 07:55:55','',''),(3052,'1','274','1',1,'Retail Sale Id 2984',9300.00,0.00,0.00,12.50,1025.00,'2022-07-30 08:03:55','',''),(3053,'1','274','1',1,'Retail Sale Id 2985',2246.88,0.00,0.00,3.02,247.64,'2022-07-30 08:05:15','',''),(3054,'1','274','1',1,'Retail Sale Id 2986',9300.00,0.00,0.00,12.50,1025.00,'2022-07-30 08:07:42','',''),(3055,'1','274','1',1,'Retail Sale Id 2987',2001.36,0.00,0.00,2.69,220.58,'2022-07-30 09:18:47','',''),(3056,'1','274','1',1,'Retail Sale Id 2988',1502.88,0.00,0.00,2.02,165.64,'2022-07-30 09:19:30','',''),(3057,'1','274','1',1,'Retail Sale Id 2989',9300.00,0.00,0.00,12.50,1025.00,'2022-07-30 09:23:58','',''),(3058,'1','274','1',1,'Retail Sale Id 2990',2001.36,0.00,0.00,2.69,220.58,'2022-07-30 09:26:01','',''),(3059,'1','274','1',1,'Retail Sale Id 2991',3749.76,0.00,0.00,5.04,413.28,'2022-07-30 09:51:57','',''),(3060,'1','274','1',1,'Retail Sale Id 2992',3749.76,0.00,0.00,5.04,413.28,'2022-07-30 10:34:56','',''),(3061,'1','274','1',1,'Retail Sale Id 2993',1502.88,0.00,0.00,2.02,165.64,'2022-07-30 10:37:23','',''),(3062,'1','274','1',1,'Retail Sale Id 2994',44647.44,0.00,0.00,60.01,4920.82,'2022-07-30 10:48:45','',''),(3063,'1','274','1',1,'Retail Sale Id 2995',14002.08,0.00,0.00,18.82,1543.24,'2022-07-30 10:50:27','',''),(3064,'1','274','1',1,'Retail Sale Id 2996',2998.32,0.00,0.00,4.03,330.46,'2022-07-30 10:54:59','',''),(3065,'1','274','1',1,'Retail Sale Id 2997',4501.20,0.00,0.00,6.05,496.10,'2022-07-30 10:57:50','',''),(3066,'1','274','1',1,'Retail Sale Id 2998',3749.76,0.00,0.00,5.04,413.28,'2022-07-30 11:01:59','',''),(3067,'1','274','1',1,'Retail Sale Id 2999',74400.00,0.00,0.00,100.00,8200.00,'2022-07-30 11:04:23','',''),(3068,'1','274','1',1,'Retail Sale Id 3000',2246.88,0.00,0.00,3.02,247.64,'2022-07-30 11:34:34','',''),(3069,'1','274','1',1,'Retail Sale Id 3001',9300.00,0.00,0.00,12.50,1025.00,'2022-07-30 11:39:47','',''),(3070,'1','274','1',1,'Retail Sale Id 3002',4002.72,0.00,0.00,5.38,441.16,'2022-07-30 12:01:28','',''),(3071,'1','274','1',1,'Retail Sale Id 3003',37200.00,0.00,0.00,50.00,4100.00,'2022-07-30 12:02:33','',''),(3072,'1','274','1',1,'Retail Sale Id 3004',9300.00,0.00,0.00,12.50,1025.00,'2022-07-30 12:19:10','',''),(3073,'1','274','1',1,'Retail Sale Id 3005',4501.20,0.00,0.00,6.05,496.10,'2022-07-30 13:35:50','',''),(3074,'1','274','1',1,'Retail Sale Id 3006',37200.00,0.00,0.00,50.00,4100.00,'2022-07-30 14:21:16','',''),(3075,'1','274','1',1,'Retail Sale Id 3007',2001.36,0.00,0.00,2.69,220.58,'2022-07-30 14:32:16','',''),(3076,'1','274','1',1,'Retail Sale Id 3008',9300.00,0.00,0.00,12.50,1025.00,'2022-07-30 14:34:32','',''),(3077,'1','274','1',1,'Retail Sale Id 3009',4501.20,0.00,0.00,6.05,496.10,'2022-07-30 14:39:39','',''),(3078,'1','274','1',1,'Retail Sale Id 3010',4501.20,0.00,0.00,6.05,496.10,'2022-07-30 15:07:55','',''),(3079,'1','274','1',1,'Retail Sale Id 3011',37200.00,0.00,0.00,50.00,4100.00,'2022-07-30 15:35:48','',''),(3080,'1','274','1',1,'Retail Sale Id 3012',13801.20,0.00,0.00,18.55,1521.10,'2022-07-30 15:37:01','',''),(3081,'1','274','1',1,'Retail Sale Id 3013',41299.44,0.00,0.00,55.51,4551.82,'2022-07-30 15:46:38','',''),(3082,'1','274','1',1,'Retail Sale Id 3014',2499.84,0.00,0.00,3.36,275.52,'2022-07-30 15:48:52','',''),(3083,'1','274','1',1,'Retail Sale Id 3015',4501.20,0.00,0.00,6.05,496.10,'2022-07-30 15:50:03','',''),(3084,'1','274','1',1,'Retail Sale Id 3016',18600.00,0.00,0.00,25.00,2050.00,'2022-07-30 15:56:55','',''),(3085,'1','274','1',1,'Retail Sale Id 3017',1502.88,0.00,0.00,2.02,165.64,'2022-07-30 15:59:33','',''),(3086,'1','274','1',1,'Retail Sale Id 3018',9300.00,0.00,0.00,12.50,1025.00,'2022-07-30 16:08:05','',''),(3087,'1','274','1',1,'Retail Sale Id 3019',40920.00,0.00,0.00,55.00,4510.00,'2022-07-30 17:11:57','',''),(3088,'1','274','1',1,'Return of Retail Sale Id 3019',0.00,40920.00,55.00,0.00,-4510.00,'2022-07-30 17:16:54','',''),(3089,'1','274','1',1,'Retail Sale Id 3020',40920.00,0.00,0.00,55.00,4510.00,'2022-07-30 17:18:11','',''),(3090,'1','274','1',1,'Retail Sale Id 3021',4999.68,0.00,0.00,6.72,551.04,'2022-07-30 17:20:11','',''),(3091,'1','274','1',1,'Retail Sale Id 3022',9300.00,0.00,0.00,12.50,1025.00,'2022-07-30 17:21:54','',''),(3092,'1','274','1',1,'Retail Sale Id 3024',69154.80,0.00,0.00,92.95,7621.90,'2022-07-30 17:33:03','',''),(3093,'1','274','1',1,'Retail Sale Id 3025',61893.36,0.00,0.00,83.19,6821.58,'2022-07-30 17:35:47','',''),(3094,'1','274','1',1,'Retail Sale Id 3026',3697.68,0.00,0.00,4.97,407.54,'2022-07-30 17:37:26','',''),(3095,'1','274','1',1,'Retail Sale Id 3027',37200.00,0.00,0.00,50.00,4100.00,'2022-07-30 17:40:09','',''),(3096,'1','274','1',1,'Retail Sale Id 3028',4002.72,0.00,0.00,5.38,441.16,'2022-07-30 17:43:24','',''),(3097,'1','274','1',1,'Retail Sale Id 3029',2246.88,0.00,0.00,3.02,247.64,'2022-07-30 17:55:51','',''),(3098,'1','274','1',1,'Retail Sale Id 3031',7001.04,0.00,0.00,9.41,771.62,'2022-07-30 17:57:43','',''),(3099,'1','274','1',1,'Retail Sale Id 3032',9300.00,0.00,0.00,12.50,1025.00,'2022-07-30 18:00:15','',''),(3100,'1','274','1',1,'Retail Sale Id 3033',4501.20,0.00,0.00,6.05,496.10,'2022-07-30 18:17:20','',''),(3101,'1','274','1',1,'Retail Sale Id 3034',9300.00,0.00,0.00,12.50,1025.00,'2022-07-30 18:43:50','',''),(3102,'1','274','1',1,'Retail Sale Id 3035',9552.96,0.00,0.00,12.84,1052.88,'2022-07-30 19:26:51','',''),(3103,'1','274','1',1,'Return of Retail Sale Id 3027',0.00,37200.00,50.00,0.00,-4100.00,'2022-07-30 19:32:19','',''),(3104,'1','274','1',1,'Retail Sale Id 3036',5996.64,0.00,0.00,8.06,660.92,'2022-07-31 07:20:32','',''),(3105,'1','274','1',1,'Retail Sale Id 3037',2001.36,0.00,0.00,2.69,220.58,'2022-07-31 07:23:31','',''),(3106,'1','274','1',1,'Retail Sale Id 3038',2499.84,0.00,0.00,3.36,275.52,'2022-07-31 07:45:08','',''),(3107,'1','274','1',1,'Retail Sale Id 3039',996.96,0.00,0.00,1.34,109.88,'2022-07-31 08:02:03','',''),(3108,'1','274','1',1,'Retail Sale Id 3040',2246.88,0.00,0.00,3.02,247.64,'2022-07-31 08:12:26','',''),(3109,'1','274','1',1,'Retail Sale Id 3041',996.96,0.00,0.00,1.34,109.88,'2022-07-31 08:18:52','',''),(3110,'1','274','1',1,'Retail Sale Id 3042',7998.00,0.00,0.00,10.75,881.50,'2022-07-31 08:22:45','',''),(3111,'1','274','1',1,'Retail Sale Id 3043',4501.20,0.00,0.00,6.05,496.10,'2022-07-31 08:26:46','',''),(3112,'1','274','1',1,'Retail Sale Id 3044',13801.20,0.00,0.00,18.55,1521.10,'2022-07-31 08:31:31','',''),(3113,'1','274','1',1,'Retail Sale Id 3045',4501.20,0.00,0.00,6.05,496.10,'2022-07-31 08:32:42','',''),(3114,'1','274','1',1,'Retail Sale Id 3046',5661.84,0.00,0.00,7.61,624.02,'2022-07-31 09:22:06','',''),(3115,'1','274','1',1,'Retail Sale Id 3047',4002.72,0.00,0.00,5.38,441.16,'2022-07-31 09:45:27','',''),(3116,'1','274','1',1,'Retail Sale Id 3048',2998.32,0.00,0.00,4.03,330.46,'2022-07-31 09:55:25','',''),(3117,'1','274','1',1,'Retail Sale Id 3050',498.48,0.00,0.00,0.67,54.94,'2022-07-31 09:57:07','',''),(3118,'1','274','1',1,'Retail Sale Id 3051',18600.00,0.00,0.00,25.00,2050.00,'2022-07-31 10:00:40','',''),(3119,'1','274','1',1,'Retail Sale Id 3052',9300.00,0.00,0.00,12.50,1025.00,'2022-07-31 10:01:31','',''),(3120,'1','274','1',1,'Retail Sale Id 3053',7001.04,0.00,0.00,9.41,771.62,'2022-07-31 10:11:25','',''),(3121,'1','274','1',1,'Retail Sale Id 3054',1696.32,0.00,0.00,2.28,186.96,'2022-07-31 10:13:08','',''),(3122,'1','274','1',1,'Retail Sale Id 3055',9300.00,0.00,0.00,12.50,1025.00,'2022-07-31 10:14:42','',''),(3123,'1','274','1',1,'Retail Sale Id 3056',2998.32,0.00,0.00,4.03,330.46,'2022-07-31 10:17:59','',''),(3124,'1','274','1',1,'Retail Sale Id 3058',2001.36,0.00,0.00,2.69,220.58,'2022-07-31 12:05:19','',''),(3125,'1','274','1',1,'Retail Sale Id 3059',2001.36,0.00,0.00,2.69,220.58,'2022-07-31 12:10:21','',''),(3126,'1','274','1',1,'Retail Sale Id 3060',9300.00,0.00,0.00,12.50,1025.00,'2022-07-31 12:18:57','',''),(3127,'1','274','1',1,'Retail Sale Id 3061',4501.20,0.00,0.00,6.05,496.10,'2022-07-31 12:21:34','',''),(3128,'1','274','1',1,'Retail Sale Id 3062',2001.36,0.00,0.00,2.69,220.58,'2022-07-31 12:31:43','',''),(3129,'1','274','1',1,'Retail Sale Id 3063',9300.00,0.00,0.00,12.50,1025.00,'2022-07-31 12:33:04','',''),(3130,'1','274','1',1,'Retail Sale Id 3064',18600.00,0.00,0.00,25.00,2050.00,'2022-07-31 12:34:19','',''),(3131,'1','274','1',1,'Retail Sale Id 3065',2001.36,0.00,0.00,2.69,220.58,'2022-07-31 12:52:12','',''),(3132,'1','274','1',1,'Retail Sale Id 3066',4002.72,0.00,0.00,5.38,441.16,'2022-07-31 12:55:38','',''),(3133,'1','274','1',1,'Retail Sale Id 3067',4999.68,0.00,0.00,6.72,551.04,'2022-07-31 12:56:22','',''),(3134,'1','274','1',1,'Retail Sale Id 3068',150384.72,0.00,0.00,202.13,16574.66,'2022-07-31 13:56:29','',''),(3135,'1','274','1',1,'Retail Sale Id 3069',110729.52,0.00,0.00,148.83,12204.06,'2022-07-31 13:57:31','',''),(3136,'1','274','1',1,'Retail Sale Id 3070',9300.00,0.00,0.00,12.50,1025.00,'2022-07-31 13:59:33','',''),(3137,'1','274','1',1,'Retail Sale Id 3071',996.96,0.00,0.00,1.34,109.88,'2022-07-31 14:00:22','',''),(3138,'1','274','1',1,'Retail Sale Id 3072',12298.32,0.00,0.00,16.53,1355.46,'2022-07-31 14:28:47','',''),(3139,'1','274','1',1,'Retail Sale Id 3073',9300.00,0.00,0.00,12.50,1025.00,'2022-07-31 14:32:11','',''),(3140,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,17576.10,26.55,0.00,0.00,'2022-07-31 16:41:49','',''),(3141,'1','274',NULL,1,'Reception corrector for bridging 22',0.00,0.00,0.00,26.55,0.00,'2022-07-31 16:45:16','',''),(3142,'1','274','1',1,'Received from bridging 22',0.00,0.00,26.55,0.00,0.00,'2022-07-31 16:45:16','',''),(3143,'1','274','1',1,'Retail Sale Id 3074',46418.16,0.00,0.00,62.39,5115.98,'2022-07-31 16:47:37','',''),(3144,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,662000.00,1000.00,0.00,0.00,'2022-07-31 18:17:38','',''),(3145,'1','274',NULL,1,'Reception corrector for bridging 23',0.00,0.00,0.00,1000.00,0.00,'2022-07-31 18:21:18','',''),(3146,'1','274','1',1,'Received from bridging 23',0.00,0.00,1000.00,0.00,0.00,'2022-07-31 18:21:18','',''),(3147,'1','274','1',1,'Retail Sale Id 3075',17796.48,0.00,0.00,23.92,1961.44,'2022-08-01 06:41:41','',''),(3148,'1','274','1',1,'Retail Sale Id 3076',9300.00,0.00,0.00,12.50,1025.00,'2022-08-01 07:20:55','',''),(3149,'1','274','1',1,'Retail Sale Id 3077',2998.32,0.00,0.00,4.03,330.46,'2022-08-01 07:22:01','',''),(3150,'1','274','1',1,'Retail Sale Id 3078',2499.84,0.00,0.00,3.36,275.52,'2022-08-01 07:22:52','',''),(3151,'1','274','1',1,'Retail Sale Id 3079',9300.00,0.00,0.00,12.50,1025.00,'2022-08-01 07:30:36','',''),(3152,'1','274','1',1,'Retail Sale Id 3080',9300.00,0.00,0.00,12.50,1025.00,'2022-08-01 07:45:38','',''),(3153,'1','274','1',1,'Retail Sale Id 3082',9300.00,0.00,0.00,12.50,1025.00,'2022-08-01 08:05:06','',''),(3154,'1','274','1',1,'Retail Sale Id 3083',4501.20,0.00,0.00,6.05,496.10,'2022-08-01 08:14:12','',''),(3155,'1','274','1',1,'Retail Sale Id 3084',16368.00,0.00,0.00,22.00,1804.00,'2022-08-01 10:46:42','',''),(3156,'1','274','1',1,'Retail Sale Id 3085',29998.08,0.00,0.00,40.32,3306.24,'2022-08-01 12:52:32','',''),(3157,'1','274','1',1,'Retail Sale Id 3086',37200.00,0.00,0.00,50.00,4100.00,'2022-08-01 15:35:32','',''),(3158,'1','274','1',1,'Retail Sale Id 3087',9300.00,0.00,0.00,12.50,1025.00,'2022-08-01 15:36:00','',''),(3159,'1','274','1',1,'Retail Sale Id 3088',9999.36,0.00,0.00,13.44,1102.08,'2022-08-01 15:36:36','',''),(3160,'1','274','1',1,'Retail Sale Id 3089',22320.00,0.00,0.00,30.00,2460.00,'2022-08-01 16:32:56','',''),(3161,'1','274','1',1,'Retail Sale Id 3090',6100.80,0.00,0.00,8.20,672.40,'2022-08-01 17:12:04','',''),(3162,'1','274','1',1,'Retail Sale Id 3091',9300.00,0.00,0.00,12.50,1025.00,'2022-08-01 17:12:34','',''),(3163,'1','274','1',1,'Retail Sale Id 3092',9300.00,0.00,0.00,12.50,1025.00,'2022-08-01 17:29:52','',''),(3164,'1','274','1',1,'Retail Sale Id 3093',4501.20,0.00,0.00,6.05,496.10,'2022-08-01 17:36:39','',''),(3165,'1','274','1',1,'Retail Sale Id 3094',9300.00,0.00,0.00,12.50,1025.00,'2022-08-01 17:37:15','',''),(3166,'1','274','1',1,'Retail Sale Id 3095',37200.00,0.00,0.00,50.00,4100.00,'2022-08-01 17:55:10','',''),(3167,'1','274','1',1,'Retail Sale Id 3096',3720.00,0.00,0.00,5.00,410.00,'2022-08-01 17:58:21','',''),(3168,'1','274','1',1,'Retail Sale Id 3097',2998.32,0.00,0.00,4.03,330.46,'2022-08-01 18:10:10','',''),(3169,'1','274','1',1,'Retail Sale Id 3098',2001.36,0.00,0.00,2.69,220.58,'2022-08-01 18:11:17','',''),(3170,'1','274','1',1,'Retail Sale Id 3099',9300.00,0.00,0.00,12.50,1025.00,'2022-08-01 19:18:35','',''),(3171,'1','274','1',1,'Retail Sale Id 3100',143227.44,0.00,0.00,192.51,15785.82,'2022-08-01 20:03:28','',''),(3172,'1','274','1',1,'Retail Sale Id 3101',10282.08,0.00,0.00,13.82,1133.24,'2022-08-01 20:04:39','',''),(3173,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,2422920.00,3660.00,0.00,0.00,'2022-08-01 21:31:38','',''),(3174,'1','274','1',1,'Retail Sale Id 3102',1502.88,0.00,0.00,2.02,165.64,'2022-08-02 07:01:36','',''),(3175,'1','274','1',1,'Retail Sale Id 3103',2998.32,0.00,0.00,4.03,330.46,'2022-08-02 07:27:39','',''),(3176,'1','274','1',1,'Retail Sale Id 3104',9300.00,0.00,0.00,12.50,1025.00,'2022-08-02 09:03:11','',''),(3177,'1','274','1',1,'Retail Sale Id 3105',996.96,0.00,0.00,1.34,109.88,'2022-08-02 09:05:20','',''),(3178,'1','274','1',1,'Retail Sale Id 3106',111600.00,0.00,0.00,150.00,12300.00,'2022-08-02 09:57:18','',''),(3179,'1','274','1',1,'Retail Sale Id 3107',9300.00,0.00,0.00,12.50,1025.00,'2022-08-02 09:58:22','',''),(3180,'1','274','1',1,'Retail Sale Id 3108',4501.20,0.00,0.00,6.05,496.10,'2022-08-02 09:59:22','',''),(3181,'1','274','1',1,'Retail Sale Id 3109',1502.88,0.00,0.00,2.02,165.64,'2022-08-02 10:19:29','',''),(3182,'1','274','1',1,'Retail Sale Id 3111',9300.00,0.00,0.00,12.50,1025.00,'2022-08-02 10:22:34','',''),(3183,'1','274','1',1,'Retail Sale Id 3112',2001.36,0.00,0.00,2.69,220.58,'2022-08-02 10:26:15','',''),(3184,'1','274','1',1,'Retail Sale Id 3113',17997.36,0.00,0.00,24.19,1983.58,'2022-08-02 10:45:15','',''),(3185,'1','274','1',1,'Retail Sale Id 3114',2202.24,0.00,0.00,2.96,242.72,'2022-08-02 10:52:38','',''),(3186,'1','274','1',1,'Retail Sale Id 3115',2998.32,0.00,0.00,4.03,330.46,'2022-08-02 11:02:55','',''),(3187,'1','274','1',1,'Retail Sale Id 3116',4002.72,0.00,0.00,5.38,441.16,'2022-08-02 11:07:32','',''),(3188,'1','274','1',1,'Retail Sale Id 3117',996.96,0.00,0.00,1.34,109.88,'2022-08-02 11:08:24','',''),(3189,'1','274','1',1,'Retail Sale Id 3118',4501.20,0.00,0.00,6.05,496.10,'2022-08-02 11:21:57','',''),(3190,'1','274','1',1,'Retail Sale Id 3119',2001.36,0.00,0.00,2.69,220.58,'2022-08-02 11:35:58','',''),(3191,'1','274','1',1,'Retail Sale Id 3120',18600.00,0.00,0.00,25.00,2050.00,'2022-08-02 11:37:01','',''),(3192,'1','274','1',1,'Retail Sale Id 3121',4999.68,0.00,0.00,6.72,551.04,'2022-08-02 11:54:38','',''),(3193,'1','274','1',1,'Retail Sale Id 3122',29760.00,0.00,0.00,40.00,3280.00,'2022-08-02 12:53:59','',''),(3194,'1','274','1',1,'Retail Sale Id 3123',37200.00,0.00,0.00,50.00,4100.00,'2022-08-02 13:07:47','',''),(3195,'1','274','1',1,'Retail Sale Id 3124',6748.08,0.00,0.00,9.07,743.74,'2022-08-02 13:19:36','',''),(3196,'1','274','1',1,'Retail Sale Id 3126',13801.20,0.00,0.00,18.55,1521.10,'2022-08-02 13:22:13','',''),(3197,'1','274',NULL,1,'Reception corrector for bridging 25',0.00,0.00,0.00,3660.00,0.00,'2022-08-02 15:40:58','',''),(3198,'1','274','1',1,'Received from bridging 25',0.00,0.00,3660.00,0.00,0.00,'2022-08-02 15:40:58','',''),(3199,'1','274','1',1,'Retail Sale Id 3128',5996.64,0.00,0.00,8.06,660.92,'2022-08-02 15:44:02','',''),(3200,'1','274','1',1,'Retail Sale Id 3129',22349.76,0.00,0.00,30.04,2463.28,'2022-08-02 18:41:13','',''),(3201,'1','274','1',1,'Retail Sale Id 3131',265392.24,0.00,0.00,356.71,29250.22,'2022-08-02 19:49:10','',''),(3202,'1','274','1',1,'Retail Sale Id 3132',106421.76,0.00,0.00,143.04,11729.28,'2022-08-02 19:51:10','',''),(3203,'1','274','1',1,'Retail Sale Id 3133',9300.00,0.00,0.00,12.50,1025.00,'2022-08-03 07:13:06','',''),(3204,'1','274','1',1,'Retail Sale Id 3134',4501.20,0.00,0.00,6.05,496.10,'2022-08-03 07:16:23','',''),(3205,'1','274','1',1,'Retail Sale Id 3135',2202.24,0.00,0.00,2.96,242.72,'2022-08-03 07:17:57','',''),(3206,'1','274','1',1,'Retail Sale Id 3136',996.96,0.00,0.00,1.34,109.88,'2022-08-03 09:14:33','',''),(3207,'1','274','1',1,'Retail Sale Id 3137',37200.00,0.00,0.00,50.00,4100.00,'2022-08-03 13:46:36','',''),(3208,'1','274','1',1,'Retail Sale Id 3138',9300.00,0.00,0.00,12.50,1025.00,'2022-08-03 13:47:24','',''),(3209,'1','274','1',1,'Retail Sale Id 3139',2001.36,0.00,0.00,2.69,220.58,'2022-08-03 13:48:06','',''),(3210,'1','274','1',1,'Retail Sale Id 3140',4501.20,0.00,0.00,6.05,496.10,'2022-08-03 13:48:39','',''),(3211,'1','274','1',1,'Retail Sale Id 3141',9300.00,0.00,0.00,12.50,1025.00,'2022-08-03 16:55:01','',''),(3212,'1','274','1',1,'Retail Sale Id 3142',22320.00,0.00,0.00,30.00,2460.00,'2022-08-03 17:01:37','',''),(3213,'1','274','1',1,'Retail Sale Id 3143',16368.00,0.00,0.00,22.00,1804.00,'2022-08-03 17:03:20','',''),(3214,'1','274','1',1,'Retail Sale Id 3144',3749.76,0.00,0.00,5.04,413.28,'2022-08-03 17:17:01','',''),(3215,'1','274','1',1,'Retail Sale Id 3145',1502.88,0.00,0.00,2.02,165.64,'2022-08-03 17:22:21','',''),(3216,'1','274','1',1,'Retail Sale Id 3146',803.52,0.00,0.00,1.08,88.56,'2022-08-03 17:23:53','',''),(3217,'1','274','1',1,'Retail Sale Id 3147',4501.20,0.00,0.00,6.05,496.10,'2022-08-03 18:03:15','',''),(3218,'1','274','1',1,'Retail Sale Id 3148',2246.88,0.00,0.00,3.02,247.64,'2022-08-03 18:12:32','',''),(3219,'1','274','1',1,'Retail Sale Id 3149',9300.00,0.00,0.00,12.50,1025.00,'2022-08-03 18:21:13','',''),(3220,'1','274','1',1,'Retail Sale Id 3150',9300.00,0.00,0.00,12.50,1025.00,'2022-08-03 18:23:05','',''),(3221,'1','274','1',1,'Retail Sale Id 3151',9300.00,0.00,0.00,12.50,1025.00,'2022-08-03 18:44:07','',''),(3222,'1','274','1',1,'Retail Sale Id 3152',24998.40,0.00,0.00,33.60,2755.20,'2022-08-03 19:00:34','',''),(3223,'1','274','1',1,'Retail Sale Id 3153',145489.20,0.00,0.00,195.55,16035.10,'2022-08-03 19:58:31','',''),(3224,'1','274','1',1,'Retail Sale Id 3154',498.48,0.00,0.00,0.67,54.94,'2022-08-03 19:59:55','',''),(3225,'1','274','1',1,'Retail Sale Id 3155',5996.64,0.00,0.00,8.06,660.92,'2022-08-04 07:59:31','',''),(3226,'1','274','1',1,'Retail Sale Id 3156',996.96,0.00,0.00,1.34,109.88,'2022-08-04 08:01:30','',''),(3227,'1','274','1',1,'Retail Sale Id 3157',9300.00,0.00,0.00,12.50,1025.00,'2022-08-04 08:04:34','',''),(3228,'1','274','1',1,'Retail Sale Id 3158',9300.00,0.00,0.00,12.50,1025.00,'2022-08-04 08:07:23','',''),(3229,'1','274','1',1,'Retail Sale Id 3159',2499.84,0.00,0.00,3.36,275.52,'2022-08-04 08:11:14','',''),(3230,'1','274','1',1,'Retail Sale Id 3160',1800.48,0.00,0.00,2.42,198.44,'2022-08-04 08:44:15','',''),(3231,'1','274','1',1,'Retail Sale Id 3161',5996.64,0.00,0.00,8.06,660.92,'2022-08-04 08:45:56','',''),(3232,'1','274','1',1,'Retail Sale Id 3162',996.96,0.00,0.00,1.34,109.88,'2022-08-04 08:55:50','',''),(3233,'1','274','1',1,'Retail Sale Id 3163',9300.00,0.00,0.00,12.50,1025.00,'2022-08-04 09:37:02','',''),(3234,'1','274','1',1,'Retail Sale Id 3164',2001.36,0.00,0.00,2.69,220.58,'2022-08-04 09:42:38','',''),(3235,'1','274','1',1,'Retail Sale Id 3165',9999.36,0.00,0.00,13.44,1102.08,'2022-08-04 09:53:40','',''),(3236,'1','274','1',1,'Retail Sale Id 3166',9300.00,0.00,0.00,12.50,1025.00,'2022-08-04 10:16:49','',''),(3237,'1','274','1',1,'Retail Sale Id 3167',2998.32,0.00,0.00,4.03,330.46,'2022-08-04 10:18:01','',''),(3238,'1','274','1',1,'Retail Sale Id 3168',1502.88,0.00,0.00,2.02,165.64,'2022-08-04 10:33:11','',''),(3239,'1','274','1',1,'Retail Sale Id 3169',996.96,0.00,0.00,1.34,109.88,'2022-08-04 10:53:18','',''),(3240,'1','274','1',1,'Retail Sale Id 3170',2001.36,0.00,0.00,2.69,220.58,'2022-08-04 10:58:14','',''),(3241,'1','274','1',1,'Retail Sale Id 3171',9300.00,0.00,0.00,12.50,1025.00,'2022-08-04 11:07:14','',''),(3242,'1','274','1',1,'Retail Sale Id 3172',6703.44,0.00,0.00,9.01,738.82,'2022-08-04 11:16:43','',''),(3243,'1','274','1',1,'Retail Sale Id 3173',22320.00,0.00,0.00,30.00,2460.00,'2022-08-04 11:43:20','',''),(3244,'1','274','1',1,'Retail Sale Id 3174',9300.00,0.00,0.00,12.50,1025.00,'2022-08-04 13:29:02','',''),(3245,'1','274','1',1,'Retail Sale Id 3175',2499.84,0.00,0.00,3.36,275.52,'2022-08-04 13:44:01','',''),(3246,'1','274','1',1,'Retail Sale Id 3176',996.96,0.00,0.00,1.34,109.88,'2022-08-04 13:44:44','',''),(3247,'1','274','1',1,'Retail Sale Id 3177',9300.00,0.00,0.00,12.50,1025.00,'2022-08-04 15:13:19','',''),(3248,'1','274','1',1,'Retail Sale Id 3178',18600.00,0.00,0.00,25.00,2050.00,'2022-08-04 15:16:00','',''),(3249,'1','274','1',1,'Retail Sale Id 3179',7998.00,0.00,0.00,10.75,881.50,'2022-08-04 15:24:15','',''),(3250,'1','274','1',1,'Retail Sale Id 3180',2001.36,0.00,0.00,2.69,220.58,'2022-08-04 15:32:52','',''),(3251,'1','274','1',1,'Retail Sale Id 3181',7001.04,0.00,0.00,9.41,771.62,'2022-08-04 15:37:40','',''),(3252,'1','274','1',1,'Retail Sale Id 3182',2001.36,0.00,0.00,2.69,220.58,'2022-08-04 15:49:40','',''),(3253,'1','274','1',1,'Retail Sale Id 3183',9300.00,0.00,0.00,12.50,1025.00,'2022-08-04 18:16:55','',''),(3254,'1','274','1',1,'Retail Sale Id 3184',2001.36,0.00,0.00,2.69,220.58,'2022-08-04 18:17:39','',''),(3255,'1','274','1',1,'Retail Sale Id 3185',1502.88,0.00,0.00,2.02,165.64,'2022-08-04 18:36:28','',''),(3256,'1','274','1',1,'Retail Sale Id 3187',2998.32,0.00,0.00,4.03,330.46,'2022-08-04 18:42:31','',''),(3257,'1','274','1',1,'Retail Sale Id 3189',4501.20,0.00,0.00,6.05,496.10,'2022-08-04 18:44:11','',''),(3258,'1','274','1',1,'Retail Sale Id 3190',9746.40,0.00,0.00,13.10,1074.20,'2022-08-04 18:46:18','',''),(3259,'1','274','1',1,'Retail Sale Id 3191',259656.00,0.00,0.00,349.00,28618.00,'2022-08-04 19:57:32','',''),(3260,'1','274','1',1,'Retail Sale Id 3192',6748.08,0.00,0.00,9.07,743.74,'2022-08-05 07:21:00','',''),(3261,'1','274','1',1,'Retail Sale Id 3193',2998.32,0.00,0.00,4.03,330.46,'2022-08-05 07:21:40','',''),(3262,'1','274','1',1,'Retail Sale Id 3194',9300.00,0.00,0.00,12.50,1025.00,'2022-08-05 07:25:32','',''),(3263,'1','274','1',1,'Retail Sale Id 3195',2001.36,0.00,0.00,2.69,220.58,'2022-08-05 07:38:24','',''),(3264,'1','274','1',1,'Retail Sale Id 3196',2001.36,0.00,0.00,2.69,220.58,'2022-08-05 07:42:38','',''),(3265,'1','274','1',1,'Retail Sale Id 3197',14880.00,0.00,0.00,20.00,1640.00,'2022-08-05 07:51:10','',''),(3266,'1','274','1',1,'Retail Sale Id 3198',2001.36,0.00,0.00,2.69,220.58,'2022-08-05 07:57:28','',''),(3267,'1','274','1',1,'Retail Sale Id 3199',2001.36,0.00,0.00,2.69,220.58,'2022-08-05 08:07:34','',''),(3268,'1','274','1',1,'Retail Sale Id 3200',2001.36,0.00,0.00,2.69,220.58,'2022-08-05 08:22:09','',''),(3269,'1','274','1',1,'Retail Sale Id 3201',2246.88,0.00,0.00,3.02,247.64,'2022-08-05 08:36:44','',''),(3270,'1','274','1',1,'Retail Sale Id 3202',9300.00,0.00,0.00,12.50,1025.00,'2022-08-05 08:57:21','',''),(3271,'1','274','1',1,'Retail Sale Id 3203',7440.00,0.00,0.00,10.00,820.00,'2022-08-05 09:07:37','',''),(3272,'1','274','1',1,'Retail Sale Id 3204',996.96,0.00,0.00,1.34,109.88,'2022-08-05 09:23:06','',''),(3273,'1','274','1',1,'Retail Sale Id 3205',7998.00,0.00,0.00,10.75,881.50,'2022-08-05 09:25:55','',''),(3274,'1','274','1',1,'Retail Sale Id 3206',22320.00,0.00,0.00,30.00,2460.00,'2022-08-05 09:27:04','',''),(3275,'1','274','1',1,'Return of Retail Sale Id 3206',0.00,22320.00,30.00,0.00,-2460.00,'2022-08-05 09:28:12','',''),(3276,'1','274','1',1,'Retail Sale Id 3207',22320.00,0.00,0.00,30.00,2460.00,'2022-08-05 09:29:26','',''),(3277,'1','274','1',1,'Retail Sale Id 3208',996.96,0.00,0.00,1.34,109.88,'2022-08-05 09:37:59','',''),(3278,'1','274','1',1,'Retail Sale Id 3209',2001.36,0.00,0.00,2.69,220.58,'2022-08-05 09:44:04','',''),(3279,'1','274','1',1,'Retail Sale Id 3211',4501.20,0.00,0.00,6.05,496.10,'2022-08-05 09:44:51','',''),(3280,'1','274','1',1,'Retail Sale Id 3212',16003.44,0.00,0.00,21.51,1763.82,'2022-08-05 10:02:18','',''),(3281,'1','274','1',1,'Retail Sale Id 3213',37200.00,0.00,0.00,50.00,4100.00,'2022-08-05 10:09:01','',''),(3282,'1','274','1',1,'Retail Sale Id 3214',3801.84,0.00,0.00,5.11,419.02,'2022-08-05 10:15:16','',''),(3283,'1','274','1',1,'Retail Sale Id 3215',996.96,0.00,0.00,1.34,109.88,'2022-08-05 10:37:50','',''),(3284,'1','274','1',1,'Retail Sale Id 3216',4002.72,0.00,0.00,5.38,441.16,'2022-08-05 10:54:11','',''),(3285,'1','274','1',1,'Retail Sale Id 3217',4501.20,0.00,0.00,6.05,496.10,'2022-08-05 10:55:29','',''),(3286,'1','274','1',1,'Retail Sale Id 3218',9300.00,0.00,0.00,12.50,1025.00,'2022-08-05 10:59:25','',''),(3287,'1','274','1',1,'Retail Sale Id 3219',7440.00,0.00,0.00,10.00,820.00,'2022-08-05 11:16:08','',''),(3288,'1','274','1',1,'Retail Sale Id 3220',9300.00,0.00,0.00,12.50,1025.00,'2022-08-05 11:17:36','',''),(3289,'1','274','1',1,'Retail Sale Id 3221',9300.00,0.00,0.00,12.50,1025.00,'2022-08-05 11:23:54','',''),(3290,'1','274','1',1,'Retail Sale Id 3222',3496.80,0.00,0.00,4.70,385.40,'2022-08-05 12:05:15','',''),(3291,'1','274','1',1,'Retail Sale Id 3223',1502.88,0.00,0.00,2.02,165.64,'2022-08-05 14:18:55','',''),(3292,'1','274','1',1,'Retail Sale Id 3224',7440.00,0.00,0.00,10.00,820.00,'2022-08-05 14:19:23','',''),(3293,'1','274','1',1,'Retail Sale Id 3227',7440.00,0.00,0.00,10.00,820.00,'2022-08-05 14:45:52','',''),(3294,'1','274','1',1,'Retail Sale Id 3228',9300.00,0.00,0.00,12.50,1025.00,'2022-08-05 14:46:26','',''),(3295,'1','274','1',1,'Retail Sale Id 3229',59520.00,0.00,0.00,80.00,6560.00,'2022-08-05 15:34:01','',''),(3296,'1','274','1',1,'Retail Sale Id 3230',9300.00,0.00,0.00,12.50,1025.00,'2022-08-05 15:35:15','',''),(3297,'1','274','1',1,'Retail Sale Id 3231',7001.04,0.00,0.00,9.41,771.62,'2022-08-05 15:40:42','',''),(3298,'1','274','1',1,'Retail Sale Id 3232',52.08,0.00,0.00,0.07,5.74,'2022-08-05 15:50:13','',''),(3299,'1','274','1',1,'Retail Sale Id 3233',4501.20,0.00,0.00,6.05,496.10,'2022-08-05 15:59:50','',''),(3300,'1','274','1',1,'Retail Sale Id 3234',996.96,0.00,0.00,1.34,109.88,'2022-08-05 16:00:47','',''),(3301,'1','274','1',1,'Retail Sale Id 3235',29998.08,0.00,0.00,40.32,3306.24,'2022-08-05 16:14:54','',''),(3302,'1','274','1',1,'Retail Sale Id 3236',37200.00,0.00,0.00,50.00,4100.00,'2022-08-05 16:40:31','',''),(3303,'1','274','1',1,'Retail Sale Id 3237',9300.00,0.00,0.00,12.50,1025.00,'2022-08-05 16:41:16','',''),(3304,'1','274','1',1,'Retail Sale Id 3238',11546.88,0.00,0.00,15.52,1272.64,'2022-08-05 16:51:08','',''),(3305,'1','274','1',1,'Retail Sale Id 3239',36999.12,0.00,0.00,49.73,4077.86,'2022-08-05 17:01:04','',''),(3306,'1','274','1',1,'Retail Sale Id 3240',9002.40,0.00,0.00,12.10,992.20,'2022-08-05 17:01:39','',''),(3307,'1','274','1',1,'Retail Sale Id 3241',2001.36,0.00,0.00,2.69,220.58,'2022-08-05 17:02:29','',''),(3308,'1','274','1',1,'Retail Sale Id 3242',9002.40,0.00,0.00,12.10,992.20,'2022-08-05 17:15:31','',''),(3309,'1','274','1',1,'Retail Sale Id 3243',9300.00,0.00,0.00,12.50,1025.00,'2022-08-05 17:17:47','',''),(3310,'1','274','1',1,'Retail Sale Id 3244',1502.88,0.00,0.00,2.02,165.64,'2022-08-05 17:19:06','',''),(3311,'1','274','1',1,'Retail Sale Id 3245',9999.36,0.00,0.00,13.44,1102.08,'2022-08-05 17:24:34','',''),(3312,'1','274','1',1,'Retail Sale Id 3246',9300.00,0.00,0.00,12.50,1025.00,'2022-08-05 17:43:33','',''),(3313,'1','274','1',1,'Retail Sale Id 3247',14880.00,0.00,0.00,20.00,1640.00,'2022-08-05 17:59:17','',''),(3314,'1','274','1',1,'Retail Sale Id 3248',4501.20,0.00,0.00,6.05,496.10,'2022-08-05 18:05:22','',''),(3315,'1','274','1',1,'Retail Sale Id 3249',9300.00,0.00,0.00,12.50,1025.00,'2022-08-05 18:11:09','',''),(3316,'1','274','1',1,'Retail Sale Id 3250',9672.00,0.00,0.00,13.00,1066.00,'2022-08-05 18:24:30','',''),(3317,'1','274','1',1,'Retail Sale Id 3251',7440.00,0.00,0.00,10.00,820.00,'2022-08-05 18:33:57','',''),(3318,'1','274','1',1,'Retail Sale Id 3252',803.52,0.00,0.00,1.08,88.56,'2022-08-05 18:48:11','',''),(3319,'1','274','1',1,'Retail Sale Id 3253',255132.48,0.00,0.00,342.92,28119.44,'2022-08-05 19:37:47','',''),(3320,'1','274','1',1,'Retail Sale Id 3254',12253.68,0.00,0.00,16.47,1350.54,'2022-08-06 07:35:57','',''),(3321,'1','274','1',1,'Retail Sale Id 3255',2001.36,0.00,0.00,2.69,220.58,'2022-08-06 07:41:02','',''),(3322,'1','274','1',1,'Retail Sale Id 3256',2246.88,0.00,0.00,3.02,247.64,'2022-08-06 07:46:26','',''),(3323,'1','274','1',1,'Retail Sale Id 3258',12298.32,0.00,0.00,16.53,1355.46,'2022-08-06 07:58:10','',''),(3324,'1','274','1',1,'Retail Sale Id 3259',3749.76,0.00,0.00,5.04,413.28,'2022-08-06 08:19:59','',''),(3325,'1','274','1',1,'Retail Sale Id 3261',4501.20,0.00,0.00,6.05,496.10,'2022-08-06 08:21:51','',''),(3326,'1','274','1',1,'Retail Sale Id 3262',3749.76,0.00,0.00,5.04,413.28,'2022-08-06 08:23:00','',''),(3327,'1','274','1',1,'Retail Sale Id 3263',18600.00,0.00,0.00,25.00,2050.00,'2022-08-06 08:32:00','',''),(3328,'1','274','1',1,'Retail Sale Id 3264',4501.20,0.00,0.00,6.05,496.10,'2022-08-06 08:41:44','',''),(3329,'1','274','1',1,'Retail Sale Id 3265',3749.76,0.00,0.00,5.04,413.28,'2022-08-06 08:44:20','',''),(3330,'1','274','1',1,'Retail Sale Id 3266',1502.88,0.00,0.00,2.02,165.64,'2022-08-06 08:45:45','',''),(3331,'1','274','1',1,'Retail Sale Id 3267',4501.20,0.00,0.00,6.05,496.10,'2022-08-06 08:46:53','',''),(3332,'1','274','1',1,'Retail Sale Id 3268',4002.72,0.00,0.00,5.38,441.16,'2022-08-06 08:47:46','',''),(3333,'1','274','1',1,'Retail Sale Id 3269',4501.20,0.00,0.00,6.05,496.10,'2022-08-06 08:48:46','',''),(3334,'1','274','1',1,'Retail Sale Id 3270',2001.36,0.00,0.00,2.69,220.58,'2022-08-06 08:49:48','',''),(3335,'1','274','1',1,'Retail Sale Id 3271',9300.00,0.00,0.00,12.50,1025.00,'2022-08-06 08:51:21','',''),(3336,'1','274','1',1,'Retail Sale Id 3272',3600.96,0.00,0.00,4.84,396.88,'2022-08-06 08:54:58','',''),(3337,'1','274','1',1,'Retail Sale Id 3273',4501.20,0.00,0.00,6.05,496.10,'2022-08-06 09:10:07','',''),(3338,'1','274','1',1,'Retail Sale Id 3274',9300.00,0.00,0.00,12.50,1025.00,'2022-08-06 09:11:51','',''),(3339,'1','274','1',1,'Retail Sale Id 3275',1502.88,0.00,0.00,2.02,165.64,'2022-08-06 09:13:14','',''),(3340,'1','274','1',1,'Retail Sale Id 3276',2998.32,0.00,0.00,4.03,330.46,'2022-08-06 09:19:03','',''),(3341,'1','274','1',1,'Retail Sale Id 3277',4501.20,0.00,0.00,6.05,496.10,'2022-08-06 09:20:12','',''),(3342,'1','274','1',1,'Retail Sale Id 3278',9300.00,0.00,0.00,12.50,1025.00,'2022-08-06 09:28:48','',''),(3343,'1','274','1',1,'Retail Sale Id 3279',4501.20,0.00,0.00,6.05,496.10,'2022-08-06 09:44:59','',''),(3344,'1','274','1',1,'Retail Sale Id 3280',4999.68,0.00,0.00,6.72,551.04,'2022-08-06 10:53:44','',''),(3345,'1','274','1',1,'Retail Sale Id 3281',2246.88,0.00,0.00,3.02,247.64,'2022-08-06 10:55:43','',''),(3346,'1','274','1',1,'Retail Sale Id 3282',4501.20,0.00,0.00,6.05,496.10,'2022-08-06 10:58:55','',''),(3347,'1','274','1',1,'Retail Sale Id 3283',18600.00,0.00,0.00,25.00,2050.00,'2022-08-06 10:59:55','',''),(3348,'1','274','1',1,'Retail Sale Id 3284',9300.00,0.00,0.00,12.50,1025.00,'2022-08-06 11:31:34','',''),(3349,'1','274','1',1,'Retail Sale Id 3285',2998.32,0.00,0.00,4.03,330.46,'2022-08-06 11:32:48','',''),(3350,'1','274','1',1,'Retail Sale Id 3286',1197.84,0.00,0.00,1.61,132.02,'2022-08-06 11:34:10','',''),(3351,'1','274','1',1,'Retail Sale Id 3287',9300.00,0.00,0.00,12.50,1025.00,'2022-08-06 11:35:29','',''),(3352,'1','274','1',1,'Retail Sale Id 3288',9300.00,0.00,0.00,12.50,1025.00,'2022-08-06 11:40:00','',''),(3353,'1','274','1',1,'Retail Sale Id 3290',37200.00,0.00,0.00,50.00,4100.00,'2022-08-06 11:40:57','',''),(3354,'1','274','1',1,'Retail Sale Id 3291',2998.32,0.00,0.00,4.03,330.46,'2022-08-06 11:55:06','',''),(3355,'1','274','1',1,'Retail Sale Id 3292',4501.20,0.00,0.00,6.05,496.10,'2022-08-06 12:09:44','',''),(3356,'1','274','1',1,'Return of Retail Sale Id 3290',0.00,37200.00,50.00,0.00,-4100.00,'2022-08-06 12:16:55','',''),(3357,'1','274','1',1,'Retail Sale Id 3293',11777.52,0.00,0.00,15.83,1298.06,'2022-08-06 12:18:23','',''),(3358,'1','274','1',1,'Retail Sale Id 3294',18577.68,0.00,0.00,24.97,2047.54,'2022-08-06 12:20:31','',''),(3359,'1','274','1',1,'Retail Sale Id 3295',9300.00,0.00,0.00,12.50,1025.00,'2022-08-06 12:24:01','',''),(3360,'1','274','1',1,'Retail Sale Id 3296',2998.32,0.00,0.00,4.03,330.46,'2022-08-06 12:31:30','',''),(3361,'1','274','1',1,'Retail Sale Id 3297',4501.20,0.00,0.00,6.05,496.10,'2022-08-06 12:33:20','',''),(3362,'1','274','1',1,'Retail Sale Id 3298',7447.44,0.00,0.00,10.01,820.82,'2022-08-06 12:36:01','',''),(3363,'1','274','1',1,'Retail Sale Id 3299',9300.00,0.00,0.00,12.50,1025.00,'2022-08-06 12:37:58','',''),(3364,'1','274','1',1,'Retail Sale Id 3301',8303.04,0.00,0.00,11.16,915.12,'2022-08-06 12:45:59','',''),(3365,'1','274','1',1,'Retail Sale Id 3302',9300.00,0.00,0.00,12.50,1025.00,'2022-08-06 12:57:15','',''),(3366,'1','274','1',1,'Retail Sale Id 3303',7001.04,0.00,0.00,9.41,771.62,'2022-08-06 13:01:59','',''),(3367,'1','274','1',1,'Retail Sale Id 3304',2998.32,0.00,0.00,4.03,330.46,'2022-08-06 13:03:00','',''),(3368,'1','274','1',1,'Retail Sale Id 3305',69199.44,0.00,0.00,93.01,7626.82,'2022-08-06 13:06:29','',''),(3369,'1','274','1',1,'Retail Sale Id 3306',3749.76,0.00,0.00,5.04,413.28,'2022-08-06 13:08:55','',''),(3370,'1','274','1',1,'Retail Sale Id 3307',9300.00,0.00,0.00,12.50,1025.00,'2022-08-06 14:33:01','',''),(3371,'1','274','1',1,'Retail Sale Id 3309',18600.00,0.00,0.00,25.00,2050.00,'2022-08-06 14:34:01','',''),(3372,'1','274','1',1,'Retail Sale Id 3310',9300.00,0.00,0.00,12.50,1025.00,'2022-08-06 14:36:18','',''),(3373,'1','274','1',1,'Retail Sale Id 3311',9300.00,0.00,0.00,12.50,1025.00,'2022-08-06 14:40:28','',''),(3374,'1','274','1',1,'Retail Sale Id 3312',9300.00,0.00,0.00,12.50,1025.00,'2022-08-06 14:41:03','',''),(3375,'1','274','1',1,'Retail Sale Id 3313',4501.20,0.00,0.00,6.05,496.10,'2022-08-06 14:55:55','',''),(3376,'1','274','1',1,'Retail Sale Id 3314',37200.00,0.00,0.00,50.00,4100.00,'2022-08-06 16:52:24','',''),(3377,'1','274','1',1,'Retail Sale Id 3315',9300.00,0.00,0.00,12.50,1025.00,'2022-08-06 16:53:20','',''),(3378,'1','274','1',1,'Retail Sale Id 3316',1800.48,0.00,0.00,2.42,198.44,'2022-08-06 16:54:40','',''),(3379,'1','274','1',1,'Retail Sale Id 3317',2998.32,0.00,0.00,4.03,330.46,'2022-08-06 17:03:50','',''),(3380,'1','274','1',1,'Retail Sale Id 3318',3749.76,0.00,0.00,5.04,413.28,'2022-08-06 17:15:48','',''),(3381,'1','274','1',1,'Retail Sale Id 3319',9300.00,0.00,0.00,12.50,1025.00,'2022-08-06 17:18:14','',''),(3382,'1','274','1',1,'Retail Sale Id 3320',2001.36,0.00,0.00,2.69,220.58,'2022-08-06 17:24:50','',''),(3383,'1','274','1',1,'Retail Sale Id 3321',2998.32,0.00,0.00,4.03,330.46,'2022-08-06 17:25:59','',''),(3384,'1','274','1',1,'Retail Sale Id 3322',4501.20,0.00,0.00,6.05,496.10,'2022-08-06 17:31:39','',''),(3385,'1','274','1',1,'Retail Sale Id 3323',9300.00,0.00,0.00,12.50,1025.00,'2022-08-06 17:35:48','',''),(3386,'1','274','1',1,'Retail Sale Id 3324',2998.32,0.00,0.00,4.03,330.46,'2022-08-06 17:39:37','',''),(3387,'1','274','1',1,'Retail Sale Id 3325',2001.36,0.00,0.00,2.69,220.58,'2022-08-06 17:43:11','',''),(3388,'1','274','1',1,'Retail Sale Id 3326',3749.76,0.00,0.00,5.04,413.28,'2022-08-06 17:49:07','',''),(3389,'1','274','1',1,'Retail Sale Id 3327',4501.20,0.00,0.00,6.05,496.10,'2022-08-06 17:50:23','',''),(3390,'1','274','1',1,'Retail Sale Id 3328',3749.76,0.00,0.00,5.04,413.28,'2022-08-06 17:51:59','',''),(3391,'1','274','1',1,'Retail Sale Id 3329',1502.88,0.00,0.00,2.02,165.64,'2022-08-06 17:55:50','',''),(3392,'1','274','1',1,'Retail Sale Id 3330',2700.72,0.00,0.00,3.63,297.66,'2022-08-06 18:03:20','',''),(3393,'1','274','1',1,'Retail Sale Id 3332',2246.88,0.00,0.00,3.02,247.64,'2022-08-06 18:06:59','',''),(3394,'1','274','1',1,'Retail Sale Id 3333',12000.72,0.00,0.00,16.13,1322.66,'2022-08-06 18:16:00','',''),(3395,'1','274','1',1,'Retail Sale Id 3334',996.96,0.00,0.00,1.34,109.88,'2022-08-06 18:17:05','',''),(3396,'1','274','1',1,'Retail Sale Id 3335',4501.20,0.00,0.00,6.05,496.10,'2022-08-06 18:18:42','',''),(3397,'1','274','1',1,'Retail Sale Id 3336',9300.00,0.00,0.00,12.50,1025.00,'2022-08-06 18:20:07','',''),(3398,'1','274','1',1,'Retail Sale Id 3337',996.96,0.00,0.00,1.34,109.88,'2022-08-06 18:21:03','',''),(3399,'1','274','1',1,'Retail Sale Id 3338',2246.88,0.00,0.00,3.02,247.64,'2022-08-06 18:23:08','',''),(3400,'1','274','1',1,'Retail Sale Id 3339',2246.88,0.00,0.00,3.02,247.64,'2022-08-06 18:24:37','',''),(3401,'1','274','1',1,'Retail Sale Id 3340',9300.00,0.00,0.00,12.50,1025.00,'2022-08-06 18:34:44','',''),(3402,'1','274','1',1,'Retail Sale Id 3341',2001.36,0.00,0.00,2.69,220.58,'2022-08-06 18:41:16','',''),(3403,'1','274','1',1,'Retail Sale Id 3342',9300.00,0.00,0.00,12.50,1025.00,'2022-08-06 18:51:21','',''),(3404,'1','274','1',1,'Retail Sale Id 3343',96749.76,0.00,0.00,130.04,10663.28,'2022-08-06 19:57:51','',''),(3405,'1','274','1',1,'Retail Sale Id 3344',5498.16,0.00,0.00,7.39,605.98,'2022-08-07 07:16:46','',''),(3406,'1','274','1',1,'Retail Sale Id 3345',7499.52,0.00,0.00,10.08,826.56,'2022-08-07 07:39:37','',''),(3407,'1','274','1',1,'Retail Sale Id 3346',6502.56,0.00,0.00,8.74,716.68,'2022-08-07 07:43:36','',''),(3408,'1','274','1',1,'Retail Sale Id 3347',4501.20,0.00,0.00,6.05,496.10,'2022-08-07 08:07:04','',''),(3409,'1','274','1',1,'Retail Sale Id 3348',2998.32,0.00,0.00,4.03,330.46,'2022-08-07 08:47:53','',''),(3410,'1','274','1',1,'Retail Sale Id 3349',1502.88,0.00,0.00,2.02,165.64,'2022-08-07 08:49:58','',''),(3411,'1','274','1',1,'Retail Sale Id 3350',498.48,0.00,0.00,0.67,54.94,'2022-08-07 08:52:02','',''),(3412,'1','274','1',1,'Retail Sale Id 3351',1502.88,0.00,0.00,2.02,165.64,'2022-08-07 10:06:16','',''),(3413,'1','274','1',1,'Retail Sale Id 3352',9300.00,0.00,0.00,12.50,1025.00,'2022-08-07 10:07:26','',''),(3414,'1','274','1',1,'Retail Sale Id 3353',4999.68,0.00,0.00,6.72,551.04,'2022-08-07 10:13:54','',''),(3415,'1','274','1',1,'Retail Sale Id 3354',4501.20,0.00,0.00,6.05,496.10,'2022-08-07 10:19:01','',''),(3416,'1','274','1',1,'Retail Sale Id 3355',9300.00,0.00,0.00,12.50,1025.00,'2022-08-07 10:36:02','',''),(3417,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,66067.60,99.80,0.00,0.00,'2022-08-07 11:36:38','',''),(3418,'1','274',NULL,1,'Reception corrector for bridging 26',0.00,0.00,0.00,99.80,0.00,'2022-08-07 11:38:18','',''),(3419,'1','274','1',1,'Received from bridging 26',0.00,0.00,99.80,0.00,0.00,'2022-08-07 11:38:18','',''),(3420,'1','274','1',1,'Retail Sale Id 3356',74258.64,0.00,0.00,99.81,8184.42,'2022-08-07 11:40:16','',''),(3421,'1','274','1',1,'Distributed to operational loss for sales id:3',3581.42,0.00,0.00,5.41,0.00,'2022-08-07 11:44:24','',''),(3422,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,665000.00,1000.00,0.00,0.00,'2022-08-07 13:31:22','',''),(3423,'1','274',NULL,1,'Reception corrector for bridging 27',0.00,0.00,0.00,1000.00,0.00,'2022-08-07 13:32:26','',''),(3424,'1','274','1',1,'Received from bridging 27',0.00,0.00,1000.00,0.00,0.00,'2022-08-07 13:32:26','',''),(3425,'1','274','1',1,'Retail Sale Id 3357',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 13:48:14','',''),(3426,'1','274','1',1,'Retail Sale Id 3358',7998.00,0.00,0.00,10.75,849.25,'2022-08-07 14:17:01','',''),(3427,'1','274','1',1,'Retail Sale Id 3359',2246.88,0.00,0.00,3.02,238.58,'2022-08-07 14:19:36','',''),(3428,'1','274','1',1,'Retail Sale Id 3360',2001.36,0.00,0.00,2.69,212.51,'2022-08-07 14:20:58','',''),(3429,'1','274','1',1,'Retail Sale Id 3361',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 14:37:27','',''),(3430,'1','274','1',1,'Retail Sale Id 3362',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 15:01:18','',''),(3431,'1','274','1',1,'Retail Sale Id 3363',2246.88,0.00,0.00,3.02,238.58,'2022-08-07 15:15:59','',''),(3432,'1','274','1',1,'Retail Sale Id 3364',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 15:21:11','',''),(3433,'1','274','1',1,'Retail Sale Id 3366',18600.00,0.00,0.00,25.00,1975.00,'2022-08-07 15:43:11','',''),(3434,'1','274','1',1,'Retail Sale Id 3367',2001.36,0.00,0.00,2.69,212.51,'2022-08-07 15:45:45','',''),(3435,'1','274','1',1,'Retail Sale Id 3368',37200.00,0.00,0.00,50.00,3950.00,'2022-08-07 16:20:08','',''),(3436,'1','274','1',1,'Retail Sale Id 3369',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 16:24:29','',''),(3437,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,2972550.00,4470.00,0.00,0.00,'2022-08-07 16:53:20','',''),(3438,'1','274','1',1,'Retail Sale Id 3370',18600.00,0.00,0.00,25.00,1975.00,'2022-08-07 16:53:27','',''),(3439,'1','274',NULL,1,'Reception corrector for bridging 28',0.00,0.00,0.00,4470.00,0.00,'2022-08-07 16:56:39','',''),(3440,'1','274','1',1,'Received from bridging 28',0.00,0.00,4470.00,0.00,0.00,'2022-08-07 16:56:39','',''),(3441,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,665000.00,1000.00,0.00,0.00,'2022-08-07 16:58:14','',''),(3442,'1','274',NULL,1,'Reception corrector for bridging 29',0.00,0.00,0.00,1000.00,0.00,'2022-08-07 17:01:20','',''),(3443,'1','274','1',1,'Received from bridging 29',0.00,0.00,1000.00,0.00,0.00,'2022-08-07 17:01:20','',''),(3444,'1','274','1',1,'Retail Sale Id 3371',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 17:19:39','',''),(3445,'1','274','1',1,'Retail Sale Id 3372',1502.88,0.00,0.00,2.02,159.58,'2022-08-07 17:21:14','',''),(3446,'1','274','1',1,'Distributed to operational loss for sales id:4',1057350.00,0.00,0.00,1590.00,0.00,'2022-08-07 17:21:42','',''),(3447,'1','274','1',1,'Retail Sale Id 3373',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 17:34:09','',''),(3448,'1','274','1',1,'Retail Sale Id 3374',4501.20,0.00,0.00,6.05,477.95,'2022-08-07 17:36:38','',''),(3449,'1','274','1',1,'Retail Sale Id 3375',4501.20,0.00,0.00,6.05,477.95,'2022-08-07 17:48:44','',''),(3450,'1','274','1',1,'Retail Sale Id 3376',2246.88,0.00,0.00,3.02,238.58,'2022-08-07 18:01:18','',''),(3451,'1','274','1',1,'Retail Sale Id 3377',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 18:40:13','',''),(3452,'1','274','1',1,'Retail Sale Id 3378',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 18:42:29','',''),(3453,'1','274','1',1,'Retail Sale Id 3379',9002.40,0.00,0.00,12.10,955.90,'2022-08-07 18:45:43','',''),(3454,'1','274','1',1,'Retail Sale Id 3380',9300.00,0.00,0.00,12.50,987.50,'2022-08-07 18:50:08','',''),(3455,'1','274','1',1,'Retail Sale Id 3381',2998.32,0.00,0.00,4.03,318.37,'2022-08-07 18:55:45','',''),(3456,'1','274','1',1,'Retail Sale Id 3382',43791.84,0.00,0.00,58.86,4649.94,'2022-08-07 19:49:01','',''),(3457,'1','274','1',1,'Retail Sale Id 3383',2246.88,0.00,0.00,3.02,238.58,'2022-08-08 07:48:51','',''),(3458,'1','274','1',1,'Retail Sale Id 3384',4501.20,0.00,0.00,6.05,477.95,'2022-08-08 07:50:26','',''),(3459,'1','274','1',1,'Retail Sale Id 3385',996.96,0.00,0.00,1.34,105.86,'2022-08-08 08:06:30','',''),(3460,'1','274','1',1,'Retail Sale Id 3386',996.96,0.00,0.00,1.34,105.86,'2022-08-08 08:07:14','',''),(3461,'1','274','1',1,'Retail Sale Id 3387',37200.00,0.00,0.00,50.00,3950.00,'2022-08-08 08:21:32','',''),(3462,'1','274','1',1,'Retail Sale Id 3388',9300.00,0.00,0.00,12.50,987.50,'2022-08-08 08:26:41','',''),(3463,'1','274','1',1,'Retail Sale Id 3389',9300.00,0.00,0.00,12.50,987.50,'2022-08-08 08:28:35','',''),(3464,'1','274','1',1,'Retail Sale Id 3390',22597.60,0.00,0.00,30.05,2614.35,'2022-08-08 08:51:21','',''),(3465,'1','274','1',1,'Retail Sale Id 3392',3797.60,0.00,0.00,5.05,439.35,'2022-08-08 09:17:37','',''),(3466,'1','274','1',1,'Retail Sale Id 3393',3000.48,0.00,0.00,3.99,347.13,'2022-08-08 09:44:50','',''),(3467,'1','274','1',1,'Retail Sale Id 3394',9400.00,0.00,0.00,12.50,1087.50,'2022-08-08 09:46:34','',''),(3468,'1','274','1',1,'Retail Sale Id 3395',3797.60,0.00,0.00,5.05,439.35,'2022-08-08 09:47:19','',''),(3469,'1','274','1',1,'Retail Sale Id 3396',9400.00,0.00,0.00,12.50,1087.50,'2022-08-08 09:49:29','',''),(3470,'1','274','1',1,'Retail Sale Id 3397',9400.00,0.00,0.00,12.50,1087.50,'2022-08-08 10:08:11','',''),(3471,'1','274','1',1,'Retail Sale Id 3398',2301.12,0.00,0.00,3.06,266.22,'2022-08-08 10:09:13','',''),(3472,'1','274','1',1,'Retail Sale Id 3399',1496.48,0.00,0.00,1.99,173.13,'2022-08-08 10:10:40','',''),(3473,'1','274','1',1,'Retail Sale Id 3400',5000.80,0.00,0.00,6.65,578.55,'2022-08-08 10:20:06','',''),(3474,'1','274','1',1,'Retail Sale Id 3401',9400.00,0.00,0.00,12.50,1087.50,'2022-08-08 10:29:05','',''),(3475,'1','274','1',1,'Retail Sale Id 3402',2301.12,0.00,0.00,3.06,266.22,'2022-08-08 10:49:46','',''),(3476,'1','274','1',1,'Retail Sale Id 3403',9400.00,0.00,0.00,12.50,1087.50,'2022-08-08 10:54:09','',''),(3477,'1','274','1',1,'Retail Sale Id 3404',9400.00,0.00,0.00,12.50,1087.50,'2022-08-08 11:19:10','',''),(3478,'1','274','1',1,'Retail Sale Id 3405',7550.08,0.00,0.00,10.04,873.48,'2022-08-08 11:30:25','',''),(3479,'1','274','1',1,'Retail Sale Id 3406',4000.64,0.00,0.00,5.32,462.84,'2022-08-08 11:31:49','',''),(3480,'1','274','1',1,'Retail Sale Id 3407',7550.08,0.00,0.00,10.04,873.48,'2022-08-08 11:32:57','',''),(3481,'1','274','1',1,'Retail Sale Id 3408',1496.48,0.00,0.00,1.99,173.13,'2022-08-08 11:41:39','',''),(3482,'1','274','1',1,'Retail Sale Id 3409',18800.00,0.00,0.00,25.00,2175.00,'2022-08-08 11:54:55','',''),(3483,'1','274','1',1,'Retail Sale Id 3410',3797.60,0.00,0.00,5.05,439.35,'2022-08-08 12:08:34','',''),(3484,'1','274','1',1,'Retail Sale Id 3411',3797.60,0.00,0.00,5.05,439.35,'2022-08-08 12:21:43','',''),(3485,'1','274','1',1,'Retail Sale Id 3412',37600.00,0.00,0.00,50.00,4350.00,'2022-08-08 12:45:40','',''),(3486,'1','274','1',1,'Retail Sale Id 3413',20003.20,0.00,0.00,26.60,2314.20,'2022-08-08 12:46:31','',''),(3487,'1','274','1',1,'Return of Retail Sale Id 3412',0.00,37600.00,50.00,0.00,-4350.00,'2022-08-08 12:48:43','',''),(3488,'1','274','1',1,'Retail Sale Id 3414',9400.00,0.00,0.00,12.50,1087.50,'2022-08-08 12:50:19','',''),(3489,'1','274','1',1,'Retail Sale Id 3415',9400.00,0.00,0.00,12.50,1087.50,'2022-08-08 12:55:06','',''),(3490,'1','274','1',1,'Retail Sale Id 3416',18800.00,0.00,0.00,25.00,2175.00,'2022-08-08 12:56:08','',''),(3491,'1','274','1',1,'Retail Sale Id 3417',1000.16,0.00,0.00,1.33,115.71,'2022-08-08 12:56:51','',''),(3492,'1','274','1',1,'Retail Sale Id 3418',1000.16,0.00,0.00,1.33,115.71,'2022-08-08 13:01:59','',''),(3493,'1','274','1',1,'Retail Sale Id 3419',1496.48,0.00,0.00,1.99,173.13,'2022-08-08 13:27:48','',''),(3494,'1','274','1',1,'Retail Sale Id 3420',4496.96,0.00,0.00,5.98,520.26,'2022-08-08 13:28:59','',''),(3495,'1','274','1',1,'Retail Sale Id 3421',3053.12,0.00,0.00,4.06,353.22,'2022-08-08 13:29:39','',''),(3496,'1','274','1',1,'Retail Sale Id 3423',6903.36,0.00,0.00,9.18,798.66,'2022-08-08 13:34:53','',''),(3497,'1','274','1',1,'Retail Sale Id 3424',13949.60,0.00,0.00,18.55,1613.85,'2022-08-08 13:36:23','',''),(3498,'1','274','1',1,'Retail Sale Id 3425',1000.16,0.00,0.00,1.33,115.71,'2022-08-08 14:01:39','',''),(3499,'1','274','1',1,'Retail Sale Id 3426',9798.56,0.00,0.00,13.03,1133.61,'2022-08-08 14:03:34','',''),(3500,'1','274','1',1,'Retail Sale Id 3427',9046.56,0.00,0.00,12.03,1046.61,'2022-08-08 14:08:44','',''),(3501,'1','274','1',1,'Retail Sale Id 3428',1797.28,0.00,0.00,2.39,207.93,'2022-08-08 14:36:26','',''),(3502,'1','274','1',1,'Retail Sale Id 3429',2000.32,0.00,0.00,2.66,231.42,'2022-08-08 14:57:46','',''),(3503,'1','274','1',1,'Retail Sale Id 3432',2496.64,0.00,0.00,3.32,288.84,'2022-08-08 15:19:25','',''),(3504,'1','274','1',1,'Retail Sale Id 3433',3053.12,0.00,0.00,4.06,353.22,'2022-08-08 15:21:51','',''),(3505,'1','274','1',1,'Retail Sale Id 3434',113003.04,0.00,0.00,150.27,13073.49,'2022-08-08 15:23:27','',''),(3506,'1','274','1',1,'Return of Retail Sale Id 3434',0.00,113003.04,150.27,0.00,-13073.49,'2022-08-08 15:41:31','',''),(3507,'1','274','1',1,'Retail Sale Id 3435',112800.00,0.00,0.00,150.00,13050.00,'2022-08-08 15:42:04','',''),(3508,'1','274','1',1,'Return of Retail Sale Id 3435',0.00,112800.00,150.00,0.00,-13050.00,'2022-08-08 15:42:56','',''),(3509,'1','274','1',1,'Retail Sale Id 3436',112800.00,0.00,0.00,150.00,13050.00,'2022-08-08 15:43:18','',''),(3510,'1','274','1',1,'Retail Sale Id 3439',4549.60,0.00,0.00,6.05,526.35,'2022-08-08 15:54:01','',''),(3511,'1','274','1',1,'Retail Sale Id 3440',4000.64,0.00,0.00,5.32,462.84,'2022-08-08 16:21:29','',''),(3512,'1','274','1',1,'Retail Sale Id 3441',18800.00,0.00,0.00,25.00,2175.00,'2022-08-08 16:22:20','',''),(3513,'1','274','1',1,'Retail Sale Id 3442',9400.00,0.00,0.00,12.50,1087.50,'2022-08-08 16:23:41','',''),(3514,'1','274','1',1,'Retail Sale Id 3443',9400.00,0.00,0.00,12.50,1087.50,'2022-08-08 16:29:56','',''),(3515,'1','274','1',1,'Retail Sale Id 3444',3000.48,0.00,0.00,3.99,347.13,'2022-08-08 16:37:38','',''),(3516,'1','274','1',1,'Retail Sale Id 3445',9400.00,0.00,0.00,12.50,1087.50,'2022-08-08 16:51:59','',''),(3517,'1','274','1',1,'Retail Sale Id 3446',2301.12,0.00,0.00,3.06,266.22,'2022-08-08 16:53:39','',''),(3518,'1','274','1',1,'Retail Sale Id 3448',1150.56,0.00,0.00,1.53,133.11,'2022-08-08 17:03:56','',''),(3519,'1','274','1',1,'Retail Sale Id 3449',9400.00,0.00,0.00,12.50,1087.50,'2022-08-08 17:07:01','',''),(3520,'1','274','1',1,'Retail Sale Id 3450',2301.12,0.00,0.00,3.06,266.22,'2022-08-08 17:08:09','',''),(3521,'1','274','1',1,'Retail Sale Id 3451',10197.12,0.00,0.00,13.56,1179.72,'2022-08-08 17:16:52','',''),(3522,'1','274','1',1,'Retail Sale Id 3452',4549.60,0.00,0.00,6.05,526.35,'2022-08-08 17:21:00','',''),(3523,'1','274','1',1,'Retail Sale Id 3453',4000.64,0.00,0.00,5.32,462.84,'2022-08-08 17:28:53','',''),(3524,'1','274','1',1,'Retail Sale Id 3454',2301.12,0.00,0.00,3.06,266.22,'2022-08-08 18:18:34','',''),(3525,'1','274','1',1,'Retail Sale Id 3455',3797.60,0.00,0.00,5.05,439.35,'2022-08-08 18:26:03','',''),(3526,'1','274','1',1,'Retail Sale Id 3456',4549.60,0.00,0.00,6.05,526.35,'2022-08-08 18:52:39','',''),(3527,'1','274','1',1,'Retail Sale Id 3457',4549.60,0.00,0.00,6.05,526.35,'2022-08-08 18:54:54','',''),(3528,'1','274','1',1,'Retail Sale Id 3458',2496.64,0.00,0.00,3.32,288.84,'2022-08-08 18:56:51','',''),(3529,'1','274','1',1,'Retail Sale Id 3459',9400.00,0.00,0.00,12.50,1087.50,'2022-08-08 18:57:32','',''),(3530,'1','274','1',1,'Retail Sale Id 3460',99391.84,0.00,0.00,132.17,11498.79,'2022-08-08 19:52:10','',''),(3531,'1','274','1',1,'Retail Sale Id 3461',3496.80,0.00,0.00,4.65,404.55,'2022-08-09 07:27:38','',''),(3532,'1','274','1',1,'Retail Sale Id 3462',9400.00,0.00,0.00,12.50,1087.50,'2022-08-09 08:20:42','',''),(3533,'1','274','1',1,'Retail Sale Id 3463',22560.00,0.00,0.00,30.00,2610.00,'2022-08-09 09:06:21','',''),(3534,'1','274','1',1,'Retail Sale Id 3464',9400.00,0.00,0.00,12.50,1087.50,'2022-08-09 09:08:00','',''),(3535,'1','274','1',1,'Retail Sale Id 3465',2000.32,0.00,0.00,2.66,231.42,'2022-08-09 09:09:46','',''),(3536,'1','274','1',1,'Retail Sale Id 3466',9400.00,0.00,0.00,12.50,1087.50,'2022-08-09 10:07:49','',''),(3537,'1','274','1',1,'Retail Sale Id 3467',37600.00,0.00,0.00,50.00,4350.00,'2022-08-09 10:09:03','',''),(3538,'1','274','1',1,'Retail Sale Id 3468',6000.96,0.00,0.00,7.98,694.26,'2022-08-09 10:23:24','',''),(3539,'1','274','1',1,'Retail Sale Id 3469',2000.32,0.00,0.00,2.66,231.42,'2022-08-09 10:32:26','',''),(3540,'1','274','1',1,'Retail Sale Id 3470',3000.48,0.00,0.00,3.99,347.13,'2022-08-09 10:44:31','',''),(3541,'1','274','1',1,'Retail Sale Id 3471',4000.64,0.00,0.00,5.32,462.84,'2022-08-09 11:35:39','',''),(3542,'1','274','1',1,'Retail Sale Id 3472',1496.48,0.00,0.00,1.99,173.13,'2022-08-09 11:53:07','',''),(3543,'1','274','1',1,'Retail Sale Id 3473',4602.24,0.00,0.00,6.12,532.44,'2022-08-09 12:10:25','',''),(3544,'1','274','1',1,'Retail Sale Id 3474',3496.80,0.00,0.00,4.65,404.55,'2022-08-09 12:45:33','',''),(3545,'1','274','1',1,'Retail Sale Id 3476',9400.00,0.00,0.00,12.50,1087.50,'2022-08-09 13:50:10','',''),(3546,'1','274','1',1,'Retail Sale Id 3477',1496.48,0.00,0.00,1.99,173.13,'2022-08-09 14:39:52','',''),(3547,'1','274','1',1,'Retail Sale Id 3478',9400.00,0.00,0.00,12.50,1087.50,'2022-08-09 14:49:47','',''),(3548,'1','274','1',1,'Retail Sale Id 3479',9400.00,0.00,0.00,12.50,1087.50,'2022-08-09 15:01:06','',''),(3549,'1','274','1',1,'Retail Sale Id 3480',1504.00,0.00,0.00,2.00,174.00,'2022-08-09 15:11:41','',''),(3550,'1','274','1',1,'Retail Sale Id 3481',9400.00,0.00,0.00,12.50,1087.50,'2022-08-09 15:18:38','',''),(3551,'1','274','1',1,'Retail Sale Id 3482',9400.00,0.00,0.00,12.50,1087.50,'2022-08-09 15:25:27','',''),(3552,'1','274','1',1,'Retail Sale Id 3483',4000.64,0.00,0.00,5.32,462.84,'2022-08-09 16:45:56','',''),(3553,'1','274','1',1,'Retail Sale Id 3484',9400.00,0.00,0.00,12.50,1087.50,'2022-08-09 17:06:32','',''),(3554,'1','274','1',1,'Retail Sale Id 3485',9400.00,0.00,0.00,12.50,1087.50,'2022-08-09 17:08:10','',''),(3555,'1','274','1',1,'Retail Sale Id 3486',9400.00,0.00,0.00,12.50,1087.50,'2022-08-09 17:18:05','',''),(3556,'1','274','1',1,'Retail Sale Id 3487',3496.80,0.00,0.00,4.65,404.55,'2022-08-09 17:20:21','',''),(3557,'1','274','1',1,'Retail Sale Id 3488',9400.00,0.00,0.00,12.50,1087.50,'2022-08-09 17:21:53','',''),(3558,'1','274','1',1,'Retail Sale Id 3489',18002.88,0.00,0.00,23.94,2082.78,'2022-08-09 17:31:06','',''),(3559,'1','274','1',1,'Retail Sale Id 3490',9400.00,0.00,0.00,12.50,1087.50,'2022-08-09 17:43:09','',''),(3560,'1','274','1',1,'Retail Sale Id 3491',9400.00,0.00,0.00,12.50,1087.50,'2022-08-09 17:49:19','',''),(3561,'1','274','1',1,'Retail Sale Id 3492',3000.48,0.00,0.00,3.99,347.13,'2022-08-09 17:52:33','',''),(3562,'1','274','1',1,'Retail Sale Id 3493',9400.00,0.00,0.00,12.50,1087.50,'2022-08-09 17:54:11','',''),(3563,'1','274','1',1,'Retail Sale Id 3494',4512.00,0.00,0.00,6.00,522.00,'2022-08-09 18:05:17','',''),(3564,'1','274','1',1,'Retail Sale Id 3495',2496.64,0.00,0.00,3.32,288.84,'2022-08-09 18:07:21','',''),(3565,'1','274','1',1,'Retail Sale Id 3496',9776.00,0.00,0.00,13.00,1131.00,'2022-08-09 18:23:31','',''),(3566,'1','274','1',1,'Retail Sale Id 3497',122764.00,0.00,0.00,163.25,14202.75,'2022-08-09 19:58:05','',''),(3567,'1','274','1',1,'Retail Sale Id 3498',1000.16,0.00,0.00,1.33,115.71,'2022-08-10 08:06:22','',''),(3568,'1','274','1',1,'Retail Sale Id 3499',8497.60,0.00,0.00,11.30,983.10,'2022-08-10 08:09:35','',''),(3569,'1','274','1',1,'Retail Sale Id 3500',9001.44,0.00,0.00,11.97,1041.39,'2022-08-10 08:13:11','',''),(3570,'1','274','1',1,'Retail Sale Id 3502',9776.00,0.00,0.00,13.00,1131.00,'2022-08-10 08:51:21','',''),(3571,'1','274','1',1,'Retail Sale Id 3503',22560.00,0.00,0.00,30.00,2610.00,'2022-08-10 08:55:27','',''),(3572,'1','274','1',1,'Retail Sale Id 3504',1000.16,0.00,0.00,1.33,115.71,'2022-08-10 09:22:26','',''),(3573,'1','274','1',1,'Retail Sale Id 3505',3797.60,0.00,0.00,5.05,439.35,'2022-08-10 09:46:29','',''),(3574,'1','274','1',1,'Retail Sale Id 3506',9400.00,0.00,0.00,12.50,1087.50,'2022-08-10 09:58:17','',''),(3575,'1','274','1',1,'Retail Sale Id 3507',2301.12,0.00,0.00,3.06,266.22,'2022-08-10 10:01:47','',''),(3576,'1','274','1',1,'Retail Sale Id 3508',14400.80,0.00,0.00,19.15,1666.05,'2022-08-10 10:04:41','',''),(3577,'1','274','1',1,'Retail Sale Id 3509',2301.12,0.00,0.00,3.06,266.22,'2022-08-10 10:10:07','',''),(3578,'1','274','1',1,'Retail Sale Id 3510',2301.12,0.00,0.00,3.06,266.22,'2022-08-10 10:21:17','',''),(3579,'1','274','1',1,'Retail Sale Id 3511',9001.44,0.00,0.00,11.97,1041.39,'2022-08-10 10:24:56','',''),(3580,'1','274','1',1,'Retail Sale Id 3512',9400.00,0.00,0.00,12.50,1087.50,'2022-08-10 10:34:58','',''),(3581,'1','274','1',1,'Retail Sale Id 3513',9400.00,0.00,0.00,12.50,1087.50,'2022-08-10 10:49:18','',''),(3582,'1','274','1',1,'Retail Sale Id 3514',9001.44,0.00,0.00,11.97,1041.39,'2022-08-10 10:50:58','',''),(3583,'1','274','1',1,'Retail Sale Id 3515',9400.00,0.00,0.00,12.50,1087.50,'2022-08-10 10:55:19','',''),(3584,'1','274','1',1,'Retail Sale Id 3516',3000.48,0.00,0.00,3.99,347.13,'2022-08-10 11:14:44','',''),(3585,'1','274','1',1,'Retail Sale Id 3517',33900.16,0.00,0.00,45.08,3921.96,'2022-08-10 11:21:59','',''),(3586,'1','274','1',1,'Retail Sale Id 3518',4602.24,0.00,0.00,6.12,532.44,'2022-08-10 11:52:44','',''),(3587,'1','274','1',1,'Retail Sale Id 3519',3496.80,0.00,0.00,4.65,404.55,'2022-08-10 12:03:53','',''),(3588,'1','274','1',1,'Retail Sale Id 3520',5000.80,0.00,0.00,6.65,578.55,'2022-08-10 12:13:22','',''),(3589,'1','274','1',1,'Retail Sale Id 3521',2000.32,0.00,0.00,2.66,231.42,'2022-08-10 12:16:26','',''),(3590,'1','274','1',1,'Retail Sale Id 3522',2000.32,0.00,0.00,2.66,231.42,'2022-08-10 12:29:52','',''),(3591,'1','274','1',1,'Retail Sale Id 3523',1504.00,0.00,0.00,2.00,174.00,'2022-08-10 12:46:25','',''),(3592,'1','274','1',1,'Retail Sale Id 3525',1496.48,0.00,0.00,1.99,173.13,'2022-08-10 12:48:04','',''),(3593,'1','274','1',1,'Retail Sale Id 3526',11001.76,0.00,0.00,14.63,1272.81,'2022-08-10 12:59:02','',''),(3594,'1','274','1',1,'Retail Sale Id 3527',5301.60,0.00,0.00,7.05,613.35,'2022-08-10 13:00:15','',''),(3595,'1','274','1',1,'Retail Sale Id 3528',2301.12,0.00,0.00,3.06,266.22,'2022-08-10 14:21:57','',''),(3596,'1','274','1',1,'Retail Sale Id 3529',9400.00,0.00,0.00,12.50,1087.50,'2022-08-10 14:23:30','',''),(3597,'1','274','1',1,'Retail Sale Id 3530',2301.12,0.00,0.00,3.06,266.22,'2022-08-10 14:26:00','',''),(3598,'1','274','1',1,'Retail Sale Id 3531',9400.00,0.00,0.00,12.50,1087.50,'2022-08-10 14:45:29','',''),(3599,'1','274','1',1,'Retail Sale Id 3532',2000.32,0.00,0.00,2.66,231.42,'2022-08-10 14:58:52','',''),(3600,'1','274','1',1,'Retail Sale Id 3533',4602.24,0.00,0.00,6.12,532.44,'2022-08-10 15:16:20','',''),(3601,'1','274','1',1,'Retail Sale Id 3534',1000.16,0.00,0.00,1.33,115.71,'2022-08-10 15:29:21','',''),(3602,'1','274','1',1,'Retail Sale Id 3535',2496.64,0.00,0.00,3.32,288.84,'2022-08-10 15:30:02','',''),(3603,'1','274','1',1,'Retail Sale Id 3537',15047.52,0.00,0.00,20.01,1740.87,'2022-08-10 15:39:07','',''),(3604,'1','274','1',1,'Retail Sale Id 3538',2301.12,0.00,0.00,3.06,266.22,'2022-08-10 16:22:28','',''),(3605,'1','274','1',1,'Retail Sale Id 3539',9400.00,0.00,0.00,12.50,1087.50,'2022-08-10 16:23:20','',''),(3606,'1','274','1',1,'Retail Sale Id 3540',2301.12,0.00,0.00,3.06,266.22,'2022-08-10 16:35:45','',''),(3607,'1','274','1',1,'Retail Sale Id 3541',2301.12,0.00,0.00,3.06,266.22,'2022-08-10 17:01:13','',''),(3608,'1','274','1',1,'Retail Sale Id 3542',4700.00,0.00,0.00,6.25,543.75,'2022-08-10 17:04:20','',''),(3609,'1','274','1',1,'Retail Sale Id 3543',21003.36,0.00,0.00,27.93,2429.91,'2022-08-10 17:46:44','',''),(3610,'1','274','1',1,'Retail Sale Id 3544',3053.12,0.00,0.00,4.06,353.22,'2022-08-10 17:52:45','',''),(3611,'1','274','1',1,'Retail Sale Id 3545',9400.00,0.00,0.00,12.50,1087.50,'2022-08-10 17:54:08','',''),(3612,'1','274','1',1,'Retail Sale Id 3546',9400.00,0.00,0.00,12.50,1087.50,'2022-08-10 17:58:35','',''),(3613,'1','274','1',1,'Retail Sale Id 3547',3000.48,0.00,0.00,3.99,347.13,'2022-08-10 18:04:55','',''),(3614,'1','274','1',1,'Retail Sale Id 3548',14002.24,0.00,0.00,18.62,1619.94,'2022-08-10 18:12:54','',''),(3615,'1','274','1',1,'Retail Sale Id 3549',9400.00,0.00,0.00,12.50,1087.50,'2022-08-10 18:23:55','',''),(3616,'1','274','1',1,'Retail Sale Id 3551',1300.96,0.00,0.00,1.73,150.51,'2022-08-10 18:45:14','',''),(3617,'1','274','1',1,'Retail Sale Id 3552',2000.32,0.00,0.00,2.66,231.42,'2022-08-10 18:46:11','',''),(3618,'1','274','1',1,'Retail Sale Id 3553',9400.00,0.00,0.00,12.50,1087.50,'2022-08-10 18:57:21','',''),(3619,'1','274','1',1,'Retail Sale Id 3554',13160.00,0.00,0.00,17.50,1522.50,'2022-08-10 19:09:51','',''),(3620,'1','274','1',1,'Retail Sale Id 3555',2000.32,0.00,0.00,2.66,231.42,'2022-08-10 19:12:23','',''),(3621,'1','274','1',1,'Retail Sale Id 3557',139368.16,0.00,0.00,185.33,16123.71,'2022-08-10 19:54:25','',''),(3622,'1','274','1',1,'Retail Sale Id 3558',18198.40,0.00,0.00,24.20,2105.40,'2022-08-11 07:57:59','',''),(3623,'1','274','1',1,'Retail Sale Id 3559',2301.12,0.00,0.00,3.06,266.22,'2022-08-11 08:12:28','',''),(3624,'1','274','1',1,'Retail Sale Id 3560',18800.00,0.00,0.00,25.00,2175.00,'2022-08-11 08:26:35','',''),(3625,'1','274','1',1,'Retail Sale Id 3561',37600.00,0.00,0.00,50.00,4350.00,'2022-08-11 09:49:54','',''),(3626,'1','274','1',1,'Retail Sale Id 3562',8399.84,0.00,0.00,11.17,971.79,'2022-08-11 10:02:49','',''),(3627,'1','274','1',1,'Retail Sale Id 3563',4512.00,0.00,0.00,6.00,522.00,'2022-08-11 10:03:42','',''),(3628,'1','274','1',1,'Retail Sale Id 3564',9400.00,0.00,0.00,12.50,1087.50,'2022-08-11 10:16:10','',''),(3629,'1','274','1',1,'Retail Sale Id 3565',1000.16,0.00,0.00,1.33,115.71,'2022-08-11 10:39:05','',''),(3630,'1','274','1',1,'Retail Sale Id 3566',1496.48,0.00,0.00,1.99,173.13,'2022-08-11 11:46:43','',''),(3631,'1','274','1',1,'Retail Sale Id 3567',3000.48,0.00,0.00,3.99,347.13,'2022-08-11 11:48:22','',''),(3632,'1','274','1',1,'Retail Sale Id 3568',9400.00,0.00,0.00,12.50,1087.50,'2022-08-11 11:55:43','',''),(3633,'1','274','1',1,'Retail Sale Id 3569',8302.08,0.00,0.00,11.04,960.48,'2022-08-11 12:00:18','',''),(3634,'1','274','1',1,'Retail Sale Id 3570',2496.64,0.00,0.00,3.32,288.84,'2022-08-11 12:43:55','',''),(3635,'1','274','1',1,'Retail Sale Id 3571',9001.44,0.00,0.00,11.97,1041.39,'2022-08-11 12:45:00','',''),(3636,'1','274','1',1,'Retail Sale Id 3572',9400.00,0.00,0.00,12.50,1087.50,'2022-08-11 12:45:55','',''),(3637,'1','274','1',1,'Retail Sale Id 3573',22597.60,0.00,0.00,30.05,2614.35,'2022-08-11 13:35:51','',''),(3638,'1','274','1',1,'Retail Sale Id 3574',37600.00,0.00,0.00,50.00,4350.00,'2022-08-11 14:01:07','',''),(3639,'1','274','1',1,'Retail Sale Id 3576',2301.12,0.00,0.00,3.06,266.22,'2022-08-11 14:31:08','',''),(3640,'1','274','1',1,'Retail Sale Id 3577',3797.60,0.00,0.00,5.05,439.35,'2022-08-11 14:37:31','',''),(3641,'1','274','1',1,'Retail Sale Id 3578',1496.48,0.00,0.00,1.99,173.13,'2022-08-11 14:44:24','',''),(3642,'1','274','1',1,'Returned bridging 27',0.00,0.00,0.00,1000.00,0.00,'2022-08-11 14:57:06','',''),(3643,'1','274',NULL,1,'Reception Return corrector for bridging 27',0.00,0.00,1000.00,0.00,0.00,'2022-08-11 14:57:06','',''),(3644,'1','274',NULL,1,'Returned purchase #28 to AA RANO NIGERIA LTD',665000.00,0.00,0.00,1000.00,0.00,'2022-08-11 14:57:26','',''),(3645,'1','274','1',1,'Retail Sale Id 3579',2000.32,0.00,0.00,2.66,231.42,'2022-08-11 15:08:39','',''),(3646,'1','274','1',1,'Retail Sale Id 3580',1000.16,0.00,0.00,1.33,115.71,'2022-08-11 15:21:50','',''),(3647,'1','274','1',1,'Retail Sale Id 3581',4602.24,0.00,0.00,6.12,532.44,'2022-08-11 15:53:33','',''),(3648,'1','274','1',1,'Retail Sale Id 3583',2248.48,0.00,0.00,2.99,260.13,'2022-08-11 15:58:00','',''),(3649,'1','274','1',1,'Retail Sale Id 3584',1496.48,0.00,0.00,1.99,173.13,'2022-08-11 16:04:17','',''),(3650,'1','274','1',1,'Retail Sale Id 3585',1000.16,0.00,0.00,1.33,115.71,'2022-08-11 16:08:24','',''),(3651,'1','274','1',1,'Retail Sale Id 3587',7497.44,0.00,0.00,9.97,867.39,'2022-08-11 16:10:03','',''),(3652,'1','274','1',1,'Retail Sale Id 3589',1496.48,0.00,0.00,1.99,173.13,'2022-08-11 16:14:43','',''),(3653,'1','274','1',1,'Retail Sale Id 3590',2000.32,0.00,0.00,2.66,231.42,'2022-08-11 16:27:16','',''),(3654,'1','274','1',1,'Retail Sale Id 3592',9798.56,0.00,0.00,13.03,1133.61,'2022-08-11 16:31:42','',''),(3655,'1','274','1',1,'Retail Sale Id 3593',5000.80,0.00,0.00,6.65,578.55,'2022-08-11 16:37:16','',''),(3656,'1','274','1',1,'Retail Sale Id 3594',3000.48,0.00,0.00,3.99,347.13,'2022-08-11 16:53:08','',''),(3657,'1','274','1',1,'Retail Sale Id 3595',18800.00,0.00,0.00,25.00,2175.00,'2022-08-11 16:57:04','',''),(3658,'1','274','1',1,'Retail Sale Id 3596',2496.64,0.00,0.00,3.32,288.84,'2022-08-11 16:59:18','',''),(3659,'1','274','1',1,'Retail Sale Id 3597',2000.32,0.00,0.00,2.66,231.42,'2022-08-11 18:22:20','',''),(3660,'1','274','1',1,'Retail Sale Id 3598',9400.00,0.00,0.00,12.50,1087.50,'2022-08-11 18:29:42','',''),(3661,'1','274','1',1,'Retail Sale Id 3599',8001.28,0.00,0.00,10.64,925.68,'2022-08-11 19:11:40','',''),(3662,'1','274','1',1,'Retail Sale Id 3600',138149.92,0.00,0.00,183.71,15982.77,'2022-08-11 19:46:30','',''),(3663,'1','274','1',1,'Retail Sale Id 3601',4496.96,0.00,0.00,5.98,520.26,'2022-08-12 06:46:05','',''),(3664,'1','274','1',1,'Retail Sale Id 3602',1000.16,0.00,0.00,1.33,115.71,'2022-08-12 06:48:12','',''),(3665,'1','274','1',1,'Retail Sale Id 3603',2256.00,0.00,0.00,3.00,261.00,'2022-08-12 07:11:28','',''),(3666,'1','274','1',1,'Retail Sale Id 3604',15002.40,0.00,0.00,19.95,1735.65,'2022-08-12 07:12:24','',''),(3667,'1','274','1',1,'Retail Sale Id 3605',3000.48,0.00,0.00,3.99,347.13,'2022-08-12 07:28:21','',''),(3668,'1','274','1',1,'Retail Sale Id 3606',3053.12,0.00,0.00,4.06,353.22,'2022-08-12 07:39:09','',''),(3669,'1','274','1',1,'Retail Sale Id 3607',4602.24,0.00,0.00,6.12,532.44,'2022-08-12 08:14:54','',''),(3670,'1','274','1',1,'Retail Sale Id 3608',1000.16,0.00,0.00,1.33,115.71,'2022-08-12 08:35:53','',''),(3671,'1','274','1',1,'Retail Sale Id 3609',9400.00,0.00,0.00,12.50,1087.50,'2022-08-12 08:38:59','',''),(3672,'1','274','1',1,'Retail Sale Id 3610',752.00,0.00,0.00,1.00,87.00,'2022-08-12 08:53:59','',''),(3673,'1','274','1',1,'Retail Sale Id 3611',1000.16,0.00,0.00,1.33,115.71,'2022-08-12 09:23:47','',''),(3674,'1','274','1',1,'Retail Sale Id 3612',752.00,0.00,0.00,1.00,87.00,'2022-08-12 12:13:41','',''),(3675,'1','274','1',1,'Retail Sale Id 3613',752.00,0.00,0.00,1.00,87.00,'2022-08-12 12:30:08','',''),(3676,'1','274','1',1,'Retail Sale Id 3614',2301.12,0.00,0.00,3.06,266.22,'2022-08-12 12:50:53','',''),(3677,'1','274','1',1,'Retail Sale Id 3615',9400.00,0.00,0.00,12.50,1087.50,'2022-08-12 15:10:21','',''),(3678,'1','274','1',1,'Retail Sale Id 3616',13197.60,0.00,0.00,17.55,1526.85,'2022-08-12 15:13:18','',''),(3679,'1','274','1',1,'Retail Sale Id 3617',1000.16,0.00,0.00,1.33,115.71,'2022-08-12 17:08:29','',''),(3680,'1','274','1',1,'Retail Sale Id 3618',9798.56,0.00,0.00,13.03,1133.61,'2022-08-12 17:42:56','',''),(3681,'1','274','1',1,'Retail Sale Id 3619',4602.24,0.00,0.00,6.12,532.44,'2022-08-12 17:47:25','',''),(3682,'1','274','1',1,'Retail Sale Id 3620',9798.56,0.00,0.00,13.03,1133.61,'2022-08-12 18:12:50','',''),(3683,'1','274','1',1,'Retail Sale Id 3621',2496.64,0.00,0.00,3.32,288.84,'2022-08-12 18:16:44','',''),(3684,'1','274','1',1,'Retail Sale Id 3622',4602.24,0.00,0.00,6.12,532.44,'2022-08-12 18:37:51','',''),(3685,'1','274','1',1,'Retail Sale Id 3623',9400.00,0.00,0.00,12.50,1087.50,'2022-08-12 18:51:30','',''),(3686,'1','274','1',1,'Retail Sale Id 3625',9400.00,0.00,0.00,12.50,1087.50,'2022-08-12 19:07:22','',''),(3687,'1','274','1',1,'Retail Sale Id 3627',365020.80,0.00,0.00,485.40,42229.80,'2022-08-12 20:07:38','',''),(3688,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,665000.00,1000.00,0.00,0.00,'2022-08-12 20:11:38','',''),(3689,'1','274',NULL,1,'Reception corrector for bridging 30',0.00,0.00,0.00,1000.00,0.00,'2022-08-12 20:13:51','',''),(3690,'1','274','1',1,'Received from bridging 30',0.00,0.00,1000.00,0.00,0.00,'2022-08-12 20:13:51','',''),(3691,'1','274','1',1,'Retail Sale Id 3628',1601.76,0.00,0.00,2.13,185.31,'2022-08-13 07:17:23','',''),(3692,'1','274','1',1,'Retail Sale Id 3629',15040.00,0.00,0.00,20.00,1740.00,'2022-08-13 07:41:15','',''),(3693,'1','274','1',1,'Retail Sale Id 3630',9400.00,0.00,0.00,12.50,1087.50,'2022-08-13 07:42:10','',''),(3694,'1','274','1',1,'Retail Sale Id 3631',2000.32,0.00,0.00,2.66,231.42,'2022-08-13 07:56:14','',''),(3695,'1','274','1',1,'Retail Sale Id 3632',9400.00,0.00,0.00,12.50,1087.50,'2022-08-13 08:26:14','',''),(3696,'1','274','1',1,'Retail Sale Id 3633',4602.24,0.00,0.00,6.12,532.44,'2022-08-13 08:30:50','',''),(3697,'1','274','1',1,'Retail Sale Id 3634',1601.76,0.00,0.00,2.13,185.31,'2022-08-13 08:32:23','',''),(3698,'1','274','1',1,'Retail Sale Id 3635',2000.32,0.00,0.00,2.66,231.42,'2022-08-13 08:33:23','',''),(3699,'1','274','1',1,'Retail Sale Id 3636',4496.96,0.00,0.00,5.98,520.26,'2022-08-13 08:34:29','',''),(3700,'1','274','1',1,'Retail Sale Id 3637',1000.16,0.00,0.00,1.33,115.71,'2022-08-13 08:35:26','',''),(3701,'1','274','1',1,'Retail Sale Id 3638',9400.00,0.00,0.00,12.50,1087.50,'2022-08-13 08:57:23','',''),(3702,'1','274','1',1,'Retail Sale Id 3639',3797.60,0.00,0.00,5.05,439.35,'2022-08-13 09:11:56','',''),(3703,'1','274','1',1,'Retail Sale Id 3641',4496.96,0.00,0.00,5.98,520.26,'2022-08-13 09:13:51','',''),(3704,'1','274','1',1,'Retail Sale Id 3642',9400.00,0.00,0.00,12.50,1087.50,'2022-08-13 09:23:34','',''),(3705,'1','274','1',1,'Retail Sale Id 3643',2000.32,0.00,0.00,2.66,231.42,'2022-08-13 09:25:07','',''),(3706,'1','274','1',1,'Retail Sale Id 3644',3797.60,0.00,0.00,5.05,439.35,'2022-08-13 09:32:01','',''),(3707,'1','274','1',1,'Retail Sale Id 3645',2000.32,0.00,0.00,2.66,231.42,'2022-08-13 09:36:31','',''),(3708,'1','274','1',1,'Retail Sale Id 3646',22597.60,0.00,0.00,30.05,2614.35,'2022-08-13 09:45:45','',''),(3709,'1','274','1',1,'Retail Sale Id 3647',8001.28,0.00,0.00,10.64,925.68,'2022-08-13 09:50:30','',''),(3710,'1','274','1',1,'Retail Sale Id 3649',9001.44,0.00,0.00,11.97,1041.39,'2022-08-13 10:55:54','',''),(3711,'1','274','1',1,'Retail Sale Id 3650',2301.12,0.00,0.00,3.06,266.22,'2022-08-13 11:01:28','',''),(3712,'1','274','1',1,'Retail Sale Id 3653',3000.48,0.00,0.00,3.99,347.13,'2022-08-13 12:03:41','',''),(3713,'1','274','1',1,'Retail Sale Id 3654',37600.00,0.00,0.00,50.00,4350.00,'2022-08-13 12:32:55','',''),(3714,'1','274','1',1,'Retail Sale Id 3655',4602.24,0.00,0.00,6.12,532.44,'2022-08-13 12:41:02','',''),(3715,'1','274','1',1,'Retail Sale Id 3656',75200.00,0.00,0.00,100.00,8700.00,'2022-08-13 12:43:45','',''),(3716,'1','274','1',1,'Retail Sale Id 3657',82201.12,0.00,0.00,109.31,9509.97,'2022-08-13 12:45:59','',''),(3717,'1','274','1',1,'Return of Retail Sale Id 3656',0.00,75200.00,100.00,0.00,-8700.00,'2022-08-13 12:47:52','',''),(3718,'1','274','1',1,'Retail Sale Id 3658',7550.08,0.00,0.00,10.04,873.48,'2022-08-13 12:48:34','',''),(3719,'1','274','1',1,'Retail Sale Id 3659',24447.52,0.00,0.00,32.51,2828.37,'2022-08-13 13:05:32','',''),(3720,'1','274','1',1,'Retail Sale Id 3660',14002.24,0.00,0.00,18.62,1619.94,'2022-08-13 13:10:30','',''),(3721,'1','274','1',1,'Retail Sale Id 3661',6903.36,0.00,0.00,9.18,798.66,'2022-08-13 13:11:43','',''),(3722,'1','274','1',1,'Retail Sale Id 3662',9776.00,0.00,0.00,13.00,1131.00,'2022-08-13 13:44:44','',''),(3723,'1','274','1',1,'Retail Sale Id 3663',9400.00,0.00,0.00,12.50,1087.50,'2022-08-13 13:48:51','',''),(3724,'1','274','1',1,'Retail Sale Id 3664',7001.12,0.00,0.00,9.31,809.97,'2022-08-13 13:54:57','',''),(3725,'1','274','1',1,'Retail Sale Id 3665',5000.80,0.00,0.00,6.65,578.55,'2022-08-13 14:01:36','',''),(3726,'1','274','1',1,'Retail Sale Id 3666',9400.00,0.00,0.00,12.50,1087.50,'2022-08-13 14:23:33','',''),(3727,'1','274','1',1,'Retail Sale Id 3667',2000.32,0.00,0.00,2.66,231.42,'2022-08-13 14:26:22','',''),(3728,'1','274','1',1,'Retail Sale Id 3668',4602.24,0.00,0.00,6.12,532.44,'2022-08-13 14:36:50','',''),(3729,'1','274','1',1,'Retail Sale Id 3669',9400.00,0.00,0.00,12.50,1087.50,'2022-08-13 14:58:16','',''),(3730,'1','274','1',1,'Retail Sale Id 3670',1549.12,0.00,0.00,2.06,179.22,'2022-08-13 15:17:17','',''),(3731,'1','274','1',1,'Retail Sale Id 3671',2301.12,0.00,0.00,3.06,266.22,'2022-08-13 15:43:37','',''),(3732,'1','274','1',1,'Retail Sale Id 3672',14002.24,0.00,0.00,18.62,1619.94,'2022-08-13 17:11:41','',''),(3733,'1','274','1',1,'Retail Sale Id 3673',3797.60,0.00,0.00,5.05,439.35,'2022-08-13 17:34:47','',''),(3734,'1','274','1',1,'Retail Sale Id 3674',9400.00,0.00,0.00,12.50,1087.50,'2022-08-13 17:44:47','',''),(3735,'1','274','1',1,'Retail Sale Id 3675',36998.40,0.00,0.00,49.20,4280.40,'2022-08-13 17:52:23','',''),(3736,'1','274','1',1,'Retail Sale Id 3676',1398.72,0.00,0.00,1.86,161.82,'2022-08-13 17:53:34','',''),(3737,'1','274','1',1,'Retail Sale Id 3677',3000.48,0.00,0.00,3.99,347.13,'2022-08-13 17:57:56','',''),(3738,'1','274','1',1,'Retail Sale Id 3678',2000.32,0.00,0.00,2.66,231.42,'2022-08-13 18:01:04','',''),(3739,'1','274','1',1,'Retail Sale Id 3679',3797.60,0.00,0.00,5.05,439.35,'2022-08-13 18:02:31','',''),(3740,'1','274','1',1,'Retail Sale Id 3680',9798.56,0.00,0.00,13.03,1133.61,'2022-08-13 18:11:22','',''),(3741,'1','274','1',1,'Retail Sale Id 3681',4000.64,0.00,0.00,5.32,462.84,'2022-08-13 18:20:12','',''),(3742,'1','274','1',1,'Retail Sale Id 3682',3098.24,0.00,0.00,4.12,358.44,'2022-08-13 18:21:36','',''),(3743,'1','274','1',1,'Retail Sale Id 3683',4602.24,0.00,0.00,6.12,532.44,'2022-08-13 18:24:37','',''),(3744,'1','274','1',1,'Retail Sale Id 3684',32854.88,0.00,0.00,43.69,3801.03,'2022-08-13 19:41:02','',''),(3745,'1','274','1',1,'Retail Sale Id 3685',153851.68,0.00,0.00,204.59,17799.33,'2022-08-13 19:42:50','',''),(3746,'1','274','1',1,'Retail Sale Id 3686',1000.16,0.00,0.00,1.33,115.71,'2022-08-14 07:13:38','',''),(3747,'1','274','1',1,'Retail Sale Id 3687',9400.00,0.00,0.00,12.50,1087.50,'2022-08-14 07:14:17','',''),(3748,'1','274','1',1,'Retail Sale Id 3688',37600.00,0.00,0.00,50.00,4350.00,'2022-08-14 07:27:23','',''),(3749,'1','274','1',1,'Retail Sale Id 3689',1496.48,0.00,0.00,1.99,173.13,'2022-08-14 07:31:00','',''),(3750,'1','274','1',1,'Return of Retail Sale Id 3688',0.00,37600.00,50.00,0.00,-4350.00,'2022-08-14 07:31:47','',''),(3751,'1','274','1',1,'Retail Sale Id 3690',29997.28,0.00,0.00,39.89,3470.43,'2022-08-14 07:32:23','',''),(3752,'1','274','1',1,'Retail Sale Id 3691',10001.60,0.00,0.00,13.30,1157.10,'2022-08-14 07:34:18','',''),(3753,'1','274','1',1,'Retail Sale Id 3693',4602.24,0.00,0.00,6.12,532.44,'2022-08-14 07:50:11','',''),(3754,'1','274','1',1,'Retail Sale Id 3694',3000.48,0.00,0.00,3.99,347.13,'2022-08-14 07:59:11','',''),(3755,'1','274','1',1,'Retail Sale Id 3695',4000.64,0.00,0.00,5.32,462.84,'2022-08-14 08:13:56','',''),(3756,'1','274','1',1,'Retail Sale Id 3696',797.12,0.00,0.00,1.06,92.22,'2022-08-14 08:16:30','',''),(3757,'1','274','1',1,'Retail Sale Id 3697',9400.00,0.00,0.00,12.50,1087.50,'2022-08-14 08:20:22','',''),(3758,'1','274','1',1,'Retail Sale Id 3699',1000.16,0.00,0.00,1.33,115.71,'2022-08-14 08:22:34','',''),(3759,'1','274','1',1,'Retail Sale Id 3700',9400.00,0.00,0.00,12.50,1087.50,'2022-08-14 08:28:04','',''),(3760,'1','274','1',1,'Retail Sale Id 3701',9400.00,0.00,0.00,12.50,1087.50,'2022-08-14 12:15:00','',''),(3761,'1','274','1',1,'Retail Sale Id 3702',173110.40,0.00,0.00,230.20,20027.40,'2022-08-14 13:27:01','',''),(3762,'1','274','1',1,'Return of Retail Sale Id 3702',0.00,173110.40,230.20,0.00,-20027.40,'2022-08-14 14:30:41','',''),(3763,'1','274','1',1,'Retail Sale Id 3703',152370.24,0.00,0.00,202.62,17627.94,'2022-08-14 14:43:17','',''),(3764,'1','274','1',1,'Retail Sale Id 3704',3797.60,0.00,0.00,5.05,439.35,'2022-08-14 14:44:38','',''),(3765,'1','274','1',1,'Return of Retail Sale Id 3703',0.00,152370.24,202.62,0.00,-17627.94,'2022-08-14 14:46:42','',''),(3766,'1','274','1',1,'Retail Sale Id 3705',148572.64,0.00,0.00,197.57,17188.59,'2022-08-14 15:09:50','',''),(3767,'1','274','1',1,'Retail Sale Id 3706',20740.16,0.00,0.00,27.58,2399.46,'2022-08-14 15:17:51','',''),(3768,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,32638.20,49.08,0.00,0.00,'2022-08-14 15:22:31','',''),(3769,'1','274',NULL,1,'Returned purchase #32 to AA RANO NIGERIA LTD',32638.20,0.00,0.00,49.08,0.00,'2022-08-14 15:44:19','',''),(3770,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,32638.20,49.08,0.00,0.00,'2022-08-14 15:51:48','',''),(3771,'1','274',NULL,1,'Reception corrector for bridging 34',0.00,0.00,0.00,49.08,0.00,'2022-08-14 16:04:27','',''),(3772,'1','274','1',1,'Received from bridging 34',0.00,0.00,49.08,0.00,0.00,'2022-08-14 16:04:27','',''),(3773,'1','274','1',1,'Return of Retail Sale Id 3705',0.00,148572.64,197.57,0.00,-17188.59,'2022-08-14 16:34:29','',''),(3774,'1','274','1',1,'Retail Sale Id 3707',127832.48,0.00,0.00,169.99,14789.13,'2022-08-14 16:36:10','',''),(3775,'1','274','1',1,'Retail Sale Id 3708',57648.32,0.00,0.00,76.66,6669.42,'2022-08-14 16:38:08','',''),(3776,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,665000.00,1000.00,0.00,0.00,'2022-08-14 17:44:25','',''),(3777,'1','274',NULL,1,'Reception corrector for bridging 35',0.00,0.00,0.00,1000.00,0.00,'2022-08-14 17:45:56','',''),(3778,'1','274','1',1,'Received from bridging 35',0.00,0.00,1000.00,0.00,0.00,'2022-08-14 17:45:56','',''),(3779,'1','274','1',1,'Retail Sale Id 3709',98805.28,0.00,0.00,131.39,11430.93,'2022-08-14 19:41:57','',''),(3780,'1','274','1',1,'Retail Sale Id 3710',21056.00,0.00,0.00,28.00,2436.00,'2022-08-14 19:43:30','',''),(3781,'1','274','1',1,'Retail Sale Id 3711',9400.00,0.00,0.00,12.50,1087.50,'2022-08-15 07:45:11','',''),(3782,'1','274','1',1,'Retail Sale Id 3712',7520.00,0.00,0.00,10.00,870.00,'2022-08-15 07:46:39','',''),(3783,'1','274','1',1,'Retail Sale Id 3713',15040.00,0.00,0.00,20.00,1740.00,'2022-08-15 08:38:34','',''),(3784,'1','274','1',1,'Retail Sale Id 3714',4512.00,0.00,0.00,6.00,522.00,'2022-08-15 08:40:09','',''),(3785,'1','274','1',1,'Retail Sale Id 3715',37600.00,0.00,0.00,50.00,4350.00,'2022-08-15 09:06:33','',''),(3786,'1','274','1',1,'Retail Sale Id 3716',9400.00,0.00,0.00,12.50,1087.50,'2022-08-15 09:28:51','',''),(3787,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,2932650.00,4410.00,0.00,0.00,'2022-08-15 09:30:23','',''),(3788,'1','274',NULL,1,'Reception corrector for bridging 36',0.00,0.00,0.00,4410.00,0.00,'2022-08-15 09:31:18','',''),(3789,'1','274','1',1,'Received from bridging 36',0.00,0.00,4410.00,0.00,0.00,'2022-08-15 09:31:18','',''),(3790,'1','274','1',1,'Retail Sale Id 3717',15040.00,0.00,0.00,20.00,1740.00,'2022-08-15 09:32:29','',''),(3791,'1','274','1',1,'Retail Sale Id 3718',22560.00,0.00,0.00,30.00,2610.00,'2022-08-15 10:43:26','',''),(3792,'1','274','1',1,'Retail Sale Id 3719',1699.52,0.00,0.00,2.26,196.62,'2022-08-15 10:45:55','',''),(3793,'1','274','1',1,'Retail Sale Id 3720',2000.32,0.00,0.00,2.66,231.42,'2022-08-15 11:10:41','',''),(3794,'1','274','1',1,'Retail Sale Id 3721',3000.48,0.00,0.00,3.99,347.13,'2022-08-15 11:11:40','',''),(3795,'1','274','1',1,'Retail Sale Id 3722',9400.00,0.00,0.00,12.50,1087.50,'2022-08-15 11:16:17','',''),(3796,'1','274','1',1,'Retail Sale Id 3723',5000.80,0.00,0.00,6.65,578.55,'2022-08-15 11:17:03','',''),(3797,'1','274','1',1,'Retail Sale Id 3724',3000.48,0.00,0.00,3.99,347.13,'2022-08-15 12:45:21','',''),(3798,'1','274','1',1,'Retail Sale Id 3725',9400.00,0.00,0.00,12.50,1087.50,'2022-08-15 13:49:16','',''),(3799,'1','274','1',1,'Retail Sale Id 3726',4000.64,0.00,0.00,5.32,462.84,'2022-08-15 14:07:20','',''),(3800,'1','274','1',1,'Retail Sale Id 3727',9400.00,0.00,0.00,12.50,1087.50,'2022-08-15 14:08:07','',''),(3801,'1','274','1',1,'Retail Sale Id 3728',3797.60,0.00,0.00,5.05,439.35,'2022-08-15 14:28:21','',''),(3802,'1','274','1',1,'Retail Sale Id 3729',797.12,0.00,0.00,1.06,92.22,'2022-08-15 16:21:03','',''),(3803,'1','274','1',1,'Retail Sale Id 3730',3760.00,0.00,0.00,5.00,435.00,'2022-08-15 16:46:26','',''),(3804,'1','274','1',1,'Retail Sale Id 3730',9400.00,0.00,0.00,12.50,1087.50,'2022-08-15 16:46:26','',''),(3805,'1','274','1',1,'Retail Sale Id 3731',9776.00,0.00,0.00,13.00,1131.00,'2022-08-15 16:47:28','',''),(3806,'1','274','1',1,'Retail Sale Id 3733',15040.00,0.00,0.00,20.00,1740.00,'2022-08-15 17:07:32','',''),(3807,'1','274','1',1,'Retail Sale Id 3734',2000.32,0.00,0.00,2.66,231.42,'2022-08-15 17:09:45','',''),(3808,'1','274','1',1,'Retail Sale Id 3735',9001.44,0.00,0.00,11.97,1041.39,'2022-08-15 17:20:30','',''),(3809,'1','274','1',1,'Retail Sale Id 3736',1496.48,0.00,0.00,1.99,173.13,'2022-08-15 17:26:40','',''),(3810,'1','274','1',1,'Retail Sale Id 3737',1496.48,0.00,0.00,1.99,173.13,'2022-08-15 17:29:36','',''),(3811,'1','274','1',1,'Retail Sale Id 3738',9400.00,0.00,0.00,12.50,1087.50,'2022-08-15 17:36:10','',''),(3812,'1','274','1',1,'Retail Sale Id 3739',2301.12,0.00,0.00,3.06,266.22,'2022-08-15 18:33:04','',''),(3813,'1','274','1',1,'Retail Sale Id 3740',1549.12,0.00,0.00,2.06,179.22,'2022-08-15 18:34:36','',''),(3814,'1','274','1',1,'Retail Sale Id 3741',1496.48,0.00,0.00,1.99,173.13,'2022-08-15 18:38:20','',''),(3815,'1','274','1',1,'Return of Retail Sale Id 3741',0.00,1496.48,1.99,0.00,-173.13,'2022-08-15 18:38:36','',''),(3816,'1','274','1',1,'Retail Sale Id 3742',2301.12,0.00,0.00,3.06,266.22,'2022-08-15 18:39:15','',''),(3817,'1','274','1',1,'Retail Sale Id 3743',12001.92,0.00,0.00,15.96,1388.52,'2022-08-15 18:41:20','',''),(3818,'1','274','1',1,'Retail Sale Id 3744',9400.00,0.00,0.00,12.50,1087.50,'2022-08-15 19:07:06','',''),(3819,'1','274','1',1,'Retail Sale Id 3745',278758.88,0.00,0.00,370.69,32250.03,'2022-08-15 19:24:09','',''),(3820,'1','274','1',1,'Return of Retail Sale Id 3718',0.00,22560.00,30.00,0.00,-2610.00,'2022-08-15 19:26:51','',''),(3821,'1','274','1',1,'Retail Sale Id 3746',8648.00,0.00,0.00,11.50,1000.50,'2022-08-15 19:28:03','',''),(3822,'1','274','1',1,'Retail Sale Id 3747',4501.20,0.00,0.00,6.05,477.95,'2022-08-16 07:03:23','',''),(3823,'1','274','1',1,'Retail Sale Id 3748',3749.76,0.00,0.00,5.04,398.16,'2022-08-16 08:23:50','',''),(3824,'1','274','1',1,'Retail Sale Id 3749',9672.00,0.00,0.00,13.00,1027.00,'2022-08-16 08:56:30','',''),(3825,'1','274','1',1,'Retail Sale Id 3750',4501.20,0.00,0.00,6.05,477.95,'2022-08-16 09:11:38','',''),(3826,'1','274','1',1,'Retail Sale Id 3751',9300.00,0.00,0.00,12.50,987.50,'2022-08-16 09:48:42','',''),(3827,'1','274','1',1,'Retail Sale Id 3752',4999.68,0.00,0.00,6.72,530.88,'2022-08-16 09:59:05','',''),(3828,'1','274','1',1,'Retail Sale Id 3753',4002.72,0.00,0.00,5.38,425.02,'2022-08-16 09:59:54','',''),(3829,'1','274','1',1,'Retail Sale Id 3754',9999.36,0.00,0.00,13.44,1061.76,'2022-08-16 10:04:14','',''),(3830,'1','274','1',1,'Retail Sale Id 3755',9300.00,0.00,0.00,12.50,987.50,'2022-08-16 10:38:26','',''),(3831,'1','274','1',1,'Retail Sale Id 3756',1502.88,0.00,0.00,2.02,159.58,'2022-08-16 10:42:38','',''),(3832,'1','274','1',1,'Retail Sale Id 3757',2298.96,0.00,0.00,3.09,244.11,'2022-08-16 10:50:04','',''),(3833,'1','274','1',1,'Retail Sale Id 3758',7998.00,0.00,0.00,10.75,849.25,'2022-08-16 11:07:57','',''),(3834,'1','274','1',1,'Retail Sale Id 3759',22320.00,0.00,0.00,30.00,2370.00,'2022-08-16 11:45:59','',''),(3835,'1','274','1',1,'Retail Sale Id 3760',29998.08,0.00,0.00,40.32,3185.28,'2022-08-16 11:49:24','',''),(3836,'1','274','1',1,'Retail Sale Id 3761',9300.00,0.00,0.00,12.50,987.50,'2022-08-16 12:03:16','',''),(3837,'1','274','1',1,'Retail Sale Id 3762',7001.04,0.00,0.00,9.41,743.39,'2022-08-16 12:04:15','',''),(3838,'1','274','1',1,'Retail Sale Id 3763',996.96,0.00,0.00,1.34,105.86,'2022-08-16 12:55:47','',''),(3839,'1','274','1',1,'Retail Sale Id 3764',37200.00,0.00,0.00,50.00,3950.00,'2022-08-16 12:59:54','',''),(3840,'1','274','1',1,'Retail Sale Id 3765',9300.00,0.00,0.00,12.50,987.50,'2022-08-16 13:00:24','',''),(3841,'1','274','1',1,'Retail Sale Id 3766',2001.36,0.00,0.00,2.69,212.51,'2022-08-16 13:11:19','',''),(3842,'1','274','1',1,'Retail Sale Id 3767',7001.04,0.00,0.00,9.41,743.39,'2022-08-16 13:32:39','',''),(3843,'1','274','1',1,'Retail Sale Id 3768',9002.40,0.00,0.00,12.10,955.90,'2022-08-16 13:35:22','',''),(3844,'1','274','1',1,'Retail Sale Id 3769',13801.20,0.00,0.00,18.55,1465.45,'2022-08-16 13:43:29','',''),(3845,'1','274','1',1,'Retail Sale Id 3770',996.96,0.00,0.00,1.34,105.86,'2022-08-16 14:01:59','',''),(3846,'1','274','1',1,'Retail Sale Id 3771',9300.00,0.00,0.00,12.50,987.50,'2022-08-16 14:07:31','',''),(3847,'1','274','1',1,'Retail Sale Id 3772',9300.00,0.00,0.00,12.50,987.50,'2022-08-16 14:28:14','',''),(3848,'1','274','1',1,'Retail Sale Id 3773',14798.16,0.00,0.00,19.89,1571.31,'2022-08-16 15:13:05','',''),(3849,'1','274','1',1,'Retail Sale Id 3774',2998.32,0.00,0.00,4.03,318.37,'2022-08-16 15:14:31','',''),(3850,'1','274','1',1,'Retail Sale Id 3775',26002.80,0.00,0.00,34.95,2761.05,'2022-08-16 15:18:16','',''),(3851,'1','274','1',1,'Retail Sale Id 3776',5208.00,0.00,0.00,7.00,553.00,'2022-08-16 15:25:54','',''),(3852,'1','274','1',1,'Retail Sale Id 3777',5996.64,0.00,0.00,8.06,636.74,'2022-08-16 17:28:50','',''),(3853,'1','274','1',1,'Retail Sale Id 3778',4501.20,0.00,0.00,6.05,477.95,'2022-08-16 18:02:32','',''),(3854,'1','274','1',1,'Retail Sale Id 3779',9300.00,0.00,0.00,12.50,987.50,'2022-08-16 18:03:31','',''),(3855,'1','274','1',1,'Retail Sale Id 3780',9672.00,0.00,0.00,13.00,1027.00,'2022-08-16 18:49:07','',''),(3856,'1','274','1',1,'Retail Sale Id 3781',125222.64,0.00,0.00,168.31,13296.49,'2022-08-16 19:27:41','',''),(3857,'1','274','1',1,'Retail Sale Id 3782',19299.36,0.00,0.00,25.94,2049.26,'2022-08-16 19:28:43','',''),(3858,'1','274','1',1,'Retail Sale Id 3783',9300.00,0.00,0.00,12.50,987.50,'2022-08-17 07:08:00','',''),(3859,'1','274','1',1,'Retail Sale Id 3784',996.96,0.00,0.00,1.34,105.86,'2022-08-17 08:19:07','',''),(3860,'1','274','1',1,'Retail Sale Id 3785',9300.00,0.00,0.00,12.50,987.50,'2022-08-17 08:21:09','',''),(3861,'1','274','1',1,'Retail Sale Id 3786',2499.84,0.00,0.00,3.36,265.44,'2022-08-17 08:32:59','',''),(3862,'1','274','1',1,'Retail Sale Id 3787',4999.68,0.00,0.00,6.72,530.88,'2022-08-17 10:19:21','',''),(3863,'1','274','1',1,'Retail Sale Id 3788',9300.00,0.00,0.00,12.50,987.50,'2022-08-17 10:29:41','',''),(3864,'1','274','1',1,'Retail Sale Id 3789',17997.36,0.00,0.00,24.19,1911.01,'2022-08-17 10:45:01','',''),(3865,'1','274','1',1,'Retail Sale Id 3790',9300.00,0.00,0.00,12.50,987.50,'2022-08-17 10:55:12','',''),(3866,'1','274','1',1,'Retail Sale Id 3791',9300.00,0.00,0.00,12.50,987.50,'2022-08-17 11:09:36','',''),(3867,'1','274','1',1,'Retail Sale Id 3792',9300.00,0.00,0.00,12.50,987.50,'2022-08-17 11:26:48','',''),(3868,'1','274','1',1,'Retail Sale Id 3793',29760.00,0.00,0.00,40.00,3160.00,'2022-08-17 11:31:36','',''),(3869,'1','274','1',1,'Retail Sale Id 3794',1502.88,0.00,0.00,2.02,159.58,'2022-08-17 11:41:18','',''),(3870,'1','274','1',1,'Retail Sale Id 3795',4999.68,0.00,0.00,6.72,530.88,'2022-08-17 11:51:43','',''),(3871,'1','274','1',1,'Retail Sale Id 3796',9300.00,0.00,0.00,12.50,987.50,'2022-08-17 11:56:42','',''),(3872,'1','274','1',1,'Retail Sale Id 3797',3496.80,0.00,0.00,4.70,371.30,'2022-08-17 12:19:02','',''),(3873,'1','274','1',1,'Retail Sale Id 3798',2001.36,0.00,0.00,2.69,212.51,'2022-08-17 12:42:55','',''),(3874,'1','274','1',1,'Retail Sale Id 3799',12997.68,0.00,0.00,17.47,1380.13,'2022-08-17 14:43:25','',''),(3875,'1','274','1',1,'Retail Sale Id 3800',37200.00,0.00,0.00,50.00,3950.00,'2022-08-17 14:58:45','',''),(3876,'1','274','1',1,'Retail Sale Id 3801',4501.20,0.00,0.00,6.05,477.95,'2022-08-17 15:00:16','',''),(3877,'1','274','1',1,'Retail Sale Id 3802',9300.00,0.00,0.00,12.50,987.50,'2022-08-17 15:02:38','',''),(3878,'1','274','1',1,'Retail Sale Id 3803',9300.00,0.00,0.00,12.50,987.50,'2022-08-17 15:03:17','',''),(3879,'1','274','1',1,'Retail Sale Id 3804',18600.00,0.00,0.00,25.00,1975.00,'2022-08-17 15:04:25','',''),(3880,'1','274','1',1,'Retail Sale Id 3805',14880.00,0.00,0.00,20.00,1580.00,'2022-08-17 15:20:04','',''),(3881,'1','274','1',1,'Retail Sale Id 3806',7998.00,0.00,0.00,10.75,849.25,'2022-08-17 15:33:24','',''),(3882,'1','274','1',1,'Retail Sale Id 3808',1502.88,0.00,0.00,2.02,159.58,'2022-08-17 16:26:26','',''),(3883,'1','274','1',1,'Retail Sale Id 3809',3749.76,0.00,0.00,5.04,398.16,'2022-08-17 16:38:05','',''),(3884,'1','274','1',1,'Retail Sale Id 3810',18600.00,0.00,0.00,25.00,1975.00,'2022-08-17 17:25:57','',''),(3885,'1','274','1',1,'Retail Sale Id 3811',4501.20,0.00,0.00,6.05,477.95,'2022-08-17 17:50:33','',''),(3886,'1','274','1',1,'Retail Sale Id 3812',59520.00,0.00,0.00,80.00,6320.00,'2022-08-17 18:15:39','',''),(3887,'1','274','1',1,'Retail Sale Id 3814',3749.76,0.00,0.00,5.04,398.16,'2022-08-17 18:35:19','',''),(3888,'1','274','1',1,'Retail Sale Id 3816',31002.48,0.00,0.00,41.67,3291.93,'2022-08-17 18:38:01','',''),(3889,'1','274','1',1,'Retail Sale Id 3817',9300.00,0.00,0.00,12.50,987.50,'2022-08-17 18:38:41','',''),(3890,'1','274','1',1,'Retail Sale Id 3818',4501.20,0.00,0.00,6.05,477.95,'2022-08-17 18:39:25','',''),(3891,'1','274','1',1,'Retail Sale Id 3819',44104.32,0.00,0.00,59.28,4683.12,'2022-08-17 19:26:29','',''),(3892,'1','274','1',1,'Retail Sale Id 3820',169431.12,0.00,0.00,227.73,17990.67,'2022-08-17 19:27:11','',''),(3893,'1','274','1',1,'Retail Sale Id 3821',14880.00,0.00,0.00,20.00,1580.00,'2022-08-18 07:23:02','',''),(3894,'1','274','1',1,'Retail Sale Id 3822',18600.00,0.00,0.00,25.00,1975.00,'2022-08-18 09:44:06','',''),(3895,'1','274','1',1,'Retail Sale Id 3823',9300.00,0.00,0.00,12.50,987.50,'2022-08-18 09:45:41','',''),(3896,'1','274','1',1,'Retail Sale Id 3824',996.96,0.00,0.00,1.34,105.86,'2022-08-18 10:03:22','',''),(3897,'1','274','1',1,'Retail Sale Id 3825',4999.68,0.00,0.00,6.72,530.88,'2022-08-18 11:30:11','',''),(3898,'1','274','1',1,'Retail Sale Id 3826',2001.36,0.00,0.00,2.69,212.51,'2022-08-18 11:48:46','',''),(3899,'1','274','1',1,'Retail Sale Id 3827',37200.00,0.00,0.00,50.00,3950.00,'2022-08-18 12:19:18','',''),(3900,'1','274','1',1,'Retail Sale Id 3828',1502.88,0.00,0.00,2.02,159.58,'2022-08-18 12:22:23','',''),(3901,'1','274','1',1,'Retail Sale Id 3829',4002.72,0.00,0.00,5.38,425.02,'2022-08-18 12:24:01','',''),(3902,'1','274','1',1,'Retail Sale Id 3830',4501.20,0.00,0.00,6.05,477.95,'2022-08-18 12:29:30','',''),(3903,'1','274','1',1,'Retail Sale Id 3831',9300.00,0.00,0.00,12.50,987.50,'2022-08-18 12:31:19','',''),(3904,'1','274','1',1,'Retail Sale Id 3832',2232.00,0.00,0.00,3.00,237.00,'2022-08-18 12:33:03','',''),(3905,'1','274','1',1,'Retail Sale Id 3833',2232.00,0.00,0.00,3.00,237.00,'2022-08-18 12:42:41','',''),(3906,'1','274','1',1,'Retail Sale Id 3834',9300.00,0.00,0.00,12.50,987.50,'2022-08-18 12:51:27','',''),(3907,'1','274','1',1,'Retail Sale Id 3835',4501.20,0.00,0.00,6.05,477.95,'2022-08-18 13:01:35','',''),(3908,'1','274','1',1,'Retail Sale Id 3836',9300.00,0.00,0.00,12.50,987.50,'2022-08-18 13:06:42','',''),(3909,'1','274','1',1,'Retail Sale Id 3837',9300.00,0.00,0.00,12.50,987.50,'2022-08-18 14:16:29','',''),(3910,'1','274','1',1,'Retail Sale Id 3838',20088.00,0.00,0.00,27.00,2133.00,'2022-08-18 14:21:46','',''),(3911,'1','274','1',1,'Retail Sale Id 3839',1502.88,0.00,0.00,2.02,159.58,'2022-08-18 14:32:50','',''),(3912,'1','274','1',1,'Retail Sale Id 3840',9300.00,0.00,0.00,12.50,987.50,'2022-08-18 14:33:55','',''),(3913,'1','274','1',1,'Retail Sale Id 3841',4501.20,0.00,0.00,6.05,477.95,'2022-08-18 14:42:17','',''),(3914,'1','274','1',1,'Retail Sale Id 3842',12298.32,0.00,0.00,16.53,1305.87,'2022-08-18 15:47:39','',''),(3915,'1','274','1',1,'Retail Sale Id 3843',9300.00,0.00,0.00,12.50,987.50,'2022-08-18 15:48:28','',''),(3916,'1','274','1',1,'Retail Sale Id 3844',219807.36,0.00,0.00,295.44,23339.76,'2022-08-18 19:22:10','',''),(3917,'1','274','1',1,'Retail Sale Id 3845',94473.12,0.00,0.00,126.98,10031.42,'2022-08-18 19:23:56','',''),(3918,'1','274','1',1,'Retail Sale Id 3846',9300.00,0.00,0.00,12.50,987.50,'2022-08-19 06:54:50','',''),(3919,'1','274','1',1,'Retail Sale Id 3847',1502.88,0.00,0.00,2.02,159.58,'2022-08-19 08:57:45','',''),(3920,'1','274','1',1,'Retail Sale Id 3848',4501.20,0.00,0.00,6.05,477.95,'2022-08-19 08:59:05','',''),(3921,'1','274','1',1,'Retail Sale Id 3849',8250.96,0.00,0.00,11.09,876.11,'2022-08-19 09:00:24','',''),(3922,'1','274','1',1,'Retail Sale Id 3850',996.96,0.00,0.00,1.34,105.86,'2022-08-19 09:06:18','',''),(3923,'1','274','1',1,'Retail Sale Id 3851',7797.12,0.00,0.00,10.48,827.92,'2022-08-19 09:18:39','',''),(3924,'1','274','1',1,'Retail Sale Id 3853',996.96,0.00,0.00,1.34,105.86,'2022-08-19 09:44:08','',''),(3925,'1','274','1',1,'Retail Sale Id 3854',2298.96,0.00,0.00,3.09,244.11,'2022-08-19 09:45:40','',''),(3926,'1','274','1',1,'Retail Sale Id 3855',2001.36,0.00,0.00,2.69,212.51,'2022-08-19 09:48:26','',''),(3927,'1','274','1',1,'Retail Sale Id 3856',9300.00,0.00,0.00,12.50,987.50,'2022-08-19 09:50:09','',''),(3928,'1','274','1',1,'Retail Sale Id 3857',18696.72,0.00,0.00,25.13,1985.27,'2022-08-19 10:04:21','',''),(3929,'1','274','1',1,'Return of Retail Sale Id 3857',0.00,18696.72,25.13,0.00,-1985.27,'2022-08-19 10:08:06','',''),(3930,'1','274','1',1,'Retail Sale Id 3858',18696.72,0.00,0.00,25.13,1985.27,'2022-08-19 10:08:51','',''),(3931,'1','274','1',1,'Retail Sale Id 3859',4501.20,0.00,0.00,6.05,477.95,'2022-08-19 10:30:13','',''),(3932,'1','274','1',1,'Retail Sale Id 3860',9002.40,0.00,0.00,12.10,955.90,'2022-08-19 10:43:04','',''),(3933,'1','274','1',1,'Retail Sale Id 3861',2298.96,0.00,0.00,3.09,244.11,'2022-08-19 10:55:55','',''),(3934,'1','274','1',1,'Retail Sale Id 3862',2246.88,0.00,0.00,3.02,238.58,'2022-08-19 11:08:25','',''),(3935,'1','274','1',1,'Retail Sale Id 3863',3749.76,0.00,0.00,5.04,398.16,'2022-08-19 11:13:53','',''),(3936,'1','274','1',1,'Retail Sale Id 3864',2246.88,0.00,0.00,3.02,238.58,'2022-08-19 11:14:45','',''),(3937,'1','274','1',1,'Retail Sale Id 3865',9300.00,0.00,0.00,12.50,987.50,'2022-08-19 11:36:13','',''),(3938,'1','274','1',1,'Retail Sale Id 3866',996.96,0.00,0.00,1.34,105.86,'2022-08-19 11:37:02','',''),(3939,'1','274','1',1,'Retail Sale Id 3867',13503.60,0.00,0.00,18.15,1433.85,'2022-08-19 12:04:25','',''),(3940,'1','274','1',1,'Retail Sale Id 3868',2246.88,0.00,0.00,3.02,238.58,'2022-08-19 12:08:22','',''),(3941,'1','274','1',1,'Retail Sale Id 3869',4501.20,0.00,0.00,6.05,477.95,'2022-08-19 12:20:52','',''),(3942,'1','274','1',1,'Retail Sale Id 3870',9300.00,0.00,0.00,12.50,987.50,'2022-08-19 12:39:21','',''),(3943,'1','274','1',1,'Retail Sale Id 3871',9002.40,0.00,0.00,12.10,955.90,'2022-08-19 12:40:13','',''),(3944,'1','274','1',1,'Retail Sale Id 3872',4002.72,0.00,0.00,5.38,425.02,'2022-08-19 12:42:33','',''),(3945,'1','274','1',1,'Retail Sale Id 3873',13399.44,0.00,0.00,18.01,1422.79,'2022-08-19 12:44:00','',''),(3946,'1','274','1',1,'Return of Retail Sale Id 3873',0.00,13399.44,18.01,0.00,-1422.79,'2022-08-19 12:45:59','',''),(3947,'1','274','1',1,'Retail Sale Id 3874',18696.72,0.00,0.00,25.13,1985.27,'2022-08-19 12:47:09','',''),(3948,'1','274','1',1,'Retail Sale Id 3875',37200.00,0.00,0.00,50.00,3950.00,'2022-08-19 12:55:28','',''),(3949,'1','274','1',1,'Retail Sale Id 3876',2001.36,0.00,0.00,2.69,212.51,'2022-08-19 13:13:07','',''),(3950,'1','274','1',1,'Retail Sale Id 3877',9999.36,0.00,0.00,13.44,1061.76,'2022-08-19 13:51:45','',''),(3951,'1','274','1',1,'Retail Sale Id 3878',24499.92,0.00,0.00,32.93,2601.47,'2022-08-19 13:54:01','',''),(3952,'1','274','1',1,'Retail Sale Id 3879',42601.44,0.00,0.00,57.26,4523.54,'2022-08-19 13:57:07','',''),(3953,'1','274','1',1,'Retail Sale Id 3880',18600.00,0.00,0.00,25.00,1975.00,'2022-08-19 14:14:37','',''),(3954,'1','274','1',1,'Retail Sale Id 3881',4002.72,0.00,0.00,5.38,425.02,'2022-08-19 14:39:28','',''),(3955,'1','274','1',1,'Retail Sale Id 3882',9300.00,0.00,0.00,12.50,987.50,'2022-08-19 14:42:31','',''),(3956,'1','274','1',1,'Retail Sale Id 3883',7998.00,0.00,0.00,10.75,849.25,'2022-08-19 14:46:11','',''),(3957,'1','274','1',1,'Retail Sale Id 3884',2001.36,0.00,0.00,2.69,212.51,'2022-08-19 14:51:21','',''),(3958,'1','274','1',1,'Retail Sale Id 3885',996.96,0.00,0.00,1.34,105.86,'2022-08-19 14:58:13','',''),(3959,'1','274','1',1,'Retail Sale Id 3886',9300.00,0.00,0.00,12.50,987.50,'2022-08-19 14:59:24','',''),(3960,'1','274','1',1,'Retail Sale Id 3887',9300.00,0.00,0.00,12.50,987.50,'2022-08-19 15:01:58','',''),(3961,'1','274','1',1,'Retail Sale Id 3888',2001.36,0.00,0.00,2.69,212.51,'2022-08-19 15:07:16','',''),(3962,'1','274','1',1,'Retail Sale Id 3889',9300.00,0.00,0.00,12.50,987.50,'2022-08-19 15:16:07','',''),(3963,'1','274','1',1,'Retail Sale Id 3890',2998.32,0.00,0.00,4.03,318.37,'2022-08-19 15:19:24','',''),(3964,'1','274','1',1,'Retail Sale Id 3891',10453.20,0.00,0.00,14.05,1109.95,'2022-08-19 15:53:58','',''),(3965,'1','274','1',1,'Retail Sale Id 3892',2700.72,0.00,0.00,3.63,286.77,'2022-08-19 15:56:20','',''),(3966,'1','274','1',1,'Retail Sale Id 3893',9999.36,0.00,0.00,13.44,1061.76,'2022-08-19 16:59:06','',''),(3967,'1','274','1',1,'Retail Sale Id 3894',996.96,0.00,0.00,1.34,105.86,'2022-08-19 17:09:27','',''),(3968,'1','274','1',1,'Retail Sale Id 3895',2001.36,0.00,0.00,2.69,212.51,'2022-08-19 17:10:38','',''),(3969,'1','274','1',1,'Retail Sale Id 3896',4002.72,0.00,0.00,5.38,425.02,'2022-08-19 17:13:17','',''),(3970,'1','274','1',1,'Retail Sale Id 3897',2246.88,0.00,0.00,3.02,238.58,'2022-08-19 17:17:33','',''),(3971,'1','274','1',1,'Retail Sale Id 3898',2499.84,0.00,0.00,3.36,265.44,'2022-08-19 17:22:43','',''),(3972,'1','274','1',1,'Retail Sale Id 3899',5751.12,0.00,0.00,7.73,610.67,'2022-08-19 17:25:46','',''),(3973,'1','274','1',1,'Retail Sale Id 3900',3749.76,0.00,0.00,5.04,398.16,'2022-08-19 17:31:48','',''),(3974,'1','274','1',1,'Retail Sale Id 3901',2001.36,0.00,0.00,2.69,212.51,'2022-08-19 17:36:00','',''),(3975,'1','274','1',1,'Retail Sale Id 3902',7499.52,0.00,0.00,10.08,796.32,'2022-08-19 17:39:17','',''),(3976,'1','274','1',1,'Retail Sale Id 3903',1502.88,0.00,0.00,2.02,159.58,'2022-08-19 17:58:17','',''),(3977,'1','274','1',1,'Retail Sale Id 3904',996.96,0.00,0.00,1.34,105.86,'2022-08-19 17:59:22','',''),(3978,'1','274','1',1,'Retail Sale Id 3905',3749.76,0.00,0.00,5.04,398.16,'2022-08-19 18:01:22','',''),(3979,'1','274','1',1,'Retail Sale Id 3906',2001.36,0.00,0.00,2.69,212.51,'2022-08-19 18:06:22','',''),(3980,'1','274','1',1,'Retail Sale Id 3907',2998.32,0.00,0.00,4.03,318.37,'2022-08-19 18:07:29','',''),(3981,'1','274','1',1,'Retail Sale Id 3908',2998.32,0.00,0.00,4.03,318.37,'2022-08-19 18:08:28','',''),(3982,'1','274','1',1,'Retail Sale Id 3909',4002.72,0.00,0.00,5.38,425.02,'2022-08-19 18:09:49','',''),(3983,'1','274','1',1,'Retail Sale Id 3910',9002.40,0.00,0.00,12.10,955.90,'2022-08-19 18:12:13','',''),(3984,'1','274','1',1,'Retail Sale Id 3911',2797.44,0.00,0.00,3.76,297.04,'2022-08-19 18:27:29','',''),(3985,'1','274','1',1,'Retail Sale Id 3912',9300.00,0.00,0.00,12.50,987.50,'2022-08-19 18:33:17','',''),(3986,'1','274','1',1,'Return of Retail Sale Id 3912',0.00,9300.00,12.50,0.00,-987.50,'2022-08-19 19:32:48','',''),(3987,'1','274','1',1,'Return of Retail Sale Id 3910',0.00,9002.40,12.10,0.00,-955.90,'2022-08-19 19:33:18','',''),(3988,'1','274','1',1,'Return of Retail Sale Id 3905',0.00,3749.76,5.04,0.00,-398.16,'2022-08-19 19:33:54','',''),(3989,'1','274','1',1,'Return of Retail Sale Id 3909',0.00,4002.72,5.38,0.00,-425.02,'2022-08-19 19:34:29','',''),(3990,'1','274','1',1,'Return of Retail Sale Id 3907',0.00,2998.32,4.03,0.00,-318.37,'2022-08-19 19:36:44','',''),(3991,'1','274','1',1,'Return of Retail Sale Id 3908',0.00,2998.32,4.03,0.00,-318.37,'2022-08-19 19:37:13','',''),(3992,'1','274','1',1,'Return of Retail Sale Id 3911',0.00,2797.44,3.76,0.00,-297.04,'2022-08-19 19:38:01','',''),(3993,'1','274','1',1,'Return of Retail Sale Id 3903',0.00,1502.88,2.02,0.00,-159.58,'2022-08-19 19:38:51','',''),(3994,'1','274','1',1,'Return of Retail Sale Id 3904',0.00,996.96,1.34,0.00,-105.86,'2022-08-19 19:39:37','',''),(3995,'1','274','1',1,'Retail Sale Id 3913',915.12,0.00,0.00,1.23,97.17,'2022-08-19 19:40:47','',''),(3996,'1','274','1',1,'Retail Sale Id 3914',90299.28,0.00,0.00,121.37,9588.23,'2022-08-19 19:42:18','',''),(3997,'1','274','1',1,'Retail Sale Id 3915',18600.00,0.00,0.00,25.00,1975.00,'2022-08-20 07:30:17','',''),(3998,'1','274','1',1,'Retail Sale Id 3916',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 07:31:21','',''),(3999,'1','274','1',1,'Retail Sale Id 3917',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 09:22:55','',''),(4000,'1','274','1',1,'Retail Sale Id 3918',9672.00,0.00,0.00,13.00,1027.00,'2022-08-20 09:23:29','',''),(4001,'1','274','1',1,'Retail Sale Id 3919',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 09:33:44','',''),(4002,'1','274','1',1,'Retail Sale Id 3920',27996.72,0.00,0.00,37.63,2972.77,'2022-08-20 09:34:35','',''),(4003,'1','274','1',1,'Retail Sale Id 3921',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 09:35:39','',''),(4004,'1','274','1',1,'Retail Sale Id 3922',22320.00,0.00,0.00,30.00,2370.00,'2022-08-20 09:38:40','',''),(4005,'1','274','1',1,'Retail Sale Id 3923',2246.88,0.00,0.00,3.02,238.58,'2022-08-20 09:46:02','',''),(4006,'1','274','1',1,'Retail Sale Id 3924',3749.76,0.00,0.00,5.04,398.16,'2022-08-20 09:49:57','',''),(4007,'1','274','1',1,'Retail Sale Id 3925',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 09:55:18','',''),(4008,'1','274','1',1,'Retail Sale Id 3926',37200.00,0.00,0.00,50.00,3950.00,'2022-08-20 11:27:02','',''),(4009,'1','274','1',1,'Retail Sale Id 3927',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 11:32:08','',''),(4010,'1','274','1',1,'Retail Sale Id 3928',4501.20,0.00,0.00,6.05,477.95,'2022-08-20 11:33:38','',''),(4011,'1','274','1',1,'Retail Sale Id 3929',2998.32,0.00,0.00,4.03,318.37,'2022-08-20 11:43:07','',''),(4012,'1','274','1',1,'Retail Sale Id 3930',18600.00,0.00,0.00,25.00,1975.00,'2022-08-20 11:49:24','',''),(4013,'1','274','1',1,'Retail Sale Id 3931',996.96,0.00,0.00,1.34,105.86,'2022-08-20 11:51:35','',''),(4014,'1','274','1',1,'Retail Sale Id 3932',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 11:55:55','',''),(4015,'1','274','1',1,'Retail Sale Id 3933',3496.80,0.00,0.00,4.70,371.30,'2022-08-20 11:58:11','',''),(4016,'1','274','1',1,'Retail Sale Id 3934',2298.96,0.00,0.00,3.09,244.11,'2022-08-20 12:03:14','',''),(4017,'1','274','1',1,'Retail Sale Id 3935',11532.00,0.00,0.00,15.50,1224.50,'2022-08-20 12:05:26','',''),(4018,'1','274','1',1,'Retail Sale Id 3936',2998.32,0.00,0.00,4.03,318.37,'2022-08-20 12:06:58','',''),(4019,'1','274','1',1,'Retail Sale Id 3937',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 12:08:51','',''),(4020,'1','274','1',1,'Retail Sale Id 3938',75002.64,0.00,0.00,100.81,7963.99,'2022-08-20 12:11:49','',''),(4021,'1','274','1',1,'Retail Sale Id 3939',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 12:18:12','',''),(4022,'1','274','1',1,'Retail Sale Id 3940',29998.08,0.00,0.00,40.32,3185.28,'2022-08-20 12:29:58','',''),(4023,'1','274','1',1,'Retail Sale Id 3941',2232.00,0.00,0.00,3.00,237.00,'2022-08-20 12:32:03','',''),(4024,'1','274','1',1,'Retail Sale Id 3942',2232.00,0.00,0.00,3.00,237.00,'2022-08-20 12:35:23','',''),(4025,'1','274','1',1,'Retail Sale Id 3943',18600.00,0.00,0.00,25.00,1975.00,'2022-08-20 12:49:35','',''),(4026,'1','274','1',1,'Retail Sale Id 3944',2232.00,0.00,0.00,3.00,237.00,'2022-08-20 12:55:15','',''),(4027,'1','274','1',1,'Retail Sale Id 3945',9672.00,0.00,0.00,13.00,1027.00,'2022-08-20 12:57:20','',''),(4028,'1','274','1',1,'Retail Sale Id 3946',4464.00,0.00,0.00,6.00,474.00,'2022-08-20 12:58:46','',''),(4029,'1','274','1',1,'Retail Sale Id 3947',4464.00,0.00,0.00,6.00,474.00,'2022-08-20 13:04:17','',''),(4030,'1','274','1',1,'Retail Sale Id 3948',7440.00,0.00,0.00,10.00,790.00,'2022-08-20 13:10:02','',''),(4031,'1','274','1',1,'Retail Sale Id 3949',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 13:13:26','',''),(4032,'1','274','1',1,'Retail Sale Id 3950',2499.84,0.00,0.00,3.36,265.44,'2022-08-20 13:23:47','',''),(4033,'1','274','1',1,'Retail Sale Id 3952',996.96,0.00,0.00,1.34,105.86,'2022-08-20 13:28:25','',''),(4034,'1','274','1',1,'Retail Sale Id 3953',803.52,0.00,0.00,1.08,85.32,'2022-08-20 13:39:21','',''),(4035,'1','274','1',1,'Retail Sale Id 3954',37200.00,0.00,0.00,50.00,3950.00,'2022-08-20 13:52:44','',''),(4036,'1','274','1',1,'Retail Sale Id 3955',2499.84,0.00,0.00,3.36,265.44,'2022-08-20 13:54:36','',''),(4037,'1','274','1',1,'Retail Sale Id 3956',2298.96,0.00,0.00,3.09,244.11,'2022-08-20 14:06:17','',''),(4038,'1','274','1',1,'Retail Sale Id 3957',2001.36,0.00,0.00,2.69,212.51,'2022-08-20 14:10:30','',''),(4039,'1','274','1',1,'Retail Sale Id 3958',1502.88,0.00,0.00,2.02,159.58,'2022-08-20 14:18:08','',''),(4040,'1','274','1',1,'Retail Sale Id 3959',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 14:28:44','',''),(4041,'1','274','1',1,'Retail Sale Id 3960',2232.00,0.00,0.00,3.00,237.00,'2022-08-20 14:32:50','',''),(4042,'1','274','1',1,'Retail Sale Id 3961',4999.68,0.00,0.00,6.72,530.88,'2022-08-20 14:33:41','',''),(4043,'1','274','1',1,'Retail Sale Id 3962',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 14:34:36','',''),(4044,'1','274','1',1,'Retail Sale Id 3963',3720.00,0.00,0.00,5.00,395.00,'2022-08-20 14:36:41','',''),(4045,'1','274','1',1,'Retail Sale Id 3964',2232.00,0.00,0.00,3.00,237.00,'2022-08-20 14:44:31','',''),(4046,'1','274','1',1,'Retail Sale Id 3965',11904.00,0.00,0.00,16.00,1264.00,'2022-08-20 14:51:01','',''),(4047,'1','274','1',1,'Retail Sale Id 3966',45384.00,0.00,0.00,61.00,4819.00,'2022-08-20 15:08:48','',''),(4048,'1','274','1',1,'Retail Sale Id 3967',1502.88,0.00,0.00,2.02,159.58,'2022-08-20 15:14:17','',''),(4049,'1','274','1',1,'Retail Sale Id 3968',4501.20,0.00,0.00,6.05,477.95,'2022-08-20 15:20:33','',''),(4050,'1','274','1',1,'Retail Sale Id 3969',2001.36,0.00,0.00,2.69,212.51,'2022-08-20 17:07:15','',''),(4051,'1','274','1',1,'Retail Sale Id 3970',996.96,0.00,0.00,1.34,105.86,'2022-08-20 17:11:33','',''),(4052,'1','274','1',1,'Retail Sale Id 3971',14880.00,0.00,0.00,20.00,1580.00,'2022-08-20 17:18:32','',''),(4053,'1','274','1',1,'Retail Sale Id 3972',1502.88,0.00,0.00,2.02,159.58,'2022-08-20 17:30:17','',''),(4054,'1','274','1',1,'Retail Sale Id 3973',1502.88,0.00,0.00,2.02,159.58,'2022-08-20 17:31:31','',''),(4055,'1','274','1',1,'Retail Sale Id 3974',4501.20,0.00,0.00,6.05,477.95,'2022-08-20 17:33:10','',''),(4056,'1','274','1',1,'Retail Sale Id 3975',2001.36,0.00,0.00,2.69,212.51,'2022-08-20 17:34:49','',''),(4057,'1','274','1',1,'Retail Sale Id 3976',18600.00,0.00,0.00,25.00,1975.00,'2022-08-20 17:42:23','',''),(4058,'1','274','1',1,'Retail Sale Id 3977',996.96,0.00,0.00,1.34,105.86,'2022-08-20 17:44:08','',''),(4059,'1','274','1',1,'Retail Sale Id 3978',2246.88,0.00,0.00,3.02,238.58,'2022-08-20 17:51:14','',''),(4060,'1','274','1',1,'Retail Sale Id 3979',7440.00,0.00,0.00,10.00,790.00,'2022-08-20 17:57:27','',''),(4061,'1','274','1',1,'Retail Sale Id 3980',4002.72,0.00,0.00,5.38,425.02,'2022-08-20 18:01:13','',''),(4062,'1','274','1',1,'Retail Sale Id 3981',3749.76,0.00,0.00,5.04,398.16,'2022-08-20 18:02:57','',''),(4063,'1','274','1',1,'Retail Sale Id 3982',2246.88,0.00,0.00,3.02,238.58,'2022-08-20 18:04:19','',''),(4064,'1','274','1',1,'Retail Sale Id 3983',996.96,0.00,0.00,1.34,105.86,'2022-08-20 18:09:27','',''),(4065,'1','274','1',1,'Retail Sale Id 3984',4002.72,0.00,0.00,5.38,425.02,'2022-08-20 18:10:46','',''),(4066,'1','274','1',1,'Retail Sale Id 3985',2998.32,0.00,0.00,4.03,318.37,'2022-08-20 18:11:36','',''),(4067,'1','274','1',1,'Retail Sale Id 3986',2998.32,0.00,0.00,4.03,318.37,'2022-08-20 18:13:57','',''),(4068,'1','274','1',1,'Retail Sale Id 3987',53940.00,0.00,0.00,72.50,5727.50,'2022-08-20 18:17:26','',''),(4069,'1','274','1',1,'Retail Sale Id 3988',9300.00,0.00,0.00,12.50,987.50,'2022-08-20 18:52:12','',''),(4070,'1','274','1',1,'Retail Sale Id 3989',46559.52,0.00,0.00,62.58,4943.82,'2022-08-20 19:21:35','',''),(4071,'1','274','1',1,'Retail Sale Id 3990',96429.84,0.00,0.00,129.61,10239.19,'2022-08-20 19:23:24','',''),(4072,'1','274','1',1,'Retail Sale Id 3991',9300.00,0.00,0.00,12.50,987.50,'2022-08-21 07:17:50','',''),(4073,'1','274','1',1,'Retail Sale Id 3992',9300.00,0.00,0.00,12.50,987.50,'2022-08-21 07:29:29','',''),(4074,'1','274','1',1,'Retail Sale Id 3993',3720.00,0.00,0.00,5.00,395.00,'2022-08-21 07:52:41','',''),(4075,'1','274','1',1,'Retail Sale Id 3994',9300.00,0.00,0.00,12.50,987.50,'2022-08-21 08:56:08','',''),(4076,'1','274','1',1,'Retail Sale Id 3995',4501.20,0.00,0.00,6.05,477.95,'2022-08-21 09:44:42','',''),(4077,'1','274','1',1,'Retail Sale Id 3996',74400.00,0.00,0.00,100.00,7900.00,'2022-08-21 10:02:18','',''),(4078,'1','274','1',1,'Retail Sale Id 3997',2246.88,0.00,0.00,3.02,238.58,'2022-08-21 10:28:17','',''),(4079,'1','274','1',1,'Retail Sale Id 3998',1398.72,0.00,0.00,1.88,148.52,'2022-08-21 10:34:09','',''),(4080,'1','274','1',1,'Retail Sale Id 3999',4999.68,0.00,0.00,6.72,530.88,'2022-08-21 11:25:04','',''),(4081,'1','274','1',1,'Retail Sale Id 4000',36999.12,0.00,0.00,49.73,3928.67,'2022-08-21 11:29:59','',''),(4082,'1','274','1',1,'Retail Sale Id 4001',9300.00,0.00,0.00,12.50,987.50,'2022-08-21 11:31:36','',''),(4083,'1','274','1',1,'Retail Sale Id 4002',9300.00,0.00,0.00,12.50,987.50,'2022-08-21 11:34:37','',''),(4084,'1','274','1',1,'Retail Sale Id 4003',9300.00,0.00,0.00,12.50,987.50,'2022-08-21 11:44:51','',''),(4085,'1','274','1',1,'Retail Sale Id 4004',9300.00,0.00,0.00,12.50,987.50,'2022-08-21 12:07:14','',''),(4086,'1','274','1',1,'Retail Sale Id 4005',2001.36,0.00,0.00,2.69,212.51,'2022-08-21 12:24:19','',''),(4087,'1','274','1',1,'Retail Sale Id 4006',55800.00,0.00,0.00,75.00,5925.00,'2022-08-21 12:34:18','',''),(4088,'1','274','1',1,'Retail Sale Id 4007',2246.88,0.00,0.00,3.02,238.58,'2022-08-21 12:39:50','',''),(4089,'1','274','1',1,'Retail Sale Id 4008',996.96,0.00,0.00,1.34,105.86,'2022-08-21 12:40:58','',''),(4090,'1','274','1',1,'Retail Sale Id 4009',2001.36,0.00,0.00,2.69,212.51,'2022-08-21 12:46:16','',''),(4091,'1','274','1',1,'Retail Sale Id 4010',4999.68,0.00,0.00,6.72,530.88,'2022-08-21 13:40:47','',''),(4092,'1','274','1',1,'Retail Sale Id 4011',27900.00,0.00,0.00,37.50,2962.50,'2022-08-21 13:49:28','',''),(4093,'1','274','1',1,'Retail Sale Id 4012',9300.00,0.00,0.00,12.50,987.50,'2022-08-21 13:50:33','',''),(4094,'1','274','1',1,'Retail Sale Id 4013',37200.00,0.00,0.00,50.00,3950.00,'2022-08-21 14:00:22','',''),(4095,'1','274','1',1,'Retail Sale Id 4014',13801.20,0.00,0.00,18.55,1465.45,'2022-08-21 14:12:59','',''),(4096,'1','274','1',1,'Retail Sale Id 4015',2246.88,0.00,0.00,3.02,238.58,'2022-08-21 14:20:28','',''),(4097,'1','274','1',1,'Retail Sale Id 4016',2998.32,0.00,0.00,4.03,318.37,'2022-08-21 14:29:54','',''),(4098,'1','274','1',1,'Retail Sale Id 4017',11546.88,0.00,0.00,15.52,1226.08,'2022-08-21 14:37:29','',''),(4099,'1','274','1',1,'Retail Sale Id 4018',2998.32,0.00,0.00,4.03,318.37,'2022-08-21 14:43:28','',''),(4100,'1','274','1',1,'Retail Sale Id 4019',4999.68,0.00,0.00,6.72,530.88,'2022-08-21 14:46:48','',''),(4101,'1','274','1',1,'Retail Sale Id 4020',3749.76,0.00,0.00,5.04,398.16,'2022-08-21 14:52:38','',''),(4102,'1','274','1',1,'Retail Sale Id 4021',2001.36,0.00,0.00,2.69,212.51,'2022-08-21 15:01:57','',''),(4103,'1','274','1',1,'Retail Sale Id 4022',9999.36,0.00,0.00,13.44,1061.76,'2022-08-21 15:03:07','',''),(4104,'1','274','1',1,'Retail Sale Id 4023',2246.88,0.00,0.00,3.02,238.58,'2022-08-21 15:09:57','',''),(4105,'1','274','1',1,'Retail Sale Id 4024',9300.00,0.00,0.00,12.50,987.50,'2022-08-21 15:21:36','',''),(4106,'1','274','1',1,'Retail Sale Id 4025',3749.76,0.00,0.00,5.04,398.16,'2022-08-21 15:30:41','',''),(4107,'1','274','1',1,'Retail Sale Id 4026',2998.32,0.00,0.00,4.03,318.37,'2022-08-21 15:31:46','',''),(4108,'1','274','1',1,'Retail Sale Id 4027',2246.88,0.00,0.00,3.02,238.58,'2022-08-21 15:42:04','',''),(4109,'1','274','1',1,'Retail Sale Id 4028',996.96,0.00,0.00,1.34,105.86,'2022-08-21 15:42:52','',''),(4110,'1','274','1',1,'Retail Sale Id 4029',2246.88,0.00,0.00,3.02,238.58,'2022-08-21 15:48:32','',''),(4111,'1','274','1',1,'Retail Sale Id 4030',22349.76,0.00,0.00,30.04,2373.16,'2022-08-21 15:57:05','',''),(4112,'1','274','1',1,'Retail Sale Id 4031',996.96,0.00,0.00,1.34,105.86,'2022-08-21 16:01:36','',''),(4113,'1','274','1',1,'Retail Sale Id 4032',2492.40,0.00,0.00,3.35,264.65,'2022-08-21 16:46:25','',''),(4114,'1','274','1',1,'Return of Retail Sale Id 4024',0.00,9300.00,12.50,0.00,-987.50,'2022-08-21 16:48:09','',''),(4115,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,66759.35,100.39,0.00,0.00,'2022-08-21 16:52:39','',''),(4116,'1','274',NULL,1,'Reception corrector for bridging 37',0.00,0.00,0.00,100.39,0.00,'2022-08-21 16:53:54','',''),(4117,'1','274','1',1,'Received from bridging 37',0.00,0.00,100.39,0.00,0.00,'2022-08-21 16:53:54','',''),(4118,'1','274','1',1,'Return of Retail Sale Id 4006',0.00,55800.00,75.00,0.00,-5925.00,'2022-08-21 17:01:35','',''),(4119,'1','274','1',1,'Retail Sale Id 4033',111272.64,0.00,0.00,149.56,11815.24,'2022-08-21 17:02:26','',''),(4120,'1','274','1',1,'Retail Sale Id 4034',50815.20,0.00,0.00,68.30,5395.70,'2022-08-21 17:03:33','',''),(4121,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,665000.00,1000.00,0.00,0.00,'2022-08-21 17:21:23','',''),(4122,'1','274',NULL,1,'Reception corrector for bridging 38',0.00,0.00,0.00,1000.00,0.00,'2022-08-21 17:22:13','',''),(4123,'1','274','1',1,'Received from bridging 38',0.00,0.00,1000.00,0.00,0.00,'2022-08-21 17:22:13','',''),(4124,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,2094750.00,3150.00,0.00,0.00,'2022-08-21 19:35:05','',''),(4125,'1','274',NULL,1,'Reception corrector for bridging 39',0.00,0.00,0.00,3150.00,0.00,'2022-08-21 19:36:12','',''),(4126,'1','274','1',1,'Received from bridging 39',0.00,0.00,3150.00,0.00,0.00,'2022-08-21 19:36:12','',''),(4127,'1','274','1',1,'Retail Sale Id 4035',37200.00,0.00,0.00,50.00,3950.00,'2022-08-22 07:23:23','',''),(4128,'1','274','1',1,'Retail Sale Id 4036',3749.76,0.00,0.00,5.04,398.16,'2022-08-22 09:22:23','',''),(4129,'1','274','1',1,'Retail Sale Id 4037',4999.68,0.00,0.00,6.72,530.88,'2022-08-22 09:23:41','',''),(4130,'1','274','1',1,'Retail Sale Id 4038',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 09:54:52','',''),(4131,'1','274','1',1,'Retail Sale Id 4039',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 10:35:17','',''),(4132,'1','274','1',1,'Retail Sale Id 4040',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 11:00:22','',''),(4133,'1','274','1',1,'Retail Sale Id 4041',4650.00,0.00,0.00,6.25,493.75,'2022-08-22 11:05:05','',''),(4134,'1','274','1',1,'Retail Sale Id 4042',2998.32,0.00,0.00,4.03,318.37,'2022-08-22 11:22:39','',''),(4135,'1','274','1',1,'Retail Sale Id 4043',996.96,0.00,0.00,1.34,105.86,'2022-08-22 11:23:18','',''),(4136,'1','274','1',1,'Retail Sale Id 4044',1502.88,0.00,0.00,2.02,159.58,'2022-08-22 11:24:01','',''),(4137,'1','274','1',1,'Retail Sale Id 4045',4999.68,0.00,0.00,6.72,530.88,'2022-08-22 11:26:09','',''),(4138,'1','274','1',1,'Retail Sale Id 4046',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 11:27:30','',''),(4139,'1','274','1',1,'Retail Sale Id 4047',7998.00,0.00,0.00,10.75,849.25,'2022-08-22 13:19:05','',''),(4140,'1','274','1',1,'Retail Sale Id 4048',4002.72,0.00,0.00,5.38,425.02,'2022-08-22 13:21:14','',''),(4141,'1','274','1',1,'Retail Sale Id 4049',9999.36,0.00,0.00,13.44,1061.76,'2022-08-22 13:31:15','',''),(4142,'1','274','1',1,'Retail Sale Id 4050',6138.00,0.00,0.00,8.25,651.75,'2022-08-22 13:51:54','',''),(4143,'1','274','1',1,'Retail Sale Id 4051',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 13:56:47','',''),(4144,'1','274','1',1,'Retail Sale Id 4052',13801.20,0.00,0.00,18.55,1465.45,'2022-08-22 14:02:44','',''),(4145,'1','274','1',1,'Retail Sale Id 4053',2246.88,0.00,0.00,3.02,238.58,'2022-08-22 14:07:55','',''),(4146,'1','274','1',1,'Retail Sale Id 4054',996.96,0.00,0.00,1.34,105.86,'2022-08-22 14:10:51','',''),(4147,'1','274','1',1,'Retail Sale Id 4055',2246.88,0.00,0.00,3.02,238.58,'2022-08-22 14:26:48','',''),(4148,'1','274','1',1,'Retail Sale Id 4056',2998.32,0.00,0.00,4.03,318.37,'2022-08-22 14:31:21','',''),(4149,'1','274','1',1,'Retail Sale Id 4057',2499.84,0.00,0.00,3.36,265.44,'2022-08-22 14:33:42','',''),(4150,'1','274','1',1,'Retail Sale Id 4058',2001.36,0.00,0.00,2.69,212.51,'2022-08-22 14:34:33','',''),(4151,'1','274','1',1,'Retail Sale Id 4059',2246.88,0.00,0.00,3.02,238.58,'2022-08-22 14:35:17','',''),(4152,'1','274','1',1,'Retail Sale Id 4060',3749.76,0.00,0.00,5.04,398.16,'2022-08-22 14:38:03','',''),(4153,'1','274','1',1,'Retail Sale Id 4061',1800.48,0.00,0.00,2.42,191.18,'2022-08-22 14:43:18','',''),(4154,'1','274','1',1,'Retail Sale Id 4062',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 14:55:22','',''),(4155,'1','274','1',1,'Retail Sale Id 4063',7998.00,0.00,0.00,10.75,849.25,'2022-08-22 15:06:54','',''),(4156,'1','274','1',1,'Retail Sale Id 4064',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 15:27:52','',''),(4157,'1','274','1',1,'Retail Sale Id 4065',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 15:30:33','',''),(4158,'1','274','1',1,'Retail Sale Id 4066',2499.84,0.00,0.00,3.36,265.44,'2022-08-22 16:25:43','',''),(4159,'1','274','1',1,'Retail Sale Id 4067',996.96,0.00,0.00,1.34,105.86,'2022-08-22 16:45:55','',''),(4160,'1','274','1',1,'Retail Sale Id 4068',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 16:50:10','',''),(4161,'1','274','1',1,'Retail Sale Id 4069',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 17:08:36','',''),(4162,'1','274','1',1,'Retail Sale Id 4070',4501.20,0.00,0.00,6.05,477.95,'2022-08-22 17:18:04','',''),(4163,'1','274','1',1,'Retail Sale Id 4071',2246.88,0.00,0.00,3.02,238.58,'2022-08-22 17:27:06','',''),(4164,'1','274','1',1,'Retail Sale Id 4072',9300.00,0.00,0.00,12.50,987.50,'2022-08-22 17:52:30','',''),(4165,'1','274','1',1,'Retail Sale Id 4073',4501.20,0.00,0.00,6.05,477.95,'2022-08-22 17:53:46','',''),(4166,'1','274','1',1,'Retail Sale Id 4074',7447.44,0.00,0.00,10.01,790.79,'2022-08-22 17:55:32','',''),(4167,'1','274','1',1,'Retail Sale Id 4075',9500.88,0.00,0.00,12.77,1008.83,'2022-08-22 17:57:55','',''),(4168,'1','274','1',1,'Retail Sale Id 4076',3749.76,0.00,0.00,5.04,398.16,'2022-08-22 18:01:45','',''),(4169,'1','274','1',1,'Retail Sale Id 4077',1502.88,0.00,0.00,2.02,159.58,'2022-08-22 18:28:58','',''),(4170,'1','274','1',1,'Retail Sale Id 4078',9701.76,0.00,0.00,13.04,1030.16,'2022-08-22 18:29:54','',''),(4171,'1','274','1',1,'Retail Sale Id 4079',94874.88,0.00,0.00,127.52,10074.08,'2022-08-22 19:32:48','',''),(4172,'1','274','1',1,'Retail Sale Id 4080',233050.56,0.00,0.00,313.24,24745.96,'2022-08-22 19:35:08','',''),(4173,'1','274','1',1,'Return of Retail Sale Id 4080',0.00,233050.56,313.24,0.00,-24745.96,'2022-08-22 20:25:32','',''),(4174,'1','274','1',1,'Retail Sale Id 4081',59043.84,0.00,0.00,79.36,6269.44,'2022-08-22 20:26:51','',''),(4175,'1','274','1',1,'Retail Sale Id 4082',9300.00,0.00,0.00,12.50,987.50,'2022-08-23 06:51:02','',''),(4176,'1','274','1',1,'Retail Sale Id 4083',1502.88,0.00,0.00,2.02,159.58,'2022-08-23 08:20:59','',''),(4177,'1','274','1',1,'Retail Sale Id 4084',9300.00,0.00,0.00,12.50,987.50,'2022-08-23 08:21:52','',''),(4178,'1','274','1',1,'Retail Sale Id 4085',4002.72,0.00,0.00,5.38,425.02,'2022-08-23 08:34:03','',''),(4179,'1','274','1',1,'Retail Sale Id 4086',18600.00,0.00,0.00,25.00,1975.00,'2022-08-23 08:57:29','',''),(4180,'1','274','1',1,'Retail Sale Id 4087',9300.00,0.00,0.00,12.50,987.50,'2022-08-23 08:59:36','',''),(4181,'1','274','1',1,'Retail Sale Id 4088',9300.00,0.00,0.00,12.50,987.50,'2022-08-23 09:01:38','',''),(4182,'1','274','1',1,'Retail Sale Id 4089',2001.36,0.00,0.00,2.69,212.51,'2022-08-23 09:03:14','',''),(4183,'1','274','1',1,'Retail Sale Id 4090',1800.48,0.00,0.00,2.42,191.18,'2022-08-23 09:35:34','',''),(4184,'1','274','1',1,'Retail Sale Id 4091',7001.04,0.00,0.00,9.41,743.39,'2022-08-23 10:05:03','',''),(4185,'1','274','1',1,'Retail Sale Id 4092',9300.00,0.00,0.00,12.50,987.50,'2022-08-23 10:47:36','',''),(4186,'1','274','1',1,'Retail Sale Id 4093',74400.00,0.00,0.00,100.00,7900.00,'2022-08-23 11:12:51','',''),(4187,'1','274','1',1,'Retail Sale Id 4094',4501.20,0.00,0.00,6.05,477.95,'2022-08-23 11:19:13','',''),(4188,'1','274','1',1,'Retail Sale Id 4095',74400.00,0.00,0.00,100.00,7900.00,'2022-08-23 12:07:09','',''),(4189,'1','274','1',1,'Retail Sale Id 4096',111600.00,0.00,0.00,150.00,11850.00,'2022-08-23 12:08:12','',''),(4190,'1','274','1',1,'Return of Retail Sale Id 4095',0.00,74400.00,100.00,0.00,-7900.00,'2022-08-23 12:08:50','',''),(4191,'1','274','1',1,'Retail Sale Id 4097',59520.00,0.00,0.00,80.00,6320.00,'2022-08-23 12:09:37','',''),(4192,'1','274','1',1,'Retail Sale Id 4098',9002.40,0.00,0.00,12.10,955.90,'2022-08-23 14:07:03','',''),(4193,'1','274','1',1,'Retail Sale Id 4099',9300.00,0.00,0.00,12.50,987.50,'2022-08-23 14:07:41','',''),(4194,'1','274','1',1,'Retail Sale Id 4100',9300.00,0.00,0.00,12.50,987.50,'2022-08-23 14:10:48','',''),(4195,'1','274','1',1,'Retail Sale Id 4101',34997.76,0.00,0.00,47.04,3716.16,'2022-08-23 14:14:23','',''),(4196,'1','274','1',1,'Retail Sale Id 4102',8496.48,0.00,0.00,11.42,902.18,'2022-08-23 14:40:18','',''),(4197,'1','274','1',1,'Retail Sale Id 4104',8184.00,0.00,0.00,11.00,869.00,'2022-08-23 15:30:05','',''),(4198,'1','274','1',1,'Retail Sale Id 4106',2001.36,0.00,0.00,2.69,212.51,'2022-08-23 16:00:22','',''),(4199,'1','274','1',1,'Retail Sale Id 4107',9300.00,0.00,0.00,12.50,987.50,'2022-08-23 16:05:27','',''),(4200,'1','274','1',1,'Retail Sale Id 4108',2499.84,0.00,0.00,3.36,265.44,'2022-08-23 16:21:25','',''),(4201,'1','274','1',1,'Retail Sale Id 4109',9300.00,0.00,0.00,12.50,987.50,'2022-08-23 16:46:26','',''),(4202,'1','274','1',1,'Retail Sale Id 4110',4501.20,0.00,0.00,6.05,477.95,'2022-08-23 17:07:41','',''),(4203,'1','274','1',1,'Retail Sale Id 4111',9300.00,0.00,0.00,12.50,987.50,'2022-08-23 17:08:59','',''),(4204,'1','274','1',1,'Retail Sale Id 4112',9300.00,0.00,0.00,12.50,987.50,'2022-08-23 17:09:56','',''),(4205,'1','274','1',1,'Retail Sale Id 4113',1897.20,0.00,0.00,2.55,201.45,'2022-08-23 17:11:11','',''),(4206,'1','274','1',1,'Retail Sale Id 4114',498.48,0.00,0.00,0.67,52.93,'2022-08-23 17:11:50','',''),(4207,'1','274','1',1,'Retail Sale Id 4115',2298.96,0.00,0.00,3.09,244.11,'2022-08-23 17:14:52','',''),(4208,'1','274','1',1,'Retail Sale Id 4116',3720.00,0.00,0.00,5.00,395.00,'2022-08-23 17:17:21','',''),(4209,'1','274','1',1,'Retail Sale Id 4117',2001.36,0.00,0.00,2.69,212.51,'2022-08-23 17:24:33','',''),(4210,'1','274','1',1,'Retail Sale Id 4118',3720.00,0.00,0.00,5.00,395.00,'2022-08-23 17:25:27','',''),(4211,'1','274','1',1,'Retail Sale Id 4119',996.96,0.00,0.00,1.34,105.86,'2022-08-23 17:35:48','',''),(4212,'1','274','1',1,'Retail Sale Id 4120',2001.36,0.00,0.00,2.69,212.51,'2022-08-23 17:36:54','',''),(4213,'1','274','1',1,'Retail Sale Id 4121',4501.20,0.00,0.00,6.05,477.95,'2022-08-23 17:43:10','',''),(4214,'1','274','1',1,'Retail Sale Id 4122',4501.20,0.00,0.00,6.05,477.95,'2022-08-23 17:45:11','',''),(4215,'1','274','1',1,'Retail Sale Id 4123',5498.16,0.00,0.00,7.39,583.81,'2022-08-23 17:46:06','',''),(4216,'1','274','1',1,'Retail Sale Id 4124',7001.04,0.00,0.00,9.41,743.39,'2022-08-23 17:47:24','',''),(4217,'1','274','1',1,'Retail Sale Id 4125',996.96,0.00,0.00,1.34,105.86,'2022-08-23 18:30:25','',''),(4218,'1','274','1',1,'Retail Sale Id 4126',1502.88,0.00,0.00,2.02,159.58,'2022-08-23 18:33:48','',''),(4219,'1','274','1',1,'Retail Sale Id 4127',10497.84,0.00,0.00,14.11,1114.69,'2022-08-23 18:36:27','',''),(4220,'1','274','1',1,'Retail Sale Id 4128',40428.96,0.00,0.00,54.34,4292.86,'2022-08-23 19:31:45','',''),(4221,'1','274','1',1,'Retail Sale Id 4129',26456.64,0.00,0.00,35.56,2809.24,'2022-08-23 19:33:18','',''),(4222,'1','274','1',1,'Retail Sale Id 4130',9300.00,0.00,0.00,12.50,987.50,'2022-08-24 07:23:15','',''),(4223,'1','274','1',1,'Retail Sale Id 4131',37200.00,0.00,0.00,50.00,3950.00,'2022-08-24 08:41:47','',''),(4224,'1','274','1',1,'Retail Sale Id 4132',7440.00,0.00,0.00,10.00,790.00,'2022-08-24 08:54:02','',''),(4225,'1','274','1',1,'Retail Sale Id 4133',17856.00,0.00,0.00,24.00,1896.00,'2022-08-24 09:30:04','',''),(4226,'1','274','1',1,'Retail Sale Id 4134',9672.00,0.00,0.00,13.00,1027.00,'2022-08-24 09:31:12','',''),(4227,'1','274','1',1,'Retail Sale Id 4135',9300.00,0.00,0.00,12.50,987.50,'2022-08-24 10:28:33','',''),(4228,'1','274','1',1,'Retail Sale Id 4136',5297.28,0.00,0.00,7.12,562.48,'2022-08-24 10:29:40','',''),(4229,'1','274','1',1,'Retail Sale Id 4137',9389.28,0.00,0.00,12.62,996.98,'2022-08-24 10:30:27','',''),(4230,'1','274','1',1,'Retail Sale Id 4138',7998.00,0.00,0.00,10.75,849.25,'2022-08-24 11:25:45','',''),(4231,'1','274','1',1,'Retail Sale Id 4139',996.96,0.00,0.00,1.34,105.86,'2022-08-24 11:43:02','',''),(4232,'1','274','1',1,'Retail Sale Id 4140',4002.72,0.00,0.00,5.38,425.02,'2022-08-24 11:43:50','',''),(4233,'1','274','1',1,'Retail Sale Id 4141',12997.68,0.00,0.00,17.47,1380.13,'2022-08-24 11:49:08','',''),(4234,'1','274','1',1,'Retail Sale Id 4142',4501.20,0.00,0.00,6.05,477.95,'2022-08-24 14:31:58','',''),(4235,'1','274','1',1,'Retail Sale Id 4143',8184.00,0.00,0.00,11.00,869.00,'2022-08-24 14:32:45','',''),(4236,'1','274','1',1,'Retail Sale Id 4144',14999.04,0.00,0.00,20.16,1592.64,'2022-08-24 14:33:25','',''),(4237,'1','274','1',1,'Retail Sale Id 4145',37200.00,0.00,0.00,50.00,3950.00,'2022-08-24 14:44:17','',''),(4238,'1','274','1',1,'Retail Sale Id 4146',4999.68,0.00,0.00,6.72,530.88,'2022-08-24 14:46:24','',''),(4239,'1','274','1',1,'Retail Sale Id 4147',2998.32,0.00,0.00,4.03,318.37,'2022-08-24 15:16:33','',''),(4240,'1','274','1',1,'Retail Sale Id 4148',996.96,0.00,0.00,1.34,105.86,'2022-08-24 15:23:19','',''),(4241,'1','274','1',1,'Retail Sale Id 4149',3749.76,0.00,0.00,5.04,398.16,'2022-08-24 15:28:48','',''),(4242,'1','274','1',1,'Retail Sale Id 4150',2001.36,0.00,0.00,2.69,212.51,'2022-08-24 15:30:10','',''),(4243,'1','274','1',1,'Retail Sale Id 4151',2001.36,0.00,0.00,2.69,212.51,'2022-08-24 16:17:55','',''),(4244,'1','274','1',1,'Retail Sale Id 4152',3720.00,0.00,0.00,5.00,395.00,'2022-08-24 16:19:35','',''),(4245,'1','274','1',1,'Retail Sale Id 4153',9300.00,0.00,0.00,12.50,987.50,'2022-08-24 16:41:54','',''),(4246,'1','274','1',1,'Retail Sale Id 4154',4501.20,0.00,0.00,6.05,477.95,'2022-08-24 16:44:25','',''),(4247,'1','274','1',1,'Retail Sale Id 4155',9300.00,0.00,0.00,12.50,987.50,'2022-08-24 16:48:57','',''),(4248,'1','274','1',1,'Retail Sale Id 4156',9300.00,0.00,0.00,12.50,987.50,'2022-08-24 16:52:02','',''),(4249,'1','274','1',1,'Retail Sale Id 4157',2246.88,0.00,0.00,3.02,238.58,'2022-08-24 16:53:12','',''),(4250,'1','274','1',1,'Retail Sale Id 4158',1502.88,0.00,0.00,2.02,159.58,'2022-08-24 16:55:12','',''),(4251,'1','274','1',1,'Retail Sale Id 4159',2998.32,0.00,0.00,4.03,318.37,'2022-08-24 17:01:27','',''),(4252,'1','274','1',1,'Retail Sale Id 4160',744.00,0.00,0.00,1.00,79.00,'2022-08-24 17:02:57','',''),(4253,'1','274','1',1,'Retail Sale Id 4161',32996.40,0.00,0.00,44.35,3503.65,'2022-08-24 17:13:32','',''),(4254,'1','274','1',1,'Retail Sale Id 4162',2001.36,0.00,0.00,2.69,212.51,'2022-08-24 17:14:51','',''),(4255,'1','274','1',1,'Retail Sale Id 4163',9300.00,0.00,0.00,12.50,987.50,'2022-08-24 17:17:56','',''),(4256,'1','274','1',1,'Retail Sale Id 4164',9300.00,0.00,0.00,12.50,987.50,'2022-08-24 17:45:31','',''),(4257,'1','274','1',1,'Retail Sale Id 4165',2998.32,0.00,0.00,4.03,318.37,'2022-08-24 17:52:35','',''),(4258,'1','274','1',1,'Retail Sale Id 4166',9300.00,0.00,0.00,12.50,987.50,'2022-08-24 17:54:04','',''),(4259,'1','274','1',1,'Retail Sale Id 4167',3720.00,0.00,0.00,5.00,395.00,'2022-08-24 17:55:13','',''),(4260,'1','274','1',1,'Retail Sale Id 4168',1502.88,0.00,0.00,2.02,159.58,'2022-08-24 17:56:50','',''),(4261,'1','274','1',1,'Retail Sale Id 4169',2998.32,0.00,0.00,4.03,318.37,'2022-08-24 17:59:37','',''),(4262,'1','274','1',1,'Retail Sale Id 4170',3801.84,0.00,0.00,5.11,403.69,'2022-08-24 18:24:17','',''),(4263,'1','274','1',1,'Retail Sale Id 4171',3720.00,0.00,0.00,5.00,395.00,'2022-08-24 18:29:38','',''),(4264,'1','274','1',1,'Retail Sale Id 4172',9672.00,0.00,0.00,13.00,1027.00,'2022-08-24 18:40:31','',''),(4265,'1','274','1',1,'Retail Sale Id 4173',4464.00,0.00,0.00,6.00,474.00,'2022-08-24 18:42:39','',''),(4266,'1','274','1',1,'Retail Sale Id 4174',109963.20,0.00,0.00,147.80,11676.20,'2022-08-24 19:17:06','',''),(4267,'1','274','1',1,'Retail Sale Id 4175',38494.56,0.00,0.00,51.74,4087.46,'2022-08-24 19:18:20','',''),(4268,'1','274','1',1,'Retail Sale Id 4176',4464.00,0.00,0.00,6.00,474.00,'2022-08-25 06:35:21','',''),(4269,'1','274','1',1,'Retail Sale Id 4177',9300.00,0.00,0.00,12.50,987.50,'2022-08-25 07:50:03','',''),(4270,'1','274','1',1,'Retail Sale Id 4178',14880.00,0.00,0.00,20.00,1580.00,'2022-08-25 07:51:59','',''),(4271,'1','274','1',1,'Retail Sale Id 4179',9300.00,0.00,0.00,12.50,987.50,'2022-08-25 09:35:17','',''),(4272,'1','274','1',1,'Retail Sale Id 4180',7440.00,0.00,0.00,10.00,790.00,'2022-08-25 09:37:33','',''),(4273,'1','274','1',1,'Retail Sale Id 4181',14880.00,0.00,0.00,20.00,1580.00,'2022-08-25 09:38:21','',''),(4274,'1','274','1',1,'Retail Sale Id 4182',22320.00,0.00,0.00,30.00,2370.00,'2022-08-25 10:42:27','',''),(4275,'1','274','1',1,'Retail Sale Id 4183',2298.96,0.00,0.00,3.09,244.11,'2022-08-25 11:38:25','',''),(4276,'1','274','1',1,'Retail Sale Id 4184',5996.64,0.00,0.00,8.06,636.74,'2022-08-25 11:39:43','',''),(4277,'1','274','1',1,'Retail Sale Id 4185',9300.00,0.00,0.00,12.50,987.50,'2022-08-25 11:42:02','',''),(4278,'1','274','1',1,'Retail Sale Id 4186',1502.88,0.00,0.00,2.02,159.58,'2022-08-25 11:56:25','',''),(4279,'1','274','1',1,'Retail Sale Id 4187',2001.36,0.00,0.00,2.69,212.51,'2022-08-25 12:10:12','',''),(4280,'1','274','1',1,'Retail Sale Id 4188',9300.00,0.00,0.00,12.50,987.50,'2022-08-25 12:13:21','',''),(4281,'1','274','1',1,'Retail Sale Id 4189',7440.00,0.00,0.00,10.00,790.00,'2022-08-25 12:27:06','',''),(4282,'1','274','1',1,'Retail Sale Id 4190',29001.12,0.00,0.00,38.98,3079.42,'2022-08-25 12:36:26','',''),(4283,'1','274','1',1,'Retail Sale Id 4191',2246.88,0.00,0.00,3.02,238.58,'2022-08-25 12:57:49','',''),(4284,'1','274','1',1,'Retail Sale Id 4192',9300.00,0.00,0.00,12.50,987.50,'2022-08-25 13:07:00','',''),(4285,'1','274','1',1,'Retail Sale Id 4193',2001.36,0.00,0.00,2.69,212.51,'2022-08-25 13:58:57','',''),(4286,'1','274','1',1,'Retail Sale Id 4194',9300.00,0.00,0.00,12.50,987.50,'2022-08-25 14:00:22','',''),(4287,'1','274','1',1,'Retail Sale Id 4195',4501.20,0.00,0.00,6.05,477.95,'2022-08-25 14:01:50','',''),(4288,'1','274','1',1,'Retail Sale Id 4196',111600.00,0.00,0.00,150.00,11850.00,'2022-08-25 15:03:36','',''),(4289,'1','274','1',1,'Retail Sale Id 4197',8496.48,0.00,0.00,11.42,902.18,'2022-08-25 15:13:03','',''),(4290,'1','274','1',1,'Retail Sale Id 4198',14902.32,0.00,0.00,20.03,1582.37,'2022-08-25 15:22:53','',''),(4291,'1','274','1',1,'Retail Sale Id 4199',4501.20,0.00,0.00,6.05,477.95,'2022-08-25 15:32:47','',''),(4292,'1','274','1',1,'Retail Sale Id 4200',9300.00,0.00,0.00,12.50,987.50,'2022-08-25 16:40:07','',''),(4293,'1','274','1',1,'Retail Sale Id 4201',2001.36,0.00,0.00,2.69,212.51,'2022-08-25 16:41:20','',''),(4294,'1','274','1',1,'Retail Sale Id 4202',9300.00,0.00,0.00,12.50,987.50,'2022-08-25 17:32:35','',''),(4295,'1','274','1',1,'Retail Sale Id 4203',18600.00,0.00,0.00,25.00,1975.00,'2022-08-25 17:35:11','',''),(4296,'1','274','1',1,'Retail Sale Id 4204',2246.88,0.00,0.00,3.02,238.58,'2022-08-25 17:39:39','',''),(4297,'1','274','1',1,'Retail Sale Id 4205',2202.24,0.00,0.00,2.96,233.84,'2022-08-25 17:45:27','',''),(4298,'1','274','1',1,'Retail Sale Id 4206',2001.36,0.00,0.00,2.69,212.51,'2022-08-25 17:58:30','',''),(4299,'1','274','1',1,'Retail Sale Id 4207',9300.00,0.00,0.00,12.50,987.50,'2022-08-25 18:01:18','',''),(4300,'1','274','1',1,'Retail Sale Id 4208',2499.84,0.00,0.00,3.36,265.44,'2022-08-25 18:06:10','',''),(4301,'1','274','1',1,'Retail Sale Id 4209',74400.00,0.00,0.00,100.00,7900.00,'2022-08-25 19:06:14','',''),(4302,'1','274','1',1,'Retail Sale Id 4210',60360.72,0.00,0.00,81.13,6409.27,'2022-08-25 19:07:06','',''),(4303,'1','274','1',1,'Retail Sale Id 4211',49275.12,0.00,0.00,66.23,5232.17,'2022-08-25 19:08:15','',''),(4304,'1','274','1',1,'Retail Sale Id 4212',37200.00,0.00,0.00,50.00,3950.00,'2022-08-26 07:56:37','',''),(4305,'1','274','1',1,'Retail Sale Id 4213',1197.84,0.00,0.00,1.61,127.19,'2022-08-26 08:18:46','',''),(4306,'1','274','1',1,'Retail Sale Id 4214',2700.72,0.00,0.00,3.63,286.77,'2022-08-26 08:46:36','',''),(4307,'1','274','1',1,'Retail Sale Id 4215',996.96,0.00,0.00,1.34,105.86,'2022-08-26 08:52:33','',''),(4308,'1','274','1',1,'Retail Sale Id 4216',9300.00,0.00,0.00,12.50,987.50,'2022-08-26 08:53:25','',''),(4309,'1','274','1',1,'Retail Sale Id 4217',2298.96,0.00,0.00,3.09,244.11,'2022-08-26 08:59:51','',''),(4310,'1','274','1',1,'Retail Sale Id 4218',9300.00,0.00,0.00,12.50,987.50,'2022-08-26 09:17:09','',''),(4311,'1','274','1',1,'Retail Sale Id 4219',18600.00,0.00,0.00,25.00,1975.00,'2022-08-26 09:25:40','',''),(4312,'1','274','1',1,'Retail Sale Id 4220',18600.00,0.00,0.00,25.00,1975.00,'2022-08-26 09:27:00','',''),(4313,'1','274','1',1,'Retail Sale Id 4221',4501.20,0.00,0.00,6.05,477.95,'2022-08-26 09:28:03','',''),(4314,'1','274','1',1,'Retail Sale Id 4222',9300.00,0.00,0.00,12.50,987.50,'2022-08-26 09:32:39','',''),(4315,'1','274','1',1,'Retail Sale Id 4223',2001.36,0.00,0.00,2.69,212.51,'2022-08-26 09:36:27','',''),(4316,'1','274','1',1,'Retail Sale Id 4224',9300.00,0.00,0.00,12.50,987.50,'2022-08-26 09:41:09','',''),(4317,'1','274','1',1,'Retail Sale Id 4225',3720.00,0.00,0.00,5.00,395.00,'2022-08-26 09:42:30','',''),(4318,'1','274','1',1,'Retail Sale Id 4226',3749.76,0.00,0.00,5.04,398.16,'2022-08-26 10:15:05','',''),(4319,'1','274','1',1,'Retail Sale Id 4227',2298.96,0.00,0.00,3.09,244.11,'2022-08-26 10:39:21','',''),(4320,'1','274','1',1,'Retail Sale Id 4228',2998.32,0.00,0.00,4.03,318.37,'2022-08-26 10:44:08','',''),(4321,'1','274','1',1,'Retail Sale Id 4229',9300.00,0.00,0.00,12.50,987.50,'2022-08-26 10:46:41','',''),(4322,'1','274','1',1,'Retail Sale Id 4230',9300.00,0.00,0.00,12.50,987.50,'2022-08-26 10:53:05','',''),(4323,'1','274','1',1,'Retail Sale Id 4231',4501.20,0.00,0.00,6.05,477.95,'2022-08-26 11:19:00','',''),(4324,'1','274','1',1,'Retail Sale Id 4232',3749.76,0.00,0.00,5.04,398.16,'2022-08-26 11:34:08','',''),(4325,'1','274','1',1,'Retail Sale Id 4233',37200.00,0.00,0.00,50.00,3950.00,'2022-08-26 11:43:28','',''),(4326,'1','274','1',1,'Retail Sale Id 4234',2298.96,0.00,0.00,3.09,244.11,'2022-08-26 11:48:34','',''),(4327,'1','274','1',1,'Retail Sale Id 4235',1502.88,0.00,0.00,2.02,159.58,'2022-08-26 12:02:42','',''),(4328,'1','274','1',1,'Retail Sale Id 4236',4501.20,0.00,0.00,6.05,477.95,'2022-08-26 12:04:56','',''),(4329,'1','274','1',1,'Retail Sale Id 4237',44647.44,0.00,0.00,60.01,4740.79,'2022-08-26 12:06:37','',''),(4330,'1','274','1',1,'Retail Sale Id 4238',2998.32,0.00,0.00,4.03,318.37,'2022-08-26 12:07:41','',''),(4331,'1','274','1',1,'Retail Sale Id 4239',751.44,0.00,0.00,1.01,79.79,'2022-08-26 12:10:21','',''),(4332,'1','274','1',1,'Retail Sale Id 4240',4002.72,0.00,0.00,5.38,425.02,'2022-08-26 14:13:07','',''),(4333,'1','274','1',1,'Retail Sale Id 4241',2001.36,0.00,0.00,2.69,212.51,'2022-08-26 14:14:47','',''),(4334,'1','274','1',1,'Retail Sale Id 4242',9300.00,0.00,0.00,12.50,987.50,'2022-08-26 14:16:51','',''),(4335,'1','274','1',1,'Retail Sale Id 4243',9300.00,0.00,0.00,12.50,987.50,'2022-08-26 14:30:22','',''),(4336,'1','274','1',1,'Retail Sale Id 4244',4002.72,0.00,0.00,5.38,425.02,'2022-08-26 14:36:13','',''),(4337,'1','274','1',1,'Retail Sale Id 4245',2499.84,0.00,0.00,3.36,265.44,'2022-08-26 14:38:35','',''),(4338,'1','274','1',1,'Retail Sale Id 4246',9999.36,0.00,0.00,13.44,1061.76,'2022-08-26 14:41:18','',''),(4339,'1','274','1',1,'Retail Sale Id 4247',2246.88,0.00,0.00,3.02,238.58,'2022-08-26 14:47:02','',''),(4340,'1','274','1',1,'Retail Sale Id 4248',996.96,0.00,0.00,1.34,105.86,'2022-08-26 14:57:28','',''),(4341,'1','274','1',1,'Retail Sale Id 4249',1502.88,0.00,0.00,2.02,159.58,'2022-08-26 15:24:12','',''),(4342,'1','274','1',1,'Retail Sale Id 4250',2001.36,0.00,0.00,2.69,212.51,'2022-08-26 16:33:38','',''),(4343,'1','274','1',1,'Retail Sale Id 4251',4501.20,0.00,0.00,6.05,477.95,'2022-08-26 16:35:11','',''),(4344,'1','274','1',1,'Retail Sale Id 4252',9300.00,0.00,0.00,12.50,987.50,'2022-08-26 16:56:36','',''),(4345,'1','274','1',1,'Retail Sale Id 4253',2001.36,0.00,0.00,2.69,212.51,'2022-08-26 17:28:45','',''),(4346,'1','274','1',1,'Retail Sale Id 4254',9300.00,0.00,0.00,12.50,987.50,'2022-08-26 17:33:46','',''),(4347,'1','274','1',1,'Retail Sale Id 4255',9300.00,0.00,0.00,12.50,987.50,'2022-08-26 17:45:57','',''),(4348,'1','274','1',1,'Retail Sale Id 4256',1800.48,0.00,0.00,2.42,191.18,'2022-08-26 17:46:56','',''),(4349,'1','274','1',1,'Return of Retail Sale Id 4255',0.00,9300.00,12.50,0.00,-987.50,'2022-08-26 17:56:35','',''),(4350,'1','274','1',1,'Retail Sale Id 4257',150444.24,0.00,0.00,202.21,15974.59,'2022-08-26 17:57:47','',''),(4351,'1','274','1',1,'Retail Sale Id 4258',9300.00,0.00,0.00,12.50,987.50,'2022-08-26 18:00:06','',''),(4352,'1','274','1',1,'Retail Sale Id 4259',2246.88,0.00,0.00,3.02,238.58,'2022-08-26 18:33:52','',''),(4353,'1','274','1',1,'Retail Sale Id 4260',7447.44,0.00,0.00,10.01,790.79,'2022-08-26 18:41:14','',''),(4354,'1','274','1',1,'Retail Sale Id 4261',1502.88,0.00,0.00,2.02,159.58,'2022-08-26 18:42:16','',''),(4355,'1','274','1',1,'Retail Sale Id 4262',2001.36,0.00,0.00,2.69,212.51,'2022-08-26 18:43:07','',''),(4356,'1','274','1',1,'Retail Sale Id 4263',9300.00,0.00,0.00,12.50,987.50,'2022-08-26 18:44:41','',''),(4357,'1','274','1',1,'Return of Retail Sale Id 4254',0.00,9300.00,12.50,0.00,-987.50,'2022-08-26 19:34:26','',''),(4358,'1','274','1',1,'Return of Retail Sale Id 4246',0.00,9999.36,13.44,0.00,-1061.76,'2022-08-26 19:36:21','',''),(4359,'1','274','1',1,'Return of Retail Sale Id 4237',0.00,44647.44,60.01,0.00,-4740.79,'2022-08-26 19:39:46','',''),(4360,'1','274','1',1,'Retail Sale Id 4264',22744.08,0.00,0.00,30.57,2415.03,'2022-08-26 19:42:57','',''),(4361,'1','274','1',1,'Retail Sale Id 4265',54252.48,0.00,0.00,72.92,5760.68,'2022-08-26 19:56:32','',''),(4362,'1','274','1',1,'Retail Sale Id 4266',15252.00,0.00,0.00,20.50,1619.50,'2022-08-26 19:57:18','',''),(4363,'1','274','1',1,'Retail Sale Id 4268',9300.00,0.00,0.00,12.50,987.50,'2022-08-27 06:37:53','',''),(4364,'1','274','1',1,'Retail Sale Id 4269',46500.00,0.00,0.00,62.50,4937.50,'2022-08-27 06:49:40','',''),(4365,'1','274','1',1,'Retail Sale Id 4270',9672.00,0.00,0.00,13.00,1027.00,'2022-08-27 07:53:58','',''),(4366,'1','274','1',1,'Retail Sale Id 4271',18600.00,0.00,0.00,25.00,1975.00,'2022-08-27 09:54:39','',''),(4367,'1','274','1',1,'Retail Sale Id 4272',9300.00,0.00,0.00,12.50,987.50,'2022-08-27 09:55:28','',''),(4368,'1','274','1',1,'Retail Sale Id 4273',9002.40,0.00,0.00,12.10,955.90,'2022-08-27 09:56:24','',''),(4369,'1','274','1',1,'Retail Sale Id 4274',9300.00,0.00,0.00,12.50,987.50,'2022-08-27 10:01:01','',''),(4370,'1','274','1',1,'Retail Sale Id 4275',1502.88,0.00,0.00,2.02,159.58,'2022-08-27 10:04:22','',''),(4371,'1','274','1',1,'Retail Sale Id 4276',33480.00,0.00,0.00,45.00,3555.00,'2022-08-27 10:15:02','',''),(4372,'1','274','1',1,'Retail Sale Id 4277',2246.88,0.00,0.00,3.02,238.58,'2022-08-27 10:16:26','',''),(4373,'1','274','1',1,'Retail Sale Id 4278',9300.00,0.00,0.00,12.50,987.50,'2022-08-27 10:17:26','',''),(4374,'1','274','1',1,'Retail Sale Id 4279',2246.88,0.00,0.00,3.02,238.58,'2022-08-27 10:19:46','',''),(4375,'1','274','1',1,'Retail Sale Id 4280',3749.76,0.00,0.00,5.04,398.16,'2022-08-27 10:28:07','',''),(4376,'1','274','1',1,'Retail Sale Id 4281',2998.32,0.00,0.00,4.03,318.37,'2022-08-27 10:30:30','',''),(4377,'1','274','1',1,'Retail Sale Id 4282',18600.00,0.00,0.00,25.00,1975.00,'2022-08-27 10:55:24','',''),(4378,'1','274','1',1,'Retail Sale Id 4283',7998.00,0.00,0.00,10.75,849.25,'2022-08-27 11:01:11','',''),(4379,'1','274','1',1,'Retail Sale Id 4284',7001.04,0.00,0.00,9.41,743.39,'2022-08-27 11:04:28','',''),(4380,'1','274','1',1,'Retail Sale Id 4285',4002.72,0.00,0.00,5.38,425.02,'2022-08-27 11:14:13','',''),(4381,'1','274','1',1,'Retail Sale Id 4286',9300.00,0.00,0.00,12.50,987.50,'2022-08-27 11:19:59','',''),(4382,'1','274','1',1,'Retail Sale Id 4287',3496.80,0.00,0.00,4.70,371.30,'2022-08-27 11:25:22','',''),(4383,'1','274','1',1,'Retail Sale Id 4288',4501.20,0.00,0.00,6.05,477.95,'2022-08-27 11:39:13','',''),(4384,'1','274','1',1,'Retail Sale Id 4289',996.96,0.00,0.00,1.34,105.86,'2022-08-27 11:43:22','',''),(4385,'1','274','1',1,'Retail Sale Id 4290',2001.36,0.00,0.00,2.69,212.51,'2022-08-27 11:48:53','',''),(4386,'1','274','1',1,'Retail Sale Id 4291',5996.64,0.00,0.00,8.06,636.74,'2022-08-27 11:55:22','',''),(4387,'1','274','1',1,'Retail Sale Id 4292',18600.00,0.00,0.00,25.00,1975.00,'2022-08-27 12:19:18','',''),(4388,'1','274','1',1,'Retail Sale Id 4293',2246.88,0.00,0.00,3.02,238.58,'2022-08-27 12:21:07','',''),(4389,'1','274','1',1,'Retail Sale Id 4294',2998.32,0.00,0.00,4.03,318.37,'2022-08-27 12:25:27','',''),(4390,'1','274','1',1,'Retail Sale Id 4295',2998.32,0.00,0.00,4.03,318.37,'2022-08-27 12:26:53','',''),(4391,'1','274','1',1,'Retail Sale Id 4296',9300.00,0.00,0.00,12.50,987.50,'2022-08-27 12:29:13','',''),(4392,'1','274','1',1,'Retail Sale Id 4297',2998.32,0.00,0.00,4.03,318.37,'2022-08-27 12:32:41','',''),(4393,'1','274','1',1,'Retail Sale Id 4298',2998.32,0.00,0.00,4.03,318.37,'2022-08-27 12:41:07','',''),(4394,'1','274','1',1,'Retail Sale Id 4299',27900.00,0.00,0.00,37.50,2962.50,'2022-08-27 12:42:52','',''),(4395,'1','274','1',1,'Retail Sale Id 4300',4002.72,0.00,0.00,5.38,425.02,'2022-08-27 13:24:18','',''),(4396,'1','274','1',1,'Retail Sale Id 4301',9300.00,0.00,0.00,12.50,987.50,'2022-08-27 13:36:10','',''),(4397,'1','274','1',1,'Retail Sale Id 4302',2998.32,0.00,0.00,4.03,318.37,'2022-08-27 13:37:00','',''),(4398,'1','274','1',1,'Retail Sale Id 4303',115409.28,0.00,0.00,155.12,12254.48,'2022-08-27 14:58:34','',''),(4399,'1','274','1',1,'Retail Sale Id 4304',30556.08,0.00,0.00,41.07,3244.53,'2022-08-27 15:00:32','',''),(4400,'1','274','1',1,'Retail Sale Id 4305',8303.04,0.00,0.00,11.16,881.64,'2022-08-27 15:16:27','',''),(4401,'1','274','1',1,'Retail Sale Id 4306',2968.56,0.00,0.00,3.99,315.21,'2022-08-27 15:43:01','',''),(4402,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,5206.95,7.83,0.00,0.00,'2022-08-27 16:03:01','',''),(4403,'1','274',NULL,1,'Reception corrector for bridging 40',0.00,0.00,0.00,7.83,0.00,'2022-08-27 16:04:56','',''),(4404,'1','274','1',1,'Received from bridging 40',0.00,0.00,7.83,0.00,0.00,'2022-08-27 16:04:56','',''),(4405,'1','274','1',1,'Retail Sale Id 4307',5825.52,0.00,0.00,7.83,618.57,'2022-08-27 16:05:48','',''),(4406,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,665000.00,1000.00,0.00,0.00,'2022-08-28 07:44:47','',''),(4407,'1','274',NULL,1,'Reception corrector for bridging 41',0.00,0.00,0.00,1000.00,0.00,'2022-08-28 07:47:06','',''),(4408,'1','274','1',1,'Received from bridging 41',0.00,0.00,1000.00,0.00,0.00,'2022-08-28 07:47:06','',''),(4409,'1','274','1',1,'Retail Sale Id 4308',9300.00,0.00,0.00,12.50,987.50,'2022-08-28 07:48:26','',''),(4410,'1','274','1',1,'Retail Sale Id 4309',29998.08,0.00,0.00,40.32,3185.28,'2022-08-28 07:49:25','',''),(4411,'1','274','1',1,'Retail Sale Id 4310',4501.20,0.00,0.00,6.05,477.95,'2022-08-28 07:50:14','',''),(4412,'1','274','1',1,'Retail Sale Id 4311',9300.00,0.00,0.00,12.50,987.50,'2022-08-28 07:51:00','',''),(4413,'1','274','1',1,'Retail Sale Id 4312',9300.00,0.00,0.00,12.50,987.50,'2022-08-28 10:27:02','',''),(4414,'1','274','1',1,'Retail Sale Id 4313',4501.20,0.00,0.00,6.05,477.95,'2022-08-28 10:28:04','',''),(4415,'1','274','1',1,'Retail Sale Id 4314',6502.56,0.00,0.00,8.74,690.46,'2022-08-28 10:29:15','',''),(4416,'1','274','1',1,'Retail Sale Id 4315',9300.00,0.00,0.00,12.50,987.50,'2022-08-28 10:29:46','',''),(4417,'1','274','1',1,'Retail Sale Id 4316',9300.00,0.00,0.00,12.50,987.50,'2022-08-28 10:30:27','',''),(4418,'1','274','1',1,'Retail Sale Id 4317',1502.88,0.00,0.00,2.02,159.58,'2022-08-28 10:36:13','',''),(4419,'1','274','1',1,'Retail Sale Id 4318',2246.88,0.00,0.00,3.02,238.58,'2022-08-28 10:42:47','',''),(4420,'1','274','1',1,'Retail Sale Id 4319',27900.00,0.00,0.00,37.50,2962.50,'2022-08-28 11:13:47','',''),(4421,'1','274','1',1,'Retail Sale Id 4320',9300.00,0.00,0.00,12.50,987.50,'2022-08-28 11:14:34','',''),(4422,'1','274','1',1,'Retail Sale Id 4321',4501.20,0.00,0.00,6.05,477.95,'2022-08-28 11:47:47','',''),(4423,'1','274','1',1,'Retail Sale Id 4322',7001.04,0.00,0.00,9.41,743.39,'2022-08-28 11:49:42','',''),(4424,'1','274','1',1,'Retail Sale Id 4323',2001.36,0.00,0.00,2.69,212.51,'2022-08-28 11:59:39','',''),(4425,'1','274','1',1,'Retail Sale Id 4324',9300.00,0.00,0.00,12.50,987.50,'2022-08-28 12:02:08','',''),(4426,'1','274','1',1,'Retail Sale Id 4325',9300.00,0.00,0.00,12.50,987.50,'2022-08-28 12:05:29','',''),(4427,'1','274','1',1,'Retail Sale Id 4326',2298.96,0.00,0.00,3.09,244.11,'2022-08-28 12:28:23','',''),(4428,'1','274','1',1,'Retail Sale Id 4327',18600.00,0.00,0.00,25.00,1975.00,'2022-08-28 12:30:07','',''),(4429,'1','274','1',1,'Retail Sale Id 4328',2246.88,0.00,0.00,3.02,238.58,'2022-08-28 12:36:00','',''),(4430,'1','274','1',1,'Retail Sale Id 4329',1502.88,0.00,0.00,2.02,159.58,'2022-08-28 12:50:08','',''),(4431,'1','274','1',1,'Retail Sale Id 4330',996.96,0.00,0.00,1.34,105.86,'2022-08-28 12:51:42','',''),(4432,'1','274','1',1,'Retail Sale Id 4331',9300.00,0.00,0.00,12.50,987.50,'2022-08-28 12:54:23','',''),(4433,'1','274','1',1,'Retail Sale Id 4332',2001.36,0.00,0.00,2.69,212.51,'2022-08-28 13:00:51','',''),(4434,'1','274','1',1,'Retail Sale Id 4333',22997.04,0.00,0.00,30.91,2441.89,'2022-08-28 13:08:46','',''),(4435,'1','274','1',1,'Retail Sale Id 4334',996.96,0.00,0.00,1.34,105.86,'2022-08-28 13:39:32','',''),(4436,'1','274','1',1,'Retail Sale Id 4335',751.44,0.00,0.00,1.01,79.79,'2022-08-28 14:00:42','',''),(4437,'1','274','1',1,'Retail Sale Id 4336',4002.72,0.00,0.00,5.38,425.02,'2022-08-28 14:30:02','',''),(4438,'1','274','1',1,'Retail Sale Id 4337',2001.36,0.00,0.00,2.69,212.51,'2022-08-28 14:57:42','',''),(4439,'1','274','1',1,'Retail Sale Id 4338',9300.00,0.00,0.00,12.50,987.50,'2022-08-28 14:58:57','',''),(4440,'1','274','1',1,'Retail Sale Id 4339',4501.20,0.00,0.00,6.05,477.95,'2022-08-28 15:01:14','',''),(4441,'1','274','1',1,'Retail Sale Id 4340',2001.36,0.00,0.00,2.69,212.51,'2022-08-28 15:02:02','',''),(4442,'1','274','1',1,'Retail Sale Id 4341',2246.88,0.00,0.00,3.02,238.58,'2022-08-28 15:08:49','',''),(4443,'1','274','1',1,'Retail Sale Id 4342',4501.20,0.00,0.00,6.05,477.95,'2022-08-28 15:16:49','',''),(4444,'1','274','1',1,'Retail Sale Id 4343',1502.88,0.00,0.00,2.02,159.58,'2022-08-28 15:19:50','',''),(4445,'1','274','1',1,'Retail Sale Id 4344',1502.88,0.00,0.00,2.02,159.58,'2022-08-28 15:23:25','',''),(4446,'1','274','1',1,'Retail Sale Id 4345',9300.00,0.00,0.00,12.50,987.50,'2022-08-28 15:25:49','',''),(4447,'1','274','1',1,'Retail Sale Id 4346',2246.88,0.00,0.00,3.02,238.58,'2022-08-28 15:27:18','',''),(4448,'1','274','1',1,'Retail Sale Id 4347',4501.20,0.00,0.00,6.05,477.95,'2022-08-28 15:41:23','',''),(4449,'1','274','1',1,'Retail Sale Id 4348',2246.88,0.00,0.00,3.02,238.58,'2022-08-28 15:43:15','',''),(4450,'1','274','1',1,'Retail Sale Id 4349',4501.20,0.00,0.00,6.05,477.95,'2022-08-28 15:46:46','',''),(4451,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,2952600.00,4440.00,0.00,0.00,'2022-08-28 18:11:28','',''),(4452,'1','274',NULL,1,'Reception corrector for bridging 43',0.00,0.00,0.00,4440.00,0.00,'2022-08-28 18:13:08','',''),(4453,'1','274','1',1,'Received from bridging 43',0.00,0.00,4440.00,0.00,0.00,'2022-08-28 18:13:08','',''),(4454,'1','274','1',1,'Retail Sale Id 4350',74400.00,0.00,0.00,100.00,7900.00,'2022-08-28 19:17:12','',''),(4455,'1','274','1',1,'Retail Sale Id 4351',74400.00,0.00,0.00,100.00,7900.00,'2022-08-28 19:17:39','',''),(4456,'1','274','1',1,'Retail Sale Id 4352',104970.96,0.00,0.00,141.09,11146.11,'2022-08-28 19:18:15','',''),(4457,'1','274','1',1,'Retail Sale Id 4353',68693.52,0.00,0.00,92.33,7294.07,'2022-08-28 19:18:46','',''),(4458,'1','274','1',1,'Retail Sale Id 4354',74400.00,0.00,0.00,100.00,7900.00,'2022-08-28 19:19:49','',''),(4459,'1','274','1',1,'Retail Sale Id 4355',4464.00,0.00,0.00,6.00,474.00,'2022-08-29 06:38:57','',''),(4460,'1','274','1',1,'Retail Sale Id 4356',9300.00,0.00,0.00,12.50,987.50,'2022-08-29 07:10:35','',''),(4461,'1','274','1',1,'Retail Sale Id 4357',7440.00,0.00,0.00,10.00,790.00,'2022-08-29 08:04:32','',''),(4462,'1','274','1',1,'Retail Sale Id 4358',22320.00,0.00,0.00,30.00,2370.00,'2022-08-29 10:19:44','',''),(4463,'1','274','1',1,'Retail Sale Id 4359',9300.00,0.00,0.00,12.50,987.50,'2022-08-29 10:36:41','',''),(4464,'1','274','1',1,'Retail Sale Id 4360',996.96,0.00,0.00,1.34,105.86,'2022-08-29 10:48:13','',''),(4465,'1','274','1',1,'Retail Sale Id 4361',1502.88,0.00,0.00,2.02,159.58,'2022-08-29 12:20:12','',''),(4466,'1','274','1',1,'Retail Sale Id 4362',4999.68,0.00,0.00,6.72,530.88,'2022-08-29 12:27:39','',''),(4467,'1','274','1',1,'Retail Sale Id 4363',127573.68,0.00,0.00,171.47,13546.13,'2022-08-29 12:34:25','',''),(4468,'1','274','1',1,'Return of Retail Sale Id 4363',0.00,127573.68,171.47,0.00,-13546.13,'2022-08-29 12:35:24','',''),(4469,'1','274','1',1,'Retail Sale Id 4364',89570.16,0.00,0.00,120.39,9510.81,'2022-08-29 12:39:18','',''),(4470,'1','274','1',1,'Retail Sale Id 4365',3749.76,0.00,0.00,5.04,398.16,'2022-08-29 14:37:03','',''),(4471,'1','274','1',1,'Retail Sale Id 4366',180992.88,0.00,0.00,243.27,19218.33,'2022-08-29 19:10:46','',''),(4472,'1','274','1',1,'Retail Sale Id 4367',89830.56,0.00,0.00,120.74,9538.46,'2022-08-29 19:12:15','',''),(4473,'1','274','1',1,'Retail Sale Id 4368',9300.00,0.00,0.00,12.50,987.50,'2022-08-30 06:59:36','',''),(4474,'1','274','1',1,'Retail Sale Id 4369',4464.00,0.00,0.00,6.00,474.00,'2022-08-30 07:00:18','',''),(4475,'1','274','1',1,'Retail Sale Id 4370',29001.12,0.00,0.00,38.98,3079.42,'2022-08-30 08:04:06','',''),(4476,'1','274','1',1,'Retail Sale Id 4371',9300.00,0.00,0.00,12.50,987.50,'2022-08-30 08:16:24','',''),(4477,'1','274','1',1,'Retail Sale Id 4372',744.00,0.00,0.00,1.00,79.00,'2022-08-30 08:23:07','',''),(4478,'1','274','1',1,'Retail Sale Id 4373',9300.00,0.00,0.00,12.50,987.50,'2022-08-30 11:41:33','',''),(4479,'1','274','1',1,'Retail Sale Id 4374',9300.00,0.00,0.00,12.50,987.50,'2022-08-30 11:55:15','',''),(4480,'1','274','1',1,'Retail Sale Id 4375',17997.36,0.00,0.00,24.19,1911.01,'2022-08-30 12:38:21','',''),(4481,'1','274','1',1,'Retail Sale Id 4377',6502.56,0.00,0.00,8.74,690.46,'2022-08-30 12:59:09','',''),(4482,'1','274','1',1,'Retail Sale Id 4378',4002.72,0.00,0.00,5.38,425.02,'2022-08-30 13:38:22','',''),(4483,'1','274','1',1,'Retail Sale Id 4379',13392.00,0.00,0.00,18.00,1422.00,'2022-08-30 14:04:29','',''),(4484,'1','274','1',1,'Retail Sale Id 4380',18600.00,0.00,0.00,25.00,1975.00,'2022-08-30 14:05:46','',''),(4485,'1','274','1',1,'Retail Sale Id 4381',46500.00,0.00,0.00,62.50,4937.50,'2022-08-30 14:08:14','',''),(4486,'1','274','1',1,'Retail Sale Id 4382',2298.96,0.00,0.00,3.09,244.11,'2022-08-30 14:10:31','',''),(4487,'1','274','1',1,'Retail Sale Id 4383',4501.20,0.00,0.00,6.05,477.95,'2022-08-30 14:17:56','',''),(4488,'1','274','1',1,'Retail Sale Id 4384',4501.20,0.00,0.00,6.05,477.95,'2022-08-30 14:34:23','',''),(4489,'1','274','1',1,'Retail Sale Id 4385',9300.00,0.00,0.00,12.50,987.50,'2022-08-30 14:47:45','',''),(4490,'1','274','1',1,'Retail Sale Id 4386',2001.36,0.00,0.00,2.69,212.51,'2022-08-30 15:04:52','',''),(4491,'1','274','1',1,'Retail Sale Id 4387',2001.36,0.00,0.00,2.69,212.51,'2022-08-30 15:11:10','',''),(4492,'1','274','1',1,'Retail Sale Id 4388',9300.00,0.00,0.00,12.50,987.50,'2022-08-30 15:21:57','',''),(4493,'1','274','1',1,'Retail Sale Id 4389',32996.40,0.00,0.00,44.35,3503.65,'2022-08-30 15:31:31','',''),(4494,'1','274','1',1,'Retail Sale Id 4390',2298.96,0.00,0.00,3.09,244.11,'2022-08-30 16:13:47','',''),(4495,'1','274','1',1,'Retail Sale Id 4391',18600.00,0.00,0.00,25.00,1975.00,'2022-08-30 16:15:04','',''),(4496,'1','274','1',1,'Retail Sale Id 4392',9300.00,0.00,0.00,12.50,987.50,'2022-08-30 16:16:18','',''),(4497,'1','274','1',1,'Retail Sale Id 4393',9300.00,0.00,0.00,12.50,987.50,'2022-08-30 16:17:34','',''),(4498,'1','274','1',1,'Retail Sale Id 4394',9300.00,0.00,0.00,12.50,987.50,'2022-08-30 16:18:34','',''),(4499,'1','274','1',1,'Retail Sale Id 4395',3697.68,0.00,0.00,4.97,392.63,'2022-08-30 16:19:37','',''),(4500,'1','274','1',1,'Retail Sale Id 4396',1502.88,0.00,0.00,2.02,159.58,'2022-08-30 16:26:28','',''),(4501,'1','274','1',1,'Retail Sale Id 4397',9300.00,0.00,0.00,12.50,987.50,'2022-08-30 16:27:33','',''),(4502,'1','274','1',1,'Retail Sale Id 4398',3697.68,0.00,0.00,4.97,392.63,'2022-08-30 16:29:08','',''),(4503,'1','274','1',1,'Retail Sale Id 4399',2232.00,0.00,0.00,3.00,237.00,'2022-08-30 16:50:34','',''),(4504,'1','274','1',1,'Retail Sale Id 4400',9300.00,0.00,0.00,12.50,987.50,'2022-08-30 16:51:49','',''),(4505,'1','274','1',1,'Retail Sale Id 4401',18600.00,0.00,0.00,25.00,1975.00,'2022-08-30 17:13:37','',''),(4506,'1','274','1',1,'Retail Sale Id 4402',9300.00,0.00,0.00,12.50,987.50,'2022-08-30 17:17:04','',''),(4507,'1','274','1',1,'Retail Sale Id 4403',3749.76,0.00,0.00,5.04,398.16,'2022-08-30 17:22:10','',''),(4508,'1','274','1',1,'Retail Sale Id 4404',996.96,0.00,0.00,1.34,105.86,'2022-08-30 17:29:48','',''),(4509,'1','274','1',1,'Retail Sale Id 4405',2246.88,0.00,0.00,3.02,238.58,'2022-08-30 17:31:19','',''),(4510,'1','274','1',1,'Retail Sale Id 4406',2499.84,0.00,0.00,3.36,265.44,'2022-08-30 17:32:31','',''),(4511,'1','274','1',1,'Retail Sale Id 4407',1302.00,0.00,0.00,1.75,138.25,'2022-08-30 17:33:56','',''),(4512,'1','274','1',1,'Retail Sale Id 4408',5498.16,0.00,0.00,7.39,583.81,'2022-08-30 17:37:41','',''),(4513,'1','274','1',1,'Retail Sale Id 4409',9300.00,0.00,0.00,12.50,987.50,'2022-08-30 17:48:29','',''),(4514,'1','274','1',1,'Retail Sale Id 4410',2998.32,0.00,0.00,4.03,318.37,'2022-08-30 17:50:23','',''),(4515,'1','274','1',1,'Retail Sale Id 4411',9300.00,0.00,0.00,12.50,987.50,'2022-08-30 17:51:12','',''),(4516,'1','274','1',1,'Retail Sale Id 4412',1502.88,0.00,0.00,2.02,159.58,'2022-08-30 17:56:02','',''),(4517,'1','274','1',1,'Retail Sale Id 4413',2246.88,0.00,0.00,3.02,238.58,'2022-08-30 17:57:16','',''),(4518,'1','274','1',1,'Retail Sale Id 4414',4501.20,0.00,0.00,6.05,477.95,'2022-08-30 18:07:22','',''),(4519,'1','274','1',1,'Retail Sale Id 4415',1502.88,0.00,0.00,2.02,159.58,'2022-08-30 18:08:40','',''),(4520,'1','274','1',1,'Retail Sale Id 4416',14136.00,0.00,0.00,19.00,1501.00,'2022-08-30 18:11:35','',''),(4521,'1','274','1',1,'Retail Sale Id 4417',9300.00,0.00,0.00,12.50,987.50,'2022-08-30 18:15:14','',''),(4522,'1','274','1',1,'Retail Sale Id 4418',27900.00,0.00,0.00,37.50,2962.50,'2022-08-30 18:18:54','',''),(4523,'1','274','1',1,'Retail Sale Id 4419',16003.44,0.00,0.00,21.51,1699.29,'2022-08-30 18:22:28','',''),(4524,'1','274','1',1,'Retail Sale Id 4420',9300.00,0.00,0.00,12.50,987.50,'2022-08-30 18:26:24','',''),(4525,'1','274','1',1,'Retail Sale Id 4421',996.96,0.00,0.00,1.34,105.86,'2022-08-30 18:33:04','',''),(4526,'1','274','1',1,'Retail Sale Id 4422',9300.00,0.00,0.00,12.50,987.50,'2022-08-30 18:37:45','',''),(4527,'1','274','1',1,'Retail Sale Id 4424',4501.20,0.00,0.00,6.05,477.95,'2022-08-30 18:47:03','',''),(4528,'1','274','1',1,'Retail Sale Id 4425',4501.20,0.00,0.00,6.05,477.95,'2022-08-30 18:48:41','',''),(4529,'1','274','1',1,'Retail Sale Id 4427',996.96,0.00,0.00,1.34,105.86,'2022-08-30 18:53:37','',''),(4530,'1','274','1',1,'Retail Sale Id 4428',124329.84,0.00,0.00,167.11,13201.69,'2022-08-30 19:54:12','',''),(4531,'1','274','1',1,'Return of Retail Sale Id 4416',0.00,14136.00,19.00,0.00,-1501.00,'2022-08-30 19:56:39','',''),(4532,'1','274','1',1,'Retail Sale Id 4429',12216.48,0.00,0.00,16.42,1297.18,'2022-08-30 19:57:49','',''),(4533,'1','274','1',1,'Retail Sale Id 4430',996.96,0.00,0.00,1.34,105.86,'2022-08-31 07:18:31','',''),(4534,'1','274','1',1,'Retail Sale Id 4431',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 07:54:03','',''),(4535,'1','274','1',1,'Retail Sale Id 4432',37200.00,0.00,0.00,50.00,3950.00,'2022-08-31 12:07:58','',''),(4536,'1','274','1',1,'Retail Sale Id 4433',3801.84,0.00,0.00,5.11,403.69,'2022-08-31 12:42:45','',''),(4537,'1','274','1',1,'Retail Sale Id 4434',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 12:43:39','',''),(4538,'1','274','1',1,'Retail Sale Id 4435',7998.00,0.00,0.00,10.75,849.25,'2022-08-31 12:45:03','',''),(4539,'1','274','1',1,'Retail Sale Id 4436',5602.32,0.00,0.00,7.53,594.87,'2022-08-31 12:52:54','',''),(4540,'1','274','1',1,'Retail Sale Id 4437',2246.88,0.00,0.00,3.02,238.58,'2022-08-31 12:58:55','',''),(4541,'1','274','1',1,'Retail Sale Id 4438',1502.88,0.00,0.00,2.02,159.58,'2022-08-31 13:33:14','',''),(4542,'1','274','1',1,'Retail Sale Id 4439',22320.00,0.00,0.00,30.00,2370.00,'2022-08-31 13:39:39','',''),(4543,'1','274','1',1,'Retail Sale Id 4440',22349.76,0.00,0.00,30.04,2373.16,'2022-08-31 14:19:21','',''),(4544,'1','274','1',1,'Retail Sale Id 4441',4501.20,0.00,0.00,6.05,477.95,'2022-08-31 14:21:47','',''),(4545,'1','274','1',1,'Retail Sale Id 4442',37200.00,0.00,0.00,50.00,3950.00,'2022-08-31 14:23:43','',''),(4546,'1','274','1',1,'Retail Sale Id 4443',1502.88,0.00,0.00,2.02,159.58,'2022-08-31 14:39:43','',''),(4547,'1','274','1',1,'Retail Sale Id 4444',2298.96,0.00,0.00,3.09,244.11,'2022-08-31 14:52:08','',''),(4548,'1','274','1',1,'Retail Sale Id 4445',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 15:04:00','',''),(4549,'1','274','1',1,'Retail Sale Id 4446',2499.84,0.00,0.00,3.36,265.44,'2022-08-31 15:06:03','',''),(4550,'1','274','1',1,'Retail Sale Id 4447',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 15:09:18','',''),(4551,'1','274','1',1,'Retail Sale Id 4448',3749.76,0.00,0.00,5.04,398.16,'2022-08-31 15:13:44','',''),(4552,'1','274','1',1,'Retail Sale Id 4449',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 15:17:29','',''),(4553,'1','274','1',1,'Retail Sale Id 4450',7998.00,0.00,0.00,10.75,849.25,'2022-08-31 15:21:15','',''),(4554,'1','274','1',1,'Retail Sale Id 4451',4501.20,0.00,0.00,6.05,477.95,'2022-08-31 15:35:18','',''),(4555,'1','274','1',1,'Retail Sale Id 4452',5996.64,0.00,0.00,8.06,636.74,'2022-08-31 15:50:28','',''),(4556,'1','274','1',1,'Retail Sale Id 4454',2001.36,0.00,0.00,2.69,212.51,'2022-08-31 15:54:10','',''),(4557,'1','274','1',1,'Retail Sale Id 4456',1502.88,0.00,0.00,2.02,159.58,'2022-08-31 15:55:05','',''),(4558,'1','274','1',1,'Retail Sale Id 4457',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 16:38:48','',''),(4559,'1','274','1',1,'Retail Sale Id 4458',1502.88,0.00,0.00,2.02,159.58,'2022-08-31 16:39:57','',''),(4560,'1','274','1',1,'Retail Sale Id 4459',74400.00,0.00,0.00,100.00,7900.00,'2022-08-31 16:40:46','',''),(4561,'1','274','1',1,'Retail Sale Id 4460',1502.88,0.00,0.00,2.02,159.58,'2022-08-31 16:56:44','',''),(4562,'1','274','1',1,'Retail Sale Id 4461',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 17:15:15','',''),(4563,'1','274','1',1,'Retail Sale Id 4462',7001.04,0.00,0.00,9.41,743.39,'2022-08-31 17:19:15','',''),(4564,'1','274','1',1,'Retail Sale Id 4463',2001.36,0.00,0.00,2.69,212.51,'2022-08-31 17:23:19','',''),(4565,'1','274','1',1,'Retail Sale Id 4464',4501.20,0.00,0.00,6.05,477.95,'2022-08-31 17:24:03','',''),(4566,'1','274','1',1,'Retail Sale Id 4465',2246.88,0.00,0.00,3.02,238.58,'2022-08-31 17:25:58','',''),(4567,'1','274','1',1,'Retail Sale Id 4466',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 17:56:23','',''),(4568,'1','274','1',1,'Retail Sale Id 4467',91921.20,0.00,0.00,123.55,9760.45,'2022-08-31 17:57:55','',''),(4569,'1','274','1',1,'Retail Sale Id 4468',123615.60,0.00,0.00,166.15,13125.85,'2022-08-31 17:59:23','',''),(4570,'1','274','1',1,'Retail Sale Id 4469',4501.20,0.00,0.00,6.05,477.95,'2022-08-31 18:16:09','',''),(4571,'1','274','1',1,'Retail Sale Id 4470',2298.96,0.00,0.00,3.09,244.11,'2022-08-31 18:17:37','',''),(4572,'1','274','1',1,'Retail Sale Id 4471',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 18:18:23','',''),(4573,'1','274','1',1,'Retail Sale Id 4472',10497.84,0.00,0.00,14.11,1114.69,'2022-08-31 18:25:12','',''),(4574,'1','274','1',1,'Retail Sale Id 4473',498.48,0.00,0.00,0.67,52.93,'2022-08-31 18:25:59','',''),(4575,'1','274','1',1,'Retail Sale Id 4474',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 18:28:34','',''),(4576,'1','274','1',1,'Retail Sale Id 4475',9300.00,0.00,0.00,12.50,987.50,'2022-08-31 18:31:27','',''),(4577,'1','274','1',1,'Retail Sale Id 4476',4501.20,0.00,0.00,6.05,477.95,'2022-08-31 18:35:08','',''),(4578,'1','274','1',1,'Retail Sale Id 4477',2001.36,0.00,0.00,2.69,212.51,'2022-08-31 18:44:53','',''),(4579,'1','274','1',1,'Retail Sale Id 4478',4002.72,0.00,0.00,5.38,425.02,'2022-08-31 18:50:29','',''),(4580,'1','274','1',1,'Retail Sale Id 4479',4501.20,0.00,0.00,6.05,477.95,'2022-08-31 18:51:24','',''),(4581,'1','274','1',1,'Retail Sale Id 4480',37200.00,0.00,0.00,50.00,3950.00,'2022-08-31 18:53:34','',''),(4582,'1','274','1',1,'Return of Retail Sale Id 4480',0.00,37200.00,50.00,0.00,-3950.00,'2022-08-31 19:23:11','',''),(4583,'1','274','1',1,'Retail Sale Id 4481',22297.68,0.00,0.00,29.97,2367.63,'2022-08-31 19:24:17','',''),(4584,'1','274','1',1,'Retail Sale Id 4482',31404.24,0.00,0.00,42.21,3334.59,'2022-08-31 19:25:29','',''),(4585,'1','274','1',1,'Retail Sale Id 4483',4464.00,0.00,0.00,6.00,474.00,'2022-09-01 06:55:04','',''),(4586,'1','274','1',1,'Retail Sale Id 4484',9300.00,0.00,0.00,12.50,987.50,'2022-09-01 06:55:58','',''),(4587,'1','274','1',1,'Retail Sale Id 4485',4501.20,0.00,0.00,6.05,477.95,'2022-09-01 08:15:07','',''),(4588,'1','274','1',1,'Retail Sale Id 4486',8198.88,0.00,0.00,11.02,870.58,'2022-09-01 08:16:32','',''),(4589,'1','274','1',1,'Retail Sale Id 4487',996.96,0.00,0.00,1.34,105.86,'2022-09-01 08:17:20','',''),(4590,'1','274','1',1,'Retail Sale Id 4488',22320.00,0.00,0.00,30.00,2370.00,'2022-09-01 10:34:13','',''),(4591,'1','274','1',1,'Retail Sale Id 4490',22349.76,0.00,0.00,30.04,2373.16,'2022-09-01 10:36:08','',''),(4592,'1','274','1',1,'Retail Sale Id 4491',4501.20,0.00,0.00,6.05,477.95,'2022-09-01 12:16:34','',''),(4593,'1','274','1',1,'Retail Sale Id 4492',3749.76,0.00,0.00,5.04,398.16,'2022-09-01 12:18:00','',''),(4594,'1','274','1',1,'Retail Sale Id 4493',46500.00,0.00,0.00,62.50,4937.50,'2022-09-01 12:19:55','',''),(4595,'1','274','1',1,'Retail Sale Id 4494',1502.88,0.00,0.00,2.02,159.58,'2022-09-01 12:23:45','',''),(4596,'1','274','1',1,'Retail Sale Id 4495',3749.76,0.00,0.00,5.04,398.16,'2022-09-01 12:32:16','',''),(4597,'1','274','1',1,'Retail Sale Id 4496',9300.00,0.00,0.00,12.50,987.50,'2022-09-01 12:34:04','',''),(4598,'1','274','1',1,'Retail Sale Id 4497',2998.32,0.00,0.00,4.03,318.37,'2022-09-01 12:36:06','',''),(4599,'1','274','1',1,'Retail Sale Id 4498',2001.36,0.00,0.00,2.69,212.51,'2022-09-01 13:25:57','',''),(4600,'1','274','1',1,'Retail Sale Id 4499',9300.00,0.00,0.00,12.50,987.50,'2022-09-01 13:27:15','',''),(4601,'1','274','1',1,'Retail Sale Id 4500',4501.20,0.00,0.00,6.05,477.95,'2022-09-01 13:36:03','',''),(4602,'1','274','1',1,'Retail Sale Id 4501',9300.00,0.00,0.00,12.50,987.50,'2022-09-01 14:09:53','',''),(4603,'1','274','1',1,'Retail Sale Id 4502',39647.76,0.00,0.00,53.29,4209.91,'2022-09-01 14:17:42','',''),(4604,'1','274','1',1,'Retail Sale Id 4503',5758.56,0.00,0.00,7.74,611.46,'2022-09-01 14:21:48','',''),(4605,'1','274','1',1,'Retail Sale Id 4503',5952.00,0.00,0.00,8.00,632.00,'2022-09-01 14:21:48','',''),(4606,'1','274','1',1,'Retail Sale Id 4503',9300.00,0.00,0.00,12.50,987.50,'2022-09-01 14:21:48','',''),(4607,'1','274','1',1,'Retail Sale Id 4503',37200.00,0.00,0.00,50.00,3950.00,'2022-09-01 14:21:48','',''),(4608,'1','274','1',1,'Retail Sale Id 4504',996.96,0.00,0.00,1.34,105.86,'2022-09-01 14:22:59','',''),(4609,'1','274','1',1,'Retail Sale Id 4505',18600.00,0.00,0.00,25.00,1975.00,'2022-09-01 14:24:31','',''),(4610,'1','274','1',1,'Retail Sale Id 4507',9300.00,0.00,0.00,12.50,987.50,'2022-09-01 14:26:00','',''),(4611,'1','274','1',1,'Retail Sale Id 4508',1502.88,0.00,0.00,2.02,159.58,'2022-09-01 14:34:35','',''),(4612,'1','274','1',1,'Retail Sale Id 4509',803.52,0.00,0.00,1.08,85.32,'2022-09-01 14:35:42','',''),(4613,'1','274','1',1,'Retail Sale Id 4510',4002.72,0.00,0.00,5.38,425.02,'2022-09-01 14:49:52','',''),(4614,'1','274','1',1,'Retail Sale Id 4511',7499.52,0.00,0.00,10.08,796.32,'2022-09-01 14:56:10','',''),(4615,'1','274','1',1,'Retail Sale Id 4512',2998.32,0.00,0.00,4.03,318.37,'2022-09-01 15:01:50','',''),(4616,'1','274','1',1,'Retail Sale Id 4513',2246.88,0.00,0.00,3.02,238.58,'2022-09-01 15:09:11','',''),(4617,'1','274','1',1,'Retail Sale Id 4514',2998.32,0.00,0.00,4.03,318.37,'2022-09-01 15:17:31','',''),(4618,'1','274','1',1,'Retail Sale Id 4515',2246.88,0.00,0.00,3.02,238.58,'2022-09-01 15:20:50','',''),(4619,'1','274','1',1,'Retail Sale Id 4516',4501.20,0.00,0.00,6.05,477.95,'2022-09-01 15:22:00','',''),(4620,'1','274','1',1,'Retail Sale Id 4517',1502.88,0.00,0.00,2.02,159.58,'2022-09-01 15:24:53','',''),(4621,'1','274','1',1,'Retail Sale Id 4518',37200.00,0.00,0.00,50.00,3950.00,'2022-09-01 15:31:26','',''),(4622,'1','274','1',1,'Retail Sale Id 4519',2998.32,0.00,0.00,4.03,318.37,'2022-09-01 15:36:32','',''),(4623,'1','274','1',1,'Retail Sale Id 4520',2001.36,0.00,0.00,2.69,212.51,'2022-09-01 15:38:00','',''),(4624,'1','274','1',1,'Retail Sale Id 4521',2499.84,0.00,0.00,3.36,265.44,'2022-09-01 15:40:00','',''),(4625,'1','274','1',1,'Retail Sale Id 4522',9300.00,0.00,0.00,12.50,987.50,'2022-09-01 15:42:41','',''),(4626,'1','274','1',1,'Retail Sale Id 4523',4501.20,0.00,0.00,6.05,477.95,'2022-09-01 15:43:57','',''),(4627,'1','274','1',1,'Retail Sale Id 4524',4501.20,0.00,0.00,6.05,477.95,'2022-09-01 15:48:02','',''),(4628,'1','274','1',1,'Retail Sale Id 4525',9300.00,0.00,0.00,12.50,987.50,'2022-09-01 15:50:24','',''),(4629,'1','274','1',1,'Retail Sale Id 4526',18600.00,0.00,0.00,25.00,1975.00,'2022-09-01 15:52:25','',''),(4630,'1','274','1',1,'Retail Sale Id 4527',9300.00,0.00,0.00,12.50,987.50,'2022-09-01 15:54:01','',''),(4631,'1','274','1',1,'Retail Sale Id 4528',4501.20,0.00,0.00,6.05,477.95,'2022-09-01 16:00:55','',''),(4632,'1','274','1',1,'Retail Sale Id 4529',4501.20,0.00,0.00,6.05,477.95,'2022-09-01 16:14:11','',''),(4633,'1','274','1',1,'Retail Sale Id 4530',9300.00,0.00,0.00,12.50,987.50,'2022-09-01 16:15:37','',''),(4634,'1','274','1',1,'Retail Sale Id 4531',2246.88,0.00,0.00,3.02,238.58,'2022-09-01 16:17:47','',''),(4635,'1','274','1',1,'Retail Sale Id 4532',2499.84,0.00,0.00,3.36,265.44,'2022-09-01 16:26:41','',''),(4636,'1','274','1',1,'Retail Sale Id 4533',4501.20,0.00,0.00,6.05,477.95,'2022-09-01 16:28:57','',''),(4637,'1','274','1',1,'Retail Sale Id 4534',2998.32,0.00,0.00,4.03,318.37,'2022-09-01 16:32:36','',''),(4638,'1','274','1',1,'Retail Sale Id 4536',23101.20,0.00,0.00,31.05,2452.95,'2022-09-01 16:34:50','',''),(4639,'1','274','1',1,'Retail Sale Id 4537',4501.20,0.00,0.00,6.05,477.95,'2022-09-01 16:39:33','',''),(4640,'1','274','1',1,'Retail Sale Id 4538',2246.88,0.00,0.00,3.02,238.58,'2022-09-01 16:41:58','',''),(4641,'1','274','1',1,'Retail Sale Id 4539',1502.88,0.00,0.00,2.02,159.58,'2022-09-01 16:49:50','',''),(4642,'1','274','1',1,'Retail Sale Id 4540',4999.68,0.00,0.00,6.72,530.88,'2022-09-01 16:50:40','',''),(4643,'1','274','1',1,'Retail Sale Id 4541',2998.32,0.00,0.00,4.03,318.37,'2022-09-01 16:54:32','',''),(4644,'1','274','1',1,'Retail Sale Id 4542',4501.20,0.00,0.00,6.05,477.95,'2022-09-01 16:56:08','',''),(4645,'1','274','1',1,'Retail Sale Id 4543',74400.00,0.00,0.00,100.00,7900.00,'2022-09-01 17:01:44','',''),(4646,'1','274','1',1,'Retail Sale Id 4544',22498.56,0.00,0.00,30.24,2388.96,'2022-09-01 17:02:19','',''),(4647,'1','274','1',1,'Retail Sale Id 4545',1502.88,0.00,0.00,2.02,159.58,'2022-09-01 17:02:54','',''),(4648,'1','274','1',1,'Retail Sale Id 4546',9672.00,0.00,0.00,13.00,1027.00,'2022-09-01 17:23:11','',''),(4649,'1','274','1',1,'Retail Sale Id 4547',9701.76,0.00,0.00,13.04,1030.16,'2022-09-01 17:23:53','',''),(4650,'1','274','1',1,'Retail Sale Id 4549',4999.68,0.00,0.00,6.72,530.88,'2022-09-01 17:26:55','',''),(4651,'1','274','1',1,'Retail Sale Id 4550',3749.76,0.00,0.00,5.04,398.16,'2022-09-01 17:27:40','',''),(4652,'1','274','1',1,'Retail Sale Id 4551',4002.72,0.00,0.00,5.38,425.02,'2022-09-01 17:28:47','',''),(4653,'1','274','1',1,'Retail Sale Id 4552',803.52,0.00,0.00,1.08,85.32,'2022-09-01 17:33:06','',''),(4654,'1','274','1',1,'Retail Sale Id 4553',9300.00,0.00,0.00,12.50,987.50,'2022-09-01 17:35:53','',''),(4655,'1','274','1',1,'Retail Sale Id 4554',32401.20,0.00,0.00,43.55,3440.45,'2022-09-01 17:40:38','',''),(4656,'1','274','1',1,'Retail Sale Id 4555',2001.36,0.00,0.00,2.69,212.51,'2022-09-01 17:42:37','',''),(4657,'1','274','1',1,'Retail Sale Id 4556',996.96,0.00,0.00,1.34,105.86,'2022-09-01 17:44:10','',''),(4658,'1','274','1',1,'Retail Sale Id 4557',8198.88,0.00,0.00,11.02,870.58,'2022-09-01 17:45:15','',''),(4659,'1','274','1',1,'Retail Sale Id 4560',2499.84,0.00,0.00,3.36,265.44,'2022-09-01 17:50:28','',''),(4660,'1','274','1',1,'Retail Sale Id 4562',9300.00,0.00,0.00,12.50,987.50,'2022-09-01 17:51:48','',''),(4661,'1','274','1',1,'Retail Sale Id 4563',3749.76,0.00,0.00,5.04,398.16,'2022-09-01 18:02:03','',''),(4662,'1','274','1',1,'Retail Sale Id 4564',2246.88,0.00,0.00,3.02,238.58,'2022-09-01 18:03:03','',''),(4663,'1','274','1',1,'Retail Sale Id 4565',9300.00,0.00,0.00,12.50,987.50,'2022-09-01 18:03:53','',''),(4664,'1','274','1',1,'Retail Sale Id 4566',2001.36,0.00,0.00,2.69,212.51,'2022-09-01 18:07:23','',''),(4665,'1','274','1',1,'Retail Sale Id 4567',18600.00,0.00,0.00,25.00,1975.00,'2022-09-01 18:08:38','',''),(4666,'1','274','1',1,'Retail Sale Id 4568',9300.00,0.00,0.00,12.50,987.50,'2022-09-01 18:09:53','',''),(4667,'1','274','1',1,'Retail Sale Id 4569',996.96,0.00,0.00,1.34,105.86,'2022-09-01 18:21:17','',''),(4668,'1','274','1',1,'Retail Sale Id 4570',3801.84,0.00,0.00,5.11,403.69,'2022-09-01 18:22:48','',''),(4669,'1','274','1',1,'Retail Sale Id 4571',22349.76,0.00,0.00,30.04,2373.16,'2022-09-01 18:23:55','',''),(4670,'1','274','1',1,'Retail Sale Id 4572',9300.00,0.00,0.00,12.50,987.50,'2022-09-01 18:25:49','',''),(4671,'1','274','1',1,'Retail Sale Id 4573',3749.76,0.00,0.00,5.04,398.16,'2022-09-01 18:27:18','',''),(4672,'1','274','1',1,'Retail Sale Id 4574',9300.00,0.00,0.00,12.50,987.50,'2022-09-01 18:28:23','',''),(4673,'1','274','1',1,'Retail Sale Id 4575',1502.88,0.00,0.00,2.02,159.58,'2022-09-01 18:29:17','',''),(4674,'1','274','1',1,'Retail Sale Id 4576',9300.00,0.00,0.00,12.50,987.50,'2022-09-01 18:30:18','',''),(4675,'1','274','1',1,'Retail Sale Id 4577',2246.88,0.00,0.00,3.02,238.58,'2022-09-01 18:37:21','',''),(4676,'1','274','1',1,'Return of Retail Sale Id 4571',0.00,22349.76,30.04,0.00,-2373.16,'2022-09-01 19:23:08','',''),(4677,'1','274','1',1,'Retail Sale Id 4578',282169.44,0.00,0.00,379.26,29961.54,'2022-09-01 19:24:20','',''),(4678,'1','274','1',1,'Return of Retail Sale Id 4577',0.00,2246.88,3.02,0.00,-238.58,'2022-09-01 19:24:44','',''),(4679,'1','274','1',1,'Return of Retail Sale Id 4574',0.00,9300.00,12.50,0.00,-987.50,'2022-09-01 19:27:37','',''),(4680,'1','274','1',1,'Retail Sale Id 4579',7663.20,0.00,0.00,10.30,813.70,'2022-09-01 19:31:37','',''),(4681,'1','274','1',1,'Retail Sale Id 4580',3720.00,0.00,0.00,5.00,395.00,'2022-09-02 07:05:37','',''),(4682,'1','274','1',1,'Retail Sale Id 4581',9300.00,0.00,0.00,12.50,987.50,'2022-09-02 08:28:18','',''),(4683,'1','274','1',1,'Retail Sale Id 4582',7440.00,0.00,0.00,10.00,790.00,'2022-09-02 08:29:02','',''),(4684,'1','274','1',1,'Retail Sale Id 4583',9300.00,0.00,0.00,12.50,987.50,'2022-09-02 10:08:57','',''),(4685,'1','274','1',1,'Retail Sale Id 4584',4999.68,0.00,0.00,6.72,530.88,'2022-09-02 10:20:56','',''),(4686,'1','274','1',1,'Retail Sale Id 4585',9300.00,0.00,0.00,12.50,987.50,'2022-09-02 10:42:52','',''),(4687,'1','274','1',1,'Retail Sale Id 4586',2246.88,0.00,0.00,3.02,238.58,'2022-09-02 11:06:40','',''),(4688,'1','274','1',1,'Retail Sale Id 4587',27528.00,0.00,0.00,37.00,2923.00,'2022-09-02 11:15:22','',''),(4689,'1','274','1',1,'Retail Sale Id 4588',27699.12,0.00,0.00,37.23,2941.17,'2022-09-02 11:17:54','',''),(4690,'1','274','1',1,'Return of Retail Sale Id 4587',0.00,27528.00,37.00,0.00,-2923.00,'2022-09-02 11:22:55','',''),(4691,'1','274','1',1,'Retail Sale Id 4589',81237.36,0.00,0.00,109.19,8626.01,'2022-09-02 11:24:31','',''),(4692,'1','274','1',1,'Retail Sale Id 4590',3749.76,0.00,0.00,5.04,398.16,'2022-09-02 11:26:45','',''),(4693,'1','274','1',1,'Retail Sale Id 4591',1502.88,0.00,0.00,2.02,159.58,'2022-09-02 11:27:50','',''),(4694,'1','274','1',1,'Retail Sale Id 4592',2001.36,0.00,0.00,2.69,212.51,'2022-09-02 11:28:39','',''),(4695,'1','274','1',1,'Retail Sale Id 4593',9300.00,0.00,0.00,12.50,987.50,'2022-09-02 11:30:00','',''),(4696,'1','274','1',1,'Retail Sale Id 4594',7998.00,0.00,0.00,10.75,849.25,'2022-09-02 11:41:45','',''),(4697,'1','274','1',1,'Retail Sale Id 4595',2246.88,0.00,0.00,3.02,238.58,'2022-09-02 11:45:25','',''),(4698,'1','274','1',1,'Retail Sale Id 4595',5996.64,0.00,0.00,8.06,636.74,'2022-09-02 11:45:25','',''),(4699,'1','274','1',1,'Retail Sale Id 4596',9300.00,0.00,0.00,12.50,987.50,'2022-09-02 11:52:17','',''),(4700,'1','274','1',1,'Retail Sale Id 4597',74400.00,0.00,0.00,100.00,7900.00,'2022-09-02 12:44:18','',''),(4701,'1','274','1',1,'Retail Sale Id 4598',4501.20,0.00,0.00,6.05,477.95,'2022-09-02 14:20:16','',''),(4702,'1','274','1',1,'Retail Sale Id 4599',1502.88,0.00,0.00,2.02,159.58,'2022-09-02 14:22:38','',''),(4703,'1','274','1',1,'Retail Sale Id 4600',9300.00,0.00,0.00,12.50,987.50,'2022-09-02 14:38:04','',''),(4704,'1','274','1',1,'Retail Sale Id 4601',2001.36,0.00,0.00,2.69,212.51,'2022-09-02 14:53:40','',''),(4705,'1','274','1',1,'Retail Sale Id 4602',9300.00,0.00,0.00,12.50,987.50,'2022-09-02 16:21:50','',''),(4706,'1','274','1',1,'Retail Sale Id 4603',46500.00,0.00,0.00,62.50,4937.50,'2022-09-02 16:29:49','',''),(4707,'1','274','1',1,'Retail Sale Id 4604',5252.64,0.00,0.00,7.06,557.74,'2022-09-02 16:36:33','',''),(4708,'1','274','1',1,'Retail Sale Id 4605',2246.88,0.00,0.00,3.02,238.58,'2022-09-02 16:43:03','',''),(4709,'1','274','1',1,'Retail Sale Id 4606',2246.88,0.00,0.00,3.02,238.58,'2022-09-02 16:49:06','',''),(4710,'1','274','1',1,'Retail Sale Id 4606',27900.00,0.00,0.00,37.50,2962.50,'2022-09-02 16:49:06','',''),(4711,'1','274','1',1,'Retail Sale Id 4607',9300.00,0.00,0.00,12.50,987.50,'2022-09-02 16:53:53','',''),(4712,'1','274','1',1,'Retail Sale Id 4608',4002.72,0.00,0.00,5.38,425.02,'2022-09-02 16:56:05','',''),(4713,'1','274','1',1,'Retail Sale Id 4609',9300.00,0.00,0.00,12.50,987.50,'2022-09-02 16:58:02','',''),(4714,'1','274','1',1,'Retail Sale Id 4610',4501.20,0.00,0.00,6.05,477.95,'2022-09-02 17:04:14','',''),(4715,'1','274','1',1,'Retail Sale Id 4611',4002.72,0.00,0.00,5.38,425.02,'2022-09-02 17:33:23','',''),(4716,'1','274','1',1,'Retail Sale Id 4612',2998.32,0.00,0.00,4.03,318.37,'2022-09-02 17:34:09','',''),(4717,'1','274','1',1,'Retail Sale Id 4613',9300.00,0.00,0.00,12.50,987.50,'2022-09-02 17:35:43','',''),(4718,'1','274','1',1,'Retail Sale Id 4614',7499.52,0.00,0.00,10.08,796.32,'2022-09-02 17:36:35','',''),(4719,'1','274','1',1,'Retail Sale Id 4615',9300.00,0.00,0.00,12.50,987.50,'2022-09-02 17:41:45','',''),(4720,'1','274','1',1,'Retail Sale Id 4616',9500.88,0.00,0.00,12.77,1008.83,'2022-09-02 17:46:57','',''),(4721,'1','274','1',1,'Retail Sale Id 4617',3846.48,0.00,0.00,5.17,408.43,'2022-09-02 17:48:30','',''),(4722,'1','274','1',1,'Retail Sale Id 4618',1502.88,0.00,0.00,2.02,159.58,'2022-09-02 17:49:29','',''),(4723,'1','274','1',1,'Retail Sale Id 4619',2001.36,0.00,0.00,2.69,212.51,'2022-09-02 18:05:11','',''),(4724,'1','274','1',1,'Retail Sale Id 4620',9300.00,0.00,0.00,12.50,987.50,'2022-09-02 18:25:12','',''),(4725,'1','274','1',1,'Return of Retail Sale Id 4597',0.00,74400.00,100.00,0.00,-7900.00,'2022-09-02 19:19:26','',''),(4726,'1','274','1',1,'Retail Sale Id 4621',59326.56,0.00,0.00,79.74,6299.46,'2022-09-02 19:23:26','',''),(4727,'1','274','1',1,'Retail Sale Id 4622',96846.48,0.00,0.00,130.17,10283.43,'2022-09-02 19:25:05','',''),(4728,'1','274','1',1,'Retail Sale Id 4623',29998.08,0.00,0.00,40.32,3185.28,'2022-09-03 07:06:43','',''),(4729,'1','274','1',1,'Retail Sale Id 4624',9404.16,0.00,0.00,12.64,998.56,'2022-09-03 07:55:07','',''),(4730,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9443.00,14.20,0.00,0.00,'2022-09-03 08:01:38','',''),(4731,'1','274',NULL,1,'Reception corrector for bridging 44',0.00,0.00,0.00,14.20,0.00,'2022-09-03 08:02:39','',''),(4732,'1','274','1',1,'Received from bridging 44',0.00,0.00,14.20,0.00,0.00,'2022-09-03 08:02:39','',''),(4733,'1','274','1',1,'Retail Sale Id 4625',8332.80,0.00,0.00,11.20,884.80,'2022-09-03 08:04:08','',''),(4734,'1','274','1',1,'Retail Sale Id 4626',2232.00,0.00,0.00,3.00,237.00,'2022-09-03 08:04:48','',''),(4735,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,665000.00,1000.00,0.00,0.00,'2022-09-03 09:52:28','',''),(4736,'1','274',NULL,1,'Reception corrector for bridging 45',0.00,0.00,0.00,1000.00,0.00,'2022-09-03 09:53:54','',''),(4737,'1','274','1',1,'Received from bridging 45',0.00,0.00,1000.00,0.00,0.00,'2022-09-03 09:53:54','',''),(4738,'1','274','1',1,'Retail Sale Id 4627',29752.56,0.00,0.00,39.99,3159.21,'2022-09-03 11:18:55','',''),(4739,'1','274','1',1,'Retail Sale Id 4628',29797.20,0.00,0.00,40.05,3163.95,'2022-09-03 11:21:24','',''),(4740,'1','274','1',1,'Retail Sale Id 4629',14902.32,0.00,0.00,20.03,1582.37,'2022-09-03 11:22:44','',''),(4741,'1','274','1',1,'Retail Sale Id 4630',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 11:23:36','',''),(4742,'1','274','1',1,'Retail Sale Id 4633',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 12:05:24','',''),(4743,'1','274','1',1,'Retail Sale Id 4634',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 12:07:24','',''),(4744,'1','274','1',1,'Retail Sale Id 4635',1502.88,0.00,0.00,2.02,159.58,'2022-09-03 12:12:02','',''),(4745,'1','274','1',1,'Retail Sale Id 4636',17997.36,0.00,0.00,24.19,1911.01,'2022-09-03 12:13:42','',''),(4746,'1','274','1',1,'Retail Sale Id 4637',4002.72,0.00,0.00,5.38,425.02,'2022-09-03 12:23:55','',''),(4747,'1','274','1',1,'Retail Sale Id 4639',2499.84,0.00,0.00,3.36,265.44,'2022-09-03 12:31:46','',''),(4748,'1','274','1',1,'Retail Sale Id 4640',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 12:46:07','',''),(4749,'1','274','1',1,'Retail Sale Id 4641',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 12:50:38','',''),(4750,'1','274','1',1,'Retail Sale Id 4642',9701.76,0.00,0.00,13.04,1030.16,'2022-09-03 12:52:58','',''),(4751,'1','274','1',1,'Retail Sale Id 4643',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 12:55:06','',''),(4752,'1','274','1',1,'Retail Sale Id 4644',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 12:58:24','',''),(4753,'1','274','1',1,'Retail Sale Id 4645',1502.88,0.00,0.00,2.02,159.58,'2022-09-03 12:59:19','',''),(4754,'1','274','1',1,'Retail Sale Id 4646',2001.36,0.00,0.00,2.69,212.51,'2022-09-03 13:01:50','',''),(4755,'1','274','1',1,'Retail Sale Id 4647',2098.08,0.00,0.00,2.82,222.78,'2022-09-03 13:06:33','',''),(4756,'1','274','1',1,'Retail Sale Id 4648',13049.76,0.00,0.00,17.54,1385.66,'2022-09-03 13:12:51','',''),(4757,'1','274','1',1,'Retail Sale Id 4649',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 13:20:17','',''),(4758,'1','274','1',1,'Retail Sale Id 4650',4501.20,0.00,0.00,6.05,477.95,'2022-09-03 13:25:54','',''),(4759,'1','274','1',1,'Retail Sale Id 4651',4501.20,0.00,0.00,6.05,477.95,'2022-09-03 13:44:01','',''),(4760,'1','274','1',1,'Retail Sale Id 4652',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 13:53:36','',''),(4761,'1','274','1',1,'Retail Sale Id 4653',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 13:57:51','',''),(4762,'1','274','1',1,'Retail Sale Id 4654',4501.20,0.00,0.00,6.05,477.95,'2022-09-03 14:04:19','',''),(4763,'1','274','1',1,'Retail Sale Id 4655',2001.36,0.00,0.00,2.69,212.51,'2022-09-03 14:07:06','',''),(4764,'1','274','1',1,'Retail Sale Id 4656',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 14:16:45','',''),(4765,'1','274','1',1,'Retail Sale Id 4657',2246.88,0.00,0.00,3.02,238.58,'2022-09-03 14:19:32','',''),(4766,'1','274','1',1,'Retail Sale Id 4658',4501.20,0.00,0.00,6.05,477.95,'2022-09-03 14:24:27','',''),(4767,'1','274','1',1,'Retail Sale Id 4659',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 14:26:29','',''),(4768,'1','274','1',1,'Retail Sale Id 4660',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 14:28:00','',''),(4769,'1','274','1',1,'Retail Sale Id 4661',2246.88,0.00,0.00,3.02,238.58,'2022-09-03 14:28:40','',''),(4770,'1','274','1',1,'Retail Sale Id 4662',3749.76,0.00,0.00,5.04,398.16,'2022-09-03 14:33:53','',''),(4771,'1','274','1',1,'Retail Sale Id 4663',18600.00,0.00,0.00,25.00,1975.00,'2022-09-03 14:35:41','',''),(4772,'1','274','1',1,'Retail Sale Id 4664',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 14:40:41','',''),(4773,'1','274','1',1,'Retail Sale Id 4665',8801.52,0.00,0.00,11.83,934.57,'2022-09-03 14:42:14','',''),(4774,'1','274','1',1,'Retail Sale Id 4666',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 14:43:49','',''),(4775,'1','274','1',1,'Retail Sale Id 4667',7499.52,0.00,0.00,10.08,796.32,'2022-09-03 14:48:57','',''),(4776,'1','274','1',1,'Retail Sale Id 4668',2246.88,0.00,0.00,3.02,238.58,'2022-09-03 14:50:52','',''),(4777,'1','274','1',1,'Retail Sale Id 4669',2001.36,0.00,0.00,2.69,212.51,'2022-09-03 14:54:16','',''),(4778,'1','274','1',1,'Retail Sale Id 4670',1502.88,0.00,0.00,2.02,159.58,'2022-09-03 14:57:32','',''),(4779,'1','274','1',1,'Retail Sale Id 4671',4501.20,0.00,0.00,6.05,477.95,'2022-09-03 15:08:11','',''),(4780,'1','274','1',1,'Retail Sale Id 4672',1502.88,0.00,0.00,2.02,159.58,'2022-09-03 15:12:11','',''),(4781,'1','274','1',1,'Retail Sale Id 4673',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 15:18:12','',''),(4782,'1','274','1',1,'Retail Sale Id 4674',1502.88,0.00,0.00,2.02,159.58,'2022-09-03 15:24:19','',''),(4783,'1','274','1',1,'Retail Sale Id 4675',4501.20,0.00,0.00,6.05,477.95,'2022-09-03 15:40:48','',''),(4784,'1','274','1',1,'Retail Sale Id 4676',2246.88,0.00,0.00,3.02,238.58,'2022-09-03 15:43:39','',''),(4785,'1','274','1',1,'Retail Sale Id 4677',2001.36,0.00,0.00,2.69,212.51,'2022-09-03 15:47:30','',''),(4786,'1','274','1',1,'Retail Sale Id 4678',2499.84,0.00,0.00,3.36,265.44,'2022-09-03 15:49:03','',''),(4787,'1','274','1',1,'Retail Sale Id 4679',2001.36,0.00,0.00,2.69,212.51,'2022-09-03 15:50:03','',''),(4788,'1','274','1',1,'Retail Sale Id 4680',2298.96,0.00,0.00,3.09,244.11,'2022-09-03 15:58:21','',''),(4789,'1','274','1',1,'Retail Sale Id 4681',18600.00,0.00,0.00,25.00,1975.00,'2022-09-03 15:59:35','',''),(4790,'1','274','1',1,'Retail Sale Id 4682',996.96,0.00,0.00,1.34,105.86,'2022-09-03 16:01:23','',''),(4791,'1','274','1',1,'Retail Sale Id 4683',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 16:10:13','',''),(4792,'1','274','1',1,'Retail Sale Id 4684',2998.32,0.00,0.00,4.03,318.37,'2022-09-03 16:11:40','',''),(4793,'1','274','1',1,'Retail Sale Id 4685',2499.84,0.00,0.00,3.36,265.44,'2022-09-03 16:19:51','',''),(4794,'1','274','1',1,'Retail Sale Id 4686',27900.00,0.00,0.00,37.50,2962.50,'2022-09-03 16:28:14','',''),(4795,'1','274','1',1,'Retail Sale Id 4687',3749.76,0.00,0.00,5.04,398.16,'2022-09-03 17:06:54','',''),(4796,'1','274','1',1,'Retail Sale Id 4689',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 17:12:55','',''),(4797,'1','274','1',1,'Retail Sale Id 4690',4501.20,0.00,0.00,6.05,477.95,'2022-09-03 17:25:23','',''),(4798,'1','274','1',1,'Retail Sale Id 4691',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 17:36:36','',''),(4799,'1','274','1',1,'Retail Sale Id 4692',4501.20,0.00,0.00,6.05,477.95,'2022-09-03 17:43:34','',''),(4800,'1','274','1',1,'Retail Sale Id 4693',13801.20,0.00,0.00,18.55,1465.45,'2022-09-03 17:47:17','',''),(4801,'1','274','1',1,'Retail Sale Id 4694',4501.20,0.00,0.00,6.05,477.95,'2022-09-03 18:18:55','',''),(4802,'1','274','1',1,'Retail Sale Id 4695',4501.20,0.00,0.00,6.05,477.95,'2022-09-03 18:20:14','',''),(4803,'1','274','1',1,'Retail Sale Id 4696',12997.68,0.00,0.00,17.47,1380.13,'2022-09-03 18:21:39','',''),(4804,'1','274','1',1,'Retail Sale Id 4697',2797.44,0.00,0.00,3.76,297.04,'2022-09-03 18:34:47','',''),(4805,'1','274','1',1,'Retail Sale Id 4698',9300.00,0.00,0.00,12.50,987.50,'2022-09-03 18:44:29','',''),(4806,'1','274','1',1,'Return of Retail Sale Id 4696',0.00,12997.68,17.47,0.00,-1380.13,'2022-09-03 19:15:18','',''),(4807,'1','274','1',1,'Return of Retail Sale Id 4698',0.00,9300.00,12.50,0.00,-987.50,'2022-09-03 19:16:20','',''),(4808,'1','274','1',1,'Return of Retail Sale Id 4673',0.00,9300.00,12.50,0.00,-987.50,'2022-09-03 19:18:23','',''),(4809,'1','274','1',1,'Return of Retail Sale Id 4689',0.00,9300.00,12.50,0.00,-987.50,'2022-09-03 19:19:00','',''),(4810,'1','274','1',1,'Return of Retail Sale Id 4691',0.00,9300.00,12.50,0.00,-987.50,'2022-09-03 19:19:38','',''),(4811,'1','274','1',1,'Return of Retail Sale Id 4656',0.00,9300.00,12.50,0.00,-987.50,'2022-09-03 19:20:32','',''),(4812,'1','274','1',1,'Return of Retail Sale Id 4681',0.00,18600.00,25.00,0.00,-1975.00,'2022-09-03 19:22:50','',''),(4813,'1','274','1',1,'Return of Retail Sale Id 4686',0.00,27900.00,37.50,0.00,-2962.50,'2022-09-03 19:23:47','',''),(4814,'1','274','1',1,'Retail Sale Id 4699',6465.36,0.00,0.00,8.69,686.51,'2022-09-03 19:25:55','',''),(4815,'1','274','1',1,'Retail Sale Id 4700',132982.56,0.00,0.00,178.74,14120.46,'2022-09-03 19:27:12','',''),(4816,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,1443050.00,2170.00,0.00,0.00,'2022-09-03 19:35:05','',''),(4817,'1','274',NULL,1,'Reception corrector for bridging 46',0.00,0.00,0.00,2170.00,0.00,'2022-09-03 19:36:17','',''),(4818,'1','274','1',1,'Received from bridging 46',0.00,0.00,2170.00,0.00,0.00,'2022-09-03 19:36:17','',''),(4819,'1','274','1',1,'Retail Sale Id 4701',7440.00,0.00,0.00,10.00,790.00,'2022-09-04 06:30:27','',''),(4820,'1','274','1',1,'Retail Sale Id 4702',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 08:45:36','',''),(4821,'1','274','1',1,'Retail Sale Id 4703',44640.00,0.00,0.00,60.00,4740.00,'2022-09-04 09:09:06','',''),(4822,'1','274','1',1,'Retail Sale Id 4704',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 09:12:25','',''),(4823,'1','274','1',1,'Retail Sale Id 4705',1502.88,0.00,0.00,2.02,159.58,'2022-09-04 09:15:38','',''),(4824,'1','274','1',1,'Retail Sale Id 4706',7998.00,0.00,0.00,10.75,849.25,'2022-09-04 09:18:20','',''),(4825,'1','274','1',1,'Retail Sale Id 4707',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 09:21:15','',''),(4826,'1','274','1',1,'Retail Sale Id 4708',7001.04,0.00,0.00,9.41,743.39,'2022-09-04 09:49:10','',''),(4827,'1','274','1',1,'Retail Sale Id 4709',2998.32,0.00,0.00,4.03,318.37,'2022-09-04 11:24:25','',''),(4828,'1','274','1',1,'Retail Sale Id 4710',751.44,0.00,0.00,1.01,79.79,'2022-09-04 11:28:34','',''),(4829,'1','274','1',1,'Retail Sale Id 4711',2499.84,0.00,0.00,3.36,265.44,'2022-09-04 11:41:42','',''),(4830,'1','274','1',1,'Retail Sale Id 4712',2001.36,0.00,0.00,2.69,212.51,'2022-09-04 11:59:46','',''),(4831,'1','274','1',1,'Retail Sale Id 4713',2246.88,0.00,0.00,3.02,238.58,'2022-09-04 12:02:22','',''),(4832,'1','274','1',1,'Retail Sale Id 4714',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 12:03:18','',''),(4833,'1','274','1',1,'Retail Sale Id 4715',2232.00,0.00,0.00,3.00,237.00,'2022-09-04 12:08:32','',''),(4834,'1','274','1',1,'Retail Sale Id 4716',9002.40,0.00,0.00,12.10,955.90,'2022-09-04 12:11:46','',''),(4835,'1','274','1',1,'Retail Sale Id 4718',18600.00,0.00,0.00,25.00,1975.00,'2022-09-04 12:17:52','',''),(4836,'1','274','1',1,'Retail Sale Id 4719',2001.36,0.00,0.00,2.69,212.51,'2022-09-04 12:24:48','',''),(4837,'1','274','1',1,'Retail Sale Id 4720',1502.88,0.00,0.00,2.02,159.58,'2022-09-04 12:33:22','',''),(4838,'1','274','1',1,'Retail Sale Id 4721',2246.88,0.00,0.00,3.02,238.58,'2022-09-04 12:49:36','',''),(4839,'1','274','1',1,'Retail Sale Id 4722',4501.20,0.00,0.00,6.05,477.95,'2022-09-04 12:50:22','',''),(4840,'1','274','1',1,'Retail Sale Id 4723',2998.32,0.00,0.00,4.03,318.37,'2022-09-04 12:57:10','',''),(4841,'1','274','1',1,'Retail Sale Id 4724',3749.76,0.00,0.00,5.04,398.16,'2022-09-04 12:58:17','',''),(4842,'1','274','1',1,'Retail Sale Id 4725',9672.00,0.00,0.00,13.00,1027.00,'2022-09-04 12:59:58','',''),(4843,'1','274','1',1,'Retail Sale Id 4726',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 13:35:12','',''),(4844,'1','274','1',1,'Retail Sale Id 4727',4002.72,0.00,0.00,5.38,425.02,'2022-09-04 13:35:57','',''),(4845,'1','274','1',1,'Retail Sale Id 4728',996.96,0.00,0.00,1.34,105.86,'2022-09-04 13:41:36','',''),(4846,'1','274','1',1,'Retail Sale Id 4729',2998.32,0.00,0.00,4.03,318.37,'2022-09-04 13:42:14','',''),(4847,'1','274','1',1,'Retail Sale Id 4731',74400.00,0.00,0.00,100.00,7900.00,'2022-09-04 13:45:53','',''),(4848,'1','274','1',1,'Retail Sale Id 4732',1696.32,0.00,0.00,2.28,180.12,'2022-09-04 13:51:35','',''),(4849,'1','274','1',1,'Retail Sale Id 4733',996.96,0.00,0.00,1.34,105.86,'2022-09-04 13:54:45','',''),(4850,'1','274','1',1,'Retail Sale Id 4734',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 14:02:39','',''),(4851,'1','274','1',1,'Retail Sale Id 4735',1502.88,0.00,0.00,2.02,159.58,'2022-09-04 14:11:12','',''),(4852,'1','274','1',1,'Retail Sale Id 4736',2998.32,0.00,0.00,4.03,318.37,'2022-09-04 14:18:31','',''),(4853,'1','274','1',1,'Retail Sale Id 4737',2998.32,0.00,0.00,4.03,318.37,'2022-09-04 14:20:41','',''),(4854,'1','274','1',1,'Retail Sale Id 4738',34201.68,0.00,0.00,45.97,3631.63,'2022-09-04 14:24:37','',''),(4855,'1','274','1',1,'Retail Sale Id 4739',5996.64,0.00,0.00,8.06,636.74,'2022-09-04 14:25:27','',''),(4856,'1','274','1',1,'Retail Sale Id 4740',2976.00,0.00,0.00,4.00,316.00,'2022-09-04 14:31:55','',''),(4857,'1','274','1',1,'Retail Sale Id 4741',37200.00,0.00,0.00,50.00,3950.00,'2022-09-04 14:34:14','',''),(4858,'1','274','1',1,'Retail Sale Id 4742',5200.56,0.00,0.00,6.99,552.21,'2022-09-04 14:41:50','',''),(4859,'1','274','1',1,'Retail Sale Id 4743',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 14:54:20','',''),(4860,'1','274','1',1,'Retail Sale Id 4744',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 15:13:16','',''),(4861,'1','274','1',1,'Retail Sale Id 4745',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 15:23:58','',''),(4862,'1','274','1',1,'Retail Sale Id 4746',2298.96,0.00,0.00,3.09,244.11,'2022-09-04 15:25:41','',''),(4863,'1','274','1',1,'Retail Sale Id 4747',2998.32,0.00,0.00,4.03,318.37,'2022-09-04 15:35:21','',''),(4864,'1','274','1',1,'Retail Sale Id 4748',14880.00,0.00,0.00,20.00,1580.00,'2022-09-04 15:57:45','',''),(4865,'1','274','1',1,'Retail Sale Id 4749',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 15:59:03','',''),(4866,'1','274','1',1,'Retail Sale Id 4749',14880.00,0.00,0.00,20.00,1580.00,'2022-09-04 15:59:03','',''),(4867,'1','274','1',1,'Retail Sale Id 4750',44640.00,0.00,0.00,60.00,4740.00,'2022-09-04 16:04:47','',''),(4868,'1','274','1',1,'Retail Sale Id 4751',4999.68,0.00,0.00,6.72,530.88,'2022-09-04 16:18:47','',''),(4869,'1','274','1',1,'Retail Sale Id 4752',7440.00,0.00,0.00,10.00,790.00,'2022-09-04 16:24:02','',''),(4870,'1','274','1',1,'Retail Sale Id 4753',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 16:24:25','',''),(4871,'1','274','1',1,'Retail Sale Id 4754',18600.00,0.00,0.00,25.00,1975.00,'2022-09-04 16:24:51','',''),(4872,'1','274','1',1,'Retail Sale Id 4755',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 16:25:19','',''),(4873,'1','274','1',1,'Retail Sale Id 4756',7440.00,0.00,0.00,10.00,790.00,'2022-09-04 16:40:05','',''),(4874,'1','274','1',1,'Retail Sale Id 4757',2001.36,0.00,0.00,2.69,212.51,'2022-09-04 16:51:38','',''),(4875,'1','274','1',1,'Retail Sale Id 4758',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 17:29:30','',''),(4876,'1','274','1',1,'Retail Sale Id 4759',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 17:31:40','',''),(4877,'1','274','1',1,'Retail Sale Id 4760',2232.00,0.00,0.00,3.00,237.00,'2022-09-04 17:33:25','',''),(4878,'1','274','1',1,'Retail Sale Id 4761',2001.36,0.00,0.00,2.69,212.51,'2022-09-04 17:34:58','',''),(4879,'1','274','1',1,'Retail Sale Id 4762',13801.20,0.00,0.00,18.55,1465.45,'2022-09-04 17:47:45','',''),(4880,'1','274','1',1,'Retail Sale Id 4763',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 17:50:58','',''),(4881,'1','274','1',1,'Retail Sale Id 4764',4501.20,0.00,0.00,6.05,477.95,'2022-09-04 17:51:59','',''),(4882,'1','274','1',1,'Retail Sale Id 4765',7001.04,0.00,0.00,9.41,743.39,'2022-09-04 17:53:38','',''),(4883,'1','274','1',1,'Retail Sale Id 4766',1599.60,0.00,0.00,2.15,169.85,'2022-09-04 18:05:00','',''),(4884,'1','274','1',1,'Retail Sale Id 4767',148800.00,0.00,0.00,200.00,15800.00,'2022-09-04 18:33:17','',''),(4885,'1','274','1',1,'Retail Sale Id 4768',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 18:38:24','',''),(4886,'1','274','1',1,'Retail Sale Id 4769',9002.40,0.00,0.00,12.10,955.90,'2022-09-04 19:14:29','',''),(4887,'1','274','1',1,'Retail Sale Id 4770',4002.72,0.00,0.00,5.38,425.02,'2022-09-04 19:15:33','',''),(4888,'1','274','1',1,'Retail Sale Id 4771',9300.00,0.00,0.00,12.50,987.50,'2022-09-04 19:16:54','',''),(4889,'1','274','1',1,'Retail Sale Id 4772',1197.84,0.00,0.00,1.61,127.19,'2022-09-04 19:18:30','',''),(4890,'1','274','1',1,'Retail Sale Id 4773',145385.04,0.00,0.00,195.41,15437.39,'2022-09-04 19:45:22','',''),(4891,'1','274','1',1,'Return of Retail Sale Id 4767',0.00,148800.00,200.00,0.00,-15800.00,'2022-09-04 19:46:00','',''),(4892,'1','274','1',1,'Retail Sale Id 4775',82643.52,0.00,0.00,111.08,8775.32,'2022-09-04 19:47:34','',''),(4893,'1','274','1',1,'Retail Sale Id 4776',9300.00,0.00,0.00,12.50,987.50,'2022-09-05 06:58:59','',''),(4894,'1','274','1',1,'Retail Sale Id 4777',7440.00,0.00,0.00,10.00,790.00,'2022-09-05 07:34:29','',''),(4895,'1','274','1',1,'Retail Sale Id 4778',4501.20,0.00,0.00,6.05,477.95,'2022-09-05 07:52:47','',''),(4896,'1','274','1',1,'Retail Sale Id 4778',4501.20,0.00,0.00,6.05,477.95,'2022-09-05 07:52:47','',''),(4897,'1','274','1',1,'Retail Sale Id 4778',9300.00,0.00,0.00,12.50,987.50,'2022-09-05 07:52:47','',''),(4898,'1','274','1',1,'Retail Sale Id 4778',18600.00,0.00,0.00,25.00,1975.00,'2022-09-05 07:52:47','',''),(4899,'1','274','1',1,'Retail Sale Id 4779',9300.00,0.00,0.00,12.50,987.50,'2022-09-05 07:58:58','',''),(4900,'1','274','1',1,'Retail Sale Id 4780',9672.00,0.00,0.00,13.00,1027.00,'2022-09-05 07:59:44','',''),(4901,'1','274','1',1,'Retail Sale Id 4781',9300.00,0.00,0.00,12.50,987.50,'2022-09-05 08:22:29','',''),(4902,'1','274','1',1,'Retail Sale Id 4782',18503.28,0.00,0.00,24.87,1964.73,'2022-09-05 08:33:26','',''),(4903,'1','274','1',1,'Retail Sale Id 4783',9300.00,0.00,0.00,12.50,987.50,'2022-09-05 09:12:35','',''),(4904,'1','274','1',1,'Retail Sale Id 4784',2001.36,0.00,0.00,2.69,212.51,'2022-09-05 09:13:23','',''),(4905,'1','274','1',1,'Retail Sale Id 4785',9300.00,0.00,0.00,12.50,987.50,'2022-09-05 09:18:30','',''),(4906,'1','274','1',1,'Retail Sale Id 4786',2001.36,0.00,0.00,2.69,212.51,'2022-09-05 09:39:04','',''),(4907,'1','274','1',1,'Retail Sale Id 4787',74400.00,0.00,0.00,100.00,7900.00,'2022-09-05 10:28:40','',''),(4908,'1','274','1',1,'Retail Sale Id 4788',9002.40,0.00,0.00,12.10,955.90,'2022-09-05 10:36:26','',''),(4909,'1','274','1',1,'Retail Sale Id 4789',9300.00,0.00,0.00,12.50,987.50,'2022-09-05 10:40:03','',''),(4910,'1','274','1',1,'Retail Sale Id 4790',9300.00,0.00,0.00,12.50,987.50,'2022-09-05 11:16:00','',''),(4911,'1','274','1',1,'Retail Sale Id 4791',2001.36,0.00,0.00,2.69,212.51,'2022-09-05 11:17:21','',''),(4912,'1','274','1',1,'Retail Sale Id 4792',9300.00,0.00,0.00,12.50,987.50,'2022-09-05 11:30:41','',''),(4913,'1','274','1',1,'Retail Sale Id 4793',9300.00,0.00,0.00,12.50,987.50,'2022-09-05 11:49:24','',''),(4914,'1','274','1',1,'Retail Sale Id 4794',3697.68,0.00,0.00,4.97,392.63,'2022-09-05 12:18:10','',''),(4915,'1','274','1',1,'Retail Sale Id 4795',2001.36,0.00,0.00,2.69,212.51,'2022-09-05 12:27:21','',''),(4916,'1','274','1',1,'Retail Sale Id 4796',2998.32,0.00,0.00,4.03,318.37,'2022-09-05 12:27:58','',''),(4917,'1','274','1',1,'Return of Retail Sale Id 4795',0.00,2001.36,2.69,0.00,-212.51,'2022-09-05 12:28:37','',''),(4918,'1','274','1',1,'Retail Sale Id 4797',7998.00,0.00,0.00,10.75,849.25,'2022-09-05 12:41:15','',''),(4919,'1','274','1',1,'Retail Sale Id 4798',996.96,0.00,0.00,1.34,105.86,'2022-09-05 12:59:34','',''),(4920,'1','274','1',1,'Retail Sale Id 4799',7998.00,0.00,0.00,10.75,849.25,'2022-09-05 13:15:38','',''),(4921,'1','274','1',1,'Retail Sale Id 4800',2246.88,0.00,0.00,3.02,238.58,'2022-09-05 13:16:37','',''),(4922,'1','274','1',1,'Retail Sale Id 4801',4999.68,0.00,0.00,6.72,530.88,'2022-09-05 13:19:16','',''),(4923,'1','274','1',1,'Retail Sale Id 4802',4501.20,0.00,0.00,6.05,477.95,'2022-09-05 13:26:12','',''),(4924,'1','274','1',1,'Retail Sale Id 4803',7998.00,0.00,0.00,10.75,849.25,'2022-09-05 13:31:03','',''),(4925,'1','274','1',1,'Retail Sale Id 4804',1502.88,0.00,0.00,2.02,159.58,'2022-09-05 13:46:16','',''),(4926,'1','274','1',1,'Retail Sale Id 4805',3749.76,0.00,0.00,5.04,398.16,'2022-09-05 13:59:36','',''),(4927,'1','274','1',1,'Retail Sale Id 4806',3749.76,0.00,0.00,5.04,398.16,'2022-09-05 14:00:58','',''),(4928,'1','274','1',1,'Retail Sale Id 4807',2001.36,0.00,0.00,2.69,212.51,'2022-09-05 14:17:53','',''),(4929,'1','274','1',1,'Retail Sale Id 4808',9300.00,0.00,0.00,12.50,987.50,'2022-09-05 14:35:55','',''),(4930,'1','274','1',1,'Retail Sale Id 4809',9300.00,0.00,0.00,12.50,987.50,'2022-09-05 14:41:03','',''),(4931,'1','274','1',1,'Retail Sale Id 4810',2298.96,0.00,0.00,3.09,244.11,'2022-09-05 15:22:27','',''),(4932,'1','274','1',1,'Retail Sale Id 4811',9300.00,0.00,0.00,12.50,987.50,'2022-09-05 15:27:29','',''),(4933,'1','274','1',1,'Retail Sale Id 4812',9300.00,0.00,0.00,12.50,987.50,'2022-09-05 15:36:21','',''),(4934,'1','274','1',1,'Retail Sale Id 4813',1302.00,0.00,0.00,1.75,138.25,'2022-09-05 15:37:18','',''),(4935,'1','274','1',1,'Retail Sale Id 4814',9300.00,0.00,0.00,12.50,987.50,'2022-09-05 15:38:20','',''),(4936,'1','274','1',1,'Retail Sale Id 4815',37200.00,0.00,0.00,50.00,3950.00,'2022-09-05 15:39:53','',''),(4937,'1','274','1',1,'Retail Sale Id 4816',4501.20,0.00,0.00,6.05,477.95,'2022-09-05 15:40:46','',''),(4938,'1','274','1',1,'Retail Sale Id 4817',3697.68,0.00,0.00,4.97,392.63,'2022-09-05 16:04:05','',''),(4939,'1','274','1',1,'Retail Sale Id 4818',9300.00,0.00,0.00,12.50,987.50,'2022-09-05 16:05:32','',''),(4940,'1','274','1',1,'Return of Retail Sale Id 4818',0.00,9300.00,12.50,0.00,-987.50,'2022-09-05 16:05:55','',''),(4941,'1','274','1',1,'Retail Sale Id 4819',2998.32,0.00,0.00,4.03,318.37,'2022-09-05 16:07:31','',''),(4942,'1','274','1',1,'Retail Sale Id 4820',4501.20,0.00,0.00,6.05,477.95,'2022-09-05 16:16:19','',''),(4943,'1','274','1',1,'Retail Sale Id 4821',2998.32,0.00,0.00,4.03,318.37,'2022-09-05 16:18:00','',''),(4944,'1','274','1',1,'Retail Sale Id 4822',1502.88,0.00,0.00,2.02,159.58,'2022-09-05 16:29:51','',''),(4945,'1','274','1',1,'Retail Sale Id 4823',2998.32,0.00,0.00,4.03,318.37,'2022-09-05 16:54:13','',''),(4946,'1','274','1',1,'Retail Sale Id 4824',2001.36,0.00,0.00,2.69,212.51,'2022-09-05 16:56:17','',''),(4947,'1','274','1',1,'Retail Sale Id 4825',14880.00,0.00,0.00,20.00,1580.00,'2022-09-05 16:58:41','',''),(4948,'1','274','1',1,'Retail Sale Id 4826',2001.36,0.00,0.00,2.69,212.51,'2022-09-05 17:00:23','',''),(4949,'1','274','1',1,'Retail Sale Id 4827',3720.00,0.00,0.00,5.00,395.00,'2022-09-05 17:11:54','',''),(4950,'1','274','1',1,'Retail Sale Id 4828',4501.20,0.00,0.00,6.05,477.95,'2022-09-05 17:13:05','',''),(4951,'1','274','1',1,'Retail Sale Id 4829',9300.00,0.00,0.00,12.50,987.50,'2022-09-05 17:19:50','',''),(4952,'1','274','1',1,'Retail Sale Id 4830',4999.68,0.00,0.00,6.72,530.88,'2022-09-05 17:20:31','',''),(4953,'1','274','1',1,'Retail Sale Id 4831',2499.84,0.00,0.00,3.36,265.44,'2022-09-05 17:25:30','',''),(4954,'1','274','1',1,'Retail Sale Id 4832',3749.76,0.00,0.00,5.04,398.16,'2022-09-05 17:30:45','',''),(4955,'1','274','1',1,'Retail Sale Id 4833',9300.00,0.00,0.00,12.50,987.50,'2022-09-05 17:36:30','',''),(4956,'1','274','1',1,'Retail Sale Id 4834',13801.20,0.00,0.00,18.55,1465.45,'2022-09-05 17:44:12','',''),(4957,'1','274','1',1,'Retail Sale Id 4835',1502.88,0.00,0.00,2.02,159.58,'2022-09-05 17:44:50','',''),(4958,'1','274','1',1,'Retail Sale Id 4836',9300.00,0.00,0.00,12.50,987.50,'2022-09-05 17:45:52','',''),(4959,'1','274','1',1,'Retail Sale Id 4837',2246.88,0.00,0.00,3.02,238.58,'2022-09-05 17:53:27','',''),(4960,'1','274','1',1,'Retail Sale Id 4838',4501.20,0.00,0.00,6.05,477.95,'2022-09-05 18:01:43','',''),(4961,'1','274','1',1,'Retail Sale Id 4839',1502.88,0.00,0.00,2.02,159.58,'2022-09-05 18:22:49','',''),(4962,'1','274','1',1,'Retail Sale Id 4840',4501.20,0.00,0.00,6.05,477.95,'2022-09-05 18:37:10','',''),(4963,'1','274','1',1,'Retail Sale Id 4841',41001.84,0.00,0.00,55.11,4353.69,'2022-09-05 18:43:41','',''),(4964,'1','274','1',1,'Retail Sale Id 4842',18302.40,0.00,0.00,24.60,1943.40,'2022-09-05 18:44:45','',''),(4965,'1','274','1',1,'Retail Sale Id 4843',2001.36,0.00,0.00,2.69,212.51,'2022-09-05 18:46:07','',''),(4966,'1','274','1',1,'Retail Sale Id 4844',2246.88,0.00,0.00,3.02,238.58,'2022-09-05 18:49:18','',''),(4967,'1','274','1',1,'Retail Sale Id 4845',7440.00,0.00,0.00,10.00,790.00,'2022-09-05 18:51:03','',''),(4968,'1','274','1',1,'Retail Sale Id 4846',66669.84,0.00,0.00,89.61,7079.19,'2022-09-05 19:25:53','',''),(4969,'1','274','1',1,'Return of Retail Sale Id 4787',0.00,74400.00,100.00,0.00,-7900.00,'2022-09-05 19:30:51','',''),(4970,'1','274','1',1,'Retail Sale Id 4847',21486.72,0.00,0.00,28.88,2281.52,'2022-09-05 19:32:09','',''),(4971,'1','274','1',1,'Retail Sale Id 4849',19998.72,0.00,0.00,26.88,2123.52,'2022-09-06 07:02:16','',''),(4972,'1','274','1',1,'Retail Sale Id 4850',2001.36,0.00,0.00,2.69,212.51,'2022-09-06 07:07:51','',''),(4973,'1','274','1',1,'Retail Sale Id 4851',996.96,0.00,0.00,1.34,105.86,'2022-09-06 07:36:17','',''),(4974,'1','274','1',1,'Retail Sale Id 4852',9300.00,0.00,0.00,12.50,987.50,'2022-09-06 07:46:40','',''),(4975,'1','274','1',1,'Retail Sale Id 4853',1502.88,0.00,0.00,2.02,159.58,'2022-09-06 07:47:30','',''),(4976,'1','274','1',1,'Retail Sale Id 4854',9300.00,0.00,0.00,12.50,987.50,'2022-09-06 08:13:54','',''),(4977,'1','274','1',1,'Retail Sale Id 4855',18600.00,0.00,0.00,25.00,1975.00,'2022-09-06 08:28:41','',''),(4978,'1','274','1',1,'Return of Retail Sale Id 4855',0.00,18600.00,25.00,0.00,-1975.00,'2022-09-06 08:35:15','',''),(4979,'1','274','1',1,'Retail Sale Id 4856',1197.84,0.00,0.00,1.61,127.19,'2022-09-06 08:57:51','',''),(4980,'1','274','1',1,'Retail Sale Id 4857',9300.00,0.00,0.00,12.50,987.50,'2022-09-06 08:58:56','',''),(4981,'1','274','1',1,'Retail Sale Id 4857',9300.00,0.00,0.00,12.50,987.50,'2022-09-06 08:58:56','',''),(4982,'1','274','1',1,'Retail Sale Id 4858',1502.88,0.00,0.00,2.02,159.58,'2022-09-06 09:07:09','',''),(4983,'1','274','1',1,'Retail Sale Id 4859',4002.72,0.00,0.00,5.38,425.02,'2022-09-06 09:12:53','',''),(4984,'1','274','1',1,'Retail Sale Id 4860',4999.68,0.00,0.00,6.72,530.88,'2022-09-06 09:16:09','',''),(4985,'1','274','1',1,'Retail Sale Id 4861',37200.00,0.00,0.00,50.00,3950.00,'2022-09-06 09:18:56','',''),(4986,'1','274','1',1,'Retail Sale Id 4862',2246.88,0.00,0.00,3.02,238.58,'2022-09-06 09:20:45','',''),(4987,'1','274','1',1,'Retail Sale Id 4863',2246.88,0.00,0.00,3.02,238.58,'2022-09-06 09:27:34','',''),(4988,'1','274','1',1,'Retail Sale Id 4864',4999.68,0.00,0.00,6.72,530.88,'2022-09-06 09:38:49','',''),(4989,'1','274','1',1,'Retail Sale Id 4865',9300.00,0.00,0.00,12.50,987.50,'2022-09-06 09:53:00','',''),(4990,'1','274','1',1,'Retail Sale Id 4866',4999.68,0.00,0.00,6.72,530.88,'2022-09-06 10:21:19','',''),(4991,'1','274','1',1,'Retail Sale Id 4867',18600.00,0.00,0.00,25.00,1975.00,'2022-09-06 11:09:28','',''),(4992,'1','274','1',1,'Retail Sale Id 4868',9300.00,0.00,0.00,12.50,987.50,'2022-09-06 11:22:01','',''),(4993,'1','274','1',1,'Retail Sale Id 4869',2246.88,0.00,0.00,3.02,238.58,'2022-09-06 11:27:23','',''),(4994,'1','274','1',1,'Retail Sale Id 4870',4002.72,0.00,0.00,5.38,425.02,'2022-09-06 11:47:54','',''),(4995,'1','274','1',1,'Retail Sale Id 4871',1502.88,0.00,0.00,2.02,159.58,'2022-09-06 11:49:00','',''),(4996,'1','274','1',1,'Retail Sale Id 4872',3496.80,0.00,0.00,4.70,371.30,'2022-09-06 11:51:16','',''),(4997,'1','274','1',1,'Return of Retail Sale Id 4872',0.00,3496.80,4.70,0.00,-371.30,'2022-09-06 11:52:02','',''),(4998,'1','274','1',1,'Retail Sale Id 4873',34997.76,0.00,0.00,47.04,3716.16,'2022-09-06 11:52:51','',''),(4999,'1','274','1',1,'Retail Sale Id 4874',4501.20,0.00,0.00,6.05,477.95,'2022-09-06 11:58:49','',''),(5000,'1','274','1',1,'Retail Sale Id 4875',2246.88,0.00,0.00,3.02,238.58,'2022-09-06 12:02:20','',''),(5001,'1','274','1',1,'Retail Sale Id 4875',9300.00,0.00,0.00,12.50,987.50,'2022-09-06 12:02:20','',''),(5002,'1','274','1',1,'Retail Sale Id 4876',9300.00,0.00,0.00,12.50,987.50,'2022-09-06 12:17:01','',''),(5003,'1','274','1',1,'Retail Sale Id 4877',4999.68,0.00,0.00,6.72,530.88,'2022-09-06 12:37:25','',''),(5004,'1','274','1',1,'Return of Retail Sale Id 4875',0.00,2246.88,3.02,0.00,-238.58,'2022-09-06 12:53:15','',''),(5005,'1','274','1',1,'Return of Retail Sale Id 4875',0.00,9300.00,12.50,0.00,-987.50,'2022-09-06 12:53:15','',''),(5006,'1','274','1',1,'Retail Sale Id 4878',2998.32,0.00,0.00,4.03,318.37,'2022-09-06 12:54:53','',''),(5007,'1','274','1',1,'Retail Sale Id 4878',9300.00,0.00,0.00,12.50,987.50,'2022-09-06 12:54:53','',''),(5008,'1','274','1',1,'Retail Sale Id 4879',2246.88,0.00,0.00,3.02,238.58,'2022-09-06 13:06:11','',''),(5009,'1','274','1',1,'Retail Sale Id 4880',74400.00,0.00,0.00,100.00,7900.00,'2022-09-06 13:16:12','',''),(5010,'1','274','1',1,'Retail Sale Id 4881',13764.00,0.00,0.00,18.50,1461.50,'2022-09-06 13:25:27','',''),(5011,'1','274','1',1,'Retail Sale Id 4882',3720.00,0.00,0.00,5.00,395.00,'2022-09-06 13:42:03','',''),(5012,'1','274','1',1,'Retail Sale Id 4883',9300.00,0.00,0.00,12.50,987.50,'2022-09-06 13:47:04','',''),(5013,'1','274','1',1,'Retail Sale Id 4884',9300.00,0.00,0.00,12.50,987.50,'2022-09-06 13:54:48','',''),(5014,'1','274','1',1,'Retail Sale Id 4885',2998.32,0.00,0.00,4.03,318.37,'2022-09-06 15:34:39','',''),(5015,'1','274','1',1,'Return of Retail Sale Id 4885',0.00,2998.32,4.03,0.00,-318.37,'2022-09-06 15:36:06','',''),(5016,'1','274','1',1,'Return of Retail Sale Id 4861',0.00,37200.00,50.00,0.00,-3950.00,'2022-09-06 15:39:50','',''),(5017,'1','274','1',1,'Retail Sale Id 4886',21442.08,0.00,0.00,28.82,2276.78,'2022-09-06 15:41:03','',''),(5018,'1','274','1',1,'Retail Sale Id 4887',15802.56,0.00,0.00,21.24,1677.96,'2022-09-06 15:42:26','',''),(5019,'1','274','1',1,'Retail Sale Id 4888',2998.32,0.00,0.00,4.03,318.37,'2022-09-06 15:43:15','',''),(5020,'1','274','1',1,'Return of Retail Sale Id 4888',0.00,2998.32,4.03,0.00,-318.37,'2022-09-06 15:43:43','',''),(5021,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,665000.00,1000.00,0.00,0.00,'2022-09-06 15:52:24','',''),(5022,'1','274',NULL,1,'Reception corrector for bridging 47',0.00,0.00,0.00,1000.00,0.00,'2022-09-06 15:53:24','',''),(5023,'1','274','1',1,'Received from bridging 47',0.00,0.00,1000.00,0.00,0.00,'2022-09-06 15:53:24','',''),(5024,'1','274','1',1,'Retail Sale Id 4889',9977.04,0.00,0.00,13.41,1059.39,'2022-09-06 15:55:37','',''),(5025,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,2972550.00,4470.00,0.00,0.00,'2022-09-06 16:06:19','',''),(5026,'1','274',NULL,1,'Reception corrector for bridging 48',0.00,0.00,0.00,4470.00,0.00,'2022-09-06 16:07:30','',''),(5027,'1','274','1',1,'Received from bridging 48',0.00,0.00,4470.00,0.00,0.00,'2022-09-06 16:07:30','',''),(5028,'1','274','1',1,'Return of Retail Sale Id 4889',0.00,9977.04,13.41,0.00,-1059.39,'2022-09-06 16:08:18','',''),(5029,'1','274','1',1,'Retail Sale Id 4890',9300.00,0.00,0.00,12.50,987.50,'2022-09-06 16:24:52','',''),(5030,'1','274','1',1,'Retail Sale Id 4891',9300.00,0.00,0.00,12.50,987.50,'2022-09-06 16:26:54','',''),(5031,'1','274','1',1,'Retail Sale Id 4891',9300.00,0.00,0.00,12.50,987.50,'2022-09-06 16:26:54','',''),(5032,'1','274','1',1,'Retail Sale Id 4892',9300.00,0.00,0.00,12.50,987.50,'2022-09-06 16:40:01','',''),(5033,'1','274','1',1,'Retail Sale Id 4893',2246.88,0.00,0.00,3.02,238.58,'2022-09-06 16:41:01','',''),(5034,'1','274','1',1,'Retail Sale Id 4894',4999.68,0.00,0.00,6.72,530.88,'2022-09-06 17:18:01','',''),(5035,'1','274','1',1,'Retail Sale Id 4895',1502.88,0.00,0.00,2.02,159.58,'2022-09-06 17:19:23','',''),(5036,'1','274','1',1,'Retail Sale Id 4896',10416.00,0.00,0.00,14.00,1106.00,'2022-09-06 17:43:32','',''),(5037,'1','274','1',1,'Retail Sale Id 4897',2246.88,0.00,0.00,3.02,238.58,'2022-09-06 17:46:47','',''),(5038,'1','274','1',1,'Retail Sale Id 4897',9300.00,0.00,0.00,12.50,987.50,'2022-09-06 17:46:47','',''),(5039,'1','274','1',1,'Retail Sale Id 4898',3749.76,0.00,0.00,5.04,398.16,'2022-09-06 17:58:59','',''),(5040,'1','274','1',1,'Retail Sale Id 4899',1502.88,0.00,0.00,2.02,159.58,'2022-09-06 18:08:15','',''),(5041,'1','274','1',1,'Retail Sale Id 4900',2246.88,0.00,0.00,3.02,238.58,'2022-09-06 18:15:46','',''),(5042,'1','274','1',1,'Retail Sale Id 4901',9672.00,0.00,0.00,13.00,1027.00,'2022-09-06 18:18:29','',''),(5043,'1','274','1',1,'Retail Sale Id 4902',4002.72,0.00,0.00,5.38,425.02,'2022-09-06 18:19:46','',''),(5044,'1','274','1',1,'Retail Sale Id 4903',41403.60,0.00,0.00,55.65,4396.35,'2022-09-06 19:31:12','',''),(5045,'1','274','1',1,'Retail Sale Id 4904',5498.16,0.00,0.00,7.39,583.81,'2022-09-06 19:32:29','',''),(5046,'1','274','1',1,'Retail Sale Id 4905',14999.04,0.00,0.00,20.16,1592.64,'2022-09-07 06:59:01','',''),(5047,'1','274','1',1,'Retail Sale Id 4906',996.96,0.00,0.00,1.34,105.86,'2022-09-07 07:28:22','',''),(5048,'1','274','1',1,'Retail Sale Id 4907',9300.00,0.00,0.00,12.50,987.50,'2022-09-07 07:39:08','',''),(5049,'1','274','1',1,'Retail Sale Id 4908',9300.00,0.00,0.00,12.50,987.50,'2022-09-07 07:44:04','',''),(5050,'1','274','1',1,'Retail Sale Id 4909',9300.00,0.00,0.00,12.50,987.50,'2022-09-07 08:12:01','',''),(5051,'1','274','1',1,'Retail Sale Id 4910',2001.36,0.00,0.00,2.69,212.51,'2022-09-07 08:22:04','',''),(5052,'1','274','1',1,'Retail Sale Id 4911',1502.88,0.00,0.00,2.02,159.58,'2022-09-07 08:33:02','',''),(5053,'1','274','1',1,'Retail Sale Id 4912',3749.76,0.00,0.00,5.04,398.16,'2022-09-07 08:38:53','',''),(5054,'1','274','1',1,'Retail Sale Id 4913',4501.20,0.00,0.00,6.05,477.95,'2022-09-07 08:43:30','',''),(5055,'1','274','1',1,'Retail Sale Id 4914',9300.00,0.00,0.00,12.50,987.50,'2022-09-07 09:00:43','',''),(5056,'1','274','1',1,'Retail Sale Id 4916',9300.00,0.00,0.00,12.50,987.50,'2022-09-07 09:08:07','',''),(5057,'1','274','1',1,'Retail Sale Id 4917',5996.64,0.00,0.00,8.06,636.74,'2022-09-07 09:09:47','',''),(5058,'1','274','1',1,'Retail Sale Id 4918',4501.20,0.00,0.00,6.05,477.95,'2022-09-07 09:16:55','',''),(5059,'1','274','1',1,'Retail Sale Id 4918',9300.00,0.00,0.00,12.50,987.50,'2022-09-07 09:16:55','',''),(5060,'1','274','1',1,'Retail Sale Id 4919',2001.36,0.00,0.00,2.69,212.51,'2022-09-07 09:20:21','',''),(5061,'1','274','1',1,'Retail Sale Id 4920',37200.00,0.00,0.00,50.00,3950.00,'2022-09-07 09:22:50','',''),(5062,'1','274','1',1,'Retail Sale Id 4921',996.96,0.00,0.00,1.34,105.86,'2022-09-07 09:39:02','',''),(5063,'1','274','1',1,'Retail Sale Id 4922',9300.00,0.00,0.00,12.50,987.50,'2022-09-07 09:50:36','',''),(5064,'1','274','1',1,'Retail Sale Id 4923',2998.32,0.00,0.00,4.03,318.37,'2022-09-07 09:52:13','',''),(5065,'1','274','1',1,'Retail Sale Id 4924',3720.00,0.00,0.00,5.00,395.00,'2022-09-07 10:07:41','',''),(5066,'1','274','1',1,'Retail Sale Id 4925',2499.84,0.00,0.00,3.36,265.44,'2022-09-07 10:14:00','',''),(5067,'1','274','1',1,'Retail Sale Id 4927',14880.00,0.00,0.00,20.00,1580.00,'2022-09-07 10:39:11','',''),(5068,'1','274','1',1,'Retail Sale Id 4929',4501.20,0.00,0.00,6.05,477.95,'2022-09-07 10:44:30','',''),(5069,'1','274','1',1,'Retail Sale Id 4930',4501.20,0.00,0.00,6.05,477.95,'2022-09-07 10:47:29','',''),(5070,'1','274','1',1,'Retail Sale Id 4931',3801.84,0.00,0.00,5.11,403.69,'2022-09-07 10:50:29','',''),(5071,'1','274','1',1,'Retail Sale Id 4933',2001.36,0.00,0.00,2.69,212.51,'2022-09-07 10:59:59','',''),(5072,'1','274','1',1,'Retail Sale Id 4934',28272.00,0.00,0.00,38.00,3002.00,'2022-09-07 11:07:23','',''),(5073,'1','274','1',1,'Retail Sale Id 4935',2604.00,0.00,0.00,3.50,276.50,'2022-09-07 11:09:28','',''),(5074,'1','274','1',1,'Retail Sale Id 4936',9300.00,0.00,0.00,12.50,987.50,'2022-09-07 13:22:47','',''),(5075,'1','274','1',1,'Retail Sale Id 4939',4501.20,0.00,0.00,6.05,477.95,'2022-09-07 13:27:39','',''),(5076,'1','274','1',1,'Retail Sale Id 4940',9300.00,0.00,0.00,12.50,987.50,'2022-09-07 13:28:39','',''),(5077,'1','274','1',1,'Retail Sale Id 4941',9999.36,0.00,0.00,13.44,1061.76,'2022-09-07 13:38:48','',''),(5078,'1','274','1',1,'Retail Sale Id 4942',18600.00,0.00,0.00,25.00,1975.00,'2022-09-07 13:57:47','',''),(5079,'1','274','1',1,'Retail Sale Id 4943',1502.88,0.00,0.00,2.02,159.58,'2022-09-07 14:04:32','',''),(5080,'1','274','1',1,'Retail Sale Id 4944',9300.00,0.00,0.00,12.50,987.50,'2022-09-07 14:06:08','',''),(5081,'1','274','1',1,'Retail Sale Id 4945',2001.36,0.00,0.00,2.69,212.51,'2022-09-07 14:12:00','',''),(5082,'1','274','1',1,'Retail Sale Id 4946',7998.00,0.00,0.00,10.75,849.25,'2022-09-07 14:21:15','',''),(5083,'1','274','1',1,'Retail Sale Id 4947',2232.00,0.00,0.00,3.00,237.00,'2022-09-07 14:36:56','',''),(5084,'1','274','1',1,'Retail Sale Id 4948',2001.36,0.00,0.00,2.69,212.51,'2022-09-07 14:40:02','',''),(5085,'1','274','1',1,'Retail Sale Id 4949',4501.20,0.00,0.00,6.05,477.95,'2022-09-07 14:41:04','',''),(5086,'1','274','1',1,'Retail Sale Id 4950',18600.00,0.00,0.00,25.00,1975.00,'2022-09-07 15:12:38','',''),(5087,'1','274','1',1,'Retail Sale Id 4950',37200.00,0.00,0.00,50.00,3950.00,'2022-09-07 15:12:38','',''),(5088,'1','274','1',1,'Retail Sale Id 4951',2998.32,0.00,0.00,4.03,318.37,'2022-09-07 15:19:04','',''),(5089,'1','274','1',1,'Retail Sale Id 4952',2001.36,0.00,0.00,2.69,212.51,'2022-09-07 15:35:33','',''),(5090,'1','274','1',1,'Retail Sale Id 4953',2246.88,0.00,0.00,3.02,238.58,'2022-09-07 15:37:00','',''),(5091,'1','274','1',1,'Retail Sale Id 4954',4501.20,0.00,0.00,6.05,477.95,'2022-09-07 15:54:46','',''),(5092,'1','274','1',1,'Retail Sale Id 4955',9300.00,0.00,0.00,12.50,987.50,'2022-09-07 15:58:11','',''),(5093,'1','274','1',1,'Retail Sale Id 4956',9300.00,0.00,0.00,12.50,987.50,'2022-09-07 15:59:32','',''),(5094,'1','274','1',1,'Retail Sale Id 4957',6696.00,0.00,0.00,9.00,711.00,'2022-09-07 16:08:01','',''),(5095,'1','274','1',1,'Retail Sale Id 4958',751.44,0.00,0.00,1.01,79.79,'2022-09-07 16:13:03','',''),(5096,'1','274','1',1,'Retail Sale Id 4959',1502.88,0.00,0.00,2.02,159.58,'2022-09-07 16:24:49','',''),(5097,'1','274','1',1,'Retail Sale Id 4960',996.96,0.00,0.00,1.34,105.86,'2022-09-07 16:27:54','',''),(5098,'1','274','1',1,'Retail Sale Id 4961',4002.72,0.00,0.00,5.38,425.02,'2022-09-07 16:36:46','',''),(5099,'1','274','1',1,'Retail Sale Id 4962',7998.00,0.00,0.00,10.75,849.25,'2022-09-07 16:41:33','',''),(5100,'1','274','1',1,'Retail Sale Id 4963',3749.76,0.00,0.00,5.04,398.16,'2022-09-07 16:44:26','',''),(5101,'1','274','1',1,'Retail Sale Id 4964',7998.00,0.00,0.00,10.75,849.25,'2022-09-07 16:51:26','',''),(5102,'1','274','1',1,'Retail Sale Id 4965',1502.88,0.00,0.00,2.02,159.58,'2022-09-07 17:05:43','',''),(5103,'1','274','1',1,'Retail Sale Id 4966',9300.00,0.00,0.00,12.50,987.50,'2022-09-07 17:13:59','',''),(5104,'1','274','1',1,'Retail Sale Id 4967',9300.00,0.00,0.00,12.50,987.50,'2022-09-07 17:17:15','',''),(5105,'1','274','1',1,'Retail Sale Id 4968',1502.88,0.00,0.00,2.02,159.58,'2022-09-07 17:24:12','',''),(5106,'1','274','1',1,'Retail Sale Id 4969',19998.72,0.00,0.00,26.88,2123.52,'2022-09-07 17:28:59','',''),(5107,'1','274','1',1,'Retail Sale Id 4970',401.76,0.00,0.00,0.54,42.66,'2022-09-07 17:33:26','',''),(5108,'1','274','1',1,'Retail Sale Id 4971',9300.00,0.00,0.00,12.50,987.50,'2022-09-07 17:42:07','',''),(5109,'1','274','1',1,'Retail Sale Id 4972',9300.00,0.00,0.00,12.50,987.50,'2022-09-07 17:54:29','',''),(5110,'1','274','1',1,'Retail Sale Id 4973',7001.04,0.00,0.00,9.41,743.39,'2022-09-07 18:19:08','',''),(5111,'1','274','1',1,'Retail Sale Id 4974',2202.24,0.00,0.00,2.96,233.84,'2022-09-07 18:21:15','',''),(5112,'1','274','1',1,'Return of Retail Sale Id 4973',0.00,7001.04,9.41,0.00,-743.39,'2022-09-07 18:21:58','',''),(5113,'1','274','1',1,'Retail Sale Id 4975',2001.36,0.00,0.00,2.69,212.51,'2022-09-07 18:28:08','',''),(5114,'1','274','1',1,'Retail Sale Id 4976',9300.00,0.00,0.00,12.50,987.50,'2022-09-07 18:36:34','',''),(5115,'1','274','1',1,'Retail Sale Id 4977',2998.32,0.00,0.00,4.03,318.37,'2022-09-07 18:37:58','',''),(5116,'1','274','1',1,'Retail Sale Id 4978',2499.84,0.00,0.00,3.36,265.44,'2022-09-07 18:39:06','',''),(5117,'1','274','1',1,'Retail Sale Id 4979',2001.36,0.00,0.00,2.69,212.51,'2022-09-07 18:41:07','',''),(5118,'1','274','1',1,'Retail Sale Id 4980',57853.44,0.00,0.00,77.76,6143.04,'2022-09-07 19:11:27','',''),(5119,'1','274','1',1,'Return of Retail Sale Id 4955',0.00,9300.00,12.50,0.00,-987.50,'2022-09-07 19:13:43','',''),(5120,'1','274','1',1,'Return of Retail Sale Id 4934',0.00,28272.00,38.00,0.00,-3002.00,'2022-09-07 19:18:15','',''),(5121,'1','274','1',1,'Retail Sale Id 4981',24648.72,0.00,0.00,33.13,2617.27,'2022-09-07 19:19:56','',''),(5122,'1','274','1',1,'Retail Sale Id 4982',2998.32,0.00,0.00,4.03,318.37,'2022-09-08 06:46:47','',''),(5123,'1','274','1',1,'Retail Sale Id 4983',2001.36,0.00,0.00,2.69,212.51,'2022-09-08 06:47:49','',''),(5124,'1','274','1',1,'Retail Sale Id 4984',22997.04,0.00,0.00,30.91,2441.89,'2022-09-08 07:00:54','',''),(5125,'1','274','1',1,'Retail Sale Id 4985',751.44,0.00,0.00,1.01,79.79,'2022-09-08 07:13:56','',''),(5126,'1','274','1',1,'Retail Sale Id 4986',2998.32,0.00,0.00,4.03,318.37,'2022-09-08 07:23:43','',''),(5127,'1','274','1',1,'Retail Sale Id 4987',2001.36,0.00,0.00,2.69,212.51,'2022-09-08 07:44:12','',''),(5128,'1','274','1',1,'Retail Sale Id 4988',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 08:08:57','',''),(5129,'1','274','1',1,'Retail Sale Id 4989',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 08:10:08','',''),(5130,'1','274','1',1,'Retail Sale Id 4990',2998.32,0.00,0.00,4.03,318.37,'2022-09-08 08:19:02','',''),(5131,'1','274','1',1,'Retail Sale Id 4991',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 08:22:33','',''),(5132,'1','274','1',1,'Retail Sale Id 4992',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 08:23:49','',''),(5133,'1','274','1',1,'Retail Sale Id 4993',74400.00,0.00,0.00,100.00,7900.00,'2022-09-08 08:25:56','',''),(5134,'1','274','1',1,'Retail Sale Id 4994',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 08:29:41','',''),(5135,'1','274','1',1,'Retail Sale Id 4995',12997.68,0.00,0.00,17.47,1380.13,'2022-09-08 08:38:14','',''),(5136,'1','274','1',1,'Retail Sale Id 4996',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 08:56:38','',''),(5137,'1','274','1',1,'Retail Sale Id 4997',1502.88,0.00,0.00,2.02,159.58,'2022-09-08 09:05:47','',''),(5138,'1','274','1',1,'Retail Sale Id 4998',8928.00,0.00,0.00,12.00,948.00,'2022-09-08 09:09:28','',''),(5139,'1','274','1',1,'Retail Sale Id 4998',18600.00,0.00,0.00,25.00,1975.00,'2022-09-08 09:09:28','',''),(5140,'1','274','1',1,'Retail Sale Id 4999',4501.20,0.00,0.00,6.05,477.95,'2022-09-08 09:16:46','',''),(5141,'1','274','1',1,'Retail Sale Id 5000',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 09:29:04','',''),(5142,'1','274','1',1,'Retail Sale Id 5001',3749.76,0.00,0.00,5.04,398.16,'2022-09-08 10:08:14','',''),(5143,'1','274','1',1,'Retail Sale Id 5002',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 10:52:06','',''),(5144,'1','274','1',1,'Retail Sale Id 5003',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 10:55:01','',''),(5145,'1','274','1',1,'Retail Sale Id 5004',803.52,0.00,0.00,1.08,85.32,'2022-09-08 11:01:41','',''),(5146,'1','274','1',1,'Retail Sale Id 5005',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 11:17:50','',''),(5147,'1','274','1',1,'Retail Sale Id 5006',498.48,0.00,0.00,0.67,52.93,'2022-09-08 11:27:01','',''),(5148,'1','274','1',1,'Retail Sale Id 5007',4002.72,0.00,0.00,5.38,425.02,'2022-09-08 11:29:17','',''),(5149,'1','274','1',1,'Retail Sale Id 5008',2001.36,0.00,0.00,2.69,212.51,'2022-09-08 12:01:37','',''),(5150,'1','274','1',1,'Retail Sale Id 5009',7998.00,0.00,0.00,10.75,849.25,'2022-09-08 12:17:36','',''),(5151,'1','274','1',1,'Retail Sale Id 5010',2998.32,0.00,0.00,4.03,318.37,'2022-09-08 12:24:24','',''),(5152,'1','274','1',1,'Retail Sale Id 5011',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 12:31:15','',''),(5153,'1','274','1',1,'Retail Sale Id 5012',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 12:54:34','',''),(5154,'1','274','1',1,'Retail Sale Id 5013',4501.20,0.00,0.00,6.05,477.95,'2022-09-08 13:03:46','',''),(5155,'1','274','1',1,'Retail Sale Id 5014',744.00,0.00,0.00,1.00,79.00,'2022-09-08 13:05:49','',''),(5156,'1','274','1',1,'Retail Sale Id 5016',4999.68,0.00,0.00,6.72,530.88,'2022-09-08 13:07:05','',''),(5157,'1','274','1',1,'Retail Sale Id 5017',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 13:32:25','',''),(5158,'1','274','1',1,'Retail Sale Id 5018',8198.88,0.00,0.00,11.02,870.58,'2022-09-08 13:51:46','',''),(5159,'1','274','1',1,'Retail Sale Id 5019',900.24,0.00,0.00,1.21,95.59,'2022-09-08 13:59:27','',''),(5160,'1','274','1',1,'Retail Sale Id 5020',2499.84,0.00,0.00,3.36,265.44,'2022-09-08 14:04:29','',''),(5161,'1','274','1',1,'Retail Sale Id 5021',8496.48,0.00,0.00,11.42,902.18,'2022-09-08 14:08:58','',''),(5162,'1','274','1',1,'Retail Sale Id 5022',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 14:13:19','',''),(5163,'1','274','1',1,'Retail Sale Id 5023',4501.20,0.00,0.00,6.05,477.95,'2022-09-08 14:16:25','',''),(5164,'1','274','1',1,'Retail Sale Id 5024',4501.20,0.00,0.00,6.05,477.95,'2022-09-08 14:23:02','',''),(5165,'1','274','1',1,'Retail Sale Id 5028',3720.00,0.00,0.00,5.00,395.00,'2022-09-08 14:32:40','',''),(5166,'1','274','1',1,'Retail Sale Id 5029',2998.32,0.00,0.00,4.03,318.37,'2022-09-08 14:39:41','',''),(5167,'1','274','1',1,'Retail Sale Id 5030',18600.00,0.00,0.00,25.00,1975.00,'2022-09-08 14:47:01','',''),(5168,'1','274','1',1,'Retail Sale Id 5031',10497.84,0.00,0.00,14.11,1114.69,'2022-09-08 14:52:13','',''),(5169,'1','274','1',1,'Retail Sale Id 5032',1502.88,0.00,0.00,2.02,159.58,'2022-09-08 14:52:59','',''),(5170,'1','274','1',1,'Retail Sale Id 5033',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 15:41:50','',''),(5171,'1','274','1',1,'Retail Sale Id 5034',4501.20,0.00,0.00,6.05,477.95,'2022-09-08 16:01:27','',''),(5172,'1','274','1',1,'Retail Sale Id 5034',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 16:01:27','',''),(5173,'1','274','1',1,'Retail Sale Id 5035',2246.88,0.00,0.00,3.02,238.58,'2022-09-08 16:11:52','',''),(5174,'1','274','1',1,'Retail Sale Id 5036',2499.84,0.00,0.00,3.36,265.44,'2022-09-08 16:13:45','',''),(5175,'1','274','1',1,'Retail Sale Id 5037',4002.72,0.00,0.00,5.38,425.02,'2022-09-08 16:28:17','',''),(5176,'1','274','1',1,'Return of Retail Sale Id 5037',0.00,4002.72,5.38,0.00,-425.02,'2022-09-08 16:28:54','',''),(5177,'1','274','1',1,'Retail Sale Id 5038',2001.36,0.00,0.00,2.69,212.51,'2022-09-08 16:29:57','',''),(5178,'1','274','1',1,'Retail Sale Id 5039',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 16:45:13','',''),(5179,'1','274','1',1,'Retail Sale Id 5040',2001.36,0.00,0.00,2.69,212.51,'2022-09-08 16:56:14','',''),(5180,'1','274','1',1,'Retail Sale Id 5041',4501.20,0.00,0.00,6.05,477.95,'2022-09-08 17:11:15','',''),(5181,'1','274','1',1,'Retail Sale Id 5042',4999.68,0.00,0.00,6.72,530.88,'2022-09-08 17:12:50','',''),(5182,'1','274','1',1,'Retail Sale Id 5043',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 17:16:11','',''),(5183,'1','274','1',1,'Retail Sale Id 5044',2998.32,0.00,0.00,4.03,318.37,'2022-09-08 17:25:02','',''),(5184,'1','274','1',1,'Retail Sale Id 5045',4501.20,0.00,0.00,6.05,477.95,'2022-09-08 17:32:54','',''),(5185,'1','274','1',1,'Retail Sale Id 5046',37.20,0.00,0.00,0.05,3.95,'2022-09-08 17:35:38','',''),(5186,'1','274','1',1,'Retail Sale Id 5047',29760.00,0.00,0.00,40.00,3160.00,'2022-09-08 17:36:52','',''),(5187,'1','274','1',1,'Return of Retail Sale Id 5046',0.00,37.20,0.05,0.00,-3.95,'2022-09-08 17:37:20','',''),(5188,'1','274','1',1,'Retail Sale Id 5048',4501.20,0.00,0.00,6.05,477.95,'2022-09-08 17:37:59','',''),(5189,'1','274','1',1,'Retail Sale Id 5049',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 17:38:51','',''),(5190,'1','274','1',1,'Retail Sale Id 5050',5208.00,0.00,0.00,7.00,553.00,'2022-09-08 17:39:47','',''),(5191,'1','274','1',1,'Retail Sale Id 5051',1302.00,0.00,0.00,1.75,138.25,'2022-09-08 17:40:44','',''),(5192,'1','274','1',1,'Retail Sale Id 5052',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 17:41:48','',''),(5193,'1','274','1',1,'Retail Sale Id 5053',2998.32,0.00,0.00,4.03,318.37,'2022-09-08 18:03:24','',''),(5194,'1','274','1',1,'Retail Sale Id 5054',996.96,0.00,0.00,1.34,105.86,'2022-09-08 18:05:22','',''),(5195,'1','274','1',1,'Retail Sale Id 5055',3749.76,0.00,0.00,5.04,398.16,'2022-09-08 18:22:18','',''),(5196,'1','274','1',1,'Return of Retail Sale Id 5055',0.00,3749.76,5.04,0.00,-398.16,'2022-09-08 18:23:08','',''),(5197,'1','274','1',1,'Retail Sale Id 5056',3801.84,0.00,0.00,5.11,403.69,'2022-09-08 18:23:38','',''),(5198,'1','274','1',1,'Retail Sale Id 5057',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 18:33:24','',''),(5199,'1','274','1',1,'Retail Sale Id 5058',9300.00,0.00,0.00,12.50,987.50,'2022-09-08 18:35:21','',''),(5200,'1','274','1',1,'Retail Sale Id 5059',4999.68,0.00,0.00,6.72,530.88,'2022-09-08 18:41:07','',''),(5201,'1','274','1',1,'Retail Sale Id 5060',3749.76,0.00,0.00,5.04,398.16,'2022-09-08 18:44:37','',''),(5202,'1','274','1',1,'Retail Sale Id 5061',3749.76,0.00,0.00,5.04,398.16,'2022-09-08 18:45:20','',''),(5203,'1','274','1',1,'Retail Sale Id 5062',5996.64,0.00,0.00,8.06,636.74,'2022-09-08 19:00:17','',''),(5204,'1','274','1',1,'Retail Sale Id 5063',38546.64,0.00,0.00,51.81,4092.99,'2022-09-08 19:33:14','',''),(5205,'1','274','1',1,'Retail Sale Id 5064',39774.24,0.00,0.00,53.46,4223.34,'2022-09-08 19:34:20','',''),(5206,'1','274','1',1,'Retail Sale Id 5065',22320.00,0.00,0.00,30.00,2370.00,'2022-09-08 19:35:31','',''),(5207,'1','274','1',1,'Retail Sale Id 5066',22320.00,0.00,0.00,30.00,2370.00,'2022-09-09 08:38:43','',''),(5208,'1','274','1',1,'Retail Sale Id 5068',82286.40,0.00,0.00,110.60,8737.40,'2022-09-09 10:02:38','',''),(5209,'1','274','1',1,'Retail Sale Id 5069',3496.80,0.00,0.00,4.70,371.30,'2022-09-09 10:03:04','',''),(5210,'1','274','1',1,'Retail Sale Id 5070',7001.04,0.00,0.00,9.41,743.39,'2022-09-09 10:03:40','',''),(5211,'1','274','1',1,'Retail Sale Id 5071',2232000.00,0.00,0.00,3000.00,237000.00,'2022-09-09 10:04:35','',''),(5212,'1','274','1',1,'Return of Retail Sale Id 5071',0.00,2232000.00,3000.00,0.00,-237000.00,'2022-09-09 10:07:34','',''),(5213,'1','274','1',1,'Retail Sale Id 5072',2998.32,0.00,0.00,4.03,318.37,'2022-09-09 10:08:21','',''),(5214,'1','274','1',1,'Retail Sale Id 5073',9300.00,0.00,0.00,12.50,987.50,'2022-09-09 10:32:54','',''),(5215,'1','274','1',1,'Retail Sale Id 5074',5996.64,0.00,0.00,8.06,636.74,'2022-09-09 10:50:26','',''),(5216,'1','274','1',1,'Retail Sale Id 5075',9300.00,0.00,0.00,12.50,987.50,'2022-09-09 11:01:26','',''),(5217,'1','274','1',1,'Retail Sale Id 5076',14880.00,0.00,0.00,20.00,1580.00,'2022-09-09 11:02:35','',''),(5218,'1','274','1',1,'Retail Sale Id 5077',4501.20,0.00,0.00,6.05,477.95,'2022-09-09 11:08:31','',''),(5219,'1','274','1',1,'Retail Sale Id 5078',9300.00,0.00,0.00,12.50,987.50,'2022-09-09 11:33:06','',''),(5220,'1','274','1',1,'Retail Sale Id 5079',996.96,0.00,0.00,1.34,105.86,'2022-09-09 11:40:40','',''),(5221,'1','274','1',1,'Retail Sale Id 5080',2499.84,0.00,0.00,3.36,265.44,'2022-09-09 12:12:12','',''),(5222,'1','274','1',1,'Retail Sale Id 5081',9300.00,0.00,0.00,12.50,987.50,'2022-09-09 12:17:11','',''),(5223,'1','274','1',1,'Retail Sale Id 5082',9672.00,0.00,0.00,13.00,1027.00,'2022-09-09 12:19:52','',''),(5224,'1','274','1',1,'Retail Sale Id 5083',4501.20,0.00,0.00,6.05,477.95,'2022-09-09 12:22:16','',''),(5225,'1','274','1',1,'Retail Sale Id 5084',2001.36,0.00,0.00,2.69,212.51,'2022-09-09 13:00:50','',''),(5226,'1','274','1',1,'Retail Sale Id 5085',996.96,0.00,0.00,1.34,105.86,'2022-09-09 13:01:59','',''),(5227,'1','274','1',1,'Retail Sale Id 5086',3749.76,0.00,0.00,5.04,398.16,'2022-09-09 13:04:23','',''),(5228,'1','274','1',1,'Retail Sale Id 5087',9300.00,0.00,0.00,12.50,987.50,'2022-09-09 13:11:01','',''),(5229,'1','274','1',1,'Retail Sale Id 5088',37200.00,0.00,0.00,50.00,3950.00,'2022-09-09 13:14:34','',''),(5230,'1','274','1',1,'Retail Sale Id 5089',9300.00,0.00,0.00,12.50,987.50,'2022-09-09 14:05:22','',''),(5231,'1','274','1',1,'Retail Sale Id 5090',2001.36,0.00,0.00,2.69,212.51,'2022-09-09 14:11:03','',''),(5232,'1','274','1',1,'Retail Sale Id 5091',1502.88,0.00,0.00,2.02,159.58,'2022-09-09 14:13:40','',''),(5233,'1','274','1',1,'Retail Sale Id 5092',4501.20,0.00,0.00,6.05,477.95,'2022-09-09 14:24:16','',''),(5234,'1','274','1',1,'Retail Sale Id 5093',18600.00,0.00,0.00,25.00,1975.00,'2022-09-09 14:28:10','',''),(5235,'1','274','1',1,'Retail Sale Id 5093',37200.00,0.00,0.00,50.00,3950.00,'2022-09-09 14:28:10','',''),(5236,'1','274','1',1,'Retail Sale Id 5094',9300.00,0.00,0.00,12.50,987.50,'2022-09-09 14:43:08','',''),(5237,'1','274','1',1,'Retail Sale Id 5095',7440.00,0.00,0.00,10.00,790.00,'2022-09-09 14:45:44','',''),(5238,'1','274','1',1,'Retail Sale Id 5095',9300.00,0.00,0.00,12.50,987.50,'2022-09-09 14:45:44','',''),(5239,'1','274','1',1,'Retail Sale Id 5096',9002.40,0.00,0.00,12.10,955.90,'2022-09-09 14:49:13','',''),(5240,'1','274','1',1,'Retail Sale Id 5097',2246.88,0.00,0.00,3.02,238.58,'2022-09-09 14:50:22','',''),(5241,'1','274','1',1,'Retail Sale Id 5098',2001.36,0.00,0.00,2.69,212.51,'2022-09-09 14:51:49','',''),(5242,'1','274','1',1,'Retail Sale Id 5099',1800.48,0.00,0.00,2.42,191.18,'2022-09-09 14:55:25','',''),(5243,'1','274','1',1,'Retail Sale Id 5101',4501.20,0.00,0.00,6.05,477.95,'2022-09-09 14:59:30','',''),(5244,'1','274','1',1,'Retail Sale Id 5103',9300.00,0.00,0.00,12.50,987.50,'2022-09-09 15:06:15','',''),(5245,'1','274','1',1,'Retail Sale Id 5104',4999.68,0.00,0.00,6.72,530.88,'2022-09-09 15:14:14','',''),(5246,'1','274','1',1,'Retail Sale Id 5104',9300.00,0.00,0.00,12.50,987.50,'2022-09-09 15:14:14','',''),(5247,'1','274','1',1,'Retail Sale Id 5105',4501.20,0.00,0.00,6.05,477.95,'2022-09-09 15:31:59','',''),(5248,'1','274','1',1,'Retail Sale Id 5106',1502.88,0.00,0.00,2.02,159.58,'2022-09-09 15:48:11','',''),(5249,'1','274','1',1,'Retail Sale Id 5107',2499.84,0.00,0.00,3.36,265.44,'2022-09-09 16:16:37','',''),(5250,'1','274','1',1,'Retail Sale Id 5107',3496.80,0.00,0.00,4.70,371.30,'2022-09-09 16:16:37','',''),(5251,'1','274','1',1,'Retail Sale Id 5108',4501.20,0.00,0.00,6.05,477.95,'2022-09-09 16:21:24','',''),(5252,'1','274','1',1,'Retail Sale Id 5109',2001.36,0.00,0.00,2.69,212.51,'2022-09-09 16:24:28','',''),(5253,'1','274','1',1,'Retail Sale Id 5110',3600.96,0.00,0.00,4.84,382.36,'2022-09-09 16:33:25','',''),(5254,'1','274','1',1,'Retail Sale Id 5111',9300.00,0.00,0.00,12.50,987.50,'2022-09-09 17:01:03','',''),(5255,'1','274','1',1,'Retail Sale Id 5112',4501.20,0.00,0.00,6.05,477.95,'2022-09-09 17:04:07','',''),(5256,'1','274','1',1,'Retail Sale Id 5113',4501.20,0.00,0.00,6.05,477.95,'2022-09-09 17:30:42','',''),(5257,'1','274','1',1,'Retail Sale Id 5114',2001.36,0.00,0.00,2.69,212.51,'2022-09-09 17:55:57','',''),(5258,'1','274','1',1,'Retail Sale Id 5115',2998.32,0.00,0.00,4.03,318.37,'2022-09-09 17:57:23','',''),(5259,'1','274','1',1,'Retail Sale Id 5117',9300.00,0.00,0.00,12.50,987.50,'2022-09-09 18:03:08','',''),(5260,'1','274','1',1,'Retail Sale Id 5118',2001.36,0.00,0.00,2.69,212.51,'2022-09-09 18:05:06','',''),(5261,'1','274','1',1,'Retail Sale Id 5119',1502.88,0.00,0.00,2.02,159.58,'2022-09-09 18:06:40','',''),(5262,'1','274','1',1,'Retail Sale Id 5120',2001.36,0.00,0.00,2.69,212.51,'2022-09-09 18:18:45','',''),(5263,'1','274','1',1,'Retail Sale Id 5121',2499.84,0.00,0.00,3.36,265.44,'2022-09-09 18:21:43','',''),(5264,'1','274','1',1,'Retail Sale Id 5122',3749.76,0.00,0.00,5.04,398.16,'2022-09-09 18:28:02','',''),(5265,'1','274','1',1,'Retail Sale Id 5124',9300.00,0.00,0.00,12.50,987.50,'2022-09-09 18:48:39','',''),(5266,'1','274','1',1,'Retail Sale Id 5124',37200.00,0.00,0.00,50.00,3950.00,'2022-09-09 18:48:39','',''),(5267,'1','274','1',1,'Retail Sale Id 5125',13503.60,0.00,0.00,18.15,1433.85,'2022-09-09 18:52:03','',''),(5268,'1','274','1',1,'Retail Sale Id 5126',9300.00,0.00,0.00,12.50,987.50,'2022-09-09 18:53:09','',''),(5269,'1','274','1',1,'Retail Sale Id 5127',40920.00,0.00,0.00,55.00,4345.00,'2022-09-09 19:17:04','',''),(5270,'1','274','1',1,'Return of Retail Sale Id 5124',0.00,9300.00,12.50,0.00,-987.50,'2022-09-09 19:18:28','',''),(5271,'1','274','1',1,'Return of Retail Sale Id 5124',0.00,37200.00,50.00,0.00,-3950.00,'2022-09-09 19:18:28','',''),(5272,'1','274','1',1,'Retail Sale Id 5128',32929.44,0.00,0.00,44.26,3496.54,'2022-09-09 19:19:30','',''),(5273,'1','274','1',1,'Retail Sale Id 5129',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 08:07:26','',''),(5274,'1','274','1',1,'Retail Sale Id 5130',5208.00,0.00,0.00,7.00,553.00,'2022-09-10 08:07:57','',''),(5275,'1','274','1',1,'Retail Sale Id 5131',12000.72,0.00,0.00,16.13,1274.27,'2022-09-10 08:12:12','',''),(5276,'1','274','1',1,'Retail Sale Id 5132',1502.88,0.00,0.00,2.02,159.58,'2022-09-10 08:18:30','',''),(5277,'1','274','1',1,'Retail Sale Id 5133',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 08:32:34','',''),(5278,'1','274','1',1,'Retail Sale Id 5134',2998.32,0.00,0.00,4.03,318.37,'2022-09-10 08:33:33','',''),(5279,'1','274','1',1,'Retail Sale Id 5135',2001.36,0.00,0.00,2.69,212.51,'2022-09-10 08:43:12','',''),(5280,'1','274','1',1,'Retail Sale Id 5136',4501.20,0.00,0.00,6.05,477.95,'2022-09-10 08:45:35','',''),(5281,'1','274','1',1,'Retail Sale Id 5137',4501.20,0.00,0.00,6.05,477.95,'2022-09-10 09:00:45','',''),(5282,'1','274','1',1,'Retail Sale Id 5138',2298.96,0.00,0.00,3.09,244.11,'2022-09-10 09:50:46','',''),(5283,'1','274','1',1,'Retail Sale Id 5139',1502.88,0.00,0.00,2.02,159.58,'2022-09-10 09:54:30','',''),(5284,'1','274','1',1,'Retail Sale Id 5140',17000.40,0.00,0.00,22.85,1805.15,'2022-09-10 09:55:47','',''),(5285,'1','274','1',1,'Retail Sale Id 5141',2001.36,0.00,0.00,2.69,212.51,'2022-09-10 09:56:50','',''),(5286,'1','274','1',1,'Retail Sale Id 5142',48746.88,0.00,0.00,65.52,5176.08,'2022-09-10 10:01:59','',''),(5287,'1','274','1',1,'Retail Sale Id 5143',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 10:13:10','',''),(5288,'1','274','1',1,'Retail Sale Id 5144',22349.76,0.00,0.00,30.04,2373.16,'2022-09-10 10:16:10','',''),(5289,'1','274','1',1,'Retail Sale Id 5145',4501.20,0.00,0.00,6.05,477.95,'2022-09-10 10:30:30','',''),(5290,'1','274','1',1,'Retail Sale Id 5146',2998.32,0.00,0.00,4.03,318.37,'2022-09-10 10:39:58','',''),(5291,'1','274','1',1,'Retail Sale Id 5147',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 10:57:15','',''),(5292,'1','274','1',1,'Retail Sale Id 5148',1502.88,0.00,0.00,2.02,159.58,'2022-09-10 11:13:57','',''),(5293,'1','274','1',1,'Retail Sale Id 5149',1502.88,0.00,0.00,2.02,159.58,'2022-09-10 11:25:37','',''),(5294,'1','274','1',1,'Retail Sale Id 5150',4999.68,0.00,0.00,6.72,530.88,'2022-09-10 11:59:10','',''),(5295,'1','274','1',1,'Retail Sale Id 5151',1502.88,0.00,0.00,2.02,159.58,'2022-09-10 13:24:49','',''),(5296,'1','274','1',1,'Retail Sale Id 5152',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 13:30:09','',''),(5297,'1','274','1',1,'Retail Sale Id 5153',4501.20,0.00,0.00,6.05,477.95,'2022-09-10 13:42:20','',''),(5298,'1','274','1',1,'Retail Sale Id 5155',44699.52,0.00,0.00,60.08,4746.32,'2022-09-10 14:03:29','',''),(5299,'1','274','1',1,'Retail Sale Id 5156',1696.32,0.00,0.00,2.28,180.12,'2022-09-10 14:07:09','',''),(5300,'1','274','1',1,'Retail Sale Id 5157',8496.48,0.00,0.00,11.42,902.18,'2022-09-10 14:11:44','',''),(5301,'1','274','1',1,'Retail Sale Id 5158',2998.32,0.00,0.00,4.03,318.37,'2022-09-10 14:15:47','',''),(5302,'1','274','1',1,'Retail Sale Id 5159',4002.72,0.00,0.00,5.38,425.02,'2022-09-10 14:26:19','',''),(5303,'1','274','1',1,'Retail Sale Id 5160',2246.88,0.00,0.00,3.02,238.58,'2022-09-10 14:30:18','',''),(5304,'1','274','1',1,'Retail Sale Id 5161',6703.44,0.00,0.00,9.01,711.79,'2022-09-10 14:31:41','',''),(5305,'1','274','1',1,'Retail Sale Id 5162',3749.76,0.00,0.00,5.04,398.16,'2022-09-10 14:34:03','',''),(5306,'1','274','1',1,'Retail Sale Id 5163',6800.16,0.00,0.00,9.14,722.06,'2022-09-10 14:37:50','',''),(5307,'1','274','1',1,'Retail Sale Id 5164',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 14:39:31','',''),(5308,'1','274','1',1,'Retail Sale Id 5165',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 14:42:44','',''),(5309,'1','274','1',1,'Retail Sale Id 5166',7998.00,0.00,0.00,10.75,849.25,'2022-09-10 14:46:48','',''),(5310,'1','274','1',1,'Retail Sale Id 5167',4501.20,0.00,0.00,6.05,477.95,'2022-09-10 14:48:03','',''),(5311,'1','274','1',1,'Retail Sale Id 5168',4501.20,0.00,0.00,6.05,477.95,'2022-09-10 14:49:05','',''),(5312,'1','274','1',1,'Retail Sale Id 5169',2246.88,0.00,0.00,3.02,238.58,'2022-09-10 15:05:28','',''),(5313,'1','274','1',1,'Retail Sale Id 5170',4501.20,0.00,0.00,6.05,477.95,'2022-09-10 15:22:50','',''),(5314,'1','274','1',1,'Retail Sale Id 5171',46500.00,0.00,0.00,62.50,4937.50,'2022-09-10 15:24:34','',''),(5315,'1','274','1',1,'Return of Retail Sale Id 5171',0.00,46500.00,62.50,0.00,-4937.50,'2022-09-10 15:26:10','',''),(5316,'1','274','1',1,'Retail Sale Id 5172',46500.00,0.00,0.00,62.50,4937.50,'2022-09-10 15:26:39','',''),(5317,'1','274','1',1,'Retail Sale Id 5173',9002.40,0.00,0.00,12.10,955.90,'2022-09-10 15:29:26','',''),(5318,'1','274','1',1,'Retail Sale Id 5174',2001.36,0.00,0.00,2.69,212.51,'2022-09-10 15:42:00','',''),(5319,'1','274','1',1,'Retail Sale Id 5175',2001.36,0.00,0.00,2.69,212.51,'2022-09-10 16:04:52','',''),(5320,'1','274','1',1,'Retail Sale Id 5176',1502.88,0.00,0.00,2.02,159.58,'2022-09-10 16:14:32','',''),(5321,'1','274','1',1,'Retail Sale Id 5177',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 16:18:17','',''),(5322,'1','274','1',1,'Retail Sale Id 5178',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 16:21:03','',''),(5323,'1','274','1',1,'Retail Sale Id 5179',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 16:26:19','',''),(5324,'1','274','1',1,'Retail Sale Id 5180',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 16:40:29','',''),(5325,'1','274','1',1,'Retail Sale Id 5181',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 16:59:49','',''),(5326,'1','274','1',1,'Retail Sale Id 5182',18600.00,0.00,0.00,25.00,1975.00,'2022-09-10 17:01:47','',''),(5327,'1','274','1',1,'Retail Sale Id 5184',9300.00,0.00,0.00,12.50,987.50,'2022-09-10 17:05:54','',''),(5328,'1','274','1',1,'Retail Sale Id 5185',996.96,0.00,0.00,1.34,105.86,'2022-09-10 17:11:01','',''),(5329,'1','274','1',1,'Retail Sale Id 5187',4999.68,0.00,0.00,6.72,530.88,'2022-09-10 17:30:40','',''),(5330,'1','274','1',1,'Retail Sale Id 5188',4501.20,0.00,0.00,6.05,477.95,'2022-09-10 17:31:49','',''),(5331,'1','274','1',1,'Retail Sale Id 5189',9701.76,0.00,0.00,13.04,1030.16,'2022-09-10 17:35:32','',''),(5332,'1','274','1',1,'Retail Sale Id 5190',996.96,0.00,0.00,1.34,105.86,'2022-09-10 17:37:35','',''),(5333,'1','274','1',1,'Retail Sale Id 5191',2246.88,0.00,0.00,3.02,238.58,'2022-09-10 17:43:32','',''),(5334,'1','274','1',1,'Retail Sale Id 5192',2998.32,0.00,0.00,4.03,318.37,'2022-09-10 17:46:10','',''),(5335,'1','274','1',1,'Retail Sale Id 5193',3749.76,0.00,0.00,5.04,398.16,'2022-09-10 17:50:51','',''),(5336,'1','274','1',1,'Retail Sale Id 5194',7499.52,0.00,0.00,10.08,796.32,'2022-09-10 17:54:22','',''),(5337,'1','274','1',1,'Retail Sale Id 5195',26910.48,0.00,0.00,36.17,2857.43,'2022-09-10 18:27:23','',''),(5338,'1','274','1',1,'Retail Sale Id 5196',59252.16,0.00,0.00,79.64,6291.56,'2022-09-10 18:28:28','',''),(5339,'1','274','1',1,'Retail Sale Id 5197',37200.00,0.00,0.00,50.00,3950.00,'2022-09-11 07:47:06','',''),(5340,'1','274','1',1,'Retail Sale Id 5198',7499.52,0.00,0.00,10.08,796.32,'2022-09-11 08:28:32','',''),(5341,'1','274','1',1,'Retail Sale Id 5199',4002.72,0.00,0.00,5.38,425.02,'2022-09-11 08:39:16','',''),(5342,'1','274','1',1,'Retail Sale Id 5200',4002.72,0.00,0.00,5.38,425.02,'2022-09-11 08:40:58','',''),(5343,'1','274','1',1,'Retail Sale Id 5201',11546.88,0.00,0.00,15.52,1226.08,'2022-09-11 08:43:31','',''),(5344,'1','274','1',1,'Retail Sale Id 5202',2998.32,0.00,0.00,4.03,318.37,'2022-09-11 08:44:23','',''),(5345,'1','274','1',1,'Retail Sale Id 5203',1502.88,0.00,0.00,2.02,159.58,'2022-09-11 08:45:21','',''),(5346,'1','274','1',1,'Retail Sale Id 5204',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 08:47:16','',''),(5347,'1','274','1',1,'Retail Sale Id 5205',2998.32,0.00,0.00,4.03,318.37,'2022-09-11 08:53:58','',''),(5348,'1','274','1',1,'Retail Sale Id 5206',1502.88,0.00,0.00,2.02,159.58,'2022-09-11 08:54:43','',''),(5349,'1','274','1',1,'Retail Sale Id 5208',16003.44,0.00,0.00,21.51,1699.29,'2022-09-11 08:56:32','',''),(5350,'1','274','1',1,'Retail Sale Id 5209',8198.88,0.00,0.00,11.02,870.58,'2022-09-11 09:00:17','',''),(5351,'1','274','1',1,'Retail Sale Id 5210',4999.68,0.00,0.00,6.72,530.88,'2022-09-11 09:13:53','',''),(5352,'1','274','1',1,'Retail Sale Id 5211',6748.08,0.00,0.00,9.07,716.53,'2022-09-11 09:23:43','',''),(5353,'1','274','1',1,'Retail Sale Id 5212',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 09:33:00','',''),(5354,'1','274','1',1,'Retail Sale Id 5213',2001.36,0.00,0.00,2.69,212.51,'2022-09-11 09:41:42','',''),(5355,'1','274','1',1,'Retail Sale Id 5214',3749.76,0.00,0.00,5.04,398.16,'2022-09-11 09:42:46','',''),(5356,'1','274','1',1,'Retail Sale Id 5215',4002.72,0.00,0.00,5.38,425.02,'2022-09-11 09:50:11','',''),(5357,'1','274','1',1,'Retail Sale Id 5216',2001.36,0.00,0.00,2.69,212.51,'2022-09-11 09:51:55','',''),(5358,'1','274','1',1,'Retail Sale Id 5217',2246.88,0.00,0.00,3.02,238.58,'2022-09-11 09:52:48','',''),(5359,'1','274','1',1,'Retail Sale Id 5218',2998.32,0.00,0.00,4.03,318.37,'2022-09-11 10:10:58','',''),(5360,'1','274','1',1,'Retail Sale Id 5219',4501.20,0.00,0.00,6.05,477.95,'2022-09-11 10:22:08','',''),(5361,'1','274','1',1,'Retail Sale Id 5220',4501.20,0.00,0.00,6.05,477.95,'2022-09-11 10:23:38','',''),(5362,'1','274','1',1,'Retail Sale Id 5221',7499.52,0.00,0.00,10.08,796.32,'2022-09-11 10:25:10','',''),(5363,'1','274','1',1,'Retail Sale Id 5223',2499.84,0.00,0.00,3.36,265.44,'2022-09-11 10:35:05','',''),(5364,'1','274','1',1,'Retail Sale Id 5224',17000.40,0.00,0.00,22.85,1805.15,'2022-09-11 10:49:55','',''),(5365,'1','274','1',1,'Retail Sale Id 5226',6748.08,0.00,0.00,9.07,716.53,'2022-09-11 10:57:20','',''),(5366,'1','274','1',1,'Retail Sale Id 5227',2246.88,0.00,0.00,3.02,238.58,'2022-09-11 11:02:34','',''),(5367,'1','274','1',1,'Retail Sale Id 5228',18600.00,0.00,0.00,25.00,1975.00,'2022-09-11 11:08:45','',''),(5368,'1','274','1',1,'Retail Sale Id 5229',40949.76,0.00,0.00,55.04,4348.16,'2022-09-11 11:09:32','',''),(5369,'1','274','1',1,'Retail Sale Id 5230',1502.88,0.00,0.00,2.02,159.58,'2022-09-11 11:15:19','',''),(5370,'1','274','1',1,'Retail Sale Id 5231',2001.36,0.00,0.00,2.69,212.51,'2022-09-11 11:18:19','',''),(5371,'1','274','1',1,'Retail Sale Id 5232',2998.32,0.00,0.00,4.03,318.37,'2022-09-11 11:19:12','',''),(5372,'1','274','1',1,'Retail Sale Id 5233',4501.20,0.00,0.00,6.05,477.95,'2022-09-11 11:23:44','',''),(5373,'1','274','1',1,'Retail Sale Id 5234',4501.20,0.00,0.00,6.05,477.95,'2022-09-11 11:25:08','',''),(5374,'1','274','1',1,'Retail Sale Id 5235',2998.32,0.00,0.00,4.03,318.37,'2022-09-11 11:29:52','',''),(5375,'1','274','1',1,'Retail Sale Id 5236',8496.48,0.00,0.00,11.42,902.18,'2022-09-11 11:43:09','',''),(5376,'1','274','1',1,'Retail Sale Id 5237',7499.52,0.00,0.00,10.08,796.32,'2022-09-11 11:50:09','',''),(5377,'1','274','1',1,'Retail Sale Id 5238',2246.88,0.00,0.00,3.02,238.58,'2022-09-11 11:52:03','',''),(5378,'1','274','1',1,'Retail Sale Id 5239',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 11:55:23','',''),(5379,'1','274','1',1,'Retail Sale Id 5240',22349.76,0.00,0.00,30.04,2373.16,'2022-09-11 12:02:46','',''),(5380,'1','274','1',1,'Retail Sale Id 5241',2001.36,0.00,0.00,2.69,212.51,'2022-09-11 12:10:13','',''),(5381,'1','274','1',1,'Retail Sale Id 5242',2202.24,0.00,0.00,2.96,233.84,'2022-09-11 12:14:01','',''),(5382,'1','274','1',1,'Retail Sale Id 5243',2998.32,0.00,0.00,4.03,318.37,'2022-09-11 12:14:54','',''),(5383,'1','274','1',1,'Retail Sale Id 5244',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 12:20:03','',''),(5384,'1','274','1',1,'Retail Sale Id 5245',2998.32,0.00,0.00,4.03,318.37,'2022-09-11 12:22:17','',''),(5385,'1','274','1',1,'Retail Sale Id 5246',12000.72,0.00,0.00,16.13,1274.27,'2022-09-11 12:35:17','',''),(5386,'1','274','1',1,'Retail Sale Id 5247',2499.84,0.00,0.00,3.36,265.44,'2022-09-11 12:37:55','',''),(5387,'1','274','1',1,'Retail Sale Id 5248',2001.36,0.00,0.00,2.69,212.51,'2022-09-11 12:42:01','',''),(5388,'1','274','1',1,'Retail Sale Id 5249',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 12:48:49','',''),(5389,'1','274','1',1,'Retail Sale Id 5250',1502.88,0.00,0.00,2.02,159.58,'2022-09-11 12:54:43','',''),(5390,'1','274','1',1,'Retail Sale Id 5251',3496.80,0.00,0.00,4.70,371.30,'2022-09-11 13:04:53','',''),(5391,'1','274','1',1,'Retail Sale Id 5252',2499.84,0.00,0.00,3.36,265.44,'2022-09-11 13:05:47','',''),(5392,'1','274','1',1,'Retail Sale Id 5253',4501.20,0.00,0.00,6.05,477.95,'2022-09-11 13:12:58','',''),(5393,'1','274','1',1,'Retail Sale Id 5254',22997.04,0.00,0.00,30.91,2441.89,'2022-09-11 13:39:04','',''),(5394,'1','274','1',1,'Retail Sale Id 5255',7998.00,0.00,0.00,10.75,849.25,'2022-09-11 14:08:57','',''),(5395,'1','274','1',1,'Retail Sale Id 5256',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 14:10:42','',''),(5396,'1','274','1',1,'Retail Sale Id 5257',2001.36,0.00,0.00,2.69,212.51,'2022-09-11 14:12:21','',''),(5397,'1','274','1',1,'Retail Sale Id 5258',17900.64,0.00,0.00,24.06,1900.74,'2022-09-11 14:15:29','',''),(5398,'1','274','1',1,'Retail Sale Id 5259',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 14:18:19','',''),(5399,'1','274','1',1,'Retail Sale Id 5260',4002.72,0.00,0.00,5.38,425.02,'2022-09-11 14:19:39','',''),(5400,'1','274','1',1,'Retail Sale Id 5261',16799.52,0.00,0.00,22.58,1783.82,'2022-09-11 14:39:02','',''),(5401,'1','274','1',1,'Retail Sale Id 5262',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 14:43:41','',''),(5402,'1','274','1',1,'Retail Sale Id 5263',4501.20,0.00,0.00,6.05,477.95,'2022-09-11 14:56:24','',''),(5403,'1','274','1',1,'Retail Sale Id 5264',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 14:58:09','',''),(5404,'1','274','1',1,'Retail Sale Id 5265',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 15:02:50','',''),(5405,'1','274','1',1,'Retail Sale Id 5266',2001.36,0.00,0.00,2.69,212.51,'2022-09-11 15:04:01','',''),(5406,'1','274','1',1,'Retail Sale Id 5267',13049.76,0.00,0.00,17.54,1385.66,'2022-09-11 15:06:31','',''),(5407,'1','274','1',1,'Retail Sale Id 5268',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 15:09:13','',''),(5408,'1','274','1',1,'Retail Sale Id 5269',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 15:42:19','',''),(5409,'1','274','1',1,'Retail Sale Id 5270',13801.20,0.00,0.00,18.55,1465.45,'2022-09-11 15:47:02','',''),(5410,'1','274','1',1,'Retail Sale Id 5271',4501.20,0.00,0.00,6.05,477.95,'2022-09-11 15:51:23','',''),(5411,'1','274','1',1,'Retail Sale Id 5272',4501.20,0.00,0.00,6.05,477.95,'2022-09-11 15:57:01','',''),(5412,'1','274','1',1,'Retail Sale Id 5273',1502.88,0.00,0.00,2.02,159.58,'2022-09-11 15:58:24','',''),(5413,'1','274','1',1,'Retail Sale Id 5274',4999.68,0.00,0.00,6.72,530.88,'2022-09-11 16:00:01','',''),(5414,'1','274','1',1,'Retail Sale Id 5275',11948.64,0.00,0.00,16.06,1268.74,'2022-09-11 16:01:47','',''),(5415,'1','274','1',1,'Retail Sale Id 5276',19998.72,0.00,0.00,26.88,2123.52,'2022-09-11 16:27:44','',''),(5416,'1','274','1',1,'Retail Sale Id 5277',4501.20,0.00,0.00,6.05,477.95,'2022-09-11 16:35:18','',''),(5417,'1','274','1',1,'Retail Sale Id 5278',3496.80,0.00,0.00,4.70,371.30,'2022-09-11 16:37:09','',''),(5418,'1','274','1',1,'Retail Sale Id 5279',1502.88,0.00,0.00,2.02,159.58,'2022-09-11 16:38:07','',''),(5419,'1','274','1',1,'Retail Sale Id 5280',3749.76,0.00,0.00,5.04,398.16,'2022-09-11 16:40:24','',''),(5420,'1','274','1',1,'Retail Sale Id 5281',2246.88,0.00,0.00,3.02,238.58,'2022-09-11 17:08:30','',''),(5421,'1','274','1',1,'Retail Sale Id 5282',4501.20,0.00,0.00,6.05,477.95,'2022-09-11 17:14:09','',''),(5422,'1','274','1',1,'Retail Sale Id 5283',4002.72,0.00,0.00,5.38,425.02,'2022-09-11 17:22:15','',''),(5423,'1','274','1',1,'Retail Sale Id 5284',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 17:27:10','',''),(5424,'1','274','1',1,'Retail Sale Id 5285',8496.48,0.00,0.00,11.42,902.18,'2022-09-11 17:37:39','',''),(5425,'1','274','1',1,'Retail Sale Id 5286',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 17:39:36','',''),(5426,'1','274','1',1,'Retail Sale Id 5287',9002.40,0.00,0.00,12.10,955.90,'2022-09-11 17:43:34','',''),(5427,'1','274','1',1,'Retail Sale Id 5288',2246.88,0.00,0.00,3.02,238.58,'2022-09-11 17:54:43','',''),(5428,'1','274','1',1,'Retail Sale Id 5289',2998.32,0.00,0.00,4.03,318.37,'2022-09-11 17:56:08','',''),(5429,'1','274','1',1,'Retail Sale Id 5290',9300.00,0.00,0.00,12.50,987.50,'2022-09-11 17:58:50','',''),(5430,'1','274','1',1,'Retail Sale Id 5291',4999.68,0.00,0.00,6.72,530.88,'2022-09-11 18:03:45','',''),(5431,'1','274','1',1,'Retail Sale Id 5293',4501.20,0.00,0.00,6.05,477.95,'2022-09-11 18:10:49','',''),(5432,'1','274','1',1,'Retail Sale Id 5294',2001.36,0.00,0.00,2.69,212.51,'2022-09-11 18:17:00','',''),(5433,'1','274','1',1,'Retail Sale Id 5295',2202.24,0.00,0.00,2.96,233.84,'2022-09-11 18:18:05','',''),(5434,'1','274','1',1,'Retail Sale Id 5296',4501.20,0.00,0.00,6.05,477.95,'2022-09-11 18:20:09','',''),(5435,'1','274','1',1,'Retail Sale Id 5297',77576.88,0.00,0.00,104.27,8237.33,'2022-09-11 19:19:49','',''),(5436,'1','274','1',1,'Retail Sale Id 5298',69400.32,0.00,0.00,93.28,7369.12,'2022-09-11 19:20:27','',''),(5437,'1','274','1',1,'Retail Sale Id 5299',14880.00,0.00,0.00,20.00,1580.00,'2022-09-12 07:11:19','',''),(5438,'1','274','1',1,'Retail Sale Id 5300',1502.88,0.00,0.00,2.02,159.58,'2022-09-12 08:13:34','',''),(5439,'1','274','1',1,'Retail Sale Id 5301',9300.00,0.00,0.00,12.50,987.50,'2022-09-12 08:21:57','',''),(5440,'1','274','1',1,'Retail Sale Id 5302',1502.88,0.00,0.00,2.02,159.58,'2022-09-12 08:23:42','',''),(5441,'1','274','1',1,'Retail Sale Id 5303',17498.88,0.00,0.00,23.52,1858.08,'2022-09-12 08:30:44','',''),(5442,'1','274','1',1,'Retail Sale Id 5304',996.96,0.00,0.00,1.34,105.86,'2022-09-12 09:16:13','',''),(5443,'1','274','1',1,'Retail Sale Id 5305',18600.00,0.00,0.00,25.00,1975.00,'2022-09-12 09:20:12','',''),(5444,'1','274','1',1,'Retail Sale Id 5306',51901.44,0.00,0.00,69.76,5511.04,'2022-09-12 09:24:16','',''),(5445,'1','274','1',1,'Retail Sale Id 5307',4501.20,0.00,0.00,6.05,477.95,'2022-09-12 09:26:20','',''),(5446,'1','274','1',1,'Retail Sale Id 5308',9300.00,0.00,0.00,12.50,987.50,'2022-09-12 09:28:48','',''),(5447,'1','274','1',1,'Retail Sale Id 5309',4999.68,0.00,0.00,6.72,530.88,'2022-09-12 09:34:18','',''),(5448,'1','274','1',1,'Retail Sale Id 5310',8198.88,0.00,0.00,11.02,870.58,'2022-09-12 09:40:40','',''),(5449,'1','274','1',1,'Retail Sale Id 5311',2001.36,0.00,0.00,2.69,212.51,'2022-09-12 09:52:08','',''),(5450,'1','274','1',1,'Retail Sale Id 5312',2001.36,0.00,0.00,2.69,212.51,'2022-09-12 10:02:12','',''),(5451,'1','274','1',1,'Retail Sale Id 5313',2998.32,0.00,0.00,4.03,318.37,'2022-09-12 10:07:23','',''),(5452,'1','274','1',1,'Retail Sale Id 5314',22320.00,0.00,0.00,30.00,2370.00,'2022-09-12 10:10:28','',''),(5453,'1','274','1',1,'Retail Sale Id 5315',2001.36,0.00,0.00,2.69,212.51,'2022-09-12 10:14:31','',''),(5454,'1','274','1',1,'Retail Sale Id 5316',4501.20,0.00,0.00,6.05,477.95,'2022-09-12 10:16:25','',''),(5455,'1','274','1',1,'Retail Sale Id 5317',7998.00,0.00,0.00,10.75,849.25,'2022-09-12 10:37:40','',''),(5456,'1','274','1',1,'Retail Sale Id 5318',2998.32,0.00,0.00,4.03,318.37,'2022-09-12 10:38:43','',''),(5457,'1','274','1',1,'Retail Sale Id 5320',3749.76,0.00,0.00,5.04,398.16,'2022-09-12 10:48:00','',''),(5458,'1','274','1',1,'Retail Sale Id 5322',46500.00,0.00,0.00,62.50,4937.50,'2022-09-12 11:06:53','',''),(5459,'1','274','1',1,'Retail Sale Id 5323',3720.00,0.00,0.00,5.00,395.00,'2022-09-12 11:24:47','',''),(5460,'1','274','1',1,'Retail Sale Id 5324',9300.00,0.00,0.00,12.50,987.50,'2022-09-12 11:27:00','',''),(5461,'1','274','1',1,'Retail Sale Id 5325',9300.00,0.00,0.00,12.50,987.50,'2022-09-12 11:30:22','',''),(5462,'1','274','1',1,'Retail Sale Id 5326',3749.76,0.00,0.00,5.04,398.16,'2022-09-12 11:36:04','',''),(5463,'1','274','1',1,'Retail Sale Id 5327',2998.32,0.00,0.00,4.03,318.37,'2022-09-12 11:45:48','',''),(5464,'1','274','1',1,'Retail Sale Id 5328',4002.72,0.00,0.00,5.38,425.02,'2022-09-12 12:05:18','',''),(5465,'1','274','1',1,'Retail Sale Id 5329',9300.00,0.00,0.00,12.50,987.50,'2022-09-12 12:26:56','',''),(5466,'1','274','1',1,'Retail Sale Id 5330',9002.40,0.00,0.00,12.10,955.90,'2022-09-12 12:28:33','',''),(5467,'1','274','1',1,'Retail Sale Id 5331',9701.76,0.00,0.00,13.04,1030.16,'2022-09-12 12:39:02','',''),(5468,'1','274','1',1,'Retail Sale Id 5332',18600.00,0.00,0.00,25.00,1975.00,'2022-09-12 12:44:36','',''),(5469,'1','274','1',1,'Retail Sale Id 5333',1502.88,0.00,0.00,2.02,159.58,'2022-09-12 12:48:58','',''),(5470,'1','274','1',1,'Retail Sale Id 5334',2998.32,0.00,0.00,4.03,318.37,'2022-09-12 13:11:10','',''),(5471,'1','274','1',1,'Retail Sale Id 5335',7499.52,0.00,0.00,10.08,796.32,'2022-09-12 13:12:02','',''),(5472,'1','274','1',1,'Retail Sale Id 5336',14798.16,0.00,0.00,19.89,1571.31,'2022-09-12 13:33:02','',''),(5473,'1','274','1',1,'Retail Sale Id 5337',9300.00,0.00,0.00,12.50,987.50,'2022-09-12 13:38:27','',''),(5474,'1','274','1',1,'Retail Sale Id 5338',2001.36,0.00,0.00,2.69,212.51,'2022-09-12 13:43:34','',''),(5475,'1','274','1',1,'Retail Sale Id 5339',7499.52,0.00,0.00,10.08,796.32,'2022-09-12 13:46:15','',''),(5476,'1','274','1',1,'Retail Sale Id 5340',3749.76,0.00,0.00,5.04,398.16,'2022-09-12 14:01:55','',''),(5477,'1','274','1',1,'Retail Sale Id 5341',2001.36,0.00,0.00,2.69,212.51,'2022-09-12 14:05:11','',''),(5478,'1','274','1',1,'Retail Sale Id 5342',2246.88,0.00,0.00,3.02,238.58,'2022-09-12 14:15:27','',''),(5479,'1','274','1',1,'Retail Sale Id 5343',3720.00,0.00,0.00,5.00,395.00,'2022-09-12 14:18:39','',''),(5480,'1','274','1',1,'Retail Sale Id 5344',9300.00,0.00,0.00,12.50,987.50,'2022-09-12 14:20:18','',''),(5481,'1','274','1',1,'Retail Sale Id 5345',3720.00,0.00,0.00,5.00,395.00,'2022-09-12 14:21:31','',''),(5482,'1','274','1',1,'Retail Sale Id 5346',1197.84,0.00,0.00,1.61,127.19,'2022-09-12 14:22:18','',''),(5483,'1','274','1',1,'Retail Sale Id 5347',9300.00,0.00,0.00,12.50,987.50,'2022-09-12 14:25:51','',''),(5484,'1','274','1',1,'Retail Sale Id 5348',9300.00,0.00,0.00,12.50,987.50,'2022-09-12 14:31:26','',''),(5485,'1','274','1',1,'Retail Sale Id 5349',2001.36,0.00,0.00,2.69,212.51,'2022-09-12 14:48:36','',''),(5486,'1','274','1',1,'Retail Sale Id 5350',4002.72,0.00,0.00,5.38,425.02,'2022-09-12 14:55:13','',''),(5487,'1','274','1',1,'Retail Sale Id 5351',9300.00,0.00,0.00,12.50,987.50,'2022-09-12 14:57:07','',''),(5488,'1','274','1',1,'Retail Sale Id 5352',4501.20,0.00,0.00,6.05,477.95,'2022-09-12 15:00:48','',''),(5489,'1','274','1',1,'Retail Sale Id 5353',996.96,0.00,0.00,1.34,105.86,'2022-09-12 15:15:56','',''),(5490,'1','274','1',1,'Retail Sale Id 5354',2232.00,0.00,0.00,3.00,237.00,'2022-09-12 15:30:07','',''),(5491,'1','274','1',1,'Retail Sale Id 5355',4501.20,0.00,0.00,6.05,477.95,'2022-09-12 15:34:03','',''),(5492,'1','274','1',1,'Retail Sale Id 5356',9300.00,0.00,0.00,12.50,987.50,'2022-09-12 15:48:17','',''),(5493,'1','274','1',1,'Retail Sale Id 5357',1502.88,0.00,0.00,2.02,159.58,'2022-09-12 15:50:34','',''),(5494,'1','274','1',1,'Retail Sale Id 5358',2998.32,0.00,0.00,4.03,318.37,'2022-09-12 15:51:40','',''),(5495,'1','274','1',1,'Retail Sale Id 5359',1502.88,0.00,0.00,2.02,159.58,'2022-09-12 15:52:40','',''),(5496,'1','274','1',1,'Retail Sale Id 5360',9300.00,0.00,0.00,12.50,987.50,'2022-09-12 15:59:11','',''),(5497,'1','274','1',1,'Retail Sale Id 5361',9300.00,0.00,0.00,12.50,987.50,'2022-09-12 16:08:49','',''),(5498,'1','274','1',1,'Retail Sale Id 5362',1502.88,0.00,0.00,2.02,159.58,'2022-09-12 16:12:13','',''),(5499,'1','274','1',1,'Retail Sale Id 5363',4501.20,0.00,0.00,6.05,477.95,'2022-09-12 16:13:16','',''),(5500,'1','274','1',1,'Retail Sale Id 5364',996.96,0.00,0.00,1.34,105.86,'2022-09-12 16:29:21','',''),(5501,'1','274','1',1,'Retail Sale Id 5365',2001.36,0.00,0.00,2.69,212.51,'2022-09-12 16:49:13','',''),(5502,'1','274','1',1,'Retail Sale Id 5366',1502.88,0.00,0.00,2.02,159.58,'2022-09-12 17:17:02','',''),(5503,'1','274','1',1,'Retail Sale Id 5367',2246.88,0.00,0.00,3.02,238.58,'2022-09-12 17:21:43','',''),(5504,'1','274','1',1,'Retail Sale Id 5368',2499.84,0.00,0.00,3.36,265.44,'2022-09-12 17:27:54','',''),(5505,'1','274','1',1,'Retail Sale Id 5369',2998.32,0.00,0.00,4.03,318.37,'2022-09-12 17:36:01','',''),(5506,'1','274','1',1,'Retail Sale Id 5370',27996.72,0.00,0.00,37.63,2972.77,'2022-09-12 17:44:04','',''),(5507,'1','274','1',1,'Retail Sale Id 5371',4501.20,0.00,0.00,6.05,477.95,'2022-09-12 17:54:35','',''),(5508,'1','274','1',1,'Retail Sale Id 5372',2998.32,0.00,0.00,4.03,318.37,'2022-09-12 17:55:12','',''),(5509,'1','274','1',1,'Retail Sale Id 5373',4501.20,0.00,0.00,6.05,477.95,'2022-09-12 18:03:31','',''),(5510,'1','274','1',1,'Retail Sale Id 5374',2797.44,0.00,0.00,3.76,297.04,'2022-09-12 18:15:54','',''),(5511,'1','274','1',1,'Retail Sale Id 5375',2001.36,0.00,0.00,2.69,212.51,'2022-09-12 18:28:49','',''),(5512,'1','274','1',1,'Retail Sale Id 5376',4501.20,0.00,0.00,6.05,477.95,'2022-09-12 18:33:09','',''),(5513,'1','274','1',1,'Retail Sale Id 5377',2246.88,0.00,0.00,3.02,238.58,'2022-09-12 18:37:00','',''),(5514,'1','274','1',1,'Retail Sale Id 5378',9300.00,0.00,0.00,12.50,987.50,'2022-09-12 18:38:03','',''),(5515,'1','274','1',1,'Retail Sale Id 5379',498.48,0.00,0.00,0.67,52.93,'2022-09-12 18:40:03','',''),(5516,'1','274','1',1,'Retail Sale Id 5380',41678.88,0.00,0.00,56.02,4425.58,'2022-09-12 19:20:52','',''),(5517,'1','274','1',1,'Retail Sale Id 5381',8890.80,0.00,0.00,11.95,944.05,'2022-09-12 19:22:46','',''),(5518,'1','274','1',1,'Retail Sale Id 5382',37200.00,0.00,0.00,50.00,3950.00,'2022-09-13 06:49:09','',''),(5519,'1','274','1',1,'Retail Sale Id 5383',9672.00,0.00,0.00,13.00,1027.00,'2022-09-13 08:09:43','',''),(5520,'1','274','1',1,'Retail Sale Id 5384',31441.44,0.00,0.00,42.26,3338.54,'2022-09-13 08:13:38','',''),(5521,'1','274','1',1,'Retail Sale Id 5385',9300.00,0.00,0.00,12.50,987.50,'2022-09-13 08:16:11','',''),(5522,'1','274','1',1,'Retail Sale Id 5386',4397.04,0.00,0.00,5.91,466.89,'2022-09-13 08:18:58','',''),(5523,'1','274','1',1,'Retail Sale Id 5387',3749.76,0.00,0.00,5.04,398.16,'2022-09-13 08:23:16','',''),(5524,'1','274','1',1,'Retail Sale Id 5388',4501.20,0.00,0.00,6.05,477.95,'2022-09-13 08:24:23','',''),(5525,'1','274','1',1,'Retail Sale Id 5389',17997.36,0.00,0.00,24.19,1911.01,'2022-09-13 08:25:41','',''),(5526,'1','274','1',1,'Retail Sale Id 5390',9300.00,0.00,0.00,12.50,987.50,'2022-09-13 08:30:41','',''),(5527,'1','274','1',1,'Retail Sale Id 5391',9300.00,0.00,0.00,12.50,987.50,'2022-09-13 08:31:57','',''),(5528,'1','274','1',1,'Retail Sale Id 5392',22320.00,0.00,0.00,30.00,2370.00,'2022-09-13 08:48:32','',''),(5529,'1','274','1',1,'Retail Sale Id 5393',9300.00,0.00,0.00,12.50,987.50,'2022-09-13 09:01:19','',''),(5530,'1','274','1',1,'Retail Sale Id 5394',2998.32,0.00,0.00,4.03,318.37,'2022-09-13 09:04:16','',''),(5531,'1','274','1',1,'Retail Sale Id 5395',3511.68,0.00,0.00,4.72,372.88,'2022-09-13 09:31:01','',''),(5532,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,12661.60,19.04,0.00,0.00,'2022-09-13 10:40:27','',''),(5533,'1','274',NULL,1,'Reception corrector for bridging 49',0.00,0.00,0.00,19.04,0.00,'2022-09-13 10:41:38','',''),(5534,'1','274','1',1,'Received from bridging 49',0.00,0.00,19.04,0.00,0.00,'2022-09-13 10:41:38','',''),(5535,'1','274','1',1,'Return of Retail Sale Id 5392',0.00,22320.00,30.00,0.00,-2370.00,'2022-09-13 10:43:03','',''),(5536,'1','274','1',1,'Retail Sale Id 5396',12097.44,0.00,0.00,16.26,1284.54,'2022-09-13 10:44:29','',''),(5537,'1','274','1',1,'Retail Sale Id 5397',24388.32,0.00,0.00,32.78,2589.62,'2022-09-13 10:45:05','',''),(5538,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,665000.00,1000.00,0.00,0.00,'2022-09-13 12:50:27','',''),(5539,'1','274',NULL,1,'Reception corrector for bridging 50',0.00,0.00,0.00,1000.00,0.00,'2022-09-13 12:51:23','',''),(5540,'1','274','1',1,'Received from bridging 50',0.00,0.00,1000.00,0.00,0.00,'2022-09-13 12:51:23','',''),(5541,'1','274','1',1,'Retail Sale Id 5398',9300.00,0.00,0.00,12.50,987.50,'2022-09-13 14:25:05','',''),(5542,'1','274','1',1,'Retail Sale Id 5399',9300.00,0.00,0.00,12.50,987.50,'2022-09-13 14:56:20','',''),(5543,'1','274','1',1,'Retail Sale Id 5400',996.96,0.00,0.00,1.34,105.86,'2022-09-13 15:11:43','',''),(5544,'1','274','1',1,'Retail Sale Id 5401',9300.00,0.00,0.00,12.50,987.50,'2022-09-13 15:14:36','',''),(5545,'1','274','1',1,'Retail Sale Id 5402',2001.36,0.00,0.00,2.69,212.51,'2022-09-13 15:22:47','',''),(5546,'1','274','1',1,'Retail Sale Id 5403',3749.76,0.00,0.00,5.04,398.16,'2022-09-13 15:35:23','',''),(5547,'1','274','1',1,'Retail Sale Id 5405',9300.00,0.00,0.00,12.50,987.50,'2022-09-13 16:31:15','',''),(5548,'1','274','1',1,'Retail Sale Id 5407',9300.00,0.00,0.00,12.50,987.50,'2022-09-13 16:33:19','',''),(5549,'1','274','1',1,'Retail Sale Id 5409',4501.20,0.00,0.00,6.05,477.95,'2022-09-13 16:37:55','',''),(5550,'1','274','1',1,'Retail Sale Id 5410',2001.36,0.00,0.00,2.69,212.51,'2022-09-13 16:51:09','',''),(5551,'1','274','1',1,'Retail Sale Id 5412',26999.76,0.00,0.00,36.29,2866.91,'2022-09-13 16:56:22','',''),(5552,'1','274','1',1,'Retail Sale Id 5414',9300.00,0.00,0.00,12.50,987.50,'2022-09-13 17:01:55','',''),(5553,'1','274','1',1,'Retail Sale Id 5414',18600.00,0.00,0.00,25.00,1975.00,'2022-09-13 17:01:55','',''),(5554,'1','274','1',1,'Retail Sale Id 5415',2001.36,0.00,0.00,2.69,212.51,'2022-09-13 17:10:23','',''),(5555,'1','274','1',1,'Retail Sale Id 5416',4501.20,0.00,0.00,6.05,477.95,'2022-09-13 17:12:32','',''),(5556,'1','274','1',1,'Retail Sale Id 5417',2001.36,0.00,0.00,2.69,212.51,'2022-09-13 17:13:57','',''),(5557,'1','274','1',1,'Retail Sale Id 5418',9300.00,0.00,0.00,12.50,987.50,'2022-09-13 17:14:45','',''),(5558,'1','274','1',1,'Retail Sale Id 5419',2998.32,0.00,0.00,4.03,318.37,'2022-09-13 17:22:36','',''),(5559,'1','274','1',1,'Retail Sale Id 5420',498.48,0.00,0.00,0.67,52.93,'2022-09-13 17:23:50','',''),(5560,'1','274','1',1,'Retail Sale Id 5421',4248.24,0.00,0.00,5.71,451.09,'2022-09-13 17:24:44','',''),(5561,'1','274','1',1,'Retail Sale Id 5422',14880.00,0.00,0.00,20.00,1580.00,'2022-09-13 17:30:25','',''),(5562,'1','274','1',1,'Retail Sale Id 5423',9300.00,0.00,0.00,12.50,987.50,'2022-09-13 17:34:16','',''),(5563,'1','274','1',1,'Retail Sale Id 5424',2998.32,0.00,0.00,4.03,318.37,'2022-09-13 17:36:29','',''),(5564,'1','274','1',1,'Retail Sale Id 5425',2246.88,0.00,0.00,3.02,238.58,'2022-09-13 17:40:14','',''),(5565,'1','274','1',1,'Retail Sale Id 5426',9002.40,0.00,0.00,12.10,955.90,'2022-09-13 17:51:21','',''),(5566,'1','274','1',1,'Retail Sale Id 5427',1502.88,0.00,0.00,2.02,159.58,'2022-09-13 17:52:23','',''),(5567,'1','274','1',1,'Retail Sale Id 5428',2001.36,0.00,0.00,2.69,212.51,'2022-09-13 17:53:49','',''),(5568,'1','274','1',1,'Retail Sale Id 5429',4999.68,0.00,0.00,6.72,530.88,'2022-09-13 17:55:01','',''),(5569,'1','274','1',1,'Retail Sale Id 5430',996.96,0.00,0.00,1.34,105.86,'2022-09-13 17:58:25','',''),(5570,'1','274','1',1,'Retail Sale Id 5431',2001.36,0.00,0.00,2.69,212.51,'2022-09-13 18:00:47','',''),(5571,'1','274','1',1,'Retail Sale Id 5432',2298.96,0.00,0.00,3.09,244.11,'2022-09-13 18:10:16','',''),(5572,'1','274','1',1,'Retail Sale Id 5433',9300.00,0.00,0.00,12.50,987.50,'2022-09-13 18:16:19','',''),(5573,'1','274','1',1,'Retail Sale Id 5434',22320.00,0.00,0.00,30.00,2370.00,'2022-09-13 18:22:32','',''),(5574,'1','274','1',1,'Retail Sale Id 5435',9999.36,0.00,0.00,13.44,1061.76,'2022-09-13 18:30:53','',''),(5575,'1','274','1',1,'Retail Sale Id 5436',37497.60,0.00,0.00,50.40,3981.60,'2022-09-13 18:32:03','',''),(5576,'1','274','1',1,'Return of Retail Sale Id 5436',0.00,37497.60,50.40,0.00,-3981.60,'2022-09-13 18:33:13','',''),(5577,'1','274','1',1,'Retail Sale Id 5437',4501.20,0.00,0.00,6.05,477.95,'2022-09-13 18:34:31','',''),(5578,'1','274','1',1,'Retail Sale Id 5438',9300.00,0.00,0.00,12.50,987.50,'2022-09-13 18:39:23','',''),(5579,'1','274','1',1,'Retail Sale Id 5439',3749.76,0.00,0.00,5.04,398.16,'2022-09-13 18:41:21','',''),(5580,'1','274','1',1,'Retail Sale Id 5440',9300.00,0.00,0.00,12.50,987.50,'2022-09-13 18:43:10','',''),(5581,'1','274','1',1,'Retail Sale Id 5441',9300.00,0.00,0.00,12.50,987.50,'2022-09-13 18:44:27','',''),(5582,'1','274','1',1,'Return of Retail Sale Id 5434',0.00,22320.00,30.00,0.00,-2370.00,'2022-09-13 19:47:40','',''),(5583,'1','274','1',1,'Retail Sale Id 5442',28658.88,0.00,0.00,38.52,3043.08,'2022-09-13 19:49:09','',''),(5584,'1','274','1',1,'Retail Sale Id 5443',3340.56,0.00,0.00,4.49,354.71,'2022-09-13 19:50:40','',''),(5585,'1','274','1',1,'Retail Sale Id 5444',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 06:53:02','',''),(5586,'1','274','1',1,'Retail Sale Id 5445',32951.76,0.00,0.00,44.29,3498.91,'2022-09-14 07:52:46','',''),(5587,'1','274','1',1,'Retail Sale Id 5446',2246.88,0.00,0.00,3.02,238.58,'2022-09-14 08:00:53','',''),(5588,'1','274','1',1,'Retail Sale Id 5447',4501.20,0.00,0.00,6.05,477.95,'2022-09-14 08:14:32','',''),(5589,'1','274','1',1,'Retail Sale Id 5448',1502.88,0.00,0.00,2.02,159.58,'2022-09-14 08:28:23','',''),(5590,'1','274','1',1,'Retail Sale Id 5449',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 08:36:07','',''),(5591,'1','274','1',1,'Retail Sale Id 5450',2001.36,0.00,0.00,2.69,212.51,'2022-09-14 08:44:14','',''),(5592,'1','274','1',1,'Retail Sale Id 5451',12000.72,0.00,0.00,16.13,1274.27,'2022-09-14 08:50:23','',''),(5593,'1','274','1',1,'Return of Retail Sale Id 5451',0.00,12000.72,16.13,0.00,-1274.27,'2022-09-14 08:53:19','',''),(5594,'1','274','1',1,'Retail Sale Id 5452',11301.36,0.00,0.00,15.19,1200.01,'2022-09-14 08:53:54','',''),(5595,'1','274','1',1,'Retail Sale Id 5453',4501.20,0.00,0.00,6.05,477.95,'2022-09-14 08:55:18','',''),(5596,'1','274','1',1,'Retail Sale Id 5454',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 09:02:49','',''),(5597,'1','274','1',1,'Retail Sale Id 5455',4002.72,0.00,0.00,5.38,425.02,'2022-09-14 09:03:49','',''),(5598,'1','274','1',1,'Retail Sale Id 5456',4501.20,0.00,0.00,6.05,477.95,'2022-09-14 09:04:45','',''),(5599,'1','274','1',1,'Retail Sale Id 5457',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 09:13:14','',''),(5600,'1','274','1',1,'Retail Sale Id 5458',7001.04,0.00,0.00,9.41,743.39,'2022-09-14 09:15:15','',''),(5601,'1','274','1',1,'Retail Sale Id 5459',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 09:19:08','',''),(5602,'1','274','1',1,'Retail Sale Id 5460',2998.32,0.00,0.00,4.03,318.37,'2022-09-14 09:36:52','',''),(5603,'1','274','1',1,'Retail Sale Id 5461',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 09:42:36','',''),(5604,'1','274','1',1,'Retail Sale Id 5462',2246.88,0.00,0.00,3.02,238.58,'2022-09-14 09:54:16','',''),(5605,'1','274','1',1,'Retail Sale Id 5463',12997.68,0.00,0.00,17.47,1380.13,'2022-09-14 09:55:21','',''),(5606,'1','274','1',1,'Retail Sale Id 5464',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 09:56:47','',''),(5607,'1','274','1',1,'Retail Sale Id 5465',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 10:04:33','',''),(5608,'1','274','1',1,'Retail Sale Id 5466',7797.12,0.00,0.00,10.48,827.92,'2022-09-14 10:10:59','',''),(5609,'1','274','1',1,'Retail Sale Id 5467',1502.88,0.00,0.00,2.02,159.58,'2022-09-14 10:17:22','',''),(5610,'1','274','1',1,'Retail Sale Id 5468',74400.00,0.00,0.00,100.00,7900.00,'2022-09-14 10:26:35','',''),(5611,'1','274','1',1,'Return of Retail Sale Id 5468',0.00,74400.00,100.00,0.00,-7900.00,'2022-09-14 10:27:53','',''),(5612,'1','274','1',1,'Retail Sale Id 5469',74400.00,0.00,0.00,100.00,7900.00,'2022-09-14 10:29:05','',''),(5613,'1','274','1',1,'Retail Sale Id 5470',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 10:30:37','',''),(5614,'1','274','1',1,'Retail Sale Id 5471',125364.00,0.00,0.00,168.50,13311.50,'2022-09-14 10:34:22','',''),(5615,'1','274','1',1,'Retail Sale Id 5472',2246.88,0.00,0.00,3.02,238.58,'2022-09-14 10:45:25','',''),(5616,'1','274','1',1,'Retail Sale Id 5473',4501.20,0.00,0.00,6.05,477.95,'2022-09-14 11:02:57','',''),(5617,'1','274','1',1,'Retail Sale Id 5474',2001.36,0.00,0.00,2.69,212.51,'2022-09-14 11:15:42','',''),(5618,'1','274','1',1,'Retail Sale Id 5475',996.96,0.00,0.00,1.34,105.86,'2022-09-14 11:23:20','',''),(5619,'1','274','1',1,'Retail Sale Id 5476',4999.68,0.00,0.00,6.72,530.88,'2022-09-14 11:28:04','',''),(5620,'1','274','1',1,'Retail Sale Id 5477',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 12:19:25','',''),(5621,'1','274','1',1,'Retail Sale Id 5478',1502.88,0.00,0.00,2.02,159.58,'2022-09-14 12:30:04','',''),(5622,'1','274','1',1,'Retail Sale Id 5479',14136.00,0.00,0.00,19.00,1501.00,'2022-09-14 12:34:03','',''),(5623,'1','274','1',1,'Retail Sale Id 5480',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 12:36:10','',''),(5624,'1','274','1',1,'Retail Sale Id 5481',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 12:42:35','',''),(5625,'1','274','1',1,'Retail Sale Id 5482',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 12:55:59','',''),(5626,'1','274','1',1,'Retail Sale Id 5483',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 12:57:33','',''),(5627,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,2533650.00,3810.00,0.00,0.00,'2022-09-14 13:28:17','',''),(5628,'1','274',NULL,1,'Reception corrector for bridging 51',0.00,0.00,0.00,3810.00,0.00,'2022-09-14 13:30:25','',''),(5629,'1','274','1',1,'Received from bridging 51',0.00,0.00,3810.00,0.00,0.00,'2022-09-14 13:30:25','',''),(5630,'1','274','1',1,'Retail Sale Id 5484',13801.20,0.00,0.00,18.55,1465.45,'2022-09-14 13:49:30','',''),(5631,'1','274','1',1,'Retail Sale Id 5485',2246.88,0.00,0.00,3.02,238.58,'2022-09-14 13:55:52','',''),(5632,'1','274','1',1,'Retail Sale Id 5486',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 14:19:09','',''),(5633,'1','274','1',1,'Retail Sale Id 5487',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 14:51:32','',''),(5634,'1','274','1',1,'Retail Sale Id 5488',4999.68,0.00,0.00,6.72,530.88,'2022-09-14 15:32:49','',''),(5635,'1','274','1',1,'Retail Sale Id 5489',2246.88,0.00,0.00,3.02,238.58,'2022-09-14 15:34:33','',''),(5636,'1','274','1',1,'Retail Sale Id 5490',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 16:31:52','',''),(5637,'1','274','1',1,'Retail Sale Id 5491',2998.32,0.00,0.00,4.03,318.37,'2022-09-14 16:38:25','',''),(5638,'1','274','1',1,'Retail Sale Id 5492',9300.00,0.00,0.00,12.50,987.50,'2022-09-14 16:52:12','',''),(5639,'1','274','1',1,'Retail Sale Id 5493',3749.76,0.00,0.00,5.04,398.16,'2022-09-14 17:02:26','',''),(5640,'1','274','1',1,'Retail Sale Id 5494',2001.36,0.00,0.00,2.69,212.51,'2022-09-14 17:08:27','',''),(5641,'1','274','1',1,'Retail Sale Id 5495',7001.04,0.00,0.00,9.41,743.39,'2022-09-14 17:12:53','',''),(5642,'1','274','1',1,'Retail Sale Id 5496',996.96,0.00,0.00,1.34,105.86,'2022-09-14 17:16:39','',''),(5643,'1','274','1',1,'Retail Sale Id 5497',2998.32,0.00,0.00,4.03,318.37,'2022-09-14 17:18:49','',''),(5644,'1','274','1',1,'Retail Sale Id 5498',2001.36,0.00,0.00,2.69,212.51,'2022-09-14 17:20:54','',''),(5645,'1','274','1',1,'Retail Sale Id 5499',1502.88,0.00,0.00,2.02,159.58,'2022-09-14 17:21:34','',''),(5646,'1','274','1',1,'Retail Sale Id 5500',996.96,0.00,0.00,1.34,105.86,'2022-09-14 17:24:28','',''),(5647,'1','274','1',1,'Retail Sale Id 5501',2998.32,0.00,0.00,4.03,318.37,'2022-09-14 17:26:30','',''),(5648,'1','274','1',1,'Retail Sale Id 5502',2001.36,0.00,0.00,2.69,212.51,'2022-09-14 17:32:13','',''),(5649,'1','274','1',1,'Retail Sale Id 5503',2001.36,0.00,0.00,2.69,212.51,'2022-09-14 17:33:31','',''),(5650,'1','274','1',1,'Retail Sale Id 5504',5996.64,0.00,0.00,8.06,636.74,'2022-09-14 17:47:49','',''),(5651,'1','274','1',1,'Retail Sale Id 5505',2499.84,0.00,0.00,3.36,265.44,'2022-09-14 17:52:22','',''),(5652,'1','274','1',1,'Retail Sale Id 5506',2001.36,0.00,0.00,2.69,212.51,'2022-09-14 17:56:25','',''),(5653,'1','274','1',1,'Retail Sale Id 5507',9672.00,0.00,0.00,13.00,1027.00,'2022-09-14 18:35:46','',''),(5654,'1','274','1',1,'Retail Sale Id 5508',4501.20,0.00,0.00,6.05,477.95,'2022-09-14 18:36:48','',''),(5655,'1','274','1',1,'Retail Sale Id 5509',103542.48,0.00,0.00,139.17,10994.43,'2022-09-14 19:23:47','',''),(5656,'1','274','1',1,'Return of Retail Sale Id 5463',0.00,12997.68,17.47,0.00,-1380.13,'2022-09-14 19:26:43','',''),(5657,'1','274','1',1,'Return of Retail Sale Id 5471',0.00,125364.00,168.50,0.00,-13311.50,'2022-09-14 19:30:06','',''),(5658,'1','274','1',1,'Retail Sale Id 5510',78685.44,0.00,0.00,105.76,8355.04,'2022-09-14 19:31:41','',''),(5659,'1','274','1',1,'Retail Sale Id 5511',14880.00,0.00,0.00,20.00,1580.00,'2022-09-15 06:49:12','',''),(5660,'1','274','1',1,'Retail Sale Id 5513',4002.72,0.00,0.00,5.38,425.02,'2022-09-15 07:59:40','',''),(5661,'1','274','1',1,'Retail Sale Id 5514',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 08:01:36','',''),(5662,'1','274','1',1,'Retail Sale Id 5515',23808.00,0.00,0.00,32.00,2528.00,'2022-09-15 08:03:15','',''),(5663,'1','274','1',1,'Retail Sale Id 5516',2998.32,0.00,0.00,4.03,318.37,'2022-09-15 08:05:00','',''),(5664,'1','274','1',1,'Retail Sale Id 5517',1502.88,0.00,0.00,2.02,159.58,'2022-09-15 08:09:59','',''),(5665,'1','274','1',1,'Retail Sale Id 5518',2246.88,0.00,0.00,3.02,238.58,'2022-09-15 08:13:01','',''),(5666,'1','274','1',1,'Retail Sale Id 5519',2001.36,0.00,0.00,2.69,212.51,'2022-09-15 08:20:25','',''),(5667,'1','274','1',1,'Retail Sale Id 5520',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 08:21:33','',''),(5668,'1','274','1',1,'Retail Sale Id 5521',2001.36,0.00,0.00,2.69,212.51,'2022-09-15 08:40:30','',''),(5669,'1','274','1',1,'Retail Sale Id 5522',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 08:42:45','',''),(5670,'1','274','1',1,'Retail Sale Id 5523',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 08:59:15','',''),(5671,'1','274','1',1,'Retail Sale Id 5524',5996.64,0.00,0.00,8.06,636.74,'2022-09-15 09:02:50','',''),(5672,'1','274','1',1,'Retail Sale Id 5525',1502.88,0.00,0.00,2.02,159.58,'2022-09-15 09:03:38','',''),(5673,'1','274','1',1,'Retail Sale Id 5526',1502.88,0.00,0.00,2.02,159.58,'2022-09-15 09:05:05','',''),(5674,'1','274','1',1,'Retail Sale Id 5527',1696.32,0.00,0.00,2.28,180.12,'2022-09-15 09:18:50','',''),(5675,'1','274','1',1,'Retail Sale Id 5528',14136.00,0.00,0.00,19.00,1501.00,'2022-09-15 09:28:03','',''),(5676,'1','274','1',1,'Retail Sale Id 5529',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 09:29:37','',''),(5677,'1','274','1',1,'Retail Sale Id 5530',4501.20,0.00,0.00,6.05,477.95,'2022-09-15 09:44:33','',''),(5678,'1','274','1',1,'Retail Sale Id 5531',17000.40,0.00,0.00,22.85,1805.15,'2022-09-15 09:52:36','',''),(5679,'1','274','1',1,'Retail Sale Id 5532',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 10:18:59','',''),(5680,'1','274','1',1,'Retail Sale Id 5533',5996.64,0.00,0.00,8.06,636.74,'2022-09-15 10:24:02','',''),(5681,'1','274','1',1,'Retail Sale Id 5534',7440.00,0.00,0.00,10.00,790.00,'2022-09-15 10:44:14','',''),(5682,'1','274','1',1,'Retail Sale Id 5535',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 10:53:01','',''),(5683,'1','274','1',1,'Retail Sale Id 5536',2232.00,0.00,0.00,3.00,237.00,'2022-09-15 11:07:53','',''),(5684,'1','274','1',1,'Retail Sale Id 5537',2001.36,0.00,0.00,2.69,212.51,'2022-09-15 11:16:55','',''),(5685,'1','274','1',1,'Retail Sale Id 5538',7998.00,0.00,0.00,10.75,849.25,'2022-09-15 11:23:58','',''),(5686,'1','274','1',1,'Retail Sale Id 5539',7998.00,0.00,0.00,10.75,849.25,'2022-09-15 11:24:49','',''),(5687,'1','274','1',1,'Retail Sale Id 5540',4501.20,0.00,0.00,6.05,477.95,'2022-09-15 11:56:09','',''),(5688,'1','274','1',1,'Retail Sale Id 5541',4999.68,0.00,0.00,6.72,530.88,'2022-09-15 12:03:48','',''),(5689,'1','274','1',1,'Retail Sale Id 5542',74400.00,0.00,0.00,100.00,7900.00,'2022-09-15 12:17:51','',''),(5690,'1','274','1',1,'Retail Sale Id 5542',74400.00,0.00,0.00,100.00,7900.00,'2022-09-15 12:17:51','',''),(5691,'1','274','1',1,'Retail Sale Id 5543',37200.00,0.00,0.00,50.00,3950.00,'2022-09-15 13:23:16','',''),(5692,'1','274','1',1,'Retail Sale Id 5544',2998.32,0.00,0.00,4.03,318.37,'2022-09-15 13:55:50','',''),(5693,'1','274','1',1,'Retail Sale Id 5545',2998.32,0.00,0.00,4.03,318.37,'2022-09-15 14:02:06','',''),(5694,'1','274','1',1,'Retail Sale Id 5546',11904.00,0.00,0.00,16.00,1264.00,'2022-09-15 14:04:46','',''),(5695,'1','274','1',1,'Retail Sale Id 5547',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 14:16:01','',''),(5696,'1','274','1',1,'Retail Sale Id 5547',18600.00,0.00,0.00,25.00,1975.00,'2022-09-15 14:16:01','',''),(5697,'1','274','1',1,'Retail Sale Id 5548',2246.88,0.00,0.00,3.02,238.58,'2022-09-15 14:17:51','',''),(5698,'1','274','1',1,'Retail Sale Id 5549',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 14:35:24','',''),(5699,'1','274','1',1,'Retail Sale Id 5550',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 14:59:04','',''),(5700,'1','274','1',1,'Retail Sale Id 5551',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 15:03:52','',''),(5701,'1','274','1',1,'Retail Sale Id 5552',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 15:06:54','',''),(5702,'1','274','1',1,'Retail Sale Id 5553',4501.20,0.00,0.00,6.05,477.95,'2022-09-15 15:15:36','',''),(5703,'1','274','1',1,'Retail Sale Id 5554',996.96,0.00,0.00,1.34,105.86,'2022-09-15 15:25:18','',''),(5704,'1','274','1',1,'Retail Sale Id 5555',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 15:26:14','',''),(5705,'1','274','1',1,'Retail Sale Id 5556',1502.88,0.00,0.00,2.02,159.58,'2022-09-15 15:28:38','',''),(5706,'1','274','1',1,'Retail Sale Id 5557',18600.00,0.00,0.00,25.00,1975.00,'2022-09-15 15:37:50','',''),(5707,'1','274','1',1,'Retail Sale Id 5558',22000.08,0.00,0.00,29.57,2336.03,'2022-09-15 16:02:16','',''),(5708,'1','274','1',1,'Retail Sale Id 5559',11301.36,0.00,0.00,15.19,1200.01,'2022-09-15 16:38:35','',''),(5709,'1','274','1',1,'Retail Sale Id 5560',4464.00,0.00,0.00,6.00,474.00,'2022-09-15 16:46:02','',''),(5710,'1','274','1',1,'Retail Sale Id 5560',22320.00,0.00,0.00,30.00,2370.00,'2022-09-15 16:46:02','',''),(5711,'1','274','1',1,'Retail Sale Id 5561',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 16:55:40','',''),(5712,'1','274','1',1,'Retail Sale Id 5562',2001.36,0.00,0.00,2.69,212.51,'2022-09-15 17:01:03','',''),(5713,'1','274','1',1,'Retail Sale Id 5563',1502.88,0.00,0.00,2.02,159.58,'2022-09-15 17:43:49','',''),(5714,'1','274','1',1,'Retail Sale Id 5564',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 17:44:38','',''),(5715,'1','274','1',1,'Retail Sale Id 5565',2246.88,0.00,0.00,3.02,238.58,'2022-09-15 17:45:42','',''),(5716,'1','274','1',1,'Retail Sale Id 5566',2246.88,0.00,0.00,3.02,238.58,'2022-09-15 17:46:58','',''),(5717,'1','274','1',1,'Retail Sale Id 5567',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 17:55:22','',''),(5718,'1','274','1',1,'Retail Sale Id 5568',2246.88,0.00,0.00,3.02,238.58,'2022-09-15 18:04:26','',''),(5719,'1','274','1',1,'Retail Sale Id 5569',18600.00,0.00,0.00,25.00,1975.00,'2022-09-15 18:08:50','',''),(5720,'1','274','1',1,'Retail Sale Id 5570',2246.88,0.00,0.00,3.02,238.58,'2022-09-15 18:09:59','',''),(5721,'1','274','1',1,'Retail Sale Id 5571',2246.88,0.00,0.00,3.02,238.58,'2022-09-15 18:16:23','',''),(5722,'1','274','1',1,'Retail Sale Id 5572',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 18:17:18','',''),(5723,'1','274','1',1,'Retail Sale Id 5574',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 18:22:13','',''),(5724,'1','274','1',1,'Retail Sale Id 5575',4002.72,0.00,0.00,5.38,425.02,'2022-09-15 18:25:03','',''),(5725,'1','274','1',1,'Retail Sale Id 5576',17997.36,0.00,0.00,24.19,1911.01,'2022-09-15 18:31:42','',''),(5726,'1','274','1',1,'Retail Sale Id 5577',4501.20,0.00,0.00,6.05,477.95,'2022-09-15 18:40:16','',''),(5727,'1','274','1',1,'Retail Sale Id 5578',9300.00,0.00,0.00,12.50,987.50,'2022-09-15 18:42:42','',''),(5728,'1','274','1',1,'Retail Sale Id 5579',118563.84,0.00,0.00,159.36,12589.44,'2022-09-15 19:07:35','',''),(5729,'1','274','1',1,'Return of Retail Sale Id 5543',0.00,37200.00,50.00,0.00,-3950.00,'2022-09-15 19:12:14','',''),(5730,'1','274','1',1,'Return of Retail Sale Id 5542',0.00,74400.00,100.00,0.00,-7900.00,'2022-09-15 19:13:12','',''),(5731,'1','274','1',1,'Return of Retail Sale Id 5542',0.00,74400.00,100.00,0.00,-7900.00,'2022-09-15 19:13:12','',''),(5732,'1','274','1',1,'Retail Sale Id 5580',74400.00,0.00,0.00,100.00,7900.00,'2022-09-15 19:14:33','',''),(5733,'1','274','1',1,'Return of Retail Sale Id 5576',0.00,17997.36,24.19,0.00,-1911.01,'2022-09-15 19:15:56','',''),(5734,'1','274','1',1,'Retail Sale Id 5581',13659.84,0.00,0.00,18.36,1450.44,'2022-09-15 19:17:43','',''),(5735,'1','274','1',1,'Retail Sale Id 5582',996.96,0.00,0.00,1.34,105.86,'2022-09-16 06:14:31','',''),(5736,'1','274','1',1,'Retail Sale Id 5583',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 09:29:14','',''),(5737,'1','274','1',1,'Retail Sale Id 5584',2001.36,0.00,0.00,2.69,212.51,'2022-09-16 09:33:18','',''),(5738,'1','274','1',1,'Retail Sale Id 5585',4501.20,0.00,0.00,6.05,477.95,'2022-09-16 09:47:56','',''),(5739,'1','274','1',1,'Retail Sale Id 5586',2499.84,0.00,0.00,3.36,265.44,'2022-09-16 10:30:39','',''),(5740,'1','274','1',1,'Retail Sale Id 5587',4002.72,0.00,0.00,5.38,425.02,'2022-09-16 10:42:13','',''),(5741,'1','274','1',1,'Retail Sale Id 5588',81698.64,0.00,0.00,109.81,8674.99,'2022-09-16 10:50:31','',''),(5742,'1','274','1',1,'Retail Sale Id 5589',49996.80,0.00,0.00,67.20,5308.80,'2022-09-16 10:51:10','',''),(5743,'1','274','1',1,'Retail Sale Id 5590',6703.44,0.00,0.00,9.01,711.79,'2022-09-16 10:51:56','',''),(5744,'1','274','1',1,'Retail Sale Id 5591',2298.96,0.00,0.00,3.09,244.11,'2022-09-16 10:53:45','',''),(5745,'1','274','1',1,'Retail Sale Id 5592',4501.20,0.00,0.00,6.05,477.95,'2022-09-16 10:54:57','',''),(5746,'1','274','1',1,'Retail Sale Id 5593',1502.88,0.00,0.00,2.02,159.58,'2022-09-16 11:14:18','',''),(5747,'1','274','1',1,'Retail Sale Id 5594',17550.96,0.00,0.00,23.59,1863.61,'2022-09-16 11:51:11','',''),(5748,'1','274','1',1,'Retail Sale Id 5595',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 11:52:47','',''),(5749,'1','274','1',1,'Retail Sale Id 5596',2998.32,0.00,0.00,4.03,318.37,'2022-09-16 11:54:54','',''),(5750,'1','274','1',1,'Retail Sale Id 5597',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 12:07:53','',''),(5751,'1','274','1',1,'Retail Sale Id 5598',13451.52,0.00,0.00,18.08,1428.32,'2022-09-16 12:44:04','',''),(5752,'1','274','1',1,'Retail Sale Id 5599',1502.88,0.00,0.00,2.02,159.58,'2022-09-16 12:45:29','',''),(5753,'1','274','1',1,'Retail Sale Id 5600',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 14:02:26','',''),(5754,'1','274','1',1,'Retail Sale Id 5601',2001.36,0.00,0.00,2.69,212.51,'2022-09-16 14:06:28','',''),(5755,'1','274','1',1,'Retail Sale Id 5602',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 14:09:40','',''),(5756,'1','274','1',1,'Retail Sale Id 5603',3749.76,0.00,0.00,5.04,398.16,'2022-09-16 14:20:56','',''),(5757,'1','274','1',1,'Retail Sale Id 5604',4501.20,0.00,0.00,6.05,477.95,'2022-09-16 14:24:07','',''),(5758,'1','274','1',1,'Retail Sale Id 5605',4999.68,0.00,0.00,6.72,530.88,'2022-09-16 14:31:19','',''),(5759,'1','274','1',1,'Retail Sale Id 5608',4501.20,0.00,0.00,6.05,477.95,'2022-09-16 14:38:48','',''),(5760,'1','274','1',1,'Retail Sale Id 5609',33502.32,0.00,0.00,45.03,3557.37,'2022-09-16 14:51:52','',''),(5761,'1','274','1',1,'Retail Sale Id 5610',996.96,0.00,0.00,1.34,105.86,'2022-09-16 14:55:34','',''),(5762,'1','274','1',1,'Retail Sale Id 5611',37200.00,0.00,0.00,50.00,3950.00,'2022-09-16 14:57:56','',''),(5763,'1','274','1',1,'Retail Sale Id 5612',37200.00,0.00,0.00,50.00,3950.00,'2022-09-16 15:25:27','',''),(5764,'1','274','1',1,'Retail Sale Id 5613',32698.80,0.00,0.00,43.95,3472.05,'2022-09-16 16:32:32','',''),(5765,'1','274','1',1,'Retail Sale Id 5614',1502.88,0.00,0.00,2.02,159.58,'2022-09-16 16:41:01','',''),(5766,'1','274','1',1,'Retail Sale Id 5615',4501.20,0.00,0.00,6.05,477.95,'2022-09-16 16:56:03','',''),(5767,'1','274','1',1,'Retail Sale Id 5616',6748.08,0.00,0.00,9.07,716.53,'2022-09-16 17:13:23','',''),(5768,'1','274','1',1,'Retail Sale Id 5617',5751.12,0.00,0.00,7.73,610.67,'2022-09-16 17:14:58','',''),(5769,'1','274','1',1,'Retail Sale Id 5618',2001.36,0.00,0.00,2.69,212.51,'2022-09-16 17:19:39','',''),(5770,'1','274','1',1,'Retail Sale Id 5619',9002.40,0.00,0.00,12.10,955.90,'2022-09-16 17:21:56','',''),(5771,'1','274','1',1,'Retail Sale Id 5620',996.96,0.00,0.00,1.34,105.86,'2022-09-16 17:33:18','',''),(5772,'1','274','1',1,'Retail Sale Id 5621',4002.72,0.00,0.00,5.38,425.02,'2022-09-16 17:38:40','',''),(5773,'1','274','1',1,'Retail Sale Id 5622',2246.88,0.00,0.00,3.02,238.58,'2022-09-16 17:42:35','',''),(5774,'1','274','1',1,'Retail Sale Id 5623',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 17:50:34','',''),(5775,'1','274','1',1,'Retail Sale Id 5624',3749.76,0.00,0.00,5.04,398.16,'2022-09-16 18:28:18','',''),(5776,'1','274','1',1,'Retail Sale Id 5626',9300.00,0.00,0.00,12.50,987.50,'2022-09-16 18:29:34','',''),(5777,'1','274','1',1,'Retail Sale Id 5628',22349.76,0.00,0.00,30.04,2373.16,'2022-09-16 18:31:08','',''),(5778,'1','274','1',1,'Return of Retail Sale Id 5626',0.00,9300.00,12.50,0.00,-987.50,'2022-09-16 19:16:13','',''),(5779,'1','274','1',1,'Retail Sale Id 5629',1651.68,0.00,0.00,2.22,175.38,'2022-09-16 19:16:56','',''),(5780,'1','274','1',1,'Retail Sale Id 5630',40369.44,0.00,0.00,54.26,4286.54,'2022-09-16 19:18:09','',''),(5781,'1','274','1',1,'Retail Sale Id 5631',2001.92,0.00,0.00,2.72,193.12,'2022-09-17 06:57:38','',''),(5782,'1','274','1',1,'Retail Sale Id 5632',9597.44,0.00,0.00,13.04,925.84,'2022-09-17 08:18:58','',''),(5783,'1','274','1',1,'Retail Sale Id 5633',9001.28,0.00,0.00,12.23,868.33,'2022-09-17 08:20:08','',''),(5784,'1','274','1',1,'Retail Sale Id 5634',6999.36,0.00,0.00,9.51,675.21,'2022-09-17 08:21:09','',''),(5785,'1','274','1',1,'Retail Sale Id 5635',1000.96,0.00,0.00,1.36,96.56,'2022-09-17 10:19:26','',''),(5786,'1','274','1',1,'Retail Sale Id 5636',2252.16,0.00,0.00,3.06,217.26,'2022-09-17 10:20:15','',''),(5787,'1','274','1',1,'Retail Sale Id 5638',4452.80,0.00,0.00,6.05,429.55,'2022-09-17 10:29:53','',''),(5788,'1','274','1',1,'Retail Sale Id 5639',2001.92,0.00,0.00,2.72,193.12,'2022-09-17 10:42:16','',''),(5789,'1','274','1',1,'Retail Sale Id 5640',2502.40,0.00,0.00,3.40,241.40,'2022-09-17 10:43:45','',''),(5790,'1','274','1',1,'Retail Sale Id 5641',4496.96,0.00,0.00,6.11,433.81,'2022-09-17 10:54:33','',''),(5791,'1','274','1',1,'Retail Sale Id 5642',48782.08,0.00,0.00,66.28,4705.88,'2022-09-17 11:16:15','',''),(5792,'1','274','1',1,'Retail Sale Id 5643',2001.92,0.00,0.00,2.72,193.12,'2022-09-17 11:16:55','',''),(5793,'1','274','1',1,'Retail Sale Id 5644',112269.44,0.00,0.00,152.54,10830.34,'2022-09-17 11:17:49','',''),(5794,'1','274','1',1,'Retail Sale Id 5645',1501.44,0.00,0.00,2.04,144.84,'2022-09-17 11:18:22','',''),(5795,'1','274','1',1,'Retail Sale Id 5646',3002.88,0.00,0.00,4.08,289.68,'2022-09-17 11:21:48','',''),(5796,'1','274','1',1,'Retail Sale Id 5647',2001.92,0.00,0.00,2.72,193.12,'2022-09-17 11:25:01','',''),(5797,'1','274','1',1,'Retail Sale Id 5648',750.72,0.00,0.00,1.02,72.42,'2022-09-17 11:26:02','',''),(5798,'1','274','1',1,'Retail Sale Id 5649',4452.80,0.00,0.00,6.05,429.55,'2022-09-17 11:30:49','',''),(5799,'1','274','1',1,'Retail Sale Id 5650',9200.00,0.00,0.00,12.50,887.50,'2022-09-17 11:33:20','',''),(5800,'1','274','1',1,'Retail Sale Id 5651',3002.88,0.00,0.00,4.08,289.68,'2022-09-17 11:41:02','',''),(5801,'1','274','1',1,'Retail Sale Id 5653',14749.44,0.00,0.00,20.04,1422.84,'2022-09-17 11:43:51','',''),(5802,'1','274','1',1,'Retail Sale Id 5654',3996.48,0.00,0.00,5.43,385.53,'2022-09-17 11:46:22','',''),(5803,'1','274','1',1,'Retail Sale Id 5655',9200.00,0.00,0.00,12.50,887.50,'2022-09-17 11:52:26','',''),(5804,'1','274','1',1,'Retail Sale Id 5656',4452.80,0.00,0.00,6.05,429.55,'2022-09-17 12:02:44','',''),(5805,'1','274','1',1,'Retail Sale Id 5657',9200.00,0.00,0.00,12.50,887.50,'2022-09-17 12:05:17','',''),(5806,'1','274','1',1,'Retail Sale Id 5659',3002.88,0.00,0.00,4.08,289.68,'2022-09-17 12:26:24','',''),(5807,'1','274','1',1,'Retail Sale Id 5660',9200.00,0.00,0.00,12.50,887.50,'2022-09-17 12:35:28','',''),(5808,'1','274','1',1,'Retail Sale Id 5661',1501.44,0.00,0.00,2.04,144.84,'2022-09-17 12:37:35','',''),(5809,'1','274','1',1,'Retail Sale Id 5662',36800.00,0.00,0.00,50.00,3550.00,'2022-09-17 13:47:10','',''),(5810,'1','274','1',1,'Retail Sale Id 5663',9200.00,0.00,0.00,12.50,887.50,'2022-09-17 14:00:47','',''),(5811,'1','274','1',1,'Retail Sale Id 5664',4452.80,0.00,0.00,6.05,429.55,'2022-09-17 14:06:52','',''),(5812,'1','274','1',1,'Retail Sale Id 5665',13196.48,0.00,0.00,17.93,1273.03,'2022-09-17 14:09:44','',''),(5813,'1','274','1',1,'Retail Sale Id 5666',2252.16,0.00,0.00,3.06,217.26,'2022-09-17 14:16:17','',''),(5814,'1','274','1',1,'Retail Sale Id 5667',9200.00,0.00,0.00,12.50,887.50,'2022-09-17 14:33:24','',''),(5815,'1','274','1',1,'Retail Sale Id 5668',3002.88,0.00,0.00,4.08,289.68,'2022-09-17 15:08:34','',''),(5816,'1','274','1',1,'Retail Sale Id 5669',13652.80,0.00,0.00,18.55,1317.05,'2022-09-17 15:23:13','',''),(5817,'1','274','1',1,'Retail Sale Id 5670',17001.60,0.00,0.00,23.10,1640.10,'2022-09-17 15:32:41','',''),(5818,'1','274','1',1,'Retail Sale Id 5671',3996.48,0.00,0.00,5.43,385.53,'2022-09-17 16:01:36','',''),(5819,'1','274','1',1,'Retail Sale Id 5672',7396.80,0.00,0.00,10.05,713.55,'2022-09-17 16:06:59','',''),(5820,'1','274','1',1,'Retail Sale Id 5673',4452.80,0.00,0.00,6.05,429.55,'2022-09-17 16:24:01','',''),(5821,'1','274','1',1,'Retail Sale Id 5674',9200.00,0.00,0.00,12.50,887.50,'2022-09-17 16:25:28','',''),(5822,'1','274','1',1,'Retail Sale Id 5675',6999.36,0.00,0.00,9.51,675.21,'2022-09-17 16:28:49','',''),(5823,'1','274','1',1,'Retail Sale Id 5676',3702.08,0.00,0.00,5.03,357.13,'2022-09-17 16:29:37','',''),(5824,'1','274','1',1,'Retail Sale Id 5677',2252.16,0.00,0.00,3.06,217.26,'2022-09-17 16:32:54','',''),(5825,'1','274','1',1,'Retail Sale Id 5678',9001.28,0.00,0.00,12.23,868.33,'2022-09-17 16:34:37','',''),(5826,'1','274','1',1,'Retail Sale Id 5679',119600.00,0.00,0.00,162.50,11537.50,'2022-09-17 16:38:20','',''),(5827,'1','274','1',1,'Retail Sale Id 5680',1000.96,0.00,0.00,1.36,96.56,'2022-09-17 16:44:30','',''),(5828,'1','274','1',1,'Retail Sale Id 5681',6697.60,0.00,0.00,9.10,646.10,'2022-09-17 16:52:53','',''),(5829,'1','274','1',1,'Retail Sale Id 5682',4997.44,0.00,0.00,6.79,482.09,'2022-09-17 16:54:49','',''),(5830,'1','274','1',1,'Retail Sale Id 5683',22102.08,0.00,0.00,30.03,2132.13,'2022-09-17 17:01:05','',''),(5831,'1','274','1',1,'Retail Sale Id 5684',2001.92,0.00,0.00,2.72,193.12,'2022-09-17 17:22:24','',''),(5832,'1','274','1',1,'Retail Sale Id 5685',2252.16,0.00,0.00,3.06,217.26,'2022-09-17 17:24:43','',''),(5833,'1','274','1',1,'Retail Sale Id 5686',1000.96,0.00,0.00,1.36,96.56,'2022-09-17 17:33:12','',''),(5834,'1','274','1',1,'Retail Sale Id 5687',9200.00,0.00,0.00,12.50,887.50,'2022-09-17 17:41:09','',''),(5835,'1','274','1',1,'Return of Retail Sale Id 5683',0.00,22102.08,30.03,0.00,-2132.13,'2022-09-17 17:54:07','',''),(5836,'1','274','1',1,'Retail Sale Id 5688',74983.68,0.00,0.00,101.88,7233.48,'2022-09-17 17:57:56','',''),(5837,'1','274','1',1,'Retail Sale Id 5689',9200.00,0.00,0.00,12.50,887.50,'2022-09-17 18:03:44','',''),(5838,'1','274','1',1,'Retail Sale Id 5690',1501.44,0.00,0.00,2.04,144.84,'2022-09-17 18:04:59','',''),(5839,'1','274','1',1,'Retail Sale Id 5691',36800.00,0.00,0.00,50.00,3550.00,'2022-09-17 18:14:21','',''),(5840,'1','274','1',1,'Retail Sale Id 5692',2001.92,0.00,0.00,2.72,193.12,'2022-09-17 18:15:35','',''),(5841,'1','274','1',1,'Retail Sale Id 5693',2502.40,0.00,0.00,3.40,241.40,'2022-09-17 18:25:16','',''),(5842,'1','274','1',1,'Retail Sale Id 5694',4496.96,0.00,0.00,6.11,433.81,'2022-09-17 18:28:09','',''),(5843,'1','274','1',1,'Retail Sale Id 5695',802.24,0.00,0.00,1.09,77.39,'2022-09-17 18:30:50','',''),(5844,'1','274','1',1,'Retail Sale Id 5697',2097.60,0.00,0.00,2.85,202.35,'2022-09-17 18:34:01','',''),(5845,'1','274','1',1,'Retail Sale Id 5698',36800.00,0.00,0.00,50.00,3550.00,'2022-09-17 18:38:22','',''),(5846,'1','274','1',1,'Retail Sale Id 5699',9200.00,0.00,0.00,12.50,887.50,'2022-09-17 18:40:31','',''),(5847,'1','274','1',1,'Retail Sale Id 5700',2001.92,0.00,0.00,2.72,193.12,'2022-09-17 18:42:50','',''),(5848,'1','274','1',1,'Retail Sale Id 5702',2502.40,0.00,0.00,3.40,241.40,'2022-09-17 18:48:59','',''),(5849,'1','274','1',1,'Return of Retail Sale Id 5691',0.00,36800.00,50.00,0.00,-3550.00,'2022-09-17 19:54:31','',''),(5850,'1','274','1',1,'Retail Sale Id 5703',26908.16,0.00,0.00,36.56,2595.76,'2022-09-17 19:55:52','',''),(5851,'1','274','1',1,'Retail Sale Id 5704',3150.08,0.00,0.00,4.28,303.88,'2022-09-17 19:57:39','',''),(5852,'1','274','1',1,'Retail Sale Id 5705',9200.00,0.00,0.00,12.50,887.50,'2022-09-18 06:51:27','',''),(5853,'1','274','1',1,'Retail Sale Id 5706',2252.16,0.00,0.00,3.06,217.26,'2022-09-18 10:58:12','',''),(5854,'1','274','1',1,'Retail Sale Id 5707',4452.80,0.00,0.00,6.05,429.55,'2022-09-18 11:03:16','',''),(5855,'1','274','1',1,'Retail Sale Id 5708',98498.88,0.00,0.00,133.83,9501.93,'2022-09-18 11:09:43','',''),(5856,'1','274','1',1,'Retail Sale Id 5709',2001.92,0.00,0.00,2.72,193.12,'2022-09-18 11:13:08','',''),(5857,'1','274','1',1,'Retail Sale Id 5710',2252.16,0.00,0.00,3.06,217.26,'2022-09-18 11:14:43','',''),(5858,'1','274','1',1,'Retail Sale Id 5711',12953.60,0.00,0.00,17.60,1249.60,'2022-09-18 11:19:19','',''),(5859,'1','274','1',1,'Retail Sale Id 5712',18400.00,0.00,0.00,25.00,1775.00,'2022-09-18 11:39:42','',''),(5860,'1','274','1',1,'Retail Sale Id 5713',9001.28,0.00,0.00,12.23,868.33,'2022-09-18 11:42:52','',''),(5861,'1','274','1',1,'Retail Sale Id 5714',4452.80,0.00,0.00,6.05,429.55,'2022-09-18 11:47:00','',''),(5862,'1','274','1',1,'Retail Sale Id 5715',3702.08,0.00,0.00,5.03,357.13,'2022-09-18 11:49:31','',''),(5863,'1','274','1',1,'Retail Sale Id 5716',1000.96,0.00,0.00,1.36,96.56,'2022-09-18 11:50:44','',''),(5864,'1','274','1',1,'Retail Sale Id 5717',9200.00,0.00,0.00,12.50,887.50,'2022-09-18 11:52:36','',''),(5865,'1','274','1',1,'Retail Sale Id 5718',14197.44,0.00,0.00,19.29,1369.59,'2022-09-18 11:54:17','',''),(5866,'1','274','1',1,'Retail Sale Id 5719',3002.88,0.00,0.00,4.08,289.68,'2022-09-18 12:37:59','',''),(5867,'1','274','1',1,'Retail Sale Id 5720',2252.16,0.00,0.00,3.06,217.26,'2022-09-18 12:42:52','',''),(5868,'1','274','1',1,'Retail Sale Id 5721',699.20,0.00,0.00,0.95,67.45,'2022-09-18 12:45:39','',''),(5869,'1','274','1',1,'Retail Sale Id 5722',3002.88,0.00,0.00,4.08,289.68,'2022-09-18 12:56:12','',''),(5870,'1','274','1',1,'Retail Sale Id 5723',3996.48,0.00,0.00,5.43,385.53,'2022-09-18 12:58:38','',''),(5871,'1','274','1',1,'Retail Sale Id 5724',2502.40,0.00,0.00,3.40,241.40,'2022-09-18 13:04:01','',''),(5872,'1','274','1',1,'Retail Sale Id 5725',13998.72,0.00,0.00,19.02,1350.42,'2022-09-18 13:04:35','',''),(5873,'1','274','1',1,'Retail Sale Id 5726',15897.60,0.00,0.00,21.60,1533.60,'2022-09-18 13:22:23','',''),(5874,'1','274','1',1,'Retail Sale Id 5727',2252.16,0.00,0.00,3.06,217.26,'2022-09-18 13:35:58','',''),(5875,'1','274','1',1,'Retail Sale Id 5728',9200.00,0.00,0.00,12.50,887.50,'2022-09-18 13:42:41','',''),(5876,'1','274','1',1,'Retail Sale Id 5729',3996.48,0.00,0.00,5.43,385.53,'2022-09-18 13:43:59','',''),(5877,'1','274','1',1,'Retail Sale Id 5730',2001.92,0.00,0.00,2.72,193.12,'2022-09-18 14:05:35','',''),(5878,'1','274','1',1,'Retail Sale Id 5731',2252.16,0.00,0.00,3.06,217.26,'2022-09-18 14:10:50','',''),(5879,'1','274','1',1,'Retail Sale Id 5732',9200.00,0.00,0.00,12.50,887.50,'2022-09-18 14:12:38','',''),(5880,'1','274','1',1,'Retail Sale Id 5733',13652.80,0.00,0.00,18.55,1317.05,'2022-09-18 14:14:10','',''),(5881,'1','274','1',1,'Retail Sale Id 5734',9200.00,0.00,0.00,12.50,887.50,'2022-09-18 14:16:08','',''),(5882,'1','274','1',1,'Retail Sale Id 5736',2252.16,0.00,0.00,3.06,217.26,'2022-09-18 15:11:04','',''),(5883,'1','274','1',1,'Retail Sale Id 5737',1000.96,0.00,0.00,1.36,96.56,'2022-09-18 15:19:58','',''),(5884,'1','274','1',1,'Retail Sale Id 5738',9001.28,0.00,0.00,12.23,868.33,'2022-09-18 15:25:27','',''),(5885,'1','274','1',1,'Retail Sale Id 5739',2001.92,0.00,0.00,2.72,193.12,'2022-09-18 15:26:05','',''),(5886,'1','274','1',1,'Retail Sale Id 5740',46000.00,0.00,0.00,62.50,4437.50,'2022-09-18 15:30:10','',''),(5887,'1','274','1',1,'Retail Sale Id 5741',1302.72,0.00,0.00,1.77,125.67,'2022-09-18 15:44:06','',''),(5888,'1','274','1',1,'Retail Sale Id 5742',2502.40,0.00,0.00,3.40,241.40,'2022-09-18 15:57:16','',''),(5889,'1','274','1',1,'Retail Sale Id 5744',14999.68,0.00,0.00,20.38,1446.98,'2022-09-18 16:11:07','',''),(5890,'1','274','1',1,'Retail Sale Id 5745',9200.00,0.00,0.00,12.50,887.50,'2022-09-18 16:12:19','',''),(5891,'1','274','1',1,'Retail Sale Id 5747',9200.00,0.00,0.00,12.50,887.50,'2022-09-18 16:30:30','',''),(5892,'1','274','1',1,'Retail Sale Id 5748',1000.96,0.00,0.00,1.36,96.56,'2022-09-18 16:31:38','',''),(5893,'1','274','1',1,'Retail Sale Id 5749',3996.48,0.00,0.00,5.43,385.53,'2022-09-18 16:32:57','',''),(5894,'1','274','1',1,'Retail Sale Id 5750',2001.92,0.00,0.00,2.72,193.12,'2022-09-18 16:40:58','',''),(5895,'1','274','1',1,'Retail Sale Id 5751',9200.00,0.00,0.00,12.50,887.50,'2022-09-18 17:27:44','',''),(5896,'1','274','1',1,'Retail Sale Id 5752',13652.80,0.00,0.00,18.55,1317.05,'2022-09-18 17:31:42','',''),(5897,'1','274','1',1,'Retail Sale Id 5753',3702.08,0.00,0.00,5.03,357.13,'2022-09-18 17:36:17','',''),(5898,'1','274','1',1,'Retail Sale Id 5754',2252.16,0.00,0.00,3.06,217.26,'2022-09-18 17:41:50','',''),(5899,'1','274','1',1,'Retail Sale Id 5755',4452.80,0.00,0.00,6.05,429.55,'2022-09-18 17:47:18','',''),(5900,'1','274','1',1,'Retail Sale Id 5756',2303.68,0.00,0.00,3.13,222.23,'2022-09-18 17:48:59','',''),(5901,'1','274','1',1,'Retail Sale Id 5757',6999.36,0.00,0.00,9.51,675.21,'2022-09-18 17:50:19','',''),(5902,'1','274','1',1,'Retail Sale Id 5758',2252.16,0.00,0.00,3.06,217.26,'2022-09-18 17:51:10','',''),(5903,'1','274','1',1,'Retail Sale Id 5759',13652.80,0.00,0.00,18.55,1317.05,'2022-09-18 17:58:17','',''),(5904,'1','274','1',1,'Retail Sale Id 5760',3996.48,0.00,0.00,5.43,385.53,'2022-09-18 17:59:43','',''),(5905,'1','274','1',1,'Retail Sale Id 5761',2303.68,0.00,0.00,3.13,222.23,'2022-09-18 18:07:20','',''),(5906,'1','274','1',1,'Retail Sale Id 5762',2252.16,0.00,0.00,3.06,217.26,'2022-09-18 18:10:36','',''),(5907,'1','274','1',1,'Retail Sale Id 5763',3702.08,0.00,0.00,5.03,357.13,'2022-09-18 18:24:35','',''),(5908,'1','274','1',1,'Retail Sale Id 5764',4452.80,0.00,0.00,6.05,429.55,'2022-09-18 18:26:03','',''),(5909,'1','274','1',1,'Retail Sale Id 5765',6300.16,0.00,0.00,8.56,607.76,'2022-09-18 19:17:58','',''),(5910,'1','274','1',1,'Retail Sale Id 5766',33002.24,0.00,0.00,44.84,3183.64,'2022-09-18 19:18:37','',''),(5911,'1','274','1',1,'Retail Sale Id 5767',9200.00,0.00,0.00,12.50,887.50,'2022-09-19 08:13:14','',''),(5912,'1','274','1',1,'Retail Sale Id 5768',4452.80,0.00,0.00,6.05,429.55,'2022-09-19 08:13:53','',''),(5913,'1','274','1',1,'Retail Sale Id 5769',18400.00,0.00,0.00,25.00,1775.00,'2022-09-19 08:14:23','',''),(5914,'1','274','1',1,'Retail Sale Id 5770',1501.44,0.00,0.00,2.04,144.84,'2022-09-19 08:22:55','',''),(5915,'1','274','1',1,'Retail Sale Id 5771',36800.00,0.00,0.00,50.00,3550.00,'2022-09-19 09:10:02','',''),(5916,'1','274','1',1,'Retail Sale Id 5772',18400.00,0.00,0.00,25.00,1775.00,'2022-09-19 09:11:41','',''),(5917,'1','274','1',1,'Retail Sale Id 5773',9200.00,0.00,0.00,12.50,887.50,'2022-09-19 09:12:59','',''),(5918,'1','274','1',1,'Retail Sale Id 5775',6646.08,0.00,0.00,9.03,641.13,'2022-09-19 09:18:03','',''),(5919,'1','274','1',1,'Retail Sale Id 5776',7396.80,0.00,0.00,10.05,713.55,'2022-09-19 09:28:27','',''),(5920,'1','274','1',1,'Retail Sale Id 5777',1000.96,0.00,0.00,1.36,96.56,'2022-09-19 09:34:41','',''),(5921,'1','274','1',1,'Retail Sale Id 5778',21447.04,0.00,0.00,29.14,2068.94,'2022-09-19 09:41:19','',''),(5922,'1','274','1',1,'Retail Sale Id 5780',9200.00,0.00,0.00,12.50,887.50,'2022-09-19 10:01:55','',''),(5923,'1','274','1',1,'Retail Sale Id 5781',9200.00,0.00,0.00,12.50,887.50,'2022-09-19 10:11:46','',''),(5924,'1','274','1',1,'Retail Sale Id 5782',3996.48,0.00,0.00,5.43,385.53,'2022-09-19 10:16:23','',''),(5925,'1','274','1',1,'Retail Sale Id 5783',897.92,0.00,0.00,1.22,86.62,'2022-09-19 10:17:55','',''),(5926,'1','274','1',1,'Retail Sale Id 5784',2502.40,0.00,0.00,3.40,241.40,'2022-09-19 10:23:23','',''),(5927,'1','274','1',1,'Retail Sale Id 5785',2001.92,0.00,0.00,2.72,193.12,'2022-09-19 10:42:13','',''),(5928,'1','274','1',1,'Retail Sale Id 5786',9200.00,0.00,0.00,12.50,887.50,'2022-09-19 11:02:16','',''),(5929,'1','274','1',1,'Retail Sale Id 5787',3253.12,0.00,0.00,4.42,313.82,'2022-09-19 11:03:58','',''),(5930,'1','274','1',1,'Return of Retail Sale Id 5786',0.00,9200.00,12.50,0.00,-887.50,'2022-09-19 12:56:56','',''),(5931,'1','274','1',1,'Return of Retail Sale Id 5778',0.00,21447.04,29.14,0.00,-2068.94,'2022-09-19 13:26:34','',''),(5932,'1','274','1',1,'Return of Retail Sale Id 5781',0.00,9200.00,12.50,0.00,-887.50,'2022-09-19 13:39:26','',''),(5933,'1','274','1',1,'Return of Retail Sale Id 5780',0.00,9200.00,12.50,0.00,-887.50,'2022-09-19 13:41:05','',''),(5934,'1','274','1',1,'Retail Sale Id 5788',31935.04,0.00,0.00,43.39,3080.69,'2022-09-19 13:41:59','',''),(5935,'1','274','1',1,'Return of Retail Sale Id 5788',0.00,31935.04,43.39,0.00,-3080.69,'2022-09-19 13:53:42','',''),(5936,'1','274','1',1,'Return of Retail Sale Id 5787',0.00,3253.12,4.42,0.00,-313.82,'2022-09-19 13:54:11','',''),(5937,'1','274','1',1,'Retail Sale Id 5789',22801.28,0.00,0.00,30.98,2199.58,'2022-09-19 13:59:08','',''),(5938,'1','274','1',1,'Retail Sale Id 5790',27482.24,0.00,0.00,37.34,2651.14,'2022-09-19 14:00:36','',''),(5939,'1','274','1',1,'Retail Sale Id 5791',1913.60,0.00,0.00,2.60,184.60,'2022-09-19 14:24:36','',''),(5940,'1','274','1',1,'Retail Sale Id 5792',88.32,0.00,0.00,0.12,8.52,'2022-09-19 14:25:30','',''),(5941,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,670000.00,1000.00,0.00,0.00,'2022-09-20 20:25:16','',''),(5942,'1','274',NULL,1,'Reception corrector for bridging 52',0.00,0.00,0.00,1000.00,0.00,'2022-09-20 20:26:51','',''),(5943,'1','274','1',1,'Received from bridging 52',0.00,0.00,1000.00,0.00,0.00,'2022-09-20 20:26:51','',''),(5944,'1','274','1',1,'Retail Sale Id 5793',18400.00,0.00,0.00,25.00,1650.00,'2022-09-21 08:33:00','',''),(5945,'1','274','1',1,'Retail Sale Id 5794',9200.00,0.00,0.00,12.50,825.00,'2022-09-21 08:37:03','',''),(5946,'1','274','1',1,'Retail Sale Id 5795',4452.80,0.00,0.00,6.05,399.30,'2022-09-21 08:37:48','',''),(5947,'1','274','1',1,'Retail Sale Id 5796',9200.00,0.00,0.00,12.50,825.00,'2022-09-21 08:38:39','',''),(5948,'1','274','1',1,'Retail Sale Id 5797',9200.00,0.00,0.00,12.50,825.00,'2022-09-21 08:39:29','',''),(5949,'1','274','1',1,'Retail Sale Id 5798',22102.08,0.00,0.00,30.03,1981.98,'2022-09-21 09:04:35','',''),(5950,'1','274','1',1,'Retail Sale Id 5799',15500.16,0.00,0.00,21.06,1389.96,'2022-09-21 09:06:19','',''),(5951,'1','274','1',1,'Retail Sale Id 5801',1000.96,0.00,0.00,1.36,89.76,'2022-09-21 09:53:31','',''),(5952,'1','274','1',1,'Retail Sale Id 5802',1501.44,0.00,0.00,2.04,134.64,'2022-09-21 09:55:17','',''),(5953,'1','274','1',1,'Retail Sale Id 5803',2001.92,0.00,0.00,2.72,179.52,'2022-09-21 10:20:41','',''),(5954,'1','274','1',1,'Retail Sale Id 5804',2502.40,0.00,0.00,3.40,224.40,'2022-09-21 10:34:53','',''),(5955,'1','274','1',1,'Retail Sale Id 5805',3702.08,0.00,0.00,5.03,331.98,'2022-09-21 11:03:11','',''),(5956,'1','274','1',1,'Retail Sale Id 5806',9200.00,0.00,0.00,12.50,825.00,'2022-09-21 11:04:23','',''),(5957,'1','274','1',1,'Retail Sale Id 5807',4997.44,0.00,0.00,6.79,448.14,'2022-09-21 11:05:24','',''),(5958,'1','274','1',1,'Retail Sale Id 5808',1501.44,0.00,0.00,2.04,134.64,'2022-09-21 11:10:10','',''),(5959,'1','274','1',1,'Retail Sale Id 5809',66247.36,0.00,0.00,90.01,5940.66,'2022-09-21 11:19:08','',''),(5960,'1','274','1',1,'Retail Sale Id 5810',4997.44,0.00,0.00,6.79,448.14,'2022-09-21 11:30:42','',''),(5961,'1','274','1',1,'Retail Sale Id 5811',9200.00,0.00,0.00,12.50,825.00,'2022-09-21 11:48:57','',''),(5962,'1','274','1',1,'Retail Sale Id 5813',3996.48,0.00,0.00,5.43,358.38,'2022-09-21 12:14:34','',''),(5963,'1','274','1',1,'Retail Sale Id 5814',1501.44,0.00,0.00,2.04,134.64,'2022-09-21 12:17:45','',''),(5964,'1','274','1',1,'Retail Sale Id 5815',6999.36,0.00,0.00,9.51,627.66,'2022-09-21 12:33:19','',''),(5965,'1','274','1',1,'Retail Sale Id 5816',8500.80,0.00,0.00,11.55,762.30,'2022-09-21 12:42:45','',''),(5966,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,2974800.00,4440.00,0.00,0.00,'2022-09-21 12:43:26','',''),(5967,'1','274','1',1,'Retail Sale Id 5817',4997.44,0.00,0.00,6.79,448.14,'2022-09-21 12:44:30','',''),(5968,'1','274',NULL,1,'Reception corrector for bridging 53',0.00,0.00,0.00,4440.00,0.00,'2022-09-21 12:45:16','',''),(5969,'1','274','1',1,'Received from bridging 53',0.00,0.00,4440.00,0.00,0.00,'2022-09-21 12:45:16','',''),(5970,'1','274','1',1,'Retail Sale Id 5818',9200.00,0.00,0.00,12.50,825.00,'2022-09-21 12:45:20','',''),(5971,'1','274','1',1,'Retail Sale Id 5819',2001.92,0.00,0.00,2.72,179.52,'2022-09-21 13:14:40','',''),(5972,'1','274','1',1,'Retail Sale Id 5820',3002.88,0.00,0.00,4.08,269.28,'2022-09-21 13:39:14','',''),(5973,'1','274','1',1,'Retail Sale Id 5821',36800.00,0.00,0.00,50.00,3300.00,'2022-09-21 13:40:14','',''),(5974,'1','274','1',1,'Retail Sale Id 5822',9200.00,0.00,0.00,12.50,825.00,'2022-09-21 13:42:13','',''),(5975,'1','274','1',1,'Retail Sale Id 5823',1302.72,0.00,0.00,1.77,116.82,'2022-09-21 14:26:15','',''),(5976,'1','274','1',1,'Retail Sale Id 5824',9200.00,0.00,0.00,12.50,825.00,'2022-09-21 14:29:16','',''),(5977,'1','274','1',1,'Retail Sale Id 5825',9200.00,0.00,0.00,12.50,825.00,'2022-09-21 14:46:47','',''),(5978,'1','274','1',1,'Retail Sale Id 5826',2252.16,0.00,0.00,3.06,201.96,'2022-09-21 15:47:58','',''),(5979,'1','274','1',1,'Retail Sale Id 5827',32052.80,0.00,0.00,43.55,2874.30,'2022-09-21 15:52:22','',''),(5980,'1','274','1',1,'Retail Sale Id 5828',9200.00,0.00,0.00,12.50,825.00,'2022-09-21 15:56:27','',''),(5981,'1','274','1',1,'Retail Sale Id 5829',3503.36,0.00,0.00,4.76,314.16,'2022-09-21 16:32:53','',''),(5982,'1','274','1',1,'Retail Sale Id 5830',16000.64,0.00,0.00,21.74,1434.84,'2022-09-21 16:36:06','',''),(5983,'1','274','1',1,'Retail Sale Id 5831',9200.00,0.00,0.00,12.50,825.00,'2022-09-21 16:42:01','',''),(5984,'1','274','1',1,'Retail Sale Id 5832',9200.00,0.00,0.00,12.50,825.00,'2022-09-21 16:49:33','',''),(5985,'1','274','1',1,'Retail Sale Id 5833',4901.76,0.00,0.00,6.66,439.56,'2022-09-21 17:06:34','',''),(5986,'1','274','1',1,'Retail Sale Id 5834',1302.72,0.00,0.00,1.77,116.82,'2022-09-21 17:07:19','',''),(5987,'1','274','1',1,'Retail Sale Id 5835',6999.36,0.00,0.00,9.51,627.66,'2022-09-21 17:21:32','',''),(5988,'1','274','1',1,'Retail Sale Id 5836',3996.48,0.00,0.00,5.43,358.38,'2022-09-21 17:22:33','',''),(5989,'1','274','1',1,'Retail Sale Id 5837',1000.96,0.00,0.00,1.36,89.76,'2022-09-21 17:28:20','',''),(5990,'1','274','1',1,'Retail Sale Id 5838',2001.92,0.00,0.00,2.72,179.52,'2022-09-21 17:30:11','',''),(5991,'1','274','1',1,'Retail Sale Id 5839',18400.00,0.00,0.00,25.00,1650.00,'2022-09-21 17:36:34','',''),(5992,'1','274','1',1,'Retail Sale Id 5840',4997.44,0.00,0.00,6.79,448.14,'2022-09-21 17:46:06','',''),(5993,'1','274','1',1,'Retail Sale Id 5841',1501.44,0.00,0.00,2.04,134.64,'2022-09-21 18:18:39','',''),(5994,'1','274','1',1,'Retail Sale Id 5842',2001.92,0.00,0.00,2.72,179.52,'2022-09-21 18:19:20','',''),(5995,'1','274','1',1,'Retail Sale Id 5843',2252.16,0.00,0.00,3.06,201.96,'2022-09-21 18:35:36','',''),(5996,'1','274','1',1,'Retail Sale Id 5844',82542.40,0.00,0.00,112.15,7401.90,'2022-09-21 19:32:43','',''),(5997,'1','274','1',1,'Retail Sale Id 5845',67859.20,0.00,0.00,92.20,6085.20,'2022-09-21 19:33:52','',''),(5998,'1','274','1',1,'Retail Sale Id 5846',9200.00,0.00,0.00,12.50,825.00,'2022-09-22 06:36:38','',''),(5999,'1','274','1',1,'Retail Sale Id 5847',6697.60,0.00,0.00,9.10,600.60,'2022-09-22 07:22:55','',''),(6000,'1','274','1',1,'Retail Sale Id 5848',17700.80,0.00,0.00,24.05,1587.30,'2022-09-22 08:04:57','',''),(6001,'1','274','1',1,'Retail Sale Id 5849',16192.00,0.00,0.00,22.00,1452.00,'2022-09-22 08:06:18','',''),(6002,'1','274','1',1,'Retail Sale Id 5850',8000.32,0.00,0.00,10.87,717.42,'2022-09-22 08:13:12','',''),(6003,'1','274','1',1,'Retail Sale Id 5851',9568.00,0.00,0.00,13.00,858.00,'2022-09-22 08:37:42','',''),(6004,'1','274','1',1,'Retail Sale Id 5852',9200.00,0.00,0.00,12.50,825.00,'2022-09-22 08:45:56','',''),(6005,'1','274','1',1,'Retail Sale Id 5853',9200.00,0.00,0.00,12.50,825.00,'2022-09-22 08:50:25','',''),(6006,'1','274','1',1,'Retail Sale Id 5854',9501.76,0.00,0.00,12.91,852.06,'2022-09-22 09:22:23','',''),(6007,'1','274','1',1,'Retail Sale Id 5855',9200.00,0.00,0.00,12.50,825.00,'2022-09-22 09:34:16','',''),(6008,'1','274','1',1,'Retail Sale Id 5856',4496.96,0.00,0.00,6.11,403.26,'2022-09-22 09:35:47','',''),(6009,'1','274','1',1,'Retail Sale Id 5857',13696.96,0.00,0.00,18.61,1228.26,'2022-09-22 09:38:56','',''),(6010,'1','274','1',1,'Retail Sale Id 5858',8000.32,0.00,0.00,10.87,717.42,'2022-09-22 09:44:50','',''),(6011,'1','274','1',1,'Retail Sale Id 5859',4496.96,0.00,0.00,6.11,403.26,'2022-09-22 09:45:54','',''),(6012,'1','274','1',1,'Retail Sale Id 5860',9200.00,0.00,0.00,12.50,825.00,'2022-09-22 09:52:11','',''),(6013,'1','274','1',1,'Retail Sale Id 5861',1803.20,0.00,0.00,2.45,161.70,'2022-09-22 09:57:39','',''),(6014,'1','274','1',1,'Retail Sale Id 5862',5998.40,0.00,0.00,8.15,537.90,'2022-09-22 10:03:29','',''),(6015,'1','274','1',1,'Retail Sale Id 5863',9200.00,0.00,0.00,12.50,825.00,'2022-09-22 10:09:28','',''),(6016,'1','274','1',1,'Retail Sale Id 5864',1000.96,0.00,0.00,1.36,89.76,'2022-09-22 10:28:36','',''),(6017,'1','274','1',1,'Retail Sale Id 5865',9200.00,0.00,0.00,12.50,825.00,'2022-09-22 10:29:51','',''),(6018,'1','274','1',1,'Retail Sale Id 5866',3680.00,0.00,0.00,5.00,330.00,'2022-09-22 10:33:17','',''),(6019,'1','274','1',1,'Retail Sale Id 5867',3702.08,0.00,0.00,5.03,331.98,'2022-09-22 10:40:49','',''),(6020,'1','274','1',1,'Retail Sale Id 5868',9200.00,0.00,0.00,12.50,825.00,'2022-09-22 10:45:16','',''),(6021,'1','274','1',1,'Retail Sale Id 5869',9200.00,0.00,0.00,12.50,825.00,'2022-09-22 10:46:42','',''),(6022,'1','274','1',1,'Retail Sale Id 5870',3002.88,0.00,0.00,4.08,269.28,'2022-09-22 10:50:15','',''),(6023,'1','274','1',1,'Retail Sale Id 5871',1501.44,0.00,0.00,2.04,134.64,'2022-09-22 10:55:26','',''),(6024,'1','274','1',1,'Retail Sale Id 5872',1501.44,0.00,0.00,2.04,134.64,'2022-09-22 10:58:02','',''),(6025,'1','274','1',1,'Retail Sale Id 5873',7360.00,0.00,0.00,10.00,660.00,'2022-09-22 11:07:53','',''),(6026,'1','274','1',1,'Retail Sale Id 5874',9200.00,0.00,0.00,12.50,825.00,'2022-09-22 11:18:10','',''),(6027,'1','274','1',1,'Retail Sale Id 5875',2001.92,0.00,0.00,2.72,179.52,'2022-09-22 11:21:50','',''),(6028,'1','274','1',1,'Retail Sale Id 5876',3702.08,0.00,0.00,5.03,331.98,'2022-09-22 11:30:44','',''),(6029,'1','274','1',1,'Retail Sale Id 5877',2252.16,0.00,0.00,3.06,201.96,'2022-09-22 11:41:38','',''),(6030,'1','274','1',1,'Retail Sale Id 5878',7360.00,0.00,0.00,10.00,660.00,'2022-09-22 11:42:56','',''),(6031,'1','274','1',1,'Retail Sale Id 5879',5497.92,0.00,0.00,7.47,493.02,'2022-09-22 13:11:31','',''),(6032,'1','274','1',1,'Retail Sale Id 5880',9200.00,0.00,0.00,12.50,825.00,'2022-09-22 13:34:11','',''),(6033,'1','274','1',1,'Retail Sale Id 5881',5152.00,0.00,0.00,7.00,462.00,'2022-09-22 13:39:30','',''),(6034,'1','274','1',1,'Retail Sale Id 5882',4997.44,0.00,0.00,6.79,448.14,'2022-09-22 13:40:35','',''),(6035,'1','274','1',1,'Retail Sale Id 5883',4496.96,0.00,0.00,6.11,403.26,'2022-09-22 13:41:12','',''),(6036,'1','274','1',1,'Retail Sale Id 5884',1000.96,0.00,0.00,1.36,89.76,'2022-09-22 13:43:50','',''),(6037,'1','274','1',1,'Retail Sale Id 5885',9200.00,0.00,0.00,12.50,825.00,'2022-09-22 13:46:37','',''),(6038,'1','274','1',1,'Retail Sale Id 5886',9200.00,0.00,0.00,12.50,825.00,'2022-09-22 13:51:43','',''),(6039,'1','274','1',1,'Retail Sale Id 5887',2001.92,0.00,0.00,2.72,179.52,'2022-09-22 13:53:16','',''),(6040,'1','274','1',1,'Retail Sale Id 5888',4496.96,0.00,0.00,6.11,403.26,'2022-09-22 14:05:33','',''),(6041,'1','274','1',1,'Retail Sale Id 5889',9200.00,0.00,0.00,12.50,825.00,'2022-09-22 14:13:30','',''),(6042,'1','274','1',1,'Retail Sale Id 5890',9200.00,0.00,0.00,12.50,825.00,'2022-09-22 14:27:58','',''),(6043,'1','274','1',1,'Retail Sale Id 5891',9200.00,0.00,0.00,12.50,825.00,'2022-09-22 15:17:35','',''),(6044,'1','274','1',1,'Retail Sale Id 5892',1000.96,0.00,0.00,1.36,89.76,'2022-09-22 15:27:19','',''),(6045,'1','274','1',1,'Retail Sale Id 5893',9200.00,0.00,0.00,12.50,825.00,'2022-09-22 15:49:09','',''),(6046,'1','274','1',1,'Retail Sale Id 5894',3002.88,0.00,0.00,4.08,269.28,'2022-09-22 16:07:09','',''),(6047,'1','274','1',1,'Retail Sale Id 5895',5998.40,0.00,0.00,8.15,537.90,'2022-09-22 16:13:54','',''),(6048,'1','274','1',1,'Retail Sale Id 5896',9001.28,0.00,0.00,12.23,807.18,'2022-09-22 16:26:17','',''),(6049,'1','274','1',1,'Retail Sale Id 5897',2208.00,0.00,0.00,3.00,198.00,'2022-09-22 16:29:16','',''),(6050,'1','274','1',1,'Retail Sale Id 5898',4401.28,0.00,0.00,5.98,394.68,'2022-09-22 16:37:06','',''),(6051,'1','274','1',1,'Retail Sale Id 5899',2303.68,0.00,0.00,3.13,206.58,'2022-09-22 16:44:00','',''),(6052,'1','274','1',1,'Retail Sale Id 5900',1000.96,0.00,0.00,1.36,89.76,'2022-09-22 16:49:27','',''),(6053,'1','274','1',1,'Retail Sale Id 5902',9200.00,0.00,0.00,12.50,825.00,'2022-09-22 16:50:58','',''),(6054,'1','274','1',1,'Retail Sale Id 5903',9501.76,0.00,0.00,12.91,852.06,'2022-09-22 16:52:58','',''),(6055,'1','274','1',1,'Retail Sale Id 5904',4496.96,0.00,0.00,6.11,403.26,'2022-09-22 16:59:21','',''),(6056,'1','274','1',1,'Retail Sale Id 5905',9200.00,0.00,0.00,12.50,825.00,'2022-09-22 17:03:14','',''),(6057,'1','274','1',1,'Retail Sale Id 5906',17502.08,0.00,0.00,23.78,1569.48,'2022-09-22 17:06:09','',''),(6058,'1','274','1',1,'Retail Sale Id 5907',1501.44,0.00,0.00,2.04,134.64,'2022-09-22 17:06:51','',''),(6059,'1','274','1',1,'Retail Sale Id 5908',1501.44,0.00,0.00,2.04,134.64,'2022-09-22 17:16:32','',''),(6060,'1','274','1',1,'Retail Sale Id 5909',9568.00,0.00,0.00,13.00,858.00,'2022-09-22 17:18:58','',''),(6061,'1','274','1',1,'Retail Sale Id 5910',3680.00,0.00,0.00,5.00,330.00,'2022-09-22 17:20:26','',''),(6062,'1','274','1',1,'Retail Sale Id 5911',9200.00,0.00,0.00,12.50,825.00,'2022-09-22 17:22:03','',''),(6063,'1','274','1',1,'Retail Sale Id 5912',18400.00,0.00,0.00,25.00,1650.00,'2022-09-22 17:23:30','',''),(6064,'1','274','1',1,'Retail Sale Id 5913',18400.00,0.00,0.00,25.00,1650.00,'2022-09-22 17:44:50','',''),(6065,'1','274','1',1,'Retail Sale Id 5913',26496.00,0.00,0.00,36.00,2376.00,'2022-09-22 17:44:50','',''),(6066,'1','274','1',1,'Retail Sale Id 5914',3002.88,0.00,0.00,4.08,269.28,'2022-09-22 17:47:20','',''),(6067,'1','274','1',1,'Retail Sale Id 5915',9200.00,0.00,0.00,12.50,825.00,'2022-09-22 18:11:26','',''),(6068,'1','274','1',1,'Retail Sale Id 5916',17001.60,0.00,0.00,23.10,1524.60,'2022-09-22 18:13:41','',''),(6069,'1','274','1',1,'Retail Sale Id 5917',6197.12,0.00,0.00,8.42,555.72,'2022-09-22 18:19:33','',''),(6070,'1','274','1',1,'Retail Sale Id 5918',4496.96,0.00,0.00,6.11,403.26,'2022-09-22 18:20:02','',''),(6071,'1','274','1',1,'Retail Sale Id 5919',3002.88,0.00,0.00,4.08,269.28,'2022-09-22 18:20:47','',''),(6072,'1','274','1',1,'Retail Sale Id 5920',9200.00,0.00,0.00,12.50,825.00,'2022-09-22 18:22:10','',''),(6073,'1','274','1',1,'Retail Sale Id 5921',4496.96,0.00,0.00,6.11,403.26,'2022-09-22 18:29:35','',''),(6074,'1','274','1',1,'Retail Sale Id 5922',3680.00,0.00,0.00,5.00,330.00,'2022-09-22 18:31:18','',''),(6075,'1','274','1',1,'Retail Sale Id 5923',9200.00,0.00,0.00,12.50,825.00,'2022-09-22 18:35:48','',''),(6076,'1','274','1',1,'Retail Sale Id 5924',2001.92,0.00,0.00,2.72,179.52,'2022-09-22 18:36:51','',''),(6077,'1','274','1',1,'Retail Sale Id 5925',6999.36,0.00,0.00,9.51,627.66,'2022-09-22 18:38:41','',''),(6078,'1','274','1',1,'Retail Sale Id 5925',9001.28,0.00,0.00,12.23,807.18,'2022-09-22 18:38:41','',''),(6079,'1','274','1',1,'Retail Sale Id 5926',1000.96,0.00,0.00,1.36,89.76,'2022-09-22 18:40:00','',''),(6080,'1','274','1',1,'Return of Retail Sale Id 5925',0.00,6999.36,9.51,0.00,-627.66,'2022-09-22 19:24:57','',''),(6081,'1','274','1',1,'Return of Retail Sale Id 5925',0.00,9001.28,12.23,0.00,-807.18,'2022-09-22 19:24:57','',''),(6082,'1','274','1',1,'Return of Retail Sale Id 5923',0.00,9200.00,12.50,0.00,-825.00,'2022-09-22 19:25:46','',''),(6083,'1','274','1',1,'Return of Retail Sale Id 5905',0.00,9200.00,12.50,0.00,-825.00,'2022-09-22 19:27:00','',''),(6084,'1','274','1',1,'Return of Retail Sale Id 5917',0.00,6197.12,8.42,0.00,-555.72,'2022-09-22 19:27:28','',''),(6085,'1','274','1',1,'Return of Retail Sale Id 5921',0.00,4496.96,6.11,0.00,-403.26,'2022-09-22 19:30:00','',''),(6086,'1','274','1',1,'Return of Retail Sale Id 5918',0.00,4496.96,6.11,0.00,-403.26,'2022-09-22 19:30:51','',''),(6087,'1','274','1',1,'Return of Retail Sale Id 5902',0.00,9200.00,12.50,0.00,-825.00,'2022-09-22 19:32:39','',''),(6088,'1','274','1',1,'Retail Sale Id 5927',6992.00,0.00,0.00,9.50,627.00,'2022-09-22 19:33:42','',''),(6089,'1','274','1',1,'Retail Sale Id 5928',36800.00,0.00,0.00,50.00,3300.00,'2022-09-22 19:34:48','',''),(6090,'1','274','1',1,'Retail Sale Id 5929',15927.04,0.00,0.00,21.64,1428.24,'2022-09-22 19:35:16','',''),(6091,'1','274','1',1,'Retail Sale Id 5930',11996.80,0.00,0.00,16.30,1075.80,'2022-09-23 06:28:14','',''),(6092,'1','274','1',1,'Retail Sale Id 5931',18400.00,0.00,0.00,25.00,1650.00,'2022-09-23 07:28:36','',''),(6093,'1','274','1',1,'Retail Sale Id 5932',6403.20,0.00,0.00,8.70,574.20,'2022-09-23 07:29:53','',''),(6094,'1','274','1',1,'Retail Sale Id 5933',16199.36,0.00,0.00,22.01,1452.66,'2022-09-23 07:53:48','',''),(6095,'1','274','1',1,'Retail Sale Id 5933',16898.56,0.00,0.00,22.96,1515.36,'2022-09-23 07:53:48','',''),(6096,'1','274','1',1,'Retail Sale Id 5934',9200.00,0.00,0.00,12.50,825.00,'2022-09-23 07:55:00','',''),(6097,'1','274','1',1,'Retail Sale Id 5935',4496.96,0.00,0.00,6.11,403.26,'2022-09-23 07:55:27','',''),(6098,'1','274','1',1,'Retail Sale Id 5936',9200.00,0.00,0.00,12.50,825.00,'2022-09-23 07:59:37','',''),(6099,'1','274','1',1,'Retail Sale Id 5937',4496.96,0.00,0.00,6.11,403.26,'2022-09-23 08:00:16','',''),(6100,'1','274','1',1,'Retail Sale Id 5938',2001.92,0.00,0.00,2.72,179.52,'2022-09-23 09:22:14','',''),(6101,'1','274','1',1,'Retail Sale Id 5939',9200.00,0.00,0.00,12.50,825.00,'2022-09-23 09:35:56','',''),(6102,'1','274','1',1,'Retail Sale Id 5940',9200.00,0.00,0.00,12.50,825.00,'2022-09-23 09:39:44','',''),(6103,'1','274','1',1,'Retail Sale Id 5941',9200.00,0.00,0.00,12.50,825.00,'2022-09-23 09:40:51','',''),(6104,'1','274','1',1,'Retail Sale Id 5942',4496.96,0.00,0.00,6.11,403.26,'2022-09-23 09:45:08','',''),(6105,'1','274','1',1,'Retail Sale Id 5943',3503.36,0.00,0.00,4.76,314.16,'2022-09-23 09:49:34','',''),(6106,'1','274','1',1,'Retail Sale Id 5944',9200.00,0.00,0.00,12.50,825.00,'2022-09-23 09:50:30','',''),(6107,'1','274','1',1,'Retail Sale Id 5945',10002.24,0.00,0.00,13.59,896.94,'2022-09-23 10:09:24','',''),(6108,'1','274','1',1,'Retail Sale Id 5946',9200.00,0.00,0.00,12.50,825.00,'2022-09-23 10:11:50','',''),(6109,'1','274','1',1,'Retail Sale Id 5947',1501.44,0.00,0.00,2.04,134.64,'2022-09-23 10:49:09','',''),(6110,'1','274','1',1,'Retail Sale Id 5948',9200.00,0.00,0.00,12.50,825.00,'2022-09-23 10:49:59','',''),(6111,'1','274','1',1,'Retail Sale Id 5949',16928.00,0.00,0.00,23.00,1518.00,'2022-09-23 10:52:34','',''),(6112,'1','274','1',1,'Retail Sale Id 5949',33856.00,0.00,0.00,46.00,3036.00,'2022-09-23 10:52:34','',''),(6113,'1','274','1',1,'Retail Sale Id 5950',2303.68,0.00,0.00,3.13,206.58,'2022-09-23 10:53:35','',''),(6114,'1','274','1',1,'Retail Sale Id 5951',9200.00,0.00,0.00,12.50,825.00,'2022-09-23 10:56:35','',''),(6115,'1','274','1',1,'Retail Sale Id 5952',2252.16,0.00,0.00,3.06,201.96,'2022-09-23 11:00:18','',''),(6116,'1','274','1',1,'Retail Sale Id 5953',6999.36,0.00,0.00,9.51,627.66,'2022-09-23 11:02:41','',''),(6117,'1','274','1',1,'Retail Sale Id 5954',736.00,0.00,0.00,1.00,66.00,'2022-09-23 11:13:46','',''),(6118,'1','274','1',1,'Retail Sale Id 5955',2001.92,0.00,0.00,2.72,179.52,'2022-09-23 11:19:28','',''),(6119,'1','274','1',1,'Retail Sale Id 5956',2303.68,0.00,0.00,3.13,206.58,'2022-09-23 11:23:04','',''),(6120,'1','274','1',1,'Retail Sale Id 5957',802.24,0.00,0.00,1.09,71.94,'2022-09-23 11:29:47','',''),(6121,'1','274','1',1,'Retail Sale Id 5958',9200.00,0.00,0.00,12.50,825.00,'2022-09-23 11:30:36','',''),(6122,'1','274','1',1,'Retail Sale Id 5959',2252.16,0.00,0.00,3.06,201.96,'2022-09-23 11:33:57','',''),(6123,'1','274','1',1,'Retail Sale Id 5960',2303.68,0.00,0.00,3.13,206.58,'2022-09-23 11:35:05','',''),(6124,'1','274','1',1,'Retail Sale Id 5961',1000.96,0.00,0.00,1.36,89.76,'2022-09-23 11:36:12','',''),(6125,'1','274','1',1,'Retail Sale Id 5962',2252.16,0.00,0.00,3.06,201.96,'2022-09-23 11:54:15','',''),(6126,'1','274','1',1,'Retail Sale Id 5963',9200.00,0.00,0.00,12.50,825.00,'2022-09-23 12:01:00','',''),(6127,'1','274','1',1,'Retail Sale Id 5964',73600.00,0.00,0.00,100.00,6600.00,'2022-09-23 12:07:37','',''),(6128,'1','274','1',1,'Retail Sale Id 5965',4496.96,0.00,0.00,6.11,403.26,'2022-09-23 12:11:58','',''),(6129,'1','274','1',1,'Retail Sale Id 5966',9200.00,0.00,0.00,12.50,825.00,'2022-09-23 12:18:49','',''),(6130,'1','274','1',1,'Retail Sale Id 5967',1000.96,0.00,0.00,1.36,89.76,'2022-09-23 12:21:53','',''),(6131,'1','274','1',1,'Retail Sale Id 5968',22080.00,0.00,0.00,30.00,1980.00,'2022-09-23 12:24:08','',''),(6132,'1','274','1',1,'Retail Sale Id 5969',9200.00,0.00,0.00,12.50,825.00,'2022-09-23 12:31:07','',''),(6133,'1','274','1',1,'Retail Sale Id 5970',9200.00,0.00,0.00,12.50,825.00,'2022-09-23 12:48:39','',''),(6134,'1','274','1',1,'Retail Sale Id 5971',3002.88,0.00,0.00,4.08,269.28,'2022-09-23 12:50:06','',''),(6135,'1','274','1',1,'Retail Sale Id 5972',9200.00,0.00,0.00,12.50,825.00,'2022-09-23 14:51:13','',''),(6136,'1','274','1',1,'Retail Sale Id 5973',9200.00,0.00,0.00,12.50,825.00,'2022-09-23 14:52:56','',''),(6137,'1','274','1',1,'Retail Sale Id 5974',3002.88,0.00,0.00,4.08,269.28,'2022-09-23 14:54:24','',''),(6138,'1','274','1',1,'Retail Sale Id 5975',8103.36,0.00,0.00,11.01,726.66,'2022-09-23 14:59:27','',''),(6139,'1','274','1',1,'Retail Sale Id 5976',2303.68,0.00,0.00,3.13,206.58,'2022-09-23 15:00:24','',''),(6140,'1','274','1',1,'Retail Sale Id 5977',7360.00,0.00,0.00,10.00,660.00,'2022-09-23 15:07:31','',''),(6141,'1','274','1',1,'Retail Sale Id 5977',18400.00,0.00,0.00,25.00,1650.00,'2022-09-23 15:07:31','',''),(6142,'1','274','1',1,'Retail Sale Id 5978',9200.00,0.00,0.00,12.50,825.00,'2022-09-23 15:09:10','',''),(6143,'1','274','1',1,'Retail Sale Id 5979',2001.92,0.00,0.00,2.72,179.52,'2022-09-23 15:20:31','',''),(6144,'1','274','1',1,'Retail Sale Id 5980',4496.96,0.00,0.00,6.11,403.26,'2022-09-23 15:43:27','',''),(6145,'1','274','1',1,'Retail Sale Id 5981',4496.96,0.00,0.00,6.11,403.26,'2022-09-23 15:45:36','',''),(6146,'1','274','1',1,'Retail Sale Id 5982',2252.16,0.00,0.00,3.06,201.96,'2022-09-23 16:06:20','',''),(6147,'1','274','1',1,'Retail Sale Id 5983',2502.40,0.00,0.00,3.40,224.40,'2022-09-23 16:16:35','',''),(6148,'1','274','1',1,'Retail Sale Id 5984',2001.92,0.00,0.00,2.72,179.52,'2022-09-23 16:17:45','',''),(6149,'1','274','1',1,'Retail Sale Id 5985',2001.92,0.00,0.00,2.72,179.52,'2022-09-23 16:21:36','',''),(6150,'1','274','1',1,'Retail Sale Id 5986',9200.00,0.00,0.00,12.50,825.00,'2022-09-23 16:34:31','',''),(6151,'1','274','1',1,'Retail Sale Id 5987',2001.92,0.00,0.00,2.72,179.52,'2022-09-23 16:35:25','',''),(6152,'1','274','1',1,'Retail Sale Id 5988',6498.88,0.00,0.00,8.83,582.78,'2022-09-23 16:46:53','',''),(6153,'1','274','1',1,'Retail Sale Id 5989',2001.92,0.00,0.00,2.72,179.52,'2022-09-23 16:47:39','',''),(6154,'1','274','1',1,'Retail Sale Id 5990',2001.92,0.00,0.00,2.72,179.52,'2022-09-23 17:28:43','',''),(6155,'1','274','1',1,'Retail Sale Id 5991',3002.88,0.00,0.00,4.08,269.28,'2022-09-23 17:29:45','',''),(6156,'1','274','1',1,'Retail Sale Id 5992',7360.00,0.00,0.00,10.00,660.00,'2022-09-23 17:30:37','',''),(6157,'1','274','1',1,'Retail Sale Id 5993',6999.36,0.00,0.00,9.51,627.66,'2022-09-23 17:31:25','',''),(6158,'1','274','1',1,'Retail Sale Id 5994',4496.96,0.00,0.00,6.11,403.26,'2022-09-23 17:41:07','',''),(6159,'1','274','1',1,'Retail Sale Id 5995',1501.44,0.00,0.00,2.04,134.64,'2022-09-23 17:51:19','',''),(6160,'1','274','1',1,'Retail Sale Id 5996',9568.00,0.00,0.00,13.00,858.00,'2022-09-23 17:52:42','',''),(6161,'1','274','1',1,'Retail Sale Id 5998',750.72,0.00,0.00,1.02,67.32,'2022-09-23 17:55:29','',''),(6162,'1','274','1',1,'Retail Sale Id 5999',7360.00,0.00,0.00,10.00,660.00,'2022-09-23 18:02:18','',''),(6163,'1','274','1',1,'Retail Sale Id 6000',9200.00,0.00,0.00,12.50,825.00,'2022-09-23 18:09:09','',''),(6164,'1','274','1',1,'Retail Sale Id 6001',1501.44,0.00,0.00,2.04,134.64,'2022-09-23 18:13:05','',''),(6165,'1','274','1',1,'Retail Sale Id 6002',27600.00,0.00,0.00,37.50,2475.00,'2022-09-23 18:26:05','',''),(6166,'1','274','1',1,'Retail Sale Id 6002',36800.00,0.00,0.00,50.00,3300.00,'2022-09-23 18:26:05','',''),(6167,'1','274','1',1,'Retail Sale Id 6003',3002.88,0.00,0.00,4.08,269.28,'2022-09-23 18:27:59','',''),(6168,'1','274','1',1,'Retail Sale Id 6004',9200.00,0.00,0.00,12.50,825.00,'2022-09-23 18:34:32','',''),(6169,'1','274','1',1,'Retail Sale Id 6005',24332.16,0.00,0.00,33.06,2181.96,'2022-09-23 19:28:33','',''),(6170,'1','274','1',1,'Retail Sale Id 6006',22065.28,0.00,0.00,29.98,1978.68,'2022-09-23 19:29:32','',''),(6171,'1','274','1',1,'Retail Sale Id 6008',2001.92,0.00,0.00,2.72,179.52,'2022-09-24 06:28:08','',''),(6172,'1','274','1',1,'Retail Sale Id 6009',24957.76,0.00,0.00,33.91,2238.06,'2022-09-24 07:20:00','',''),(6173,'1','274','1',1,'Retail Sale Id 6011',20998.08,0.00,0.00,28.53,1882.98,'2022-09-24 07:21:11','',''),(6174,'1','274','1',1,'Retail Sale Id 6012',8103.36,0.00,0.00,11.01,726.66,'2022-09-24 07:22:33','',''),(6175,'1','274','1',1,'Retail Sale Id 6012',9200.00,0.00,0.00,12.50,825.00,'2022-09-24 07:22:33','',''),(6176,'1','274','1',1,'Retail Sale Id 6012',1472000.00,0.00,0.00,2000.00,132000.00,'2022-09-24 07:22:33','',''),(6177,'1','274','1',1,'Return of Retail Sale Id 6012',0.00,8103.36,11.01,0.00,-726.66,'2022-09-24 07:23:25','',''),(6178,'1','274','1',1,'Return of Retail Sale Id 6012',0.00,9200.00,12.50,0.00,-825.00,'2022-09-24 07:23:25','',''),(6179,'1','274','1',1,'Return of Retail Sale Id 6012',0.00,1472000.00,2000.00,0.00,-132000.00,'2022-09-24 07:23:25','',''),(6180,'1','274','1',1,'Retail Sale Id 6014',2001.92,0.00,0.00,2.72,179.52,'2022-09-24 07:24:57','',''),(6181,'1','274','1',1,'Retail Sale Id 6014',8103.36,0.00,0.00,11.01,726.66,'2022-09-24 07:24:57','',''),(6182,'1','274','1',1,'Retail Sale Id 6014',9200.00,0.00,0.00,12.50,825.00,'2022-09-24 07:24:57','',''),(6183,'1','274','1',1,'Retail Sale Id 6015',2252.16,0.00,0.00,3.06,201.96,'2022-09-24 07:25:30','',''),(6184,'1','274','1',1,'Retail Sale Id 6016',3687.36,0.00,0.00,5.01,330.66,'2022-09-24 07:43:05','',''),(6185,'1','274','1',1,'Retail Sale Id 6017',7360.00,0.00,0.00,10.00,660.00,'2022-09-24 07:52:40','',''),(6186,'1','274','1',1,'Retail Sale Id 6018',2001.92,0.00,0.00,2.72,179.52,'2022-09-24 08:32:26','',''),(6187,'1','274','1',1,'Retail Sale Id 6019',2252.16,0.00,0.00,3.06,201.96,'2022-09-24 08:33:59','',''),(6188,'1','274','1',1,'Retail Sale Id 6020',9200.00,0.00,0.00,12.50,825.00,'2022-09-24 08:35:46','',''),(6189,'1','274','1',1,'Retail Sale Id 6021',8000.32,0.00,0.00,10.87,717.42,'2022-09-24 08:38:55','',''),(6190,'1','274','1',1,'Retail Sale Id 6022',9200.00,0.00,0.00,12.50,825.00,'2022-09-24 08:42:09','',''),(6191,'1','274','1',1,'Retail Sale Id 6023',1501.44,0.00,0.00,2.04,134.64,'2022-09-24 08:52:09','',''),(6192,'1','274','1',1,'Retail Sale Id 6024',3002.88,0.00,0.00,4.08,269.28,'2022-09-24 08:53:39','',''),(6193,'1','274','1',1,'Retail Sale Id 6025',11503.68,0.00,0.00,15.63,1031.58,'2022-09-24 08:55:48','',''),(6194,'1','274','1',1,'Retail Sale Id 6026',1501.44,0.00,0.00,2.04,134.64,'2022-09-24 09:17:52','',''),(6195,'1','274','1',1,'Retail Sale Id 6027',2001.92,0.00,0.00,2.72,179.52,'2022-09-24 09:25:10','',''),(6196,'1','274','1',1,'Retail Sale Id 6028',2502.40,0.00,0.00,3.40,224.40,'2022-09-24 09:50:00','',''),(6197,'1','274','1',1,'Retail Sale Id 6029',9200.00,0.00,0.00,12.50,825.00,'2022-09-24 10:18:27','',''),(6198,'1','274','1',1,'Retail Sale Id 6030',3680.00,0.00,0.00,5.00,330.00,'2022-09-24 10:26:28','',''),(6199,'1','274','1',1,'Retail Sale Id 6031',3002.88,0.00,0.00,4.08,269.28,'2022-09-24 10:41:52','',''),(6200,'1','274','1',1,'Retail Sale Id 6032',14720.00,0.00,0.00,20.00,1320.00,'2022-09-24 10:53:29','',''),(6201,'1','274','1',1,'Retail Sale Id 6032',15456.00,0.00,0.00,21.00,1386.00,'2022-09-24 10:53:29','',''),(6202,'1','274','1',1,'Retail Sale Id 6033',9200.00,0.00,0.00,12.50,825.00,'2022-09-24 10:57:19','',''),(6203,'1','274','1',1,'Retail Sale Id 6034',2001.92,0.00,0.00,2.72,179.52,'2022-09-24 11:31:02','',''),(6204,'1','274','1',1,'Retail Sale Id 6035',20998.08,0.00,0.00,28.53,1882.98,'2022-09-24 11:38:01','',''),(6205,'1','274','1',1,'Retail Sale Id 6036',5888.00,0.00,0.00,8.00,528.00,'2022-09-24 11:51:15','',''),(6206,'1','274','1',1,'Retail Sale Id 6037',9200.00,0.00,0.00,12.50,825.00,'2022-09-24 11:57:05','',''),(6207,'1','274','1',1,'Retail Sale Id 6038',3002.88,0.00,0.00,4.08,269.28,'2022-09-24 12:09:31','',''),(6208,'1','274','1',1,'Retail Sale Id 6039',2001.92,0.00,0.00,2.72,179.52,'2022-09-24 12:21:39','',''),(6209,'1','274','1',1,'Retail Sale Id 6040',4496.96,0.00,0.00,6.11,403.26,'2022-09-24 12:25:28','',''),(6210,'1','274','1',1,'Retail Sale Id 6041',4496.96,0.00,0.00,6.11,403.26,'2022-09-24 12:25:58','',''),(6211,'1','274','1',1,'Retail Sale Id 6042',1501.44,0.00,0.00,2.04,134.64,'2022-09-24 12:27:15','',''),(6212,'1','274','1',1,'Retail Sale Id 6044',3680.00,0.00,0.00,5.00,330.00,'2022-09-24 12:31:35','',''),(6213,'1','274','1',1,'Retail Sale Id 6045',5888.00,0.00,0.00,8.00,528.00,'2022-09-24 12:47:06','',''),(6214,'1','274','1',1,'Retail Sale Id 6046',13616.00,0.00,0.00,18.50,1221.00,'2022-09-24 12:48:43','',''),(6215,'1','274','1',1,'Retail Sale Id 6047',9200.00,0.00,0.00,12.50,825.00,'2022-09-24 13:08:36','',''),(6216,'1','274','1',1,'Retail Sale Id 6048',3002.88,0.00,0.00,4.08,269.28,'2022-09-24 13:09:34','',''),(6217,'1','274','1',1,'Retail Sale Id 6049',4416.00,0.00,0.00,6.00,396.00,'2022-09-24 13:34:50','',''),(6218,'1','274','1',1,'Retail Sale Id 6050',3002.88,0.00,0.00,4.08,269.28,'2022-09-24 13:46:32','',''),(6219,'1','274','1',1,'Retail Sale Id 6051',9200.00,0.00,0.00,12.50,825.00,'2022-09-24 13:48:59','',''),(6220,'1','274','1',1,'Retail Sale Id 6052',2303.68,0.00,0.00,3.13,206.58,'2022-09-24 14:09:23','',''),(6221,'1','274','1',1,'Retail Sale Id 6054',22080.00,0.00,0.00,30.00,1980.00,'2022-09-24 14:17:19','',''),(6222,'1','274','1',1,'Retail Sale Id 6055',4496.96,0.00,0.00,6.11,403.26,'2022-09-24 14:28:41','',''),(6223,'1','274','1',1,'Retail Sale Id 6056',3503.36,0.00,0.00,4.76,314.16,'2022-09-24 14:40:16','',''),(6224,'1','274','1',1,'Retail Sale Id 6057',6999.36,0.00,0.00,9.51,627.66,'2022-09-24 14:45:13','',''),(6225,'1','274','1',1,'Retail Sale Id 6058',9200.00,0.00,0.00,12.50,825.00,'2022-09-24 14:47:31','',''),(6226,'1','274','1',1,'Retail Sale Id 6059',3002.88,0.00,0.00,4.08,269.28,'2022-09-24 14:49:58','',''),(6227,'1','274','1',1,'Retail Sale Id 6060',9200.00,0.00,0.00,12.50,825.00,'2022-09-24 15:08:24','',''),(6228,'1','274','1',1,'Retail Sale Id 6061',4496.96,0.00,0.00,6.11,403.26,'2022-09-24 15:13:38','',''),(6229,'1','274','1',1,'Retail Sale Id 6062',2001.92,0.00,0.00,2.72,179.52,'2022-09-24 15:38:38','',''),(6230,'1','274','1',1,'Retail Sale Id 6063',3503.36,0.00,0.00,4.76,314.16,'2022-09-24 15:56:04','',''),(6231,'1','274','1',1,'Retail Sale Id 6064',1501.44,0.00,0.00,2.04,134.64,'2022-09-24 15:57:15','',''),(6232,'1','274','1',1,'Retail Sale Id 6065',3680.00,0.00,0.00,5.00,330.00,'2022-09-24 15:59:52','',''),(6233,'1','274','1',1,'Retail Sale Id 6066',3996.48,0.00,0.00,5.43,358.38,'2022-09-24 16:25:30','',''),(6234,'1','274','1',1,'Retail Sale Id 6067',2001.92,0.00,0.00,2.72,179.52,'2022-09-24 16:32:44','',''),(6235,'1','274','1',1,'Retail Sale Id 6068',5998.40,0.00,0.00,8.15,537.90,'2022-09-24 16:37:10','',''),(6236,'1','274','1',1,'Retail Sale Id 6069',2252.16,0.00,0.00,3.06,201.96,'2022-09-24 17:02:13','',''),(6237,'1','274','1',1,'Retail Sale Id 6070',13616.00,0.00,0.00,18.50,1221.00,'2022-09-24 17:05:25','',''),(6238,'1','274','1',1,'Retail Sale Id 6071',4496.96,0.00,0.00,6.11,403.26,'2022-09-24 17:07:48','',''),(6239,'1','274','1',1,'Retail Sale Id 6072',1000.96,0.00,0.00,1.36,89.76,'2022-09-24 17:09:06','',''),(6240,'1','274','1',1,'Retail Sale Id 6073',3002.88,0.00,0.00,4.08,269.28,'2022-09-24 17:10:11','',''),(6241,'1','274','1',1,'Retail Sale Id 6074',1803.20,0.00,0.00,2.45,161.70,'2022-09-24 17:11:19','',''),(6242,'1','274','1',1,'Retail Sale Id 6075',9200.00,0.00,0.00,12.50,825.00,'2022-09-24 17:40:50','',''),(6243,'1','274','1',1,'Retail Sale Id 6076',6498.88,0.00,0.00,8.83,582.78,'2022-09-24 17:42:39','',''),(6244,'1','274','1',1,'Retail Sale Id 6077',9200.00,0.00,0.00,12.50,825.00,'2022-09-24 17:44:08','',''),(6245,'1','274','1',1,'Retail Sale Id 6078',2252.16,0.00,0.00,3.06,201.96,'2022-09-24 17:45:14','',''),(6246,'1','274','1',1,'Retail Sale Id 6079',7360.00,0.00,0.00,10.00,660.00,'2022-09-24 17:46:32','',''),(6247,'1','274','1',1,'Retail Sale Id 6080',9200.00,0.00,0.00,12.50,825.00,'2022-09-24 17:47:35','',''),(6248,'1','274','1',1,'Retail Sale Id 6081',2303.68,0.00,0.00,3.13,206.58,'2022-09-24 17:57:53','',''),(6249,'1','274','1',1,'Retail Sale Id 6082',4496.96,0.00,0.00,6.11,403.26,'2022-09-24 18:00:32','',''),(6250,'1','274','1',1,'Retail Sale Id 6083',9200.00,0.00,0.00,12.50,825.00,'2022-09-24 18:04:11','',''),(6251,'1','274','1',1,'Retail Sale Id 6084',2252.16,0.00,0.00,3.06,201.96,'2022-09-24 18:08:25','',''),(6252,'1','274','1',1,'Retail Sale Id 6085',4496.96,0.00,0.00,6.11,403.26,'2022-09-24 18:21:12','',''),(6253,'1','274','1',1,'Retail Sale Id 6086',6999.36,0.00,0.00,9.51,627.66,'2022-09-24 18:29:35','',''),(6254,'1','274','1',1,'Retail Sale Id 6087',8000.32,0.00,0.00,10.87,717.42,'2022-09-24 18:31:44','',''),(6255,'1','274','1',1,'Retail Sale Id 6088',1501.44,0.00,0.00,2.04,134.64,'2022-09-24 18:35:04','',''),(6256,'1','274','1',1,'Retail Sale Id 6089',9200.00,0.00,0.00,12.50,825.00,'2022-09-24 18:37:41','',''),(6257,'1','274','1',1,'Retail Sale Id 6090',9200.00,0.00,0.00,12.50,825.00,'2022-09-24 18:40:15','',''),(6258,'1','274','1',1,'Return of Retail Sale Id 6009',0.00,24957.76,33.91,0.00,-2238.06,'2022-09-24 19:12:33','',''),(6259,'1','274','1',1,'Retail Sale Id 6091',7337.92,0.00,0.00,9.97,658.02,'2022-09-24 19:13:53','',''),(6260,'1','274','1',1,'Retail Sale Id 6092',34724.48,0.00,0.00,47.18,3113.88,'2022-09-24 19:15:19','',''),(6261,'1','274','1',1,'Retail Sale Id 6093',2001.92,0.00,0.00,2.72,179.52,'2022-09-25 06:38:20','',''),(6262,'1','274','1',1,'Retail Sale Id 6093',9200.00,0.00,0.00,12.50,825.00,'2022-09-25 06:38:20','',''),(6263,'1','274','1',1,'Retail Sale Id 6094',21999.04,0.00,0.00,29.89,1972.74,'2022-09-25 06:44:25','',''),(6264,'1','274','1',1,'Retail Sale Id 6095',3503.36,0.00,0.00,4.76,314.16,'2022-09-25 07:59:31','',''),(6265,'1','274','1',1,'Retail Sale Id 6096',18400.00,0.00,0.00,25.00,1650.00,'2022-09-25 08:46:35','',''),(6266,'1','274','1',1,'Return of Retail Sale Id 6096',0.00,18400.00,25.00,0.00,-1650.00,'2022-09-25 09:19:33','',''),(6267,'1','274','1',1,'Retail Sale Id 6097',9200.00,0.00,0.00,12.50,825.00,'2022-09-25 09:20:28','',''),(6268,'1','274','1',1,'Retail Sale Id 6097',9200.00,0.00,0.00,12.50,825.00,'2022-09-25 09:20:28','',''),(6269,'1','274','1',1,'Retail Sale Id 6098',9200.00,0.00,0.00,12.50,825.00,'2022-09-25 09:20:54','',''),(6270,'1','274','1',1,'Retail Sale Id 6099',9200.00,0.00,0.00,12.50,825.00,'2022-09-25 09:22:57','',''),(6271,'1','274','1',1,'Retail Sale Id 6100',2200.64,0.00,0.00,2.99,197.34,'2022-09-25 09:28:43','',''),(6272,'1','274','1',1,'Retail Sale Id 6101',9200.00,0.00,0.00,12.50,825.00,'2022-09-25 09:32:42','',''),(6273,'1','274','1',1,'Retail Sale Id 6102',4496.96,0.00,0.00,6.11,403.26,'2022-09-25 09:36:53','',''),(6274,'1','274','1',1,'Retail Sale Id 6103',2303.68,0.00,0.00,3.13,206.58,'2022-09-25 09:56:58','',''),(6275,'1','274','1',1,'Retail Sale Id 6104',3702.08,0.00,0.00,5.03,331.98,'2022-09-25 09:57:57','',''),(6276,'1','274','1',1,'Retail Sale Id 6105',4496.96,0.00,0.00,6.11,403.26,'2022-09-25 10:04:44','',''),(6277,'1','274','1',1,'Retail Sale Id 6106',9200.00,0.00,0.00,12.50,825.00,'2022-09-25 10:06:43','',''),(6278,'1','274','1',1,'Retail Sale Id 6107',9200.00,0.00,0.00,12.50,825.00,'2022-09-25 10:07:53','',''),(6279,'1','274','1',1,'Retail Sale Id 6108',3680.00,0.00,0.00,5.00,330.00,'2022-09-25 10:09:14','',''),(6280,'1','274','1',1,'Retail Sale Id 6109',2303.68,0.00,0.00,3.13,206.58,'2022-09-25 10:12:12','',''),(6281,'1','274','1',1,'Retail Sale Id 6110',1000.96,0.00,0.00,1.36,89.76,'2022-09-25 10:20:28','',''),(6282,'1','274','1',1,'Retail Sale Id 6111',4496.96,0.00,0.00,6.11,403.26,'2022-09-25 10:21:13','',''),(6283,'1','274','1',1,'Retail Sale Id 6112',7360.00,0.00,0.00,10.00,660.00,'2022-09-25 10:39:11','',''),(6284,'1','274','1',1,'Retail Sale Id 6113',4496.96,0.00,0.00,6.11,403.26,'2022-09-25 10:39:53','',''),(6285,'1','274','1',1,'Retail Sale Id 6114',4496.96,0.00,0.00,6.11,403.26,'2022-09-25 10:54:00','',''),(6286,'1','274','1',1,'Retail Sale Id 6115',2252.16,0.00,0.00,3.06,201.96,'2022-09-25 10:59:57','',''),(6287,'1','274','1',1,'Retail Sale Id 6116',9200.00,0.00,0.00,12.50,825.00,'2022-09-25 11:04:47','',''),(6288,'1','274','1',1,'Retail Sale Id 6117',9200.00,0.00,0.00,12.50,825.00,'2022-09-25 11:18:53','',''),(6289,'1','274','1',1,'Retail Sale Id 6118',1000.96,0.00,0.00,1.36,89.76,'2022-09-25 11:21:26','',''),(6290,'1','274','1',1,'Retail Sale Id 6119',4496.96,0.00,0.00,6.11,403.26,'2022-09-25 11:23:53','',''),(6291,'1','274','1',1,'Retail Sale Id 6120',2252.16,0.00,0.00,3.06,201.96,'2022-09-25 11:25:05','',''),(6292,'1','274','1',1,'Retail Sale Id 6121',18400.00,0.00,0.00,25.00,1650.00,'2022-09-25 11:34:01','',''),(6293,'1','274','1',1,'Retail Sale Id 6122',9200.00,0.00,0.00,12.50,825.00,'2022-09-25 11:37:45','',''),(6294,'1','274','1',1,'Retail Sale Id 6124',2502.40,0.00,0.00,3.40,224.40,'2022-09-25 11:58:38','',''),(6295,'1','274','1',1,'Retail Sale Id 6125',1501.44,0.00,0.00,2.04,134.64,'2022-09-25 12:12:02','',''),(6296,'1','274','1',1,'Retail Sale Id 6127',18400.00,0.00,0.00,25.00,1650.00,'2022-09-25 12:18:30','',''),(6297,'1','274','1',1,'Retail Sale Id 6128',2001.92,0.00,0.00,2.72,179.52,'2022-09-25 12:21:36','',''),(6298,'1','274','1',1,'Retail Sale Id 6129',2001.92,0.00,0.00,2.72,179.52,'2022-09-25 12:22:52','',''),(6299,'1','274','1',1,'Retail Sale Id 6130',1472.00,0.00,0.00,2.00,132.00,'2022-09-25 12:23:50','',''),(6300,'1','274','1',1,'Retail Sale Id 6131',9200.00,0.00,0.00,12.50,825.00,'2022-09-25 12:24:42','',''),(6301,'1','274','1',1,'Retail Sale Id 6132',9200.00,0.00,0.00,12.50,825.00,'2022-09-25 12:26:49','',''),(6302,'1','274','1',1,'Retail Sale Id 6133',9568.00,0.00,0.00,13.00,858.00,'2022-09-25 12:27:35','',''),(6303,'1','274','1',1,'Retail Sale Id 6134',4496.96,0.00,0.00,6.11,403.26,'2022-09-25 12:31:14','',''),(6304,'1','274','1',1,'Retail Sale Id 6135',27496.96,0.00,0.00,37.36,2465.76,'2022-09-25 12:37:50','',''),(6305,'1','274','1',1,'Retail Sale Id 6136',500.48,0.00,0.00,0.68,44.88,'2022-09-25 12:40:56','',''),(6306,'1','274','1',1,'Retail Sale Id 6137',3002.88,0.00,0.00,4.08,269.28,'2022-09-25 12:45:12','',''),(6307,'1','274','1',1,'Retail Sale Id 6138',1501.44,0.00,0.00,2.04,134.64,'2022-09-25 12:45:54','',''),(6308,'1','274','1',1,'Retail Sale Id 6139',9200.00,0.00,0.00,12.50,825.00,'2022-09-25 12:55:50','',''),(6309,'1','274','1',1,'Retail Sale Id 6140',4496.96,0.00,0.00,6.11,403.26,'2022-09-25 13:30:12','',''),(6310,'1','274','1',1,'Retail Sale Id 6141',3680.00,0.00,0.00,5.00,330.00,'2022-09-25 13:35:22','',''),(6311,'1','274','1',1,'Retail Sale Id 6142',3002.88,0.00,0.00,4.08,269.28,'2022-09-25 13:37:24','',''),(6312,'1','274','1',1,'Retail Sale Id 6143',2208.00,0.00,0.00,3.00,198.00,'2022-09-25 13:38:43','',''),(6313,'1','274','1',1,'Retail Sale Id 6144',9200.00,0.00,0.00,12.50,825.00,'2022-09-25 13:47:12','',''),(6314,'1','274','1',1,'Retail Sale Id 6145',3002.88,0.00,0.00,4.08,269.28,'2022-09-25 13:53:35','',''),(6315,'1','274','1',1,'Retail Sale Id 6146',2001.92,0.00,0.00,2.72,179.52,'2022-09-25 13:54:18','',''),(6316,'1','274','1',1,'Retail Sale Id 6147',1501.44,0.00,0.00,2.04,134.64,'2022-09-25 13:57:31','',''),(6317,'1','274','1',1,'Retail Sale Id 6148',2001.92,0.00,0.00,2.72,179.52,'2022-09-25 14:02:37','',''),(6318,'1','274','1',1,'Retail Sale Id 6149',3503.36,0.00,0.00,4.76,314.16,'2022-09-25 14:09:35','',''),(6319,'1','274','1',1,'Retail Sale Id 6150',1000.96,0.00,0.00,1.36,89.76,'2022-09-25 14:12:28','',''),(6320,'1','274','1',1,'Retail Sale Id 6151',1000.96,0.00,0.00,1.36,89.76,'2022-09-25 14:23:09','',''),(6321,'1','274','1',1,'Retail Sale Id 6152',2208.00,0.00,0.00,3.00,198.00,'2022-09-25 14:33:13','',''),(6322,'1','274','1',1,'Retail Sale Id 6153',3680.00,0.00,0.00,5.00,330.00,'2022-09-25 14:38:38','',''),(6323,'1','274','1',1,'Retail Sale Id 6154',9200.00,0.00,0.00,12.50,825.00,'2022-09-25 14:39:55','',''),(6324,'1','274','1',1,'Retail Sale Id 6155',9200.00,0.00,0.00,12.50,825.00,'2022-09-25 14:45:34','',''),(6325,'1','274','1',1,'Retail Sale Id 6155',11408.00,0.00,0.00,15.50,1023.00,'2022-09-25 14:45:34','',''),(6326,'1','274','1',1,'Retail Sale Id 6156',3680.00,0.00,0.00,5.00,330.00,'2022-09-25 14:57:33','',''),(6327,'1','274','1',1,'Retail Sale Id 6157',4416.00,0.00,0.00,6.00,396.00,'2022-09-25 15:07:15','',''),(6328,'1','274','1',1,'Retail Sale Id 6158',2208.00,0.00,0.00,3.00,198.00,'2022-09-25 15:16:58','',''),(6329,'1','274','1',1,'Retail Sale Id 6159',2502.40,0.00,0.00,3.40,224.40,'2022-09-25 15:40:53','',''),(6330,'1','274','1',1,'Retail Sale Id 6160',3680.00,0.00,0.00,5.00,330.00,'2022-09-25 15:43:21','',''),(6331,'1','274','1',1,'Retail Sale Id 6161',5299.20,0.00,0.00,7.20,475.20,'2022-09-25 15:47:38','',''),(6332,'1','274','1',1,'Retail Sale Id 6161',9200.00,0.00,0.00,12.50,825.00,'2022-09-25 15:47:38','',''),(6333,'1','274','1',1,'Retail Sale Id 6162',9200.00,0.00,0.00,12.50,825.00,'2022-09-25 15:48:27','',''),(6334,'1','274','1',1,'Retail Sale Id 6163',22102.08,0.00,0.00,30.03,1981.98,'2022-09-25 16:11:14','',''),(6335,'1','274','1',1,'Retail Sale Id 6164',2001.92,0.00,0.00,2.72,179.52,'2022-09-25 16:13:26','',''),(6336,'1','274','1',1,'Retail Sale Id 6166',6999.36,0.00,0.00,9.51,627.66,'2022-09-25 16:20:15','',''),(6337,'1','274','1',1,'Retail Sale Id 6167',7360.00,0.00,0.00,10.00,660.00,'2022-09-25 16:35:40','',''),(6338,'1','274','1',1,'Retail Sale Id 6168',9200.00,0.00,0.00,12.50,825.00,'2022-09-25 16:44:18','',''),(6339,'1','274','1',1,'Retail Sale Id 6169',3702.08,0.00,0.00,5.03,331.98,'2022-09-25 16:53:30','',''),(6340,'1','274','1',1,'Retail Sale Id 6170',18400.00,0.00,0.00,25.00,1650.00,'2022-09-25 17:11:19','',''),(6341,'1','274','1',1,'Retail Sale Id 6171',2001.92,0.00,0.00,2.72,179.52,'2022-09-25 17:11:58','',''),(6342,'1','274','1',1,'Retail Sale Id 6172',4997.44,0.00,0.00,6.79,448.14,'2022-09-25 17:20:46','',''),(6343,'1','274','1',1,'Retail Sale Id 6173',17502.08,0.00,0.00,23.78,1569.48,'2022-09-25 17:43:15','',''),(6344,'1','274','1',1,'Retail Sale Id 6174',73600.00,0.00,0.00,100.00,6600.00,'2022-09-25 17:51:08','',''),(6345,'1','274','1',1,'Retail Sale Id 6175',2252.16,0.00,0.00,3.06,201.96,'2022-09-25 17:56:39','',''),(6346,'1','274','1',1,'Retail Sale Id 6176',22.08,0.00,0.00,0.03,1.98,'2022-09-25 17:58:20','',''),(6347,'1','274','1',1,'Retail Sale Id 6177',18400.00,0.00,0.00,25.00,1650.00,'2022-09-25 18:00:14','',''),(6348,'1','274','1',1,'Retail Sale Id 6178',12902.08,0.00,0.00,17.53,1156.98,'2022-09-25 18:06:06','',''),(6349,'1','274','1',1,'Retail Sale Id 6179',9200.00,0.00,0.00,12.50,825.00,'2022-09-25 18:11:43','',''),(6350,'1','274','1',1,'Retail Sale Id 6180',18400.00,0.00,0.00,25.00,1650.00,'2022-09-25 18:20:00','',''),(6351,'1','274','1',1,'Return of Retail Sale Id 6174',0.00,73600.00,100.00,0.00,-6600.00,'2022-09-25 19:11:58','',''),(6352,'1','274','1',1,'Retail Sale Id 6181',38536.96,0.00,0.00,52.36,3455.76,'2022-09-25 19:13:14','',''),(6353,'1','274','1',1,'Retail Sale Id 6182',42121.28,0.00,0.00,57.23,3777.18,'2022-09-25 19:14:31','',''),(6354,'1','274','1',1,'Return of Retail Sale Id 6175',0.00,2252.16,3.06,0.00,-201.96,'2022-09-25 19:15:39','',''),(6355,'1','274','1',1,'Retail Sale Id 6183',2230.08,0.00,0.00,3.03,199.98,'2022-09-25 19:16:49','',''),(6356,'1','274','1',1,'Retail Sale Id 6184',5998.40,0.00,0.00,8.15,537.90,'2022-09-26 06:06:10','',''),(6357,'1','274','1',1,'Retail Sale Id 6185',9200.00,0.00,0.00,12.50,825.00,'2022-09-26 07:46:12','',''),(6358,'1','274','1',1,'Retail Sale Id 6186',1501.44,0.00,0.00,2.04,134.64,'2022-09-26 10:08:31','',''),(6359,'1','274','1',1,'Retail Sale Id 6187',46000.00,0.00,0.00,62.50,4125.00,'2022-09-26 10:09:55','',''),(6360,'1','274','1',1,'Retail Sale Id 6188',48318.40,0.00,0.00,65.65,4332.90,'2022-09-26 10:20:11','',''),(6361,'1','274','1',1,'Retail Sale Id 6189',6999.36,0.00,0.00,9.51,627.66,'2022-09-26 10:21:55','',''),(6362,'1','274','1',1,'Retail Sale Id 6190',6307.52,0.00,0.00,8.57,565.62,'2022-09-26 10:25:47','',''),(6363,'1','274','1',1,'Return of Retail Sale Id 6185',0.00,9200.00,12.50,0.00,-825.00,'2022-09-26 10:37:04','',''),(6364,'1','274','1',1,'Return of Retail Sale Id 6184',0.00,5998.40,8.15,0.00,-537.90,'2022-09-26 10:37:51','',''),(6365,'1','274','1',1,'Retail Sale Id 6191',2259.52,0.00,0.00,3.07,202.62,'2022-09-26 10:40:13','',''),(6366,'1','274','1',1,'Retail Sale Id 6192',5998.40,0.00,0.00,8.15,537.90,'2022-09-26 10:41:34','',''),(6367,'1','274','1',1,'Retail Sale Id 6193',3002.88,0.00,0.00,4.08,269.28,'2022-09-26 10:43:18','',''),(6368,'1','274','1',1,'Retail Sale Id 6194',1803.20,0.00,0.00,2.45,161.70,'2022-09-26 11:42:53','',''),(6369,'1','274','1',1,'Retail Sale Id 6195',2001.92,0.00,0.00,2.72,179.52,'2022-09-26 12:07:49','',''),(6370,'1','274','1',1,'Retail Sale Id 6196',3503.36,0.00,0.00,4.76,314.16,'2022-09-26 12:09:48','',''),(6371,'1','274','1',1,'Retail Sale Id 6197',2303.68,0.00,0.00,3.13,206.58,'2022-09-26 12:18:47','',''),(6372,'1','274','1',1,'Retail Sale Id 6198',4496.96,0.00,0.00,6.11,403.26,'2022-09-26 12:19:48','',''),(6373,'1','274','1',1,'Retail Sale Id 6199',9200.00,0.00,0.00,12.50,825.00,'2022-09-26 12:27:21','',''),(6374,'1','274','1',1,'Retail Sale Id 6200',11040.00,0.00,0.00,15.00,990.00,'2022-09-26 12:40:36','',''),(6375,'1','274','1',1,'Retail Sale Id 6201',9200.00,0.00,0.00,12.50,825.00,'2022-09-26 12:50:58','',''),(6376,'1','274','1',1,'Retail Sale Id 6202',2001.92,0.00,0.00,2.72,179.52,'2022-09-26 12:56:20','',''),(6377,'1','274','1',1,'Retail Sale Id 6203',2252.16,0.00,0.00,3.06,201.96,'2022-09-26 13:19:58','',''),(6378,'1','274','1',1,'Retail Sale Id 6204',1501.44,0.00,0.00,2.04,134.64,'2022-09-26 13:32:56','',''),(6379,'1','274','1',1,'Retail Sale Id 6205',1501.44,0.00,0.00,2.04,134.64,'2022-09-26 13:39:03','',''),(6380,'1','274','1',1,'Retail Sale Id 6206',3002.88,0.00,0.00,4.08,269.28,'2022-09-26 13:44:25','',''),(6381,'1','274','1',1,'Retail Sale Id 6207',3002.88,0.00,0.00,4.08,269.28,'2022-09-26 13:46:38','',''),(6382,'1','274','1',1,'Retail Sale Id 6208',3002.88,0.00,0.00,4.08,269.28,'2022-09-26 14:13:28','',''),(6383,'1','274','1',1,'Retail Sale Id 6210',9200.00,0.00,0.00,12.50,825.00,'2022-09-26 14:16:26','',''),(6384,'1','274','1',1,'Retail Sale Id 6211',4496.96,0.00,0.00,6.11,403.26,'2022-09-26 14:19:51','',''),(6385,'1','274','1',1,'Retail Sale Id 6212',1501.44,0.00,0.00,2.04,134.64,'2022-09-26 14:28:12','',''),(6386,'1','274','1',1,'Retail Sale Id 6213',2001.92,0.00,0.00,2.72,179.52,'2022-09-26 14:45:18','',''),(6387,'1','274','1',1,'Retail Sale Id 6215',9200.00,0.00,0.00,12.50,825.00,'2022-09-26 14:48:46','',''),(6388,'1','274','1',1,'Retail Sale Id 6216',4496.96,0.00,0.00,6.11,403.26,'2022-09-26 14:59:53','',''),(6389,'1','274','1',1,'Retail Sale Id 6217',3002.88,0.00,0.00,4.08,269.28,'2022-09-26 15:01:01','',''),(6390,'1','274','1',1,'Retail Sale Id 6218',2001.92,0.00,0.00,2.72,179.52,'2022-09-26 15:03:12','',''),(6391,'1','274','1',1,'Retail Sale Id 6219',1000.96,0.00,0.00,1.36,89.76,'2022-09-26 15:04:04','',''),(6392,'1','274','1',1,'Retail Sale Id 6220',2001.92,0.00,0.00,2.72,179.52,'2022-09-26 15:07:19','',''),(6393,'1','274','1',1,'Retail Sale Id 6221',9200.00,0.00,0.00,12.50,825.00,'2022-09-26 15:17:48','',''),(6394,'1','274','1',1,'Retail Sale Id 6222',1501.44,0.00,0.00,2.04,134.64,'2022-09-26 15:18:59','',''),(6395,'1','274','1',1,'Retail Sale Id 6223',17001.60,0.00,0.00,23.10,1524.60,'2022-09-26 15:20:03','',''),(6396,'1','274','1',1,'Retail Sale Id 6224',9200.00,0.00,0.00,12.50,825.00,'2022-09-26 15:22:37','',''),(6397,'1','274','1',1,'Retail Sale Id 6225',2001.92,0.00,0.00,2.72,179.52,'2022-09-26 15:27:14','',''),(6398,'1','274','1',1,'Retail Sale Id 6226',14499.20,0.00,0.00,19.70,1300.20,'2022-09-26 15:30:51','',''),(6399,'1','274','1',1,'Retail Sale Id 6227',4997.44,0.00,0.00,6.79,448.14,'2022-09-26 15:43:13','',''),(6400,'1','274','1',1,'Retail Sale Id 6228',1199.68,0.00,0.00,1.63,107.58,'2022-09-26 15:44:31','',''),(6401,'1','274','1',1,'Retail Sale Id 6229',1501.44,0.00,0.00,2.04,134.64,'2022-09-26 15:49:19','',''),(6402,'1','274','1',1,'Retail Sale Id 6230',1000.96,0.00,0.00,1.36,89.76,'2022-09-26 15:56:49','',''),(6403,'1','274','1',1,'Retail Sale Id 6231',3702.08,0.00,0.00,5.03,331.98,'2022-09-26 16:21:46','',''),(6404,'1','274','1',1,'Retail Sale Id 6232',1501.44,0.00,0.00,2.04,134.64,'2022-09-26 16:28:27','',''),(6405,'1','274','1',1,'Retail Sale Id 6233',2303.68,0.00,0.00,3.13,206.58,'2022-09-26 16:30:30','',''),(6406,'1','274','1',1,'Retail Sale Id 6234',3996.48,0.00,0.00,5.43,358.38,'2022-09-26 16:33:57','',''),(6407,'1','274','1',1,'Retail Sale Id 6235',802.24,0.00,0.00,1.09,71.94,'2022-09-26 16:37:34','',''),(6408,'1','274','1',1,'Retail Sale Id 6236',2001.92,0.00,0.00,2.72,179.52,'2022-09-26 16:52:22','',''),(6409,'1','274','1',1,'Retail Sale Id 6237',9200.00,0.00,0.00,12.50,825.00,'2022-09-26 16:56:11','',''),(6410,'1','274','1',1,'Retail Sale Id 6237',9200.00,0.00,0.00,12.50,825.00,'2022-09-26 16:56:11','',''),(6411,'1','274','1',1,'Retail Sale Id 6238',9200.00,0.00,0.00,12.50,825.00,'2022-09-26 17:06:30','',''),(6412,'1','274','1',1,'Retail Sale Id 6239',1000.96,0.00,0.00,1.36,89.76,'2022-09-26 17:13:25','',''),(6413,'1','274','1',1,'Retail Sale Id 6240',9200.00,0.00,0.00,12.50,825.00,'2022-09-26 17:14:32','',''),(6414,'1','274','1',1,'Retail Sale Id 6241',4496.96,0.00,0.00,6.11,403.26,'2022-09-26 17:26:09','',''),(6415,'1','274','1',1,'Retail Sale Id 6242',9200.00,0.00,0.00,12.50,825.00,'2022-09-26 17:27:43','',''),(6416,'1','274','1',1,'Retail Sale Id 6243',6999.36,0.00,0.00,9.51,627.66,'2022-09-26 17:28:44','',''),(6417,'1','274','1',1,'Retail Sale Id 6244',1000.96,0.00,0.00,1.36,89.76,'2022-09-26 17:32:03','',''),(6418,'1','274','1',1,'Retail Sale Id 6245',1199.68,0.00,0.00,1.63,107.58,'2022-09-26 17:33:43','',''),(6419,'1','274','1',1,'Retail Sale Id 6246',9200.00,0.00,0.00,12.50,825.00,'2022-09-26 17:39:43','',''),(6420,'1','274','1',1,'Retail Sale Id 6247',5998.40,0.00,0.00,8.15,537.90,'2022-09-26 17:41:44','',''),(6421,'1','274','1',1,'Retail Sale Id 6248',29999.36,0.00,0.00,40.76,2690.16,'2022-09-26 17:53:10','',''),(6422,'1','274','1',1,'Retail Sale Id 6249',9200.00,0.00,0.00,12.50,825.00,'2022-09-26 17:56:33','',''),(6423,'1','274','1',1,'Retail Sale Id 6250',2252.16,0.00,0.00,3.06,201.96,'2022-09-26 17:57:48','',''),(6424,'1','274','1',1,'Retail Sale Id 6251',2252.16,0.00,0.00,3.06,201.96,'2022-09-26 18:00:36','',''),(6425,'1','274','1',1,'Retail Sale Id 6252',9200.00,0.00,0.00,12.50,825.00,'2022-09-26 18:05:48','',''),(6426,'1','274','1',1,'Retail Sale Id 6253',9568.00,0.00,0.00,13.00,858.00,'2022-09-26 18:06:47','',''),(6427,'1','274','1',1,'Retail Sale Id 6254',9568.00,0.00,0.00,13.00,858.00,'2022-09-26 18:08:03','',''),(6428,'1','274','1',1,'Retail Sale Id 6255',2502.40,0.00,0.00,3.40,224.40,'2022-09-26 18:10:40','',''),(6429,'1','274','1',1,'Retail Sale Id 6256',4496.96,0.00,0.00,6.11,403.26,'2022-09-26 18:23:22','',''),(6430,'1','274','1',1,'Retail Sale Id 6257',19231.68,0.00,0.00,26.13,1724.58,'2022-09-26 18:59:06','',''),(6431,'1','274','1',1,'Return of Retail Sale Id 6253',0.00,9568.00,13.00,0.00,-858.00,'2022-09-26 19:00:42','',''),(6432,'1','274','1',1,'Retail Sale Id 6258',6528.32,0.00,0.00,8.87,585.42,'2022-09-26 19:02:05','',''),(6433,'1','274','1',1,'Retail Sale Id 6259',4997.44,0.00,0.00,6.79,448.14,'2022-09-27 06:44:24','',''),(6434,'1','274','1',1,'Retail Sale Id 6260',3002.88,0.00,0.00,4.08,269.28,'2022-09-27 06:47:50','',''),(6435,'1','274','1',1,'Retail Sale Id 6261',2252.16,0.00,0.00,3.06,201.96,'2022-09-27 06:55:31','',''),(6436,'1','274','1',1,'Retail Sale Id 6262',2208.00,0.00,0.00,3.00,198.00,'2022-09-27 07:05:02','',''),(6437,'1','274','1',1,'Retail Sale Id 6263',2001.92,0.00,0.00,2.72,179.52,'2022-09-27 07:14:57','',''),(6438,'1','274','1',1,'Retail Sale Id 6264',18400.00,0.00,0.00,25.00,1650.00,'2022-09-27 07:32:40','',''),(6439,'1','274','1',1,'Return of Retail Sale Id 6264',0.00,18400.00,25.00,0.00,-1650.00,'2022-09-27 07:33:21','',''),(6440,'1','274','1',1,'Retail Sale Id 6265',25001.92,0.00,0.00,33.97,2242.02,'2022-09-27 07:34:22','',''),(6441,'1','274','1',1,'Retail Sale Id 6266',16302.40,0.00,0.00,22.15,1461.90,'2022-09-27 07:41:55','',''),(6442,'1','274','1',1,'Retail Sale Id 6267',1501.44,0.00,0.00,2.04,134.64,'2022-09-27 07:48:07','',''),(6443,'1','274','1',1,'Retail Sale Id 6268',6999.36,0.00,0.00,9.51,627.66,'2022-09-27 07:52:15','',''),(6444,'1','274','1',1,'Retail Sale Id 6270',1000.96,0.00,0.00,1.36,89.76,'2022-09-27 07:54:00','',''),(6445,'1','274','1',1,'Retail Sale Id 6271',9200.00,0.00,0.00,12.50,825.00,'2022-09-27 07:57:27','',''),(6446,'1','274','1',1,'Retail Sale Id 6272',2001.92,0.00,0.00,2.72,179.52,'2022-09-27 08:05:34','',''),(6447,'1','274','1',1,'Retail Sale Id 6273',5998.40,0.00,0.00,8.15,537.90,'2022-09-27 08:14:36','',''),(6448,'1','274','1',1,'Retail Sale Id 6274',22080.00,0.00,0.00,30.00,1980.00,'2022-09-27 08:16:20','',''),(6449,'1','274','1',1,'Retail Sale Id 6275',9200.00,0.00,0.00,12.50,825.00,'2022-09-27 08:44:29','',''),(6450,'1','274','1',1,'Retail Sale Id 6276',2208.00,0.00,0.00,3.00,198.00,'2022-09-27 08:48:29','',''),(6451,'1','274','1',1,'Retail Sale Id 6277',14800.96,0.00,0.00,20.11,1327.26,'2022-09-27 09:06:02','',''),(6452,'1','274','1',1,'Retail Sale Id 6278',4496.96,0.00,0.00,6.11,403.26,'2022-09-27 09:29:36','',''),(6453,'1','274','1',1,'Retail Sale Id 6279',2208.00,0.00,0.00,3.00,198.00,'2022-09-27 09:33:24','',''),(6454,'1','274','1',1,'Retail Sale Id 6280',9200.00,0.00,0.00,12.50,825.00,'2022-09-27 09:34:47','',''),(6455,'1','274','1',1,'Retail Sale Id 6281',3002.88,0.00,0.00,4.08,269.28,'2022-09-27 09:42:20','',''),(6456,'1','274','1',1,'Retail Sale Id 6282',9200.00,0.00,0.00,12.50,825.00,'2022-09-27 09:54:12','',''),(6457,'1','274','1',1,'Retail Sale Id 6283',4997.44,0.00,0.00,6.79,448.14,'2022-09-27 09:59:59','',''),(6458,'1','274','1',1,'Retail Sale Id 6284',2001.92,0.00,0.00,2.72,179.52,'2022-09-27 10:20:52','',''),(6459,'1','274','1',1,'Retail Sale Id 6285',147200.00,0.00,0.00,200.00,13200.00,'2022-09-27 11:00:19','',''),(6460,'1','274','1',1,'Retail Sale Id 6286',18400.00,0.00,0.00,25.00,1650.00,'2022-09-27 12:21:05','',''),(6461,'1','274','1',1,'Retail Sale Id 6287',9200.00,0.00,0.00,12.50,825.00,'2022-09-27 12:31:07','',''),(6462,'1','274','1',1,'Retail Sale Id 6288',9200.00,0.00,0.00,12.50,825.00,'2022-09-27 12:47:56','',''),(6463,'1','274','1',1,'Retail Sale Id 6289',11503.68,0.00,0.00,15.63,1031.58,'2022-09-27 12:55:39','',''),(6464,'1','274','1',1,'Retail Sale Id 6290',3002.88,0.00,0.00,4.08,269.28,'2022-09-27 13:05:03','',''),(6465,'1','274','1',1,'Retail Sale Id 6291',1000.96,0.00,0.00,1.36,89.76,'2022-09-27 13:19:47','',''),(6466,'1','274','1',1,'Retail Sale Id 6292',3996.48,0.00,0.00,5.43,358.38,'2022-09-27 13:23:43','',''),(6467,'1','274','1',1,'Retail Sale Id 6293',18400.00,0.00,0.00,25.00,1650.00,'2022-09-27 13:33:51','',''),(6468,'1','274','1',1,'Retail Sale Id 6294',1000.96,0.00,0.00,1.36,89.76,'2022-09-27 14:21:05','',''),(6469,'1','274','1',1,'Retail Sale Id 6295',4496.96,0.00,0.00,6.11,403.26,'2022-09-27 14:23:02','',''),(6470,'1','274','1',1,'Retail Sale Id 6296',1803.20,0.00,0.00,2.45,161.70,'2022-09-27 15:02:28','',''),(6471,'1','274','1',1,'Retail Sale Id 6297',18032.00,0.00,0.00,24.50,1617.00,'2022-09-27 15:16:26','',''),(6472,'1','274','1',1,'Retail Sale Id 6298',3996.48,0.00,0.00,5.43,358.38,'2022-09-27 15:51:15','',''),(6473,'1','274','1',1,'Retail Sale Id 6299',2252.16,0.00,0.00,3.06,201.96,'2022-09-27 15:59:52','',''),(6474,'1','274','1',1,'Retail Sale Id 6300',9200.00,0.00,0.00,12.50,825.00,'2022-09-27 16:12:31','',''),(6475,'1','274','1',1,'Retail Sale Id 6301',1898.88,0.00,0.00,2.58,170.28,'2022-09-27 16:18:07','',''),(6476,'1','274','1',1,'Retail Sale Id 6302',9200.00,0.00,0.00,12.50,825.00,'2022-09-27 16:19:02','',''),(6477,'1','274','1',1,'Retail Sale Id 6303',2001.92,0.00,0.00,2.72,179.52,'2022-09-27 16:24:43','',''),(6478,'1','274','1',1,'Retail Sale Id 6304',1501.44,0.00,0.00,2.04,134.64,'2022-09-27 16:32:04','',''),(6479,'1','274','1',1,'Retail Sale Id 6305',3002.88,0.00,0.00,4.08,269.28,'2022-09-27 16:37:33','',''),(6480,'1','274','1',1,'Retail Sale Id 6306',2502.40,0.00,0.00,3.40,224.40,'2022-09-27 16:38:43','',''),(6481,'1','274','1',1,'Retail Sale Id 6307',2502.40,0.00,0.00,3.40,224.40,'2022-09-27 16:40:25','',''),(6482,'1','274','1',1,'Retail Sale Id 6308',3996.48,0.00,0.00,5.43,358.38,'2022-09-27 16:43:03','',''),(6483,'1','274','1',1,'Retail Sale Id 6309',3996.48,0.00,0.00,5.43,358.38,'2022-09-27 16:44:54','',''),(6484,'1','274','1',1,'Retail Sale Id 6310',9200.00,0.00,0.00,12.50,825.00,'2022-09-27 16:50:44','',''),(6485,'1','274','1',1,'Retail Sale Id 6311',9200.00,0.00,0.00,12.50,825.00,'2022-09-27 16:55:07','',''),(6486,'1','274','1',1,'Retail Sale Id 6312',1803.20,0.00,0.00,2.45,161.70,'2022-09-27 16:56:22','',''),(6487,'1','274','1',1,'Retail Sale Id 6313',2001.92,0.00,0.00,2.72,179.52,'2022-09-27 16:58:28','',''),(6488,'1','274','1',1,'Retail Sale Id 6314',2001.92,0.00,0.00,2.72,179.52,'2022-09-27 17:05:01','',''),(6489,'1','274','1',1,'Retail Sale Id 6315',2230.08,0.00,0.00,3.03,199.98,'2022-09-27 17:15:56','',''),(6490,'1','274','1',1,'Retail Sale Id 6316',9200.00,0.00,0.00,12.50,825.00,'2022-09-27 17:19:44','',''),(6491,'1','274','1',1,'Retail Sale Id 6317',4423.36,0.00,0.00,6.01,396.66,'2022-09-27 17:51:33','',''),(6492,'1','274','1',1,'Return of Retail Sale Id 6297',0.00,18032.00,24.50,0.00,-1617.00,'2022-09-27 17:53:23','',''),(6493,'1','274','1',1,'Return of Retail Sale Id 6313',0.00,2001.92,2.72,0.00,-179.52,'2022-09-27 17:54:18','',''),(6494,'1','274','1',1,'Return of Retail Sale Id 6274',0.00,22080.00,30.00,0.00,-1980.00,'2022-09-27 18:02:17','',''),(6495,'1','274','1',1,'Retail Sale Id 6318',37977.60,0.00,0.00,51.60,3405.60,'2022-09-27 18:03:42','',''),(6496,'1','274','1',1,'Retail Sale Id 6319',4136.32,0.00,0.00,5.62,370.92,'2022-09-27 18:04:47','',''),(6497,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,14492.10,21.63,0.00,0.00,'2022-09-27 18:09:51','',''),(6498,'1','274',NULL,1,'Reception corrector for bridging 54',0.00,0.00,0.00,21.63,0.00,'2022-09-27 18:10:55','',''),(6499,'1','274','1',1,'Received from bridging 54',0.00,0.00,21.63,0.00,0.00,'2022-09-27 18:10:55','',''),(6500,'1','274','1',1,'Retail Sale Id 6320',15919.68,0.00,0.00,21.63,1427.58,'2022-09-27 18:11:25','',''),(6501,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,670000.00,1000.00,0.00,0.00,'2022-09-28 06:38:31','',''),(6502,'1','274',NULL,1,'Reception corrector for bridging 55',0.00,0.00,0.00,1000.00,0.00,'2022-09-28 06:39:35','',''),(6503,'1','274','1',1,'Received from bridging 55',0.00,0.00,1000.00,0.00,0.00,'2022-09-28 06:39:35','',''),(6504,'1','274','1',1,'Retail Sale Id 6321',13270.08,0.00,0.00,18.03,1189.98,'2022-09-28 06:40:43','',''),(6505,'1','274','1',1,'Retail Sale Id 6322',500.48,0.00,0.00,0.68,44.88,'2022-09-28 06:41:50','',''),(6506,'1','274','1',1,'Retail Sale Id 6323',7499.84,0.00,0.00,10.19,672.54,'2022-09-28 07:12:36','',''),(6507,'1','274','1',1,'Retail Sale Id 6324',1000.96,0.00,0.00,1.36,89.76,'2022-09-28 07:13:25','',''),(6508,'1','274','1',1,'Retail Sale Id 6325',18400.00,0.00,0.00,25.00,1650.00,'2022-09-28 07:14:45','',''),(6509,'1','274','1',1,'Retail Sale Id 6326',10002.24,0.00,0.00,13.59,896.94,'2022-09-28 07:23:56','',''),(6510,'1','274','1',1,'Retail Sale Id 6327',16199.36,0.00,0.00,22.01,1452.66,'2022-09-28 07:27:06','',''),(6511,'1','274','1',1,'Retail Sale Id 6328',1000.96,0.00,0.00,1.36,89.76,'2022-09-28 07:29:03','',''),(6512,'1','274','1',1,'Retail Sale Id 6329',1501.44,0.00,0.00,2.04,134.64,'2022-09-28 07:34:00','',''),(6513,'1','274','1',1,'Retail Sale Id 6330',3996.48,0.00,0.00,5.43,358.38,'2022-09-28 07:38:44','',''),(6514,'1','274','1',1,'Retail Sale Id 6331',6999.36,0.00,0.00,9.51,627.66,'2022-09-28 07:40:42','',''),(6515,'1','274','1',1,'Retail Sale Id 6332',500.48,0.00,0.00,0.68,44.88,'2022-09-28 07:41:46','',''),(6516,'1','274','1',1,'Retail Sale Id 6333',2001.92,0.00,0.00,2.72,179.52,'2022-09-28 07:55:41','',''),(6517,'1','274','1',1,'Retail Sale Id 6334',4496.96,0.00,0.00,6.11,403.26,'2022-09-28 07:56:38','',''),(6518,'1','274','1',1,'Retail Sale Id 6335',9200.00,0.00,0.00,12.50,825.00,'2022-09-28 07:59:21','',''),(6519,'1','274','1',1,'Retail Sale Id 6336',17664.00,0.00,0.00,24.00,1584.00,'2022-09-28 08:13:39','',''),(6520,'1','274','1',1,'Retail Sale Id 6337',1501.44,0.00,0.00,2.04,134.64,'2022-09-28 08:15:44','',''),(6521,'1','274','1',1,'Retail Sale Id 6339',26797.76,0.00,0.00,36.41,2403.06,'2022-09-28 08:18:30','',''),(6522,'1','274','1',1,'Retail Sale Id 6340',17700.80,0.00,0.00,24.05,1587.30,'2022-09-28 08:19:39','',''),(6523,'1','274','1',1,'Retail Sale Id 6341',2303.68,0.00,0.00,3.13,206.58,'2022-09-28 08:20:30','',''),(6524,'1','274','1',1,'Retail Sale Id 6342',9200.00,0.00,0.00,12.50,825.00,'2022-09-28 08:25:37','',''),(6525,'1','274','1',1,'Retail Sale Id 6343',9200.00,0.00,0.00,12.50,825.00,'2022-09-28 08:32:11','',''),(6526,'1','274','1',1,'Retail Sale Id 6344',9200.00,0.00,0.00,12.50,825.00,'2022-09-28 08:37:18','',''),(6527,'1','274','1',1,'Retail Sale Id 6347',2001.92,0.00,0.00,2.72,179.52,'2022-09-28 08:40:02','',''),(6528,'1','274','1',1,'Retail Sale Id 6349',3002.88,0.00,0.00,4.08,269.28,'2022-09-28 08:52:04','',''),(6529,'1','274','1',1,'Retail Sale Id 6351',7360.00,0.00,0.00,10.00,660.00,'2022-09-28 09:01:11','',''),(6530,'1','274','1',1,'Retail Sale Id 6351',18400.00,0.00,0.00,25.00,1650.00,'2022-09-28 09:01:11','',''),(6531,'1','274','1',1,'Retail Sale Id 6352',1000.96,0.00,0.00,1.36,89.76,'2022-09-28 09:16:02','',''),(6532,'1','274','1',1,'Retail Sale Id 6353',1000.96,0.00,0.00,1.36,89.76,'2022-09-28 09:16:42','',''),(6533,'1','274','1',1,'Retail Sale Id 6354',22080.00,0.00,0.00,30.00,1980.00,'2022-09-28 09:18:00','',''),(6534,'1','274','1',1,'Retail Sale Id 6355',2001.92,0.00,0.00,2.72,179.52,'2022-09-28 09:24:18','',''),(6535,'1','274','1',1,'Retail Sale Id 6356',750.72,0.00,0.00,1.02,67.32,'2022-09-28 09:29:33','',''),(6536,'1','274','1',1,'Retail Sale Id 6356',4452.80,0.00,0.00,6.05,399.30,'2022-09-28 09:29:33','',''),(6537,'1','274','1',1,'Retail Sale Id 6357',9200.00,0.00,0.00,12.50,825.00,'2022-09-28 09:37:53','',''),(6538,'1','274','1',1,'Retail Sale Id 6358',2001.92,0.00,0.00,2.72,179.52,'2022-09-28 10:35:06','',''),(6539,'1','274','1',1,'Retail Sale Id 6359',1000.96,0.00,0.00,1.36,89.76,'2022-09-28 10:37:53','',''),(6540,'1','274','1',1,'Retail Sale Id 6360',9200.00,0.00,0.00,12.50,825.00,'2022-09-28 10:41:14','',''),(6541,'1','274','1',1,'Retail Sale Id 6361',3996.48,0.00,0.00,5.43,358.38,'2022-09-28 10:42:08','',''),(6542,'1','274','1',1,'Retail Sale Id 6362',4496.96,0.00,0.00,6.11,403.26,'2022-09-28 10:48:33','',''),(6543,'1','274','1',1,'Retail Sale Id 6363',9553.28,0.00,0.00,12.98,856.68,'2022-09-28 11:12:57','',''),(6544,'1','274','1',1,'Retail Sale Id 6364',4496.96,0.00,0.00,6.11,403.26,'2022-09-28 11:19:40','',''),(6545,'1','274','1',1,'Retail Sale Id 6364',9200.00,0.00,0.00,12.50,825.00,'2022-09-28 11:19:40','',''),(6546,'1','274','1',1,'Retail Sale Id 6366',1000.96,0.00,0.00,1.36,89.76,'2022-09-28 11:23:57','',''),(6547,'1','274','1',1,'Retail Sale Id 6367',8000.32,0.00,0.00,10.87,717.42,'2022-09-28 11:42:49','',''),(6548,'1','274','1',1,'Retail Sale Id 6368',9200.00,0.00,0.00,12.50,825.00,'2022-09-28 12:12:53','',''),(6549,'1','274','1',1,'Retail Sale Id 6369',5152.00,0.00,0.00,7.00,462.00,'2022-09-28 12:27:03','',''),(6550,'1','274','1',1,'Retail Sale Id 6370',1501.44,0.00,0.00,2.04,134.64,'2022-09-28 12:37:44','',''),(6551,'1','274','1',1,'Retail Sale Id 6371',3702.08,0.00,0.00,5.03,331.98,'2022-09-28 12:52:27','',''),(6552,'1','274','1',1,'Retail Sale Id 6372',8000.32,0.00,0.00,10.87,717.42,'2022-09-28 13:00:01','',''),(6553,'1','274','1',1,'Retail Sale Id 6373',2001.92,0.00,0.00,2.72,179.52,'2022-09-28 13:31:15','',''),(6554,'1','274','1',1,'Retail Sale Id 6374',3996.48,0.00,0.00,5.43,358.38,'2022-09-28 14:11:10','',''),(6555,'1','274','1',1,'Retail Sale Id 6374',9200.00,0.00,0.00,12.50,825.00,'2022-09-28 14:11:10','',''),(6556,'1','274','1',1,'Retail Sale Id 6375',1501.44,0.00,0.00,2.04,134.64,'2022-09-28 14:19:57','',''),(6557,'1','274','1',1,'Retail Sale Id 6376',3996.48,0.00,0.00,5.43,358.38,'2022-09-28 14:30:33','',''),(6558,'1','274','1',1,'Retail Sale Id 6377',3002.88,0.00,0.00,4.08,269.28,'2022-09-28 14:31:24','',''),(6559,'1','274','1',1,'Retail Sale Id 6378',73600.00,0.00,0.00,100.00,6600.00,'2022-09-28 14:58:52','',''),(6560,'1','274','1',1,'Retail Sale Id 6379',11098.88,0.00,0.00,15.08,995.28,'2022-09-28 15:07:40','',''),(6561,'1','274','1',1,'Retail Sale Id 6380',3680.00,0.00,0.00,5.00,330.00,'2022-09-28 15:48:29','',''),(6562,'1','274','1',1,'Retail Sale Id 6381',2303.68,0.00,0.00,3.13,206.58,'2022-09-28 15:50:51','',''),(6563,'1','274','1',1,'Retail Sale Id 6382',9200.00,0.00,0.00,12.50,825.00,'2022-09-28 15:51:50','',''),(6564,'1','274','1',1,'Retail Sale Id 6383',9200.00,0.00,0.00,12.50,825.00,'2022-09-28 15:59:15','',''),(6565,'1','274','1',1,'Retail Sale Id 6384',1501.44,0.00,0.00,2.04,134.64,'2022-09-28 16:18:03','',''),(6566,'1','274','1',1,'Retail Sale Id 6385',3002.88,0.00,0.00,4.08,269.28,'2022-09-28 16:21:56','',''),(6567,'1','274','1',1,'Return of Retail Sale Id 6378',0.00,73600.00,100.00,0.00,-6600.00,'2022-09-28 16:22:58','',''),(6568,'1','274','1',1,'Retail Sale Id 6386',69184.00,0.00,0.00,94.00,6204.00,'2022-09-28 16:24:02','',''),(6569,'1','274','1',1,'Retail Sale Id 6387',26275.20,0.00,0.00,35.70,2356.20,'2022-09-28 16:25:33','',''),(6570,'1','274','1',1,'Retail Sale Id 6388',19106.56,0.00,0.00,25.96,1713.36,'2022-09-28 16:27:48','',''),(6571,'1','274','1',1,'Retail Sale Id 6389',8464.00,0.00,0.00,11.50,759.00,'2022-09-28 16:29:54','',''),(6572,'1','274','1',1,'Retail Sale Id 6389',40480.00,0.00,0.00,55.00,3630.00,'2022-09-28 16:29:54','',''),(6573,'1','274','1',1,'Retail Sale Id 6391',3002.88,0.00,0.00,4.08,269.28,'2022-09-28 16:37:52','',''),(6574,'1','274','1',1,'Retail Sale Id 6392',3503.36,0.00,0.00,4.76,314.16,'2022-09-28 16:42:03','',''),(6575,'1','274','1',1,'Retail Sale Id 6393',1501.44,0.00,0.00,2.04,134.64,'2022-09-28 17:07:08','',''),(6576,'1','274','1',1,'Retail Sale Id 6394',3996.48,0.00,0.00,5.43,358.38,'2022-09-28 17:08:50','',''),(6577,'1','274','1',1,'Retail Sale Id 6394',7396.80,0.00,0.00,10.05,663.30,'2022-09-28 17:08:50','',''),(6578,'1','274','1',1,'Retail Sale Id 6395',5946.88,0.00,0.00,8.08,533.28,'2022-09-28 17:10:51','',''),(6579,'1','274','1',1,'Retail Sale Id 6395',9200.00,0.00,0.00,12.50,825.00,'2022-09-28 17:10:51','',''),(6580,'1','274','1',1,'Retail Sale Id 6396',18400.00,0.00,0.00,25.00,1650.00,'2022-09-28 17:13:24','',''),(6581,'1','274','1',1,'Retail Sale Id 6397',9200.00,0.00,0.00,12.50,825.00,'2022-09-28 17:21:12','',''),(6582,'1','274','1',1,'Retail Sale Id 6398',1501.44,0.00,0.00,2.04,134.64,'2022-09-28 17:27:45','',''),(6583,'1','274','1',1,'Retail Sale Id 6399',18400.00,0.00,0.00,25.00,1650.00,'2022-09-28 17:29:48','',''),(6584,'1','274','1',1,'Retail Sale Id 6400',1501.44,0.00,0.00,2.04,134.64,'2022-09-28 17:37:44','',''),(6585,'1','274','1',1,'Retail Sale Id 6401',9597.44,0.00,0.00,13.04,860.64,'2022-09-28 17:55:25','',''),(6586,'1','274','1',1,'Retail Sale Id 6402',1000.96,0.00,0.00,1.36,89.76,'2022-09-28 17:57:22','',''),(6587,'1','274','1',1,'Retail Sale Id 6403',2252.16,0.00,0.00,3.06,201.96,'2022-09-28 18:03:29','',''),(6588,'1','274','1',1,'Retail Sale Id 6404',2001.92,0.00,0.00,2.72,179.52,'2022-09-28 18:04:58','',''),(6589,'1','274','1',1,'Retail Sale Id 6405',1501.44,0.00,0.00,2.04,134.64,'2022-09-28 18:06:51','',''),(6590,'1','274','1',1,'Retail Sale Id 6406',4048.00,0.00,0.00,5.50,363.00,'2022-09-28 18:08:21','',''),(6591,'1','274','1',1,'Retail Sale Id 6407',9200.00,0.00,0.00,12.50,825.00,'2022-09-28 18:25:22','',''),(6592,'1','274','1',1,'Retail Sale Id 6408',10112.64,0.00,0.00,13.74,906.84,'2022-09-28 18:57:56','',''),(6593,'1','274','1',1,'Return of Retail Sale Id 6407',0.00,9200.00,12.50,0.00,-825.00,'2022-09-28 19:01:49','',''),(6594,'1','274','1',1,'Return of Retail Sale Id 6408',0.00,10112.64,13.74,0.00,-906.84,'2022-09-28 19:03:52','',''),(6595,'1','274','1',1,'Retail Sale Id 6409',22904.32,0.00,0.00,31.12,2053.92,'2022-09-28 19:04:58','',''),(6596,'1','274','1',1,'Return of Retail Sale Id 6406',0.00,4048.00,5.50,0.00,-363.00,'2022-09-28 19:14:31','',''),(6597,'1','274','1',1,'Retail Sale Id 6410',3135.36,0.00,0.00,4.26,281.16,'2022-09-28 19:17:19','',''),(6598,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,2793900.00,4170.00,0.00,0.00,'2022-09-29 06:26:53','',''),(6599,'1','274',NULL,1,'Reception corrector for bridging 56',0.00,0.00,0.00,4170.00,0.00,'2022-09-29 06:27:54','',''),(6600,'1','274','1',1,'Received from bridging 56',0.00,0.00,4170.00,0.00,0.00,'2022-09-29 06:27:54','',''),(6601,'1','274','1',1,'Retail Sale Id 6411',9200.00,0.00,0.00,12.50,825.00,'2022-09-29 07:00:15','',''),(6602,'1','274','1',1,'Retail Sale Id 6412',3680.00,0.00,0.00,5.00,330.00,'2022-09-29 07:00:50','',''),(6603,'1','274','1',1,'Retail Sale Id 6413',9200.00,0.00,0.00,12.50,825.00,'2022-09-29 10:29:16','',''),(6604,'1','274','1',1,'Retail Sale Id 6414',1501.44,0.00,0.00,2.04,134.64,'2022-09-29 10:43:21','',''),(6605,'1','274','1',1,'Retail Sale Id 6415',2502.40,0.00,0.00,3.40,224.40,'2022-09-29 10:44:45','',''),(6606,'1','274','1',1,'Retail Sale Id 6416',152926.08,0.00,0.00,207.78,13713.48,'2022-09-29 10:53:03','',''),(6607,'1','274','1',1,'Retail Sale Id 6417',39272.96,0.00,0.00,53.36,3521.76,'2022-09-29 10:53:54','',''),(6608,'1','274','1',1,'Return of Retail Sale Id 6413',0.00,9200.00,12.50,0.00,-825.00,'2022-09-29 10:55:39','',''),(6609,'1','274','1',1,'Retail Sale Id 6418',3702.08,0.00,0.00,5.03,331.98,'2022-09-29 10:56:28','',''),(6610,'1','274','1',1,'Retail Sale Id 6419',2303.68,0.00,0.00,3.13,206.58,'2022-09-29 11:04:15','',''),(6611,'1','274','1',1,'Return of Retail Sale Id 6411',0.00,9200.00,12.50,0.00,-825.00,'2022-09-29 11:06:23','',''),(6612,'1','274','1',1,'Retail Sale Id 6420',9200.00,0.00,0.00,12.50,825.00,'2022-09-29 11:06:57','',''),(6613,'1','274','1',1,'Retail Sale Id 6421',9200.00,0.00,0.00,12.50,825.00,'2022-09-29 11:26:01','',''),(6614,'1','274','1',1,'Retail Sale Id 6422',2001.92,0.00,0.00,2.72,179.52,'2022-09-29 11:38:02','',''),(6615,'1','274','1',1,'Retail Sale Id 6422',2001.92,0.00,0.00,2.72,179.52,'2022-09-29 11:38:02','',''),(6616,'1','274','1',1,'Retail Sale Id 6423',1597.12,0.00,0.00,2.17,143.22,'2022-09-29 11:48:23','',''),(6617,'1','274','1',1,'Retail Sale Id 6424',36800.00,0.00,0.00,50.00,3300.00,'2022-09-29 11:54:51','',''),(6618,'1','274','1',1,'Retail Sale Id 6425',2001.92,0.00,0.00,2.72,179.52,'2022-09-29 12:25:23','',''),(6619,'1','274','1',1,'Retail Sale Id 6426',1302.72,0.00,0.00,1.77,116.82,'2022-09-29 12:26:22','',''),(6620,'1','274','1',1,'Retail Sale Id 6427',4997.44,0.00,0.00,6.79,448.14,'2022-09-29 12:54:53','',''),(6621,'1','274','1',1,'Retail Sale Id 6428',3002.88,0.00,0.00,4.08,269.28,'2022-09-29 13:49:56','',''),(6622,'1','274','1',1,'Retail Sale Id 6428',4452.80,0.00,0.00,6.05,399.30,'2022-09-29 13:49:56','',''),(6623,'1','274','1',1,'Retail Sale Id 6429',4997.44,0.00,0.00,6.79,448.14,'2022-09-29 14:06:17','',''),(6624,'1','274','1',1,'Retail Sale Id 6430',9200.00,0.00,0.00,12.50,825.00,'2022-09-29 14:20:05','',''),(6625,'1','274','1',1,'Retail Sale Id 6430',9200.00,0.00,0.00,12.50,825.00,'2022-09-29 14:20:05','',''),(6626,'1','274','1',1,'Return of Retail Sale Id 6430',0.00,9200.00,12.50,0.00,-825.00,'2022-09-29 14:22:00','',''),(6627,'1','274','1',1,'Return of Retail Sale Id 6430',0.00,9200.00,12.50,0.00,-825.00,'2022-09-29 14:22:00','',''),(6628,'1','274','1',1,'Retail Sale Id 6431',9200.00,0.00,0.00,12.50,825.00,'2022-09-29 14:22:28','',''),(6629,'1','274','1',1,'Retail Sale Id 6432',2001.92,0.00,0.00,2.72,179.52,'2022-09-29 14:24:17','',''),(6630,'1','274','1',1,'Retail Sale Id 6433',2001.92,0.00,0.00,2.72,179.52,'2022-09-29 14:33:11','',''),(6631,'1','274','1',1,'Retail Sale Id 6434',9200.00,0.00,0.00,12.50,825.00,'2022-09-29 14:35:17','',''),(6632,'1','274','1',1,'Retail Sale Id 6436',9200.00,0.00,0.00,12.50,825.00,'2022-09-29 14:45:15','',''),(6633,'1','274','1',1,'Retail Sale Id 6438',7396.80,0.00,0.00,10.05,663.30,'2022-09-29 14:50:01','',''),(6634,'1','274','1',1,'Retail Sale Id 6439',9200.00,0.00,0.00,12.50,825.00,'2022-09-29 14:53:13','',''),(6635,'1','274','1',1,'Retail Sale Id 6440',9200.00,0.00,0.00,12.50,825.00,'2022-09-29 14:55:54','',''),(6636,'1','274','1',1,'Retail Sale Id 6441',9200.00,0.00,0.00,12.50,825.00,'2022-09-29 15:28:17','',''),(6637,'1','274','1',1,'Retail Sale Id 6442',9200.00,0.00,0.00,12.50,825.00,'2022-09-29 15:36:44','',''),(6638,'1','274','1',1,'Retail Sale Id 6443',3503.36,0.00,0.00,4.76,314.16,'2022-09-29 15:50:53','',''),(6639,'1','274','1',1,'Retail Sale Id 6444',9200.00,0.00,0.00,12.50,825.00,'2022-09-29 15:52:23','',''),(6640,'1','274','1',1,'Retail Sale Id 6445',9200.00,0.00,0.00,12.50,825.00,'2022-09-29 17:26:37','',''),(6641,'1','274','1',1,'Retail Sale Id 6446',3002.88,0.00,0.00,4.08,269.28,'2022-09-29 17:42:24','',''),(6642,'1','274','1',1,'Retail Sale Id 6447',88916.16,0.00,0.00,120.81,7973.46,'2022-09-29 17:47:36','',''),(6643,'1','274','1',1,'Retail Sale Id 6448',63119.36,0.00,0.00,85.76,5660.16,'2022-09-29 17:48:18','',''),(6644,'1','274','1',1,'Return of Retail Sale Id 6448',0.00,63119.36,85.76,0.00,-5660.16,'2022-09-29 17:51:08','',''),(6645,'1','274','1',1,'Retail Sale Id 6449',2502.40,0.00,0.00,3.40,224.40,'2022-09-29 17:52:20','',''),(6646,'1','274','1',1,'Return of Retail Sale Id 6438',0.00,7396.80,10.05,0.00,-663.30,'2022-09-29 17:55:59','',''),(6647,'1','274','1',1,'Retail Sale Id 6450',1000.96,0.00,0.00,1.36,89.76,'2022-09-29 17:59:21','',''),(6648,'1','274','1',1,'Retail Sale Id 6451',2252.16,0.00,0.00,3.06,201.96,'2022-09-29 18:03:40','',''),(6649,'1','274','1',1,'Retail Sale Id 6452',4997.44,0.00,0.00,6.79,448.14,'2022-09-29 18:07:46','',''),(6650,'1','274','1',1,'Retail Sale Id 6453',21770.88,0.00,0.00,29.58,1952.28,'2022-09-29 18:22:39','',''),(6651,'1','274','1',1,'Return of Retail Sale Id 6453',0.00,21770.88,29.58,0.00,-1952.28,'2022-09-29 18:52:17','',''),(6652,'1','274','1',1,'Return of Retail Sale Id 6452',0.00,4997.44,6.79,0.00,-448.14,'2022-09-29 18:52:47','',''),(6653,'1','274','1',1,'Return of Retail Sale Id 6451',0.00,2252.16,3.06,0.00,-201.96,'2022-09-29 18:54:15','',''),(6654,'1','274','1',1,'Return of Retail Sale Id 6424',0.00,36800.00,50.00,0.00,-3300.00,'2022-09-29 18:59:00','',''),(6655,'1','274','1',1,'Retail Sale Id 6454',12144.00,0.00,0.00,16.50,1089.00,'2022-09-29 19:01:00','',''),(6656,'1','274','1',1,'Retail Sale Id 6456',31935.04,0.00,0.00,43.39,2863.74,'2022-09-29 19:02:52','',''),(6657,'1','274','1',1,'Retail Sale Id 6457',9200.00,0.00,0.00,12.50,825.00,'2022-09-30 06:18:25','',''),(6658,'1','274','1',1,'Retail Sale Id 6458',1000.96,0.00,0.00,1.36,89.76,'2022-09-30 06:59:44','',''),(6659,'1','274','1',1,'Retail Sale Id 6459',1501.44,0.00,0.00,2.04,134.64,'2022-09-30 07:04:08','',''),(6660,'1','274','1',1,'Retail Sale Id 6460',3996.48,0.00,0.00,5.43,358.38,'2022-09-30 07:11:52','',''),(6661,'1','274','1',1,'Retail Sale Id 6461',4452.80,0.00,0.00,6.05,399.30,'2022-09-30 07:14:01','',''),(6662,'1','274','1',1,'Retail Sale Id 6462',2252.16,0.00,0.00,3.06,201.96,'2022-09-30 07:15:16','',''),(6663,'1','274','1',1,'Retail Sale Id 6463',1501.44,0.00,0.00,2.04,134.64,'2022-09-30 07:16:31','',''),(6664,'1','274','1',1,'Retail Sale Id 6464',39000.64,0.00,0.00,52.99,3497.34,'2022-09-30 07:19:12','',''),(6665,'1','274','1',1,'Retail Sale Id 6465',3702.08,0.00,0.00,5.03,331.98,'2022-09-30 07:19:59','',''),(6666,'1','274','1',1,'Retail Sale Id 6466',3996.48,0.00,0.00,5.43,358.38,'2022-09-30 07:32:50','',''),(6667,'1','274','1',1,'Retail Sale Id 6467',4416.00,0.00,0.00,6.00,396.00,'2022-09-30 07:46:57','',''),(6668,'1','274','1',1,'Retail Sale Id 6467',9200.00,0.00,0.00,12.50,825.00,'2022-09-30 07:46:57','',''),(6669,'1','274','1',1,'Retail Sale Id 6468',18400.00,0.00,0.00,25.00,1650.00,'2022-09-30 07:52:08','',''),(6670,'1','274','1',1,'Retail Sale Id 6468',18400.00,0.00,0.00,25.00,1650.00,'2022-09-30 07:52:08','',''),(6671,'1','274','1',1,'Retail Sale Id 6469',2252.16,0.00,0.00,3.06,201.96,'2022-09-30 08:04:05','',''),(6672,'1','274','1',1,'Retail Sale Id 6470',9200.00,0.00,0.00,12.50,825.00,'2022-09-30 08:06:25','',''),(6673,'1','274','1',1,'Retail Sale Id 6471',9001.28,0.00,0.00,12.23,807.18,'2022-09-30 08:15:08','',''),(6674,'1','274','1',1,'Retail Sale Id 6472',1000.96,0.00,0.00,1.36,89.76,'2022-09-30 08:16:18','',''),(6675,'1','274','1',1,'Retail Sale Id 6473',9200.00,0.00,0.00,12.50,825.00,'2022-09-30 08:21:35','',''),(6676,'1','274','1',1,'Retail Sale Id 6475',8000.32,0.00,0.00,10.87,717.42,'2022-09-30 08:24:21','',''),(6677,'1','274','1',1,'Retail Sale Id 6476',3702.08,0.00,0.00,5.03,331.98,'2022-09-30 08:28:03','',''),(6678,'1','274','1',1,'Retail Sale Id 6478',9597.44,0.00,0.00,13.04,860.64,'2022-09-30 08:31:36','',''),(6679,'1','274','1',1,'Retail Sale Id 6479',9200.00,0.00,0.00,12.50,825.00,'2022-09-30 09:04:27','',''),(6680,'1','274','1',1,'Retail Sale Id 6480',3702.08,0.00,0.00,5.03,331.98,'2022-09-30 09:06:13','',''),(6681,'1','274','1',1,'Retail Sale Id 6481',9200.00,0.00,0.00,12.50,825.00,'2022-09-30 09:12:54','',''),(6682,'1','274','1',1,'Retail Sale Id 6483',3996.48,0.00,0.00,5.43,358.38,'2022-09-30 09:22:04','',''),(6683,'1','274','1',1,'Retail Sale Id 6485',2001.92,0.00,0.00,2.72,179.52,'2022-09-30 09:30:40','',''),(6684,'1','274','1',1,'Retail Sale Id 6486',2303.68,0.00,0.00,3.13,206.58,'2022-09-30 09:38:29','',''),(6685,'1','274','1',1,'Retail Sale Id 6487',9200.00,0.00,0.00,12.50,825.00,'2022-09-30 09:39:18','',''),(6686,'1','274','1',1,'Retail Sale Id 6488',2303.68,0.00,0.00,3.13,206.58,'2022-09-30 09:52:19','',''),(6687,'1','274','1',1,'Retail Sale Id 6489',2200.64,0.00,0.00,2.99,197.34,'2022-09-30 09:58:50','',''),(6688,'1','274','1',1,'Retail Sale Id 6490',9200.00,0.00,0.00,12.50,825.00,'2022-09-30 10:03:17','',''),(6689,'1','274','1',1,'Retail Sale Id 6491',1501.44,0.00,0.00,2.04,134.64,'2022-09-30 10:04:21','',''),(6690,'1','274','1',1,'Return of Retail Sale Id 6490',0.00,9200.00,12.50,0.00,-825.00,'2022-09-30 10:07:01','',''),(6691,'1','274','1',1,'Retail Sale Id 6492',7396.80,0.00,0.00,10.05,663.30,'2022-09-30 10:07:33','',''),(6692,'1','274','1',1,'Retail Sale Id 6493',1501.44,0.00,0.00,2.04,134.64,'2022-09-30 10:10:34','',''),(6693,'1','274','1',1,'Retail Sale Id 6494',8802.56,0.00,0.00,11.96,789.36,'2022-09-30 10:13:53','',''),(6694,'1','274','1',1,'Retail Sale Id 6495',3702.08,0.00,0.00,5.03,331.98,'2022-09-30 11:22:24','',''),(6695,'1','274','1',1,'Retail Sale Id 6496',4452.80,0.00,0.00,6.05,399.30,'2022-09-30 11:23:54','',''),(6696,'1','274','1',1,'Retail Sale Id 6496',9200.00,0.00,0.00,12.50,825.00,'2022-09-30 11:23:54','',''),(6697,'1','274','1',1,'Retail Sale Id 6497',2252.16,0.00,0.00,3.06,201.96,'2022-09-30 11:36:10','',''),(6698,'1','274','1',1,'Retail Sale Id 6498',9200.00,0.00,0.00,12.50,825.00,'2022-09-30 11:51:55','',''),(6699,'1','274','1',1,'Retail Sale Id 6499',9200.00,0.00,0.00,12.50,825.00,'2022-09-30 11:53:22','',''),(6700,'1','274','1',1,'Retail Sale Id 6500',2001.92,0.00,0.00,2.72,179.52,'2022-09-30 12:26:16','',''),(6701,'1','274','1',1,'Retail Sale Id 6501',9200.00,0.00,0.00,12.50,825.00,'2022-09-30 12:31:31','',''),(6702,'1','274','1',1,'Retail Sale Id 6503',4496.96,0.00,0.00,6.11,403.26,'2022-09-30 12:36:31','',''),(6703,'1','274','1',1,'Retail Sale Id 6504',3996.48,0.00,0.00,5.43,358.38,'2022-09-30 12:37:50','',''),(6704,'1','274','1',1,'Retail Sale Id 6505',3002.88,0.00,0.00,4.08,269.28,'2022-09-30 12:47:17','',''),(6705,'1','274','1',1,'Retail Sale Id 6506',1302.72,0.00,0.00,1.77,116.82,'2022-09-30 13:07:24','',''),(6706,'1','274','1',1,'Retail Sale Id 6507',18400.00,0.00,0.00,25.00,1650.00,'2022-09-30 14:04:51','',''),(6707,'1','274','1',1,'Retail Sale Id 6508',2502.40,0.00,0.00,3.40,224.40,'2022-09-30 14:08:52','',''),(6708,'1','274','1',1,'Retail Sale Id 6509',37999.68,0.00,0.00,51.63,3407.58,'2022-09-30 14:32:08','',''),(6709,'1','274','1',1,'Return of Retail Sale Id 6509',0.00,37999.68,51.63,0.00,-3407.58,'2022-09-30 14:35:29','',''),(6710,'1','274','1',1,'Retail Sale Id 6510',37918.72,0.00,0.00,51.52,3400.32,'2022-09-30 14:36:59','',''),(6711,'1','274','1',1,'Return of Retail Sale Id 6464',0.00,39000.64,52.99,0.00,-3497.34,'2022-09-30 14:40:02','',''),(6712,'1','274','1',1,'Retail Sale Id 6511',15949.12,0.00,0.00,21.67,1430.22,'2022-09-30 14:41:53','',''),(6713,'1','274','1',1,'Retail Sale Id 6512',7499.84,0.00,0.00,10.19,672.54,'2022-09-30 14:59:17','',''),(6714,'1','274','1',1,'Retail Sale Id 6513',4416.00,0.00,0.00,6.00,396.00,'2022-09-30 15:00:40','',''),(6715,'1','274','1',1,'Retail Sale Id 6514',5799.68,0.00,0.00,7.88,520.08,'2022-09-30 15:01:59','',''),(6716,'1','274','1',1,'Retail Sale Id 6515',9200.00,0.00,0.00,12.50,825.00,'2022-09-30 15:13:35','',''),(6717,'1','274','1',1,'Retail Sale Id 6516',2303.68,0.00,0.00,3.13,206.58,'2022-09-30 15:58:30','',''),(6718,'1','274','1',1,'Retail Sale Id 6516',9200.00,0.00,0.00,12.50,825.00,'2022-09-30 15:58:30','',''),(6719,'1','274','1',1,'Retail Sale Id 6517',2252.16,0.00,0.00,3.06,201.96,'2022-09-30 15:59:46','',''),(6720,'1','274','1',1,'Retail Sale Id 6517',4997.44,0.00,0.00,6.79,448.14,'2022-09-30 15:59:46','',''),(6721,'1','274','1',1,'Retail Sale Id 6524',5048.96,0.00,0.00,6.86,452.76,'2022-09-30 16:14:47','',''),(6722,'1','274','1',1,'Retail Sale Id 6528',1501.44,0.00,0.00,2.04,134.64,'2022-09-30 16:41:20','',''),(6723,'1','274','1',1,'Retail Sale Id 6528',3753.60,0.00,0.00,5.10,336.60,'2022-09-30 16:41:20','',''),(6724,'1','274','1',1,'Retail Sale Id 6529',9200.00,0.00,0.00,12.50,825.00,'2022-09-30 16:43:59','',''),(6725,'1','274','1',1,'Retail Sale Id 6529',9200.00,0.00,0.00,12.50,825.00,'2022-09-30 16:43:59','',''),(6726,'1','274','1',1,'Retail Sale Id 6530',16928.00,0.00,0.00,23.00,1518.00,'2022-09-30 16:55:56','',''),(6727,'1','274','1',1,'Retail Sale Id 6531',11201.92,0.00,0.00,15.22,1004.52,'2022-09-30 16:56:33','',''),(6728,'1','274','1',1,'Retail Sale Id 6532',13696.96,0.00,0.00,18.61,1228.26,'2022-09-30 16:57:55','',''),(6729,'1','274','1',1,'Retail Sale Id 6533',9700.48,0.00,0.00,13.18,869.88,'2022-09-30 17:06:13','',''),(6730,'1','274','1',1,'Retail Sale Id 6534',11503.68,0.00,0.00,15.63,1031.58,'2022-09-30 17:28:45','',''),(6731,'1','274','1',1,'Retail Sale Id 6535',21402.88,0.00,0.00,29.08,1919.28,'2022-09-30 17:48:15','',''),(6732,'1','274','1',1,'Retail Sale Id 6536',16501.12,0.00,0.00,22.42,1479.72,'2022-09-30 17:49:21','',''),(6733,'1','274','1',1,'Retail Sale Id 6537',18400.00,0.00,0.00,25.00,1650.00,'2022-09-30 17:49:55','',''),(6734,'1','274','1',1,'Retail Sale Id 6538',28865.92,0.00,0.00,39.22,2588.52,'2022-09-30 19:18:59','',''),(6735,'1','274','1',1,'Retail Sale Id 6539',50997.44,0.00,0.00,69.29,4573.14,'2022-09-30 19:20:30','',''),(6736,'1','274','1',1,'Retail Sale Id 6540',36800.00,0.00,0.00,50.00,3300.00,'2022-10-01 06:48:54','',''),(6737,'1','274','1',1,'Retail Sale Id 6541',9200.00,0.00,0.00,12.50,825.00,'2022-10-01 07:17:59','',''),(6738,'1','274','1',1,'Retail Sale Id 6542',7396.80,0.00,0.00,10.05,663.30,'2022-10-01 07:32:52','',''),(6739,'1','274','1',1,'Retail Sale Id 6542',18400.00,0.00,0.00,25.00,1650.00,'2022-10-01 07:32:52','',''),(6740,'1','274','1',1,'Retail Sale Id 6543',5505.28,0.00,0.00,7.48,493.68,'2022-10-01 07:45:09','',''),(6741,'1','274','1',1,'Retail Sale Id 6543',9303.04,0.00,0.00,12.64,834.24,'2022-10-01 07:45:09','',''),(6742,'1','274','1',1,'Retail Sale Id 6544',18400.00,0.00,0.00,25.00,1650.00,'2022-10-01 08:52:00','',''),(6743,'1','274','1',1,'Retail Sale Id 6545',18569.28,0.00,0.00,25.23,1665.18,'2022-10-01 08:54:03','',''),(6744,'1','274','1',1,'Retail Sale Id 6546',36800.00,0.00,0.00,50.00,3300.00,'2022-10-01 08:55:43','',''),(6745,'1','274','1',1,'Retail Sale Id 6547',9347.20,0.00,0.00,12.70,838.20,'2022-10-01 08:56:48','',''),(6746,'1','274','1',1,'Retail Sale Id 6548',1501.44,0.00,0.00,2.04,134.64,'2022-10-01 09:05:53','',''),(6747,'1','274','1',1,'Retail Sale Id 6549',9200.00,0.00,0.00,12.50,825.00,'2022-10-01 11:16:23','',''),(6748,'1','274','1',1,'Retail Sale Id 6550',84603.20,0.00,0.00,114.95,7586.70,'2022-10-01 11:36:26','',''),(6749,'1','274','1',1,'Retail Sale Id 6552',60042.88,0.00,0.00,81.58,5384.28,'2022-10-01 11:37:03','',''),(6750,'1','274','1',1,'Retail Sale Id 6553',9200.00,0.00,0.00,12.50,825.00,'2022-10-01 11:54:06','',''),(6751,'1','274','1',1,'Retail Sale Id 6554',2001.92,0.00,0.00,2.72,179.52,'2022-10-01 11:54:38','',''),(6752,'1','274','1',1,'Retail Sale Id 6555',36800.00,0.00,0.00,50.00,3300.00,'2022-10-01 13:15:30','',''),(6753,'1','274','1',1,'Retail Sale Id 6556',8648.00,0.00,0.00,11.75,775.50,'2022-10-01 13:23:27','',''),(6754,'1','274','1',1,'Retail Sale Id 6557',2001.92,0.00,0.00,2.72,179.52,'2022-10-01 13:24:23','',''),(6755,'1','274','1',1,'Retail Sale Id 6559',2001.92,0.00,0.00,2.72,179.52,'2022-10-01 13:30:56','',''),(6756,'1','274','1',1,'Retail Sale Id 6559',3996.48,0.00,0.00,5.43,358.38,'2022-10-01 13:30:56','',''),(6757,'1','274','1',1,'Retail Sale Id 6560',73600.00,0.00,0.00,100.00,6600.00,'2022-10-01 13:35:48','',''),(6758,'1','274','1',1,'Retail Sale Id 6561',3002.88,0.00,0.00,4.08,269.28,'2022-10-01 13:39:00','',''),(6759,'1','274','1',1,'Retail Sale Id 6561',3702.08,0.00,0.00,5.03,331.98,'2022-10-01 13:39:00','',''),(6760,'1','274','1',1,'Retail Sale Id 6562',9200.00,0.00,0.00,12.50,825.00,'2022-10-01 13:50:17','',''),(6761,'1','274','1',1,'Retail Sale Id 6563',2252.16,0.00,0.00,3.06,201.96,'2022-10-01 14:07:17','',''),(6762,'1','274','1',1,'Retail Sale Id 6564',13306.88,0.00,0.00,18.08,1193.28,'2022-10-01 14:09:36','',''),(6763,'1','274','1',1,'Retail Sale Id 6565',1405.76,0.00,0.00,1.91,126.06,'2022-10-01 14:11:10','',''),(6764,'1','274','1',1,'Retail Sale Id 6566',16000.64,0.00,0.00,21.74,1434.84,'2022-10-01 15:11:28','',''),(6765,'1','274','1',1,'Return of Retail Sale Id 6566',0.00,16000.64,21.74,0.00,-1434.84,'2022-10-01 15:12:18','',''),(6766,'1','274','1',1,'Retail Sale Id 6567',11776.00,0.00,0.00,16.00,1056.00,'2022-10-01 15:12:48','',''),(6767,'1','274','1',1,'Retail Sale Id 6568',9200.00,0.00,0.00,12.50,825.00,'2022-10-01 15:25:15','',''),(6768,'1','274','1',1,'Retail Sale Id 6569',45057.92,0.00,0.00,61.22,4040.52,'2022-10-01 15:29:39','',''),(6769,'1','274','1',1,'Retail Sale Id 6570',3738.88,0.00,0.00,5.08,335.28,'2022-10-01 15:32:12','',''),(6770,'1','274','1',1,'Retail Sale Id 6571',9200.00,0.00,0.00,12.50,825.00,'2022-10-01 15:41:38','',''),(6771,'1','274','1',1,'Retail Sale Id 6571',18400.00,0.00,0.00,25.00,1650.00,'2022-10-01 15:41:38','',''),(6772,'1','274','1',1,'Retail Sale Id 6572',4997.44,0.00,0.00,6.79,448.14,'2022-10-01 15:51:04','',''),(6773,'1','274','1',1,'Retail Sale Id 6573',3002.88,0.00,0.00,4.08,269.28,'2022-10-01 15:55:06','',''),(6774,'1','274','1',1,'Retail Sale Id 6574',5998.40,0.00,0.00,8.15,537.90,'2022-10-01 15:58:24','',''),(6775,'1','274','1',1,'Retail Sale Id 6575',1000.96,0.00,0.00,1.36,89.76,'2022-10-01 16:00:40','',''),(6776,'1','274','1',1,'Retail Sale Id 6576',2001.92,0.00,0.00,2.72,179.52,'2022-10-01 16:04:54','',''),(6777,'1','274','1',1,'Return of Retail Sale Id 6574',0.00,5998.40,8.15,0.00,-537.90,'2022-10-01 16:18:53','',''),(6778,'1','274','1',1,'Retail Sale Id 6578',2001.92,0.00,0.00,2.72,179.52,'2022-10-01 16:32:26','',''),(6779,'1','274','1',1,'Retail Sale Id 6579',2252.16,0.00,0.00,3.06,201.96,'2022-10-01 16:33:28','',''),(6780,'1','274','1',1,'Retail Sale Id 6580',5998.40,0.00,0.00,8.15,537.90,'2022-10-01 16:42:53','',''),(6781,'1','274','1',1,'Retail Sale Id 6581',2252.16,0.00,0.00,3.06,201.96,'2022-10-01 16:49:29','',''),(6782,'1','274','1',1,'Retail Sale Id 6582',73519.04,0.00,0.00,99.89,6592.74,'2022-10-01 17:14:17','',''),(6783,'1','274','1',1,'Retail Sale Id 6583',15581.12,0.00,0.00,21.17,1397.22,'2022-10-01 17:16:10','',''),(6784,'1','274','1',1,'Retail Sale Id 6584',9200.00,0.00,0.00,12.50,825.00,'2022-10-01 17:20:41','',''),(6785,'1','274','1',1,'Retail Sale Id 6585',21498.56,0.00,0.00,29.21,1927.86,'2022-10-01 17:25:52','',''),(6786,'1','274','1',1,'Retail Sale Id 6586',9200.00,0.00,0.00,12.50,825.00,'2022-10-01 17:26:32','',''),(6787,'1','274','1',1,'Retail Sale Id 6587',3002.88,0.00,0.00,4.08,269.28,'2022-10-01 17:41:26','',''),(6788,'1','274','1',1,'Retail Sale Id 6588',3002.88,0.00,0.00,4.08,269.28,'2022-10-01 18:01:35','',''),(6789,'1','274','1',1,'Retail Sale Id 6589',4496.96,0.00,0.00,6.11,403.26,'2022-10-01 18:08:14','',''),(6790,'1','274','1',1,'Retail Sale Id 6591',4496.96,0.00,0.00,6.11,403.26,'2022-10-01 18:12:17','',''),(6791,'1','274','1',1,'Retail Sale Id 6592',2001.92,0.00,0.00,2.72,179.52,'2022-10-01 18:22:25','',''),(6792,'1','274','1',1,'Retail Sale Id 6593',500.48,0.00,0.00,0.68,44.88,'2022-10-01 18:24:37','',''),(6793,'1','274','1',1,'Retail Sale Id 6594',9200.00,0.00,0.00,12.50,825.00,'2022-10-01 18:27:14','',''),(6794,'1','274','1',1,'Retail Sale Id 6595',2252.16,0.00,0.00,3.06,201.96,'2022-10-01 18:29:35','',''),(6795,'1','274','1',1,'Retail Sale Id 6596',2252.16,0.00,0.00,3.06,201.96,'2022-10-01 18:30:33','',''),(6796,'1','274','1',1,'Retail Sale Id 6597',3702.08,0.00,0.00,5.03,331.98,'2022-10-01 18:34:20','',''),(6797,'1','274','1',1,'Retail Sale Id 6598',2001.92,0.00,0.00,2.72,179.52,'2022-10-01 18:45:47','',''),(6798,'1','274','1',1,'Return of Retail Sale Id 6594',0.00,9200.00,12.50,0.00,-825.00,'2022-10-01 18:51:55','',''),(6799,'1','274','1',1,'Retail Sale Id 6599',9200.00,0.00,0.00,12.50,825.00,'2022-10-01 18:53:03','',''),(6800,'1','274','1',1,'Retail Sale Id 6600',1501.44,0.00,0.00,2.04,134.64,'2022-10-02 07:24:08','',''),(6801,'1','274','1',1,'Retail Sale Id 6601',4452.80,0.00,0.00,6.05,399.30,'2022-10-02 07:25:01','',''),(6802,'1','274','1',1,'Retail Sale Id 6602',2001.92,0.00,0.00,2.72,179.52,'2022-10-02 08:08:20','',''),(6803,'1','274','1',1,'Retail Sale Id 6604',4401.28,0.00,0.00,5.98,394.68,'2022-10-02 08:36:12','',''),(6804,'1','274','1',1,'Retail Sale Id 6605',9200.00,0.00,0.00,12.50,825.00,'2022-10-02 08:38:21','',''),(6805,'1','274','1',1,'Retail Sale Id 6606',4997.44,0.00,0.00,6.79,448.14,'2022-10-02 08:39:37','',''),(6806,'1','274','1',1,'Retail Sale Id 6607',1501.44,0.00,0.00,2.04,134.64,'2022-10-02 08:46:42','',''),(6807,'1','274','1',1,'Retail Sale Id 6608',1501.44,0.00,0.00,2.04,134.64,'2022-10-02 08:55:37','',''),(6808,'1','274','1',1,'Retail Sale Id 6609',3702.08,0.00,0.00,5.03,331.98,'2022-10-02 09:06:19','',''),(6809,'1','274','1',1,'Retail Sale Id 6610',3680.00,0.00,0.00,5.00,330.00,'2022-10-02 09:14:25','',''),(6810,'1','274','1',1,'Retail Sale Id 6611',2001.92,0.00,0.00,2.72,179.52,'2022-10-02 09:23:05','',''),(6811,'1','274','1',1,'Retail Sale Id 6612',1398.40,0.00,0.00,1.90,125.40,'2022-10-02 09:36:28','',''),(6812,'1','274','1',1,'Retail Sale Id 6614',4496.96,0.00,0.00,6.11,403.26,'2022-10-02 09:46:36','',''),(6813,'1','274','1',1,'Retail Sale Id 6615',3503.36,0.00,0.00,4.76,314.16,'2022-10-02 09:51:11','',''),(6814,'1','274','1',1,'Retail Sale Id 6616',3002.88,0.00,0.00,4.08,269.28,'2022-10-02 09:58:32','',''),(6815,'1','274','1',1,'Retail Sale Id 6617',1501.44,0.00,0.00,2.04,134.64,'2022-10-02 10:01:05','',''),(6816,'1','274','1',1,'Retail Sale Id 6618',9200.00,0.00,0.00,12.50,825.00,'2022-10-02 10:02:22','',''),(6817,'1','274','1',1,'Retail Sale Id 6619',2252.16,0.00,0.00,3.06,201.96,'2022-10-02 10:03:25','',''),(6818,'1','274','1',1,'Retail Sale Id 6620',1501.44,0.00,0.00,2.04,134.64,'2022-10-02 10:04:40','',''),(6819,'1','274','1',1,'Retail Sale Id 6621',1501.44,0.00,0.00,2.04,134.64,'2022-10-02 10:05:42','',''),(6820,'1','274','1',1,'Retail Sale Id 6622',1000.96,0.00,0.00,1.36,89.76,'2022-10-02 10:06:48','',''),(6821,'1','274','1',1,'Retail Sale Id 6623',3702.08,0.00,0.00,5.03,331.98,'2022-10-02 10:19:32','',''),(6822,'1','274','1',1,'Retail Sale Id 6624',4496.96,0.00,0.00,6.11,403.26,'2022-10-02 10:21:37','',''),(6823,'1','274','1',1,'Retail Sale Id 6625',7360.00,0.00,0.00,10.00,660.00,'2022-10-02 10:25:27','',''),(6824,'1','274','1',1,'Retail Sale Id 6626',2001.92,0.00,0.00,2.72,179.52,'2022-10-02 10:31:35','',''),(6825,'1','274','1',1,'Retail Sale Id 6628',9200.00,0.00,0.00,12.50,825.00,'2022-10-02 10:33:27','',''),(6826,'1','274','1',1,'Retail Sale Id 6629',9200.00,0.00,0.00,12.50,825.00,'2022-10-02 10:36:48','',''),(6827,'1','274','1',1,'Retail Sale Id 6630',3002.88,0.00,0.00,4.08,269.28,'2022-10-02 10:41:59','',''),(6828,'1','274','1',1,'Retail Sale Id 6632',4496.96,0.00,0.00,6.11,403.26,'2022-10-02 10:49:37','',''),(6829,'1','274','1',1,'Retail Sale Id 6633',3223.68,0.00,0.00,4.38,289.08,'2022-10-02 11:00:26','',''),(6830,'1','274','1',1,'Return of Retail Sale Id 6633',0.00,3223.68,4.38,0.00,-289.08,'2022-10-02 11:02:14','',''),(6831,'1','274','1',1,'Retail Sale Id 6634',3002.88,0.00,0.00,4.08,269.28,'2022-10-02 11:03:33','',''),(6832,'1','274','1',1,'Retail Sale Id 6636',4496.96,0.00,0.00,6.11,403.26,'2022-10-02 11:18:45','',''),(6833,'1','274','1',1,'Retail Sale Id 6636',9001.28,0.00,0.00,12.23,807.18,'2022-10-02 11:18:45','',''),(6834,'1','274','1',1,'Retail Sale Id 6636',9200.00,0.00,0.00,12.50,825.00,'2022-10-02 11:18:45','',''),(6835,'1','274','1',1,'Retail Sale Id 6638',4452.80,0.00,0.00,6.05,399.30,'2022-10-02 11:19:44','',''),(6836,'1','274','1',1,'Retail Sale Id 6639',1501.44,0.00,0.00,2.04,134.64,'2022-10-02 11:22:31','',''),(6837,'1','274','1',1,'Retail Sale Id 6640',9200.00,0.00,0.00,12.50,825.00,'2022-10-02 11:23:39','',''),(6838,'1','274','1',1,'Retail Sale Id 6641',3002.88,0.00,0.00,4.08,269.28,'2022-10-02 11:24:28','',''),(6839,'1','274','1',1,'Retail Sale Id 6642',9200.00,0.00,0.00,12.50,825.00,'2022-10-02 11:26:39','',''),(6840,'1','274','1',1,'Retail Sale Id 6643',3002.88,0.00,0.00,4.08,269.28,'2022-10-02 11:27:23','',''),(6841,'1','274','1',1,'Retail Sale Id 6644',2001.92,0.00,0.00,2.72,179.52,'2022-10-02 11:28:03','',''),(6842,'1','274','1',1,'Retail Sale Id 6645',2252.16,0.00,0.00,3.06,201.96,'2022-10-02 11:31:00','',''),(6843,'1','274','1',1,'Retail Sale Id 6646',9200.00,0.00,0.00,12.50,825.00,'2022-10-02 11:32:29','',''),(6844,'1','274','1',1,'Retail Sale Id 6648',1000.96,0.00,0.00,1.36,89.76,'2022-10-02 11:34:27','',''),(6845,'1','274','1',1,'Retail Sale Id 6649',4496.96,0.00,0.00,6.11,403.26,'2022-10-02 11:35:03','',''),(6846,'1','274','1',1,'Retail Sale Id 6650',9200.00,0.00,0.00,12.50,825.00,'2022-10-02 11:39:18','',''),(6847,'1','274','1',1,'Retail Sale Id 6651',8000.32,0.00,0.00,10.87,717.42,'2022-10-02 11:40:23','',''),(6848,'1','274','1',1,'Retail Sale Id 6652',3996.48,0.00,0.00,5.43,358.38,'2022-10-02 11:44:43','',''),(6849,'1','274','1',1,'Retail Sale Id 6653',6999.36,0.00,0.00,9.51,627.66,'2022-10-02 11:46:27','',''),(6850,'1','274','1',1,'Retail Sale Id 6654',2001.92,0.00,0.00,2.72,179.52,'2022-10-02 11:48:21','',''),(6851,'1','274','1',1,'Retail Sale Id 6656',2502.40,0.00,0.00,3.40,224.40,'2022-10-02 11:50:03','',''),(6852,'1','274','1',1,'Retail Sale Id 6657',2502.40,0.00,0.00,3.40,224.40,'2022-10-02 11:50:44','',''),(6853,'1','274','1',1,'Retail Sale Id 6658',73600.00,0.00,0.00,100.00,6600.00,'2022-10-02 11:51:35','',''),(6854,'1','274','1',1,'Retail Sale Id 6659',2252.16,0.00,0.00,3.06,201.96,'2022-10-02 11:58:57','',''),(6855,'1','274','1',1,'Retail Sale Id 6662',4997.44,0.00,0.00,6.79,448.14,'2022-10-02 12:12:04','',''),(6856,'1','274','1',1,'Retail Sale Id 6663',9001.28,0.00,0.00,12.23,807.18,'2022-10-02 12:13:28','',''),(6857,'1','274','1',1,'Retail Sale Id 6664',9200.00,0.00,0.00,12.50,825.00,'2022-10-02 12:16:31','',''),(6858,'1','274','1',1,'Retail Sale Id 6666',4496.96,0.00,0.00,6.11,403.26,'2022-10-02 12:17:39','',''),(6859,'1','274','1',1,'Retail Sale Id 6667',7360.00,0.00,0.00,10.00,660.00,'2022-10-02 12:20:00','',''),(6860,'1','274','1',1,'Retail Sale Id 6669',2252.16,0.00,0.00,3.06,201.96,'2022-10-02 12:25:03','',''),(6861,'1','274','1',1,'Retail Sale Id 6670',1000.96,0.00,0.00,1.36,89.76,'2022-10-02 12:26:09','',''),(6862,'1','274','1',1,'Retail Sale Id 6671',9200.00,0.00,0.00,12.50,825.00,'2022-10-02 12:28:03','',''),(6863,'1','274','1',1,'Retail Sale Id 6672',4496.96,0.00,0.00,6.11,403.26,'2022-10-02 12:32:36','',''),(6864,'1','274','1',1,'Retail Sale Id 6673',1501.44,0.00,0.00,2.04,134.64,'2022-10-02 12:34:28','',''),(6865,'1','274','1',1,'Retail Sale Id 6674',2001.92,0.00,0.00,2.72,179.52,'2022-10-02 12:35:24','',''),(6866,'1','274','1',1,'Retail Sale Id 6675',9001.28,0.00,0.00,12.23,807.18,'2022-10-02 12:36:06','',''),(6867,'1','274','1',1,'Retail Sale Id 6676',9200.00,0.00,0.00,12.50,825.00,'2022-10-02 12:37:55','',''),(6868,'1','274','1',1,'Retail Sale Id 6677',2001.92,0.00,0.00,2.72,179.52,'2022-10-02 12:39:33','',''),(6869,'1','274','1',1,'Return of Retail Sale Id 6677',0.00,2001.92,2.72,0.00,-179.52,'2022-10-02 12:40:19','',''),(6870,'1','274','1',1,'Retail Sale Id 6678',3002.88,0.00,0.00,4.08,269.28,'2022-10-02 12:48:35','',''),(6871,'1','274','1',1,'Return of Retail Sale Id 6658',0.00,73600.00,100.00,0.00,-6600.00,'2022-10-02 12:49:33','',''),(6872,'1','274','1',1,'Retail Sale Id 6679',66240.00,0.00,0.00,90.00,5940.00,'2022-10-02 12:50:24','',''),(6873,'1','274','1',1,'Retail Sale Id 6681',9200.00,0.00,0.00,12.50,825.00,'2022-10-02 12:50:48','',''),(6874,'1','274','1',1,'Retail Sale Id 6682',2001.92,0.00,0.00,2.72,179.52,'2022-10-02 12:51:21','',''),(6875,'1','274','1',1,'Retail Sale Id 6683',2001.92,0.00,0.00,2.72,179.52,'2022-10-02 12:58:08','',''),(6876,'1','274','1',1,'Retail Sale Id 6684',3002.88,0.00,0.00,4.08,269.28,'2022-10-02 13:00:32','',''),(6877,'1','274','1',1,'Retail Sale Id 6685',3503.36,0.00,0.00,4.76,314.16,'2022-10-02 13:14:17','',''),(6878,'1','274','1',1,'Retail Sale Id 6688',9200.00,0.00,0.00,12.50,825.00,'2022-10-02 13:17:26','',''),(6879,'1','274','1',1,'Retail Sale Id 6690',3503.36,0.00,0.00,4.76,314.16,'2022-10-02 13:25:52','',''),(6880,'1','274','1',1,'Retail Sale Id 6690',7499.84,0.00,0.00,10.19,672.54,'2022-10-02 13:25:52','',''),(6881,'1','274','1',1,'Retail Sale Id 6691',1000.96,0.00,0.00,1.36,89.76,'2022-10-02 13:31:52','',''),(6882,'1','274','1',1,'Retail Sale Id 6692',5888.00,0.00,0.00,8.00,528.00,'2022-10-02 13:51:29','',''),(6883,'1','274','1',1,'Retail Sale Id 6694',14720.00,0.00,0.00,20.00,1320.00,'2022-10-02 13:54:37','',''),(6884,'1','274','1',1,'Retail Sale Id 6695',2208.00,0.00,0.00,3.00,198.00,'2022-10-02 13:56:14','',''),(6885,'1','274','1',1,'Retail Sale Id 6696',2001.92,0.00,0.00,2.72,179.52,'2022-10-02 13:57:07','',''),(6886,'1','274','1',1,'Retail Sale Id 6697',500.48,0.00,0.00,0.68,44.88,'2022-10-02 14:07:34','',''),(6887,'1','274','1',1,'Retail Sale Id 6698',1000.96,0.00,0.00,1.36,89.76,'2022-10-02 14:08:22','',''),(6888,'1','274','1',1,'Retail Sale Id 6699',9200.00,0.00,0.00,12.50,825.00,'2022-10-02 14:16:32','',''),(6889,'1','274','1',1,'Retail Sale Id 6700',1803.20,0.00,0.00,2.45,161.70,'2022-10-02 14:17:06','',''),(6890,'1','274','1',1,'Retail Sale Id 6701',9200.00,0.00,0.00,12.50,825.00,'2022-10-02 14:18:36','',''),(6891,'1','274','1',1,'Retail Sale Id 6702',12718.08,0.00,0.00,17.28,1140.48,'2022-10-02 14:23:21','',''),(6892,'1','274','1',1,'Retail Sale Id 6703',2001.92,0.00,0.00,2.72,179.52,'2022-10-02 14:24:10','',''),(6893,'1','274','1',1,'Retail Sale Id 6704',5998.40,0.00,0.00,8.15,537.90,'2022-10-02 14:34:09','',''),(6894,'1','274','1',1,'Retail Sale Id 6705',9200.00,0.00,0.00,12.50,825.00,'2022-10-02 14:36:09','',''),(6895,'1','274','1',1,'Retail Sale Id 6706',10002.24,0.00,0.00,13.59,896.94,'2022-10-02 14:41:32','',''),(6896,'1','274','1',1,'Retail Sale Id 6707',9200.00,0.00,0.00,12.50,825.00,'2022-10-02 14:42:36','',''),(6897,'1','274','1',1,'Retail Sale Id 6708',4416.00,0.00,0.00,6.00,396.00,'2022-10-02 14:47:29','',''),(6898,'1','274','1',1,'Retail Sale Id 6709',1501.44,0.00,0.00,2.04,134.64,'2022-10-02 14:48:12','',''),(6899,'1','274','1',1,'Retail Sale Id 6710',9200.00,0.00,0.00,12.50,825.00,'2022-10-02 14:49:03','',''),(6900,'1','274','1',1,'Retail Sale Id 6711',4496.96,0.00,0.00,6.11,403.26,'2022-10-02 14:50:37','',''),(6901,'1','274','1',1,'Retail Sale Id 6712',3002.88,0.00,0.00,4.08,269.28,'2022-10-02 14:53:07','',''),(6902,'1','274','1',1,'Retail Sale Id 6713',9200.00,0.00,0.00,12.50,825.00,'2022-10-02 15:29:49','',''),(6903,'1','274','1',1,'Retail Sale Id 6714',15198.40,0.00,0.00,20.65,1362.90,'2022-10-02 16:21:22','',''),(6904,'1','274','1',1,'Retail Sale Id 6715',15698.88,0.00,0.00,21.33,1407.78,'2022-10-02 16:22:26','',''),(6905,'1','274','1',1,'Retail Sale Id 6716',9200.00,0.00,0.00,12.50,825.00,'2022-10-02 16:32:06','',''),(6906,'1','274','1',1,'Retail Sale Id 6717',3002.88,0.00,0.00,4.08,269.28,'2022-10-02 16:38:28','',''),(6907,'1','274','1',1,'Return of Retail Sale Id 6715',0.00,15698.88,21.33,0.00,-1407.78,'2022-10-02 16:40:47','',''),(6908,'1','274','1',1,'Retail Sale Id 6718',1501.44,0.00,0.00,2.04,134.64,'2022-10-02 16:41:48','',''),(6909,'1','274','1',1,'Retail Sale Id 6718',4997.44,0.00,0.00,6.79,448.14,'2022-10-02 16:41:48','',''),(6910,'1','274','1',1,'Retail Sale Id 6718',9200.00,0.00,0.00,12.50,825.00,'2022-10-02 16:41:48','',''),(6911,'1','274','1',1,'Retail Sale Id 6719',1000.96,0.00,0.00,1.36,89.76,'2022-10-02 16:43:39','',''),(6912,'1','274','1',1,'Retail Sale Id 6720',9200.00,0.00,0.00,12.50,825.00,'2022-10-02 16:50:28','',''),(6913,'1','274','1',1,'Retail Sale Id 6721',1000.96,0.00,0.00,1.36,89.76,'2022-10-02 16:53:22','',''),(6914,'1','274','1',1,'Retail Sale Id 6722',9200.00,0.00,0.00,12.50,825.00,'2022-10-02 17:03:19','',''),(6915,'1','274','1',1,'Retail Sale Id 6723',9200.00,0.00,0.00,12.50,825.00,'2022-10-02 17:04:12','',''),(6916,'1','274','1',1,'Retail Sale Id 6724',1000.96,0.00,0.00,1.36,89.76,'2022-10-02 17:04:56','',''),(6917,'1','274','1',1,'Retail Sale Id 6725',750.72,0.00,0.00,1.02,67.32,'2022-10-02 17:07:21','',''),(6918,'1','274','1',1,'Retail Sale Id 6726',1000.96,0.00,0.00,1.36,89.76,'2022-10-02 17:09:25','',''),(6919,'1','274','1',1,'Retail Sale Id 6727',1501.44,0.00,0.00,2.04,134.64,'2022-10-02 17:14:21','',''),(6920,'1','274','1',1,'Retail Sale Id 6728',18400.00,0.00,0.00,25.00,1650.00,'2022-10-02 17:21:48','',''),(6921,'1','274','1',1,'Retail Sale Id 6729',9200.00,0.00,0.00,12.50,825.00,'2022-10-02 17:24:43','',''),(6922,'1','274','1',1,'Retail Sale Id 6730',2208.00,0.00,0.00,3.00,198.00,'2022-10-02 17:37:15','',''),(6923,'1','274','1',1,'Retail Sale Id 6731',500.48,0.00,0.00,0.68,44.88,'2022-10-02 17:37:59','',''),(6924,'1','274','1',1,'Retail Sale Id 6732',2208.00,0.00,0.00,3.00,198.00,'2022-10-02 18:08:07','',''),(6925,'1','274','1',1,'Retail Sale Id 6733',4496.96,0.00,0.00,6.11,403.26,'2022-10-02 18:20:02','',''),(6926,'1','274','1',1,'Retail Sale Id 6735',9200.00,0.00,0.00,12.50,825.00,'2022-10-02 18:20:44','',''),(6927,'1','274','1',1,'Retail Sale Id 6736',1501.44,0.00,0.00,2.04,134.64,'2022-10-02 18:24:04','',''),(6928,'1','274','1',1,'Retail Sale Id 6737',4496.96,0.00,0.00,6.11,403.26,'2022-10-02 18:26:31','',''),(6929,'1','274','1',1,'Retail Sale Id 6738',1000.96,0.00,0.00,1.36,89.76,'2022-10-02 18:29:08','',''),(6930,'1','274','1',1,'Retail Sale Id 6739',10892.80,0.00,0.00,14.80,976.80,'2022-10-02 18:55:57','',''),(6931,'1','274','1',1,'Return of Retail Sale Id 6694',0.00,14720.00,20.00,0.00,-1320.00,'2022-10-02 19:03:43','',''),(6932,'1','274','1',1,'Retail Sale Id 6740',4217.28,0.00,0.00,5.73,378.18,'2022-10-02 19:05:42','',''),(6933,'1','274','1',1,'Retail Sale Id 6741',7360.00,0.00,0.00,10.00,660.00,'2022-10-03 06:35:47','',''),(6934,'1','274','1',1,'Retail Sale Id 6742',2208.00,0.00,0.00,3.00,198.00,'2022-10-03 06:55:09','',''),(6935,'1','274','1',1,'Retail Sale Id 6743',2502.40,0.00,0.00,3.40,224.40,'2022-10-03 07:08:44','',''),(6936,'1','274','1',1,'Retail Sale Id 6744',4496.96,0.00,0.00,6.11,403.26,'2022-10-03 07:27:27','',''),(6937,'1','274','1',1,'Retail Sale Id 6745',2001.92,0.00,0.00,2.72,179.52,'2022-10-03 07:38:28','',''),(6938,'1','274','1',1,'Retail Sale Id 6746',3503.36,0.00,0.00,4.76,314.16,'2022-10-03 07:41:38','',''),(6939,'1','274','1',1,'Retail Sale Id 6747',6624.00,0.00,0.00,9.00,594.00,'2022-10-03 07:55:13','',''),(6940,'1','274','1',1,'Retail Sale Id 6748',3680.00,0.00,0.00,5.00,330.00,'2022-10-03 08:03:48','',''),(6941,'1','274','1',1,'Retail Sale Id 6749',4416.00,0.00,0.00,6.00,396.00,'2022-10-03 08:27:01','',''),(6942,'1','274','1',1,'Return of Retail Sale Id 6749',0.00,4416.00,6.00,0.00,-396.00,'2022-10-03 08:27:26','',''),(6943,'1','274','1',1,'Retail Sale Id 6750',3996.48,0.00,0.00,5.43,358.38,'2022-10-03 08:28:03','',''),(6944,'1','274','1',1,'Retail Sale Id 6751',10002.24,0.00,0.00,13.59,896.94,'2022-10-03 08:29:08','',''),(6945,'1','274','1',1,'Retail Sale Id 6752',3002.88,0.00,0.00,4.08,269.28,'2022-10-03 08:32:34','',''),(6946,'1','274','1',1,'Retail Sale Id 6753',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 08:45:18','',''),(6947,'1','274','1',1,'Retail Sale Id 6754',1501.44,0.00,0.00,2.04,134.64,'2022-10-03 08:56:29','',''),(6948,'1','274','1',1,'Retail Sale Id 6756',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 09:16:19','',''),(6949,'1','274','1',1,'Retail Sale Id 6757',2701.12,0.00,0.00,3.67,242.22,'2022-10-03 09:18:49','',''),(6950,'1','274','1',1,'Retail Sale Id 6759',3702.08,0.00,0.00,5.03,331.98,'2022-10-03 09:30:14','',''),(6951,'1','274','1',1,'Retail Sale Id 6760',2303.68,0.00,0.00,3.13,206.58,'2022-10-03 09:33:52','',''),(6952,'1','274','1',1,'Retail Sale Id 6761',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 09:34:59','',''),(6953,'1','274','1',1,'Retail Sale Id 6762',4496.96,0.00,0.00,6.11,403.26,'2022-10-03 09:36:49','',''),(6954,'1','274','1',1,'Retail Sale Id 6763',4496.96,0.00,0.00,6.11,403.26,'2022-10-03 09:38:16','',''),(6955,'1','274','1',1,'Retail Sale Id 6764',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 09:53:42','',''),(6956,'1','274','1',1,'Retail Sale Id 6765',2001.92,0.00,0.00,2.72,179.52,'2022-10-03 09:54:42','',''),(6957,'1','274','1',1,'Retail Sale Id 6766',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 10:04:44','',''),(6958,'1','274','1',1,'Retail Sale Id 6768',1000.96,0.00,0.00,1.36,89.76,'2022-10-03 10:12:59','',''),(6959,'1','274','1',1,'Retail Sale Id 6769',3002.88,0.00,0.00,4.08,269.28,'2022-10-03 10:24:51','',''),(6960,'1','274','1',1,'Retail Sale Id 6770',1000.96,0.00,0.00,1.36,89.76,'2022-10-03 10:28:59','',''),(6961,'1','274','1',1,'Retail Sale Id 6771',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 10:33:37','',''),(6962,'1','274','1',1,'Retail Sale Id 6773',1302.72,0.00,0.00,1.77,116.82,'2022-10-03 11:00:38','',''),(6963,'1','274','1',1,'Retail Sale Id 6775',699.20,0.00,0.00,0.95,62.70,'2022-10-03 11:03:08','',''),(6964,'1','274','1',1,'Retail Sale Id 6777',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 11:05:49','',''),(6965,'1','274','1',1,'Retail Sale Id 6778',4997.44,0.00,0.00,6.79,448.14,'2022-10-03 11:07:11','',''),(6966,'1','274','1',1,'Retail Sale Id 6780',6999.36,0.00,0.00,9.51,627.66,'2022-10-03 11:19:31','',''),(6967,'1','274','1',1,'Retail Sale Id 6781',2001.92,0.00,0.00,2.72,179.52,'2022-10-03 11:22:56','',''),(6968,'1','274','1',1,'Retail Sale Id 6782',16560.00,0.00,0.00,22.50,1485.00,'2022-10-03 11:30:04','',''),(6969,'1','274','1',1,'Retail Sale Id 6783',3002.88,0.00,0.00,4.08,269.28,'2022-10-03 11:40:41','',''),(6970,'1','274','1',1,'Retail Sale Id 6784',22080.00,0.00,0.00,30.00,1980.00,'2022-10-03 11:44:35','',''),(6971,'1','274','1',1,'Retail Sale Id 6786',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 11:50:16','',''),(6972,'1','274','1',1,'Retail Sale Id 6789',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 11:52:41','',''),(6973,'1','274','1',1,'Retail Sale Id 6790',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 12:06:45','',''),(6974,'1','274','1',1,'Retail Sale Id 6791',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 12:36:51','',''),(6975,'1','274','1',1,'Retail Sale Id 6792',500.48,0.00,0.00,0.68,44.88,'2022-10-03 12:44:08','',''),(6976,'1','274','1',1,'Retail Sale Id 6793',3702.08,0.00,0.00,5.03,331.98,'2022-10-03 12:47:13','',''),(6977,'1','274','1',1,'Retail Sale Id 6794',3702.08,0.00,0.00,5.03,331.98,'2022-10-03 12:48:30','',''),(6978,'1','274','1',1,'Retail Sale Id 6795',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 13:19:05','',''),(6979,'1','274','1',1,'Retail Sale Id 6796',7360.00,0.00,0.00,10.00,660.00,'2022-10-03 13:24:54','',''),(6980,'1','274','1',1,'Retail Sale Id 6797',2001.92,0.00,0.00,2.72,179.52,'2022-10-03 13:27:08','',''),(6981,'1','274','1',1,'Retail Sale Id 6798',2502.40,0.00,0.00,3.40,224.40,'2022-10-03 13:39:26','',''),(6982,'1','274','1',1,'Retail Sale Id 6801',4496.96,0.00,0.00,6.11,403.26,'2022-10-03 13:51:48','',''),(6983,'1','274','1',1,'Retail Sale Id 6802',5203.52,0.00,0.00,7.07,466.62,'2022-10-03 13:53:03','',''),(6984,'1','274','1',1,'Retail Sale Id 6803',3002.88,0.00,0.00,4.08,269.28,'2022-10-03 15:29:27','',''),(6985,'1','274','1',1,'Retail Sale Id 6804',36800.00,0.00,0.00,50.00,3300.00,'2022-10-03 15:33:39','',''),(6986,'1','274','1',1,'Return of Retail Sale Id 6784',0.00,22080.00,30.00,0.00,-1980.00,'2022-10-03 15:34:42','',''),(6987,'1','274','1',1,'Retail Sale Id 6805',2001.92,0.00,0.00,2.72,179.52,'2022-10-03 15:57:02','',''),(6988,'1','274','1',1,'Retail Sale Id 6806',2001.92,0.00,0.00,2.72,179.52,'2022-10-03 16:24:36','',''),(6989,'1','274','1',1,'Retail Sale Id 6807',2001.92,0.00,0.00,2.72,179.52,'2022-10-03 16:31:07','',''),(6990,'1','274','1',1,'Retail Sale Id 6808',1501.44,0.00,0.00,2.04,134.64,'2022-10-03 16:44:15','',''),(6991,'1','274','1',1,'Retail Sale Id 6809',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 16:45:38','',''),(6992,'1','274','1',1,'Retail Sale Id 6810',1501.44,0.00,0.00,2.04,134.64,'2022-10-03 17:23:54','',''),(6993,'1','274','1',1,'Retail Sale Id 6811',2208.00,0.00,0.00,3.00,198.00,'2022-10-03 17:25:10','',''),(6994,'1','274','1',1,'Retail Sale Id 6812',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 17:38:49','',''),(6995,'1','274','1',1,'Retail Sale Id 6813',18400.00,0.00,0.00,25.00,1650.00,'2022-10-03 17:41:09','',''),(6996,'1','274','1',1,'Retail Sale Id 6814',3002.88,0.00,0.00,4.08,269.28,'2022-10-03 17:44:13','',''),(6997,'1','274','1',1,'Retail Sale Id 6815',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 17:49:11','',''),(6998,'1','274','1',1,'Retail Sale Id 6816',18400.00,0.00,0.00,25.00,1650.00,'2022-10-03 17:52:14','',''),(6999,'1','274','1',1,'Retail Sale Id 6817',72128.00,0.00,0.00,98.00,6468.00,'2022-10-03 18:03:29','',''),(7000,'1','274','1',1,'Retail Sale Id 6818',64032.00,0.00,0.00,87.00,5742.00,'2022-10-03 18:04:32','',''),(7001,'1','274','1',1,'Return of Retail Sale Id 6817',0.00,72128.00,98.00,0.00,-6468.00,'2022-10-03 18:05:16','',''),(7002,'1','274','1',1,'Retail Sale Id 6819',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 18:08:17','',''),(7003,'1','274','1',1,'Retail Sale Id 6820',4496.96,0.00,0.00,6.11,403.26,'2022-10-03 18:11:33','',''),(7004,'1','274','1',1,'Retail Sale Id 6821',4997.44,0.00,0.00,6.79,448.14,'2022-10-03 18:19:39','',''),(7005,'1','274','1',1,'Retail Sale Id 6822',1501.44,0.00,0.00,2.04,134.64,'2022-10-03 18:21:43','',''),(7006,'1','274','1',1,'Retail Sale Id 6823',1501.44,0.00,0.00,2.04,134.64,'2022-10-03 18:25:58','',''),(7007,'1','274','1',1,'Retail Sale Id 6824',9568.00,0.00,0.00,13.00,858.00,'2022-10-03 18:27:25','',''),(7008,'1','274','1',1,'Retail Sale Id 6825',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 18:29:55','',''),(7009,'1','274','1',1,'Retail Sale Id 6826',9200.00,0.00,0.00,12.50,825.00,'2022-10-03 18:32:50','',''),(7010,'1','274','1',1,'Retail Sale Id 6827',3002.88,0.00,0.00,4.08,269.28,'2022-10-03 18:37:34','',''),(7011,'1','274','1',1,'Return of Retail Sale Id 6818',0.00,64032.00,87.00,0.00,-5742.00,'2022-10-03 19:07:45','',''),(7012,'1','274','1',1,'Retail Sale Id 6828',88445.12,0.00,0.00,120.17,7931.22,'2022-10-03 19:09:11','',''),(7013,'1','274','1',1,'Retail Sale Id 6829',2701.12,0.00,0.00,3.67,242.22,'2022-10-03 19:10:18','',''),(7014,'1','274','1',1,'Retail Sale Id 6830',6624.00,0.00,0.00,9.00,594.00,'2022-10-04 06:38:33','',''),(7015,'1','274','1',1,'Retail Sale Id 6831',14720.00,0.00,0.00,20.00,1320.00,'2022-10-04 08:08:37','',''),(7016,'1','274','1',1,'Retail Sale Id 6832',9200.00,0.00,0.00,12.50,825.00,'2022-10-04 08:09:22','',''),(7017,'1','274','1',1,'Return of Retail Sale Id 6830',0.00,6624.00,9.00,0.00,-594.00,'2022-10-04 08:48:56','',''),(7018,'1','274','1',1,'Retail Sale Id 6833',28829.12,0.00,0.00,39.17,2585.22,'2022-10-04 08:49:27','',''),(7019,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,5299.70,7.91,0.00,0.00,'2022-10-04 08:51:46','',''),(7020,'1','274',NULL,1,'Reception corrector for bridging 57',0.00,0.00,0.00,7.91,0.00,'2022-10-04 08:52:46','',''),(7021,'1','274','1',1,'Received from bridging 57',0.00,0.00,7.91,0.00,0.00,'2022-10-04 08:52:46','',''),(7022,'1','274','1',1,'Retail Sale Id 6834',12718.08,0.00,0.00,17.28,1140.48,'2022-10-04 08:53:16','',''),(7023,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,670000.00,1000.00,0.00,0.00,'2022-10-06 16:22:10','',''),(7024,'1','274',NULL,1,'Reception corrector for bridging 58',0.00,0.00,0.00,1000.00,0.00,'2022-10-06 16:23:17','',''),(7025,'1','274','1',1,'Received from bridging 58',0.00,0.00,1000.00,0.00,0.00,'2022-10-06 16:23:17','',''),(7026,'1','274','1',1,'Retail Sale Id 6835',1000.96,0.00,0.00,1.36,89.76,'2022-10-06 16:34:23','',''),(7027,'1','274','1',1,'Retail Sale Id 6836',500.48,0.00,0.00,0.68,44.88,'2022-10-06 16:34:57','',''),(7028,'1','274','1',1,'Retail Sale Id 6837',2001.92,0.00,0.00,2.72,179.52,'2022-10-06 16:35:43','',''),(7029,'1','274','1',1,'Retail Sale Id 6838',2001.92,0.00,0.00,2.72,179.52,'2022-10-06 16:36:19','',''),(7030,'1','274','1',1,'Retail Sale Id 6839',1000.96,0.00,0.00,1.36,89.76,'2022-10-06 16:36:54','',''),(7031,'1','274','1',1,'Retail Sale Id 6840',3002.88,0.00,0.00,4.08,269.28,'2022-10-06 16:37:42','',''),(7032,'1','274','1',1,'Retail Sale Id 6841',4401.28,0.00,0.00,5.98,394.68,'2022-10-06 16:38:32','',''),(7033,'1','274','1',1,'Retail Sale Id 6842',3002.88,0.00,0.00,4.08,269.28,'2022-10-06 16:39:02','',''),(7034,'1','274','1',1,'Retail Sale Id 6843',2502.40,0.00,0.00,3.40,224.40,'2022-10-06 16:39:50','',''),(7035,'1','274','1',1,'Retail Sale Id 6846',1501.44,0.00,0.00,2.04,134.64,'2022-10-06 16:40:38','',''),(7036,'1','274','1',1,'Retail Sale Id 6847',3702.08,0.00,0.00,5.03,331.98,'2022-10-06 16:41:46','',''),(7037,'1','274','1',1,'Retail Sale Id 6848',2502.40,0.00,0.00,3.40,224.40,'2022-10-06 16:42:44','',''),(7038,'1','274','1',1,'Retail Sale Id 6849',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 16:45:06','',''),(7039,'1','274','1',1,'Retail Sale Id 6850',5998.40,0.00,0.00,8.15,537.90,'2022-10-06 16:50:21','',''),(7040,'1','274','1',1,'Retail Sale Id 6850',7396.80,0.00,0.00,10.05,663.30,'2022-10-06 16:50:21','',''),(7041,'1','274','1',1,'Retail Sale Id 6851',3002.88,0.00,0.00,4.08,269.28,'2022-10-06 16:51:27','',''),(7042,'1','274','1',1,'Retail Sale Id 6852',4496.96,0.00,0.00,6.11,403.26,'2022-10-06 16:52:06','',''),(7043,'1','274','1',1,'Retail Sale Id 6853',1501.44,0.00,0.00,2.04,134.64,'2022-10-06 16:52:51','',''),(7044,'1','274','1',1,'Retail Sale Id 6854',1000.96,0.00,0.00,1.36,89.76,'2022-10-06 16:53:25','',''),(7045,'1','274','1',1,'Retail Sale Id 6855',3002.88,0.00,0.00,4.08,269.28,'2022-10-06 16:53:59','',''),(7046,'1','274','1',1,'Retail Sale Id 6856',4496.96,0.00,0.00,6.11,403.26,'2022-10-06 16:54:46','',''),(7047,'1','274','1',1,'Retail Sale Id 6857',2252.16,0.00,0.00,3.06,201.96,'2022-10-06 16:56:11','',''),(7048,'1','274','1',1,'Retail Sale Id 6858',1803.20,0.00,0.00,2.45,161.70,'2022-10-06 16:57:02','',''),(7049,'1','274','1',1,'Retail Sale Id 6859',1000.96,0.00,0.00,1.36,89.76,'2022-10-06 16:57:46','',''),(7050,'1','274','1',1,'Retail Sale Id 6860',3002.88,0.00,0.00,4.08,269.28,'2022-10-06 17:00:21','',''),(7051,'1','274','1',1,'Retail Sale Id 6861',8103.36,0.00,0.00,11.01,726.66,'2022-10-06 17:01:10','',''),(7052,'1','274','1',1,'Retail Sale Id 6862',3702.08,0.00,0.00,5.03,331.98,'2022-10-06 17:02:24','',''),(7053,'1','274','1',1,'Retail Sale Id 6863',1501.44,0.00,0.00,2.04,134.64,'2022-10-06 17:06:04','',''),(7054,'1','274','1',1,'Retail Sale Id 6864',8000.32,0.00,0.00,10.87,717.42,'2022-10-06 17:07:01','',''),(7055,'1','274','1',1,'Retail Sale Id 6865',4997.44,0.00,0.00,6.79,448.14,'2022-10-06 17:13:24','',''),(7056,'1','274','1',1,'Retail Sale Id 6867',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 17:15:16','',''),(7057,'1','274','1',1,'Retail Sale Id 6868',4997.44,0.00,0.00,6.79,448.14,'2022-10-06 17:19:44','',''),(7058,'1','274','1',1,'Retail Sale Id 6869',2252.16,0.00,0.00,3.06,201.96,'2022-10-06 17:29:08','',''),(7059,'1','274','1',1,'Retail Sale Id 6870',147200.00,0.00,0.00,200.00,13200.00,'2022-10-06 17:30:52','',''),(7060,'1','274','1',1,'Retail Sale Id 6871',9200.00,0.00,0.00,12.50,825.00,'2022-10-06 17:35:43','',''),(7061,'1','274','1',1,'Retail Sale Id 6872',1501.44,0.00,0.00,2.04,134.64,'2022-10-06 17:45:15','',''),(7062,'1','274','1',1,'Retail Sale Id 6873',1000.96,0.00,0.00,1.36,89.76,'2022-10-06 17:48:52','',''),(7063,'1','274','1',1,'Retail Sale Id 6874',1803.20,0.00,0.00,2.45,161.70,'2022-10-06 17:49:52','',''),(7064,'1','274','1',1,'Retail Sale Id 6875',1501.44,0.00,0.00,2.04,134.64,'2022-10-06 17:53:32','',''),(7065,'1','274','1',1,'Retail Sale Id 6876',1501.44,0.00,0.00,2.04,134.64,'2022-10-06 18:16:18','',''),(7066,'1','274','1',1,'Retail Sale Id 6877',14859.84,0.00,0.00,20.19,1332.54,'2022-10-06 18:58:54','',''),(7067,'1','274','1',1,'Retail Sale Id 6878',11363.84,0.00,0.00,15.44,1019.04,'2022-10-06 19:00:00','',''),(7068,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,2211000.00,3300.00,0.00,0.00,'2022-10-06 19:06:03','',''),(7069,'1','274',NULL,1,'Reception corrector for bridging 59',0.00,0.00,0.00,3300.00,0.00,'2022-10-06 19:07:18','',''),(7070,'1','274','1',1,'Received from bridging 59',0.00,0.00,3300.00,0.00,0.00,'2022-10-06 19:07:18','',''),(7071,'1','274','1',1,'Retail Sale Id 6879',7360.00,0.00,0.00,10.00,660.00,'2022-10-07 07:06:56','',''),(7072,'1','274','1',1,'Retail Sale Id 6880',2208.00,0.00,0.00,3.00,198.00,'2022-10-07 07:07:44','',''),(7073,'1','274','1',1,'Retail Sale Id 6881',4997.44,0.00,0.00,6.79,448.14,'2022-10-07 08:03:52','',''),(7074,'1','274','1',1,'Retail Sale Id 6882',14720.00,0.00,0.00,20.00,1320.00,'2022-10-07 08:45:28','',''),(7075,'1','274','1',1,'Retail Sale Id 6883',7360.00,0.00,0.00,10.00,660.00,'2022-10-07 08:46:17','',''),(7076,'1','274','1',1,'Retail Sale Id 6884',1501.44,0.00,0.00,2.04,134.64,'2022-10-07 09:39:16','',''),(7077,'1','274','1',1,'Retail Sale Id 6885',8898.24,0.00,0.00,12.09,797.94,'2022-10-07 09:59:36','',''),(7078,'1','274','1',1,'Retail Sale Id 6886',2252.16,0.00,0.00,3.06,201.96,'2022-10-07 10:01:12','',''),(7079,'1','274','1',1,'Retail Sale Id 6887',73600.00,0.00,0.00,100.00,6600.00,'2022-10-07 10:03:55','',''),(7080,'1','274','1',1,'Retail Sale Id 6888',18179.20,0.00,0.00,24.70,1630.20,'2022-10-07 10:05:19','',''),(7081,'1','274','1',1,'Retail Sale Id 6889',24840.00,0.00,0.00,33.75,2227.50,'2022-10-07 10:06:59','',''),(7082,'1','274','1',1,'Retail Sale Id 6890',5998.40,0.00,0.00,8.15,537.90,'2022-10-07 10:11:38','',''),(7083,'1','274','1',1,'Retail Sale Id 6891',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 10:12:42','',''),(7084,'1','274','1',1,'Retail Sale Id 6892',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 10:15:48','',''),(7085,'1','274','1',1,'Retail Sale Id 6893',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 10:16:45','',''),(7086,'1','274','1',1,'Retail Sale Id 6894',7360.00,0.00,0.00,10.00,660.00,'2022-10-07 10:34:58','',''),(7087,'1','274','1',1,'Retail Sale Id 6895',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 10:37:09','',''),(7088,'1','274','1',1,'Retail Sale Id 6896',3002.88,0.00,0.00,4.08,269.28,'2022-10-07 10:48:16','',''),(7089,'1','274','1',1,'Retail Sale Id 6897',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 10:55:11','',''),(7090,'1','274','1',1,'Retail Sale Id 6898',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 11:16:50','',''),(7091,'1','274','1',1,'Retail Sale Id 6899',4997.44,0.00,0.00,6.79,448.14,'2022-10-07 11:28:33','',''),(7092,'1','274','1',1,'Retail Sale Id 6900',2097.60,0.00,0.00,2.85,188.10,'2022-10-07 11:34:59','',''),(7093,'1','274','1',1,'Retail Sale Id 6901',73600.00,0.00,0.00,100.00,6600.00,'2022-10-07 11:38:06','',''),(7094,'1','274','1',1,'Retail Sale Id 6903',2252.16,0.00,0.00,3.06,201.96,'2022-10-07 11:40:45','',''),(7095,'1','274','1',1,'Retail Sale Id 6904',4452.80,0.00,0.00,6.05,399.30,'2022-10-07 11:44:34','',''),(7096,'1','274','1',1,'Retail Sale Id 6905',18002.56,0.00,0.00,24.46,1614.36,'2022-10-07 12:03:40','',''),(7097,'1','274','1',1,'Retail Sale Id 6907',4997.44,0.00,0.00,6.79,448.14,'2022-10-07 12:12:41','',''),(7098,'1','274','1',1,'Retail Sale Id 6908',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 12:17:21','',''),(7099,'1','274','1',1,'Retail Sale Id 6909',2252.16,0.00,0.00,3.06,201.96,'2022-10-07 12:37:14','',''),(7100,'1','274','1',1,'Retail Sale Id 6910',4496.96,0.00,0.00,6.11,403.26,'2022-10-07 12:43:56','',''),(7101,'1','274','1',1,'Retail Sale Id 6911',5998.40,0.00,0.00,8.15,537.90,'2022-10-07 12:49:48','',''),(7102,'1','274','1',1,'Retail Sale Id 6912',3002.88,0.00,0.00,4.08,269.28,'2022-10-07 13:00:33','',''),(7103,'1','274','1',1,'Retail Sale Id 6913',2252.16,0.00,0.00,3.06,201.96,'2022-10-07 13:01:45','',''),(7104,'1','274','1',1,'Retail Sale Id 6914',1472.00,0.00,0.00,2.00,132.00,'2022-10-07 13:04:14','',''),(7105,'1','274','1',1,'Retail Sale Id 6917',500.48,0.00,0.00,0.68,44.88,'2022-10-07 13:05:57','',''),(7106,'1','274','1',1,'Retail Sale Id 6918',33502.72,0.00,0.00,45.52,3004.32,'2022-10-07 13:09:45','',''),(7107,'1','274','1',1,'Retail Sale Id 6920',36800.00,0.00,0.00,50.00,3300.00,'2022-10-07 13:12:50','',''),(7108,'1','274','1',1,'Retail Sale Id 6921',4496.96,0.00,0.00,6.11,403.26,'2022-10-07 13:14:01','',''),(7109,'1','274','1',1,'Retail Sale Id 6922',2252.16,0.00,0.00,3.06,201.96,'2022-10-07 13:16:53','',''),(7110,'1','274','1',1,'Retail Sale Id 6923',4452.80,0.00,0.00,6.05,399.30,'2022-10-07 14:01:21','',''),(7111,'1','274','1',1,'Retail Sale Id 6925',1000.96,0.00,0.00,1.36,89.76,'2022-10-07 14:02:22','',''),(7112,'1','274','1',1,'Retail Sale Id 6927',1501.44,0.00,0.00,2.04,134.64,'2022-10-07 14:02:58','',''),(7113,'1','274','1',1,'Retail Sale Id 6928',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 14:04:10','',''),(7114,'1','274','1',1,'Retail Sale Id 6929',2252.16,0.00,0.00,3.06,201.96,'2022-10-07 14:05:13','',''),(7115,'1','274','1',1,'Retail Sale Id 6930',3002.88,0.00,0.00,4.08,269.28,'2022-10-07 14:07:02','',''),(7116,'1','274','1',1,'Retail Sale Id 6931',3996.48,0.00,0.00,5.43,358.38,'2022-10-07 14:07:51','',''),(7117,'1','274','1',1,'Retail Sale Id 6932',1000.96,0.00,0.00,1.36,89.76,'2022-10-07 14:14:58','',''),(7118,'1','274','1',1,'Retail Sale Id 6933',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 14:20:32','',''),(7119,'1','274','1',1,'Retail Sale Id 6934',7396.80,0.00,0.00,10.05,663.30,'2022-10-07 14:24:25','',''),(7120,'1','274','1',1,'Retail Sale Id 6935',500.48,0.00,0.00,0.68,44.88,'2022-10-07 14:31:14','',''),(7121,'1','274','1',1,'Retail Sale Id 6936',5998.40,0.00,0.00,8.15,537.90,'2022-10-07 14:41:47','',''),(7122,'1','274','1',1,'Retail Sale Id 6937',4452.80,0.00,0.00,6.05,399.30,'2022-10-07 14:53:55','',''),(7123,'1','274','1',1,'Retail Sale Id 6939',2252.16,0.00,0.00,3.06,201.96,'2022-10-07 14:56:01','',''),(7124,'1','274','1',1,'Retail Sale Id 6940',2001.92,0.00,0.00,2.72,179.52,'2022-10-07 14:57:01','',''),(7125,'1','274','1',1,'Retail Sale Id 6941',1000.96,0.00,0.00,1.36,89.76,'2022-10-07 14:57:52','',''),(7126,'1','274','1',1,'Retail Sale Id 6942',2001.92,0.00,0.00,2.72,179.52,'2022-10-07 14:59:07','',''),(7127,'1','274','1',1,'Retail Sale Id 6944',3503.36,0.00,0.00,4.76,314.16,'2022-10-07 15:05:13','',''),(7128,'1','274','1',1,'Retail Sale Id 6945',2001.92,0.00,0.00,2.72,179.52,'2022-10-07 15:08:19','',''),(7129,'1','274','1',1,'Retail Sale Id 6946',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 15:11:26','',''),(7130,'1','274','1',1,'Retail Sale Id 6947',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 15:20:42','',''),(7131,'1','274','1',1,'Retail Sale Id 6948',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 15:22:45','',''),(7132,'1','274','1',1,'Retail Sale Id 6949',1000.96,0.00,0.00,1.36,89.76,'2022-10-07 15:24:56','',''),(7133,'1','274','1',1,'Retail Sale Id 6951',25796.80,0.00,0.00,35.05,2313.30,'2022-10-07 15:29:57','',''),(7134,'1','274','1',1,'Retail Sale Id 6952',1000.96,0.00,0.00,1.36,89.76,'2022-10-07 15:31:25','',''),(7135,'1','274','1',1,'Retail Sale Id 6953',1302.72,0.00,0.00,1.77,116.82,'2022-10-07 15:35:35','',''),(7136,'1','274','1',1,'Retail Sale Id 6954',2252.16,0.00,0.00,3.06,201.96,'2022-10-07 15:41:46','',''),(7137,'1','274','1',1,'Retail Sale Id 6955',2252.16,0.00,0.00,3.06,201.96,'2022-10-07 15:42:44','',''),(7138,'1','274','1',1,'Retail Sale Id 6956',2252.16,0.00,0.00,3.06,201.96,'2022-10-07 15:44:15','',''),(7139,'1','274','1',1,'Retail Sale Id 6957',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 16:09:15','',''),(7140,'1','274','1',1,'Retail Sale Id 6958',500.48,0.00,0.00,0.68,44.88,'2022-10-07 16:10:08','',''),(7141,'1','274','1',1,'Retail Sale Id 6959',1700.16,0.00,0.00,2.31,152.46,'2022-10-07 16:13:28','',''),(7142,'1','274','1',1,'Retail Sale Id 6960',5998.40,0.00,0.00,8.15,537.90,'2022-10-07 16:19:01','',''),(7143,'1','274','1',1,'Retail Sale Id 6961',1501.44,0.00,0.00,2.04,134.64,'2022-10-07 16:23:16','',''),(7144,'1','274','1',1,'Retail Sale Id 6962',3002.88,0.00,0.00,4.08,269.28,'2022-10-07 16:31:28','',''),(7145,'1','274','1',1,'Retail Sale Id 6963',8103.36,0.00,0.00,11.01,726.66,'2022-10-07 16:32:47','',''),(7146,'1','274','1',1,'Retail Sale Id 6964',8000.32,0.00,0.00,10.87,717.42,'2022-10-07 16:34:24','',''),(7147,'1','274','1',1,'Retail Sale Id 6965',2252.16,0.00,0.00,3.06,201.96,'2022-10-07 16:35:18','',''),(7148,'1','274','1',1,'Retail Sale Id 6966',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 16:37:57','',''),(7149,'1','274','1',1,'Retail Sale Id 6967',8000.32,0.00,0.00,10.87,717.42,'2022-10-07 16:39:39','',''),(7150,'1','274','1',1,'Retail Sale Id 6968',1501.44,0.00,0.00,2.04,134.64,'2022-10-07 16:40:55','',''),(7151,'1','274','1',1,'Retail Sale Id 6969',2001.92,0.00,0.00,2.72,179.52,'2022-10-07 16:42:38','',''),(7152,'1','274','1',1,'Retail Sale Id 6970',3503.36,0.00,0.00,4.76,314.16,'2022-10-07 16:43:49','',''),(7153,'1','274','1',1,'Retail Sale Id 6971',18400.00,0.00,0.00,25.00,1650.00,'2022-10-07 16:53:11','',''),(7154,'1','274','1',1,'Retail Sale Id 6972',3702.08,0.00,0.00,5.03,331.98,'2022-10-07 16:57:07','',''),(7155,'1','274','1',1,'Retail Sale Id 6973',36800.00,0.00,0.00,50.00,3300.00,'2022-10-07 17:00:55','',''),(7156,'1','274','1',1,'Retail Sale Id 6974',1000.96,0.00,0.00,1.36,89.76,'2022-10-07 17:06:21','',''),(7157,'1','274','1',1,'Retail Sale Id 6975',4452.80,0.00,0.00,6.05,399.30,'2022-10-07 17:08:02','',''),(7158,'1','274','1',1,'Retail Sale Id 6977',1000.96,0.00,0.00,1.36,89.76,'2022-10-07 17:11:14','',''),(7159,'1','274','1',1,'Retail Sale Id 6978',4496.96,0.00,0.00,6.11,403.26,'2022-10-07 17:12:16','',''),(7160,'1','274','1',1,'Retail Sale Id 6979',4997.44,0.00,0.00,6.79,448.14,'2022-10-07 17:16:31','',''),(7161,'1','274','1',1,'Retail Sale Id 6980',3702.08,0.00,0.00,5.03,331.98,'2022-10-07 17:17:33','',''),(7162,'1','274','1',1,'Retail Sale Id 6981',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 17:20:34','',''),(7163,'1','274','1',1,'Retail Sale Id 6982',2252.16,0.00,0.00,3.06,201.96,'2022-10-07 17:28:53','',''),(7164,'1','274','1',1,'Retail Sale Id 6983',4496.96,0.00,0.00,6.11,403.26,'2022-10-07 17:30:38','',''),(7165,'1','274','1',1,'Retail Sale Id 6984',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 17:32:20','',''),(7166,'1','274','1',1,'Retail Sale Id 6985',2001.92,0.00,0.00,2.72,179.52,'2022-10-07 17:33:05','',''),(7167,'1','274','1',1,'Retail Sale Id 6986',2252.16,0.00,0.00,3.06,201.96,'2022-10-07 17:34:09','',''),(7168,'1','274','1',1,'Retail Sale Id 6987',802.24,0.00,0.00,1.09,71.94,'2022-10-07 17:35:20','',''),(7169,'1','274','1',1,'Retail Sale Id 6988',13652.80,0.00,0.00,18.55,1224.30,'2022-10-07 17:38:04','',''),(7170,'1','274','1',1,'Retail Sale Id 6989',14999.68,0.00,0.00,20.38,1345.08,'2022-10-07 17:41:30','',''),(7171,'1','274','1',1,'Retail Sale Id 6990',4997.44,0.00,0.00,6.79,448.14,'2022-10-07 17:42:41','',''),(7172,'1','274','1',1,'Retail Sale Id 6991',9200.00,0.00,0.00,12.50,825.00,'2022-10-07 18:07:46','',''),(7173,'1','274','1',1,'Retail Sale Id 6992',7499.84,0.00,0.00,10.19,672.54,'2022-10-07 18:12:01','',''),(7174,'1','274','1',1,'Retail Sale Id 6993',9001.28,0.00,0.00,12.23,807.18,'2022-10-07 18:20:06','',''),(7175,'1','274','1',1,'Retail Sale Id 6993',9001.28,0.00,0.00,12.23,807.18,'2022-10-07 18:20:06','',''),(7176,'1','274','1',1,'Retail Sale Id 6993',9001.28,0.00,0.00,12.23,807.18,'2022-10-07 18:20:06','',''),(7177,'1','274','1',1,'Retail Sale Id 6993',9001.28,0.00,0.00,12.23,807.18,'2022-10-07 18:20:06','',''),(7178,'1','274','1',1,'Retail Sale Id 6993',9001.28,0.00,0.00,12.23,807.18,'2022-10-07 18:20:06','',''),(7179,'1','274','1',1,'Retail Sale Id 6993',17001.60,0.00,0.00,23.10,1524.60,'2022-10-07 18:20:06','',''),(7180,'1','274','1',1,'Return of Retail Sale Id 6993',0.00,9001.28,12.23,0.00,-807.18,'2022-10-07 18:20:41','',''),(7181,'1','274','1',1,'Return of Retail Sale Id 6993',0.00,9001.28,12.23,0.00,-807.18,'2022-10-07 18:20:41','',''),(7182,'1','274','1',1,'Return of Retail Sale Id 6993',0.00,9001.28,12.23,0.00,-807.18,'2022-10-07 18:20:41','',''),(7183,'1','274','1',1,'Return of Retail Sale Id 6993',0.00,9001.28,12.23,0.00,-807.18,'2022-10-07 18:20:41','',''),(7184,'1','274','1',1,'Return of Retail Sale Id 6993',0.00,9001.28,12.23,0.00,-807.18,'2022-10-07 18:20:41','',''),(7185,'1','274','1',1,'Return of Retail Sale Id 6993',0.00,17001.60,23.10,0.00,-1524.60,'2022-10-07 18:20:41','',''),(7186,'1','274','1',1,'Retail Sale Id 6994',9001.28,0.00,0.00,12.23,807.18,'2022-10-07 18:22:10','',''),(7187,'1','274','1',1,'Retail Sale Id 6994',9001.28,0.00,0.00,12.23,807.18,'2022-10-07 18:22:10','',''),(7188,'1','274','1',1,'Retail Sale Id 6994',9001.28,0.00,0.00,12.23,807.18,'2022-10-07 18:22:10','',''),(7189,'1','274','1',1,'Retail Sale Id 6994',9001.28,0.00,0.00,12.23,807.18,'2022-10-07 18:22:10','',''),(7190,'1','274','1',1,'Retail Sale Id 6994',17001.60,0.00,0.00,23.10,1524.60,'2022-10-07 18:22:10','',''),(7191,'1','274','1',1,'Retail Sale Id 6995',2208.00,0.00,0.00,3.00,198.00,'2022-10-07 18:25:46','',''),(7192,'1','274','1',1,'Return of Retail Sale Id 6995',0.00,2208.00,3.00,0.00,-198.00,'2022-10-07 18:26:21','',''),(7193,'1','274','1',1,'Retail Sale Id 6996',3002.88,0.00,0.00,4.08,269.28,'2022-10-07 18:26:53','',''),(7194,'1','274','1',1,'Retail Sale Id 6997',2001.92,0.00,0.00,2.72,179.52,'2022-10-07 18:27:47','',''),(7195,'1','274','1',1,'Retail Sale Id 6998',55803.52,0.00,0.00,75.82,5004.12,'2022-10-07 18:36:09','',''),(7196,'1','274','1',1,'Return of Retail Sale Id 6998',0.00,55803.52,75.82,0.00,-5004.12,'2022-10-07 19:02:25','',''),(7197,'1','274','1',1,'Retail Sale Id 6999',86516.80,0.00,0.00,117.55,7758.30,'2022-10-07 19:03:40','',''),(7198,'1','274','1',1,'Retail Sale Id 7000',80717.12,0.00,0.00,109.67,7238.22,'2022-10-07 19:05:05','',''),(7199,'1','274','1',1,'Return of Retail Sale Id 6999',0.00,86516.80,117.55,0.00,-7758.30,'2022-10-07 19:10:56','',''),(7200,'1','274','1',1,'Return of Retail Sale Id 6991',0.00,9200.00,12.50,0.00,-825.00,'2022-10-07 19:12:41','',''),(7201,'1','274','1',1,'Return of Retail Sale Id 6992',0.00,7499.84,10.19,0.00,-672.54,'2022-10-07 19:13:18','',''),(7202,'1','274','1',1,'Return of Retail Sale Id 6984',0.00,9200.00,12.50,0.00,-825.00,'2022-10-07 19:14:02','',''),(7203,'1','274','1',1,'Retail Sale Id 7001',4776.64,0.00,0.00,6.49,428.34,'2022-10-07 19:15:02','',''),(7204,'1','274','1',1,'Retail Sale Id 7002',7360.00,0.00,0.00,10.00,660.00,'2022-10-08 06:23:54','',''),(7205,'1','274','1',1,'Retail Sale Id 7003',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 06:48:02','',''),(7206,'1','274','1',1,'Retail Sale Id 7004',4416.00,0.00,0.00,6.00,396.00,'2022-10-08 07:27:46','',''),(7207,'1','274','1',1,'Retail Sale Id 7005',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 08:39:03','',''),(7208,'1','274','1',1,'Retail Sale Id 7006',6462.08,0.00,0.00,8.78,579.48,'2022-10-08 08:41:32','',''),(7209,'1','274','1',1,'Retail Sale Id 7006',66240.00,0.00,0.00,90.00,5940.00,'2022-10-08 08:41:32','',''),(7210,'1','274','1',1,'Retail Sale Id 7007',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 08:43:05','',''),(7211,'1','274','1',1,'Retail Sale Id 7008',3002.88,0.00,0.00,4.08,269.28,'2022-10-08 08:44:47','',''),(7212,'1','274','1',1,'Retail Sale Id 7009',3702.08,0.00,0.00,5.03,331.98,'2022-10-08 08:45:31','',''),(7213,'1','274','1',1,'Retail Sale Id 7010',4452.80,0.00,0.00,6.05,399.30,'2022-10-08 08:50:20','',''),(7214,'1','274','1',1,'Retail Sale Id 7011',1000.96,0.00,0.00,1.36,89.76,'2022-10-08 08:52:45','',''),(7215,'1','274','1',1,'Retail Sale Id 7012',3996.48,0.00,0.00,5.43,358.38,'2022-10-08 08:53:29','',''),(7216,'1','274','1',1,'Retail Sale Id 7013',3002.88,0.00,0.00,4.08,269.28,'2022-10-08 08:54:24','',''),(7217,'1','274','1',1,'Retail Sale Id 7014',3002.88,0.00,0.00,4.08,269.28,'2022-10-08 08:56:40','',''),(7218,'1','274','1',1,'Retail Sale Id 7015',2001.92,0.00,0.00,2.72,179.52,'2022-10-08 08:57:24','',''),(7219,'1','274','1',1,'Retail Sale Id 7016',2001.92,0.00,0.00,2.72,179.52,'2022-10-08 08:58:49','',''),(7220,'1','274','1',1,'Retail Sale Id 7017',13652.80,0.00,0.00,18.55,1224.30,'2022-10-08 09:00:50','',''),(7221,'1','274','1',1,'Retail Sale Id 7018',1501.44,0.00,0.00,2.04,134.64,'2022-10-08 09:01:58','',''),(7222,'1','274','1',1,'Retail Sale Id 7019',1000.96,0.00,0.00,1.36,89.76,'2022-10-08 09:02:40','',''),(7223,'1','274','1',1,'Retail Sale Id 7020',2252.16,0.00,0.00,3.06,201.96,'2022-10-08 09:07:47','',''),(7224,'1','274','1',1,'Retail Sale Id 7021',2001.92,0.00,0.00,2.72,179.52,'2022-10-08 09:08:27','',''),(7225,'1','274','1',1,'Retail Sale Id 7022',2001.92,0.00,0.00,2.72,179.52,'2022-10-08 09:09:07','',''),(7226,'1','274','1',1,'Retail Sale Id 7023',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 09:09:45','',''),(7227,'1','274','1',1,'Retail Sale Id 7024',1501.44,0.00,0.00,2.04,134.64,'2022-10-08 09:13:44','',''),(7228,'1','274','1',1,'Retail Sale Id 7025',2001.92,0.00,0.00,2.72,179.52,'2022-10-08 09:15:44','',''),(7229,'1','274','1',1,'Retail Sale Id 7026',6999.36,0.00,0.00,9.51,627.66,'2022-10-08 09:17:23','',''),(7230,'1','274','1',1,'Retail Sale Id 7027',3702.08,0.00,0.00,5.03,331.98,'2022-10-08 09:18:48','',''),(7231,'1','274','1',1,'Retail Sale Id 7028',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 09:21:07','',''),(7232,'1','274','1',1,'Retail Sale Id 7029',3002.88,0.00,0.00,4.08,269.28,'2022-10-08 09:23:43','',''),(7233,'1','274','1',1,'Retail Sale Id 7031',2001.92,0.00,0.00,2.72,179.52,'2022-10-08 09:28:57','',''),(7234,'1','274','1',1,'Retail Sale Id 7032',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 09:30:18','',''),(7235,'1','274','1',1,'Retail Sale Id 7033',3002.88,0.00,0.00,4.08,269.28,'2022-10-08 09:31:49','',''),(7236,'1','274','1',1,'Retail Sale Id 7034',14999.68,0.00,0.00,20.38,1345.08,'2022-10-08 09:34:32','',''),(7237,'1','274','1',1,'Retail Sale Id 7035',2252.16,0.00,0.00,3.06,201.96,'2022-10-08 09:35:48','',''),(7238,'1','274','1',1,'Retail Sale Id 7036',2502.40,0.00,0.00,3.40,224.40,'2022-10-08 09:37:03','',''),(7239,'1','274','1',1,'Retail Sale Id 7037',4452.80,0.00,0.00,6.05,399.30,'2022-10-08 09:38:31','',''),(7240,'1','274','1',1,'Retail Sale Id 7038',9597.44,0.00,0.00,13.04,860.64,'2022-10-08 09:40:12','',''),(7241,'1','274','1',1,'Retail Sale Id 7039',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 09:41:21','',''),(7242,'1','274','1',1,'Retail Sale Id 7040',1501.44,0.00,0.00,2.04,134.64,'2022-10-08 09:42:25','',''),(7243,'1','274','1',1,'Retail Sale Id 7041',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 09:43:30','',''),(7244,'1','274','1',1,'Retail Sale Id 7042',4452.80,0.00,0.00,6.05,399.30,'2022-10-08 09:45:49','',''),(7245,'1','274','1',1,'Retail Sale Id 7043',4901.76,0.00,0.00,6.66,439.56,'2022-10-08 09:47:08','',''),(7246,'1','274','1',1,'Retail Sale Id 7044',9501.76,0.00,0.00,12.91,852.06,'2022-10-08 09:48:34','',''),(7247,'1','274','1',1,'Retail Sale Id 7045',3002.88,0.00,0.00,4.08,269.28,'2022-10-08 09:52:30','',''),(7248,'1','274','1',1,'Retail Sale Id 7046',1000.96,0.00,0.00,1.36,89.76,'2022-10-08 09:53:53','',''),(7249,'1','274','1',1,'Retail Sale Id 7047',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 10:00:21','',''),(7250,'1','274','1',1,'Retail Sale Id 7048',7499.84,0.00,0.00,10.19,672.54,'2022-10-08 10:02:24','',''),(7251,'1','274','1',1,'Retail Sale Id 7049',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 10:06:21','',''),(7252,'1','274','1',1,'Retail Sale Id 7050',1501.44,0.00,0.00,2.04,134.64,'2022-10-08 10:09:32','',''),(7253,'1','274','1',1,'Retail Sale Id 7051',1501.44,0.00,0.00,2.04,134.64,'2022-10-08 10:10:53','',''),(7254,'1','274','1',1,'Retail Sale Id 7052',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 10:17:13','',''),(7255,'1','274','1',1,'Retail Sale Id 7053',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 10:18:04','',''),(7256,'1','274','1',1,'Retail Sale Id 7054',2252.16,0.00,0.00,3.06,201.96,'2022-10-08 10:24:20','',''),(7257,'1','274','1',1,'Retail Sale Id 7055',802.24,0.00,0.00,1.09,71.94,'2022-10-08 10:26:34','',''),(7258,'1','274','1',1,'Retail Sale Id 7056',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 10:27:37','',''),(7259,'1','274','1',1,'Retail Sale Id 7057',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 10:28:35','',''),(7260,'1','274','1',1,'Retail Sale Id 7058',3002.88,0.00,0.00,4.08,269.28,'2022-10-08 10:29:26','',''),(7261,'1','274','1',1,'Retail Sale Id 7059',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 10:31:09','',''),(7262,'1','274','1',1,'Retail Sale Id 7060',3996.48,0.00,0.00,5.43,358.38,'2022-10-08 10:31:54','',''),(7263,'1','274','1',1,'Retail Sale Id 7061',4452.80,0.00,0.00,6.05,399.30,'2022-10-08 10:32:56','',''),(7264,'1','274','1',1,'Retail Sale Id 7062',1803.20,0.00,0.00,2.45,161.70,'2022-10-08 10:38:06','',''),(7265,'1','274','1',1,'Retail Sale Id 7063',34599.36,0.00,0.00,47.01,3102.66,'2022-10-08 10:42:13','',''),(7266,'1','274','1',1,'Retail Sale Id 7064',8000.32,0.00,0.00,10.87,717.42,'2022-10-08 10:44:44','',''),(7267,'1','274','1',1,'Retail Sale Id 7065',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 10:47:32','',''),(7268,'1','274','1',1,'Retail Sale Id 7066',1000.96,0.00,0.00,1.36,89.76,'2022-10-08 10:49:35','',''),(7269,'1','274','1',1,'Retail Sale Id 7067',3002.88,0.00,0.00,4.08,269.28,'2022-10-08 10:52:37','',''),(7270,'1','274','1',1,'Retail Sale Id 7068',18400.00,0.00,0.00,25.00,1650.00,'2022-10-08 10:55:11','',''),(7271,'1','274','1',1,'Retail Sale Id 7069',743.36,0.00,0.00,1.01,66.66,'2022-10-08 11:02:29','',''),(7272,'1','274','1',1,'Retail Sale Id 7070',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 11:05:06','',''),(7273,'1','274','1',1,'Retail Sale Id 7071',1000.96,0.00,0.00,1.36,89.76,'2022-10-08 11:07:34','',''),(7274,'1','274','1',1,'Retail Sale Id 7072',1501.44,0.00,0.00,2.04,134.64,'2022-10-08 11:08:30','',''),(7275,'1','274','1',1,'Retail Sale Id 7073',14749.44,0.00,0.00,20.04,1322.64,'2022-10-08 11:09:49','',''),(7276,'1','274','1',1,'Retail Sale Id 7074',4496.96,0.00,0.00,6.11,403.26,'2022-10-08 11:11:04','',''),(7277,'1','274','1',1,'Retail Sale Id 7075',2252.16,0.00,0.00,3.06,201.96,'2022-10-08 11:12:00','',''),(7278,'1','274','1',1,'Retail Sale Id 7076',55200.00,0.00,0.00,75.00,4950.00,'2022-10-08 11:12:49','',''),(7279,'1','274','1',1,'Retail Sale Id 7077',8500.80,0.00,0.00,11.55,762.30,'2022-10-08 11:14:41','',''),(7280,'1','274','1',1,'Retail Sale Id 7078',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 11:15:27','',''),(7281,'1','274','1',1,'Retail Sale Id 7079',5998.40,0.00,0.00,8.15,537.90,'2022-10-08 11:16:42','',''),(7282,'1','274','1',1,'Retail Sale Id 7080',2502.40,0.00,0.00,3.40,224.40,'2022-10-08 11:17:31','',''),(7283,'1','274','1',1,'Retail Sale Id 7081',1000.96,0.00,0.00,1.36,89.76,'2022-10-08 11:19:46','',''),(7284,'1','274','1',1,'Retail Sale Id 7082',2252.16,0.00,0.00,3.06,201.96,'2022-10-08 11:20:39','',''),(7285,'1','274','1',1,'Retail Sale Id 7083',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 11:23:52','',''),(7286,'1','274','1',1,'Retail Sale Id 7084',1501.44,0.00,0.00,2.04,134.64,'2022-10-08 11:33:37','',''),(7287,'1','274','1',1,'Retail Sale Id 7085',3002.88,0.00,0.00,4.08,269.28,'2022-10-08 11:35:03','',''),(7288,'1','274','1',1,'Retail Sale Id 7086',2001.92,0.00,0.00,2.72,179.52,'2022-10-08 11:36:53','',''),(7289,'1','274','1',1,'Retail Sale Id 7087',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 11:37:44','',''),(7290,'1','274','1',1,'Retail Sale Id 7089',3702.08,0.00,0.00,5.03,331.98,'2022-10-08 11:39:42','',''),(7291,'1','274','1',1,'Retail Sale Id 7090',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 11:40:56','',''),(7292,'1','274','1',1,'Retail Sale Id 7091',1501.44,0.00,0.00,2.04,134.64,'2022-10-08 11:41:56','',''),(7293,'1','274','1',1,'Retail Sale Id 7092',4997.44,0.00,0.00,6.79,448.14,'2022-10-08 11:45:42','',''),(7294,'1','274','1',1,'Retail Sale Id 7093',4496.96,0.00,0.00,6.11,403.26,'2022-10-08 11:48:19','',''),(7295,'1','274','1',1,'Retail Sale Id 7094',4496.96,0.00,0.00,6.11,403.26,'2022-10-08 11:51:51','',''),(7296,'1','274','1',1,'Retail Sale Id 7095',4496.96,0.00,0.00,6.11,403.26,'2022-10-08 11:55:47','',''),(7297,'1','274','1',1,'Retail Sale Id 7096',9001.28,0.00,0.00,12.23,807.18,'2022-10-08 11:58:48','',''),(7298,'1','274','1',1,'Retail Sale Id 7097',2208.00,0.00,0.00,3.00,198.00,'2022-10-08 12:06:18','',''),(7299,'1','274','1',1,'Retail Sale Id 7098',3002.88,0.00,0.00,4.08,269.28,'2022-10-08 12:07:15','',''),(7300,'1','274','1',1,'Retail Sale Id 7099',9001.28,0.00,0.00,12.23,807.18,'2022-10-08 12:10:39','',''),(7301,'1','274','1',1,'Retail Sale Id 7100',29447.36,0.00,0.00,40.01,2640.66,'2022-10-08 12:16:09','',''),(7302,'1','274','1',1,'Retail Sale Id 7101',3996.48,0.00,0.00,5.43,358.38,'2022-10-08 12:20:57','',''),(7303,'1','274','1',1,'Retail Sale Id 7102',2001.92,0.00,0.00,2.72,179.52,'2022-10-08 12:24:06','',''),(7304,'1','274','1',1,'Retail Sale Id 7104',1000.96,0.00,0.00,1.36,89.76,'2022-10-08 12:27:01','',''),(7305,'1','274','1',1,'Retail Sale Id 7105',18400.00,0.00,0.00,25.00,1650.00,'2022-10-08 12:29:13','',''),(7306,'1','274','1',1,'Retail Sale Id 7106',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 12:32:35','',''),(7307,'1','274','1',1,'Retail Sale Id 7107',1000.96,0.00,0.00,1.36,89.76,'2022-10-08 12:33:33','',''),(7308,'1','274','1',1,'Retail Sale Id 7108',4452.80,0.00,0.00,6.05,399.30,'2022-10-08 12:37:18','',''),(7309,'1','274','1',1,'Retail Sale Id 7109',18400.00,0.00,0.00,25.00,1650.00,'2022-10-08 12:41:42','',''),(7310,'1','274','1',1,'Retail Sale Id 7110',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 12:42:53','',''),(7311,'1','274','1',1,'Retail Sale Id 7111',2001.92,0.00,0.00,2.72,179.52,'2022-10-08 12:44:31','',''),(7312,'1','274','1',1,'Retail Sale Id 7112',3996.48,0.00,0.00,5.43,358.38,'2022-10-08 12:50:49','',''),(7313,'1','274','1',1,'Retail Sale Id 7113',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 12:54:31','',''),(7314,'1','274','1',1,'Retail Sale Id 7114',1501.44,0.00,0.00,2.04,134.64,'2022-10-08 12:55:21','',''),(7315,'1','274','1',1,'Retail Sale Id 7115',1000.96,0.00,0.00,1.36,89.76,'2022-10-08 13:03:43','',''),(7316,'1','274','1',1,'Retail Sale Id 7116',3002.88,0.00,0.00,4.08,269.28,'2022-10-08 13:04:37','',''),(7317,'1','274','1',1,'Retail Sale Id 7117',13652.80,0.00,0.00,18.55,1224.30,'2022-10-08 13:06:12','',''),(7318,'1','274','1',1,'Retail Sale Id 7118',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 13:08:46','',''),(7319,'1','274','1',1,'Retail Sale Id 7119',2796.80,0.00,0.00,3.80,250.80,'2022-10-08 13:10:13','',''),(7320,'1','274','1',1,'Retail Sale Id 7120',3680.00,0.00,0.00,5.00,330.00,'2022-10-08 13:15:57','',''),(7321,'1','274','1',1,'Retail Sale Id 7121',3702.08,0.00,0.00,5.03,331.98,'2022-10-08 13:17:52','',''),(7322,'1','274','1',1,'Retail Sale Id 7122',5998.40,0.00,0.00,8.15,537.90,'2022-10-08 13:18:38','',''),(7323,'1','274','1',1,'Retail Sale Id 7123',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 13:19:36','',''),(7324,'1','274','1',1,'Retail Sale Id 7124',2001.92,0.00,0.00,2.72,179.52,'2022-10-08 13:20:19','',''),(7325,'1','274','1',1,'Retail Sale Id 7125',2001.92,0.00,0.00,2.72,179.52,'2022-10-08 13:26:42','',''),(7326,'1','274','1',1,'Retail Sale Id 7126',4496.96,0.00,0.00,6.11,403.26,'2022-10-08 13:29:16','',''),(7327,'1','274','1',1,'Retail Sale Id 7127',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 13:31:53','',''),(7328,'1','274','1',1,'Retail Sale Id 7128',4496.96,0.00,0.00,6.11,403.26,'2022-10-08 13:33:06','',''),(7329,'1','274','1',1,'Retail Sale Id 7129',1472.00,0.00,0.00,2.00,132.00,'2022-10-08 13:34:36','',''),(7330,'1','274','1',1,'Retail Sale Id 7130',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 13:36:25','',''),(7331,'1','274','1',1,'Retail Sale Id 7131',2208.00,0.00,0.00,3.00,198.00,'2022-10-08 13:37:37','',''),(7332,'1','274','1',1,'Retail Sale Id 7132',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 13:42:28','',''),(7333,'1','274','1',1,'Retail Sale Id 7133',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 13:46:46','',''),(7334,'1','274','1',1,'Retail Sale Id 7135',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 13:51:30','',''),(7335,'1','274','1',1,'Retail Sale Id 7136',2502.40,0.00,0.00,3.40,224.40,'2022-10-08 13:52:26','',''),(7336,'1','274','1',1,'Retail Sale Id 7137',1000.96,0.00,0.00,1.36,89.76,'2022-10-08 13:55:36','',''),(7337,'1','274','1',1,'Retail Sale Id 7138',1000.96,0.00,0.00,1.36,89.76,'2022-10-08 13:58:45','',''),(7338,'1','274','1',1,'Retail Sale Id 7139',4997.44,0.00,0.00,6.79,448.14,'2022-10-08 13:59:47','',''),(7339,'1','274','1',1,'Retail Sale Id 7140',1501.44,0.00,0.00,2.04,134.64,'2022-10-08 14:00:49','',''),(7340,'1','274','1',1,'Retail Sale Id 7141',3503.36,0.00,0.00,4.76,314.16,'2022-10-08 14:03:46','',''),(7341,'1','274','1',1,'Retail Sale Id 7142',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 14:05:16','',''),(7342,'1','274','1',1,'Retail Sale Id 7143',2001.92,0.00,0.00,2.72,179.52,'2022-10-08 14:07:10','',''),(7343,'1','274','1',1,'Retail Sale Id 7144',2001.92,0.00,0.00,2.72,179.52,'2022-10-08 14:15:44','',''),(7344,'1','274','1',1,'Retail Sale Id 7145',3002.88,0.00,0.00,4.08,269.28,'2022-10-08 14:19:36','',''),(7345,'1','274','1',1,'Retail Sale Id 7146',18400.00,0.00,0.00,25.00,1650.00,'2022-10-08 14:25:39','',''),(7346,'1','274','1',1,'Retail Sale Id 7147',1501.44,0.00,0.00,2.04,134.64,'2022-10-08 14:26:35','',''),(7347,'1','274','1',1,'Retail Sale Id 7148',182910.72,0.00,0.00,248.52,16402.32,'2022-10-08 14:28:10','',''),(7348,'1','274','1',1,'Return of Retail Sale Id 7148',0.00,182910.72,248.52,0.00,-16402.32,'2022-10-08 14:28:29','',''),(7349,'1','274','1',1,'Retail Sale Id 7149',147200.00,0.00,0.00,200.00,13200.00,'2022-10-08 14:28:58','',''),(7350,'1','274','1',1,'Retail Sale Id 7150',4452.80,0.00,0.00,6.05,399.30,'2022-10-08 14:32:02','',''),(7351,'1','274','1',1,'Retail Sale Id 7151',18400.00,0.00,0.00,25.00,1650.00,'2022-10-08 14:37:11','',''),(7352,'1','274','1',1,'Retail Sale Id 7152',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 14:39:48','',''),(7353,'1','274','1',1,'Retail Sale Id 7153',2001.92,0.00,0.00,2.72,179.52,'2022-10-08 14:42:26','',''),(7354,'1','274','1',1,'Retail Sale Id 7154',4452.80,0.00,0.00,6.05,399.30,'2022-10-08 14:45:36','',''),(7355,'1','274','1',1,'Retail Sale Id 7155',2252.16,0.00,0.00,3.06,201.96,'2022-10-08 14:49:25','',''),(7356,'1','274','1',1,'Retail Sale Id 7156',3996.48,0.00,0.00,5.43,358.38,'2022-10-08 14:50:58','',''),(7357,'1','274','1',1,'Retail Sale Id 7157',1501.44,0.00,0.00,2.04,134.64,'2022-10-08 14:51:46','',''),(7358,'1','274','1',1,'Retail Sale Id 7158',3702.08,0.00,0.00,5.03,331.98,'2022-10-08 14:56:21','',''),(7359,'1','274','1',1,'Retail Sale Id 7159',897.92,0.00,0.00,1.22,80.52,'2022-10-08 14:59:54','',''),(7360,'1','274','1',1,'Retail Sale Id 7160',1501.44,0.00,0.00,2.04,134.64,'2022-10-08 15:04:25','',''),(7361,'1','274','1',1,'Retail Sale Id 7161',3996.48,0.00,0.00,5.43,358.38,'2022-10-08 15:23:26','',''),(7362,'1','274','1',1,'Retail Sale Id 7162',1501.44,0.00,0.00,2.04,134.64,'2022-10-08 15:41:12','',''),(7363,'1','274','1',1,'Retail Sale Id 7163',1000.96,0.00,0.00,1.36,89.76,'2022-10-08 15:43:02','',''),(7364,'1','274','1',1,'Retail Sale Id 7164',18400.00,0.00,0.00,25.00,1650.00,'2022-10-08 15:44:12','',''),(7365,'1','274','1',1,'Retail Sale Id 7165',2001.92,0.00,0.00,2.72,179.52,'2022-10-08 15:49:57','',''),(7366,'1','274','1',1,'Retail Sale Id 7166',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 15:53:07','',''),(7367,'1','274','1',1,'Retail Sale Id 7167',6498.88,0.00,0.00,8.83,582.78,'2022-10-08 15:56:02','',''),(7368,'1','274','1',1,'Retail Sale Id 7168',3002.88,0.00,0.00,4.08,269.28,'2022-10-08 15:57:28','',''),(7369,'1','274','1',1,'Retail Sale Id 7169',2252.16,0.00,0.00,3.06,201.96,'2022-10-08 15:58:58','',''),(7370,'1','274','1',1,'Retail Sale Id 7170',3996.48,0.00,0.00,5.43,358.38,'2022-10-08 15:59:54','',''),(7371,'1','274','1',1,'Retail Sale Id 7171',1000.96,0.00,0.00,1.36,89.76,'2022-10-08 16:00:24','',''),(7372,'1','274','1',1,'Retail Sale Id 7172',4496.96,0.00,0.00,6.11,403.26,'2022-10-08 16:01:28','',''),(7373,'1','274','1',1,'Retail Sale Id 7173',2252.16,0.00,0.00,3.06,201.96,'2022-10-08 16:02:12','',''),(7374,'1','274','1',1,'Retail Sale Id 7174',1000.96,0.00,0.00,1.36,89.76,'2022-10-08 16:03:09','',''),(7375,'1','274','1',1,'Retail Sale Id 7175',3702.08,0.00,0.00,5.03,331.98,'2022-10-08 16:03:57','',''),(7376,'1','274','1',1,'Retail Sale Id 7176',1000.96,0.00,0.00,1.36,89.76,'2022-10-08 16:04:44','',''),(7377,'1','274','1',1,'Retail Sale Id 7177',2001.92,0.00,0.00,2.72,179.52,'2022-10-08 16:05:27','',''),(7378,'1','274','1',1,'Retail Sale Id 7178',11040.00,0.00,0.00,15.00,990.00,'2022-10-08 16:06:40','',''),(7379,'1','274','1',1,'Retail Sale Id 7179',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 16:08:25','',''),(7380,'1','274','1',1,'Retail Sale Id 7180',2200.64,0.00,0.00,2.99,197.34,'2022-10-08 16:10:39','',''),(7381,'1','274','1',1,'Retail Sale Id 7181',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 16:12:21','',''),(7382,'1','274','1',1,'Retail Sale Id 7182',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 16:13:41','',''),(7383,'1','274','1',1,'Retail Sale Id 7183',4997.44,0.00,0.00,6.79,448.14,'2022-10-08 16:15:15','',''),(7384,'1','274','1',1,'Retail Sale Id 7184',2208.00,0.00,0.00,3.00,198.00,'2022-10-08 16:17:30','',''),(7385,'1','274','1',1,'Retail Sale Id 7185',1000.96,0.00,0.00,1.36,89.76,'2022-10-08 16:19:37','',''),(7386,'1','274','1',1,'Retail Sale Id 7186',4496.96,0.00,0.00,6.11,403.26,'2022-10-08 16:21:15','',''),(7387,'1','274','1',1,'Retail Sale Id 7187',4401.28,0.00,0.00,5.98,394.68,'2022-10-08 16:23:42','',''),(7388,'1','274','1',1,'Retail Sale Id 7188',1000.96,0.00,0.00,1.36,89.76,'2022-10-08 16:24:50','',''),(7389,'1','274','1',1,'Retail Sale Id 7188',1501.44,0.00,0.00,2.04,134.64,'2022-10-08 16:24:50','',''),(7390,'1','274','1',1,'Retail Sale Id 7189',3002.88,0.00,0.00,4.08,269.28,'2022-10-08 16:25:43','',''),(7391,'1','274','1',1,'Retail Sale Id 7190',17664.00,0.00,0.00,24.00,1584.00,'2022-10-08 16:27:21','',''),(7392,'1','274','1',1,'Retail Sale Id 7191',2001.92,0.00,0.00,2.72,179.52,'2022-10-08 16:28:26','',''),(7393,'1','274','1',1,'Retail Sale Id 7192',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 16:29:49','',''),(7394,'1','274','1',1,'Retail Sale Id 7193',3680.00,0.00,0.00,5.00,330.00,'2022-10-08 16:31:50','',''),(7395,'1','274','1',1,'Retail Sale Id 7194',3002.88,0.00,0.00,4.08,269.28,'2022-10-08 16:33:24','',''),(7396,'1','274','1',1,'Retail Sale Id 7195',1501.44,0.00,0.00,2.04,134.64,'2022-10-08 16:34:12','',''),(7397,'1','274','1',1,'Retail Sale Id 7196',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 16:39:11','',''),(7398,'1','274','1',1,'Retail Sale Id 7197',2001.92,0.00,0.00,2.72,179.52,'2022-10-08 16:43:01','',''),(7399,'1','274','1',1,'Retail Sale Id 7198',4997.44,0.00,0.00,6.79,448.14,'2022-10-08 16:43:42','',''),(7400,'1','274','1',1,'Retail Sale Id 7199',8000.32,0.00,0.00,10.87,717.42,'2022-10-08 16:44:23','',''),(7401,'1','274','1',1,'Retail Sale Id 7200',699.20,0.00,0.00,0.95,62.70,'2022-10-08 16:44:51','',''),(7402,'1','274','1',1,'Retail Sale Id 7201',2502.40,0.00,0.00,3.40,224.40,'2022-10-08 16:45:21','',''),(7403,'1','274','1',1,'Retail Sale Id 7202',3996.48,0.00,0.00,5.43,358.38,'2022-10-08 16:45:50','',''),(7404,'1','274','1',1,'Retail Sale Id 7204',2303.68,0.00,0.00,3.13,206.58,'2022-10-08 16:50:03','',''),(7405,'1','274','1',1,'Retail Sale Id 7205',2944.00,0.00,0.00,4.00,264.00,'2022-10-08 16:51:32','',''),(7406,'1','274','1',1,'Retail Sale Id 7206',1700.16,0.00,0.00,2.31,152.46,'2022-10-08 16:53:57','',''),(7407,'1','274','1',1,'Retail Sale Id 7207',2001.92,0.00,0.00,2.72,179.52,'2022-10-08 16:54:33','',''),(7408,'1','274','1',1,'Retail Sale Id 7208',73600.00,0.00,0.00,100.00,6600.00,'2022-10-08 16:56:01','',''),(7409,'1','274','1',1,'Retail Sale Id 7209',9803.52,0.00,0.00,13.32,879.12,'2022-10-08 16:57:21','',''),(7410,'1','274','1',1,'Retail Sale Id 7210',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 17:00:11','',''),(7411,'1','274','1',1,'Retail Sale Id 7211',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 17:02:14','',''),(7412,'1','274','1',1,'Retail Sale Id 7212',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 17:03:59','',''),(7413,'1','274','1',1,'Retail Sale Id 7213',3702.08,0.00,0.00,5.03,331.98,'2022-10-08 17:11:07','',''),(7414,'1','274','1',1,'Retail Sale Id 7214',3002.88,0.00,0.00,4.08,269.28,'2022-10-08 17:12:27','',''),(7415,'1','274','1',1,'Retail Sale Id 7215',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 17:13:52','',''),(7416,'1','274','1',1,'Retail Sale Id 7216',1501.44,0.00,0.00,2.04,134.64,'2022-10-08 17:14:40','',''),(7417,'1','274','1',1,'Retail Sale Id 7217',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 17:20:46','',''),(7418,'1','274','1',1,'Retail Sale Id 7218',3002.88,0.00,0.00,4.08,269.28,'2022-10-08 17:26:55','',''),(7419,'1','274','1',1,'Retail Sale Id 7219',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 17:28:34','',''),(7420,'1','274','1',1,'Retail Sale Id 7220',18400.00,0.00,0.00,25.00,1650.00,'2022-10-08 17:30:02','',''),(7421,'1','274','1',1,'Retail Sale Id 7221',2502.40,0.00,0.00,3.40,224.40,'2022-10-08 17:31:40','',''),(7422,'1','274','1',1,'Retail Sale Id 7222',4496.96,0.00,0.00,6.11,403.26,'2022-10-08 17:33:24','',''),(7423,'1','274','1',1,'Retail Sale Id 7223',3996.48,0.00,0.00,5.43,358.38,'2022-10-08 17:38:13','',''),(7424,'1','274','1',1,'Retail Sale Id 7224',1501.44,0.00,0.00,2.04,134.64,'2022-10-08 17:40:20','',''),(7425,'1','274','1',1,'Retail Sale Id 7225',4496.96,0.00,0.00,6.11,403.26,'2022-10-08 17:41:09','',''),(7426,'1','274','1',1,'Retail Sale Id 7226',2303.68,0.00,0.00,3.13,206.58,'2022-10-08 17:42:03','',''),(7427,'1','274','1',1,'Retail Sale Id 7227',34599.36,0.00,0.00,47.01,3102.66,'2022-10-08 17:48:28','',''),(7428,'1','274','1',1,'Retail Sale Id 7228',4496.96,0.00,0.00,6.11,403.26,'2022-10-08 17:49:22','',''),(7429,'1','274','1',1,'Retail Sale Id 7229',12548.80,0.00,0.00,17.05,1125.30,'2022-10-08 17:50:18','',''),(7430,'1','274','1',1,'Retail Sale Id 7230',3002.88,0.00,0.00,4.08,269.28,'2022-10-08 17:52:16','',''),(7431,'1','274','1',1,'Retail Sale Id 7231',3702.08,0.00,0.00,5.03,331.98,'2022-10-08 17:53:18','',''),(7432,'1','274','1',1,'Retail Sale Id 7232',7396.80,0.00,0.00,10.05,663.30,'2022-10-08 17:54:21','',''),(7433,'1','274','1',1,'Retail Sale Id 7233',2252.16,0.00,0.00,3.06,201.96,'2022-10-08 17:56:01','',''),(7434,'1','274','1',1,'Retail Sale Id 7234',3996.48,0.00,0.00,5.43,358.38,'2022-10-08 17:56:47','',''),(7435,'1','274','1',1,'Retail Sale Id 7236',4496.96,0.00,0.00,6.11,403.26,'2022-10-08 18:00:15','',''),(7436,'1','274','1',1,'Retail Sale Id 7237',8000.32,0.00,0.00,10.87,717.42,'2022-10-08 18:02:03','',''),(7437,'1','274','1',1,'Retail Sale Id 7238',1000.96,0.00,0.00,1.36,89.76,'2022-10-08 18:06:51','',''),(7438,'1','274','1',1,'Retail Sale Id 7239',9200.00,0.00,0.00,12.50,825.00,'2022-10-08 18:09:05','',''),(7439,'1','274','1',1,'Retail Sale Id 7240',2502.40,0.00,0.00,3.40,224.40,'2022-10-08 18:11:06','',''),(7440,'1','274','1',1,'Retail Sale Id 7242',4496.96,0.00,0.00,6.11,403.26,'2022-10-08 18:15:32','',''),(7441,'1','274','1',1,'Retail Sale Id 7243',3002.88,0.00,0.00,4.08,269.28,'2022-10-08 18:16:57','',''),(7442,'1','274','1',1,'Retail Sale Id 7244',17112.00,0.00,0.00,23.25,1534.50,'2022-10-08 19:09:44','',''),(7443,'1','274','1',1,'Retail Sale Id 7245',85125.76,0.00,0.00,115.66,7633.56,'2022-10-08 19:11:31','',''),(7444,'1','274','1',1,'Retail Sale Id 7247',9550.00,0.00,0.00,12.50,1175.00,'2022-10-09 06:39:27','',''),(7445,'1','274','1',1,'Retail Sale Id 7248',11460.00,0.00,0.00,15.00,1410.00,'2022-10-09 07:08:00','',''),(7446,'1','274','1',1,'Retail Sale Id 7249',2299.64,0.00,0.00,3.01,282.94,'2022-10-09 07:15:26','',''),(7447,'1','274','1',1,'Retail Sale Id 7251',1497.44,0.00,0.00,1.96,184.24,'2022-10-09 07:20:10','',''),(7448,'1','274','1',1,'Retail Sale Id 7252',1000.84,0.00,0.00,1.31,123.14,'2022-10-09 07:21:26','',''),(7449,'1','274','1',1,'Retail Sale Id 7254',6501.64,0.00,0.00,8.51,799.94,'2022-10-09 07:23:24','',''),(7450,'1','274','1',1,'Retail Sale Id 7256',2498.28,0.00,0.00,3.27,307.38,'2022-10-09 07:31:30','',''),(7451,'1','274','1',1,'Retail Sale Id 7258',1497.44,0.00,0.00,1.96,184.24,'2022-10-09 07:32:38','',''),(7452,'1','274','1',1,'Retail Sale Id 7259',3797.08,0.00,0.00,4.97,467.18,'2022-10-09 07:34:31','',''),(7453,'1','274','1',1,'Retail Sale Id 7260',1497.44,0.00,0.00,1.96,184.24,'2022-10-09 07:35:40','',''),(7454,'1','274','1',1,'Retail Sale Id 7261',4003.36,0.00,0.00,5.24,492.56,'2022-10-09 07:42:41','',''),(7455,'1','274','1',1,'Retail Sale Id 7263',1000.84,0.00,0.00,1.31,123.14,'2022-10-09 07:45:41','',''),(7456,'1','274','1',1,'Retail Sale Id 7264',76400.00,0.00,0.00,100.00,9400.00,'2022-10-09 07:46:54','',''),(7457,'1','274','1',1,'Retail Sale Id 7265',1000.84,0.00,0.00,1.31,123.14,'2022-10-09 07:49:34','',''),(7458,'1','274','1',1,'Retail Sale Id 7266',45840.00,0.00,0.00,60.00,5640.00,'2022-10-09 07:50:44','',''),(7459,'1','274','1',1,'Retail Sale Id 7267',9496.52,0.00,0.00,12.43,1168.42,'2022-10-09 07:52:44','',''),(7460,'1','274','1',1,'Retail Sale Id 7268',2001.68,0.00,0.00,2.62,246.28,'2022-10-09 07:54:23','',''),(7461,'1','274','1',1,'Retail Sale Id 7269',3896.40,0.00,0.00,5.10,479.40,'2022-10-09 07:55:57','',''),(7462,'1','274','1',1,'Retail Sale Id 7270',15280.00,0.00,0.00,20.00,1880.00,'2022-10-09 07:58:19','',''),(7463,'1','274','1',1,'Retail Sale Id 7272',2292.00,0.00,0.00,3.00,282.00,'2022-10-09 08:00:39','',''),(7464,'1','274','1',1,'Retail Sale Id 7273',764.00,0.00,0.00,1.00,94.00,'2022-10-09 08:03:52','',''),(7465,'1','274','1',1,'Retail Sale Id 7274',1780.12,0.00,0.00,2.33,219.02,'2022-10-09 08:09:04','',''),(7466,'1','274','1',1,'Return of Retail Sale Id 7266',0.00,45840.00,60.00,0.00,-5640.00,'2022-10-09 08:33:49','',''),(7467,'1','274','1',1,'Return of Retail Sale Id 7270',0.00,15280.00,20.00,0.00,-1880.00,'2022-10-09 08:35:41','',''),(7468,'1','274','1',1,'Retail Sale Id 7280',23997.24,0.00,0.00,31.41,2952.54,'2022-10-09 08:36:58','',''),(7469,'1','274','1',1,'Retail Sale Id 7281',29612.64,0.00,0.00,38.76,3643.44,'2022-10-09 08:38:37','',''),(7470,'1','274','1',1,'Retail Sale Id 7282',7005.88,0.00,0.00,9.17,861.98,'2022-10-09 08:42:20','',''),(7471,'1','274','1',1,'Return of Retail Sale Id 7247',0.00,9550.00,12.50,0.00,-1175.00,'2022-10-09 08:45:24','',''),(7472,'1','274','1',1,'Retail Sale Id 7283',9550.00,0.00,0.00,12.50,1175.00,'2022-10-10 15:48:21','',''),(7473,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,2525900.00,3770.00,0.00,0.00,'2022-10-10 16:16:25','',''),(7474,'1','274',NULL,1,'Reception corrector for bridging 60',0.00,0.00,0.00,3770.00,0.00,'2022-10-10 16:18:19','',''),(7475,'1','274','1',1,'Received from bridging 60',0.00,0.00,3770.00,0.00,0.00,'2022-10-10 16:18:19','',''),(7476,'1','274','1',1,'Retail Sale Id 7284',38001.36,0.00,0.00,49.74,4675.56,'2022-10-10 16:26:00','',''),(7477,'1','274','1',1,'Retail Sale Id 7286',4996.56,0.00,0.00,6.54,614.76,'2022-10-10 16:29:57','',''),(7478,'1','274','1',1,'Retail Sale Id 7286',19100.00,0.00,0.00,25.00,2350.00,'2022-10-10 16:29:57','',''),(7479,'1','274','1',1,'Retail Sale Id 7288',1497.44,0.00,0.00,1.96,184.24,'2022-10-10 16:31:00','',''),(7480,'1','274','1',1,'Retail Sale Id 7289',4599.28,0.00,0.00,6.02,565.88,'2022-10-10 16:49:24','',''),(7481,'1','274','1',1,'Retail Sale Id 7289',8396.36,0.00,0.00,10.99,1033.06,'2022-10-10 16:49:24','',''),(7482,'1','274','1',1,'Retail Sale Id 7290',2001.68,0.00,0.00,2.62,246.28,'2022-10-10 16:51:13','',''),(7483,'1','274','1',1,'Retail Sale Id 7291',802.20,0.00,0.00,1.05,98.70,'2022-10-10 16:53:24','',''),(7484,'1','274','1',1,'Retail Sale Id 7293',9550.00,0.00,0.00,12.50,1175.00,'2022-10-10 16:58:04','',''),(7485,'1','274','1',1,'Retail Sale Id 7294',5997.40,0.00,0.00,7.85,737.90,'2022-10-10 17:03:20','',''),(7486,'1','274','1',1,'Retail Sale Id 7295',7999.08,0.00,0.00,10.47,984.18,'2022-10-10 17:05:59','',''),(7487,'1','274','1',1,'Retail Sale Id 7296',1497.44,0.00,0.00,1.96,184.24,'2022-10-10 17:13:17','',''),(7488,'1','274','1',1,'Retail Sale Id 7297',9496.52,0.00,0.00,12.43,1168.42,'2022-10-10 17:14:56','',''),(7489,'1','274','1',1,'Retail Sale Id 7298',19100.00,0.00,0.00,25.00,2350.00,'2022-10-10 17:18:31','',''),(7490,'1','274','1',1,'Retail Sale Id 7300',764.00,0.00,0.00,1.00,94.00,'2022-10-10 17:20:38','',''),(7491,'1','274','1',1,'Retail Sale Id 7301',9550.00,0.00,0.00,12.50,1175.00,'2022-10-10 17:21:41','',''),(7492,'1','274','1',1,'Retail Sale Id 7303',9550.00,0.00,0.00,12.50,1175.00,'2022-10-10 17:23:25','',''),(7493,'1','274','1',1,'Retail Sale Id 7304',7701.12,0.00,0.00,10.08,947.52,'2022-10-10 17:25:40','',''),(7494,'1','274','1',1,'Retail Sale Id 7305',9550.00,0.00,0.00,12.50,1175.00,'2022-10-10 17:27:43','',''),(7495,'1','274','1',1,'Retail Sale Id 7306',54801.72,0.00,0.00,71.73,6742.62,'2022-10-10 17:31:17','',''),(7496,'1','274','1',1,'Retail Sale Id 7307',57300.00,0.00,0.00,75.00,7050.00,'2022-10-10 17:36:58','',''),(7497,'1','274','1',1,'Retail Sale Id 7308',2292.00,0.00,0.00,3.00,282.00,'2022-10-10 17:40:35','',''),(7498,'1','274','1',1,'Retail Sale Id 7309',9550.00,0.00,0.00,12.50,1175.00,'2022-10-10 17:43:42','',''),(7499,'1','274','1',1,'Retail Sale Id 7310',47750.00,0.00,0.00,62.50,5875.00,'2022-10-10 17:53:47','',''),(7500,'1','274','1',1,'Retail Sale Id 7311',34380.00,0.00,0.00,45.00,4230.00,'2022-10-10 17:55:39','',''),(7501,'1','274','1',1,'Retail Sale Id 7312',1000.84,0.00,0.00,1.31,123.14,'2022-10-10 17:59:55','',''),(7502,'1','274','1',1,'Retail Sale Id 7313',9550.00,0.00,0.00,12.50,1175.00,'2022-10-10 18:01:38','',''),(7503,'1','274','1',1,'Retail Sale Id 7315',1000.84,0.00,0.00,1.31,123.14,'2022-10-10 18:08:29','',''),(7504,'1','274','1',1,'Retail Sale Id 7316',4996.56,0.00,0.00,6.54,614.76,'2022-10-10 18:13:48','',''),(7505,'1','274','1',1,'Retail Sale Id 7317',38200.00,0.00,0.00,50.00,4700.00,'2022-10-10 18:16:35','',''),(7506,'1','274','1',1,'Retail Sale Id 7318',2001.68,0.00,0.00,2.62,246.28,'2022-10-10 18:21:27','',''),(7507,'1','274','1',1,'Return of Retail Sale Id 7317',0.00,38200.00,50.00,0.00,-4700.00,'2022-10-10 18:48:05','',''),(7508,'1','274','1',1,'Return of Retail Sale Id 7310',0.00,47750.00,62.50,0.00,-5875.00,'2022-10-10 18:48:40','',''),(7509,'1','274','1',1,'Return of Retail Sale Id 7311',0.00,34380.00,45.00,0.00,-4230.00,'2022-10-10 18:49:11','',''),(7510,'1','274','1',1,'Return of Retail Sale Id 7313',0.00,9550.00,12.50,0.00,-1175.00,'2022-10-10 18:49:58','',''),(7511,'1','274','1',1,'Return of Retail Sale Id 7309',0.00,9550.00,12.50,0.00,-1175.00,'2022-10-10 18:51:15','',''),(7512,'1','274','1',1,'Retail Sale Id 7319',870.96,0.00,0.00,1.14,107.16,'2022-10-10 18:52:53','',''),(7513,'1','274','1',1,'Retail Sale Id 7320',92405.80,0.00,0.00,120.95,11369.30,'2022-10-10 18:54:32','',''),(7514,'1','274','1',1,'Retail Sale Id 7321',9550.00,0.00,0.00,12.50,1175.00,'2022-10-11 07:19:16','',''),(7515,'1','274','1',1,'Retail Sale Id 7322',3056.00,0.00,0.00,4.00,376.00,'2022-10-11 07:21:13','',''),(7516,'1','274','1',1,'Retail Sale Id 7323',42050.56,0.00,0.00,55.04,5173.76,'2022-10-11 08:35:08','',''),(7517,'1','274','1',1,'Retail Sale Id 7324',3850.56,0.00,0.00,5.04,473.76,'2022-10-11 08:35:49','',''),(7518,'1','274','1',1,'Retail Sale Id 7325',9550.00,0.00,0.00,12.50,1175.00,'2022-10-11 08:37:50','',''),(7519,'1','274','1',1,'Retail Sale Id 7327',11842.00,0.00,0.00,15.50,1457.00,'2022-10-11 09:11:32','',''),(7520,'1','274','1',1,'Retail Sale Id 7328',2498.28,0.00,0.00,3.27,307.38,'2022-10-11 09:14:13','',''),(7521,'1','274','1',1,'Retail Sale Id 7329',9550.00,0.00,0.00,12.50,1175.00,'2022-10-11 09:38:38','',''),(7522,'1','274','1',1,'Retail Sale Id 7330',4599.28,0.00,0.00,6.02,565.88,'2022-10-11 09:41:53','',''),(7523,'1','274','1',1,'Retail Sale Id 7331',1497.44,0.00,0.00,1.96,184.24,'2022-10-11 09:43:37','',''),(7524,'1','274','1',1,'Retail Sale Id 7331',1497.44,0.00,0.00,1.96,184.24,'2022-10-11 09:43:37','',''),(7525,'1','274','1',1,'Retail Sale Id 7332',9550.00,0.00,0.00,12.50,1175.00,'2022-10-11 10:19:29','',''),(7526,'1','274','1',1,'Retail Sale Id 7333',9550.00,0.00,0.00,12.50,1175.00,'2022-10-11 10:31:05','',''),(7527,'1','274','1',1,'Retail Sale Id 7334',1497.44,0.00,0.00,1.96,184.24,'2022-10-11 10:39:08','',''),(7528,'1','274','1',1,'Retail Sale Id 7335',9550.00,0.00,0.00,12.50,1175.00,'2022-10-11 10:44:38','',''),(7529,'1','274','1',1,'Retail Sale Id 7336',1000.84,0.00,0.00,1.31,123.14,'2022-10-11 10:49:36','',''),(7530,'1','274','1',1,'Retail Sale Id 7337',2498.28,0.00,0.00,3.27,307.38,'2022-10-11 10:50:24','',''),(7531,'1','274','1',1,'Retail Sale Id 7338',3002.52,0.00,0.00,3.93,369.42,'2022-10-11 12:34:44','',''),(7532,'1','274','1',1,'Retail Sale Id 7339',9550.00,0.00,0.00,12.50,1175.00,'2022-10-11 13:08:53','',''),(7533,'1','274','1',1,'Retail Sale Id 7341',4599.28,0.00,0.00,6.02,565.88,'2022-10-11 13:27:14','',''),(7534,'1','274','1',1,'Retail Sale Id 7342',19100.00,0.00,0.00,25.00,2350.00,'2022-10-11 13:35:31','',''),(7535,'1','274','1',1,'Retail Sale Id 7343',9550.00,0.00,0.00,12.50,1175.00,'2022-10-11 14:02:59','',''),(7536,'1','274','1',1,'Retail Sale Id 7344',6203.68,0.00,0.00,8.12,763.28,'2022-10-11 14:13:36','',''),(7537,'1','274','1',1,'Retail Sale Id 7346',2299.64,0.00,0.00,3.01,282.94,'2022-10-11 14:19:45','',''),(7538,'1','274','1',1,'Retail Sale Id 7348',3850.56,0.00,0.00,5.04,473.76,'2022-10-11 14:33:24','',''),(7539,'1','274','1',1,'Retail Sale Id 7349',3101.84,0.00,0.00,4.06,381.64,'2022-10-11 14:57:01','',''),(7540,'1','274','1',1,'Retail Sale Id 7350',38200.00,0.00,0.00,50.00,4700.00,'2022-10-11 14:59:48','',''),(7541,'1','274','1',1,'Retail Sale Id 7351',3101.84,0.00,0.00,4.06,381.64,'2022-10-11 15:01:39','',''),(7542,'1','274','1',1,'Retail Sale Id 7352',19100.00,0.00,0.00,25.00,2350.00,'2022-10-11 15:03:39','',''),(7543,'1','274','1',1,'Retail Sale Id 7355',2299.64,0.00,0.00,3.01,282.94,'2022-10-11 15:07:35','',''),(7544,'1','274','1',1,'Retail Sale Id 7356',2001.68,0.00,0.00,2.62,246.28,'2022-10-11 15:10:03','',''),(7545,'1','274','1',1,'Retail Sale Id 7359',9550.00,0.00,0.00,12.50,1175.00,'2022-10-11 15:12:03','',''),(7546,'1','274','1',1,'Retail Sale Id 7360',1497.44,0.00,0.00,1.96,184.24,'2022-10-11 15:21:01','',''),(7547,'1','274','1',1,'Retail Sale Id 7361',4003.36,0.00,0.00,5.24,492.56,'2022-10-11 15:23:50','',''),(7548,'1','274','1',1,'Retail Sale Id 7362',76400.00,0.00,0.00,100.00,9400.00,'2022-10-11 15:33:38','',''),(7549,'1','274','1',1,'Retail Sale Id 7363',33998.00,0.00,0.00,44.50,4183.00,'2022-10-11 15:34:28','',''),(7550,'1','274','1',1,'Retail Sale Id 7364',9550.00,0.00,0.00,12.50,1175.00,'2022-10-11 15:39:26','',''),(7551,'1','274','1',1,'Retail Sale Id 7365',1000.84,0.00,0.00,1.31,123.14,'2022-10-11 15:41:46','',''),(7552,'1','274','1',1,'Retail Sale Id 7366',2001.68,0.00,0.00,2.62,246.28,'2022-10-11 15:43:05','',''),(7553,'1','274','1',1,'Retail Sale Id 7367',2001.68,0.00,0.00,2.62,246.28,'2022-10-11 16:14:36','',''),(7554,'1','274','1',1,'Retail Sale Id 7368',4599.28,0.00,0.00,6.02,565.88,'2022-10-11 16:55:53','',''),(7555,'1','274','1',1,'Retail Sale Id 7370',7999.08,0.00,0.00,10.47,984.18,'2022-10-11 17:06:38','',''),(7556,'1','274','1',1,'Retail Sale Id 7372',42050.56,0.00,0.00,55.04,5173.76,'2022-10-11 17:11:20','',''),(7557,'1','274','1',1,'Retail Sale Id 7373',13400.56,0.00,0.00,17.54,1648.76,'2022-10-11 17:19:37','',''),(7558,'1','274','1',1,'Retail Sale Id 7374',2001.68,0.00,0.00,2.62,246.28,'2022-10-11 17:21:04','',''),(7559,'1','274','1',1,'Retail Sale Id 7375',4599.28,0.00,0.00,6.02,565.88,'2022-10-11 17:23:58','',''),(7560,'1','274','1',1,'Retail Sale Id 7376',4499.96,0.00,0.00,5.89,553.66,'2022-10-11 17:27:47','',''),(7561,'1','274','1',1,'Retail Sale Id 7377',2299.64,0.00,0.00,3.01,282.94,'2022-10-11 17:29:05','',''),(7562,'1','274','1',1,'Retail Sale Id 7378',1000.84,0.00,0.00,1.31,123.14,'2022-10-11 17:41:07','',''),(7563,'1','274','1',1,'Return of Retail Sale Id 7372',0.00,42050.56,55.04,0.00,-5173.76,'2022-10-11 18:49:36','',''),(7564,'1','274','1',1,'Return of Retail Sale Id 7373',0.00,13400.56,17.54,0.00,-1648.76,'2022-10-11 18:50:15','',''),(7565,'1','274','1',1,'Return of Retail Sale Id 7363',0.00,33998.00,44.50,0.00,-4183.00,'2022-10-11 19:01:55','',''),(7566,'1','274','1',1,'Retail Sale Id 7379',18366.56,0.00,0.00,24.04,2259.76,'2022-10-11 19:03:15','',''),(7567,'1','274','1',1,'Retail Sale Id 7380',83581.60,0.00,0.00,109.40,10283.60,'2022-10-11 19:04:22','',''),(7568,'1','274','1',1,'Retail Sale Id 7381',27997.64,0.00,0.00,37.43,2919.54,'2022-10-12 07:10:18','',''),(7569,'1','274','1',1,'Retail Sale Id 7382',3650.24,0.00,0.00,4.88,380.64,'2022-10-12 07:11:26','',''),(7570,'1','274','1',1,'Retail Sale Id 7383',9350.00,0.00,0.00,12.50,975.00,'2022-10-12 07:40:08','',''),(7571,'1','274','1',1,'Retail Sale Id 7385',30077.08,0.00,0.00,40.21,3136.38,'2022-10-12 08:24:05','',''),(7572,'1','274','1',1,'Retail Sale Id 7386',9350.00,0.00,0.00,12.50,975.00,'2022-10-12 08:43:30','',''),(7573,'1','274','1',1,'Retail Sale Id 7387',4502.96,0.00,0.00,6.02,469.56,'2022-10-12 08:44:19','',''),(7574,'1','274','1',1,'Retail Sale Id 7388',18700.00,0.00,0.00,25.00,1950.00,'2022-10-12 08:50:53','',''),(7575,'1','274','1',1,'Retail Sale Id 7390',4502.96,0.00,0.00,6.02,469.56,'2022-10-12 08:57:27','',''),(7576,'1','274','1',1,'Retail Sale Id 7391',6732.00,0.00,0.00,9.00,702.00,'2022-10-12 09:14:41','',''),(7577,'1','274','1',1,'Retail Sale Id 7392',76400.00,0.00,0.00,100.00,9400.00,'2022-10-12 09:27:45','',''),(7578,'1','274','1',1,'Return of Retail Sale Id 7392',0.00,76400.00,100.00,0.00,-9400.00,'2022-10-12 09:28:38','',''),(7579,'1','274','1',1,'Retail Sale Id 7393',2296.36,0.00,0.00,3.07,239.46,'2022-10-12 09:35:04','',''),(7580,'1','274','1',1,'Retail Sale Id 7394',74800.00,0.00,0.00,100.00,7800.00,'2022-10-12 09:36:22','',''),(7581,'1','274','1',1,'Retail Sale Id 7395',14960.00,0.00,0.00,20.00,1560.00,'2022-10-12 09:56:36','',''),(7582,'1','274','1',1,'Retail Sale Id 7396',24960.76,0.00,0.00,33.37,2602.86,'2022-10-12 10:05:15','',''),(7583,'1','274','1',1,'Retail Sale Id 7397',9350.00,0.00,0.00,12.50,975.00,'2022-10-12 10:05:38','',''),(7584,'1','274','1',1,'Return of Retail Sale Id 7381',0.00,27997.64,37.43,0.00,-2919.54,'2022-10-12 10:29:06','',''),(7585,'1','274','1',1,'Retail Sale Id 7398',27406.72,0.00,0.00,36.64,2857.92,'2022-10-12 10:30:14','',''),(7586,'1','274','1',1,'Retail Sale Id 7399',4488.00,0.00,0.00,6.00,468.00,'2022-10-12 10:44:50','',''),(7587,'1','274','1',1,'Retail Sale Id 7399',9350.00,0.00,0.00,12.50,975.00,'2022-10-12 10:44:50','',''),(7588,'1','274','1',1,'Retail Sale Id 7400',3912.04,0.00,0.00,5.23,407.94,'2022-10-12 11:12:25','',''),(7589,'1','274','1',1,'Retail Sale Id 7401',9783.84,0.00,0.00,13.08,1020.24,'2022-10-12 11:13:23','',''),(7590,'1','274','1',1,'Retail Sale Id 7402',45628.00,0.00,0.00,61.00,4758.00,'2022-10-12 12:25:07','',''),(7591,'1','274','1',1,'Retail Sale Id 7403',12820.72,0.00,0.00,17.14,1336.92,'2022-10-12 12:38:44','',''),(7592,'1','274','1',1,'Retail Sale Id 7404',18700.00,0.00,0.00,25.00,1950.00,'2022-10-12 12:39:40','',''),(7593,'1','274','1',1,'Retail Sale Id 7405',2992.00,0.00,0.00,4.00,312.00,'2022-10-12 12:53:10','',''),(7594,'1','274','1',1,'Retail Sale Id 7405',9350.00,0.00,0.00,12.50,975.00,'2022-10-12 12:53:10','',''),(7595,'1','274','1',1,'Retail Sale Id 7406',2244.00,0.00,0.00,3.00,234.00,'2022-10-12 12:54:08','',''),(7596,'1','274','1',1,'Retail Sale Id 7407',1952.28,0.00,0.00,2.61,203.58,'2022-10-12 13:02:05','',''),(7597,'1','274','1',1,'Retail Sale Id 7408',22514.80,0.00,0.00,30.10,2347.80,'2022-10-12 13:08:29','',''),(7598,'1','274','1',1,'Retail Sale Id 7409',18700.00,0.00,0.00,25.00,1950.00,'2022-10-12 13:47:22','',''),(7599,'1','274','1',1,'Retail Sale Id 7410',1952.28,0.00,0.00,2.61,203.58,'2022-10-12 14:00:54','',''),(7600,'1','274','1',1,'Retail Sale Id 7411',9350.00,0.00,0.00,12.50,975.00,'2022-10-12 14:31:20','',''),(7601,'1','274','1',1,'Retail Sale Id 7412',17817.36,0.00,0.00,23.82,1857.96,'2022-10-12 14:36:11','',''),(7602,'1','274','1',1,'Retail Sale Id 7413',16837.48,0.00,0.00,22.51,1755.78,'2022-10-12 14:36:49','',''),(7603,'1','274','1',1,'Retail Sale Id 7414',11220.00,0.00,0.00,15.00,1170.00,'2022-10-12 14:56:19','',''),(7604,'1','274','1',1,'Retail Sale Id 7415',18700.00,0.00,0.00,25.00,1950.00,'2022-10-12 15:27:33','',''),(7605,'1','274','1',1,'Retail Sale Id 7416',9724.00,0.00,0.00,13.00,1014.00,'2022-10-12 16:09:08','',''),(7606,'1','274','1',1,'Retail Sale Id 7417',5183.64,0.00,0.00,6.93,540.54,'2022-10-12 16:19:15','',''),(7607,'1','274','1',1,'Retail Sale Id 7418',7480.00,0.00,0.00,10.00,780.00,'2022-10-12 16:27:06','',''),(7608,'1','274','1',1,'Retail Sale Id 7419',3740.00,0.00,0.00,5.00,390.00,'2022-10-12 16:43:45','',''),(7609,'1','274','1',1,'Retail Sale Id 7420',9350.00,0.00,0.00,12.50,975.00,'2022-10-12 16:48:04','',''),(7610,'1','274','1',1,'Retail Sale Id 7421',2244.00,0.00,0.00,3.00,234.00,'2022-10-12 16:58:46','',''),(7611,'1','274','1',1,'Retail Sale Id 7422',5998.96,0.00,0.00,8.02,625.56,'2022-10-12 17:14:43','',''),(7612,'1','274','1',1,'Retail Sale Id 7423',6298.16,0.00,0.00,8.42,656.76,'2022-10-12 17:33:35','',''),(7613,'1','274','1',1,'Retail Sale Id 7424',9350.00,0.00,0.00,12.50,975.00,'2022-10-12 17:39:02','',''),(7614,'1','274','1',1,'Retail Sale Id 7425',1002.32,0.00,0.00,1.34,104.52,'2022-10-12 18:17:15','',''),(7615,'1','274','1',1,'Retail Sale Id 7426',65330.32,0.00,0.00,87.34,6812.52,'2022-10-12 18:49:51','',''),(7616,'1','274','1',1,'Retail Sale Id 7427',28603.52,0.00,0.00,38.24,2982.72,'2022-10-12 18:50:49','',''),(7617,'1','274','1',1,'Retail Sale Id 7428',7480.00,0.00,0.00,10.00,780.00,'2022-10-13 07:14:52','',''),(7618,'1','274','1',1,'Retail Sale Id 7429',8003.60,0.00,0.00,10.70,834.60,'2022-10-13 07:15:40','',''),(7619,'1','274','1',1,'Retail Sale Id 7430',9350.00,0.00,0.00,12.50,975.00,'2022-10-13 09:05:50','',''),(7620,'1','274','1',1,'Retail Sale Id 7431',9350.00,0.00,0.00,12.50,975.00,'2022-10-13 09:09:44','',''),(7621,'1','274','1',1,'Retail Sale Id 7433',1002.32,0.00,0.00,1.34,104.52,'2022-10-13 09:19:32','',''),(7622,'1','274','1',1,'Retail Sale Id 7434',2251.48,0.00,0.00,3.01,234.78,'2022-10-13 09:26:46','',''),(7623,'1','274','1',1,'Retail Sale Id 7435',18700.00,0.00,0.00,25.00,1950.00,'2022-10-13 09:36:36','',''),(7624,'1','274','1',1,'Retail Sale Id 7436',2251.48,0.00,0.00,3.01,234.78,'2022-10-13 09:40:05','',''),(7625,'1','274','1',1,'Retail Sale Id 7437',36001.24,0.00,0.00,48.13,3754.14,'2022-10-13 10:07:47','',''),(7626,'1','274','1',1,'Retail Sale Id 7438',28050.00,0.00,0.00,37.50,2925.00,'2022-10-13 11:26:51','',''),(7627,'1','274','1',1,'Retail Sale Id 7439',7502.44,0.00,0.00,10.03,782.34,'2022-10-13 11:28:33','',''),(7628,'1','274','1',1,'Retail Sale Id 7440',14503.72,0.00,0.00,19.39,1512.42,'2022-10-13 11:30:36','',''),(7629,'1','274','1',1,'Retail Sale Id 7441',1997.16,0.00,0.00,2.67,208.26,'2022-10-13 11:34:14','',''),(7630,'1','274','1',1,'Retail Sale Id 7442',9350.00,0.00,0.00,12.50,975.00,'2022-10-13 11:35:32','',''),(7631,'1','274','1',1,'Retail Sale Id 7443',9350.00,0.00,0.00,12.50,975.00,'2022-10-13 11:39:16','',''),(7632,'1','274','1',1,'Retail Sale Id 7444',9350.00,0.00,0.00,12.50,975.00,'2022-10-13 11:43:45','',''),(7633,'1','274','1',1,'Retail Sale Id 7445',9350.00,0.00,0.00,12.50,975.00,'2022-10-13 12:27:12','',''),(7634,'1','274','1',1,'Retail Sale Id 7446',3747.48,0.00,0.00,5.01,390.78,'2022-10-13 12:44:33','',''),(7635,'1','274','1',1,'Retail Sale Id 7447',9350.00,0.00,0.00,12.50,975.00,'2022-10-13 13:21:42','',''),(7636,'1','274','1',1,'Retail Sale Id 7448',1503.48,0.00,0.00,2.01,156.78,'2022-10-13 13:25:54','',''),(7637,'1','274','1',1,'Retail Sale Id 7449',1503.48,0.00,0.00,2.01,156.78,'2022-10-13 13:26:38','',''),(7638,'1','274','1',1,'Retail Sale Id 7451',11347.16,0.00,0.00,15.17,1183.26,'2022-10-13 13:29:51','',''),(7639,'1','274','1',1,'Retail Sale Id 7452',4502.96,0.00,0.00,6.02,469.56,'2022-10-13 13:48:03','',''),(7640,'1','274','1',1,'Retail Sale Id 7453',9350.00,0.00,0.00,12.50,975.00,'2022-10-13 13:57:03','',''),(7641,'1','274','1',1,'Retail Sale Id 7454',9350.00,0.00,0.00,12.50,975.00,'2022-10-13 14:28:06','',''),(7642,'1','274','1',1,'Retail Sale Id 7455',4001.80,0.00,0.00,5.35,417.30,'2022-10-13 14:29:40','',''),(7643,'1','274','1',1,'Retail Sale Id 7456',2999.48,0.00,0.00,4.01,312.78,'2022-10-13 14:46:12','',''),(7644,'1','274','1',1,'Retail Sale Id 7457',9350.00,0.00,0.00,12.50,975.00,'2022-10-13 14:50:34','',''),(7645,'1','274','1',1,'Retail Sale Id 7458',1099.56,0.00,0.00,1.47,114.66,'2022-10-13 15:13:08','',''),(7646,'1','274','1',1,'Retail Sale Id 7459',1002.32,0.00,0.00,1.34,104.52,'2022-10-13 15:13:53','',''),(7647,'1','274','1',1,'Retail Sale Id 7460',2999.48,0.00,0.00,4.01,312.78,'2022-10-13 15:24:09','',''),(7648,'1','274','1',1,'Retail Sale Id 7461',1002.32,0.00,0.00,1.34,104.52,'2022-10-13 15:37:01','',''),(7649,'1','274','1',1,'Retail Sale Id 7462',1002.32,0.00,0.00,1.34,104.52,'2022-10-13 15:51:24','',''),(7650,'1','274','1',1,'Retail Sale Id 7463',9350.00,0.00,0.00,12.50,975.00,'2022-10-13 15:52:07','',''),(7651,'1','274','1',1,'Retail Sale Id 7464',2251.48,0.00,0.00,3.01,234.78,'2022-10-13 16:09:33','',''),(7652,'1','274','1',1,'Retail Sale Id 7465',1997.16,0.00,0.00,2.67,208.26,'2022-10-13 16:10:52','',''),(7653,'1','274','1',1,'Retail Sale Id 7466',11003.08,0.00,0.00,14.71,1147.38,'2022-10-13 16:12:28','',''),(7654,'1','274','1',1,'Retail Sale Id 7467',4001.80,0.00,0.00,5.35,417.30,'2022-10-13 16:20:49','',''),(7655,'1','274','1',1,'Retail Sale Id 7468',2251.48,0.00,0.00,3.01,234.78,'2022-10-13 16:23:55','',''),(7656,'1','274','1',1,'Retail Sale Id 7469',1997.16,0.00,0.00,2.67,208.26,'2022-10-13 16:36:52','',''),(7657,'1','274','1',1,'Retail Sale Id 7470',1997.16,0.00,0.00,2.67,208.26,'2022-10-13 16:39:26','',''),(7658,'1','274','1',1,'Retail Sale Id 7471',9350.00,0.00,0.00,12.50,975.00,'2022-10-13 16:45:38','',''),(7659,'1','274','1',1,'Retail Sale Id 7472',9350.00,0.00,0.00,12.50,975.00,'2022-10-13 16:46:44','',''),(7660,'1','274','1',1,'Retail Sale Id 7473',2999.48,0.00,0.00,4.01,312.78,'2022-10-13 16:50:17','',''),(7661,'1','274','1',1,'Retail Sale Id 7474',2251.48,0.00,0.00,3.01,234.78,'2022-10-13 16:55:55','',''),(7662,'1','274','1',1,'Retail Sale Id 7475',8998.44,0.00,0.00,12.03,938.34,'2022-10-13 16:59:16','',''),(7663,'1','274','1',1,'Retail Sale Id 7476',112200.00,0.00,0.00,150.00,11700.00,'2022-10-13 17:05:37','',''),(7664,'1','274','1',1,'Return of Retail Sale Id 7476',0.00,112200.00,150.00,0.00,-11700.00,'2022-10-13 17:13:02','',''),(7665,'1','274','1',1,'Retail Sale Id 7477',74800.00,0.00,0.00,100.00,7800.00,'2022-10-13 17:13:26','',''),(7666,'1','274','1',1,'Retail Sale Id 7478',37400.00,0.00,0.00,50.00,3900.00,'2022-10-13 17:14:02','',''),(7667,'1','274','1',1,'Retail Sale Id 7479',7502.44,0.00,0.00,10.03,782.34,'2022-10-13 17:23:00','',''),(7668,'1','274','1',1,'Retail Sale Id 7481',3747.48,0.00,0.00,5.01,390.78,'2022-10-13 17:37:41','',''),(7669,'1','274','1',1,'Retail Sale Id 7482',9350.00,0.00,0.00,12.50,975.00,'2022-10-13 17:39:14','',''),(7670,'1','274','1',1,'Retail Sale Id 7483',1503.48,0.00,0.00,2.01,156.78,'2022-10-13 18:00:16','',''),(7671,'1','274','1',1,'Retail Sale Id 7484',9350.00,0.00,0.00,12.50,975.00,'2022-10-13 18:05:24','',''),(7672,'1','274','1',1,'Retail Sale Id 7485',2251.48,0.00,0.00,3.01,234.78,'2022-10-13 18:10:14','',''),(7673,'1','274','1',1,'Retail Sale Id 7486',59840.00,0.00,0.00,80.00,6240.00,'2022-10-13 18:50:28','',''),(7674,'1','274','1',1,'Retail Sale Id 7487',76999.12,0.00,0.00,102.94,8029.32,'2022-10-13 18:51:15','',''),(7675,'1','274','1',1,'Retail Sale Id 7488',12716.00,0.00,0.00,17.00,1326.00,'2022-10-14 07:15:20','',''),(7676,'1','274','1',1,'Retail Sale Id 7489',4488.00,0.00,0.00,6.00,468.00,'2022-10-14 07:21:12','',''),(7677,'1','274','1',1,'Retail Sale Id 7490',9350.00,0.00,0.00,12.50,975.00,'2022-10-14 07:46:10','',''),(7678,'1','274','1',1,'Retail Sale Id 7490',10000.76,0.00,0.00,13.37,1042.86,'2022-10-14 07:46:10','',''),(7679,'1','274','1',1,'Retail Sale Id 7491',37400.00,0.00,0.00,50.00,3900.00,'2022-10-14 07:52:59','',''),(7680,'1','274','1',1,'Retail Sale Id 7492',9746.44,0.00,0.00,13.03,1016.34,'2022-10-14 08:05:40','',''),(7681,'1','274','1',1,'Retail Sale Id 7493',1997.16,0.00,0.00,2.67,208.26,'2022-10-14 08:22:56','',''),(7682,'1','274','1',1,'Retail Sale Id 7494',9350.00,0.00,0.00,12.50,975.00,'2022-10-14 08:24:46','',''),(7683,'1','274','1',1,'Retail Sale Id 7495',1997.16,0.00,0.00,2.67,208.26,'2022-10-14 08:26:05','',''),(7684,'1','274','1',1,'Retail Sale Id 7496',9350.00,0.00,0.00,12.50,975.00,'2022-10-14 08:33:52','',''),(7685,'1','274','1',1,'Retail Sale Id 7497',2999.48,0.00,0.00,4.01,312.78,'2022-10-14 08:34:45','',''),(7686,'1','274','1',1,'Retail Sale Id 7498',9350.00,0.00,0.00,12.50,975.00,'2022-10-14 08:36:04','',''),(7687,'1','274','1',1,'Retail Sale Id 7499',9350.00,0.00,0.00,12.50,975.00,'2022-10-14 08:41:58','',''),(7688,'1','274','1',1,'Retail Sale Id 7500',7502.44,0.00,0.00,10.03,782.34,'2022-10-14 08:47:03','',''),(7689,'1','274','1',1,'Retail Sale Id 7501',37400.00,0.00,0.00,50.00,3900.00,'2022-10-14 08:54:38','',''),(7690,'1','274','1',1,'Retail Sale Id 7502',4996.64,0.00,0.00,6.68,521.04,'2022-10-14 08:58:50','',''),(7691,'1','274','1',1,'Retail Sale Id 7503',14997.40,0.00,0.00,20.05,1563.90,'2022-10-14 09:08:21','',''),(7692,'1','274','1',1,'Retail Sale Id 7504',10000.76,0.00,0.00,13.37,1042.86,'2022-10-14 09:14:37','',''),(7693,'1','274','1',1,'Retail Sale Id 7505',24003.32,0.00,0.00,32.09,2503.02,'2022-10-14 09:16:57','',''),(7694,'1','274','1',1,'Retail Sale Id 7506',1002.32,0.00,0.00,1.34,104.52,'2022-10-14 09:33:38','',''),(7695,'1','274','1',1,'Retail Sale Id 7507',1997.16,0.00,0.00,2.67,208.26,'2022-10-14 09:34:24','',''),(7696,'1','274','1',1,'Retail Sale Id 7508',8998.44,0.00,0.00,12.03,938.34,'2022-10-14 09:39:10','',''),(7697,'1','274','1',1,'Retail Sale Id 7509',11601.48,0.00,0.00,15.51,1209.78,'2022-10-14 09:55:11','',''),(7698,'1','274','1',1,'Retail Sale Id 7510',20996.36,0.00,0.00,28.07,2189.46,'2022-10-14 09:57:36','',''),(7699,'1','274','1',1,'Retail Sale Id 7511',37400.00,0.00,0.00,50.00,3900.00,'2022-10-14 10:00:19','',''),(7700,'1','274','1',1,'Retail Sale Id 7512',1503.48,0.00,0.00,2.01,156.78,'2022-10-14 10:04:34','',''),(7701,'1','274','1',1,'Retail Sale Id 7513',7801.64,0.00,0.00,10.43,813.54,'2022-10-14 10:16:25','',''),(7702,'1','274','1',1,'Retail Sale Id 7514',8998.44,0.00,0.00,12.03,938.34,'2022-10-14 10:17:19','',''),(7703,'1','274','1',1,'Retail Sale Id 7515',9350.00,0.00,0.00,12.50,975.00,'2022-10-14 10:38:26','',''),(7704,'1','274','1',1,'Retail Sale Id 7516',2251.48,0.00,0.00,3.01,234.78,'2022-10-14 10:43:02','',''),(7705,'1','274','1',1,'Retail Sale Id 7517',9350.00,0.00,0.00,12.50,975.00,'2022-10-14 10:44:40','',''),(7706,'1','274','1',1,'Retail Sale Id 7518',37400.00,0.00,0.00,50.00,3900.00,'2022-10-14 10:51:17','',''),(7707,'1','274','1',1,'Retail Sale Id 7519',9350.00,0.00,0.00,12.50,975.00,'2022-10-14 11:16:44','',''),(7708,'1','274','1',1,'Retail Sale Id 7520',46750.00,0.00,0.00,62.50,4875.00,'2022-10-14 11:18:55','',''),(7709,'1','274','1',1,'Retail Sale Id 7521',9350.00,0.00,0.00,12.50,975.00,'2022-10-14 11:20:37','',''),(7710,'1','274','1',1,'Retail Sale Id 7522',43010.00,0.00,0.00,57.50,4485.00,'2022-10-14 11:23:35','',''),(7711,'1','274','1',1,'Retail Sale Id 7523',4502.96,0.00,0.00,6.02,469.56,'2022-10-14 11:26:44','',''),(7712,'1','274','1',1,'Retail Sale Id 7524',9350.00,0.00,0.00,12.50,975.00,'2022-10-14 11:30:10','',''),(7713,'1','274','1',1,'Retail Sale Id 7525',2251.48,0.00,0.00,3.01,234.78,'2022-10-14 11:38:36','',''),(7714,'1','274','1',1,'Retail Sale Id 7526',9350.00,0.00,0.00,12.50,975.00,'2022-10-14 11:39:22','',''),(7715,'1','274','1',1,'Retail Sale Id 7527',8302.80,0.00,0.00,11.10,865.80,'2022-10-14 11:42:12','',''),(7716,'1','274','1',1,'Retail Sale Id 7529',4502.96,0.00,0.00,6.02,469.56,'2022-10-14 11:54:11','',''),(7717,'1','274','1',1,'Retail Sale Id 7530',2251.48,0.00,0.00,3.01,234.78,'2022-10-14 12:07:00','',''),(7718,'1','274','1',1,'Retail Sale Id 7531',9350.00,0.00,0.00,12.50,975.00,'2022-10-14 12:14:21','',''),(7719,'1','274','1',1,'Retail Sale Id 7532',1002.32,0.00,0.00,1.34,104.52,'2022-10-14 14:07:05','',''),(7720,'1','274','1',1,'Retail Sale Id 7533',63954.00,0.00,0.00,85.50,6669.00,'2022-10-14 14:16:36','',''),(7721,'1','274','1',1,'Retail Sale Id 7534',2999.48,0.00,0.00,4.01,312.78,'2022-10-14 14:17:23','',''),(7722,'1','274','1',1,'Return of Retail Sale Id 7522',0.00,43010.00,57.50,0.00,-4485.00,'2022-10-14 14:18:43','',''),(7723,'1','274','1',1,'Retail Sale Id 7535',1368.84,0.00,0.00,1.83,142.74,'2022-10-14 14:20:51','',''),(7724,'1','274','1',1,'Retail Sale Id 7536',703.12,0.00,0.00,0.94,73.32,'2022-10-14 14:40:28','',''),(7725,'1','274','1',1,'Retail Sale Id 7537',9350.00,0.00,0.00,12.50,975.00,'2022-10-14 14:52:22','',''),(7726,'1','274','1',1,'Retail Sale Id 7538',9350.00,0.00,0.00,12.50,975.00,'2022-10-14 14:55:14','',''),(7727,'1','274','1',1,'Retail Sale Id 7539',2251.48,0.00,0.00,3.01,234.78,'2022-10-14 14:59:09','',''),(7728,'1','274','1',1,'Retail Sale Id 7540',24003.32,0.00,0.00,32.09,2503.02,'2022-10-14 15:09:58','',''),(7729,'1','274','1',1,'Retail Sale Id 7541',4996.64,0.00,0.00,6.68,521.04,'2022-10-14 16:24:01','',''),(7730,'1','274','1',1,'Retail Sale Id 7542',7001.28,0.00,0.00,9.36,730.08,'2022-10-14 16:35:22','',''),(7731,'1','274','1',1,'Retail Sale Id 7543',10000.76,0.00,0.00,13.37,1042.86,'2022-10-14 16:37:22','',''),(7732,'1','274','1',1,'Retail Sale Id 7544',4502.96,0.00,0.00,6.02,469.56,'2022-10-14 16:38:45','',''),(7733,'1','274','1',1,'Retail Sale Id 7545',20001.52,0.00,0.00,26.74,2085.72,'2022-10-14 16:45:53','',''),(7734,'1','274','1',1,'Retail Sale Id 7546',8998.44,0.00,0.00,12.03,938.34,'2022-10-14 16:53:02','',''),(7735,'1','274','1',1,'Retail Sale Id 7547',13852.96,0.00,0.00,18.52,1444.56,'2022-10-14 16:57:47','',''),(7736,'1','274','1',1,'Retail Sale Id 7548',3246.32,0.00,0.00,4.34,338.52,'2022-10-14 17:01:19','',''),(7737,'1','274','1',1,'Retail Sale Id 7550',8250.44,0.00,0.00,11.03,860.34,'2022-10-14 17:04:00','',''),(7738,'1','274','1',1,'Return of Retail Sale Id 7545',0.00,20001.52,26.74,0.00,-2085.72,'2022-10-14 17:23:37','',''),(7739,'1','274','1',1,'Return of Retail Sale Id 7547',0.00,13852.96,18.52,0.00,-1444.56,'2022-10-14 17:24:09','',''),(7740,'1','274','1',1,'Retail Sale Id 7551',10255.08,0.00,0.00,13.71,1069.38,'2022-10-14 17:25:06','',''),(7741,'1','274','1',1,'Retail Sale Id 7552',30353.84,0.00,0.00,40.58,3165.24,'2022-10-14 17:26:00','',''),(7742,'1','274','1',1,'Retail Sale Id 7553',2999.48,0.00,0.00,4.01,312.78,'2022-10-14 17:49:43','',''),(7743,'1','274',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,2673300.00,3990.00,0.00,0.00,'2022-10-16 06:04:20','',''),(7744,'1','274',NULL,1,'Reception corrector for bridging 61',0.00,0.00,0.00,3900.00,0.00,'2022-10-16 06:05:46','',''),(7745,'1','274','1',1,'Received from bridging 61',0.00,0.00,3900.00,0.00,0.00,'2022-10-16 06:05:46','',''),(7746,'1','274','1',1,'Retail Sale Id 7554',5984.00,0.00,0.00,8.00,624.00,'2022-10-16 06:41:03','',''),(7747,'1','274','1',1,'Retail Sale Id 7555',18700.00,0.00,0.00,25.00,1950.00,'2022-10-16 07:52:17','',''),(7748,'1','274','1',1,'Retail Sale Id 7556',3740.00,0.00,0.00,5.00,390.00,'2022-10-16 07:53:14','',''),(7749,'1','274','1',1,'Retail Sale Id 7557',74800.00,0.00,0.00,100.00,7800.00,'2022-10-16 09:16:05','',''),(7750,'1','274','1',1,'Retail Sale Id 7558',2498.32,0.00,0.00,3.34,260.52,'2022-10-16 09:18:42','',''),(7751,'1','274','1',1,'Retail Sale Id 7559',9499.60,0.00,0.00,12.70,990.60,'2022-10-16 09:19:51','',''),(7752,'1','274','1',1,'Retail Sale Id 7560',4502.96,0.00,0.00,6.02,469.56,'2022-10-16 09:20:35','',''),(7753,'1','274','1',1,'Retail Sale Id 7561',9350.00,0.00,0.00,12.50,975.00,'2022-10-16 09:23:08','',''),(7754,'1','274','1',1,'Retail Sale Id 7562',703.12,0.00,0.00,0.94,73.32,'2022-10-16 09:25:45','',''),(7755,'1','274','1',1,'Retail Sale Id 7563',1002.32,0.00,0.00,1.34,104.52,'2022-10-16 09:27:02','',''),(7756,'1','274','1',1,'Retail Sale Id 7564',3740.00,0.00,0.00,5.00,390.00,'2022-10-16 09:31:28','',''),(7757,'1','274','1',1,'Retail Sale Id 7565',1997.16,0.00,0.00,2.67,208.26,'2022-10-16 09:33:09','',''),(7758,'1','274','1',1,'Retail Sale Id 7566',2296.36,0.00,0.00,3.07,239.46,'2022-10-16 09:47:01','',''),(7759,'1','274','1',1,'Retail Sale Id 7567',1997.16,0.00,0.00,2.67,208.26,'2022-10-16 09:48:10','',''),(7760,'1','274','1',1,'Retail Sale Id 7568',74800.00,0.00,0.00,100.00,7800.00,'2022-10-16 09:51:13','',''),(7761,'1','274','1',1,'Retail Sale Id 7569',1002.32,0.00,0.00,1.34,104.52,'2022-10-16 09:53:25','',''),(7762,'1','274','1',1,'Retail Sale Id 7570',9499.60,0.00,0.00,12.70,990.60,'2022-10-16 09:59:21','',''),(7763,'1','274','1',1,'Retail Sale Id